﻿USE sofia;
DROP TABLE IF EXISTS sofia.poiNT_vpl;
CREATE TABLE poiNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES poiNT_vpl WRITE;
INSERT INTO poiNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jaycámneta̱ yɨɨm jém lista de jém Jesucristo ija̱tuŋwe̱we jém wiñɨcpɨcyaj. Jém Jesucristo jém David io̱cma̱nɨc y jém Abraham io̱cma̱nɨc. ");
INSERT INTO poiNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Jém Abraham ima̱nɨc jém Isaac. Jém Isaac ima̱nɨc jém Jacob. Jém Jacob ima̱nɨc jém Judá con it́ɨ̱wɨtam. ");
INSERT INTO poiNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Jém Judá ima̱nɨc jém Fares y Zara, ia̱pa jém Tamar. Jém Fares ima̱nɨc jém Erson. Jém Erson ima̱nɨc jém Aram. ");
INSERT INTO poiNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Jém Aram ima̱nɨc jém Aminadab. Jém Aminadab ima̱nɨc jém Naasón. Jém Naasón ima̱nɨc jém Salmón. ");
INSERT INTO poiNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Jém Salmón ima̱nɨc jém Booz, ia̱pa jém Rahab. Jém Booz ima̱nɨc jém Obed, ia̱pa jém Rut. Jém Obed ima̱nɨc jém Isaí. ");
INSERT INTO poiNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jém Isaí ima̱nɨc jém rey David. Jém rey David ima̱nɨc jém Salomón, jém ia̱pa jém Urías iyo̱mo id́ɨc. ");
INSERT INTO poiNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Jém Salomón ima̱nɨc jém Roboam. Jém Roboam ima̱nɨc jém Abías. Jém Abías ima̱nɨc jém Asa. ");
INSERT INTO poiNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Jém Asa ima̱nɨc jém Josafat. Jém Josafat ima̱nɨc jém Joram. Jém Joram ima̱nɨc jém Uzías. ");
INSERT INTO poiNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Jém Uzías ima̱nɨc jém Jotam. Jém Jotam ima̱nɨc jém Acaz. Jém Acaz ima̱nɨc jém Ezequías. ");
INSERT INTO poiNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Jém Ezequías ima̱nɨc jém Manasés. Jém Manasés ima̱nɨc jém Amón. Jém Amón ima̱nɨc jém Josías. ");
INSERT INTO poiNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jém Josías ima̱nɨc jém Jeconías con it́ɨ̱wɨtam. Jeet́im tiempo cuando nanɨcyajta̱ preso it́u̱mpɨy jém Israelpɨc pɨxiñt́am hasta jém naxyucmɨ de Babilonia. ");
INSERT INTO poiNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Jesɨc cuando nanɨcneyajta̱wum jém naxyucmɨ de Babilonia jém Jeconías ima̱nɨc jém Salatiel. Jém Salatiel ima̱nɨc jém Zorobabel. ");
INSERT INTO poiNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Jém Zorobabel ima̱nɨc jém Abiud. Jém Abiud ima̱nɨc jém Eliaquim. Jém Eliaquim ima̱nɨc jém Azor. ");
INSERT INTO poiNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Jém Azor ima̱nɨc jém Sadoc. Jém Sadoc ima̱nɨc jém Aquim. Jém Aquim ima̱nɨc jém Eliud. ");
INSERT INTO poiNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Jém Eliud ima̱nɨc jém Eleazar. Jém Eleazar ima̱nɨc jém Matán. Jém Matán ima̱nɨc jém Jacob. ");
INSERT INTO poiNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jém Jacob ima̱nɨc jém José, jém Malía iwɨd́a̱ya jém icnayñewɨɨp jém Jesús, iñɨ̱yit́im CRISTO. ");
INSERT INTO poiNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Jesɨc it́ catorce jém Abraham io̱cma̱nɨctam hasta David. It́t́im catorce jém David io̱cma̱nɨctam hasta cuando mu ininɨcyajta̱ preso jém Israelpɨc pɨxiñt́am jém naxyucmɨ de Babilonia. It́t́im catorce jém Jeconías io̱cma̱nɨctam dende nanɨcyajta̱ preso jém naxyucmɨ de Babilonia hasta cuando mu iñay jém Cristo. ");
INSERT INTO poiNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesɨc yɨɨmpɨc nay jém Jesucristo. Cuando jém José iniwatneum trato jém wo̱ñi Malía iga napɨcyajta̱p, antes que d́anam napɨcneyajta̱, ma̱nɨccomcaneum jém Malía con Dios iA̱nama ipɨ̱mi. D́a je jém José ima̱nɨc. ");
INSERT INTO poiNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Jesɨc jém José, jém iwatnewɨɨp trato jém Malía iga napɨcyajta̱p, como wɨbɨc pɨ̱xiñ, d́a ichaawattooba jém Malía. Jeeyucmɨ iyamtsactooba jém wo̱ñi iga jém pɨxiñt́am odoy ijo̱dóŋa̱yajiñ. ");
INSERT INTO poiNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Jesɨc iganam ijɨ̱spa je̱mpɨc jém José, ima̱wíñix tu̱m sɨŋyucmɨpɨc pɨ̱xiñ jém icutsatnewɨɨp Dios. Iñɨ́máy jém José: —MiJosé, jém rey David mio̱cma̱nɨc, odoy cɨ̱ŋɨ iga impɨctsoŋpa jém Malía. Porque jém ima̱nɨc, jém ijúmpacnewɨɨp, inimiñ jém Dios iA̱nama. ");
INSERT INTO poiNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Jém wo̱ñi icnaypa tu̱m jaychɨ̱xi. Accámaayɨ iñɨ̱yi iga JESÚS porque icɨacputpa jém ipɨxiñt́am, iwɨ̱tsagáypa jém it́áŋca iga odoy ipɨctsoŋyajiñ jém castigo. ");
INSERT INTO poiNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Je̱mpɨgam iñasca jém Malía iga cupaguiñ juuts nɨmpa jém wiñɨcpɨc aŋmat́cɨɨwiñ jém ipɨɨmɨyñewɨɨp jém tanJa̱tuŋ Dios iga iŋmad́iñ. Nɨmyajpa: ");
INSERT INTO poiNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ma̱nɨccomca tu̱m wo̱ñi jém d́apɨc jaayɨ́y. D́a queman ijɨypát pɨ̱xiñ. Icnaypa tu̱m jaychɨ̱xi. Accámayt́a̱p iñɨ̱yi iga Emanuel. Taɨcht́am tanaŋmat́i̱mɨ nɨmtooba: taŋwaganait́t́ámpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Jesɨc cuando yus jém José iwat juuts iñɨ́máy jém sɨŋyucmɨpɨc pɨ̱xiñ jém icutsatnewɨɨp jém tanJa̱tuŋ Dios. Ipɨctsoŋ jém Malía. ");
INSERT INTO poiNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pero d́a inimoŋ hasta que icnay jém ico̱ponma̱nɨc tu̱m jaychɨ̱xi. Jesɨc jém José iccámáy iñɨ̱yi iga Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Nay Jesús jém attebet Belén jém naxyucmɨ de Judea cuando iŋjacpa jém rey Herodes. Jesɨc jeet́im tiempo núcyaj Jerusalén jém sabioyaj. Miñyaj aŋja̱mquímmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Mu iñúcyaj, acwágoyyajpa. Nɨmyaj: —¿Ju̱t́ it́ jém tsɨ̱xi jém nayñewɨɨp, jém tsɨ́ypáppɨc juuts Rey iga iŋjacpa jém judíos? Ánixayt́a ima̱tsa jém aŋja̱mquímmɨ. Amiññeta iga aco̱steeñayt́ámpa y anjɨ̱stámpa. ");
INSERT INTO poiNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Jesɨc cuando jém rey Herodes ijo̱dóŋa̱ t́i iñɨ́máy jém juumɨpɨc pɨ̱xiñ, agui cɨ̱ŋ, d́a icutɨɨyɨ́y t́i iwatpa. Cɨ̱ŋyajt́im jém pɨxiñt́am jém it́yajwɨɨp jém attebet Jerusalén. ");
INSERT INTO poiNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Jesɨc jém Herodes iŋtuuma̱wat it́u̱mpɨy jém co̱bacpɨc pa̱nij aŋjagooyiyaj con jém escribaspɨc maestroyaj. Jém Herodes icwácpa jém pa̱nij aŋjagooyi ju̱t́ naypa jém Cristo. ");
INSERT INTO poiNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Jeeyaj iñɨ́mayyaj jém Herodes: —Naypa jém attebet Belén jém naxyucmɨ de Judea porque je̱mpɨgam ijaychacne jém wiñɨcpɨc aŋmat́cɨɨwiñ. Nɨmpa Dios: ");
INSERT INTO poiNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Mich miattebet Belén, miit́wɨɨp jém naxyucmɨ de Judá, agui mixut́u, pero michɨ́ypa juuts tu̱m mɨjpɨc attebet porque mimicht́ámaŋjo̱m naypa tu̱m mɨjpɨc aŋjagooyi. Iwatpa cuenta jém ampɨxiñt́am jém attebet Israel. ");
INSERT INTO poiNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Jesɨc jém Herodes iyámaŋwejáy jém sabioyaj. Icwác iga juchɨs moj iixyaj jém ma̱tsa. ");
INSERT INTO poiNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Jesɨc ocmɨ jém Herodes icutsat jém sabioyaj jém attebet Belén. Nɨmpa: —Nɨctaamɨ jemɨc. Wɨ̱métstaamɨ jém tsɨ̱xi. Jesɨc cuando impátnetámum, mi̱ñɨ acjo̱dóŋa̱jɨ. Ɨch nɨcpat́im aŋco̱steeñáy. ");
INSERT INTO poiNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Jesɨc cuando yaj imatoŋyaj t́i nɨmpa jém rey Herodes, moj nɨquiyaj jém Belén. Aŋjagoyñeeba iñɨc jém ma̱tsa jém iixñeyajwɨɨp aŋja̱mquímmɨ. Núc ju̱t́ it́ jém xut́u tsɨ̱xi, jemum teeñaŋjac. ");
INSERT INTO poiNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Cuando iixyaj jém ma̱tsa ju̱t́ teeñaŋjac, tsa̱m pɨ̱mi maymayyaj. ");
INSERT INTO poiNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Jesɨc cuando tɨgɨyyaj jém tɨcjo̱m, iixyaj jém jaychɨ̱xi con ia̱pa Malía. Jém sabio ico̱steeñayyaj jém tsɨ̱xi. Ijɨ̱syajpa. Íŋáy jém ibaúl, ixaɨyyajpa oro, jém wɨbɨc incienso y jém mirra jém aguipɨc cɨ̱npa. ");
INSERT INTO poiNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ocmɨ Dios icma̱wíña̱ jém sabioyaj iga odom nɨcyajiñ e̱ybɨc ju̱t́ it́ jém Herodes. Pɨɨmɨyt́a̱ iga se̱d́iñ tuŋgac tuŋjo̱m hasta núcpa it́ɨcmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Jesɨc ocmɨ mu iñɨcyajum jém sabio, jém José ima̱wíñix tu̱m sɨŋyucmɨpɨc pɨ̱xiñ jém Diospɨc icutsatne. Iñɨ́máy jém José: —Napo̱yɨ jém xut́u tsɨ̱xi con ia̱pa. Nɨctaamɨ jém naxyucmɨ de Egipto. Jemum tsɨ́yt́aamɨ hasta que ɨch mannɨ́máypa iga mixe̱d́iñ porque jém Herodes imétspa jém xut́u tsɨ̱xi iga iccaaba. ");
INSERT INTO poiNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Jesɨc tsucum jém José con jém Malía. Inipoyyaj jém xut́u tsɨ̱xi tsuucɨɨm. Nɨcyaj jém naxyucmɨ de Egipto. ");
INSERT INTO poiNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Jemɨgam tsɨ́yyaj hasta que ca jém Herodes. Iñasca je̱mpɨc iga cupaguiñ juuts iñɨ́máy Dios jém wiñɨcpɨc aŋmat́cɨɨwiñ: “Ɨch anaŋwejáypa amma̱nɨc jém naxyucmɨ de Egipto.” ");
INSERT INTO poiNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Jesɨc tsa̱m jóy jém Herodes mu iix iga jém sabio d́a icupɨcyaj juuts iñɨ́máy. Ipɨɨmɨ́y jém isoldado iga iccucaayyajiñ it́u̱mpɨy jém jaychɨ̱xt́am jém it́yajwɨɨp Belén con jém it́yajwɨɨp nocojo̱m. Ijɨ̱sne jutsaŋ mayooyi oyñe iámyaj jém sabioyaj jém tsɨ̱xi. Jeeyucmɨ iccucaayyaj it́u̱mpɨy jém iniit́wɨɨp dos a̱mt́ɨy hasta jém d́apɨc núcne dos a̱mt́ɨy. ");
INSERT INTO poiNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Je̱mpɨgam cupac jém aŋma̱t́i juuts ijaychacne jém wiñɨcpɨc aŋmat́cɨɨwiñ jém Jeremías. Nɨmpa: ");
INSERT INTO poiNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Matoŋta̱p tu̱m jɨ̱yi jém attebet Ramá. Tsa̱m wejyajpa, tsa̱m aŋyácneyaj. Tsa̱m wejyajpa jém Raquel, jém Israelpɨc yo̱mtam, iyaachaŋja̱mpa jém ima̱nɨctam. D́a ixunpa iga acpocsayt́a̱p ia̱nama porque accucaáyayyajt́a̱ ima̱nɨctam. ");
INSERT INTO poiNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Jesɨc ocmɨ cuando caaneum jém Herodes, tanJa̱tuŋ Dios icutsat tu̱m sɨŋyucmɨpɨc pɨ̱xiñ iga icma̱wíña̱iñ jém José jém naxyucmɨ de Egipto, nɨ́mayt́a̱: ");
INSERT INTO poiNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Sɨɨp se̱ttaamɨ jém iñt́ɨcmɨ Israel. Nase̱tɨ jém jaychɨ̱xi con ia̱pa. Porque sɨɨp caaneum jém aŋjagooyi jém iccaapáppɨc id́ɨc jém xut́u tsɨ̱xi. ");
INSERT INTO poiNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Jesɨc mojum se̱t́i jém José. Inise̱tpa jém xut́u tsɨ̱xi con ia̱pa jém naxyucmɨ de Israel. ");
INSERT INTO poiNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pero tsa̱m cɨ̱ŋ jém José iga nɨcpa jém naxyucmɨ de Judea porque ijo̱dóŋa̱ iga jém Herodes ima̱nɨc jém Arquelao iŋjacpa jém naxyucmɨ Judea ju̱t́ iŋjacpa id́ɨc jém ija̱tuŋ. Jém José ma̱wíña̱ iga odoy nɨguiñ Judea. Ijɨ̱spa iga nɨcpa jém naxyucmɨ de Galilea. ");
INSERT INTO poiNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Jesɨc núc jém Galilea, nɨc i̱t́i jém attebet Nazaret. Iñasca je̱mpɨc iga cupacpa juuts nɨm jém wiñɨcpɨc aŋmat́cɨɨwiñ iga Nazaretpɨc pɨ̱xiñ jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Núc jém ja̱ma iga moj najɨ́yooyi jém Xiwan jém acchíŋoypáppɨc. Najɨ́yóypa jém tɨtsɨnaxyucmɨ ju̱t́ d́a t́i id́ɨ́yɨ́y, jém naxyucmɨ de Judea. ");
INSERT INTO poiNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Nɨm jém Xiwan: —Tsa̱cɨ iga immalwatpa, cuca̱cɨ iñjɨ̱xi porque núctooba jém tiempo iga iŋjacpa Dios yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jém wiñɨcpɨc aŋmat́cɨɨwiñ jém Isaías iŋmat de yɨ́pt́im Xiwan. Nɨmpa: Matoŋta̱p tu̱m aŋmat́cɨɨwiñ jém tsa̱mpɨc najɨ́yóypa jém tɨtsɨnaxyucmɨ. Nɨmpa iga: “Wɨ̱tsagaayɨ jém tánO̱mi it́uŋ. Áŋaayɨ tu̱m tuŋ nu̱mapɨc.” ");
INSERT INTO poiNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jém Xiwan iyoot́i tacne con jém camello ipɨc. Jém icinturón tu̱m tsococuero. Icútpa jém a̱wu. Iucpa jém jɨmñi chi̱ñu. ");
INSERT INTO poiNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Tsa̱m jáyaŋ pɨxiñt́am nɨc imatoŋyaj jém Xiwan ju̱t́ najɨ́yóypa. Miñyaj jém attebet Jerusalén, icuwɨ̱t́i jém naxyucmɨ de Judea, con jém it́yajwɨɨp nocojo̱m jém río Jordán. ");
INSERT INTO poiNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Jém pɨxiñt́am iŋmadayyajpa Dios it́áŋca iga agui imalwatne. Ocmɨ jém Xiwan icchiŋpa jém río de Jordán. ");
INSERT INTO poiNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Jesɨc cuando jém Xiwan iix iga chiŋtooba wa̱t́i jém fariseopɨc pɨxiñt́am y jém saduceopɨc pɨxiñt́am, iñɨ́máy: —¿Que micht́am impóyayt́ámpat́im jém Dios icastigo? ¿Que iŋcupɨcpa iga ɨch wɨa̱p maŋcɨacputta? Mijex juuts jém tsa̱ñ agui poypa cuando miñpa jém iccaapáppɨc. ");
INSERT INTO poiNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Siiga nu̱ma iñchacneum jém immalajɨ̱xi, jesɨc wa̱tɨ juuts ixunpa Dios, jesɨc quejpa iga nu̱ma iŋcucacneum iñjɨ̱xi. ");
INSERT INTO poiNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Odoy jɨ̱staamɨ íña̱namaŋjo̱m iga mimicht́am tsa̱m wɨbɨc mipɨxiñt́am d́a mimalotam porque jém Abraham mima̱nɨctam. D́a wɨ̱ iga iñjɨ̱stámpa je̱mpɨc porque Dios wɨa̱p icse̱t yɨ́p tsa juuts jém Abraham ima̱nɨctam. ");
INSERT INTO poiNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Wɨ̱tsacneum jém hacha. Accámneta̱wum jém cuyt́i̱chɨcyucmɨ. It́u̱mpɨy cuy d́apɨc tɨ́ma̱p, tɨŋquímta̱p, nooquetta̱p juctjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ɨch nu̱ma manacchiŋpa con nɨ iga quejiñ iga iñchacneum iga immalwatpa. Pero ocmɨ miñpa tuŋgac pɨ̱xiñ antuuñiaŋcɨɨm. Je más wɨa̱p que aɨch. D́a wɨa̱p annasca. D́a wɨa̱p aŋcuwijáyáy jém icɨac. Micchiŋpa con Dios iA̱nama y con juctɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Imatspacneum jém iyemcuy iga icutɨ̱ppa jém trigo. Cuando yajum icutɨ̱p, iccáypa jém trigo granerojo̱m. Nooquetta̱p jém trigo ipu̱chi juctjo̱m ju̱t́ d́a nunca píchpa. ");
INSERT INTO poiNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jesɨc Jesús put jém naxyucmɨ de Galilea. Nɨc jém río de Jordán iga icchíŋiñ jém Xiwan jém acchíŋoypaap. ");
INSERT INTO poiNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Pero jém Xiwan d́a icchiŋtooba Jesús. Nɨ́mayt́a̱ Jesús: —Más wɨ̱ iga mich anacchiŋpa aɨch. ¿T́iiga mimiñpa iga manacchíŋiñ? ");
INSERT INTO poiNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesɨc Jesús icutsoŋ. Iñɨ́máy jém Xiwan: —Pero sɨɨp wɨ̱ iga anacchiŋpa. Wɨ̱ iga tanaccupacpa it́u̱mpɨy juuts tapɨɨmɨ́y Dios. Jesɨc jém Xiwan icchiŋ. ");
INSERT INTO poiNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Cuando yajum icchiŋta̱ jém Jesús, put jém nɨɨcɨɨm. Jesɨc áŋáy jém sɨŋ, Jesús iix jém Dios iA̱nama. Quet juuts tu̱m cuucu. Nu̱mmiñ, núc Jesúsyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Jesɨc jém it́yajwɨɨp je̱m imatoŋyaj tu̱m jɨ̱yi sɨŋyucmɨ. Nɨmpa: —Yɨ́p ɨch amMa̱nɨc jém tsa̱mpɨc antoypa. Tsa̱m amaymay con je. ");
INSERT INTO poiNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ocmɨ jém Dios iA̱nama ininɨc Jesús jém tɨtsɨnaxyucmɨ ju̱t́ d́a t́i id́ɨ́yɨ́y. Nanɨcta̱ iga icutɨ́chiñ jém Woccɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","D́a wíc Jesús cuarenta ja̱ma y cuarenta tsuu. Jesɨc ocmɨ tsa̱m pɨ̱mi yua̱p. ");
INSERT INTO poiNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Jesɨc jém Woccɨɨwiñ icunúc Jesús iga icutɨ́tspa. Iñɨ́máy: —Siiga nu̱ma Dios miMa̱nɨc, acse̱tɨ yɨ́p tsa iga caxt́ána̱ñi. ");
INSERT INTO poiNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesɨc Jesús iñɨ́máy jém Woccɨɨwiñ: —Nɨmpa jém Dios iŋma̱t́i jém jayñewɨɨp: “Jém pɨxiñt́am d́a it́pa no más con jém caxt́ána̱ñi iga icútpa. Wɨ̱it́pa jém pɨ̱xiñ siiga iwatpa it́u̱mpɨy juuts iñɨ́máy Dios.” ");
INSERT INTO poiNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Jesɨc jém Woccɨɨwiñ ininɨc Jesús jém attebet Jerusalén. Iniquím jém mɨjpɨc ma̱stɨcaŋco̱bac. ");
INSERT INTO poiNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Jesɨc jém Woccɨɨwiñ iñɨ́máy Jesús: —Siiga nu̱ma Dios miMa̱nɨc, yóyaŋque̱tɨ. Porque nɨmpa jém Dios iŋma̱t́i: Dios icutsat jém sɨŋyucmɨpɨc pɨxiñt́am iga mimatstsoŋyajiñ icɨɨjo̱m iga odoy coowa̱iñ impuy tsaayucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesɨc Jesús iñɨ́máy jém Woccɨɨwiñ: —Nɨmpat́im jém Dios iŋma̱t́i: “Odoy cutɨɨtsɨ jém tanJa̱tuŋ Dios siiga nu̱ma wɨa̱p.” ");
INSERT INTO poiNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Jesɨc jém Woccɨɨwiñ e̱ybɨc icutɨ́tspa jém Jesús. Ininɨc tu̱m mɨjpɨc co̱tsɨcyucmɨ tsa̱m yucmɨ. Iŋquejáy it́u̱mpɨy jém attebetyaj icuwɨ̱t́i yɨ́p naxyucmɨ iga tsa̱m wɨbɨc lugar. ");
INSERT INTO poiNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Jém Woccɨɨwiñ iñɨ́máy Jesús: —Manchiiba it́u̱mpɨy yɨɨmpɨc manaŋquejáy siiga aŋco̱steeñáypa y anjɨ̱spa. ");
INSERT INTO poiNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jesɨc Jesús iñɨ́máy: —Nɨcsɨm, miWoccɨɨwiñ. Nɨmpa jém Dios iŋma̱t́i: “Jɨ̱staamɨ tanJa̱tuŋ Dios icut́um. Odoy cuyo̱xataamɨ tuŋgac.” ");
INSERT INTO poiNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Jesɨc nɨc jém Woccɨɨwiñ. Ichac iga icutɨ́tspa Jesús. Jesɨc miñyaj jém sɨŋyucmɨpɨc pɨxiñt́am iga iyo̱xpátyajpa. ");
INSERT INTO poiNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jesɨc cuando Jesús imatoŋ iga pajta̱ cárcel jém Xiwan, se̱t e̱ybɨc jém naxyucmɨ de Galilea. ");
INSERT INTO poiNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","D́a tsɨ́y jém attebet Nazaret. Nɨc i̱t́i jém attebet Capernaum jém laguna aŋna̱ca jém naxyucmɨ de Zabulón y Neftalí. ");
INSERT INTO poiNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Iñasca je̱mpɨc iga cupacpa jém aŋma̱t́i juuts ijaychacne jém wiñɨcpɨc aŋmat́cɨɨwiñ jém Isaías. Nɨmpa: ");
INSERT INTO poiNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Jém naxyucmɨ de Zabulón con jém naxyucmɨ de Neftalí dende jém lamar aŋna̱ca hasta jém Jordán iŋwiñt́uc, jém naxyucmɨ de Galilea, ju̱t́ it́yaj jém pɨxiñt́am jém d́apɨc je de Israel, ");
INSERT INTO poiNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","jém it́yajwɨɨp piichcɨɨm; iixyajpa tu̱m wɨbɨc juctɨaŋtso̱ca. Tsɨ́yyaj juuts caaneyaj id́ɨc. Cupiicha̱ne i̱t́i, pero iyɨcquejyajpa tu̱m wɨbɨc juctɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Jesɨc cuando núc jém Capernaum, moj iŋmat Jesús jém Dios iŋma̱t́i. Nɨmpa: —Tsa̱cɨ iga immalwatpa, cuca̱cɨ iñjɨ̱xi porque núcneum jém tiempo iga iŋjacpa Dios yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesɨc naspa Jesús jém laguna aŋna̱ca iñɨ̱yi Galilea. Iix tu̱m pɨ̱xiñ con it́ɨ̱wɨ. Tu̱m jém Ximoj, iñɨ̱yit́im Peto; tu̱m jém Anti. Sɨ́p ipatsyaj ired jém laguna iga imatspa tɨɨpɨ. Jeeyaj tɨɨpteroyaj. ");
INSERT INTO poiNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesɨc Jesús iñɨ́máy jém wɨste̱n: —Atúŋɨyt́aamɨ. Nɨcpa tamméts pɨ̱xiñ juuts tɨɨpɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Jesɨc jeet́i rato ichacyaj ired, nɨc it́úŋɨyyaj jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jesɨc nɨc Jesús uxaŋ más juumɨ, ipát tuŋgac wɨste̱n pɨ̱xiñ. Jém Jacobo, jém Zebedeo ima̱nɨc, con it́ɨ̱wɨ jém Xiwan. It́yaj barcojo̱m con ija̱tuŋ. Sɨ́p iŋtótsyaj ired. Jesɨc Jesús iŋwejáy. ");
INSERT INTO poiNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Jeet́i rato ichacyaj jém ibarco y jém ija̱tuŋ. Nɨc it́úŋɨyyaj Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesɨc nɨc Jesús icuwɨ̱t́i jém naxyucmɨ de Galilea. Accuyujóypa cada lugar jém sinagoga ju̱t́ icuyujcayajpa jém Moisés iŋquímayooyi. Iŋmadáypa jém pɨxiñt́am jém wɨbɨc aŋma̱t́i iga núcpa jém tiempo iga iŋjacpa Dios yɨ́p naxyucmɨ. Icpɨs jém mɨmneyajwɨɨp jém imatsneyajwɨɨp it́u̱mpɨy jém caacuy. ");
INSERT INTO poiNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Jo̱dóŋa̱ta̱ icuwɨ̱t́i jém naxyucmɨ de Siria iga agui wɨa̱p jém Jesús. Jesɨc namíñayt́a̱ Jesús it́u̱mpɨy jém mɨmneyajwɨɨp, jém imatsneyajwɨɨp caacuy y jém to̱ya. Namíñayt́a̱t́im jém iniit́wɨɨp mal espíritu, jém imatsneyajwɨɨp ataque y jém tusacanewɨɨp. Icpɨs it́u̱mpɨy. ");
INSERT INTO poiNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Tsa̱m jáyaŋ pɨxiñt́am it́úŋɨyyajpa jém Jesús. Miñyaj de jém naxyucmɨ de Galilea, de jém attebet Decápolis y de jém attebet Jerusalén. Miñyajt́im de jém naxyucmɨ de Judea y de jém Jordán iŋwiñt́uc. ");
INSERT INTO poiNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jesɨc cuando iix Jesús iga aŋtuuma̱yajpa tsa̱m jáyaŋ pɨxiñt́am, quím tu̱m co̱tsɨcyucmɨ. Jemum co̱ñ Jesús. Jém icuyujcɨɨwiñ icunúcyaj. ");
INSERT INTO poiNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Jesɨc Jesús moj iŋquejáy. Nɨmpa: ");
INSERT INTO poiNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Agui maymay jém ijo̱dóŋa̱neyajwɨɨp t́it́am it́ogóyayyaj iga núcpa ju̱t́ it́ Dios porque jeeyaj núcyajpa ju̱t́ it́ Dios. ");
INSERT INTO poiNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Agui maymay jém aŋyácneyajwɨɨp porque Dios icpocsáypa ia̱nama. ");
INSERT INTO poiNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Agui maymayyaj jém pɨxiñt́am jém d́apɨc nacujípta̱p iyaac porque jeeyaj ipɨctsoŋyajpa yɨ́p nas, jém ijɨycámayñewɨɨp Dios iga ichiiba. ");
INSERT INTO poiNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Agui maymay jém tsa̱mpɨc iwattooba juuts ixunpa Dios porque Dios iyo̱xpátpa iga wɨa̱iñ iwatyaj je̱mpɨc. ");
INSERT INTO poiNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Agui maymay jém iyaachaŋja̱myajpáppɨc jém it́ɨ̱wɨtam porque Dios iyaachaŋja̱mpat́im jeeyaj. ");
INSERT INTO poiNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Agui maymay jém cuáyñewɨɨp ia̱nama porque jeeyaj iixyajpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Agui maymay jém pɨ̱xiñ jém iŋjɨyjacpáppɨc jém áŋa̱yajpaap porque tsɨ́ypa juuts Dios ima̱nɨc. ");
INSERT INTO poiNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Agui maymay jém tsa̱mpɨc yaachwatta̱p iga iwɨ̱watpa juuts ixunpa Dios porque jeeyaj núcyajpa jém wɨ̱co̱m ju̱t́ iŋjacpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Maymáya̱taamɨ cuando jém malopɨc pɨxiñt́am tsa̱m mimalnɨ́mayt́ámpa, tsa̱m miyaachwattámpa y tsa̱m micumɨgoyt́ámpa ɨch aŋcuyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Maymáya̱taamɨ. Odoy aŋyáctaamɨ porque impɨctsoŋtámpa tu̱m wɨbɨc xaja sɨŋyucmɨ. Jɨ̱staamɨ iga jém wiñɨcpɨc aŋmat́cɨɨwiñ tsa̱m pɨ̱mi malwadayyajta̱t́im. ");
INSERT INTO poiNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Mimicht́am mijex juuts jém ca̱na para yɨ́p naxyucmɨpɨc pɨxiñt́am. Pero siiga d́a paac jém ca̱na, ¿jutsa̱p taŋwɨ̱tsac? D́a t́i mejcuy. Tampatsáypa. Icunepnepquetyajpa jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Mimicht́am mijex juuts tu̱m wɨbɨc juctɨ iga iñyɨcquejpa jém it́yajwɨɨp yɨ́p naxyucmɨ. Tu̱m mɨjpɨc attebet lumuyucmɨ d́a i̱ wɨa̱p iŋnéc. ");
INSERT INTO poiNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","D́a i̱ iñooba tu̱m nooquejcuy iga icujappa tu̱m cooŋcucɨɨm. It́unpa yucmɨ iga iyɨcquejpa it́u̱mpɨy jém it́yajwɨɨp je̱m. ");
INSERT INTO poiNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Jesanet́im mimicht́am wɨ̱tsoctaamɨ juuts tu̱m wɨbɨc juctɨ iga iñyɨcquejyajpa jém pɨxiñt́am. Wɨ̱wattaamɨ jém pɨxiñt́ámaŋjo̱m iga cuando iixyajpa, tsa̱m icujípyajpa tanJa̱tuŋ Dios jém it́wɨɨp sɨŋyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Odoy jɨ̱sɨ iga ɨch miñ anaccáy jém Moisés iŋquímayooyi, ni d́a anaccáypa jém wiñɨcpɨc aŋmat́cɨɨwiñ iŋquímayooyi. Ɨch amiñ anaccupac it́u̱mpɨy juuts nɨmpa jém wiñɨcpɨc aŋquímayooyi. ");
INSERT INTO poiNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nu̱ma, mannɨ́máypa, d́a i̱ nunca iccáypa jém wiñɨcpɨc aŋquímayooyi. Ni tu̱m punto ni tu̱m jɨ̱t́i d́a togoypa. D́a cuyajpa jém sɨŋ ni jém nas hasta que cupacpa it́u̱mpɨy cosa juuts nɨmpa jém aŋquímayooyi. ");
INSERT INTO poiNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Siiga tu̱m pɨ̱xiñ d́a iccupacpa tu̱m jém aŋquímayooyi d́apɨc juchaŋ y iŋquejáypat́im je̱mpɨc jém pɨxiñt́am, jesɨc d́a t́i mejcuy jém pɨ̱xiñ. D́a tɨgɨypa ju̱t́ iŋjacpa Dios. Pero siiga tu̱m pɨ̱xiñ iwatpa it́u̱mpɨy juuts nɨmpa jém wiñɨcpɨc aŋquímayooyi, y siiga iŋquejáypat́im jém pɨxiñt́am, jesɨc jém pɨ̱xiñ tsɨ́ypa juuts tu̱m mɨjpɨc aŋjagooyi cuando iŋjacpa Dios yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Pero mannɨ́máypa mimicht́am, siiga d́a más iŋwɨ̱wattámpa que jém fariseoyaj y jém escribaspɨc maestroyaj, jesɨc d́a wɨa̱p iññúc ju̱t́ iŋjacpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Micht́am immatoŋneta iga jém wiñɨcpɨc tanja̱tuŋwe̱wetam nɨmyaj iga: “Odoy accaooyɨ porque chiit́a̱p castigo jém accaoypaap.” ");
INSERT INTO poiNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pero ɨch mannɨ́máypa, siiga i̱ ijóyixpa jém it́ɨ̱wɨ, ipɨctsoŋpa jém castigo juuts tu̱m accaoypaap. Siiga i̱ imalnɨ́máypa jém it́ɨ̱wɨ, cɨɨpiŋta̱p jém co̱bacpɨc aŋjagooyicɨɨm, jém Sanhedrín; chiit́a̱p castigo. Siiga i̱ iñɨ́máypa jém it́ɨ̱wɨ iga tsa̱m bruto, jesɨc jém pɨ̱xiñ wɨa̱p icnɨcta̱ jém infierno, jém juctjo̱m ju̱t́ d́a nunca píchpa. ");
INSERT INTO poiNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Cuando ininɨcpa tu̱m ofrenda iga iñchiiba Dios jém altaryucmɨ, siiga iñjɨ̱spa iga immalwadayñe jém iñt́ɨ̱wɨ, ");
INSERT INTO poiNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","jesɨc odoyñam tsa̱cɨ jém ofrenda jém altaryucmɨ. Wiñt́i nɨ̱gɨ cunucsaayɨ jém iñt́ɨ̱wɨ, jesɨc wɨa̱p iñchac jém ofrenda. ");
INSERT INTO poiNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Siiga i̱ mijóyixpa y miquejajwadáypa, jesɨc wɨ̱tsa̱cɨ jém íñasunto antes que miñúctámpa jém juezcɨɨm porque una vez miñúcneum je̱m, micɨɨjuŋcotta̱p jém policía icɨɨjo̱m, mipajta̱p. ");
INSERT INTO poiNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Mannɨ́máypa iga d́a miputpa hasta que yajpa iñyoj. ");
INSERT INTO poiNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Micht́am immatoŋneta iga jém wiñɨcpɨc tanja̱tuŋwe̱wetam nɨmyajpa iga: “Odoy pejooyɨ.” ");
INSERT INTO poiNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pero ɨch mannɨ́máypa siiga i̱ iámpa tu̱m yo̱mo iga tsa̱m icusúnɨ́ypa, jesɨc pejóypa ia̱namaŋjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Siiga jém íñixcuy, jém aŋwɨ̱mɨpɨc, micwatpa táŋca, to̱pɨ, patsaayɨ. Más wɨ̱ iga togoypa tu̱m parte jém immɨjta̱y que iga micotta̱p iŋcumɨj jém juctjo̱m ju̱t́ d́a nunca píchpa. ");
INSERT INTO poiNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Siiga iŋcɨ, jém aŋwɨ̱mɨpɨc, micwatpa táŋca, jesɨc ja̱cɨ, patsaayɨ. Más wɨ̱ iga togoypa tu̱m ja̱ca jém immɨjta̱y que iga micotta̱p iŋcumɨj jém juctjo̱m ju̱t́ d́a nunca píchpa. ");
INSERT INTO poiNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Wiñɨgam nɨmyajpat́im: “Siiga i̱ ichacpa iyo̱mo, tienes que iwatpa tu̱m acta iga ichacneum jém yo̱mo.” ");
INSERT INTO poiNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pero ɨch mannɨ́máypa siiga tu̱m pɨ̱xiñ ichobɨychacpa iyo̱mo d́a pejoyñe, jesɨc icpejóypa jém yo̱mo siiga ipɨcpa tuŋgac pɨ̱xiñ. Siiga tu̱m pɨ̱xiñ ipɨcpa jém yo̱mo jém tsacneta̱wɨɨp, jesɨc pejóypat́im jém pɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Immatoŋnetat́im iga jém wiñɨcpɨc tanja̱tuŋwe̱wetam nɨmyajpa iga: “Siiga miñɨmpa, wɨ̱jo̱dios, jesɨc accupa̱cɨ t́it́am iñjɨycámayñe Dios.” ");
INSERT INTO poiNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pero ɨch mannɨ́máypa iga odoy tsa̱cɨ ni tu̱m cosa juuts testigo iga d́a mimɨgóypa. Odoy tsa̱cɨ jém sɨŋ juuts tu̱m testigo iga d́a mimɨgóypa porque sɨŋyucmɨ iŋjacpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Odoy tsa̱cɨ jém nas juuts tu̱m testigo iga d́a mimɨgóypa porque jém naxyucmɨ icte̱ññe ipuy jém tanJa̱tuŋ Dios. Odoy tsa̱cɨ jém Jerusalén juuts tu̱m testigo porque je jém más Mɨjpɨc Rey imɨɨchi. ");
INSERT INTO poiNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Odoy tsa̱cɨ juuts tu̱m testigo jém iŋco̱bac iga d́a mimɨgóypa porque ni tu̱m jém iŋway d́a wɨa̱p inicpooba̱ ni d́at́im wɨa̱p inicyɨga̱. ");
INSERT INTO poiNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Cuando miŋmattámpa, nɨmtaamɨ “nu̱ma” o “d́a”. Siiga iñchacpa algun t́i juuts testigo iga d́a mimɨgóypa, jesɨc d́a wɨ̱ porque jexpɨc jɨ̱xi miññe de jém Woccɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Micht́am immatoŋneta iga nɨmyajpa wiñɨgam: “Siiga i̱ iñácscutedáypa iixcuy tu̱m pɨ̱xiñ, jesɨc jém pɨ̱xiñ icɨaŋseedáypa, iñácscutedáypat́im iixcuy. Siiga i̱ iñacxquímáypa it́ɨts tu̱m pɨ̱xiñ, jesɨc icɨaŋseedáypat́im, iñacxquímáypat́im it́ɨts.” ");
INSERT INTO poiNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pero ɨch mannɨ́máypa: Siiga i̱ mimalwadáypa, odoy cɨaŋseedaayɨ. Siiga i̱ micótsáypa íña̱cpac, jesɨc jɨ́gaayɨ iga micótsáyiñt́im tuŋgac lado. ");
INSERT INTO poiNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Siiga i̱ miquejajwadáypa iga mit́obáypa jém iñyoot́i, jesɨc chi̱ɨt́im jém iñchamarra. ");
INSERT INTO poiNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Siiga i̱ mipɨɨmɨ́ypa pɨ̱mi̱mɨ iga ininɨgáyiñ algun t́i tu̱m kilómetro, nanɨgaayɨ dos kilómetro. ");
INSERT INTO poiNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Siiga i̱ miwágáypa algun t́i, jesɨc chi̱ɨ. Siiga i̱ miñucsáypa alguna cosa, jesɨc acnúcsɨ, odoy nɨ́maayɨ iga d́a manchiiba. ");
INSERT INTO poiNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Immatoŋneta juuts nɨmyajpa jém pɨxiñt́am: “Toyt́aamɨ jém íñamigo, pero jóyixt́aamɨ jém íñenemigo.” ");
INSERT INTO poiNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pero ɨch mannɨ́máypa iga: Toyt́aamɨ jém íñenemigoyaj. Odoy malnɨ́mayt́aamɨ jém mimalnɨ́mayñewɨɨp. Wɨ̱wadayt́aamɨ jém mijóyixpaap. Aŋwejpáttaamɨ Dios iga iwɨ̱wadáyiñ jém pɨxiñt́am jém mimalwadayñewɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Siiga iŋwattámpa je̱mpɨc, jesɨc michɨ́yt́ámpa juuts tanJa̱tuŋ Dios mima̱nɨctam jém it́wɨɨp sɨŋyucmɨ. Porque jém tanJa̱tuŋ Dios icpijpa ja̱ma para jém malopɨc y para jém wɨbɨc. Dios icchijóypa tuj para jém tsa̱mpɨc táŋcaɨ́y y para jém d́apɨc táŋcaɨ́y. ");
INSERT INTO poiNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Siiga nada más iñt́oyt́ámpa jém mit́oyyajpaap, ¿que iñjɨ̱spa iga Dios miwɨ̱wadáypa? Porque jém malopɨc pɨxiñt́am, jém ichécyajpáppɨc impuesto, it́oypat́im jém iamigoyaj. ");
INSERT INTO poiNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Siiga iñdioschiiba nada más jém iñt́ɨ̱wɨtam, ¿que iñjɨ̱spa iga iŋwɨ̱watpa? Jém d́apɨc iixpɨcpa Dios idioschiyajpat́im jém it́ɨ̱wɨtam. ");
INSERT INTO poiNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Siempre wɨ̱wattaamɨ juuts iwatpa jém tanJa̱tuŋ Dios jém it́wɨɨp sɨŋyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Odoy nɨ́maŋtaaya̱jɨ iga iŋwatpa juuts ixunpa Dios iga miixyajiñ jém pɨxiñt́am porque siiga iŋwatpa je̱mpɨc, jesɨc jém tanJa̱tuŋ Dios jém it́wɨɨp sɨŋyucmɨ d́a michiiba jém iŋcoñwɨyooyi. ");
INSERT INTO poiNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Jeeyucmɨ mannɨ́máypa cuando iñyo̱xpátpa jém yaacha̱yajpaap, odoy i̱ aŋmadaayɨ iga iŋwɨ̱watne. Jém malopɨc pɨxiñt́am, jém nɨ́maŋtaaya̱paap iga icupɨcyajpa Dios, siiga iwɨ̱watyajpa, tsa̱m iŋmadayyajpa i̱ quej iga cujípta̱iñ. Iŋmatpat́im aŋsɨ̱cmɨ y jém sinagoga t́it́am iwatyajpa. Tsa̱m iwɨ̱aŋja̱myaj iga cujípyajta̱iñ. Nu̱ma mannɨ́máypa iga jeeyaj ipɨctsoŋneyajum jém icoñwɨyooyi. ");
INSERT INTO poiNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Cuando iñchiiba algun t́i jém yaacha̱yajpaap, odoy jɨɨcɨ iga jém aŋna̱ymɨpɨc iŋcɨ ijo̱doŋ t́i iwatpa jém aŋwɨ̱mɨpɨc iŋcɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Yamwa̱tɨ, jesɨc tanJa̱tuŋ Dios icut́um miixpa. Je michiiba jém iŋcoñwɨyooyi. ");
INSERT INTO poiNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Cuando iniŋwejpáttámpa Dios, odoy wattaamɨ juuts iwatyajpa jém nɨ́maŋtaaya̱paap iga icupɨcyajpa Dios. Tsa̱m iwɨ̱aŋja̱myajpa iga iŋwejpátyajpa Dios jém sinagoga o jém calle aŋna̱ca iga iixyajiñ jém pɨxiñt́am. Nu̱ma mannɨ́máypa iga ipɨctsoŋneum jém icoñwɨyooyi. ");
INSERT INTO poiNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Pero mimicht́am cuando iniŋwejpáttámpa Dios, tɨgɨ̱yɨ jém iñt́ɨcjo̱m, aŋpa̱jɨ jém iñt́ɨc, aŋwejpaatɨ Dios jém miwaganait́wɨɨp ju̱t́ d́a i̱ miixpa. Dios iixpa it́u̱mpɨy cosa jém iñyamwatnewɨɨp, michiiba jém iŋcoñwɨyooyi. ");
INSERT INTO poiNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Cuando iniŋwejpátpa Dios, odoy nɨ̱mɨ jeet́im jeet́im aŋma̱t́i jém d́apɨc tayo̱xpátpa juuts iwatyajpa jém tuŋgac pɨxiñt́am jém ijɨ̱syajpaap jém tuŋgac dios jém watnas. Ijɨ̱syajpa iga imatóŋáypa jém watnas porque wat́cɨy nɨmpa jeet́im jeet́im aŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Odoy wa̱tɨ je̱mpɨc juuts iwatyajpa jeeyaj porque tanJa̱tuŋ Dios ijo̱doŋ t́it́am mit́ogóyáy antes que iŋwágáypa. ");
INSERT INTO poiNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Jeeyucmɨ mannɨ́máypa, cuando iniŋwejpáttámpa Dios, nɨmtaamɨ yɨɨmpɨc: ManJa̱tuŋ Dios, miit́wɨɨp sɨŋyucmɨ, agui cuáyñe mich iñɨ̱yi. ");
INSERT INTO poiNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Wɨ̱ iga míñiñ jém ja̱ma iga iniŋjacpa yɨ́p naxyucmɨ. Wa̱tɨ yɨ́p naxyucmɨ juuts mich iŋwɨ̱aŋja̱m, juutst́im iŋwatpa sɨŋyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Achiit́aamɨ yɨ́p ja̱ma t́it́am aŋcúttámpa. ");
INSERT INTO poiNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Awadayt́aamɨ perdón jém antáŋca juutst́im aɨcht́am aŋwadayñeta perdón jém amalwadayñewɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Awattaamɨ cuenta iga odoy i̱ wɨa̱iñ acutɨ́tsta iga acmalwattámpa. Agui miwɨ̱, manJa̱tuŋ Dios. Mich más mɨjpɨc miŋjagooyi. Iniit́ it́u̱mpɨy jém impɨ̱mi. D́a nunca micuyajpa. Amén. ");
INSERT INTO poiNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Porque siiga iŋwadáypa perdón jém mimalwadayñewɨɨp, jesɨc miwadáypat́im perdón jém tanJa̱tuŋ Dios jém it́wɨɨp sɨŋyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pero siiga d́a iŋwadáypa perdón jém mimalwadayñewɨɨp, jesɨc tanJa̱tuŋ Dios d́at́im miwadáypa perdón jém iñt́áŋca. ");
INSERT INTO poiNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Cuando iŋwattámpa ayuno odoy aŋyáguiñ íñámooyi juuts iwatyaj jém nɨ́maŋtaaya̱paap iga iixpɨcyajpa Dios. Odoy naŋquejta̱jɨ iga iŋwatne ayuno. Nu̱ma mannɨ́máypa iga jeeyaj iniit́um jém icoñwɨyooyi. ");
INSERT INTO poiNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Pero mimicht́am cuando iŋwattámpa ayuno jetstaamɨ iŋway, jít́t́aamɨ iŋwiñpac, ");
INSERT INTO poiNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","iga jém pɨxiñt́am odoy icutɨɨyɨ́yiñ iga iŋwatne ayuno. Jém tanJa̱tuŋ Dios icut́um ijo̱doŋ iga iŋwatne ayuno, jesɨc michiiba jém iŋcoñwɨyooyi. ");
INSERT INTO poiNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Odoy aŋtuuma̱wa̱tɨ jáyaŋ riqueza yɨ́p naxyucmɨ ju̱t́ icútpa jém we̱chi, ju̱t́ tsa̱m jómpa, ju̱t́ tɨgɨyyajpa jém númyajpaap. ");
INSERT INTO poiNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Aŋtuuma̱wa̱tɨ jáyaŋ riqueza sɨŋyucmɨ ju̱t́ d́a icútpa jém we̱chi ni d́at́im jómpa, ju̱t́ d́a tɨgɨyyajpa jém númyajpaap. ");
INSERT INTO poiNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Porque ju̱t́ iniŋtuuma̱watne jém iñriqueza je̱mt́im it́ íña̱nama. ");
INSERT INTO poiNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Jém íñixcuy jex juuts tu̱m wɨbɨc juctɨaŋtso̱ca para jém immɨjta̱y. Siiga wɨ̱ jém íñixcuy, jesɨc it́u̱mpɨy jém immɨjta̱y it́ jém juctɨaŋtso̱cajo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Siiga d́a wɨ̱ jém íñixcuy, it́u̱mpɨy jém immɨjta̱y it́ piichcɨɨm. Siiga píchñe jém juctɨaŋtso̱ca, tsa̱m pɨ̱mi piichcɨɨm miit́. ");
INSERT INTO poiNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’D́a i̱ wɨa̱p icuyo̱xa̱ wɨste̱n io̱mi. Porque siiga it́oypa tu̱m, jesɨc ijóyixpa tuŋgac. Siiga iwɨ̱nanɨgáypa tu̱m, jesɨc tuŋgac d́a iwɨ̱nanɨgáypa. D́a i̱ wɨa̱p icuyo̱xa̱ Dios siiga tsa̱m it́oypa jém it́umiñ. ");
INSERT INTO poiNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Jeeyucmɨ mannɨ́máypa iga: Odoy jɨ̱sɨ ju̱t́ impɨcpa t́it́am iŋcútpa ni t́it́am íñucpa para miit́pa yɨ́p vida. Odoy jɨ̱sɨ ju̱t́ impɨcpa jém impuctu̱cu para jém immɨjta̱y. Más wɨ̱ jém imvida que jém iŋwíccuy. Más wɨ̱ jém immɨjta̱y que jém impuctu̱cu. ");
INSERT INTO poiNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","I̱xɨ jém jonyaj jém quecpaap. D́a ñipyajpa, d́at́im ipiŋyajpa jém cosecha iga iccáypa tu̱m tɨcjo̱m. Pero icwícpa jém tanJa̱tuŋ Dios jém it́wɨɨp sɨŋyucmɨ. Mich más miwɨ̱ que jém jonyaj. ");
INSERT INTO poiNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Siiga tsa̱m iñjɨ̱spa, ¿que wɨa̱p iñyón uxaŋ más? ");
INSERT INTO poiNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿T́iiga tsa̱m iñji̱spa ju̱t́ impɨcpa jém impuctu̱cu? Jɨ̱staamɨ jém wɨbɨc mo̱ya jém nayñewɨɨp co̱pjo̱m. Je d́a yo̱xa̱p ni d́a pit́pa. ");
INSERT INTO poiNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Pero ni jém rey Salomón cuando tsa̱m wɨ̱cuyajne, d́a ictsɨ́ypa iwɨ̱ juuts jém wɨbɨc mo̱ya. ");
INSERT INTO poiNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Dios tsa̱m iwɨ̱accuyajne jém mo̱ya, jém it́wɨɨp co̱pjo̱m, pero jo̱ymɨ jípsquetpa. Mimicht́am d́a iŋwɨ̱cupɨcne Dios, pero je más mit́oypa que jém mo̱ya. ");
INSERT INTO poiNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Jeeyucmɨ mannɨ́máypa odoy jɨ̱sɨ ju̱t́ impɨcpa t́it́am iŋcútpa y t́it́am íñucpa. Odoy jɨ̱sɨ ju̱t́ impɨcpa jém impuctu̱cu. ");
INSERT INTO poiNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Porque jexpɨc jɨ̱xi iniit́ jém d́apɨc icupɨcyajpa Dios. Tsa̱m imétsyajpa it́u̱mpɨy jexpɨc cosa, pero mimicht́am iniit́ tu̱m iñJa̱tuŋ sɨŋyucmɨ. Ijo̱doŋ t́it́am mit́ogóyáy. ");
INSERT INTO poiNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Wiñt́i métstaamɨ jutsa̱p iñt́ɨgɨyt́a ju̱t́ iŋjacpa Dios y jutsa̱p iŋwatta jém wɨ̱tampɨc cosa juuts ixunpa Dios, jesɨc ocmɨ Dios michiiba t́it́am mit́ogóyáy. ");
INSERT INTO poiNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Odoy jɨ̱sɨ t́it́am mit́ogóyáypa para jo̱ymɨ porque jo̱ymɨ it́ tiempo iga iñjɨ̱spat́im. Cada ja̱ma iniit́ jém d́a wɨbɨc cosa. ");
INSERT INTO poiNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Odoy jɨ̱sɨ tuŋgac pɨ̱xiñ iga táŋcaɨ́y, jesɨc Dios d́at́im mijɨ̱sáypa mich iñt́áŋca. ");
INSERT INTO poiNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Siiga tsa̱m iñjɨ̱spa iga táŋcaɨ́y tuŋgac pɨ̱xiñ, jesɨc Dios mijɨ̱sáypat́im mimich iñt́áŋca. Miquípsayt́a̱pt́im con jeet́im quipsóycuy jém impɨcnewɨɨp iga iŋquíps. ");
INSERT INTO poiNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿T́iiga íñixáypa jém iñt́ɨ̱wɨ tu̱m xut́u pu̱chi iixco̱m? ¿Que d́a iñja̱mpa jém mɨjpɨc cuy íñixco̱m? ");
INSERT INTO poiNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Jutsa̱p iññɨ́máy jém iñt́ɨ̱wɨ iga mantobáypa jém pu̱chi íñixco̱m cuando michgact́i iniit́t́im tu̱m mɨjpɨc cuy íñixco̱m? ");
INSERT INTO poiNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Tsa̱m minimɨgóyayt́a̱p iñyaac. Wiñt́i to̱pɨ jém cuy íñixco̱m, jesɨc iŋwɨ̱ixáypa jém pu̱chi jém iñt́ɨ̱wɨ iixco̱m. ");
INSERT INTO poiNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Odoy chi̱ɨ jém wɨbɨc cosa jém Diospɨc imɨɨchi jém malopɨc pɨxiñt́am juuts jém chimpayaj. Porque d́a iwɨ̱ixyajpa jém Dios imɨɨchi, mimalwadáypat́im mex mimich. Odoy co̱tɨ jém perla, jém wɨbɨc tsa, ju̱t́ it́yaj jém yo̱ya. Wɨa̱p icunepnepquetyaj. ");
INSERT INTO poiNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Wágayt́aamɨ Dios t́it́am mit́ogóyáy, je michiiba. Métstaamɨ jém wɨ̱tampɨc cosa, jesɨc impáttámpa. Tɨcstaamɨ jém tɨc ipuerta, míŋáyayt́a̱p. ");
INSERT INTO poiNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","El que iwágáypa Dios algun t́i, chiit́a̱p. El que imétspa jém wɨ̱tampɨc cosa, ipátpa. El que it́ɨcspa jém tɨc ipuerta, áŋáyayt́a̱p. ");
INSERT INTO poiNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Siiga miwágáypa imma̱nɨc tu̱m caxt́ána̱ñi, ¿que iñchiiba tu̱m tsa? ");
INSERT INTO poiNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Siiga miwágáypa imma̱nɨc tu̱m tɨɨpɨ, ¿que iñchiiba tu̱m tsa̱ñ? ");
INSERT INTO poiNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mimicht́am tsa̱m mimalotam, pero iñjo̱doŋ jutsa̱p iñchi imma̱nɨc jém wɨ̱tampɨc cosa. Pero jém tanJa̱tuŋ Dios, jém it́wɨɨp sɨŋyucmɨ, je d́a malo; ichiiba jém ima̱nɨctam jém wɨ̱tampɨc cosa jém iwágaypáppɨc. ");
INSERT INTO poiNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Jesɨc mimicht́am wɨ̱wadayt́aamɨ jém tuŋgac pɨxiñt́am juuts mimicht́am iñxunpa iga miwɨ̱wadáypat́im mex jeeyaj. Siiga iŋwattámpa je̱mpɨc, jesɨc cupacpa it́u̱mpɨy jém Moisés iŋquímayooyi con jém aŋma̱t́i ijaychacnewɨɨp jém wiñɨcpɨc Dios iŋmat́cɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Tɨgɨyt́aamɨ jém wayaypɨc puerta. Porque wɨ̱t́i jém puerta y tsa̱m wɨ̱t́i jém tuŋ jém nɨcpáppɨc ju̱t́ togoyyajpa jém pɨxiñt́am. Tsa̱m jáyaŋ nɨcyajpa je̱m. ");
INSERT INTO poiNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Wayay jém puerta y wayayt́im jém tuŋ jém nɨcpáppɨc ju̱t́ ipɨctsoŋyajpa jém vida jém d́apɨc cuyajpa. D́a wa̱t́i jém pɨxiñt́am ipátyajpa jém tuŋ iga tɨgɨyyajpa je̱m. ");
INSERT INTO poiNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Nawatta̱jɨ cuenta iga odoy mimɨgóyáyiñ jém malopɨc pɨxiñt́am, jém nɨ́maŋtaaya̱paap iga icuyo̱xa̱p Dios. Miñpa juuts tu̱m wɨbɨc pɨ̱xiñ, pero miñpa imalwadáy jém Dios ipɨxiñt́am. Juuts jém lobo icunu̱mpa jém borrego. ");
INSERT INTO poiNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mimicht́am wɨa̱p íñixpɨcta juutspɨc pɨ̱xiñ cuando íñixt́ámpa t́i iwatpa. Mich iñjo̱doŋ iga d́a tantúcpa wɨbɨc uvas chicxchayyucmɨ. D́a tantúcpa tsuj a̱pit́cuyyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Jém wɨbɨc cuy d́a chióypa malopɨc tɨm. Jém malopɨc cuy d́a chióypa jém wɨbɨc tɨm. ");
INSERT INTO poiNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Jém wɨbɨc cuy d́a wɨa̱p ichióy jém malopɨc tɨm. Jém malopɨc cuy d́a wɨa̱p ichióy jém wɨbɨc tɨm. ");
INSERT INTO poiNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","It́u̱mpɨy jém cuy, jém d́apɨc chióypa jém wɨbɨc tɨm, tɨŋquímta̱p. Nooquetta̱p juctjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Jesɨc mimicht́am íñixpɨctámpa juutspɨc pɨ̱xiñ cuando íñixpa siiga iwɨ̱watpa o imalwatpa. ");
INSERT INTO poiNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Wa̱t́i jém pɨxiñt́am anɨ́mayyajpa iga: “MánO̱mi, mánO̱mi”, pero d́a it́u̱mpɨy tɨgɨyyajpa ju̱t́ iŋjacpa Dios. Nada más tɨgɨyyajpa jém iwatneyajwɨɨp juuts ixunpa tanJa̱tuŋ Dios jém it́wɨɨp sɨŋyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Cuando núcpa jém ja̱ma, jesɨc jáyaŋ jém pɨxiñt́am anɨ́mayyajpa: “MánO̱mi, mánO̱mi, ¿que d́a anaŋmatta jém Dios iŋma̱t́i mich iññɨyi̱mɨ, que d́a antopta jém mal espíritu mich iññɨyi̱mɨ, que d́a aŋwatta jáyaŋ jém wɨbɨc milagro mich iññɨyi̱mɨ?” ");
INSERT INTO poiNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Jesɨc ɨch annɨ́máypa jeeyaj: “D́a mánixpɨcpa. Nɨcstaamɨ mimicht́am, tsa̱m immalwatneta.” ");
INSERT INTO poiNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Jém pɨ̱xiñ imatoŋpa ɨch anaŋma̱t́i y iwatpa juuts annɨ́máypa jex juuts tu̱m pɨ̱xiñ tsa̱mpɨc jɨ̱xiɨ́y iga iwatpa tɨc. Icpɨɨma̱p tu̱m tsaayucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ocmɨ tsa̱m pɨ̱mi chijóypa tuj. Compa jém nɨ. Tsa̱m pɨ̱mi poypa jém sa̱wa. Ictsɨ́ypa jém tɨc, pero d́a cutɨŋpa porque pɨɨma̱ne tsaayucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Tuŋgac imatoŋpa ɨch anaŋma̱t́i, pero d́a iwatpa juuts annɨ́máypa. Je jex juuts tu̱m pɨ̱xiñ d́apɨc jɨ̱xiɨ́y. Iwat tu̱m tɨc, pero icpɨɨma̱p pooyyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ocmɨ tsa̱m pɨ̱mi chijóy tuj, compa nɨ, pɨ̱mi poypa jém sa̱wa. Ictsɨ́y jém tɨc, iccutɨŋ, d́a t́i tsɨ́y. ");
INSERT INTO poiNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesɨc cuando yaj iŋmat Jesús jém iŋquímayooyi tsa̱m ipooñaŋja̱myajpa jém pɨxiñt́am, ");
INSERT INTO poiNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","porque iŋquejáypa juuts tu̱m aŋjagooyi d́a jex juuts jém escribaspɨc maestroyaj. ");
INSERT INTO poiNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Cuando quet Jesús jém co̱tsɨcyucmɨ, it́úŋɨyyaj jáyaŋ jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Jesɨc miñ tu̱m pɨ̱xiñ tsa̱m mɨmne, cupúgayñe iña̱ca, iniit́ jém lepra. Ico̱steeñáy jém Jesús. Nɨmpa jém mɨmnewɨɨp: —MánO̱mi, siiga iŋwɨ̱aŋja̱m, wɨa̱p anacpɨs. ");
INSERT INTO poiNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesɨc Jesús ichɨccunúc jém pɨ̱xiñ, iñɨ́máy: —Aŋwɨ̱aŋja̱m. Micuáyñeum. Jesɨc yaj nɨ̱mi jém Jesús, pɨsum jém pɨ̱xiñ, wɨ̱tsɨ́yum jém iña̱ca. ");
INSERT INTO poiNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jesɨc Jesús iñɨ́máy jém pɨ̱xiñ: —Odoy i̱ aŋmadaayɨ iga ɨch manacpɨs, pero nɨ̱gɨ aŋquejaayɨ jém pa̱nij iga michacneum jém caacuy. Jesɨc chi̱ɨ Dios jém ofrenda juuts nɨmpa jém Moisés iŋquímayooyi iga miixt́a̱p iga nu̱ma mipɨsneum. ");
INSERT INTO poiNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jesɨc núc Jesús jém attebet Capernaum. Tu̱m Romapɨc capitán icunúc Jesús, moj icunucsáy. ");
INSERT INTO poiNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Nɨmpa jém capitán: —Maestro, mɨmne actɨŋ tu̱m wo̱ñjaychɨ̱xi antɨccɨɨm, tu̱m jém aŋcuyo̱xapaap. Tusacane icumu̱ma. Tsa̱m pɨ̱mi yaacha̱p ixɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesús iñɨ́máy: —Nɨcpa anacpɨs. ");
INSERT INTO poiNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Nɨmpa jém capitán: —Maestro, d́a wɨ̱ iga miñɨcpa antɨccɨɨm porque mich agui wɨbɨc mipɨ̱xiñ, ɨch tsa̱m atáŋcaɨ́y. Nada más pɨɨmɨɨyɨ jém caacuy iga ichaguiñ jém aŋcuyo̱xapaap, jesɨc pɨspa. ");
INSERT INTO poiNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Porque ɨch anait́t́im tu̱m anaŋjagooyi iga apɨɨmɨ́ypa. Ɨch anait́t́im soldado jém ampɨɨmɨypaap. Siiga annɨ́máypa jém ansoldado iga nɨguiñ, jesɨc tienes que nɨcpa. Siiga annɨ́máypa iga míñiñ, jesɨc tienes que miñpa. Siiga ampɨɨmɨ́ypa tu̱m jém acuyo̱xapaap iga iwad́iñ alguna cosa, jesɨc tienes que iwatpa. ");
INSERT INTO poiNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jesɨc mimatoŋ jém Jesús junɨmpa jém capitán, agui ipooñaŋja̱m. Iñɨ́máy Jesús jém it́úŋɨyyajpaap: —Nu̱ma mannɨ́máypa, icuwɨ̱t́i tannación de Israel d́a ampát ni tu̱m pɨ̱xiñ wɨa̱p icupɨc Dios juuts yɨ́p capitán. ");
INSERT INTO poiNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mannɨ́máypat́im iga tsa̱m jáyaŋ pɨxiñt́am jém d́apɨc je de Israel miñyajpa ju̱t́quej yɨ́p naxyucmɨ. Miñyajpa aŋnɨɨsa̱umɨpɨc y aŋyo̱msa̱umɨpɨc. Iwaganaco̱ñyajpa jém wiñɨcpɨc aŋmat́cɨɨwiñ jém Abraham, Isaac y Jacob ju̱t́ iŋjacpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pero wa̱t́i jém Israelpɨc pɨxiñt́am jém iniit́wɨɨp derecho iga tɨgɨypa ju̱t́ iŋjacpa Dios, quebacputyajta̱p. Tsacyajta̱p aŋsɨ̱cmɨ jém piichcɨɨm. Jemum tsa̱m wejyajpa, tsa̱m iñichyajpa it́ɨts. ");
INSERT INTO poiNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jesɨc Jesús iñɨ́máy jém capitán: —Nɨcsɨm iñt́ɨcmɨ. Mich iŋcupɨc iga Dios miwadáy juuts mich iñxunpa. Je̱mpam iwat. Jeet́i hora pɨsum jém icuyo̱xapaap. ");
INSERT INTO poiNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Cuando núc Jesús jém Peto it́ɨccɨɨm, iix iga wo̱ne icheesmɨ jém Peto imɨɨda̱pa. Tsa̱m pɨ̱mi jawaŋɨ́y. ");
INSERT INTO poiNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesɨc Jesús ichɨgáy jém yo̱mo icɨ. Ichac jém jawaŋ, jeet́i rato tsucum, moj icwícyaj jém Jesús con icuyujcɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Jesɨc piicha̱wum i̱t́i, jém pɨxiñt́am inimíñayyaj Jesús jáyaŋ jém iniit́wɨɨp jém mal espíritu. It́op jém mal espíritu, nada más ijɨ́yáypa iga pud́iñ. Icpɨs it́u̱mpɨy jém mɨmneyajwɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Je̱mpam iwat Jesús iga cupacpa jém aŋma̱t́i juuts ijaychacne jém wiñɨcpɨc aŋmat́cɨɨwiñ jém Isaías. Nɨmpa: “Je iyaac ipɨctsoŋ taɨcht́am taŋcaacuy. Ipɨctsoŋ it́u̱mpɨy jém yaacha̱ji.” ");
INSERT INTO poiNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jesɨc cuando iix Jesús iga aŋtuuma̱yajpa tsa̱m jáyaŋ pɨxiñt́am, iñɨ́máy jém icuyujcɨɨwiñ: —Tanɨctámpa jém laguna aŋwiñt́uc. ");
INSERT INTO poiNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Jesɨc miñ tu̱m jém escribaspɨc maestro. Icunúc jém Jesús, iñɨ́máy: —Maestro, mantúŋɨ́ypa ju̱t́quej ju̱t́ miñɨcpa. ");
INSERT INTO poiNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesús iñɨ́máy jém pɨ̱xiñ: —Jém zorra iniit́ ijos ju̱t́ moŋpa. Jém jon iniit́t́im ipeeñi. Pero ɨch, jém aMiññewɨɨp Sɨŋyucmɨ, d́a anai̱ ju̱t́ anacjejpa aŋco̱bac. ");
INSERT INTO poiNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Jesɨc tuŋgac jém icuyujcɨɨwiñ iñɨ́máy jém Jesús: —MánO̱mi, ajɨ́gaayɨ iga wiñt́i nɨcpa aŋcum jém anja̱tuŋ. Ocmɨ mantúŋɨ́ypa. ");
INSERT INTO poiNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Pero Jesús iñɨ́máy: —Mi̱ñɨ atúŋɨɨyɨ. Tsa̱cɨ jém caaneyajwɨɨp iga nacumyajta̱p jeeyaj. ");
INSERT INTO poiNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jesɨc Jesús tɨgɨy tu̱m barcojo̱m. Tɨgɨyt́im mex jém icuyujcɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ocmɨ moj po̱yi jém sa̱wa jém laguna. Tsa̱m pɨ̱mi poypa hasta tɨgɨypa nɨ jém barcojo̱m. Pero moŋpa Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Jesɨc jém icuyujcɨɨwiñ nɨc ichɨcyus. Iñɨ́mayyaj: —MánO̱mi, acɨacputtaamɨ porque tacumoŋtámpam nɨɨcɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesɨc Jesús iñɨ́máy: —¿T́iiga tsa̱m micɨ̱ŋtámpa? ¿Que d́a iŋcupɨcpa ni uxaŋ iga Dios miyo̱xpátpa? Jesɨc tsucum Jesús, iñɨ́máy jém sa̱wa y jém nɨɨpoa iga teeñaŋjaguiñ. Jesɨc teeñaŋjac jém sa̱wa y jém nɨɨpoa. D́am t́i tsɨgóypa. ");
INSERT INTO poiNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Jém icuyujcɨɨwiñ agui ipooñaŋja̱myaj. Nanɨ́mayyajta̱ entre jeeyaj: —¿I̱apaap yɨ́p pɨ̱xiñ iga iñɨ́máy jém sa̱wa y nɨɨpoa iga teeñiñ y icupɨcpa? ");
INSERT INTO poiNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jesɨc cuando núc Jesús jém laguna aŋwiñt́uc jém naxyucmɨ de Gadara, ipát wɨste̱n pɨ̱xiñ jém imatsnewɨɨp jém mal espíritu. Putyaj jém camposanto, icunúcyaj Jesús. Tsa̱m pɨ̱mi maloyaj juuts tu̱m jɨmñi ani̱mat. Tsa̱m pɨ̱mi icɨ̱ŋyajpa jém it́yajwɨɨp je̱m, d́a i̱ wɨa̱p iñas jém tuŋjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Jesɨc pɨ̱mi jɨyyajpa jém wɨste̱n. Nɨmyaj: —¿T́iiga mit́ɨgɨycúmpa con aɨcht́am? Mich miJesús jém Yucmɨpɨc Dios miMa̱nɨc. ¿Que mimiñ yɨɨm iga anyaachwattámpa antes que d́anam núcpa jém íŋaŋpɨc ja̱ma? ");
INSERT INTO poiNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Jesɨc d́a más juumɨ it́yaj tsa̱m jáyaŋ yo̱ya. Wícpa ixɨɨyaj. ");
INSERT INTO poiNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Jesɨc jém mal espíritu icunucsáy jém Jesús. Nɨmpa: —Siiga antoptámpa, ajɨ́gayt́aamɨ iga atɨgɨypa jém yo̱ya ia̱namaŋjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesɨc Jesús iñɨ́máy: —¡Nɨcsɨm! Jesɨc putyajum jém mal espíritu. Tɨgɨyyaj jém yo̱ya ia̱namaŋjo̱m. Jesɨc póyaŋtsucumyaj jém yo̱ya. Poyi̱mɨ quetyaj jém tejajyucmɨ, actɨŋyaj jém laguna, jicjiccayaj nɨɨcɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Tsa̱m pɨ̱mi ichɨgaŋjécyaj jém iwatyajpáppɨc cuenta jém yo̱ya. Poyi̱mɨ nɨcyajpa it́ɨcmɨ. Cuando núcyaj, moj iŋmadayyaj los demás t́i iñasca jém imatsnewɨɨp id́ɨc jém mal espíritu. ");
INSERT INTO poiNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Jesɨc it́u̱mpɨy jém it́yajwɨɨp jém attebet, nɨc iámyaj jém Jesús. Cuando iixyaj, icunucsayyajpa iga cáyiñ de jém naxyucmɨ de Gadara. ");
INSERT INTO poiNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jesɨc tɨgɨy Jesús tu̱m barcojo̱m, e̱ybɨc jac jém laguna aŋwiñt́uc. Nɨc it́ɨcmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Jesɨc algunos inimíñayyaj Jesús tu̱m mɨmnewɨɨp, tusacane icumu̱ma. Wo̱ne tu̱m tseesyucmɨ mu inimiñyaj. Cuando Jesús iix iga tsa̱m icupɨcyajpa iga Dios wɨa̱p icpɨs, jesɨc iñɨ́máy jém mɨmnewɨɨp: —Ma̱nɨc, maymáya̱jɨ, miwadayñeta̱ perdón jém iñt́áŋca. ");
INSERT INTO poiNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","It́t́im je̱m jute̱n escribaspɨc maestroyaj. Ijɨ̱syajpa ijɨ̱xiaŋjo̱m: “Yɨ́p pɨ̱xiñ icujɨypa tanDios.” ");
INSERT INTO poiNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Pero Jesús ijo̱doŋ t́i sɨ́p ijɨ̱syaj, jesɨc iñɨ́máy: —¿T́iiga iniit́ jém malopɨc jɨ̱xi íña̱namaŋjo̱m? ");
INSERT INTO poiNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Júp más d́a táŋca iga annɨ́máypa yɨ́p pɨ̱xiñ iga: “Manaccáyáypa iñt́áŋca”, o iga annɨ́máypa: “Tsucu̱mɨ, wi̱t́ɨm”? ");
INSERT INTO poiNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Nɨmt́im Jesús: —Pero iga iñjo̱dóŋa̱ta iga jém Miññewɨɨp Sɨŋyucmɨ iniit́ jém ipɨ̱mi iga wɨa̱p iccáyáy jém pɨ̱xiñ it́áŋca yɨ́p naxyucmɨ (jesɨc iñɨ́máy Jesús jém tusacanewɨɨp): Tsucu̱mɨ, pi̱ŋɨm jém iñchees, nɨcsɨm iñt́ɨccɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Jesɨc tsucum jém pɨ̱xiñ, nɨcum it́ɨccɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Cuando iixyaj jém pɨxiñt́am t́i iwat Jesús, tsa̱m cɨ̱ŋyaj, icujípyajpa Dios iga icutsat yɨ́p naxyucmɨ jém ipɨ̱mi. ");
INSERT INTO poiNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesɨc moj nɨqui Jesús. Iix iga jemum co̱ñ jém calle aŋna̱ca tu̱m pɨ̱xiñ ichécpa jém impuesto. Iñɨ̱yi Mateo. Jesɨc Jesús iñɨ́máy: —Atúŋɨɨyɨ. Tsucum jém Mateo, nɨc it́úŋɨ́y jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jesɨc ocmɨ iganam wícpa Jesús jém Mateo it́ɨccɨɨm, núcyaj jáyaŋ jém ichécyajpaap impuesto con tuŋgac jém táŋcaɨywɨɨp. Miñ iwaganaco̱ñyaj jém Jesús con jém icuyujcɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Jesɨc cuando jém fariseoyaj iixyaj t́i iwat jém Jesús, iñɨ́mayyaj jém icuyujcɨɨwiñ: —¿T́iiga wagawícpa jém immaestro con jém ichécyajpaap impuesto y jém tuŋgac táŋcaɨywɨɨp? ");
INSERT INTO poiNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Cuando imatoŋ Jesús t́i nɨmyajpa, iñɨ́máy jém fariseoyaj: —Jém d́apɨc mɨmne d́a ixunpa jém tsóyɨ́yoypaap, pero jém mɨmneyajwɨɨp ixunpa jém tsóyɨ́yoypaap. ");
INSERT INTO poiNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nɨ̱gɨ cuyujcaɨ t́i nɨmtooba jém Dios iŋma̱t́i ju̱t́ jaychacneta̱: “Más wɨ̱ iga iñt́óyiñ jém iñt́ɨ̱wɨtam que iga iŋwatpa jém sacrificio.” Jesa̱pt́im aɨch d́a miñ amméts jém d́apɨc táŋcaɨ́y. Miñ amméts jém táŋcaɨywɨɨp iga icucacyajiñ jém ijɨ̱xi. ");
INSERT INTO poiNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Jesɨc miñyaj jém Xiwan icuyujcɨɨwiñ jém acchíŋoypaap. Miñ icwácyaj jém Jesús. Nɨmyaj: —¿T́iiga aɨcht́am con jém fariseopɨc pɨxiñt́am tsa̱m aŋwattámpa ayuno, pero mich iŋcuyujcɨɨwiñ d́a iwatyajpa ayuno? ");
INSERT INTO poiNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesús icutsoŋ. Nɨmpa: —¿Que wɨa̱p iŋyácneyaj jém aŋwejayñeta̱wɨɨp ju̱t́ it́ tu̱m aŋcoomɨ́yóycuy iganam it́ jém yoomɨypaap? Pero núcpa ja̱ma cuando accáyt́a̱p jém yoomɨypaap, jesɨc nu̱ma iwatyajpa ayuno. ");
INSERT INTO poiNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Jesɨc Jesús iŋquejáyt́im iga jém jo̱mipɨc aŋquímayooyi d́a iwɨ̱nanɨgáypa jém wiñɨcpɨc jɨ̱xi. Nɨmpa: —D́a i̱ iŋtótspa tu̱m pecapɨc yoot́i con tu̱m ja̱ca jo̱mpuctu̱cu. Porque siiga iwatpa je̱mpɨc, nɨaŋxichpa jém jo̱mipɨc puctu̱cu, más pɨ̱mi jacpa jém pecapɨc puctu̱cu ju̱t́ aŋtótsne. ");
INSERT INTO poiNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","D́a i̱ icucompa jo̱mvino jém pecapɨc cuero bolsajo̱m. Porque siiga je̱mpɨc iwatpa, tojaŋsajpa jém pecapɨc cuero bolsa, cutegáypa jém vino, togoypa jém cuero bolsa. Jeeyucmɨ cucomta̱p jém jo̱mvino jém jo̱mipɨc cuero bolsajo̱m, jesɨc d́a togoypa jém bolsa ni jém vino. ");
INSERT INTO poiNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Iganam iŋmatpa Jesús, núc tu̱m Israelpɨc aŋjagooyi. Ico̱steeñáy jém Jesús. Iñɨ́máy: —Yaguiñ ca jém anyo̱mma̱nɨc. Nɨ̱gɨ tsɨccunuucɨ jém anyo̱mma̱nɨc iga pɨxiñ. ");
INSERT INTO poiNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Tsucum Jesús. Iwagananɨcyaj jém aŋjagooyi con jém icuyujcɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Iganam nɨquiyaj, tu̱m yo̱mo icunúc jém Jesús it́uuñiaŋcɨɨm. Tsa̱m mɨmne. Doce a̱mt́ɨy imatsne jém caacuy iga quetpa iñɨɨpiñ, d́a nunca te̱ñpa. Ichɨgáy jém Jesús iyoot́i iŋna̱ca. ");
INSERT INTO poiNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ijɨ̱spa jém yo̱mo ijɨ̱xiaŋjo̱m. Nɨmpa: “Siiga nada más antsɨgáypa jém iyoot́i, jesɨc apɨspa.” ");
INSERT INTO poiNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesɨc ámse̱t Jesús, iix jém yo̱mo. Iñɨ́máy: —Miyo̱mo, odoy cɨ̱ŋɨ. Tsa̱m iŋcupɨcpa iga Dios wɨa̱p micpɨs, jeeyucmɨ mipɨsneum. Jeet́i rato pɨsum jém yo̱mo. ");
INSERT INTO poiNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Cuando núc Jesús jém aŋjagooyi it́ɨccɨɨm, iix iga it́ jém susyajpaap iga nɨcpa icumta̱. Agui aŋyácneyaj jém pɨxiñt́am. Agui wejyajpa. Tsa̱m it́ bulla. ");
INSERT INTO poiNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Iñɨ́máy Jesús jém it́yajwɨɨp je̱m: —Mimicht́am puttaamɨ aŋsɨ̱cmɨ. D́a nunta caane yɨ́p wo̱ñi. Nada más moŋpa. Pero tsa̱m ixiccayajpa jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Cuando cupudayyaj, jesɨc tɨgɨy Jesús jém tɨcjo̱m. Imatsáy jém wo̱ñi icɨ, tsucum jém wo̱ñi. ");
INSERT INTO poiNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Jesɨc icuwɨ̱t́i jém naxyucmɨ jo̱dóŋa̱ta̱ t́i iwat jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesɨc nɨc Jesús. Nas ju̱t́ it́ wɨste̱n cácht́i. Moj it́úŋɨyyaj. Pɨ̱mi aŋwejyajpa. Nɨmyaj: —Mich mirey David mima̱nɨc, ayaachaŋja̱mɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Cuando tɨgɨyñe Jesús tu̱m tɨcjo̱m, tɨgɨyyajt́im jém cácht́i. Icunúcyaj Jesús. Jesɨc Jesús moj icwác jém cácht́i. Iñɨ́máy: —¿Que iŋcupɨctámpa iga ɨch awɨa̱p? Nɨmyaj jém cácht́iyaj: —¡Jɨ̱, mánO̱mi! ");
INSERT INTO poiNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jesɨc Jesús ichɨgáy iixcuy jém wɨste̱n cácht́i. Iñɨ́máy: —Sɨɨp maŋwadáypa je̱mpɨc porque mich tsa̱m iŋcupɨcpa iga Dios wɨa̱p miyo̱xpát. ");
INSERT INTO poiNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Jesɨc toj jém cácht́i iixcuy. Wɨ̱tsɨ́yum. Jesɨc duro iŋquímpa Jesús iga odoy i̱ iŋmadáyiñ. Iñɨ́máy: —Odoy i̱ aŋmadaayɨ iga manacpɨs. ");
INSERT INTO poiNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pero cuando nɨcneyaj jém cácht́ipɨc id́ɨc, iŋmadayyajpa i̱ quej t́i iwat Jesús icuwɨ̱t́i jém naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Cuando yaj nɨquiyaj jém cácht́iyaj, namíñayt́a̱ Jesús tu̱m u̱ma. Iniit́ tu̱m mal espíritu jém pɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Cuando tobayt́a̱ jém mal espíritu mojum jɨ̱yi jém u̱ma. Agui ipooñaŋja̱myaj jém it́yajwɨɨp je̱m. Nɨmyaj: —D́a queman tánix yɨcxpɨc cosa yɨ́p naxyucmɨ Israel. ");
INSERT INTO poiNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pero jém fariseoyaj tsa̱m jóyñeyaj. Nɨmyaj: —Yɨ́p pɨ̱xiñ wɨa̱p it́op jém mal espíritu porque iniit́ jém Woccɨɨwiñ ipɨ̱mi. ");
INSERT INTO poiNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Nɨc Jesús it́u̱mpɨy jém attebetyaj y jém tɨgaŋjoj. Accuyujóypa jém sinagoga ju̱t́ icuyujcayajpa jém Moisés iŋquímayooyi. Iŋmadáypa jém miññeyajwɨɨp jutsa̱p it́ɨgɨyyaj ju̱t́ iŋjacpa Dios. Icpɨs it́u̱mpɨy jém mɨmneyajwɨɨp y jém iniit́wɨɨp wa̱t́i jém caacuy. ");
INSERT INTO poiNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Pero cuando iix Jesús iga tsa̱m jáyaŋ miññeyaj, agui iyaachaŋja̱mpa porque tsa̱m yaacha̱neyaj, agui uuguyyajt́im juuts jém borregoyaj cuando d́a i̱ iwatne cuenta. ");
INSERT INTO poiNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Jesɨc iñɨ́máy Jesús jém icuyujcɨɨwiñ: —Nu̱ma, juuts tu̱m mɨjpɨc cosecha, tsa̱m jáyaŋ jém pɨxiñt́am icupɨctooba Dios, pero jém yo̱xacɨɨwiñ, jém iŋmatyajpáppɨc jém Dios iŋma̱t́i, d́a wa̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Jeeyucmɨ mannɨ́máypa, wágayt́aamɨ jém cosecha iO̱mi iga icutsad́iñ jáyaŋ jém yo̱xacɨɨwiñ iga ipiŋyajpa jém cosecha. ");
INSERT INTO poiNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesɨc Jesús iŋwejáy jém doce icuyujcɨɨwiñ. Ichi jém pɨ̱mi iga wɨa̱iñ it́opyaj jém mal espíritu y iga wɨa̱iñ icpɨsyaj it́u̱mpɨy jém mɨmneyajwɨɨp y jém imatsnewɨɨp caacuy. ");
INSERT INTO poiNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Yɨ́pyaj iñɨ̱yi jém doce icuyujcɨɨwiñ jém apóstolyaj: Wiñt́i jém Ximoj, iñɨ̱yit́im Peto; jém Anti, jém Peto it́ɨ̱wɨ; jém Jacobo, jém Zebedeo ima̱nɨc; jém Xiwan, jém Jacobo it́ɨ̱wɨ; ");
INSERT INTO poiNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","jém Felipe; jém Bartolo; jém Tomax; jém Mateo, jém ichécpaap id́ɨc impuesto; jém Jacobo, jém Alfeo ima̱nɨc; jém Tadeo; ");
INSERT INTO poiNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","jém Ximoj, jém it́wɨɨp con jém partido cananista; jém Judas Iscariote, jém iwadaypaap atraición Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesɨc Jesús icutsat jém doce icuyujcɨɨwiñ iga iŋmatyajiñ jém wɨbɨc aŋma̱t́i. Iñɨ́máy t́i wɨa̱p iwatyaj. Nɨ́mayyajta̱: —Odoy nɨctaamɨ ju̱t́ it́ jém tuŋgac pɨxiñt́am jém d́apɨc je de Israel. Odoy tɨgɨyt́aamɨ jém Samariapɨc iattebetyaj. ");
INSERT INTO poiNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Más wɨ̱ iga miñɨctámiñ ju̱t́ it́ jém Israelpɨc borregoyaj jém togoyñewɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Iganam miñɨcpa, aŋma̱tɨ iga noco it́ jém tiempo iga Dios iŋjacpa yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Acpɨstaamɨ jém cupúgayñewɨɨp iña̱ca con it́u̱mpɨy jém mɨmneyajwɨɨp. Acpɨstaamɨt́im jém caanewɨɨp. Tobayt́aamɨ jém mal espíritu jém iniit́wɨɨp jém pɨxiñt́am ia̱namaŋjo̱m. D́a mantségáy cuando manchiit́a ampɨ̱mi, jesɨc odoy tséctaamɨ cuando inicpɨspa. ");
INSERT INTO poiNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Odoy nanɨctaamɨ tumiñ; ni plata, ni oro, ni cobre imbolsajo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Odoy nanɨctaamɨ immorral, ni wɨste̱n iñyoot́i, ni tuŋgac iŋcɨac, ni imbastun, porque jém yo̱xacɨɨwiñ wɨ̱ iga chiit́a̱p jém iwíccuy. ");
INSERT INTO poiNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Cuando miñúctámpa tu̱m attebet o tu̱m xut́u tɨgaŋjoj, métstaamɨ tu̱m wɨbɨc pɨ̱xiñ ju̱t́ miñúctámpa. Jemum tsɨ́yt́aamɨ hasta que miñɨctámpa tuŋgac tɨgaŋjoj. ");
INSERT INTO poiNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Cuando mit́ɨgɨyt́ámpa tu̱m tɨcjo̱m, dioschi̱ɨ jém it́yajwɨɨp je̱m. Wágaayɨ Dios iga ichiiñ bendición. ");
INSERT INTO poiNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Siiga wɨbɨc pɨ̱xiñ it́yaj jém tɨcjo̱m, jesɨc Dios ichiiba jém bendición. Pero siiga malopɨc pɨ̱xiñ it́yaj jém tɨcjo̱m, jesɨc Dios d́a ichiiba bendición. ");
INSERT INTO poiNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Siiga d́a mipɨctsoŋpa ni d́a imatoŋtooba t́it́am iniŋmadáypa, jesɨc cuando miputtámpa jém tɨcjo̱m o jém tɨgaŋjoj, cunebaayɨ jém impuy ipótpót iga quejiñ iga d́a i̱ mipɨctsoŋ. ");
INSERT INTO poiNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nu̱ma mannɨ́máypa cuando núcpa jém ja̱ma iga Dios ichiiba castigo jém malopɨc, jesɨc más mɨjpɨc castigo chiit́a̱p jém d́apɨc ipɨctsoŋ ɨch anaŋquímayooyi que jém it́yajwɨɨp jém attebet de Sodoma y Gomorra. ");
INSERT INTO poiNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Amatoŋtaamɨ. Mimicht́am maŋcutsatpa juuts tu̱m miborrego ju̱t́ tsa̱m it́ jém pa̱jo. Wɨ̱ iga agui mijáyayaŋjɨ̱chɨch juuts tu̱m tsa̱ñ. Pero nait́t́aamɨ jém wɨbɨc jɨ̱xi juuts tu̱m cuucu d́apɨc malo. ");
INSERT INTO poiNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Nawattamta̱jɨ cuenta porque jém malopɨc pɨ̱xiñ tsa̱m mimatstooba, micɨɨjuŋcotpa jém Sanhedrín icɨɨjo̱m. Micótsta̱p jém sinagoga. ");
INSERT INTO poiNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Mininɨctamta̱p hasta jém más mɨjpɨc aŋjagooyicɨɨm hasta ju̱t́ it́ jém gobernador y hasta ju̱t́ it́ jém reyyaj ɨch aŋcuyucmɨ. Je̱mpɨgam wɨa̱p iniŋmadáy ɨch anaŋma̱t́i jém aŋjagooyiyaj y it́u̱mpɨy jém tuŋgacpɨc pɨxiñt́am jém d́apɨc je de Israel. ");
INSERT INTO poiNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Pero cuando mininɨctamta̱p jém aŋjagooyicɨɨm, odoy jɨ̱sɨ jutsa̱p iŋcutsoŋta jém aŋjagooyi o t́i iññɨ́máypa porque jeet́i rato Dios michiiba jɨ̱xi jutsa̱p iŋcutsoŋ jém aŋjagooyi. ");
INSERT INTO poiNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Cuando iŋcutsoŋpa d́a mimicht́am mijɨypa. Jɨypa jém Dios iA̱nama, michiiba jɨ̱xi, jesɨc wɨa̱p iŋcutsoŋ jém aŋjagooyi. ");
INSERT INTO poiNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Núcpa ja̱ma iga algunos iwadáypa atraición jém iñuntatɨ̱wɨ iga accaata̱iñ. Jém ja̱tuŋpɨc iwadáypat́im atraición jém ima̱nɨc. Jém ma̱nɨcpɨc iwadáypa atraición jém ija̱tuŋ o jém ia̱pa iga accaata̱iñ. ");
INSERT INTO poiNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","It́u̱mpɨy jém pɨxiñt́am tsa̱m mijóyixpa ɨch aŋcuyucmɨ. Pero siiga iñyaachɨ́ypa cuando miyaachwatta̱p y d́a iñchacpa ɨch anaŋma̱t́i hasta jém íŋaŋpɨgam ja̱ma, jesɨc micɨacputpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Cuando miyaachwatta̱p tu̱m attebet, jesɨc poyt́aamɨ, nɨctaamɨ tuŋgac attebet. Nu̱ma mannɨ́máypa iga antes que d́a yajpa iññasca jém tɨgaŋjoj de Israel, núcpa jém Miññewɨɨp Sɨŋyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Tu̱m maestro icuyujcɨɨwiñ d́a wɨa̱p iñasca jém imaestro. Tu̱m esclavo d́a wɨa̱p iñasca jém io̱mi. ");
INSERT INTO poiNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","It́um wɨ̱ siiga jém maestro icuyujcɨɨwiñ tsɨ́y juuts jém imaestro, siiga jém esclavo tsɨ́ypa juuts io̱mi. Siiga nɨ́mayt́a̱p jém ja̱tuŋpɨc iga Beelzebú, jesɨc malnɨ́mayt́a̱pt́im jém it́yajwɨɨp it́ɨccɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Odoy cɨ̱ŋtaamɨ jém malopɨc pɨxiñt́am. Dios iŋquejpa it́u̱mpɨy jém jɨ̱xi jém aŋyamnewɨɨp. Jo̱dóŋa̱ta̱p it́u̱mpɨy jém jɨ̱xi jém aŋnécnewɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","T́it́am manyamnɨ́máypa, mimicht́am aŋmattaamɨ jém pɨxiñt́ámaŋjo̱m. T́it́am manyamnɨ́máypa, aŋmattaamɨ ju̱t́quej iga imatoŋyajiñ it́u̱mpɨy jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Odoy cɨ̱ŋtaamɨ jém pɨ̱xiñ jém wɨa̱paap miccaáy jém immɨjta̱y porque jém íña̱nama d́a wɨa̱p miccaáy. Más wɨ̱ iga iŋcɨ̱ŋtámpa Dios jém wɨa̱paap miccaáy immɨjta̱y y jém íña̱nama icotpa jém juctjo̱m ju̱t́ d́a nunca píchpa. ");
INSERT INTO poiNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Mayt́a̱p wɨste̱n xuxut́ jon por tu̱m centavo, pero ni tu̱m de jém jonyaj d́a cutɨŋpa naxyucmɨ siiga jém tanJa̱tuŋ Dios d́a ijɨ́cpa. ");
INSERT INTO poiNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Dios imayñe it́u̱mpɨy jém iŋway jute̱n iniit́ jém iŋco̱bacyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Jeeyucmɨ mannɨ́máypa, odoy cɨ̱ŋtaamɨ. Más mit́oypa Dios que jém xuxut́ jonyaj. ");
INSERT INTO poiNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’It́u̱mpɨy jém iŋmatyajpáppɨc jém pɨxiñt́ámaŋjo̱m iga acupɨcpa, jesɨc ampɨctsoŋpa sɨŋyucmɨ jém anJa̱tuŋ Dios iwiñjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pero siiga tu̱m pɨ̱xiñ iŋnécpa iga acupɨcpa jém pɨxiñt́ámaŋjo̱m, jesɨc d́a ampɨctsoŋpa sɨŋyucmɨ jém anJa̱tuŋ Dios iwiñjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Odoy jɨ̱sɨ iga amiñ yɨ́p naxyucmɨ iga anaŋjɨyjacpa jém áŋa̱yajpáppɨc. D́a anamiñ jém paz, anamiñ jém espada. Ɨch aŋcuyucmɨ tsa̱m áŋa̱yajpa yɨ́p naxyucmɨpɨc. ");
INSERT INTO poiNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ɨch miñ anactsucum iga áŋa̱yajiñ tu̱m pɨ̱xiñ con ija̱tuŋ, iga áŋa̱yajpa tu̱m yo̱mo con ia̱pa, iga tuŋgac yo̱mo áŋa̱yajpa con ixa̱qui. ");
INSERT INTO poiNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Jém it́yajwɨɨp iñt́ɨcjo̱m tsɨ́yyajpa iga íñenemigoyaj. ");
INSERT INTO poiNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Siiga más iñt́oypa iñja̱tuŋ o íña̱pa que antoypa aɨch, d́a wɨa̱p iñchɨ́y juuts ɨch mammɨɨchi. Siiga más iñt́oypa jém iñjayma̱nɨc o iñyo̱mma̱nɨc que antoypa aɨch, d́a wɨa̱p iñchɨ́y juuts ɨch mammɨɨchi. ");
INSERT INTO poiNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Jém d́apɨc ijɨ́cpa iga yaachwatta̱p juuts ɨch ayaachwatta̱p y atúŋɨ́ypa, d́a tsɨ́ypa juuts ɨch ammɨɨchi. ");
INSERT INTO poiNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Siiga tu̱m pɨ̱xiñ tsa̱m ijɨ̱spa jém ivida iga odoy togóyiñ, jesɨc togoypa jém ivida. Pero siiga togoy tu̱m pɨ̱xiñ ivida ɨch aŋcuyucmɨ, jesɨc iniit́pa jém ivida. ");
INSERT INTO poiNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Jém mipɨctsoŋpaap mimicht́am, apɨctsoŋpat́im aɨch. Jém apɨctsoŋpaap aɨch, ipɨctsoŋpat́im jém anJa̱tuŋ Dios jém acutsatnewɨɨp yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Jém ipɨctsoŋpaap tu̱m jém Dios iŋmat́cɨɨwiñ porque icutsat Dios tienes que ipɨctsoŋpat́im jexpɨct́im coñwɨyooyi juuts ipɨctsoŋpa jém Dios iŋmat́cɨɨwiñ. Jém ipɨctsoŋpaap tu̱m wɨbɨc pɨ̱xiñ iga iwɨ̱wadáypa, je tienes que ipɨctsoŋpat́im jexpɨct́im coñwɨyooyi juuts ipɨctsoŋpa jém wɨbɨc pɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Siiga i̱ ichiiba tu̱m taza pagac nɨ tu̱m jém aŋcuyujcɨɨwiñ ɨch aŋcuyucmɨ, nu̱ma mannɨ́máypa iga je ipɨctsoŋpa tu̱m wɨbɨc coñwɨyooyi. ");
INSERT INTO poiNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesɨc cuando yaj iñɨ́máy Jesús jém doce icuyujcɨɨwiñ t́i wɨa̱p iwatyaj, moj nɨqui Jesús. Nɨc iŋquejáy jém pɨxiñt́am it́u̱mpɨy jém attebetyaj jém naxyucmɨ de Galilea. Iŋmadáy jém Dios iŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jém Xiwan jém acchíŋoypaap pajneta̱ cárcel. Cuando imatoŋ t́i iwat jém tánO̱mi Cristo, jesɨc icutsat wɨste̱n jém icuyujcɨɨwiñ iga nɨguiñ icwácyaj Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Cuando núcyaj ju̱t́ it́ Jesús, moj icwácyaj. Nɨmyaj: —¿Que micham jém miCristo jém miñpaap yɨ́p naxyucmɨ o anaŋjóctámpa tuŋgac? ");
INSERT INTO poiNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesús icutsoŋ. Iñɨ́máy: —Nɨ̱gɨ nɨ́maayɨ jém Xiwan t́i íñixñeta y t́i immatoŋneta. ");
INSERT INTO poiNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Aŋmadayt́aamɨ iga ixixóypam jém cácht́i, wit́pam jém cu̱xujpɨc id́ɨc, pɨsneum jém cupúgayñewɨɨp id́ɨc iña̱ca, matóŋóypam jém chajca, pɨsneum jém caaneyajwɨɨp id́ɨc y jém yaacha̱yajpaap ipɨctsoŋyaj jém wɨbɨc aŋma̱t́i iga Dios icɨacputpa. ");
INSERT INTO poiNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Agui maymay jém pɨ̱xiñ jém d́apɨc ijɨ́cpa iga i̱ ictsacpa ɨch anaŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Cuando nɨcyaj jém Xiwan icuyujcɨɨwiñ, jesɨc jém Jesús moj iŋmadáy jém pɨxiñt́am iga wɨbɨc aŋmat́cɨɨwiñ jém Xiwan. Nɨ́mayyajta̱: —¿T́i oy íñámta jém tɨtsɨnaxyucmɨ? ¿Que oy íñámta tu̱m pɨ̱xiñ d́apɨc wɨa̱p juuts tu̱m po̱c jém aguipɨc ictsɨgóypa sa̱wa? D́a je. Oy íñámta tu̱m pɨ̱xiñ wɨa̱paap. ");
INSERT INTO poiNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Que oy íñámta tu̱m pɨ̱xiñ agui wɨ̱cuyajne? D́a je. Tanjo̱doŋtam iga jém wɨ̱cuyajnewɨɨp it́yaj jém rey it́ɨccɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Que t́i oy íñámta jém tɨtsɨnaxyucmɨ? ¿Que oy íñámta tu̱m Dios iŋmat́cɨɨwiñ? Nu̱ma tu̱m aŋmat́cɨɨwiñ más wɨa̱p que it́u̱mpɨy jém wiñɨcpɨc aŋmat́cɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Nɨmpa jém Dios iŋma̱t́i t́i iwatpa jém Xiwan: Dios icutsatpa tu̱m aŋmat́cɨɨwiñ iga iwɨ̱tsagáypa jém Cristo it́uŋ. Jém aŋmat́cɨɨwiñ aŋjagoyñeeba iñɨc. Ocmɨ it́uuñiaŋcɨɨm miñpa jém Cristo. ");
INSERT INTO poiNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nu̱ma mannɨ́máypa iga icuwɨ̱t́i yɨ́p naxyucmɨ d́a i̱ tuŋgac pɨ̱xiñ más wɨa̱p que jém Xiwan jém acchíŋoypaap. Pero cuando núc jém tiempo iga iŋjacpa Dios, jém más xut́upɨc jém Dios ipɨxiñt́am más wɨa̱p que jém Xiwan. ");
INSERT INTO poiNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Dende núc jém Xiwan, jém acchíŋoypaap, hasta sɨɨp jém pɨxiñt́am tsa̱m tɨgɨyyajtooba pɨ̱mi̱mɨ ju̱t́ iŋjacpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Jém Moisés iŋquímayooyi con it́u̱mpɨy jém wiñɨcpɨc aŋmat́cɨɨwiñ iŋmatyaj t́i miñpa. Cuando núc jém Xiwan, moj iccupac t́i nɨm jém aŋmat́cɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Yɨ́p Xiwan, jém acchíŋoypaap, jeet́im jém Elías jém miñpáppɨc; siiga micht́am iŋcupɨcpa. ");
INSERT INTO poiNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Siiga mit́atsɨgɨyt́a, matoŋtaamɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’Sɨɨp manaŋquejáypa juuts t́i jém pɨxiñt́am jém it́yajwɨɨp sɨɨp. Jex juuts jém tsɨ̱xt́am jém mɨ̱chyajpáppɨc plaza. Iñɨ́mayyajpa jém iamigoyaj: ");
INSERT INTO poiNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Mansusáypa jém flauta, pero d́a mietstámpa. Ocmɨ maŋwánáypa jém wa̱ñi aŋyácnewɨɨp, pero d́at́im miwejtámpa.” ");
INSERT INTO poiNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Porque cuando miñ jém Xiwan, d́a icútpa caxt́ána̱ñi ni d́a iucpa vino, pero mimicht́am miñɨmtámpa iga iniit́ tu̱m mal espíritu. ");
INSERT INTO poiNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ocmɨ ɨch anyaac amiñ sɨŋyucmɨ. Awícpa, ánucpa jém vino, pero mimicht́am miñɨmtámpa iga tsa̱m awícpa, tsa̱m ánucpa jém vino y tsa̱m ánamigo jém malopɨc pɨxiñt́am con jém ichécyajpaap impuesto. Quejpa iga wɨ̱ jém jɨ̱xi siiga wɨ̱putpa jém yo̱xacuy. ");
INSERT INTO poiNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jesɨc jém Jesús moj iwogáy jém it́yajwɨɨp jém attebetyaj ju̱t́ oy iwat jáyaŋ jém milagro porque jeeyaj d́a ichacyaj iga imalwatyajpa. Nɨmpa Jesús: ");
INSERT INTO poiNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—¡Agui miuuguyt́im mimicht́am miit́wɨɨp jém attebet Corazín! Agui miuuguyt́im mimicht́am miit́wɨɨp jém attebet Betsaida. Jém it́yajwɨɨp jém attebet Tiro y Sidón d́a iixñeyaj jém milagroyaj juuts sɨɨp íñix. Pero meega iixñeyaj, pecam ichacneyaj jém imalajɨ̱xi, agui aŋyácneyaj iga táŋcaɨ́y. ");
INSERT INTO poiNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Jeeyucmɨ mannɨ́máypa, cuando núcpa jém ja̱ma iga Dios icɨɨpiŋpa yɨ́p naxyucmɨpɨc pɨxiñt́am, jesɨc más pɨ̱mi michiit́a̱p castigo mimicht́am que jém it́yajwɨɨp jém attebet Tiro y Sidón. ");
INSERT INTO poiNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Mimicht́am miit́wɨɨp jém attebet Capernaum tsa̱m micujípyajpa jém pɨxiñt́am, pero tienes que mininɨctamta̱p jém piichcɨɨm ju̱t́ it́ jém caaneyajwɨɨp. Porque meega aŋwatne jém milagro jém attebet Sodoma juuts aŋwatne mimicht́ámaŋjo̱m, jesɨc d́a id́ɨc togoypa jém attebet hasta sɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nu̱ma mannɨ́máypa iga cuando núcpa jém ja̱ma iga cɨɨpíŋóypa Dios, más pɨ̱mi michiit́a̱p castigo mimicht́am que jém it́yajwɨɨp jém attebet Sodoma. ");
INSERT INTO poiNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Jesɨc jém tiempo nɨm Jesús: —ManJa̱tuŋ Dios, mich iniŋjacne jém sɨŋ y jém nas, tsa̱m maŋcujíppa. Mich iniŋnéc jém wɨbɨc jɨ̱xi iga jém tsa̱mpɨc icutɨɨyɨyyajpa yɨ́p naxyucmɨpɨc jɨ̱xi d́a wɨa̱p icutɨɨyɨ́y. Pero iniŋquejayñe jém wɨbɨc jɨ̱xi jém pɨxiñt́am jém d́apɨc icuyujcaneyaj yɨ́p naxyucmɨpɨc jɨ̱xi. ");
INSERT INTO poiNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Je̱mpɨgam iŋwat, manJa̱tuŋ Dios, porque je̱mpɨgam iŋwɨ̱aŋja̱m. ");
INSERT INTO poiNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Jesɨc Jesús iñɨ́máy jém pɨxiñt́am: —Jém anJa̱tuŋ Dios acɨɨjuŋcodáy it́u̱mpɨy jém wɨ̱tampɨc jɨ̱xi. D́a i̱ ijo̱doŋ jém Dios iMa̱nɨc ijɨ̱xi, icut́um ijo̱doŋ jém iJa̱tuŋ t́i ijɨ̱spa iMa̱nɨc. D́at́im i̱ ijo̱doŋ jém anJa̱tuŋ Dios ijɨ̱xi, icut́um ijo̱doŋ jém iMa̱nɨc con jém pɨxiñt́am jém iwɨ̱aŋja̱mpáppɨc iMa̱nɨc iga icjo̱dóŋa̱p jém Dios ijɨ̱xi. ");
INSERT INTO poiNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Miñt́aamɨ yɨɨm iñt́u̱mpɨyt́am mimicht́am jém tsa̱mpɨc miyo̱xane, jém tsa̱mpɨc michɨɨma̱ne, manacjejpa. ");
INSERT INTO poiNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Pɨctsoŋtaamɨ jém yugo jém ɨchpɨc manchiiba iga tawagayo̱xa̱p. Cuyujcataamɨ ɨch anaŋquímayooyi porque je d́a táŋca. Ɨch d́a malo ána̱nama. Manyo̱xpátpa. Impáttámpa ju̱t́ wɨa̱p ijej jém íña̱nama. ");
INSERT INTO poiNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ɨch anyugo d́a táŋca. Ɨch antsɨ̱mi xejcɨy. ");
INSERT INTO poiNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Jesɨc tu̱m jejcuy ja̱ma wid́aŋnaspa Jesús ju̱t́ ñipneta̱ jém trigo. Jém icuyujcɨɨwiñ como tsa̱m yua̱neyaj, moj iju̱dayyaj jém trigo ipac, icútyaj. ");
INSERT INTO poiNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Pero cuando jém fariseoyaj iixyaj t́i iwatyaj jém Jesús icuyujcɨɨwiñ, nɨ́mayt́a̱ jém Jesús: —I̱xɨ jém iŋcuyujcɨɨwiñ. ¿T́iiga iwatyajpa contra jém tanaŋquímayooyi jém jejcuy ja̱ma? ");
INSERT INTO poiNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesɨc Jesús iñɨ́máy jém fariseoyaj: —¿Que d́a queman immay t́i iwat jém David cuando tsa̱m yua̱neyaj con jém icompañeroyaj? ");
INSERT INTO poiNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Tɨgɨyyaj jém Dios it́ɨcjo̱m. Icútyaj jém caxt́ána̱ñi jém tsacneta̱wɨɨp altaryucmɨ. Tanjo̱doŋ iga jém tanaŋquímayooyi d́a ijɨ́cpa iga icútyajpa jém David ni jém iwaganamiññewɨɨp. Nada más jém pa̱nij wɨa̱p icútyaj. ");
INSERT INTO poiNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Que d́a immayñe junɨmpa jém Moisés iŋquímayooyi iga jém pa̱nij d́a jejyajpa cuando yo̱xayajpa jém mɨjpɨc ma̱stɨcjo̱m jém jejcuyja̱ma? Pero d́a táŋcawatpa siiga d́a jejyajpa. ");
INSERT INTO poiNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nu̱ma mannɨ́máypa iga jém it́wɨɨp yɨɨm con mimicht́am más mɨj que jém mɨjpɨc ma̱stɨc. ");
INSERT INTO poiNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Mimicht́am d́a iŋcutɨɨyɨyt́a t́i nɨmpa jém aŋma̱t́i ju̱t́ jaychacneta̱. Nɨmpa: “Más iwɨ̱aŋja̱m Dios iga iñyaachaŋja̱mtámiñ jém iñt́ɨ̱wɨtam que iniccaaba jém ani̱mat iga iñchiiba ofrenda jém altaryucmɨ.” Meega iŋcutɨɨyɨ́ypa, jesɨc d́a iñchiiba castigo jém pɨxiñt́am jém d́apɨc t́i iwatne. ");
INSERT INTO poiNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ɨch, jém aMiññewɨɨp Sɨŋyucmɨ, wɨa̱p anaŋquejáy jém pɨxiñt́am t́i wɨa̱p iwat jém jejcuyja̱ma porque anait́ jém autoridad. ");
INSERT INTO poiNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jesɨc nɨc Jesús, tɨgɨy jém sinagoga ju̱t́ icuyujcayajpa jém Moisés iŋquímayooyi. ");
INSERT INTO poiNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Je̱m it́ tu̱m pɨ̱xiñ tɨtsnewɨɨp icɨ. Jesɨc jém fariseoyaj icwácyaj jém Jesús. Nɨ́mayt́a̱: —¿Que wɨ̱ iga tanacpɨspa tu̱m pɨ̱xiñ jém jejcuyja̱ma? Porque tsa̱m imétsyajpa jutsa̱p iquejajwadayyaj jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesɨc icutsoŋ Jesús. Iñɨ́máy: —Siiga tu̱m de mimicht́am iniit́ tu̱m borrego actɨŋne josjo̱m tu̱m jejcuyja̱ma, ¿que d́a iñt́oppa jeet́i rato? ");
INSERT INTO poiNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Tu̱m pɨ̱xiñ más wɨ̱ que jém borrego. Jesɨc quejpa iga wɨ̱ iga taŋwɨ̱watpa jém jejcuyja̱ma. ");
INSERT INTO poiNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Jesɨc iñɨ́máy jém pɨ̱xiñ jém tɨtsnewɨɨp icɨ: —Tɨ̱mɨ iŋcɨ. Jesɨc it́ɨ̱m icɨ. Wɨ̱tsɨ́yum juuts jém tuŋgac jém icɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Jesɨc putyaj jém fariseoyaj. Moj ijɨ̱syaj jutsa̱p iccaayaj jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Cuando ijo̱dóŋa̱ Jesús t́i ijɨ̱syajpa, jesɨc nɨc. Jáyaŋ jém pɨxiñt́am it́úŋɨyyajpa. Icpɨs it́u̱mpɨy jém mɨmneyajwɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ipɨɨmɨ́y Jesús iga odoy i̱ iŋmadayyajiñ i̱apaap icpɨsne. ");
INSERT INTO poiNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Iwat je̱mpɨc iga cupacpa juuts nɨm jém wiñɨcpɨc aŋmat́cɨɨwiñ jém Isaías: ");
INSERT INTO poiNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Yɨ́bam jém acuyo̱xapaap, jém aŋcupiŋnewɨɨp. Tsa̱m antoypa, tsa̱m amaymay con je. Anchiiba ánA̱nama iga inisɨɨba. Iŋmadáypa jém tuŋgac pɨxiñt́am jém d́apɨc je de Israel iga: Ɨch aŋwɨ̱tsagáypa jém it́áŋca. ");
INSERT INTO poiNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","D́a áŋa̱pa, d́at́im pɨ̱mi jɨypa. D́a i̱ imatoŋpa iga najɨ́yóypa calle. ");
INSERT INTO poiNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Jém acuyo̱xapaap agui wɨa̱p. D́a iquit́pa tu̱m xut́u waycuy jém quit́páppɨc, pero más iwɨ̱tsacpa. D́at́im icpíchpa jém me̱chaj jém yaguiñpɨc juctɨmatsne. Pɨ̱mi yo̱xa̱p hasta que icoñwɨ́ypa jém ienemigoyaj. ");
INSERT INTO poiNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Jém tuŋgac pɨxiñt́am icuwɨ̱t́i yɨ́p naxyucmɨ tsa̱m icupɨcyajpa iga jém acuyo̱xapaap wɨa̱p iyo̱xpátyaj. ");
INSERT INTO poiNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Jesɨc namíñayt́a̱ Jesús tu̱m pɨ̱xiñ jém imatsnewɨɨp tu̱m mal espíritu. Cácht́i jém pɨ̱xiñ, u̱maa̱ne. Icpɨs Jesús. Jesɨc ixixóypam, wɨa̱bam ijɨy. ");
INSERT INTO poiNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","It́u̱mpɨy jém it́yajwɨɨp je̱m agui ipooñaŋja̱myaj cuando iixyaj t́i iwat Jesús. Nɨmyaj: —¿Tánaŋja̱m yɨ́bam jém rey David io̱cma̱nɨc? ");
INSERT INTO poiNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pero cuando jém fariseoyaj imatoŋyaj t́i iwat jém Jesús, pɨ̱mi jóyñeyaj. Nɨmyaj: —Yɨ́p pɨ̱xiñ wɨa̱p it́op jém mal espíritu porque iniit́ jém Beelzebú ipɨ̱mi, jém mal espíritu iŋjagooyi. ");
INSERT INTO poiNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Pero ijo̱doŋ Jesús t́i sɨ́p ijɨ̱syaj jém pɨxiñt́am. Iñɨ́máy: —Siiga tu̱m gobierno nawécyajta̱p y áŋa̱yajpa entre jeeyaj, jesɨc tienes que nayajyajta̱p. Siiga nawécyajta̱p tu̱m attebet y tsa̱m áŋa̱yajpa jém pɨxiñt́am, d́a jáypa cuyajpat́im. Siiga nawécyajta̱p jém it́yajwɨɨp tu̱m tɨccɨɨm, jesɨc cuyajpat́im. ");
INSERT INTO poiNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Jesanet́im siiga jém Woccɨɨwiñ natopta̱p iyaac jém pɨ̱xiñ ia̱namaŋjo̱m, jesɨc nawécta̱p iyaac jém Woccɨɨwiñ. D́a jáyñe cuyajpa jém ipɨ̱mi. ");
INSERT INTO poiNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Micht́am miñɨmtámpa iga ɨch antoppa jém mal espíritu con jém Beelzebú ipɨ̱mi. Siiga nu̱ma aŋwatpa je̱mpɨc, ¿jesɨc i̱ ichiiba ipɨ̱mi mich iŋcuyujcɨɨwiñ iga wɨa̱iñ it́op jém mal espíritu? Cuando iwatpa je̱mpɨc, jém iŋcuyujcɨɨwiñ miŋquejáypa iga togoyñe iñjɨ̱xi. ");
INSERT INTO poiNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Pero siiga ɨch antoppa jém mal espíritu con Dios iA̱nama, jesɨc quejpa iga nu̱ma núcneum jém tiempo iga Dios iŋjacpa yɨ́p naxyucmɨ. Mimicht́am wɨa̱pt́im impɨctsoŋta. ");
INSERT INTO poiNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Jém númpaap d́a wɨa̱p it́ɨgɨy tu̱m pɨ̱mipɨc pɨ̱xiñ it́ɨcjo̱m iga icunúmáypa siiga d́a wiñt́i ichenpa jém tɨc io̱mi. Pero siiga wiñt́i ichenpa, jesɨc wɨa̱p iñúmáy it́u̱mpɨy jém iniit́wɨɨp it́ɨccɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Jém d́apɨc acuyo̱xa̱p it́ en contra de aɨch. Jém d́apɨc ayo̱xpátpa iga anaŋtuuma̱watpa jém pɨxiñt́am, je iquepquebáypa. ");
INSERT INTO poiNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Jeeyucmɨ mannɨ́máypa iga Dios iwadáypa perdón jém pɨxiñt́am it́u̱mpɨy jém it́áŋca. Wadayt́a̱pt́im perdón jém pɨxiñt́am siiga icujɨypa tanJa̱tuŋ Dios, pero siiga i̱ icujɨypa jém Dios iA̱nama, d́a i̱ wɨa̱p iwadáy perdón jém it́áŋca. ");
INSERT INTO poiNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Dios acutsat yɨ́p naxyucmɨ iga aŋcuyo̱xa̱p Dios. Siiga i̱ amalnɨ́máypa aɨch, jesɨc Dios wɨa̱p iwadáy perdón jém it́áŋca. Pero siiga i̱ imalnɨ́máypa jém Dios iA̱nama, d́a i̱ wɨa̱p iwadáy perdón jém it́áŋca ni yɨ́p naxyucmɨ ni jém tuŋgac jém miñpaap. ");
INSERT INTO poiNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Siiga wɨbɨc cuy, iwatpa wɨbɨc it́ɨm. Siiga malopɨc cuy, iwatpa malopɨc it́ɨm. Tánixpɨcpa jém cuy por it́ɨm. ");
INSERT INTO poiNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Micht́am mijex juuts jém tsa̱ñ iga agui mimalo. ¿Jutsa̱p iniŋmat jém wɨ̱tampɨc cosa siiga tsa̱m mimalotam? Jém aŋma̱t́i jém iñt́oppáppɨc iñjɨpjo̱m, tsucumpa íña̱namaŋjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Jém wɨbɨc pɨ̱xiñ iŋmatpa jém wɨ̱tampɨc cosa porque comne ia̱namaŋjo̱m con jém wɨbɨc jɨ̱xi. Jém malopɨc pɨ̱xiñ iŋmatpa jém malopɨc cosa porque comne ia̱namaŋjo̱m con jém malopɨc jɨ̱xi. ");
INSERT INTO poiNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Sɨɨp mannɨ́máypa mimicht́am, cuando núcpa jém ja̱ma iga Dios icɨɨpiŋpa it́u̱mpɨy jém pɨxiñt́am, jesɨgam tségayt́a̱p it́u̱mpɨy jém malopɨc aŋma̱t́i jém iŋmatnewɨɨp aunque d́a juchaŋ. ");
INSERT INTO poiNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Con jém iniŋma̱t́i micɨɨpiŋta̱p, con jeet́im iniŋma̱t́i miŋquejpa siiga mit́áŋcaɨ́y o d́a mit́áŋcaɨ́y. ");
INSERT INTO poiNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Jesɨc algunos jém fariseoyaj con jém escribaspɨc maestroyaj iwágayyaj tu̱m milagro. Nɨ́mayt́a̱ Jesús: —Maestro, ánixt́ooba tu̱m milagro, awadayt́aamɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesɨc Jesús iñɨ́máy: —Jém malopɨc pɨxiñt́am, jém it́yajwɨɨp sɨɨp jém d́apɨc icupɨcyajpa Dios, tsa̱m awágáypa milagro. Pero no más tu̱m milagro iwadáypa Dios, jém milagro juuts iñasca jém Jonás. ");
INSERT INTO poiNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Juuts jém Jonás oy iyaj tucunaja̱ma y tucunatsuu jém mɨjpɨc tɨɨpɨ ipuujo̱m, jesa̱pt́im aɨch, jém aMiññewɨɨp Sɨŋyucmɨ, acumta̱p, anyajpa tucunaja̱ma y tucunatsuu jém nascɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Núcpa ja̱ma iga jém it́yajwɨɨp jém attebet Nínive tsucumyajpa jém íŋaŋpɨgam ja̱ma iga miquejajwadayt́ámpa mimicht́am, miit́t́aŋwɨɨp cuando Dios icɨɨpiŋpa it́u̱mpɨy jém pɨxiñt́am. Porque jém it́yajwɨɨp Nínive icucacyaj ijɨ̱xi cuando jém Jonás iŋmadáy jém Dios iŋma̱t́i. Yɨɨm it́ con mimicht́am tu̱m pɨ̱xiñ más wɨa̱p que jém Jonás. ");
INSERT INTO poiNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Tsucumpat́im jém yo̱mpɨc aŋjagooyi jém miññewɨɨp aŋtsapsa̱umɨ jém íŋaŋpɨgam ja̱ma cuando Dios icɨɨpiŋpa it́u̱mpɨy jém pɨxiñt́am. Miquejajwadayt́ámpat́im porque juumɨ miñ jém yo̱mo. Miñ imatoŋ jém Salomón ijɨ̱xi, pero yɨɨm it́ con mimicht́am tu̱m más mɨjpɨc aŋjagooyi que jém Salomón. ");
INSERT INTO poiNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Cuando put jém mal espíritu tu̱m pɨ̱xiñ ia̱namaŋjo̱m, jesɨc sɨɨba icut́um jém tɨtsɨnaxyucmɨ. Imétspa tu̱m lugar ju̱t́ jejpa. Pero d́a ipátpa. Jesɨc nɨmpa: ");
INSERT INTO poiNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“E̱ybɨct́im ase̱tpa antɨccɨɨm ju̱t́ aput.” Jesɨc mu ixe̱t, e̱ybɨc ipát jém pɨ̱xiñ juuts tu̱m tɨc d́a oomɨ́y, petneta̱wum, wɨ̱tsacneta̱wum. ");
INSERT INTO poiNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Jesɨc inimiñ siete espíritu más pɨ̱mi malo. Miñ i̱t́iyaj jém pɨ̱xiñ ia̱namaŋjo̱m. Wiñt́i jém pɨ̱xiñ iniit́ id́ɨc nada más tu̱m mal espíritu, pero ocmɨ más pɨ̱mi malo jém pɨ̱xiñ. Je̱mpɨgam iñascaaba jém malopɨc pɨxiñt́am jém it́yajwɨɨp sɨɨp. Más pɨ̱mi maloja̱p. ");
INSERT INTO poiNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Iganam sɨ́p iŋmat Jesús, núcyaj ia̱pa con ijáyuctam. Tsɨ́yyaj aŋsɨ̱cmɨ. Ijɨypáttooba Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Tu̱m pɨ̱xiñ iñɨ́máy Jesús: —Miññe jém íña̱pa con iñt́ɨ̱wɨtam, it́yaj aŋsɨ̱cmɨ. Mijɨypáttooba. ");
INSERT INTO poiNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jesɨc Jesús iñɨ́máy jém pɨ̱xiñ jém iŋmadayñewɨɨp iga miññe ia̱pa: —¿Pero i̱ jém ána̱pa? ¿I̱ jém antɨ̱wɨtam? ");
INSERT INTO poiNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Jesús iquij icɨɨmɨ jém icuyujcɨɨwiñ, iñɨ́máy: —Mimicht́am jém mána̱pa y mantɨ̱wɨtam. ");
INSERT INTO poiNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Porque it́u̱mpɨy jém iwatpaap juuts ixunpa jém anJa̱tuŋ Dios jém it́wɨɨp sɨŋyucmɨ, jeam jém antɨ̱wɨ, jém anyo̱mtɨ̱wɨ y jém ána̱pa. ");
INSERT INTO poiNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Jesɨc jeet́im ja̱ma put Jesús jém tɨcjo̱m. Nɨc co̱ñi je̱m laguna aŋna̱ca. ");
INSERT INTO poiNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tsa̱m jáyaŋ pɨxiñt́am aŋtuuma̱neyaj ju̱t́ it́ Jesús. Jeeyucmɨ tɨgɨy tu̱m barcojo̱m, jemum co̱ñ. It́u̱mpɨy jém miññeyajwɨɨp tsɨ́yyaj jém laguna aŋna̱ca. ");
INSERT INTO poiNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Jesɨc Jesús moj iŋquejáy jáyaŋ jém wɨbɨc jɨ̱xi por medio de cuento. Nɨmpa: —Tu̱m pɨ̱xiñ nɨc ñi̱pi. Nɨc iyɨ̱n jém trigo ipac ica̱mjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Mu iyɨ̱n jém pac, actɨŋ uxaŋ jém tuŋjo̱m. Miñyaj jém jon, icútquet jém pac. ");
INSERT INTO poiNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Actɨŋt́im uxaŋ jém pac tsaaŋjo̱m ju̱t́ d́a i̱ jáyaŋ nas. Jesɨc jicscɨy nay jém pac porque d́a juchaŋ jém nas. ");
INSERT INTO poiNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Cuando pijpa jém ja̱ma, iñoonoca jém xuxut́ planta. Yaj cutɨ́tsaayiyaj porque d́a t́i̱chɨgɨ́y. ");
INSERT INTO poiNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Actɨŋt́im uxaŋ jém pac jém a̱pid́aŋjo̱m. Jicscɨy yón jém a̱pit́, ixamsamca jém xuxut́ planta. ");
INSERT INTO poiNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pero actɨŋt́im jém pac jém wɨbɨc naxyucmɨ. Wɨ̱tɨ́ma̱. Algunos chióy cien, algunos chióy sesenta, algunos chióy treinta. ");
INSERT INTO poiNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Siiga mit́a̱tsɨgɨyt́a, amatoŋtaamɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jesɨc icunúcyaj Jesús jém icuyujcɨɨwiñ, icwácyaj. Nɨ́mayt́a̱: —¿T́iiga iniŋmadáypa jém pɨxiñt́am por medio de cuento? ");
INSERT INTO poiNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesɨc Jesús icutsoŋ. Iñɨ́máy: —Dios miyo̱xpáttámpa mimicht́am iga wɨa̱p iŋcutɨɨyɨyt́a jutsa̱p iŋjac Dios yɨ́p naxyucmɨ. Mimicht́am micjo̱dóŋa̱ta jém jɨ̱xi aŋnécnewɨɨp id́ɨc, pero los demás d́a wɨa̱p icutɨɨyɨyyaj. ");
INSERT INTO poiNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Jém ipɨctsoŋpaap jém Dios iŋma̱t́i, más ichiiba Dios jáyaŋ wɨbɨc cosa. Pero jém d́apɨc iwɨ̱pɨctsoŋpa jém Dios iŋma̱t́i, d́a t́i ichiiba Dios, más accáyayt́a̱p jém cosa jém ijɨ̱spaap iga iniit́. ");
INSERT INTO poiNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Jeeyucmɨ anaŋquejáypa jém pɨxiñt́am por medio de cuento. Iixyaj, pero tsɨ́yyaj juuts d́a iixyaj. Imatoŋyaj, pero tsɨ́yyaj juuts d́a imatoŋyaj ni d́at́im icutɨɨyɨyyaj. ");
INSERT INTO poiNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Iñascayajpa juuts nɨmpa jém wiñɨcpɨc aŋmat́cɨɨwiñ jém Isaías: Mimicht́am nu̱ma immatoŋtámpa, pero d́a iŋcutɨɨyɨyt́ámpa. Nu̱ma íñixt́ámpa, pero d́a iŋcupɨctámpa. ");
INSERT INTO poiNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Porque yɨ́pyaj pɨxiñt́am tsa̱m malo ia̱namayaj, d́a matóŋóypa jém it́a̱tsɨc, iŋmichñeyaj jém iixcuy. Iwatyajpa je̱mpɨc porque d́a ixixoyt́ooba, d́a matóŋoyt́ooba, d́a ijɨ̱spa ia̱namaŋjo̱m iga tsa̱m jáyaŋ mal iwatneyaj iga ichaguiñ jém malatuŋ iga ɨch aŋwɨ̱tsagáyiñ jém it́áŋca. ");
INSERT INTO poiNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Pero sɨɨp mimicht́am agui mimaymayt́am porque miixixóypa y mimatóŋóypa. ");
INSERT INTO poiNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nu̱ma mannɨ́máypa iga wa̱t́i jém wiñɨcpɨc aŋmat́cɨɨwiñ y jém tuŋgac wɨbɨc pɨxiñt́am tsa̱m iixyajtooba t́it́am íñixt́ámpa mimicht́am, pero d́a wɨa̱. Tsa̱m imatoŋyajtooba t́it́am immatoŋtámpa, pero d́a wɨa̱. ");
INSERT INTO poiNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Nɨmpa Jesús: —Matoŋtaamɨ t́i nɨmtooba jém cuento cuando jém pɨ̱xiñ iyɨ̱npa jém pac ica̱mjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Jém imatoŋpaap jém wɨbɨc aŋma̱t́i jutsa̱p iŋjac Dios yɨ́p naxyucmɨ, pero d́a icutɨɨyɨ́ypa, jex juuts jém pac jém actɨŋnewɨɨp tuŋjo̱m. Miñpa jém Woccɨɨwiñ, iccáyáypa jém wɨbɨc jɨ̱xi jém ñipneta̱wɨɨp jém pɨ̱xiñ ia̱namaŋjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Jém pac, jém actɨŋnewɨɨp jém tsaaŋjo̱m, jex juuts jém pɨ̱xiñ cuando imatoŋpa jém wɨbɨc aŋma̱t́i, agui maymay mu ipɨctsoŋ. ");
INSERT INTO poiNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Pero como d́a t́i̱chɨgɨ́y, d́a jáypa. Jesɨc cuando cutɨ́tsta̱p jém pɨ̱xiñ, tsa̱m malwadayt́a̱p jém wɨbɨc aŋma̱t́i icuyucmɨ, ichacpa jém wɨbɨc tuŋ. ");
INSERT INTO poiNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Jém pac, jém actɨŋnewɨɨp jém a̱pid́aŋjo̱m, jex juuts jém pɨ̱xiñ jém imatoŋpaap jém wɨbɨc aŋma̱t́i, pero tsa̱m ijɨ̱spa jém cosa jém it́yajwɨɨp yɨ́p naxyucmɨ. Jém riqueza tsa̱m imɨgóyáypa jém pɨ̱xiñ. Ixamcaaba jém wɨbɨc aŋma̱t́i. D́a tɨ́ma̱p. ");
INSERT INTO poiNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pero jém pac, jém actɨŋnewɨɨp jém wɨbɨc naxyucmɨ, jex juuts jém pɨ̱xiñ imatoŋpa jém wɨbɨc aŋma̱t́i, iwɨ̱cutɨɨyɨ́ypa t́i nɨmtooba. Jém pɨ̱xiñ juuts jém wɨbɨc nas. Ipɨctsoŋpa jém wɨbɨc aŋma̱t́i, jáyaŋa̱p jém wɨbɨc jɨ̱xi ia̱namaŋjo̱m. Algunos chióy cien, algunos chióy sesenta, algunos chióy treinta. ");
INSERT INTO poiNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesɨc Jesús iŋmat tuŋgac xut́u cuento. Nɨmpa: —Jém wɨbɨc aŋma̱t́i iga Dios iŋjacpa yɨ́p naxyucmɨ jex juuts tu̱m pɨ̱xiñ iñip jém wɨbɨc trigo ica̱mjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pero jesɨc tsuucɨɨm cuando moŋyajpa jém pɨxiñt́am miñ tu̱m enemigo. Oy iñip jém malopɨc pɨm ica̱mjo̱m ju̱t́ ñipneta̱ jém wɨbɨc trigo. ");
INSERT INTO poiNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ocmɨ nay jém trigo, mɨja̱p, jesɨc moypam. Jesɨgam quej jém malopɨc pɨm jém ñipneta̱wɨɨp ocmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Jesɨc jém pɨ̱xiñ iyo̱xacɨɨwiñ nɨc iámyaj jém io̱mi. Iñɨ́mayyaj: “Máno̱mi, siiga wɨbɨc pac iññip jém iŋca̱mjo̱m, ¿jesɨc jutsa̱ mu iñay jém malapɨm?” ");
INSERT INTO poiNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Jesɨc jém nas io̱mi iñɨ́máy jém iyo̱xacɨɨwiñ: “Tu̱m enemigo iwat je̱mpɨc.” Jesɨc acwácta̱, nɨ́mayt́a̱: “¿Iñxunpa iga nɨcpa aŋwixquímta jém malapɨm?” ");
INSERT INTO poiNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Pero jém nas io̱mi iñɨ́máy: “D́a taŋwixpa sɨɨp jém malapɨm porque químnamotpa jém trigo. ");
INSERT INTO poiNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Tsactaamɨ jém malapɨm iga iwaganamɨja̱p jém trigo hasta tampiŋpa jém cosecha. Jesɨc annɨ́máypa jém ipiŋpaap jém cosecha iga wiñt́i iwixquímyajiñ jém malapɨm, ichenyajiñ iga tannooquetpa. Jesɨc ocmɨ tanaccáypa jém trigo jém granerojo̱m.” ");
INSERT INTO poiNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesɨc Jesús iŋmat tuŋgac xut́u cuento. Nɨmpa Jesús: —Jém wɨbɨc aŋma̱t́i iga Dios iŋjacpa yɨ́p naxyucmɨ jex juuts tu̱m mostaza ipac jém iñipnewɨɨp tu̱m pɨ̱xiñ ica̱mjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Jém mostaza ipac tsa̱m xut́u, pero cuando mɨja̱p jém planta más mɨj que it́u̱mpɨy jém ñipñibooyi. Mɨja̱p juuts tu̱m mɨjpɨc cuy hasta jém jon iwatyajpa ipeeñi jém mostaza iŋcɨsyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesɨc iŋmatpat́im Jesús tuŋgac xut́u cuento. Nɨmpa: —Jém wɨbɨc aŋma̱t́i iga Dios iŋjacpa yɨ́p naxyucmɨ jex juuts tu̱m yo̱mo inimotpa jém levadura con tucute̱n jepscuy de harina. Jesɨc pɨ̱pa it́u̱mpɨy jém jaapi. ");
INSERT INTO poiNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","It́u̱mpɨy yɨ́pyaj cosa iŋquejáypa Jesús jém pɨxiñt́am con jém xuxut́ cuentoyaj. D́a t́i iŋquejáypa sin cuento. ");
INSERT INTO poiNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Je̱mpɨgam cupacpa jém aŋma̱t́i jém iŋmatnewɨɨp jém wiñɨcpɨc aŋmat́cɨɨwiñ cuando ijaychacne así: Anaŋquejáypa jém pɨxiñt́am con jém xuxut́ cuentoyaj. Anaŋmadáypa jém jɨ̱xi jém aŋnécnewɨɨp dende wiñɨgam cuando moj iwat Dios yɨ́p nas. ");
INSERT INTO poiNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jesɨc Jesús iŋquím jém pɨxiñt́am. Tɨgɨy e̱ybɨc jém tɨcjo̱m. Icunúcyaj jém icuyujcɨɨwiñ. Iñɨ́mayyaj: —Aŋmadaayɨ t́i nɨmtooba jém xut́u cuento cuando jém enemigo iñip jém malapɨm jém pɨ̱xiñ ica̱mjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesɨc Jesús iñɨ́máy: —Ɨch, jém aMiññewɨɨp Sɨŋyucmɨ, ɨch mismo anñippa jém wɨbɨc pac. ");
INSERT INTO poiNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Jém ca̱ma nɨmtooba yɨ́p naxyucmɨ. Jém wɨbɨc pac jex juuts jém iwɨ̱aŋja̱myajpáppɨc iga iŋjacpa Dios. Jém malapɨm jex juuts jém pɨxiñt́am jém Woccɨɨwiñ imɨɨchi. ");
INSERT INTO poiNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Jém enemigo iñippa jém malapɨm, je jém Woccɨɨwiñ. Jesɨc cuando piŋta̱p jém cosecha, yɨ́p nɨmtooba cuando cuyajpa yɨ́p nas. Jém ipiŋyajpaap jém cosecha jeeyaj jém sɨŋyucmɨpɨc pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Piŋta̱p jém malapɨm iga iñooba juctjo̱m, je̱mpɨgam iñascayajpa jém malopɨc pɨxiñt́am cuando cuyajpa yɨ́p nas. ");
INSERT INTO poiNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Jém Miññewɨɨp Sɨŋyucmɨ icutsatpa jém sɨŋyucmɨpɨc pɨxiñt́am iga it́opyajiñ jém Dios ipɨxiñt́ámaŋjo̱m it́u̱mpɨy jém malopɨc pɨxiñt́am con it́u̱mpɨy jém icmalwatneyajwɨɨp it́ɨ̱wɨtam. ");
INSERT INTO poiNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Matsyajta̱p, cotyajta̱p jém juctjo̱m ju̱t́ d́a nunca píchpa, ju̱t́ ipɨctsoŋyajpa jém castigo. Jemɨgam tsa̱m wejyajpa, tsa̱m iñichyajpa it́ɨts. ");
INSERT INTO poiNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Cuando yajpa it́opyaj it́u̱mpɨy jém malopɨc pɨxiñt́am, jesɨc it́u̱mpɨy jém pɨxiñt́am jém iwatyajpaap juuts ixunpa Dios, tsa̱m tsocyajpa juuts jém ja̱ma ju̱t́ iŋjacpa tanJa̱tuŋ Dios. Siiga mit́atsɨgɨyt́a, amatoŋtaamɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Jém wɨbɨc aŋma̱t́i iga Dios iŋjacpa yɨ́p naxyucmɨ jex juuts tu̱m caja tumiñ nécneta̱ ju̱t́ it́ tu̱m ja̱ca nas. Cuando tu̱m pɨ̱xiñ ipát jém tumiñ, jesɨc je̱mt́im iñec e̱ybɨc. Nɨc icumáyáy t́it́am iniit́ iga ijuypa jém nas ju̱t́ nécneta̱ jém tumiñ. ");
INSERT INTO poiNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Jém wɨbɨc aŋma̱t́i iga Dios iŋjacpa yɨ́p naxyucmɨ jex juuts tu̱m juyjúyoypaap. Ijuypa y imáypa jém wɨ̱tampɨc xuxut́ tsa jém perla. ");
INSERT INTO poiNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Cuando ipát tu̱m más wɨbɨc jém perla tsa̱mpɨc tsoowɨ́y, jesɨc icumáyáypa it́u̱mpɨy jém iniit́wɨɨp. Ijuypa jém wɨbɨc perla jém tsa̱mpɨc tsoowɨ́y. ");
INSERT INTO poiNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’También jém wɨbɨc aŋma̱t́i iga iŋjacpa Dios yɨ́p naxyucmɨ jex juuts tu̱m red, cuando ipatsyajpa lamar jém tɨɨptero, imatspa it́u̱mpɨy clase de tɨɨpɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Jesɨc cuando comne jém ired, jém tɨɨptero ijɨ̱cputyajpa lamar aŋna̱ca. Co̱ñyajpa, mojpa icupíŋayyaj jém tɨɨpɨ. Icotyajpa icooŋjo̱m jém wɨ̱tampɨc tɨɨpɨ. Jém d́apɨc wɨ̱tam ipatsayyajpa. ");
INSERT INTO poiNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Je̱mpɨgam iñascayajpa jém pɨxiñt́am cuando cuyajpa yɨ́p nas. Miñyajpa jém sɨŋyucmɨpɨc pɨxiñt́am iga icupíŋáypa jém malopɨc pɨxiñt́am jém Dios ipɨxiñt́ámaŋjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Cotyajta̱p jém malopɨc pɨxiñt́am jém juctjo̱m ju̱t́ ipɨctsoŋyajpa jém castigo. Jemɨgam tsa̱m wejyajpa, tsa̱m iñichyajpa it́ɨts. ");
INSERT INTO poiNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesɨc Jesús icwácpa jém icuyujcɨɨwiñ. Nɨ́mayyajta̱: —¿Iŋcutɨɨyɨyt́a t́i nɨmtooba it́u̱mpɨy yɨ́p xuxut́ cuento? Nɨmyajpa jeeyaj: —Jɨ̱, aŋcutɨɨyɨyt́a. ");
INSERT INTO poiNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Jesɨc nɨm Jesús: —Cuando tu̱m jém escribaspɨc maestro icutɨɨyɨ́ypa jém wɨbɨc aŋma̱t́i iga Dios iŋjacpa yɨ́p naxyucmɨ, jesɨc jém pɨ̱xiñ jex juuts tu̱m pɨ̱xiñ tsa̱m rico. Iniit́t́im jém pecapɨc tesoro y jém jo̱mipɨc tesoro. ");
INSERT INTO poiNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jesɨc cuando yaj iŋmat it́u̱mpɨy jém xuxut́ cuento, nɨcum Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Nɨc it́ɨcmɨ. Moj iŋquejáy jém pɨxiñt́am jém sinagoga ju̱t́ icuyujcayajpa jém wiñɨcpɨc aŋquímayooyi. Jeeyaj tsa̱m pɨ̱mi ipooñaŋja̱myajpa. Nɨmyaj: —¿Yɨ́p pɨ̱xiñ ju̱t́ icuyujca yɨ́p jɨ̱xi? ¿Jutsa̱p iwat yɨ́p milagroyaj? ");
INSERT INTO poiNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Yɨ́p pɨ̱xiñ jém carpintero ima̱nɨc. Ia̱pa jém Malía. Tánixpɨgayt́ámpa jém it́ɨ̱wɨtam jém Jacobo, jém José, jém Ximoj y jém Judas. ");
INSERT INTO poiNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Jém iyo̱mtɨ̱wɨtam it́t́im yɨɨm con taɨcht́am. ¿Ju̱t́ ipɨc yɨ́p pɨ̱xiñ it́u̱mpɨy yɨ́p jɨ̱xi? ");
INSERT INTO poiNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Jeeyucmɨ tsa̱m ijóyixyajpa Jesús. Jesɨc Jesús iñɨ́máy: —Ju̱t́quej wɨ̱pɨctsoŋta̱p jém Dios iŋmat́cɨɨwiñ. Pero jém it́yajwɨɨp it́ɨcmɨpɨc lugar con jém it́yajwɨɨp it́ɨccɨɨm d́a iwɨ̱aŋja̱myaj. ");
INSERT INTO poiNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Jesɨc d́a wa̱t́i wɨbɨc milagro iwat Jesús it́ɨcmɨ, Nazaret, porque d́a icupɨcyajpa iga Dios iMa̱nɨc. ");
INSERT INTO poiNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Jesɨc jeet́im tiempo jém gobernador Herodes ijo̱dóŋa̱ t́i iwatpa Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Jesɨc jém Herodes iñɨ́máy jém icuyo̱xapaap: —Yɨ́p pɨ̱xiñ jém Xiwan jém acchíŋoypaap. Pɨsneum. Jeeyucmɨ wɨa̱p iwat jém mɨjpɨc milagroyaj. ");
INSERT INTO poiNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","D́a más pecam jém Herodes icám orde iga matsta̱iñ jém Xiwan. Tsenta̱, cotta̱ cárcel. Matsta̱ jém Xiwan porque iwogáy jém Herodes cuando it́obáyáy jém it́ɨ̱wɨ Felipe iwɨcho̱mo. Jém yo̱mo iñɨ̱yi Herodías. ");
INSERT INTO poiNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Jém Xiwan iñɨ́máy jém Herodes: —D́a wɨ̱ iga impɨgayñe iñt́ɨ̱wɨ iyo̱mo. ");
INSERT INTO poiNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Jém Herodes tsa̱m iccaatooba jém Xiwan, pero icɨ̱ŋpa jém pɨxiñt́am porque nɨmyajpa iga jém Xiwan tu̱m jém Dios iŋmat́cɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Cuando núc jém Herodes icumpleaño, iwatpa tu̱m sɨŋ. Miñ jém Herodías iyo̱mma̱nɨc. Moj e̱chi jém pɨxiñt́am iwiñjo̱m. Tsa̱m iwɨ̱aŋja̱m jém Herodes. ");
INSERT INTO poiNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Jesɨc ijɨycámáy iga ichiiba jém wo̱ñi t́it́am iwágáypa. ");
INSERT INTO poiNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Jém ia̱pa iñɨ́máy jém wo̱ñi iga iwágáyiñ jém Xiwan ico̱bac. Jesɨc jém wo̱ñi iñɨ́máy jém Herodes: —Ansunpa iga yɨɨmt́i achiaayɨ jém Xiwan ico̱bac, jém acchíŋoypaap, tu̱m mɨjpɨc chi̱majo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Jesɨc pɨ̱mi aŋyácne jém rey. Pero como ijɨycámayñe iga ichiiba jém wo̱ñi t́it́am iwágáypa y como imatoŋneyaj it́u̱mpɨy jém it́yajwɨɨp jém mesacɨɨm, jém Herodes ipɨɨmɨ́y tu̱m soldado iga ichiáyiñ jém Xiwan ico̱bac jém wo̱ñi. ");
INSERT INTO poiNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Icutsat cárcel iga tɨŋcujagayt́a̱iñ jém Xiwan iɨscɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ocmɨ namíñayt́a̱ jém ico̱bac tu̱m mɨjpɨc chi̱majo̱m. Chiit́a̱ jém wo̱ñi. Jesɨc jém wo̱ñi ininɨgáy ia̱pa. ");
INSERT INTO poiNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Jesɨc miñyaj jém Xiwan icuyujcɨɨwiñ, ipíŋayyaj jém Xiwan imɨjta̱y, nɨc icumyaj. Ocmɨ nɨc iŋmadayyaj Jesús t́i iñasca jém Xiwan. ");
INSERT INTO poiNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Cuando imatoŋ Jesús t́i iñasca jém Xiwan, nɨc icut́um tu̱m lugar ju̱t́ d́a t́i id́ɨ́yɨ́y. Nɨc barcojo̱m. Jesɨc cuando ijo̱dóŋa̱yaj jém pɨxiñt́am iga nɨc Jesús, jeeyaj tsucumyaj jém attebetyaj. It́úŋɨyyajpa puymɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jesɨc put Jesús jém barcojo̱m, iix iga tsa̱m jáyaŋ pɨxiñt́am aŋtuuma̱neyaj. Tsa̱m pɨ̱mi iyaachaŋja̱mpa. Icpɨs jém mɨmneyajwɨɨp jém it́yajwɨɨp je̱m. ");
INSERT INTO poiNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Jesɨc piicha̱bam i̱t́i, miñyaj jém Jesús icuyujcɨɨwiñ. Iñɨ́mayyaj: —Sɨɨp tsa̱m tsuuyɨm. Yɨɨm d́a t́i id́ɨ́yɨ́y. Aŋquímya̱jɨ jém pɨxiñt́am. Nɨ́maayɨ iga nɨcyajiññam hasta ju̱t́ it́ jém tɨgaŋjoj iga ijuyyajpa t́it́am icútyajpa. ");
INSERT INTO poiNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Nɨmpa Jesús: —¿T́iiga nɨcyajpa? Mimicht́am acwíctaamɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Jesɨc nɨmyaj jém Jesús icuyujcɨɨwiñ: —D́a ictsɨ́ypa. Anait́t́a cinco caxt́ána̱ñi y wɨste̱n tɨɨpɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Nɨmpa Jesús: —Anamíñaayɨ yɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Jesɨc iñɨ́máy Jesús jém pɨxiñt́am iga co̱ñyajiñ naxyucmɨ jém múgaŋjo̱m. Jesɨc imatspac jém cinco caxt́ána̱ñi con jém wɨste̱n tɨɨpɨ. Ámquím sɨŋyucmɨ, moj iŋwejpát Dios. Iwenwenjac jém caxt́ána̱ñi, ichi jém icuyujcɨɨwiñ. Jesɨc jeeyaj ichiiyaj jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Jesɨc wícyaj it́u̱mpɨy hasta cusyajum wiiqui. Ocmɨ icucomyaj doce nacooŋ con jém pedazo jém cutsɨ́ywɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Wícyaj cinco mil pɨxiñt́am. Jém yo̱mtam y jém tsɨ̱xt́am d́a i̱ imayñe. ");
INSERT INTO poiNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jesɨc jeet́i rato Jesús ipɨɨmɨ́y jém icuyujcɨɨwiñ iga tɨgɨyyajiñ barcojo̱m. Jacyajpa id́ɨc jém laguna aŋwiñt́uc wiñt́i que jém Jesús, iganam je iŋquímpa jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Jesɨc cuando yaj mu iŋquím jém pɨxiñt́am, quím Jesús tu̱m co̱tsɨcyucmɨ ju̱t́ d́a t́i id́ɨ́yɨ́y iga iŋwejpátpa Dios. Jesɨc piicha̱wum i̱t́i Jesús icut́um it́ jém co̱tsɨcyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Pero juumɨ nɨc jém barco. Núc cucmɨ jém laguna, moj po̱yi jém sa̱wa, tsa̱m pooba jém nɨ. Tsa̱m pɨ̱mi ictsɨ́ypa jém barco jém nɨɨpoa y jém sa̱wa. Táŋcaa̱p iñɨc. ");
INSERT INTO poiNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Jesɨc jeet́im tsuu, cuquejtooba, núc Jesús ju̱t́ it́ icuyujcɨɨwiñ. Wit́pa iñɨc jém nɨɨwiñpacyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Cuando iixyaj jém icuyujcɨɨwiñ iga wit́pa jém nɨɨwiñpacyucmɨ, tsa̱m pɨ̱mi ichɨgaŋjécyaj. Como tsa̱m cɨ̱ŋneyaj, pɨ̱mi aŋwejyajpa. Nɨmyaj: —¡Miñpa tu̱m po̱ñ! ");
INSERT INTO poiNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pero jeet́i rato ijɨ́yáy Jesús, iñɨ́máy: —¡Camamwattaamɨ íña̱nama! ¡Aɨcham! ¡Odoy cɨ̱ŋtaamɨ! ");
INSERT INTO poiNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Jesɨc jém Peto iñɨ́máy: —MánO̱mi, siiga nu̱ma mimich, ajɨ́gaayɨ iga awit́pa jém nɨɨwiñpacyucmɨ hasta ju̱t́ miit́. ");
INSERT INTO poiNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesɨc nɨmpa Jesús: —Mi̱ñɨ. Jesɨc cuando quet jém Peto jém barcojo̱m, moj wi̱t́i jém nɨɨwiñpacyucmɨ. Nɨcpa id́ɨc hasta ju̱t́ it́ Jesús, ");
INSERT INTO poiNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","pero cuando iix iga tsa̱m pɨ̱mi jém sa̱wa, cɨ̱ŋpa jém Peto. Moj cumo̱ŋi jém nɨɨcɨɨm, tsa̱m pɨ̱mi aŋwejpa. Nɨmpa: —¡MánO̱mi, acɨacpu̱tɨ! ");
INSERT INTO poiNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jesɨc jeet́i rato jém Jesús imatsáy icɨ, iñɨ́máy: —Tsa̱m uxaŋ iŋcupɨcpa. ¿T́iiga iñjɨ̱spa iga d́a awɨa̱p? ");
INSERT INTO poiNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Jesɨc cuando tɨgɨyyaj jém barcojo̱m, te̱ñum jém sa̱wa. ");
INSERT INTO poiNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Jesɨc jém it́yajwɨɨp jém barcojo̱m co̱ste̱ñyaj jém Jesús iwiñjo̱m. Nɨmyaj: —Nu̱ma mimich jém Dios miMa̱nɨc. ");
INSERT INTO poiNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Cuando yaj ja̱quiyaj jém laguna, núcyaj jém naxyucmɨ de Genesaret. ");
INSERT INTO poiNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Cuando jém Genesaretpɨc pɨxiñt́am iixpɨcyaj iga Jesús, icutsat aŋma̱t́i icuwɨ̱t́i jém naxyucmɨ iga inimiñyajiñ it́u̱mpɨy jém mɨmneyajwɨɨp iga icpɨspa Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Icunucsayyajpa Jesús iga ijɨ́gáyiñ iga ichɨgayyajpa jém iyoot́i iŋna̱ca. Jesɨc cupɨsayyaj it́u̱mpɨy jém ichɨgayñeyajwɨɨp jém iyoot́i. ");
INSERT INTO poiNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Jesɨc miñ iámyaj Jesús jém escribaspɨc maestroyaj con jém fariseoyaj. Miñyaj Jerusalén. Icwácyaj jém Jesús. Nɨ́mayt́a̱: ");
INSERT INTO poiNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—Jém iŋcuyujcɨɨwiñ, ¿t́iiga d́a iwatyajpa jém costumbre jém ichacnewɨɨp jém wiñɨcpɨc tantúmmɨtam? D́a icheeyajpa icɨ juuts nɨmpa jém costumbre antes que wícpa. ");
INSERT INTO poiNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesɨc Jesús iñɨ́máy: —¿T́iiga mimichgact́i iŋwattámpa contra jém Dios iŋquímayooyi con mich iŋcostumbre? ");
INSERT INTO poiNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Porque nɨmpa Dios: “Wɨ̱ixt́aamɨ jém iñja̱tuŋ y íña̱pa.” Nɨmt́im: “Siiga i̱ imalnɨ́máypa jém ija̱tuŋ o ia̱pa, jesɨc wɨ̱ iga accaata̱iñ jexpɨc pɨ̱xiñ.” ");
INSERT INTO poiNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pero mimicht́am iniit́ tu̱m d́a wɨbɨc costumbre. Miñɨmtámpa: “Siiga i̱ iñɨ́máypa ija̱tuŋ o ia̱pa iga d́a wɨa̱p manyo̱xpát porque it́u̱mpɨy jém anait́wɨɨp, jém manchiipáppɨc id́ɨc, anjɨycámayñe Dios iga anchiiba.” ");
INSERT INTO poiNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Jém nɨmpaap je̱mpɨc d́a iyo̱xpátpa jém ija̱tuŋ o ia̱pa. Je̱mpɨgam iñchactámpa jém Dios iŋquímayooyi juuts tu̱m cosa d́a para t́i wɨ̱ iga iŋcupɨctámpa mimicht́ampɨc iŋcostumbre. ");
INSERT INTO poiNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Tsa̱m minimɨgóyayt́a̱p iñyaac. Iñjɨ̱stámpa iga iŋwatpa juuts ixunpa Dios, pero más immalwatpa. Wɨ̱ nɨm jém wiñɨcpɨc aŋmat́cɨɨwiñ jém Isaías cuando iŋmatpa de mimicht́am. Nɨmpa: ");
INSERT INTO poiNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Yɨ́pyaj pɨxiñt́am tsa̱m acujípyajpa con ijɨp. Pero ia̱namaŋjo̱m d́a acupɨcneyaj. ");
INSERT INTO poiNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Xajat́im ajɨ̱syajpa. Iŋquejpa jém pɨxiñt́am jém ijɨ̱xquiimi juuts wɨbɨc aŋquímayooyi. ");
INSERT INTO poiNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jesɨc Jesús pɨ̱mi jɨypa. Iñɨ́máy los demás jém miññeyajwɨɨp: —Matoŋtaamɨ. Cutɨɨyɨyt́aamɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Jém tɨgɨypaap tu̱m pɨ̱xiñ ijɨpjo̱m iga icútpa, d́a icmalwatpa. Pero jém malopɨc jɨ̱xi y jém malopɨc aŋma̱t́i jém putpaap ijɨpjo̱m, je ictáŋcawatpa. ");
INSERT INTO poiNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Jesɨc icunúcyaj Jesús jém icuyujcɨɨwiñ. Nɨmyaj: —¿Que iñjo̱doŋ iga tsa̱m pɨ̱mi jóyñe jém fariseoyaj cuando imatoŋyaj t́i iññɨ́máy? ");
INSERT INTO poiNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesɨc Jesús iñɨ́máy: —It́u̱mpɨy jém planta jém d́apɨc je Dios iñi̱pi tienes que wixquímta̱p. ");
INSERT INTO poiNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Jesɨc odoy wadaayɨ caso jém maestroyaj de jém wiñɨcpɨc aŋquímayooyi. Cácht́iyaj. Ijɨ̱cneyaj tuŋgac cácht́i. Siiga tu̱m cácht́i ijɨ̱cpa tuŋgac cácht́i, jesɨc tsutpa icuɨstɨc jém pacusjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Jesɨc jém Peto iñɨ́máy jém Jesús: —Aŋmadayt́aamɨ t́i nɨmtooba yɨ́p xut́u cuento. ");
INSERT INTO poiNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesɨc nɨmpa Jesús: —¿Que mimicht́am, d́at́im iŋcutɨɨyɨyt́ámpa? ");
INSERT INTO poiNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Que d́a iŋcutɨɨyɨ́ypa iga it́u̱mpɨy cosa jém tɨgɨypáppɨc iñjɨpjo̱m naspa impuujo̱m y ocmɨ putpa? ");
INSERT INTO poiNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pero it́u̱mpɨy jém malopɨc aŋma̱t́i y jém malajɨ̱xi jém putpaap iñjɨpjo̱m tsucumpa jém íña̱namaŋjo̱m. Jexpɨc cosa mictáŋcawatpa. ");
INSERT INTO poiNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Porque jém pɨ̱xiñ ia̱namaŋjo̱m tsucumpa it́u̱mpɨy jém malopɨc jɨ̱xi. Jemum tsucumpa jém jɨ̱xi iga accaóypa, pejóypa, iwatyajpa jém d́a wɨ̱tampɨc cosa, númpa, mɨgóypa y cumɨgóyóypa. ");
INSERT INTO poiNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Yɨ́pyaj malopɨc cosa ictáŋcawatpa jém pɨ̱xiñ. Pero siiga wícpa y d́a icheeba icɨ juuts nɨmpa jém wiñɨcpɨc costumbre, je d́a ictáŋcawatpa. ");
INSERT INTO poiNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesɨc Jesús put de je̱m, nɨc nocojo̱m de jém attebet Tiro y Sidón. ");
INSERT INTO poiNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Jemum miñ tu̱m Cananeapɨc yo̱mo. Je̱mt́im tsucum nocojo̱m de jém Tiro y Sidón. Pɨ̱mi jɨypa jém yo̱mo. Iñɨ́máy Jesús: —Ayaachaŋja̱mɨ, mánO̱mi. Mich jém David mio̱cma̱nɨc. Jém anyo̱mma̱nɨc imatsne tu̱m mal espíritu. Tsa̱m pɨ̱mi sɨ́p iyaachwat. ");
INSERT INTO poiNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pero Jesús d́a icutsoŋ. Jesɨc jém icuyujcɨɨwiñ miñ iñɨ́mayyaj Jesús: —Chi̱ɨ t́i ixunpa yɨ́p yo̱mo iga nɨguiñam porque tsa̱m tamoogɨ́ypa. ");
INSERT INTO poiNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesɨc Jesús icutsoŋ, iñɨ́máy: —Dios acutsat iga anyo̱xpád́iñ jém Israelpɨc borregoyaj jém togoyñewɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Pero miñ jém yo̱mo, ico̱steeñáy jém Jesús iwiñjo̱m. Nɨmpa jém yo̱mo: —MánO̱mi, ayo̱xpaatɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Nɨmpa Jesús: —D́a wɨ̱ tantobáyáypa jém tsɨ̱xt́am icaxt́ána̱ñi iga tanchiiba chimpa. ");
INSERT INTO poiNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Jesɨc nɨmpa jém yo̱mo: —Nu̱ma, mánO̱mi, pero hasta jém chimpa icútyajpa jém ipaccanewɨɨp jém io̱mi imesacucɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jesɨc Jesús iñɨ́máy jém yo̱mo: —Miyo̱mo, tsa̱m iŋcupɨcpa iga Dios wɨa̱p miyo̱xpát. Sɨɨp Dios miwadáypa juuts mich iñxunpa. Jeet́i rato pɨs jém iyo̱mma̱nɨc. ");
INSERT INTO poiNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesɨc Jesús put de je̱m. Nas jém laguna aŋna̱ca de Galilea. Quím Jesús tu̱m co̱tsɨcyucmɨ. Jemum nɨc co̱ñi. ");
INSERT INTO poiNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tsa̱m jáyaŋ pɨxiñt́am núcyaj ju̱t́ it́ jém Jesús. Inimíñayyaj jém cu̱xuj, jém cácht́i, jém u̱ma, jém d́apɨc wɨa̱ne icɨ o ipuy, con jáyaŋ tuŋgac más mɨmneyajwɨɨp. Oy ichacyaj jém Jesús ipuycɨɨm. Jesɨc Jesús icpɨs it́u̱mpɨy. ");
INSERT INTO poiNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Jeeyucmɨ tsa̱m ipooñaŋja̱myaj jém aŋtuuma̱neyajwɨɨp cuando iixyaj iga jɨypam jém u̱ma, wɨ̱tsɨ́yñeum jém d́apɨc wɨ̱ icɨ o ipuy, wit́pam jém cu̱xuj, ixixóypam jém cácht́i. Jesɨc moj icujípyaj jém Dios de Israel. ");
INSERT INTO poiNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesɨc Jesús iŋwejáy jém icuyujcɨɨwiñ. Iñɨ́máy: —Tsa̱m anyaachaŋja̱mpa jém miññeyajwɨɨp yɨɨm. Porque tucunaja̱ma taŋwaganait́, sɨɨp d́a inii̱yaj t́it́am icútyajpa. D́a aŋcutsattooba iga nɨcyajiñ it́ɨcmɨ sin wiiqui porque wɨa̱p icupóna̱quetyaj, cutɨŋyajpa tuŋjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Jém icuyujcɨɨwiñ iñɨ́mayyaj Jesús: —¿Ju̱t́ tampɨcpa tsa̱m jáyaŋ caxt́ána̱ñi iga tanacwícpa tsa̱m jáyaŋ pɨxiñt́am? Porque yɨɨm d́a t́i id́ɨ́yɨ́y. ");
INSERT INTO poiNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesɨc Jesús icwác: —¿Jute̱n caxt́ána̱ñi iniit́t́a? Nɨmyaj jém icuyujcɨɨwiñ: —Siete, con jute̱n jém xuxut́ tɨɨpɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jesɨc Jesús iñɨ́máy jém aŋtuuma̱neyajwɨɨp iga co̱ñyajiñ naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ipɨc Jesús jém siete caxt́ána̱ñi con jém tɨɨpɨ, moj iŋwejpát Dios. Ocmɨ iwenwenjac jém caxt́ána̱ñi, ichi jém icuyujcɨɨwiñ. Iwégayyaj it́u̱mpɨy jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Cusum wiiquiyaj it́u̱mpɨy. Ocmɨ icucomyaj siete nacooŋ jém caxt́ána̱ñi con jém tɨɨpɨ jém cutsɨ́yñewɨ́ppɨgam. ");
INSERT INTO poiNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Wícyaj cuatro mil pɨxiñt́am, d́a maycumne jém yo̱mtam y jém tsɨ̱xt́am. ");
INSERT INTO poiNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ocmɨ Jesús iŋquímyaj jém aŋtuuma̱neyajwɨɨp, tɨgɨy tu̱m barcojo̱m, nɨc jém laguna aŋna̱ca noco ju̱t́ it́ jém attebet Magdala. ");
INSERT INTO poiNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Jém fariseoyaj con jém saduceoyaj miñ iámyaj Jesús iga icutɨ́tsyajpa. Iwágayyajpa Jesús iga iŋquejáyiñ tu̱m sɨŋyucmɨpɨc milagro. ");
INSERT INTO poiNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jesɨc Jesús iñɨ́máy: —Jesɨc tsuáŋam cuando íñixt́ámpa iga agui tsabats jém ucsɨ, miñɨmtámpa iga wɨ̱cooma̱p. ");
INSERT INTO poiNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Jesɨc tsuuyt́im cuando agui tsabats jém ucsɨ, agui ucsjo̱m, miñɨmtámpa iga d́a wɨ̱cooma̱p. Mimicht́am tsa̱m minimɨgóyayt́a̱p iñyaac porque iŋcutɨɨyɨyt́ámpa t́i miñpa cuando íñixpa jém ucsɨ, pero d́a wɨa̱p iŋcutɨɨyɨ́y jém seña jém sɨɨppɨc íñixñeta iga miñpa jém íŋaŋpɨgam ja̱ma. ");
INSERT INTO poiNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Jém it́yajwɨɨp sɨɨp tsa̱m imalwatyajpa, ichacneyaj jém Dios iŋquímayooyi, tsa̱m iwágayyajpa tu̱m milagro. Pero tu̱m seña no más iwadáypa Dios, jém milagro juuts iñasca jém wiñɨcpɨc aŋmat́cɨɨwiñ jém Jonás. Jesɨc nɨc Jesús. Jemum ichac jém miññeyajwɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jesɨc núcyaj jém Jesús icuyujcɨɨwiñ jém laguna aŋwiñt́uc. Jeeyaj ijaamaŋnotyaj jém caxt́ána̱ñi. ");
INSERT INTO poiNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesɨc Jesús iñɨ́máy: —I̱xɨ, nawattamta̱jɨ cuenta iga odoy mimalwadáyiñ jém levadura jém iniit́wɨɨp jém fariseoyaj y jém saduceoyaj. ");
INSERT INTO poiNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Jesɨc jém icuyujcɨɨwiñ moj nanɨ́mayyajta̱ji entre jeeyaj: —Tanɨ́máy je̱mpɨc porque d́a tanamiñ jém caxt́ána̱ñi. ");
INSERT INTO poiNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Pero Jesús ijo̱doŋ t́i sɨ́p ijɨ̱syajpa, iñɨ́máy: —A que mimicht́am, tsa̱m uxaŋ iŋcupɨcpa iga Dios wɨa̱p miyo̱xpát. ¿T́iiga iñjɨ̱stámpa iga d́a inii̱ jém caxt́ána̱ñi? ");
INSERT INTO poiNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Que d́a iŋcutɨɨyɨ́ypa, ni d́a iñjɨ̱spa jém cinco caxt́ána̱ñi cuando tanacwícta jém cinco mil pɨxiñt́am? ¿Jute̱n cooŋ impiŋ jém cutsɨ́ywɨɨp? ");
INSERT INTO poiNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Que d́at́im iñjɨ̱spa jém siete caxt́ána̱ñi cuando tanacwícta jém cuatro mil pɨxiñt́am y jute̱n cooŋ impiŋ jém cutsɨ́ywɨɨp? ");
INSERT INTO poiNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿T́iiga micht́am d́a iŋcutɨɨyɨyt́a iga d́a je caxt́ána̱ñi sɨ́p mannɨ́máy cuando manaŋmadáypa de jém levadura jém iniit́wɨɨp jém fariseoyaj y jém saduceoyaj? ");
INSERT INTO poiNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Jesɨc icutɨɨyɨyyaj iga d́a nɨmtooba Jesús iga cuidado con levadura jém iniit́wɨɨp jém caxt́ána̱ñi, pero nɨmtooba cuidado con jém fariseoyaj iŋquímayooyi y con jém saduceoyaj iŋquímayooyi. ");
INSERT INTO poiNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Cuando núc Jesús nocojo̱m jém attebet Cesarea de Filipo, icwácyaj jém icuyujcɨɨwiñ, iñɨ́máy: —¿Junɨmpa jém pɨxiñt́am iga ai̱apaap aɨch, jém aMiññewɨɨp Sɨŋyucmɨ? ");
INSERT INTO poiNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Nɨmyaj jém icuyujcɨɨwiñ: —Algunos nɨmyajpa iga mich miXiwan jém micchíŋoypaap. Nɨmyajpat́im algunos iga mich miElías. Más tuŋgac nɨmyajpa iga mich miJeremías o tuŋgac jém wiñɨcpɨc aŋmat́cɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","E̱ybɨc jɨypa Jesús, iñɨ́máy: —Pero mimicht́am, ¿mijunɨmtámpa, ai̱apaap aɨch? ");
INSERT INTO poiNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Jesɨc jém Ximoj Peto iñɨ́máy: —Mich miCristo jém vivopɨc Dios miMa̱nɨc. ");
INSERT INTO poiNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesɨc Jesús iñɨ́máy jém Peto: —Dios miwɨ̱wadáy miXimoj jém Jonás mima̱nɨc, porque yɨ́p jɨ̱xi d́a i̱ miŋmadáy, pero jém anJa̱tuŋ Dios jém it́wɨɨp sɨŋyucmɨ miŋquejáy. ");
INSERT INTO poiNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Sɨɨp ɨch mannɨ́máypa iga mich miPeto. Ɨch anacte̱ñpa jém amma̱stɨc yɨ́p tsaayucmɨ. Jém Woccɨɨwiñ ipɨ̱mi d́a wɨa̱p icoñwɨ́y. ");
INSERT INTO poiNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Manchiiba jém llave iga tɨgɨyyajiñ jém pɨxiñt́am ju̱t́ iŋjacpa Dios. T́it́am miñɨmpa iga d́a wɨa̱p yɨ́p naxyucmɨ, jesɨc d́at́im wɨa̱p iwatyaj sɨŋyucmɨ. T́it́am iñjɨ́cpa yɨ́p naxyucmɨ, jesɨc wɨa̱pt́im iwatyaj sɨŋyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jesɨc iñɨ́máy jém icuyujcɨɨwiñ iga: “Odoy i̱ aŋmadaayɨ iga ɨch aCristo.” ");
INSERT INTO poiNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Dende jesɨgam moj iŋmadáy Jesús jém icuyujcɨɨwiñ t́i iñascaaba. Nɨmpa: —Anɨcpa jém attebet Jerusalén ju̱t́ pɨ̱mi ayaachwatta̱p. Tsa̱m pɨ̱mi amalwadáypa jém wɨd́ayt́am, jém co̱bacpɨc pa̱nijyaj, y jém escribaspɨc maestroyaj. Ocmɨ accaata̱p y jém tucunaja̱ma apɨspa. ");
INSERT INTO poiNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Jesɨc jém Peto iŋwejput Jesús, iwogáy. Nɨmpa: —MánO̱mi, odoy jɨɨcɨ iga iññascaaba je̱mpɨc. ");
INSERT INTO poiNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Pero ámse̱t Jesús, nɨ́mayt́a̱ jém Peto: —MiPeto, mich miwoccɨɨwiñ, acupóyaayɨ. Mich anactáŋcawattooba. D́a inii̱ jém Dios ijɨ̱xi. Iniit́ jém pɨxiñt́am ijɨ̱xi. ");
INSERT INTO poiNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Jesɨc Jesús iñɨ́máy jém icuyujcɨɨwiñ: —Siiga i̱ atúŋɨyt́ooba, wɨ̱ iga ichaguiñ iga iwatpa juuts je ixunpa, wɨ̱t́im iga iyaachɨ́yiñ cuando yaachwatta̱p juuts ɨch anyaachɨ́ypa, jesɨc atúŋɨɨyɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Siiga tu̱m pɨ̱xiñ tsa̱m it́oypa ivida iga it́pa yɨ́p naxyucmɨ, jesɨc togoypa jém ivida. Pero siiga accaata̱p tu̱m pɨ̱xiñ ɨch aŋcuyucmɨ, jesɨc jém pɨ̱xiñ d́a togoypa ivida, it́pa para siempre. ");
INSERT INTO poiNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","D́a t́i cuwatcuy siiga tu̱m pɨ̱xiñ iniit́ it́u̱mpɨy jém wɨbɨc cosa jém it́wɨɨp yɨ́p naxyucmɨ, pero ocmɨ togoypa ia̱nama. Tu̱m pɨ̱xiñ d́a wɨa̱p iyoj con tumiñ iga ipɨctsoŋpa e̱ybɨc jém ia̱nama cuando caaneum. ");
INSERT INTO poiNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ɨch, jém aMiññewɨɨp Sɨŋyucmɨ, e̱ybɨc amiñpa con anJa̱tuŋ Dios ipɨ̱mi. Aŋwaganamiñpa jém sɨŋyucmɨpɨc pɨxiñt́am. Anyojpa cada tu̱mtu̱m jém pɨ̱xiñ según juuts iwatne jém iyo̱xa̱ji. ");
INSERT INTO poiNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nu̱ma, mannɨ́máypa iga algunos de mimicht́am miit́t́aŋwɨɨp yɨɨm d́a micaaba hasta que íñixt́ámpa cuando ampɨctsoŋpa jém anJa̱tuŋ ipɨ̱mi iga anaŋjacpa jém Dios ipɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Jesɨc cuando nasum seis día, Jesús ininɨc jém Peto, Jacobo y Xiwan, jém Jacobo it́ɨ̱wɨ, tu̱m mɨjpɨc co̱tsɨcyucmɨ. Icut́um nɨcyaj. ");
INSERT INTO poiNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Jemum iixyaj iga aŋcac jém Jesús iámooyi. Agui pɨ̱mi tsocpa jém iámooyi juuts jém ja̱ma. Pɨ̱mi po̱po jém ipuctu̱cu juuts tu̱m juctɨ icho̱ca. ");
INSERT INTO poiNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Jesɨc jeet́i rato iixyaj wɨste̱n jém wiñɨcpɨc pɨ̱xiñ, jém Moisés y jém Elías, aŋmatyajpa con Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Jesɨc jém Peto iñɨ́máy Jesús: —MánO̱mi, agui wɨ̱ iga tait́t́ámpa yɨɨm. Siiga iŋwɨ̱aŋja̱m aŋwatpa tucute̱n nacxt́ɨc, tu̱m para mimich, tu̱m para jém Moisés, tu̱m para jém Elías. ");
INSERT INTO poiNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Iganam jɨypa jém Peto, actɨŋ tu̱m ucsɨ agui tsocpa. Iŋmon it́u̱mpɨy. Jesɨc imatoŋyaj tu̱m jɨ̱yi jém ucsaŋjo̱m. Nɨmpa: —Yɨ́p ɨch amMa̱nɨc, tsa̱m antoypa. Matóŋayt́aamɨ t́i miñɨ́máypa. ");
INSERT INTO poiNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Cuando imatoŋyaj jém jɨ̱yi, jém icuyujcɨɨwiñ tocsneactɨŋyaj naxyucmɨ. Tsa̱m pɨ̱mi cɨ̱ŋyaj. ");
INSERT INTO poiNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ocmɨ Jesús icunúc jém icuyujcɨɨwiñ, ichɨcyaj, nɨ́mayyajta̱p: —Tsucu̱mɨ. Odoy cɨ̱ŋtaamɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Cuando ámquímyaj jém icuyujcɨɨwiñ, d́am i̱ iixyaj. Tsɨ́y Jesús icut́um. ");
INSERT INTO poiNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Iganam quetyajpa jém co̱tsɨcyucmɨ, Jesús iŋquímpa jém icuyujcɨɨwiñ. Iñɨ́máy: —Odoy i̱ aŋmadaayɨ t́i íñix jém co̱tsɨcyucmɨ hasta que accaata̱p y pɨspa jém Miññewɨɨp Sɨŋyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Jesɨc jém icuyujcɨɨwiñ icwácyajpa Jesús. Nɨ́mayt́a̱p: —¿Jesɨc t́iiga nɨmpa jém escribaspɨc maestroyaj iga miñpa wiñt́i jém Elías? ");
INSERT INTO poiNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesɨc Jesús icutsoŋ, nɨ́mayyajta̱: —Nu̱ma, wiñt́i miñpa jém Elías iga iwɨ̱tsacpa it́u̱mpɨy cosa. ");
INSERT INTO poiNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Sɨɨp mannɨ́máypa iga oyñeum jém Elías, pero jém it́yajwɨɨp sɨɨp d́a iixpɨcyaj. Imalwadayyaj juuts jeeyaj ixunyajpa. Jesa̱pt́im imalwadayyajpat́im jém Miññewɨɨp Sɨŋyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jesɨc jém icuyujcɨɨwiñ icutɨɨyɨyyaj iga cuando nɨmpa Jesús iga núcneum jém Elías, nɨmtooba iga jém Xiwan jém acchíŋoypaap. ");
INSERT INTO poiNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Cuando núcgacum Jesús ju̱t́ aŋtuuma̱neyaj tsa̱m jáyaŋ pɨxiñt́am, tu̱m pɨ̱xiñ icunúc Jesús, ico̱steeñáy iwiñjo̱m. Iñɨ́máy: ");
INSERT INTO poiNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Maestro, yaachaŋja̱mɨ jém amma̱nɨc. Tsa̱m imatspa jém ataque. Pɨ̱mi iyaachwatpa. Wat́cɨy actɨŋpa juctjo̱m y jém nɨɨcɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Anamíñáy jém iŋcuyujcɨɨwiñ iga icpɨsyajiñ, pero jeeyaj d́a wɨa̱p icpɨsyaj. ");
INSERT INTO poiNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesɨc Jesús iñɨ́máy jém it́yajwɨɨp je̱m: —A que mimicht́am, hasta sɨɨp d́a iŋcupɨctámpa Dios. Jáyum tawagai̱t́i con mimicht́am, pero d́at́im iŋcupɨcta. Tsa̱m anyaachɨ́yum iga manaŋquejáypa jém Dios iŋma̱t́i, pero d́a iŋcutɨɨyɨyt́ámpa. Anamíñaayɨ jém tsɨ̱xi. ");
INSERT INTO poiNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jesús iwogáy jém mal espíritu, jesɨc put jém jaychɨ̱xi ia̱namaŋjo̱m. Jeet́i rato pɨs. ");
INSERT INTO poiNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Más ocmɨ jém icuyujcɨɨwiñ iyamnɨ́máy Jesús. Icwácyaj: —¿T́iiga d́a wɨa̱ antopta jém mal espíritu? ");
INSERT INTO poiNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesɨc Jesús iñɨ́máy: —D́a wɨa̱p iñt́opta porque d́a iŋwɨ̱cupɨcpa iga Dios miyo̱xpátpa. Nu̱ma mannɨ́máypa siiga iŋcupɨcpa uxaŋ juuts tu̱m xut́u mostaza ipac, wɨa̱p iññɨ́máy yɨ́p co̱tsɨc: “Caayɨ de yɨɨm, nɨ̱cɨ jeexɨc.” Jesɨc cáypa jém co̱tsɨc. Wɨa̱p iŋwatta it́u̱mpɨy cosa siiga nu̱ma iŋcupɨcpa iga Dios miyo̱xpátpa. ");
INSERT INTO poiNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Pero yɨcxpɨc mal espíritu wɨa̱p iñt́opta siiga iniŋwejpátpa Dios y siiga iŋwatpa ayuno. ");
INSERT INTO poiNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Iganam wagasɨɨyajpa Jesús con icuyujcɨɨwiñ jém naxyucmɨ de Galilea, moj iŋmadáy Jesús t́i iñascaaba. Nɨmpa iga jém Miññewɨɨp Sɨŋyucmɨ cɨɨjuŋcotta̱p jém malopɨc pɨxiñt́am icɨɨjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ocmɨ accaata̱p, pero jém tucunaja̱ma pɨspa. Jesɨc cuando imatoŋyaj jém icuyujcɨɨwiñ tsa̱m pɨ̱mi aŋyácyaj. ");
INSERT INTO poiNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Cuando núcyaj jém attebet Capernaum jém Jesús con icuyujcɨɨwiñ, jesɨc miñ jém ichécyajpaap impuesto para jém mɨjpɨc ma̱stɨc. Miñ iámyaj jém Peto. Icwácyajpa. Nɨ́mayt́a̱p: —¿Que d́a iyojpa impuesto jém immaestro para jém mɨjpɨc ma̱stɨc? ");
INSERT INTO poiNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Icutsoŋ jém Peto, nɨmpa: —Jɨ̱, iyojpa. Jesɨc cuando tɨgɨy jém Peto jém tɨcjo̱m ju̱t́ it́ Jesús, wiñt́i jɨy jém Jesús, nɨ́mayt́a̱p jém Peto: —MiPeto, ¿t́i iñjɨ̱spa, jém reyyaj jém it́yajwɨɨp yɨ́p naxyucmɨ, i̱ ichégáypa jém impuesto? ¿Jém it́ɨ̱wɨtam o jém tuŋgac pɨ̱xiñ jém d́apɨc je̱mpɨc? ");
INSERT INTO poiNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Icutsoŋ jém Peto: —Jém tuŋgac pɨ̱xiñ jém d́apɨc je̱mpɨc. Jesɨc Jesús iñɨ́máy: —Jesɨc jém it́ɨ̱wɨtam d́a iyojpa. ");
INSERT INTO poiNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pero iga odoy tajóyixiñ jém ichécyajpaap jém impuesto, nɨ̱cɨ jém laguna, co̱tɨ jém íñaawi. To̱pɨ jém tɨɨpɨ jém mojpaap iñxuy. Impátpa ijɨpjo̱m tu̱m tumiñ. Ictsɨ́ypa jém tumiñ iga iñyojpa jém impuesto para mimich y para aɨch. Jesɨc nɨ̱gɨ yo̱jɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Jeet́im ja̱ma icunúcyaj Jesús jém icuyujcɨɨwiñ. Iñɨ́mayyaj: —Cuando núcpa jém tiempo iga Dios iŋjacpa yɨ́p naxyucmɨ, ¿i̱ tsɨ́ypa más mɨjpɨc aŋjagooyi de aɨcht́am? ");
INSERT INTO poiNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jesɨc Jesús iŋwejáy tu̱m xut́u tsɨ̱xi. Iñɨ́máy: —Mi̱ñɨ mit́e̱ñi yɨɨm jém aŋcuyujcɨɨwiñ iwiñjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Jesɨc Jesús iñɨ́máy jém icuyujcɨɨwiñ: —Nu̱ma mannɨ́máypa, siiga d́a iŋcucacpa jém iñjɨ̱xi y d́a michɨ́ypa juuts tu̱m xut́u tsɨ̱xi, d́a wɨa̱p iñt́ɨgɨy ju̱t́ iŋjacpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Jém tsɨ́ypáppɨc juuts jém más mɨjpɨc aŋjagooyi, je jém nɨmpáppɨc iga d́a t́i wɨa̱p, tsɨ́ypa juuts yɨ́p xut́u tsɨ̱xi. ");
INSERT INTO poiNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Siiga tu̱m pɨ̱xiñ iwɨ̱pɨctsoŋpa tu̱m jém ammɨɨchipɨc jém d́apɨc juchaŋ juuts yɨ́p xut́u tsɨ̱xi, awɨ̱pɨctsoŋpat́im aɨch. ");
INSERT INTO poiNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Siiga i̱ icwatpa táŋca tu̱m pɨ̱xiñ, jém yaguiñpɨc acupɨcpa aɨch, más wɨ̱ iga cutsénayt́a̱iñ iɨscɨyucmɨ tu̱m mɨjpɨc molino icha iga jiccaiñ lamar ju̱t́ tsa̱m jojmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Agui uuguyt́im jém it́yajwɨɨp yɨ́p naxyucmɨ porque siempre it́ jém malopɨc pɨ̱xiñ jém icwatpáppɨc táŋca jém it́ɨ̱wɨtam. Tienes que iñascaaba je̱mpɨc, pero agui uuguyt́im jém pɨ̱xiñ jém icwatpáppɨc táŋca jém it́ɨ̱wɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Siiga iŋcɨ o impuy micwatpa táŋca, jesɨc ja̱cɨ, patsaayɨ. Más wɨ̱ iga mit́ɨgɨypa ju̱t́ it́ jém vida micɨɨt́a̱ca o mipuyt́a̱ca que iga micotta̱p juctjo̱m ju̱t́ d́a nunca píchpa con icuɨstɨc iŋcɨ o icuɨstɨc impuy. ");
INSERT INTO poiNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Siiga íñixcuy micwatpa táŋca, jesɨc to̱pɨ jém íñixcuy, patsaayɨ. Más wɨ̱ iga mit́ɨgɨypa ju̱t́ it́ jém vida con tu̱m íñixcuy que iga micotta̱p jém juctjo̱m ju̱t́ d́a nunca píchpa con icuɨstɨc íñixcuy. ");
INSERT INTO poiNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Odoy jóyi̱xɨ jém tsɨ̱xt́am y jém yaguiñpɨc icupɨcyajpa ɨch anaŋma̱t́i. Porque cada tu̱mtu̱m de jeeyaj iwatyajpa cuenta jém sɨŋyucmɨpɨc pɨxiñt́am, jém it́yajwɨɨp jém tanJa̱tuŋ Dios iwiñjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Jeeyucmɨ amiñ sɨŋyucmɨ iga aŋcɨacpud́iñ jém togoyñeyajwɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿T́i miñɨmpa mimicht́am? Siiga tu̱m pɨ̱xiñ iniit́ cien borrego y togoypa tu̱m, ¿jesɨc t́i iwatpa jém io̱mi? Tienes que ipoychacpa jém noventa y nueve. Nɨcpa iméts jém togoyñewɨɨp co̱tsɨgaŋjoj. ");
INSERT INTO poiNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Siiga ipátpa jém togoyñewɨɨp, más pɨ̱mi maymáya̱p jém pɨ̱xiñ con jém tu̱m jém ipátnewɨɨp que con jém noventa y nueve jém d́apɨc togoyñe. ");
INSERT INTO poiNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Jesa̱pt́im jém tanJa̱tuŋ Dios, jém it́wɨɨp sɨŋyucmɨ, d́a ixunpa iga togoypa ni tu̱m jém xut́upɨc. ");
INSERT INTO poiNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Siiga tu̱m iñt́ɨ̱wɨ mimalwadáy, jesɨc nɨ̱gɨ aamɨ iŋcut́um, wogaayɨ iga mimalwadáy. Siiga mimatóŋáypa, jesɨc d́a togoypa jém iñt́ɨ̱wɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Siiga d́a mimatóŋáypa, jesɨc nanɨ̱cɨ tuŋgac jém iñt́ɨ̱wɨ o wɨste̱n iga con wɨste̱n o tucute̱n testigo wɨ̱quejiñ t́i miñɨ́mayñe y t́i iññɨ́máyt́im jém pɨ̱xiñ jém mimalwadayñewɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Siiga d́at́im mimatóŋáypa con jém testigo, jesɨc nɨ̱gɨ nɨ́maayɨ it́u̱mpɨy jém Dios ipɨxiñt́am ju̱t́ aŋtuuma̱yajpa. Pero siiga jém pɨ̱xiñ d́at́im imatóŋáypa it́u̱mpɨy jém Dios ipɨxiñt́am, jesɨc jém pɨ̱xiñ tsɨ́y juuts tu̱m malopɨc pɨ̱xiñ jém d́apɨc icupɨcpa Dios, juuts tu̱m jém ichécpáppɨc impuesto. ");
INSERT INTO poiNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Nu̱ma mannɨ́máypa jém d́apɨc iñjɨ́ctámpa iga watta̱p yɨ́p naxyucmɨ, jesɨc d́at́im i̱ ijɨ́cpa iga watta̱iñ sɨŋyucmɨ. Jém iñjɨ́cpáppɨc iga watta̱iñ yɨ́p naxyucmɨ, jɨ́cta̱pt́im iga watta̱p sɨŋyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Mannɨ́máypat́im siiga wɨste̱n de mimicht́am yɨ́p naxyucmɨ miit́t́a de acuerdo iga iŋwágayt́ámpa Dios t́it́am iñxunpa, jesɨc michiit́ámpa jém anJa̱tuŋ Dios jém it́wɨɨp sɨŋyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Porque ju̱t́ aŋtuuma̱neyaj wɨste̱n o tucute̱n jém pɨ̱xiñ ɨch annɨyi̱mɨ je̱mt́im aŋwaganait́yaj jém ampɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Jesɨc miñ jém Peto. Icwácpa jém Jesús. Nɨmpa: —MánO̱mi, ¿ju̱na veces aŋwadáypa perdón tu̱m jém antɨ̱wɨ siiga amalwadáypa? ¿Hasta siete veces? ");
INSERT INTO poiNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesɨc Jesús icutsoŋ. Nɨmpa: —D́a mannɨ́máypa iga hasta siete veces, pero mannɨ́máypa hasta setenta veces por siete. ");
INSERT INTO poiNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Cuando iŋjacpa Dios yɨ́p naxyucmɨ, iwatpa juuts tu̱m rey cuando it́oppa icuenta con jém icuyo̱xayajpaap. ");
INSERT INTO poiNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Moj it́op icuenta, iŋwejáy tu̱m jém icuyo̱xapaap jém icnucsnewɨɨp diez mil jém tumiñ de plata iñɨ̱yi talento. ");
INSERT INTO poiNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Pero jém pɨ̱xiñ d́a wɨa̱p icseedáy jém rey it́umiñ. Jesɨc jém rey ipɨɨmɨ́y iga máyt́a̱iñ jém pɨ̱xiñ con iyo̱mo con ichɨ̱xt́am con it́u̱mpɨy jém iniit́wɨɨp iga icse̱tpa jém tumiñ. ");
INSERT INTO poiNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Jesɨc jém pɨ̱xiñ ico̱steeñáy jém rey iwiñjo̱m. Icunucsáypa. Nɨmpa: “Máno̱mi, apoyyaachɨɨyɨ. Manacseedáypa jém iñt́umiñ. Ɨch yajpa manyoj.” ");
INSERT INTO poiNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Jesɨc jém rey tsa̱m iyaachaŋja̱m jém pɨ̱xiñ. Icutsɨgáy, iwadáy perdón iga d́a icseedáy jém it́umiñ. ");
INSERT INTO poiNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Cuando put de je̱m, ipát tu̱m icompañero, icuyo̱xa̱pt́im jém rey. Icnucsne jém icompañero cien tumiñ de plata. Jesɨc imats jém pɨ̱xiñ, iŋpenjagáypa iɨscɨ. Nɨmpa: “Acseedaayɨ jém antumiñ jém manacnucsnewɨɨp.” ");
INSERT INTO poiNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Jesɨc jém tuŋgac jém icuyo̱xapaap jém rey, ico̱steeñáy jém pɨ̱xiñ. Moj iwágáy perdón. Nɨmpa: “Apoyyaachɨɨyɨ. Manacseedáypa jém iñt́umiñ jém mannucsayñewɨɨp.” ");
INSERT INTO poiNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pero jém pɨ̱xiñ jém wadayñeta̱wɨɨp perdón diez mil jém talento, d́a iwadáypa perdón jém icompañero. Icot cárcel hasta icse̱tpa jém tumiñ. ");
INSERT INTO poiNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Jesɨc cuando iixyaj t́i iwat jém pɨ̱xiñ, los demás jém icuyo̱xayajpaap jém rey, tsa̱m toy ia̱nama, nɨc iŋmadayyaj jém rey t́i iwat jém pɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Jesɨc jém rey e̱ybɨc iŋwejáy jém icuyo̱xapaap. Iñɨ́máy: “Agui mimalo. Ɨch maŋwadáy perdón it́u̱mpɨy jém tumiñ jém manacnucsnewɨɨp iga d́a anácseedáypa porque tsa̱m aŋcunucsáy iga maŋwadáyiñ perdón. ");
INSERT INTO poiNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿T́iiga d́a iñyaachaŋja̱m jém iŋcompañero jém inicnucsnewɨɨp uxaŋ tumiñ juuts ɨch manyaachaŋja̱m?” ");
INSERT INTO poiNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Jesɨc tsa̱m pɨ̱mi jóy jém rey. Icɨɨjuŋcot jém policía icɨɨjo̱m iga yaachwatta̱iñ cárcel hasta que icse̱tpa it́u̱mpɨy jém tumiñ. ");
INSERT INTO poiNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jesɨc Jesús yaj iŋmat jém cuento. Nɨmpa: —Miwadáypat́im je̱mpɨc jém anJa̱tuŋ Dios jém it́wɨɨp sɨŋyucmɨ siiga d́a iŋwadáypa perdón íña̱namaŋjo̱m jém iñt́ɨ̱wɨtam, jém mimalwadayñewɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesɨc cuando yaj iŋmat Jesús, put jém naxyucmɨ de Galilea, nɨc jém naxyucmɨ de Judea. Jac jém nɨ aŋwiñt́uc, jém río Jordán. ");
INSERT INTO poiNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Tsa̱m jáyaŋ pɨxiñt́am it́úŋɨyyajpa Jesús. Jemum icpɨs jém mɨmneyajwɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Jesɨc miñyaj algunos jém fariseoyaj iga icutɨ́tsyajpa jém Jesús. Nɨmyajpa: —¿Que wɨa̱p ichac iyo̱mo tu̱m pɨ̱xiñ siiga d́a imalwatne? ");
INSERT INTO poiNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Icutsoŋ Jesús. Iñɨ́máy: —¿Que d́a immayñe t́i nɨmpa jém Dios iŋma̱t́i cuando moj i̱t́i it́u̱mpɨy cosa: “Dios iwat tu̱m pɨ̱xiñ y tu̱m yo̱mo”? ");
INSERT INTO poiNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Nɨmpat́im jém Dios iŋma̱t́i: “Jeeyucmɨ tu̱m pɨ̱xiñ ichacpa ija̱tuŋ con ia̱pa iga iwaganait́pa jém iyo̱mo. Icuɨstɨc tsɨ́ypa tu̱mt́i mɨjta̱y.” ");
INSERT INTO poiNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Jesɨc jém pɨ̱xiñ con iyo̱mo d́am wɨste̱n. Tsɨ́y tu̱mt́i mɨjta̱y. Jeeyucmɨ d́a wɨ̱ iga ichacpa iyo̱mo jém Diospɨc iŋtuuma̱watne. ");
INSERT INTO poiNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Jesɨc jém fariseoyaj icwácyaj jém Jesús. Nɨ́mayt́a̱: —¿T́iiga nɨm jém Moisés iga tu̱m pɨ̱xiñ wɨa̱p iwadáy jém iyo̱mo tu̱m acta iga natsacyajta̱p con iwɨd́a̱ya? ");
INSERT INTO poiNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesús iñɨ́máy: —Mimicht́am, tsa̱m malo íña̱nama, jeeyucmɨ jém Moisés ijɨ́cpa iga iñchactámiñ jém iñyo̱mo. Pero cuando moj i̱t́i it́u̱mpɨy cosa, d́a iwatyajpa je̱mpɨc. ");
INSERT INTO poiNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Mannɨ́máy-pat́im siiga i̱ ichobɨychacpa jém iyo̱mo jém d́apɨc pejoyñe iga ipɨcpa tuŋgac yo̱mo, jesɨc pejóypa jém pɨ̱xiñ. Jém ipɨcpáppɨc jém yo̱mo jém tsacneta̱wɨɨp, pejóypat́im. ");
INSERT INTO poiNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jesɨc jém icuyujcɨɨwiñ iñɨ́máy Jesús: —Siiga tsa̱m táŋca iga ichacpa iyo̱mo tu̱m pɨ̱xiñ, jesɨc más wɨ̱ iga odoy yoomɨ́yiñ. ");
INSERT INTO poiNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesús iñɨ́máy jém icuyujcɨɨwiñ: —D́a it́u̱mpɨy pɨ̱xiñ wɨa̱p iit́ sin yo̱mo, nada más jém icupiŋnewɨɨp Dios. ");
INSERT INTO poiNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","It́ algunos jém pɨ̱xiñ d́a wɨa̱p iyoomɨ́y porque je̱mpam nay. It́t́im algunos d́a wɨa̱p iyoomɨ́y porque tuŋgac pɨ̱xiñ icapunne. It́t́im algunos jém pɨ̱xiñ d́a yoomɨ́ypa iga más wɨa̱iñ iwat jém Dios iyo̱xacuy. Jém wɨa̱paap iwat je̱mpɨc wɨ̱ iga iwad́iñ. ");
INSERT INTO poiNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Jesɨc ocmɨ namíñayyajta̱ Jesús jém xuxut́ tsɨ̱xt́am iga ichɨccunúgáyiñ ico̱bac y iga iŋwejpádáyiñ Dios para jeeyaj. Pero jém icuyujcɨɨwiñ iwogayyaj jém inimiññeyajwɨɨp jém tsɨ̱xt́am. ");
INSERT INTO poiNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Pero nɨmpa Jesús: —Jɨ́gayt́aamɨ iga míñiñ aámyaj jém xuxut́ tsɨ̱xt́am, odoy aŋjɨyja̱cɨ. Porque jém iŋjacyajpáppɨc Dios jex juuts yɨ́p xuxut́ tsɨ̱xt́am. ");
INSERT INTO poiNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Jesɨc Jesús ichɨccunúgáy jém tsɨ̱xt́am ico̱bac. Ocmɨ nɨc. ");
INSERT INTO poiNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Jesɨc ocmɨ núc tu̱m pɨ̱xiñ d́anam tsa̱mi. Miñ iám jém Jesús. Nɨmpa jém pɨ̱xiñ: —Agui wɨbɨc miMaestro, ¿t́i wɨa̱p aŋwat iga anait́pa jém vida jém d́apɨc cuyajpa? ");
INSERT INTO poiNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesɨc Jesús iñɨ́máy: —¿T́iiga miñɨmpa iga ɨch agui awɨ̱? It́ no más tu̱m jém wɨbɨc, je jém tanJa̱tuŋ Dios. Siiga impɨctsoŋtooba jém vida jém d́apɨc cuyajpa, jesɨc wa̱tɨ juuts nɨmpa jém Dios iŋquímayooyi. ");
INSERT INTO poiNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Jesɨc nɨmpa jém pɨ̱xiñ jém d́apɨc tsa̱mi: —¿Juppɨc aŋquímayooyi? Nɨmpa Jesús: —Odoy accaooyɨ, odoy pejooyɨ, odoy nuumɨ, odoy cumɨgóyooyɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Naid́aayɨ respeto jém iñja̱tuŋ y jém íña̱pa. To̱yɨ jém iñt́ɨ̱wɨ juuts minitoyt́a̱p iñyaac. ");
INSERT INTO poiNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Nɨmpa jém pɨ̱xiñ: —Ɨch je̱mpɨgam aŋwatne dende atsɨ̱xiñam. ¿T́i más atogóyáy? ");
INSERT INTO poiNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Iñɨ́máy Jesús: —Siiga capspa iŋwat it́u̱mpɨy juuts ixunpa Dios, cumáyaayɨ it́u̱mpɨy jém iniit́wɨɨp, chi̱ɨ jém tumiñ jém yaacha̱yajpaap. Jesɨc iniit́pa sɨŋyucmɨ jáyaŋ wɨbɨc riqueza. Jesɨc mi̱ñɨ atúŋɨɨyɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Mu imatoŋ t́i iñɨ́máy Jesús, nɨc jém pɨ̱xiñ. Tsa̱m pɨ̱mi aŋyác porque tsa̱m pɨ̱mi rico. ");
INSERT INTO poiNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jesɨc Jesús iñɨ́máy jém icuyujcɨɨwiñ: —Nu̱ma mannɨ́máypa, tsa̱m pɨ̱mi táŋca iga tɨgɨypa tu̱m ricopɨc ju̱t́ iŋjacpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","E̱ybɨc mannɨ́máypa. Más d́a táŋca iga naspa tu̱m camello tu̱m núncuypac ijosjo̱m que iga tɨgɨypa tu̱m rico ju̱t́ iŋjacpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Cuando imatoŋyaj jém icuyujcɨɨwiñ, tsa̱m pɨ̱mi ichɨgaŋjécyaj. Nɨmyaj: —¿Jesɨc i̱ wɨa̱p icɨɨput? ");
INSERT INTO poiNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesɨc Jesús iámmats jém icuyujcɨɨwiñ. Iñɨ́máy: —Nu̱ma, jém pɨxiñt́am d́a wɨa̱p iwatyaj, pero Dios wɨa̱p iwat porque Dios wɨa̱p iwat it́u̱mpɨy cosa. ");
INSERT INTO poiNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Jesɨc nɨm jém Peto: —MánO̱mi, aɨcht́am antsacnetámum it́u̱mpɨy jém anait́wɨɨp id́ɨc, mantúŋɨyñetámum. ¿Jesɨc t́i ampɨctsoŋtámpa? ");
INSERT INTO poiNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesɨc Jesús icutsoŋ. Iñɨ́máy jém icuyujcɨɨwiñ: —Nu̱ma mannɨ́máypa iga mimicht́am, jém antúŋɨyt́ampaap, cuando jooma̱se̱tpa yɨ́p nas, ɨch jém aMiññewɨɨp Sɨŋyucmɨ aco̱ñpa jém mɨjpɨc co̱ñcuyyucmɨ con Dios ipɨ̱mi. Jesɨc mimicht́am mico̱ñt́ámpa jém doce co̱ñcuyyucmɨ iga iniŋjactámpa jém doce grupo de jém Israelpɨc pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","It́u̱mpɨy jém ichacneyajwɨɨp jém it́ɨc, o it́ɨ̱wɨtam, ija̱tuŋ, ia̱pa, iyo̱mo, ichɨ̱xt́am, o iñas ɨch aŋcuyucmɨ, Dios icseedáypa yɨ́p naxyucmɨ cien veces más. Ipɨctsoŋyajpat́im jém vida jém d́apɨc cuyajpa. ");
INSERT INTO poiNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Jáyaŋ jém pɨxiñt́am, jém aŋjagoyñeyajwɨɨp, tsɨ́yyajpa tuuñiaŋcɨɨm. Jém tuuñiaŋcɨɨmpɨc, aŋjagoyyajpa. ");
INSERT INTO poiNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Jém Dios iyo̱xacuy jex juuts tu̱m pɨ̱xiñ nasɨywɨɨp. Tu̱m ja̱ma, joccuquej, nɨc iméts jém yo̱xacɨɨwiñ iga icyo̱xayajpa jém ifinca de uvas. ");
INSERT INTO poiNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ipátyaj, iwat trato con jeeyaj iga iwɨ̱yojpa jém ja̱ma. Ocmɨ icutsat jém ifinca de uvas. ");
INSERT INTO poiNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Jesɨc yucmɨm ja̱ma, como las nueve, e̱ybɨc nɨc jém pɨ̱xiñ jém plaza. Jemum iix algunos d́a inii̱yaj yo̱xacuy. ");
INSERT INTO poiNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Iñɨ́máy: “Mimicht́am nɨctaamɨ miyo̱xa̱jit́am jém amfinca. Maŋwɨ̱yojpat́im.” Jesɨc jeeyaj nɨcyajpat́im yo̱xa̱ji. ");
INSERT INTO poiNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","E̱ybɨc nɨc jém finca io̱mi jém plaza cugapja̱ma y a las tres de la tarde. Je̱mpɨct́im iwat. ");
INSERT INTO poiNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Jesɨc a las cinco de la tarde e̱ybɨct́im nɨc jém plaza. Ipát algunos jém pɨxiñt́am d́a inii̱yaj yo̱xacuy. Iñɨ́máy: “¿T́iiga miit́t́a yɨɨm? ¿Mu̱ma ja̱ma d́a sɨ́p iñyo̱xata?” ");
INSERT INTO poiNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Nɨmyajpa: “D́a i̱ oy amétsta iga nɨguiñ ayo̱xa̱jit́am.” Jesɨc nɨmpa jém finca io̱mi: “Jesɨc nɨ̱gɨ miyo̱xa̱jit́am jém amfinca. Maŋwɨ̱yojpat́im.” ");
INSERT INTO poiNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","’Jesɨc cuando tɨgɨyñeum ja̱ma, jém finca io̱mi iñɨ́máy jém cabo jém iwatpaap cuenta jém ifinca: “Sɨɨp aŋwejayyajɨ jém anyo̱xacɨɨwiñ, yojya̱jɨ. Wiñt́i yo̱jɨ jém ocmɨpɨc núcyaj. Jesɨc ocmɨ yo̱jɨt́im jém wiñt́ipɨc núcyaj.” ");
INSERT INTO poiNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Cuando núcyaj jém miññeyajwɨɨp a las cinco, it́u̱mpɨy wɨ̱yojyajta̱ juutst́im yo̱xane mu̱ma ja̱ma. ");
INSERT INTO poiNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ocmɨ cuando núcyaj jém mojnewɨɨp mi̱ñi, ijɨ̱syajpa iga más jáyaŋ yojyajta̱p. Pero jesaŋt́im yojyajta̱p juuts jém tɨgɨyñewɨɨp a las cinco de la tarde. ");
INSERT INTO poiNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Jesɨc yaj ipɨctsoŋyaj jém icoñwɨyooyi, moj icujɨyyaj jém finca io̱mi. ");
INSERT INTO poiNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Jesɨc iñɨ́mayyaj jém finca io̱mi: “Jém ocmɨpɨc núcyaj yo̱xayaj tu̱m hora no más, pero jesaŋt́im ipɨctsoŋyaj juuts aɨcht́am. Tsa̱m pɨ̱mi ayo̱xata mu̱ma ja̱ma, anyaachɨyt́a jém ja̱mpi̱ji.” ");
INSERT INTO poiNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Jesɨc jém finca io̱mi icutsoŋ. Iñɨ́máy tu̱m jém pɨ̱xiñ jém icujɨyñewɨɨp: “Amigo, d́a mammalwaday ni uxaŋ. ¿Que d́a manawat trato iga manyojpa tu̱m ja̱ma icoñwɨyooyi? ");
INSERT INTO poiNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Jesɨc pɨ̱cɨ jém iŋcoñwɨyooyi, nɨcsɨm. Ɨch anyojtooba jém ocmɨpɨc núc jutsaŋt́im mich manyoj. ");
INSERT INTO poiNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Que d́a wɨa̱p aŋwat juuts ɨch ansunpa con antumiñ? Tsa̱m miña̱jajóypa porque ɨch aŋwɨ̱wadáypa jém tuŋgac anyo̱xacɨɨwiñ.” ");
INSERT INTO poiNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jém tuuñiaŋcɨɨmpɨc aŋjagóypa. Jém aŋjagoyñewɨɨp tsɨ́ypa tuuñiaŋcɨɨm. Jáyaŋ jém pɨxiñt́am aŋwejayyajta̱p, pero d́a wa̱t́i jém cupiŋneyajta̱wɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Cuando nɨquiyaj Jesús tuŋjo̱m iga nɨcpa Jerusalén, iŋwejáy aparte jém icuyujcɨɨwiñ. Iñɨ́máy: ");
INSERT INTO poiNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Matoŋtaamɨ. Sɨɨp tanɨctámpa Jerusalén. Ɨch, jém aMiññewɨɨp Sɨŋyucmɨ, acɨɨjuŋcotta̱p jém pa̱nij aŋjagooyi icɨɨjo̱m y jém escribaspɨc maestroyaj icɨɨjo̱m. Jeeyaj acɨɨpiŋpa, achiiba mɨjpɨc castigo. Ocmɨ ijɨ̱syajpa iga accaayajpa. ");
INSERT INTO poiNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Acɨɨjuŋcotta̱p jém tuŋgac pɨ̱xiñ icɨɨjo̱m iga axiccayajpa, acótsyajpa y acunúnyajpa cunusyucmɨ. Accaayajpa, pero jém tucunaja̱ma apɨspa de ju̱t́ it́ jém caaneyajwɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ocmɨ icunúcyaj Jesús wɨste̱n jém icuyujcɨɨwiñ jém Jacobo y Xiwan. Iwaganamiñyaj ia̱pa, jém Zebedeo iyo̱mo. Co̱ste̱ñ jém Jesús iwiñjo̱m iga iwágáypa tu̱m favor. ");
INSERT INTO poiNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesɨc Jesús icwácpa jém yo̱mo. Nɨ́mayt́a̱: —¿T́i iñxunpa? Nɨmpa jém yo̱mo: —Cuando iniŋjacpa yɨ́p naxyucmɨ, ansunpa iga yɨ́p wɨste̱n amma̱nɨc ipɨctsóŋiñ tu̱m mɨjpɨc cargo. Tu̱m co̱ñpa mich iniŋwɨ̱mɨ y tu̱m iniŋna̱ymɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Pero Jesús icutsoŋ, iñɨ́máy: —Mimicht́am d́a iñjo̱doŋtam t́i iŋwácpa. ¿Que mimicht́am wɨa̱p iñyaachɨ́y jém yaacha̱ji jém ɨchpɨc ampɨctsoŋpa? ¿Wɨa̱p íñuc jém copa jém ɨchpɨc ánucpa? Nɨmpa jém wɨste̱n: —Awɨa̱támpa. ");
INSERT INTO poiNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesɨc Jesús iñɨ́máy: —Nu̱ma íñucpa jém copa jém ɨchpɨc ánucpa y wɨa̱p impɨctsoŋ jém yaacha̱ji juuts ampɨctsoŋpa aɨch. Ɨch d́a wɨa̱p manchi jém derecho iga nɨcpa mico̱ñi anaŋwɨ̱mɨ y anaŋna̱ymɨ. Ichiiba anJa̱tuŋ Dios jém icupiŋnewɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Jesɨc cuando imatoŋyaj jém diez icuyujcɨɨwiñ, tsa̱m ijóyixyaj jém wɨste̱n. ");
INSERT INTO poiNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Pero Jesús iŋwejáy los demás jém icuyujcɨɨwiñ iga iŋmadáypa. Nɨmpa: —Micht́am iñjo̱doŋ iga jém juumɨpɨc pɨxiñt́am iŋjagooyiyaj tsa̱m ipɨɨmɨ́ypa jém ipɨxiñt́am. Jém más mɨjpɨc aŋjagooyi más pɨ̱mi ipɨɨmɨ́ypa jém ipɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pero mimicht́am d́a iŋwattámpa je̱mpɨc. Siiga mɨjpɨc miŋjagooyi, jesɨc iŋcuyo̱xa̱p jém iñt́ɨ̱wɨtam. ");
INSERT INTO poiNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Jém más mɨjpɨc aŋjagooyi entre mimicht́am micuyo̱xa̱p juuts tu̱m esclavo. ");
INSERT INTO poiNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Iŋwattámpat́im juuts aɨch. Ɨch amiñ sɨŋyucmɨ iga aŋcuyo̱xa̱p jém it́yajwɨɨp yɨ́p naxyucmɨ. D́a amiñ iga acuyo̱xata̱p. Amiñ iga anchiiba amvida iga anyojáypa jáyaŋ pɨxiñt́am it́áŋca. ");
INSERT INTO poiNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jesɨc cuando putyaj jém attebet Jericó, tsa̱m jáyaŋ pɨxiñt́am it́úŋɨyyajpa Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Wɨste̱n cácht́i co̱ñyaj jém tuŋ aŋna̱ca. Cuando imatoŋyaj iga naspa Jesús, jesɨc pɨ̱mi jɨyyajpa jém cácht́i. Nɨmyaj: —MánO̱mi, jém rey David mima̱nɨc, ayaachaŋja̱mɨ aɨcht́am. ");
INSERT INTO poiNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Pero jém it́úŋɨyyajpaap Jesús iwogayyajpa jém cácht́i. Iñɨ́mayyajpa iga odoy jɨyyajiñ. Pero más pɨ̱mi jɨypa jém cácht́i. Nɨmyaj: —MánO̱mi, mich jém rey David mima̱nɨc, ayaachaŋja̱mɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesɨc teeñaŋjac Jesús. Iŋwejáy jém wɨste̱n iga miñyajiñ. Cuando núc, iñɨ́máy Jesús: —¿T́i iñxunpa iga maŋwadáypa? ");
INSERT INTO poiNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Nɨmyaj jém cácht́iyaj: —MánO̱mi, ansunpa iga aixixóyiñ. ");
INSERT INTO poiNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesɨc iyaachaŋja̱mpa Jesús. Ichɨgáy iixcuy. Jeet́i rato ixixóypam. Mojum it́úŋɨyyaj jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Cuando núcyajtooba Jerusalén, núcyaj wiñt́i jém attebet Betfagé nocojo̱m jém Olivos co̱tsɨc. Jesɨc icutsat wɨste̱n jém icuyujcɨɨwiñ tuŋgac xut́u tɨgaŋjoj. ");
INSERT INTO poiNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Iñɨ́máy Jesús: —Nɨctaamɨ jém tɨgaŋjoj jexpɨc it́. Cuando miñúctámpa impáttámpa tu̱m burroa̱pa tsenne con ima̱nɨc. Wi̱jɨ, anamíñaayɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Siiga i̱ micwácpa iga: “¿T́iiga iŋwijpa?” jesɨc nɨ́maayɨ iga jém tánO̱mi ixunpa y d́a jáypa micutsadáypa e̱ybɨc. ");
INSERT INTO poiNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Je̱mpɨgam iwatyaj iga cupacpa jém aŋma̱t́i jém ijaychacnewɨɨp jém wiñɨcpɨc aŋmat́cɨɨwiñ. Nɨmpa: ");
INSERT INTO poiNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Nɨ́maayɨ jém it́yajwɨɨp jém attebet Jerusalén: “Ixt́aamɨ iga miñpa jém iñRey. D́a malo, d́a nacujípta̱p. Iquímcane tu̱m burro. Miñpa tu̱m ma̱ñburroyucmɨ, tu̱m burroa̱pa ima̱nɨc.” ");
INSERT INTO poiNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jesɨc nɨcyaj jém wɨste̱n icuyujcɨɨwiñ. Iwatyaj juuts iñɨ́máy Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Inimiñyaj jém burroa̱pa con ima̱nɨc. Icutócyaj con iyoot́iyaj. Jesɨc iquímca Jesús jém ma̱ñburro. ");
INSERT INTO poiNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Miñyaj tsa̱m jáyaŋ pɨxiñt́am y yo̱mtam. It́ócyajpa iyoot́i tuŋjo̱m ju̱t́ naspa Jesús. Tuŋgac it́ɨŋyajpa jém cuy iŋcɨs y jém ay iga it́ócyajpat́im tuŋjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Algunos aŋjagoyñeyaj iñɨc y algunos miñyajpa jém Jesús it́uuñiaŋcɨɨm. Pɨ̱mi aŋwejyajpa. Nɨmyaj: —Taŋcujíptámpa jém rey David iMa̱nɨc. Agui wɨ̱ yɨ́p tanaŋjagooyi jém tacutsadayñewɨɨp Dios. Agui wɨ̱ jém tanJa̱tuŋ Dios. ");
INSERT INTO poiNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Cuando tɨgɨy Jesús jém attebet Jerusalén, tsa̱m cujínayyajpa it́u̱mpɨy jém pɨxiñt́am. Nacwácyajta̱: —¿I̱apaap yɨ́p pɨ̱xiñ? ");
INSERT INTO poiNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Jesɨc nɨmyajpa jém pɨxiñt́am jém miññeyajwɨɨp con Jesús: —Yɨ́p pɨ̱xiñ Jesús jém Dios iŋmat́cɨɨwiñ. Nazaretpɨc pɨ̱xiñ de jém naxyucmɨ de Galilea. ");
INSERT INTO poiNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ocmɨ tɨgɨy Jesús jém mɨjpɨc ma̱stɨcjo̱m. Moj iquebacput it́u̱mpɨy jém máymáyoyyajpaap con it́u̱mpɨy jém juyjúyoyyajpaap. Ichiputseedáy jém imesayaj jém icucacyajpaap tumiñ. Imutsmutsseedáy jém ico̱ñcuyyaj jém imáyyajpaap cuucu. ");
INSERT INTO poiNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Iñɨ́máy Jesús jém it́yajwɨɨp je̱m: —Nɨmpa jém Dios iŋma̱t́i jém jayñewɨɨp: “Antsac antɨc ju̱t́ iwatyajpa oración jém pɨxiñt́am.” Pero mimicht́am inicse̱tneta jém Dios ima̱stɨc juuts tu̱m tɨc ju̱t́ it́ jém númyajpaap. ");
INSERT INTO poiNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jesɨc miñ iámyaj Jesús jém mɨjpɨc ma̱stɨcjo̱m jém cácht́i y jém cu̱xujyaj. Icpɨs. ");
INSERT INTO poiNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Jém co̱bacpɨc pa̱nijyaj con jém escribaspɨc maestroyaj agui jóyñeyaj cuando iixyaj jém wɨbɨc milagro jém iwatnewɨɨp Jesús y cuando imatoŋyaj iga pɨ̱mi jɨyyajpa jém tsɨ̱xt́am ma̱stɨcjo̱m, nɨmyajpa: “Taŋcujíptámpa jém rey David iMa̱nɨc.” ");
INSERT INTO poiNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Jesɨc jém pa̱nijyaj iñɨ́mayyaj jém Jesús: —¿Que d́a immatoŋ t́i nɨmpa yɨ́p tsɨ̱xt́am? Jesús icutsoŋ. Nɨmpa: —Nu̱ma, ammatoŋ. ¿Que d́a immayñe jém Dios iŋma̱t́i? Nɨmpa así: Dios ichiiba jɨ̱xi jém xuxut́ tsɨ̱xt́am iga icujípyajiñ Dios juuts je iwɨ̱aŋja̱m. ");
INSERT INTO poiNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jesɨc moj nɨqui jém Jesús. Jemum ichac jém pa̱nij. Nɨc mo̱ŋi jém xut́u tɨgaŋjoj jém Betania. ");
INSERT INTO poiNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Jesɨc icuqueja̱ma, cuando se̱tgacpa Jerusalén, tsa̱m yua̱p jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Iix tu̱m tsuj tuŋaŋna̱ca. Nɨc icuámáy jém tsuj it́ɨm, pero d́a ipadáy. Nada más it́ jém iay. Jesɨc Jesús iñɨ́máy jém tsuj: —D́a nunca mit́ɨ́ma̱p e̱ybɨc. Jeet́i rato tɨts jém tsuj. ");
INSERT INTO poiNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Cuando iixyaj jém icuyujcɨɨwiñ, agui ipooñaŋja̱myaj. Icwácyaj jém Jesús. Nɨ́mayt́a̱: —¿T́iiga tsa̱m jicscɨy tɨts jém tsuj? ");
INSERT INTO poiNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesús icutsoŋ. Nɨmpa: —Siiga tsa̱m iŋcupɨcpa iga Dios wɨa̱p iwat it́u̱mpɨy cosa y siiga d́a iñjɨ̱spa íña̱namaŋjo̱m iga d́a wɨa̱p, jesɨc d́a no más wɨa̱p iŋwat juuts ɨch aŋwadáy jém tsuj, pero wɨa̱pt́im iññɨ́máy yɨ́p co̱tsɨc iga caayɨ de yɨɨm, nɨ̱gɨ miniccámta̱ji lamar, jesɨc miwadáypa Dios juuts iŋwágáypa. ");
INSERT INTO poiNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Siiga nu̱ma iŋcupɨcpa iga Dios wɨa̱p miyo̱xpát, jesɨc impɨctsoŋpa t́it́am iŋwágáypa Dios. ");
INSERT INTO poiNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jesɨc tɨgɨy e̱ybɨc Jesús jém mɨjpɨc ma̱stɨcjo̱m. Iganam accuyujóypa Jesús, icunúcyaj jém pa̱nij aŋjagooyiyaj con jém Israelpɨc wɨd́ayt́am. Icwácyajpa. Nɨ́mayt́a̱ Jesús: —¿I̱ michi jém pɨ̱mi iga iŋwatpa juuts mich sɨ́p iŋwat? ¿I̱ micutsat? ");
INSERT INTO poiNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesús icutsoŋ. Iñɨ́máy: —Ɨch manacwácpat́im, siiga aŋcutsoŋpa, jesɨc mannɨ́máypat́im ju̱t́ ampɨc jém pɨ̱mi iga aŋwatpa juuts sɨ́p aŋwat. ");
INSERT INTO poiNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Anɨ́maayɨ: ¿I̱ icutsat jém Xiwan iga acchíŋóypa? ¿Que Dios icutsat, o jém pɨxiñt́am? Jesɨc jém aŋjagooyiyaj nacwácyajta̱ entre jeeyaj: —Siiga tanɨmpa iga Dios icutsat jém Xiwan, jesɨc tanɨ́máypa: “¿T́iiga d́a iŋcupɨcta?” ");
INSERT INTO poiNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Pero siiga tannɨ́máypa iga d́a je Dios icutsat jém Xiwan, jesɨc tsa̱m taŋcɨ̱ŋpa jém pɨxiñt́am porque icupɨcyajpa iga Dios icutsat jém Xiwan. ");
INSERT INTO poiNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Jesɨc icutsoŋyajpa. Nɨ́mayt́a̱p Jesús: —Aɨcht́am d́a anjo̱doŋ i̱ icutsat jém Xiwan. Jesɨc Jesús iñɨ́máy: —Ɨch d́at́im mannɨ́máypa ju̱t́ ampɨc jém autoridad iga aŋwatpa juuts sɨ́p aŋwat. ");
INSERT INTO poiNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesɨc Jesús iŋmadáy tu̱m xut́u cuento. Nɨmpa: —¿T́i iñjɨ̱spa? Iniit́ id́ɨc tu̱m pɨ̱xiñ wɨste̱n ijayma̱nɨc. Nɨc iñɨ́máy jém tu̱m: “Ma̱nɨc, yɨ́p ja̱ma nɨ̱gɨ miyo̱xa̱ji jém amfinca de uvas.” ");
INSERT INTO poiNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Jém ima̱nɨc iñɨ́máy ija̱tuŋ: “D́a anɨcpa.” Pero ocmɨ icac ijɨ̱xi, nɨc yo̱xa̱ji. ");
INSERT INTO poiNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Jesɨc ocmɨ jém ja̱tuŋpɨc nɨc iñɨ́máy jém tuŋgac ima̱nɨc: “Ma̱nɨc, nɨ̱gɨ miyo̱xa̱ji yɨ́p ja̱ma jém amfinca de uvas.” Jesɨc jém tuŋgac ima̱nɨc iñɨ́máy ija̱tuŋ: “Ɨch anɨcpa.” Pero ocmɨ d́a nɨc. ");
INSERT INTO poiNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Jesɨc anɨ́maayɨ: ¿Juppɨc de jém wɨste̱n iwat juuts ixunpa ija̱tuŋ? Nɨmyajpa jém aŋjagooyiyaj: —Jém wiñt́ipɨc. Nɨmpa Jesús: —Nu̱ma mannɨ́máypa iga jém malopɨc pɨxiñt́am jém ichécyajpaap impuesto y jém malopɨc yo̱mtam tɨgɨyyajpa ju̱t́ iŋjacpa Dios wiñt́it́im antes que mimicht́am. ");
INSERT INTO poiNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Porque jém Xiwan jém acchíŋoypaap miñ iga miŋquejayt́ámiñ jutsa̱p iŋwatta juuts ixunpa Dios, pero d́a iŋcupɨcta. Pero jém ichécyajpaap impuesto y jém malopɨc yo̱mtam icupɨcyaj t́i iñɨ́máy jém Xiwan. Aunque íñixñeta iga jém malopɨc ichacyaj jém it́áŋca, mimicht́am d́a iŋcacta jém iñjɨ̱xi iga iŋcupɨctámpa jém Xiwan iŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Nɨmt́im Jesús: —Matoŋtaamɨ tuŋgac xut́u cuento: It́ id́ɨc tu̱m pɨ̱xiñ nasɨywɨɨp. Iñip tu̱m finca de uvas. Icutánne. Iwat tu̱m tsaajos ju̱t́ it́obáypa jém uvas iñɨ iga iwatpa jém vino. Iwatt́im tu̱m torre ju̱t́ iwatpa cuenta jém uvas. ’Cuando cupacneum, icnucs jém finca de uvas tuŋgac pɨxiñt́am iga iyo̱xacaiñ. Ocmɨ nɨc jém nas io̱mi tuŋgac naxyucmɨ ju̱t́ tsa̱m juumɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Cuando núc jém tiempo iga it́úcyajpa jém uvas, jém finca io̱mi icutsat jute̱n jém imozoyaj iga ipɨctsóŋiñ jém io̱mi imɨɨchi. ");
INSERT INTO poiNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pero jém iñucsneyajwɨɨp jém finca iga iyo̱xacaaba imatsyaj jém imozoyaj. Tu̱m tsa̱m icótsyaj, tu̱m iccaayaj, tu̱m iñácscayaj tsaamɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Jesɨc e̱ybɨc jém nas io̱mi icutsat tuŋgac más jém imozo, pero jém iñucsneyajwɨɨp jém ifinca imalwadayyajpat́im mex jeeyaj. ");
INSERT INTO poiNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Jesɨc ocmɨ jém nas io̱mi icutsat ima̱nɨc iga ipɨctsoŋpa jém ija̱tuŋ imɨɨchi. Nɨmpa: “Tienes que iwɨ̱pɨctsoŋyajpa jém amma̱nɨc.” ");
INSERT INTO poiNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pero cuando jém iñucsneyajwɨɨp jém finca iixyaj iga miñpa jém io̱mi ima̱nɨc, moj nanɨ́mayyajta̱ji: “Yɨ́bam ipɨctsoŋpa it́u̱mpɨy jém ija̱tuŋ imɨɨchi. Tej tanacca, jesɨc taɨcht́am tamɨɨcha̱támpa t́it́am ichiiba jém ija̱tuŋ.” ");
INSERT INTO poiNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Jesɨc imatsayyaj jém pɨ̱xiñ ima̱nɨc. It́opyaj aŋsɨ̱cmɨ, iccaayaj. ");
INSERT INTO poiNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jesɨc Jesús icwác jém pa̱nijyaj. Nɨmpa: —Sɨɨp anɨ́maayɨ: Cuando miñpa jém nas io̱mi, ¿t́i iniwatpa jém iwatyajpáppɨc cuenta jém iñas? ");
INSERT INTO poiNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Jesɨc jém pa̱nijyaj icutsoŋyaj, nɨmyaj: —Accaayajta̱p it́u̱mpɨy jém malopɨc pɨxiñt́am. D́a iyaachaŋja̱mpa ni uxaŋ jém finca io̱mi. Jesɨc ocmɨ icnucspa tuŋgac pɨ̱xiñ, jém iwégaypaap jém cosecha cuando núcpa itiempo. ");
INSERT INTO poiNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesɨc nɨmpa Jesús: —¿Que d́a immayñeta jém Dios iŋma̱t́i ju̱t́ jayñe? Nɨmpa: Jém tɨcwatpaap ipatsayt́ɨp tu̱m tsa. Pero ocmɨ jeet́im tsa piŋta̱. Sɨɨp jeet́im tsa icóppacne jém tɨc. Je̱mpam iwat jém tanJa̱tuŋ Dios. Cuando tánixt́ámpa, agui tampooñaŋja̱mtámpa. ");
INSERT INTO poiNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Jeeyucmɨ mannɨ́máypa iga miccáyayt́a̱p jém wɨbɨc aŋma̱t́i iga sɨɨp Dios iŋjacpa yɨ́p naxyucmɨ. Chiit́a̱p jém tuŋgac pɨxiñt́am jém ichiipaap jém wɨbɨc cosecha juuts ixunpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Siiga michutpa yɨ́p tsaayucmɨ, micusámáypa. Siiga yɨ́p tsa micuchijquetpa, jesɨc michɨ́ypa iga mipoot́i. ");
INSERT INTO poiNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Jesɨc cuando jém pa̱nij aŋjagooyiyaj con jém fariseoyaj imatoŋyaj jém xuxut́ cuento, icutɨɨyɨyyaj iga jeeyaj icuyucmɨ iŋmatpa Jesús jém xuxut́ cuento. ");
INSERT INTO poiNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Tsa̱m imatsyajtooba Jesús, pero d́a wɨa̱p imatsyaj. Jém aŋjagooyiyaj tsa̱m icɨ̱ŋyaj jém pɨxiñt́am porque jeeyaj icupɨcyajpa iga tu̱m Dios iŋmat́cɨɨwiñ jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesɨc Jesús iŋmatpa tuŋgac más cuento. Nɨmpa: ");
INSERT INTO poiNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Jém tiempo cuando Dios iŋjacpa jém pɨxiñt́am jex juuts tu̱m rey cuando aŋcoomɨ́ypa ijayma̱nɨc. Jém ija̱tuŋ iwatpa tu̱m mɨjpɨc sɨŋ. ");
INSERT INTO poiNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Cuando yajum iwɨ̱tsac it́u̱mpɨy cosa, icutsat jém icuyo̱xayajpaap iga iŋwejayyajpa jém pɨxiñt́am jém it́ɨ́pneyajwɨɨp. Pero jeeyaj d́a miñt́ooba. ");
INSERT INTO poiNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Jesɨc e̱ybɨc icutsat tuŋgac más jém icuyo̱xayajpaap. Iñɨ́máy: “Nɨ́mayya̱jɨ jém antɨ́pneyajwɨɨp iga watneum jém wíccuy. Accaaneta̱wum jém xix y jém borregoyaj jém anacpɨ̱newɨɨp. Sɨɨp it́um listo, miñyajiñ ju̱t́ it́ jém aŋcoomɨ́yóycuy.” ");
INSERT INTO poiNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","’Pero jeeyaj d́a iwadáy caso. Tu̱m nɨc ica̱mjo̱m, tu̱m nɨc máymáyooyi. ");
INSERT INTO poiNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Tuŋgac imats jém icutsatneyajwɨɨp jém rey, moj imalwadayyaj hasta iccaayaj algunos. ");
INSERT INTO poiNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Jesɨc cuando imatoŋ jém rey t́i iñasca jém icuyo̱xayajpaap, tsa̱m pɨ̱mi jóy. Icutsat jém soldado iga accaayajta̱iñ jém accaoyñeyajwɨɨp y iga nooquetta̱iñt́im jém attebet ju̱t́ it́ jém malopɨc pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Jesɨc e̱ybɨc jém rey iñɨ́máy jém icuyo̱xayajpaap: “It́um listo jém aŋcoomɨ́yóycuy, pero jém mojnewɨɨp antɨ́p d́a wɨ̱ iga miñpa. ");
INSERT INTO poiNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Jesɨc nɨctaamɨ ju̱t́ aŋwácne jém tuŋ ju̱t́ nasyajpa jáyaŋ jém pɨxiñt́am. Nɨ́mayya̱jɨ it́u̱mpɨy jém impátpáppɨc iga miñyajiñ ju̱t́ it́ jém aŋcoomɨ́yóycuy.” ");
INSERT INTO poiNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Jesɨc nɨcyaj jém icuyo̱xayajpaap ju̱t́ nasyajpa jáyaŋ jém pɨxiñt́am. Iŋtuuma̱watyajpa it́u̱mpɨy jém ipátneyajwɨɨp, jém malopɨc y jém wɨbɨc. Je̱mpɨgam com jém tɨc ju̱t́ it́ jém aŋcoomɨ́yóycuy. ");
INSERT INTO poiNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Jesɨc tɨgɨy jém rey iga iámpa jém aŋtuuma̱neyajwɨɨp. Iix tu̱m pɨ̱xiñ d́a ipɨctsoŋne jém wɨbɨc yoot́i jém iccámaypáppɨc jém rey icuyo̱xapaap para jém sɨŋjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Jesɨc jém rey iñɨ́máy jém pɨ̱xiñ: “Amigo, ¿jutsa̱ mu iñt́ɨgɨy yɨɨm y d́a i̱ miccámáy jém wɨbɨc yoot́i para jém aŋcoomɨ́yóycuy?” D́a jɨy jém pɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Jesɨc jém rey iñɨ́máy jém icuyo̱xapaap: “Matstaamɨ yɨ́p pɨ̱xiñ, tsénayt́aamɨ icɨ y ipuy. Cottaamɨ jém piichcɨɨm jém it́wɨɨp aŋsɨ̱cmɨ, ju̱t́ tsa̱m wejyajpa, ju̱t́ iñichyajpa it́ɨts.” ");
INSERT INTO poiNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Porque tsa̱m jáyaŋ aŋwejayyajta̱p, pero d́a wa̱t́i cupiŋneyajta̱. ");
INSERT INTO poiNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Jesɨc jém fariseoyaj moj ijɨ̱syaj jutsa̱p iquejajwadáy jém Jesús con jeet́im iŋquímayooyi jém iŋquejayñewɨɨp jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Jeeyucmɨ icutsatyaj algunos jém fariseoyaj icuyujcɨɨwiñ con algunos jém Herodes ipɨxiñt́am iga iniŋmatyajiñ jém Jesús. Nɨ́mayt́a̱p: —Maestro, anjo̱dóŋa̱ta iga siempre iniŋmatpa jém nu̱mapɨc aŋma̱t́i. Iniŋquejpa parejo jém Dios iŋma̱t́i, d́a i̱ immɨgóyáypa. D́a iŋwada̱p caso t́i nɨmyajpa jém pɨxiñt́am. D́a i̱ iŋcɨ̱ŋpa. ");
INSERT INTO poiNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Jesɨc anɨ́maayɨ t́i iñjɨ̱spa: ¿Wɨ̱ iga tanyojpa impuesto jém Romapɨc aŋjagooyi o d́a wɨ̱? ");
INSERT INTO poiNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Pero Jesús icutɨɨyɨ́ypa iga tsa̱m iniit́yaj malopɨc jɨ̱xi ia̱namaŋjo̱m. Iñɨ́máy: —Mimicht́am miñɨ́maŋtaaya̱p iga iŋwattooba juuts ixunpa Dios. ¿T́iiga aŋcutɨ́tspa? ");
INSERT INTO poiNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Aŋquejaayɨ tu̱m jém tumiñ jém iñyojóycapaap jém impuesto. Jesɨc namíñayt́a̱ Jesús jém tumiñ. ");
INSERT INTO poiNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jesɨc mu iix Jesús, icwácpa. Nɨ́mayyajta̱p: —¿I̱ iwiñpac it́ yɨ́p tumiñyucmɨ? ¿I̱ iñɨ̱yi jaycámayñeta̱? ");
INSERT INTO poiNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Nɨmyajpa: —Jém César jém Romapɨc aŋjagooyi. Jesɨc nɨmpa Jesús: —Chiit́aamɨ jém César jém Césarpɨc imɨɨchi. Chiit́aamɨ Dios jém Diospɨc imɨɨchi. ");
INSERT INTO poiNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Cuando imatoŋyaj t́i iñɨ́máy Jesús, tsa̱m ipooñaŋja̱myajpa jém miññeyajwɨɨp. Ichacyaj Jesús, nɨcyaj. ");
INSERT INTO poiNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Jesɨc jeet́im ja̱ma miñ iámyaj Jesús algunos jém saduceoyaj, jém d́apɨc icupɨcyajpa iga pɨspa jém caaneyajwɨɨp. Jeeyucmɨ miñ icwác Jesús. Nɨmyaj: ");
INSERT INTO poiNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Maestro, nɨmpa jém Moisés, siiga caaba tu̱m pɨ̱xiñ y ichacpa iyo̱mo, pero d́a ichac ni tu̱m ima̱nɨc, jesɨc jém pɨ̱xiñ it́ɨ̱wɨ ipɨgáyiñ jém iyo̱mo iga inima̱nɨcwatpa. Jesɨc jém tsɨ̱xi tsɨ́ypa juuts jém caanewɨɨp ima̱nɨc. ");
INSERT INTO poiNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","It́ id́ɨc con aɨcht́am siete pɨ̱xiñ tu̱mt́i ija̱tuŋ. Jesɨc yoomɨ́y jém más a̱chpɨc. Ocmɨ ca. D́a ichac ni tu̱m ima̱nɨc. Jesɨc jém ipɨɨtsɨ ipɨc jém ica̱pay. ");
INSERT INTO poiNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Iñascat́im je̱mpɨc jém ipɨɨtsɨ y jém tuŋgac jém ijáyuc hasta que icusiete ipɨcyaj jém yo̱mo. Caayaj it́u̱mpɨyyaj. ");
INSERT INTO poiNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ocmɨ caat́im mex jém yo̱mo. ");
INSERT INTO poiNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Jesɨc cuando Dios icpɨspa it́u̱mpɨy jém caaneyajwɨɨp, ¿juppɨc de jeeyaj tsɨ́ypa juuts jém yo̱mo iwɨd́a̱ya? Porque icusiete iniŋcoomɨyyaj jém yo̱mo. ");
INSERT INTO poiNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesɨc Jesús icutsoŋ. Nɨmpa: —Mimicht́am tsa̱m mijɨ̱xit́ogoyñeta porque d́a iŋcutɨɨyɨyt́ámpa jém Dios iŋma̱t́i ni d́at́im iŋcutɨɨyɨyt́ámpa t́i wɨa̱p iwat Dios con ipɨ̱mi. ");
INSERT INTO poiNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Cuando acpɨsyajta̱p jém caaneyajwɨɨp, d́am aŋcoomɨyyajpa, d́am napɨcyajta̱p jém pɨxiñt́am con jém yo̱mtam. Tsɨ́yyajpa juuts jém sɨŋyucmɨpɨc pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Sɨɨp manaŋquejáypa iga nu̱ma acpɨsyajta̱p jém caaneyajwɨɨp. ¿Que d́a immayñe jém Dios iŋma̱t́i t́i miñɨ́máy Dios? Nɨmpa: ");
INSERT INTO poiNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Ɨch jém Abraham aDios, jém Isaac aDios y jém Jacob aDios.” Jesɨc quejpa iga jém tanJa̱tuŋ Dios d́a je jém caanewɨɨp iDios, je jém vivopɨc iDios. ");
INSERT INTO poiNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jesɨc jém miññeyajwɨɨp je̱m agui ipooñaŋja̱myajpa cuando imatoŋyaj jém Jesús iŋquímayooyi. ");
INSERT INTO poiNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Cuando jém fariseoyaj ijo̱dóŋa̱yaj iga Jesús d́a icjɨyyaj jém saduceoyaj, jesɨc e̱ybɨc aŋtuuma̱yaj ju̱t́ it́ Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Tu̱m de jeeyaj, jém maestro de jém wiñɨcpɨc aŋquímayooyi, tsa̱m icutɨ́tstooba jém Jesús. Jesɨc iñɨ́máy: ");
INSERT INTO poiNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Maestro, ¿juppɨc jém más mɨjpɨc aŋquímayooyi de jém Moisés iŋquímayooyi? ");
INSERT INTO poiNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesús iñɨ́máy: —“To̱yɨ jém tanJa̱tuŋ Dios con it́u̱mpɨy íña̱nama y con it́u̱mpɨy iñjɨ̱xi.” ");
INSERT INTO poiNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Yɨ́bam jém mɨjpɨc aŋquímayooyi jém wiñt́ipɨc. ");
INSERT INTO poiNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Jém tuŋgac aŋquímayooyi jext́im. Nɨmpa: “To̱yɨ jém iñt́ɨ̱wɨ juuts minitoyt́a̱p iñyaac.” ");
INSERT INTO poiNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Siiga iŋwatpa juuts nɨmpa icuɨstɨc yɨ́p aŋquímayooyi, jesɨc capsum iŋwat it́u̱mpɨy jém aŋquímayooyi jém ichacnewɨɨp jém Moisés y it́u̱mpɨy jém wiñɨcpɨc aŋmat́cɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Iganam aŋtuuma̱neyaj je̱m jém fariseoyaj, Jesús icwác. ");
INSERT INTO poiNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Iñɨ́máy: —Anɨ́maayɨ t́i iñjɨ̱stámpa, ¿i̱ ima̱nɨc jém Cristo? Nɨmyaj jém fariseoyaj: —Jém David ima̱nɨc. ");
INSERT INTO poiNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jesús iñɨ́máy: —Jém Dios iA̱nama ichi jɨ̱xi jém David iga wɨa̱p iŋmat, ¿jesɨc t́iiga nɨmpa jém David iga jém Cristo je jém iO̱mi? Porque nɨmpa jém David: ");
INSERT INTO poiNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Jém anJa̱tuŋ Dios iñɨ́máy jém ánO̱mi Cristo: “Co̱ñɨ yɨɨm anaŋwɨ̱mɨ hasta que iŋcoñwɨ́ypa jém mijóyixyajpaap.” ");
INSERT INTO poiNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿Pero jutsa̱p ichɨ́y jém Cristo juuts jém David ima̱nɨc, siiga nɨmt́im jém David iga jém Cristo iO̱mi? ");
INSERT INTO poiNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Jesɨc d́a i̱ wɨa̱ icutsoŋ jém Jesús. Dende jém ja̱ma d́am i̱ más icwác jém Jesús porque agui cɨ̱ŋyajpa. ");
INSERT INTO poiNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jesɨc moj iŋmadáy Jesús it́u̱mpɨy jém aŋtuuma̱neyajwɨɨp con jém icuyujcɨɨwiñ. Nɨmpa: ");
INSERT INTO poiNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Jém escribaspɨc maestroyaj con jém fariseoyaj jexpɨct́im aŋquímayooyi iŋmatpa juuts jém Moisés. ");
INSERT INTO poiNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Jesɨc cupɨctaamɨ mimicht́am, wattaamɨ it́u̱mpɨy juuts miñɨ́mayt́ámpa cuando miŋquejayt́ámpa jém Dios iŋma̱t́i. Pero odoy wattaamɨ juuts iwatyajpa jeeyaj. Porque iwɨ̱aŋmatyajpa, pero d́a iwɨ̱watyajpa. ");
INSERT INTO poiNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Tsa̱m jáyaŋ iŋquímayooyi ijɨ̱xquímyajpa, tsa̱m ictsɨɨma̱yajpa jém it́ɨ̱wɨtam, pero jeeyaj d́a iyo̱xpátpa con tu̱m jém iwaycɨ iga icuyagɨ́yáypa ichɨ̱mi. ");
INSERT INTO poiNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Iwɨ̱watyajpa iga ixt́a̱iñ iga wɨbɨc pɨ̱xiñ. Agui iwɨ̱aŋja̱myaj jém wɨ̱t́ipɨc bolsa ju̱t́ ininɨcpa jém Dios iŋma̱t́i. Agui wɨ̱ accuyajne jém iyagats yoot́i iŋna̱ca. ");
INSERT INTO poiNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Cuando watta̱p jém mɨjpɨc sɨŋ, agui iwɨ̱aŋja̱myaj jém co̱ñcuy ju̱t́ wícyajpa jém mɨjtampɨc aŋjagooyiyaj. Agui icusúnɨyyajpa jém más wɨbɨc co̱ñcuy jém sinagoga. ");
INSERT INTO poiNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Iwɨ̱aŋja̱mpat́im iga tandioschiiñ calle. Ixunpa iga jém pɨxiñt́am iñɨɨyɨ́yiñ iga: “Rabí, Rabí”. Taɨcht́am tanaŋmat́i̱mɨ nɨmtooba: “Mammaestro”. ");
INSERT INTO poiNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Odoy jɨɨcɨ iga i̱ miñɨɨyɨ́yiñ iga miRabí, porque it́ tu̱m jém imMaestro, je jém Cristo. Mimicht́am mit́ɨ̱wɨtam. ");
INSERT INTO poiNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Odoy nɨ́maayɨ tu̱m pɨ̱xiñ iga “Manja̱tuŋ” iga mipɨɨmɨ́ypa yɨ́p naxyucmɨ, porque it́ tu̱m jém tanJa̱tuŋ jém it́wɨɨp sɨŋyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","D́a wɨa̱p iñchɨ́y juuts miŋjagooyi porque it́ tu̱m jém iniŋjagooyi je jém Cristo. ");
INSERT INTO poiNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Jém más mɨjpɨc aŋjagooyi entre mimicht́am micuyo̱xatámpa. ");
INSERT INTO poiNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Dios d́a iwɨ̱ixpa jém pɨ̱xiñ jém tsa̱mpɨc nacujípta̱p. Pero wɨ̱ixt́a̱p tu̱m pɨ̱xiñ siiga d́a malo ia̱nama. ");
INSERT INTO poiNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’Agui miuuguyt́im, mimicht́am, miescribaspɨc y mifariseopɨc. Tsa̱m minimɨgóyayt́a̱p. D́a nunca iŋwattámpa juuts iniŋquejáypa jém iŋcuyujcɨɨwiñ. Mimicht́am iniŋpajpa jém puerta ju̱t́ tɨgɨyyajpa jém pɨxiñt́am ju̱t́ iŋjacpa Dios. D́a mit́ɨgɨypa mimicht́am, ni d́at́im iñj ɨ́gáypa iga tɨgɨyyajiñ jeeyaj. ");
INSERT INTO poiNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’Agui miuuguyt́im mimicht́am, miescribaspɨc mimaestrotam y mifariseopɨc. Tsa̱m minimɨgóyayt́a̱p. D́a nunca iŋwattámpa juuts iniŋquejáypa jém pɨxiñt́am. Iñt́obáypa pɨ̱mi̱mɨ jém cuno̱ya imɨɨchi, jesɨc ocmɨ tsa̱m yagatspɨc oración iŋwatpa iga immɨgóyáypa jém pɨxiñt́am. Jeeyucmɨ tsa̱m mɨjpɨc castigo michiit́amta̱p. ");
INSERT INTO poiNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’Agui miuuguyt́im, mimicht́am, miescribaspɨc mimaestrotam y mifariseopɨc. Tsa̱m minimɨgóyayt́a̱p. Tsa̱m iŋcuámpa icuwɨ̱t́i yɨ́p naxyucmɨ hasta jém lamar aŋwiñt́uc iga impátpa tu̱m pɨ̱xiñ iga iniŋquejáypa michpɨc iniŋquímayooyi. Cuando yaj iniŋmadáy, jesɨc jém pɨ̱xiñ más jáyaŋ ipɨctsoŋpa castigo que mimicht́am. ");
INSERT INTO poiNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’Agui miuuguyt́im, mimicht́am, iñjɨ̱ctámpa jém iñt́ɨ̱wɨtam juuts cácht́iyaj, pero micácht́it́im mimicht́am. Porque miñɨmtámpa, siiga i̱ ichacpa jém mɨjpɨc ma̱stɨc juuts tu̱m testigo iga iwatpa juuts ijɨycámáy, jesɨc d́a t́i iñascaaba siiga d́a iwatpa. Pero siiga i̱ ichacpa jém oro jém it́wɨɨp ma̱stɨcjo̱m juuts tu̱m testigo, jesɨc tienes que iwatpa juuts ijɨycámayñe. ");
INSERT INTO poiNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mimicht́am d́a mijɨ̱xiɨyt́a. Micácht́it́am. Jém mɨjpɨc ma̱stɨc más wɨa̱p que jém oro porque jém ma̱stɨc iwɨ̱tsacpa jém oro jém it́wɨɨp ma̱stɨcjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","’Miñɨmtámpat́im: “Siiga i̱ ichacpa juuts tu̱m testigo jém altar iga iwatpa juuts ijɨycámayñe, jesɨc d́a t́i iñascaaba siiga d́a iccupacpa juuts ijɨycámayñe. Pero siiga ichacpa jém ofrenda jém it́wɨɨp jém altaryucmɨ juuts tu̱m testigo, jesɨc tienes que iwatpa juuts ijɨycámayñe.” ");
INSERT INTO poiNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Micht́am d́a mijɨ̱xiɨyt́a. Micácht́it́am. Jém altar más wɨa̱p que jém ofrenda porque jém altar iwɨ̱tsacpa jém ofrenda jém it́wɨɨp altaryucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Siiga i̱ ichacpa juuts tu̱m testigo jém altar, jesɨc ichacpat́im juuts tu̱m testigo it́u̱mpɨy jém it́wɨɨp jém altaryucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Siiga i̱ ichacpa juuts tu̱m testigo jém mɨjpɨc ma̱stɨc, jesɨc ichacpat́im juuts tu̱m testigo jém it́wɨɨp ma̱stɨcjo̱m porque je̱mt́im it́ jém tanJa̱tuŋ Dios. ");
INSERT INTO poiNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Siiga i̱ ichacpa jém sɨŋ juuts tu̱m testigo, ichacpat́im juuts tu̱m testigo jém tanJa̱tuŋ Dios jém it́wɨɨp sɨŋyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’Agui miuuguyt́im, mimicht́am, miescribaspɨc mimaestrotam y mifariseopɨc. Miñɨ́maŋtaaya̱p iga iŋcupɨcpa Dios. Iñchiiba Dios jém décima parte jém menta, jém anís y jém comino, pero d́a iŋwadáypa caso jém más mɨjpɨc aŋquímayooyi. Más ixunpa Dios iga iŋwɨ̱watpa y miyaachaŋjaamóypa y iŋcupɨcpa iga Dios wɨa̱p miyo̱xpát. Nu̱ma wɨ̱ iga iŋwattámpa juuts nɨmpa jém más mɨjpɨc aŋquímayooyi y d́a iñchactámpa iga iŋwatpat́im jém xut́upɨc aŋquímayooyi. ");
INSERT INTO poiNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","’Mimicht́am miŋjagooyit́im, pero micácht́it́am. Tsa̱m iŋwadáypa caso jém xut́upɨc asunto jém d́apɨc juchaŋ. Pero jém asunto tsa̱m mɨjpɨc d́a iŋwadáypa caso. Juuts nɨmyajpa, iñt́oppa tu̱m xut́u u̱su jém imvasojo̱m iga odoy íñuguiñ, pero ocmɨ impɨtquetpa tu̱m camello. ");
INSERT INTO poiNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’Agui miuuguyt́im, mimicht́am, miescribaspɨc mimaestrotam y mifariseopɨc, d́a iŋwattámpa juuts iniŋquejáypa jém pɨxiñt́am. Tsa̱m iŋcujichayt́ámpa jém taza y jém chi̱ma iyucwiñ, pero jojmɨ d́a iŋcujichayñeta, tsa̱m it́ jém nuumi y jém cusúnɨyooyi. ");
INSERT INTO poiNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","A que mifariseopɨc, agui micácht́it́am. Wiñt́i cujichaayɨ jém taza ijojmɨ y jém chi̱ma ijojmɨ, jesɨc ocmɨ cujichayt́a̱pt́im jém iyucwiñ. ");
INSERT INTO poiNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’Agui miuuguyt́im miescribaspɨc mimaestrotam y mifariseopɨc, tsa̱m minimɨgóyayt́a̱p iñyaac. Mijext́am juuts tu̱m tsúts ijos tsa̱m wɨ̱watneta̱, agui po̱po aŋsɨ̱cmɨ. Agui wɨ̱ tánix. Pero jojmɨ tsa̱m it́ jém tsúts ipac. Jáyaŋ it́ jém d́a wɨ̱tampɨc cosa, tsa̱m pu̱wa. ");
INSERT INTO poiNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Jesanet́im mimicht́am, cuando miixyajpa jém pɨxiñt́am, ijɨ̱syajpa iga wɨbɨc mipɨ̱xiñ, pero íña̱namaŋjo̱m tsa̱m it́ jém mɨgooyi y jém malopɨc jɨ̱xi. ");
INSERT INTO poiNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’Agui miuuguyt́im miescribaspɨc mimaestrotam y jém mifariseopɨc, d́a iŋwattámpa juuts iniŋquejáypa jém pɨxiñt́am. Iŋwatta jém mɨjpɨc monumento ju̱t́ cumyajta̱ jém wiñɨcpɨc Dios iŋmat́cɨɨwiñ. Tsa̱m iŋwɨ̱accuyajneta jém monumento ju̱t́ cumyajta̱ jém wiñɨcpɨc aŋmat́cɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ocmɨ miñɨmtámpa mimicht́am: “Meega ait́t́a cuando it́ jém wiñɨcpɨc antúmmɨtam, d́a id́ɨc anyo̱xpát iga accaata̱ jém Dios iŋmat́cɨɨwiñ.” ");
INSERT INTO poiNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Nu̱ma juuts mimicht́am miñɨmta iga jém wiñɨcpɨc pɨxiñt́am mimicht́am iñja̱tuŋwe̱wetam. Iccaayaj jém Dios iŋmat́cɨɨwiñ. Mimicht́am mijext́im juuts jém iñja̱tuŋwe̱wetam. ");
INSERT INTO poiNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Jesɨc seguido wa̱tɨ je̱mpɨc hasta que cupacpa iŋwat juuts ictsucumyaj jém iñja̱tuŋwe̱wetam. ");
INSERT INTO poiNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’Tsa̱m malo jém iŋwe̱wetam. Mimicht́am tsa̱m mimalot́im juuts tu̱m tsa̱ñ. D́a wɨa̱p iŋcɨɨputta de jém castigo. Tienes que miñɨcpa jém juctjo̱m ju̱t́ d́a nunca píchpa. ");
INSERT INTO poiNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Jeeyucmɨ maŋcutsadáypa tuŋgac aŋmat́cɨɨwiñ, y wɨbɨc pɨxiñt́am jɨ̱xiɨywɨɨp, y jém nunta escribaspɨc maestroyaj. Pero algunos iniccaatámpa. Algunos iŋcunúntámpa cunusyucmɨ. Algunos iŋcótstámpa jém sinagoga. Algunos inicpoyt́ámpa de tu̱m attebet hasta tuŋgac attebet. ");
INSERT INTO poiNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Micht́am impɨctsoŋtámpa tu̱m mɨjpɨc castigo. Dios michégáypa ico̱bac iga accaayajta̱ it́u̱mpɨy jém wɨ̱tampɨc pɨxiñt́am, dende jém wiñt́ipɨc accaata̱ jém Abel jém d́apɨc t́i iwatne, hasta jém Berequías ima̱nɨc, jém Zacarías, jém accaata̱wɨɨp ma̱stɨcjo̱m nocojo̱m ju̱t́ it́ jém altar. ");
INSERT INTO poiNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nu̱ma mannɨ́máypa iga it́u̱mpɨy yɨ́p castigo ipɨctsoŋyajpa jém it́yajwɨɨp sɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’Mimicht́am, miit́t́aŋwɨɨp Jerusalén, iniccaata jém wiñɨcpɨc aŋmat́cɨɨwiñ. Iññácscata tsaamɨ jém micutsadayñewɨɨp Dios. Wat́cɨy anaŋtuuma̱wattɨp jém imma̱nɨctam juuts jém piyua̱pa iŋtuuma̱watpa jém ima̱nɨctam jém ixajcucɨɨm, pero d́a iŋwɨ̱aŋja̱mta. ");
INSERT INTO poiNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ixt́aamɨ mimicht́am, yɨ́p attebet tsɨ́ypa juuts tu̱m tɨc d́a oomɨ́y. Icut́um tsɨ́ypa. ");
INSERT INTO poiNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Sɨɨp mannɨ́máypa mimicht́am iga d́a e̱ybɨc ánixt́ámpa hasta núcpa jém tiempo cuando miñɨmtámpa iga: “Agui wɨ̱ jém tanaŋjagooyi jém tacutsadayñewɨɨp tanJa̱tuŋ Dios.” ");
INSERT INTO poiNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesɨc put Jesús ma̱stɨcjo̱m. Iganam nɨcpa, icunúcyaj jém icuyujcɨɨwiñ. Moj iŋquejayyaj Jesús jém wɨbɨc tɨcyaj jém mɨjpɨc ma̱stɨc aŋna̱ca, tsa̱m wɨ̱watne. ");
INSERT INTO poiNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Pero Jesús iñɨ́máy: —Mimicht́am, ixt́aamɨ yɨ́p tɨcyaj. Nu̱ma mannɨ́máypa iga yajpa imɨswatta̱ icutero yɨ́p ma̱stɨc, d́a tatsneeba ichɨ́y ni tu̱m tsa. It́u̱mpɨy accujegayyajta̱p. ");
INSERT INTO poiNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jesɨc nɨcyaj jém co̱tsɨcyucmɨ de Olivos. Cuando co̱ñ Jesús, jém icuyujcɨɨwiñ iyamnɨ́mayyajpa: —Anɨ́maayɨ jucha̱ naspa it́u̱mpɨy yɨ́pyaj cosa. ¿Júp seña ánixt́ámpa cuando mimiñgacpa yɨ́p naxyucmɨ iga iniccuyajpa yɨ́p nas? ");
INSERT INTO poiNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesɨc Jesús icutsoŋ. Iñɨ́máy: —Nawattamta̱jɨ cuenta iga odoy i̱ mimɨgóyáyiñ. ");
INSERT INTO poiNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Miñyajpa wa̱t́i jém mɨgoypaap ɨch annɨyi̱mɨ. Nɨmyajpa iga: “Ɨch aCristo.” Imɨgóyayyajpa tsa̱m jáyaŋ jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Immatoŋtámpa iga miñpa jém guerra. Waŋpa iga tsa̱m áŋa̱yajpa jém naciónyaj. Pero odoy cɨ̱ŋtaamɨ. Tienes que naspa it́u̱mpɨy yɨ́pyaj cosa, pero d́anam núcne jém íŋaŋpɨgam ja̱ma. ");
INSERT INTO poiNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Tu̱m nación áŋa̱yajpa con tuŋgac nación. Tu̱m naxyucmɨ áŋa̱yajpa con tuŋgac naxyucmɨ. Miñpa jém mɨjpɨc yuu. Miñpa wa̱t́i jém malopɨc caacuy. Miñpa jém nasyɨɨxi ju̱t́ quej. ");
INSERT INTO poiNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Cuando miñpa it́u̱mpɨy yɨ́pyaj cosa, yaguiñ tsucumpa jém mɨjpɨc yaacha̱ji. ");
INSERT INTO poiNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Jesɨc micɨɨjuŋcottamta̱p jém malopɨc aŋjagooyi icɨɨjo̱m iga mimalwadayt́amta̱p. Miccaatamta̱p. Icuwɨ̱t́i yɨ́p naxyucmɨ tsa̱m mijóyixyajpa ɨch aŋcuyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Cuando núcpa jém tiempo, tsa̱m jáyaŋ pɨxiñt́am ichacyajpa jém Dios iŋma̱t́i. Algunos iwadáypa atraición jém it́ɨ̱wɨ iga matsta̱iñ. Tsa̱m najóyixyajta̱p. ");
INSERT INTO poiNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Miñyajpa jáyaŋ jém mɨgoyyajpaap, nɨ́maŋtaaya̱p iga Dios iŋmat́cɨɨwiñ. Imɨgóyayyajpa tsa̱m jáyaŋ jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Tsa̱m jáyaŋa̱p jém malopɨc jɨ̱xi jeeyucmɨ jáyaŋ jém pɨxiñt́am ichacyajpa iga it́oypa jém it́ɨ̱wɨtam. ");
INSERT INTO poiNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pero cɨacputta̱p jém iyaachɨypaap jém yaacha̱ji, jém d́apɨc ichacpa jém Dios iŋma̱t́i hasta jém íŋaŋpɨgam ja̱ma. ");
INSERT INTO poiNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Wiñt́i aŋmatta̱p yɨ́p wɨbɨc aŋma̱t́i iga Dios iŋjacpa jém it́yajwɨɨp yɨ́p naxyucmɨ. Núcpa ju̱t́quej iga jo̱dóŋa̱ta̱iñ jém Dios iŋma̱t́i. Ocmɨ núcpa jém íŋaŋpɨgam ja̱ma. ");
INSERT INTO poiNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Jém wiñɨcpɨc aŋmat́cɨɨwiñ jém Daniel ijaychac jém librojo̱m iga miñpa tu̱m aŋjagooyi tsa̱m pɨ̱mi malo, ijóyixpa tanJa̱tuŋ Dios. Miñpa iwat contra jém Dios iŋquímayooyi. Cuando íñix iga miñ i̱t́i jém aŋjagooyi ju̱t́ d́a iwɨ̱aŋja̱m Dios (el que imaypa yɨ́p libro wɨ̱ iga icutɨɨyɨ́yiñ t́i annɨ́máypa), ");
INSERT INTO poiNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","jesɨc miit́t́aŋwɨɨp jém naxyucmɨ de Judea, poyt́aamɨ, nɨctaamɨ jém co̱tsɨgaŋjoj. ");
INSERT INTO poiNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Siiga miquímne iñt́ɨcyucmɨ jém tuŋgac piso, jesɨc odoy que̱tɨ iga nɨcpa impɨc iñtraste, pero nɨcsɨm poyi̱mɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Siiga miit́t́a ca̱mjo̱m cuando immatoŋ iga núcneum jém malopɨc aŋjagooyi, jesɨc odoy se̱ttaamɨ iñt́ɨccɨɨm iga miñpa impɨc impuctu̱cu. Jemɨgam tsucumtaamɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Agui uuguyt́im jém yo̱mtam jém ma̱nɨccomcanewɨɨp y jém ictsútspáppɨc jém xuxut́ tsɨ̱xt́am. Porque tsa̱m jáyaŋ yaacha̱ji miñpa. ");
INSERT INTO poiNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Aŋwejpáttaamɨ Dios iga odoy mictsɨ́yt́ámiñ jém tiempo de sucsuc ni jém jejcuy ja̱ma cuando mipoyt́ámpa. ");
INSERT INTO poiNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Cuando núc yɨ́p malopɨc aŋjagooyi, tsa̱m pɨ̱mi miyaacha̱támpa. D́a nunca oypa tánix jexpɨc yaacha̱ji dende Dios iwat yɨ́p nas. Ni ocmɨ d́a e̱ybɨc tánixpa jexpɨc yaacha̱ji. ");
INSERT INTO poiNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Jém tanJa̱tuŋ Dios d́a ijɨ́cpa iga jáypa jém malopɨc aŋjagooyi. Siiga jáypa, d́a i̱ cɨɨputpa, cucaayyajpa it́u̱mpɨy jém icupiŋneyajwɨɨp Dios, jeeyucmɨ d́a ijɨ́cpa iga jáypa jém mɨjpɨc yaacha̱ji. ");
INSERT INTO poiNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Siiga i̱ miñɨ́máypa iga: “Mi̱ñɨ aamɨ, yɨɨm it́ jém Cristo”, o tuŋgac miñɨ́máypa: “Nɨ̱gɨ aamɨ jeexɨc it́ jém Cristo”, jesɨc odoy cupɨctaamɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Porque miñyajpa tsa̱m jáyaŋ jém mɨgoyyajpaap. Nɨ́maŋtaaya̱p iga: “Ɨch aCristo”, pero mɨgóypa. Nɨ́maŋtaaya̱p iga: “Ɨch awɨbɨc jém Dios iŋmat́cɨɨwiñ.” Iwatyajpa jém wɨ̱tampɨc seña y jém milagroyaj iga imɨgóyayyajpa jém icupiŋneyajwɨɨp Dios meega wɨa̱p. ");
INSERT INTO poiNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mannɨ́mayñeum wiñt́i t́i miñpa antes que amiñgacpa. ");
INSERT INTO poiNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Jeeyucmɨ siiga i̱ miñɨ́máypa iga: “Nɨ̱gɨ aamɨ jém Cristo jém tɨtsɨnaxyucmɨ”, odoy nɨ̱gɨ aamɨ. Siiga nɨmyajpa: “Mi̱ñɨ aamɨ, yɨɨm it́ jém Cristo tu̱m cuartojo̱m aŋnécne”, odoy cupɨ̱cɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Porque cuando ɨch, jém aMiññewɨɨp Sɨŋyucmɨ, amiñgacpa yɨ́p naxyucmɨ, jesɨc i̱ quej aixyajpa. Juuts quénpa jém majɨywiñ dende aŋnɨɨsa̱umɨ hasta aŋyo̱msa̱umɨ, jesanet́im tsa̱m wɨ̱quejpa cuando amiñgacpa. ");
INSERT INTO poiNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ju̱t́ caane tu̱m cawaj jemum aŋtuuma̱yajpa jém nuupu. Jesa̱pt́im tsa̱m wɨ̱quejpa cuando núctooba jém íŋaŋpɨgam ja̱ma. ");
INSERT INTO poiNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Jeet́i rato cuando naspa jém yaacha̱ji, píchpa jém ja̱ma icho̱ca y jém po̱ya d́at́im tsocpa. Jém ma̱tsa, jém it́wɨɨp sɨŋyucmɨ, cutɨŋyajpa. Tsa̱m tsɨgoyyajpa it́u̱mpɨy jém it́yajwɨɨp jém ma̱tsaaŋjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Quejpa jém seña sɨŋyucmɨ iga miñpa jém icutsatnewɨɨp Dios. Tsa̱m wejyajpa it́u̱mpɨy jém it́yajwɨɨp icuwɨ̱t́i yɨ́p naxyucmɨ cuando iixyajpa iga miñgacpa jém Miññewɨɨp Sɨŋyucmɨ jém ucsaŋjo̱m con jém Dios ipɨ̱mi juuts tu̱m mɨjpɨc aŋjagooyi. ");
INSERT INTO poiNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Cutsadayyajta̱p jém sɨŋyucmɨpɨc pɨxiñt́am yɨ́p naxyucmɨ. Susta̱p tu̱m suscuy. Agui pɨ̱mi aŋjɨypa iga iŋtuuma̱watpa it́u̱mpɨy jém icupɨŋneyajwɨɨp Dios icuwoyo jém mundo dende sɨŋyucmɨ hasta naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Cutɨɨyɨyt́aamɨ yɨ́p ejemplo de jém tsuj. Cuando químpa jém iŋmaañay, jesɨc iñjo̱doŋtam iga núctooba jém cutujcɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Jesa̱pt́im cuando íñixt́ámpa iga naspa it́u̱mpɨy jém mannɨ́mayñewɨɨp iga miñpa, jesɨc iñjo̱doŋtam iga nocojo̱m it́ jém ja̱ma cuando amiñgacpa yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nu̱ma mannɨ́máypa, cupacpa it́u̱mpɨy yɨ́pyaj cosa antes que caayajpa it́u̱mpɨy jém pɨxiñt́am jém it́yajwɨɨp jém tiempo. ");
INSERT INTO poiNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Cuyajpa jém sɨŋ y jém nas, pero ɨch anaŋma̱t́i d́a nunca cuyajpa. ");
INSERT INTO poiNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’D́a i̱ ijo̱doŋ júp ja̱ma ni juchɨs hora naspa it́u̱mpɨy yɨ́pyaj cosa. D́a ijo̱doŋyaj ni jém sɨŋyucmɨpɨc pɨxiñt́am ni d́at́im ijo̱doŋ jém Dios iMa̱nɨc. Icut́um ijo̱doŋ jém tanJa̱tuŋ Dios. ");
INSERT INTO poiNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Juutst́im jém tiempo cuando it́ id́ɨc jém Noé, jesa̱pt́im jém tiempo cuando amiñgacpa yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Porque wiñɨgam cuando it́ id́ɨc jém Noé, cuando d́anam núcne jém diluvio, jém pɨxiñt́am wícyajpat́im y ucyajpat́im. Aŋcoomɨ́yoyyajpat́im y ichiiyajpat́im iyo̱mma̱nɨctam iga aŋcoomɨyyajpa hasta que núc jém ja̱ma cuando jém Noé tɨgɨy jém mɨjpɨc barcojo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","D́a icutɨɨyɨyyaj hasta que quím jém nɨ, inicunɨ́gayyaj it́u̱mpɨy jém pɨxiñt́am. Je̱mpɨct́im iñascayajpa jém it́yajwɨɨp yɨ́p naxyucmɨ cuando ɨch, jém aMiññewɨɨp Sɨŋyucmɨ, amiñgacpa yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Cuando núctooba jém íŋaŋpɨgam ja̱ma, wagayo̱xayajpa wɨste̱n pɨ̱xiñ ica̱mjo̱m, tu̱m nanɨcta̱p, tu̱m tsacta̱p. ");
INSERT INTO poiNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Wɨste̱n yo̱mo wid́oyyajpa tu̱m molinoyucmɨ, tu̱m nanɨcta̱p, tu̱m tsacta̱p. ");
INSERT INTO poiNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’It́t́aamɨ al tanto porque d́a iñjo̱doŋtam juchɨs hora miñpa jém íñO̱mi, odoy moŋtaamɨ mimicht́am. ");
INSERT INTO poiNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Cutɨɨyɨyt́aamɨ, siiga tu̱m pɨ̱xiñ ijo̱doŋ juchɨs hora núcpa tsuucɨɨm jém númpaap, jesɨc d́a moŋpa iga odoy ijedáyiñ jém it́ɨc jém númpaap. ");
INSERT INTO poiNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Jeeyucmɨ mannɨ́máypa, it́t́aamɨ listo porque jém tiempo iga iñjɨ̱spa iga ɨch, jém aMiññewɨɨp Sɨŋyucmɨ, d́a amiñgacpa, jesɨgam amiñpa. ");
INSERT INTO poiNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’Sɨɨp manaŋquejáypa i̱apaap jém wɨbɨc cabo jém icutɨɨyɨypaap. Jém io̱mi ichacpa iga iŋjaguiñ jém it́yajwɨɨp it́ɨccɨɨm iga icwícyajiñ. ");
INSERT INTO poiNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Agui maymay jém cabo siiga sɨ́p iwat juuts ipɨɨmɨyñe jém io̱mi cuando miñgacpa. ");
INSERT INTO poiNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Mannɨ́máypa iga jém io̱mi iccámpa jém icabo juuts tu̱m aŋjagooyi iga iŋjacpa it́u̱mpɨy jém iñas y jém icuyo̱xayajpaap. ");
INSERT INTO poiNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pero siiga malo yɨ́p cabo, ijɨ̱spa ia̱namaŋjo̱m iga d́a jobit́ miñgacpa jém io̱mi. ");
INSERT INTO poiNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Mojpa imalwadáy tuŋgac jém icuyo̱xapaap jém io̱mi. Tsa̱m wícpa, tsa̱m ucpa con jém tuŋgac uccɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Miñgacpa jém cabo io̱mi tu̱m ja̱ma cuando d́a iŋjócne. Miñpa tu̱m hora cuando d́a ijo̱doŋ. ");
INSERT INTO poiNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Chiit́a̱p mɨjpɨc castigo con jém malopɨc pɨxiñt́am ju̱t́ tsa̱m wejyajpa, ju̱t́ iñichyajpa it́ɨts. ");
INSERT INTO poiNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Jesɨc jém tiempo cuando iŋjacpa Dios yɨ́p naxyucmɨ jex juuts diez jém wo̱ñt́am nɨcyaj ju̱t́ aŋcoomɨ́yoyñɨ̱mpa. Ipɨcyaj jém ijuctɨ, nɨc ichoŋyaj jém aŋcoomɨypaap. ");
INSERT INTO poiNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Cinco jém wo̱ñt́am d́a jɨ̱xiɨ́y y cinco jém wo̱ñt́am agui jɨ̱xiɨ́y. ");
INSERT INTO poiNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Jém d́apɨc jɨ̱xiɨ́y ipɨcyaj ijuctɨ, pero d́a ininɨcyaj jém aceite iga icucómáypa e̱ybɨc jém ijuctɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pero jém jɨ̱xiɨywɨɨp ininɨc jém aceite tu̱m xa̱nujo̱m. Ininɨcpat́im jém ijuctɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tsa̱m táŋcaa̱p iñúc jém yoomɨypaap. Tsa̱m moŋtooba jém wo̱ñt́am. Ocmɨ moŋyaj. ");
INSERT INTO poiNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Jesɨc cugaptsu imatoŋyaj tu̱m mɨjpɨc jɨ̱yi. Nɨmpa: “Miñpa jém yoomɨypaap. Nɨ̱gɨ tsoŋtaamɨ.” ");
INSERT INTO poiNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Tsucumyaj it́u̱mpɨy jém wo̱ñt́am. Moj iwɨ̱tsacyaj ijuctɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Jém cinco wo̱ñt́am, jém d́apɨc jɨ̱xiɨ́y, iñɨ́mayyajpa jém jɨ̱xiɨywɨɨp: “Achiit́aamɨ uxaŋ aceite porque ɨch anjuctɨ pícht́oobam.” ");
INSERT INTO poiNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Pero jém jɨ̱xiɨywɨɨp icutsoŋyaj. Nɨmyaj: “D́a manchiiba porque wɨɨp d́a actsɨ́ypa aɨch siiga manchiiba. Más wɨ̱ nɨ̱gɨ juyt́aamɨ iñyaac ju̱t́ mayt́a̱p.” ");
INSERT INTO poiNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Pero iganam nɨc ijuyyaj aceite jém cinco wo̱ñt́am, jém d́apɨc jɨ̱xiɨ́y, jesɨgam núc jém yoomɨypaap. Y jém cinco jém wo̱ñt́am jém jɨ̱xiɨywɨɨp tɨgɨyyaj jojmɨ ju̱t́ it́ jém aŋcoomɨ́yóycuy. Aŋpajta̱ jém puerta. ");
INSERT INTO poiNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ocmɨ se̱tyaj jém wo̱ñt́am jém nɨcnewɨɨp ijuy aceite. Iñɨ́mayyajpa jém tɨc io̱mi: “Áŋaayɨ jém puerta.” ");
INSERT INTO poiNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Pero jém tɨc io̱mi iñɨ́máy: “Nu̱ma mimicht́am, d́a mánixpɨcpa.” ");
INSERT INTO poiNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jesɨc Jesús iñɨ́máy: —Odoy moŋtaamɨ mimicht́am, it́t́aamɨ al tanto porque d́a iñjo̱doŋ júp ja̱ma ni juchɨs hora amiñgacpa yɨ́p naxyucmɨ jém aMiññewɨɨp Sɨŋyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Jém wɨbɨc aŋma̱t́i iga Dios iŋjacpa yɨ́p naxyucmɨ jex juuts tu̱m pɨ̱xiñ tsa̱m tumiñɨ́y. Nɨcpa tuŋgac naxyucmɨ. Jesɨc nɨcpa, iŋwejáy jém iesclavoyaj iga ichi uxaŋ tumiñ iga iyo̱xacayajiñ. ");
INSERT INTO poiNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Tu̱m jém iesclavo ichi cinco talento (tu̱m talento ivale seis mil tumiñ de plata). Tuŋgac ichi wɨste̱n talento. Tuŋgac ichi tu̱m talento. Chiit́a̱ cada quien juuts wɨa̱p iyo̱xaca. Jesɨc ocmɨ nɨc jém pɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Tu̱m jém esclavo, jém chiiñeta̱wɨɨp jém cinco talento, moj iyo̱xaca jém tumiñ. Icoñwɨ́y tuŋgac cinco talento. ");
INSERT INTO poiNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Je̱mpɨct́im iwat jém tuŋgac esclavo, jém chiiñeta̱wɨɨp wɨste̱n talento. Icoñwɨ́y con jém tumiñ tuŋgac wɨste̱n talento. ");
INSERT INTO poiNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pero jém tuŋgac esclavo, jém chiiñeta̱wɨɨp tu̱m talento, nɨc iñegáy jém io̱mi it́umiñ. It́aj tu̱m jos, jemum icum nascɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Jesɨc pecam nɨcne jém io̱mi, se̱t e̱ybɨc. Moj it́op cuenta con jém iesclavo. ");
INSERT INTO poiNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Wiñt́i núc jém chiiñeta̱wɨɨp jém cinco talento. Icɨɨjuŋcodáy io̱mi tuŋgac cinco talento jém icoñwɨyñewɨɨp. Iñɨ́máy: “Máno̱mi, anchi cinco talento, pero yɨɨm it́ tuŋgac cinco talento aŋcoñwɨyñe.” ");
INSERT INTO poiNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Jém io̱mi iñɨ́máy: “It́ wɨ̱. Mich tu̱m wɨbɨc miesclavo, agui wɨa̱ iŋwat cuenta jém ammɨɨchi. Como mánix iga wɨa̱ miŋwat cuenta jém uxaŋpɨc, sɨɨp manaccámpa juuts tu̱m aŋjagooyi iga iniŋjacpa más jém jáyaŋpɨc. Sɨɨp tɨgɨ̱yɨ yɨɨm con aɨch ju̱t́ it́ jém maymáya̱ji.” ");
INSERT INTO poiNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","’Ocmɨ núc jém tuŋgac iesclavo jém chiiñeta̱wɨɨp wɨste̱n talento. Nɨmpa: “Máno̱mi, anchi wɨste̱n talento. Yɨɨm it́ tuŋgac wɨste̱n aŋcoñwɨyñe.” ");
INSERT INTO poiNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Jém io̱mi iñɨ́máy: “Wɨbɨc miesclavo, wɨa̱p iŋwat cuenta jém ammɨɨchi. Como mánix iga wɨa̱ miŋwat cuenta jém uxaŋpɨc, sɨɨp manaccámpa juuts tu̱m miŋjagooyi iga iniŋjacpa jém más jáyaŋpɨc. Sɨɨp tɨgɨ̱yɨ yɨɨm con aɨch ju̱t́ it́ jém maymáya̱ji.” ");
INSERT INTO poiNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","’Ocmɨ núct́im jém tuŋgac esclavo jém chiiñeta̱wɨɨp tu̱m talento. Iñɨ́máy: “Máno̱mi, ɨch anjo̱doŋ iga tsa̱m pɨ̱mi mipɨɨmɨ́yóypa. Impɨctsoŋpa jém cosecha ju̱t́ d́a oy iññip. Impiŋpa jém cosecha ju̱t́ d́a oy iñyɨn. ");
INSERT INTO poiNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Jeeyucmɨ tsa̱m acɨ̱ŋ. Oy mannegáy jém iñt́umiñ nascɨɨm. Pero yɨɨm it́ jém iñt́umiñ jém immɨɨchipɨc.” ");
INSERT INTO poiNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Jém io̱mi iñɨ́máy jém iesclavo: “Tsa̱m mimalopɨc miesclavo, tsa̱m micut́iñ. Siiga iñjo̱doŋ iga ampɨctsoŋpa jém cosecha ju̱t́ d́a oy anñip y ampiŋpa jém cosecha ju̱t́ d́a oy anyɨn, ");
INSERT INTO poiNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","¿jesɨc t́iiga d́a iŋcucom antumiñ jém banco? Jesɨc cuando ase̱tpa, ampɨctsoŋpa antumiñ con jém icoñwɨyooyi.” ");
INSERT INTO poiNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","’Jesɨc jém esclavo io̱mi iñɨ́máy jém it́yajwɨɨp je̱m: “Accáyaayɨ jém talento yɨ́p pɨ̱xiñ. Chi̱ɨ jém iniit́wɨɨp diez talento. ");
INSERT INTO poiNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Porque jém iniit́wɨɨp, chiit́a̱p más iga odoy t́i it́ogóyáyiñ. Pero jém d́apɨc inii̱, accáyayt́a̱p hasta jém uxaŋpɨc iniit́. ");
INSERT INTO poiNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Acnɨctaamɨ yɨ́p d́a wɨbɨc esclavo jém piichcɨɨm jém it́wɨɨp aŋsɨ̱cmɨ, ju̱t́ tsa̱m wejyajpa, iñichyajpa it́ɨts.” ");
INSERT INTO poiNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Cuando miñgacpa jém Miññewɨɨp Sɨŋyucmɨ, miñpa juuts tu̱m aŋjagooyi. Iwaganamiñyajpa it́u̱mpɨy jém sɨŋyucmɨpɨc pɨxiñt́am. Co̱ñ jém aŋjagooyi ico̱ñcuyyucmɨ iga iŋjacpa yɨ́p nas con jém Dios ipɨ̱mi. ");
INSERT INTO poiNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","It́u̱mpɨy jém pɨxiñt́am, jém it́yajwɨɨp icuwɨ̱t́i yɨ́p naxyucmɨ, aŋtuuma̱yajpa jém aŋjagooyi iwiñjo̱m. Jém aŋjagooyi icupíŋáypa jém tuŋgac pɨxiñt́am juuts iwatpa jém borrego io̱mi. It́oppa jém chivo jém borregoaŋjo̱m, ichacpa aparte. ");
INSERT INTO poiNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Jém borregoyaj tsacyajta̱p aŋwɨ̱mɨ y jém chivoyaj tsacyajta̱p aŋna̱ymɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","’Jesɨc jém Rey iñɨ́máypa jém it́yajwɨɨp iŋwɨ̱mɨ: “Mi̱ñɨ mimicht́am jém miwɨ̱wadayñewɨɨp anJa̱tuŋ Dios. Mi̱ñɨ, pɨctsoŋtaamɨ jém lugar jém miwɨ̱tsagayñeta̱wɨɨp dende iwat Dios yɨ́p nas. ");
INSERT INTO poiNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Porque tsa̱m ayua̱p y mimicht́am anacwícta. Tsa̱m anɨ́ctɨtspa y micht́am anacnɨ́cta. Ɨch juuts juumɨpɨc apɨ̱xiñ, pero mimicht́am anacnúcsta tɨc. ");
INSERT INTO poiNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","D́a apuctugɨ́y, pero mimicht́am anchiit́a. Amɨmne y mimicht́am oy anámta. Apajta̱ cárcel, pero mimicht́am oy anámta.” ");
INSERT INTO poiNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","’Jesɨc jém wɨbɨc pɨxiñt́am, jém iwɨ̱pɨctsoŋneyajwɨɨp jém aŋjagooyi, nɨmyajpa: “MánO̱mi, ¿jucha̱ mánixt́a iga miyua̱p y manacwícta? ¿Jucha̱ mánixt́a iga miñɨ́ctɨtspa y manacnɨ́cta? ");
INSERT INTO poiNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Jucha̱ mánixt́a juuts tu̱m juumɨpɨc mipɨ̱xiñ y manacnúcsta tɨc, o iga d́a mipuctugɨ́y y manchiit́a? ");
INSERT INTO poiNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Jucha̱ mánixt́a mimɨmne o mipajneta̱ cárcel y oy mánámta?” ");
INSERT INTO poiNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Jém Rey icutsoŋ, iñɨ́máy jém iwɨ̱watneyajwɨɨp: “Nu̱ma, mannɨ́máypa, t́it́am iŋwadáy yɨ́p antɨ̱wɨtam, jém d́apɨc juchaŋ, jesɨc ɨch mismo aŋwɨ̱wadáy.” ");
INSERT INTO poiNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Jesɨc jém Rey iñɨ́máy jém it́yajwɨɨp iŋna̱ymɨ: “Mimicht́am tsa̱m mimalo, impɨctsoŋtámpa jém castigo. Nɨctaamɨ jém juctjo̱m ju̱t́ d́a nunca píchpa jém watneta̱wɨɨp para jém Woccɨɨwiñ y jém mal espíritu. ");
INSERT INTO poiNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ɨch tsa̱m ayua̱p y mimicht́am d́a anacwícta. Tsa̱m anɨ́ctɨtspa y mimicht́am d́a anacnɨ́cta. ");
INSERT INTO poiNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Asɨɨba juuts tu̱m juumɨpɨc apɨ̱xiñ, pero mimicht́am d́a anacnúcsta tɨc. D́a apuctugɨ́y y mimicht́am d́a t́i anchiit́a. Amɨmne y apajta̱ cárcel y mimicht́am d́at́im oy anámta.” ");
INSERT INTO poiNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Jesɨc nɨmyajpa jém malopɨc pɨxiñt́am: “MánO̱mi, ¿juchɨs mánixt́a cuando miyua̱p, miñɨ́ctɨtspa, mixɨɨba juuts tu̱m juumɨpɨc pɨ̱xiñ, d́a mipuctugɨ́y, mimɨmne, o mipajneta̱ cárcel y d́a oy manyo̱xpátta?” ");
INSERT INTO poiNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Jesɨc jém Rey icutsoŋpa jém malopɨc pɨxiñt́am. Nɨ́mayyajta̱: “Nu̱ma mannɨ́máypa, como d́a iŋwɨ̱wadayt́a jém antɨ̱wɨtam d́apɨc juchaŋ, jesɨc ɨcht́im mismo d́a aŋwɨ̱wadáy.” ");
INSERT INTO poiNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ocmɨ nɨcyajpa yɨ́p malopɨc pɨxiñt́am ju̱t́ ipɨctsoŋyajpa jém castigo ju̱t́ d́a nunca yajpa iyoj. Pero jém wɨbɨc pɨxiñt́am, jém iwɨ̱watneyajwɨɨp, ipɨctsoŋpa jém vida jém d́apɨc cuyajpa. ");
INSERT INTO poiNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Cuando yaj iŋmat Jesús, iñɨ́máy jém icuyujcɨɨwiñ: ");
INSERT INTO poiNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Mimicht́am iñjo̱doŋtam iga wɨsna ja̱ma naspa jém pascuasɨŋ y ɨch, jém aMiññewɨɨp Sɨŋyucmɨ, acɨɨjuŋcotta̱p iga acunúnta̱p cunusyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Jesɨc aŋtuuma̱yajpa jém co̱bacpɨc pa̱nijyaj con jém escribaspɨc maestroyaj y con jém Israelpɨc wɨd́ayt́am. Aŋtuuma̱yajpa jém co̱bacpɨc pa̱nij, jém Caifás, ipalacio. ");
INSERT INTO poiNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Jemum moj ijɨ̱syaj jutsa̱p icumɨgoyyaj jém Jesús iga imatsyajpa iga iccaayajpa. ");
INSERT INTO poiNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pero nɨmyajpa jém aŋjagooyiyaj: —D́a tammatspa yɨ́p sɨŋjo̱m, jesɨc d́a cujínayyajpa jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","It́ Jesús jém attebet Betania, núc jém Ximoj it́ɨccɨɨm, jém cupúgayñewɨɨp id́ɨc iña̱ca. ");
INSERT INTO poiNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Icunúc tu̱m yo̱mo con tu̱m tsaafrasco comne jém aceite jém cɨ̱npáppɨc jém aguipɨc tsoowɨ́y. Cuando co̱ñ Jesús jém mesacɨɨm, jém yo̱mo icutegáy jém aceite ico̱bacyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Cuando iixyaj jém icuyujcɨɨwiñ agui jóyyaj. Nɨmyaj: —¿T́iiga it́ecmɨ̱chca yɨ́p aceite? ");
INSERT INTO poiNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Meega tammáypa, tampɨctsoŋpa jáyaŋ tumiñ. Wɨa̱p tanyo̱xpátta jém yaacha̱yajpáppɨc. ");
INSERT INTO poiNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesɨc Jesús icutɨɨyɨ́y t́i sɨ́p iñɨmyaj jém icuyujcɨɨwiñ. Iñɨ́máy: —Odoy moogɨɨyɨ yɨ́p yo̱mo. Sɨ́p awɨ̱wadáy. ");
INSERT INTO poiNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Jém yaacha̱yajpáppɨc siempre iŋwaganait́t́ámpa. Pero aɨch d́a siempre maŋwaganait́t́ámpa. ");
INSERT INTO poiNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Acutegáy jém yo̱mo jém aceite ammɨjta̱yyucmɨ juuts cuando cumta̱p tu̱m tsúts. ");
INSERT INTO poiNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nu̱ma mannɨ́máypa iga ju̱t́quej aŋmatta̱p jém wɨbɨc aŋma̱t́i icuwɨ̱t́i yɨ́p naxyucmɨ, aŋmatta̱pt́im t́i awadáy yɨ́p yo̱mo iga jém pɨxiñt́am ijɨ̱syajiñ t́i iwat yɨ́p yo̱mo. ");
INSERT INTO poiNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ocmɨ tu̱m de jém docepɨc icuyujcɨɨwiñ iñɨ̱yi Judas Iscariote nɨc iniŋmat jém pa̱nij aŋjagooyiyaj. ");
INSERT INTO poiNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Iñɨ́máy jém pa̱nijyaj: —¿Jutsaŋ anyojpa siiga aŋcɨɨjuŋcotpa jém Jesús? Jesɨc jeeyaj iyojyaj treinta tumiñ de plata. ");
INSERT INTO poiNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Dende jeet́i rato moj ijɨ̱s jém Judas jutsa̱p icɨɨjuŋcot jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Núc jém sɨŋ cuando cútta̱p jém caxt́ána̱ñi sin levadura. Jesɨc jém wiñt́ipɨc ja̱ma jém Jesús icuyujcɨɨwiñ icunúcyaj. Icwácyaj, iñɨ́mayyaj Jesús: —¿Ju̱t́ iñxunpa iga aŋwɨ̱tsacpa it́u̱mpɨy cosa iga tawíctámpa jém pascuasɨŋ? ");
INSERT INTO poiNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesús iñɨ́máy icuyujcɨɨwiñ: —Nɨctaamɨ jém attebet Jerusalén. Cuando miñúctámpa tu̱m tɨccɨɨm, impátpa tu̱m pɨ̱xiñ. Nɨ́maayɨ: “Nɨmpa jém amMaestro iga sɨɨp núcum jém hora iga cupacpa jém anyo̱xacuy. Anacnaspa jém pascuasɨŋ mich iñt́ɨccɨɨm con aŋcuyujcɨɨwiñ.” ");
INSERT INTO poiNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jesús icuyujcɨɨwiñ iwatyaj it́u̱mpɨy cosa juuts ipɨɨmɨ́y. Iwatyajpa jém wíccuy iga icnaspa jém pascuasɨŋ. ");
INSERT INTO poiNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Jesɨc tsuuya̱wum i̱t́i, co̱ñyaj Jesús jém mesacɨɨm con jém doce icuyujcɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Iganam wícyajpa, nɨmpa Jesús: —Nu̱ma mannɨ́máypa, tu̱m de mimicht́am aŋcɨɨjuŋcotpa jém ánenemigo icɨɨjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Jesɨc jém icuyujcɨɨwiñ tsa̱m aŋyácyaj. Moj nacwácyajta̱ji entre jeeyaj. Cada tu̱mtu̱m nɨm: —MánO̱mi, ¿que aɨcham? ");
INSERT INTO poiNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Icutsoŋ Jesús. Nɨmpa: —Jém aŋwaganaso̱npaap caxt́ána̱ñi tu̱mt́i chi̱majo̱m, jeam jém acɨɨjuŋcotpaap ánenemigo icɨɨjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Jém Miññewɨɨp Sɨŋyucmɨ tienes que iñascaaba juuts nɨmpa jém Dios iŋma̱t́i ju̱t́ jayñeta̱, pero agui uuguyt́im jém pɨxiñt́am jém acɨɨjuŋcotpáppɨc, wɨ̱ id́ɨc meega d́a nay. ");
INSERT INTO poiNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ocmɨ jɨy jém Judas jém icɨɨjuŋcotpaap. Nɨmpa: —MamMaestro, ¿que aɨcham? Jesús iñɨ́máy: —Mimicham. ");
INSERT INTO poiNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Iganam wícyajpa, Jesús imatspɨc jém caxt́ána̱ñi. Cuando yaj iŋwejpát Dios, iwéc jém caxt́ána̱ñi, ichi icuyujcɨɨwiñ. Iñɨ́máy: —Yɨ́p caxt́ána̱ñi ɨch ammɨjta̱y, cúttaamɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ocmɨ ipɨc tu̱m copa jém uvas iñɨ, iŋwejpát Dios. Ichi jeeyaj. Iñɨ́máy: —Uctaamɨ iñt́u̱mpɨyt́am. ");
INSERT INTO poiNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Yɨ́p ɨch annɨɨpiñ jém antegaypáppɨc iga aŋwatpa jém jo̱mipɨc trato iga aŋwɨ̱tsagáypa jáyaŋ jém pɨxiñt́am it́áŋca. ");
INSERT INTO poiNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mannɨ́may-t́ámpa mimicht́am iga dende sɨɨp d́a ánucpa jém uvas iñɨ hasta que núcpa jém ja̱ma iga ánucpa e̱ybɨc con mimicht́am ju̱t́ iŋjacpa anJa̱tuŋ Dios. ");
INSERT INTO poiNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Jesɨc yaj iwanyaj tu̱m wa̱ñi, nɨcyaj jém co̱tsɨcyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ocmɨ Jesús iñɨ́máy icuyujcɨɨwiñ: —Mimicht́am iñt́u̱mpɨyt́am tsa̱m micɨ̱ŋtámpa y ampoychactámpa aŋcut́um yɨ́pt́im tsuu. Porque nɨmpa así jém Dios iŋma̱t́i ju̱t́ jayñeta̱: “Accaata̱p jém iwatpáppɨc cuenta jém borregoyaj. Jém borregoyaj cupóyayyajpa.” ");
INSERT INTO poiNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pero ocmɨ cuando apɨspa, aŋjagoyñeeba annɨc jém naxyucmɨ de Galilea. ");
INSERT INTO poiNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Jesɨc Peto iñɨ́máy jém Jesús: —Aunque it́u̱mpɨy tsa̱m cɨ̱ŋyajpa y michacyajpa iŋcut́um, más aɨch d́a acɨ̱ŋpa y d́a maŋcupóyáypa. ");
INSERT INTO poiNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesɨc Jesús iñɨ́máy: —Nu̱ma mannɨ́máypa iga yɨ́pt́im tsuu antes que aŋwejpa jém ca̱yu mich anaŋnécpa tuccɨy. ");
INSERT INTO poiNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Jém Peto iñɨ́máy: —Aunque tawagaaccaata̱iñ con mimich, ɨch d́a manaŋnécpa. It́u̱mpɨy jém icuyujcɨɨwiñ nɨmyajt́im je̱mpɨc. ");
INSERT INTO poiNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jesɨc nɨcyaj Jesús con jém icuyujcɨɨwiñ tu̱m lugar iñɨ̱yi Getsemaní. Nɨmpa Jesús: —Co̱ñt́aamɨ yɨɨm iganam ɨch anɨcpa jemɨc iga anaŋwejpátpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Jesɨc Jesús ininɨc uxaŋ más juumɨ jém Peto y icuɨstɨc jém Zebedeo ima̱nɨctam. Tsa̱m pɨ̱mi aŋyác Jesús, tsa̱m ijɨ̱spa t́i iñascaaba. ");
INSERT INTO poiNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Jesɨc Jesús iñɨ́máy jém tucute̱n icuyujcɨɨwiñ: —Ɨch agui pɨ̱mi aŋyácne ána̱namaŋjo̱m hasta quénam acaatooba. Tsɨ́yt́aamɨ yɨɨm, odoy moŋtaamɨ, nawattamta̱jɨ cuenta. ");
INSERT INTO poiNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jesɨc ocmɨ Jesús nɨc uxaŋ más juumɨ. Tocsneactɨŋ. Moj iŋwejpát Dios. Nɨmpa: —ManJa̱tuŋ, siiga iŋwɨ̱aŋja̱m odoy jɨɨcɨ iga annascaaba yɨ́p mɨjpɨc yaacha̱ji. Pero odoy wa̱tɨ juuts ɨch ansunpa. Wa̱tɨ juuts mich iŋwɨ̱aŋja̱m. ");
INSERT INTO poiNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Jesɨc se̱t e̱ybɨc Jesús ju̱t́ ichac jém tucute̱n icuyujcɨɨwiñ. Moŋyajpa. Iñɨ́máy jém Peto: —¿Mimoŋpa Peto? ¿Que d́a wɨa̱p imvivoja̱ con aɨch ni tu̱m hora? ");
INSERT INTO poiNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Odoy moŋtaamɨ, nawattamta̱jɨ cuenta. Aŋwejpáttaamɨ Dios iga odoy i̱ wɨa̱iñ micutɨ́tsta iga micmalwattámpa. Nu̱ma, jém íña̱nama iwattooba juuts ixunpa Dios, pero jém immɨjta̱y d́a iwɨ̱aŋja̱m. ");
INSERT INTO poiNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jesɨc e̱ybɨct́im nɨc Jesús iŋwejpát Dios. Nɨmpa: —ManJa̱tuŋ, siiga d́a wɨa̱p aŋcɨacput yɨ́p mɨjpɨc yaacha̱ji, jesɨc wa̱tɨ juuts mich iŋwɨ̱aŋja̱m. ");
INSERT INTO poiNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ocmɨ e̱ybɨc se̱t Jesús ju̱t́ it́ icuyujcɨɨwiñ. Tsa̱m moŋyajpa. D́a tojtooba iixcuy porque tsa̱m moŋtooba. ");
INSERT INTO poiNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Jemum ichac jém icuyujcɨɨwiñ. E̱ybɨct́im nɨc iŋwejpát Dios tres vecesam. Nɨmpa jeet́im aŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Jesɨc se̱t e̱ybɨc ju̱t́ it́ jém icuyujcɨɨwiñ. Iñɨ́máy: —Sɨɨp nu̱ma moŋtaamɨm, jejtaamɨm. Sɨɨp núcum jém hora iga ɨch, jém aMiññewɨɨp Sɨŋyucmɨ, acɨɨjuŋcotta̱p jém malopɨc pɨxiñt́am icɨɨjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Tsucumtaamɨm, tanɨctámpam porque miñpam jém acɨɨjuŋcotpaap. ");
INSERT INTO poiNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Iganam sɨ́p ijɨy Jesús, núc jém Judas jém it́wɨɨp id́ɨc con jém doce icuyujcɨɨwiñ. Iwaganamiñyaj tsa̱m jáyaŋ jém pɨxiñt́am. Inimiñyaj espada y jém cuy iga icótspa. Icutsadayyaj jém pa̱nij aŋjagooyi y jém wɨd́ayt́am. ");
INSERT INTO poiNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Jém Judas, jém icɨɨjuŋcotpaap Jesús, iwadáy jém pɨxiñt́am tu̱m seña. Iñɨ́máy: —Jém anaŋna̱catsútspaap, jeam. Matstaamɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Jesɨc jém Judas icunúc jém Jesús. Iñɨ́máy: —MamMaestro, xutsóy. Jesɨc iŋna̱catsúts. ");
INSERT INTO poiNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesús iñɨ́máy: —¿Amigo, t́i miñ imméts? Jesɨc icunúcyaj jém miññeyajwɨɨp. Imatsyaj jém Jesús. Nanɨcta̱wum preso. ");
INSERT INTO poiNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Pero tu̱m jém iwaganait́wɨɨp Jesús, it́op tu̱m espada, it́ɨŋquímáy it́a̱tsɨc jém co̱bacpɨc pa̱nij imozo. ");
INSERT INTO poiNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesɨc Jesús iñɨ́máy: —Co̱tɨ jém espada iñacjo̱m. Porque it́u̱mpɨy jém áŋa̱yajpáppɨc con espada, con espadat́im accaata̱p. ");
INSERT INTO poiNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Que d́a iñjo̱doŋ iga ɨch wɨa̱p aŋwágáy Dios iga acutsadáyiñ doce legiones jém sɨŋyucmɨpɨc pɨxiñt́am y yɨ́pt́i rato acutsadáypa? ");
INSERT INTO poiNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pero siiga aŋwatpa je̱mpɨc, ¿jutsa̱p icupac jém aŋma̱t́i ju̱t́ jayñeta̱ iga ayaachwatta̱p? ");
INSERT INTO poiNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Jesɨc Jesús iñɨ́máy jém miññeyajwɨɨp: —¿Que miñ ammatsta con espada y jém cuy juuts tu̱m anúmpaap? It́u̱mpɨy ja̱ma accuyujóypa ma̱stɨcjo̱m, d́a nunca ammatsta. ");
INSERT INTO poiNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","It́u̱mpɨy yɨ́p cosa iñascaaba Jesús iga cupacpa juuts ijaychacne jém wiñɨcpɨc aŋmat́cɨɨwiñ. Jesɨc it́u̱mpɨy jém icuyujcɨɨwiñ yaj cupóyaayiyaj. Icut́um tsɨ́y jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jesɨc jém imatsneyajwɨɨp Jesús ininɨcyaj jém Caifás iwiñjo̱m, jém co̱bacpɨc pa̱nij aŋjagooyi. Jemum aŋtuuma̱neyaj wa̱t́i jém escribaspɨc maestroyaj y jém wɨd́ayt́am. ");
INSERT INTO poiNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Jém Peto ijuumactúŋɨyñe hasta jém co̱bacpɨc pa̱nij iaŋcɨɨm. Jemum tɨgɨy, cooñaŋjac jém Peto con jém policía. Iixt́ooba t́i nawatta̱p jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Jém co̱bacpɨc pa̱nijyaj con it́u̱mpɨy jém wɨd́ayt́am, jém Sanhedrín, imétsyajpa tu̱m cumɨgoypaap iga accaata̱iñ Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pero d́a ipátyaj jém nɨmyajpáppɨc iga imalwatne. Tsa̱m jáyaŋ pɨ̱xiñ icumɨgoyyajtooba id́ɨc jém Jesús, pero d́a wɨa̱p. Ocmɨ miñ wɨste̱n jém pɨ̱xiñ jém icumɨgoypaap. ");
INSERT INTO poiNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Nɨmyaj: —Yɨ́p pɨ̱xiñ nɨmpa iga: “Ɨch wɨa̱p ammɨswat jém Dios ima̱stɨc, jesɨc tucunaja̱ma e̱ybɨc anactsucumpa.” ");
INSERT INTO poiNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Jesɨc te̱ñchucum jém co̱bacpɨc pa̱nij, iñɨ́máy Jesús: —¿Que d́a iŋcutsoŋpa? ¿D́a immatoŋ t́i sɨ́p iñɨmyaj contra mimich? ");
INSERT INTO poiNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pero Jesús d́a jɨypa. Jém co̱bacpɨc pa̱nij aŋjagooyi iñɨ́máy: —Odoy amɨgóyaayɨ porque jém vivopɨc Dios taixpa. Anuntanɨ́maayɨ siiga nu̱ma mimicham miCristo jém Dios miMa̱nɨc. ");
INSERT INTO poiNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesɨc Jesús iñɨ́máy: —Juuts mich miñɨm. Pero mannɨ́máypa iga dende sɨɨp ánixt́ámpa aɨch, jém aMiññewɨɨp Sɨŋyucmɨ, cuando aco̱ñ jém tanJa̱tuŋ Dios iŋwɨ̱mɨ, jém tsa̱mpɨc iniit́ ipɨ̱mi. Ánixt́ámpat́im cuando amiñgacpa sɨŋyucmɨ jém ucsaŋjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jesɨc jém co̱bacpɨc pa̱nij ichiccujac iyoot́i iga quejiñ iga icujɨypa Dios. Nɨmpa: —Yɨ́p pɨ̱xiñ icujɨypa tanDios. ¿T́iiga tammétstámpa tuŋgac testigo? Mimicht́am sɨɨp immatoŋneta iga tsa̱m icujɨypa tanDios. ");
INSERT INTO poiNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿T́i iñjɨ̱stámpa? Nɨmyajpa jém miññeyajwɨɨp: —Iniit́ la culpa. Wɨ̱ iga tanaccaaba. ");
INSERT INTO poiNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ocmɨ ichujcaayyaj iwiñpac. Ixoŋyaj. Tuŋgac it́ojáy iwiñpac. ");
INSERT INTO poiNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Nɨmyaj: —Siiga micham miCristo, anɨ́maayɨ i̱ micóts. ");
INSERT INTO poiNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Iganam co̱ñ jém Peto aŋcɨɨm, miñ tu̱m yo̱mo jém icuyo̱xapaap jém pa̱nij. Iñɨ́máy jém Peto: —Mich iŋwaganasɨɨbat́im jém Jesús, jém Galileapɨc pɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pero jém Peto iŋnéc iga iwaganasɨɨba Jesús. Iñɨ́máy jém yo̱mo: —D́a anjo̱doŋ t́i sɨ́p iññɨm. ");
INSERT INTO poiNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Cuando nɨc jém Peto jém corredor, tuŋgac jém yo̱mo iixpɨct́im, iñɨ́máy jém it́yajwɨɨp je̱m: —Yɨ́p pɨ̱xiñ iwaganasɨɨba jém Jesús jém Nazaretpɨc. ");
INSERT INTO poiNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","E̱ybɨct́im iŋnéc jém Peto. Nɨmpa: —Wɨ̱jo̱dios, d́a ánixpɨcpa. ");
INSERT INTO poiNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Tu̱m rato más, algunos jém it́yajwɨɨp je̱m, icunúcyaj jém Peto, iñɨ́máy: —Nu̱ma mich tu̱m jeepɨct́im mipɨ̱xiñ, tsa̱m wɨ̱quejpa hasta iniŋma̱t́i iga Nazaretpɨc mipɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Jesɨc jém Peto moj malnɨ̱mi. Nɨmpa: —Wɨ̱jo̱dios, ɨch d́a ánixpɨcpa yɨ́p pɨ̱xiñ. Jeet́i rato aŋwej jém ca̱yu. ");
INSERT INTO poiNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Jesɨc jém Peto ijɨ̱s t́i iñɨ́máy Jesús cuando iñɨ́máypa iga: “Mich anaŋnécpa tres veces antes que aŋwejpa jém ca̱yu.” Jesɨc put aŋsɨ̱cmɨ jém Peto. Pɨ̱mi wejpa porque agui aŋyácne. ");
INSERT INTO poiNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Jesɨc icuqueja̱ma aŋtuuma̱yajpa it́u̱mpɨy jém pa̱nij aŋjagooyiyaj y jém wɨd́ayt́am iga iwatyajpa acuerdo jutsa̱p iccaayaj Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Tsenneta̱ jém Jesús, nanɨcta̱ jém gobernadorcɨɨm. Cɨɨjuŋcotta̱ jém Poncio Pilato icɨɨjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jém Judas, jém iwadayñewɨɨp atraición, iix iga accaata̱p jém Jesús. Jesɨc icucac ijɨ̱xi, ichacse̱t jém treinta tumiñ de plata jém pa̱nij aŋjagooyi con jém wɨd́ayt́am. ");
INSERT INTO poiNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Nɨmpa jém Judas: —Ɨch tsa̱m aŋwat táŋca iga aŋcɨɨjuŋcot tu̱m pɨ̱xiñ d́apɨc t́i iwatne iga accaata̱iñ. Pero jeeyaj nɨmyaj: —Ɨch d́a ant́icutɨgɨ̱yi. Je cuestión de mimich. ");
INSERT INTO poiNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ocmɨ jém Judas ipatsquet jém tumiñ ma̱stɨcjo̱m. Nɨc. Najúpcata̱ iyaac. ");
INSERT INTO poiNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Jém pa̱nij aŋjagooyi ipiŋ jém tumiñ. Nɨmyajpa, yɨ́p tumiñ d́a wɨa̱p taŋcot jém cajonjo̱m ju̱t́ accáyt́a̱p jém ofrenda porque yɨ́p tumiñ nɨɨpiñ icho̱wa. ");
INSERT INTO poiNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ocmɨ iwatyaj acuerdo iga ijuyyajpa tu̱m ja̱ca nas con jém tumiñ. Jém lugar iñɨ̱yi jém suuŋnascɨɨm. Ijuyyaj iga iniit́ lugar ju̱t́ cumyajta̱p jém juumɨpɨc pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Jeeyucmɨ hasta sɨɨp iñɨ̱yi jém nas, jém Nɨɨpiñ iCho̱wa. ");
INSERT INTO poiNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Je̱mpam cupacpa juuts nɨmpa jém wiñɨcpɨc aŋmat́cɨɨwiñ jém Jeremías: “Jém treinta tumiñ de plata tu̱m pɨ̱xiñ icho̱wa. Iccámáy jém precio jém Israelpɨc pɨxiñt́am. Ipɨgayyaj jém pɨ̱xiñ icho̱wa. ");
INSERT INTO poiNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Con jém tumiñ ijuyyaj jém nas ju̱t́ watta̱p suuŋ juuts anɨ́máy jém tanJa̱tuŋ Dios.” ");
INSERT INTO poiNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesɨc nanɨcta̱ Jesús jém gobernadorcɨɨm. Jém gobernador icwác Jesús. Nɨ́mayt́a̱: —¿Micham miRey de jém judíos? Jesús iñɨ́máy jém gobernador: —Aɨcham, juuts mich miñɨmpa. ");
INSERT INTO poiNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Jesɨc cuando jém pa̱nij aŋjagooyi con jém wɨd́ayt́am iquejajwadáy Jesús, d́a t́i icutsoŋ. ");
INSERT INTO poiNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Jesɨc jém Pilato iñɨ́máy Jesús: —¿Que d́a immatoŋ iga agui jáyaŋ cosa sɨ́p iñɨmyaj en contra de mimich? ");
INSERT INTO poiNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pero Jesús d́at́im icutsoŋ. Jesɨc jém gobernador agui ipooñaŋja̱mpa. ");
INSERT INTO poiNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Cada naspa jém pascuasɨŋ, iniit́ tu̱m costumbre jém gobernador iga icutsɨgáypa tu̱m preso para jém pɨxiñt́am juuts jeeyaj icupiŋyajpa. ");
INSERT INTO poiNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Pajneta̱ id́ɨc tu̱m pɨ̱xiñ iñɨ̱yi Barrabás. Jo̱dóŋa̱neta̱ iga agui malo. ");
INSERT INTO poiNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Cuando aŋtuuma̱neyaj it́u̱mpɨy jém pɨxiñt́am, jém Pilato icwácyajpa. Iñɨ́máy: —¿I̱ iñxuntámpa iga aŋcutsɨgáypa, jém Barrabás o jém Jesús, iñɨ̱yit́im Cristo? ");
INSERT INTO poiNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Porque ijo̱doŋ jém Pilato iga jém Israelpɨc aŋjagooyiyaj agui ijóyixyajpa Jesús, agui icujóyɨyyajpa jeeyucmɨ icɨɨjuŋcotyaj. ");
INSERT INTO poiNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Iganam co̱ñ jém Pilato ju̱t́ cɨɨpíŋóypa, jém iyo̱mo icutsadáy aŋma̱t́i. Nɨ́mayt́a̱ jém Pilato: “Odoy tɨgɨycuumɨ con yɨ́p wɨbɨc pɨ̱xiñ. Porque tsúmɨc agui amalmawíña̱ yɨ́bam pɨ̱xiñ icuyucmɨ.” ");
INSERT INTO poiNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pero jém pa̱nij aŋjagooyiyaj con jém wɨd́ayt́am iñɨ́mayyajpa jém pɨxiñt́am iga iwácyajiñ iga cutsɨgayt́a̱iñ jém Barrabás y accaata̱iñ jém Jesús, hasta ijɨ́cyaj jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Jesɨc e̱ybɨc jém gobernador iñɨ́máy jeeyaj: —¿Juppɨc de yɨ́p wɨste̱n pɨ̱xiñ iŋwɨ̱aŋja̱mta iga aŋcutsɨgáypa? Nɨmyaj: —Barrabás. ");
INSERT INTO poiNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Jesɨc jém Pilato e̱ybɨc icwácpa jém pɨxiñt́am. Nɨ́mayyajta̱: —¿T́i iŋwɨ̱aŋja̱mta iga aŋwadáypa yɨ́p Jesús iñɨ̱yit́im Cristo? It́u̱mpɨy jém pɨxiñt́am icutsoŋyaj. Nɨmyaj: —¡Cunúntaamɨ cunusyucmɨ! ");
INSERT INTO poiNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Jesɨc Pilato iñɨ́máy jém pɨxiñt́am: —¿T́iiga? ¿T́i mal iwatne? Pero más pɨ̱mi jɨyyajpa jeeyaj. Nɨmyaj: —¡Cunúntaamɨ cunusyucmɨ! ");
INSERT INTO poiNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Cuando iix jém Pilato iga d́a t́i wɨa̱p iwat iga sɨ́p icujíñayyaj jém pɨxiñt́am, iwác uxaŋ nɨ, iche icɨ jém pɨxiñt́am iwiñjo̱m. Nɨmpa: —Ɨch d́a anai̱ la culpa iga accaata̱p yɨ́p wɨbɨc pɨ̱xiñ. D́a t́i iwatne. Yɨ́p cuestión de mimicht́am. ");
INSERT INTO poiNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Nɨmyaj it́u̱mpɨy jém miññeyajwɨɨp: —Aɨcht́am con jém amma̱nɨctam anait́t́a la culpa iga accaata̱p yɨ́p pɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Jesɨc ocmɨ jém Pilato icutsɨgáy jém Barrabás. Ipɨɨmɨ́y jém soldado iga cótsta̱iñ Jesús. Icɨɨjuŋcodáy jém soldado iga icunúnyajiñ cunusyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Jesɨc jém gobernador isoldado ininɨc Jesús tu̱m mɨjpɨc cuarto ju̱t́ aŋtuuma̱neyaj tsa̱m jáyaŋ jém soldado. It́u̱mpɨy icute̱ñxe̱tyaj Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Tsodayt́a̱ jém yagatspɨc iyoot́i. Accámayt́a̱ jém tuŋgac yoot́i jém tsabatspɨc. ");
INSERT INTO poiNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Jém soldado it́agayyaj tu̱m apit́ corona, icámayyaj ico̱bacyucmɨ. Ichiiyaj tu̱m cuy iga imatspa iŋwɨ̱cɨɨmɨ juuts tu̱m rey. Ico̱steeñayyajpa jém Jesús iwiñjo̱m. Ixaayɨyyajpa. Nɨmyaj: —¡Xutsóy miRey de jém judíos! ");
INSERT INTO poiNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ichujcayajpa. It́obayyaj jém icuy iga iyɨ́gáyáypa ico̱bac. ");
INSERT INTO poiNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Cuando yaj ixaayɨyyaj, iccáyáy jém tsabats yoot́i, icámáy e̱ybɨc jém iyoot́i jém imɨɨchipɨc. Ocmɨ nanɨcta̱ iga cunúnta̱p cunusyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Cuando nɨquiyaj tuŋjo̱m, ipát tu̱m Cirenepɨc pɨ̱xiñ iñɨ̱yi Ximoj. Jém soldado ipɨɨmɨ́y jém Ximoj iga ininɨgáyiñ jém Jesús icunus. ");
INSERT INTO poiNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Jesɨc núcyaj tu̱m lugar iñɨ̱yi Gólgota. Nɨmtooba jém Tsútsco̱bacpaccɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Jemum ichiiyaj jém vino namotneta̱ con chuxñi̱wi. Cuando icutɨ́ts Jesús jém vino, d́a iuc. ");
INSERT INTO poiNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Cuando yaj icunúnyaj cunusyucmɨ jém soldado, iwatyajpa sorteo entre jeeyaj i̱ icoñwɨ́ypa iga imɨɨcha̱p jém Jesús ipuctu̱cu. Je̱mpɨgam cupac juuts nɨmpa jém wiñɨcpɨc aŋmat́cɨɨwiñ: “Iwécyajpa ampuctu̱cu entre jeeyaj. Iwatyajpa sorteo.” ");
INSERT INTO poiNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Jesɨc co̱ñyajpa jém soldado iga iwatyajpa cuenta. ");
INSERT INTO poiNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Jém ico̱bacaŋtɨcmɨ accámayt́a̱ tu̱m letrero ju̱t́ nɨmpa t́iiga accaata̱: “Yɨ́bam jém Jesús jém judíos iRey.” ");
INSERT INTO poiNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jesɨc cunúnyajta̱t́im wɨste̱n númyajpaap jeet́im lugar ju̱t́ cunúnta̱ Jesús. Páŋayt́a̱ tu̱m jém icunus jém Jesús iŋwɨ̱mɨ y tu̱m iŋna̱ymɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Jém nasyajpáppɨc je̱m iŋwɨ́ŋóyayyajpa con ico̱bac, tsa̱m imalmalnɨ́mayyajpa. ");
INSERT INTO poiNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Iñɨ́mayyaj: —Mich miñɨmpa iga immɨswatpa jém mɨjpɨc ma̱stɨc y tucunaja̱ma inictsucumpa e̱ybɨc. Siiga Dios miMa̱nɨc, nacɨacputta̱jɨ iñyaac. Nacunúnayt́a̱jɨ jém cunusyucmɨ, que̱tɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Agui ixaayɨyyajpat́im jém pa̱nij aŋjagooyiyaj, jém escribaspɨc maestroyaj, jém fariseoyaj y jém wɨd́ayt́am. Nɨmyajt́im jeeyaj: ");
INSERT INTO poiNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Yɨ́p pɨ̱xiñ icɨacputpa tuŋgac, pero iyaac d́a wɨa̱p inicɨacputta̱. Siiga nu̱ma jém Israelpɨc iRey, nacunúnayt́a̱iñ, jesɨc taŋcupɨctámpa. ");
INSERT INTO poiNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Tsa̱m icupɨcpa iga Dios wɨa̱p iyo̱xpát, jesɨc sɨɨp wɨ̱ iga Dios icɨacpud́iñ siiga nu̱ma it́oypa; como tanɨ́mayñe iga Dios iMa̱nɨc. ");
INSERT INTO poiNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Hasta jém númyajpaap, jém cunúnta̱wɨɨp con Jesús, imalnɨ́máyt́im. ");
INSERT INTO poiNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Jesɨc icuwɨ̱t́i jém naxyucmɨ cupiicha̱ dende cugapja̱ma hasta las tres de la tarde. ");
INSERT INTO poiNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Jesɨc jeet́im hora pɨ̱mi jɨy jém Jesús. Nɨm: —Elí Elí, ¿lama sabactani? Yɨ́p nɨmtooba: ManDios, manDios, ¿t́iiga antsac aŋcut́um? ");
INSERT INTO poiNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Algunos jém te̱ññeyajwɨɨp je̱m cuando imatoŋyaj, nɨmyajpa: —Yɨ́p pɨ̱xiñ sɨ́p iŋwejáy jém wiñɨcpɨc aŋmat́cɨɨwiñ jém Elías. ");
INSERT INTO poiNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Jeet́i rato nɨc poyi̱mɨ tu̱m de jeeyaj. Nɨc ipɨc tu̱m esponja juuts tu̱m pu̱qui. Imuj con jém ta̱mpɨc vino. Iccám tu̱m waycuyyucmɨ iga igucpa Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pero tuŋgac nɨmyajpa: —Tsa̱cɨ, tánixpa siiga miñpa icɨacput jém Elías. ");
INSERT INTO poiNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","E̱ybɨct́im pɨ̱mi jɨy Jesús, jesɨc caum. ");
INSERT INTO poiNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Jeet́i rato jém mɨjpɨc puctuctaañi jém it́wɨɨp jém mɨjpɨc ma̱stɨcjo̱m teeñaŋsaj icucmɨ dende sɨŋwiñ hasta naxwiñ. Tsa̱m yɨɨs jém nas, pooyaj jém mɨjpɨc tsa. ");
INSERT INTO poiNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Jém tsúts ijos áŋáyyaj. Pɨsyaj jáyaŋ jém pɨxiñt́am jém icupɨcneyajwɨɨp Dios, jém wiñɨcpɨc caaneyaj. ");
INSERT INTO poiNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ocmɨ cuando acpɨsta̱ jém Jesús, putyaj ijosjo̱m jém tsúts, nɨcyaj hasta jém attebet Jerusalén. Jemum tsa̱m jáyaŋ pɨxiñt́am iixyaj. ");
INSERT INTO poiNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Jesɨc jém capitán con jém iwatyajpáppɨc cuenta jém Jesús, cuando iixyaj iga pɨ̱mi yɨɨs jém nas y iixt́im t́i naspa je̱m, tsa̱m pɨ̱mi cɨ̱ŋyaj. Nɨmyaj: —Nu̱ma, yɨ́p pɨ̱xiñ jém Dios iMa̱nɨc. ");
INSERT INTO poiNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","It́yajt́im je̱m wa̱t́i jém yo̱mtam, juumɨ iixyajpa t́i iñasca jém Jesús. Yɨ́pyaj yo̱mtam iwaganamiñyaj Jesús jém naxyucmɨ de Galilea, jém iyo̱xpátneyajwɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Entre jeeyaj it́t́im jém Malía Magdalena, jém Malía jém Jacobo y José ia̱pa, it́t́im jém Zebedeo iyo̱mo. ");
INSERT INTO poiNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Jesɨc tsuuyɨm miñ tu̱m pɨ̱xiñ tsa̱m rico iñɨ̱yi José. Tsucum jém attebet Arimatea, jém Jesús icuyujcɨɨwiñt́im. ");
INSERT INTO poiNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Jesɨc jém José nɨc iám jém Pilato, iwágáy jém Jesús imɨjta̱y. Jesɨc jém Pilato ipɨɨmɨ́y jém soldado iga ichiáyiñ jém imɨjta̱y. ");
INSERT INTO poiNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Jesɨc José ipɨgáy jém Jesús imɨjta̱y, iŋmónáy con tu̱m wɨbɨc puctu̱cu. ");
INSERT INTO poiNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Icot jém tsaajosjo̱m, jém José imɨɨchi, jém yaguiñpɨc iwatne. Ocmɨ iŋjo̱pnúc jém tsaajos con tu̱m mɨjpɨc tsa. Yaj iwat je̱mpɨc, se̱tum. ");
INSERT INTO poiNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","It́t́im je̱m jém Malía Magdalena y jém tuŋgac Malía. Co̱ñyaj jém tsaajosaŋna̱ca. ");
INSERT INTO poiNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ocmɨ cuyaj jém ja̱ma iga iwɨ̱tsacyajpa it́u̱mpɨy cosa para jém jejcuy ja̱ma. Cuando tɨgɨy ja̱ma, aŋtuuma̱yajpa jém pa̱nij aŋjagooyi y jém fariseoyaj, nɨc iámyaj jém Pilato. ");
INSERT INTO poiNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Iñɨ́mayyaj: —Manaŋjagooyi, anjɨ̱sta iga jém mɨgoypaap cuando d́anam caane, nɨmpa iga: “Jém tucunaja̱ma ɨch apɨspa de ju̱t́ cumneyajta̱ jém caaneyajwɨɨp.” ");
INSERT INTO poiNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Jeeyucmɨ cutsa̱tɨ jém soldado iga iwatpa cuenta jém jos ju̱t́ cumta̱ hasta jém tucunaja̱ma. Wɨa̱p imiñyaj jém icuyujcɨɨwiñ tsuucɨɨm, ininɨgayyajpa jém imɨjta̱y. Ocmɨ nɨmyajpa iga: “Nu̱ma pɨsneum de ju̱t́ cumneta̱ jém caanewɨɨp.” Siiga iwatyajpa je̱mpɨc, jesɨc jém ocmɨpɨc mɨgooyi más pɨ̱mi malo que jém wiñt́ipɨc. ");
INSERT INTO poiNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Jém Pilato iñɨ́máy: —Yɨɨm it́ jém soldado. Wagananɨ̱cɨ. Nɨ̱gɨ wattaamɨ cuenta jutspɨyam miwɨa̱p. ");
INSERT INTO poiNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Jesɨc ocmɨ nɨcyaj iga iwatyajpa cuenta jém tsaajos. Icámáy tu̱m sello jém jos iŋnúccuyyucmɨ iga quejiñ siiga i̱ íŋáypa. Jemum ichacyaj jém soldado iga iwatyajiñ cuenta. ");
INSERT INTO poiNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Cuando nasum jém jejcuyja̱ma, tuŋgagam cuque̱ja, joccuquej, jém wiñt́ipɨc ja̱ma de jém semana, jém Malía Magdalena con jém tuŋgac Malía nɨc iámyaj jém jos. ");
INSERT INTO poiNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Jeet́i rato miñ tu̱m mɨjpɨc nasyɨɨxi. Quet tu̱m sɨŋyucmɨpɨc pɨ̱xiñ jém icutsatnewɨɨp tanJa̱tuŋ Dios. Cuando núc jém tsaajoscɨɨm, iccáy jém tsa jém josaŋnúccuy, ocmɨ ico̱ñca. ");
INSERT INTO poiNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Tsa̱m tsocpa juuts quénpa majɨywiñ. Tsa̱m pɨ̱mi po̱po jém ipuctu̱cu juuts nieve. ");
INSERT INTO poiNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Cuando jém soldado iixyaj, tsa̱m pɨ̱mi cɨ̱ŋyaj, cuetsayyajpa. Tsɨ́yyaj juuts caane. ");
INSERT INTO poiNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Jesɨc jém sɨŋyucmɨpɨc pɨ̱xiñ iñɨ́máy jém yo̱mtam: —Odoy cɨ̱ŋtaamɨ. Ɨch anjo̱doŋ iga miñ imméts jém Jesús jém cunúnta̱wɨɨp cunusyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","D́am i̱ yɨɨm. Pɨsneum, cupac juuts nɨm. Mi̱ñɨ aamɨ ju̱t́ tsacneta̱ id́ɨc jém tánO̱mi. ");
INSERT INTO poiNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Nɨ̱cɨ jobit́, aŋmadaayɨ jém icuyujcɨɨwiñ iga pɨsneum de ju̱t́ it́ jém caaneyajwɨɨp. Sɨɨp aŋjagóypa iñɨc jém naxyucmɨ de Galilea. Jemɨgam mictsɨ́yt́ámpa. Jɨ̱sɨ iga mannɨ́mayñeum. ");
INSERT INTO poiNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Jesɨc jém yo̱mtam cáyyaj de jém tsaajoscɨɨm. Tsa̱m pɨ̱mi cɨ̱ŋyaj, pero agui maymayyaj. Póyaŋtsucum, nɨc iŋmadáy jém icuyujcɨɨwiñ iga pɨsneum jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Iganam nɨquiyaj jém yo̱mtam, iwiñquejáy jém Jesús tuŋjo̱m. Idioschi. Jesɨc jém yo̱mtam icunúcyaj Jesús, ico̱steeñayyaj, iñuusayyaj ipuy iga ijɨ̱syajpa. ");
INSERT INTO poiNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jesɨc Jesús iñɨ́máy jém yo̱mtam: —Odoy cɨ̱ŋtaamɨ. Nɨ̱gɨ nɨ́maayɨ jém antɨ̱wɨtam iga nɨcyajiñ jém naxyucmɨ de Galilea, jemɨgam aixyajpa. ");
INSERT INTO poiNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Iganam nɨcyajpa jém yo̱mtam algunos jém soldado jém iwatnewɨɨp cuenta jém tsaajos, nɨc iŋmadayyaj jém pa̱nij aŋjagooyi t́i iñascayaj. ");
INSERT INTO poiNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Jesɨc jém pa̱nij aŋjagooyiyaj nɨc iniŋmat jém wɨd́ayt́am iga iwatyajpa acuerdo. Jesɨc tsa̱m jáyaŋ tumiñ chiiyajta̱ jém soldado. ");
INSERT INTO poiNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Nɨ́mayyajta̱ jém soldado: —Mimicht́am nɨmtaamɨ iga: “Tsuucɨɨm iganam amoŋtámpa, miñ jém Jesús icuyujcɨɨwiñ; iñúmáy jém imɨjta̱y.” ");
INSERT INTO poiNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Siiga ijo̱dóŋa̱p jém gobernador, ɨch maŋcupujpa iga odoy michiiñ castigo. ");
INSERT INTO poiNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Jesɨc jém soldado ipɨctsoŋyaj jém tumiñ, nɨc iwatyaj juuts ipɨɨmɨ́y jém pa̱nij aŋjagooyi. Je̱mpɨgam nɨmyajpa jém judíos hasta sɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jesɨc jém once icuyujcɨɨwiñ nɨcyaj jém naxyucmɨ de Galilea. Quím jém co̱tsɨcyucmɨ juuts iñɨ́mayñe Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Cuando iixyaj Jesús, ico̱steeñayyaj. Aunque algunos ijɨ̱spa iga mɨgooyi, d́a iwɨ̱cupɨcpa. ");
INSERT INTO poiNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesɨc Jesús icunúc jém icuyujcɨɨwiñ. Iñɨ́máy: —Achiiñeta̱ jém pɨ̱mi iga anaŋjacpa jém it́yajwɨɨp sɨŋyucmɨ y naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nɨ̱gɨ aŋmadaayɨ Dios iŋma̱t́i it́u̱mpɨy jém pɨxiñt́am icuwɨ̱t́i yɨ́p naxyucmɨ. Aŋquejaayɨ jém wɨbɨc aŋma̱t́i iga tsɨ́yyajiñ juuts ɨch aŋcuyujcɨɨwiñ. Acchiŋtaamɨ jém acupɨcnewɨɨp jém anJa̱tuŋ iñɨyi̱mɨ, jém Dios iMa̱nɨc iñɨyi̱mɨ y jém Dios iA̱nama iñɨyi̱mɨ. ");
INSERT INTO poiNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Aŋquejayya̱jɨ iga icupɨcyajiñ it́u̱mpɨy jém anaŋquímayooyi jém manaŋmadayñewɨɨp. Jo̱dóŋa̱taamɨ iga ɨch maŋwaganait́pa it́u̱mpɨy ja̱ma hasta cuyajpa yɨ́p nas. Jemum cuyaj.");
INSERT INTO poiNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yɨɨmpɨc tsucum jém wɨbɨc aŋma̱t́i iga tacɨacputtámiñ jém tánO̱mi Jesucristo. ");
INSERT INTO poiNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Jém wiñɨcpɨc profeta jém Isaías ijaychacne t́i iñɨ́máy jém tanJa̱tuŋ Dios: Wiñt́i aŋcutsatpa tu̱m profeta, jém pɨ̱xiñ aŋjagoyñeeba iñɨc. Miwɨ̱tsagáypa jém iñt́uŋ. ");
INSERT INTO poiNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Nɨcyajpa jém pɨxiñt́am jém tɨtsɨnaxyucmɨ ju̱t́ d́a t́i id́ɨ́yɨ́y iga imatoŋyajpa jém najɨ́yoypaap. Pɨ̱mi najɨ́yóypa jém pɨ̱xiñ. Nɨmpa: “Áŋáyaayɨ jém tánO̱mi it́uŋ. Tsa̱cɨ iga immalwattámpa porque miñpa jém tánO̱mi.” ");
INSERT INTO poiNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Jesɨc tu̱m ja̱ma núc jém Xiwan jém tɨtsɨnaxyucmɨ ju̱t́ d́a t́i id́ɨ́yɨ́y iga iŋmatpa jém Dios iŋma̱t́i y icchiŋpa jém pɨxiñt́am, iñɨ́máypa: —Tsa̱cɨ iga immalwatpa y Dios miwadáypa perdón jém iñt́áŋca. Miñt́aamɨ, manacchiŋtámpa iga quejiñ iga iŋcucacneum jém iñjɨ̱xi. ");
INSERT INTO poiNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Jesɨc it́u̱mpɨy jém Judeapɨc pɨxiñt́am con jém Jerusalénpɨc pɨxiñt́am nɨcpa imatoŋyaj jém Xiwan jém acchíŋoypáppɨc. Cuando jém pɨxiñt́am iŋmadayyajpa Dios jém it́áŋca, jém Xiwan icchiŋpa jém río de Jordán. ");
INSERT INTO poiNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","D́a wɨ̱cuyajne jém Xiwan. Jém iyoot́i tacne con jém camello ipɨc, agui jutsóypa. Jém imɨjpactsencuy tu̱m tsococuero. Icútpa jém a̱wu, iucpa jém jɨmñi chi̱ñu. ");
INSERT INTO poiNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Jesɨc jém Xiwan iŋmadáypa jém pɨxiñt́am jém Dios iŋma̱t́i. Nɨmpa: —Miñpa antuuñiaŋcɨɨm tu̱m pɨ̱xiñ más wɨa̱p que aɨch. D́a wɨa̱p annasca, d́a wɨa̱p aŋcuwijáyáy jém icɨac. ");
INSERT INTO poiNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ɨch manacchiŋtámpa con nɨ, pero jém miñpáppɨc micchiŋtámpa con Dios iA̱nama. ");
INSERT INTO poiNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Jesɨc jeet́im tiempo put it́ɨcmɨ jém Jesús jém attebet Nazaret jém naxyucmɨ de Galilea. Jesɨc jém Xiwan icchiŋ Jesús jém río de Jordán. ");
INSERT INTO poiNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Iganam putpa nɨɨcɨɨm jém Jesús, iix iga áŋáy jém sɨŋ. Quet jém Dios iA̱nama juuts tu̱m cuucu, nu̱mmiñ, núc hasta Jesúsyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Jém it́yajwɨɨp imatoŋyaj tu̱m jɨ̱yi sɨŋyucmɨ. Nɨ́mayt́a̱ jém Jesús: —Mich mamma̱nɨc, tsa̱m mantoypa. Sɨɨp agui amaymay con mimich. ");
INSERT INTO poiNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Jesɨc jeet́i rato jém Dios iA̱nama ininɨc jém Jesús jém tɨtsɨnaxyucmɨ ju̱t́ d́a t́i id́ɨ́yɨ́y. ");
INSERT INTO poiNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Nɨc i̱t́i cuarenta ja̱ma jém tɨtsɨnaxyucmɨ ju̱t́ it́yaj jém jɨmñi ani̱matyaj. Jesɨc jém Woccɨɨwiñ miñ icutɨ́ts jém Jesús iga icmalwatpa id́ɨc. Jesɨc ocmɨ miñyaj jém sɨŋyucmɨpɨc pɨxiñt́am, icuyo̱xayajpa jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ocmɨ matsta̱ jém Xiwan, pajta̱ cárcel. Iganam pajneta̱ jém Xiwan, nɨc Jesús jém naxyucmɨ de Galilea iga iŋmatpa jém wɨbɨc aŋma̱t́i iga núctooba jém ja̱ma iga Dios iŋjacpa yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Nɨmpa Jesús: —Sɨɨp núcneum jém tiempo jém iniŋjócnetaŋwɨɨp. D́am jáyñe Dios iŋjacpa jém it́yajwɨɨp yɨ́p naxyucmɨ. Jesɨc tsa̱cɨ iga immalwatpa, cuca̱cɨ iñjɨ̱xi, cupɨctaamɨ jém wɨbɨc aŋma̱t́i iga micɨacputtamta̱iñ. ");
INSERT INTO poiNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Cuando naspa Jesús jém laguna aŋna̱ca iñɨ̱yi Galilea, iix jém Ximoj con it́ɨ̱wɨ Anti. Sɨ́p ipatsyaj jém ired jém laguna porque tɨɨpteroyaj. ");
INSERT INTO poiNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesɨc Jesús iñɨ́máy jeeyaj: —Atúŋɨyt́aamɨ. Sɨɨp nɨcpa tamméts jém pɨxiñt́am juuts tɨɨpɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Jesɨc jeet́i rato ichacyaj ired, nɨc it́úŋɨyyaj jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jesɨc nɨc Jesús uxaŋ más juumɨ, ipát jém Jacobo, jém Zebedeo ima̱nɨc, con it́ɨ̱wɨ jém Xiwan. It́yaj jém barcojo̱m, sɨ́p iŋtótsyaj ired. ");
INSERT INTO poiNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jesɨc jeet́i rato iŋwejáyt́im jeeyaj. Jesɨc Jacobo y Xiwan ichacyaj ija̱tuŋ jém Zebedeo jém barcojo̱m con jém imozoyaj. Nɨc it́úŋɨyyaj jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jesɨc nɨcyaj jém attebet Capernaum. Jeet́im jejcuyja̱ma, tɨgɨy Jesús jém sinagoga. Moj iŋquejáy jém Dios iŋma̱t́i jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Jesɨc jeeyaj tsa̱m tɨ̱neaŋjacyaj cuando imatoŋyaj t́i nɨmpa jém Jesús. Porque najɨ́yóypa juuts tu̱m aŋjagooyi d́a juuts jém escribaspɨc maestroyaj. ");
INSERT INTO poiNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Jém sinagoga it́ id́ɨc tu̱m pɨ̱xiñ imatsne tu̱m mal espíritu. Pɨ̱mi aŋwejpa, nɨ́mayt́a̱ Jesús: ");
INSERT INTO poiNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—MiJesús miNazaretpɨc, ¿t́iiga ammoogɨ́ypa aɨcht́am? ¿Que miñpa anactogoyt́a? Mánixpɨcpa, mich jém Yucmɨpɨc Dios miMɨɨchi. ");
INSERT INTO poiNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesɨc Jesús iwogáy jém mal espíritu, iñɨ́máy: —Odoy jɨ̱yɨ. Pu̱tɨ yɨ́p pɨ̱xiñ ia̱namaŋjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Jém mal espíritu iccutɨŋ jém pɨ̱xiñ naxyucmɨ. Pɨ̱mi aŋwejpa jém mal espíritu, ocmɨ put. ");
INSERT INTO poiNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Pɨ̱mi aŋjécneyaj jém pɨxiñt́am. Moj nacwácyajta̱ji entre jeeyaj: —¿T́iapaap? ¿Que tu̱m jo̱mipɨc aŋquímayooyi inimiññe yɨ́p pɨ̱xiñ? Wɨa̱p ipɨɨmɨ́y jém mal espíritu juuts tu̱m aŋjagooyi y icupɨcyajpa. ");
INSERT INTO poiNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Jicscɨy waŋpa icuwɨ̱t́i jém naxyucmɨ de Galilea t́i iwatpa jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jesɨc cuando putyaj jém sinagoga jém Jesús con icuyujcɨɨwiñ, nɨcyaj jém Ximoj y Anti it́ɨccɨɨm, iwagananɨcyajt́im jém Jacobo y jém Xiwan. ");
INSERT INTO poiNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Mɨmne jém Ximoj imɨɨda̱pa. Tsa̱m pɨ̱mi jawaŋɨ́y. Wo̱ne icheesmɨ. Cuando núc jém Jesús, aŋmadayt́a̱ iga mɨmne jém yo̱mo. ");
INSERT INTO poiNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jesɨc Jesús icunúc jém yo̱mo, imatsáy icɨ, ijɨ̱ctsucum. Jeet́i rato ichac jém jawaŋ, mojum iwat jém wíccuy iga acwícta̱p Jesús con jém icuyujcɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Jesɨc tsuuyɨm cuando tɨgɨyñeum ja̱ma, jém pɨxiñt́am inimíñayyaj Jesús it́u̱mpɨy jém mɨmneyajwɨɨp y jém imatsneyajwɨɨp jém mal espíritu. ");
INSERT INTO poiNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","It́u̱mpɨy jém it́yajwɨɨp jém attebet aŋtuuma̱yaj jém Ximoj it́ɨgaŋna̱ca. ");
INSERT INTO poiNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesɨc Jesús icpɨs jáyaŋ jém mɨmneyajwɨɨp, jém iniit́yajwɨɨp wa̱t́i jém caacuy. It́opt́im jáyaŋ jém mal espíritu. Pero Jesús d́a ijɨ́gáy iga jɨypa jém mal espíritu porque jeeyaj iixpɨcpa i̱apaap jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Jesɨc tsa̱m tsuuyt́im, piichcɨɨmnam, yus jém Jesús. Put jém tɨgaŋjo̱m, nɨc icut́um tu̱m lugar ju̱t́ d́a i̱ id́ɨ́yɨ́y. Nɨc iŋwejpát Dios. ");
INSERT INTO poiNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Jesɨc jém Ximoj con jém icompañeroyaj nɨc icuámyaj jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Jesɨc ipátyaj, iñɨ́mayyaj: —Sɨ́p mimétsyaj wa̱t́i jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesɨc Jesús iñɨ́máy: —Tanɨctámpa jém tuŋgac tɨgaŋjojyaj jém it́yajwɨɨp nocojo̱m iga anaŋmatpat́im jém wɨbɨc aŋma̱t́i. Jeeyucmɨ ɨch amiññe yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Jesɨc nɨc Jesús it́u̱mpɨy jém attebetyaj icuwɨ̱t́i jém naxyucmɨ de Galilea. Cada attebet najɨ́yóypa Jesús jém sinagoga. It́opt́im jáyaŋ jém mal espíritu. ");
INSERT INTO poiNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Jesɨc miñ tu̱m pɨ̱xiñ cupúgayñe iña̱ca, icunúc Jesús. Ico̱steeñáy jém Jesús ipuycɨɨm. Icunucsáypa jém Jesús iga iyo̱xpád́iñ, nɨmpa: —Siiga iŋwɨ̱aŋja̱m, wɨa̱p anacpɨs. ");
INSERT INTO poiNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesɨc Jesús tsa̱m iyaachaŋja̱m, ichɨccunúc jém pɨ̱xiñ, iñɨ́máy: —Aŋwɨ̱aŋja̱m. Micuáyñeum. ");
INSERT INTO poiNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Jesɨc cuando yaj nɨ̱mi Jesús, jeet́i rato ichacum jém lepra caacuy, wɨ̱tsɨ́yum jém iña̱ca. ");
INSERT INTO poiNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jesɨc Jesús iŋquímpa jém pɨ̱xiñ, duro ipɨɨmɨ́y, ");
INSERT INTO poiNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","iñɨ́máy: —Odoy i̱ aŋmadaayɨ iga ɨch manacpɨs, nɨ̱gɨ aŋquejaayɨ jém pa̱nij iga michacneum jém caacuy. Nanɨgaayɨ jém ofrenda juuts nɨmpa jém Moisés iŋquímayooyi iga miixt́a̱iñ iga nu̱ma mipɨsneum. ");
INSERT INTO poiNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pero jém pɨ̱xiñ d́a iwat je̱mpɨc. Nɨc iŋmat ju̱t́quej t́i iwadáy jém Jesús. Jeeyucmɨ d́a wɨa̱p it́ɨgɨy Jesús ni tu̱m attebet ju̱t́ ixt́a̱p porque jém pɨxiñt́am tsa̱m iŋtuuma̱cayajpa. Jesɨc sɨɨba aŋsɨ̱cmɨ ju̱t́ d́a t́i id́ɨ́yɨ́y. Pero miñyajpa jém pɨxiñt́am ju̱t́quej iga iixyajpa jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Cuando nas ju̱na ja̱ma, se̱t e̱ybɨc Jesús jém Capernaum. Cuando ijo̱dóŋa̱yaj jém pɨxiñt́am iga se̱tneum it́ɨccɨɨm, ");
INSERT INTO poiNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","jeet́i rato aŋtuuma̱yajpa tsa̱m jáyaŋ pɨxiñt́am hasta d́a cutɨgɨyyajpa jém tɨgaŋna̱ca. Jesús iŋquejáypa jém Dios iŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Jesɨc cuatro pɨ̱xiñ inimíñayyaj Jesús tu̱m cu̱xuj tusacane icumɨj. Cópneta̱ inimiñt́a̱. ");
INSERT INTO poiNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Pero como tsa̱m it́ñɨ̱m, d́a wɨa̱p ininas jém mɨmnewɨɨp iga icunúcpa Jesús. Jesɨc iniquímyaj tɨgaŋco̱bac, ijetyaj jém tɨc itecho. Yaj ijetyaj, ijɨ́mquetyaj tɨ́psyucmɨ jém cu̱xuj con ichees hasta ju̱t́ it́ Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesɨc mu iix Jesús iga tsa̱m icupɨcyaj iga wɨa̱p icpɨsóy, iñɨ́máy jém cu̱xuj: —Ma̱nɨc, miwadayñeta̱ perdón jém iñt́áŋca. ");
INSERT INTO poiNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Jemum co̱ñyaj jém escribaspɨc maestroyaj. Moj ijɨ̱syaj ijɨ̱xiaŋjo̱m: ");
INSERT INTO poiNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Yɨ́p pɨ̱xiñ t́iiga nɨmpa yɨɨmpɨc? Sɨ́p icujɨy tanDios. Jém tanJa̱tuŋ Dios iyaac wɨa̱p iccáyáy tu̱m pɨ̱xiñ it́áŋca.” ");
INSERT INTO poiNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Pero Jesús ijo̱doŋ t́i sɨ́p ijɨ̱syaj, jesɨc iñɨ́máy: —¿T́iiga iñjɨ̱stámpa je̱mpɨc? ");
INSERT INTO poiNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿T́i más d́a táŋca iga annɨ́máypa yɨ́p cu̱xuj iga “Miwadayñeta̱ perdón jém iñt́áŋca” o iga annɨ́máypa iga: “Tsucu̱mɨm, pi̱ŋɨm iñchees, wi̱t́ɨm?” ");
INSERT INTO poiNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Pero iga iñjo̱dóŋa̱támiñ iga jém Miññewɨɨp Sɨŋyucmɨ iniit́ ipɨ̱mi iga wɨa̱p iccáyáy jém pɨxiñt́am it́áŋca yɨ́p naxyucmɨ (jesɨc Jesús iñɨ́máy jém cu̱xuj): ");
INSERT INTO poiNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Mannɨ́máypa, tsucu̱mɨm, pi̱ŋɨm jém iñchees, nɨcsɨm iñt́ɨcmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Iganam iámyajpa jém pɨxiñt́am, tsucum jém cu̱xuj, jeet́i rato ipiŋ jém ichees, put jém tɨcjo̱m. Jeeyaj agui ipooñaŋja̱myaj, moj icujípyaj Dios. Nɨmyaj: —D́a queman tánix yɨcxpɨc milagro. ");
INSERT INTO poiNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesɨc e̱ybɨc nɨc Jesús jém laguna aŋna̱ca. Jesɨc aŋtuuma̱yajpa tsa̱m jáyaŋ jém pɨxiñt́am ju̱t́ it́ Jesús. Moj iŋquejayyajta̱ jém Dios iŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Jesɨc moj nɨqui Jesús, naspa ju̱t́ ichécyajpa jém impuesto. Iix iga jemum co̱ñ jém Leví, jém Alfeo ima̱nɨc. Jesɨc Jesús iñɨ́máy jém Leví: —Atúŋɨɨyɨ. Jesɨc tsucum jém Leví, nɨc it́úŋɨ́y jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ocmɨ nɨc wiiqui Jesús con icuyujcɨɨwiñ jém Leví it́ɨccɨɨm. Iwaganaco̱ñyaj jáyaŋ jém ichécyajpaap impuesto y jém tuŋgac jém táŋcaɨyyajwɨɨp. Tsa̱m jáyaŋ de jeeyaj it́úŋɨyyajpa jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Pero cuando jém fariseoyaj con jém escribaspɨc maestroyaj iixyaj iga jém Jesús iwaganawícyajpa jém ichécyajpáppɨc impuesto y jém tuŋgac táŋcaɨywɨɨp, jesɨc iñɨ́mayyajpa jém Jesús icuyujcɨɨwiñ: —¿T́iiga wagawícyajpa jém immaestro con jém táŋcaɨywɨɨp? ");
INSERT INTO poiNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Cuando imatoŋ jém Jesús t́i nɨmyajpa, jesɨc iñɨ́máy jeeyaj: —Jém d́apɨc mɨmne d́a ixunpa jém tsóyɨ́yoypaap, pero jém mɨmneyajwɨɨp ixunpa jém tsóyɨ́yoypaap. Ɨch d́a amiñ iga anaŋwejáypa jém d́apɨc táŋcaɨ́y, pero miñ anaŋwejáy jém táŋcaɨywɨɨp iga ichacyajiñ jém it́áŋca. ");
INSERT INTO poiNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Tu̱m ja̱ma jém Xiwan icuyujcɨɨwiñ y jém fariseoyaj iwatyajpa ayuno. Jesɨc tuŋgac miñ icwácyaj jém Jesús, nɨ́mayt́a̱: —¿T́iiga iwatyajpa ayuno jém Xiwan icuyujcɨɨwiñ y jém fariseoyaj, pero mich iŋcuyujcɨɨwiñ d́a iwatyajpa ayuno? ");
INSERT INTO poiNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesɨc Jesús iñɨ́máy jém miññeyajwɨɨp: —Cuando yoomɨ́ypa tu̱m pɨ̱xiñ, inisɨ́ŋa̱p jém iamigoyaj. Jesɨc iganam it́ jém yoomɨypaap, d́a wɨa̱p iwatyaj ayuno. ");
INSERT INTO poiNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pero núcpa jém ja̱ma cuando nanɨcneta̱wum jém yoomɨypaap, tsɨ́yyajpa iamigoyaj icut́um. Jesɨc nu̱ma iwatyajpa ayuno. ");
INSERT INTO poiNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’D́a i̱ iŋtótspa tu̱m pecapɨc yoot́i con tu̱m ja̱ca jém jo̱mipɨc puctu̱cu. Siiga i̱ iŋtótspa jém pecapɨc yoot́i con jo̱mpuctu̱cu, jesɨc nɨaŋxichpa jém jo̱mipɨc y ocmɨm jacpa jém pecapɨc yoot́i ju̱t́ núnmatsne jém iŋtoochi. ");
INSERT INTO poiNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","D́a i̱ icucompa jém jo̱mvino jém pecapɨc cuerobolsajo̱m. Porque siiga je̱mpɨc iŋwatpa, jesɨc pɨ̱pa jém jo̱mvino, tojaŋsajpa jém pecapɨc cuerobolsa, cutegáypa jém vino, togoypat́im jém cuerobolsa. Más wɨ̱ iga cucomta̱p jém jo̱mvino jém jo̱mipɨc cuerobolsajo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Tu̱m jejcuy ja̱ma wid́aŋnaspa Jesús ju̱t́ ñipneta̱ jém trigo. Cuando wid́aŋnasyajpa jém icuyujcɨɨwiñ, moj it́úcyaj jém trigo ipac. ");
INSERT INTO poiNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Jesɨc jém fariseoyaj iñɨ́mayyaj jém Jesús: —I̱xɨ jém iŋcuyujcɨɨwiñ, ¿t́iiga iwatyajpa je̱mpɨc jém jejcuyja̱ma contra jém tanaŋquímayooyi? ");
INSERT INTO poiNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesɨc Jesús iñɨ́máy jém fariseoyaj: —¿Que d́a immayñe t́i iwatyaj jém David con icompañeroyaj cuando tsa̱m yaacha̱yajpa, tsa̱m yua̱yajpa? ");
INSERT INTO poiNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Jém David con icompañeroyaj tɨgɨyyaj jém Dios it́ɨcjo̱m cuando it́ jém co̱bacpɨc pa̱nij jém Abiatar. Jém David icút jém caxt́ána̱ñi jém tsacneta̱wɨɨp altaryucmɨ. Ichiit́im jém icompañeroyaj. Tanjo̱doŋ iga jém tanaŋquímayooyi d́a ijɨ́cpa iga i̱ icútpa jém ma̱stɨcjo̱mpɨc caxt́ána̱ñi, nada más jém pa̱nijyaj. ");
INSERT INTO poiNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jesɨc Jesús iñɨ́máyt́im jém fariseoyaj: —Dios ichac jém jejcuy ja̱ma iga iwɨ̱wadayyajiñ jém pɨxiñt́am. D́a iwat jém pɨxiñt́am iga ixutsyajpa jém jejcuy ja̱ma. ");
INSERT INTO poiNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ɨch, jém aMiññewɨɨp Sɨŋyucmɨ, achiit́a̱ jém pɨ̱mi iga wɨa̱p annɨ́máy jém pɨxiñt́am t́i wɨa̱p iwatyaj jém jejcuyja̱ma. ");
INSERT INTO poiNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesɨc e̱ybɨct́im tɨgɨy Jesús tu̱m sinagoga. Jemum it́ tu̱m pɨ̱xiñ tɨtsne icɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Jesɨc jém Jesús ienemigoyaj tsa̱m icuixyajpa siiga icpɨspa jém pɨ̱xiñ jém jejcuyja̱ma iga iquejajwadayyajtooba jém aŋjagooyicɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesɨc Jesús iñɨ́máy jém pɨ̱xiñ jém tɨtsnewɨɨp icɨ: —Te̱ñchucu̱mɨ. Mi̱ñɨ mit́e̱ñi yɨ́p pɨxiñt́am aŋcucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Jesɨc icwácpa Jesús jém it́yajwɨɨp je̱m. Nɨ́mayyajta̱: —¿T́i wɨa̱p taŋwat jém jejcuyja̱ma? ¿Wɨ̱ iga taŋwɨ̱watpa o iga tammalwatpa? ¿Wɨ̱ iga taŋcɨacpudáypa tu̱m pɨ̱xiñ ivida o tannaccáyáypa? Pero jeeyaj d́a jɨyyaj. ");
INSERT INTO poiNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesɨc Jesús icuámse̱t jém pɨxiñt́am, tsa̱m jóyñe y aŋyácne iga agui maloyaj jém ia̱nama. Jesɨc iñɨ́máy jém pɨ̱xiñ, jém tɨtsnewɨɨp icɨ: —Tɨ̱mɨ iŋcɨ. Jesɨc jém pɨ̱xiñ it́ɨ̱m jém icɨ, wɨ̱tsɨ́yñeum. ");
INSERT INTO poiNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Jesɨc putyaj jém fariseoyaj. Aŋtuuma̱yaj con jém Herodes ipɨxiñt́am, moj ijɨ̱syaj jutsa̱p iccaayaj jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Nɨcyaj jém Jesús con icuyujcɨɨwiñ jém laguna aŋna̱ca. Tsa̱m jáyaŋ jém Galileapɨc pɨxiñt́am it́úŋɨyyajpa Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ju̱t́ quej ijo̱dóŋa̱yaj jém pɨxiñt́am iga Jesús tsa̱m iwɨ̱watpa. Jesɨc nɨc iámyaj jém Jesús. Nɨcyaj jém Judeapɨc, jém Jerusalénpɨc y jém Idumeapɨc pɨxiñt́am. Nɨcyajpat́im jém it́yajwɨɨp nɨ aŋwiñt́uc jém río de Jordán y jém it́yajwɨɨp nocojo̱m de Tiro y Sidón. ");
INSERT INTO poiNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jeeyucmɨ Jesús iñɨ́máy jém icuyujcɨɨwiñ iga inimíñiñ tu̱m barco ju̱t́ químpa iga jém pɨxiñt́am odoy icpɨtsɨyyajiñ. ");
INSERT INTO poiNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Jesús icpɨs jáyaŋ jém mɨmneyajwɨɨp. Jeeyucmɨ it́u̱mpɨy jém mɨmneyajwɨɨp icunúcyajtooba Jesús. Tsa̱m ichɨcyajtooba iga pɨsyajiñ. ");
INSERT INTO poiNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Cuando jém imatsneyajwɨɨp jém mal espíritu iixyaj Jesús, jesɨc ico̱steeñayyaj jém Jesús ipuycɨɨm, pɨ̱mi aŋwejyajpa. Nɨmyajpa: —¡Micham Dios miMa̱nɨc! ");
INSERT INTO poiNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jesɨc Jesús iwogáypa jém imatsneyajwɨɨp jém mal espíritu. Iñɨ́máy iga odoy nɨ́miñ i̱apaap jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jesɨc ocmɨ quím Jesús tu̱m co̱tsɨcyucmɨ. Iŋwejáy jém icupiŋpaap juuts je iwɨ̱aŋja̱m. Jesɨc jeeyaj miñ iámyaj jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Jesɨc Jesús icupiŋ doce jém icuyujcɨɨwiñ iga iwaganasɨɨba. Icutsattooba iga nɨguiñ iŋmat jém Dios iŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Chiit́a̱pt́im jém Dios ipɨ̱mi iga icpɨsyajiñ jém mɨmneyajwɨɨp y iga it́opyajiñ jém mal espíritu jém pɨxiñt́am ia̱namaŋjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Icupiŋ doce jém icuyujcɨɨwiñ: jém Ximoj, iccámáyt́im iñɨ̱yi iga Peto; ");
INSERT INTO poiNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacobo, con it́ɨ̱wɨ jém Xiwan, icuɨstɨc Zebedeo ima̱nɨctam, accámayt́a̱ iñɨ̱yi jém wɨste̱n iga Boanerges, yɨ́p aŋma̱t́i nɨmtooba iga t́i̱ñpa juuts majɨywiñ. ");
INSERT INTO poiNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Cupiŋyajta̱t́im Anti; Felipe; Bartolo; Mateo; Tomax; Jacobo, jém Alfeo ima̱nɨc; Tadeo; Ximoj, jém it́wɨɨp con jém partido cananista; ");
INSERT INTO poiNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","y Judas Iscariote, jém icɨɨjuŋcotwɨɨp jém Jesús. Ocmɨ Jesús nɨc tu̱m tɨccɨɨm con jém icuyujcɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","E̱ybɨct́im aŋtuuma̱yaj tsa̱m jáyaŋ jém pɨxiñt́am. D́a i̱ lugar ni para wícyajpa jém Jesús con icuyujcɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jesɨc cuando ijo̱dóŋa̱yaj jém it́ɨ̱wɨtam t́i iwat jém Jesús, nɨc imatsyaj porque nɨmyajpa iga locoja̱ne Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Jém escribaspɨc maestroyaj miñyaj de Jerusalén. Nɨmyajpa: —Yɨ́p pɨ̱xiñ iniit́ jém mal espíritu iŋjagooyi, jém Beelzebú, ia̱namaŋjo̱m. Jeam ichi ipɨ̱mi, jeeyucmɨ wɨa̱p it́op jém mal espíritu jém pɨxiñt́am ia̱namaŋjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jesɨc Jesús iŋwejáy jém maestroyaj. Iŋquejáy con tu̱m cuento. Nɨ́mayyajta̱: —¿Jutsa̱p initopta̱ iyaac jém Woccɨɨwiñ? ");
INSERT INTO poiNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Siiga nawécta̱p tu̱m gobierno y tsɨ́ypa wɨste̱n partido, y siiga áŋa̱yajpa, jesɨc nayajyajta̱p jém gobierno. ");
INSERT INTO poiNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Siiga najóyixyajta̱p tu̱m pɨ̱xiñ ima̱nɨctam y áŋa̱yajpa con it́ɨ̱wɨ, jesɨc nayajyajta̱p. ");
INSERT INTO poiNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Siiga nawécyajta̱p jém Woccɨɨwiñ idemonio y áŋa̱yajpa, jesɨc d́a jáypa cuyajpa jém Woccɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Jém númpaap d́a wɨa̱p it́ɨgɨy tu̱m pɨ̱mipɨc pɨ̱xiñ it́ɨcjo̱m iga icunúmáypa siiga d́a wiñt́i ichenpa jém tɨc io̱mi. Pero siiga wiñt́i ichenpa, jesɨc wɨa̱p iñúmáy it́u̱mpɨy jém iniit́wɨɨp it́ɨccɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Nu̱ma mannɨ́máypa iga wadayt́a̱p perdón jém pɨxiñt́am it́áŋca. Wadayt́a̱pt́im perdón siiga icujɨypa jém tanJa̱tuŋ Dios, ");
INSERT INTO poiNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","pero siiga tu̱m pɨ̱xiñ icujɨypa jém Dios iA̱nama, d́a nunca i̱ iwadáypa perdón jém it́áŋca. Chiit́a̱p castigo jém d́apɨc nunca cuyajpa. ");
INSERT INTO poiNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Nɨmpa yɨɨmpɨc jém Jesús porque nɨmyajpa jém pɨxiñt́am iga Jesús iniit́ tu̱m mal espíritu ia̱namaŋjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jesɨc ocmɨ núcyaj jém Jesús ijáyuctam con ia̱pa. Tsɨ́yyaj jém tɨc aŋna̱ca. Aŋwejayt́a̱ Jesús iga míñiñ iám ia̱pa. ");
INSERT INTO poiNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Co̱ñyaj jáyaŋ pɨxiñt́am jém tɨcjo̱m. Cucmɨ tsɨ́y jém Jesús. Jesɨc jém pɨxiñt́am iñɨ́mayyaj jém Jesús: —Jém íña̱pa con iñt́ɨ̱wɨtam con iñyo̱mtɨ̱wɨtam núcneyaj jém tɨgaŋna̱ca. Sɨ́p mimétsyaj. ");
INSERT INTO poiNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesɨc nɨmpa Jesús: —¿Pero i̱ jém ána̱pa, i̱ jém antɨ̱wɨtam? ");
INSERT INTO poiNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Jesɨc Jesús iámmats jém co̱ñyajwɨɨp je̱m, jém icuwoyxe̱tneyajwɨɨp. Iñɨ́máy: —Mimicht́am jém mána̱pa y mantɨ̱wɨtam. ");
INSERT INTO poiNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Porque it́u̱mpɨy jém iwatpaap juuts ixunpa Dios, jeam jém antɨ̱wɨ, anyo̱mtɨ̱wɨ y ána̱pa. ");
INSERT INTO poiNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesɨc e̱ybɨct́im moj iŋquejáy Jesús jém pɨxiñt́am jém laguna aŋna̱ca. Aŋtuuma̱neyaj ju̱t́ it́ Jesús tsa̱m jáyaŋ pɨxiñt́am. Jeeyucmɨ tɨgɨy tu̱m barcojo̱m, nɨc co̱ñi Jesús iga iŋquejáypa jeeyaj jém tsɨ́yñeyajwɨɨp nɨaŋna̱ca. ");
INSERT INTO poiNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jesɨc Jesús iŋquejáypa jém pɨxiñt́am tsa̱m jáyaŋ wɨ̱tampɨc jɨ̱xi cuentujmɨ. Iŋquejáypa yɨɨmpɨc: ");
INSERT INTO poiNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Sɨɨp matoŋtaamɨ t́i mannɨ́mayt́ámpa. Tu̱m pɨ̱xiñ nɨc ñi̱pi, nɨc iyɨ̱n jém trigo ipac ica̱mjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Mu iyɨ̱n jém pac, actɨŋ uxaŋ jém tuŋjo̱m. Miñyaj jém jon, icútquet. ");
INSERT INTO poiNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Actɨŋt́im uxaŋ jém pac tsaaŋjo̱m ju̱t́ d́a i̱ jáyaŋ nas. Jesɨc jicscɨy nay jém pac porque d́a juchaŋ jém nas. ");
INSERT INTO poiNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Cuando pijpa ja̱ma, iñoonoca jém xuxut́ planta. Yaj cutɨtsaayi porque d́a t́i̱chɨgɨ́y. ");
INSERT INTO poiNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Actɨŋt́im uxaŋ jém pac jém a̱pid́aŋjo̱m. Jicscɨy yón jém a̱pit́, ixamsamca jém xuxut́ planta. ");
INSERT INTO poiNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pero actɨŋt́im jém pac jém wɨbɨc naxyucmɨ. Wɨ̱tɨ́ma̱p. Algunos chióy treinta, algunos chióy sesenta, algunos chióy cien. ");
INSERT INTO poiNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jesɨc nɨmpa Jesús: —Siiga mit́atsɨgɨyt́a amatoŋtaamɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ocmɨ cunɨgayyaj jém pɨxiñt́am. Cuando icut́um tsɨ́y jém Jesús, jém it́yajwɨɨp noco con jém doce icuyujcɨɨwiñ icwácyajpa jém Jesús t́i nɨmtooba jém xut́u cuento. ");
INSERT INTO poiNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesɨc Jesús iñɨ́máy jém icuyujcɨɨwiñ: —Mimicht́am, Dios michiiba jém jɨ̱xi iga iŋcutɨɨyɨyt́ámpa jém jɨ̱xi jém aŋnécnewɨɨp id́ɨc. Sɨɨp iŋcutɨɨyɨyt́ámpa jutsa̱p iŋjac Dios jém it́yajwɨɨp yɨ́p naxyucmɨ. Pero jém tuŋgac pɨxiñt́am, jém d́apɨc icupɨcneyaj Dios, jeeyaj anaŋmadáypa cuentujmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Dios iwat je̱mpɨc para jém pɨxiñt́am jém d́apɨc ichactooba jém it́áŋca, jesɨc cuando iixyajpa, d́a icutɨɨyɨyyajpa. Cuando imatoŋyajpa, d́at́im ijo̱dóŋa̱yajpa iga odoy ichacyajiñ iga imalwatpa y odoy i̱ iwadáyiñ perdón jém it́áŋca. ");
INSERT INTO poiNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jesɨc Jesús iñɨ́máypa jém icuyujcɨɨwiñ: —Siiga mimicht́am d́a iŋcutɨɨyɨyt́ámpa yɨ́p xut́u cuento, ¿jesɨc jutsa̱p iŋcutɨɨyɨyt́a jém tuŋgac cuento siiga manaŋmadáypa? ");
INSERT INTO poiNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Jém pɨ̱xiñ jém iñippaap jém pac jex juuts jém pɨ̱xiñ jém iŋmatpaap jém Dios iŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Jesɨc cuando ñipta̱p jém Dios iŋma̱t́i algunos jém pɨxiñt́am jex juuts jém pac jém actɨŋnewɨɨp tuŋjo̱m. Imatoŋyajpa jém aŋma̱t́i, pero jém Woccɨɨwiñ miñpa iccáyáy jém aŋma̱t́i jém ñipneta̱wɨɨp jém pɨ̱xiñ ia̱namaŋjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Algunos jém pɨxiñt́am jex juuts jém pac jém actɨŋwɨɨp tsaaŋjo̱m. Imatoŋyajpa jém aŋma̱t́i. Agui maymayyaj mu ipɨctsoŋyaj jém Dios iŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Jeeyaj como d́a t́i̱chɨgɨ́y, d́a jáypa. Cuando cutɨ́tsta̱p, malwadayt́a̱p jém Dios iŋma̱t́i icuyucmɨ, jesɨc jóypa jém pɨ̱xiñ, ichacpa jém Dios iŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Algunos jém pɨxiñt́am jex juuts jém pac jém actɨŋnewɨɨp jém apid́aŋjo̱m. Imatoŋyajpa jém aŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Pero jesɨc tsa̱m ijɨ̱spa jém iyo̱xacuy, tsa̱m iwɨ̱aŋja̱m jém tumiñ, tsa̱m icusúnɨ́ypat́im jém d́apɨc wɨ̱ yɨ́p naxyucmɨ. Jesɨc jexpɨc jɨ̱xi ixamsamcaaba jém wɨbɨc aŋma̱t́i. Jém pɨ̱xiñ ichacpa jém Dios iŋma̱t́i, d́a wɨ̱putpa, d́a tɨ́ma̱p. ");
INSERT INTO poiNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Pero algunos jém pɨxiñt́am jex juuts jém pac jém actɨŋnewɨɨp jém wɨbɨc naxyucmɨ. Imatoŋyajpa jém Dios iŋma̱t́i, icupɨcyajpa, wɨ̱tɨ́ma̱p. Algunos chióy treinta, algunos chióy sesenta, algunos chióy cien. ");
INSERT INTO poiNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesɨc nɨmt́im Jesús: —Tannooba juctɨ iga tayɨcquejpa. D́a taŋcujappa cooŋcucɨɨm ni d́a tantsacpa tseescucɨɨm. Tantunpa yucmɨ jém juctɨ iga tayɨcquejpa. ");
INSERT INTO poiNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Porque quejpa it́u̱mpɨy jém aŋnécnewɨɨp id́ɨc. It́u̱mpɨy jém yamnɨmnewɨɨp, ocmɨ jo̱dóŋa̱ta̱p. ");
INSERT INTO poiNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Siiga mit́atsɨgɨyt́a, matoŋtaamɨ t́i mannɨ́máypa. ");
INSERT INTO poiNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jesɨc Jesús iñɨ́máyt́im jém icuyujcɨɨwiñ: —Wadaayɨ caso iga iŋwatpa t́i mannɨ́máypa. Siiga tsa̱m impɨctsoŋtooba jém Dios iŋma̱t́i, jesɨc Dios michiiba jáyaŋ jém wɨ̱tampɨc jɨ̱xi. Pero jém pɨ̱xiñ jém d́apɨc ipɨctsoŋtooba, d́a t́i ichiiba Dios. ");
INSERT INTO poiNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Siiga impɨctsoŋne jém wɨbɨc jɨ̱xi, jesɨc miyo̱xpátpa Dios iga más iŋcutɨɨyɨ́yiñ. Pero jém pɨ̱xiñ jém d́apɨc iwɨ̱aŋja̱m jém wɨbɨc jɨ̱xi, jesɨc Dios iccáyáypa e̱ybɨc jém ijɨ̱xi jém uxaŋpɨc iniit́. ");
INSERT INTO poiNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesɨc nɨmt́im Jesús: —Jém wɨbɨc aŋma̱t́i jutsa̱p iŋjac Dios yɨ́p naxyucmɨ jex juuts tu̱m pɨ̱xiñ iñiptsac tu̱m pac ica̱mjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Jesɨc jém pɨ̱xiñ moŋpa y yuspa, tsuucɨɨm y sɨŋñi. Jém pac naypa, mɨja̱p. Pero jém pɨ̱xiñ d́a ijo̱doŋ jutsa̱p iñay ni jutsa̱p imɨja̱. ");
INSERT INTO poiNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Jém nas wɨa̱p icmɨja̱ jém ñipñibooyi, d́a tanyo̱xpátpa. Naypa jém pac, yónpa, mɨja̱p, ocmɨ tsampa. ");
INSERT INTO poiNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Jesɨc cuando tsamum jém it́ɨm, nɨcpa ipiŋ jém io̱mi porque tsamneum. ");
INSERT INTO poiNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesɨc nɨmt́im Jesús: —Sɨɨp manaŋquejáypa ju̱t́pɨc aŋpɨcpa jém wɨbɨc aŋma̱t́i iga Dios iŋjacpa yɨ́p naxyucmɨ. Manaŋquejáypa cuentujmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Jém wɨbɨc aŋma̱t́i jex juuts tu̱m mostaza ipac ñipta̱p naxyucmɨ. Je jém más xut́upɨc pac que it́u̱mpɨy jém pacyaj. ");
INSERT INTO poiNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Jesɨc ñipneum jém pac, yónpa, más mɨja̱p que it́u̱mpɨy jém ñipñibooyiyaj. Iccámpa jém mɨjpɨc iŋcɨs y jém jonyaj nɨcpa i̱t́iyaj jém cuy iŋcɨsyucmɨ, jejyajpa jém icumuŋco̱m. ");
INSERT INTO poiNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Con wa̱t́i jém cuento iŋquejáy Jesús jém pɨxiñt́am jém Dios iŋma̱t́i hasta ju̱t́pɨc wɨa̱iñ icutɨɨyɨyyaj. ");
INSERT INTO poiNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Jesús iŋmadáy cuentujmɨ it́u̱mpɨy jém pɨxiñt́am. Pero cuando icut́um it́ con jém icuyujcɨɨwiñ, jesɨc iŋmadáy jeeyaj t́i nɨmtooba it́u̱mpɨy jém cuentoyaj. ");
INSERT INTO poiNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Jesɨc jeet́im ja̱ma, tsuáŋam, Jesús iñɨ́máy jém icuyujcɨɨwiñ: —Tanɨctámpa jém laguna aŋwiñt́uc. ");
INSERT INTO poiNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Jesɨc Jesús iŋquímyaj jém aŋtuuma̱neyajwɨɨp. Jém icuyujcɨɨwiñ tɨgɨyyaj barcojo̱m con Jesús. Ininɨcyajpa Jesús jém laguna aŋwiñt́uc. Iwagananɨcyajpat́im tuŋgac jém barcoyaj. ");
INSERT INTO poiNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Iganam nɨquiyaj barcojo̱m, moj po̱yi tu̱m sa̱wa tsa̱m pɨ̱mi. Jesɨc pɨ̱mi pooba jém nɨ, tsa̱m pɨ̱mi tɨgɨypa nɨ jém barcojo̱m hasta comtooba. ");
INSERT INTO poiNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Moŋpa Jesús jém barco it́utscɨɨm tu̱m colchonyucmɨ. Jém icuyujcɨɨwiñ ichɨcyusyaj, iñɨ́mayyaj: —Mammaestro, ¿que d́a íñix iga tacumoŋtoobam? ");
INSERT INTO poiNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jesɨc yusum jém Jesús, iñɨ́máy jém sa̱wa iga teeñiñ. Iñɨ́máyt́im jém lamar: —¡Tɨ̱neɨ, odom tsɨgooyɨ! Jesɨc te̱ñum jém sa̱wa y tɨ̱neum jém nɨɨpoa. D́am t́i tsɨgóypa. ");
INSERT INTO poiNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jesɨc Jesús iñɨ́máy jém icuyujcɨɨwiñ: —¿T́iiga tsa̱m micɨ̱ŋtámpa? ¿Que d́a iŋcupɨctámpa iga Dios tawatpa cuenta? ");
INSERT INTO poiNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Tsa̱m pɨ̱mi cɨ̱ŋyaj jém Jesús icuyujcɨɨwiñ. Nanɨ́mayyajta̱p: —¿I̱apaap yɨ́p pɨ̱xiñ iga jém sa̱wa y jém nɨɨpoa icupɨcpa? ");
INSERT INTO poiNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jesɨc ocmɨ Jesús con icuyujcɨɨwiñ núcyaj jém laguna aŋwiñt́uc jém naxyucmɨ de Gadara. ");
INSERT INTO poiNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jesɨc mu iput jém Jesús jém barcojo̱m, ipát tu̱m Gadarapɨc pɨ̱xiñ. Miñ jém pɨ̱xiñ jém camposanto. Imatsne jém mal espíritu. ");
INSERT INTO poiNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Jém pɨ̱xiñ d́a i̱pa tɨgaŋjo̱m, nɨcpa i̱t́i jém camposanto. D́a i̱ wɨa̱p ichen jém pɨ̱xiñ ni con cadena. ");
INSERT INTO poiNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Wa̱t́cɨy tsénayt́a̱ jém pɨ̱xiñ icɨ y ipuy con cadena, pero siempre ijacpa jém cadena. Iccujagáypa jém tɨ́ŋcuy jém iñuusmatsayñewɨɨp ipuy. Tsa̱m pɨ̱mi malo, d́a i̱ wɨa̱p imanxuwat jém pɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tsuucɨɨm y sɨŋñi sɨɨba jém pɨ̱xiñ jém camposanto y jém co̱tsɨcjo̱m. Pɨ̱mi aŋwejpa. Tsa̱m naccoowaneta̱ iyaac tsaamɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Jesɨc cuando jém pɨ̱xiñ juumɨnam iix jém Jesús, póyaŋtsucum, miñ ico̱steeñáy jém Jesús iwiñjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Jesɨc pɨ̱mi jɨypa jém pɨ̱xiñ. Nɨmpa: —MiJesús, ¿t́iiga miñpa ammoogɨ́y? Mich jém Yucmɨpɨc Dios miMa̱nɨc. Maŋcunucsáypa por Dios iga odoy ayaachwa̱tɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Je̱mpɨgam nɨmpa jém pɨ̱xiñ porque Jesús iñɨ́máy jém mal espíritu: —Mimalespíritu, pu̱tɨ jém pɨ̱xiñ ia̱namaŋjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesɨc Jesús icwác jém pɨ̱xiñ, nɨmpa: —¿Mich, mii̱apaap? Jém pɨ̱xiñ icutsoŋ. Nɨ́mayt́a̱ Jesús: —Ɨch aLegión porque tsa̱m ajáyaŋtam. Taɨch tanaŋma̱t́i jém legión nɨmtooba iga agui jáyaŋ. ");
INSERT INTO poiNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Jém mal espíritu icunucsáy Jesús iga odoy icutsad́iñ tuŋgac lugar. ");
INSERT INTO poiNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","It́ id́ɨc je̱m jáyaŋ jém yo̱ya. Wícyajpa nocojo̱m de jém co̱tsɨccɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Jesɨc jém mal espíritu icunucsáypa jém Jesús. Nɨ́mayt́a̱: —Acutsattaamɨ ju̱t́ it́ jém yo̱ya. Ajɨ́gaayɨ iga atɨgɨyt́ámpa jém yo̱ya ia̱namaŋjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jesɨc Jesús ijɨ́gáy iga tɨgɨyyaj jém yo̱ya ia̱namaŋjo̱m. Cuando putyajum jém mal espíritu jém pɨ̱xiñ ia̱namaŋjo̱m, nɨc tɨgɨ̱yiyaj jém yo̱ya ia̱namaŋjo̱m. It́yaj je̱m como dos mil yo̱ya. Mu it́ɨgɨyyaj jém mal espíritu, póyaŋtsucumyaj jém yo̱ya. Poyi̱mɨ quetyaj jém tejajyucmɨ. Tɨgɨyyaj jém nɨɨcɨɨm. Yaj jicjiccaiyaj jém yo̱ya. ");
INSERT INTO poiNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Jesɨc poyyaj jém pɨxiñt́am jém iwatyajpáppɨc cuenta jém yo̱ya. Tsa̱m pɨ̱mi cɨ̱ŋyaj. Nɨc iŋmadayyaj jém pɨxiñt́am t́i iñascayaj jém yo̱ya. Nanɨcta̱ jém aŋma̱t́i icuwɨ̱t́i jém attebet Gadara y hasta ju̱t́ nɨcne yo̱xa̱jiyaj. Jesɨc jém pɨxiñt́am miñ iámyaj t́i iñascayaj jém yo̱ya. ");
INSERT INTO poiNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Núcyaj ju̱t́ it́ jém Jesús. Iixyaj jém pɨ̱xiñ jém imatsnewɨɨp id́ɨc jém mal espíritu tsa̱m jáyaŋ. Jemum co̱ñ, puctugɨ́yum, jɨ̱xiɨ́yum. Cuando iixyaj jém pɨxiñt́am, tsa̱m pɨ̱mi cɨ̱ŋyaj. ");
INSERT INTO poiNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Jesɨc jém pɨxiñt́am, jém iixñeyajwɨɨp t́i iwat Jesús, moj iŋmadayyaj jém miññeyajwɨɨp t́i iñasca jém pɨ̱xiñ jém imatsnewɨɨp id́ɨc jém mal espíritu y t́i iñasca jém yo̱ya. ");
INSERT INTO poiNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Jesɨc jém Gadarapɨc pɨxiñt́am moj iñɨ́mayyaj jém Jesús iga nɨguiñam de je̱m. ");
INSERT INTO poiNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","E̱ybɨct́im tɨgɨy Jesús jém barcojo̱m. Jém pɨ̱xiñ, jém iniit́wɨɨp id́ɨc jém mal espíritu, iñɨ́máy jém Jesús: —Ɨch anɨctoobat́im. Ajɨ́gaayɨ iga awaganɨcpa con mimich. ");
INSERT INTO poiNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pero Jesús d́a ijɨ́gáy iga nɨcpa it́úŋɨ́y jém pɨ̱xiñ. Nɨmpa Jesús: —Nɨcsɨm iñt́ɨcmɨ. Nɨ̱gɨ aŋmadaayɨ jém iñt́ɨ̱wɨtam t́i miwadáy Dios iga tsa̱m miyaachaŋja̱m. ");
INSERT INTO poiNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Jesɨc jém pɨ̱xiñ nɨc jém naxyucmɨ Decápolis. Moj iŋmadáy jém pɨxiñt́am t́i iwadáy Jesús cuando it́obáy jém mal espíritu. Tsa̱m ipooñaŋja̱myaj it́u̱mpɨy de jeeyaj. ");
INSERT INTO poiNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesɨc se̱t e̱ybɨc Jesús jém laguna aŋwiñt́uc jém barcojo̱m. Cuando núc Jesús jém nɨ aŋna̱ca, jesɨc iŋtuuma̱cayaj tsa̱m jáyaŋ jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Jesɨc miñ iám Jesús tu̱m pɨ̱xiñ iñɨ̱yi Jairo, tu̱m sinagoga iŋjagooyi. Cuando núc ju̱t́ it́ Jesús, ico̱steeñáy ipuycɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Jesɨc jém Jairo pɨ̱mi icunucsáypa jém Jesús. Nɨ́mayt́a̱: —Tsa̱m pɨ̱mi mɨmne jém anyo̱mma̱nɨc. Caatoobam. Nɨ̱gɨ accámaayɨ iŋcɨ jém anyo̱mma̱nɨc ico̱bacyucmɨ iga pɨxiñ iga odoy caiñ. ");
INSERT INTO poiNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jesɨc jém Jairo iwagananɨc jém Jesús. Tsa̱m jáyaŋ pɨxiñt́am nɨcyajt́im, it́úŋɨyyaj jém Jesús. Tsa̱m icpɨtsɨyyaj. ");
INSERT INTO poiNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Jém pɨxiñt́ámaŋjo̱m it́t́im tu̱m yo̱mo mɨmne. Doce a̱mt́ɨy iniit́ jém caacuy iga quetpa iñɨɨpiñ. ");
INSERT INTO poiNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Wa̱t́i jém tsóyɨ́yoypaap ichóyɨyt́ɨp, pero tsa̱m iyaachwatne jém yo̱mo. Yajneum iwadáy gasto jém it́umiñ, pero d́a pɨspa. Mást́im pɨ̱mi mɨmne. ");
INSERT INTO poiNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Jém yo̱mo imatoŋne iga tsa̱m wɨa̱p icpɨsóy jém Jesús. Jesɨc iganam tsa̱m icpɨtsɨyyajpa Jesús jém pɨxiñt́am, jém yo̱mo icunúc jém Jesús it́uuñiaŋcɨɨm, ichɨgáy jém Jesús iyoot́i. ");
INSERT INTO poiNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Nɨmpa jém yo̱mo ijɨ̱xiaŋjo̱m: “Siiga antsɨgáypa iyoot́i con aŋcɨ, jesɨc apɨspa.” ");
INSERT INTO poiNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Jesɨc jeet́i rato te̱ñ iga quetpa jém iñɨɨpiñ. Ija̱m jém yo̱mo iga pɨsneum. ");
INSERT INTO poiNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesɨc Jesús icutɨɨyɨ́y iga icpɨs tu̱m mɨmnewɨɨp con ipɨ̱mi, ámse̱t jém pɨxiñt́ámaŋjo̱m, nɨmpa: —¿I̱ atsɨgáy jém anyoot́i? ");
INSERT INTO poiNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Jesɨc jém icuyujcɨɨwiñ iñɨ́máy: —Íñix iga jém pɨxiñt́am tsa̱m pɨ̱mi micpɨtsɨyyajpa. ¿T́iiga micwágóypa iga i̱ michɨc? ");
INSERT INTO poiNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pero Jesús icuámse̱tpa iga iixiñ i̱ ichɨc. ");
INSERT INTO poiNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Jesɨc agui cɨ̱ŋne jém yo̱mo, agui cuetsáypa porque ijo̱doŋ jutsa̱ mu ipɨs. Miñ ico̱steeñáy jém Jesús iwiñjo̱m, iñuumaŋmadáy Jesús t́i iñasca. ");
INSERT INTO poiNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesɨc Jesús iñɨ́máy: —Miyo̱mo, mipɨsneum porque tsa̱m iŋcupɨcpa iga Dios wɨa̱p micpɨs. Sɨɨp michacneum jém caacuy. Chogoyñɨcsɨm. ");
INSERT INTO poiNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Iganam Jesús iniŋmatpa jém yo̱mo, núcyaj algunos jém pɨxiñt́am, miññeyaj jém Jairo it́ɨccɨɨm. Iñɨ́mayyaj jém aŋjagooyi: —Caaneum jém iñyo̱mma̱nɨc. Odom más wadaayɨ molestia yɨ́p tammaestro. ");
INSERT INTO poiNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Pero Jesús d́a iwadáy caso t́i iñɨ́máy jém miññeyajwɨɨp. Iñɨ́máy jém Jairo: —Odoy cɨ̱ŋɨ. Cupɨ̱cɨ iga Dios wɨa̱p miyo̱xpát. ");
INSERT INTO poiNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jesɨc d́a ijɨ́cpa Jesús iga nɨcpa it́úŋɨyyaj jém pɨxiñt́am. Ininɨc no más Peto, Jacobo, y Xiwan jém Jacobo it́ɨ̱wɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Cuando núcyaj jém sinagoga iŋjagooyi it́ɨccɨɨm, iix Jesús iga tsa̱m it́ bulla, tsa̱m wejyajpa, tsa̱m aŋyácneyaj. ");
INSERT INTO poiNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Tɨgɨy tɨcjo̱m jém Jesús, iñɨ́máy jém pɨxiñt́am jém wejyajpáppɨc: —¿T́iiga tsa̱m miwejtámpa? ¿T́iiga tsa̱m iŋwattámpa bulla? D́a caane jém wo̱ñi, moŋpa. ");
INSERT INTO poiNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Pero jeeyaj agui ixíccayajpa jém Jesús. Jesɨc Jesús iquebacputyaj it́u̱mpɨy jém it́yajwɨɨp jém tɨcjo̱m. Jesɨc iwagananɨcpa Jesús jém wo̱ñi ija̱tuŋ con ia̱pa y jém icuyujcɨɨwiñ. Tɨgɨyyaj jém cuarto ju̱t́ it́ jém wo̱ñi. ");
INSERT INTO poiNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jesɨc Jesús imatsáy jém wo̱ñi icɨ, iñɨ́máy jém wo̱ñi: —Talita cumi. Taɨcht́am tanaŋmat́i̱mɨ nɨmtooba: Miwo̱ñi, mannɨ́máypa, tsucu̱mɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Jeet́i rato tsucum jém wo̱ñi. Mojum wi̱t́i. Doce ia̱mt́ɨy iniit́. Jém it́yajwɨɨp tsa̱m pɨ̱mi ipooñaŋja̱myaj mu iixyaj t́i iwat Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesɨc Jesús tsa̱m iwɨ̱aŋquím jeeyaj iga odoy i̱ iŋmadáyiñ iga icpɨs jém wo̱ñi. Iñɨ́máyt́im Jesús iga acwícta̱iñ jém wo̱ñi. ");
INSERT INTO poiNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesɨc put de je̱m jém Jesús, nɨc it́ɨcmɨ. Iwagananɨcyajpat́im jém icuyujcɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Jesɨc cuando núc jém jejcuyja̱ma, moj accuyujooyi Jesús jém sinagoga. It́yaj jáyaŋ pɨxiñt́am. Mu imatoŋyaj t́i iŋmatpa jém Jesús, jesɨc tsa̱m ipooñaŋja̱myajpa. Nɨmyajpa: —¿Ju̱t́ cuyuj yɨ́p pɨ̱xiñ? ¿Ju̱t́ ipɨc yɨ́p wɨbɨc jɨ̱xi? ¿Jutsa̱p iwat con icɨ jém wɨ̱tampɨc milagro? ");
INSERT INTO poiNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿D́a yɨ́p pɨ̱xiñ jém carpintero? Ia̱pa jém Malía. Tánixpɨgáypat́im jém it́ɨ̱wɨtam jém Jacobo, jém José, jém Judas y jém Ximoj. It́yajt́im yɨɨm jém iyo̱mtɨ̱wɨtam con taɨcht́am. Jeeyucmɨ jém pɨxiñt́am ijóyixyajpa jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesɨc Jesús iñɨ́máy jeeyaj: —Ju̱t́quej wɨ̱pɨctsoŋta̱p tu̱m jém profeta, pero cuando nɨcpa najɨ́yooyi it́ɨcmɨ, jesɨc jém it́ɨcmɨpɨc pɨxiñt́am con jém it́ɨ̱wɨtam d́a iwɨ̱ixyajpa. ");
INSERT INTO poiNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Jesɨc jém Jesús d́a wɨa̱p iwat jém milagro it́ɨcmɨ. Ichɨc con icɨ nada más jute̱n jém mɨmneyajwɨɨp iga icpɨsyajpa. ");
INSERT INTO poiNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Agui ipooñaŋja̱mpa Jesús iga jém pɨxiñt́am d́a icupɨcyajpa iga Dios wɨa̱p iwat jém milagroyaj. Jesɨc ocmɨ Jesús icuwit́xe̱tpa it́u̱mpɨy jém xuxut́ tɨgaŋjoj jém it́yajwɨɨp nocojo̱m iga iŋmatpa jém Dios iŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jesɨc Jesús iŋwejáy jém doce icuyujcɨɨwiñ. Icutsat wɨswɨs iga nɨcyajiñ iŋmat jém Dios iŋma̱t́i ju̱t́quej. Chiiyajta̱ jém Dios ipɨ̱mi iga wɨa̱iñ it́opyaj jém mal espíritu jém pɨxiñt́am ia̱namaŋjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Jesɨc Jesús iñɨ́máy jém icuyujcɨɨwiñ iga odoy t́i ininɨcyajiñ tuŋjo̱m. Nɨ́mayyajta̱p: —Nanɨctaamɨ no más jém imbastun. Odoy nanɨctaamɨ ni tumiñ, ni immorral ni t́it́am iŋcútpa. ");
INSERT INTO poiNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Accaamɨ jém iŋcɨac y tu̱m jém iñyoot́i. Odoy nanɨctaamɨ tuŋgac iñyoot́i. ");
INSERT INTO poiNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Cuando miñúctámpa tu̱m tɨccɨɨm, jemum poychɨ́yt́aamɨ hasta miñɨctámpa tuŋgac tɨgaŋjoj. ");
INSERT INTO poiNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Siiga miñúcpa tu̱m tɨgaŋjoj, y d́a i̱ miwɨ̱pɨctsoŋpa, ni d́a i̱ imatoŋtooba jém Dios iŋma̱t́i, jesɨc puttaamɨ aŋsɨ̱cmɨ, cunebayt́aamɨ jém impuy iga cáyiñ jém pótpót. Je̱mpɨgam iniŋquejáypa jém pɨxiñt́am iga núctɨp jém Dios iŋma̱t́i. Nu̱ma mannɨ́máypa iga cuando núcpa jém ja̱ma iga Dios icɨɨpiŋpa it́u̱mpɨy jém malopɨc pɨxiñt́am, jesɨc yɨ́pyaj pɨxiñt́am jém d́apɨc iwɨ̱aŋja̱myaj jém Dios iŋma̱t́i, más chiit́a̱p castigo que jém malopɨc pɨxiñt́am jém it́yajwɨɨp jém attebet de Sodoma y Gomorra. ");
INSERT INTO poiNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jesɨc nɨc najɨ́yooyiyaj jém Jesús icuyujcɨɨwiñ. Iŋquímyajpa jém pɨxiñt́am iga ichacyajiñ iga imalwatpa y iga iwatyajiñ juuts ixunpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Jém Jesús icuyujcɨɨwiñ it́opyajpat́im jáyaŋ jém mal espíritu jém pɨxiñt́am ia̱namaŋjo̱m. Iccámayyaj aceite ico̱bacyucmɨ jáyaŋ jém mɨmneyajwɨɨp. Acpɨsyajta̱. ");
INSERT INTO poiNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jém rey Herodes imatoŋ t́i iwatpa jém Jesús porque waŋpa ju̱t́quej t́i iwat. Ijɨ̱syajpa iga pɨsneum jém Xiwan jém acchíŋoypaap, jeeyucmɨ wɨa̱p iwat jém wɨ̱tampɨc milagro. ");
INSERT INTO poiNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Pero tuŋgac nɨmpa: —Pɨsneum jém wiñɨcpɨc profeta jém Elías. Tuŋgagam nɨmpa: —Yɨ́p pɨ̱xiñ tu̱m jém profeta jex juuts jém wiñɨcpɨc. ");
INSERT INTO poiNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Mu imatoŋ t́i iwat jém Jesús, jesɨc nɨmpa jém Herodes: —Yɨ́p jém Xiwan jém ampɨɨmɨyñewɨɨp iga tɨŋcujagayt́a̱iñ iɨscɨ. Sɨɨp pɨsneum. ");
INSERT INTO poiNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Porque yɨ́pt́im Herodes ipɨɨmɨ́y iga matsta̱iñ jém Xiwan. Pajta̱ cárcel, tsenta̱ con cadena porque iwogáy jém aŋjagooyi cuando it́obáyáy jém it́ɨ̱wɨ Felipe iwɨcho̱mo. Jém yo̱mo iñɨ̱yi Herodías. ");
INSERT INTO poiNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Jém Xiwan iñɨ́máy jém Herodes: —Mich d́a iŋwat juuts nɨmpa jém Dios iŋquímayooyi. D́a wɨ̱ iga impɨgayñe iñt́ɨ̱wɨ iyo̱mo. ");
INSERT INTO poiNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Jeeyucmɨ jém yo̱mo Herodías tsa̱m ijóyixpa jém Xiwan hasta iccaatooba, pero d́a wɨa̱p. ");
INSERT INTO poiNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Porque jém Herodes tsa̱m icɨ̱ŋpa jém Xiwan. Ijo̱doŋ iga wɨbɨc pɨ̱xiñ y siempre iwatpa juuts ixunpa Dios. Jeeyucmɨ jém aŋjagooyi d́a ijɨ́cpa iga i̱ imalwadáypa jém Xiwan. Tsa̱m aŋyácpa jém aŋjagooyi cuando imatoŋ jém Xiwan iŋmadayooyi, pero siempre imatoŋtooba. Pero d́a icupɨcpa. ");
INSERT INTO poiNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Jesɨc núc jém ja̱ma iga jém yo̱mo Herodías ipát jutsa̱p icca jém Xiwan. Núc jém aŋjagooyi Herodes icumpleaño. Iwatpa tu̱m sɨŋ jém Herodes. Iwadáy invitación it́u̱mpɨy jém aŋjagooyiyaj con jém soldado iŋjagooyiyaj y con jém pɨxiñt́am jém iniit́yajwɨɨp jém mɨjtampɨc cargo jém naxyucmɨ de Galilea. ");
INSERT INTO poiNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Tɨgɨy jém yo̱mo Herodías iyo̱mma̱nɨc ju̱t́ iwatyajpa jém sɨŋ. Jém wo̱ñi etspa jém pɨxiñt́ámaŋjo̱m. Jesɨc jém Herodes con jém it́yajwɨɨp je̱m tsa̱m iwɨ̱aŋja̱myaj jém wo̱ñi iga etspa. Jém rey iñɨ́máy jém wo̱ñi: —Awágaayɨ t́it́am iñxunpa y ɨch manchiiba. ");
INSERT INTO poiNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Jesɨc jém Herodes ijɨycámáy jém wo̱ñi iga ichiiba t́it́am ixunpa hasta cucmɨ jém naxyucmɨ ju̱t́ iŋjacpa. ");
INSERT INTO poiNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Jesɨc jém wo̱ñi put jém cuarto ju̱t́ sɨ́ŋa̱yajpa. Nɨc icwác jém ia̱pa. Nɨmpa jém wo̱ñi: —¿T́i aŋwágáypa jém Herodes? Nɨmpa jém wo̱ñi ia̱pa: —Wágaayɨ jém Xiwan ico̱bac jém acchíŋoypaap. ");
INSERT INTO poiNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Jesɨc jicscɨy tɨgɨy e̱ybɨc jém wo̱ñi ju̱t́ it́ jém rey. Nɨmpa jém wo̱ñi: —Ansunpa iga sɨɨpt́i achiaayɨ jém Xiwan ico̱bac jém acchíŋoypaap tu̱m mɨjpɨc chi̱majo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Jesɨc pɨ̱mi aŋyác jém rey, pero como ijɨycámayñeum iga ichiiba t́it́am ixunpa jém wo̱ñi y como it́u̱mpɨy jém iŋwejayñewɨɨp imatoŋyaj, jesɨc d́a t́i wɨa̱p iwat más que ichiiba juuts ijɨycámayñe. ");
INSERT INTO poiNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Jesɨc jeet́i rato jém rey icutsat tu̱m soldado, jém accaoypaap, iga inimíñáyiñ jém Xiwan ico̱bac. ");
INSERT INTO poiNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Jesɨc jém soldado nɨc jém cárcel, it́ɨŋcujagáy jém Xiwan iɨscɨ. Jesɨc inimíñáy jém ico̱bac tu̱m mɨjpɨc chi̱majo̱m. Chiit́a̱ jém wo̱ñi. Jesɨc jém wo̱ñi ipɨctsoŋ, ichi ia̱pa. ");
INSERT INTO poiNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Cuando jém Xiwan icuyujcɨɨwiñ imatoŋ t́i iñasca jém Xiwan, jesɨc oy ipíŋayyaj jém imɨjta̱y, nɨc icúmayyaj tu̱m tsaajosjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jesɨc ocmɨ aŋtuuma̱yaj jém apóstolyaj ju̱t́ it́ Jesús. Iŋmadayyaj Jesús t́it́am iwatyaj y t́it́am iŋquejayyaj jém pɨxiñt́am cuando oy najɨ́yooyi. ");
INSERT INTO poiNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jesɨc Jesús iñɨ́máy jém icuyujcɨɨwiñ: —Miñt́aamɨ mimicht́am, tanɨctámpa tu̱m lugar ju̱t́ d́a i̱ñɨ̱m. Tapoyjejtámpa. Porque tsa̱m aŋtuuma̱yajpa jém pɨxiñt́am, miñpa y nɨcpa hasta d́a i̱ lugar para wícyajpa jém Jesús icuyujcɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Jesɨc Jesús con jém icuyujcɨɨwiñ nɨcyaj tu̱m barcojo̱m. Nɨcyaj naps jeeyaj ju̱t́ d́a i̱ id́ɨ́yɨ́y. ");
INSERT INTO poiNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pero tsa̱m jáyaŋ jém pɨxiñt́am iixyaj iga nɨcyajpa Jesús con icuyujcɨɨwiñ. Iixpɨcyaj Jesús iga nɨqui barcojo̱m. Jesɨc póyaŋtsucumyaj jáyaŋ jém pɨxiñt́am, miñyaj wa̱t́i jém tɨgaŋjoj. Icuwit́xe̱tyajpa jém laguna. Aŋjagóy miñúcyaj antes que núcpa Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Cuando núc Jesús, put jém barcojo̱m, iix iga aŋtuuma̱neyaj tsa̱m jáyaŋ pɨxiñt́am. Tsa̱m iyaachaŋja̱mpa porque jeeyaj jex juuts jém borregoyaj jém d́apɨc oomɨ́y. D́a i̱ iwatpa cuenta. Jesɨc Jesús moj iŋquejáy jáyaŋ wɨ̱tampɨc jɨ̱xi. ");
INSERT INTO poiNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Jesɨc tsuuyɨm, miñyaj jém Jesús icuyujcɨɨwiñ, icunúcyaj jém Jesús. Nɨ́mayt́a̱: —Yɨɨm d́a i̱ tɨgaŋjoj, sɨɨp tsa̱m tsuuyɨm. ");
INSERT INTO poiNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Nɨ́maayɨ jém pɨxiñt́am iga nɨguiñ ijuyyaj t́it́am icútyajpa. Nɨcyajiñ yɨɨm jeexɨc ju̱t́ it́ jém tɨgaŋjoj porque yɨɨm d́a i̱ t́i taŋcútpa. ");
INSERT INTO poiNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Pero Jesús iñɨ́máy jém icuyujcɨɨwiñ: —Mimicht́am acwíctaamɨ. Jesɨc nɨmyajpa jém Jesús icuyujcɨɨwiñ: —¿Que aɨcht́am nɨcpa anjúyayt́a doscientos tumiñ de plata jém caxt́ána̱ñi iga anacwícpa jém pɨxiñt́am? ");
INSERT INTO poiNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesɨc Jesús icwác jém icuyujcɨɨwiñ. Nɨ́mayt́a̱: —¿Jute̱n caxt́ána̱ñi iniit́t́a? Nɨ̱gɨ aamɨ. Cuando ijo̱dóŋa̱yaj, iñɨ́mayyaj: —Anait́t́a cinco caxt́ána̱ñi y wɨste̱n tɨɨpɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jesɨc Jesús iñɨ́máy it́u̱mpɨy jém pɨxiñt́am iga aŋtsayco̱ñyajiñ naxyucmɨ jém múgaŋjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Aŋtsayco̱ñyaj it́u̱mpɨy jém pɨxiñt́am algunos cincuenta algunos cien. ");
INSERT INTO poiNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jesɨc Jesús ipɨc jém cinco caxt́ána̱ñi y jém wɨste̱n tɨɨpɨ. Ámquím sɨŋyucmɨ, moj iŋwejpát Dios. Jesɨc iwenwenjac jém caxt́ána̱ñi. Ichi icuyujcɨɨwiñ iga icwícyajiñ jém pɨxiñt́am. Iwéct́im jém wɨste̱n tɨɨpɨ iga ichiiyajpa it́u̱mpɨy jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","It́u̱mpɨy wícyaj hasta cusyaj. ");
INSERT INTO poiNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ocmɨ jém Jesús icuyujcɨɨwiñ ipiŋyaj doce nacooŋ jém caxt́ána̱ñi y jém tɨɨpɨ jém cutsɨ́ywɨ́ppɨc. ");
INSERT INTO poiNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Jém icútneyajwɨɨp jém caxt́ána̱ñi cinco mil jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jesɨc yajum wiiquiyaj, jeet́i rato Jesús iñɨ́máy icuyujcɨɨwiñ: —Sɨɨp tɨgɨyt́aamɨ barcojo̱m, nɨcstaamɨ jém Betsaida jém laguna aŋwiñt́uc. Jemɨgam manactsɨ́ypa. Sɨɨp apoychɨ́ypa yɨɨm iga anaŋquímpa jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Jesɨc yajum iŋquímyaj jém pɨxiñt́am, nɨc Jesús tu̱m co̱tsɨcyucmɨ iga iŋwejpátpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Jesɨc piicha̱wum, jém barco cucmɨm nɨqui jém laguna. Icut́um tsɨ́y Jesús jém naxyucmɨ ju̱t́ tsucumyaj. ");
INSERT INTO poiNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jesús iix iga sopsneyajum jém icuyujcɨɨwiñ iga icwit́yajpa jém barco con jém remos. Porque poypa jém sa̱wa, tsa̱m ictsɨ́ypa jém barco, táŋcaa̱p iñɨc. Jesɨc cuque̱jacɨɨm núc Jesús ju̱t́ nɨquiyaj jeeyaj. Wit́pa iñɨc Jesús jém nɨɨwiñpacyucmɨ, iñascatooba id́ɨc jém barco. ");
INSERT INTO poiNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Pero cuando jém icuyujcɨɨwiñ iixyajpa iga wit́pa nɨɨwiñpacyucmɨ, ijɨ̱syajpa iga iixyaj tu̱m po̱ñ. Tsa̱m aŋwejyajpa porque cɨ̱ŋneyaj. ");
INSERT INTO poiNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","It́u̱mpɨy jém icuyujcɨɨwiñ iixyaj. Tsa̱m pɨ̱mi cɨ̱ŋyaj. Pero jeet́i rato ijɨ́yáypa Jesús, iñɨ́máy: —¡Camamwattaamɨ íña̱nama! ¡Aɨcham! ¡Odoy cɨ̱ŋtaamɨ! ");
INSERT INTO poiNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Jesɨc tɨgɨy barcojo̱m jém Jesús con jeeyaj. Teeñaŋjac jém sa̱wa. Mu iixyaj jém icuyujcɨɨwiñ, tsa̱m pɨ̱mi tɨ̱neaŋjacyaj, agui ipooñaŋja̱myajpa. ");
INSERT INTO poiNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Porque d́anam icutɨɨyɨyñeyaj jém milagro iga icjáyaŋa̱ jém caxt́ána̱ñi. Tsa̱m camam ia̱nama, d́anam icupɨcneyaj. ");
INSERT INTO poiNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Mu ijacyaj jém laguna aŋwiñt́uc, núcyaj jém naxyucmɨ Genesaret. Ichenyaj ibarco jém playa aŋna̱ca. ");
INSERT INTO poiNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Jesɨc putyaj jém barcojo̱m Jesús con icuyujcɨɨwiñ, jém Genesaretpɨc pɨxiñt́am iixpɨcyajpa jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Jesɨc jém pɨxiñt́am nɨcyaj poyi̱mɨ yɨɨm jeexɨc. Moj inimiñyaj tseesyucmɨ jém mɨmneyajwɨɨp hasta ju̱t́ it́ Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ju̱t́quej nɨcpa Jesús jém xut́upɨc tɨgaŋjoj o jém mɨjpɨc attebetyaj, jém pɨxiñt́am inimiñyajpa jém mɨmneyajwɨɨp. Ichacyajpa jém calle aŋna̱ca ju̱t́ naspa Jesús. Cuando núc Jesús, jesɨc jém pɨxiñt́am icunucsáypa iga icpɨsyajiñ jém mɨmneyajwɨɨp. Nɨmyajpa: —Jɨ́gaayɨ nada más iga michɨgayyajpa jém iñyoot́i jém mɨmneyajwɨɨp. Porque siiga ichɨgáypa iyoot́i iŋna̱ca, pɨsyajpa it́u̱mpɨy jém mɨmneyajwɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ocmɨ aŋtuuma̱yaj ju̱t́ it́ Jesús algunos jém fariseoyaj con algunos jém escribaspɨc maestroyaj. Miñyaj Jerusalén. ");
INSERT INTO poiNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Iixyaj iga jém Jesús icuyujcɨɨwiñ d́a icheeyajpa icɨ juuts jém Israelpɨc pɨxiñt́am icostumbre antes que wícpa. Ijɨ̱syaj siiga d́a iwatyajpa jém costumbre jém Jesús icuyujcɨɨwiñ, ictáŋcawatpa. ");
INSERT INTO poiNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Porque jém fariseoyaj y it́u̱mpɨy jém Israelpɨc pɨxiñt́am d́a wícyajpa siiga d́a wat́cɨy icheeba icɨ juuts nɨm jém wiñɨcpɨc costumbre, jém ichacnewɨɨp jém wiñɨcpɨc wɨd́ayt́am. ");
INSERT INTO poiNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Cuando se̱t de jém mercado, d́a t́i icɨɨspa hasta que icheeba icɨ juuts nɨmpa jém wiñɨcpɨc costumbre. Iniit́yaj jáyaŋ costumbre ju̱t́pɨc icheeyajpa it́aza, jém majcuy y jém tɨ́ŋcuyxuuŋ y ju̱t́pɨc icheeba jém ichees. ");
INSERT INTO poiNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Jesɨc jém fariseoyaj con jém escribaspɨc maestroyaj icwácyajpa jém Jesús. Nɨ́mayt́a̱: —¿T́iiga jém iŋcuyujcɨɨwiñ d́a iwatyajpa juuts nɨmpa jém costumbre jém ichacnewɨɨp jém wiñɨcpɨc pɨxiñt́am? D́a icheeyajpa icɨ antes que wícyajpa juuts nɨmpa jém costumbre. ");
INSERT INTO poiNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesɨc Jesús iñɨ́máy jeeyaj: —D́a mɨgóypa jém wiñɨcpɨc Dios iŋmat́cɨɨwiñ jém Isaías cuando miŋmadayt́a. Quejpa iga minimɨgóyayt́a̱p iñyaac juuts nɨm jém Isaías. Ijaychacne yɨɨmpɨc: Nɨmpa Dios: Yɨ́pyaj pɨxiñt́am acujípyajpa con ijɨp. Pero ia̱namaŋjo̱m d́a acupɨcneyaj. ");
INSERT INTO poiNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Xajat́im ajɨ̱syajpa. Iŋquejayyajpa jém pɨxiñt́am ijɨ̱xquiimi juuts wɨbɨc aŋquímayooyi. ");
INSERT INTO poiNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Jesɨc Jesús iñɨ́máyt́im jém pɨxiñt́am: —Micht́am iñchacneta jém Dios iŋquímayooyi. Iŋwattámpa sɨɨp juuts jém pɨxiñt́am icostumbre iga iñcheeba immajcuy, jém imvaso, y tuŋgac más jáyaŋ jexpɨc cosa. ");
INSERT INTO poiNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jeeyucmɨ mimicht́am tsa̱m iñchactámpa jém Dios iŋma̱t́i. Iŋwɨ̱aŋja̱mta iga iŋwattámpa jém wiñɨcpɨc costumbre. ");
INSERT INTO poiNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Nɨmpa jém Moisés iŋquímayooyi: “Wɨ̱ixt́aamɨ jém iñja̱tuŋ y íña̱pa. Siiga i̱ imalnɨ́máypa jém ija̱tuŋ o ia̱pa, jesɨc wɨ̱ iga accaata̱iñ jexpɨc pɨ̱xiñ.” ");
INSERT INTO poiNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pero mimicht́am iniit́t́a tu̱m d́a wɨbɨc costumbre. Miñɨmtámpa siiga i̱ iñɨ́máypa ija̱tuŋ o ia̱pa iga: “D́a wɨa̱p manyo̱xpát porque it́u̱mpɨy jém anait́wɨɨp, jém manchiipáppɨc id́ɨc, tsɨ́y juuts Corbán.” (Taɨcht́am tanaŋmat́i̱mɨ nɨmtooba iga ijɨycámáypa Dios iga ichiiba.) ");
INSERT INTO poiNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Siiga iwatpa así tu̱m pɨ̱xiñ, jesɨc miñɨmtámpa iga d́a malo jém pɨ̱xiñ iga d́a iyo̱xpátpa jém ija̱tuŋ o ia̱pa. ");
INSERT INTO poiNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Je̱mpɨgam inictogoyt́ámpa jém Dios iŋquímayooyi porque mich iŋwattámpa jexpɨc costumbre, jém ichacnewɨɨp jém pɨxiñt́am dende wiñɨgam. Tsa̱m jáyaŋ jexpɨct́im cosa iŋwattámpa. ");
INSERT INTO poiNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jesɨc e̱ybɨc iŋwejáy Jesús it́u̱mpɨy jém pɨxiñt́am. Iñɨ́máypa: —Amatoŋtaamɨ iñt́u̱mpɨyt́am. Cutɨɨyɨyt́aamɨ t́it́am mannɨ́mayt́ámpa. ");
INSERT INTO poiNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","T́it́am iŋcútpa, jém tɨgɨypaap iñjɨpjo̱m, d́a mictáŋcaɨ́ypa. Pero jém malopɨc jɨ̱xi, jém putpáppɨc íña̱namaŋjo̱m, je nu̱ma mictáŋcaɨ́ypa. ");
INSERT INTO poiNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Siiga mit́atsɨgɨyt́a, amatoŋtaamɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jesɨc cuando yaj iŋquímyaj jém pɨxiñt́am, tɨgɨy Jesús jém tɨcjo̱m. Jém icuyujcɨɨwiñ moj icwácyaj t́i nɨmtooba jém aŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jesɨc Jesús iñɨ́máy jém icuyujcɨɨwiñ: —¿Que mimicht́am d́at́im iŋcutɨɨyɨyt́ámpa? Que d́a iñjo̱doŋ iga jém tɨgɨypáppɨc tu̱m pɨ̱xiñ ijɨpjo̱m d́a ictáŋcaɨ́ypa. ");
INSERT INTO poiNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Jém icútpáppɨc tu̱m pɨ̱xiñ d́a tɨgɨypa ia̱namaŋjo̱m porque it́u̱mpɨy naspa ipuujo̱m y ocmɨ putpa. Cuando nɨmpa yɨɨmpɨc, nɨmtooba Jesús iga it́u̱mpɨy wíccuy wɨ̱ taŋcút, d́a tactáŋcaɨ́ypa. ");
INSERT INTO poiNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Nɨmt́im Jesús: —Jém malopɨc jɨ̱xi jém tsucumpáppɨc jém pɨ̱xiñ ia̱namaŋjo̱m je nu̱ma ictáŋcaɨ́ypa. ");
INSERT INTO poiNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Porque jém pɨ̱xiñ ia̱namaŋjo̱m tsucumpa it́u̱mpɨy jém malopɨc jɨ̱xi. Jemum tsucumpa jém jɨ̱xi iga ichɨcpa jém yo̱mtam, iga pejóypa, iga accaóypa, ");
INSERT INTO poiNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","iga númpa, iga icusúnɨ́yáypa tuŋgac pɨ̱xiñ imɨɨchi, iga imalwadáypa tuŋgac pɨ̱xiñ, iga icumɨgóypa it́ɨ̱wɨtam, iga tsa̱m icusúnɨ́ypa jáyaŋ malopɨc cosa, iga cujóyɨ́yóypa, iga icujɨypa it́ɨ̱wɨtam, iga d́a jɨ̱xiɨ́y, iga agui nacujípta̱p iyaac jém pɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","It́u̱mpɨy yɨ́pyaj malopɨc jɨ̱xi tsucum jém pɨ̱xiñ ia̱namaŋjo̱m. Yɨ́p malopɨc jɨ̱xi ictáŋcaɨ́ypa jém pɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesɨc nɨc Jesús jém naxyucmɨ nocojo̱m de jém Tiro y Sidón. Jemɨgam tɨgɨy Jesús tu̱m tɨcjo̱m iga odoy i̱ iixiñ. Pero d́a wɨa̱ miiyam porque ixt́a̱. ");
INSERT INTO poiNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Tu̱m yo̱mo mu imatoŋ iga núc jém Jesús, jicscɨy miñ, ico̱steeñáy jém Jesús ipuycɨɨm. Miñ iám porque jém iyo̱mma̱nɨc imatsne tu̱m mal espíritu. ");
INSERT INTO poiNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Tu̱m griegopɨc yo̱mo, d́a je de Israel. Tsucum jém naxyucmɨ Sirofenicia. Jesɨc jém yo̱mo icunucsáy Jesús iga it́obáyiñ jém mal espíritu jém iyo̱mma̱nɨc ia̱namaŋjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Pero Jesús iñɨ́máy jém yo̱mo: —Wɨ̱ iga wiñt́i cuspa wiiquiyaj jém tsɨ̱xt́am. D́a wɨ̱ iga tantobáyáypa jém tsɨ̱xt́am icaxt́ána̱ñi iga tanchiiba chimpa. ");
INSERT INTO poiNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Jesɨc jém yo̱mo icutsoŋ, iñɨ́máy jém Jesús: —Nu̱ma, mánO̱mi, pero jém chimpa icútyajpa jém ipaccanewɨɨp jém tsɨ̱xt́am mesacucɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesɨc Jesús iñɨ́máy jém yo̱mo: —Nu̱ma miwɨ̱nɨm. Sɨɨp nɨcsɨm iñt́ɨccɨɨm. Jém iñyo̱mma̱nɨc ichacum jém mal espíritu. ");
INSERT INTO poiNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Jesɨc cuando se̱tum it́ɨccɨɨm jém yo̱mo, ipát iyo̱mma̱nɨc wo̱ne icheesmɨ. Ichacneum jém mal espíritu. ");
INSERT INTO poiNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesɨc jém Jesús mojgacum se̱t́i, put jém naxyucmɨ de Tiro, nas jém Sidón, nast́im jém naxyucmɨ iñɨ̱yi Decápolis, e̱ybɨc núc jém laguna de Galilea. ");
INSERT INTO poiNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Jesɨc namíñayt́a̱ Jesús tu̱m chajca iga icpɨxiñ. D́at́im ja̱ya wɨa̱p ijɨy. Cunucsayt́a̱ iga iccámiñ icɨ jém chajca ico̱bacyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesɨc Jesús ininɨc jém pɨ̱xiñ tu̱m áŋe̱ymɨ. Icodáy iwaycɨ jém pɨ̱xiñ it́a̱tsɨcjo̱m. Ocmɨ ichujca Jesús iwaycɨ, ichɨgáy jém pɨ̱xiñ it́ots. ");
INSERT INTO poiNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Jesɨc ámquím Jesús sɨŋyucmɨ, jejquet, iñɨ́máy jém chajca: —Efata. Yɨ́p aŋma̱t́i nɨmtooba: Áŋaayɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Jesɨc áŋáyum jém chajca it́a̱tsɨc. Matóŋóypam. Wɨ̱tsɨ́yñeum jém it́ots. Wɨa̱bam ijɨy parejo. ");
INSERT INTO poiNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesɨc iŋquím Jesús jém pɨxiñt́am iga odoy aŋmad́iñ iga icpɨs jém chajca. Pero aunque tsa̱m pɨ̱mi iŋquímpa Jesús, mást́im aŋmatyajpa jém pɨxiñt́am iga Jesús icpɨs jém chajca. ");
INSERT INTO poiNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Tsa̱m pɨ̱mi ipooñaŋja̱myajpa. Nɨmyaj: —Yɨ́p pɨ̱xiñ tsa̱m iwɨ̱watpa. Icmatóŋóypa jém chajca, icjɨypa jém u̱ma. ");
INSERT INTO poiNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Jesɨc jeet́im tiempo aŋtuuma̱yaj tsa̱m jáyaŋ jém pɨxiñt́am. D́a inii̱yaj jém iwíccuy. Jesɨc Jesús iŋwejáy jém icuyujcɨɨwiñ. Iñɨ́máy: ");
INSERT INTO poiNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Tsa̱m aŋyaachaŋja̱mpa jém pɨxiñt́am jém aŋtuuma̱neyajwɨɨp yɨɨm. Taŋwaganait́ tucunaja̱ma y sɨɨp d́a t́i inii̱yaj iga icútpa. ");
INSERT INTO poiNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Siiga aŋcutsatpa it́ɨcmɨyaj sin wiiqui, jesɨc cupóna̱quetyajpa tuŋjo̱m porque algunos miññeyaj tsa̱m juumɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Jesɨc jém Jesús icuyujcɨɨwiñ icutsoŋ, nɨmyaj: —Yɨɨm ju̱t́ tait́ d́a t́i id́ɨ́yɨ́y. ¿Jutsa̱p tampát wíccuy iga tanacwícpa it́u̱mpɨy yɨ́pyaj pɨxiñt́am? ");
INSERT INTO poiNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesɨc Jesús icwác jém icuyujcɨɨwiñ. Nɨ́mayt́a̱: —¿Jute̱n caxt́ána̱ñi iniit́t́a? Nɨmyajpa jém icuyujcɨɨwiñ: —Siete. ");
INSERT INTO poiNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jesɨc Jesús iñɨ́máy jém aŋtuuma̱neyajwɨɨp iga co̱ñyajiñ naxyucmɨ. Jesɨc ipɨc jém siete caxt́ána̱ñi, iŋwejpát Dios, moj iwenwenjac jém caxt́ána̱ñi. Jesɨc ichi jém icuyujcɨɨwiñ iga icwícyajiñ jém pɨxiñt́am. Je̱mpɨgam iwatyaj. ");
INSERT INTO poiNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Iniit́yajt́im jute̱n xuxut́ tɨɨpɨ. Jesɨc Jesús e̱ybɨct́im iŋwejpát Dios. Ipɨɨmɨ́y jém icuyujcɨɨwiñ iga ichiiyajiñt́im jém tɨɨpɨ jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Jesɨc wícyaj hasta cusyaj. Ocmɨ jém Jesús icuyujcɨɨwiñ ipiŋyaj jém wíccuy jém cutsɨ́ywɨɨp. Icucomyaj siete nacooŋ. ");
INSERT INTO poiNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","It́yaj je̱m como cuatro mil pɨxiñt́am. Cuando yajum wiiquiyaj, jesɨc Jesús iŋquím jeeyaj. ");
INSERT INTO poiNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Jeet́i rato tɨgɨy Jesús tu̱m barcojo̱m con icuyujcɨɨwiñ. Nɨcyaj jém naxyucmɨ Dalmanuta. ");
INSERT INTO poiNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Miñyaj jém maestroyaj de jém fariseopɨc aŋquímayooyi. Moj icwácyaj Jesús. Miñ icutɨ́tsyaj. Nɨmyajpa iga: “Aŋquejaayɨ tu̱m sɨŋyucmɨpɨc seña.” ");
INSERT INTO poiNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesɨc agui aŋyácne Jesús. Pɨ̱mi jejquet. Nɨmpa: —¿T́iiga yɨ́pyaj pɨxiñt́am awágáypa tu̱m seña? Nu̱ma mannɨ́máypa iga Dios d́a ichiiba ni tu̱m seña. ");
INSERT INTO poiNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Jesɨc Jesús ichac jém pɨxiñt́am, e̱ybɨc quím tu̱m barcojo̱m. Nɨc jém laguna aŋwiñt́uc. ");
INSERT INTO poiNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jesɨc jém Jesús icuyujcɨɨwiñ ijaamaŋnotyaj iga ininɨcyajpa jém caxt́ána̱ñi. No más t́u̱m caxt́ána̱ñi iniit́yaj barcojo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesɨc Jesús ipɨɨmɨ́y jém icuyujcɨɨwiñ: —Cuidado. Nawattamta̱jɨ cuenta iga odoy impɨguiñ jém fariseoyaj ilevadura o jém Herodes ilevadura. ");
INSERT INTO poiNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Jesɨc moj nanɨ́mayyajta̱ji entre jeeyaj: —Tanɨ́máy je̱mpɨc porque d́a tanamiñ jém caxt́ána̱ñi. ");
INSERT INTO poiNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesɨc Jesús icutɨɨyɨ́y t́i sɨ́p ijɨ̱syaj, iñɨ́máy: —¿T́iiga miñɨmtámpa iga d́a inii̱t́a jém caxt́ána̱ñi? ¿Que d́a iŋcutɨɨyɨyt́a? ¿Que d́a mijɨ̱xiɨyt́a? ¿Que tsa̱m malot́im íña̱nama? ");
INSERT INTO poiNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Miixcuyɨyt́a, ¿que d́a miixixoyt́ámpa? Mit́atsɨgɨyt́a, ¿que d́a mimatóŋoyt́ámpa? ¿Que d́a iñjɨ̱stámpa cuando ");
INSERT INTO poiNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","mu aŋwéc jém cinco caxt́ána̱ñi con jém cinco mil pɨxiñt́am? ¿Ju̱na cooŋ impiŋta jém cutsɨ́ywɨ́ppɨc? Jesɨc jém icuyujcɨɨwiñ icutsoŋyaj. Nɨmyaj: —Doce. ");
INSERT INTO poiNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Jesɨc nɨmt́im Jesús: —Cuando mu aŋwéc jém siete caxt́ána̱ñi con jém cuatro mil pɨxiñt́am, ¿jesɨc ju̱na cooŋ impiŋta jém cutsɨ́ywɨ́ppɨc? Jesɨc nɨmyaj icuyujcɨɨwiñ: —Siete. ");
INSERT INTO poiNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jesɨc Jesús iñɨ́máy jém icuyujcɨɨwiñ: —¿Que mimicht́am d́anam iŋcutɨɨyɨyñeta? ");
INSERT INTO poiNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ocmɨ nɨcyaj Jesús con icuyujcɨɨwiñ jém attebet Betsaida. Mu iñúcyaj je̱m, algunos inimíñayyaj jém Jesús tu̱m cácht́i. Icunucsayyaj jém Jesús iga ichɨguiñ jém cácht́i. ");
INSERT INTO poiNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesɨc Jesús imatsáy jém cácht́i icɨ, ijɨ̱cte̱ñ aŋsɨ̱cmɨ de jém tɨgaŋjoj. Jesɨc Jesús iccámáy uxaŋ ichuyñɨ jém pɨ̱xiñ iixcuyyucmɨ. Iccámáy icɨ jém pɨ̱xiñ ico̱bacyucmɨ. Jesɨc icwác jém cácht́i. Nɨ́mayt́a̱: —¿Sɨɨp miixixóypam? ");
INSERT INTO poiNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Jesɨc jém cácht́i ámquím. Iñɨ́máy jém Jesús: —Ánixpa jém pɨxiñt́am quénam cuyyaj, pero wit́yajpa. ");
INSERT INTO poiNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesɨc Jesús e̱ybɨct́im iccámáypa icɨ jém pɨ̱xiñ iixcuyyucmɨ, ipɨɨmɨ́y iga ichɨ́d́iñ iixcuy. Jesɨc wɨ̱tsɨ́yum jém iixcuy, wɨ̱ ixixóypam. ");
INSERT INTO poiNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesɨc Jesús iñɨ́máy jém cácht́ipɨc id́ɨc: —Sɨɨp nɨcsɨm iñt́ɨcmɨ. Odoy na̱sɨ yɨ́p tɨgaŋjoj. Odoy i̱ aŋmadaayɨ iga manacpɨs. ");
INSERT INTO poiNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesɨc nɨcyaj Jesús con icuyujcɨɨwiñ jém tɨgaŋjojyaj jém it́yajwɨɨp nocojo̱m jém attebet Cesarea de Filipo. Iganam nɨcyajpa tuŋjo̱m, jém Jesús icwácpa jém icuyujcɨɨwiñ. Nɨmpa: —Anɨ́maayɨ junɨmyajpa jém pɨxiñt́am iga ai̱apaap aɨch. ");
INSERT INTO poiNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Jesɨc icutsoŋyaj jém icuyujcɨɨwiñ. Nɨmyajpa: —Algunos nɨmpa iga mich miXiwan jém acchíŋoypaap. Tuŋgac nɨmpa iga mich miElías. Tuŋgac nɨmpa iga mich tu̱m wiñɨcpɨc miprofeta. ");
INSERT INTO poiNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jesɨc Jesús icwác jém icuyujcɨɨwiñ. Nɨ́mayyajta̱p: —¿Mimicht́am, mijunɨmtámpa iga ai̱apaap? Jesɨc jém Peto icutsoŋ. Iñɨ́máy: —Mich miCristo. ");
INSERT INTO poiNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jesɨc Jesús ipɨɨmɨ́y jém icuyujcɨɨwiñ iga odoy i̱ iŋmadayyajiñ iga je jém Cristo. ");
INSERT INTO poiNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jesɨc moj iŋquejáy Jesús jém icuyujcɨɨwiñ iga jém Miññewɨɨp Sɨŋyucmɨ tsa̱m pɨ̱mi yaachwatta̱p. Tsa̱m ijóyixyajpa jém wɨd́ayt́am, jém co̱bacpɨc pa̱nijyaj y jém escribaspɨc maestroyaj. Ocmɨ accaata̱p, pero jém tucunaja̱ma Dios icpɨspa. ");
INSERT INTO poiNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Iñuntawɨ̱aŋmadáy Jesús jém icuyujcɨɨwiñ. Pero jém Peto d́a iwɨ̱aŋja̱m, iŋwejput Jesús, moj iwogáy. ");
INSERT INTO poiNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesɨc jém Jesús iámseedáy jém icuyujcɨɨwiñ, iwogáy jém Peto. Nɨmpa: —MiPeto, acupóyaayɨ miWoccɨɨwiñ. Mich d́a inii̱ jém Dios ijɨ̱xi iñjɨ̱xiaŋjo̱m. Iniit́ jém pɨxiñt́am ijɨ̱xi. ");
INSERT INTO poiNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jesɨc Jesús iŋwejáy jém icuyujcɨɨwiñ con it́u̱mpɨy jém aŋtuuma̱neyajwɨɨp je̱m. Moj iŋquejáy. Nɨ́mayyajta̱: —Siiga i̱ atúŋɨyt́ooba, tsa̱cɨ iga iŋwatpa juuts iñxunpa iñyaac, yaachɨɨyɨ cuando miyaachwatta̱p ɨch aŋcuyucmɨ, jesɨc atúŋɨɨyɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Siiga tu̱m pɨ̱xiñ tsa̱m it́oypa ivida iga it́pa yɨ́p naxyucmɨ, jesɨc togoypa jém ivida. Pero siiga accaata̱p tu̱m pɨ̱xiñ ɨch aŋcuyucmɨ iga iwatpa juuts nɨmpa ɨch anaŋma̱t́i, jesɨc jém pɨ̱xiñ d́a togoypa ivida, it́pa para siempre. ");
INSERT INTO poiNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","D́a t́i cuwatcuy tu̱m pɨ̱xiñ siiga iniit́ it́u̱mpɨy jém wɨbɨc cosa jém it́wɨɨp yɨ́p naxyucmɨ y togoypa ia̱nama. ");
INSERT INTO poiNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Con jutsaŋ tumiñ wɨa̱p iyoj tu̱m pɨxiñ iga ipɨctsoŋpa e̱ybɨc jém ia̱nama cuando caaneum? ");
INSERT INTO poiNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Siiga michaa̱p iga iniŋmatpa ɨch anaŋma̱t́i y siiga mich antsaaixpa, jesɨc ɨchgact́i, jém aMiññewɨɨp Sɨŋyucmɨ, mantsaaixpat́im cuando amiñgacpa yɨ́p naxyucmɨ con anJa̱tuŋ Dios ipɨ̱mi y con jém sɨŋyucmɨpɨc pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesɨc nɨmt́im Jesús: —Nu̱ma mannɨ́máypa iga algunos de mimicht́am miit́t́aŋwɨɨp yɨɨm, d́a micaaba hasta que íñixt́ámpa iga núcpa jém tiempo cuando Dios iŋjacpa jém pɨxiñt́am con ipɨ̱mi. ");
INSERT INTO poiNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Jesɨc cuando nasum seis día, Jesús ininɨc jém Peto, Jacobo, y Xiwan tu̱m mɨjpɨc co̱tsɨcyucmɨ. Icut́um nɨcyaj. Jemum iixyaj iga aŋcac jém Jesús iámooyi. ");
INSERT INTO poiNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Agui tsocpa ipuctu̱cu. Tsa̱m pɨ̱mi po̱po juuts nieve. Icuwɨ̱t́i yɨ́p naxyucmɨ d́a i̱ wɨa̱p iche jém puctu̱cu jutspɨy ipo̱po jém Jesús ipuctu̱cu. ");
INSERT INTO poiNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Jesɨc jém Jesús icuyujcɨɨwiñ iixyaj iga wiñquej wɨste̱n jém wiñɨcpɨc Dios iŋmat́cɨɨwiñ jém Elías y jém Moisés. Sɨ́p iŋmatyaj con Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Jesɨc jém Peto iñɨ́máy jém Jesús: —Mammaestro, agui wɨ̱ iga tait́t́ámpa yɨɨm. Sɨɨp maŋwadayt́ámpa tucute̱n nacxt́ɨc. Tu̱m para mimich, tu̱m para Moisés y tu̱m para Elías. ");
INSERT INTO poiNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Je̱mpɨc nɨmpa jém Peto porque d́a icutɨɨyɨ́ypa t́i nɨmpa porque tsa̱m pɨ̱mi cɨ̱ŋneyaj jém Jesús icuyujcɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Jesɨc actɨŋ tu̱m ucsɨ. Iŋmontogoyyaj jém ucsɨ. Jesɨc imatoŋyaj tu̱m jɨ̱yi jém ucsaŋjo̱m. Nɨ́mayyajta̱: —Yɨ́bam ɨch amma̱nɨc, tsa̱m antoypa. Matoŋtaamɨ t́i miñɨ́máypa. ");
INSERT INTO poiNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Jesɨc jeet́i rato ámámóypa ju̱t́quej jém icuyujcɨɨwiñ. D́a iixyaj ni tu̱m pɨ̱xiñ. Icut́um it́ jém Jesús con jeeyaj. ");
INSERT INTO poiNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Iganam quetyajpa jém co̱tsɨcyucmɨ, Jesús iŋquímpa jém icuyujcɨɨwiñ iga odoy i̱ iŋmadáyiñ t́i iixyaj jém co̱tsɨcyucmɨ hasta que jém Miññewɨɨp Sɨŋyucmɨ pɨspa de ju̱t́ it́ jém caaneyajwɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Jesɨc d́a iŋmatyajpa jém Jesús icuyujcɨɨwiñ t́i iixyaj, pero nacwácyajta̱p entre jeeyaj t́i nɨmtooba Jesús cuando nɨmpa iga pɨspa de ju̱t́ it́ jém caaneyajwɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Jesɨc acwácta̱ jém Jesús, nɨ́mayt́a̱p: —¿T́iiga nɨmyajpa jém escribaspɨc maestroyaj iga wiñt́i miñpa jém Elías? ");
INSERT INTO poiNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesɨc Jesús icutsoŋ, iñɨ́máy: —Nu̱ma, wiñt́i miñpa jém Elías iga iwɨ̱tsacpa it́u̱mpɨy cosa. Nɨmt́im jém Dios iŋma̱t́i, jém jayñewɨɨp, iga tsa̱m yaachwatta̱p, tsa̱m jóyixt́a̱p jém Miññewɨɨp Sɨŋyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Sɨɨp mannɨ́máypa iga núcneum jém Elías y jém pɨxiñt́am tsa̱m imalwadayyaj juuts ixunyajpa jeeyaj. Iñasca jém Elías juuts nɨmpa jém Dios iŋma̱t́i jém jayñewɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jesɨc se̱tyaj ju̱t́ it́ los de más jém Jesús icuyujcɨɨwiñ. Iixyaj iga tsa̱m jáyaŋ pɨxiñt́am iŋtuuma̱cayajpa jeeyaj. Jém escribaspɨc maestroyaj áŋa̱yajpa con icuyujcɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Jesɨc jém pɨxiñt́am, mu iixyaj iga miñpa Jesús, tsa̱m ipooñaŋja̱myajpa. Jeet́i rato it́u̱mpɨy de jeeyaj póyaŋtsucumyaj, nɨc ichoŋyaj. ");
INSERT INTO poiNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesɨc Jesús icwácpa jém icuyujcɨɨwiñ. Nɨ́mayyajta̱: —¿T́i sɨ́p iniŋa̱cata con jém escribaspɨc maestroyaj? ");
INSERT INTO poiNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Jesɨc tu̱m pɨ̱xiñ, jém it́wɨɨp je̱m, iñɨ́máy jém Jesús: —Maestro, mannamíñáy jém anja̱yma̱nɨc. Iniit́ tu̱m mal espíritu. Iu̱mawatne. ");
INSERT INTO poiNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Cuando pɨ̱mi imatspa jém mal espíritu iccutɨŋpa naxyucmɨ. Aŋxacamoypa ijɨp, iñichpa it́ɨts. Jeeyucmɨ tsa̱m flaco jém amma̱nɨc. Annɨ́máy jém iŋcuyujcɨɨwiñ iga it́obáyiñ jém mal espíritu, pero jeeyaj d́a wɨa̱ mit́obayyaj. ");
INSERT INTO poiNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesɨc Jesús iñɨ́máy jém pɨxiñt́am: —A que mimicht́am hasta sɨɨp d́a iŋcupɨctámpa Dios. Jáyum tawagai̱t́i con mimicht́am, pero d́at́im iŋcupɨctámpa. Tsa̱m anyaachɨ́yum iga manaŋquejáypa jém Dios iŋma̱t́i, pero d́at́im iŋcutɨɨyɨyt́ámpa. Anamíñaayɨ jém tsɨ̱xi. ");
INSERT INTO poiNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Jesɨc inimíñayyaj Jesús jém tsɨ̱xi. Cuando jém mal espíritu iix jém Jesús, jeet́i rato e̱ybɨct́im imats jém jaychɨ̱xi. Actɨŋ naxyucmɨ, tsa̱m cujo̱ppa, aŋxacamoypa ijɨp. ");
INSERT INTO poiNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesɨc Jesús iñɨ́máy jém tsɨ̱xi ija̱tuŋ: —¿Juchɨxam moj imats yɨ́p caacuy? Nɨmpa jém tsɨ̱xi ija̱tuŋ: —Moj imats dende xut́unam. ");
INSERT INTO poiNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Wat́cɨy iccutɨŋpa juctjo̱m o nɨɨcɨɨm iga iccaaba. Siiga wɨa̱p inicpɨs, ayaachaŋja̱mɨ aɨcht́am, ayo̱xpaatɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesɨc Jesús iñɨ́máy jém pɨ̱xiñ: —Siiga mich wɨa̱p iŋcupɨc iga Dios miyo̱xpátpa, jesɨc ɨch awɨa̱p. Porque Dios wɨa̱p iwat it́u̱mpɨy cosa para jém icupɨcneyajwɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Mu imatoŋ jém pɨ̱xiñ t́i iñɨ́máy Jesús, jesɨc pɨ̱mi jɨypa. Nɨmpa: —Aŋcupɨcpa iga Dios wɨa̱p iwat. Ayo̱xpaatɨ iga más parejo aŋcupɨcpa. ");
INSERT INTO poiNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesɨc Jesús iix iga tsa̱m aŋtuuma̱yajpa jém pɨxiñt́am. Miñyajpa poyi̱mɨ. Jesɨc Jesús iwogáypa jém mal espíritu. Nɨ́mayt́a̱: —Mich mimalespíritu, iñchajcawatne yɨ́p tsɨ̱xi, íñu̱mawatne, sɨɨp mannɨ́máypa, pu̱tɨ yɨ́p tsɨ̱xi ia̱namaŋjo̱m. Odoy tɨgɨ̱yɨ e̱ybɨc. ");
INSERT INTO poiNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Jesɨc pɨ̱mi aŋwejpa jém mal espíritu, e̱ybɨc iccutɨŋpa naxyucmɨ jém tsɨ̱xi. Jesɨc jeet́i rato put jém mal espíritu. Tsɨ́y jém tsɨ̱xi juuts caane. Hasta nɨmyajpa wa̱t́i jém pɨxiñt́am iga caaneum. ");
INSERT INTO poiNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pero Jesús imatsáy icɨ, ijɨ̱ctsucum. Jesɨc te̱ñum jém tsɨ̱xi. ");
INSERT INTO poiNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ocmɨ tɨgɨy Jesús tu̱m tɨcjo̱m. Jém icuyujcɨɨwiñ iyámacwácyajpa: —¿T́iiga aɨcht́am d́a wɨa̱p antopta jém mal espíritu? ");
INSERT INTO poiNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesɨc Jesús iñɨ́máy jeeyaj: —D́a wɨa̱p iñt́opta yɨcxpɨc mal espíritu siiga d́a iniŋwejpáttámpa Dios y siiga d́a iŋwattámpa ayuno. ");
INSERT INTO poiNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jesɨc Jesús con icuyujcɨɨwiñ putyaj jém tɨgaŋjoj. Moj nɨquiyaj. Wid́aŋnasyajpa jém naxyucmɨ de Galilea. D́a iwɨ̱aŋja̱m Jesús iga ijo̱dóŋa̱yajiñ jém pɨxiñt́am ju̱t́ nɨcpa. ");
INSERT INTO poiNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Porque iŋmadáy jém icuyujcɨɨwiñ t́i iñascaaba. Nɨmpa Jesús: —Ɨch, jém aMiññewɨɨp Sɨŋyucmɨ, acɨɨjuŋcotta̱p jém malopɨc pɨxiñt́am icɨɨjo̱m. Accaayajpa jém pɨxiñt́am, pero ocmɨ jém tucunaja̱ma acpɨsta̱p. ");
INSERT INTO poiNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Pero jém icuyujcɨɨwiñ d́a icutɨɨyɨyyajpa t́i nɨmpa Jesús. Tsa̱m cɨ̱ŋyajpa iga icwácyajpa. ");
INSERT INTO poiNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ocmɨ núcyajum jém attebet Capernaum. Cuando tɨgɨyyaj jém tɨcjo̱m, Jesús icwác jém icuyujcɨɨwiñ. Nɨ́mayyajta̱: —¿T́i sɨ́p iniŋa̱cata tuŋjo̱m? ");
INSERT INTO poiNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Jesɨc d́am jɨyyaj porque tsa̱m áŋa̱neyaj tuŋjo̱m iga i̱ tsɨ́ypa juuts jém más mɨjpɨc aŋjagooyi. ");
INSERT INTO poiNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jesɨc co̱ñ jém Jesús, iŋwejáy jém doce icuyujcɨɨwiñ, moj iñɨ́máy: —Siiga i̱ tsɨ́yt́ooba juuts jém más mɨjpɨc aŋjagooyi, jesɨc tsɨ́ypa juuts jém íŋaŋpɨc pɨ̱xiñ, icuyo̱xa̱p jém it́ɨ̱wɨtam juuts tu̱m mozo. ");
INSERT INTO poiNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ocmɨ Jesús iŋwejáy tu̱m xut́u tsɨ̱xi jém icuyujcɨɨwiñ iwiñjo̱m. Iñuuspac Jesús jém xut́u tsɨ̱xi. Iñɨ́máy jém icuyujcɨɨwiñ: ");
INSERT INTO poiNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Siiga tu̱m pɨ̱xiñ iwɨ̱pɨctsoŋpa tu̱m xut́u tsɨ̱xi ɨch annɨyi̱mɨ, jesɨc jém pɨ̱xiñ awɨ̱pɨctsoŋpat́im aɨch. Y siiga awɨ̱pɨctsoŋpa aɨch, jesɨc wɨ̱pɨctsoŋta̱pt́im jém anJa̱tuŋ Dios jém acutsatnewɨɨp yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jesɨc Xiwan iñɨ́máy jém Jesús: —Mammaestro, ánixñeta tu̱m pɨ̱xiñ iga it́oppa jém mal espíritu mich iñɨyi̱mɨ. Jesɨc aɨcht́am anaŋjɨyjacta porque jém pɨ̱xiñ d́a sɨɨba con taɨcht́am. ");
INSERT INTO poiNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesɨc Jesús iñɨ́máy jém icuyujcɨɨwiñ: —Odoy aŋjɨyjactaamɨ porque siiga tu̱m pɨ̱xiñ iwatpa tu̱m mɨjpɨc milagro ɨch annɨyi̱mɨ, jesɨc d́a jobit́ wɨa̱p amalnɨ́máy. ");
INSERT INTO poiNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Jém d́apɨc it́ en contra de taɨcht́am, tayo̱xpátpa. ");
INSERT INTO poiNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Siiga i̱ michiiba tu̱m taza nɨ ɨch annɨyi̱mɨ porque mich jém Cristo mimɨɨchi, nu̱ma mannɨ́máypa iga wɨ̱yojta̱p jém pɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Siiga i̱ icwatpa táŋca tu̱m pɨ̱xiñ jém yaguiñpɨc acupɨcpa aɨch, jesɨc chiit́a̱p mɨjpɨc castigo jém pɨ̱xiñ. Más wɨ̱ iga cutsénayt́a̱iñ tu̱m mɨjpɨc molino icha iɨscɨyucmɨ y acpatsɨyt́a̱iñ lamar. ");
INSERT INTO poiNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Jesɨc siiga iŋcɨ micwatpa táŋca y mictsacpa jém Dios iŋma̱t́i, jesɨc ja̱cɨ jém iŋcɨ. Más wɨ̱ iga mit́ɨgɨypa ju̱t́ it́ Dios con tu̱m iŋcɨ que iga con icuɨstɨc iŋcɨ mininɨcta̱p jém juctjo̱m ju̱t́ d́a nunca píchpa, ju̱t́ ipɨctsoŋyajpa jém castigo. ");
INSERT INTO poiNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ju̱t́ d́a nunca caayajpa jém tsuuquiñ, ju̱t́ d́a nunca píchpa jém juctɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Siiga impuy micwatpa táŋca hasta mictsacpa jém Dios iŋma̱t́i, jesɨc ja̱cɨ jém impuy. Más wɨ̱ iga mit́ɨgɨypa ju̱t́ it́ Dios con tu̱m impuy que iga con icuɨstɨc impuy mininɨcta̱p jém juctjo̱m ju̱t́ d́a nunca píchpa, ju̱t́ ipɨctsoŋyajpa jém castigo, ");
INSERT INTO poiNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ju̱t́ d́a caayajpa jém tsuuquiñ, ju̱t́ d́a nunca píchpa jém juctɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Siiga tu̱m íñixcuy micwatpa táŋca hasta mictsacpa jém Dios iŋma̱t́i, jesɨc to̱pɨ jém íñixcuy, patsaayɨ. Más wɨ̱ iga mit́ɨgɨypa con tu̱m íñixcuy ju̱t́ iŋjacpa Dios que iga con icuɨstɨc íñixcuy micnɨcta̱p jém juctjo̱m ju̱t́ ipɨctsoŋyajpa jém castigo. ");
INSERT INTO poiNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ju̱t́ d́a nunca caayajpa jém tsuuquiñ, ju̱t́ d́a nunca píchpa jém juctɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Porque it́u̱mpɨy ca̱naɨyt́a̱p con juctɨ. It́u̱mpɨy jém sacrificio codayt́a̱p jém ca̱na. ");
INSERT INTO poiNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","’Wɨ̱ jém ca̱na, tsa̱m tayo̱xpátpa. Pero siiga jém ca̱na mɨsa̱p, togoypa ipaac, jesɨc d́am para t́i wɨ̱. Jém wɨbɨc jɨ̱xi jex juuts jém ca̱na. Nait́t́aamɨ jém wɨbɨc jɨ̱xi íña̱namaŋjo̱m. Odoy áŋa̱taamɨ con jém iñt́ɨ̱wɨtam, nawɨ̱nanɨgayt́amta̱jɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesɨc put Jesús jém attebet Capernaum. Nɨc jém naxyucmɨ Judea. Jac hasta jém nɨ aŋwiñt́uc jém río de Jordán. E̱ybɨct́im aŋtuuma̱yajpa tsa̱m jáyaŋ jém pɨxiñt́am. Miñ iámyaj jém Jesús. Jesɨc e̱ybɨc iŋquejáy jém pɨxiñt́am jém Dios iŋma̱t́i juuts iwatpa siempre. ");
INSERT INTO poiNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Jesɨc miñyaj algunos jém fariseoyaj, icunúcyajpa Jesús. Icutɨ́tsyajtooba. Jeeyucmɨ icwácpa, nɨ́mayt́a̱p: —¿Que wɨ̱ iga tu̱m pɨ̱xiñ ichacpa iyo̱mo? ");
INSERT INTO poiNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Icutsoŋ Jesús. Nɨmpa: —¿Junɨmpa jém aŋquímayooyi jém michiiñewɨɨp jém Moisés? ");
INSERT INTO poiNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Nɨmyajpa jém pɨxiñt́am: —Jém Moisés iŋquímayooyi ijɨ́cpa iga tu̱m pɨ̱xiñ wɨa̱p ictsucum tu̱m acta iga ichacpa iyo̱mo. ");
INSERT INTO poiNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesɨc Jesús iñɨ́máy jém fariseoyaj: —Yɨ́pyaj Israelpɨc pɨxiñt́am tsa̱m maloyaj ia̱nama jeeyucmɨ ijaychac yɨ́p aŋquímayooyi jém Moisés. ");
INSERT INTO poiNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pero wiñɨgam cuando Dios iwat it́u̱mpɨy cosa, iwat tu̱m pɨ̱xiñ y tu̱m iyo̱mo. ");
INSERT INTO poiNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Jeeyucmɨ jém pɨ̱xiñ ichacpa ija̱tuŋ y ia̱pa iga nɨcpa iwaganait́ iyo̱mo. ");
INSERT INTO poiNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Icuɨstɨc tsɨ́ypa tu̱mt́i mɨjta̱y. Jeeyucmɨ d́a tsɨ́ypa iga wɨste̱n. Tu̱mt́i imɨjta̱y. ");
INSERT INTO poiNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Jesɨc siiga Dios iwat iga tu̱m pɨ̱xiñ wagait́yajpa con iyo̱mo, wɨ̱ iga seguido wagait́yajiñ. D́a wɨ̱ iga tu̱m pɨ̱xiñ ichacpa iyo̱mo. ");
INSERT INTO poiNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Jesɨc cuando tɨgɨyyaj jém tɨcjo̱m jém Jesús icuyujcɨɨwiñ, e̱ybɨct́im icwácyajpa t́i nɨmtooba jém aŋquímayooyi. ");
INSERT INTO poiNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesɨc Jesús iñɨ́máy: —Siiga tu̱m pɨ̱xiñ ichacpa jém iyo̱mo y ipɨcpa tuŋgac yo̱mo, jesɨc pejóypa jém pɨ̱xiñ. Ipejpa jém iyo̱mo jém wiñt́ipɨc. ");
INSERT INTO poiNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Siiga tu̱m yo̱mo ichacpa jém iwɨd́a̱ya y ipɨcpa tuŋgac pɨ̱xiñ, jesɨc pejóypat́im jém yo̱mo. ");
INSERT INTO poiNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Jesɨc namíñayt́a̱ Jesús xuxut́ tsɨ̱xt́am iga ichiiñ bendición. Pero jém icuyujcɨɨwiñ iwogayyaj jém inimiññeyajwɨɨp jém tsɨ̱xt́am. ");
INSERT INTO poiNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesɨc pɨ̱mi jóy jém Jesús cuando iix t́i iwat jém icuyujcɨɨwiñ. Iñɨ́máy: —Jɨ́gayt́aamɨ iga míñiñ aámyaj yɨ́p tsɨ̱xt́am. Odoy aŋjɨyja̱cɨ porque jém tɨgɨyyajpaap ju̱t́ iŋjacpa Dios jex juuts jém tsɨ̱xt́am. ");
INSERT INTO poiNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nu̱ma mannɨ́máypa siiga d́a iñjɨ́cpa iga miŋjacpa Dios juuts tu̱m xut́u tsɨ̱xi, jesɨc d́a wɨa̱p iñt́ɨgɨy ju̱t́ iŋjacpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Jesɨc Jesús iñuuspacpa jém tsɨ̱xt́am. Iccámáy icɨ ico̱bacyucmɨ, ichi bendición. ");
INSERT INTO poiNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesɨc tu̱m ja̱ma mojgacum nɨqui Jesús. Jeet́i rato miñ poyi̱mɨ tu̱m pɨ̱xiñ, ico̱steeñáy jém Jesús iwiñjo̱m. Acwágóypa jém pɨ̱xiñ. Nɨ́mayt́a̱ Jesús: —Agui wɨbɨc miMaestro, ¿t́i wɨa̱p aŋwat iga ampɨctsoŋpa jém vida jém d́apɨc cuyajpa? ");
INSERT INTO poiNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesɨc Jesús iñɨ́máy jém pɨ̱xiñ: —¿T́iiga miñɨmpa iga ɨch awɨ̱? It́ tu̱m jém wɨbɨc, je jém tanJa̱tuŋ Dios. ");
INSERT INTO poiNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Mich iñjo̱doŋ jém Dios iŋquímayooyi. Nɨmpa: “Odoy accaooyɨ, odoy pejooyɨ, odoy nuumɨ, odoy cumɨgooyɨ iñt́ɨ̱wɨtam, odoy mɨgóyaayɨ tu̱m jém iñt́ɨ̱wɨ iga iññúmáypa t́it́am iniit́, naid́aayɨ respeto jém iñja̱tuŋ y jém íña̱pa.” ");
INSERT INTO poiNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Jesɨc jém pɨ̱xiñ iñɨ́máy jém Jesús: —Maestro, ɨch je̱mpɨgam aŋwatne it́u̱mpɨy dende atsɨ̱xiñam. ");
INSERT INTO poiNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesɨc Jesús iámmats jém pɨ̱xiñ, tsa̱m pɨ̱mi it́oypa. Iñɨ́máy: —No más tu̱m cosa mit́ogóyáy. Cumáyaayɨ it́u̱mpɨy jém iniit́wɨɨp, chi̱ɨ jém tumiñ jém yaacha̱yajpáppɨc, jesɨc iniit́ jáyaŋ jém wɨbɨc riqueza sɨŋyucmɨ. Jɨɨcɨ iga miyaachwatta̱p, atúŋɨɨyɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Mu imatoŋ t́i iñɨ́máy jém Jesús, nɨc jém pɨ̱xiñ. Pɨ̱mi aŋyác porque tsa̱m pɨ̱mi rico. ");
INSERT INTO poiNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesɨc Jesús iámaŋpoy jém it́yajwɨɨp, iñɨ́máy jém icuyujcɨɨwiñ: —Tsa̱m táŋca iga tu̱m ricopɨc pɨ̱xiñ núcpa ju̱t́ iŋjacpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Jém icuyujcɨɨwiñ agui ipooñaŋja̱myajpa t́i nɨmpa jém Jesús. Jesɨc e̱ybɨct́im nɨmpa jém Jesús: —Mamma̱nɨctam, tsa̱m pɨ̱mi táŋca iga núcyajpa ju̱t́ iŋjacpa Dios jém tsa̱mpɨc it́oypa it́umiñ. ");
INSERT INTO poiNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Más d́a táŋca iga naspa tu̱m camello tu̱m núncuypac ijosjo̱m que iga tɨgɨypa tu̱m rico ju̱t́ iŋjacpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Jesɨc pɨ̱mi ichɨgaŋjécyaj jém Jesús icuyujcɨɨwiñ. Moj nacwácyajta̱ji entre jeeyaj. Nɨmyaj: —¿Jesɨc i̱ wɨa̱p icɨɨput? ");
INSERT INTO poiNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesɨc Jesús iámmats jém icuyujcɨɨwiñ, iñɨ́máy: —Nu̱ma, jém pɨxiñt́am d́a wɨa̱p iwat, pero Dios wɨa̱p porque je wɨa̱p iwat it́u̱mpɨy cosa. ");
INSERT INTO poiNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Jesɨc jém Peto moj iniŋmat Jesús. Nɨ́mayt́a̱: —MánO̱mi, aɨcht́am antsacnetámum it́u̱mpɨy jém anait́wɨɨp id́ɨc iga nɨcpa mantúŋɨ́y. ");
INSERT INTO poiNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesɨc Jesús iñɨ́máy jém icuyujcɨɨwiñ: —Nu̱ma mannɨ́máypa, siiga i̱ ichacpa it́ɨc, it́ɨ̱wɨtam, ia̱pa, ija̱tuŋ, iyo̱mo, ichɨ̱xt́am, o iñas ɨch aŋcuyucmɨ iga iŋmatpa jém wɨbɨc aŋma̱t́i, jesɨc Dios iwɨ̱yojpa. ");
INSERT INTO poiNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Jesɨc yɨ́pt́im naxyucmɨ Dios icseedáypa más jáyaŋ cosa que jém ichacneyajwɨɨp jém it́ɨc, it́ɨ̱wɨtam, ia̱pa, ichɨ̱xt́am, o iñas. Pero tsa̱m yaachwatta̱pt́im yɨ́p naxyucmɨ. Jesɨc ocmɨ cuando núcpa ju̱t́ it́ Dios, iniit́um jém vida jém d́apɨc cuyajpa. ");
INSERT INTO poiNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Wa̱t́i jém aŋjagoypáppɨc tsɨ́ypa tuuñiaŋcɨɨm, jém tuuñiaŋcɨɨmpɨc, aŋjagóypa iñɨc. ");
INSERT INTO poiNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Nɨcyajpa Jerusalén Jesús con icuyujcɨɨwiñ. Jém Jesús aŋjagoyñe iñɨc, jém icuyujcɨɨwiñ miñyajpa it́uuñiaŋcɨɨm. Tsa̱m cɨ̱ŋneyaj. Tsa̱m ipooñaŋja̱myajpa iga nɨcpa Jesús Jerusalén. Jesɨc e̱ybɨc iŋwejput jém doce icuyujcɨɨwiñ, moj iŋmadáy t́it́am iñascaaba Jerusalén. ");
INSERT INTO poiNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Nɨmpa Jesús: —Matoŋtaamɨ. Sɨɨp tanɨctámpa Jerusalén. Ɨch jém aMiññewɨɨp Sɨŋyucmɨ acɨɨjuŋcotta̱p jém co̱bacpɨc pa̱nij icɨɨjo̱m y jém escribaspɨc maestroyaj icɨɨjo̱m. Jeeyaj achiiba mɨjpɨc castigo. Ocmɨ ijɨ̱syajpa jutsa̱p accaayaj. Acɨɨjuŋcotta̱p jém tuŋgac pɨxiñt́am icɨɨjo̱m jém d́apɨc je de Israel. ");
INSERT INTO poiNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Jeeyaj axiccayajpa, atsujcayajpa, pɨ̱mi acótsyajpa. Accaayajpa. Pero jém tucunaja̱ma apɨspa de ju̱t́ it́ jém caaneyajwɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jesɨc ocmɨ jém Jacobo y jém Xiwan, jém Zebedeo ima̱nɨctam, icunúcyaj Jesús. Iñɨ́mayyajpa: —Miccuyujoypaap, awadayt́aamɨ tu̱m favor. ");
INSERT INTO poiNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesɨc Jesús iñɨ́máy jém wɨste̱n: —¿T́i iñxunpa iga maŋwadayt́ámpa? ");
INSERT INTO poiNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Jeeyaj nɨmyaj: —Cuando núcpa jém tiempo iga iniŋjacpa yɨ́p naxyucmɨ con Dios ipɨ̱mi, achiit́aamɨ derecho iga nɨcpa aco̱ñi tu̱m iniŋwɨ̱mɨ y tu̱m iniŋna̱ymɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Pero Jesús iñɨ́máy jém wɨste̱n: —Micht́am d́a iñjo̱doŋtam t́i aŋwágayt́ámpa. ¿Que mich iñyaachɨ́ypa iga miyaachwatta̱p juuts aɨch ayaachwatta̱p? ¿Que wɨa̱p íñuc jém copa jém ɨchpɨc ánucpa? ¿Que wɨa̱pt́im micchiŋtamta̱ juuts ɨch acchiŋta̱p? ");
INSERT INTO poiNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Jesɨc jém wɨste̱n iñɨ́máy jém Jesús: —Awɨa̱támpa. Jesɨc Jesús iñɨ́máy: —Nu̱ma, mimicht́am miyaachwattamta̱pt́im juuts aɨch. Íñuctámpa jém copa jém ɨchpɨc ánucpa. Micchiŋtamta̱pt́im juuts aɨch acchiŋta̱p. ");
INSERT INTO poiNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pero ɨch d́a wɨa̱p manchi derecho iga nɨcpa mico̱ñi tu̱m anaŋwɨ̱mɨ y tu̱m anaŋna̱ymɨ. Jém anJa̱tuŋ Dios ichiiba derecho jém icupiŋneyajwɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Jesɨc cuando imatoŋyaj los de más jém Jesús icuyujcɨɨwiñ, jém diezpɨc, tsa̱m ijóyixyajpa jém Jacobo y Xiwan. ");
INSERT INTO poiNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jesɨc Jesús iŋwejáy it́u̱mpɨy jém icuyujcɨɨwiñ. Iñɨ́máy: —Micht́am iŋwɨ̱jo̱doŋ iga jém juumɨpɨc pɨxiñt́am iŋjagooyiyaj tsa̱m ipɨɨmɨ́ypa jém ipɨxiñt́am. Jém más mɨjpɨc aŋjagooyi más pɨ̱mi ipɨɨmɨ́ypa jém ipɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pero mimicht́am d́a iŋwattámpa je̱mpɨc. Siiga mɨjpɨc miŋjagooyi, iŋcuyo̱xa̱p jém iñt́ɨ̱wɨtam. ");
INSERT INTO poiNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Jém más mɨjpɨc iniŋjagooyi micuyo̱xa̱p juuts tu̱m esclavo. ");
INSERT INTO poiNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Wattaamɨt́im juuts aɨch. Amiñ sɨŋyucmɨ iga aŋcuyo̱xa̱p jém it́yajwɨɨp yɨ́p naxyucmɨ. Ɨch d́a amiñ iga acuyo̱xayajiñ jeeyaj. Ɨch amiñ iga anchiiba amvida iga anyojáypa jáyaŋ jém pɨxiñt́am it́áŋca. ");
INSERT INTO poiNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ocmɨ núcyaj jém attebet Jericó. Jesɨc cuando putyajpa jém Jericó jém Jesús con icuyujcɨɨwiñ iwagananɨcyajpa jáyaŋ jém pɨxiñt́am. Jemum co̱ñ tuŋaŋna̱ca tu̱m cácht́i iñɨ̱yi Bartimeo jém Timeo ima̱nɨc. Iwácpa tumiñ. ");
INSERT INTO poiNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Jesɨc cuando jém cácht́i imatoŋ iga naspa Jesús jém Nazaretpɨc, jesɨc pɨ̱mi jɨypa jém cácht́i. Nɨmpa: —Jesús, jém rey David mima̱nɨc, ayaachaŋja̱mɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Jém it́úŋɨyyajpaap Jesús iwogayyajpa jém cácht́i iga odoy jɨ́yiñ. Pero más pɨ̱mi jɨypa jém cácht́i. Nɨmpa: —Jém rey David mima̱nɨc, ayaachaŋja̱mɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesɨc teeñaŋjac Jesús. Iñɨ́máy jém it́yajwɨɨp: —Aŋwejaayɨ jém pɨ̱xiñ. Jesɨc jeeyaj iŋwejayyaj jém cácht́i. Nɨ́mayt́a̱: —Maymáya̱jɨ. Tsucu̱mɨ, porque sɨ́p miŋwejáy jém tamMaestro. ");
INSERT INTO poiNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Jesɨc jém cácht́i ipatsquet naxyucmɨ jém icapa de lana, jicscɨy tsucum, nɨc iám jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesɨc Jesús iñɨ́máy jém cácht́i: —¿T́i iñxunpa iga maŋwadáypa? Jesɨc jém cácht́i icutsoŋ. Nɨmpa: —MamMaestro, ansunpa iga actojaayɨ ánixcuy. ");
INSERT INTO poiNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesɨc Jesús iñɨ́máy jém cácht́i: —Sɨɨp nɨcsɨm. Tsa̱m iŋcupɨcne iga Dios wɨa̱p miyo̱xpát, jeeyucmɨ mipɨsneum. Jesɨc jeet́i rato toj iixcuy jém cácht́i, mojum it́úŋɨ́y jém Jesús ju̱t́ nɨcpa. ");
INSERT INTO poiNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jesɨc núcyajpa nocojo̱m jém Jerusalén tomi ju̱t́ it́ jém wɨste̱n tɨgaŋjoj jém Betfagé y jém Betania, co̱tsɨc aŋna̱ca, jém co̱tsɨc iñɨ̱yi Olivos. Jesɨc Jesús icutsat wɨste̱n jém icuyujcɨɨwiñ tu̱m tɨgaŋjoj nocojo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Iñɨ́máy jeeyaj: —Nɨctaamɨ jém tɨgaŋjoj jeexpɨc it́. Cuando miñúctámpa je̱m, impáttámpa tu̱m ma̱ñburro tsenne. D́a i̱ queman iquímca jém burro. Wi̱jɨ, anamíñaayɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Siiga i̱ miñɨ́máypa iga t́iiga iŋwijpa jém burro, jesɨc nɨ́maayɨ: “Jém tánO̱mi ixunpa. D́a jáypa micseedáy.” ");
INSERT INTO poiNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Jesɨc nɨcyaj jém wɨste̱n. Ipátyaj tu̱m ma̱ñburro tsenne calle tu̱m puerta aŋna̱ca. Iwijyaj. ");
INSERT INTO poiNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Jesɨc jém it́yajwɨɨp je̱m iñɨ́mayyaj jém Jesús icuyujcɨɨwiñ: —¿T́i iŋwatpa? ¿T́iiga iŋwijpa jém burro? ");
INSERT INTO poiNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Jesɨc jém icuyujcɨɨwiñ icutsoŋyaj jém it́yajwɨɨp juuts iñɨ́máy jém Jesús. Jesɨc ichi lado iga ininɨguiñ jém burro. ");
INSERT INTO poiNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Jesɨc ininɨgayyaj Jesús jém burro, icutógayyaj jém burro con iyoot́i. Jesús iquímca. ");
INSERT INTO poiNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Wa̱t́i jém pɨxiñt́am it́ócyaj iyoot́i tuŋjo̱m ju̱t́ wit́pa jém burro. Tuŋgac it́úcyaj jém cuy iŋcɨs y jém ay iga it́ócyajpat́im tuŋjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Algunos jém pɨxiñt́am aŋjagoyñeyaj iñɨc y algunos nɨcyajpa tuuñiaŋcɨɨm. Pɨ̱mi aŋwejyajpa. Nɨmyajpa: —¡Hosanna! Agui wɨ̱ jém tanJa̱tuŋ Dios. Taŋcujíptámpat́im yɨ́p tanaŋjagooyi jém tacutsadayñewɨɨp Dios. ");
INSERT INTO poiNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Agui wɨ̱ yɨ́p tanaŋjagooyi. Miñpa iŋjac tannación juuts jém wiñɨcpɨc rey jém David. ¡Hosanna! Agui wɨ̱ jém tanJa̱tuŋ Dios jém it́wɨɨp sɨŋyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesɨc núc Jerusalén jém Jesús. Tɨgɨy jém mɨjpɨc ma̱stɨcjo̱m, iám it́u̱mpɨy cosa jém it́yajwɨɨp je̱m. Ocmɨ nɨc tsɨɨyiyaj Betania jém Jesús con jém doce icuyujcɨɨwiñ porque tsuuyɨm. ");
INSERT INTO poiNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Jesɨc icuqueja̱ma cuando put Jesús jém Betania, tsa̱m yua̱p. ");
INSERT INTO poiNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Jesɨc juumɨ iix Jesús tu̱m tsuj tsa̱m áyɨ́y. Jesɨc nɨc icuámáy jém tsuj it́ɨm. Pero d́a ipadáy jém it́ɨm no más it́ jém iay porque d́a itiempo iga tɨɨma̱p. ");
INSERT INTO poiNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jesɨc Jesús iñɨ́máy jém tsuj: —Ɨch mannɨ́máypa iga d́a nunca i̱ micudáypa jém iñt́ɨm. Jém icuyujcɨɨwiñ imatoŋyaj t́i nɨmpa Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jesɨc ocmɨ nɨcyaj Jerusalén. E̱ybɨc tɨgɨy Jesús jém mɨjpɨc ma̱stɨcjo̱m. Moj iquepquebacput jém máymáyoyyajpaap y jém juyjúyoyyajpaap jém mɨjpɨc ma̱stɨcjo̱m. Jesús ichiputseedáy jém imesayaj jém icucacyajpaap tumiñ. Imutsmutsseedáy jém ico̱ñcuyyaj jém imáyyajpaap cuucu. ");
INSERT INTO poiNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","D́at́im ijɨ́cpa Jesús iga i̱ ininɨcpa algun carga jém mɨjpɨc ma̱stɨcjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Jesɨc Jesús moj iŋquejáy jém pɨxiñt́am. Nɨ́mayyajta̱: —Jaychacneta̱wum jém Dios iŋma̱t́i: “Ɨch antɨc ju̱t́ iwatyajpa oración. Je para it́u̱mpɨy jém pɨxiñt́am.” Pero micht́am impɨcneta yɨ́p antɨc juuts tu̱m mercado, tsa̱m it́ jém númyajpaap. ");
INSERT INTO poiNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Jém co̱bacpɨc pa̱nijyaj con jém escribaspɨc maestroyaj imatoŋyaj t́i nɨmpa jém Jesús. Moj ijɨ̱syaj jutsa̱p iccaayaj. Jém aŋjagooyiyaj icɨ̱ŋyajpa jém Jesús porque it́u̱mpɨy jém pɨxiñt́am tsa̱m ipooñaŋja̱myajpa cuando imatoŋyaj jém wɨbɨc iŋquímayooyi. ");
INSERT INTO poiNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Jesɨc tsuáŋam putyaj Jerusalén jém Jesús con icuyujcɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Jesɨc icuqueja̱ma cuando nɨcgacpa Jesús Jerusalén, nasyajpa ju̱t́ it́ jém tsuj. Iixyaj iga tɨtsneum jém tsuj hasta it́i̱chɨcyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Jém Peto ijɨ̱s iga imalnɨ́máy Jesús jém tsuj, jesɨc iñɨ́máy: —MamMaestro, aamɨ jém tsuj jém immalnɨ́mayñewɨɨp. Sɨɨp tɨtsneum. ");
INSERT INTO poiNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesɨc Jesús iñɨ́máy jém icuyujcɨɨwiñ: —Cupɨctaamɨ iga tsa̱m wɨa̱p jém tanJa̱tuŋ Dios. ");
INSERT INTO poiNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nu̱ma mannɨ́máypa, siiga i̱ iñɨ́máypa yɨ́p co̱tsɨc iga: “Caayɨ de yɨɨm, nɨ̱gɨ miniccámta̱ji lamar”, jesɨc tienes que miwadáypa Dios juuts iŋwágáypa siiga d́a inii̱ duda y iŋcupɨcpa íña̱namaŋjo̱m iga Dios wɨa̱p miyo̱xpát. ");
INSERT INTO poiNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Jeeyucmɨ mannɨ́máypa iga cuando iŋwattámpa oración iga iŋwágáypa Dios algun t́i, siiga iŋcupɨcpa iga impɨctsoŋpa, jesɨc Dios michiiba. ");
INSERT INTO poiNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Cuando iniŋwejpáttámpa Dios, wiñt́i wadayt́aamɨ perdón siiga i̱ mimalwadáy. Jesɨc jém tanJa̱tuŋ Dios, jém it́wɨɨp sɨŋyucmɨ, miwadayt́ámpat́im perdón mimicht́am it́u̱mpɨy jém iñt́áŋca. ");
INSERT INTO poiNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Siiga d́a iŋwadáypa perdón jém mimalwadayñewɨɨp, jesɨc jém tanJa̱tuŋ Dios jém it́wɨɨp sɨŋyucmɨ d́at́im miwadáypa perdón mimicht́am iñt́áŋca. ");
INSERT INTO poiNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jesɨc e̱ybɨct́im nɨc Jesús Jerusalén con icuyujcɨɨwiñ. Cuando sɨɨba Jesús jém mɨjpɨc ma̱stɨcjo̱m, miñyaj jém co̱bacpɨc pa̱nijyaj con jém escribaspɨc maestroyaj y jém wɨd́ayt́am. Icunúcyaj jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Jesɨc jeeyaj icwácyaj jém Jesús. Nɨ́mayt́a̱: —¿I̱ micutsat iga iŋwatpa juuts mich sɨ́p iŋwat? ¿I̱ michi jém impɨ̱mi? ");
INSERT INTO poiNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesɨc Jesús iñɨ́máy jeeyaj: —Sɨɨp manacwácpat́im tu̱m cosa. Siiga wɨa̱p aŋcutsoŋta, jesɨc ɨchgam mannɨ́máypa i̱ achi jém pɨ̱mi iga aŋwatpa juuts sɨ́p aŋwat. ");
INSERT INTO poiNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Anɨ́mayt́aamɨ, ¿i̱ ichi ipɨ̱mi jém Xiwan iga acchíŋóypa? ¿Que Dios ichi jém ipɨ̱mi o pɨ̱xiñ ichi? ");
INSERT INTO poiNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Jesɨc jém aŋjagooyiyaj moj nacwácyajta̱ji entre jeeyaj. Nanɨ́mayyajta̱: —Siiga tannɨ́máypa iga Dios icutsat jém Xiwan, jesɨc tanɨ́máypa iga: “¿T́iiga d́a iŋcupɨctámpa?” ");
INSERT INTO poiNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Pero siiga tannɨ́máypa iga d́a je Dios icutsat jém Xiwan, jesɨc d́a t́i wɨa̱p taŋwat. Jém aŋjagooyiyaj icɨ̱ŋyajpa jém pɨxiñt́am porque it́u̱mpɨy de jeeyaj ijo̱doŋyaj iga jém Xiwan tu̱m nunta profeta. ");
INSERT INTO poiNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Jesɨc jém aŋjagooyiyaj icutsoŋyaj. Iñɨ́mayyaj Jesús: —D́a anjo̱doŋtam. Jesɨc Jesús iñɨ́máyt́im jém aŋjagooyiyaj: —Ɨch d́at́im mannɨ́máypa i̱ achi jém pɨ̱mi iga aŋwatpa juuts sɨ́p aŋwat. ");
INSERT INTO poiNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jesɨc Jesús moj iŋquejáy jém pɨxiñt́am cuentujmɨ. Nɨ́mayyajta̱: —It́ id́ɨc tu̱m pɨ̱xiñ iñip tu̱m finca de uvas. Icutánne. Iwat tu̱m tsaajos ju̱t́ it́obáypa jém uvas iñɨ iga iwatpa jém vino. Iwatt́im tu̱m torre ju̱t́ iwatpa cuenta jém finca. ’Jesɨc ocmɨ icnucs jém ifinca tuŋgac pɨxiñt́am iga it́úcyajpa jém uvas y iwatpa jém vino. Jesɨc jém nas io̱mi nɨc jo̱yi tuŋgac naxyucmɨ tsa̱m juumɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Jesɨc cuando núc jém tiempo iga tɨɨma̱p jém uvas, jém finca io̱mi icutsat tu̱m imozo iga nɨguiñ iám jém icnucsneyajwɨɨp jém ifinca iga iwégáyiñ jém cosecha. ");
INSERT INTO poiNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pero cuando núc jém imozo, matsta̱, tsa̱m cótsta̱. Acse̱tta̱ e̱ybɨc ju̱t́ miñ. D́a t́i ichiiyaj. ");
INSERT INTO poiNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Jesɨc jém finca io̱mi icutsat tuŋgac jém imozo. Pero iŋnácsjedayyaj jém ico̱bac. Tsa̱m pɨ̱mi imalmalnɨ́mayyaj. Acse̱tta̱ e̱ybɨc ju̱t́ miñ. ");
INSERT INTO poiNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Jesɨc icutsat tuŋgac jém imozo, pero accaayt́a̱ jém imozo. Asíam iñascayaj wa̱t́i jém imozoyaj. Algunos pɨ̱mi cótsta̱ y algunos accaata̱. ");
INSERT INTO poiNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Ocmɨ núc tu̱m ja̱ma iga tsɨ́y no más jém pɨ̱xiñ ima̱nɨc jém tsa̱mpɨc it́oypa. Jesɨc ocmɨ icutsatt́im jém ima̱nɨc. Ijɨ̱spa: “Tienes que iniid́ayyajpa respeto amma̱nɨc.” ");
INSERT INTO poiNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pero cuando núc jém pɨ̱xiñ ima̱nɨc, jesɨc jém pɨxiñt́am moj nanɨ́mayyajta̱ji: “Yɨ́bam jém ima̱nɨc jém ipɨctsoŋpáppɨc it́u̱mpɨy jém ija̱tuŋpɨc imɨɨchi. Sɨɨp tanaccaaba, jesɨc taɨcht́am tammɨɨcha̱támpa jém herencia.” ");
INSERT INTO poiNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Jesɨc matsayt́a̱ jém pɨ̱xiñ ima̱nɨc, accaata̱, patsayt́a̱ aŋsɨ̱cmɨ de jém finca. ");
INSERT INTO poiNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Jesɨc Jesús iñɨ́máy jém pɨxiñt́am: —Sɨɨp anɨ́maayɨ: ¿T́i iwatpa jém finca io̱mi? Miñpa iccucaáy jém iwatyajpáppɨc cuenta jém uvas. Jesɨc ocmɨ ichiiba jém finca tuŋgac pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Que d́a immayñe jém Dios iŋma̱t́i ju̱t́ jayñeta̱? Nɨmpa: Jém tɨcwatpaap ipatsayt́ɨp jém tsa. Pero ocmɨ jeet́im tsa piŋta̱. Sɨɨp jeet́im tsa icóppacne jém tɨc. ");
INSERT INTO poiNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Yɨ́bam jém tanJa̱tuŋ Dios iwa̱t́i. Cuando tánixt́ámpa, agui tampooñaŋja̱mtámpa. ");
INSERT INTO poiNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jesɨc jém aŋjagooyiyaj tsa̱m imatsyajtooba jém Jesús porque icutɨɨyɨyyaj iga jeam icuyucmɨ iŋmat Jesús jém xut́u cuento. Pero tsa̱m icɨ̱ŋyajpa jém pɨxiñt́am. Jesɨc ichacyajpa iga imoogɨ́ypa jém Jesús. Nɨcyajum. ");
INSERT INTO poiNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Jesɨc ocmɨ cutsadayt́a̱ Jesús algunos jém fariseoyaj y jém aŋjagooyi Herodes ipɨxiñt́am. Nɨc icutɨ́tsta̱ Jesús iga iccutɨŋpa con jém iŋma̱t́i iga wɨa̱iñ iquejajwadayyaj. ");
INSERT INTO poiNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Jesɨc núcyaj iñɨ́mayyaj jém Jesús: —Maestro, anjo̱dóŋa̱ta iga siempre iniŋmatpa jém nu̱mapɨc aŋma̱t́i y d́a iŋwadáypa caso t́i nɨmyajpa jém pɨxiñt́am. Mich d́a i̱ iŋcɨ̱ŋpa. Siempre iniŋmatpa parejo jém Dios iŋma̱t́i. Jesɨc anɨ́maayɨ, ¿wɨ̱ iga tanyojpa jém impuesto jém César o d́a wɨ̱? ¿Tanyojtámpa o d́a tanyojtámpa? ");
INSERT INTO poiNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Pero Jesús icutɨɨyɨ́y iga jeeyaj d́a icuyujcatooba jém Dios iŋma̱t́i, no más miñ icutɨ́ts. Jesɨc iñɨ́máy: —¿T́iiga aŋcutɨ́tstámpa mimicht́am? Anamíñaayɨ tu̱m tumiñ iga ánámpa. ");
INSERT INTO poiNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Jesɨc inimíñayyaj Jesús tu̱m tumiñ. Jesɨc Jesús iñɨ́máy: —¿I̱ iwiñpac, i̱ iñɨ̱yi accámayñeta̱ yɨ́p tumiñyucmɨ? Jesɨc nɨmyajpa jém pɨxiñt́am: —Jém César jém Romapɨc aŋjagooyi. ");
INSERT INTO poiNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jesɨc Jesús iñɨ́máy jém pɨxiñt́am: —Jém Césarpɨc imɨɨchi, chiit́aamɨ jém César. Jém Diospɨc imɨɨchi, chiit́aamɨ Dios. Tsa̱m pɨ̱mi ipooñaŋja̱myajpa jém pɨxiñt́am cuando imatoŋyaj t́i nɨmpa jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Miñyajt́im algunos jém saduceoyaj iga iámyajpa jém Jesús. Jeeyaj d́a icupɨcyajpa iga pɨsyajpa jém caaneyajwɨɨp. Jesɨc icwácyajpa Jesús. Nɨmyajpa: ");
INSERT INTO poiNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Maestro, wiñɨgam jém Moisés tajaychagáy yɨ́p aŋquímayooyi. Nɨmpa siiga caaba tu̱m pɨ̱xiñ y ichacpa iyo̱mo, pero d́a ichac ni tu̱m ima̱nɨc, jesɨc jém pɨ̱xiñ it́ɨ̱wɨ tienes que ipɨgáyiñ jém iyo̱mo iga inima̱nɨcwatpa. Jesɨc tsɨ́ypa jém tsɨ̱xi juuts jém caanewɨɨp ima̱nɨc. ");
INSERT INTO poiNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","It́ id́ɨc tu̱m pɨ̱xiñ, iniit́ siete ijayma̱nɨc. Yoomɨ́y jém más a̱chpɨc. Ocmɨ ca, d́a ichac ni tu̱m ima̱nɨc. ");
INSERT INTO poiNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Jesɨc jém ipɨɨtsɨ ipɨc jém ica̱pay, jém cuno̱ya. Ocmɨ jém pɨ̱xiñ caat́im mex je. D́at́im inima̱nɨcwat jém yo̱mo. Jesɨc ocmɨ je̱mpɨct́im iwat jém tuŋgac ijáyuc. ");
INSERT INTO poiNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Je̱mpam iwatyaj icusiete, ipɨcyaj jém ica̱pay, ni tu̱m d́a inima̱nɨcwat jém yo̱mo. Ocmɨm caat́im mex jém yo̱mo. ");
INSERT INTO poiNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Jesɨc cuando acpɨsyajta̱p jém caaneyajwɨɨp, ¿juppɨc de jeeyaj tsɨ́ypa juuts jém yo̱mo iwɨd́a̱ya porque icusiete aŋcoomɨyyaj con jém yo̱mo? ");
INSERT INTO poiNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesɨc Jesús icutsoŋ, nɨmpa: —Mimicht́am tsa̱m mijɨ̱xit́ogoyñeta. D́a iŋcutɨɨyɨyt́ámpa jém Dios iŋma̱t́i jém jaychacneta̱wɨɨp. D́at́im iŋcutɨɨyɨyt́ámpa t́i wɨa̱p iwat Dios con ipɨ̱mi. ");
INSERT INTO poiNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Cuando acpɨsyajta̱p jém caaneyajwɨɨp, d́am aŋcoomɨyyajpa. D́am napɨcyajta̱p jém pɨxiñt́am con jém yo̱mtam. Jeeyaj tsɨ́yyajpa juuts jém sɨŋyucmɨpɨc pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Sɨɨp manaŋquejáypa iga nu̱ma acpɨsyajta̱p jém caaneyajwɨɨp. Micht́am immayñeta jém libro jém ijayñewɨɨp jém Moisés ju̱t́ iŋmatpa jém cuento de jém xut́u cuy jém jípspáppɨc id́ɨc. D́a iñjɨ̱spa t́i nɨmpa Dios cuando ijɨ́yáy jém Moisés ju̱t́ agui yótpa jém xut́u cuy. Nɨmpa así Dios: “Ɨch jém Abraham aDios, y jém Isaac aDios, y jém Jacob aDios.” ");
INSERT INTO poiNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Jesɨc quejpa iga jém tanJa̱tuŋ Dios d́a je jém caanewɨɨp iDios, je jém vivopɨc iDios. Mimicht́am tsa̱m mijɨ̱xit́ogoyñeta. ");
INSERT INTO poiNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Jesɨc núct́im je̱m tu̱m jém escribaspɨc maestro. Imatoŋ iga áŋa̱yajpa jém saduceoyaj con Jesús. Jém maestro iix iga Jesús tsa̱m iwɨ̱cutsoŋ jém ienemigoyaj, jesɨc icwác. Nɨ́mayt́a̱p: —¿Juppɨc jém más mɨjpɨc aŋquímayooyi? ");
INSERT INTO poiNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesɨc Jesús iñɨ́máy: —Nɨmpa así jém más mɨjpɨc aŋquímayooyi: “Matoŋtaamɨ miIsraelpɨc mipɨxiñt́am. Jém tanJa̱tuŋ Dios t́u̱m. D́a i̱ tuŋgac. ");
INSERT INTO poiNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","To̱yɨ jém tanJa̱tuŋ Dios con it́u̱mpɨy íña̱nama, con it́u̱mpɨy iñjɨ̱xi y con it́u̱mpɨy impɨ̱mi.” Yɨ́bam jém más mɨjpɨc aŋquímayooyi. ");
INSERT INTO poiNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","It́ tuŋgac aŋquímayooyi jexpɨct́im. Nɨmpa así: “To̱yɨ jém iñt́ɨ̱wɨ juuts minitoyt́a̱p iñyaac.” D́a i̱ tuŋgac aŋquímayooyi más mɨj que yɨ́p wɨste̱n. ");
INSERT INTO poiNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Jesɨc jém escribaspɨc maestro iñɨ́máy Jesús: —Nu̱ma, miMaestro, agui iŋwɨ̱aŋmat. Nu̱ma juuts miñɨm iga tu̱m Dios it́, d́a i̱ tuŋgac. ");
INSERT INTO poiNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Wɨ̱ iga tantóyiñ Dios con it́u̱mpɨy tána̱nama, con it́u̱mpɨy tanjɨ̱xi y con it́u̱mpɨy tampɨ̱mi. Wɨ̱ iga tantóyiñ tantɨ̱wɨ juuts tanatoyt́a̱p tanyaac. Siiga taŋwatpa yɨɨmpɨc, más iwɨ̱aŋja̱m Dios que it́u̱mpɨy jém ofrenda y jém sacrificio jém nooneta̱wɨɨp altaryucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesɨc Jesús iix iga agui jɨ̱xiɨ́y jém maestro. Tsa̱m iwɨ̱cutsoŋ. Jeeyucmɨ nɨmpa así jém Jesús: —D́a juchaŋ mit́ogóyáy iga miñúcpa ju̱t́ iŋjacpa Dios. Jesɨc cɨ̱ŋyajpa jém pɨxiñt́am iga e̱ybɨc icwácyajpa jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesɨc ocmɨ iganam accuyujóypa Jesús jém ma̱stɨcjo̱m, nɨmpa así: —¿T́iiga nɨmyajpa jém escribaspɨc maestroyaj iga jém Cristo je jém David ima̱nɨc? ");
INSERT INTO poiNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Jeet́im David ijaychacne así porque jém Dios iA̱nama ichi jém jɨ̱xi. Nɨmpa: Jém tanJa̱tuŋ Dios iñɨ́máy jém tánO̱mi Cristo iga: “Co̱ñɨ yɨɨm anaŋwɨ̱mɨ hasta que iŋcoñwɨ́ypa jém mijóyixyajpaap.” ");
INSERT INTO poiNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","¿Pero jutsa̱p ichɨ́y jém Cristo juuts jém David ima̱nɨc siiga nɨmt́im jém David iga jém Cristo je jém iO̱mi? Jemum aŋtuuma̱neyaj tsa̱m jáyaŋ jém pɨxiñt́am. Agui maymayyaj cuando imatoŋyaj t́i nɨmpa jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesɨc iŋmadáypat́im Jesús jém pɨxiñt́am. Nɨ́mayyajta̱p: —Cuidado iga iŋcupɨcpa jém jɨ̱xi jém d́apɨc wɨ̱ jém iniit́wɨɨp jém escribaspɨc maestroyaj. Je iwɨ̱aŋja̱myaj iga iccámyajpa jém yagatsyoot́i. Iwɨ̱aŋja̱myajt́im iga jém pɨxiñt́am idioschiyajiñ cuando sɨɨyajpa calle. ");
INSERT INTO poiNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Iwɨ̱aŋja̱myajt́im jém más wɨbɨc co̱ñcuy jém sinagoga. Cuando nɨcpa sɨ́ŋa̱jiyaj, icusúnɨyyajpa jém co̱ñcuy ju̱t́ wícpa jém más mɨjpɨc aŋjagooyi. ");
INSERT INTO poiNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Iccáyáypa jém cuno̱ya it́ɨc. Jesɨc ocmɨ tsa̱m jáypa hora iwatyajpa jém oración iga tamɨgóyáypa. Ipɨctsoŋyajpa tsa̱m mɨjpɨc castigo cuando nɨcpa iyoj it́áŋca. ");
INSERT INTO poiNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Tu̱m ja̱ma co̱ñ Jesús jém mɨjpɨc ma̱stɨcjo̱m noco ju̱t́ it́ jém cajon ju̱t́ cotta̱p jém ofrenda. Iix Jesús jém pɨxiñt́am cuando icotyajpa jém ofrenda cajonjo̱m. Iix iga wa̱t́i jém ricoyaj, icotyaj jáyaŋ tumiñ. ");
INSERT INTO poiNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ocmɨ núct́im tu̱m yo̱mo tsa̱m pobre. Cuno̱yam. Icot cajonjo̱m wɨste̱n xuxut́ tumiñ. ");
INSERT INTO poiNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jesɨc Jesús iŋwejáy icuyujcɨɨwiñ iga míñiñ iámyaj. Iñɨ́máy: —Nu̱ma mannɨ́máypa, yɨ́p cuno̱ya tsa̱m pobre más chióy que it́u̱mpɨy jém pɨxiñt́am jém icotneyajwɨɨp it́umiñ jém cajonjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Porque los de más, jém tumiñɨywɨɨp, ichiiyaj no más uxaŋ jém it́umiñ jém iniit́wɨɨp id́ɨc. Yɨ́p cuno̱ya tsa̱m pobre, pero icuchiáy Dios it́u̱mpɨy jém iniit́wɨɨp. D́am t́i initsɨ́y iga wícpa jém yo̱mo. ");
INSERT INTO poiNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesɨc iganam putyaj Jesús jém mɨjpɨc ma̱stɨcjo̱m con icuyujcɨɨwiñ, tu̱m jém icuyujcɨɨwiñ iñɨ́máy: —Mammaestro, aamɨ yɨ́p tamma̱stɨc. Agui wɨ̱watne con jém wɨ̱tampɨc tsa. ");
INSERT INTO poiNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesɨc Jesús iñɨ́máy jém icuyujcɨɨwiñ: —Nu̱ma, sɨɨp íñixt́ámpa yɨ́p mɨjtampɨc ma̱stɨc, pero núcpa ja̱ma iga mɨswatta̱p. D́a cutatsquetneeba ichɨ́y ni tu̱m tsa. It́u̱mpɨy accujegayyajta̱p. ");
INSERT INTO poiNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Nɨcyaj Jesús con icuyujcɨɨwiñ jém co̱tsɨcyucmɨ de Olivos. Jemum co̱ñyaj jém mɨjpɨc ma̱stɨc iñu̱ma, jém pacus aŋwiñt́uc. Jesɨc jém Peto, jém Jacobo, jém Xiwan y jém Anti icunúcyaj jém Jesús. Iyámacwácyajpa: ");
INSERT INTO poiNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—¿Anɨ́mayt́aamɨ juchɨs naspa yɨ́pyaj cosa? ¿Jup seña tánixt́ámpa cuando naspa it́u̱mpɨy yɨ́pyaj cosa? ");
INSERT INTO poiNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesɨc Jesús moj iñɨ́máy jeeyaj: —Nawattamta̱jɨ cuenta iga odoy i̱ mimɨgóyayt́ámiñ. ");
INSERT INTO poiNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Miñyajpa wa̱t́i jém mɨgoyyajpaap ɨch annɨyi̱mɨ. Nɨmyajpa iga: “Ɨch aCristo.” Imɨgóyayyajpa tsa̱m jáyaŋ jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Jesɨc cuando immatoŋtámpa iga it́ jém guerra y waŋpa iga tsa̱m áŋa̱yajpa jém naciónyaj, odoy cɨ̱ŋtaamɨ; tienes que naspa it́u̱mpɨy yɨ́pyaj cosa, pero d́anam núcne jém íŋaŋpɨgam ja̱ma. ");
INSERT INTO poiNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tu̱m nación áŋa̱yajpa con tuŋgac nación. Tu̱m naxyucmɨ áŋa̱yajpa con tuŋgac naxyucmɨ. Miñpa jém nasyɨɨxi ju̱t́quej. Miñpat́im jém mɨjtampɨc yuu. Tsa̱m cujíñayyajpa jém pɨxiñt́am. Cuando íñixt́ámpa it́u̱mpɨy yɨ́pyaj cosa, iñjo̱doŋtam iga tsucumneum jém mɨjpɨc yaacha̱ji. ");
INSERT INTO poiNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Cuando mojpa íñixt́a it́u̱mpɨy yɨ́pyaj cosa, nawattamta̱jɨ cuenta. Mimatstamta̱p, mininɨctamta̱p ju̱t́ aŋtuuma̱yajpa jém Sanhedrín iga micɨɨpiŋta̱p. Mininɨctamta̱p jém sinagoga iga micótstamta̱p. Ɨch aŋcuyucmɨ mininɨctamta̱p jém gobernador iwiñjo̱m y hasta jém rey iwiñjo̱m. Jesɨc je̱mpɨgam inicjo̱dóŋa̱p jeeyaj ɨch anaŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Antes que núcpa jém íŋaŋpɨgam ja̱ma, tienes que aŋmatta̱p jém wɨbɨc aŋma̱t́i icuwɨ̱t́i yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Cuando mininɨctamta̱p jém aŋjagooyicɨɨm, antes que miñúctámpa, odoy jɨ̱sɨ jutsa̱p iŋcutsoŋ jém aŋjagooyiyaj. Aŋmadaayɨ juuts miñɨ́máy Dios jeet́i rato porque d́a mich iñjɨ̱xquiimi. Dios iA̱nama michiiba jém aŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Algunos jém pɨxiñt́am icɨɨjuŋcotpa jém iñuntatɨ̱wɨ jém aŋjagooyicɨɨm iga accaata̱iñ. Tu̱m pɨ̱xiñ icɨɨjuŋcotpa jém ima̱nɨc jém aŋjagooyicɨɨm iga accaata̱iñ. Algunos jém tsɨ̱xt́am ijóyixyajpa jém ija̱tuŋ o ia̱pa hasta icɨɨjuŋcotyajpa jém aŋjagooyicɨɨm iga accaayajta̱iñ. ");
INSERT INTO poiNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","It́u̱mpɨy jém pɨxiñt́am tsa̱m mijóyixt́ámpa ɨch aŋcuyucmɨ. Pero siiga d́a iñchactámpa jém Dios iŋma̱t́i y siiga iñyaachɨ́ypa cuando mimalwadayt́amta̱p, jesɨc Dios micɨacputtámpa. ");
INSERT INTO poiNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Jém wiñɨcpɨc profeta, jém Daniel, ijaychac jém librojo̱m iga miñpa tu̱m aŋjagooyi tsa̱m pɨ̱mi malo, tsa̱m ijóyixpa tanJa̱tuŋ Dios. Miñpa iwat contra jém Dios iŋquímayooyi. Cuando íñixpa iga miñpa i̱t́i jém aŋjagooyi ju̱t́ d́a iwɨ̱aŋja̱m Dios (el que imaypa yɨ́p libro wɨ̱ iga icutɨɨyɨ́yiñ t́i annɨ́máypa), jesɨc miit́t́aŋwɨɨp jém naxyucmɨ de Judea, poyt́aamɨ, nɨctaamɨ co̱tsɨgaŋjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Siiga miquímne iñt́ɨcyucmɨ jém tuŋgac piso, jesɨc odoy que̱tɨ iga nɨcpa impɨc iñtraste, pero nɨcsɨm poyi̱mɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Siiga miit́t́a ca̱mjo̱m cuando immatoŋ iga núcneum jém malopɨc aŋjagooyi, jesɨc odoy se̱ttaamɨ iñt́ɨccɨɨm iga miñpa impɨc impuctu̱cu. Jemɨgam tsucumtaamɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Agui uuguyt́im jém yo̱mtam jém ma̱nɨccomcaneyajwɨɨp y jém ictsútsyajpaap jém xuxut́ tsɨ̱xt́am. Porque tsa̱m jáyaŋ yaacha̱ji miñpa. ");
INSERT INTO poiNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Aŋwejpáttaamɨ Dios iga odoy mictsɨ́yt́ámiñ jém tiempo de sucsuc cuando mipoyt́ámpa. ");
INSERT INTO poiNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Cuando núcpa jém malopɨc aŋjagooyi, tsa̱m pɨ̱mi miyaacha̱támpa. D́a nunca oypa tánix jexpɨc yaacha̱ji dende Dios iwat yɨ́p mundo. Ni ocmɨ d́a e̱ybɨc tánixpa jexpɨc yaacha̱ji. ");
INSERT INTO poiNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Jém tanJa̱tuŋ Dios d́a ijɨ́cpa iga jáypa jém malopɨc aŋjagooyi. Siiga jáypa, d́a i̱ cɨɨputpa, cucaayyajpa it́u̱mpɨy jém icupiŋneyajwɨɨp Dios. Jeeyucmɨ d́a ijɨ́cpa iga jáypa jém malopɨc aŋjagooyi. ");
INSERT INTO poiNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Siiga i̱ miñɨ́máypa iga: “Mi̱ñɨ aamɨ, yɨɨm it́ jém Cristo”, o tuŋgac miñɨ́máypa iga: “Nɨ̱gɨ aamɨ, jeexɨc it́ jém Cristo”, jesɨc odoy cupɨctaamɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Porque miñyajpa tsa̱m jáyaŋ jém mɨgoypaap. Nɨ́maŋtaaya̱p iga je jém Cristo, pero mɨgóypa. Nɨ́maŋtaaya̱p iga je jém wɨbɨc profeta. Iwatyajpa jém wɨ̱tampɨc seña y jém milagroyaj iga meega wɨa̱p imɨgóyayyajpa jém icupiŋneyajwɨɨp Dios. ");
INSERT INTO poiNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Jesɨc mimicht́am nawattamta̱jɨ cuenta porque mannɨ́mayñe t́i miñpa antes que núcpa jém ja̱ma. ");
INSERT INTO poiNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Jesɨc jém tiempo cuando nasum jém yaacha̱ji, píchpa jém ja̱ma icho̱ca. Jém po̱ya d́at́im tsocpa. ");
INSERT INTO poiNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Jém ma̱tsa jém it́wɨɨp sɨŋyucmɨ, cutɨŋyajpa. Tsa̱m tsɨgóypa it́u̱mpɨy jém it́yajwɨɨp jém ma̱tsaaŋjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Cuando nasum it́u̱mpɨy yɨ́pyaj cosa, jesɨc it́u̱mpɨy jém pɨxiñt́am iixyajpa jém Miññewɨɨp Sɨŋyucmɨ cuando miñgacpa yɨ́p naxyucmɨ. Miñpa ucsaŋjo̱m. Miñpa juuts tu̱m mɨjpɨc aŋjagooyi con Dios ipɨ̱mi. ");
INSERT INTO poiNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Cutsadayt́a̱p jém sɨŋyucmɨpɨc pɨxiñt́am icuwoyo yɨ́p naxyucmɨ iga iŋtuuma̱watyajiñ it́u̱mpɨy jém icupiŋneyajwɨɨp Dios. Nɨcyajpa hasta jém más juumɨpɨc tɨgaŋjoj iga iŋtuuma̱watyajpa it́u̱mpɨy jém ampɨxiñt́am dende sɨŋyucmɨ hasta naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Cutɨɨyɨyt́aamɨ yɨ́p ejemplo de jém tsuj. Cuando químpa jém iŋmaañay, jesɨc tanjo̱doŋ iga nocojo̱m miñpa jém cutujcɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Jesa̱pt́im cuando íñixt́ámpa iga naspa jém mannɨ́mayñewɨɨp, jesɨc iñjo̱doŋtam iga nocojo̱m it́ jém íŋaŋpɨc ja̱ma cuando amiñgacpa yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nu̱ma, mannɨ́máypa, it́u̱mpɨy yɨ́pyaj cosa naspa antes que caayajpa jém pɨxiñt́am jém it́yajwɨɨp yɨ́p naxyucmɨ cuando mojpa mi̱ñi it́u̱mpɨy yɨ́pyaj seña. ");
INSERT INTO poiNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Cuyajpa jém sɨŋ y jém nas, pero ɨch anaŋma̱t́i d́a nunca cuyajpa. ");
INSERT INTO poiNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’D́a i̱ ijo̱doŋ jup ja̱ma ni juchɨs hora núcpa it́u̱mpɨy yɨ́pyaj cosa. D́a ijo̱doŋyaj ni jém sɨŋyucmɨpɨc pɨxiñt́am ni d́at́im ijo̱doŋ jém Dios iMa̱nɨc. Icut́um ijo̱doŋ jém tanJa̱tuŋ Dios. ");
INSERT INTO poiNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Nawattamta̱jɨ cuenta, it́t́aamɨ al tanto, seguido aŋwejpáttaamɨ Dios porque d́a iñjo̱doŋtam juchɨs núcpa jém íŋaŋpɨc ja̱ma. ");
INSERT INTO poiNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Cuando núcpa jém ja̱ma jext́im juuts tu̱m pɨ̱xiñ cuando nɨcne jo̱yi juumɨ. Ichacpa it́ɨc con algunos jém imozoyaj iga iwadáyiñ cuenta. Iŋquímtsacpa jém imozoyaj. Cada tu̱mtu̱m ichi iyo̱xacuy. Ichac tu̱m iga iwatpa cuenta jém puerta. Iñɨ́máy iga id́iñ al tanto. ");
INSERT INTO poiNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Mannɨ́mayt́ámpat́im mimicht́am, it́t́aamɨ al tanto porque d́a iñjo̱doŋtam juchɨs hora amiñpa, siiga amiñpa cuando jocpiicha̱bam, o cugaptsu, o cuando aŋwejpa jém ca̱yu, o hasta cuque̱jacɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Jesɨc aŋjóctaamɨ iga odoy maŋcupiichcɨɨyt́ámiñ cuando amiñgacpa. ");
INSERT INTO poiNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Sɨɨp anaŋmadáypa it́u̱mpɨy pɨxiñt́am juuts mannɨ́mayñeta mimicht́am iga it́yajiñ al tanto. ");
INSERT INTO poiNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Togoy wɨsna ja̱ma iga naspa jém pascuasɨŋ cuando cútta̱p jém caxt́ána̱ñi sin levadura. Jesɨc jém co̱bacpɨc pa̱nijyaj entre jém escribaspɨc maestroyaj imétsyajpa jutsa̱p iyammats jém Jesús iga iccaaba. ");
INSERT INTO poiNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Pero algunos jém aŋjagooyiyaj nɨmyajpa: —D́a tammatstámpa sɨŋjo̱m iga odoy cujíñayyajiñ jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","It́ id́ɨc Jesús jém attebet Betania jém Ximoj it́ɨccɨɨm, jém cupúgayñewɨɨp id́ɨc iña̱ca. Iganam co̱ñ Jesús jém mesacɨɨm ju̱t́ wícyajpa, tu̱m yo̱mo inimiñ tu̱m tsaafrasco comne de jém wɨbɨc aceite. Naps nardo jém aceite jém tsa̱mpɨc tsoowɨ́y. Jesɨc jém yo̱mo ipo jém frasco, icutecquet jém aceite Jesús ico̱bacyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Pero algunos pɨ̱mi jóy iga iwat je̱mpɨc jém yo̱mo. Nanɨ́mayyajta̱ entre jeeyaj: —¿T́iiga it́ecmɨ̱chca yɨ́p wɨbɨc aceite? ");
INSERT INTO poiNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Meega tammáypa yɨ́p aceite, ivale más de trescientos tumiñ de plata. Jesɨc wɨa̱p tanyo̱xpát jém yaacha̱yajpaap. Jesɨc moj iwogayyaj jém yo̱mo. ");
INSERT INTO poiNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Pero Jesús iñɨ́máy: —Tsa̱cɨ yɨ́p yo̱mo. ¿T́iiga immoogɨ́ypa? Tsa̱m awɨ̱wadáy. ");
INSERT INTO poiNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Jém yaacha̱yajpaap siempre iŋwaganait́t́ámpa. Wɨa̱p iñyo̱xpátta juchɨs mich iñxunpa. Pero aɨch d́a siempre maŋwaganait́t́ámpa. ");
INSERT INTO poiNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Yɨ́p yo̱mo awɨ̱wadáy con jém iniit́wɨɨp. D́anam acaane, pero miñ acutegáy jém wɨbɨc aceite ammɨjta̱yyucmɨ juuts cuando cumta̱p tu̱m tsúts. ");
INSERT INTO poiNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nu̱ma mannɨ́máypa, ju̱t́quej aŋmatta̱p jém wɨbɨc aŋma̱t́i icuwɨ̱t́i yɨ́p naxyucmɨ, aŋmatta̱pt́im t́i awadáy yɨ́p yo̱mo iga jém pɨxiñt́am ijɨ̱syajiñ yɨ́p yo̱mo. ");
INSERT INTO poiNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Jesɨc jém Judas Iscariote, tu̱m de jém Jesús icuyujcɨɨwiñ, jém docepɨc, nɨc iniŋmat jém pa̱nij aŋjagooyi. Nɨc iwat trato jutsa̱p icɨɨjuŋcot Jesús jém aŋjagooyi icɨɨjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Jesɨc agui maymayyaj jém pa̱nij aŋjagooyiyaj cuando ijo̱dóŋa̱ t́iiga miñ jém Judas. Iñɨ́mayyaj iga ichiiyajpa tumiñ jém Judas iga icɨɨjuŋcotpa jém Jesús. Jesɨc jém Judas moj iméts jutsa̱p iwat. ");
INSERT INTO poiNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Jesɨc tsucúmum jém sɨŋ iga jém Israelpɨc pɨxiñt́am icútyajpa jém caxt́ána̱ñi jém d́apɨc inii̱ levadura. Jesɨc jém wiñt́ipɨc ja̱ma cuando accaayajta̱p jém xuxut́ borregoyaj para jém pascuasɨŋ, jém Jesús icuyujcɨɨwiñ icwácyaj, iñɨ́mayyaj: —¿Ju̱t́ iñxunpa iga nɨcpa aŋwɨ̱tsacta it́u̱mpɨy cosa iga tawíctámpa jém pascuasɨŋ? ");
INSERT INTO poiNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Jesɨc Jesús icutsat Jerusalén wɨste̱n jém icuyujcɨɨwiñ. Iñɨ́máy: —Nɨctaamɨ jém attebet Jerusalén. Jemɨc impáttámpa tu̱m pɨ̱xiñ jém ininɨcpaap tu̱m majcuy nɨ. Jesɨc túŋɨyt́aamɨ, ");
INSERT INTO poiNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","hasta tɨgɨypa tu̱m tɨcjo̱m. Nɨ́mayt́aamɨ jém tɨc io̱mi iga: “Nɨmpa jém ammaestro: ¿Ju̱t́ it́ jém cuarto ju̱t́ anacnaspa jém pascuasɨŋ con aŋcuyujcɨɨwiñ?” ");
INSERT INTO poiNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Jesɨc jém tɨc io̱mi miŋquejáypa tu̱m mɨjpɨc cuarto jém yucmɨpɨc piso. Wɨ̱tsacneum jém cuarto. Iniit́um t́it́am tansunpa. Jemɨgam wɨ̱wattaamɨ jém taŋwíccuy iga tasɨ́ŋa̱támpa. ");
INSERT INTO poiNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Jesɨc jém wɨste̱n icuyujcɨɨwiñ nɨcyaj jém attebet Jerusalén. Cuando núcyaj jemɨc, ipát jém tɨc juuts iñɨ́mayñe jém Jesús. Jesɨc jém cuarto iwatyaj jém wíccuy iga icnasyajpa jém pascuasɨŋ. ");
INSERT INTO poiNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Jesɨc tsuuya̱wum i̱t́i, núcyaj Jesús con jém doce icuyujcɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Jesɨc iganam sɨ́p iwícyaj, nɨmpa jém Jesús: —Nu̱ma mannɨ́máypa, tu̱m de mimicht́am, jém aŋwaganawícpaap, aŋcɨɨjuŋcotpa jém ánenemigo icɨɨjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Jesɨc tsa̱m aŋyácyaj jém Jesús icuyujcɨɨwiñ. Cada tu̱mtu̱m moj icwácyaj jém Jesús. Nɨmyajpa: —¿Aɨcham? ");
INSERT INTO poiNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesɨc Jesús iñɨ́máy: —Nu̱ma, tu̱m de mimicht́am, jém midocepɨc maŋcuyujcɨɨwiñ, jém aŋwaganaso̱npaap jém caxt́ána̱ñi tu̱mt́i chi̱majo̱m, jeam acɨɨjuŋcotpa. ");
INSERT INTO poiNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ɨch jém aMiññewɨɨp Sɨŋyucmɨ, tienes que accaata̱p juuts nɨmpa jém Dios iŋma̱t́i. Pero agui uuguyt́im jém pɨ̱xiñ jém acɨɨjuŋcotpaap. Más wɨ̱ meega d́a id́ɨc nay jém pɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Jesɨc iganam wícyajpa, jém Jesús imatspɨc tu̱m caxt́ána̱ñi. Cuando yaj iŋwejpát Dios, iwéc jém caxt́ána̱ñi, ichi jém icuyujcɨɨwiñ, iñɨ́máy: —Yɨ́p caxt́ána̱ñi ɨch ammɨjta̱y. Cúttaamɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ocmɨ ipɨc tu̱m copa jém uvas iñɨ. Cuando yaj iŋwejpát Dios, ichi jeeyaj. Iucyaj it́u̱mpɨyyaj. ");
INSERT INTO poiNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jesɨc Jesús iñɨ́máy jém icuyujcɨɨwiñ: —Yɨ́p ɨch annɨɨpiñ, con jeam aŋwatpa jém jo̱mipɨc trato. Antegáypa annɨɨpiñ por jáyaŋ pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nu̱ma mannɨ́máypa, d́a e̱ybɨc ánucpa jém uvas iñɨ hasta que núcpa jém ja̱ma iga ánucpa jém jo̱mipɨc vino ju̱t́ iŋjacpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Jesɨc yaj iwanyaj tu̱m wa̱ñi, nɨcyaj jém co̱tsɨcyucmɨ iñɨ̱yi Olivos. ");
INSERT INTO poiNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesɨc iñɨ́máy Jesús jém icuyujcɨɨwiñ: —Mimicht́am iñt́u̱mpɨyt́am tsa̱m micɨ̱ŋtámpa, ampoychactámpa aŋcut́um yɨ́pt́im tsuu. Porque nɨmpa así jém Dios iŋma̱t́i ju̱t́ jayñeta̱: “Accaata̱p jém pastor. Cupóyayyajpa jém iborregoyaj.” ");
INSERT INTO poiNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pero ocmɨ cuando apɨspa, jesɨc aŋjagoyñeeba annɨc jém naxyucmɨ de Galilea. ");
INSERT INTO poiNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Jesɨc jém Peto iñɨ́máy jém Jesús: —Aunque it́u̱mpɨy tsa̱m cɨ̱ŋyajpa y michacpa iŋcut́um, más aɨch d́a acɨ̱ŋpa y d́a maŋcupóyáypa. ");
INSERT INTO poiNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesɨc Jesús iñɨ́máy jém Peto: —Nu̱ma mannɨ́máypa iga yɨ́pt́im tsuu antes que wɨscɨy aŋwejpa jém ca̱yu, mimich anaŋnécpa tres veces. ");
INSERT INTO poiNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pero jém Peto duro iñɨ́máy: —Aunque tawagacaiñ con mimich, ɨch d́a manaŋnécpa. It́u̱mpɨy jém icuyujcɨɨwiñ je̱mpɨct́im nɨmyaj. ");
INSERT INTO poiNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jesɨc núcyaj tu̱m lugar iñɨ̱yi Getsemaní. Jesús iñɨ́máy jém icuyujcɨɨwiñ: —Co̱ñt́aamɨ yɨɨm iganam ɨch nɨcpa anaŋwejpát Dios. ");
INSERT INTO poiNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Jesɨc Jesús ininɨc jém Peto, Jacobo, y Xiwan uxaŋ más juumɨ. Tsa̱m pɨ̱mi aŋyácne jém Jesús, tsa̱m ijɨ̱spa ia̱namaŋjo̱m t́i iñascaaba. ");
INSERT INTO poiNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Jesɨc Jesús iñɨ́máy jém tucute̱n icuyujcɨɨwiñ: —Ɨch agui pɨ̱mi aŋyácne ána̱namaŋjo̱m hasta quénam acaatooba. Tsɨ́yt́aamɨ yɨɨm. Odoy moŋtaamɨ. Nawattamta̱jɨ cuenta. ");
INSERT INTO poiNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Jesɨc nɨc icut́um Jesús uxaŋ más juumɨ. Tocsne actɨŋ naxyucmɨ. Moj iŋwejpát Dios. Iwágáy siiga wɨa̱p, iga odoy ijɨ́guiñ iga iñascaaba jém mɨjpɨc yaacha̱ji, jém sɨɨppɨc ictsɨ́y. ");
INSERT INTO poiNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Nɨmpa Jesús: —ManJa̱tuŋ Dios, mich wɨa̱p iŋwat it́u̱mpɨy cosa. Ayo̱xpaatɨ iga odoy annascaiñ yɨ́p mɨjpɨc yaacha̱ji. Pero odoy wa̱tɨ juuts ɨch ansunpa. Wa̱tɨ juuts mich iŋwɨ̱aŋja̱m. ");
INSERT INTO poiNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ocmɨ se̱t e̱ybɨc Jesús ju̱t́ ichac jém tucute̱n icuyujcɨɨwiñ. Moŋyajpa. Iñɨ́máy jém Peto: —¿Mimoŋpa Peto? ¿Que d́a wɨa̱p imvivoja̱ ni tu̱m hora? ");
INSERT INTO poiNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Odoy moŋtaamɨ, nawattamta̱jɨ cuenta. Aŋwejpáttaamɨ Dios iga odoy i̱ wɨa̱iñ micutɨ́tsta iga micmalwattámpa. Nu̱ma jém íña̱nama iwattooba juuts ixunpa Dios, pero jém immɨjta̱y d́a iwɨ̱aŋja̱m. ");
INSERT INTO poiNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jesɨc e̱ybɨct́im nɨc iŋwejpát Dios con jeet́im aŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Jesɨc cuando se̱t Jesús ju̱t́ it́ jém icuyujcɨɨwiñ, e̱ybɨct́im moŋyajpa porque tsa̱m pɨ̱mi moŋtooba. D́a tojtooba jém iixcuy. D́a icutɨɨyɨ́ypa ju̱t́pɨc icutsoŋpa jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Jesɨc tres vecesam se̱tpa Jesús ju̱t́ it́ jém icuyujcɨɨwiñ. Ipátt́im ju̱t́ moŋyajpa. Nɨmpa Jesús: —Sɨɨp moŋtaamɨm, jejtaamɨm. Yajum aŋwat jém oración. Núcneum jém hora iga ɨch, jém aMiññewɨɨp Sɨŋyucmɨ, acɨɨjuŋcotta̱p jém malopɨc pɨxiñt́am icɨɨjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Tsucumtaamɨ, tanɨctámpam. Sɨɨp miñpa jém acɨɨjuŋcotpaap. ");
INSERT INTO poiNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesɨc jeet́i rato iganam jɨypa ixɨ jém Jesús, núc jém Judas jém it́wɨɨp id́ɨc con jém doce icuyujcɨɨwiñ. Iwaganamiñyajpa tsa̱m jáyaŋ pɨxiñt́am. Inimiñyajpa espada y jém cuy para cótsóypa. Icutsatyaj jém co̱bacpɨc pa̱nijyaj con jém escribaspɨc maestroyaj y jém wɨd́ayt́am. ");
INSERT INTO poiNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Jém Judas, jém icɨɨjuŋcotpaap Jesús, iwadáy jém pɨxiñt́am tu̱m seña. Iñɨ́máy: —Jém anaŋna̱catsútspaap jeam jém pɨ̱xiñ. Matstaamɨ, nanɨctaamɨ, d́a iñchɨcpoyt́ámpa. ");
INSERT INTO poiNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Jesɨc cuando núc jém Judas ju̱t́ it́ Jesús, icunúc, iñɨ́máy: —MamMaestro. Jesɨc iŋna̱catsútsáy ia̱cpac. ");
INSERT INTO poiNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Jesɨc matsta̱ Jesús, nanɨcta̱ preso. ");
INSERT INTO poiNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Pero tu̱m pɨ̱xiñ, jém iwaganait́wɨɨp Jesús, it́op jém espada, it́ɨŋquímáy it́a̱tsɨc jém co̱bacpɨc pa̱nij imozo. ");
INSERT INTO poiNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesɨc Jesús iñɨ́máy jém pɨxiñt́am: —¿T́iiga miñ ammatsta con espada y con cuy juuts tu̱m anúmpaap? ");
INSERT INTO poiNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Cada ja̱ma jáy accuyujooyi ma̱stɨcjo̱m y d́a nunca ammatsta. Pero sɨɨp micht́am je̱mpɨgam iŋwatta iga cupaguiñ jém Dios iŋma̱t́i ju̱t́ jayñeta̱. ");
INSERT INTO poiNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Jesɨc it́u̱mpɨy jém icuyujcɨɨwiñ ichacyaj icut́um, cupóyayyaj. ");
INSERT INTO poiNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Pero tu̱m wo̱ñjaychɨ̱xi it́úŋɨ́ypa jém Jesús. Naŋmonneta̱ con tu̱m manta. Matsta̱t́im jém wo̱ñjaychɨ̱xi. ");
INSERT INTO poiNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Pero ichac jém iŋmónóycuy, icusɨ̱cɨ poy. ");
INSERT INTO poiNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jesɨc nanɨcta̱ Jesús ju̱t́ it́ jém co̱bacpɨc pa̱nij aŋjagooyi. Jemum aŋtuuma̱yaj jém co̱bacpɨc pa̱nijyaj, con jém wɨd́ayt́am y con jém escribaspɨc maestroyaj. ");
INSERT INTO poiNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Jém Peto ijuumacpoyñe jém Jesús. Jesɨc núct́im mex je jém co̱bacpɨc pa̱nij it́ɨccɨɨm. Iwaganaco̱ñ jém policía aŋcɨɨm. Sampa jém Peto con jeeyaj jém juctɨcɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Jesɨc jém co̱bacpɨc pa̱nijyaj con jém más mɨjpɨc aŋjagooyiyaj, jém Sanhedrín, imétsyajpa tu̱m icumɨgoypaap Jesús iga accaata̱iñ. Pero d́a ipádáy jém it́áŋca. ");
INSERT INTO poiNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Tsa̱m wa̱t́i jém testigo icumɨgóypa jém Jesús, pero jeeyaj d́a tu̱mt́ia̱ jém iŋma̱t́iyaj. ");
INSERT INTO poiNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Algunos jém pɨxiñt́am te̱ñchucum iga icumɨgóypa jém Jesús. Nɨmyaj: ");
INSERT INTO poiNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Ammatoŋta yɨ́p pɨ̱xiñ iga nɨmpa: “Ɨch ammɨswatpa yɨ́p mɨjpɨc ma̱stɨc jém watneta̱wɨɨp cɨɨmɨ, jesɨc tucunaja̱ma ɨch aŋwatpa tuŋgac ma̱stɨc jém d́apɨc watne cɨɨmɨ.” ");
INSERT INTO poiNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pero jém pɨxiñt́am d́at́im tu̱mt́ia̱ jém iŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Jesɨc te̱ñchucum jém co̱bacpɨc pa̱nij jém pɨxiñt́am aŋcucmɨ. Icwácpa jém Jesús. Iñɨ́máypa: —¿Que d́a iŋcutsoŋpa t́i sɨ́p iñɨmyaj contra mimich? ");
INSERT INTO poiNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Pero jém Jesús d́a jɨypa. D́a t́i icutsoŋpa. Jesɨc e̱ybɨc jém pa̱nij aŋjagooyi icwác jém Jesús. Iñɨ́máy: —¿Que mich miCristo? ¿Que micham jém Yucmɨpɨc Dios miMa̱nɨc? ");
INSERT INTO poiNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesɨc Jesús icutsoŋ. Iñɨ́máy: —Aɨcham. Micht́am ánixt́ámpa aɨch, jém aMiññewɨɨp Sɨŋyucmɨ, cuando aco̱ñpa jém tanJa̱tuŋ Dios iŋwɨ̱mɨ. Ánixt́ámpat́im cuando amiñgacpa sɨŋyucmɨ jém ucsaŋjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Jesɨc jém co̱bacpɨc pa̱nij ichobɨychíccujac iyoot́i iga agui jóyñe. Nɨmpa: —¿T́iiga tammétspa tuŋgac testigo? ");
INSERT INTO poiNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mimicht́am immatoŋneta iga tsa̱m icujɨypa tanDios. ¿Jesɨc t́i iñjɨ̱stámpa? ¿Jup castigo tanchiiba? Jesɨc it́u̱mpɨy jém aŋjagooyiyaj nɨmyaj iga accaata̱iñ jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Jesɨc algunos moj ichujcayaj jém Jesús. Iŋmónayyaj iixcuy. Moj ixoŋyaj. Nɨ́mayt́a̱ Jesús: —Siiga nu̱ma mixabio, anɨ́maayɨ i̱ mixoŋ. Cɨɨjuŋcotta̱ Jesús jém ma̱stɨc ipolicía icɨɨjo̱m. Jeeyaj it́ojayyajpa iwiñpac. ");
INSERT INTO poiNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Jém Peto tsɨ́y naxwiñ, tsɨ́y aŋcɨɨm. Miñ tu̱m yo̱mo, jém pa̱nij aŋjagooyi imozo. ");
INSERT INTO poiNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Mu iix iga sampa jém Peto, jesɨc jém yo̱mo iámmats, iñɨ́máy: —Mich mixɨɨbat́im con jém Jesús jém Nazaretpɨc pɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Jesɨc jém Peto iŋnécpa. Nɨmpa: —D́a ánixpɨcpa jém pɨ̱xiñ. Ni d́a anjo̱doŋ t́i sɨ́p iññɨm. Jesɨc nɨc jém Peto jém puerta aŋna̱ca. Jesɨgam aŋwejpa tu̱m ca̱yu. ");
INSERT INTO poiNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Jém yo̱mo e̱ybɨct́im agui iámpa jém Peto, moj iñɨ́máy jém it́yajwɨɨp je̱m: —Yɨ́p pɨ̱xiñ tu̱m de jeeyaj. ");
INSERT INTO poiNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pero e̱ybɨct́im iŋnéc jém Peto iga d́a iixpɨcpa jém Jesús. Jesɨc ocmɨ tuŋgagam pɨ̱xiñ nɨmpa: —Nu̱ma mimich tu̱m de jeeyajpɨc. Quejpa iga Galileapɨc mipɨ̱xiñ. Je̱mpɨct́im miŋmatpa juuts jeeyaj. ");
INSERT INTO poiNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Jesɨc jém Peto pɨ̱mi jóyñe. Moj malmaljɨ̱yi. Nɨmpa: —Wɨ̱jo̱dios iga d́a ánixpɨcpa jém pɨ̱xiñ, jém miñɨmpaap. ");
INSERT INTO poiNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Jesɨc jeet́i rato e̱ybɨc aŋwej jém ca̱yu. Jém Peto ijɨ̱s t́i iñɨ́máy jém Jesús iga: “Antes que wɨscɨy aŋwejpa jém ca̱yu, mimich anaŋnécpa túccɨy iga d́a ánixpɨcpa.” Cuando ijɨ̱s jém Peto t́i iñɨ́máy jém Jesús, moj we̱ji. ");
INSERT INTO poiNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Jesɨc icuqueja̱ma aŋtuuma̱yajpa jém co̱bacpɨc pa̱nijyaj, con jém wɨd́ayt́am, con jém escribaspɨc maestroyaj y it́u̱mpɨy jém más mɨjpɨc aŋjagooyiyaj, jém Sanhedrín. Moj ijɨ̱syaj t́i wɨa̱p iwatyaj con jém Jesús. Jesɨc ocmɨ ipɨɨmɨyyaj jém ipolicía iga ichenyajiñ jém Jesús y iga nɨguiñ icɨɨjuŋcotyaj jém Pilato icɨɨjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Jesɨc jém Pilato icwácpa jém Jesús. Nɨ́mayt́a̱: —¿Que micham jém judíos miRey? Jesɨc Jesús icutsoŋ, iñɨ́máy: —Mich miñɨmpa. ");
INSERT INTO poiNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Jesɨc jém co̱bacpɨc pa̱nijyaj iñɨ́mayyaj jém Pilato iga Jesús tsa̱m pɨ̱mi imalwatne. ");
INSERT INTO poiNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Jesɨc jém Pilato e̱ybɨct́im icwác jém Jesús. Iñɨ́máy: —¿Que d́a iŋcutsoŋpa? I̱xɨ jutsaŋ quejaj ampɨctsoŋ acontra de mimich. ");
INSERT INTO poiNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pero jém Jesús d́a t́i más icutsoŋ. Jesɨc jém Pilato tɨ̱neaŋjac porque d́a jɨy jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Jém Pilato iniit́ tu̱m costumbre iga icutsɨgáypa tu̱m preso jém pascuasɨŋ. Icutsɨgáypa jém preso jém icupiŋneyajwɨɨp jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Jesɨc it́ id́ɨc cárcel tu̱m pɨ̱xiñ iñɨ̱yi Barrabás. Wagapajneyajta̱ con jém rebeldeyaj jém accaoyñeyajwɨɨp cuando ictsucumyajtɨp tu̱m bulla. ");
INSERT INTO poiNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Jesɨc aŋtuuma̱yajpa tsa̱m jáyaŋ pɨxiñt́am ju̱t́ it́ jém Pilato, mojpa iwágayyaj iga icutsɨgáyiñ tu̱m preso juuts siempre iwatpa. ");
INSERT INTO poiNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Jesɨc jém Pilato iñɨ́máy jém pɨxiñt́am: —¿Iŋwɨ̱aŋja̱mta iga aŋcutsɨgáypa jém judíos iRey? ");
INSERT INTO poiNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Jém Pilato icutɨɨyɨ́y iga jém pa̱nij aŋjagooyiyaj icɨɨjuŋcotyaj Jesús porque agui icujóyɨyyajpa. ");
INSERT INTO poiNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Jesɨc jém pa̱nij aŋjagooyiyaj moj iccujíñayyaj jém pɨxiñt́am. Iñɨ́mayyaj iga iwágáyiñ jém Pilato iga icutsɨgáyiñ jém Barrabás. ");
INSERT INTO poiNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Jesɨc jém Pilato e̱ybɨct́im iñɨ́máy jém pɨxiñt́am: —¿Jesɨc t́i iŋwɨ̱aŋja̱mta iga aŋwad́iñ con yɨɨmpɨc inicnɨɨya̱neta jém judíos iRey? ");
INSERT INTO poiNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Jesɨc e̱ybɨct́im icutsoŋyajpa. Pɨ̱mi jɨyyajpa. Nɨmyajpa: —¡Cunuuntaamɨ cunusyucmɨ! ");
INSERT INTO poiNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Jesɨc jém Pilato iñɨ́máy jém pɨxiñt́am: —¿T́iiga? ¿T́i mal iwatne? Jesɨc mást́im pɨ̱mi jɨyyajpa. Nɨmyajpa: —¡Cunuuntaamɨ cunusyucmɨ! ");
INSERT INTO poiNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Jesɨc jém Pilato ijɨ̱spa iga iwatpa juuts iwɨ̱aŋja̱myaj jém pɨxiñt́am, icutsɨgáy jém Barrabás. Ipɨɨmɨ́y iga cótsta̱iñ jém Jesús, icɨɨjuŋcot jém soldado icɨɨjo̱m iga cunúnta̱iñ cunusyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Jesɨc nanɨcta̱ Jesús jém palacio iaŋcɨɨm ju̱t́ aŋtuuma̱neyaj it́u̱mpɨy jém soldado. ");
INSERT INTO poiNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Iccámayyaj Jesús tu̱m moradopɨc puctu̱cu. It́agayyaj tu̱m a̱pit́corona, iccámayyaj ico̱bacyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Jesɨc jém soldado moj idioschiyaj jém Jesús juuts tu̱m rey. Nɨmyajpa: —Xutsóy miRey de jém judíos. ");
INSERT INTO poiNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Jesɨc icótsayyajpa Jesús ico̱bac con tu̱m cuy. Ichujcayajpa. Ico̱steeñayyajpa Jesús juuts ijɨ̱syajpa tu̱m dios. ");
INSERT INTO poiNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Jesɨc cuando yaj ixaayɨyyaj jém Jesús, accáyayt́a̱ jém moradopɨc puctu̱cu, e̱ybɨct́im accámayt́a̱ jém iyoot́i jém imɨɨchipɨc. Ocmɨ ininɨcyajum jém Jesús iga cunúnta̱iñ cunusyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Jemum na̱xi id́ɨc tu̱m Cirenepɨc pɨ̱xiñ iñɨ̱yi Ximoj. Jém ima̱nɨctam Alejandro y Rufo. Se̱t́i id́ɨc ica̱mjo̱m. Imatsyaj jém soldado, ipɨɨmɨyyaj iga ininɨgáyiñ jém Jesús icunus. ");
INSERT INTO poiNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Nanɨcta̱ Jesús tu̱m lugar iñɨ̱yi Gólgota. Nɨmtooba jém tanaŋmat́i̱mɨ, jém Tsútsco̱bacpaccɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Jesɨc chiit́a̱ Jesús jém vino namotneta̱wɨɨp con jém tsoy iñɨ̱yi mirra. Pero d́a iuc. ");
INSERT INTO poiNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Jesɨc jém soldado icunúnyaj cunusyucmɨ jém Jesús. Iwégayyaj jém Jesús ipuctu̱cu. Iwatyaj tu̱m sorteo iga iixyajiñ t́it́am ictsɨ́ypa cada tu̱mtu̱m jém soldado iga ininɨcyajpa. ");
INSERT INTO poiNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","A las nueve de la mañana micunúnta̱ Jesús cunusyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Accámayt́a̱ tu̱m letrero icunusyucmɨ iga quejiñ t́iiga accaata̱ jém Jesús. Jayñeta̱ yɨɨmpɨc: “Jém judíos iRey.” ");
INSERT INTO poiNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Jeet́im lugar cunúnyajta̱t́im cunusyucmɨ tuŋgac wɨste̱n pɨ̱xiñ, númyajpaap. Páŋayt́a̱ tu̱m jém icunus jém Jesús iŋwɨ̱mɨ y tu̱m iŋna̱ymɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Je̱mpɨgam cupac jém Dios iŋma̱t́i jém jayñeta̱wɨɨp juuts nɨmpa: “Chiit́a̱p castigo jém wɨbɨc pɨ̱xiñ juuts tu̱m criminal.” ");
INSERT INTO poiNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Jesɨc jém pɨxiñt́am nasyajpa je̱m, imalmalnɨ́mayyajpa jém Jesús. Ixiccayajpa. Iŋwɨ́ŋóyayyajpa con ico̱bac. Nɨmyajpa: —Ja̱, ¿d́a mich miñɨmpa iga wɨa̱p immɨswat jém mɨjpɨc ma̱stɨc y ocmɨ iniccupacpa e̱ybɨc en tucunaja̱ma? ");
INSERT INTO poiNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Sɨɨp nacupujta̱jɨ iñyaac. Que̱tɨ iŋcunusyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Jesɨc jém co̱bacpɨc pa̱nijyaj con jém escribaspɨc maestroyaj tsa̱m ixaayɨyyajpat́im jém Jesús. Moj nanɨ́mayyajta̱ji entre jeeyaj: —Yɨ́p pɨ̱xiñ icɨacputpa tuŋgac, pero iyaac d́a wɨa̱p inicɨacputta̱. ");
INSERT INTO poiNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Siiga yɨ́bam jém Cristo jém Rey de Israel, quetpa yɨ́pt́i rato jém icunusyucmɨ, jesɨc nu̱ma taŋcupɨctámpa. Jesɨc jém cunúnneta̱wɨɨp con Jesús imalnɨ́mayyajpat́im. ");
INSERT INTO poiNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Núc cugapja̱ma. Cupiicha̱ icuwɨ̱t́i jém naxyucmɨ. Pɨ̱mi piichɨ hasta las tres de la tarde. ");
INSERT INTO poiNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Jesɨc jeet́im hora pɨ̱mi jɨypa jém Jesús. Nɨmpa: —Eloi, Eloi, ¿lama sabactani? Taɨcht́am tanaŋmat́i̱mɨ nɨmtooba: ManDios, manDios, ¿t́iiga antsac aŋcut́um? ");
INSERT INTO poiNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Jesɨc algunos jém it́yajwɨɨp je̱m, cuando imatoŋyaj, nɨmyaj: —¿Immatoŋta? Sɨɨp iŋwejáy jém wiñɨcpɨc profeta jém Elías. ");
INSERT INTO poiNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Jesɨc tu̱m de jeeyaj poyi̱mɨ nɨc ipɨc tu̱m esponja juuts tu̱m pu̱qui, imuj con jém ta̱mpɨc vino, iccám tu̱m waycuyyucmɨ iga igucpa jém Jesús. Nɨmpa jém pɨ̱xiñ: —Joocɨnam, taŋcuixpa siiga d́a miñpa jém Elías iga icquetpa jém cunusyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesɨc pɨ̱mi aŋwej jém Jesús, caum. ");
INSERT INTO poiNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Jesɨc jém puctuctaañi jém it́wɨɨp jém mɨjpɨc ma̱stɨcjo̱m teeñaŋsaj dende sɨŋwiñ hasta naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jesɨc jém soldado icapitán jemum te̱ñ ju̱t́ cunúnneta̱ cunusyucmɨ jém Jesús. Mu imatoŋ iga aŋwejpa jém Jesús y iix jutsa̱ mu icca, nɨmpa jém capitán: —Nu̱ma, yɨ́p pɨ̱xiñ jém Dios iMa̱nɨc. ");
INSERT INTO poiNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Miñyajt́im algunos jém yo̱mtam, tsɨ́yyaj juumɨ, pero iixyaj t́i iñasca jém Jesús. It́ jém Malía Magdalena. It́t́im jém tuŋgac Malía jém segundo Jacobo y José ia̱pa. It́t́im jém yo̱mo jém Salomé. ");
INSERT INTO poiNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Yɨ́pyaj yo̱mtam it́úŋɨyyaj Jesús cuando oy i̱t́i jém naxyucmɨ de Galilea. Jemum tsa̱m iyo̱xpátyajpa, icwícyajpa jém Jesús. It́yajt́im je̱m jáyaŋ jém Galileapɨc yo̱mtam jém iwaganamiññewɨɨp Jesús Jerusalén. ");
INSERT INTO poiNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Jeet́im ja̱ma jém Israelpɨc pɨxiñt́am iwɨ̱tsacyajpa it́u̱mpɨy cosa para jém jejcuyja̱ma. Jesɨc tsuuyɨm ");
INSERT INTO poiNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","tu̱m pɨ̱xiñ iñɨ̱yi José moj ijɨ̱s iga icquedáypa cunusyucmɨ jém Jesús imɨjta̱y. Arimateapɨc pɨ̱xiñ, tsɨ́y juuts tu̱m mɨjpɨc aŋjagooyi de Israel. Tsa̱m iŋjócpat́im jém tiempo cuando Dios iŋjacpa it́u̱mpɨy jém pɨxiñt́am. Jesɨc jém José icamamwat ia̱nama, nɨc iám jém Pilato, iwágáypa permiso iga icquedáypa jém Jesús imɨjta̱y. ");
INSERT INTO poiNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Jém Pilato iŋjɨ̱sjac siiga nu̱ma caaneum jém Jesús o d́a caane. Jesɨc iŋwejáy jém capitán, icwác siiga nu̱ma caaneum. ");
INSERT INTO poiNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Cuando jém capitán nɨmpa iga nu̱ma caaneum, jesɨc jém Pilato ichi permiso jém José iga ininɨgáyiñ jém Jesús imɨjta̱y. ");
INSERT INTO poiNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Jesɨc José ijuy tu̱m jo̱mipɨc puctu̱cu, jém lino. Nɨc icquedáy jém Jesús imɨjta̱y, iŋmon con jém jo̱mpuctu̱cu, nɨc icot tu̱m tsaajosjo̱m. Watneta̱ jém tsaajos. Jesɨc ocmɨ jém José iŋjo̱pnúc jém tsaajos con tu̱m mɨjpɨc tsa. ");
INSERT INTO poiNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Jém Malía Magdalena con jém tuŋgac Malía, jém José ia̱pa, iixyaj ju̱t́ cumta̱ jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Jesɨc jém tuŋgac ja̱ma cuando nasum jém jejcuyja̱ma, jém yo̱mtam nɨc ijuy jém especia jém cɨ̱npáppɨc iga icámáypa jém Jesús imɨjta̱y. It́yaj jém Malía Magdalena, jém Salomé y jém Jacobo ia̱pa jém Malía. ");
INSERT INTO poiNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Jesɨc icuqueja̱ma, jém wiñt́ipɨc ja̱ma de jém semana, joccuquej, nɨcyaj jém tsaajoscɨɨm jém yo̱mtam. ");
INSERT INTO poiNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Iganam nɨquiyaj tuŋjo̱m jém yo̱mtam moj ijɨ̱syaj, nanɨ́mayyajta̱p: —¿Pero i̱ wɨa̱p iŋjoobáy jém mɨjpɨc tsa, jém jos aŋnúccuy? ");
INSERT INTO poiNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pero cuando núcyaj jém tsaajoscɨɨm iixyaj iga jém mɨjpɨc tsa, jém jos aŋnúccuy, aŋjoobayñeta̱wum. ");
INSERT INTO poiNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Jesɨc tɨgɨyyaj jém yo̱mtam jém tsaajosjo̱m. Jemum iixyaj iga co̱ñ tu̱m wo̱ñjaychɨ̱xi jém josjo̱m jém aŋwɨ̱mɨpɨc lado. Iccámne tu̱m yagats yoot́i agui po̱po. Jém yo̱mtam tsa̱m aŋjécyaj. ");
INSERT INTO poiNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Pero jém pɨ̱xiñ iñɨ́máy jém yo̱mtam: —Odoy cɨ̱ŋtaamɨ. Micht́am sɨ́p immétsta jém Jesús, jém Nazaretpɨc pɨ̱xiñ, jém cunúnta̱wɨɨp cunusyucmɨ. Pero sɨɨp acpɨsneta̱wum. D́am i̱ yɨɨm. Ámtaamɨ ju̱t́ tsagayñeta̱ id́ɨc jém imɨjta̱y. ");
INSERT INTO poiNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Sɨɨp nɨ̱gɨ nɨ́maayɨ jém icuyujcɨɨwiñ y jém Peto iga: “Aŋjagóypa iñɨc jém Jesús jém naxyucmɨ de Galilea. Jemɨgam íñixt́ámpa juuts miñɨ́mayñeta.” ");
INSERT INTO poiNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Jesɨc putyaj jém tsaajosjo̱m jém yo̱mtam. Nɨc poyi̱mɨ. Tsa̱m aŋjécneyaj. Agui cuetsayyajpa. D́a i̱ iŋmadayyaj t́i iñascayaj porque tsa̱m cɨ̱ŋneyaj. ");
INSERT INTO poiNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesɨc cuando acpɨsta̱wum jém Jesús, icuqueja̱ma, tsuuyt́im, jém wiñt́ipɨc ja̱ma de la semana, iwiñquejáy jém Malía Magdalena, jém it́obayñewɨɨp Jesús jém siete mal espíritu. Jém yo̱mo jém mojwɨɨp iwiñquejáy Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Jesɨc jém Malía Magdalena nɨc iám jém icuyujcɨɨwiñ. Jeeyaj agui aŋyácneyaj, agui wejyajpa. Jém Malía iŋmadayyaj iga iwiñquejayñe jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Cuando imatoŋyaj iga pɨsneum jém Jesús y iga jém Malía iixñeum, jesɨc jém Jesús icuyujcɨɨwiñ d́a icupɨcyajpa. ");
INSERT INTO poiNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Jesɨc ocmɨ Jesús iwiñquejáy wɨste̱n jém icuyujcɨɨwiñ cuando nɨcyajpa tuŋjo̱m. Aŋcacne iámooyi. D́a iixpɨcyaj. ");
INSERT INTO poiNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Jesɨc jém wɨste̱n nɨc iŋmadayyaj los de más iga pɨsneum jém Jesús, pero d́at́im icupɨcyajpa. ");
INSERT INTO poiNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Jesɨc ocmɨ iwiñquejáy Jesús jém once icuyujcɨɨwiñ iganam wícpa ixɨɨyaj. Iwogáy Jesús jém icuyujcɨɨwiñ porque tsa̱m maloyaj ia̱nama y d́a icupɨcyajpa iga acpɨsneta̱wum jém Jesús juuts nɨmyajpa jém iixñeyajwɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Iñɨ́máy jeeyaj: —Nɨctaamɨ icuwɨ̱t́i yɨ́p naxyucmɨ. Aŋmadayya̱jɨ jém wɨbɨc aŋma̱t́i it́u̱mpɨy jém pɨxiñt́am iga Dios icɨacputtooba. ");
INSERT INTO poiNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Siiga i̱ icupɨcpa jém wɨbɨc aŋma̱t́i y acchiŋta̱p, jesɨc Dios icɨacputpa. Jém d́apɨc icupɨcyajpa jém wɨbɨc aŋma̱t́i, ipɨctsoŋpa jém mɨjpɨc castigo. ");
INSERT INTO poiNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Como tu̱m seña anchiiba jém ampɨ̱mi jém acupɨcneyajwɨɨp iga wɨa̱iñ it́opyaj jém mal espíritu ɨch annɨyi̱mɨ. Wɨa̱pt́im iŋmatyaj tuŋgac aŋmat́i̱mɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Siiga imatspa tu̱m tsa̱ñ o siiga iucpa algun veneno, d́a t́i iwadáypa. Siiga ichɨgáypa ico̱bac jém mɨmneyajwɨɨp, jesɨc pɨspa. ");
INSERT INTO poiNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Jesɨc jém tánO̱mi Jesús cuando yaj iŋmadáy jém icuyujcɨɨwiñ, nanɨcta̱ sɨŋyucmɨ, nɨc co̱ñi jém tanJa̱tuŋ Dios iŋwɨ̱mɨ. ");
INSERT INTO poiNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Jesɨc jém Jesús icuyujcɨɨwiñ nɨcyajpa najɨ́yooyi ju̱t́quej. Jém tánO̱mi tsa̱m iyo̱xpát iga wɨa̱iñ iwatyaj jém milagro. Jesɨc quejpa iga Dios icutsat jém wɨbɨc aŋma̱t́i. Jemum cuyaj.");
INSERT INTO poiNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Wa̱t́i jém pɨ̱xiñ ijɨ̱s iga ijaypa t́it́am nasne aɨcht́ámaŋjo̱m juuts tu̱m historia wɨ̱tsacneta̱wɨɨp, ");
INSERT INTO poiNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","juuts taŋquejáy jém tantɨ̱wɨtam jém iixñeyajwɨɨp iixcuymɨ dende wiñt́i. Jeeyaj iwaganasɨɨba jém inimiññewɨɨp jém wɨbɨc aŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ɨch anjɨ̱spat́im iga wɨ̱ iga manjáyáypa tu̱m historia, nu̱mtsacneum. Aŋwɨ̱cɨɨpiŋ it́u̱mpɨy cosa jém nasnewɨɨp dende wiñt́i. Jeeyucmɨ sɨɨp manjáyáypa, wɨbɨc miTeófilo, ");
INSERT INTO poiNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","iga iñjo̱dóŋa̱iñ iga d́a je mɨgooyi jém miŋquejayñeta̱wɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Jesɨc jém tiempo cuando jém rey Herodes iŋjacpa Judea, it́ id́ɨc tu̱m Israelpɨc pa̱nij iñɨ̱yi Zacarías. Yo̱xa̱p id́ɨc jém mɨjpɨc ma̱stɨcjo̱m. Wagayo̱xayajpa con jém grupo de jém Abíaspɨc pa̱nijyaj. Jém iyo̱mo iñɨ̱yi Elisabet. Jém yo̱mo it́úmmɨyaj con jém wiñɨcpɨc pa̱nij Aarón. ");
INSERT INTO poiNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Icuɨstɨc iwɨ̱watyajpa tanJa̱tuŋ Dios iwiñjo̱m. Icupɨcyajpat́im Dios iŋquímayooyi y jém iŋmadayooyi. D́a i̱ wɨa̱p ipadáy jém it́áŋca. ");
INSERT INTO poiNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pero jém Zacarías con iyo̱mo d́a ma̱nɨgɨyyaj. D́a wɨa̱p iŋpɨc jém yo̱mo. Sɨɨp tsa̱miyajam icuɨstɨcyaj. ");
INSERT INTO poiNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Jesɨc tu̱m ja̱ma ictsɨ́y iturno jém Zacarías ipɨxiñt́am iga yo̱xayajpa jém mɨjpɨc ma̱stɨcjo̱m. Cupiŋta̱ jém Zacarías iga iwatpa jém pa̱nij iyo̱xacuy jém Dios iwiñjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Metsta̱ por sorteo juuts jém pa̱nij icostumbre iga iñooba jém po̱ma jém tanJa̱tuŋ Dios ima̱stɨcjo̱m jém mɨjpɨc. ");
INSERT INTO poiNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Iganam sɨ́p iño jém po̱ma, it́u̱mpɨy jém pɨxiñt́am jém it́yajwɨɨp jém ma̱stɨc aŋna̱ca iŋwejpátyajpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Jesɨc Dios icutsat tu̱m sɨŋyucmɨpɨc pɨ̱xiñ iga iwiñquejáy jém Zacarías. Iix iga jemum te̱ñ jém sɨŋyucmɨpɨc pɨ̱xiñ jém altar aŋwɨ̱mɨ ju̱t́ iñooba jém po̱ma. ");
INSERT INTO poiNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Agui ichɨgaŋjéc jém Zacarías cuando iix. Tsa̱m pɨ̱mi cɨ̱ŋ. ");
INSERT INTO poiNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Jesɨc jém sɨŋyucmɨpɨc pɨ̱xiñ iñɨ́máy: —MiZacarías, odoy cɨ̱ŋɨ. Sɨɨp mannɨ́máypa iga Dios mimatóŋayñeum cuando iŋwágáy Dios iga mima̱nɨgɨyt́ámiñ. Jeeyucmɨ ma̱nɨgɨ́ypa jém iñyo̱mo Elisabet. Icnaypa tu̱m jaychɨ̱xi, accámaayɨ iñɨ̱yi iga Xiwan. ");
INSERT INTO poiNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Mich agui mimaymáya̱p iga naypa jém imma̱nɨc. Tsa̱m iŋwɨ̱aŋja̱mta. Jáyaŋ pɨxiñt́am maymáya̱yajpat́im iga naypa yɨ́p tsɨ̱xi. ");
INSERT INTO poiNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Wɨ̱ixt́a̱p jém imma̱nɨc tanJa̱tuŋ Dios iwiñjo̱m. D́a iucpa vino ni o̱jo. Chiit́a̱p jém Dios iA̱nama cuando it́ ia̱pa ipuujo̱m. ");
INSERT INTO poiNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Jém imma̱nɨc icucagáyáypa ijɨ̱xiyaj jáyaŋ jém Israelpɨc pɨxiñt́am iga e̱ybɨc ijɨ̱syajpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Dios icutsatpa jém imma̱nɨc iga icjo̱dóŋa̱iñ jém pɨxiñt́am iga miñpa jém tánO̱mi. Jext́im ijɨ̱xi y jext́im ipɨ̱mi jém imma̱nɨc juuts jém wiñɨcpɨc aŋmat́cɨɨwiñ jém Elías. Jém imma̱nɨc iŋjɨyjacpa jém áŋa̱yajpáppɨc iga odoy áŋa̱yajiñ jém ja̱tuŋpɨc con ima̱nɨc. Iŋquejáypa jém d́apɨc icupɨcpa Dios iga icupɨcyajiñ. Iŋquejáypa jém pɨxiñt́am iga ipɨctsoŋyajiñ jém tánO̱mi cuando miñpa. ");
INSERT INTO poiNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Jesɨc jém Zacarías icwác jém sɨŋyucmɨpɨc pɨ̱xiñ. Iñɨ́máy: —¿Jutsa̱p aŋcutɨɨyɨ́y iga nu̱ma yɨɨmpɨc annɨ́máy? Ɨch tsa̱m awɨd́a̱yam, tsa̱mim mex jém anyo̱mo. ");
INSERT INTO poiNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Jesɨc jém sɨŋyucmɨpɨc pɨ̱xiñ iñɨ́máy jém Zacarías: —Ɨch aGabriel. Aŋcuyo̱xa̱p Dios. Acutsat yɨɨm iga manaŋmadáypa yɨ́p wɨbɨc aŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Pero iga d́a iŋcupɨc t́i mannɨ́máy, sɨɨp michajcaa̱p, miu̱maa̱p. D́a wɨa̱p iñjɨy hasta que naypa jém imma̱nɨc. Iññascaaba así porque d́a iŋcupɨc t́i mannɨ́máy. Cuando núcpa jém ja̱ma tienes que cupacpa juuts mannɨ́mayñe. ");
INSERT INTO poiNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Jesɨc jém pɨxiñt́am jém it́yajwɨɨp jém ma̱stɨc aŋna̱ca iŋjócyajpa jém Zacarías. D́a icutɨɨyɨyyaj t́iiga tsa̱m jáyñeum jém mɨjpɨc ma̱stɨcjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Jesɨc cuando putum jém Zacarías d́a wɨa̱p ijɨ́yáy jém pɨxiñt́am. Jesɨc icutɨɨyɨyyaj iga iix tu̱m po̱ñ ma̱stɨcjo̱m. Iwatpa seña icɨɨmɨ, pero d́a wɨa̱p ijɨy, u̱maa̱ne. ");
INSERT INTO poiNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ocmɨ cuando cupacneum jém tiempo iga iwat jém iyo̱xacuy ma̱stɨcjo̱m, se̱t jém Zacarías it́ɨccɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ocmɨ ma̱nɨgɨ́yum jém iyo̱mo Elisabet. Jesɨc tsɨ́y jém yo̱mo it́ɨccɨɨm cinco meses juuts icostumbre. Pero agui maymay jém yo̱mo. Nɨmpa: ");
INSERT INTO poiNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Tsa̱m awɨ̱wadáy jém tanJa̱tuŋ Dios porque ijo̱doŋ iga d́a awɨ̱ixyajpa jém pɨxiñt́am iga d́a ama̱nɨgɨ́ypa.” ");
INSERT INTO poiNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Cuando núcum seis meses iga ma̱nɨccomcane jém Elisabet, jesɨc Dios icutsat tu̱m sɨŋyucmɨpɨc pɨ̱xiñ, jém Gabriel, hasta tu̱m Galileapɨc attebet iñɨ̱yi Nazaret. ");
INSERT INTO poiNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Cutsatta̱ jém sɨŋyucmɨpɨc pɨ̱xiñ iga ininɨgáyiñ aŋma̱t́i tu̱m wo̱ñi iñɨ̱yi Malía. Jém wo̱ñi d́a queman ijɨypát pɨ̱xiñ. Iniit́um tu̱m trato iga napɨcyajta̱p con tu̱m pɨ̱xiñ iñɨ̱yi José, jém rey David io̱cma̱nɨc ma̱nɨc. ");
INSERT INTO poiNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Jesɨc cuando núc jém sɨŋyucmɨpɨc pɨ̱xiñ jém Malía it́ɨccɨɨm, iñɨ́máy: —¡Xutsóy, miwɨ̱ixpáppɨc jém tanJa̱tuŋ Dios! Tsa̱m miwɨ̱wadáypa más que it́u̱mpɨy jém yo̱mtam. ");
INSERT INTO poiNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Jesɨc tɨ̱neaŋjac jém Malía cuando imatoŋ t́i iñɨ́máy. Ijɨ̱spa ijɨ̱xiaŋjo̱m iga: “¿T́iiga je̱mpɨc adioschi?” ");
INSERT INTO poiNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Jesɨc jém sɨŋyucmɨpɨc pɨ̱xiñ iñɨ́máy: —Malía, odoy cɨ̱ŋɨ. Dios tsa̱m miwɨ̱ixpa. ");
INSERT INTO poiNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","D́a jáypa mima̱nɨgɨ́ypa. Iniit́pa tu̱m jaychɨ̱xi. Accámaayɨ iñɨ̱yi iga JESÚS. ");
INSERT INTO poiNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Tsa̱m iniit́pa ipɨ̱mi. Accámayt́a̱p iñɨ̱yi iga jém Yucmɨpɨc Dios iMa̱nɨc. Jém tanJa̱tuŋ Dios iccámpa juuts Rey jex juuts jém wiñɨcpɨc ija̱tuŋwe̱we jém David. ");
INSERT INTO poiNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Accámta̱p iga Rey iga it́u̱mpɨy tiempo iŋjaguiñ jém nación de Israel. D́a nunca cuyajpa ipɨ̱mi iga aŋjagooyi. ");
INSERT INTO poiNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Jesɨc jém Malía icwác jém sɨŋyucmɨpɨc pɨ̱xiñ. Iñɨ́máy: —¿Jutsa̱p amma̱nɨgɨ́y? D́anam ajaayɨ́y. D́a queman ajɨypát pɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Jesɨc jém sɨŋyucmɨpɨc pɨ̱xiñ iñɨ́máy jém Malía: —Jém Dios iA̱nama miñpa i̱t́i con mimich. Impɨctsoŋpa jém Dios ipɨ̱mi. Jeeyucmɨ d́a táŋcaɨ́y jém imma̱nɨc jém inicnaypáppɨc y accámayt́a̱p iñɨ̱yi iga Dios iMa̱nɨc. ");
INSERT INTO poiNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Sɨɨp ma̱nɨgɨ́ypat́im mex jém iñchɨ̱tsɨ jém Elisabet jém d́apɨc id́ɨc ma̱nɨgɨ́ypa. Tsa̱mim jém yo̱mo, pero núcneum seis meses iga ma̱nɨccomcane. ");
INSERT INTO poiNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Porque Dios wɨa̱p iwat it́u̱mpɨy cosa. ");
INSERT INTO poiNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Jesɨc nɨmpa jém Malía: —Sɨɨp ɨch atsɨ́ypa juuts jém tanJa̱tuŋ Dios imɨɨchi. Sɨɨp je̱mpɨgam iwad́iñ juuts mich annɨ́mayñe. Cuando yaj iŋmat jém Malía, jesɨc nɨc jém sɨŋyucmɨpɨc pɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Jesɨc jeet́im tiempo jém Malía aŋjeega nɨcpa tu̱m attebet jém naxyucmɨ de Judea jém co̱tsɨc aŋna̱ca. ");
INSERT INTO poiNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Tɨgɨy jém Zacarías it́ɨcjo̱m. Idioschiiba jém ichɨ̱tsɨ Elisabet. ");
INSERT INTO poiNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Cuando imatoŋ jém Elisabet iga idioschi jém Malía, jesɨc tsɨgóypa jém tsɨ̱xi jém Elisabet ipuujo̱m. Jém yo̱mo ipɨctsoŋ jém Dios iA̱nama. ");
INSERT INTO poiNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Jesɨc pɨ̱mi jɨy jém yo̱mo. Iñɨ́máy jém ijáyuc: —Mich más miwɨ̱wadáypa Dios que it́u̱mpɨy jém yo̱mtam. Dios tsa̱m pɨ̱mi iwɨ̱wadáypat́im jém imma̱nɨc jém inicnaypáppɨc. ");
INSERT INTO poiNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Ɨch ai̱apaap iga miñpa ajóyáy jém tánO̱mi ia̱pa? ");
INSERT INTO poiNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Cuando mich andioschi, jeet́i rato tsɨgóypa jém amma̱nɨc ampuujo̱m, agui maymay iga mimiññe. ");
INSERT INTO poiNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Agui miwɨ̱wadayñe Dios porque iŋcupɨcne iga je wɨa̱p iccupac t́i miñɨ́mayñe. ");
INSERT INTO poiNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Jesɨc nɨmpa jém Malía: Ɨch aŋcujíppa jém tanJa̱tuŋ Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Tsa̱m amaymay ána̱namajo̱m cuando anjɨ̱spa Dios jém tacɨacputpáppɨc. ");
INSERT INTO poiNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ɨch d́a ajutsaŋ, pero Dios acupiŋ iga aŋcuyo̱xa̱p, jesɨc dende sɨɨp para siempre jém pɨxiñt́am jém it́yajwɨɨp icuwɨ̱t́i yɨ́p mundo nɨmyajpa iga Dios tsa̱m awɨ̱wadayñe. ");
INSERT INTO poiNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Porque awɨ̱wadayñe jém Tsa̱mpɨc iniit́ iPɨ̱mi. Agui wɨ̱ cuáyñe jém iñɨ̱yi. ");
INSERT INTO poiNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Siempre iyaachaŋja̱mpa it́u̱mpɨy jém pɨxiñt́am jém sɨɨppɨc it́ con jém miñpáppɨc ocmɨ, jém icɨ̱ŋyajpáppɨc Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Tsa̱m iniit́ ipɨ̱mi. Wɨa̱p imɨswadáy jém pɨxiñt́am ijɨ̱xi jém nacujípta̱páppɨc. ");
INSERT INTO poiNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Iccáypa jém mɨjtampɨc aŋjagooyi jém tsa̱mpɨc iniit́ ipɨ̱mi. Iccámpa tuŋgac jém d́apɨc nacujípta̱p. ");
INSERT INTO poiNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Jém tsa̱mpɨc yua̱p icwícpa hasta cuspa. Pero jém ricoyaj jém ijɨ̱spáppɨc iga d́a t́i it́ogóyáy, d́a t́i ichiiba Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Iyo̱xpátpa jém imozo Israel. D́a ijaamaŋnotpa iga iyaachaŋja̱mpa jém ipɨxiñt́am jém icuyo̱xayajpáppɨc, ");
INSERT INTO poiNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","juuts ijɨycámáy jém tanja̱tuŋwe̱we ija̱tuŋ jém Abraham iga iyaachaŋja̱myajpa jém ima̱nɨctam para siempre. ");
INSERT INTO poiNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Jesɨc yaj iŋmat jém Malía. Jemum tsɨ́y tres meses con jém ichɨ̱tsɨ Elisabet. Ocmɨ se̱t it́ɨcmɨ jém Malía. ");
INSERT INTO poiNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Jesɨc núc jém ja̱ma iga nay jém Elisabet ima̱nɨc. Icnay tu̱m jaychɨ̱xi. ");
INSERT INTO poiNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Jesɨc cuando jém it́ɨ̱wɨtam con jém ivecinoyaj imatoŋyaj iga nay jém ima̱nɨc, icujípyajpa Dios con jém yo̱mo iga tsa̱m iyaachaŋja̱mpa. Agui maymáya̱yajpa con jém Elisabet. ");
INSERT INTO poiNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Cuando núc ocho día nayñe jém tsɨ̱xi, wadayt́a̱ jém marca de circuncisión juuts jém Israelpɨc icostumbre. Iccámayyajtooba id́ɨc iñɨ̱yi iga Zacarías juuts ija̱tuŋ. ");
INSERT INTO poiNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pero nɨmpa ia̱pa: —D́a tanaccámáypa iñɨ̱yi iga Zacarías. Tanaccámáypa iñɨ̱yi iga Xiwan. ");
INSERT INTO poiNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Jesɨc nɨmyajpa jém pɨxiñt́am: —¿T́iiga iniccámáypa iñɨ̱yi iga Xiwan porque ni tu̱m jém iñt́ɨ̱wɨtam d́a inii̱ jexpɨc iñɨ̱yi? ");
INSERT INTO poiNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Jesɨc jém it́yajwɨɨp je̱m icwácyajpa jém tsɨ̱xi ija̱tuŋ con seña. Acwácta̱ jém Zacarías jup nɨ̱yi iccámáypa jém ima̱nɨc. ");
INSERT INTO poiNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Jesɨc jém Zacarías iwác tu̱m ja̱ca to̱to. Ijaycámáy jém ima̱nɨc iñɨ̱yi to̱tyucmɨ. Nɨmpa: “Iñɨ̱yi Xiwan.” Jesɨc it́u̱mpɨy jém pɨxiñt́am agui ipooñaŋja̱myajpa. ");
INSERT INTO poiNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Jeet́i rato wɨa̱wum ijɨy jém Zacarías. Mojum icujíp Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Jesɨc mu iixyaj jém it́yajwɨɨp je̱m, pɨ̱mi cɨ̱ŋyaj. Acjo̱dóŋa̱yajta̱p t́i iñasca jém Zacarías it́u̱mpɨy jém it́yajwɨɨp jém naxyucmɨ de Judea jém co̱tsɨgaŋjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","It́u̱mpɨy jém pɨxiñt́am jém imatoŋneyajwɨɨp, tsa̱m ijɨ̱syajpa t́i iñasca jém Zacarías. Nacwácyajta̱p entre jeeyaj. Nanɨ́mayyajta̱p: —¿T́i iwatpa yɨ́p tsɨ̱xi, jesɨc mɨja̱p? Porque tsa̱m wɨ̱quejpa iga iniit́ jém Dios ipɨ̱mi. ");
INSERT INTO poiNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Jém tsɨ̱xi ija̱tuŋ, jém Zacarías, ipɨctsoŋ jém Dios iA̱nama. Moj iŋmat jém aŋma̱t́i jém ichiiñewɨɨp Dios. Nɨmpa jém Zacarías: ");
INSERT INTO poiNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Wɨ̱ iga taŋcujíptámiñ jém tanJa̱tuŋ Dios, jém Israel iO̱mi, porque miñ tacutsɨgayt́a taɨcht́am. ");
INSERT INTO poiNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Tacutsadayt́a̱ tu̱m wɨa̱paap tacɨacputta, jém wiñɨcpɨc it́úmmɨ jém David jém icuyo̱xapáppɨc tanJa̱tuŋ Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Sɨɨp tawadayt́a juuts tajɨycámayñe tsa̱m wiñɨgam cuando iŋmatyaj jém wɨbɨc profeta. ");
INSERT INTO poiNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Nɨmpa iga tacɨacputtámpa jém tánenemigoyaj icɨɨjo̱m, it́u̱mpɨy jém tajóyixyajpáppɨc. ");
INSERT INTO poiNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Tsa̱m tayaachaŋja̱mpa juuts iwadayñeyaj jém wiñɨcpɨc tantúmmɨtam. Je̱mpam ijɨ̱spa jém wɨbɨc trato jém iwatnewɨɨp wiñɨgam, ");
INSERT INTO poiNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","cuando ijɨycámáy jém Abraham, jém wiñɨcpɨc tanja̱tuŋ, ");
INSERT INTO poiNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","iga tacɨacputtámpa jém tánenemigoyaj icɨɨjo̱m iga taŋcuyo̱xatámpa Dios y d́a t́i taŋcɨ̱ŋpa, ");
INSERT INTO poiNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","iga taŋwɨ̱wattámpa tanJa̱tuŋ Dios iwiñjo̱m y tantsactámpa iga tammalwattámpa it́u̱mpɨy ja̱ma iga tait́pa vivo. ");
INSERT INTO poiNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Jesɨc jém Zacarías moj iŋmadáy jém xut́u tsɨ̱xi. Iñɨ́máy: Mich mamma̱nɨc, michɨ́ypa juuts jém yucmɨpɨc Dios iprofeta. Cuando miñpa jém tánO̱mi, miŋjagoyñeeba iññɨc iga iŋwɨ̱tsagáypa jém it́uŋ. ");
INSERT INTO poiNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Inicjo̱dóŋa̱yajpa jém Dios ipɨxiñt́am iga sɨɨp Dios iwadayt́ooba perdón jém it́áŋca iga icɨacputyajpa. ");
INSERT INTO poiNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Porque wɨbɨc tóyooyi iniit́ jém tanJa̱tuŋ Dios, tsa̱m tayaachaŋja̱mpa. Jém jɨ̱xi miñpa juuts químpa jém ja̱ma ");
INSERT INTO poiNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","sɨŋyucmɨ iga iyɨcquejpa jém it́yajwɨɨp piichcɨɨm, jém caanewɨɨp icumuŋco̱m. Miñpa taŋquejáy jém tuŋ jém nɨcpáppɨc ju̱t́ tawɨ̱ixpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Jesɨc yaj iŋmat jém Zacarías. Ocmɨ mɨja̱p jém ima̱nɨc. Tsa̱m iniit́ Dios iA̱nama, iwɨ̱cutɨɨyɨ́y t́i ixunpa Dios. Jáy i̱t́i jém tɨtsɨnaxyucmɨ ju̱t́ d́a t́i id́ɨ́yɨ́y hasta núc jém ja̱ma iga Xiwan aŋquejayt́a̱p jém Israelpɨc pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Jeet́im tiempo jém Romapɨc aŋjagooyi jém César Augusto icutsat tu̱m orde iga watta̱iñ censo it́u̱mpɨy jém naxyucmɨyaj jém iŋjacpáppɨc jém Romapɨc aŋjagooyi. ");
INSERT INTO poiNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Watta̱ jém wiñt́ipɨc censo cuando jém gobernador Cirenio iŋjacpa jém naxyucmɨ de Siria. ");
INSERT INTO poiNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Jesɨc cada pɨ̱xiñ nɨcpa nacámyajta̱ji ju̱t́ tsucum jém wiñɨcpɨc it́úmmɨyaj. ");
INSERT INTO poiNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Jeeyucmɨ se̱t Belén jém José. Porque nɨcne i̱t́i tu̱m attebet iñɨ̱yi Nazaret jém naxyucmɨ de Galilea. Pero it́ɨcmɨ jém Belén jém naxyucmɨ de Judea. Porque jemum it́ id́ɨc jém ija̱tuŋwe̱we ija̱tuŋ jém wiñɨcpɨc aŋjagooyi jém David. ");
INSERT INTO poiNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Jesɨc nɨc nacámyajta̱ji jém José con Malía jém iwatnewɨɨp trato iga aŋcoomɨyyajpa. D́anam napɨcneyajta̱ con jém José, pero jém wo̱ñi ma̱nɨccomcaneum. ");
INSERT INTO poiNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Iganam it́yaj jém Belén, núc jém tiempo iga naypa jém tsɨ̱xi. ");
INSERT INTO poiNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Jesɨc icnay Malía jém ico̱ponma̱nɨc, tu̱m jaychɨ̱xi. Iŋmon con puctu̱cu, icmoŋpa tu̱m cawajtɨcjo̱m. Como tsa̱m it́ñɨ̱m, d́a i̱ icnucs tɨc. ");
INSERT INTO poiNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","D́a más juumɨ de jém Belén it́yaj id́ɨc jém iwatyajpáppɨc cuenta jém borrego. Iŋmoŋyajpa jém iborregoyaj co̱pjo̱m iga iwatpa cuenta. ");
INSERT INTO poiNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Jesɨc jemum iwiñquejáy tu̱m sɨŋyucmɨpɨc pɨ̱xiñ jém icutsatnewɨɨp jém tanJa̱tuŋ Dios. Icunooquejpa jém tanJa̱tuŋ Dios icho̱ca ju̱t́ it́yaj jém iwatyajpáppɨc cuenta jém borrego. Jesɨc tsa̱m pɨ̱mi cɨ̱ŋyaj jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Pero jém sɨŋyucmɨpɨc pɨ̱xiñ iñɨ́máy: —¡Odoy cɨ̱ŋtaamɨ! Ɨch miñ manaŋmadáy tu̱m wɨbɨc aŋma̱t́i. Tsa̱m maymáya̱yajpa it́u̱mpɨy jém pɨxiñt́am cuando imatoŋyajpa. ");
INSERT INTO poiNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Mannɨ́máypa iga yɨ́pt́i ja̱ma nay jém Cɨacpudoypáppɨc. Je jém tánO̱mi CRISTO. Nay jém tsɨ̱xi jém David iattebet jém Belén. ");
INSERT INTO poiNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Sɨɨp juuts tu̱m seña manaŋmadáypa ju̱t́ impáttámpa jém tsɨ̱xi; aŋmonneta̱ con puctu̱cu, wo̱ne tu̱m cawajtɨcjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Iganam iŋmatpa jém sɨŋyucmɨpɨc pɨ̱xiñ, jeet́i rato miñyaj tsa̱m jáyaŋ jém sɨŋyucmɨpɨc pɨxiñt́am. Wanyajpa, icujípyajpa Dios. Nɨmyajpa: ");
INSERT INTO poiNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Sɨɨp taŋcujíptámpa jém tanJa̱tuŋ Dios jém más yucmɨpɨc it́. Sɨɨp iwɨ̱nanɨgáypa jém pɨxiñt́am jém Diospɨc iwɨ̱ixyajpa. ");
INSERT INTO poiNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Jesɨc cuando nɨcgacum sɨŋyucmɨ jém sɨŋyucmɨpɨc pɨxiñt́am, nanɨ́mayyajta̱ jém iwatyajpáppɨc cuenta jém borregoyaj: —Sɨɨp tanɨcpa jém Belén. Nɨcpa tánám t́i naspa je̱m juuts tacjo̱dóŋa̱ta jém tanJa̱tuŋ Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Jesɨc aŋjeega nɨcyaj. Cuando núcyaj, ipátyaj jém Malía con jém José, ipátyajt́im jém tsɨ̱xi wo̱ne jém cawajtɨcjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Cuando iixyaj jém tsɨ̱xi, jesɨc moj iŋmadayyaj jém it́yajwɨɨp je̱m t́i iñɨ́máy jém sɨŋyucmɨpɨc pɨ̱xiñ de jém tsɨ̱xi. ");
INSERT INTO poiNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","It́u̱mpɨy jém pɨxiñt́am ipooñaŋja̱myajpa cuando imatoŋyaj t́i iŋmatyajpa jém iwatyajpáppɨc cuenta jém borregoyaj. ");
INSERT INTO poiNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Pero jém Malía d́a ijaamaŋnotpa t́i iñɨ́mayyaj jém pɨxiñt́am. Tsa̱m ijɨ̱spa ia̱namajo̱m. ");
INSERT INTO poiNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ocmɨ se̱tgacum jém iwatyajpáppɨc cuenta jém borregoyaj. Agui maymayyaj. Iŋwejpátyajpa Dios, icujípyajpa iga wɨa̱p imatoŋyaj y iixyaj it́u̱mpɨy cosa juuts iñɨ́máy jém sɨŋyucmɨpɨc pɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Jesɨc núc ocho día iga nayñe jém tsɨ̱xi. Jém José y Malía iwadáy jém marca de circuncisión juuts jém Israelpɨc pɨxiñt́am icostumbre. Accámayt́a̱ iñɨ̱yi iga JESÚS juuts iccámáy jém sɨŋyucmɨpɨc pɨ̱xiñ cuando d́anam ma̱nɨgɨ́y jém Malía. ");
INSERT INTO poiNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ocmɨ cuando capsum jém ja̱ma iga accuáyt́a̱p jém yo̱mo, juuts nɨmpa jém Moisés iŋquímayooyi, jesɨc ininɨcyajpa Jerusalén jém xut́u tsɨ̱xi iga icwiñquejpa Dios iwiñjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Iwatyajpa je̱mpɨc porque jayñeta̱wum jém tanJa̱tuŋ Dios iŋquímayooyi iga: “Chi̱ɨ tanJa̱tuŋ Dios jém iŋco̱ponma̱nɨc, jém ja̱ypɨc, iga tsɨ́yiñ juuts jém tanJa̱tuŋ Dios imɨɨchi.” ");
INSERT INTO poiNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Jesɨc ininɨcyajt́im tu̱m sacrificio iga ichiiba Dios juuts jayñeta̱wum jém Dios iŋquímayooyi. Nɨmpa jém aŋquímayooyi: “Chi̱ɨ tanJa̱tuŋ Dios wɨste̱n cuucu o wɨste̱n ma̱ñpichona.” ");
INSERT INTO poiNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Jesɨc jeet́im tiempo it́ id́ɨc Jerusalén tu̱m pɨ̱xiñ iñɨ̱yi Ximoj. Tu̱m wɨbɨc pɨ̱xiñ. Tsa̱m ijɨ̱spa Dios. Tsa̱m iŋjócpa jém ja̱ma iga Dios icɨacputpa jém nación de Israel. Jém Ximoj tsa̱m iniit́ jém Dios iA̱nama. ");
INSERT INTO poiNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Jém Dios iA̱nama icjo̱dóŋa̱ jém Ximoj iga antes que caaba jém wɨd́a̱ya, iixpanam jém Cristo jém icutsatpáppɨc Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Jém Dios iA̱nama ichi jɨ̱xi jém Ximoj iga tɨgɨ́yiñ jém mɨjpɨc ma̱stɨcjo̱m. Jesɨc jeet́i rato núc jém José y Malía. Inimiñ ma̱stɨcjo̱m jém xut́u tsɨ̱xi iga iwadáyiñ juuts nɨmpa jém wiñɨcpɨc aŋquímayooyi. ");
INSERT INTO poiNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Jesɨc jém Ximoj iñuuspac jém tsɨ̱xi, moj icujíp Dios. Nɨmpa jém Ximoj: ");
INSERT INTO poiNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","ManJa̱tuŋ Dios, sɨɨp cupacneum juuts anjɨycámayñe wiñɨc. D́a aŋwada̱p caso siiga sɨɨp acaabam. ");
INSERT INTO poiNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Sɨɨp ɨch ánixcuymɨ ánixñe jém Cɨacpudoypáppɨc. ");
INSERT INTO poiNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Sɨɨp moj iŋwat it́u̱mpɨy jém pɨxiñt́am iwiñjo̱m icuwɨ̱t́i yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Tsɨ́y juuts tu̱m juctɨ iga iyɨcquejpa jém tuŋgac pɨxiñt́am jém d́apɨc je de Israel. Chiit́a̱pt́im jém wɨbɨc juctɨaŋtso̱ca jém Israelpɨc pɨxiñt́am jém michpɨc immɨɨchi, manJa̱tuŋ Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Jesɨc jém ia̱pa con jém José agui ipooñaŋja̱myajpa iga iñɨ́máy je̱mpɨc jém Ximoj. ");
INSERT INTO poiNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Jesɨc jém Ximoj ichi ibendición. Iñɨ́máyt́im jém Malía: —Dios tacutsadáy yɨ́p tsɨ̱xi. Tsa̱m wɨ̱it́yajpa jém icupɨcyajpáppɨc. Pero jém d́apɨc icupɨcyajpa tsa̱m yaachwatta̱p. Dios icutsat yɨ́p tsɨ̱xi juuts tu̱m señal iga icjo̱dóŋa̱p jém Israelpɨc pɨxiñt́am iga Dios tacɨacputtooba. Pero wa̱t́i jém tantɨ̱wɨtam d́a icupɨcyajpa. Tsa̱m imalmalnɨ́mayyajpa. ");
INSERT INTO poiNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Jesɨc quejpa jém malopɨc jɨ̱xi jém aŋnécnewɨɨp jém pɨxiñt́am ijɨ̱xiaŋjo̱m. Mich, miMalía, tu̱m mɨjpɨc aŋyaaqui iñja̱mpa juuts tu̱m espada icutseŋnaspa jém íña̱nama. ");
INSERT INTO poiNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Jesɨc it́t́im je̱m tu̱m cho̱mo. Dios iŋmat́cɨɨwiñ jém yo̱mo. Iñɨ̱yi Ana. Jém ija̱tuŋ iñɨ̱yi Fanuel. Jém wiñɨcpɨc it́úmmɨyaj jém tribu de Aser. Tsa̱m cho̱mom. Jém yo̱mo it́ id́ɨc con iwɨd́a̱ya siete a̱mt́ɨy dende aŋcoomɨyñe. Ocmɨ ca jém iwɨd́a̱ya. ");
INSERT INTO poiNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Pecam cuno̱ya̱ne, núcneum ochenta y cuatro a̱mt́ɨy. Sɨɨp d́a putpa de jém mɨjpɨc ma̱stɨcjo̱m. Iwatpa ayuno y oración. Icuyo̱xa̱p Dios tsuucɨɨm y sɨŋñi. ");
INSERT INTO poiNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Jeet́i rato núc jém cho̱mo ju̱t́ it́ jém tsɨ̱xi. Moj icujíp Dios iga wɨa̱ miix jém tsɨ̱xi. Ocmɨ iŋmadayyaj it́u̱mpɨy jém pɨxiñt́am iga nay jém tsɨ̱xi jém Cɨacpudoypaap. Porque jáyaŋ jém pɨxiñt́am iŋjócyajpa iga cɨacputta̱p jém attebet Jerusalén. ");
INSERT INTO poiNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Cuando jém Malía y jém José yajum iwatyaj juuts nɨmpa jém Dios iŋquímayooyi, jesɨc se̱tyaj it́ɨcmɨ jém attebet Nazaret jém naxyucmɨ de Galilea. ");
INSERT INTO poiNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Jesɨc mɨja̱p jém tsɨ̱xi. Tsa̱m iniit́ ipɨ̱mi, wɨa̱p iwat jém iyo̱xacuy. Tsa̱m jɨ̱xiɨ́y. Iniit́t́im Dios it́óyooyi. ");
INSERT INTO poiNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Cada a̱mt́ɨy nɨcyajpa jém Malía y José Jerusalén. Nɨcpa iwatyaj jém pascuasɨŋ. ");
INSERT INTO poiNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jesɨc cuando iniit́ doce ia̱mt́ɨy jém Jesús, nɨcpa sɨ́ŋa̱jiyaj Jerusalén juuts icostumbreyaj. ");
INSERT INTO poiNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Cuando cuyajum jém sɨŋ, se̱tyajpam it́ɨcmɨ. Jém jaychɨ̱xi Jesús tsɨ́y Jerusalén. Jém ia̱pa con jém José d́a ijo̱doŋ iga jemɨgam tsɨ́y jém ima̱nɨc. ");
INSERT INTO poiNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Jeeyaj iŋja̱mpa iga iwaganamiñpa jém iamigoyaj. Jesɨc moj se̱t́i. Wit́ñeyajum tu̱m ja̱ma. Jesɨc moj imétsyaj jém jaychɨ̱xi ju̱t́ it́ jém it́ɨ̱wɨtam con jém iamigoyaj. ");
INSERT INTO poiNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Pero d́a ipát, jesɨc e̱ybɨc se̱t Jerusalén iga icuámyajpa. ");
INSERT INTO poiNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Cuando nasum tucunaja̱ma, jesɨgam ipát jém Jesús jém mɨjpɨc ma̱stɨcjo̱m. Jemum wagaco̱ñyaj con jém maestroyaj de jém Israelpɨc aŋquímayooyi. Jém jaychɨ̱xi imatoŋpa jém maestroyaj, icwácpat́im jeeyaj. ");
INSERT INTO poiNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","It́u̱mpɨy jém imatoŋneyajwɨɨp agui ipooñaŋja̱myajpa iga tsa̱m jɨ̱xiɨ́y jém jaychɨ̱xi iga tsa̱m wɨa̱p icutsoŋ jém maestroyaj, acwágóypat́im mex je. ");
INSERT INTO poiNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Jesɨc jém José con jém Malía tɨ̱neaŋjac cuando iixyaj t́i iwatpa jém jaychɨ̱xi. Jém ia̱pa iñɨ́máy jém Jesús: —¿Mamma̱nɨc, t́iiga aŋwadayt́a je̱mpɨc? Jém iñja̱tuŋ con aɨch agui manjɨ̱spa porque d́a mii̱. Tsa̱m sɨ́p maŋcuámta. ");
INSERT INTO poiNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesɨc Jesús iñɨ́máy ia̱pa: —¿T́iiga aŋcuámta? ¿Que d́a iñjo̱doŋ iga tienes que aŋwatpa juuts ixunpa anJa̱tuŋ Dios? ");
INSERT INTO poiNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Pero jém Malía con jém José d́a icutɨɨyɨyyaj t́i iñɨ́máy jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Jesɨc se̱tum it́ɨcmɨ Nazaret jém Jesús con jeeyaj. Seguido iwatpa juuts ipɨɨmɨyyajpa. Jém ia̱pa tsa̱m ijɨ̱spa ia̱namaŋjo̱m t́it́am iwatpa jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ocmɨ mɨja̱p jém Jesús, más jɨ̱xiɨ́yum. Dios tsa̱m iwɨ̱ixpa. Iwɨ̱ixyajpat́im it́u̱mpɨy jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Jesɨc capsum quince a̱mt́ɨy iga iŋjacpa jém Romapɨc aŋjagooyi jém Tiberio César. Jesɨc jém Poncio Pilato iŋjacpa jém naxyucmɨ de Judea como gobernador. Jém Herodes iŋjacpa jém naxyucmɨ de Galilea. Jém Herodes it́ɨ̱wɨ jém Felipe iŋjacpa jém Iturea y jém Traconite. Jém aŋjagooyi jém Lisanias iŋjacpa jém naxyucmɨ Abilinia. ");
INSERT INTO poiNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","It́ id́ɨc wɨste̱n jém co̱bacpɨc pa̱nij aŋjagooyi jém más mɨjpɨc. Tu̱m jém Anás y tu̱m jém Caifás. Jesɨc jeet́im tiempo it́ id́ɨc jém tɨtsɨnaxyucmɨ jém Xiwan, jém Zacarías ima̱nɨc. Jemum chiit́a̱ jém Xiwan tanJa̱tuŋ Dios iŋmadayooyi. ");
INSERT INTO poiNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Jesɨc nɨcpa najɨ́yooyi icuwɨ̱t́i jém naxyucmɨ nocojo̱m jém nɨ iñɨ̱yi Jordán. Iñɨ́máy jém pɨxiñt́am: —Tsa̱cɨ iga immalwatpa. Mi̱ñɨ manacchiŋtámpa, jesɨc Dios miccáyáypa jém iñt́áŋca. ");
INSERT INTO poiNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Iwatpa jém Xiwan juuts ijaychacne librojo̱m jém Isaías jém wiñɨcpɨc profeta. Nɨmpa: Tammatoŋpa tu̱m najɨ́yoypáppɨc jém tɨtsɨnaxyucmɨ: “Áŋáyaayɨ jém tánO̱mi it́uŋ, nu̱mtsagayt́aamɨ.” ");
INSERT INTO poiNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Aŋcujnúctaamɨ jém pacusyaj, tajquettaamɨ jém co̱tsɨc y jém lumu iga nóŋa̱iñ. Nu̱mtsactaamɨ jém tuŋ jém wotnewɨɨp, aŋcujtaamɨt́im jém tuŋ icua̱ja. ");
INSERT INTO poiNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Jesɨc cuando miñpa jém taCɨacputpáppɨc, it́u̱mpɨy jém pɨxiñt́am iixyajpa jém icutsatnewɨɨp Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Jesɨc tsa̱m jáyaŋ pɨxiñt́am nɨc iámyaj jém Xiwan iga acchiŋyajta̱iñ. Pero jém Xiwan iñɨ́máy: —¿Micha̱ñt́am, i̱ micjo̱dóŋa̱ iga impóyayt́ámiñ jém tsa̱m mɨjpɨc castigo jém icmiñpáppɨc jém tanJa̱tuŋ Dios? ");
INSERT INTO poiNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Siiga nu̱ma iñchacneum jém immalajɨ̱xi, jesɨc wa̱tɨ juuts ixunpa Dios. Jesɨc quejpa iga cacneum iñjɨ̱xi. Odoy nɨmtaamɨ iga: “Ɨch d́a amalo porque jém Abraham tsɨ́y juuts ɨch anja̱tuŋwe̱we ija̱tuŋ.” Odoy nɨmtaamɨ je̱mpɨc porque Dios wɨa̱p icse̱t yɨ́p tsa juuts jém Abraham ima̱nɨctam. ");
INSERT INTO poiNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Sɨɨp Dios it́ɨŋquímtooba jém cuyyaj jém d́apɨc tɨ́ma̱p. It́ɨŋquímpa jém cuy, ocmɨ iñooquetpa. ");
INSERT INTO poiNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Jesɨc jém pɨxiñt́am icwácyajpa jém Xiwan. Nɨmyajpa: —¿T́i wɨa̱p aŋwatta iga aŋwattámpa juuts ixunpa Dios? ");
INSERT INTO poiNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Jém Xiwan iñɨ́máy jeeyaj: —Siiga iniit́ wɨste̱n iñyoot́i, jesɨc chi̱ɨ tu̱m jém d́apɨc yood́ɨ́y. Siiga iniit́ iŋwíccuy, jesɨc chi̱ɨ jém d́apɨc inii̱ iwíccuy. ");
INSERT INTO poiNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Jesɨc jém ichécyajpáppɨc impuesto miñyajt́im iga acchiŋyajta̱iñ. Icwácpat́im jém Xiwan, iñɨ́máy: —Maestro, ¿t́i wɨa̱p aŋwatta? ");
INSERT INTO poiNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Jém Xiwan iñɨ́máy: —Tseecɨ jém impuesto juuts nɨmpa jém aŋquímayooyi. Odoy tseecɨ más jáyaŋ. ");
INSERT INTO poiNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Miñyajt́im algunos jém soldado iga icwácyajpa jém Xiwan. Nɨmyaj: —¿T́i wɨa̱p aŋwatta aɨcht́am? Jém Xiwan iñɨ́máy: —Odoy tobaayɨ tu̱m pɨ̱xiñ imɨɨchi pɨ̱mi̱mɨ. Odoy cumɨgooyɨ jém pɨxiñt́am iga iñt́obáypa it́umiñ. Maymáya̱jɨ con jém iŋcoñwɨyooyi jutsaŋ miyojpa jém gobierno. ");
INSERT INTO poiNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Tsa̱m wiñɨgam iŋjócyajpa jém pɨxiñt́am iga miñpa jém Cristo jém icutsatnewɨɨp Dios. Jesɨc moj ijɨ̱syaj ijɨ̱xiaŋjo̱m, ¿tanaŋja̱m iga yɨ́p Xiwan yɨ́bam jém Cristo jém tacutsadayñewɨɨp Dios? ");
INSERT INTO poiNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Pero jém Xiwan iñɨ́máy jém pɨxiñt́am: —Ɨch manacchiŋtámpa con nɨ. Pero miñpa tuŋgac, je más pɨ̱mi wɨa̱p que aɨch, d́a wɨa̱p annasca. D́a wɨa̱p aŋcuwijáyáy jém icɨac. Jém miñpáppɨc micchiŋtámpa con Dios iA̱nama y con juctɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Icɨɨpiŋpa jém pɨxiñt́am juuts tu̱m pɨ̱xiñ icutɨ̱ppa jém trigo. Iccáypa jém trigo granerojo̱m. Nooquetta̱p jém trigo ipu̱chi juctjo̱m ju̱t́ d́a nunca píchpa. ");
INSERT INTO poiNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jesɨc jém Xiwan tsa̱m wɨ̱ najɨ́yóypa. Seguido iŋquímpa jém pɨxiñt́am iga ichacyajiñ jém malopɨc jɨ̱xi iga ipɨctsoŋyajiñ jém wɨbɨc aŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Jém Xiwan iwogáyt́im jém gobernador Herodes porque ipɨgáy jém ijáyuc jém Felipe iwɨcho̱mo. Ininɨc it́ɨccɨɨm. Iñɨ̱yi jém yo̱mo Herodías. Wogayt́a̱ jém Herodes porque tsa̱m jáyaŋ táŋca iwat. ");
INSERT INTO poiNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Jesɨc tuŋgac más malopɨc cosa iwat. Ipɨɨmɨ́y iga matsta̱iñ jém Xiwan, cotta̱p cárcel. ");
INSERT INTO poiNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Cuando acchiŋyajta̱ it́u̱mpɨy jém pɨxiñt́am, acchiŋta̱t́im mex jém Jesús. Jeet́i rato iganam iŋwejpátpa Dios, áŋáy jém sɨŋ. ");
INSERT INTO poiNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Quet Dios iA̱nama sɨŋyucmɨ. Jém pɨxiñt́am iixyaj iga quet juuts tu̱m cuucu, nu̱mmiñ, núc hasta jém Jesúsyucmɨ. Imatoŋyaj tu̱m jɨ̱yi sɨŋyucmɨ. Nɨ́mayt́a̱ Jesús: —Mich mamMa̱nɨc, mantoypáppɨc. Agui amaymay con mimich. ");
INSERT INTO poiNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jém Jesús iniit́ treinta ia̱mt́ɨy cuando moj iwat jém iyo̱xacuy. Ijɨ̱syajpa id́ɨc jém pɨxiñt́am iga Jesús ija̱tuŋ jém José. Jém ija̱tuŋwe̱we jém Helí. ");
INSERT INTO poiNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Jém Helí ija̱tuŋ jém Matat. Jém Matat ija̱tuŋ jém Leví. Jém Leví ija̱tuŋ jém Melqui. Jém Melqui ija̱tuŋ jém Jana. Jém Jana ija̱tuŋ jém José. ");
INSERT INTO poiNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Jém José ija̱tuŋ jém Matatías. Jém Matatías ija̱tuŋ jém Amós. Jém Amós ija̱tuŋ jém Nahum. Jém Nahum ija̱tuŋ jém Esli. Jém Esli ija̱tuŋ jém Nagai. ");
INSERT INTO poiNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Jém Nagai ija̱tuŋ jém Maat. Jém Maat ija̱tuŋ jém Matatías. Jém Matatías ija̱tuŋ jém Semei. Jém Semei ija̱tuŋ jém José. Jém José ija̱tuŋ jém Judá. ");
INSERT INTO poiNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Jém Judá ija̱tuŋ jém Joana. Jém Joana ija̱tuŋ jém Resa. Jém Resa ija̱tuŋ jém Zorobabel. Jém Zorobabel ija̱tuŋ jém Salatiel. Jém Salatiel ija̱tuŋ jém Neri. ");
INSERT INTO poiNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Jém Neri ija̱tuŋ jém Melqui. Jém Melqui ija̱tuŋ jém Adi. Jém Adi ija̱tuŋ jém Cosam. Jém Cosam ija̱tuŋ jém Elmodam. Jém Elmodam ija̱tuŋ jém Er. ");
INSERT INTO poiNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Jém Er ija̱tuŋ jém Josué. Jém Josué ija̱tuŋ jém Eliezer. Jém Eliezer ija̱tuŋ jém Jorim. Jém Jorim ija̱tuŋ jém Matat. ");
INSERT INTO poiNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Jém Matat ija̱tuŋ jém Leví. Jém Leví ija̱tuŋ jém Simeón. Jém Simeón ija̱tuŋ jém Judá. Jém Judá ija̱tuŋ jém José. Jém José ija̱tuŋ jém Jonán. Jém Jonán ija̱tuŋ jém Eliaquim. ");
INSERT INTO poiNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Jém Eliaquim ija̱tuŋ jém Melea. Jém Melea ija̱tuŋ jém Mainán. Jém Mainán ija̱tuŋ jém Matata. Jém Matata ija̱tuŋ jém Natán. ");
INSERT INTO poiNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Jém Natán ija̱tuŋ jém David. Jém David ija̱tuŋ jém Isaí. Jém Isaí ija̱tuŋ jém Obed. Jém Obed ija̱tuŋ jém Booz. Jém Booz ija̱tuŋ jém Salmón. Jém Salmón ija̱tuŋ jém Naasón. ");
INSERT INTO poiNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Jém Naasón ija̱tuŋ jém Aminadab. Jém Aminadab ija̱tuŋ jém Aram. Jém Aram ija̱tuŋ jém Esrom. Jém Esrom ija̱tuŋ jém Fares. Jém Fares ija̱tuŋ jém Judá. ");
INSERT INTO poiNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Jém Judá ija̱tuŋ jém Jacob. Jém Jacob ija̱tuŋ jém Isaac. Jém Isaac ija̱tuŋ jém Abraham. Jém Abraham ija̱tuŋ jém Taré. Jém Taré ija̱tuŋ jém Nacor. ");
INSERT INTO poiNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Jém Nacor ija̱tuŋ jém Serug. Jém Serug ija̱tuŋ jém Ragau. Jém Ragau ija̱tuŋ jém Peleg. Jém Peleg ija̱tuŋ jém Heber. Jém Heber ija̱tuŋ jém Sala. ");
INSERT INTO poiNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Jém Sala ija̱tuŋ jém Cainán. Jém Cainán ija̱tuŋ jém Arfaxad. Jém Arfaxad ija̱tuŋ jém Sem. Jém Sem ija̱tuŋ jém Noé. Jém Noé ija̱tuŋ jém Lamec. ");
INSERT INTO poiNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Jém Lamec ija̱tuŋ jém Matusalén. Jém Matusalén ija̱tuŋ jém Enoc. Jém Enoc ija̱tuŋ jém Jared. Jém Jared ija̱tuŋ jém Mahalaleel. Jém Mahalaleel ija̱tuŋ jém Cainán. ");
INSERT INTO poiNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Jém Cainán ija̱tuŋ jém Enós. Jém Enós ija̱tuŋ jém Set. Jém Set ija̱tuŋ jém Adán. Jém Adán ija̱tuŋ jém Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesɨc Jesús tsa̱m iniit́ jém Dios iA̱nama iganam se̱tpa de jém río Jordán. Dios iA̱nama ininɨc Jesús jém tɨtsɨnaxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Jemum nɨc i̱t́i cuarenta ja̱ma. Jém Woccɨɨwiñ miñ icutɨts iga icmalwatpa id́ɨc. Cuarenta ja̱ma d́a wíc Jesús, jesɨc núc jém cuarenta ja̱ma, pɨ̱mi yua̱. ");
INSERT INTO poiNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Jesɨc jém Woccɨɨwiñ iñɨ́máy Jesús: —Siiga nu̱ma Dios mima̱nɨc, acse̱tɨ yɨ́p tsa iga caxt́ána̱ñi. ");
INSERT INTO poiNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesɨc jém Jesús iñɨ́máy jém Woccɨɨwiñ: —Nɨmpa jém Dios iŋma̱t́i, jém jayñeta̱wɨɨp: “D́a no más iga iŋcútpa caxt́ána̱ñi miit́pa. Tamatspacpat́im it́u̱mpɨy jém Dios iŋma̱t́i.” ");
INSERT INTO poiNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ocmɨ jém Woccɨɨwiñ ininɨc jém Jesús tu̱m mɨjpɨc co̱tsɨcyucmɨ. Tu̱mt́i rato iŋquejáy it́u̱mpɨy jém naxyucmɨyaj icuwɨ̱t́i de jém mundo ju̱t́ iŋjacyajpa jém aŋjagooyiyaj. ");
INSERT INTO poiNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Jesɨc jém Woccɨɨwiñ iñɨ́máy jém Jesús: —It́u̱mpɨy yɨ́pyaj naxyucmɨyaj ɨch ammɨɨchi. Sɨɨp manchiiba mich porque ɨch acɨɨjuŋcodayñeta̱. I̱ ansunpa iga anchiiba, wɨa̱p anchi. Jesɨc it́u̱mpɨy jém pɨxiñt́am micujípyajpa iga más mɨjpɨc miŋjagooyi. ");
INSERT INTO poiNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Siiga mich aŋco̱steeñáypa y anjɨ̱spa juuts ɨch adios, jesɨc immɨɨchi it́u̱mpɨy jém manaŋquejayñewɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Pero Jesús iñɨ́máy: —Nɨcsɨm, miWoccɨɨwiñ. Jayñeta̱wum jém Dios iŋma̱t́i: “Wɨ̱ iga tanjɨ̱spa tanJa̱tuŋ Dios, je icut́um taŋcuyo̱xa̱p.” ");
INSERT INTO poiNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ocmɨ jém Woccɨɨwiñ ininɨc jém Jesús Jerusalén. Iniquím jém mɨjpɨc ma̱stɨc iŋco̱bac. Jém Woccɨɨwiñ iñɨ́máy Jesús: —Siiga Dios mima̱nɨc, yóyaŋque̱tɨ hasta naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Porque jayñeta̱wum jém Dios iŋma̱t́i iga: Dios icutsatpa jém sɨŋyucmɨpɨc pɨxiñt́am iga miwad́iñ cuenta ");
INSERT INTO poiNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","iga mimatstsoŋpa icɨɨjo̱m iga odoy coowa̱iñ impuy tsaayucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Pero Jesús iñɨ́máy jém Woccɨɨwiñ: —Nɨmpat́im jém Dios iŋma̱t́i: “Odoy cutɨɨtsɨ jém tanJa̱tuŋ Dios siiga nu̱ma wɨa̱p.” ");
INSERT INTO poiNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Jesɨc jém Woccɨɨwiñ yaj icutɨts jém Jesús iga icmalwatpa id́ɨc. Ipoychac hasta tuŋgac ja̱ma. ");
INSERT INTO poiNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesɨc se̱t e̱ybɨc Galilea jém Jesús. Tsa̱m iniit́ jém Dios iA̱nama iga wɨa̱p iwat juuts ixunpa Dios. Waŋpa icuwɨ̱t́i jém naxyucmɨ de Galilea iga se̱tne jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jesɨc cada tɨgaŋjoj jém Jesús nɨcpa accuyujooyi jém sinagoga, jém judíos ima̱stɨc. Jeeyaj tsa̱m icujípyajpa. ");
INSERT INTO poiNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jesɨc tu̱m ja̱ma núc Jesús jém attebet Nazaret ju̱t́ mɨja̱. Jesɨc jém jejcuyja̱ma, tɨgɨy jém sinagoga juuts icostumbre. Te̱ñchucum jém Jesús iga imaypa jém Dios iŋma̱t́i jém jayñewɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Chiit́a̱ Jesús jém libro, jém ijaychacnewɨɨp jém profeta Isaías, iga imaypa. Jesɨc Jesús íŋáy jém libro, ipát ju̱t́ jayñeta̱: ");
INSERT INTO poiNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Tsa̱m anait́ jém Dios iA̱nama, achiiñeta̱ iga anaŋmadáyiñ jém wɨbɨc aŋma̱t́i jém yaacha̱neyajwɨɨp. Acutsatta̱ iga anacpocsáyiñ ia̱nama jém aŋyácneyajwɨɨp. Acutsatta̱ iga anaŋmadáyiñ jém presoyaj iga cutsɨgayyajta̱p y jém cácht́iyaj iga acpɨsyajta̱p. Acutsatta̱ iga anaccutsɨgáypa jém pɨxiñt́am jém tsa̱mpɨc malwadayñeyajta̱. ");
INSERT INTO poiNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Acutsatta̱ iga anaŋmatpa jém aŋma̱t́i iga núcneum jém a̱mt́ɨy iga Dios iwɨ̱wadáypa jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jesɨc Jesús iŋnúc jém libro, ichi jém maestro imozo. Jesɨc co̱ññeactɨŋ jém Jesús. It́u̱mpɨy jém it́yajwɨɨp jém sinagoga agui iámyajpa. ");
INSERT INTO poiNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Jesɨc Jesús moj iŋmadáy jém pɨxiñt́am. Nɨmpa: —Yɨ́bam ja̱ma íñixt́ámpa iga cupacneum yɨ́p aŋma̱t́i jém jayñewɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Jesɨc it́u̱mpɨy jém pɨxiñt́am agui iwɨ̱aŋja̱myaj jém Jesús. Agui ipooñaŋja̱myaj cuando imatoŋyaj jém wɨbɨc aŋma̱t́i jém iŋmatnewɨɨp Jesús. Jesɨc moj nanɨ́mayyajta̱ji: —¿Que d́a yɨ́bam jém José ima̱nɨc? ");
INSERT INTO poiNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesɨc Jesús iñɨ́máy jém pɨxiñt́am: —Ɨch anjo̱doŋ iga mimicht́am sɨ́p annɨ́máypa tu̱m refran: “¿Michóyɨ́yoypáppɨc t́iiga d́a minitsóyɨyt́a̱p iñyaac?” Annɨ́mayt́ámpat́im iga: “Wa̱tɨ yɨɨm iñt́ɨcmɨ jém wɨ̱tampɨc cosa juutst́im iŋwatne jém Capernaum.” ");
INSERT INTO poiNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Iñɨ́máyt́im jeeyaj: —Wɨ̱pɨctsoŋta̱p tu̱m profeta tuŋgac attebet, pero cuando nɨcpa najɨ́yooyi it́ɨcmɨ, jesɨc jém it́ɨ̱wɨtam d́a iwɨ̱pɨctsoŋyajpa. ");
INSERT INTO poiNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Nu̱ma, mannɨ́máypa iga wiñɨgam it́ id́ɨc jém naxyucmɨ de Israel tsa̱m jáyaŋ jém yo̱mtam jém cuno̱yt́am cuando najɨ́yóypa jém Dios iŋmat́cɨɨwiñ jém Elías. Jeet́im tiempo cuando d́a chijóy tuj tres año y seis meses. Jesɨc tɨgɨy tu̱m mɨjpɨc yuu it́u̱mpɨy jém attebetyaj icuwɨ̱t́i jém naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pero Dios d́a icutsat jém Elías iga iyo̱xpád́iñ jém Israelpɨc yo̱mtam jém cuno̱yt́am. Dios icutsat jém Elías iga iyo̱xpád́iñ jém tuŋgac cuno̱ya jém d́apɨc je taɨch yo̱mo. Jém yo̱mo Sareptapɨc yo̱mo de jém naxyucmɨ de Sidón. ");
INSERT INTO poiNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","It́t́im id́ɨc jém naxyucmɨ de Israel tsa̱m jáyaŋ pɨxiñt́am jém cupúgayñewɨɨp iña̱ca cuando iŋmatpa jém wiñɨcpɨc aŋmat́cɨɨwiñ jém Eliseo. Pero jém Eliseo d́a icpɨs ni tu̱m de jeeyaj. Nada más icpɨs jém Naamán tu̱m Siriapɨc pɨ̱xiñ, d́a je taɨch pɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jesɨc tsa̱m pɨ̱mi jóyyaj it́u̱mpɨy jém it́yajwɨɨp jém sinagoga cuando imatoŋyaj t́i nɨmpa jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Tsucumyaj jém pɨxiñt́am, iquebacputyaj jém Jesús aŋsɨ̱cmɨ de jém attebet, nanɨcta̱ tu̱m tejajyucmɨ ju̱t́ watneta̱ jém attebet. Jemum icyágɨyyajtooba id́ɨc jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pero wid́aŋnaspa Jesús jém pɨxiñt́am aŋcucmɨ. D́a i̱ wɨa̱ miimats. Nɨc jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jesɨc nɨc Jesús jém attebet Capernaum, jém naxyucmɨ de Galilea. Jemum cada jejcuyja̱ma nɨcpa iŋquejáy jém Dios iŋma̱t́i jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Tsa̱m ipooñaŋja̱myajpa cuando imatoŋyajpa t́i iŋquejáypa jém Jesús. Porque aŋmatpa juuts tu̱m aŋjagooyi. ");
INSERT INTO poiNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Jesɨc jém sinagoga it́ tu̱m pɨ̱xiñ imatsne tu̱m mal espíritu. Pɨ̱mi aŋwejpa, nɨ́mayt́a̱ Jesús: ");
INSERT INTO poiNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Atsa̱cɨ, miJesús miNazaretpɨc, ¿t́iiga ammoogɨ́ypa? ¿Que miñpa anactogoyt́a? Mánixpɨcpa, anjo̱doŋ iga mich jém Yucmɨpɨc Dios miMɨɨchi. ");
INSERT INTO poiNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesɨc Jesús iwogáy jém mal espíritu. Iñɨ́máy: —Odoy jɨ̱yɨ. Pu̱tɨ yɨ́p pɨ̱xiñ ia̱namaŋjo̱m. Jesɨc jém mal espíritu iccutɨŋ jém pɨ̱xiñ naxyucmɨ jeeyaj iwiñjo̱m. Put jém mal espíritu, d́a t́i iwadáy. ");
INSERT INTO poiNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","It́u̱mpɨy jém it́yajwɨɨp agui aŋjécyaj. Nanɨ́mayyajta̱p entre jeeyaj: —¿T́iapaap yɨ́p aŋmadayooyi? Yɨ́p pɨ̱xiñ iŋmatpa juuts tu̱m aŋjagooyi. Con ipɨ̱mi wɨa̱p it́op jém mal espíritu. ");
INSERT INTO poiNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Jesɨc waŋpa ju̱t́ quej icuwɨ̱t́i jém naxyucmɨ t́i iwat jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesɨc put Jesús jém sinagoga. Nɨc jém Peto it́ɨccɨɨm. Mɨmne actɨŋ jém Peto imɨɨda̱pa. Tsa̱m pɨ̱mi jawaŋɨ́y. Icunucsayyaj jém Jesús iga icpɨxiñ jém yo̱mo. ");
INSERT INTO poiNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jesɨc nocojo̱m te̱ñ jém Jesús ju̱t́ wo̱ne jém yo̱mo. Iŋjɨyjac jém jawaŋ. Jém yo̱mo ichac jém jawaŋ, jeet́i rato tsucum, moj icwíc jém miññeyajwɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Jesɨc cuando tɨgɨ́yum ja̱ma, jém pɨxiñt́am inimíñayyaj Jesús it́u̱mpɨy jém mɨmneyajwɨɨp. Jesɨc Jesús ichɨccunúgáy ico̱bac cada tu̱mtu̱m. Je̱mpɨgam icpɨsyaj it́u̱mpɨy. ");
INSERT INTO poiNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Tobayyajta̱pt́im jém mal espíritu wa̱t́i jém pɨxiñt́am ia̱namaŋjo̱m. Agui aŋwejpa cuando putyaj. Nɨ́mayt́a̱ jém Jesús: —Mich jém Dios miMa̱nɨc. Pero Jesús iwogáy jém mal espíritu. D́a ijɨ́cpa iga jɨypa porque jém mal espíritu ijo̱dóŋa̱yaj iga je jém Cristo. ");
INSERT INTO poiNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Jesɨc cuquejtooba, put Jesús jém attebet. Nɨc tu̱m lugar ju̱t́ d́a t́i id́ɨ́yɨ́y. Pero jém pɨxiñt́am, jém it́yajwɨɨp jém attebet, tsa̱m imétsyaj, icunúcyaj. Icunucsayyaj iga tsɨ́yiñ con jeeyaj. ");
INSERT INTO poiNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pero Jesús iñɨ́máy: —Tienes que anaŋmadáypa jém tuŋgac attebetyaj jém wɨbɨc aŋma̱t́i ju̱t́pɨc iŋjacpa Dios jém it́yajwɨɨp yɨ́p naxyucmɨ. Jeeyucmɨ acutsat Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Jesɨc Jesús nɨcpa najɨ́yooyi it́u̱mpɨy jém sinagoga icuwɨ̱t́i jém naxyucmɨ de Galilea. ");
INSERT INTO poiNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Jesɨc tu̱m ja̱ma oy iŋmat Jesús jém Dios iŋma̱t́i tu̱m laguna aŋna̱ca. Jém laguna iñɨ̱yi Genesaret. Tsa̱m jáyaŋ pɨxiñt́am y yo̱mtam miñ imatoŋyaj hasta nacpɨtsɨyyajta̱p. ");
INSERT INTO poiNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jesɨc Jesús iix wɨste̱n barco playa aŋna̱ca. Putneyaj io̱mi. Icheeyajpa jém ired nɨaŋna̱ca. ");
INSERT INTO poiNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jesɨc núc Jesús ju̱t́ it́ jém barco, quím barcoyucmɨ. Imɨɨchi jém Peto. Jesɨc Jesús iñɨ́máy iga icnɨguiñ uxaŋ jojmɨ jém ibarco. Jesɨc co̱ñ Jesús jém barcoyucmɨ. Moj iŋquejáy jém pɨxiñt́am jém Dios iŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Cuando yajum najɨ́yooyi, iñɨ́máy jém Peto: —Nanɨ̱cɨ imbarco ju̱t́ jojmɨ jém nɨ. Patscuumɨ jém iñred nɨɨcɨɨm. Tammatspa tɨɨpɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Jém Peto iñɨ́máy: —MamMaestro, mu̱ma tsuu ayo̱xata, d́a ammatsta ni tu̱m tɨɨpɨ. Pero siiga mich miñɨmpa, aŋcotpa e̱ybɨc jém anred. ");
INSERT INTO poiNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Jesɨc mu icotum jém ired, imatsyaj tsa̱m jáyaŋ tɨɨpɨ hasta jactɨp jém ired. ");
INSERT INTO poiNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Jesɨc jém Peto iwadáy seña jém it́ɨ̱wɨtam jém it́yajwɨɨp jém tuŋgac barcojo̱m iga míñiñ iyo̱xpát. Jesɨc miñyaj, icucomyaj icuɨstɨc jém barco hasta cumoŋtooba. ");
INSERT INTO poiNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Mu iix, jém Peto ico̱steeñáy jém Jesús ipuycɨɨm, iñɨ́máy: —MánO̱mi, acupóyaayɨ porque tsa̱m atáŋcaɨ́y. ");
INSERT INTO poiNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Jém Peto con jém it́yajwɨɨp ibarcojo̱m agui ámaŋjacyaj iga imatsyaj tsa̱m jáyaŋ jém tɨɨpɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Agui ámaŋjacyajt́im jém it́yajwɨɨp jém tuŋgac barcojo̱m, jém Jacobo con jém Xiwan, jém Zebedeo ima̱nɨctam. Jeeyaj iwaganayo̱xayajpa jém Peto. Jesɨc Jesús iñɨ́máy jém Peto: —Odoy cɨ̱ŋɨ, tsa̱cɨm iga immatspa tɨɨpɨ. Nɨcpa tamméts pɨ̱xiñ juuts tɨɨpɨ iga icupɨcyajiñ jém Dios iŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Jesɨc ininɨcyaj ibarco nɨaŋna̱ca. Ichacyaj it́u̱mpɨy jém iniit́wɨɨp. Nɨc it́úŋɨyyaj jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Cuando it́ Jesús jém tuŋgac attebet, ictsɨ́y tu̱m pɨ̱xiñ tsa̱m cupúgayñe iña̱ca. Mu iix Jesús, jém pɨ̱xiñ ico̱steeñáy ipuycɨɨm. Icunucsáypa iga icpɨxiñ. Nɨ́mayt́a̱: —MánO̱mi, siiga iŋwɨ̱aŋja̱m, acpɨ̱sɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesɨc Jesús ichɨccunúc jém pɨ̱xiñ, iñɨ́máy: —Aŋwɨ̱aŋja̱m. Micuáyñeum. Jesɨc jeet́i rato ichacum jém pɨ̱xiñ ipuuca, wɨ̱tsɨ́yum. ");
INSERT INTO poiNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jesɨc Jesús iñɨ́máy jém pɨ̱xiñ: —Odoy i̱ aŋmadaayɨ iga ɨch manacpɨs, pero nɨ̱gɨ wiñquejaayɨ jém pa̱nij iga iŋquejáyiñ iga nu̱ma mipɨsneum. Jesɨc ocmɨ chi̱ɨ Dios tu̱m ofrenda juuts nɨmpa jém Moisés iŋquímayooyi iga miixt́a̱p iga nu̱ma mipɨsneum. ");
INSERT INTO poiNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pero ju̱t́quej waŋpa iga acpɨsóypa jém Jesús. Aŋtuuma̱yajpa tsa̱m jáyaŋ pɨxiñt́am iga imatoŋyajpa jém Jesús iŋmadayooyi. Miñyaj jém mɨmneyajwɨɨp iga acpɨsyajta̱iñ. ");
INSERT INTO poiNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Pero put Jesús jém attebet, nɨc icut́um ju̱t́ d́a t́i id́ɨ́yɨ́y iga iŋwejpátpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Jesɨc tu̱m ja̱ma cuando accuyujóypa Jesús, co̱ñyajt́im je̱m jém fariseoyaj con jém maestroyaj de jém wiñɨcpɨc aŋquímayooyi. Jeeyaj miñyaj de it́u̱mpɨy jém tɨgaŋjojyaj de jém naxyucmɨ de Galilea y Judea. Miñyajt́im de jém attebet Jerusalén. Jém Jesús tsa̱m iniit́ jém Dios ipɨ̱mi. Wɨa̱p icpɨs jém mɨmneyajwɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Jesɨc núcyaj jute̱n jém pɨ̱xiñ, icópneyaj tseesyucmɨ tu̱m pɨ̱xiñ tsa̱m mɨmne. Tusacane icumu̱ma, d́a tsɨgóypa. Tɨgɨyt́ooba id́ɨc jém tɨcjo̱m iga iámpa jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pero d́a ipátyaj ju̱t́ wɨa̱p it́ɨgɨy porque tsa̱m it́ñɨ̱m. Jesɨc químyaj jém tɨcyucmɨ, ijetyaj jém tɨc iñecxi. Ijɨ́mquetyaj tseesyucmɨ jém mɨmnewɨɨp jém Jesús iwiñjo̱m jém pɨxiñt́am aŋcucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesɨc cuando iix Jesús iga tsa̱m icupɨcyajpa jeeyaj, iñɨ́máy jém mɨmnewɨɨp: —Mipɨ̱xiñ, miwadayñeta̱ perdón jém iñt́áŋca. ");
INSERT INTO poiNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Jesɨc jém escribaspɨc maestroyaj con jém fariseoyaj ijɨ̱syajpa ijɨ̱xiaŋjo̱m iga: “¿Que i̱apaap yɨ́p pɨ̱xiñ? Sɨ́p icujɨy tanDios. Porque Dios icut́um wɨa̱p taccáyáy tantáŋca.” ");
INSERT INTO poiNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Pero Jesús ijo̱doŋ t́i sɨ́p ijɨ̱syaj ijɨ̱xiaŋjo̱m, jesɨc iñɨ́máy jeeyaj: —¿T́iiga iñjɨ̱stámpa je̱mpɨc? ");
INSERT INTO poiNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Jup más d́a táŋca iga annɨ́máypa yɨ́p pɨ̱xiñ iga: “Miwadayñeta̱ perdón jém iñt́áŋca”, o iga annɨ́máypa: “Tsucu̱mɨ, wi̱t́ɨm”? ");
INSERT INTO poiNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Sɨɨp manaŋquejáypa iga jém Miññewɨɨp Sɨŋyucmɨ nu̱ma iniit́ jém pɨ̱mi iga wɨa̱p iccáyáy jém pɨxiñt́am it́áŋca yɨ́p naxyucmɨ. Jesɨc Jesús iñɨ́máy jém pɨ̱xiñ jém tusacanewɨɨp: —Mannɨ́máypa, tsucu̱mɨm, pi̱ŋɨm jém iñchees, nɨcsɨm iñt́ɨccɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Jesɨc iganam iámyajpa jém it́yajwɨɨp, jeet́i rato tsucum jém pɨ̱xiñ. Ipiŋum jém ichees ju̱t́ wo̱ne id́ɨc. Nɨc it́ɨcmɨ. Tsa̱m icujíppa Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","It́u̱mpɨy jém pɨxiñt́am ipooñaŋja̱myaj. Icujípyajpat́im Dios. Tsa̱m cɨ̱ŋyaj. Nanɨ́mayyajta̱p: —Yɨ́p ja̱ma tánixt́a tu̱m cosa d́apɨc queman oypa tánix. ");
INSERT INTO poiNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Cuando cuyaj jém asunto, moj nɨqui jém Jesús. Iix tu̱m pɨ̱xiñ jém ichécpáppɨc impuesto, iñɨ̱yi Leví. Co̱ñ ju̱t́ ichécpa jém impuesto. Jesús iñɨ́máy jém pɨ̱xiñ: —Atúŋɨɨyɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Jesɨc tsucum jém pɨ̱xiñ, ichac jém iyo̱xacuy, nɨc it́úŋɨ́y jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Jesɨc ocmɨ jém Leví inisɨ́ŋa̱p jém Jesús it́ɨccɨɨm. Tu̱m mɨjpɨc sɨŋ iwat. Aŋwejayyajta̱ tsa̱m jáyaŋ jém ichécyajpáppɨc impuesto con tuŋgac más jém pɨxiñt́am. Iwaganawícyajpa jém Jesús mesacɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Jesɨc jém fariseoyaj con jém maestroyaj de jém fariseo iŋquímayooyi moj iŋwejcayaj jém Jesús icuyujcɨɨwiñ. Nɨ́mayyajta̱p: —¿T́iiga miwagawíctámpa y miwaganɨ́ctámpa con jém ichécyajpáppɨc impuesto y con jém tuŋgac táŋcaɨywɨɨp? ");
INSERT INTO poiNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesɨc Jesús iñɨ́máy jém fariseoyaj: —Jém d́apɨc mɨmne d́a ixunpa jém tsóyɨ́yoypaap. Pero jém mɨmneyajwɨɨp ixunpa jém tsóyɨ́yoypaap. ");
INSERT INTO poiNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ɨch d́a amiñ iga anaŋwejáypa jém d́apɨc táŋcaɨ́y. Amiñ iga anaŋwejáypa jém táŋcaɨywɨɨp iga ichacyajiñ jém it́áŋca. ");
INSERT INTO poiNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Jesɨc jém miññeyajwɨɨp icwácyaj jém Jesús. Nɨ́mayt́a̱: —¿T́iiga jém Xiwan icuyujcɨɨwiñ con jém fariseoyaj siempre iwatyajpa ayuno, iwatyajpa jém oración? Pero mich jém iŋcuyujcɨɨwiñ siempre wícyajpa, nɨ́cyajpa, d́a iwatyajpa ayuno. ");
INSERT INTO poiNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesɨc Jesús iñɨ́máy jeeyaj: —Siempre wícyajpa ju̱t́ aŋcoomɨ́yoyñɨ̱mpa. D́a i̱ iwatpa ayuno cuando it́ jém yoomɨypaap. ");
INSERT INTO poiNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pero núcpa ja̱ma cuando d́a i̱ jém yoomɨypaap. Jesɨc nu̱ma iwatyajpa ayuno. ");
INSERT INTO poiNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jesɨc Jesús iŋmadayyaj jém pɨxiñt́am tu̱m xut́u cuento. Iŋquejáypa jém pɨxiñt́am iga jém jo̱mipɨc jɨ̱xi jém inimiññewɨɨp Jesús d́a iwɨ̱nanɨgáypa jém wiñɨcpɨc jɨ̱xi. Nɨmpa Jesús: —D́a i̱ ijacpa tu̱m jo̱myoot́i iga iŋtótspa tu̱m pecapɨc yoot́i. Siiga iwatpa je̱mpɨc, mɨ̱sa̱p jém jo̱myoot́i. Jém jo̱mipɨc puctu̱cu d́at́im iwɨ̱nacutɨŋpa jém pecapɨc. ");
INSERT INTO poiNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","D́a i̱ icotpa jo̱mvino jém pecapɨc cuerobolsajo̱m. Porque siiga iwatpa je̱mpɨc, jesɨc pɨ̱pa jém jo̱mvino, tojaŋsajpa jém pecapɨc cuerobolsa. Tegáypa jém vino. Togoypa jém cuerobolsa. ");
INSERT INTO poiNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Jeeyucmɨ cotta̱p jém jo̱mvino jém jo̱mipɨc cuerobolsajo̱m. ");
INSERT INTO poiNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Nu̱ma, jém iucpáppɨc jém pecapɨc vino d́a iuctooba jém jo̱mvino porque nɨmpa iga: “Wɨ̱ jém pecapɨc.” ");
INSERT INTO poiNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Tu̱m jejcuyja̱ma wid́aŋnaspa Jesús ju̱t́ ñipneta̱ jém trigo. Jém icuyujcɨɨwiñ iju̱dayyajpa jém trigo ipac, icútyajpa. ");
INSERT INTO poiNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Jesɨc algunos jém fariseoyaj iwogayyaj jém Jesús icuyujcɨɨwiñ. Nɨ́mayt́a̱: —¿T́iiga iŋwattámpa contra jém tanaŋquímayooyi jém jejcuyja̱ma? ");
INSERT INTO poiNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesɨc Jesús iñɨ́máy jém fariseoyaj: —¿Que d́a queman immay t́i iwat jém David cuando tsa̱m yua̱yajpa con jém icompañeroyaj? ");
INSERT INTO poiNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Tɨgɨy David jém Dios it́ɨcjo̱m. Ipɨc jém caxt́ána̱ñi jém tsacneta̱wɨɨp altaryucmɨ. Icút jém David, ichiit́im jém icompañeroyaj. Tanjo̱doŋ iga jém tanaŋquímayooyi nɨmpa iga nada más jém pa̱nij wɨa̱p icút jém caxt́ána̱ñi jém tsacneta̱wɨɨp altaryucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jesɨc ocmɨ jém Jesús iñɨ́máy jém fariseoyaj: —Jém Miññewɨɨp Sɨŋyucmɨ imɨɨchit́im jém jejcuyja̱ma, wɨa̱p iñɨ́máy jém pɨxiñt́am t́i wɨa̱p iwatyaj jém jejcuyja̱ma. ");
INSERT INTO poiNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Jesɨc tuŋgagam jejcuyja̱ma nɨc Jesús jém sinagoga. Moj iŋquejáy jém pɨxiñt́am. It́t́im je̱m tu̱m pɨ̱xiñ mɨmne. Tɨtsne jém iŋwɨ̱cɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Jesɨc jém escribaspɨc maestroyaj con jém fariseoyaj icuixyajpa jém Jesús siiga nu̱ma acpɨsóypa jém jejcuyja̱ma. Imétsyajpa ju̱t́pɨc iquejajwadayyajpa jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pero Jesús ijo̱doŋ t́i sɨ́p ijɨ̱syaj. Iñɨ́máy jém pɨ̱xiñ jém tɨtsnewɨɨp icɨ: —Te̱ñchucu̱mɨ, mi̱ñɨ mit́e̱ñi yɨ́p pɨxiñt́am aŋcucmɨ. Jesɨc tsucum, nɨc te̱ñi. ");
INSERT INTO poiNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jesɨc Jesús iñɨ́máy jém pɨxiñt́am jém it́yajwɨɨp je̱m: —Sɨɨp manacwáctámpa: ¿T́i wɨa̱p taŋwat jém jejcuyja̱ma? ¿Taŋwɨ̱watpa o tammalwatpa? ¿Wɨ̱ iga taŋcɨacpudáypa tu̱m pɨ̱xiñ ivida o tanaccáyáypa? ");
INSERT INTO poiNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jesɨc Jesús icuámse̱t jém pɨxiñt́am icuwoyo, iñɨ́máy jém pɨ̱xiñ jém tɨtsnewɨɨp icɨ: —¡Tɨ̱mɨ iŋcɨ! Je̱mpam iwat jém pɨ̱xiñ, wɨ̱tsɨ́yum icɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Jesɨc tsa̱m pɨ̱mi jóyyaj jém fariseoyaj. Moj nacwácyajta̱ji entre jeeyaj t́i wɨa̱p iwadayyaj jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Jesɨc tu̱m ja̱ma nɨc Jesús tu̱m co̱tsɨcyucmɨ. Nɨc iŋwejpát Dios mu̱ma tsuu. ");
INSERT INTO poiNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Icuqueja̱ma iŋwejáy jém icuyujcɨɨwiñ. Icupiŋ doce de jeeyaj, iccám juuts “apóstolyaj”. Taɨch tanaŋmat́i̱mɨ nɨmtooba jém cutsatneta̱wɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Icupiŋ jém Ximoj, Jesús icagáy iñɨ̱yi, icámáy iga Peto; jém Anti, je jém Ximoj it́ɨ̱wɨ; jém Jacobo; jém Xiwan; jém Felipe; jém Bartolo; ");
INSERT INTO poiNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","jém Mateo; jém Tomax; jém Jacobo, je jém Alfeo ima̱nɨc; jém tuŋgac Ximoj, jém iñɨ̱yit́im jém Zelote; ");
INSERT INTO poiNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","jém Judas, je jém Jacobo it́ɨ̱wɨ; y jém Judas Iscariote jém icɨɨjuŋcotwɨɨp jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesɨc quet Jesús jém co̱tsɨcyucmɨ con icuyujcɨɨwiñ. Nɨc accuyujooyi tu̱m wɨ̱t́ipɨc noŋjo̱m. Aŋtuuma̱yaj tsa̱m jáyaŋ jém pɨxiñt́am. Miñyaj icuwɨ̱t́i jém naxyucmɨ de Judea, jém Jerusalén y jém lamar aŋna̱ca ju̱t́ it́ jém attebet Tiro y Sidón. Miññeyaj je̱m iga imatoŋyajpa jém Jesús iŋquímayooyi, iga acpɨsyajta̱iñ jém mɨmneyajwɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Pɨsyajt́im jém tsa̱mpɨc iyaachwatyaj jém mal espíritu. ");
INSERT INTO poiNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Jém pɨxiñt́am tsa̱m icunúcyajpa Jesús iga ichɨcpa porque tsa̱m putpa jém ipɨ̱mi iga icpɨspa it́u̱mpɨy. ");
INSERT INTO poiNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesɨc jém Jesús iámmats jém icuyujcɨɨwiñ. Iñɨ́máy: —Maymáya̱taamɨ siiga sɨɨp tsa̱m miyaacha̱p porque mit́ɨgɨyñeta con Dios, sɨɨp miŋjactámpa mimicht́am. ");
INSERT INTO poiNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Maymáya̱taamɨ siiga sɨɨp miyua̱támpa porque ocmɨm custámpa miwiiquit́am. ’Maymáya̱taamɨ siiga sɨɨp miwejtámpa porque ocmɨ mixictámpa. ");
INSERT INTO poiNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Maymáya̱taamɨ siiga sɨɨp mijóyixt́amta̱p, miquebacputtamta̱p, mimalnɨ́mayt́amta̱p y d́a i̱ miwɨ̱ixt́ámpa. Pɨ̱mi mimalwadayt́amta̱p porque mimicht́am aŋcupɨctámpa aɨch jém aMiññewɨɨp Sɨŋyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Maymáya̱taamɨ cuando núcpa jém ja̱ma, miyóypa juuts tu̱m tsɨ̱xi, porque iñjo̱doŋ iga Dios michiiba jáyaŋ jém wɨ̱tampɨc cosa sɨŋyucmɨ. Jɨ̱sɨ iga jém wiñɨcpɨc pɨxiñt́am imalwadáyt́im jém wiñɨcpɨc Dios iŋmat́cɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Agui miuuguyt́im jém ricopɨc mipɨxiñt́am porque sɨɨp mimaymáya̱támpa, pero ocmɨ d́a t́i michiiba Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Agui miuuguyt́im siiga sɨɨp cuspa miwiiqui. Ocmɨ miyua̱támpa. ’Agui miuuguyt́im siiga tsa̱m mixictámpa sɨɨp porque ocmɨ miŋyáctámpa, miwejtámpa. ");
INSERT INTO poiNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Agui miuuguyt́im siiga it́u̱mpɨy jém pɨxiñt́am micujíptámpa sɨɨp, porque jém wiñɨcpɨc pɨxiñt́am icujípyajt́im jém malopɨc aŋmat́cɨɨwiñ jém mɨgoyyajpáppɨc. ");
INSERT INTO poiNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Jesɨc Jesús iñɨ́máyt́im jém pɨxiñt́am: —Pero sɨɨp mannɨ́mayt́ámpa mimicht́am iga to̱yɨ jém íñenemigoyaj. Wɨ̱wadaayɨ jém mijóyixyajpáppɨc. ");
INSERT INTO poiNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Aŋwejpaatɨ Dios iga iwɨ̱wadáyiñ jém mimalnɨ́maypáppɨc y jém mimalwadaypáppɨc. ");
INSERT INTO poiNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Siiga i̱ micótsáypa tu̱m íña̱cpac, jɨ́gaayɨ iga micótsáyiñt́im tuŋgac lado, odoy cɨaŋseedaayɨ. Siiga i̱ mit́obáyáypa jém iñchamarra, jɨ́gaayɨ iga mit́obáyáyiñt́im mex jém iñyoot́i. ");
INSERT INTO poiNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Siiga i̱ miwágáypa tu̱m cosa, chi̱ɨ. Siiga i̱ mit́obáyáypa tu̱m cosa jém immɨɨchipɨc, odom wágaayɨ iga micseedáyiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Wɨ̱wadaayɨ jém tuŋgac juutst́im mich iñxunpa iga miwɨ̱wadayt́a̱iñ. ");
INSERT INTO poiNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Siiga no más iñt́oypa jém mit́oypáppɨc, odoy jɨ̱sɨ iga micujípta̱p. Porque jém malopɨc pɨxiñt́am it́oypat́im jém iamigoyaj. ");
INSERT INTO poiNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Siiga iŋwɨ̱wadáypa no más jém miwɨ̱wadaypáppɨc d́a micujípta̱p porque jém malopɨc pɨxiñt́am iwɨ̱wadáypat́im jém iwɨ̱wadaypáppɨc. ");
INSERT INTO poiNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Siiga inicnucspa tumiñ no más jém pɨ̱xiñ jém wɨa̱paap micseedáy jém iñt́umiñ, jesɨc d́a micujípta̱p. Porque jém malopɨc pɨxiñt́am icnucspat́im tumiñ jém iamigoyaj jém wɨa̱paap icseedayyaj. ");
INSERT INTO poiNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pero mannɨ́mayt́ámpa: Toyt́aamɨ jém mijóyixpáppɨc. Wɨ̱wadayt́aamɨ jém mimalwadaypáppɨc. Siiga miñucsáypa tumiñ, chi̱ɨt́im. Odoy wadaayɨ caso siiga d́a wɨa̱p micseedáy jém iñt́umiñ. Siiga iŋwatpa je̱mpɨc, Dios miwɨ̱yojpa. Quejpa iga Dios mima̱nɨctam. Porque Dios iyaachaŋja̱mpat́im jém malopɨc y jém táŋcaɨywɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Yaachaŋja̱mtaamɨ it́u̱mpɨy jém pɨxiñt́am juutst́im tanJa̱tuŋ Dios miyaachaŋja̱mtámpa mimicht́am. ");
INSERT INTO poiNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Odoy jɨ̱sɨ tu̱m iñt́ɨ̱wɨ iga táŋcaɨ́y, jesɨc Dios d́at́im mijɨ̱sáypa mich iñt́áŋca. Siiga tu̱m pɨ̱xiñ mimalwadáypa, odoy tseecɨ, jesɨc Dios d́a michégáypa mich iñt́áŋca. ");
INSERT INTO poiNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Siiga i̱ miwágáy alguna cosa, siiga wɨ̱ íña̱nama, chi̱ɨ jém d́apɨc inii̱, jesɨc Dios jeet́im quípsɨ mipɨgáypa iga micseedáypa mimich. ");
INSERT INTO poiNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesɨc Jesús iŋmadáypa jém pɨxiñt́am yɨ́p xut́u cuento: —Tu̱m cácht́ipɨc pɨ̱xiñ d́a wɨa̱p iniwit́ tuŋgac cácht́i porque tsutyajpa icuɨstɨcyaj jém pacusjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Tu̱m cuyujcɨɨwiñ d́a wɨa̱p iñasca jém imaestro, cuando yajum cuyu̱ji d́a ictsɨ́ypa jém imaestro. ");
INSERT INTO poiNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’T́iiga iññɨ́máypa jém iñt́ɨ̱wɨ iga táŋcaɨ́y siiga d́a jutsaŋ jém it́áŋca juuts tu̱m xut́u pu̱chi iniit́ iixco̱m. Pero mich tsa̱m jáyaŋ táŋca iniit́ jex juuts tu̱m mɨjpɨc cuy iniit́ íñixco̱m. ");
INSERT INTO poiNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Siiga d́a iñja̱mpa jém cuy jém iniit́wɨɨp íñixco̱m, t́iiga iñjɨ̱spa iga wɨa̱p iñt́obáy jém pu̱chi jém iñt́ɨ̱wɨ iixco̱m. Minimɨgóyayt́a̱p iñyaac. Wiñt́i to̱pɨ jém cuy jém michpɨc iniit́ íñixco̱m, jesɨc ocmɨ wɨa̱p iñt́obáy jém pu̱chi jém iñt́ɨ̱wɨ iixco̱m. ");
INSERT INTO poiNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Jém wɨbɨc cuy d́a wɨa̱p iwat jém malopɨc it́ɨm. Jém malopɨc cuy d́a wɨa̱p iwat jém wɨbɨc it́ɨm. ");
INSERT INTO poiNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Cada cuy tánixpɨcpa con it́ɨm. D́a tantúcpa tu̱m tsuj jém a̱pit́cuyyucmɨ. D́a tantúcpa uvas jém chicxchayyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Tu̱m wɨbɨc pɨ̱xiñ iwatpa wɨbɨc cosa porque iniit́ jém wɨbɨc jɨ̱xi ia̱namaŋjo̱m. Jém malopɨc pɨ̱xiñ iwatpa jém cosa d́apɨc wɨ̱tam porque iniit́ jém malopɨc jɨ̱xi ia̱namaŋjo̱m. Jém aŋma̱t́i jém putpáppɨc tanjɨpjo̱m tsucum jém tána̱namaŋjo̱m. Siiga tu̱m pɨ̱xiñ iŋmatpa wɨbɨc cosa, jesɨc quejpa iga d́a malo. Pero siiga iŋmatpa tu̱m cosa d́apɨc wɨ̱, jesɨc quejpa iga malo. ");
INSERT INTO poiNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Jesɨc Jesús iñɨ́máyt́im jém pɨxiñt́am: —¿T́iiga miñɨmtámpa iga, “MánO̱mi, mánO̱mi”, pero d́a iŋwattámpa juuts mannɨ́máypa? ");
INSERT INTO poiNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Wɨ̱ iga miñpa immatoŋ ɨch anaŋma̱t́i y iga iŋwad́iñ juuts mannɨ́máypa. Sɨɨp manaŋquejáypa juutspɨc mipɨ̱xiñ siiga iŋwatpa juuts mannɨ́máypa. ");
INSERT INTO poiNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Mijex juuts tu̱m pɨ̱xiñ wɨa̱paap it́ɨcwat. Wiñt́i iwɨ̱tajcúmpa jojmɨ iga icpɨɨma̱p jém tɨc tsaayucmɨ. Jesɨc ocmɨ cuando compa jém nɨ, pɨ̱mi ictsɨ́y jém nɨɨco̱ma jém tɨc. Pero d́a wɨa̱p ictsɨgóy ni imɨswatpa porque acpɨɨma̱neta̱ tsaayucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Siiga tu̱m pɨ̱xiñ imatoŋpa ɨch anaŋma̱t́i, pero d́a icupɨcpa, jesɨc jém pɨxiñ jex juuts tu̱m pɨ̱xiñ jém d́apɨc wɨa̱p it́ɨcwat. Jém pɨ̱xiñ d́a iwɨ̱tajcúm jojmɨ iga icpɨɨma̱p jém tɨc jém tsaayucmɨ. Naxyucmɨ no más icpɨɨma̱ne. Jesɨc ocmɨ com jém nɨ, pɨ̱mi ictsɨ́y jém nɨɨco̱ma jém tɨc, jeet́i rato cutɨŋ, d́a t́i tsɨ́y. ");
INSERT INTO poiNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesɨc yaj iŋmadáy Jesús jém pɨxiñt́am, nɨc Capernaum. ");
INSERT INTO poiNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","It́ id́ɨc je̱m tu̱m jém Romapɨc capitán. Iniit́ id́ɨc tu̱m imozo jém tsa̱mpɨc it́oypa. Pero ocmɨ mɨmneactɨŋ jém imozo. Tsa̱m pɨ̱mi mɨmne. Caatoobam. ");
INSERT INTO poiNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Jesɨc cuando jém capitán ijo̱dóŋa̱ iga jém Jesús wɨa̱p icpɨsóy, icutsadáy jute̱n jém Israelpɨc wɨd́ayt́am iga icunucsáypa jém Jesús iga míñiñ icpɨs jém imozo. ");
INSERT INTO poiNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Jesɨc jém wɨd́ayt́am nɨc iám jém Jesús. Icunucsáy, iñɨ́máy: —Awadaayɨ tu̱m favor, jém capitán tu̱m wɨbɨc pɨ̱xiñ, yo̱xpaatɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Porque tsa̱m it́oypa jém tannación. Tawadáyt́im tu̱m jém tamma̱stɨc jém sinagoga. ");
INSERT INTO poiNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jesɨc jém wɨd́ayt́am iwagananɨcyajpa jém Jesús. Iganam núcyajpa nocojo̱m jém capitán it́ɨccɨɨm, jém capitán icutsadáy aŋma̱t́i jém Jesús con tuŋgac iamigoyaj. Iñɨ́mayyaj: —Jém capitán miñɨ́máy iga: “MánO̱mi, d́a más maŋco̱bacpijpa. D́a wɨ̱ iga miñúcpa antɨccɨɨm porque mich wɨbɨc mipɨ̱xiñ, ɨch tsa̱m atáŋcaɨ́y.” ");
INSERT INTO poiNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Jeeyucmɨ ɨch d́a nɨc mamméts anyaac. Sɨɨp no más nɨ́maayɨ jém caacuy iga ichaguiñ jém ammozo, tienes que pɨspa. ");
INSERT INTO poiNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Porque ɨch anait́t́im tu̱m anaŋjagooyi iga apɨɨmɨ́ypa. Ɨch anait́t́im soldado jém ampɨɨmɨypaap. Siiga annɨ́máypa jém ansoldado iga nɨguiñ, jesɨc tienes que nɨcpa. Siiga annɨ́máypa jém ansoldado iga míñiñ, jesɨc tienes que miñpa. Siiga annɨ́máypa jém ammozo iga iwad́iñ tu̱m cosa, jesɨc tienes que iwatpa. ");
INSERT INTO poiNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jesɨc miimatoŋ jém Jesús junɨmpa jém capitán, ipooñaŋja̱mpa. Iámseedáy jém pɨxiñt́am jém miñyajpáppɨc it́uuñiaŋcɨɨm. Iñɨ́máy: —Nu̱ma, mannɨ́máypa, d́a ampátne ni tu̱m pɨxiñ icuwɨ̱t́i yɨ́p Israel iga icupɨcpa Dios juuts yɨ́p capitán. ");
INSERT INTO poiNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Jesɨc jém capitán iamigoyaj se̱tyajum it́ɨccɨɨm. Iixyajum iga pɨsneum jém capitán imozo. ");
INSERT INTO poiNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Jesɨc jém tuŋgac ja̱ma nɨc Jesús tu̱m attebet iñɨ̱yi Naín. Waganɨcyajpa con wa̱t́i jém icuyujcɨɨwiñ. Nɨcyajpat́im jáyaŋ jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Iganam núcyajpa jém attebet aŋna̱ca, iix iga nanɨcta̱p tu̱m tsúts. Jém caanewɨɨp tu̱m cuno̱ya ijayma̱nɨc. Jém yo̱mo d́a inii̱ tuŋgac ima̱nɨc. Icut́um tsɨ́y. Jáyaŋ jém pɨxiñt́am iwagananɨcyajpa jém cuno̱ya. ");
INSERT INTO poiNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Mu iix jém tánO̱mi, iyaachaŋja̱mpa jém yo̱mo. Iñɨ́máy: —Odoy we̱jɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Jesɨc Jesús icunúc nocojo̱m jém tsúts, ichɨgáy icaja. Jém icópneyajwɨɨp teeñaŋjacyaj. Jesɨc Jesús iñɨ́máy jém caanewɨɨp: —¡Miwo̱ñjaychɨ̱xi, mannɨ́máypa, tsucu̱mɨ! ");
INSERT INTO poiNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Jesɨc jém caanewɨɨp id́ɨc co̱ñchucum. Mojum jɨ̱yi. Jesɨc Jesús icɨɨjuŋcodáy ia̱pa. ");
INSERT INTO poiNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Mu iixyaj, pɨ̱mi cɨ̱ŋyaj it́u̱mpɨy jém it́yajwɨɨp je̱m. Moj icujípyaj Dios. Nɨmyajpa: —Tawiñquejayñe tu̱m mɨjpɨc profeta. Nɨmyajpat́im: —Dios tsa̱m tayaachaŋja̱mpa, jeeyucmɨ tacutsadayñe yɨ́p pɨxiñ iga tayo̱xpáttámiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Jesɨc ocmɨ jo̱dóŋa̱ta̱ t́i iwat jém Jesús icuwɨ̱t́i jém naxyucmɨ de Judea con jém tuŋgac naxyucmɨ jém nocojo̱mpɨc. ");
INSERT INTO poiNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ocmɨ acjo̱dóŋa̱ta̱t́im jém Xiwan jém acchíŋoypaap t́i iwat jém Jesús. Jém Xiwan icuyujcɨɨwiñ iŋmadáy. Jesɨc ocmɨ iŋwejáy wɨste̱n de jeeyaj. ");
INSERT INTO poiNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Icutsat iga nɨguiñ icwácyaj jém Jesús. Nɨ́mayt́a̱ jém icuyujcɨɨwiñ: —Nɨ̱gɨ acwaacɨ jém Jesús iga: “¿Que micham miCristo jém micutsatnewɨɨp Dios o anaŋjóctámpa tuŋgac?” ");
INSERT INTO poiNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Jesɨc ocmɨ jém Xiwan icuyujcɨɨwiñ ipát jém Jesús. Iñɨ́mayyaj: —Jém Xiwan, jém acchíŋoypáppɨc, acutsatta iga manacwáguiñ siiga micham miCristo jém micutsatnewɨɨp Dios o anaŋjóctámpa tuŋgac. ");
INSERT INTO poiNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Jesɨc jeet́im hora cuando núcyaj jém Xiwan icuyujcɨɨwiñ, jém Jesús icpɨspa jáyaŋ jém pɨxiñt́am jém iniit́wɨɨp caacuy, jém mɨmneyajwɨɨp y jém imatsnewɨɨp jém mal espíritu. Icpɨst́im jáyaŋ jém cácht́iyaj. ");
INSERT INTO poiNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jesɨc Jesús iñɨ́máy jém Xiwan icuyujcɨɨwiñ: —Nɨ̱gɨ nɨ́maayɨ jém Xiwan t́i íñixñeta y t́i immatoŋneta. Aŋmadayt́aamɨ iga ixixóypam jém cácht́i, wit́pam jém cuxujpɨc id́ɨc, pɨsneum jém cupúgayñewɨɨp id́ɨc iña̱ca, matóŋóypam jém chajca, pɨsneum jém caaneyajwɨɨp id́ɨc y jém yaacha̱yajpaap ipɨctsoŋyaj jém wɨbɨc aŋma̱t́i iga Dios icɨacputpa. ");
INSERT INTO poiNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Agui maymay jém pɨ̱xiñ jém d́apɨc ijɨ́cpa iga i̱ ictsacpa ɨch anaŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jesɨc nɨcyajum jém Xiwan icuyujcɨɨwiñ. Moj iŋmadáy Jesús jém pɨxiñt́am iga jém Xiwan tu̱m Dios iŋmat́cɨɨwiñ. Nɨmpa: —¿T́i oy íñámta jém tɨtsɨnaxyucmɨ? ¿Que oy íñámta tu̱m pɨ̱xiñ d́apɨc wɨa̱p juuts tu̱m po̱c jém aguipɨc ictsɨgóypa sa̱wa? D́a je. Oy íñámta tu̱m pɨ̱xiñ wɨa̱paap. ");
INSERT INTO poiNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Que oy íñámta jém pɨ̱xiñ agui wɨ̱cuyajne? D́a je. Tanjo̱doŋ iga jém wɨ̱cuyajnewɨɨp it́yaj jém rey it́ɨccɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Que t́i oy íñámta jém tɨtsɨnaxyucmɨ? ¿Que oy íñámta tu̱m nunta profeta? Nu̱ma tu̱m profeta más wɨa̱p que it́u̱mpɨy jém wiñɨcpɨc Dios iŋmat́cɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Nɨmpa jém Dios iŋma̱t́i t́i iwatpa jém Xiwan: Dios icutsatpa tu̱m aŋmat́cɨɨwiñ iga iwɨ̱tsagáypa jém Cristo it́uŋ. Jém aŋmat́cɨɨwiñ aŋjagoyñeeba iñɨc. Ocmɨ it́uuñiaŋcɨɨm miñpa jém Cristo. ");
INSERT INTO poiNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Jesɨc Jesús iñɨ́máyt́im jém pɨxiñt́am: —Nu̱ma mannɨ́máypa iga icuwɨ̱t́i yɨ́p naxyucmɨ d́a i̱ tuŋgac más wɨbɨc profeta que jém Xiwan jém acchíŋoypaap. Pero cuando núcpa jém tiempo iga iŋjacpa Dios, jém más xut́upɨc más wɨa̱p que jém Xiwan. ");
INSERT INTO poiNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Mu imatoŋyaj t́i nɨmpa jém Jesús, jesɨc it́u̱mpɨy jém pɨxiñt́am agui maymáya̱yaj. Agui maymáya̱yajpat́im jém ichécyajpáppɨc jém impuesto. Nɨmyajpa: —Agui wɨ̱ tanDios iga taŋquejáypa yɨ́p nu̱mapɨc aŋma̱t́i. Porque casi it́u̱mpɨy jém pɨxiñt́am oy icchiŋyajta̱ ju̱t́ acchíŋóypa jém Xiwan. ");
INSERT INTO poiNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pero jém fariseoyaj con jém maestroyaj de jém Israelpɨc aŋquímayooyi d́a icupɨcyajpa jém Dios iŋma̱t́i jém inimiññewɨɨp jém Xiwan. Dios iwɨ̱wadayt́ooba id́ɨc, pero jeeyaj d́a iwɨ̱aŋja̱myaj. Jeeyucmɨ jém fariseoyaj d́a ijɨ́cpa iga icchiŋyajpa jém Xiwan. ");
INSERT INTO poiNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jesɨc tánO̱mi Jesús iñɨ́máy jém aŋtuuma̱neyajwɨɨp: —Jém pɨxiñt́am jém it́yajwɨɨp sɨɨp ");
INSERT INTO poiNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","jex juuts jém tsɨ̱xt́am jém mɨ̱chyajpáppɨc plaza. Iñɨ́mayyajpa jém iamigoyaj iga: “Mansusáypa jém flauta, pero d́a mietstámpa. Ocmɨ maŋwánáypa jém wa̱ñi jém aŋyácnewɨɨp, pero d́at́im miwejtámpa.” ");
INSERT INTO poiNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Porque cuando miñ jém Xiwan jém acchíŋoypáppɨc, d́a icútpa caxt́ána̱ñi, d́a iucpa vino; miñɨmtámpa iga jém Xiwan iniit́ tu̱m mal espíritu. ");
INSERT INTO poiNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ocmɨ ɨch anyaac amiñ sɨŋyucmɨ. Awícpa y anɨ́cpa, pero micht́am miñɨmtámpa iga tsa̱m awícpa y tsa̱m ánucpa vino. Miñɨmtámpat́im iga ɨch aŋcompañero jém ichécyajpáppɨc jém impuesto y jém táŋcaɨywɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Quejpa iga wɨ̱ jém jɨ̱xi siiga wɨ̱putpa jém yo̱xacuy. ");
INSERT INTO poiNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Tu̱m fariseo iŋwejáy Jesús iga nɨguiñ wiiqui. Jesɨc nɨc jém Jesús, tɨgɨy it́ɨcjo̱m, co̱ñ jém mesacɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","It́t́im jém attebet tu̱m yo̱mo wit́wid́oypáppɨc id́ɨc. Jesɨc jém yo̱mo ijo̱doŋ iga nɨc wiiqui jém Jesús jém fariseopɨc it́ɨccɨɨm. Nɨct́im mex jém yo̱mo. Ininɨc tu̱m wɨbɨc tsaafrasco comne de pomada cɨ̱npáppɨc. ");
INSERT INTO poiNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Jesɨc jém yo̱mo icunúc jém Jesús. Ico̱steeñáy ipuycɨɨm. Wejpa jém yo̱mo. Icheáypa jém Jesús ipuy con iixcaŋnɨ. Ocmɨ jém yo̱mo icujicháyáypa jém ipuy con jém iway. Iŋna̱catsútsáypa ipuy. Ocmɨ icámáy jém pomada jém Jesús ipuyyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Jesɨc jém fariseo, jém iŋwejayñewɨɨp Jesús, iix t́i iwatpa jém yo̱mo. Jém pɨ̱xiñ ijɨ̱spa ijɨ̱xiaŋjo̱m. Nɨmpa iga: “Siiga nu̱ma yɨ́p pɨ̱xiñ tu̱m profeta, ¿t́iiga d́a icutɨɨyɨ́ypa iga yɨ́p yo̱mo tsa̱m táŋcaɨ́y? Porque yɨ́p yo̱mo tu̱m wit́wid́oypáppɨc.” ");
INSERT INTO poiNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesɨc Jesús iñɨ́máy jém fariseopɨc pɨ̱xiñ: —MiXimoj, mannɨ́mayt́ooba tu̱m aŋma̱t́i: Jesɨc jém pɨ̱xiñ iñɨ́máy jém Jesús: —Maestro, anɨ́maayɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesɨc nɨmpa Jesús: —It́ id́ɨc wɨste̱n pɨ̱xiñ. Oy icacyaj tumiñ. Tu̱m icac quinientos tumiñ de plata, tu̱m icac cincuenta tumiñ de plata. ");
INSERT INTO poiNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ocmɨ icuɨstɨc d́a wɨa̱p icse̱tyaj jém tumiñ. Jesɨc jém ichiiñewɨɨp jém tumiñ iwadáypa perdón icuɨstɨc. D́am ichécpa jém pɨ̱xiñ. Sɨɨp, miXimoj, ¿anɨ́maayɨ juppɨc más it́oypa jém ichiiñewɨɨp jém tumiñ? ");
INSERT INTO poiNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Jesɨc jém Ximoj icutsoŋ. Nɨ́mayt́a̱ Jesús: —Jém más jáyaŋpɨc icacne jém tumiñ. Jesús iñɨ́máy jém Ximoj: —Nu̱ma, aŋwɨ̱cutsoŋ. ");
INSERT INTO poiNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jesɨc Jesús iámseedáy jém yo̱mo ju̱t́ sɨɨp icheáy jém ipuy, iñɨ́máy jém Ximoj: —Aamɨ yɨ́p yo̱mo t́i sɨ́p iwat. Cuando atɨgɨy iñt́ɨcjo̱m mich d́a anchi nɨ iga antseeba ampuy. Pero yɨ́p yo̱mo atseáypa ampuy con iixcaŋnɨ. Acujicháyáypa ampuy con iway. ");
INSERT INTO poiNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Mich d́a anaŋna̱catsútspa, pero yɨ́p yo̱mo tsa̱m aŋna̱catsútsáypa ampuy. ");
INSERT INTO poiNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Mich d́a anaccámáy aceite aŋco̱bacyucmɨ, pero yɨ́p yo̱mo acámáy tu̱m frasco jém pomada jém cɨ̱npáppɨc ampuyyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Jesɨc mannɨ́máypa iga Dios iccáyáy yɨ́p yo̱mo it́áŋca tsa̱m jáyaŋ. Jeeyucmɨ tsa̱m pɨ̱mi it́oypa Dios. Pero siiga Dios iccáyáypa tu̱m pɨ̱xiñ it́áŋca d́apɨc jutsaŋ, jesɨc jém pɨ̱xiñ uxaŋt́im it́oypa Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jesɨc Jesús iñɨ́máy jém yo̱mo: —Miccáyayt́a̱ jém iñt́áŋca. ");
INSERT INTO poiNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Jesɨc jém it́yajwɨɨp jém mesacɨɨm con Jesús moj nanɨ́mayyajta̱ji entre jeeyaj: —¿I̱apaap yɨ́p pɨ̱xiñ iga wɨa̱p iccáyáy jém yo̱mo it́áŋca? ");
INSERT INTO poiNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Pero jém Jesús iñɨ́máy jém yo̱mo: —Iŋcupɨcne Dios jeeyucmɨ micɨɨputneum. Chogoyñɨcsɨm. ");
INSERT INTO poiNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ocmɨ Jesús oy jo̱yi wa̱t́i jém attebet y jém tɨgaŋjoj. Oy najɨ́yooyi. Iŋmatpa jém wɨbɨc aŋma̱t́i ju̱t́pɨc Dios iŋjacpa yɨ́p naxyucmɨ. It́úŋɨyyaj jém doce icuyujcɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Iwagananɨcyajpat́im jém yo̱mtam jém mɨmneyajwɨɨp id́ɨc con jém iniit́wɨɨp id́ɨc jém mal espíritu. Jesús icpɨs jém yo̱mtam. Tu̱m de jeeyaj jém Malía, iñɨ̱yit́im Magdalena, tobayt́a̱ siete jém mal espíritu. ");
INSERT INTO poiNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","It́t́im jém Xiwana, jém iwɨd́a̱ya iñɨ̱yi Chuzo. Jém pɨ̱xiñ icuyo̱xa̱p jém gobernador Herodes. It́t́im jém Susana. Yɨ́pyaj con wa̱t́i más jém yo̱mtam icwícyajpa jém Jesús con icuyujcɨɨwiñ, ichiiyajpa t́it́am iniit́yaj. ");
INSERT INTO poiNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Tu̱m ja̱ma aŋtuuma̱yajpa tsa̱m jáyaŋ pɨxiñt́am. Putyaj de wa̱t́i jém attebetyaj. Miñ iámyaj jém Jesús. Jesɨc Jesús iŋmadáy tu̱m xut́u cuento iga iŋquejáypa jém aŋtuuma̱neyajwɨɨp. Iñɨ́máy: ");
INSERT INTO poiNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—It́ id́ɨc tu̱m pɨ̱xiñ. Nɨc ñi̱pi. Nɨc iyɨ̱n jém pac ica̱mjo̱m. Jesɨc mu iyɨ̱n jém pac, actɨŋ uxaŋ tuŋjo̱m jém ca̱maŋna̱ca. Jém nasyajpaap icunepnepquetyaj. Jém jon icútquetyaj. ");
INSERT INTO poiNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Actɨŋt́im uxaŋ jém pac jém tsaaŋjo̱m. Mu iñay, jobit́t́im tɨts porque d́a mu̱jajo̱m. ");
INSERT INTO poiNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Actɨŋt́im uxaŋ jém pac apid́aŋjo̱m. Jém apit́ iwagananay jém pac, ocmɨ ixamca. ");
INSERT INTO poiNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Actɨŋt́im jém pac jém wɨbɨc naxyucmɨ. Nay, wɨ̱tɨ́ma̱p. Cada tu̱mtu̱m jém pac chióy cien. Jesɨc yaj iŋmat jém cuento. Pɨ̱mi jɨy Jesús. Iñɨ́máy jém pɨxiñt́am: —Siiga mit́atsɨgɨyt́a, amatoŋtaamɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jesɨc jém icuyujcɨɨwiñ icwácyaj jém Jesús t́i nɨmtooba jém xut́u cuento. ");
INSERT INTO poiNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesús iñɨ́máy: —Dios michiiñe jém jɨ̱xi iga wɨa̱p iñjo̱dóŋa̱ta jém cosa aŋyamneta̱wɨɨp id́ɨc. Sɨɨp wɨa̱p iŋcutɨɨyɨ́y ju̱t́pɨc iŋjacpa Dios jém it́yajwɨɨp yɨ́p naxyucmɨ. Pero ɨch anaŋquejáypa jém tuŋgacpɨc pɨxiñt́am con yɨ́p xut́u cuento. Jesɨc cuando iixyajpa, d́a ijo̱dóŋa̱yajpa t́i iixyaj. Cuando imatoŋyajpa, d́a icutɨɨyɨyyajpa t́i imatoŋyaj. ");
INSERT INTO poiNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Sɨɨp manaŋmadáypa t́i nɨmtooba yɨ́p xut́u cuento. Jém pac jém Dios iŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Jém actɨŋnewɨɨp tuŋjo̱m jex juuts jém pɨxiñt́am jém imatoŋneyajwɨɨp jém Dios iŋma̱t́i. Pero ocmɨ jém Woccɨɨwiñ miñ iccáyáy ia̱namaŋjo̱m iga odoy icupɨcyajiñ, iga odoy cɨɨputyajiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Jém pac, jém actɨŋnewɨɨp tsaaŋjo̱m, jex juuts jém pɨxiñt́am cuando imatoŋ jém Dios iŋma̱t́i, agui maymay, iwɨ̱pɨctsoŋyaj. Pero d́a pɨ̱mi t́i̱chɨgɨ́y, d́a jáypa icupɨcyaj, pero cuando cutɨ́tsta̱p, ichacyajpa jém aŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Jém pac, jém actɨŋnewɨɨp apid́aŋjo̱m, jex juuts jém imatoŋneyajwɨɨp Dios iŋma̱t́i, mojpa iwat juuts ixunpa Dios, pero d́a iyaachɨ́ypa. Icupɨctooba id́ɨc, pero tsa̱m ijɨ̱spa iyo̱xacuy. Ijɨ̱spat́im jém it́umiñ con jém maymáya̱ji. Jém jɨ̱xi d́apɨc wɨ̱ ixamcaaba jém wɨbɨc jɨ̱xi. D́a wɨ̱ tɨ́ma̱p. ");
INSERT INTO poiNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Pero jém pac, jém actɨŋnewɨɨp jém wɨbɨc naxyucmɨ, jex juuts tu̱m pɨ̱xiñ wɨ̱ ia̱nama, imatoŋpa jém Dios iŋma̱t́i, iwadáypa caso. Icupɨcpa jém aŋma̱t́i, d́a nunca ichacpa. Wɨ̱tɨ́ma̱p jém pɨ̱xiñ. Siempre iwatpa juuts ixunpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jesɨc nɨmpat́im Jesús: —D́a i̱ iñooba tu̱m juctɨ iga icujappa cooŋcucɨɨm o iga ichacpa tseescucɨɨm. Tannooba juctɨ iga tantunpa yucmɨ iga iixixóypa jém tɨgɨypáppɨc. ");
INSERT INTO poiNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Jesanet́im quejpa it́u̱mpɨy cosa aŋnécne id́ɨc. Quejpat́im jém d́apɨc quejne id́ɨc. ");
INSERT INTO poiNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Wadaayɨ caso mimicht́am, awɨ̱matoŋtaamɨ. Siiga iŋwɨ̱pɨctsoŋpa jém Dios iŋma̱t́i, jesɨc Dios michiiba jáyaŋ wɨ̱tampɨc cosa. Pero siiga d́a iŋwɨ̱pɨctsoŋpa jém Dios iŋma̱t́i, jesɨc d́a t́i wɨa̱p michi Dios, más miccáyáypa jém cosa jém iñjɨ̱spáppɨc id́ɨc iga iniit́. ");
INSERT INTO poiNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesɨc jém Jesús it́ɨ̱wɨtam con ia̱pa miñyaj. Pero d́a wɨa̱p it́ɨgɨyyaj ju̱t́ it́ jém Jesús porque tsa̱m it́ñɨ̱m. ");
INSERT INTO poiNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Aŋmadayt́a̱ Jesús: —Miññeum jém íña̱pa con iñt́ɨ̱wɨtam. Jemum it́ aŋsɨ̱cmɨ. Miixt́ooba. Mijɨypáttooba. ");
INSERT INTO poiNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Pero Jesús iñɨ́máy jeeyaj: —Jém icupɨcneyajwɨɨp jém Dios iŋma̱t́i, jeam ána̱pa, jeam antɨ̱wɨtam. ");
INSERT INTO poiNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Tu̱m ja̱ma tɨgɨy Jesús barcojo̱m con icuyujcɨɨwiñ. Iñɨ́máy: —Tanɨctámpa jém laguna aŋwiñt́uc. Jesɨc nɨcyajum barcojo̱m. ");
INSERT INTO poiNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Iganam jacyajpa jém laguna, moŋpa Jesús jém barcojo̱m. Miñúcyaj cucmɨ jém laguna, mojum po̱yi jém sa̱wa tsa̱m pɨ̱mi. Agui poobat́im jém nɨ. Moj tɨgɨ̱yi nɨ jém barcojo̱m hasta cumoŋtoobam jém barco. ");
INSERT INTO poiNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Jesɨc nɨc ichɨcyusyaj jém Jesús. Nɨ́mayt́a̱: —¡Maestro! ¡Maestro! ¡Tatogoyt́ámpa! Jesɨc yus Jesús, tsucum. Iwogáy jém sa̱wa con jém nɨɨpoa. Iñɨ́máy iga teeñiñ. Jesɨc teeñaŋjac jém sa̱wa con jém nɨɨpoa. D́am t́i tsɨgóypa. ");
INSERT INTO poiNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jesɨc iñɨ́máy jém icuyujcɨɨwiñ: —¿T́iiga d́a iŋcupɨctámpa iga Dios wɨa̱p? Pero agui aŋjécneyaj jém icuyujcɨɨwiñ. Ipooñaŋja̱myajpa. Nacwácyajta̱p entre jeeyaj: —Que i̱apaap yɨ́p pɨ̱xiñ iga iñɨ́máy jém sa̱wa iga teeñiñ y icupɨcpa. ");
INSERT INTO poiNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ocmɨ núcyaj jém naxyucmɨ de Gadara jém nɨaŋwiñt́uc de jém Galilea. ");
INSERT INTO poiNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jesɨc miquet jém Jesús jém barcojo̱m, miñ tu̱m Gadarapɨc pɨ̱xiñ, icunúc Jesús. Jáyaŋ tiempo iniit́ jém mal espíritu. Icusɨ̱cɨ sɨɨba. D́a puctugɨ́y, d́a tɨgɨ́y. Nɨcne i̱t́i ju̱t́ cumta̱p tsúts. ");
INSERT INTO poiNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Mu iix jém Jesús, jém pɨ̱xiñ co̱ste̱ññeactɨŋ ipuycɨɨm. Pɨ̱mi aŋwejpa. Nɨmpa: —¿T́iiga mit́ɨgɨycúmpa con aɨcht́am? Mich miJesús jém Yucmɨpɨc Dios miMa̱nɨc. Maŋcunucsáypa, odoy ayaachwa̱tɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Iñɨ́máy je̱mpɨc porque Jesús iquebacputpa jém mal espíritu jém pɨ̱xiñ ia̱namaŋjo̱m. Wa̱t́cɨy jém mal espíritu imats jém pɨ̱xiñ. Jém it́yajwɨɨp jém attebet ichénayñeyaj id́ɨc icɨ y ipuy con cadena. Pero ijacpa jém cadena y jém tɨ́ŋcuy jém iñuusmatsayñewɨɨp ipuy. Jém mal espíritu ichɨcpoypa jém pɨ̱xiñ hasta jém tɨtsɨnaxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesɨc Jesús icwác jém pɨ̱xiñ, iñɨ́máy: —¿Mich, i̱ iññɨ̱yi? Icutsoŋ. Nɨmpa: —Ɨch aLegión. Taɨch tanaŋmat́i̱mɨ nɨmtooba jém jáyaŋpɨc. Icnɨɨya̱ je̱mpɨc porque tsa̱m jáyaŋ iniit́ jém mal espíritu. ");
INSERT INTO poiNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Jém mal espíritu icunucsáy Jesús iga odoy icnɨguiñ jém mɨjpɨc josjo̱m ju̱t́ pajta̱p jém mal espíritu. ");
INSERT INTO poiNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Jesɨc it́ id́ɨc je̱m tsa̱m jáyaŋ yo̱ya. Wícyajpa jém lumuyucmɨ. Jém mal espíritu iñɨ́máy Jesús: —Ajɨ́gayt́aamɨ iga atɨgɨyt́ámpa jém yo̱ya ia̱namaŋjo̱m. Jesɨc Jesús ijɨ́gáy. ");
INSERT INTO poiNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Jém mal espíritu ichacum jém pɨ̱xiñ. Putum ia̱namaŋjo̱m. Tɨgɨy jém mal espíritu jém yo̱ya ia̱namaŋjo̱m. Jesɨc jém yo̱ya póyaŋtsucumyaj, joobaŋnasyaj jém tejajyucmɨ. Actɨŋyaj jém nɨɨcɨɨm. Jicjiccayaj jém yo̱ya. ");
INSERT INTO poiNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Jesɨc jém iwatyajpaap cuenta jém yo̱ya, iixyaj t́i iñasca jém yo̱ya. Tsa̱m cɨ̱ŋneyaj jeeyaj. Póyaŋtsucumyaj. Nɨcpa iŋmatyaj jém attebet Gadara y jém it́yajwɨɨp nocojo̱m t́i iñasca jém yo̱ya. ");
INSERT INTO poiNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Jesɨc miñ iámyaj it́u̱mpɨy jém pɨxiñt́am t́i iñasca jém yo̱ya. Miñúcyaj ju̱t́ it́ jém Jesús, ju̱t́ jicjicca jém yo̱ya, ipátyaj jém pɨ̱xiñ jém iniit́wɨɨp id́ɨc jém mal espíritu. Jemum co̱ñ jém Jesús ipuycɨɨm, puctugɨ́yum, jɨ̱xiɨ́yum. Jesɨc tsa̱m cɨ̱ŋneyaj jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Jém iixyajwɨɨp t́i iwat Jesús, iŋmadayyajpa jém pɨxiñt́am jém miññeyajwɨɨp jutsa̱ micpɨsta̱ jém iniit́wɨɨp id́ɨc jém mal espíritu. ");
INSERT INTO poiNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Jesɨc it́u̱mpɨy jém Gadarapɨc pɨxiñt́am tsa̱m icɨ̱ŋyajpa jém Jesús. Nɨ́mayt́a̱ jém Jesús iga cáyiñ de je̱m. Jeeyucmɨ tɨgɨy Jesús jém barcojo̱m, e̱ybɨc se̱t ju̱t́ tsucum. ");
INSERT INTO poiNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Pero jém pɨ̱xiñ jém iniit́wɨɨp id́ɨc jém mal espíritu icunucsáy Jesús iga nɨcpa it́úŋɨ́y. Pero Jesús d́a ijɨ́gáy. Ipɨɨmɨ́y iga tsɨ́yiñ. Iñɨ́máy: ");
INSERT INTO poiNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Nɨcsɨm iñt́ɨccɨɨm. Aŋmadaayɨ jém iñt́ɨ̱wɨtam t́i miwadáy Dios. Jesɨc nɨc jém pɨ̱xiñ. Nɨc iŋmat icuwɨ̱t́i jém attebet t́i iwadáy jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jesɨc se̱tgacum Jesús jém laguna aŋwiñt́uc. Jém pɨxiñt́am, jém it́yajwɨɨp je̱m, iwɨ̱pɨctsoŋyaj. Agui maymayyaj porque it́u̱mpɨy iŋjócneyaj id́ɨc. ");
INSERT INTO poiNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Jesɨc núc tu̱m pɨ̱xiñ iñɨ̱yi Jairo. Sinagoga aŋjagooyi jém pɨ̱xiñ. Co̱ste̱ññeactɨŋ jém Jesús ipuycɨɨm. Icunucsáy iga nɨguiñ it́ɨccɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Jém Jairo iniit́ tu̱m iyo̱mma̱nɨc, doce ia̱mt́ɨy. Tsa̱m pɨ̱mi mɨmne jém wo̱ñi hasta caatoobam. Iganam nɨcpa Jesús, tsa̱m jáyaŋ jém pɨxiñt́am icpɨtsɨyyajpa. ");
INSERT INTO poiNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","It́ con jeeyaj tu̱m yo̱mo mɨmne doce a̱mt́ɨy con jém caacuy iga quetpa iñɨɨpiñ. Jém yo̱mo yaj miwadáy gasto it́u̱mpɨy it́umiñ iga iyoj jém tsóyɨ́yoypaap. Pero d́a i̱ wɨa̱ micpɨs. ");
INSERT INTO poiNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Jesɨc jém yo̱mo icunúc Jesús it́uuñiaŋcɨɨm. Ichɨgáy jém Jesús iyoot́i iŋna̱ca. Jeet́i rato te̱ñ jém iñɨɨpiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesɨc acwágóypa Jesús. Nɨmpa: —¿I̱ atsɨc? Nɨmyajpa it́u̱mpɨy iga d́a i̱ michɨc. Jesɨc jém Peto con jém tuŋgac icuyujcɨɨwiñ iñɨ́mayyaj Jesús: —MamMaestro, tsa̱m jáyaŋ pɨxiñt́am micpɨtsɨyyajpa, micyágɨ́ypa. ¿T́iiga micwágóypa iga i̱ michɨc? ");
INSERT INTO poiNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Pero Jesús nɨmpa: —Atsɨcta̱. Aŋcutɨɨyɨ́y iga anacpɨs tu̱m mɨmnewɨɨp con ampɨ̱mi. ");
INSERT INTO poiNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Jém yo̱mo iix iga cutɨɨyɨyt́a̱. Agui cɨ̱ŋne, agui cuetsáypa imiñ. Co̱ste̱ññeactɨŋ jém Jesús ipuycɨɨm. Nɨmpa jém yo̱mo jém pɨxiñt́am iwiñjo̱m: —Ɨch mantsɨgáy iñyoot́i iga apɨxiñ. Jeet́i rato apɨs. ");
INSERT INTO poiNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesɨc Jesús iñɨ́máy: —Miyo̱mo, mipɨsneum porque iŋcupɨcne Dios. Sɨɨp chogoyñɨcsɨm. ");
INSERT INTO poiNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Iganam iŋquímpa Jesús jém yo̱mo, jesɨgam núc tu̱m de jém Jairo it́ɨccɨɨm. Miñ iŋmadáy jém Jairo. Nɨ́mayt́a̱p: —Caaneum jém iñyo̱mma̱nɨc. Odom más co̱bacpi̱jɨ yɨ́p tamMaestro. ");
INSERT INTO poiNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Pero cuando Jesús imatoŋ, iñɨ́máy jém Jairo: —Odoy cɨ̱ŋɨ. Cupɨ̱cɨ Dios. Pɨspa iñyo̱mma̱nɨc. ");
INSERT INTO poiNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jesɨc núc Jesús jém Jairo it́ɨccɨɨm, d́a ijɨ́c iga i̱ tɨgɨypa. Icut́um tɨgɨy Jesús con jém Peto, Jacobo, Xiwan y jém wo̱ñi ija̱tuŋ con ia̱pa. ");
INSERT INTO poiNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Agui wejyajpa jém it́yajwɨɨp je̱m. Pɨ̱mi aŋyácneyaj iga caaneum jém wo̱ñi. Pero Jesús iñɨ́máy: —Odoy wejtaamɨ. D́a caane yɨ́p wo̱ñi, moŋpa. ");
INSERT INTO poiNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Pero jém pɨxiñt́am ixiccayajpa jém Jesús porque iñuntawɨ̱jo̱doŋ iga caaneum jém wo̱ñi. ");
INSERT INTO poiNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Pero jesɨc Jesús imatsáy jém wo̱ñi icɨ. Pɨ̱mi ijɨ́yáy. Iñɨ́máy jém wo̱ñi: —Miwo̱ñi, tsucu̱mɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Jesɨc e̱ybɨct́im miñ ia̱nama, jeet́i rato tsucum jém wo̱ñi. Jesɨc jém Jesús iñɨ́máy ia̱pa iga icwíguiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ipooñaŋja̱myajpa ija̱tuŋ con ia̱pa. Jesús iñɨ́máy iga odoy i̱ iŋmadáyiñ t́i iñasca jém wo̱ñi. ");
INSERT INTO poiNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesɨc tu̱m ja̱ma jém Jesús iŋtuuma̱wat jém doce icuyujcɨɨwiñ. Ichi ipɨ̱mi iga wɨa̱iñ it́op jém mal espíritu y iga wɨa̱iñ icpɨsyaj jém mɨmneyajwɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Icutsat iga nɨguiñ iŋmatyaj jém aŋma̱t́i ju̱t́pɨc iŋjacpa Dios yɨ́p naxyucmɨ. Icutsat iga icpɨsyajiñ jém mɨmneyajwɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Jesɨc Jesús iñɨ́máy jém icuyujcɨɨwiñ: —Odoy nanɨctaamɨ ni t́i tuŋjo̱m, ni imbastun, ni imbolsa, ni a̱ñi, ni tumiñ. Nanɨctaamɨ no más tu̱m iñyoot́i. ");
INSERT INTO poiNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Cuando miñúctámpa tu̱m tɨccɨɨm, jemum michɨ́ypa hasta miñɨcpa tuŋgac tɨgaŋjoj. ");
INSERT INTO poiNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Siiga d́a i̱ miwɨ̱pɨctsoŋtámpa, puttaamɨ jém attebet. Cunebayt́aamɨ impuy iga cáyiñ jém pótpót. Wattaamɨ je̱mpɨc iga iniŋquejáypa iga tsa̱m maloyaj jém it́yajwɨɨp je̱m. ");
INSERT INTO poiNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Jesɨc moj nɨquiyaj jém icuyujcɨɨwiñ, nasyajpa it́u̱mpɨy jém tɨgaŋjoj. Iŋmatyajpa jém wɨbɨc aŋma̱t́i iga tacɨacputtámpa Dios. Ju̱t́quej icpɨsyajpat́im jém mɨmneyajwɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Jém gobernador Herodes ijo̱dóŋa̱ t́i iwatpa Jesús. Pero d́a icutɨɨyɨ́ypa i̱apaap jém Jesús porque nɨmyajpa algunos iga pɨsneum jém Xiwan jém it́ɨŋcujagayñewɨɨp iɨscɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Pero tuŋgac nɨmyajpa iga wiñquejne jém Elías, tuŋgac nɨmyajpa iga pɨsnegacum tu̱m jém wiñɨcpɨc profeta. ");
INSERT INTO poiNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Pero jém Herodes nɨmpa: —Aɨch anyaac ampɨɨmɨ́y iga tɨŋcujagayt́a̱iñ iɨscɨ jém Xiwan. ¿Jesɨc i̱apaap yɨ́p pɨ̱xiñ jém ammatoŋnewɨɨp iga wɨa̱p iwat jáyaŋ jém wɨ̱tampɨc cosa? Jesɨc jém Herodes agui iixt́ooba jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jesɨc mixe̱tyaj jém apóstolyaj, iŋmadayyaj jém Jesús t́i iñascayaj. Jesɨc iwagananɨcyaj jém doce icuyujcɨɨwiñ tuŋgac lugar ju̱t́ d́a t́i id́ɨ́yɨ́y, nocojo̱m jém attebet Betsaida. ");
INSERT INTO poiNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pero ijo̱dóŋa̱yaj jém pɨxiñt́am ju̱t́ nɨc Jesús, jesɨc nɨc icpoyyaj. Jesɨc Jesús ipɨctsoŋ jém pɨxiñt́am. Moj iŋquejáy ju̱t́pɨc iŋjacpa Dios jém it́yajwɨɨp yɨ́p naxyucmɨ. Icpɨspat́im jém mɨmneyajwɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Jesɨc tsuuyɨm. Tɨgɨyt́oobam ja̱ma. Jém doce icuyujcɨɨwiñ icunúcyaj jém Jesús. Iñɨ́mayyaj: —Aŋquímya̱jɨ jém pɨxiñt́am iga nɨguiñam mo̱ŋiyaj iga nɨguiñ imétsyaj jém wíccuy jém tɨgaŋjoj y jém ranchoyaj jém it́yajwɨɨp nocojo̱m. Porque yɨɨm d́a t́i id́ɨ́yɨ́y. ");
INSERT INTO poiNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Pero Jesús iñɨ́máy icuyujcɨɨwiñ: —Acwíctaamɨ mimicht́am. Nɨmyajpa jeeyaj: —D́a t́i anait́t́a más que cinco caxt́ána̱ñi y wɨste̱n tɨɨpɨ. ¿T́i iñxunpa, iga nɨcpa tanjuy wíccuy iga tanacwícpa it́u̱mpɨy jém it́yajwɨɨp yɨɨm? ");
INSERT INTO poiNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Porque it́yaj como cinco mil jém pɨxiñt́am. Pero Jesús iñɨ́máy jém icuyujcɨɨwiñ: —Sɨɨp acco̱ñya̱jɨ como cincuenta cada grupo. ");
INSERT INTO poiNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Jesɨc je̱mpam iwatyaj jém icuyujcɨɨwiñ. Acco̱ñyajta̱ naxyucmɨ it́u̱mpɨy jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jesɨc Jesús ipɨc jém cinco caxt́ána̱ñi y jém wɨste̱n tɨɨpɨ. Ámquím sɨŋyucmɨ, iŋwejpát Dios. Jesɨc mojum iwenwenjac jém caxt́ána̱ñi y jém tɨɨpɨ. Ichi icuyujcɨɨwiñ, ipɨɨmɨ́y iga ichiiyajiñ jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Jesɨc it́u̱mpɨy wícyaj, cusyajum. Ocmɨ ipiŋyaj doce nacooŋ jém caxt́ána̱ñi y jém tɨɨpɨ jém cutsɨ́ywɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Jesɨc tu̱m ja̱ma icut́um tsɨ́y Jesús con icuyujcɨɨwiñ iga iŋwejpátpa Dios. Jesɨc acwágóypa Jesús, iñɨ́máy jeeyaj: —¿Junɨmyajpa iga ai̱apaap aɨch? ");
INSERT INTO poiNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Jesɨc icutsoŋyaj jém icuyujcɨɨwiñ: —Nɨmyajpa iga mich miXiwan jém acchíŋoypaap. Tuŋgac nɨmyajpa iga mich miElías. Tuŋgac nɨmyajpa iga mich jém wiñɨcpɨc profeta jém pɨsnewɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Jesɨc Jesús e̱ybɨct́im icwác jém icuyujcɨɨwiñ. Nɨmpa: —¿Mimicht́am, mijunɨmtámpa iga ai̱apaap aɨch? Jém Peto iñɨ́máy jém Jesús: —Mich miCristo jém micutsatnewɨɨp Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pero Jesús iŋquím icuyujcɨɨwiñ: —Odoy i̱ aŋmadaayɨ iga ɨcham aCristo. ");
INSERT INTO poiNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Jesɨc nɨmt́im Jesús: —Ɨch, jém aMiññewɨɨp Sɨŋyucmɨ, tsa̱m pɨ̱mi ayaachwatta̱p. Tsa̱m pɨ̱mi ajóyixyajpa jém wɨd́ayt́am, jém pa̱nij aŋjagooyiyaj y jém escribaspɨc maestroyaj. D́a awɨ̱pɨctsoŋyajpa. Ocmɨ accaata̱p, pero jém tucunaja̱ma acpɨsta̱p. ");
INSERT INTO poiNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Jesɨc Jesús iñɨ́máy it́u̱mpɨy de jeeyaj: —Siiga micht́am antúŋɨyt́amtooba, jesɨc odoy natoyt́a̱jɨ iñyaac. Yaachɨɨyɨ cuando miyaachwatta̱p, atúŋɨɨyɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Pero siiga tu̱m pɨ̱xiñ tsa̱m it́oypa ivida iga it́pa yɨ́p naxyucmɨ, jesɨc togoypa ivida. Siiga miccaata̱p ɨch aŋcuyucmɨ, jesɨc d́a togoypa imvida, micɨacputta̱p. ");
INSERT INTO poiNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","D́a t́i cuwatcuy siiga tu̱m pɨ̱xiñ iniit́ it́u̱mpɨy cosa jém it́wɨɨp yɨ́p naxyucmɨ, pero ocmɨ caaba y togoypa ia̱nama. ");
INSERT INTO poiNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Siiga michaa̱p iga iniŋmatpa ɨch anaŋma̱t́i o siiga mich antsaaixpa, jesɨc ɨchgact́i jém aMiññewɨɨp Sɨŋyucmɨ mantsaaixpat́im cuando amiñgacpa yɨ́p naxyucmɨ con jém sɨŋyucmɨpɨc pɨxiñt́am y con jém tanJa̱tuŋ Dios ipɨ̱mi. ");
INSERT INTO poiNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nu̱ma mannɨ́máypa iga algunos de mimicht́am d́a micaaba hasta que íñixpa ju̱t́pɨc iŋjacpa Dios yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ocmɨ cuando yaj iŋmat Jesús, tuŋgac ocho día, quím tu̱m co̱tsɨcyucmɨ. Iwaganasɨɨba jém Peto, Jacobo y Xiwan. Nɨc iŋwejpát Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Jesɨc iganam iŋwejpátpa Dios, aŋcac jém Jesús iámooyi. Pɨ̱mi po̱po ipuctu̱cu, tsa̱m pɨ̱mi tsocpa. ");
INSERT INTO poiNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Jeet́i rato núc wɨste̱n jém wiñɨcpɨc pɨ̱xiñ, jém Moisés y jém Elías, miñ iŋmatmatneyaj con jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Agui tsocpat́im mex jeeyaj. Aŋmatyajpa con Jesús jutsa̱p iccupac jém Dios iyo̱xacuy cuando accaata̱p Jerusalén. ");
INSERT INTO poiNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Tsa̱m moŋtooba id́ɨc jém Peto con jém icompañeroyaj. Ocmɨ cáy jém imo̱ŋi, mu iixyaj iga agui tsocpa jém Jesús iámooyi con ipuctu̱cu y tsocyajpat́im jém wɨste̱n pɨ̱xiñ jém miññewɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Jesɨc iganam nɨctooba jém Moisés y Elías, jém Peto iñɨ́máy jém Jesús: —MamMaestro, agui wɨ̱ iga tait́pa yɨɨm. Sɨɨp maŋwadayt́ámpa tucute̱n nacxt́ɨc. Tu̱m para mimich, tu̱m para Moisés y tu̱m para Elías. Jém Peto cumoŋ ijɨ̱xi. D́a icutɨɨyɨ́ypa t́i nɨmpa. ");
INSERT INTO poiNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Iganam jɨypa jém Peto, actɨŋ tu̱m ucsɨ. Iŋmonyaj. Jesɨc tsa̱m pɨ̱mi cɨ̱ŋyaj jém Peto con jém icompañeroyaj iga tsɨ́y jém ucscucɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Jesɨgam imatoŋyajpa tu̱m jɨ̱yi jém ucsaŋjo̱m. Nɨmpa: —Yɨ́bam ɨch amMa̱nɨc, jém tsa̱mpɨc antoypa. Matoŋtaamɨ t́i miñɨ́máypa. ");
INSERT INTO poiNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Cuando cuyajum jém jɨ̱yi, jesɨc jém icuyujcɨɨwiñ iixyaj iga icut́umt́im tsɨ́y jém Jesús. Jesɨc jém icuyujcɨɨwiñ d́a t́i ijɨyyaj. Jém tiempo d́a i̱ iŋmadayyajpa t́i iixñeyaj. ");
INSERT INTO poiNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Jesɨc tuŋgagam ja̱ma quetyaj jém co̱tsɨcyucmɨ jém Jesús con icuyujcɨɨwiñ. Tsa̱m jáyaŋ pɨxiñt́am miñ imétsyaj Jesús. ");
INSERT INTO poiNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Jesɨc tu̱m pɨ̱xiñ pɨ̱mi ijɨ́yáy jém Jesús jém pɨxiñt́am aŋcucmɨ. Nɨmpa: —Maestro, awadaayɨ tu̱m favor. Aámaayɨ yɨ́p amma̱nɨc porque nada más tu̱m anait́. ");
INSERT INTO poiNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Imatsne tu̱m mal espíritu. Agui imalwadáypa. Tsa̱m pɨ̱mi aŋwejpa. Imatspa jém co̱ñxus caacuy. Aŋmoypacpa ijɨp. D́a ichacpa, pɨ̱mi iyaachwatpa. ");
INSERT INTO poiNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Aŋcunucsayt́ɨp jém iŋcuyujcɨɨwiñ iga it́obáyiñ jém mal espíritu, pero jeeyaj d́a wɨa̱ mit́obáy. ");
INSERT INTO poiNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesɨc Jesús iñɨ́máy jém pɨxiñt́am: —A que mimicht́am, ¿t́iiga d́a iŋcupɨctámpa iga Dios wɨa̱p? ¿T́iiga d́a iŋcutɨɨyɨyt́ámpa? Jáyum tawagai̱t́i con mimicht́am, tsa̱m manyaachɨ́yum, pero hasta sɨɨp d́at́im aŋcupɨctámpa. Jesɨc Jesús iñɨ́máy jém tsɨ̱xi ija̱tuŋ: —Nami̱ñɨ yɨɨm jém imma̱nɨc. ");
INSERT INTO poiNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Iganam núcpa jém jaychɨ̱xi, imats jém mal espíritu. Iccutɨŋ naxyucmɨ. E̱ybɨct́im imats jém co̱ñxus caacuy. Jesɨc Jesús iwogáy jém mal espíritu, it́obáy. Icpɨs jém jaychɨ̱xi. Icɨɨjuŋcodáy ija̱tuŋ. ");
INSERT INTO poiNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Agui ipooñaŋja̱myajpa it́u̱mpɨy jém it́yajwɨɨp je̱m, cuando iixyaj iga tsa̱m pɨ̱mi wɨa̱p jém tanJa̱tuŋ Dios. Jesɨgam agui ámaŋjacyaj jém iixñeyajwɨɨp t́i iwat jém Jesús. Nɨmyajpa jeeyaj iga d́a queman tánix yɨcxpɨc cosa. Pero Jesús iñɨ́máy icuyujcɨɨwiñ: ");
INSERT INTO poiNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Wɨ̱matoŋtaamɨ iga odoy iñjaamaŋnod́iñ. Ɨch, jém aMiññewɨɨp Sɨŋyucmɨ, acɨɨjuŋcotta̱p jém malopɨc pɨxiñt́am icɨɨjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pero jém icuyujcɨɨwiñ d́a icutɨɨyɨyyajpa t́i nɨmpa Jesús. Dios d́a ijɨ́cpa iga icutɨɨyɨyyajiñ. Cɨ̱ŋyajpa iga icwácyajpa t́i nɨmtooba. ");
INSERT INTO poiNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Jesɨc Jesús icuyujcɨɨwiñ moj nacwácyajta̱ji entre jeeyaj iga i̱ tsɨ́ypa jém más mɨjpɨc aŋjagooyi. ");
INSERT INTO poiNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Pero Jesús icutɨɨyɨ́y t́i sɨ́p ijɨ̱syaj jém icuyujcɨɨwiñ, jesɨc iŋwejáy tu̱m xut́u tsɨ̱xi. Inimiñ ju̱t́ co̱ñ Jesús. ");
INSERT INTO poiNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Iñɨ́máy jém icuyujcɨɨwiñ: —Siiga tu̱m pɨ̱xiñ iwɨ̱pɨctsoŋpa tu̱m xut́u tsɨ̱xi juuts yɨ́p tsɨ̱xi iga iŋquejáypa anaŋma̱t́i, jesɨc jém pɨ̱xiñ awɨ̱pɨctsoŋpat́im mex aɨch. Siiga awɨ̱pɨctsoŋpa aɨch, jesɨc iwɨ̱pɨctsoŋpat́im jém anJa̱tuŋ Dios jém acutsatnewɨɨp yɨ́p naxyucmɨ. Jém pɨ̱xiñ, jém d́apɨc nacujípta̱p, tsɨ́ypa juuts jém mɨjpɨc aŋjagooyi. ");
INSERT INTO poiNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jesɨc jém Xiwan iñɨ́máy Jesús: —MamMaestro, ánixñeta tu̱m pɨ̱xiñ it́oppa jém mal espíritu mich iññɨyi̱mɨ. Jesɨc anaŋjɨyjacta porque jém pɨ̱xiñ d́a sɨɨba con taɨcht́am. ");
INSERT INTO poiNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Pero Jesús iñɨ́máy: —Odoy aŋjɨyjactaamɨ porque jém d́apɨc nɨcpa en contra de taɨcht́am, tayo̱xpátpa. ");
INSERT INTO poiNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jesɨc núcpa jém tiempo iga químgacpa sɨŋyucmɨ jém Jesús. Duro ijɨ̱spa iga nɨcpa iccupac jém Dios iyo̱xacuy jemɨgam Jerusalén. ");
INSERT INTO poiNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Jesɨc Jesús icutsat wɨste̱n icuyujcɨɨwiñ iga nɨguiñ tu̱m Samariapɨc attebet iga iwɨ̱tsacpa tu̱m tɨc ju̱t́ núcpa. ");
INSERT INTO poiNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pero jém Samariapɨc pɨxiñt́am d́a ipɨctsoŋ, d́a ichiiba lugar porque iixyaj iga nɨcpa Jesús Jerusalén. ");
INSERT INTO poiNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jesɨc cuando jém icuyujcɨɨwiñ jém Xiwan y jém Jacobo iix iga jém Samariapɨc pɨxiñt́am d́a ipɨctsoŋpa Jesús, nɨmpa jém icuyujcɨɨwiñ: —MánO̱mi, siiga iñxunpa, anacquettámpa jém sɨŋyucmɨpɨc juctɨ iga anactogoypa yɨ́p attebet. Wɨa̱pt́im aŋwatta juuts iwat jém wiñɨcpɨc aŋmat́cɨɨwiñ jém Elías. ");
INSERT INTO poiNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jesɨc Jesús iámmats jém Xiwan y Jacobo. Iwogáy. Nɨ́mayyajta̱p: —Mimicht́am, d́a iŋcutɨɨyɨyt́ámpa juppɨc jɨ̱xi tanait́. ");
INSERT INTO poiNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ɨch jém aMiññewɨɨp Sɨŋyucmɨ d́a amiñ iga anactogoypa jém it́yajwɨɨp yɨ́p naxyucmɨ, miñ aŋcɨacput. Ocmɨ nɨcyaj tuŋgac tɨgaŋjoj. ");
INSERT INTO poiNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Iganam nɨquiyaj tuŋjo̱m, tu̱m pɨ̱xiñ iñɨ́máy jém Jesús: —MánO̱mi, ɨch nɨcpa mantúŋɨ́y. Siempre ju̱t́ miñɨcpa ɨch anɨcpat́im. ");
INSERT INTO poiNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesɨc Jesús iñɨ́máy jém pɨ̱xiñ: —Jém zorra iniit́ ijos ju̱t́ moŋpa. Jém jon iniit́ ipeeñi. Pero ɨch, jém aMiññewɨɨp Sɨŋyucmɨ, d́a anai̱ ju̱t́ wɨa̱p anacjej aŋco̱bac. ");
INSERT INTO poiNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesɨc Jesús iñɨ́máy tuŋgagam pɨ̱xiñ: —Atúŋɨɨyɨ. Pero jém pɨ̱xiñ nɨmpa: —MánO̱mi, achi̱ɨ lado iga nɨcpa aŋcum jém anja̱tuŋ, jesɨc nɨcpa mantúŋɨ́y. ");
INSERT INTO poiNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesús iñɨ́máy jém pɨ̱xiñ: —Tsa̱cɨ jém caaneyajwɨɨp iga nacumyajta̱p jeeyaj. Pero mich nɨ̱gɨ aŋmadaayɨ jém pɨxiñt́am jutsa̱p iŋjac Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Jesɨc tuŋgagam pɨ̱xiñ iñɨ́máy: —MánO̱mi, ɨch nɨctooba mantúŋɨ́y, pero wiñt́i ajɨ́gaayɨ iga nɨcpa anaŋquím jém it́yajwɨɨp antɨccɨɨm. Jesɨc nɨcpa mantúŋɨ́y. ");
INSERT INTO poiNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Pero Jesús iñɨ́máy: —Siiga tu̱m pɨ̱xiñ imatscunúcpa jém arado y ámse̱tpa it́uuñiaŋcɨɨm, d́a wɨa̱p icuyo̱xa̱ Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ocmɨ tánO̱mi icupiŋ setenta más icuyujcɨɨwiñ. Icutsat wɨswɨs cada attebet ju̱t́ jém Jesús nɨctooba iŋmat jém Dios iŋma̱t́i. Wiñt́i nɨcyajpa jém icuyujcɨɨwiñ, ocmɨ nɨcpa Jesús. ");
INSERT INTO poiNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Jesɨc Jesús iñɨ́máy jém icuyujcɨɨwiñ: —Como tu̱m mɨjpɨc cosecha tsa̱m jáyaŋ pɨxiñt́am icupɨcyajtooba jém Dios iŋma̱t́i. Pero d́a i̱ wa̱t́i jém yo̱xacɨɨwiñ jém iŋmatyajpáppɨc jém Dios iŋma̱t́i. Sɨɨp cunucsaayɨ Dios iga icutsad́iñ jém yo̱xacɨɨwiñ iga ipiŋpa jém cosecha. ");
INSERT INTO poiNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Sɨɨp nɨcsɨm. Mimicht́am mijext́am juuts tu̱m mima̱ñborrego. Sɨɨp maŋcutsattámpa ju̱t́ it́ jém loboyaj. ");
INSERT INTO poiNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Odoy nanɨctaamɨ immorral, ni iñt́umiñ accáycuy, ni tuŋgac iŋcɨac. Odoy teeñaŋja̱cɨ tuŋjo̱m iga algun i̱ iñdioschiiba. ");
INSERT INTO poiNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Jesɨc mit́ɨgɨyt́ámpa tu̱m tɨcjo̱m, wiñt́i dioschioyt́aamɨ. Nɨmtaamɨ iga: “Dios miwɨ̱wadáyiñ, miit́wɨɨp yɨ́p tɨccɨɨm.” ");
INSERT INTO poiNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Siiga jemum it́ jém it́oypáppɨc Dios, jesɨc miwɨ̱aŋtsoŋpa. Pero siiga it́ jém ijóyixpáppɨc Dios, jesɨc d́a miwɨ̱aŋtsoŋpa. ");
INSERT INTO poiNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Jesɨc tsɨ́yt́aamɨ jeet́im tɨccɨɨm ju̱t́ miwɨ̱pɨctsoŋtamta̱. Siiga micwíctamta̱p, jesɨc wíctaamɨ, nɨ́ctaamɨ. Wɨ̱ iga yojta̱p jém yo̱xacɨɨwiñ, wɨa̱p ipɨctsoŋ icoñwɨyooyi. Pero odoy wíctaamɨ yɨɨm jeexɨc tɨc por tɨc. ");
INSERT INTO poiNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Jesɨc miñúctámpa tu̱m attebet ju̱t́ miwɨ̱pɨctsoŋta̱p, cúttaamɨ t́it́am michiit́amta̱p. ");
INSERT INTO poiNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Acpɨstaamɨ jém mɨmneyajwɨɨp jém it́yajwɨɨp je̱m. Nɨ́mayt́aamɨ iga núctooba jém tiempo iga Dios iŋjacpa jém it́yajwɨɨp yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pero cuando miñúcpa tu̱m attebet ju̱t́ d́a i̱ miwɨ̱pɨctsoŋpa, jesɨc nɨctaamɨ calle, aŋmadaayɨ jém it́yajwɨɨp. Nɨ́maayɨ: ");
INSERT INTO poiNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Sɨɨp aŋcunebáypa ampuy iga antsacpa yɨɨm jém pótpót jém anait́wɨɨp ampuyyucmɨ. Aŋwatpa je̱mpɨc iga manaŋquejáypa iga d́a i̱ awɨ̱pɨctsoŋta. Pero jo̱dóŋa̱taamɨ iga manaŋquejayt́ooba id́ɨc jutsa̱p iŋjac Dios jém it́yajwɨɨp yɨ́p naxyucmɨ.” ");
INSERT INTO poiNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Pero mannɨ́mayt́ámpa, maŋcuyujcɨɨwiñ, iga cuando núcpa jém ja̱ma iga Dios icɨɨpiŋpa jém it́yajwɨɨp yɨ́p naxyucmɨ, jesɨc más pɨ̱mi chiit́a̱p castigo jém attebet, jém d́apɨc miwɨ̱pɨctsoŋta, que jém malopɨc attebet jém Sodoma. ");
INSERT INTO poiNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’¡Agui miuuguyt́im mimicht́am, miit́wɨɨp jém attebet Corazín! ¡Agui miuuguyt́im mimicht́am miit́wɨɨp jém attebet Betsaida! Jém it́yajwɨɨp jém attebet Tiro y jém Sidón d́a iixñeyaj jém milagro juuts sɨɨp íñixpa. Pero meega iixñeyaj, pecam ichacneyaj jém imalajɨ̱xi, agui aŋyácneyaj iga táŋcaɨ́y. ");
INSERT INTO poiNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Pero núcpa jém ja̱ma iga Dios icɨɨpiŋpa jém it́yajwɨɨp yɨ́p naxyucmɨ. Cuando micɨɨpiŋtámpa, jesɨc michiit́amta̱p más pɨ̱mi castigo que jém wɨste̱n malopɨc attebet jém Tiro y jém Sidón. ");
INSERT INTO poiNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Mimicht́am, Capernaumpɨc mipɨxiñt́am, tsa̱m minicujíptamta̱p, iñjɨ̱spa iga mininɨctamta̱p sɨŋyucmɨ, pero micquettamta̱p hasta jém infierno. ");
INSERT INTO poiNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jesɨc Jesús iñɨ́máy icuyujcɨɨwiñ: —Siiga tu̱m pɨ̱xiñ mimatoŋpa mimicht́am, jex juuts ɨch amatoŋpa. Pero siiga tu̱m pɨ̱xiñ mijóyixpa mimicht́am, ajóyixpat́im aɨch. Siiga tu̱m pɨ̱xiñ ajóyixpa aɨch, ijóyixpat́im jém anJa̱tuŋ Dios jém acutsatnewɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Jesɨc ocmɨ se̱tyaj jém setenta jém icuyujcɨɨwiñ. Agui maymayyaj. Nɨmyajpa: —MánO̱mi, wɨa̱pt́im antop jém mal espíritu mich iññɨyi̱mɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesɨc Jesús iñɨ́máy: —Ɨch ánix iga coñwɨyt́a̱ jém Woccɨɨwiñ. Actɨŋ dende sɨŋyucmɨ juuts tu̱m majɨywiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Sɨɨp matoŋtaamɨ. Manchiiba jém pɨ̱mi iga wɨa̱p iŋcunepquet jém tsa̱ñ y jém cacwi. Manchiibat́im jém pɨ̱mi iga iŋcoñwɨ́yiñ it́u̱mpɨy jém Woccɨɨwiñ ipɨ̱mi iga odoy wɨa̱iñ mimalwadáy. ");
INSERT INTO poiNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pero odoy maymáya̱taamɨ iga wɨa̱p iñt́op jém mal espíritu. Maymáya̱taamɨ iga mijaycámayñeta̱ iññɨ̱yi sɨŋyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Jesɨc jeet́i rato agui maymay Jesús porque jém Dios iA̱nama icmaymáya̱p. Moj iŋwejpát Dios. Nɨmpa: —ManJa̱tuŋ, it́u̱mpɨy jém it́yajwɨɨp sɨŋyucmɨ y naxyucmɨ mich immɨɨchi. Maŋcujíppa iga d́a iñjɨ́gáypa jém sabioyaj iga icutɨɨyɨ́ypa jém wɨbɨc jɨ̱xi. Pero agui miwɨ̱ iga iñchiiba jɨ̱xi jém pɨxiñt́am jém d́apɨc nacujípta̱p iyaac iga wɨa̱iñ icutɨɨyɨ́y jém wɨbɨc jɨ̱xi. Nu̱ma quejpa sɨɨp iga je̱mpɨgam iŋwɨ̱aŋja̱m. ");
INSERT INTO poiNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Jesɨc Jesús iñɨ́máy jém icuyujcɨɨwiñ: —AnJa̱tuŋ Dios acɨɨjuŋcodáy it́u̱mpɨy cosa. D́a i̱ ijo̱doŋ i̱apaap jém Dios iMa̱nɨc, jém anJa̱tuŋ icut́um ijo̱doŋ. D́a i̱ ijo̱doŋ i̱apaap jém anJa̱tuŋ Dios, ɨch, Dios aMa̱nɨc, anjo̱doŋ. Ijo̱doŋt́im jém pɨxiñt́am, jém aŋquejayñewɨɨp i̱apaap Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Jesɨc Jesús icuámse̱t jém icuyujcɨɨwiñ. Iñɨ́máy naps jeeyaj: —Agui miwɨ̱it́t́ámpa porque sɨɨp íñixt́a t́it́am iwatpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Mannɨ́mayt́ámpa iga jáyaŋ jém wiñɨcpɨc profeta y jém reyyaj iixyajtooba id́ɨc t́it́am sɨ́p íñixt́a. Pero d́a wɨa̱ miixyaj. Imatoŋyajtooba id́ɨc t́it́am sɨ́p immatoŋta, pero d́a wɨa̱ mimatoŋyaj. ");
INSERT INTO poiNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Jesɨc te̱ñchucum tu̱m maestro de jém Israelpɨc aŋquímayooyi iga icutɨtspa Jesús. Iñɨ́máy: —Maestro, ¿t́i wɨa̱p aŋwat iga ampɨctsoŋpa jém vida jém d́apɨc cuyajpa? ");
INSERT INTO poiNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesɨc Jesús iñɨ́máy jém pɨ̱xiñ: —¿Junɨmpa jém Dios iŋma̱t́i jém jayñewɨɨp? ¿T́i immay je̱m? ");
INSERT INTO poiNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Jesɨc jém maestro de jém aŋquímayooyi icutsoŋ jém Jesús. Nɨmpa: —Tantóyiñ jém tanJa̱tuŋ Dios con it́u̱mpɨy tána̱nama, con it́u̱mpɨy tampɨ̱mi y con it́u̱mpɨy tanjɨ̱xi. Tantóyiñ tantɨ̱wɨ como taɨch mismo. ");
INSERT INTO poiNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesɨc Jesús iñɨ́máy jém pɨ̱xiñ: —Nu̱ma, mich aŋwɨ̱cutsoŋ. Siiga iŋwatpa je̱mpɨc, jesɨc impátpa jém vida jém d́apɨc cuyajpa. ");
INSERT INTO poiNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pero jém pɨ̱xiñ naŋquejta̱tooba iyaac iga d́a malo. Jesɨc e̱ybɨct́im icwác Jesús. Nɨmpa: —¿I̱apaap jém antɨ̱wɨ? ");
INSERT INTO poiNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesɨc Jesús iŋmadáy yɨ́p xut́u cuento iga iŋquejáypa i̱apaap jém it́ɨ̱wɨ. Iñɨ́máy: —Tu̱m Jerusalénpɨc pɨ̱xiñ nɨcpa id́ɨc naxwiñ jém attebet Jericó. Pero jém númyajpaap it́eeñaŋjacyaj tuŋjo̱m. Cunúmáyayt́a̱ it́u̱mpɨy jém iniit́wɨɨp, pɨ̱mi cótsta̱, tsacta̱ tuŋjo̱m. Por uxaŋ caaba. Jesɨc nɨc jém númyajpáppɨc. ");
INSERT INTO poiNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ocmɨ miñpa jeet́im tuŋjo̱m tu̱m Israelpɨc pa̱nij. Cuando iix jém coowa̱newɨɨp, icuwid́áy, d́a icunúc, nɨc jém pa̱nij. ");
INSERT INTO poiNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Jesɨc naspat́im tu̱m Levitapɨc pɨ̱xiñ. Icunúc, iám jém coowa̱newɨɨp, icuwid́áyt́im. ");
INSERT INTO poiNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ocmɨ miñpa jeet́im tuŋjo̱m tu̱m Samariapɨc pɨ̱xiñ, tuŋgac pɨ̱xiñ. Mu iix jém coowa̱newɨɨp, iyaachaŋja̱m. ");
INSERT INTO poiNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Icunúc jém pɨ̱xiñ. Ichóyɨ́yáy icoowa̱ji con aceite y vino. Iŋmónáy puctucmɨ. Icquím icawajyucmɨ. Ininɨc tu̱m tɨccɨɨm ju̱t́ watta̱p cuenta. ");
INSERT INTO poiNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Jesɨc tuŋgagam ja̱ma moj nɨqui jém Samariapɨc pɨ̱xiñ. It́op wɨste̱n tumiñ de plata, ichi jém tɨc io̱mi. Iñɨ́máy: “Wa̱tɨ cuenta yɨ́p pɨ̱xiñ. Siiga más jáyaŋ gasto iŋwatpa, miñpa manyojáy cuando anaspa e̱ybɨc.” ");
INSERT INTO poiNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jesɨc yaj iŋmat jém cuento. Jesús icwác jém maestro de jém aŋquímayooyi, iñɨ́máy: —¿I̱ it́ɨ̱wɨ jém coowa̱newɨɨp? ¿Juppɨc de jém tucute̱n, jém nasnewɨɨp jém tuŋjo̱m? ");
INSERT INTO poiNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Jém maestro iñɨ́máy Jesús: —Jém iyaachaŋja̱mnewɨɨp, jeam it́ɨ̱wɨ. Jesɨc Jesús iñɨ́máy jém pɨ̱xiñ: —Sɨɨp nɨcsɨm. Wa̱tɨ je̱mpɨc mex mich. ");
INSERT INTO poiNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesɨc mojgacum nɨqui Jesús. Núc tuŋgac attebet. Jemum ipát tu̱m yo̱mo iñɨ̱yi Marta. Jém yo̱mo iñɨ́máy Jesús: —Mi̱ñɨ miwiiqui antɨccɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Jém Marta ijáyuc iñɨ̱yi Malía. Jém jáyucpɨc co̱ñ jém tánO̱mi ipuycɨɨm iga imatoŋpa jém iŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Pero jém Marta tsa̱m jáyaŋ mandajo iniit́. Icunúc Jesús, iñɨ́máy: —¿MánO̱mi, que d́a iŋwadáypa caso iga d́a ayo̱xpátpa jém anjáyuc? Atsacne aŋcut́um con jáyaŋ mandajo. Cutsa̱tɨ jém anjáyuc iga ayo̱xpád́iñ. ");
INSERT INTO poiNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jesɨc Jesús iñɨ́máy jém yo̱mo: —Marta, Marta, mich tsa̱m iŋwadáypa caso. Agui iniit́ sɨɨp jém co̱bacpi̱ji. ");
INSERT INTO poiNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Wɨ̱ iga taŋwadáypa caso de tu̱m cosa no más. Jém Malía ipátne jém wɨbɨc cosa iga imatoŋpa ɨch anaŋma̱t́i. D́a i̱ wɨa̱p iccáyáy. ");
INSERT INTO poiNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jesɨc tu̱m ja̱ma it́ id́ɨc Jesús con icuyujcɨɨwiñ, iŋwejpátpa Dios. Cuando yaj iwat oración jém Jesús, tu̱m jém icuyujcɨɨwiñ iñɨ́máy: —MánO̱mi, aŋquejayt́aamɨ iga wɨa̱iñ anaŋwejpátta Dios juuts jém Xiwan, jém acchíŋoypaap, iŋquejáy jém icuyujcɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesɨc Jesús iñɨ́máy jém icuyujcɨɨwiñ: —Cuando iniŋwejpáttámpa Dios, nɨmtaamɨ yɨɨmpɨc: ManJa̱tuŋ Dios, miit́wɨɨp sɨŋyucmɨ. Agui cuáyñe mich iñɨ̱yi. Wɨ̱ iga míñiñ jém ja̱ma iga iniŋjacpa yɨ́p naxyucmɨ. Wa̱tɨ yɨ́p naxyucmɨ juuts mich iŋwɨ̱aŋja̱m, juutst́im iŋwatpa sɨŋyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Achiit́aamɨ cada ja̱ma t́it́am aŋcúttámpa. ");
INSERT INTO poiNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Awadayt́aamɨ perdón jém antáŋca juutst́im aɨcht́am aŋwadayñeta perdón jém amalwadayñewɨɨp. Awattaamɨ cuenta iga odoy i̱ wɨa̱iñ acutɨ́tsta iga acmalwattámpa. ");
INSERT INTO poiNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jesɨc Jesús iñɨ́máyt́im icuyujcɨɨwiñ: —Siiga tu̱m de mimicht́ampɨc iniit́ tu̱m amigo, nɨcpa íñám tsuucɨɨm, iññɨ́máypa: ");
INSERT INTO poiNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","“Amigo, acca̱cɨ tucute̱n caxt́ána̱ñi. Yaguiñ núc antɨccɨɨm tu̱m ánamigo. D́a t́i anait́ iga anacwícpa.” ");
INSERT INTO poiNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Pero jém it́wɨɨp tɨcjo̱m micutsoŋpa, nɨmpa: “Odoy awadaayɨ molestia. Sɨɨp aŋpajneum antɨc. Awagamoŋtámpa con amma̱nɨctam. D́a wɨa̱p antsucum iga manchiiba algun t́i.” ");
INSERT INTO poiNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Mannɨ́máypa, jesɨc teguet tsucumpa jém íñamigo iga michiiba jém caxt́ána̱ñi. Pero d́a porque tsa̱m mit́oypa. Michiiba porque d́a iñchacpa iga iŋwadáypa molestia. Duro iŋwágáypa hasta que michiiba it́u̱mpɨy juuts iñxunpa. ");
INSERT INTO poiNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Jeeyucmɨm annɨ́mayt́ámpa iga wágayt́aamɨ Dios, jesɨc michiiba t́it́am mit́ogóyáy. Métstaamɨ jém wɨ̱tampɨc cosa, impáttámpa. Tɨcstaamɨ jém puerta, míŋáyayt́a̱p. ");
INSERT INTO poiNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Porque jém iwágaypáppɨc, chiit́a̱p. Jém imétspáppɨc, ipátpa. Jém it́ɨcspaap jém puerta, áŋáyayt́a̱p. ");
INSERT INTO poiNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Mimicht́am, siiga imma̱nɨc miwágáypa tu̱m caxt́ána̱ñi, ¿que iñchiiba tu̱m tsa? Siiga miwágáypa tu̱m tɨɨpɨ, ¿que iñchiiba tu̱m tsa̱ñ? ");
INSERT INTO poiNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Siiga miwágáypa tu̱m cánpu, ¿que iñchiiba tu̱m cacwi? ");
INSERT INTO poiNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Micht́am, tsa̱m mimalo, pero iñjo̱doŋ jutsa̱p iñchi imma̱nɨctam tu̱m wɨbɨc xaja. Pero tanJa̱tuŋ Dios, jém it́wɨɨp sɨŋyucmɨ, d́a malo; ichiiba jém Dios iA̱nama jém iwágaypáppɨc. ");
INSERT INTO poiNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Tu̱m ja̱ma Jesús it́op tu̱m mal espíritu. Jém mal espíritu iu̱mawatne id́ɨc tu̱m pɨ̱xiñ. D́a wɨa̱p ijɨy. Pero cuando topta̱, mojum jɨ̱yi jém u̱ma. It́u̱mpɨy jém pɨxiñt́am, jém it́yajwɨɨp je̱m, agui ipooñaŋja̱myaj. ");
INSERT INTO poiNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pero algunos jém it́yajwɨɨp nɨmyaj: —Yɨ́p pɨ̱xiñ wɨa̱p it́op jém mal espíritu porque iniid́áy jém Beelzebú ipɨ̱mi, jém malopɨc espíritu iŋjagooyi. ");
INSERT INTO poiNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Tuŋgac jém it́yajwɨɨp icutɨtsyajpa jém Jesús. Nɨ́mayt́a̱p: —Aŋquejaayɨ tu̱m milagro. Aŋquejaayɨ tu̱m seña iga quejiñ iga Dios micutsatne. ");
INSERT INTO poiNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pero Jesús ijo̱doŋ t́i sɨ́p ijɨ̱syaj. Iñɨ́máy: —Siiga tu̱m gobierno nawécyajta̱p, áŋa̱yajpa entre jeeyaj, jesɨc nayajyajta̱p. Siiga nawécyajta̱p jém it́yajwɨɨp tu̱m tɨccɨɨm, áŋa̱yajpa, jesɨc nayajyajta̱pt́im. ");
INSERT INTO poiNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Je̱mpɨct́im iñascaaba jém Woccɨɨwiñ siiga nawécyajta̱p entre jeeyaj, áŋa̱yajpa, jesɨc d́a jáypa cuyajpa. Mannɨ́máypa je̱mpɨc porque miñɨmtámpa iga wɨa̱p antop jém mal espíritu porque ɨch anait́ jém Beelzebú ipɨ̱mi. ");
INSERT INTO poiNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Siiga ɨch antoppa jém mal espíritu con jém Beelzebú ipɨ̱mi, ¿jesɨc mich iŋcuyujcɨɨwiñ, i̱ ichiiba jém ipɨ̱mi iga it́oppat́im jém mal espíritu? Jeeyaj iyaac miŋquejáypa iga mijɨ̱xit́ogoyñeta. ");
INSERT INTO poiNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Siiga antoppa jém mal espíritu con jém Dios ipɨ̱mi, jesɨc tsa̱m wɨ̱quejpa iga núcneum jém tiempo iga Dios iŋjacpa yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Siiga tu̱m pɨ̱xiñ tsa̱m pɨ̱mi iwatpa cuenta jém it́ɨc con jém espada y jém lejon, d́a i̱ wɨa̱p iñúmáy jém iniit́wɨɨp it́ɨccɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pero siiga miñpa tuŋgac pɨ̱xiñ más pɨ̱mi iga áŋa̱yajpa con jém tɨc io̱mi y icoñwɨ́ypa, jesɨc iccáyáypa jém iespada y jém ilejon, jém ijɨ̱spáppɨc id́ɨc jém tɨc io̱mi iga nacupujta̱p. Wɨa̱p it́obáyáy it́u̱mpɨy jém iniit́wɨɨp. Nɨcpa iwéc con jém it́ɨ̱wɨtam. ");
INSERT INTO poiNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Jesɨc nɨmt́im Jesús: —Jém d́apɨc awaganayo̱xa̱ aɨch, iwatpa en contra. Jém d́apɨc ayo̱xpátpa iga anaŋtuuma̱watyajpa jém pɨxiñt́am, je más aquepquebáyáypa. ");
INSERT INTO poiNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Put tu̱m mal espíritu tu̱m pɨ̱xiñ ia̱namaŋjo̱m. Sɨɨba jém tɨtsɨnaxyucmɨ. Imétspa ju̱t́ jejpa. Pero d́a ipát. Nɨmpa iga: “E̱ybɨc ase̱tpa jém tɨccɨɨm ju̱t́ aput.” ");
INSERT INTO poiNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Jesɨc mu ixe̱tum, ipát jém pɨ̱xiñ juuts tu̱m tɨc petneum y wɨ̱tsacneum. ");
INSERT INTO poiNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Jesɨc inimiñ siete espíritu más pɨ̱mi malo. Nɨc i̱t́iyaj jém pɨ̱xiñ ia̱namaŋjo̱m. Sɨɨp más pɨ̱mi malo que wiñt́i. ");
INSERT INTO poiNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Cuando najɨ́yóypa Jesús, pɨ̱mi jɨypa tu̱m yo̱mo jém pɨxiñt́am aŋcucmɨ. Jém yo̱mo iñɨ́máy jém Jesús: —Agui wɨ̱it́pa jém yo̱mo jém micnaywɨɨp, jém mictsútswɨɨp iga mictsam. ");
INSERT INTO poiNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Pero Jesús iñɨ́máy jém yo̱mo: —Más wɨ̱it́pa jém imatoŋpáppɨc jém Dios iŋmadayooyi y iwatpa juuts iñɨ́máypa. ");
INSERT INTO poiNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Jesɨc jém pɨxiñt́am tsa̱m icutuuma̱cayaj jém Jesús. Moj jɨ̱yi Jesús. Nɨmpa: —Tsa̱m malo jém it́yajwɨɨp sɨɨp porque awágáypa tu̱m milagro iga anaŋquejáyiñ iga Dios acutsatne. Pero Dios iwatpa no más tu̱m señal juuts jém iwadayñewɨɨp jém profeta Jonás. ");
INSERT INTO poiNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Dios iwadáy jém Jonás tu̱m señal iga jém Nínivepɨc pɨxiñt́am wɨa̱iñ iixyaj. Jesa̱pt́im aɨch jém aMiññewɨɨp Sɨŋyucmɨ atsɨ́y juuts tu̱m señal para jém it́yajwɨɨp sɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Jesɨc cuando núcpa jém ja̱ma iga Dios icɨɨpiŋpa it́u̱mpɨy jém pɨxiñt́am, miñpa jém aŋtsapsa̱umɨpɨc reina. Tsucumpa iga iquejajwadáypa jém pɨxiñt́am jém it́yajwɨɨp sɨɨp. Porque juumɨ miñ jém yo̱mo iga imatoŋpa jém aŋjagooyi jém Salomón ijɨ̱xi. Pero yɨɨm it́ con mimicht́am tu̱m más mɨjpɨc aŋjagooyi que jém Salomón, pero micht́am d́a iŋcupɨctámpa. ");
INSERT INTO poiNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Cuando núcpa jém ja̱ma iga cɨɨpíŋóypa Dios, tsucumyajpa jém Nínivepɨc pɨxiñt́am. Iquejajwadayyajpa jém it́yajwɨɨp sɨɨp. Porque jeeyaj ichacyaj iga imalwatpa cuando najɨ́yóypa jém Jonás. Sɨɨp yɨɨm it́ con mimicht́am tu̱m profeta más wɨa̱paap que jém Jonás, pero micht́am d́a iñchactámpa jém malajɨ̱xi. ");
INSERT INTO poiNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’D́a i̱ iñooba tu̱m nooquejcuy iga ichacpa ju̱t́ d́a i̱ iixpa ni tu̱m cajoncucɨɨm. Pero accámta̱p yucmɨ iga ixixóyiñ jém tɨgɨypáppɨc. ");
INSERT INTO poiNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Jém tánixcuy juuts tu̱m wɨbɨc juctɨ aŋtso̱ca. Siiga wɨ̱ jém tánixcuy, jesɨc it́u̱mpɨy jém tammɨjta̱y it́ jém wɨbɨc juctɨ aŋtso̱cajo̱m. Pero siiga d́a wɨ̱ jém tánixcuy, it́u̱mpɨy jém tammɨjta̱y cupiicha̱ne. ");
INSERT INTO poiNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Wa̱tɨ cuenta jém juctɨ jém iniit́wɨɨp iga odoy tsɨɨyiñ juuts piichɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Siiga it́u̱mpɨy jém immɨjta̱y it́ jém wɨbɨc juctɨ aŋtso̱cajo̱m, d́a i̱ ni uxaŋ piichɨ, tsa̱m wɨ̱quejpa cuando tu̱m nooquejcuy yɨcquejóypa con jém icho̱ca. ");
INSERT INTO poiNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ocmɨ cuando yaj aŋma̱t́i Jesús, tu̱m fariseopɨc pɨ̱xiñ iŋwejáy iga nɨcpa wiiqui it́ɨccɨɨm. Jesɨc tɨgɨy Jesús, co̱ñ jém mesacɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Pero agui ámaŋjac jém fariseo porque iix iga Jesús d́a iche icɨ antes que wícpa juuts nɨmpa jém fariseoyaj icostumbre. ");
INSERT INTO poiNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Pero tánO̱mi Jesús iñɨ́máy jém fariseo: —Mimicht́am mifariseopɨc, iŋcujicháypa jém imvaso y jém iñchi̱ma iyucwiñ, pero íña̱namaŋjo̱m tsa̱m it́ nuumi con jáyaŋ malopɨc jɨ̱xi. ");
INSERT INTO poiNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mimicht́am, tsa̱m micuɨ̱xit́am. Siiga iñjo̱doŋ iga Dios miwadáy jém iŋcɨ, ¿t́iiga d́a iñjɨ̱spa iga Dios miwadáyt́im jém íña̱nama? Dios iwɨ̱aŋja̱m iga cuáyñeiñ iŋcɨ, pero más iwɨ̱aŋja̱m iga cuáyñeiñ íña̱nama. ");
INSERT INTO poiNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Siiga iñchiiba tu̱m limosna jém yaacha̱yajpaap porque wɨbɨc jɨ̱xi iniit́ íña̱namaŋjo̱m, jesɨc quejpa iga micuáyñeum iŋcutero. ");
INSERT INTO poiNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’Agui miuuguyt́im mifariseopɨc mipɨxiñt́am. Iñchiit́ámpa Dios jém iñdiezmo de jém yierba buena, de jém ruda y it́u̱mpɨy jém iññipñibooyi. Pero d́a iñjɨ̱stámpa iga iñyo̱xpáttámpa jém iñt́ɨ̱wɨtam jém yaacha̱yajpáppɨc. D́at́im iñjɨ̱stámpa iga iñt́oyt́ámpa Dios. Wɨ̱ iga iñyo̱xpátpa jém iñt́ɨ̱wɨtam y iñt́oypa Dios y odoy iñchaguiñ iga iñchiiba Dios jém iñdiezmo. ");
INSERT INTO poiNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’Agui miuuguyt́im, mifariseopɨc mipɨxiñt́am, porque iŋcusúnɨ́ypa jém más wɨbɨc co̱ñcuy jém sinagoga. Tsa̱m iŋwɨ̱aŋja̱mt́im iga it́u̱mpɨy jém pɨxiñt́am midioschiiyajpa calle. ");
INSERT INTO poiNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’Agui miuuguyt́im miescribaspɨc mimaestrotam y mifariseopɨc mipɨxiñt́am. Iñyaac minimɨgóyayt́a̱p. Inicwatpa táŋca jém tantɨ̱wɨtam porque ijɨ̱syajpa iga wɨbɨc mipɨxiñt́am, pero tsa̱m malo íña̱nama. Mimicht́am mijex juuts tu̱m tsúts ijos. D́a iixyajpa jém pɨxiñt́am, wit́yajpa jém tsútscu̱miyucmɨ, pero d́a ijo̱doŋyaj. ");
INSERT INTO poiNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jesɨc tu̱m maestro de jém Israelpɨc aŋquímayooyi iñɨ́máy Jesús: —Maestro, cuando miñɨmpa je̱mpɨc, jesɨc mich anaŋnɨ́maycúmpa aɨcht́am. ");
INSERT INTO poiNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Pero Jesús iñɨ́máy jém pɨ̱xiñ: —Agui miuuguyt́im mimicht́am. Tsa̱m iniŋcodɨ́ypa jém iniŋquímayooyi, je puro iñjɨ̱xquiimi. Sɨɨp inictsɨɨma̱támpa jém tantɨ̱wɨtam con jém iniŋquímayooyi. D́a icɨyyajpa. Pero mimicht́am d́a iŋcuyágɨ́yáypa jém ichɨ̱mi con tu̱m iŋwaycɨ iga iñyo̱xpátpa. ");
INSERT INTO poiNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’Agui miuuguyt́im mimicht́am, iŋwattámpa jém mɨjpɨc monumento ju̱t́ cumyajta̱ jém wiñɨcpɨc profeta. Pero jém wiñɨcpɨc iñt́úmmɨtam iccaayaj jeet́im profeta. ");
INSERT INTO poiNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Jesɨc quejpa iga iŋwɨ̱aŋja̱m t́i iwatyaj jém wiñɨcpɨc iñt́úmmɨtam. Jeeyaj iccaayaj jém wiñɨcpɨc profeta, mimicht́am iŋwattámpa jém monumento ju̱t́ cumyajta̱. Quejpa iga iniit́ de acuerdo con jém wiñɨcpɨc iñt́úmmɨtam. ");
INSERT INTO poiNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Jeeyucmɨ nɨmpa Dios, jém tsa̱mpɨc jɨ̱xiɨ́y: “Aŋcutsat jém profetayaj y jém apóstolyaj, pero jém malopɨc pɨxiñt́am iccaayaj algunos, tuŋgac icpóyɨyyajpa.” ");
INSERT INTO poiNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Pero mimicht́am, miit́wɨɨp sɨɨp, Dios michiit́ámpa tsa̱m mɨjpɨc castigo. Michégayt́ámpa iñɨɨpiñ iga accaayajta̱ it́u̱mpɨy jém Dios iprofetayaj dende watneta̱ yɨ́p mundo. ");
INSERT INTO poiNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Mimicht́am, miit́t́aŋwɨɨp, michégáypa iñɨɨpiñ it́u̱mpɨy jém aŋmat́cɨɨwiñ dende jém mojwɨɨp iccaata̱, jém Abel, hasta jém Zacarías, jém accaaneta̱wɨɨp jém altar iŋcucmɨ con jém santuario jém mɨjpɨc ma̱stɨcjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’Agui miuuguyt́im miccuyujoypaap de jém Israelpɨc aŋquímayooyi. Iniŋnéctámpa jém Dios iŋma̱t́i iga jém Israelpɨc pɨxiñt́am odoy wɨa̱iñ icutɨɨyɨyyaj. Mimicht́ampɨc d́a iŋcutɨɨyɨyt́ámpa jém Dios iŋma̱t́i, d́a iñjɨ́gayt́ámpa jém Israelpɨc pɨxiñt́am iga wɨa̱iñ icutɨɨyɨyyaj. ");
INSERT INTO poiNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jesɨc yaj aŋma̱t́i Jesús. Put jém tɨcjo̱m. Jém escribaspɨc maestroyaj con jém fariseoyaj tsa̱m ijóyixyajpa Jesús. Jesɨc icwácyajpa Jesús jáyaŋ cosa iga icutɨtsyajpa. ");
INSERT INTO poiNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Tsa̱m icunu̱myajpa. Iŋma̱t́t́o̱pyajpa jém Jesús iga wɨa̱iñ iquejajwadayyaj. ");
INSERT INTO poiNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ocmɨ aŋtuuma̱yajpa tsa̱m jáyaŋ pɨxiñt́am hasta napɨɨtsyajta̱p. Jesɨc moj iŋmadáy Jesús jém icuyujcɨɨwiñ. Nɨ́mayyajta̱p: —Cuidado. Odoy cupɨ̱cɨ jém fariseopɨc iŋquímayooyi. Porque mimɨgóyáypa hasta namɨgóyayt́a̱p iyaac. Jáyaŋa̱p jém malopɨc aŋquímayooyi jex juuts jém levadura icpɨ̱pa jém jaapi. ");
INSERT INTO poiNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Porque Dios iŋquejpa it́u̱mpɨy jém jɨ̱xi jém iŋyamneyajwɨɨp. Jo̱dóŋa̱ta̱p it́u̱mpɨy jém jɨ̱xi jém aŋnécneta̱wɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","It́u̱mpɨy jém aŋma̱t́i jém iniŋmatnewɨɨp piichcɨɨm, matoŋta̱p juctɨaŋtso̱cajo̱m. Jém aŋma̱t́i jém miyamnɨmnewɨɨp tɨcjo̱m, ju̱t́ wɨ̱aŋpajne, aŋmatta̱p tɨgaŋco̱bac jém yucmɨpɨc piso. ");
INSERT INTO poiNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Mánamigotam, mannɨ́máypa iga odoy cɨ̱ŋtaamɨ jém pɨxiñt́am jém miccaatampáppɨc. Porque ocmɨ d́a t́i wɨa̱p miwadáy. ");
INSERT INTO poiNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Pero mannɨ́máypa i̱ wɨa̱p iŋcɨ̱ŋ, cɨ̱ŋtaamɨ Dios porque despues de que micaaneum, wɨa̱p micnɨc jém juctjo̱m ju̱t́ d́a nunca píchpa, ju̱t́ impɨctsoŋpa iŋcastigo. Nu̱ma mannɨ́máypa, cɨ̱ŋtaamɨ Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Máyt́a̱p cinco xuxut́ jon por wɨste̱n tumiñ. Pero Dios ijɨ̱spa jém xut́u jon iga iwatpa cuenta. ");
INSERT INTO poiNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Dios ijo̱doŋ jute̱n iŋway iniit́ iŋco̱bacyucmɨ. Jeeyucmɨ mannɨ́mayt́ámpa: Odoy cɨ̱ŋtaamɨ. Porque Dios tsa̱m miwɨ̱wattámpa cuenta. Mit́oyt́ámpa más que jém xuxut́ jonyaj. ");
INSERT INTO poiNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Nɨmpat́im Jesús: —Siiga iniŋmadáypa jém iñt́ɨ̱wɨtam iga mich iŋcupɨc iga Dios acutsat yɨ́p naxyucmɨ, jesɨc cuando miñúcpa sɨŋyucmɨ, mampɨctsoŋpat́im jém sɨŋyucmɨpɨc pɨxiñt́am iwiñjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pero siiga tu̱m pɨ̱xiñ iŋnécpa iga acupɨcne, jesɨc ɨch anaŋnécpat́im jém sɨŋyucmɨpɨc pɨxiñt́am iwiñjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Siiga tu̱m pɨ̱xiñ amalnɨ́máypa aɨch, jém aMiññewɨɨp Sɨŋyucmɨ, wadayt́a̱p perdón. Pero siiga tu̱m pɨ̱xiñ imalnɨ́máypa jém Dios iA̱nama, d́a nunca i̱ iwadáypa perdón. ");
INSERT INTO poiNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Cuando mininɨctamta̱p iga miquejajwadayt́amta̱p jém juezcɨɨm, jém aŋjagooyicɨɨm, o jém sinagoga, jesɨc odoy jɨ̱staamɨ ju̱t́pɨc iŋcutsoŋtámpa o ju̱t́pɨc minicupujtamta̱p. ");
INSERT INTO poiNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Porque cuando núcpa jém rato iga iŋcutsoŋpa, jesɨc Dios iA̱nama michiiba jɨ̱xi ju̱t́pɨc iŋcutsoŋpa. ");
INSERT INTO poiNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Tu̱m pɨ̱xiñ iñɨ́máy Jesús: —Maestro, nɨ́maayɨ jém ána̱chi iga awégáyiñ jém anja̱tuŋ imɨɨchi jém atsagayñeta̱wɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Pero Jesús iñɨ́máy jém pɨ̱xiñ: —Mipɨ̱xiñ, ¿i̱ accámne como ajuez o awégoypaap para mimicht́am? ");
INSERT INTO poiNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Nɨmt́im Jesús: —Wadaayɨ caso mich iñyaac iga odoy iŋcusúnɨ́yiñ jáyaŋ cosa. D́a tanait́pa tamvida iga jáyaŋ cosa tanait́pa. ");
INSERT INTO poiNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Jesɨc Jesús iŋmadáypa tu̱m xut́u cuento iga iŋquejáypa jém pɨxiñt́am. Iñɨ́máy: —It́ id́ɨc tu̱m ricopɨc pɨ̱xiñ. Agui jáyaŋ cosecha chióy jém iñas. ");
INSERT INTO poiNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Jesɨc mojpa ijɨ̱s jém rico. Nɨmpa: “¿T́i wɨa̱p aŋwat? D́a anai̱ ju̱t́ anaccáypa jém aŋcosecha.” ");
INSERT INTO poiNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Jesɨc ijɨ̱s t́i wɨa̱p iwat. Nɨmpa: “Anjo̱doŋ t́i aŋwatpa sɨɨp. Ammɨswatpa jém antɨc ju̱t́ anaccáypa jém aŋcosecha. Aŋwatpa tuŋgac más mɨjpɨc. Jemum wɨa̱p anaccáy it́u̱mpɨy jém aŋcosecha con it́u̱mpɨy jém anait́wɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Jesɨc anjɨ̱spa ána̱namaŋjo̱m: Sɨɨp anait́ wíccuy y t́it́am ansunpa para jáyaŋ a̱mt́ɨy. Sɨɨp ajejpa, awícpa, aucpa, amaymáya̱p.” ");
INSERT INTO poiNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pero Dios iñɨ́máy jém rico: “Agui micuɨ̱xi, ¿que d́a iñjo̱doŋ iga yɨ́bam tsuu micaaba? ¿Jesɨc jém iniccáyñewɨɨp, i̱ iñchagáypa?” ");
INSERT INTO poiNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Jesɨc yaj iŋmat jém xut́u cuento, Jesús iñɨ́máy jém icuyujcɨɨwiñ: —Je̱mpɨgam iñascaaba jém pɨ̱xiñ jém iŋtuuma̱watpáppɨc it́umiñ para je iyaac. Tsa̱m pɨ̱mi yaacha̱p cuando caaneum porque d́a wɨa̱p ininɨc jém it́umiñ, d́at́im núcpa ju̱t́ it́ Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ocmɨ Jesús iñɨ́máy icuyujcɨɨwiñ: —Mannɨ́mayt́ámpa iga odoy wadaayɨ caso iga miwɨ̱it́t́ámiñ. Odoy wadaayɨ caso iga iniit́t́ámiñ jáyaŋ iŋwíccuy o impuctu̱cu. ");
INSERT INTO poiNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Jém imvida más vale que jém iŋwíccuy. Jém immɨjta̱y vale más que jém impuctu̱cu. ");
INSERT INTO poiNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Jɨ̱staamɨ jém jonyaj. D́a ñippa, d́a ichicpa, d́a inii̱ ju̱t́ iccáypa jém cosecha, pero Dios icwícpat́im. Nu̱ma, mimicht́am más mivale que jém jonyaj. ");
INSERT INTO poiNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Siiga pɨ̱mi iñjɨ̱spa, d́a wɨa̱p iñyón ni tu̱m quípsɨ más. ");
INSERT INTO poiNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Siiga d́a wɨa̱p iŋwat tu̱m cosa d́apɨc jutsaŋ iga pɨ̱mi iñjɨ̱spa, ¿t́iiga iŋwadáypa caso iga ju̱t́ impɨcpa jém iŋwíccuy con jém impuctu̱cu? ");
INSERT INTO poiNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Jɨ̱staamɨ ju̱t́pɨc mɨja̱p jém wɨbɨc mo̱ya jém lirio. D́a yo̱xa̱p ni d́a pit́pa. Pero mannɨ́máypa ni jém rey Salomón cuando tsa̱m wɨ̱cuyajne, d́a ictsɨ́ypa jém wɨbɨc mo̱ya. ");
INSERT INTO poiNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Dios iwɨ̱accuyajpa jém mo̱ya, pero d́a jáypa xichpa, nooquetta̱p. Jeeyucmɨ mannɨ́máypa: Cupɨ̱cɨ iga Dios wɨa̱p miwatta cuenta. Michiiba t́it́am mit́ogóyáy. ");
INSERT INTO poiNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Odoy wadaayɨ caso ju̱t́ impɨcpa t́it́am iŋcútpa y t́it́am íñucpa. Odoy jɨ̱sɨ t́it́am mit́ogóyáy. ");
INSERT INTO poiNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","It́u̱mpɨy jém pɨxiñt́am icuwɨ̱t́i yɨ́p naxyucmɨ imétsyajpa t́it́am icútyajpa. Pero mimicht́am iñJa̱tuŋ ijo̱doŋ t́it́am mit́ogóyáy. ");
INSERT INTO poiNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Meetsɨ wiñt́i ju̱t́ iŋjacpa Dios, jesɨc ocmɨ Dios michiiba t́it́am mit́ogóyáy. ");
INSERT INTO poiNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Odoy cɨ̱ŋtaamɨ. Mimicht́am mamborregotam. D́a miwa̱t́it́am, pero tanJa̱tuŋ Dios iwɨ̱aŋja̱m iga mimɨɨcha̱p iga miŋjacpa. ");
INSERT INTO poiNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Mayt́aamɨ t́it́am iniit́t́a iga wɨa̱iñ iñchiit́a jém tumiñ jém yaacha̱yajpáppɨc. Wa̱tɨ jém Dios iyo̱xacuy con jém iñt́umiñ. Je̱mpam iniccáypa jém iñt́umiñ sɨŋyucmɨ ju̱t́ d́a nunca yajpa. Jém númpaap d́a wɨa̱p it́ɨgɨy. Jém we̱chi d́a wɨa̱p ictogoy. ");
INSERT INTO poiNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Porque ju̱t́ it́ jém iñriqueza, jemum it́t́im jém íña̱nama. ");
INSERT INTO poiNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’It́t́aamɨ listo mimicht́am juuts tu̱m pɨ̱xiñ iyo̱xacɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Iŋjócyajpa io̱mi. Oy sɨ́ŋa̱ji ju̱t́ aŋcoomɨ́yoyñɨ̱mpa. Se̱tpa tsuucɨɨm. Jesɨc d́a moŋpa jém iyo̱xacɨɨwiñ. Jicscɨy íŋáypa jém puerta cuando it́ɨcspa jém io̱mi. ");
INSERT INTO poiNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Agui maymay jém yo̱xacɨɨwiñ siiga d́a moŋpa cuando se̱tpa jém io̱mi. Nu̱ma mannɨ́máypa iga jém io̱mi tsa̱m it́oypa jém iyo̱xacɨɨwiñ. Mojpa iwat wíccuy jém io̱mi, icwícpa jém iyo̱xacɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Siiga núcpa cugaptsu o hasta cuque̱jacɨɨm y d́a moŋpa jém iyo̱xacɨɨwiñ, jesɨc agui maymayyaj jeeyaj porque jém io̱mi pɨ̱mi iwɨ̱ixpa. ");
INSERT INTO poiNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Jesɨc nɨmt́im Jesús: —Cutɨɨyɨyt́aamɨ, siiga tu̱m pɨ̱xiñ ijo̱doŋ juchɨs hora núcpa jém númpaap, jesɨc d́a moŋpa jém pɨ̱xiñ. D́a ichacpa jém it́ɨc iga cunúmayt́a̱iñ. Jesa̱pt́im mimicht́am. ");
INSERT INTO poiNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","It́t́aamɨ listo cuando ɨch, jém aMiññewɨɨp Sɨŋyucmɨ, amiñgacpa yɨ́p naxyucmɨ. Porque cuando nɨmyajpa iga d́a amiñpa, jesɨgam amiñpa. ");
INSERT INTO poiNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Jesɨc Peto icwác Jesús. Iñɨ́máy: —MánO̱mi, ¿t́iiga iniŋmat yɨ́p xut́u cuento, para aɨcht́am o para it́u̱mpɨy jém pɨxiñt́am? ");
INSERT INTO poiNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jesɨc tánO̱mi iñɨ́máy: —Sɨɨp manaŋquejáypa i̱apaap jém wɨbɨc mayordomo jém icutɨɨyɨypáppɨc. It́ id́ɨc tu̱m pɨ̱xiñ iccám iga mayordomo tu̱m jém iesclavo iga iŋjacpa it́u̱mpɨy jém imozoyaj. Iwécpat́im jém wíccuy. ");
INSERT INTO poiNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Agui maymay jém mayordomo siiga iwatpa juuts ipɨɨmɨ́y jém io̱mi cuando miñgacpa. ");
INSERT INTO poiNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nu̱ma mannɨ́mayt́ámpa iga jém io̱mi iccámpa jém pɨ̱xiñ juuts tu̱m aŋjagooyi iga iŋjacpa jém iñas y it́u̱mpɨy jém iniit́wɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pero siiga jém mayordomo ijɨ̱spa iga d́a jobit́ se̱tpa jém io̱mi, jesɨc mojpa imalwadáy jém imozoyaj jém pɨxiñt́am y jém yo̱mtam. Moj wiiqui jém mayordomo. Moj u̱qui hasta u̱quia̱p. ");
INSERT INTO poiNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ocmɨ núc jém ja̱ma iga se̱t jém io̱mi. Pero jém mayordomo d́a iŋjócne. Ni d́a ijo̱doŋ juchɨs núcpa jém io̱mi. Jesɨc mu iñúc jém io̱mi, it́oppa jém pɨ̱xiñ. Ichiiba mɨjpɨc castigo con it́u̱mpɨy jém d́apɨc iŋjócneyaj. ");
INSERT INTO poiNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Siiga tu̱m esclavo iwɨ̱jo̱doŋ t́i ixunpa jém io̱mi pero d́a iwatpa ni d́a icupɨcpa, jesɨc jém io̱mi pɨ̱mi ichiiba castigo. ");
INSERT INTO poiNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pero jém pɨ̱xiñ jém d́apɨc icutɨɨyɨ́ypa ni d́a ijo̱doŋ t́i ixunpa jém io̱mi, siiga imalwatpa jém pɨ̱xiñ, jém io̱mi ichiibat́im castigo, pero d́a más pɨ̱mi. Siiga tu̱m pɨ̱xiñ iwɨ̱cutɨɨyɨ́ypa it́u̱mpɨy jém Dios iŋma̱t́i, jesɨc Dios iwɨ̱aŋja̱m iga iwad́iñ it́u̱mpɨy juuts je ixunpa. Siiga jáyaŋ jɨ̱xi michiiba Dios, jesɨc je ixunpa iga más iŋcuyo̱xa̱iñ. ");
INSERT INTO poiNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Nɨmt́im Jesús: —Ɨch anamiñ yɨ́p naxyucmɨ tu̱m wɨbɨc jɨ̱xi. Pero d́a ipɨctsoŋyajpa it́u̱mpɨy jém pɨxiñt́am. Jém malopɨc pɨxiñt́am tsa̱m ijóyixyajpa jém iwɨ̱pɨctsoŋneyajwɨɨp jém wɨbɨc jɨ̱xi. Tsa̱m nawécyajta̱p jém pɨxiñt́am. Sɨɨp agui ansunpa iga núguiñ jém tiempo cuando mojpa nawécyajta̱ji. ");
INSERT INTO poiNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ɨch amiñ iga ampɨctsoŋpa jém yaacha̱ji. Tsa̱m pɨ̱mi aŋyácne hasta que cupacpa t́i ixunpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Odoy jɨ̱sɨ iga ɨch amiñ iga anaŋjɨyjacpa jém áŋa̱yajpáppɨc. Porque ɨch aŋcuyucmɨ nawécyajta̱p jém it́yajwɨɨp yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Dende sɨɨp tsucumpa iga nawécyajta̱p. Siiga it́yaj cinco pɨ̱xiñ tu̱m tɨccɨɨm, jesɨc jém tucute̱npɨc áŋa̱yajpa con wɨste̱n. ");
INSERT INTO poiNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Jém pɨ̱xiñ áŋa̱yajpa con ija̱yma̱nɨc. Jém yo̱mo áŋa̱yajpa con iyo̱mma̱nɨc. Tuŋgac yo̱mo áŋa̱yajpa con ixa̱qui. ");
INSERT INTO poiNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesús iñɨ́máypat́im jém pɨxiñt́am: —Mu íñix iga químpa jém ucsɨ aŋnɨɨsa̱umɨ, miñɨmtámpa iga miñt́ooba tuj. Nu̱ma miñpa. ");
INSERT INTO poiNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Cuando poypa jém tsapsa̱wa, miñɨmtámpa iga miñpa pi̱ji. Nu̱ma miñpa. ");
INSERT INTO poiNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Odoy namɨgóyayt́a̱jɨ. Iñjo̱doŋ t́i miñpa cuando íñixt́ámpa jém ucsɨ y iñja̱mpa jém sa̱wa. Jesɨc cuando íñixpa jém milagro jém sɨɨppɨc aŋwatpa, ¿t́iiga d́a iŋcutɨɨyɨ́ypa iga núcum jém tiempo iga Dios iŋjacpa yɨ́p naxyucmɨ? ");
INSERT INTO poiNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’¿Mimicht́am, t́iiga d́a wɨa̱p iŋcɨɨpiŋta jup jém malopɨc y jup jém wɨbɨc? ");
INSERT INTO poiNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Jesɨc siiga mijóyixpa tu̱m pɨ̱xiñ y miŋwejáypa jém aŋjagooyicɨɨm iga miquejajwadáypa, jesɨc wɨ̱tsa̱cɨ jém asunto antes que miñúctámpa jém aŋjagooyicɨɨm. Jesɨc d́a miñúctámpa jém juezcɨɨm. Porque siiga miñúctámpa jém juezcɨɨm, jesɨc jém juez micɨɨjuŋcotpa jém policía icɨɨjo̱m. Jém policía micotpa cárcel. ");
INSERT INTO poiNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Mannɨ́máypa iga d́a miputpa hasta que yajpa iñyoj. ");
INSERT INTO poiNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Jesɨc jeet́im tiempo núcyaj algunos jém pɨxiñt́am iga iŋmadayyajpa Jesús tu̱m asunto. Nɨmyajpa: —Jém aŋjagooyi Pilato icca jute̱n jém Galileapɨc pɨ̱xiñ. Accaayajta̱ je̱mt́im ju̱t́ iwat sacrificio, mot jém iñɨɨpiñ con jém ani̱mat iñɨɨpiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesɨc Jesús iñɨ́máy: —¿T́iiga iñjɨ̱spa iga yɨ́pyaj más pɨ̱mi táŋcaɨ́y que it́u̱mpɨy jém Galileapɨc pɨxiñt́am? ");
INSERT INTO poiNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Siiga mimicht́am d́a iñchactámpa jém malajɨ̱xi, jesɨc mit́ogoyt́ámpat́im iñt́u̱mpɨyt́am. ");
INSERT INTO poiNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","D́anam más pecam caayaj dieciocho pɨ̱xiñ cuando actɨŋ jém torre jém attebet Siloé, icuchijquetyaj. Odoy jɨ̱staamɨ iga jém caaneyajwɨɨp más táŋcaɨ́y que it́u̱mpɨy jém it́yajwɨɨp Jerusalén. ");
INSERT INTO poiNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Mannɨ́máypa siiga mimicht́am d́a iñchactámpa jém malajɨ̱xi, jesɨc mit́ogoyt́ámpat́im iñt́u̱mpɨyt́am. ");
INSERT INTO poiNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jesɨc Jesús iŋmatt́im yɨ́p xut́u cuento iga iŋquejáypa jém pɨxiñt́am. Iñɨ́máy: —It́ id́ɨc tu̱m pɨ̱xiñ iniit́ tu̱m finca de uvas. Jém uvasaŋjo̱m ñipta̱t́im tu̱m tsuj. Cuando núc itiempo, nɨcpa iám siiga tɨ́ma̱neum jém tsuj, pero d́a tɨ́ma̱p. ");
INSERT INTO poiNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Jesɨc jém nas io̱mi iñɨ́máy jém iwatpáppɨc cuenta jém uvas: “Cada a̱mt́ɨy miñpa ammétsáy jém tsuj it́ɨm, pero d́a ampadáypa. Sɨɨp iniit́um tres a̱mt́ɨy, d́a queman tɨ́ma̱ jém tsuj. Sɨɨp wɨɨtɨ jém tsuj. Anxajañipne.” ");
INSERT INTO poiNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Jém iwatpáppɨc cuenta jém nas iñɨ́máy jém io̱mi: “Máno̱mi, tsa̱cɨnam yɨ́p a̱mt́ɨy. Ampuusáypa jém nas, aŋcodáypa abono. ");
INSERT INTO poiNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Siiga tɨ́ma̱p, it́ wɨ̱. Siiga d́at́im tɨ́ma̱p, jesɨc taŋwɨtquímpam.” ");
INSERT INTO poiNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Tu̱m jejcuyja̱ma accuyujóypa Jesús jém sinagoga ju̱t́ icuyujcayajpa jém Dios iŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Jemum it́ tu̱m yo̱mo. Mɨmne dieciocho a̱mt́ɨy. Tu̱m mal espíritu iccómáy it́uuñi. D́a wɨa̱p iñu̱mte̱ñ. ");
INSERT INTO poiNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Cuando iix Jesús, iŋwejáy jém yo̱mo. Iñɨ́máy: —Miyo̱mo, sɨɨp Dios micpɨspa. Mictsacpa jém caacuy. ");
INSERT INTO poiNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Jesɨc Jesús ichɨccunúc jém yo̱mo. Jeet́i rato nu̱mtsɨ́y jém it́uuñi. Jém yo̱mo moj icujíp Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pero agui jóy jém sinagoga iŋjagooyi iga acpɨsóypa jém Jesús jém jejcuyja̱ma. Iñɨ́máy jém it́yajwɨɨp je̱m: —Tanait́ seis día iga tayo̱xa̱p. Mi̱ñɨ minicpɨsta̱ji jém yo̱xacuyja̱ma. Odoy mi̱ñɨ jém jejcuyja̱ma. ");
INSERT INTO poiNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Jesɨc tánO̱mi iñɨ́máy jém aŋjagooyi: —Tsa̱m minimɨgóyayt́a̱p. Siiga nɨ́ctɨtspa jém imbuey o imburro jém jejcuyja̱ma, jesɨc tienes que iŋwijpa, nɨcpa inicnɨ́c. ");
INSERT INTO poiNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Yɨ́p yo̱mo taɨch yo̱mo, jém Abraham io̱cma̱nɨc. Jém Woccɨɨwiñ icmatsne id́ɨc yɨ́p caacuy dieciocho a̱mt́ɨy. ¿T́iiga d́a wɨa̱p tanaccutsɨgáy yɨ́p yo̱mo de jém caacuy jém jejcuyja̱ma? ");
INSERT INTO poiNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jesɨc cuando imatoŋyaj t́i nɨm Jesús, pɨ̱mi tsaa̱yaj jém d́apɨc iwɨ̱ixyajpa Jesús. Pero los de más jém pɨxiñt́am agui maymayyaj mu iixyaj t́i iwat Jesús. Iwɨ̱aŋja̱myaj jém wɨbɨc milagro. ");
INSERT INTO poiNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesɨc Jesús iñɨ́máy jém pɨxiñt́am: —Sɨɨp manaŋquejáypa jutsa̱p iŋpɨc jém Dios iŋquímayooyi. ");
INSERT INTO poiNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Jém Dios iŋquímayooyi jex juuts tu̱m mostaza ipac. Tu̱m pɨ̱xiñ iñip jém pac ica̱mjo̱m. Nay jém pac, mɨja̱p juuts tu̱m mɨjpɨc cuy hasta jém jon iwatpa ipeeñi jém mostaza iŋcɨsyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Nɨmt́im Jesús: —Sɨɨp manaŋquejáypa ju̱t́pɨc jáyaŋa̱p jém Dios iŋquímayooyi. ");
INSERT INTO poiNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Jém Dios iŋquímayooyi jex juuts levadura. Tu̱m yo̱mo inimot uxaŋ jém levadura con tucuna je̱pe de harina. Jesɨc pɨ̱pa it́u̱mpɨy jém jaapi. ");
INSERT INTO poiNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Mojgacum nɨqui jém Jesús Jerusalén. Oy najɨ́yooyi jém mɨjpɨc attebet y jém xut́upɨc tɨgaŋjoj. ");
INSERT INTO poiNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Jesɨc tu̱m pɨ̱xiñ icwác jém Jesús. Nɨmpa: —MánO̱mi, ¿que d́a wa̱t́i jém icɨacputyajpáppɨc Dios? Jesɨc Jesús iñɨ́máy: ");
INSERT INTO poiNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Wattaamɨ empeño iga mit́ɨgɨyt́ámpa jém xut́upɨc puerta. Mannɨ́mayt́ámpa iga tsa̱m jáyaŋ pɨxiñt́am tɨgɨyyajtooba, pero d́a wɨa̱yajpa. ");
INSERT INTO poiNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","’Porque cuando núcum jém hora, jesɨc jém tɨc io̱mi iŋpajpa jém it́ɨc. Cuando aŋpajneum jém it́ɨc, d́am wɨa̱p iñt́ɨgɨyt́a. Michɨ́yt́ámpa aŋsɨ̱cmɨ. Iñt́ɨcstámpa jém puerta. Miñɨmtámpa: “¡Áŋaayɨ jém puerta!” Pero miñɨ́máypa jém tɨc io̱mi: “D́a mánixpɨcpa. D́a anjo̱doŋ ju̱t́pɨc mipɨ̱xiñ.” ");
INSERT INTO poiNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Jesɨc micht́am mojpa iññɨ́mayt́a: “Tawagawícne y tawaganɨ́cne con mimich. Mich oyñe miccuyujooyi jém ánattebet.” ");
INSERT INTO poiNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Pero e̱ybɨct́im nɨmpa jém tɨc io̱mi: “Mimicht́am d́a mánixpɨcpa, d́a anjo̱doŋ ju̱t́pɨc mipɨxiñt́am. Tsa̱m mimalotam, acupóyayt́aamɨ.” ");
INSERT INTO poiNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Núcpa ja̱ma iga tsa̱m pɨ̱mi miwejtámpa y iññichpa iñt́ɨts. Pɨ̱mi miŋyáctámpa cuando íñixt́ámpa iga iwaganait́yajum Dios jém Abraham, jém Isaac, jém Jacob y it́u̱mpɨy jém wiñɨcpɨc profeta; pero mimicht́am michactamta̱ aŋsɨ̱cmɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Nɨcpa i̱t́iyaj jém aŋnɨɨsa̱umɨpɨc pɨxiñt́am, jém aŋyo̱msa̱umɨpɨc, jém aŋwɨ̱xa̱umɨpɨc y jém aŋtsapsa̱umɨpɨc pɨxiñt́am. Nɨcpa wiiquiyaj jemum ju̱t́ iŋjacpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Jém ocmɨpɨc jém pɨxiñt́am tsɨ́ypa iga wiñt́i y jém wiñt́ipɨc tsɨ́ypa iga ocmɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Jesɨc jeet́im ja̱ma núcyaj jute̱n jém fariseoyaj. Nɨ́mayt́a̱ Jesús: —Nɨcsɨm, pu̱tɨ de yɨɨm porque jém Herodes miccaatooba. ");
INSERT INTO poiNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Pero Jesús iñɨ́máy jeeyaj: —Agui jáyayaŋjɨ̱chɨch jém Herodes juuts tu̱m zorra, nɨ̱gɨ nɨ́maayɨ, iga antoppa jém mal espíritu, anacpɨspa jém mɨmnewɨɨp yɨ́p ja̱ma y jo̱ymɨ. Jesɨc wɨstɨcmɨ cuyajpa jém anyo̱xacuy. ");
INSERT INTO poiNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Seguido aŋwatpa jém anyo̱xacuy hasta cupacpa. D́a jáypa anaccupacpa. Ɨch d́a aŋcɨ̱ŋpa jém Herodes porque d́a i̱ wɨa̱p icca tu̱m profeta aŋsɨ̱cmɨ de jém Jerusalén. ");
INSERT INTO poiNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’Mimicht́am, miit́t́aŋwɨɨp Jerusalén, tsa̱m iniccaata jém Dios iprofeta. Iññácscata tsaamɨ jém icutsatneyajwɨɨp Dios. Ɨch tsa̱m maŋcɨacputtamtooba id́ɨc, pero d́a iŋwɨ̱aŋja̱mta. Wat́cɨy manaŋtuuma̱wattamtɨp juuts jém piyua̱pa iŋtuuma̱watpa jém ima̱nɨc ixajcucɨɨm. Pero mimicht́am d́a iŋwɨ̱aŋja̱mta. ");
INSERT INTO poiNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Como d́a iŋwɨ̱aŋja̱mta iga manyo̱xpáttámpa, jesɨc Dios michacum. Sɨɨp d́a michɨ́ypa juuts jém Dios mipɨxiñt́am. Mannɨ́máypa iga d́a e̱ybɨc ánixt́ámpa hasta que núcpa jém tiempo iga aŋcujíptámpa aɨch, jém acutsatnewɨɨp jém tanJa̱tuŋ Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Jesɨc tu̱m jejcuyja̱ma nɨc wiiqui Jesús tu̱m fariseopɨc aŋjagooyi it́ɨccɨɨm. Algunos jém fariseo iyamcuixyajpa jém Jesús siiga imalwatpa. ");
INSERT INTO poiNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Jesɨc tu̱m pɨ̱xiñ miñ iám jém Jesús. Imatsne jém caacuy iga cuxíŋayñe. ");
INSERT INTO poiNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesɨc Jesús icwác jém maestro de jém Israelpɨc aŋquímayooyi y jém fariseoyaj, iñɨ́máy: —¿Junɨmpa jém aŋquímayooyi? ¿Wɨa̱p tanacpɨs yɨ́p pɨ̱xiñ jém jejcuyja̱ma o d́a wɨa̱p? ");
INSERT INTO poiNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Pero jeeyaj d́a jɨyyaj. Jesɨc Jesús ichɨccunúc jém mɨmnewɨɨp. Icpɨs. Jesɨc iñɨ́máy: —Chogoyñɨcsɨm. ");
INSERT INTO poiNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Jesɨc Jesús iñɨ́máy jém fariseoyaj: —Siiga joppa tu̱m pacusjo̱m jém imburro o imbuey, jesɨc iñt́oppa jeet́i rato. D́a iŋwada̱p caso siiga jejcuyja̱ma. ");
INSERT INTO poiNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Jeeyaj d́a wɨa̱ miicutsoŋyaj jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jesɨc Jesús iix iga jém aŋwejayñeta̱wɨɨp tsa̱m imétsyajpa jém más wɨbɨc co̱ñcuy mesacɨɨm. Jesɨc Jesús iŋmat tu̱m ejemplo iga ichi jɨ̱xi. Nɨmpa: ");
INSERT INTO poiNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Siiga miŋwejayñeta̱ iga nɨguiñ mixɨ́ŋa̱ji ju̱t́ aŋcoomɨ́yoyñɨ̱mpa, odoy meetsɨ jém co̱ñcuy más wɨbɨc. Odoy co̱ñɨ ju̱t́ it́ noco jém aŋjagooyi porque wɨa̱p imiñ tu̱m pɨ̱xiñ más wɨa̱paap que mich. ");
INSERT INTO poiNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Jesɨc jém miŋwejayñewɨɨp miñɨ́máypa: “¡Tsucu̱mɨ! Chi̱ɨ yɨ́p tuŋgac pɨ̱xiñ jém iŋco̱ñcuy.” Jesɨc mich pɨ̱mi michaa̱p, nɨcpa mico̱ñi jém íŋaŋpɨgam co̱ñcuyyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Pero jesɨc cuando miŋwejayt́a̱p ju̱t́ watta̱p jém sɨŋ, nɨcsɨm mico̱ñi jém lugar más juumɨ. Jesɨc cuando miñpa jém miŋwejayñewɨɨp, miñɨ́máypa: “Amigo, yɨɨm it́ más wɨbɨc co̱ñcuy.” Jesɨc jém tuŋgac pɨxiñt́am jém co̱ñyajwɨɨp jém mesacɨɨm miwɨ̱ixyajpa. ");
INSERT INTO poiNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","D́a i̱ iwɨ̱ixpa jém nacujípta̱páppɨc. Pero jém d́apɨc nacujípta̱p, iwɨ̱nanɨgayyajpa jém it́ɨ̱wɨtam, icujípyajpa jém pɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jesɨc Jesús iñɨ́máyt́im jém pɨ̱xiñ jém iwatpáppɨc jém sɨŋ. Nɨmpa Jesús: —Cuando mixɨ́ŋa̱p, d́a wɨ̱ iga seguido iniŋwejáypa jém íñamigoyaj, jém iñt́ɨ̱wɨtam y jém ricopɨc imvecino. Porque ocmɨ jeegagam miŋwejáypa. Je̱mpɨct́im micseedáypa. ");
INSERT INTO poiNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Pero cuando mixɨ́ŋa̱p, aŋwejaayɨ jém yaacha̱yajpáppɨc, jém cɨɨt́a̱ca, jém cu̱xuj y jém cácht́i. ");
INSERT INTO poiNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Jesɨc maymáya̱jɨ porque jeeyaj d́a wɨa̱p micseedáy iga nɨcpa micwíc. Pero Dios miyojpa jém ja̱ma cuando acpɨsyajta̱p jém icupɨcneyajwɨɨp Dios jém caaneyajwɨ́ppɨc. ");
INSERT INTO poiNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Jesɨc tu̱m pɨ̱xiñ, jém iwaganait́wɨɨp jém mesacɨɨm, imatoŋ junɨmpa jém Jesús. Jesɨc jém pɨ̱xiñ iñɨ́máy: —Agui maymayyaj jém nɨcpaap sɨ́ŋa̱ji ju̱t́ iŋjacpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesɨc moj iŋmadáy Jesús yɨ́p ejemplo. Nɨmpa: —It́ id́ɨc tu̱m pɨ̱xiñ. Iwatpa tu̱m mɨjpɨc sɨŋ. Iŋwejáypa tsa̱m jáyaŋ pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Jesɨc cuando yajum iwat jém wíccuy, icutsat tu̱m icuyo̱xapaap iga nɨguiñ iŋwejáy jém iñɨ́mayñewɨɨp id́ɨc. Nɨmpa: “Nɨ̱cɨ miwiiquit́am. Sɨɨp watneum jém wíccuy.” ");
INSERT INTO poiNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Pero nɨmyajpa it́u̱mpɨy iga d́a wɨa̱p iñɨc. Tu̱m jém pɨ̱xiñ nɨmpa: “Yaguiñ anjuy tu̱m ja̱ca nas. Sɨɨp nɨcpa ánám. Nɨ́maayɨ jém íño̱mi iga d́a wɨa̱p iga nɨcpa asɨ́ŋa̱ji.” ");
INSERT INTO poiNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Jesɨc nɨmpa jém tuŋgac pɨ̱xiñ: “Yaguiñ anjuy cinco par de jém buey. Sɨɨp nɨcpa aŋcutɨts siiga yo̱xa̱p. Nɨ́maayɨ jém íño̱mi iga d́a wɨa̱p annɨc.” ");
INSERT INTO poiNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Nɨmpa jém tuŋgac pɨ̱xiñ: “Yaguiñ aŋcoomɨyñe. Jeeyucmɨ d́a wɨa̱p annɨc.” ");
INSERT INTO poiNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Cuando se̱t jém icuyo̱xapaap, iŋmadáy io̱mi junɨmpa it́u̱mpɨy jém iñɨ́mayñewɨɨp id́ɨc. Jesɨc agui jóy jém io̱mi. Iñɨ́máy jém icuyo̱xapaap: “Nɨ̱gɨ aŋwejaayɨ jém it́yajwɨɨp calle. Nɨ̱cɨ hasta jém xut́upɨc calle icuwɨ̱t́i yɨ́p attebet. Nami̱ñɨ yɨɨm jém yaacha̱yajpáppɨc, jém cu̱xujyaj, jém cácht́iyaj, jém cɨɨt́a̱ca y jém puyt́a̱ca.” ");
INSERT INTO poiNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ocmɨ jém icuyo̱xapaap iñɨ́máy jém io̱mi: “Máno̱mi, aŋwatum juuts annɨ́mayñe, pero it́ñam lugar iga tanacwícyajpa.” ");
INSERT INTO poiNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Jesɨc jém io̱mi e̱ybɨct́im iñɨ́máy jém icuyo̱xapaap: “Nɨ̱gɨ meetsɨ más pɨxiñt́am jém tuŋjo̱m y jém taañi aŋna̱ca ju̱t́ co̱ñyajpa jém yaacha̱yajpaap. Nɨ́maayɨ iga míñiñ wiiqui antɨccɨɨm. Ansunpa iga cómiñ yɨ́p antɨc. ");
INSERT INTO poiNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Mannɨ́máypa, d́a aŋwɨ̱aŋja̱m iga miñyajpa wiiqui jeeyaj jém mojnewɨɨp annɨ́mayyaj.” ");
INSERT INTO poiNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Jesɨc it́úŋɨyyajpa Jesús tsa̱m jáyaŋ pɨxiñt́am. Ámse̱t Jesús. Iñɨ́máy: ");
INSERT INTO poiNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Siiga más iñt́oypa iñja̱tuŋ, íña̱pa, iñyo̱mo, iñchɨ̱xt́am, íña̱chi, iñjáyuc o iñchɨ̱tsɨ que iñt́oypa Dios, d́a wɨa̱p iñchɨ́y juuts ɨch maŋcuyujcɨɨwiñ. Siiga más minitoyt́a̱p iñyaac que iñt́oypa Dios, d́a wɨa̱p iñchɨ́y juuts ɨch aŋcuyujcɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Siiga d́a iñyaachɨ́ypa iga miyaachwatta̱p, jesɨc d́a wɨa̱p iñchɨ́y juuts ɨch aŋcuyujcɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Siiga tu̱m pɨ̱xiñ iwattooba tu̱m torre, wiñt́i ijɨ̱spa jutsaŋ gasto ininɨcpa. Ijɨ̱spa siiga ictsɨ́ypa it́umiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Siiga ictsucum jém torre y d́a wɨa̱p iccupac, jesɨc agui ixiccayajpa jém iixyajpáppɨc. ");
INSERT INTO poiNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Nɨmyajpa: “Yɨ́p pɨ̱xiñ ictsucum iga iwatpa jém torre, pero d́a wɨa̱ miiccupac.” ");
INSERT INTO poiNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Siiga tu̱m rey áŋa̱tooba con tuŋgac rey, wiñt́i ijɨ̱xiñ siiga wɨa̱p icoñwɨ́y. Nɨmpa jém rey: “¿Que wɨa̱p aŋcoñwɨ́y con jém diez mil soldado siiga jém ánenemigo iniit́ veinte mil soldado?” ");
INSERT INTO poiNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Jesɨc jém rey ijɨ̱spa iga d́a wɨa̱p icoñwɨ́y. Jesɨc cuando it́ñam juumɨ jém ienemigo, icutsadáypa tu̱m representante iga icunucsáypa iga odoy áŋa̱yajiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Jesa̱pt́im mimicht́am, siiga d́a iñchactámpa it́u̱mpɨy jém iniit́wɨɨp, d́a wɨa̱p iñchɨ́y juuts ɨch aŋcuyujcɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Jesɨc Jesús iñɨ́máyt́im: —Wɨ̱ jém ca̱na. Pero siiga d́a paac, jesɨc d́a wɨa̱p taŋwɨ̱tsac. ");
INSERT INTO poiNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","D́a wɨ̱ ni para jém nas, ni d́at́im wɨ̱ iga taŋcodáypa ju̱t́ cu̱mneta̱ jém abono. Jesɨc tampatsáypa. Siiga mit́atsɨgɨyt́a, amatoŋtaamɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Jesɨc tu̱m ja̱ma miñyaj jáyaŋ jém pɨxiñt́am jém ichécyajpáppɨc jém impuesto y jém táŋcaɨywɨɨp. Miñ imatoŋyaj jém Jesús iŋquímayooyi. ");
INSERT INTO poiNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Jeeyucmɨ agui jóyñeyaj jém fariseoyaj y jém escribaspɨc maestroyaj. Icujɨyyajpa jém Jesús. Nɨmyajpa: —Yɨ́p Jesús ipɨctsoŋpa jém malopɨc pɨxiñt́am, iwaganawícyajpa. ");
INSERT INTO poiNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jesɨc Jesús iŋmadáy yɨ́p xut́u cuento iga iŋquejáypa jeeyaj, iñɨ́máy: ");
INSERT INTO poiNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Siiga tu̱m de mimicht́am iniit́ cien borrego y siiga togoypa tu̱m jém iborrego, ¿que d́a ichacpa jém noventa y nueve jém it́wɨɨp co̱pjo̱m y nɨcpa iméts jém togoyñewɨɨp? Ɨch anɨmpa iga seguido icuámpa hasta que ipátpa. ");
INSERT INTO poiNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Jesɨc cuando ipátum, icónneeba inimiñ iqueeweyucmɨ. Agui maymay. ");
INSERT INTO poiNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Cuando núcpa it́ɨccɨɨm, iŋtuuma̱watpa iamigoyaj con jém it́yajwɨɨp nocojo̱m. Iñɨ́máypa: “Maymáya̱taamɨ con aɨch, porque ampátum jém amborrego jém togoyñewɨɨp id́ɨc.” ");
INSERT INTO poiNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Jesa̱pt́im mannɨ́mayt́ámpa iga tsa̱m it́ maymáya̱ji sɨŋyucmɨ cuando tu̱m pɨ̱xiñ táŋcaɨywɨɨp ichacpa it́áŋca iga icupɨcpa Dios. Jém it́yajwɨɨp sɨŋyucmɨ más maymáya̱yajpa con tu̱m pɨ̱xiñ cuando ichacpa it́áŋca que con jém noventa y nueve jém wɨbɨc pɨxiñt́am jém d́apɨc táŋcaɨ́y. ");
INSERT INTO poiNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Jesanet́im siiga tu̱m yo̱mo iniit́ diez tumiñ de plata y togoypa tu̱m, ¿que d́a ictsocpa juctɨ, ipetpa it́ɨc y iwɨ̱cuámpa hasta ipátpa? ");
INSERT INTO poiNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Jesɨc cuando ipátum jém it́umiñ, iŋtuuma̱watpa jém iamigoyaj y jém ivecino. Nɨmpa jém yo̱mo: “Maymáya̱taamɨ con aɨch porque ampátum jém antumiñ jém togoyñewɨɨp id́ɨc.” ");
INSERT INTO poiNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","’Je̱mpɨct́im mannɨ́máypa iga maymáya̱yajpa jém sɨŋyucmɨpɨc pɨxiñt́am jém it́yajwɨɨp con Dios cuando tu̱m pɨ̱xiñ táŋcaɨywɨɨp icucacpa ijɨ̱xi. ");
INSERT INTO poiNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Nɨmpat́im Jesús: —It́ id́ɨc tu̱m pɨ̱xiñ. Iniit́ wɨste̱n ijayma̱nɨc. ");
INSERT INTO poiNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Jém jáyucpɨc iñɨ́máy ija̱tuŋ: “Manja̱tuŋ, awégaayɨ jém annɨ́mayñewɨɨp iga anchiiba.” Jesɨc jém ija̱tuŋ iwégáy jém it́umiñ y it́u̱mpɨy jém iniit́wɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Jesɨc d́a wa̱t́ña ja̱ma jém jáyucpɨc icumáyáy jém imɨɨchipɨc jém ichiiwɨɨp ija̱tuŋ. Ipɨc jém it́umiñ, nɨc juumɨ. Jém tuŋgac attebet imɨ̱chca jém it́umiñ con jém yo̱mtam y jém o̱jo. ");
INSERT INTO poiNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Yaj imɨ̱chca it́u̱mpɨy jém it́umiñ. Ocmɨ núc tu̱m mɨjpɨc yuu jém naxyucmɨ. Yajneum jém it́umiñ, agui yua̱p jém pɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Jesɨc nɨc iám tu̱m pɨ̱xiñ jém it́wɨɨp jém attebet. Nɨc iméts yo̱xacuy. Jém pɨ̱xiñ ichi tu̱m yo̱xacuy. Icutsat irancho iga iwadáyiñ cuenta jém iyo̱ya. ");
INSERT INTO poiNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Jesɨc jém pɨ̱xiñ tsa̱m icúttooba jém algarrobas, jém yo̱ya iwíccuy. Pero ni t́i d́a i̱ ichiiba. ");
INSERT INTO poiNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Jesɨgam jém pɨ̱xiñ moj ijɨ̱s iga tsa̱m cuɨ̱xi. Nɨmpa ijɨ̱xiaŋjo̱m: “Jém anja̱tuŋ iniit́ jáyaŋ iyo̱xacɨɨwiñ it́ɨccɨɨm. Jeeyaj tsa̱m jáyaŋ wíccuy iniit́yaj hasta cuspa wiiquiyaj. Pero ɨch yɨɨm ayuucatoobam. ");
INSERT INTO poiNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Sɨɨp ase̱tpa ju̱t́ it́ anja̱tuŋ, annɨ́máypa: Manja̱tuŋ, tsa̱m jáyaŋ táŋca aŋwat contra Dios y contra mimich. ");
INSERT INTO poiNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Como tsa̱m ammalwatum, d́a wɨ̱ iga atsɨ́ypa juuts tu̱m imma̱nɨc. Atsɨ́yt́ooba juuts tu̱m iñyo̱xacɨɨwiñ.” ");
INSERT INTO poiNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Jesɨc mojum se̱t́i ija̱tuŋcɨɨm. ’Jesɨc cuando d́anam núcne, juumɨnam miñi, ámput jém ija̱tuŋ, iix iga se̱tpam jém ima̱nɨc. Agui iyaachaŋja̱m. Póyaŋtsucum, nɨc iŋnuusáy. Iŋna̱catsúts. ");
INSERT INTO poiNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Jesɨc nɨmpa jém ima̱nɨc: “Manja̱tuŋ, tsa̱m jáyaŋ táŋca aŋwat contra Dios y contra mimich. Como tsa̱m ammalwatum d́am wɨ̱ iga atsɨ́ypa juuts tu̱m imma̱nɨc.” ");
INSERT INTO poiNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pero ija̱tuŋ iñɨ́máy tu̱m jém icuyo̱xapaap: “Impɨ̱mi nami̱ñɨ jém más wɨbɨc yoot́i, accámaayɨ yɨ́p amma̱nɨc. Accámaayɨt́im tu̱m cucu̱ma icɨɨyucmɨ y jém wɨbɨc cɨac ipuyyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Nami̱ñɨ jém ma̱ñxix jém tanacpɨ̱newɨɨp. Accaataamɨ. Jesɨc tawíctámpa, tasɨ́ŋa̱támpa. ");
INSERT INTO poiNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Anjɨ̱sne id́ɨc iga caaneum yɨ́p amma̱nɨc, pero sɨɨp vivojam. Togoyñe id́ɨc, pero sɨɨp quejum.” Jesɨc mojum sɨ́ŋa̱jiyaj. ");
INSERT INTO poiNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Pero jém ia̱chi nɨcne id́ɨc ca̱mjo̱m. Jesɨc se̱tt́im. Cuando nuuquim tomi it́ɨccɨɨm, imatoŋ iga aŋjɨypa música, etsnɨ̱mpa. ");
INSERT INTO poiNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Jesɨc iŋwejáy tu̱m jém icuyo̱xapaap. Moj icwác. Iñɨ́máy: “¿T́iiga tɨcsoyyajpa? ¿T́iiga etsyajpa?” ");
INSERT INTO poiNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Jesɨc jém icuyo̱xapaap nɨmpa: “Se̱tum jém iñjáyuc. Jém iñja̱tuŋ ipɨɨmɨ́y iga accaata̱iñ jém ma̱ñxix jém tanacpɨ̱newɨɨp porque se̱tum jém iñjáyuc. D́a t́i iñasca.” ");
INSERT INTO poiNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Jesɨc tsa̱m pɨ̱mi jóy jém a̱chpɨc. D́a tɨgɨyt́ooba jém it́ɨcjo̱m. Jesɨc put jém ija̱tuŋ. Nɨc icunucsáy iga tɨgɨ́yiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Pero jém a̱chpɨc ima̱nɨc iñɨ́máy ija̱tuŋ: “Mich iñjo̱doŋ iga tsa̱m jáyaŋ a̱mt́ɨy maŋcuyo̱xane. Siempre aŋwat juuts annɨ́máypa. Pero d́a nunca anchiiñe ni tu̱m xut́u chivo iga anasɨ́ŋa̱p jém ánamigoyaj. ");
INSERT INTO poiNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Sɨɨp núc yɨ́p imma̱nɨc jém imalmɨ̱chcanewɨɨp jém iñt́umiñ con jém yo̱mtam jém wit́wid́oypáppɨc. Mich iniccaáy jém ma̱ñxix jém tanacpɨ̱newɨɨp.” ");
INSERT INTO poiNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Jesɨc ija̱tuŋ iñɨ́máy: “Mamma̱nɨc, mich siempre miit́ con aɨch. It́u̱mpɨy jém ammɨɨchipɨc, immɨɨchit́im mich. ");
INSERT INTO poiNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pero sɨɨp agui wɨ̱ iga tasɨ́ŋa̱támpa, tamaymáya̱támpa porque caane id́ɨc jém iñjáyuc, pero sɨɨp vivojam. Togoyñe id́ɨc, pero sɨɨp quejneum.” ");
INSERT INTO poiNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesɨc jém Jesús iñɨ́máyt́im icuyujcɨɨwiñ: —It́ id́ɨc tu̱m ricopɨc pɨ̱xiñ. Iniit́ tu̱m mayordomo icuyo̱xa̱p. Iwadáypa cuenta jém rico imɨɨchi. Pero ocmɨ jém rico ijo̱dóŋa̱ iga sɨ́p imɨ̱chcaáy jém it́umiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Jesɨc jém rico iŋwejáy jém pɨ̱xiñ. Iñɨ́máy: “¿T́i yɨɨmpɨc ammatoŋpa iga sɨ́p iŋwat? Sɨɨp wɨ̱tsa̱cɨ iŋcuenta, acɨɨjuŋcodaayɨ t́it́am iŋwatne con jém anyo̱xacuy. Porque sɨɨp mantoppam. D́am je mammayordomo.” ");
INSERT INTO poiNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Jesɨc jém icuyo̱xapáppɨc jém rico moj ijɨ̱s: “¿Sɨɨp, t́i wɨa̱p aŋwat siiga accáyayt́a̱p yɨ́p yo̱xacuy? D́a wɨa̱p aŋwat tuŋgac yo̱xacuy. Atsaa̱pt́im iga aŋwácpa tumiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Sɨɨp anjo̱doŋ t́i wɨa̱p aŋwat iga anaid́iñ i̱ apɨctsoŋpa it́ɨccɨɨm cuando d́am anai̱ anyo̱xacuy. Anaŋnécpa icuenta jém ijatsneyajwɨɨp jém áno̱mi. Jesɨc jeeyaj apɨctsoŋpa it́ɨccɨɨm cuando atopta̱wum ju̱t́ ayo̱xa̱p.” ");
INSERT INTO poiNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Jesɨc jém pɨ̱xiñ moj iŋwejayyaj jém ijatsneyajwɨɨp jém io̱mi. Icwác jém mojwɨɨp mi̱ñi. Iñɨ́máy: “¿Jutsaŋ iñjatsne jém áno̱mi?” ");
INSERT INTO poiNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Nɨmpa: “Anjatsne cien barril de aceite.” Jesɨc jém icuyo̱xapaap jém rico iñɨ́máy jém ijatsnewɨɨp: “Yɨɨm it́ jém imvale. Mi̱ñɨ mico̱ñi yɨɨm, wa̱tɨ tuŋgac vale. Accaamɨ no más cincuenta barril.” ");
INSERT INTO poiNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ocmɨ icwác jém tuŋgac pɨ̱xiñ, iñɨ́máy: “¿Mich, jutsaŋ iñjatsne jém áno̱mi?” Jesɨc nɨmpa jém pɨ̱xiñ: “Ɨch anjatsne cien carga de trigo.” Jesɨc jém icuyo̱xapaap jém rico iñɨ́máy: “Yɨɨm it́ jém imvale, wa̱tɨ tuŋgac vale. Accaamɨ no más ochenta carga.” ");
INSERT INTO poiNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ocmɨ cuando imatoŋ jém rico, nɨmpa: “Tsa̱m jáyayaŋjɨ̱chɨch jém acuyo̱xapaap id́ɨc.” Jesɨc Jesús iñɨ́máy jém icuyujcɨɨwiñ: —Jém it́yajwɨɨp yɨ́p naxyucmɨ, jém d́apɨc icupɨcyajpa Dios, jeeyaj más jáyayaŋjɨ̱chɨch que jém icupɨcneyajwɨɨp Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Jeeyucmɨ mannɨ́máypa iga wɨ̱wadaayɨ jém yaacha̱yajpáppɨc con jém iñt́umiñ jém iniit́wɨɨp yɨ́p naxyucmɨ. Jesɨc iniit́ amigo iga mipɨctsoŋpa sɨŋyucmɨ cuando micaaba. ");
INSERT INTO poiNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Siiga tu̱m pɨ̱xiñ iwɨ̱watpa cuenta tu̱m cosa d́apɨc jutsaŋ, jesɨc wɨa̱pt́im iwat cuenta tu̱m cosa jáyaŋpɨc. Pero siiga tu̱m pɨ̱xiñ d́a iwɨ̱watpa cuenta tu̱m cosa d́apɨc jutsaŋ, jesɨc d́at́im wɨa̱p iwat cuenta tu̱m cosa jáyaŋpɨc. ");
INSERT INTO poiNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Siiga mimicht́am d́a wɨa̱p iŋwatta cuenta jém riqueza jém it́wɨɨp yɨ́p naxyucmɨ, jesɨc Dios d́at́im michiiba jém sɨŋyucmɨpɨc riqueza. ");
INSERT INTO poiNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Siiga d́a iŋwɨ̱wada̱p cuenta jém tuŋgac pɨ̱xiñ imɨɨchi, jesɨc d́a i̱ michiiba jém cosa iga wɨa̱p immɨɨcha̱ porque d́a iŋwatpa cuenta. ");
INSERT INTO poiNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Tu̱m esclavo, tu̱m pɨ̱xiñ juyñewɨɨp, d́a wɨa̱p icuyo̱xa̱ wɨste̱n io̱mi. Porque tu̱m it́oypa y tu̱m ijóyixpa. Tu̱m iwɨ̱nanɨgáypa y jém tuŋgac d́a iwɨ̱ixpa. D́a wɨa̱p iŋcuyo̱xata Dios siiga tsa̱m iñt́oypa iñt́umiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Jém fariseoyaj como tsa̱m it́oypa it́umiñ, ixiccayajpa jém Jesús cuando imatoŋ t́i nɨm. ");
INSERT INTO poiNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Pero Jesús iñɨ́máy jém fariseoyaj: —Mimicht́am iñyaac miniŋquejta̱p iga wɨbɨc mipɨ̱xiñ. Miñɨ́maŋtaaya̱p iga wɨbɨc mipɨ̱xiñ. Wɨa̱p immɨgóyayyaj jém iñt́ɨ̱wɨtam, pero Dios miixpɨgáypa íña̱nama, tsa̱m pɨ̱mi ijóyixpa jém mɨgooyi. ");
INSERT INTO poiNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Wiñt́i it́ id́ɨc jém aŋquímayooyi jém tachiiñewɨɨp jém Moisés y jém wiñɨcpɨc profeta. Ocmɨ miñ jém Xiwan jém acchíŋoypáppɨc. Moj iŋmat jém wɨbɨc aŋma̱t́i ju̱t́pɨc iŋjacpa Dios yɨ́p naxyucmɨ. Sɨɨp tsa̱m pɨ̱mi tɨgɨyyajtooba jém pɨxiñt́am ju̱t́ iŋjacpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’D́a i̱ wɨa̱p iccuyaj jém Dios iŋma̱t́i. Meega cuyajpa jém sɨŋ y jém nas, jém Dios iŋma̱t́i tienes que iccupacpa, d́a togoypa ni tu̱m tɨɨmi ni tu̱m jɨ̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Siiga tu̱m pɨ̱xiñ ichacpa iyo̱mo y ipɨcpa tuŋgac yo̱mo, jesɨc pejóypa. Siiga tuŋgac pɨ̱xiñ ipɨcpa jém yo̱mo, jém tsacneta̱wɨɨp, jesɨc pejóypat́im. ");
INSERT INTO poiNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’It́ id́ɨc tu̱m pɨ̱xiñ tsa̱m rico. Siempre wɨ̱cuyajpa con jém wɨbɨc puctu̱cu jém tsoowɨywɨɨp. Cada ja̱ma sɨ́ŋa̱p, maymáya̱p. Tsa̱m wɨ̱ it́. ");
INSERT INTO poiNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","It́t́im id́ɨc tu̱m pɨ̱xiñ agui yaacha̱p, iñɨ̱yi Lázaro. Agui iquímcane puucɨ iñacyucmɨ. Nɨcpa co̱ñi jém Lázaro jém rico it́ɨc aŋna̱ca. ");
INSERT INTO poiNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Tsa̱m yua̱p jém Lázaro. Icúttooba id́ɨc jém ipaccapaap jém rico imesacɨɨm. Jém chimpa icunúcyajpa jém Lázaro, iñémáypa ipuucɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ocmɨ ca jém Lázaro. Jém sɨŋyucmɨpɨc pɨxiñt́am ininɨc sɨŋyucmɨ jém wɨ̱co̱m ju̱t́ it́ jém Abraham. Jesɨc ocmɨ caat́im mex jém rico. Cu̱mta̱. ");
INSERT INTO poiNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Jém ia̱nama nɨc i̱t́i ju̱t́ tsa̱m yaacha̱yajpa jém caaneyajwɨɨp. Pɨ̱mi yaacha̱p jém rico. Cuando ámnɨc, juumɨ iix jém Lázaro wagait́yaj con jém Abraham. ");
INSERT INTO poiNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Jesɨc pɨ̱mi aŋwejpa jém rico. Nɨmpa: “Manja̱tuŋ Abraham, ayaachaŋja̱mɨ. Acutsadaayɨ jém Lázaro iga imujiñ icɨaŋqui̱ñi con nɨ iga míñiñ amujáy antots iga cupagaga̱iñ porque sɨɨp pɨ̱mi ayaacha̱p juctjo̱m.” ");
INSERT INTO poiNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Jesɨc Abraham iñɨ́máy: “Ma̱nɨc, jɨ̱sɨ iga tsa̱m miwɨ̱it́ id́ɨc cuando d́anam micaane. Pero jém Lázaro tsa̱m yaacha̱p id́ɨc. Pero sɨɨp wɨ̱ it́um jém Lázaro, maymay. Mich tsa̱m miyaacha̱p. ");
INSERT INTO poiNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Mannɨ́máypat́im iga it́ tu̱m mɨjpɨc pacus entre aɨcht́am y mimicht́am. D́a i̱ wɨa̱p ijac. Siiga yɨɨmpɨc nɨctooba jemɨc, d́a wɨa̱p iñas. Siiga jemɨcpɨc miñt́ooba yɨɨm d́at́im wɨa̱p iñas.” ");
INSERT INTO poiNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Jesɨc nɨmpa jém rico: “Manja̱tuŋ Abraham, maŋcunucsáypa, cutsa̱tɨ jém Lázaro anja̱tuŋ it́ɨccɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Anait́ cinco antɨ̱wɨ. Accutsadaayɨ jém Lázaro iga iñɨ́máyiñ jém antɨ̱wɨtam iga odoy míñiñ yɨɨm ju̱t́ tsa̱m ayaacha̱p ansɨ.” ");
INSERT INTO poiNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Pero Abraham iñɨ́máy jém rico: “Jeeyaj iniit́ jém Dios iŋma̱t́i jém ijayñewɨɨp jém Moisés y jém wiñɨcpɨc profeta. Wɨa̱p icupɨcyaj.” ");
INSERT INTO poiNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Pero nɨmpa jém rico: “D́a icupɨcyajpa, manja̱tuŋ Abraham, pero siiga nɨcpa tu̱m jém caanewɨɨp, jesɨc icucacpa ijɨ̱xi jém antɨ̱wɨtam.” ");
INSERT INTO poiNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Pero jém Abraham iñɨ́máy: “Siiga d́a icupɨcyajpa jém Dios iŋma̱t́i jém ijayñewɨɨp jém Moisés y jém wiñɨcpɨc profeta, jesɨc d́at́im icupɨcyajpa siiga miñ iŋmadáy tu̱m caanewɨɨp id́ɨc.” ");
INSERT INTO poiNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesɨc Jesús iñɨ́máy icuyujcɨɨwiñ: —Ju̱t́quej it́ jém malopɨc cosa iga micmalwatpa. Pero agui uuguyt́im jém pɨ̱xiñ jém ictáŋcawatpaap it́ɨ̱wɨtam. ");
INSERT INTO poiNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Tsa̱m jáyaŋ castigo ichiiba Dios jém icmalwatpáppɨc jém Dios ipɨxiñt́am. Más wɨ̱ iga cutsénayt́a̱iñ iɨscɨyucmɨ tu̱m molino icha y acpatsɨyt́a̱iñ lamar jém malopɨc pɨ̱xiñ iga jiccaiñ que iga icmalwatpa tu̱m jém yaguiñpɨc icupɨcne Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Jesɨc cuidado iga immalwatpa. ’Siiga táŋcaɨ́y tu̱m iñt́ɨ̱wɨ, aŋjɨyja̱cɨ iga ichaguiñ jém it́áŋca. Siiga icacpa ijɨ̱xi, wadaayɨ perdón. ");
INSERT INTO poiNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Siiga iñt́ɨ̱wɨ mimalwadáypa siete veces tu̱m ja̱ma, pero siete veces miñpa miñɨ́máy iga: “Awadaayɨ perdón, aŋcucacum anjɨ̱xi”, jesɨc wadaayɨ perdón siete veces. ");
INSERT INTO poiNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jesɨc jém doce apóstolyaj miñ iñɨ́mayyaj jém Jesús: —MánO̱mi, ayo̱xpáttaamɨ iga más aŋcupɨctámiñ iga Dios wɨa̱p iwat juuts ajɨycámayñe. ");
INSERT INTO poiNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jesɨc tánO̱mi iñɨ́máy icuyujcɨɨwiñ: —Siiga uxaŋ iŋcupɨcpa iga Dios wɨa̱p iwat juuts mijɨycámayñe, jesɨc ocmɨ más iŋcupɨcpa. Jex juuts tu̱m mostaza ipac. D́a jutsaŋ jém pac, pero ocmɨ naypa, mɨja̱p. Nu̱ma meega iŋcupɨcpa uxaŋ, jesɨc wɨa̱p iññɨ́máy jém sicómoro cuy: “Nawixquímta̱jɨ, nɨ̱gɨ miña̱yi lamar.” Jesɨc jém cuy mimatoŋpa. Iwatpa juuts iññɨ́máypa. ");
INSERT INTO poiNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Siiga iniit́ mich tu̱m esclavo oy ijɨ̱t nas o oy iwat cuenta jém imborrego, jesɨc cuando se̱tum iñt́ɨccɨɨm, d́a iññɨ́máypa jém íñesclavo iga mi̱ñɨ miwiiqui. ");
INSERT INTO poiNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Pero mich impɨɨmɨ́ypa jém íñesclavo. Iññɨ́máypa iga: “Awadaayɨ jém aŋwíccuy. Accaamɨ jém indelantal. Nami̱ñɨ jém wíccuy, tu̱nɨ mesayucmɨ. Wiñt́i acwiicɨ ɨch, acnɨɨcɨ, jesɨc ocmɨ miwícpa y miñɨ́cpat́im mex mich.” ");
INSERT INTO poiNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","D́at́im iŋcujíppa jém íñesclavo porque no más iwat juuts ipɨɨmɨ́y io̱mi. ");
INSERT INTO poiNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Jesa̱pt́im mimicht́am cuando yaj iŋwat juuts mipɨɨmɨyñe Dios, jesɨc más wɨ̱ iga iññɨ́máypa Dios yɨɨmpɨc: “Aɨch mich ánesclavo. D́a wɨ̱ iga mich aŋcujíppa porque no más aŋwat juuts mich ampɨɨmɨyñe.” ");
INSERT INTO poiNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesɨc iganam nɨcpa Jesús Jerusalén, naspa jém naxyucmɨ Samaria y Galilea. ");
INSERT INTO poiNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Núc tu̱m xut́u tɨgaŋjoj aŋna̱ca. Iganam tɨgɨy, ipát diez pɨ̱xiñ cupúgayñeyaj iña̱ca. Juumɨ tsɨ́yyaj iga odoy i̱ icmachiñ jém caacuy. ");
INSERT INTO poiNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Jesɨc pɨ̱mi aŋwejyajpa jém mɨmneyajwɨɨp, nɨmyajpa: —MiJesús, mamMaestro, ayaachaŋja̱mtaamɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesɨc Jesús iámmats, iñɨ́máy: —Nɨ̱gɨ wiñquejaayɨ jém pa̱nijyaj. Jesɨc mojum nɨquiyaj. Iganam nɨcyajpa, jeet́i rato wɨ̱tsɨ́yum jém iña̱ca, cuáyñeum. ");
INSERT INTO poiNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Jesɨc tu̱m de jeeyaj cuando iix iga pɨsneum, se̱t e̱ybɨc ju̱t́ it́ Jesús. Pɨ̱mi jɨypa, agui icujíppa Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jesɨc jém pɨ̱xiñ co̱ste̱ññeactɨŋ jém Jesús ipuycɨɨm. Nɨ́mayt́a̱ Jesús: “Iyucuɨpdios iga anacpɨs.” Jém pɨ̱xiñ Samariapɨc. ");
INSERT INTO poiNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesɨc nɨmpa Jesús: —¿Que d́a midieztam mipɨsta? ¿Ju̱t́ it́ jém nueve? ");
INSERT INTO poiNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Se̱t no más yɨ́p Samariapɨc pɨ̱xiñ iga icujíppa Dios? Yɨ́p tuŋgac pɨ̱xiñ, d́a je de Israel. ");
INSERT INTO poiNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jesɨc Jesús iñɨ́máy jém pɨ̱xiñ: —Tsucu̱mɨ, nɨcsɨm. Mich iŋcupɨcum iga Dios wɨa̱p micpɨs jeeyucmɨ micuáyñeum. ");
INSERT INTO poiNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Jém fariseoyaj icwácyaj jém Jesús: Iñɨ́mayyaj: —¿Jup ja̱ma tsucumpa Dios iga iŋjacpa yɨ́p naxyucmɨ? Jesɨc Jesús iñɨ́máy: —Cuando núcpa jém ja̱ma iga Dios iŋjacpa yɨ́p naxyucmɨ d́a t́i íñixt́ámpa ni d́a t́i quejpa. ");
INSERT INTO poiNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","D́a i̱ miñɨ́máypa iga yɨɨm iŋjacpa Dios o jeexɨc iŋjacpa Dios porque sɨɨp núcneum iga iŋjacpa Dios jém pɨxiñt́am ia̱namaŋjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ocmɨ Jesús iŋmadáy icuyujcɨɨwiñ: —Ɨch amiñ sɨŋyucmɨ iga aŋwatpa jém Dios iyo̱xacuy. Núcpa jém tiempo iga micht́am tsa̱m íñixt́amtooba jém ja̱ma iga amiñgacpa yɨ́p naxyucmɨ. Pero d́a íñixt́ámpa. ");
INSERT INTO poiNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Núcpa jém mɨgoyyajpaap, miñɨ́máypa iga yɨɨm it́ o jeexɨc it́. Odoy cupɨ̱cɨ. Odoy nɨ̱gɨ aamɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Jex juuts quénpa jém majɨywiñ, quejpa ju̱t́iŋquej. Jesa̱bam aɨch, jém aMiññewɨɨp Sɨŋyucmɨ, cuando amiñgacpa yɨ́p naxyucmɨ, it́u̱mpɨy jém it́yajwɨɨp wɨa̱p aixyaj. ");
INSERT INTO poiNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero wiñt́i tsa̱m pɨ̱mi ayaachwatta̱p. Jém pɨxiñt́am, jém it́yajwɨɨp sɨɨp, tsa̱m ajóyixyajpa; d́a awɨ̱ixyajpa. ");
INSERT INTO poiNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Juutst́im jém tiempo cuando it́ id́ɨc jém Noé, jesa̱pt́im jém tiempo cuando amiñgacpa yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Cuando it́ id́ɨc jém Noé, wícyajpat́im, ucyajpat́im. Aŋcoomɨyyajpat́im, ichiiyajpat́im iyo̱mma̱nɨctam iga aŋcoomɨyyajpa hasta que tɨgɨy jém Noé ibarcojo̱m. Jesɨc quím jém nɨ, cumoŋ icutero yɨ́p naxyucmɨ. Actogoyyajta̱ it́u̱mpɨy. ");
INSERT INTO poiNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Jesanet́im jém tiempo cuando it́ id́ɨc jém Lot. Jém pɨxiñt́am wícyajpa y ucyajpat́im, juyjúyoyyajpat́im y máymáyoyyajpat́im, ñipyajpat́im y tɨga̱yajpat́im. ");
INSERT INTO poiNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pero cuando put jém Lot de jém attebet de Sodoma, actɨŋ sɨŋyucmɨ juctɨ y azufre juuts chijóypa tuj. Actogoyyajta̱ it́u̱mpɨy jém Sodomapɨc pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Jesanet́im aɨch jém aMiññewɨɨp Sɨŋyucmɨ cuando e̱ybɨc awiñquejpa yɨ́p naxyucmɨ, d́a i̱ ijo̱doŋ jucha̱ amiñpa. ");
INSERT INTO poiNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Jesɨc cuando núcum jém ja̱ma, siiga químne algunos jém tɨgaŋco̱bac, jesɨc odoy qued́iñ iga it́oppa itraste jém it́wɨɨp it́ɨcjo̱m. Jém nɨcnewɨɨp ica̱mjo̱m odoy se̱d́iñ iga miñpa ipɨc itraste. ");
INSERT INTO poiNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Jɨ̱staamɨ t́i iñasca jém Lot iwɨcho̱mo. ");
INSERT INTO poiNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Jém pɨ̱xiñ jém tsa̱mpɨc it́oypa ivida yɨ́p naxyucmɨ tienes que togoypa jém ivida. Pero jém d́apɨc ijɨ̱spa ivida yɨ́p naxyucmɨ, je d́a togoypa ivida. ");
INSERT INTO poiNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Mannɨ́máypa iga jeet́im tsuu, wɨste̱n wagamoŋyajpa tseesmɨ. Tu̱m nanɨcta̱p, tu̱m tsacta̱p. ");
INSERT INTO poiNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Wagawayyajpa wɨste̱n yo̱mo. Tu̱m nanɨcta̱p, tu̱m tsacta̱p. ");
INSERT INTO poiNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Wagayo̱xayajpa wɨste̱n pɨ̱xiñ ica̱mjo̱m. Tu̱m nanɨcta̱p, tu̱m tsacta̱p. ");
INSERT INTO poiNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Mu imatoŋyaj icuyujcɨɨwiñ icwácyaj jém Jesús. Iñɨ́mayyaj: —¿MánO̱mi, ju̱t́ iñascayajpa je̱mpɨc? Jesɨc Jesús iñɨ́máypa: —Tsa̱m wɨ̱quejpa ju̱t́ caane tu̱m ani̱mat, jemum aŋtuuma̱neyaj jém nuupuyaj. Jesa̱pt́im cuando núcpa jém ja̱ma, it́u̱mpɨy pɨxiñt́am wɨa̱p iixyaj. ");
INSERT INTO poiNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesɨc Jesús iŋmat tu̱m xut́u cuento iga iŋquejáypa jém icuyujcɨɨwiñ iga iŋwejpátyajiñ Dios cada ja̱ma y odoy cut́íña̱iñ. ");
INSERT INTO poiNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Nɨmpa Jesús: —It́ id́ɨc tu̱m attebet tu̱m juez. D́a icɨ̱ŋpa Dios, d́at́im iwɨ̱ixpa ni tu̱m pɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","It́t́im jém attebet tu̱m cuno̱ya. Tsa̱m nɨcpa iám jém juez iga iwɨ̱tsaguiñ jém ipleito. Nɨmpa: “Aŋjɨyja̱cɨ jém amalwadaypáppɨc iga odom más amoogɨ́yiñ.” ");
INSERT INTO poiNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Jém cuno̱ya wa̱t́cɨy oy iám jém juez, pero jém juez d́a imatóŋáypa. Pero ocmɨ ijɨ̱spa ico̱bacjo̱m jém juez: “Ɨch d́a aŋcɨ̱ŋpa Dios ni d́at́im aŋwɨ̱ixpa ni tu̱m pɨ̱xiñ, ");
INSERT INTO poiNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","pero como yɨ́p cuno̱ya tsa̱m miñpa aco̱bacpij, sɨɨp anyo̱xpátpa. D́a wɨa̱p anyaachɨ́y siiga seguido miñpa quejajwa̱t́i.” ");
INSERT INTO poiNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Nɨmpat́im tánO̱mi: —Jɨ̱staamɨ t́i iwat jém malopɨc juez. ");
INSERT INTO poiNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Pero d́a jex jém tanJa̱tuŋ Dios. Tsa̱m iyo̱xpátpa jém icupiŋneyajwɨɨp. D́a jáypa iyo̱xpát jém iŋwejpátpáppɨc tsuucɨɨm y sɨŋñi. ");
INSERT INTO poiNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Mannɨ́máypa iga Dios d́a jáyñe iyo̱xpátpa ipɨxiñt́am. Pero cuando ɨch, jém aMiññewɨɨp Sɨŋyucmɨ, amiñgacpa yɨ́p naxyucmɨ, d́a ampátpa wa̱t́i jém icupɨcneyajwɨɨp Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","It́ algunos ijɨ̱syajpa iga d́a táŋcaɨ́y. Jeeyaj tsa̱m ijóyixyajpa los de más. Jesɨc Jesús moj iŋmat tu̱m xut́u cuento iga iŋquejáypa jeeyaj iga táŋcaɨ́y it́u̱mpɨy jém pɨxiñt́am. Iñɨ́máy: ");
INSERT INTO poiNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Nɨcyaj wɨste̱n pɨ̱xiñ jém mɨjpɨc ma̱stɨcjo̱m iga iwatyajpa oración. Tu̱m jém fariseopɨc pɨ̱xiñ. Tuŋgac jém ichécpáppɨc impuesto. ");
INSERT INTO poiNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Jém fariseopɨc te̱ñchucum, iyaac iwat oración. Nɨmpa: “ManDios, iyucuɨpdios iga ɨch d́a ajex juuts jém tuŋgac pɨxiñt́am jém táŋcaɨycɨɨwiñ, jém númpáppɨc y jém pejoypáppɨc. Ɨch d́a ajex juuts yɨ́p ichécpáppɨc impuesto. ");
INSERT INTO poiNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Cada ocho día ɨch aŋwatpa ayuno wɨscɨy. ManDios, manchiiba jém décima parte de it́u̱mpɨy aŋcoñwɨyooyi.” ");
INSERT INTO poiNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Jesɨc jém ichécpaap impuesto tɨgɨyñet́im ma̱stɨcjo̱m, pero d́a núcpa ju̱t́ iŋwejpátyajpa Dios. D́a wɨa̱p iámquím sɨŋyucmɨ. Tsa̱m ixoŋpa ipecho porque pɨ̱mi aŋyácne iga imalwatne contra jém Dios iŋquímayooyi. Nɨmpa jém ichécpáppɨc impuesto: “ManDios, ayaachaŋja̱mɨ, tsa̱m atáŋcaɨ́y.” ");
INSERT INTO poiNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jesɨc nɨmt́im Jesús: —Mannɨ́máypa iga Dios iccáyáy yɨ́p pɨ̱xiñ it́áŋca. Jesɨc se̱tum it́ɨccɨɨm, d́am táŋcaɨ́y. Pero Dios d́a iccáyáy jém fariseopɨc it́áŋca. Porque jém iŋnécpáppɨc jém it́áŋca, Dios d́a ipɨctsoŋpa. Pero jém d́apɨc iŋnécpa jém it́áŋca, Dios ipɨctsoŋpa. ");
INSERT INTO poiNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Jesɨc tu̱m ja̱ma namiñyajta̱ jém xuxut́ tsɨ̱xt́am ju̱t́ it́ Jesús iga ichɨgáyiñ ico̱bac iga ichiiñ bendición. Pero cuando iixyaj jém icuyujcɨɨwiñ, iwogayyaj jém inimiññeyajwɨɨp jém tsɨ̱xt́am. ");
INSERT INTO poiNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Pero Jesús iŋwejáypa jém tsɨ̱xt́am. Iñɨ́máy icuyujcɨɨwiñ: —Ɨch aŋwɨ̱aŋja̱m iga míñiñ aámyaj jém xuxut́ tsɨ̱xt́am. Odoy aŋjɨyja̱cɨ. Porque jém tɨgɨyyajpaap ju̱t́ iŋjacpa Dios jex juuts yɨ́pyaj xuxut́ tsɨ̱xt́am. ");
INSERT INTO poiNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nu̱ma mannɨ́máypa siiga tu̱m pɨ̱xiñ d́a ijɨ́cpa iga iŋjacpa Dios juuts tu̱m xut́u tsɨ̱xi, jesɨc d́a wɨa̱p iñúc ju̱t́ iŋjacpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Jesɨc miñ tu̱m Israelpɨc aŋjagooyi iga icwácpa Jesús. Iñɨ́máy: —Wɨbɨc Maestro, ¿t́i wɨa̱p aŋwat iga ampɨctsoŋpa jém vida jém d́apɨc cuyajpa? ");
INSERT INTO poiNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesɨc Jesús iñɨ́máy jém pɨ̱xiñ: —¿T́iiga miñɨmpa iga ɨch awɨ̱? It́ tu̱m jém wɨbɨc, je jém tanJa̱tuŋ Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Iŋwɨ̱jo̱doŋ jém Dios iŋquímayooyi: “Odoy pejooyɨ; odoy accaooyɨ; odoy nuumɨ; odoy cumɨgooyɨ tuŋgac pɨ̱xiñ; to̱yɨ jém iñja̱tuŋ con jém íña̱pa.” ");
INSERT INTO poiNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Jesɨc jém pɨ̱xiñ iñɨ́máy Jesús: —Ɨch je̱mpɨgam aŋwatne dende atsɨ̱xiñam. ");
INSERT INTO poiNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Mu imatoŋ, Jesús iñɨ́máy: —No más tu̱m cosa mit́ogóyáy. Cumáyaayɨ it́u̱mpɨy jém iniit́wɨɨp, chi̱ɨ jém tumiñ jém yaacha̱yajpáppɨc. Jesɨc iniit́pa jáyaŋ wɨbɨc riqueza sɨŋyucmɨ. Jesɨc mi̱ñɨ atúŋɨɨyɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Cuando imatoŋ jém pɨ̱xiñ, tsa̱m pɨ̱mi aŋyác porque tsa̱m tumiñɨ́y. ");
INSERT INTO poiNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Cuando Jesús iix iga tsa̱m aŋyác jém pɨ̱xiñ, jesɨc iñɨ́máy los de más: —Tsa̱m táŋca iga jém ricopɨc núcyajpa ju̱t́ iŋjacpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Más dá táŋca iñas tu̱m camello jém núncuypac ijo̱sjo̱m que iga tɨgɨypa tu̱m ricopɨc ju̱t́ iŋjacpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Jesɨc jém imatoŋneyajwɨɨp iñɨ́mayyajpa Jesús: —¿Jesɨc i̱ wɨa̱p icɨɨput? ");
INSERT INTO poiNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesús iñɨ́máy: —Jém d́apɨc wɨa̱p iwat jém pɨxiñt́am, wɨa̱p iwat Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Jesɨc jém Peto iñɨ́máy Jesús: —MánO̱mi, aɨcht́am antsacneum it́u̱mpɨy jém anait́wɨɨp iga mantúŋɨ́ypa. ");
INSERT INTO poiNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesɨc Jesús iñɨ́máy jém icuyujcɨɨwiñ: —Nu̱ma mannɨ́máypa, siiga iñchacpa iñt́ɨc o iñja̱tuŋ o íña̱pa o iñt́ɨ̱wɨtam o iñyo̱mo o imma̱nɨctam iga nɨcpa iŋwat juuts mipɨɨmɨ́ypa Dios, ");
INSERT INTO poiNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","jesɨc Dios miwɨ̱yojpa yɨ́p naxyucmɨ, ocmɨ nɨcpa mii̱t́i con Dios para siempre. ");
INSERT INTO poiNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesɨc Jesús iŋwejput jém doce icuyujcɨɨwiñ, iñɨ́máy: —Matoŋtaamɨ, sɨɨp tanɨcpa Jerusalén. Jém wiñɨcpɨc profeta ijaychacne t́i annascaaba aɨch jém aMiññewɨɨp Sɨŋyucmɨ. Jemɨc Jerusalén cupacpa it́u̱mpɨy juuts ijaychacne. ");
INSERT INTO poiNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Acɨɨjuŋcotta̱p jém tuŋgac pɨxiñt́am icɨɨjo̱m jém d́apɨc je de Israel. Jeeyaj asaayɨyyajpa, amalnɨ́mayyajpa y atsujcayajpa. ");
INSERT INTO poiNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Pɨ̱mi acótsyajpa, ocmɨ accaayajpa jém malopɨc pɨxiñt́am. Pero jém tucunaja̱ma acpɨsta̱p de ju̱t́ it́ jém caaneyajwɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Jém icuyujcɨɨwiñ d́a wɨa̱p icutɨɨyɨyyaj t́i iñɨ́máy jém Jesús. Porque Dios d́a ijɨ́cpa iga wɨa̱iñ icutɨɨyɨ́y. Aŋnécne jém jɨ̱xi para jeeyaj. ");
INSERT INTO poiNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesɨc cuando núc noco Jesús jém attebet Jericó, jemum co̱ñ tu̱m cácht́i tuŋaŋna̱ca iga iwácpa tumiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Mu imatoŋ iga naspa tsa̱m jáyaŋ pɨxiñt́am, jém cácht́i icwácpa t́i naspa. ");
INSERT INTO poiNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Jesɨc jém it́yajwɨɨp iñɨ́mayyaj jém cácht́i: —Na̱xi jém Jesús jém Nazaretpɨc pɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Jesɨc pɨ̱mi aŋwejpa jém cácht́i. Nɨmpa: —¡MiJesús, jém rey David miMa̱nɨc, ayaachaŋja̱mɨ! ");
INSERT INTO poiNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Jesɨc jém aŋjagoyñeyajwɨɨp iñɨcyaj iwogayyajpa jém cácht́i. Ipɨɨmɨyyaj iga odoy jɨ́yiñ. Pero jesɨc más pɨ̱mi jɨypa jém cácht́i. Nɨmpa: —Jém rey David miMa̱nɨc, ayaachaŋja̱mɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jesɨgam teeñaŋjac Jesús. Ipɨɨmɨ́y jém it́yajwɨɨp iga inimíñáyiñ jém cácht́i. Cuando nanúcta̱ ju̱t́ it́ Jesús, jesɨc iñɨ́máy: ");
INSERT INTO poiNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿T́i iñxunpa iga maŋwadáypa? Nɨmpa jém cácht́i: —MánO̱mi, ansunpa iga actojaayɨ ánixcuy. ");
INSERT INTO poiNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesɨc Jesús iñɨ́máy: —Manactojáypa íñixcuy. Iga tsa̱m iŋcupɨcne, Dios micpɨs. ");
INSERT INTO poiNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Jeet́i rato toj jém cácht́i iixcuy. Ixixóypam. Mojum it́úŋɨ́y jém Jesús. Icujíppa Dios. Jesɨc cuando it́u̱mpɨy jém pɨxiñt́am iixyaj t́i iñasca, icujípyajpat́im Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesɨc tɨgɨy Jesús Jericó, na̱xi id́ɨc jém attebet. ");
INSERT INTO poiNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Jemum it́ id́ɨc tu̱m pɨ̱xiñ iñɨ̱yi Zaqueo. Aŋjagooyi id́ɨc de jém impuesto. Tsa̱m pɨ̱mi rico. ");
INSERT INTO poiNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Agui iixt́ooba jém Jesús, pero d́a wɨa̱p porque tsa̱m it́ñɨ̱m. Agui chapa jém Zaqueo. ");
INSERT INTO poiNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Jesɨc póyaŋtsucum jém Zaqueo, aŋjagóy miñɨc, quím tu̱m sicómoro cuyyucmɨ iga wɨa̱iñ iix Jesús porque jemɨgam naspa. ");
INSERT INTO poiNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Cuando naspa Jesús, iámquímáypa cuyyucmɨ ju̱t́ it́ jém Zaqueo. Iñɨ́máy: —MiZaqueo, impɨ̱mi que̱tɨ. Yɨ́p ja̱ma nɨcpa manjóyáy iñt́ɨccɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Jesɨc jicscɨy quet jém Zaqueo. Nɨc ichoŋ jém Jesús, iwagananɨcpa it́ɨccɨɨm. Tsa̱m maymay jém Zaqueo. ");
INSERT INTO poiNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Pero jém pɨxiñt́am d́a iwɨ̱aŋja̱myaj iga nɨcpa Jesús con jém Zaqueo. Moj icujɨyyaj jém Jesús. Nɨmyaj: —D́a wɨ̱ iga nɨcpa tanjóyáy tu̱m táŋcaɨywɨɨp it́ɨccɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ocmɨ te̱ñchucum jém Zaqueo it́ɨccɨɨm, iñɨ́máy Jesús: —MánO̱mi, sɨɨp aŋwécpa it́u̱mpɨy jém anait́wɨɨp. Cuccucmɨ anchiiba jém yaacha̱yajpáppɨc. Siiga i̱ ammɨgóyayñe iga annúmáy it́umiñ, jesɨc anácseedáypa cuatro veces. ");
INSERT INTO poiNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesɨc nɨmpa Jesús: —Yɨ́p ja̱ma cɨacputta̱p jém it́yajwɨɨp yɨ́p tɨccɨɨm. Táŋcaɨ́y id́ɨc, pero taɨch pɨ̱xiñ, ima̱nɨct́im jém Abraham. ");
INSERT INTO poiNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ɨch, jém aMiññewɨɨp Sɨŋyucmɨ, miñ amméts jém togoyñeyajwɨɨp iga aŋcɨacputpa. ");
INSERT INTO poiNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Iganam imatoŋyajpa, Jesús iŋmadáypat́im jeeyaj tu̱m xut́u cuento. Porque d́a juumɨ jém Jerusalén y jém pɨxiñt́am ijɨ̱syajpa iga d́am jáyñe núcpa jém tiempo iga Dios iŋjacpa yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Jesɨc Jesús iñɨ́máy: —It́ id́ɨc tu̱m wɨbɨc pɨ̱xiñ. Aŋwejayt́a̱p iga nɨguiñ iccámta̱ juuts tu̱m mɨjpɨc aŋjagooyi. Juumɨ nɨcpa ipɨc jém icargo. ");
INSERT INTO poiNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Pero antes que nɨcpa, iŋwejáy diez jém icuyo̱xapaap. Ichi cada tu̱mtu̱m cien tumiñ de plata. Iñɨ́máy jeeyaj: “Nɨ̱gɨ mimáymáyooyi iga iñyo̱xacaiñ yɨ́p tumiñ hasta amiñgacpa.” Ocmɨ nɨc jém pɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pero jém it́yajwɨɨp jém iñaxyucmɨ tsa̱m ijóyixyajpa jém wɨbɨc pɨxiñ. Jesɨc jeeyaj icutsatyaj aŋma̱t́i hasta ju̱t́ nɨcpa ipɨc jém icargo. Nɨmyajpa iga: “D́a ansuntámpa iga accámta̱ yɨ́p pɨ̱xiñ juuts anaŋjagooyi.” ");
INSERT INTO poiNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pero jém wɨbɨc pɨ̱xiñ oy ipɨc jém icargo. E̱ybɨc se̱t it́ɨcmɨ. Mu iñúc, iŋwejayyaj jém icuyo̱xayajpaap, jém ichiiñewɨɨp jém tumiñ. Ijo̱dóŋa̱tooba jutsaŋ icoñwɨyñe jém it́umiñ. Icwác cada tu̱mtu̱m de jeeyaj. ");
INSERT INTO poiNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Núc jém wiñt́ipɨc. Nɨmpa: “Máno̱mi, jém cien tumiñ de plata icoñwɨ́y mil tumiñ de plata.” ");
INSERT INTO poiNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Jém aŋjagooyi iñɨ́máy: “Agui wɨbɨc miyo̱xacɨɨwiñ. Iga iŋwɨ̱yo̱xaca jém tumiñ, jesɨc manaccámpa como tu̱m miŋjagooyi de diez attebet.” ");
INSERT INTO poiNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ocmɨ núc jém tuŋgac icuyo̱xapaap. Iñɨ́máy: “Máno̱mi, jém cien tumiñ de plata icoñwɨ́y quinientos tumiñ de plata.” ");
INSERT INTO poiNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Jém aŋjagooyi iñɨ́máy: “Jesɨc manaccámpa como miŋjagooyi iga iniŋjacpa cinco attebet.” ");
INSERT INTO poiNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Jesɨc núcpa tuŋgac jém icuyo̱xapaap. Nɨmpa: “Máno̱mi, yɨɨm it́ jém cien tumiñ de plata. Manaccáyayñe id́ɨc tu̱m pañuelojo̱m ");
INSERT INTO poiNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","porque agui acɨ̱ŋpa. Ɨch anjo̱doŋ iga tsa̱m impɨɨmɨ́ypa jém iñyo̱xacɨɨwiñ. Mich iñt́obáyáy jém tuŋgac pɨ̱xiñ imɨɨchi pɨ̱mi̱mɨ. Tuŋgac iñippa jém ca̱ma, pero mich impiŋpa jém cosecha.” ");
INSERT INTO poiNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Jesɨc nɨmpa jém aŋjagooyi: “Mich tsa̱m mimalo. Sɨɨp maŋcɨɨpiŋpa con micham iniŋma̱t́i. Siiga iñjo̱doŋ iga tsa̱m ampɨɨmɨ́ypa jém anyo̱xacɨɨwiñ y antobáypa jém tuŋgac pɨ̱xiñ imɨɨchi pɨ̱mi̱mɨ y iga ampiŋpa jém cosecha jém d́apɨc anñipne, ");
INSERT INTO poiNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿jesɨc t́iiga d́a iŋcucom antumiñ jém banco iga ɨch ampɨctsoŋpa antumiñ con icoñwɨyooyi cuando ase̱tum?” ");
INSERT INTO poiNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Jesɨc jém aŋjagooyi iñɨ́máy jém it́yajwɨɨp: “Accáyaayɨ yɨ́p pɨ̱xiñ it́umiñ. Chi̱ɨ jém iniit́wɨɨp jém mil tumiñ de plata.” ");
INSERT INTO poiNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Jesɨc nɨmyajpa jeeyaj: “Máno̱mi, iniit́um mil tumiñ de plata.” ");
INSERT INTO poiNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Pero jém aŋjagooyi iñɨ́máy: “Jém iniit́wɨɨp, anchiiba más. Jém d́apɨc jutsaŋ iniit́, más anaccáyáypa jém uxaŋpɨc iniit́. ");
INSERT INTO poiNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Sɨɨp nami̱ñɨ yɨɨm jém d́apɨc ixunyajpa iga ɨch accámta̱ juuts aŋjagooyi iga anaŋjacpa. Accaaya̱jɨ yɨɨm aŋwiñjo̱m jém malopɨc pɨxiñt́am.” ");
INSERT INTO poiNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jesɨc cuando yaj aŋma̱t́i Jesús, mojgacum nɨqui Jerusalén, aŋjagóypa iñɨc. ");
INSERT INTO poiNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Jesɨc núcyajtoobam jém wɨste̱n attebet jém Betfagé y Betania. Co̱tsɨc aŋna̱ca, jém co̱tsɨc iñɨ̱yi Olivos. Jesɨc Jesús icutsat wɨste̱n jém icuyujcɨɨwiñ iga iwatpa tu̱m mandado. ");
INSERT INTO poiNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Nɨ́mayyajta̱: —Nɨctaamɨ jém tɨgaŋjoj jém táŋámmocnewɨɨp. Cuando miñúctámpa, impáttámpa tu̱m burro tsenne. Jém burro d́a i̱ queman iquímca. Wi̱jɨ, anamíñaayɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Siiga i̱ micwácpa iga t́iiga iŋwijpa, jesɨc nɨ́maayɨ iga jém íñO̱mi ixunpa. ");
INSERT INTO poiNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Jesɨc nɨcyaj jém icutsatneyajwɨɨp, ipátyaj juuts iñɨ́máy Jesús. ");
INSERT INTO poiNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Cuando iwijyajpa jém burro, jém io̱mi acwágóypa, iñɨ́máy: —¿T́iiga iŋwijpa amburro? ");
INSERT INTO poiNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Jesɨc jém Jesús icuyujcɨɨwiñ icutsoŋyaj. Iñɨ́mayyaj: —Porque jém tánO̱mi ixunpa. ");
INSERT INTO poiNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Nanɨgayt́a̱p Jesús jém burro. Jesɨc jém icuyujcɨɨwiñ icutócyajpa jém burro con iyoot́i. Acquímta̱ Jesús burroyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Iganam nɨcpa jém Jesús, jém it́yajwɨɨp it́ógayyajpa iyoot́i tuŋjo̱m ju̱t́ wit́pa jém burro. ");
INSERT INTO poiNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Jesɨc núcyajpa nocojo̱m Jerusalén. Nasyajpa jém co̱tsɨcaŋna̱ca iñɨ̱yi Olivos. It́úŋɨyyajpa it́u̱mpɨy jém icupɨcneyajwɨɨp Jesús. Agui maymayyaj. Pɨ̱mi jɨyyajpa. Icujípyajpa Dios iga agui jáyaŋ wɨbɨc milagro iixyaj. ");
INSERT INTO poiNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Nɨmyajpa jém Jesús icuyujcɨɨwiñ: —TanJa̱tuŋ Dios tacutsadáy tu̱m Rey, wɨ̱ iga iwɨ̱wadáyiñ Dios. Maymáya̱yajpa jém it́yajwɨɨp sɨŋyucmɨ. Sɨɨp agui cujípta̱p tanJa̱tuŋ Dios jém yucmɨpɨc it́. ");
INSERT INTO poiNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Jesɨc algunos jém fariseoyaj jém it́yajwɨɨp jém pɨxiñt́ámaŋjo̱m, iñɨ́mayyaj jém Jesús: —Maestro, aŋjɨyja̱cɨ jém iŋcuyujcɨɨwiñ porque icujɨyyajpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Pero Jesús iñɨ́máy jém fariseoyaj: —Mannɨ́mayt́ámpa siiga jeeyaj d́a icujípyajpa Dios, jesɨc jɨyyajpa jém tsa jém it́wɨɨp tuŋ aŋna̱ca. ");
INSERT INTO poiNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Cuando núc nocojo̱m jém Jerusalén, mu iix jém attebet, agui wejpa Jesús. ");
INSERT INTO poiNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Nɨmpa: —Agui miuuguyt́im mimicht́am miit́t́aŋwɨɨp yɨ́p Jerusalén. Núctɨp jém wɨbɨc aŋma̱t́i iga micɨacputpa Dios, pero mimicht́am d́a iŋwɨ̱aŋja̱mta. Sɨɨp nasum jém ja̱ma iga impɨctsoŋtámpa jém wɨbɨc aŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Núcpa jém ja̱ma iga miyaachwattamta̱p. Jém íñenemigoyaj micute̱ñxe̱tpa icuwoyo yɨ́p attebet. Micunúcyajpa cada lado hasta d́a ju̱t́ wɨa̱p imput. ");
INSERT INTO poiNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Miccutɨŋtamta̱p naxyucmɨ. Mɨswatta̱pt́im it́u̱mpɨy jém tɨcyaj, cujegáypat́im jém tsaataañi. D́a tsɨ́ypa ni tu̱m jém tsa ju̱t́ cutatsquetne. Yajpa miccucaayt́amta̱ iñt́u̱mpɨyt́am. Miñt́ɨp Dios iga micɨacputtámpa, pero micht́am d́a iŋwɨ̱aŋja̱mta. ");
INSERT INTO poiNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jesɨc tɨgɨy Jesús jém mɨjpɨc ma̱stɨcjo̱m. Iquebacput aŋsɨ̱cmɨ it́u̱mpɨy jém máymáyoypáppɨc y jém juyjúyoypáppɨc. ");
INSERT INTO poiNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Jesús iñɨ́máy: —Je̱mpam jaychacneta̱ jém Dios iŋma̱t́i, nɨmpa Dios iga: “Ɨch antɨc ju̱t́ jém ampɨxiñt́am iŋwejpátyajpa Dios. Pero sɨɨp jém númyajpaap yamyajpa jém Dios it́ɨcjo̱m.” ");
INSERT INTO poiNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jesɨc ocmɨ accuyujóypa jém Jesús cada ja̱ma jém mɨjpɨc ma̱stɨcjo̱m. Pero jém pa̱nij aŋjagooyiyaj con jém escribaspɨc maestroyaj con jém Israelpɨc aŋjagooyiyaj tsa̱m imétsyajpa jutsa̱p iccaayaj jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pero d́a ipátyajpa jutsa̱p icca. Porque it́u̱mpɨy jém pɨxiñt́am pɨ̱mi iwɨ̱aŋja̱myaj iga imatoŋyajpa jém Jesús iŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Tu̱m ja̱ma accuyujóypa Jesús jém mɨjpɨc ma̱stɨcjo̱m. Iŋmadáypa jém pɨxiñt́am jém wɨbɨc aŋma̱t́i iga Dios tacɨacputpa. Jesɨc núcyaj jém pa̱nij aŋjagooyiyaj con jém escribaspɨc maestroyaj. Wagamiñyaj con jém wɨd́ayt́am. ");
INSERT INTO poiNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Nɨ́mayt́a̱ Jesús: —Anɨ́maayɨ: ¿I̱ miñɨ́máy iga iŋwatpa yɨɨmpɨc? ¿I̱ mipɨɨmɨ́y? ");
INSERT INTO poiNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesɨc Jesús icutsoŋ. Iñɨ́máy: —Ɨchgact́i manacwácpa. Anɨ́maayɨ: ");
INSERT INTO poiNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿I̱ ipɨɨmɨ́y jém Xiwan jém acchíŋoypaap? ¿Dios ipɨɨmɨ́y o jém pɨxiñt́am? ");
INSERT INTO poiNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Jesɨc jém aŋjagooyiyaj moj nanɨ́mayyajta̱ji entre jeeyaj: —Siiga tannɨ́máypa iga Dios ichi ipɨ̱mi jém Xiwan iga acchíŋóypa, jesɨc wɨa̱p tanɨ́máy iga: “¿Jesɨc t́iiga d́a iŋcupɨcta?” ");
INSERT INTO poiNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Pero siiga tannɨ́máypa iga Dios d́a ichi ipɨ̱mi jém Xiwan, jesɨc it́u̱mpɨy jém pɨxiñt́am tanácscaaba tsaamɨ porque jeeyaj icupɨcyajpa iga nunta profeta jém Xiwan. ");
INSERT INTO poiNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Jesɨc jém aŋjagooyiyaj icutsoŋyaj iga d́a ijo̱doŋ i̱ ichi ipɨ̱mi jém Xiwan. ");
INSERT INTO poiNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jesɨc Jesús iñɨ́máy: —Ɨch d́at́im mannɨ́máypa ju̱t́ ampɨc jém ampɨ̱mi iga aŋwatpa juuts sɨ́p aŋwat. ");
INSERT INTO poiNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jesɨc Jesús mojpa iŋmat tu̱m xut́u cuento iga iŋquejáypa jém pɨxiñt́am. Iñɨ́máy: —It́ id́ɨc tu̱m pɨ̱xiñ. Iniit́ tu̱m ja̱ca nas. Iñip tu̱m finca de uvas. Ocmɨ icnucs jém iñas tuŋgac jute̱n yo̱xacɨɨwiñ. Jesɨc jém nas io̱mi nɨc i̱t́i tuŋgac naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ocmɨ núc jém tiempo iga it́úcyajpa jém uvas. Jém nas io̱mi icutsat tu̱m jém icuyo̱xapaap iga iwéguiñ jém uvas con jém acnucsneta̱wɨɨp jém nas. Pero pɨ̱mi cótsta̱, acse̱tta̱, d́a t́i ichiiyaj. ");
INSERT INTO poiNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Jesɨc jém nas io̱mi icutsat tuŋgac jém icuyo̱xapaap. Pero cótsta̱t́im, malnɨ́mayt́a̱t́im. D́at́im i̱ ichi jém uvas. ");
INSERT INTO poiNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Jesɨc jém nas io̱mi tuccɨy icutsat tuŋgagam jém icuyo̱xapaap, pero accoowata̱, quebacputta̱t́im. ");
INSERT INTO poiNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Ocmɨ ijɨ̱s jém nas io̱mi: “¿T́i wɨa̱p aŋwat? Aŋcutsatpa jém amma̱nɨc jém tsa̱mpɨc antoypa. Ɨch anɨmpa iga wɨ̱ixt́a̱p jém amma̱nɨc.” ");
INSERT INTO poiNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Jesɨc jém pɨ̱xiñ ima̱nɨc nɨc ipɨc jém uvas. Pero mu iixyaj jém icnucsneyajwɨɨp jém nas, nanɨ́mayyajta̱p: “Yɨ́bam ipɨctsoŋpa jém ija̱tuŋ imɨɨchi. Sɨɨp tanaccaaba. Jesɨc taɨcht́am tammɨɨcha̱p yɨ́p nas.” ");
INSERT INTO poiNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Jesɨc matsta̱ jém pɨ̱xiñ ima̱nɨc, quebacputta̱, accaata̱ aŋsɨ̱cmɨ. Jesɨc Jesús icwác jém pɨxiñt́am: —Sɨɨp anɨ́maayɨ: ¿T́i iwatpa jém nas io̱mi con jém malopɨc pɨxiñt́am? ");
INSERT INTO poiNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ɨch anɨmpa iga miñpa iccucaáy it́u̱mpɨy jém icnucsnewɨɨp jém iñas. Imétspa tuŋgac iga iyo̱xacaiñ jém finca de uvas. Cuando imatoŋyajpa junɨmpa Jesús, jesɨc nɨmyaj jém aŋjagooyiyaj: —¡Ni Dios d́a ixunpa iga tannascaaba je̱mpɨc! ");
INSERT INTO poiNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesɨc Jesús pɨ̱mi iámmats jeeyaj. Iñɨ́máy: —¿Jesɨc t́i nɨmtooba jém Dios iŋma̱t́i jém jayñewɨɨp? Jém tɨcwatpaap ipatsáy jém tsa. Ocmɨ e̱ybɨct́im piŋta̱, accámta̱ ju̱t́ tsucumpa jém tɨgaŋtaana. Sɨɨp jeet́im tsa icóppacne jém tɨc. ");
INSERT INTO poiNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Nɨmt́im Jesús: —Siiga michutpa yɨ́p tsaayucmɨ, micusámáypa juuts tu̱m majcuy. Siiga micuchijquetpa yɨ́p tsa, michɨ́ypa juuts poot́i. ");
INSERT INTO poiNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Jém pa̱nij aŋjagooyiyaj con jém escribaspɨc maestroyaj imatsyajtooba id́ɨc jém Jesús jeet́i rato. Porque icutɨɨyɨyyaj iga jeeyaj icuyucmɨ iŋmatpa jém xut́u cuento. Pero d́a wɨa̱p imatsyaj. Icɨ̱ŋyajpa jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Jesɨc agui icuixyajpa jém Jesús. Icutsatyajpa jém icusutsyajpáppɨc. Jeeyaj nɨ́maŋtaaya̱yajpa iga icuyujcayajpa jém Jesús iŋquímayooyi. Pero mɨgóypa. Imétsyajpa ju̱t́pɨc wɨa̱p iquejajwadayyaj, icɨɨjuŋcotyajtooba Jesús jém gobernador icɨɨjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Jeeyucmɨ icwácyajpa Jesús, nɨ́mayt́a̱: —Maestro, anjo̱dóŋa̱ta iga iniŋmatpa jém wɨbɨc jɨ̱xi. Tsa̱m wɨ̱ jém íña̱nama. Mich d́a ammɨgóyáypa, siempre iniŋquejpa jém nu̱mapɨc aŋquímayooyi jém tachiiñewɨɨp Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Jesɨc anɨ́maayɨ: ¿Wɨ̱ iga tanyojáypa impuesto jém Romapɨc aŋjagooyi o d́a wɨ̱? ");
INSERT INTO poiNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pero Jesús icutɨɨyɨ́y iga agui jáyayaŋjɨ̱chɨch jém icusutsyajpaap. Iñɨ́máy: —¿T́iiga aŋcutɨtstámpa? ");
INSERT INTO poiNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Aŋquejaayɨ tu̱m jém tumiñ. ¿I̱ iwiñpac, i̱ iñɨ̱yi accámayñeta̱ yɨ́p tumiñyucmɨ? Jesɨc nɨmyaj jém pɨxiñt́am: —Jém César, jém Romapɨc aŋjagooyi. ");
INSERT INTO poiNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jesús iñɨ́máy: —Jesɨc jém Césarpɨc imɨɨchi, chiit́aamɨ jém César. Jém Diospɨc imɨɨchi, chiit́aamɨ Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Pero Jesús d́a t́i iŋmat jém pɨxiñt́ámaŋjo̱m iga jém ienemigoyaj d́a wɨa̱p iquejajwadayyaj. Ipooñaŋja̱myajpa iga agui wɨa̱p icutsoŋ Jesús. Jém icutɨtsyajpáppɨc d́am más jɨy. ");
INSERT INTO poiNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ocmɨ miñ iámyaj Jesús algunos jém saduceoyaj. Jeeyaj d́a icupɨcyajpa iga Dios icpɨspa jém caaneyajwɨɨp. Icwácyajpa jém Jesús, nɨmyajpa: ");
INSERT INTO poiNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Maestro, jém Moisés tajaychagayñe iga siiga caaba tu̱m pɨ̱xiñ y ichacpa iyo̱mo d́a ma̱nɨgɨ́y, jesɨc jém pɨ̱xiñ it́ɨ̱wɨ ipɨgáypa jém iyo̱mo iga inima̱nɨcwatpa. Tsɨ́ypa jém ima̱nɨc juuts jém caanewɨɨp ima̱nɨc. ");
INSERT INTO poiNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Jesɨc it́ id́ɨc tu̱m pɨ̱xiñ con siete ijayma̱nɨc. Aŋcoomɨ́ypa jém más a̱chpɨc. Ocmɨm ca. D́a ichac ni tu̱m ima̱nɨc. ");
INSERT INTO poiNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Jesɨc jém ipɨɨtsɨ ipɨc jém ica̱pay, jém cuno̱ya. Ocmɨ jém pɨ̱xiñ caat́im mex je. D́at́im inima̱nɨcwat jém yo̱mo. ");
INSERT INTO poiNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Jesɨc jém tuŋgac ijáyuc ipɨct́im jeet́im yo̱mo. Je̱mpɨgam iwatyaj icusiete. Ca it́u̱mpɨy. Ni tu̱m d́a inima̱nɨcwat jém yo̱mo. ");
INSERT INTO poiNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ocmɨ caat́im mex jém cuno̱ya. ");
INSERT INTO poiNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Jesɨc acwácta̱ Jesús: —Anɨ́maayɨ cuando acpɨsyajta̱p jém caaneyajwɨɨp, ¿jup de jeeyaj tsɨ́ypa iga jém yo̱mo iwɨd́a̱ya? Icusiete iniŋcoomɨyñeyaj jém yo̱mo. ");
INSERT INTO poiNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesɨc Jesús icutsoŋ. Nɨmpa: —Jém it́yajwɨɨp yɨ́p naxyucmɨ jém pɨxiñt́am y jém yo̱mtam aŋcoomɨyyajpa, napɨcyajta̱p. ");
INSERT INTO poiNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pero jém wɨa̱paap iñɨcyaj sɨŋyucmɨ, jém icpɨsyajpáppɨc Dios de jém caaneyajwɨɨp, d́am aŋcoomɨyyajpa, d́am napɨcyajta̱p jém pɨxiñt́am con jém yo̱mtam. ");
INSERT INTO poiNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Jém nɨ́cyajpáppɨc sɨŋyucmɨ d́a e̱ybɨc caayajpa. Tsɨ́yyajpa juuts jém sɨŋyucmɨpɨc pɨxiñt́am. Jeeyaj Dios ima̱nɨctam porque Dios ichiiyaj jém jo̱mipɨc mɨjta̱y. ");
INSERT INTO poiNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Jém Dios iŋma̱t́i, jém ijaychacnewɨɨp jém Moisés, taŋquejayt́ámpa iga acpɨsta̱p jém caaneyajwɨɨp. Nɨmpa iga cuando jípspa jém xut́u cuy, Dios iñɨ́máy jém Moisés iga: “Ɨch jém Abraham aDios, jém Isaac aDios y jém Jacob aDios.” ");
INSERT INTO poiNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Quejpa iga tanJa̱tuŋ Dios d́a je jém caanewɨ́ppɨc iDios, je jém vivopɨc iDios. ");
INSERT INTO poiNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Jesɨc jém escribaspɨc maestroyaj iñɨ́mayyaj jém Jesús: —Maestro, miwɨ̱nɨm. ");
INSERT INTO poiNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","D́a e̱ybɨc icwácyajpa. Icɨ̱ŋyaj. ");
INSERT INTO poiNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesɨc jém Jesús iñɨ́máy jém pɨxiñt́am: —¿Jutsa̱p iñɨmyaj iga jém Cristo jém rey David ima̱nɨc? ");
INSERT INTO poiNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Pero jém David ijaychacne jém Salmojo̱m: Jém tanJa̱tuŋ Dios iñɨ́máy jém tánO̱mi Cristo: “Co̱ñɨ yɨɨm anaŋwɨ̱mɨ ");
INSERT INTO poiNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","hasta que iŋcoñwɨ́y jém mijóyixyajpaap.” ");
INSERT INTO poiNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","’¿Pero jutsa̱p ichɨ́y jém Cristo juuts jém David ima̱nɨc siiga nɨmt́im jém David iga jém Cristo je jém iO̱mi? ");
INSERT INTO poiNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Iganam imatoŋyajpa it́u̱mpɨy jém pɨxiñt́am, Jesús iŋquejáypa jém icuyujcɨɨwiñ. Iñɨ́máy: ");
INSERT INTO poiNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—¡Nawatta̱jɨ cuenta! Odoy wa̱tɨ juuts iwatyajpa jém escribaspɨc maestroyaj. Agui iwɨ̱aŋja̱myaj iga iccámyajpa jém yagatsyoot́i. Agui iwɨ̱aŋja̱myaj iga tandioschiiñ calle. Imétsyajpa jém más yucmɨpɨc co̱ñcuy jém sinagoga. Cuando nɨcpa sɨ́ŋa̱ji icusúnɨyyajpa jém más wɨbɨc co̱ñcuy ju̱t́ wícyajpa. ");
INSERT INTO poiNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Agui jáypa iŋwejpát Dios iga tamɨgóyáypa. Pero ocmɨ iccáyáypa jém cuno̱ya it́ɨc. Yɨ́p malopɨc pɨxiñt́am ipɨctsoŋyajpa tsa̱m mɨjpɨc castigo cuando nɨcpa iyoj it́áŋca. ");
INSERT INTO poiNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jém mɨjpɨc ma̱stɨcjo̱m ámquím Jesús, iix jém ricopɨc icotyajpa tumiñ jém cajonjo̱m ju̱t́ cotta̱p ofrenda. ");
INSERT INTO poiNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Iixt́im tu̱m pobrepɨc cuno̱ya. Icot cajonjo̱m wɨste̱n xuxut́ tumiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Nɨmpa Jesús: —Nu̱ma, mannɨ́máypa iga yɨ́p pobrepɨc cuno̱ya más chióy que it́u̱mpɨy jém miññeyajwɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Yɨ́pyaj rico icotyajpa cajonjo̱m no más jém cutsɨ́yñewɨɨp. Pero yɨ́p yo̱mo aunque tsa̱m yaacha̱p, icuchiáy Dios it́u̱mpɨy jém iniit́wɨɨp. D́am t́i initsɨ́y iga ijuypa iwíccuy. ");
INSERT INTO poiNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Nɨmyajpa jém icuyujcɨɨwiñ: —Agui wɨ̱watneta̱ yɨ́p mɨjpɨc tamma̱stɨc. Agui wɨ̱tampɨc tsa accamayñeta̱. Agui wɨ̱tampɨc xaja jém inimiññewɨɨp jém pɨxiñt́am iga ichiiba Dios. Jesɨc nɨmpa Jesús: ");
INSERT INTO poiNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Núcpa jém ja̱ma iga mɨswatta̱p yɨ́p mɨjpɨc ma̱stɨc. D́a cutatsquetneeba ichɨ́y ni tu̱m tsa. It́u̱mpɨy accujegayyajta̱p. ");
INSERT INTO poiNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Jesɨc jém icuyujcɨɨwiñ icwácyaj jém Jesús. Nɨ́mayt́a̱: —¿MamMaestro, juchɨs naspa yɨ́pyaj cosa? ¿Jup seña tánixt́ampa cuando núctooba it́u̱mpɨy yɨ́pyaj cosa? ");
INSERT INTO poiNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Nɨmpa Jesús: —Nawattamta̱jɨ cuenta iga odoy i̱ mimɨgóyáyiñ. Porque miñyajpa wa̱t́i jém mɨgoyyajpaap ɨch annɨyi̱mɨ. Nɨmyajpa iga: “Ɨch aCristo”; y “Sɨɨp núcum jém tiempo.” Pero odoy cupɨ̱cɨ. Odoy túŋɨɨyɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Cuando immatoŋtámpa iga miñpa jém guerra y miñpa jém bulla, odoy cɨ̱ŋɨ. Porque wiñt́i naspa it́u̱mpɨy jexpɨc cosa. Pero d́anam jobit́ togoypa yɨ́p nas. ");
INSERT INTO poiNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Iñɨ́máyt́im Jesús: —Tu̱m nación áŋa̱yajpa con tuŋgac nación. Tu̱m naxyucmɨ iwatyajpa guerra con tuŋgac naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Miñpa jém mɨjpɨc nasyɨɨxi. Miñpa mɨjpɨc yuu, miñpa tsa̱m jáyaŋ caacuy ju̱t́iŋquej. Miñpa jém cosa agui michɨgaŋjécpa. Quejyajpa jém mɨjpɨc seña sɨŋyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Pero wiñt́i mimatstamta̱p mimicht́am. Mimalwadayt́amta̱p. Mininɨctamta̱p jém sinagoga iga miquejajwadayt́amta̱p. MicUcomtamta̱p cárcel. Mininɨctamta̱p jém rey iwiñjo̱m y jém gobernador iwiñjo̱m. Mijóyixt́amta̱p ɨch aŋcuyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Jesɨc cuando miñúctámpa jém aŋjagooyicɨɨm wɨa̱p iniŋmadayt́a jém wɨbɨc aŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Odoy wadaayɨ caso jutsa̱p inicupujta̱ iñyaac, ");
INSERT INTO poiNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","porque manchiiba aŋma̱t́i ju̱t́pɨc iŋcutsoŋpa. Manchiiba jém wɨbɨc jɨ̱xi. Jém mijóyixpaap d́a wɨa̱p micoñwɨ́y. D́a wɨa̱p micseedáy jém iniŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Algunos de micht́am mijóyixt́ámpa jém iñja̱tuŋ o íña̱pa o iñt́ɨ̱wɨ o íñamigo. Mimatstamta̱p iga micɨɨjuŋcotta̱p jém aŋjagooyicɨɨm. Miccaatamta̱p algunos de mimicht́am. ");
INSERT INTO poiNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","It́u̱mpɨy jém pɨxiñt́am jém it́yajwɨɨp yɨ́p naxyucmɨ mijóyixt́ámpa ɨch aŋcuyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pero d́a togoypa ni tu̱m iŋway jém iniit́wɨɨp iŋco̱bacyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Siiga iñyaachɨ́ypa cuando pɨ̱mi mimalwadayt́a̱p, jesɨc iŋcoñwɨ́y jém imvida. ");
INSERT INTO poiNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Pero cuando íñixt́ámpa iga cutánse̱tneum Jerusalén con soldado, jesɨc iñjo̱doŋtam iga jobit́ togoypa jém attebet. ");
INSERT INTO poiNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Siiga miit́ jém naxyucmɨ de Judea, jesɨc poyt́aamɨ, nɨctaamɨ jém co̱tsɨgaŋjo̱m. Siiga miit́ jém attebet de Jerusalén, jesɨc puttaamɨ, poyt́aamɨ. Siiga miit́ aŋsɨ̱cmɨ, jesɨc odoy tɨgɨ̱yɨ jém attebet. ");
INSERT INTO poiNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Porque núcum jém ja̱ma iga Dios ichiiba castigo jém Jerusalénpɨc pɨxiñt́am. Cupacpa jém aŋma̱t́i jém ijaychacnewɨɨp jém wiñɨcpɨc aŋmat́cɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Agui uuguyt́im jém yo̱mtam jém ma̱nɨccomcanewɨɨp y jém ictsútspáppɨc jém xuxut́ tsɨ̱xt́am. Porque miñpa tsa̱m jáyaŋ aŋyaaqui yɨ́p naxyucmɨ. Jém Israelpɨc pɨxiñt́am ipɨctsoŋyajpa tsa̱m mɨjpɨc castigo. ");
INSERT INTO poiNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Cuando miñpa jém guerra tsa̱m jáyaŋ accaayajta̱p, matsyajta̱p, nanɨcyajta̱p juumɨ hasta icuwɨ̱t́i yɨ́p naxyucmɨ. Jém juumɨpɨc pɨxiñt́am miñpa i̱t́i yɨ́p Jerusalén, imɨɨcha̱p hasta cupacpa jém tiempo iga Dios ijɨ́gáypa iga tsɨ́yyajpa je̱m. ");
INSERT INTO poiNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Jesɨc quejpa jém seña jém ja̱myucmɨ, jém po̱yayucmɨ y jém ma̱tsaaŋjo̱m. It́u̱mpɨy jém pɨxiñt́am icuwɨ̱t́i yɨ́p mundo tsa̱m pɨ̱mi cɨ̱ŋyajpa cuando imatoŋyajpa iga pɨ̱mi ju̱pa y tsɨgóypa jém lamar. D́a icutɨɨyɨyyajpa t́i wɨa̱p iwatyaj. ");
INSERT INTO poiNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Iga agui cɨ̱ŋyajpa, jém pɨxiñt́am cupóna̱quetyajpa cuando iixyajpa t́i naspa yɨ́p naxyucmɨ. Tsɨgoyyajpa jém ma̱tsa jém it́yajwɨɨp sɨŋyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Cuando amiñgacpa, aɨch jém aMiññewɨɨp Sɨŋyucmɨ, jesɨc it́u̱mpɨy jém pɨxiñt́am ju̱t́quej yɨ́p naxyucmɨ wɨa̱p aixyaj. Amiñgacpa ucsɨyucmɨ juuts tu̱m mɨjpɨc aŋjagooyi, anamiñpa jém Dios ipɨ̱mi. ");
INSERT INTO poiNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Cuando mojpa na̱xi yɨ́pyaj cosa, maymáya̱jɨ, agámquiimɨ iŋco̱bac, porque d́am jáyñe micɨacputtámpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Iŋmatt́im Jesús yɨ́p xut́u cuento: —Ámtaamɨ jém tsuj y jém tuŋgac cuyyaj. ");
INSERT INTO poiNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Siiga íñixt́ámpa iga químpa jém ma̱ñipɨc iay, jesɨc iñjo̱doŋ iga d́a jáypa naspa jém cuja̱msɨŋ, miñt́ooba jém cutujcɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Jesanet́im cuando íñixt́ámpa iga naspa yɨ́p cosa, iñjo̱doŋtam iga núctoobam jém ja̱ma iga Dios iñjacpa yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Nu̱ma mannɨ́mayt́ámpa iga d́a yajpa cucaaayiyaj jém it́yajwɨɨp jém tiempo hasta cupacpa it́u̱mpɨy juuts mannɨ́mayñe. ");
INSERT INTO poiNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Cuyajpa jém sɨŋ y jém nas, pero ɨch anaŋma̱t́i cupacpa, d́a nunca cuyajpa. ");
INSERT INTO poiNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Cuidado iga maŋcupiichcɨɨ́ypa cuando amiñgacpa. D́a wɨ̱ siiga tsa̱m it́ jém malopɨc jɨ̱xi íña̱namaŋjo̱m, tsa̱m miucpa, tsa̱m iñjɨ̱spa jém iniit́wɨɨp yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Jém ja̱ma miñpa juuts wimpa tu̱m trampa, ichɨgaŋjécyajpa jém pɨxiñt́am icuwɨ̱t́i yɨ́p naxyucmɨ, jém d́apɨc aŋjócneyaj. ");
INSERT INTO poiNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Nawɨ̱tsacnetamta̱jɨ, odoy tsa̱cɨ iga iniŋwejpáttámpa Dios iga Dios miyo̱xpád́iñ iga odoy immalnascaiñ cuando miñpa jém ja̱ma. Jesɨc wɨa̱p iññúc ɨch aŋwiñjo̱m jém aMiññewɨɨp Sɨŋyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jesɨc sɨŋñi Jesús iŋquejáypa jém it́yajwɨɨp jém mɨjpɨc ma̱stɨcjo̱m. Tsuucɨɨm nɨcpa i̱t́i jém co̱tsɨcyucmɨ, jém co̱tsɨc iñɨ̱yi Olivos. ");
INSERT INTO poiNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Cada cuque̱ja nɨcyajpa jáyaŋ jém pɨxiñt́am jém mɨjpɨc ma̱stɨcjo̱m iga imatoŋyajpa jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Jesɨc núctooba jém sɨŋ iga icútyajpa jém caxt́ána̱ñi sin levadura, iñɨ̱yi jém pascuasɨŋ. ");
INSERT INTO poiNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Jém pa̱nij aŋjagooyiyaj con jém escribaspɨc maestroyaj imétsyajpa jutsa̱p iccaayaj jém Jesús. Pero d́a wɨa̱p imatsyaj porque icɨ̱ŋyajpa jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Jesɨc ocmɨ jém Woccɨɨwiñ tɨgɨy jém Judas Iscariote ia̱namaŋjo̱m. Je tu̱m de jém docepɨc icuyujcɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Jesɨc jém Judas nɨc iŋmadáy jém pa̱nij aŋjagooyi y jém comandante de jém ma̱stɨcjo̱mpɨc policía jutsa̱p icɨɨjuŋcot jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Jesɨc agui maymayyaj jeeyaj. Iñɨ́mayyaj iga ichiiba tumiñ jém Judas cuando icɨɨjuŋcotpa jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Jesɨc jém Judas iwat trato con jeeyaj. Moj iméts ju̱t́pɨc icɨɨjuŋcotpa jém Jesús cuando d́a i̱yaj jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Jesɨc núcum jém ja̱ma iga iwatyajpa jém sɨŋ iga icútyajpa jém caxt́ána̱ñi sin levadura, jém pascuasɨŋ cuando accaayajta̱p jém ma̱ñborrego. ");
INSERT INTO poiNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesús icutsat jém Peto con jém Xiwan iga iwɨ̱tsacpa jém wíccuy. Nɨ́mayyajta̱: —Nɨ̱gɨ wattaamɨ jém wíccuy iga tanacnaspa jém pascuasɨŋ. ");
INSERT INTO poiNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Icwácyajpa jeeyaj, nɨ́mayt́a̱ Jesús: —¿Ju̱t́ iñxunpa iga tasɨ́ŋa̱támpa? ");
INSERT INTO poiNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Icutsoŋpa Jesús, nɨ́mayt́a̱p jém Peto y jém Xiwan: —Cuando mit́ɨgɨyt́ámpa jém attebet, impáttámpa tu̱m pɨ̱xiñ ininɨcpa tu̱m majcuy nɨ. Túŋɨyt́aamɨ hasta núcpa jém tɨccɨɨm ju̱t́ tɨgɨypa. ");
INSERT INTO poiNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Nɨ́maayɨ jém tɨc io̱mi iga jém imMaestro iñɨ́máypa iga: “¿Ju̱t́ it́ jém cuarto ju̱t́ asɨ́ŋa̱támpa con jém aŋcuyujcɨɨwiñ?” ");
INSERT INTO poiNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Jesɨc jém tɨc io̱mi miŋquejáypa tu̱m mɨjpɨc cuarto jém yucmɨpɨc piso, wɨ̱tsacneum, ju̱t́ it́ it́u̱mpɨy cosa iga tawícmoŋtámpa. Jemum wattaamɨ jém wíccuy. ");
INSERT INTO poiNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Jesɨc nɨcyaj, ipátyaj jém tɨc juuts iñɨ́máy Jesús. Jemum iwatyaj jém wíccuy iga wícmoŋyajpa jém pascuasɨŋ. ");
INSERT INTO poiNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Jesɨc núcum jém hora iga wícyajpa. Co̱ñyajum Jesús jém mesacɨɨm con jém doce apóstolyaj. ");
INSERT INTO poiNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Jesɨc iñɨ́máy jeeyaj: —Tsa̱m ansunpa iga aŋwatpa yɨ́p sɨŋ con mimicht́am antes que ayaachwatta̱p. ");
INSERT INTO poiNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Mannɨ́mayt́ámpa iga d́a e̱ybɨc tawagawícpa jém pascuasɨŋ hasta que núcpa jém ja̱ma iga Dios iŋjacpa yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Jesɨc Jesús ipɨc tu̱m copa icɨɨjo̱m. Iŋwejpát Dios. Jesɨgam iñɨ́máy jém icuyujcɨɨwiñ: —Pɨctaamɨ yɨ́p copa. Wéctaamɨ entre mimicht́am. ");
INSERT INTO poiNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Mannɨ́mayt́ámpat́im iga d́a e̱ybɨc ánucpa yɨ́p uvas iñɨ hasta que miñpa jém ja̱ma iga Dios iŋjacpa yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Jesɨc imatspɨc tu̱m caxt́ána̱ñi. Cuando yaj iŋwejpát Dios, iwéc jém caxt́ána̱ñi, ichi jém icuyujcɨɨwiñ. Iñɨ́máy: —Yɨ́p caxt́ána̱ñi ɨch ammɨjta̱y. Anchiiba ammɨjta̱y iga accaata̱iñ para mimicht́am. Wattaamɨ yɨɨmpɨc iga anjɨ̱stámpa mimicht́am. ");
INSERT INTO poiNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ocmɨ je̱mpɨct́im iwat con jém copa. Cuando yajum wiiqui, iñɨ́máy icuyujcɨɨwiñ: —Yɨ́p copa jém jo̱mipɨc trato jém aŋwatpáppɨc con mimicht́am iga maŋwɨ̱tsagáypa iñt́áŋca cuando antegáypa annɨɨpiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Sɨɨp yɨɨm it́ con taɨcht́am jém acɨɨjuŋcotpáppɨc. It́ icɨ yɨ́p mesayucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Nu̱ma ɨch accaata̱p, jeeyucmɨ jém anJa̱tuŋ Dios acutsat yɨ́p naxyucmɨ. Pero agui uuguyt́im jém pɨ̱xiñ jém acɨɨjuŋcotpaap jém malopɨc pɨxiñt́am icɨɨjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Jesɨc moj nacwácyajta̱ji entre jeeyaj iga i̱ icɨɨjuŋcotpa jém iMaestro. ");
INSERT INTO poiNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ocmɨ moj áŋa̱jiyaj jém icuyujcɨɨwiñ. Nacwácyajta̱ entre jeeyaj iga i̱ tsɨ́ypa juuts jém más mɨjpɨc aŋjagooyi de jeeyaj. ");
INSERT INTO poiNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Pero Jesús iñɨ́máy: —Yɨ́p naxyucmɨpɨc rey tsa̱m pɨ̱mi iccámpa orde. Tsa̱m ipɨɨmɨ́ypa jém ipɨxiñt́am. Pero jeeyaj icujípyajpa jém irey aunque agui ipɨɨmɨ́y. ");
INSERT INTO poiNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pero mimicht́am odoy wa̱tɨ je̱mpɨc. D́a wɨ̱ iga tsa̱m impɨɨmɨ́ypa jém iñt́ɨ̱wɨtam. Entre mimicht́am jém más mɨjpɨc aŋjagooyi tienes que tsɨ́ypa juuts jém más ma̱ñipɨc. Jém más mɨjpɨc tienes que micuyo̱xatámpa iñt́u̱mpɨyt́am. ");
INSERT INTO poiNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿I̱ más iniit́ ipɨ̱mi, jém co̱ññewɨɨp mesacɨɨm o jém icuyo̱xapaap, jém inimiñpáppɨc jém wíccuy? Mannɨ́máypa iga ɨch amiñ iga maŋcuyo̱xa̱p. ");
INSERT INTO poiNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Nɨmt́im Jesús: —Mimicht́am siempre miit́t́a con aɨch cuando tsa̱m acutɨ́tsta̱. ");
INSERT INTO poiNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Jeeyucmɨ manchiiba jém pɨ̱mi iga michɨ́yt́ámiñ juuts miŋjagooyit́am cuando ɨch miñpa anaŋjac jém it́yajwɨɨp yɨ́p naxyucmɨ. Sɨɨp manchiiba jém ampɨ̱mi porque ɨch achiiñe jém anJa̱tuŋ Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Tawagait́t́ámpa cuando miñpa anaŋjac jém pɨxiñt́am yɨ́p naxyucmɨ. Miwíctámpa y miñɨ́ctámpa ammesacɨɨm. Miwagaco̱ñt́ámpa jém aŋjagooyi ico̱ñcuyyucmɨ iga iŋcɨɨpiŋtámiñ jém doce tribu de jém Israelpɨc pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jesɨc Jesús iñɨ́máy jém Peto: —MiPeto, i̱xɨ iga jém Woccɨɨwiñ miwácneta iñt́u̱mpɨyt́am. Tsa̱m micutɨ́tspa siiga nu̱ma iŋcupɨcneta Dios. Micuxicstámpa juuts trigo. ");
INSERT INTO poiNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pero anaŋwejpátpa Dios para mimich iga odoy iñchaguiñ iga iŋcupɨcpa Dios. Pero ocmɨ cuando e̱ybɨc iŋcupɨcse̱tpa Dios, jesɨc yo̱xpaatɨ jém iñt́ɨ̱wɨtam iga iwɨ̱cupɨcyajiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Jém Peto iñɨ́máy Jesús: —MánO̱mi, ait́ listo iga tawaganɨcpa cárcel con mimich. Wɨa̱pt́im taŋwagaca. ");
INSERT INTO poiNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Pero jém Jesús iñɨ́máy: —MiPeto, mannɨ́máypa iga yɨ́pt́im ja̱ma antes que aŋwejpa jém ca̱yu anaŋnécpa túccɨy, miñɨmpa iga d́a ánixpɨcpa. ");
INSERT INTO poiNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jesɨc Jesús iñɨ́máy jém icuyujcɨɨwiñ: —Cuando maŋcutsatta sin morral, ni jém iñt́umiñ accáycuy, ni tuŋgac iŋcɨac; ¿jesɨc t́i mit́ogóyáy? Nɨmyaj jém icuyujcɨɨwiñ: —D́a t́i. ");
INSERT INTO poiNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jesɨc Jesús iñɨ́máy jeeyaj: —Siiga sɨɨp inimiññe jém immorral o jém iñt́umiñ accáycuy, jesɨc wɨa̱p ininɨc. Siiga d́a inii̱ tu̱m espada, maayɨ jém iñchamarra iga iñjuypa. ");
INSERT INTO poiNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Mannɨ́máypa iga nu̱ma anaccupacpa jém Dios iŋma̱t́i jém jaychacneta̱wɨɨp. Nɨmpa así: “Matsta̱p jém Cristo, chiit́a̱p castigo juuts tu̱m accaoyñewɨɨp.” Cupacpa it́u̱mpɨy juuts jaychacneta̱ jém Dios iŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Jesɨc nɨmyaj jém icuyujcɨɨwiñ: —MánO̱mi, yɨɨm it́ wɨste̱n espada. Nɨm Jesús: —It́um wɨ̱. ");
INSERT INTO poiNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jesɨc put Jesús, nɨc juuts icostumbre jém Olivos co̱tsɨc. It́úŋɨyyaj jém icuyujcɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Cuando núcyaj jém co̱tsɨcyucmɨ, Jesús iñɨ́máy jém icuyujcɨɨwiñ: —Aŋwejpáttaamɨ Dios iga odoy i̱ wɨa̱iñ micutɨ́tsta. ");
INSERT INTO poiNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Jesɨc Jesús ichac icuyujcɨɨwiñ, nɨc uxaŋ más juumɨ, jutspɨy taŋwípnɨcpa tu̱m tsa. Jemum co̱ste̱ññeactɨŋ, moj iŋwejpát Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Nɨmpa Jesús: —ManJa̱tuŋ, siiga mich iŋwɨ̱aŋja̱m, odoy jɨɨcɨ iga annascaaba yɨ́p mɨjpɨc yaacha̱ji. Pero odoy wa̱tɨ juuts ɨch ansunpa, wa̱tɨ juuts mich iŋwɨ̱aŋja̱m. ");
INSERT INTO poiNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Jesɨc miñ iwiñquejáy tu̱m sɨŋyucmɨpɨc pɨ̱xiñ iga iccamamwadáypa jém Jesús ia̱nama. ");
INSERT INTO poiNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Pero tsa̱m pɨ̱mi ijɨ̱spa iga accaata̱p, jesɨc más pɨ̱mi iŋwejpátpa Dios. Agui pɨ̱mi cupijpa hasta wɨtspa naxyucmɨ juuts nɨɨpiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Jesɨc yaj iŋwejpát Dios. Tsucum, nɨc ju̱t́ it́ jém icuyujcɨɨwiñ. Ipát iga moŋyajpa jeeyaj porque tsa̱m pɨ̱mi aŋyácneyaj. ");
INSERT INTO poiNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Jesɨc Jesús iñɨ́máy jém icuyujcɨɨwiñ: —¿T́iiga mimoŋtámpa? Tsucumtaamɨ. Aŋwejpáttaamɨ Dios iga odoy i̱ wɨa̱iñ micmalwat. ");
INSERT INTO poiNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Iganam jɨypa ixɨ jém Jesús, jesɨgam núcyaj tsa̱m jáyaŋ pɨxiñt́am. Jém Judas, jém it́wɨɨp id́ɨc con jém docepɨc icuyujcɨɨwiñ, inimiñ jém pɨxiñt́am iga icɨɨjuŋcotpa jém Jesús, icunúc, ichútsáy ia̱cpac. ");
INSERT INTO poiNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jesɨc Jesús iñɨ́máy: —MiJudas, ¿que mich aŋwadáypa atraición aɨch, jém aMiññewɨɨp Sɨŋyucmɨ, con tu̱m aŋna̱catsuuchi? ");
INSERT INTO poiNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jesɨc cuando icuyujcɨɨwiñ iixyaj iga matsta̱ jém Jesús, iñɨ́mayyaj: —MánO̱mi, ¿maŋcupujpa con jém espada? ");
INSERT INTO poiNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Tu̱m de jeeyaj it́ɨŋ jém co̱bacpɨc pa̱nij imozo. It́ɨŋquímáy it́a̱tsɨc jém aŋwɨ̱mɨpɨc. ");
INSERT INTO poiNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Pero nɨmpa Jesús: —Odoy wa̱tɨ je̱mpɨc. Jesɨc Jesús it́óbáy e̱ybɨc jém pɨ̱xiñ it́a̱tsɨc. ");
INSERT INTO poiNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Sɨɨbat́im mex jém pa̱nij aŋjagooyiyaj con jém mɨjpɨc ma̱stɨc iŋjagooyi y jém wɨd́ayt́am. Miñpa imatsyaj Jesús. Pero Jesús iñɨ́máy: —¿T́iiga miñ ammatsta con jém espada y con jém cuy? ¿Que ɨch anúmpaap? ");
INSERT INTO poiNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Jáyum tawagai̱t́i jém mɨjpɨc ma̱stɨcjo̱m, pero d́a i̱ ammats. Pero sɨɨp Dios ijɨ́cpa iga wɨa̱p ammatsta. Núc jém hora, wɨa̱p iŋwatta juuts ixunpa jém piichcɨɨmpɨc ipɨ̱mi. ");
INSERT INTO poiNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jesɨc matsta̱ jém Jesús, nanɨcta̱ jém pa̱nij aŋjagooyi it́ɨccɨɨm. Jém Peto ijuumactúŋɨ́y. ");
INSERT INTO poiNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Jesɨc jém it́yajwɨɨp jém tɨgaŋna̱ca icnúcyaj juctɨ, co̱ñyaj iga samyajpa. Jém Peto iwaganaco̱ñt́im. ");
INSERT INTO poiNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Jesɨc tu̱m yo̱mo, jém pa̱nij imozo, iix jém Peto iga co̱ñ ju̱t́ acnúcneta̱ juctɨ. Tsa̱m iámpa jém Peto, iixpɨc. Nɨm jém yo̱mo: —Yɨ́p pɨ̱xiñ sɨɨba id́ɨc con je. ");
INSERT INTO poiNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pero jém Peto iŋnéc. Iñɨ́máy jém yo̱mo: —Miyo̱mo, ɨch d́a ánixpɨcpa jém pɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ocmɨ tuŋgagam pɨ̱xiñ iix jém Peto. Nɨ́mayt́a̱: —¡Mich, tu̱m de mijeet́im! Pero jém Peto iñɨ́máypa jém pɨ̱xiñ: —¡Mipɨ̱xiñ, d́a ánixpɨcpa! ");
INSERT INTO poiNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ocmɨ como tu̱m hora, tuŋgagam pɨ̱xiñ nɨmpat́im: —Nu̱ma, yɨ́p pɨ̱xiñ it́ id́ɨc con je, quejpa iga Galileapɨc. ");
INSERT INTO poiNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Jesɨc Peto iñɨ́máy: —Mipɨ̱xiñ, d́a anjo̱doŋ t́i sɨ́p iññɨmta. Jesɨc jeet́i rato iganam jɨypa jém Peto, jesɨgam aŋwej jém ca̱yu. ");
INSERT INTO poiNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","TánO̱mi iámseedáy, iix jém Peto. Jesɨc Peto ijɨ̱s t́i iñɨ́mayñe jém tánO̱mi cuando miñɨ́mayt́a̱ jém Peto iga: “Antes que aŋwejpa jém ca̱yu, mich anaŋnécpa tuccɨy.” ");
INSERT INTO poiNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Jesɨc put jém Peto. Tsa̱m pɨ̱mi wejpa. Agui aŋyácne. ");
INSERT INTO poiNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jesɨc jém imatsneyajwɨɨp Jesús ixaayɨyyajpa. Ixoŋyajpa. ");
INSERT INTO poiNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Aŋmónayt́a̱ jém Jesús iixcuy con tu̱m puctu̱cu. Jesɨc icwácyaj Jesús, nɨ́mayt́a̱: —Siiga mixabio, anɨ́maayɨ i̱ mixoŋ. ");
INSERT INTO poiNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Jesɨc pɨ̱mi imalmalnɨ́mayyajpa jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Jesɨc cuquejum, aŋtuuma̱yajpa jém wɨd́ayt́am jém Israelpɨc aŋjagooyiyaj. It́yajt́im jém pa̱nij aŋjagooyiyaj con jém escribaspɨc maestroyaj. Nanɨcta̱ Jesús ju̱t́ aŋtuuma̱neyaj jém wɨd́ayt́am, jém Sanhedrín. Jesɨc jém aŋjagooyiyaj icwácyaj jém Jesús. Nɨ́mayt́a̱: ");
INSERT INTO poiNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Siiga miCristo, jém micutsatnewɨɨp Dios, jesɨc aŋma̱tɨ. Jesɨc Jesús iñɨ́máy: —Siiga mannɨ́máypa iga ɨch aCristo, d́at́im iŋcupɨctámpa. ");
INSERT INTO poiNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Siiga mannɨ́máypa iga t́iiga micwágoyt́ampa, jesɨc mich d́at́im aŋcutsoŋtámpa ni d́at́im aŋcutsɨgayt́ámpa. ");
INSERT INTO poiNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pero ɨch, jém aMiññewɨɨp Sɨŋyucmɨ, sɨɨp nɨcpa aco̱ñi jém Dios iŋwɨ̱mɨ, jém iniit́wɨɨp it́u̱mpɨy ipɨ̱mi. ");
INSERT INTO poiNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Jesɨc it́u̱mpɨy jém it́yajwɨɨp icwácyajpa Jesús. Nɨmyajpa: —¿Que mich Dios miMa̱nɨc? Jesɨc jém Jesús icutsoŋ. Nɨmpa: —Mich miñɨmpa iga aɨcham. ");
INSERT INTO poiNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Jesɨc nɨmyajpa jém pɨxiñt́am: —D́am tammétstámpa tuŋgac testigo, iyaagam naŋmatcata̱. ");
INSERT INTO poiNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Jesɨc tsucumyaj it́u̱mpɨy jém Israelpɨc aŋjagooyiyaj. Nanɨcta̱ jém Jesús jém aŋjagooyi Pilato iwiñjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Jemum moj iquejajwadayyaj. Nɨ́mayt́a̱ jém Pilato: —Yɨ́p pɨ̱xiñ tsa̱m iccujíñayñe jém pɨxiñt́am jém it́yajwɨɨp yɨ́p naxyucmɨ. Nɨmpa iga d́a wɨ̱ tanyojpa jém impuesto para jém Romapɨc aŋjagooyi. Nɨmt́im iga je jém Cristo, tu̱m Rey. ");
INSERT INTO poiNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Jesɨc jém Pilato icwác jém Jesús. Nɨ́mayt́a̱: —¿Que mich miRey de jém judíos? Jesús icutsoŋ, iñɨ́máy: —Nu̱ma juuts mich miñɨm. ");
INSERT INTO poiNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Jesɨc Pilato iñɨ́máy jém pa̱nij aŋjagooyiyaj con jém aŋtuuma̱neyajwɨɨp je̱m: —D́a ampádáy ni tu̱m it́áŋca yɨ́p pɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pero jém pɨxiñt́am más pɨ̱mi jɨyyajpa. Nɨmyajpa: —Yɨ́bam tsa̱m icujíñayñe it́u̱mpɨy jém it́yajwɨɨp yɨ́p naxyucmɨ de Judea con jém iŋquímayooyi. Moj iŋmat jém iŋquímayooyi jém naxyucmɨ de Galilea. Sɨɨp núcneum hasta yɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Jesɨc cuando Pilato imatoŋ, acwágóypa. Nɨmpa: —¿Pero que yɨ́p tu̱m Galileapɨc pɨ̱xiñ? ");
INSERT INTO poiNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Cuando icutɨɨyɨ́y iga Galileapɨc pɨ̱xiñ, jesɨc jém Pilato ipɨɨmɨ́y iga nanɨcta̱iñ Jesús ju̱t́ it́ jém Herodes, jém Galileapɨc gobernador, porque noco it́ jém Herodes. Miññe jo̱yi Jerusalén. ");
INSERT INTO poiNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Jesɨc cuando jém Herodes iix Jesús, agui maymay. Dende pecam iixt́ooba porque imatoŋne iga wɨa̱p iwat jém milagro. Sɨɨp ixunpa jém Herodes iga iwad́iñ Jesús tu̱m milagro. ");
INSERT INTO poiNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Tsa̱m pɨ̱mi icwácpa jém Herodes, pero Jesús d́a icutsoŋpa. ");
INSERT INTO poiNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","It́t́im id́ɨc jém pa̱nij aŋjagooyiyaj con jém escribaspɨc maestroyaj. Pɨ̱mi iquejajwadayyajpa Jesús. ");
INSERT INTO poiNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Jesɨc jém Herodes con jém isoldado d́a iwɨ̱ixyajpa jém Jesús. Ixaayɨyyajpa, iccámayyajpa wɨbɨc puctu̱cu juuts tu̱m rey. Jesɨc e̱ybɨct́im nanɨcta̱ Jesús jém Pilatocɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Jesɨc jeet́im ja̱ma tsɨ́yyaj juuts amigo jém Herodes con jém Pilato, porque wiñt́i pɨ̱mi najóyixyajta̱p id́ɨc. ");
INSERT INTO poiNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Jesɨc jém Pilato iŋtuuma̱watpa jém co̱bacpɨc pa̱nij con jém aŋjagooyiyaj y jém pɨxiñt́am jém it́yajwɨɨp je̱m. ");
INSERT INTO poiNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Nɨmpa jém Pilato: —Mimicht́am anamíñayt́a yɨ́p pɨ̱xiñ. Miñɨmtámpa iga tsa̱m iccujíñayñe it́u̱mpɨy jém pɨxiñt́am jém it́yajwɨɨp yɨ́p attebet. Ɨch aŋwɨ̱cɨɨpiŋ. Sɨɨp íñixñeta iga d́a ampádáy it́áŋca t́iiga iŋquejajwadayñeta. ");
INSERT INTO poiNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Icɨɨpiŋt́im jém Herodes. D́at́im ipádáy it́áŋca porque e̱ybɨct́im acutsadáy yɨɨm. Tsa̱m wɨ̱quejpa iga d́a t́i mal iwatne, d́a wɨa̱p anacca. ");
INSERT INTO poiNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Sɨɨp anchiiba castigo, jesɨc aŋcutsɨgáypa. ");
INSERT INTO poiNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Jém Pilato siempre icutsɨgáypa tu̱m preso cuando naspa jém sɨŋ. Jém pɨxiñt́am wɨa̱p icupiŋ jup preso icutsɨgáypa. ");
INSERT INTO poiNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pero it́u̱mpɨy jém pɨxiñt́am, jém it́yajwɨɨp je̱m, pɨ̱mi jɨyyajpa. Nɨmyaj: —¡Acca̱ɨ yɨ́p pɨ̱xiñ! ¡Cutsɨgaayɨ jém Barrabás! ");
INSERT INTO poiNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Yɨ́pt́im Barrabás cotta̱ cárcel porque ictsucum tu̱m rebelión jém attebet Jerusalén y porque accaoyñe. ");
INSERT INTO poiNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Jém Pilato icutsɨgayt́ooba id́ɨc jém Jesús. E̱ybɨct́im iñɨ́máy jém pɨxiñt́am iga icutsɨgayt́ooba. ");
INSERT INTO poiNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pero jeeyaj más pɨ̱mi jɨyyajpa. Nɨmyajpa: —¡Cunuuntaamɨ cunusyucmɨ! ¡Cunuuntaamɨ cunusyucmɨ! ");
INSERT INTO poiNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Jesɨc e̱ybɨct́im jém Pilato iñɨ́máy jém pɨxiñt́am: —¿T́iiga? ¿T́i mal iwatne? Ɨch d́a ampádáy it́áŋca iga accaata̱iñ. Sɨɨp anchiiba castigo, jesɨc aŋcutsɨgáypa. ");
INSERT INTO poiNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pero más pɨ̱mi jɨyyajpa jém pɨxiñt́am. Nɨmyajpa iga cunúnta̱iñ cunusyucmɨ. Jesɨc jém Pilato imatóŋáy jeeyaj. ");
INSERT INTO poiNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Iwat juuts iwɨ̱aŋja̱myaj. ");
INSERT INTO poiNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Icutsɨgáy jém Barrabás jém cotneta̱wɨɨp id́ɨc cárcel porque tu̱m rebelde, tsa̱m accaóypa. Cutsɨgayt́a̱ juuts ixunyajpa jém pɨxiñt́am. Jém Pilato icɨɨjuŋcodáy Jesús jém malopɨc pɨxiñt́am icɨɨjo̱m iga imalwadayyajiñ juuts iwɨ̱aŋja̱myaj. ");
INSERT INTO poiNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Jesɨc nanɨcta̱ Jesús iga cunúnta̱p cunusyucmɨ. Iganam nɨquiyaj, jém soldado ipátyaj tu̱m pɨ̱xiñ iñɨ̱yi Ximoj. Cirenepɨc pɨ̱xiñ, se̱t́i id́ɨc ica̱mjo̱m. Matsta̱ jém Ximoj, accónte̱ñt́a̱ jém cunus. It́utsapacpa jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","It́úŋɨyyajpat́im tsa̱m jáyaŋ jém pɨxiñt́am. Nɨcyajpat́im jáyaŋ jém yo̱mtam. Pɨ̱mi wejyajpa jém yo̱mtam, aŋyácneyaj iga yaachwatta̱p jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Iámseedáy jém Jesús. Iñɨ́máy: —MiJerusalénpɨc miyo̱mtam, odoy anawejtaamɨ ɨch iga ayaachwatta̱p. Wejtaamɨ iga miyaachwattamta̱p mimicht́am con jém imma̱nɨctam. ");
INSERT INTO poiNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Porque miñpa jém ja̱ma iga nɨmyajpa: “Tsa̱m maymay jém yo̱mo jém d́apɨc ma̱nɨgɨ́y, jém d́apɨc ma̱nɨccomcane y jém d́apɨc ictsútspa tu̱m tsɨ̱xi.” ");
INSERT INTO poiNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Jesɨc jeet́im ja̱ma jém it́yajwɨɨp iñɨ́mayyajpa jém co̱tsɨc: “Acujécque̱tɨ.” Iñɨ́mayyajpat́im jém lumu: “Accucumque̱tɨ.” ");
INSERT INTO poiNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Nɨmt́im Jesús: —Siiga je̱mpɨgam iñasca jém tsococuy, ¿jesɨc t́i naspa con jém tɨtsnewɨɨp? ");
INSERT INTO poiNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Nanɨcta̱pt́im wɨste̱n malopɨc pɨ̱xiñ iga accaayajta̱p tu̱mt́i lugar con jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Jesɨc núcyaj tu̱m lumuyucmɨ, iñɨ̱yi jém Tsútsco̱bacpaccɨɨm. Jemum cunúnta̱ jém Jesús cunusyucmɨ. Cada lado cunúnyajta̱t́im jém wɨste̱n malopɨc pɨ̱xiñ, tu̱m jém iŋwɨ̱mɨ, tu̱m jém iŋna̱ymɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Iganam cunúnta̱p jém Jesús, iŋwejpát Dios. Iñɨ́máy: —ManJa̱tuŋ, wadaayɨ perdón yɨ́pyaj pɨxiñt́am porque d́a ijo̱doŋ t́i sɨ́p iwatyaj. Jém soldado iwécyaj jém Jesús ipuctu̱cu. Iwatyaj tu̱m sorteo i̱ icoñwɨ́ypa jém iyagatsyoot́i. ");
INSERT INTO poiNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Jém pɨxiñt́am jém it́yajwɨɨp je̱m, iámyajpa jém Jesús. Jém Israelpɨc aŋjagooyiyaj pɨ̱mi ixaayɨyyajpat́im. Nɨmyaj: —Yɨ́p pɨ̱xiñ nɨmpa iga wɨa̱p icɨacput tuŋgac pɨ̱xiñ. Jesɨc siiga nu̱ma je jém Cristo, jém icutsatnewɨɨp Dios, wɨ̱ iga nacɨacputta̱iñ iyaac. ");
INSERT INTO poiNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ixaayɨyyajpat́im jém soldado. Icunúc, ichi jém ca̱tsupɨc vino iga iuguiñ, pero Jesús d́a iuc. ");
INSERT INTO poiNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Jesɨc jém soldado iñɨ́mayyaj jém Jesús: —Siiga mimicham jém judíospɨc miRey, nacɨacputta̱jɨ iñyaac. ");
INSERT INTO poiNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Accámayt́a̱ tu̱m letrero ico̱bacaŋtɨcmɨ. Jayñe jém letrero tucute̱n aŋmat́i̱mɨ, jém griego, jém latín y jém hebreo. Yɨɨmpɨc nɨmpa: “Yɨ́bam jém judíos iRey.” ");
INSERT INTO poiNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Jesɨc tu̱m de jém wɨste̱n malopɨc pɨ̱xiñ, jém cunúnneta̱wɨɨp, pɨ̱mi imalnɨ́máy jém Jesús. Iñɨ́máy: —Siiga mich miCristo, nacɨacputta̱jɨ iñyaac. Acɨacputtaamɨt́im aɨcht́am. ");
INSERT INTO poiNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pero jém tuŋgac iwogáy it́ɨ̱wɨ. Iñɨ́máy: —¿Que mich d́a iŋcɨ̱ŋpa Dios? Sɨɨp tampɨctsoŋnet́im jexpɨct́im castigo. ");
INSERT INTO poiNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Taɨcht́am tanait́ razon iga tayaachwatta̱p porque sɨɨp tanyojpa jém tantáŋca. Pero yɨ́p pɨ̱xiñ d́a t́i mal iwatne. ");
INSERT INTO poiNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Nɨmt́im jém pɨ̱xiñ: —MiJesús, ajɨ̱sɨ cuando núcpa jém ja̱ma iga michɨ́ypa juuts aŋjagooyi. ");
INSERT INTO poiNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesɨc Jesús iñɨ́máy: —Nu̱ma mannɨ́máypa iga yɨ́pt́im ja̱ma nɨcpa tawagai̱t́i paraíso. ");
INSERT INTO poiNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Núc cugapja̱ma. Cupiicha̱ icuwɨ̱t́i yɨ́p naxyucmɨ. Pɨ̱mi piicha̱ hasta las tres de la tarde. ");
INSERT INTO poiNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Jém ja̱ma cupiicha̱ne. Jém mɨjpɨc ma̱stɨcjo̱m teeñaŋsajt́im jém puctuctaañi icuyagats. ");
INSERT INTO poiNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jesɨc Jesús pɨ̱mi jɨy. Nɨm: —ManJa̱tuŋ, maŋcɨɨjuŋcodáypa ána̱nama. Jesɨc yaj nɨ̱mi, caum jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Cuando jém Romapɨc capitán iix t́i iñasca, moj icujíp Dios. Nɨmpa: —Nu̱ma, yɨ́p tu̱m wɨbɨc pɨ̱xiñ. D́a t́i mal iwatne. ");
INSERT INTO poiNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","It́u̱mpɨy jém pɨxiñt́am, jém aŋtuuma̱neyajwɨɨp, cuando iixyaj t́i acnascata̱ jém Jesús, ixoŋyajpa ipecho porque pɨ̱mi aŋyácneyaj. Ocmɨ se̱tyajum it́ɨccɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Pero it́u̱mpɨy jém Jesús iamigoyaj con jém Galileapɨc yo̱mtam jém miññeyajwɨɨp con Jesús, tsɨ́yyaj juumɨ iganam iámyajpa t́i acnascata̱ jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Jesɨc it́t́im je̱m tu̱m wɨbɨc pɨ̱xiñ iñɨ̱yi José, Israelpɨc aŋjagooyit́im. Siempre iwatpa juuts ixunpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Sɨ́p iŋjóc jém ja̱ma iga Dios iŋjacpa yɨ́p naxyucmɨ. Jém pɨ̱xiñ tsucum jém attebet Arimatea, jém naxyucmɨ de Judea. Je d́a tɨgɨycúm con jém tuŋgac aŋjagooyiyaj cuando ijɨ̱syaj iga accaata̱p jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Jesɨc jém José nɨc iám jém Pilato. Iwágáy jém Jesús imɨjta̱y. ");
INSERT INTO poiNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Oy icquedáy jém imɨjta̱y jém cunusyucmɨ. Iŋmon con wɨbɨc puctu̱cu de lino. Icum tu̱m tsaajosjo̱m, watneta̱wɨɨp, ju̱t́ d́a i̱ queman icum tu̱m tsúts. ");
INSERT INTO poiNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Yɨ́pt́im ja̱ma jém Israelpɨc pɨxiñt́am iwatyajpa jém iwíccuy iga wɨa̱p ijejyaj jém jejcuyja̱ma. Jesɨc cuando cumta̱ jém Jesús, tsucumtooba jém jejcuy ja̱ma. ");
INSERT INTO poiNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Jém yo̱mtam, jém miññeyajwɨɨp de Galilea con Jesús, it́úŋɨyyaj jém José iga iámyajpa jém tsaajos y juuts cotneta̱ jém Jesús imɨjta̱y. ");
INSERT INTO poiNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Jesɨc jém yo̱mtam se̱tyaj it́ɨccɨɨm, iwɨ̱tsacyajpa jém poot́i jém cɨ̱npáppɨc y jém wɨbɨc pomada. Ocmɨ jejyajpa jém jejcuyja̱ma juuts nɨmpa jém aŋquímayooyi. ");
INSERT INTO poiNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Jesɨc jém wiñt́ipɨc ja̱ma de jém semana, tsa̱m tsúyt́im, nɨcgac jém yo̱mtam jém tsaajoscɨɨm. Ininɨcyaj jém poot́i cɨ̱npaap jém iwatnewɨɨp. Iwagananɨcyajt́im jém tuŋgac yo̱mtam. ");
INSERT INTO poiNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Cuando núcyaj jém tsaajoscɨɨm, iixyaj iga áŋáyñeum jém tsaajos. Aŋjoobayñeta̱wum jém jos aŋnúccuy. ");
INSERT INTO poiNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Tɨgɨyyaj jém yo̱mtam jém tsaajosjo̱m. D́am ipádáy jém tánO̱mi Jesús imɨjta̱y. ");
INSERT INTO poiNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Agui cɨ̱ŋyaj, d́a icutɨɨyɨ́y t́i nasne je̱m. Jesɨc iixyaj iga jemum te̱ñ wɨste̱n pɨ̱xiñ, agui tsocpa jém ipuctu̱cu. ");
INSERT INTO poiNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Tsa̱m pɨ̱mi ichɨgaŋjécyaj jém yo̱mtam, ámquetneyaj naxyucmɨ. Jesɨc jém sɨŋyucmɨpɨc pɨ̱xiñ iñɨ́máy jém yo̱mtam: —¿T́iiga miñ immétsta jém vivopɨc yɨɨm ju̱t́ cumneta̱ jém caaneyajwɨɨp? ");
INSERT INTO poiNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Je d́am i̱ yɨɨm. Acpɨsneta̱wum. Jɨ̱staamɨ juuts miñɨ́mayt́a cuando it́ id́ɨc jém Galilea. ");
INSERT INTO poiNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Miñɨ́máy iga jém Miññewɨɨp Sɨŋyucmɨ cɨɨjuŋcotta̱p jém malopɨc pɨxiñt́am icɨɨjo̱m, cunúnta̱p cunusyucmɨ, jesɨc jém tucunaja̱ma acpɨsta̱p. ");
INSERT INTO poiNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Jesɨc jém yo̱mtam ijɨ̱syajpa jém aŋma̱t́i juuts iñɨ́mayñe jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Jesɨc se̱tyaj jém yo̱mtam de jém tsaajos hasta ju̱t́ aŋtuuma̱neyaj jém once con jém tuŋgac jém Jesús icuyujcɨɨwiñ. Iŋmadayyaj t́i iixyaj. ");
INSERT INTO poiNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Sɨɨba jém Malía Magdalena, jém Xiwana y jém Malía jém Jacobo ia̱pa. Jeeyaj con jém tuŋgac más yo̱mtam iŋmadayyaj jém apóstolyaj t́i iixyaj jém tsaajosjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pero jém Jesús icuyujcɨɨwiñ ijɨ̱syaj iga mɨgooyi. D́a icupɨcyaj t́i iŋmadáy jém yo̱mtam. ");
INSERT INTO poiNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Jesɨc póyaŋtsucum jém Peto, nɨc jém tsaajoscɨɨm. Ámcúm jém tsaajosjo̱m, iix no más jém iŋmónóycuy, tsacneta̱ tu̱m áŋe̱ymɨ. Ocmɨ se̱t jém Peto. Agui tɨ̱neaŋjac, ijɨ̱spa ijɨ̱xiaŋjo̱m t́i nasne. ");
INSERT INTO poiNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Jesɨc jeet́im ja̱ma nɨcyajpa jém tɨgaŋjoj Emaús wɨste̱n jém Jesús icuyujcɨɨwiñ. Jém Emaús como once kilómetro ijuumɨ de jém Jerusalén. ");
INSERT INTO poiNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Iganam nɨquiyaj jém wɨste̱n icuyujcɨɨwiñ, sɨ́p iŋmatyaj t́i iñasca jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Iganam aŋmatyajpa jém wɨste̱n, jesɨgam núc Jesús ju̱t́ nɨquiyaj; mojum iwagananɨcyaj. ");
INSERT INTO poiNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Dios d́a ijɨ́cpa iga iixpɨguiñ jém icuyujcɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesɨc Jesús moj icwác jém wɨste̱n, iñɨ́máy: —¿T́i sɨɨp iniŋmatta iganam miñɨquit́am tuŋjo̱m? ¿T́iiga miŋyácneta? ");
INSERT INTO poiNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Tu̱m de jeeyaj, iñɨ̱yi Cleofas, icutsoŋ. Iñɨ́máy: —¿Mioy Jerusalén y d́a iñjo̱doŋ t́i nasne jemɨc? ¿Que juumɨpɨc mipɨ̱xiñ? ");
INSERT INTO poiNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jesɨc Jesús iñɨ́máy jém pɨ̱xiñ: —¿T́i nasne jemɨc? Nɨmpa jém Cleofas: —Tsa̱m jáyaŋ cosa iñasca jém Jesús jém Nazaretpɨc pɨ̱xiñ. Je tu̱m profeta tsa̱m wɨa̱p, agui wɨa̱pt́im iŋmat jém Dios iwiñjo̱m. It́u̱mpɨy jém pɨxiñt́am tsa̱m iwɨ̱ixyajpat́im. ");
INSERT INTO poiNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Pero jém co̱bacpɨc pa̱nijyaj con jém aɨcht́ampɨc anaŋjagooyiyaj icɨɨjuŋcotyaj jém Jesús jém Romapɨc aŋjagooyi icɨɨjo̱m iga accaata̱iñ. Jemum cunúnta̱ cunusyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ɨcht́am anjɨ̱stámpa id́ɨc iga jém Jesús wɨa̱p tacɨacputta taɨcht́am jém taIsraelpɨc tapɨxiñt́am. Sɨɨp nasneum tucunaja̱ma iga accaata̱. ");
INSERT INTO poiNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Jute̱n de jém aɨcht́ampɨc yo̱mtam oy iámyaj jém tsaajos tsúyt́im. Agui atsɨgaŋjécta, ");
INSERT INTO poiNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","porque aŋmadayyaj iga d́am i̱ jém tsúts jém tsaajosjo̱m. Anɨ́mayt́a iga iixyaj wɨste̱n sɨŋyucmɨpɨc pɨ̱xiñ. Nɨmpat́im jém yo̱mtam iga aŋmadayt́a̱t́im iga pɨsneum jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Algunos de aɨcht́am oy iámyaj jém tsaajos. Nu̱ma iixyaj jém cosa juuts nɨm jém yo̱mtam. Pero d́a iixyaj jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jesɨc Jesús iñɨ́máy jém wɨste̱n icuyujcɨɨwiñ: —Odoy cuɨ̱xataamɨ. Agui mijɨ̱xicumoŋneta iga d́a iŋcupɨctámpa it́u̱mpɨy juuts ijaychacneyaj jém wiñɨcpɨc profeta. ");
INSERT INTO poiNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Que d́a iñjɨ̱spa iga yaachwatta̱p jém Cristo y ocmɨ químpa sɨŋyucmɨ? ");
INSERT INTO poiNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Jesɨc jém Jesús moj iŋquejáy jém Dios iŋma̱t́i jém ijaychacnewɨɨp jém Moisés y jém wiñɨcpɨc profetayaj. Iŋquejáypa it́u̱mpɨy ju̱t́ jaychacneta̱ de jém Cristo. ");
INSERT INTO poiNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Jesɨc núcyajum jém wɨste̱n icuyujcɨɨwiñ jém tɨgaŋjoj ju̱t́ nɨcyajpa. Iŋja̱myajpa iga jém Jesús nɨcpanam más juumɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Jesɨc jém icuyujcɨɨwiñ iñɨ́mayyaj Jesús iga tsɨ́yiñ con jeeyaj. Nɨ́mayt́a̱: —Tsɨɨyɨm yɨɨm con aɨcht́am porque tsuuyɨm, piicha̱bam i̱t́i. Jesɨc jemum tsɨ́y jém Jesús con jeeyaj. ");
INSERT INTO poiNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Wagaco̱ñyajum mesacɨɨm. Ipɨc Jesús tu̱m caxt́ána̱ñi, moj iŋwejpát Dios. Ocmɨ iwéc jém caxt́ána̱ñi con jém wɨste̱n icuyujcɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Jesɨc Dios ijɨ́gáy jém wɨste̱n iga iixpɨguiñ jém Jesús. Pero jeet́i rato coñt́ogoy, d́a iixyaj ju̱t́ iɨŋ. ");
INSERT INTO poiNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Jesɨc nacwácyajta̱p jeeyaj. Nɨmpa: —¿Que d́a iñjɨ̱spa iga agui imatspa tána̱nama cuando taŋmadáypa tuŋjo̱m y cuando taŋquejáypa jém Dios iŋma̱t́i? ");
INSERT INTO poiNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Jesɨc jeet́i rato se̱tyaj jém wɨste̱n Jerusalén. Tɨgɨy jém tɨcjo̱m ju̱t́ aŋtuuma̱neyaj jém once con jém tuŋgac jém Jesús icuyujcɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Nɨ́mayyajta̱ jém oyñewɨɨp jém Emaús. —Nu̱ma, pɨsneum jém tánO̱mi. Dios icpɨs. Jém Peto iixñe. ");
INSERT INTO poiNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Jesɨc jém wɨste̱n iŋmatyajt́im t́i iñascayaj tuŋjo̱m y jutsa̱ miixpɨcyaj jém Jesús cuando iwécpa jém caxt́ána̱ñi. ");
INSERT INTO poiNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Iganam sɨ́p iŋmatyaj jém icuyujcɨɨwiñ, jesɨgam núc jém Jesús, iwiñquejáy ju̱t́ aŋtuuma̱neyaj. Idioschi jeeyaj, iñɨ́máy: —Xutsóyt́am. ");
INSERT INTO poiNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Pero jeeyaj agui aŋjécyaj, cɨ̱ŋyaj. Ijɨ̱syaj iga iixyaj tu̱m a̱nama. ");
INSERT INTO poiNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Jesɨc Jesús iñɨ́máy: —¿T́iiga miŋjécneta? ¿T́iiga iniit́t́a jexpɨc jɨ̱xi íña̱namaŋjo̱m? ");
INSERT INTO poiNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Aámaayɨ jém aŋcɨ y ampuy. Ɨcham aJesús. Atsɨctaamɨ iga iŋcutɨɨyɨyt́ámiñ iga d́a je aa̱nama. Porque tu̱m a̱nama d́a maayɨ́y ni d́a pagɨ́y juuts ɨch anait́. ");
INSERT INTO poiNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Iganam iŋmadáy jém icuyujcɨɨwiñ, iŋquejáy icɨ y ipuy. ");
INSERT INTO poiNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Agui maymayyaj jém icuyujcɨɨwiñ. Como d́anam iwɨ̱cupɨcne, agui tɨ̱neaŋjacyaj. Jesɨc Jesús iñɨ́máy jém icuyujcɨɨwiñ: —¿Iniit́t́a uxaŋ wíccuy iga aŋcɨɨspa? ");
INSERT INTO poiNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Jesɨc chiit́a̱ tu̱m ja̱ca tɨɨpɨ jaasnewɨɨp. Chiit́a̱t́im tu̱m ja̱ca chi̱ñu con iña̱yi. ");
INSERT INTO poiNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ipɨctsoŋ jém Jesús. Moj icɨɨs. ");
INSERT INTO poiNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ocmɨ iñɨ́máy: —Sɨɨp accupacneta̱wum jém aŋma̱t́i jém mannɨ́mayñewɨɨp cuando ait́ id́ɨc con mimicht́am. Mannɨ́mayñe iga tienes que anaccupacpa it́u̱mpɨy juuts ajaychagayñe jém Moisés, jém wiñɨcpɨc profetayaj y jém Salmojo̱m. ");
INSERT INTO poiNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Jesɨc jém Jesús ichi jɨ̱xi jém icuyujcɨɨwiñ iga wɨa̱iñ icutɨɨyɨyyaj jém Dios iŋma̱t́i jém jayñewɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Jesús iñɨ́máy jém icuyujcɨɨwiñ: —Jém wiñɨcpɨc aŋmat́cɨɨwiñ ijaychacne iga tienes que accaata̱p jém Cristo jém icutsatnewɨɨp Dios. Ocmɨ acpɨsta̱p jém tucunaja̱ma de ju̱t́ it́ jém caaneyajwɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Jesɨc yɨ́pt́im Cristo icutsatpa jém icuyujcɨɨwiñ iga iŋmadayyajiñ jém pɨxiñt́am jém wɨbɨc aŋquímayooyi. Mojpa iŋmatyaj jém attebet Jerusalén. Ocmɨ núcpa yɨ́p aŋma̱t́i it́u̱mpɨy jém naciónyaj icuwɨ̱t́i jém naxyucmɨ. Aŋmadayyajta̱p jém malopɨc pɨxiñt́am iga icucaguiñ jém ijɨ̱xi d́apɨc wɨ̱. Cuando cucacum ijɨ̱xi, jesɨc Dios iccáyáypa jém it́áŋca. ");
INSERT INTO poiNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Mimicht́am wɨa̱p iniŋmadayt́a jém pɨxiñt́am porque íñixñeta t́i annascane. ");
INSERT INTO poiNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","¡Matoŋtaamɨ! Maŋcutsadáypa jém Dios ipɨ̱mi juuts mijɨycámayñe anJa̱tuŋ Dios. Jesɨc tsɨ́yt́aamɨ yɨ́p attebet Jerusalén hasta impɨctsoŋtámpa jém sɨŋyucmɨpɨc pɨ̱mi. ");
INSERT INTO poiNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jesɨc Jesús ininɨc jém icuyujcɨɨwiñ hasta jém tɨgaŋjoj Betania. Icquím icɨ, iŋwejpátpa Dios iga iwɨ̱wadáyiñ jém icuyujcɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Jesɨc yajum iŋwejpát Dios, nɨc Jesús. Nanɨcta̱ sɨŋyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Co̱ste̱ñyaj jém icuyujcɨɨwiñ iga ijɨ̱syajpa Jesús. Ocmɨ se̱tyajum Jerusalén. Agui pɨ̱mi maymayyaj. ");
INSERT INTO poiNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Seguido wagait́yaj jém mɨjpɨc ma̱stɨcjo̱m. Icujípyajpa Dios. Jemum cuyaj.");
INSERT INTO poiNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Wiñɨgam cuando moj i̱t́i it́u̱mpɨy cosa, jesɨc it́t́im id́ɨc jém Dios iMa̱nɨc, iñɨ̱yit́im jém Aŋma̱t́i. Jém Dios iMa̱nɨc iwaganait́ tanJa̱tuŋ Dios. Jém Dios iMa̱nɨc jeet́im jém Dios. ");
INSERT INTO poiNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Cuando moj i̱t́i it́u̱mpɨy cosa, jesɨc jém Dios iMa̱nɨc iwaganait́ jém tanJa̱tuŋ Dios. ");
INSERT INTO poiNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Wagayo̱xayaj iga iwatyajpa it́u̱mpɨy cosa. D́a i̱ ni tu̱m cosa d́apɨc je iwa̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Je iniit́ jém vida iga tachiiba. Jém vida je jém juctɨ jém tsocpáppɨc jém pɨxiñt́am ia̱namaŋjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Tsocpa jém juctɨ piichcɨɨm y jém piichɨ d́a wɨa̱p icpích jém juctɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","It́ id́ɨc tu̱m pɨ̱xiñ jém icutsatnewɨɨp Dios, iñɨ̱yi Xiwan. ");
INSERT INTO poiNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Cutsatta̱ jém Xiwan iga iŋmadáyiñ jém pɨxiñt́am iga miñpa jém Dios iMa̱nɨc juuts tu̱m juctɨ. Oy iŋmadáy jém pɨxiñt́am i̱apaap jém miñpáppɨc iga icupɨcyajiñ cuando miñpa. ");
INSERT INTO poiNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jém Xiwan d́a je jém juctɨ, pero oy iŋmadáy jém pɨxiñt́am i̱apaap jém juctɨ jém miñpáppɨc. ");
INSERT INTO poiNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Je jém nu̱mapɨc juctɨ. Miñ yɨ́p naxyucmɨ iga iyɨcquejyajpa it́u̱mpɨy jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Oy i̱t́i yɨ́p naxyucmɨ. Iwaganayo̱xa̱ jém tanJa̱tuŋ Dios iga iwatyaj yɨ́p nas con it́u̱mpɨy jém it́wɨɨp yɨɨm, pero jém pɨxiñt́am, yɨ́p naxyucmɨpɨc, d́a iixpɨcyaj jém Dios iMa̱nɨc. ");
INSERT INTO poiNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Oy i̱t́i it́ɨcmɨ, jém naxyucmɨ de Israel, pero jeeyaj d́a ipɨctsoŋyaj. ");
INSERT INTO poiNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pero jém ipɨctsoŋneyajwɨɨp, jém icupɨcneyajwɨɨp, chiiyajta̱ derecho iga tsɨ́yyajiñ juuts jém Dios ima̱nɨctam. ");
INSERT INTO poiNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","D́a jex juuts tu̱m pɨ̱xiñ ima̱nɨc jém iwatnewɨɨp yo̱myucmɨ, juuts iwɨ̱aŋja̱m jém ja̱tuŋpɨc, pero Dios ima̱nɨga̱yajpa. Tsɨ́yyaj juuts Dios ima̱nɨctam. ");
INSERT INTO poiNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Oy i̱t́i yɨ́p naxyucmɨ jém Dios iMa̱nɨc juuts tu̱m pɨ̱xiñ. Maayɨ́yt́im juuts taɨcht́am. Oy i̱t́i yɨ́p naxyucmɨ con aɨcht́am. Ánixayñeta iga inimiñ jém ipɨ̱mi jém iJa̱tuŋpɨc ichiiñe jém t́u̱mpɨc iMa̱nɨc. Jém Dios iMa̱nɨc tsa̱m tóyóypa, siempre nuumaŋmatpa, d́a mɨgóypa. ");
INSERT INTO poiNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jém Xiwan oy iŋmadáy jém pɨxiñt́am i̱apaap jém miññewɨɨp. Nɨm jém Xiwan: —Yɨ́bam jém mannɨ́mayñewɨɨp iga ocmɨm miñpa tu̱m pɨ̱xiñ más wɨa̱p que aɨch porque it́t́im id́ɨc dende wiñɨgam cuando d́anam anayñe aɨch. ");
INSERT INTO poiNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Jém Dios iMa̱nɨc tsa̱m tawɨ̱wadayñeta tantu̱mpɨyt́am. Tsa̱m tawɨ̱it́t́a porque inimiñ jém wɨbɨc tóyooyi iga tayaachaŋja̱mtámiñ Dios. ");
INSERT INTO poiNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Chiit́a̱ jém Moisés jém wiñɨcpɨc aŋquímayooyi iga aŋmadayyajta̱iñ jém pɨxiñt́am. Jesɨc ocmɨ jém Jesucristo oy yɨ́p naxyucmɨ iga taŋquejáy jutsa̱p tayaachaŋja̱mta Dios y iga taŋquejáypa jém nu̱mapɨc aŋquímayooyi. ");
INSERT INTO poiNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","D́a i̱ queman oypa iix jém tanJa̱tuŋ Dios; pero jém Dios iMa̱nɨc, jém t́u̱mpɨc, jém iwaganait́wɨɨp Dios, taŋquejayt́a juutspɨc Dios jém tanJa̱tuŋ Dios. ");
INSERT INTO poiNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Algunos jém judíos, jém it́yajwɨɨp jém Jerusalén, icutsatyaj jém pa̱nijyaj con jém levitapɨc pɨxiñt́am iga icwácyajiñ jém Xiwan. Nɨ́mayt́a̱: —Nɨ̱gɨ acwaacɨ jém Xiwan: “¿Mich, mii̱apaap?” ");
INSERT INTO poiNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Jesɨc cuando núcyaj ju̱t́ it́ jém Xiwan, je d́a iŋyam. Iñɨ́máy jeeyaj: —Ɨch d́a je aCristo jém acutsatnewɨɨp Dios. ");
INSERT INTO poiNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Jesɨc nɨmyaj jém pa̱nijyaj: —¿Jesɨc mii̱apaap? ¿Que mich jém miElías jém wiñɨcpɨc miprofeta? Pero jém Xiwan icutsoŋ. Iñɨ́máy: —Ɨch d́a aje. Nɨmyaj jém pa̱nijyaj: —¿Que mich jém miprofeta jém manaŋjóctampaap? Jém Xiwan iñɨ́máy: —Ɨch d́at́im aje. ");
INSERT INTO poiNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Jesɨc jém pa̱nijyaj iñɨ́mayyaj jém Xiwan: —¿Mich, mii̱apaap? Anɨ́maayɨ iga wɨa̱iñ anaŋmadayt́a jém acutsatnewɨɨp. ¿Mich iñyaac, t́i wɨa̱p anaŋmadáy? ");
INSERT INTO poiNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jesɨc jém Xiwan iñɨ́máy jém pa̱nijyaj: —Ɨcham oy anajɨ́yooyi jém tɨtsɨnaxyucmɨ. Oy anaŋmadáy jém pɨxiñt́am iga: “Áŋaayɨ jém tuŋ, nu̱mtsa̱cɨ, porque miñpa jém tánO̱mi”, juuts nɨmpa jém profeta jém Isaías. ");
INSERT INTO poiNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Jém fariseoyaj icutsatyajt́im jém icwácyajpáppɨc jém Xiwan. ");
INSERT INTO poiNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Acwácta̱t́im jém Xiwan, nɨ́mayt́a̱: —¿Jesɨc t́iiga micchíŋóypa siiga mich d́a je miCristo, ni d́a je miElías ni d́a je miprofeta jém miñpáppɨc? ");
INSERT INTO poiNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jém Xiwan iñɨ́máy jeeyaj: —Ɨch acchíŋóypa con nɨ. Pero yɨɨm it́ mimicht́ámaŋjo̱m tu̱m pɨ̱xiñ jém d́apɨc íñixpɨcneta. ");
INSERT INTO poiNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ocmɨm miñ jém pɨ̱xiñ, pero más wɨa̱p que aɨch. Ɨch d́a wɨa̱p antsɨ́y ni juuts tu̱m imozo iga aŋcuwijáyáypa jém icɨac. ");
INSERT INTO poiNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Je̱mpɨgam iñasca jém Xiwan jém attebet Betábara, aŋwiñt́uc de jém río Jordán ju̱t́ acchíŋóypa. ");
INSERT INTO poiNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Jém tuŋgac ja̱ma jém Xiwan iix iga miñpa Jesús, iñɨ́máy jém pɨxiñt́am: —I̱xɨ, jém pɨ̱xiñ jeexɨc miñpa, je jém Dios iCordero. Accaata̱p iga iccáyáypa it́u̱mpɨy jém pɨxiñt́am it́áŋca. ");
INSERT INTO poiNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Yɨ́bam jém pɨ̱xiñ jém mannɨ́mayñewɨɨp iga: “Ocmɨm miñpa tu̱m pɨ̱xiñ, pero más wɨa̱p que aɨch, porque it́t́im dende wiñɨgam cuando d́anam anayñe aɨch.” ");
INSERT INTO poiNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ɨch d́a id́ɨc anjo̱doŋ i̱apaap jém pɨ̱xiñ, pero ɨch miñ acchíŋooyi con nɨ iga jém it́yajwɨɨp Israel wɨa̱iñ ijo̱dóŋa̱yaj i̱apaap jém Cristo. ");
INSERT INTO poiNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Nɨmt́im jém Xiwan: —Ɨch ánix jém Dios iA̱nama juuts tu̱m cuucu cuando quet dende sɨŋyucmɨ. Miñ i̱t́i con je. ");
INSERT INTO poiNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Jesɨc ɨch d́a id́ɨc anjo̱doŋ i̱apaap jém pɨ̱xiñ jém miñpáppɨc, pero cuando Dios acutsat iga acchíŋóypa con nɨ, anɨ́máy iga: “Cuando íñixpa iga jém Dios iA̱nama quetpa sɨŋyucmɨ y miñ i̱t́i con tu̱m pɨ̱xiñ, jesɨc iñjo̱doŋ iga jeam jém iniŋjócpáppɨc. Acchíŋóypat́im mex je con jém Dios iA̱nama, d́a je con nɨ.” ");
INSERT INTO poiNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ɨch ánix iga je̱mpɨgam iñasca yɨ́p pɨ̱xiñ, jeeyucmɨ wɨa̱p mannɨ́máy iga yɨ́bam pɨ̱xiñ jém Dios iMa̱nɨc. ");
INSERT INTO poiNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Jesɨc tuŋgagam ja̱ma je̱mt́im it́yaj jém Xiwan con wɨste̱n jém icuyujcɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Iix jém Xiwan iga wid́aŋnaspa jém Jesús. Jesɨc iñɨ́máy jém icuyujcɨɨwiñ: —Ixt́aamɨ jém pɨ̱xiñ. Yɨ́bam jém Dios iCordero. ");
INSERT INTO poiNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Jesɨc jém wɨste̱n icuyujcɨɨwiñ imatoŋ t́i iñɨ́máy, moj it́úŋɨ́y jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesɨc Jesús iámseedáy, iix iga it́úŋɨ́ypa jém wɨste̱n, iñɨ́máy: —¿T́i miñ immétsta? Nɨmyaj jém wɨste̱n: —¿Rabí, (taɨcht́am tanaŋmat́i̱mɨ nɨmtooba, Maestro), ju̱t́ miit́? ");
INSERT INTO poiNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesɨc Jesús iñɨ́máy jeeyaj: —Mi̱ñɨ aamɨ. Jesɨc nɨc iámyaj ju̱t́ it́ Jesús. Jemum iyaj jém ja̱ma, núcyaj a las cuatro. ");
INSERT INTO poiNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Tu̱m de jém wɨste̱n jém imatoŋneyajwɨɨp junɨmpa jém Xiwan, jém it́úŋɨywɨɨp jém Jesús, iñɨ̱yi Anti. It́ɨ̱wɨ jém Ximoj Peto. ");
INSERT INTO poiNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Jesɨc jém Anti wiñt́i nɨc iméts it́ɨ̱wɨ jém Ximoj, iñɨ́máy: —Ampátneum jém Mesías. (Taɨcht́am tanaŋmat́i̱mɨ nɨmtooba jém Cristo.) ");
INSERT INTO poiNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ocmɨ jém Anti ininɨc jém Ximoj ju̱t́ it́ Jesús. Jesɨc Jesús iwɨ̱ámpa jém Ximoj, iñɨ́máy: —Mich miXimoj, jém Jonás mima̱nɨc, pero sɨɨp manacnɨɨya̱p iga miCefas. (Taɨcht́am tanaŋmat́i̱mɨ nɨmtooba iga Peto.) ");
INSERT INTO poiNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Jesɨc tuŋgagam ja̱ma nɨctooba id́ɨc Jesús jém naxyucmɨ de Galilea. Ipát jém Felipe. Nɨ́mayt́a̱: —Mi̱ñɨ atúŋɨɨyɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Yɨ́p Felipe jém Betsaidapɨc pɨ̱xiñ, jeet́im attebet ju̱t́ tsucum jém Anti y Peto. ");
INSERT INTO poiNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Jesɨc jém Felipe nɨc iméts jém Natanael, iñɨ́máy: —Ampátneta jém pɨ̱xiñ jém tanɨ́mayñewɨɨp iga miñpa jém Moisés y jém tuŋgac jém wiñɨcpɨc profeta jém ijayñewɨɨp Dios iŋma̱t́i. Je jém Jesús, jém Nazaretpɨc, jém José ima̱nɨc. ");
INSERT INTO poiNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nɨmpa jém Natanael: —¿Que wɨa̱p iput tu̱m wɨbɨc pɨ̱xiñ de jém attebet de Nazaret? Nɨmpa Felipe: —Mi̱ñɨ aamɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Cuando Jesús iix iga icunúcpa jém Natanael, iñɨ́máy: —Yɨɨm miñpa tu̱m nunta Israelpɨc pɨ̱xiñ, jém d́apɨc inii̱ mɨgooyi. ");
INSERT INTO poiNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Jesɨc jém Natanael icwác jém Jesús, iñɨ́máy: —¿Jutsa̱ mánixpɨc? Nɨmpa Jesús: —Antes que d́anam miŋwejayñe jém Felipe, mánix ju̱t́ miit́ jém tsujcucɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Jesɨc jém Natanael iñɨ́máy jém Jesús: —Rabí, micham jém Dios miMa̱nɨc. Micham miRey de Israel. ");
INSERT INTO poiNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesɨc Jesús icutsoŋ, iñɨ́máy: —Sɨɨp mich aŋcupɨcpa porque mannɨ́máy iga mánixñe jém tsujcucɨɨm. Núcpa ja̱ma iga íñixpa jém más mɨjpɨc milagro. ");
INSERT INTO poiNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Nu̱ma mannɨ́máypa iga íñixt́ámpa iga áŋáypa jém sɨŋ y químpa y quetpa jém sɨŋyucmɨpɨc pɨxiñt́am aɨchyucmɨ, jém aMiññewɨɨp Sɨŋyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ocmɨ nas tucunaja̱ma, it́ tu̱m aŋcoomɨ́yóycuy jém attebet de Caná jém naxyucmɨ de Galilea, it́t́im jém Jesús ia̱pa. ");
INSERT INTO poiNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Aŋwejayyajta̱t́im jém Jesús con icuyujcɨɨwiñ iga nɨguiñ ju̱t́ it́ jém aŋcoomɨ́yóycuy. ");
INSERT INTO poiNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Yaj jém vino, jesɨc Jesús ia̱pa iñɨ́máy: —Sɨɨp yajneum jém vino. ");
INSERT INTO poiNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesɨc jém Jesús iñɨ́máy: —Yo̱mo, ¿t́iiga annɨ́máy iga yajneum jém vino? D́anam núcne jém hora iga aŋwatpa jém milagro. ");
INSERT INTO poiNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Jesɨc jém Jesús ia̱pa iñɨ́máy jém icuyo̱xayajpaap jém tɨc io̱mi: —Wattaamɨ it́u̱mpɨy juuts miñɨ́máypa. ");
INSERT INTO poiNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Jemum it́ seis jém tsaamajcuy. Cucómayñeta̱ nɨ iga icheeyajpa icɨ juuts jém judíos icostumbre. Cada jém majcuy iyajpa ochenta o cien litro de nɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesɨc Jesús iñɨ́máy jém mozo: —Comtaamɨ yɨ́pyaj majcuy con nɨ. Jesɨc moj icomyaj jém seis majcuy hasta wɨ̱ com. ");
INSERT INTO poiNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Jesɨc Jesús iñɨ́máy jém mozo: —Sɨɨp to̱pɨ uxaŋ, nɨ̱gɨ chi̱ɨ jém mayordomo de jém sɨŋ. Je̱mpɨgam iwatyaj. ");
INSERT INTO poiNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Jesɨc jém mayordomo iuc uxaŋ jém nɨ jém acse̱tneta̱wɨɨp iga vino, pero d́a ijo̱doŋ ju̱t́ ipɨcyaj jém vino. Pero jém mozo, jém it́opneyajwɨɨp jém nɨ, ijo̱doŋ ju̱t́ ipɨc jém vino. Jesɨc jém mayordomo iŋwejáy jém pɨ̱xiñ jém yoomɨypaap. ");
INSERT INTO poiNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Iñɨ́máy: —Jesɨc nawatta̱p sɨŋ, it́u̱mpɨy ichiiba wiñt́i jém más wɨbɨc vino iga iuguiñ jém iamigoyaj. Jesɨc ocmɨ cuando iucneyajum jáyaŋ jém wɨbɨc vino, jesɨc chiiyajta̱p jém vino d́apɨc ja̱ya wɨ̱. Pero mich iniccáyñe jém más wɨbɨc vino hasta sɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Je̱mpam moj iwat Jesús jém milagro jém attebet de Caná, jém naxyucmɨ de Galilea. Aŋquejayyajta̱ jém pɨxiñt́am iga iniit́ jém Dios ipɨ̱mi. Jém icuyujcɨɨwiñ tsa̱m icupɨcyaj jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Jesɨc ocmɨm, nɨc Jesús jém attebet Capernaum. Iwagananɨcyaj ia̱pa, it́ɨ̱wɨtam y jém icuyujcɨɨwiñ. Pero jemum d́a wa̱t́ña ja̱ma tsɨ́yyaj. ");
INSERT INTO poiNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Jesɨc jeet́im tiempo núctooba jém pascuasɨŋ jém iwatyajpáppɨc jém judíos. Nɨc Jesús Jerusalén ju̱t́ iwatyajpa jém sɨŋ. ");
INSERT INTO poiNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Y jém mɨjpɨc ma̱stɨcjo̱m ipát jém imáyyajpáppɨc jém xix, jém borrego y jém cuucuyaj. Jemum co̱ñyajt́im imesacɨɨm jém icucacyajpáppɨc tumiñ. ");
INSERT INTO poiNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jesɨc Jesús ipɨc tu̱m tɨpxi, iwat tu̱m cótsóycuy. Iquebacput it́u̱mpɨy jém pɨxiñt́am jém it́wɨɨp ma̱stɨcjo̱m con jém xixyaj y jém borregoyaj. Ipatspatsquedáy it́umiñ naxyucmɨ jém icucacyajpáppɨc tumiñ. Ichiputseedáy jém imesayaj. ");
INSERT INTO poiNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Iñɨ́máy jém pɨxiñt́am jém imáyyajpaap jém cuucuyaj: —Toptaamɨ jém cuucuyaj aŋsɨ̱cmɨ. Odoy acse̱ttaamɨ anJa̱tuŋ it́ɨc juuts tu̱m mercado. ");
INSERT INTO poiNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jesɨc jém Jesús icuyujcɨɨwiñ ijɨ̱syajpa juuts jayñeta̱ jém Dios iŋma̱t́i. Nɨmpa: “Ɨch tsa̱m pɨ̱mi aŋwatpa cuenta mich iñt́ɨc, manJa̱tuŋ Dios.” ");
INSERT INTO poiNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Jesɨc jém judíos icwácyajpa. Nɨ́mayt́a̱ Jesús: —¿I̱ mipɨɨmɨ́y iga iŋquebacput jém pɨxiñt́am? Siiga Dios mipɨɨmɨ́y, jesɨc aŋquejaayɨ aɨcht́am tu̱m milagro. ");
INSERT INTO poiNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesús iñɨ́máy jeeyaj: —Mɨswattaamɨ yɨ́p ma̱stɨc, jesɨc jém tucunaja̱ma anactsucumpa e̱ybɨc. ");
INSERT INTO poiNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Nɨmyaj jém judíos: —Cuarenta y seis a̱mt́ɨy yo̱xayaj iga iwatyaj yɨ́p ma̱stɨc. ¿Que wɨa̱p inictsucum en tucunaja̱ma? ");
INSERT INTO poiNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pero cuando nɨmpa Jesús iga iwatpa e̱ybɨc jém ma̱stɨc, je iŋmatpa de jém imɨjta̱y. ");
INSERT INTO poiNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Cuando accaata̱p jém Jesús y ocmɨ pɨspa, jesɨc jém icuyujcɨɨwiñ ijɨ̱syajpa t́i iñɨ́máy jém Jesús. Jesɨc icupɨcyaj jém Dios iŋma̱t́i jém jayñeta̱wɨɨp y jém iŋma̱t́i jém iñɨ́mayñewɨɨp jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jesɨc iganam it́ Jesús jém Jerusalén, cuando iwatyajpa jém pascuasɨŋ, jáyaŋ jém pɨxiñt́am moj icupɨcyaj porque iixyaj jém wɨbɨc milagro jém iwatnewɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pero jém Jesús d́a inii̱ayyaj confianza jém pɨxiñt́am, porque ijo̱doŋ t́i iniit́yaj ia̱namaŋjo̱m it́u̱mpɨy jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","D́a ixunpa Jesús iga i̱ iŋmadáypa iga tsa̱m malo jém pɨxiñt́am, porque ijo̱doŋ iga tsa̱m it́ mal ia̱namaŋjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","It́ id́ɨc tu̱m fariseopɨc pɨ̱xiñ iñɨ̱yi Nicodemo, aŋjagooyi de jém judíos. ");
INSERT INTO poiNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Jém Nicodemo oy iám jém Jesús tsuucɨɨm. Mu iñúc, iñɨ́máy: —MamMaestro, anjo̱dóŋa̱ta iga Dios micutsat iga anaŋquejayt́ámiñ aɨcht́am. D́a i̱ wɨa̱p iwat jém wɨbɨc milagro juutspɨc mich iŋwatpa siiga d́a iŋwaganait́ Dios. ");
INSERT INTO poiNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesɨc Jesús iñɨ́máy jém Nicodemo: —Nu̱ma mannɨ́máypa siiga tu̱m pɨ̱xiñ d́a nayxe̱tpa e̱ybɨc, jesɨc d́a tsɨ́ypa juuts Dios imɨɨchi ni d́a nɨcpa i̱t́i con Dios. ");
INSERT INTO poiNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Jém Nicodemo icwác jém Jesús. Iñɨ́máy: —¿Pero jutsa̱p iñayxe̱t tu̱m pɨ̱xiñ tsa̱mipɨc? ¿Que wɨa̱p it́ɨgɨy e̱ybɨc jém ia̱pa ipuujo̱m iga nayxe̱tpa? ");
INSERT INTO poiNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesús icutsoŋ jém Nicodemo. Iñɨ́máy: —Nu̱ma mannɨ́máypa siiga tu̱m pɨ̱xiñ d́a naypa con nɨ y d́a naypat́im con Dios iA̱nama, d́a tsɨ́ypa juuts Dios imɨɨchi ni d́a wɨa̱p it́ɨgɨy ju̱t́ it́ Dios. ");
INSERT INTO poiNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Jém nayñewɨɨp jém yo̱myucmɨ iniit́ no más jém vida yɨ́p naxyucmɨ. Pero jém nayñewɨɨp con Dios iA̱nama iniit́ jém sɨŋyucmɨpɨc vida. ");
INSERT INTO poiNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Odoy ámaŋja̱cɨ iga mannɨ́máy iga siiga d́a miñayxe̱tpa e̱ybɨc d́a miñúcpa ju̱t́ it́ Dios. ");
INSERT INTO poiNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Poypa jém sa̱wa ju̱t́ quej. Tammatoŋpa iga poypa jém sa̱wa, pero d́a tanjo̱doŋ ju̱t́ miñpa ni ju̱t́ nɨcpa. Jesa̱pt́im quejpa iga nayñe jém pɨ̱xiñ con Dios iA̱nama. Pero d́a tánixpa jutsa̱ miñay. ");
INSERT INTO poiNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Jesɨc jém Nicodemo iñɨ́máy jém Jesús: —¿Pero que jutsa̱p tannasca je̱mpɨc? ");
INSERT INTO poiNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Nɨmpa Jesús: —¿Que mich miIsraelpɨc mimaestro y d́a iŋcutɨɨyɨ́ypa t́i mannɨ́máypa? ");
INSERT INTO poiNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nu̱ma mannɨ́máypa aɨcht́am aŋwɨ̱jo̱doŋtam t́i sɨ́p mannɨ́máy. Manaŋmadayt́ámpa jém cosa jém ánixñewɨɨp. Pero micht́am d́a aŋcupɨgayt́ámpa. ");
INSERT INTO poiNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Siiga manaŋmadáypa jém cosa jém it́wɨɨp yɨ́p naxyucmɨ y d́a iŋcupɨcpa, ¿jesɨc jutsa̱p iŋcupɨc siiga manaŋmadáypa jém cosa jém it́wɨɨp sɨŋyucmɨ? ");
INSERT INTO poiNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’D́a i̱ wɨa̱p iquím sɨŋyucmɨ, no más ɨch wɨa̱p aŋquím. Ɨch jém aMiññewɨɨp Sɨŋyucmɨ, ait́ id́ɨc sɨŋyucmɨ, pero aquet yɨ́p naxyucmɨ iga aŋwatpa jém Dios iyo̱xacuy. ");
INSERT INTO poiNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Wiñɨc jém Moisés ipaŋpa tu̱m cuy, icquím tu̱m tsa̱ñwatnas jém cuyyucmɨ cuando oyyaj jém Dios ipɨxiñt́am jém tɨtsɨnaxyucmɨ. Jesa̱pt́im aɨch, jém aMiññewɨɨp Sɨŋyucmɨ, acquímta̱p tu̱m cuyyucmɨ ");
INSERT INTO poiNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","iga it́u̱mpɨy jém pɨxiñt́am, jém acupɨcneyajwɨɨp aɨch, d́a togoypa, mas ipɨctsoŋyajpa jém vida jém d́apɨc cuyajpa. ");
INSERT INTO poiNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Dios tsa̱m it́oypa it́u̱mpɨy jém pɨxiñt́am jém it́yajwɨɨp yɨ́p naxyucmɨ. Jeeyucmɨ ijɨ́c iga accaata̱ jém t́u̱mpɨc iMa̱nɨc iga it́u̱mpɨy jém icupɨcneyajwɨɨp jém Dios iMa̱nɨc d́a togoypa, mas ipɨctsoŋpa jém vida jém d́apɨc cuyajpa. ");
INSERT INTO poiNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Porque Dios d́a icutsat iMa̱nɨc yɨ́p naxyucmɨ iga ichiiba castigo jém pɨxiñt́am. Icutsat iMa̱nɨc iga icɨacputyajiñ it́u̱mpɨy jém it́yajwɨɨp icuwɨ̱t́i yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Siiga tu̱m pɨ̱xiñ icupɨc jém Dios iMa̱nɨc, jesɨc d́a i̱ ichiiba castigo. Pero jém d́apɨc icupɨcpa, jesɨc Dios ijɨycámayñe iga ichiiba castigo porque d́a icupɨcpa jém Dios iMa̱nɨc jém t́u̱mpɨc. ");
INSERT INTO poiNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Chiit́a̱p castigo jém pɨxiñt́am porque cuando miñ yɨ́p naxyucmɨ jém wɨbɨc juctɨaŋtso̱ca, jesɨc jeeyaj d́a iwɨ̱aŋja̱myaj. Tsa̱m it́oyyajpa jém piichɨ porque tsa̱m iwɨ̱aŋja̱m iga imalwatyajpa. ");
INSERT INTO poiNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","It́u̱mpɨy jém imalwatyajpáppɨc ijóyixyajpa jém wɨbɨc juctɨaŋtso̱ca. D́a icunúcyajpa jém juctɨaŋtso̱ca iga odoy quejiñ iga imalwatyajpa. ");
INSERT INTO poiNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pero jém iwatneyajwɨɨp juuts nɨmpa jém nu̱mapɨc aŋquímayooyi, icunúcyaj jém wɨbɨc juctɨaŋtso̱ca iga quejiñ iga iwɨ̱watyajpa juuts ixunpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Jesɨc ocmɨ jém Jesús con icuyujcɨɨwiñ nɨcyaj jém naxyucmɨ de Judea. Jemɨgam nɨc i̱t́iyaj. Acchíŋoyyajpa. ");
INSERT INTO poiNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Acchíŋóypat́im jém Xiwan jém attebet Enón nocojo̱m de jém attebet Salim porque jemɨc tsa̱m it́ nɨ. Nɨcyaj jém pɨxiñt́am iga acchiŋyajta̱iñ. ");
INSERT INTO poiNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Porque d́anam pajneta̱ cárcel jém Xiwan. ");
INSERT INTO poiNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Jesɨc algunos de jém Xiwan icuyujcɨɨwiñ moj áŋa̱jiyaj con jém judíos iga t́i ixunpa jém Moisés iŋquímayooyi iga tsɨ́y tu̱m pɨ̱xiñ cuáyñe. ");
INSERT INTO poiNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Jesɨc jém Xiwan icuyujcɨɨwiñ nɨc iŋmadayyaj jém Xiwan. Iñɨ́mayyaj: —Mammaestro, jém pɨ̱xiñ jém tanjɨypátnewɨɨp jém Jordán iŋwiñt́uc, jém annɨ́mayñewɨɨp mimich iga jeam jém Dios iMa̱nɨc, sɨɨp acchíŋóypat́im mex je. Nɨcyajpa it́u̱mpɨy jém pɨxiñt́am iga it́úŋɨyyajpa. ");
INSERT INTO poiNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jesɨc jém Xiwan iñɨ́máy jém icuyujcɨɨwiñ: —Siiga d́a t́i tachiiba Dios, jesɨc d́a t́i tanait́. ");
INSERT INTO poiNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Micht́am aŋwɨ̱matoŋneta cuando manaŋmadayt́a iga ɨch d́a je aCristo. Pero Dios acutsat iga aŋjagoyñeiñ ammiñ iga aŋwɨ̱tsagáypa jém Cristo it́uŋ. ");
INSERT INTO poiNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Cuando it́ jém aŋcoomɨ́yóycuy, jesɨc jém representante wiñt́i iwɨ̱tsacpa it́u̱mpɨy jém cosa. Jesɨc ocmɨ miñpa jém yoomɨypaap iga ipɨctsoŋpa jém iyo̱mo. Jesɨc maymay jém representante. Jesa̱pt́im aɨch. Agui amaymay iga núcneum jém Cristo. ");
INSERT INTO poiNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Sɨɨp más jáyaŋa̱p jém Cristo ipɨxiñt́am. D́am atúŋɨyyajpa jém pɨxiñt́am porque cuyajum jém anyo̱xacuy. ");
INSERT INTO poiNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Jém yucmɨpɨc miññe, je más wɨa̱p que it́u̱mpɨy jém pɨxiñt́am. Pero jém tsucumnewɨɨp yɨ́p naxyucmɨ iniit́ yɨ́p naxyucmɨpɨc jɨ̱xi. Iŋmatpa yɨ́p naxyucmɨpɨc aŋquímayooyi. Pero jém yucmɨpɨc miññe inimiñ jém más wɨbɨc jɨ̱xi. ");
INSERT INTO poiNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Iŋmatpa jém wɨbɨc aŋquímayooyi jém iixñewɨɨp y jém imatoŋnewɨɨp sɨŋyucmɨ. Pero jém pɨxiñt́am d́a icupɨcyajpa jém iŋmadayooyi, it́u̱mpɨy ijɨ̱syajpa iga mɨgooyi. ");
INSERT INTO poiNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Pero ɨch aXiwan aŋcupɨc jém iŋquímayooyi y mannɨ́máypa iga je jém nu̱mapɨc, d́a mɨgóypa tanJa̱tuŋ Dios. ");
INSERT INTO poiNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Porque jém icutsatnewɨɨp Dios, iŋmatpa jém Dios iŋma̱t́i. Quejpa iga tsa̱m pɨ̱mi chiiñeta̱ jém Dios iA̱nama. ");
INSERT INTO poiNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","TanJa̱tuŋ Dios tsa̱m it́oypa jém iMa̱nɨc. Icɨɨjuŋcodáy it́u̱mpɨy cosa icɨɨjo̱m iga wɨa̱iñ iwat juuts je iwɨ̱aŋja̱m. ");
INSERT INTO poiNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Siiga i̱ icupɨcpa jém Dios iMa̱nɨc, jesɨc ipɨctsoŋpa jém vida jém d́apɨc cuyajpa. Pero siiga tu̱m pɨ̱xiñ d́a icupɨcpa jém Dios iMa̱nɨc, jesɨc d́a ipɨctsoŋpa jém vida jém d́apɨc cuyajpa. Dios ichiiba jém pɨ̱xiñ jém mɨjpɨc castigo jém d́apɨc cuyajpa. ");
INSERT INTO poiNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Jesɨc imatoŋyaj jém fariseoyaj iga más jáyaŋ jém pɨxiñt́am it́úŋɨyyajpa jém Jesús que jém Xiwan, icchiŋpat́im más jáyaŋ pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Pero jém Jesús iyaac d́a acchíŋóypa, nada más acchíŋoyyajpa jém icuyujcɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Mu ijo̱dóŋa̱ jém Jesús t́i ijɨ̱syajpa jém fariseoyaj, jesɨc put de jém naxyucmɨ de Judea. Se̱t e̱ybɨc jém naxyucmɨ de Galilea. ");
INSERT INTO poiNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Iganam nɨcpa Galilea jém Jesús, tienes que naspa jém naxyucmɨ de Samaria. ");
INSERT INTO poiNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Jesɨc núc jém Jesús tu̱m Samariapɨc attebet iñɨ̱yi Sicar. D́a juumɨ jém nas jém ichiiñewɨɨp wiñɨgam jém Jacob jém ima̱nɨc José. ");
INSERT INTO poiNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Je̱mt́im it́ jém mu̱tɨ jém iwatnewɨɨp jém Jacob. Cugapja̱ma núc jém Jesús. Agui sopsne. Juumɨ miñ. Jesɨc co̱ñ Jesús jém mu̱tcɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Jesɨc jeet́i rato núc tu̱m Samariapɨc yo̱mo. Miñ ipɨc nɨ. Jesús iñɨ́máy jém yo̱mo: —Acwaacɨ uxaŋ nɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","D́a i̱ jém icuyujcɨɨwiñ. Nɨc ijuyyaj t́it́am icútyajpa jém attebet Sicar. ");
INSERT INTO poiNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Jesɨc jém Samariapɨc yo̱mo iñɨ́máy jém Jesús: —¿T́iiga aŋwágáypa nɨ aɨch? Mich mijudío y ɨch aSamariapɨc ayo̱mo. Je̱mpam nɨm jém yo̱mo porque jém judíos tsa̱m ijóyixyajpa jém Samariapɨc pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesɨc Jesús icutsoŋ jém yo̱mo. Iñɨ́máy: —Meega mich iñjo̱doŋ i̱ miwágáypa jém nɨ y meega iñjo̱doŋt́im iga Dios michiit́ooba jém wɨbɨc nɨ, jesɨc mich aŋwágáypa jém nɨ y ɨch manchiiba jém wɨbɨc nɨ jém michiipáppɨc jém vida. ");
INSERT INTO poiNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Jesɨc jém yo̱mo iñɨ́máy jém Jesús: —Pero mich d́a inii̱ t́imɨ iñt́oppa jém nɨ. Tsa̱m jojmɨ jém mu̱tɨ. ¿Jutsa̱p iñt́op jém nɨ jém tachiipáppɨc vida? ");
INSERT INTO poiNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Jém anja̱tuŋwe̱we ija̱tuŋ jém Jacob ichac yɨ́p mu̱tɨ para aɨcht́am. Jém Jacob con jém ima̱nɨctam nɨ́cyajpa yɨɨm. Icnɨ́cyajpat́im jém iani̱matyaj. ¿Que mich más miwɨa̱p que jém Jacob? ");
INSERT INTO poiNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesɨc Jesús iñɨ́máy jém yo̱mo: —It́u̱mpɨy jém iucyajpáppɨc yɨ́p nɨ, yɨɨmpɨc it́ mu̱tjo̱m, nɨ́ctɨtsyajpa e̱ybɨc. ");
INSERT INTO poiNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Pero jém iucpáppɨc jém nɨ, jém ɨchpɨc anchiiba, d́am e̱ybɨc nɨ́ctɨtspa. Jém nɨ tsɨ́ypa juuts tu̱m nɨ ixcuy ia̱namaŋjo̱m. Iyaacquímpa jém nɨ iga ichiiba jém vida jém d́apɨc cuyajpa. ");
INSERT INTO poiNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Jém yo̱mo iñɨ́máy jém Jesús: —Mimich, achi̱ɨ jém nɨ, jesɨc d́am e̱ybɨc anɨ́ctɨtspa. D́a amiñgacpa yɨɨm iga ampɨcpa nɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesús iñɨ́máy jém yo̱mo: —Nɨ̱gɨ aŋwejaayɨ jém iŋwɨd́a̱ya. Miñt́aamɨ yɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Nɨm jém yo̱mo: —D́a ajaayɨ́y. Jesɨc Jesús iñɨ́máy: —D́a mimɨgóypa iga miñɨmpa iga d́a mijaayɨ́y. ");
INSERT INTO poiNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Porque iniit́ id́ɨc cinco iŋwɨd́a̱ya y jém pɨ̱xiñ jém sɨɨppɨc iniit́ d́a je iŋwɨd́a̱ya. D́a mimɨgóypa iga d́a mijaayɨ́y. ");
INSERT INTO poiNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Cuando imatoŋ junɨmpa Jesús, jesɨc jém yo̱mo iñɨ́máy: —Quejpa iga mich miprofeta. ");
INSERT INTO poiNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Aɨcht́am jém aSamariapɨc aŋwe̱wetam dende wiñɨgam ijɨ̱syajpa Dios yɨ́p co̱tsɨcyucmɨ. Pero mimicht́am miñɨmtámpa iga solamente Jerusalén wɨa̱p tanjɨ̱sta Dios. ");
INSERT INTO poiNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesús iñɨ́máy jém yo̱mo: —Cupɨ̱cɨ sɨɨp t́i mannɨ́máypa. Núcpa jém ja̱ma iga wɨa̱p iñjɨ̱sta tanJa̱tuŋ Dios ju̱t́quej. D́a miñɨcpa Jerusalén ni d́at́im miquímpa yɨ́p co̱tsɨcyucmɨ iga iniŋwejpáttámpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mimicht́am miit́wɨɨp Samaria d́a iñjo̱doŋ i̱ iñjɨ̱stámpa. Pero aɨcht́am jém ajudíospɨc apɨxiñt́am ánixpɨcneta jém nunta Dios porque Dios ichac iga tsucum jém naxyucmɨ de Israel jém cɨacpudoypaap. ");
INSERT INTO poiNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Sɨɨp núctooba jém ja̱ma cuando jém nu̱mapɨc icupɨcneyajwɨɨp Dios ijɨ̱syajpa Dios ia̱namaŋjo̱m, ijɨ̱syajpa juuts nɨmpa jém nu̱mapɨc aŋquímayooyi. Jém tanJa̱tuŋ Dios imétspa jém ijɨ̱syajpáppɨc je̱mpɨc. ");
INSERT INTO poiNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","TanJa̱tuŋ Dios je tu̱m A̱nama juuts jém sa̱wa. Jém nu̱mapɨc icupɨcneyajwɨɨp Dios jeeyaj nu̱ma ijɨ̱syajpa Dios ia̱namaŋjo̱m juuts nɨmpa jém nu̱mapɨc aŋquímayooyi. ");
INSERT INTO poiNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Jém yo̱mo iñɨ́máy Jesús: —Anjo̱doŋ iga miñpa jém Mesías jém icutsatpaap Dios, iñɨ̱yit́im Cristo. Cuando núcneum jém Mesías, jesɨc taŋquejáypa it́u̱mpɨy jém wɨ̱tampɨc aŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesɨc Jesús iñɨ́máy jém yo̱mo: —Ɨcham aje, jém sɨɨppɨc manaŋmat. ");
INSERT INTO poiNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Jeet́i rato núcyaj jém Jesús icuyujcɨɨwiñ. Tsa̱m ámaŋjacyaj iga aŋmatpa Jesús con jém yo̱mo. Pero d́a i̱ icwác jém yo̱mo iga: “¿T́i miñ imméts?” Ni d́at́im i̱ icwác jém Jesús iga: “¿T́iiga iniŋmatpa jém yo̱mo?” ");
INSERT INTO poiNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Jesɨc jém yo̱mo ichac imajcuy, nɨc jém attebet. Nɨc iŋmadáy jém pɨxiñt́am: ");
INSERT INTO poiNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Nɨ̱gɨ aamɨ tu̱m pɨ̱xiñ. Aŋmadáy aɨch it́u̱mpɨy t́it́am aŋwatne dende wiñɨc. ¿Que d́a yɨ́bam jém Cristo? ");
INSERT INTO poiNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Jesɨc jeeyaj putyaj jém attebet, nɨc iámyaj jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Iganam nɨcne jém yo̱mo, jém Jesús icuyujcɨɨwiñ iñɨ́mayyaj: —MamMaestro, mi̱ñɨ miwiiqui. ");
INSERT INTO poiNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Pero Jesús iñɨ́máy jém icuyujcɨɨwiñ: —Ɨch anait́ wíccuy jém d́apɨc íñixpɨctámpa mimicht́am. ");
INSERT INTO poiNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Jesɨc jém icuyujcɨɨwiñ mojpa nacwácyajta̱ji entre jeeyaj. Nɨmyajpa: —¿Tanaŋja̱m iga algunos inimíñáy jém wíccuy? ");
INSERT INTO poiNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Pero Jesús iñɨ́máy icuyujcɨɨwiñ: —Cuando aŋwatpa juuts ixunpa Dios y anaccupacpa jém Dios iyo̱xacuy jex juuts ɨch aŋwíccuy. ");
INSERT INTO poiNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Micht́am miñɨmtámpa iga: “Togoyñam cuatro meses iga it́pa jém cosecha.” Pero ɨch mannɨ́máypa, ixt́aamɨ iga cɨŋneum jém cosecha. Jáyaŋ jém pɨxiñt́am icupɨcyajtooba jém Dios iŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Jém ipiŋyajpáppɨc jém cosecha yojyajta̱p. Ipiŋyajpa jém pɨxiñt́am iga chiita̱p jém vida jém d́apɨc cuyajpa. It́u̱mpɨy jém iñipneyajwɨɨp y jém ipiŋyajpáppɨc jém cosecha wagamaymáya̱yajpa. ");
INSERT INTO poiNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Nu̱ma juuts nɨmpa jém aŋma̱t́i iga tu̱m pɨ̱xiñ iñippa jém ca̱ma, pero tuŋgac ipiŋpa jém cosecha. ");
INSERT INTO poiNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Maŋcutsat iga nɨguiñ impiŋ jém yo̱xa̱ji ju̱t́ mich d́a iññip. Tuŋgac yo̱xayajpa jém ca̱mjo̱m, pero micht́am impíŋáypa jém iyo̱xa̱ji. ");
INSERT INTO poiNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Jáyaŋ jém Samariapɨc pɨxiñt́am jém it́yajwɨɨp jém attebet Sicar icupɨcyaj jém Jesús porque jém yo̱mo iñɨ́máy iga: “Jém pɨ̱xiñ aŋmadáy it́u̱mpɨy juuts ɨch aŋwatne.” ");
INSERT INTO poiNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Jesɨc cuando jém pɨxiñt́am núcyaj ju̱t́ it́ jém Jesús, icunucsayyajpa. Iñɨ́mayyaj iga: “Tsɨɨyɨ yɨɨm con aɨcht́am.” Jesɨc jemum tsɨ́y jém Jesús wɨsna ja̱ma. ");
INSERT INTO poiNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Jesɨc iganam accuyujóypa Jesús jém attebet Sicar, mást́im jáyaŋam jém pɨxiñt́am icupɨcyaj jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Jesɨc jeeyaj iñɨ́mayyaj jém yo̱mo: —Sɨɨp anjo̱doŋtam iga yɨ́p pɨ̱xiñ je jém Cristo jém icɨacputpáppɨc it́u̱mpɨy jém it́yajwɨɨp icuwɨ̱t́i yɨ́p naxyucmɨ. Anjo̱dóŋa̱ta porque anyaac ammatoŋneta t́i nɨmpa, d́a no más iga mich anaŋmadáy. ");
INSERT INTO poiNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Jemum poychɨ́y wɨsnaja̱ma. Ocmɨ mojgacum nɨqui jém Jesús jém naxyucmɨ de Galilea. ");
INSERT INTO poiNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Porque iyaac nɨm jém Jesús iga: “Wɨ̱pɨctsoŋta̱p jém profeta ju̱t́quej, pero cuando nɨcpa najɨ́yooyi it́ɨcmɨpɨc attebet, jém it́ɨ̱wɨtam d́a iwɨ̱pɨctsoŋyajpa.” ");
INSERT INTO poiNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Cuando núc Jesús Galilea, jesɨc jém Galileapɨc pɨxiñt́am iwɨ̱pɨctsoŋyaj. Porque oy sɨŋa̱jiyaj jém pascuasɨŋ jém Jerusalén. Iixyajt́im t́it́am iwatne Jesús jém Jerusalén. ");
INSERT INTO poiNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Nɨcgac Jesús jém attebet Caná, jém naxyucmɨ de Galilea, ju̱t́ icse̱t jém nɨ iga vino. Jesɨc jemum it́ id́ɨc tu̱m mɨjpɨc aŋjagooyi, icuyo̱xa̱p jém rey. Mɨmne jém aŋjagooyi ijayma̱nɨc jém attebet Capernaum. ");
INSERT INTO poiNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Cuando ijo̱dóŋa̱p jém aŋjagooyi iga putneum Jesús jém naxyucmɨ de Judea y núcneum jém naxyucmɨ de Galilea, jesɨc nɨc iám jém Jesús. Jém aŋjagooyi icunucsáypa jém Jesús iga nɨguiñ it́ɨccɨɨm iga icpɨsáyiñ jém ijayma̱nɨc porque caatoobam. ");
INSERT INTO poiNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesɨc Jesús iñɨ́máy jém pɨ̱xiñ: —Mimicht́am, siiga d́a íñixt́ámpa jém wɨbɨc seña y jém wɨ̱tampɨc milagroyaj, d́a iŋcupɨctámpa iga Dios acutsat yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Pero jém aŋjagooyi iñɨ́máy Jesús: —MánO̱mi, sɨɨpt́i tanɨcpa antes que caaba jém amma̱nɨc. ");
INSERT INTO poiNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesɨc Jesús iñɨ́máy jém aŋjagooyi: —Sɨɨp nɨcsɨm iñt́ɨcmɨ. Pɨsneum jém imma̱nɨc. Jém pɨ̱xiñ icupɨc t́i iñɨ́máy Jesús. Mojum se̱t́i it́ɨcmɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Iganam se̱t́i id́ɨc it́ɨcmɨ jém aŋjagooyi, jesɨc tuŋjo̱m ipát algunos de jém icuyo̱xayajpaap. Miñ imétsyaj jém io̱mi. Nɨ́mayt́a̱: —Pɨsneum jém imma̱nɨc. ");
INSERT INTO poiNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Jesɨc jém aŋjagooyi icwác jeeyaj iga juchɨs hora moj uxáŋa̱ji iga pɨstooba jém ima̱nɨc. Nɨmyaj: —Matɨc a la una de la tarde ichac jém jawaŋ. ");
INSERT INTO poiNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Jesɨc jém tsɨ̱xi ija̱tuŋ ijɨ̱s iga jeet́im hora Jesús iñɨ́máy iga: “Pɨsum jém imma̱nɨc.” Jesɨc jém pɨ̱xiñ icupɨc Jesús con it́u̱mpɨy jém it́yajwɨɨp it́ɨccɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Wɨste̱n milagro iwat Jesús cuando se̱t jém naxyucmɨ de Galilea de jém naxyucmɨ de Judea. Yɨ́p jém ocmɨpɨc. ");
INSERT INTO poiNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Jesɨc yaj iwat je̱mpɨc, núc jém ja̱ma iga jém judíos iwatyajpa tu̱m sɨŋ Jerusalén. Nɨct́im mex jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jemum Jerusalén it́ tu̱m me̱yɨ watneta̱, taañiaŋna̱ca. Jém nɨ iñɨ̱yi Betesda jém hebreopɨc aŋmat́i̱mɨ. Nocojo̱m it́ jém taañi ipuerta iñɨ̱yi jém Borrego iPuerta. Jém me̱yaŋna̱ca it́ cinco corredor. ");
INSERT INTO poiNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Wo̱neyaj jém corredor jáyaŋ jém mɨmneyajwɨɨp. It́t́im jém cácht́i, jém cu̱xuj y jém tusacanewɨɨp icumɨj. Iŋjócyajpa iga tsɨgóypa jém nɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Porque aveces miñpa tu̱m sɨŋyucmɨpɨc pɨ̱xiñ iga ictsɨgóypa jém nɨ. Jesɨc jém wiñt́ipɨc tɨgɨypa jém me̱yjo̱m cuando tsɨgóypa jém nɨ, pɨspa de cualquier jém caacuy. ");
INSERT INTO poiNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Jemum it́ tu̱m pɨ̱xiñ tsa̱m pecam mɨmne. Iniit́um jém caacuy treinta y ocho a̱mt́ɨy. ");
INSERT INTO poiNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesɨc Jesús iix jém pɨ̱xiñ ju̱t́ wo̱ne. Ijo̱dóŋa̱ Jesús iga tsa̱m pecam mɨmne, iñɨ́máy jém pɨ̱xiñ: —¿Iŋwɨ̱aŋja̱m iga mipɨspa? ");
INSERT INTO poiNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Jesɨc jém mɨmnewɨɨp iñɨ́máy Jesús: —MánO̱mi, d́a anai̱ i̱ acucompa jém me̱yjo̱m cuando tsɨgóypa jém nɨ. Iganam atɨgɨyt́ooba aɨch, wiñt́i tɨgɨypa tuŋgac. ");
INSERT INTO poiNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesús iñɨ́máy jém pɨ̱xiñ: —Sɨɨp tsucu̱mɨm, pi̱ŋɨm jém iñchees, wi̱t́ɨm. ");
INSERT INTO poiNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Jeet́i rato pɨsum jém pɨ̱xiñ, ipiŋ jém ichees, mojum wi̱t́i. Watta̱ yɨ́p milagro jém jejcuyja̱ma. ");
INSERT INTO poiNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Jém judíos pɨ̱mi jóyñeyaj. Iñɨ́mayyaj jém pɨ̱xiñ jém pɨsnewɨɨp: —Yɨ́p ja̱ma jém jejcuyja̱ma. Jém tanaŋquímayooyi d́a ijɨ́cpa iga iñchɨmte̱ñpa iñchees yɨ́p ja̱ma. ");
INSERT INTO poiNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Jesɨc jém mɨmnewɨɨp id́ɨc iñɨ́máy jém aŋjagooyiyaj: —Jém pɨ̱xiñ, jém acpɨsnewɨɨp, anɨ́máy iga: “Pi̱ŋɨm iñchees. Wi̱t́ɨm.” ");
INSERT INTO poiNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Jesɨc jeeyaj icwácyaj, iñɨ́máy: —¿I̱ miñɨ́máy iga: “Pi̱ŋɨm jém iñchees, wi̱t́ɨm”? ");
INSERT INTO poiNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pero jém acpɨsneta̱wɨɨp d́a ijo̱doŋ i̱ icpɨs porque tsa̱m it́ñɨ̱m jém lugar y nɨcneum jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Jesɨc ocmɨ Jesús ictsɨ́y jém pɨ̱xiñ jém mɨjpɨc ma̱stɨcjo̱m. Iñɨ́máy: —Sɨɨp mipɨsneum. Odom malwa̱tɨ e̱ybɨc iga odoy iññascaiñ tu̱m cosa más pɨ̱mi malo. ");
INSERT INTO poiNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Jesɨc jém pɨ̱xiñ nɨc iŋmadáy jém judíos iga Jesús jém icpɨsnewɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Jém judíos ijóyixyajpa Jesús iga acpɨsóypa jém jejcuyja̱ma. Jeeyucmɨ tsa̱m icpóyɨyyaj jém Jesús. Imétsyaj ju̱t́pɨc iccaayajpa. ");
INSERT INTO poiNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Pero Jesús iñɨ́máy jeeyaj: —Jém anJa̱tuŋ Dios yo̱xa̱p hasta sɨɨp. Ɨch ayo̱xa̱pt́im. ");
INSERT INTO poiNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Jeeyucmɨ jém judíos más pɨ̱mi iccaayajtooba jém Jesús. Porque d́a solamente iga yo̱xa̱p jém jejcuyja̱ma, pero nɨmpat́im Jesús iga: “Ɨch jém Dios anJa̱tuŋ.” Jesɨc tsɨ́y jex juuts tanJa̱tuŋ Dios. ");
INSERT INTO poiNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesɨc Jesús iñɨ́máy jém pɨxiñt́am: —Nu̱ma mannɨ́máypa iga jém Dios iMa̱nɨc d́a iwatpa juuts ijɨ̱spa iyaac, iwatpa juuts iix iga iwatpa jém iJa̱tuŋ. Jém Dios iMa̱nɨc iwatpa jext́im juuts iwatne iJa̱tuŋ. ");
INSERT INTO poiNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Jém anJa̱tuŋ Dios it́oypa jém iMa̱nɨc y iŋquejáypa it́u̱mpɨy juuts je iwatpa. Ocmɨ Dios iŋquejáypat́im iMa̱nɨc jém más mɨjpɨc milagro y mimicht́am tsa̱m miámaŋjactámpa cuando íñixt́ámpa. ");
INSERT INTO poiNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Porque jém anJa̱tuŋ Dios icpɨspa jém caaneyajwɨɨp, ichiiba vida. Jesa̱pt́im iwat jém Dios iMa̱nɨc, ichiibat́im vida jém pɨxiñt́am jém iwɨ̱aŋja̱myajpáppɨc. ");
INSERT INTO poiNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Jém anJa̱tuŋ Dios d́a i̱ icɨɨpiŋpa. Iccám iMa̱nɨc juuts tu̱m aŋjagooyi iga icɨɨpíŋiñ it́u̱mpɨy jém pɨxiñt́am, ");
INSERT INTO poiNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","iga it́u̱mpɨy de jeeyaj icujípyajiñ jém Dios iMa̱nɨc. Jém d́apɨc icujíppa jém Dios iMa̱nɨc, jesɨc d́at́im icujíppa jém anJa̱tuŋ Dios jém icutsatnewɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Nɨmt́im Jesús: —Nu̱ma mannɨ́máypa mimicht́am, siiga immatoŋpa ɨch anaŋma̱t́i y iŋcupɨcpa Dios jém acutsatnewɨɨp, jesɨc iniit́um jém vida jém d́apɨc cuyajpa. Jesɨc d́a impɨctsoŋpa jém castigo. Michɨ́yñe id́ɨc juuts caane jém íña̱nama, pero sɨɨp vivojam jém íña̱nama. ");
INSERT INTO poiNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nu̱ma mannɨ́máypa iga núcpa jém ja̱ma y sɨɨp núcneum iga jém pɨxiñt́am, jém caaneyajwɨɨp, imatóŋayyajpa jém Dios iMa̱nɨc ijɨ̱yi. Jém icupɨcneyajwɨɨp t́i iñɨ́máy, ipɨctsoŋyajpa jém vida. ");
INSERT INTO poiNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Jém anJa̱tuŋ Dios iniit́ jém vida y wɨa̱p ichi i̱ quej. Ichiiñet́im jém iMa̱nɨc jexpɨct́im pɨ̱mi iga jeegact́i wɨa̱p michi jém vida juutst́im anJa̱tuŋ Dios. ");
INSERT INTO poiNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Jém Miññewɨɨp Sɨŋyucmɨ chiit́a̱ jém pɨ̱mi iga icɨɨpiŋ jém pɨxiñt́am. Jeeyucmɨ miñ yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Odoy ámaŋja̱cɨ cuando mannɨ́máypa iga pɨsyajpa jém caaneyajwɨɨp. Porque núcpa jém ja̱ma cuando it́u̱mpɨy jém pɨxiñt́am, jém caaneyajwɨɨp, imatóŋayyajpa jém ijɨ̱yi. ");
INSERT INTO poiNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","It́u̱mpɨy jém caaneyajwɨɨp putyajpa de ju̱t́ cumneyajta̱. Jém iwatneyajwɨɨp juuts iwɨ̱aŋja̱m Dios, pɨsyajpa iga ipɨctsoŋyajpa jém vida iga d́am e̱ybɨc caaba. Pero jém malopɨc pɨxiñt́am, pɨsyajpat́im iga ipɨctsoŋyajpa jém castigo ju̱t́ d́a nunca putpa. ");
INSERT INTO poiNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Jesɨc nɨmt́im Jesús: —Ɨch d́a t́i wɨa̱p aŋwat anyaac. Aŋcɨɨpiŋpa jém pɨxiñt́am juuts anɨ́máy Dios. Jeeyucmɨ ɨch aŋwɨ̱cɨɨpiŋpa porque d́a aŋwatpa juuts ɨch aŋwɨ̱aŋja̱m, pero aŋwatpa juuts iwɨ̱aŋja̱m jém anJa̱tuŋ Dios jém acutsatnewɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Siiga ɨch anyaac manaŋmadáypa iga Dios acutsat, jesɨc d́a i̱ acupɨgáypa jém anaŋmadayooyi. ");
INSERT INTO poiNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","It́ tuŋgac testigo jém miŋmadaypáppɨc iga Dios acutsat. Ɨch anjo̱doŋ iga nuumaŋmatpa cuando miñɨ́máypa ju̱t́ amiñ. ");
INSERT INTO poiNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Micht́am iŋcutsat jém pɨxiñt́am iga nɨguiñ icwácyaj jém Xiwan jém acchíŋoypaap. Jém Xiwan miñuumaŋmadáy, d́a mimɨgóyáy. ");
INSERT INTO poiNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ɨch d́a ansunpa jém testigo iga ayo̱xpátpa aɨch, pero ammétspa jém testigo iga miyo̱xpáttámiñ iga micɨacputtámiñ mimicht́am. ");
INSERT INTO poiNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jém Xiwan jex juuts tu̱m juctɨ iga miyɨ́cquejpa, agui wɨ̱tsocpa. Cuando it́ jém Xiwan, mimicht́am agui mimaymayt́am iga impɨctsoŋta jém Xiwan iŋquímayooyi. ");
INSERT INTO poiNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Pero it́ tu̱m testigo más wɨ̱ que jém Xiwan. Jém milagroyaj, jém aŋwatnewɨɨp, tsɨ́y juuts tu̱m testigo para ɨch. Cuando aŋwatpa jém milagro juuts anɨ́máy Dios, jesɨc quejpa iga Dios acutsat yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Jém anJa̱tuŋ, jém acutsatnewɨɨp yɨ́p naxyucmɨ, tsɨ́yt́im juuts tu̱m testigo iga ɨch amiñ sɨŋyucmɨ, pero mimicht́am d́a queman immatoŋta jém Dios ijɨ̱yi ni d́a queman íñixt́a jém icuwiñ. ");
INSERT INTO poiNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Mimicht́am, d́a inii̱t́a jém Dios iŋma̱t́i íña̱namaŋjo̱m porque d́a aŋcupɨcta aɨch jém acutsatnewɨɨp Dios. ");
INSERT INTO poiNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mimicht́am tsa̱m iŋcuyujcatámpa jém Dios iŋma̱t́i jém jayñewɨɨp porque iñjɨ̱stámpa iga jemum impátpa jém vida jém d́apɨc cuyajpa. Pero jém Dios iŋma̱t́i jém jayñewɨɨp, miŋmadáypa de aɨch. ");
INSERT INTO poiNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Mimicht́am d́a michɨ́yt́amtooba juuts ɨch maŋcuyujcɨɨwiñ iga wɨa̱iñ impɨctsoŋta jém vida jém d́apɨc cuyajpa. ");
INSERT INTO poiNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Nɨmt́im Jesús: —Ɨch d́a ammétspa jém pɨxiñt́am yɨ́p naxyucmɨ iga acujípyajiñ. ");
INSERT INTO poiNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Maŋwɨ̱ixpɨcpa mimicht́am, anjo̱doŋ iga d́a iñt́oyt́ámpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ɨch amiñ jém anJa̱tuŋ Dios iñɨyi̱mɨ, pero mimicht́am d́a ampɨctsoŋta. Siiga miñpa tuŋgac pɨ̱xiñ jém d́apɨc je Dios imɨɨchi, jesɨc impɨctsoŋtámpa. ");
INSERT INTO poiNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Pero jutsa̱p iŋcupɨcta Dios porque tsa̱m minicujíptamta̱p iñyaac? D́a iŋwattamtooba jém wɨ̱tampɨc cosa iga Dios icut́um micujíptámiñ. ");
INSERT INTO poiNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Odoy jɨ̱sɨ iga ɨch anaquímpa jém quejaj contra mimicht́am jém anJa̱tuŋ Dios iwiñjo̱m. Pero jém Moisés nu̱ma iniquímpa jém quejaj contra mimicht́am porque miñɨmtámpa iga iŋcupɨcta jém Moisés iŋquímayooyi. ");
INSERT INTO poiNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Siiga nu̱ma iŋcupɨcta jém Moisés iŋquímayooyi, jesɨc iŋcupɨctámpat́im iga Dios acutsat porque jém Moisés ijay iga ɨch amiñpa. ");
INSERT INTO poiNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pero siiga d́a iŋcupɨctámpa t́i ijay jém Moisés, ¿jesɨc jutsa̱p iŋcupɨc t́i mannɨ́máy? ");
INSERT INTO poiNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ocmɨ, cuando yaj iñasca je̱mpɨc, nɨc Jesús jém laguna aŋwiñt́uc, iñɨ̱yi jém laguna Galilea, iñɨ̱yit́im Tiberias. ");
INSERT INTO poiNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Tsa̱m jáyaŋ pɨxiñt́am it́úŋɨyyajpa Jesús porque iixyaj jém milagroyaj cuando icpɨs jém mɨmneyajwɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Quím Jesús tu̱m co̱tsɨcyucmɨ, iwaganaco̱ñyaj jém icuyujcɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Núctooba jém pascuasɨŋ jém iwatyajpáppɨc jém judíos. ");
INSERT INTO poiNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Cuando ámquím Jesús, iix iga miñyajpa tsa̱m jáyaŋ jém pɨxiñt́am. Jesɨc iñɨ́máy jém Felipe: —¿Ju̱t́ wɨa̱p tanjuy caxt́ána̱ñi iga tanacwíctámpa it́u̱mpɨy yɨ́pyaj pɨxiñt́am? ");
INSERT INTO poiNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ichobɨyñɨ́máy jém Felipe je̱mpɨc iga icutɨ́tspa, porque ijo̱doŋ Jesús jutsa̱p icwíc jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Jesɨc jém Felipe iñɨ́máy: —Meega tanait́ doscientos tumiñ de plata iga tanjuypa caxt́ána̱ñi, d́a ictsɨ́ypa iga cada tu̱mtu̱m ipɨctsoŋpa uxaŋ. ");
INSERT INTO poiNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Jesɨc jém Anti, tuŋgac jém icuyujcɨɨwiñ, jém Ximoj Peto it́ɨ̱wɨ, iñɨ́máy Jesús: ");
INSERT INTO poiNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Yɨɨm it́ tu̱m jaychɨ̱xi. Iniit́ cinco caxt́ána̱ñi de cebada y wɨste̱n tɨɨpɨ. Pero como tsa̱m jáyaŋ it́yaj, d́a ictsɨ́ypa ni uxaŋ. ");
INSERT INTO poiNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesɨc Jesús iñɨ́máy jém icuyujcɨɨwiñ: —Acco̱ñya̱jɨ it́u̱mpɨy jém pɨxiñt́am. Jesɨc co̱ñyaj múgaŋjo̱m, it́yaj como cinco mil jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesɨc Jesús ipɨc jém caxt́ána̱ñi. Cuando yaj iŋwejpát Dios, ichi jém caxt́ána̱ñi jém icuyujcɨɨwiñ. Jeeyaj iwécyaj, ichiiyaj it́u̱mpɨy jém pɨxiñt́am jém co̱ñyajwɨɨp. Je̱mpɨct́im iwat con jém tɨɨpɨ. Chiiyajta̱ juuts ixunyajpa jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Jesɨc cuando cusum wiiquiyaj, iñɨ́máy Jesús jém icuyujcɨɨwiñ: —Sɨɨp piŋtaamɨ it́u̱mpɨy jém cutsɨ́yñewɨɨp iga odoy togóyiñ ni uxaŋ. ");
INSERT INTO poiNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Jesɨc ipiŋyaj it́u̱mpɨy jém cutsɨ́yñewɨɨp, jém d́apɨc yaj icútyaj jém pɨxiñt́am. Icucomyaj doce nacooŋ con jém cutsɨ́yñewɨɨp de jém cinco caxt́ána̱ñi de cebada. ");
INSERT INTO poiNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Jesɨc jém pɨxiñt́am cuando iixyaj jém milagro jém iwatnewɨɨp Jesús, nɨmyaj: —Nu̱ma yɨ́p pɨ̱xiñ jém Profeta jém tanaŋjóctampáppɨc iga miñpa yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Pero Jesús icutɨɨyɨ́y iga miñpa imats jém pɨxiñt́am iga iccámpa pɨ̱mi̱mɨ juuts tu̱m rey, jeeyucmɨ nɨc icut́um tu̱m co̱tsɨcyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Jesɨc jocpiicha̱bam i̱t́i. Quetyaj jém Jesús icuyujcɨɨwiñ jém laguna aŋna̱ca. ");
INSERT INTO poiNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Tɨgɨyyaj tu̱m barcojo̱m, moj nɨquiyaj jém laguna aŋwiñt́uc jém attebet Capernaum. Cupiicha̱wum, pero d́anam quet jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Jesɨc moj po̱yi jém sa̱wa tsa̱m pɨ̱mi. Agui mɨj jém nɨɨpoa. ");
INSERT INTO poiNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Juumɨ nɨc jém barco como cinco o seis kilómetro. Icwit́yajpa jém barco con remos. Jesɨc jeet́i rato iixyaj iga miñpa jém Jesús, wit́pa imiñ jém nɨɨwiñpacyucmɨ. Núc nocojo̱m ju̱t́ it́ jém barco. Tsa̱m pɨ̱mi cɨ̱ŋyaj jém icuyujcɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Jesɨc Jesús iñɨ́máy jeeyaj: —Aɨcham, odoy cɨ̱ŋtaamɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Jesɨc iwɨ̱pɨctsoŋyaj jém icuyujcɨɨwiñ, icquímyaj Jesús jém barcojo̱m. Jesɨc tu̱mt́i rato núcyaj jém laguna aŋna̱ca ju̱t́ nɨcyajpa. ");
INSERT INTO poiNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Jesɨc icuqueja̱ma jém pɨxiñt́am, jém tsɨ́yñeyajwɨɨp jém laguna aŋna̱ca, ju̱t́ tsucumyaj jém Jesús icuyujcɨɨwiñ, ijo̱dóŋa̱yaj iga it́ id́ɨc je̱m no más tu̱m barco. Ijo̱dóŋa̱yajt́im iga jém Jesús d́a iwagananɨcyaj jém icuyujcɨɨwiñ barcojo̱m. ");
INSERT INTO poiNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Iganam sɨɨp ijɨ̱syaj jém pɨxiñt́am, núcyaj wa̱t́i jém barco, tsucumyaj jém attebet de Tiberias. Núcyaj jém laguna aŋna̱ca nocojo̱m jém lugar ju̱t́ icútyajpa jém caxt́ána̱ñi ju̱t́ iŋwejpát Dios jém tánO̱mi. ");
INSERT INTO poiNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Jesɨc cuando jém pɨxiñt́am iixyaj iga d́a i̱ jém Jesús ni jém icuyujcɨɨwiñ, tɨgɨyyaj jém tuŋgac barcojo̱m, jém yaguiñpɨc miñyaj, nɨcyajt́im jém attebet Capernaum iga imétsyajpa Jesús. ");
INSERT INTO poiNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Jesɨc cuando ipátyaj jém Jesús jém laguna aŋwiñt́uc nɨmyajpa: —MamMaestro, ¿juchɨs miñúc yɨɨm? ");
INSERT INTO poiNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesɨc Jesús iñɨ́máy jeeyaj: —Nu̱ma mannɨ́máypa, mimicht́am ammétstámpa porque micusta mu iŋcútta jém caxt́ána̱ñi. D́a ammétstámpa porque iŋcutɨɨyɨyt́a t́i manaŋquejayt́a con jém wɨbɨc milagro jém aŋwatnewɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Odoy yo̱xataamɨ no más para jém wíccuy, jém it́wɨɨp yɨ́p naxyucmɨ, porque je yajpa. Más wɨ̱ iga miyo̱xatámiñ para jém tuŋgac wíccuy jém d́apɨc cuyajpa, jém michiipáppɨc jém vida jém d́apɨc cuyajpa. Ɨch, jém aMiññewɨɨp Sɨŋyucmɨ, amiñ iga manchiiba jém wíccuy jém d́apɨc cuyajpa. Quejpa iga acutsat jém anJa̱tuŋ Dios porque achi jém pɨ̱mi iga wɨa̱iñ aŋwat jém milagroyaj. ");
INSERT INTO poiNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Jesɨc jém pɨxiñt́am iñɨ́máy jém Jesús: —¿T́i wɨa̱p aŋwatta iga aŋwattámpa jém Dios iyo̱xacuy? ");
INSERT INTO poiNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesús iñɨ́máy jém pɨxiñt́am: —It́ tu̱m yo̱xacuy iwɨ̱aŋja̱m Dios iga iŋwattámiñ, acupɨctaamɨ aɨch jém acutsatnewɨɨp Dios yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Jesɨc jém pɨxiñt́am iñɨ́máy jém Jesús: —¿Que jup seña anaŋquejáypa mimich iga maŋcupɨctámiñ? ¿Jup milagro wɨa̱p iŋwat? ");
INSERT INTO poiNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Jém tanja̱tuŋwe̱wetam wiñɨgam icútyaj jém maná jém tɨtsɨnaxyucmɨ. Jayñeta̱ jém Dios iŋma̱t́i iga: “Chiiyajta̱ jém pɨxiñt́am jém sɨŋyucmɨpɨc caxt́ána̱ñi.” ");
INSERT INTO poiNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesɨc Jesús iñɨ́máy jém pɨxiñt́am: —Nu̱ma mannɨ́máypa, d́a je sɨŋyucmɨpɨc caxt́ána̱ñi jém ichiiñewɨɨp jém Moisés jém wiñɨcpɨc pɨxiñt́am. Pero anJa̱tuŋ Dios michiiba jém nunta sɨŋyucmɨpɨc caxt́ána̱ñi. ");
INSERT INTO poiNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Porque jém caxt́ána̱ñi, jém michiipáppɨc Dios, quetpa sɨŋyucmɨ y ichiiba vida jém pɨxiñt́am jém it́yajwɨɨp yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Jesɨc nɨmyaj jeeyaj: —MánO̱mi, achiit́aamɨ siempre jexpɨc caxt́ána̱ñi. ");
INSERT INTO poiNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesɨc Jesús iñɨ́máy: —Ɨch jém acaxt́ána̱ñi jém michiipáppɨc jém vida. Siiga i̱ miñpa atúŋɨ́y, jesɨc d́a nunca yua̱p; siiga i̱ acupɨcpa aɨch, jesɨc d́a nunca nɨ́ctɨtspa. ");
INSERT INTO poiNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Mannɨ́mayt́a iga mex ánixñeta mimicht́am, d́a aŋcupɨctámpa iga michɨ́yiñ juuts ɨch maŋcuyujcɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","It́u̱mpɨy jém pɨxiñt́am, jém achiipáppɨc jém anJa̱tuŋ Dios, miñpa atúŋɨyyaj. Siiga miñpa atúŋɨ́y tu̱m pɨ̱xiñ, ampɨctsoŋpa, d́a aŋquebacputpa. ");
INSERT INTO poiNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Porque ɨch amiñ sɨŋyucmɨ iga aŋwatpa juuts iwɨ̱aŋja̱m Dios jém acutsatnewɨɨp. D́a amiñ iga aŋwatpa juuts aɨch aŋwɨ̱aŋja̱m. ");
INSERT INTO poiNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Jém anJa̱tuŋ, jém acutsatnewɨɨp yɨ́p naxyucmɨ, d́a ixunpa iga togoypa ni tu̱m jém pɨ̱xiñ jém achiiñewɨɨp aɨch. Achiit́a̱ jém pɨ̱mi iga wɨa̱iñ anacpɨsyaj jém ampɨxiñt́am jém caaneyajwɨɨp jém íŋaŋpɨgam ja̱ma. ");
INSERT INTO poiNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Porque jém anJa̱tuŋ Dios, jém acutsatnewɨɨp, iwɨ̱aŋja̱m iga it́u̱mpɨy jém pɨxiñt́am, siiga iixyaj jém iMa̱nɨc, icupɨcyajpa, ipɨctsoŋyajpa jém vida jém d́apɨc cuyajpa. Anacpɨsyajpa it́u̱mpɨy jém ampɨxiñt́am jém íŋaŋpɨgam ja̱ma. ");
INSERT INTO poiNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Jesɨc agui jóyñeyaj jém judíos. Icujɨyyaj jém Jesús porque nɨmpa iga: “Ɨch jém acaxt́ána̱ñi jém aquetnewɨɨp sɨŋyucmɨ.” ");
INSERT INTO poiNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Nɨmyaj jeeyaj: —¿Que d́a yɨ́bam jém José ima̱nɨc? Tánixpɨ́gáy jém ija̱tuŋ y ia̱pa. ¿T́iiga tanɨ́máypa iga quetne sɨŋyucmɨ? ");
INSERT INTO poiNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesɨc jém Jesús iñɨ́máy jém pɨxiñt́am: —Tsa̱cɨ iga aŋcujɨyt́ámpa mimicht́am. ");
INSERT INTO poiNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","D́a i̱ wɨa̱p imiñ iga acupɨcpa siiga jém anJa̱tuŋ Dios d́a inimiñpa. Ɨch anacpɨspa jém ampɨxiñt́am jém caaneyajwɨɨp jém íŋaŋpɨgam ja̱ma. ");
INSERT INTO poiNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Jém wiñɨcpɨc profeta ijaychacne jém librojo̱m iga: “Dios iccuyujyajpa it́u̱mpɨy jém ipɨxiñt́am.” Sɨɨp mannɨ́máypa iga it́u̱mpɨy jém pɨxiñt́am jém iccuyujneyajwɨɨp jém anJa̱tuŋ Dios, jém imatoŋneyajwɨɨp, miñpa atúŋɨyyaj aɨch. ");
INSERT INTO poiNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nɨmpat́im Jesús: —Ɨch anjo̱doŋ iga d́a i̱ oypa iix jém anJa̱tuŋ Dios, ɨch aŋcut́um ánixñe. Porque ɨch amiñ ju̱t́ it́ jém anJa̱tuŋ. ");
INSERT INTO poiNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nu̱ma mannɨ́máypa, jém acupɨcpaap aɨch, ipɨctsoŋpa jém vida jém d́apɨc cuyajpa. ");
INSERT INTO poiNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ɨch jém acaxt́ána̱ñi, jém manchiipáppɨc vida jém d́apɨc cuyajpa. ");
INSERT INTO poiNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Mimicht́am iñja̱tuŋwe̱wetam, jém wiñɨcpɨc, icútyaj jém maná jém tɨtsɨnaxyucmɨ. Pero ocmɨ caayajt́im jeeyaj. ");
INSERT INTO poiNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pero sɨɨp manaŋmadáypa iga it́ tuŋgac caxt́ána̱ñi jém quetnewɨɨp sɨŋyucmɨ. Siiga i̱ icútpa yɨ́p caxt́ána̱ñi d́a e̱ybɨc caaba. ");
INSERT INTO poiNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ɨcht́im mismo jém acaxt́ána̱ñi jém aquetnewɨɨp sɨŋyucmɨ. Siiga i̱ icútpa yɨ́p caxt́ána̱ñi, it́pa para siempre. Jém caxt́ána̱ñi, jém manchiipáppɨc, ɨch ammɨjta̱y. Ɨch anyaac anjɨ́cpa iga accaata̱p iga anyojáypa jém pɨxiñt́am it́áŋca iga ipɨctsoŋyajpa jém vida jém d́apɨc cuyajpa. ");
INSERT INTO poiNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Jesɨc jém judíos nacwácyajta̱p entre jeeyaj. Moj áŋa̱jiyaj. Nanɨ́mayyajta̱p: —¿Jutsa̱p tachi jém imɨjta̱y iga taŋcúdáypa? ");
INSERT INTO poiNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesɨc Jesús iñɨ́máy jeeyaj: —Ɨch jém aMiññewɨɨp Sɨŋyucmɨ, nu̱ma mannɨ́máypa siiga mimicht́am d́a iŋcútpa ɨch ammɨjta̱y y siiga d́a íñucpa jém annɨɨpiñ, jesɨc d́a inii̱ jém vida iga nɨcpa mii̱t́i con Dios. ");
INSERT INTO poiNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Siiga i̱ icútpa jém ammɨjta̱y y iucpa annɨɨpiñ, iniit́um jém vida jém d́apɨc cuyajpa; anacpɨspa jém íŋaŋpɨgam ja̱ma. ");
INSERT INTO poiNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Jém ammɨjta̱y nunta wíccuy y jém annɨɨpiñ nunta uccuy, mimatspagáypa íña̱nama. ");
INSERT INTO poiNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Siiga i̱ icútpa ammɨjta̱y y iucpa annɨɨpiñ, awaganait́pa aɨch y ɨch aŋwaganait́pa je. ");
INSERT INTO poiNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Jém anJa̱tuŋ Dios jém acutsatnewɨɨp iniit́ jém vida. Ɨch anait́t́im jém vida porque achiiñe jém anJa̱tuŋ. Jesanet́im jém ampɨxiñt́am jém icútnewɨɨp jém ammɨjta̱y, iniit́yajt́im jém vida jém d́apɨc cuyajpa, porque ɨch anchiiñe. ");
INSERT INTO poiNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Manaŋmadáypa de jém caxt́ána̱ñi jém quetnewɨɨp sɨŋyucmɨ. Yɨ́p caxt́ána̱ñi d́a jex juuts jém wíccuy jém maná jém icútneyajwɨɨp jém iñja̱tuŋwe̱wetam wiñɨgam. Jeeyaj caayajt́im it́u̱mpɨy. Pero siiga i̱ icútpa yɨ́p caxt́ána̱ñi, iniit́pa jém vida jém d́apɨc cuyajpa para it́u̱mpɨy tiempo. ");
INSERT INTO poiNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesús iŋquejáypa je̱mpɨc jém it́yajwɨɨp jém sinagoga jém attebet Capernaum. ");
INSERT INTO poiNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Jáyaŋ jém icuyujcɨɨwiñ cuando imatoŋyajpa t́i nɨmpa jém Jesús, jesɨc nɨmyaj: —Tsa̱m táŋca yɨ́p aŋquímayooyi. ¿I̱ wɨa̱p icupɨc? ");
INSERT INTO poiNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jém icuyujcɨɨwiñ mojpa icujɨyyaj jém Jesús. Pero je ijo̱doŋ t́i sɨ́p iñɨmyaj, jesɨc iñɨ́máy: —¿Que d́a iŋwɨ̱aŋja̱mta yɨ́p aŋquímayooyi? ");
INSERT INTO poiNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Jesɨc t́i iñjɨ̱stámpa siiga mimicht́am ánixt́ámpa, jém aMiññewɨɨp Sɨŋyucmɨ, cuando aquímgacpa sɨŋyucmɨ ju̱t́ ait́ id́ɨc wiñɨgam? ");
INSERT INTO poiNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Tu̱m pɨ̱xiñ ia̱nama iniit́ jém ivida. Pero siiga putpa jém ia̱nama, jesɨc jém imɨjta̱y d́a t́i cuwatcuy. Ɨch anaŋma̱t́i, jém manaŋmadayñewɨɨp, nu̱ma iniit́ jém vida, iniit́ jém a̱nama. ");
INSERT INTO poiNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pero todavía it́ algunos de mimicht́am d́a iŋcupɨctámpa ɨch anaŋma̱t́i. Mu icupiŋ Jesús jém icuyujcɨɨwiñ ijo̱doŋ i̱apaap d́a icupɨcpa y i̱apaap iwadáypa jém atraición. ");
INSERT INTO poiNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Jesɨc Jesús iñɨ́máy it́u̱mpɨy jém it́úŋɨyyajpaap: —Jeeyucmɨ mannɨ́máypa iga d́a i̱ wɨa̱p imiñ iga atúŋɨ́ypa siiga jém anJa̱tuŋ Dios d́a ijɨ́cpa, siiga d́a anamíñáypa. ");
INSERT INTO poiNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Dende jesɨgam tsa̱m jáyaŋ jém Jesús icuyujcɨɨwiñ ichagaŋputyaj iga iwaganasɨɨba, d́a más it́úŋɨyyaj. ");
INSERT INTO poiNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jesɨc Jesús icwácpa jém doce icuyujcɨɨwiñ. Nɨ́mayt́a̱: —¿Que mimicht́am antsagaŋputpat́im? ");
INSERT INTO poiNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Icutsoŋ jém Ximoj Peto, iñɨ́máy: —MánO̱mi, ¿jesɨc i̱ antúŋɨ́ypa? Mimich iniit́ jém wɨbɨc aŋma̱t́i jém tachiipáppɨc jém vida jém d́apɨc cuyajpa. ");
INSERT INTO poiNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Aɨcht́am maŋcupɨcnetámum y anjo̱dóŋa̱netámum iga mich miCristo jém Vivopɨc Dios miMa̱nɨc. ");
INSERT INTO poiNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesɨc Jesús iñɨ́máy jém icuyujcɨɨwiñ: —Ɨch maŋcupiŋneta mimicht́am jém doce maŋcuyujcɨɨwiñ. Pero tu̱m de mimicht́am miwoccɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Iŋmatpa Jesús de jém Judas Iscariote, jém Ximoj Iscariote ima̱nɨc. Je tu̱m de jém docepɨc icuyujcɨɨwiñ, pero iwadáypa atraición jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Jesɨc ocmɨ cuando yaj iŋquejáy je̱mpɨc, sɨɨba Jesús jém naxyucmɨ de Galilea. D́a nɨctooba jém naxyucmɨ de Judea porque jém judíos iccaayajtooba. ");
INSERT INTO poiNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","D́a jáypa núc jém sɨŋ iga iwatyajpa jém nacxt́ɨc jém judíos. ");
INSERT INTO poiNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Jesɨc jém Jesús it́ɨ̱wɨtam iñɨ́mayyaj: —¿T́iiga michɨ́y yɨɨm? Nɨ̱cɨ jém naxyucmɨ de Judea iga it́u̱mpɨy jém iŋcuyujcɨɨwiñ jém it́yajwɨɨp jém naxyucmɨ de Judea wɨa̱p iixyaj t́i iŋwatpa. ");
INSERT INTO poiNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Siiga i̱ ixunpa iga ixpɨcta̱iñ, jesɨc d́a iyamwatpa tu̱m cosa ju̱t́ d́a i̱ iixpa. Siiga mich iŋwatpa jexpɨc cosa, odoy yamwa̱tɨ. Wa̱tɨ jém pɨxiñt́am aŋcucmɨ iga miixt́a̱iñ. ");
INSERT INTO poiNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Porque jém it́ɨ̱wɨtam d́at́im icupɨcyajpa jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesɨc Jesús iñɨ́máy jeeyaj: —D́anam núcne jém hora iga aŋwatpa juuts ixunpa Dios jém naxyucmɨ de Judea. Pero mimicht́am juchɨs quej wɨa̱p iññɨc. ");
INSERT INTO poiNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Jém pɨxiñt́am, jém it́yajwɨɨp yɨ́p naxyucmɨ, d́a mijóyixt́ámpa mimicht́am. Pero tsa̱m ajóyixyajpa aɨch porque ɨch atsɨ́y juuts tu̱m testigo iga tsa̱m imalwatyajpa jeeyaj. ");
INSERT INTO poiNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Mimicht́am, nɨcstaamɨm mixɨ́ŋa̱jit́am. Ɨch d́a anɨcpa porque d́anam núcne jém hora iga anɨcpa. ");
INSERT INTO poiNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ocmɨ yaj nɨ̱mi jém Jesús, jemum tsɨ́y jém naxyucmɨ de Galilea. ");
INSERT INTO poiNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Cuando nɨcyajum sɨ́ŋa̱jiyaj jém it́ɨ̱wɨtam, jesɨc nɨct́im mex jém Jesús. D́a nɨc cucwiñjo̱m, pero yamnɨc. ");
INSERT INTO poiNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Jém judíos imétsyajpa jém Jesús sɨŋjo̱m. Nɨmyajpa: —¿Ju̱t́ it́ jém pɨ̱xiñ? ");
INSERT INTO poiNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Jesɨc jém pɨxiñt́am jém it́yajwɨɨp jém sɨŋjo̱m nacwácyajta̱p entre jeeyaj i̱apaap jém Jesús. Nɨmyajpa algunos iga agui wɨbɨc pɨ̱xiñ jém Jesús. Pero tuŋgac nɨmyajpa iga tsa̱m imɨgóyáypa jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pero d́a i̱ iŋmatpa ju̱t́ wɨa̱p imatoŋyaj jém judíos porque tsa̱m cɨ̱ŋyajpa. ");
INSERT INTO poiNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Cuando núcne cucmɨ iga sɨŋa̱yajpa jém pɨxiñt́am, jesɨc tɨgɨy Jesús jém mɨjpɨc ma̱stɨcjo̱m. Moj accuyujooyi. ");
INSERT INTO poiNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Jesɨc jém judíos tsa̱m ipooñaŋja̱myaj cuando imatoŋyaj jém Jesús. Nɨmyaj: —D́a oy cuyu̱ji yɨ́p pɨ̱xiñ, pero tsa̱m jɨ̱xiɨ́y. ");
INSERT INTO poiNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesɨc Jesús iñɨ́máy jeeyaj: —Yɨ́p aŋquímayooyi d́a ɨch ammɨɨchi. Imɨɨchi jém acutsatnewɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Siiga tu̱m pɨ̱xiñ iwɨ̱aŋja̱m iga iwatpa juuts ixunpa Dios, jesɨc icutɨɨyɨ́ypa iga Dios imɨɨchi yɨ́p aŋquímayooyi, d́a ɨch anjɨ̱xquiimi. ");
INSERT INTO poiNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Siiga tu̱m pɨ̱xiñ ijɨ̱xquímpa tu̱m aŋquímayooyi, iwatpa iga cujípta̱iñ. Pero siiga tu̱m pɨ̱xiñ ixunpa iga cujípta̱iñ jém icutsatnewɨɨp, jesɨc quejpa iga nuumaŋmatpa jém pɨ̱xiñ, d́a mɨgóypa, d́a táŋcaɨ́y ni uxaŋ. ");
INSERT INTO poiNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’¿Que d́a nu̱ma michiiñeta jém Moisés jém wiñɨcpɨc aŋquímayooyi? Pero mimicht́am, ni tu̱m, d́a iŋcupɨctámpa jém aŋquímayooyi. Mimicht́am, ¿t́iiga anaccaatamtooba aɨch? ");
INSERT INTO poiNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Nɨmyajpa jeeyaj: —Mich iniit́ tu̱m mal espíritu. ¿I̱ miccaatooba? ");
INSERT INTO poiNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesɨc Jesús iñɨ́máy: —Mimicht́am agui impooñaŋja̱mtámpa iga ɨch aŋwat jém milagro jém jejcuy ja̱ma. ");
INSERT INTO poiNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Jém Moisés ichac jém costumbre iga iŋwattámiñ jém marca de circuncisión. D́at́im Moisés ictsucum yɨ́p costumbre, pero jém wiñɨcpɨc pɨxiñt́am iwatt́im je̱mpɨc. Jeeyucmɨ mimicht́am iŋwadayt́ámpat́im jém marca tu̱m jaychɨ̱xi y d́a iŋwadayt́ámpa caso siiga jejcuy ja̱ma. ");
INSERT INTO poiNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Jesɨc siiga mimicht́am iŋwadayt́ámpa jém marca de circuncisión tu̱m jaychɨ̱xi iga iŋwatpa juuts nɨmpa jém Moisés iŋquímayooyi, ¿jesɨc t́iiga anjóyixpa aɨch siiga anacpɨspa tu̱m pɨ̱xiñ mɨmnewɨɨp jém jejcuy ja̱ma? ");
INSERT INTO poiNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Odoy nɨ̱mɨ iga imalwatpa tu̱m pɨ̱xiñ siiga d́a iŋwɨ̱jo̱doŋ. Wɨ̱cɨɨpi̱ŋɨ con wɨbɨc jɨ̱xi. ");
INSERT INTO poiNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jesɨc algunos jém it́yajwɨɨp jém Jerusalén moj nanɨ́mayyajta̱ji entre jeeyaj: —¿D́a yɨ́bam jém pɨ̱xiñ jém imétsyajpáppɨc jém aŋjagooyiyaj iga accaata̱iñ? ");
INSERT INTO poiNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Yɨɨm it́. Sɨ́p iŋmat jém pɨxiñt́am icucwiñjo̱m. Pero d́a i̱ ijɨ́yáypa. ¿Tanaŋja̱m iga jém aŋjagooyiyaj iñuntawɨ̱jo̱doŋ iga yɨ́p pɨ̱xiñ jém Cristo jém icutsatnewɨɨp Dios? ");
INSERT INTO poiNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pero taɨcht́am tanjo̱doŋ ju̱t́ miñ yɨ́p pɨ̱xiñ. Pero cuando miñpa jém Cristo d́a i̱ ijo̱doŋ ju̱t́ tsucumpa. ");
INSERT INTO poiNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jeeyucmɨ pɨ̱mi jɨypa Jesús ju̱t́ accuyujóypa jém mɨjpɨc ma̱stɨcjo̱m, nɨm mu ijɨy: —Nu̱ma micht́am ánixpɨcpa y iñjo̱doŋtam ju̱t́ amiññe, pero ɨch d́a amiñ anyaac. Jém acutsatnewɨɨp je jém nu̱mapɨc Dios, micht́am d́a íñixpɨctámpa. ");
INSERT INTO poiNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Pero ɨch ánixpɨcpa porque ɨch amiññe Dioscɨɨm, jeam acutsatne. ");
INSERT INTO poiNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Jeeyucmɨ jém aŋjagooyiyaj tsa̱m imatsyajtooba jém Jesús. Pero d́a i̱ wɨa̱p imats porque d́anam núcne jém hora iga matsta̱p. ");
INSERT INTO poiNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Y tsa̱m jáyaŋ jém pɨxiñt́am icupɨcyaj jém Jesús. Nɨmyajpa: —Cuando miñpa jém Cristo, ¿que wɨa̱p iwat tuŋgac más wɨbɨc milagro que jém iwatnewɨɨp yɨ́p pɨ̱xiñ? D́a wɨa̱p. ");
INSERT INTO poiNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Jesɨc jém fariseopɨc aŋjagooyiyaj imatoŋyaj t́i nɨmyajpa jém pɨxiñt́am de jém Jesús. Jesɨc jeeyaj con jém pa̱nij aŋjagooyiyaj icutsat jém ma̱stɨcjo̱mpɨc policía iga nɨguiñ imatsyaj jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jeeyucmɨ Jesús iñɨ́máy jém pɨxiñt́am: —Apoyit́pa con mimicht́am tu̱m rato. D́a jáypa nɨcpa ai̱t́i ju̱t́ it́ jém acutsatnewɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Micht́am ammétstámpa, pero d́a ampáttámpa porque nɨcpa ai̱t́i ju̱t́ mimicht́am d́a wɨa̱p iññɨcta. ");
INSERT INTO poiNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Jesɨc jém judíos moj nacwácyajta̱ji entre jeeyaj: —¿Ju̱t́ nɨcpa yɨ́p pɨ̱xiñ iga d́a wɨa̱p tampátta? ¿Tanaŋja̱m nɨcpa jém tuŋgac naxyucmɨ ju̱t́ it́ jém Israelpɨc pɨxiñt́am jém iŋmatyajpáppɨc griego iga iccuyujpa jém griegoyaj? ");
INSERT INTO poiNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿T́i nɨmtooba yɨ́p pɨ̱xiñ cuando nɨmpa iga: “Micht́am ammétstámpa, pero d́a wɨa̱p ampátta y ju̱t́ nɨcpa ai̱t́i, d́a wɨa̱p iññúcta”? ");
INSERT INTO poiNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Jesɨc núc jém ja̱ma iga cuyajpa jém sɨŋ, jém más mɨjpɨc ja̱ma. Te̱ñchucum jém Jesús jém pɨxiñt́am aŋcucmɨ. Pɨ̱mi ijɨ́yáypa jém pɨxiñt́am, nɨ́mayyajta̱p: —Siiga miñɨ́ctɨtstámpa, mi̱ñɨ manacnɨ́cpa. ");
INSERT INTO poiNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Siiga tu̱m pɨ̱xiñ acupɨcpa aɨch, jesɨc iniit́ juuts nɨmpa jém Dios iŋma̱t́i: “Tu̱m mɨjpɨc nɨixcuy ia̱namaŋjo̱m.” ");
INSERT INTO poiNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Cuando iŋmatpa je̱mpɨc, nɨmtooba Jesús iga jém icupɨcneyajwɨɨp, ipɨctsoŋyajpa jém Dios iA̱nama. Porque d́anam núcne jém Dios iA̱nama hasta nɨcgacpa Jesús sɨŋyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jesɨc cuando jém pɨxiñt́am imatoŋyajpa t́i nɨmpa jém Jesús, nɨmyajpa algunos iga: “Yɨ́p pɨ̱xiñ nu̱ma jém profeta jém tanaŋjócnewɨɨp.” ");
INSERT INTO poiNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Pero tuŋgac de jeeyaj nɨmyajpa: —Yɨ́p pɨ̱xiñ nu̱ma jém Cristo jém icutsatnewɨɨp Dios. Pero jém tuŋgac más de jeeyaj nɨmyajpa: —¿Que wɨa̱p imiñ jém Cristo de Galilea? ");
INSERT INTO poiNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Tanjo̱doŋ iga nɨmpa jém Dios iŋma̱t́i iga jém Cristo jém David io̱cma̱nɨc ima̱nɨc. Naypa jém Belén, jeet́im attebet ju̱t́ it́ id́ɨc jém David. ");
INSERT INTO poiNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Je̱mpɨgam nawécyajta̱ jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Algunos de jeeyaj imatsyajtooba jém Jesús, pero d́a i̱ wɨa̱ mimats. ");
INSERT INTO poiNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Jesɨc jém ma̱stɨc ipolicía se̱tyajum ju̱t́ it́yaj jém pa̱nij aŋjagooyiyaj con jém fariseoyaj. Jesɨc acwácyajta̱ jém policía: —¿T́iiga d́a inimiñt́a jém preso? ");
INSERT INTO poiNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Nɨmyaj jém policía: —D́a i̱ nunca wɨa̱p iŋmat juuts jém pɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Jém fariseoyaj iñɨ́mayyaj jém policía: —¿Que mich iŋcupɨctámpat́im jém mɨgooyi? ");
INSERT INTO poiNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Iñjo̱doŋtam iga jém tanaŋjagooyiyaj ni jém fariseoyaj d́a icupɨcyajpa yɨ́p pɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Pero yɨ́pyaj pɨxiñt́am d́a icutɨɨyɨyyajpa jém tanaŋquímayooyi, jeeyaj d́a wɨa̱p iñúcyaj ju̱t́ it́ Dios. ");
INSERT INTO poiNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Jesɨc jém Nicodemo, jém oyñewɨɨp iám jém Jesús tsuucɨɨm, tu̱m fariseopɨc aŋjagooyi, iñɨ́máy: ");
INSERT INTO poiNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Jém tanaŋquímayooyi d́a ijɨ́cpa iga chiit́a̱p castigo tu̱m pɨ̱xiñ siiga d́a wiñt́i cɨɨpiŋta̱p iga quejiñ siiga imalwatne. ");
INSERT INTO poiNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Jém tuŋgac aŋjagooyiyaj iñɨ́mayyaj jém Nicodemo: —¿Que mich miGalileapɨct́im mipɨ̱xiñ? Cuyujcaɨ jém Dios iŋma̱t́i iga iñjo̱dóŋa̱iñ iga ni tu̱m jém profeta d́a miñpa de jém naxyucmɨ de Galilea. ");
INSERT INTO poiNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Jesɨc cada tu̱mtu̱m nɨcyaj it́ɨccɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Pero nɨc Jesús jém co̱tsɨcyucmɨ iñɨ̱yi Olivos. ");
INSERT INTO poiNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Jesɨc jém tuŋgac ja̱ma, icuqueja̱ma, nɨcgacpa Jesús jém mɨjpɨc ma̱stɨcjo̱m. Aŋtuuma̱yaj jém pɨxiñt́am iga imatoŋyajpa. Jesɨc co̱ñ jém Jesús, moj iŋquejáy jém aŋtuuma̱neyajwɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Jesɨc algunos jém escribaspɨc maestroyaj con algunos jém fariseoyaj inimiñyaj tu̱m yo̱mo ju̱t́ it́ Jesús. Matsta̱ jém yo̱mo porque pátta̱ ju̱t́ pejóypa ixɨ. Namiñt́a̱ jém yo̱mo hasta jém pɨxiñt́am aŋcucmɨ iga icwácyajpa jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Nɨ́mayt́a̱p: —Maestro, matsta̱ yɨ́p yo̱mo porque pátta̱ ju̱t́ pejóypa ixɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Nɨmpa jém Moisés iŋquímayooyi iga tannácscatámiñ tsaamɨ jém pejoypaap. Jesɨc mich anɨ́maayɨ jup castigo tanchiiba yɨ́p yo̱mo. ");
INSERT INTO poiNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Nɨmyajpa je̱mpɨc jém fariseoyaj iga icutɨ́tspa jém Jesús. Imétsyajpa ju̱t́pɨc iquejajwadayyajpa jém Jesús. Jesɨc cómneactɨŋ jém Jesús, moj ja̱yi naxyucmɨ con icɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pero jeeyaj d́a ichacpa iga icwácyajpa. Jesɨc te̱ñchucum jém Jesús, iñɨ́máy jém inimiññewɨɨp jém yo̱mo: —Siiga tu̱m de mimicht́am d́a mit́áŋcaɨ́y, wɨ̱ iga iñyɨ́gáypa con jém wiñt́ipɨc tsa. ");
INSERT INTO poiNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Jesɨc e̱ybɨct́im cómneactɨŋ jém Jesús, mojgacum ja̱yi naxyucmɨ con icɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Jesɨc cuando jém pɨxiñt́am imatoŋyaj t́i iñɨ́máy jém Jesús, agui ijɨ̱syajpa ia̱namaŋjo̱m iga táŋcaɨ́yt́im. Tu̱mtu̱mt́i moj nɨquiyaj. Wiñt́i nɨcyaj jém más tsa̱mipɨc hasta cunɨgayyaj it́u̱mpɨyyaj. Jesɨc icut́umt́im tsɨ́y jém Jesús con jém yo̱mo, jemum te̱ñ jém cuarto icucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jesɨc te̱ñchucum jém Jesús. D́a i̱ iix, tsɨ́y no más jém yo̱mo. Jesɨc Jesús iñɨ́máy: —Miyo̱mo, ¿ju̱t́ it́ jém miquejajwádaypáppɨc? ¿Que d́a i̱ wɨa̱ michi castigo? ");
INSERT INTO poiNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Jém yo̱mo icutsoŋ. Iñɨ́máy: —D́a i̱, mánO̱mi. Jesɨc Jesús iñɨ́máy jém yo̱mo: —Ɨch d́at́im manchiiba castigo. Sɨɨp nɨcsɨm. Odom malwa̱tɨ e̱ybɨc. ");
INSERT INTO poiNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ocmɨ e̱ybɨct́im accuyujóypa Jesús, iñɨ́máy: —Ɨcham jém ajuctɨaŋtso̱ca, amiñ iga anyɨcquejpa jém it́yajwɨɨp yɨ́p naxyucmɨ. Jém atúŋɨypaap d́a sɨɨba jém piichcɨɨm, pero iniit́ jém juctɨ aŋtso̱ca ia̱namaŋjo̱m, jém ichiipáppɨc vida jém d́apɨc cuyajpa. ");
INSERT INTO poiNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Jesɨc jém fariseoyaj iñɨ́mayyaj jém Jesús: —Mich iñyaac miŋmatpa iga mii̱apaap, jeeyucmɨ d́a quejpa iga miñuumaŋmatpa. ");
INSERT INTO poiNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesɨc Jesús iñɨ́máy jeeyaj: —Siiga ɨch anyaac anaŋmatpa iga ai̱apaap, jesɨc nu̱ma jém anaŋma̱t́i porque anjo̱doŋ ju̱t́ amiñ y anjo̱doŋt́im ju̱t́ anɨcpa. Pero mimicht́am d́a iñjo̱doŋtam ju̱t́ amiñ ni d́at́im iñjo̱doŋ ju̱t́ anɨcpa. ");
INSERT INTO poiNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Micht́am micɨɨpiŋoyt́ámpa juuts nɨmpa yɨ́p naxyucmɨpɨc aŋquímayooyi. Ɨch d́a i̱ aŋcɨɨpiŋpa. ");
INSERT INTO poiNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Pero siiga acɨɨpíŋóypa juuts tu̱m juez, jesɨc awɨ̱cɨɨpíŋóypa porque d́a anyaac acɨɨpíŋóypa. Aŋwaganacɨɨpíŋóypa jém anJa̱tuŋ Dios jém acutsatnewɨɨp yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Jayñeta̱wum micht́ampɨc iniŋquímayooyi: “Siiga wɨste̱n testigo nɨmpat́im je̱mpɨc, wɨ̱ iga taŋcupɨcpa.” ");
INSERT INTO poiNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Jesɨc it́um wɨ̱ porque anyaac atsɨ́y juuts tu̱m testigo iga manaŋmadáypa ai̱apaap. Tsɨ́yt́im juuts testigo jém anJa̱tuŋ Dios, jém acutsatnewɨɨp yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Jesɨc icwácyajpa jeeyaj. Nɨ́mayt́a̱p jém Jesús: —¿Ju̱t́ it́ jém iñJa̱tuŋ? Jesús icutsoŋ, iñɨ́máy jeeyaj: —Mimicht́am d́a ánixpɨcta aɨch ni d́at́im íñixpɨcta jém anJa̱tuŋ Dios. Siiga ánixpɨcta aɨch, jesɨc íñixpɨctámpat́im jém anJa̱tuŋ Dios. ");
INSERT INTO poiNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Je̱mpɨgam iŋmatpa Jesús jém mɨjpɨc ma̱stɨcjo̱m iganam accuyujóypa jém cuarto ju̱t́ piŋta̱p jém ofrenda. Pero d́a i̱ wɨa̱p imats porque d́anam núcne jém ihora. ");
INSERT INTO poiNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesɨc e̱ybɨct́im iñɨ́máy jeeyaj: —Ɨch anɨcpa. Mimicht́am ammétstámpa, pero d́a wɨa̱p ampátta. Jesɨc cuando micaanetámum, nɨcpa iñyojta jém iñt́áŋca ju̱t́ d́a nunca miputpa. Ju̱t́ ɨch anɨcpa, mimicht́am d́a wɨa̱p iññɨcta. ");
INSERT INTO poiNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Jesɨc nɨmyajpa jém judíos: —¿Ju̱t́ nɨcpa yɨ́p pɨ̱xiñ? ¿Que nacaata̱p iyaac? Porque nɨmpa: “Ju̱t́ ɨch anɨcpa, micht́am d́a wɨa̱p iññɨcta.” ");
INSERT INTO poiNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesɨc Jesús iñɨ́máy jeeyaj: —Mimicht́am miñaxwiñpɨc, ɨch asɨŋwiñpɨc, ɨch amiñ sɨŋyucmɨ. Mimicht́am yɨ́p naxyucmɨpɨc mipɨxiñt́am, ɨch d́a yɨ́p naxyucmɨpɨc apɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Jeeyucmɨ mannɨ́máypa iga cuando micaanetámum, nɨcpa iñyojta jém iñt́áŋca. Porque siiga d́a iŋcupɨctámpa iga ɨch amiñ sɨŋyucmɨ, jesɨc cuando micaanetámum, nɨcpa iñyojta jém iñt́áŋca. ");
INSERT INTO poiNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Jesɨc icwácyajpa jeeyaj, nɨ́mayt́a̱ jém Jesús: —¿Que mich mii̱apaap? Jesɨc Jesús iñɨ́máy: —Ɨch ajeam juuts mannɨ́mayñe wiñt́i. ");
INSERT INTO poiNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Wɨa̱ manaŋquejayt́a iga mimicht́am tsa̱m mit́áŋcaɨyt́a y wɨa̱pt́im meega maŋcɨɨpiŋpa mimicht́am. Pero d́a aŋwatpa, porque nada más anaŋmatpa yɨ́p naxyucmɨ jém aŋquímayooyi jém anɨ́mayñewɨɨp jém acutsatnewɨɨp. Je d́a mɨgóypa, siempre nuumaŋmatpa. ");
INSERT INTO poiNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Pero d́a icutɨɨyɨyyaj iga nɨmtooba Jesús iga jém tanJa̱tuŋ Dios ichiiñe jém iŋquímayooyi. ");
INSERT INTO poiNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Jeeyucmɨ Jesús iñɨ́máy jém pɨxiñt́am: —Ɨch jém aMiññewɨɨp Sɨŋyucmɨ y cuando acquímta̱p aɨch jém cunusyucmɨ, jesɨc iŋcutɨɨyɨyt́ámpa ai̱apaap. Manaŋmadayt́ámpa jém aŋquímayooyi jém aŋquejayñewɨɨp jém anJa̱tuŋ Dios. D́a anyaac anjɨ̱xquímpa. ");
INSERT INTO poiNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Jém anJa̱tuŋ Dios jém acutsatnewɨɨp yɨ́p naxyucmɨ, aŋwaganait́ aɨch. D́a atsacne aŋcut́um porque siempre aŋwatpa juuts je iwɨ̱aŋja̱m. ");
INSERT INTO poiNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Iganam iŋmatpa je̱mpɨc jém Jesús, jesɨc jáyaŋ jém pɨxiñt́am moj icupɨcyaj. ");
INSERT INTO poiNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jesɨc Jesús iñɨ́máy jém judíos jém sɨɨppɨc icupɨcneyaj: —Siiga mimicht́am d́a iñchactámpa iga iŋwattámpa juuts mannɨ́máypa, jesɨc nu̱ma michɨ́ypa iga maŋcuyujcɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Wɨa̱p iŋcutɨɨyɨyt́a jém nu̱mapɨc aŋquímayooyi, jesɨc jém nu̱mapɨc aŋquímayooyi miccutsɨgayt́ámpa iga odoy michɨ́yt́ámiñ juuts tu̱m esclavo. ");
INSERT INTO poiNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Jesɨc los de más jém judíos, jém d́apɨc icupɨcneyaj Jesús, iñɨ́mayyaj: —Aɨcht́am jém Abraham ama̱nɨctam. D́a nunca atsɨ́yt́a juuts tu̱m esclavo. ¿T́iiga annɨ́mayt́ámpa iga acutsɨgayt́amta̱iñ? ");
INSERT INTO poiNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesɨc Jesús iñɨ́máy jeeyaj: —Nu̱ma mannɨ́máypa, it́u̱mpɨy jém imalwatyajpáppɨc tsɨ́y juuts esclavo porque iwatpa juuts ipɨɨmɨ́ypa jém malopɨc jɨ̱xi ia̱namaŋjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Mannɨ́máypat́im iga tu̱m esclavo d́a wɨa̱p iwaganait́ jém io̱mi it́u̱mpɨy tiempo. Pero tu̱m pɨ̱xiñ ima̱nɨc wɨa̱p iwaganait́ jém ija̱tuŋ it́u̱mpɨy tiempo. ");
INSERT INTO poiNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Siiga Dios iMa̱nɨc miccutsɨgáypa, jesɨc d́a michɨ́ypa juuts esclavo iga iŋcuyo̱xa̱p jém Woccɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ɨch anjo̱doŋ iga mimicht́am jém Abraham mima̱nɨctam, pero mimicht́am aŋcumectámpa iga anaccaatamtooba aɨch porque d́a iŋwɨ̱aŋja̱mta t́i manaŋmadáypa. ");
INSERT INTO poiNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Manaŋmadáypa jém aŋquímayooyi jém aŋquejayñewɨɨp anJa̱tuŋ Dios. Pero mimicht́am iŋwattámpa juuts miñɨ́mayt́a mimicht́am iñja̱tuŋ. ");
INSERT INTO poiNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Jesɨc jeeyaj iñɨ́mayyaj jém Jesús: —Aɨcht́am anja̱tuŋ jém Abraham. Jesɨc Jesús iñɨ́máypa: —Siiga nu̱ma mimicht́am jém Abraham mima̱nɨctam, wɨ̱ iga iŋwattámpat́im juuts iwatpa jém Abraham. ");
INSERT INTO poiNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Pero mimicht́am aŋcumectámpa iga anaccaatámpa aɨch, aunque manaŋmadayñe jém nu̱mapɨc iŋquímayooyi jém achiiñewɨɨp anJa̱tuŋ Dios. Jém Abraham d́a nunca iwat je̱mpɨc. ");
INSERT INTO poiNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Micht́am, sɨɨp iŋwattámpat́im juuts iwatpa mich iñja̱tuŋ. Jesɨc jeeyaj iñɨ́mayyaj jém Jesús: —Aɨcht́am d́a je apejpen. Aɨcht́am anJa̱tuŋ t́u̱m, jém Dios anJa̱tuŋ. ");
INSERT INTO poiNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesɨc Jesús iñɨ́máy jeeyaj: —Siiga nu̱ma Dios iñJa̱tuŋ, tienes que antoyt́ámpa aɨch porque ɨch amiññe ju̱t́ it́ Dios. Ɨch d́a amiñ anyaac; Dios acutsatne yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿T́iiga d́a iŋcutɨɨyɨyt́ámpa t́i mannɨ́máypa? D́a wɨa̱p iŋcutɨɨyɨyt́a porque d́a iŋcupɨcpa ɨch anaŋmadayooyi. ");
INSERT INTO poiNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mimicht́am iñja̱tuŋ jém Woccɨɨwiñ. Jeam mimɨɨchit́am. Iŋwɨ̱aŋja̱mta iga iŋwattámpa juuts ixunpa jém iñja̱tuŋ. Jém Woccɨɨwiñ jém accaoypáppɨc dende wiñɨgam. D́at́im nunca nuumaŋmatpa. Iŋmatpa mɨgooyi porque je jém mɨgoypaap, ictsucum jém mɨgooyi. ");
INSERT INTO poiNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Aunque ɨch mannuumaŋmadáypa, mimicht́am d́a aŋcupɨctámpa. ");
INSERT INTO poiNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ni tu̱m de mimicht́am d́a wɨa̱p ampádáy ɨch antáŋca. Siiga mannuumaŋmatpa, ¿jesɨc t́iiga d́a aŋcupɨctámpa aɨch? ");
INSERT INTO poiNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Siiga Dios imɨɨchi tu̱m pɨ̱xiñ, iwɨ̱matoŋpa jém Dios iŋma̱t́i. Mimicht́am d́a je Dios mimɨɨchit́am jeeyucmɨ d́a immatoŋtámpa jém Dios iŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Jesɨc jém judíos imalnɨ́máy jém Jesús, nɨmyaj: —¿D́a mannɨ́máy iga Samariapɨc mipɨ̱xiñ y tu̱m mal espíritu iniit́ íña̱namaŋjo̱m? ");
INSERT INTO poiNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesɨc Jesús iñɨ́máy: —Ɨch d́a anai̱ jém mal espíritu. Ɨch aŋwatpa jém wɨ̱tampɨc cosa iga wɨ̱ixt́a̱iñ jém anJa̱tuŋ Dios. Pero mimicht́am d́a aŋwɨ̱ixt́ámpa aɨch. ");
INSERT INTO poiNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ɨch anyaac d́a ammétspa iga acujípta̱iñ. Jém anJa̱tuŋ Dios ixunpa iga acujípta̱iñ. Jeet́im anJa̱tuŋ icɨɨpiŋpa jém malopɨc pɨxiñt́am, ichiiba castigo. ");
INSERT INTO poiNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nu̱ma mannɨ́máypa, siiga tu̱m pɨ̱xiñ icupɨcpa ɨch anaŋmadayooyi, jesɨc d́a nunca caaba. ");
INSERT INTO poiNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Jesɨc jém judíos iñɨ́mayyaj jém Jesús: —Sɨɨp aŋcutɨɨyɨyt́ámpa iga mich iniit́ tu̱m mal espíritu íña̱namaŋjo̱m. Tsa̱m wiñɨgam ca jém Abraham. Caayajt́im jém wiñɨcpɨc profeta, pero mich miñɨmpa iga siiga tu̱m pɨ̱xiñ icupɨcpa jém iniŋmadayooyi, jesɨc d́a nunca caaba. ");
INSERT INTO poiNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Que mich más miwɨa̱p que jém anja̱tuŋ Abraham jém caanewɨɨp? Cucaayyajt́im it́u̱mpɨy jém wiñɨcpɨc profeta. ¿Mich t́i iñjɨ̱spa iga mii̱apaap? ");
INSERT INTO poiNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesɨc Jesús icutsoŋ, iñɨ́máy jeeyaj: —Siiga anacujípta̱p anyaac, jesɨc d́a t́i acuwatcuy. Pero anJa̱tuŋ Dios acujíppa. Jeet́im Dios, jém miñɨmtampáppɨc iga mich iñDios. ");
INSERT INTO poiNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Pero mimicht́am d́a íñixpɨctámpa Dios. Ɨch nu̱ma ánixpɨcpa. Siiga mannɨ́máypa iga d́a ánixpɨcpa Dios, jesɨc amɨgóypat́im juuts mimicht́am. Pero ɨch nu̱ma ánixpɨcpa Dios y siempre aŋwatpa juuts je aŋmadáy. ");
INSERT INTO poiNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Agui iwɨ̱aŋja̱m jém iñja̱tuŋ Abraham iga wɨa̱p iix jém ja̱ma iga amiñ yɨ́p naxyucmɨ, agui maymay mu iix jém ja̱ma. ");
INSERT INTO poiNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Jesɨc jém judíos iñɨ́mayyaj jém Jesús: —Mich d́a inii̱ ni cincuenta íña̱mt́ɨy ¿y miñɨmpa iga íñixñe jém Abraham? ");
INSERT INTO poiNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesɨc Jesús iñɨ́máy: —Nu̱ma mannɨ́máypa cuando d́anam nayñe jém Abraham, ɨch ait́t́im. ");
INSERT INTO poiNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Jesɨc jém pɨxiñt́am ipiŋyaj tsa iga iñácscayajpa id́ɨc tsaamɨ. Pero yam jém Jesús, put jém ma̱stɨcjo̱m, nas jém pɨxiñt́am aŋcucmɨ. Nɨc. ");
INSERT INTO poiNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Cuando naspa Jesús tu̱m lugar, iix tu̱m pɨ̱xiñ, cácht́i mu iñay. ");
INSERT INTO poiNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Jesɨc jém Jesús icuyujcɨɨwiñ icwácyajpa. Nɨ́mayt́a̱: —MamMaestro, ¿t́iiga cácht́i yɨ́p pɨ̱xiñ mu iñay? ¿Que yɨ́p pɨ̱xiñ iyaac iwat táŋca, o jém ija̱tuŋ con ia̱pa iwat táŋca iga cácht́ia̱ mu iñay? ");
INSERT INTO poiNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesɨc Jesús iñɨ́máy jém icuyujcɨɨwiñ: —D́a cácht́i yɨ́p pɨ̱xiñ iga táŋcaɨ́y iyaac o iga táŋcaɨ́y jém ija̱tuŋ o ia̱pa. Cácht́ia̱ yɨ́p pɨ̱xiñ iga ixt́a̱iñ iga Dios wɨa̱p iwat jém wɨbɨc milagro. ");
INSERT INTO poiNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Iganam sɨŋñi wɨ̱ iga taŋwatpa jém Dios iyo̱xacuy jém acutsatnewɨɨp, porque miñpa jém piichɨ cuando d́a i̱ wɨa̱p iwat jém yo̱xacuy. ");
INSERT INTO poiNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Iganam ait́ yɨ́p naxyucmɨ, jesɨc ɨch jém wɨbɨc juctɨaŋtso̱ca, anyɨcquejpa jém it́yajwɨɨp yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jesɨc yaj iñɨ́máy je̱mpɨc, Jesús tsujpa naxyucmɨ, iwat uxaŋ tuutɨ con ichuyñɨ, iccámáy jém tuutɨ jém cácht́i iixcuyyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Jesɨc iñɨ́máy jém cácht́i: —Nɨ̱gɨ cutseaayɨ jém íñixcuy jém me̱yjo̱m jém lugar Siloé. Taɨcht́am tanaŋmat́i̱mɨ jém Siloé nɨmtooba jém cutsatneta̱wɨɨp. Jesɨc jém cácht́i nɨcpa icutseáy jém iixcuy. Cuando se̱tpa, ixixóypam. ");
INSERT INTO poiNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Jesɨc jém ivecinoyaj con jém iixñeyajwɨɨp id́ɨc cuando iwácpa tumiñ, moj nanɨ́mayyajta̱ji entre jeeyaj: —¿Que d́a yɨ́bam jém co̱ññepaap id́ɨc yɨɨm iga iwácpa tumiñ? ");
INSERT INTO poiNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Nɨmyajpa algunos: —Nu̱ma, yɨ́bam jém pɨ̱xiñ. Tuŋgac nɨmyajpa: —Quénam jeam, pero d́a je. Pero jém cácht́ipɨc id́ɨc nɨmpa: —Aɨcham. ");
INSERT INTO poiNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Jesɨc jém aŋtuuma̱neyajwɨɨp iñɨ́mayyaj jém cácht́ipɨc id́ɨc: —¿Jutsa̱ mit́oj jém íñixcuy? ");
INSERT INTO poiNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Nɨmpa jém cácht́ipɨc id́ɨc: —Jém pɨ̱xiñ iñɨ̱yi Jesús iwat uxaŋ tuutɨ, accámáy ánixcuyyucmɨ y anɨ́máy iga: “Nɨ̱gɨ cutseaayɨ jém íñixcuy jém me̱yjo̱m jém lugar Siloé.” Jesɨc oy aŋcutseáy ánixcuy, mojum aixixooyi. ");
INSERT INTO poiNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Jesɨc nɨmyaj jeeyaj: —¿Sɨɨp ju̱t́ it́ jém pɨ̱xiñ? Jém cácht́ipɨc id́ɨc icutsoŋ: —D́a anjo̱doŋ ju̱t́ iɨŋ. ");
INSERT INTO poiNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Jesɨc ocmɨm nanɨcta̱ jém cácht́ipɨc id́ɨc jém aŋjagooyicɨɨm ju̱t́ it́ jém fariseoyaj. ");
INSERT INTO poiNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jejcuyja̱ma id́ɨc cuando jém Jesús iwat uxaŋ jém tuutɨ iga ictojáy jém cácht́i iixcuy. ");
INSERT INTO poiNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Jesɨc jém fariseoyaj e̱ybɨc icwácyaj jém cácht́ipɨc id́ɨc. Nɨ́mayt́a̱: —¿Jutsa̱ miixixóy? Jesɨc jém cácht́ipɨc id́ɨc nɨmpa: —Jém pɨ̱xiñ accámáy uxaŋ jém tuutɨ ánixcuyyucmɨ. Oy aŋcutseáy jém ánixcuy jém me̱yjo̱m. Sɨɨp aixixóypam. ");
INSERT INTO poiNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Jesɨc algunos jém fariseoyaj nɨmyaj: —Jém pɨ̱xiñ, jém iwatnewɨɨp je̱mpɨc, d́a je de Dios porque yo̱xa̱p jém jejcuyja̱ma contra jém tanaŋquímayooyi. Pero jém tuŋgac jém fariseoyaj nɨmyajpa: —¿Pero jutsa̱p iwat jém wɨbɨc milagro siiga táŋcaɨ́yt́im jém pɨ̱xiñ? Jesɨc nawécyajta̱ jém fariseoyaj. Agui áŋa̱yajpa. ");
INSERT INTO poiNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","E̱ybɨct́im acwácta̱ jém cácht́ipɨc id́ɨc. Nɨ́mayt́a̱: —¿Mich t́i miñɨmpa, i̱apaap jém mictojayñewɨɨp íñixcuy? Nɨmpa jém cácht́ipɨc id́ɨc: —Je tu̱m profeta. ");
INSERT INTO poiNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pero jém judíos d́a icupɨcyajpa iga cácht́i id́ɨc jém pɨ̱xiñ. D́at́im icupɨcyajpa iga actojayt́a̱ iixcuy hasta que iŋwejáyayyaj jém pɨ̱xiñ ija̱tuŋ con ia̱pa. ");
INSERT INTO poiNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Jém fariseoyaj icwácyajpa jém pɨ̱xiñ ija̱tuŋ. Nɨ́mayt́a̱: —¿Que yɨ́p pɨ̱xiñ mich imma̱nɨc, jém miñɨmpaap iga cácht́i mu iñay? ¿Jutsa̱p miixixóy sɨɨp? ");
INSERT INTO poiNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Jesɨc nɨmyaj ija̱tuŋ con ia̱pa: —Anjo̱doŋ iga nu̱ma yɨ́bam jém amma̱nɨc, cácht́i miñay. ");
INSERT INTO poiNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pero d́a anjo̱doŋ jutsa̱ miixixóy y ni d́at́im anjo̱doŋ i̱ ictojáy jém iixcuy. Acwaacɨ jém amma̱nɨc porque sɨɨp mɨjam, wɨa̱p miŋmadáy iyaac i̱ ictojáy iixcuy. ");
INSERT INTO poiNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Je̱mpɨgam nɨmpa jém cácht́ipɨc id́ɨc ija̱tuŋ con ia̱pa porque icɨ̱ŋyajpa jém judíos. Porque jeeyaj iccám tu̱m orde siiga nɨmpa tu̱m pɨ̱xiñ iga jém Jesús je jém Cristo, jesɨc quebacputta̱p jém sinagoga. ");
INSERT INTO poiNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Jeeyucmɨ nɨmyaj jém pɨ̱xiñ ija̱tuŋ con ia̱pa iga: “Acwaacɨ jém amma̱nɨc porque sɨɨp mɨjam jém amma̱nɨc.” ");
INSERT INTO poiNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Jesɨc jém judíos e̱ybɨct́im iŋwejáypa jém cácht́ipɨc id́ɨc. Nɨ́mayt́a̱: —Anuntawɨ̱aŋmadaayɨ. Jɨ̱sɨ iga Dios taixpa. Odoy amɨgóyaayɨ. Ɨcht́am anjo̱doŋ iga táŋcaɨ́y jém pɨ̱xiñ jém miñɨmpaap iga micpɨs. ");
INSERT INTO poiNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Jesɨc jém cácht́ipɨc id́ɨc iñɨ́máy jém aŋjagooyi: —Ɨch d́a anjo̱doŋ siiga táŋcaɨ́y jém pɨ̱xiñ. Pero annuntawɨ̱jo̱doŋ iga acácht́i id́ɨc y sɨɨp aixixóypam. ");
INSERT INTO poiNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Jesɨc e̱ybɨct́im acwácta̱. Nɨ́mayt́a̱ jém cácht́ipɨc id́ɨc: —¿T́i miwadáy jém pɨ̱xiñ? ¿Jutsa̱ mictojáy jém íñixcuy? ");
INSERT INTO poiNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Jém cácht́ipɨc id́ɨc iñɨ́máy jém aŋjagooyi: —Mannɨ́mayñeum t́i awadáy jém pɨ̱xiñ, pero mimicht́am d́a iŋcupɨctámpa t́i mannɨ́mayñe. ¿T́iiga anacwáctámpa e̱ybɨc? ¿Que michɨ́yt́ooba juuts icuyujcɨɨwiñ? ");
INSERT INTO poiNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Jesɨc agui jóyyaj jém aŋjagooyiyaj. Moj imalmalnɨ́mayyaj jém pɨ̱xiñ. Nɨ́mayt́a̱ jém cácht́ipɨc id́ɨc: —Mimich micuyujcɨɨwiñ jém pɨ̱xiñ. Aɨcht́am jém Moisés acuyujcɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ɨcht́am anjo̱doŋ iga wiñɨgam Dios ijɨ́yáy jém Moisés, pero yɨ́p Jesús ni d́a anjo̱doŋ ju̱t́pɨc pɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Jesɨc jém cácht́ipɨc id́ɨc iñɨ́máy jém aŋjagooyi: —Yɨ́p cosa d́a oypa tánix. Mimicht́am miñɨmtámpa iga iŋcupɨcne Dios, pero d́a iñjo̱doŋtam ju̱t́pɨc pɨ̱xiñ actojáy ánixcuy. ");
INSERT INTO poiNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Taŋwɨ̱jo̱doŋ iga Dios d́a imatóŋáypa tu̱m malopɨc pɨ̱xiñ. Pero siiga tu̱m pɨ̱xiñ ijɨ̱spa Dios y iwatpa juuts ixunpa Dios, jesɨc nu̱ma Dios imatóŋáypa. ");
INSERT INTO poiNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nunca oypa tammatoŋ iga tu̱m pɨ̱xiñ wɨa̱p ictojáy tu̱m cácht́i iixcuy jém cácht́ipɨc miñay. ");
INSERT INTO poiNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Siiga yɨ́p pɨ̱xiñ d́a je de Dios, jesɨc d́a t́i wɨa̱p iwat. ");
INSERT INTO poiNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Jesɨc jeeyaj iñɨ́mayyaj jém pɨ̱xiñ: —Mich tsa̱m pɨ̱mi mit́áŋcaɨ́y miiññay. ¿Que mich sɨɨp anaccuyujtoobam aɨch? Jesɨc quebacputta̱ jém sinagoga jém cácht́ipɨc id́ɨc. ");
INSERT INTO poiNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesɨc Jesús ijo̱dóŋa̱ iga quebacputta̱ jém sinagoga jém cácht́ipɨc id́ɨc. Cuando mipát jém pɨ̱xiñ, jesɨc Jesús iñɨ́máy: —¿Que mich iŋcupɨcpa jém Dios iMa̱nɨc? ");
INSERT INTO poiNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Jém pɨ̱xiñ iñɨ́máy jém Jesús: —MánO̱mi, anɨ́maayɨ: ¿I̱apaap jém Dios iMa̱nɨc iga wɨa̱iñ aŋcupɨc? ");
INSERT INTO poiNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesɨc Jesús iñɨ́máy: —Mich íñixñe. Aɨcham jém Dios aMa̱nɨc jém sɨɨppɨc miniŋmat. ");
INSERT INTO poiNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Jesɨc jém cácht́ipɨc id́ɨc co̱ste̱ññeactɨŋ jém Jesús iwiñjo̱m. Iñɨ́máy: —MánO̱mi, maŋcupɨcpa. ");
INSERT INTO poiNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesɨc Jesús iñɨ́máy jém it́yajwɨɨp je̱m: —Ɨch amiñ yɨ́p naxyucmɨ iga aŋcɨɨpiŋyajpa jém pɨxiñt́am. Amiñ iga ixixóyiñ jém cácht́ipɨc, amiñ iga cácht́ia̱yajiñ jém ixixoypáppɨc. ");
INSERT INTO poiNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Jesɨc algunos jém fariseoyaj jém iwaganait́yajwɨɨp Jesús, cuando imatoŋyaj t́i iŋmadáy, nɨmyaj: —¿Que mijunɨmpa iga aɨcham acácht́it́am? ");
INSERT INTO poiNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesɨc Jesús icutsoŋ. Nɨ́mayyajta̱: —Meega micácht́i, jesɨc d́a i̱ michégáypa jém iñt́áŋca, pero como miñɨmtámpa iga miixixóypa, jesɨc michɨ́yt́ámpa con jém iñt́áŋca. ");
INSERT INTO poiNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","’Nu̱ma mannɨ́máypa, siiga tu̱m pɨ̱xiñ d́a tɨgɨypa jém borrego it́aañi ijɨpjo̱m, pero tɨgɨypa tu̱m áŋe̱ymɨ, jesɨc quejpa iga tu̱m númpaap, pɨ̱mi̱mɨ ininɨgáypa tuŋgac imɨɨchi. ");
INSERT INTO poiNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pero siiga tu̱m pɨ̱xiñ tɨgɨypa jém taañi ijɨpjo̱m, jesɨc quejpa iga jém borrego io̱mi. ");
INSERT INTO poiNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Cuando núc jém borrego io̱mi, jesɨc jém iwatpáppɨc cuenta jém puerta, íŋáypa jém puerta iga tɨgɨ́yiñ jém borrego io̱mi. Jém borregoyaj, jém imɨɨchipɨc, iixpɨcyajpa jém io̱mi. Imatóŋactɨɨyáypa jém io̱mi ijɨ̱yi. Jesɨc jém pɨ̱xiñ iŋwejáypa jém iborregoyaj jém imɨɨchipɨc con iñɨ̱yi. It́oppa jém taañijo̱m. ");
INSERT INTO poiNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Jesɨc cuando yajum it́op it́u̱mpɨy jém iborregoyaj, mojum nɨquiyaj. Jém io̱mi aŋjagoyñeeba iñɨc, jém iborregoyaj it́úŋɨyyajpa porque imatóŋactɨɨyáypa ijɨ̱yi. ");
INSERT INTO poiNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Jém borregoyaj d́a it́úŋɨyyajpa jém tuŋgac pɨ̱xiñ jém d́apɨc iixpɨcpa. Icɨ̱ŋyajpa, cupóyayyajpa porque imatóŋactɨɨyáypa iga d́a je io̱mi ijɨ̱yi. ");
INSERT INTO poiNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesús iŋquejáypa jém pɨxiñt́am con yɨ́p cuento, pero jeeyaj d́a icutɨɨyɨyyajpa t́i iŋmadayt́ooba jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jesɨc Jesús e̱ybɨct́im iŋmadáypa jém pɨxiñt́am. Nɨmpa: —Nu̱ma mannɨ́máypa iga ɨcham jém apuerta ju̱t́ tɨgɨyyajpa jém borregoyaj. ");
INSERT INTO poiNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Jém tuŋgac maestroyaj, jém wiñt́ipɨc miñyaj cuando d́anam anúcne, je jém númyajpaap, pero jém borregoyaj d́a iwadayyajpa caso. ");
INSERT INTO poiNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ɨcham jém apuerta. Siiga i̱ tɨgɨypa con aɨch, jesɨc cɨacputta̱p. Jex juuts tu̱m borrego tɨgɨypa y putpa jém it́aañijo̱m y ipátpa jém wɨ̱tampɨc múc. ");
INSERT INTO poiNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Jém númpaap miñ iga númpa, accaóypa, icujíñáypa jém pɨxiñt́am. Pero ɨch amiñ iga anchiiba jém pɨxiñt́am jém vida iga iniid́iñ jáyaŋ. ");
INSERT INTO poiNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ɨch jém wɨbɨc apastor tsa̱m aŋwɨɨd́a̱p jém amborregoyaj. Jém wɨbɨc pastor nachiit́a̱p iga accaata̱p iga je̱mpɨgam icupujpa jém iborregoyaj. ");
INSERT INTO poiNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Pero jém coñwɨ́yoypaap je̱mpɨc yo̱xa̱p iga yojta̱p, d́a je pastor, d́a imɨɨchi jém borrego. Jesɨc cuando iixpa iga miñpa jém lobo, cɨ̱ŋpa jém pɨ̱xiñ, ichacpa jém borregoyaj, poypa. Jesɨc jém lobo imatspa jém borregoyaj, iccupóyayyajpa. ");
INSERT INTO poiNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Poypa jém yo̱xapaap porque nada más coñwɨ́yóypa, d́a ijɨ̱spa jém borregoyaj, porque d́a je imɨɨchi. ");
INSERT INTO poiNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","’Ɨch jém wɨbɨc apastor. Ánixpɨcpa jém ampɨxiñt́am y jeeyaj aixpɨcyajpat́im aɨch. ");
INSERT INTO poiNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Jext́im juuts jém anJa̱tuŋ Dios aixpɨcpa aɨch y ɨch ánixpɨcpat́im jém anJa̱tuŋ. Ɨch anyaac anachiit́a̱p iga accaata̱p iga je̱mpɨgam aŋcupujpa jém amborregoyaj. ");
INSERT INTO poiNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Anait́t́im tuŋgac jém amborregoyaj, d́a yɨɨmpɨc, ɨch anamiñpat́im. Amatóŋayyajpat́im ɨch anjɨ̱yi, acupɨcpat́im mex jeeyaj. Jesɨc anaŋtuuma̱watpa it́u̱mpɨyyaj iga wagait́yajiñ tu̱mt́i lugar y tu̱mt́i pastor iŋjacyajpa. ");
INSERT INTO poiNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Jém anJa̱tuŋ Dios tsa̱m atoypa porque anyaac anachiit́a̱p iga accaata̱p. Jesɨc ocmɨ anyaact́im ampɨctsoŋpa e̱ybɨc jém amvida. ");
INSERT INTO poiNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Jém ánenemigoyaj d́a wɨa̱p acca, pero ɨch anyaac anjɨ́cpa iga accaata̱p. Ɨch anait́ jém pɨ̱mi iga anyaac anachiit́a̱p iga accaata̱p. Anait́t́im jém pɨ̱mi iga anyaac ampɨctsoŋpa e̱ybɨc jém amvida. Je̱mpɨgam aŋwatpa porque apɨɨmɨ́y jém anJa̱tuŋ Dios. ");
INSERT INTO poiNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jesɨc cuando jém judíos imatoŋyajpa t́i nɨmpa jém Jesús, mojpa áŋa̱jiyaj. Nawécyajta̱p e̱ybɨc. ");
INSERT INTO poiNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Wa̱t́i de jeeyaj nɨmyaj: —¿T́iiga iŋwadayt́ámpa caso? Yɨ́p pɨ̱xiñ iniit́ tu̱m mal espíritu, tsa̱m locoaŋmatpa. ");
INSERT INTO poiNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Pero tuŋgac de jeeyaj nɨmyaj: —Jém iniit́wɨɨp tu̱m mal espíritu d́a wɨa̱p iŋmat jém wɨbɨc aŋma̱t́i juuts iŋmatpa yɨ́p pɨ̱xiñ. Jém mal espíritu d́a wɨa̱p ictojáy tu̱m cácht́i iixcuy. ");
INSERT INTO poiNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Jesɨc núc jém tiempo de sucsuc cuando jém Jerusalénpɨc pɨxiñt́am icusɨ́ŋa̱cayajpa jém mɨjpɨc ma̱stɨc. Watta̱p jém sɨŋ cada a̱mt́ɨy. ");
INSERT INTO poiNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesɨc nɨc Jesús jém mɨjpɨc ma̱stɨcjo̱m, wid́aŋnaspa jém corredor iñɨ̱yi Salomón. ");
INSERT INTO poiNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Jesɨc aŋtuuma̱neyaj tsa̱m jáyaŋ jém judíos, icute̱ñxe̱tyaj jém Jesús. Nɨmyaj jeeyaj: —¿Mii̱apaap? Tsa̱m anjo̱dóŋa̱tooba. Siiga micham miCristo, sɨɨbam nunta aŋma̱tɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesɨc Jesús iñɨ́máy jeeyaj: —Mannɨ́mayñeum iga ɨch aCristo, pero d́a iŋcupɨcta t́i mannɨ́máy. Aŋwat jém milagroyaj con jém anJa̱tuŋ Dios ipɨ̱mi iga wɨ̱quejiñ iga ɨcham aCristo. ");
INSERT INTO poiNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pero mimicht́am d́a iŋcupɨctámpa porque d́a je mamborregotam juuts mannɨ́mayñe pecam. ");
INSERT INTO poiNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ɨch amborregoyaj amatóŋactɨɨyáypa jém anjɨ̱yi y ɨch ánixpɨcpat́im jém amborregoyaj. Jeeyaj atúŋɨyyajpa. ");
INSERT INTO poiNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Anchiiba jém amborregoyaj jém vida jém d́apɨc cuyajpa. Jesɨc d́a nunca togoypa. D́a i̱ wɨa̱p atobáyáy ɨch aŋcɨɨjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Jém anJa̱tuŋ Dios achi jém amborregoyaj y d́a i̱ wɨa̱p atobáyáy jém amborregoyaj jém anJa̱tuŋ Dios icɨɨjo̱m, porque jém anJa̱tuŋ Dios tsa̱m wɨa̱p. Je iniit́ it́u̱mpɨy ipɨ̱mi. ");
INSERT INTO poiNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ɨch con jém anJa̱tuŋ Dios atu̱mt́it́am. ");
INSERT INTO poiNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Jesɨc jém judíos e̱ybɨct́im ipiŋyajpa tsa iga iñácscayajpa tsaamɨ Jesús. ");
INSERT INTO poiNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesɨc Jesús iñɨ́máypa jeeyaj: —Jáyaŋ wɨ̱tampɨc milagro aŋwat mimicht́ámaŋjo̱m jém anJa̱tuŋ Dios ipɨ̱mi̱mɨ. ¿Jup milagro anaŋnúcpa iga annácscatámpa tsaamɨ? ");
INSERT INTO poiNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Jesɨc jém judíos iñɨ́mayyaj Jesús: —D́a mannácscatámpa tsaamɨ iga iŋwatne jém wɨ̱tampɨc milagro. Mannácscatámpa tsaamɨ iga iŋcujɨypa tanDios. Mich mipɨ̱xiñ, pero miñɨmpa iga mich miDios. ");
INSERT INTO poiNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesɨc Jesús iñɨ́máy jeeyaj: —¿Que d́a jayñeta̱wum jém Moisés iŋquímayooyi iga nɨmpa Dios: “Mimicht́am midiostam”? ");
INSERT INTO poiNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Siiga icnɨɨya̱ jeeyaj iga diosyaj jém ipɨctsoŋneyajwɨɨp jém Dios iŋma̱t́i, y d́a i̱ wɨa̱p ictogoy jém Dios iŋma̱t́i jém jaychacneta̱wɨɨp, ");
INSERT INTO poiNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","¿jesɨc t́iiga miñɨmtámpa iga ɨch aŋcujɨypa Dios cuando anɨmpa iga: “Ɨch jém Dios aMa̱nɨc”? Porque Dios acupiŋ y acutsat yɨ́p naxyucmɨ iga aŋwad́iñ juuts je iwɨ̱aŋja̱m. ");
INSERT INTO poiNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Siiga ɨch d́a aŋwatpa jém wɨbɨc milagro juuts iwatpa jém anJa̱tuŋ Dios, jesɨc odoy acupɨctaamɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pero siiga ɨch aŋwatpa jém wɨ̱tampɨc milagro juuts iwatpa Dios y mimicht́am d́a iŋcupɨctámpa t́i mannɨ́máypa, jesɨc cupɨ̱cɨ iga d́a je mɨgooyi jém milagroyaj iga wɨa̱iñ iŋcutɨɨyɨyt́a iga jém anJa̱tuŋ Dios it́ con aɨch y ɨch ait́ con anJa̱tuŋ Dios. ");
INSERT INTO poiNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Jesɨc jeeyaj e̱ybɨct́im imatsyajtooba jém Jesús, pero cɨɨput, d́a wɨa̱ mimatsyaj. ");
INSERT INTO poiNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","E̱ybɨct́im nɨc Jesús jém nɨ aŋwiñt́uc iñɨ̱yi Jordán. Jemum tsɨ́y Jesús ju̱t́ moj acchíŋooyi jém Xiwan. ");
INSERT INTO poiNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Jesɨc tsa̱m jáyaŋ pɨxiñt́am nɨc iámyaj jém Jesús. Nɨmyajpa jeeyaj: —Jém Xiwan, jém acchíŋoypáppɨc, d́a iwat ni tu̱m milagro. Pero jém Xiwan d́a tamɨgóyáy cuando taŋmadáy t́i iwatpa yɨ́p pɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Jemum tsa̱m jáyaŋ jém pɨxiñt́am icupɨcyaj jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Jesɨc mɨmne tu̱m pɨ̱xiñ iñɨ̱yi Lázaro jém attebet Betania. Yɨ́p jém attebet ju̱t́ it́ jém Malía con it́ɨ̱wɨ jém Marta. ");
INSERT INTO poiNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Yɨ́pt́im Malía jém iccámayñewɨɨp jém pomada jém cɨ̱npaap jém tánO̱mi Jesús ipuyyucmɨ y icujicháyáy ipuy con iway. Jém mɨmnewɨɨp, jém Lázaro, it́ɨ̱wɨt́im jém Malía. ");
INSERT INTO poiNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Jesɨc jém Malía y Marta icutsadáy aŋma̱t́i jém Jesús. Iñɨ́máy: —MánO̱mi, mɨmneactɨŋ jém pɨ̱xiñ, jém iñt́oypáppɨc. ");
INSERT INTO poiNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Mu imatoŋ jém Jesús iga mɨmne jém iamigo, nɨmpa: —Yɨ́p caacuy d́a iccaaba. Imats yɨ́p caacuy iga ixt́a̱iñ jém Dios ipɨ̱mi y iga ixt́a̱iñt́im jém Dios iMa̱nɨc ipɨ̱mi. ");
INSERT INTO poiNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesús tsa̱m it́oypa jém Marta, jém Malía y jém Lázaro. ");
INSERT INTO poiNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Mu imatoŋ Jesús iga mɨmne jém Lázaro, jesɨc d́a jobit́ nɨc iám, jemum tsɨ́y tuŋgac wɨsnaja̱ma. ");
INSERT INTO poiNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Jesɨc cuando nasneum wɨsnaja̱ma, Jesús iñɨ́máy jém icuyujcɨɨwiñ: —Tanɨctámpa e̱ybɨc jém naxyucmɨ de Judea. ");
INSERT INTO poiNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Jém Jesús icuyujcɨɨwiñ iñɨ́mayyaj: —MamMaestro, jém Judeapɨc pɨxiñt́am d́a más pecam miñácscatooba id́ɨc tsaamɨ. ¿Que miñɨcgacpa e̱ybɨc? ");
INSERT INTO poiNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesús iñɨ́máy jém icuyujcɨɨwiñ: —Tu̱m ja̱ma iniit́ doce hora. Siiga tu̱m pɨ̱xiñ wit́pa sɨŋñi, jesɨc d́a iñeppa ipuy iga tsutpa porque iguixixóypa jém ja̱ma jém icuyɨcquejpaap yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pero siiga tu̱m pɨ̱xiñ wit́pa tsuucɨɨm, jesɨc tsutpa porque d́a i̱ jém ja̱ma iga iyɨcquejpa. ");
INSERT INTO poiNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jesɨc ocmɨ e̱ybɨct́im nɨmpa Jesús: —Moŋpa sɨɨp jém tánamigo Lázaro, pero nɨcpa antsɨcyus. ");
INSERT INTO poiNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Jesɨc Jesús icuyujcɨɨwiñ iñɨ́mayyaj: —MánO̱mi, siiga moŋpa jém Lázaro, jesɨc tanjo̱doŋ iga pɨspa. ");
INSERT INTO poiNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Nɨmtooba Jesús iga caaneum jém Lázaro, pero jém icuyujcɨɨwiñ iŋja̱mpa iga nunta moŋpa. ");
INSERT INTO poiNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Jesɨc Jesús iñuumaŋmadáy jém icuyujcɨɨwiñ. Nɨ́mayyajta̱: —Caaneum jém Lázaro. ");
INSERT INTO poiNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ɨch amaymay iga d́a ai̱ cuando ca jém Lázaro porque sɨɨp más wɨ̱ para mimicht́am. Más iŋcupɨctámpa Dios. Jesɨc nɨcpa tánám jém Lázaro. ");
INSERT INTO poiNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Jesɨc jém Tomax, iñɨ̱yit́im Me̱chi, iñɨ́máy los de más jém Jesús icuyujcɨɨwiñ: —Tanɨctámpat́im iga taŋwaganacaaba jém tánO̱mi. ");
INSERT INTO poiNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jesɨc cuando núc Jesús jém Betania, ijo̱dóŋa̱ iga cuatro ja̱ma cumneta̱wum jém Lázaro imɨjta̱y tu̱m tsaajosjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Jém Betania noco it́ jém attebet Jerusalén, ijuumɨ como dos kilómetro y medio. ");
INSERT INTO poiNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Jesɨc tsa̱m jáyaŋ jém judíos nɨc iámyaj jém Marta y Malía iga icpócsayyajpa ia̱nama iga odoy aŋyáguiñ porque caane jém it́ɨ̱wɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Cuando imatoŋ jém Marta iga miñpa jém Jesús, jesɨc nɨc iméts tuŋjo̱m. Tsɨ́y jém Malía it́ɨccɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mu iñúc ju̱t́ it́ Jesús, nɨmpa jém Marta: —MánO̱mi, meega miit́ yɨɨm cuando mɨmneactɨŋ jém antɨ̱wɨ, jesɨc d́a id́ɨc ca. ");
INSERT INTO poiNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pero ɨch anjo̱doŋ iga Dios michiiba sɨɨp t́it́am iŋwágáypa. ");
INSERT INTO poiNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesɨc Jesús iñɨ́máy jém Marta: —Pɨspa jém iñt́ɨ̱wɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Jesɨc Marta iñɨ́máy jém Jesús: —Anjo̱doŋ iga pɨspa jém antɨ̱wɨ cuando pɨsyajpa jém caaneyajwɨɨp jém íŋaŋpɨgam ja̱ma. ");
INSERT INTO poiNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesús iñɨ́máy jém Marta: —Ɨch wɨa̱p anacpɨs jém caaneyajwɨɨp. Wɨa̱p anchi i̱ quej jém vida jém d́apɨc cuyajpa. Siiga tu̱m pɨ̱xiñ acupɨcpa aɨch, aunque caaneum, pɨspa. ");
INSERT INTO poiNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Siiga vivonam tu̱m pɨ̱xiñ jém íŋaŋpɨgam ja̱ma y acupɨcpa aɨch, jesɨc d́a nunca caaba. ¿Que d́a iŋcupɨcpa yɨ́p aŋma̱t́i? ");
INSERT INTO poiNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Jesɨc jém Marta iñɨ́máy jém Jesús: —Nu̱ma, mánO̱mi, ɨch aŋcupɨcpa iga micham miCristo jém Dios miMa̱nɨc. Mich jém mimiññewɨɨp naxyucmɨ, jém anaŋjócnetaŋwɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Cuando yaj iŋmat je̱mpɨc jém Marta, nɨc iŋwejáy it́ɨ̱wɨ jém Malía. Iyamnɨ́máy: —Núcneum jém tamMaestro, sɨɨp miŋwejáypa. ");
INSERT INTO poiNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Jesɨc mu imatoŋ jém Malía, jicscɨy tsucum, nɨc iám jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","D́anam núcne Jesús jém tɨgaŋjoj. Tsɨ́yñe je̱mt́im ju̱t́ oy ictsɨ́y jém Marta. ");
INSERT INTO poiNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Jesɨc jém judíos, jém it́yajwɨɨp jém Marta it́ɨccɨɨm iga icpócsayyajpa ia̱nama, iixyaj iga agui jicscɨy nɨc jém Malía. Jesɨc jeeyaj it́úŋɨyyajpa. Iŋja̱myaj iga nɨc we̱ji jém Malía jém tsaajoscɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Jesɨc jém Malía, mu iñúc ju̱t́ it́ jém Jesús, ico̱steeñáy ipuycɨɨm. Nɨmpa jém Malía: —MánO̱mi, meega miit́ cuando mɨmneactɨŋ jém antɨ̱wɨ, d́a id́ɨc ca. ");
INSERT INTO poiNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Cuando iix Jesús iga tsa̱m wejpa jém Malía y wejyajpat́im mex jém judíos, pɨ̱mi aŋyác jém Jesús, tsa̱m ija̱mpa jém aŋyaaqui ia̱namaŋjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Jesɨc Jesús icwác, iñɨ́máy: —¿Ju̱t́ iñchac jém imɨjta̱y? Nɨmyaj jeeyaj: —MánO̱mi, mi̱ñɨ aamɨ ju̱t́ it́. ");
INSERT INTO poiNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Wej jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Jesɨc nɨmyaj jém judíos: —I̱xɨ. Tsa̱m pɨ̱mi it́oypa jém iamigo. ");
INSERT INTO poiNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Pero jém tuŋgac nɨmyaj: —Yɨ́p pɨ̱xiñ ictojáy jém cácht́i iixcuy, ¿t́iiga d́a icpɨspa jém Lázaro iga odoy caiñ? ");
INSERT INTO poiNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesɨc e̱ybɨct́im pɨ̱mi aŋyácne jém Jesús, tsa̱m pɨ̱mi ija̱mpa jém aŋyaaqui ia̱namaŋjo̱m. Núc jém tsaajoscɨɨm ju̱t́ cumneta̱ jém Lázaro. Aŋnúcneta̱ jém tsaajos con tu̱m mɨjpɨc tsa. ");
INSERT INTO poiNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesɨc Jesús iñɨ́máy jém pɨxiñt́am: —Accáyaayɨ yɨ́p tsa. Jém Marta, jém caanewɨɨp it́ɨ̱wɨ, iñɨ́máy jém Jesús: —Pero mánO̱mi, sɨɨp iniit́um cuatro ja̱ma caane, tsa̱m aŋjejpam. ");
INSERT INTO poiNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesús iñɨ́máy jém Marta: —¿Que d́a mannɨ́máy siiga iŋcupɨcpa iga ɨch wɨa̱p manyo̱xpát, jesɨc íñixáypa jém tanJa̱tuŋ Dios ipɨ̱mi? ");
INSERT INTO poiNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Jesɨc jém it́yajwɨɨp iccáyayyaj jém tsa. Ámquím Jesús sɨŋyucmɨ, moj iŋwejpát Dios. Nɨmpa: —ManJa̱tuŋ Dios, iyucuɨpdios iga mich ammatóŋayñe t́i mannɨ́máy. ");
INSERT INTO poiNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Anjo̱doŋ iga siempre mich ammatoŋpa, pero mannɨ́máypa yɨɨmpɨc iga jém pɨxiñt́am wɨa̱iñ icutɨɨyɨyyaj iga mich aŋcutsatne yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Jesɨc cuando yaj iŋwejpát Dios, pɨ̱mi jɨypa jém Jesús. Nɨmpa: —MiLázaro, pu̱tɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Jesɨc putum jém Lázaro, jém caanewɨ́ppɨc id́ɨc. Aŋmónayñeta̱ icɨ y ipuy con puctu̱cu. Aŋmónayñeta̱t́im ico̱bac con tu̱m puctu̱cu. Jesɨc Jesús iñɨ́máy jém pɨxiñt́am: —¡Cuwijáyaayɨ jém iŋmónóycuy, cutsɨgaayɨ! ");
INSERT INTO poiNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Cuando iixyaj t́i iwat jém Jesús, jesɨc moj icupɨcyaj jáyaŋ jém judíos jém miññeyajwɨɨp iám jém Malía. ");
INSERT INTO poiNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pero algunos nɨc iámyaj jém fariseoyaj iga iŋmadáypa t́i iwat jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Jesɨc jém co̱bacpɨc pa̱nijyaj, con jém fariseoyaj, iŋtuuma̱watyaj jém Sanhedrín, jém wɨd́ayt́am. Nɨmyaj: —¿T́i wɨa̱p taŋwatta con yɨ́p pɨ̱xiñ? Tsa̱m jáyaŋ milagro iwat. ");
INSERT INTO poiNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Siiga seguido tanjɨ́cpa iga iwatpa jém milagroyaj, jesɨc núcpa jém ja̱ma iga it́u̱mpɨy jém pɨxiñt́am icupɨcyajpa yɨ́p Jesús. Jesɨc jém Romapɨc aŋjagooyi icutsadáypa jém soldado iga imɨswadayyajpa jém mɨjpɨc ma̱stɨc y imɨɨcha̱p jém tannas. ");
INSERT INTO poiNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Jesɨc tu̱m de jeeyaj, jém Caifás, co̱bacpɨc pa̱nij jém a̱mt́ɨy, moj aŋma̱t́i con jém aŋjagooyiyaj jém aŋtuuma̱neyajwɨɨp. Nɨmpa jém Caifás: —Mimicht́am d́a t́i iñjo̱doŋtam. ");
INSERT INTO poiNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","D́at́im iŋcutɨɨyɨyt́a iga más wɨ̱ iga accaata̱p tu̱m pɨ̱xiñ para it́u̱mpɨy jém pɨxiñt́am iga odoy togóyiñ jém tannaxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Jém Caifás d́a ijɨ̱xquím iyaac, pero Dios ichi jém jɨ̱xi porque je jém co̱bacpɨc pa̱nij. Jeeyucmɨ jém Caifás wɨa̱p iŋmadáy jém pɨxiñt́am iga accaata̱p jém Jesús iga iyo̱xpátpa it́u̱mpɨy jém it́yajwɨɨp jém naxyucmɨ Israel. ");
INSERT INTO poiNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","D́a solamente iga iyo̱xpátpa jém it́yajwɨɨp Israel, pero accaata̱p jém Jesús iga iŋtuuma̱watyajpa it́u̱mpɨy jém icupɨcneyajwɨɨp Dios ju̱t́quej icutero yɨ́p mundo. ");
INSERT INTO poiNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Jesɨc jeet́im ja̱ma jém aŋjagooyiyaj moj ijɨ̱syaj ju̱t́pɨc iccaayajpa jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Jeeyucmɨ jém Jesús d́a sɨɨba ju̱t́ iixpa jém judíos. Put jém naxyucmɨ de Judea. Nɨc i̱t́i tuŋgac lugar nocojo̱m jém tɨtsɨnaxyucmɨ. Jém attebet iñɨ̱yi Efraín. Jemum nɨc i̱t́iyaj Jesús con icuyujcɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Núctooba jém pascuasɨŋ jém iwatyajpáppɨc jém judíos. Icuwɨ̱t́i jém naxyucmɨ de Israel tsucumyaj jáyaŋ jém pɨxiñt́am iga nɨcyajpa jém attebet Jerusalén iga iwatyajpa jém costumbre iga cuáyñeiñ ia̱nama antes que núcpa jém pascuasɨŋ. ");
INSERT INTO poiNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Jesɨc cuando núcyaj Jerusalén jém pɨxiñt́am, imétsyajpa jém Jesús. Tɨgɨyyaj jém ma̱stɨcjo̱m, moj nanɨ́mayyajta̱ji entre jeeyaj: —¿Que tanaŋja̱m iga miñpa sɨŋa̱ji jém Jesús o d́a miñpa? ");
INSERT INTO poiNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Jesɨc jém co̱bacpɨc pa̱nijyaj con jém fariseoyaj tsa̱m imatsyajtooba jém Jesús. Ipɨɨmɨyyaj jém pɨxiñt́am, nɨ́mayyajta̱: —Siiga i̱ ijo̱doŋ ju̱t́ it́ jém Jesús, jesɨc acjo̱dóŋa̱jɨ jém tanaŋjagooyi iga matsta̱iñ. ");
INSERT INTO poiNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Jesɨc seis día antes que naspa jém pascuasɨŋ, nɨc jo̱yi Jesús jém attebet Betania ju̱t́ it́ jém Lázaro, jém icpɨsnewɨɨp jém Jesús de ju̱t́ it́ jém caaneyajwɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Jém iamigoyaj inisɨ́ŋa̱p jém Jesús. Jém Marta icwícpa jém miññeyajwɨɨp. It́t́im jém Lázaro. Iwaganawícyajpa jém Jesús mesacɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Jém Malía inimiñ tu̱m libra jém wɨbɨc perfume, naps nardo, jém cɨ̱npáppɨc, jém aguipɨc tsoowɨ́y. Iccámáy jém perfume jém Jesús ipuyyucmɨ. Ocmɨ jém Malía icujicháyáypa jém Jesús ipuy con iway. Agui cɨ̱npa jém perfume, comne jém tɨc de cɨ̱ñi. ");
INSERT INTO poiNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","It́t́im tu̱m de jém Jesús icuyujcɨɨwiñ, jém Judas Iscariote, jém Ximoj Iscariote ima̱nɨc, jém iwadaypáppɨc atraición jém Jesús. Nɨm jém Judas: ");
INSERT INTO poiNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿T́iiga d́a tammáypa yɨ́p wɨbɨc perfume? Ivale tres cientos tumiñ de plata. Jesɨc wɨa̱p tanyo̱xpát jém yaacha̱yajpáppɨc. ");
INSERT INTO poiNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Jém Judas d́a iyaachaŋja̱mpa jém yaacha̱yajpáppɨc, pero nɨmpa je̱mpɨc porque númpa jém pɨ̱xiñ. Iwatpa cuenta jém tumiñ ibolsa y siempre iñúmpa jém tumiñ. ");
INSERT INTO poiNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Nɨmpa Jesús: —Odoy moogɨɨyɨ yɨ́p yo̱mo. Iccáyñe id́ɨc jém perfume iga accámáypa cuando acu̱mta̱p. ");
INSERT INTO poiNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Siempre it́yaj con mimicht́am jém yaacha̱yajpáppɨc, pero ɨch d́a seguido ait́pa con mimicht́am. ");
INSERT INTO poiNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jesɨc jáyaŋ jém Jerusalénpɨc pɨxiñt́am ijo̱dóŋa̱yaj iga jemum it́ jém Jesús. Jesɨc nɨc iámyaj. D́a no más nɨc iámyaj jém Jesús, pero iixyajtoobat́im jém Lázaro jém acpɨsneta̱wɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Jesɨc jém pa̱nij aŋjagooyiyaj iwatyajpa acuerdo iga iccaayajpat́im jém Lázaro. ");
INSERT INTO poiNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Porque cuando jém judíos iixyaj iga nu̱ma acpɨsneta̱ jém Lázaro, jesɨc jáyaŋ ichacyajpa jém Israelpɨc aŋquímayooyi, mojpa icupɨcyaj jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Jém tuŋgac ja̱ma jáyaŋ pɨxiñt́am nɨcne sɨ́ŋa̱jiyaj jém attebet Jerusalén. Iwatyajpa jém pascuasɨŋ. Cuando ijo̱dóŋa̱yaj iga núcpa Jerusalén jém Jesús, ");
INSERT INTO poiNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","jesɨc it́úcyaj jáyaŋ jém suyat iay. Nɨc imétsyaj jém Jesús tuŋjo̱m. Mu ipátyaj, tsa̱m icujípyajpa. Pɨ̱mi jɨyyajpa jém pɨxiñt́am. Nɨmyajpa: —¡Hosanna! ¡Agui wɨ̱ jém tanJa̱tuŋ Dios! ¡Taŋcujíptámpa jém Rey de Israel jém miññewɨɨp jém tanJa̱tuŋ Dios iñɨyi̱mɨ! ");
INSERT INTO poiNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesɨc jém Jesús ipát tu̱m ma̱ñburro. Iquímca. Iwat juuts jayñeta̱: ");
INSERT INTO poiNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Odoy cɨ̱ŋtaamɨ miit́t́aŋwɨɨp jém attebet Sión. Ixt́aamɨ iga sɨɨp miñpa jém iñRey. Iquímcane tu̱m ma̱ñburro. ");
INSERT INTO poiNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Wiñt́i jém Jesús icuyujcɨɨwiñ d́a icutɨɨyɨyyajpa, pero ocmɨ cuando pɨsneum y químgac sɨŋyucmɨ jém Jesús, ijɨ̱syajpa iga je̱mpɨgam nɨmpa jém Dios iŋma̱t́i y je̱mpɨgam iñascaaba jém Jesús cuando núcpa Jerusalén. ");
INSERT INTO poiNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jo̱dóŋa̱ta̱p ju̱t́quej t́i iwat jém Jesús mu iŋwejáy jém Lázaro jém tsaajosjo̱m ju̱t́ cumne. Jém it́yajwɨɨp con Jesús cuando pɨs jém Lázaro, iŋmadayyaj i̱ quej t́i iixyaj. ");
INSERT INTO poiNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Jeeyucmɨ miñ iámyaj Jesús tsa̱m jáyaŋ jém pɨxiñt́am porque imatoŋyaj iga iwat jém milagro. ");
INSERT INTO poiNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Jesɨc jém fariseoyaj nanɨ́mayyajta̱p: —Sɨɨp quejpa iga d́a t́i wɨa̱p taŋwatta. I̱xɨ, it́u̱mpɨy jém pɨxiñt́am icuwɨ̱t́i yɨ́p naxyucmɨ it́úŋɨyyajpa. ");
INSERT INTO poiNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Miñyajt́im sɨ́ŋa̱jiyaj algunos jém pɨxiñt́am jém aŋmatyajpaap jém aŋma̱t́i griego. Miñyaj Jerusalén iga ijɨ̱syajpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Jeeyaj nɨc iámyaj jém Felipe, jém miññewɨɨp jém attebet Betsaida jém naxyucmɨ de Galilea. Jém griegopɨc pɨxiñt́am icunucsayyaj jém Felipe. Nɨ́mayt́a̱: —Awadaayɨ tu̱m favor. Nɨ̱gɨ nɨ́maayɨ jém Jesús iga tsa̱m anjɨypáttooba. ");
INSERT INTO poiNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Jesɨc jém Felipe nɨc iŋmadáy jém Anti t́i ixunpa jém griegopɨc pɨxiñt́am. Jesɨc iwagananɨcyaj jém Anti y jém Felipe iga iŋmadayyaj Jesús t́i ixunpa jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesɨc jém Jesús iñɨ́máy jém icuyujcɨɨwiñ: —Núcneum jém tiempo iga ɨch, jém aMiññewɨɨp Sɨŋyucmɨ, ampɨctsoŋpa e̱ybɨc jém ampɨ̱mi jém anait́wɨɨp id́ɨc sɨŋyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nu̱ma mannɨ́máypa siiga tu̱m pac d́a ñipta̱p nascɨɨm ju̱t́ caaba ima̱yi, jesɨc tsɨ́ypa icut́um. Pero siiga caaba ima̱yi, jesɨc jáyaŋa̱p. ");
INSERT INTO poiNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Siiga tu̱m pɨ̱xiñ tsa̱m it́oypa ivida yɨ́p naxyucmɨ, jesɨc togoypa ivida. Pero siiga tu̱m pɨ̱xiñ d́a it́oypa ivida yɨ́p naxyucmɨ, jesɨc d́a togoypa ivida, iniit́pa para it́u̱mpɨy tiempo. ");
INSERT INTO poiNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Siiga tu̱m pɨ̱xiñ acuyo̱xatooba, jesɨc ansunpa iga atúŋɨ́yiñ, jesɨc je̱mt́im ju̱t́ ait́pa aɨch it́pat́im jém acuyo̱xapáppɨc. Siiga tu̱m pɨ̱xiñ acuyo̱xa̱p aɨch, jesɨc jém anJa̱tuŋ Dios iwɨ̱ixpa jém pɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Sɨɨp tsa̱m aŋyácne. ¿Que t́i wɨa̱p annɨ́máy jém anJa̱tuŋ? Ɨch d́a annɨ́máypa jém anJa̱tuŋ Dios iga: “ManJa̱tuŋ, ayo̱xpaatɨ iga odoy ayaachwatta̱iñ”. D́a aŋwatpa je̱mpɨc porque ɨch amiñ yɨ́p naxyucmɨ iga ayaachwatta̱iñ. Jesɨc annɨ́máypa iga: ");
INSERT INTO poiNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","“ManJa̱tuŋ Dios, wa̱tɨ juuts mich iñxunpa iga jém pɨxiñt́am micujípyajiñ”. Jesɨc jɨypa Dios sɨŋyucmɨ. Nɨmpa: —Sɨɨp aŋwatneum y aŋwatpat́im e̱ybɨc iga acujípyajiñ jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Jesɨc jém pɨxiñt́am, jém aŋtuuma̱neyajwɨɨp, imatoŋyaj jém jɨ̱yi. Nɨmyajpa iga t́i̱ñpa jém majɨywiñ. Pero tuŋgac nɨmpa: —Ijɨ́yáy tu̱m sɨŋyucmɨpɨc pɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesɨc Jesús iñɨ́máy jém pɨxiñt́am: —Tammatoŋneta yɨ́p jɨ̱yi mimicht́am iŋcuyucmɨ, d́a para ɨch, iga iŋcutɨɨyɨyt́ámiñ t́i iwatpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Sɨɨp núcpa jém hora iga cɨɨpiŋta̱p jém it́yajwɨɨp yɨ́p naxyucmɨ. Sɨɨp accáyayt́a̱p ipɨ̱mi jém Woccɨɨwiñ, jém iŋjacnewɨɨp yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Pero ɨch cuando acquímta̱p cunusyucmɨ, jesɨc anchiiba jɨ̱xi jém pɨxiñt́am iga acupɨguiñ. ");
INSERT INTO poiNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Cuando iŋmatpa je̱mpɨc jém Jesús, iŋquejáypa jém pɨxiñt́am iga accaata̱p cunusyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Jesɨc jém pɨxiñt́am iñɨ́mayyaj jém Jesús: —Tammatoŋne iga nɨmpa jém Dios iŋma̱t́i iga it́pa jém Cristo para it́u̱mpɨy tiempo. ¿Jesɨc t́iiga miñɨmpa iga accaata̱p cunusyucmɨ jém Miññewɨɨp Sɨŋyucmɨ? Anɨ́maayɨ: ¿I̱apaap jém Miññewɨɨp Sɨŋyucmɨ? ");
INSERT INTO poiNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesɨc Jesús iñɨ́máypa jeeyaj: —Jém juctɨaŋtso̱ca poy it́ tu̱m rato con mimicht́am. Wit́t́aamɨ iganam it́ jém juctɨaŋtso̱ca iga odoy mictsɨ́yiñ jém piichɨ. Porque jém wit́páppɨc jém piichcɨɨm d́a ijo̱doŋ ju̱t́ nɨcpa. ");
INSERT INTO poiNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Iganam it́pa jém juctɨaŋtso̱ca, jesɨc acupɨctaamɨ aɨch iga iniit́t́ámiñt́im jém juctɨaŋtso̱ca jém íña̱namaŋjo̱m. Jesɨc cuando yaj nɨ̱mi jém Jesús, nɨc iyámáy jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Tsa̱m jáyaŋ milagro y seña iwat Jesús jém pɨxiñt́ámaŋjo̱m, pero jeeyaj d́a icupɨcyajpa iga je jém Cristo. ");
INSERT INTO poiNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Iwatyajpa je̱mpɨc iga cupaguiñ jém aŋma̱t́i jém ijaychacnewɨɨp jém wiñɨcpɨc profeta jém Isaías. Nɨmpa: ManJa̱tuŋ Dios, mich iniŋquejáy jém pɨxiñt́am jém impɨ̱mi, pero d́a i̱ icupɨcpa mich iniŋma̱t́i jém anamiññewɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Jeeyucmɨ jém Israelpɨc pɨxiñt́am d́a icupɨcyajpa jém Cristo, porque nɨmt́im jém Isaías: ");
INSERT INTO poiNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Dios icácht́iwatpa jém pɨxiñt́am, ica̱mamwadáy ico̱bac iga mást́im d́a wɨa̱p icutɨɨyɨyyaj jém Dios iŋma̱t́i. Je̱mpam iwat Dios iga jém pɨxiñt́am d́a t́i iixyajpa iixcuymɨ ni d́a wɨa̱p icutɨɨyɨyyaj ia̱namaŋjo̱m iga Dios iwɨ̱wadayt́ooba id́ɨc. D́at́im wɨa̱p ichacyaj jém malopɨc ijɨ̱xi iga Dios iccáyáyiñ it́áŋca. ");
INSERT INTO poiNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Wɨa̱ iŋmat je̱mpɨc jém Isaías porque wiñɨgam iix jém Cristo ipɨ̱mi. Ijaychacne t́i iñascaaba jém Cristo cuando miñpa yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Pero d́a it́u̱mpɨy jém Israelpɨc pɨxiñt́am cuɨ̱xayaj. Jáyaŋ icupɨcyaj, hasta algunos jém aŋjagooyiyaj icupɨcyajt́im jém Jesús. Pero iga tsa̱m icɨ̱ŋyajpa jém fariseoyaj jesɨc iŋyampa iga icupɨcne. Icɨ̱ŋyajpa iga quebacputyajta̱p jém sinagoga. ");
INSERT INTO poiNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Más iwɨ̱aŋja̱myaj iga cujípyajta̱iñ yɨ́p naxyucmɨ que iga Dios icujíppa. ");
INSERT INTO poiNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesɨc ocmɨ pɨ̱mi jɨypa jém Jesús. Nɨmpa: —Siiga i̱ acupɨcpa aɨch, jesɨc icupɨcpat́im mex jém anJa̱tuŋ Dios jém acutsatnewɨɨp yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Jém aixpáppɨc aɨch, iixpat́im mex jém anJa̱tuŋ Dios jém acutsatnewɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ɨch, jém ajuctɨaŋtso̱ca, amiñ yɨ́p naxyucmɨ iga it́u̱mpɨy jém acupɨcyajpáppɨc aɨch, d́a tsɨ́yyajpa piichcɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Siiga i̱ imatoŋpa ɨch anaŋma̱t́i, pero d́a icupɨcpa, jesɨc ɨch anyaac d́a anchiiba jém icastigo. Ɨch d́a amiñ iga acɨɨpíŋóypa. Amiñ iga aŋcɨacputpa jém it́yajwɨɨp yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Siiga tu̱m pɨ̱xiñ ajóyixpa y d́a iwatpa juuts nɨmpa ɨch anaŋma̱t́i, jesɨc jém íŋaŋpɨgam ja̱ma ɨch anaŋma̱t́i tsɨ́ypa juuts tu̱m juez. Jeet́im anaŋma̱t́i icɨɨpiŋpa y ichiiba castigo jém d́apɨc ipɨctsoŋpa ɨch anaŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ɨch anyaac d́a anjɨ̱xquímpa jém anaŋma̱t́i, pero jém anJa̱tuŋ Dios jém acutsatnewɨɨp anɨ́máy jutsa̱p anaŋmat jém aŋma̱t́i y t́i anaŋquejáypa jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ɨch anjo̱doŋ iga jém anJa̱tuŋ Dios iŋquímayooyi ichiiba jém pɨxiñt́am jém vida jém d́apɨc cuyajpa. Jeeyucmɨ anaŋmatpa jém anaŋma̱t́i juuts anɨ́mayñe jém anJa̱tuŋ Dios. ");
INSERT INTO poiNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Jesɨc núctooba jém ja̱ma iga jém Israelpɨc pɨxiñt́am iwatyajpa jém pascuasɨŋ. Ijo̱doŋ Jesús iga núcneum jém hora iga nɨcgacpa sɨŋyucmɨ ju̱t́ it́ iJa̱tuŋ Dios. Jém Jesús tsa̱m pɨ̱mi it́oypa jém it́úŋɨyyajwɨɨp, jém imɨɨchipɨc, d́a nunca ichacpa iga it́oypa. ");
INSERT INTO poiNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jesɨc iganam wícmoŋyajpa Jesús con jém icuyujcɨɨwiñ, jém Woccɨɨwiñ iccám jém malopɨc jɨ̱xi jém Judas Iscariote ia̱namaŋjo̱m iga iwadáypa atraición jém Jesús. Yɨ́p Judas jém Ximoj ima̱nɨc. ");
INSERT INTO poiNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ijo̱dóŋa̱ Jesús iga jém iJa̱tuŋ Dios icɨɨjuŋcodáy it́u̱mpɨy cosa icɨɨjo̱m. Ijo̱doŋt́im iga miñ de Dios y e̱ybɨc nɨcpa ju̱t́ it́ Dios. ");
INSERT INTO poiNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Cuando yajtoobam wiiquiyaj, te̱ñchucum jém Jesús, ichac iyoot́i, ipɨc tu̱m toalla, iwoycunúc jém imɨjpacyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","It́ec nɨ tu̱m palanganajo̱m, moj icheáy ipuy jém icuyujcɨɨwiñ. Ocmɨ icujicháyáypa ipuy con jém toalla jém iwoycunúcnewɨɨp jém imɨjpacyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Cuando núc Jesús ju̱t́ it́ jém Peto, jesɨc Peto iñɨ́máy: —MánO̱mi, ¿que mich antseáypat́im ampuy? ");
INSERT INTO poiNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Nɨmpa Jesús: —Sɨɨp d́a iŋcutɨɨyɨ́ypa t́iiga mantseayt́ámpa jém impuy, pero ocmɨ iŋcutɨɨyɨyt́ámpa. ");
INSERT INTO poiNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Jesɨc jém Peto iñɨ́máypa jém Jesús: —Mich d́a nunca manjɨ́gáypa iga antseáypa ampuy. Jesɨc nɨmpa Jesús: —Siiga d́a mantseáypa impuy, jesɨc d́a je mammɨɨchi. ");
INSERT INTO poiNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Jesɨc Peto iñɨ́máy jém Jesús: —MánO̱mi, atseaayɨ ampuy. Atseaayɨt́im jém aŋcɨ y aŋco̱bac. ");
INSERT INTO poiNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesɨc iñɨ́máy Jesús: —Siiga yaguiñ chiŋne tu̱m pɨ̱xiñ, jesɨc d́a ixunpa iga chiŋpa e̱ybɨc. No más ixunpa iga icheeba ipuy porque cuáyñeum icutero. Mimicht́am micuáyñeum, pero tu̱m de mimicht́am, jém maŋcuyujcɨɨwiñ, d́a micuáyñe. ");
INSERT INTO poiNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Porque jém Jesús ijo̱doŋ i̱apaap iwadáypa atraición. Jeeyucmɨ nɨmpa Jesús iga: “D́a iñt́u̱mpɨyt́am micuáyñeta.” ");
INSERT INTO poiNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Cuando yaj icheáy jém icuyujcɨɨwiñ ipuy, jesɨc jém Jesús icot iyoot́i, e̱ybɨct́im co̱ñ jém mesacɨɨm. Iñɨ́máy jém icuyujcɨɨwiñ: —¿Iŋcutɨɨyɨ́y t́i sɨɨp maŋwadayt́a? ");
INSERT INTO poiNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Mimicht́am annɨ́mayt́ámpa iga: mamMaestro y mánO̱mi. Wɨ̱ iga miñɨmtámpa je̱mpɨc porque mimicht́am nu̱ma manaccuyujpa y nu̱ma mimicht́am mammɨɨcha̱ne. ");
INSERT INTO poiNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Aunque micht́am amMaestro y ánO̱mi, mantseáypa impuy, jesɨc wɨ̱t́im iga minitseayt́amta̱iñ impuy mimicht́am. ");
INSERT INTO poiNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Mantseáy jém impuy iga manaŋquejáypa iga wɨ̱ iga iŋwattámiñ juuts ɨch maŋwadayt́a. ");
INSERT INTO poiNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nu̱ma mannɨ́máypa, tu̱m pɨ̱xiñ iesclavo d́a wɨa̱p iñasca jém io̱mi. Tu̱m mensajero d́a más mɨj que jém icutsatpáppɨc. ");
INSERT INTO poiNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Siiga iŋcutɨɨyɨyt́ámpa t́i mannɨ́máypa y siiga iŋwattámpa je̱mpɨc, jesɨc agui mimaymáya̱támpa. ");
INSERT INTO poiNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","E̱ybɨc jɨypa Jesús. Nɨmpa: —D́a anɨmtooba iga iñt́u̱mpɨyt́am wɨa̱p iŋcutɨɨyɨyt́a porque aŋwɨ̱ixpɨcpa jém aŋcupiŋneyajwɨɨp. Anjo̱doŋ i̱apaap amalwadáypa. Nɨmpa jém Dios iŋma̱t́i, jém jayñeta̱wɨɨp, iga: “Tu̱m pɨ̱xiñ aŋwaganawícpa aɨch, ocmɨ awadáypa atraición.” Sɨɨp cupactooba jém aŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Mannɨ́máypa sɨɨp t́i annascaaba aɨch, jesɨc cuando íñixt́ámpa iga cupacum jém anaŋma̱t́i, wɨa̱p iŋcupɨcta iga ɨch jém aCristo jém acupiŋnewɨɨp Dios. ");
INSERT INTO poiNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nu̱ma, mannɨ́máypa siiga i̱ ipɨctsoŋpa jém aŋcutsatnewɨɨp, jesɨc apɨctsoŋpat́im aɨch. Siiga i̱ apɨctsoŋpa aɨch, ipɨctsoŋpat́im jém anJa̱tuŋ Dios. ");
INSERT INTO poiNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jesɨc cuando yaj iŋmat je̱mpɨc jém Jesús, tsa̱m pɨ̱mi aŋyácne ia̱namaŋjo̱m. Nɨmpa Jesús: —Nu̱ma sɨɨp mannɨ́máypa, tu̱m de mimicht́am acɨɨjuŋcotpa jém ánenemigo icɨɨjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Jesɨc jém Jesús icuyujcɨɨwiñ tsa̱m naámyajta̱p. Nɨmyajpa ia̱namaŋjo̱m iga: “¿I̱apaap iwadáypa atraición jém tánO̱mi?” ");
INSERT INTO poiNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Tu̱m jém Jesús icuyujcɨɨwiñ, jém tsa̱mpɨc it́oypa, iwaganaco̱ñ jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Jesɨc jém Peto iwadáy seña con ico̱bac iga jém pɨ̱xiñ icwáguiñ Jesús i̱apaap jém iwadaypaap atraición. ");
INSERT INTO poiNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Jesɨc jém pɨ̱xiñ icunúc noco iga iyámacwácpa. Nɨ́mayt́a̱p jém Jesús: —MánO̱mi, ¿i̱ miwadáypa atraición? ");
INSERT INTO poiNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesɨc Jesús icutsoŋ. Nɨmpa: —Sɨɨp anso̱npa tu̱m ja̱ca caxt́ána̱ñi jém anchimajo̱m, anchiiba jém pɨ̱xiñ jém awadaypáppɨc atraición iga quejiñ i̱apaap. Jesɨc cuando ixo̱n jém caxt́ána̱ñi, ichi jém Judas Iscariote, jém Ximoj ima̱nɨc. ");
INSERT INTO poiNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Jesɨc yaj ipɨctsoŋ jém Judas jém caxt́ána̱ñi, tɨgɨy jém Woccɨɨwiñ jém Judas ia̱namaŋjo̱m. Jesɨc Jesús iñɨ́máy jém Judas: —Jém sɨɨppɨc iŋwatpa, nɨ̱gɨ wa̱tɨ jicscɨy. ");
INSERT INTO poiNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Jém tuŋgac icuyujcɨɨwiñ, jém it́yajwɨɨp mesacɨɨm, d́a icutɨɨyɨyyaj t́iiga iñɨ́máy je̱mpɨc jém Judas. ");
INSERT INTO poiNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ijɨ̱syajpa algunos iga cutsatta̱p jém Judas iga nɨguiñ ijuy t́it́am ixunyajpa iga sɨŋa̱yajpa. Tuŋgac ijɨ̱syajpa iga cutsatta̱p jém Judas iga ichiiñ tumiñ jém yaacha̱yajpáppɨc. Porque iwatpa cuenta jém tumiñ ibolsa. ");
INSERT INTO poiNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Jesɨc yajum icút jém caxt́ána̱ñi, nɨc jém Judas. Piichcɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Jesɨc cuando nɨcneum jém Judas, moj aŋma̱t́i jém Jesús. Iñɨ́máy jém icuyujcɨɨwiñ: —Sɨɨp cujípta̱p jém Miññewɨɨp Sɨŋyucmɨ. Cujípta̱pt́im tanJa̱tuŋ Dios je icuyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Siiga cujípta̱p Dios ɨch aŋcuyucmɨ, jesɨc acujípta̱pt́im aɨch jém anJa̱tuŋ Dios icuyucmɨ. Sɨɨp iwatpa Dios jém wɨ̱tampɨc cosa iga acujípta̱iñ y d́a jáyñe iccupacpa. ");
INSERT INTO poiNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Mamma̱nɨctam, mantoyt́ampáppɨc, sɨɨp tu̱m ratot́im tawagait́t́a. Pero ocmɨ mimicht́am tsa̱m aŋcuámtámpa, d́a ampáttámpa. Sɨɨp mannɨ́máypa juuts annɨ́mayñe jém judíos, mimicht́am d́a wɨa̱p iññɨcta ju̱t́ ɨch anɨcpa. ");
INSERT INTO poiNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Sɨɨp manchiiba tu̱m jo̱mipɨc aŋquímayooyi, natoyt́amta̱jɨ con jém iñt́ɨ̱wɨtam. Juuts mantoyt́ámpa mimicht́am, jesɨc je̱mpɨct́im natoyt́amta̱jɨ con jém iñt́ɨ̱wɨtam. ");
INSERT INTO poiNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Siiga minitoyt́amta̱p con jém iñt́ɨ̱wɨtam, jesɨc it́u̱mpɨy jém it́yajwɨɨp yɨ́p naxyucmɨ ijo̱dóŋa̱yajpa iga ɨch maŋcuyujcɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Jesɨc jém Peto icwác jém Jesús, iñɨ́máy: —MánO̱mi, ¿ju̱t́ miñɨcpa? Nɨmpa Jesús: —Jemum ju̱t́ ɨch anɨcpa, mimicht́am d́a wɨa̱p iññɨcta sɨɨp, pero ocmɨ miñɨctámpat́im mex mimicht́am. ");
INSERT INTO poiNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Jesɨc jém Peto iñɨ́máy: —MánO̱mi, ¿t́iiga d́a wɨa̱p annɨcta sɨɨp? Ɨch anyaac anchiiba amvida iga accaata̱p para mimich. ");
INSERT INTO poiNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesɨc nɨmpa Jesús: —¿Que mich michióypa imvida iga miccaata̱p para aɨch? Nu̱ma mannɨ́máypa iga antes que aŋwejpa jém ca̱yu, anaŋnécpa tres veces iga ɨch maŋcuyujcɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","’Mimicht́am, odoy aŋyáctaamɨ íña̱namaŋjo̱m iga ɨch anɨcpa. Cupɨctaamɨ Dios, acupɨctaamɨt́im mex aɨch. ");
INSERT INTO poiNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Jém anJa̱tuŋ Dios it́ɨccɨɨm tsa̱m it́ jém wɨ̱tampɨc lugar ju̱t́ nɨcpa mii̱t́it́am. Meega d́a id́ɨc i̱, d́a id́ɨc mannɨ́máy. Nɨcpa maŋwɨ̱tsagáy tu̱m lugar para mimicht́am. ");
INSERT INTO poiNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Siiga nɨcpa maŋwɨ̱tsagáy tu̱m lugar para mimicht́am, jesɨc amiñgacpa e̱ybɨc iga mananɨctámpa, iga ju̱t́ ait́pa aɨch je̱mt́im miit́t́ámpa mimicht́am. ");
INSERT INTO poiNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Mimicht́am iñjo̱doŋtam ju̱t́ anɨcpa, iñjo̱doŋt́im jém tuŋ. ");
INSERT INTO poiNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Jém Tomax iñɨ́máy: —MánO̱mi, d́a anjo̱doŋtam ju̱t́ miñɨcpa. ¿Jutsa̱p anjo̱dóŋa̱ta jém tuŋ? ");
INSERT INTO poiNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesɨc Jesús iñɨ́máy jém Tomax: —Ɨcham jém atuŋ. Ɨch anamiñ jém nu̱mapɨc aŋquímayooyi. Ɨch anchiiba jém pɨxiñt́am jém vida jém d́apɨc cuyajpa. D́a i̱ núcpa ju̱t́ it́ anJa̱tuŋ Dios siiga d́a acupɨcpa aɨch. ");
INSERT INTO poiNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Siiga mimicht́am ánixpɨctámpa aɨch, jesɨc íñixpɨctámpat́im jém anJa̱tuŋ Dios. Sɨɨp mojum íñixpɨcta Dios, íñixñetámum. ");
INSERT INTO poiNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Jesɨc jém Felipe iñɨ́máy Jesús: —MánO̱mi, aguixt́aamɨ jém tanJa̱tuŋ Dios, jesɨc it́um wɨ̱. D́a t́i más ansuntámpa. ");
INSERT INTO poiNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesɨc Jesús iñɨ́máy jém Felipe: —A que miFelipe, tsa̱m wiñɨgam awagait́t́a con mimicht́am. ¿Que mich d́a ánixpɨcpa? Jém aixñewɨɨp aɨch, iixñet́im jém anJa̱tuŋ Dios. ¿T́iiga mich annɨ́máy iga: “Aguixt́aamɨ jém tanJa̱tuŋ Dios”? ");
INSERT INTO poiNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Que d́a iŋcupɨcpa iga aŋwaganait́ anJa̱tuŋ Dios y jém anJa̱tuŋ Dios awaganait́ aɨch? Jém anaŋma̱t́i, jém manaŋmadayñewɨɨp, d́a je anjɨ̱xquiimi. Jém anJa̱tuŋ Dios, jém it́wɨɨp ána̱namaŋjo̱m, iwatpa jém wɨ̱tampɨc cosa juuts je iwɨ̱aŋja̱m. ");
INSERT INTO poiNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Cupɨctaamɨ iga aŋwaganait́ anJa̱tuŋ Dios y jém anJa̱tuŋ Dios it́ ána̱namaŋjo̱m. Siiga d́a wɨa̱p iŋcupɨcta iga ɨch aŋwaganait́ jém anJa̱tuŋ Dios, jesɨc acupɨctaamɨ aɨch porque íñixñeta jém milagroyaj jém aŋwatnewɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nu̱ma mannɨ́máypa; jém pɨ̱xiñ, jém acupɨcnewɨɨp, wɨa̱pt́im iwat jém milagroyaj jext́im juuts ɨch aŋwatpa, wɨa̱pt́im iwat más wɨbɨc milagro que ɨch porque anɨcgacpam sɨŋyucmɨ ju̱t́ it́ anJa̱tuŋ. ");
INSERT INTO poiNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Siiga iniŋwejpáttámpa Dios ɨch annɨyi̱mɨ iga iŋwágayt́ámpa algun t́i, jesɨc ɨch aŋwatpa juuts mich aŋwágáypa iga cujípta̱iñ jém anJa̱tuŋ Dios. ");
INSERT INTO poiNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","T́it́am iŋwágáypa Dios ɨch annɨyi̱mɨ, jesɨc ɨch aŋwatpa juuts aŋwágáypa mimicht́am. ");
INSERT INTO poiNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Siiga mimicht́am antoyt́ámpa, jesɨc cupɨctaamɨ anaŋquímayooyi. ");
INSERT INTO poiNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ɨch aŋcunucsáypa anJa̱tuŋ Dios iga michiit́ámiñ jém Dios iA̱nama iga miyo̱xpáttámiñt́im juuts aɨch iga míñiñ miwaganait́ con mimicht́am para siempre. ");
INSERT INTO poiNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Jém Dios iA̱nama miŋquejayt́ámpa it́u̱mpɨy jém nu̱mapɨc aŋquímayooyi. Jém it́yajwɨɨp yɨ́p naxyucmɨ ijóyixyajpa Dios, d́a wɨa̱p ipɨctsoŋ jém Dios iA̱nama, porque d́a wɨa̱p iixyaj ni d́a wɨa̱p iixpɨcyaj. Pero cuando núcneum jém Dios iA̱nama, jesɨc mimicht́am íñixpɨctámpa porque miwaganait́t́a. Miñpa i̱t́i jém Dios iA̱nama mimicht́am íña̱namaŋjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","D́a mantsactámpa iŋcut́um juuts tu̱m yuctu̱cu. E̱ybɨc miñpa ai̱t́i con mimicht́am. ");
INSERT INTO poiNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","D́a jáyñe anɨcpa, jesɨc yɨ́p naxyucmɨpɨc pɨxiñt́am d́a más aixyajpa, pero mimicht́am e̱ybɨc ánixt́ámpa. Ɨch manchiiba jém vida porque ɨch anait́ jém vida. ");
INSERT INTO poiNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Jesɨc cuando núcpa jém ja̱ma, mimicht́am iñjo̱dóŋa̱támpa iga aŋwaganait́ jém anJa̱tuŋ Dios. Iñjo̱dóŋa̱támpat́im iga mich miit́ con aɨch y ɨch ait́ con mimicht́am. ");
INSERT INTO poiNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Siiga tu̱m pɨ̱xiñ ijo̱doŋ ɨch anaŋquímayooyi y icupɨcpa, jesɨc quejpa iga tsa̱m atoypa jém pɨ̱xiñ. Siiga atoypa aɨch tu̱m pɨ̱xiñ, jesɨc jém anJa̱tuŋ Dios tsa̱m it́oypat́im jém atoypáppɨc aɨch. Ɨch antoypat́im jém atoypáppɨc. Ɨch anyaac aŋwiñquejáypa jém pɨ̱xiñ iga icutɨɨyɨ́yiñ ai̱apaap. ");
INSERT INTO poiNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Jesɨc jém tuŋgac Judas, jém d́apɨc Iscariote, iñɨ́máy jém Jesús: —MánO̱mi, ¿t́iiga aŋwiñquejayt́ámpa aɨcht́am, pero d́a iŋwiñquejáypa jém it́yajwɨɨp yɨ́p mundo, jém d́apɨcnam micupɨcneyaj? ");
INSERT INTO poiNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesɨc Jesús iñɨ́máy jém icuyujcɨɨwiñ: —Siiga tu̱m pɨ̱xiñ atoypa, jesɨc nu̱ma icupɨcpa jém anaŋma̱t́i. Jém anJa̱tuŋ Dios tsa̱m it́oypat́im jém pɨ̱xiñ. Jesɨc ɨch con jém anJa̱tuŋ Dios miñpa aŋwaganait́t́a jém icupɨcpáppɨc ɨch anaŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Jém pɨ̱xiñ, jém d́apɨc atoypa aɨch, d́a iwatpa juuts nɨmpa ɨch anaŋma̱t́i. Yɨ́p aŋma̱t́i, jém sɨɨppɨc immatoŋne, d́a anjɨ̱xquiimi; achiiñe jém anJa̱tuŋ Dios, jém acutsatnewɨɨp yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Manaŋmadáy it́u̱mpɨy yɨ́pyaj cosa iganam ait́ con mimicht́am. ");
INSERT INTO poiNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Jesɨc ocmɨ anJa̱tuŋ Dios micutsadáypa jém Dios iA̱nama iga miyo̱xpád́iñ juuts tu̱m representante para ɨch. Miñpa miŋquejayt́a it́u̱mpɨy jém anaŋquímayooyi. Miñpa iga micjɨ̱stámiñ it́u̱mpɨy jém anaŋma̱t́i jém manaŋquejayñewɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Sɨɨp mantsagáypa jém paz, manchiiba jém wɨbɨc jɨ̱xi iga d́a t́i id́ɨ́yɨ́y íña̱namaŋjo̱m, d́a jex juuts michiit́a̱p yɨ́p naxyucmɨ. Jesɨc odoy aŋyáctaamɨ íña̱namaŋjo̱m, odoy cɨ̱ŋtaamɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Immatoŋneta cuando mannɨ́máy iga: “Anɨcpa, pero e̱ybɨc miñpa ai̱t́i con mimicht́am.” Siiga nu̱ma antoyt́ámpa, jesɨc maymáya̱taamɨ iga ɨch anɨcgacpa sɨɨp ju̱t́ it́ anJa̱tuŋ Dios, porque jém anJa̱tuŋ más wɨa̱p que aɨch. ");
INSERT INTO poiNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Manaŋmadáypa sɨɨp t́it́am miñpa antes que núcpa, jesɨc cuando íñixt́ámpa it́u̱mpɨy cosa juuts mannɨ́mayñe id́ɨc, iŋcupɨctámpa iga Dios acutsat. ");
INSERT INTO poiNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Sɨɨp tu̱m ratot́im manaŋmatpa, porque sɨɨp núcum jém tiempo iga miñpa yɨ́p naxyucmɨpɨc aŋjagooyi. Je d́a it́i̱cutɨgɨ̱yi con ɨch, d́a t́i wɨa̱p awadáy. ");
INSERT INTO poiNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Pero sɨɨp aŋwatpa juuts apɨɨmɨ́ypa jém anJa̱tuŋ Dios iga jém it́yajwɨɨp yɨ́p mundo ijo̱dóŋa̱yajiñ iga tsa̱m antoypa jém anJa̱tuŋ Dios. Sɨɨp tsucumtaamɨ. Tanɨctámpam. ");
INSERT INTO poiNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","’Ɨch ajex juuts tu̱m nunta uvas ico̱bac. Jém anJa̱tuŋ Dios jém iwatpáppɨc cuenta jém uvas. ");
INSERT INTO poiNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Jagayt́a̱p it́u̱mpɨy jém uvas iŋcɨs jém d́apɨc tɨ́ma̱p. Pero jém iŋcɨs jém tɨ́ma̱páppɨc, wɨ̱tsacta̱p, aŋtɨ́csayt́a̱p uxaŋ iŋqui̱ñi iga más tɨ́ma̱iñ. ");
INSERT INTO poiNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Sɨɨp mimicht́am cuáyñeum íña̱nama porque iŋcupɨc jém anaŋquímayooyi, jém manaŋmadayñewɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Seguido wagait́t́aamɨ con aɨch y ɨch seguido maŋwaganait́pa mimicht́am. Siiga tu̱m cuy iŋcɨs d́a pɨɨma̱ne jém cuyyucmɨ, jesɨc d́a tɨ́ma̱p. Jém cuy iŋcɨs d́a wɨa̱p it́ɨ́ma̱ iyaac. Jesa̱pt́im mimicht́am d́a wɨa̱p iŋwatta jém wɨ̱tampɨc cosa juuts ixunpa Dios siiga d́a miwagait́t́a con aɨch. ");
INSERT INTO poiNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Ɨch ajex juuts tu̱m uvas ico̱bac. Mimicht́am mijex juuts tu̱m uvas iŋcɨs. Siiga tu̱m pɨ̱xiñ seguido awaganait́pa aɨch y siiga ɨch aŋwaganait́pa jém pɨ̱xiñ, jesɨc wɨa̱p iwat jém wɨ̱tampɨc cosa juuts tsa̱m tɨ́ma̱p. Siiga d́a manyo̱xpáttámpa, jesɨc d́a t́i wɨa̱p iŋwatta. ");
INSERT INTO poiNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Siiga tu̱m pɨ̱xiñ d́a seguido awaganait́pa aɨch, jesɨc jex juuts tu̱m cuy iŋcɨs jém d́apɨc tɨ́ma̱p. Pátsayt́a̱p, tɨtspa. Ocmɨ piŋta̱p, cotta̱p juctjo̱m, nooquetta̱p. ");
INSERT INTO poiNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Siiga seguido miwagait́pa con aɨch y d́a iñchacpa iga iŋcupɨcpa ɨch anaŋma̱t́i, jesɨc wágayt́aamɨ Dios t́it́am iñxunpa y je michiiba. ");
INSERT INTO poiNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Jém anJa̱tuŋ Dios tsa̱m cujípta̱p cuando iŋwɨ̱wattámpa mimicht́am, juuts tsa̱m miwɨ̱tɨ́ma̱p. Je̱mpɨgam michɨ́yt́ámpa iga ɨch maŋcuyujcɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Mantoyt́ámpa mimicht́am juutst́im jém anJa̱tuŋ atoypa aɨch. Seguido wɨ̱wattaamɨ porque ɨch tsa̱m mantoyt́ámpa. ");
INSERT INTO poiNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Siiga iŋcupɨctámpa ɨch anaŋquímayooyi, jesɨc seguido iŋwɨ̱wattámpa porque ɨch tsa̱m mantoyt́ámpa. Jext́im juuts aɨch aŋcupɨcpa jém anJa̱tuŋ Dios iŋquímayooyi y seguido aŋwatpa juuts je iwɨ̱aŋja̱m porque tsa̱m atoypa jém anJa̱tuŋ Dios. ");
INSERT INTO poiNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Manaŋmadáypa yɨ́pyaj cosa iga iniid́iñt́im jém maymáya̱ji juutst́im ɨch anait́, iga tsa̱m pɨ̱mi mimaymáya̱támiñ. ");
INSERT INTO poiNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Yɨɨm it́ ɨch anaŋquímayooyi: Natoyt́amta̱jɨ con iñt́ɨ̱wɨtam juuts ɨch mantoyt́ámpa mimicht́am. ");
INSERT INTO poiNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Siiga nachiit́a̱p iyaac tu̱m pɨ̱xiñ iga accaata̱p para jém iamigo, jesɨc quejpa iga tsa̱m pɨ̱mi it́oypa jém iamigo. ");
INSERT INTO poiNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Mimicht́am mánamigotam siiga iŋwattámpa juuts mannɨ́máypa. ");
INSERT INTO poiNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Sɨɨp d́am más michɨ́ypa juuts mánesclavo porque tu̱m esclavo d́a icutɨɨyɨ́ypa t́i iwatpa jém io̱mi. Pero sɨɨp mannɨ́máypa iga mánamigotam porque manaŋquejayñetámum it́u̱mpɨy jém jɨ̱xi jém achiiñewɨɨp jém anJa̱tuŋ Dios. ");
INSERT INTO poiNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Mimicht́am d́a aŋcupiŋneta aɨch, pero ɨch maŋcupiŋneta mimicht́am. Manchiiñeta jém cargo iga nɨguiñ iŋwatta jém wɨbɨc cosa juuts ɨch ansunpa. Jesɨc nu̱ma iŋwɨ̱watpa y d́a iñchacpa jém wɨbɨc jɨ̱xi, juuts tanɨmpa, miwɨ̱tɨ́ma̱p. Jesɨc t́it́am iŋwágáypa anJa̱tuŋ Dios, ɨch annɨyi̱mɨ, michiiba. ");
INSERT INTO poiNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Sɨɨp manaŋquímpa iga natoyt́amta̱jɨ con jém iñt́ɨ̱wɨtam. ");
INSERT INTO poiNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Siiga tsa̱m mijóyixpa jém malopɨc pɨxiñt́am jém it́yajwɨɨp yɨ́p naxyucmɨ, jesɨc jɨ̱sɨ iga wiñt́i ajóyixt́im aɨch. ");
INSERT INTO poiNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Siiga mimicht́am mimalot́im juuts jém it́yajwɨɨp yɨ́p naxyucmɨ, jesɨc mit́oyt́ámpat́im jém malopɨc pɨxiñt́am. Pero maŋcupiŋne iga iñchagaŋpudiñ jém it́yajwɨɨp yɨ́p naxyucmɨ. Jeeyucmɨ tsa̱m mijóyixpa jém malopɨc pɨxiñt́am porque d́am mijex juuts jeeyaj. ");
INSERT INTO poiNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Jɨ̱staamɨ t́i mannɨ́máy iga tu̱m esclavo d́a más mɨj ipɨ̱mi que jém io̱mi. Siiga yɨ́p naxyucmɨpɨc pɨxiñt́am amalwadayyaj aɨch, jesɨc michgact́i mimalwadayyajpat́im. Meega icupɨcyaj ɨch anaŋma̱t́i, jesɨc icupɨcyajpat́im mex mich iniŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Mimalwadayt́amta̱p ɨch aŋcuyucmɨ porque jém malopɨc pɨxiñt́am d́a iixpɨcyajpa jém anJa̱tuŋ Dios jém acutsatnewɨɨp yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Meega ɨch d́a miñ anaŋmadayyaj jém pɨxiñt́am jém wɨbɨc aŋma̱t́i, jesɨc jeeyaj d́a inii̱yaj la culpa iga imalwatyajpa. Pero ɨch anamíñáy jém wɨbɨc aŋma̱t́i, jesɨc jeeyaj iniit́yaj la culpa siiga d́a icupɨcyajpa, d́a wɨa̱p iŋnécyaj it́áŋca. ");
INSERT INTO poiNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Jém ajóyixpáppɨc aɨch, ijóyixpat́im jém anJa̱tuŋ Dios. ");
INSERT INTO poiNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Jeeyaj d́a inii̱yaj la culpa meega d́a miñ aŋwat jém wɨbɨc milagroyaj jém pɨxiñt́ámaŋjo̱m, jém d́apɨc oypa íñix. Pero sɨɨp jém pɨxiñt́am iixñeyajum jém milagroyaj y ajóyixyajpa aɨch y ijóyixyajpat́im jém anJa̱tuŋ Dios. ");
INSERT INTO poiNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Annascaaba je̱mpɨc iga cupacpa jém aŋma̱t́i juuts jayñeta̱ wiñɨgam jém iŋquímayooyi de jeeyaj. Nɨmpa: “Jém malopɨc pɨxiñt́am ajóyixyajpa sin motivo.” ");
INSERT INTO poiNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Cuando anúcpa ju̱t́ it́ anJa̱tuŋ Dios, maŋcutsadáypa jém Dios iA̱nama iga miyo̱xpáttámiñ, iga icamamwad́iñ íña̱nama. Miñpa miŋmadáy de aɨch. Miŋquejayt́ámpa it́u̱mpɨy jém nu̱mapɨc aŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Mimicht́am wɨa̱pt́im iniŋmadáy jém pɨxiñt́am de aɨch porque miit́t́a con aɨch dende moj anaŋmat jém wɨbɨc aŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Sɨɨp manaŋmadáypa yɨ́pyaj cosa iga iŋcutɨɨyɨyt́ámiñ t́i miñpa. Jesɨc siiga mimalwadayt́amta̱p, d́a miŋyáctámpa ni d́a iñchactámpa jém Dios iŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Miquebacputtamta̱p jém sinagoga. Núcpa jém hora cuando jém malopɨc pɨxiñt́am imétsyajpa jutsa̱p miccaayaj, porque ijɨ̱syajpa iga iwatyajpa juuts ixunpa Dios siiga miccaaba. ");
INSERT INTO poiNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Yɨcxpɨc cosa iwatyajpa jém malopɨc pɨxiñt́am porque d́a queman iixpɨcyaj jém anJa̱tuŋ Dios y d́at́im aixpɨcyajpa aɨch. ");
INSERT INTO poiNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Sɨɨp manaŋmadáypa t́i miñpa iga cuando núcpa jém hora iga jém malopɨc pɨxiñt́am mimalwadáypa, jesɨc iñjɨ̱stámpa t́i mannɨ́mayñeta. Pecam d́a id́ɨc manaŋmadayñeta t́i miñpa porque maŋwaganait́t́a mimicht́am. ");
INSERT INTO poiNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","’Sɨɨp nɨcgacpa ai̱t́i ju̱t́ it́ jém acutsatnewɨɨp. Pero ni tu̱m de mimicht́am d́a anacwáctámpa iga: “¿Ju̱t́ miñɨcpa?” ");
INSERT INTO poiNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Pero sɨɨp tsa̱m miŋyácneta íña̱namaŋjo̱m porque manaŋmadayt́a t́i miñpa. ");
INSERT INTO poiNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Mannɨ́máypa sɨɨp jém nu̱mapɨc aŋma̱t́i. Más wɨ̱ para mimicht́am iga anɨcpa. Porque siiga d́a anɨcpa, jesɨc d́a miñpa jém Dios iA̱nama iga miyo̱xpáttámpa. Pero siiga anɨcpa, jesɨc maŋcutsadáypa jém Dios iA̱nama. ");
INSERT INTO poiNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Cuando núcpa yɨ́p naxyucmɨ jém Dios iA̱nama, jesɨc iŋquejáypa jém it́yajwɨɨp yɨ́p naxyucmɨ iga táŋcaɨ́y. Iŋquejáypat́im jém pɨxiñt́am jutsa̱p iwatyaj juuts ixunpa Dios. Iŋquejáypat́im jém pɨxiñt́am iga núcpa jém ja̱ma iga cɨɨpiŋyajta̱p it́u̱mpɨy jém malopɨc pɨxiñt́am, chiiyajta̱p castigo. ");
INSERT INTO poiNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Jém Dios iA̱nama iŋquejáypa jém pɨxiñt́am iga táŋcaɨyyaj porque d́a acupɨcyajpa. ");
INSERT INTO poiNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Aŋquejayyajta̱pt́im jém pɨxiñt́am jutsa̱p iwatyaj juuts ixunpa Dios porque sɨɨp anɨcgacpa ju̱t́ it́ jém anJa̱tuŋ y mimicht́am d́a más ánixt́ámpa. ");
INSERT INTO poiNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Aŋquejayyajta̱pt́im jém pɨxiñt́am iga cɨɨpíŋóypa Dios porque Dios icɨɨpiŋneum jém Woccɨɨwiñ, jém iŋjacpáppɨc yɨ́p mundo, y ichiibat́im castigo. ");
INSERT INTO poiNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Manaŋmadayt́amtooba jáyaŋ más cosa, pero sɨɨp d́a wɨa̱p iñyaachɨ́y. ");
INSERT INTO poiNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Pero cuando miñpa jém Dios iA̱nama jém iŋmatpáppɨc jém nu̱mapɨc aŋma̱t́i, jesɨc miŋquejayt́ámpa it́u̱mpɨy jém nu̱mapɨc aŋquímayooyi. Porque Dios iA̱nama d́a miŋmadáypa de iyaac, pero miŋmadáypa it́u̱mpɨy jém cosa jém imatoŋnewɨɨp. Miŋquejayt́ámpa t́i miñpa. ");
INSERT INTO poiNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Jém Dios iA̱nama ipɨctsoŋpa it́u̱mpɨy jém ɨch anaŋquímayooyi y miwɨ̱aŋquejayt́ámpa. Iwatpa je̱mpɨc iga jém pɨxiñt́am awɨ̱ixyajiñ aɨch. ");
INSERT INTO poiNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","It́u̱mpɨy jém anJa̱tuŋpɨc imɨɨchi, ammɨɨchit́im aɨch. Jeeyucmɨ mannɨ́máypa iga jém Dios iA̱nama ipɨctsoŋpa ɨch anaŋquímayooyi y miŋquejayt́ámpa mimicht́am. ");
INSERT INTO poiNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’D́a jáyñe mimicht́am d́a ánixt́ámpa. Pero ocmɨ d́a jáypa ánixt́ámpa e̱ybɨc. Porque anɨcpa ju̱t́ it́ anJa̱tuŋ Dios. ");
INSERT INTO poiNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Jesɨc algunos jém Jesús icuyujcɨɨwiñ nanɨ́mayyajta̱p entre jeeyaj: —¿Que t́i nɨmtooba iga: “d́a jáyñe d́a ánixt́ámpa”, y “d́a jáypa ánixt́ámpa e̱ybɨc” y “porque anɨcpa ju̱t́ it́ anJa̱tuŋ”? ");
INSERT INTO poiNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Que t́i nɨmtooba iga: “d́am jáyñe d́a tánixt́ámpa”? D́a taŋcutɨɨyɨ́ypa t́i nɨmtooba jém tánO̱mi. ");
INSERT INTO poiNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesɨc jém Jesús icutɨɨyɨ́y iga jém icuyujcɨɨwiñ icwáctooba. Jesɨc iñɨ́máy jeeyaj: —¿Que minicwáctamta̱p t́i anɨmtooba cuando mannɨ́mayñe iga: “d́am jáyñe, d́a ánixt́ámpa” y ocmɨ, “d́a jáypa ánixt́ámpa e̱ybɨc”? ");
INSERT INTO poiNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nu̱ma, mannɨ́máypa iga tsa̱m miwejtámpa, tsa̱m miŋyáctámpa. Jém malopɨc pɨxiñt́am jém it́yajwɨɨp yɨ́p naxyucmɨ tsa̱m maymáya̱yajpa. Pero mimicht́am tsa̱m miŋyáctámpa. Pero ocmɨ cáypa jém aŋyaaqui, se̱tpa iga mimaymáya̱támiñ mimicht́am. ");
INSERT INTO poiNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Cuando tu̱m yo̱mo icnaypa tsɨ̱xi, agui aŋyácne iga yaacha̱p porque núcneum jém tsɨ̱xi it́o̱ya. Pero ocmɨ cuando nayñeum jém tsɨ̱xi, d́am ijɨ̱spa jém yo̱mo iga tsa̱m yaacha̱ micnay jém tsɨ̱xi porque agui maymay iga icnayñe tu̱m tsɨ̱xi yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Jesanet́im mimicht́am sɨɨp tsa̱m miŋyáctámpa, pero jesɨc ocmɨ miñgacpa mánám y tsa̱m mimaymáya̱támpa. Jesɨc jém maymáya̱ji d́a i̱ wɨa̱p miccáyáy. ");
INSERT INTO poiNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Cuando núcum jém ja̱ma iga amiñgacpa, jesɨc d́a t́i anacwáctámpa mimicht́am. ’Nu̱ma mannɨ́máypa iga jém anJa̱tuŋ Dios michiiba t́it́am iŋwágayt́ámpa ɨch annɨyi̱mɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hasta sɨɨp d́a t́i iŋwágayt́a Dios ɨch annɨyi̱mɨ. Sɨɨbam wágayt́aamɨ Dios t́it́am iñxunpa iga tsa̱m mimaymáya̱támpa cuando impɨctsoŋtámpa. ");
INSERT INTO poiNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Hasta sɨɨp manaŋmadayñe cuentujmɨ, pero núcpa jém hora iga d́a manaŋmadáypa cuentujmɨ. Mannuntawɨ̱aŋmadáypa t́i iwɨ̱aŋja̱m jém anJa̱tuŋ Dios. ");
INSERT INTO poiNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Jesɨc cuando núcpa jém ja̱ma, d́a anaŋwejpátpa Dios para mimicht́am porque mimicht́am iŋwágáypa Dios t́it́am iñxunpa ɨch annɨyi̱mɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Jém anJa̱tuŋ Dios iyaac mit́oyt́ámpa porque micht́am antoyt́ámpa aɨch y iŋcupɨctámpa iga ɨch atsucum ju̱t́ it́ anJa̱tuŋ Dios. ");
INSERT INTO poiNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ɨch atsucum ju̱t́ it́ anJa̱tuŋ Dios. Miñ ai̱t́i yɨ́p naxyucmɨ. Sɨɨp acáypam yɨ́p naxyucmɨ. E̱ybɨct́im anɨcgacpa ju̱t́ it́ anJa̱tuŋ Dios. ");
INSERT INTO poiNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Jesɨc nɨmyaj jém icuyujcɨɨwiñ: —Sɨɨp nu̱ma iññuntawɨ̱aŋmatum. D́am iŋmatpa cuentujmɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Sɨɨp anjo̱dóŋa̱támum iga iŋcutɨɨyɨ́ypa it́u̱mpɨy cosa, d́a iñxunpa iga i̱ micwácpa. Jeeyucmɨ maŋcupɨctámpa iga nu̱ma Dios micutsatne yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesɨc jém Jesús iñɨ́máy jeeyaj: —¿Nu̱ma, iŋcupɨctámpa sɨɨp? ");
INSERT INTO poiNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Mannɨ́máypa iga núcum jém ja̱ma iga aŋcupóyayt́ámpa mimicht́am. Micupujayt́ámpa. Miñɨctámpa yɨɨm jeexɨc. Antsactámpa aɨch aŋcut́um. Pero ɨch d́a atsɨ́ypa aŋcut́um porque siempre it́ con aɨch jém anJa̱tuŋ Dios. ");
INSERT INTO poiNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Mannɨ́mayt́a it́u̱mpɨy yɨ́pyaj cosa iga odoy t́i iŋcɨ̱ŋtámiñ porque aŋcupɨcneta aɨch. Tienes que miyaachwattamta̱p yɨ́p naxyucmɨ, pero camamwa̱tɨ íña̱nama porque ɨch aŋcoñwɨyñeum it́u̱mpɨy jém Woccɨɨwiñ ipɨ̱mi jém it́wɨɨp yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jesɨc cuando yaj iŋmat je̱mpɨc jém Jesús, ámquím sɨŋyucmɨ. Moj iŋwejpát Dios. Nɨmpa: —ManJa̱tuŋ Dios, sɨɨp núcneum jém hora iga accaata̱p. Sɨɨp wa̱tɨ t́it́am iñxunpa iga jém pɨxiñt́am awɨ̱ixyajiñ aɨch, jém michpɨc imma̱nɨc. Jesɨc ɨch aŋwatpat́im jém yo̱xacuy juuts mich iñxunpa iga jém pɨxiñt́am miwɨ̱ixyajiñt́im. ");
INSERT INTO poiNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Mich anchi jém pɨ̱mi iga anaŋjacpa it́u̱mpɨy jém pɨxiñt́am. Ampɨctsoŋ jém autoridad iga anchiiyajpa jém vida jém d́apɨc cuyajpa it́u̱mpɨy jém pɨxiñt́am jém michpɨc anchiiñe. ");
INSERT INTO poiNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ipɨctsoŋyajpa jém vida jém d́apɨc cuyajpa siiga miixpɨcyajpa mimich jém t́u̱mpɨc miDios y siiga aixpɨcyajpat́im aɨch, jém aJesucristo jém michpɨc aŋcutsatne yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Yajum aŋwat jém yo̱xacuy jém anchiiñewɨɨp mimich, jeeyucmɨ tsa̱m micujípyajpa jém it́yajwɨɨp yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Sɨɨp manJa̱tuŋ Dios, awadaayɨ juuts mich iñxunpa iga acujípta̱iñ con mimich juutst́im acujípneta̱ cuando jáy tawagai̱t́i cuando d́anam taŋwatne yɨ́p mundo. ");
INSERT INTO poiNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Yɨ́p ampɨxiñt́am, jém iŋcupiŋnewɨɨp yɨ́p naxyucmɨ, mich immɨɨchi id́ɨc y sɨɨp mich anchi. Anaŋquejayyaj yɨ́p ampɨxiñt́am it́u̱mpɨy jém michpɨc iniŋquímayooyi iga miwɨ̱ixpɨcyajiñ. Sɨɨp iwatyajpa juuts nɨmpa iniŋquímayooyi. ");
INSERT INTO poiNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Sɨɨp ijo̱dóŋa̱yaj iga mich immɨɨchi it́u̱mpɨy jém anaŋquímayooyi jém michpɨc anchiiñe. ");
INSERT INTO poiNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Anchiiñeyajum jém ampɨxiñt́am jém aŋma̱t́i, jém michpɨc anchiiñe. Sɨɨp ipɨctsoŋneyajum jém aŋma̱t́i y ijo̱dóŋa̱yajum iga nu̱ma ɨch amiñ sɨŋyucmɨ ju̱t́ miit́. Icupɨcyajpa iga mich aŋcutsatne yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Sɨɨp manaŋwejpátpa mimich para jém ampɨxiñt́am. D́a manaŋwejpátpa para jém it́yajwɨɨp yɨ́p naxyucmɨ jém d́apɨc acupɨcneyaj. Solamente manaŋwejpátpa para jém ampɨxiñt́am jém michpɨc anchiiñe porque immɨɨchit́im mich. ");
INSERT INTO poiNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","It́u̱mpɨy jém ɨchpɨc ammɨɨchi, immɨɨchit́im mich. Y jém michpɨc immɨɨchi, ammɨɨchit́im ɨch. Acujípta̱p aɨch porque jém ampɨxiñt́am iwɨ̱watyajpa. ");
INSERT INTO poiNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Sɨɨp ɨch d́a atsɨ́ypa yɨ́p naxyucmɨ. Tsɨ́yyajpa jém ampɨxiñt́am. Ɨch anɨcpa sɨŋyucmɨ ju̱t́ miit́. Sɨɨp manJa̱tuŋ Dios, miCuáyñewɨɨp, con mich impɨ̱mi wa̱tɨ cuenta jém ampɨxiñt́am jém anchiiñewɨɨp iga iniit́yajiñ tu̱mt́i jɨ̱xi juutst́im taɨcht́am. ");
INSERT INTO poiNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Iganam aŋwaganait́yaj yɨ́p naxyucmɨ jém aŋcuyujcɨɨwiñ, jém anchiiñeyajwɨɨp mimich, ɨch aŋwatneyaj cuenta con mich impɨ̱mi. D́a t́i iñascaneyaj. D́a togoyñe ni tu̱m, nada más jém togoyñewɨɨp dende wiñɨgam. Je togoy iga cupacpa jém aŋma̱t́i jém jaychacneta̱wɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Sɨɨp anɨcpa ju̱t́ miit́, manJa̱tuŋ Dios. Pero iganam ait́ yɨ́p naxyucmɨ, mannɨ́máypa yɨ́pyaj cosa, jesɨc jém aŋcuyujcɨɨwiñ maymáya̱yajpat́im juutst́im aɨch. ");
INSERT INTO poiNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ɨch anchiiñeyaj jém aŋcuyujcɨɨwiñ jém michpɨc iniŋma̱t́i. Jém malopɨc pɨxiñt́am, jém it́yajwɨɨp yɨ́p naxyucmɨ, tsa̱m ijóyixyajpa jém aŋcuyujcɨɨwiñ porque jeeyaj d́at́im yɨ́p naxyucmɨpɨc pɨxiñt́am. Jext́im juuts ɨch d́a yɨ́p naxyucmɨpɨc apɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Sɨɨp d́a mannɨ́máypa iga accaayɨ jém aŋcuyujcɨɨwiñ yɨ́p naxyucmɨ. Pero mannɨ́máypa iga wa̱tɨ cuenta iga jém Woccɨɨwiñ d́a wɨa̱p imalwadáy. ");
INSERT INTO poiNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ɨch aŋcuyujcɨɨwiñ d́a je yɨ́p naxyucmɨpɨc pɨxiñt́am, jext́im juuts aɨch d́a yɨ́p naxyucmɨpɨc apɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Accámya̱jɨ yɨ́p aŋcuyujcɨɨwiñ juuts mich iñyo̱xacɨɨwiñ iga tsɨ́yyajiñ juuts mich immɨɨchi iga iŋmatyajiñ jém nu̱mapɨc aŋma̱t́i. Jém michpɨc iniŋma̱t́i jém nunta nu̱mapɨc. ");
INSERT INTO poiNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Aŋcutsatpa jém aŋcuyujcɨɨwiñ iga iŋquejayyajiñ jém pɨxiñt́am jém it́yajwɨɨp yɨ́p naxyucmɨ juutst́im mich aŋcutsatne yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ɨch anyaac anaccámta̱ juuts mich iñyo̱xacɨɨwiñ para que jém aŋcuyujcɨɨwiñ wɨa̱pt́im iniccám juuts tu̱m iñyo̱xacɨɨwiñ iga iŋmatyajiñ jém nu̱mapɨc aŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’D́a manaŋwejpátpa solamente para jém aŋcuyujcɨɨwiñ jém sɨɨppɨc it́, pero manaŋwejpátpa para it́u̱mpɨy jém pɨxiñt́am jém acupɨcyajpáppɨc aɨch cuando imatoŋyajpa jém aŋcuyujcɨɨwiñ iŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Maŋwágáypa, manJa̱tuŋ Dios, iga tu̱mt́i jɨ̱xi iniit́yajiñ it́u̱mpɨy jém ampɨxiñt́am jém acupɨcneyajwɨɨp, jesa̱pt́im juuts taɨch tu̱mt́i jɨ̱xi tanait́t́a. Yo̱xpaatɨ it́u̱mpɨy jém acupɨcneyajwɨɨp iga tu̱mt́i jɨ̱xi tanait́t́ámiñ tantu̱mpɨyt́am. Jesɨc jém d́apɨc acupɨcneyaj, wɨa̱iñ icupɨcyaj iga mich aŋcutsatne yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Anchiiñe jém impɨ̱mi, jém michpɨc anchi, iga tu̱mt́i jɨ̱xi iniit́yajiñ jext́im juuts taɨcht́am tu̱mt́i tanjɨ̱xi tanait́t́a. ");
INSERT INTO poiNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ɨch ait́ jém aŋcuyujcɨɨwiñ ia̱namaŋjo̱m. Mich miit́t́im ɨch ána̱namaŋjo̱m. Jeeyucmɨ tu̱mt́i jɨ̱xi tanait́t́a tantu̱mpɨyt́am. Jesɨc jém tuŋgac pɨxiñt́am, jém d́apɨc icupɨcneyaj, iwɨ̱jo̱doŋ iga mich aŋcutsatne yɨ́p naxyucmɨ. Ijo̱doŋt́im iga tsa̱m iñt́oyyajpa jém aŋcuyujcɨɨwiñ juutst́im mich antoypa aɨch. ");
INSERT INTO poiNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’ManJa̱tuŋ Dios, ansunpa iga aŋwaganait́yajiñ jém aŋcuyujcɨɨwiñ, jém michpɨc anchiiñe. Ansunpat́im iga iixyajiñ jém ampɨ̱mi jém michpɨc anchiiñe porque mich antoypa antes que watta̱p yɨ́p nas. ");
INSERT INTO poiNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ManJa̱tuŋ Dios, agui micuáyñe. Jém it́yajwɨɨp yɨ́p naxyucmɨ d́a miixpɨcyajpa, pero ɨch, nu̱ma mánixpɨcpa y jém ampɨxiñt́am ijo̱dóŋa̱yaj iga mich aŋcutsatne yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Aŋwɨ̱aŋquejáy jeeyaj iga icutɨɨyɨyyajiñ iga mii̱apaap mimich. Seguido anaŋquejáypa iga iniit́yajiñ jém wɨbɨc tóyooyi juuts mich antoypa aɨch. Jesɨc ɨch ait́ jém ampɨxiñt́am ia̱namaŋjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesɨc cuando yaj iŋmat yɨ́pyaj aŋma̱t́i, moj nɨquiyaj con jém icuyujcɨɨwiñ. Nɨcyaj tu̱m nɨ aŋwiñt́uc, iñɨ̱yi Cedrón. Jemum it́ tu̱m finca de olivos, tɨgɨyyaj Jesús con icuyujcɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Jém Judas, jém iwadaypaap atraición, ijo̱doŋt́im ju̱t́ it́ jém lugar porque wa̱t́cɨy iwaganaoyyaj jém Jesús jém icuyujcɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Jém pa̱nij aŋjagooyiyaj con jém fariseoyaj icutsatyaj jute̱n pɨxiñt́am y jém policía con jém Judas iga nɨcpa imatsyaj jém Jesús. Jesɨc jém Judas ininɨcpa jeeyaj hasta ju̱t́ it́ jém Jesús. Ininɨcyaj jém espada y lanza. Ininɨcyajpat́im juctɨ iga iyɨcquejpa. ");
INSERT INTO poiNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Iwɨ̱jo̱doŋ Jesús t́i iñascaaba, pero d́a cɨ̱ŋpa. Jesɨc nɨc iwiñquejáy jém miññeyajwɨɨp. Iñɨ́máy jeeyaj: —¿I̱ immétspa? ");
INSERT INTO poiNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Nɨmyajpa jém policía: —Jém Jesús, jém Nazaretpɨc. Jesɨc Jesús iñɨ́máy: —Aɨcham. Jém Judas, jém iwadaypaap atraición jém Jesús, iwaganait́ jém policía. ");
INSERT INTO poiNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Cuando iñɨ́máy Jesús jém miññeyajwɨɨp iga: “Aɨcham”, jesɨc it́u̱mpɨy de jeeyaj iñɨccayaj it́uuñi, tsutyaj. ");
INSERT INTO poiNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jesɨc e̱ybɨct́im iñɨ́máy Jesús jém policía: —¿I̱ immétspa? Nɨmyajpa jeeyaj: —Jém Jesús, jém Nazaretpɨc. ");
INSERT INTO poiNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesús e̱ybɨc iñɨ́máy jeeyaj: —Mannɨ́mayñeum iga aɨcham. Siiga ammétstámpa aɨch, jesɨc wiñt́i jɨ́gaayɨ iga nɨcyajiñ yɨ́p ampɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Nɨmpa je̱mpɨc jém Jesús iga cupacpa jém aŋma̱t́i jém iŋmatnewɨɨp wiñt́i. Nɨmpa: “Jém ampɨxiñt́am, jém achiiñewɨɨp Dios, ni tu̱m d́a antsɨctogoy.” ");
INSERT INTO poiNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Jesɨc jém Peto it́op jém espada, it́ɨŋquímáy tu̱m pɨ̱xiñ it́a̱tsɨc jém aŋwɨ̱mɨpɨc. Jém pɨ̱xiñ icuyo̱xa̱p jém co̱bacpɨc pa̱nij, iñɨ̱yi Malco. ");
INSERT INTO poiNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesɨc Jesús iñɨ́máy jém Peto: —Co̱tɨ jém espada iñacjo̱m. ¿Que d́a iñjo̱doŋ iga anJa̱tuŋ Dios ijɨ́cpa iga ayaachwatta̱p y ɨch tienes que anyaachɨ́ypa? ");
INSERT INTO poiNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Jesɨc jém pɨxiñt́am jém icutsatneyajwɨɨp jém pa̱nijyaj y jém comandante con ipolicía imatsyaj jém Jesús. Ichenyaj. ");
INSERT INTO poiNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Jesɨc wiñt́i nanɨcta̱p Jesús jém Anás it́ɨccɨɨm, jém Anás imɨɨt jém Caifás, jém co̱bacpɨc pa̱nij jém a̱mt́ɨy. ");
INSERT INTO poiNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Jeet́im Caifás, jém ichiiñewɨɨp consejo jém judíos, iga más wɨ̱ iga accaata̱iñ tu̱m pɨ̱xiñ iga odoy togoyyajiñ it́u̱mpɨy jém Israelpɨc pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Jém Peto it́úŋɨ́y Jesús con jém tuŋgac icuyujcɨɨwiñ. Jém Caifás iixpɨcpa jém pɨ̱xiñ, jeeyucmɨ tɨgɨy con Jesús jém Caifás it́aañijo̱m. ");
INSERT INTO poiNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pero tsɨ́y aŋsɨ̱cmɨ jém Peto jém taañi aŋna̱ca. Tɨgɨyñe jém tuŋgac discípulo, jém iixpɨcpáppɨc jém Caifás, ijɨ́yáy jém yo̱mo jém iwatpáppɨc cuenta jém puerta. Icunucsáy iga tɨgɨ́yiñ jém Peto. ");
INSERT INTO poiNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Jesɨc jém yo̱mo iñɨ́máypa jém Peto: —¿Que mimich, d́a yɨ́p pɨ̱xiñ micuyujcɨɨwiñ? Jesɨc nɨmpa jém Peto: —Ɨch d́a aje. ");
INSERT INTO poiNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Jesɨc como tsa̱m sucsuc, jém policía con jém icuyo̱xayajpaap jém co̱bacpɨc pa̱nij, icnúcyaj juctɨ iga samyajpa. Iwaganait́yajt́im jém Peto. Sampat́im mex je. ");
INSERT INTO poiNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Jesɨc jém co̱bacpɨc pa̱nij moj icwác jém Jesús. Nɨ́mayt́a̱p: —¿I̱t́am jém iŋcuyujcɨɨwiñ? ¿Juutspɨc aŋquímayooyi sɨ́p iniŋquej? ");
INSERT INTO poiNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesɨc Jesús icutsoŋ. Nɨmpa: —Ɨch siempre anaŋmatpa jém anaŋma̱t́i it́u̱mpɨy jém pɨxiñt́am iwiñjo̱m ju̱t́ wɨa̱p imatoŋyaj i̱ quej. Siempre accuyujóypa jém sinagoga y jém mɨjpɨc ma̱stɨcjo̱m. D́a t́i anyámaŋmatpa. ");
INSERT INTO poiNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿T́iiga anacwácpa aɨch? Acwácya̱jɨ jém pɨxiñt́am jém amatoŋneyajwɨɨp. Jeeyaj wɨa̱p miŋmadayyaj t́i anaŋquejayñeyaj. Iwɨ̱jo̱doŋyaj t́i annɨ́máy. ");
INSERT INTO poiNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Cuando nɨmpa je̱mpɨc jém Jesús, jesɨc tu̱m policía ichi tu̱m to̱ji ia̱cpacyucmɨ. Nɨmpa jém policía: —¿Que je̱mpɨgam iŋcutsoŋpa jém co̱bacpɨc pa̱nij? ");
INSERT INTO poiNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesɨc Jesús iñɨ́máy jém policía: —Siiga amalnɨm, jesɨc anɨ́maayɨ t́i mal anɨm. Pero siiga d́a amalnɨmne, ¿jesɨc t́iiga aŋcótspa? ");
INSERT INTO poiNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Tsenneta̱ jém Jesús cuando jém Anás icutsadáy jém co̱bacpɨc pa̱nij, jém Caifás. ");
INSERT INTO poiNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Jesɨc jemum te̱ñ jém Peto nocojo̱m jém juctɨcɨɨm. Sampa ixɨ. Jém it́yajwɨɨp iñɨ́mayyaj jém Peto: —Mimich, ¿d́a yɨ́p pɨ̱xiñ micuyujcɨɨwiñ? Jém Peto iŋnécpa. Nɨmpa: —Ɨch d́a aje. ");
INSERT INTO poiNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Jesɨc tu̱m jém icuyo̱xapaap jém co̱bacpɨc pa̱nij ijɨ́yáypa jém Peto. Jém it́ɨ̱wɨ, jém it́ɨŋquímayñewɨɨp it́a̱tsɨc. Nɨ́mayt́a̱ jém Peto: —¿Que d́a mánix jém finca de olivos, ju̱t́ matsta̱ jém pɨ̱xiñ? ");
INSERT INTO poiNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Jesɨc e̱ybɨct́im iŋnéc jém Peto iga iixpɨcpa Jesús. Jesɨc jeet́im rato aŋwejpa tu̱m ca̱yu. ");
INSERT INTO poiNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Jesɨc topta̱ Jesús jém Caifás it́ɨccɨɨm. Nanɨcta̱ jém palacio ju̱t́ it́ jém Romapɨc gobernador. Tsuuyt́im. Joccuquej. Jém pa̱nij aŋjagooyiyaj d́a tɨgɨyyaj jém palacio porque ijɨ̱syajpa jém Israelpɨc pɨxiñt́am siiga tɨgɨypa jém Romapɨc pɨxiñt́am it́ɨcjo̱m, d́a tsɨ́y juuts cuáyñe, jesɨc d́a wɨa̱p icútyaj jém pascuasɨŋ wíccuy. ");
INSERT INTO poiNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Jeeyucmɨ put ipalacio jém Pilato, nɨc aŋcɨɨm iga iám jém Israelpɨc aŋjagooyiyaj. Nɨ́mayt́a̱ jeeyaj: —¿T́i quejaj inimiñ para yɨ́p pɨ̱xiñ? ");
INSERT INTO poiNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Jesɨc jém judíos iŋjagooyiyaj icutsoŋyaj, nɨmyaj: —Meega d́a pɨ̱mi mal iwatne yɨ́p pɨ̱xiñ, jesɨc d́a maŋcɨɨjuŋcodáypa iŋcɨɨjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Jesɨc jém Pilato iñɨ́máy jeeyaj: —Nase̱ttaamɨ e̱ybɨc jemɨc, cɨɨpiŋtaamɨ con micht́am iniŋquímayooyi. Jesɨc nɨmyajpa jém judíos: —D́a anai̱t́a derecho iga anaccaatámpa ni tu̱m pɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Iwatyajpa je̱mpɨc iga cupacpa jém aŋma̱t́i jém nɨmnewɨɨp Jesús cuando iñɨ́máy jém icuyujcɨɨwiñ ju̱t́pɨc accaata̱p. ");
INSERT INTO poiNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Jesɨc jém Pilato tɨgɨygacum jém palacio. Iŋwejáy Jesús, iñɨ́máy: —¿Que micham jém judíospɨc miRey? ");
INSERT INTO poiNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesɨc Jesús icutsoŋ jém gobernador, iñɨ́máy: —¿Que mich iñyaac miñɨmpa je̱mpɨc o tuŋgac miŋmadayñe iga ai̱apaap? ");
INSERT INTO poiNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Nɨmpa jém Pilato: —¿Que ɨch ajudío? Jém michpɨc iñt́ɨ̱wɨtam, jém judíos, con jém pa̱nij aŋjagooyiyaj micɨɨjuŋcotyaj ɨch aŋcɨɨjo̱m. ¿T́i mal iŋwatne? ");
INSERT INTO poiNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesɨc Jesús iñɨ́máy jém Pilato: —Nu̱ma ɨch atsɨ́ypa juuts aŋjagooyi, pero d́a anaŋjacpa jém pɨxiñt́am juuts yɨ́p naxyucmɨpɨc aŋjagooyiyaj. Siiga anaŋjacpa juuts yɨ́p naxyucmɨpɨc aŋjagooyi, jesɨc áŋa̱yajpa jém ampɨxiñt́am iga odoy i̱ wɨa̱iñ acɨɨjuŋcot jém judíos icɨɨjo̱m. Pero ɨch d́a anaŋjacpa juuts yɨ́p naxyucmɨpɨc aŋjagooyiyaj. ");
INSERT INTO poiNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Jesɨc jém Pilato iñɨ́máy jém Jesús: —¿Que nu̱ma micham jém miRey? Jesús icutsoŋ. Nɨmpa: —Mich miñɨmpa iga ɨch aRey. Ɨch anay y amiñ yɨ́p naxyucmɨ iga anaŋmadáypa jém pɨxiñt́am jém nu̱mapɨc aŋquímayooyi. Jesɨc it́u̱mpɨy jém icupɨcyajpáppɨc jém nu̱mapɨc aŋquímayooyi, imatoŋyajpa t́i anaŋmadáypa. ");
INSERT INTO poiNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Nɨmpa jém Pilato: —¿T́i jém nu̱mapɨc aŋquímayooyi? Jesɨc cuando yaj icwác jém Pilato, putgac aŋsɨ̱cmɨ. E̱ybɨct́im nɨc iñɨ́máy jém judíos: —Ni tu̱m it́áŋca d́a ampadáy yɨ́p pɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pero iniit́t́a tu̱m costumbre iga cada pascuasɨŋ aŋcutsɨgáypa tu̱m preso para mimicht́am. ¿Jesɨc t́i iñxunpa, iŋwɨ̱aŋja̱mta iga aŋcutsɨgáypa jém judíos iRey? ");
INSERT INTO poiNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Jesɨc it́u̱mpɨy de jeeyaj e̱ybɨct́im pɨ̱mi jɨyyajpa. Nɨmyajpa: —Odoy cutsɨgaayɨ yɨ́p pɨ̱xiñ. Cutsɨgaayɨ jém Barrabás. Jém Barrabás tu̱m númpaap. ");
INSERT INTO poiNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Jesɨc jém Pilato ipɨɨmɨ́y isoldado iga imatsyajiñ jém Jesús y icótsyajiñ pɨ̱mi con jém cótsóycuy. ");
INSERT INTO poiNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Jesɨc ocmɨ jém soldado ipɨcyaj a̱pit́, it́acpa tu̱m corona, iccámayyaj jém Jesús ico̱bacyucmɨ. Iccámayyajt́im tu̱m yagats yoot́i moradopɨc. ");
INSERT INTO poiNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Jém soldado ixaayɨyyajpa, icunúcyajpa Jesús, iñɨ́mayyajpa: —Xutsóy, miRey de jém judíos. Tsa̱m icótsayyajpa ia̱cpac. ");
INSERT INTO poiNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Jesɨc jém Pilato e̱ybɨc put aŋsɨ̱cmɨ jém ipalacio. Iñɨ́máy jém judíos: —Ixt́aamɨ. Manamíñáy e̱ybɨc yɨ́p pɨ̱xiñ iga manacjodóŋa̱ta iga d́a ampádáy ni tu̱m it́áŋca. ");
INSERT INTO poiNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jesɨc naputta̱ Jesús jém palacio. Accámayñeta̱ jém a̱pit́ corona ico̱bacyucmɨ. Accámayñeta̱t́im jém yagats yoot́i moradopɨc. Jesɨc jém Pilato iñɨ́máy jeeyaj: —Yɨɨm it́ jém pɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Jesɨc cuando jém pa̱nij aŋjagooyiyaj con jém policía iixyaj jém Jesús, pɨ̱mi jɨyyajpa, nɨmyajpa: —¡Cunúntaamɨ cunusyucmɨ! ¡Cunúntaamɨ cunusyucmɨ! Jesɨc Pilato iñɨ́máypa jeeyaj: —Nanɨctaamɨ mimicht́am. Cunúntaamɨ cunusyucmɨ. Ɨch d́a ampadáy ni tu̱m it́áŋca. ");
INSERT INTO poiNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Pero jém judíos iñɨ́mayyaj jém Pilato: —Anait́t́a tu̱m anaŋquímayooyi. Nɨmpa jém anaŋquímayooyi iga accaata̱iñ jém pɨ̱xiñ porque nɨmpa iga: “Dios aMa̱nɨc.” ");
INSERT INTO poiNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Jesɨc jém Pilato mu imatoŋ t́i iŋmadayyaj, mást́im cɨ̱ŋ. ");
INSERT INTO poiNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Jesɨc e̱ybɨct́im jém Pilato ininɨc Jesús jém palacio, e̱ybɨc icwácpa, nɨ́mayt́a̱: —¿Ju̱t́pɨc mipɨ̱xiñ? Pero Jesús d́a icutsoŋ. ");
INSERT INTO poiNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Jesɨc Pilato iñɨ́máy jém Jesús: —¿Que mimich, d́a anjɨ́yáypa? ¿D́a iñjo̱doŋ iga ɨch anait́ jém autoridad iga maŋcunúnpa cunusyucmɨ y anait́t́im autoridad iga maŋcutsɨgáypa? ");
INSERT INTO poiNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesɨc Jesús iñɨ́máypa jém Pilato: —Mich d́a t́i wɨa̱p aŋwadáy siiga d́a ijɨ́cpa anJa̱tuŋ Dios. Jém autoridad jém iniit́wɨɨp mimich, michiiñe jém anJa̱tuŋ Dios. Jeeyucmɨ jém acɨɨjuŋcotnewɨɨp mich iŋcɨɨjo̱m más táŋcaɨ́y que mimich. ");
INSERT INTO poiNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Dende jesɨgam jém Pilato imétstɨp jutsa̱p icutsɨgáy jém Jesús. Pero pɨ̱mi jɨyyajpa jém judíos. Nɨmyajpa: —Siiga iŋcutsɨgáypa yɨ́p pɨ̱xiñ, jesɨc d́a je miamigo jém emperador jém it́wɨɨp Roma. Siiga tu̱m pɨ̱xiñ nacámta̱p iga rey, jesɨc tsɨ́ypa iga jém emperador ienemigo. ");
INSERT INTO poiNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Jesɨc cuando jém Pilato imatoŋ t́i iñɨ́mayyajpa jém pɨxiñt́am, e̱ybɨct́im it́op jém Jesús jém palacio. Ininɨc aŋsɨ̱cmɨ. Co̱ñ jém Pilato jém co̱ñcuyyucmɨ ju̱t́ cɨɨpíŋóypa. Jém lugar iñɨ̱yi Gabata. Jém hebreopɨc aŋmat́i̱mɨ nɨmtooba jém piso ju̱t́ wɨ̱watneta̱ con jém tsa. ");
INSERT INTO poiNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Iwatyajpa je̱mpɨc como las seis de la mañana. Yɨ́p jém ja̱ma antes que núcpa jém jejcuyja̱ma, jeet́im semana cuando watta̱p jém pascuasɨŋ. Jesɨc jém Pilato iñɨ́máy jém judíos: —Yɨɨm it́ jém iñRey. ");
INSERT INTO poiNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Jesɨc pɨ̱mi jɨyyajpa jém pɨxiñt́am. Nɨmyajpa: —¡Accaataamɨ! ¡Accaataamɨ! ¡Cunúntaamɨ cunusyucmɨ! Jém Pilato iñɨ́máy jém pɨxiñt́am: —¿Que iñxuntámpa iga aŋcunúnpa cunusyucmɨ jém iñRey? Jesɨc jém pa̱nij aŋjagooyiyaj iñɨ́mayyajpa jém Pilato: —D́a anai̱t́a tuŋgac más rey. Aɨcht́am anrey jém emperador jém it́wɨɨp Roma. ");
INSERT INTO poiNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Jesɨc ocmɨ jém Pilato icɨɨjuŋcot Jesús jém soldado icɨɨjo̱m iga cunúnta̱iñ cunusyucmɨ. Jeeyaj ininɨcyaj jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jesɨc nanɨcta̱ Jesús. Accónneta̱ icunus. Nɨcpa jém lugar iñɨ̱yi jém Tsútsco̱bacpaccɨɨm. Iñɨ̱yit́im Gólgota jém aŋmat́i̱mɨ hebreo. ");
INSERT INTO poiNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Jemum cunúnta̱ Jesús cunusyucmɨ. Jeet́im ja̱ma cunúnta̱t́im cunusyucmɨ tuŋgac wɨste̱n pɨ̱xiñ. Páŋayt́a̱ jém icunus tu̱mtu̱m cada lado. Cucmɨ tsɨ́y jém Jesús icunus. ");
INSERT INTO poiNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Jém Pilato iwat tu̱m letrero iga accámayt́a̱iñ jém Jesús ico̱bacaŋtɨcmɨ. Jaycámneta̱: “Jesús jém Nazaretpɨc jém judíos iRey.” ");
INSERT INTO poiNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jáyaŋ jém judíos imayyajpa jém letrero porque ju̱t́ cunúnneta̱ cunusyucmɨ jém Jesús, d́a juumɨ de jém attebet Jerusalén. Watneta̱wom jém letrero tres aŋmat́i̱mɨ, jém hebreo, jém latín y griego. ");
INSERT INTO poiNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Jém pa̱nij aŋjagooyi iñɨ́mayyaj jém Pilato: —Odoy ja̱yɨ iga: “judíos iRey”, ja̱yɨ iga: “Nɨmpa yɨ́p pɨ̱xiñ iga ɨch aRey de jém judíos.” ");
INSERT INTO poiNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pero jém Pilato iñɨ́máy jém pa̱nijyaj: —Como anjayñeum, tsɨ́yñam ju̱t́pɨc anjayñe. ");
INSERT INTO poiNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Jesɨc jém soldado cuando icunúnneyajum jém Jesús cunusyucmɨ, it́obayyaj it́u̱mpɨy jém Jesús ipuctu̱cu. Iwécyaj icucuatro jém soldado, pero jém iyoot́i tácneta̱ icuyagats, d́a núnne. ");
INSERT INTO poiNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Jesɨc nanɨ́mayyajta̱p jém soldado: —D́a tanjactámpa yɨ́p yoot́i, pero tammétstámpa por sorteo i̱ icoñwɨ́ypa. Jeam imɨɨcha̱p yɨ́p yoot́i. Iwatyajpa je̱mpɨc iga cupacpa jém aŋma̱t́i juuts jayñeta̱ jém Dios iŋma̱t́i. Nɨmpa iga: “Jém pɨxiñt́am awégayyajpa ɨch ampuctu̱cu. Imétsyajpa por sorteo i̱ icoñwɨ́ypa jém anyoot́i.” Je̱mpam iwatyaj jém soldado. ");
INSERT INTO poiNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ju̱t́ cunúnneta̱ cunusyucmɨ Jesús, d́a juumɨ it́t́im ia̱pa, con ia̱pa iyo̱mtɨ̱wɨ, it́ jém Malía jém Cleofas iwɨcho̱mo y Malía Magdalena. ");
INSERT INTO poiNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesɨc cuando iix Jesús jém ia̱pa y iixt́im iga nocojo̱m te̱ñ tu̱m jém icuyujcɨɨwiñ jém tsa̱mpɨc it́oypa, jesɨc iñɨ́máy jém ia̱pa. —Miyo̱mo, je̱mpɨc it́ mich imma̱nɨc. ");
INSERT INTO poiNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Jesɨc ocmɨ jém Jesús iñɨ́máyt́im jém icuyujcɨɨwiñ jém tsa̱mpɨc it́oypa: —Je̱mpɨc it́ mich íña̱pa. Jesɨc dende jém tiempo jém pɨ̱xiñ ininɨc jém Jesús ia̱pa it́ɨccɨɨm iga iwatpa cuenta. ");
INSERT INTO poiNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jesɨc ocmɨ ijo̱doŋ Jesús iga cupacneum it́u̱mpɨy jém iyo̱xacuy. Jesɨc iga cupacpa jém Dios iŋma̱t́i, jém jaychacneta̱wɨɨp, nɨmpa: —Ɨch anɨ́ctɨtspa. ");
INSERT INTO poiNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Jemum it́ tu̱m majcuy comne con jém ta̱mpɨc vino. Jesɨc algunos imujpa juuts tu̱m pu̱qui con jém vino, iccám tu̱m waycuyyucmɨ iga igucpa Jesús uxaŋ jém vino. ");
INSERT INTO poiNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jesɨc iuc uxaŋ jém ta̱mpɨc vino, nɨm Jesús: —Cupacneum. Iɨŋquet ico̱bac, put ia̱nama, caum jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Jesɨc yɨ́p jém ja̱ma antes que núcpa jém jejcuyja̱ma. Jeet́im jejcuy ja̱ma cuyajpa jém pascuasɨŋ, jeeyucmɨ jém judíos d́a iwɨ̱aŋja̱myaj iga tsɨ́yyajpa jém tsúts cunusyucmɨ jém jejcuyja̱ma. Jesɨc iwágayyajpa jém Pilato iga ichiiñ orde iga nácsnácsquid́ayt́a̱iñ jém iwɨ̱t́puy jém cunúnneta̱wɨɨp cunusyucmɨ iga ixt́a̱iñ iga caaneum. Jesɨc wɨa̱p icquetyaj. ");
INSERT INTO poiNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Jesɨc jém soldado nɨc iñácsnácsquíd́ayyaj iwɨ̱t́puy jém wiñt́ipɨc pɨ̱xiñ jém cunúnneta̱wɨɨp cunusyucmɨ con Jesús y ocmɨ jém tuŋgac. ");
INSERT INTO poiNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pero cuando núcyaj ju̱t́ it́ jém Jesús, jém soldado iixyaj iga caaneum. Jeeyucmɨ d́a iñácsnácsquíd́áy jém iwɨ̱t́puy. ");
INSERT INTO poiNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Pero tu̱m soldado ichéŋáy ipócpacaŋna̱ca con lanza, jeet́i rato putpa nɨɨpiñ y nɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ɨch, jém ánixñewɨɨp t́i iñasca jém Jesús, atsɨ́y juuts testigo jém nu̱mapɨc iga iŋcupɨctámiñ. D́a mammɨgóyáypa. Ɨch aŋwɨ̱jo̱doŋ t́i sɨ́p manaŋmadáy. ");
INSERT INTO poiNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Iwatyajpa je̱mpɨc iga cupacpa jém aŋma̱t́i ju̱t́ jayñeta̱ jém Dios iŋma̱t́i. Nɨmpa iga: “D́a i̱ iquid́áypa ni tu̱m ipac.” ");
INSERT INTO poiNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Tuŋgac parte nɨmpat́im jém Dios iŋma̱t́i: “Jém pɨxiñ agui iámyajpa jém pɨ̱xiñ jém tseŋneta̱wɨɨp.” ");
INSERT INTO poiNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","It́t́im je̱m tu̱m pɨ̱xiñ iñɨ̱yi José, Arimateapɨc pɨ̱xiñ. Icupɨcnet́im Jesús, pero iŋyampa iga icupɨcpa porque tsa̱m icɨ̱ŋpa jém Israelpɨc aŋjagooyiyaj. Jesɨc cuando caaneum Jesús, jém José nɨc iwágáy permiso jém Pilato iga ininɨgáypa Jesús imɨjta̱y. Jém Pilato ichi permiso. Jesɨc jém José oy ipɨgáy imɨjta̱y, ininɨc. ");
INSERT INTO poiNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Sɨɨbat́im jém Nicodemo, jém oyñewɨɨp iám Jesús tsuucɨɨm. Jém Nicodemo inimiñ cien libras jém poot́i jém cɨ̱npaap, namotneta̱ jém mirra con jém áloes. ");
INSERT INTO poiNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Jesɨc jém José y jém Nicodemo ininɨgáy jém Jesús imɨjta̱y. Iccámayyaj jém poot́i jém cɨ̱npaap, iŋmónayyaj con wɨbɨc puctu̱cu. Iwadáy it́u̱mpɨy juuts jém Israelpɨc pɨxiñt́am icostumbre cuando icumpa tu̱m tsúts. ");
INSERT INTO poiNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Je̱m ju̱t́ cunúnta̱ cunusyucmɨ jém Jesús it́ tu̱m huerto. Jém huertojo̱m it́ tu̱m tsaajos yaguiñ watneta̱, ju̱t́ cu̱mta̱p tsúts. Pero d́a i̱ queman icot ni tu̱m tsúts jém tsaajosjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Noco it́ jém tsaajos. Jeeyucmɨ jém José y Nicodemo nɨc icodayyaj jém Jesús imɨjta̱y jém tsaajosjo̱m porque tsucumtoobam jém jejcuy ja̱ma iga jejyajpa jém judíos. ");
INSERT INTO poiNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Jesɨc cuando nasneum jém jejcuyja̱ma, jém tuŋgagam ja̱ma, icuqueja̱ma, jém Malía Magdalena nɨc tsuuyt́im jém tsaajoscɨɨm. Piichɨnam. Mu iñúc, iix iga jopputneta̱wum jém tsa jém jos iŋnúccuy. ");
INSERT INTO poiNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Jesɨc póyaŋtsucum jém Malía, nɨc iám jém Peto y jém tuŋgac icuyujcɨɨwiñ, jém tsa̱mpɨc it́oypa Jesús. Jém Malía iñɨ́máy jém wɨste̱n icuyujcɨɨwiñ: —Topneta̱wum jém tánO̱mi imɨjta̱y jém tsaajosjo̱m, nanɨcneta̱wum. D́a anjo̱doŋ ju̱t́ tsacta̱. ");
INSERT INTO poiNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Jesɨc moj nɨqui jém Peto con jém tuŋgac jém Jesús icuyujcɨɨwiñ. Nɨcyajpa jém tsaajoscɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Poyi̱mɨ nɨcyaj icuɨstɨc, pero jém tuŋgac icuyujcɨɨwiñ más jicscɨy nɨc que jém Peto. Aŋjagóy miñúc jém tsaajoscɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Jém mojnewɨɨp nuuqui ámcúm jém tsaajosjo̱m. Iix iga it́ no más jém wɨbɨc puctu̱cu, jém Jesús iŋmónóycuy, pero d́a tɨgɨy jém tsaajosjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ocmɨm núc jém Peto, tuuñiaŋcɨɨm miñ. Tɨgɨy jém tsaajosjo̱m. Iixt́im iga jemum it́ no más jém iŋmónóycuy. ");
INSERT INTO poiNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Iixt́im iga it́ jém ico̱bacaŋmónóycuy, pacsneta̱wum, tsacneta̱wum tu̱m áŋe̱ymɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Jesɨc tɨgɨy mex jém tuŋgac icuyujcɨɨwiñ, jém mojnewɨɨp nuuqui jém tsaajoscɨɨm. Iix iga d́a i̱ jém Jesús imɨjta̱y, jesɨc icupɨc iga pɨsneum. ");
INSERT INTO poiNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Porque d́anam icutɨɨyɨyñeyaj jém Dios iŋma̱t́i ju̱t́ jayñeta̱ iga tienes que pɨspa jém Jesús de ju̱t́ it́ jém caaneyajwɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Jesɨc jém wɨste̱n jém icuyujcɨɨwiñ se̱tyaj e̱ybɨc it́ɨccɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Pero tsɨ́y jém Malía jém tsaajosaŋna̱ca. Wejpa jém yo̱mo. Iganam wejpa ámcúmpa jém tsaajosjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Iix wɨste̱n jém sɨŋyucmɨpɨc pɨ̱xiñ. Agui po̱po ipuctu̱cu. Jemum co̱ñyaj ju̱t́ it́ id́ɨc jém Jesús imɨjta̱y. Tu̱m co̱ñ ju̱t́ it́ id́ɨc ico̱bac, tu̱m co̱ñ ju̱t́ it́ id́ɨc ipuy. ");
INSERT INTO poiNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Jesɨc jeeyaj icwácyajpa jém Malía. Nɨ́mayt́a̱p: —Miyo̱mo, ¿t́iiga miwejpa? Jesɨc nɨmpa jém Malía: —Awejpa porque nanɨcneta̱wum jém ánO̱mi imɨjta̱y y d́a anjo̱doŋ ju̱t́ tsagayñeta̱. ");
INSERT INTO poiNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Cuando yaj jɨ̱yi jém Malía, ámse̱t it́uuñiaŋcɨɨm. Iix iga jemum te̱ñ jém Jesús. Pero d́a icutɨɨyɨ́ypa iga nu̱ma jeam jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesɨc Jesús iñɨ́máy jém Malía: —Miyo̱mo, ¿t́iiga miwejpa? ¿I̱ immétspa? Jém Malía d́a iixpɨcpa iga jeam jém Jesús, iŋja̱mpa iga je jém pɨ̱xiñ jém iwatpáppɨc cuenta jém huerto. Jeeyucmɨ Malía iñɨ́máy: —Mimich, siiga ininɨcne jém ánO̱mi imɨjta̱y, aŋmadaayɨ ju̱t́ iñchacne, jesɨc nɨcpa ampɨc. ");
INSERT INTO poiNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesɨc nɨmpa Jesús: —¡MiMalía! Jesɨc ámse̱t jém Malía. Ijɨ́yáy jém Jesús. Nɨ́mayt́a̱ jém hebreopɨc aŋmat́i̱mɨ: —¡Raboni! Tanaŋmat́i̱mɨ nɨmtooba: MamMaestro. ");
INSERT INTO poiNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesɨc Jesús iñɨ́máypa jém Malía: —Odoy atsɨ̱cɨ porque d́anam aquímne ju̱t́ it́ anJa̱tuŋ Dios. Sɨɨp nɨ̱gɨ aŋmadaayɨ jém tantɨ̱wɨtam, jém aŋcuyujcɨɨwiñ, iga aquímgacpa ju̱t́ it́ jém anJa̱tuŋ y iñJa̱tuŋt́im mimicht́am, hasta ju̱t́ it́ ɨch anDios y iñDiost́im mimicht́am. ");
INSERT INTO poiNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Jesɨc jém Malía Magdalena nɨc iŋmadáy jém Jesús icuyujcɨɨwiñ. Nɨmpa jém Malía: —Ánixñeum jém tánO̱mi. Iŋmadáyt́im jeeyaj t́i iñɨ́máy jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Jesɨc jém wiñt́ipɨc ja̱ma de jém semana, aŋtuuma̱neyaj tsuucɨɨm jém Jesús icuyujcɨɨwiñ tu̱m tɨcjo̱m. Wɨ̱aŋpajneta̱ jém tɨc porque tsa̱m icɨ̱ŋyajpa jém judíos. Jesɨc jeet́i rato iixyaj iga jém Jesús iwaganait́yajum icuyujcɨɨwiñ. Pero d́a i̱ iix ju̱t́ tɨgɨy. Nɨmpa jém Jesús: —¡Xutsóyt́am! ");
INSERT INTO poiNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Mu iñɨ́máy Jesús, jesɨc iŋquejáy jém icɨ y ipócpacaŋna̱ca ju̱t́ coowa̱ne. Jesɨc icuyujcɨɨwiñ cuando iixyaj jém tánO̱mi, tsa̱m pɨ̱mi maymayyaj. ");
INSERT INTO poiNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jesɨc e̱ybɨct́im iñɨ́máy Jesús: —¡Xutsóyt́am! Juuts jém anJa̱tuŋ Dios acutsat yɨ́p naxyucmɨ iga aŋwatpa jém Dios iyo̱xacuy, je̱mpɨct́im maŋcutsattámpa mimicht́am iga iŋwattámiñ jém Dios iyo̱xacuy. ");
INSERT INTO poiNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Jesɨc cuando yaj iŋmadáy je̱mpɨc jém Jesús, ixujpa jém icuyujcɨɨwiñ. Iñɨ́máy: —Pɨctsoŋtaamɨ jém Dios iA̱nama. ");
INSERT INTO poiNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Siiga mimicht́am iñyo̱xpátpa jém pɨxiñt́am iga jeeyaj iŋmadáypa Dios it́áŋca, jesɨc wadayt́a̱p perdón jém it́áŋca. D́am i̱ ichiiba castigo. Pero siiga d́a iñyo̱xpátpa jém pɨxiñt́am iga iŋmadáypa Dios it́áŋca, jesɨc d́a i̱ iwadáypa perdón jém it́áŋca. ");
INSERT INTO poiNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Pero jém Tomax tu̱m de jém docepɨc icuyujcɨɨwiñ, jém iñɨ̱yit́im Me̱chi, d́a i̱ con los de más cuando núc jém Jesús ju̱t́ it́ icuyujcɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Jesɨc jém tuŋgac icuyujcɨɨwiñ iŋmadayyaj jém Tomax t́i iixñeyaj: —Ánixñetámum jém tánO̱mi. Pero jém Tomax iñɨ́máy jeeyaj: —Siiga d́a ánixáypa icɨ ju̱t́ jetne con jém clavos y aŋcodáypa aŋwaycɨ ju̱t́ coowa̱ne y siiga d́a aŋcucompa aŋcɨ ju̱t́ tseŋayñeta̱ jém ipócpacaŋna̱ca, jesɨc d́a aŋcupɨcpa. ");
INSERT INTO poiNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Jesɨc tuŋgagam ocho día e̱ybɨct́im aŋtuuma̱yaj jém Jesús icuyujcɨɨwiñ tu̱m tɨccɨɨm. Jesɨc i̱t́um mex jém Tomax. Iwɨ̱aŋpajneyajt́im jém tɨc. Jesɨc e̱ybɨct́im miñ Jesús, iwaganait́yaj jém icuyujcɨɨwiñ. D́a i̱ iix ju̱t́ tɨgɨy jém Jesús. Iñɨ́máy jeeyaj: —¡Xutsóyt́am! ");
INSERT INTO poiNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Jesɨc iñɨ́máy jém Tomax: —Mi̱ñɨ aámaayɨ jém aŋcɨ. Co̱tɨ iŋwaycɨ ju̱t́ coowa̱ne. Cuco̱mɨ iŋcɨ ju̱t́ coowa̱ne jém ampócpacaŋna̱ca. Tsa̱cɨ iga d́a iŋcupɨcpa. Cupɨ̱cɨ iga apɨsneum. ");
INSERT INTO poiNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Jesɨc jém Tomax iñɨ́máy jém Jesús: —¡MánO̱mi, manDios! ");
INSERT INTO poiNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesɨc Jesús iñɨ́máy jém Tomax: —Mich iŋcupɨcpa iga apɨsneum porque ánixñe. Pero tsa̱m wɨ̱it́pa jém d́apɨc ánixñeyaj, pero icupɨcyajpa iga apɨsneum. ");
INSERT INTO poiNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jém Jesús tsa̱m jáyaŋ wɨ̱tampɨc milagro iwat cuando iwaganait́ icuyujcɨɨwiñ. Pero d́a anjaycámne it́u̱mpɨy jém milagro yɨ́p librojo̱m. ");
INSERT INTO poiNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pero yɨɨmpɨc anjaycámneum iga iŋcupɨctámiñ iga Jesús je jém Cristo jém Dios iMa̱nɨc. Siiga iŋcupɨctámpa, jesɨc impɨctsoŋtámpa jém vida jém d́apɨc cuyajpa jém tánO̱mi Cristo iñɨyi̱mɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Jesɨc ocmɨm Jesús iwiñquejáy e̱ybɨct́im jém icuyujcɨɨwiñ jém laguna aŋna̱ca jém Tiberias. Yɨɨmpɨc iwiñquejáy jém icuyujcɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Iwaganait́yaj jém Ximoj Peto algunos jém Jesús icuyujcɨɨwiñ. It́ jém Tomax, iñɨ̱yit́im Me̱chi, it́t́im Natanael jém Galileapɨc pɨ̱xiñ, it́t́im Zebedeo ima̱nɨctam con tuŋgac wɨste̱n jém icuyujcɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Jesɨc jém Ximoj Peto iñɨ́máy jém icompañeroyaj: —Nɨcpa atɨɨpma̱chi. Nɨmyaj jeeyaj: —Anɨctámpat́im. Tawaganɨcpa. Jesɨc nɨcyaj, químyaj tu̱m barcojo̱m. Pero jém tsuu d́a t́i imatsyaj ni tu̱m tɨɨpɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Jesɨc cuquejtoobam, núc Jesús jém nɨ aŋna̱ca. Pero jém icuyujcɨɨwiñ d́a iixpɨcyaj iga Jesús. ");
INSERT INTO poiNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jesɨc jɨypa Jesús, iñɨ́máy: —¿Miwo̱ñjaychɨ̱xt́am, d́a iniit́t́a tɨɨpɨ? Jeeyaj icutsoŋyaj. Nɨmyaj: —D́a i̱. ");
INSERT INTO poiNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Jesɨc jém Jesús iñɨ́máy jeeyaj: —Co̱tɨ jém iñred jém aŋwɨ̱mɨpɨc lado de jém imbarco. Jemum immatspa jém tɨɨpɨ. Jesɨc icotyaj jém ired y tsa̱m jáyaŋ tɨɨpɨ imatsyaj. D́a wɨa̱p it́opyaj jém ired porque tsa̱m jáyaŋ tɨɨpɨ imatsyaj. ");
INSERT INTO poiNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Jesɨc jém Jesús icuyujcɨɨwiñ, jém tsa̱mpɨc it́oypa, iñɨ́máy jém Peto: —Yɨ́bam jém tánO̱mi. Jesɨc cuando jém Peto imatoŋ iga tánO̱mi, icot iyoot́i, porque iccáyñe id́ɨc iga tɨɨpmatspa. Quet jém barcojo̱m, tɨgɨy nɨɨcɨɨm jém Peto iga nɨcpa iám jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Jesɨc los de más jém Jesús icuyujcɨɨwiñ inimiñyaj jém barco hasta playa aŋna̱ca. Ijɨ̱cneyaj jém red comne de tɨɨpɨ, porque d́a juumɨ jém playa como cien metros. ");
INSERT INTO poiNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Cuando putyaj aŋsɨ̱cmɨ, ipátyaj ju̱t́ acnúcneta̱ juctɨ. Iixyaj iga sɨ́p ijaasta̱ tɨɨpɨ juuyjo̱m, it́t́im caxt́ána̱ñi. ");
INSERT INTO poiNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesɨc Jesús iñɨ́máy icuyujcɨɨwiñ: —Nami̱ñɨ algunos jém tɨɨpɨ jém yaguiñpɨc immatsta. ");
INSERT INTO poiNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Jém Peto quím jém barcoyucmɨ, iwij jém ired, moj ijɨ̱c aŋsɨ̱cmɨ. Comne jém red con mɨjtampɨc tɨɨpɨ. It́yaj ciento cincuenta y tres. Tsa̱m jáyaŋ tɨɨpɨ, pero d́a jac jém red. ");
INSERT INTO poiNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesɨc Jesús iñɨ́máy jém icuyujcɨɨwiñ: —Mi̱ñɨ miwiiquit́am. Ni tu̱m de jém icuyujcɨɨwiñ d́a icwácyaj iga: “¿Mii̱apaap?” Porque iñuntawɨ̱jo̱doŋ iga tánO̱mi. ");
INSERT INTO poiNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesɨc Jesús icunúc, ipɨc jém caxt́ána̱ñi icɨɨjo̱m, ichi icuyujcɨɨwiñ, jesa̱pt́im iwat con jém tɨɨpɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Sɨɨp tres vecesam iwiñquejáy Jesús jém icuyujcɨɨwiñ dende pɨsne. ");
INSERT INTO poiNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Jesɨc yaj wiiquiyaj, jém Jesús icwác jém Peto. Nɨ́mayt́a̱: —MiPeto, jém Jonás mima̱nɨc, ¿que mich más antoypa que jém tuŋgac aŋcuyujcɨɨwiñ? Jesɨc Peto icutsoŋ. Iñɨ́máy jém Jesús: —Nu̱ma, mánO̱mi, mich iñjo̱doŋ iga tsa̱m mantoypa. Jesɨc Jesús iñɨ́máy jém Peto: —Acwiicɨ jém amma̱ñborregoyaj. ");
INSERT INTO poiNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jesɨc e̱ybɨct́im icwácpa Jesús jém Peto. Nɨ́mayt́a̱: —MiPeto, jém Jonás mima̱nɨc, ¿que tsa̱m antoypa? Jém Peto icutsoŋ. Nɨmpa: —Nu̱ma, mich iñjo̱doŋ iga tsa̱m mantoypa. Jesɨc Jesús iñɨ́máy: —Wa̱tɨ cuenta jém amborregoyaj. ");
INSERT INTO poiNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jém Jesús túccɨyam icwácpa jém Peto. Nɨ́mayt́a̱p: —MiPeto, jém Jonás mima̱nɨc, ¿que tsa̱m antoypa? Jesɨc jém Peto tsa̱m aŋyác porque tres vecesam icwácpa siiga it́oypa, jesɨc iñɨ́máy jém Jesús: —MánO̱mi, mich iñjo̱doŋ it́u̱mpɨy cosa. Iñjo̱doŋt́im iga mantoypa. Jesɨc Jesús iñɨ́máy jém Peto: —Acwícya̱jɨ jém amborregoyaj. ");
INSERT INTO poiNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nu̱ma mannɨ́máypa iga cuando d́anam micha̱mi, jesɨc iŋcotpa iñyaac jém iñyoot́i y miñɨcpa ju̱t́ mich iñxunpa. Pero cuando micha̱mim, jesɨc iñt́ɨ̱mpa iŋcɨ y tuŋgac miccámáypa iñyoot́i. Mininɨcpa ju̱t́ mich d́a miñɨctooba. ");
INSERT INTO poiNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Nɨmpa je̱mpɨc Jesús iga icjo̱dóŋa̱p ju̱t́pɨc accaata̱p jém Peto iga cujípta̱iñ Dios. Jesɨc Jesús iñɨ́máy jém Peto: —Atúŋɨɨyɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Jesɨc ámse̱tpa jém Peto, iix iga it́úŋɨ́ypa jém tuŋgac jém Jesús icuyujcɨɨwiñ jém tsa̱mpɨc it́oypa, jém ipɨtsnewɨɨp cuando wagawícyajpa jém pascuasɨŋ. Jeet́im pɨ̱xiñ jém icwácnewɨɨp Jesús iga: “¿I̱ miwadáypa atraición?” ");
INSERT INTO poiNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Cuando Peto iix iga it́úŋɨ́ypa jém pɨ̱xiñ, jesɨc iñɨ́máypa jém Jesús: —MánO̱mi, ¿t́i iñascaaba yɨ́p pɨ̱xiñ? ");
INSERT INTO poiNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesús icutsoŋ. Nɨ́mayt́a̱p jém Peto: —Siiga ɨch ansunpa iga d́a caaba yɨ́p pɨ̱xiñ hasta amiñgacpa, ¿jesɨc mich iñt́icutɨgɨ̱yɨ? Mich atúŋɨɨyɨ. ");
INSERT INTO poiNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Núc jém aŋma̱t́i ju̱t́ it́ jém icupɨcneyajwɨɨp Jesús, waŋpa iga d́a caaba jém tu̱m jém icuyujcɨɨwiñ, jém tsa̱mpɨc it́oypa. Pero Jesús d́a nɨm iga d́a caaba jém pɨ̱xiñ. Nɨm iga: “Siiga ɨch ansunpa iga d́a caaba yɨ́p pɨ̱xiñ hasta amiñgacpa, ¿jesɨc mich iñt́icutɨgɨ̱yɨ?” ");
INSERT INTO poiNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ɨcham jém aXiwan jém tsa̱mpɨc atoypa jém Jesús, jeeyucmɨ wɨa̱p manaŋmadáy yɨ́pyaj cosa. Sɨɨp anjaycámpa librojo̱m. Anjo̱doŋ iga d́a je mɨgooyi. ");
INSERT INTO poiNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","It́yaj jáyaŋ cosa más jém iwatnewɨɨp Jesús. Siiga jaycámta̱p it́u̱mpɨy cosa juuts iwatne Jesús, ɨch anɨmpa iga icuwɨ̱t́i yɨ́p naxyucmɨ d́a cutɨgɨyyajpa jém libro. Jemum cuyaj.");
INSERT INTO poiNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Mánamigo Teófilo, jém wint́ipɨc to̱to manjáyáy t́it́am iwat Jesús y t́it́am iŋquej dende wiñt́i ");
INSERT INTO poiNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","hasta jém ja̱ma cuando químgacpa sɨŋyucmɨ. Antes que químgacpa sɨŋyucmɨ iŋquejáy jém apóstolyaj, jém icupiŋnewɨɨp, t́i wɨa̱p iwatyaj. Iŋquejáy con jém Dios iA̱nama. ");
INSERT INTO poiNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Jesɨc cuando yaj iñasca jém yaacha̱ji iga mu iccaata̱, iwiñquejáy e̱ybɨc jém icuyujcɨɨwiñ iga vivo. Cuarenta ja̱ma iwiñquejáy jém ipɨxiñt́am wa̱t́i veces iga iixyajiñ iga d́a caane. Iŋmadáy jutsa̱p iŋjac Dios jém it́yajwɨɨp yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Tu̱m ja̱ma cuando aŋtuuma̱neyajum jém icuyujcɨɨwiñ, jém Jesús iŋquím iga odoy putyajiñ jém attebet Jerusalén. Iñɨ́máy iga: —Aŋjoocɨ hasta que cupacpa juuts mijɨycámayñe jém tanJa̱tuŋ Dios juuts ɨch mannɨ́mayñe. ");
INSERT INTO poiNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Mannɨ́máy iga jém Xiwan acchíŋóypa con nɨ, pero d́a jáypa michiit́amta̱p jém Dios iA̱nama. ");
INSERT INTO poiNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Jesɨc jém aŋtuuma̱neyajwɨɨp icwácyajpa jém Jesús: —¿Que yɨ́pt́i rato mojpa iniŋjac yɨ́p tannaxyucmɨ Israel? ");
INSERT INTO poiNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesús icutsoŋ, iñɨ́máy: —Micht́am d́a wɨa̱p iñjo̱dóŋa̱ta jucha̱ ni júp ja̱ma iwatpa jém tanJa̱tuŋ Dios, iwatpa con ipɨ̱mi juuts je ixunpa. ");
INSERT INTO poiNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pero mimicht́am impɨctsoŋtámpa jém Dios ipɨ̱mi. Michiit́amta̱p jém Dios iA̱nama iga wɨa̱p iniŋmadáy jém pɨxiñt́am t́it́am íñix iga ɨch aŋwatne. Mojpa iniŋmatta Jerusalén, icuwɨ̱t́i jém naxyucmɨ de Judea, hasta jém naxyucmɨ de Samaria, y hasta más juumɨ, icuwɨ̱t́i de yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Cuando yaj iŋmadáy jém icuyujcɨɨwiñ, naquímta̱ Jesús sɨŋyucmɨ. Iganam sɨ́p iámyaj, ucsɨtogoy. D́am i̱ más iix. ");
INSERT INTO poiNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Iganam iámyajpa ju̱t́ químpa Jesús sɨŋyucmɨ, jeet́i rato miñ iwaganate̱ñ wɨste̱n pɨ̱xiñ, agui po̱po ipuctu̱cu. ");
INSERT INTO poiNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Iñɨ́máy: —MiGalileapɨc mipɨxiñt́am, ¿t́iiga miámquímneta sɨŋyucmɨ? Yɨ́pt́im Jesús, jém químnewɨɨp sɨŋyucmɨ, je̱mpɨct́im miñgacpa e̱ybɨc. ");
INSERT INTO poiNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Jesɨc se̱tyaj Jerusalén de jém co̱tsɨc iñɨ̱yi Olivos. Ijuumɨ juuts nɨmpa jém ley iga wɨa̱p taŋwit́ tu̱m jejcuy ja̱ma. ");
INSERT INTO poiNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Cuando núcyaj jém attebet Jerusalén, químyaj jém yucmɨpɨc piso. Tɨgɨyyaj jém cuarto jém iñúcsneyajwɨɨp. Jemum it́t́im Peto, Jacobo, Xiwan, Anti, Felipe, Tomax, Bartolo, Mateo, jém tuŋgac Jacobo jém Alfeo ima̱nɨc, Ximoj Zelote y Judas jém Jacobo it́ɨ̱wɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Aŋtuuma̱neyaj iga seguido iwatyajpa oración con tu̱mt́i ijɨ̱xi. Jemum it́t́im jém yo̱mtam; jém Malía, jém Jesús ia̱pa con Jesús it́ɨ̱wɨtam. ");
INSERT INTO poiNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Jesɨc tu̱m ja̱ma iganam aŋtuuma̱neyaj, te̱ñchucum jém Peto jém pɨxiñt́ámaŋjo̱m, it́yaj je̱m como ciento veinte. Nɨmpa jém Peto: ");
INSERT INTO poiNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Mimicht́am mantɨ̱wɨtam, tienes que cupacpa jém Dios iŋma̱t́i juuts nɨm jém David cuando iŋquejáy jém Dios iA̱nama t́i miñpa. Iŋmatpa iga jém Judas icɨɨjuŋcotpa jém Jesús iga matsta̱iñ. ");
INSERT INTO poiNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Jém Judas it́ id́ɨc con aɨcht́am jém docepɨc jém Jesús icuyujcɨɨwiñ. Taŋwaganayo̱xatámpa id́ɨc. ");
INSERT INTO poiNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Juyt́a̱ tu̱m ja̱ca nas con jém tumiñ jém icoñwɨyñewɨɨp iga imalwadáy jém Jesús. Ocmɨ mutsneactɨŋ, tojaŋsaj ipuu, cupudáy. ");
INSERT INTO poiNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Cuando ijo̱dóŋa̱yaj t́i iñasca jém Judas, jém Jerusalénpɨc pɨxiñt́am icnɨɨya̱yaj jém nas Acéldama. Jeeyaj iŋmat́i̱mɨ nɨmtooba jém nas jém nɨɨpiñ cho̱wa. ");
INSERT INTO poiNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Porque nɨmpa jém Salmojo̱m ju̱t́ jayñeta̱: D́a oomɨ́ypa ichɨ́y jém iñas. D́a i̱ nɨcpa i̱t́i je̱m. Nɨmpat́im: Tuŋgac tsɨ́ypa iga iwatpa jém iyo̱xacuy. ");
INSERT INTO poiNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Jesɨc nɨmpat́im jém Peto: —Sɨɨp taŋcupiŋpa tu̱m de jém taŋwaganait́wɨɨp seguido cuando sɨɨba tánO̱mi Jesús con taɨcht́am, ");
INSERT INTO poiNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","dende icchiŋ jém Xiwan hasta químgac Jesús sɨŋyucmɨ. Tu̱m de taɨcht́am tsɨ́ypa juuts tu̱m testigo iga nu̱ma pɨsneum jém tánO̱mi Jesús de ju̱t́ it́ jém caaneyajwɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Jesɨc cupiŋta̱ wɨste̱n de jeeyaj. Tu̱m jém José, iñɨ̱yi Barsabás, iñɨ̱yit́im Justo. Jém tuŋgac iñɨ̱yi Matías. ");
INSERT INTO poiNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Jesɨc los demás iŋwejpátyajpa Dios. Nɨmyajpa: —MánO̱mi, mich íñixpɨgáypa it́u̱mpɨy jém pɨxiñt́am ia̱nama. Aŋquejaayɨ juppɨc de yɨ́p wɨste̱n mich iŋcupiŋ ");
INSERT INTO poiNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","iga iwad́iñ jém yo̱xacuy juuts jém apóstolyaj jém iŋcutsatnewɨɨp. Togoy jém Judas iga tsa̱m imalwat. Nɨc ju̱t́ ipɨctsoŋpa jém icastigo. ");
INSERT INTO poiNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Jesɨc iwatyajpa tu̱m sorteo. Icoñwɨ́y jém Matías, cupiŋneta̱. Accámta̱ con jém once apóstolyaj. ");
INSERT INTO poiNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Cuando núc jém ja̱ma de pentecostés, aŋtuuma̱neyaj tu̱mt́i lugar it́u̱mpɨy jém icupɨcneyajwɨɨp Jesús. ");
INSERT INTO poiNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Jeet́i rato imatoŋyaj tu̱m mɨjpɨc aŋjɨ̱yi sɨŋyucmɨ juuts tu̱m mɨjpɨc sa̱wa. Tsa̱m pɨ̱mi ju̱pa. Tɨgɨy jém iŋjɨ̱yi tɨcjo̱m ju̱t́ co̱ñyaj jeeyaj. ");
INSERT INTO poiNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Jesɨc iixyaj jáyaŋ juctɨaŋqui̱ñi. Nawécta̱ jém juctɨaŋqui̱ñi, núcyaj cada tu̱mtu̱m jém pɨxiñt́am ico̱bacyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ipɨctsoŋyaj jém Dios iA̱nama, tsa̱m iniit́ ia̱namaŋjo̱m. Mojpa iŋmat tuŋgac aŋmat́i̱mɨ juuts ipɨɨmɨ́ypa jém Dios iA̱nama. ");
INSERT INTO poiNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Jém tiempo aŋtuuma̱neyaj Jerusalén jém Israelpɨc pɨxiñt́am iga iwatyajpa juuts jém icostumbre iga ijɨ̱syajpa Dios. Miññeyaj de it́u̱mpɨy nación icuwɨ̱t́i yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Cuando imatoŋyaj iga tsa̱m pɨ̱mi ju̱pa, aŋtuuma̱neyaj it́u̱mpɨy jém pɨxiñt́am. Tsa̱m cɨ̱ŋyaj, d́a icutɨɨyɨ́y t́i iwatyajpa porque cada tu̱mtu̱m imatoŋ iga jɨyyajpa jeeyaj iŋmat́i̱mɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Tsa̱m ipooñaŋja̱myaj, ámaŋjacyaj. Nanɨ́mayyajta̱p entre jeeyaj: —¿Que d́a it́u̱mpɨy jém sɨɨppɨc jɨyyajpa Galileapɨc pɨxiñt́am? ");
INSERT INTO poiNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Junɨm ammatoŋtámpa iga jɨypa annuntaaŋmat́i̱mɨ? ");
INSERT INTO poiNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Yɨɨm it́t́im jém pɨxiñt́am de tuŋgac naxyucmɨ. Miññeyaj de jém naxyucmɨ de Partia, de Media, de Elam, de Mesopotamia, de Judea, de jém naxyucmɨ de Capadocia, de jém Ponto y de jém naxyucmɨ de Asia. ");
INSERT INTO poiNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","It́t́im de Frigia, de Panfilia, de Egipto y de jém naxyucmɨ de África jém más juumɨpɨc de Cirene. It́t́im jém Romapɨc pɨxiñt́am jém yaguiñpɨc miññe. It́t́im jém nunta Israelpɨc pɨxiñt́am y jém tuŋgacpɨc pɨxiñt́am jém mojwɨɨp icupɨc jém judíos iŋquímayooyi. ");
INSERT INTO poiNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","It́t́im jém pɨxiñt́am de Creta y de Arabia. Ammatoŋta aɨcht́ampɨc anaŋmat́i̱mɨ iga aŋmadayyajpa jém wɨ̱tampɨc cosa jém tawadayñewɨɨp Dios. ");
INSERT INTO poiNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","It́u̱mpɨy agui ipooñaŋja̱myaj. D́a icutɨɨyɨ́y t́i wɨa̱p ijɨ̱syaj. Nacwácyajta̱p: —¿Yɨ́p t́i nɨmtooba? ");
INSERT INTO poiNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pero tuŋgac ixaayɨyyajpa. Nɨmpa: —Yɨ́pyaj u̱quiyaj. ");
INSERT INTO poiNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Pero jém Peto te̱ñchucum con jém once apóstolyaj. Pɨ̱mi jɨy. Iñɨ́máy jém aŋtuuma̱neyajwɨɨp: —MiJudeapɨc mipɨxiñt́am con iñt́u̱mpɨy jém miit́t́aŋwɨɨp Jerusalén, wɨ̱jo̱dóŋa̱taamɨ t́i mannɨ́máypa. Matoŋtaamɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Yɨ́p pɨxiñt́am d́a u̱quiyaj juuts micht́am iñjɨ̱stámpa porque yaguiñ tait́ a las nueve de la mañana. ");
INSERT INTO poiNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Iwatyajpa je̱mpɨc porque asíam nɨmpa jém wiñɨcpɨc profeta jém Joel: ");
INSERT INTO poiNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Jém íŋaŋpɨgam ja̱ma, nɨmpa Dios, anchiiba ánA̱nama jém pɨxiñt́am. Micht́am iñjayma̱nɨctam y jém iñyo̱mma̱nɨctam iŋmatyajpa ɨch anaŋma̱t́i. Jém wo̱ñjaychɨ̱xt́am iixyajpa po̱ñ. Jém wɨd́ayt́am ma̱wíña̱yajpa. ");
INSERT INTO poiNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Anchiiyajpa jém ánA̱nama jém acuyo̱xayajpáppɨc jém pɨxiñt́am y jém yo̱mtam iga iŋmatyajpa ɨch anaŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Sɨŋyucmɨ manaŋquejáypa jém impooñaŋja̱mpáppɨc jém d́apɨc oypa íñix. Naxyucmɨ manaŋquejáypat́im seña. Jém seña juuts nɨɨpiñ, juuts juctɨ, juuts ucsjo̱co. ");
INSERT INTO poiNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Jém ja̱ma píchpa icho̱ca, jém po̱ya tsɨ́ypa juuts nɨɨpiñ antes que núcpa jém ja̱ma iga miñpa jém íñO̱mi. Jesɨgam agui wɨ̱quejpa jém Dios ipɨ̱mi. ");
INSERT INTO poiNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Jesɨc tanJa̱tuŋ Dios icɨacputpa it́u̱mpɨy jém iŋwejpátyajpáppɨc jém tánO̱mi iñɨyi̱mɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Nɨmt́im jém Peto: —MiIsraelpɨc mipɨxiñt́am, amatóŋayt́aamɨ t́i mannɨ́máypa. Tsa̱m wɨ̱quejpa mimicht́ámaŋjo̱m iga Dios icutsat jém Jesús jém Nazaretpɨc pɨ̱xiñ. Dios ichi ipɨ̱mi iga wɨa̱p iwat jém d́apɨc oypa tánix, jém wɨbɨc milagro y jém seña. Micht́am iŋwɨ̱jo̱doŋtam. ");
INSERT INTO poiNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Pero micht́am d́a iŋwadáy caso iga Dios icutsat jém Jesús. Iŋcɨɨjuŋcotta jém enemigo icɨɨjo̱m. Iñasca je̱mpɨc porque dende wiñɨgam ixunpa Dios iga mimicht́am iŋcɨɨjuŋcottámpa jém malopɨc pɨxiñt́am icɨɨjo̱m iga accaata̱iñ cunusyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pero Dios icpɨs. Icɨacput. Porque d́a wɨa̱p iga caaneeba ichɨ́y. ");
INSERT INTO poiNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Jém wiñɨcpɨc aŋjagooyi David iŋmatpa de Jesús cuando nɨmpa: Siempre ánixpa jém ánO̱mi aŋwiñjo̱m. Awaganait́ aɨch iga odoy acɨɨŋiñ. ");
INSERT INTO poiNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Jeeyucmɨ ɨch agui amaymay ána̱namaŋjo̱m. Anaŋmatpa jém wɨbɨc aŋma̱t́i porque agui amaymay. Jeeyucmɨ d́a acɨ̱ŋpa iga acaaba porque anjo̱doŋ iga apɨspa. ");
INSERT INTO poiNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ManJa̱tuŋ Dios, mich d́a iñchacpa ána̱nama jém lugar ju̱t́ it́ jém caaneyajwɨɨp. D́at́im iñjɨ́cpa iga púcpa imɨjta̱y jém micuyo̱xapáppɨc jém Cuáyñewɨɨp iA̱nama. ");
INSERT INTO poiNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Anaŋquejáy jém tuŋ jém ananɨcpáppɨc ju̱t́ ampɨctsoŋpa jém vida. Agui amaymay iga nɨcpa awagai̱t́i con mimich. Je̱mpam nɨmpa jém David cuando iŋmatpa de Cristo. ");
INSERT INTO poiNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Jesɨc nɨmt́im Peto: —Mantɨ̱wɨtam, tsa̱m wɨ̱quejpa iga caaneum jém tanja̱tuŋwe̱we David, cumta̱ jém tsaajosjo̱m. Hasta sɨɨp yɨɨm it́ jém tsaajos. ");
INSERT INTO poiNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Pero jém David tu̱m jém Dios iŋmat́cɨɨwiñ id́ɨc. Ijo̱doŋ iga Dios ijɨycámayñe iga tu̱m jém io̱cma̱nɨc, jém naypáppɨc ocmɨ, jeam jém Cristo. Tsɨ́ypa juuts jém más mɨjpɨc aŋjagooyi. ");
INSERT INTO poiNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Jém David iixñe t́i miñpa dende wiñɨgam. Iŋmatpa iga pɨspa jém Cristo. Nɨmpa iga jém ia̱nama d́a tsɨ́ypa ju̱t́ it́ jém caaneyajwɨɨp, jém imɨjta̱y d́a púcpa. ");
INSERT INTO poiNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yɨ́pt́im Jesús icpɨs jém tanJa̱tuŋ Dios. Aɨcht́am antu̱mpɨyt́am ánixñeta. Jeeyucmɨ atsɨ́yt́a juuts testigo. ");
INSERT INTO poiNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ocmɨ nanɨcta̱ sɨŋyucmɨ jém Dios iŋwɨ̱mɨ. Ipɨctsoŋ jém Dios iA̱nama juuts ijɨycámayñe iJa̱tuŋ. Jém sɨɨppɨc íñix y immatoŋne, jeet́im Dios iA̱nama iwat. ");
INSERT INTO poiNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Porque d́a je jém David quím sɨŋyucmɨ, pero nɨm jém David: Jém tanJa̱tuŋ Dios iñɨ́máy jém tánO̱mi Cristo: “Mi̱ñɨ mico̱ñi anaŋwɨ̱mɨ, ");
INSERT INTO poiNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","hasta que ɨch manaccoñwɨ́ypa jém íñenemigo.” ");
INSERT INTO poiNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’MiIsraelpɨc mipɨxiñt́am, wɨ̱jo̱dóŋa̱taamɨ iga yɨ́pt́im Jesús, jém micht́ampɨc iŋcunúnta cunusyucmɨ, Dios iccám jém tánO̱mi y jém Cristo. ");
INSERT INTO poiNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Cuando mimatoŋyaj t́i nɨmpa jém Peto, agui aŋyácyaj ia̱namaŋjo̱m jém pɨxiñt́am. Tsa̱m icwácyajpa jém Peto con jém tuŋgac apóstolyaj. Iñɨ́mayyajpa: —Mantɨ̱wɨtam, ¿t́i wɨa̱p aŋwatta? ");
INSERT INTO poiNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Jesɨc ocmɨ jém Peto icutsoŋ. Iñɨ́máy: —Cucactaamɨ iñjɨ̱xi. Chiŋtaamɨ cada tu̱mtu̱m de mimicht́am jém Jesucristo iñɨyi̱mɨ iga Dios miccáyáypa jém iñt́áŋca. Jesɨc Dios michiiba jém iA̱nama. ");
INSERT INTO poiNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Wiñɨgam Dios ijɨycámayñe iga miwɨ̱wadáypa mimicht́am y jém imma̱nɨctam. Iwɨ̱wadáypat́im jém it́yajwɨɨp juumɨ con it́u̱mpɨy jém iwɨ̱aŋja̱myajpáppɨc jém tanJa̱tuŋ Dios iga iŋwejáypa. ");
INSERT INTO poiNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Jém Peto iŋmadáypa jáyaŋ aŋma̱t́i. Tsa̱m pɨ̱mi iŋquímpa jém pɨxiñt́am. Iñɨ́máy: —Pɨctsoŋtaamɨ yɨ́p wɨbɨc aŋma̱t́i iga micɨacputtamta̱p iga d́a iŋwagananɨcpa jém togoyñeyajwɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Jesɨc jém ipɨctsoŋnewɨɨp jém wɨbɨc aŋma̱t́i acchiŋyajta̱. Jeet́im ja̱ma tsa̱m jáyaŋ tɨgɨyñeyaj, como tres mil pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Seguido icuyujcayajpa juuts iŋquejayñe jém apóstolyaj. Nawɨ̱nanɨgayyajta̱p it́u̱mpɨy de jeeyaj. Iŋwejpátyajpa Dios. Aŋtuuma̱yajpa iga iwécyajpa jém caxt́ána̱ñi. ");
INSERT INTO poiNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Cada tu̱mtu̱m de jeeyaj tsa̱m icɨ̱ŋpa Dios. Jém apóstolyaj iwatyajpa jáyaŋ jém milagro y jém seña. ");
INSERT INTO poiNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","It́u̱mpɨy jém icupɨcneyajwɨɨp Cristo it́yaj de acuerdo. T́it́am iniit́yaj icumunmɨɨchiyaj. ");
INSERT INTO poiNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Imayyajpa t́it́am iniit́yaj. Iwécyajpa jém tumiñ, ichiiyajpa jém d́apɨc inii̱yaj iga ijuypa t́it́am it́ogóyáy. ");
INSERT INTO poiNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Cada ja̱ma aŋtuuma̱yajpa jém mɨjpɨc ma̱stɨcjo̱m con tu̱mt́i ijɨ̱xi. Iwécyajpa jém caxt́ána̱ñi tɨc por tɨc. Wagawícyajpa. Agui maymayyaj. Wɨbɨc jɨ̱xi iniit́yaj jém ia̱namaŋjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Tsa̱m icujípyajpa Dios. Jém d́apɨc icupɨcpa Cristo iwɨ̱ixyajpa jém icupɨcneyajwɨɨp Cristo. Cada ja̱ma jém tanJa̱tuŋ Dios inimiñpa jém pɨxiñt́am jém icɨacputpáppɨc iga más jáyaŋa̱p jém icupɨcneyajwɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Tu̱m ja̱ma nɨcyajpa jém Peto y Xiwan jém mɨjpɨc ma̱stɨcjo̱m. Nɨcpa iwat oración a las tres de la tarde, jesɨgam jém hora de oración. ");
INSERT INTO poiNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Jesɨc tsacta̱ tu̱m cu̱xuj jém ma̱stɨc aŋna̱ca. Je cu̱xuj mu iñay. Nanɨcta̱ tu̱m jém puerta iŋna̱ca iñɨ̱yi jém Wɨbɨc Puerta. Jemum tsacta̱ cada ja̱ma iga iwágáyiñ tumiñ jém tɨgɨyyajpáppɨc jém mɨjpɨc ma̱stɨcjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Cuando jém cu̱xuj iix iga tɨgɨypa jém Peto y jém Xiwan, iwágáy tumiñ. ");
INSERT INTO poiNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Jesɨc jém Peto y Xiwan iámmatsyaj jém cu̱xuj. Jém Peto iñɨ́máy jém pɨ̱xiñ: —Aámma̱tsɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Jém cu̱xuj icupɨc, iámmats jém Peto. Ijɨ̱spa iga ichiiba tumiñ. ");
INSERT INTO poiNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pero Peto iñɨ́máy: —D́a anai̱ plata ni oro, pero manchiiba jém anait́wɨɨp. Jém Jesucristo de Nazaret iñɨyi̱mɨ mannɨ́máypa: Tsucu̱mɨ. Wi̱t́ɨm. ");
INSERT INTO poiNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ocmɨ jém Peto imatsáy icɨ, jém iŋwɨ̱mɨpɨc, ijɨ̱ctsucum. Jeet́i rato wɨ̱tsɨ́yum jém cu̱xuj ipuy. ");
INSERT INTO poiNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Te̱ñchucumum jém cu̱xuj, yóyquímpa, mojum wi̱t́i. Tɨgɨy jém ma̱stɨcjo̱m con jeeyaj. Wit́pa, yóyquímpa, icujíppa tanJa̱tuŋ Dios. ");
INSERT INTO poiNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","It́u̱mpɨy jém pɨxiñt́am iix jém cu̱xujpɨc id́ɨc iga wit́pam y icujíppa Dios. ");
INSERT INTO poiNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Iixpɨcyajpa iga jeet́im jém pɨ̱xiñ jém iwácpáppɨc tumiñ jém ma̱stɨcaŋna̱ca ju̱t́ it́ jém Wɨbɨc Puerta. Agui tɨ̱neaŋjacyaj, agui ipooñaŋja̱myaj cuando iix t́i iñasca jém pɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Jesɨc jém cu̱xuj, jém acpɨsneta̱wɨɨp, d́a ichactooba jém Peto y Xiwan. Poyi̱mɨ miñyaj jém pɨxiñt́am, aŋtuuma̱yajpa jém Salomón icorredor ju̱t́ it́yaj jém Peto y Xiwan. Agui ámaŋjacyaj. ");
INSERT INTO poiNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Cuando iix iga agui aŋtuuma̱yajpa jém pɨxiñt́am jém Peto iñɨ́máy: —MiIsraelpɨc mipɨxiñt́am, ¿t́iiga ampooñaŋja̱mtámpa, t́iiga agui anámtámpa? ¿Que mich iñjɨ̱s iga ɨch anacpɨs yɨ́p pɨ̱xiñ iga wɨa̱p anacwit́ con ɨch ampɨ̱mi? ¿Que iñjɨ̱spa iga tsa̱m wɨbɨc apɨ̱xiñ? Odoy jɨ̱sɨ je̱mpɨc. Porque Dios icpɨs. ");
INSERT INTO poiNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Jém wiñɨcpɨc tanja̱tuŋwe̱wetam jém Abraham, jém Isaac y jém Jacob tsa̱m ijɨ̱syajpa tanJa̱tuŋ Dios. Jeet́im Dios sɨɨp iwat así iga taŋcujíptámiñ jém iMa̱nɨc Jesucristo, jém michpɨc iŋcɨɨjuŋcotta jém aŋjagooyi icɨɨjo̱m iga accaata̱iñ. Cuando jém Pilato icutsɨgayt́ooba id́ɨc, mimicht́am d́a iñjɨ́cta. ");
INSERT INTO poiNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","D́a iñjɨ́cta iga cutsɨgayt́a̱iñ jém wɨbɨc pɨ̱xiñ jém d́apɨc táŋcaɨ́y. Pero iŋwácta iga cutsɨgayt́a̱iñ tu̱m accaoypaap. ");
INSERT INTO poiNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Je̱mpam iniccaata jém tachiipáppɨc jém tamvida. Pero Dios icpɨs de ju̱t́ it́ jém caaneyajwɨɨp. Aɨcht́am atsɨ́yt́a juuts atestigo iga nu̱ma pɨsneum. ");
INSERT INTO poiNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Yɨ́pt́im Jesús iñɨyi̱mɨ acpɨsta̱ yɨ́p pɨ̱xiñ jém sɨɨppɨc íñix, micht́am íñixpɨcta. Wɨ̱tsɨ́y porque icupɨc iga jém Jesús wɨa̱p iyo̱xpát. Iñasca así ju̱t́ íñámpacneta. ");
INSERT INTO poiNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Mantɨ̱wɨtam, anjo̱doŋ iga immalwadáy jém Jesús porque d́a iŋcutɨɨyɨ́y iga Dios icutsat. D́at́im icutɨɨyɨyyaj jém iniŋjagooyit́am. ");
INSERT INTO poiNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","It́u̱mpɨy jém wiñɨcpɨc Dios iŋmat́cɨɨwiñ nɨmyaj iga tienes que yaachwatta̱p jém Cristo jém icutsatnewɨɨp Dios. Sɨɨp Dios iccupacneum juuts nɨmyaj jeeyaj. ");
INSERT INTO poiNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Jeeyucmɨ mannɨ́máypa: Cuca̱cɨ iñjɨ̱xi, tsa̱cɨ iga immalwatpa, jesɨc jém tanJa̱tuŋ Dios miccáyáypa jém iñt́áŋca. Michiiba tu̱m wɨbɨc maymáya̱ji íña̱namaŋjo̱m, ");
INSERT INTO poiNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","micutsadáypa jém Cristo jém icupiŋnewɨɨp dende wiñɨgam para mimicht́am. ");
INSERT INTO poiNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Sɨɨp nɨc i̱t́i sɨŋyucmɨ jém Jesucristo. Jemum tsɨ́y hasta que iwɨ̱tsacpa it́u̱mpɨy cosa juuts nɨm jém wiñɨcpɨc aŋmat́cɨɨwiñ jém cuáyñewɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Je̱mpɨgam iñɨ́máy Moisés jém wiñɨcpɨc tanja̱tuŋwe̱wetam: “Jém tanJa̱tuŋ Dios ictsucumpa tu̱m jém profeta entre mimicht́am juuts acutsat aɨch. Matoŋtaamɨ it́u̱mpɨy t́it́am miñɨ́máypa jém profeta. ");
INSERT INTO poiNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Porque it́u̱mpɨy jém d́apɨc iwadáypa caso yɨ́p aŋmat́cɨɨwiñ iga icupɨcpa, actogoyt́a̱p, topta̱p de jém nación de Israel.” ");
INSERT INTO poiNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’It́u̱mpɨy jém wiñɨcpɨc aŋmat́cɨɨwiñ dende jém Samuel hasta sɨɨp, iŋmatyajpa iga iwatpa Dios juuts tánixpa sɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Mimicht́am iñja̱tuŋwe̱wetam jém wiñɨcpɨc aŋmat́cɨɨwiñ. Dios ijɨycámáy iga miwɨ̱wadáypa. Iwat tu̱m trato con jém wiñɨcpɨc taŋwe̱wetam cuando iñɨ́máy jém Abraham así: “Tu̱m jém mich imma̱nɨc tsa̱m iwɨ̱wadáypa it́u̱mpɨy jém pɨxiñt́am icuwɨ̱t́i yɨ́p naxyucmɨ.” ");
INSERT INTO poiNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Cuando Dios icpɨs jém iMa̱nɨc Jesucristo, wiñt́i micutsadáy iga miwɨ̱wadáyiñ mimicht́am. Ixunpa Dios iga iñchaguiñ iga immalwatpa cada tu̱mtu̱m de mimicht́am. ");
INSERT INTO poiNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Iganam jém Peto y Xiwan iŋmadayyajpa jém pɨxiñt́am, miñyaj jém pa̱nijyaj. Wagamiñyaj con jém policía icomandante y con jém saduceoyaj. ");
INSERT INTO poiNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Tsa̱m jóyñeyaj porque jém Peto y Xiwan iŋquejáypa jém pɨxiñt́am iga acpɨsta̱p jém caaneyajwɨɨp porque pɨsneum jém Jesús de ju̱t́ it́ jém caaneyajwɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ocmɨ matsta̱ jém Peto y Xiwan, cotta̱ cárcel porque tsuuyɨm. Hasta icuqueja̱ma cɨɨpiŋta̱p. ");
INSERT INTO poiNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pero tsa̱m jáyaŋ jém imatoŋneyajwɨɨp jém Peto iŋma̱t́i icupɨcyaj jém Cristo. Jeet́im ja̱ma icupɨcyaj como cinco mil pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Icuqueja̱ma aŋtuuma̱yaj Jerusalén jém Israelpɨc aŋjagooyiyaj, con jém wɨd́ayt́am, con jém escribaspɨc maestroyaj. ");
INSERT INTO poiNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","It́t́im jém Anás jém co̱bacpɨc pa̱nij aŋjagooyi. It́t́im jém Caifás, jém Xiwan, jém Alejandro y it́u̱mpɨy jém co̱bacpɨc pa̱nij it́ɨ̱wɨtam. ");
INSERT INTO poiNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Jesɨc cutsatta̱ jém policía iga inimíñiñ jém Peto y Xiwan jém aŋjagooyiyaj iwiñjo̱m. Acwácta̱: —¿I̱ ipɨ̱mi̱mɨ, i̱ iñɨyi̱mɨ iŋwatpa jexpɨc cosa? ");
INSERT INTO poiNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Jesɨc Peto tsa̱m iniit́ jém Dios iA̱nama. Iñɨ́máy: —Manaŋjagooyit́am, miIsraelpɨc miwɨd́ayt́am, ");
INSERT INTO poiNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","mich anacwácpa jutsa̱ mu iwɨ̱wadayt́a̱ jém cu̱xujpɨc id́ɨc, jutsa̱ micpɨsta̱. ");
INSERT INTO poiNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Sɨɨp manaŋmadáypa micht́am iŋwiñjo̱m iga it́u̱mpɨy jém Israelpɨc pɨxiñt́am ijo̱dóŋa̱yajiñ iga Jesucristo icpɨs yɨ́p pɨ̱xiñ yɨɨmpɨc it́ iŋwiñjo̱m. Acpɨsta̱ jém Jesús iñɨyi̱mɨ, jém Nazaretpɨc. Jeet́im pɨ̱xiñ mimicht́am iŋcunúnta cunusyucmɨ. Pero Dios icpɨs de ju̱t́ it́ jém caaneyajwɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yɨ́pt́im Jesús tsɨ́y juuts tu̱m wɨbɨc tsa para jém tɨc. Pero micht́am, jém mit́ɨcwattampáppɨc, impatsayt́ɨp. Pero sɨɨp yɨ́pt́im tsa imatspacne jém tɨc. ");
INSERT INTO poiNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","D́a i̱ tuŋgac wɨa̱paap tacɨacput icuwɨ̱t́i yɨ́p naxyucmɨ. Dios d́a icutsat tuŋgac pɨ̱xiñ iga tacɨacputpa. ");
INSERT INTO poiNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Jém aŋjagooyiyaj agui ipooñaŋja̱myaj porque iix iga d́a cɨ̱ŋpa iŋmat jém Peto y Xiwan. Icutɨɨyɨyyaj iga d́a cuyujne, sɨɨba juuts cualquier pɨ̱xiñ. Jesɨc icutɨɨyɨyyaj iga jáy iwaganasɨ jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Iixyajt́im iga iwaganate̱ñ jém cu̱xujpɨc id́ɨc, jeeyucmɨ d́a wɨa̱p iñɨm iga mɨgooyi. ");
INSERT INTO poiNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Quebacputta̱ jém Peto y Xiwan con jém cu̱xujpɨc id́ɨc iga jém aŋjagooyiyaj wɨa̱iñ ijɨ̱syaj t́i wɨa̱p iwatyaj. ");
INSERT INTO poiNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Jesɨc nanɨ́mayyajta̱ entre jeeyaj: —¿T́i wɨa̱p taŋwat con yɨ́p pɨxiñt́am? Porque it́u̱mpɨy jém it́yajwɨɨp Jerusalén iwɨ̱jo̱doŋ iga iwat tu̱m wɨbɨc milagro. D́a wɨa̱p tanaŋyam. ");
INSERT INTO poiNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Pero iga odom más juumɨ nɨguiñ yɨ́p aŋma̱t́i, jesɨc tannɨ́máypa iga: Manchiiba tu̱m mɨjpɨc castigo siiga seguido iniŋmatpa yɨ́p Jesús iñɨyi̱mɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Jesɨc ocmɨ aŋwejayt́a̱ jém Peto y Xiwan jém aŋjagooyicɨɨm. Nɨ́mayt́a̱: —Odoy más aŋma̱tɨ jém Jesús iñɨyi̱mɨ. Odoy aŋmadaayɨ jém pɨxiñt́am jexpɨc aŋquímayooyi. ");
INSERT INTO poiNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pero jém Peto y Xiwan iñɨ́máy jém aŋjagooyi: —Jɨ̱staamɨ micht́am iñyaac siiga más wɨ̱ iga maŋcupɨcpa mimicht́am o iga aŋcupɨcpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Aɨcht́am d́a wɨa̱p antsacta iga anaŋmattámpa t́i ánixñe y t́i ammatoŋne. ");
INSERT INTO poiNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Jesɨc e̱ybɨc iñɨ́mayyaj jém aŋjagooyi iga ichiiba castigo siiga d́a ichacpa iga iŋmatpa. Pero d́a i̱ wɨa̱ michi castigo porque it́u̱mpɨy jém pɨxiñt́am tsa̱m icujípyajpa Dios porque iix t́i iñasca jém cu̱xujpɨc id́ɨc. Ocmɨ cutsɨgayt́a̱ jém Peto y Xiwan. ");
INSERT INTO poiNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Jém pɨ̱xiñ jém wadayñeta̱wɨɨp jém milagro, jém acpɨsneta̱wɨɨp, iniit́um más de cuarenta ia̱mt́ɨy. ");
INSERT INTO poiNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Cuando cutsɨgayñeta̱wum jém Peto y Xiwan, nɨcyaj ju̱t́ it́ icompañeroyaj. Iŋmadáy it́u̱mpɨy t́it́am iñɨ́mayyaj jém pa̱nij aŋjagooyiyaj y jém Israelpɨc wɨd́ayt́am. ");
INSERT INTO poiNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Cuando imatoŋyaj t́i iñɨ́máy jém Peto, it́u̱mpɨy jém Jesús icuyujcɨɨwiñ con tu̱mt́i jɨ̱xi moj iŋwejpátyaj Dios. Nɨmyajpa: —ManJa̱tuŋ Dios, mich iŋwat jém sɨŋ, jém nas, jém lamar y it́u̱mpɨy jém it́wɨɨp yɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Wiñɨgam jém iŋcuyo̱xapaap jém David ijaychac mich iniŋma̱t́i. Mich íñA̱nama iyo̱xpát iga ijay. Iñɨ́máy: ¿T́iiga tsa̱m jóyñeyaj jém naciónyaj jém d́apɨc icupɨcyajpa Dios? ¿T́iiga tsa̱m ijɨ̱squímpa jém pɨxiñt́am jém cosa d́a para t́i wɨ̱, jém d́apɨc i̱ iyo̱xpátpa? ");
INSERT INTO poiNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Aŋtuuma̱yaj jém reyyaj con yɨ́p naxyucmɨpɨc aŋjagooyi. Nɨcyaj en contra de jém tanJa̱tuŋ Dios, nɨcyaj en contra de jém Cristo jém icutsatnewɨɨp Dios. ");
INSERT INTO poiNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Nu̱ma aŋtuuma̱yaj yɨ́p Jerusalén jém Herodes y jém Poncio Pilato, jém tuŋgac pɨxiñt́am jém d́apɨc je de Israel con jém Israelpɨc pɨxiñt́am. Nɨcyajpa en contra de jém wɨbɨc imMa̱nɨc Jesús jém michpɨc iniccám iga Cɨacpudoypaap. ");
INSERT INTO poiNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Jeeyaj cupacpa iwatyaj juuts mich iñjɨ̱sne iga iñascaaba jém imMa̱nɨc. ");
INSERT INTO poiNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Sɨɨp manJa̱tuŋ Dios, i̱xɨ yɨ́p pɨxiñt́am. Nɨmyajpa iga achiiba tu̱m mɨjpɨc castigo. Maŋcuyo̱xatámpa. Ayo̱xpáttaamɨ iga wɨa̱p anaŋmat iniŋma̱t́i. Acamamwadaayɨ ána̱nama iga odoy acɨɨŋiñ. ");
INSERT INTO poiNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Achi̱ɨ jém impɨ̱mi iga anacpɨspa jém mɨmnewɨɨp, iga aŋwatpa jém milagro y jém seña jém Jesucristo iñɨyi̱mɨ, jém wɨbɨc imMa̱nɨc. ");
INSERT INTO poiNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Cuando yaj iŋwejpátyaj Dios, pɨ̱mi tsɨgóypa jém tɨc ju̱t́ aŋtuuma̱neyaj. It́u̱mpɨy jém pɨxiñt́am tsa̱m iniit́yaj jém Dios iA̱nama. D́a cɨ̱ŋyajpa iga iŋmatpa jém Dios iŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","It́u̱mpɨy jém icupɨcneyajwɨɨp tu̱mt́i ijɨ̱xi y tu̱mt́i ia̱nama. D́a i̱ ijɨ̱spa iga imɨɨchi icut́um t́it́am iniit́yaj. Ijɨ̱spa iga it́u̱mpɨy cosa icumunmɨɨchiyaj. ");
INSERT INTO poiNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Jém apóstolyaj seguido iŋmatpa iga pɨsneum jém tánO̱mi Jesús. Tsa̱m wɨa̱p iŋmat porque Dios ichi jém ipɨ̱mi y tsa̱m tóyoyyajpa. ");
INSERT INTO poiNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","D́a i̱ jém yaacha̱yajpáppɨc. Porque it́u̱mpɨy jém iniit́wɨɨp iñas o it́ɨc, imáy iga inimiñpa jém tumiñ. ");
INSERT INTO poiNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Ipɨctsoŋ jém apóstolyaj, iwécyajpa, ichiiyajpa cada tu̱mtu̱m de jeeyaj iga ijuypa t́it́am it́ogóyáy. ");
INSERT INTO poiNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","It́ id́ɨc tu̱m levitapɨc pɨ̱xiñ iñɨ̱yi José. Nay jém isla de Chipre. Jém apóstolyaj iccámayyaj iñɨ̱yi, Bernabé. Jém iñɨ̱yi nɨmtooba jém yo̱xpádoypaap. ");
INSERT INTO poiNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Yɨ́p pɨ̱xiñ iniit́ id́ɨc tu̱m ja̱ca nas, ocmɨ imáy. Inimiñ jém tumiñ, icɨɨjuŋcodáy jém apóstolyaj icɨɨjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Jemum it́t́im tu̱m pɨ̱xiñ iñɨ̱yi Ananías con iwɨcho̱mo Safira. Imáyyajt́im tu̱m ja̱ca nas. ");
INSERT INTO poiNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Pero yɨ́p pɨ̱xiñ iŋnéc uxaŋ jém nas icho̱wa. Jém iyo̱mo it́t́im de acuerdo con iwɨd́a̱ya. Nɨmyaj iga yɨcsáŋam icho̱wa jém nas. Jém pɨ̱xiñ miñ ichagáy jém apóstolyaj ipuycɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Jesɨc Peto iñɨ́máy jém Ananías: —MiAnanías, ¿t́iiga tɨgɨy jém Woccɨɨwiñ íña̱namaŋjo̱m iga immɨgóyáypa jém Dios iA̱nama iga iññéctsɨ́y uxaŋ jém nas icho̱wa? ");
INSERT INTO poiNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Que d́a immɨɨchi jém nas cuando d́anam immáyñe, cuando immáyñeum immɨɨchit́im jém icho̱wa? ¿T́iiga iñjɨ̱spa iga iŋwatpa je̱mpɨc? Immɨgóyáy Dios, d́a immɨgóyáy tu̱m pɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Cuando imatoŋ t́i nɨmpa jém Peto, actɨŋ jém Ananías, je̱mt́i caanas. Jesɨc tsa̱m pɨ̱mi cɨ̱ŋyaj it́u̱mpɨy jém imatoŋneyajwɨɨp t́i iñasca jém pɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Tsucumyaj jém wo̱ñjaychɨ̱xt́am, iŋmonyaj jém tsúts, nɨc icumyaj. ");
INSERT INTO poiNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Cuando nasne tres hora, miñ jém Ananías iwɨcho̱mo, d́a ijo̱doŋ t́i nasne. ");
INSERT INTO poiNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Jesɨc jém Peto icwác jém yo̱mo: —Anɨ́maayɨ, ¿nu̱ma jesáŋam icho̱wa jém nas jutsaŋ achi jém iŋwɨd́a̱ya? Nɨm jém yo̱mo: —Nu̱ma jesáŋam. ");
INSERT INTO poiNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Jesɨc Peto iñɨ́máy: —¿T́iiga iŋwatta de acuerdo con iŋwɨd́a̱ya iga iŋcutɨ́tspa jém Dios iA̱nama? Jemum mi̱ñiyaj aŋsɨ̱cmɨ jém oyñewɨɨp icum jém iŋwɨd́a̱ya. Sɨɨp michgact́i nɨcpa micum. ");
INSERT INTO poiNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Jeet́i rato actɨŋ jém yo̱mo jém Peto ipuycɨɨm. Caanas. Cuando tɨgɨyyaj jém wo̱ñjaychɨ̱xt́am caaneum jém yo̱mo. It́opyaj, nɨc icum tu̱m lado ju̱t́ cumneta̱ jém iwɨd́a̱ya. ");
INSERT INTO poiNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Tsa̱m pɨ̱mi cɨ̱ŋneyaj it́u̱mpɨy jém icupɨcneyajwɨɨp Cristo con jém imatoŋneyajwɨɨp t́i iñascayaj. ");
INSERT INTO poiNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Jém apóstolyaj iwatyaj jáyaŋ jém milagro y seña jém pɨxiñt́ámaŋjo̱m. Aŋtuuma̱neyaj it́u̱mpɨy de jeeyaj jém mɨjpɨc ma̱stɨc icorredor iñɨ̱yi Salomón. ");
INSERT INTO poiNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Pero jém d́apɨc icupɨcpa Cristo ni t́u̱m d́a iŋpɨtsneyaj, pero tsa̱m iwɨ̱ixyajpa jém Dios ipɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Jém icupɨcneyajwɨɨp Cristo más jáyaŋa̱p. Jém pɨxiñt́am y yo̱mtam cada ja̱ma más icupɨcyajpa jém Dios iŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","It́opyajpa jém mɨmneyajwɨɨp con ichees. Nɨcpa ichacyaj calle iga cuando naspa jém Peto, ictsɨ́yáyiñ jém icumuŋcɨ algunos de jeeyaj. ");
INSERT INTO poiNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Inimiñyajpat́im jém mɨmneyajwɨ́ppɨc jém tuŋgac attebetyaj jém it́yajwɨɨp nocojo̱m Jerusalén. Inimiñyaj jém mɨmneyajwɨɨp y jém imatsneyajwɨɨp jém mal espíritu. Cupɨsayyaj it́u̱mpɨy. ");
INSERT INTO poiNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Jesɨc jém co̱bacpɨc pa̱nij aŋjagooyi con jém iwaganait́yajwɨɨp, jém saduceopɨc pɨxiñt́am, tsa̱m pɨ̱mi icujóyɨyyaj. ");
INSERT INTO poiNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Matsta̱ jém apóstolyaj, cotta̱ cárcel. ");
INSERT INTO poiNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Pero jeet́im tsuu Dios icutsat tu̱m sɨŋyucmɨpɨc pɨ̱xiñ iga íŋáyiñ jém cárcel. Topta̱ jém apóstolyaj. Nɨ́mayt́a̱: ");
INSERT INTO poiNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Nɨ̱gɨ mite̱ñi jém mɨjpɨc ma̱stɨcjo̱m. Aŋmadayya̱jɨ jém pɨxiñt́am iga Dios ichiit́ooba jém jo̱mipɨc vida. ");
INSERT INTO poiNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Cuando imatoŋyaj jém apóstolyaj, icuqueja̱ma, tsúyt́im, tɨgɨyyaj jém mɨjpɨc ma̱stɨcjo̱m, moj iŋquejáy jém pɨxiñt́am. Jesɨc jeet́im ja̱ma aŋtuuma̱neyaj jém co̱bacpɨc pa̱nij con it́u̱mpɨy jém Israelpɨc aŋjagooyiyaj y jém wɨd́ayt́am iga iwatyajpa tu̱m mɨjpɨc junta. Pɨɨmɨyt́a̱ jém policía iga nɨguiñ it́opyaj cárcel jém presoyaj. ");
INSERT INTO poiNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Pero cuando jém policía núc jém cárcel, d́a ipátyaj jém preso. Jesɨc e̱ybɨc se̱tyaj. Miñ iŋmadáy jém aŋjagooyi. ");
INSERT INTO poiNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Nɨmyajpa: —Cuando anúc jém cárcel tsa̱m wɨ̱aŋpajne y jém guardia ichaŋwɨ̱watne cuenta jém cárcel ipuerta. Cuando anáŋáy jém cárcel d́a i̱ ampát. ");
INSERT INTO poiNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Cuando imatoŋ t́i iñɨ́máy jém policía, agui ipooñaŋja̱myaj jém pa̱nij aŋjagooyiyaj con jém ma̱stɨc icomandante. D́a icutɨɨyɨyyaj t́i naspa y hasta ju̱t́ cuyajpa yɨ́p asunto. ");
INSERT INTO poiNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Jeet́i rato miñ tu̱m pɨ̱xiñ, iŋmadáy jém aŋjagooyi: —Jém wɨste̱n pɨ̱xiñ, jém micht́ampɨc impajta cárcel, sɨɨp it́ jém mɨjpɨc ma̱stɨcjo̱m. Sɨ́p iccuyuj jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Jesɨc jém comandante con ipolicía nɨc imétsyaj jém apóstolyaj. Inimiñyaj, pero d́a imalwadáy porque tsa̱m cɨ̱ŋneyaj. Ijɨ̱spa iga iñácscayajpa tsaamɨ jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Cuando inimiñyaj, nanɨcta̱ jém aŋjagooyiyaj iwiñjo̱m, jém Sanhedrín. Jesɨc jém co̱bacpɨc pa̱nij iñɨ́máy: ");
INSERT INTO poiNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—¿D́a mannɨ́mayñeum iga odoy aŋma̱tɨ yɨ́p pɨ̱xiñ iñɨyi̱mɨ? ¿Pero t́i sɨ́p iŋwat? Icuwɨ̱t́i yɨ́p Jerusalén núc jém iniŋma̱t́i. ¿Que mich antsagayt́ooba la culpa iga accaata̱ yɨ́p pɨ̱xiñ? ");
INSERT INTO poiNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Jesɨc jém Peto con jém tuŋgac apóstolyaj icutsoŋyaj. Iñɨ́mayyaj: —Más wɨ̱ iga aŋcupɨcpa Dios que iga aŋcupɨcpa jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Jém wiñɨcpɨc taŋwe̱wetam ijɨ̱syajpa Dios. Jeet́im Dios icpɨs jém Jesús jém michpɨc iniccaata, iŋcunúnta cunusyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Pero Dios ininɨc sɨŋyucmɨ, icco̱ñ iŋwɨ̱mɨ. Iccám iga Mɨjpɨc iŋJagooyi, iccám iga jém Cɨacpudoypaap. Iwadáy je̱mpɨc iga ichiiba lugar jém Israelpɨc pɨxiñt́am iga icucacpa ijɨ̱xi iga wadayt́a̱p perdón jém it́áŋca. ");
INSERT INTO poiNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Aɨcht́am atsɨ́yt́a juuts tu̱m testigo iga nu̱ma pɨs jém Cristo, quím e̱ybɨc sɨŋyucmɨ. Tsɨ́yt́im juuts tu̱m testigo jém Dios iA̱nama jém ichiiñewɨɨp Dios jém icupɨcneyajwɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Cuando imatoŋyaj t́i nɨmpa jém Peto, tsa̱m jóyñeyaj jém aŋjagooyi. Tsa̱m iccaayajtooba. ");
INSERT INTO poiNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pero entre jeeyaj it́t́im id́ɨc tu̱m fariseopɨc pɨ̱xiñ iñɨ̱yi Gamaliel. Tu̱m accuyujoypaap de jém Israelpɨc aŋquímayooyi. Jém pɨxiñt́am tsa̱m iwɨ̱ixyajpa. Te̱ñchucum, ipɨɨmɨ́y jém policía iga iquebacpud́iñ tu̱m rato jém apóstolyaj. ");
INSERT INTO poiNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ocmɨ iñɨ́máy jém aŋjagooyiyaj: —MiIsraelpɨc mipɨxiñt́am, nawattamta̱jɨ cuenta. Cuidado iga immalwadáypa yɨ́p pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Jɨ̱staamɨ iga pecam tsucum jém Teudas, tu̱m pɨ̱xiñ tsɨ́yt́ɨp juuts tu̱m mɨjpɨc aŋjagooyi. Initsucum como cuatrocientos pɨxiñt́am. Ocmɨ accaata̱ jém pɨ̱xiñ y jém it́úŋɨyyajwɨɨp cutogóyayyaj. Jemum cuyaj. ");
INSERT INTO poiNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Más ocmɨ cuando watta̱p jém censo, tsucum jém Judas, tu̱m Galileapɨc pɨ̱xiñ. Initsucum tsa̱m jáyaŋ pɨxiñt́am. Pero ocmɨ accaata̱t́im. Cupóyayyaj it́u̱mpɨy jém it́úŋɨyyajwɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Jeeyucmɨ mannɨ́máypa, tsa̱cɨ yɨ́p pɨxiñt́am. Odoy moogɨɨyɨ. Porque siiga yɨ́p aŋquímayooyi pɨxiñt́am ijɨ̱xquiimi, cuyajpa. ");
INSERT INTO poiNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pero siiga yɨ́p pɨxiñt́am iniid́áy Dios ijɨ̱xi, mich d́a wɨa̱p inictogoy. Nawattamta̱jɨ cuenta. Cuidado iga iníŋa̱támpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Jesɨc it́u̱mpɨy jém aŋjagooyiyaj icupɨcyaj juuts nɨm jém Gamaliel. Ocmɨ aŋwejayt́a̱ jém apóstolyaj, cótsyajta̱, nɨ́mayyajta̱ iga odoy más aŋma̱tɨ Jesús iñɨyi̱mɨ. Ocmɨ cutsɨgayyajta̱. ");
INSERT INTO poiNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Jém apóstolyaj putyaj jém aŋjagooyi iwiñjo̱m. Agui maymayyaj porque Dios ijɨ́c iga yaachwatyajta̱ jém Jesús icuyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Jesɨc cada ja̱ma accuyujóypa jém mɨjpɨc ma̱stɨcjo̱m y jém it́ɨgaŋjo̱myaj. D́a ichacpa iga iŋmatpa jém wɨbɨc aŋma̱t́i iga Jesús je jém Cristo. ");
INSERT INTO poiNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Jém tiempo tsa̱m jáyaŋa̱p jém Dios ipɨxiñt́am. Icupɨcyajpat́im jém griegopɨc pɨxiñt́am. Jeeyaj agui jɨyyajpa acontra de jém Israelpɨc pɨxiñt́am porque iñe̱jawégáypa jém cuno̱yt́am iwíccuy cuando iwécpa jém wíccuy cada ja̱ma. ");
INSERT INTO poiNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ocmɨ jém apóstolyaj iŋtuuma̱watyaj it́u̱mpɨy jém icupɨcneyajwɨɨp jém Cristo. Iñɨ́mayyaj: —D́a wɨ̱ iga antsactámpa iga anaŋmatpa jém Dios iŋma̱t́i iga acwígoyt́ámpa. ");
INSERT INTO poiNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Jeeyucmɨ mantɨ̱wɨtam, métstaamɨ siete de mimicht́am jém wɨbɨc pɨxiñt́am, jém jɨ̱xiɨywɨɨp, jém tsa̱mpɨc iniit́ jém Dios iA̱nama. Accámtaamɨ iga iwatpa jém yo̱xacuy iga iwécpa jém wíccuy. ");
INSERT INTO poiNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Pero aɨcht́am seguido anaŋwejpáttámpa Dios, anaŋquejpa jém Dios iŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Jesɨc it́u̱mpɨy jém Dios ipɨxiñt́am it́yaj de acuerdo iga iwatyajpa juuts nɨmyaj jém apóstolyaj. Cupiŋta̱ jém Esteban. Jém pɨ̱xiñ tsa̱m iniit́ jém Dios iA̱nama. Cupiŋyajta̱t́im Felipe, Prócoro, Nicanor, Timón, Parmenas y jém Nicolás. Jém Nicolás miñ de jém Antioquía. Je tɨgɨyñe id́ɨc iga icupɨcpa jém Israelpɨc aŋquímayooyi. ");
INSERT INTO poiNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ocmɨ namiñt́a̱ icusiete jém pɨxiñt́am hasta ju̱t́ it́ jém apóstolyaj iga iŋwejpádáypa Dios para jeeyaj. Cada tu̱mtu̱m de jeeyaj jém apóstolyaj ichɨccunúgáy ico̱bac. ");
INSERT INTO poiNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Jesɨc tsa̱m jáyaŋa̱p jém Dios iŋma̱t́i, núcpa yɨɨm jeexɨc. Tsa̱m jáyaŋa̱pt́im jém Dios ipɨxiñt́am jém attebet Jerusalén. Wa̱t́i jém Israelpɨc pa̱nij icupɨcyajt́im. ");
INSERT INTO poiNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Jém Esteban tsa̱m iniit́ jém Dios ipɨ̱mi y tsa̱m iniit́ jém wɨbɨc tóyooyi. Agui iwatpa jém milagro y jém seña jém pɨxiñt́ámaŋjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Jesɨc algunos jém pɨxiñt́am miñ iníŋa̱yaj jém Esteban. Miñyaj algunos de jém sinagoga de jém Libertinopɨc pɨxiñt́am. Miñyajt́im de jém naxyucmɨ de Cirene, de jém naxyucmɨ de Alejandría, de jém Cilicia y de jém Asia. Moj íŋa̱cayaj jém Dios iŋma̱t́i con jém Esteban. ");
INSERT INTO poiNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Pero jém pɨxiñt́am d́a wɨa̱ micoñwɨ́y jém Esteban porque tsa̱m jɨ̱xiɨ́y. Jém Dios iA̱nama iyo̱xpát iga tsa̱m wɨa̱ micutsoŋ. ");
INSERT INTO poiNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Jém áŋa̱yajpáppɨc con Esteban iyojpa algunos pɨxiñt́am iga icumɨgóypa jém Esteban. Nɨmyaj: —Ɨch ammatoŋ iga yɨ́p Esteban imalnɨ́máy jém Moisés iŋquímayooyi. Tsa̱m icujɨypat́im Dios. ");
INSERT INTO poiNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Jém áŋa̱yajpáppɨc con Esteban iccujíñáy jém pɨxiñt́am, jém Israelpɨc wɨd́ayt́am y jém escribaspɨc maestroyaj. Icutuuma̱cayaj jém Esteban, matsta̱, nanɨcta̱ jém pa̱nij aŋjagooyicɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ocmɨ inimiñyaj tuŋgac jém mɨgoypaap. Nɨmyaj: —Yɨ́p pɨ̱xiñ d́a ichacpa iga icujɨypa jém tamma̱stɨc. Tsa̱m icujɨypat́im jém Moisés iŋquímayooyi. ");
INSERT INTO poiNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ammatoŋta iga nɨmpa iga Jesús jém Nazaretpɨc pɨ̱xiñ imɨswatpa jém tamma̱stɨc y icucagáypa jém costumbre jém tatsagayñewɨɨp Moisés. ");
INSERT INTO poiNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Jesɨc it́u̱mpɨy jém co̱ñyajwɨɨp je̱m, agui iámyajpa jém Esteban. Iixyaj iga aŋcac jém iámooyi juuts tu̱m sɨŋyucmɨpɨc pɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Jesɨc jém co̱bacpɨc pa̱nij aŋjagooyi icwác jém Esteban. Iñɨ́máy: —¿Que nu̱ma iŋwat juuts nɨmyajpa? ");
INSERT INTO poiNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Jém Esteban iñɨ́máy: —Mantɨ̱wɨtam, miŋjagooyit́am, amatoŋtaamɨ. Jém wɨbɨc tanDios iwiñquejáy jém wiñɨcpɨc taŋwe̱we jém Abraham. Iwiñquejáy jém naxyucmɨ de Mesopotamia cuando d́anam nɨcne i̱t́i jém naxyucmɨ de Harán. ");
INSERT INTO poiNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Dios iñɨ́máy: “Pu̱tɨ jém iññaxyucmɨ. Tsa̱cɨ jém iñt́ɨ̱wɨtam. Nɨcsɨm jém naxyucmɨ iga manaŋquejáypa.” ");
INSERT INTO poiNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ocmɨ jém Abraham put jém naxyucmɨ de Caldea ju̱t́ it́ id́ɨc. Nɨc i̱t́i jém naxyucmɨ de Harán. Jemɨgam ca jém ija̱tuŋ. Ocmɨ Dios inimiñ jém Abraham hasta yɨɨm ju̱t́ tait́t́a sɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Pero Dios d́a ichi ni tu̱m ja̱ca nas jém imɨɨchipɨc ni ju̱t́ icte̱ñpa ipuy. Pero ijɨycámayñe iga ichiiba jém nas y cuando caaneum, tsɨ́ypa jém nas para jém ima̱nɨctam. Pero cuando ijɨycámáy iga ichiiba jém nas d́a inii̱ ima̱nɨc ni tu̱m. ");
INSERT INTO poiNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Dios iñɨ́máy: “Jém imma̱nɨctam nɨcpa jém tuŋgac naxyucmɨ. Nɨcpa i̱t́i juuts juumɨpɨc pɨxiñt́am. Tsɨ́yyajpa iga esclavo, yaachwatyajta̱p cuatrocientos a̱mt́ɨy.” ");
INSERT INTO poiNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Nɨmpat́im Dios: “Ɨch anchiiba castigo jém pɨxiñt́am jém it́yajwɨɨp jém naxyucmɨ ju̱t́ natsɨ́yyajta̱ iga esclavo. Jesɨc cuando putyajpa jemɨc, miñyajpa e̱ybɨc yɨ́p naxyucmɨ iga acuyo̱xa̱p.” ");
INSERT INTO poiNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Dios iwat tu̱m trato con jém Abraham. Iñɨ́máy iga iwadáyiñ jém marca de circuncisión jém ima̱nɨctam juuts tu̱m seña iga Dios iwadayñe jém trato con jeeyaj. Jeeyucmɨ cuando nay jém ima̱nɨc Isaac, cuando iniit́um ocho día, jém Abraham iwadáy ima̱nɨc jém marca de circuncisión. Ocmɨ cuando ma̱nɨgɨ́yum jém Isaac, iwadáyt́im je̱mpɨc jém ima̱nɨc Jacob. Ocmɨ cuando ma̱nɨgɨ́yum jém Jacob iwadáyt́im je̱mpɨc jém ima̱nɨctam. Jém doce ima̱nɨctam tsɨ́yyaj juuts ja̱tuŋpɨc de jém doce tribu de Israel. ");
INSERT INTO poiNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Yɨ́p Jacob ima̱nɨctam jém wiñɨcpɨc tantɨ̱wɨtam tsa̱m ijóyixyaj jém ijáyuc José. Ia̱chiyaj imáychi jém ijáyuc jém tuŋgac pɨxiñt́am. Ocmɨ nanɨcta̱ juumɨ jém naxyucmɨ de Egipto. Pero Dios iwaganait́ jém José. ");
INSERT INTO poiNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Icɨacput de it́u̱mpɨy jém yaacha̱ji. Dios iyo̱xpát jém José iga tsa̱m jɨ̱xiɨ́y iga iwɨ̱ixiñ jém Egiptopɨc rey jém Faraón. Ocmɨ jém Faraón iccám jém José iga gobernador de jém naxyucmɨ de Egipto. Chiit́a̱t́im jém cargo iga iŋjacpa jém it́yajwɨɨp jém rey it́ɨccɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Ocmɨ miñ tu̱m mɨjpɨc yuu y tu̱m mɨjpɨc yaacha̱ji jém naxyucmɨ de Egipto y jém Canaán. Jém wiñɨcpɨc tantɨ̱wɨtam d́a ipátyajpa t́i icútpa. ");
INSERT INTO poiNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Pero cuando jém Jacob ijo̱dóŋa̱ iga it́ trigo Egipto icutsat ima̱nɨctam, jém wiñɨcpɨc tantɨ̱wɨtam, iga ijuyyajpa jém trigo. Yɨ́p jém wiñt́ipɨc viaje. ");
INSERT INTO poiNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ocmɨ e̱ybɨct́im icutsat ima̱nɨctam Egipto. Jesɨc jém tuŋgac viaje jém José, jém máyñeta̱wɨɨp wiñɨgam, iŋmadayyaj ia̱chiyaj iga it́ɨ̱wɨ. Jesɨc jém rey Faraón icutɨɨyɨ́y júp raza jém José. ");
INSERT INTO poiNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Jesɨc José iñɨ́máy it́ɨ̱wɨtam iga: “Nami̱ñɨ jém tanja̱tuŋ con it́u̱mpɨy jém tantɨ̱wɨtam.” Jém miññeyajwɨɨp setenta y cinco con it́u̱mpɨy ima̱nɨctam. ");
INSERT INTO poiNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jesɨc je̱mpam iwat jém Jacob. Nɨc i̱t́i jém naxyucmɨ de Egipto. Ocmɨ jemɨgam ca jém Jacob. Más ocmɨ caayajt́im jém ima̱nɨctam jém naxyucmɨ Egipto. ");
INSERT INTO poiNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Cuando ca jém Jacob, naseedayt́a̱ it́ɨcmɨ jém ipacyaj jém attebet Siquem. Jemum cúmayt́a̱ jém ipac tu̱m tsaajosjo̱m. Jeet́im tsaajos ijuy wiñɨc jém Abraham. Imáychi tu̱m pɨ̱xiñ ima̱nɨctam, iñɨ̱yi jém pɨ̱xiñ Hamor. ");
INSERT INTO poiNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Cuando núctooba jém tiempo iga cupacpa jém trato jém Diospɨc iwadayñe jém Abraham, jesɨc tsa̱m jáyaŋa̱p jém Israelpɨc pɨxiñt́am jém naxyucmɨ de Egipto. ");
INSERT INTO poiNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ocmɨ tsucum tuŋgac rey jém naxyucmɨ de Egipto jém d́apɨc iixpɨcpa jém José. ");
INSERT INTO poiNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Yɨ́p aŋjagooyi tsa̱m imɨgóyáy jém wiñɨcpɨc tantɨ̱wɨtam. Tsa̱m imalwadáy jém tanja̱tuŋwe̱wetam. Ipɨɨmɨ́y iga ichaguiñ jém ima̱nɨctam, jém yaguiñpɨc nayñe, iga caayajiñ. ");
INSERT INTO poiNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Jesɨc jém tiempo nay jém Moisés, tu̱m wɨbɨc tsɨ̱xi, Dios tsa̱m iwɨ̱ixpa. Jém ija̱tuŋ icmɨja̱p tres meses it́ɨccɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ocmɨ jém ija̱tuŋ ichac jém ima̱nɨc iga caiññam. Jesɨc jém Faraón iyo̱mma̱nɨc ipiŋ jém xut́u tsɨ̱xi. Icmɨja̱p juuts iñuntama̱nɨc. ");
INSERT INTO poiNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Jeeyucmɨ jém Moisés tsa̱m wɨ̱cuyujne. Iwɨ̱cutɨɨyɨ́ypa it́u̱mpɨy jém jɨ̱xi jém it́wɨɨp Egipto. Jém Moisés tsa̱m wɨa̱p iwat t́i quej. Tsa̱m wɨa̱p iŋmat. ");
INSERT INTO poiNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Cuando jém Moisés iniit́ cuarenta ia̱mt́ɨy, ijɨ̱spa ia̱namaŋjo̱m iga nɨcpa ijooyáy jém it́ɨ̱wɨtam jém Israelpɨc pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Jemum iix tu̱m Egiptopɨc pɨ̱xiñ sɨ́p imalwadáy tu̱m Israelpɨc pɨ̱xiñ. Jesɨc jém Moisés icupuj jém it́ɨ̱wɨ. Icca jém pɨ̱xiñ, ichégáy iga imalwadáy jém it́ɨ̱wɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Jém Moisés ijɨ̱spa iga jém it́ɨ̱wɨtam icutɨɨyɨyñe iga Dios icutsat jém Moisés iga iccutsɨgáyiñ. Pero jeeyaj d́a icutɨɨyɨyyaj. ");
INSERT INTO poiNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Jesɨc tuŋgagam ja̱ma jém Moisés ipát wɨste̱n jém Israelpɨc pɨxiñt́am sɨ́p íŋa̱yaj. Iŋjɨyjac. Iñɨ́máy: “Odoy áŋa̱taamɨ con iñt́ɨ̱wɨ. ¿T́iiga minicótstamta̱p?” ");
INSERT INTO poiNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ocmɨ jém áŋa̱yajpáppɨc id́ɨc con it́ɨ̱wɨ agui ijóyix jém Moisés. Iñɨ́máy: “¿I̱ miccám juuts juez iga anaŋjɨyjactámpa? ");
INSERT INTO poiNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Que anaccaabat́im aɨch juuts matɨc inicca jém Egiptopɨc pɨ̱xiñ?” ");
INSERT INTO poiNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Jesɨc cuando imatoŋ t́i nɨm jém pɨ̱xiñ, poy jém Moisés. Nɨc i̱t́i jém naxyucmɨ de Madián juuts tu̱m juumɨpɨc pɨ̱xiñ. Jemum nay wɨste̱n ijayma̱nɨc. ");
INSERT INTO poiNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Cuando nasne cuarenta a̱mt́ɨy jém tɨtsɨnaxyucmɨ, jém Moisés it́ id́ɨc nocojo̱m jém co̱tsɨc iñɨ̱yi Sinaí. Jemum iix tu̱m xut́u cuy jípspa ixɨ. Jém juctjo̱m iwiñquejáy tu̱m sɨŋyucmɨpɨc pɨ̱xiñ, jém icutsatnewɨɨp tanJa̱tuŋ Dios. ");
INSERT INTO poiNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Agui ipooñaŋja̱m cuando iix jém juctɨ. Cuando icunúc nocojo̱m iga iwɨ̱ámpa, imatoŋ iga jɨypa jém tanJa̱tuŋ Dios. Nɨmpa: ");
INSERT INTO poiNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Ɨch jém wiñɨcpɨc pɨxiñt́am aDios. Ɨch jém Abraham aDios, jém Isaac aDios y jém Jacob aDios.” Jesɨc Moisés moj cuetsaayi. Agui cɨ̱ŋ, d́a wɨa̱p íŋámmoc jém juctɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Jesɨc jém tanJa̱tuŋ Dios iñɨ́máy jém Moisés: “Tsa̱cɨ jém iŋcɨac porque yɨɨm ju̱t́ mit́e̱ñ tsa̱m it́ jém Dios ipɨ̱mi. ");
INSERT INTO poiNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ɨch ánixñe jém ampɨxiñt́am iga tsa̱m yaachwatyajta̱p jém naxyucmɨ de Egipto. Ammatoŋ iga agui wejyajpa. Jeeyucmɨ aquet naxyucmɨ iga aŋcɨacputpa jeeyaj. Jesɨc mi̱ñɨ, maŋcutsatpa e̱ybɨc jém Egipto ju̱t́ miit́ id́ɨc.” ");
INSERT INTO poiNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Yɨ́pt́im Moisés jém tsa̱mpɨc ijóyixyaj jém wiñɨcpɨc pɨxiñt́am jém iñɨ́mayñewɨɨp iga: “¿I̱ miccám juuts miŋjagooyi y juuts mijuez?” Yɨ́pt́im Moisés Dios iccám juuts tu̱m aŋjagooyi iga icɨacputpa jém ipɨxiñt́am. Wɨa̱p iwat porque ichi ipɨ̱mi jém sɨŋyucmɨpɨc pɨ̱xiñ jém iixñewɨɨp ju̱t́ yótpa juctɨ jém xut́u cuyyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Yɨ́pt́im Moisés it́opyaj Egipto jém wiñɨcpɨc tantɨ̱wɨtam. Tsa̱m iwat jém milagro y jém seña jém naxyucmɨ de Egipto, jém Tsabats Lamar y jém tɨtsɨnaxyucmɨ ju̱t́ jáy i̱t́i cuarenta a̱mt́ɨy. ");
INSERT INTO poiNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Yɨ́pt́im Moisés iñɨ́máy jém Israelpɨc pɨxiñt́am iga: “Dios icutsatpa tuŋgac profeta juutst́im acutsat aɨch. Tsucumpa jém nunta tantɨ̱wɨtámaŋjo̱m juuts ɨch atsucumne. Cupɨ̱cɨ t́i nɨmpa.” ");
INSERT INTO poiNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Yɨ́pt́im Moisés it́ id́ɨc con jém wiñɨcpɨc tantɨ̱wɨtam jém tɨtsɨnaxyucmɨ cuando ijɨ́yáy jém sɨŋyucmɨ pɨ̱xiñ jém co̱tsɨcyucmɨ Sinaí. Ipɨctsoŋ jém vivopɨc Dios iŋma̱t́i iga tachiiñ taɨcht́am. ");
INSERT INTO poiNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Pero jém wiñɨcpɨc tantɨ̱wɨtam d́a icupɨcyaj jém Moisés. Ijóyixyaj. Ijɨ̱syaj ia̱namaŋjo̱m iga se̱tpa e̱ybɨc Egipto. ");
INSERT INTO poiNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Iñɨ́mayyaj jém Aarón: “Awadaayɨ tu̱m watnas jém aŋquejaypáppɨc jém tuŋ porque d́a tanjo̱doŋ ju̱t́ nɨc jém Moisés jém tatopnewɨɨp jém naxyucmɨ de Egipto.” ");
INSERT INTO poiNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ocmɨ jém Aarón iwat tu̱m watnas, tu̱m xut́u xix. Iccaayajpa jém ani̱mat jém watnas iwiñjo̱m iga iwatpa sacrificio. Agui maymayyaj iga wɨa̱p iwat icɨɨmɨ jém watnas. ");
INSERT INTO poiNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ocmɨ Dios ichagaŋputyaj jém pɨxiñt́am. Ichi lugar iga ijɨ̱syajpa jém ma̱tsa y it́u̱mpɨy cosa jém tánixpáppɨc sɨŋyucmɨ. Je̱mpam ijaychacne jém librojo̱m jém wiñɨcpɨc aŋmat́cɨɨwiñ. Nɨmpa Dios: Mimicht́am miIsraelpɨc mipɨxiñt́am, mich d́a inicca jém ani̱mat iga aŋwadáy sacrificio iga anchiiba ɨch aŋwiñjo̱m cuando jáy tawagai̱t́i jém tɨtsɨnaxyucmɨ jém cuarenta a̱mt́ɨy. ");
INSERT INTO poiNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Iŋcópcóbóypa jém watnas Moloc con jém ipuctucma̱stɨc. Inisɨɨbat́im jém watnas Renfán ima̱tsa jém michpɨc iŋwatneta iŋcɨɨmɨ iga iñjɨ̱stámpa. Jeeyucmɨ maŋquebacputtámpa jém iññaxyucmɨ. Maŋcutsattámpa más juumɨ de jém naxyucmɨ de Babilonia. ");
INSERT INTO poiNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Nɨmpa jém Esteban: —Jém wiñɨcpɨc tantɨ̱wɨtam inisɨɨbat́im jém puctucma̱stɨc ju̱t́ accáyt́a̱p jém tsaatabla ju̱t́ jayñeta̱ jém Moisés iŋquímayooyi. Jém puctucma̱stɨc iwat jém Moisés juuts Dios ipɨɨmɨ́y. Iwat juuts Dios iŋquejáy jém co̱tsɨcyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Jesɨc ocmɨ cuando caum jém Moisés, jém wiñɨcpɨc tantɨ̱wɨtam con jém Josué ipɨctsoŋyaj jém puctucma̱stɨc juuts tu̱m herencia. Ininɨcyaj jém tuŋgac naxyucmɨ iganam it́obáyáy jém tuŋgac pɨxiñt́am iñas. Dios iquebacput jém tuŋgac pɨxiñt́am iga ichi jém nas jém wiñɨcpɨc tantɨ̱wɨtam. Inisɨɨyajpa jém puctucma̱stɨc hasta cuando tsɨ́y jém David juuts aŋjagooyi. ");
INSERT INTO poiNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dios tsa̱m it́oypa jém David. Je agui iwattooba tu̱m mɨjpɨc tɨc ju̱t́ it́pa jém tanJa̱tuŋ Dios, jém ijɨ̱spáppɨc jém tanja̱tuŋwe̱we jém Jacob. ");
INSERT INTO poiNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pero jém Salomón, jém David ima̱nɨc, iwadáy Dios tu̱m tɨc, jém mɨjpɨc ma̱stɨc. ");
INSERT INTO poiNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Mex jém yucmɨpɨc Dios d́a i̱pa jém tɨcjo̱m jém watneta̱wɨɨp cɨɨmɨ, juuts nɨm jém wiñɨcpɨc aŋmat́cɨɨwiñ: ");
INSERT INTO poiNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Nɨmpa tanJa̱tuŋ Dios: Sɨŋyucmɨ it́ aŋco̱ñcuy. Naxyucmɨ anaccámne ampuy. ¿Juutspɨc tɨc aŋwadayt́ámpa? ¿Ju̱t́ it́ jém lugar ju̱t́ wɨa̱p anjej? ");
INSERT INTO poiNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Que d́a ɨch aŋcɨɨmɨ aŋwat it́u̱mpɨy jém yɨɨmpɨc it́yaj? ");
INSERT INTO poiNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Jesɨc jém Esteban iñɨ́máyt́im jém aŋjagooyiyaj: —Micht́am tsa̱m malotam íña̱nama juuts jém d́apɨc icupɨcpa Dios. Jém iñt́a̱tsɨc d́a matóŋóypa, d́a iŋwattooba juuts miñɨ́máypa jém Dios iA̱nama. Micht́am mijext́im juuts jém wiñɨcpɨc tantɨ̱wɨtam. ");
INSERT INTO poiNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿Juppɨc jém wiñɨcpɨc profeta d́a imalwadáy jém wiñɨcpɨc tantɨ̱wɨtam? Iccaayaj jém wiñɨcpɨc aŋmat́cɨɨwiñ jém iŋmatnewɨɨp iga miñpa naxyucmɨ jém Wɨbɨc Pɨ̱xiñ jém icutsatnewɨɨp Dios. Sɨɨp jeet́im pɨ̱xiñ mich iŋwadayt́a atraición. Iniccaata. ");
INSERT INTO poiNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Micht́am impɨctsoŋta jém Dios iŋquímayooyi jém tacɨɨjuŋcodayñewɨɨp jém sɨŋyucmɨpɨc pɨ̱xiñ, pero d́a iŋwatta juuts nɨmpa jém aŋquímayooyi. ");
INSERT INTO poiNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Cuando imatoŋyaj jém pɨxiñt́am t́i nɨmpa jém Esteban, tsa̱m ijóycayaj hasta ichɨgaŋjɨyyajpa it́ɨts jém Esteban icuyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pero jém Esteban tsa̱m iniit́ jém Dios iA̱nama. Jesɨc ámquím sɨŋyucmɨ, iix ju̱t́ it́ Dios. Iixt́im iga te̱ñ jém Jesús jém Dios iŋwɨ̱mɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Jesɨc iñɨ́máy jém pɨxiñt́am: —Aamɨ. Ɨch ánix iga áŋáyñe jém sɨŋ. Ánix jém Pɨ̱xiñ jém Miññewɨɨp Sɨŋyucmɨ. Sɨɨp te̱ñ jém Dios iŋwɨ̱mɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Pero jém pɨxiñt́am iŋnúcyaj jém it́a̱tsɨc. Pɨ̱mi jɨyyajpa, poyi̱mɨ miñyaj, iŋtuuma̱cayaj jém Esteban. Imatsyaj. ");
INSERT INTO poiNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","It́opyaj jém attebet, ininɨcyaj aŋsɨ̱cmɨ. Iñácscayaj tsaamɨ. Moj iyɨ́gayyaj jém Esteban jém icumɨgoyñeyajwɨɨp iga icujɨypa Dios. Ichagayyaj iyoot́i tu̱m ma̱ñpɨ̱xiñ ipuycɨɨm, iñɨ̱yi Saulo, iga iwadáypa cuenta. ");
INSERT INTO poiNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Iganam sɨ́p iyɨ́gayyaj tsaamɨ jém Esteban, iŋwejpát Dios. Nɨmpa: —MánO̱mi Jesús, pɨctso̱ŋɨ ána̱nama. ");
INSERT INTO poiNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ocmɨ jém Esteban co̱ste̱ññeactɨŋ. Pɨ̱mi jɨypa. Nɨmpa: —MánO̱mi, odoy tségayya̱jɨ yɨ́p pɨxiñt́am it́áŋca iga amalwadáy. Yaj nɨ̱mi, caum jém Esteban. ");
INSERT INTO poiNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Jém Saulo it́ de acuerdo con jém iccaaneyajwɨɨp jém Esteban. Jeet́im ja̱ma jém ijóyixyajpáppɨc moj ictsucumyaj iga pɨ̱mi imalwadáypa jém Dios ipɨxiñt́am jém it́yajwɨɨp Jerusalén. It́u̱mpɨy cupóyayyaj. Cunɨgayyaj yɨɨm jeexɨc hasta jém naxyucmɨ de Judea y Samaria. Tsɨ́y Jerusalén no más jém apóstolyaj. ");
INSERT INTO poiNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Algunos jém wɨbɨc pɨxiñt́am icum jém Esteban. Agui wejyajpa iga accaata̱ jém pɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Jesɨc jém Saulo moj iyaachwatyaj jém Dios ipɨxiñt́am. Nɨcpa iméts tɨc por tɨc. Pɨ̱mi̱mɨ ijɨ̱cputpa jém pɨxiñt́am con jém yo̱mtam. Icotyajpa cárcel. ");
INSERT INTO poiNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Pero jém cupóyayyajwɨɨp Jerusalén nɨc iŋmatyaj jém wɨbɨc aŋma̱t́i ju̱t́ quej. ");
INSERT INTO poiNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Jesɨc jém Felipe, tu̱m de jeeyaj, nɨc jém attebet Samaria. Jemum iŋmadáy jém pɨxiñt́am jém Cristo iŋquímayooyi. ");
INSERT INTO poiNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Aŋtuuma̱yajpa it́u̱mpɨy de jeeyaj, imatoŋyajpa t́i nɨmpa jém Felipe. Tsa̱m iwadáypa caso cuando iixyaj jém seña jém iwatnewɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Porque acpɨsyajta̱ tsa̱m jáyaŋ jém iniit́wɨɨp id́ɨc jém mal espíritu. Topta̱ jém mal espíritu. Tsa̱m pɨ̱mi aŋwejpa mu iput. Acpɨsyajta̱t́im jém tusacaneyajwɨɨp icumɨj y jém cu̱xujyaj. ");
INSERT INTO poiNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Jeeyucmɨ it́u̱mpɨy jém it́yajwɨɨp jém attebet tsa̱m maymayyaj. ");
INSERT INTO poiNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Pero it́ id́ɨc jém attebet tu̱m pɨ̱xiñ iñɨ̱yi, Ximoj. Icuyujcane jém magia iga iña̱watwadáypa jém it́ɨ̱wɨtam. Tsa̱m imɨgóyáypa jém pɨxiñt́am. Nɨmpa iga: “Ɨch tu̱m apɨ̱xiñ tsa̱m awɨa̱p.” ");
INSERT INTO poiNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","It́u̱mpɨy jém pɨxiñt́am tsa̱m iwadáypa caso. Icupɨcyajpa jém cuyujnewɨɨp y jém d́apɨc cuyujne. Nɨmyajpa: —Yɨ́p pɨ̱xiñ iniit́ jém Dios ipɨ̱mi. ");
INSERT INTO poiNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Tsa̱m iwɨ̱cupɨcyajpa porque dende wiñɨgam imɨgóyáypa jém pɨxiñt́am con jém magia. ");
INSERT INTO poiNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pero jesɨc jém Felipe inimiñ jém wɨbɨc aŋma̱t́i iga Dios iŋjactooba yɨ́p naxyucmɨ y iga wɨa̱p tacɨacput jém Jesucristo iñɨyi̱mɨ. Tsa̱m icupɨcyaj jém pɨxiñt́am y jém yo̱mtam. Acchiŋyajta̱. ");
INSERT INTO poiNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Jesɨc jeet́im Ximoj, jém na̱watpɨc id́ɨc, icupɨct́im. Acchiŋta̱. Mojum it́úŋɨ́y jém Felipe. Agui ipooñaŋja̱mpa cuando iix jém milagro y jém seña juuts iwatpa jém Felipe. ");
INSERT INTO poiNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Jesɨc cuando jém apóstolyaj jém it́yajwɨɨp Jerusalén ijo̱dóŋa̱yaj iga jém Samariapɨc pɨxiñt́am ipɨctsoŋyaj jém Dios iŋma̱t́i, icutsat jém Peto y Xiwan Samaria. ");
INSERT INTO poiNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Cuando núcyaj jém Samaria, moj iŋwejpádáy Dios para jém icupɨcneyajwɨɨp Cristo iga ipɨctsóŋiñ jém Dios iA̱nama. ");
INSERT INTO poiNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Porque ni tu̱m de jeeyaj d́anam ipɨctsoŋne jém Dios iA̱nama. No más acchiŋneyajta̱ jém tánO̱mi Jesús iñɨyi̱mɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Jesɨc jém Peto y Xiwan ichɨgáy jém pɨxiñt́am ico̱bac con icɨ. Je̱mpam ipɨctsoŋyaj jém Dios iA̱nama. ");
INSERT INTO poiNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Jesɨc jém Ximoj, jém na̱watpɨc id́ɨc, cuando iix iga chiit́a̱ jém Dios iA̱nama cuando jém apóstolyaj ichɨgáy jém pɨxiñt́am ico̱bac con icɨ, ");
INSERT INTO poiNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","iñɨ́máy: —Manyojpa. Achi̱ɨt́im jexpɨc pɨ̱mi mex aɨch iga cuando antsɨgáypa tu̱m pɨ̱xiñ ico̱bac con aŋcɨ, jesɨc ipɨctsoŋpat́im jém Dios iA̱nama. ");
INSERT INTO poiNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Jesɨc jém Peto iñɨ́máy: —Miwagatogóyiñ con jém iñt́umiñ porque iñjɨ̱spa iga jém Diospɨc tachiiba wɨa̱p iñjuy con tumiñ. ");
INSERT INTO poiNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Mich d́a inii̱ derecho iga iŋwatpa jém Dios iyo̱xacuy ni d́a miwɨa̱p porque d́a wɨ̱ jém íña̱nama jém Dios iwiñjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Tsa̱cɨ jém malopɨc jɨ̱xi. Aŋwejpaatɨ tanJa̱tuŋ Dios siiga wɨa̱p miwadáy perdón jém iñt́áŋca jém iñjɨ̱snewɨɨp íña̱namaŋjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Porque ánix iga tsa̱m iniit́ jém cujóyɨyooyi íña̱namaŋjo̱m juuts jém chuxñi̱wi tsa̱mpɨc ta̱m. Jém malopɨc jɨ̱xi michenne. ");
INSERT INTO poiNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Jesɨc jém Ximoj iñɨ́máy jém Peto: —Aŋwejpáttaamɨ Dios para ɨch iga odoy t́i annascaiñ juuts mich annɨ́mayñe. ");
INSERT INTO poiNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Jesɨc yaj iŋmat jém Dios iŋma̱t́i jemɨc, se̱tyaj jém Peto y Xiwan Jerusalén. Nasyajpa wa̱t́i jém tɨgaŋjoj jém naxyucmɨ de Samaria. Iŋmatyajpa jém wɨbɨc aŋma̱t́i iga Dios tacɨacputpa. ");
INSERT INTO poiNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Jesɨc ocmɨ Dios icutsat tu̱m sɨŋyucmɨpɨc pɨ̱xiñ. Iñɨ́máy jém Felipe: —Tsucu̱mɨ. Nɨcsɨm aŋtsapsa̱umɨ. Pɨ̱cɨ jém Gaza cu̱tuŋ, jém tsucumnewɨɨp Jerusalén. Naspa jém tuŋ jém tɨtsɨnaxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Jesɨc jém Felipe tsucum. Nɨc. Tuŋjo̱m ipát tu̱m Etiopíapɨc pɨ̱xiñ. Capun pɨ̱xiñ. Mɨjpɨc aŋjagooyi jém pɨ̱xiñ, tesorero. Iccáyáypa jém yo̱mpɨc aŋjagooyi it́umiñ. Jém yo̱mo iŋjacpa jém naxyucmɨ de Etiopía. Iñɨ̱yi jém yo̱mo Candace. Jém pɨ̱xiñ oy Jerusalén iga ijɨ̱spa Dios. ");
INSERT INTO poiNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Se̱tt́im id́ɨc it́ɨcmɨ, co̱ñ jém icarretajo̱m, sɨ́p imay jém libro jém ijaychacnewɨɨp jém Isaías jém wiñɨcpɨc profeta. ");
INSERT INTO poiNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Jesɨc jeet́i rato jém Dios iA̱nama iñɨ́máy jém Felipe: —Cunuucɨ jém carreta, wagananɨ̱cɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Póyaŋtsucum jém Felipe, cuando icunúc noco, imatoŋ iga sɨ́p imay jém libro jém ijayñewɨɨp Isaías. Jesɨc jém Felipe icwác jém capun pɨ̱xiñ, iñɨ́máy: —¿Iŋcutɨɨyɨ́y t́i sɨ́p immay? ");
INSERT INTO poiNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Jém pɨ̱xiñ iñɨ́máy: —¿Jutsa̱p aŋcutɨɨyɨ́y siiga d́a i̱ aŋquejáypa? Mi̱ñɨ tawagaco̱ñi yɨ́p carretajo̱m. ");
INSERT INTO poiNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Je̱m ju̱t́ sɨ́p imay jém Dios iŋma̱t́i nɨmpa así: Nanɨcta̱ jém pɨ̱xiñ, accaata̱ juuts tu̱m borrego juuts tu̱m ma̱ñborrego d́a aŋwejpa cuando cupood́a̱ta̱p, jesanet́im jém pɨ̱xiñ d́at́im jɨypa. ");
INSERT INTO poiNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Tsa̱m pɨ̱mi yaachwatta̱, chiit́a̱ castigo, pero d́a i̱ icɨɨpiŋ. ¿Jém ima̱nɨctam, i̱ wɨa̱p iŋmadáy porque d́a jáypa cuyajpa ivida yɨ́p naxyucmɨ? ");
INSERT INTO poiNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Jesɨc jém capun pɨ̱xiñ icwác jém Felipe. Iñɨ́máy: —¿Anɨ́maayɨ, t́i nɨmtooba yɨ́p aŋma̱t́i? ¿Jém wiñɨcpɨc profeta, iŋmatpa de iyaac o iŋmatpa de tuŋgac pɨ̱xiñ? ");
INSERT INTO poiNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Jesɨc jém Felipe moj iŋmadáy jém aŋma̱t́i jém sɨɨppɨc imay. Iŋmadáy jém wɨbɨc aŋma̱t́i de Jesús. ");
INSERT INTO poiNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Iganam waganɨcyajpa, núcyaj tu̱m lugar ju̱t́ it́ nɨ. Jesɨc jém capun pɨ̱xiñ iñɨ́máy jém Felipe: —Yɨɨm it́ nɨ. ¿Que ɨch d́a wɨa̱p anacchiŋ? ");
INSERT INTO poiNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Jém Felipe iñɨ́máy: —Siiga iŋcupɨcpa con it́u̱mpɨy íña̱nama, wɨa̱p manacchiŋ. Jesɨc jém pɨ̱xiñ iñɨ́máy Felipe: —Ɨch aŋcupɨcpa iga Jesucristo je jém Dios iMa̱nɨc. ");
INSERT INTO poiNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ocmɨ icte̱ñ jém icarreta. Quetyaj, tɨgɨyyaj jém nɨɨcɨɨm. Jém Felipe icchiŋ jém aŋjagooyi. ");
INSERT INTO poiNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Cuando putyaj jém nɨɨcɨɨm, jém Dios iA̱nama ininɨc jém Felipe. Jém aŋjagooyi d́a más iix. Mojum nɨqui, tsa̱m maymay. ");
INSERT INTO poiNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Jesɨc pátta̱ jém Felipe jém attebet Azoto. De je̱m moj nɨqui. Iŋmatpa jém wɨbɨc aŋma̱t́i it́u̱mpɨy jém attebetyaj hasta núc jém attebet Cesarea. ");
INSERT INTO poiNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Jesɨc jém Saulo seguido imalwadáypa jém tánO̱mi ipɨxiñt́am. Tsa̱m icumecpa iga iccaaba. Jeeyucmɨ nɨc iám jém co̱bacpɨc pa̱nij aŋjagooyi. ");
INSERT INTO poiNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Nɨc iwác tu̱m to̱to iga wɨa̱p it́ɨgɨyyaj jém sinagogayaj jém it́yajwɨɨp jém attebet Damasco iga icuámpa jém icupɨcneyajwɨɨp Cristo, jém pɨxiñt́am y yo̱mtam iga imatspa y ininɨcpa Jerusalén. ");
INSERT INTO poiNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Iganam nɨqui jém Saulo tuŋjo̱m, cuando núctooba jém attebet Damasco, iix tu̱m juctɨ tsa̱m pɨ̱mi tsocpa sɨŋyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Jesɨc jém Saulo actɨŋ naxyucmɨ. Imatoŋ tu̱m jɨ̱yi. Nɨ́mayt́a̱p: —Saulo, Saulo, ¿t́iiga anacpoypa? ");
INSERT INTO poiNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Jesɨc jém Saulo icwác. Nɨmpa: —¿Mii̱apaap, mánO̱mi? Jém jɨ̱yi icutsoŋ. Nɨmpa: —Ɨch aJesús jém michpɨc sɨɨp anacpoy. Iñyaact́im sɨɨp inimalwadayt́a̱. Mijex juuts jém yunta jém iñeppáppɨc jém icheŋóycuy iŋqui̱ñi. ");
INSERT INTO poiNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Jém Saulo tsa̱m pɨ̱mi cuetsáypa porque agui cɨ̱ŋne. Nɨmpa: —¿MánO̱mi, t́i iñxunpa iga aŋwatpa? Jesɨc tánO̱mi iñɨ́máy: —Tsucu̱mɨm, nɨ̱cɨ yɨ́p attebet Damasco. Jemum miñɨ́mayt́a̱p t́i wɨa̱p iŋwat. ");
INSERT INTO poiNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Jém pɨxiñt́am, jém iwagananɨcpáppɨc jém Saulo, tsa̱m pɨ̱mi cɨ̱ŋ porque imatoŋ jém jɨ̱yi, pero d́a i̱ iix. ");
INSERT INTO poiNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ocmɨ tsucum jém Saulo ju̱t́ actɨŋne id́ɨc naxyucmɨ. Tojne jém iixcuy, pero d́a ixixóypa. Matsayt́a̱ icɨ, jɨ̱cte̱ñt́a̱. Nanɨcta̱ jém attebet Damasco. ");
INSERT INTO poiNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Jemum tucunaja̱ma d́a ixixóypa. D́a wíc ni d́a nɨ́c. ");
INSERT INTO poiNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","It́ id́ɨc Damasco tu̱m pɨ̱xiñ iñɨ̱yi Ananías, icupɨcnet́im Cristo. Iwiñquejáy tánO̱mi juuts tu̱m po̱ñ. Iñɨ́máy: —¡Ananías! Jesɨc jém pɨ̱xiñ iñɨ́máy: —Yɨɨm ait́, mánO̱mi. ");
INSERT INTO poiNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Jesɨc iñɨ́máy jém tánO̱mi: —Tsucu̱mɨ. Nɨ̱cɨ jém calle iñɨ̱yi Nu̱ma, hasta jém Judas it́ɨccɨɨm. Acwaacɨ tu̱m pɨ̱xiñ de Tarso iñɨ̱yi Saulo, sɨ́p iŋwejpát Dios. ");
INSERT INTO poiNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Jém Saulo iixt́im tu̱m po̱ñ. Iix iga miñpa tu̱m pɨ̱xiñ iñɨ̱yi Ananías, tɨgɨypa jém tɨcjo̱m, iccámpa icɨ jém Saulo ico̱bacyucmɨ iga e̱ybɨct́im ixixóyiñ. ");
INSERT INTO poiNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Jesɨc imatoŋ jém Ananías, iñɨ́máy jém tánO̱mi: —MánO̱mi, tsa̱m jáyaŋ pɨxiñt́am aŋmadayñe t́i iwat yɨ́p pɨ̱xiñ iga tsa̱m imalwadáy jém impɨxiñt́am jém micupɨcneyajwɨɨp jém attebet Jerusalén. ");
INSERT INTO poiNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Sɨɨp núcneum yɨɨm con jeet́im orde jém ichiiñewɨɨp jém co̱bacpɨc pa̱nij iga imatspa it́u̱mpɨy jém iŋwejpátpáppɨc Dios mich iñɨyi̱mɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Jesɨc jém tánO̱mi iñɨ́máy jém Ananías: —Sɨɨp nɨcsɨm. Ɨch aŋcupiŋ yɨ́p pɨ̱xiñ iga iŋmadáyiñ ɨch anaŋquímayooyi jém tuŋgacpɨc pɨxiñt́am, jém tuŋgac naxyucmɨ ireyyaj y jém Israelpɨc pɨxiñt́am iwiñjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ɨch anaŋquejáypa iga tsa̱m pɨ̱mi yaachwatta̱p yɨ́p pɨ̱xiñ ɨch aŋcuyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ocmɨ jém Ananías nɨc jém tɨccɨɨm ju̱t́ it́ jém Saulo. Tɨgɨy, iccám icɨ ico̱bacyucmɨ. Iñɨ́máy: —Mantɨ̱wɨ Saulo, jém tánO̱mi Jesús miwiñquejáy iganam mimiñpa tuŋjo̱m. Sɨɨp acutsat iga wɨa̱p íñixixóy e̱ybɨc y iga tsa̱m iniid́iñ jém Dios iA̱nama. ");
INSERT INTO poiNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Jeet́i rato actɨŋ iixcuyyucmɨ juuts tɨɨpɨ iña̱ca, wɨa̱wum miixixóy e̱ybɨc. Jesɨc ocmɨ tsucum jém Saulo, acchiŋta̱. ");
INSERT INTO poiNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ocmɨ wícum, e̱ybɨc ipɨctsoŋ ipɨ̱mi. Tsɨ́y ju̱na ja̱ma con jém icupɨcneyajwɨɨp Cristo jém attebet Damasco. ");
INSERT INTO poiNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ocmɨ moj iŋmat jém wɨbɨc aŋma̱t́i jém sinagoga. Iŋmadáy jém pɨxiñt́am iga Jesús je jém Dios iMa̱nɨc. ");
INSERT INTO poiNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","It́u̱mpɨy jém imatoŋyajpáppɨc tsa̱m ipooñaŋja̱myaj. Nɨmyajpa: —¿Que d́a yɨ́pt́im pɨ̱xiñ jemɨc Jerusalén tsa̱m icpoy jém iŋwejpátpáppɨc Dios jém Jesús iñɨyi̱mɨ? ¿Que d́a yɨ́pt́im pɨ̱xiñ sɨ́p miññe yɨɨm iga imatspa jém pɨxiñt́am y ininɨcpa jém pa̱nij aŋjagooyicɨɨm? ");
INSERT INTO poiNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Pero jém Saulo más pɨ̱mi iŋmatpa jém Dios iŋma̱t́i. Je d́a cɨ̱ŋpa. Iŋquejáypa iga Jesús je jém Cristo hasta imɨswadáy ijɨ̱xi jém judíos jém it́yajwɨɨp Damasco. ");
INSERT INTO poiNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Cuando wa̱t́ña ja̱ma it́ jém Saulo, jém judíos iwatyaj acuerdo iga iccaayajpa. ");
INSERT INTO poiNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Pero ocmɨ jém Saulo ijo̱dóŋa̱ iga tsuucɨɨm y sɨŋñi jém ienemigo iŋte̱ññe jém puerta aŋna̱ca iga iccaaba cuando putpa jém attebet. ");
INSERT INTO poiNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Pero jém icupɨcneyajwɨɨp Cristo icotyaj jém Saulo tu̱m mɨjpɨc cooŋjo̱m. Ijɨ́mquetyaj tsuucɨɨm jém taañi iwe̱ñt́aŋ. Je̱mpam cɨɨput. ");
INSERT INTO poiNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Cuando núc jém Saulo jém Jerusalén, tɨgɨyt́ooba id́ɨc ju̱t́ aŋtuuma̱neyaj jém icupɨcneyajwɨɨp Cristo. Pero it́u̱mpɨy jém pɨxiñt́am tsa̱m icɨ̱ŋyajpa. D́a icupɨcpa iga jém Saulo nu̱ma icupɨcneum jém Cristo. ");
INSERT INTO poiNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Pero jém Bernabé iwagananɨc jém Saulo. Nɨc icwiñquej jém apóstolyaj iwiñjo̱m y iŋmadáypa jutsa̱ miix jém Saulo jém tánO̱mi tuŋjo̱m y jutsa̱ mijɨ́yáy. Iŋmadáypat́im iga jém Saulo d́a cɨ̱ŋpa iŋmat jém Damasco jém Jesús iñɨyi̱mɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Jesɨc jemum tsɨ́y Jerusalén jém Saulo. Mojum iwaganasɨɨyaj jeeyaj. ");
INSERT INTO poiNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Seguido iŋmatpa jém Dios iŋma̱t́i jém tánO̱mi iñɨyi̱mɨ. D́a cɨ̱ŋpa. Aŋmatmatneyajpa, áŋa̱yajpa con jém Israelpɨc pɨxiñt́am jém ijɨyyajpáppɨc jém griego aŋma̱t́i. Pero jeeyaj tsa̱m iccaayajtooba jém Saulo. ");
INSERT INTO poiNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Cuando ijo̱dóŋa̱yaj jém tantɨ̱wɨtam, nanɨcta̱ Saulo jém attebet Cesarea y de je̱m cutsatta̱ hasta it́ɨcmɨ jém attebet Tarso. ");
INSERT INTO poiNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Jesɨc d́a i̱ imoogɨ́ypa jém Dios ipɨxiñt́am icuwɨ̱t́i jém naxyucmɨ de Judea y de Galilea y de Samaria. Jesɨc más iwɨ̱cutɨɨyɨyyajpa Dios iŋma̱t́i jém icupɨcneyajwɨɨp Cristo. Tsa̱m iwɨ̱watyajpa porque tsa̱m icɨ̱ŋpa tánO̱mi. Dios iA̱nama iyo̱xpátpa iga tsa̱m jáyaŋa̱p jém Dios ipɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Jesɨc jém Peto nɨcpa ijooyáy jém tantɨ̱wɨtam yɨɨm jeexɨc. Nɨct́im ijooyáy jém icupɨcneyajwɨɨp Cristo jém attebet Lida. ");
INSERT INTO poiNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Jemum ipát tu̱m pɨ̱xiñ iñɨ̱yi Eneas. Ocho a̱mt́ɨy mɨmne icheesmɨ. Tusacane icumɨj. ");
INSERT INTO poiNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Jesɨc jém Peto iñɨ́máy: —Eneas, Jesucristo micpɨspa. Tsucu̱mɨ. Pi̱ŋɨ jém immoŋcuy. Jesɨc jeet́i rato tsucum jém Eneas. ");
INSERT INTO poiNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Jesɨc it́u̱mpɨy jém pɨxiñt́am jém it́yajwɨɨp jém attebet Lida y Sarón iixyaj iga pɨsneum. Ichacyaj jém wiñɨcpɨc aŋquímayooyi, moj icupɨcyaj jém tánO̱mi. ");
INSERT INTO poiNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Jeet́im tiempo it́ id́ɨc jém attebet Jope tu̱m yo̱mo icupɨcnet́im Cristo. Iñɨ̱yi Tabita. Jém aŋmat́i̱mɨ griego nɨmtooba Dorcas. Yɨ́p yo̱mo tsa̱m iwɨ̱watpa, iyo̱xpátpa jém yaacha̱yajpáppɨc. ");
INSERT INTO poiNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Jesɨc jeet́im tiempo mɨmneactɨŋ jém yo̱mo, ocmɨ ca. Jesɨc acchíŋayt́a̱ jém imɨjta̱y. Nanɨcta̱ tu̱m cuarto jém tuŋgac pisoyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jém attebet Jope d́a juumɨ de jém attebet Lida. Cuando imatoŋyaj iga it́ jém Peto jém attebet Lida, jém icupɨcneyajwɨɨp Cristo icutsatyaj wɨste̱n pɨ̱xiñ iga nɨguiñ iŋwejáy jém Peto. Iñɨ́máy: —Jicscɨy nɨ̱cɨ jém Jope. ");
INSERT INTO poiNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Jesɨc nɨc jém Peto con jém miññeyajwɨɨp iŋwejáy. Cuando núc jém Jope, nanɨcta̱ jém cuarto ju̱t́ it́ jém tsúts jém yucmɨpɨc piso. It́u̱mpɨy jém cuno̱yt́am iŋtuuma̱caneyaj. Tsa̱m wejyajpa. Iŋquejayyajpa jém Peto jém wɨbɨc tecxi y yoot́i jém iñúnwɨɨp jém Dorcas cuando vivonam. ");
INSERT INTO poiNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Jesɨc Peto iñɨ́máy iga pud́iñ it́u̱mpɨy jém it́yajwɨɨp cuartojo̱m. Co̱ste̱ññeactɨŋ, moj iŋwejpát Dios. Iámseedáy jém yo̱mo jém caanewɨɨp, iñɨ́máy: —Tabita, tsucu̱mɨ. Jesɨc jém yo̱mo ictoj iixcuy. Cuando iix jém Peto, co̱ñchucum. ");
INSERT INTO poiNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Jém Peto imatsáy icɨ, ijɨ̱ctsucum. Iŋwejáy jém tantɨ̱wɨtam y jém cuno̱yt́am. Iŋquejáy iga pɨsneum. ");
INSERT INTO poiNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Icuwɨ̱t́i jém attebet Jope imatoŋyaj t́i iñasca jém yo̱mo. Tsa̱m jáyaŋ icupɨcyaj jém tánO̱mi. ");
INSERT INTO poiNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Tsɨ́y jém Peto jém attebet Jope wa̱t́ña ja̱ma tu̱m pɨ̱xiñ it́ɨccɨɨm. Iñɨ̱yi Ximoj jém pɨ̱xiñ, icɨŋpáppɨc cuero. ");
INSERT INTO poiNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","It́ id́ɨc jém attebet Cesarea tu̱m pɨ̱xiñ iñɨ̱yi Cornelio. Capitán id́ɨc, iŋjacpa tu̱m batallón, jém grupo iñɨ̱yi jém Italiano. ");
INSERT INTO poiNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Yɨ́p pɨ̱xiñ ijɨ̱syajpa Dios con it́u̱mpɨy jém ichɨ̱xt́am y it́ɨ̱wɨtam. Icɨ̱ŋyajpa Dios. Ichiiba tumiñ jém yaacha̱yajpáppɨc iga iyo̱xpátpa. Siempre iŋwejpátpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Tu̱m ja̱ma como las tres de la tarde iix tu̱m po̱ñ. Iñuntawɨ̱ix iga tɨgɨy hasta ju̱t́ it́ jém Cornelio tu̱m sɨŋyucmɨpɨc pɨ̱xiñ jém icutsatnewɨɨp Dios. Iñɨ́máy: —¡Cornelio! ");
INSERT INTO poiNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Jém Cornelio agui iámpa jém sɨŋyucmɨpɨc pɨ̱xiñ, tsa̱m pɨ̱mi cɨ̱ŋne. Jesɨc icwác. Nɨmpa: —¿T́i, mánO̱mi? Jesɨc jém sɨŋyucmɨpɨc pɨ̱xiñ iñɨ́máy: —Dios mimatóŋayñeum jém íñoración. Ijo̱doŋ iga agui iñyo̱xpátpa jém yaacha̱yajpáppɨc y Dios tsa̱m iwɨ̱aŋja̱m. ");
INSERT INTO poiNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Sɨɨp cutsa̱tɨ algunos pɨxiñt́am jém attebet Jope iga iŋwejáypa tu̱m pɨxiñ iñɨ̱yi Ximoj, iñɨ̱yit́im Peto. ");
INSERT INTO poiNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Yɨ́p pɨ̱xiñ it́ jém tuŋgac Ximoj it́ɨccɨɨm jém icɨŋpáppɨc cuero. It́ jém lamar aŋna̱ca. Jém pɨ̱xiñ miŋmadáypa t́i wɨa̱p iŋwat. ");
INSERT INTO poiNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Jesɨc nɨc jém sɨŋyucmɨpɨc pɨ̱xiñ jém inimiññewɨɨp jém aŋma̱t́i. Jém Cornelio iŋwejáy wɨste̱n jém imozo y tu̱m soldado. Jém soldado siempre iwatpa juuts pɨɨmɨyt́a̱p. Ijɨ̱spat́im Dios. ");
INSERT INTO poiNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Jesɨc jém Cornelio iŋmadáy it́u̱mpɨy t́i iix y t́i iñɨ́máy jém sɨŋyucmɨpɨc pɨ̱xiñ. Ocmɨ icutsat jém attebet Jope. ");
INSERT INTO poiNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Jesɨc icuqueja̱ma nɨc imétsyaj jém Peto. Iganam nɨquiyaj tuŋjo̱m cuando núctoobam nocojo̱m jém attebet Jope, jesɨc jeet́i rato quím jém Peto jém yucmɨpɨc piso iga iŋwejpátpa Dios. Cugapja̱ma. ");
INSERT INTO poiNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Pɨ̱mi yua̱ne jém Peto, agui wíctooba, pero iganam sɨ́p iwadayt́a̱ iwíccuy, iix tu̱m po̱ñ. ");
INSERT INTO poiNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Iix iga áŋáy jém sɨŋ. Juuts tu̱m mɨjpɨc manta jɨ́mquetta̱ hasta naxyucmɨ, tsénayñeta̱ icucuatro it́a̱tsɨc. ");
INSERT INTO poiNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","It́yaj jém mantajo̱m it́u̱mpɨy jém ani̱mat yɨ́p naxyucmɨpɨc, jém cuatropɨc ipuy, jém tsa̱ñyaj y jém jonyaj. ");
INSERT INTO poiNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ocmɨ imatoŋ tu̱m jɨ̱yi. Nɨ́mayt́a̱: —Peto, tsucu̱mɨ, acca̱ɨ, cuutɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pero jém Peto icutsoŋ. Nɨmpa: —MánO̱mi, d́a queman oypa aŋcút jém d́apɨc wɨ̱ taŋcút, ni jém nɨmyajpáppɨc iga tactáŋcaɨ́ypa. ");
INSERT INTO poiNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","E̱ybɨct́im jɨ́yayt́a̱. Nɨ́mayt́a̱: —Jém Diospɨc iwɨ̱tsac iga wɨ̱ taŋcút, d́a i̱ wɨa̱p iñɨm iga tactáŋcaɨ́ypa. ");
INSERT INTO poiNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Je̱mpɨgam iñasca tuccɨy. Ocmɨ e̱ybɨct́im quím jém manta sɨŋyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Iganam ámaŋjac jém Peto iga iix jém po̱ñ, núcyaj jém tɨgaŋna̱ca jém pɨxiñt́am jém icutsatnewɨɨp jém Cornelio. Acwágoyyajpa jém Ximoj it́ɨccɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Cuando núcyaj it́ɨccɨɨm, pɨ̱mi jɨy. Icwácyaj siiga jemum it́ jém Ximoj iñɨ̱yit́im Peto. ");
INSERT INTO poiNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Iganam Peto sɨ́p ijɨ̱s t́i nɨmtooba jém po̱ñ, Dios iA̱nama iñɨ́máy: —Aamɨ, sɨ́p miméts tucute̱n pɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Tsucu̱mɨ, que̱tɨ jém yucmɨpɨc piso, nɨcsɨm con jeeyaj. Odoy cɨ̱ŋɨ porque ɨch maŋcutsadayñe. ");
INSERT INTO poiNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Jesɨc quet jém Peto, nɨc iám jém tucute̱n pɨ̱xiñ jém icutsatnewɨɨp jém Cornelio. Iñɨ́máy: —Ɨcham jém ammétstampáppɨc. ¿T́iiga mimiñt́a yɨɨm? ");
INSERT INTO poiNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Jesɨc iñɨ́máy jém pɨxiñt́am: —Amiñt́a porque acutsatta jém capitán Cornelio. Je tu̱m wɨbɨc pɨ̱xiñ, tsa̱m iwatpa juuts ixunpa Dios. It́u̱mpɨy jém Israelpɨc pɨxiñt́am tsa̱m iwɨ̱aŋja̱myaj, tsa̱m it́oyyajpa jém capitán. D́a más pecam oy iwiñquejáy tu̱m sɨŋyucmɨpɨc pɨ̱xiñ jém icutsatnewɨɨp Dios. Nɨmpa jém sɨŋyucmɨpɨc pɨ̱xiñ iga miŋwejáyiñ it́ɨccɨɨm iga imatoŋpa jém capitán mich iniŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Jesɨc jém Peto iñɨ́máy jém pɨxiñt́am: —Tɨgɨ̱yɨ. Jemum tsɨ́yyaj jém tsuu con jém Peto. Icuqueja̱ma waganɨcyajpa jém Peto con jeeyaj. Iwagananɨcyajpat́im algunos jém tantɨ̱wɨtam jém it́yajwɨɨp jém attebet Jope. ");
INSERT INTO poiNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Jesɨc jém tuŋgagam más ja̱ma, núcyaj jém attebet Cesarea. Jemum iŋjócneyaj jém Cornelio con algunos it́ɨ̱wɨtam y con jém más wɨbɨc iamigoyaj jém iŋwejayñewɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Cuando núc jém Peto jém Cornelio it́ɨccɨɨm, put jém Cornelio, miñ iwɨ̱pɨctsoŋ. Co̱ste̱ñactɨŋ jém Peto iwiñjo̱m iga iŋwejpáttooba. ");
INSERT INTO poiNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pero jém Peto ijɨ̱ctsucum. Iñɨ́máy: —Te̱ñchucu̱mɨ. Ɨch apɨ̱xiñt́im juuts mimich. ");
INSERT INTO poiNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Iganam sɨɨp iŋmatyaj, tɨgɨyyaj jém Cornelio it́ɨcjo̱m. Jém Peto ipát tsa̱m jáyaŋ pɨxiñt́am aŋtuuma̱neyaj. ");
INSERT INTO poiNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Jesɨc Peto iñɨ́máy: —Micht́am iñjo̱doŋ iga jém judíos iŋquímayooyi d́a ijɨ́cpa iga aŋtuuma̱p jém judíos con jém tuŋgac pɨxiñt́am ni d́at́im ijɨ́cpa iga tɨgɨypa jém tuŋgac pɨ̱xiñ it́ɨcjo̱m. Pero Dios aŋquejayñe iga d́a wɨ̱ iga tanjɨ̱spa iga tu̱m pɨ̱xiñ tactáŋcawatpa, d́a wɨ̱ iga tanjɨ̱spa iga tu̱m pɨ̱xiñ d́a jex juuts taɨch. ");
INSERT INTO poiNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Jeeyucmɨ cuando mich anaŋwejáy, amiñ. D́a t́i anjɨy. Sɨɨp manacwácpa, ¿t́iiga anaŋwejáy? ");
INSERT INTO poiNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Jesɨc jém Cornelio iñɨ́máy: —Iniit́um cuatro día como yɨ́pt́im hora ait́ antɨccɨɨm. Aŋwatne ayuno. Anaŋwejpátpa Dios juuts siempre aŋwatpa cada cutsuuya̱ji. Jesɨc awiñquejáy tu̱m pɨ̱xiñ tsa̱m tsocpa ipuctu̱cu. ");
INSERT INTO poiNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Jém pɨ̱xiñ anɨ́máy: “MiCornelio, Dios mimatóŋayñeum jém íñoración. Ijɨ̱spa iga tsa̱m iñyo̱xpátpa jém yaacha̱yajpáppɨc.” ");
INSERT INTO poiNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Anɨ́máyt́im: “Cutsa̱tɨ algunos jém impɨxiñt́am hasta jém attebet Jope iga inimíñiñ jém Ximoj iñɨ̱yit́im Peto. Jém pɨ̱xiñ it́ jém tuŋgac Ximoj it́ɨccɨɨm jém icɨŋpáppɨc cuero jém it́wɨɨp lamar aŋna̱ca. Cuando núcpa, miŋmadáypa t́i wɨa̱p iŋwat.” ");
INSERT INTO poiNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Jeeyucmɨ jeet́i rato aŋcutsat jém ampɨxiñt́am iga nɨguiñ miméts. Agui wɨ̱ iga mimiñ. Sɨɨp tantu̱mpɨyt́am tait́t́a yɨɨm Dios iwiñjo̱m. Tsa̱m ammatoŋtamtooba it́u̱mpɨy cosa juuts miñɨ́máy jém tánO̱mi. ");
INSERT INTO poiNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Jesɨc jém Peto moj jɨ̱yi. Nɨmpa: —Nu̱ma sɨɨp taŋcutɨɨyɨ́ypa iga jém tanJa̱tuŋ Dios d́a iñe̱jaixpa ni tu̱m pɨ̱xiñ. It́u̱mpɨy iixpa jext́im. ");
INSERT INTO poiNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Pero Dios iwɨ̱pɨctsoŋpa it́u̱mpɨy jém pɨxiñt́am icuwɨ̱t́i yɨ́p naxyucmɨ siiga icɨ̱ŋpa Dios y iwɨ̱watpa. ");
INSERT INTO poiNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Dios icutsadáy jém wɨbɨc aŋma̱t́i jém Israelpɨc pɨxiñt́am. Iñɨ́máy iga tawɨ̱pɨctsoŋpa tanJa̱tuŋ Dios porque tawɨ̱wadáy jém Jesucristo. Je tantu̱mpɨyt́am tánO̱mi. ");
INSERT INTO poiNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Micht́am iŋwɨ̱jo̱doŋ t́i nasne jém naxyucmɨ de Judea. Jemɨgam tsucum jém Galilea cuando najɨ́yóypa y acchíŋóypa jém Xiwan. ");
INSERT INTO poiNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Iñjo̱doŋt́im iga ocmɨ Dios ichi jém Jesús de Nazaret jém Dios iA̱nama ipɨ̱mi. Iñjo̱doŋt́im iga ju̱t́ quej nɨcpa jém Jesús, iwɨ̱wadáypa jém pɨxiñt́am, icpɨspa it́u̱mpɨy jém iyaachwatyajpáppɨc jém Woccɨɨwiñ. Jém tanJa̱tuŋ Dios iwaganait́, jeeyucmɨ wɨa̱p iwat je̱mpɨc. ");
INSERT INTO poiNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Aɨcht́am atsɨ́yt́a juuts testigo. Ánixñeta it́u̱mpɨy cosa juuts iwat jém attebet Jerusalén y icuwɨ̱t́i jém judíos iñaxyucmɨ. Ocmɨ jeeyaj iccaayaj, cunúnta̱ cunusyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Pero Dios icpɨs jém tucunaja̱ma y awiñquejayt́a aɨcht́am. ");
INSERT INTO poiNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","D́a iwiñquejáy it́u̱mpɨy pɨxiñt́am. No más awiñquejáy aɨcht́am jém acupiŋneta̱wɨɨp dende wiñt́i jém tanJa̱tuŋ Dios iga atsɨ́yt́a juuts testigo. Awagawícta, awaganɨ́cta con je cuando pɨsneum de ju̱t́ it́ jém caaneyajwɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Acutsatta iga anaŋmadayt́ámiñ jém pɨxiñt́am y anaŋquejayt́ámiñ iga Dios iccám yɨ́pt́im Jesús iga juez iga icɨɨpiŋpa jém vivopɨc y jém caaneyajwɨ́ppɨc. ");
INSERT INTO poiNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Dende wiñɨgam it́u̱mpɨy jém Dios iŋmat́cɨɨwiñ iŋmatyajt́im iga miñpa jém Jesús. Nɨmyajpa iga jém icupɨcpaap jém Jesús, wadayt́a̱p perdón jém it́áŋca jém Jesús iñɨyi̱mɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Iganam sɨ́p iŋmat jém Peto, núc jém Dios iA̱nama. Ipɨctsoŋyaj it́u̱mpɨy jém imatoŋneyajwɨɨp jém Peto iŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Tsa̱m ipooñaŋja̱myajpa jém Israelpɨc pɨxiñt́am jém miññeyajwɨɨp con Peto, jém icupɨcnewɨɨp Cristo, cuando iix iga chiit́a̱t́im jém Dios iA̱nama jém tuŋgac pɨxiñt́am jém d́apɨc je de Israel. ");
INSERT INTO poiNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Porque imatoŋyaj iga jɨyyajpa jém tuŋgac pɨxiñt́am iŋmat́i̱mɨ. Tsa̱m icujípyajpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Jesɨc Peto iñɨ́máy: —¿I̱ wɨa̱p iñɨm iga d́a wɨa̱p tanacchiŋ yɨ́p pɨxiñt́am? Porque ipɨctsoŋneum Dios iA̱nama juutst́im taɨcht́am. ");
INSERT INTO poiNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Jesɨc Peto ipɨɨmɨ́y iga acchiŋyajta̱iñ jém pɨxiñt́am jém Jesucristo iñɨyi̱mɨ. Ocmɨ cunucsayt́a̱ jém Peto iga tsɨ́yiñ ju̱na ja̱ma con jeeyaj. ");
INSERT INTO poiNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Jesɨc jém apóstolyaj con jém tantɨ̱wɨtam, jém it́yajwɨɨp Judea, ijo̱dóŋa̱yaj iga jém tuŋgac pɨxiñt́am, jém d́apɨc je de Israel, ipɨctsoŋyajt́im jém Dios iŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Cuando se̱t Jerusalén jém Peto, agui icujɨyyaj jém Israelpɨc pɨxiñt́am jém icupɨcneyajwɨɨp Jesús. ");
INSERT INTO poiNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Nɨmyaj: —¿T́iiga oy iñjooyáy jém tuŋgac pɨxiñt́am jém d́apɨc je de Israel? ¿T́iiga miwagawícpa con jeeyaj? ");
INSERT INTO poiNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Jesɨc jém Peto moj iŋmadáy t́it́am iñasca dende wiñt́i. Iñɨ́máy: ");
INSERT INTO poiNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Ɨch ait́ id́ɨc jém attebet Jope. Iganam sɨ́p anaŋwejpát Dios, ánix tu̱m po̱ñ. Ánix juuts tu̱m mɨjpɨc manta tsénayñeta̱ icucuatro it́a̱tsɨc, jɨ́mquetta̱ dende sɨŋyucmɨ hasta ju̱t́ ait́. ");
INSERT INTO poiNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Cuando aŋwɨ̱ám t́i it́ jém mantajo̱m, ánix yɨ́p naxyucmɨpɨc ani̱mat jém cuatropɨc ipuj, jém jɨmñi ani̱mat, it́t́im jém tsa̱ñ, jém pa̱chi y jém jonyaj. ");
INSERT INTO poiNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Jesɨc ammatoŋ tu̱m jɨ̱yi. Anɨ́mayt́a̱: “Peto, tsucu̱mɨ, acca̱ɨ, cuutɨ.” ");
INSERT INTO poiNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Pero annɨ́máy: “MánO̱mi, ɨch d́a queman aŋcút jém d́apɨc wɨ̱ taŋcút jém tactáŋcaɨypáppɨc.” ");
INSERT INTO poiNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Jesɨc e̱ybɨc ajɨ́yáy jém sɨŋyucmɨpɨc jɨ̱yi. Anɨ́máy: “Jém Diospɨc iwɨ̱tsac, d́a wɨa̱p tannɨm iga d́a wɨ̱ taŋcút.” ");
INSERT INTO poiNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Annasca tuccɨy. Ocmɨ e̱ybɨc jɨ́mquímta̱ sɨŋyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Jeet́i rato núcyaj tucute̱n pɨ̱xiñ jém tɨccɨɨm ju̱t́ ait́ id́ɨc. Tu̱m Cesareapɨc pɨ̱xiñ icutsat iga miñ améts. ");
INSERT INTO poiNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Jém Dios iA̱nama anɨ́máy iga anɨguiñ con jeeyaj y iga odoy acɨɨŋiñ. Aŋwagananɨctat́im yɨ́p seis tantɨ̱wɨtam. Antu̱mpɨyt́am atɨgɨyt́a jém pɨ̱xiñ it́ɨcjo̱m, tu̱m capitán. ");
INSERT INTO poiNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Aŋmadáy jutsa̱ miix it́ɨccɨɨm tu̱m sɨŋyucmɨpɨc pɨ̱xiñ. Miñ iŋmadáy jém capitán. Iñɨ́máy: “Cutsa̱tɨ algunos pɨxiñt́am jém attebet Jope iga inimíñiñ jém Ximoj iñɨ̱yit́im Peto. ");
INSERT INTO poiNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Je miñpa miŋmadáy jutsa̱p iŋcɨɨput y jutsa̱p icɨɨputyaj it́u̱mpɨy jém it́yajwɨɨp iñt́ɨccɨɨm.” ");
INSERT INTO poiNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Cuando moj anaŋmat jém Dios iŋma̱t́i, ipɨctsoŋyaj jém Dios iA̱nama juutst́im taɨcht́am matampɨctsoŋ wiñt́i. ");
INSERT INTO poiNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Jesɨc anjɨ̱s t́i tanɨ́máy jém tánO̱mi. Nɨmpa: “Jém Xiwan acchíŋóypa con nɨ, pero mimicht́am impɨctsoŋtámpa Dios iA̱nama.” ");
INSERT INTO poiNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Siiga Dios ichi jém tuŋgac pɨxiñt́am jém Dios iA̱nama juuts tachiiñeta taɨcht́am, jém taŋcupɨcnewɨɨp Jesucristo, ¿jesɨc ɨch ai̱apaap iga anɨcpa contra jém tanJa̱tuŋ Dios? ");
INSERT INTO poiNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Jesɨc cuando imatoŋyaj jém tantɨ̱wɨtam, jém it́yajwɨɨp Jerusalén, d́a jɨyyaj. Moj icujípyaj Dios. Nɨmyaj: —Jém tanJa̱tuŋ Dios ichiit́im lugar jém tuŋgac pɨxiñt́am jém d́apɨc je de Israel iga icucacyajpa ijɨ̱xi iga iniit́pat́im jém vida jém d́apɨc cuyajpa. ");
INSERT INTO poiNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Cuando accaata̱ jém Esteban, jeet́im ja̱ma moj icpoyyajta̱ los demás jém icupɨcneyajwɨɨp Cristo. Cupóyayyaj. Algunos nɨcyaj hasta jém attebet Fenicia, Chipre y Antioquía. Jemɨgam iŋmadayyaj jém wɨbɨc aŋma̱t́i jém Israelpɨc pɨxiñt́am. Pero d́a iŋmadáy jém tuŋgac pɨxiñt́am jém d́apɨc je de Israel. ");
INSERT INTO poiNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Pero algunos jém tantɨ̱wɨtam jém it́yajwɨɨp jém attebet Chipre y Cirene nɨcyaj jém attebet Antioquía. Iŋmadayyaj jém tuŋgac pɨxiñt́am jém d́apɨc je de Israel iga wɨa̱p icɨacputyaj jém tánO̱mi Jesús. ");
INSERT INTO poiNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Jém tantɨ̱wɨtam tsa̱m iniit́ jém tánO̱mi ipɨ̱mi. Tsa̱m jáyaŋ jém pɨxiñt́am ichacyaj jém wiñɨcpɨc aŋquímayooyi. Moj icupɨcyaj jém tánO̱mi Jesús. ");
INSERT INTO poiNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Cuando ijo̱dóŋa̱yaj jém Dios ipɨxiñt́am, jém it́yajwɨɨp Jerusalén, icutsat jém Bernabé iga nɨguiñ Antioquía. ");
INSERT INTO poiNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Cuando núc jém Bernabé, iix iga Dios agui iwɨ̱wadayñe jém pɨxiñt́am. Jesɨc agui maymay jém Bernabé. Moj iŋquímyaj it́u̱mpɨy jém pɨxiñt́am iga iwɨ̱cupɨguiñ y odoy ichaguiñ jém tánO̱mi iŋmadayooyi. ");
INSERT INTO poiNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Porque jém Bernabé tu̱m wɨbɨc pɨ̱xiñ, tsa̱m iniit́ jém Dios iA̱nama. Tsa̱m iwɨ̱cupɨcpa iga Dios wɨa̱p. Jeeyucmɨ jáyaŋ pɨxiñt́am tɨgɨyñeyaj iga icupɨcyajpa jém tánO̱mi Jesús. ");
INSERT INTO poiNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ocmɨ jém Bernabé nɨc jém attebet Tarso. Nɨc iméts jém Saulo. Cuando ipát, ininɨc Antioquía. ");
INSERT INTO poiNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Jáy i̱t́iyaj jemum con jém Dios ipɨxiñt́am. Oy i̱t́i tu̱m a̱mt́ɨy. Iŋquejáy jáyaŋ pɨxiñt́am jém Dios iŋma̱t́i. Yɨ́pt́im Antioquía moj iccámayyajta̱ iñɨ̱yi iga cristiano jém icupɨcneyajwɨɨp Cristo. ");
INSERT INTO poiNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Jeet́im tiempo algunos jém profeta, jém it́yajwɨɨp Jerusalén, nɨc Antioquía. ");
INSERT INTO poiNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Tu̱m de jeeyaj, iñɨ̱yi Agabo, te̱ñchucum ju̱t́ aŋtuuma̱neyaj jém tantɨ̱wɨtam. Dios iA̱nama icjo̱dóŋa̱ t́i miñpa. Nɨmpa iga miñpa tu̱m mɨjpɨc yuu icuwɨ̱t́i de yɨ́p naxyucmɨ. Ocmɨ nu̱ma cupac juuts nɨm, jém tiempo cuando iŋjacpa jém Romapɨc aŋjagooyi Claudio. ");
INSERT INTO poiNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Jesɨc ocmɨ jém icupɨcneyajwɨɨp Cristo, jém Antioquíapɨc pɨxiñt́am, moj ijɨ̱syaj iga icutsadayyajpa tu̱m yo̱xpádooyi jém tantɨ̱wɨtam jém it́yajwɨɨp Judea. Ichiiyajpa cada tu̱mtu̱m jutsaŋ wɨa̱yajpa. ");
INSERT INTO poiNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Je̱mpɨgam iwatyaj. Cutsadayt́a̱ jém yo̱xpádooyi jém Dios ipɨxiñt́am iŋjagooyiyaj. Oy ichac jém Bernabé y Saulo. ");
INSERT INTO poiNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Jeet́im tiempo moj icpoy jém rey Herodes algunos jém Dios ipɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Accaata̱ con espada jém Jacobo jém Xiwan it́ɨ̱wɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Cuando jém Herodes iix iga agui iwɨ̱aŋja̱m jém Israelpɨc pɨxiñt́am, jesɨc ipɨɨmɨ́yt́im iga matsta̱iñ mex jém Peto. Iñasca je̱mpɨc cuando watta̱p jém sɨŋ iga cútta̱p jém caxt́ána̱ñi sin levadura. ");
INSERT INTO poiNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Cuando matsta̱ jém Peto, nanɨcta̱ cárcel. Jém cárcel tsa̱m wɨ̱ watneta̱ cuenta con cuatro grupo de soldado. Cada grupo it́yaj cuatro soldado. Jém Herodes ijɨ̱spa id́ɨc iga it́oppa jém Peto cuando cuyajneum jém sɨŋ iga icɨɨpiŋpa jém pɨxiñt́am iwiñjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Jeeyucmɨ tsɨ́y Peto jém cárcel, tsa̱m wɨ̱watneta̱ cuenta. Pero jém Dios ipɨxiñt́am tsa̱m pɨ̱mi iŋwejpádáypa Dios para je. ");
INSERT INTO poiNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ocmɨ cuando núc jém tiempo iga jém Herodes ijɨ̱spa iga it́oppa jém Peto, jeet́im tsuu moŋpa Peto cucmɨ de wɨste̱n soldado. Tsenne con wɨste̱n cadena. Algunos jém soldado iwatne cuenta jém cárcel ipuerta. ");
INSERT INTO poiNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Jeet́i rato iwiñquejáy jém Peto tu̱m sɨŋyucmɨpɨc pɨ̱xiñ jém Diospɨc icutsatne. Jém cárcel ijojmɨ cutsoctɨc juuts tu̱m juctɨ. Jesɨc jém sɨŋyucmɨpɨc pɨ̱xiñ ichɨgáy jém Peto ipócpac. Ichɨcyus. Iñɨ́máy: —Jicscɨy tsucu̱mɨ. Jesɨc wij jém cadena jém Peto icɨɨyucmɨ, cutɨŋ naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Jém sɨŋyucmɨpɨc pɨ̱xiñ iñɨ́máy: —Tsencaamɨ jém iñcinturón immɨjpacyucmɨ. Co̱tɨ iŋcɨac. Cuando yaj iwat je̱mpɨc, iñɨ́máy jém sɨŋyucmɨpɨc pɨ̱xiñ: —Co̱tɨ iñyoot́i. Atúŋɨɨyɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Jesɨc put jém Peto, mojum it́úŋɨ́y jém sɨŋyucmɨpɨc pɨ̱xiñ. Pero d́a icutɨɨyɨ́y siiga nu̱ma t́i iwatpa jém sɨŋyucmɨpɨc pɨ̱xiñ. Je ijɨ̱spa no más iga ima̱wiñ. ");
INSERT INTO poiNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Pero nasyaj ju̱t́ iŋte̱ññe jém wiñt́ipɨc soldado y jém ocmɨpɨc soldado. Cuando núcyaj ju̱t́ it́ jém tɨ́ŋcuy puerta jém calle aŋna̱ca, áŋáy iyaac jém puerta. Putyaj, wid́aŋnasyaj tu̱m calle, jeet́i rato nɨc jém sɨŋyucmɨpɨc pɨ̱xiñ. Tsɨ́y icut́um jém Peto. ");
INSERT INTO poiNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Jesɨgam jém Peto icutɨɨyɨ́y iga nu̱ma. Nɨmpa: —Sɨɨp aŋcutɨɨyɨ́y iga nu̱ma jém tánO̱mi icutsat tu̱m sɨŋyucmɨpɨc pɨ̱xiñ iga acɨacputpa jém Herodes icɨɨjo̱m con jém Israelpɨc pɨxiñt́am icɨɨjo̱m jém amalwadaypáppɨc id́ɨc. ");
INSERT INTO poiNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Iganam sɨ́p ijɨ̱s jém Peto t́i iñasca, nɨc jém Malía it́ɨccɨɨm. Jém yo̱mo jém Xiwan ia̱pa iñɨ̱yit́im Marco. Je̱m tsa̱m jáyaŋ pɨxiñt́am aŋtuuma̱neyaj. Sɨ́p iwatyaj oración. ");
INSERT INTO poiNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Cuando jém Peto it́ɨcs jém puerta, miñ iŋtsoŋ tu̱m wo̱ñi iñɨ̱yi Rode. ");
INSERT INTO poiNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Imatóŋactɨɨyáy iga Peto ijɨ̱yi. Pero jém wo̱ñi d́a íŋáy jém tɨc. Tsa̱m maymay, póyaŋtsucum, nɨc jojmɨ iga iŋmadáy jém aŋtuuma̱neyajwɨɨp iga núcneum jém Peto jém puerta aŋna̱ca. ");
INSERT INTO poiNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Pero jeeyaj iñɨ́máy jém wo̱ñi: —Mich miloco. Pero jém wo̱ñi nɨmpa: —¡Nu̱ma, d́a je mɨgooyi! Jesɨc nɨmyajpa jém pɨxiñt́am: —¿Que d́a je Petot́im ia̱nama? ");
INSERT INTO poiNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Seguido it́ɨcspa puerta jém Peto. Cuando íŋáy jém puerta jém pɨxiñt́am, iixyaj jém Peto, tsa̱m pɨ̱mi ámaŋjacyaj. ");
INSERT INTO poiNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pero jém Peto iwat seña con icɨ iga odoy jɨyyajiñ. Moj iŋmadáy jutsa̱ mit́op tánO̱mi jém cárcel. Iñɨ́máy jém pɨxiñt́am: —Aŋmadayt́aamɨ jém Jacobo y los demás jém tantɨ̱wɨtam. Ocmɨ put jém Peto, nɨc tuŋgac lugar. ");
INSERT INTO poiNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Icuqueja̱ma pɨ̱mi cujíñayñeyaj jém soldadoyaj porque d́a ijo̱doŋ t́i iñasca jém Peto. ");
INSERT INTO poiNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Jém Herodes icutsat jém soldado iga inimíñiñ jém Peto, pero d́a ipát. Jesɨc jém Herodes iŋwejáy jém soldado jém iwatneyajwɨɨp cuenta jém cárcel. Icɨɨpiŋ. Ocmɨ ipɨɨmɨ́y iga accaayajta̱iñ it́u̱mpɨy de jeeyaj. Jesɨc put jém Herodes jém naxyucmɨ de Judea, nɨc i̱t́i jém attebet de Cesarea. ");
INSERT INTO poiNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Jesɨc jém Herodes tsa̱m pɨ̱mi ijóyixpa jém pɨxiñt́am jém it́yajwɨɨp jém attebet de Tiro y Sidón. Pero jém pɨxiñt́am iwatyaj acuerdo con jém Blasto, tu̱m mɨjpɨct́im aŋjagooyi, icuyo̱xa̱p jém rey Herodes. Iyojyaj jém Blasto iga iyo̱xpád́iñ. Icunucsáy iga odoy imoogɨyyajiñ jém rey porque jém pɨxiñt́am ipɨcpa iwíccuy jém rey Herodes iñaxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Jém Herodes iŋwejáy jém pɨxiñt́am. Iñɨ́máy júp ja̱ma miñyajiñ. Jesɨc jém ja̱ma icot jém rey ipuctu̱cu. Nɨc co̱ñi jém ico̱ñcuyyucmɨ ju̱t́ cɨɨpíŋóypa. Moj najɨ́yooyi. ");
INSERT INTO poiNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Jesɨc jém pɨxiñt́am, jém iŋwejayñeyajwɨɨp, tsa̱m pɨ̱mi jɨyyajpa, tsa̱m icujípyajpa jém Herodes. Nɨmyaj: —Yɨɨmpɨc jɨypa d́a je pɨ̱xiñ, tu̱m dios. ");
INSERT INTO poiNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Jeet́i rato tanJa̱tuŋ Dios icutsat tu̱m sɨŋyucmɨpɨc pɨ̱xiñ iga icmɨmneiñ jém Herodes porque d́a icujíppa Dios. Más iwɨ̱aŋja̱m iga cujípta̱iñ iyaac. Je̱mpɨgam ca. Jém tsuuquiñ icútyaj. ");
INSERT INTO poiNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Pero jém tánO̱mi iŋquímayooyi más jáyaŋa̱p. Aŋmatta̱p ju̱t́iŋquej jém aŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Jesɨc jém Bernabé y Saulo cuando cuyaj jém iyo̱xacuy, putyaj Jerusalén. Se̱tyaj it́ɨcmɨ. Iwagananɨcyajpa jém Xiwan iñɨ̱yit́im Marco. ");
INSERT INTO poiNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Jesɨc jemɨgam ju̱t́ aŋtuuma̱yajpa jém Dios ipɨxiñt́am, jém attebet Antioquía, it́yaj jém Dios iŋmat́cɨɨwiñ y jém wɨbɨc maestroyaj. It́yaj jém Bernabé; jém Ximoj iñɨ̱yit́im Niger; jém Lucio, jém Cirenepɨc pɨ̱xiñ; jém Manaén, icuyo̱xa̱p id́ɨc jém Herodes jém gobernador de Galilea; it́t́im jém Saulo. ");
INSERT INTO poiNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Tu̱m ja̱ma cuando aŋtuuma̱neyaj jém pɨxiñt́am iga ijɨ̱spa jém tánO̱mi y iwatyajpa ayuno, Dios iA̱nama iñɨ́máy jém pɨxiñt́am: —Tsa̱cɨ aparte yɨ́p Bernabé y Saulo jém aŋcupiŋnewɨɨp iga acuyo̱xa̱p. ");
INSERT INTO poiNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Iwatyaj ayuno jém Dios ipɨxiñt́am, iŋwejpátyaj Dios, iccámayyaj icɨ jém Bernabé y Saulo ico̱bacyucmɨ. Jesɨc naŋquímyajta̱. ");
INSERT INTO poiNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Jesɨc Dios iA̱nama icutsat jém Bernabé y Saulo. Nɨcyaj jém attebet Seleucia. Jemum tɨgɨyyaj barcojo̱m iga nɨcpa jém isla de Chipre. ");
INSERT INTO poiNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Cuando núc jém attebet Salamina, moj iŋmat jém Dios iŋma̱t́i jém judíos ima̱stɨcjo̱m, jém sinagoga. Iwagananɨcyajt́im jém Xiwan iga iyo̱xpátpa. ");
INSERT INTO poiNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Iŋmatyaj yɨɨm jeexɨc icuwɨ̱t́i jém isla de Chipre. Núcyaj jém attebet Pafos. Jemum ipát tu̱m na̱wat iñɨ̱yi Barjesús. Nɨmpa iga tu̱m Israelpɨc aŋmat́cɨɨwiñ, pero je tu̱m mɨgoypaap. ");
INSERT INTO poiNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Jém na̱wat it́ id́ɨc con jém gobernador Sergio Paulo. Yɨ́p aŋjagooyi tsa̱m jɨ̱xiɨ́y. Iŋwejáy jém Bernabé y Saulo porque agui imatoŋtooba jém Dios iŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Pero jém na̱wat, iñɨ̱yit́im Elimas, nɨcpa en contra de jém Bernabé y Saulo. D́a ichiit́ooba lugar jém gobernador iga icupɨguiñ Cristo. ");
INSERT INTO poiNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Jesɨc jém Saulo, iñɨ̱yit́im Pablo, tsa̱m iniit́ jém Dios iA̱nama. Iwɨ̱ámmats jém na̱wat. ");
INSERT INTO poiNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Iñɨ́máy: —Mimɨgoypaap, tsa̱m malopɨc mipɨ̱xiñ, Woccɨɨwiñ mima̱nɨc. Mich tsa̱m mienemigo de it́u̱mpɨy jém wɨ̱tampɨc cosa. Agui iŋwótpa jém tánO̱mi iŋquímayooyi jém nu̱mapɨc. ");
INSERT INTO poiNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Sɨɨp jém tánO̱mi michiiba castigo. Sɨɨp micácht́ia̱p. Ju̱na ja̱ma d́a wɨa̱p íñix jém ja̱ma icho̱ca. Jesɨc jeet́i rato imats juuts tu̱m oma jém iixcuy, cupiicha̱. Mojpa iméts i̱ wɨa̱p ijɨ̱cte̱ñ. ");
INSERT INTO poiNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Cuando jém gobernador iix t́i iñasca jém pɨ̱xiñ, icupɨc Cristo. Agui ipooñaŋja̱mpa cuando imatoŋ jém tánO̱mi iŋquímayooyi. ");
INSERT INTO poiNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Ocmɨ jém Pablo con icompañeroyaj tɨgɨy barcojo̱m, putyaj jém attebet Pafos. Nɨcyaj jém attebet Perge jém naxyucmɨ de Panfilia. Pero jém Xiwan ichagaŋput iga iwaganasɨɨba jeeyaj, se̱t Jerusalén. ");
INSERT INTO poiNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ocmɨ nasyaj jém attebet Perge, núcyaj jém tuŋgac Antioquía jém it́wɨɨp jém naxyucmɨ de Pisidia. Jemum tu̱m jejcuy ja̱ma tɨgɨyyaj jém sinagoga, co̱ñyaj. ");
INSERT INTO poiNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Jém sinagoga iŋjagooyiyaj imayyaj jém Dios iŋma̱t́i, jém Moisés iŋquímayooyi y jém ijaychacnewɨɨp jém wiñɨcpɨc aŋmat́cɨɨwiñ. Cuando yaj imayyaj, jesɨc jém aŋjagooyiyaj icutsadáy aŋma̱t́i jém Pablo. Nɨ́mayt́a̱: —Mantɨ̱wɨtam, siiga iniit́ t́i iññɨ́mayt́ooba yɨ́pyaj pɨxiñt́am iga iniŋquímpa, sɨɨbam wɨa̱p iniŋmadáy. ");
INSERT INTO poiNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Jesɨc jém Pablo te̱ñchucum. Iwat tu̱m seña con icɨ iga odoy i̱ jɨ́yiñ, moj iŋmadáy: —MiIsraelpɨc mipɨxiñt́am y mimicht́am iŋcɨ̱ŋtampáppɨc tanJa̱tuŋ Dios, matoŋtaamɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","TanJa̱tuŋ Dios, jém Israelpɨc pɨxiñt́am iDios, icupiŋ jém wiñɨcpɨc tanja̱tuŋwe̱wetam. Tsa̱m icjáyaŋa̱yaj jém taŋwe̱wetam cuando oy i̱t́iyaj jém naxyucmɨ Egipto juuts juumɨpɨc pɨxiñt́am. Ocmɨ it́op jém naxyucmɨ de Egipto con ipɨ̱mi. ");
INSERT INTO poiNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Dios iyaachɨ́y iga tsa̱m imalwatyajpa jeeyaj cuando jáy i̱t́iyaj cuarenta a̱mt́ɨy jém tɨtsɨnaxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ocmɨ Dios ictogoy siete nación jém it́yajwɨɨp jém naxyucmɨ de Canaán iga chiit́a̱p jém nas jém tanja̱tuŋwe̱wetam. ");
INSERT INTO poiNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Jesɨc ocmɨ Dios iccám jém juezyaj iga iŋjacyajpa jém Israelpɨc pɨxiñt́am cuatrocientos cincuenta a̱mt́ɨy. Iŋjacyajpa jém juezyaj hasta que núc jém tiempo de Samuel jém Dios iŋmat́cɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ocmɨ iwácyaj tu̱m nunta rey iga iŋjaguiñ. Jesɨc Dios iccám jém Saúl juuts rey iga iŋjacpa cuarenta a̱mt́ɨy. Jém Saúl, jém Cis ima̱nɨc, tsucum de jém tribu de Benjamín. ");
INSERT INTO poiNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ocmɨ Dios it́op jém Saúl. Accámta̱ jém David iga rey. Nɨmpa Dios: “Ampát jém David jém Isaí ima̱nɨc. Jém ijɨ̱xi jext́im juuts aɨch. Iwatpa juuts ɨch aŋwɨ̱aŋja̱m.” ");
INSERT INTO poiNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Yɨ́pt́im David io̱cma̱nɨc ma̱nɨc jém Jesús, jém icɨacputpáppɨc jém Israelpɨc pɨxiñt́am. Dios ictsucum juuts tajɨycámayñe wiñɨgam. ");
INSERT INTO poiNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Antes que miñpa jém Jesús, jém Xiwan iŋmadáy it́u̱mpɨy jém Israelpɨc pɨxiñt́am iga icucacyajiñ ijɨ̱xi y iga acchiŋyajta̱iñ. ");
INSERT INTO poiNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Cuando d́am jáyñe iga caaba jém Xiwan, nɨmpa: “Ɨch d́a aje jém michpɨc iñjɨ̱spa iga miñpa. Pero ocmɨ miñpa antuuñiaŋcɨɨm tu̱m pɨ̱xiñ más wɨa̱p que aɨch. Ɨch d́a ipa̱t́i iga aŋwijáypa icɨac ipuyyucmɨ.” ");
INSERT INTO poiNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","’Mantɨ̱wɨtam, jém Abraham mima̱nɨctam, jém iŋcɨ̱ŋtampáppɨc Dios, taɨcht́am tacutsadayt́a̱ jém wɨbɨc aŋma̱t́i iga tacɨacputpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jém it́yajwɨɨp Jerusalén y jém iŋjagooyiyaj d́a ijo̱doŋyaj iga Jesús je jém icutsatnewɨɨp Dios. D́at́im icutɨɨyɨyyajpa cuando imayyajpa cada jejcuy ja̱ma jém aŋma̱t́i jém ijaychacnewɨɨp jém wiñɨcpɨc aŋmat́cɨɨwiñ. Cuando accaata̱ jém Jesús, cupacpa iwat juuts nɨm jém wiñɨcpɨc aŋmat́cɨɨwiñ. ");
INSERT INTO poiNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Mex d́a ipádayyaj it́áŋca jém Jesús iga accaata̱iñ, jém pɨxiñt́am iwágáy jém Pilato iga accaata̱iñ. ");
INSERT INTO poiNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Cuando jém pɨxiñt́am yaj imalwadayyaj jém Jesús juuts ijaychacne jém wiñɨcpɨc aŋmat́cɨɨwiñ, icquetyaj jém icunusyucmɨ, icumyaj. ");
INSERT INTO poiNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Pero Dios icpɨs de ju̱t́ it́ jém caaneyajwɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Wa̱t́ña ja̱ma iwiñquejáy jém icuyujcɨɨwiñ jém iwaganamiññewɨɨp de Galilea a Jerusalén. Sɨɨp jeeyaj tsɨ́yyaj juuts testigo iga iŋmadayyajpa jém pɨxiñt́am iga nu̱ma pɨsneum. ");
INSERT INTO poiNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","’Sɨɨp aɨcht́am manaŋquejáypa jém wɨbɨc aŋma̱t́i jém Diospɨc ijɨycámayñe jém wiñɨcpɨc tanja̱tuŋwe̱wetam. ");
INSERT INTO poiNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Sɨɨp Dios iccupac jém promesa para taɨcht́am jém wiñɨcpɨc pɨxiñt́am tama̱nɨctam. Iccupac Dios cuando icpɨs jém Jesús, juuts jaychacneta̱ jém salmo dos. Nɨmpa: Mich mamma̱nɨc. Yɨ́p ja̱ma manchi jém vida. ");
INSERT INTO poiNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Jém tanJa̱tuŋ Dios ijɨychacne iga icpɨspa jém ima̱nɨc de ju̱t́ it́ jém caaneyajwɨɨp iga jém imɨjta̱y d́a púcpa. Yɨɨmpɨc nɨmpa ju̱t́ jaychacneta̱: Manyaachaŋja̱mpa, maŋwɨ̱wadáypa juuts anjɨycámayñe jém David. ");
INSERT INTO poiNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Jeeyucmɨ nɨmpat́im jém tuŋgac salmo: D́a anjɨ́cpa iga púcpa imɨjta̱y jém acuyo̱xapaap, jém tsa̱mpɨc antoypa. ");
INSERT INTO poiNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Nu̱ma jém David tsa̱m icuyo̱xa̱ jém it́ɨ̱wɨtam juuts iwɨ̱aŋja̱m Dios. Ocmɨ ca, cumta̱ ju̱t́t́im cumneyaj jém ija̱tuŋwe̱we, púc jém imɨjta̱y. ");
INSERT INTO poiNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Pero jém icpɨsnewɨɨp Dios, d́a púc jém imɨjta̱y. ");
INSERT INTO poiNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Mantɨ̱wɨtam, jo̱dóŋa̱taamɨ iga yɨ́pt́im Jesús iñɨyi̱mɨ miŋmadayt́amta̱p iga Dios miwadayt́ámpa perdón jém iñt́áŋca. ");
INSERT INTO poiNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Yɨ́p pɨ̱xiñ iñɨyi̱mɨ it́u̱mpɨy jém icupɨcneyajwɨɨp Jesús wadayt́a̱p perdón it́u̱mpɨy jém it́áŋca jém d́apɨc wɨa̱p iwɨ̱tsagáy jém Moisés iŋquímayooyi. ");
INSERT INTO poiNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Nawattamta̱jɨ cuenta mimicht́am iga d́a iññascaaba juuts ijaychacne jém wiñɨcpɨc aŋmat́cɨɨwiñ. Nɨmpa yɨɨmpɨc: ");
INSERT INTO poiNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Mimalopɨc mipɨxiñt́am, tsa̱m iñxiccatámpa jém wɨbɨc cosa. Núcpa ja̱ma iga agui miámaŋjacpa, pero mit́ogoypa. Porque ɨch aDios aŋwatpa tu̱m mɨjpɨc cosa jém tiempo de mimicht́am. Pero mimicht́am d́a iŋcupɨctámpa mex i̱ miŋmadáypa. ");
INSERT INTO poiNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Iganam putyaj jém Pablo con icompañeroyaj jém sinagoga, jesɨc jém pɨxiñt́am iñɨ́mayyaj: —Yɨ́p tuŋgac jejcuy ja̱ma mi̱ñɨ aŋmadayt́aamɨ e̱ybɨc jém sɨɨppɨc ammatoŋta. ");
INSERT INTO poiNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Cuando cupudayyaj de ju̱t́ aŋtuuma̱neyaj, jesɨc tsa̱m jáyaŋ jém judíos con jém tuŋgac pɨxiñt́am, jém iwɨ̱aŋja̱myajpáppɨc jém Moisés iŋquímayooyi, it́úŋɨyyajpa jém Pablo y Bernabé. Jesɨc jeeyaj iŋquímpa jém pɨxiñt́am iga seguido icupɨguiñ y odoy ichaguiñ jém Dios it́óyooyi. ");
INSERT INTO poiNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Jesɨc jém tuŋgac semana jém jejcuy ja̱ma aŋtuuma̱yajpa casi it́u̱mpɨy jém it́yajwɨɨp jém attebet iga imatoŋyajpa jém Dios iŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Pero cuando jém judíos iix iga aŋtuuma̱neyaj tsa̱m jáyaŋ pɨxiñt́am, jesɨc tsa̱m na̱jajoyyajpa, moj imalmalnɨ́mayyaj jém Pablo. Nɨmyajpa iga tsa̱m mɨgóypa. ");
INSERT INTO poiNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Jém Pablo y Bernabé d́a cɨ̱ŋpa iŋmat. Iñɨ́máy: —Tienes que wiñt́i manaŋmadáypa jém Dios iŋma̱t́i mimicht́am miIsraelpɨc mipɨxiñt́am. Pero como d́a impɨctsoŋtooba jém vida jém d́apɨc cuyajpa, sɨɨp ananɨgáypa jém wɨbɨc aŋma̱t́i jém tuŋgac pɨxiñt́am jém d́apɨc je de Israel. ");
INSERT INTO poiNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Porque je̱mpɨgam tanɨ́máy jém tanJa̱tuŋ Dios. Nɨmpa yɨɨmpɨc: Manaccám juuts tu̱m wɨbɨc juctɨ para jém tuŋgac pɨxiñt́am jém d́apɨc je de Israel. Maŋcutsatpa iga ininɨcpa jém wɨbɨc aŋma̱t́i iga Dios icɨacputtooba jém pɨxiñt́am icuwɨ̱t́i yɨ́p naxyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Jesɨc cuando imatoŋyaj jém tuŋgac pɨxiñt́am, jém d́apɨc je de Israel, agui maymayyaj. Nɨmyajpa: —¡Yɨ́p Dios iŋma̱t́i tsa̱m wɨ̱! Jesɨc icupɨcyaj it́u̱mpɨy jém icupiŋnewɨɨp Dios iga ipɨctsoŋyajiñ jém vida jém d́apɨc cuyajpa. ");
INSERT INTO poiNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Jesɨc aŋmatta̱p jém Dios iŋma̱t́i icuwɨ̱t́i jém naxyucmɨ de Pisidia. ");
INSERT INTO poiNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Pero jém judíos tsa̱m ijóyixyajpa jém wɨbɨc aŋma̱t́i. Moj ictsucum iga icpóyɨyyajpa jém Pablo y Bernabé. Jém malopɨc judíos iñɨ́máy jém wɨbɨc yo̱mtam con jém mɨjpɨc aŋjagooyiyaj iga iyo̱xpád́iñ. Jesɨc moj icpóyɨyyaj hasta icquebacputyaj jém naxyucmɨ de Pisidia. ");
INSERT INTO poiNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Jesɨc cuando putyaj jém Pablo y Bernabé, icunebayyaj jém pótpót ipuyyucmɨ iga quejiñ iga jém pɨxiñt́am d́a ipɨctsoŋyaj jém Dios iŋma̱t́i. Ocmɨ nɨcyaj jém attebet Iconio. ");
INSERT INTO poiNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Pero jém icupɨcneyajwɨɨp Cristo jém attebet Antioquía tsa̱m maymayyaj. Tsa̱m iniit́yaj Dios iA̱nama. ");
INSERT INTO poiNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Jesɨc jém attebet Iconio jém Pablo y Bernabé wagatɨgɨyyaj jém judíos isinagoga. Como tsa̱m wɨa̱p iŋmatyaj jém wɨbɨc aŋma̱t́i, tsa̱m jáyaŋ pɨxiñt́am icupɨcyaj jém Cristo. Icupɨcyajt́im jém judíos con jém griegopɨc. ");
INSERT INTO poiNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Pero jém judíos, jém d́apɨc icupɨcpa, tsa̱m pɨ̱mi imalnɨ́mayyaj jém Pablo y Bernabé. Icjóyixyajt́im jém tuŋgac pɨxiñt́am jém d́apɨc je de Israel. ");
INSERT INTO poiNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Jeeyucmɨ tsɨ́yyaj jemum jém Pablo y Bernabé wa̱t́ña ja̱ma. D́a cɨ̱ŋpa iŋmat porque ijo̱doŋ iga iyo̱xpátpa jém tánO̱mi. Nu̱ma Dios iŋquejáypa jém pɨxiñt́am iga d́a mɨgóypa jém Pablo cuando iŋmatpa de jém Dios it́óyooyi. Chiit́a̱t́im jém Dios ipɨ̱mi iga wɨa̱p iwat jém milagro y jém seña jém d́apɨc oypa tánix. ");
INSERT INTO poiNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Pero nawécyajta̱ jém pɨxiñt́am jém it́yajwɨɨp jém attebet. Algunos iwɨ̱aŋja̱myaj jém judíos iŋquímayooyi, algunos iwɨ̱aŋja̱myaj jém apóstol iŋquímayooyi. ");
INSERT INTO poiNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ocmɨ jém judíos con jém tuŋgac pɨxiñt́am iwatyaj acuerdo con jém aŋjagooyiyaj iga imalwadayyajpa jém Pablo y Bernabé, iga iñácscayajpa tsaamɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Pero jém Pablo y Bernabé cuando ijo̱dóŋa̱yaj, poyyaj, nɨcyaj jém attebet Listra y Derbe jém naxyucmɨ de Licaonia. Nasyaj it́u̱mpɨy jém attebetyaj jém nocojo̱mpɨc it́ ");
INSERT INTO poiNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","iga iŋmatyajpa jém wɨbɨc aŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Jém attebet Listra co̱ñ tu̱m cu̱xuj calle aŋna̱ca. D́a nunca wɨa̱p iwit́ porque cu̱xuj miñay. ");
INSERT INTO poiNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Jém pɨ̱xiñ sɨ́p imatoŋ t́i nɨmpa jém Pablo. Jesɨc jém Pablo iámmats, iix iga tsa̱m icupɨcpa iga Dios wɨa̱p icpɨs. ");
INSERT INTO poiNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Jesɨc jém Pablo ijɨ́yáypa pɨ̱mi. Nɨmpa: —¡Tsucu̱mɨ, nu̱mte̱ñɨ! Jém pɨ̱xiñ te̱ñchucum, yóyquím, mojum wi̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Cuando jém pɨxiñt́am iixyaj t́i iwat jém Pablo, pɨ̱mi jɨyyajpa jém Licaoniapɨc aŋmat́i̱mɨ. Nɨmyajpa: —Quetneum wɨste̱n diosyaj, jex juuts pɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ijɨ̱syaj jém pɨxiñt́am iga jém Bernabé jém dios Júpiter y jém Pablo jém dios Mercurio porque je agui aŋmatpa. ");
INSERT INTO poiNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Jém pa̱nij, jém icuyo̱xapáppɨc jém dios Júpiter, iniit́ ima̱stɨc jém attebet aŋna̱ca. Inimiñ jute̱n xix tsa̱m iwɨ̱accuyajne con jém mo̱ya. Jém pa̱nij con jém pɨxiñt́am iccaayajtooba jém xix juuts tu̱m sacrificio jém Pablo iwiñjo̱m iga ijɨ̱syajpa juuts tu̱m dios. ");
INSERT INTO poiNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Pero jém apóstolyaj, jém Pablo y Bernabé, cuando icutɨɨyɨyyaj t́i iwatpa jém pɨxiñt́am, jesɨc ichiccujac jém iyoot́i. Tɨgɨy jém pɨxiñt́ámaŋjo̱m, moj jɨ̱yi pɨ̱mi. ");
INSERT INTO poiNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Nɨmpa: —¡Mipɨxiñt́am! ¿T́iiga iŋwattámpa je̱mpɨc? Ɨch apɨ̱xiñ juuts mimicht́am. Jeeyucmɨ amiñ iga manactsactámpa jexpɨc jɨ̱xi jém d́apɨc tayo̱xpátpa. Cupɨ̱cɨ jém vivopɨc Dios jém iwatnewɨɨp sɨŋ, nas y lamar. It́u̱mpɨy jém Dios iwa̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Wiñɨgam Dios ijɨ́c iga it́u̱mpɨy jém pɨxiñt́am iwatyajpa con ijɨ̱xi juuts ixunpa iyaac. ");
INSERT INTO poiNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Pero dende wiñɨgam taŋquejáypa juutspɨc Dios jém tanJa̱tuŋ Dios. Tsa̱m tawɨ̱wadáypa. Icchijóypa tuj iga tanait́t́ámpa wɨbɨc cosecha. Tachiiba t́it́am taŋcútpa iga tamaymáya̱p. ");
INSERT INTO poiNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Mext́im iŋmadáypa je̱mpɨc, jém Pablo tsa̱m táŋca ictsac jém pɨxiñt́am iga iccaaba jém xix iga iwadáypa sacrificio jém Pablo y Bernabé iwiñjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ocmɨ miñyajt́im je̱m jém malopɨc judíos, jém it́yajwɨɨp jém Antioquía y jém Iconio. Moj icumɨgoyyaj jém pɨxiñt́am iga Pablo icujɨypa Dios. Jesɨc iccupɨcyaj, iyɨgayyaj tsaamɨ jém Pablo. Ijɨ̱syaj iga caaneum. Ijɨ̱cputyaj aŋsɨ̱cmɨ de jém attebet. ");
INSERT INTO poiNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Pero cuando icuyujcɨɨwiñ iŋtuuma̱cayaj jém Pablo, e̱ybɨc tsucum, tɨgɨy jém attebet. Jém tuŋgac ja̱ma put jém attebet con jém Bernabé, nɨcyaj jém attebet Derbe. ");
INSERT INTO poiNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ocmɨ cuando yaj iŋmat jém wɨbɨc aŋma̱t́i jém attebet Derbe, tsa̱m jáyaŋ tɨgɨyyaj iga icupɨcyajpa Cristo. Jesɨc se̱t jém attebet Listra, jém Iconio y jém Antioquía. ");
INSERT INTO poiNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Cuando nasyaj jém tuŋgac attebetyaj tsa̱m iyo̱xpátpa jém icupɨcneyajwɨɨp Cristo. Iŋquímpa iga odoy ichaguiñ jém Dios iŋma̱t́i. Iñɨ́mayyajpat́im iga tienes que tayaachwatta̱p y tacutɨtsta̱p iga tanúcpa ju̱t́ it́ Dios. ");
INSERT INTO poiNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Accámta̱ tu̱m aŋjagooyi cada ma̱stɨcjo̱m ju̱t́ aŋtuuma̱yajpa jém Dios ipɨxiñt́am. Jesɨc jém Pablo y Bernabé cuando yaj iwat oración y ayuno, icɨɨjuŋcot jém aŋjagooyiyaj jém tánO̱mi icɨɨjo̱m iga iwatyajiñ cuenta jém icupɨcneyajwɨɨp Cristo. ");
INSERT INTO poiNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ocmɨ nasyajpa jém naxyucmɨ de Pisidia, núcyaj jém naxyucmɨ de Panfilia. ");
INSERT INTO poiNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Iŋmatyaj jém Dios iŋma̱t́i jém attebet Perge. Ocmɨ nɨcyaj hasta tu̱m attebet iñɨ̱yi Atalia. ");
INSERT INTO poiNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Jemum tɨgɨyyaj tu̱m barcojo̱m. Se̱t e̱ybɨc jém Antioquía, jém attebet ju̱t́ tsucumyaj, ju̱t́ jém tantɨ̱wɨtam icɨɨjuŋcotyaj jém Dios icɨɨjo̱m iga iwatpa cuenta con jém wɨbɨc tóyooyi cuando nɨcpa iwat jém yo̱xacuy jém sɨɨppɨc cuyajneum. ");
INSERT INTO poiNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Cuando núcyaj jém Antioquía, iŋtuuma̱watyaj jém Dios ipɨxiñt́am. Jesɨc jém Pablo y Bernabé iŋmadayyaj it́u̱mpɨy juuts iwadáy Dios. Iŋmadáyt́im it́u̱mpɨy jutsa̱p íŋáyáy jém puerta jém tánO̱mi para jém tuŋgac pɨxiñt́am jém d́apɨc je de Israel iga wɨa̱iñt́im icupɨcyaj. ");
INSERT INTO poiNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Jesɨc jeeyaj tsɨ́yyaj wa̱t́i ja̱ma con jém tantɨ̱wɨtam. ");
INSERT INTO poiNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Jesɨc algunos pɨxiñt́am, jém it́yajwɨɨp id́ɨc Judea, miñyaj Antioquía. Moj iŋquejayyaj jém tantɨ̱wɨtam iga d́a tacɨacputta̱p siiga d́a tampɨctsoŋpa jém marca de circuncisión jém ictsucumnewɨɨp jém Moisés. ");
INSERT INTO poiNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Jesɨc jém Pablo y Bernabé áŋa̱yaj con jém inimiññeyajwɨɨp jém mɨgooyi. Jesɨc cupiŋta̱ jém Pablo y Bernabé con tuŋgac más pɨxiñt́am iga nɨcpa iwɨ̱tsac jém asunto Jerusalén con jém apóstolyaj y jém wɨd́ayt́am, jém iŋjacpáppɨc jém Dios ipɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Jesɨc jém Dios ipɨxiñt́am jém it́yajwɨɨp Antioquía oy ijagaŋtsacyaj tuŋjo̱m. Ocmɨ nasyaj jém Fenicia y Samaria. Iŋmadayyaj jutsa̱ micupɨcyaj jém tuŋgac pɨxiñt́am jém d́apɨc je de Israel. Agui maymayyaj it́u̱mpɨy jém tantɨ̱wɨtam cuando imatoŋyaj. ");
INSERT INTO poiNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Cuando núcyaj Jerusalén jém Pablo y Bernabé, iwɨ̱pɨctsoŋyaj jém Dios ipɨxiñt́am. Iwɨ̱pɨctsoŋyajt́im jém apóstolyaj y jém wɨd́ayt́am. Moj iŋmadayyaj t́it́am iwadáy Dios con jeeyaj. ");
INSERT INTO poiNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Pero jemum it́t́im jute̱n jém fariseoyaj, icupɨcyajt́im jém Jesucristo iŋquímayooyi. Te̱ñchucum, nɨmyajpa: —Jém tuŋgac pɨxiñt́am jém d́apɨc je de Israel tienes que iwatpat́im jém marca de circuncisión cuando mojpa icupɨc Jesús. Tienes que iwatpat́im juuts nɨmpa jém Moisés iŋquímayooyi. ");
INSERT INTO poiNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ocmɨ aŋtuuma̱yaj jém apóstolyaj con jém wɨd́ayt́am. Moj ijɨ̱syaj siiga wɨ̱ iga taŋwatpa juuts nɨmpa jém fariseoyaj. ");
INSERT INTO poiNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Cuando yajum áŋa̱jiyaj, te̱ñchucum jém Peto. Iñɨ́máy: —Mantɨ̱wɨtam, micht́am iñjo̱doŋ iga d́a más pecam Dios acupiŋ de mimicht́ámaŋjo̱m iga anaŋmadáypa jém wɨbɨc aŋma̱t́i jém tuŋgac pɨxiñt́am jém d́apɨc je de Israel iga icupɨcyajiñ mex jeeyaj. ");
INSERT INTO poiNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Dios ijo̱doŋ t́i tanjɨ̱spa tána̱namaŋjo̱m. Taŋquejáy iga jém tuŋgac pɨxiñt́am nu̱ma icupɨcyajpat́im Cristo porque chiiyajta̱ jém Dios iA̱nama juutst́im taɨcht́am. ");
INSERT INTO poiNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Dios d́a iñe̱jaixpa jém pɨxiñt́am. Iixpa jém tuŋgac pɨxiñt́am jext́im juuts taɨcht́am. Dios iccuáyáy ia̱nama porque icupɨcpat́im Cristo mex jeeyaj. ");
INSERT INTO poiNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Jesɨc t́iiga d́a iŋcupɨcpa t́i iwatpa Dios. ¿T́iiga inictsɨɨma̱p jém tantɨ̱wɨtam con jém wiñɨcpɨc aŋquímayooyi? Porque ni taɨcht́am ni jém wiñɨcpɨc tanja̱tuŋwe̱wetam d́a wɨa̱p tanaccupac juuts nɨmpa jém wiñɨcpɨc aŋquímayooyi. ");
INSERT INTO poiNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Pero taɨcht́am taŋcupɨcpa iga Jesucristo tacɨacputpa porque tsa̱m tatoypa. Tachiiba jém tóyooyi juuts tu̱m xaja. Je̱mpɨct́im iwadáypa Dios jém tuŋgac pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Jesɨc it́u̱mpɨy jém pɨxiñt́am ju̱t́ aŋtuuma̱neyaj d́am jɨyyaj. Moj icumatoŋyaj iganam iŋmatpa jém Pablo y Bernabé jutsa̱ miyo̱xpát Dios iga iwat jém milagro y seña entre jém tuŋgac pɨxiñt́am, jém d́apɨc je de Israel. ");
INSERT INTO poiNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Cuando yaj nɨ̱miyaj, te̱ñchucum jém Jacobo, iñɨ́máy jém pɨxiñt́am: —Mantɨ̱wɨtam, amatoŋtaamɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Taŋmadáy jém Peto jutsa̱ miwɨ̱wadáy Dios jém tuŋgac pɨxiñt́am cuando moj ipɨctsoŋyaj jém Dios iŋma̱t́i. Cupiŋyajta̱t́im jute̱n de jeeyaj iga tsɨ́yyajpa juuts jém Dios ipɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Cuando iwat je̱mpɨc, ictsɨ́ypa jém aŋma̱t́i juuts ijaychacne jém wiñɨcpɨc aŋmat́cɨɨwiñ. Nɨmpa yɨɨmpɨc: ");
INSERT INTO poiNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Jesɨc yaj iñasca je̱mpɨc, amiñgacpa e̱ybɨc iga aŋwɨ̱tsagáypa jém David it́ɨc jém actɨŋnewɨɨp. Aŋwatse̱tpa jo̱mipɨc jém mɨsa̱newɨɨp, e̱ybɨc anacte̱ñpa. ");
INSERT INTO poiNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Aŋwatpa je̱mpɨc iga jém tuŋgac pɨxiñt́am imétsyajiñ Dios. Jesɨc it́u̱mpɨy jém cupiŋneta̱wɨɨp, jém d́apɨc de Israel, tsɨ́yyaj juuts ɨch ampɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Nɨmpa jém tanJa̱tuŋ Dios: Tsa̱m wiñɨgam jo̱dóŋa̱ta̱ iga naspa je̱mpɨc. ");
INSERT INTO poiNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Nɨmpat́im Jacobo: —Jeeyucmɨ ɨch anɨmpa wɨ̱ iga d́a tammoogɨ́ypa jém tuŋgac pɨxiñt́am jém d́apɨc je de Israel cuando ichacpa jém wiñɨcpɨc jɨ̱xi iga icupɨcyajiñ Dios. ");
INSERT INTO poiNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Wɨ̱ iga tanjáyáypa tu̱m to̱to iga ichaguiñ iga icupɨcpa jém watnas, iga odoy pejóyiñ, odoy icúd́iñ jém ani̱mat jém pencanewɨɨp ni jém jupcanewɨɨp y odoy icúd́iñ jém nɨɨpiñ. ");
INSERT INTO poiNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Dende wiñɨgam it́ jém iŋmatpáppɨc jém Moisés iŋquímayooyi cada tɨgaŋjoj. Mayt́a̱p jém aŋma̱t́i cada jejcuy ja̱ma jém sinagoga. ");
INSERT INTO poiNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Jesɨc jém apóstolyaj con it́u̱mpɨy de jém Dios ipɨxiñt́am con jém wɨd́ayt́am ijɨ̱syaj iga icupiŋyajpa wɨste̱n pɨ̱xiñ de jeeyaj iga icutsatpa Antioquía con jém Pablo y Bernabé. Jesɨc cupiŋta̱ jém Judas iñɨ̱yit́im Barsabás y tu̱m pɨ̱xiñ iñɨ̱yi Silas. Yɨ́p wɨste̱n tsɨ́y iga jém Dios ipɨxiñt́am iŋjagooyiyaj. ");
INSERT INTO poiNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Icutsat tu̱m to̱to con jeeyaj. Nɨmpa: “Aɨcht́am aapóstoltam, con jém wɨd́ayt́am, con it́u̱mpɨy jém tantɨ̱wɨtam jém it́yajwɨɨp yɨɨm, maŋcutsadáypa wa̱t́idios, mantɨ̱wɨtam, jém miit́t́aŋwɨɨp jém attebet Antioquía y jém naxyucmɨ de Siria y Cilicia. ");
INSERT INTO poiNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Anjo̱doŋa̱neta iga oyñe yɨɨmpɨc pɨxiñt́am, pero aɨcht́am d́a aŋcutsatneta. Yɨ́pyaj mimɨgóyáypa, micujíñáypa con jém iŋma̱t́i. Mipɨɨmɨ́ypa iga iŋwad́iñ jém marca de circuncisión y iga odoy iñchaguiñ jém Moisés iŋquímayooyi. ");
INSERT INTO poiNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Jeeyucmɨ aŋcumunjɨ̱sta iga aŋcupiŋpa wɨste̱n pɨ̱xiñ aɨcht́ampɨc iga nɨguiñ miámta con jém Bernabé y jém Pablo jém tantoypáppɨc. ");
INSERT INTO poiNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Yɨ́p wɨste̱n pɨ̱xiñ wat́cɨy accaata̱tooba jém tánO̱mi Jesucristo icuyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Jeeyucmɨ maŋcutsadáypa jém Judas y Silas iga nɨcpa miŋmadáy iyaac it́u̱mpɨy juuts manjáyáypa yɨ́p to̱toyucmɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Dios iA̱nama d́a iwɨ̱aŋja̱m iga manactsɨɨma̱p con jém mɨjpɨc aŋquímayooyi y aɨcht́am anjɨ̱stámpat́im je̱mpɨc. Manaŋmadáypa t́i ixunpa Dios iga taŋwatpa: ");
INSERT INTO poiNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Odoy cuutɨ jém ani̱mat ima̱yi, jém accaaneta̱wɨɨp jém watnas iwiñjo̱m, jém watneta̱wɨɨp sacrificio. Odoy cuutɨ jém nɨɨpiñ ni jém ani̱mat jém pencanewɨɨp. Odoy pejooyɨ. Odoy tsɨ̱cɨ tuŋgac yo̱mo. Siiga seguido iŋwatpa juuts nɨmpa yɨ́p aŋquímayooyi, jesɨc iŋwɨ̱watpa. Jesáŋam manjáyáy.” ");
INSERT INTO poiNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Jesɨc yaj iŋquímyaj, mojum nɨquiyaj jém cuatro pɨxiñt́am jém attebet Antioquía. Cuando núcyaj, iŋtuuma̱watyaj it́u̱mpɨy jém Dios ipɨxiñt́am. Icɨɨjuŋcodayyaj jém to̱to. ");
INSERT INTO poiNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Cuando yaj imayyaj jém to̱to, jém tantɨ̱wɨtam agui maymayyaj porque tsa̱m iyo̱xpát jém to̱to. ");
INSERT INTO poiNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Jém Judas y Silas profetayaj, chiiyajta̱ jém jɨ̱xi iga wɨa̱p iŋmat jém Dios iŋma̱t́i. Tsa̱m iŋmadayyajpa jém pɨxiñt́am t́i ixunpa Dios. Tsa̱m iyo̱xpátpa iga iwɨ̱cupɨcyajpa y d́a ichacyajpa jém wɨbɨc aŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Jesɨc jáy wagai̱t́iyaj. Cuando yaj iwat iyo̱xacuy, jém tantɨ̱wɨtam iŋquímyaj iga se̱tpa e̱ybɨc ju̱t́t́im tsucumyaj. ");
INSERT INTO poiNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Pero jém Silas ijɨ̱s iga tsɨ́ypa Antioquía. ");
INSERT INTO poiNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Tsɨ́yyajt́im jém Pablo y Bernabé. D́a ichacyaj iga najɨ́yóypa y iŋquejáypa jém pɨxiñt́am jém tánO̱mi iŋmadayooyi. Jemum tsɨ́yyajt́im wa̱t́i jém tantɨ̱wɨtam. ");
INSERT INTO poiNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","D́a wa̱t́ña ja̱ma jáyi̱t́iyaj, jém Pablo iñɨ́máy jém Bernabé: —Nɨcpa tanjóyáy e̱ybɨc jém tantɨ̱wɨtam it́u̱mpɨy jém attebet ju̱t́ moj tanaŋmat jém tánO̱mi iŋmadayooyi iga tanjo̱dóŋa̱p jutsa̱ne ii̱t́iyaj. ");
INSERT INTO poiNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Jém Bernabé iwagananɨctoobat́im jém Xiwan iñɨ̱yit́im Marcos. ");
INSERT INTO poiNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pero jém Pablo d́a iwɨ̱aŋja̱m iga iwagananɨcpa jém Xiwan porque ichagaŋput jém yo̱xacuy jém attebet Panfilia. ");
INSERT INTO poiNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ocmɨ jém Pablo áŋa̱yaj con jém Bernabé. Mex jeegact́i natsagaŋputyajta̱. Jém Bernabé ininɨc jém Marcos. Tɨgɨy barcojo̱m, waganɨcyaj jém isla de Chipre. ");
INSERT INTO poiNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Jesɨc jém Pablo icupiŋ jém Silas. Nɨcyaj. Jesɨc jém tantɨ̱wɨtam iŋquímyaj, iŋwejpátyaj tanJa̱tuŋ Dios iga iyo̱xpád́iñ. ");
INSERT INTO poiNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Nasyajpa jém naxyucmɨ de Siria y Cilicia. Ju̱t́ quej nɨcpa iyo̱xpát jém Dios ipɨxiñt́am iga más wɨa̱iñ iwatyaj juuts ixunpa Dios. ");
INSERT INTO poiNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Jesɨc jém Pablo y Silas nɨcyaj jém attebet Derbe y Listra. Jemum ipát tu̱m pɨ̱xiñ jém icupɨcnewɨɨp Cristo iñɨ̱yi Timoteo. Jém ia̱pa tu̱m Israelpɨc yo̱mo, tsa̱m icupɨcpat́im Cristo. Jém ija̱tuŋ tu̱m griegopɨc pɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Jém tantɨ̱wɨtam jém it́yajwɨɨp Listra y jém Iconio tsa̱m iwɨ̱ixyajpa jém Timoteo. ");
INSERT INTO poiNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Jém Pablo iwagananɨctooba jém Timoteo. Jeeyucmɨ iwadáyt́im jém marca de circuncisión iga odoy ijóyixiñ jém judíos ju̱t́ nɨcyajpa jém Pablo. Porque ijo̱doŋyaj iga jém ija̱tuŋ griegopɨc pɨ̱xiñ. ");
INSERT INTO poiNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Jesɨc nɨcyaj, nasyajpa wa̱t́i jém attebet. Iŋquejayyajpa t́i wɨa̱p iwatyaj juuts ipɨɨmɨ́y jém apóstolyaj y jém wɨd́ayt́am jém it́yajwɨɨp Jerusalén. ");
INSERT INTO poiNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Jesɨc ju̱t́ aŋtuuma̱yajpa Dios ipɨxiñt́am mást́im icupɨcyajpa. Cada ja̱ma más jáyaŋa̱p. ");
INSERT INTO poiNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Jém Dios iA̱nama d́a ijɨ́gáy iga iŋmatpa jém Dios iŋma̱t́i jém naxyucmɨ de Asia. Jeeyucmɨ wid́aŋnasyaj jém naxyucmɨ de Frigia y Galacia. ");
INSERT INTO poiNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ocmɨ núcyaj ju̱t́ tsucum jém naxyucmɨ de Misia. De je̱m ijɨ̱syajpa iga tɨgɨypa jém naxyucmɨ de Bitinia. Pero Dios iA̱nama d́at́im ijɨ́gáy iga iŋmatyajpa jém Dios iŋma̱t́i je̱m. ");
INSERT INTO poiNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Jesɨc icuwid́ayyaj jém naxyucmɨ de Misia, nɨcyaj naxwiñ jém attebet Troas jém lamar aŋna̱ca. ");
INSERT INTO poiNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Jesɨc tsuucɨɨm jém Pablo iix tu̱m po̱ñ. Iix iga jemum te̱ñ tu̱m Macedoniapɨc pɨ̱xiñ. Icunucsáypa. Iñɨ́máy: —Na̱sɨ yɨɨm Macedonia, mi̱ñɨ ayo̱xpáttaamɨ. ");
INSERT INTO poiNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Mu iix jém po̱ñ, jicscɨy anawɨ̱tsactamta̱ iga anɨctámpa Macedonia. Anjo̱dóŋa̱ta iga nu̱ma aŋwejáy Dios iga nɨguiñ anaŋmat jém wɨbɨc aŋma̱t́i Macedonia. ");
INSERT INTO poiNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Atɨgɨyt́a barcojo̱m jém attebet Troas. Anu̱mnɨcta jém isla de Samotracia. Tuŋgagam ja̱ma anúcta jém attebet Neápolis. ");
INSERT INTO poiNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","De je̱m anɨcta hasta Filipos, tu̱m Romapɨc colonia. Je jém más mɨjpɨc attebet de jém parte de Macedonia. Jáy ai̱t́it́am jemum ju̱na ja̱ma. ");
INSERT INTO poiNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Tu̱m jejcuy ja̱ma aputta aŋsɨ̱cmɨ de jém attebet. Anɨcta tu̱m nɨ aŋna̱ca. Anúcta tu̱m lugar ju̱t́ siempre iŋwejpátyajpa Dios. Aco̱ñt́a, moj anaŋmadayyaj jém Dios iŋma̱t́i jém yo̱mtam jém aŋtuuma̱neyajwɨɨp je̱m. ");
INSERT INTO poiNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Tu̱m de jeeyaj iñɨ̱yi Lidia. Jém yo̱mo tsucum jém attebet Tiatira. Imáypa jém wɨbɨc puctu̱cu jém color morado. Tsa̱m ijɨ̱spa Dios. Iwɨ̱matoŋpa jém Dios iŋma̱t́i. Jém tánO̱mi íŋáyáy jém yo̱mo ia̱nama iga iwadáyiñ caso t́i nɨmpa jém Pablo. ");
INSERT INTO poiNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Jesɨc acchiŋta̱ jém Lidia. Acchiŋyajta̱t́im it́u̱mpɨy jém it́yajwɨɨp it́ɨccɨɨm. Ocmɨ icunucsáy jém Pablo. Iñɨ́máy: —Siiga iñjɨ̱spa iga aŋwɨ̱cupɨc jém tánO̱mi, mi̱ñɨ michɨɨyi ɨch antɨccɨɨm. Jesɨc aŋcupɨcta, atsɨ́yt́a. ");
INSERT INTO poiNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Jesɨc tuŋgagam ja̱ma anɨctámpa e̱ybɨc jém lugar ju̱t́ iwatyajpa oración. Tuŋjo̱m ampát tu̱m wo̱ñi juyñeta̱, tu̱m esclava. Iniit́ tu̱m mal espíritu. Jém wo̱ñi tu̱m sabio. Imétspa suerte. Tsa̱m iwɨ̱coñwɨ́ypa tumiñ para jém io̱mi jém ijuyñewɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Yɨ́p wo̱ñi moj atúŋɨyt́a aɨcht́am. Pɨ̱mi jɨypa jém wo̱ñi, nɨmpa: —Yɨ́p pɨxiñt́am icuyo̱xa̱p jém yucmɨpɨc Dios. Iŋmatyajpa jutsa̱p tacɨacput Dios. ");
INSERT INTO poiNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Je̱mpam iwat jém wo̱ñi wa̱t́ña ja̱ma. Ocmɨ jém Pablo ijóyca. Iámseedáy, iñɨ́máy jém mal espíritu: —Jém Jesucristo iñɨyi̱mɨ mannɨ́máypa, pu̱tɨ yɨ́p wo̱ñi ia̱namaŋjo̱m. Jeet́i rato jém mal espíritu ichacum jém wo̱ñi. ");
INSERT INTO poiNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Pero mu iix jém wo̱ñi io̱mi iga d́a más icoñwɨ́ypa tumiñ, jesɨc matsta̱ jém Pablo y Silas. Nanɨcta̱ jém aŋjagooyicɨɨm jém plaza aŋna̱ca. ");
INSERT INTO poiNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Icɨɨjuŋcot jém juez icɨɨjo̱m. Nɨmpa jém wo̱ñi io̱mi: —Yɨ́pyaj judíos tsa̱m iccujíñáypa jém pɨxiñt́am jém it́yajwɨɨp tánattebet. ");
INSERT INTO poiNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Iŋquejpa tu̱m aŋquímayooyi jém d́apɨc wɨa̱p taŋcuyujcata porque taɨcht́am taRomapɨc tapɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ocmɨ tsucumyaj jém pɨxiñt́am iga iquejajwadayyajpa jém Pablo. Jém juez ipɨɨmɨ́y iga ichodayyajiñ iyoot́i iga cótsta̱iñ con waycuy. ");
INSERT INTO poiNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Pɨ̱mi icótsyaj, ocmɨ icotyaj cárcel. Pɨɨmɨyt́a̱ jém carcelero iga iwɨ̱wad́iñ cuenta. ");
INSERT INTO poiNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Cuando ipɨctsoŋ jém orde, icot jém Pablo y Silas jém más jojmɨpɨc cuarto de jém cárcel. Codayt́a̱ ipuy tu̱m cuycotcuyjo̱m, acmatsta̱ tu̱m cadena. ");
INSERT INTO poiNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Cuando núc cugaptsu, jém Pablo y Silas iwatyajpa oración; iwánayyajpa Dios tu̱m himno. Jém tuŋgac preso imatoŋyajpa. ");
INSERT INTO poiNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Jeet́i rato tsa̱m pɨ̱mi yɨɨspa jém nas. Tsa̱m pɨ̱mi ixics jém cárcel. Jeet́i rato áŋáy it́u̱mpɨy jém ipuerta. Áŋáyyaj it́u̱mpɨy jém cuycotcuy icadena, cutsɨgayyajta̱ it́u̱mpɨy jém preso. ");
INSERT INTO poiNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Jesɨgam yus jém carcelero. Iix iga áŋáyñeum it́u̱mpɨy jém cárcel ipuerta. It́op imachi̱t́i iga nacaata̱p iyaac porque ijɨ̱spa iga cupóyayñeyajum it́u̱mpɨy jém preso. ");
INSERT INTO poiNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pero jém Pablo pɨ̱mi ijɨ́yáy. Iñɨ́máy: —Odoy wa̱tɨ je̱mpɨc. D́a apoyñeta, antu̱mpɨyt́am ait́t́a yɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Jesɨc jém carcelero iwác juctɨ. Tɨgɨy poyi̱mɨ jém cárcel. Pɨ̱mi cuetsáypa, tsa̱m cɨ̱ŋne. Ocmɨ co̱ste̱ññeactɨŋ jém Pablo y Silas iwiñjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ocmɨ it́op jém Pablo y Silas. Icwác. Iñɨ́máy: —Mipɨxiñt́am, ¿t́i wɨa̱p aŋwat iga acɨacputta̱p? ");
INSERT INTO poiNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Jesɨc jém Pablo y Silas iñɨ́máy: —Cupɨ̱cɨ tánO̱mi Jesucristo. Jesɨc micɨacputpa, cɨacputta̱pt́im it́u̱mpɨy jém it́yajwɨɨp iñt́ɨccɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Jesɨc moj iŋmadáy Dios iŋma̱t́i jém carcelero con it́u̱mpɨy jém it́yajwɨɨp it́ɨccɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Jeet́im hora, tsuucɨɨm, d́anam cuquejne, jém carcelero icheáy jém Pablo y Silas icoowa̱ji. Jesɨc jeet́i rato acchiŋyajta̱ jém pɨ̱xiñ con it́u̱mpɨy jém it́yajwɨɨp it́ɨccɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ocmɨ ininɨc it́ɨccɨɨm jém Pablo y Silas iga acwícyajta̱p. Agui maymay jém pɨ̱xiñ con it́u̱mpɨy jém it́yajwɨɨp it́ɨccɨɨm porque icupɨcyaj Dios. ");
INSERT INTO poiNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Icuqueja̱ma jém juezyaj icutsatyaj jute̱n jém policía iga iñɨ́máyiñ jém carcelero iga icutsɨgáyiñ jém Pablo y Silas. ");
INSERT INTO poiNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Jesɨc ocmɨ jém iwatnewɨɨp cuenta jém cárcel iŋmadáypa jém Pablo: —Apɨɨmɨ́y jém juezyaj iga maŋcutsɨgáyiñ. Sɨɨp puttaamɨm. Chogoyñɨcsɨm. ");
INSERT INTO poiNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pero jém Pablo iñɨ́máy: —Aunque aɨcht́am aRomapɨc, acótstamta̱ jém pɨxiñt́am iwiñjo̱m ni d́a i̱ acɨɨpiŋ. Acotta̱ cárcel. ¿Que ijɨ̱syajpa iga sɨɨp ayamcutsɨgayyajt́ooba? D́a wɨa̱p. Más wɨ̱ iga miñyajiñ jeeyaj iga acutsɨgayyajpa iyaac. ");
INSERT INTO poiNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Jém policía nɨc iŋmadayyaj jém juezyaj. Jesɨc tsa̱m pɨ̱mi cɨ̱ŋyaj jeeyaj cuando imatoŋyaj iga Romapɨc pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Jesɨc miñyaj jém juezyaj iga iwágáypa perdón jém Pablo y Silas iga tsa̱m imalwadáy. Icunucsáy iga pud́iñ jém attebet. ");
INSERT INTO poiNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Cuando yajum pu̱t́i cárcel jém Pablo y Silas, nɨc jém Lidia it́ɨccɨɨm. Nɨc iámyaj jém tantɨ̱wɨtam. Iŋquímyaj t́i wɨa̱p iwatyaj. Ocmɨ nɨcyajum. ");
INSERT INTO poiNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Jesɨc jém Pablo y Silas nasyaj jém attebet de Anfípolis y Apolonia. Ocmɨ núcyaj jém attebet Tesalónica ju̱t́ it́ tu̱m jém judíos isinagoga. ");
INSERT INTO poiNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Juuts siempre jém Pablo tɨgɨypa ju̱t́ aŋtuuma̱neyaj. Tucunasemana iŋquejáypa Dios iŋma̱t́i cada jejcuyja̱ma. ");
INSERT INTO poiNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Iŋquejáy jém pɨxiñt́am ju̱t́ jayñeta̱ jém Dios iŋma̱t́i. Iŋmadáypa iga tienes que yaachwatta̱p jém Cristo y ocmɨ acpɨsta̱p. Iñɨ́máyt́im: —Yɨ́pt́im mismo Jesús sɨɨp manaŋmadáypa, je jém Cristo. ");
INSERT INTO poiNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Jesɨc algunos jém Israelpɨc pɨxiñt́am icupɨcyaj, iŋpɨtsyaj jém Pablo y Silas. Icupɨcyajt́im jáyaŋ jém griegopɨc pɨxiñt́am jém ijɨ̱syajpáppɨc Dios y wa̱t́i jém wɨ̱tampɨc yo̱mtam jém jɨ̱xiɨywɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ocmɨ jém judíos, jém d́apɨc icupɨcyajpa jém wɨbɨc aŋma̱t́i, tsa̱m na̱jajóypa. Aŋtuuma̱yaj con algunos jém malopɨc pɨxiñt́am jém d́apɨc yo̱xayajpa, jém wit́wid́oypáppɨc calle. Ictsucumyaj tu̱m mɨjpɨc bulla iga iccujíñáypa jém pɨxiñt́am. Iŋnácsayyaj jém Jasón it́ɨc. Imétstɨp jém Pablo y Silas iga it́opyajpa iga ininɨcyajpa jém pɨxiñt́am iwiñjo̱m. ");
INSERT INTO poiNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Pero cuando d́a ipát jém Pablo tɨcjo̱m, matsyajta̱ jém Jasón con algunos jém tantɨ̱wɨtam. Ijɨ̱cte̱ñyaj hasta jém aŋjagooyicɨɨm. Jém pɨxiñt́am pɨ̱mi aŋwejyajpa. Nɨmyajpa: —Yɨ́bam pɨxiñt́am iccujíñayñeyaj icuwɨ̱t́i yɨ́p naxyucmɨ. Sɨɨp núcneyajum yɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Yɨ́p Jasón ipɨctsoŋne it́ɨccɨɨm. It́u̱mpɨy de jeeyaj d́a iwatyajpa juuts nɨmpa jém Romapɨc aŋquímayooyi. Nɨmyajpat́im iga it́ tuŋgac rey, jém Jesús. ");
INSERT INTO poiNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Jesɨc jém pɨxiñt́am con jém aŋjagooyiyaj tsa̱m pɨ̱mi cujíñayyaj cuando imatoŋ t́i nɨmyajpa. ");
INSERT INTO poiNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Jesɨc jém Jasón con icompañeroyaj ichiiyaj tumiñ jém aŋjagooyi iga odoy más id́iñ jém bulla. Ocmɨ cutsɨgayt́a̱. ");
INSERT INTO poiNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Jesɨc jeet́i tsuu jém tantɨ̱wɨtam icutsatyaj jém Pablo y Silas iga nɨcyajiñ jém attebet Berea. Ocmɨ cuando núcyaj, tɨgɨyyaj jém judíos isinagoga. ");
INSERT INTO poiNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Pero jém Bereapɨc pɨxiñt́am más d́a maloyaj que jém it́yajwɨɨp jém attebet Tesalónica. Tsa̱m maymayyaj, iwɨ̱pɨctsoŋyaj jém Dios iŋma̱t́i. Cada ja̱ma icuyujcayajpa jém aŋma̱t́i jém jayñewɨɨp, icuámyajpa siiga nu̱ma jesaneum juuts iñɨ́máy jém Pablo. ");
INSERT INTO poiNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Jeeyucmɨ tsa̱m jáyaŋ de jeeyaj icupɨcyaj. Icupɨcyajt́im jáyaŋ jém griegopɨc yo̱mtam y pɨxiñt́am jém wɨ̱tampɨc. ");
INSERT INTO poiNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Pero jém judíos jém it́yajwɨɨp Tesalónica, cuando ijo̱dóŋa̱yaj iga jém Pablo iŋmatpa Dios iŋma̱t́i Berea, nɨcyaj jemɨc iga iccujíñayyajpat́im jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Jesɨc jém tantɨ̱wɨtam jém it́yajwɨɨp Berea jicscɨy icutsat jém Pablo jém lamar aŋna̱ca. Pero jém Silas y Timoteo tsɨ́yyaj jém attebet Berea. ");
INSERT INTO poiNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Jém iwagananɨcnewɨɨp jém Pablo ininɨcyaj hasta jém attebet Atenas. Cuando se̱tyaj, jém Pablo icutsadáy aŋma̱t́i jém Silas y Timoteo con jeeyaj. Iñɨ́máy iga: Jicscɨy mi̱ñɨ, d́a mijáypa. ");
INSERT INTO poiNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Iganam jém Pablo iŋjócpa jém Silas y Timoteo, iix iga jém it́yajwɨɨp jém attebet Atenas agui icupɨcyajpa jém watnas. Tsa̱m jáyaŋ it́yaj. Jesɨc jóyñe jém Pablo ia̱namajo̱m. ");
INSERT INTO poiNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Jeeyucmɨ aŋmatyajpa jém Pablo con jém it́yajwɨɨp jém sinagoga, jém judíos, con jém tuŋgac pɨxiñt́am jém ijɨ̱syajpáppɨc Dios. Cada ja̱ma aŋmatyajpat́im jém Pablo con jém pɨxiñt́am jém ipátneyajwɨɨp plaza. ");
INSERT INTO poiNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Jemum ipátyaj algunos jém pɨxiñt́am jém icuyujcanewɨɨp jém epicúreospɨc iŋquímayooyi con jém icuyujcanewɨɨp jém estoicospɨc iŋquímayooyi. Jeeyaj moj aŋma̱t́iyaj con jém Pablo. Nɨmyajpa: —¿T́i nɨmtooba yɨ́p pɨ̱xiñ tsa̱m aŋmattero? Tuŋgac jém pɨxiñt́am nɨmyajpa: —Quénam tu̱m najɨ́yoypaap de tuŋgac dios. Nɨmyajpa je̱mpɨc porque jém Pablo iŋmatpa jém Cristo iŋquímayooyi iga pɨs jém Jesús de ju̱t́ it́ jém caaneyajwɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ocmɨ jém pɨxiñt́am ininɨcyaj jém Pablo tu̱m lugar iñɨ̱yi Areópago ju̱t́ siempre aŋtuuma̱yajpa iga accuyujóypa. Jém pɨxiñt́am icwácyaj jém Pablo. Iñɨ́máy: —Aɨcht́am anjo̱dóŋa̱tooba t́iapaap yɨ́p jo̱mipɨc aŋquímayooyi jém michpɨc inimiñ. ");
INSERT INTO poiNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Mich anaŋmadáypa tuŋgac jɨ̱xi jém d́apɨc queman ammatoŋta. Anjo̱dóŋa̱tooba t́i nɨmtooba. ");
INSERT INTO poiNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Porque it́u̱mpɨy jém Atenaspɨc pɨxiñt́am con jém juumɨpɨc pɨxiñt́am jém it́yajwɨɨp je̱m, tsa̱m iwɨ̱aŋja̱myaj jém jo̱mipɨc jɨ̱xi iga imatoŋyajpa y iga iŋmatyajpa. ");
INSERT INTO poiNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Ocmɨ jém Pablo te̱ñchucum jém pɨxiñt́am aŋcucmɨ jém it́yajwɨɨp jém Areópago. Iñɨ́máy: —Mimicht́am, miit́t́aŋwɨɨp Atenas. Ánix iga tsa̱m jáyaŋ diosyaj iñjɨ̱stámpa. ");
INSERT INTO poiNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Cuando anas ju̱t́ it́ wa̱t́i jém iñdios, ampát tu̱m altar ju̱t́ jayñeta̱ yɨ́p aŋma̱t́i. Nɨmpa jém letra: “Jém dios jém d́apɨc i̱ iixpɨcpa.” Sɨɨp manaŋmadáypa de jém Dios, jém d́apɨc íñixpɨctámpa mimicht́am. ");
INSERT INTO poiNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","’Yɨ́bam Dios iwat jém nas con it́u̱mpɨy jém it́yajwɨɨp yɨ́p naxyucmɨ. Imɨɨchi jém sɨŋ y jém nas. D́a sɨɨba jém ma̱stɨcjo̱m jém iwatnewɨɨp jém pɨxiñt́am. ");
INSERT INTO poiNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Jém pɨxiñt́am d́a wɨa̱p iyo̱xpátyaj yɨ́p Dios iga ichiiba t́it́am it́ogóyáy. Porque je iniit́ it́u̱mpɨy cosa. Tachiiba tamvida tantu̱mpɨyt́am. Tachiibat́im jém sa̱wa iga tasa̱upɨcpa. Tachiiba it́u̱mpɨy cosa. ");
INSERT INTO poiNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","’De tu̱m pɨ̱xiñ ictsucum iga it́yaj it́u̱mpɨy jém naciónyaj jém it́yajwɨɨp icuwɨ̱t́i de yɨ́p naxyucmɨ. Ijɨ̱spa ju̱t́ it́pa jém naciónyaj y jutsaŋ it́yaj. ");
INSERT INTO poiNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Dios iwadáypa je̱mpɨc porque ixunpa iga icuámiñ jém pɨxiñt́am iga wɨa̱iñ ipát. Nu̱ma Dios d́a juumɨ it́ con taɨcht́am. ");
INSERT INTO poiNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Porque yɨ́p naxyucmɨ taŋwaganait́pa Dios. Je tachiiba tamvida y tampɨ̱mi. Tu̱m de mimicht́am jém iniŋmat́cɨɨwiñ nɨmpa iga: “Taɨcht́am Dios tama̱nɨctam.” ");
INSERT INTO poiNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Siiga Dios tama̱nɨctam, d́a wɨa̱p tanjɨ̱sta iga tanJa̱tuŋ Dios jex juuts tu̱m watnas jém watneta̱wɨɨp de oro, plata o tsa, jém ijɨ̱xquímpáppɨc jém pɨxiñt́am iga iwatpa. ");
INSERT INTO poiNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Dios d́a ijɨ̱sáy it́áŋca jém wiñɨcpɨc pɨxiñt́am porque jeeyaj d́a ijo̱doŋ t́i wɨ̱ taŋwat. Pero sɨɨp Dios ipɨɨmɨ́y it́u̱mpɨy jém pɨxiñt́am icuwɨ̱t́i de yɨ́p naxyucmɨ iga icucacyajiñ ijɨ̱xi. ");
INSERT INTO poiNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Porque Dios ichac tu̱m ja̱ma iga icɨɨpiŋpa it́u̱mpɨy jém pɨxiñt́am, jém it́yajwɨɨp yɨ́p mundo. Iwɨ̱cɨɨpiŋpa con tu̱m pɨ̱xiñ jém iccámnewɨɨp juuts juez. Taŋquejáy tantu̱mpɨyt́am iga nu̱ma iwatpa je̱mpɨc cuando pɨs yɨ́p pɨ̱xiñ de ju̱t́ it́ jém caaneyajwɨɨp. ");
INSERT INTO poiNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Jesɨc cuando imatoŋyaj jeeyaj iga pɨs tu̱m pɨ̱xiñ caanewɨɨp, algunos agui ixiccayajpa. Pero jém tuŋgac nɨmyajpa: —Tuŋgac ja̱ma ammatoŋtooba e̱ybɨc t́i miñɨmpa. ");
INSERT INTO poiNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Jesɨc put jém Pablo ju̱t́ aŋtuuma̱neyaj. Nɨc. ");
INSERT INTO poiNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Pero algunos jém pɨxiñt́am nɨc it́úŋɨ́y jém Pablo. Icupɨct́im jém Cristo iŋquímayooyi. It́úŋɨ́y jém Dionisio tu̱m Areópagopɨc pɨ̱xiñ, y tu̱m yo̱mo iñɨ̱yi Dámaris con tuŋgac más. ");
INSERT INTO poiNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ocmɨ jém Pablo put jém attebet Atenas. Nɨc jém attebet Corinto. ");
INSERT INTO poiNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Jemum ipát tu̱m judío iñɨ̱yi Aquila. Nay jém attebet Ponto. Yaguiñ miñ de jém naxyucmɨ de Italia. Iwaganamiñ iwɨcho̱mo Priscila. Putyaj jém naxyucmɨ de Italia porque jém Romapɨc aŋjagooyi jém Claudio ipɨɨmɨ́y it́u̱mpɨy jém Israelpɨc pɨxiñt́am iga pud́iñ jém attebet Roma. Jesɨc jém Pablo nɨc ijooyáy jém Aquila y Priscila. ");
INSERT INTO poiNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Jeet́im yo̱xacuy iwatyajpa juuts iwatpa jém Pablo. Jeeyucmɨ nɨcpa iwaganait́yaj. Wagayo̱xayajpa. Iwatyajpa jém puctuctɨc. ");
INSERT INTO poiNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Cada jejcuy ja̱ma jém Pablo nɨcpa iŋquejayyaj jém aŋtuuma̱neyajwɨɨp jém sinagoga. Iccupɨcyaj jém judíos con jém tuŋgac pɨxiñt́am jém d́apɨc je de Israel. ");
INSERT INTO poiNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Mu ixe̱tyaj jém Silas y Timoteo de jém Macedonia jém Pablo iŋmadáypa jém judíos con it́u̱mpɨy ijɨ̱xi iga Jesús je jém Cristo. ");
INSERT INTO poiNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Pero jeeyaj tsa̱m ijóyixyajpa jém Pablo. Tsa̱m imalmalnɨ́mayyaj. Jesɨc Pablo icuxicsáy iyoot́i juuts tu̱m seña. Iñɨ́máy: —Micht́am iniit́ la culpa siiga micaaba y d́a impɨctsoŋpa jém vida jém d́apɨc cuyajpa. Ɨch d́a anai̱ la culpa. Dende sɨɨp nɨcpa anaŋmadáy jém tuŋgac pɨxiñt́am jém d́apɨc je de Israel. ");
INSERT INTO poiNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Jesɨc put jém sinagoga, nɨc tu̱m pɨ̱xiñ it́ɨccɨɨm iñɨ̱yi Justo. Jém sinagoga aŋna̱ca it́ jém it́ɨc. Yɨ́p pɨ̱xiñ tsa̱m ijɨ̱spa Dios. ");
INSERT INTO poiNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Jém sinagoga iŋjagooyi iñɨ̱yi Crispo. Icupɨct́im jém tánO̱mi con it́u̱mpɨy jém it́yajwɨɨp it́ɨccɨɨm. Jesɨc tsa̱m jáyaŋ jém Corintopɨc pɨxiñt́am mu imatoŋyaj t́i nɨmpa jém Pablo, icupɨcyajt́im jém Cristo y acchiŋyajta̱. ");
INSERT INTO poiNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Jesɨc tu̱m tsuu jém Pablo iix tu̱m po̱ñ. Jém tánO̱mi iñɨ́máy jém Pablo: —Odoy cɨ̱ŋɨ. Seguido aŋma̱tɨ ɨch anaŋma̱t́i. Odoy tsa̱cɨ iga iniŋmatpa. ");
INSERT INTO poiNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Ɨch maŋwaganait́ mimich jeeyucmɨ d́a i̱ wɨa̱p mimalwadáy. Tsa̱m jáyaŋ ampɨxiñt́am anait́ yɨ́p attebet. ");
INSERT INTO poiNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Jesɨc jemɨgam tsɨ́y jém Pablo tu̱m a̱mt́ɨy y medio jém attebet Corinto. Iŋquejáypa jém pɨxiñt́am jém Dios iŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Jém tiempo jém gobernador Galión iŋjacpa jém naxyucmɨ de Acaya. Jesɨc jém judíos aŋtuuma̱yaj iga imatsyajpa jém Pablo. Ocmɨ nanɨcta̱ jém aŋjagooyicɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Iñɨ́mayyaj jém gobernador: —Yɨ́p pɨ̱xiñ iŋquejáy jém pɨxiñt́am iga ijɨ̱syajiñ Dios con tuŋgac aŋquímayooyi jém d́apɨc jex juuts aɨcht́am anaŋquímayooyi. ");
INSERT INTO poiNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Jesɨc jɨyt́ooba id́ɨc Pablo cuando jém Galión iñɨ́máy jém Israelpɨc pɨxiñt́am: —MiIsraelpɨc mipɨxiñt́am, siiga tsa̱m mɨjpɨc táŋca iwat yɨ́p pɨ̱xiñ o siiga accaoyñe, jesɨc mammatóŋáypa t́i miñɨmpa. ");
INSERT INTO poiNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Pero siiga nada más iníŋa̱catámpa micht́am iniŋmadayooyi y jém iniŋquímayooyi y jém iñDios iñɨ̱yi, jesɨc wɨ̱tsactaamɨ iñyaac. D́a aŋcɨɨpiŋtooba jexpɨc cosa. ");
INSERT INTO poiNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Jesɨc topyajta̱ jém aŋjagooyicɨɨm. ");
INSERT INTO poiNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Cuando putyaj, jesɨc jém griegopɨc pɨxiñt́am imatsyaj jém Sóstenes jém sinagoga iŋjagooyi, icótsyaj jém gobernador iwiñjo̱m. Pero jém Galión d́a iwadáy caso. ");
INSERT INTO poiNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Jemum tsɨ́y jém Pablo jáyaŋ tiempo. Ocmɨ iŋquímyaj jém tantɨ̱wɨtam, tɨgɨypa barcojo̱m con jém Priscila y Aquila iga nɨcyajpa jém naxyucmɨ de Siria, jém attebet Cencrea. Antes que tɨgɨypa jém barcojo̱m, icujeebáy ico̱bac juuts tu̱m seña iga iccupacpa juuts ijɨycámayñe Dios. ");
INSERT INTO poiNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ocmɨ núcyaj jém attebet Efeso. Jemum ichacyaj jém Priscila y Aquila. Jesɨc tɨgɨy jém sinagoga jém Pablo iga iŋquejáypa Dios iŋma̱t́i jém judíos porque jemum aŋtuuma̱neyaj. ");
INSERT INTO poiNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Jém pɨxiñt́am icunucsayyaj jém Pablo iga tsɨ́yiñ más jáyaŋ tiempo con jeeyaj, pero Pablo d́a ijɨ́c. ");
INSERT INTO poiNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Cuando nɨctoobam jém Pablo, iŋquím jém pɨxiñt́am. Iñɨ́máy: —Wɨ̱ iga anɨcpa Jerusalén iga anacnaspa jém sɨŋ jém miñpáppɨc. Pero e̱ybɨc miñpa mánámta siiga Dios iwɨ̱aŋja̱m. Ocmɨ tɨgɨy barcojo̱m jém attebet Efeso. Nɨc Cesarea. ");
INSERT INTO poiNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Cuando núc jém Cesarea, nɨct́im Jerusalén iga idioschiyajpa jém Dios ipɨxiñt́am. Ocmɨ nɨc jém attebet Antioquía. ");
INSERT INTO poiNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Jesɨc jáy i̱t́i ju̱na ja̱ma Antioquía. Ocmɨ put e̱ybɨc. Nɨc yɨɨm jeexɨc cada tu̱mtu̱m tɨgaŋjoj ju̱t́ oyñe wiñt́i. Nas icuwɨ̱t́i jém naxyucmɨ de Galacia y Frigia. Iyo̱xpátpa jém Dios ipɨxiñt́am iga odoy ichaguiñ jém Dios iŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Jesɨc jeet́im tiempo núc jém attebet Efeso tu̱m judío iñɨ̱yi Apolos. Nay jém attebet Alejandría. Tsa̱m wɨa̱p inijɨ́yóy. Tsa̱m iwɨ̱cutɨɨyɨ́ypa jém Dios iŋma̱t́i. ");
INSERT INTO poiNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Tsa̱m iwɨ̱cuyujcane t́i ixunpa tanJa̱tuŋ Dios iga taŋwatpa. Iŋmatpa Dios iŋma̱t́i con it́u̱mpɨy ia̱nama. Iwɨ̱aŋquejáypa jém pɨxiñt́am jém tánO̱mi Jesucristo iŋquímayooyi. Mex d́a iwɨ̱jo̱doŋ jém aŋquímayooyi, no más ijo̱doŋ jém Xiwan iŋquímayooyi jém acchíŋoypaap. ");
INSERT INTO poiNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Jém Apolo tɨgɨy jém sinagoga, moj iŋmat jém Dios iŋma̱t́i. Je d́a cɨ̱ŋpa. Pero cuando jém Priscila y Aguila imatoŋyaj, ininɨcyaj jém Apolo tuŋgac áŋe̱ymɨ. Iwɨ̱aŋquejáypa iga más iwɨ̱cutɨɨyɨ́ypa jém tanJa̱tuŋ Dios iŋmadayooyi. ");
INSERT INTO poiNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Jesɨc cuando nɨctooba jém Apolo jém naxyucmɨ de Acaya, jém tantɨ̱wɨtam jém it́yajwɨɨp Efeso tsa̱m iyo̱xpátyajpa. Ijáyáy tu̱m to̱to jém it́yajwɨɨp Acaya iga wɨ̱pɨctsoŋta̱iñ jém Apolo. Jesɨc ocmɨ cuando núcneum Acaya jém Apolo, tsa̱m iyo̱xpát jém icupɨcneyajwɨɨp Cristo, jém ipɨctsoŋneyajwɨɨp jém Dios it́óyooyi. ");
INSERT INTO poiNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Iwɨ̱aŋquejáypa jém judíos jém pɨxiñt́ámaŋjo̱m iga d́a wɨ̱putne jém iŋquímayooyi. Tsa̱m wɨ̱quejpa jém mɨgooyi y jeeyaj d́a wɨa̱p iŋyam. Iŋquejpa con Dios iŋma̱t́i jém jayñewɨɨp iga nu̱ma Jesús je jém Cristo jém iŋjócyajpáppɨc. ");
INSERT INTO poiNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Iganam it́ jém Apolo jém attebet Corinto, naspa jém Pablo jém tɨgaŋjojyaj jém it́yajwɨɨp jém co̱tsɨgaŋjo̱m jém naxyucmɨ de Galacia y Frigia. Ocmɨ núc Efeso. Jemum ipát algunos jém icupɨcneyajwɨɨp Cristo. ");
INSERT INTO poiNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Jém Pablo icwác jém pɨxiñt́am. Iñɨ́máy: —¿Que impɨctsoŋta jém Dios iA̱nama cuando moj iŋcupɨc Cristo? Nɨmyajpa: —D́a ammatoŋta siiga it́ jém Dios iA̱nama. ");
INSERT INTO poiNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Jesɨc jém Pablo icwác. Iñɨ́máy: —¿I̱ iñɨyi̱mɨ micchiŋtamta̱? Nɨmyajpa: —Acchiŋtamta̱ juuts acchíŋóypa jém Xiwan jém acchíŋoypaap. ");
INSERT INTO poiNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Jém Pablo iñɨ́máy: —Jém Xiwan icchiŋpa jém pɨxiñt́am juuts tu̱m seña iga icucaguiñ jém ijɨ̱xi. Iñɨ́máyt́im iga icupɨguiñ jém miñpáppɨc ocmɨ, je jém Jesucristo. ");
INSERT INTO poiNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Jesɨc yaj imatoŋyaj, acchiŋyajta̱p jém tánO̱