﻿USE sofia;
DROP TABLE IF EXISTS sofia.poeNT_vpl;
CREATE TABLE poeNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES poeNT_vpl WRITE;
INSERT INTO poeNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Tíhi mé chrónka nkexro kaín tí sín kꞌuaxrjeníxin chꞌín Jesucristo. Mé jehe chꞌán kꞌuaxrjeníxin chꞌán tí chꞌín David la ko tí chꞌín Abraham. ");
INSERT INTO poeNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Chꞌín Abraham mé itꞌé tí chꞌín Isaac la ko chꞌín Isaac mé itꞌé tí chꞌín Jacob la jehe chꞌán mé itꞌé tí chꞌín Judá la ko kaín kíchó chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Chꞌín Judá mé itꞌé tí chꞌín Fares la ko chꞌín Zara la tí ìné sín mé itꞌin Tamar. Chꞌín Fares mé itꞌé tí chꞌín Esrom la jehe chꞌán mé itꞌé tí chꞌín Aram. ");
INSERT INTO poeNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Chꞌín Aram mé itꞌé tí chꞌín Aminadab la jehe mé itꞌé tí chꞌín Naasón la jehe mé itꞌé tí chꞌín Salmón. ");
INSERT INTO poeNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Chꞌín Salmón mé itꞌé tí chꞌín Booz la ìné mé tjan Rahab. Chꞌín Booz mé itꞌé tí chꞌín Obed la ìné tí chꞌín Obed mé tjan Rut. Tí chꞌín Obed mé itꞌé tí chꞌín Isaí. ");
INSERT INTO poeNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Chꞌín Isaí mé itꞌé tí rey David la jehe chꞌán la ko tí tjan kꞌuéchjién chꞌín Urías mé táha itꞌé la ko ìné tí chꞌín Salomón. ");
INSERT INTO poeNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Chꞌín Salomón mé itꞌé tí chꞌín Roboam la jehe mé itꞌé tí chꞌín Abías la jehe chꞌán mé itꞌé tí chꞌín Asa. ");
INSERT INTO poeNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Chꞌín Asa mé itꞌé tí chꞌín Josafat la chꞌín Josafat mé itꞌé tí chꞌín Joram la chꞌín Joram mé itꞌé tí chꞌín Uzías. ");
INSERT INTO poeNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Chꞌín Uzías mé itꞌé tí chꞌín Jotam la chꞌín Jotam mé itꞌé tí chꞌín Acaz la chꞌín Acaz mé itꞌé tí chꞌín Ezequías. ");
INSERT INTO poeNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías mé itꞌé tí chꞌín Manasés la chꞌín Manasés mé itꞌé tí chꞌín Amón la chꞌín Amón mé itꞌé tí chꞌín Josías. ");
INSERT INTO poeNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Chꞌín Josías mé itꞌé tí chꞌín Jeconías la ko kíchó chꞌán. Tí sín a mé kꞌuéjó sín tí ya̱on a ntá xrína̱hya ikui tí sín Babilonia sákjuíko sín tí sín israelita kíxin tsꞌejóchjina sín tí chjasén sín Babilonia. ");
INSERT INTO poeNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ntá kjuixin sákjuí sín mé chꞌín Jeconías mé itꞌé tí chꞌín Salatiel la chꞌín Salatiel mé itꞌé tí chꞌín Zorobabel. ");
INSERT INTO poeNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Chꞌín Zorobabel mé itꞌé tí chꞌín Abiud la chꞌín Abiud mé itꞌé tí chꞌín Eliaquim la ko chꞌín Eliaquim mé itꞌé tí chꞌín Azor. ");
INSERT INTO poeNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Chꞌín Azor mé itꞌé tí chꞌín Sadoc la ko chꞌín Sadoc mé itꞌé tí chꞌín Aquim la ko chꞌín Aquim mé itꞌé tí chꞌín Eliud. ");
INSERT INTO poeNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Chꞌín Eliud mé itꞌé tí chꞌín Eleazar la chꞌín Eleazar mé itꞌé tí chꞌín Matán la chꞌín Matán mé itꞌé tí chꞌín Jacob. ");
INSERT INTO poeNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Chꞌín Jacob mé itꞌé tí chꞌín José la chꞌín José mé kꞌóna xìí tjan María la jehe tjan María mé ìné tí chꞌín Jesús. Tí chꞌín Jesús la mé nchekꞌin sín Cristo. ");
INSERT INTO poeNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Mé xi̱kaha catorce tꞌáchri̱i kꞌuaxrjeníxin tí chꞌín Abraham ntá kjuákꞌe chꞌín David la í jnko catorce tꞌáchri̱i kꞌuaxrjeníxin tí chꞌín David la ntá tí sín Babilonia sákjuíko tí sín israelita chjasén sín la ntá í jnko catorce tꞌáchri̱i kꞌuéjó la ntá kokjíhi Cristo. ");
INSERT INTO poeNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Tí kokjíhi Jesucristo mé xi̱kihi kónhen. Tí tjan María ìné chꞌán mé tso̱te̱he tjan chꞌín José. A̱ ntá na̱xa̱ kuákjahya kíchó sín ntá kónoxín kíxin jehe tjan la ó tjeyá tjan kíxin tíha la kjua̱cha̱xién Ncha̱kuen Dios. ");
INSERT INTO poeNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Chꞌín José mé tí nkexro tsꞌóna xìí tjan María, mé ijnko chojni jína la tjinkakonhya chꞌán noxín chrókꞌóxroan chꞌán tjan ntá kjuenka̱yáxin chꞌán imó chrókjuáke̱he̱ chꞌán tjan kíxin tjinkaon chꞌán kíxin ninkexró tso̱noehya. ");
INSERT INTO poeNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ntá tí na̱xa̱ tjenka̱yáxin chꞌán kíxin xi̱kaha sichꞌe chꞌán ntá kotáchrién chꞌán chrónkaxín titàya̱ kꞌuíkuèn chꞌán ikui ijnko ángel kuènte Ìnchéni nixja, chrónka kíxin: ―José jaha mé kꞌuaxrjeníxian David. Tóxakuanhya la ko chrakonhya chrókuákjá tjan María tsꞌóna ichjián kíxin tí xjan tsochónta tjan la kjuachaxin kuènté Ncha̱kuen Dios ikui mé kꞌóna tí xjan a. ");
INSERT INTO poeNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Sinchekokjíhi tjan ijnko xjan ntoa la itsꞌin xjan Jesús mé xi̱kaha itsꞌin xjan kíxin jehe xjan tsjakjìin iji̱é chojni ―mé xi̱kaha chrónka tí chꞌín ángel. ");
INSERT INTO poeNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Kaín tíha kónhen kíxin tsoxiteyá tí nkehe chrónka Ìnchéni kꞌuénixja tí sín kꞌuéchrónka itén chꞌán ósé. Mé ntáchro xi̱kihi: ");
INSERT INTO poeNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ijnko tjan na̱xa̱ chóntahya chojni ntoa mé tsjakꞌeyá tjan la tsochónta tjan ijnko xjan, la sinchekꞌin sín chꞌán Emanuel, la tíha tꞌaxrjexín kíxin Dios tjejókoni. Mé xi̱kaha chrónka itén Dios. ");
INSERT INTO poeNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ntá kꞌuàya chꞌín José ntá kjuínchexiteyá chꞌán tí nkehe kꞌue̱to̱an tí ángel kuènte Ìnchéni la kuákja chꞌán tjan María tsꞌóna ichjién chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","A̱ ntá kjónté xi̱kaha la na̱xa̱ kójnkojiéhya sín tí na̱xa̱ kokjíehya xjan la ntá tí xjan mé kjuínchekꞌin sín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Tí kokjíexín chꞌín Jesús tí chjasin Belén estado Judea la tí ya̱on a kjuákꞌe ijnko chꞌín rey itꞌin Herodes mé kꞌue̱tue̱nhen chꞌán tí nación a. A̱ ntá xrína̱hya iso chojni ntoa kjui̱xi̱n ijnko chjasin nó tji̱to̱xi̱n ya̱on mé kjuíji sín chjasin Jerusalén. Jehe sín mé sín mago mé tónoexín sín tí konotsé. ");
INSERT INTO poeNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ntá kjuanchankí sín kíxin: ―¿Nketí tjen tí xjan tsíkokjíhi tsꞌóna tí rey tsꞌe̱tue̱nhen tí sín judío? Kꞌuíkonxínni tí konotsé kuènte chꞌán nó tji̱to̱xi̱n ya̱on na ntá ó kjuini kíxin tsochjéheni chꞌán kjuasáya ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ntá kuínhin tí chꞌín rey Herodes tí xi̱kaha ichro sín ntá imá tóxakonhen chꞌán la ko tóxakonhen kaín tí sín chjasin Jerusalén. ");
INSERT INTO poeNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ntá tí chꞌín rey kꞌue̱to̱an kíxin síxrakoa kaín tí sín ncha̱tꞌá tꞌe̱to̱an la kaín tí sín tjako tí ley la ntá kjuanchankíhi sín chꞌán nketí chrókokjíexín tí nkexro Cristo. ");
INSERT INTO poeNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ntá jehe sín kjuáte̱he sín kíxin: ―Tsokjíexín xjan chjasin Belén estado Judea mé xi̱kaha tsíkjin tí sín tsíchrónka itén Dios. Ntáchro xi̱kihi: ");
INSERT INTO poeNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Jaha chjasin Belén nonte Judá, jaha la jehya ijnko chjasin imá ntsí; kíxin tí nonte tsꞌaxrjexín tí nkexro a̱ntsí tꞌe̱to̱an, la jehe chꞌán tsꞌayakonhen tí chjasin kuènta̱na mé chjasin Israel. Mé xi̱kaha nixja itén Dios. ");
INSERT INTO poeNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ntá imó kꞌuíye̱he̱ chꞌin Herodes tí sín mago la kjuanchankíhi chꞌán sín nkesá kjuankíxin kꞌuíkon sín tí konotsé. ");
INSERT INTO poeNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ntá chrónka sín ntá tuénxín kꞌue̱to̱an chꞌán kíxin sátsji sín chjasin Belén la ntáchro chꞌán kíxin: ―Sátjirá ntiha la tjéyárá tí xjan la tió tsꞌitjará xjan la tso̱chro̱nka̱rá kíxin ntá kja̱xian janhan sátsjia ntiha tso̱tja̱ha̱ xjan kjuasáya ―mé xi̱kaha kꞌue̱to̱an chꞌín Herodes. ");
INSERT INTO poeNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ntá kuínhin tí sín mago tí nkehe kꞌue̱to̱an tí chꞌín rey ntá sákjuí sín la xíkꞌikon sín tí konotsé ínaá la kjuítaón va nti̱a la ntá chréhe̱ sín hasta kjuákꞌe va chrítaón tí nchia tjen tí xjan a. ");
INSERT INTO poeNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ntá tió kꞌuíkon tí sín mago nketí kjuákꞌe tí konotsé la imá kóchéhe̱ sín. ");
INSERT INTO poeNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","La kꞌuíxenhen sín tí nchia la kꞌuíkon sín tí xjan kjuákꞌeko tí tjan María ìné xjan. Ntá kꞌuéjóxin tochꞌin sín la chjéhe sín kjuasáya ntá kuakitje̱he̱ sín tí nkehe kjui̱ka̱o sín la kjuanjon sín chica oro la ko ihnti tsochéxin chji̱nco̱ la ko xro̱a̱n xraxé náxrjón. ");
INSERT INTO poeNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ntá chrꞌéxi̱n kotáchrién sín chrónkaxín kíxin chrókjanhya sín tí tjen chꞌín Herodes. Méxra̱ kja̱nxi̱n sín í jnko nti̱a la sákjuí sín chjasén sín. ");
INSERT INTO poeNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ntá tió kjuixin sákjuí tí sín mago la ntá kotáchrién chꞌín José chrónkaxín titàya̱ kꞌuíkon chꞌán ijnko ángel kuènte Ìnchéni chrónka kíxin: ―Tꞌàyá sátsjikoa xjan la ko ìné xjan la sátsjirá chjasin Egipto la ntahó tsꞌejorá hasta tso̱xrja̱nkajia, kíxin tí chꞌín Herodes xritjeyá tí xjan chrókꞌóyán chꞌán xjan ―mé xi̱kaha chrónka tí ángel. ");
INSERT INTO poeNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ntá chꞌín José kꞌuàya la ntá sákjuíko chꞌán xjan la ko ìné xjan la sákjuí sín chjasin Egipto tí tie a. ");
INSERT INTO poeNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ntahó kꞌuéjó sín hasta ikꞌuén chꞌín Herodes. Mé xi̱kaha kónhen kíxin tsoxiteyá kaín tí nkehe chrónka Ìnchéni, kꞌuénixja tí sín tsíchrónka itén chꞌán. Mé ntáchro sín kíxin: “Chjasin Egipto kjuákꞌe xja̱nna ntá kꞌuíya̱ha̱ chꞌán”. ");
INSERT INTO poeNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","A̱ ntá kónohe chꞌín rey Herodes kíxin tí sín mago mé kjuíchꞌiyehe sín chꞌán ntá imá kónínkaon chꞌán la kꞌue̱to̱an chꞌán kíxin itsꞌen kaín tí chánjan ntoa siín chjasin Belén ó chónta iyó nánó la ko tí xjan na̱xa̱ chóntahya iyó nánó. Mé xi̱kaha kꞌue̱to̱an chꞌán kíxin ó xraxinkaon chꞌán nkehe kuínhin chꞌán chrónka tí sín mago. ");
INSERT INTO poeNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Mé xi̱kaha ó xiteyá tí nkehe tsíkjin tí chꞌín Jeremías ntáchro chꞌán kíxin: ");
INSERT INTO poeNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Kuínhin sín itén chojni chjasin Ramá mé tsjánka sín. Tíha mé tí tjan Raquel la tsjánkàma̱ tjan xje̱en tjan. Kohya nkexro sinchechéhe̱ tjan kíxin ó kaín xjan tsíkꞌen xjan. Mé xi̱kaha chrónka itén Dios. ");
INSERT INTO poeNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ntá tió kjuixin kꞌuén chꞌín Herodes ntá ijnko ángel kuènte Ìnchéni mé kꞌuíkonxín chꞌín José kotáchrién chꞌán tí kjuákꞌe chꞌán chjasin Egipto mé ntáchro kíxin: ");
INSERT INTO poeNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Tꞌàyá sátsjikoa tí xjan la ko tí ìné xjan la tsokjan chjasin Israel kíxin ó kjuixin kꞌuén tí nkexro chrókꞌóyán tí xjan a ―mé xi̱kaha kꞌue̱to̱an tí chꞌín ángel. ");
INSERT INTO poeNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ntá chꞌín José mé kꞌuàya chꞌán la sákjuíko chꞌán tí xjan la ko tí ìné xjan la sákjuí sín chjasin Israel. ");
INSERT INTO poeNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","A̱ ntá kuínhin chꞌín José kíxin chꞌín Arquelao xje̱en chꞌín Herodes mé kꞌue̱to̱an chꞌán tí estado Judea la ntá chrakon chꞌán la sáchrókjuihya chꞌán ntiha. A̱ ntá kotáchrién chꞌán chrónkaxín Dios kíxin sáchrókjui chꞌán estado Galilea. ");
INSERT INTO poeNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ntá tió kjuíji sín ntiha ntá sákjuí sín ijnko chjasin itꞌin Nazaret la ntaha kꞌuéjó sín. Mé xi̱kaha xiteyá tí nkehe tsíchrónka tí sín kꞌuénixja itén Dios senó. Kꞌuéntáchro sín kíxin jehe chꞌán mé tsi̱ki̱texín sín nazareno. ");
INSERT INTO poeNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","A̱ ntá tí ya̱on a kjuákꞌe chꞌín Juan Bautista nte̱je̱ Judea la kjuako chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ntáchro chꞌán kíxin: ―Ti̱to̱hérá iji̱árá la tjínkírá tí nkehe tjenka̱yáxinrá kíxin í séhya itsi kjua̱cha̱xién Dios. ");
INSERT INTO poeNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Tí chꞌín Isaías, mé ijnko chꞌín tsíchrónka itén Dios, mé tsíkjin chꞌán kuènte tí chꞌín Juan mé chrónka chꞌán kíxin: Tsinhin sín itén ijnko nkexro tsjakꞌe nte̱je̱ tsꞌèya tsontáchro kíxin: “Tóxakonhanrá ncheyóxinrá nti̱a tsi̱xi̱n Ìnchéni. Takitje̱hérá ijnko nti̱a ntoí.” ");
INSERT INTO poeNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Tí iké chꞌín Juan mé tsíkꞌóna ka̱xre̱e kocamello la ko tí nkehe chrꞌínkatꞌóxin chꞌán mé tsíkꞌóna tjo̱a̱. A̱ ntá tí nkehe kjóne chꞌán mé kochjo̱á la ko itsje̱n kotsje̱nta tónoxín nte̱je̱. ");
INSERT INTO poeNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Itsjé chojni kui̱xi̱n sín chjasin Jerusalén la ko í so chjasin siín estado Judea la ko chjinaxón tí nta̱río Jordán kíxin tsinhin sín nkexrí tjechrónka chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ntá chrónka sín iji̱é sín ntá chꞌín Juan kui̱ki̱texín chꞌán sín tí nta̱río Jordán. ");
INSERT INTO poeNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ntá xrína̱hya kꞌuíkon chꞌín Juan ikui nchónhya tí sín fariseo la ko tí sín saduceo kíxin tjinkaon chrókuikite sín la ntá ntáchro chꞌán kíxin: ―Jahará tsíkꞌaxrjeníxinrá konche. ¿Xá nkexro kjuíntanohará kíxin chrókuinkéhérá tí kjuanínkaon kuènte Dios ó tsi? ");
INSERT INTO poeNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Tꞌichjánxi̱n kíxin chrókꞌuejorá jnkojína chrókjuáko̱xi̱nrá kíxin chaxín kjuítoxi̱nhínrá tí nkehe tjenka̱yáxinrá. ");
INSERT INTO poeNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Jahará nchehnkerá ntáchrorá kíxin kꞌuaxrjeníxinrá chꞌín Abraham. Janhan ntáxrja̱n kíxin kjónté tí xro̱ i la Dios tsjacha chrókjuichꞌéna chꞌán chojni kꞌuaxrjeníxin chꞌín Abraham. ");
INSERT INTO poeNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Tí chica hacha ó tjechónhen tsochrínjinxín tí nta. A̱ ntá kaín xín nta tꞌónahya to jína mé tsochrínjin kíxin tsoche. ");
INSERT INTO poeNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Janhan mé ìnta̱ tíki̱texián chojni kíxin tsja̱ko̱xi̱n sín kíxin ó kjuitoxi̱nhin sín nti̱é sín. A̱ ntá tí nkexro itsi chrꞌéxi̱n mé tsi̱ki̱texínrá tí Ncha̱kuen Dios la ko xrohi. A̱ntsí tjetóxin tꞌe̱to̱an chꞌán a̱ ntá janhan la kánhyó. Méxra̱ chrókósuàna sáchrókjui̱ki̱an to̱ka̱té chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Jehe chꞌán la ó tjexraá chꞌán pala sinchetjuáxin chꞌán noatrigo kíxin tí nta̱chji̱ji trigo la ókjé tsꞌejo chꞌán a̱ ntá tí noatrigo la tsjenájín chꞌán la tsꞌe̱nka̱chji̱na chꞌán. A̱ ntá tí nta̱chji̱ji trigo la tsjakaxín chꞌán ijnko xrohi tsꞌankahya jnkochríxín —mé xi̱kaha kjuako chꞌín Juan. ");
INSERT INTO poeNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ntá chꞌín Jesús kjui̱xi̱n chꞌán nó estado Galilea ikui chꞌán tí nta̱río Jordán tí tjen chꞌín Juan kixin chꞌín Juan tsi̱ki̱te tí jehe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","A̱ ntá tí sa̱oxín chrohya chꞌín Juan chrókui̱ki̱te tí chꞌín Jesús ntáchro chꞌán kíxin: ―Náhí. Jeheni tꞌichjánxi̱nhinni jaha chrókuíki̱te tí jeheni. A̱ ntá jaha kꞌuinka kíxin jeheni chrókuíki̱tia tí jaha ―ichro chꞌín Juan. ");
INSERT INTO poeNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ntá kjuáte̱he chꞌín Jesús kíxin: ―A̱ ntá jie la ti̱to̱hé tí xi̱kaha tjenka̱yáxian kíxin tꞌichjánxi̱n tsikiteni kíxin sinchexiteyáni tí nkehe kꞌue̱to̱an Dios. Ntá chꞌín Juan kuítekaon chꞌán la xi̱kaha kjuíchꞌe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ntá tió kuíkite tí chꞌín Jesús la ntá xrína̱hya titàya̱ xitje̱he̱ nka̱jní la kꞌuíkon chꞌán tí Ncha̱kuen Dios, éxí kontóá tsjehe, kꞌuínkaji̱nxi̱n nkaya nka̱jní ntá kjuákꞌe chrítaón kja chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ntá xrína̱hya kuínhin sín ijnko tan kui̱xi̱n nkaya nka̱jní ntáchro kíxin: ―Tíhi mé xja̱nna la imá tjua̱ha̱ chꞌán la imá chàna kíxin nchexiteyàna chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ntá tí Ncha̱kuen Dios mé sákjuíko chꞌín Jesús tí nte̱je̱ a̱ ntá chꞌín Tsochren tjinkaon chrókjuachroe chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Tí nte̱je̱ a mé kjuákꞌe chꞌán kjónehya chꞌán cuarenta ya̱on la ko cuarenta tie la ntá chrꞌéxi̱n kónohe chꞌán ikꞌuén chꞌán kjinta. ");
INSERT INTO poeNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ntá chꞌín Tsochren mé kóchjinehe tí chꞌín Jesús kíxin tjinkaon chrókjua̱cha̱xi̱n chꞌán. Ntáchro chꞌán kíxin: ―Tí chaxín jaha Xje̱en Dios la ntáche tí xro̱ i kíxin chrókꞌóna nio̱tja̱. ");
INSERT INTO poeNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ntá kjuáte̱he chꞌín Jesús ntáchro kíxin: ―Náhí. Ntáchro xroon itén Dios kíxin: “Jehya nio̱tja̱ ó chrókꞌuejóchónxin chojni. Náhí. Kaín tí tán nixja Dios tjejóchónxin chojni” ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ntá chꞌín Tsochren mé sákjui̱ko chꞌín Jesús tí chjasin tjóá mé chjasin Jerusalén, la sákjui̱ko chꞌán tí chrítaón tí kja ni̱nko a ");
INSERT INTO poeNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","la ntáchro chꞌán kíxin: ―Tí chaxín Xje̱en Dios jaha la ti̱to̱hé tꞌanótje̱nxian tí noi ntihi kíxin ntáchro xroon itén Dios kíxin: Dios mé tsꞌe̱tue̱nhen tí sín ángel kuènte chꞌán kíxin tsꞌayakonhan sín. Tsotsé sín itjá kíxin tsotéhya to̱tá tsꞌitja xro̱ tí tsꞌanótje̱n ―ichro chꞌín Tsochren. ");
INSERT INTO poeNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Náhí. Kja̱xin ntáchro xroon itén Dios kíxin: “Chji̱níhya chrókjuásixián kjuaxroan kjuachaxin kuènte Ìnchéni Dios” ―ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","A̱ ntá tió kjuixixín sákjui̱ko chꞌín Tsochren tí chꞌín Jesús ijnko jna̱ imá noi ntá kjuako tí Jínahya kaín xín tí nación siín chjasintajni la ko tí nkehe tꞌe̱to̱an kuènte. ");
INSERT INTO poeNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","La ntáchro chꞌín Tsochren kíxin: ―Kaín tíha mé tso̱tja̱ha tí tsjakꞌéxian tóchꞌian tsjíkosáyana tí janhan ―mé xi̱kaha ichro chꞌín Tsochren. ");
INSERT INTO poeNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Sátjia Satanás kíxin xroon itén Dios ntáchro kíxin: “Chrókjuíkosáyehé Ìnchéni Dios la jehó chꞌán chrókjui̱chꞌehé xra̱” ―ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","A̱ ntá chꞌín Tsochren mé kuíto̱he tí chꞌín Jesús la iso tí sín ángel ikui tsjinki̱tsa tí jehe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","A̱ ntá chꞌín Jesús mé kuínhin chꞌán kíxin tí chꞌín Juan mé tjechjina chꞌán nto̱echiso a, a̱ ntá jehe chꞌán mé sákjuí chꞌán estado Galilea. ");
INSERT INTO poeNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Kuíto̱ehya chꞌán chjasin Nazaret ntiha. Náhí. Sákjuí chꞌán chjasin Capernaum la kjuákꞌe chꞌán ntiha. Tí chjasin a mé tjen chrínta nta̱yaon chjino estado Zabulón la ko estado Neftalí. ");
INSERT INTO poeNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Mé xi̱kaha kjuíchꞌe chꞌán kíxin tsoxiteyá tí nkehe tsíkjin chꞌín Isaías, ijnko nkexro kꞌuéchrónka itén Dios. Ntáchro chꞌán kíxin: ");
INSERT INTO poeNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Tí estado Zabulón la ko Neftalí tí nti̱a chrìnta nta̱yaon la tí nó chókꞌá tji̱to̱xi̱n ya̱on tí nta̱río Jordán, mé tí estado Galilea tí tjejó tí sín jehya judío. ");
INSERT INTO poeNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Mé ntiha tjejó tí sín siín tí sítié mé tsꞌikon sín ijnko xrohi jié, la tí sín éxí tsíkꞌen xritjejó sín mé tsꞌinkaséyanxín tsꞌejó sín. ");
INSERT INTO poeNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ntá kjuankixin kjuako chꞌín Jesús ntáchro chꞌán kíxin: ―Tjitóxínhinrá nti̱ará. Tsákjárá ijnko nti̱a ni̱xin kíxin kjuachaxin kuènte Dios tjen nkaya nka̱jní la í séhya tsi. ");
INSERT INTO poeNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ntá sákjuí chꞌín Jesús chrìnta nta̱yaon Galilea ntá xrína̱hya kꞌuíkon chꞌán yaá sín jnkoko̱á kíchó sín, ijnko mé itꞌin Simón mé kja̱xin itꞌin chꞌán Pedro la ko í jnko itꞌin Andrés. Jehe sín mé koche xritsé sín. Ntá tinkákꞌe sín nchísén chrínkí nta̱. ");
INSERT INTO poeNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ntá chꞌín Jesús nixje̱he̱ sín ntáchro chꞌán kíxin: ―Chréhérá tí janhan ntá tso̱tja̱hará xra̱ tsjéyárá chojni. ");
INSERT INTO poeNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ntá tuénxín kuíto̱he sín tí nchísén kꞌuétséya sín koche, ntá sákjuíko sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ntá kjínhya kjuíji chꞌán ntá kꞌuíkon chꞌán ijnko yaá sín, jnkoko̱á kíchó sín, mé tí chꞌín Jacobo la ko chꞌín Juan, mé xje̱en tí chꞌín Zebedeo. Tjejóko sín itꞌé sín tí ntabárco̱ la tjejótjo̱ni̱te sín tí nchísén tséya sín koche. Ntá kja̱xin tí sín a kꞌuíye̱he̱ chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","La ntá tuénxín kuíto̱he sín tí ntabárco̱ la ko tí itꞌé sín ntá sákjuíchréhe̱ sín tí chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ntá sákjuí chꞌín Jesús nkuíxín tí estado Galilea la kjua̱ko̱xi̱n chꞌán tí ni̱nko Israel siín jnkojnko chjasin mé kjuako chꞌán tí tan jína chrónka nkexrí tí kjuachaxin kuènte Dios la ko kjuínchekito̱he chꞌán jína kaín chojni chónta kaín xín chin la ko kaín kjuatjoté. ");
INSERT INTO poeNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ntá kaín xín tí sín tjejó tí estado Siria mé kuínhin sín kuènte Jesús la kjui̱ka̱o sín kaín xín tí sín níhi chónta kaín chin la ko tí sín imá tjotéhe sín la ko tí sín chónta ncha̱kuen tí jínahya la ko tí sín tꞌaniáte sín la ko tí sín síxénká to̱té sín, la ntá chꞌín Jesús mé kjuínchekito̱he chꞌán sín jína. ");
INSERT INTO poeNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ntá itsjé chojni kjuíchréhe̱ tí chꞌín Jesús, mé kjui̱xi̱n sín estado Galilea la ko tí chjasin chjinaxón Decápolis la ko chjasin Jerusalén la ko kuenté tí estado Judea la ko tí nó chókꞌá tji̱to̱xi̱n ya̱on tí nta̱río Jordán. ");
INSERT INTO poeNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Kꞌuíkon chꞌín Jesús kíxin kꞌuéjó nchónhya chojni la ntá chrìin chꞌán ijnko jna̱ la ntaha kjuákꞌetja̱xi̱n chꞌán. Ntá tí sín kꞌuájiko chꞌán a mé kóchjina sín chjinaxón tjejóntaxin sín tí tjen chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ntá chꞌín Jesús kjuankíxin kjua̱ko̱he̱ chꞌán sín kíxin: ");
INSERT INTO poeNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Náxrjón tjejó tí sín nohe kíxin tꞌichjánxi̱nhin sín nkehe kuènte Dios kíxin ntá jehe sín mé tsochónta sín tí kjuachaxin kuènte Dios. ");
INSERT INTO poeNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Náxrjón tjejó tí sín tꞌává kíxin Dios mé sinchechéhe̱ a̱sén sín. ");
INSERT INTO poeNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Náxrjón tjejó tí sín hnkehya a̱sén kíxin jehe sín mé tsꞌáyéhe̱ sín tí nonte tsjanjon Dios. ");
INSERT INTO poeNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Náxrjón tjejó tí sín éxí yóhe̱ chrókꞌuenxín sín kjinta la chrókꞌuenxín sín nta̱ kíxin xi̱kaha imá tjinkaon sín sinchexiteyéhe̱ sín Dios ntá Dios tsjinki̱tsa sín kíxin tsꞌáyéhe̱ sín tí nkehe tjinkaon sín. ");
INSERT INTO poeNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Náxrjón tjejó tí sín ti̱konóe̱he̱ kíchó sín kíxin ntá Dios kja̱xin tsi̱konóe̱he̱ tí jehe sín. ");
INSERT INTO poeNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Náxrjón tjejó tí sín kótjóá a̱sén kíxin ntá jehe sín sátsji̱kꞌikon sín Dios. ");
INSERT INTO poeNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Náxrjón tjejó tí sín tjinkaon kjuaxróxin kíxin Dios sinchekꞌin chꞌán xje̱en chꞌán tí jehe sín. ");
INSERT INTO poeNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Náxrjón tjejó tí sín kjónté tjejótjasótexín sín kíxin kjuínchexiteyéhe̱ sín Dios kíxin ntá jehe sín mé kuènte sín nkaya nka̱jní. ");
INSERT INTO poeNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Náxrjón tjejorá kjónté tꞌántaxínhanrá sín la ko ntachrakonrá sín la ko kaín nkehe náxrjónhya ntáchro sín kíxin tinkachónkirá tí janhan. ");
INSERT INTO poeNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Chrókócháhará la ko kjuaxróxin chrókꞌuejorá kíxin ntá chrꞌéxi̱n jahará tsꞌayéhérá ijnko nkehe a̱ntsí má jína nkaya nka̱jní. Mé xi̱kaha kjuasóte tí sín kꞌuéjó ósé kꞌuéchrónka sín tí itén Dios. ");
INSERT INTO poeNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Jahará mé yóhe̱ éxí xíjnta chjasintajni. A̱ ntá tí chrókꞌuánkéhé tí jní tí xíjnta la ntá xitjahya chrókójní ínaá. Ninkehó chrókjuichꞌehya xra̱ la chrókꞌuikitjí ntója la ko chrókuinkátja chojni. ");
INSERT INTO poeNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’A̱ ntá jahará la mé tí xrohi tꞌinkaséyanxín chjasintajni. Ijnko chjasin itjen chrítaón jna̱ la xitjahya tsjakꞌemá. ");
INSERT INTO poeNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","La ko kohya nkexro sinchekꞌákjen ijnko lámpara ntá tsjakꞌe chrínkí ijnko ntacajón. Íchá jína tsjakꞌe chꞌán xrohi noi kíxin ntá tsꞌinkaséyanxín kaín nkexro siín tí nchia ntiha. ");
INSERT INTO poeNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Mé xi̱kaha tí jahará chrókóyóha̱rá éxí tí xrohi tꞌinkaséyanxín kíxin tsꞌikon kaín chojni tí xra̱ jína tjejochꞌerá la ntá chrókjuanchehe sín kjuasáyé Itꞌéni tjen nkaya nka̱jní. ");
INSERT INTO poeNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Jahará chróntáchrohyará kíxin kꞌuinka kíxin tsjakjíyan tí ley tsíkꞌe̱to̱an chꞌín Moisés la ko tí nkehe kjuako tí sín kꞌuéchrónka itén Dios. Náhí. Jehya xi̱kaha kꞌuinka kíxin tsjakjíyan tíha. Náhí. Kꞌuinka janhan kíxin tsjáko̱xian nkehe chaxín tꞌaxrjexín tíha. ");
INSERT INTO poeNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Chaxín xrja̱nka kíxin tí na̱xa̱ tjen nka̱jní la ko chjasintajni la kohya ninkehó ley tsjìinhya, mé tsjìinhya nijnko punto la nijnko letra kuènté tí ley tsjixinjian tsoxiteyá kaín tí nkehe tꞌichjánxi̱n tsoxiteyá. ");
INSERT INTO poeNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Mé xi̱kaha tí nkexro tsitekakonhya tí nkehe kꞌue̱to̱an tí ley kjónté ijnko nkehe imá intsí, la ko chrókjuako kíxin xi̱kaha chrókuitekakonhya chojni, la jehe sín la imá tso̱ntsí sín tí tsi tí kjuachaxin kuènte Dios. A̱ ntá tí nkexro tsitekaon la ko tsja̱ko̱he̱ ókjé nkexro tsitekaon sín, mé a̱ntsí imá tsꞌe̱to̱an sín tí tsi kjuachaxin kuènte Dios. ");
INSERT INTO poeNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Méxra̱ tjo̱nka̱rá kíxin tꞌichjánxi̱n kíxin a̱ntsí jína tsꞌejorá la tsoyóa̱hyará tí sín tjako ley la ko tí sín fariseo kíxin tí tso̱yóha̱rá sín la ntá xitjahya tsákjárá tí kjuachaxin kuènte Dios tjen nkaya nka̱jní. ");
INSERT INTO poeNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Jahará tsíkinhínrá kíxin tí sín ósé tsíkꞌítuenhen sín kíxin: “Tꞌoyánhyará kíchuárá kíxin tí nkexro tꞌóyán kíchó mé tꞌichjánxi̱n tsjasóte sín.” ");
INSERT INTO poeNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","A̱ ntá janhan tjo̱nka̱rá kíxin jnkojín nkexro tso̱nínkakonhen kíchó mé tꞌichjánxi̱n tsjasóte. A̱ ntá tí nkexro tꞌántaxínhi̱n kíchó la mé tí sín tꞌe̱to̱an mé sinchekito̱exín iji̱é chꞌán. La ntá tí nkexro tsontáche kíchó kíxin tsíxénká chꞌán la tíha mé sátsji tsjasótexín tí siín xrohi. ");
INSERT INTO poeNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","A̱ ntá tí tsjikuehérá Dios nkehe tsochje̱hérá chꞌán ntá tsjasánrá tí altar ntá tsoxráxinkáonrá tí jnkojín kíchuárá kjuánjo̱nkoará sín ");
INSERT INTO poeNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","la ntá tí xi̱kaha la ti̱to̱hérá tí nkehe tí altar la sátsjirá tsonixje̱hérá chꞌán jnkojína kíxin í tso̱kohya kjuanínkaon. La ntá tsjixin la ntá tsji̱hará tsjánjonrá tí nkehe tjinkáonrá tsjánjonrá. ");
INSERT INTO poeNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Tí siín jnkojín nkexro tjanchia jie̱ tí jahará la tjinkaon chrókjuikoárá chꞌán juzgado, a̱ ntá íchá jína jnkoko̱á chrókjuenka̱yáxinrá, jehe chꞌán la ko jahará, nti̱a ó, kíxin ntá sáchrókjuihyará tí tjen chꞌín juez. Kíxin sáchrókjuirá tí tjen chꞌán ntá jehe chꞌán tsꞌe̱tue̱nhen chꞌán tí policía kíxin tsꞌixe̱nhenrá nto̱echiso. ");
INSERT INTO poeNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","A̱ ntá chaxín tjo̱nka̱rá kíxin tí tsꞌikjaha̱rá sín nto̱echiso la tsꞌaxrjéxi̱nhyará ntiha tsjixinjian tsjenke̱herá sín kaín xín chichaon chontará. ");
INSERT INTO poeNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Jahará tsíkinhínrá tí nkehe tsíkꞌítuenhen tí sín ósé ntáchro kíxin: “Chrókjuásinhyará jie̱, chróchontahyará chojni chjin ókjé.” ");
INSERT INTO poeNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","A̱ ntá janhan tjo̱nka̱rá kíxin tí nkexro tsokomá ijnko tjan ókjé tjakꞌe a̱sén chrókuákja chꞌán la ó kjuixin kjuasin chꞌán jie̱ nkaya a̱sén chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’A̱ ntá tí ikuan chjina chrókjuásixián jie̱ la chrókuakitsjenkiá ikuan la chróchrꞌan ikjín kíxin íchá jína tsꞌítjáyan itꞌo̱ cuerpo kuèntá kíxin jehya kuenté cuerpo kuèntá sátsji tsjasótexín tí siín xrohi. ");
INSERT INTO poeNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","A̱ ntá tí itja chjina chrókjuásixián jie̱ la chrókóchrínjian tí tjá a la chróchrꞌan ikjín kíxin íchá jína tsꞌítjáyan itꞌo̱ cuerpo kuèntá kíxin jehya kuenté cuerpo sáchrókjui tsjasóte tí siín xrohi. ");
INSERT INTO poeNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Kja̱xin tsíkꞌítuenhen tí sín ósé kíxin tí nkexro tjinkaon chrókꞌuitjíhi ichjién tꞌichjánxi̱n tsꞌóna xroon tsakja tí ichjién kíxin tsꞌitjíexín kíchó sín. ");
INSERT INTO poeNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","A̱ ntá janhan tjo̱nka̱rá kíxin ijnko nkexro tsjáke̱he̱ ichjién tí chróchóntahya tjan ókjé nkexro la jehe chꞌán kuíto̱he chꞌán tjan kíxin tsjasin tjan jie̱. A̱ ntá tí nkexro tso̱te̱he ijnko tjan tsíkítsínkehe la kja̱xin ó kjuasin chꞌán jie̱. ");
INSERT INTO poeNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Kja̱xin tsíkinhínrá tsíkꞌítuenhen tí sín ósé kíxin: “Tꞌichjánxi̱n si̱nchexiteyárá tí nkehe tsíntáchrorá kíxin chrókꞌuákjenxi̱nhyará ihni̱é Ìnchéni chji̱ní.” ");
INSERT INTO poeNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","A̱ ntá janhan mé tjo̱nka̱rá kíxin chrókꞌuákjenxi̱nhyará ihni̱é Dios ninkehó la ko chrókꞌuákjenxi̱nhyará nka̱jní kíxin ntaha tjen Dios tꞌe̱to̱an. ");
INSERT INTO poeNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","La ko chrókꞌuákjenxi̱nhyará chjasintajni kíxin ntaha tjejókjen to̱té chꞌán la ko chrókꞌuákjenxi̱nhyará chjasin Jerusalén kíxin ntiha la itjen tí Rey tꞌe̱to̱an. ");
INSERT INTO poeNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","La tjenka̱yáxixínhyará ikjárá ó kíxin jahará xitjahya tsjakérá ijnko ka̱xi̱hi tjóá o̱ nijnko ka̱xi̱hi tié. ");
INSERT INTO poeNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Tí nkehe tsontáchrorá chaxín la chaxín la tí nkehe náhí la náhí la kohya nkehe chrókjuakétꞌo̱xinrá chróchro̱nka̱rá. A̱ ntá ichrén nkehe tjakétꞌo̱xinrá tsochro̱nka̱rá la táha mé jínahya. ");
INSERT INTO poeNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Jahará mé ó tsíkinhínrá tsíkꞌítuenhen tí sín ósé kíxin tí takitsjenkí sín ikonrá la kja̱xinrá chrókuakitsjenkírá ikon sín. A̱ ntá tí chrókuakitsjenkí sín nènorá la kja̱xinrá chrókuakitsjenkírá neno sín kja̱xin. ");
INSERT INTO poeNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","A̱ ntá janhan mé tjo̱nka̱rá kíxin tí jnkojín nkexro ichrén nkehe jínahya sitꞌahará la jahará chꞌehyará xi̱kaha. Náhí. Tí chjéhe ijnko nkexro ijnko tua̱an la ntá tjóka tí í jnko nànko tua̱an. ");
INSERT INTO poeNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","La tí siín jnkojín nkexro tjanchia jie̱ la tjinkaon sín chrókuakitsjaha sín camisá la ti̱to̱hé sín sátsjiko sín tí ka tꞌínka̱yate kja̱xin. ");
INSERT INTO poeNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","La tí tꞌe̱tua̱nhanrá sín tsámárá nkehe ijnko kilómetro la tjakétꞌo̱xinrá í yaá kilómetro. ");
INSERT INTO poeNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Tí jnkojín nkexro tsjanchia nkehe la tí tjinkaon chꞌán nkehe la chróntáchrohyará kíxin “náhí”, chrókjui̱nchekjenrá chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Kja̱xin ó tsíkinhínrá tsíkꞌítuenhen tí sín ósé kíxin: “Tjuèhérá tí nkexro choxinrá la tso̱ninkákonhénrá tí sín jínahya kjuítꞌahará.” ");
INSERT INTO poeNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","A̱ ntá janhan mé tjo̱nka̱rá kíxin chrótjuèhérá tí sín nínkakonhanrá la chrókjui̱ncheyaonrá tí sín jínahya kjuítꞌahará la jína chrókjuinki̱tsará tí sín tjinkakonhya tí jahará la chrónixje̱hérá Dios kíxin chrókjuinki̱tsa chꞌán tí sín tꞌántaxínhanrá la ko tí sín tꞌahará tí jínahya. ");
INSERT INTO poeNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Tí xi̱kaha si̱chꞌerá la ntá jahará chaxín xje̱en Itꞌéni tjen nkaya nka̱jní kíxin jehe chꞌán mé tꞌe̱to̱an chꞌán tsji̱to̱n ya̱on tsꞌinkaséyenhen tí sín jínahya la ko tí sín jína la ko kja̱xin tꞌe̱to̱an chꞌán kíxin tsꞌaniá ichrin tí siín tí sín jína la ko tí sín jínahya. ");
INSERT INTO poeNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Tí jehó tjuèhérá tí nkexro tjuàhará, ¿la ntá nkehe chrókjuachará? A̱ ntá kja̱xin tí sín nchekjènki̱ la xi̱kaha chꞌe sín. ");
INSERT INTO poeNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","La tí jehó nixje̱hérá tí sín kíchuárá la ntá, ¿á chaxín imá jína tíha ní? Kíxin tí xi̱kaha la kja̱xin tí sín chónhya Dios la xi̱kaha ichꞌe sín. ");
INSERT INTO poeNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kja̱xinrá jahará ntoá chrókꞌuejorá kíxin Itꞌéni tjen nkaya nka̱jní la a̱ntsí má ntoá tjen chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Chrókjuásixínhyará kjuaxroan tí nkehe tinkachónkirá kíxin tjinkáonrá chrókꞌuikon chojni ó. A̱ ntá jahará tí xi̱kaha chrókjui̱chꞌerá ntá Itꞌéni tjen nkaya nka̱jní la ninkehó nkehe tsotjáhyará chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Tí tjínki̱tsará ijnko chojni nòa la ninkexró chróchenkahyará. Jahará chrókóyóa̱hyará tí sín ntoáhya tjenka̱yáxin ixri tꞌóxroan kíxin mé xi̱kaha chꞌe sín tꞌóxroan sín nkaxenhen ni̱nko la ko tí nti̱a kíxin chrókꞌuikon chojni la chrókjuikosáyehe sín tí jehe sín kíxin jína tjejóchꞌe sín. A̱ ntá janhan ntáxrja̱n kíxin ó kjuixin kꞌuáyéhe̱ sín nkehe la í tsꞌáyèhya sín ínaá. ");
INSERT INTO poeNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","A̱ ntá tí jahará tió chrókjuínki̱tsará ijnko chojni chaxín nòa la íchá jína kíxin chrókónoehya ninkexró kjónté ijnko nkexro tjuá jína. ");
INSERT INTO poeNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","A̱ ntá jahará tí chrókjuánjonrá ichrén nkehe la ninkexró chrókónoehya la ntá tí Itꞌéni tsꞌikon chꞌán kíxin xi̱kaha chꞌerá la ninkexró noehya la ntá tí jehe chꞌán mé tsotjáhará chꞌán nkehe. ");
INSERT INTO poeNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’A̱ ntá tió nixje̱hérá Dios la jehya éxí tí sín jnkojínxónhya tjenka̱yáxin sín chrónixjará. Jehe sín mé tóxrjínhi̱n sín tsꞌejóxin to̱té sín nkaxenhen ni̱nko la ko tsꞌejó sín esquina calle kuènte ntasin kíxin tsꞌikon kaín chojni kíxin tjejónixje̱he̱ sín Dios. Ntá janhan chaxín ntáxrja̱n kíxin jehe sín la xi̱kaha kjuíchꞌe sín la ó kjuixin kꞌuáyéhe̱ sín nkehe la í tsꞌáyèhya sín ínaá. ");
INSERT INTO poeNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","A̱ ntá tió nixje̱hérá Dios la tꞌixe̱nhénrá nchia nto̱ará la tꞌikje̱hérá tí puerta la nixje̱hérá Itꞌéni kíxin ntaha tjekoárá chꞌán. A̱ ntá jehe chꞌán tsꞌikon kíxin xi̱kaha ninkexró tsꞌikonhya ntá jehe chꞌán tsjanjon chꞌán nkehe tsꞌayéhérá. ");
INSERT INTO poeNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Ntá tió chrónixje̱hérá Dios la chrókja̱te̱ehya chrónixjará kíxin chrókóyóa̱hyará éxí tí sín chónhya Dios kíxin jehe sín tjenka̱yáxin sín kíxin nchónhya tsonixja sín, la mé xi̱kaha mé chrókuinhin Dios, ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","A̱ ntá jahará chrókóyóa̱hyará éxí tí jehe sín. Itꞌéni ó nohe chꞌán nkehe tꞌichjánxi̱nhanrá kjónté na̱xa̱ tjanchéhyará chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Méxra̱ xi̱kihi chróntáchrorá: Itꞌéni tjen nkaya nka̱jní jaha imá tjóá. ");
INSERT INTO poeNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Chrókui tí kjuachaxin kuènta. Chrókjui̱chꞌe tí nkehe tóxrjínhan jaha ntihi chjasintajni éxí tjechꞌe nkaya nka̱jní. ");
INSERT INTO poeNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ijie la tsjánjuan tí nio̱tja̱ tꞌichjánxi̱nhinni. ");
INSERT INTO poeNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Tꞌoxíka tí nkehe jínahya kjuíchꞌeni kíxin kja̱xin jeheni tsꞌitjáyenhenni tí nkehe kjuíchꞌeheni chojni. ");
INSERT INTO poeNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ti̱to̱éhyani kíxin xra̱hya chrókjuasinni jie̱. Nchekaáni kaín tí jínahya chrókónhenni, kíxin jaha mé kuèntá tí kjuachaxin kíxin ó noheni kíxin jaha tjetéto̱an tí kjuachaxin jnkochríxín. Amén. ");
INSERT INTO poeNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Tí jahará tsꞌitjáyanhanrá tí nkexro kjuasinhanrá ichrén jie̱ la mé kja̱xin Itꞌéni tjen nkaya nka̱jní mé tsꞌikon chꞌán kíxin xi̱kaha kjui̱chꞌerá la ntá kja̱xin jehe chꞌán tsꞌóxíka chꞌán tí jie̱ kjuásinrá. ");
INSERT INTO poeNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","A̱ ntá tí jahará tsꞌitjáyanhyará tí jie̱ kjuasinhanrá í jnko chojni la ntá kja̱xin Itꞌéni tjen nkaya nka̱jní tsꞌikon kíxin xi̱kaha kjui̱chꞌerá kꞌuitjáyanhyará la ntá kja̱xin jehe chꞌán la tsꞌóxíkahya chꞌán tí jie̱ chontará. ");
INSERT INTO poeNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’A̱ ntá tí jahará tí na̱xa̱ kjóntehyará kíxin tjinkáonrá tsonixje̱hérá Dios la ntá chrókꞌuejohyará éxí tꞌavárá éxí chꞌe tí sín jehya jnkojínxón tjenka̱yáxin sín. Mé xi̱kaha chꞌe sín kíxin tjinkaon sín tsꞌikon chojni kíxin na̱xa̱ kjónehya sín. Tí xi̱kaha chꞌe sín la janhan ntáxrja̱n kíxin ó kjuixin kꞌuáyéhe̱ sín nkehe la í tsꞌáyèhya sín ínaá. ");
INSERT INTO poeNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","A̱ ntá tí jahará kjónté na̱xa̱ kjóntehyará kíxin tjinkáonrá tsonixje̱hérá Dios la tꞌontirá ikonrá la tjéntoárá kjárá ");
INSERT INTO poeNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","kíxin tso̱noehya chojni kíxin na̱xa̱ kjóntehyará. Jehó Itꞌéni tjekoará ntiha mé jehe chꞌán nohe chꞌán xi̱kaha ntá tsjanjon chꞌán nkehe tsꞌayéhérá. ");
INSERT INTO poeNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Jahará chrókjuásitonhyará nkehe tjete ntihi chjasintajni kíxin ntihi la tsꞌín kué tí nkehe tjete sinchekꞌitjáyanhanrá va la ko tso̱chji̱sen tí chichaon la ko xíche̱e tsꞌixenhen tsaáhará. ");
INSERT INTO poeNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Íchá jína tjásitonrá tí nkehe tjete nkaya nka̱jní kíxin ntaha kohya iko sinchekꞌitjáyan nkehe la tso̱chji̱senhya tí nkehe la ko kohya xíche̱e tsꞌixenhen tseé. ");
INSERT INTO poeNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","A̱ ntá tí nkaya nka̱jní tsochontará nkehe tjete la ntá tí nkehe tjenka̱yáxinrá la kja̱xin ntaha tjen. ");
INSERT INTO poeNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Tí ikonrá mé éxí yóhe̱ ijnko xrohi tꞌinkáséyanxín tí cuerpo kuèntárá. Tí jína ikonrá la ntá kja̱xin kuenté ti cuerpo kuèntárá mé chónta xrohi. ");
INSERT INTO poeNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","A̱ ntá tí ikonrá la jínahya la ntá kuenté tí cuerpo kuèntárá la sítié tjen. A̱ ntá tí chrókjuakꞌehya tí xrohi la ntá a̱ntsí má chrókjuinchetié tí sítié. ");
INSERT INTO poeNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Kohya ninkexró tsjacha sichꞌehe xra̱ yaá lamó. Tí xi̱kaha chrókjuichꞌe chꞌán la ntá ijnko tso̱nínkakonhen chꞌán la tí í jnko tsotjuèhe chꞌán o̱ ijnko la tsitekakonhen chꞌán la tí í jnko la tsitekakuenhya chꞌán. Méxra̱ xitjahya chrókjuichꞌehe chojni xra̱ Dios tí tjinkaon sín chróchónta sín itsjé chichaon. ");
INSERT INTO poeNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’A̱ ntá ntáxrja̱n kíxin chrókóxakuanhyará tí nkehe chrókjónterá o̱ tí nkehe chrókꞌuirá o̱ tí ka chrókꞌuítsa̱rá. ¿Á jehya a̱ntsí má sínkí tí kjuachón chróchontará, a̱ ntá kánhyó sínkí tí nkehe chrókjónterá, la á jehya a̱ntsí má sínkí tí cuerpo kuèntárá, a̱ ntá kánhyó sínkí tí ka chrókꞌuítsa̱rá? ");
INSERT INTO poeNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Xráxinkáonrá nkexrí siín tí koxroxe xritjaka. Jehe va la tꞌe̱nka̱hya va noa la ko tjáhya va la ko chóntahya va nketí tsꞌi̱nka̱chji̱nayá va tí noa, la kjánchó Itꞌéni tjen nkaya nka̱jní la tjanjon chꞌán nkehe sine va. A̱ ntá jahará mé a̱ntsí tjetoan a̱ ntá tí koxroxe la kénhyó. ");
INSERT INTO poeNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Á tjejó jnkojínrá tjenka̱yáxinrá kíxin tí chrókóxakonhanrá imá a̱ ntá na̱xa̱ chrókꞌuankírá itꞌo̱ metro nte̱toxinrá ínaá? ");
INSERT INTO poeNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿Nkekuènté kíxin imá tóxakonhanrá ikárá ó? Tsjehérá nkexrí sítꞌánkí tí catsjo siín nte̱je̱. Tí itsjo la ní chꞌehya xra̱ la ko tjo̱nhya. ");
INSERT INTO poeNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","La tjo̱nka̱rá kíxin kjónté chꞌín rey Salomón kꞌuéchónta itsjé chichaon la na̱xa̱ kjuíncheyóe̱hya chꞌán nkexrí náxrjón tsjehe tí tsjo a. ");
INSERT INTO poeNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","A̱ ntá tí Dios la nchekꞌitsa tí ka yoa siín nte̱je̱ kjónté ijie síchón ka la ntóye tsochexín tí nkaxenhen tja̱, a̱ ntá jahará mé a̱ntsí chrókjuintakꞌitsará chꞌán. ¿A̱ ntá nkekuènté títekákonhyará chꞌán? ");
INSERT INTO poeNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Méxra̱ xi̱kaha chrókóxakuanhyará chrókjuanchankíhyará kíxin nkehe chrókjónterá o̱ nkehe chrókꞌuirá o̱ nkehe chrókꞌuítsa̱rá. ");
INSERT INTO poeNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kaín tí nkehe la tí sín chónhya Dios mé tóxakonhen sín tíha. A̱ ntá jahará chontará Itꞌéni tjen nkaya nka̱jní la mé nohe chꞌán kaín nkehe tꞌichjánxi̱nhanrá. ");
INSERT INTO poeNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","A̱ ntá senó mé chrókjuéyárá tí kjuachaxin kuènté Dios la chrókjui̱nchexiteyárá tí nkehe jína tjinkaon chꞌán, a̱ ntá jehe chꞌán mé tsjanjon chꞌán kaín nkehe tꞌichjánxi̱nhanrá. ");
INSERT INTO poeNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Tóxakuanhyará tí nkehe tso̱nhen ntóye xi̱kaha kíxin ntóye la í jnko ya̱on táha la jnkojnko ya̱on tji̱ka̱o kjuaxikaon kuènte. ");
INSERT INTO poeNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Chrókuékahyará ókjé chojni jie̱ kíxin ntá Dios kja̱xin chrókjuanchahya jie̱ tí jahará. ");
INSERT INTO poeNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","A̱ ntá Dios la tsjanchia chꞌán jie̱ tí jahará tí tsékará ókjé chojni jie̱. A̱ ntá tí xi̱kaha si̱chꞌerá la mé xi̱kaha tso̱nhanrá kja̱xin. ");
INSERT INTO poeNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿A̱ ntá nkekuènte tsjehé tí chji̱nínó ntsí tjenkánkí ikon tí kíchuá tí na̱xa̱ ánto̱sán tí inta jié tjenkánkí ikuan? ");
INSERT INTO poeNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","A̱ ntá tí chonta jaha tí nta jié tjenkánkí ikuan, ¿a̱ ntá nkexrí kíxin chróntáche tí kíchuá kíxin: “Ti̱to̱hé tsakitsjenkíni tí chji̱nínó ntsí tjenkánkí tí kuan?” ");
INSERT INTO poeNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","A̱ ntá jaha la ntoáhya tjenka̱yáxian. Senó chrókuakitsjenkiá tí nta jié tjenkánkí ikuan kíxin ntá chrókꞌuikuan tsakitsjenkiá chji̱nínó ntsí tjenkánkí ikon tí kíchuá. ");
INSERT INTO poeNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Chróchje̱éhyará tí nkehe tsíkótjóá tí koni̱a̱ kíxin jehe va tsokjan va tso̱nínkakonhanrá va ntá sinchekuenrá va. La ko kja̱xin chróchje̱éhyará tí cochíno tí xro̱ perla tjete kíxin tsinkátja va la tso̱kuen. ");
INSERT INTO poeNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Tjanchiará nkehe la Dios tsotjáhará. Tjéyárá nkehe la tsꞌitjará. Tꞌinkará puerta la ntá tsoxitje̱he̱. ");
INSERT INTO poeNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kíxin tí nkexro tjanchia nkehe la tsꞌáyéhe̱ tí nkehe la tí nkexro tjeyá nkehe la tsꞌitja la tí nkexro tꞌínka puerta la tsoxitje̱he̱. ");
INSERT INTO poeNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’¿Á tjejó jnkojín nkexro ntihi chrókjuanjon xro̱ chrókjóne xje̱en tí chrókjuanchia xjan nio̱tja̱? Kja̱ náhí. ");
INSERT INTO poeNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O̱ tí chrókjuanchia xjan ijnko koche la, ¿á chróchjéhe chꞌán tí xje̱en chꞌán konche chrókjóne ní? Kja̱ náhí. ");
INSERT INTO poeNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","A̱ ntá jahará kjónté jínahyará la ó nohará nkehe jína chje̱hérá xja̱anrá. A̱ ntá Itꞌéni tjen nkaya nka̱jní kja̱xin a̱ntsí tsochjéhe chꞌán nkehe jína tí nkexro tsjanchia nkehe. ");
INSERT INTO poeNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Méxra̱ xi̱kaha chrókjuíkosáyehérá kíchuárá éxí yóhe̱ nkexrí tjinkáonrá chrókjuikosáyahará sín mé xi̱kaha kꞌue̱to̱an chꞌín Moisés la ko xi̱kaha ntáchro tí xroon kuènte tí sín kꞌuéchrónka itén Dios ósé. ");
INSERT INTO poeNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Tꞌixe̱enxínrá tí puerta tekahya. Kíxin tí puerta la ko tí nti̱a tsꞌitjáyanxín chojni la imá iton la ko teka la nchónhya chojni sátsji tí nti̱a ntiha. ");
INSERT INTO poeNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","A̱ ntá tí puerta la ko tí nti̱a sátsji̱xinni tí kjuachón la tekahya ntiha la ko tsjéhya chojni tsꞌitja tí nti̱a a. ");
INSERT INTO poeNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Méxra̱ tóxakonhanrá tí tsꞌikonrá itsi tí sín chꞌia tsontáchro sín kíxin kja̱xin sín nixja sín itén Dios. Jehe sín la chrítaón ó tjo̱é kolélo ó, a̱ ntá nkaya la kolobo jie̱he. ");
INSERT INTO poeNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Jahará la chrókjuátso̱anxínrá tí jehe sín kíxin tí xra̱ chꞌe sín kíxin tí ntachꞌi̱ la xitjahya chrókꞌóna to uva la ko tí kachꞌi̱ xitjahya chrókꞌóna to higo. ");
INSERT INTO poeNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Méxra̱ kaín inta jína la tꞌóna to jína la ntá tí nta jínahya la kja̱xin tí to la jehya to jína. ");
INSERT INTO poeNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Tí nta jína la xitjahya chrókꞌóna to jínahya, la ko tí nta jínahya xitjahya chrókꞌóna to jína. ");
INSERT INTO poeNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kaínxín tí nta tꞌónahya to jína mé tsochrínjin la tsoche. ");
INSERT INTO poeNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Mé xi̱kaha chrókjuatso̱anxínrá jahará tí sín jehya jína kíxin tí xra̱ tjejóchꞌe sín. ");
INSERT INTO poeNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Kénhya chojni tsontáchro: “Ìnchéni, Ìnchéni”, mé tsꞌixenhen sín tí kjua̱cha̱xién Dios tjen nkaya nka̱jní. Náhí. Jehó tí nkexro sinchexiteyá tí nkehe tóxrjínhi̱n Tꞌaná tꞌe̱to̱an tjen nkaya nka̱jní. ");
INSERT INTO poeNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Tsjixraká tí ya̱on a la ntá itsjé sín tsontáchro sín kíxin: “Ìnchéni, Ìnchéni, kꞌuénixjaxínni ihni̱á la ko tí ihni̱á mé kuakitsjexínni ncha̱kuen tí jínahya la ko kjua̱cha̱xién ihni̱á kjuasixínni nchónhya kjuaxroan.” ");
INSERT INTO poeNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","A̱ ntá janhan tsjata̱ha̱ kíxin: “Janhan la chonhya tí jahará. Ti̱to̱nará sátjirá kíxin jahará imá jínahyará.” ");
INSERT INTO poeNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Méxra̱ tí nkexro tinhin tí nkehe ntáxrja̱n la titekaon chꞌán la jehe chꞌán mé éxí yóhe̱ ijnko nkexro chónta kjuaxrexinkaon jína la kjuíchꞌéna nchia chrítaón tjo̱. ");
INSERT INTO poeNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","A̱ ntá xrína̱hya xrakoa chrin, ikui yeé nta̱ninche la tji̱a̱n chjéhe xri̱nto̱ la kjónté xi̱kaha la xíkahya tí nchia kíxin itjo̱ tjekjen nchia. ");
INSERT INTO poeNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","A̱ ntá tí nkexro tinhin tí xrja̱nka la titekakonhya mé jehe la éxí yóhe̱ ijnko nkexro lo̱nti̱ la kjuíchꞌéna chꞌán ijnko nchia tí siín nchesen. ");
INSERT INTO poeNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","La ntá xrína̱hya xrakoa chrin ntá a̱ntsí kóyeé nta̱ninche tí tsa̱ka la ko chjéhe xri̱nto̱ la ntá xíka tí nchia, la ijnko kjuachrakon kónhen tíha. ");
INSERT INTO poeNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","A ntá tió kjuixin nixja chꞌín Jesús la ntá imá chrakon tí chojni kíxin nkexrí kjuako chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Kíxin kjuako chꞌán éxí ijnko nkexro chónta imá kjuachaxin la tóyóe̱hya chꞌán tí sín maestro kjuako tí ley. ");
INSERT INTO poeNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","A̱ ntá chꞌín Jesús kꞌuínkaji̱nxi̱n chꞌán tí jna̱ la chréhe̱ nchónhya chojni. ");
INSERT INTO poeNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","La ntá kóchjina ijnko chꞌín níhi chónta chin lepra la kjuákꞌexín tochꞌin chꞌán nkayakon chꞌín Jesús la ntáchro chꞌán kíxin: ―Ìnchéni tí tjinkávan la jína chrókjui̱nchekito̱héni jína ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ntá chꞌín Jesús mé kjuakꞌetja itja chꞌán chrítaón tí chꞌín a la ntáchro chꞌán kíxin: ―Méxra̱ xi̱kaha tjínka̱van. Ntá jie si̱ntakito̱ha jína. A̱ ntá tuénxín kuíto̱he chꞌán jína la ó kjuìin tí chin kꞌuéchónta chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","La ntá ntáchro chꞌín Jesús kíxin: ―Ninkexró che̱nkahya ntihi. Jehó sátjia tjákohé tí chꞌín ncha̱tꞌá kíxin kuíto̱ha jína la ko sátjíkoa tí nkehe tsíkꞌe̱to̱an chꞌín Moisés kíxin ntá xi̱kaha tso̱noexín kaín xín chojni kíxin ó kuíto̱ha jína ―mé xi̱kaha kꞌue̱to̱an chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","A̱ ntá tió kꞌuíxenhen chꞌín Jesús chjasin Capernaum la ntá xrína̱hya kóchjina ijnko capitán romano la chrónòa chꞌán ");
INSERT INTO poeNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ntáchro chꞌán kíxin: ―Ìnchéni nto̱eni itjen ijnko chꞌín chꞌeheni xra̱ mé níhi chꞌán, tjetsínka chꞌán, tsíkꞌen to̱té chꞌán la imá tjotéhe chꞌán ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","A̱ ntá chꞌín Jesús kjuáte̱he chꞌán ntáchro chꞌán kíxin: ―¿Á sátsjia si̱ntakito̱ha̱ jína tí chꞌín a? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ntá tí chꞌín capitán kjuáte̱he kíxin: ―Náhí, Ìnchéni, tósuèheni kíxin chrókꞌuixe̱nhén nto̱eni kíxin jehya chojni jínani. Jehó chrókjuánjuan kjuachaxin kuèntá, ntá tí chꞌín chꞌeheni xra̱ chrókuito̱he chꞌán jína. ");
INSERT INTO poeNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Janhan na kja̱xin chonta chojni tꞌe̱tua̱nna la ko kja̱xin janhan tétua̱nha̱n tí sín soldado. Tió tétua̱nha̱n ijnko sín sátsji sín la ntá ó sátsji sín. La kja̱xin tió tétua̱nha̱n ijnko sín kíxin xrakoa sín la mé tji sín. La ko tió tétua̱nha̱n ijnko nkexro chꞌena xra̱ kíxin sichꞌe xra̱ la ichꞌe xra̱ ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ntá kuínhin chꞌín Jesús ntá kóxakonhen chꞌán kíxin xi̱kaha chro tí chꞌín a, ntá nixje̱he̱ chꞌán tí sín chréhe̱ chꞌán ntáchro chꞌán kíxin: ―Chaxín ntáxrja̱n kíxin kuenté tí nación Israel la kꞌuitjahya janhan ninkexró tinkáchónki xi̱kaha éxí tinkáchónki tí chꞌín i. ");
INSERT INTO poeNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Janhan xrja̱nka kíxin nchónhya chojni ókjé tji̱xi̱n tí tji̱to̱xi̱n ya̱on la ko tí tjiátóxin ya̱on la sineko sín tí chꞌín Abraham la ko Isaac la ko Jacob tí tjen tí kjuachaxin kuènte Dios. ");
INSERT INTO poeNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","A̱ ntá itsjé tí sín chrókꞌuejó tí tjen tí kjuachaxin kuènte Dios la tsꞌaxrjexín sín ntiha, sátsji sín tí sítié la ntaha tsotsjánka sín la sinetaón neno sín. ");
INSERT INTO poeNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","La ntá chꞌín Jesús mé nixje̱he̱ chꞌán tí chꞌín capitán ntáchro chꞌán kíxin: ―Sátjia nto̱a. Éxí kuítekávan jaha la tsoxiteyá tso̱nhen tíha ―ichro chꞌán. La ntá tí chꞌín chꞌe xra̱ la o tuénxín tí hora a tsíkito̱he chꞌán jína. ");
INSERT INTO poeNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","A̱ ntá sákjuí chꞌín Jesús tí nto̱e chꞌín Pedro la ntaha kꞌuíkon chꞌán kíxin tí ichꞌe̱e chꞌín Pedro la níhi tjan tjetsínka tjan la chónta tjan sóa. ");
INSERT INTO poeNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ntá itsé chꞌán itja tjan la ntá kjuìinhin tjan tí sóa la ntá kꞌuínkatjen tjan la kjuankíxin yaxínhin tjan kíxin tsjanjon tjan nkehe sine sín. ");
INSERT INTO poeNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","La ntá tí ó kóntanonte ntá kjuikohe sín chꞌín Jesús nchónhya chojni chónta ncha̱kuen tí jínahya. La ntá jnkoko̱á nixja chꞌán la kꞌuaxrjexín tí ncha̱kuen tí jínahya tí jehe sín la kja̱xin kjuínchekito̱he chꞌán jína kaín tí si̱nníhi. ");
INSERT INTO poeNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Mé xi̱kaha kjuíchꞌe chꞌán kíxin tsoxiteyá tí nkehe tsíchrónka tí chꞌín Isaías tí chꞌín kꞌuéchrónka itén Dios. Mé ntáchro chꞌán xi̱kihi: “Jehe chꞌán kuákja chꞌán tí chin chóntani la ko jehe chꞌán kuámá chꞌán tí kjuatjoté.” Mé xi̱kaha ichro itén Dios. ");
INSERT INTO poeNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Tió kꞌuíkon chꞌín Jesús kíxin nchónhya chojni kꞌuántatjen sín chꞌán la ntá kꞌue̱to̱an chꞌán kíxin tsꞌátòye̱ sín í jnko chrínta nta̱. ");
INSERT INTO poeNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","La ntá ijnko tí sín maestro tjako tí ley mé kóchjinehe chꞌán tí chꞌín Jesús la ntáchro chꞌán kíxin: ―Maestro tjinkaonni chróchréhe̱ni tí jaha kjónté nketí tjinkávan sátsjia ―ichro tí chꞌín a. ");
INSERT INTO poeNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","La ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Tí koxróntá chónta va itjue̱é va la ko tí koxroxe chónta va ka̱ké va. A̱ ntá tí Xje̱en Dios Kꞌóna Chojni mé chóntahya nketí tsꞌo̱kꞌèxin chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","A̱ ntá ijnko tí chojni kꞌuájiko chꞌán, mé ntáchro chꞌán kíxin: ―Ìnchéni, ti̱to̱héni senó sátsjikja̱váni itꞌéni ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","La ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Náhí, chréhé tí janhan. Ti̱to̱hé kíxin tí chojni tsíkꞌen la jnkokón sín tsíkꞌen tsja̱vá kíchó sín ―mé xi̱kaha ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ntá chꞌín Jesús kꞌuíxenhen tí ntabárco̱ la kꞌuíxenko chꞌán tí sín kꞌuájiko chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","La ntá xrína̱hya imá síchrica nta̱ la ó chjina sítikia nta̱ tí ntabárco̱. La kjánchó chꞌín Jesús la tjejua chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","La ntá tí sín kꞌuájiko chꞌán kjuínchekꞌàya sín chꞌán la ntáchro sín kíxin: ―Ìnchéni nchekaáni kíxin tí ntabárco̱ la ó meró tsꞌaniánkí nta̱ ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ntá kjuáte̱he chꞌán ntáchro chꞌán kíxin: ―¿Nkekuènté kíxin imá chrakonrá? Intsíkoá tinkachónkirá Dios ―ichro chꞌán. Kjuixin ntáchro chꞌán xi̱kaha ntá kꞌuàya chꞌán la kꞌue̱tue̱nhen chꞌán tí xri̱nto̱ la ko tí nta̱yaon la ntá tuénxín kꞌuixrata. ");
INSERT INTO poeNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","La ntá imá chrakon sín la ntáchro sín kíxin: ―¿Xá nkexro tíhi? Kjónté xri̱nto̱ la ko nta̱yaon la mé nchexiteyéhe̱ chꞌán ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ntá tió kꞌuátòye̱ chꞌín Jesús tí nta̱yaon a̱ ntá kjuíji sín tí nonte Gadara. La ntá yaá chojni chónta ncha̱kuen tí jínahya kꞌuaxrjexín tòyé chojni tsíkꞌen la kóchjinehe sín chꞌán. Jehe sín mé imá jie̱he sín la kohya ninkexró tjacha tsꞌatsínka tí nti̱a ntiha. ");
INSERT INTO poeNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","La ntá kjuankíxin kꞌóyako sín ntáchro sín kíxin: ―Tjia̱téhya jaha tí jeheni jaha Jesús mé Xje̱en Dios. ¿Á kꞌuinka ntihi kíxin si̱nchekjasóteni kjónte na̱xa̱ kjuixrakáhya tí ya̱on tsjasóteni? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","A̱ ntá ntiha kánhyó kjín siín itsjé cochíno xrine va. ");
INSERT INTO poeNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","La ntá tí ncha̱kuen tí jínahya mé chrónóe̱he̱ tí chꞌín Jesús kíxin: ―Tí tséto̱an kíxin sátsjini la chrókjuánjuan kjuachaxin chrókꞌuixenhenni tí cochíno ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ntá ntáchro chꞌín Jesús kíxin: ―Tí xi̱kaha la sátjia ―ichro chꞌán. La ntá tí ncha̱kuen tí jínahya a mé kꞌuaxrjexín tí chojni la kꞌuíxenhen tí cochíno. La ntá kaín xín tí cochíno kuinká va, kꞌuínkaji̱nxi̱n va ntiha kjuítsínkayá va tsa̱ka, ntá kjuítsínkankí va nta̱, kjuínhin va nta̱. ");
INSERT INTO poeNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","La ntá tí chojni tꞌayakonhen tí cochíno mé chrakon sín ntá kuinká sín sákjuí sín chjasin la kjuankíxin chrónka sín kaín tí nkehe kónhen la ko kaín nkehe kónhen tí sín kꞌuéchónta tí ncha̱kuen tí jínahya. ");
INSERT INTO poeNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","A̱ ntá kaín tí sín chjasin ntiha sákjuítsjehe sín ntá kjuíji sín tí tjen chꞌín Jesús ntá kꞌuíkon sín kíxin xi̱kaha tsíkónhen la chrónóe̱he̱ sín chꞌán kíxin sáchrókjui chꞌán ókjé. ");
INSERT INTO poeNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","La ntá kjuixin tíha ntá chꞌín Jesús mé kꞌuíxenhen chꞌán ijnko ntabárco̱ la kꞌuátsínka chꞌán í jnko lado chrínta nta̱ la kjuíji chꞌán chjasén chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","A̱ ntá ntiha kui̱ka̱o sín ijnko chꞌín tsíkꞌen to̱té la tjetsínkatákꞌá ijnko kania. Ntá kꞌuíkon chꞌín Jesús kíxin chaxín tinkáchónki sín chꞌán la ntá nixje̱he̱ chꞌán tí si̱nníhi ntáchro chꞌán kíxin: ―Xje̱enni nchechéhé a̱sán. Tí jie̱ chonta la ó kjuixin kjuìinhan ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","La ntá iso tí sín maestro tjako tí ley mé jehó sín ikjo sín a̱sén sín, ntáchro sín kíxin: ―Tí chꞌín i mé ncheyóhe̱ chꞌán a̱sén chꞌán Dios kíxin xi̱kaha nixja chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ntá chꞌín Jesús mé ó nohe chꞌán kíxin nkehe tí kjo sín a̱sén sín ntá ntáchro chꞌán kíxin: ―¿Nkekuènté kíxin xi̱kaha jínahya tjenka̱yáxinrá? ");
INSERT INTO poeNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Nkehe a̱ntsí xra̱hya chróntátjan chꞌán? ¿Á a̱ntsí xra̱hya chróntátjan chꞌán kíxin ó kjuixin kjuìinhin chꞌán tí jie̱ yámá chꞌán o̱ á a̱ntsí xra̱hya chróntátjan chꞌán kíxin chrókꞌuínkatjen chꞌán sáchrókjui chꞌán? ");
INSERT INTO poeNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Méxra̱ tsjáko̱xia̱n kíxin tí Xje̱en Dios Kꞌóna Chojni mé ntihi chjasintajni chónta kjuachaxin tsjakjìinhin iji̱é chojni. Ntá ntáche chꞌán tí si̱nníhi a kíxin: ―Ijie la tꞌinkatjen tjatsíyan ka̱nia̱a na sátsjia nto̱a ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ntá tí chꞌín tsíkꞌen to̱té na tuénxín kꞌuínkatjen chꞌán la sakjuí chꞌán nto̱e chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ntá kaín tí sín siín ntiha kꞌuíkon sín kíxin xi̱kaha kónhen la imá chrakon sín la kjuanchehe sín Dios kjuasáya kíxin tí nkexro imá kjua̱ko̱xi̱n chꞌán kjuachaxin kuènte Dios. ");
INSERT INTO poeNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","A̱ ntá chꞌín Jesús sákjui̱xi̱n chꞌán ntiha la kꞌuíkon chꞌán ijnko chꞌín itꞌin Mateo tjetja̱xi̱n chꞌán ntiha nchekjènki̱ chꞌán. Ntá ntáchro chꞌín Jesús kíxin: ―Chréhé tí janhan ―ichro chꞌán. Ntá chꞌín Mateo tuénxín kꞌuínkatjen chꞌán chréhe̱ chꞌán tí chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","A̱ ntá chrꞌéxi̱n chꞌín Jesús kjuákꞌe chꞌán nto̱e tí chꞌín Mateo la ntaha xranjon nkehe sine chꞌán la ntá itsjé tí sín nchekjènki̱ la ko í so sín chónta jie̱ mé kjuíji sín la kja̱xin kjóneko sín tí chꞌín Jesús la ko tí sín kꞌuájiko chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","La ntá tí sín fariseo kja̱xin kꞌuíkon sín xi̱kaha la kjuanchankíhi sín tí sín kꞌuájiko chꞌín Jesús, ntáchro sín kíxin: ―¿Nkekuènté kíxin tí chꞌín maestro kuèntárá mé neko chꞌán tí sín nchekjènki̱ la ko tí í so sín chónta jie̱? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ntá chꞌín Jesús la kuínhin chꞌán nkehe tí tjo sín la ntáchro chꞌán kíxin: ―Tí sín níehya la tꞌichjánxi̱enhya sín nkexro sichꞌe xro̱a̱n. Náhí. Jehó tí chojni níhi mé tꞌichjánxi̱nhin sín nkexro sichꞌehe sín xro̱a̱n. ");
INSERT INTO poeNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Sátjirá la tsꞌítjará nkexrí tꞌaxrjexín tí nkehe ntáchro xroon itén Dios. Mé ntáchro kíxin: “Janhan tjínka̱van kíxin chrókui̱konóe̱hérá chojni la tjínka̱konhya kíxin chrókꞌoyánrá iko chrókjuánjonrá.” Mé xi̱kaha ichro itén Dios. Janhan na kꞌuinkahya ntihi kíxin chrókꞌuíya̱ha̱ chojni jína tjejó. Náhí. Kꞌuinka kíxin tsꞌíya̱ha̱ tí chojni chónta jie̱ kíxin chrókuíto̱he sín tí iji̱é sín ntá chrókjuinkí sín tí tjenka̱yáxin sín ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ntá iso tí sín kꞌuékꞌajiko tí chꞌín Juan Bautista mé kóchjinehe sín chꞌín Jesús la kjuanchankíhi sín chꞌán, ntáchro sín kíxin: ―Jeheni la ko tí sín fariseo la jnkoya̱xon nehyani, a̱ ntá tí sín xrikoá la, ¿nkekuènte xi̱kahya chꞌe sín? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ntá kjuáte̱he chꞌín Jesús, ntáchro chꞌán kíxin: ―¿Xá chrókꞌuává kaín tí sín tsíkꞌíye̱he̱ sín tso̱chjina tso̱te̱he ijnko chojni kíxin na̱xa̱ tjen tí chꞌín tsíkóte̱he tjejóko sín ntiha? A̱ ntá tsjixraká ijnko ya̱on tsotsé sín tí chꞌín tsíkóte̱he sátsjiko sín chꞌán ntá kaín tí sín tsíkóchjina mé tsꞌává sín la í sinehya sín. ");
INSERT INTO poeNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Nijnko chojni chrókjuakꞌenie̱he tí ka ó ntaxin itꞌo̱ ka ni̱xin kíxin ntá chrókjui̱xéhe̱ tí ka ni̱xin chrókꞌuítji̱a̱n tí ka ntaxin ntá a̱ntsí má chrókꞌuichje. ");
INSERT INTO poeNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","La ko kja̱xin éxí yóhe̱ chrókui̱ki̱ahya chojni xranvino ni̱xin ijnko tjua̱xran ó ntaxin kíxin tí xi̱kaha chrókjuichꞌe sín ntá chrókꞌuichje ti tjua̱xran ntaxin. Ntá chrókꞌuitjáyan tí xran la ko chrokꞌuitjáyan tí tjua̱xran. Ntá tí xranvino ni̱xin chrókuikia ijnko tjua̱xran ni̱xin la ntá xi̱kaha la yóí nkehe chrókꞌuitjáyanhya. ");
INSERT INTO poeNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ntá na̱xa̱ tjenixja chꞌín Jesús la ntá ikjui ijnko chꞌín tꞌe̱to̱an kuènte tí sín judío la kjuákꞌexín tochꞌin chꞌán nkayakon tí chꞌín Jesús la chrónóe̱he̱ chꞌán kíxin: ―Tí xja̱nna na ntá kjuixin kꞌuén. Xrja̱nóa̱ha sáchrókjuini chrókjuakétja tjá jehe tjan ntá chróxechón tjan ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ntá kꞌuínkatjen chꞌín Jesús ntá sákjuíko chꞌán tí chꞌín a la ko sákjuíkotoxi̱n chꞌán tí sín kꞌuájiko chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","A̱ ntá itjen ijnko chojni chjin níhi tjan, ó teyó nánó chónta tjan ijnko chin tsꞌítji tjan jni̱. Ntá kóchjina tjan nóton tí chꞌín Jesús ntá kuákóxi̱n tjan tí iké chꞌán ");
INSERT INTO poeNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","kíxin tjenka̱yáxin tjan kíxin kjónté chrínta iké chꞌán ó chrókuákóxi̱n tjan, la táhó chrókuíto̱exín tjan jína. ");
INSERT INTO poeNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ntá nkátjíá chꞌín Jesús la kꞌuíkon chꞌán tí tjan a ntá ntáchro chꞌán kíxin: ―Xje̱enni, nchechéhé a̱sán jaha. Jaha la ó kuíto̱ha jína kíxin kuítekávan tí janhan ―ichro chꞌán. Na ntá tuénxín ó kuíto̱he tjan jína. ");
INSERT INTO poeNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ntá tió kjuíji chꞌín Jesús nto̱e tí chꞌín judío tꞌe̱to̱an la kꞌuíkon chꞌán kíxin ó yaxínhin tí sín músico kíxin ó sátsjixravá xjan. La kaín tí chojni tsíkójnkotsé la tsjánkàma̱ sín xjan. ");
INSERT INTO poeNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","La ntá ntáchro chꞌín Jesús kíxin: ―Tí xjan méhe̱ ti̱to̱hérá, kíxin tsíkꞌenhya xjan, la tjejua xjan ó ―ichro chꞌan. Ntá kjuanoá sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","A̱ ntá tí kꞌuaxrje kaín chojni la ntá chꞌín Jesús la kꞌuíxenhen chꞌán la itsé chꞌán itja tí tjan a la ntá tuénxín kꞌuínkatjen tjan. ");
INSERT INTO poeNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ntá kuenté chjasin ntiha la kuínhin sín kíxin xi̱kaha kónhen. ");
INSERT INTO poeNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ntá sákjuíxin chꞌín Jesús ntiha la ntá yaá chojni tꞌikonhya kjuíchréhe̱ tí jehe chꞌán la kꞌuíye̱he̱ sín chꞌán ntáchro sín kíxin: ―Ti̱konóe̱héni jaha tsíkꞌaxrjeníxian David. ");
INSERT INTO poeNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ntá kꞌuíxenhen chꞌín Jesús ijnko nchia na ntá kóchjina tí yaá sín tꞌikonhya la ntá chꞌín Jesús kjuanchankíhi sín chꞌán, ntáchro chꞌán kíxin: ―¿Á títekávan kíxin tsjácha si̱tꞌa xi̱kaha? ―mé xi̱kaha kjuanchankí chꞌán. Ntá kjuáte̱he sín kíxin: ―Jeén, Ìnchéni, titekaonni. ");
INSERT INTO poeNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ntá chꞌín Jesús kjuakꞌetja tja chꞌán chrítaón ikon sín la ntáchro chꞌán kíxin: ―Tí xi̱kaha kuítekávan la tsoxiteyá ―mé xi̱kaha ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","La ntá tuénxín ó jína tꞌikon sín. Ntá chꞌín Jesús kꞌue̱tue̱nhen sín chꞌán kíxin: ―Ninkexró tsoche̱nkahyará ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ntá tuénxín sákjuí sín la nkuíxín chjasin ntiha chrónka sín tí kjuaxroan kjuasin chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Tió sákjuí tí sín kꞌuékꞌikonhya, a̱ ntá iso chojni kjui̱ka̱o sín ijnko chꞌín nósin chꞌán la chónta chꞌán ncha̱kuen tí jínahya. ");
INSERT INTO poeNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ntá chꞌín Jesús kuakitsje tí ncha̱kuen tí jínahya ntá tí chꞌín nósin la ó kjuankíxin nixja chꞌán. Ntá kaín chojni la kꞌuíkon sín la ntáchro sín kíxin: ―Nunca tꞌikonhyéni ijnko kjuaxroan xi̱kaha kuenté tí nación Israel ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","A̱ ntá tí sín fariseo ntáchro sín kíxin: ―Tí nkexro tꞌe̱tue̱nhen tí ncha̱kuen tí jínahya tsíkjanjon kjuachaxin mé xi̱kaha takitsje tí chꞌín i tí ncha̱kuen tí jínahya ―mé xi̱kaha ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ntá kꞌuátsínka chꞌín Jesús itsjé chjasin jié la ko chjasin ntsí la kjua̱ko̱xi̱n chꞌán jnkojnko ni̱nko Israel. Chrónka chꞌán tí tan jína nkexrí tjen tí kjuachaxin kuènte Dios. La ntá kjuínchekito̱he chꞌán jína chojni níhi chónta kaín xín chin la ko chojni chónta kjuatjoté. ");
INSERT INTO poeNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Kꞌuíkon chꞌán kíxin nchónhya chojni kꞌuéjó sín ntá kui̱konóe̱he̱ chꞌán sín kíxin imá tóxakonhen sín la kꞌuéjó sín éxí kolélo chóntahya nkexro tꞌayakonhen. ");
INSERT INTO poeNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ntá ntáche chꞌán tí sín kꞌuájiko chꞌán kíxin: ―Chaxín ntáxrja̱n janhan kíxin imá tsíkꞌóna, kjánchó chojni sichꞌe xra̱ mé tsjéhya. ");
INSERT INTO poeNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Chrókjuanchehérá tí Ìnché tí nonte kíxin chróchrꞌán chꞌán itsjé chojni chrókjuichꞌe xra̱ ―mé xi̱kaha ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ntá chꞌín Jesús mé kjueyá chꞌán teyó sín tsꞌajiko chꞌán la kjuanjon chꞌán kjuachaxin tsakitsje sín kaín tí ncha̱kuen tí jínahya tꞌe̱tue̱nhen a̱sén chojni la ko sinchekito̱he sín jína kaín chojni chónta kaín chin la ko kaín xín kjuatjoté. ");
INSERT INTO poeNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Na mé tí teyó sín kꞌuájiko chꞌán mé itꞌin sín xi̱kihi: sa̱oxín mé chꞌín Simón na mé kja̱xin itꞌin chꞌán Pedro la ko kíchó chꞌán Andrés la ko chꞌín Jacobo la ko kíchó chꞌán Juan mé tí xje̱en chꞌín Zebedeo. ");
INSERT INTO poeNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","La ko kja̱xin chꞌín Felipe la ko chꞌín Bartolomé la ko chꞌín Tomás la ko chꞌín Mateo mé tí chꞌín nchekjènki̱ la ko chꞌín Jacobo xje̱en chꞌín Alfeo la ko chꞌín Lebeo, mé jehe chꞌán kja̱xin itꞌin chꞌán Tadeo. ");
INSERT INTO poeNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","La ko kja̱xin chꞌín Simón, mé kuènte tí sín cananista, la ko kja̱xin chꞌín Judas Iscariote, mé tí nkexro chrꞌéxi̱n kjuínchekji tí chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ntá kꞌue̱tue̱nhen chꞌín Jesús tí teyó sín kíxin sátsji sín la kꞌue̱to̱an chꞌán kíxin: ―Tjíhyará tí tjejó tí sín jehya judío la ko tꞌixe̱enhyará tí chjasin siín estado Samaria. ");
INSERT INTO poeNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Náhí. Íchá jína sátjírá tí tjejó tí chojni éxí kolélo kjuíchroe kuènte nación Israel. ");
INSERT INTO poeNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Sátjírá tjákohérá sín kíxin kjua̱cha̱xién Dios tjen nkaya nka̱jní la í séhya tsi. ");
INSERT INTO poeNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Si̱nchekito̱hérá jína chojni níhi la ko si̱nchekito̱hérá jína tí sín chónta chin lepra la ko si̱nchexechónrá chojni tsíkꞌen la takítsjerá tí ncha̱kuen tí jínahya. Jahará kja̱xin kui̱to̱nha̱nrá tí kjua̱cha̱xién Dios, méxra̱ chrókjuachahyará jahará kja̱xin. ");
INSERT INTO poeNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Chrókjuikuahyará ninkehó chichaon oro la ko ninkehó chichaon plata la ko ninkehó chichaon cobre ");
INSERT INTO poeNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","la ko tí sátjírá nti̱a la chrókjuíkuahyará ka bolsa la chrókjuíkuahyará yaá ka chrókꞌuínka̱yaterá la ko chrókjuankahyará to̱ka̱tárá la ko chrókjuíkuahyará nta tjíxinrá. Tí nkexro chꞌe xra̱ la jehí siín kjuachaxin ntiha chrókjóne. ");
INSERT INTO poeNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’A̱ ntá tió tsjasánrá ijnko chjasin jié o̱ ijnko chjasin ntsí la tjéyárá ijnko nkexro tsjanjon kjuachaxin la nto̱e sín ntahó chrókuito̱hará ntá tsjixin tí xra̱ ntá sátsjirá. ");
INSERT INTO poeNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","A̱ ntá tió tꞌixe̱nhénrá nto̱e sín la nixje̱hérá sín tjáko̱xi̱nrá jnkojína. ");
INSERT INTO poeNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","A̱ ntá tí chaxín jína a̱sén sín la tsꞌáyéhe̱ sín tí kjuaxróxin, a̱ ntá tí náhí la sátjikorá tí kjuaxroxin. ");
INSERT INTO poeNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","A̱ ntá tí tsochrohya sín tsjanjon sín kjuachaxin tsito̱hará la tjinkakonhya sín tsinhin sín tí nkehe tso̱chro̱nka̱rá na mé tꞌaxrjéxi̱nrá tí nto̱e sín o̱ tí chjasén sín la tꞌoxènjinrá tí inche chónta to̱tárá. ");
INSERT INTO poeNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","A̱ ntá chaxín tjo̱nka̱rá kíxin tió tsjixraká tí ya̱on tsjixixín na mé tí sín chjasin Sodoma la ko tí sín Gomorra kjónté imá kꞌuéchónta sín jie̱ la kánhyó tsjasóte sín, a̱ ntá tí sín chjasin a la a̱ntsí tsjasóte sín kíxin kꞌuéjóxróxinhya sín tí tan chrókuaáxin sín. ");
INSERT INTO poeNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Janhan tsochrꞌan tí jahará éxí yóhe̱ chróchrꞌan kolélo tsꞌejóyakjan kolóbo. Listo chrókꞌuejorá éxí konche xi̱kaha la chrókꞌuejorá éxí kontóá chrókójia̱hyará. ");
INSERT INTO poeNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Chrókóxakonhanrá kíxin itsi chojni tsotsé sín tí jahará la sátsjikoará sín tí tjejó tí sín tꞌe̱to̱an la ko nkaxenhen tí ni̱nko̱é sín tsjatiaxínrá sín. ");
INSERT INTO poeNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","La ntá tsjikaánrá sín tí tjejó tí sín tꞌe̱to̱an la ko tí siín tí sín rey kíxin tinkachónkirá tí janhan. Ntá jína tso̱chro̱nka̱rá kíxin tinkachónkirá tí janhan nkayakon tí jehe sín la ko nkayakon tí sín chónhya Dios. ");
INSERT INTO poeNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","A̱ ntá tió sátsjikoará sín tí tjejó tí sín tꞌe̱to̱an la tóxakuanhyará nkehe tsontáchrorá o̱ nkexrí tsonixjará kíxin tió tsjixraká tí hora la ntá Dios mé tsjinki̱tsará tsonixjará. ");
INSERT INTO poeNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kíxin jehya jahará tsonixjará. Náhí. Tí Ncha̱kuen Itꞌéni mé tsochrónka nkehe tsonixjará. ");
INSERT INTO poeNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Ntá iso chojni mé tsjikaán sín tí kíchó sín kíxin itsꞌen la ko tí itꞌé mé tsjikaán tí xje̱en. A̱ ntá tí xjan mé tsokjan tso̱nínkakonhen tí itꞌé kíxin itsꞌen. ");
INSERT INTO poeNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Kaínxín chojni chjasintajni tso̱nínkakonhanrá sín kíxin tinkachónkirá tí janhan. A̱ ntá tí nkexro tsíto̱ehya tsinkáchónki sín tí janhan hasta tsjéje̱ chjasintajni mé tsaá. ");
INSERT INTO poeNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Tió má chónkíhará sín ijnko chjasin la ntá sátsjirá í jnko chjasin. La ntá chaxín tso̱xrja̱nka kíxin tí Xje̱en Dios Kꞌóna Chojni mé tsokjan tí na̱xa̱ tjixinhya tsꞌatsínkará kaín tí chjasin Israel. ");
INSERT INTO poeNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Tí nkexro xrako̱he̱ la kánhyó tjetoan la tí maestro la a̱ntsí tjetoan, la ko kja̱xin tí nkexro chꞌe xra̱ la tjetoanhya la a̱ntsí tjetoan tí lamo. ");
INSERT INTO poeNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","A̱ ntá tí nkexro xrako̱he̱ chrókjua̱ko̱xi̱n chꞌán éxí tí nkexro kjua̱ko̱he̱ chꞌán la ko tí nkexro chꞌe xra̱ chrókjua̱ko̱xi̱n chꞌán éxí tí lámoé chꞌán chꞌehe chꞌán xra̱. Tí chꞌín ìnché nchia la kja̱xin nchekꞌin sín Beelzebú la kja̱xin tí sín kjéhya xi̱kaha nchekꞌin sín. ");
INSERT INTO poeNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Méxra̱ chróchrakuénhyará chojni. Kohya ninkehó nkehe imó chrókónoehya chojni la ko kohya nkehe tjemá ijie kíxin chrókónoehya chojni chrꞌéxi̱n. ");
INSERT INTO poeNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Tí nkehe tjo̱nka̱rá sítié la tꞌichjánxi̱n tso̱chro̱nka̱rá tió itsi xrohi tꞌinkaséyanxín tí ya̱on. La ko tí nkehe tjo̱nka̱rá ijie ninkexró noehya la tꞌichjánxi̱n chro̱nka̱rá chrókuinhin kaín sín. ");
INSERT INTO poeNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Chróchrakuénhyará tí sín tꞌóyán cuérpo̱é chojni kíxin a̱sén chojni xitjahya tsꞌóyán sín. Íchá jína chróchrakonhénrá tí nkexro tsjacha sinchekꞌitjáyanxín cuérpo̱é chojni la ko a̱sén chojni tí xrohi tsꞌankahya. ");
INSERT INTO poeNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’¿Á chrókóxi̱xi̱nhya yaá koxroxe ntsíntsí ijnko chichaon ntsí? A̱ ntá kjónté xi̱kaha la chrókꞌuánótjenhya nijnko tí jehe va nonte tí chrókjuanjonhya Itꞌéni kjuachaxin. ");
INSERT INTO poeNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","A̱ ntá kjónté tí ka̱xi̱hi̱ chónta ikjárá la ó nohe chꞌán nkekja̱ín ka chontará. ");
INSERT INTO poeNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","A̱ ntá jahará chróchrakonhyará kíxin tóyóa̱hyará tí koxroxe kíxin a̱ntsí sínkí tí jahará, a̱ ntá tí koxroxe, kjónté nchónhya va, la kánhyó sínkí tíha. ");
INSERT INTO poeNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Kaín tí chojni tsochrónka kíxin tinkáchónkina sin nkayakon chojni la janhan mé kja̱xin tso̱xrja̱nka kíxin choxian tí jehe sín nkayakon Tꞌaná tjen nkaya nka̱jní. ");
INSERT INTO poeNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","A̱ ntá tí nkexro sinchemána tsontáchro sín kíxin chónhya sín tí janhan nkayakon chojni la kja̱xin janhan tsontáxrja̱n kíxin chonhya tí jehe sín nkayakon Tꞌaná tjen nkaya nka̱jní. ");
INSERT INTO poeNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Tjenka̱yáxinhyará kíxin kꞌuinkakian kjuaxróxin chjasintajni. Náhí. Janhan kꞌuinkakianhya kjuaxróxin. Tsjanjo̱nko kíchó chojni kíxin kꞌuinka janhan. ");
INSERT INTO poeNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Janhan kꞌuinka kíxin tso̱nínkakonhen chojni itꞌé, la ko tí xje̱en sín chjin mé tso̱nínkakonhen ìné, la ko tí tíkìnta̱ tso̱nínkakonhen ichꞌe̱e. ");
INSERT INTO poeNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Mé xi̱kaha tí sín tso̱nínkakonhen kíchó la mé tí sín na̱xa̱ kjéhya sín. ");
INSERT INTO poeNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’A̱ ntá tí nkexro a̱ntsí tjuèhe itꞌé sín la ko ìné sín la kánhyó tjuèhe tí janhan la mé xitjahya tsꞌóna sín kuènta̱na, la ko tí nkexro a̱ntsí tjuèhe xje̱en sín la kánhyó tjua̱na sín la mé xitjahya tsꞌóna sín kuènta̱na. ");
INSERT INTO poeNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","La tí nkexro tamáhya ntacruz, chrèhya sín tí janhan la mé xitjahya tsꞌóna sín kuènta̱na. ");
INSERT INTO poeNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Tí nkexro tjinkaon kíxin kohya nkehe chrókónhen sín mé tsꞌitjáyan sín, a̱ ntá tí nkexro chrókjuinchekꞌitjáyanxín a̱sén kíxin tinkáchónki sín tí janhan la mé tsaá sín. ");
INSERT INTO poeNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Tí nkexro chrókjuanjon kjuachaxin chrókꞌuejorá la mé éxí chrókꞌuáyéhe̱ sín tí janhan la ko tí nkexro chrókꞌuáyéhe̱ tí janhan la éxí yóhe̱ chrókꞌuáyéhe̱ sín tí nkexro ichrꞌánna kꞌuinka. ");
INSERT INTO poeNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","La tí nkexro chrókjuanjon kjuachaxin tsjakꞌe ijnko nkexro nixja itén Dios kíxin táha la Dios ichrꞌán la mé tsꞌáyéhe̱ nkehe éxí tsꞌáyéhe̱ tí nkexro kjuako. La ko tí nkexro chrókjuanjon kjuachaxin tsjakꞌe ijnko chojni jína kíxin jína chꞌán mé xi̱kaha tsꞌáyéhe̱ sín nkehe éxí tsꞌáyéhe̱ tí nkexro jína. ");
INSERT INTO poeNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","A̱ ntá tí nkexro sincheki̱to̱nhe̱n ijnko vaso nta̱ kin kjónté ijnko chojni noehya má, chréhe̱ tí janhan, la mé chaxín ntáxrja̱n kíxin tí chꞌín a mé chaxín tsꞌáyéhe̱ chꞌán nkehe jína kíxin xi̱kaha kjuíchꞌe chꞌán.﻿ ");
INSERT INTO poeNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ntá chꞌín Jesús kjuixin kjua̱ko̱he̱ chꞌán tí teyó sín xriko chꞌán la ntá sákjuíxin chꞌán ntiha la sákjuíkjako chꞌán iso chjasin chjinaxón ntiha. ");
INSERT INTO poeNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","A̱ ntá chꞌín Juan mé tjechjina chꞌán nto̱echiso ntá xrína̱hya kuínhin chꞌán nkerí xra̱ tjechꞌe Cristo. La ntá kꞌue̱tue̱nhen chꞌán iyó tí sín kꞌuékꞌajiko chꞌán kíxin sátsjitsjehe sín tí chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ntá sákjuí sín kjuíji sín ntiha ntá kjuanchankíhi sín chꞌán ntáchro sín kíxin: ―¿Á jaha tí nkexro itsi ní o̱ á na̱xa̱ tsochónhenni í jnko nkexro? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","A̱ ntá kjuáte̱he chꞌín Jesús, ntáchro chꞌán kíxin: ―Sátjirá tjiche̱nkará tí chꞌín Juan tí nkehe kꞌuíkonrá la ko tí nkehe kuínhínrá. ");
INSERT INTO poeNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Che̱nkará chꞌán kíxin tí sín kꞌuékꞌikonhya la ó tꞌikon sín jie la tí sín xitjahya kꞌuékji la ó tji sín la ko tí sín kꞌuéchónta chin lepra la ó kótjóá sín kuíto̱he sín jína la ko tí sín kꞌuékienhya la ó tinhin sín jie. Kja̱xin tí sín tsíkꞌen na ó xechón sín ínaá la ko kaín tí sín nòa mé síxrako̱he̱ sín tí tan jína tsaáxin sín. ");
INSERT INTO poeNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Méxra̱ imá náxrjón tí nkexro kohya nkehe tꞌinkákonhe̱n tinkáchónki tí janhan. ");
INSERT INTO poeNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Tió sákjuí sín ntá chꞌín Jesús kjuankíxin nixje̱he̱ chꞌán tí sín kꞌuéjó la chrónka chꞌán kuènte chꞌín Juan ntáchro chꞌán kíxin: ―Tí sákjuítsjehérá chꞌín Juan nte̱je̱ la, ¿nkexrí kꞌuíkonrá tí jehe chꞌán? ¿Á kꞌuíkonrá chꞌán éxí ijnko tji nchexrayehe xri̱nto̱? ");
INSERT INTO poeNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Tí náhí, la ¿nkehe kꞌuíkonrá? ¿Á kꞌuíkonrá chꞌán éxí ijnko nkexro tsíkꞌitsa jína? Jahará ó nohará kíxin chojni tsíkꞌitsa jína la tjejó sín tí nchia kuènte tí sín rey. ");
INSERT INTO poeNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿A̱ ntá nkehe kꞌuíkonrá? ¿Á ijnko nkexro chrónka itén Dios? Jehe chaxín la a̱ntsí chónta chꞌán kjuachaxin la tí sín kꞌuéchrónka itén Dios la kánhyó. ");
INSERT INTO poeNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Chꞌín Juan mé tí nkexro kui éxí xi̱kaha chrónka xroon itén Dios ósé. Mé ntáchro xi̱kihi: Janhan mé tsochrꞌan ijnko nkexro tsochrónka itan kuènta̱na tsitónxin nti̱a, kíxin tsjasiyóxin chꞌán nti̱a kuèntá. Mé xi̱kaha chrónka itén Dios. ");
INSERT INTO poeNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ntá ijnko nkehe chaxín tso̱tjo̱nka̱rá kíxin kaín tí nkexro kꞌuéjó senó la kánhyó tjetoan sín la a̱ntsí tjetoan tí chꞌín Juan Bautista. Kjánchó ijnko nkexro kjónté tjetuanhya la tí tsꞌáyéhe̱ sín tí kjua̱cha̱xién Dios tjen nkaya nka̱jní la a̱ntsí tjetoan sín la ntá jehe chꞌín Juan la kénhyó. ");
INSERT INTO poeNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Tí ikui chꞌín Juan Bautista hasta ijie la imá tjanjo̱nxi̱n tí sín tjinkaon tsꞌikon sín tí kjuachaxin kuènte nkaya nka̱jní. La jehó tí sín imá chónta kjuachaxin mé tsjacha sín. ");
INSERT INTO poeNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kaín tí sín profeta la ko tí ley kuènte chꞌín Moisés mé chrónka nkexrí tí kjuachaxin kuènte Dios hasta ikui chꞌín Juan. ");
INSERT INTO poeNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","A̱ ntá tí jahará chrókuítekáonrá tíhi; kíxin chꞌín Juan la mé ikui kíxin tí xra̱ kuènte chꞌín Elías tsjintaxín sichꞌe chꞌán kíxin chꞌín Elías la tꞌichjánxi̱n chrókui chꞌán ínaá. ");
INSERT INTO poeNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Tí nkexro tjinkaon chrókuinhin la chrókuinhin. ");
INSERT INTO poeNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿Nkexrí chrókjui̱ntayóa̱xian tí chojni tjejó ijie? Tóyóhe̱ sín tí chánjan tjejótja̱xi̱n sín ntasin tsítán sín la tꞌíye̱he̱ sín kíchó sín ");
INSERT INTO poeNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","ntáchro sín kíxin: “Kꞌuánoani flauta kjánchó jahará la te̱hyará. Itsjeni isón kuènte chojni tsíkꞌen la ntá kꞌuaváhyará la ko tsja̱nkahyará.” ");
INSERT INTO poeNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Kíxin tí ikui chꞌín Juan la kjónehya chꞌán la kꞌuíhya chꞌán vino la jahará ntáchrorá kíxin ijnko ncha̱kuen tí jínahya mé chónta chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","A̱ ntá tió kui tí Xje̱en Dios Kꞌóna Chojni ntá kjóne chꞌán la ko ikꞌui chꞌán, ntá ntáchrorá kíxin imá itsjé kjóne chꞌán la imá ikꞌui chꞌán la ko imá tꞌito chꞌán tí chojni chónta jie̱ la ko tí sín nchekjènki̱, ichrorá. A̱ ntá tí kjuachaxin kuènte Dios mé tja̱ko̱xi̱n tí xje̱en chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ntá chꞌín Jesús mé kjuankíxin chꞌán ntáche chꞌán tí sín tjejó iso tí chjasin imá kjuasixín chꞌán kjuaxroan kíxin kjónté xi̱kaha la na̱xa̱ kuinkáchónkihya sín Dios. ");
INSERT INTO poeNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ntá ntáchro chꞌán kíxin: ―Nòará jahará tjejorá chjasin Corazín la ko nòará jahará tjejorá chjasin Betsaida. Tí chrókꞌuixin tí kjuaxroan tí chjasin Tiro la ko chjasin Sidón éxí kꞌuíkonrá jahará ntá tí chrókójehe sín la tjoka chrókuinkáchónki sín Dios la tjoka chrókjua̱ko̱xi̱n sín chrókꞌuinkáya sín ka tié la ko nteso chrókjuinchekꞌia sín a̱sén sín. ");
INSERT INTO poeNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ntá ntáxrja̱n kíxin tí ya̱on tsito̱exín iji̱é chojni a̱ ntá jahará a̱ntsí tsjasótiará, a̱ ntá tí sín chjasin Tiro la ko chjasin Sidón la kénhyó tsjasóte sín. ");
INSERT INTO poeNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","A̱ ntá jahará chojni chjasin Capernaum tjenka̱yáxinrá kíxin imá nohará a̱ ntá sátsjírá nkaya nka̱jní, ichrorá, kjánchó chaxínhya. Jahará la tsjasinka̱ji̱nxinrá ntiha sátsjirá tsjasótiará tí siín tí sín tsíkꞌen. Tí chrókjuásian tí kjuaxroan tí chjasin Sodoma éxí kjuásian chjasánrá la tí chjasin la kjá na̱xa̱ chrókꞌuixin sín na̱xa̱ chrókꞌuítjáyanhya sín tí ya̱on ijie kíxin tjoka chrókuitekaon sín. ");
INSERT INTO poeNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","A̱ ntá tjo̱nka̱rá kíxin tió sinchekito̱éxín Dios iji̱é chojni la a̱ntsí tsjasótiará la tí sín chjasin Sodoma la kénhyó tsjasóte sín. ");
INSERT INTO poeNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ntá tí ya̱on a chꞌín Jesús mé nixje̱he̱ chꞌán Itꞌé chꞌán ntáchro chꞌán kíxin: ―Tjáncháha kjuasáya Itꞌéni mé Ìnché nkaya nka̱jni la ko chjasintajni kíxin jaha kjuánjonhya kjuachaxin chrókꞌuitja tí sín imá nohe a̱ ntá kjuánjuan kjuachaxin kíxin tsꞌitja tí sín noehya. ");
INSERT INTO poeNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Mé xi̱kaha Itꞌéni jaha kóxrjínhan kíxin xi̱kaha tso̱nhen ―ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ntá ntáchro chꞌín Jesús kíxin: ―Tꞌaná mé chjìna kaín xín nkehe. Kohya ninkexró chaxín chóxin tí Xje̱en chꞌán. Jehó Itꞌé chꞌán mé chóxin chꞌán la kohya ninkexró chóxin tí Itꞌé chꞌán. Jehó tí Xje̱en chꞌán mé chóxin chꞌán la ko tí sín tsíkjeyá chꞌán tsochóxin sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Xrákirá kaín rá tí tjén janhan tí jahará imá tsíkóxrjérá kjui̱chꞌerá xra̱ la yamárá nkehe iye la ntá janhan mé si̱ntakꞌo̱kꞌáhará. ");
INSERT INTO poeNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Tákjárá tí xra̱ kuènta̱na la tsꞌitjará kuènta̱na kíxin janhan mé jína a̱senná la nta̱hnkehya. Ntaha mé tsꞌitjará tsꞌo̱kꞌèxin a̱sánrá. ");
INSERT INTO poeNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Tí xra̱ tso̱tja̱hárá la xra̱hya la tí nkehe tso̱tja̱hárá la yehya. ");
INSERT INTO poeNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","A̱ ntá ijnko ya̱on la chꞌín Jesús kꞌuátsínka chꞌán ijnko nonte siín noatrigo tí ya̱on tꞌo̱kꞌéhe tí sín Israel. Na ntá tí sín xriko chꞌán mé tsíkꞌen sín kjinta la ntá kjuankíxin sín ikꞌuín sín iso noatrigo a kíxin sine sín. ");
INSERT INTO poeNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","A̱ ntá iso tí sín fariseo kꞌuíkon sín kíxin xi̱kaha kjuíchꞌe tí sín xriko chꞌín Jesús la ntá ntáchro sín kíxin: ―Tsjehé tí sín xrikoa mé tjejóchꞌe sín xra̱ tí ya̱on tꞌo̱kꞌéheni na mé kohya kjuachaxin tso̱nhen xra̱ tí ya̱on i ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ntá kjuáte̱he chꞌín Jesús kíxin: ―Jahará ¿a kjui̱nchekuáxinhyará tí xroon chrónka nkehe kjuíchꞌe chꞌín David la ko tí sín kꞌuájiko chꞌán tió kꞌuén sín kjinta? ");
INSERT INTO poeNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","A̱ ntá jehe sín mé kꞌuíxenhen sín tí nchia kuènte Dios la kaín sín kjóne sín tí nio̱tja̱ tsíkóyaon kuènte Dios kjónté kohya kjuachaxin sine chꞌán ni tí sín kꞌuájiko chꞌán. Jehó siín kjuachaxin sine tí sín ncha̱tꞌá. ");
INSERT INTO poeNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Jahará ¿á nchekuáxinhyará tí xroon tsíkjin chꞌín Moisés ntáchro kíxin tí sín ncha̱tꞌá kuènte ni̱nko mé tꞌo̱kꞌèhya sín tí ya̱on sábado la kjónté xi̱kaha la jehya jie̱ tíha? ");
INSERT INTO poeNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ntáxrja̱n kíxin itjén janhan la a̱ntsí má chonta kjuachaxin la ntá tí ni̱nko la kénhyó. ");
INSERT INTO poeNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Jahará la tiénxinhyará nkexrí tꞌaxrjexín tí nkehe ntáchro xroon itén Dios. Mé ntáchro kíxin: “Janhan Dios tjínka̱van kíxin chrókui̱konóe̱hérá chojni la tjínka̱konhya kíxin chrókꞌoyánrá iko chrókjuánjonrá.” Tí chrókuiénxinrá tíha la ntá chrókóninkákuénhyará tí janhan kíxin ninkehó jie̱ chontahya. ");
INSERT INTO poeNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","A̱ ntá tí Xje̱en Dios Kꞌóna Chojni mé chónta kjuachaxin tsꞌe̱to̱an nkexrí tso̱nhen tí ya̱on tꞌo̱kꞌéheni ―ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ntá chꞌín Jesús mé sákjuíxin chꞌán ntiha la kꞌuíxenhen chꞌán ijnko ni̱nko Israel. ");
INSERT INTO poeNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Mé ntiha itjen ijnko chꞌín tsíxámá tja. Na ntá tjejóntaxín iso sín fariseo a tjinkaon sín tsjanchia sín jie̱. La ntá kjuanchankíhi sín chꞌán kíxin: ―¿Á siín kjuachaxin sinchekito̱heni jína ijnko chojni níhi tí ya̱on tꞌo̱kꞌéheni ní? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Jnkojín tí jahará chontará ijnko kolélo chrókjuítsínkáya ijnko tòye̱ tí ya̱on tꞌo̱kꞌéheni ¿á chrókjuíhyará chrókuakitsjetaónrá va tòye̱ ní? ");
INSERT INTO poeNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Kjánchó tí chojni a̱ntsí má tjete sínkí a̱ ntá tí kolélo la kénhyó. Méxra̱ jína sichꞌeni tí xra̱ jína kjónté tí ya̱on tꞌo̱kꞌéheni. ");
INSERT INTO poeNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Méxra̱ nixje̱he̱ chꞌán tí chꞌín níhi a, ntáchro chꞌán kíxin: ―Tjéntoá tjá ―ichro chꞌán. A̱ ntá tí chꞌín níhi tja kjuentoá tja chꞌán la ó kjuixin kuíto̱he jína éxí tí í jnko tja chꞌán xi̱kaha. ");
INSERT INTO poeNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ntá tí sín fariseo kónínkaon sín kꞌuaxrjexín sín ntiha sákjuí sín la kjuenka̱yáxin sín nkexrí tsꞌóyán sín tí chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","A̱ ntá chꞌín Jesús mé kónohe chꞌán kíxin xi̱kaha tjenka̱yáxin sín la ntá sákjuíxin chꞌán ntiha la itsjé sín chréhe̱ sín chꞌán. Kjuínchekito̱he chꞌán jína kaín tí si̱nníhi ");
INSERT INTO poeNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","la kꞌue̱to̱an chꞌán kíxin tsochrónkahya sín noxín kíxin nkexro tí jehe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Mé xi̱kaha ó xiteyá tí nkehe chrónka chꞌín Isaías, tí nkexro chrónka itén Dios ósé, mé tsíntáchro chꞌán xi̱kihi: ");
INSERT INTO poeNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ntihi tjen tí nkexro chꞌena xra̱ la janhan mé kjuéyá chꞌán, janhan tjua̱ha̱ chꞌán la chàna kíxin itjen chꞌán. Tso̱tja̱ha̱ chꞌán tí ncha̱kuenná la jehe chꞌán mé tsochrónka chꞌán nkexrí si̱ntakito̱axián iji̱é chojni chjasintajni. ");
INSERT INTO poeNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Tso̱nínkakuenhya chꞌán chojni la chji̱níhya tsꞌóyako chꞌán, la ko kohya nkexro tsinhin itén chꞌan tí nti̱a. ");
INSERT INTO poeNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Tsꞌóchjenjinhya chꞌán kjónté itji tsíxréya, la tsꞌókꞌa̱nkahya chꞌán kjónté ijnko nkehe síhnchikoá. Jehe chꞌán na̱xa̱ sichꞌe chꞌán xra̱ tsjixrakájia tí ya̱on tsꞌe̱to̱an chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","La kaín xín chojni chjasintajni mé tsitekaon sín tí jehe chꞌán. Mé xi̱kaha chrónka itén Dios ósé. ");
INSERT INTO poeNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ntá iso chojni sákjuíkohe sín chꞌín Jesús ijnko chꞌín tꞌikonhya la ko nixjahya kíxin chónta chꞌán ncha̱kuen tí jínahya. A̱ ntá chꞌín Jesús mé kjuínchekito̱he chꞌán jína la ntá jína nixja chꞌán la ko jína tꞌikon chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ntá kaín xín chojni la chrakon sín la tjanchankíhi kíchó sín ntáchro sín kíxin: ―¿Á jehya xje̱en David tíhi? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ntá kuínhin tí sín fariseo la ntáchro sín kíxin: ―Tí chꞌín a takitsje chꞌán ncha̱kuen tí jínahya kíxin chónta chꞌán tí kjuachaxin kuènte chꞌín Beelzebú, mé tí chꞌín mé Tsochren tꞌe̱tue̱nhen kaín tí ncha̱kuen tí jínahya. ");
INSERT INTO poeNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ntá ó kónohe chꞌín Jesús tí nkehe tjenka̱yáxin sín ntá ntáchro chꞌán kíxin: ―Jnkojín gobierno jnkoko̱áhya tjenka̱yáxin sín ntá tjanjo̱nko kíchó sín na mé tsꞌitjáyan tí kjuachaxin tsꞌe̱to̱anxín sín, la ko kja̱xin tí sín jnkoko̱á chjasin o̱ tí sín jnkoko̱á nchia jnkokónhya tjenka̱yáxin sín la kja̱xin xi̱kaha tsꞌitjáyan sín. ");
INSERT INTO poeNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","A̱ ntá tí chaxín chꞌín Tsochren chrókuakitsjexín a̱sén ntihi kja̱ í chróchóntahya kjuachaxin na̱xa̱ chrókꞌue̱to̱an. ");
INSERT INTO poeNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Jahará ntáchrorá kíxin janhan kuakítsjexián tí ncha̱kuen tí jínahya kjuachaxin kuènte chꞌín Beelzebú. A̱ ntá tí chaxín xi̱kaha la ntá ¿nkexro chjéhe kjuachaxin tí sín chréhe̱ tí jahará kíxin tjacha sín takitsje sín ncha̱kuen tí jínahya? Jehe sín mé tja̱ko̱xi̱n sín kíxin ntoáhya tjenka̱yáxinrá. ");
INSERT INTO poeNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","A̱ ntá janhan mé kuakítsjexián tí ncha̱kuen tí jínahya kjuachaxin kuènte Ncha̱kuen Dios la tíha mé chrókónoaxínrá kíxin tí kjua̱cha̱xién Dios mé ó kui tí tjejorá. ");
INSERT INTO poeNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’¿Nkexrí chrókꞌuixenhen ijnko nkexro ijnko nto̱e ijnko chꞌín jie̱he la chrókuakitsjehe chꞌán tí nkehe chónta chꞌán? Senó la chrókónteto chꞌán kíxin jína chrókueéhe sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Tí nkexro titekakonhya tí janhan la mé nínkakonna sín. A̱ ntá tí nkexro tjinkakonhya tí janhan mé tꞌinkákonhe̱n tí xra̱ itꞌa̱. ");
INSERT INTO poeNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Méxra̱ xrja̱nka kíxin Dios tsjakjìin jnkojnko jie̱ tjasin chojni la ko kaín nkehe jínahya nixja sín. A̱ ntá tí tꞌántaxínhi̱n sín Ncha̱kuen Dios la xitjahya tsjìin iji̱é sín. ");
INSERT INTO poeNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","La ko xrja̱nka kíxin kaín nkehe tꞌántaxínhínrá tí Xje̱en Dios Kꞌóna Chojni la tsjakjìin Dios. A̱ ntá tí tsꞌantaxínhínrá Ncha̱kuen Dios la ntá mé í tsjìinhya tí iji̱ará kjónté ntihi chjasintajni la ko kjónté tí chrꞌéxi̱n. ");
INSERT INTO poeNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Tí nta tsíkꞌánkí jína la tꞌóna to jína la tí nta tsíkꞌánkíhya jína la tꞌónahya to jína. Méxra̱ tí nta mé chrókjuatso̱anxínni tí to a. ");
INSERT INTO poeNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Jahará tsíkꞌaxrjeníxinrá konche. ¿Nkexrí jína chróntáchrorá jahará tí jehya jínará? Tí nixja irꞌvará la éxí ntáchro a̱sánrá mé nixja irꞌvará. ");
INSERT INTO poeNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ijnko chojni jína mé jína nixja kíxin jína a̱sén chꞌán. A̱ ntá ijnko chojni jínahya mé nixja tí nkehe jínahya kíxin tí a̱sén chꞌán kja̱xin jínahya. ");
INSERT INTO poeNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ntá tjo̱nka̱rá kíxin itsi tí ya̱on tsjixixín tió sinchekito̱exín Dios iji̱é chojni ntá tso̱nohará kaín nkehe chji̱ní tsínixjará. ");
INSERT INTO poeNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kíxin tí nkehe nixjará tsja̱ko̱xi̱n á kjuásinrá jie̱ ní o̱ náhí. ");
INSERT INTO poeNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ntá iso tí sín fariseo la ko tí sín maestro tjako tí ley mé nixje̱he̱ sín chꞌín Jesús ntáchro sín kíxin: ―Maestro, tjinkaonni chrókꞌuikonni chrókjuásian ijnko kjuaxroan náxrjón tso̱noexínni kíxin nkexro jaha ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Tí sín jínahya la ko tí sín kuíto̱he Dios mé tjanchia sín chrókjuásian kjuaxroan náxrjón. Kjánchó tsjáko̱xi̱nhya í jnko kjuaxroan la jehó tí kjuaxroan kónhen chꞌín Jonás, tí nkexro kꞌuéchrónka itén Dios ósé. ");
INSERT INTO poeNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Éxí yóhe̱ kjuákꞌe chꞌín Jonás iní ya̱on la iní tie nkaxenhen tse̱e koche jié mé xi̱kaha tí Xje̱en Dios Kꞌóna Chojni tsjakꞌe nkaxenhen tòye̱ tsoxravá iní ya̱on la iní tie. ");
INSERT INTO poeNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","A̱ ntá tí ya̱on tsito̱exín iji̱é chojni la ntá tí sín chjasin Nínive mé tsjanchia sín jie̱ kíxin tí sín tjejó jie, kíxin tí sín chjasin Nínive mé kuíto̱he sín iji̱é sín tió kuínhin sín itén Dios chrónka chꞌín Jonás. A̱ ntá ijie itjén janhan la a̱ntsí má chonta kjuachaxin. A̱ ntá tí chꞌín Jonás la kénhyó kꞌuéchónta chꞌán kjuachaxin, kjánchó jahará kuítekákonhyará tí janhan. ");
INSERT INTO poeNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kja̱xin tí ya̱on tsito̱exín iji̱é chojni la tí tjan reina kꞌue̱to̱an kjui̱xi̱n nó Sur mé tsjanchia tjan jie̱ kíxin tí sín tjejó ijie kíxin jehe tjan kjui̱xi̱n imá ikjín kíxin chrókuinhin tjan tí kjuaxrexinkaon jína kꞌuékjako chꞌín Salomón. A̱ ntá ijie itjén janhan la janhan a̱ntsí má nòna a̱ ntá chꞌín Salomón la kénhyó kꞌuénohe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’A̱ ntá ijnko ncha̱kuen tí jínahya tsíkꞌaxrjexín ijnko chojni la mé ixri tí nonte xámá xritjeyá nketí náxrjón tsꞌo̱kꞌéhe. A̱ ntá kꞌuitjahya nketí náxrjón tsꞌo̱kꞌéhe. ");
INSERT INTO poeNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","La ntá kjuenka̱yáxin kíxin: “Áxri tsokjan nto̱na kꞌuaxrjéxian”, ichro. A̱ ntá tió ikjan tí ncha̱kuen la tꞌikon éxí ijnko nchia kohya ninkexró la éxí ijnko chojni tsíkꞌánjón nto̱e la náxrjón tsjehe tí nkaxenhen nchia. ");
INSERT INTO poeNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","A̱ ntá kꞌuíkon tí jínahya xi̱kaha tjen nchia la ntá sákjuíkakjín í jnko yato ncha̱kuen tí jínahya a̱ntsí má jínahya. A̱ ntá kaín kꞌuíxenhen tí ntiha. A̱ ntá a̱ntsí má jínahya kónhen tí chꞌín a, a̱ ntá tí senó la kénhyó. Mé xi̱kaha tso̱nhen kaín tí sín siín ijie titekakonhya. ");
INSERT INTO poeNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ntá chꞌín Jesús na̱xa̱ tjenixje̱he̱ chꞌán chojni la ntá xrína̱hya kjuíji ìné chꞌán la ko kíchó chꞌán. Ntá kuíto̱he sín ntója ó la tjinkaon sín chrónixje̱he̱ sín chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ntá ijnko nkexro ntiha sákjuíchénka tí chꞌín Jesús, ntáchro chꞌán kíxin: ―Ìná la ko kíchua tjejó sín ntója la tjinkaon sín chrónixja̱ha sín tí jaha. ");
INSERT INTO poeNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","A̱ ntá chꞌín Jesús kjuáte̱he chꞌán nixje̱he̱ chꞌán tí nkexro chrónka a, ntáchro chꞌán kíxin: ―¿Xá nkexro tí na̱ná la ko nkexro tí kíchiná? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ntá kjua̱ko̱xi̱n tja chꞌán tí sín xriko chꞌán la ntáchro chꞌán kíxin: ―Tí sín i la mé na̱ná la ko kíchiná. ");
INSERT INTO poeNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tí jnkojín sín i nchexiteyá nkehe tjinkaon Tꞌaná tjen nkaya nka̱jní na mé táha mé na̱ná la ko kíchiná mé xi̱kaha tꞌíkua̱n tí jehe sín ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","A̱ ntá tí ya̱on a ntá chꞌín Jesús kꞌuaxrjexín chꞌán nchia la sákjuí chꞌán kjuákꞌetja̱xi̱n chꞌán chrínta nta̱yaon. ");
INSERT INTO poeNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ntá kꞌuíxikóchjina nchónhya chojni tí tjen chꞌán la ntá jehe chꞌán mé kꞌui̱tꞌótjen chꞌán ijnko ntabárco̱ kjuákꞌetja̱xi̱n chꞌán la kaín sín na tí chrínta nta̱ ó kuíto̱he sín. ");
INSERT INTO poeNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","A̱ ntá nchónhya nkehe kjuako chꞌán kjuíncheyóe̱xin chꞌán, ntáchro chꞌán kíxin: ―Éxí ijnko chꞌín sákjuíkꞌe̱nka̱ no̱nte̱e ");
INSERT INTO poeNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","mé xi̱kaha sákjuíkꞌe̱nka̱ chꞌán iso tí noatrigo a. Ntá iso noa la tsíkꞌánótjen nti̱a ntá ikui koxroxe kꞌuìnka̱ va noa. ");
INSERT INTO poeNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","A̱ ntá iso noa na mé kꞌuítji chríkꞌá xro̱ tí kohya itsjé nche ntá tjoka kꞌuayan kíxin ntaha tjínhya chónta nche. ");
INSERT INTO poeNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ntá tí kjui̱to̱n ya̱on la ntá tí ka la xámá kíxin ni̱nkahya chónta nuèe. ");
INSERT INTO poeNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","A̱ ntá í so noa kjuítsínkakꞌá tí siín kachꞌi̱ na kꞌuánkí tí kachꞌi̱ a na ntá í xitjahya kꞌuánkí tí noatrigo a kíxin tsíkja̱te tí kachꞌi̱. ");
INSERT INTO poeNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","A̱ ntá tí noa tsíkꞌitjí nche jína na ntá tió kꞌuánkí la mé kꞌóna jína. Iso tí no na jnkoko̱á noatje mé kꞌóna ciento neno noa, a̱ ntá í jnko mé kꞌóna sesenta neno noa, a̱ ntá í jnko mé kꞌóna treinta. ");
INSERT INTO poeNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Tí nkexro tjinkaon chrókuinhin la chrókuinhin ―ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ntá iso tí sín kꞌuájiko chꞌín Jesús mé kóchjinehe chꞌán sín la ntá kjuanchankíhi sín kíxin: ―¿Nkekuènté xi̱kaha nixje̱hé sín ncheyóe̱xián? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","A̱ ntá chꞌín Jesús kjuáte̱he chꞌán ntáchro chꞌán kíxin: ―Jahará la Dios me tsjinki̱tsa tso̱nohará tí nkehe noehya í so chojni kuènte tí kjuachaxin kuènte Dios. A̱ ntá tí jehe sín a la náhí. ");
INSERT INTO poeNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tí nkexro ó chónta nkehe la a̱ntsí tsꞌáyéhe̱ sín kíxin a̱ntsí má tsochónta sín. A̱ ntá tí nkexro chóntahya la kjónté tí ntsí chónta sín la tsꞌaxrjehe sín. ");
INSERT INTO poeNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Mé xi̱kaha kjui̱ntayóa̱xuán kjuákua̱xia̱n sín kíxin jehe sín tꞌikon sín la ntá kjónté tjátso̱anhya sín la tjejótinhin sín a̱ ntá kjónté kienxínhya sín. ");
INSERT INTO poeNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Mé xi̱kaha ó xiteyá tí nkehe kꞌuéchrónka chꞌín Isaías tí nkexro kꞌuéchrónka itén Dios, mé ntáchro chꞌán xi̱kihi: Jehe sín tsinhin sín a̱ ntá tsienxínhya sín la tsꞌikon sín la tsjatso̱anhya sín tí nkehe tsꞌikon sín. ");
INSERT INTO poeNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Imá icha a̱sén tí sín chjasin i. Chónta sín ntatsjon kjánchó tsꞌíkjehe̱ la chónta sín ikon sín kjánchó tꞌikonhya sín, kíxin chrókꞌuikonhya sín la chrókuienhya sín la ko xitjahya kíenxín sín, kíxin í tjinkakonhya sín chrókjan sín kíxin janhan mé chrókjui̱ntakito̱ha̱ sín jína. Mé xi̱kaha tsíkjin chꞌín Isaías. ");
INSERT INTO poeNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ntá ntáchro chꞌín Jesús ínaá kíxin: ―A̱ ntá jahará la imá náxrjón tjejorá kíxin tꞌikonrá la ko tinhínrá. ");
INSERT INTO poeNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Chaxín xrja̱nka kíxin itsjé tí sín kꞌuéchrónka itén Dios la ko tí sín jína mé kꞌuétjinkaon sín chrókꞌuikon sín tí nkehe tꞌikonrá la ntá kꞌuíkonhya sín la ko kꞌuétjinkaon sín chrókuinhin sín tí nkehe tjejotinhínrá la ntá kuíenhya sín. ");
INSERT INTO poeNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Tinhínrá nkexrí tꞌaxrjexín tí chꞌín sákjuíkꞌe̱nka̱ no̱nte̱e. ");
INSERT INTO poeNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Tí nkexro kuínhin tí itén Dios chrónka nkexrí tí kjuachaxin kuènte Dios la ntá kíenxínhya sín la yóhe̱ tí noa xènjintja nti̱a. Ó kui chꞌín Tsochren ntá kjuínchekꞌitjáyan chꞌán tí itan jína kuínhin sín. ");
INSERT INTO poeNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","A̱ ntá tí tje kjuítsínkakꞌá xro̱ la mé tꞌaxrjexín kíxin tí chojni kuínhin itén Dios la tjoka kóxrjínhi̱n sín la kuinkáchónki sín. ");
INSERT INTO poeNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Kjánchó ni̱nkahya chónta nuèe na ntá itsi tí kjuaxróxinhya o̱ tsochónkíhi sín chojni chrókꞌóyán sín kíxin tí itén Dios kuítekaon sín, a̱ ntá tsíto̱he sín tí tinkáchónki sín Dios. ");
INSERT INTO poeNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","A̱ ntá tí tje kjuítsínkakꞌá kachꞌi̱ na mé éxí yóhe̱ ijnko chojni kuínhin itan jína kjánchó tjitoxi̱enhya nti̱e sín kíxin tóxakonhen sín tí xra̱ chónta sín chjasintajni la ko tjinkaon sín tsochónta sín itsjé nkehe. Kaín tíha mé tꞌinkákonhe̱n tí itén Dios kuínhin sín la ntá xi̱kaha xitjahya sichꞌehe sín xra̱ Dios. ");
INSERT INTO poeNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","A̱ ntá tí tje kꞌuínka tí nonte chónta nche jína na mé yóhe̱ tí chojni kuínhin tí itén Dios na ko kíenxín sín la ntá xi̱kaha jína chꞌehe sín Dios xra̱. Na iso sín la yóhe̱ éxí tí tje kꞌóna ijnko ciento neno noa la iso sín la yóhe̱ tí kꞌóna sesenta neno noa la iso sín la yóhe̱ tí kꞌóna treinta neno noa ―mé xi̱kaha chrónka chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ntá chꞌín Jesús kjuíncheyóe̱xin chꞌán ínaá ntáchro chꞌán kíxin: ―Tí kjuachaxin kuènte Dios mé yóhe̱ ijnko chꞌín kꞌue̱nka̱ noa jína no̱nte̱e chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","A̱ ntá tió kꞌuéjójua kaín sín ntá ikui ijnko nkexro nínkakonhen sín la kꞌue̱nka̱ chꞌán kajnto chríkꞌá tí noa a la ntá sákjuí chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","La ntá tí noatrigo kꞌuánkí la ntá ó sítinta̱a la ntá ntiha kja̱xin kónoxíxin kꞌuánkí tí kajnto. ");
INSERT INTO poeNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ntá tí sín chꞌe xra̱ mé sákjuínixje̱he̱ sín tí lámo̱e sín la ntáchro sín kíxin: “Tí noa kꞌuènká no̱nta̱a la noa jína tíha. A̱ ntá ¿nketí kjui̱xi̱n tí kajnto tsíkꞌayan?” ichro sín kjuanchankí sín. ");
INSERT INTO poeNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ntá kjuáte̱he tí ìnché tí nonte ntáchro kíxin: “Kjá ijnko nkexro nínkakonna mé kjuíchꞌe xi̱kaha”, ichro chꞌán. Ntá tí sín chꞌe xra̱ mé kjuanchankí sín kíxin: “¿Á tjinkávan kíxin sátsjini tsakitsjenkíni tí kajnto?” ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","A̱ ntá kjuáte̱he chꞌán kíxin: “Náhí. Tí sátsjia tsakítsjenkiá tí kajnto la kjá chónte tí katrigo tsꞌaxrjenkí. ");
INSERT INTO poeNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Íchá jína ti̱to̱hé kíxin tsꞌánkíkué tsjixin tsotjájiani. Ntá tsꞌe̱tue̱nhenni tí sín tsotjá kíxin senó tsꞌejo sín tí kajnto la sinchenteto sín kíxin tsoche la ntá chrꞌéxi̱n tsotjá sín tí noatrigo ntá tsꞌinkachjina tí noa a” ―mé xi̱kaha chrónka chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ntá chꞌín Jesús kja̱xin kjuíncheyóe̱xin ínaá ntáchro chꞌán kíxin: ―Tí kjuachaxin kuènte Dios mé éxí yóhe̱ ijnko tje mostaza kꞌue̱nka̱ ijnko chojni no̱nte̱e chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Tí tje a mé a̱ntsí má ntsí la ntá tí í so tje la kánhyó, a̱ ntá chrꞌéxi̱n ntá tsꞌayan tí nta mostaza la tsꞌánkí ijnko nta imá jié la tí í so nta la kánhyó. Ntá koxroxe xritjaká mé itsi va sichꞌéna va ka̱ké va tí chríkꞌá tí chaon nta. ");
INSERT INTO poeNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Kja̱xin kjuíncheyóe̱xin chꞌán tíhi mé ntáchro chꞌán kíxin: ―Tí kjuachaxin kuènte Dios mé éxí yóhe̱ tí xro̱a̱n tꞌánkíxin nio̱tja̱. Kjuinkíkja̱nxi̱n ijnko chojni chjin iní medida harina ntá tí chꞌo mé kꞌuánkí. ");
INSERT INTO poeNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Chꞌín Jesús kjua̱ko̱he̱ chꞌán tí chojni la kjuíncheyóe̱xón chꞌán la nixjahya chꞌán ninkehó tí kohya nkehe chrókjuincheyóe̱xin chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Mé xi̱kaha kjuako chꞌán kíxin tsoxiteyá tí nkehe tsíchrónka ijnko nkexro kꞌuéchrónka itén Dios ntáchro xi̱kihi: Mé tsoníxja̱xia̱n si̱ntayóa̱xión nkehe tsontáxrja̱n tí nkehe ninkexró noehya desde kꞌóna chjasintajni. ");
INSERT INTO poeNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ntá kjuixin nixje̱he̱ chꞌín Jesús tí sín a ntá sákjuí sín kaín sín la jehe chꞌán kꞌuíxenhen chꞌán nchia. Ntá kóchjina tí sín kꞌuájiko chꞌán la ntáchro sín kíxin: ―Chro̱nkaxián nkexrí tꞌaxrjexín tí kajnto kꞌuánkíkué tí noa trigo tí nonte ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ntá chꞌín Jesús kjuáte̱he chꞌán ntáchro chꞌán kíxin: ―Tí nkexro kꞌue̱nka̱ tí noa jína mé tí Xje̱en Dios Kꞌóna Chojni. ");
INSERT INTO poeNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","A̱ ntá tí nonte mé chjasintajni tíha. Tí noa jína mé éxí yóhe̱ tí chojni kuákja kjuachaxin kuènte Dios. La ntá tí kajnto mé éxí yóhe̱ tí chojni tꞌe̱tue̱nhen Tsochren. ");
INSERT INTO poeNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Tí nkexro nínkakonhenni mé kꞌue̱nka̱ tí kajnto mé Tsochren tíha. A̱ ntá tí tsotjá sín la mé tsjeje̱ chjasintajni. A̱ ntá tí sín tsotjá la mé tí sín ángel. ");
INSERT INTO poeNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Éxí xrenájín tí kajnto la tsoche mé xi̱kaha tso̱nhen tió tsjixixín tsjeje̱ chjasintajni. ");
INSERT INTO poeNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Tí Xje̱en Dios Kꞌóna Chojni mé tsꞌe̱tue̱nhen tí sín ángel kíxin tsakitsjexín sín tí tjetꞌe̱to̱an Dios kaín tí chojni tjachroe í so chojni la ko tí sín chꞌe tí nkehe jínahya. ");
INSERT INTO poeNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","La tsochrꞌán sín sátsji sín tí tja̱ siín xrohi la ntaha tsotsjánka sín la sinetaón neno sín. ");
INSERT INTO poeNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ntá kaín xín tí sín nchexiteyá tí nkehe tjinkaon Dios mé éxí tí ya̱on xi̱kaha tsotsjehe sín tí tjetꞌe̱to̱an Itꞌéni Dios. Tí nkexro tjinkaon chrókuinhin la chrókuinhin ―mé xi̱kaha ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Tí kjuachaxin kuènte Dios mé éxí yóhe̱ ijnko nkehe tjete tjemá ijnko nonte. Ijnko chojni kꞌuitja chꞌán tí nkehe tjete la ntá kjua̱kꞌe̱ma̱ chꞌán ínaá ntahó. Ntá chéhe̱ chꞌán sákjuí chꞌán la kjuínchekji chꞌán kaín nkehe chónta chꞌán la ntá ikjan chꞌán la kꞌue̱na chꞌán tí nonte a. ");
INSERT INTO poeNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ntá ntáchro chꞌín Jesús kíxin: ―Kja̱xin tí kjuachaxin kuènte Dios mé éxí yóhe̱ ijnko nkexro tjeyá xro̱ perla náxrjón. ");
INSERT INTO poeNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ntá tió tsꞌitja chꞌán ijnko xro̱ imá tjete la ntá sátsji chꞌán sinchekji chꞌán kaín nkehe chónta chꞌán kíxin tsꞌe̱na chꞌán tí xro̱ perla. ");
INSERT INTO poeNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ntáchro chꞌín Jesús kíxin: ―Kja̱xin tí kjuachaxin kuènte Dios mé éxí yóhe̱ ijnko nchísén tséya chojni koche tꞌenkí sín tí nta̱yaon la ntá tsotsé nchónhya clase koche. ");
INSERT INTO poeNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ntá tió tsíkaón koche tí nchísén tséya sín va la ntá tsakitsjenkí sín la tsjakꞌe sín chrínta nta̱ la ntaha tsꞌejótja̱xi̱n sín la tsíchéhe sín koche jína la tꞌe̱nka̱ sín ntaxra. La ntá tí jehya koche jína la itꞌe sín. ");
INSERT INTO poeNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Mé xi̱kaha tso̱nhen tió tsjeje̱ chjasintajni. Sátsji tí sín ángel la tsakitsjekjan sín chojni jínahya la tsito̱he tí chojni jína. ");
INSERT INTO poeNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","La tsochrꞌán sín tí sín jínahya sátsji sín tí tjen tja̱ tí siín xrohi la ntaha tsotsjánka sín la ko sinetaón neno sín. ");
INSERT INTO poeNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ntá chꞌín Jesús mé kjuanchankí chꞌán kíxin: ―¿Á tiénxinrá jahará kaín tí nkehe ní? ―ichro chꞌán. Ntá kjuáte̱he sín kíxin: ―Jeén, Ìnchéni, ó kíenxínni ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ntá ntáchro chꞌín Jesús kíxin: ―Ijnko maestro nohe tí nkehe kuènte ley la ntá ó nohe chꞌán kuènte tí kjuachaxin kuènte Dios la jehe chꞌán la éxí yóhe̱ ijnko ìnché nchia chónta itsjé nkehe tjete tjejóchjina la ntá nohe chꞌán tsakitsje tí nkehe tjete ni̱xin la tí nkehe tjete ntaxin ―mé xi̱kaha ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ntá kjuixin nixja chꞌín Jesús kjuíncheyóe̱xin chꞌán tíha na ntá sákjuíxin chꞌán ntiha. ");
INSERT INTO poeNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","La ntá sákjuí chꞌán chjasén chꞌán Nazaret. Ntaha kjuankíxin kjua̱ko̱xi̱n chꞌán tí ni̱nko Israel. Ntá itsjé sín la kóxakonhen sín kuínhin sín tí tjako chꞌán la ntáchro sín kíxin: ―Tí chꞌín i la, ¿nketí tsíxrako̱he̱ chꞌán kíxin imá nohe chꞌán la ko nkexrí kíxin tjasin chꞌán kjuaxroan? ");
INSERT INTO poeNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Á jehya tíhi xje̱en tí chꞌín carpintero la ìné chꞌán mé María? La ko chóxinni tí kíchó chꞌán a mé chꞌín Jacobo la ko chꞌín José la ko chꞌín Simón la ko chꞌín Judas. ");
INSERT INTO poeNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Kja̱xin tí sín chjin kíchó chꞌán na ntihi tjejó sín. Méxra̱ ¿nkexrí nohe chꞌán kaín tí nkehe? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Mé xi̱kaha chrohya sín tsitekakonhen sín chꞌán. Ntá ntáchro chꞌín Jesús kíxin: ―Nkuíxín tjikosáyehe chojni ijnko nkexro chrónka itén Dios. A̱ ntá tí sín chjasén chꞌán la ko kaín tí sín nto̱e chꞌán mé tjikosáyehya sín chꞌán ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","A̱ ntá tsjéhya kjuaxroan kjuasin chꞌán ntiha kíxin kuítekakuenhya sín chꞌán.﻿ ");
INSERT INTO poeNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","A̱ ntá tí ya̱on a ntá tí chꞌín Herodes mé tí nkexro kꞌue̱to̱an tí estado Galilea mé kuínhin chꞌán nkexrí ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ntá nixje̱he̱ chꞌán tí sín chꞌehe chꞌán xra̱, ntáchro chꞌán kíxin: ―Kjá tíha la chꞌín Juan Bautista ó tsíxechón chꞌán ínaá. Mé xi̱kaha chónta chꞌán kjuachaxin tjasin chꞌán kjuaxroan ―ichro chꞌín Herodes. ");
INSERT INTO poeNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Méxra̱ tí chꞌín Herodes mé tsíkꞌe̱to̱an kíxin chꞌín Juan tso̱ntetoxín cadena la ko tsjakꞌechjina chꞌán. Mé xi̱kaha kjuíchꞌe chꞌán kíxin xi̱kaha tsíkjanchia tí tjan Herodías, tí tjan ichjién tí chꞌín Felipe, kíchó chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Tí chꞌín Juan tsíntáche chꞌán tí chꞌín Herodes kíxin: ―Jehya jína tsochonta tí ichjién tí kíchuá ―mé xi̱kaha tsíntáchro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ntá chꞌín Herodes tjinkaon chꞌán chrókꞌóyán chꞌán tí chꞌín Juan kjánchó chrako̱nhe̱n chꞌán tí chojni kíxin kaín sín ntáchro sín kíxin chꞌín Juan mé nixja itén Dios, ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","A̱ ntá tí ya̱on kia tsíkjitoxi̱nhin nánó chꞌín Herodes la tí xje̱en tjan Herodías mé ité tjan tí tjejó tí chojni tsíkꞌíye̱he̱ chꞌán. A̱ ntá imá kóxrjínhi̱n chꞌín Herodes nkexrí ité tjan. ");
INSERT INTO poeNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","La ntá nixje̱he̱ chꞌán tjan kꞌuákjenxi̱n chꞌán ihni̱é Dios ntáchro chꞌán kíxin tsochjéhe chꞌán tjan kjónté jnkojín nkehe tsjanchia tjan, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ntá jehe tjan la senó kjuíkjanchankíhi tjan ìné tjan ntá ìné tjan tsíntachro kíxin ikja chꞌín Juan mé tsjanchia tjan ntá jehe tjan mé nixje̱he̱ tjan tí chꞌín Herodes ínaá ntáchro tjan kíxin: ―Chje̱héni ijnko plato tsjakꞌenkáya kja chꞌín Juan Bautista ―ichro tjan kjuanchia tjan. ");
INSERT INTO poeNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Na ntá chꞌín Herodes la mé imá kꞌuává chꞌán kíxin xi̱kaha kjuanchia tjan. Na ntá kaín tí sín siín ntiha ó kuínhin sín kíxin kjuínchenohe chꞌán Dios kíxin ichrén nkehe tsjanchia tjan tsjanjon chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Méxra̱ kꞌue̱to̱an chꞌán kíxin tsꞌóchrínjin sín ikja chꞌín Juan tí tjen chꞌán nto̱echiso. ");
INSERT INTO poeNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ntá kjui̱ka̱o sín kjui̱ko̱yá sín tí kja chꞌín Juan ijnko plato la chjéhe sín tí tjan tjarisoá ntá jehe tjan la sákjuíkénhen tjan ìné tjan. ");
INSERT INTO poeNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ntá tí sín kꞌuékꞌajiko chꞌán a mé sákjuíkakitsje sín tí cuérpo̱é chꞌán la sákjuíkjává sín. La ntá chrꞌéxi̱n la sákjuí sín sákjuíchénka sín tí chꞌín Jesús kíxin xi̱kaha tsíkónhen ntiha. ");
INSERT INTO poeNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ntá tí kuínhin chꞌín Jesús kíxin xi̱kaha tsíkónhen la ntá jehó chꞌán sákjuí chꞌán kꞌui̱tꞌótjen chꞌán ijnko ntabárco̱ la sákjuí chꞌán ijnko nonte ninkexró tjihya. A̱ ntá kaín tí chojni la kuínhin sín nketí tjen chꞌán la ntá kꞌuaxrjexín sín chjasén sín la ntá to̱tó sín sákjuíchréhe̱ sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","A̱ ntá kꞌuaxrjexín chꞌín Jesús tí ntabárco̱ a, a̱ ntá kꞌuíkon chꞌán kíxin nchónhya chojni siín ntiha ntá kui̱konóe̱he̱ chꞌán tí jehe sín na ntá kjuínchekito̱he chꞌán jína tí sín níhi tsíkji̱ka̱o sín. ");
INSERT INTO poeNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","La ntá ó kꞌuíxin tie na ntá tí sín kꞌuájiko chꞌín Jesús a mé kóchjinehe sín chꞌán, ntáchro sín kíxin: ―Ntá ó kóntó la kohya nkexro tjejó ntihi. Na ntá jaha chrókuétue̱nhén sín kíxin sátsji sín tí chjasin ntsí chjinaxón tsjikꞌe̱na sín nkehe sine sín ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ntá kjuáte̱he chꞌín Jesús, ntáchro chꞌán kíxin: ―Tꞌichjánxi̱nhya sátsji sín. Chje̱hérá sín nkehe sine sín ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ntá kjuáte̱he sín kíxin: ―Chóntahyani itsjé nkehe. Jehó inꞌó nio̱tja̱ la ko yaá koche chóntani ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ntá ntáchro chꞌín Jesús kíxin: ―Xrakoanará tí nkehe méhe̱ ntihi ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ntá kꞌue̱to̱an chꞌán kíxin kaín xín sín tsꞌixitja̱xi̱n sín tí chrítaón kaxi a. Ntá kuákja chꞌán tí inꞌó nio̱tja̱ la ko tí yaá koche ntá konta chꞌán nka̱jní la kjuanchehe chꞌán kjuasáyé Dios. Ntá kóchrítꞌo̱ chꞌán tí nio̱tja̱ chjéhe chꞌán tí sín kꞌuájiko chꞌán la jehe sín mé kꞌóxika̱ye̱he sín chjéhe sín tí chojni siín a. ");
INSERT INTO poeNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ntá kaín sín kjuixin kjóne sín kókje̱he sín. Ntá kjuixin ntá tí sín kꞌuájiko chꞌín Jesús kjuenájín kaín tí nkehe síxèhe sín la mé teyó ntaxra kaón. ");
INSERT INTO poeNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Na mé inꞌó mil chojni ntoa kjóne sín, la tí chojni chjin la ko chánjan la kuákjahya sín cuenta nkekja̱ín tí sín a. ");
INSERT INTO poeNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ntá kjuixin tíha ntá kꞌue̱tue̱nhen chꞌín Jesús tí sín kꞌuájiko chꞌán kíxin tsꞌi̱tꞌótjen sín tí ntabárco̱ tsꞌatòye̱ sín í jnko nánko nta̱yaon. Ntá jehe chꞌán na̱xa̱ kuíto̱he chꞌán nixje̱he̱ chꞌán tí sín siín ntiha. ");
INSERT INTO poeNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ntá kjuixin xíka̱ye̱he sín na ntá jehó chꞌán chrìin chꞌán ijnko jna̱ tsonixje̱he̱ chꞌán Itꞌé chꞌán tjen nkaya nka̱jní. Na ntá ó kꞌuíxin tie la jehó chꞌín Jesús itjen chꞌán ntiha. ");
INSERT INTO poeNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","La ntá tí ntabárco̱ na mé tjenkátaón nta̱ jnko̱siné nta̱yaon. Ntá imá chjéhe nta̱ tí ntabárco̱ kíxin tí xri̱nto̱ la chjéhe la xitjahya sátsji ntabárco̱. ");
INSERT INTO poeNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Na ntá las tres nantóye a mé sákjuíchréhe̱ chꞌán sín. To̱tó chꞌán mé sákjuítónxin chꞌán tí nta̱yaon la ntá kóchjinehe chꞌán tí tjejó sín. ");
INSERT INTO poeNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Na ntá tí sín kꞌuájiko chꞌán mé kꞌuíkon sín kíxin tjetjitaón chꞌán tí nta̱yaon na ntá imá chrakon sín la kꞌóyako sín. Ntáchro sín kíxin kjuacha sín ichro sín, chrakon sín. ");
INSERT INTO poeNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Na ntá nixje̱he̱ chꞌín Jesús tí jehe sín ntá ntáchro chꞌán kíxin: ―Nchefuérte a̱sánrá, chrakonhyará. Janhan kjuihá ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ntá chꞌín Pedro mé nixje̱he̱ chꞌán Ìnchéni, ntáchro chꞌán kíxin: ―Ìnchéni tí chaxín jaha la ntá chrókjuánjuan kjuachaxin chrókjuitaónni tí nta̱ tsjijini tí tjen jaha ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ntá ntáchro chꞌín Jesús kíxin: ―Xrákiá. Ntá kꞌuínkaji̱nxi̱n chꞌín Pedro tí ntabárco̱ la kjuankíxin chꞌán tjetjitaón chꞌán nta̱ sákjuíchréhe̱ chꞌán tí tjen chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","A̱ ntá xrína̱hya ntá kónohe chꞌán kíxin imá chjéhe xri̱nto̱ chrítaón nta̱, ntá chrakon chꞌán la kjuankíxin tinkákꞌaniánkí chꞌán nta̱, ntá kꞌuèya chꞌán ntáchro chꞌán kíxin: ―Ìnchéni, nchekaáni ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","A̱ ntá tuénxín chꞌín Jesús mé itsé chꞌán tja chꞌín Pedro la ntáchro chꞌán kíxin: ―Intsíkoá tinkachónkia tí janhan. ¿Nkekuènté títekákonhya? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Na ntá tió kꞌui̱tꞌótjen sín yóí sín tí ntabárco̱ la ntá tuénxín kꞌuíxratá tí xri̱nto̱. ");
INSERT INTO poeNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ntá kaín xín tí sín tjejóxenhen tí ntabárco̱ mé kꞌuéjóxin tochrꞌin sín nkayakon chꞌín Jesús la ntáchro sín kíxin: ―Jaha mé chaxín Xje̱en Dios ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ntá tió kꞌuátòye̱ sín tí nta̱yaon ntá kjuíji sín tí nonte Genesaret. ");
INSERT INTO poeNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ntá tí sín siín ntiha tjoka kjuátso̱an sín kíxin jehe chꞌín Jesús tíha, ntá kuínhin tí sín chjasin chjinaxón ntiha la ntá kui̱ka̱o sín kaín tí sín níhi tí tjen chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Na ntá chrónóe̱he̱ sín chꞌán kíxin chrókuíto̱he chꞌán kíxin kjónté chrínta iké chꞌán chrókuákóxi̱n sín, la ntá kaín tí sín kuákóxi̱n iké chꞌán mé kuíto̱he sín jína. ");
INSERT INTO poeNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","A̱ ntá chjasin Jerusalén kjui̱xi̱n iso sín fariseo la ko iso tí sín maestro tjako tí ley la kjuíchréhe̱ sín tí chꞌín Jesús. Ntá kjuanchankíhi sín chꞌán kíxin: ");
INSERT INTO poeNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Nkekuènté kíxin tí sín xrikoa la nchexiteyáhya sín tí nkehe kꞌuékinkáchónki tí sín tsíkꞌaxrjeníxinni kíxin tꞌóntihya sín itja sín ntá kjónté ine sín? ―ichro tí sín fariseo a. ");
INSERT INTO poeNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","A̱ ntá kjuanchankí chꞌín Jesús kíxin: ―¿Nkekuènté jahará kja̱xin títekákonhyará nkehe tsíkꞌe̱to̱an Dios? A̱ ntá jahará tjinkáonrá na̱xa̱ chrókuinkachónkirá tí nkehe kuinkáchónki tí sín tsíkꞌaxrjeníxinrá. ");
INSERT INTO poeNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ntáchro Dios kíxin: “Tsochontehérá kjuasáya itꞌárá la ko ìnárá”, la ko ntáchro chꞌán kíxin: “Tí nkexro tꞌántaxínhi̱n itꞌé la ko ìné la chrókꞌuen.” ");
INSERT INTO poeNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","A̱ ntá jahará tsíntáchrorá kíxin ó ncho̱xon kíxin ijnko nkexro tsochénka itꞌé la ko ìné kíxin: “Itꞌéni, ìnéni, chrokjuahya tsjinki̱tsani tí jaha kíxin kaín nkehe chóntani la ó chjéheni Dios.” ");
INSERT INTO poeNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","A̱ ntá jnkojín nkexro tsontáchro chꞌán tíhi ntá í tꞌichjánxi̱nhya tsjinki̱tsa tí itꞌé la ko tí ìné, mé xi̱kaha tsixrorá. Mé xi̱kaha jahará kui̱to̱hérá tí nkehe kꞌue̱to̱an Dios kíxin tjinkáonrá chrókjui̱chꞌerá éxí kjuíchꞌe tí sín tsíkꞌaxrjeníxinrá. ");
INSERT INTO poeNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Jahará la jehya jnkojínxón tjenka̱yáxinrá. Ntoá tsíntáchro tí chꞌín Isaías, tí nkexro kꞌuéchrónka itén Dios ósé. Mé chrónka chꞌán kíxin nkexrí tjejorá la xi̱kaha tsíkjin chꞌán kíxin: ");
INSERT INTO poeNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Tí chojni tí chjasin i irꞌva ó xraxinkakonxín sín tí janhan a̱ ntá tí a̱sén sín la ikjín kuíto̱he sín tí janhan. ");
INSERT INTO poeNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Méxra̱ ó chónko tóchjina sín xraxinkaon sín tí janhan kíxin tí nkehe tjako sín la tí nkehe tsíkꞌe̱to̱an chojni ó. Mé xi̱kaha ichro itén Dios. ");
INSERT INTO poeNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ntá kꞌuíye̱he̱ chꞌín Jesús tí chojni ínaá la ntáchro chꞌán kíxin: ―Chrókuinhínrá la ko chrókuiénxinrá. ");
INSERT INTO poeNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kaín nkehe ine chojni la ó ncho̱xon, jehya jie̱. Tí jie̱ la tí nkehe tꞌaxrjexín irꞌva chojni ―mé xi̱kaha ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","A̱ ntá tí sín kꞌuájiko chꞌín Jesús mé kóchjinehe chꞌán la ntáchro sín kíxin: ―¿Á noha kíxin tí sín fariseo mé kónínkaon sín tí kuínhin sín tí nkehe ntáche sín? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ntá kjuáte̱he chꞌán ntáchro chꞌán kíxin: ―Kaín tí ka jehya Tꞌaná tjen nkaya nka̱jní kꞌue̱nka̱xin la mé tsꞌaxrjenkíxin nuèe. ");
INSERT INTO poeNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Nté ti̱to̱hé sín. Tí jehe sín la ntakótán sín la tꞌe̱tue̱nhen sín í so sín ntakótán. A̱ ntá tió ijnko chojni ntakótán tjitaón nti̱a la ntá yóí sín tsꞌanótjenyá sín ichrén tòye̱ ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ntá ntáchro chꞌín Pedro kíxin: ―Chro̱nka nkexrí tꞌaxrjexín tíha ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―¿Á kja̱xinrá jahará tiénxinhyará? ");
INSERT INTO poeNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Á tiénxinhyará kíxin kaín tí nkehe ineni na sátji nkaya tse̱eni na ko xíkꞌaxrjexín tí cuérpo̱eni ínaá? ");
INSERT INTO poeNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","A̱ ntá tí nkehe tꞌaxrjexín irꞌva chojni la tꞌaxrjeníxin a̱sén chojni la tíha la mé tí jie̱ tjasixín chojni. ");
INSERT INTO poeNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kaín tíha mé tꞌaxrjeníxin a̱sén chojni, mé tí jínahya tjenka̱yáxin sín la ko tí tꞌóyán kíchó sín la ko tí tja̱che̱he̱ kíchó sín la ko tí chónta sín í jnko chojni chjin ókjé la ko teé sín la ko tí kjuachꞌia la ko tí tꞌántaxínhi̱n kíchó sín. ");
INSERT INTO poeNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Tí nkehe a mé tjasixín chojni jie̱. A̱ ntá tí sineni kjónté nchexiteyáhyani tsꞌónti tjani la tíha la jehya jie̱ ―mé xi̱kaha ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ntá chꞌín Jesús mé kꞌuaxrjexín chꞌán ntiha la ntá sákjuí chꞌán nó chjasin Tiro la ko chjasin Sidón. ");
INSERT INTO poeNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ntá ikui ijnko chojni chjin na mé ijnko tjan cananea na kjuákꞌe tjan tí chjasin ntiha. Kóchjinehe tjan tí chꞌín Jesús la kꞌuèya tjan ntáchro tjan kíxin: ―Ìnchéni, Xje̱en David, ti̱konóe̱héni kíxin tí xje̱enni chjin la mé níhi tjan chónta tjan ijnko ncha̱kuen tí jínahya ―ichro ti tjan a. ");
INSERT INTO poeNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","A̱ ntá chꞌín Jesús la ninkehó kjuáte̱ehya chꞌán. A̱ ntá tí sín kꞌuájiko chꞌán na kóchjina sín la ntáche sín chꞌán kíxin: ―Tétue̱nhén tjan sátsji tjan kíxin tinkákꞌóyako tjan chréhe̱ tjan tí jeheni ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ntá ntáchro chꞌín Jesús kíxin: ―Dios mé ichrꞌánna tsjéyá jehó tí kolélo kjuíchroe kuènte nación Israel ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","A̱ ntá tí tjan a kóchjina la kjuákꞌexín tochꞌin tjan nkayakon tí chꞌín Jesús la ntáchro tjan kíxin: ―Ìnchéni, tjínki̱tsani ―ichro tjan. ");
INSERT INTO poeNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","A̱ ntá chꞌín Jesús kjuáte̱he chꞌán ntáchro chꞌán kíxin: ―Jehya tí jína chrókuakitsja̱ha̱ nio̱tja̱ tí xjan ntá chrótja̱ha̱ koni̱a̱ chrókjóne va ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","A̱ ntá jehe tjan la ntáchro tjan kíxin: ―Chaxín xi̱kaha, ìnchéni. Kjánchó kjónté tí koni̱a̱ na tí nkehe tsjixènjinnkí mesa kuènte ìnché la ine va ―ichro tjan. ");
INSERT INTO poeNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ntá ntáchro chꞌín Jesús kíxin: ―Jaha imá tinkachónkia tí janhan. Tí nkehe tjinkávan la tsoxiteyá ―ichro chꞌán. Ntá tuénxín tí hora la tí xje̱en tjan ó kuíto̱he jína. ");
INSERT INTO poeNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ntá chꞌín Jesús mé sákjuíxin chꞌán ntiha la kjuíji chꞌán chrínta nta̱yaon Galilea. Ntá chrìin chꞌán ijnko jna̱ la ntiha kjuákꞌetja̱xi̱n chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ntá kójnkotsé itsjé chojni tí tjen chꞌán la kjui̱ka̱o sín tí si̱nníhi, mé tí sín xitjahya tji la ko tí sín tꞌikonhya la ko tí sín nixjahya la ko tí sín tsíxénká la kaín xín tí í so si̱nníhi. Kꞌuejo sín tí si̱nníhi to̱té tí chꞌín Jesús kíxin jehe chꞌán mé sinchekito̱he chꞌán sín jína. ");
INSERT INTO poeNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kaín chojni la imá chrakon sín kíxin kꞌuíkon sín kíxin tí sín kꞌuénixjahya la ó nixja sín la tí sín tsíxénká la tsíkito̱he sín jína la tí sín xitjahya tji la ó tji sín la ko tí sín kꞌuékꞌikonhya la ó tꞌikon sín. Méxra̱ kjuanchehe sín kjuasáyé tí Dios kuènte tí sín Israel. ");
INSERT INTO poeNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ntá kꞌuíye̱he̱ chꞌín Jesús tí sín kꞌuájiko chꞌán la ntáchro chꞌán kíxin: ―Imá ti̱konóa̱ha̱ kaín tí chojni kíxin ó ní ya̱on tjejókoni sín ntá kjuèhe sín nkehe sine sín. Tjinka̱konhya chrókuétua̱nha̱n sín sáchrókjui sín nto̱e sín kíxin na̱xa̱ nehya sín la nti̱a ó tso̱tie̱nxín sín kjinta ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ntá ntáchro tí sín kꞌuájiko chꞌán kíxin: ―Ntá jaha la ó noha kíxin nte̱je̱ tjejóni la kohya nkehe tsochjéheni kaín xín tí chojni a ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ntá chꞌín Jesús mé kjuanchankíhi sín, ntáchro chꞌan kíxin: ―¿Nkekja̱ín nio̱tja̱ chontará? ―ichro chꞌán. Ntá ntáchro sín kíxin: ―Yato nio̱tja̱ chóntani la ko iso koche ntsíntsí ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ntá chꞌín Jesús kꞌue̱to̱an chꞌán kíxin kaín xín sín tsꞌixitja̱xi̱n sín nonte, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ntá kuákja chꞌán tí yato nio̱tja̱ la ko tí koche ntsíntsí la kjuanchehe chꞌán kjuasáyé Dios. Ntá kóchrítꞌo̱ chꞌán tí nio̱tja̱ a la ntá kꞌue̱tue̱nhen chꞌán tí sín kꞌuájiko chꞌán kíxin tsꞌóxíka̱ye̱he sín tí nio̱tja̱ la ko tí koche kaín xín tí sín siín a, sine sín. ");
INSERT INTO poeNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Na mé kaín xín sín kjóne sín na kókje̱he sín ntá kjuenájín sín yato ntaxra to̱tꞌo̱ tí nkehe na̱xa̱ tsíxehe̱. ");
INSERT INTO poeNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","A̱ ntá tí sín kjóne mé noó mil chojni ntoa. A̱ ntá tí chojni chjin la ko chánjan la mé kuákjahya sín cuenta nkekja̱ín tí sín a. ");
INSERT INTO poeNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ntá chꞌín Jesús mé nixje̱he̱ chꞌán sín sákjuí sín la ntá kꞌui̱tꞌótjen chꞌán ntabárco̱ la sákjuí chꞌán nó Magdala.﻿ ");
INSERT INTO poeNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","A̱ ntá iso tí sín fariseo la ko iso tí sín saduceo mé sákjuítsjehe sín tí chꞌín Jesús. Tjinkaon sín chrókjua̱cha̱xi̱n sín chꞌán la kjuanchehe sín chꞌán kíxin chrókjua̱ko̱xi̱n chꞌán ijnko kjuaxroan kíxin á chaxín jehe chꞌán tsíki̱xi̱n chꞌán tí tjen Dios. ");
INSERT INTO poeNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","A̱ ntá chꞌín Jesús na kjuáte̱he chꞌán, ntáchro chꞌán kíxin: ―Jahará ntáchrorá kíxin ijie ntá kónjín ó tsi ijnko ya̱on jína kíxin kjátse nka̱jní. ");
INSERT INTO poeNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","La ntá nchítjen ntáchrorá kíxin ijie la náxrjónhya kíxin kjátse nka̱jní la tjenkáya tjui̱. Méxra̱ jahará ntoáhya tjenka̱yáxinrá. Ó nohará tjátso̱anrá tí nka̱jní, a̱ ntá tjátso̱anhyará tí kjuaxroan sítónhen jie. ");
INSERT INTO poeNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Tí sín jínahya la tí sín titekakonhya la tjanchia sín ijnko kjuaxroan jié. A̱ ntá tsꞌikonhyará í jnko kjuaxroan, jehó tí kjuaxroan kuènte chꞌín Jonás mé tsꞌikonrá ―mé xi̱kaha ichro chꞌín Jesús. Ntá kuíto̱he chꞌán sín la sákjuí chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ntá tí sín kꞌuájiko chꞌín Jesús mé kꞌuátòye̱ sín nta̱yaon la ntá kꞌuitjáyenhen sín tsíkjikohya sín nio̱tja̱. ");
INSERT INTO poeNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ntá ntáchro chꞌín Jesús kíxin: ―Chrókóxakonhanrá kíxin tí xro̱a̱n tsꞌánkíxin nio̱tjé tí sín fariseo la ko tí sín saduceo. ");
INSERT INTO poeNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ntá tí sín kꞌuájiko tí chꞌín Jesús mé ikjo sín kíchó sín ntachro sín kíxin: ―Mé xi̱kaha ichro chꞌán kíxin tsíkjikohyani nio̱tja̱ ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ntá kónohe chꞌín Jesús kíxin nkehe tí kjo sín kíchó sín, ntá ntáchro chꞌán kíxin: ―¿Nkekuènté tjórá kíxin chontahyará nio̱tja̱? Jahará la intsíkoá tinkachónkirá tí janhan. ");
INSERT INTO poeNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Jahará ¿á na̱xa̱ tiénxinhyará la ko á xráxinkákonhyará tí inꞌó nio̱tja̱ kꞌóxika̱ye̱heni kjóne tí inꞌó mil chojni la ko á xráxinkákonhyará nkekja̱ín ntaxra kjuenájinrá tí nkehe tsíxehe̱? ");
INSERT INTO poeNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","La ko ¿á xráxinkákonhyará jahará tí yato nio̱tja̱ xika̱ye̱he kjóne tí noó mil chojni la ko á xráxinkákonhyará nkekja̱ín ntaxra kjuenájinrá tí nkehe tsíxehe̱? ");
INSERT INTO poeNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","A̱ ntá ¿nkekuènté kíxin kuiénxinhyará kíxin janhan la jehya kuènte nio̱tja̱ tjénixja̱ tió ntáxrja̱n kíxin chrókóxakonhanrá kíxin tí xro̱a̱n tsꞌánkíxin nio̱tjé tí sín fariseo la ko tí sín saduceo? ―mé xi̱kaha ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Na ntá kuienxín sín kíxin nixjahya chꞌán kuènte tí xro̱a̱n tꞌánkíxin nio̱tja̱. Náhí. Tjenixja chꞌán kíxin chrókóxakonhen sín kíxin tí nkehe tjako tí sín fariseo la ko tí sín saduceo. ");
INSERT INTO poeNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Kjuíji chꞌín Jesús chjino tí chjasin Cesarea de Filipo ntá jehe chꞌán mé kjuanchankíhi chꞌán tí sín kꞌuájiko chꞌán, ntáchro chꞌán kíxin: ―¿Nkehe tjo sín kíxin nkexro tí Xje̱en Dios Kꞌóna Chojni? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ntá jehe sín kjuáte̱he sín ntáchro sín kíxin: ―Iso sín mé ntáchro sín kíxin Juan Bautista, ichro sín. A̱ ntá í so sín na mé ntáchro sín kíxin Elías, ichro sín. A̱ ntá í so sín mé ntáchro sín kíxin Jeremías o̱ í jnko nkexro kꞌuéchrónka itén Dios ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ntá ntáchro chꞌín Jesús kíxin: ―¿A̱ ntá jahará nkechrorá kíxin nkexro tí janhan? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","A̱ ntá chꞌín Simón Pedro kjuáte̱he chꞌán ntáchro chꞌán kíxin: ―Jaha mé tí Cristo mé Xje̱en Dios tjechón ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Náxrjón tjen jaha Simón xje̱en Jonás kíxin kohya nijnko chojni kjua̱ko̱ha tíha. Jehó Tꞌaná tjen nkaya nka̱jní mé kjua̱ko̱ha tíha. ");
INSERT INTO poeNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Méxra̱ ntáxrja̱n kíxin jaha mé Pedro mé tꞌaxrjexín kíxin ijnko xro̱ la chrítaón tí xro̱ mé si̱tꞌána ni̱nko la kjónté tí kjuachaxin kuènte kjuachꞌén la tsjachahya sinchekꞌitjáyan. ");
INSERT INTO poeNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Méxra̱ jaha mé tso̱tja̱ha tí llave kuènte kjuachaxin nkaya nka̱jní la ntá tí nkehe tjánjonhya kjuachaxin tso̱nhen ntihi chjasintajni la kja̱xin nkaya nka̱jní tsochóntahya kjuachaxin. A̱ ntá tí nkehe tsjánjuan kjuachaxin tso̱nhen ntihi chjasintajni la ntá kja̱xin nkaya nka̱jní siín kjuachaxin. ");
INSERT INTO poeNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ntá chꞌín Jesús mé kꞌue̱tue̱nhen chꞌán tí sín kꞌuájiko chꞌán kíxin ninkexró tsochénkahya sín kíxin jehe mé tí Cristo. ");
INSERT INTO poeNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ntá chꞌín Jesús kjuankíxin chꞌán chénka chꞌán tí sín kꞌuájiko chꞌán kíxin tꞌichjánxi̱n satsji̱ chꞌán chjasin Jerusalén la ntaha la tí sín tꞌe̱to̱an kuènte ni̱nko la tí sín ncha̱tꞌá tjetoan la ko tí sín maestro tjako ley mé imá sinchekjasóte sín chꞌán. La chrónka chꞌán kíxin tsꞌóyán sín chꞌán kjánchó tí níxin ya̱on mé tsoxechón chꞌán ínaá. ");
INSERT INTO poeNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ntá chꞌín Pedro mé kuakitsjenta chꞌán tí chꞌín Jesús la kjuankíxin nixje̱he̱ chꞌán ntáchro chꞌán kíxin: ―Kjá Dios tsjanjonhya kjuachaxin xi̱kaha tso̱nhan Ìnchéni kíxin jaha la xitjahya tsjasóte xi̱kaha ―ichro chꞌín Pedro. ");
INSERT INTO poeNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","A̱ ntá chꞌín Jesús mé kuinkátjíá chꞌán la nixje̱he̱ chꞌán tí chꞌín Pedro, ntáchro chꞌán kíxin: ―Sátjia ntáha, Sátanas. Tjia̱téhya tí jaha tí nkehe tso̱nna. Jaha chrókꞌuínkakonhén tí nkehe tjinkaon Dios. Jaha tjenka̱yáxinhya éxí tjinkaon Dios. Náhí. Tjenka̱yáxian éxí tjenka̱yáxin chojni ó ―ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ntá nixje̱he̱ chꞌín Jesús tí í so sín kꞌuájiko chꞌán, ntáchro chꞌán kíxin: ―Jnkojínrá tjinkáonrá tsochréhérá tí janhan la tꞌichjánxi̱n tsi̱to̱hérá kaín tí nkehe tjaké a̱sánrá, ntá tsámárá tí ntacruz kuèntárá, a̱ ntá tsochréhérá tí janhan. ");
INSERT INTO poeNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","A̱ ntá tí nkexro tjinkaon jehó sinchekaá a̱sén la tsꞌitjáyan. A̱ ntá tí nkexro chrókjuinchekꞌitjáyanxín a̱sén kíxin tinkáchónki sín tí janhan la tsaá. ");
INSERT INTO poeNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿A̱ ntá nkehe tso̱nhen tí chrókjuacha ijnko chojni chróchónta kaín nkehe siín chjasintajni a̱ ntá tí kjuachón chrókjuinchekꞌitjáyan? ¿Nkehe chrókjue̱nka̱ chojni kíxin chróchónta tí kjuachón? ");
INSERT INTO poeNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Tí Xje̱en Dios Kꞌóna Chojni tsi̱ka̱o chꞌán tí kjuachaxin jié kuènte Itꞌé chꞌán tjen nkaya nka̱jní la kaín tí sín ángel tsi̱ka̱o chꞌán na ntá tsje̱nke̱he chꞌán jnkojnko chojni nkexrí tí xra̱ kjuíchꞌe jnkojnko tí jehe sín. ");
INSERT INTO poeNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Chaxín xrja̱nka kíxin isorá tjejorá ntihi la na̱xa̱ tsꞌénhyará na̱xa̱ tsꞌikonjiará kíxin nkexrí tí kjuachaxin tsochónta tí Xje̱en Dios Kꞌóna Chojni tí tsi̱ka̱o chꞌán kjuachaxin jié ―ichro chꞌín Jesús.﻿ ");
INSERT INTO poeNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ntá injón ya̱on chrꞌéxi̱n ntá chꞌín Jesús mé sákjui̱ko chꞌán chꞌín Pedro la ko chꞌín Jacobo la ko chꞌín Juan, kíchó chꞌín Jacobo, la kꞌui̱tꞌótjen sín ijnko jna̱ imá noi. ");
INSERT INTO poeNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ntá ntiha tjejó sín ntá xrína̱hya kꞌuíkon sín kíxin chꞌín Jesús mé kꞌuíxitóxi̱n nkexrí tsjehe chꞌán. Tí nkayakon chꞌán la imá tjáki̱ni tsjehe éxí ya̱on la ko iké chꞌán la kꞌóna imá tjóá la tsjehe éxí yóhe̱ ijnko xrohi tꞌinkaséyan. ");
INSERT INTO poeNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Na ntá xrína̱hya kꞌuíkon sín itjen chꞌín Moisés la ko tí chꞌín Elías tjejótjo sín tí chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Na ntá chꞌín Pedro mé ntáche chꞌán tí chꞌín Jesús kíxin: ―Ìnchéni, jína kíxin tjejóni ntihi. Tí tjinkávan la chrókjuichꞌénani iní nchia la mé ijnko kuèntá jaha la ijnko kuènte chꞌín Moisés la í jnko kuènte chꞌín Elías ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ntá na̱xa̱ tjenixja chꞌín Pedro na ntá xrína̱hya ikui ijnko tjui̱ imá tꞌinkaséyan kjuákꞌetja chrítaón tí jna̱ tjejó sín. Ntá xrína̱hya chríkjan tí tjui̱ kuínhin sín itén ijnko nkexro nixja na mé ntáchro kíxin: ―Tíhi mé xja̱nna. Imá tjua̱ha̱ chꞌán la ko chàna kíxin itjen chꞌán. Chrókuinhínrá tí nkehe tjako chꞌán ―ichro Dios. ");
INSERT INTO poeNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Kuínhin tí sín kꞌuájiko chꞌán xi̱kaha la ntá kjuítsínka sín nonte kíxin imá chrakon sín. ");
INSERT INTO poeNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Na ntá chꞌín Jesús mé kóchjina tí tjejó sín la kuákóxi̱n sín chꞌán la ntáchro chꞌán kíxin: ―Tꞌàya chrakonhyará ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Na ntá xrína̱hya kꞌuíkon sín kíxin kohya ninkexró. Jehó chꞌín Jesús mé tjen. ");
INSERT INTO poeNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Na ntá tí kꞌuínkaji̱nxi̱n sín tí jna̱ ntá kꞌue̱to̱an chꞌín Jesús, ntáchro chꞌán kíxin: ―Ninkexró che̱nkahyará tí nkehe kꞌuíkonrá ijie hasta tsoxechónjian tí Xje̱en Dios Kꞌóna Chojni ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ntá tí sín kꞌuájiko chꞌín Jesús mé kjuanchankí sín, ntáchro sín kíxin: ―¿Nkekuènté ntáchro tí sín maestro tjako tí ley kíxin sa̱oxín itsi tí chꞌín Elías la ntá chrꞌéxi̱n itsi tí nkexro tsaáxinni? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ntá kjuáte̱he chꞌín Jesús, ntáchro chꞌán kíxin: ―Chaxín senó itsi chꞌín Elías kíxin tsjasiyóxin chꞌán kaín nkehe. ");
INSERT INTO poeNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Kjánchó ó xrja̱nka kíxin chaxín ó kui chꞌín Elías la tí sín chjasintajni la mé kjuátso̱anhya sín chꞌán la kjuínchekjasóte sín chꞌán éxí kóxrjínhi̱n sín. Mé xi̱kaha kja̱xin tí Xje̱en Dios Kꞌóna Chojni la mé kja̱xin sinchekjasóte tí jehe sín ―mé xi̱kaha ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ntá tí sín kꞌuájiko chꞌán mé kónohe sín kíxin chꞌín Jesús la nixja chꞌán kuènte Juan Bautista. ");
INSERT INTO poeNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ntá tió kꞌuíji sín tí siín nchónhya chojni la ntá kóchjina ijnko chꞌín tí tjen chꞌín Jesús la kjuákꞌexín tochꞌin chꞌán nkayakon chꞌán. La ntáchro chꞌán kíxin: ");
INSERT INTO poeNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Ìnchéni, ti̱konóe̱héni kíxin xje̱enni la níhi, chónta chꞌán chin tꞌaniáte. Nchónhya veces tjítsínkate chꞌán xrohi la tjítsínkankí chꞌán nta̱. ");
INSERT INTO poeNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ntá kjui̱ka̱oni chꞌán ntihi la tí sín xrikoá la kjuachahya sín kjuínchekito̱he chꞌán jína. ");
INSERT INTO poeNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","A̱ ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Jahará la chaxínhya tinkachónkirá tí janhan la imá tjásinrá jie̱. ¿Xá hasta nkesá tjinkáonrá na̱xa̱ tsꞌejóni? ¿Hasta nkesá tsjácha tsjakꞌé tsjákohará? Xrakoa tí xjan méhe̱ ntihi ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ntá chꞌín Jesús mé kꞌue̱tue̱nhen chꞌán tí ncha̱kuen tí jínahya la ntá kꞌuaxrjexín tí ncha̱kuen tí jínahya tí chánjan la tuénxín kuíto̱he xjan jína. ");
INSERT INTO poeNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ntá kjuixin sákjuí sín la jehó chꞌín Jesús tjen chꞌán la ntá tí sín kꞌuájiko chꞌán mé kjuanchankíhi sín chꞌán, ntáchro sín kíxin: ―¿Nkekuènté kíxin kjuachahyani kuakitsjeni tí ncha̱kuen tí jínahya a? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ntá ntáchro chꞌín Jesús kíxin: ―Jahará la kjuachahyará kuakítsjerá ncha̱kuen tí jínahya kíxin intsíkoá tinkachónkirá tí janhan. Chaxín xrja̱nka kíxin tí chrókuinkachónkirá kaín a̱sánrá kjónté intsíkoá éxí ijnko tje mostaza intsí la ntá chróntácherá tí jna̱ kíxin: “Sátjíxian ntihi la sátsjia ókjé”, chróchrorá chróntácherá tí jna̱ la ntá tí jna̱ sáchrókjuixin ntiha. Mé xi̱kaha kaín nkehe chrókjuachará chrókjui̱chꞌerá tí chaxín tinkachónkirá tí janhan. ");
INSERT INTO poeNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","A̱ ntá tí tsakítsjerá ijnko ncha̱kuen tí jínahya la tꞌichjánxi̱n tsonixje̱hérá Dios la ko sintehyará. ");
INSERT INTO poeNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Na̱xa̱ kꞌuékꞌaji sín jnkoko̱á tí estado Galilea la ntáchro chꞌín Jesús kíxin jehe chꞌán tí Xje̱en Dios Kꞌóna Chojni mé tsotsé sín chꞌán la ko tsjikaán sín chꞌán tí siín chojni tꞌe̱to̱an sinchekjasóte sín chꞌán ");
INSERT INTO poeNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","la tsꞌóyán sín chꞌán. A̱ ntá tí ya̱on níxin ntá tsoxechón chꞌán ínaá, ichro chꞌán. Ntá tí sín kꞌuájiko chꞌán mé kuínhin sín la imá kꞌuává sín. ");
INSERT INTO poeNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ntá tió kjuíji chꞌín Jesús la ko tí sín kꞌuájiko chꞌán tí chjasin Capernaum la ntá tí sín nchekjènki̱ kuènte ni̱nko mé sákjuítsjehe sín tí chꞌín Pedro la kjuanchankí sín kíxin: ―Tí maestro kuèntá la, ¿a tje̱nka̱hya chꞌán tí nkehe tjanchia tí sín nchekjènki̱ kuènte ni̱nko? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ntá kjuáte̱he chꞌín Pedro, ntáchro chꞌán kíxin: ―Kjá tje̱nka̱ chꞌán ―ichro chꞌán. Ntá kꞌuíxenhen chꞌín Pedro tí nchia la chꞌín Jesús mé senó nixja chꞌán ntáchro kíxin: ―¿Nkechrua, Simón? ¿Nkexro chrókjue̱nka̱ tí nkehe tjanchia tí sín tꞌe̱to̱an chjasintajni, á tí sín kuènte ntihó o̱ á tí sín tsíkji̱xi̱n ókjé? ―ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ntá kjuáte̱he chꞌín Pedro, ntáchro chꞌán kíxin: ―Tí sín tsíkji̱xi̱n ókjé mé tje̱nka̱ sín ―ichro chꞌán. Ntá ntáchro chꞌín Jesús kíxin: ―A̱ ntá tí sín chjasén sín la tꞌichjánxi̱nhya chrókjue̱nka̱ sín. ");
INSERT INTO poeNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Kjánchó tjínka̱konhya tso̱nínkaon ninkexró ntihi. La ntá sátsjia tí nta̱yaon sátsjikoá tí ichjo̱n chónta gancho tséxin sín koche la ntaha itsé tí chjo̱n chrínkí nta̱yaon. Ntá tsákjá tí koche sa̱oxín sítsé gancho. Ntá takitje̱he nkaya irꞌva va la tsꞌitja ijnko chichaon. Táha mé tsjacha tsje̱nka̱ kaín tí tjásikáha̱ sín la ko tí tjásíkehé sín jaha. Táha mé sátjikoá tjènka ―ichro chꞌín Jesús.﻿ ");
INSERT INTO poeNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","A̱ ntá tí ya̱on a tí sín kꞌuájiko chꞌín Jesús mé kóchjinehe sín chꞌán ntá kjuanchankíhi sín chꞌán kíxin: ―¿Nkexro tí a̱ntsí má tsꞌe̱to̱an tí kjuachaxin kuènte nkaya nka̱jní? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ntá chꞌín Jesús mé kꞌuíye̱he̱ chꞌán ijnko chánjan la kjuakꞌe jnko̱siné tí tjejó tí jehe sín ");
INSERT INTO poeNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","la ntáchro chꞌán kíxin: ―Chaxín xrja̱nka kíxin tí tsꞌónahyará éxí ijnko xjan ntsí ntá xitjahya tsákjárá tí kjuachaxin kuènte Dios. ");
INSERT INTO poeNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Tí jnkojín nkexro tsꞌóna éxí tí chánjan ihnkehya la mé a̱ntsí tjetoan ntiha. ");
INSERT INTO poeNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","A̱ ntá tí nkexro tsꞌáyéhe̱ ijnko chánjan kíxin tinkáchónki sín tí janhan la mé xi̱kaha éxí chrókꞌuáyéhe̱ sín tí janhan ―mé xi̱kaha ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Tí jnkojín nkexro chrókjuachroe ijnko chánjan ntsí tinkáchónki tí janhan la íchá jína chrókjuincheteyá sín chꞌán ijnko xro̱ tsíkꞌóna xro̱chre̱ ntá chrókjuíkakánkí chꞌán nta̱yaon ni̱nka. ");
INSERT INTO poeNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Imá náxrjónhya tjejó tí sín chjasintajni kíxin siín nkehe tjasixín chojni jie̱. Xráxín la jehí siín, a̱ ntá nòa tí nkexro tjasin tí nkehe tsjasixín chojni jie̱. ");
INSERT INTO poeNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Tí itjá o̱ to̱tá tjásixián jie̱ na chrókójína chrókochrínjian chróchrꞌan ikjín kíxin íchá jína chróchonta kjuachón kjónté itꞌo̱ó itjá o̱ itꞌo̱ó to̱tá. Á ntá tí yóí itjá o̱ yóí to̱tá chróchonta tsjásixián jie̱ la tíha mé sátsjixián tí síche xrohi jnkochríxín. ");
INSERT INTO poeNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","La ko kja̱xin tí ikuan tjásixian jie̱ na chrókójína chrókuakitsjenkiá tí ikuan chróchrꞌan ikjín kíxin kjónté náyó ikuan na chróchonta kjuachón. A̱ ntá tí yóí ikuan chróchonta tsjásixián jie̱ la tíha mé sátsjixián tí síche xrohi jnkochríxín. ");
INSERT INTO poeNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Chrókókjo̱niéhyará nijnko tí chánjan ntsíntsí. Tjo̱nka̱rá kíxin nkaya nka̱jní la tí sín ángel kuènte tí xjanntsí la xráxín tjejó sín tí tjen Tꞌaná nkaya nka̱jní. ");
INSERT INTO poeNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Tí Xje̱en Dios Kꞌóna Chojni la mé ikui kíxin chrókjuinchekaá tí chojni xrichroe. ");
INSERT INTO poeNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Jahará nkechrorá? Ijnko chojni chónta ijnko ciento kolélo ntá chrókꞌuitjáyan ijnko va na ¿á chrókuíto̱ehya chꞌán tí noventa y nueve va tí jna̱ ó a̱ ntá á chrókjuikjeyáhya chꞌán tí ijnko tí ko kꞌuítjáyan ní? ");
INSERT INTO poeNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","A̱ ntá tí tsjacha chꞌán tsꞌitja chꞌán va ntá a̱ntsí tso̱chéhe̱ chꞌán kíxin tí kolélo kꞌuitja chꞌán la ntá kánhyó tso̱chéhe̱ chꞌán kíxin tjejó tí noventa y nueve ko tsíkꞌitjáyanhya va. ");
INSERT INTO poeNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Mé xi̱kaha kja̱xin Itꞌéni tjen nkaya nka̱jní la tjinkakonhya chꞌán kíxin chrókꞌuitjáyan ninkexró kjónté ijnko chojni kánhyó tjetoan. ");
INSERT INTO poeNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Tí kíchuá tí chrókjuitꞌaha ichrén nkehe jínahya la ntá jahvá chrónixje̱hé chꞌán la nche̱xraxinkaon chꞌán tí jie̱ kjuasin chꞌán. A̱ ntá tí kjuacha nixje̱hé tí kíchuá la í kohya kjuanínkaon. ");
INSERT INTO poeNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","A̱ ntá tí tahya chꞌán kuentá nkechrua la ntá ntáche á jnko o̱ yaá chojni sátjikoa kíxin tsinhin sín á chaxín titekakonhya chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","A̱ ntá tí kjónté xi̱kaha na̱xa̱ titekakuenhya chꞌán sín la ntá chenka tí sín tsíkójnkotsé nkehe tí jie̱ kjuasin chꞌán la ntá tí na̱xa̱ titekakuenhya chꞌán tí sín tsíkójnkotsé la ntá tsꞌikonrá chꞌán éxí ijnko chojni tinkáchónkihya Dios o̱ éxí ijnko chojni nchekjènki̱. ");
INSERT INTO poeNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Chaxín ntáxrja̱n kíxin tí tsjánjonhyará kjuachaxin nkehe tso̱nhen ntihi chjasintajni la ntá kja̱xin nkaya nka̱jni tsjanjonhya Dios kjuachaxin la ko tí tsjánjonrá kjuachaxin nkehe tso̱nhen ntihi chjasintajni la kja̱xin ntaha nkaya nka̱jní tsjanjon Dios kjuachaxin. ");
INSERT INTO poeNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Kja̱xin ntáxrja̱n kíxin tí tjejó yaárá ntihi chjasintajni la tí jnkoko̱á tjejótjenka̱yáxinrá chrókjuancheherá Dios ijnko nkehe tjinkáonrá la ntá jehe chꞌán mé tsotjáhará chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kíxin tí tjejó yaá o̱ iyꞌá chojni tjejó jnkoko̱á tꞌákjenxi̱n sín ni̱ná la janhan koína tjénta̱xian tí tjejó sín ntiha. ");
INSERT INTO poeNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ntá kóchjina chꞌín Pedro mé kjuanchankí chꞌán ntáchro chꞌán kíxin: ―Ìnchéni, ¿nkekja̱ín veces chrókꞌuitjáyenhenni tí jie̱ kjuasin kíchó ni? ¿Á yato veces ó ní? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ntá kjuáte̱he chꞌín Jesús, ntáchro chꞌán kíxin: ―Náhí, jehya yato veces ó. Náhí, hasta setenta veces tí yato. ");
INSERT INTO poeNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Tí kjuachaxin kuènte Dios la éxí yóhe̱ ijnko rey tjinkaon chꞌán tsjentoáko chꞌán kuentá tí sín chꞌehe chꞌán xra̱. ");
INSERT INTO poeNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ntá kjuankíxin chꞌán tsítsínkaxín cuenta la ntá xrína̱hya kóchjina ijnko chꞌín chꞌe xra̱ síká nchónhya millones chichaon. ");
INSERT INTO poeNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Tí chꞌín a mé chóntahya chꞌán chichaon tsꞌókjenhen chꞌán tí chꞌín rey la ntá tí chꞌín rey mé kꞌue̱to̱an chꞌán kíxin tí nkexro a mé tso̱xi chꞌán la koí tí ichjién chꞌán la ko xje̱en chꞌán la ko kaín nkehe kuènte chꞌán kíxin ntá xi̱kaha mé tsoxenka kaín tí síká chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","A̱ ntá tí nkexro chꞌe xra̱ mé kjuákꞌexín tochꞌin chꞌán nkayakon tí rey la chrónóe̱he̱ chꞌán, ntáchro chꞌán kíxin: “Jaha Ìnchéni ti̱konóe̱héni la kjónté kja̱xón tsje̱nka̱hani kaín tí sikáhani”, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","A̱ ntá tí chꞌín rey kui̱konóe̱he̱ chꞌán tí chꞌín a kjónté itsjé síká chꞌán, ntá kuíto̱he chꞌán sákjuí. ");
INSERT INTO poeNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","A̱ ntá tí sákjuí tí chꞌín a ntá xrína̱hya xéta chꞌán ijnko nkexro chꞌeko chꞌán xra̱ mé ijnko nkexro síkéhe chꞌán iso chichaon. La ntá tí chꞌín a mé tsénkíhi chꞌán isin la ntáchro chꞌán kíxin: “¡Tsjénka̱na tí nkehe tjasíkàna ní o̱ náhí!” ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","A̱ ntá tí chꞌín chóxin chꞌán mé kjuákꞌexín tochꞌin chꞌán nkayakon chꞌán la chrónóe̱he̱ chꞌán ntáchro chꞌán kíxin: “Ti̱konóe̱héni ijie la kjónté kja̱xón tsje̱nka̱hani kaín tí nkehe sikáhani”, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","A̱ ntá jehe chꞌán la kui̱konóe̱hya chꞌán. Kꞌue̱to̱an chꞌán kíxin tí chꞌín a mé tsjakꞌechjina chꞌán tsjixinjian tsje̱nka̱ chꞌán kaín tí síká chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ntá tí í so sín chꞌexón xra̱ mé kꞌuíkon sín la ntá imá kóxakonhen sín la sákjuíchénka sín tí lámoé sín nkexrí kaá kónhen tí chꞌín síká. ");
INSERT INTO poeNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","A̱ ntá tí lamo mé kꞌue̱to̱an tsjikꞌíye̱he̱ sín tí nkexro jínahya la ntá ntáchro chꞌán kíxin: “Imá jínahya jaha. Janhan mé kjui̱ntakꞌitjáyanhan tí nkehe tjasíkàna kíxin jaha chronóa̱na. ");
INSERT INTO poeNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","A̱ ntá jaha mé kja̱xin chrókui̱konóe̱hé tí nkexro choxian éxí janhan kui̱konóa̱ha tí jaha”, ichro tí chꞌín lamo. ");
INSERT INTO poeNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","A̱ ntá imá kónínkaon tí lamo a la kꞌue̱to̱an chꞌán kíxin tsjasóte tí chꞌín a tsjixinjian tsje̱nka̱ chꞌán kaín tí síká chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","A̱ ntá tí chꞌín Jesús ntáchro chꞌán kíxin: ―Mé xi̱kaha Tꞌaná tjen nkaya nka̱jní xi̱kaha sitꞌahará jahará tí jehya kaín a̱sánrá tsꞌitjáyanhanrá tí jie̱ chónta kíchuárá ―ichro chꞌín Jesús.﻿ ");
INSERT INTO poeNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","A̱ ntá kjuixin nixja chꞌín Jesús kaín tíha, ntá sákjuíxin chꞌán estado Galilea la kjuíji chꞌán estado Judea nó tóhe tí nta̱río Jordán. ");
INSERT INTO poeNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ntá nchónhya chojni kjuíjichréhe̱ sín chꞌán ntá ntiha mé kjuínchekito̱he chꞌán jína tí chojni níhi. ");
INSERT INTO poeNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ntá iso sín fariseo mé kóchjinehe sín tí chꞌín Jesús kjuanchankíhi sín chꞌán kíxin tsotsjehe sín nkexrí tsixro chꞌán, ntáchro sín kíxin: ―¿Á siín kjuachaxin tsjáke̱he̱ jnkojín chojni ichjién kjónté kohya jie̱ jié? ―mé xi̱kaha kjuanchankí sín. ");
INSERT INTO poeNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―¿Á nunca kjui̱nchekuáxinhyará jahará kíxin ntáchro xroon itén Dios kíxin tí nkexro kjuíchꞌéna kaín chojni siín chjasintajni tí xrankíxixín, la tí nkexro mé “kjuíchꞌéna chꞌán chojni ntoa ko chojni chjin”? ");
INSERT INTO poeNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","La ko ntáchro kíxin: “Mé xi̱kaha tí chojni ntoa la tsíto̱he sín itꞌé sín la ko ìné sín la tsakja sín ichjién sín la yóí sín la éxí ó jnko chojni xi̱kaha tsꞌóna sín.” ");
INSERT INTO poeNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Mé xi̱kaha la í jehya yaá chojni tí jehe sín. Náhí. Ó jnko chojni kꞌóna tí jehe sín la mé Dios kjuanjon kjuachaxin kíxin kuákja kíchó sín, la i xitjahya tsꞌitjíhi kíchó sín. ");
INSERT INTO poeNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ntá tí sín fariseo mé kjuanchankíhi sín chꞌán kíxin: ―¿Ntá nkexrí kíxin tí chꞌín Moisés kꞌue̱to̱an kíxin tsꞌóna ijnko xroon tsakja tí ichjién kíxin tsjáke̱exín kíchó sín? ―ichro tí sín fariseo. ");
INSERT INTO poeNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ntá ntáchro chꞌín Jesús kíxin: ―A̱ ntá jahará títekákonhyará. Méxra̱ chꞌín Moisés kjuanjon chꞌán kjuachaxin kíxin tsꞌóna tí xroon tsꞌitjíexín kíchuárá. Kjánchó tí xrankíxixín la xi̱kahya kónhen. ");
INSERT INTO poeNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Méxra̱ ntáxrja̱n kíxin jnkojín sín tjáke̱he̱ ichjién tí kjuasinhya jie̱, chóntahya tjan í jnko chojni, ntá kjuáke̱he̱ chꞌán tjan ntá tsakja chꞌán í jnko chjin mé xi̱kaha la ó jie̱ tíha. La ko kja̱xin tí ijnko chojni chjin tsíkítsínkehe ntá tsakja í jnko chojni la kja̱xin jie̱ tíha. ");
INSERT INTO poeNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","La ntá tí sín kꞌuájiko chꞌín Jesús ntáchro sín kíxin: ―Tí xi̱kaha tjanjo̱nko kíchó sín chrókꞌuitjíhi kíchó sín la íchá jína chrókóte̱ehya sín. ");
INSERT INTO poeNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ntá ntáchro chꞌín Jesús kíxin: ―Kénhya chojni tsjacha tienxín tíha. Jehó tí sín kjuanjon Dios kjuachaxin tienxín sín. ");
INSERT INTO poeNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Siín iso chojni tí tsíkꞌónaxín sín la chóntahya sín ko̱jé sín la xitjahya tsochónta sín ichjién sín. La í so sín la chrokjuahya tsakja kíchó sín kíxin ókjé chojni kja̱xin kjuíchꞌehe sín xi̱kaha, la ko í so sín la takjahya kíchó sín kíxin tjinkaon Dios kíxin xi̱kaha sichꞌehe sín chꞌán xra̱. Tí sín tsjacha sichꞌe tíha la chrókjuichꞌe sín xi̱kaha. ");
INSERT INTO poeNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ntá ikjui chojni kjui̱ka̱o sín iso xjan kíxin tjinkaon sín tsjakꞌetja tja chꞌín Jesús chrítaón tí chánjan la sincheyaon chꞌán sín. Ntá tí sín kꞌuájiko chꞌán mé kónínkakonhen sín tí sín kjui̱ka̱o tí xjan. ");
INSERT INTO poeNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","A̱ ntá ntáchro chꞌín Jesús kíxin: ―Nté ti̱to̱hérá tsoxrakoa xjan tí tjén janhan la tꞌínkakuènhyará xjan kíxin tí sín kuènte kjuachaxin nkaya nka̱jní la mé tóyóhe̱ éxí tí jehe xjan ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ntá kjuakꞌetja tja chꞌán chrítaón tí xjan la ntá kjuixin ntá sákjuí chꞌán ókjé. ");
INSERT INTO poeNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","A̱ ntá ijnko chꞌín ntasoá sákjuítsjehe chꞌán tí chꞌín Jesús la kjuanchankíhi chꞌán kíxin: ―Jaha la ijnko Maestro jína. La ntá ¿nkehe jína chrókjuichꞌeni kíxin chróchóntani kjuachón jnkochríxín? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ntá chꞌín Jesús kjuáte̱he chꞌán, ntáchro chꞌán kíxin: ―¿Nkekuènté ntáchrua kíxin jína tí janhan? Jehó jnkoko̱á nkexro la mé jína la tíha mé Dios. A̱ ntá tí tjinkávan tsochonta kjuachón jnkochríxín la títekávan tí nkehe kꞌue̱to̱an Dios ―ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ntá ntáchro tí chꞌín ntasoá kíxin: ―¿Nkehe tíha? ―ichro chꞌán. Ntá ntáchro chꞌín Jesús kíxin: ―Chrókꞌoyánhya chojni la ko chrókjui̱chꞌiyehya nijnko chojni chjin la ko chrókue̱ehya la ko chrókjui̱chꞌénahya kjuachꞌia kuènte ókjé chojni ");
INSERT INTO poeNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","la ko chrókjuíkosáyehé itꞌá la ko ìná la ko chrótjuèhé kíchuá éxí tjuèxian a̱sán. ―mé xi̱kaha ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ntá ntáchro tí chꞌín ntasoá kíxin: ―Kaín tíha la kjuínchexiteyáni desde tí ntasoáni. ¿A̱ ntá nkehe tí na̱xa̱ tꞌitjáyan? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ntá ntáchro chꞌín Jesús kíxin: ―Tí tjinkávan a̱ntsí ntoá si̱nchexiteyá la sátjia si̱nchekjia kaín tí nkehe chonta la si̱ncheki̱to̱nhén tí sín nòa. Ntá kaín tí nkehe tjete la tsochonta nkaya nka̱jní. Ntá tsjixin ntá tsjihá la chréhé tí janhan ―ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ntá kuínhin tí chꞌín ntasoá a xi̱kaha ntá tꞌává chꞌán sákjuí chꞌán kíxin imá itsjé nkehe chónta chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ntá chꞌín Jesús mé nixje̱he̱ chꞌán tí sín kꞌuájiko chꞌán, ntáchro chꞌán kíxin: ―Chaxín tjo̱nka̱rá kíxin tí chojni chónta imá itsjé nkehe na imá xra̱ tsꞌáyéhe̱ sín tí kjuachaxin kuènte nkaya nka̱jní. ");
INSERT INTO poeNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kja̱te̱e xrja̱nka kíxin a̱ntsí xra̱hya chrókꞌuatsínka ijnko kocamello ijnko tjarꞌi ntachica tjexrja. A̱ ntá a̱ntsí xra̱ kíxin tí sín chónta itsjé nkehe chrókꞌuáyéhe̱ tí kjuachaxin kuènte Dios ―ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ntá tí sín kꞌuájiko chꞌán mé kuínhin sín la imá chrakon sín, la jehe sín kjuanchankíhi kíchó sín kíxin: ―Tí xi̱kaha la ¿xá nkexro chrókjuacha chrókuaá? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ntá komá chꞌín Jesús tí jehe sín la ntáchro chꞌán kíxin: ―Chojni chjasintajni la xitjahya xi̱kaha sichꞌe. A̱ ntá Dios mé tsjacha sichꞌe xi̱kaha ―ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ntá ntáchro chꞌín Pedro kíxin: ―Ìnchéni, jeheni kaín ni la kuíto̱heni kaín nkehe chóntani kíxin tsochréhe̱ni tí jaha. A̱ ntá ¿nkehe tsꞌáyéhe̱ni? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ntá kjuáte̱he chꞌín Jesús kíxin: ―Chaxín ntáxrja̱n kíxin tió itsi tí ya̱on tso̱ni̱xin kaín nkehe la tí Xje̱en Dios Kꞌóna Chojni la mé tsjakꞌe tí trono tsochónta kjuachaxin jié la ntá kja̱xinrá jahará chréhérá tí janhan la tsꞌejorá teyó trono si̱nchekito̱exínrá iji̱é kaín tí sín tsíkꞌaxrjeníxin tí teyó xje̱en chꞌín Israel. ");
INSERT INTO poeNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","La ko kaín tí sín kuíto̱he sín nto̱e sín la ko kuíto̱he sín tí kíchó sín la ko kuíto̱he sín itꞌé sín o̱ ìné sín la ko kuíto̱he sín ichjién sín la ko xje̱en sín la ko no̱nte̱e sín kíxin tinkáchónki sín tí janhan, na ntá a̱ntsí má tsochónta sín la ko kja̱xin tsochónta sín kjuachón jnkochríxín. ");
INSERT INTO poeNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","A̱ ntá nchónhya tí sín tꞌe̱to̱an ijie, mé tsjixixín tsochréhe̱ sín. A̱ ntá nchónhya tí sín tꞌítuenhen ijie la tí sín a mé tsꞌe̱to̱an sín tí ntiha.﻿ ");
INSERT INTO poeNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Tí kjuachaxin kuènte Dios la éxí yóhe̱ ijnko chojni chónta xra̱ no̱nte̱e chꞌán la ntá ijnko ya̱on imá nchítjen sákjuíkjeyá chꞌán chojni tsotjéhe chꞌán to uva. ");
INSERT INTO poeNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ntá tí kꞌuitja chꞌán tí sín sichꞌehe chꞌán xra̱ ntá ikjo chꞌán sín kíxin ijnko denario tsje̱nke̱he chꞌán sín tí xra̱ sichꞌe sín no̱nte̱e chꞌán tí ya̱on a. ");
INSERT INTO poeNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ntá chrꞌéxi̱n como las nueve nchítjen ntá sákjuí chꞌán ntasin la kꞌuíkon chꞌán í so sín tjejó ntasin chóntahya sín xra̱. ");
INSERT INTO poeNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ntá nixje̱he̱ chꞌán sín ntáchro chꞌán kíxin: “Kja̱xinrá sáchrókjuirá chrókjui̱chꞌerá xra̱ no̱nte̱eni la jína chrókjuénka̱hará”, ichro chꞌán. La ntá jehe sín sákjuí sín. ");
INSERT INTO poeNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","A̱ ntá tí ìnché nonte la sákjuí chꞌán ínaá chonkíxin na̱xa̱ xíkꞌitja chꞌán í so sín chꞌehe chꞌán xra̱ la nta tí las tres kónjín la xi̱kaha na̱xa̱ xíkꞌitja chꞌán í so sín ínaá. ");
INSERT INTO poeNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","A̱ ntá las cinco kónjín sáxíkji chꞌán ntasin ínaá la kꞌuitja chꞌán í so chojni ntaha chóntahya sín xra̱ la ntá kjuanchankíhi chꞌán sín kíxin: “¿Nkekuènté tjejorá ntihi chꞌehyará xra̱ kuenté ya̱on? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ntá ntáchro sín kíxin: “Kohya nkexro kjuanjon xra̱ chrókjuichꞌeni”, ichro sín. Ntá ntáchro chꞌán kíxin: “Kja̱xinrá chrókjuirá chrókjui̱chꞌerá xra̱ no̱nte̱eni la jína chrókjuénka̱hará”, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","A̱ ntá ó kóntó ntá tí ìnché nonte mé nixje̱he̱ chꞌán tí chꞌín tꞌe̱to̱an sítónhen xra̱ no̱nte̱e chꞌán la ntáchro chꞌán kíxin: “Tꞌiye̱hé kaín tí sín kjuíchꞌe xra̱ tjénke̱hé sín. Tjankíxian tjénke̱hé tí chojni kjuixixín kꞌuíxenhen xra̱ la chrꞌéxi̱n tjénke̱hé tí sín sa̱oxín kꞌuíxenhen xra̱”, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","A̱ ntá kóchjina kaín tí sín kꞌuíxenhen xra̱ las cinco kónjín la jnkojnko sín kꞌuáyéhe̱ sín jnkojnko denario. ");
INSERT INTO poeNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ntá chrꞌéxi̱n, tió kóchjina tí sín kꞌuíxenhen xra̱ nchítjen la ntá kjuenka̱yáxin sín kíxin a̱ntsí itsjé chichaon chrókjuacha sín, ichro sín. Kjánchó kja̱xin sín kꞌuáyéhe̱ sín jnkojnko denario ó. ");
INSERT INTO poeNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","A̱ ntá tí kjuachahya sín tjete ntá kjuankíxin sín kónínkakonhen sín tí ìnché nonte ");
INSERT INTO poeNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","la ntáchro sín kíxin: “Tí sín ikui kjuixixín la kjuíchꞌe sín xra̱ jnkoko̱á hora la ntá kja̱xin kjuénke̱hé sín jnkokón éxí kjuacha tí jeheni. La ntá jeheni kjuíchꞌeni xra̱ kjónté sóa la kuenté ya̱on kjuíchꞌeni xra̱”, ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","A̱ ntá kjuáte̱he tí ìnché nonte nixje̱he̱ chꞌán ijnko tí jehe sín, ntáchro chꞌán kíxin: “Janhan la kjui̱tꞌayahyará ninkehó. Ó kuíto̱exínni kíxin ijnko denario tsjénka̱hará tí ya̱on. ");
INSERT INTO poeNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ntá tsákjá chi̱cha̱ko̱an la sátjia. Janhan tjínka̱van tsjénka̱ha̱ tí sín kꞌuíxenhen kjuixixín éxí tí kjuénka̱ha jaha. ");
INSERT INTO poeNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Á chontahya janhan kjuachaxin xi̱kaha chrókjuénka̱ha̱ sín kíxin tíha la chi̱cha̱ko̱nna? ¿Nkekuènté tóchji̱no̱xínhan jaha kíxin xi̱kaha kjuénka̱ha̱ sín?” ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Mé xi̱kaha iso tí sín tsjixixín chréhe̱ sín la tí sín a senóxin ntiha la ntá itsjé tí sín senó la mé tsjixixín tsochréhe̱ sín ntiha kíxin nchónhya sín kꞌuíya̱ha̱ kjánchó tsjéhya sín kꞌuítja ―ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ntá chꞌín Jesús sákjuí chꞌán nti̱a nó chjasin Jerusalén la ntá kꞌuaxrjentako chꞌán tí teyó sín kꞌuájiko chꞌán la ntáchro chꞌán kíxin: ");
INSERT INTO poeNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Jahará tsꞌikonrá ó sátsji̱ni chjasin Jerusalén la ntá tí Xje̱en Dios Kꞌóna Chojni mé tsotsé chojni tsjikaán sín chꞌán tí siín tí sín ncha̱tꞌá tꞌe̱to̱an la ko tí sín maestro tí tjako ley. Ntá jehe sín tsꞌe̱to̱an sín kíxin itsꞌen chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ntá tsjikaán sín chꞌán tí siín chojni jehya judío la jehe sín mé tsjanoá sín chꞌán la ko tsjate sín chꞌán ntá tsja̱kꞌe̱nka̱ni sín chꞌán ijnko ntacruz kjánchó ya̱on níxin mé tsoxechón chꞌán ínaá ―mé xi̱kaha chrónka chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","A̱ ntá tí ìné tí xje̱en chꞌín Zebedeo mé kjui̱ka̱o tí jehe sín mé chꞌín Jacobo la ko chꞌín Juan mé kóchjinehe tjan tí chꞌín Jesús. Kjuákꞌexín tochꞌin tjan nkayakon tí chꞌín Jesús la chrónóe̱he̱ tjan chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ntá chꞌín Jesús kjuanchankíhi chꞌán tjan kíxin: ―¿Nkehe tjinkávan? ―ichro chꞌán. Ntá kjuáte̱he tjan ntáchro tjan kíxin: ―Tió tséto̱anxián tí kjua̱cha̱xián jié la tsjánjuan kjuachaxin kíxin tí iyó xje̱enni chrókꞌuejó sín ijnko la itjá chjina la í jnko la itjá ikjon ―ichro tjan. ");
INSERT INTO poeNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ntá kjuáte̱he chꞌín Jesús, ntáchro chꞌán kíxin: ―Jahará la noahyará nkehe tjanchiará. ¿Á chrókjuachará chrókꞌuirá tí nkehe itsjá itsꞌia janhan la ko á chrókjuachará chrókuikiterá éxí tsikite janhan? ―ichro chꞌán. Ntá kjuáte̱he sín, ntáchro sín kíxin: ―Kja̱ tsjachani ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ntá ntáchro chꞌín Jesús kíxin: ―Chaxín kjónté chrókjuachará chrókꞌuirá éxí tí nkehe itsjá itsꞌia la ko chrókuikiterá éxí tsikite janhan, kjánchó janhan xitjahya tsjánjuan kjuachaxin kíxin ijnkorá chrókjuakꞌerá tjaná chjina la í jnkorá chrókjuakꞌerá tjaná ikjon kíxin janhan la tónahya tocar kíxin tsjánjuan tíha. Jehó Tꞌaná tjen nkaya nka̱jní mé nohe kíxin nkexro tsíkjeyá chꞌán tsꞌáyéhe̱ tíha ―ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ntá kuínhin tí ite sín kíxin xi̱kaha tsíkjanchia tí sín a ntá kónínkakonhen sín tí yaá a. ");
INSERT INTO poeNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","A̱ ntá chꞌín Jesús mé kꞌuíye̱he̱ chꞌán tí jehe sín ntá ntáchro chꞌán kíxin: ―Jahará ó nohará kíxin tí sín tꞌe̱to̱an chjasintajni la imá tꞌe̱tue̱nhen sín kaín chojni la tí sín tꞌe̱to̱an imá nchehnkehe a̱sén sín kíxin ihyé sín tꞌe̱to̱an sín. ");
INSERT INTO poeNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Kjánchó jahará la xi̱kahya chrókjui̱chꞌerá. Náhí. Tí jnkojínrá tjinkáonrá chrókuéto̱anrá la chrókjuínki̱tsará tí í so sín. ");
INSERT INTO poeNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","A̱ ntá ti jnkojínrá tjinkáonrá chrókuéto̱anrá mé tꞌichjánxi̱n senó chrókjuáko̱xi̱nrá chrókjui̱chꞌeherá kíchuárá xra̱. ");
INSERT INTO poeNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Mé xi̱kaha tí Xje̱en Dios Kꞌóna Chojni mé kuihya kíxin chojni chrókjuichꞌehe xra̱. Náhí. Ikui chꞌán kíxin sichꞌehe chꞌán sín xra̱ la ko tsꞌenyákonhe̱n chojni kíxin tsaáxin nchónhya sín. ");
INSERT INTO poeNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ntá kꞌuaxrjexín sín chjasin Jericó la nchónhya chojni chréhe̱ tí chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ntá ntaha chrínta nti̱a tjejótja̱xi̱n yaá sín tꞌikonhya. La ntá kuínhin sín kíxin kꞌuatsínka chꞌín Jesús la ntá kjuankíxin tꞌíye̱he̱ sín chꞌán ntáchro sín kíxin: ―Ìnchéni, jaha tsíkꞌaxrjeníxian David, ti̱konóe̱héni ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ntá nchónhya chojni mé ntáche sín tí sín tꞌikonhya kíxin: ―Tánírá tí jahará ―ichro sín. Ntá tí jehe sín a̱ntsí itsén kꞌuèya sín, ntáchro sín kíxin: ―Ìnchéni, jaha tsíkꞌaxrjeníxian David, ti̱konóe̱héni ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ntá chꞌín Jesús kjuákꞌechónhen chꞌán ntá kꞌuíye̱he̱ chꞌán tí sín tꞌikonhya la kjuanchankíhi chꞌán sín ntáchro chꞌán kíxin: ―¿Xá nkehe tí tjinkáonrá chrókjui̱tꞌahará? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ntá jehe sín kjuáte̱he sín ntáchro sín kíxin: ―Jaha Ìnchéni, tjinkaonni chrókjui̱nchekꞌikuanni ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ntá chꞌín Jesús mé kui̱konóe̱he̱ chꞌán tí jehe sín la kjuínchekuákóxi̱n tja chꞌán tí ikon tí sín tꞌikonhya. Ntá tuénxín kꞌuíkon sín la chréhe̱ sín tí chꞌín Jesús.﻿ ");
INSERT INTO poeNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ntá kjuíji chjina sín chjasin Jerusalén, mé kjuíji sín tí chjasin ntsí Betfagé itjen chjinaxón tí jna̱ Olivo. Ntá chꞌín Jesús kꞌue̱tue̱nhen chꞌán iyó tí sín kꞌuájiko chꞌán ");
INSERT INTO poeNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ntáchro chꞌán kíxin: ―Sátjirá tí chjasin ntsí itjen tóhe ntiha. Ntiha mé tsꞌítjará ijnko kolócho tjechroé va la ko ijnko kolóchóxjan. Ntá tjasinta̱nke̱hérá va ntá tsjíkuanará va ntihi. ");
INSERT INTO poeNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","A̱ ntá tí jnkojín nkexro tsjanchankíhará nkekuènté tjasinta̱nke̱hérá va la ntá tsontáchrorá kíxin “Ìnchéni tꞌichjánxi̱nhin va la ntá tió tsjixin ntá tuénxín tsjikaáni va”, ichrorá ―ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Mé xi̱kaha kónhen kíxin tsoxiteyá tí nkehe chrónka ijnko chꞌín kꞌuéchrónka itén Dios ósé ntáchro xi̱kihi: ");
INSERT INTO poeNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Ntáche tí chojni chjasin Sión kíxin: “Tsjehérá ó kui tí chꞌín Rey kuèntárá. Ihnkehya chꞌán la ijnko kolócho ó tjekjen chꞌán, mé ijnko kolóchóxjan, xje̱en ijnko kolócho támá nkehe.” Mé xi̱kaha ichro tí itén Dios ósé. ");
INSERT INTO poeNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ntá tí iyó sín mé sákjuí sín la kjuínchexiteyá sín tí nkehe kꞌue̱to̱an chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ntá kjui̱ka̱o sín kolócho la ko xje̱en va la kuakitsje sín ika titsáte sín ntá kjuínchekamá sín va ntá kjuákꞌekjen chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ntá itsjé chojni kuakitsje sín ka titsáte sín na kjuentoá sín ka tinkákꞌikjínxi̱n sín ka tí nti̱a tsꞌatsínkaxín chꞌín Jesús. La iso sín xraá kajni la ko chaon nta yoa tsíkóchrínjin sín la tinkákjasin sín nti̱a a. ");
INSERT INTO poeNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ntá iso sín tsítaón nti̱a la ko í so sín chréhe̱ iton chꞌán mé kjuankíxin sín itsje sín kíxin: ―Tjancheheni kjuasáyé tí nkexro kꞌuaxrjeníxin tí rey David. Jína tí nkexro kjui̱xi̱n kjua̱cha̱xién ihni̱é Ìnchéni. Tjancheheni kjuasáyé Dios ―ichro sín itsje sín. ");
INSERT INTO poeNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ntá kꞌuíxenhen chꞌín Jesús tí chjasin Jerusalén la ntá kaín tí sín ntiha mé kóxakonhen sín la itsjé sín kjuanchankí sín kíxin: ―¿Xá nkexro tíhi? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","La ntá nchónhya sín kjuáte̱he sín ntáchro sín kíxin: ―Tíhi mé tí nkexro Jesús chrónka itén Dios kjui̱xi̱n chꞌán chjasin Nazaret estado Galilea ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","A̱ ntá chꞌín Jesús mé kꞌuíxenhen chꞌán tí ni̱nko la ntá kuakitsje chꞌán kaín tí sín nchekjixin nkehe ntiha la ko tí sín tꞌe̱na nkehe ntiha. La kótéka chꞌán tí mesa tjinkítóxixín sín chichaon la ko tí silla tjejókjen tí sín nchekji kontóá. ");
INSERT INTO poeNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","La ntá ntáchro chꞌán kíxin: ―Tí xroon itén Dios tsíkjin sín ósé mé ntáchro kíxin: “Tí nto̱na imé itꞌin nchia tsonixja̱naxian sín.” A̱ ntá jahará tí nchia i tsíkji̱chꞌénará itjue̱é xíche̱e ―mé xi̱kaha ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ntaha nkaxenhen ni̱nko kóchjinehe chꞌín Jesús iso tí sín tꞌikonhya la ko iso tí sín xitjahya tji la ntá chꞌín Jesús mé kjuínchekito̱he chꞌán sín jína. ");
INSERT INTO poeNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","A̱ ntá tí sín ncha̱tꞌá tjetoan la ko tí sín maestro tjako tí ley mé kꞌuíkon sín kaín tí kjuaxroan kjuíchꞌe chꞌán la ko kuínhin sín kíxin iso chánjan mé itsje sín nkaxenhen ni̱nko ntáchro sín kíxin: “Chjéheni kjuasáyé tí nkexro kꞌuaxrjeníxin rey David”, ichro sín. Ntá kuínhin tí sín a xi̱kaha ntá kónínkaon sín ");
INSERT INTO poeNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","la nixje̱he̱ sín tí chꞌín Jesús ntáchro sín kíxin: ―¿Á kuínhín tí nkehe itsje tí chánjan? ―kjuanchankí sín. Ntá ntáchro chꞌín Jesús kíxin: ―Ó kui̱nha̱n. Kjánchó, ¿á nunca kjui̱nchekuáxinhyará tí xroon itén Dios? La xi̱kihi chro: Jaha kjuánjuan kjuachaxin kíxin tí sín chánjan hyé la ko chánjan na̱xa̱ tjejótakí mé tsotsje sín ―mé xi̱kaha ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ntá jehe chꞌán mé kuíto̱he chꞌán sín la kꞌuaxrjexín chꞌán chjasin Jerusalén la sákjuí chꞌán chjasin Betania la ntiha kꞌo̱kꞌéhe chꞌán tí tie a. ");
INSERT INTO poeNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","A̱ ntá tí kóya̱on nchítjen ntá kjan sín chjasin Jerusalén ínaá la ikui sín nti̱a ntá chꞌín Jesús mé ikꞌuén chꞌán kjinta. ");
INSERT INTO poeNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ntá kꞌuíkon chꞌán itjen ijnko nta tꞌóna to higo chjino nti̱a. La ntá sákjuítsjehe chꞌán tí nta, ntá kꞌuíkon chꞌán kíxin jehó ka itsa tí nta, na̱xa̱ kꞌónahya to. A̱ ntá jehe chꞌán mé nixje̱he̱ chꞌán tí nta, ntáchro chꞌán kíxin: ―Í nunca tsꞌónahya to ínaá ―ichro chꞌán. Ntá tí nta tꞌóna to higo mé tuénxín xámá. ");
INSERT INTO poeNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ntá tí sín kꞌuájiko chꞌín Jesús mé kꞌuíkon sín kíxin xi̱kaha kónhen tí nta, ntá chrakon sín la kjuanchankíhi sín tí chꞌín Jesús kíxin: ―¿Nkekuènté kíxin tí nta tꞌóna to higo tuénxín xámá? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ntá kjuáte̱he chꞌín Jesús, ntáchro chꞌán kíxin: ―Ntá chaxín ntáxrja̱n kíxin tí tinkachónkirá Dios chaxín la ntá jehya jehó tí nta xi̱kaha kónhen, la kja̱xin chrónixje̱herá tí jna̱ i kíxin: “Sátjíxian ntihi sátjíkjia̱nkiá nta̱yaon”, la mé xi̱kaha tso̱nhen. ");
INSERT INTO poeNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Tí tinkachónkirá Dios kaín nkehe tsjancheherá chꞌán la tsꞌayéhérá ―ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ntá kjuixin ntá chꞌín Jesús mé kꞌuíxenhen chꞌán tí ni̱nko ntiha. Ntá tió tjetjako chꞌán ntá kóchjina iso tí sín ncha̱tꞌa tꞌe̱to̱an la ko tí sín táda judío tꞌe̱to̱an la kjuanchankíhi sín chꞌán ntáchro sín kíxin: ―¿Nkehe tí kjuachaxin chonta kíxin xi̱kaha chꞌe la ko nkexro tí kjuanjon kjuachaxin? ―mé xi̱kaha kjuanchankí sín. ");
INSERT INTO poeNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Ntá kja̱xian janhan tsjánchánkíhará ijnko nkehe siná tsjate̱herá ntá janhan tso̱tjo̱nka̱rá nkehe tí kjuachaxin chonta tjétꞌa̱ tí xra̱ i. ");
INSERT INTO poeNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿A̱ ntá nkexro kꞌue̱tue̱nhen chꞌín Juan kíxin tsi̱ki̱te chꞌán chojni? ¿Á Dios ní o̱ á chojni ó? ―mé kjuanchankí chꞌín Jesús. Ntá jehe sín itjo sín kíchó sín kíxin: ―A̱ ntá tí tsontáchroni kíxin Dios tsíkꞌe̱tue̱nhen tí chꞌín Juan ntá tsjanchankí tí chꞌín a kíxin nkekuènté kuítekakuenhyani chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","A̱ ntá tí tsontáchroni kíxin chojni ó tsíkꞌe̱tue̱nhen chꞌán la ntá chrako̱nhe̱nni tí chojni kíxin kaín sín kuítekaon sín kíxin chꞌín Juan la nixja chꞌán itén Dios ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","A̱ ntá kjuáte̱he sín ntáche sín tí chꞌín Jesús kíxin: ―Náhí, noehyani ―ichro sín. Ntá ntáchro chꞌán kíxin: ―La ko kja̱xin janhan tso̱xrja̱nkahya nkexro kjuanjon kjuachaxin kíxin tjétꞌa̱ tí xra̱ ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ntá ntáchro chꞌín Jesús kíxin: ―¿Nkehe tsixrorá? Itjen ijnko chojni chónta yaá xje̱en chꞌán la ijnko ya̱on nixje̱he̱ chꞌán ijnko xjan ntáchro chꞌán kíxin: “Xje̱enni ijie la sátsjia tꞌakjínjián to uva no̱nte̱eni”, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ntá kjuáte̱he tí xjan kíxin: “Náhí tjinkakonhyani”, ichro chꞌán. A̱ ntá chrꞌéxi̱n ntá kꞌuíxitoxi̱n tí kjuenka̱yáxin chꞌán la sákjuíkjichꞌe chꞌán tí xra̱ a. ");
INSERT INTO poeNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","A̱ ntá tí itꞌé xjan a mé kjuínixje̱he̱ chꞌán tí í jnko xjan la jnkokón kꞌue̱tue̱nhen chꞌán la kjuáte̱he tí xjan kíxin: “Jeén, ó sátsjini”, ichro chꞌán. La ntá chaxínhya sátsíkji chꞌán ―ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ntá kjuanchankí chꞌín Jesús kíxin: ―¿Nkexéhe tí yaá chánjan kjuínchexiteyá tí nkehe kꞌue̱tue̱nhen itꞌé? ―ichro chꞌán. Ntá kjuáte̱he sín kíxin: ―Tí xjan sa̱o ―ichro sín. Ntá ntáchro chꞌín Jesús kíxin: ―Méxra̱ chaxín tjo̱nka̱rá kíxin tí sín nchekjènki̱ la ko tí chojni chjin chꞌiyehe nchónhya chojni ntoa la sa̱oxín tsꞌixenhen sín tí kjuachaxin tꞌe̱to̱an Dios la ntá jahará la náhí. ");
INSERT INTO poeNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kíxin chꞌín Juan Bautista mé ikui chꞌán kjua̱ko̱hará chꞌán nkexrí chrókꞌuejorá la ntá jahará kuítekákuenhyará tí chrónka chꞌán. A̱ ntá tí sín nchekjènki̱ la ko tí chojni chjin chꞌiyehe nchónhya chojni ntoa mé kuítekaon sín. A̱ ntá jahará kjónté xi̱kaha kꞌuíkonrá la kjuítoxi̱énhyará tí tjenka̱yáxinrá la ko kuítekákonhyará ―ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ntá chꞌín Jesús ntáchro chꞌán kíxin: ―Tsinhínrá ijnko nkehe si̱ntayóa̱xian. Éxí ijnko chꞌín kꞌue̱nka̱xin chꞌán itsjé ntanoa tꞌóna to uva no̱nte̱e chꞌán. Ntá kjuíchꞌéna chꞌán ijnko corral. La ko ijnko tjo̱ kjuíchꞌéna chꞌán tòye̱ kíxin tsꞌénya sín ìnté to uva. La ko kjuíchꞌéna chꞌán ijnko tja̱tꞌo̱ noi kíxin tsꞌi̱tꞌótjen chꞌán tsotsjehe chꞌán nkuíxín. ’A̱ nta kjuínchekjen chꞌán tí no̱nte̱e chꞌán iso tí sín chꞌe xra̱ ntá kjuixin ntá sákjuí chꞌán imá ikjín. ");
INSERT INTO poeNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","A̱ ntá tí kjuixraká tí ya̱on kꞌóna nkehe ntá jehe chꞌán mé ichrꞌán chꞌán iso tí chojni chꞌehe chꞌán xra̱ kíxin tsjikjanchehe sín tí sín chꞌe xra̱ no̱nte̱e chꞌán kíxin tsjanjon sín tí nkehe tsakja chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","A̱ ntá tí sín tꞌayakonhen tí nonte mé itsé sín tí sín kjuíkjanchia tí nkehe la kjuate sín iso la ko í so la kꞌóyán sín la í so la ixro̱ kꞌuíchexín sín. ");
INSERT INTO poeNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","A̱ ntá tí ìnché nonte a xíchrꞌán chꞌán iso chojni chꞌehe chꞌán xra̱ ínaá, a̱ ntá tí sín chꞌe xra̱ la kja̱xin xi̱kahó kjuíchꞌehe sín tí sín kjuíji. ");
INSERT INTO poeNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’A̱ ntá xi̱kaha tsíkónhen ntá kjuenka̱yáxin chꞌán ichrꞌán chꞌán tí xje̱en chꞌán, la kjá chróchóntehe sín kjuasáyé tí xje̱en chꞌán, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","A̱ ntá tí kꞌuíkon tí sín chꞌe xra̱ tí xje̱en chꞌán la ntá jehó sín kjuenka̱yáxin sín kíxin: “Tí chꞌín i mé tsꞌáyéhe̱ chꞌán kaín nkehe. Tsꞌóyánni chꞌán kíxin ntá tsito̱ekoni kaín tí nkehe kuènte chꞌán”, ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ntá itsé sín tí xje̱en chꞌán ntá kuakitsjexín sín chꞌán tí nonte ntaha ntá kꞌóyán sín chꞌán ―mé xi̱kaha kjuako chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ntá kjuanchankíhi chꞌín Jesús tí sín kóchjina, ntáchro chꞌán kíxin: ―Tió itsi tí ìnché tí nonte a la, ¿nkehe sichꞌehe chꞌán tí sín chꞌe xra̱? ―ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ntá kjuáte̱he sín kíxin: ―Mé tsjiji chꞌán la tsi̱konóe̱hya chꞌán tí sín jínahya la tsꞌóyán chꞌán sín la tsjeyá chꞌán ókjé chojni sinchekjen chꞌán tí nonte a. Tsjeyá chꞌán chojni jína tsjanjon tí to tsjixraká tí ya̱on tsꞌínjin sín to ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ntá ntáchro chꞌín Jesús kíxin: ―¿Á nunca kjui̱nchekuáxinhyará tí xroon itén Dios tsíkjin sín ósé? Mé ntáchro xi̱kihi: Tí xro̱ náxrjónhya kuíto̱enta tí sín chꞌéna tja̱tꞌo̱, a̱ ntá mé jie kꞌóna tí xro̱ tjetoan. Mé xi̱kaha kjuíchꞌe Ìnchéni Dios, na ntá tíha mé ijnko nkehe kjuachrakon kꞌuíkonni. Mé xi̱kaha ichro itén Dios. ");
INSERT INTO poeNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ntá ntáchro chꞌín Jesús kíxin: ―Tjo̱nka̱rá kíxin Dios tsakitsjahará tí kjuachaxin kuènte chꞌán la ntá sinchekꞌáyéhe̱ chꞌán tí sín chꞌe xra̱ jína. ");
INSERT INTO poeNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","A̱ ntá jnkojín nkexro tsjitsínka chrítaón tí xro̱ i mé tso̱kuen chꞌán la tí tsꞌánótjen tí xro̱ tsoxratja ijnko chojni la jehe sín tsꞌóna inche ―mé xi̱kaha ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ntá tí sín ncha̱tꞌá tjetoan la ko tí sín fariseo mé kuínhin xi̱kaha kjuíncheyóe̱xin chꞌín Jesús ntá kienxín sín kíxin kaín tí ntáchro chꞌán kjuíncheyóe̱xin chꞌán kíxin tí jehe sín xi̱kaha tso̱nhen sín. ");
INSERT INTO poeNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","La ntá tjinkaon sín chrókjuinchekjasóte sín chꞌán kjánchó chrako̱nhe̱n sín tí chojni kíxin kaín sín ntáchro sín kíxin chaxín tí nkehe nixja chꞌín Jesús la kuènte Dios.﻿ ");
INSERT INTO poeNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ntá chꞌín Jesús mé kjuankíxin nixja chꞌán ínaá la kjuíncheyóe̱xin chꞌán ntáchro chꞌán kíxin: ");
INSERT INTO poeNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Tí kjuachaxin kuènte Dios mé éxí yóhe̱ ijnko chꞌín rey kjuasin chꞌán ijnko kia kíxin tso̱te̱he xje̱en chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Kꞌue̱tue̱nhen chꞌán tí sín chꞌehe chꞌán xra̱ kíxin tsjikꞌíye̱he̱ sín tí sín kjueyá chꞌán, kjánchó jehe sín mé tjinkakonhya sín tso̱chjina sín. ");
INSERT INTO poeNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","A̱ ntá kꞌue̱tue̱nhen chꞌán ínaá í so tí sín chꞌehe chꞌán xra̱ ntáchro chꞌán kíxin: “Che̱nka tí sín ó kꞌuíya̱ha̱ kíxin kaín tí nkehe sineni la ó tjechónhen. Ó kuéto̱an itsꞌen tí koxinta la ko í so ko tsa̱nka̱ la kaín nkehe la ó síchónhen. A̱ ntá chróxrakoa sín tí siín kia”, mé xi̱kaha kꞌue̱to̱an chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","A̱ ntá tí sín tsíkꞌíye̱he̱ chꞌán mé ánto̱sén sín. Ijnko sín la sákjuí no̱nte̱e la í jnko la sákjuí chꞌán í jnko xra̱ chónta chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","La í so tí sín a mé tsítsé sín tí sín tsíkꞌe̱tue̱nhen tí chꞌín rey la kꞌóka tí sín a hasta ikꞌuén tí jehe sín. ");
INSERT INTO poeNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ntá tí chꞌín rey mé kónínkaon chꞌán ntá kꞌue̱tue̱nhen chꞌán tí sín soldado kíxin itsꞌen tí sín kjuàya la ko tsoche tí chjasén sín. ");
INSERT INTO poeNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ntá nixje̱he̱ chꞌán tí sín chꞌehe chꞌán xra̱ ínaá ntáchro chꞌán kíxin: “Kaín nkehe la ó síchónhen kíxin tí nkexro tso̱te̱he la ntá tí sín kꞌuíya̱ha̱ kuítekakonhya sín la kjuihya sín. ");
INSERT INTO poeNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Méxra̱ sátsjirá tí esquina tí nti̱a jié la tꞌi̱ye̱hérá kaín tí sín tsoxetará kíxin itsji sin ti kia”, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ntá tí sín chꞌe xra̱ mé sákjuí sín la kꞌuíye̱he̱ sín kaín tí sín tꞌátsínka tí nti̱a ntiha, mé chojni jína la ko chojni jínahya hasta kꞌuíxikaón chojni tí nchia ntiha. ");
INSERT INTO poeNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Ntá tí chꞌín rey mé kuitsjehe kaín tí sín tsíkꞌíye̱he̱ chꞌán la ntá kꞌuíkon chꞌán ijnko chꞌín ntiha chóntahya ka jína kuènte tí kia a. ");
INSERT INTO poeNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","La ntá nixje̱he̱ chꞌán, ntáchro chꞌán kíxin: “Amigo, ¿nkexrí kꞌuíxe̱nhén kíxin tsíkꞌítsa̱hya kuènte kié chojni tso̱te̱he?” ichro chꞌán. Ntá tí chꞌín a kjuáte̱ehya chꞌán ninkehó. ");
INSERT INTO poeNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","A̱ ntá tí chꞌín rey mé kꞌuíye̱he̱ chꞌán tí sín chꞌehe chꞌán xra̱ la ntáchro chꞌán kíxin: “Si̱nchenteto to̱té la ko itja tí chꞌín a la ité ntója sítié la nta ntiha a mé tsotsjánka chꞌán la sinetaón chꞌán neno chꞌán.” ");
INSERT INTO poeNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ntá ntáchro chꞌín Jesús kíxin: ―Nchónhya sín kꞌuíya̱ha̱ la séhya sín kꞌuítja ―mé xi̱kaha kjuako chꞌán Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ntá tí sín fariseo mé sákjuí sín ókjé la jnkoko̱á kjuenka̱yáxin sín kíxin tsja̱cha̱xi̱n sín tí chꞌín Jesús kíxin áchꞌe ichrén jie̱ tsjasin chꞌán la ntá tsjanchia sín jie̱. ");
INSERT INTO poeNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ntá ichrꞌán sín iso tí sín chꞌehe sín xra̱ la iso tí sín chꞌehe tí chꞌín Herodes xra̱ kíxin tsja̱cha̱xi̱n sín tí chꞌín Jesús. Ntá tí sín a nixje̱he̱ sín chꞌán ntáchro sín kíxin: ―Maestro, ó noheni kíxin tí nkehe ntáchrua jaha la chaxín, la ko ntoá tjàkua nti̱e Dios, la ko jehya nkexrí tsjehe chojni tjenka̱yáxixián kíxin á jína sín. ");
INSERT INTO poeNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","A̱ ntá jaha chro̱nka nkehe tjenka̱yáxian. ¿Á jína chrókjue̱nke̱heni tí gobierno romano o̱ náhí? ―ichro sín kjuanchankí sín. ");
INSERT INTO poeNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ntá chꞌín Jesús kónohe chꞌán kíxin ntoáhya tjenka̱yáxin sín ntá ntáchro chꞌán kíxin: ―Jahará ntoáhya tjenka̱yáxinrá. ¿Nkekuènte chrókjuácha̱xi̱nráni? ");
INSERT INTO poeNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Tjáko̱nará tí chichaon tjénke̱hérá sín méhe̱ ―mé xi̱kaha kꞌue̱to̱an chꞌín Jesús. Ntá kjuikohe sín chꞌán tí chichaon a. ");
INSERT INTO poeNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ntá kꞌuíkon chꞌín Jesús ntá kjuanchankí chꞌán kíxin: ―¿Nkexro tí tsíkꞌaxrjexín tjenkáni tí chichaon méhe̱ la ko nkexro ihni̱é chónta? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ntá kjuáte̱he sín kíxin: ―Tí chꞌín tꞌe̱to̱an mé tjenkáni chꞌán ―ichro sín. Ntá ntáchro chꞌín Jesús kíxin: ―Chróchje̱hérá tí chꞌín gobierno tꞌe̱to̱an tí nkehe kuènte chꞌán la kja̱xin tí nkehe kuènte Dios la chróchje̱hérá Dios ―mé xi̱kaha chro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ntá tí kuínhin sín xi̱kaha la chrakon sín la komá sín chꞌán ntá sákjuí sín. ");
INSERT INTO poeNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ntá tí ya̱on a la iso sín saduceo sákjuítsjehe sín tí chꞌín Jesús. A̱ ntá tí sín saduceo mé titekakonhya sín kíxin tsoxechón chojni tsíkꞌen la mé xi̱kaha chrókjua̱cha̱xi̱n sín chꞌín Jesús. Ntáchro sín kíxin: ");
INSERT INTO poeNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Maestro, tsíntáchro chꞌín Moisés kíxin tí itsꞌen ijnko chojni la na̱xa̱ itjen tí ichjién chꞌán la tsíkꞌikonhya sín xje̱en sín, ntá tí kíchó tí nkexro tsíkꞌen chrókuakja chꞌán tí tjan kꞌán, a̱ ntá tí xje̱en sín mé tsꞌóna éxí xje̱en tí chꞌín sa̱o tsíkꞌen. ");
INSERT INTO poeNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ntá ntihi kꞌuejó yato sín jnkoko̱á kíchó sín. Ntá tí chꞌín sa̱o kóte̱he chꞌán. La ntá ikꞌuén chꞌán. A̱ ntá kꞌuéchóntahya sín xje̱en sín la ntá tí ichjién chꞌán kóte̱he tjan tí chꞌín tsoyo. ");
INSERT INTO poeNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","A̱ ntá tí chꞌín yóxin ikꞌuén kja̱xin la tí chꞌín níxin kuákja chꞌán tjan la ntá xi̱kaha kónhen ínaá. La kayatoé tí sín kꞌuéchónta sín tjan xi̱kaha kónhen sín kaín sín ikꞌuén sín. ");
INSERT INTO poeNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","A̱ ntá kjuixixín ntá kja̱xin tjan ikꞌuén tjan. ");
INSERT INTO poeNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ntá tió tsoxechón kaín xín chojni tsíkꞌen, ¿ntá nkexro tsꞌóna xìi tí jehe tjan kíxin kayatoé sín kóte̱he tjan? ―mé xi̱kaha kjuanchankíhi sín tí chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ntá chꞌín Jesús kjuáte̱he chꞌán ntáchro chꞌán kíxin: ―Jahará la ntoáhya tjenka̱yáxinrá kíxin noahyará nkehe chro xroon itén Dios la ko chonhyará tí kjuachaxin kuènte Dios. ");
INSERT INTO poeNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","A̱ ntá tí chojni tsíkꞌen tió tsoxechón la tso̱te̱ehya sín la ko tso̱te̱ehya tí xje̱en sín kíxin tí sín tsíkꞌen la éxí tí sín ángel kuènte Dios tsꞌejó sín nkaya nka̱jní. ");
INSERT INTO poeNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","A̱ ntá tí kaín tí sín tsíkꞌen tsoxechón, ¿á kjui̱nchekuáxinhyará nkehe ntáchro Dios? Jehe chꞌán xi̱kihi chro chꞌán: ");
INSERT INTO poeNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Janhan mé tí Dios tinkáchónki chꞌín Abraham la ko chꞌín Isaac la ko chꞌín Jacob.” Méxra̱ tí Dios i la jehya tinkáchónki tí sín tsíkꞌen. Náhí. Tí Dios i la tinkáchónki tí sín tjejóchón ―mé xi̱kaha ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ntá kuínhin sín nkexrí kjuako chꞌán ntá chrakon sín. ");
INSERT INTO poeNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ntá tí sín fariseo mé tsíkójnkotsé sín tió kónohe sín kíxin nkehe chro chꞌín Jesús la ninkehó kjuáte̱ehya tí sín saduceo. ");
INSERT INTO poeNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","La ijnko tí sín maestro tjako tí ley mé tjinkaon chꞌán chrókjua̱cha̱xi̱n chꞌán tí chꞌín Jesús. Ntá kjuanchankí chꞌán kíxin: ");
INSERT INTO poeNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Maestro, ¿nkexéhe tí nkehe imá tjetoan kuènte tí ley? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ntá ntáchro chꞌín Jesús kíxin: ―“Chrótjuèhérá Ìnchéni Dios kaín a̱sánrá la ko kaín kjuaxrexinkaon kuèntárá.” ");
INSERT INTO poeNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Mé tíha mé tí ley imá tjetoan la ko sa̱oxín kꞌue̱to̱an Dios tíha. ");
INSERT INTO poeNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","A̱ ntá tí nkehe yóxin la tóyóhe̱ la mé ntáchro xi̱kihi: “Chrótjuèhérá kíchuárá éxí tjuèxínrá a̱sánrá.” ");
INSERT INTO poeNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Tí iyó nkehe i la mé a̱ntsí tjetoan kuènte tí ley tsíkꞌe̱to̱an Moisés la ko tí nkehe kjuako tí sín kꞌuéchrónka itén Dios. ");
INSERT INTO poeNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","A̱ ntá tí sín fariseo la na̱xa̱ jnkoko̱á tjejó sín ");
INSERT INTO poeNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","la ntá chꞌín Jesús mé kjuanchankí chꞌán ntáchro chꞌán kíxin: ―¿Nkehe tjenka̱yáxinrá jahará? ¿Nkexro tí Cristo la nkexro tí tsíkꞌaxrjeníxin chꞌán? ―kjuanchankí chꞌán. Ntá ntáchro sín kíxin: ―Tí Cristo mé tsíkꞌaxrjeníxin chꞌán chꞌín David ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ntá ntáchro chꞌín Jesús kíxin: ―¿Ntá nkexrí kíxin Ncha̱kuen Dios chénkaxín chꞌín David kíxin David chróntáchro chꞌán kíxin Ìnché chꞌán tí Cristo? Ntáchro chꞌín David xi̱kihi: ");
INSERT INTO poeNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ìnchéni Dios ntáche tí Ìnchéni kíxin: “Tjakꞌe tjaná chjina ntihó tséto̱an, tsjixinjian kaín xín tí sín nínkakonhan la tsjachahya sín tsꞌe̱to̱an sín kíxin jahvá mé tséto̱an.” Mé xi̱kaha chro itén Dios. ");
INSERT INTO poeNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","’A̱ ntá ¿xá nkexrí kíxin Cristo chrókꞌóna xje̱en David a̱ ntá jehe chꞌín David kui̱ki̱texín chꞌán Ìnché chꞌán tí Cristo? ―ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","A̱ ntá ninkexró xitjahya kjuáte̱he sín ninkehó la desde tí ya̱on a chrakon sín la í nínkehó kjuanchankíehya sín chꞌán.﻿ ");
INSERT INTO poeNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ntá kjuixin tíha ntá chꞌín Jesús mé nixje̱he̱ chꞌán tí chojni la ko tí sín kꞌuájiko chꞌán, ntáchro chꞌán kíxin: ");
INSERT INTO poeNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Tí maestro tjako tí ley la ko tí sín fariseo mé chónta sín kjuachaxin tsochrónkaxín sín tí ley kjuako chꞌín Moisés. ");
INSERT INTO poeNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Méxra̱ chrókjui̱nchexiteyéhérá kaín tí nkehe tꞌe̱to̱an sín la ko chrókjui̱chꞌerá kaín nkehe ntáchro sín kjánchó chrókuankíehyará tí jehe sín kíxin jehe sín la ijnko nkehe ntáchro sín la ókjé nkehe chꞌe sín. ");
INSERT INTO poeNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Tꞌe̱tue̱nhen sín chojni tsamá ijnko nkehe imá ye, mé ijnko nkehe chrókjuachahya chrókuamá chojni. A̱ ntá jehe sín na nijnko dedo tja sín chrókjuinki̱tsa sín tí nkehe imá ye yamá chojni. ");
INSERT INTO poeNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ichꞌe sín kaín xín nkehe kíxin tsotsjehe chojni. Tóxrjínhi̱n sín tsjakꞌenkáni totjen sín la ko itja sín ijnko xroon kjínjin iton tsꞌínixín itén Dios la tjinkaon sín iké sín síxinkáni nkehe tjáki̱ni. ");
INSERT INTO poeNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Tjinkaon sín tsochónta sín silla jína tsꞌejókjen sín sine sín tió sátsji sín tí siín kia la ko xritjeyá sín tí silla a̱ntsí náxrjón chrókꞌuejóya sín nkaxenhen ni̱nko. ");
INSERT INTO poeNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","La ko tjinkaon sín kíxin chojni chrókjuikosáyehe sín tsoxeta sín tí nti̱a la ko tjinkaon sín kíxin tsontáchro chojni kíxin maestro tí jehe sín. ");
INSERT INTO poeNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’A̱ ntá jahará la ti̱to̱éhyará kíxin tsontáchro sín kíxin maestro tí jahará kíxin jehe sín la ko jahará la ó jnkokónrá, la jahará chontará jnkoko̱á Maestro la mé Cristo tíha. ");
INSERT INTO poeNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","La ntá chróntáchrohyará kíxin ninkexró mé itꞌárá ntihi chjasintajni kíxin jahará la chontará jnkoko̱á Itꞌárá mé itjen nkaya nka̱jní. ");
INSERT INTO poeNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","La ko jehe sín chróntáchrohya sín kíxin jefe tí jahará kíxin jehó Cristo mé jefe. ");
INSERT INTO poeNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Tí nkexro a̱ntsí tsjinki̱tsa iso chojni la jehe chꞌán mé a̱ntsí tꞌe̱to̱an chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kíxin tí nkexro ntáchro kíxin imá ijié la mé imá tso̱ntsí. A̱ ntá tí nkexro nchehnkehya la a̱ntsí tso̱jié. ");
INSERT INTO poeNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’Nòará tí jahará maestro tjàkorá tí ley la ko tí jahará chojni fariseo. Jahará la jnkojínxónhya tjenka̱yáxinrá. Jahará la tꞌikjéhe̱rá tí puerta tsꞌixenxín chojni tí kjuachaxin kuènte Dios kíxin ti̱to̱éhyará tsꞌixenhen ókjé chojni. A̱ ntá ni jahará la xitjahya tꞌixe̱nhyará la ko tjánjonhyará kjuachaxin tsꞌixenhen tí sín tjinkaon chrókꞌuixenhen. ");
INSERT INTO poeNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’Nòará tí jahará maestro tjàkorá tí ley la ko chojni fariseo. Jnkojínxónhya tjenka̱yáxinrá. Jahará takitsjeherá nto̱e tí chojni tsíkókꞌán la ntá isé nixje̱hérá Dios kíxin chꞌiyexínrá chojni kíxin jína tí jahará. A̱ ntá xi̱kaha kjui̱chꞌerá jahará la a̱ntsí tsjasótiará. ");
INSERT INTO poeNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’Nòará tí jahará maestro tjàkorá tí ley la ko chojni fariseo. Jahará la jnkojínxónhya tjenka̱yáxinrá. Jahará sátjirá nonte la chrítaón nta̱yaon kíxin tsjákohérá ijnko chojni tsinkáchónki xi̱kaha tí tinkachónkirá la ntá tió kjuachará kjuachroerá sín la ntá jehe sín a̱ntsí má tsjasótexín sín tí xrohi la kánhyó jahará. ");
INSERT INTO poeNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’Nòará tí jahará kíxin této̱anrá kjánchó ntakótánrá. Ntáchrorá kíxin tí jnkojín chojni tsontáchro kíxin sinchexiteyá sín nkehe la tꞌákjenxi̱n sín tí ni̱nko la ntá tꞌichjánxi̱nhya sinchexiteyá sín. A̱ ntá tí tsontáchro sín kíxin sinchexiteyá sín nkehe la tꞌákjenxi̱n sín tí chica oro siín nkaxenhen ni̱nko la ntá tꞌichjánxi̱n sinchexiteyá sín. ");
INSERT INTO poeNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Imá lo̱nti̱rá la ko ntakótánrá. ¿Á imá tjetoan tí chica oro o̱ á imá tjetoan tí ni̱nko kíxin tí ni̱nko mé kótjuáxin tí chica oro? ");
INSERT INTO poeNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kja̱xin ntáchrorá kíxin: “Tí jnkojín chojni tsontáchro sín kíxin sinchexiteyá sín nkehe la tꞌákjenxi̱n sín tí altar la ntá tꞌichjánxi̱nhya sinchexiteyá sín. A̱ ntá tí tsontáchro sín kíxin sinchexiteyá sín nkehe la tꞌákjenxi̱n sín tí nkehe tjo̱ke̱he̱ sín Dios chrítaón tí altar la ntá tꞌichjánxi̱n sinchexiteyá sín tí nkehe tsíntáchro sín.” ");
INSERT INTO poeNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Imá lo̱nti̱rá la ko ntakótánrá. ¿Á imá tjetoan tí nkehe tsochje̱hérá Dios o̱ á imá tjetoan tí altar kíxin tí altar mé tótjuáxin tí nkehe tsjánjonrá? ");
INSERT INTO poeNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kíxin tí nkexro tsontáchro kíxin sinchexiteyá nkehe la tꞌákjenxi̱n chꞌán tí altar la jehya tꞌákjenxi̱n chꞌán tí altar ó. Náhí. Kja̱xin tꞌákjenxi̱n chꞌán kaín tí nkehe siín chrítaón ntiha. ");
INSERT INTO poeNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","A̱ ntá tí nkexro tsontáchro kíxin sinchexiteyá chꞌán nkehe la tꞌákjenxi̱n tí ni̱nko la jehya tꞌákjenxi̱n chꞌán ni̱nko ó. Náhí. Kja̱xin tꞌákjenxi̱n chꞌán tí Dios itjen ntiha. ");
INSERT INTO poeNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","A̱ ntá tí nkexro tꞌákjenxi̱n nkaya nka̱jní la ntá kja̱xin tꞌákjenxi̱n sín tí trono kuènte Dios la ko tí nkexro tjetꞌe̱to̱an ntiha. ");
INSERT INTO poeNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’Nòará jahará maestro tjàkorá ley la ko jahará chojni fariseo. Jahará jnkojínxónhya tjenka̱yáxinrá. Jahará la chje̱hérá Dios ijnko ite parte kaín tí kaxro̱a̱n tsjiko tí nkehe ineni, mé tí menta la ko anís la ko comino. Kjánchó tahyará kuentá tí nkehe imá tjetoan kuènte tí ley. Mé ntoá chrókjuenka̱yáxinrá la ko chrókui̱konóe̱hérá kíchuárá la ko chrókuinkachónkirá Dios. Tíhi la a̱ntsí tjetoan chrókjui̱nchexiteyárá la kja̱xin chrókui̱to̱éhyará chrokjui̱chꞌerá tí í so nkehe. ");
INSERT INTO poeNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Jahará la této̱anrá kjánchó ntakótánrá. Jahará la nchekꞌankihirá kjónté ijnko kochji̱se̱n intsí chónta tí nkehe itsꞌirá, a̱ ntá ijnko kocamello kjónté ijié va la tꞌínka̱rá. ");
INSERT INTO poeNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’Nòará tí jahará maestro tjàkorá ley la ko jahará fariseorá. Jahará la jnkojínxónhya tjenka̱yáxinrá. Jahará la imá nchetjóárá chrítaón tí vaso la ko tí plato, a̱ ntá tí nkaxenhen tsíkaón kjuache̱e la ko jahórá tjinkáonrá chróchontará itsjé nkehe. ");
INSERT INTO poeNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Jahará chojni fariseorá imá ntakótán jahará. Sa̱oxín chrókjui̱nchetjóárá tí nkehe nkaxenhen tí vaso la ko tí plato la ntá ó chrókótjóá tí chrítaón kja̱xin. ");
INSERT INTO poeNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’Nòará jahará maestro tjàkorá tí ley la ko chojni fariseorá. Jnkojínxónhya tjenka̱yáxinrá. Jahará la éxí yóhe̱ ijnko tòye̱ tsíxravá chojni, imá náxrjón tsjehe ntója, a̱ ntá nkaxenhen mé tsíkaón huésoé chojni tsíkꞌen la ko kaín nkehe tjuáhya. ");
INSERT INTO poeNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Mé xi̱kaha tí jahará la tsjehe éxí chojni jína xi̱kaha, a̱ ntá jnkojínxónhya tjenka̱yáxinrá la ko jínahyará. ");
INSERT INTO poeNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’Nòará tí jahará maestro tjàkorá ley la ko chojni fariseorá. Jahará la jnkojínxónhya tjenka̱yáxinrá. Jahará la kjui̱chꞌénará tja̱tꞌo̱ náxrjón chrítaón tí tòye̱ tsíxravá tí sín kꞌuékjako itén Dios ósé la ko nchekꞌítsará tja̱tꞌo̱ chrítaón tòye̱ kuènte tí sín jína a̱sén. ");
INSERT INTO poeNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","La ntá ntáchrorá kíxin tí chrókꞌuejorá tí kꞌuéjó tí sín tsíkꞌaxrjeníxinrá la ntá chrókjuínki̱tsahyará chrókꞌuén tí sín kjuako itén Dios. ");
INSERT INTO poeNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Méxra̱ xi̱kaha jahórá ntáchrorá kíxin chaxín tsíkꞌaxrjeníxinrá tí sín kꞌóyán tí sín kꞌuékjako itén Dios. ");
INSERT INTO poeNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Méxra̱ ijie la tjinkáonrá tsjixinhanrá tí xra̱ kjuíchꞌe tí sín tsíkꞌaxrjeníxinrá. ");
INSERT INTO poeNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’Jahará la tsíkꞌaxrjeníxinrá konche. ¿Ntá nkexrí chrókuaárá kíxin itsi tí tsjasótiará? ");
INSERT INTO poeNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Méxra̱ janhan mé tsétua̱nha̱n chojni chrónka itén Dios la ko chojni imá nohe la ko chojni tjako, itsi sín. A̱ ntá jahará la tsꞌoyánrá sín tsꞌejoyánirá sín ntacruz la í so sín la tsjatexínrá sín nkaxenhen ni̱nko la ko tsochonkíhirá sín chjasin la chjasin. ");
INSERT INTO poeNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Méxra̱ jahará la yamárá tí jie̱ kíxin tí sín jína kꞌuítjixín ijni̱é senó. Méxra̱ tsamárá tí jie̱ kíxin ikꞌuén chꞌín Abel, tí nkexro jína, la ko kaín tí í so sín hasta ikꞌuén chꞌín Zacarías, xje̱en Berequías, tí nkexro kꞌoyánxinrá chjino tí altar. ");
INSERT INTO poeNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Chaxín tjo̱nka̱rá kíxin kaín tí jie̱ a mé yámá tí chojni siín ijie. ");
INSERT INTO poeNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ntá ntáchro chꞌín Jesús kíxin: ―Jerusalén, Jerusalén, jahará tꞌoyánrá tí sín tjako itén Dios la chje̱hérá xro̱ tí sín ichrꞌán chꞌán ikui chrókjuinki̱tsará. Nchónhya veces tjínka̱van chrókójnkotsérá la chrókꞌuáyakonhánrá éxí ijnko cochíká mé tꞌayakonhen xje̱en va chrínkí ka̱ne̱ne̱e va mé xi̱kaha tjínka̱van chrókꞌuáyakonhánrá tí jahará. Kjánchó jahará la tjinkákonhyará xi̱kaha. ");
INSERT INTO poeNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ntá jie la Dios la tsíto̱he tí jahará. ");
INSERT INTO poeNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ntáxrja̱n kíxin í tsꞌikonhyará tí janhan ínaá tsjixrakájia tí ya̱on tsontáchrorá kíxin: “Imá jína tí nkexro kui̱xi̱n kjua̱cha̱xién ihni̱é Ìnchéni” ―mé xi̱kaha ichro chꞌín Jesús.﻿ ");
INSERT INTO poeNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ntá chꞌín Jesús kꞌuaxrjexín chꞌán tí ni̱nko la ntá ó sáchrókjuí chꞌán la ntá tí sín kꞌuájiko chꞌán mé kóchjina sín kíxin tsochónhen chꞌán kíxin kja̱xin chꞌán chrótsjehe chꞌán kíxin náxrjón tsíkꞌóna tí ni̱nko a. ");
INSERT INTO poeNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","A̱ ntá chꞌín Jesús mé kjuáte̱he chꞌán kíxin: ―Jahará ¿á tjejotsjehérá kaín tíha? Chaxín tjo̱nka̱rá kíxin tsjixraká tí ya̱on tsꞌo̱ya̱ kuenté ni̱nko. Nijnko xro̱ tsꞌejókjenhya kíchó kíxin kaín tíha la tso̱xíka ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ntá sákjui̱ sín chrítaón tí jna̱ Olivo la chꞌín Jesús kjuákꞌetja̱xi̱n chꞌán la ntá tí sín kꞌuájiko chꞌán mé kjuanchankíhi sín chꞌán kíxin: ―Tjinkaonni tso̱chro̱nka nkesá tso̱nhen tíha. ¿Nkexrí tso̱noexínni tió tsꞌinka tí jaha la ko nkexrí tso̱noexínni tí itsi tí tsjixixín chjasintajni? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Kjuáte̱he chꞌín Jesús kíxin: ―Tóxakonhanrá ti̱to̱éhyará kíxin ninkexró chrókjuitꞌáyahará. ");
INSERT INTO poeNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Nchónhya chojni itsi sichꞌiyaxín ni̱na tsontáchro kíxin: “Janhan mé tí Cristo” tsixro sín, la sichꞌiyehe sín nchónhya chojni. ");
INSERT INTO poeNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","A̱ ntá tió tsinhínrá tsontáchro chojni kíxin ó siín kjuanínkaon la ko tsꞌixin kjuachrakon kíxin tsjanjo̱nko kíchó sín la kjónté xi̱kaha tso̱nhen la chrakonhyará. Ó jehí tso̱nhen tíha tí na̱xa̱ tsꞌitjáyanhya chjasintajni. ");
INSERT INTO poeNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ijnko nación tsjanjo̱nko í jnko nación la tsjanjo̱nxi̱n sín tí xra̱ tsꞌe̱to̱an sín. La ko itsjé chjasin na tso̱kjinta la ko tso̱níhi chojni la ko ntihi la ntaha tsinkí nonte. ");
INSERT INTO poeNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Kaín tíha la ntá tsoxrankíxixón tí kjuatjoté tso̱nhen chojni. ");
INSERT INTO poeNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’A̱ ntá tsotsérá chojni la tsjikaánrá sín tí tjejó tí síxre̱é kíxin sinchekjasótiará sín la ntá tsꞌóyánrá sín. La ko kaín xín chojni siín chjasintajni tso̱nínkakonhanrá sín kíxin tinkachónkirá tí janhan. ");
INSERT INTO poeNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ntá tí ya̱on a la itsjé sín la tsíto̱he sín tsinkáchónkihya sín tí janhan la ko tso̱nínkakonhen sín kíchó sín la ko sinchekji kíchó sín. ");
INSERT INTO poeNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ntá itsi nchónhya chojni ntoáhya tsjako la ntá sichꞌiyehe sín nchónhya chojni. ");
INSERT INTO poeNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","La tsꞌixin nchónhya jie̱ jínahya la ntá tsꞌixin itsjé chojni tsotjuèhya sín kíchó sín. ");
INSERT INTO poeNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","A̱ ntá tí nkexro na̱xa̱ tjejótinkáchónki tí janhan hasta tí tsjixixín la mé tsaá. ");
INSERT INTO poeNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","La ko tí itán jína chrónka nkexrí tjen tí kjuachaxin kuènte Dios la tꞌichjánxi̱n tsinhin sín kuenté chjasintajni, la tió tsjixin tsinhin sín kuenté chjasintajni la ntá ó tsꞌítjáyan chjasintajni. ");
INSERT INTO poeNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Chꞌín Daniel kꞌuéchrónka itén Dios mé tsíkjin chꞌán kíxin tsjixraká ijnko ya̱on tsjakꞌe ijnko nkehe jínahya nkaxenhen ni̱nko tjóá. Ntá jahará tsꞌikonrá tíha. A̱ ntá tí nkexro nchekuáxin mé tsienxín nkehe tíha. ");
INSERT INTO poeNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ntá kaín tí sín tjejó estado Judea tsochrìin sín jna̱ sátsji̱ sín. ");
INSERT INTO poeNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","A̱ ntá tí sín tjejó chrítaón nchia nto̱é sín la í xitjahya tsakitsje sín ninkehó. ");
INSERT INTO poeNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ntá tí tjejóchꞌe sín xra̱ no̱nte̱e sín la kjá í tsokjanhya sín tsjikakja sín iké sín. ");
INSERT INTO poeNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ntá nòa tí chojni chjin tjejóyá sín la ko nòa tí sín nchekakí xjan tí ya̱on a. ");
INSERT INTO poeNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Chrókjuanchehérá Dios kíxin tí tso̱nhen tíha la chrókójehya ncha̱kuen kin la ko chrókójehya tí ya̱on tꞌo̱kꞌéhe chojni. ");
INSERT INTO poeNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kíxin tíha mé ijnko kjuachrakon imá ijié la desde tí xrankíxixín chjasintajni la nunca xi̱kahya kónhen. ");
INSERT INTO poeNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ntá tí chrókꞌue̱to̱anhya Dios kíxin tjoka tsꞌatsínka tíha ntá chrókuaáhya ninkexró. Ntá tsꞌe̱to̱an chꞌán kíxin tjoka tsꞌatsínka tí kjuachrakon jié kíxin jehe chꞌán mé imá tjuèhe chꞌán tí sín tsíkjeyá chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Ntá tí tsontáchro chojni kíxin: “Tsjehé ntihi itjen Cristo”, o̱ “Tsjehé ntiha itjen chꞌán”, la ntá chrókuítekákuénhyará sín. ");
INSERT INTO poeNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kíxin ntá itsi iso sín tsontáchro sín kíxin Cristo tí jehe sín la ko kja̱xin itsi í so sín ntoáhya tsjako la ko tsjasin sín kjuaxroan jié kíxin tjinkaon sín chrókjuichꞌiyehe sín chojni kjónté tí sín tsíkjeyá Dios. ");
INSERT INTO poeNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ó xrja̱nka senó nkehe tso̱nhen kíxin tso̱nohará. ");
INSERT INTO poeNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Méxra̱ tí chróntáchro sín kíxin: “Tsjehérá tí nte̱je̱ ntiha tjen chꞌán”, la ntá tsjihyará nó ntiha. O̱ tí chróntáchro sín kíxin: “Tsjehérá ntihi tí cuarto mé tjen chꞌán”, la chrókuítekákonhyará. ");
INSERT INTO poeNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Méxra̱ éxí tsjo̱nkíxín la tꞌikon chojni tꞌinkaséyanxín tí tji̱to̱xi̱n ya̱on hasta tsjiatóxin ya̱on mé xi̱kaha tsꞌikon chojni tió itsi tí Xje̱en Dios Kꞌóna Chojni. ");
INSERT INTO poeNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Mé éxí yóhe̱ tí tjen ijnko cuerpo tsíkꞌen la ntiha tso̱jnkotsé tí konte̱xjue̱n. ");
INSERT INTO poeNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’A̱ ntá séhyó tí tsjixixín tí kjuachrakon jié la ntá tí ya̱on la tso̱tie a̱ ntá tí nitjó la í tsꞌinkaséyanxínhya. La ko tí konotsé la tsoxènjinxín nka̱jní la kja̱xin kaín nkehe siín nkaya nka̱jní la tsinkí. ");
INSERT INTO poeNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","La ntá tsꞌikon chojni kíxin nka̱jní tsi̱xi̱n tí Xje̱en Dios Kꞌóna Chojni. La ntá kaín chojni chjasintajni tsochrakon sín la tsotsjánka sín la tsꞌikon sín kíxin itsi tí Xje̱en Dios Kꞌóna Chojni, mé chríkjan tjui̱ mé tsjakꞌenkakjan chꞌán tsi̱ka̱o tí kjuachaxin jié. ");
INSERT INTO poeNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ntá tsochrꞌán Dios tí sín ángel kíxin tsꞌánoa sín tí trompeta itsen kíxin tso̱chjina kaín tí nkexro kjueyá Dios tsji̱xi̱n kano̱é lado chjasintajni. ");
INSERT INTO poeNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Chrókꞌuitjará nkexrí si̱ntayóa̱xian kuènte ijnko nta to higo. Éxí yóhe̱ tió chónta ntahnte̱ la ko tsꞌixin kayoa la nta tso̱noaxínrá kíxin í séhya tsokjan ichrin. ");
INSERT INTO poeNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Mé xi̱kaha tí tsꞌikonrá tsꞌatsínka kaín tíha la ntá xi̱kaha tso̱noaxínrá kíxin í séhya itsi Ìnchéni. ");
INSERT INTO poeNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ntá tjo̱nka̱rá chaxín kíxin kaín tíha senó tso̱nhen tí na̱xa̱ tsꞌenhya tí chojni siín jie. ");
INSERT INTO poeNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","A̱ ntá tí nka̱jní la ko tí chjasintajni mé tsꞌitjáyan. A̱ ntá tí nkehe ntáxrja̱n la nunca tsꞌitjáyanhya tsoxiteyá tíha. ");
INSERT INTO poeNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Á ntá tí ya̱on la ko tí hora tsoxiteyá tíha la kohya ninkexró nohe. Ni tí sín ángel tjejó nkaya nka̱jní noehya sín la ko ni tí Xje̱en Dios noehya. Ó jehó tí Itꞌé mé nohe. ");
INSERT INTO poeNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Éxí yóhe̱ tí nkehe kónhen tí ya̱on kꞌuékjakꞌe chꞌín Noé mé xi̱kaha tso̱nhen tí tsokjan tí Xje̱en Dios Kꞌóna Chojni. ");
INSERT INTO poeNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tí na̱xa̱ titjiéhya sín nta̱ la kaín chojni la jína kꞌuéjó sín la kjóne sín la ko ikꞌuí sín la ko sítóte̱he sín kjuixrakájia tí ya̱on kꞌuíxenhen chꞌín Noé ntabárco̱. ");
INSERT INTO poeNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","A̱ ntá jehe sín mé kienxínhya sín hasta kuijia tí kꞌuániá chrin ntá ikui nta̱ la kꞌuátjoá kaín sín. Mé xi̱kaha tso̱nhen tió itsi tí Xje̱en Dios Kꞌóna Chojni. ");
INSERT INTO poeNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","A̱ ntá yaá chojni ntoa tjejóchꞌe sín xra̱ nonte la ntá ijnko la sátsji̱ la í jnko la tsito̱he. ");
INSERT INTO poeNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","La ko yaá chojni chjin mé tjejótꞌo sín la ijnko la sátsji̱ la í jnko la tsito̱he. ");
INSERT INTO poeNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Chrókꞌuejotsjehérá kíxin noahyará nkehora la ko nkesá tsꞌinka janhan. ");
INSERT INTO poeNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Chrókónohará tíhi: tí chrókónohe ijnko ìnché nchia nkehora tie chrókjui ijnko nkexro tseé la ntá chrókjuakꞌechónhen tí ìnché tí nchia ntá xitjahya tsꞌixenhen tí nkexro tjinkaon chrókueé. ");
INSERT INTO poeNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Méxra̱ jahará la jína chrókꞌuejorá kíxin tí Xje̱en Dios Kꞌóna Chojni me titàya̱ itsi. ");
INSERT INTO poeNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’Tí nkexro chaxín chꞌe xra̱ jína la ko imá nohe la ntá tí lámoé chꞌán tsꞌe̱tue̱nhen kíxin tsꞌayakonhen chꞌán tí sín siín nto̱e chꞌán la ko tsjanjon chꞌán nkehe sine sín chi̱nti̱i tí hora a. ");
INSERT INTO poeNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Náxrjón tjen tí nkexro chꞌe xra̱ tió itsi tí lamo la tsꞌikon kíxin xi̱kaha tjenchexiteyá chꞌán tí xra̱ kꞌuítuenhen chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Chaxín tí lamo la tsjanjon chꞌán kaín tí xra̱ chónta chꞌán tsꞌe̱to̱an tí chꞌín a. ");
INSERT INTO poeNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","A̱ ntá ijnko chojni chꞌehya xra̱ jína la ntá tsjenka̱yáxin chꞌán kíxin kjá tjokahya tsokjan tí lámo̱e chꞌán ");
INSERT INTO poeNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","la ntá tsjankíxin chꞌán tsjanjo̱nko chꞌán tí í so sín chꞌe xra̱ la ko tsjankíxin sineko chꞌán la ko itsꞌika̱o chꞌán kaín tí sín sítókoan. ");
INSERT INTO poeNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ntá xrína̱hya tsokjan ti lamo ijnko ya̱on la ko ijnko hora noehya tí nkexro chꞌe xra̱. ");
INSERT INTO poeNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","La ntá jehe chꞌán la sinchekjasóte tí chꞌín kuíto̱hehe xra̱ kjuínchexiteyáhya la tsꞌe̱to̱an chꞌán kíxin tsjasóte tí chꞌín a éxí tí sín jnkojínxónhya tjenka̱yáxin. Ntá ntiha la tsotsjánka chꞌán la ko sinetaón neno chꞌán.﻿ ");
INSERT INTO poeNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ntáchro chꞌín Jesús kíxin: ―Tí kjuachaxin kuènte Dios mé éxí yóhe̱ ite sín tjarisoá sátsji tí tso̱te̱he chojni chuénko linterna tjiá aceite la sákjuíchónhen sín tí chꞌín tsíkóte̱he. ");
INSERT INTO poeNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Inꞌó sín la tsíkóyaxíenhya sín la inꞌó sín ó tsíkóyaxínhin sín. ");
INSERT INTO poeNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Tí sín tsíkóyaxíenhya na kja̱xin la tsíkjijiko sin linterna kjánchó tsíkjijikohya sín aceite tsi̱ki̱a ínaá. ");
INSERT INTO poeNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","A̱ ntá tí sín tsíkóyaxínhin la sátsíkjiko sín xro̱ tjiá aceite la ko tí linterna kuènte sín. ");
INSERT INTO poeNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","A̱ ntá tí chꞌín tsíkóte̱he la tjokahya kui chꞌán la ntá jehe sín mé tsíkihi sín kotáchrín la tsíkꞌejójua sín kaín sín. ");
INSERT INTO poeNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","A ntá kuichjina kꞌáxrótjen la kuínhin sín tꞌèya ijnko chojni kíxin: “Ó kui tí chꞌín tsíkóte̱he na tꞌaxrjerá ntója tsoxetará chꞌán”, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","A̱ ntá kaín tí sín tjarisoá la kꞌuàya sín la kjuasiyóxin sín tí linterna kuènte sín. ");
INSERT INTO poeNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","A̱ ntá ti inꞌó sín tsíkóyaxíenhya la nixje̱he̱ sín tí sín inꞌó tsíkóyaxínhin ntáchro sín kíxin: “Chje̱héni intsí aceite kuèntárá kíxin ó kꞌuànka̱ aceite tjiá linternéni”, ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","A̱ ntá tí sín tsíkóyaxínhin mé ntáchro sín kíxin: “Náhí, tí aceite tí xi̱kaha tsjanjonni intsí jahará la a̱ntsí jeheni la tsjachahya. Íchá jína sátjikꞌènará tí sítoxi̱n ntiha”, ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ntá tí inꞌó tí sín kóyaxíenhya mé sákjuíkꞌe̱na sín aceite la ntá ó kui tí chꞌín tsíkóte̱he. Tí inꞌó sín tjejóchónhen mé sákjui̱ko sín chꞌán tí kia tsíkóte̱he sín la ntá ó tuénxín kꞌuikjéhe̱ tí puerta. ");
INSERT INTO poeNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ntá chrꞌéxi̱n ikui tí inꞌó sín tjarisoá tsíkóyaxíenhya la tꞌínka sín puerta ntáchro sín kíxin: “Ó kuini takitje̱hé nchia.” ");
INSERT INTO poeNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","A nta jehe chꞌan kjuáte̱he chꞌán ntáchro chꞌán kíxin: “Chaxín tí jahará la ní chonhyará”, ichro chꞌan. ");
INSERT INTO poeNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ntá ntáchro chꞌín Jesús ínaá kíxin: ―Méxra̱ xi̱kaha tí jahará chrókꞌuejótsjehérá kíxin noahyará nkeya̱on la nkehora itsi ti Xje̱en Dios Kꞌóna Chojni ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ntá ntáchro chꞌín Jesús kíxin: ―Tí kjuachaxin kuènte Dios la yóhe̱ ijnko chojni tjinkaon sáchrókjui chꞌán í jnko nación la ntá kꞌuíye̱he̱ chꞌán tí sín chꞌehe chꞌán xra̱ la ntá chjéhe chꞌán sín tí chichaon a kíxin tsꞌayakonhen sín. ");
INSERT INTO poeNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Ijnko chꞌán la kꞌuáyéhe̱ chꞌán inꞌó mil chichaon, la í jnko la kꞌuáyéhe̱ chꞌán iyó mil chichaon, la í jnko la kꞌuáyéhe̱ ijnko mil chichaon. Tí nkexro kjuanjon chichaon la mé kónohe chꞌán nkexro ti tsjacha sichꞌe jnkojnko xra̱. Ntá jehe chꞌán tió kjuixin kjuanjon chꞌán la ntá sakjuí chꞌán ikjín. ");
INSERT INTO poeNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ntá tí nkexro kꞌuáyéhe̱ inꞌó mil chichaon la kjuíchꞌeko chꞌán xra̱ tí chichaon kuákja chꞌán la kjuacha chꞌán í jnko inꞌó mil. ");
INSERT INTO poeNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Kja̱xin tí nkexro kꞌuáyéhe̱ iyó mil chichaon mé xíkjacha chꞌán í jnko iyó mil. ");
INSERT INTO poeNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","A̱ ntá tí nkexro kꞌuáyéhe̱ ijnko mil chichaon mé sákjuí chꞌán la kjuíchꞌéna chꞌán ijnko tòye̱ kjua̱vá chꞌán tí chichaon kuènte lámo̱é chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","A̱ ntá nchónhya nánó kꞌuátsínka la ntá ikjan tí lámo̱é sín kíxin ntá tsjentoáko sín chꞌán cuenta. ");
INSERT INTO poeNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Sa̱oxín kui tí nkexro kꞌuáyéhe̱ tí inꞌó mil la chjéhe chꞌán tí lamo í jnko inꞌó mil la ntáchro chꞌán kixin: “Jaha me chje̱héni inꞌó mil la ó kjuachani í jnko inꞌó. Tákjá tjinhin tí chichaon i”, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ntá tí lamo mé ntáchro kíxin: “Ncho̱xon tí xi̱kaha. Jaha la ijnko chojni jína chꞌe xra̱. La ó kjui̱nchexiteyá jína. Kjónté jehya xra̱ jié la kjui̱nchexiteyá jína la ntá tso̱tja̱ha ijnko xra̱ a̱ntsí jié la tjakꞌe tso̱chéhe̱ni.” ");
INSERT INTO poeNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ntá chrꞌéxi̱n ikui tí nkexro kꞌuáyéhe̱ iyó mil la ntáchro chꞌán kíxin: “Jaha mé chje̱héni iyó mil la kjuachani í jnko iyó. Tákjá tjinhin tí chichaon i”, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","La ntá tí lamo ntáchro kíxin: “Ncho̱xon jaha mé ijnko nkexro jína chꞌe xra̱ la ó kjui̱nchexiteyá. Kjónté jehya xra̱ jié la kjui̱nchexiteyá jína la ntá tso̱tja̱ha í jnko xra̱ a̱ntsí jié. Tjakꞌe tso̱chéhe̱ni”, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","A̱ ntá ikui tí chꞌín kꞌuáyéhe̱ ijnko mil la ntáchro chꞌán kíxin: “Ó nòna kíxin ijnko chojni imá jie̱he tí jaha la itja̱a tí nonte jehya jaha kꞌuénka̱xian la tsákjá nkehe kjónté kꞌuénka̱hya. ");
INSERT INTO poeNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Méxra̱ chrakonni la sákjuíkjakꞌemáni tí chichaon chrínkí nche. Tákjá chi̱cha̱ko̱an tjinhin”, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","A̱ ntá kjuáte̱he tí lamo kíxin: “Jaha ijnko chojni jínahya la ko séhe. Jaha la ó noha kíxin chrótja̱a tí nonte kꞌuénka̱hya la chrókuákjaá tí nkehe kꞌuénka̱hya. ");
INSERT INTO poeNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","A̱ ntá tí chichaon chróchrꞌan banco. Ntiha chrókjuichꞌexín xra̱ ntá tí ikjan janhan ntá chrókꞌuayáha̱ a̱ntsí itsjé chichaon chrókjuacha kíchó chica”, ichro tí lamo. ");
INSERT INTO poeNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","A̱ ntá nixje̱he̱ chꞌán tí í so sín tjejó la ntáchro chꞌán kíxin: “Takitsjehérá tí mil chónta chꞌán la chje̱hérá tí nkexro chónta tí ite mil chichaon ");
INSERT INTO poeNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","kíxin tí nkexro kjónté itsjé chónta la mé tsꞌáyéhe̱ a̱ntsí la ntá tí nkexro chóntahya la kjónté tí intsí chónta la tsꞌaxrjehe. ");
INSERT INTO poeNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","A̱ ntá tí nkexro chꞌehya xra̱ la tsétue̱nhén sátsji chꞌán tí sítié ntója la ntá ntiha la tsotsjánka chꞌán la ko sinetaón chꞌán neno chꞌán.” ");
INSERT INTO poeNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’A̱ ntá tí tsi tí Xje̱en Dios Kꞌóna Chojni la tsi̱ka̱o chꞌán kjua̱cha̱xién jié éxí ijnko Réy la ko tsi̱ka̱o chꞌán kaín xín tí sín ángel ntá ntaha tsjakꞌetja̱xi̱n chꞌán tí trono tsꞌe̱to̱anxín tí kjua̱cha̱xién jié. ");
INSERT INTO poeNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ntiha kaín xín tí chojni tsíkji̱xi̱n nkuíxín nación tso̱chjina tí tjen chꞌán la jehe chꞌán tsakitsjekjan chꞌán ijnko la í jnko. Éxí ijnko nkexro tꞌayakonhen kolélo mé tsakitsjekjan chꞌán tí kolélo la ókjé tsꞌixin va la ko tí kotèntso̱ la ókjé tsꞌixin. ");
INSERT INTO poeNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Méxra̱ tsꞌe̱to̱an chꞌán kíxin tí kolélo la tsꞌixin nó tja chꞌán chjina, a̱ ntá tí kotèntso̱ la nó ti tja chꞌán kjon. ");
INSERT INTO poeNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ntá tí Rey tsonixje̱he̱ tí sín tjejó tja chꞌán chjina tsontáchro kíxin: “Xrákirá jahará ti tjen kjuachaxin kuènte Tꞌaná kíxin Tꞌaná ó kjuíncheyaonrá chꞌán. Tí na̱xa̱ kjuíchꞌénahya Dios chjasintajni la xráxín kjuenka̱yáxin chꞌán xi̱kaha tso̱nhen. ");
INSERT INTO poeNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Janhan mé kꞌuén kjinta la jahará kjuánjonrá nkehe kjoné. La ikꞌuén nta̱ la jahará kjuánjonrá nkehe ikꞌuia, la kꞌuájia éxí ijnko chojni kjui̱xi̱n ikjín la jahará kjuánjonrá nketí kꞌo̱kꞌàna. ");
INSERT INTO poeNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","La ko kꞌuéchontahya kaná la jahará kjuánjonrá ika kꞌuítsa̱, la ko kónìna la jahará kjuasántsjehérá ti janhan, la kjuakꞌéchjina la ntá jahará kjuasántsjehérá tí janhan.” ");
INSERT INTO poeNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","A̱ ntá tí sín jína la tsjanchankí sín kíxin: “Ìnchéni, ¿nkesá kꞌuíkonni kíxin ikꞌuén kjinta ntá kjuanjonni nkehe kjónte? ¿La nkesá kꞌuíkonni kíxin ikꞌuén nta̱ la kjuanjonni nkehe ikꞌuia? ");
INSERT INTO poeNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿La ko nkesá kꞌuíkonni kíxin ikjín kjuíxian ntá kjuanjonni nketí kꞌo̱kꞌáha? ¿La ko nkesá kꞌuíkonni kíxin chontahya iká la kjuanjonni ika kꞌuítsa̱? ");
INSERT INTO poeNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿La nkesá kꞌuíkonni kíxin kóníha o̱ kjuákꞌechjina la ntá kjuíjitsjeheni tí jaha?” mé xi̱kaha tsjanchankíhi sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","A̱ ntá tí Rey tsontáchro kíxin: “Tió kjuínki̱tsará ijnko kíchó ni kjónté ijnko chojni nòé la mé yóhe̱ kíxin tí janhan chrókjuínki̱tsará.” ");
INSERT INTO poeNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’A̱ ntá tí Rey tꞌe̱to̱an mé tsonixje̱he̱ tí sín tjejó nó tja chꞌán kjon tsontáchro kíxin: “Sátjirá jahará kíxin jahará tsjasótiará. Sátjirá tsjasótiará tí tjen tí xrohi tsꞌankahya. Mé tí xrohi tjechónhen kíxin tsoche tí chꞌín Tsochren la ko kaín tí sín ángel kuènte chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Tí ikꞌuén kjinta la jahará kjuánjonhyará nkehe kjoné la ko ikꞌuén nta̱ la jahará kjuánjonhyará nkehe ikꞌuia. ");
INSERT INTO poeNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Kꞌuájia éxí ijnko nkexro kjui̱xi̱n kjín la jahará kjuánjonhyará nketí kꞌókꞌàna la ko kꞌuéchontahya kaná la jahará kjuánjonhyará ka chrókꞌuítsa̱ la ko kꞌuénìna la kjuakꞌéchjina la jahará kjuasántsjehyará tí janhan.” ");
INSERT INTO poeNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ntá tí jehe sín la tsjanchankí sín kíxin: “Ìnchéni, ¿nkesá kꞌuíkonni kíxin ikꞌuén kjinta la ikꞌuén nta̱ la ko kjuíxian kjín la ko chontahya iká la ko níha la ko kjuákꞌechjina? ¿Mé nkesá kꞌuíkonni xi̱kaha la ntá kjuínki̱tsahyani ti jaha?” tsixro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","La ntá tí Rey tsjate̱he chꞌán tsontáchro chꞌán kíxin: “Tí xi̱kaha kaín tíha kjuínki̱tsahyará ijnko chojni imá nòé la éxí xi̱kaha kjuínki̱tsahyará tí janhan.” ");
INSERT INTO poeNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","A̱ ntá tí sín jínahya xi̱kaha kjuíchꞌe la mé sátsjixin sín ntihi tsjasóte sín jnkochríxín. A̱ ntá tí sín jína la sátsji̱ sín tsꞌáyéhe̱ sín kjuachón jnkochríxín ―mé xi̱kaha chrónka chꞌín Jesús.﻿ ");
INSERT INTO poeNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ntá kjuixin chrónka chꞌín Jesús kaín tíha, ntá nixje̱he̱ chꞌán tí sín kꞌuájiko chꞌán, ntáchro chꞌán kíxin: ");
INSERT INTO poeNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Jahará ó nohará kíxin tꞌitjáyan iyó ya̱on ntá tsjasin sín tí kia pascua la ntá tí Xje̱en Dios Kꞌóna Chojni mé tsotsé sín chꞌán tsji̱kaán sín chꞌán tí tjejó tí sín tꞌe̱to̱an ntá tsja̱kꞌe̱nka̱ni sín chꞌán ijnko ntacruz ―ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ntá tí sín ncha̱tꞌá tꞌe̱to̱an la ko tí sín maestro tjako tí ley la ko tí sín táda kuènte tí sín judío mé kójnkotsé sín tí nta̱sin kuènte tí nchia kjuákꞌe chꞌín Caifás tí chꞌín ncha̱tꞌá tꞌe̱to̱an. ");
INSERT INTO poeNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ntaha tjenka̱yáxin sín kíxin nkexrí tsotsé sín chꞌín Jesús la tsꞌóyán sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","A̱ ntá ntáchro sín kíxin: ―Tí siín kia la chrótséhyani chꞌán kíxin imá tso̱nínkaon tí chojni ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Chꞌín Jesús tjen chjasin Betania nto̱e chꞌín Simón tí chꞌín kꞌuéchónta chinlepra. ");
INSERT INTO poeNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ntá xrína̱hya kóchjina ijnko tjan kjui̱ka̱o tjan ijnko xro̱ tsíkꞌóna xro̱ mármol mé kuíkaón aceite xraxé náxrjón la imá tjete kꞌuíte. A̱ ntá tí tjene chꞌín Jesús ntá tí tjan a mé kui̱ki̱te aceite ikja chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","A̱ ntá tí sín kꞌuájiko chꞌín Jesús mé kꞌuíkon sín xi̱kaha ntá kónínkaon sín la ntáchro sín kíxin: ―¿Nkekuènté kóxénhen tí xro̱a̱n a? ");
INSERT INTO poeNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Íchá jína chrókóxi̱xi̱n itsjé chichaon tí xro̱a̱n ntá tí chichaon a chrókjuinki̱tsa tí sín nòé a ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ntá kuínhin chꞌín Jesús tí nkehe tjo sín, ntá ntáchro chꞌán kíxin: ―¿Nkekuènté tꞌantaxínhínrá tí tjan i? Ó ncho̱xon ijnko nkehe jína kjuíchꞌe tjan. ");
INSERT INTO poeNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Tí sín nòé la ó xráxín tsꞌejókoará sín, a̱ ntá janhan la jnkochríxínhya tsꞌejóni. ");
INSERT INTO poeNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Tí nkehe kjuíchꞌe tjan mé kjuíncheka tjan aceite xraxé tí cuerpo kuènta̱na la mé xi̱kaha kjua̱ko̱xi̱n tjan kíxin xi̱kaha tsoxravána. ");
INSERT INTO poeNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ntá chaxín tjo̱nka̱rá kíxin kuenté chjasintajni tió tsjako sín tí tán jína tsaáxin sín ntá tsochrónka sín kíxin xi̱kaha kjuíchꞌe tjan ntá tsoxraxinkakonxín sín kíxin nkehe tí kjuíchꞌe tjan ―ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","A̱ ntá ijnko tí teyóxin sín kꞌuájiko chꞌín Jesús mé itꞌin Judas Iscariote sákjuínixje̱he̱ chꞌán tí sín ncha̱tꞌá tꞌe̱to̱an ");
INSERT INTO poeNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","la ntáchro chꞌán kíxin: ―¿Nkekja̱ín tsochjìnará tso̱xrja̱nka nketí tjen tí chꞌín Jesús? ―mé xi̱kaha chro tí chꞌín Judas. Ntá tí sín ncha̱tꞌá tꞌe̱to̱an kjue̱nke̱he sín chꞌán treinta chichaon plata. ");
INSERT INTO poeNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ntá tuénxín tí hora tí chꞌín Judas mé xritjeyá chꞌán nkexrí tsochénka chꞌán sín nketí tjen tí chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ntá ikui tí ya̱on xrankíxixín kia sine sín nio̱tja̱ tsíkjikohya tí xro̱a̱n tꞌánkíxin nio̱tja̱. Ntá tí sín kꞌuájiko chꞌín Jesús mé kóchjina sín kjuanchankíhi sín chꞌán kíxin: ―¿Ìnchéni, nketí tjinkávan sincheyaxíxinni tí sineni tí kia pascua? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ntá ntáchro chꞌán kíxin: ―Sátsjirá Jerusalén la tsjasánrá nto̱e ijnko chꞌín la nixje̱hérá chꞌán tsontáchrorá kíxin: “Ntáchro Maestro kuènténi kíxin í séhya na̱xa̱ tsjakꞌe chꞌán la ntá ijie nto̱a ntihi tso̱yaxíxin kíxin sineko chꞌán tí sín xriko chꞌán tí kia pascua”, tsixrorá ―mé xi̱kaha ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","A̱ ntá tí sín kꞌuájiko chꞌín Jesús mé kjuínchexiteyá sín la kjuíncheyaxíxin sín ntiha tí nkehe sine sín kia pascua. ");
INSERT INTO poeNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Tió ntá kóntó la ntá chꞌín Jesús kꞌuéjóko tí teyó sín kꞌuájiko chꞌán kjóne sín. ");
INSERT INTO poeNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","La ntá tió na̱xa̱ tjejóne sín la ntáchro chꞌín Jesús kíxin: ―Chaxín tjo̱nka̱rá kíxin jnkojínrá tjejorá ntihi mé sinchekjirána ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ntá kaín sín la kjuankíxin kóxakonhen sín kꞌuává sín la ntá kjuankíxin sín jnkojnko sín kjuanchankíhi sín tí chꞌín Jesús kíxin: ―Ìnchéni, ¿á jeheni ní? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ntá kjuáte̱he chꞌín Jesús kíxin: ―Tí nkexro tsochrꞌánkíkian niotja tí plato a mé tí nkexro a mé sinchekjina chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Tí Xje̱en Dios Kꞌóna Chojni xi̱kaha tsjasóte chꞌán éxí nixja xroon itén Dios, a̱ ntá nòa tí chꞌín sinchekji chꞌán. Íchá jína chrókokjíehya chꞌán ―mé xi̱kaha ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Na ntá tí chꞌín Judas tí chꞌín sinchekji chꞌín Jesús, mé ntáchro chꞌán kíxin: ―Maestro, ¿á janhan? ―ichro chꞌán. Ntá ntáchro chꞌín Jesús kíxin: ―Méxra̱ xi̱kaha tsíntáchrua ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ntá tió tjejóne sín na chꞌín Jesús mé kuákja chꞌán tí nio̱tja̱ ntá kjuanchehe chꞌán kjuasáyé Dios. Ntá kóchrítꞌo̱ chꞌán tí nio̱tja̱ ntá chjéhe chꞌán kaín tí sín kꞌuájiko chꞌán sine sín. Ntá ntáchro chꞌán kíxin: ―Sinterá tíhi mé cuerpo kuènta̱na ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Na ntá kuákja chꞌán ijnko vaso tjiá ìnté to uva na ntá kjuanchehe chꞌán kjuasáya Dios ntá kjuixin ntá chjéhe chꞌán kaín tí sín tjejóko chꞌán ikꞌui sín. Ntá ntáchro chꞌán kíxin: ―Tíhi mé kaín rá itꞌirá ");
INSERT INTO poeNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","kíxin tíhi mé jni̱na mé chrónkaxín ijnko nkehe ni̱xin tso̱nhen. Mé tí jni̱na tsꞌítji na mé tsjacha tsjinki̱tsa nchónhya chojni kíxin tsꞌíjmáxin iji̱é sín. ");
INSERT INTO poeNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Tjo̱nka̱rá kíxin tsꞌíhya janhan tí ìnté to uva ínaá tsjixrakájia tí ya̱on tsꞌayàjia kjuachaxin kuènte Tꞌaná ntá xíkꞌini ìnté to uva ínaá ―mé xi̱kaha ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ntá itsje sín ijnko himno ntá kjuixin ntá sákjui̱ sín tí jna̱ Olivo. ");
INSERT INTO poeNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ntá ntáchro chꞌín Jesús kíxin: ―Jahará tsíto̱naráni kaín rá ijie tie kíxin ntáchro tí xroon itén Dios kíxin: “Itsꞌen tí nkexro Pastor tꞌayakonhen kolélo ntá kaín tí ko mé tsjichroe va.” ");
INSERT INTO poeNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Na ntá tió tsoxechónna ntá sátsjia senó estado Galilea, a̱ ntá jahará la chrꞌéxi̱n tsochréhérá ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ntá kjuáte̱he chꞌín Pedro ntáchro chꞌán kíxin: ―Kjónté kaín sín tsíto̱ha sín ntá janhan la náhí ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ntá ntáchro chꞌín Jesús kíxin: ―Chaxín tso̱xrja̱nka kíxin tí tie i na̱xa̱ tsotsjehya kochínto̱a la ó si̱nchemána níya ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ntá ntáchro chꞌín Pedro kíxin: ―Kjónté koína itsꞌén la si̱ntamáhya tí jaha ―ichro chꞌán. La ntá kaín tí sín kꞌuájiko chꞌán na xi̱kaha ichro sín kaín sín. ");
INSERT INTO poeNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ntá chꞌín Jesús la ko tí sín kꞌuájiko chꞌán mé kjuíji sín tí nonte ntiha mé nchekꞌin sín Getsemaní. Ntá jehe chꞌán mé ntáchro chꞌán kíxin: ―Tjejorá ntihó ntá janhan sátsjia tsonixja̱ha̱ Tꞌaná ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ntá sákjuiko chꞌán tí chꞌín Pedro la ko tí iyó xje̱en chꞌín Zebedeo la kjuankíxin kóxakonhen chꞌán la ko kꞌuává chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ntá ntáche chꞌán tí iyꞌá sín kíxin: ―Imá tꞌává a̱senná éxí itsꞌén ntá tsꞌaxrje a̱senná. Ntá jahará ntihó tsito̱hará tsꞌejotsjehekoárána ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ntá sákjuí chꞌán a̱ntsí kjínxi̱n ntá kjuákꞌexín tochꞌin chꞌán kꞌuísén chꞌán hasta caxi̱n kja chꞌán nonte ntá chrónóe̱he̱ chꞌán Itꞌé chꞌán tjen nkaya nka̱jní, ntáchro chꞌán kíxin: ―Itꞌéni, tí tjinkávan chrókjui̱nchekaáni kíxin chrókꞌuihyani tí nkehe tsjá tjiá tí copa i. Kjánchó jehya éxí tjinkaonni jeheni. Náhí. Éxí tjinkávan jaha ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ntá ikjan chꞌán tí kuíto̱he sín la ó kꞌuíkon chꞌán kíxin tjejójua sín. Ntá nixje̱he̱ chꞌán tí chꞌín Pedro ntáchro chꞌán kíxin: ―Xá xitjahya chrókꞌuejótsjehekoarána ijnko hora. ");
INSERT INTO poeNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Tito̱hará tjejotsjehérá la nixje̱hérá Dios kíxin tsjinki̱tsará chꞌán kíxin chrókjuachroehyará chꞌín Tsochren. A̱sánrá tóxrjínhi̱n kjánchó tí cuerpo chontará la imá ntá ―mé xi̱kaha ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ntá sákjuí chꞌán yóxin ínaá chrónóehe̱ chꞌán Itꞌé chꞌán, ntáchro chꞌán kíxin: ―Jaha Itꞌéni tí xitjahya tsjakjíyan tí nkehe tsjasótexínni la ntá tjinkaonni éxí jaha tjinkávan ―mé xi̱kaha ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ntá ikjan chꞌán la kꞌuíkon chꞌán tjejójua tí sín kꞌuájiko chꞌán ínaá kíxin tjiehya sín kotáchrin. ");
INSERT INTO poeNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ntá kuíto̱he chꞌán sín ínaá la níxin sáxíkji chꞌán ntá ó xi̱kahó xínixja chꞌán ínaá. ");
INSERT INTO poeNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ntá kjan chꞌán tí kꞌuéjó sín la ntáchro chꞌán kíxin: ―¿A̱ ntá jie, tjejochrinrá la tꞌo̱kꞌáhará ní? Ntá ó tjen. Ntá jie kjuixraká tí hora ntá tí Xje̱en Dios Kꞌóna Chojni tsotsé tí sín chónta jie̱ tsji̱kaán sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ntá ijie tꞌinkatjenrá sátsjini kíxin ó kjui tí chꞌín sinchekjina ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ntá na̱xa̱ tjenixja chꞌín Jesús ntá xrína̱hya kui chꞌín Judas, mé ijnko tí teyóxin sín kꞌuájiko chꞌán. A̱ ntá jehe chꞌán kui̱ka̱o chꞌán nchónhya chojni kjuíjiko sín chica espada la ko inta. Na mé kjua̱cha̱xién tí sín ncha̱tꞌá tꞌe̱to̱an la ko tí sín táda kuènte tí sín judío mé kui sín. ");
INSERT INTO poeNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ntá chꞌín Judas, tí chꞌín kjuínchekji, mé tsíntáchro chꞌán kíxin: ―Tí chꞌín tsa̱ki̱ha̱ tue̱en chꞌán na mé tso̱noaxínrá kíxin jehe chꞌán. Ntá itse̱rá chꞌán ―mé xi̱kaha tsíntáchro chꞌín Judas. ");
INSERT INTO poeNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ntá kóchjinehe chꞌán tí chꞌín Jesús la nixje̱he̱ chꞌán ntáchro chꞌán kíxin: ―¿Á jína tjen, Maestro? ―ichro chꞌán. Ntá kjóneko chꞌán kochíto. ");
INSERT INTO poeNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ntá kjuáte̱he chꞌín Jesús, ntáchro chꞌán kíxin: ―Amigo, á ó kꞌuinka tí xra̱ tjinkávan si̱chꞌe? Ntá xi̱kaha kaín sín kóchjinehe sín chꞌán la itsé sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ntá ijnko chꞌín kꞌuájiko chꞌín Jesús mé kuakitsje chꞌán chica espada kóchrínjin chꞌán ta̱tsjon ijnko tí sín chꞌehe tí ncha̱tꞌá tꞌe̱to̱an xra̱. ");
INSERT INTO poeNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ntá ntáchro chꞌín Jesús kíxin: ―Chrꞌaxe̱nhén tjo̱e chica espada méhe̱. Kaínxín tí sín tjàya̱xi̱n chica espada la xi̱kaha tsꞌenxín sín. ");
INSERT INTO poeNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Á noahyará kíxin janhan jína chrókjuáncháha̱ Tꞌaná la ntá tuénxín chróchrꞌán chꞌán teyó ejército sín ángel? ");
INSERT INTO poeNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Kjánchó tí xi̱kaha chrókónhen la chróxiteyáhya éxí nixja xroon itén Dios kíxin itén Dios mé chrónka kíxin tꞌichjánxi̱n ó jehí xi̱kaha tso̱nhen ―ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ntá chꞌín Jesús mé ntáche chꞌán tí sín ikui kíxin: ―Jahará kꞌuinkakoará chica espada la ko inta kíxin tso̱tse̱rána éxí chrótse̱rá ijnko síche̱e xi̱kaha. A̱ ntá kaín ya̱on kjuakꞌé nkaxenhen ni̱nko kjuàkua ¿na ntá nkexrí ntiha mé tse̱xinhyarána? ");
INSERT INTO poeNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Kjánchó jehí kaín tíha tso̱nhen kíxin tsoxiteyá tí chrónka tí sín tsíkjin xroon itén Dios ósé ―ichro chꞌán. Mé xi̱kaha ntá kaín tí sín kꞌuájiko chꞌín Jesús na mé kuíto̱he sín chꞌán, ntá sákjuí sín. ");
INSERT INTO poeNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ntá tí sín itsé chꞌín Jesús la sákjuíko sín chꞌán nto̱e chꞌín Caifás, tí ncha̱tꞌá tꞌe̱to̱an. Ntaha mé tsíkójnkotsé kaín tí sín maestro tjako tí ley la ko tí sín tꞌe̱to̱an kuènte ni̱nko. ");
INSERT INTO poeNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ntá chꞌín Pedro ikjín tinkáchréhe̱ chꞌán ntá kjuíji chꞌán tí nta̱sin nto̱e tí ncha̱tꞌá tꞌe̱to̱an la kja̱xin kꞌuíxenhen chꞌán tí nta̱sin la kjuákꞌeko chꞌán tí sín policía kuènte ni̱nko kíxin tsotsjehe chꞌán nkerí tso̱nhen. ");
INSERT INTO poeNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ntá tí sín ncha̱tꞌá tꞌe̱to̱an la ko tí sín táda la ko kaín tí sín tꞌe̱to̱an mé kjueyá sín nkexrí tsꞌeka sín jie̱ tí chꞌín Jesús kíxin jína chrókꞌóyán sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ntá kjónté nchónhya chojni kuikjanchia sín jie̱ kjánchó kꞌuitjahya sín nkerí jie̱ tꞌíká chꞌán. Ntá kjónté la kóchjina iyó testigo ntoáhya chrónka sín ");
INSERT INTO poeNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","la ntáchro sín kíxin: ―Ó kuínhinni ntáchro chꞌán kíxin: “Janhan na tsꞌoxíka tí ni̱nko kuènte Dios la ntá iní ya̱on koá la ó tsjaké ínaá” ―mé xi̱kaha chro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ntá tí ncha̱tꞌá tꞌe̱to̱an kꞌuínkatjen la kjuanchankíhi chꞌán tí chꞌín Jesús, ntáchro chꞌán kíxin: ―¿Nkekuènté tjáte̱éhya ninkehó? ¿Á chaxín xi̱kaha tsíntáchrua éxí xi̱kaha ichro sín? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ntá chꞌín Jesús la táníkoá chꞌán nixjahya chꞌán. Ntá ntáchro tí ncha̱tꞌá tꞌe̱to̱an kíxin: ―Kjua̱cha̱xién ihni̱é tí Dios tjechón tꞌakjénxian chro̱nka ntoá, ¿á jaha tí Cristo Xje̱en Dios? ―kjuanchankí chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Éxí tí ntáchrua jaha. Ntá kja̱xin xrja̱nka kíxin chrꞌéxi̱n tsꞌikuan kíxin tí Xje̱en Dios Kꞌóna Chojni mé tsjakꞌetja̱xi̱n nánko tí tja chjina Dios chónta kaín xín kjuachaxin la ko tsꞌikuan itjui̱ mé tsi̱xi̱n chꞌán nkaya nka̱jní ―ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ntá kuínhin tí ncha̱tꞌá tꞌe̱to̱an la ntá imá kónínkaon chꞌán ntá kótséchje chꞌán tí iké chꞌán la ntáchro chꞌán kíxin: ―Tí chꞌín a kꞌuántaxínhi̱n chꞌán Dios kíxin xi̱kaha nixja chꞌán. Méxra̱ tꞌichjánxi̱nhya í so chojni tsochrónka. La ntá jahará la ó kuinhínrá kíxin nkexrí nixja chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿A̱ ntá jahará la, ¿nkechrorá? ―mé ichro tí ncha̱tꞌá a. Ntá kjuáte̱he sín ntáchro sín kíxin: ―Chónta chꞌán jie̱ la chrókꞌuen chꞌán ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ntá iso sín la kui̱ki̱te sín nta̱te sín nkayakon chꞌán na í so sín na kjuate sín chꞌán la í so la chjéhe sín ikon chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","La ntáchro sín kíxin: ―Tí chaxín tí Cristo jaha la tónoha nkexro kjuatia ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ntá chꞌín Pedro na̱xa̱ tjetja̱xi̱n chꞌán tí nta̱sin la ntá ikui ijnko tjan chꞌe xra̱ ntiha kóchjinehe chꞌán, la ntáchro tjan kíxin: ―Kja̱xian xríkoa tí chꞌín Jesús tsíkji̱xi̱n estado Galilea ―ichro tjan. ");
INSERT INTO poeNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","A̱ ntá chꞌín Pedro kjuínchemá chꞌán nkayakon kaín sín la ntáchro chꞌán kíxin: ―Nonahya nkehe tí ntáchrua ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ntá sákjuí chꞌán kjuíji chꞌán chjina tí puerta. La ntá í jnko tjan kꞌuíkon tí jehe chꞌán la nixje̱he̱ tjan kaín sín tjejóntaxín, la ntáchro tjan kíxin: ―Tí chꞌín i la kja̱xin kꞌuájiko chꞌán tí chꞌín Jesús tsíkji̱xi̱n chjasin Nazaret ―ichro tjan. ");
INSERT INTO poeNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ntá chꞌín Pedro kjuínchemá chꞌán ínaá, kꞌuákjenxi̱n chꞌán ihni̱é Dios, ntáchro chꞌán kíxin: ―Chonhya tí nkexro a ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ntá a̱ntsí chrꞌéxi̱n tí sín kꞌuéjóntaxín kóchjinehe sín chꞌín Pedro la ntáchro sín kíxin: ―Chaxín jaha kja̱xin jnkojín tí sín a kíxin tjátso̱anxínni tí nixja jaha ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ntá kꞌuákjenxi̱n chꞌán ihni̱é Dios ntáchro chꞌán kíxin: ―Chonhya tí nkexro a ―ichro chꞌán. Na ntá xrína̱hya itsje kochínto̱a. ");
INSERT INTO poeNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ntá chꞌín Pedro mé xraxinkaon chꞌán kíxin nkexrí chrónka chꞌín Jesús senó kíxin: “Na̱xa̱ tsotsjehya kochínto̱a mé ó tsjixin si̱nchemána níya kíxin chonhyana.” ﻿ Ntá xi̱kaha xraxinkaon chꞌín Pedro ntá kꞌuaxrjenta chꞌán ntiha la imá tsjánka chꞌán la ó mero tsꞌenxín chꞌán tí kjuancheníhi, la sákjuí chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ntá tí kóya̱on kꞌuínkaséyan ntá kaín sín ncha̱tꞌá tꞌe̱to̱an la ko tí sín tꞌe̱to̱an kuènte tí sín judío kjuenka̱yáxin sín nkexrí tsꞌóyán sín tí chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ntá tjechronteto chꞌán sákjuiko sín chꞌán tí tjen tí chꞌín Poncio Pilato, tí chꞌín gobernador romano. ");
INSERT INTO poeNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ntá tí chꞌín Judas, tsíkjinchekji chꞌín Jesús, mé kꞌuíkon chꞌán kíxin tsꞌóyán sín tí chꞌín Jesús. La ntá xraxinkaon chꞌán tí jie̱ kjuasin chꞌán la sákjuíkénhen chꞌán sín ínaá tí treinta chichaon plata kuákja chꞌán, mé chjéhe chꞌán tí sín ncha̱tꞌá tꞌe̱to̱an la ko tí sín táda. ");
INSERT INTO poeNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","La ntá ntáchro chꞌán kíxin: ―Ó kjuasinni jie̱ kíxin kjuínchekjini ijnko nkexro tjóá ―ichro chꞌán. A̱ ntá jehe sín kjuáte̱he sín kíxin: ―Ntá janhanna la nonahyana tíha. Tíha la ó jie̱ kuènta ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ntá chꞌín Judas mé sákjuíkꞌe tí chichaon nkaxenhen ni̱nko ntá sákjuí chꞌán kjuísikꞌá isin chꞌán nta. ");
INSERT INTO poeNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ntá tí sín ncha̱tꞌá tꞌe̱to̱an kjuenájín sín tí chichaon la ntáchro sín kíxin: ―Tí chichaon la kóxi̱xi̱n ijni̱é chojni la chrokjuahya chrꞌáxenhenni tí caja kuènte ofrenda ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","La ntá kjuenka̱yáxin sín jnkoko̱á kíxin tí chichaon la tsꞌe̱naxín sín ijnko nonte itꞌin No̱nte̱e Tí Chꞌín Chꞌéna Nchésen kíxin tsochónta sín nketí tsoxravá tí chojni tsíkji̱xi̱n ikjín. ");
INSERT INTO poeNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Mé xi̱kaha kjuínchekꞌin sín tí nonte mé Campo Kuènte Jni̱ la hasta ijie la na̱xa̱ xi̱kaha nchekꞌin sín. ");
INSERT INTO poeNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Mé xi̱kaha ó xiteyá tí nkehe kꞌuéntáchro profeta Jeremías, ntáchro chꞌán kíxin: “Kuákja sín tí treinta chichaon plata (tí chichaon kjuanjon tí sín israelita kuènte tí chꞌín a), ");
INSERT INTO poeNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","la kꞌue̱naxín sín tí nonte kuènte tí chꞌín chꞌéna nchésen kíxin xi̱kaha kjuínchexiteyá sín tí nkehe kꞌue̱tua̱nna Ìnchéni.” ");
INSERT INTO poeNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Na ntá chꞌín Jesús sákjuíko sín chꞌán nkayakon tí chꞌín gobernador la ntá jehe chꞌán kjuanchankí chꞌán kíxin: ―¿Á jaha tí Rey kuènte tí sín judío? ―ichro chꞌán. Ntá kjuáte̱he chꞌín Jesús, ntáchro chꞌán kíxin: ―Éxí ntáchrua jaha ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Na ntá tí sín ncha̱tꞌá tꞌe̱to̱an la ko tí sín táda tꞌe̱to̱an tꞌeka sín jie̱ tí chꞌín Jesús kjánchó la chꞌín Jesús la ninkehó kjuáte̱ehya. ");
INSERT INTO poeNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","A̱ ntá chꞌín Pilato kjuanchankí chꞌán kíxin: ―¿Á kiénhya kaín tí jie̱ tꞌeka sín tí jaha? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Kjánchó chꞌín Jesús la ninkehó kjuáte̱ehya chꞌán. Ntá tí chꞌín gobernador la chrakon chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","A̱ ntá tí kié pascua mé kuènhen tí chꞌín gobernador kíxin jnkojnko nánó takitsjexín chꞌán nto̱echiso ijnko chojni tjechjina. Ntá tí chojni mé tsjanchia sín nkexro tí tsíto̱he chꞌán sátsji. ");
INSERT INTO poeNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ntá tjechjina ijnko chꞌán, mé kaín sín ntiha ó nohe sín kíxin jínahya chꞌán, mé itꞌin chꞌán Barrabás. ");
INSERT INTO poeNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ntá itsjé chojni kójnkotsé la ntá chꞌín Pilato mé kjuanchankí chꞌán kíxin: ―¿Nkexro tjinkáonrá tsꞌatjánta, á tí chꞌín Barrabás o̱ á tí chꞌín Jesús nchekꞌin sín Cristo? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Kíxin tí chꞌín Pilato la ó nohe chꞌán kíxin kjuachji̱no̱xínhin chónta tí sín kjuíkaán tí chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ntá jehe chꞌán na̱xa̱ tjetja̱xi̱n chꞌán tí nchekito̱exíxin chꞌán iji̱é chojni la ntá tí ichjién chꞌán mé kꞌue̱tue̱nhen tjan ijnko chojni tsjichénka chꞌán kíxin tsjiatéhya chꞌán tí nkexro jína kíxin kóntó náxrjónhya kꞌuíkonxín tjan kotáchrién tjan kíxin tí jehe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","A̱ ntá tí sín ncha̱tꞌá tꞌe̱to̱an la ko tí sín táda tꞌe̱to̱an a mé nixje̱he̱ kaín tí chojni tsíkóchjina kíxin chrókjuanchia sín kíxin chrókuíto̱he chꞌán tí chꞌín Barrabás sáchrókjui, a̱ ntá chꞌín Jesús mé chrókꞌuen. ");
INSERT INTO poeNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","A̱ ntá tí chꞌín gobernador mé nixje̱he̱ chꞌán sín ínaá kjuanchankí chꞌán kíxin: ―¿Nkexro tí yaá sín tjejó ntihi tjinkáonrá tsꞌatjánta? ―ichro chꞌán. Ntá kjuáte̱he sín ntáchro sín kíxin: ―Chꞌín Barrabás mé chrókꞌuatjánta chꞌán ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","A̱ ntá chꞌín Pilato mé kjuanchankí chꞌán kíxin: ―¿A̱ ntá nkehe si̱tꞌaha̱ tí chꞌín Jesús tí chꞌín nchekꞌinrá Cristo? ―ichro chꞌán. Ntá kaín sín kjuáte̱he sín kíxin: ―¡Tsjakꞌenkáni chꞌán ntacruz! ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ntá chꞌín Pilato kjuanchankí chꞌán ntáchro chꞌán kíxin: ―¿Xá nkehe tí kjuíchꞌe tí chꞌín i kíxin? ―ichro chꞌán. Ntá a̱ntsí má itsen kꞌuíxite sín, kꞌóyako sín, ntáchro sín kíxin: ―¡Tsjakꞌenkáni chꞌán ntacruz! ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ntá chꞌín Pilato kꞌuíkon chꞌán kíxin í kohya tsjitóxi̱nhin sín tsjenka̱yáxin sín la a̱ntsí má kꞌuíxité sín, nínkaon sín, la ntá kjuanchia chꞌán xraka̱o sín ìnta̱, la nkayakon kaín tí sín tsíkójnkotsé ntaha kꞌònti chꞌán tja chꞌán. La ntáchro chꞌán kíxin: ―Janhan tsámáhya jie̱ tí itsꞌen tí nkexro í chóntahya jie̱. Jahará xi̱kaha tjinkáonrá tso̱nhen ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ntá kaín sín kjuáte̱he sín kíxin: ―Jeheni la ko xje̱enni mé yámáni tí jie̱ tí itsꞌen tí nkexro i ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ntá chꞌín Pilato kuíto̱he chꞌán kíxin sáchrókjui tí chꞌín Barrabás. Ntá tuénxín kꞌue̱to̱an chꞌán kíxin tsjate sín tí chꞌín Jesús la ntá kjuínchekꞌáyéhe̱ chꞌán tí sín tsja̱kꞌe̱nka̱ni sín chꞌán ntacruz. ");
INSERT INTO poeNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","A̱ ntá tí sín soldado a mé sákjuíko sín tí chꞌín Jesús tí palacio kuènte tí chꞌín gobernador. Ntaha kójnkotséxin kaín tí sín soldado romano la kꞌuántatjen sín tí jehe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ntá kuakitsjehe sín tí iké chꞌán la ntá kjuínchekꞌinkáya sín chꞌán ijnko ka kjátse tié. ");
INSERT INTO poeNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","La kjua̱kꞌe̱nka̱ya sín kja chꞌán ijnko corona tsíkjichꞌéna sín ntachꞌi̱ la ko kjuanjon sín ijnko nta vara kíxin tjenkáya tja chꞌán chjina. La ntá kꞌuéjóxin tochꞌin sín nkayakon chꞌán la kjuanoá sín chꞌán, ntáchro sín kíxin: ―Jnkochríxín tsjakꞌé tsétue̱nhén tí sín judío ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","La ko kja̱xin nta̱té sín kui̱ki̱te sín nkayakon chꞌán la ko kuákja sín tí nta tjexraá chꞌán la tꞌíchjéxin sín kja chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ntá kjuixin kjuanoá sín chꞌán na ntá kuakitsjehe sín chꞌán tí ka kjátse tié ntá kjuínchekꞌinkáya sín tí iké chꞌán xráxín. Ntá sákjuíko sín chꞌán kíxin tsja̱kꞌe̱nka̱ni sín chꞌán ntacruz. ");
INSERT INTO poeNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","A̱ ntá sákjuíxin sín ntiha la xéta sín ijnko chꞌín kjui̱xi̱n chꞌán chjasin Cirene, mé itꞌin chꞌán Simón. Ntá kꞌue̱tue̱nhen sín chꞌán kíxin tsámá chꞌán tí ntacruz tsjakꞌenkáni chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ntá kjuíji sín ijnko tjo itꞌin Gólgota na mé nkíve̱e sín tꞌaxrjexín Nta Hueso Kja Chojni Tsíkꞌen. ");
INSERT INTO poeNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ntá chjéhe sín chꞌín Jesús xranvino tsíkꞌixinkíkjanxín xro̱a̱n tsjá kjánchó jehe chꞌán kꞌuíhya chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","A̱ ntá tí sín soldado kjuixin kjua̱kꞌe̱nka̱ni sín chꞌán tí ntacruz ntá tí iké chꞌán kjuíchꞌexín sín suerte kíxin nkexro tsakja. Mé xi̱kaha xiteyá tí nkehe nixja tí sín kꞌuéchrónka itén Dios ósé, ntáchro kíxin: “Nchónhya suerte kjuíchꞌexín sín tí kaná.” ");
INSERT INTO poeNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ntá tí sín soldado ntaha kꞌuéjónta sín tꞌayakonhen sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ntá kjua̱kꞌe̱nka̱ni sín tí ikja tí ntacruz ijnko ntachiso ntáchro kíxin: “Chꞌín Jesús mé tí chꞌín Rey tꞌe̱tue̱nhen tí sín judío.” ");
INSERT INTO poeNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Kja̱xin yaá tí síche̱e kꞌuéjóyáni sín ntacruz ijnko la nó tja chjina la í jnko la nó tja kjon. ");
INSERT INTO poeNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ntá tí sín tinkákꞌatsínka mé kjuanoá sín chꞌán tinkátjíá kja sín ");
INSERT INTO poeNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","la ntáchro sín kíxin: ―Jaha ntáchrua kíxin chrókꞌoxíka tí ni̱nko a ntá iní koá ya̱on la ó chrókjuixin chrókjui̱chꞌéna ínaá, ichrua. Méxra̱ ijie jahvá nchekaá a̱sán. Tí chaxín jaha Xje̱en Dios la jahvá tjasinka̱jinxián tí ntacruz méhe̱ ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","La ntá kja̱xin tí sín ncha̱tꞌá tꞌe̱to̱an la ko tí sín maestro tjako tí ley la ko tí sín fariseo la ko tí sín kꞌue̱to̱an kuènte ni̱nko kjuanoá sín chꞌán, ikjo sín kíchó sín kíxin: ");
INSERT INTO poeNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Jehe chꞌán mé kjuínchekaá chꞌán ókjé chojni ntá jehe chꞌán xitjahya sinchekaá a̱sén chꞌán. Kja̱ tí chaxín jehe chꞌán tí Rey kuènte Israel ntá jehó chꞌán chrókjuinkaji̱nxi̱n chꞌán a̱sén chꞌán tí ntacruz kíxin ntá kja̱xinni chrókuitekaonni tí jehe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Jehe chꞌán tsíntáchro chꞌán kíxin Dios tjinki̱tsa tí jehe chꞌán la ntá tsotsjeheni á chaxin tjinkaon Dios sinchekaá tí jehe chꞌán kíxin tsíntáchro chꞌán kíxin Xje̱en Dios tí jehe chꞌán ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Kja̱xin tí síche̱e sínkáni ntacruz kꞌuántaxínhi̱n sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ntá chonkíxin hasta las tres kónjín mé kꞌuíxin tie chjasintajni. ");
INSERT INTO poeNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ntá tí hora a chꞌín Jesús itsen kꞌuèya chꞌán, ntáchro chꞌán kíxin: ―Elí, Elí, ¿lama sabactani? ―mé tíhi tꞌaxrjexín kíxin: Itꞌéni, Itꞌéni, ¿nkekuènté kui̱to̱héni? ―mé xi̱kaha ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ntá iso sín tjejóntaxín kuínhin sín ntá ntáchro sín kíxin: ―Tí chꞌín a mé tꞌíye̱he̱ tí chꞌín profeta Elías ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ntá ijnko chꞌín kuinká chꞌán sákjuíkakja chꞌán ijnko ka ntá chrꞌánkí chꞌán xranvino isán ntá tí ka a kjua̱kꞌe̱kjen chꞌán ijnko nta kjínjin ntá kjuínchechrìin chꞌán kíxin chrókꞌui chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ntá í so sín ntáchro sín kíxin: ―Nté ti̱to̱hé chꞌán. Tsotsjeheni á tsi chꞌín Elías sinchekaá tí jehe chꞌán ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ntá chꞌín Jesús itsen kꞌuíyato chꞌán ínaá, ntá kjuixin ikꞌuén chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Mé ntá tuénxín kꞌuíchje tí ka tjenkákuènxín nkaxenhen ni̱nko. Mé kꞌuíchje tí ka kꞌóna yaá tí kjuankíxixín noi hasta nonte. La ko kuínkí nonte la ko tí tjo̱ la kja̱xin xitje̱he̱. ");
INSERT INTO poeNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","La ko ó xitje̱he̱ tí tòye̱ tsíxravá chojni la ko ó xechón itsjé tí sín kꞌuékinkáchónki Dios. ");
INSERT INTO poeNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Kaín tí sín a mé kꞌuaxrjexín sín tí tòye̱, la tió kjuixin xechón chꞌín Jesús ntá kꞌuíxenhen sín tí chjasin tjóá mé chjasin Jerusalén la ntaha itsjé chojni kꞌuíkon kíxin xíxechón tí sín a. ");
INSERT INTO poeNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ntá tí chꞌín capitán la ko tí sín kꞌuéjóko chꞌán, mé tí sín tꞌayakonhen chꞌín Jesús, na ntá kꞌuíkon sín kuínkí nonte la kaín tí í so nkehe la ntá imá chrakon sín, la ntáchro sín kíxin: ―Chaxín tí nkexro a mé Xje̱en Dios. ");
INSERT INTO poeNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ntá ntiha nchónhya chojni chjin ikjín tjejó sín, tjejótsjehe sín. Jehe sín kꞌuékinkáchréhe̱ sín chꞌín Jesús tí kjui̱xi̱n chꞌán estado Galilea kíxin mé ntiha kjuankíxixín sín kꞌuékjinki̱tsa sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ntaha kja̱xin tjen tjan María Magdalena la ko tjan María, ìné tí chꞌín Jacobo, la ko chꞌín José la ko tí ìné tí xje̱en tí chꞌín Zebedeo. ");
INSERT INTO poeNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ntá tí ó ntá kóntó ikui ijnko chꞌín itꞌin José, mé ijnko chꞌín rico. Chjasén chꞌán mé Arimatea la jehe chꞌán kja̱xin kꞌuéchréhe̱ chꞌán tí chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ntá tí chꞌín José sákjuítsjehe chꞌán chꞌín Pilato kjuíkjanchia chꞌán tí cuérpo̱é tí nkexro Jesús. Ntá chꞌín Pilato mé kjuanjon chꞌán kjuachaxin. ");
INSERT INTO poeNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ntá chꞌín José mé kuákja chꞌán tí cuerpo ntá kjuínchekꞌisímá chꞌán ijnko ka tjóá. ");
INSERT INTO poeNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Na ntá kjua̱kꞌe̱nka̱ya chꞌán ijnko tòye̱ ni̱xin kuènte chꞌán kíxin senó tsíkjichꞌéna chꞌán. Ntá ijnko xro̱ jié kꞌuíkjèxín chꞌán tí ntója tí tjo̱, ntá kjuixin ntá sákjuí chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ntaha kjuákꞌe tí tjan María Magdalena la ko í jnko tjan María tjejótja̱xi̱n sín ntoí chokꞌèxin tjen tòye̱. ");
INSERT INTO poeNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","A̱ ntá tí ya̱on ó kjuixin kjuasiyóxin sín nkehe kuènte tí ya̱on tꞌo̱kꞌéhe sín, la ntá tí sín ncha̱tꞌá tꞌe̱to̱an la ko tí sín fariseo sákjuítsjehe sín tí chꞌín Pilato ");
INSERT INTO poeNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","la ntá ntáchro sín kíxin: ―Ó xraxinkaonni kíxin tió na̱xa̱ kjuákꞌechón tí nkexro kjuíchꞌia la tsíntáchro chꞌán kíxin tsꞌatsínka iní ya̱on ntá tsoxechón chꞌán ínaá, tsíchro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Méxra̱ tsétue̱nhén tí sín soldado kíxin tsꞌayakonhen sín tí tòye̱ tsoxétjajia tí níxin ya̱on. Tí náhí, la kjá tie itsi tí sín kꞌuájiko chꞌán la tseé sín tí cuerpo kuènte chꞌán la ntá chrꞌéxi̱n tsochénka sín chojni kíxin ó xíxechón tí nkexro a, mé xi̱kaha sichꞌia sín. La ntá tí xi̱kaha sichꞌe sín a̱ntsí má sichꞌia sín que tí xrankíxixín ―mé xi̱kaha ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ntá ntáchro chꞌín Pilato kíxin: ―Ntihi tjejó soldado. Sátsjirá la tsꞌayakonhenrá jína tí tòye̱ éxí tjinkáonrá ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Na ntá sákjui̱ sín la kjuakꞌe sín ijnko sello chrítaón tí xro̱ tjekjèxin tí tòye̱ la kuíto̱he sín tí sín soldado ntahó kíxin tsꞌayakonhen sín.﻿ ");
INSERT INTO poeNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ntá ó kꞌuátsínka tí ya̱on tꞌo̱kꞌéhe sín. Ntá chjino tꞌinkaséyan tí ya̱on xrankíxixín semana, la ntá tjan María Magdalena la ko tí í jnko tjan María sákjuítsjehe sín tí tsíkji̱xravá Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ntá xrína̱hya kuínkí nonte imá tji̱a̱n kíxin ijnko ángel kuènte Ìnchéni kꞌuínkaji̱nxi̱n nkaya nka̱jní la kjuíji chꞌán tí tsíxravá Jesús la kjuakjìin chꞌán tí xro̱ a tjekjèxin tòye̱ la ntá chrítaón tí xro̱ a kjuákꞌekjen chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Tí ángel la imá tjáki̱ni tsjehe éxí ijnko xrohi la tí iké chꞌán la imá tjóá tsjehe éxí chrinta. ");
INSERT INTO poeNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Tí sín soldado mé kꞌuíkon sín xi̱kaha la ntá síxrànka̱ sín chrakon sín la éxí tsíkꞌen sín xi̱kaha kꞌuéjó sín. ");
INSERT INTO poeNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","La ntá tí ángel mé ntáche chꞌán tí chojni chjin kíxin: ―Chrakonhyará. Janhan ó nòna kíxin xrítjéyárá tí nkexro Jesús mé tí nkexro tsíkjakꞌenkáni ntacruz. ");
INSERT INTO poeNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Kjánchó í kohya chꞌán ntihi ó tsíxechón chꞌán ínaá éxí chrónka chꞌán senó. Xrákirá tsjehérá tí tsíkjakꞌe sín chꞌán, í kohya chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ntá sátjirá tjoka tjíche̱nkará tí sín kꞌuájiko chꞌán kíxin: “Tí nkexro la ó tsíxechón. Ó kuítónxin chꞌán nti̱a sátsji chꞌán estado Galilea. Ntiha tsꞌikonrá chꞌán”, mé xi̱kaha tso̱chro̱nka̱rá. Kaín tíha mé tjo̱nka̱rá ―mé xi̱kaha chrónka tí chꞌín ángel. ");
INSERT INTO poeNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","A̱ ntá tí chojni chjin tjoka sákjuíxin sín tí tsíxravá tí nkexro Jesús, la chrakon sín la ko chéhe̱ sín la sákjuíchénka sín tí sín kꞌuékꞌajiko chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ntá xrína̱hya titàya̱ kꞌuíkuèn sín kíxin itjen tí chꞌín Jesús la nixje̱he̱ sín chꞌán. Ntá kóchjinehe sín chꞌán la kjóa sín to̱té chꞌán, kuítekaon sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","La ntáchro chꞌán kíxin: ―Chrakonhyará sátjirá tjíche̱nkará tí sín kíchó ni kíxin sáchrókjui sín estado Galilea la ntaha tsꞌikon sín tí janhan ―mé xi̱kaha ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Tió sátsíkji tí chojni chjin la nta iso tí sín soldado kꞌuáyakonhen tí tsíxravá chꞌín Jesús mé sákjuí sín chjasin Jerusalén la chénka sín tí ncha̱tꞌá tꞌe̱to̱an kaín tí nkehe tsíkónhen tí kꞌuéjó sín ntiha. ");
INSERT INTO poeNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ntá tí sín ncha̱tꞌa tꞌe̱to̱an kjuínixje̱he̱ sín tí sín táda la ntá jnkoko̱á kjuenka̱yáxin sín ntá chjéhe sín nchónhya chichaon tí sín soldado. ");
INSERT INTO poeNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","La ntáchro sín kíxin: ―Chro̱nka̱rá kíxin tí tie na̱xa̱ tjejochrinrá ikui tí sín kꞌuékꞌajiko tí nkexro Jesús, mé kueé sín cuerpo kuènte chꞌán, ichrorá. ");
INSERT INTO poeNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","A̱ ntá tí chrókónohe tí chꞌín gobernador tíha la ntá jeheni tsonixje̱he̱ni chꞌán kíxin tso̱nínkakuanhyará chꞌán ―mé xi̱kaha ichro tí sín ncha̱tꞌá. ");
INSERT INTO poeNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","La ntá tí sín soldado kꞌuáyéhe̱ sín tí chichaon la sákjuí sín la xi̱kaha kjuíchꞌe sín éxí kꞌuítuenhen sín. La mé xi̱kaha chrónkaxín tí sín judío, la hasta tí ya̱on ijie la xi̱kahó ichro sín, chrónkaxín sín. ");
INSERT INTO poeNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","A̱ ntá tí tejnko sín kꞌuékꞌajiko chꞌín Jesús sákjui̱ sín ijnko jna̱ estado Galilea kíxin xi̱kaha tsíkꞌe̱to̱an chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ntá kꞌuíkon sín chꞌín Jesús la ntá kuinkáchónki sín chꞌán kjónté iso sín na̱xa̱ kjuenka̱yáxin á chaxín jehe chꞌán o̱ náhí. ");
INSERT INTO poeNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ntá chꞌín Jesús kóchjinehe tí jehe sín la ntáchro chꞌán kíxin: ―Dios mé chjìna kaín xín kjuachaxin nkaya nka̱jní la ko chjasintajni. ");
INSERT INTO poeNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Méxra̱ sátjirá kaín xín nación la tjákohérá chojni kíxin tsitekaon sín tí janhan. Tíki̱texínrá sín kjua̱cha̱xién ihni̱é Itꞌéni la ko ihni̱é tí Xje̱en la ko Ncha̱kuèn Dios. ");
INSERT INTO poeNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Tjákohérá sín kíxin sinchexiteyá sín kaín xín nkehe kuétua̱nhanrá. Ijie la ó nohará kíxin tsjakꞌé tsꞌejokoará jnkochríxín hasta tsjeje̱ chjasintajni. Mé xi̱kaha tso̱nhen. Amén ―ichro chꞌín Jesús.");
INSERT INTO poeNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Xi̱kihi mé xrankíxixín tí tan jína kuènte Jesucristo mé tí Xje̱en Dios. ");
INSERT INTO poeNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ósé mé kjuákꞌe chꞌín Isaías mé ijnko nkexro tsíchrꞌán Dios chrónka itén chꞌán kꞌuékjin chꞌán nkexrí nixje̱he̱ Dios tí Xje̱en chꞌán ntáchro kíxin: Janhan tsochrꞌan ijnko nkexro tsochrónka tan kuènta̱na tsitónxin nti̱a, kíxin tsjasiyóxin chꞌán nti̱a kuèntá. ");
INSERT INTO poeNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ntá tsinhin sín itén ijnko nkexro tsjakꞌe nte̱je̱ tsꞌèya tsontáchro kíxin: “Tóxakonhanrá ncheyóxinrá nti̱a tsi̱xi̱n Ìnchéni, takitje̱hérá ijnko nti̱a ntoí.” ");
INSERT INTO poeNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Tíha mé xíteyá ikui chꞌín Juan Bautista, mé xi̱kaha kjuákꞌe chꞌán nte̱je̱ kui̱ki̱te chꞌán chojni. Kjua̱ko̱he̱ chꞌán chojni ntiha kíxin chrókjuinkí sín tí nkehe tjenka̱yáxin sín chrókuíto̱he sín tí iji̱é sín ntá chrókuikite sín kíxin xi̱kaha mé chrókjuìin iji̱é sín. ");
INSERT INTO poeNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Itsjé chojni kui̱xi̱n estado Judea la ko tí chjasin Jerusalén ikui sín tí kjuákꞌe chꞌín Juan kuínhin sín tí nkehe kjuako chꞌán ntá chrónka sín tí jie̱ yámá sín ntá chꞌín Juan mé kui̱ki̱texín sín chꞌán nta̱río Jordán. ");
INSERT INTO poeNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Tí ké chꞌín Juan mé tsíkꞌóna ka̱xre̱e kocamello la ko tí nkehe chrꞌínkatꞌóxin chꞌán mé tsíkꞌóna tjo̱a̱. A̱ ntá tí nkehe kjóne chꞌán mé kochjo̱á la ko tsje̱n kotsje̱nta tónoxín nte̱je̱. ");
INSERT INTO poeNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Mé kjuákꞌekja̱ko̱he̱ chꞌán chojni ntáchro chꞌán kíxin: ―Iton tí janhan mé tsichréhe̱ ijnko nkexro a̱ntsí má chónta kjuachaxin, a̱ ntá janhan la kánhyó. Méxra̱ chrókósuàna chrókjuasinta̱nka̱ tí correa tí to̱ka̱té chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Janhan mé ìnta̱ ó kuíki̱texínrá. Ntá jehe chꞌán mé tsi̱ki̱texínrá chꞌán tí Ncha̱kuen Dios ―ichro chꞌín Juan. ");
INSERT INTO poeNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ntá tí ya̱on a chꞌín Jesús, kꞌuaxrjexín chꞌán chjasin Nazaret estado Galilea. Na ntá chꞌín Juan mé kui̱ki̱texín chꞌán tí nta̱río Jordán. ");
INSERT INTO poeNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Tió kꞌuaxrjenkíxin chꞌín Jesús tí ìnta̱, ntá xrína̱hya titàya̱ kꞌuíkuèn chꞌán na ó xitje̱he̱ nka̱jní la ntá tí Ncha̱kuen Dios éxí kontóá kꞌuínkaji̱nxi̱n ntiha ntá kjuákꞌe chrítaón kja chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ntá xrína̱hya kuínhin sín nixja Dios nkaya nka̱jní, ntáchro kíxin: ―Janhan mé xja̱nna imá tjua̱ha tí jaha. Imá chàna kíxin nchexiteyàna tí jaha ―mé xi̱kaha kuínhin sín. ");
INSERT INTO poeNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ntá tí Ncha̱kuen Dios mé sákjuíko tí chꞌín Jesús nte̱je̱. ");
INSERT INTO poeNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Kjuákꞌe chꞌán cuarenta ya̱on tí nte̱je̱ la ko ntiha mé kꞌuíxin ko jie̱he ntá chꞌín Tsochren a na mé tjinkaon chrókjuachroe chꞌán. La ntá tí sín ángel kui kꞌuàyakonhen tí jehe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kjuixin kjuákꞌechjina chꞌín Juan nto̱echiso ntá chꞌín Jesús na mé sákjuí chꞌán nó estado Galilea sákjuíkja̱ko̱he̱ chꞌán tí sín ntiha tí tan jína kuènte Dios. ");
INSERT INTO poeNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ntá ntáchro chꞌán kíxin: ―Ó kjuixraká tí ya̱on, la ó tsi tí kjuachaxin kuènte Dios tsꞌe̱to̱an chꞌán. Chrókui̱to̱hérá tí nkehe jínahya kꞌuékjenka̱yáxinrá a̱ ntá chrókuítekáonrá tí tan tsaáxinrá ―mé xi̱kaha kjuako chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Chꞌín Jesús tjetji chꞌán chrínta nta̱yaon Galilea ntá xrína̱hya kꞌuíkon chꞌán tí chꞌín Simón la ko tí kíchó chꞌán mé itꞌin Andrés, mé koche xritsé sín, ntá tinkákꞌe sin tí nchísén chrínkí nta̱. ");
INSERT INTO poeNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ntá ntáchro tí chꞌín Jesús kíxin: ―Chréhérá tí janhan, ntá tso̱tja̱hárá xra̱ tsjéyárá chojni ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ntá tuénxín kuíto̱he sín tí nchísén kꞌuétséya sín koche ntá sákjuíko sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ntá kjínhya kjuíji chꞌín Jesús ntá kꞌuíkon chꞌán tí yaá xje̱en chꞌín Zebedeo. Ijnko mé itꞌin Jacobo. A̱ ntá tí í jnko la mé itꞌin Juan. Jehe sín la ko tí itꞌé sín tjejóxenhen sín tí ntabárco̱ tjejótjo̱nité sín tí nchísén tséya sín tí koche. ");
INSERT INTO poeNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Na ntá chꞌín Jesús mé kꞌuíye̱he̱ tí jehe sín kíxin kja̱xin tsochréhe̱ sín chꞌán. A̱ ntá tuénxín kuíto̱he sin tí itꞌé sín chꞌín Zebedeo kuíto̱eko chꞌan tí ntabárco̱ la ko tí sín tjinki̱tsa chꞌán chꞌe xra̱. A̱ ntá jehe sín sákjuiko sín chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ntá kjuíji sín tí chjasin itꞌin Capernaum. Na ntá tí ya̱on tꞌo̱kꞌéhe sín mé kꞌuíxenhen chꞌin Jesús tí ni̱nko Israel. Na ntá ntaha mé kjuankíxin chꞌán kjuako chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","A̱ ntá tí chojni siín ntiha mé chrakon sín kuínhin sín tí nkehe kjuako chꞌán kíxin kjua̱ko̱xi̱n chꞌán kíxin chónta chꞌán kjuachaxin, la jehya éxí tí sín maestro tjako tí ley, ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ntá tí ni̱nko Israel chjasin ntiha itjen ijnko chojni chónta ijnko ncha̱kuen tí jínahya kꞌuíyato ntáchro kíxin: ");
INSERT INTO poeNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―¿Nkekuènté tji̱a̱té tí jeheni kaín ni? Jaha Jesús kjuíxian Nazaret. ¿Á kꞌuinka kíxin si̱nchekꞌitjáyanni? Janhan mé ó kjuátso̱an tí jaha, la ko nòna kíxin jaha tí nkexro tjóá kuènte Dios ―mé xi̱kaha ichro tí ncha̱kuen tí jínahya. ");
INSERT INTO poeNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ntá chꞌín Jesús mé kꞌue̱tue̱nhen tí ncha̱kuen tí jínahya ntáchro chꞌán kíxin: ―Tániá, tꞌaxrjéxian tí jehe chꞌán ―mé xi̱kaha ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","A̱ ntá tí ncha̱kuen tí jínahya mé kjuínchekꞌaniáte tí chꞌín a la ko kꞌuíyatoxín tsen ntá kꞌuaxrjexín tí chꞌín a. ");
INSERT INTO poeNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","A̱ ntá kaín sín chrakon sín ntá kjuanchankíhi sín kíchó sín, ntáchro sín kíxin: ―¿Xá nkexro tíha kíxin tjako chꞌán nkehe ni̱xin? Jehe chꞌán chónta kjuachaxin kíxin tꞌe̱tue̱nhen chꞌán tí ncha̱kuen tí jínahya la titekakonhen ―mé xi̱kaha ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","A̱ ntá imá tjoka kꞌuíxikónohe kaín xín sín estado Galilea kíxin nkexrí tí kjuachaxin chónta tí chꞌín Jesús a. ");
INSERT INTO poeNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ntá tí chꞌín Jesús mé kꞌuaxrjexín chꞌán tí ni̱nko, a̱ ntá tuénxín sákjuiko chꞌán chꞌín Jacobo la ko chꞌín Juan, sákjuí sin nto̱e chꞌín Simón la ko chꞌín Andrés. ");
INSERT INTO poeNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ntá tí ichꞌe̱e chꞌín Simón na tjetsínka tjan, níhi tjan kíxin chónta tjan sóa. Ntá chénka sín tí chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ntá kóchjina chꞌán tí tjetsínka tjan ntá itsé chꞌán tja tjan kꞌuínkatjen tjan. Ntá tuénxín kjuìinhin tjan tí sóa chónta tjan. Ntá kjuanjon tjan nkehe sine sín. ");
INSERT INTO poeNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","A̱ ntá tió kjuiátaón ya̱on tió kꞌuíxin tie kui̱ko̱he sín tí chꞌin Jesús kaín tí sín níhi la ko tí sín chónta ncha̱kuen jínahya; ");
INSERT INTO poeNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","na ntá kuenté chjasin kójnkotsé sín kꞌuíxintankí sin ntója tí nchia a. ");
INSERT INTO poeNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ntá kjuínchekito̱he chꞌán jína kaín tí chojni níhi chónta nchónhya clase chin la ko kuakitsje chꞌán kaín tí ncha̱kuen tí jínahya. Na í kjuanjonhya chꞌán kjuachaxin kíxin tsonixja tí ncha̱kuen tí jínahya kíxin ó kjuátso̱an tíha nkexro tí jehe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ntá na̱xa̱ sítié kꞌuàya chꞌín Jesús kꞌuaxrjexín chꞌán tí chjasin a sákjui̱ chꞌán nte̱je̱ kíxin ntiha nixje̱exín chꞌán Itꞌé chꞌán tjen nkaya nka̱jní. ");
INSERT INTO poeNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ntá chꞌín Simón la ko tí sín xriko chꞌán mé sákjui̱kjeyá sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ntá kꞌuitja sín chꞌán ntá chénka sín kíxin: ―Kaín sín xritjeyá sín tí jaha ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ntá ntáchro chꞌín Jesús kíxin: ―Sátsjini ókjé chjasin chjinaxón kíxin ntaha kja̱xin tsjáko̱ha̱ sín tí tan jína, kíxin xi̱kaha mé tí kꞌuaxrjexia̱n chjasin ntiha. ");
INSERT INTO poeNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ntá nkuíxín estado Galilea sákjuí chꞌán kuinkákjako chꞌán jnkojnko ni̱nko la ko kuakitsje chꞌán tí ncha̱kuen tí jínahya chónta sín. ");
INSERT INTO poeNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ntá kui ijnko chꞌín chónta chinlepra kjuákꞌexín tochꞌin chꞌán nkayakon chꞌín Jesús ntá chrónóe̱he̱ chꞌán ntáchro chꞌán kíxin: ―Tí tjinkávan jaha la jína chrókjui̱nchekito̱héni jína ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ntá chꞌín Jesús na imá kui̱konóe̱he̱ chꞌán tí chꞌín a na ntá kjuentoá tja chꞌán kjuakꞌe tja chꞌán chrítaón tí chꞌín níhi a ntá ntáchro chꞌán kíxin: ―Méxra̱ xi̱kaha tjínka̱van. Ntá jie si̱ntakito̱ha jína ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","A̱ ntá xi̱kaha ntáchro chꞌán ntá tuénxín kjuìin tí chinlepra ntá kuíto̱he chꞌán jína. ");
INSERT INTO poeNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ntá kꞌue̱tue̱nhen chꞌín Jesús tí chꞌín a kíxin tjoka sátsji chꞌán, ntáchro chꞌán kíxin: ");
INSERT INTO poeNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Ninkexró chenkahya ntihi; jehó sátjia tjákohé tí chꞌín ncha̱tꞌá kíxin ó kjuìinhan tí chinlepra la ko tjánjuan tí nkehe tsíkꞌe̱to̱an chꞌín Moisés kíxin tso̱noexín kaín xín chojni kíxin ó kuíto̱ha jína ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","A̱ ntá tí chꞌín tsíkito̱he jína, a̱ ntá sákjuí chꞌán kjuankíxin chꞌán chénka chꞌán kaín xín chojni kíxin nkexrí kuíto̱he chꞌán jína. Méxra̱ xitjahya tsꞌixenhen chꞌín Jesús noxín nijnko chjasin na ntá kꞌuaxrjenta chꞌán tí kohya chojni. Ntá kjónté la kjuitsjehe sín chꞌán kjui̱xi̱n sín nkuíxín chjasin. ");
INSERT INTO poeNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ntá ó kꞌuátsínka iso ya̱on ntá chꞌín Jesús mé xíkjan chꞌán chjasin Capernaum. Ntá kꞌuíxikónohe chojni kíxin ijnko nchia ntiha kjuákꞌe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ntá tuénxín nchónhya chojni kóchjina ntá kjuachahya tí nchia kꞌuíxixenhen sín la ko kja̱xin kjuachahya tí ntója nchia chrókꞌuíxintankí sín. A̱ ntá chꞌín Jesús kjuako tí tan jína kuènte Dios. ");
INSERT INTO poeNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ntá kui noó sín tinkátsénkí sín ijnko chꞌín tsíkꞌen to̱té chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kjánchó xitjahya kóchjina sín tí tjen chꞌín Jesús kíxin nchónhya chojni siín. La ntá kꞌui̱tꞌótjen sín tí chrítaón nchia a ntá kꞌóxra̱tꞌo̱ sín. Na ntá ijnko hno̱ kjua̱kꞌe̱te sín tí kania tjenkáya tí si̱nníhi a ntá kjuinkajin sín ntoí tí tjen chꞌín Jesús a. ");
INSERT INTO poeNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Tió kꞌuíkon chꞌín Jesús tí nkehe kjuíchꞌe sín ntá ó nohe chꞌán kíxin chaxín imá tinkáchónki sín tí jehe chꞌán. Ntá nixje̱he̱ chꞌán tí si̱nníhi ntáche chꞌán kíxin: ―Xje̱enni, ó kjuixin kjuìinhan tí jie̱ chonta ―mé xi̱kaha ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Na ntá iso tí sín maestro tjako tí ley tjejótja̱xi̱n sín ntiha na ntá jehó sín mé kjo sín a̱sén sín kíxin: ");
INSERT INTO poeNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Nkekuènté xi̱kaha nixja tí chꞌín i ncheyóhe̱ chꞌán a̱sén chꞌán Dios? Kíxin ninkexró xitjahya tsjatsìin ijie̱ kíxin jehó Dios mé chónta kjuachaxin tsja̱tse̱n iji̱é chojni”, mé xi̱kaha ikjo sín a̱sén sín. ");
INSERT INTO poeNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ntá chꞌín Jesús la ó nohe chꞌán nkehe tjenka̱yáxin sín. Ntá ntáchro chꞌán kíxin: ―¿Nkekuènté kíxin xi̱kaha tjenka̱yáxinrá? ");
INSERT INTO poeNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Nkehe a̱ntsí má xra̱hya chróntátjan chꞌán? ¿Á a̱ntsí xra̱hya chróntátjan chꞌán kíxin ó kjuixin kjuìinhin chꞌán tí jie̱ yámá chꞌán, o̱ á a̱ntsí xra̱hya chróntátjan chꞌán kíxin chrókꞌuinkatjen chꞌán chrókjuenájín chꞌán ka̱nie̱e chꞌán ntá sáchrókjui chꞌán? ");
INSERT INTO poeNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Méxra̱ jie tsjáko̱xi̱a̱n kíxin tí Xje̱en Dios Kꞌóna Chojni mé ntihi chjasintajni chónta kjuachaxin tsjakjìinhin iji̱é chojni ―ichro chꞌán. Ntá ntáche chꞌán tí chꞌín xitjahya tji kíxin: ");
INSERT INTO poeNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Jaha tétua̱nhan tꞌinkatjen, tjenájían ka̱nia̱a na sátjia nto̱a ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","A̱ ntá tí si̱nníhi na tuénxín kꞌuínkatjen chꞌán kjuákꞌexín to̱té chꞌán na kjuenájín chꞌán ka̱nie̱e chꞌán na kuámá chꞌán kꞌuaxrjexín chꞌán nchia sákjuí chꞌán. Na ntá kaín tí sín siín a tsjehe sín nkexrí kónhen na chrakon sín la ko kjuanchehe sín Dios kjuasáyé. Ntá ntáchro sín kíxin: ―Kꞌuíkonhyéni tí nkehe i ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","A̱ ntá chrꞌéxi̱n chꞌín Jesús mé sáxíkji chꞌán inaá chrínta nta̱yaon. Ntá kaín xín chojni kóchjina sín tí tjen chꞌán ntá kjuako chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ntá kꞌuátsínka chꞌán kꞌuíkon chꞌán tí chꞌín Leví xje̱en chꞌín Alfeo tjetja̱xi̱n chꞌán tjenchekjènki̱ chꞌán. Ntá chꞌín Jesús mé kꞌuíye̱he̱ chꞌán, ntáchro chꞌán kíxin: ―Chréhé tí janhan ―ichro chꞌán. Ntá chꞌín Leví mé tuénxín kꞌuínkatjen chꞌán chréhe̱ chꞌán tí chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","A̱ ntá chꞌín Jesús kjuákꞌe chꞌán nto̱e tí chꞌín Leví, la ntá kjuanjon sín nkehe sine chꞌán la ko kja̱xin kꞌuéjó nchónhya tí sín nchekjènki̱ la ko kja̱xin í so chojni chónta jie̱. Mé kaín tí sín a mé tjejótja̱xi̱n sín tjejóneko tí chꞌín Jesús la ko tí sín kꞌuájiko chꞌán, kíxin nchónhya chojni chréhe̱ sín tí jehe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Na ntá tí sín maestro tjako tí ley la ko tí sín fariseo kꞌuíkon sín kíxin chꞌín Jesús tjejóneko kaín ti sín nchekjènki̱ la ko tí í so sín chónta jie̱, a̱ ntá ntáche sín tí sín kꞌuájiko chꞌán kíxin: ―¿Nkekuènté kíxin tí maestro kuèntárá neko chꞌán la ko tꞌika̱o chꞌán tí sín nchekjènki̱ la ko tí í so sín chónta jie̱? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Na ntá chꞌín Jesús kuínhin chꞌán nkehe tí tjo sín a. Ntá nixje̱he̱ chꞌán tí sín a ntáchro chꞌán kíxin: ―Tí sín níehya tꞌichjánxi̱enhya sín nkexro sichꞌe xro̱a̱n. Náhí. Jehó tí sín níhi mé tꞌichjánxi̱nhin sín nkexro sichꞌehe sín xro̱a̱n. Janhan na kꞌuinkahya ntihi kíxin chrókꞌuíya̱ha̱ chojni jína tjejó sín. Náhí. Kꞌuinka kíxin tsꞌíya̱ha̱ chojni chónta jie̱ ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ijnko ya̱on na mé kaín xín tí sín kꞌuékꞌajiko chꞌín Juan Bautista la ko tí sín fariseo a mé kjónehya sín kuenté ya̱on kíxin mé xi̱kaha tsꞌáyéhe̱ sín kjuaxróxin, ichro sín. A̱ ntá kui iso chojni nixje̱he̱ sín tí chꞌín Jesús ntáchro sín kíxin: ―¿Nkekuènté kíxin tí sín kꞌuékꞌajiko sín tí chꞌín Juan la ko tí sín fariseo la nehya sín jie, a̱ ntá tí sín xrikoa la ine sín? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―¿Xá chrókjónehya tí chojni tsíkꞌíye̱he̱ sín kóchjina ijnko kia tso̱te̱he chojni tí na̱xa̱ tjejóko sín tí nkexro tso̱te̱he? Tí na̱xa̱ tjen tí nkexro tso̱te̱he la xitjahya kíxin chrókjónehya sín. ");
INSERT INTO poeNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","A̱ ntá itsi ijnko ya̱on itsi chojni sátsjiko sín tí chꞌín tsíkóte̱he, ntá tí ya̱on la chaxín sinehya sín. ");
INSERT INTO poeNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Ninkexró chrókjuakꞌenie̱he ijnko ka ó ntaxin itꞌo̱ ka ni̱xin kíxin ntá chrókjui̱xéhe̱ tí ka ni̱xin ntá a̱ntsí má chrókꞌuichje tí ka ntaxin a. ");
INSERT INTO poeNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","La ko kja̱xin ninkexró chrókui̱ki̱a̱ xran vino ni̱xin ijnko tjua̱xran ó ntaxin; kíxin tí xran vino ni̱xin la chrókótséchje tí tjua̱xran ntaxin ntá chrókꞌuitjáyan tí xran la ko tí tjo̱a̱. Méxra̱ tí xran vino ni̱xin chrókuikia ijnko tjua̱xran ni̱xin ―mé xi̱kaha ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ijnko ya̱on tꞌo̱kꞌéhe sín na chꞌín Jesús la ko tí sín kꞌuájiko chꞌán mé kꞌuátsínka sín ijnko nonte siín noatrigo. Na ntá tí sín kꞌuájiko chꞌán kjuankíxin sín ikꞌuín sín iso noatrigo. ");
INSERT INTO poeNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Na ntá iso tí sín fariseo kjuanchankíhi sín tí chꞌín Jesús a kíxin: ―¿Nkekuènté kíxin tí sín xrikoa tjejóchꞌe sín xra̱ ijie? Na mé kohya kjuachaxin tso̱nhen xra̱ tí ya̱on tꞌo̱kꞌéheni ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ntá kjuáte̱he chꞌán ntáchro chꞌán kíxin: ―¿Á kjui̱nchekuáxinhyará jahará tí xroon chrónka nkehe kjuíchꞌe chꞌín David la ko tí sín kꞌuájiko chꞌán tí kꞌuén sín kjinta? ");
INSERT INTO poeNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","A ntá jehe chꞌán kꞌuíxenhen chꞌán nto̱e Dios tió kjuákꞌe ncha̱tꞌá Abiatar kꞌue̱to̱an, a̱ ntá kjóne chꞌán tí nio̱tja̱ tsíkóyaon kjónté jehó tí sín ncha̱tꞌá mé kꞌuéchónta kjuachaxin sine sín la kja̱xin chjéhe chꞌán tí sín kꞌuájiko chꞌán ―ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Kja̱xin ntáchro chꞌín Jesús kíxin: ―Kꞌóna tí ya̱on tsꞌo̱kꞌéhe chojni kíxin tꞌichjánxi̱n sín, la jehya kíxin chrókjuikosáyehe tí ya̱on a. ");
INSERT INTO poeNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","A̱ ntá tí Xje̱en Dios Kꞌóna Chojni mé chónta kjuachaxin tsꞌe̱to̱an nkehe tso̱nhen tí ya̱on tꞌo̱kꞌéheni ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ntá chꞌín Jesús kꞌuíxenhen chꞌán ijnko ni̱nko Israel ínaá. Na mé ntiha tjen ijnko chꞌín tsíxámá ijnko tja chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Na ntá kóchjina iso chojni tsáyehe sín chꞌín Jesús tsꞌikon sín kíxin á sinchekito̱he chꞌán jína tí chꞌín tsíxámá tja tí ya̱on tꞌo̱kꞌéhe sín kíxin mé jína tsjanchia sín jie̱, ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ntá chꞌín Jesús mé ntáche chꞌán tí chꞌín tsíxámá tja a kíxin: ―Tꞌinkatjen, tjakꞌe jnko̱siné ntihi ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","A̱ ntá kjuanchankíhi chꞌín Jesús tí sín siín ntiha kíxin: ―¿Nkehe siín kjuachaxin tso̱nhen tí ya̱on tꞌo̱kꞌéheni? ¿Á chrókjuichꞌeni tí jína ní o̱ á chrókjuichꞌeni tí jínahya? ¿Á chrókjuinchekito̱heni chojni jína ní o̱ á chrókꞌóyánni chojni? ―ichro chꞌán. A̱ ntá jehe sín la táníkoá sín. ");
INSERT INTO poeNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Na ntá chꞌín Jesús la nínkaon chꞌán komá chꞌán tí jehe sín la ko tꞌává chꞌán kíxin tjinkakonhya sín tsi̱konóe̱he̱ sín chojni. Na ntá kꞌue̱tue̱nhen chꞌán tí chꞌín a kíxin: ―Tjéntoá tjá ―ichro chꞌán. A̱ ntá kjuéntoá chꞌán tja chꞌán la ó kuíto̱he tja chꞌán jína. ");
INSERT INTO poeNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Na ntá tí sín fariseo a kꞌuaxrjexín sín ni̱nko sákjuí sín kꞌuíto sín tí sín kuènte chꞌín Herodes ntá kjuenka̱yáxinko kíchó sín kíxin nkexrí chrókꞌóyán sín tí chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ntá chꞌín Jesús la ko tí sín kꞌuájiko chꞌán sákjuí sín chrínta nta̱yaon a. A̱ ntá nchónhya chojni kjuíjichréhe̱ sín tsíki̱xi̱n sín nó estado Galilea la ko kja̱xin tsíki̱xi̱n sín nó estado Judea ");
INSERT INTO poeNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","la ko chjasin Jerusalén la ko estado Idumea la ko ikjé sín kui̱xi̱n sín nó tóhe nta̱río Jordán la ko iso sín tsíki̱xi̱n sín nó chjasin Tiro la ko nó chjasin Sidón. Na mé kaín sín tsíkinhin sín kíxin nkexrí tí kjuaxroan jié kjuasin chꞌín Jesús ntá kuichréhe̱ sín chꞌán kíxin chrókꞌuikon sín tíha kja̱xin. ");
INSERT INTO poeNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ntá kꞌue̱tue̱nhen chꞌán tí sín kꞌuájiko chꞌán a kíxin ntahó chrókjua̱kꞌe̱cho̱nhen sín ijnko ntabárco̱. A̱ ntá tí imá chrókꞌuixitja sín chꞌán ntá chrókꞌuixenhen chꞌán tí ntabárco̱, a̱ ntá ntiha chrókjuakꞌe chꞌán tsochrónka chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Kíxin itsjé chojni tsíkjinchekito̱he chꞌán jína, na ntá kaín xín tí sín níhi kꞌuíxitja sín chꞌán kíxin tjinkaon sín chrókuákóxi̱n sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kja̱xin tí sín chónta ncha̱kuen tí jínahya na mé tió kꞌuíkon sín tí chꞌín Jesús ntá kꞌuéjóxin sín tochꞌin sín nkayakon chꞌán. Ntá kꞌóyako tí ncha̱kuen tí jínahya a ntáchro kíxin: ―Jaha mé tí Xje̱en Dios. ");
INSERT INTO poeNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","A̱ ntá chꞌín Jesús ntáche chꞌán tí ncha̱kuen tí jínahya kíxin kohya kjuachaxin tsochrónka kíxin nkexro tí jehe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","A̱ ntá chrꞌéxi̱n chrìin chꞌín Jesús ijnko jna̱, a̱ ntá ntiha kꞌuíye̱he̱ chꞌán tí sín tjinkaon chꞌán chrókꞌuajiko chꞌán ntá kóchjinehe sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ntá kjueyá chꞌán teyó tí sín tsꞌajiko chꞌán kíxin tsꞌe̱tue̱nhen chꞌán sín sátsji sín tsjako sín tí tan jína. ");
INSERT INTO poeNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Kjuanjon chꞌán kjuachaxin sinchekito̱he sín chojni níhi jína la ko tsakitsje sín ncha̱kuen tí jínahya chónta chojni. ");
INSERT INTO poeNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","A̱ ntá tí sín i mé tí teyó sín tsíkjeyá chꞌán mé itꞌin sín xi̱kihi: Simón na mé kjuínchekꞌin chꞌán Pedro; ");
INSERT INTO poeNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","la ko Jacobo la ko tí kícho chꞌán Juan mé xje̱en chꞌín Zebedeo. Kja̱xin kjuínchekꞌin chꞌán sín Boanerges mé tꞌaxrjexín kíxin Xje̱en Sítjonta. ");
INSERT INTO poeNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","La ko Andrés la ko Felipe la ko Bartolomé la ko Mateo la ko Tomás la ko Jacobo, itꞌé mé itꞌin Alfeo, la ko Tadeo la ko í jnko Simón tíhi mé kuènte tí sín cananista, ");
INSERT INTO poeNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","la ko Judas Iscariote, mé kjuínchekji tí chꞌín Jesús chrꞌéxi̱n. Na ntá chrꞌéxi̱n chꞌín Jesús la ko tí sín kꞌuájiko chꞌán kꞌuíxenhen sín ijnko nchia. ");
INSERT INTO poeNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","A̱ ntá ínaá kójnkotsé nchónhya chojni, a̱ ntá xitjahya sine sín. ");
INSERT INTO poeNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ntá kónohe tí sín na̱xa̱ kjéhya chꞌín Jesús ntá ikui sín sátsjiko sín chꞌán kíxin ntáchro sín kíxin ó tsíkꞌixikján chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Kja̱xin tí sín tjako ti ley kui̱xi̱n sín Jerusalén, ntáchro sín kíxin: ―Tí chꞌín i chónta chꞌán tí chꞌín Beelzebú, mé chꞌín Tsochren, mé tí nkexro tꞌe̱tue̱nhen kaín tí ncha̱kuen tí jínahya ntá xi̱kaha tjacha chꞌán takitsje chꞌán ncha̱kuen tí jínahya a ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ntá chꞌín Jesús kꞌuíye̱he̱ chꞌán tí sín ntá kjuíncheyóe̱xin chꞌán ntáchro chꞌán kíxin: ―¿Nkexrí kíxin jnkokón chꞌín Tsochren chrókuakitsje a̱sén? ");
INSERT INTO poeNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","A̱ ntá tí sín tꞌe̱to̱an ijnko nación tjanjo̱nko kíchó la tsjachahya tsꞌe̱to̱an. ");
INSERT INTO poeNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","La ko kja̱xin tí sín jnkoko̱á nto̱e jnkoko̱áhya tjenka̱yáxin sín ntá xitjahya tsꞌejóko kíchó sín. ");
INSERT INTO poeNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","A̱ ntá tí chaxín chꞌín Tsochren jnkokónhya tjenka̱yáxin tjanjo̱nko kíchó la ntá tsꞌitjáyan kjuachaxin kuènte. ");
INSERT INTO poeNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Ninkexró tsjacha tsꞌixenhen nto̱e ijnko chojni jie̱he kíxin tsꞌaxrjehe tí nkehe chónta chꞌán. Náhí. Tꞌichjánxi̱n sa̱oxín sinchenteto chꞌán tí chꞌín jie̱he kíxin jína tseéhe chꞌán nkehe chónta tí chꞌín a. ");
INSERT INTO poeNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Ijnko nkehe chaxín tso̱tjo̱nka̱rá kíxin tió tsoxraxinkaon ijnko chojni tí jie̱ chónta la ko tsochronóe̱he̱ Dios la ntá tsjakjìinhin chꞌán kaín tí jie̱ la ko kaín tí nkehe jínahya tsíntáchro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","A̱ ntá tí nkexro tsꞌántaxínhi̱n tí Ncha̱kuen Dios na mé xitjahya tsjìin tí jie̱ na mé jnkochríxín tsochónta sín tí jie̱ a ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Mé xi̱kaha ichro chꞌán kíxin tí sín a tsíntáchro sín kíxin ijnko ncha̱kuen tí jínahya mé chónta tí jehe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","A̱ ntá kui ìné chꞌín Jesús la ko kíchó chꞌán tjejó sín ntója ó na ntá kꞌue̱tue̱nhen sín ijnko chojni tsjikꞌíye̱he̱ chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","A ntá tí sín tjejótja̱xi̱n tí tjen chꞌín Jesús ntiha chénka sín chꞌán kíxin: ―Ìná la ko kíchuá tjejó sín ntója xritjeyá sín ti jaha. ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ntá ntáchro chꞌán kíxin: ―¿Xá nkexro tí na̱na la ko nkexro tí kíchiná? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ntá komá chꞌán tí chojni tjejótja̱xi̱n tí tjen chꞌán ntá ntáchro chꞌán kíxin: ―Jahará mé na̱na la ko kíchiná. ");
INSERT INTO poeNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Kaín tí sín nchexiteyá tí nkehe tjinkaon Dios na mé tí sín a mé kíchiná la ko na̱na ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Chꞌín Jesús mé kjuankíxin chꞌán kjua̱ko̱xi̱n chꞌán chrínta nta̱yaon ínaá. A̱ ntá ntiha mé kójnkotsé nchónhya chojni tí tjen chꞌán. Ntá ijnko ntabárco̱ tjenkátaón nta̱ kꞌui̱tꞌótjen chꞌán, a̱ ntá ntaha kjuákꞌe chꞌán kjua̱ko̱xi̱n chꞌán. Ntá kaín tí sín tsíkójnkotsé mé kuíto̱he sín chrínta nta̱yaon kꞌuéjókinhin sín. ");
INSERT INTO poeNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Nchónhya nkehe kjuako chꞌán kjuíncheyóe̱xin chꞌán. Ntá ntáchro chꞌán kíxin: ");
INSERT INTO poeNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Tinhínrá tíhi: Ijnko chojni sákjuíkꞌe̱nka̱ no̱nte̱e. ");
INSERT INTO poeNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Mé xi̱kaha sákjuíkꞌe̱nka̱ chꞌán iso tí noatrigo a. Ntá iso noa la tsíkꞌánotjen nti̱a ntá kui koxroxe kꞌuìnka̱ va tí noa. ");
INSERT INTO poeNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","A̱ ntá iso noa na mé kꞌuítji chríkꞌá xro̱ tí kohya itsjé nche ntá tjoka kꞌuayan kíxin tjínhya chónta nche. ");
INSERT INTO poeNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","A ntá tió kjui̱to̱n ya̱on la ntá tí ka la chján; la ko chóntahya nuèe a̱ ntá xámá. ");
INSERT INTO poeNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","A̱ ntá í so noa kjuítsínkakꞌá tí siín kachꞌi̱ la ntá tí kachꞌi̱ kꞌuánkí la ntá tí noa í kꞌónahya kíxin sítja tí kachꞌi̱. ");
INSERT INTO poeNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","A̱ ntá íso tí noa kꞌuítji nche jína la ntá kꞌuayan la ko kꞌuánkí nte̱to la ko kꞌóna jína. A̱ ntá ijnko noa la mé kꞌóna treinta neno noa. A̱ ntá í jnko la mé kꞌóna sesenta neno noa, a̱ ntá í jnko la kꞌóna ijnko ciento neno noa ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ntá ntáchro chꞌán kíxin: ―Tí nkexro tjinkaon chrókuinhin la chrókuinhin ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","A̱ ntá chrꞌéxi̱n, tió kuíto̱he chꞌín Jesús jehó chꞌán, a̱ ntá tí sín tjejó chjinaxón tí tjen chꞌán la ko tí teyó sín kꞌuájiko chꞌán mé kjuanchankíhi sín chꞌán kíxin nkexrí tꞌaxrjexín tí nkehe kjuíncheyóe̱xin chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ntá ntáchro chꞌán kíxin: ―A̱ ntá jahará la Dios mé sintanohará tí nkehe tienxínhya chojni kuènte tí kjuachaxin kuènte Dios, a̱ ntá tí sín titekakonhya la ó kjui̱ntayóa̱xuán kaín nkehe kuínhin sín. ");
INSERT INTO poeNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Kíxin kjónté tsꞌikon sín la éxí kꞌuíkonhya sín, la ko kjónté tsinhin sín la tsienxínhya sín kíxin ntá chrókꞌuixitoxi̱nhya tí tjenka̱yáxin sín a la ko chrókjuìinhya tí iji̱é sín ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ntá ntáche chꞌán sín kíxin: ―¿Á kiénxinhyará jahará nkexrí tꞌaxrjexín tí nkehe kjui̱ntayóa̱xian ní? ¿A̱ ntá nkexrí chrókiénxinrá tí í so nkehe na̱xa̱ si̱ntayóa̱xian? ");
INSERT INTO poeNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","A̱ ntá tí nkexro sákjuíkꞌe̱nka̱ tí tje a mé yóhe̱ ijnko nkexro sákjuíkjako itén Dios. ");
INSERT INTO poeNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","A̱ ntá iso chojni la éxí tí tje kjuítsínka nti̱a; kíxin kuínhin sín itén Dios, ntá chrꞌéxi̱n ó kui chꞌín Tsochren kjuínchekꞌitjáyan chꞌán tí tan jína kuínhin sín. ");
INSERT INTO poeNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","A̱ ntá í so chojni la éxí yóhe̱ tí tje kjuítsínkakꞌá xro̱: mé kuínhin sín itén Dios ntá tjoka kóxrjínhi̱n sín kuítekaon sín. ");
INSERT INTO poeNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Kjánchó ni̱nkahya chónta nuèe, a̱ ntá séhya kuíto̱he; a̱ ntá itsi tí kjuaxróxinhya tso̱nhen sín, o̱ tsochónkíhi sín chojni kíxin tí itén Dios kuítekaon sín ntá tsíto̱he sín tí tinkáchónki sín Dios. ");
INSERT INTO poeNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","A̱ ntá í so chojni la éxí yóhe̱ tí tje kꞌuínka chríkꞌá kachꞌi̱ na mé kuínhin sín itén Dios ");
INSERT INTO poeNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","kjánchó tóxakonhen sín tí nkehe siín chjasintajni la ko tí nkehe tjete tóxrjínhi̱n sín la ko tjinkaon sín tsochónta sín kaín xín nkehe. Kaín tíha mé tꞌinkákonhe̱n tí itén Dios kuínhin sín a, la tí chojni xi̱kaha la xitjahya sichꞌehe sín xra̱ Dios. ");
INSERT INTO poeNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","A̱ ntá í so chojni kuínhin tí itén Dios na kuinkáchónki sín la ntá xi̱kaha jína chꞌehe sín Dios xra̱. La iso sín la éxí yóhe̱ tí tje kꞌuínka tí nonte jína kꞌóna treinta neno noa la ko iso sín la yóhe̱ tí tje kꞌóna sesenta neno noa la ko iso sín la yóhe̱ tí tje kꞌóna ciento neno noa ―mé xi̱kaha ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Kja̱xin ntáchro chꞌín Jesús kíxin: ―¿Á chrókui̱ka̱onni xrohi tjeche chrókjuakꞌemá chrínkí ntacajón o̱ chrínkí cama? Kjá náhí. Tí xrohi la noi chrókjuakꞌe tsꞌinkaséyanxín. ");
INSERT INTO poeNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Mé xi̱kaha kaín tí nkehe tjejómá jie tso̱noxín chrꞌéxi̱n la ko kaín tí nkehe ninkexró noehya jie la tso̱noxín chrꞌéxi̱n. ");
INSERT INTO poeNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","A̱ ntá tí nkexro tjinkaon chrókuinhin la chrókuinhin tíhi ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Kja̱xin ntáchro chꞌán kíxin: ―Chrókjuenka̱yáxinrá jína tí nkehe tjejótinhinrá. Tí nkehe tjáchoayárá jahará la Dios la kja̱xin tíha tsjáchoayá chꞌán tí nkehe tsꞌayéhérá jahará, a̱ ntá a̱ntsí má tsꞌayéhéra tí jahará tjejontinhinrá. ");
INSERT INTO poeNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","A̱ ntá tí nkexro chónta nkehe la a̱ntsí má tsꞌáyéhe̱ sín. A̱ ntá tí nkexro chóntahya la kjónté tí ntsí chónta la tsꞌaxrjehe ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Kja̱xin ntáchro chꞌín Jesús kíxin: ―Tí kjuachaxin tꞌe̱to̱an Dios tóyóhe̱ ijnko chojni sátsjikꞌe̱nka̱ nonte. ");
INSERT INTO poeNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ntá sákjuíkꞌajua chꞌán tí tie la ko kꞌuàya chꞌán tí nchítjen. A̱ ntá xi̱kahó kꞌuátsínka iso ya̱on la ko iso tie, a̱ ntá tí tje la kꞌuayan la kꞌuánkí. A̱ ntá tí nkexro kꞌue̱nka̱ la noehya chꞌán nkexrí kónhen tíha. ");
INSERT INTO poeNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","A̱ ntá tí nche mé kjuíchꞌe xra̱ jehó. Senó kꞌuayan tí chaon tí ka, a̱ ntá kjui̱nta̱a, a̱ ntá chrꞌéxi̱n icha tí noa tsjinjin; ");
INSERT INTO poeNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","a̱ ntá tió tsícha tí noa, a̱ ntá tsakjinjin sín tí noa kíxin ó kjuixraká tí ya̱on tsotjá sín. ");
INSERT INTO poeNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Kja̱xin ntáchro chꞌín Jesús kíxin: ―¿Nkehe chrókóyóhe̱ tí kjuachaxin tꞌe̱to̱an Dios, nkehe chrókóyóe̱xin tíha? ");
INSERT INTO poeNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Mé éxí yóhe̱ tí tje itꞌin mostaza tsíkꞌinka nonte. Tíha mé ijnko tje imá ntsí, a̱ ntá tí í so tje siín chjasintajni la kénhyó. ");
INSERT INTO poeNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","A̱ ntá jnkonaá tsíkꞌinka tí tje la tsíkꞌayan tsíkꞌánkí imá ihyé, a̱ ntá tí í so nta la kánhyó. A̱ ntá kja̱xin tí chaon tí nta tsíkꞌánkí imá ihyé, a̱ ntá kjónté koxroxe xritjaka la jína tsꞌo̱kꞌéhe va chrínkí tí tsꞌvan chaon tí nta. ");
INSERT INTO poeNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Mé xi̱kaha chꞌín Jesús kjua̱ko̱he̱ chꞌán tí jehe sín, kjuíncheyóe̱xin chꞌán nchónhya nkehe éxí tí nkehe a kíxin chrókjuacha chrókienxín sín tíha. ");
INSERT INTO poeNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Kaínxín nkehe kjua̱ko̱he̱ chꞌán tí jehe sín la kjuíncheyóe̱xin chꞌán. A̱ ntá jehó tí sín kꞌuájiko chꞌán la chrónka chꞌán nkexrí tꞌaxrjexín kaín tí nkehe kjuíncheyóe̱xin chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","A̱ ntá tí ya̱on a la ntá ó kóntó ntá ntáche chꞌín Jesús tí sín kꞌuájiko chꞌán a kíxin: ―Sátsjini tóhe tí nta̱yaon ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ntá kuíto̱he sín kaín tí chojni a ntá sákjuíko sín tí chꞌín Jesús na̱xa̱ tjenkáya chꞌán tí ntabárco̱ la ko kja̱xin í so ntabárco̱ sákjuí koí. ");
INSERT INTO poeNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ntá xrína̱hya tji̱a̱n chjéhe xri̱nto̱ la ntá síchrica nta̱ tꞌixenhen tí ntabárco̱, ó mero tso̱kaón nta̱ tí ntabárco̱. ");
INSERT INTO poeNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","A̱ ntá chꞌín Jesús na mé tjejua chꞌán tí tjarꞌi nóton tí tjejó sín nkaxenhen tí ntabárco̱ a tjekjón chꞌán ijnko ka. Na ntá kjuínchekjàya̱ sín chꞌán ntáchro sín kíxin: ―¡Maestro! ¿Á nto̱sán kíxin tsꞌitjáyanni, tsꞌaniánkíni nta̱ ní? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","A̱ ntá chꞌín Jesús kꞌuàya chꞌán, kꞌue̱tue̱nhen chꞌán tí xri̱nto̱ la ko tí nta̱ kíxin tsꞌixita, ntáchro chꞌán kíxin: ―Tániá, tjakꞌeta ―ichro chꞌán. Na ntá tí xri̱nto̱ la ko tí nta̱ kꞌuíxratá. ");
INSERT INTO poeNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ntá kjuanchankíhi chꞌán tí sín kꞌuájiko chꞌán ntáchro chꞌán kíxin: ―¿Nkekuènté kíxin imá chrakonrá? ¿Á na̱xa̱ tinkachónkihyará Dios? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ntá imá chrakon sín ntá kjo sín kíchó sín kíxin: ―¿Xá nkexro tíhi? Kjónté xri̱nto̱ la ko nta̱yaon la mé kjuínchexiteyéhe̱ chꞌán ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ntá tió kꞌuátòye̱ sín tí nta̱yaon, a̱ ntá kjuíji sín tí nonte Gadara. ");
INSERT INTO poeNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ntá kꞌuínkaji̱nxi̱n chꞌín Jesús tí ntabárco̱ a. Ntá xrína̱hya xeta chꞌán ijnko chꞌín kui̱xi̱n nó tsíkji̱xravá chojni mé chónta chꞌán ijnko ncha̱kuen tí jínahya. ");
INSERT INTO poeNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Tí chꞌín a mé kjuákꞌe chꞌán tí tsíkji̱xravá chojni. Ninkexró tjachahya sinchenteto chꞌán kjónté cadena tjachahya. ");
INSERT INTO poeNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Nchónhya veces kjuínchentetoxín sín chꞌán cadena to̱té chꞌán la ko itja chꞌán, la kjónté kóchríto̱n chꞌán kjuínchekuen chꞌán tí cadena. Kohya ninkexro tjacha tsꞌe̱tue̱nhen tí jehe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Kꞌuékꞌaji chꞌán ncha̱kotjin la ko tie tꞌíyato chꞌán nó jna̱ la ko tí tsíkji̱xravá chojni la ko chjéhe a̱sén chꞌán xro̱. ");
INSERT INTO poeNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Na ntá kꞌuíkon chꞌán kíxin kui chꞌín Jesús kjónté ikjín la kuinká chꞌán kjuíji chꞌán kjuákꞌexín tochꞌin chꞌán nkayakon chꞌín Jesús a ");
INSERT INTO poeNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","kꞌóyako chꞌán ntáchro chꞌán kíxin: ―¿Nkekuènté tji̱a̱té jaha tí jeheni, jaha Jesús Xje̱en Dios tjen nkaya nka̱jní? Dios nchenoheni kíxin xrja̱nóa̱ha nchekjasótehyani ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Mé xi̱kaha ichro chꞌán kíxin tsíntáchro chꞌín Jesús kíxin: ―Jaha ncha̱kuen tí jínahya, ti̱to̱hé tí chꞌín i ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ntá chꞌín Jesús mé kjuanchankíhi chꞌán tí chꞌín a kíxin: ―¿Nkexrí itꞌian? ―ichro chꞌán. Ntá kjuáte̱he chꞌán ntáchro chꞌán kíxin: ―Legión mé itꞌinni kíxin nchónhyani ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ntá imá chrónóe̱he̱ chꞌán tí chꞌín Jesús kíxin tsochrꞌánhya chꞌán ókjé tí ncha̱kuen tí jínahya. ");
INSERT INTO poeNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Na ntá siín nchónhya cochíno xrine va chjinaxón tí jna̱ ntiha. ");
INSERT INTO poeNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","A̱ ntá chrónòa̱ tí ncha̱kuen tí jínahya ntáchro kíxin: ―Tétue̱nhénni sátsjini tí siín tí cochíno, ti̱to̱hé tsꞌixenhenni tí jehe va ―ichro tí ncha̱kuen tí jínahya a. ");
INSERT INTO poeNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ntá chꞌín Jesús mé kjuanjon chꞌán kjuachaxin. Ntá kaín xín tí ncha̱kuen tí jínahya a mé kꞌuaxrjexín tí chꞌín a sákjui̱ kjui̱kꞌixenhen tí cochíno a. Na ntá kaín xín tí ko a mé chjina iyó mil va siín va xrine va. Na mé kaín xín va kꞌuínkaji̱nxi̱n va ntiha kjuítsínkayá va tsa̱ka ntá kjuítsínkankí va nta̱yaon ntá kjuínhin va nta̱. ");
INSERT INTO poeNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Na ntá tí chojni tꞌayakonhen tí cochíno a na mé kuinká sín kíxin chrakon sín na ntá sákjuí chrónka sín chjasén sín la ko no̱nte̱e chojni. Na ntá itsjé chojni mé kuitsjehe sín nkehe tí tsíkónhen ntiha. ");
INSERT INTO poeNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ntá kjuíji sín tí tjen chꞌín Jesús a na kꞌuíkon sín kíxin itjen tí chꞌín kꞌuéchónta tí nchónhya ncha̱kuen tí jínahya senó la ó jína tjen chꞌán tjetja̱xi̱n chꞌán tjenkáya chꞌán iké chꞌán, na ntá chrakon sín. ");
INSERT INTO poeNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","A̱ ntá tí sín tsíkꞌikon mé chrónka sín nkexrí kꞌuékꞌaji tí chꞌín kꞌuéchónta tí ncha̱kuen tí jínahya la ko nkexrí kónhen tí cochíno a. ");
INSERT INTO poeNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ntá kjuankíxin sín chrónóe̱he̱ sín tí chꞌín Jesús a kíxin sáchrókjuixin chꞌán ntiha. ");
INSERT INTO poeNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","A̱ ntá ó tsꞌi̱tꞌótjen chꞌín Jesús tí ntabárco̱ na ntá tí chꞌín kꞌuéchónta ncha̱kuen tí jínahya na mé chrónòa chꞌán kíxin kja̱xin chꞌán sáchrókjuiko sín chꞌán, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ntá chꞌín Jesús kjuanjonhya chꞌán kjuachaxin sátsjiko sín chꞌán. Náhí. Kꞌue̱to̱an chꞌán kíxin: ―Sátjia nto̱a tjíchenka tí sín na̱xa̱ kjéhya tí jaha kíxin nkexrí kaín tí kjuaxroan jié kjuasin Dios kjuínchekito̱ha jína kui̱konóa̱ha chꞌán tí jaha ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Na ntá tí chꞌín a sákjui̱ chꞌán kjuankíxin chrónka chꞌán kaín tí chjasin kuènte Decápolis kíxin nkexrí kaín tí nkehe kjuíchꞌe chꞌín Jesús kjuínchekito̱he chꞌán jína. A̱ ntá kaín tí sín kuínhin na chrakon sín. ");
INSERT INTO poeNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ntá tió xíkjanka̱o chꞌín Jesús tí ntabárco̱ tóhe tí nta̱yaon ínaá ntá kóchjina nchónhya chojni ntá ntahó chrínta nta̱ kuíto̱he chꞌán ínaá. ");
INSERT INTO poeNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Na ntá ikui ijnko chꞌín tꞌe̱to̱an kuènte ni̱nko mé itꞌin chꞌán Jairo. A̱ ntá tió kꞌuíkon chꞌán kíxin itjen chꞌín Jesús ntá kjuákꞌexín tochꞌin chꞌán chrínkí to̱té chꞌín Jesús a ");
INSERT INTO poeNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","imá chrónóe̱he̱ chꞌán kíxin: ―Tí ijnko xja̱nna chjin ó tjetꞌen xjan. Xrja̱nóa̱ha chrókjui̱ni chrókjuakꞌétja itjá chrítaón kja xjan ntá chrókuito̱he xjan jína ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ntá chꞌín Jesús sákjui̱ko tí chꞌín a. Na nchónhya chojni chréhe̱ sín tinkákꞌixitja sín chꞌán ínaá. ");
INSERT INTO poeNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","A̱ ntá kja̱xin tjenkákjan sín ijnko chojni chjin níhi tjan, ó chónta teyó nánó sítji tjan jni̱. ");
INSERT INTO poeNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Imá tjote tjan kíxin nchónhya chojni kjuanjon xro̱a̱n kónhen tjan na ó kjuixin kjuèhe tjan kaín xín nkehe kꞌuéchónta tjan. Ó jehí tito̱ehya tjan jína la íchá ntsí tinkákótao tjan. ");
INSERT INTO poeNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","A̱ ntá tió kuínhin tjan chrónka chojni nkehe tí kjuaxroan kjuasin chꞌín Jesús ntá kui tjan kjuákꞌenkákjan tí chojni kóchjina nóton chꞌín Jesús ntá kuákóxi̱n tjan tí ké chꞌán, ");
INSERT INTO poeNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ntáchro tjan kíxin kjónté iké chꞌán ó chrókuakóxi̱n tjan na ó tíhó mé chrókuito̱he tjan jína, ichro tjan. ");
INSERT INTO poeNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ntá tuénxín tí jni̱ na mé ó kjui̱xié tjan la ko kónohe tjan kíxin ó kjuixin kuíto̱he tjan jína ti chin kꞌuéchónta tjan. ");
INSERT INTO poeNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ntá chꞌín Jesús na ó kónohe chꞌán kíxin kjua̱cha̱xién chꞌán mé kuíto̱exín ijnko chojni jína ntá kuinkátjíá chꞌán kjuanchankíhi chꞌán tí chojni siín a kíxin: ―¿Nkexro kuákóxi̱n tí kaná? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ntá kjuáte̱he tí sín kꞌuajiko chꞌán a ntáchro sín kíxin: ―Ó noha kíxin nchónhya chojni sítja, ¿ntá nkekuènté kíxin na̱xa̱ tjanchankiá kíxin nkexro tí kuákóxian? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ntá kuinkátjíá chꞌán tsjehe chꞌán nkuíxín kíxin tso̱nohe chꞌán nkexro tí kuákóxi̱n tí ké chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ntá tí tjan a na mé chrakon tjan síxrànka̱ tjan ó nohe tjan kíxin ó kuíto̱he tjan jína ntá xrakoa tjan kjuákꞌexín tochꞌin tjan nkayakon chꞌín Jesús ntá ntoá chrónka tjan kaín nkehe kónhen tjan. ");
INSERT INTO poeNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ntá ntáchro chꞌín Jesús kíxin: ―Xje̱enni, kaín a̱sán kuinkachónkia tí janhan ntá kuíto̱ha jína. Ijie la kjuaxróxin sátsjia nto̱a la ó kuíto̱ha jína a ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Na ntá na̱xa̱ tjenixja chꞌán ntá ó kui chojni kui̱xi̱n sín nto̱e tí chꞌín tꞌe̱to̱an tí ni̱nko. Ntá chénka sín chꞌán kíxin: ―Xja̱an na ó kjuixin kꞌuén. ¿Nkekuènté na̱xa̱ chje̱hé xra̱ tí Maestro a? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ntá chꞌín Jesús na ánto̱sén chꞌán tí chrónka sín ntá nixje̱he̱ chꞌán tí chꞌín tꞌe̱to̱an tí ni̱nko ntáchro chꞌán kíxin: ―Chrakonhya jaha, jehó tsinkachónke tí janhan ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ntá kjuanjonhya chꞌán kjuachaxin kíxin sátsji kaín sín, na ó jehó chꞌín Pedro la ko chꞌín Jacobo la ko chꞌín Juan mé kíchó chꞌin Jacobo, sátsji sín. ");
INSERT INTO poeNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Na ntá tió kjuíji sín tí nto̱e tí chꞌín tꞌe̱to̱an tí ni̱nko na kꞌuíkon sín kíxin imá sítjité sín tsjánkàma̱ sín tí xjan a. ");
INSERT INTO poeNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ntá kꞌuíxenhen chꞌín Jesús nchia kjuanchankí chꞌán kíxin: ―¿Nkekuènté ánta tjasítérá tsja̱nkàma̱rá tí xjan a? Tí xjan na tsíkꞌenhya xjan na tjejua xjan ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","A̱ ntá kjuanoá sín chꞌán. Ntá kꞌue̱to̱an chꞌán kíxin kaín sín sátsji sín ntója. Ntá kjuíko chꞌán tí itꞌé la ko tí ìné xjan la ko tí iyꞌá sín xriko chꞌán ntá kꞌuíxenko sín chꞌán tí tjen tí xjan a. ");
INSERT INTO poeNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Itsé chꞌán tja xjan ntá nkíve̱e xjan mé nixje̱exín chꞌán ntáchro chꞌán kíxin: ―Talita, cumi ―mé tꞌaxrjexín kíxin: Lonchí, tétua̱nhan kíxin tꞌàya. ");
INSERT INTO poeNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","A̱ ntá tí xjan a ó chónta tjan teyó nánó na mé tuénxín kꞌuínkatjen tjan ó jína tji tjan. Ntá kaín tí chojni siín ntiha la chrakon sín kꞌuíkon sín xi̱kaha. ");
INSERT INTO poeNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ntá fuerte kꞌue̱to̱an chꞌín Jesús kíxin chróchenkahya sín ninkexró. La kja̱xin kꞌue̱to̱an chꞌán kíxin tsjanjon sín nkehe sine tjan. ");
INSERT INTO poeNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","A̱ ntá chrꞌéxi̱n kꞌuaxrjexín chꞌán chjasin ntiha. Ntá jehe chꞌán la ko tí sín kꞌuájiko chꞌán na mé sákjuí sín Nazaret tí chjasin tsíkꞌánkíxin chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Na ntá tió kui tí ya̱on tꞌo̱kꞌéhe sín ntá kjuankíxin chꞌán kjua̱ko̱xi̱n chꞌán tí ni̱nko ntiha. Na ntá nchónhya chojni kuínhin sín ntá chrakon sín ntáchro sín kíxin: ―¿Nketí tsíxrako̱he̱ tí chꞌín i kaín tíhi? ¿Nketí kui̱xi̱n tí kjuaxrexinkaon chónta chꞌán la ko tí kjuaxroan tjasin chꞌán? ");
INSERT INTO poeNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Á jehya chꞌán tí chꞌín chꞌéna nta na mé xje̱en tí tjan María, la tí kíchó chꞌán a na mé chꞌín Jacobo, la chꞌín José, la chꞌín Judas, la chꞌín Simón? ¿A̱ kja̱xinhya ntihi tjejókoni tí kíchó chꞌán chjin? ―ichro sín. Méxra̱ tahya sín kuentá nkerí chꞌe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Na ntá ntáchro chꞌín Jesús kíxin: ―Kaín chojni tjikosáyehe sín ijnko nkexro chrónka iten Dios. Ntá tí chjasén chꞌán la ko kaín tí sín kjéhya chꞌán la ko tí sín nto̱e chꞌán na mé tjikosáyehya sín chꞌán ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Méxra̱ ninkehó kjuaxroan xitjahya kjuasin chꞌán ntiha, la jehó kjuakꞌetja tja chꞌán chrítaón ikja iso chojni níhi kjuínchekito̱he chꞌán sín jína. ");
INSERT INTO poeNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ntá chrakon chꞌán kíxin xi̱kaha kuítekakuenhya sín chꞌán. Na ntá kꞌuáji chꞌán tí chjasin ntsíntsí chjinaxón ntiha kjuako chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Na ntá kꞌuíye̱he̱ chꞌín Jesús tí teyó sín kꞌuajiko chꞌán a. Ntá kjuankíxin kꞌue̱tue̱nhen chꞌán kíxin yóyó yóyó sín sátsji sín la ko kja̱xin kjuanjon chꞌán kjuachaxin kíxin tsakitsje sín ncha̱kuen tí jínahya chónta chojni. ");
INSERT INTO poeNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","La ko kꞌue̱to̱an chꞌán kíxin ninkehó tsjikohya sín kuènte nti̱a. Jehó tí nta tjixín sín mé tsjiko sín. Na mé tsjikohya sín kabolsa la ko tsjikohya sín nkehe sine sín la ko tsjikohya sín chichaon. ");
INSERT INTO poeNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Na ko to̱ka̱te̱ ó tsjanka sín la ko tsjiko sín jehó tí ka tjejóya sín ó. ");
INSERT INTO poeNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Kja̱xin ntáchro chꞌán kíxin: ―A̱ ntá tí tsꞌixe̱nhénrá ijnko nchia a̱ ntá ntaha tsjanjon sín kjuachaxin na ntahó chókuito̱hará. A̱ ntá tsjixinjian tí xra̱ ntá sátsjixinrá ntiha. ");
INSERT INTO poeNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Na ntá tí tsjasánrá ijnko chjasin ntá tsochrohya sín tsjanjon sín kjuachaxin tsꞌejókoará sín ntiha na ko tsotjinkakonhya sín tsinhin sín tí nkehe chrókjuákohérá sín na ntá tꞌaxrjéxi̱nrá tí chjasin a ntá tsꞌoxènjinrá tí nche chónta to̱tárá kíxin xi̱kaha tsjáko̱xi̱nrá kíxin ntoáhya kjuíchꞌe tí jehe sín. A̱ ntá chaxín ntáxrja̱n kíxin tí ya̱on tsito̱exín iji̱é chojni ntá a̱ntsí má tsjasóte tí chojni tí chjasin a, a̱ ntá tí sín chjasin Sodoma la ko Gomorra la kánhyó tsjasóte sín. ");
INSERT INTO poeNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Na ntá sákjuí sín kuinkákja̱ko̱he̱ sín tí chojni a kíxin mé chrókjuitóxi̱nhin sín nti̱e sín. ");
INSERT INTO poeNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","La ko kja̱xin kuakitsje sín itsjé tí ncha̱kuen tí jínahya chónta chojni. Na ko aceite mé kui̱ki̱te sín itsjé chojni níhi a la ntá kuíto̱he sín jína. ");
INSERT INTO poeNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Na ntá tí chꞌín rey Herodes mé kuínhin chꞌán nkehe tí kjuaxroan kjuasin chꞌín Jesús. Na ntáchro chꞌín Herodes kíxin: ―Kjá tí chꞌín Juan Bautista mé ó tsíxechón chꞌán ínaá kíxin xi̱kaha tí kjuachaxin chónta tí chꞌín a ―ichro chꞌín Herodes a. ");
INSERT INTO poeNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","A̱ ntá iso sín ntáchro sín kíxin: ―Kjá chꞌín Elías kꞌuéchrónka itén Dios ―ichro sín. A̱ ntá í so sín mé ntáchro sín kíxin: ―Kjá ijnko nkexro yóhe̱ tí sín kꞌuékjako itén Dios ósé ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ntá kuínhin chꞌín Herodes tíha ntá ntáchro chꞌán kíxin: ―Kjá ó jehe tí chꞌín Juan tí kuéto̱an chrínjin kja chꞌán, mé ó tsíxechón chꞌán jie ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Méxra̱ tí chꞌín Herodes mé tsíkꞌe̱to̱an chꞌán kíxin tso̱ntetoxín tí chꞌín Juan cadena tsjakꞌechjina chꞌán kíxin xi̱kaha tsíkjanchia tí tjan Herodías. A̱ ntá tí tjan Herodías kꞌuéchjién tí chꞌín Felipe. A̱ ntá tí sa̱vé chꞌán Herodes mé kuákja tí tjan a kíxin tsꞌóna ichjién chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","A̱ ntá tí chꞌín Juan tsíntáche chꞌán tí chꞌín Herodes kíxin: ―Kohya kjuachaxin tsochonta tí ichjién tí kíchuá ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Mé xi̱kaha tí tjan Herodías mé imá kónínkakonhen tjan tí chꞌín Juan ntá chrókꞌóyán tjan chꞌán, kjánchó xitjahya ");
INSERT INTO poeNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","kíxin tí chꞌín Herodes mé chrako̱nhe̱n chꞌán tí chꞌín Juan kíxin ó nohe chꞌán kíxin tí chꞌín a mé ijnko nkexro jína la ko tjóá a̱sén la méxra̱ kuíto̱ehya chꞌán kíxin jehe tjan chrókꞌóyán tjan chꞌán. A̱ ntá kénhyó kienxín chꞌán la kjónté kóxrjínhi̱n chꞌán tí nkehe kuínhin chꞌán kjuako chꞌín Juan. ");
INSERT INTO poeNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","A̱ ntá tí tjan Herodías mé kjuacha tjan tí ya̱on kia tsíkjitoxi̱nhin nánó tí chꞌín Herodes a kíxin tsíkꞌíye̱he̱ chꞌán tí síxre̱é la ko tí sín kꞌue̱tue̱nhen tí sín soldado la ko tí sín tꞌe̱to̱an estado Galilea kíxin itsi sín nto̱e chꞌán kíxin siín kia. ");
INSERT INTO poeNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","A̱ ntá tí xje̱en tí tjan Herodías mé kꞌuíxenhen tí tjejó sín, a̱ ntá ité tjan, la kóxrjínhi̱n chꞌin Herodes la ko kaín tí sín tjejóneko chꞌán ntiha. Na ntá tí chꞌín rey ntáche chꞌán tí tjan tjarisoá a kíxin: ―Tjanchana tí nkehe tjinkávan na tso̱tja̱há ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ntá kjuínchenohe chꞌán Dios ntáchro chꞌán kíxin tsjanjon chꞌán tí nkehe tsjanchia tjan kjónté jnko̱siné tí chjasin tꞌe̱to̱an chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ntá jehe tjan na mé kuínhin tjan ntá sákjuí tjan chénka tjan ìné tjan kíxin tsíntáchro chꞌín Herodes kíxin tí ichrén nkehe chrókjuanchia tjan chrókjuanjon chꞌán. Ntá kjuanchankí tjan kíxin: ―¿Nkehe tí chrókjuanchiani? ―ichro tjan. Ntá tí ìné tjan mé ntáchro kíxin: ―Ijie la itjia tjanchia tí kja tí chꞌín Juan Bautista, ichrua ―ichro tjan. ");
INSERT INTO poeNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","A̱ ntá tí tjarisoá ikjan tjan tjoka kꞌuíxenhen tjan tí tjen tí chꞌín rey, ntá ntáchro tjan kíxin: ―A̱ ntá ijie tjinkaonni ijnko plato tsjakꞌenkáya ikja chꞌín Juan Bautista tsochje̱héni ―ichro tjan. ");
INSERT INTO poeNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Na ntá tí chꞌín rey la mé imá kꞌuává chꞌán kíxin xi̱kaha kjuanchia tjan kjánchó tsíkjinchenohe chꞌán Dios la ko tsíkinhin kaín tí sín tsíkꞌíye̱he̱ chꞌán, la ntá xitjahya tsontáchro chꞌán “Náhí” tí nkehe kjuanchia tjan. ");
INSERT INTO poeNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Na ntá tuénxín kꞌue̱tue̱nhen chꞌán ijnko chꞌín soldado kíxin tsji̱ka̱o chꞌán tí kja chꞌín Juan a. ");
INSERT INTO poeNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ntá tí chꞌín soldado mé sákjuí nto̱echiso, ntá kóchrínjin chꞌán ikja tí chꞌín Juan a. Ntá ijnko plato kjui̱koyá chꞌán tí kja chꞌán a ntá chjéhe chꞌán tí tjan tjarisoá a. Ntá jehe tjan sákjuíkénhen tjan ìné tjan. ");
INSERT INTO poeNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Na ntá kuínhin kaín tí sín kꞌuékꞌajiko chꞌín Juan kíxin xi̱kaha tsíkónhen. Na ntá sákjuíkakja sín tí cuérpo̱e chꞌán ntá kjui̱ka̱o sín ntá sákjuíkjává sín. ");
INSERT INTO poeNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","A̱ ntá chrꞌéxi̱n tí sín kꞌuájiko chꞌín Jesús a na mé ó kjan sín tí tjen chꞌán ínaá, chrónka sín nkexrí tí xra̱ kjuíchꞌe sín na ko nkexrí kjuako sín. ");
INSERT INTO poeNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","A̱ ntá ntáchro chꞌín Jesús kíxin: ―Tsꞌaxrjentani sátsjini nte̱je̱ tí kohya chojni ntá tsꞌo̱kꞌáhará ntsí ―ichro chꞌán. Mé xi̱kaha ntáchro chꞌán kíxin sásítji̱ la ko síti nchónhya chojni na ntá xrankahya tsꞌejó sín sine sín. ");
INSERT INTO poeNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Na ntá chꞌín Jesús la ko tí sín kꞌuájiko chꞌán jehó sín kꞌui̱tꞌótjen sín ijnko ntabárco̱ sákjuí sín ijnko nonte jehó tjen. ");
INSERT INTO poeNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Na ntá itsjé chojni kꞌuíkon sín kíxin sákjuí sín la ko kjuátso̱an sín kíxin chꞌín Jesús. Ntá xrákua̱xi̱n sín chjasén sín kuinká sín na ntá senó kjuíji sín tí chrínta nta̱yaon tí tsjiji chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ntá kꞌuínkaji̱nxi̱n chꞌán tí ntabárco̱, a̱ ntá kꞌuíkon chꞌán kíxin nchónhya chojni siín ntiha ntá kui̱konóe̱he̱ chꞌán tí jehe sín na mé éxí yóhe̱ kolélo tjejó sín chóntahya va nkexro tsꞌayakonhen va. Ntá kjuankíxin chꞌán kjua̱ko̱he̱ chꞌán sín nchónhya nkehe a. ");
INSERT INTO poeNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Na ntá ó kóntó na ntá tí sín kꞌuájiko chꞌín Jesús a mé kóchjina sín tí tjen chꞌán ntáchro sín kíxin: ―Ntá ó kóntó la kohya ninkexró tjejó ntihi ");
INSERT INTO poeNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","na ntá jaha chrókui̱to̱hé sín kíxin sátsji sín tí chjasin chjinaxón a tsjikꞌe̱na sín nkehe kíxin chóntahya sín nkehe sine sín ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","A̱ ntá chꞌín Jesús kjuáte̱he chꞌán ntáchro chꞌán kíxin: ―Chje̱hé sín nkehe sine sín ―ichro chꞌán. Ntá kjuáte̱he sín ntáchro sín kíxin: ―¿Á tsjikꞌe̱nani iyó ciento denario nio̱tja̱ tsochjéheni sin sine sín ní? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ntá chꞌín Jesús mé kjuanchankíhi chꞌán sín kíxin: ―¿Nkekja̱ín nio̱tja̱ chontará? Sátjítsjehérá ―ichro chꞌán. Ntá sákjuítsjehe sín na ntá chrónka sín kíxin: ―Inꞌó nio̱tja̱ la ko yaá koche mé siín ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Na ntá kꞌue̱to̱an chꞌán kíxin kaín xín sín chrókꞌuixitja̱xi̱n sín tí chrítaón tí ka yoa a. ");
INSERT INTO poeNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Na ntá xi̱kaha kójnkojié sín ciento sín la ko cincuenta sín kꞌuíxitja̱xi̱n sín. ");
INSERT INTO poeNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Na ntá chꞌín Jesús kuákja chꞌán tí inꞌó nio̱tja̱ na ko tí yaá koche ntá konta chꞌán nka̱jní ntá kjuanchia chꞌán kjuasáyé Dios. Na ntá kóchrítꞌo̱ chꞌán to̱tꞌo̱ tí nio̱tja̱ a ntá chjéhe chꞌán tí sín kꞌuájiko chꞌán kíxin tsꞌóxika̱ye̱he sín sine tí sín siín a la ko kja̱xin kóchrítꞌo̱ chꞌán tí yaá koche ntá kꞌóxika̱ye̱he sín kíxin sine sín kaín sín. ");
INSERT INTO poeNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ntá kaín xín sín kjóne sín kókje̱he sín. ");
INSERT INTO poeNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","A̱ ntá kjuixin kjóne sín ntá tí sín kꞌuájiko chꞌín Jesús na mé kjuínchekaón sín teyó ntaxra to̱tꞌo̱ tí nio̱tja̱ la ko tí koche tsíxehe̱. ");
INSERT INTO poeNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","A̱ ntá tí sín kjóne na mé inꞌó mil chojni ntoa. ");
INSERT INTO poeNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","A̱ ntá tuénxín kꞌue̱tue̱nhen chꞌín Jesús tí sín kꞌuájiko chꞌán kíxin tsꞌi̱tꞌótjen sín tí ntabárco̱ a tsꞌatòye̱ sín nta̱yaon sátsji sín nó chjasin Betsaida, ichro chꞌán. Na ntá jehe chꞌán na mé na̱xa̱ kuíto̱he chꞌán nixje̱he̱ chꞌán kaín tí sín siín a. ");
INSERT INTO poeNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kjuixin nixje̱he̱ chꞌán sín na ntá jehe chꞌán chrìin chꞌán ijnko jna̱ tsonixje̱exín chꞌán Dios. ");
INSERT INTO poeNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","A̱ ntá tió kꞌuíxin tie ntá tí ntabárco̱ na mé ó kjuíji jnko̱siné nta̱yaon, a̱ ntá jehe chꞌán jehó chꞌán kjuíji chꞌán chrínta nta̱yaon. ");
INSERT INTO poeNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ntá kotohe̱ chꞌán kꞌuíkon chꞌán kíxin imá xra̱ tjiko sín tí ntabárco̱ a kíxin tí xri̱nto̱ imá chjéhe. Nantóye a mé sákjuíchréhe̱ chꞌán sín. To̱tó chꞌán mé sákjuítónxin chꞌán tí nta̱yaon na ntá kóchjinehe chꞌán tí tjejó sín chrókꞌuátsínké chꞌán sáchrókjui chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","A̱ ntá tí kꞌuíkon sín kjuítaón chꞌán nta̱, ntá kjuenka̱yáxin sín kíxin kjuacha sín, ichro sín, ntá kꞌóyako sín ");
INSERT INTO poeNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","kíxin kaín sín kꞌuíkon sín chꞌán la chrakon sín. Na ntá jehe chꞌán mé tuénxín nixja chꞌán ntáchro chꞌán kíxin: ―Chrakonhyará. Janhan tíhi ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ntá kꞌui̱tꞌótjen chꞌán tí ntabárco̱ tí tjejó sín, a̱ ntá tí xri̱nto̱ la ó kꞌuíxratá. Ntá imá chrakon sín kíxin xi̱kaha kónhen ");
INSERT INTO poeNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","kíxin kienxínhya sín tí kjuaxroan kjuíchꞌe chꞌán kuènte tí nio̱tja̱ kíxin na̱xa̱ kénhya a̱sén sín kuinkáchónki sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ntá tió kꞌuátòye̱ sín tí nta̱yaon ntá kjuíji sín tí nonte Genesaret ntá kjua̱kꞌe̱chro̱e sín tí ntabárco̱ a tí chrínta nta̱. ");
INSERT INTO poeNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Na ntá tió kꞌuínkaji̱nxi̱n sín tí ntabárco̱, a̱ ntá tí sín siín ntiha tjoka kjuátso̱an sín tí chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ntá sákjuí sín nkuíxín chjinaxón ntiha kjuankíxin sín kui̱ka̱o sín tí si̱nníhi tinkátsénkí sín kui̱ka̱o sín tí tjen chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","La ko kaín nketí kjuíji chꞌán, á chjasin ntsí, á chjasin hyé, á no̱nte̱e sín ó kjuíjiko sín tí si̱nníhi a chrínta nti̱a. Na ntá chrónóe̱he̱ sín tí chꞌín Jesús kíxin kjónté chrínta iké chꞌán ó chrókuákóxi̱n sín, ichro sín. Na kaín xín tí sín kuákóxi̱n iké chꞌán mé kuíto̱he sín jína. ");
INSERT INTO poeNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","A̱ ntá iso sín fariseo la ko iso tí sín tjako tí ley kui̱xi̱n sín chjasin Jerusalén ntá kóchjinehe sín tí chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Tí sín a, tió kꞌuíkon sín kíxin iso tí sín kꞌuájiko chꞌín Jesús mé kꞌóntihya sín tja sín na kjónté ine sín mé tꞌaxrjexín kíxin kjuínchexiteyáhya sín tí ley, ntá kjonta tí sín a. ");
INSERT INTO poeNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Mé xi̱kaha kjuíchꞌe sín kíxin tí sín fariseo la ko kaín tí sín judío mé kuinkáchónki sín éxí kꞌuékjichꞌe tí sín táda ósé kíxin ná tꞌòntó itja sín ntá sine sín. ");
INSERT INTO poeNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Na ko tí tso̱kja̱nxi̱n sín ntasin ná tꞌónti sín ntá sine sín. Na ko kja̱xin itsjé í so nkehe tinkáchónki sín, éxí tjo̱ne̱má sín tí vaso tꞌiyá sín nkehe la ko tí nchésen la ko tí chi̱ chjányan nkehe ne sín la ko tí kàmé sín nchetjóá sín.) ");
INSERT INTO poeNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Méxra̱ tí sín fariseo la ko tí sín maestro tjako tí ley a na mé kjuanchankíhi sín tí chꞌín Jesús kíxin: ―¿Nkekuènté kíxin tí sín xrikoa la nchexiteyáhya sín tí nkehe kꞌuékinkáchónki tí sín táda kꞌuéjó ósé? Na mé tí sín xrikoa tꞌóntihya sín tja sín ntá kjónté ine sín ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Ntoá tsíchrónka chꞌín Isaías ósé kꞌuéchrónka iten Dios tsíntáchro chꞌán kíxin ntoáhya tsjenka̱yáxinrá tí jahará kíxin xi̱kihi tsíkjin chꞌán ntáchro chꞌán kíxin: Tí chojni tí chjasin i irꞌva ó xraxinkakonxín sín tí janhan, a̱ ntá tí a̱sén sín ikjín kuíto̱he sín tí janhan ");
INSERT INTO poeNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Méxra̱ ó chónkó tóchjina sín xraxinkaon sín tí janhan, kíxin tí nkehe tjako sín la tí nkehe tsíkꞌe̱to̱an chojni ó. Mé xi̱kaha ichro itén Dios. ");
INSERT INTO poeNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ntá jahará kui̱to̱hérá tí nkehe tsíkꞌe̱to̱an Dios ntá chréhérá tí nkehe chꞌe chojni, a la mé tjo̱ne̱márá nchésen, la ko tí vaso tꞌiárá nkehe, la ko kja̱xin í so nkehe yóhe̱ tinkachónkirá ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Kja̱xin ntáchro chꞌán kíxin: ―Jahará chréhérá tí nkehe kꞌuékjichꞌe chojni ntá xi̱kaha ti̱to̱hérá ntáha tí nkehe tsíkꞌe̱to̱an Dios. ");
INSERT INTO poeNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Tsíntáchro chꞌín Moisés kíxin: “Tsochonteherá kjuasáyé itꞌárá la ko ìnárá”, la ko “A̱ ntá tí nkexro tꞌántaxínhi̱n itꞌé o̱ ìné la chrókꞌóyán sín.” ");
INSERT INTO poeNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","A̱ ntá jahará ntáchrorá kíxin ó ncho̱xon kíxin ijnko nkexro tsochénka itꞌé la ko ìné kíxin: “Itꞌéni, Ìnéni, chrokjuahya tsjinki̱tsani tí jaha kíxin kaín tí nkehe chóntani mé kꞌóna Corbán” (mé tꞌaxrjexín kíxin kaín tí chichaon kꞌuáyéhe̱ Dios). ");
INSERT INTO poeNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","A̱ ntá xi̱kaha jnkojín nkexro tsontáchro chꞌán tíhi ntá jahará tsontáchrorá kíxin í tꞌichjánxi̱nhya tsjinki̱tsa chꞌán tí itꞌé chꞌán la ko tí ìné chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","A̱ ntá tí xi̱kaha la ti̱to̱hérá tí nkehe tsíkꞌe̱to̱an Dios éxí sínkíhya, a̱ ntá ókjé nkehe ichꞌerá, ntá tánkíhará chojni. Mé xi̱kaha ichꞌerá nchónhya nkehe tóyóhe̱ tíha ―ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Na ntá kꞌuíye̱he̱ chꞌín Jesús tí chojni ínaá ntáchro chꞌán kíxin: ―Tinhínrá kaín rá tí nkehe ntáxrja̱n la ko tiénxinrá. ");
INSERT INTO poeNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Tí nkehe ine chojni la jehya jie̱ tíha. Tí nkehe tꞌaxrjeníxin a̱sén chojni mé jie̱ tíha. ");
INSERT INTO poeNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Tí tjinkáonrá chrókuinhínrá la chrókuinhínrá ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","A ntá tió kuíto̱he chꞌán kaín tí sín tsíkóchjina a na ntá jehe chꞌán la ko tí sín kꞌuájiko chꞌán mé kꞌuíxenhen sín nchia. Na ntá kjuanchankíhi sín chꞌán kíxin nkexrí tꞌaxrjexín tí nkehe kjuako chꞌán a. ");
INSERT INTO poeNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Na ntá ntáchro chꞌín Jesús kíxin: ―¿Á kja̱xinrá tiénxinhyará? ¿Á noahyará kíxin tí nkehe ineni na jehya jie̱ ");
INSERT INTO poeNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","kíxin jehya a̱sénni sátsji? Tí nkehe ineni na sátji nkaya tse̱eni na ko xikꞌaxrje ínaá ―ichro chꞌán. Mé tꞌaxrjexín kíxin tí nkehe sineni la jehya jie̱. ");
INSERT INTO poeNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ntá ntáchro chꞌín Jesús kíxin: ―A̱ ntá tí nkehe tꞌaxrjeníxin chojni na mé jie̱ táha. ");
INSERT INTO poeNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Nkaya a̱sánrá mé tꞌaxrjeníxin tí jínahya tjenka̱yáxinrá, la ko tí tja̱che̱he̱ kíchuárá, la ko tí tjinkáonrá tsochontará chojni chjin ókjé, la ko tí tꞌoyán kíchuárá ");
INSERT INTO poeNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","la ko tí chrókue̱erá, la ko tí tjaké a̱sánrá tí nkehe chónta ókjé sín, la ko tí jínahya chꞌehérá kíchuárá, la ko tí kjuachꞌia xríkoará la ko tí jínahya tjenka̱yáxinrá, la ko tí chji̱no̱xínhanrá, la ko tí chꞌénará kjuachꞌia, la ko tí kjuahnke chontará, na kó ti chontahyará kjuaxrexinkaon jína. ");
INSERT INTO poeNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Kaín tí nkehe jínahya a mé tꞌaxrjeníxin chojni, la mé tjasixín sín jie̱. ");
INSERT INTO poeNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ntá chꞌín Jesús mé sákjuíxin chꞌán ntiha ntá sákjuí chꞌán nó chjasin Tiro la ko chjasin Sidón. Ntá kꞌuíxenhen chꞌán ijnko nchia kíxin tjinkakonhya chꞌán kíxin chrókónohe chojni kíxin ntaha tjen chꞌán. Kjánchó xitjahya kjuákꞌemá chꞌán ntiha. ");
INSERT INTO poeNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Na ntá ijnko ìné ijnko tjan tjarisoá chónta ijnko ncha̱kuen tí jínahya mé kuínhin nkehe tí xra̱ chꞌe chꞌín Jesús kíxin tjasin chꞌán kjuaxroan, ntá tuénxín kui tjan kjuákꞌexín tochꞌin tjan chrínkí to̱té chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Na mé jehe tjan tsíkji̱xi̱n kjín, na mé tsíkji̱xi̱n tjan nó nación Sirofenicia. Na ntá jehe tjan a mé kui tjan chrónóe̱he̱ tjan tí chꞌín Jesús kíxin chrókuakitsje chꞌán tí ncha̱kuen tí jínahya chónta xje̱en tjan. ");
INSERT INTO poeNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ntá ntáchro chꞌín Jesús kjuáte̱he chꞌán kíxin: ―Ti̱to̱hé senó chrókjóne tí xjan. Jehya tí jína chrókuakítsja̱ha̱ xjan tí nio̱tja̱ ntá chrótja̱ha̱ koni̱a̱ chrókjóne va ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ntá jehe tjan kjuáte̱he tjan ntáchro tjan kíxin: ―Chaxín xi̱kaha, Ìnchéni. Kjánchó kjónté tí koni̱a̱ tjejoyánkí mesa ine tí to̱tꞌo̱ nio̱tja̱ tóxènjin tí chánjan ―ichro tjan. ");
INSERT INTO poeNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Na ntá ntáchro chꞌín Jesús kíxin: ―Táha la chaxín ntoá ntáchrua. Sátjia kíxin tí ncha̱kuen tí jínahya ó kꞌuaxrjexín tí xja̱an ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","A̱ ntá tió kjuíji tjan nto̱e tjan, na ntá kꞌuíkon tjan kíxin tí xje̱en tjan na mé ó ntoá tjetsínkatákꞌá xjan tí cama kíxin ó tsíkꞌaxrje tí ncha̱kuen tí jínahya a. ");
INSERT INTO poeNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ntá chꞌín Jesús mé ó kꞌuaxrjexín chꞌán ínaá nó chjasin Tiro ntá kꞌuátsínka chꞌán chjasin Sidón la ko kꞌuátsínka chꞌán tí estado Decápolis ntá kjuíji chꞌán nó nta̱yaon Galilea. ");
INSERT INTO poeNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ntá kui̱ka̱o sín ijnko chꞌín tienhya na ko ntoáhya nixja chꞌán. Ntá chrónóe̱he̱ sín tí chꞌín Jesús a kíxin tsjakꞌetja tja chꞌán chrítaón kja tí chꞌín a kíxin tsito̱he chꞌán jína. ");
INSERT INTO poeNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Na ntá chꞌín Jesús kꞌuaxrjentako chꞌán tí chꞌín tienhya, kꞌuaxrjenta sín tí kohya chojni. Na ntá tí dedo tja chꞌán mé chrꞌáxenhen chꞌín Jesús ta̱tsjon tí chꞌín tienhya. La ko kja̱xin tí dedo tja chꞌán mé kui̱ki̱te chꞌán nta̱té chꞌán ntá kjuínchekákóxi̱n chꞌán nejen tí chꞌín nixjahya a. ");
INSERT INTO poeNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ntá konta chꞌán nka̱jní kꞌuáváxin chꞌán na ntá nixje̱he̱ chꞌán tí chꞌín tienhya a, ntáchro chꞌán kíxin: ―Efata ―mé tꞌaxrjexín nkíve̱e sín kíxin: ¡Tsoxitje̱he̱! ");
INSERT INTO poeNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Na ntá tuénxín xítje̱he̱ ta̱tsjon tí chꞌín tienhya ntá kuínhin chꞌán la ko kuíto̱he jína tí nejen chꞌán, ntá jína nixja chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ntá chꞌín Jesús kꞌue̱to̱an chꞌán kíxin ninkexró tsochenkahya sín. Ntá kjónté imá kꞌue̱to̱an chꞌán ntá ánto̱sén sín kjónté íchá xrichronka sín. ");
INSERT INTO poeNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Na mé imá chrakon sín ntá ntáchro sín kíxin: ―Kaín nkehe chꞌe chꞌán la jína. Tí chojni tienhya la tinhin sín la ko tí chojni nixjahya la nixja sín ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","A̱ ntá ijnko ya̱on nchónhya chojni kꞌuíxikóchjina ínaá. A̱ ntá chóntahya sín nkehe sine sín. Na ntá chꞌín Jesús mé kꞌuíye̱he̱ chꞌán tí sín kꞌuájiko chꞌán, a̱ ntá ntáchro chꞌán kíxin: ");
INSERT INTO poeNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Imá ti̱konóa̱ha̱ kaín tí sín i kíxin ó ní ya̱on tjéki̱an sín ntihi ntá chóntahya sín nkehe sine sín. ");
INSERT INTO poeNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ntá chrókuétua̱nhya sín sáchrókjui sín nto̱e sín tí na̱xa̱ nehya sín kíxin nti̱a ó chrókótie̱nxin sín kíxin iso sín la imá kjín tsíkji̱xi̱n sín ―ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Na ntá kjuáte̱he tí sín kꞌuájiko chꞌán ntáchro sín kíxin: ―¿Nkexrí chrókónoxín nchónhya nio̱tja̱ chrókjóne kaín tí sín a kíxin kohya nchia tí tjejóni? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Na ntá ntáchro chꞌín Jesús kíxin: ―¿Nkekja̱ín nio̱tja̱ chontará jahará? ―ichro chꞌán. Ntá jehe sín kjuáte̱he sín ntáchro sín kíxin: ―Yato nio̱tja̱ chóntani ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Na ntá chꞌín Jesús kꞌue̱tue̱nhen chꞌán kaín xín sín kíxin tsꞌixitja̱xi̱n sín nonte. Ntá kuákja chꞌán tí yato nio̱tja̱ ntá kjuanchehe chꞌán kjuasáyé Dios ntá kóchrítꞌo̱ chꞌán tí nio̱tja̱ a. Ntá chjéhe chꞌán tí sín kꞌuájiko chꞌán kíxin jehe sín tsꞌóxíka̱ye̱he sín tsakja kaín xín tí sín siín a. ");
INSERT INTO poeNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Na ko iso koche ntsíntsí chónta sín. Ntá chꞌín Jesús kjuanchia chꞌán kjuasáya ntá kꞌue̱to̱an chꞌán tsꞌóxíka̱ye̱he sín kja̱xin. ");
INSERT INTO poeNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Na mé kaín xín sín kjóne sín na kókje̱he sín. Ntá chrꞌéxi̱n na̱xa̱ kjuínchekaon sín yato ntaxra tí to̱tꞌo̱ tí nkehe tsíxehe̱. ");
INSERT INTO poeNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Na mé chjina noó mil chojni kjóne sín. Ntá chꞌín Jesús mé nixje̱he̱ chꞌán sín sákjuí sín ");
INSERT INTO poeNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ntá tuénxín jehe chꞌán la ko tí sín kꞌuájiko chꞌán na mé kꞌui̱tꞌótjen sín tí ntabárco̱ a sákjuí sín nó tí nonte Dalmanuta. ");
INSERT INTO poeNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Na ntá kui iso sín fariseo kjuankíxin sín tjo sín tí chꞌín Jesús kjuanchehe sín chꞌán kíxin chrókjua̱ko̱xi̱n chꞌán ijnko kjuaxroan jié kuènte nkaya nka̱jní kíxin tjinkaon sín chrókjua̱cha̱xi̱n sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","A̱ ntá chꞌín Jesús na mé kꞌuáváxin chꞌán ikjín kja̱nxi̱n a̱sén chꞌán ntá ntáchro chꞌán kíxin: ―¿Nkekuènté kíxin tí chojni i na mé tjanchia sín ijnko kjuaxroan jié? Ijie la ninkehó kjuaxroan tsjáko̱xi̱nhya ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Na ntá kuíto̱he chꞌán tí sín a, ntá xíkꞌi̱tꞌótjen chꞌán tí ntabárco̱ ntá sákjuí chꞌán í jnko tóhe nta̱yaon ínaá. ");
INSERT INTO poeNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ntá kꞌuitjáyenhen sín tsíkjikohya sín nkehe sine sín. Jehó jnkoko̱á nio̱tja̱ chónta sín nkaxenhen tí ntabárco̱ a. ");
INSERT INTO poeNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ntá chꞌín Jesús kꞌue̱tue̱nhen chꞌán tí jehe sín kíxin: ―Chrókóxakonhanrá kíxin tí xro̱a̱n nchekꞌánkí nio̱tjé tí sín fariseo la ko nio̱tjé tí chꞌín Herodes a ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ntá tí sín xriko chꞌán mé kjo sín kíchó sín kíxin: ―Mé xi̱kaha ichro chꞌán kíxin tsíkjikohyani nio̱tja̱. ");
INSERT INTO poeNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ntá kónohe chꞌín Jesús kíxin nkehe tí kjo sín kíchó sín ntá ntáchro chꞌán kíxin: ―¿Nkekuènté tjórá kíxin chontahyará nio̱tja̱? ¿Á na̱xa̱ tiénxinhyará la ko na̱xa̱ noahyará? ¿Á kénhya a̱sánrá tinkachónkirá Dios? ");
INSERT INTO poeNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Á tꞌikonxinhyará ikonrá la ko á tiénxinhyará tátsjinrá? ¿Á xráxinkákonhyará? ");
INSERT INTO poeNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Tió kóchrítꞌva̱ tí nꞌó nio̱tja̱ kjóne inꞌó mil chojni na ¿nkekja̱ín ntaxra tí to̱tꞌo̱ nio̱tja̱ na̱xa̱ kjuenájinrá? ―ichro chꞌán. Ntá jehe sín kjuáte̱he sín ntáchro sín kíxin: ―Teyó ntaxra tí nkehe kjuenájinni ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Xíntáchro chꞌín Jesús ínaá kíxin: ―Na ko tí kóchrítꞌva̱ tí yato nio̱tja̱ kjóne noó mil chojni na ¿nkekja̱ín ntaxra tí to̱tꞌo̱ nio̱tja̱ kjuenájinrá? ―ichro chꞌín Jesús. Ntá ntáchro sín kíxin: ―Yato ntaxra ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ntá chꞌín Jesús ntáchro chꞌán kíxin: ―Kjónté xi̱kaha la, ¿á na̱xa̱ tiénxinhyará? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","A̱ ntá chrꞌéxi̱n kjuíji sín chjasin Betsaida, a̱ ntá ikui iso sín kui̱ka̱o ijnko chꞌín tꞌikonhya. Ntá chrónóe̱he̱ sín tí chꞌín Jesús kíxin chrókjuinchekito̱he chꞌán jína tí chꞌín a. ");
INSERT INTO poeNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ntá chꞌín Jesús mé itsé chꞌán tja tí chꞌín tꞌikonhya a ntá kꞌuaxrjentako chꞌán ikon tí chjasin a. Na ntá kui̱ki̱tehe chꞌán nta̱té chꞌán ikon tí chꞌín tꞌikonhya a la ko kjuakꞌetja tja chꞌán ntá kjuanchankíhi chꞌán kíxin: ―¿Á ó tꞌikuan ntsí? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ntá ntáchro tí chꞌín tꞌikonhya kíxin: ―Tꞌikonni chojni, kjánchó éxí nta tsjehe itji ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ntá chꞌín Jesús mé xíkjakꞌetja tja chꞌán ínaá tí kon tí chꞌín tꞌikonhya a. A̱ ntá tí chꞌín kꞌuíkonhya kuíto̱he chꞌán jína la jína tꞌikon chꞌán kaín nkehe. ");
INSERT INTO poeNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Na ntá chꞌín Jesús mé kꞌue̱tue̱nhen chꞌán tí chꞌín kꞌuékꞌikonhya kíxin sátsji chꞌán nto̱e chꞌán ntáchro chꞌán kíxin: ―Chrókꞌuíxe̱nhya chjasin la ko ninkexró chróchenkahya ntiha ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","A̱ ntá tí chꞌín Jesús la ko tí sín kꞌuájiko chꞌán sákjuí sín tí chjasin ntsí chjino Cesarea de Filipo. A̱ ntá tí nti̱a mé kjuanchankíhi chꞌín Jesús tí sín kꞌuájiko chꞌán kíxin: ―¿Nkehe ntáchro chojni kíxin nkexro tí janhan? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ntá ntáchro sín kíxin: ―Iso sín mé ntáchro sín kíxin jaha mé chꞌín Juan Bautista, ichro sín. A̱ ntá í so sín na mé ntáchro sín kíxin jaha mé chꞌín Elías, ichro sín. A̱ ntá í so sín mé ntáchro sín kíxin jaha mé ijnko tí sín tsíchrónka itén Dios ósé ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ntá kjuanchankíhi chꞌán sín ínaá kíxin: ―¿A̱ ntá jahará nkechrorá kíxin nkexro tí janhan? ―ichro chꞌán. Ntá kjuáte̱he chꞌín Pedro ntáchro chꞌán kíxin: ―Jaha mé tí Cristo, ichroni ―mé chro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ntá kꞌue̱to̱an chꞌín Jesús kíxin tsochenkahya sín ninkexró. ");
INSERT INTO poeNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Na ntá kjuankíxin kjuako chꞌín Jesús kíxin tí Xje̱en Dios Kꞌóna Chojni mé tꞌichjánxi̱n kíxin imá tsjasóte chꞌán la ko tsotjinkakonhya kaín tí sín táda kuènte ni̱nko la ko tí sín tꞌe̱to̱an kuènte tí sín ncha̱tꞌá la ko tí sín maestro tjako tí ley. A̱ ntá tí sín a mé tsꞌóyán sín chꞌán. Kjánchó tí níxin ya̱on na ó tsoxechón chꞌán ínaá. ");
INSERT INTO poeNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Kaín tíha mé ntoá chrónka chꞌán. A̱ ntá chꞌín Pedro mé kuakitsjenta chꞌán tí chꞌín Jesús chrókjuentuéhe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Na ntá kuinkátjíá chꞌín Jesús komá chꞌán kaín tí sín kꞌuájiko chꞌán a. Ntá kjuentuéhe chꞌán tí chꞌín Pedro a ntáchro chꞌán kíxin: ―¡Sátjia ntáha, Satanás! Jaha la tjenka̱yáxinhya éxí tjenka̱yáxin Dios. Náhí. Jaha tjenka̱yáxian éxí tjenka̱yáxin chojni ó ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ntá chꞌín Jesús mé kꞌuíye̱he̱ chꞌán tí sín kꞌuájiko chꞌán la ko tí sín tsíkóchjina a. Ntá ntáchro chꞌán kíxin: ―Tí jnkojínrá tjinkáonrá tsochréhérá tí janhan na tꞌichjánxi̱n tsi̱to̱hérá kaín tí nkehe tjaké a̱sanrá na ntá tsamárá tí ntacruz kuèntárá, a̱ ntá tsochréhérá tí janhan. ");
INSERT INTO poeNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","A̱ ntá tí nkexro tjinkaon jehó sinchekaá a̱sén mé tsꞌitjáyan. A̱ ntá tí nkexro sinchekꞌitjáyanxín a̱sén kíxin tinkáchónki tí janhan la ko chrónkaxín tí tan tsjanjon kjuachón mé tsaá. ");
INSERT INTO poeNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿A̱ ntá nkehe tso̱nhen tí chrókjuacha ijnko chojni chróchónta kaín nkehe siín chjasintajni, a̱ ntá kjuachón chrókjuinchekꞌitjáyan? ");
INSERT INTO poeNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Nkehe chrókjue̱nka̱ chojni kíxin chróchónta tí kjuachón? ");
INSERT INTO poeNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","A̱ ntá jnkojín nkexro tso̱suèhe̱ kíxin tinkáchónki tí janhan la ko tí tan kuènta̱na nkayakon tí chojni jínahya chónta jie la kja̱xin tí Xje̱en Dios Kꞌóna Chojni tso̱suèhe̱ chꞌán tsontáchro chꞌán kíxin chóxin chꞌán tí jehe sín tió tsokjan chꞌán tsi̱ka̱o chꞌán tí kjuachaxin jié kuènte Itꞌé la ko tsi̱ka̱o tí sín ángel.﻿ ");
INSERT INTO poeNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Na ko kja̱xin chrónka chꞌín Jesús kíxin: ―Chaxín ntáxrja̱n kíxin isorá tjejorá ntihi la na̱xa̱ tsꞌénhyará tsꞌikonjiará itsi tí kjuachaxin tsꞌe̱to̱an Dios ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ntá kꞌuátsínka injon ya̱on ntá chꞌín Jesús mé sákjui̱ko chꞌán chꞌín Pedro la ko chꞌín Jacobo la ko chꞌín Juan sákjui̱ sín jehó sín ijnko jna̱ noi. Ntá ntiha mé xrína̱hya kꞌuíxitoxi̱n ókjé nkexrí tsjehe chꞌán kꞌuíkon tí jehe sín. ");
INSERT INTO poeNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","A̱ ntá iké chꞌán tsíkꞌóna imá tjáki̱ni la ko imá tjóá éxí chrinta tsjehe, a̱ ntá ntihi chjasintajni kohya ninkexró chrókjue̱n tí ka chrókuito̱he imá tjóá xi̱kaha. ");
INSERT INTO poeNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Na ntá titàya̱ kꞌuíkuèn sín ntiha itjen tí chꞌín Elías la ko tí chꞌín Moisés tjejótjo sín tí chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","A ntá chꞌín Pedro mé ntáche chꞌán tí chꞌín Jesús kíxin: ―Maestro, jína kíxin tjejóni ntihi. Chrókjuichꞌénani iní nchia la mé ijnko kuèntá la ko ijnko kuènte chꞌín Moisés la ko ijnko kuènte chꞌín Elías. ");
INSERT INTO poeNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Mé xi̱kaha ichro chꞌán kíxin kaín sín la imá chrakon sín la tí chꞌín Pedro la mé í noehya chꞌán nkehe tsixro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Na ntá xrína̱hya ikui ijnko tjui̱ kjuákꞌetja chrítaón kaín xín tí tjejó sín. Na ntá chríkjan tí tjui̱ kuínhin sín itén ijnko nkexro nixja na mé ntáchro kíxin: ―Tí nkexro i mé xja̱nna. Imá tjua̱ha̱ chꞌán. Chrókuinhínrá tí nkehe tjako chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Na ntá tió tsjehe sín nkuíxín tí tjejó sín la í kohya tí iyó sín a. Jehó tí chꞌín Jesús tjejóko sín. ");
INSERT INTO poeNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","A̱ ntá tí ó kꞌuínkaji̱nxi̱n sín tí jna̱ ntá kꞌue̱to̱an chꞌín Jesús kíxin tsochenkahya sín ninkexró tí nkehe kꞌuíkon sín hasta tsoxechónjian tí Xje̱en Dios Kꞌóna Chojni. ");
INSERT INTO poeNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ntá ninkexró chenkahya sín tí nkehe kꞌuíkon sín. Na ntá jehó sín mé tjejótjo sín kíxin nkehe tꞌaxrjexín tí nkehe chrónka chꞌán kíxin tsoxechón chꞌán ínaá. ");
INSERT INTO poeNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Na ntá kjuanchankíhi sín tí chꞌín Jesús ntáchro sín kíxin: ―¿Nkekuènte kíxin ntáchro tí sín tjako tí ley kíxin sa̱oxín itsi tí chꞌín Elías la ntá chrꞌéxi̱n itsi tí nkexro tsaáxinni? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ntá ntáchro chꞌín Jesús kíxin: ―Chaxín sa̱oxín itsi chꞌín Elías la ntá tsjasiyóxin chꞌán kaín xín nkehe. ¿A̱ ntá nkehe ntáchro xroon itén Dios kíxin nkehe tso̱nhen tí Xje̱en Dios Kꞌóna Chojni? Na mé ntáchro kíxin tꞌichjánxi̱n tsjasóte la ko tsotjinkakonhya sín. ");
INSERT INTO poeNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Kjánchó ó xrja̱nka kíxin chaxín ó tsíki chꞌín Elías, ntá kjuínchekjasóte sín chꞌán éxí kóxrjínhi̱n sín éxí nixja tí xroon itén Dios kíxin xi̱kaha tso̱nhen ―mé xi̱kaha chrónka chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","A̱ ntá tió ikjan sín tí kuíto̱he tí í so sín kꞌuájiko chꞌán ntá kꞌuíkon sín kíxin nchónhya chojni tsíkꞌa̱ntatjen tí jehe sín. Kja̱xin ntaha siín tí sín tjako tí ley ikjo tí jehe sín. ");
INSERT INTO poeNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","A̱ ntá tuénxín tió kꞌuíkon sín tí chꞌín Jesús na ntá kaín sín kóchéhe̱ sín tinká sín sákjuíchréhe̱ sín chꞌán, tsonixje̱he̱ sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ntá chꞌín Jesús kjuanchankíhi chꞌán sín ntáchro chꞌán kíxin: ―¿Nkehe tí tjórá tí sín i? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ntá tjen ijnko chꞌán tjenkákjan sín ntiha kjuáte̱he chꞌán kíxin: ―Maestro, ntihi kjuíkian ijnko xja̱nna chónta ncha̱kuen tí jínahya na mé nchenixjahya xjan. ");
INSERT INTO poeNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kjónté nkerí tjen xjan la tí ncha̱kuen tí jínahya mé tjáka xjan nonte, ntá nta̱lóxrjo síti̱xi̱n irꞌva xjan na netaón xjan neno xjan na méxra̱ tji̱ehya xjan. Ntá xrja̱nóa̱ha̱ tí sín xrikoa kíxin chrókuakitsje sín tí ncha̱kuen tí jínahya a. Kjánchó kjuachahya sín ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ntá chꞌín Jesús kjuáte̱he chꞌán ntáchro chꞌán kíxin: ―Jahará chojni kénhya a̱sánrá tinkachónkirá Dios. ¿Xá hasta nkesá tjinkáonrá na̱xa̱ tsꞌejóni? ¿Xá hasta nkesá tsjácha tsjakꞌé tsjákohará? Xráko̱ará ntihi tí xjan méhe̱ ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Na ntá kóchjinako sín tí xjan a. Na ntá tí ncha̱kuen tí jínahya mé kꞌuíkon tí chꞌín Jesús ntá kjuínchekꞌaniáte tí xjan a kjuítsínka xjan nonte la kjaminkítaón xjan nonte la sítji nta̱lóxrjo irꞌva xjan. ");
INSERT INTO poeNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ntá chꞌín Jesús mé kjuanchankíhi tí itꞌé tí xjan a ntáchro chꞌán kíxin: ―¿Á ósé xi̱kaha tónhen xjan? ―ichro chꞌán. Ntá ntáchro tí itꞌé tí xjan kíxin: ―Desde na̱xa̱ xja̱nntsí xjan. ");
INSERT INTO poeNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","A̱ ntá jnkoya̱xón tí ncha̱kuen tí jínahya a mé tjákáte xjan xrohi la ko tjákánkí xjan ìnta̱ kíxin tjinkaon chrókꞌóyán tí xjan a. A̱ ntá jaha ¿á tsjácha tsjínki̱tsani? La ti̱konóe̱héni tsjínki̱tsani ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ntá ntáchro chꞌín Jesús kíxin: ―¿Nkekuènté tjanchankìna kíxin á tsjácha? Tí tsitekávan la kaín nkehe la jína tso̱nhen, kíxin tí nkexro tsitekaon Dios la jína tso̱nhen kaín nkehe ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ntá tuénxín itsen kjuáte̱he tí itꞌé xjan, ntáchro chꞌán kíxin: ―Ó titekaonni. Tsjínki̱tsani kíxin a̱ntsí má tsitekaonni tí jaha ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ntá kꞌuíkon chꞌín Jesús kíxin itsjé chojni kóchjina. Ntá nixje̱he̱ chꞌán tí ncha̱kuen tí jínahya chónta tí xjan a ntáchro chꞌán kíxin: ―Jaha la ijnko ncha̱kuen tí jínahya nchenixjahya chojni la ko nchekíenhya chojni. Ijie la tétua̱nhan kíxin tꞌaxrjéxian tí xjan na ko tsi̱to̱hé xjan la í tsokjanhya ínaá ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ntá tí ncha̱kuen tí jínahya a na mé kꞌóyato la ko kjuínchekꞌaniáte tí xjan a ínaá, ntá kꞌuaxrjexín ntiha. Na éxí tsíkꞌen xjan xi̱kaha tsjehe xjan. Ntá itsjé sín ntáchro sín kíxin ó tsíkjixin tsíkꞌen xjan, ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Na ntá chꞌín Jesús mé tséhe tja tí xjan kjuínchekꞌinkatjen chꞌán xjan. ");
INSERT INTO poeNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ntá chꞌín Jesús la ko tí sín kꞌuájiko chꞌán kꞌuíxenhen sín ijnko nchia. Ntá jehe sín kjuanchankíhi sín chꞌán kíxin: ―¿Nkekuènté kíxin kjuachahyani kuakitsjeni tí ncha̱kuen tí jínahya a? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ntá ntáchro chꞌán kíxin: ―Tíhi la tꞌichjánxi̱n kíxin nchónhya tsochronóe̱hérá Tꞌaná la ko sintehyará ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","A̱ ntá tió sákjuíxin sín ntiha ntá kꞌuátsínka sín estado Galilea. A̱ ntá chꞌín Jesús tjinkakonhya chꞌán kíxin ninkexró ntiha tso̱nohe sín ");
INSERT INTO poeNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kíxin tinkákja̱ko̱he̱ chꞌán tí sín kꞌuájiko chꞌán a. Na mé chrónka chꞌán ntáchro chꞌán kíxin: ―Tí Xje̱en Dios Kꞌóna Chojni mé tsotsé sín chꞌán la ko tsjikaán sín chꞌán na ko tsꞌóyán sín chꞌán. Kjánchó tí ya̱on níxin na ó tsoxechón chꞌán ínaá ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ntá jehe sín mé kíenxínhya sín nkehe tí ntáchro chꞌán la chrakon sín chrókjuanchankíhi sín chꞌán nkexrí tꞌaxrjexín tíha. ");
INSERT INTO poeNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ntá kjuíji sín chjasin Capernaum; a̱ ntá tí tjejó sín tí nchia ntiha ntá chꞌín Jesús mé kjuanchankíhi chꞌán sín ntáchro chꞌán kíxin: ―¿Nkehe tí tinkakjórá kíchuárá tí kuini nti̱a? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ntá jehe sín la táníkoá sín kíxin tí nti̱a kui sín tinkákjo kíchó sín kíxin nkexro tí imá tsꞌe̱to̱an. ");
INSERT INTO poeNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ntá chꞌín Jesús mé kjuákꞌetja̱xi̱n chꞌán ntá kꞌuíye̱he̱ chꞌán tí teyó sín kꞌuájiko chꞌán, a̱ ntá ntáche chꞌán sín kíxin: ―Tí jnkojínrá tjinkáonrá chrókuéto̱anrá má ntá tꞌichjánxi̱n kíxin tsjixixín tsochréhérá kaín sín, tsꞌítuanhanrá la ko tsjínki̱tsará kaín xín sín ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ntá tséhe chꞌán tja ijnko chánjan kjuakꞌe chꞌán jnko̱siné tí tjejó tí jehe sín a, ntá kjóa chꞌán tí xjan a. Ntá ntáchro chꞌán kíxin: ");
INSERT INTO poeNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Tí jnkojín nkexro chrókꞌuáyéhe̱ ijnko chánjan kíxin tinkáchónki sín tí janhan la mé xi̱kaha chrókꞌuáyéhe̱ sín tí janhan la ko kja̱xin éxí chrókꞌuáyéhe̱ sín tí nkexro ichrꞌánna ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","A̱ ntá chꞌín Juan mé ntáchro chꞌán kíxin: ―Maestro, kꞌuíkonni ijnko chojni na mé kjuachaxin ihni̱á mé takitsjexín chꞌán ncha̱kuen tí jínahya chónta chojni. Ntá kꞌue̱tue̱nhenni chꞌán kíxin xi̱kahya chrókjuichꞌe chꞌán kíxin xrikohyani chꞌán ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ntá ntáchro chꞌín Jesús kíxin: ―Nté ti̱to̱hé chꞌán kíxin ninkexró tjasixín kjuaxroan kjuachaxin ni̱na la tuénxín chrókjuacha chrókꞌuántaxìna sín. ");
INSERT INTO poeNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tí nkexro ninkakuenhyani la mé tjinki̱tsa tí jeheni. ");
INSERT INTO poeNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","A̱ ntá jnkojín nkexro tsotjáhará kjónté ijnko vaso ìnta̱ tsjanjonxín sín ni̱na kíxin jahará la tinkachónkirá Cristo, ntáxrja̱n kíxin chaxín tsꞌáyéhe̱ sín nkehe. ");
INSERT INTO poeNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’A̱ ntá jnkojín nkexro chrókjuachroe ijnko xjan kíxin chrókjuasin xjan jie̱ tió tinkáchónki xjan tí janhan la íchá jína chrókjuincheteyá sín chꞌán ijnko xro̱ jié tsíkꞌóna xro̱chre̱ la chrókjuikákánkí sín chꞌán nta̱yaon. ");
INSERT INTO poeNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","A̱ ntá tí itjá tjásixián jie̱ na mé íchá chrókójína chrókochrínjian kíxin kjónté jnkoko̱á tjá mé tsochontaxián kjuachón. A̱ ntá tí yóí tjá la tíha mé sáchrókjuíxian tí siín xrohi xitjahya tsꞌanka, ");
INSERT INTO poeNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","tí siín kosi̱nto̱ tꞌenhya la ko síche xrohi tsꞌankahya. ");
INSERT INTO poeNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","A ntá kja̱xin tí to̱tá tjásixián jie̱ na íchá jína chrókochrínjian kíxin kjónté jnkoko̱á to̱tá mé tsochontaxián kjuachón. A̱ ntá tí yóí to̱tá la tíha sáchrókjuíxian tí siín xrohi xitjahya tsꞌanka, ");
INSERT INTO poeNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","tí siín kosi̱nto̱ tꞌenhya la ko síche xrohi tsꞌankahya. ");
INSERT INTO poeNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","A̱ ntá tí ikuan tjásixián jie̱ na íchá jína chrókuakitsjenkiá tí kuan a kíxin kjónté jnkoko̱á kuan mé sáchrókjuia tí tjen Dios tꞌe̱to̱an. A̱ ntá tí yóí kuan la tíha mé sáchrókjuíxian tí síche xrohi ");
INSERT INTO poeNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","tí siín kosi̱nto̱ tꞌenhya la ko siín xrohi tsꞌankahya. ");
INSERT INTO poeNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’A̱ ntá kaín nkexro tꞌichjánxi̱n tsjasóte. A̱ ntá kaín nkehe tsꞌáyéhe̱ Dios chónta xíjnta. ");
INSERT INTO poeNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Tí xíjnta la jína. A̱ ntá tí chrókꞌuankehe tí jní la ntá xitjahya chrókójní ínaá. Jahará mé chrókóyóha̱rá éxí xíjnta kíxin kjuaxróxin chrókꞌuejokoárá kíchuárá ―ichro chꞌán.﻿ ");
INSERT INTO poeNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Na ntá chꞌín Jesús mé kꞌuaxrjexín chꞌán chjasin Capernaum sákjuí chꞌán nó estado Judea la ko nó tóhe nta̱río Jordán. Ntá nchónhya chojni kójnkotsé sín tí tjen chꞌán ntiha. Ntá kjua̱ko̱he̱ chꞌán tí jehe sín kíxin xi̱kaha kuènhen chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ntá iso sín fariseo mé kóchjinehe sín chꞌán kjuanchankíhi sín chꞌán nkehe, chrókjua̱cha̱xi̱n sín chꞌán. Ntáchro sín kíxin: ―¿Á siín kjuachaxin tsjáke̱he̱ chojni ntoa ichjién? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ntá kjuáte̱he chꞌán ntáchro chꞌán kíxin: ―¿Nkehe tí kꞌue̱tua̱nhanrá tí chꞌín Moisés? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ntá ntáchro sín kíxin: ―Chꞌín Moisés kjuanjon chꞌán kjuachaxin kíxin tsꞌóna ijnko xroon tsakja tí ichjién kíxin tsꞌitjíexín kíchó sín ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ntá chꞌín Jesús ntáchro chꞌán kíxin: ―Ntá jahará icha a̱sánrá títekákonhyará ntá kꞌue̱to̱an chꞌán tsꞌóna tí xroon a. ");
INSERT INTO poeNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Kjánchó tí xrankíxixín tió kjuíchꞌéna Dios kaín xín nkehe la kjuíchꞌéna chꞌán ijnko chojni ntoa la ko ijnko chojni chjin. ");
INSERT INTO poeNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Méxra̱ tí chojni ntoa tsíto̱he chꞌán tí itꞌé chꞌán la ko ìné chꞌán kíxin tsakja chꞌán ichjién chꞌán ");
INSERT INTO poeNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ntá yóí sín tsꞌóna sín éxí jnkoko̱á chojni. Méxra̱ jehya yaá chojni. Náhí, jnkoko̱á. ");
INSERT INTO poeNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Na mé xi̱kaha tí kjuachaxin kuènte Dios kójnkojiéxin sín ntá jehe sín chrókꞌuitjíehya kíchó sín ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","A̱ ntá tjejó sín nchia ntá tí sín kꞌuájiko chꞌán a mé kjuanchankíhi sín chꞌán ínaá kíxin á xitjahya tsꞌitjíhi kíchó sín. ");
INSERT INTO poeNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Na ntá ntáchro chꞌín Jesús kíxin: ―Tí jnkojín nkexro tsjáke̱he̱ ichjién ntá tsakja chꞌán í jnko chjin na mé xi̱kaha tsja̱che̱he̱ chꞌán tí tjan tsíkóte̱he chꞌán sa̱oxín. ");
INSERT INTO poeNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","La ko kja̱xin tí chojni chjin tsíkjáke̱he̱ xìi tsakja tjan í jnko chojni ntoa na mé xi̱kaha kja̱xin tjan tjasin tjan jie̱ ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ntá kjui̱ka̱o sín xjan kíxin tjinkaon sín tsjakꞌetja tja chꞌín Jesús tí xjan a. Ntá tí sín kꞌuájiko chꞌán mé kóninkakonhen sín tí sin kjui̱ka̱o xjan. ");
INSERT INTO poeNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ntá kꞌuíkon chꞌín Jesús ntá kónínkaon chꞌán ntáchro chꞌán kíxin: ―Nté ti̱to̱hérá tí xjan tsoxrakoa tí tjén janhan la tꞌinkakuènhyará xjan kíxin tí sín kuènte kjuachaxin kuènte Dios la mé tóyóhe̱ éxí tí xjan a. ");
INSERT INTO poeNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ntá chaxín ntáxrja̱n kíxin tí nkexro tsꞌónahya éxí ijnko chánjan xitjaha tsꞌejó sín tí tsꞌe̱to̱an Dios tí kjuachaxin kuènte chꞌán ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ntá kjóa chꞌán tí xjan a kjuakꞌetja tja chꞌán xjan la kjuíncheyaon chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","A̱ ntá tió sákjuí chꞌín Jesús ínaá ntá xrakoa ijnko chꞌín tinká chꞌán kjuákꞌexín tochꞌin chꞌán nkayakon tí chꞌín Jesús kjuanchankí chꞌán kíxin: ―Jaha, maestro jína. ¿Nkexrí chrókjuichꞌeni kíxin chrókꞌuitjani kjuachón jnkochríxín? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ntá ntáche chꞌín Jesús tí jehe chꞌán kíxin: ―¿Nkekuènté ntáchrua kíxin jína tí janhan? Jehó jnkoko̱á nkexro mé jína la tíha mé Dios. ");
INSERT INTO poeNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ntá jaha ó noha kíxin nkexrí kꞌue̱to̱an Dios kíxin: “Chrókjuacheéhya kíchuá la chrókꞌoyánhya chojni la chrókue̱ehya la chrókjóntahya kíchuá la chrókjui̱chꞌiahya la ko chróchontehé kjuasáya itꞌá la ko ìná” ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","A̱ ntá jehe chꞌán kjuáte̱he chꞌán ntáchro chꞌán kíxin: ―Maestro, kaín tíha kjuínchexiteyáni desde ntasoáni ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ntá chꞌín Jesús mé komá chꞌán la ko tjuèhe chꞌán tí chꞌín a. Ntá ntáchro chꞌán kíxin: ―Na̱xa̱ tꞌitjáyan jnkoko̱á nkehe chrókjui̱chꞌe. Sátjia nchekjia kaín tí nkehe chonta. A̱ ntá tí chichaon si̱nchekjixián tí nkehe chonta la mé ncheki̱to̱nhén tí chojni nòa, a̱ ntá tí nkehe tjete tsochonta nkaya nka̱jní. A̱ ntá tió tsjixin tsjánjuan kaín ntá tsjihá tamá tí ntacruz kuènta la chréhé tí janhan ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ntá tió kuínhin chꞌán xi̱kaha ntá kꞌuává chꞌán sákjuí chꞌán, kíxin imá tsjé nkehe chónta chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ntá chꞌín Jesús komá chꞌán tí sín siín ntiha ntáche chꞌán tí sín siín kꞌuájiko chꞌán kíxin: ―Imá xra̱ ijnko chojni chónta imá tsjé nkehe tsꞌixenhen sín tí tjen Dios tꞌe̱to̱an ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ntá tóxakonhen tí sín kꞌuájiko chꞌán kíxin xi̱kaha ntáchro chꞌán. Ntá chrónka chꞌán ínaá kíxin: ―Tí sín tjekonhen tí nkehe chónta sín na imá xra̱ tsꞌixenhen sín tí tjen Dios tꞌe̱to̱an. ");
INSERT INTO poeNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","A̱ntsí xra̱hya chrókꞌuátsínka ijnko kocamello ijnko tja̱rꞌin ntachica tjexrja. A̱ ntá a̱ntsí má xra̱ ijnko chꞌín chónta itsjé nkehe chrókꞌuixenhen chꞌán tí tjen Dios tꞌe̱to̱an ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ntá jehe sín kuínhin sín xi̱kaha ntá imá chrakon sín. Ntá tjanchankíhi kíchó sín kíxin: ―Tí xi̱kaha la, ¿xá nkexro chrókjuacha chrókuaá? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ntá komá chꞌín Jesús tí jehe sín ntáchro chꞌán kíxin: ―A̱ ntá chojni ó tsjachahya sichꞌe tíha, a̱ ntá Dios jína sichꞌe kaín nkehe, kixin Dios la kohya nkehe tsjachahya sichꞌe ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ntá chꞌín Pedro ntáchro chꞌán kíxin: ―Ìnchéni, kaín ni mé kuíto̱heni kaín nkehe chóntani ntá chréhe̱ni tí jaha ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌín kíxin: ―Chaxín ntáxrja̱n kíxin jnkojín nkexro tsíto̱he nto̱e sín la o̱ tí kíchó ntoa o̱ tí kíchó chjin la o̱ itꞌé o̱ ìné sín o̱ ichjién sín o̱ xje̱en sín o̱ no̱nte̱e kíxin tinkáchónki sín tí janhan la ko tjinkaon sín chrókjuako sín tí tan tsjanjon kjuachón ");
INSERT INTO poeNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","na mé ntihi chjasintajni tsochónta sín ciento veces nchónhya nto̱e sín la ko éxí kíchó sín la ko éxí ìné sín la ko éxí xje̱en sín tsꞌikon sín itsjé chojni kjé la ko éxí no̱nte̱e sín xi̱kaha tsꞌikon sín itsjé nonte. Kjónté tsjasóte sín ntihi chjasintajni ntá chrꞌéxi̱n tsochónta sín tí kjuachón jnkochríxín. ");
INSERT INTO poeNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","A̱ ntá itsjé tí sín tꞌe̱to̱an ijie mé tsjixixín tsochréhe̱ sín. A̱ ntá itsjé tí sín tꞌítuenhen ijie, na mé tí sín a mé tsꞌe̱to̱an sín tí ntiha. ");
INSERT INTO poeNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ntá tjejótji sín chrìin sín tí nti̱a sátsji̱ chjasin Jerusalén. Ntá chꞌín Jesús mé tjetaón chꞌán nti̱a ntá tí sín kꞌuájiko chꞌán mé tóxakonhen sín chrakon sín chréhe̱ sín. Ntá kꞌuíye̱he̱ chꞌán jehó tí teyó sín ínaá ntá kjuankíxin chꞌán chénka chꞌán sín nkexrí tí nkehe tso̱nhen chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ntá ntáchro chꞌán kíxin: ―Ijie sátsji̱ni Jerusalén. Na ntá tí Xje̱en Dios Kꞌóna Chojni mé tsotsé sín chꞌán tsjikénhen sín tí sín ncha̱tꞌá tꞌe̱to̱an la ko tí sín tjako tí ley. Ntá tsꞌe̱to̱an sín kíxin itsꞌen chꞌán. Ntá sinchekꞌáyéhe̱ sín chꞌán tí sín jehya judío. ");
INSERT INTO poeNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ntá jehe sín la tsjanoá sín tí jehe chꞌán la ko nta̱té sín tsi̱ki̱te sín chꞌán la ko tsjate sín chꞌán ntá tsꞌóyán sín chꞌán. Kjánchó tí ya̱on níxin mé tsoxechón chꞌán ínaá ―mé xi̱kaha ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","A̱ ntá tí chꞌín Jacobo la ko chꞌín Juan mé xje̱en chꞌín Zebedeo mé kóchjinehe sín tí chꞌín Jesús ntá ntáchro sín kíxin: ―Maestro, tjanchahani ijnko xra̱ ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ntá kjuanchankí chꞌín Jesús ntáchro chꞌán kíxin: ―¿Nkehe tí xra̱ tjinkáonrá chrókjui̱tꞌahará? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ntá ntáchro sín kíxin: ―Tió tséto̱anxián tí kjua̱cha̱xián jié na tjinkaonni kíxin ijnkoni chrókjuakꞌeni itjá chjina a̱ í jnkoni chrókjuakꞌeni itjá kjon ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ntá ntáche chꞌín Jesús tí jehe sín kíxin: ―Jahará la noahyará nkehe tí tjanchanará. ¿Á chrókjuachará chrókꞌuirá tí nkehe itsjá itsꞌia janhan la ko á chrókjuachará chrókuikiterá éxí tsikite janhan? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ntá jehe sín kjuáte̱he sín ntáchro sín kíxin: ―Kja̱ tsjachani ―ichro sín. Ntá ntáche chꞌín Jesús tí jehe sín kíxin: ―Chaxín itsꞌirá éxí tí nkehe tsjá itsꞌia la ko tsikiterá éxí tsikite janhan. ");
INSERT INTO poeNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Kjánchó janhan xitjahya tsjánjuan kjuachaxin kíxin ijnkorá chrókjuakꞌerá tjaná chjina la í jnkorá chrókjuakꞌerá tjaná kjon kíxin janhan na tónahya tocar tsjánjuan tíha kíxin tí sín a la xráxín ó tsíkónoxín ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","A̱ ntá tió kuínhin tí ite sín xi̱kaha tsíntáchro tí sín a ntá kjuankíxin kónínkakonhen sín tí chꞌín Jacobo la ko tí chꞌín Juan. ");
INSERT INTO poeNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ntá kꞌuíye̱he̱ chꞌín Jesús kaín tí jehe sín ntá ntáche chꞌán sín kíxin: ―Ó nohará kíxin tí sín tꞌe̱to̱an chjasintajni la imá tꞌe̱tue̱nhen sín kaín chojni la ko tí sín imá tjetoan mé imá nchehnkehe a̱sén sín kíxin ihyé sín tsꞌe̱to̱an sín. ");
INSERT INTO poeNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Kjánchó jahará la xi̱kahya chrókjui̱chꞌerá. Náhí. Tí jnkojínrá tjinkáonrá chrókuéto̱anrá la chrókjuínki̱tsará tí í so sín. ");
INSERT INTO poeNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","A̱ ntá tió jnkojínrá a̱ntsí chrókuéto̱anrá mé tꞌichjánxi̱n senó chrókjuáko̱xi̱nrá chrókjui̱chꞌeherá kíchuárá xra̱. ");
INSERT INTO poeNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kíxin tí Xje̱en Dios Kꞌóna Chojni mé kuihya chꞌán kíxin chojni chrókjuichꞌehe chꞌán xra̱. Náhí. Ikui chꞌán kíxin sichꞌehe chꞌán sín xra̱ la ko tsꞌenyákonhe̱n nchónhya chojni kíxin tsaáxin sín chꞌán ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ntá kjuíji sín chjasin Jericó. Ntá chꞌín Jesús la ko tí sín kꞌuájiko chꞌán la ko nchónhya chojni kꞌuaxrjexín sín tí chjasin ntiha. Ntá ntiha tjen ijnko chꞌín tꞌikonhya mé itꞌin chꞌán Bartimeo ntá itꞌé chꞌán mé itꞌin Timeo. Tjetja̱xi̱n chꞌán chrínta nti̱a tjanchakꞌá chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ntá kuínhin tí chꞌín tꞌikonhya kíxin ó kuichjina chꞌín Jesús, mé tí nkexro kjui̱xi̱n chjasin Nazaret, ntá tí chꞌín tꞌikonhya kjuankíxin tꞌèya chꞌán ntáchro chꞌán kíxin: ―Jaha Jesús, tsíkꞌaxrjeníxian chꞌín David ti̱konóe̱héni ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ntá nchónhya sín kꞌue̱tue̱nhen sín chꞌán kíxin tso̱tání chꞌán. Ntá íchá a̱ntsí má tsen tꞌèya chꞌán ntáchro chꞌán kíxin: ―Jaha, tsíkꞌaxrjeníxian chꞌín David ti̱konóe̱héni ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ntá ntahó kjuákꞌe chꞌín Jesús. Ntá kꞌue̱to̱an chꞌán kíxin: ―Tꞌi̱ye̱hérá tí chꞌín a ―ichro chꞌán. Ntá kꞌuíye̱he̱ sín tí chꞌín tꞌikonhya ntá chénka sín chꞌán kíxin: ―Tócháha la tꞌinkatjen kíxin tjetꞌiya̱ha chꞌán. ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ntá kjua̱kꞌe̱ chꞌán tí ka titsáte chꞌán ntá chrika kꞌuínkatjen chꞌán kóchjinehe chꞌán tí tjen chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ntá chꞌín Jesús kjuanchankíhi chꞌán tí chꞌín a kíxin: ―¿Xá nkehe tjinkávan chrókjui̱tꞌahá? ―ichro chꞌán. Ntá kjuáte̱he tí chꞌín tꞌikonhya ntáchro chꞌán kíxin: ―Maestro, tjinkaonni kíxin chrókꞌuikonni ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ntá ntáche chꞌín Jesús tí chꞌín a kíxin: ―Ijie la jína sátsjia. Ó kuíto̱ha jína kíxin kuítekávan tí janhan ―ichro chꞌán. Ntá tuénxín tí chꞌín tꞌikonhya la ó kꞌuíkon chꞌán ntá chréhe̱ chꞌán tí chꞌín Jesús.﻿ ");
INSERT INTO poeNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ntá tió kjuíji chjina sín chjasin Jerusalén chjinaxón tí chjasin Betfagé la ko chjasin Betania chokꞌèxin tí jna̱ Olivo ntá kꞌue̱tue̱nhen chꞌín Jesús iyó tí sín kꞌuájiko chꞌán, ");
INSERT INTO poeNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ntáchro chꞌán kíxin: ―Sátjirá tí chjasin ntsí chokꞌèxin ntiha. Ntá ikon chjasin tsꞌikonrá kíxin ntaha tjechroé ijnko kolócho na̱xa̱ ninkexró tjitákꞌáhya va. Ntá tjasínta̱nke̱hérá va ntá tsjíkoanará va ntihi. ");
INSERT INTO poeNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","A̱ ntá tí jnkojín chojni tsjanchankíhará sín kíxin nkekuènté xi̱kaha chꞌerá ntá tsontáchrorá kíxin: “Tí Maestro mé tꞌichjánxi̱nhin va ntá tió tsoxéhe̱ va la tsjikaáni va”, ichrorá ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ntá jehe sín mé sákjuí sín kꞌuitja sín tí kolócho tjechroé va chjinaxón ntója nchia ntá kjuasinta̱nke̱he sín va. ");
INSERT INTO poeNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ntá iso tí chojni tjejó ntiha kjuanchankí sín kíxin: ―¿Nkekuènté xi̱kaha chꞌerá tjasínta̱nke̱hérá tí kolócho a? ―mé chro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ntá kjuáte̱exín sín éxí kꞌue̱to̱an chꞌín Jesús. Ntá kjuanjon sín kjuachaxin sátsjiko sín va. ");
INSERT INTO poeNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ntá tí kolócho mé kjuikohe sín chꞌín Jesús. Na ntá iké sín kjuínchekamá sín va, ntá kjuákꞌekjen chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ntá itsjé chojni kuakitsje sín iké sín la kjuentoá sín tinkákꞌikjínxi̱n sín ka tí nti̱a tsꞌatsínkaxín chꞌán. Ntá iso sín la mé tóchrínjin sín chaon nta itsá kayoa ntá xráka̱o sín tinkátꞌitjí sín nti̱a. ");
INSERT INTO poeNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","A̱ ntá tí sín tsítaón nti̱a la ko tí sín chréhe̱ iton kjuankíxin sín itsje sín chéhe̱ sín ntáchro sín kíxin: ―Tsjancheheni kjuasáyé Dios. Jína tí nkexro kui̱xi̱n kjuachaxin ihni̱é Ìnchéni. ");
INSERT INTO poeNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Jína tí kjua̱cha̱xién Dios itsi mé tsꞌe̱tue̱nhen tí nkexro kꞌuaxrjeníxin itꞌéni David. Ntá tsjancheheni kjuasáyé Dios tjen nkaya nka̱jní ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ntá kꞌuíxenhen chꞌín Jesús chjasin Jerusalén la ko kja̱xin kꞌuíxenhen chꞌán tí ni̱nko jié tsjehe chꞌán nkuíxín tí nkaxenhen. Ntá ó kóntó ntá chꞌín Jesús sákjuíko chꞌán tí teyó sín kꞌuájiko chꞌán sákjuí sín chjasin Betania. ");
INSERT INTO poeNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","A̱ ntá tí kóya̱on ntá kja̱nxi̱n sín chjasin Betania ntá chꞌín Jesús mé kꞌuén chꞌán kjinta. ");
INSERT INTO poeNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ntá kꞌuíkon chꞌán kjín kíxin itjen ijnko nta tꞌóna to higo itsá kayoa. Ntá sákjuítsjehe chꞌán tí nta kíxin ákué tsahya to. Ntá kꞌuíkon chꞌán kíxin jehó ka itsa tí nta a kíxin jehya tí ya̱on tsꞌóna to. ");
INSERT INTO poeNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ntá nixje̱he̱ chꞌín Jesús tí nta tꞌóna to higo kꞌue̱tue̱nhen chꞌán tí nta kíxin: ―Í ninkexró sinehya tí to tsꞌóna tí jaha ínaá ―ichro chꞌán. A̱ ntá tí sín kꞌuájiko chꞌán mé kuínhin sín xi̱kaha. ");
INSERT INTO poeNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ntá kjuíji sín chjasin Jerusalén. Ntá kꞌuíxenhen chꞌín Jesús nkaxenhen ni̱nko a. Ntá kjuankíxin chꞌán kꞌuinkíté chꞌán tí sín nchekjixín nkehe ntiha la ko tí sín tꞌe̱na nkehe ntiha. A̱ ntá kótéka chꞌán tí mesa tjinkítóxixín sín chichaon la ko tí silla tjejókjen tí sín nchekji kontóá ");
INSERT INTO poeNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","la ko kjuanjonhya chꞌán kjuachaxin kíxin tsamá sín nkehe tsꞌajixenhen sín ni̱nko. ");
INSERT INTO poeNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ntá kjua̱ko̱he̱ chꞌán sín ntáchro chꞌán kíxin: ―Ntáchro xroon itén Dios kíxin: “Tí nto̱na i mé itꞌin nchia tsonixjanaxín chojni nkuíxín nación”, a̱ ntá jahará tsíkji̱chꞌénará itjue̱é xíche̱e ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ntá tí sín ncha̱tꞌá tꞌe̱to̱an la ko tí sín maestro tjako tí ley na mé kuínhin sín tíha, ntá kjueyá sín nkexrí chrókꞌóyán sín chꞌán, kjánchó chrakon sín kíxin kóxrjínhi̱n tí chojni tí nkehe kjuako chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kjánchó ntá ó kóntó ntá kꞌuaxrjexín chꞌán tí chjasin a sákjuí chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","A̱ ntá tí nchítjen kꞌuátsínka sín tí tjen tí nta tꞌóna to higo ntá kꞌuíkon sín kíxin ó tsíxámáxin nuèe tí nta. ");
INSERT INTO poeNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","A̱ ntá chꞌín Pedro xráxinkaon chꞌán ntáche chꞌán tí chꞌín Jesús kíxin: ―Maestro, tsjehé tí nta tꞌóna to higo kónínkakonhén jna na ó tsíxámá nta ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Tinkachónkirá Dios. ");
INSERT INTO poeNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Chaxín ntáxrja̱n kíxin jnkojínrá chróntácherá tí jna̱ i kíxin: “Sátjíxián ntihi tjíkjia̱nkiá nta̱yaon”, a̱ ntá tí kaín a̱sánrá chrókuinkachónkirá Dios kíxin chróxiteyá tí nkehe tsontáchrorá, ntá xi̱kaha chaxín tso̱nhen. ");
INSERT INTO poeNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Mé xi̱kaha ntáxrja̱n kíxin kaín tí nkehe tsjanchehérá Dios tí tsítekáonrá kíxin chaxín tsꞌayéhérá ntá xi̱kaha tso̱nhen tsoxiteyá. ");
INSERT INTO poeNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","A̱ ntá tió tjejonixje̱hérá Dios ntá jnkojín nkexro na̱xa̱ ninkákonhénrá, la chrókꞌuitjáyanhanrá tíha kíxin Itꞌárá tjen nkaya nka̱jní kja̱xin chrókjuinchekꞌitjáyan chꞌán tí jie̱ chontará. ");
INSERT INTO poeNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","A̱ ntá tí si̱nchekꞌitjáyanhyará tí iji̱é chojni ntá Itꞌárá tjen nkaya nka̱jní la kja̱xin sinchekꞌitjáyanhya chꞌán tí jie̱ chontará. ");
INSERT INTO poeNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ntá xíkjan sín chjasin Jerusalén ínaá. Ntá xritjakꞌe chꞌán nkaxenhen ni̱nko ntá kóchjina tí sín ncha̱tꞌá tꞌe̱to̱an la ko tí sín tjako tí ley la ko tí sín táda tꞌe̱to̱an ni̱nko ");
INSERT INTO poeNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","kjuanchankíhi sín chꞌán kíxin: ―¿Nkehe tí kjuachaxin chonta jaha kíxin xi̱kaha chꞌe? ¿Nkexro tjáha tí kjuachaxin kíxin xi̱kaha kjui̱chꞌe? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Ntá kja̱xin janhan tsjánchánkíhárá ijnko nkehe, siná á chrókjuáte̱herá, ntá tso̱tjo̱nkará nkehe tí kjuachaxin chonta janhan kíxin xi̱kaha itꞌa̱. ");
INSERT INTO poeNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿A̱ ntá nkexro kꞌue̱tue̱nhen chꞌín Juan kíxin tsi̱ki̱te chꞌán chojni? ¿Á Dios ní o̱ á chojni ó? A̱ ntá jie la tjáte̱herá ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ntá kjuankíxin jehó sín tjo sín kíchó sín kíxin: ―Tí tsontáchroni kíxin Dios tsíkꞌe̱tue̱nhen tí chꞌín Juan ntá tsjanchankí tí chꞌín a kíxin nkekuènté kuítekakuenhyani chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","¿Á chróntáchroni kíxin chojni ó tsíkꞌe̱tue̱nhen chꞌán? ―ichro sín. Kjánchó chrako̱nhe̱n sín tí chojni chjasin kíxin kaín sín kuítekaon sín kíxin chꞌín Juan mé kꞌuénixja chꞌán itén Dios. ");
INSERT INTO poeNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ntá ntáche sín tí chꞌín Jesús kíxin: ―Noehyani ―ichro sín. Ntá ntáchro chꞌín Jesús kíxin: ―La ko kja̱xin janhan tso̱xrja̱nka̱hya nkexro kjuanjon kjuachaxin kíxin xi̱kaha tꞌa̱ ―ichro chꞌán.﻿ ");
INSERT INTO poeNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ntá chꞌín Jesús kjuíncheyóe̱xin chꞌán ínaá ntáchro chꞌán kíxin: ―Itjen ijnko chꞌín kꞌue̱nka̱xin chꞌán itsjé ntanòa tꞌóna to uva no̱nte̱e chꞌán la ko kjuíchꞌéna chꞌán corral la ko kjuíchꞌéna chꞌán ijnko tòye̱ tsꞌénya sín to uva. A̱ ntá kjuíchꞌéna chꞌán ijnko tja̱tꞌo̱ noi kíxin tsꞌi̱tꞌótjen chꞌán tsokotohe̱ chꞌán. ’A̱ ntá kjuínchekjen chꞌán tí nonte iso chojni chꞌe xra̱. Ntá sákjuí chꞌán kjín. ");
INSERT INTO poeNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ntá tí kjuixraká tí ya̱on tsꞌóna to ntá kꞌue̱tue̱nhen chꞌán ijnko tí nkexro chꞌehe chꞌán xra̱ kíxin sátsjikjanchehe chꞌán tí sín chꞌe xra̱ jnko̱siné tí to tsakja chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ntá tí sín chꞌe xra̱ mé tsé sín tí chꞌín a, kjuate sín chꞌán ntá ninkehó chjéhya sín chꞌán ntá sákjuí chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","A̱ ntá tí ìnché tí nonte mé xíchrꞌán chꞌán tí í jnko nkexro chꞌehe chꞌán xra̱. Ntá kjuíji chꞌán ntiha ntá chjéhe sín chꞌán xro̱ kjuíncheníhi sín kja chꞌán la ko kꞌuántaxínhi̱n sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ntá tí ìnché tí nonte a xíchrꞌán chꞌán í jnko chojni sákjuitsjehe ntiha. Ntá kjuíji chꞌán ntiha ntá kꞌóyán sín chꞌán. Ntá chrꞌéxi̱n tí ìnché mé xíchrꞌán chꞌán í so nkexro chꞌehe chꞌán xra̱ sákjuítsjehe sín, kjánchó iso sín kꞌuékon sín la í so sín la kꞌóyán sín. ");
INSERT INTO poeNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Ntá jehe chꞌán chónta chꞌán jnkoko̱áxón xje̱en chꞌán na imá tjuèhe chꞌán tí xjan a. Ntá kjuixixín chrꞌán chꞌán tí xjan sákjuí xjan kíxin kjuenka̱yáxin chꞌán kíxin: “Tsochóntehe sín kjuasáyé tí xja̱nna”, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","A̱ ntá tí sín chꞌe xra̱ a tjo sín kíchó sín kíxin: “Tí chꞌín i mé tsꞌáyéhe̱ kaín nkehe siín ntihi. A̱ ntá jie tsꞌóyánni chꞌán, a̱ ntá jeheni tsꞌáyéhe̱ni kaín tí nkehe a”, ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ntá xi̱kaha itsé sín chꞌán kꞌóyán sín chꞌán ntá kuakitsjexín sín nto̱e chꞌán tí no̱nte̱e chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","A̱ ntá kjuanchankí chꞌín Jesús ntáchro chꞌán kíxin: ―¿A̱ ntá nkehe chrókjuichꞌe tí ìnché tí nonte a? Chrókui chꞌán chrókꞌóyán chꞌán tí sín chꞌe xra̱, a̱ ntá chróchjéhe chꞌán ókjé chojni. ");
INSERT INTO poeNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Á kjui̱nchekuáxinhyará jahará tí xroon itén Dios? Ntáchro xi̱kihí: Tí xro̱ náxrjónhya kuíto̱enta tí sín chꞌéna tja̱tꞌo̱, mé jie kꞌóna tí xro̱ tjetoan. ");
INSERT INTO poeNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Mé xi̱kaha kjuíchꞌé Ìnchéni Dios, na ntá tíha mé ijnko nkehe kjuachrakon kꞌuíkonni ―ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ntá chrótsé sín tí chꞌín Jesús chrókjua̱kꞌe̱chji̱na sín chꞌán kíxin kíenxín sín kíxin kaín tí ntáchro chꞌán la jehe chꞌán kꞌuántaxínhi̱n tí jehe sín. Kjánchó chrakon sín kíxin nchónhya chojni kóchjina ntá kuíto̱he sín chꞌán ntá sákjuí sín. ");
INSERT INTO poeNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","A̱ ntá ichrꞌán sín iso tí sín fariseo la ko iso tí sín kuènte chꞌín Herodes kíxin tsjanchankíhi sín chꞌán iso nkehe kíxin tí ntoáhya chrókjuate̱he chꞌán ntá jína chrókꞌueka sín chꞌán jie̱. ");
INSERT INTO poeNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ntá kjuíji sín tí tjen chꞌín Jesús ntáchro sín kíxin: ―Maestro, ó noheni kíxin tí nkehe chro̱nka la chaxín tíha la ko jehya nkexrí tsjehe chojni tjenka̱yáxixián kíxin á jína sín, la ko ntoá tjàkua nti̱e Dios. ¿Á jína chrókjue̱nke̱heni tí gobierno tí chichaon tjanchia? ¿Á chrókjue̱nke̱heni sín ní o̱ náhí? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ntá chꞌín Jesús kjuátso̱an chꞌán kíxin jehya jína tjenka̱yáxin sín ntáchro chꞌán kíxin: ―Jehya jína kíxin tjácha̱xi̱nráni. Xráko̱ará ijnko tí chichaon tjanchia sín tsotsjáha̱ ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ntá xráka̱o sín ijnko tí chichaon tsotsjehe chꞌán. A̱ ntá kjuanchankí chꞌán kíxin: ―¿Nkexro tí tsíkꞌaxrjexín tjenkáni tí chichaon i la ko nkexro ihni̱é chónta? ―ichro chꞌán. Ntá jehe sín kjuáte̱he sín kíxin: ―Tí chꞌín tꞌe̱to̱an mé tjenkáni chꞌán ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Chróchje̱hérá tí chꞌín gobierno tꞌe̱to̱an tí nkehe kuènte chꞌán; a̱ ntá tí nkehe kuènte Dios la chróchje̱hérá Dios ―ichro chꞌán. Ntá chrakon sín kíxin xi̱kaha kjuáte̱he chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","A̱ ntá iso sín saduceo kuitsjehe sín tí chꞌín Jesús. A̱ ntá tí sín saduceo mé ntáchro sín kíxin chaxínhya tsoxechón chojni tsíkꞌen mé xi̱kaha chrókjua̱cha̱xi̱n sín tí chꞌín Jesús ntáchro sín kíxin: ");
INSERT INTO poeNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Maestro, chꞌín Moisés mé tsíkjin chꞌán xroon ntáchro kíxin tí tsꞌen ijnko sa̱vé chojni la ko na̱xa̱ tjen tí ichjién chꞌán na ko tsíkjichꞌénahya sín xje̱en sín ntá tí kíchó tí nkexro tsíkꞌen mé chrókuakja tí tjan kꞌán a̱ ntá tí xje̱en sín mé tsꞌóna éxí xje̱en tí nkexro tsíkꞌen. ");
INSERT INTO poeNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Kjánchó kꞌuéjó yato sín jnkoko̱á kíchó sín. Ntá tí chꞌín sa̱o mé kuákja chꞌán ichjién chꞌán. Ntá ikꞌuén chꞌán, kjánchó ninkehó xjan tsíkjichꞌénahya sín. ");
INSERT INTO poeNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ntá tí chꞌín tsoyo yóxin kuákja chꞌán tí tjan kꞌán ntá kꞌuén chꞌán koí chꞌán. Ntá kja̱xin tsíkjichꞌénahya sín xjan. A̱ ntá tí chꞌín níxin kuákja chꞌán tí jehe tjan ntá xi̱kaha kónhen ínaá. ");
INSERT INTO poeNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ntá kayatoé sín kꞌuéchónta sín tjan la ko kaín sín ikꞌuén sín la ko ninkehó xjan kjuíchꞌénahya sín kaín sín. Ntá kjuixixín ntá kꞌuén tjan kja̱xin tjan. ");
INSERT INTO poeNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ntá tió tsoxechón kaín xín chojni la, ¿Ntá nkexro tsꞌóna xìi tjan kíxin kayatoé sín tsíkóte̱he tjan? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Ntoáhya tjenka̱yáxinrá kíxin tiénxinhyará nkehe ntáchro tí xroon itén Dios la ko chonhyará tí kjua̱cha̱xién Dios. ");
INSERT INTO poeNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","A̱ ntá tió tsoxechón tí chojni tsíkꞌen la tso̱te̱ehya sín la ko tsjanjonhya sín xje̱en sín kíxin tso̱te̱he sín kíxin tí sín tsíkꞌen la éxí sín ángel tsꞌejó sín nkaya nka̱jní. ");
INSERT INTO poeNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","A̱ ntá tí tsoxechón tí sín tsíkꞌen, ¿á kjui̱nchekuáxinhyará tí xroon tsíkjin chꞌín Moisés chrónka nkexrí kꞌuénixje̱exín Dios ijnko nta yoa tjeche ntáchro chꞌán xi̱kihi: “Janhan mé tí Dios tinkáchónki chꞌín Abraham la ko chꞌín Isaac la ko chꞌín Jacob”? ");
INSERT INTO poeNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Méxra̱ tí Dios i la jehya tinkáchónki tí sín tsíkꞌen. Náhí. Jehe chꞌán mé Dios tinkáchónki tí sín tjejóchón. Ntá jahará la imá tiénxinhyará kíxin xi̱kaha ichrorá tjanchankírá ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ntá kui ijnko chꞌín tjako tí ley kjuákꞌekinhin chꞌán nkexrí kjua̱cha̱xi̱n sín chꞌín Jesús. Ntá kuínhin chꞌán kíxin imá jína kjuáte̱he chꞌín Jesús. Ntá kjuanchankí chꞌán ntáchro chꞌán kíxin: ―¿Nkehe tí a̱ntsí tjetoan tsíkꞌe̱to̱an Dios? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Tí nkehe a̱ntsí tjetoan tsíkꞌe̱to̱an Dios mé tíhi: “Tinhínrá kaín rá chojni Israel kíxin Ìnchéni Dios la mé jnkoko̱á la kohya í jnko nkexro. ");
INSERT INTO poeNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ntá kaín a̱sánrá la ko kaín kjuaxrexinkaon kuèntárá la ko kaín fuerza kuèntárá chrótjuèxínrá.” Mé xi̱kaha tí nkehe a̱ntsí tjetoan tsíkꞌe̱to̱an Dios. ");
INSERT INTO poeNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","A̱ ntá tí nkehe yóxin tsíkꞌe̱to̱an Dios la mé tóyóhe̱ na mé ntáchro xi̱kihí: “Chrótjuèhérá kíchuárá éxí tjuèxínrá a̱sánrá,” la kohya í jnko nkehe a̱ntsí má tjetoan tsíkꞌe̱to̱an chꞌán ―ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","A̱ ntá kjuáte̱he tí chꞌín tjako ni̱nko a ntáchro chꞌán kíxin: ―Ntoá ntáchrua tíha, Maestro kíxin chaxín itjen jnkoko̱áxón Dios la ko kohya í jnko Dios. ");
INSERT INTO poeNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Noheni kíxin kaín a̱sénni la ko kaín kjuaxrexinkaon kuènténi la ko kaín fuerza kuènténi chrótjuèxínni Dios la ko chrótjuèheni kíchó ni éxí tjuèxínni a̱sénni. Tíha mé a̱ntsí má sínkí. A̱ ntá kaín tí ko chrókꞌóyánni chrókjuanjonni chróchjánxin chrítaón altar la kánhyó tjetoan tíha ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","A̱ ntá tió kꞌuíkon chꞌín Jesús kíxin jína kjuenka̱yáxin chꞌán kjuáte̱he chꞌán ntá ntáchro chꞌán kíxin: ―Jaha la kjínhya tjen tí kjuachaxin kuènte Dios ―ichro chꞌán. Ntá kóxakonhen sín ntá ninkexró kjuanchankíehya sín chꞌán í so nkehe. ");
INSERT INTO poeNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ntá chꞌín Jesús kjuákꞌekjako chꞌán tí ni̱nko jié. Ntá kjuanchankí chꞌán ntáchro chꞌán kíxin: ―¿Nkexrí kíxin tí sín tjako tí ley mé ntáchro sín kíxin tí Cristo mé tsꞌaxrjeníxin tí chꞌín David? ");
INSERT INTO poeNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","A̱ ntá tí Ncha̱kuen Dios mé kjuínki̱tsa tí chꞌín David ntáchro chꞌán kíxin: Ìnchéni Dios ntáche tí Ìnchéni kíxin: “Tjakꞌe tjaná chjina ntihó tséto̱an, tsjixinjian kaín xín tí sín nínkakonhan la tsjachahya sín tsꞌe̱to̱an sín kíxin jahvá mé tséto̱an” ");
INSERT INTO poeNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","¿Xá nkexrí kíxin Cristo chrókꞌóna xje̱en chꞌín David kíxin jehe chꞌín David ntáchro chꞌán kíxin Ìnché chꞌán tí Cristo a? ―ichro chꞌán. Ntá itsjé chojni kꞌuéjókinhin sín kóxrjínhi̱n sín tí nkehe kjuako chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ntá chꞌín Jesús kjuako chꞌán ntáchro chꞌán kíxin: ―Tankíehyará tí sín tjako tí ley. Jehe sín mé tóxrjínhi̱n sín chrókꞌuinkáya sín ka kjínjin la ko tjinkaon sín kíxin kaín tí chojni tsoxeta sín nti̱a mé tsjikosáyehe sín. ");
INSERT INTO poeNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Jehe sín xritjeyá sín tí nta a̱ntsí náxrjón tsꞌejóyá sín tí nkaxenhen ni̱nko. La ko kja̱xin tió sátsji sín tí sine sín xritjeyá sín tí nta a̱ntsí náxrjón tsꞌejókjen sín sine sín. ");
INSERT INTO poeNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","La ko takitsje sín nto̱e chojni kꞌán. La ko chꞌiyexín sín chojni kíxin isé nixje̱he̱ sín Dios kíxin chrókuinhin chojni chróntáchro sín kíxin imá jína tí jehe sín. Tí sín a mé a̱ntsí má tsjasóte sín ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","A̱ ntá jnkonaá mé chꞌín Jesús tjetja̱xi̱n chꞌán nkaxenhen ni̱nko chókꞌèxin tjen tí ntacajón tjetóxroyéya ofrenda. Ntá tjetsjehe chꞌán kíxin nchónhya chojni tinkáki sín chrꞌáxenhen sín chichaon tí ntacajón. La ko kja̱xin nchónhya tí sín rico chrꞌáxenhen sín nchónhya chichaon tí ntacajón a. ");
INSERT INTO poeNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ntá kja̱xin ntiha mé kjui ijnko tjan kꞌán nòa tjan ntá chrꞌáxenhen tjan tí ntacajón yaá chichaon kánhyó tjete sínkí. ");
INSERT INTO poeNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ntá chꞌín Jesús kꞌuíye̱he̱ chꞌán tí sín kꞌuájiko chꞌán ntáchro chꞌán kíxin: ―Chaxín ntáxrja̱n kíxin tí tjan kꞌán nòa tjan a̱ntsí tjete kꞌuíkon Dios tí chichaon chrꞌáxenhen tjan tí ntacajón, a̱ ntá tí sín í so la kánhyó ");
INSERT INTO poeNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","kíxin kaín sín la ó chichaon xéhe̱ sín kjuanjon sín. Ntá jehe tjan la kjónté nòa tjan la kjuanjon tjan kaín tí chichaon kꞌuéchónta tjan chrókꞌuíte nkehe chrókjóne tjan ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","A̱ ntá tió kꞌuaxrjexín chꞌín Jesús tí ni̱nko jié ntá ijnko tí sín kꞌuájiko chꞌán ntáchro chꞌán kíxin: ―Maestro, kjuánchí náxrjón tí xro̱ la ko tí nchia tsíkꞌóna ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―¿Á tsjehé jaha tí nchia jié tsíkꞌóna ní? Tsjixraká tí ya̱on la í ninkehó xro̱ tsꞌejókjenhya kíchó, la kaín tíha la tso̱xika ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","A̱ ntá sákjuí sín chrítaón tí jna̱ Olivo chókꞌèxin tjen tí ni̱nko a. Ntiha kjuákꞌetja̱xi̱n chꞌín Jesús. Ntá ntiha chꞌín Pedro, la ko chꞌín Jacobo, la ko chꞌín Juan, la ko chꞌín Andrés kjuanchankíhi sín chꞌán nkehe, ntáchro sín kíxin: ");
INSERT INTO poeNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Tjinkaonni tso̱chro̱nka nkesá tso̱nhen tíha la ko nkexrí tso̱noexínni nkesá tsoxiteyá kaín tíha ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ntá chꞌín Jesús kjuáte̱he chꞌán ntáchro chꞌán kíxin: ―Tóxakonhanrá ti̱to̱éhyará kíxin ninkexró chrókjuitꞌayahyará. ");
INSERT INTO poeNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Nchónhya chojni tsi tsontáchro sín kíxin jehe sín mé Cristo. Ntá xi̱kaha sichꞌiyehe sín nchónhya chojni. ");
INSERT INTO poeNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’A̱ ntá tió tsinhínrá kíxin tjanjo̱nko kíchó sín la tꞌóyán kíchó sín la chrakonhyará tóxakuanhyará ó jehí tso̱nhen tíha. Kjónté xi̱kaha na̱xa̱ tsjeje̱hya chjasintajni. ");
INSERT INTO poeNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ijnko nación tsjanjo̱nko í jnko nación. La ntiha la ntaha la tsinkí nonte la ko itsjé chjasin na tso̱kjinta la ko tsꞌixité sín tso̱nínkaon sín. Tíha na ntá xrankíxixón tí kjuatjoté. ");
INSERT INTO poeNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Tóxakonhanrá jahará kíxin mé tsjikaánrá sín nkayakon tí sín tꞌe̱to̱an ntá tí nkaxenhen ni̱nko ntiha mé tsjatiaxínrá sín. Jahará tꞌichjánxi̱n tsochjinará tí tjejó tí sín gobernador la ko tí sín rey kíxin tinkachónkirá tí janhan; ntá tsjachará tso̱chro̱nka̱rá nkexrí tinkachónkirá tí janhan nkayakon tí jehe sín. ");
INSERT INTO poeNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Tí na̱xa̱ tsꞌitjáyanhya chjasintajni la mé tꞌichjánxi̱n tsinhin chojni kaín xín nación tí tan jína tsaáxin sín. ");
INSERT INTO poeNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Tió sátsjikoará sín tsjikaánrá sín tí tjejó tí sín tꞌe̱to̱an, la tóxakuanhyará nkehe tsjate̱herá la ko nkehe tsjenka̱yáxinrá. Náhí. Chro̱nka̱rá tí nkehe kjuanjon Dios tsontáchrorá tí hora a, kíxin jahyará tsonixjará. Náhí. Ncha̱kuen Dios mé tsonixja. ");
INSERT INTO poeNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Iso chojni kjónté na̱xa̱ kjéhya sín tsjikaán tí kíchó sín kíxin itsꞌen. La ko kja̱xin xi̱kaha iso chojni tsjikaán tí xje̱en sín la ko kja̱xin iso sín tso̱nínkakonhen sín tí itꞌé la ko ìné la tsjikaán sín kíxin itsꞌen. ");
INSERT INTO poeNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kaínxín chojni chjasintajni tso̱nínkakonhanrá sín kíxin tinkachónkirá tí janhan. A̱ ntá tí sín tsíto̱ehya tinkáchónki sín tí janhan hasta tsjixixín ná mé tsaá sín. ");
INSERT INTO poeNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Tsjixraká ijnko ya̱on tsꞌikonrá tsjakꞌe tí nkehe jínahya tí chrókjuakꞌehya éxí tsíntáchro profeta Daniel ―ntá tí chojni sinchekuáxin tí xroon i mé chrókuienxín sín tíha―, a̱ ntá tí chojni tjejó estado Judea tsꞌikon sín xi̱kaha la sátsji sín tsochrìin sín jna̱ tsjíkꞌejómá sín. ");
INSERT INTO poeNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","A̱ ntá tí sín tjejó chrítaón nchia la í chrókꞌuínkajinhya sín, chrókꞌuixenhya sín nkaxenhen nchia chrókuakitsje sín ichrén nkehe chónta sín. ");
INSERT INTO poeNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ntá tí sín tjejó no̱nte̱e sín la í chrókjanhya sín na̱xa̱ chrókjuikakja sín iké sín. ");
INSERT INTO poeNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ntá nòa tí chojni chjin tsꞌejóyá tí ya̱on a la ko tí sín tjejónchekakí xje̱en. ");
INSERT INTO poeNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Chrókjuanchehérá Dios kíxin jehya ncha̱kuen kin chrókónhen tíha. ");
INSERT INTO poeNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","A̱ ntá tí ya̱on a mé imá kjuaxróxinhya tsꞌejó chojni kíxin ninkehó ya̱on kuènhya xi̱kaha desde ti kjuankíxixín Dios kjuíchꞌéna chꞌán chjasintajni la ko kjá xi̱kahya tso̱nhen chrꞌéxi̱n ínaá. ");
INSERT INTO poeNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","A̱ ntá tí chrókjuanjon Ìnchéni Dios kjuachaxin kíxin isé chrókónhen tíha, ntá ninkexró chrókjuacha chrókuaá. A̱ ntá náhí la kui̱konóe̱he̱ chꞌán tí sín tsíkjeyá chꞌán ntá kꞌue̱to̱an chꞌán kíxin tjoka tsꞌatsínka tí kjuachrakon a. ");
INSERT INTO poeNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’A̱ ntá jnkojín nkexro tsontáchro kíxin: “Tsjehé, ntihi itjen tí Cristo”, o̱ tsontáchro sín kíxin: “Tsjehé, ntiha tjen chꞌán”, la títekákuènhyará sín. ");
INSERT INTO poeNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Na mé itsi iso sín tsontáchro sín kíxin Cristo tí jehe sín la ko kja̱xin itsi iso sín ntoáhya tsjako sín la ko tsjasin sín kjuaxroan jié tjinkaon sín chrókjuichꞌiyexín sín chojni, kjónté tí sín tsíkjeyá Dios. ");
INSERT INTO poeNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","A̱ ntá jahará chrokóxakonhanrá kaín tíha. Tjétjo̱nka̱rá senó kíxin tso̱nohará kíxin xi̱kaha tso̱nhen. ");
INSERT INTO poeNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Ntá tsꞌatsínka tí kjuachrakon la ntá tí ya̱on la tsꞌinkaséyanhya, a̱ ntá tí nitjó la tsjanjonhya xrohi. ");
INSERT INTO poeNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","A̱ ntá tí konotsé la tsꞌanótje̱nxi̱n nka̱jní la ko tí kjuachaxin siín nkaya nka̱jní la kja̱xin tsinkí. ");
INSERT INTO poeNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ntá tsꞌikon sín tí Xje̱en Dios Kꞌóna Chojni itsi chríkjan tjui̱ tsi̱ka̱o tí kjuachaxin jié. ");
INSERT INTO poeNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ntá tsochrꞌán chꞌán tí sín ángel sátsji sín kuenté chjasintajni tsjikjenájín sín kaín chojni tsíkjeyá chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Chrókiénxinrá tí nkehe si̱ntayóa̱xian. Éxí yóhe̱ tí nta tꞌóna to higo tió sítꞌayan kahnte̱ ntá nohará kíxin tsꞌixenhen ncha̱kuen sóa ");
INSERT INTO poeNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","mé xi̱kaha tió tsꞌikonrá xi̱kaha tso̱nhen kaín tíha ntá tso̱noaxínrá kíxin ó kuichjina tí tsjeje̱ chjasintajni. ");
INSERT INTO poeNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Chaxín ntáxrja̱n kíxin kaín tíha tso̱nhen tí na̱xa̱ tꞌenhya tí chojni siín chjasintajni. ");
INSERT INTO poeNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","A̱ ntá tí nka̱jní la ko tí chjasintajni mé tsꞌitjáyan. A̱ ntá tí nkehe ntáxrja̱n la tsꞌitjáyanhya, tsoxiteyá tíha. ");
INSERT INTO poeNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’A̱ ntá tí ya̱on la tí hora tsoxiteyá tíha la ninkexro noehya. Kja̱xin noehya tí sín ángel tjejó nkaya nka̱jní la ko kja̱xin tí Xje̱en Dios Kꞌóna Chojni la noehya. Ó jehó Itꞌéni mé nohe. ");
INSERT INTO poeNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Méxra̱ chrókꞌuejotsjehérá, chrókꞌuejochonhénrá chrónixje̱hérá Dios kíxin noahyará nkesá la ko nkehora tso̱nhen tíha. ");
INSERT INTO poeNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Éxí yóhe̱ ijnko chojni sátsji kjín, a̱ ntá tí na̱xa̱ sátjixínhya chꞌán nto̱e chꞌán la senó tsochjéhe chꞌán xra̱ tí sín chꞌehe chꞌán xra̱ tsꞌayakonhen sín nto̱e chꞌán, la jnkojnko sín tsꞌáyéhe̱ sín jnkojnko xra̱ kuènte sín. La ko tsꞌe̱tue̱nhen chꞌán ijnko chꞌín tsjakꞌe tsꞌayakonhen chꞌán tí ntója nchia. ");
INSERT INTO poeNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Méxra̱ jahará chrókꞌuejotsjehérá kíxin noahyará nkesá tsokjan tí ìnché tí nchia a, á ijnko tso̱ntanonte o̱ á ijnko kꞌáxrótjen o̱ á ijnko tje̱te̱e tsje cochíká o̱ á ijnko tsꞌinkaséyan. ");
INSERT INTO poeNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ntá xrína̱hya tsi chꞌán tsꞌitjaxín chꞌán kíxin tjejochrinrá. ");
INSERT INTO poeNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Mé xi̱kaha tjo̱nka̱rá la ko xi̱kaha ntátjan kaín chojni kíxin chrókꞌuejótsjehe sín ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Na̱xa̱ tꞌitjáyan iyó ya̱on ntá tsjasin sín tí kia pascua, la ko sine sín tí nio̱tja̱ tsíkjikohya tí xro̱a̱n nchekꞌánkí nio̱tja̱. Ntá tí sín ncha̱tꞌá tꞌe̱to̱an la ko tí sín maestro tjako tí ley mé kjueyá sín kíxin nkexrí sichꞌiyehe sín tí chꞌín Jesús kíxin tsotsé sín chꞌán a̱ ntá tsꞌóyán sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ntá ntáchro sín kíxin: ―Kjánchó jehya ya̱on kia chrókónhen tíha kíxin chrókꞌuixitéhya chojni chrókónínkaon sín ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","A̱ ntá chꞌín Jesús kjuákꞌe chꞌán chjasin Betania nto̱e chꞌín Simón, tí chꞌín kꞌuéchónta chinlepra. A̱ ntá tí tjene chꞌín Jesús ntá xrína̱hya ikui ijnko tjan kui̱ka̱o tjan ijnko xro̱ mé tjiá tí aceite xraxé itsjo nardo, imá tjete tsíkꞌite. Ntá tí tjan a mé kuakitje̱he̱ tjan tí xro̱ a ntá kui̱ki̱te tjan kja chꞌín Jesús tí aceite a. ");
INSERT INTO poeNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","A̱ ntá iso tí sín tjejó ntiha kónínkakonhen sín tjan ntáchro sín kíxin: ―¿Nkekuènte kjuínchexénhen tjan tí aceite náxrjón xraxé? ");
INSERT INTO poeNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Íchá jína chrókóxi̱xi̱n iní ciento chichaon denario tí aceite a ntá tí chichaon a mé chrókui̱to̱nhe̱n tí chojni nòa ―mé xi̱kaha ichro sín kꞌuántaxínhi̱n sín tjan. ");
INSERT INTO poeNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ntá ntáchro chꞌín Jesús kíxin: ―Nté ti̱to̱hérá tjan; ¿nkekuènte tꞌantaxínhínrá tjan? Ó ncho̱xon tí nkehe kjuíchꞌena tjan. ");
INSERT INTO poeNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","A̱ ntá tí chojni nòa la ó xráxín tsꞌejókoará sín la jína tsjínki̱tsará sín jnkojín ya̱on. Ntá janhan la jnkochríxínhya tsꞌejóni. ");
INSERT INTO poeNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ntá jehe tjan kjuíchꞌe tjan kaín nkehe tjinkaon tjan tsjanjon tjan. Ó senó kjuíncheka tjan xro̱a̱n cuerpo kuènta̱na kíxin tsoxravána. ");
INSERT INTO poeNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Chaxín ntáxrja̱n kíxin ti tsjako sín tí tan jína tsaáxin chojni nkuíxín chjasintajni ntá tsochronka sín kíxin xi̱kaha kjuíchꞌe tí jehe tjan, a̱ ntá xi̱kaha tsoxraxinkakonxín sín tjan kíxin xi̱kaha kjuíchꞌe tjan ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","A̱ ntá chꞌín Judas Iscariote mé ijnko teyóxin sín kꞌuájiko chꞌín Jesús a mé sákjuítsjehe chꞌán tí sín ncha̱tꞌá tꞌe̱to̱an kíxin tsochrónka chꞌán nkexrí tsotsé sín tí chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","A̱ ntá jehe sín la chéhe̱ sín kuínhin sín ntá ntáchro sín kíxin chaxín tsjanjon sín chichaon tsꞌáyéhe̱ tí chꞌín Judas. Ntá kjuankíxin chꞌán kjueyá chꞌán nkexrí tsochrónka chꞌán kíxin tsotsé sín tí chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","A̱ ntá kui tí ya̱on xrankíxixín kia sine sín nio̱tja̱ tsíkjikohya tí xro̱a̱n nchekꞌánkí nio tió tsꞌóyán sín tí kolélo kuènte kia pascua. A̱ ntá tí sín kꞌuájiko chꞌín Jesús mé kjuanchankíhi sín chꞌán kíxin: ―¿Nketí tjinkávan sátsjini sincheyaxíxinni kíxin sineni kuènte tí kia pascua? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ntá kꞌue̱tue̱nhen chꞌán iyó tí sín kꞌuájiko chꞌán ntáchro chꞌán kíxin: ―Sátjirá chjasin Jerusalén ntá ntiha tsoxetará ijnko chꞌín yámá tóa tjiá nta̱. Tí chꞌín a tsochréhérá. ");
INSERT INTO poeNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","A̱ ntá tí nchia tsꞌixenhen chꞌán la tsjanchankíhírá tí ìnché nchia, tsontáchrorá kíxin: “Kꞌue̱to̱an tí Maestro kíxin: ¿Nketí tjen tí cuarto sinexínko chꞌán tí sín xriko chꞌán tí kia pascua a?”, xi̱kaha mé tsixrorá. ");
INSERT INTO poeNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ntá tsja̱ko̱hará chꞌán ijnko cuarto jié, yóxin piso mé chónta kaín nkehe tꞌichjánxi̱n. Mé ntaha mé si̱ncheyaxíxinrá tí nkehe sineni ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ntá jehe sín la sákjuí sín chjasin Jerusalén na ntá éxí chrónka chꞌín Jesús mé xi̱kaha kꞌuitja sín. Ntá tí cuarto a mé kjuíncheyaxíxin sín tí nkehe sine sín kuènte tí kia pascua. ");
INSERT INTO poeNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","A̱ ntá ó kóntó ntá ó kjuíji chꞌín Jesús la ko tí teyó sín kꞌuájiko chꞌán tí nchia ntiha. ");
INSERT INTO poeNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ntá kꞌuéjó sín, a̱ ntá tió tjejóne sín ntá ntáchro chꞌín Jesús kíxin: ―Chaxín ntáxrja̱n kíxin ijnko tí jahará tjejóne jnkoko̱á ntihi mé sinchekjiráni ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ntá jehe sín mé kjuankíxin kꞌuává sín. Ntá kjuankíxin sín jnkojnko kjuanchankíhi sín tí jehe chꞌán kíxin: ―¿Á janhan ní? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Jehe chꞌán mé ijnko tí teyóxinrá, mé tí nkexro tjene̱kian jnkoko̱á plato ntihi. ");
INSERT INTO poeNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Chaxín tí Xje̱en Dios Kꞌóna Chojni mé tso̱nhen éxí nixja xroon itén Dios. Kjánchó nòa tí chꞌín sinchekji chꞌán. Íchá jína tí chꞌín a la chrókokjíehya chꞌán ―mé xi̱kaha ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","A̱ ntá nachrohe tjejóne sín na chꞌín Jesús kuákja chꞌán ijnko nio̱tja̱, ntá kjuanchia chꞌán kjuasáyé Dios. Ntá kjuixin ntá kóchrítꞌo̱ chꞌán tí nio̱tja̱ ntá kjuanjon chꞌán kꞌuáyéhe̱ sín. Ntá ntáchro chꞌán kíxin: ―Interá, tíhi mé cuerpo kuènta̱na ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Na ntá kja̱xin kuákja chꞌán ijnko vaso na ntá kjuanchia chꞌán kjuasáyé Dios ntá chjéhe chꞌán sín ikꞌuí sín kaín sín tí nkehe tjiá. ");
INSERT INTO poeNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ntá ntáchro chꞌán kíxin: ―Tíhi mé jni̱na mé chrónkaxín kíxin chaxín tsoxiteyá tí nkehe ni̱xin tso̱nhen na mé tsꞌitjí kíxin tsaáxin nchónhya chojni. ");
INSERT INTO poeNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Chaxín ntáxrja̱n kíxin tsꞌíhya janhan tí ìnté to uva ínaá tí na̱xa̱ tsjixrakáhya tí ya̱on itsi kjuachaxin kuènte Dios, a̱ ntá ti ya̱on a xikꞌía ìnté to uva ni̱xin ―mé xi̱kaha ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ntá kjuixin itsje sín ijnko himno kuènte Dios ntá sákjui̱ sín tí jna̱ Olivo. ");
INSERT INTO poeNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ntá chꞌín Jesús ntáchro chꞌán kíxin: ―Ijie tie kaín rá tsochrakonrá ntá tsi̱to̱nará. Ntá tsoxiteyá éxí ntáchro xroon iten Dios kíxin: “Tsꞌóyán sín tí nkexro tꞌayakonhen tí kolélo ntá tso̱kohya nkexro tsꞌayakonhen va, a̱ ntá tsjichroe va.” ");
INSERT INTO poeNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","A̱ ntá tió tsoxechónna ntá sátsjia estado Galilea ntá ntiha tsoxetani ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ntá ntáchro chꞌín Pedro kíxin: ―Kjónté kaín sín tsíto̱ha sín ntá janhan la náhí ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ntá ntáchro chꞌín Jesús kíxin: ―Chaxín ntáxrja̱n kíxin ijie tie tí na̱xa̱ tsjehya kochínto̱a yáya, la jaha mé si̱nchemána níya kíxin chonhyana, tsixrua ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ntá itsen kjuáte̱he chꞌín Pedro ntáchro chꞌán kíxin: ―Kjónté koína itsꞌén la si̱ntamáhya tí jaha ―ichro chꞌán. La ko xi̱kaha ntáchro sín kaín sín. ");
INSERT INTO poeNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ntá kjuíji sín ijnko nonte mé itꞌin Getsemaní. Ntá kꞌue̱tue̱nhen chꞌín Jesús tí sín kꞌuájiko chꞌán kíxin: ―Tjejorá ntihyó nachrohe janhan tsonixja̱ha̱ Dios ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ntá sákjuíko chꞌán tí chꞌín Pedro la ko tí chꞌín Jacobo la ko tí chꞌín Juan. Ntá kjuankíxin imá kꞌuává a̱sén chꞌán kóxakonhen chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ntá ntáche chꞌán sín kíxin: ―Imá tꞌává a̱senná éxí chrókꞌuén xi̱kaha. Ijie la ntihyó tito̱hará tjejotsjehérá ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ntá sákjuí chꞌán ijnko kjínhya ntá kjuákꞌexín tochꞌin chꞌán. Ntá kjuankíxin chrónóe̱he̱ chꞌán Dios kíxin chrókjuanjon chꞌán kjuachaxin kíxin chrókjuasótehya chꞌán tí nkehe chrókónhen chꞌán tí ya̱on a. ");
INSERT INTO poeNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","A̱ ntá ntáchro chꞌán kíxin: ―Itꞌéni jaha. Jaha mé chonta kaín xín kjuachaxin na ntá chrónóa̱hani tsjakjínhínni kaín tí jínahya tso̱nhenni tsjasóteni jie. Jehya kíxin chrókónhen éxí tjinkaonni jeheni. Náhí. Éxí tjinkávan jaha ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ntá kjan chꞌán ntá kꞌuitjaxín chꞌán tí sín kuíto̱he la tjejójua sín. Ntá ntáche chꞌán tí chꞌín Pedro kíxin: ―Simón, tjechrian jaha. ¿Xá xitjahya chrókjuakꞌetsjehé ijnko hora? ");
INSERT INTO poeNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ijie la tjejotsjehérá la ko chronóe̱hérá Dios kíxin títo̱ehya chꞌán tí Jínahya chrókjuichroerá. Tí a̱sánrá ntáchro kíxin chrókjui̱nchexiteyárá tí jína kjánchó tí cuérpo̱rá la tsjachahya ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ntá sákjuí chꞌán ínaá chrónóe̱he̱ chꞌán Dios. Ntá ó jehe xi̱kahó xínixja chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ntá ikjan chꞌán la ó tjejójua sín ínaá kíxin kui̱hi̱ sín kotáchrin. Ntá í noehya sín nkexrí chrókjuate̱he sín. ");
INSERT INTO poeNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ntá níxin sáxíkji chꞌán ntá kjan chꞌán ntá ntáchro chꞌán kíxin: ―A̱ ntá jie tjejochrinrá tꞌo̱kꞌáhará. Ntá ó tjen. A̱ ntá jie kjuixraká tí hora kíxin tí Xje̱en Dios Kꞌóna Chojni tsꞌáyéhe̱ tí sín chónta jie̱ sinchekjasóte sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ntá tꞌàyará sátsjini kíxin ó kjui tí nkexro sinchekjina. ");
INSERT INTO poeNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Na̱xa̱ tjenixja chꞌín Jesús ntá xrína̱hya kjuíji chꞌín Judas, mé ijnko tí teyóxin sín kꞌuájiko chꞌín Jesús. Nchónhya chojni kjui̱ka̱o chꞌán kjuíjiko sín chica espada la ko inta. Na mé kjua̱cha̱xién tí sín ncha̱tꞌá tꞌe̱to̱an la ko tí sín maestro tjako tí ley la ko tí sín táda tꞌe̱to̱an ni̱nko mé kjui̱xi̱n sín. ");
INSERT INTO poeNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","A̱ ntá tí chꞌín Judas mé tí chꞌín sinchekji tsíntáchro chꞌán kíxin: ―Tí chꞌín sine̱kian kochíto mé jehe tíha la itse̱rá chꞌán sátjikoará chꞌán ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ntá kjui sín ntá tuénxín kóchjinehe chꞌín Judas tí chꞌín Jesús ntá ntáchro chꞌán kíxin: ―Maestro, Maestro ―ichro chꞌán. Na ntá kjóneko chꞌán kochíto. ");
INSERT INTO poeNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","A̱ ntá tí sin kjuíji mé tsé sín tí chꞌín Jesús, sákjuíko sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","A̱ ntá ijnko chꞌín tjentaxín ntiha mé kuakitsje chꞌán chica espada kóchrínjin chꞌán ta̱tsjon tí chꞌín chꞌehe tí ncha̱tꞌá tꞌe̱to̱an xra̱. ");
INSERT INTO poeNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ntá chꞌín Jesús mé ntáche chꞌán tí sín a kíxin: ―¿Nkekuènté kíxin éxí chrótse̱rá xíche̱e mé xi̱kaha kꞌuinkakoará chica espada la ko inta kíxin tso̱tse̱ráni? ");
INSERT INTO poeNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kaín ya̱on kjuakꞌé nkaxenhen ni̱nko kjuákohará, ¿ntá nkekuènté tse̱hyaráni? Kjánchó tꞌichjánxi̱n xi̱kaha tso̱nhen kíxin tsoxiteyá tí nkehe nixja xroon itén Dios ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ntá kaín tí sín kꞌuájiko chꞌán na mé kuíto̱he sín chꞌán jehó chꞌán ntá sákjuí sín. ");
INSERT INTO poeNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","A̱ ntá ijnko chꞌín ntasoá mé kja̱xin tinkáchréhe̱ chꞌán ntiha, a̱ ntá jehó ijnko kamantá tjetsáte chꞌán, ntá kja̱xin itsé sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Kjánchó tí ké chꞌán ó tsítsé sín ntá kjónté tjóchín chꞌán sákjuí chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ntá sákjuíko sín tí chꞌín Jesús tí nto̱e tí ncha̱tꞌá imá tꞌe̱to̱an. Ntaha mé tsíkójnkotsé kaín tí sín ncha̱tꞌá tꞌe̱to̱an la ko tí sín táda tꞌe̱to̱an ni̱nko la ko tí sín maestro tjako tí ley. ");
INSERT INTO poeNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ntá chꞌín Pedro la ikjín tjechréhe̱ chꞌán ntá kjuíji chꞌán tí nta̱sin nto̱e tí ncha̱tꞌá imá tꞌe̱to̱an a. Ntaha síche xrohi. A̱ ntá ntiha tjejótja̱xi̱n tí sín policía tjejóchjíxro̱he sín, ntá kja̱xin chꞌán ntahó kuíto̱he chꞌán tjechjíxro̱he chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ntá tí sín tꞌe̱tue̱nhen tí sín ncha̱tꞌá la ko kaín tí sín tꞌe̱to̱an kjueyá sín chojni kíxin tsochrónka sín nkehe tí jie̱ chónta chꞌín Jesús kíxin jína chrókꞌóyán sín chꞌán. Kjánchó ninkexró kꞌuitjahya sín tsjinki̱tsa tsochrónka. ");
INSERT INTO poeNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Kjánchó itsjé sín ntáchro sín kjuachꞌia ó tꞌeka sín chꞌán jie̱ kíxin jnkokónhya tí nkehe ntáchro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ntá kꞌuínkatjen iso sín ntá chaxínhya tí jie̱ kjuanchia sín. Ntá ntáchro sín kíxin: ");
INSERT INTO poeNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Jeheni ó kuínhinni kíxin ntáchro chꞌán kíxin tsꞌóxíka chꞌán tí ni̱nko tsíkjichꞌénaxín chojni tja ntá iní ya̱on koá la ó tsjakꞌe chꞌán í jnko ni̱nko jehya chojni sichꞌéna ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Kjónté xi̱kaha la jnkokónhya tí nkehe chrónka sín. ");
INSERT INTO poeNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ntá tí chꞌín tꞌe̱tue̱nhen tí sín ncha̱tꞌá kꞌuínkatjen chꞌán tí tjejó kaín sín ntá kjuanchankíhi chꞌán tí chꞌín Jesús kíxin: ―¿Á ninkehó tjate̱ehya jaha? ¿Á chaxín tí jie̱ tꞌeka sín tí jaha? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ntá chꞌín Jesús tání chꞌán la ninkehó tjate̱ehya chꞌán. Ntá xíkjanchankí tí ncha̱tꞌá tꞌe̱to̱an ntáchro chꞌán kíxin: ―¿Á jaha tí Cristo Xje̱en Dios imá tjóá? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ntá ntáchro chꞌín Jesús kíxin: ―Chaxín janhan tíha. Ntá chrꞌéxi̱n tsꞌikonrá kíxin tí Xje̱en Dios Kꞌóna Chojni mé tsjakꞌetja̱xi̱n chꞌán tí tja chjina kjuachaxin kuènte Dios la ko itjui̱ mé tsꞌinkaji̱nxi̱n chꞌán nkaya nka̱jní ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","A̱ ntá tí ncha̱tꞌá tꞌe̱to̱an kótséchje chꞌán tí iké chꞌán kjua̱ko̱xi̱n chꞌán kíxin imá nínkaon chꞌán ntáchro chꞌán kíxin: ―Tꞌichjánxi̱nhya í so chojni tsochrónka nkehe. ");
INSERT INTO poeNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Jahará ó kuínhínrá kíxin kꞌuántaxínhi̱n chꞌán Dios. ¿Ntá nkehe tsixrorá? ―ichro chꞌán. Ntá kaín sín kjuáte̱he sín kíxin chrókꞌuen chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ntá ikjé sín la kjuankíxin sín kui̱ki̱te sín chꞌán nta̱te sín. Na iso sín na kꞌuíkjehe̱ sín ikon chꞌán na ntá kjuate sín chꞌán na ko kjuanchankíhi sín chꞌán kíxin: ―Tónoha kíxin nkexro kjuatia ―ichro sín. A̱ ntá tí sín policía kuènte ni̱nko chjéhe sín nkayakon chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ntá tí nta̱sin nonte itjen chꞌín Pedro. Ntá ikui ijnko tjan chꞌehe tjan xra̱ tí ncha̱tꞌá tꞌe̱to̱an. ");
INSERT INTO poeNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ntá kꞌuíkon tjan kíxin tjechjíxro̱he chꞌín Pedro. Ntá komá tjan chꞌán ntá ntáchro tjan kíxin: ―Jaha la kja̱xin xrikoa tí chꞌín Jesús kjui̱xi̱n chjasin Nazaret ―ichro tjan. ");
INSERT INTO poeNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ntá chꞌín Pedro kjuínchemá chꞌán ntáchro chꞌán kíxin: ―Chonhya chꞌán la ko nonahya tí nkehe ntáchrua ―ichro chꞌán. Ntá kꞌuaxrjexín chꞌán ntiha sákjui chꞌán ntója. Ntá xrína̱hya itsje ijnko kochínto̱a. ");
INSERT INTO poeNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ntá tí tjan a mé kꞌuíkon tjan tí jehe chꞌán ntá chénka tí sín síntaxín ntaha kíxin: ―A̱ ntá tí chꞌín i mé jnkojín tí sín a ―ichro tjan. ");
INSERT INTO poeNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Kjánchó kjuínchemá chꞌán ínaá. Ntá a̱ntsí chrꞌéxi̱n tí sín kꞌuéjóntaxín ntáche sín tí chꞌín Pedro kíxin: ―Chaxín kja̱xian jaha tsíkjíxian estado Galilea kíxin tjatso̱anxínni kíxin nixja jaha éxí nixja tí jehe sín ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ntá chꞌín Pedro kjuankíxin chꞌán kjuínchenohe chꞌán Dios ntáchro chꞌán kíxin: ―Chonhya tí chꞌín ntáchrorá jahará ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ntá yóxin itsje kochínto̱a. Ntá chꞌín Pedro mé xraxinkaon chꞌán kíxin nkexrí ó chrónka chꞌín Jesús kíxin: “Na̱xa̱ tsotsjehya kochínto̱a yáya mé ó tsjixin si̱nchemána níya kíxin chonhyana.” Ntá xraxinkaon chꞌán tíha la ntá kjuankíxin chꞌán tsjánka chꞌán kíxin ntoáhya kjuíchꞌe chꞌán kjuínchemá chꞌán tí chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","A̱ ntá ó kꞌuínkaséyan ntá tí sín ncha̱tꞌá tꞌe̱to̱an kójnkotséko sín tí sín táda la ko tí sín tjako tí ley la ko kaín tí sín tꞌe̱to̱an kuènte ni̱nko mé kójnkotsé sín ikjo kíchó sín. Ntá kjuixin ntá kjuínchenteto sín tí chꞌín Jesús ntá kjuíkaán sín chꞌán tí tjen tí chꞌín Pilato. ");
INSERT INTO poeNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ntá tí chꞌín Pilato mé kjuanchankí chꞌán ntáchro chꞌán kíxin: ―¿Á jaha tí Rey kuènte tí sín judío? ―ichro chꞌán. Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Kja̱xian jaha ntáchrua ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","A̱ ntá tí sín ncha̱tꞌá tꞌe̱to̱an mé kꞌueka sín chꞌán nchónhya jie̱. ");
INSERT INTO poeNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ntá chꞌín Pilato xíkjanchankí chꞌán ínaá ntáchro chꞌán kíxin: ―¿Jaha, nkekuènté tjate̱ehya ninkehó? Tsjehé kíxin nchónhya jie̱ tꞌeka sín tí jaha ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","A̱ ntá chꞌín Jesús la ninkehó kjuáte̱ehya chꞌán. Ntá chꞌín Pilato la í noehya chꞌán nkehe tsjenka̱yáxin chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","A̱ ntá chꞌín Pilato mé kuènhen chꞌán kíxin tí kia a tsjanjon chꞌán kjuachaxin kíxin sátsji ijnko chojni tjechjina, éxí tjinkaon tsjanchia tí sín tsíkójnkotsé tí kia a. ");
INSERT INTO poeNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","A̱ ntá ntiha tjechjina ijnko chꞌín mé itꞌin Barrabás, la ko í so sín kuítekakuenhya sín tí síxre̱é ntá kꞌóyán sín chojni. ");
INSERT INTO poeNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ntá kui nchónhya chojni kjuankíxin sín kjuanchehe sín tí chꞌín Pilato kíxin chrókjuichꞌe chꞌán éxí kaín nánó xi̱kaha. ");
INSERT INTO poeNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ntá kjuáte̱he chꞌín Pilato kíxin: ―¿Á tjinkáonrá tsi̱to̱ha̱ sátsji tí chꞌín Rey tꞌe̱tue̱nhen tí sín judío? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Mé xi̱kaha ichro chꞌán kíxin jehe chꞌán la ó nohe chꞌán kíxin kjuachji̱no̱xínhin xriko tí sín ncha̱tꞌá tꞌe̱to̱an, a̱ ntá tsé sín tí chꞌín Jesús kjuíkénhen sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","A̱ ntá tí sín ncha̱tꞌá tꞌe̱to̱an a mé kjuínchekóninkaon sín kaín tí chojni siín, ntáche sín kíxin íchá jína chrókjuanchia sín kíxin chrókꞌuatjánta chꞌán tí chꞌín Barrabás. ");
INSERT INTO poeNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ntá chꞌín Pilato kjuanchankí chꞌán ntáchro chꞌán kíxin: ―A̱ ntá tí chꞌín tíki̱texínrá kíxin chꞌín Rey tꞌe̱tue̱nhen tí sín judío la ¿nkehe tjinkáonrá si̱tꞌaha̱ chꞌán? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ntá jehe sín kjuáte̱he sín kꞌóyako sín kjuanchia sín kíxin: ―¡Tjakénka̱nia chꞌán ntacruz! ");
INSERT INTO poeNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ntá chꞌín Pilato mé kjuanchankíhi chꞌán tí jehe sín kíxin: ―¿Xá nkehe tí jínahya kjuíchꞌe chꞌán? ―ichro chꞌán. Kjánchó a̱ntsí má itsen kꞌóyako sín kjuanchia sín kíxin: ―¡Tjakénka̱nia chꞌán ntacruz! ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ntá chꞌín Pilato mé tjinkaon chꞌán sinchexiteyá chꞌán tí nkehe kjuanchia tí sín kꞌuíxité ntá kuíto̱he chꞌán kíxin sátsji tí chꞌín Barrabás. Ntá kꞌue̱to̱an chꞌán kíxin tsjate sín tí chꞌín Jesús. Ntá kjuixin ntá kjuanjon chꞌán kjuachaxin kíxin tí sín soldado sátsjiko sín chꞌán tsja̱kꞌe̱nka̱ni sín chꞌán ntacruz. ");
INSERT INTO poeNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ntá tí sín soldado a mé sákjuíko sín chꞌán tí nta̱sin tí palacio. Ntaha kójnkotséxin kaín tí sín soldado. ");
INSERT INTO poeNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ntá ntiha kuakitsje sín iké chꞌán ntá kjuínchekꞌinkáya sín chꞌán ijnko ka kjátse tié la ko kjua̱kꞌe̱nka̱ya sín kja chꞌán ijnko corona tsíkꞌóna ntachꞌi̱. ");
INSERT INTO poeNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ntá kjuankíxin kꞌuíxité sín ntáchro sín kíxin: ―Jnkochríxín tsjakꞌe tsétue̱nhén tí sín judío ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Na ntá ntavara chjéhe sín ikja chꞌán na ko nta̱té sín kui̱ki̱te sín chꞌán. Kꞌuéjóxin tochꞌin sín nkayakon chꞌán kjuíchꞌeyáxixín sín éxí imá chrókjuikosáyehe sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ntá tió kjuixin xi̱kaha kjuíchꞌehe sín chꞌán kjuanoá sín chꞌán ntá kuakitsjehe sín chꞌán tí ka kjátse tié tsíkjinchekꞌinkáya sín chꞌán ntá kjuínchekꞌinkáya sín chꞌán iké chꞌán xráxín ínaá. Ntá kuakitsjexín sín chꞌán ntiha sákjuíko sín chꞌán kíxin ntá tsja̱kꞌe̱nka̱ni sín chꞌán ntacruz. ");
INSERT INTO poeNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","A̱ ntá ijnko chꞌín tsíkji̱xi̱n chjasin Cirene, mé itꞌin chꞌán Simón, mé xje̱en chꞌán mé tí chꞌín Alejandro la ko tí chꞌín Rufo, mé tsíkji̱xi̱n chꞌán no̱nte̱e chꞌán, ntá kꞌuátsínka chꞌán ntiha. Ntá tí sín soldado a mé kꞌue̱tue̱nhen sín chꞌán kíxin tsochréhe̱ chꞌán tsamá chꞌán tí ntacruz tsjakꞌenkáni chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","A̱ ntá sákjui̱ko sín tí chꞌín Jesús ijnko tjo itꞌin Gólgota, na mé nkíve̱e sín tꞌaxrjexín kíxin Tjo Calavera. ");
INSERT INTO poeNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ntá ntiha chjéhe sín chꞌán xranvino tsíkꞌixinkíkjanxín xro̱a̱n mirra chrókꞌui chꞌán, kjánchó kꞌuíhya chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ntá tí sín soldado kjua̱kꞌe̱nka̱ni sín chꞌán tí ntacruz a. Kjuixin ntá kjuíchꞌexín sín suerte tí ké chꞌán kíxin tso̱nohe sín nkexéhe tí ka sátsjiko sín jnkojnko sín. ");
INSERT INTO poeNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","A̱ ntá ó las nueve nchítjen tí kjua̱kꞌe̱nka̱ni sín chꞌán tí ntacruz a. ");
INSERT INTO poeNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ntá ikja tí ntacruz kjua̱kꞌe̱nka̱ni sín ijnko ntachiso ntsí tsíkjin sín nixja nkekuènte kjuínchekjasóte sín chꞌán na mé ntáchro kíxin: “Jehe chꞌán mé Rey kuènte tí sín judío”. ");
INSERT INTO poeNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Na ko kja̱xin kꞌuéjóyáni sín ntacruz yaá tí síche̱e la ijnko la nánko chjina la í jnko la nó kjon tí tjen chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Na mé xi̱kaha xiteyá éxí nixja xroon itén Dios ntáchro kíxin: “Éxí yóhe̱ ijnko chojni kjuasin jie̱ mé kꞌuíkon sín chꞌán”. ");
INSERT INTO poeNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ntá tí sín kꞌuatsínka ntiha mé kjuanoá sín chꞌán la ko kꞌuántaxínhi̱n sín chꞌán tinkátjíá kja sín ntáchro sín kíxin: ―Kjá na ntáchrua kíxin chrókꞌoxíka tí ni̱nko, a̱ ntá iní ya̱on koá la ó chrókjuixin chrókjui̱chꞌéna ínaá, ichrua. ");
INSERT INTO poeNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Nchekaá a̱sán jahvá tjasinka̱jinxián tí ntacruz méhe̱ ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ntá tí sín ncha̱tꞌá tꞌe̱to̱an la ko tí sín tjako tí ley mé kjuanoá sín chꞌán ikjo sín kíchó sín kíxin: ―Ó kjuínchekaá chꞌán chojni ókjé ntá jehe chꞌán mé xitjahya sinchekaá chꞌán a̱sén chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","A̱ ntá chaxín jehe chꞌán tí Cristo tí Rey kuènte tí nación Israel ntá chrókꞌuikonni kíxin jehó chꞌán chrókjuinkaji̱nxi̱n chꞌán a̱sén chꞌán tí ntacruz ntá kja̱xin chrókuitekaonni chꞌán ―ichro sín. Kjónté tí yaá sín kja̱xin tjejóyáni ntacruz mé kꞌuántaxínhi̱n sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","A̱ ntá tió kui chonkíxin mé kꞌuíxin tie kuenté chjasintajni, kóxrjenhen tí sítié hasta las tres kónjín ");
INSERT INTO poeNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ntá tí hora a mé itsen kꞌuèya chꞌín Jesús ntáchro chꞌán kíxin: ―Eloi, Eloi, ¿lama sabactani? ―tí nkíve̱e sín mé tꞌaxrjexín kíxin: Itꞌéni, Itꞌéni, ¿nkekuènté kui̱to̱héni?, mé xi̱kaha ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ntá iso sín siín ntiha kuínhin sín, ntá ntáchro sín kíxin: ―Tinhínrá kíxin tꞌíye̱he̱ chꞌán tí chꞌín Elías tí chꞌín kꞌuéchrónka itén Dios ósé ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ntá ijnko tí jehe sín siín ntiha kuinká chꞌán kuákja chꞌán ijnko ka ntá kjuínchekjataxín chꞌán vino náxrjónhya ntá kjua̱kꞌe̱kjen chꞌán ijnko nta kjínjin ntá kjuínchechjina chꞌán tí tjen irꞌva chꞌín Jesús chrókꞌui chꞌán tí vino náxrjónhya. Ntáchro tí chꞌín a kíxin: ―Tsíto̱heni tsotsjeheni á chaxín tsi tí chꞌín Elías tsjinkaji̱n tí jehe chꞌán ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ntá chꞌín Jesús itsen kꞌuíyato chꞌán ntá kjuixin kꞌuén chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","A̱ ntá tí ka tjenkákuènxín nkaxenhen ni̱nko mé yaá kꞌóna kꞌuichje kjuankíxixín noi la hasta nonte kꞌuichje. ");
INSERT INTO poeNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ntá tí chꞌín capitán romano mé tjen chꞌán chokꞌèxin tí tjen chꞌín Jesús ntá kꞌuíkon chꞌán kíxin xi̱kaha ó kjuixin kꞌuén chꞌán ntá ntáchro chꞌán kíxin: ―Chaxín tí nkexro i la Xje̱en Dios ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Kja̱xin ntiha kꞌuejó iso chojni chjin, ikjín kꞌuéjó sín tsjehe sín. Tjejóko sín tjan María Magdalena la ko í jnko tjan María na mé ijnko xje̱en tjan itꞌin Jacobo na mé tí chꞌín tsoyo, ichro sín, la ko í jnko mé itꞌin José. La ko kja̱xin ntaha kjuákꞌe tí tjan Salomé. ");
INSERT INTO poeNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","A̱ ntá tí chojni chjin i mé kuinkáchréhe̱ sín tí chꞌín Jesús ntá kjui̱ka̱o sín chꞌán kíxin kꞌuékjinki̱tsa sín chꞌán tí kꞌuékjakꞌe chꞌán estado Galilea la ko kja̱xin í so chojni chjin ínaá chréhe̱ sín chꞌán sákjuíko sín chꞌán chjasin Jerusalén. ");
INSERT INTO poeNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","A̱ ntá ó kóntó tí ya̱on a mé tí ya̱on tꞌóyaxínhin sín kíxin tí xrankíxixín tí ya̱on tꞌo̱kꞌéhe sín, ");
INSERT INTO poeNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","mé kui ijnko chꞌín itꞌin José chjasén chꞌán mé Arimatea. Jehe chꞌán mé koí chꞌán tꞌe̱to̱an chꞌán tí xra̱ kuènte tí síxre̱é. Kja̱xin jehe chꞌán tjechónhen chꞌán itsi tí kjuachaxin kuènte Dios. Chrakonhya chꞌán sákjuí chꞌán nto̱e chꞌín Pilato kjuíkjanchia chꞌán tí cuerpo kuènte chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ntá chꞌín Pilato chrakon chꞌán kíxin ó tsíkjixin tsíkꞌen chꞌín Jesús, ntá kꞌuíye̱he̱ chꞌán tí chꞌín capitán a kjuanchankíhi chꞌán kíxin á chaxín xi̱kaha kónhen. ");
INSERT INTO poeNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ntá chrónka tí chꞌín capitán kíxin chaxín ó kjuixin kꞌuén chꞌán. Ntá kuínhin chꞌín Pilato xi̱kaha ntá kjuanjon chꞌán kjuachaxin kíxin tsjikakja chꞌín José tí cuerpo kuènte chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ntá chꞌín José mé kꞌue̱na chꞌán ijnko ka sábana náxrjón. Ntá kjuinkajin chꞌán tí cuerpo kuènte chꞌín Jesús, a̱ ntá jehe tí ka a mé kjuínchekꞌisímá chꞌán tí cuerpo kuènte chꞌán. Ntá kjua̱kꞌe̱nka̱ya chꞌán ijnko tòye̱ tsíxrayá itjo̱. Ntá ijnko xro̱ jié mé kꞌuíkjèxin chꞌán tí ntója tí tòye̱. ");
INSERT INTO poeNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","A̱ ntá tí tjan María Magdalena la ko tí tjan María ìné chꞌín José mé kꞌuíkon sín nketí xrává chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","A̱ ntá tió kꞌuátsínka tí ya̱on tꞌo̱kꞌéhe sín ntá tí tjan María Magdalena la ko tí tjan María ìné chꞌín Jacobo la ko tí tjan Salomé mé kꞌue̱na sín xro̱a̱n xraxé sátsjiko sín sincheka sín tí cuerpo kuènte chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ntá imá nchítjen tí ya̱on xrankíxixín tí semana mé kjuíji sín tí tòye̱ tsíxravá chꞌán, na mé ó kjui̱to̱n ya̱on. ");
INSERT INTO poeNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","A̱ ntá jehe sín mé tinkákjo kíchó sín kíxin: ―¿Xá nkexro tí chrókuakjìinhinni tí xro̱ tjekjèxin tí tòye̱? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","A̱ ntá xrína̱hya kꞌuíkon sín kíxin ó tsíkjixin tsíkjìin tí xro̱ jié tjekjèxin tí tòye̱ kíxin í tjenhya éxí kꞌuékjakꞌe senó. ");
INSERT INTO poeNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ntá kjuíji sín ikon tí tòye̱ ntá kꞌuíkon sín kíxin tjetja̱xi̱n ijnko chꞌín ntasoá tí tja sín chjina tjenkáya chꞌán ka kjínjin tjóá ntá imá chrakon sín kꞌuíkon sín. ");
INSERT INTO poeNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ntá ntáchro chꞌán kíxin: ―Chrakonhyará. Ó nòna kíxin xritjéyárá jahará tí chꞌín Jesús tsíkji̱xi̱n chjasin Nazaret kjuákꞌenkáni chꞌán ntacruz. Ntá ó tsíxechón chꞌán í kohya chꞌán ntihi. Tsjehérá tí tsíkjakꞌe sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ntá sátjirá tjíchenkará tí sín kꞌuékꞌajiko chꞌán la ko tí chꞌín Pedro kíxin tí chꞌín Jesús senó sátsji chꞌán estado Galilea ntá ntaha tsoxetará chꞌán éxí tsíchrónka chꞌán ―mé xi̱kaha chrónka tí ntasoá a. ");
INSERT INTO poeNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ntá tí chojni chjin a mé sákjuíxin sín tí tsíxravá tí chꞌín Jesús imá síxrànka̱ sín chrakon sín. Ntá na̱xa̱ chenkahya sín ninkexró kíxin chrakon sín. ");
INSERT INTO poeNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Tió tsíkjixin tsíxechón chꞌín Jesús nchítjen tí ya̱on xrankíxixín semana ntá titàya̱ xeta chꞌán sa̱oxín tí tjan María Magdalena na mé jehe tjan tsíkakitsjexín chꞌán yato ncha̱kuen tí jínahya. ");
INSERT INTO poeNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ntá sákjuíchenka tjan tí sín kꞌuékꞌajiko tí jehe chꞌán tꞌává sín tsjánka sín. ");
INSERT INTO poeNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","A̱ ntá tió kuínhin sín kíxin tjechón tí chꞌín Jesús kíxin xi̱kaha tsíkꞌikon tjan la kjónté kuítekakonhya sín. ");
INSERT INTO poeNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","A ntá chrꞌéxi̱n ntá iyó tí sín a titàya̱ kꞌuíkuèn sín tí chꞌín Jesús, ókjé nkexrí tsjehe chꞌán. Tí sín a mé tjejótji sín nti̱a sátsji sín ijnko nonte. ");
INSERT INTO poeNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","A̱ ntá jehe sín sákjuíchenka sín tí sín í so a; la kjónté xi̱kaha la kuítekakonhya sín. ");
INSERT INTO poeNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","A̱ ntá tió kjuixixín la titàya̱ kꞌuíkon tí tejnko sín tí jehe chꞌán tí tjejóne sín. Ntá nixje̱he̱ chꞌán sín kíxin nkekuènté icha a̱sén sín tsíkitekakuenhya sín tí sín tsíkꞌikon kíxin tsíxechón chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ntá ntáche chꞌán sín kíxin: ―Sátjirá kuenté chjasintajni tjákohérá kaín xín chojni tí tan jína tsaáxin sín. ");
INSERT INTO poeNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Tí nkexro tsitekaon la tsikite la mé tsaá. A̱ ntá tí nkexro tsitekakonhya na mé tsjasóte. ");
INSERT INTO poeNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ntá tí sín tsinkáchónki tí janhan mé tsjasin sín kjuaxroan kíxin kjuachaxin ni̱na tsakitsjexín sín tí ncha̱kuen tí jínahya chónta chojni la ko tsonixja sín ókjé nkìva. ");
INSERT INTO poeNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Kjónté konche chrótsé sín la kohya nkehe tso̱nhen sín la ko kjónté chrókꞌui sín ijnko nta̱ chónta veneno la kohya nkehe tso̱nhen sín. Kja̱xin tsꞌejotja tja sín chojni níhi la tsito̱he sín jína. ");
INSERT INTO poeNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ntá ó kjuixin nixje̱he̱ Ìnchéni Jesús tí jehe sín ntá sákjui̱ chꞌán nkaya nka̱jní. A̱ ntá ntiha kjuákꞌetja̱xi̱n chꞌán tí tja chjina Dios. ");
INSERT INTO poeNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","A̱ ntá jehe sín sákjuí sín nkuíxín sákjuíkjako sín tí tan jína tsaáxin chojni. A̱ ntá jehe Ìnchéni mé kjuínki̱tsa chꞌán tí sín a la ko kjua̱cha̱xién chꞌán mé kjuasixín sín kjuaxroan kíxin tíha mé tso̱noexín tí sín tjejótinhin kíxin chaxín nkehe kuènte Dios kjuako sín. Amén.");
INSERT INTO poeNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Nchónhya chojni tjinkaon chrókjin sín ntoá kaín xín nkehe nkexrí kónhen kꞌuátsínka Ìnchéni tí kꞌuéjóni. ");
INSERT INTO poeNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Éxí kjua̱ko̱he̱ni tí sín tsíkꞌikonxín kon sín tí xrankíxixín nkehe kꞌuátsínka chꞌán la ntá kꞌuáyéhe̱ sín tí xra̱ sákjuíchronka sín tí tan jína ");
INSERT INTO poeNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","a̱ ntá janhan kja̱xian kjuánchánkiá jína kaín nkehe kꞌuátsínka tí xrankíxixín. Ntá nòna jína ikjian kaín tíha éxí tsíkónhen ntá tsochrꞌanhan jaha Teófilo kíxin imá tjua̱ha ");
INSERT INTO poeNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","kíxin ntá jaha tso̱noha jína tí nkehe chaxín tsíkja̱ko̱ha sín. ");
INSERT INTO poeNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","A̱ ntá tí chꞌín rey Herodes kꞌue̱to̱an chꞌán tí estado Judea la ko ntiha kjuákꞌe ijnko ncha̱tꞌá mé itꞌin Zacarías. Jehe chꞌán mé kuènte tí sín tsíkꞌaxrjeníxin tí chꞌín Abías. A̱ ntá ichjién chꞌán mé itꞌin Elisabet. Jehe tjan mé tsíkꞌaxrjeníxin tjan tí ncha̱tꞌá Aarón. ");
INSERT INTO poeNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Yóí sín na mé jína sín kíxin éxí tjinkaon Dios la mé kjuínchexiteyéhe̱ sín kaín nkehe kꞌue̱to̱an chꞌán. Méxra̱ ninkexró chrókꞌuekahya jie̱ tí jehe sín. ");
INSERT INTO poeNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","A̱ ntá jehe sín chóntahya sín xje̱en sín kíxin ó jehí tsíki̱to̱enhya tjan Elisabet kíxin sichꞌéna tjan xjan la ko ntá jie la ó táda chꞌán la ko ó nána tjan. ");
INSERT INTO poeNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","A̱ ntá ijnko ya̱on tónhen tocar chꞌín Zacarías la ko tí í so sín tjejóko chꞌán sichꞌe sín xra̱ ncha̱tꞌá kuènte Dios. ");
INSERT INTO poeNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","A̱ ntá xi̱kaha kuènhen tí sín ncha̱tꞌá a̱ ntá jie chꞌín Zacarías mé kónhen tocar tsꞌixenhen chꞌán tí cuarto tjóá kuènte ni̱nko tsja̱kꞌe̱ chꞌán chji̱nco̱ chrítaón tí altar kuènte Dios. ");
INSERT INTO poeNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ntá kjuákꞌe chꞌán ntiha kjua̱kꞌe̱ chꞌán tí chji̱nco̱ la nachrohe kaín tí chojni kꞌuéjó sín ntója nixje̱he̱ sín Dios. ");
INSERT INTO poeNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ntá xrína̱hya kꞌuíkon chꞌín Zacarías ijnko ángel kuènte Dios tjexín to̱té chꞌán nánko chjina tí altar tja̱kꞌe̱xi̱n sín chji̱nco̱. ");
INSERT INTO poeNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","A̱ ntá tió kꞌuíkon chꞌín Zacarías tí ángel la imá kóxakonhen chꞌán la ko imá chrakon chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","A̱ ntá ntáchro tí chꞌín ángel kíxin: ―Zacarías, chrakonhya jaha. Ó kuínhin Dios tí nkehe tjanchehé chꞌán la ntá ichjián Elisabet sichꞌéna tjan ijnko xjan ntoa na mé si̱nchekꞌian xjan Juan. ");
INSERT INTO poeNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Jaha la tso̱cháha̱ má la ko itsjé chojni tso̱chéhe̱ sín kíxin tsokjíhi xjan ");
INSERT INTO poeNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","kíxin imá tjetoan tsjakꞌe tí xja̱an éxí tóxrjínhi̱n Dios. Ninkehó xran vino la ko ninkehó í jnko xran tsꞌihya chꞌán. Tsochónta chꞌán kjuachaxin kuènte Ncha̱kuen Dios kjónté na̱xa̱ tokjíehya chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Jehe chꞌán mé tsja̱ko̱he̱ chꞌán tí chojni nación Israel a̱ ntá itsjé sín tsokjan sín tsinkáchónki sín Ìnché sín Dios. ");
INSERT INTO poeNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Jehe chꞌín Juan tsítaón chꞌán nti̱a tsi̱xi̱n Ìnchéni. Éxí kꞌuékjako chꞌín Elías ósé mé tsjako chꞌán la ko tsochónta chꞌán kjuachaxin éxí kꞌuéchónta chꞌín Elías kíxin tí sín itꞌé xjan la mé jína tsꞌejóko xje̱en sín la ko kja̱xin tí sín titekakonhya mé tsitekaon sín. Mé xi̱kaha tsonixje̱he̱ chꞌán chojni kíxin ó itsi Ìnchéni la chrókuinkáchónki sín tí jehe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","A̱ ntá tí chꞌín Zacarías kjuanchankíhi chꞌán tí chꞌín ángel ntáchro chꞌán kíxin: ―¿Nkexrí chrókónòna kíxin chaxín chrókónhen tíhi? Janhan la ó tádana la ko tí chjin chonta la kja̱xin ó nána tjan ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ntá kjuáte̱he tí chꞌín ángel ntáchro chꞌán kíxin: ―Janhan mé Gabriel la mé tꞌa̱ha̱ xra̱ Dios. A̱ ntá jehe chꞌán mé kꞌue̱tua̱nna kꞌuinka tsonixja̱ha tso̱xrja̱nka tí nkehe jína tso̱nhen. ");
INSERT INTO poeNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","A̱ ntá jie kuítekákonhya tí nkehe xrja̱nka a̱ ntá tso̱nósian jaha xitjahya tsonixja jaha tsoxitjajia tí ya̱on tsokjíhi tí xja̱an. Mé xi̱kaha tsoxiteyá kaín tíha ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","A̱ ntá tí í so sín ntiha kꞌuéjóchónhen sín ntója ni̱nko kíxin tsꞌaxrje chꞌín Zacarías, ntá kóxakonhen sín kíxin imá sé kóxrjenhen chꞌán nkaxenhen ni̱nko. ");
INSERT INTO poeNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ntá tió kꞌuaxrjexín chꞌín Zacarías tí nkaxenhen ni̱nko la í xitjahya nixja chꞌán. Ntá kónohe sín kíxin ichrén kjuaxroan kuènte Dios tsíkꞌikon chꞌán tí nkaxenhen ni̱nko. Ntá itja chꞌán ó tja̱ko̱xi̱n chꞌán tí nkehe chróntáchro chꞌán kíxin í xitjahya nixja chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","A̱ ntá tió kjuixin tí ya̱on kjuíchꞌe chꞌín Zacarías xra̱ ni̱nko ntá sákjuí chꞌán nto̱e chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","A̱ ntá chrꞌéxi̱n ntá kjuákꞌeyá tí ichjién chꞌán Elisabet. Ntá nto̱e tjan ó kuíto̱he tjan inꞌó nitjó kjuenka̱yáxin tjan kíxin: ");
INSERT INTO poeNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Mé xi̱kaha ijnko kjuaxroan kjuanjon Ìnchéni kíxin chrókꞌuántaxíe̱nhyani chojni kíxin ó tsochóntani xje̱enni jie chrókjuikosáyeheni sín”, ichro tjan. ");
INSERT INTO poeNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","A̱ ntá kꞌuátsínka injon nitjó ntá Dios kꞌue̱tue̱nhen tí chꞌín ángel Gabriel kíxin sátsji chꞌán ijnko chjasin estado Galilea mé itꞌin Nazaret, ");
INSERT INTO poeNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","sátsji nixje̱he̱ chꞌán ijnko tjan tjarisoá na̱xa̱ kuákjahya tjan chojni ntoa mé itꞌin tjan María. Jehe tjan mé tsíkjate̱he tjan kíxin tso̱te̱he tjan ijnko chꞌín mé itꞌin José, mé tsíkꞌaxrjeníxin chꞌán tí chꞌín rey David. ");
INSERT INTO poeNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","A̱ ntá tí chꞌín ángel kꞌuíxenhen tí tjen tjan ntá ntáchro chꞌán kíxin: ―Kꞌuinka nixja̱ha jaha kíxin Dios kjuínki̱tsa tí jaha. Ìnchéni Dios tjekoa tí jaha. A̱ ntá jaha imá kjuíntaya̱van chꞌán ntá tí í so chojni chjin la kénhyó ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Kjánchó tió kꞌuíkon tjan tí chꞌín ángel na mé kóxakonhen tjan kjuenkayáxin tjan kíxin nkekuènte xi̱kaha nixje̱he̱ni chꞌán, ichro tjan. ");
INSERT INTO poeNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","A̱ ntá ntáchro tí chꞌín ángel kíxin: ―Chrakonhya, María. Dios la imá tjetjinki̱tsa tí jaha. ");
INSERT INTO poeNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","A̱ ntá jie la tsjakꞌèyá jaha, tsochonta ijnko xjan ntoa la ko si̱nchekꞌian xjan Jesús. ");
INSERT INTO poeNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Imá tsꞌe̱to̱an chꞌán la ko itsꞌin chꞌán Xje̱en Dios nkaya nka̱jní. Ìnchéni Dios mé tsjanjon chꞌán kjuachaxin tsꞌe̱to̱an chꞌán éxí ijnko rey éxí kꞌue̱to̱an chꞌín David, tí nkexro tsꞌaxrjeníxin chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Jnkochríxín tsjakꞌe chꞌán tsꞌe̱tue̱nhen chꞌán tí sín nación Israel, la mé tsjeje̱hya tí kjuachaxin tsꞌe̱to̱an chꞌán ―ichro tí chꞌín ángel. ");
INSERT INTO poeNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ntá kjuanchankíhi tjan María tí chꞌín ángel kíxin: ―¿Nkekuènte kíxin xi̱kaha chrókónhen kíxin janhan la na̱xa̱ chontahya chojni ntoa? ―ichro tjan. ");
INSERT INTO poeNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ntá kjuate̱he tí chꞌín ángel, ntáchro chꞌán kíxin: ―Tí Ncha̱kuen Dios mé tsꞌinkajin éxí ijnko tjui̱ la ko tí kjuachaxin kuènte Dios mé tsjakꞌetja tí jaha, a̱ ntá tsꞌóna tí xjan. Mé xi̱kaha tí xjan tsokjíhi la mé tjóá xjan la mé itsꞌin xjan Xje̱en Dios. ");
INSERT INTO poeNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","La ko kja̱xin tjan Elisabet kjéhya jaha kjónté ó nána tjan la mé tjeyá tjan. Senó la kꞌuéchóntahya tjan xjan, a̱ ntá jie la ó injon nitjó tjeyá tjan. ");
INSERT INTO poeNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kíxin tí kjua̱cha̱xién Dios la tsjacha tso̱nhen kaín xín nkehe ―ichro tí chꞌín ángel. ");
INSERT INTO poeNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ntá ntáchro tjan María kíxin: ―Janhan mé tꞌa̱ha̱ Ìnchéni Dios xra̱. Ó ncho̱xon tí nkehe kꞌue̱to̱an chꞌán si̱ntaxiteyáha̱ chꞌán éxí chro̱nka jaha ―ichro tjan. A̱ ntá kjuixin chrónka tí chꞌín ángel ntá sákjuí chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","A̱ ntá ijnko ya̱on tí tjan María tji̱a̱n sákjui̱ tjan ijnko chjasin tjen tí jna̱ estado Judea. ");
INSERT INTO poeNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ntá kjuíji tjan tí chjasin ntiha ntá kꞌuíxenhen tjan nto̱e chꞌín Zacarías la ntá nixje̱he̱ tjan tí tjan Elisabet. ");
INSERT INTO poeNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","A̱ ntá tió kuínhin tjan Elisabet nixja tjan María ntá chrika tí xjan nkaya tse̱e tí tjan Elisabet. Ntá a̱ntsí kꞌuáyéhe̱ tjan kjua̱cha̱xién Ncha̱kuen Dios ");
INSERT INTO poeNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ntá itsen nixja tjan ntáchro tjan kíxin: ―Dios imá kjuíntaya̱van la ntá tí í so chojni chjin la kénhyó la ko kja̱xin kjuíncheyaon chꞌán tí xja̱an. ");
INSERT INTO poeNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Xá nkexro tí janhan kíxin kjuínixja̱na ìné Ìnchéni? ");
INSERT INTO poeNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Tió kui̱nha̱n nixjana ntá tí xjan la chrika xjan nkaya tse̱na kíxin chéhe̱ xjan kjuiha. ");
INSERT INTO poeNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ntá jaha la cháha kíxin kuítekávan kíxin Ìnchéni Dios sinchexiteyá tí nkehe ntáchro chꞌán ―ichro tjan. ");
INSERT INTO poeNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ntá ntáchro tjan María kíxin: A̱senná imá tjikosáyehe Ìnchéni Dios ");
INSERT INTO poeNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","la ko chéhe̱ a̱senná kíxin Dios sinchekaáni chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Kíxin Dios ikuá kuentá ijnko tí chojni chjin nòé chꞌexón xra̱ kuènte chꞌán. A̱ ntá ijie la ko jnkochríxín tsontáchro chojni kíxin náxrjón tjèn janhan, tsixro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kíxin Dios chónta kaín kjuachaxin ntá janhan mé kjuasixínna chꞌán ijnko kjuaxroan jié; imá tjóá tí ihni̱é chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Jnkochríxín tsi̱konóe̱he̱ chꞌán kaín tí sín tjikosáyehe sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Tsíkjasin chꞌán itsjé kjuaxroan jié; kuakitsjehe chꞌán tí kjuachaxin chónta tí sín nchehnke. ");
INSERT INTO poeNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kuakitsjehe chꞌán tí kjuachaxin chónta tí sín tꞌe̱to̱an, A̱ ntá tí sín nòa kꞌuékꞌe̱tua̱nhya senó la mé jie chjéhe chꞌán kjuachaxin tsꞌe̱to̱an sín. ");
INSERT INTO poeNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","A̱ ntá tí sín tꞌenxín kjinta la kjuanjon chꞌán kaín nkehe tsicháxi̱nhin sín, a̱ ntá tí sín rico xráxín jehó tja sín sákjuí sín. ");
INSERT INTO poeNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Kjuínki̱tsa chꞌán tí sín nación Israel kíxin tjejóchꞌehe sín chꞌán xra̱; kꞌuitjáyenhya chꞌán tí jehe sín kui̱konóe̱he̱ chꞌán sín, ");
INSERT INTO poeNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","éxí kꞌuéchenka chꞌán tí sín kꞌuaxrjeníxinni kꞌuéjó sín ósé, na mé tí chꞌín Abraham la ko kaín tí sín na̱xa̱ tsꞌaxrjeníxin chꞌán ―mé xi̱kaha ichro tjan María. ");
INSERT INTO poeNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","A̱ ntá tjan María kuíto̱eko tjan tí tjan Elisabet iní nitjó la ntá chrꞌéxi̱n xíkjan tjan nto̱e tjan. ");
INSERT INTO poeNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ntá xétja tí ya̱on sinchekokjíhi tjan Elisabet tí xje̱en tjan, a̱ ntá kjuínchekokjíhi tjan ijnko xjan ntoa. ");
INSERT INTO poeNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","A̱ ntá tí sín chjinaxón nto̱e la ko tí sín kjéhya tjan mé kjuíjitsjehe sín kíxin tso̱chéhe̱ko sín tjan kíxin kuínhin sín kíxin Dios imá tsíki̱konóe̱he̱ tí jehe tjan. ");
INSERT INTO poeNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ntá tí ya̱on jníxin ikui sín sincheka sín xjan tí xro̱ye kuènte tí sín judío. Ntá chrókjuinchekꞌin sín xjan Zacarías éxí itꞌin itꞌé. ");
INSERT INTO poeNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Kjánchó ntáchro ìné xjan kíxin: ―Náhí. Tꞌichjánxi̱n itsꞌin xjan Juan ―ichro tjan. ");
INSERT INTO poeNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ntá ntáchro sín kíxin: ―¿Nkekuènte kíxin xi̱kaha chrókꞌuin xjan? Kohya nkexro na̱xa̱ kjéhya xi̱kaha itꞌin ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","A̱ ntá kaín tí sín kjéhya kjua̱ko̱xi̱n sín tja sín kjuanchankíhi sín tí itꞌé xjan kíxin nkexrí tjinkaon chꞌán chrókꞌuin tí xjan. ");
INSERT INTO poeNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","A̱ ntá tí itꞌé xjan mé kjuanchia chꞌán ijnko ntachiso ntsí tsokjin chꞌán ntá kjin chꞌán kíxin: “Ihni̱é xjan mé Juan.” A̱ ntá kaín tí sín tjejó sín ntiha la chrakon sín kuínhin sín xi̱kaha kónhen. ");
INSERT INTO poeNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","A̱ ntá xrína̱hya chꞌín Zacarías kjuankíxin chꞌán nixja chꞌán ínaá kjuanchehe chꞌán Dios kjuasáya. ");
INSERT INTO poeNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","A̱ ntá kaín tí sín chjinaxón nto̱e sín mé chrakon sín. La ntá nkuíxín tí jna̱ kuènte estado Judea mé kjo sín kíchó sín chrónka sín kíxin xi̱kaha tsíkónhen. ");
INSERT INTO poeNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","A̱ ntá kaín tí sín kuínhin mé kjuenka̱yáxin sín kjuanchankíhi sín kíchó sín kíxin: ―¿Xá nkehe tí xra̱ tsíki̱to̱nhe̱n tí xjan i? ―ichro sín. Kíxin chaxín Ìnchéni Dios tsíkjincheyaon chꞌán tí xjan. ");
INSERT INTO poeNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","A̱ ntá itꞌé tí xjan mé chꞌín Zacarías, mé a̱ntsí kꞌuáyéhe̱ chꞌán kjuachaxin kuènte Ncha̱kuen Dios ntá xi̱kaha nixja chꞌán itén Dios ntáchro chꞌán kíxin: ");
INSERT INTO poeNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Imá jína Ìnchéni, na mé tí Dios kuènte tí nación Israel, kíxin ikui chꞌán tí tjejóni kjuínchekaá chꞌán nación kuènténi. ");
INSERT INTO poeNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","La ko kjuanjon chꞌán ijnko nkexro tꞌe̱to̱an sinchekaáni chꞌán na mé ijnko nkexro kꞌuaxrjeníxin tí chꞌín David, tí nkexro kꞌuékjichꞌehe Dios xra̱. ");
INSERT INTO poeNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Éxí kꞌuéchronkaxín tí sín kjueyá Dios kꞌuéchrónka itén Dios ósé, ");
INSERT INTO poeNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","kꞌuéchronka Dios kíxin sinchekaáni chꞌán kíxin ntá tsjachahya kaín tí sín nínkakonhenni, ");
INSERT INTO poeNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","tsi̱konóe̱he̱ chꞌán tí sín kꞌuaxrjeníxinni ósé, tsꞌitjáyenhya chꞌán tí nkehe tsíchronka chꞌán tsoxiteyá. ");
INSERT INTO poeNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Tíhi mé tsíkjo Dios tí chꞌín Abraham ósé kíxin nkehe chaxín tsoxiteyá chrꞌéxi̱n ");
INSERT INTO poeNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","kíxin sinchekaáni chꞌán kíxin kohya nkehe sichꞌeheni tí sín nínkakonhenni kíxin jína sichꞌeheni chꞌán xra̱ tsochrakonhyani, ");
INSERT INTO poeNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","la ntá jína tsꞌejóni sinchetjóáni chꞌán kaín ya̱on tí na̱xa̱ tjejóchónni. ");
INSERT INTO poeNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","A̱ ntá jaha xje̱enni mé tsontáchro Dios kíxin jaha ijnko nkexro tsochrónka itén Dios tjen nkaya nka̱jní. Jaha tsíto̱nxian nti̱a tsi̱xi̱n Ìnchéni la ko jaha tsjásiyóxian nti̱a tsi̱xi̱n chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Jaha tsjákohé tí chojni chjasintajni nkexrí tsjìin tí jie̱ chónta sín, ntá tsaá sín. ");
INSERT INTO poeNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","A̱ ntá Dios mé tjuèheni chꞌán la ko kui̱konóe̱he̱ni chꞌán, kíxin nka̱jní kui̱xi̱n ijnko xrohi ni̱xin tsꞌinkaséyanxín tí ya̱on ni̱xin. ");
INSERT INTO poeNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Tíha mé tsi̱ka̱o tí xrohi tsꞌinkaséyenxín tí sín tjejó sítié la ko tí sín chrókꞌuitjáyan, la ko tsꞌikonxínni tí nti̱a tsjanjon kjuaxróxin. Na mé kaín tíhi chrónka tí chꞌín Zacarías. ");
INSERT INTO poeNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","A̱ ntá tinkákꞌánkí tí xjan a la ko Dios kjuínchekꞌánkí tí kjuaxrexinkaon kuènte xjan kíxin a̱ntsí tso̱nohe xjan nkexrí tjen Dios. A̱ ntá kjuákꞌe xjan nte̱je̱ kꞌuánkí xjan kjuixrakájia tí ya̱on kjuankíxin kjua̱ko̱he̱ chꞌán tí chojni nación Israel. ");
INSERT INTO poeNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","A̱ ntá tí ya̱on a na mé tí chꞌín imá tꞌe̱to̱an mé itꞌin Augusto César na mé kꞌue̱to̱an chꞌán kíxin tsꞌínixín ihni̱é kaín xín chojni siín tí chjasin tꞌe̱to̱an chꞌán kíxin tso̱nohe chꞌán nkekja̱ín chojni siín. ");
INSERT INTO poeNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Tí xrankíxixín kꞌuínixín ihni̱é sín tió Cirenio mé kꞌuégobernador kꞌue̱to̱an estado Siria. ");
INSERT INTO poeNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Kaínxín chojni tꞌichjánxi̱n sátsji sín chjasén sín kíxin ntaha tsꞌínixín ihni̱é sín. ");
INSERT INTO poeNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Mé xi̱kaha chꞌín José kja̱xin kꞌuaxrjexín chꞌán tí chjasin Nazaret estado Galilea ntá sákjuí chꞌán tí estado Judea na mé sákjuí chꞌán chjasin Belén tí tsíkokjíexín tí chꞌín rey David kíxin jehe chꞌín José mé tsíkꞌaxrjeníxin chꞌán tí chꞌín David. ");
INSERT INTO poeNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Sákjuí chꞌán chjasin Belén sákjuíko chꞌán tí tjan María kíxin ntiha tsꞌínixínko ihni̱é chꞌán tjan kíxin jehe tjan tsíkjate̱he kíxin tso̱te̱he chꞌán. A̱ ntá jehe tjan na mé ó tjeyá tjan. ");
INSERT INTO poeNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","A̱ ntá xi̱kaha kónhen nachrohe kꞌuéjó sín chjasin Belén, ntá kjuixraká tí ya̱on tsokjíhi xje̱en tjan María. ");
INSERT INTO poeNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","A̱ ntá ntiha kokjíexín tí xje̱en tjan sa̱o. Ntá kjuínchekꞌísímá tjan xjan ka, a̱ ntá kjua̱kꞌe̱nka̱ya tjan ijnko nta neyá iko kíxin jehe sín la kꞌuitjahya sín nchia xranka tsꞌo̱kꞌèxín sín mé kjónté ntiha kꞌuéjó sín. ");
INSERT INTO poeNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Kja̱xin chjinaxón tí chjasin Belén tjejó iso chojni nte̱je̱ ó la ntá ntahó tito̱he sín tí tie a kíxin tꞌayakonhen sín kolélo. ");
INSERT INTO poeNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","A̱ ntá titàya̱ kꞌuíkuèn sín ijnko ángel kuènte Dios la ko nkuíxín tí tjejó sín la kꞌuínkaséyan kíxin tí kjuachaxin jié kuènte Dios kui̱ka̱o chꞌán. Ntá jehe sín la imá chrakon sín. ");
INSERT INTO poeNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","A̱ ntá tí chꞌín ángel ntáchro kíxin: ―Chrakonhyará jahará. Ijie kꞌuinka tso̱tjo̱nka̱rá nkehe jína ni̱xin kíxin tso̱chéhe̱ kaín xín chojni ");
INSERT INTO poeNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","kíxin ijie tí chjasén chꞌín David kokjíexín tí nkexro tsaáxinrá jahará na mé Ìnchéni Cristo tíha. ");
INSERT INTO poeNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ntá tso̱noaxínrá jahará kíxin tí xjan a kíxin ika tjechrꞌísímá xjan la ko ijnko nta neyá iko mé tjetsínkayá xjan ―mé xi̱kaha chrónka tí chꞌín ángel. ");
INSERT INTO poeNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","A̱ ntá titàya̱ kꞌuíkuèn sín kíxin nchónhya sín ángel kui̱xi̱n nkaya nka̱jní tjejóko tí chꞌin ángel tjejótsje sín tjanchehe sín Dios kjuasáya, ntáchro sín kíxin: ");
INSERT INTO poeNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Kjuasáyé Dios tjen nkaya nka̱jní kíxin imá chónta chꞌán kjuachaxin. Ntá chjasintajni tsꞌixin kjuaxróxin tí tjejó tí sín sinchexiteyéhe̱ chꞌán. Mé xi̱kaha ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","A̱ ntá tí sín ángel xíkjan sín nkaya nka̱jní, a̱ ntá tí sín tꞌayakonhen kolélo ikjo sín kíchó sín ntáchro sín kíxin: ―Ìntá sátsjini tí chjasin Belén tsjitsjeheni tí nkehe tsíkónhen kíxin Ìnchéni kꞌue̱to̱an kui tí nkexro kjuínchenoheni ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ntá tji̱a̱n sákjuí sín ntiha la kꞌuitja sín tí tjan María la ko tí chꞌín José la ko tí xjan a tjetsínkayá nta neyá iko. ");
INSERT INTO poeNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","A̱ ntá tió kꞌuíkon sín xi̱kaha ntá chrónka sín tí nkehe tsíchrónka tí ángel kíxin nkexrí tjen tí xjan a. ");
INSERT INTO poeNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ntá chrakon kaín tí sín kuínhin kíxin xi̱kaha chrónka tí sín kꞌuáyakonhen kolélo. ");
INSERT INTO poeNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Kjánchó tí tjan María la a̱sén tjan ó xraxinkakonxín tjan kaín tíha. ");
INSERT INTO poeNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","A̱ ntá tí sín kꞌuáyakonhen kolélo la sákjuí sín nti̱a kuinkákjanchehe sín Dios kjuasáya kíxin kaín tí nkehe tsíkinhin sín la ko kꞌuíkon sín kíxin ó xiteyá kaín nkehe éxí tsíchrónka tí ángel. ");
INSERT INTO poeNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","A̱ ntá tió xétja tí ijní ya̱on ntá kjuíncheka sín xjan xro̱ye kuènte tí sín israelita ntá kjuínchekꞌin sín xjan Jesús éxí tsíntáchro tí chꞌín ángel chénka tí tjan María tí na̱xa̱ kjuákꞌeyáhya tjan. ");
INSERT INTO poeNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","A̱ ntá tió kuíto̱he tjan María jína éxí chrónka ley kuènte Moisés ntá sákjui̱ko sín tí xjan tí chjasin Jerusalén kíxin tsochjéhe sín Dios kjuasáya. ");
INSERT INTO poeNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Éxí ntáchro tí xroon ley kuènté Ìnchéni Dios kíxin: “A̱ ntá kaín xjan ntoa tsokjíhi sa̱oxín la mé tsochjéhe sín Dios tí xjan a sichꞌehe xjan xra̱ Dios.” ");
INSERT INTO poeNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ntá xi̱kaha sákjui̱ sín kíxin ntaha tsjanjon sín iko tsꞌenxín ntiha tsochjéxín sín Dios kjuasáyé éxí tꞌe̱to̱an tí ley kuènte chꞌán na mé yaá kontóá na̱jni o̱ yaá kontóá nte̱je̱ chrókjuanjon sín. ");
INSERT INTO poeNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","A̱ ntá tí ya̱on a kjuákꞌe chjasin Jerusalén ijnko chꞌán ó táda chꞌán mé itꞌin chꞌán Simeón. Jehe chꞌán ijnko chojni jína la ko jnkochríxín xraxinkaon chꞌán Dios la ko kjuákꞌechónhen chꞌán kíxin itsi tí nkexro tsaáxin tí nación Israel. Tí Ncha̱kuen Dios tjeko tí chꞌín Simeón ");
INSERT INTO poeNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","tsíkjinchenohe chꞌán kíxin na̱xa̱ tsꞌenhya chꞌán tsꞌikonjia chꞌán tí nkexro Cristo, na mé tí nkexro tsochrꞌán Ìnchéni Dios. ");
INSERT INTO poeNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","A̱ ntá tí Ncha̱kuen Dios kjuínchexraxinkaon tí chꞌín a kíxin sátsji̱ chꞌán ni̱nko. A̱ ntá tió kui tí ìné la ko itꞌé xjan Jesús kꞌuíxenko sín xjan nkaxenhen ni̱nko kíxin sinchexiteyéhe̱ sín tí nkehe tꞌe̱to̱an tí ley ");
INSERT INTO poeNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ntá chꞌín Simeón kuakja chꞌán tí xjan a kjóa chꞌán ntá kjuanchehe chꞌán Dios kjuasáya ntáchro chꞌán kíxin: ");
INSERT INTO poeNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Ijie jaha Ìnchéni Dios, tsjánjuan kjuachaxin kíxin kjuaxróxin itsꞌén janhan kíxin jaha ó kjui̱nchexiteyá tí nkehe tsíntáchrua ");
INSERT INTO poeNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","kíxin ó kꞌuíko̱nxin kua̱n tí nkexro tsaáxinni, ");
INSERT INTO poeNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","mé xi̱kaha kjui̱chꞌe kíxin tsꞌikon kaín xín chojni. ");
INSERT INTO poeNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Jehe chꞌán mé tí xrohi tsꞌinkaséyanxín nti̱e tí sín jehya kuènte Israel, la ko jehe chꞌán tsjikosáyehe chꞌán tí chjasín kuèntá Israel, mé ichro chꞌín Simeón. ");
INSERT INTO poeNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ntá chꞌín José la ko tí ìné chꞌín Jesús la chrakon sín kíxin xi̱kaha kuínhin sín ntáchro chꞌín Simeón kíxin nkexrí tjen tí xjan. ");
INSERT INTO poeNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ntá chꞌín Simeón kjuíncheyaon chꞌán sín ntá chénka chꞌán tí tjan María mé tí ìné xjan Jesús kíxin: ―Tí xjan i tsíki̱ka̱o itsjé xra̱ la itsjé tí sín Israel tsitekakuenhya sín xjan la tsíto̱he sín la ko itsjé sín tsitekaon sín a̱ntsí tso̱nohe sín la ko nchónhya chojni tsotjinkakonhya tsinhin sín tí nkehe tsjako chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Mé xi̱kaha tso̱noxín nkexrí tjenka̱yáxin jnkojnko a̱sén chojni. Kjánchó kaín tíha tso̱yóhe̱ éxí ijnko chica espada chróchrꞌáte a̱sán na mé tso̱xakonhan la ko tsꞌavá má ―ichro chꞌán nixje̱he̱ chꞌán tí tjan María. ");
INSERT INTO poeNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Kja̱xin ntaha kjuákꞌe ijnko tjan chrónka itén Dios mé itꞌin tjan Ana, itꞌé mé itꞌin Fanuel, la mé tsíkꞌaxrjeníxin chꞌán tí chꞌín Aser. Jehe tjan la ó nána tjan. Tí na̱xa̱ kꞌuétjarisoá tjan la kóte̱he tjan. Ntá yatokoá nánó kjuákꞌeko tí xìi tjan ");
INSERT INTO poeNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ntá jie ochenta y cuatro nánó tsíkókꞌán tjan. Kuíto̱ehya tjan tí xra̱ kuènte ni̱nko la mé ntahó tjen tjan chꞌehe tjan Ìnchéni Dios xra̱ ncha̱kotjin la ko tie la jnkoya̱xón nehya tjan kíxin jína tsonixje̱he̱ tjan Dios. ");
INSERT INTO poeNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ntá kóchjina tí tjan Ana tí ya̱on, a̱ ntá kjuixin kjuanchehe tjan kjuasáyé Dios ntá kjuankíxin chrónka tjan nkexrí tjen tí xjan Jesús nixje̱he̱ tjan kaín tí sín tjejóchónhen kíxin itsi nkexro sinchekaá tí chjasin Jerusalén. ");
INSERT INTO poeNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Na ntá tió kjuixin kjuínchexiteyá sín kaín nkehe tꞌe̱to̱an tí ley kuènte Dios ntá kjan sín estado Galilea na mé chjasén sín chaxín Nazaret. ");
INSERT INTO poeNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","A̱ ntá tí xjan a mé kꞌuánkí xjan la ko tsa̱nka̱ xjan la ko imá kónohe xjan kíxin Dios imá tjinki̱tsa tjencheyaon xjan. ");
INSERT INTO poeNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Tí itꞌé la ko ìné tí xjan Jesús xráxín kꞌuékji̱ sín kaín nánó tí chjasin Jerusalén kíxin tí kia pascua. ");
INSERT INTO poeNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","A̱ ntá tió xetjehe chꞌín Jesús tí teyó nánó, ntá sákjui̱ sín kaín sín tí chjasin Jerusalén kíxin xi̱kaha kuènhen sín kíxin tí kia a. ");
INSERT INTO poeNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","A̱ ntá kja̱nxi̱n sín ntiha sáchrókjui sín chjasén sín tió kꞌuátsínka kia la tí xjan Jesús ó tsíkito̱he xjan Jerusalén ntahó, kjánchó ìné xjan la ko chꞌín José xraxinkakonhya sín kíxin kohya tí xjan. ");
INSERT INTO poeNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Jehe sín mé kjuenka̱yáxin sín kíxin áchꞌe tí sín kuichréhe̱ mé kui̱ka̱o sín xjan la ntá xi̱kaha chjina ijnko ya̱on ó tjejóyá sín nti̱a tsíkji sín. A̱ ntá kjueyá sín xjan tí tjejó tí sín kjéhya la ko tí sín chóxin sín ");
INSERT INTO poeNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","kjánchó kꞌuitjahya sín xjan. Ntá kjan sín tí chjasin Jerusalén kíxin tsjeyá sín xjan ntiha. ");
INSERT INTO poeNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ntá kꞌuátsínka iní ya̱on ntá kꞌuitja sín xjan la mé nkaxenhen ni̱nko ntiha tjetja̱xi̱n xjan jnko̱siné tí tjejó tí sín maestro tjako tí ley la tjetinhin xjan tí nkehe ntáchro sín la ko tjetjanchankíhi xjan tí jehe sín. ");
INSERT INTO poeNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ntá kaín tí sín tjejóntaxín tjejótinhin sín mé chrakon sín kíxin xi̱kaha imá nohe xjan la ko xi̱kaha tjate̱he xjan kaín nkehe tjanchankíhi sín xjan. ");
INSERT INTO poeNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ntá tió kꞌuíkon ìné la ko itꞌé la chrakon sín. Ntá ntáchro ìné kíxin: ―Xje̱enni, ¿nkekuènte xi̱kaha kjui̱chꞌe? Itꞌá la ko janhan imá kóxakonhenni kjueyáni tí jaha ―ichro tjan. ");
INSERT INTO poeNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ntá ntáchro chꞌín Jesús kíxin: ―¿Nkekuènte tjéyá tí jeheni? ¿Á noahya jaha kíxin tóxakonhenni kíxin tí xra̱ kuènte Itꞌéni? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Kjánchó kíenxínhya sín nkexrí tꞌaxrjexín tí nkehe ntáchro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ntá kjan sín chjasin Nazaret. A̱ ntá ntiha na̱xa̱ kuítekakonhen xjan tí jehe sín. A̱ ntá tí ìné la ntá a̱sén tjan xráxín ó nohe kíxin xi̱kaha kónhen. ");
INSERT INTO poeNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","La ko na̱xa̱ kꞌuánkí xjan kónte̱to xjan la ko kꞌuánkí tí kjuaxrexinkaon kuènte xjan la ko Dios kóxrjínhi̱n nkexrí kjuínchexiteyá xjan la ko kja̱xin kaín chojni kóxrjínhi̱n sín kíxin jína tjen xjan. ");
INSERT INTO poeNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","A̱ ntá quince nánó kꞌuékꞌe̱to̱an chꞌín Tiberio tí xra̱ gobierno, la ko tí chꞌín Poncio Pilato kꞌuégobernador tí estado Judea, la ko tí chꞌín Herodes kꞌuégobernador tí estado Galilea, la ko tí kíchó chꞌán Felipe mé kꞌuégobernador estado Iturea la ko estado Traconite, la ko chꞌín Lisanias kꞌuégobernador tí estado Abilinia. ");
INSERT INTO poeNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","A̱ ntá chꞌín Anás la ko chꞌín Caifás kꞌuéchónta sín xra̱ ncha̱tꞌá tꞌe̱to̱an. A̱ ntá Dios mé kjuanjon kjuachaxin kꞌuáyéhe̱ chꞌín Juan itjen chꞌán nte̱je̱ tsochrónka chꞌán itén Dios. Ntá jehe chꞌán itꞌé chꞌán Zacarías. ");
INSERT INTO poeNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Chꞌín Juan kꞌuátsínka chꞌán kaín tí chjasin chjino tí nta̱río Jordán kjua̱ko̱he̱ chꞌán chojni ntiha kíxin chrókjuinkí sín tí nkehe tjenka̱yáxin sín chrókuíto̱he sín tí iji̱é sín ntá chrókuikite sín kíxin xi̱kaha mé chrókjuìin iji̱é sín. ");
INSERT INTO poeNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Mé xi̱kaha kónhen éxí kꞌuéchronka la ko tsíkjin chꞌín Isaías, mé tí nkexro kꞌuéchronka itén Dios ósé kíxin: Tsinhin sín itén ijnko nkexro tsjakꞌe nte̱je̱ tsꞌèya tsontáchro kíxin: “Tóxakonhanrá ncheyóxinrá nti̱a tsi̱xi̱n Ìnchéni Takítje̱hérá ijnko nti̱a ntoí. ");
INSERT INTO poeNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kaínxín tsa̱ka mé tso̱yóxin, la ko kaín xín jna̱ la ko kaín xín itjo tsito̱he yóxin, la ko tí nti̱a tsíxrèya mé tsoxrentoá, la ko kaín tí nti̱a yóxinhya la mé tso̱yóxin; ");
INSERT INTO poeNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Xi̱kaha mé kaín xín chojni chjasintajni mé tsꞌikon sín kíxin Dios mé chrókuaáxin sín.” Mé xi̱kaha ichro itén Dios. ");
INSERT INTO poeNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","A̱ ntá tió kjuíji chojni ntiha kíxin chꞌín Juan chrókui̱ki̱te chꞌán sín ntá ntáche chꞌán tí jehe sín kíxin: ―Jahará tsíkꞌaxrjeníxinrá konche. ¿Xá nkexro kjuíntanohará kíxin chrókuinkeherá tí kjuanínkaon kuènte Dios ó tsi? ");
INSERT INTO poeNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Tꞌichjánxi̱n kíxin chrókꞌuejorá jnkojína chrókjuáko̱xi̱nrá kíxin chaxín kjuitoxi̱nhínrá tí nkehe tjenka̱yáxinrá. Jahará nchehnkerá ntáchrorá kíxin kꞌuaxrjeníxinrá chꞌín Abraham. Janhan ntáxrja̱n kíxin kjónté tí xro̱ i la Dios tsjacha chrókjuichꞌéna chꞌán chojni kꞌuaxrjeníxin chꞌín Abraham. ");
INSERT INTO poeNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Kíxin tí chica hacha ó tjechónhen tsochrínjinxín tí nta. A̱ ntá kaín xín nta tꞌónahya to jína mé tsochrínjin kíxin tsoche ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","A̱ ntá tí chojni mé kjuanchankíhi sín chꞌán kíxin: ―A̱ ntá tí xi̱kaha, ¿a̱ ntá jeheni nkehe tí chrókjuichꞌeni? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ntá kjuáte̱he chꞌín Juan kíxin: ―Tí nkexro chónta yaá camisa la chrókjuincheki̱to̱nhe̱n tí nkexro chóntahya. La ko tí nkexro chónta nkehe sine chróchjéhe sín tí nkexro chóntahya nkehe sine ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Kja̱xin ikui iso tí sín nchekjènki̱ kíxin chrókuikite sín. Ntá kjuanchankíhi sín tí chꞌín Juan kíxin: ―Maestro, ¿nkehe chrókjuichꞌeni jeheni? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ntá ntáchro chꞌín Juan kíxin: ―Jehó éxí tí tsíkꞌítuanhanrá chrókjui̱nchekjènki̱rá ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Kja̱xin iso sín soldado kjuanchankíhi sín chꞌán kíxin: ―¿Kja̱xin jeheni nkehe chrókjuichꞌeni? ―ichro sín. Ntá kjuáte̱he chꞌán kíxin: ―Te̱éhyará ninkexró tí chi̱cha̱ko̱en sín la ko ninkexró si̱chꞌénéhyará kjuachꞌia la ko kjónté tí chichaon tjachará ó la kjuaxróxin chrókꞌuejorá ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Kaín tí chojni chjasin kꞌuéjóchónhen sín tóxakonhen a̱sén sín tjinkaon sín tso̱nohe sín kíxin á tí chꞌín Juan mé tí Cristo. ");
INSERT INTO poeNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Kjánchó chénka chꞌín Juan kaín tí sín tjejó a kíxin: ―Janhan mé ìnta̱ tíki̱texián chojni. A̱ ntá tí nkexro itsi chrꞌéxi̱n mé tsi̱ki̱texínrá tí Ncha̱kuen Dios la ko xrohi. A̱ntsí tꞌe̱to̱an chꞌán a̱ ntá janhan la kánhyó. Méxra̱ chrókósuàna chrókjuasinta̱nka̱ha̱ chꞌán tí correa tí to̱ka̱té chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Jehe chꞌán la ó tjexraá chꞌán pala sinchetjuáxin chꞌán noatrigo kíxin tí nta̱chji̱ji trigo la ókjé tsjejo chꞌán a̱ ntá tí noatrigo la tsjenájín chꞌán la tsꞌe̱nka̱chji̱na chꞌán. A̱ ntá tí nta̱chji̱ji trigo la tsjakaxín chꞌán ijnko xrohi tsꞌankahya jnkochríxín ―mé xi̱kaha ichro chꞌín Juan. ");
INSERT INTO poeNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Mé xi̱kaha chronkaxín chꞌán la ko itsjé í so nkehe kjuínchexraxinkaon chꞌán chojni mé xi̱kaha kjua̱ko̱exín chꞌán sín tí tan jína. ");
INSERT INTO poeNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Kja̱xin kjuentuéhe chꞌán tí chꞌín Herodes kíxin chónta chꞌán tí tjan Herodías, mé tí ichjién kíchó chꞌán Felipe, la ko kjuentuéhe chꞌán tí chꞌín Herodes kíxin tí í so nkehe jínahya tsíkjichꞌe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Kjánchó chꞌín Herodes ánto̱sén chꞌán kjónté kuínhin chꞌán la kjuínchekꞌánkí chꞌán tí iji̱é chꞌán ínaá kíxin kjua̱kꞌe̱chji̱na chꞌán tí chꞌín Juan tí nto̱echiso. ");
INSERT INTO poeNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","A̱ ntá na̱xa̱ kuènhya tíha na̱xa̱ kjuákꞌe chꞌín Juan kui̱ki̱te chꞌán chojni ntá kja̱xin chꞌín Jesús mé kuíkite chꞌán. A̱ ntá tjenixje̱he̱ chꞌán Dios ntá xitje̱he̱ nka̱jní ");
INSERT INTO poeNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ntá kꞌuínkajin Ncha̱kuen Dios éxí ijnko kontóá tsjehe la kjuákꞌe chrítaón kja chꞌán. Ntá xrína̱hya kuínhin sín itén nkexro nkaya nka̱jní ntáchro kíxin: ―Jaha mé xja̱nna la tjua̱ha tí jaha. Imá chàna kíxin nchexiteyána tí jaha. ");
INSERT INTO poeNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Chꞌín Jesús kꞌuéchónta chꞌán chjino treinta nánó tió kjuankíxin kjuako chꞌán. Ntá kjuenka̱yáxin sín kíxin itꞌé la mé chꞌín José. Ntá itꞌé tí chꞌín José la mé chꞌín Elí. ");
INSERT INTO poeNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","A̱ ntá itꞌé tí chꞌín Elí la mé chꞌín Matat; a̱ ntá itꞌé tí chꞌín Matat la mé chꞌín Leví, a̱ ntá itꞌé tí chꞌín Leví la mé chꞌín Melqui; a̱ ntá itꞌé tí chꞌín Melqui la mé chꞌín Jana; a̱ ntá itꞌé tí chꞌín Jana la mé chꞌín José. ");
INSERT INTO poeNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","A̱ ntá itꞌé tí chꞌín José la mé chꞌín Matatías, a̱ ntá itꞌé tí chꞌín Matatías la mé chꞌín Amós, a̱ ntá itꞌé tí chꞌin Amós la mé chꞌín Nahum, a̱ ntá itꞌé tí chꞌín Nahum la mé chꞌín Esli; a̱ ntá itꞌé chꞌín Esli la mé chꞌín Nagai, ");
INSERT INTO poeNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","a̱ ntá itꞌé tí chꞌín Nagai la mé chꞌín Maat, a̱ ntá itꞌé tí chꞌín Maat la mé chꞌín Matatías, a̱ ntá itꞌé tí chꞌín Matatías la mé chꞌín Semei, a̱ ntá itꞌé tí chꞌín Semei na mé chꞌín José, a̱ ntá itꞌé tí chꞌín José na mé chꞌín Judá, ");
INSERT INTO poeNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","a̱ ntá itꞌé tí chꞌín Judá na mé chꞌín Joana, a̱ ntá itꞌé tí chꞌín Joana la mé chꞌín Resa, a̱ ntá itꞌé tí chꞌín Resa na mé chꞌín Zorobabel, a̱ ntá itꞌé tí chꞌín Zorobabel na mé chꞌín Salatiel, a̱ ntá itꞌé tí chꞌín Salatiel na mé chꞌín Neri, ");
INSERT INTO poeNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","a̱ ntá itꞌé tí chꞌín Neri na mé chꞌín Melqui, a̱ ntá itꞌé tí chꞌín Melqui na mé chꞌín Adi, a̱ ntá itꞌé tí chꞌín Adi na mé chꞌín Cosam, a̱ ntá itꞌé tí chꞌín Cosam na mé chꞌín Elmodam, a̱ ntá itꞌé tí chꞌín Elmodam na mé chꞌín Er, ");
INSERT INTO poeNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","a̱ ntá itꞌé tí chꞌín Er na mé chꞌín Josué, a̱ ntá itꞌé tí chꞌín Josué na mé chꞌín Eliezer, a̱ ntá itꞌé tí chꞌín Eliezer na mé chꞌín Jorim, a̱ ntá itꞌé tí chꞌín Jorim na mé chꞌín Matat, ");
INSERT INTO poeNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","a̱ ntá itꞌé tí chꞌín Matat la mé chꞌín Leví, a ntá itꞌé tí chꞌín Leví na mé chꞌín Simeón, a̱ ntá itꞌé tí chꞌín Simeón na mé chꞌín Judá, a̱ ntá itꞌé tí chꞌín Judá na mé chꞌín José, a̱ ntá itꞌé ti chꞌín José na mé chꞌín Jonán, a̱ ntá itꞌé tí chꞌín Jonán na mé chꞌín Eliaquim, ");
INSERT INTO poeNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","a̱ ntá itꞌé tí chꞌín Eliaquim na mé chꞌín Melea, a̱ ntá itꞌé tí chꞌín Melea na mé chꞌín Mainán, a̱ ntá itꞌé tí chꞌín Mainán na mé chꞌín Matata, a̱ ntá itꞌé tí chꞌín Matata na mé chꞌín Natán, ");
INSERT INTO poeNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","a̱ ntá itꞌé tí chꞌín Natán na mé chꞌín David, a̱ ntá itꞌé tí chꞌín David na mé chꞌín Isaí, a̱ ntá itꞌé tí chꞌín Isaí na mé chꞌín Obed, a̱ ntá itꞌé tí chꞌín Obed na mé chꞌín Booz, a̱ ntá itꞌé tí chꞌín Booz na mé chꞌín Salmón, a̱ ntá itꞌé tí chꞌín Salmón na mé chꞌín Naasón, ");
INSERT INTO poeNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","a̱ ntá itꞌé tí chꞌín Naasón na mé chꞌín Aminadab, a̱ ntá itꞌé tí chꞌín Aminadab na mé chꞌín Aram, a̱ ntá itꞌé tí chꞌín Aram na mé chꞌín Esrom, a̱ ntá itꞌé tí chꞌín Esrom na mé chꞌín Fares, a̱ ntá itꞌé tí chꞌín Fares na mé chꞌín Judá, ");
INSERT INTO poeNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","a̱ ntá itꞌé tí chꞌín Judá na mé chꞌín Jacob, a̱ ntá itꞌé tí chꞌín Jacob na mé chꞌín Isaac, a̱ ntá itꞌé tí chꞌín Isaac na mé chꞌín Abraham, a̱ ntá itꞌé tí chꞌín Abraham ná mé chꞌín Taré, a̱ ntá itꞌé tí chꞌín Taré na mé chꞌín Nacor, ");
INSERT INTO poeNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","a̱ ntá itꞌé tí chꞌín Nacor na mé chꞌín Serug, a̱ ntá itꞌé tí chꞌín Serug na mé chꞌín Ragau, a̱ ntá itꞌé tí chꞌín Ragau na mé chꞌín Peleg, a̱ ntá itꞌé tí chꞌín Peleg na mé chꞌín Heber, a̱ ntá itꞌé tí chꞌín Heber na mé chꞌín Sala, ");
INSERT INTO poeNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","a̱ ntá itꞌé tí chꞌín Sala na mé chꞌín Cainán, a̱ ntá itꞌé tí chꞌín Cainán na mé chꞌín Arfaxad, a̱ ntá itꞌe tí chꞌín Arfaxad na mé chꞌín Sem, a̱ ntá itꞌé tí chꞌín Sem na mé chꞌín Noé, a̱ ntá itꞌé tí chꞌín Noé na mé chꞌín Lamec, ");
INSERT INTO poeNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","a̱ ntá itꞌé tí chꞌín Lemec na mé chꞌín Matusalén, a̱ ntá itꞌé tí chꞌín Matusalén na mé chꞌín Enoc, a̱ ntá itꞌé tí chꞌín Enoc na mé chꞌín Jared, a̱ ntá itꞌé tí chꞌín Jared na mé chꞌín Mahalaleel, a̱ ntá itꞌé tí chꞌín Mahalaleel na mé chꞌín Cainán, ");
INSERT INTO poeNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","a̱ ntá itꞌé tí chꞌín Cainán na mé chꞌín Enós, a̱ ntá itꞌé tí chꞌín Enós na mé chꞌín Set, a̱ ntá itꞌé tí chꞌín Set na mé chꞌín Adán, a̱ ntá Dios mé xje̱en chꞌín Adán. ");
INSERT INTO poeNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","A̱ ntá chꞌín Jesús imá chónta chꞌán kjua̱cha̱xién Ncha̱kuen Dios ntá kja̱nxi̱n chꞌán tí nta̱río Jordán. Ntá tí Ncha̱kuen Dios sákjui̱ko chꞌán nte̱je̱. ");
INSERT INTO poeNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ntaha kjuákꞌe chꞌán cuarenta ya̱on na ntá tí chꞌín Tsochren tjinkaon chrókjuachroe tí jehe chꞌán. Kjónehya chꞌán ninkehó tí cuarenta ya̱on a, a̱ ntá chrꞌéxi̱n ntá xrína̱hya ikꞌuén chꞌán kjinta. ");
INSERT INTO poeNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ntá ntáchro tí chꞌín Tsochren kíxin: ―Tí chaxín jaha Xje̱en Dios la ntáche tí xro̱ i kíxin chrókꞌóna nio̱tja̱. ");
INSERT INTO poeNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","A̱ ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Náhí. Ntáchro xroon itén Dios kíxin: “Jehya nio̱tja̱ ó chrókꞌuejóchónxin chojni. Náhí. Kaín tí tan nixja Dios tjejóchónxin chojni” ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ntá sákjui̱ko chꞌín Tsochren tí chꞌín Jesús ijnko jna̱ imá noi ntá kjuako tí Jínahya kaín tí nación siín chjasintajni. ");
INSERT INTO poeNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ntá ntáchro tí chꞌín Tsochren kíxin: ―Janhan tso̱tja̱ha kaín tí kjuachaxin la ko kaín tí nkehe tjete chónta kaín tí nación a. Janhan na kꞌuayáha̱ kaín tíha la ntá jie tso̱tja̱ha̱ tí nkexro tjínka̱van tso̱tja̱ha̱. ");
INSERT INTO poeNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Tí tsjakꞌéxian tóchꞌian tsjíkosáyana tí janhan ntá kaín tí nkehe la tsꞌóna kuèntá ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Sátjia Satanás, kíxin xroon itén Dios ntáchro kíxin “Chrókjuíkosáyehé Ìnchéni Dios la jehó chꞌán chrókjui̱chꞌehé xra̱” ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","A̱ ntá chꞌín Tsochren mé sákjui̱ko chꞌín Jesús tí chjasin Jerusalén la sákjui̱ko chꞌán tí chrítaón tí kja ni̱nko, a̱ ntá ntáchro chꞌán kíxin: ―Tí chaxín Xje̱en Dios jaha la ti̱to̱hé tꞌanótje̱nxian tí noi ntihi ");
INSERT INTO poeNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","kíxin ntáchro xroon itén Dios kíxin: Dios mé tsꞌe̱tue̱nhen tí sín ángel kuènte chꞌán kíxin tsꞌayakonhan sín. ");
INSERT INTO poeNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Tsotsé sín itjá kíxin tsotéhya to̱tá tsꞌitja xro̱ tí tsꞌanótje̱n ―mé xi̱kaha ichro chꞌín Tsochren. ");
INSERT INTO poeNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Náhí. Kja̱xin ntáchro xroon itén Dios kíxin: “Chji̱níhya chrókjuásixián kjuaxroan kjuachaxin kuènte Ìnchéni Dios” ―ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Mé xi̱kaha tió kjuachahya tí chꞌín Tsochren kaín nkehe chrókꞌue̱tue̱nhen tí chꞌín Jesús ntá kꞌuaxrjenta chꞌán iso ya̱on. ");
INSERT INTO poeNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ntá chꞌín Jesús xíkjan chꞌán estado Galilea ínaá na imá chónta chꞌán kjuachaxin kuènte Ncha̱kuen Dios. Ntá tjejótjo sín nkuíxín ntiha kíxin nkexro tí jehe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Kjua̱ko̱xi̱n chꞌán tí ni̱nko̱e sín kaín chjasin la ko kaín xín chojni kjuanchia sín kjuasáya kíxin kóxrjínhi̱n sín tí kjuako chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ntá chꞌín Jesús sákjuí chꞌán chjasin Nazaret na mé tí chjasin tsíkꞌánkíxin chꞌán. Ntá tí ya̱on tꞌo̱kꞌéhe sín mé kꞌuíxenhen chꞌán ijnko ni̱nko Israel kíxin xi̱kaha kuènhen chꞌán. Ntá kjuákꞌexín to̱té chꞌán kíxin sinchekuáxin chꞌán tí xroon itén Dios. ");
INSERT INTO poeNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Chjéhe sín chꞌán tí xroon kuènte tí profeta Isaías. Ntá kuakitje̱he̱ chꞌán tí xroon ntá kꞌuitja chꞌán nketí nixja xi̱kihí: ");
INSERT INTO poeNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Tí Ncha̱kuen Itꞌéni Dios tjetjinki̱tsana má, kíxin kjueyána chꞌán kíxin tso̱xrja̱nka tí tan jína kuènte Dios tsja̱ko̱ha̱ tí sín nòa. Kꞌue̱tua̱nna chꞌán kíxin si̱ntaki̱to̱ha̱ jína tí sín tꞌává a̱sén kíxin chóntahya sín nkerí tsaáxin sín, la ko tsja̱ko̱ha̱ tí sín tjejóchjina kíxin nkexrí tsaá sín, la ko si̱ntakꞌikua̱n tí sín tꞌikonhya, la ko si̱ntakaá kaín tí sín tjejótjasóte kohya nkehe tsaáxin sín, ");
INSERT INTO poeNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","la ko tso̱xrja̱nka kíxin ó kjuixraká tí ya̱on kíxin tí nkexro tsitekaon la tsaá sín. ");
INSERT INTO poeNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","A̱ ntá chꞌín Jesús kjuixin kjuínchekuáxin chꞌán tí xroon, a̱ ntá chjéhe chꞌán tí chꞌín tjinki̱tsa tí xra̱ ni̱nko ntá kjuákꞌetja̱xi̱n chꞌán. Ntá kaín tí sín tsíkójnkotsé ntiha ni̱nko na̱xa̱ tjejókomá sín tí jehe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ntá kjuankíxin chronkaxín chꞌán ntáchro chꞌán kíxin: ―Ntá ijie la ó xiteyá tí nkehe kjui̱ntakuáxian tí xroon itén Dios kuínhínrá ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ntá kaín sín kóxrjínhi̱n sín tí kjuako chꞌín Jesús la ko chrakon sín kíxin náxrjón tí nkehe nixja chꞌán. Ntá kjuanchankíhi sín kíchó sín ntáchro sín kíxin: ―¿A jehya xje̱en chꞌín José tíhi? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Kjá tsontáchrorá kíxin janhan ijnko chojni chꞌe xro̱a̱n chrókjui̱ntaki̱to̱ha̱ jína a̱senná senó, la ko tsontáchrorá kíxin tí nkehe kuínhínrá kjui̱tꞌa tí chjasin Capernaum xi̱kaha chrókjui̱tꞌa ntihi chjasenná, tsixrorá ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Na̱xa̱ tjenixja chꞌán ntáchro chꞌán kíxin: ―Ijnko nkehe chaxín tsotjo̱nka̱rá kíxin tí sín chjasén ijnko nkexro chrónka itén Dios la mé xráxín chóntehya sín kjuasáyé tí nkexro a. ");
INSERT INTO poeNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Chaxín ntáxrja̱n kíxin kꞌuéjó itsjé chojni chjin tsíkókꞌán tí nación Israel tió kjuákꞌe chꞌín Elías tí nkexro kꞌuéchrónka itén Dios la ntá í kꞌuániáhya chrin iní nánó ko tꞌo̱ la ko imá kókjinta nkuíxín chjasin ntiha. ");
INSERT INTO poeNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Kjánchó Dios la kꞌue̱tue̱nhya chꞌín Elías sáchrókjuitsjehe chꞌán nijnko chojni chjin tsíkókꞌán tí nación Israel. Náhí. Dios kꞌue̱tue̱nhen chꞌán kíxin sátsjitsjehe chꞌán ijnko chojni chjin tsíkókꞌán itjen chjasin Sarepta chjino chjasin Sidón. ");
INSERT INTO poeNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kja̱xin nación Israel kꞌuéjó nchónhya chojni chónta chinlepra tió kjuákꞌe chꞌín Eliseo chrónka chꞌán itén Dios, kjánchó nijnko sín kuíto̱ehya sín jína la mé jehó chꞌín Naamán kjui̱xi̱n chꞌán nación Siria mé kuíto̱he chꞌán jína ―mé xi̱kaha ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","A̱ ntá tió kuínhin sín xi̱kaha ntáchro chꞌín Jesús la ntá kaín tí chojni kꞌuéjóxenhen ni̱nko la mé imá kónínkaon sín. ");
INSERT INTO poeNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Kꞌuínkatjen sín itsé sín chꞌán sákjuíko sín chꞌán tí ikon chjasin la sákjui̱ko sín chꞌán chrítaón tí tjo tí tjen tí chjasin a chrókjuinchekꞌanótje̱nxi̱n sín chꞌán tí tjo a. ");
INSERT INTO poeNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","A̱ ntá chꞌín Jesús kꞌuátsínka jnko̱siné tí siín tí jehe sín la sákjuí chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","A̱ ntá chꞌín Jesús sákjuí chꞌán tí chjasin Capernaum na mé ijnko chjasin estado Galilea, na ntá ntaha kjuankíxin chꞌán kjua̱ko̱he̱ chꞌán chojni tí ya̱on tꞌo̱kꞌéhe sín. ");
INSERT INTO poeNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Chrakon sín kíxin nkexrí kjuako chꞌán kíxin kjua̱ko̱xi̱n chꞌán kíxin chónta chꞌán kjuachaxin. ");
INSERT INTO poeNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","A̱ ntá nkaxenhen ni̱nko kjuákꞌe ijnko chꞌín chónta ijnko ncha̱kuen tí jínahya kꞌóyakoxín itén tí chꞌín a, ntáchro kíxin: ");
INSERT INTO poeNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―Ti̱to̱héni; ¿nkekuènte tji̱a̱té tí jeheni kaín ni, jaha Jesús kjuíxian chjasin Nazaret? ¿Á kꞌuinka kíxin si̱nchekꞌitjáyanni? Ó tjátso̱an tí jaha la ko nòna kíxin jaha mé tí nkexro tjóá kuènte Dios ―ichro tí ncha̱kuen tí jínahya. ");
INSERT INTO poeNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ntá chꞌín Jesús jie̱he kꞌue̱tue̱nhen tí ncha̱kuen tí jínahya ntáchro chꞌán kíxin: ―Táníá. Tꞌaxrjéxian tí chꞌín a ―ichro chꞌán. A̱ ntá tí ncha̱kuen tí jínahya kjuáka tí chꞌín a kjuítsínka chꞌán nonte jnko̱siné tí siín sín la kꞌuaxrje tí ncha̱kuen tí jínahya la kohya ninkehó kónhen tí chꞌín kjuítsínka. ");
INSERT INTO poeNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","A̱ ntá kaín sín chrakon sín itjo sín kíchó sín kíxin: ―¿Xá nkexrí kíxin xi̱kaha nixja tí chꞌín i? Jehe chꞌán chónta kjuachaxin kíxin kꞌue̱tue̱nhen chꞌán tí ncha̱kuen tí jínahya kꞌuaxrjexín tí nkexro i ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","A̱ ntá nkuíxín ntiha ikjo sín kíchó sín kíxin nkerí kjuaxroan kjuíchꞌe chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ntá chꞌín Jesús kꞌuaxrjexín chꞌán tí ni̱nko la ntá kꞌuíxenhen chꞌán nto̱e chꞌín Simón. A̱ ntá tí tjan ichꞌe̱e chꞌín Simón mé níhi tjan chónta tjan ijnko sóa jié ntá chronóe̱he̱ sín chꞌán kíxin chrókjuinchekito̱he chꞌán tjan jína. ");
INSERT INTO poeNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ntá kꞌuísén chꞌín Jesús tí tjen tjan ntá kꞌue̱tue̱nhen chꞌán tí sóa a ntá kjuìin. Ntá tuénxín kꞌuàya tjan la ntá kjuanjon tjan nkehe sine sín. ");
INSERT INTO poeNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","A̱ ntá kuétaón ya̱on ntá kaín tí sín chónta sín si̱nníhi chónta sín nchónhya clase chin mé kui̱ka̱o sín tí tjen chꞌín Jesús. Ntá kjuakꞌetja tja chꞌán jnkojnko tí jehe sín a̱ ntá xi̱kaha kuíto̱he sín jína. ");
INSERT INTO poeNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","La ko nchónhya chojni níhi chónta ncha̱kuen tí jínahya la mé kꞌuaxrje tí ncha̱kuen tí jínahya la kꞌóyako la ko ntáchro kíxin: ―Jaha mé Xje̱en Dios ―mé ichro tí ncha̱kuen tí jínahya. Kjánchó chꞌín Jesús kꞌue̱tue̱nhen chꞌán tí ncha̱kuen tí jínahya la kjuanjonhya chꞌán kjuachaxin kíxin tsonixja kíxin ó nohe tí ncha̱kuen tí jínahya kíxin jehe chꞌán na mé tí nkexro Cristo. ");
INSERT INTO poeNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","A̱ ntá tí kóya̱on kꞌuínkaséyan ntá chꞌín Jesús kꞌuaxrjenta chꞌán chjasin sákjui̱ chꞌán nte̱je̱. A̱ ntá kaín tí chojni kjuíkjeyá sín chꞌán la kꞌuitja sín tí tjen chꞌán. Tjinkaon sín chrókjuinchexrjenhen sín chꞌán kíxin sáchrókjuihya chꞌán ókjé. ");
INSERT INTO poeNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Kjánchó kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Tꞌichjánxi̱n kíxin sátsjia kaín chjasin ókjé tso̱xrja̱nka tí tan jína kuènte Dios kíxin nkexrí tí kjuachaxin tꞌe̱to̱an Dios, kíxin xra̱ ó mé kꞌuinka ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","A̱ ntá xi̱kaha kꞌuájikjako chꞌín Jesús kaín tí ni̱nko Israel tí estado Galilea.﻿ ");
INSERT INTO poeNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ntá ijnko ya̱on kjuákꞌe chꞌín Jesús chrínta nta̱yaon Genesaret ntá kóchjina nchónhya chojni na mé kꞌuíxitja kíchó sín kíxin tjinkaon sín chrókuinhin sín itén Dios. ");
INSERT INTO poeNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ntá kꞌuíkon chꞌín Jesús kíxin tjejó iyó ntabárco̱ jehó chjino chrínta nta̱yaon. A̱ ntá tí sín itsé koche mé tsíkꞌaxrjexín sín ntiha la kꞌuéjó sín tjentoá sín la ko tjejótjo̱ne̱má sín tí nchísén tséya sín koche. ");
INSERT INTO poeNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ntá chꞌín Jesús kꞌui̱tꞌótjen chꞌán ijnko tí ntabárco̱ ntiha na mé ntabárco̱ kuènte chꞌín Simón na ntá chronóe̱he̱ chꞌán tí chꞌín Simón kíxin sátsjiko chꞌán ntabárco̱ ijnko chrínta nta̱ kjínhya. Ntá ntahó kjuákꞌenkáya chꞌín Jesús tí nta kjuákꞌetja̱xi̱n chꞌán kjua̱ko̱he̱ chꞌán nchónhya chojni siín chrínta nta̱. ");
INSERT INTO poeNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","A̱ ntá tió kjuixin nixja chꞌán ntá ntáche chꞌán tí chꞌín Simón kíxin: ―Tjíkoa ntabárco̱ tí tjiá nta̱ ni̱nka ntá itérá tí nchísén tse̱yará koche ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ntá kjuáte̱he chꞌín Simón ntáchro chꞌán kíxin: ―Maestro, kjuíchꞌeni xra̱ kuenté tie la tséhyani ninkehó koche. Kjánchó tí jaha xi̱kaha kuétue̱nhénni la mé tsochrꞌánni tí nchísén ínaá ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Na ntá xi̱kaha kjuíchꞌe sín la ntá nchónhya koche tsítsé tí nchísén la ntá tí nchísén kjuankíxin tinkákꞌichje. ");
INSERT INTO poeNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ntá kꞌuèya̱xi̱n sín tja sín kíxin chróxrakoa tí sín chꞌeko sín xra̱ tjejóxenhen tí í jnko ntabárco̱ kíxin tsjinki̱tsa sín. Ntá xráka̱o sín ntabárco̱ kuènte sín ntá kjuínchekaón sín yóí tí ntabárco̱ ntá chrókjuachahya tí ntabárco̱ na tjinkaon chrókꞌuániánkí nta̱. ");
INSERT INTO poeNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ntá xi̱kaha kꞌuíkon chꞌín Simón Pedro ntá kjuákꞌexín tochꞌin chꞌán nkayakon chꞌín Jesús ntá ntáchro chꞌán kíxin: ―Ti̱to̱héni Ìnchéni kíxin jeheni ijnko chojni chónta jie̱ ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Mé xi̱kaha ichro chꞌín Simón kíxin chrakon chꞌán la ko kja̱xin chrakon tí í so sín tjejóko chꞌán kíxin xi̱kaha kónhen xrenájín nchónhya koche. ");
INSERT INTO poeNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","La ko chꞌín Jacobo la ko chꞌín Juan, xje̱en chꞌín Zebedeo, na mé jnkoko̱á chꞌeko sín xra̱ chꞌín Simón, la kja̱xin chrakon sín. Kjánchó ntáche chꞌín Jesús tí chꞌín Simón kíxin: ―Chrakonhya. Senó la koche kꞌuétse̱ la nta jie la náhí la mé chojni tsjéyá ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ntá tió kjuíjiko sín tí ntabárco̱ tí chrínta nta̱ la kuíto̱he sín kaín nkehe kuènte sín ntá chréhe̱ sín sákjuíko sín tí chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Kjuákꞌe chꞌín Jesús ijnko tí chjasin, ntá kui ijnko chojni níhi chónta chinlepra. A̱ ntá tió kꞌuíkon chꞌán tí chꞌín Jesús ntá kjuákꞌexín tochꞌin chꞌán chronóe̱he̱ chꞌán jnkojína ntáchro chꞌán kíxin: ―Ìnchéni, tí tjinkávan jaha la jína chrókjui̱nchekito̱héni jína ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ntá chꞌín Jesús kjuéntoá tja chꞌán ntá kjuakꞌetja tja chꞌán chrítaón tí si̱nníhi ntáchro chꞌán kíxin: ―Méxra̱ xi̱kaha tjínka̱van. Ntá jie si̱ntakito̱ha jína ―ichro chꞌán. Ntá xi̱kaha ichro chꞌán ntá tí chinlepra tuénxín kjuìinhin tí si̱nníhi. ");
INSERT INTO poeNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","A̱ ntá kꞌue̱tue̱nhen chꞌín Jesús tí chꞌín a kíxin chróchenkahya chꞌán ninkexró. Ntáchro chꞌán kíxin: ―Sátjia tjítsjehé tí ncha̱tꞌá la tsjánjuan tí nkehe tsíkꞌe̱to̱an chꞌín Moisés tsꞌáyéhe̱ Dios kíxin ntá tso̱noexín kaín xín chojni kíxin ó kuíto̱ha jína ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Kjánchó a̱ntsí kꞌuíxikónohe sín nkexrí tí kjuaxroan kjuasin chꞌín Jesús, ntá nchónhya chojni kꞌuíxikóchjinehe sín chꞌán kíxin tsinhin sín nkehe tsjako chꞌán, la ko tsito̱exín sín jína tí chin chónta sín. ");
INSERT INTO poeNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Kjánchó chꞌín Jesús la kꞌuaxrjenta chꞌán tí kohya chojni la ntaha nixje̱exín chꞌán Dios. ");
INSERT INTO poeNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","A̱ ntá ijnko ya̱on kjuákꞌekjako chꞌín Jesús na ntá ntiha kꞌuéjótja̱xi̱n iso sín fariseo la ko iso tí sín tjako tí ley, tsíkji̱xi̱n sín kaín tí chjasin ntsí estado Galilea la ko kaín tí chjasin ntsí estado Judea la ko tí chjasin Jerusalén. Ntá tí kjuachaxin kuènte Dios kjua̱ko̱xi̱n chꞌán kíxin sinchekito̱he chꞌán chojni jína. ");
INSERT INTO poeNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ntá kui iso chojni tinkátsénkí sín ijnko chꞌín tsíkꞌen to̱te tjenkáya ijnko kania. Ntá tjinkaon sín chrókꞌuixenko sín chꞌán tí nchia kíxin chrókjuakꞌe chꞌán tí tjen chꞌín Jesús tjetjako chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Kjánchó xitjahya tsꞌixenhen sín kíxin nchónhya chojni síxenhen nchia. Ntá kꞌui̱tꞌótjen sín tí chrítaón nchia, ntá kjuakjìin sín iso teja la ko tí nta sítꞌó ntá ntiha kjuinkaji̱nxi̱n sín tí chꞌín níhi tjenkáya kania ntoí tí tjen chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Na ntá tió kꞌuíkon chꞌín Jesús kíxin imá tinkáchónki sín chꞌán ntá nixje̱he̱ chꞌán tí chꞌín níhi, ntáchro chꞌán kíxin: ―Jaha, ó kjuixin kjuìinhan tí jie̱ chonta ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","A̱ ntá tí sín maestro tjako tí ley la ko tí sín fariseo kjuankíxin sín kjo sín a̱sén sín kíxin: “¿Xá nkexro tíhi chꞌia chꞌán ncheyóhe̱ chꞌán a̱sén chꞌán Dios? Ninkexró xitjahya tsjakjìin ijie̱ kixin jehó Dios mé chónta kjuachaxin tsja̱tse̱n iji̱é chojni”, mé xi̱kaha kjuenka̱yáxin sín. ");
INSERT INTO poeNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ntá chꞌín Jesús la ó nohe chꞌán tí nkehe tjenka̱yáxin sín ntá ntáchro chꞌán kíxin: ―¿Nkekuènte kíxin xi̱kaha tjenka̱yáxinrá? ");
INSERT INTO poeNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Nkehe a̱ntsí xra̱hya chróntátjan chꞌán? ¿Á a̱ntsí xra̱hya chróntátjan chꞌán kíxin ó kjuixin kjuìinhin chꞌán tí ijie̱ yámá chꞌán, o̱ á a̱ntsí xra̱hya chróntátjan chꞌán kíxin chrókꞌuínkatjen chꞌán sáchrókjui chꞌán? ");
INSERT INTO poeNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Méxra̱ ijie tsjáko̱xia̱n kíxin tí Xje̱en Dios Kꞌóna Chojni mé chónta kjuachaxin ntihi chjasintajni tsjakjìinhin iji̱é chojni ―ichro chꞌán. Ntá kꞌue̱tue̱nhen chꞌán tí chꞌín tsíkꞌen to̱te ntáchro chꞌán kíxin: ―Jaha tétua̱nhan tꞌinkatjen tjatsíyan ka̱nia̱a la sátjia nto̱a ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ntá tuénxín kꞌuínkatjen tí chꞌín tsíkꞌen to̱te nkayakon kaín tí sín siín a la kuákja chꞌán ka̱nie̱e chꞌán kꞌuékjakꞌetákꞌá chꞌán ntá sákjuí chꞌán nto̱e chꞌán la kjuanchehe chꞌán Dios kjuasáya. ");
INSERT INTO poeNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ntá kaín sín imá chrakon sín la kjuanchehe sín Dios kjuasáya kjónté chrakon sín la ntáchro sín kíxin: ―Ijie mé kꞌuíkonni a̱ntsí má kjuaxroan jié ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ntá chrꞌéxi̱n ntá chꞌín Jesús kꞌuaxrjexín chꞌán nchia ntá kꞌuíkon chꞌán ijnko chꞌín nchekjènki̱ mé itꞌin chꞌán Leví tjetja̱xi̱n chꞌán tjechꞌe chꞌán xra̱ nkaxenhen tí nchia ntsí tí xenkaxín chichaon a. Ntá ntáchro chꞌán kíxin: ―Chréhé tí janhan ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ntá chꞌín Leví mé tuénxín kꞌuínkatjen chꞌán la ntá kuíto̱he chꞌán kaín xín nkehe ntá chréhe̱ chꞌán tí chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ntá chrꞌéxi̱n chꞌín Leví chónta chꞌán ijnko kia jié nto̱e chꞌán kjuikosáyehe chꞌán tí chꞌín Jesús. Kja̱xin kꞌuéjó itsjé tí sín nchekjènki̱ la ko itsjé í so chojni chónta jie̱ kꞌuéjótja̱xi̱nko sín tí chꞌín Jesús chjino tí mesa a. ");
INSERT INTO poeNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","A̱ ntá tí sín fariseo la ko tí sín maestro tjako tí ley la mé kjuankíxin sín tjonta sín tí sín kꞌuájiko chꞌín Jesús ntáchro sín kíxin: ―¿Nkekuènte ntekoará la ko tꞌikoará tí sín nchekjènki̱ la ko tí sín chónta jie̱? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","A̱ ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Tí chojni níehya tꞌichjánxi̱enhya sín nkexro sichꞌe xro̱a̱n. Náhí. Jehó tí sín níhi mé tꞌichjánxi̱nhin sín nkexro sichꞌehe sín xro̱a̱n. ");
INSERT INTO poeNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Janhan la kꞌuinkahya ntihi kíxin chrókꞌuíya̱ha̱ tí sín jína tjejó. Náhí. Janhan kꞌuinka kíxin tsꞌíya̱ha̱ tí sín chónta jie̱ kíxin chrókuíto̱he sín tí iji̱é sín ntá chrókjuinkí sín tí tjenka̱yáxin sín ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","A̱ ntá kjuanchankíhi sín tí chꞌín Jesús kíxin: ―¿Nkekuènte kíxin tí sín kꞌuékꞌajiko chꞌín Juan jnkoya̱xón nehya sín na nixje̱he̱ sín Dios, la ko kja̱xin xi̱kaha chꞌe tí sín xriko tí sín fariseo, a̱ ntá tí sín xrikoa la ine sín la ko itꞌi sín? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ntá kjuáte̱he chꞌín Jesús kíxin: ―¿Xá chrókjuachará chrókuétue̱nhenrá kaín tí sín tsíkꞌíye̱he̱ sín tsíkóchjina tí tjejó tí sín tsíkóte̱he kíxin chrókjónehya sín tí na̱xa̱ tjejóko sín tí chꞌín tsíkóte̱he? ");
INSERT INTO poeNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Kjánchó tsjixraká tí ya̱on itsi chojni tsotsé sín tí chꞌín tsíkóte̱he sátsjiko sín chꞌán. Ntá tí sín tsíkóchjina la tsꞌává sín la í sinehya sín ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Kja̱xin kjuíncheyóe̱xin chꞌán ntáchro chꞌán kíxin: ―Ninkexró chrókuaté ijnko camisa ni̱xin ntá chrókjuakꞌenie̱he ijnko camisa ntaxin kíxin xi̱kaha chrókjuichꞌe sín ntá chrókꞌuitjáyan tí camisa ni̱xin la ko kja̱xin tí tꞌo̱ ka kꞌuaxrjexín tí camisa ni̱xin tso̱yóe̱hya tí camisa ntaxin. ");
INSERT INTO poeNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kja̱xin chrókuíki̱a̱hyará xranvino ni̱xin ijnko tjua̱xran ntaxin kíxin tí xi̱kaha chrókjui̱chꞌerá la chrókꞌuichje tí tjua̱xran ntaxin ntá chrókꞌuitjáyan tí xran la ko chrókꞌuitjáyan tí tjua̱xran. ");
INSERT INTO poeNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","A̱ ntá tí xranvino ni̱xin chrókuikia ijnko tjua̱xran ni̱xin kíxin yóí la chrókꞌuitjáyanhya. ");
INSERT INTO poeNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","La ko kja̱xin ninkexró tió tsíkꞌi tí xran ntaxin na̱xa̱ chrókóxrjínhi̱n chrókꞌui xran ni̱xin. Náhí. Tsontáchro chꞌán kíxin íchá jína tí xran ntaxin, tsixro chꞌán ―mé xi̱kaha ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ijnko ya̱on tꞌo̱kꞌéhe sín la chꞌín Jesús kꞌuátsínka chꞌán iso nonte tꞌóna noatrigo. Na ntá tí sín kꞌuájiko chꞌán mé ikꞌuín sín iso noatrigo la kjuankíxin sín nkaya tja sín ó kꞌóntajinyá sín tí noa ntá kjóne sín. ");
INSERT INTO poeNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ntá iso tí sín fariseo kjuanchankí sín kíxin: ―¿Nkekuènte kíxin tjejochꞌerá xra̱ jie? La mé kohya kjuachaxin tso̱nhen xra̱ tí ya̱on tꞌo̱kꞌéheni ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ntá kjuáte̱he chꞌín Jesús kíxin: ―¿Jahará á kjui̱nchekuáxinhyará tí xroon chrónka nkehe kjuíchꞌe chꞌín David la ko tí sín kꞌuájiko chꞌán tió kꞌuén sín kjinta? ");
INSERT INTO poeNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Na mé jehe chꞌán mé kꞌuíxenhen chꞌán nto̱e Dios la kjóne chꞌán tí nio̱tja̱ tsíkóyaon, la ko kja̱xin chjéhe chꞌán tí nio̱tja̱ tí sín kꞌuájiko chꞌán kjónté jehó siín kjuachaxin sine tí sín ncha̱tꞌá ―ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Kja̱xin ntáchro chꞌán kíxin: ―A̱ ntá tí Xje̱en Dios Kꞌóna Chojni mé chónta kjuachaxin tsꞌe̱to̱an nkexrí tso̱nhen tí ya̱on tꞌo̱kꞌéheni ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","A̱ ntá í jnko ya̱on tꞌo̱kꞌéhe chojni ntá kꞌuíxenhen chꞌín Jesús ijnko ni̱nko Israel la ntá kjuankíxin kjuako chꞌán. A̱ ntá ntaha kjuákꞌe ijnko chꞌín tsíxámá tja chꞌán chjina. ");
INSERT INTO poeNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Na ntá tí sín tjako tí ley la ko tí sín fariseo tjejó sín tsáyehe sín tí chꞌín Jesús chrókꞌuikon sín á sinchekito̱he chꞌán chojni jína tí ya̱on tꞌo̱kꞌéhe sín kíxin ntá chrókꞌueka sín chꞌán jie̱. ");
INSERT INTO poeNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Kjánchó jehe chꞌán ó nohe chꞌán nkehe tjenka̱yáxin a̱sén sín ntá nixje̱he̱ chꞌán tí chꞌín tsíxámá tja ntáchro chꞌán kíxin: ―Tꞌínkatjen, tjakꞌe jnko̱siné ntihi ―ichro chꞌán. Ntá kꞌuínkatjen tí chꞌín a kjuákꞌexín to̱te chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ntá nixje̱he̱ chꞌín Jesús tí í so sín ntáchro chꞌán kíxin: ―Tsjánchánkíhárá ijnko xra̱. Tí ya̱on tꞌo̱kꞌéheni la, ¿á jína chrókjuichꞌeni ijnko nkehe jína ní o̱ á chrókjuichꞌeni ijnko nkehe jínahya? ¿Á chrókjuinchekito̱heni chojni jína ní o̱ á chrókꞌóyánni chojni? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ntá chꞌín Jesús komá chꞌán kaín tí chojni siín ntiha ntá nixje̱he̱ chꞌán tí chꞌín níhi ntáchro chꞌán kíxin: ―Tjéntoá tjá ―ichro chꞌán. A̱ ntá tí chꞌín a xi̱kaha kjuíchꞌe chꞌán ntá kuíto̱he tja chꞌán jína. ");
INSERT INTO poeNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Kjánchó tí sín fariseo tjejó mé kónínkaon sín mé ntá kjo sín kíchó sín kíxin tjinkaon sín chrókꞌóyán sín tí chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","A̱ ntá ijnko ya̱on chꞌín Jesús sákjui chꞌán ijnko jna̱ kíxin ntaha tsonixje̱exín chꞌán Dios la ntá ntahó kjuákꞌe chꞌán kuenté tie tjenixje̱he̱ chꞌán Dios. ");
INSERT INTO poeNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","A̱ ntá tí kꞌuínkaséyan a na mé kꞌuíye̱he̱ chꞌán tí sín chréhe̱ sín chꞌán ntá kjueyá chꞌán teyó sín kíxin tsꞌóna sín apóstol tsꞌajiko sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","A̱ ntá tí sín í mé xi̱kihi itꞌin sín. Na mé chꞌín Simón la ntá chꞌín Jesús kjuínchekꞌin ihni̱é chꞌán Pedro kja̱xin; la ko kíchó chꞌán chꞌín Andrés; la ko chꞌín Jacobo la ko chꞌín Juan, la ko chꞌín Felipe, la ko chꞌín Bartolomé, ");
INSERT INTO poeNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","la ko chꞌín Mateo, la ko chꞌín Tomás, la ko chꞌín Jacobo la mé itꞌé mé itꞌin Alfeo; la ko í jnko chꞌín Simón na mé tí chꞌín a mé kꞌuékꞌaji tí partido cananista; ");
INSERT INTO poeNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","la ko chꞌín Judas la kíchó chꞌán mé itꞌin Jacobo; la ko chꞌín Judas Iscariote tí chꞌín kjuínchekji tí chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ntá chꞌín Jesús la ko tí jehe sín kꞌuínkaji̱nxi̱n sín tí jna̱ ntá kꞌuéjó sín nonte yóxin jehe chꞌán la ko tí sín kjueyá chꞌán. Kja̱xin kꞌuíxikóchjina nchónhya chojni kjui̱xi̱n nkuíxín estado Judea la ko chjasin Jerusalén la ko tí chrínta nta̱yaon tí siín tí chjasin Tiro la ko tí chjasin Sidón. Ó kjui sín kíxin tsinhin sín tí nkehe tsjako chꞌín Jesús la ko tsito̱he sín jína. ");
INSERT INTO poeNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","A̱ ntá tí sín kjuaxróxinhya kꞌuéjó kꞌuéchónta sín ncha̱kuen jínahya na mé kuíto̱he sín jína kja̱xin. ");
INSERT INTO poeNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kaín chojni tjinkaon chrókuákóxi̱n sín tí chꞌín Jesús kíxin kjuínchekito̱he chꞌán jína kaín xín chojni kíxin jehe chꞌán chónta chꞌán kjuachaxin jié. ");
INSERT INTO poeNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ntá komá chꞌín Jesús tí sín kꞌuájiko chꞌán ntá ntáchro chꞌán kíxin: ―Náxrjón tjejorá jahará nòará kíxin chontará kjua̱cha̱xién Dios. ");
INSERT INTO poeNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Náxrjón tjejorá jahará tꞌénxinrá kjinta ijie kíxin chrꞌéxi̱n sinterá jína. ’Náxrjón tjejorá jahará tsja̱nkará ijie kíxin chrꞌéxi̱n tsjanorá. ");
INSERT INTO poeNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Náxrjón tjejorá jahará nínkakonhanrá chojni la ko tsꞌinkítíárá sín sátsjirá ókjé, la ko tꞌántaxínhanrá sín la ko tꞌákjenxi̱n sín ihni̱árá éxí ijnko nkehe jínahya kíxin tinkachónkirá tí Xje̱en Dios Kꞌóna Chojni. ");
INSERT INTO poeNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Tso̱cháha̱rá má la ko imá tsochontará kjuachéhe̱ tí ya̱on a kíxin tsꞌayéhérá nkehe kuènte nkaya nka̱jní. A̱ ntá xi̱kaha tí tꞌáchri̱i tí sín jínahya chꞌe la mé ósé kjuate sín tí sín kꞌuéchrónka itén Dios. ");
INSERT INTO poeNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’A̱ ntá jahará rícorá kjuaxróxinhya tsꞌejorá chrꞌéxi̱n kíxin ó kjuixin kꞌuayéhérá kaín nkehe. ");
INSERT INTO poeNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’A̱ ntá jahará kjónterá jína, kjuaxróxinhya tsꞌejorá chrꞌéxi̱n kíxin tsꞌénxinrá kjinta. ’A̱ ntá jahará tjanorá jie, kjuaxróxinhya tsꞌejorá chrꞌéxi̱n kíxin tsꞌavárá la ko tsotsja̱nkará. ");
INSERT INTO poeNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Kjuaxróxinhya tsꞌejorá tió kaín chojni tsjikosáyahará sín kíxin xi̱kaha tí tꞌáchri̱i sín kjuikosáyehe tí sín ntoáhya kꞌuéchronka itén Dios ósé. ");
INSERT INTO poeNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’A̱ ntá jahará tjejotinhínrá mé tjéxrja̱nka kíxin chrótjuèhérá tí sín nínkakonhanrá la ko jína chrókjuínki̱tsará tí sín tjinkakonhya tí jahará. ");
INSERT INTO poeNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Jína nixje̱hérá tí sín tꞌántaxínhanrá la ko tjanchehérá Dios kíxin tsjinki̱tsa chꞌán tí sín chónkíhará sín. ");
INSERT INTO poeNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Tí chjéhe ijnko nkexro ijnko tua̱anrá chrókjóka tí í jnko nánko kíxin chróchjéhe sín tíha kja̱xin. La ko tí siín ijnko nkexro tjinkaon sín tsakitsjaha sín tí chamara tjín tꞌinka̱yate na mé ti̱to̱hé kíxin kja̱xin sátsjiko sín camisá kja̱xin. ");
INSERT INTO poeNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Tí jnkojín nkexro tjanchaha nkehe chonta la chje̱hé sín. A̱ ntá tí tsakja sín nkehe kuèntá la tjanchehya sín kíxin na̱xa̱ tsꞌókjanhan sín. ");
INSERT INTO poeNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Méxra̱ chrókjuíkosáyehérá kíchuárá éxí yóhe̱ nkexrí tjinkáonrá chrókjuikosáyahará tí jehe sín kja̱xin. ");
INSERT INTO poeNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Tí jehó tjuèhérá tí nkexro tjuàhará la tí xi̱kaha la kohya ninkehó tsjachahyará. Kjónté tí sín jínahya tjasin jie̱ la xi̱kaha chꞌe sín. ");
INSERT INTO poeNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","A̱ ntá tí tjíkosáyehérá jehó tí sín tjikosáyahará la kohya ninkehó tsjachahyará xi̱kaha. Kjónté tí sín jínahya tjasin jie̱ mé kja̱xin xi̱kaha chꞌe sín. ");
INSERT INTO poeNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","La ko tí nchekjenrá chichaon jehó tí sín tjenka̱yáxinrá kíxin tsꞌókjanhanrá sín tí chichaon, la tí xi̱kaha kohya ninkehó tsjachahyará. Kjónté tí sín jínahya tjasin jie̱ xi̱kaha chꞌe sín nchekjen kíchó sín chichaon la ko chónhen sín kíxin tsokjan tí chi̱cha̱ko̱en sín ínaá. ");
INSERT INTO poeNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Kjánchó jahará chrótjuèhérá tí sín nínkakonhanrá la ko jína chrókjui̱chꞌeherá sín xra̱ la ko chrókjui̱nchekjenrá sín chichaon la chróchoénhyará kíxin chrókjan tí chi̱cha̱ko̱anrá ínaá. Mé xi̱kaha chrókjui̱chꞌerá la imá tsjachará la ko tsꞌónará xje̱en Dios nkaya nka̱jní kíxin jehe chꞌán chꞌehe chꞌán jína tí sín chóntehya chꞌán kjuasáya la ko tí sín jínahya. ");
INSERT INTO poeNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Chrókui̱konóe̱hérá kíchuárá éxí yóhe̱ Itꞌárá nkaya nka̱jní ti̱konóe̱he̱ chꞌán chojni. ");
INSERT INTO poeNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Chrókuékahyará jie̱ ókjé chojni kíxin ntá Dios chrókjuanchahya chꞌán jie̱ tí jahará. Chrókuétua̱nhyará kíxin chrókjuasóte í jnko chojni kíxin Dios kja̱xin chrókjuinchekjasótiahyará chꞌán tí jahará. Chrókꞌuitjáyanhanrá ichrén jie̱ kjuasinhanrá í jnko chojni kíxin ntá Dios chrókjuinchekꞌitjáyanhanrá chꞌán tí jie̱ kjuásinrá. ");
INSERT INTO poeNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Chje̱hérá í so sín tí nkehe tsꞌáyéhe̱ sín kíxin ntá Dios tsotjáhará chꞌán nkehe jína kja̱xin, tjetóxin ijnko medida jína chrókjuanjon chꞌán, icha tsíkꞌe̱nka̱ chꞌán kíxin tsíkꞌótsjéyehe chꞌán tí nkehe tsíkjachro̱ayá chꞌán tjetóxin tsjanjon chꞌán. Dios tsotjáhará xi̱kaha yóhe̱ éxí tsíchje̱hérá í so chojni. ");
INSERT INTO poeNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ntá kjuíncheyóe̱xin chꞌín Jesús ntáchro chꞌán kíxin: ―¿Xá á chrókójína ijnko chojni tꞌikonhya chrókjuiko í jnko chojni tꞌikonhya? Tí xi̱kaha la yóí sín chrókꞌuanótjenyá sín ichrén tòye̱. ");
INSERT INTO poeNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ijnko nkexro xrako̱he̱ la noehya éxí tí nkexro tjako. Kjánchó tió tsjixin tsoxrako̱he̱ chꞌán ntá tso̱nohe chꞌán éxí nohe tí nkexro kjua̱ko̱he̱ chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿A̱ ntá nkekuènté tsjehé tí chji̱nínó ntsí tjenkánkí ikon tí kíchuá, tí na̱xa̱ ánto̱sán tí nta jié tjenkánkí ikuan? ");
INSERT INTO poeNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Mé xi̱kaha nkexrí kíxin chróntáche kíchuá kíxin chrókuíto̱he chꞌán kíxin chrókuakitsjenkíhí chꞌán tí chji̱nínó ntsí tjenkánkí ikon chꞌán tí na̱xa̱ ánto̱sán tí nta jié tjenkánkí ikuan? Jaha la ntoáhya tjenka̱yáxian chꞌia jaha. Senó chrókuakitsjenkiá tí nta jié tjenkánkí ikuan kíxin ntá chrókꞌuikuan chrókuakitsjenkiá chji̱nínó ntsí tjenkánkí ikon tí kíchuá. ");
INSERT INTO poeNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Kohya nta jína chrókꞌóna to jínahya, la ko kja̱xin kohya nta jínahya chrókꞌóna to jína. ");
INSERT INTO poeNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Jnkojnko tí nta mé tjatso̱anxínni tí to tꞌóna. Tí ntachꞌi̱ xitjahya tsjakjinjinni to higo la ko xitjahya tsꞌinni to uva. ");
INSERT INTO poeNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ijnko chojni jína la jína nixja chꞌán kíxin jína a̱sén chꞌán. A̱ ntá ijnko chojni jínahya la mé nixja tí nkehe jínahya kíxin jínahya a̱sén chꞌán. Kíxin éxí tjenka̱yáxin a̱sén mé xi̱kaha nixja irꞌva. ");
INSERT INTO poeNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿Nkekuènte ntáchrorá kíxin janhan Ìnchárá, la ntá tahyará kuenté tí nkehe tétua̱nhanrá? ");
INSERT INTO poeNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Méxra̱ kaín tí nkexro tóchjina tinhin tí nkehe ntáxrja̱n la ko titekaon sín la mé tsontáxrja̱n nkexro tí tóyóhe̱ sín. ");
INSERT INTO poeNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Na mé jehe sín tóyóhe̱ ijnko nkexro kjuíchꞌéna nchia la senó kꞌóxra̱ya chꞌán tòye̱ ni̱nka kíxin ntá sichꞌéna chꞌán nchia chrítaón tí tjo̱ a. A̱ ntá tió kꞌuánkí tí nta̱río la ikui tí nta̱ kꞌuíntate tí nchia, kjónté xi̱kaha la kꞌuátjoákohya la ní kuínkíhya tí nchia a kíxin jína tsíkꞌóna chrítaón tjo̱ tjekjen. ");
INSERT INTO poeNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","A̱ ntá tí nkexro tinhin tí nkehe ntáxrja̱n la ntá tahya sín kuenté la mé tóyóhe̱ ijnko nkexro kjuíchꞌéna nchia chrítaón nche la kohya tjo̱ chrínkí. A̱ ntá tió kꞌuánkí tí nta̱río la ikui tí nta̱ kꞌuíntate tí nchia la ntá kꞌuátjoáko nta̱ tí nchia la ntá kuenté tí nchia la kꞌuítjáyan ―mé ichro chꞌín Jesús.﻿ ");
INSERT INTO poeNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ntá chꞌín Jesús kjuixin nixje̱he̱ chꞌán tí chojni a ntá sákjuí chꞌán chjasin Capernaum. ");
INSERT INTO poeNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ntaha kjuákꞌe ijnko capitán romano la mé chónta chꞌán ijnko nkexro chꞌehe chꞌán xra̱ imá tjuèhe chꞌán la ntá jie níhi tí chꞌín a tjetꞌen chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","A̱ ntá tió kuínhin tí chꞌín capitán itjo sín nkexrí tjen chꞌín Jesús ntá ichrꞌán chꞌán iso sín táda judío tsjijitsjehe sín tí chꞌín Jesús tsochronóe̱he̱ sín chꞌán kíxin chrókjuiji chꞌán chrókjuinchekito̱he chꞌán jína tí chꞌín chꞌehe chꞌán xra̱. ");
INSERT INTO poeNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ntá kjuíji sín kóchjinehe sín tí chꞌín Jesús kjuankíxin chrónóe̱he̱ sín chꞌán ntáchro sín kíxin: ―Imá jína tí chꞌín capitán la mé tjinkaon chꞌán chrókjuinki̱tsa chꞌán ");
INSERT INTO poeNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","kíxin tjuèhe chꞌán tí nación kuènteni la ko jehe chꞌán kjuínki̱tsa chꞌán la ko kꞌue̱to̱an kíxin tsꞌóna ijnko ni̱nko kuènteni ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ntá chꞌín Jesús sákjuiko sín chꞌán. Ntá ó kjuíjichjina sín chjino tí nchia la mé tí chꞌín capitán kꞌue̱tue̱nhen chꞌán iso chojni chóxin chꞌán tsontáche sín tí chꞌín Jesús kíxin: ―Tadá. Tjinkakonhya chꞌán chrótjáha chꞌán xra̱ kíxin jehe chꞌán la jehya chojni jína la ko chrókósuèhe̱ kíxin chrókꞌuíxe̱nhén nto̱e chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Mé xi̱kaha chrókósuèhe̱ chꞌán chrókjuiji chꞌán chrókjueyá chꞌán tí jaha. Méxra̱ tí kjuachaxin chrónixja ó chrókuito̱exín jína tí chꞌín chꞌehe chꞌán xra̱. ");
INSERT INTO poeNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kíxin jehe chꞌán kja̱xin tꞌítuenhen chꞌán la ko kja̱xin chónta chꞌán soldado tꞌe̱tue̱nhen chꞌán ínaá. Tió tꞌe̱tue̱nhen chꞌán ijnko sín kíxin sátsji la mé sátsji la ko tió tꞌe̱tue̱nhen chꞌán í jnko sín kíxin xrákoa la mé xrákoa la ko tió tꞌe̱tu̱e̱nhen chꞌán í jnko sín kíxin sichꞌe ijnko xra̱ la mé nchexiteyá chꞌán ―mé xi̱kaha ichro tí sín kui. ");
INSERT INTO poeNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ntá ó kuínhin chꞌín Jesús xi̱kaha ntá chrakon chꞌán kíxin xi̱kaha tjenka̱yáxin tí chꞌín a, a̱ ntá nkátjíá chꞌán komá chꞌán tí chojni chréhe̱ ntáchro chꞌán kíxin: ―Ntáxrja̱n kíxin na̱xa̱ kꞌuítjahya nijnko nkexro israelita xi̱kaha tinkáchónki éxí tí chꞌín i ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","A̱ ntá ó kjan nchia tí sín tsíkꞌítuenhen la ó kꞌuíkon sín kíxin ó tsíkito̱he jína tí chꞌín níhi. ");
INSERT INTO poeNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ntá chrꞌéxi̱n ntá sákjui chꞌín Jesús ijnko chjasin itꞌin Naín la ko sákjuíko chꞌán tí sín kꞌuájiko chꞌán la ko nchónhya í so chojni. ");
INSERT INTO poeNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Tió kjuíjichjina sín tí chjasin a la kꞌuíkon sín nchónhya chojni sákjuíkja̱va sín ijnko chojni tsíkꞌen na mé tí jnkoko̱á xje̱en ijnko tjan kꞌán. Itsjé chojni chjasin ntiha sákjuíkotoxi̱n sín tjan. ");
INSERT INTO poeNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ntá tió kꞌuíkon Ìnchéni tí tjan a ntá kui̱konóe̱he̱ chꞌán tjan ntáchro chꞌán kíxin: ―Tsja̱nkahya ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ntá chꞌín Jesús kóchjinehe chꞌán tí sín tinkátsénkí tí nkexro tsíkꞌen la kjuakꞌetja tja chꞌán tí nkehe tinkátsénkía sín tí chꞌín tsíkꞌen. A̱ ntá tí sín kuámá nta kꞌuéjóchónhen sín. Ntá chꞌín Jesús nixje̱he̱ chꞌán tí chꞌín tsíkꞌen ntáchro chꞌán kíxin: ―Ntásoá. Tétua̱nhan tꞌàya ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ntá tí chꞌín tsíkꞌen tuénxín kjuákꞌetja̱xi̱n chꞌán la ko kjuankíxin nixja chꞌán. Ntá chꞌín Jesús kjuínchekꞌáyéhe̱ chꞌán ìné tí chꞌín ntasoá la sákjuíko. ");
INSERT INTO poeNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","A̱ ntá tió kꞌuíkon sín xi̱kaha kónhen la kaín sín imá chrakon sín la ko kjuankíxin kjuanchehe sín Dios kjuasáya ntáchro sín kíxin: ―Dios mé ichrꞌán ijnko chojni imá tꞌe̱to̱an chrónka itén Dios tsꞌejókoni ―ichro sín. Kja̱xin ntáchro sín kíxin: ―Ó kui Dios tsjinki̱tsa chꞌán chjasén chꞌán ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","A̱ ntá nkuíxín estado Judea la ko kaín tí chjasin chjinaxón mé kuínhin sín kíxin nkehe tí kjuaxroan kjuíchꞌe chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","A̱ ntá tí sín kꞌuájiko chꞌín Juan mé chénka sín chꞌán kaín tí nkehe tsíkónhen. Ntá kꞌuíye̱he̱ chꞌán iyó tí sín kꞌuájiko chꞌán ");
INSERT INTO poeNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","kꞌue̱tue̱nhen chꞌán sín sátsjitsjehe sín tí chꞌín Jesús tsjikjanchankíhi sín chꞌán kíxin á jehe chꞌán tí nkexro tsi o̱ á tsochónhen sín í jnko nkexro, tsixro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","A̱ ntá tí sín ichrꞌán chꞌín Juan mé kóchjina sín tí tjen chꞌín Jesús ntáchro sín kíxin: ―Chꞌín Juan Bautista kꞌue̱to̱an chꞌán kuini tsikjanchankíhani kíxin á jaha tí nkexro tsi ní o̱ á tsochónhenni í jnko nkexro ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","A̱ ntá tí ya̱on kjuíji sín na mé chꞌín Jesús kjuínchekito̱he chꞌán itsjé chojni jína la mé kjua̱tse̱n chꞌán kaín tí chin chónta sín la ko kuakitsje chꞌán tí ncha̱kuen jínahya chónta sín la ko kjuínchekꞌikon chꞌán itsjé chojni tꞌikonhya. ");
INSERT INTO poeNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","A̱ ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Sátjírá tjíchenkará tí chꞌín Juan kaín nkehe kꞌuíkonrá la ko kaín nkehe kuínhínrá kíxin tí sín kꞌuíkonhya la ó tꞌikon sín jie, la ko tí sín kꞌuékjihya la ó tji sín jie, la ko tí sín kꞌuéchónta chinlepra la ó kuíto̱he sín jína, la ko tí sín kíenhya la ntá jie la ó tinhin sín, la ko tí chojni tsíkꞌen la ó síxechón sín jie, la ko tí sín nòa síxrako̱he̱ sín tí tan jína tsaáxin sín. ");
INSERT INTO poeNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ntá náxrjón tjen tí nkexro kohya nkehe tꞌinkákonhe̱n tí tinkáchónki sín tí janhan ―mé ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Tió sátsíkji tí sín ichrꞌán chꞌín Juan ntá kjuankíxin nixje̱he̱ chꞌín Jesús tí sín kꞌuéjó ntiha kíxin nkexrí tjen chꞌín Juan ntáchro chꞌán kíxin: ―Tió sákjuítsjehérá chꞌín Juan nte̱je̱, ¿nkexrí kꞌuíkonrá tí jehe chꞌán? ¿Á kꞌuíkonrá chꞌán éxí ijnko tji nchexrayehe xri̱nto̱? ");
INSERT INTO poeNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Tí náhí, ¿la ntá nkehe kꞌuíkonrá? ¿Á kꞌuíkonrá chꞌán éxí ijnko nkexro tsíkꞌitsa jína? Jahará ó nohará kíxin chojni tsíkꞌitsa jína la ko chónta kaín nkehe náxrjón la mé nto̱e rey tjejó sín. ");
INSERT INTO poeNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿A̱ ntá nkexrí kꞌuíkonrá chꞌán? ¿Á kꞌuíkonrá chꞌán éxí ijnko nkexro chrónka itén Dios? Na mé xrja̱nka kíxin chaxín xi̱kaha jehe chꞌán na mé a̱ntsí tꞌe̱to̱an chꞌán la ntá tí sín kꞌuéchrónka itén Dios ósé la kánhyó. ");
INSERT INTO poeNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Chꞌín Juan mé tí nkexro kui éxí chrónka tí xroon itén Dios ósé ntáchro kíxin: Janhan mé tsochrꞌan ijnko nkexro tsochrónka itan kuènta̱na tsitónxin nti̱a, kíxin tsjasiyóxin chꞌán nti̱a kuèntá. Mé xi̱kaha chrónka tí xroon itén Dios. ");
INSERT INTO poeNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ntá ijnko nkehe chaxín tso̱tjo̱nka̱rá kíxin kaín tí nkexro kꞌuéjó senó kꞌuéchrónka itén Dios la kánhyó tjetoan sín la a̱ntsí tjetoan tí chꞌín Juan Bautista. Kjánchó ijnko nkexro kjónté tjetuanhya la tí tsꞌáyéhe̱ sín tí kjua̱cha̱xién Dios nkaya nka̱jní la a̱ntsí tjetoan sín a̱ ntá jehe chꞌín Juan la kánhyó ―ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","A̱ ntá tió kuínhin sín tíhi la ntá kaín tí chojni la ko tí sín nchekjènki̱ tsíki̱ki̱te chꞌín Juan la ó kjuátso̱an sín kíxin Dios la jína chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Kjánchó tí sín fariseo la ko tí maestro tjako tí ley tsíki̱ki̱tehya chꞌín Juan la mé tjinkakonhya sín tí nkehe tjinkaon Dios chrókjuinki̱tsa tí jehe sín. ");
INSERT INTO poeNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ntá ntáchro Ìnchéni kíxin: ―¿Nkexrí chrókjui̱ntayóa̱xian tí chojni tjejó jie? ¿Nkehe chrókóyóhe̱ sín? ");
INSERT INTO poeNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Tóyóhe̱ sín tí chánjan tjejótja̱xi̱n sín tí ntasin tsítán sín la tꞌíye̱he̱ kíchó sín ntáchro sín kíxin: “Kjuínchentáchroni flauta la te̱hyará la ko tsjeni isón kuènte chojni tsíkꞌen la tsja̱nkahyará.” ");
INSERT INTO poeNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Kíxin ó kui chꞌín Juan Bautista la kjónehya chꞌán nio̱tja̱ la ko kꞌuíhya chꞌán vino la ntá jahará ntáchrorá kíxin ijnko ncha̱kuen tí jínahya chónta chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","A̱ ntá kja̱xin ikui tí Xje̱en Dios Kꞌóna Chojni la kjóne chꞌán la ko ikꞌui chꞌán la ntáchrorá kíxin imá kjóne chꞌán la ko imá ikꞌui chꞌán vino la ko tꞌito chꞌán tí sín tjasin jie̱ la ko tí sín nchekjènki̱. ");
INSERT INTO poeNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","A̱ ntá tí xje̱en Dios mé tja̱ko̱xi̱n sín kaín tí nkehe tjinkaon Dios. ");
INSERT INTO poeNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ijnko chꞌín fariseo mé chronóe̱he̱ chꞌán tí chꞌín Jesús kíxin tsjiji chꞌán nto̱e chꞌán sineko sín chꞌán. Ntá sákjui chꞌán nto̱e tí chꞌín a, a̱ ntá ntiha kjuákꞌetja̱xi̱n chꞌán tí tjen mesa. ");
INSERT INTO poeNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","A̱ ntá itjen ijnko tjan nchónhya jie̱ chónta tjan. Itjen tjan tí chjasin ntiha la ntá kónohe tjan kíxin tsíkjiji chꞌín Jesús nto̱e tí chꞌín fariseo la ko ntaha sineko sín chꞌán. Ntá kui tjan ntiha kui̱ka̱o tjan ijnko xro̱ tjete tsíkaón aceite xraxé náxrjón. ");
INSERT INTO poeNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ntá tsjánka tjan kóchjina tjan to̱té chꞌín Jesús ntá nta̱kon tjan kjuátanxín to̱té chꞌán la ko ka̱xi̱hi tjan kjuínchexámáxin tjan to̱té chꞌán la ko kjóneko kochíto to̱té chꞌán la ko kjuíncheka tjan to̱té chꞌán tí aceite xraxé náxrjón. ");
INSERT INTO poeNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","A̱ ntá tió kꞌuíkon tí chꞌín fariseo tsíkꞌíye̱he̱ tí chꞌín Jesús ntá kjo chꞌán a̱sén chꞌán kíxin: “Tí chrókóchaxín tí nkexro i ijnko chꞌín chrónka itén Dios ntá chrókónohe chꞌán kíxin nkexrí xéhe tí tjan tjetákóxi̱n chꞌán kíxin ijnko tjan jínahya tíha”, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ntá chꞌín Jesús ntáche chꞌán tí chꞌín fariseo kíxin: ―Simón, janhan chonta ijnko nkehe tsonixja̱ha ―ichro chꞌán. Ntá kjuáte̱he tí chꞌín fariseo ntáchro chꞌán kíxin: ―Chro̱nka, Maestro ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ntá ntáchro chꞌín Jesús kíxin: ―Kꞌuéjó yaá chojni ntoa síkéhe sín chichaon ijnko chꞌín nchekjen chojni chichaon. Ijnko la síká chꞌán quinientos denario. A̱ ntá tí í jnko a la síká chꞌán cincuenta denario. ");
INSERT INTO poeNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","A̱ ntá kjuachahya sín kꞌókjenhen sín tí chichaon tí chꞌín síkéhe sín ntá kui̱konóe̱he̱ chꞌán sín ntá kꞌóxíka chꞌán tí cuenta síká yóí sín. A̱ ntá jie chro̱nka jaha kíxin nkexro tí yóí sín a̱ntsí chrótjuèhe tí nkexro kui̱konóe̱he̱ chꞌán ―ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ntá kjuáte̱he tí chꞌín Simón ntáchro chꞌán kíxin: ―Janhan ntáxrja̱n tí nkexro kui̱konóe̱he̱ má ―ichro chꞌán. Ntá ntáchro chꞌín Jesús kíxin: ―Ntoá tjenka̱yáxian ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ntá chꞌín Jesús komá chꞌán tí tjan a ntá ntáche chꞌán tí chꞌín Simón kíxin: ―¿Á tꞌikuan tí tjan a ní? Janhan na mé kꞌuíxa̱nha̱n nto̱a la ntá jaha la kjuánjonhya nta̱ chrókꞌontia to̱tená. Kjánchó jehe tjan ti nta̱kon tjan kjuínchekꞌóntixín tjan to̱tená la ko ka̱xi̱hi tjan kjuínchexámáxin tjan. ");
INSERT INTO poeNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","A̱ ntá jaha la kjóntekoahyana kochíto. Kjánchó jehe tjan na̱xa̱ kuíto̱ehya tjan neko kochíto to̱tená. ");
INSERT INTO poeNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Jaha la kuíki̱texinhya aceite kja̱. A̱ ntá jehe tjan kui̱ki̱te tjan aceite xraxé náxrjón to̱tená. ");
INSERT INTO poeNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Mé xi̱kaha ntáxrja̱n kíxin imá tjua̱na tjan kíxin kaín tí nchónhya jie̱ kjuasin tjan la mé kjuìinhin tjan. A̱ ntá ijnko nkexro kjuìinhin i̱ntsíkoá jie̱ la mé xi̱kaha intsíkoá tja̱ko̱xi̱n kíxin tjua̱na sín ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ntá nixje̱he̱ chꞌán tí tjan a ntáchro chꞌán kíxin: ―Ó kjuìinhan tí jie̱ chonta ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","A̱ ntá kaín tí sín tsíkóchjina sín kꞌuéjótja̱xi̱n sín tí tjen chꞌán mé kjuankíxin kjo sín kíchó sín ntáchro sín kíxin: ―¿Xá nkexro tíhi kíxin tjakjìinhin chꞌán iji̱é chojni? ");
INSERT INTO poeNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","A ntá chꞌín Jesús ntáche chꞌán tí tjan a kíxin: ―Ó kuaá jaha kíxin kuítekávan tí janhan. A̱ ntá jie kjuaxróxin sátsjia nto̱a ―ichro chꞌán.﻿ ");
INSERT INTO poeNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","A̱ ntá chrꞌéxi̱n ntá chꞌín Jesús kꞌuáji chꞌán itsjé chjasin hyé la ko chjasin ntsíntsí kjuako chꞌán la ko chrónka chꞌán tí tan jína kíxin nkexrí tí kjuachaxin tꞌe̱to̱an Dios. A̱ ntá tí teyó sín mé kꞌuájiko chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Kja̱xin chréhe̱ iso chojni chjin tsíkjinchekito̱he chꞌán jína tsíkakitsje chꞌán tí ncha̱kuen tí jínahya kꞌuéchónta sín la ko tsíkja̱tse̱n chꞌán tí chin kꞌuéchónta sín. Ijnko tjan mé itꞌin María la ko kja̱xin tikitexín tjan Magdalena na mé tsíkꞌaxrje yato ncha̱kuen tí jínahya kꞌuéchónta tjan, ");
INSERT INTO poeNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","la ko í jnko tjan itꞌin tjan Juana ne mé xìi mé itꞌin chꞌán Chuza. Jehe chꞌán mé chꞌehe chꞌán xra̱ tí chꞌín Herodes tꞌe̱to̱an chꞌán, la ko í jnko tjan mé itꞌin tjan Susana, la ko itsjé í so sín kꞌuéjó sín. A̱ ntá kaín sín kjuanjon sín tí nkehe kꞌuéchónta sín kjuínki̱tsa sín tí chꞌín Jesús la ko tí sín kꞌuájiko chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ntá nchónhya chojni kójnkotsé sín kjuítsjehe sín tí chꞌín Jesús, kꞌuaxrjexín sín kaín tí chjasin ntiha. A̱ ntá chꞌín Jesús kjuíncheyóe̱xin chꞌán ntáchro chꞌán kíxin: ");
INSERT INTO poeNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Éxí ijnko chꞌín sákjuíkꞌe̱nka̱ noatrigo no̱nte̱e chꞌán. Mé xi̱kaha sákjuí chꞌán ikꞌue chꞌán tí noatrigo a. Ntá iso noa la kꞌuanótjen chrínta nti̱a ntá nkaxénjin chojni tí noa a la ko kja̱xin tí koxroxe kꞌuìnka̱ va. ");
INSERT INTO poeNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","A̱ ntá í so la kꞌuítji chríkꞌá xro̱ ntá kꞌuayan la xámá kíxin kánhyó siín tjo. ");
INSERT INTO poeNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","A̱ ntá í so la kjuítsínkákꞌá kachꞌi̱ ntá kꞌuánkí kachꞌi̱ la ntá í xitjahya kꞌuánkí tí no a kíxin tsíkja̱te tí kachꞌi̱. ");
INSERT INTO poeNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","A̱ ntá í so la mé tsíkꞌitjí nche jína. A̱ ntá tió kꞌuánkí la kꞌóna jína la mé jnkojnko noatje kꞌóna ciento neno noa ―mé xi̱kaha ichro chꞌán. Na ntá kjuixin kjuako chꞌín Jesús kaín tíha ntá itsen ntáchro chꞌán kíxin: ―Tí tjinkáonrá chrókuinhínrá la tinhínrá ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ntá tí sín kꞌuájiko chꞌán kjuanchankíhi sín chꞌán kíxin nkexrí tꞌaxrjexín tí nkehe kjuíncheyóe̱xin chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ntá ntáchro chꞌán kíxin: ―Dios mé tsjinki̱tsa kíxin tso̱nohará tí nkehe noehya í so chojni nkexrí tꞌe̱to̱an Dios. Kjánchó tí í so sín tjáko̱ha̱ sín kjui̱ntayóa̱xoán kíxin ntá kꞌuíkon sín la kjónté tsjátso̱anhya sín la ko kuínhin sín na kjónté na̱xa̱ tienxínhya sín. ");
INSERT INTO poeNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Ntá tso̱xrja̱nka nkexrí tꞌaxrjexín tí nkehe kjui̱ntayóa̱xoán. Tí noatje mé tí itén Dios. ");
INSERT INTO poeNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","A̱ ntá tí noa kꞌuanótjen chrínta nti̱a la mé tóyóhe̱ tí sín kuínhin tí tan a. A̱ ntá ó kui chꞌín Tsochren ntá kjuínchekꞌitjáyan chꞌán kaín tí itén Dios kuínhin sín chrókuaáxin sín kíxin ntá chrókuitekakonhya sín tí nkehe chrókuaáxin sín. ");
INSERT INTO poeNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","A̱ ntá tí noa kjuítsínkakꞌá xro̱ la éxí yóhe̱ tí chojni kuínhin itén Dios la tjoka kóxrjínhi̱n sín kuinkáchónki sín. Na ntá itsi tí kjuaxróxinhya, a̱ ntá tsíto̱he sín tí itén Dios kuínhin sín kíxin na̱xa̱ ni̱nkahya chónta nuèe. ");
INSERT INTO poeNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","A̱ ntá tí noa kjuítsínkakꞌá kachꞌi̱ na mé éxí yóhe̱ ijnko chojni kuínhin tí tan jína kjánchó tjitoxi̱enhya nti̱e sín kíxin tóxakonhen sín tí xra̱ chónta sín la ko tjinkaon sín tsochónta sín itsjé nkehe la ko kaín tí nkehe tóxrjínhi̱n sín mé tꞌinkákonhe̱n kíxin xi̱kaha la xitjahya sichꞌehe sín xra̱ Dios. ");
INSERT INTO poeNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","A̱ ntá tí noa kꞌuínka nonte jína na mé éxí yóhe̱ tí chojni kuínhin tí itén Dios a̱ ntá kaín a̱sén sín kuítekaon sín la ntá kuíto̱ehya sín tí tan, a̱ ntá xi̱kaha la jína chꞌehe sín Dios xra̱. ");
INSERT INTO poeNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Nijnko nkexro chrókjuinchekꞌákjen xrohi chrókjua̱kꞌe̱ma̱ nkaxenhen chi̱ o̱ chrókjua̱kꞌe̱ma̱ chrínkí cama. Náhí. Noi chrókjuakꞌe xrohi kíxin ntá tí sín tsꞌixenhen nchia tsꞌikonxín sín tí tꞌinkaséyan. ");
INSERT INTO poeNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Kohya nkehe chrókꞌuejómá a̱ ntá chrꞌéxi̱n chrókónoxínhya; la ko kohya nkehe mó chrókónoehyani chrꞌéxi̱n kíxin kaín nkehe la tso̱noxíxin ti xrohi a. ");
INSERT INTO poeNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","A̱ ntá chrókuinhínrá jína kíxin tí tjen ijnko nkexro chónta nkehe la mé tsꞌáyéhe̱ chꞌán má. A̱ ntá tí nkexro chóntahya nkehe la mé tsꞌaxrjehe chꞌán kjónté tí nkehe ntsí tónhen chꞌán kíxin chónta chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","A̱ ntá kjuíji ìné la ko kíchó chꞌín Jesús tí tjen chꞌán. Ntá xitjahya tso̱chjinehe sín chꞌán kíxin nchónhya chojni siín. ");
INSERT INTO poeNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","A̱ ntá ijnko sín ntiha tsíkjichenka chꞌín Jesús kíxin: ―Ìná la ko kíchuá tjejó sín ntója la tjinkaon sín chrókꞌuikon sín tí jaha ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Kjánchó kjuáte̱he chꞌán ntáchro chꞌán kíxin: ―Tí sín tinhin itén Dios la ko titekaon sín na mé tꞌíkua̱n tí jehe sín éxí na̱ná la ko kíchiná ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ntá ijnko ya̱on kꞌuíxenhen chꞌín Jesús ijnko ntabárco̱ la koí tí sín kꞌuájiko chꞌán. Ntá ntáchro chꞌán kíxin: ―Sátsjini tóhe̱ nta̱yaon ―ichro chꞌán. Ntá sákjuí sín. ");
INSERT INTO poeNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ntá nachrohe tjejótꞌatòye̱ sín a̱ ntá chꞌín Jesús mé kjuákꞌejua chꞌán. A̱ ntá xrína̱hya tji̱a̱n chjéhe xri̱nto̱ chrítaón nta̱ ntá xrankíxin sítikia nta̱ tí ntabárco̱ ntá chrakon sín kíxin tsꞌaniankí nta̱ tí ntabárco̱. ");
INSERT INTO poeNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ntá kjuínchekjaye̱he sín tí chꞌín Jesús, ntáchro sín kíxin: ―Maestro, Maestro. Tjejótꞌaniankíni nta̱ ―ichro sín. Ntá chꞌín Jesús kꞌuàya chꞌán ntá kꞌue̱tue̱nhen chꞌán tí xri̱nto̱ la ko tí nta̱ kíxin tsꞌixita, a̱ ntá náxrjón kꞌuíxita tí nta̱ la ko tí xri̱nto̱. ");
INSERT INTO poeNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ntá ntáche chꞌán tí sín kꞌuájiko chꞌán kíxin: ―¿Á na̱xa̱ tinkachónkihyará Dios? ―ichro chꞌán. Kjánchó jehe sín mé chrakon sín itjo sín kíchó sín kíxin: ―¿Xá nkexro tíhi kíxin tꞌe̱tue̱nhen chꞌán xri̱nto̱ la ko tí nta̱ la titekakonhen chꞌán? ");
INSERT INTO poeNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ntá kjuíji sín tí nonte Gadara, na mé tóhe nta̱yaon ntoí chókꞌèxin estado Galilea. ");
INSERT INTO poeNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ntá kꞌuínkaji̱nxi̱n chꞌín Jesús tí ntabárco̱ ntá kóchjina ijnko chꞌín chjasin ntiha. Ntá ó má sé chónta chꞌán ncha̱kuen tí jínahya. Na ntá ni ké chꞌán tꞌinkáyahya chꞌán, la ko jehya nto̱e chꞌán kꞌuékjakꞌe chꞌán na mé tjen chꞌán tí panteón. ");
INSERT INTO poeNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Tió kꞌuíkon chꞌán tí chꞌín Jesús ntá kjuákꞌexín tochꞌin chꞌán nkayakon tí chꞌín Jesús, ntá kꞌóyako chꞌán ntáchro chꞌán kíxin: ―¿Nkekuènte tji̱a̱té tí jeheni, jaha Jesús Xje̱en Dios itjen nkaya nka̱jní? Chronóa̱hani nchekjasótehyani ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Xi̱kaha ntáchro chꞌán kíxin chꞌín Jesús tsíkꞌe̱tue̱nhen tí ncha̱kuen tí jínahya kíxin tsꞌaxrjexín tí jehe chꞌán. Nchónhya veces tí ncha̱kuen tí jínahya kꞌuékꞌe̱tue̱nhen tí jehe chꞌán; a̱ ntá tí chojni kꞌuétsé sín chꞌán kꞌuékjinchenteto sín tja chꞌán la ko to̱té chꞌán la mé cadena tsíkóntetoxín chꞌán kíxin tjinkaon sín chrókjuakꞌe chꞌán. Kjánchó kꞌuékóchrínjin chꞌán tí nkehe tsíkóntetoxín chꞌán kíxin ncha̱kuen tí jínahya tjinkaon sáchrókjui̱ko chꞌán nte̱je̱. ");
INSERT INTO poeNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ntá chꞌín Jesús kjuanchankíhi chꞌán tí chꞌín a kíxin: ―¿Nkexrí itꞌian? ―ichro chꞌán. Ntá kjuáte̱he chꞌán ntáchro chꞌán kíxin: ―Legión mé itꞌinni ―ichro chꞌán. Ntáchro chꞌán xi̱kaha kíxin nchónhya ncha̱kuen tí jínahya chónta chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","A̱ ntá kaín tí ncha̱kuen tí jínahya chronóe̱he̱ tí chꞌín Jesús kíxin chrókꞌue̱to̱anhya chꞌán kíxin chrókjuitsínkayá tí tòye̱ ni̱nka. ");
INSERT INTO poeNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","A̱ ntá ntiha tí jna̱ siín nchónhya cochíno xrine va. A̱ ntá tí ncha̱kuen tí jínahya chronóe̱he̱ tí chꞌín Jesús kíxin chrókjuanjon chꞌán kjuachaxin chrókꞌuixenhen tí cochíno a. A̱ ntá kjuanjon chꞌán kjuachaxin. ");
INSERT INTO poeNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","A̱ ntá tí ncha̱kuen tí jínahya kꞌuaxrjexín tí chꞌín a, a̱ ntá kꞌuíxenhen tí cochíno a. A̱ ntá kaín tí cochíno kuinká va sákjuí va nó nkaya tsa̱ka kꞌuánótjenkí va nta̱ kjuínhin va nta̱. ");
INSERT INTO poeNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","A̱ ntá tí sín sítꞌayakonhen tí cochíno kꞌuíkon sín kíxin xi̱kaha kónhen ntá chrakon sín kuinká sín sákjuíchronka sín tí chjasén sín la ko tí rancho. ");
INSERT INTO poeNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","A ntá tí chojni kꞌuaxrjexín sín chjasin sákjuitsjehe sín nkehe tí tsíkónhen. A̱ ntá kjuíji sín ntiha tí tjen chꞌín Jesús ntá kꞌuíkon sín kíxin ntaha tjen tí chꞌín tsíkꞌaxrjexín tí ncha̱kuen tí jínahya. Ntaha tjetja̱xi̱n chꞌán chrínkí to̱té tí chꞌín Jesús, ó tsíkꞌinkáya chꞌán iké chꞌán kíxin ó jína tjen chꞌán, a̱ ntá chrakon sín tí kꞌuíkon sín xi̱kaha. ");
INSERT INTO poeNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","A̱ ntá tí jehe sín tsíkꞌikon sín kíxin xi̱kaha kónhen la chrónka sín kíxin nkexrí kuíto̱he jína tí chꞌín kꞌuéchónta tí ncha̱kuen tí jínahya. ");
INSERT INTO poeNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","A̱ ntá kaín tí chojni chjasin Gadara kjuankíxin chronóe̱he̱ sín tí chꞌín Jesús kíxin sáchrókjuixin chꞌán ntiha kíxin imá chrakon sín. A̱ ntá tí chꞌín Jesús kꞌui̱tꞌótjen chꞌán tí ntabárco̱ sákjuíxin chꞌán ntiha. ");
INSERT INTO poeNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","A̱ ntá tí chꞌín tsíkꞌaxrjexín tí ncha̱kuen tí jínahya chronóe̱he̱ chꞌán tí chꞌín Jesús kíxin á chrókjuanjonhya chꞌán kjuachaxin sáchrókjui chꞌán koí chꞌán. Kjánchó chꞌín Jesús kꞌue̱tue̱nhen chꞌán kíxin tsito̱he chꞌán ntáchro chꞌán kíxin: ");
INSERT INTO poeNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Tito̱ha satjia nto̱a la ko chro̱nka nkexrí ti kjuachaxin jié kuènte Dios kuíto̱axián jína jaha ―ichro chꞌán. A̱ ntá sákjuí tí chꞌín a chrónka chꞌán nkuíxín tí chjasén chꞌán kíxin ijnko kjuaxroan jié kjuíchꞌe chꞌín Jesús kjuínchekito̱he chꞌán jína. ");
INSERT INTO poeNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Tió chꞌín Jesús kjan chꞌán tí í jnko chrínta nta̱ ntá nchónhya chojni siín ntiha la chéhe̱ sín kjuíji chꞌán ntiha, kíxin kaín sín tjejóchónhen sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ntá kui ijnko chꞌín itꞌin Jairo na mé ijnko chꞌín tꞌe̱to̱an kuènte ni̱nko. A̱ ntá kjuákꞌexín tochꞌin chꞌán to̱te tí chꞌín Jesús chronóe̱he̱ chꞌán kíxin sáchrókjui chꞌín Jesús nto̱e chꞌán ");
INSERT INTO poeNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kíxin chónta chꞌán jnkoko̱áxón xje̱en chꞌán chjin chónta teyó nánó la ó mero tjetꞌen tjan. A̱ ntá sákjuí chꞌín Jesús la ntá nchónhya chojni chréhe̱ kꞌuíxitja kíchó sín. ");
INSERT INTO poeNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ntá siín sín ntiha. Na mé ntiha tjenkákjan ijnko chojni chjin níhi tjan sítji tjan jni̱ na mé chónta tjan teyó nánó tito̱ehya tjan jína. A̱ ntá kaín nkehe kꞌuéchónta tjan kjue̱nke̱he tjan tí sín chꞌe xro̱a̱n la ko nijnko sín kjuachahya sín kjuínchekito̱he sín tjan jína. ");
INSERT INTO poeNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","A̱ ntá jehe tjan kóchjina tjan nóton tí chꞌín Jesús na ntá kuákóxi̱n tjan tí iké chꞌán, a̱ ntá tuénxín tí jni̱ la í kjuíhya tjan. ");
INSERT INTO poeNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ntá kjuanchankí chꞌín Jesús kíxin: ―¿Nkexro tí kuákóxi̱nna? ―ichro chꞌán. A̱ ntá kaín sín ntáchro sín kíxin ninkexró, ichro sín. A̱ ntá chꞌín Pedro la ko tí sín kꞌuéjóko chꞌán ntáchro sín kíxin: ―Maestro, nchónhya chojni siín la ko tótéka sín la ntáhi ntáha, ¿ntá nkekuènte kíxin na̱xa̱ tjanchankiá kíxin nkexro tí kuákóxian? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Kjánchó ntáchro chꞌín Jesús kíxin: ―Jnkojín nkexro kuákóxi̱nna kíxin kónòna kíxin kjuachaxin kuènta̱ná kuíto̱exín ijnko chojni jína ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","A̱ ntá tió kꞌuíkon tjan kíxin ó kónoxín ntá kóchjina tjan chrakon tjan kjuákꞌexín tjan tochꞌin tjan chrínkí to̱té tí chꞌín Jesús. Ntá chrónka tjan nkayakon kaín xín chojni kíxin nkekuènte kuákóxi̱n tjan iké chꞌán la ko nkexrí kuíto̱exín tjan jína xi̱kaha. ");
INSERT INTO poeNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ntá ntáchro chꞌán kíxin: ―Jaha, xje̱enni, ó kuíto̱ha jína kíxin kuítekávan tí janhan. Kjuaxróxin sátjia ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Na̱xa̱ tjejótjo sín ntiha ntá xrína̱hya ikui ijnko nkexro kjui̱xi̱n nto̱e tí chꞌín tꞌe̱to̱an kuènte ni̱nko, a̱ ntá chénka chꞌán tí chꞌín tꞌe̱to̱an kíxin: ―Xja̱an na mé ó kjuixin kꞌuén. Áxri í chje̱éhya xra̱ tí maestro ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","A̱ ntá tió kuínhin chꞌín Jesús la kjuáte̱he chꞌán ntáchro chꞌán kíxin: ―Chrakonhya. Títekávan tí janhan la tsito̱he xja̱an jína ―ichro chꞌán. A̱ ntá sákjuí sín. ");
INSERT INTO poeNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","A̱ ntá tí kjuíjikꞌixenhen sín nchia ntá kuíto̱ehya chꞌín Jesús kíxin ókjé nkexro chrókꞌuixenko chꞌán nchia. Jehó chꞌín Pedro la ko chꞌín Jacobo la ko chꞌín Juan la ko tí itꞌé la ko tí ìné tí xjachjin chrókꞌuixenhen sín tí tjen tí xjan a. ");
INSERT INTO poeNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Kaín tí sín tjejó ntaha tsjánkàma̱ sín tí xjan a. Kjánchó jehe chꞌán ntáchro chꞌán kíxin: ―Tsja̱nkahyará. Tí xjan la tsíkꞌenhya la tjejua xjan ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ntá tjanoá sín chꞌán kíxin jehe sín la ó nohe sín kíxin tsíkꞌen xjan. ");
INSERT INTO poeNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","A̱ ntá jehe chꞌán itsé chꞌán tja xjan ntá itsen kꞌuíye̱he̱ chꞌán tí xjan ntáchro chꞌán kíxin: ―Tjarisoá, tꞌàya ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ntá kjan a̱sén tjan ntá tuénxín kꞌuínkatjen tjan. Ntá kꞌue̱to̱an chꞌín Jesús kíxin tsjanjon sín nkehe sine tjan. ");
INSERT INTO poeNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ntá itꞌé la ko ìné xjan la chrakon sín. A̱ ntá chꞌín Jesús kꞌue̱tue̱nhen chꞌán sín kíxin ninkexró chróchenkahya sín kíxin xi̱kaha kónhen.﻿ ");
INSERT INTO poeNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ntá chꞌín Jesús kꞌue̱to̱an kíxin tso̱chjina tí teyó sín kꞌuájiko chꞌán. Ntá chjéhe chꞌán sín kjuachaxin tsakitsje sín kaín tí ncha̱kuen tí jínahya chónta chojni la ko sinchekito̱he sín chojni jína. ");
INSERT INTO poeNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ntá kꞌue̱to̱an chꞌán kíxin sátsjikjako sín nkexrí tí kjuachaxin tꞌe̱to̱an Dios la ko sinchekito̱he sín chojni jína. ");
INSERT INTO poeNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","La ko kꞌue̱to̱an chꞌán kíxin: ―Ninkehó nkehe sátsjikohyará nti̱a sátsjirá, ni tí nta tjíxinrá la náhí, ni bolsa la náhí, ni nio̱tja̱, ni chichaon, la ko tsjíkoará jehó tí ka tjejóyará ó. ");
INSERT INTO poeNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","A̱ ntá tí tsjasánrá ijnko nchia tsjanjon sín kjuachaxin la ntahó tsito̱hará la tsjixixín tí xra̱ ntá sátsjíxinrá ntiha. ");
INSERT INTO poeNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","A̱ ntá tí tsjasánrá ijnko chjasin la ntá tsjanjonhya sín kjuachaxin tsjàkorá ntá tꞌaxrjéxinrá tí chjasén sín ntiha tsotsénkará tí nche chónta to̱tárá tsjáko̱xi̱nrá xi̱kaha kíxin Dios sinchekjasóte tí jehe sín ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ntá sákjuí sín kaín tí chjasin ntsíntsí sákjuíchronka sín tí tan jína tsaáxin chojni la ko kjuínchekito̱he sín chojni jína kaín chjasin. ");
INSERT INTO poeNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","A̱ ntá tí chꞌín Herodes tꞌe̱to̱an kuínhin chꞌán kaín tí xra̱ tjechꞌe chꞌín Jesús la tóxakonhen chꞌán kíxin iso sín ntáchro sín kíxin chꞌín Juan Bautista la ó tsíxechón chꞌán, ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","A̱ ntá iso sín ntáchro sín kíxin chꞌín Elías tsíxechón chꞌán mé tí nkexro kꞌuéchronka itén Dios ósé. A̱ ntá í so sín la ntáchro sín kíxin jnkojín tí sín kꞌuéchronka itén Dios ósé la mé ó tsíxechón, ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Kjánchó ntáchro chꞌín Herodes kíxin: ―Janhan mé kuéto̱an kóchrínjin sín kja chꞌín Juan. ¿Á chrókóchaxín jehe chꞌán kíxin nchónhya kjuaxroan kui̱nha̱n tí tjechꞌe chꞌán? ―ichro chꞌán. A̱ ntá kja̱xin jehe chꞌán tóxakonhen chꞌán sáchrókjuitsjehe chꞌán tí chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","A̱ ntá tió kjan tí sín kꞌuájiko chꞌín Jesús ntá chénka sín tí jehe chꞌán kaín tí xra̱ kjuíchꞌe sín. Ntá kꞌuaxrjentako sín chꞌán tí kohya ninkexró chjinaxón chjasin Betsaida. ");
INSERT INTO poeNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ntá tió kꞌuíxikónohe chojni kíxin ntaha tjen chꞌín Jesús ntá sákjuíchréhe̱ sín chꞌán. A̱ ntá kjuanjon chꞌán kjuachaxin tsꞌejó sín. Ntá kjuankíxin chrónka chꞌán nkexrí tjen tí kjuachaxin tꞌe̱to̱an Dios la ko kjuínchekito̱he chꞌán chojni jína. ");
INSERT INTO poeNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","A̱ ntá ó ntá kóntó ntá tí teyó sín kꞌuájiko chꞌín Jesús kóchjinehe sín chꞌán ntáchro sín kíxin: ―Nixje̱hé tí chojni kíxin sátsji sín tí chjasin ntsí la ko tí ichrén nchia chjinaxón sátsjikꞌo̱kꞌéhe sín la ko sátsjikjeyá sín nkehe sine sín kíxin jaha la ó noha kíxin nte̱je̱ tjejóni la kohya nkehe tsochjéheni sín ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Kjánchó chꞌín Jesús ntáche chꞌán sín kíxin: ―Chje̱hérá sín nkehe sine sín ―ichro chꞌán. Ntá kjuáte̱he sín ntáchro sín kíxin: ―Chóntahyani itsjé nkehe; jehó inꞌó nio̱tja̱ la ko yaá koche chóntani. ¿Á tjinkávan sátsjikꞌe̱nani nkehe sine kaín tí chojni siín? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Kíxin siín chjina inꞌó mil chojni ntoa. A̱ ntá chꞌín Jesús ntáche chꞌán tí sín xriko chꞌán kíxin: ―Ntácherá sín tso̱jnkojié sín tsꞌixitja̱xi̱n sín jnkojnko cincuenta sín ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","A̱ ntá xi̱kaha kjuíchꞌe sín kꞌue̱to̱an sín, a̱ ntá kꞌuíxitja̱xi̱n sín kaín sín. ");
INSERT INTO poeNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","A̱ ntá chꞌín Jesús kuákja chꞌán tí nꞌó nio̱tja̱ la ko tí yaá koche. Ntá konta chꞌán nka̱jní kjuanchehe chꞌán kjuasáyé Dios kíxin kjuanjon tí nkehe sine sín. Ntá kóchrítꞌo̱ chꞌán tí nio̱tja̱ la ko tí koche la chjéhe chꞌán tí sín xriko chꞌán. A̱ ntá jehe sín kꞌóxika̱ye̱he sín chjéhe sín kaín tí chojni siín. ");
INSERT INTO poeNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","A̱ ntá kaín sín kjóne sín la kókje̱he sín. A̱ ntá chrꞌéxi̱n kjuenájín sín kaín tí nkehe síxehe̱ mé teyó ntaxra kjuínchekaón sín. ");
INSERT INTO poeNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ntá ijnko ya̱on chꞌín Jesús kꞌuaxrjenta chꞌán tjenixje̱he̱ chꞌán Dios. Ntá tjejóko chꞌán tí sín xriko chꞌán ntá kjuanchankíhi chꞌán tí jehe sín kíxin: ―¿Nkehe ichro tí chojni kíxin nkexro tí janhan? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","A̱ ntá jehe sín kjuáte̱he sín ntáchro sín kíxin: ―Iso sín ntáchro sín kíxin jaha tí Juan Bautista. A̱ ntá í so sín ntáchro sín kíxin jaha la tí chꞌín Elías. A̱ ntá í so sín ntáchro sín kíxin jaha ijnko nkexro kꞌuéchrónka itén Dios ósé mé ó tsíxechón ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","A̱ ntá kjuanchankíhi chꞌin Jesús tí jehe sín kíxin: ―A̱ ntá jahará, ¿nkechrorá, nkexro tí janhan? ―ichro chꞌán. Ntá ntáchro chꞌín Pedro kíxin: ―Jaha tí Cristo ichrꞌán Dios ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ntá chꞌín Jesús kꞌue̱tue̱nhen chꞌán sín kíxin ninkexró tsochenkahya sín kíxin nkexro tí jehe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ntá chénka chꞌán sín kíxin: ―Tí Xje̱en Dios Kꞌóna Chojni tꞌichjánxi̱n tsjasóte nchónhya nkehe tso̱nhen la ko tsitekakuenhya tí sín tꞌe̱to̱an kuènte ni̱nko la ko tí sín tꞌe̱to̱an kuènte tí sín ncha̱tꞌá la ko tí sín maestro tjako tí ley. Tsꞌóyán sín tí jehe chꞌán, kjánchó tí níxin ya̱on na ó tsoxechón chꞌán ínaá ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ntá chrꞌéxi̱n chénka chꞌán kaín sín kíxin: ―Tí chaxín tsochréhérá tí janhan na tꞌichjánxi̱n tsi̱to̱hérá kaín tí nkehe tjaké a̱sánrá, ntá tsamárá tí ntacruz kuèntárá jnkojnko ya̱on, a̱ ntá tsochréhérá tí janhan. ");
INSERT INTO poeNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tí nkexro tjinkaon jehó sinchekaá a̱sén mé tsꞌitjáyan. A̱ ntá tí nkexro sinchekꞌitjáyanxín a̱sén kíxin tinkáchónki tí janhan la tsaá. ");
INSERT INTO poeNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿A̱ ntá nkehe tso̱nhen tí chrókjuacha ijnko chojni chróchónta kaín nkehe siín chjasintajni a̱ ntá kjuachón chrókjuinchekꞌitjáyan chꞌán? ");
INSERT INTO poeNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","A̱ ntá jnkojín chojni chrókósuèhe̱ kíxin tinkáchónki tí janhan la ko tí nkehe tjàkua, a̱ ntá kja̱xin tí Xje̱en Dios Kꞌóna Chojni mé tso̱suèhe̱ chróntáchro chꞌán kíxin chóxin chꞌán tí jehe sín tió tsi chꞌán éxí ijnko rey tsi̱ka̱o chꞌán tí kjuachaxin kuènte Itꞌé chꞌán la ko tí sín ángel jína. ");
INSERT INTO poeNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Tíhi mé ntoá xrja̱nka kíxin iso chojni tjejó ntihi tjejótinhin sín na̱xa̱ tsꞌenhya sín tsꞌikon sín kíxin Dios tsꞌe̱to̱an tí kjuachaxin kuènte chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","A̱ ntá kꞌuátsínka ijní ya̱on tí tsíchronka chꞌán tíhi ntá sákjui̱ko chꞌán chꞌín Pedro la ko chꞌín Juan la ko chꞌín Jacobo la chrìin sín ijnko jna̱ kíxin tsonixje̱he̱ chꞌán Dios. ");
INSERT INTO poeNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ntá chꞌín Jesús tjenixje̱he̱ chꞌán Dios ntá kꞌuíxitóxi̱n nkexrí tsjehe chꞌán la ko tí iké chꞌán la tjóá la ko tjáki̱ni tsjehe. ");
INSERT INTO poeNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ntá xrína̱hya kꞌuíkon sín yaá chojni tjejótjo sín tí jehe chꞌán na mé jehe sín la tí chꞌín Moisés la ko tí chꞌín Elías. ");
INSERT INTO poeNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Imá tꞌinkáséyan jnkontatjen tí tjejó sín tjejótjo sín tí chꞌín Jesús kíxin nkexrí itsꞌen chꞌán la ko nkexrí tsjasótexín chꞌán tí chjasin Jerusalén. ");
INSERT INTO poeNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","A̱ ntá chꞌín Pedro la ko tí sín tjejóko chꞌán la imá kuihi sín kotáchrin; kjónté la kꞌuéjótsjehe sín kꞌuikon sín tí kjuachaxin kuènte chꞌín Jesús la ko kꞌuíkon sín tí yóí chojni ntoa tjejóko sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","A̱ ntá tió sátsji tí yóí sín tjejóko chꞌín Jesús ntá chꞌín Pedro ntáche chꞌán tí chꞌín Jesús kíxin: ―Maestro, jína kíxin tjejóni ntihi. Chrókjuichꞌénani iní nchia la mé ijnko kuèntá la ijnko kuènte chꞌín Moisés la ko ijnko kuènte chꞌín Elías ―ichro chꞌán. Kjánchó chꞌín Pedro í noehya chꞌán nkehe chróntáchro chꞌán kíxin chrakon chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","A̱ ntá na̱xa̱ tjenixja chꞌán ikui ijnko tjui̱ kjuákꞌetja tí jna̱ tjejó sín. Ntá chrakon sín tjejó sín chrínkí tí tjui̱. ");
INSERT INTO poeNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ntá xrína̱hya kuínhin sín chríkjan tí tjui̱ itén nkexro ntáchro kíxin: ―Tíhi mé Xja̱nna, imá tjua̱ha̱ chꞌán. Tinhínrá tí nkehe tsochronka chꞌán la ko tí nkehe tjako chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","A̱ ntá tió kjuixin kuínhin sín tí tan nixja ntá kꞌuíkon sín kíxin jeho chꞌín Jesús tjen. A̱ ntá tí jehe sín la tání sín kíxin xi̱kaha kꞌuíkon sín tí ya̱on a la ninkexró chenkahya sín tí nkehe kꞌuíkon sín. ");
INSERT INTO poeNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","A̱ ntá tí ya̱on chrꞌéxi̱n kꞌuínkaji̱nxi̱n sín jna̱ la ntá nchónhya chojni sákjuixinhin sín nti̱a chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","A̱ ntá ijnko chojni tjenkákjan chꞌán tí chojni kjuíji ntá itsen nixja chꞌán ntáchro chꞌán kíxin: ―Maestro, chronóa̱hani kíxin chrótsjehé tí xje̱enni kíxin jnkoko̱axón ó chóntani a̱ ntá níhi xjan. ");
INSERT INTO poeNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Chónta xjan ncha̱kuen tí jínahya la ntá nchekꞌíyato xjan la ko nchekꞌaniáte xjan nchexrànka̱ xjan kíxin tjotéhe xjan la ko nta̱lóxrjo sítji̱xi̱n irꞌva xjan la ko ncheníhi xjan, na mé chrohya tsjìinhin xjan. ");
INSERT INTO poeNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","A̱ ntá chronóe̱he̱ni tí sín xríkoa chrókuakitsje sín tí ncha̱kuen tí jínahya, kjánchó kjuachahya sín ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Jahará chaxínhya chojni tinkáchónki tí janhan. Jehya jína tjenka̱yáxinrá. ¿Xá hasta nkesá tjinkáonrá tsꞌejóni tsjákohará kixin nunca tꞌitjáhyará? Xrákoa tí xjan ntihi ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","A̱ ntá kóchjina tí chánjan. A̱ ntá tí ncha̱kuen tí jínahya kjuáka xjan nonte la ko kjuínchekꞌaniáte xjan ínaá. Kjánchó chꞌín Jesús jie̱he kꞌue̱tue̱nhen tí ncha̱kuen tí jínahya kíxin tsꞌaxrjexín xjan. Ntá kꞌuaxrje tí ncha̱kuen tí jínahya ntá kuíto̱he xjan jína. A̱ ntá chꞌín Jesús kjuínchekꞌáyéhe̱ tí itꞌé xjan. ");
INSERT INTO poeNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","A̱ ntá kaín sín chrakon sín kíxin kꞌuíkon sín tí kjuachaxin jié kuènte Dios. Na̱xa̱ chrakon sín kaín sín kíxin tí kjuaxroan kjuíchꞌe chꞌín Jesús la ntá ntáche chꞌán tí sín xriko chꞌán kíxin: ");
INSERT INTO poeNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Tinhínrá jína tíhi la ko tꞌitjáyanhyará. Tsotsé sín tí Xje̱en Dios Kꞌóna Chojni la ko tsjikaán sín chꞌán tí tjejó tí sín tꞌe̱to̱an ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Kjánchó jehe sín kienxínhya sín tí nkehe ntáchro chꞌán kíxin na̱xa̱ kjuanjonhya Dios kjuachaxin kíxin chrókuienxín sín, ntá chrakon sín na kjuanchankíehya sín chꞌán kíxin nkexrí tꞌaxrjexín tí nkehe ntáchro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","A̱ ntá tí sín kꞌuájiko chꞌín Jesús kjuankíxin sín itjo sín kíchó sín kíxin nkexro tí jehe sín a̱ntsí má tjetoan tsꞌe̱to̱an. ");
INSERT INTO poeNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Kjánchó chꞌín Jesús kónohe chꞌán nkehe tjenka̱yáxin a̱sén sín. Ntá kuákja chꞌán ijnko chánjan ntá kjuakꞌe chꞌán tí tjen chꞌán ");
INSERT INTO poeNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ntá ntáche chꞌán sín kíxin: ―Tí jnkojín nkexro chrókꞌuáyéhe̱ tí xjan i kíxin tinkáchónki sín tí janhan mé xi̱kaha chrókꞌuáyéhe̱ sín tí janhan. A̱ ntá jnkojín nkexro chrókꞌuáyéhe̱ tí janhan mé xi̱kaha chrókꞌuáyéhe̱ tí nkexro chrꞌánna kꞌuinka. A̱ ntá tí jnkojín nkexro a̱ntsí chrókjuinchehnkehya la mé a̱ntsí chrókꞌuáyéhe̱ kjuachaxin chrókꞌue̱to̱an. ");
INSERT INTO poeNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ntá ntáchro chꞌín Juan kíxin: ―Maestro, kꞌuíkonni ijnko nkexro kjuachaxin ihni̱á kuakitsjexín chꞌán ncha̱kuen tí jínahya chónta chojni. A̱ ntá chénkani chꞌán kíxin xi̱kahya chrókjuichꞌe chꞌán kíxin xrikohyani chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Kjánchó chꞌín Jesús ntáchro chꞌán kíxin: ―Xi̱kahya chróntáche chꞌán kíxin tí nkexro nínkakuenhya tí jeheni la kjá tóxrjínhi̱n tí xra̱ chꞌeni ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","A̱ ntá ó kóchjina tí ya̱on sátsji̱ chꞌín Jesús nkaya nka̱jní, na ntá táhó kjuenka̱yáxin chꞌán sátsji̱ chꞌán chjasin Jerusalén. ");
INSERT INTO poeNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ichrꞌán chꞌán chojni kuitónxin nti̱a a̱ ntá jehe sín sákjui̱ sín ijnko chjasin ntsí estado Samaria sákjuikjeyá sín nchia tsꞌo̱kꞌèxin sín. ");
INSERT INTO poeNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Kjánchó tí sín samaritano kjuanjonhya sín kjuachaxin chrókꞌuejó sín kíxin kꞌuíkon sín kíxin ó xra̱ ó sátsji̱ chꞌán chjasin Jerusalén. ");
INSERT INTO poeNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","A̱ ntá tió kꞌuíkon tí sín kꞌuájiko chꞌán la mé chꞌín Jacobo la ko chꞌín Juan la ntáchro sín kíxin: ―Ìnchéni, ¿á tjinkávan kíxin chrókjuanchiani xrohi chrókꞌuinkaji̱nxi̱n nkaya nka̱jní chrókjuinchekꞌitjáyan tí jehe sín éxí kjuanchia tí chꞌín Elías? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ntá chꞌín Jesús kuinkátjíá chꞌán komá chꞌán tí jehe sín ntá kjuentuéhe chꞌán sín ntáchro chꞌán kíxin: ―Jahará la kjá noahyará nkexro ncha̱kuen chontará. ");
INSERT INTO poeNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Kíxin tí Xje̱en Dios Kꞌóna Chojni kuihya chꞌán kíxin chrókjuinchekꞌitjáyan chꞌán chojni. Náhí. Xra̱ ó ikui chꞌán sinchekaá chꞌán chojni ―ichro chꞌán. Ntá sákjui̱ sín í jnko chjasin ntsí. ");
INSERT INTO poeNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","A̱ ntá jehe sín sákjui̱ sín nti̱a ínaá. Ntá xeta sín ijnko nkexro ntáche chꞌán tí chꞌín Jesús kíxin: ―Ìnchéni, tjinkaonni chróchréhe̱ni tí jaha nketí tjinkávan sátsjia ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ntá chꞌín Jesús kjuáte̱he chꞌán ntáchro chꞌán kíxin: ―Tí koxróntá chónta va itjue̱é va la ko tí koxroxe chónta va ka̱ké va. A̱ ntá tí Xje̱en Dios Kꞌóna Chojni chóntahya nketí tsꞌo̱kꞌèxin chꞌán ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","A̱ ntá ntáche chꞌán í jnko nkexro: ―Chréhé tí janhan ―ichro chꞌán. Kjánchó kjuáte̱he chꞌán kíxin: ―Ìnchéni, ti̱to̱héni senó sátsjikja̱váni itꞌéni ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Ti̱to̱hé kíxin tí chojni tsíkꞌen la jnkokón sín tsíkꞌen tsja̱vá kíchó sín. A̱ ntá jaha la sátsjikjàkua nkexrí tjen tí kjuachaxin tꞌe̱to̱an Dios ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ntá ntáchro í jnko nkexro kíxin: ―Ìnchéni, tjinkaonni tsochréhe̱ni tí jaha. Jehí ti̱to̱hé tsjinixje̱he̱ni tí sín siín nto̱eni ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Kjánchó ntáchro chꞌín Jesús kíxin: ―Tí nkexro kjuankíxin tsotsé chꞌán arado ntá chrókjan chrókotónhen nóton mé xi̱kaha xitjahya sichꞌehe chꞌán Dios xra̱.﻿ ");
INSERT INTO poeNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ntá chrꞌéxi̱n Ìnchéni kjueyá chꞌán í jnko setenta chojni ntá kꞌue̱tue̱nhen chꞌán sín sátsji sín yóyó sín sátsji sín tsitónxin sín nti̱a tí kaín chjasin na ko nkuíxín tjinkaon chꞌán sáchrókjui chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ntá ntáchro chꞌán kíxin: ―Chaxín ntáxrja̱n kíxin imá tsíkꞌóna, a̱ ntá tí chojni chꞌe xra̱ mé tsjéhya. Chrókjuanchehérá tí Ìnché nonte kíxin chróchrꞌán chꞌán itsjé chojni chrókjuichꞌe xra̱. ");
INSERT INTO poeNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Sátjirá jahará. Xráxinkáonrá kíxin tétua̱nhanrá sátsjirá éxí kolélo tsꞌejóya̱kjanrá chríkjan tí kolobo. ");
INSERT INTO poeNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Tsjíkoahyará kabólsa̱ la ko tjo̱a̱ tꞌinka chichaon la ko to̱ka̱te̱ tjíkoahyará la ko tí nixje̱hérá chojni tí nti̱a ti̱to̱éhyará kíxin chrókjuintaxrjanhanrá sín. ");
INSERT INTO poeNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","A̱ ntá tió tsꞌixe̱nhenrá jnkojín nchia la senó nixje̱hérá sín ntáchrorá kíxin tsꞌáyéhe̱ sín kjuaxróxin, tsixrorá. ");
INSERT INTO poeNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","A ntá tí tjejó sín kjuaxróxin ntiha la nixje̱hérá sín la tsꞌáyéhe̱ sín kjuaxróxin. A̱ ntá tí la náhí, a̱ ntá tí kjuaxróxin chrókꞌuáyéhe̱ sín na sátsjíkoará ínaá. ");
INSERT INTO poeNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","A̱ ntá tí nchia ntiha chrókjuanjon sín kjuachaxin chrókuito̱hará, ntaha mé tsjanjon sín nkehe chónta sín sinterá la ko itsꞌirá, kíxin tí nkexro chꞌe xra̱ la siín kjuachaxin tsoxenkehe. Tsjíhyará í jnko nchia la ko í jnko nchia. ");
INSERT INTO poeNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","A̱ ntá tsjasánrá ijnko chjasin tsjanjon sín kjuachaxin tsꞌejorá ntiha ntá interá tí nkehe tsjanjon sín. ");
INSERT INTO poeNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Nchekito̱hérá chojni níhi jína. Ntá chenkará sín kíxin tí kjuachaxin tꞌe̱to̱an Dios la kjínhya tjen tí tjejó sín, ichrorá. ");
INSERT INTO poeNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","A̱ ntá tió tsjasánrá ijnko chjasin a̱ ntá tsjanjonhya sín kjuachaxin la ntá tꞌaxrjéxinrá nto̱e sín sátjirá tí nti̱a chjasin ntiha ntá ntáchrorá kíxin ");
INSERT INTO poeNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","kjónté tí nche tsíkꞌixitja to̱tárá tsotsénkará kíxin tsjáko̱xi̱nrá kíxin tí kjuaxróxinhya tsꞌáyéhe̱ sín chrꞌéxi̱n. Kjánchó chrókónohe sín kíxin tí kjuachaxin tꞌe̱to̱an Dios la kjínhya tjen tí tjejó sín, ichrorá. ");
INSERT INTO poeNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ntáxrja̱n kíxin tí ya̱on tsjeje̱xín chjasintajni la kjuaxróxinhya tsꞌatsínka tí chjasin a. A̱ntsí náxrjónhya tí nkehe tsꞌatsínka sín, a̱ ntá tí nkehe tsꞌatsínka chjasin Sodoma la kénhyó ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’Nòará jahará chjasin Corazín. Nòará jahará chjasin Betsaida. Tí chrókꞌuixin tí kjuaxroan tí chjasin Tiro la ko chjasin Sidón éxí kꞌuíkonrá jahará, ntá chrókójehe sín la tjoka chrókjuitóxi̱nhin nti̱e sín, tjoka chrókꞌuinkáya sín ka tié la ko chrókjuikjanjin sín ikja sín nteso, kíxin chrókjua̱ko̱xi̱n sín kíxin tꞌává sín. ");
INSERT INTO poeNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","A̱ ntá tí ya̱on tsito̱exín iji̱é chojni a̱ ntá jahará a̱ntsí tsjasótiará, a̱ ntá tí sín kuènte chjasin Tiro la ko chjasin Sidón la kénhyó tsjasóte sín. ");
INSERT INTO poeNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","A̱ ntá jahará chjasin Capernaum, tjenka̱yáxinrá kíxin imá nohará a̱ ntá sátsji̱rá nkaya nka̱jní, ichrorá. Chaxínhya. Jahará la tsjasinka̱ji̱nrá sátsjirá tí tsjasótexín tí sín tsíkꞌen. ");
INSERT INTO poeNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","’Tí nkexro tinhin tí nkehe ntáchrorá la mé xi̱kaha tinhin tí nkehe ntáxrja̱n la ko tí sín titekakonhya sín tí jahará na mé xi̱kaha titekakonnahya sín tí janhan. A̱ ntá tí nkexro titekakonnahya sín tí janhan xi̱kaha titekakonhya sín tí nkexro chrꞌánna kꞌuinka. ");
INSERT INTO poeNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","A̱ ntá ó kjan tí sín setenta sátsíkji la imá chéhe̱ sín ntáchro sín kíxin: ―Ìnchéni, kjónté tí ncha̱kuen tí jínahya titekakonhenni tió tꞌákjenxi̱nni ihni̱á ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ntá ntáchro chꞌín Jesús kíxin: ―Kja̱ chaxín kꞌuíkua̱n kíxin chꞌín Tsochren kꞌuánótje̱nxi̱n nka̱jní éxí ijnko kjónkíxín xi̱kaha kónhen. ");
INSERT INTO poeNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ó tja̱hárá kjuachaxin kíxin kjónté konche la ko konchi̱a̱ tsinkátjará la ko tsjachahya ninkehó tí kjuachaxin kuènte tí chꞌín Tsochren kíxin ninkehó tso̱anhyará. ");
INSERT INTO poeNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Kjánchó jehya tíha chrókóchàxínrá kíxin tí ncha̱kuen tí jínahya kuítekakonhanrá. Náhí. Chrókóchàxínrá kíxin ihni̱árá ó tsꞌínixín nkaya nka̱jní ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","A̱ ntá tuénxín tí Ncha̱kuen Dios kjuínchechéhe̱ tí chꞌín Jesús ntá ntáchro chꞌán kíxin: ―Tjáncháha̱ kjuasáya Itꞌéni Ìnché nkaya nka̱jní la ko chjasintajni kíxin kjuánjonhya kjuachaxin chrókꞌuitja tí sín imá nohe, a̱ ntá kjuánjuan kjuachaxin kíxin tsꞌitja tí sín noehya. Mé xi̱kaha Itꞌéni, jaha kóxrjínhan kíxin xi̱kaha tso̱nhen. ");
INSERT INTO poeNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","’Tꞌaná mé chjìna kaín xín nkehe. Ninkexró noehya nkexro tí Xje̱en chꞌán. Na mé jehó Itꞌé chꞌán mé nohe. La ko ninkexró noehya nkexro tí Itꞌé chꞌán. Na mé jehó tí Xje̱en chꞌán mé nohe chꞌán la ko tí sín tsíkjeyá chꞌán kíxin tjinkaon chꞌán tso̱nohe sín nkexro Itꞌé chꞌán ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ntá komá chꞌán tí sín kꞌuájiko chꞌán ntá ntáche chꞌán tí jehó sín kíxin: ―Chéhe̱ tí sín kꞌuíkonxín kon sín éxí kꞌuíkonrá. ");
INSERT INTO poeNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ntáxrja̱n kíxin nchónhya tí sín kꞌuéchronka itén Dios ósé la ko nchonhya tí sín rey kꞌuétjinkaon sín chrókꞌuikon sín éxí tꞌikonrá, kjánchó kꞌuíkonhya sín, la ko kꞌuétjinkaon sín chrókuinhin sín tí nkehe tjejotinhínrá jie, kjánchó í kíenhya sín ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ntá ijnko maestro tjako tí ley kꞌuínkatjen chꞌán nixje̱he̱ chꞌán tí chꞌín Jesús tjinkaon chꞌán tso̱noexín chꞌán á chaxín nohe chꞌán tsjate̱he chꞌán ntá kjuanchankí chꞌán kíxin: ―Maestro, ¿nkexrí chrókjuichꞌeni chrókꞌuitjani tí kjuachón jnkochríxín? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―¿Nkexrí nixja tí ley? ¿Nkexrí tiénxian? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","A̱ ntá tí maestro tjako tí ley mé kjuáte̱he chꞌán ntáchro chꞌán kíxin: ―Chrótjuèheni Ìnchéni Dios kaín a̱sénni la ko kaín fuerza chóntani la ko kaín kjuaxrexinkaon kuènténi la ko chrótjuèheni kíchó ni éxí tjuèxínni a̱sénni ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ntá ntáchro chꞌín Jesús kíxin: ―Jína kjuáte̱he. A̱ ntá tí jaha xi̱kaha si̱chꞌe la tsochonta kjuachón ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ntá tí maestro tjako tí ley mé tjinkaon chrókjua̱cha̱xi̱n chꞌán tí chꞌín Jesús ntá kjuanchankí chꞌán ínaá kíxin: ―¿Xá nkexro tí kíchó ni chrótjuèheni, ichrua? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ntá chꞌín Jesús kjuáte̱he chꞌán ntáchro chꞌán kíxin: ―Ijnko chojni kꞌuínkaji̱nxi̱n nó nti̱a kjui̱xi̱n chjasin Jerusalén sátsji chꞌán chjasin Jericó, ntá kuátóhe nti̱a iso síche̱e kueéhe sín chꞌán kaín nkehe sáchrókjuiko chꞌán, la ko iké chꞌán tsíkakitsjehe sín chꞌán, la tsíkjate sín chꞌán, la ntá sátsíkji sín tsíkito̱he sín chꞌán la ó mero tjetꞌen chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ntá xrína̱hya kꞌuátsínka ijnko ncha̱tꞌá tí nti̱a ntiha ntá kꞌuíkon chꞌán xi̱kaha ntá ánto̱sén chꞌán kꞌuátsínké chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","A̱ ntá kja̱xin ijnko chꞌín levita kꞌuátsínka chjinaxón ntiha. Ntá kꞌuíkon chꞌán xi̱kaha ntá ánto̱sén chꞌán kꞌuátsínké chꞌán kja̱xin. ");
INSERT INTO poeNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","A̱ ntá ijnko chꞌín kjui̱xi̱n estado Samaria kꞌuátsínka tí nti̱a ntiha ntá kꞌuíkon chꞌán xi̱kaha tjetsínka tí nkexro ntá kui̱konóe̱he̱ chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ntá kóchjinehe chꞌán tí nkexro tsíkóníhi ntá kjuíchꞌehe chꞌán xro̱a̱n tí síchritꞌo̱ chjéhe chꞌán aceite la ko vino la ko kjuínchentetoxín chꞌán ka. Ntá kjuixin ntá kjuínchekitákꞌá chꞌán tí kolócho̱e chꞌán. Ntá sákjuíko chꞌán ijnko nchia tꞌo̱kꞌèxín chojni ntiha la kꞌuáyakonhen chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ntá tí kóya̱on ntá sátsji tí chꞌín samaritano kuakitsje chꞌán iyó tí chichaon la chjéhe chꞌán tí ìnché tí nchia ntáchro chꞌán kíxin: “Tꞌayakonhén tí nkexro i, a̱ ntá a̱ntsí má tsꞌichjánxi̱nhin chꞌán la tió tsokjan ntá tsjénka̱ha tsꞌókjanhan kaín tíha,” ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","A̱ ntá tí iní nkexro kꞌuátsínka nti̱a la, ¿nkexro tjuèhe tí nkexro kjuíncheníhi tí síche̱e? ―mé kjuanchankí chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","A̱ ntá kjuáte̱he tí maestro tjako tí ley kíxin: ―Tí nkexro kui̱konóe̱he̱ tí jehe chꞌán ―ichro chꞌán. Ntá ntáchro chꞌín Jesús kíxin: ―Sátjia jaha la xi̱kaha chrókjui̱chꞌe ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Na̱xa̱ tjetji chꞌín Jesús kjuíji chꞌán ijnko chjasin ntsí. A̱ ntá ntiha itjen ijnko tjan itꞌin Marta, a̱ ntá kjuanjon tjan kjuachaxin kuíto̱he chꞌán nto̱e tjan ntiha. ");
INSERT INTO poeNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","A̱ ntá tjan Marta chónta tjan ijnko kíchó tjan itꞌin María. A̱ ntá jehe tjan kjuákꞌetja̱xi̱n tjan chrínkí to̱té tí chꞌín Jesús tjetinhin tjan nkehe tí tjechro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","A̱ ntá tjan Marta tóxakonhen tjan kíxin nchónhya xra̱ chónta tjan, ntá kóchjinehe tjan tí chꞌín Jesús ntáchro tjan kíxin: ―Ìnchéni, ¿á tóxakuanhya kíxin tí tjan kíchó ni kuíto̱heni tjan, a̱ ntá jehóni tjechꞌeni kaín xra̱? Ntáche tjan kíxin tsjinki̱tsani tjan ―ichro tjan. ");
INSERT INTO poeNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Kjánchó chꞌín Jesús kjuáte̱he chꞌán ntáchro chꞌán kíxin: ―Marta, Marta, jaha imá tóxakonhan kíxin tꞌinkákonhe̱n nchónhya xra̱ chonta. ");
INSERT INTO poeNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Kjánchó jnkoko̱á nkehe tꞌichjánxi̱n. A̱ ntá tjan María kjueyá tjan tí nkehe a̱ntsí jína la ko ninkexró tsakitsjehya tjan tíha ―ichro chꞌán.﻿ ");
INSERT INTO poeNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","A̱ ntá jnkonaá chꞌín Jesús tjenixje̱he̱ chꞌán Dios ijnko lugar tjen. Ntá kjuixin la ijnko tí sín xriko chꞌán ntáchro kíxin: ―Ìnchéni, tjákohéni nkexrí tsonixje̱he̱ni Dios kixin xi̱kaha chꞌín Juan kjua̱ko̱he̱ chꞌán tí sín kꞌuájiko chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ntá chꞌín Jesús ntáchro chꞌán kíxin: ―Tió nixje̱hérá Dios ntáchrorá kíxin: Itꞌéni tjen nkaya nka̱jní, jaha imá tjóá. Chrókui ti kjuachaxin kuèntá. Chrókjui̱chꞌe tí nkehe tóxrjínhan jaha ntihi chjasintajni éxí tjechꞌe nkaya nka̱jní. ");
INSERT INTO poeNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ijie tsjánjuan tí nio̱tja̱ tꞌichjánxi̱nhinni jnkojnko ya̱on. ");
INSERT INTO poeNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Tꞌóxíka tí nkehe jínahya kjuíchꞌeni kíxin kja̱xin jeheni tsꞌitjáyenhenni tí nkehe kjuíchꞌeheni chojni. Ti̱to̱éhyani jeheni xra̱hya chrókjuasinni jie̱. Nchekaáni kaín tí nkehe jínahya chrókónhenni ―mé xi̱kaha ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Kja̱xin ntáchro chꞌán kíxin: ―A̱ ntá jnkojínrá chróchontará ijnko chojni choxian, a̱ ntá sáchrókjuia nto̱e chꞌán kꞌáxrótjen chróntáche chꞌán kíxin: “Amigo, nchekjenni iyꞌá nio̱tja̱ ");
INSERT INTO poeNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","kíxin na̱ntá ó kui ijnko chojni chóxinni kui̱xi̱n chꞌán kjín kjuíji chꞌán nto̱eni ntá chóntahyani ninkehó tsochjéheni chꞌán.” ");
INSERT INTO poeNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","A̱ ntá tí chrókjuate̱he tí nkexro choxian tjen nkaxenhen chróntáchro kíxin: “Chje̱éhyani xra̱. Tí ntója nto̱eni méhe tꞌikjéhe. A̱ ntá xje̱enni tjejótꞌo̱kꞌèkoni xjan. Ntá xitjahya tsꞌàyani tsotjáhani nkehe”, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ntáxrja̱n kíxin kjónté chrókꞌuàyahya chꞌán chrótjáhya chꞌán nkehe kjónté chóxian chꞌán, kjá tsꞌàya chꞌán tsotjáha chꞌán kaín nkehe tꞌichjánxi̱nhan kíxin tjinkakonhya chꞌán kíxin na̱xa̱ chrókjuakꞌé chrókꞌuèya jaha. ");
INSERT INTO poeNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Mé xi̱kaha ntáxrja̱n kíxin: Tjanchiará nkehe la Dios tsotjáhará; tjéyárá nkehe la tsꞌitjará; tꞌinkará puerta la tsoxitje̱he̱. ");
INSERT INTO poeNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","A̱ ntá tí nkexro tjanchia nkehe la tsꞌáyéhe̱ tí nkehe; la ko tí nkexro tjeyá nkehe la tsꞌitja; la ko tí nkexro tꞌínka puerta la tsoxitje̱he̱. ");
INSERT INTO poeNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’¿Xá jnkojínrá chontará xja̱anrá chrókjuanchahará xjan nio̱tja̱ la ¿á chrókjuánjonrá ijnko xro̱? O̱ chrókjuanchahará xjan koche la ¿a̱ chróchje̱hérá ijnko konche? ");
INSERT INTO poeNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O̱ chrókjuanchahará xjan ko̱ja̱ la ¿á chrókjuánjonrá ijnko konchi̱a̱? ");
INSERT INTO poeNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","A̱ ntá jahará kjónté jínahyará la ó nohará nkehe jína tsochje̱hérá xja̱anrá, la mé a̱ntsí chrókónohará kíxin Itꞌéni tjen nkaya nka̱jní tsotjáhará Ncha̱kuen chꞌán tí jnkojínrá chrókjuanchehérá chꞌán ―ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ntá chꞌín Jesús kuakitsje chꞌán ijnko ncha̱kuen tí jínahya tsíkjinchenósin ijnko chojní. A̱ ntá tió tsíkꞌaxrje tí ncha̱kuen tí jínahya a̱ ntá tí chꞌín xitjahya nixja la jína nixja chꞌán. Ntá kaín chojni chrakon sín kíxin xi̱kaha tsíkjichꞌe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","A ntá jnkojín tí jehe sín ntáchro sín kíxin: ―Tí chꞌín a mé takitsje chꞌán ncha̱kuen tí jínahya kíxin chónta chꞌán kjua̱cha̱xién tí chꞌín Beelzebú mé tí chꞌín Tsochren, na mé jehe chꞌán mé tꞌe̱tue̱nhen kaín tí ncha̱kuen tí jínahya ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","A̱ ntá iso sín tjinkaon sín chrókjua̱cha̱xi̱n sín tí chꞌín Jesús ntá kjuanchehe sín chꞌán ijnko kjuaxroan náxrjón kuènte nkaya nka̱jní. ");
INSERT INTO poeNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Kjánchó jehe chꞌán ó nohe chꞌán nkehe tjenka̱yáxin sín la ntáchro chꞌán kíxin: ―Jnkojín gobierno jnkokónhya tjenka̱yáxin sín ntá tjanjo̱nko kíchó sín na mé tsꞌitjáyan tí kjuachaxin tsꞌe̱to̱anxín sín, la ko tí sín jnkoko̱á nchia jnkokónhya tjenka̱yáxin sín xitjahya tsꞌejóko kíchó sín jnkoko̱á. ");
INSERT INTO poeNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","A̱ ntá kja̱xin tí chꞌín Tsochren chrókjuánjo̱nko kíchó chꞌán, ¿la nkexrí chróchónta chꞌán kjuachaxin na̱xa̱ chrókꞌue̱to̱an chꞌán tí chrókꞌuaxrje tí jínahya? A̱ ntá jahará ntáchrorá kíxin janhan takítsjé ncha̱kuen tí jínahya kíxin tí kjua̱cha̱xién chꞌín Tsochren chonta janhan, ichrorá. ");
INSERT INTO poeNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","A̱ ntá tí xi̱kaha la, ¿ntá nkexro chjéhe kjuachaxin tí sín chréhe̱ tí jahará kíxin tsjacha sín tsakitsje sín ncha̱kuen tí jínahya? Jehe sín mé tja̱ko̱xi̱n sín kíxin jahará ntoáhya tjenka̱yáxinrá. ");
INSERT INTO poeNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","A̱ ntá tí kjua̱cha̱xién Dios mé takítsjéxian tí ncha̱kuen tí jínahya na mé chrókónoaxínrá kíxin tí kjua̱cha̱xién Dios tꞌe̱to̱an chꞌán mé ó kui tí tjejorá. ");
INSERT INTO poeNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’A̱ ntá ijnko chojni jie̱he yamá chica tꞌayakonhen chꞌán nto̱e chꞌán kíxin tí nkehe chónta chꞌán tsꞌitjáyanhya. ");
INSERT INTO poeNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","A ntá itsi ijnko nkexro a̱ntsí má tse̱he̱, a̱ ntá tsjanjo̱nko chꞌán tí ìnché nchia, a̱ ntá tsjacha tsakitsjehe tí ìnché nchia kaín tí chica yamá chꞌán kíxin imá jie̱exín chꞌán. A̱ ntá tí chꞌín a̱ntsí tse̱he̱ mé tsakja chꞌán kaín nkehe siín ntiha. ");
INSERT INTO poeNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Tí nkexro titekakonhya tí janhan mé nínkakonna chꞌán. A̱ ntá tí nkexro tjinki̱tsahya tí janhan mé tꞌinkákonhe̱n tí xra̱ tꞌa̱ ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’A̱ ntá ijnko ncha̱kuen tí jínahya tsíkꞌaxrjexín ijnko chojni na mé ixri tí nonte xámá xritjeyá nketí náxrjón tsꞌo̱kꞌéhe. A̱ ntá tí kꞌuitjahya ntá tjenka̱yáxin kíxin: “Áxri tsokjan nto̱na kꞌuaxrjéxian.” ");
INSERT INTO poeNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","A̱ ntá tió kjan la éxí ijnko chojni tsíkꞌánjón nto̱e la náxrjón tsjehe tí nkaxenhen nchia. A̱ ntá kꞌuíkon tí jínahya xi̱kaha tjen nchia ");
INSERT INTO poeNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","a̱ ntá sákjuíkakjín yato ncha̱kuen tí jínahya a̱ntsí má jínahya. A̱ ntá a̱ntsí má jínahya kónhen tí chꞌín a, a̱ ntá tí senó la kénhyó. Mé xi̱kaha tso̱nhen ijnko chojni kénhya a̱sén tinkáchónki Dios ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ntá chꞌín Jesús tjenixja chꞌán chrónka chꞌán kaín tíha ntá ijnko chojni chjin tjenkákjan tí jehe sín a itsen nixja tjan ntáchro tjan kíxin: ―Chéhe̱ tí nkexro kꞌuaxrjeníxin tí jaha kjuíntakꞌánkiá ―ichro tjan. ");
INSERT INTO poeNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ntá jehe chꞌán kjuáte̱he chꞌán ntáchro chꞌán kíxin: ―A̱ntsí chéhe̱ tí nkexro tinhin tí itén Dios la ko titekaon sín ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ntá nchónhya chojni sítójnkotsé sín tí tjen chꞌín Jesús ntá jehe chꞌán kjuankíxin nixja chꞌán ntáchro chꞌán kíxin: ―A̱ ntá tí chojni siín jie la jínahya sín, a̱ ntá tjanchia sín kíxin chrókjuásian ijnko kjuaxroan náxrjón. Kjánchó tsjáko̱xi̱nhya í jnko kjuaxroan la jehó tí nkehe tsíkónhen chꞌín Jonás. ");
INSERT INTO poeNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ntá éxí yóhe̱ kónhen chꞌín Jonás kónoexín tí sín chjasin Nínive mé xi̱kaha tso̱nhen tí Xje̱en Dios Kꞌóna Chojni la tsꞌikon tí chojni siín jie. ");
INSERT INTO poeNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","A̱ ntá tí ya̱on tsito̱exín iji̱é chojni tjejó jie la mé tí tjan reina kꞌue̱to̱an kjui̱xi̱n nó Sur mé tsꞌinkatjen tjan tsjanchia tjan jie̱ kíxin tí sín tjejó jie. Kíxin jehe tjan imá kjín kjui̱xi̱n tjan tsinhin tjan nkexrí imá kꞌuénohe chꞌín Salomón. A̱ ntá jie itjèn janhan a̱ntsí chonta kjuachaxin, a̱ ntá chꞌín Salomón la kénhyó. ");
INSERT INTO poeNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","La ko tí sin chjasin Nínive kja̱xin tsꞌinkatjen sín tió tsito̱exín iji̱é chojni la tsjanchia sín jie̱ kíxin tí sín tjejó jie la ko tsontáchro sín kíxin chrókjuasóte tí chojni tjejó jie kíxin tió kuínhin tí sín Nínive chrónka chꞌín Jonás itén Dios la kjuitóxi̱nhin sín nti̱e sín. A̱ ntá jie itjèn janhan a̱ntsí má chonta kjuachaxin, a̱ ntá chꞌín Jonás la kénhyó. ");
INSERT INTO poeNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Nijnko chojni chrokjuinchekꞌákjen ijnko xrohi chrókjua̱kꞌe̱ma̱ chꞌán la ko chrókjua̱kꞌe̱hya chꞌán chrínkí ijnko ntacajón. Náhí. Noi chrókjuakꞌe xrohi chrókjuakꞌenkáya candelero kíxin tsꞌikonxín chojni tí tꞌinkaséyan. ");
INSERT INTO poeNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Tí ikonrá mé éxí yóhe̱ ijnko xrohi tꞌinkaséyanxín tí cuerpo kuèntárá. A̱ ntá tí chontará ikonrá jína la ntá kuenté cuerpo kuèntárá chónta xrohi. A̱ ntá tí chontará ikonrá jínahya la ntá kuenté cuerpo kuèntárá la sítié tjen. ");
INSERT INTO poeNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Chrókóxakonhanrá kíxin chrókꞌuayakonhénrá tí xrohi chontará kíxin chrókꞌuankahya kíxin chrókꞌuixitiéhya tí tjejorá. ");
INSERT INTO poeNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","A̱ ntá tí kuenté tí cuerpo kuèntárá chróchónta xrohi la ko nitꞌo̱ chrókꞌuixitiéhya la ntá kuenté la chrókꞌuikonrá jína la éxí ijnko lámpara kuenté chꞌe xra̱ jína. ");
INSERT INTO poeNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","A̱ ntá tió kjuixin nixja chꞌín Jesús ntá ijnko chꞌín fariseo chrónóe̱he̱ chꞌán tí chꞌín Jesús kíxin sátsjiko chꞌán nto̱e chꞌán sineko chꞌán. Ntá tió kjuíji sín ntiha la kꞌuíxenhen sín nchia ntá kjuákꞌetja̱xi̱n chꞌín Jesús chjino tjen tí mesa a. ");
INSERT INTO poeNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","A̱ ntá tí chꞌín fariseo chrakon chꞌán kꞌuíkon chꞌán kíxin chꞌín Jesús kꞌóntihya chꞌán tja chꞌán senó tí sine chꞌán éxí tinkáchónki tí jehe sín. ");
INSERT INTO poeNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kjánchó Ìnchéni ntáchro chꞌán kíxin: ―Jahará fariseorá nchetjóárá tí ntója tí vaso la ko tí plato. A̱ ntá nkaxenhen la tsíkaón kjuache̱e la ko kjuachji̱no̱xínhin. ");
INSERT INTO poeNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Jahará lo̱nti̱rá. ¿A noahyará kíxin tí nkexro kjuíchꞌéna tí ntója la koí tí nkaxenhen kjuíchꞌéna chꞌán? ");
INSERT INTO poeNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Tí chrókjui̱ncheki̱to̱nhénrá chojni nòa kaín a̱sánrá tí nkehe chontará la ntá chrókóxakuanhyará tí chrókꞌónti chojni o̱ náhí. ");
INSERT INTO poeNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’Nòará jahará fariseorá. Jahará chje̱hérá Dios ijnko ite parte kaín kaxro̱a̱n tsjiko tí nkehe sineni. A̱ ntá tahyará kuentá tí nkehe ntoá la ko nkexrí chrótjuèhérá Dios la ko nkexrí chrótjuèhérá kíchuárá. Jína chróchje̱hérá Dios nkehe la ko chrókꞌuitjáyanhyará tí chrókjuínki̱tsará kíchuárá. ");
INSERT INTO poeNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’Nòará jahará fariseorá. Tjinkáonrá tsꞌejokjenrá tí silla náxrjón nkaxenhen ni̱nko la ko tjinkáonrá kíxin jnkojína tsonixjahará sín tió tsoxétará sín ntasin. ");
INSERT INTO poeNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’Nòará jahará maestro tjàkorá tí ley la ko jahará fariseorá. Ntoáhya tjenka̱yáxinrá chꞌiará. Jahará éxí yóhe̱ tòye̱ tsíxravá chojni tsíkꞌen tꞌikonhya chojni la tꞌatsínka sín nátaón la noehya sín kíxin tsíxravá chojni ntiha. ");
INSERT INTO poeNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","A̱ ntá kjuáte̱he ijnko tí maestro tjako tí ley ntáchro chꞌán kíxin: ―Maestro, xi̱kaha ntáchrua la, ¿á kja̱xinhya jeheni kaín ni tꞌántaxínhínni ní? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","A̱ ntá ntáchro chꞌín Jesús kíxin: ―Kja̱xin nòará tí jahará tjàkorá tí ley. Tétue̱nhénrá chojni tsamá sín ijnko nkehe imá ye chrókjuachahya chojni chrókuamá. A̱ ntá jahará nijnko dedo tjárá chrókjuínki̱tsará tí nkehe imá ye yámá sín. ");
INSERT INTO poeNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’Nòará tí jahará. Chꞌénará tja̱tꞌo̱e tí sín kꞌuéchrónka itén Dios ósé tsíkꞌóyán tí sín kꞌuaxrjeníxinrá. ");
INSERT INTO poeNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Xi̱kaha jahará tjáko̱xi̱nrá kíxin ó ncho̱xon tí nkehe kjuíchꞌe tí sín kꞌuaxrjeníxinrá ósé kíxin jehe sín kꞌóyán sín tí nkexro kꞌuéchrónka itén Dios ósé. A̱ ntá jahará chꞌénará tja̱tꞌo̱ tí tsíxravá sín. ");
INSERT INTO poeNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Mé xi̱kaha Dios chónta kjuaxrexinkaon imá jína ntá ntáchro chꞌán kíxin tsochrꞌán chꞌán chojni tsochrónka itén chꞌán la ko tsochrꞌán chꞌán chojni tsjikjako itén chꞌán. A̱ ntá chojni tsꞌóyán jnkojín tí jehe sín la ko tsochónkíhi tí í so sín, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","A̱ ntá Dios mé tsjanchia jie̱ tí chojni siín jie kíxin kꞌuítji ijni̱é kaín tí sín kꞌuéchrónka itén chꞌán ósé desde tí xrankíxin kꞌóna chjasintajni ");
INSERT INTO poeNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","la mé xrankíxixín kꞌuítji ijni̱é chꞌín Abel la mé kjuixixín kꞌóyán sín chꞌín Zacarías kꞌóyánxin sín chꞌán jnko̱siné tí tjen tí altar la ko tí ni̱nko. Ntá Dios sinchekjasóte chꞌán tí sín siín jie kíxin xi̱kaha ikꞌuén kaín tí sín a. ");
INSERT INTO poeNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’Nòará jahará maestro tjàkorá tí ley. Jahará tjinkákonhyará kíxin í so chojni tso̱nohe sín tí nkehe chaxín la ni jahará tjinkákonhyará si̱nchexiteyárá la ko ti̱to̱éhyará kíxin í so chojni chrókjuinchexiteyá sín ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","A̱ ntá kjuixin nixja chꞌín Jesús kaín tíha ntá tí sín maestro tjako tí ley la ko tí sín fariseo imá kónínkakonhen sín chꞌán ntá kjuankíxin sín kjuanchankíhi sín chꞌán nchónhya nkehe ");
INSERT INTO poeNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","chrókjua̱cha̱xi̱n sín chꞌán kíxin áchꞌe ntoáhya chrókjuate̱he chꞌán ntá chrókjuanchia sín jie̱ tí jehe chꞌán.﻿ ");
INSERT INTO poeNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","A̱ ntá nchónhya mil chojni kójnkotsé sín ntá tinkákꞌíntate kíchó sín. Ntá chꞌín Jesús sa̱oxín kjuankíxin chénka chꞌán tí sín kꞌuájiko chꞌán ntáchro chꞌán kíxin: ―Chrókuítekákonhyará tí nkehe ntoáhya tjenka̱yáxin tí sín fariseo chꞌia sín, na mé éxí yóhe̱ tí xro̱a̱n nchekꞌánkí nio̱tja̱ tí nkehe tjako sín. ");
INSERT INTO poeNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kohya nkehe mó jie chrókónoxínhya chrꞌéxi̱n la ko kohya nkehe tjemá jie chrókónoahya chojni chrꞌéxi̱n. ");
INSERT INTO poeNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","A̱ ntá kaín nkehe ntáchrorá tí sítié la chrꞌéxi̱n tsinhin chojni tí ncha̱kotjin; la ko kaín nkehe mó ntáchrorá kꞌuikjéhérá nchia la chrꞌéxi̱n tsꞌèya sín chrítaón nchia tsinhin kaín xín chojni. ");
INSERT INTO poeNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Jahará chojni chóxin kíchó ni mé tjo̱nka̱rá kíxin chróchrakuenhyará tí chojni tꞌóyán tí cuerpo, a̱ ntá chrꞌéxi̱n la kohya nkehe tsjacha sín chrókjuichꞌe sín. ");
INSERT INTO poeNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Kjánchó tjo̱nka̱rá kíxin nkexro chróchrakonhénrá. Chróchrakonhénrá Dios mé tí nkexro tsakitsje kjuachón ntá chónta kjuachaxin tsochrꞌán chojni tí siín xrohi tsjasótexín sín. Tí nkexro a mé chróchrakonhénrá chꞌán má. ");
INSERT INTO poeNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’¿Á chrókóxi̱xi̱nhya inꞌó koxroxe yaá chichaon ntsíntsí? Kjánchó Dios la tsꞌitjáyenhya chꞌán nijnko tí jehe va. ");
INSERT INTO poeNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Kjónté tí ka̱xi̱hi̱ chónta ikjárá la nohe chꞌán nkekja̱ín ka chontará. Méxra̱ chrakonhyará tí jahará kíxin a̱ntsí má tjete sínkí tí jahará. A̱ ntá kjónté nchónhya koxroxe la kánhyó sínkí tíha. ");
INSERT INTO poeNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Ntáxrja̱n kaín tíhi kíxin tí nkexro tsochrónka kíxin tinkáchónkina sín nkayakon chojni la kja̱xin tí Xje̱en Dios Kꞌóna Chojni tsochrónka kíxin chóxin chꞌán tí jehe sín nkayakon tí sín ángel kuènte Dios. ");
INSERT INTO poeNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","A̱ ntá tí sín sinchemá sín kíxin chónhyana sín nkayakon chojni la ntá kja̱xian janhan si̱ntamá kíxin chonhya tí jehe sín nkayakon tí sín ángel kuènte Dios. ");
INSERT INTO poeNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’A̱ ntá jnkojín nkexro tsꞌántaxínhi̱n sín tí Xje̱en Dios Kꞌóna Chojni na̱xa̱ jína tsꞌitjáyan tí jie̱ kꞌuántaxínhi̱n sín. A̱ ntá tí nkexro tsꞌántaxínhi̱n tí Ncha̱kuen Dios la xitjahya tsjìin tí jie̱ tí xi̱kaha tsixro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Tió tsjikoará sín nkaxenhen ni̱nko Israel la ko tí tjejó tí sín tꞌe̱to̱an la ko tí tjejó tí síxre̱é la tóxakuanhyará nkehe tsjate̱herá la ko tóxakuanhyará nkehe tsixrorá ");
INSERT INTO poeNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","kíxin tió tsonixjará la tí Ncha̱kuen Dios sinchexraxinkaonrá nkehe tsixrorá ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ijnko nkexro tjenkákjan tí sin tsíkójnkotsé ntáche chꞌán tí chꞌín Jesús kíxin: ―Maestro, ntáche tí kíchó ni a kíxin tsjanjon chꞌán tí nkehe tónhenni tocar tsíkito̱he itꞌéni tsakjani ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Lo̱ntia jaha. ¿Nkekuènte chrókjui̱chꞌénará juez tí janhan chrókꞌoxika̱ya̱ha̱ tí nkehe chrókuakjará jahará? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Kja̱xin ntáchro chꞌán kíxin: ―Tóxakonhanrá tí chróchontará itsjé nkehe. Jehya tí nchónhya nkehe chróchontará ntá náxrjón chrókꞌuejorá ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ntá kjuíncheyóe̱xin chꞌán ntáchro chꞌán kíxin: ―Kjuákꞌe ijnko chojni rico, a̱ ntá tí no̱nte̱e chꞌán na mé imá kꞌóna. ");
INSERT INTO poeNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","A̱ ntá tí chꞌín rico kjuenka̱yáxin chꞌán ntáchro chꞌán kíxin: “¿Nkexrí chrókjui̱tꞌa jie kíxin chontahya nketí tsꞌínka̱chjina tí noa kꞌónana?” ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ntá kjuenka̱yáxin chꞌán ntáchro chꞌán kíxin: “Ó nòna nkehe si̱tꞌa jie. Tsꞌoxíka tí tꞌinkachjinayá noa chonta ntá si̱tꞌána ijnko a̱ntsí jié tsꞌinkachjinayá kaín nkehe kꞌónana jie chonta. ");
INSERT INTO poeNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ntá tsontátjan a̱senná kíxin: A̱sénni, nchónhya nkehe chonta jaha tsíchjina tsjacha nchónhya nánó. Ntá jie tꞌo̱kꞌáha la inte la itsꞌia la tócháha,” ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Kjánchó ntáche Dios tí jehe chꞌán kíxin: “Lo̱ntia xi̱kaha ichrua la, kíxin ijie tie itsi nkexro tsjanchia a̱sán. A̱ ntá tí nkehe kjuásichjina la, ¿xá nkexro kuènte tíha?” ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Mé xi̱kaha tso̱nhen tí nkexro chónta nchónhya nkehe chjasintajni ntihi, a̱ ntá na̱xa̱ kjueyáhya chꞌán nkehe kuènte nkaya nka̱jní ―mé ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ntá chrꞌéxi̱n ntáche chꞌín Jesús tí sín kꞌuájiko chꞌán kíxin: ―Tjo̱nka̱rá kíxin chrókóxakuanhyará tí nkehe chrókjónterá la ko tí ka chrókꞌuítsa̱rá. ");
INSERT INTO poeNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","A̱ntsí sínkí tí kjuachón, a̱ ntá tí nkehe chrókjónterá la kánhyó sínkí. La ko a̱ntsí sínkí tí cuerpo kuèntárá, a̱ ntá kánhyó sínkí tí ka chrókꞌuítsa̱rá. ");
INSERT INTO poeNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Xráxinkáonrá nkexrí siín tí kontálo. Tꞌe̱nka̱hya va la ko tjáhya va la ko chóntahya va nketí tsꞌi̱nka̱chjinayá va tí noa. Kjánchó Dios la tjanjon nkehe sine va. A̱ ntá jahará la a̱ntsí tjetoan, a̱ ntá tí ko xritjaka la kénhyó. ");
INSERT INTO poeNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Á tjejó jnkojínrá tjenka̱yáxinrá kíxin tí chrókóxakonhanrá má ntá na̱xa̱ chrókꞌuankírá itꞌo̱ metro nte̱toxinrá ínaá? ");
INSERT INTO poeNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","A̱ ntá xitjahya chrókjui̱chꞌerá tíha kjónté ijnko nkehe ntsí, ¿a̱ ntá nkehe tso̱nhen tóxakonhanrá í so nkehe siín? ");
INSERT INTO poeNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Xráxinkáonrá nkexrí sítꞌánkí tí catsjo lirio chꞌehya xra̱ la ko tjo̱nhya. Ntá kjónté ntáxrja̱n kíxin tí chꞌín rey Salomón kaín ka náxrjón kꞌuékꞌinkáya chꞌán na̱xa̱ kjuíncheyóe̱hya chꞌán kíxin a̱ntsí náxrjón tí tsjo a. ");
INSERT INTO poeNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","A̱ ntá xi̱kaha Dios mé nchekꞌitsa chꞌán kaín kayoa kjónté ijie síchón la ntóye tsoche, la mé xi̱kaha tsjanjon chꞌán tí nkehe chrokꞌuítsa̱rá jahará. ¿Ntá nkekuènte kíxin na̱xa̱ titekákonhyará chꞌán? ");
INSERT INTO poeNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","¿Ntá nkekuènte ixrírá tóxakonhanrá xrítjéyárá nkehe sinterá la ko nkehe itsꞌirá? ");
INSERT INTO poeNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","A̱ ntá tí chojni chjasintajni xritjeyá sín kaín tí nkehe a. Kjánchó Itꞌárá ó nohe chꞌán kíxin tꞌichjánxi̱nhanrá kaín tí nkehe a. ");
INSERT INTO poeNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Senó chrókjuéyárá tí kjuachaxin kuènte Dios, a̱ ntá jehe chꞌán mé tsjanjon chꞌán kaín nkehe tꞌichjánxi̱nhanrá. ");
INSERT INTO poeNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Chrakonhyará jahará kolélo kuènta̱na. Kjónté tsjéhyará la Itꞌárá tóxrjínhi̱n chꞌán tsotjáhará chꞌán tí kjuachaxin kuènte chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Nchekjirá kaín nkehe chontará la ntá chje̱herá tí chichaon tí sín chóntahya. A̱ ntá xi̱kaha si̱chꞌerá la tí tjo̱a̱ tꞌinka chi̱cha̱ko̱anrá tso̱ntaxinhya kíxin tí nkehe tjete siín nkaya nka̱jní tsjeje̱hya la ko ntaha kohya xíche̱e la ko tsꞌínhya kué la ko tsꞌitjáyanhya. ");
INSERT INTO poeNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","A̱ ntá tí nkaya nka̱jní tsochontará nkehe tjete la ntá tí nkehe tjenka̱yáxinrá la kja̱xin ntaha tjen. ");
INSERT INTO poeNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Tꞌichjánxi̱n listo tsꞌejochonhénrá la ko tsjakꞌekoará xrohi tjeche. ");
INSERT INTO poeNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Listo chrókꞌuejorá éxí chojni chꞌe xra̱ tjejóchónhen sín tsokja̱nxi̱n tí lámo̱e sín tí tsíkóte̱he chojni kíxin tió tsi chꞌán la tsꞌèya chꞌán, la ntá tsakitje̱he̱ sín tí puerta tjoka. ");
INSERT INTO poeNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Náxrjón tí nkexro chꞌe xra̱ tió chrókjan tí lámo̱e sín chrókꞌuikon chꞌán kíxin na̱xa̱ tjejótsjehe sín. Ntá chaxín ntáxrja̱n kíxin tí chꞌín lamo tsꞌe̱to̱an chꞌán kíxin tsꞌejótja̱xi̱n sín tí tjen mesa ntiha ntá tsjanjon chꞌán nkehe sine sín. ");
INSERT INTO poeNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kjónté chrókui chꞌán kꞌáxrótjen o̱ chrókui chꞌán nantóye mé xi̱kaha chrókꞌuikon chꞌán kíxin tjejótsjehe sín la náxrjón tí sín chꞌehe chꞌán xra̱. ");
INSERT INTO poeNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Chrókónohará tíhi kíxin tí chrókónohe tí ìnché nchia nke hora chrókui tí xíche̱e ntá chrókjuakꞌetsjehe chꞌán chrókuíto̱ehya chꞌán chrókꞌuixenhen xíche̱e tí nto̱e chꞌán chrókueé. ");
INSERT INTO poeNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ntá jahará kja̱xinrá xi̱kaha chrókꞌuejotsjehérá kíxin titàya̱ tsi tí Xje̱en Dios Kꞌóna Chojni. ");
INSERT INTO poeNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","A̱ ntá chꞌín Pedro kjuanchankí chꞌán kíxin: ―Ìnchéni, ¿á jehóni kaín ni kjui̱ncheyóéxian nkehe ntáchrua o̱ kaín chojni? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ntá ntáchro Ìnchéni kíxin: ―¿Nkexro tí tꞌe̱to̱an tí xra̱ jína, a̱ ntá tí lámo̱e tsꞌe̱tue̱nhen kíxin tsꞌayakonhen chꞌán tí chojni siín tí nchia ntiha kíxin tsjanjon chꞌán nkehe sine sín xintii tí hora a? ");
INSERT INTO poeNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Náxrjón tjen tí nkexro a tió tsi tí lámo̱e tsꞌikon chꞌán kíxin na̱xa̱ tjechꞌe tí xra̱. ");
INSERT INTO poeNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Tíhi mé chaxín tsontáxrja̱n kíxin tí chꞌín lamo tsochjéhe chꞌán kaín xra̱ chónta chꞌán tsꞌe̱to̱an tí chꞌín a. ");
INSERT INTO poeNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","A̱ ntá tí chꞌín tꞌe̱to̱an sítónhen xra̱ tsjenka̱yáxin kíxin tjokahya tsokjan tí lámo̱e chꞌán, a̱ ntá tsjankíxin chꞌán tso̱nínkakonhen chꞌán tsjanjo̱nko chꞌán tí í so chojni chꞌé xra̱, tí chojni ntoa la ko tí chojni chjin, a̱ ntá jehe chꞌán sine chꞌán la itsꞌi chꞌán la tso̱koan chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","A̱ ntá tí lamo tsokjan tí ya̱on tjenka̱yáxinhya tí chꞌín chꞌe xra̱, na mé ijnko hora noehya chꞌán. A̱ ntá imá sinchekjasóte chꞌán tí chꞌín kuíto̱hehe xra̱ la ntá tsjasóteko chꞌán tí sín titekakonhya. ");
INSERT INTO poeNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’A̱ ntá tí nkexro nohe chꞌán nkehe tí xra̱ tjinkaon tí lámo̱e chꞌán la tóxakuenhya chꞌán la titekakonhya chꞌán la mé tí chꞌín a imá tsjasóte chꞌán tsꞌekon chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","A̱ ntá tí nkexro noehya nkehe tí xra̱ tjinkaon tí lámo̱e chꞌán ntá chꞌe chꞌán nkehe chrókjuasótexín chꞌán la kjónté kánhyó tsjasóte chꞌán tsꞌekon chꞌán. A̱ ntá tí nkexro kꞌuáyéhe̱ nchónhya nkehe la a̱ntsí tsjé xra̱ tsꞌáyéhe̱ chꞌán sichꞌe chꞌán; la ko a̱ntsí tsjé xra̱ tsoxranchehe tí nkexro kꞌuáyéhe̱ itsjé nkehe. ");
INSERT INTO poeNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Janhan kꞌuinka kíxin si̱ntakꞌákjen xrohi chjasintajni. Áchꞌe ntáxrja̱n kíxin ó tjechrꞌákjen tí xrohi a ntá na̱xa̱ náhí. ");
INSERT INTO poeNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Tꞌichjánxi̱n nchónhya tso̱na tsjasótena. Tóxakonna tsoxiteyájia kaín tíha. ");
INSERT INTO poeNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Á tjenka̱yáxinrá kíxin kꞌuinkakian kjuaxróxin tí chjasintajni ní? Méxra̱ ntáxrja̱n náhí. Jnkoko̱áhya tsjenka̱yáxin chojni xi̱kaha. ");
INSERT INTO poeNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kíxin ijie xrankíxixín inꞌó chojni na̱xa̱ kjéhya jnkoko̱áhya tsjenka̱yáxin sín. Tí iní tso̱nínkakonhen tí yaá. Tí yaá tso̱nínkakonhen tí iní. ");
INSERT INTO poeNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","A̱ ntá tí itꞌé tso̱nínkakonhen tí xje̱en ntoa, la ko tí xje̱en ntoa tso̱nínkakonhen tí itꞌé. A̱ ntá tí ìné tso̱nínkakonhen tí xje̱en chjin, la ko tí xje̱en chjin tso̱nínkakonhen tí ìné. Tí ichꞌe̱e tso̱nínkakonhen tí tíkínte̱e la ko tí tíkínte̱e tso̱nínkakonhen tí ichꞌe̱e tjan. ");
INSERT INTO poeNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Chꞌín Jesús kja̱xin ntáche chꞌán tí chojni siín kíxin: ―A̱ ntá tsꞌikonrá tsꞌàya tjui̱ tí tjia̱tóxin ya̱on, a̱ ntá ntáchrorá kíxin tsꞌaniá chrin, a̱ ntá xi̱kaha chaxín tso̱nhen tsꞌaniá chrin. ");
INSERT INTO poeNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","A̱ ntá tí chjéhe xri̱nto̱ nó sur ntá ntáchrorá kíxin tso̱sóa, a̱ ntá xi̱kaha chaxín tso̱sóa. ");
INSERT INTO poeNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Jahará ntoáhya tjenka̱yáxinrá. Ó nohará tjenka̱yáxinrá nkexrí tso̱nhen nka̱jní la ko chjasintajni. ¿Ntá nkexrí na̱xa̱ tiénxinhyará nkehe sítónhen tí tjejorá jie? ");
INSERT INTO poeNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’¿Nkekuènte tjéyáhyará jahará nkehe tí jína? ");
INSERT INTO poeNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Tí jnkojín nkexro tsjanchia jie̱ sátjikoará chꞌán nkayakon tí sín tꞌe̱to̱an na tí nti̱a ó chrónkakjórá chꞌán kíxin tso̱yóxin tsꞌixinhya kjuanínkaon kíxin sátsjikoahyará nkayakon tí chꞌín juez, kíxin tí chꞌín juez chrókꞌue̱to̱an chꞌán kíxin sátsjikoará tí sín comandante. A̱ ntá tí chꞌín comandante chróchrꞌáxanhanrá chꞌán nto̱echiso. ");
INSERT INTO poeNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ntáxrja̱n kjá ni chrókꞌuaxrjéxinhyará ntiha tsjenka̱jiará kaín xín chichaon chonta.﻿ ");
INSERT INTO poeNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","A̱ ntá tí ya̱on kꞌuejó iso sín chénka sín tí chꞌín Jesús kíxin nkexrí kjuíchꞌe chꞌín Pilato kꞌue̱to̱an itsꞌen iso chojni tsíkji̱xi̱n estado Galilea kꞌuítji ijni̱é sín kójnkojiéko tí ijni̱é tí ko kꞌóyán sín kjuanchexín sín kjuasáyé Dios. ");
INSERT INTO poeNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","A̱ ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―¿Á tjenka̱yáxinrá kíxin xíkaha kónhen tí sín tsíkji̱xi̱n estado Galilea kíxin a̱ntsí jié jie̱ chónta sín, a̱ ntá tí í so sín chjasén sín la á náhí ní? ");
INSERT INTO poeNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ntáxrja̱n tíhi kjá náhí. A̱ ntá jahará tí tjínkíhyará tí tjenka̱yáxinrá la kaín rá xi̱kaha itsꞌenrá kja̱xin. ");
INSERT INTO poeNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿Á tjenka̱yáxinrá kíxin a̱ntsí má kꞌuéchónta jie̱ tí dieciocho chojni ikꞌuén xrátja sín tí torre Siloé, a̱ ntá tí í so sín chjasin Jerusalén la á náhí ní? ");
INSERT INTO poeNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ntáxrja̱n tíhi kjá náhí. A̱ ntá jahará tí tjínkíhyará tí tjenka̱yáxinrá la kaín rá xi̱kaha tsꞌitjáyanrá kja̱xin. ");
INSERT INTO poeNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","A̱ ntá chꞌín Jesús kjuíncheyóe̱xin chꞌán ntáchro chꞌán kíxin: ―Ijnko chojni chónta ijnko nta to higo nónte̱e chꞌán. Ntá sákjuítsjehe chꞌán á kꞌóna to. A̱ ntá náhí kꞌuitjahya chꞌán ninkehó to. ");
INSERT INTO poeNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ntá ntáche chꞌán tí nkexro tꞌayakonhen tí nonte a kíxin: “Ó ní nánó tꞌinkatsjaha̱ tí nta la kꞌuitjáhya ninkehó to higo. Tꞌochrínjian tí nta kíxin tsoxéhe tí nonte a.” ");
INSERT INTO poeNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","A̱ ntá tí chꞌín tꞌayakonhen nonte kjuáte̱he chꞌán ntáchro chꞌán kíxin: “Áxri, ti̱to̱hé ijie nánó kíxin si̱ntantá nche la ko tsjiko ncheka̱tjehe. ");
INSERT INTO poeNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","A̱ ntá tí xi̱kaha áchꞌe tsꞌóna to. A̱ ntá tí náhí na ntá tsꞌochrínjian chrꞌéxi̱n.” ");
INSERT INTO poeNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Chꞌín Jesús kjuákꞌe chꞌán ijnko ni̱nko kjua̱ko̱xi̱n chꞌán ijnko ya̱on tꞌo̱kꞌéhe chojni. ");
INSERT INTO poeNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ntiha tjen ijnko chojni chjin chónta dieciocho nánó chonta tjan ijnko ncha̱kuen tí jínahya kjuíncheníhi tjan tjesékoá tjan xitjahya xrentoá tjan. ");
INSERT INTO poeNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","A̱ ntá chꞌín Jesús kꞌuíkon chꞌán kíxin xi̱kaha tjen tjan ntá kꞌuíye̱he̱ chꞌán tjan ntáchro chꞌán kíxin: ―Naná, ó kjuìinhan tí chin chonta ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","A̱ ntá jehe chꞌán kjuakꞌetja tja chꞌan chrítaón tí jehe tjan a̱ ntá tuénxín xrentoá tjan ntá chjéhe tjan kjuasáyé Dios. ");
INSERT INTO poeNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","A̱ ntá tí chꞌín tꞌe̱to̱an kuènte ni̱nko kónínkaon chꞌán kíxin chꞌín Jesús kjuínchekito̱he jína ijnko chojni ijnko ya̱on tꞌo̱kꞌéhe sín, ntá ntáche chꞌán tí chojni a kíxin: ―Siín injon ya̱on mé chrókónhen xra̱ chrókꞌuinkará chrókuito̱hará jína na jehya tí ya̱on tꞌo̱kꞌéheni chrókónhen tíha ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","A̱ ntá Ìnchéni kjuáte̱he chꞌán ntáchro chꞌán kíxin: ―Ntoáhya tjenka̱yáxinrá jahará. ¿Á chrókjuasinta̱nke̱ehyará tí koxi̱nta̱ará la o̱ tí kolócho̱ará chrókjuíkoará va nta̱ tí ya̱on tꞌo̱kꞌéheni ní? ");
INSERT INTO poeNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","A̱ ntá tí tjan mé tsíkꞌaxrjeníxin tí chꞌín Abraham na mé ó chónta dieciocho nánó tsíkjinchenteto chꞌín Tsochren tí jehe tjan, ¿á jehya jína kja̱xin chrókjuasinta̱nka̱ tí nkehe tsíkóntetoxín tjan tí ya̱on tꞌo̱kꞌéheni? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ntá xi̱kaha ichro chꞌín Jesús la ntá kaín tí sín kónínkakonhen chꞌán la kósuèhe̱ sín. A̱ ntá kaín tí chojni siín ntaha chéhe̱ sín kꞌuíkon sín kaín tí kjuaxroan jié kjua̱ko̱xi̱n tí jehe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ntá ntáchro chꞌín Jesús kíxin: ―¿Nkehe tóyóe̱xin tí tꞌe̱to̱an Dios tí kjuachaxin kuènte chꞌán la ko nkehe jína chrókjui̱ntayóa̱xian? ");
INSERT INTO poeNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Éxí yóhe ijnko tje kuènte nta mostaza kꞌue̱nka̱ ijnko chojni no̱nte̱e chꞌán. A̱ ntá tió kꞌuánkí kóyóhe̱ éxí ijnko nta jié. A̱ ntá tí koxroxe xritjaká mé kui va kjuíchꞌéna va ka̱ké va chríkꞌá tí chaon tí nta. ");
INSERT INTO poeNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ntá ntáchro chꞌín Jesús ínaá kíxin: ―¿Nkehe chrokjui̱ntayóa̱xian tí tꞌe̱to̱an Dios tí kjuachaxin kuènte chꞌán? ");
INSERT INTO poeNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Éxí yóhe̱ tí xro̱a̱n nchekꞌánkí nio̱tja̱ kjuinkíkja̱nxi̱n ijnko chojni chjin iní medida harina. A̱ ntá tí chꞌo la kꞌuánkí. ");
INSERT INTO poeNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Kꞌuátsínka chꞌín Jesús kaín chjasin hyé la ko kaín chjasin ntsíntsí nkákjako chꞌán tí tan jína kíxin jehe chꞌán ó sátsji̱ chꞌán chjasin Jerusalén. ");
INSERT INTO poeNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","A̱ ntá ijnko nkexro kjuanchankí chꞌán kíxin: ―Ìnchéni, ¿á tsjéhya tí sín tsaá? ―ichro chꞌán. A̱ ntá jehe chꞌán kjuáte̱he chꞌán ntáchro chꞌán kíxin: ");
INSERT INTO poeNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Tóxakonhanrá tꞌixe̱enxínrá tí puerta tekahya kíxin nchónhya sín tjinkaon sín chrókꞌuixenhen sín, kjánchó tjachahya sín. ");
INSERT INTO poeNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","A̱ ntá tí ìnché nchia tsꞌikjéhe chꞌán tí puerta. A̱ ntá chrꞌéxi̱n jahará tsꞌejorá ntója tsꞌèyará tsꞌinkará tí puerta tsontáchrorá kíxin: “Tadá, takítje̱hé nchia”, tsixrorá. Kjánchó jehe chꞌán tsjate̱he chꞌán tsontáchro chꞌán kíxin: “Nonahya nketí kꞌuinkaxínrá jahará”, tsixro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","A̱ ntá tsjankíxinrá tsontáchrorá kíxin: “Kjóneni la ko kꞌuíni jnkoko̱á la ko jaha kjuáko̱xian tí nta̱si̱inni”, tsixrorá. ");
INSERT INTO poeNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","A̱ ntá jehe chꞌán tsjate̱he chꞌán tsontáchro chꞌán kíxin: “Ó ntáxrja̱n janhan kíxin chonhya tí jahará. Ti̱to̱hérá tí janhan sátjirá ókjé kaín tí jahará jínahya kjui̱chꞌerá.” ");
INSERT INTO poeNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ntaha tsotsja̱nkará la ko sintetaónrá nénorá tió tsꞌikonrá kíxin chꞌín Abraham la ko chꞌín Isaac la ko chꞌín Jacob la ko kaín tí sín kꞌuéchronkaxín itén Dios mé tjejó sín tí tjen Dios tꞌe̱to̱an chꞌán, a̱ ntá jahará la tsꞌaxrjéxinrá ntója ntiha. ");
INSERT INTO poeNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Tsji̱xi̱n chojni nó tji̱to̱xi̱n ya̱on la ko nó tjiátóxin ya̱on la ko nó norte la ko nó sur ntá tsꞌejótja̱xi̱n sín tí tjen Dios tꞌe̱to̱an chꞌán la sine sín. ");
INSERT INTO poeNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","A̱ ntá iso tí sín kꞌuítuenhen senó la mé tsꞌe̱to̱an sín, la ko iso tí sín kꞌuékꞌe̱to̱an senó la mé tsꞌítuenhen sín. ");
INSERT INTO poeNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","A̱ ntá tí ya̱on a ikui iso sín fariseo ntáche sín tí chꞌín Jesús kíxin: ―Sátjíxian ntihi kíxin chꞌín Herodes tjinkaon chrókꞌóyán chꞌán tí jaha ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","A̱ ntá jehe chꞌán kjuáte̱he chꞌán ntáchro chꞌán kíxin: ―Sátjirá chenkará tí chꞌín jínahya chꞌia kíxin: “Ijie la ko ntóye tsakítsje ncha̱kuen tí jínahya la ko si̱ntaki̱to̱ha̱ chojni níhi jína la ntá tí níxin ya̱on a ntá tsjixìnna tí xra̱ kuènta̱na,” tsixrorá. ");
INSERT INTO poeNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Kjánchó tꞌichjánxi̱n kíxin na̱xa̱ sátji̱ya tí jie ya̱on la ko ntóye la ko tí ya̱on chrꞌéxi̱n kíxin tꞌichjánxi̱n kíxin ijnko nkexro chrónka itén Dios chrókꞌuenxín chꞌán chjasin Jerusalén. ");
INSERT INTO poeNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’Jerusalén, Jerusalén. Jahará tꞌoyánrá tí sín tjako itén Dios la chje̱hérá xro̱ tí sín ichrꞌán chꞌán ikui chrókjuínki̱tsará. Imá itsjé veces tjínka̱van chrókójnkotsérá la chrókꞌuáyakonhanrá éxí ijnko cochíká mé tꞌayakonhen xje̱en va chrínkí ka̱ne̱ne̱e va mé xi̱kaha tjínka̱van chrókꞌuàyakonhanrá tí jahará. Kjánchó jahará la tjinkákonhyará xi̱kaha. ");
INSERT INTO poeNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Chrókónohará kíxin Dios la tsíto̱he chꞌán tí jahará la tsꞌikonhyará tí janhan tsjixrakájia tí ya̱on tsontáchrorá kíxin: “Jína tí nkexro kjui̱xi̱n kjuachaxin ihni̱é Ìnchéni Dios.” ");
INSERT INTO poeNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","A̱ ntá tí ya̱on tꞌo̱kꞌéhe sín sákjuí chꞌín Jesús nto̱e ijnko chꞌín fariseo tꞌe̱to̱an kíxin ntaha sineko sín chꞌán. A̱ ntá tí í so sín fariseo tinkáchréhe̱ sín tsotsjehe sín nkehe sichꞌe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","A̱ ntá ntiha ntoí chókꞌèxin tí tjen chꞌán itjen ijnko chojni tsíkꞌatjoyé kuenté. ");
INSERT INTO poeNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","A̱ ntá chꞌín Jesús kjuanchankíhi chꞌán tí sín maestro tjako tí ley la ko tí sín fariseo kíxin: ―¿A̱ siín kjuachaxin sinchekito̱heni jína ijnko chojni níhi tí ya̱on tꞌo̱kꞌéheni o̱ náhí? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","A̱ ntá jehe sín la tání sín. A̱ ntá chꞌín Jesús sákjuíko chꞌán tí chꞌín níhi la kjuínchekito̱he chꞌán jína la kꞌue̱tue̱nhen chꞌán kíxin sátsji chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","A̱ ntá ntáche chꞌán tí sín fariseo kíxin: ―Jnkojín tí jahará chontará kolócho̱ará o̱ koxi̱nta̱ará chrókjuítsínkáya va tòye̱ ¿á senóhya chrókuakítsjetaónrá va tòye̱ kjónté ya̱on tꞌo̱kꞌéheni ní? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","A̱ ntá jehe sín ninkehó kjuáte̱ehya sín kíxin xi̱kaha ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ntá kꞌuíkon chꞌín Jesús kíxin tí sín tsíkóchjina tí kia a kjueyá sín silla náxrjón tsꞌejóya sín tí tjen mesa ntá kjuíncheyóe̱xin chꞌán ntáchro chꞌán kíxin: ");
INSERT INTO poeNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Tió jnkojín nkexro tsꞌiya̱ha sín kíxin tsjasán ijnko kia tso̱te̱he chojni la tjéyáhya tí nta silla kuènte tí sín tꞌe̱to̱an kíxin áchꞌe tsi jnkojín nkexro a̱ntsí tꞌe̱to̱an ");
INSERT INTO poeNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","a̱ ntá tí nkexro kꞌuíya̱hará yóírá itsi chꞌán tsjanchahará chꞌán kíxin tꞌinkátje̱nxian tí tjen jaha méhe̱ kíxin ntaha tsjakꞌe í jnko nkexro, tsixro chꞌán. Ntá tso̱suàha sátsjia tsjakꞌetja̱xian tí silla kjuixixín. ");
INSERT INTO poeNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Íchá jína tió tꞌiya̱ha sín chrókjuakꞌetja̱xian tí silla tjetuanhya, kíxin ntá chrókui tí chꞌín tsíkꞌiya̱ha tsontáchro chꞌán kíxin: “Jína tjoni la tꞌatsínka tjakꞌetja̱xian tí silla a̱ntsí náxrjón”, kíxin ntaha tsjikosáyaha sín nkayakon kaín tí sín tsꞌejótja̱xi̱nkoa sín ntiha. ");
INSERT INTO poeNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kíxin tí nkexro sinchehnkehe a̱sén kíxin imá chrókꞌue̱to̱an chꞌán la mé chrꞌéxi̱n Dios tsjanjonhya kjuachaxin kíxin tsꞌe̱to̱an chꞌán. A̱ ntá tí nkexro kꞌuékꞌe̱to̱anhya la mé chrꞌéxi̱n Dios tsjanjon kjuachaxin kíxin a̱ntsí tsꞌe̱to̱an chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Kja̱xin ntáche chꞌán tí nkexro tsíkꞌiye̱he̱ chꞌán kíxin: ―Tió tsjásian kia itꞌo̱ ya̱on la o̱ tso̱njin la tꞌi̱ye̱éhya tí sín choxian la ko tí sín kíchuá la ko tí sín na̱xa̱ kjéhya la ko tí sín rico chjino nto̱a, kíxin jehe sín la chrꞌéxi̱n tsꞌiya̱ha sín ínaá la xi̱kahó la ó kjuixin kjan tí kꞌui̱ye̱hé sín. ");
INSERT INTO poeNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Íchá jína chrókꞌui̱ye̱hé tí sín nòa la ko tí sín tsíxénká to̱té sín la ko tí sín xitjahya tji la ko tí sín tꞌikonhya. ");
INSERT INTO poeNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ntá chrókócháha jaha kíxin jehe sín xitjahya tsꞌiya̱ha sín tsjasin sín kia. A̱ ntá tió tsoxechónjian tí sín jína la mé Dios mé tsjenka̱ha kíxin kjuínki̱tsa tí jehe sín. ");
INSERT INTO poeNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","A̱ ntá kuínhin ijnko tí sín tjejótja̱xi̱n sín chjino tí mesa, a̱ ntá ntáche chꞌán tí chꞌín Jesús kíxin: ―Náxrjón tí sín sine nio̱tja̱ tí tjen Dios tꞌe̱to̱an chꞌán ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ntá ntáchro chꞌín Jesús kíxin: ―Ijnko chojni kjuasin ijnko kia jié ijnko kónjín la kꞌuíye̱he̱ chꞌán nchónhya chojni tsi sín tí kia a. ");
INSERT INTO poeNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","A̱ ntá ó kuichjina tí hora sine sín ntá kꞌue̱tue̱nhen chꞌán ijnko chojni chꞌehe chꞌán xra̱ tsjichenka chꞌán kaín tí sín ó tsíkꞌiye̱he̱ chꞌán kíxin chrókóchjina sín kíxin ó tjejóchónhen kaín nkehe sine sín. ");
INSERT INTO poeNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ntá kaín sín kjuankíxin sín chrónòa sín kíxin xitjahya tsjiji sín sine sín. A̱ ntá tí chꞌín sa̱oxín kjuítsjehe chꞌán ntáchro chꞌán kíxin: “Na ntá kꞌue̱nani ijnko no̱nte̱eni la tꞌichjánxi̱n tsjitsjeheni la xitjahya tsjijini tí tꞌiye̱he̱ni chꞌán, ntá chénka chꞌán kíxin chrókónínkakuenhyani chꞌán”, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","A̱ ntá í jnko chꞌín ntáchro chꞌán kíxin: “Na ntá kꞌue̱nani inꞌó yunta koxinta, a̱ ntá tꞌichjánxi̱n tsotsjeheni á jína chꞌe va xra̱, ntá chénka chꞌán kíxin chrókónínkakuenhyani chꞌán”, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","A̱ ntá í jnko chꞌín ntáchro kíxin: “Na ntá kóte̱heni, méxra̱ xitjahya tsjijini”, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ntá ó kjan tí chꞌín chꞌe xra̱ chénka chꞌán tí chꞌín lámo kaín tí nkehe tsíntáchro sín. A̱ ntá tí chꞌín lámo kuínhin chꞌán xi̱kaha la ntá kónínkaon chꞌán ntá ntáche chꞌán tí chꞌín chꞌehe chꞌán xra̱ kíxin: “Tjoka sátjia kaín nti̱a chjasin i la tsjikoa ntihi tí sín nòa la ko tí sín tsíxénká to̱té sín la ko tí sín xitjahya tji la ko tí sín tꞌikonhya”, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","A̱ ntá chrꞌéxi̱n ntá kjan tí chꞌín chꞌe xra̱ chénka chꞌán tí lámo kíxin: “Ó kjuínchexiteyáni xi̱kaha kuétue̱nhénni la kjónté na̱xa̱ xranka chrókui chojni”, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","A̱ ntá tí chꞌín lámo ntáche chꞌán tí chꞌín chꞌehe chꞌán xra̱ kíxin: “Sátjia kaín nti̱a jié la ko kaín nti̱a ntsí la tétue̱nhén chojni siín chrókui sín chrókꞌuixixenhen nchia nto̱na na̱xa̱ xranka. ");
INSERT INTO poeNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Kíxin ntáxrja̱n kíxin nijnko tí sín kꞌuíya̱ha̱ senó chrókui sín chrókjone sín tí nkehe chrótja̱ha̱ sín”, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nchónhya chojni nkáchréhe̱ sín tí chꞌín Jesús, ntá jehe chꞌán kuinkátjíá chꞌán kotónhen chꞌán ton chꞌán ntáchro chꞌán kíxin: ");
INSERT INTO poeNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―A̱ ntá jnkojín chojni tsotjinkaon tsochréhe̱ tí janhan la a̱ntsí má tjetoan chrótjua̱na sín la kjónté kénhyó chrótjuèhe itꞌé sín la ko ìné sín la ko ichjién sín la ko xje̱en sín la ko kíchó sín ntoa la ko kíchó sín chjin la ko kjónté kénhyó chrótjuèhe a̱sén sín. A̱ ntá náhí la xitjahya tsꞌóna discípulo kuènta̱na jehe sín. ");
INSERT INTO poeNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Tí nkexro tsamáhya tí ntacruz kuènte sín tsochrèhya sín tí janhan la xitjahya tsꞌóna discípulo kuènta̱na. ");
INSERT INTO poeNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","A̱ ntá jnkojín tí jahará chrókjui̱chꞌénará ijnko tja̱tꞌo̱ nte̱to, ¿á senóhya chrókjuenka̱yáxinrá kíxin nkekja̱ín chichaon tsꞌichjánxi̱n tsꞌixenhen chrótsjehérá á ncho̱xon chrókjuixixín chrókꞌónaxín tí tja̱tꞌo̱ a? ");
INSERT INTO poeNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","A̱ ntá tió tsjankíxinrá si̱chꞌénará tí tja̱tꞌo̱ ntá chrꞌéxi̱n xitjahya tsjixin si̱chꞌénará, ntá kaín chojni tsꞌikon sín tsjanoárá sín ");
INSERT INTO poeNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","tsontáchro sín kíxin jaha kjuankíxian kjui̱chꞌéna, a̱ ntá jie xitjahya si̱nchekjixian tsꞌóna, tsixro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","A̱ ntá jnkojín tí chꞌín rey tꞌe̱to̱an tsjanjo̱nko í jnko rey tꞌe̱to̱an kja̱xin násenó chrókjuenka̱yáxin chꞌán kíxin ite mil soldado chónta chꞌán, á chrókjuacha chꞌán chrókjua̱cha̱xi̱n chꞌán tí kán mil soldado chónta tí í jnko chꞌín tꞌe̱to̱an. ");
INSERT INTO poeNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","A̱ ntá ti chrókjuachahya chꞌán chrókjuanjo̱nko chꞌán tí í jnko chꞌín rey, ntá na̱xa̱ ikjín tjen chꞌán la íchá jína chróchrꞌán chꞌán ijnko nkexro tsochronóe̱he̱ chꞌán kíxin chrókꞌuixinhya kjuanínkaon. ");
INSERT INTO poeNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Mé xi̱kaha jnkojín tí jahará tí tsi̱to̱éhyará kaín nkehe ntoáhya tjenka̱yáxinrá xitjahya tsꞌóna discípulo kuènta̱na. ");
INSERT INTO poeNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’A̱ ntá jína tí xíjnta, kjánchó tí chrókꞌuánkéhé tí jní la ntá xitjahya chrókójní ínaá. ");
INSERT INTO poeNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ntá tí xi̱kaha la ni tí nche xitjahya tsjiko la chrókꞌónahya nkehe la chrokꞌuitjini ntója. Tí nkexro tjinkaon chrókuinhin la chrókuinhin kaín tíhi ―ichro chꞌin Jesús.﻿ ");
INSERT INTO poeNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Kaín tí sín nchekjènki̱ la ko tí sín chónta nchónhya jie̱ kóchjinehe sín tí chꞌín Jesús kíxin tjinkaon sín chrókuinhin sín tí nkehe tjechronka chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","A̱ ntá tí sín fariseo la ko tí sín maestro tjako tí ley kjuankíxin sín tjonta sín chꞌán ntáchro sín kíxin: ―Tí chꞌín i la kjónté tí sín chónta nchónhya jie̱ la tꞌito chꞌán la ko neko chꞌán ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ntá chꞌín Jesús kjuíncheyóe̱xin chꞌán ntáchro chꞌán kíxin: ");
INSERT INTO poeNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―A̱ ntá jnkojín tí jahará, tí chontará ijnko ciento kolélo ntá chrókꞌuitjáyan ijnko va, ¿á chrókui̱to̱éhyará tí noventa y nueve va tí nte̱je̱ ó, a̱ ntá á chrókjuíkjéyáhyará tí ko tsíkꞌitjáyan hasta chrókꞌuitjájiará va ní? ");
INSERT INTO poeNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","A̱ ntá tí tsꞌitjárá va ntá tsamárá va tso̱cháha̱rá. ");
INSERT INTO poeNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ntá tió tsokjanrá nto̱ará ntá tsꞌi̱ye̱hérá kaín tí sín choxinrá tjórá jína la ko tí sín chjinaxón nto̱ará ntá tsontácherá sín kíxin: “Tso̱chéhe̱ni tsꞌejóni jie kíxin ó kꞌuítjá tí kolélo tsíkꞌitjáyan.” ");
INSERT INTO poeNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Na mé kja̱xin xi̱kaha tso̱tjo̱nka̱rá kíxin a̱ntsí tso̱chéhe̱ kaín tí sín siín nkaya nka̱jní tió ijnko chojni tsíto̱he kaín tí jie̱ tsíkjenka̱yáxin chꞌán. Ntá kánhyó tso̱chèxin tí sín nkaya nka̱jní kíxin tí noventa y nueve chojni jína tꞌichjánxi̱enhya chrókjuinkí sín tí nkehe tjenka̱yáxin sín. ");
INSERT INTO poeNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’A̱ ntá ijnko chojni chjin chónta ite chichaon, a̱ ntá tí chrókjuinchekꞌitjáyan tjan ijnko tí chichaon a la, ¿á chrókjuinchekꞌákjenhya tjan xrohi kíxin chrókjueyáxin tjan la ko chrokꞌuánjón tjan tí nchia kíxin chrótsjehe tjan jína hasta chrókꞌuitjajia tjan? ");
INSERT INTO poeNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","A̱ ntá tió chrókꞌuitja tjan la tsꞌiye̱he̱ tjan kaín tí chojni chjin jína tjo tjan la ko tí sín chjinaxón nto̱e tjan la ntá tso̱ntáche tjan sín kíxin: “Tso̱chéhe̱ni tsꞌejóni kíxin ó kꞌuitjani tí chichaon kjuínchekꞌitjáyanni.” ");
INSERT INTO poeNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ntá kja̱xin xi̱kaha tso̱tjo̱nka̱rá kíxin imá tso̱chéhe̱ kaín tí sín ángel kuènte Dios tió ijnko chojni tsíto̱he kaín tí jie̱ tsíkjenka̱yáxin chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Kja̱xin ntáchro chꞌín Jesús kíxin: ―Ijnko nkexro chónta yaá xje̱en chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","A̱ ntá tí chꞌín tsoyo ntáche chꞌán tí itꞌé chꞌán kíxin: “Itꞌéni, chje̱héni kaín nkehe chróchje̱héni.” A̱ ntá tí itꞌé sín kꞌóchrítꞌo̱he chꞌán tí nkehe chónta chꞌán. A̱ ntá tí chꞌín tsoyo kꞌuáyéhe̱ tí nkehe kuènte chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","A̱ ntá kánhyó tsjé ya̱on chrꞌéxi̱n tí xje̱en chꞌán tsoyo kjuínchekji chꞌán kaín nkehe tsíkꞌáyéhe̱ chꞌán, ntá sákjuíko chꞌán tí chichaon sákjuí chꞌán ókjé chjasin kjín. A̱ ntá ntiha kjuínchexénhen chꞌán kaín chichaon chónta chꞌán kíxin jehya tí jína kjuíchꞌe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","A̱ ntá tió kjuixin kjuèhe chꞌán tí chichaon kuicháxi̱nhin chꞌán ntá xrína̱hya kókjinta tí chjasin ntiha ntá kohya nkehe sine kaín sín. A̱ ntá jehe chꞌán kjuankíxin chꞌán tꞌenxín chꞌán kjinta. ");
INSERT INTO poeNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ntá jehe chꞌán sákjuíkjeyá chꞌán xra̱ sichꞌe chꞌán. Ntá chjasin ntaha tjen ijnko chꞌín kjuanchehe chꞌán xra̱. Ntá tí chꞌín a kjuanjon chꞌán xra̱ ntá kꞌue̱to̱an chꞌán kíxin sátsji chꞌán no̱nte̱e chꞌán kíxin ntiha tsꞌayakonhen chꞌán cochíno. ");
INSERT INTO poeNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","A̱ ntá jehe chꞌán tꞌenxín chꞌán kjinta ntá tjinkaon chꞌán chrókjóne chꞌán tí nkehe ine tí cochíno kíxin ninkexró tí ntiha chrohya tsjanjon nkehe sine chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ntá jehe chꞌán kjuákꞌe chꞌán kjuenka̱yáxin chꞌán kíxin: “Nchónhya chojni siín nto̱e tꞌaná chꞌe sín xra̱ la chónta sín nkehe sine sín. Ntá janhan tjétꞌénxi̱a̱n kjinta ntihi. ");
INSERT INTO poeNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ntá jie tsokjan tí tjen tꞌaná la ntá tsontáxrja̱n kíxin: Itꞌéni, kjuasinni jie̱ kuítekakuenhya Itꞌéni nkaya nka̱jní la ko kjuasinhanni jie̱ kuítekakuanhyani tí jaha. ");
INSERT INTO poeNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Tósuèheni tsontáchrua kíxin xja̱an tí jeheni. Chꞌénani éxí ijnko chojni tꞌaha xra̱”, mé xi̱kaha kjuenka̱yáxin chꞌán tsontáchro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ntá kuákja chꞌán nti̱a xrakoa chꞌán tí nto̱e itꞌé chꞌán. ’A̱ ntá kjónté na̱xa̱ kjín kui chꞌán a̱ ntá tí itꞌé chꞌán la ó tsíkꞌikon ntá kui̱konóe̱he̱ chꞌán tí xje̱en chꞌán. Ntá kuinká chꞌán la kjuíxinhin chꞌán nti̱a la kjóa chꞌán la ko kjóneko chꞌán kochíto. ");
INSERT INTO poeNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Na ntá ntáchro tí xje̱en kíxin: “Itꞌéni kjuasinni jie̱ kuítekakuenhyani Dios la ko kjuasinhanni jie̱ kuítekakuanhyani tí jaha. Tósuèheni tsontáchrua kíxin xja̱an tí jeheni”, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","A̱ ntá tí itꞌé chꞌán kꞌuíye̱he̱ chꞌán tí sín chꞌehe chꞌán xra̱ ntáchro chꞌán kíxin: “Xrákoará tí ka a̱ntsí jína nchekꞌinkáyará chꞌán la ko chrꞌaxenhenrá dedo tja chꞌán ijnko kochꞌa̱ninko la ko nchekjankará chꞌán to̱tjo̱a̱. ");
INSERT INTO poeNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","La ko tjicakjínrá koxintáxjan tsa̱nka̱ la tꞌoyánrá va kíxin sinekoni chꞌán tsjasinhinni chꞌán kia. ");
INSERT INTO poeNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kíxin tí xja̱nna i la éxí ó tsíkꞌen chꞌán xi̱kaha ntá jie la éxí ó xechón chꞌán la tsíkꞌitjáyan chꞌán la ntá jie la ó kónoxín chꞌán ínaá”, ichro chꞌán. Ntá kjuankíxin sín kjuasin sín kia. ");
INSERT INTO poeNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’A̱ ntá tí xje̱en chꞌán sa̱o la nonte tjechꞌe chꞌán xra̱. A̱ ntá tió kjan chꞌán kui chꞌán chjinaxón nchia ntá kuínhin chꞌán siín són la ko ité sín. ");
INSERT INTO poeNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ntá kꞌuíye̱he̱ chꞌán ijnko chꞌín chꞌe xra̱ ntá kjuanchankíhi chꞌán kíxin nkekuènte xi̱kaha sítónhen. ");
INSERT INTO poeNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","A̱ ntá tí chꞌín a ntáchro chꞌán kíxin: “Kíchuá la ó tsíkjan. A̱ ntá itꞌá la kꞌue̱to̱an kꞌuén koxintáxjan tsa̱nka̱ kíxin jína xíkjan chꞌán”, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","A̱ ntá tí chꞌín sa̱o la kónínkaon chꞌán chrohya chꞌán tsꞌixenhen chꞌán nchia. A̱ ntá tí itꞌé chꞌán kꞌuaxrjexín nchia chronóe̱he̱ chꞌán kíxin chrókꞌuixenhen nchia. ");
INSERT INTO poeNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Kjánchó jehe chꞌán kjuáte̱he chꞌán ntáche chꞌán itꞌé chꞌán kíxin: “Nchónhya nánó tꞌahani xra̱, la xráxín kuítekakonhanni kaín nkehe kuéto̱an la kjuánjonhya nijnko kotèntso̱ chrókjónekoni tí sín chóxinni. ");
INSERT INTO poeNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","A̱ ntá jie ikui tí xja̱an i kjuínchekꞌitjáyan chꞌán kaín nkehe chje̱hé chꞌán kjuínchekꞌitjáyanxín chꞌán chojni chjin. A̱ ntá jie ikjan chꞌán la na̱xa̱ tꞌoyán koxintáxjan tsa̱nka̱”, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","A̱ ntá ntáchro tí itꞌé chꞌán kíxin: “Xje̱enni jaha, xráxín tjejóko kíchó ni ntihi. Kaínxín nkehe kuènta̱na la kuènta jaha kja̱xin. ¿Nkekuènte ninkávan? ");
INSERT INTO poeNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","A̱ ntá jie la tꞌichjánxin tsjasinhinni kíchuá kia tso̱chéhe̱ni kíxin éxí tsíkꞌen chꞌán la ntá jie la ó tsíxechón, la tsíkꞌitjáyan chꞌán xi̱kaha la ntá jie la kónoxín chꞌán ínaá.”﻿ ");
INSERT INTO poeNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Kja̱xin ntáche chꞌín Jesús tí sín kꞌuájiko chꞌán kíxin: ―Kjuákꞌe ijnko chꞌín lamó ricó chónta chꞌán ijnko nkexro chjéhe chꞌán kjuachaxin kíxin tsꞌe̱to̱an tso̱nhen xra̱. Ntá kui ijnko nkexro chénka tí lamó kíxin: “Tí nkexro tꞌe̱to̱an nchexénhen chꞌán tí nkehe chonta”, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","A̱ ntá tí chꞌín lamó kꞌuíye̱he̱ chꞌán tí chꞌín chꞌehe chꞌán xra̱ ntáche chꞌán kíxin: “¿Á chaxín xi̱kaha chꞌe kíxin xi̱kaha ichro sín? A̱ ntá jie tsjánjuan jaha kuentá tí xra̱ kjui̱chꞌe kíxin ijie í si̱chꞌehya xra̱ tséto̱an ntihi”, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","A̱ ntá tí chꞌín tꞌe̱to̱an tónhen xra̱ kjuenka̱yáxin chꞌán kíxin: “¿Nkehe chrókjui̱tꞌa jie kíxin tí lamó la í tsjanjonhya chꞌán xra̱ si̱tꞌa? La ko janhan la chontahya fuérza̱ si̱tꞌa xra̱ no̱nte̱e chojni la ko tósuàna kíxin chrókꞌuájia chrókjuánchákꞌá nkehe. ");
INSERT INTO poeNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ó nòna nkehe si̱tꞌa kíxin ntá tsochonta nkexro tsjanjon kjuachaxin tsjakꞌé nto̱e sín tí í tsochontahya xra̱ si̱tꞌa”, ichro tí chꞌín tꞌe̱to̱an. ");
INSERT INTO poeNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ntá kꞌuíye̱he̱ chꞌán jnkojnko jnkojnko tí sín síkéhe tí lámo̱e chꞌán. A̱ ntá tí chꞌín sa̱o kui ntá tí chꞌín tꞌe̱to̱an mé kjuanchankíhi chꞌán kíxin: “¿Nkekja̱ín tjasikéhé lámo̱éni?” ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","A̱ ntá jehe chꞌán kjuáte̱he chꞌán ntáchro chꞌán kíxin: “Síkáni ijnko ciento ntabarril aceite”, ichro chꞌán. A̱ ntá tí chꞌín tꞌe̱to̱an ntáchro chꞌán kíxin: “Ntihi tjen xroon tsjénka̱xian a. Tjakꞌe nonte tjoka la chꞌéna í jnko xroon la í cincuenta ó ténixián”, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ntá chrꞌéxi̱n la kjuanchankíhi chꞌán í jnko nkexro kíxin: “A̱ ntá jaha, ¿nkekja̱ín tjásiká?” ichro chꞌán. Ntá ntáchro chꞌán kíxin: “Ijnko ciento medida noatrigo síkáni”, ichro chꞌán. A̱ ntá ntáchro tí chꞌín tꞌe̱to̱an kíxin: “Tí xi̱kaha la ntihi tjen tí xroon tsjénka̱xian. A̱ ntá jie la chꞌéna ochenta ó”, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","A̱ ntá tí chꞌín lamó kjuátso̱an chꞌán kíxin kjónté jehya xra̱ jína kjuíchꞌe tí chꞌín tꞌe̱to̱an kjuíchꞌehe chꞌán xra̱ la kjánchó tí kjuíchꞌia chꞌán la a̱ntsí nohe chꞌán kjuíchꞌia chꞌán. Méxra̱ tí sín chjasintajni a̱ntsí nohe sín chꞌiyehe kíchó sín, a̱ ntá tí sin ixri tí tꞌinkaséyan la xi̱kahya chrókjuenka̱yáxin sín chrókjuichꞌia sín, chrókjuenka̱yáxin sín tí jína. ");
INSERT INTO poeNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Janhan la tétua̱nhanrá kíxin chrókuicháxi̱nhanrá tí chichaon siín chjasintajni kjónté tjuáhya kíxin tsjínki̱tsará chojni kíxin ntá itsjórá sín jína. A̱ ntá tió tsjeje̱ kaín chichaon ntá jehe sín tsꞌejóchónhen sín nkaya nka̱jní tsꞌáyáhará sín jnkochríxín. ");
INSERT INTO poeNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Tí nkexro kꞌuáyakonhen tí nkehe chónta kjónté tsjéhya la kja̱xin chrókjuacha chrókꞌuáyakonhen itsjé nkehe chróchónta. A̱ ntá tí nkexro kjuachahya kꞌuáyakonhen tí nkehe tsjéhya chónta la kja̱xin chrókjuachahya chrókꞌuáyakonhen tí tsjé nkehe chróchónta chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Mé xi̱kaha tí xitjahya tꞌayakonhénrá tí chichaon kuènte chjasintajni ntihó la, ¿ntá nkexrí chrókꞌuayéhérá nkehe tjete chaxín kuènte nkaya nka̱jní? ");
INSERT INTO poeNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Mé xi̱kaha tí kjuachahyará kꞌuáyakonhénrá tí chichaon kuènte ókjé nkexro, ¿ntá nkexro chrótjáhará jahará tí nkehe chaxín tjete chrókꞌuáyakonhénrá? ");
INSERT INTO poeNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Nijnko nkexro xitjahya sichꞌehe yaá lamó xra̱ kíxin ijnko la tso̱nínkakonhen chꞌán la ko tí í jnko tsotjuèhe chꞌán, o̱ ijnko la tsitekakonhen chꞌán, la tí í jnko la tsitekakuenhya chꞌán. Xitjahya chrókjuichꞌehe chojni xra̱ Dios tí tjinkaon sín tsochónta sín itsjé chichaon ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","A̱ ntá tí sín fariseo imá kóxrjínhi̱n sín chichaon, ntá kuínhin sín kaín tíha nkerí ichro chꞌín Jesús, ntá kjuanoá sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Na ntá chꞌín Jesús ntáche chꞌán sín kíxin: ―A̱ ntá jahará tjinkáonrá chrókꞌuejóxi̱nrá jína nkayakon chojni. A̱ ntá Dios la chóxin chꞌán a̱sánrá. A̱ ntá tí nkehe imá tóxrjínhi̱n chꞌe chojni la Dios la tóxrjíe̱nhya chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Na̱xa̱ kjuakohya chꞌín Juan la kꞌuékjako sín tí ley kuènte chꞌín Moisés la ko tí nkehe kꞌuékjin tí sín kꞌuéchronka itén Dios ósé. A̱ ntá kui chꞌín Juan la chrónka chꞌán tí tan jína nkexrí tsꞌe̱to̱an Dios tí kjuachaxin kuènte chꞌán ntá kaín chojni imá tjinkaon sín chrókjuacha sín chrókꞌuejó sín tí tjen Dios tꞌe̱to̱an chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’A̱ntsí xra̱hya chrókꞌuitjáyan tí nkehe siín nka̱jní la ko chjasintajni. A̱ ntá xitjahya kíxin chróxiteyáhya kjónté ijnko nkehe ntsí tꞌe̱to̱an tí ley. ");
INSERT INTO poeNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’A̱ ntá ijnko chojni tsjake̱he̱ ichjién la ntá tsakja chꞌán í jnko chojni chjin la ijie̱ tíha. A̱ ntá tí chꞌín tsakja ijnko tjan tsíkítsínkehe la kja̱xin ijie̱ tíha. ");
INSERT INTO poeNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’Ntá kjuákꞌe ijnko chꞌán imá rico chꞌán la ko kꞌuítsá chꞌán ka imá tjete náxrjón kjátse tié la ko kaín ya̱on kjuasin chꞌán kia. ");
INSERT INTO poeNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","A̱ ntá ntója nto̱e chꞌán kjuákꞌetja̱xi̱n ijnko chꞌín nòa mé itꞌin chꞌán Lázaro tjanchakꞌá chꞌán la ko níhi chꞌán tsíchrꞌenka kuenté nto̱e chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","A̱ ntá tí chꞌín nòa la imá kjuakꞌe a̱sén chꞌán chrókjóne chꞌán la ko chrókókje̱exín chꞌán tí nkehe to̱tꞌo̱ tsjixènjinkíxin mesa kuènte tí chꞌín rico. A̱ ntá tí koni̱a̱ la kjua̱má va tí to̱sóa chónta chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","A̱ ntá ijnko ya̱on mé ikꞌuén tí chꞌín nòa. A̱ ntá tí sín ángel mé sákjui̱ko chꞌán tí náxrjón tjen chꞌín Abraham. La ko kja̱xin ikꞌuén tí chꞌín kꞌuéríko la sákjuíkja̱vá sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ntá tjen chꞌán tí sátsji tí sín tsíkꞌen tjetjasóte chꞌán. Ntá konta chꞌán kꞌuíkon chꞌán kíxin ikjín náxrjón tjen chꞌín Abraham tjeko chꞌán tí chꞌín Lázaro. ");
INSERT INTO poeNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ntá kꞌuèya tí chꞌín kꞌuéchónta tsjé nkehe ntáchro chꞌán kíxin: “Itꞌéni Abraham, ti̱konóa̱na tétue̱nhén tí chꞌín Lázaro kíxin sinchekjataxín chꞌán kóhe dedo tja chꞌán ìnta̱ ntá tsi chꞌán tsjakꞌeta̱kꞌá chꞌán ne̱je̱n kíxin tsoxrue̱he kíxin tjinahya sóa tí xrohi siín ntihi”, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Kjánchó ntáchro chꞌín Abraham kíxin: “Xje̱enni, xráxinkávan kíxin tió kjuákꞌe chjasintajni na ó kꞌuayéhé itsjé nkehe náxrjón. A̱ ntá chꞌín Lázaro mé kꞌuáyéhe̱ chꞌán nkehe náxrjónhya. A̱ ntá jie ntihi kjuaxróxin tjen chꞌán, a̱ ntá jaha tjetjasótia méhe̱. ");
INSERT INTO poeNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","A̱ ntá kja̱xin jnko̱siné tjen tsa̱ka imá jié xitjahya tsꞌátòye̱ tí sín siín ntihi tsjihya sín tí tjen jaha la ko kja̱xin tí sín siín méhe̱ xitjahya tsꞌátòye̱ sín itsji sín ntihi”, mé ichro chꞌín Abraham. ");
INSERT INTO poeNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","A̱ ntá tí chꞌín kꞌuéríko mé ntáchro chꞌán kíxin: “Ntá xrja̱nóa̱ha jaha Itꞌéni Abraham kíxin tétue̱nhén tí chꞌín Lázaro sátsji chꞌán nto̱e tꞌaná ");
INSERT INTO poeNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","kíxin ntaha kuíto̱he inꞌó tí sín kíchiná, ntá chróchenka chꞌán sín kíxin chrókuihya sín ntihi chrókjuasótehya sín kíxin imá náxrjónhya ntihi”, mé ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Kjánchó kjuáte̱he chꞌín Abraham ntáchro chꞌán kíxin: “Ó chónta sín tí nkehe tsíkjin chꞌín Moisés la ko tí sín kꞌuéchronka itén Dios ósé a. Chrókuinhin sín tí nkehe tsíntáchro tí sín a”, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ntá ntáchro tí chꞌín a ínaá kíxin: “Náhí, Itꞌéni Abraham. Chrókójína sáchrókjuitsjehe ijnko chojni tsíkꞌen ntá chrókuitekaon sín chrókuíto̱he sín iji̱é sín”, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ntá ntáchro chꞌín Abraham kíxin: “Tí tsitekakonhya sín tí nkehe tsíntáchro chꞌín Moisés la ko tí nkehe tsíntáchro tí í so sín tsíchronka itén Dios ósé, ntá kja̱xin tsitekakonhya sín kjónté chróxechón ijnko chojni tsíkꞌen chrókjuichronka ínaá”, ichro chꞌán.﻿ ");
INSERT INTO poeNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Chꞌín Jesús ntáche chꞌán tí sín kꞌuájiko chꞌán kíxin: ―Xráxín siín nkehe tsjasixín chojni jie̱. Kjánchó nòa tí nkexro tjasin tí nkehe tsjasixín chojni jie̱. ");
INSERT INTO poeNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Íchá jína chrókjuincheteyá sín chꞌán ijnko xro̱ tsíkꞌóna xro̱chre̱ chrókjuikákánkí sín nta̱yaon kíxin tjasin chꞌán tí nkehe tjasixín jie̱ ijnko chánjan na̱xa̱ noehya. ");
INSERT INTO poeNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Tóxakonhanrá kíxin xi̱kahya chrókjuásinrá nkehe. ’A̱ ntá tí kíchuárá chrókjuasinhanrá chꞌán ichrén jie̱ chrónixje̱hérá chꞌán chróchenkará chꞌán kíxin jehya jína tí xi̱kaha kjuítꞌahará chꞌán. A̱ ntá tí chrókuitekaon chꞌán chrókjuitoxi̱nhin chꞌán tí tjenka̱yáxin chꞌán, ntá chrókꞌuitjáyanhanrá tí nkehe kjuítꞌahará chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Kjónté chrókjuasinhanrá chꞌán jie̱ yato veces jnkoko̱á ya̱on la ko yato veces chróntáchro chꞌán kíxin í xi̱kahya tsjasin chꞌán jie̱ ínaá, la tꞌichjánxi̱n tsꞌitjáyanhanrá tí nkehe kjuítꞌahará chꞌán tí xi̱kaha ntáchro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ijnko ya̱on tí sín kꞌuájiko Ìnchéni ntáche sín chꞌán kíxin: ―Tjínki̱tsani kíxin a̱ntsí chrókuinkáchónkini tí jaha ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","A̱ ntá Ìnchéni ntáchro chꞌán kíxin: ―Kjónté intsí chrókuinkachónkirá tí janhan éxí jiéxin ijnko tje ntsí kuènte nta mostaza la jína chrókuétue̱nhénrá tí nta sicómoro kíxin chrókꞌuaxrjenkíxin tí tjen ntihi sáchrókjui chróxenkaxín jnko̱siné nta̱yaon ntiha, a̱ ntá tí nta la chrókjuinchexiteyá tí xi̱kaha chróntáchrorá. ");
INSERT INTO poeNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Jnkojín tí jahará tí chróchontará ijnko nkexro tꞌahará xra̱, a̱ ntá tí chrókja̱nxi̱n chꞌán no̱nta̱ará kjuínchentá chꞌán nche o̱ kꞌuàyakonhen chꞌán tí ko kuèntárá, ¿á chróntácherá chꞌán kíxin senó chrókjuakꞌe chꞌán chrókjóne chꞌán? ");
INSERT INTO poeNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Kjá náhí. Kjá chrókuétue̱nhénrá chꞌán kíxin senó chrókjuinchechján chꞌán tí nkehe sinte la ko chrókóyaxínhin chꞌán kíxin tsjanjon chꞌán nkehe nachrohe chrókjonte la ko chrókꞌuia. A̱ ntá tsjixin sinte la ntá tsjakꞌe chꞌán sine chꞌán la ko itsꞌi chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Á chrókjuanchehérá chꞌán kjuasáya kíxin kjuínchexiteyá chꞌán tí nkehe kuétue̱nhénrá chꞌán? Kjá náhí. ");
INSERT INTO poeNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Mé kja̱xin xi̱kaha tí jahará tió chrókjuixin kaín tí xra̱ kꞌue̱tua̱nhanrá Dios chróntáchrohyará kíxin jína kjui̱chꞌerá xra̱ kíxin ó jehó tí nkehe kꞌuítuanhanrá kjui̱nchexiteyárá, tsixrorá. ");
INSERT INTO poeNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ntá sátsji chꞌín Jesús chjasin Jerusalén ntá kꞌuátsínka chꞌán nó estado Samaria la ko estado Galilea. ");
INSERT INTO poeNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ntá kjuíji chꞌán ijnko chjasin ntsí ntá xeta chꞌán ite chojni ntoa níhi chónta sín chinlepra. Kjánchó ikjín tjejóchónhen sín ");
INSERT INTO poeNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ntá itsen kꞌuíye̱he̱ sín chꞌán ntáchro sín kíxin: ―Jesús, Maestro, ti̱konóe̱héni kaín ni ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ntá kꞌuíkon chꞌín Jesús tí jehe sín ikjín tjejó sín ntáche chꞌán sín kíxin: ―Sátsjirá tjákohérá tí sín ncha̱tꞌá kíxin ó kuíto̱hará jína, ichrorá. Nachrohe sákjuí sín tinkákito̱he sín jína. ");
INSERT INTO poeNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ntá ijnko tí jehe sín tió kónohe chꞌán kíxin kuíto̱he chꞌán jína ntá kjan chꞌán chjéhe chꞌán kjuasáya Dios la itsen nixja chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Kjuákꞌexín tochꞌín chꞌán chrínkí to̱té chꞌín Jesús kꞌuísén chꞌán xrákjanyani chꞌán nonte kíxin kjuanchia chꞌán kjuasáya. A̱ ntá tí chꞌín a mé tsíkji̱xi̱n chꞌán estado Samaria. ");
INSERT INTO poeNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","A̱ ntá chꞌín Jesús ntáchro chꞌán kíxin: ―¿Xá jehya ite chojni kuíto̱he jína? ¿Xá kjá tí sín ina? ");
INSERT INTO poeNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Á jehó tí chꞌín i kjónté ikjín tsíkji̱xi̱n chꞌán ikjan chꞌán kjuanchehe chꞌán kjuasáyé Dios ní? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","A̱ ntá ntáche chꞌán tí chꞌín a kíxin: ―Tꞌínkatjen sátjia. Kíxin tí kuítekávan Dios la kuíto̱ha jína ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","A̱ ntá tí sín fariseo kjuanchankíhi sín tí chꞌín Jesús kíxin nkesá tsi tí kjuachaxin kuènte Dios. A̱ ntá jehe chꞌán kjuáte̱he chꞌán ntáchro chꞌán kíxin: ―A̱ ntá tí tsi kjuachaxin kuènte Dios la me tíha ijnko nkehe xitjahya tsꞌikon chojni. ");
INSERT INTO poeNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Xitjahya tsontáchrorá kíxin: “Ntihi tjen,” o̱ “Ntiha tjen”; kíxin tí kjuachaxin kuènte Dios itjen jnko̱siné tí tjejorá ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ntá ntáche chꞌán tí sín kꞌuájiko chꞌán kíxin: ―A̱ ntá itsi tí ya̱on tsotjinkáonrá jnkojín ya̱on chrókꞌuikonrá tí Xje̱en Dios Kꞌóna Chojni, ntá í tsꞌikonhyará chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Tsontáchro sín kíxin ntihi tjen chꞌán, o̱ ntiha tjen chꞌán. Kjánchó sáchrókjuihyará la ko chróchréhyará sín. ");
INSERT INTO poeNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kíxin éxí tsꞌikonrá tsjo̱nkíxín tsꞌinkaséyanxín kuenté nka̱jní mé xi̱kaha tso̱nhen tió itsi tí Xje̱en Dios Kꞌóna Chojni. ");
INSERT INTO poeNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Tꞌichjánxi̱n senó tsjasóte chꞌán nchónhya la ko tí sín siín jie tsitekakuenhya sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Éxí kónhen tí ya̱on kjuákꞌe chꞌín Noé mé xi̱kaha tso̱nhen tió tsokjan tí Xje̱en Dios Kꞌóna Chojni. ");
INSERT INTO poeNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Kꞌuékjine sín la ko kꞌuékꞌi sín la ko kóte̱he tí xje̱en sín. A̱ ntá xrína̱hya kui tí ya̱on kꞌuíxenhen chꞌín Noé tí ntabárco̱ ntá kꞌuániá chrin, a̱ ntá tí sín kuíto̱he ntója la kaín sín kꞌuitjáyan sín. ");
INSERT INTO poeNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Mé kja̱xin xi̱kaha kónhen tí kjuákꞌe chꞌín Lot kꞌuékjine sín la ko kꞌuékꞌi sín la ko kꞌuékꞌe̱na sín nkehe la ko kꞌuékjinchekji sín nkehe la ko kꞌuékꞌe̱nka̱ sín no̱nte̱e sín la ko kꞌuékjichꞌéna sín nchia. ");
INSERT INTO poeNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","A̱ ntá tí ya̱on kꞌuaxrjexín chꞌín Lot tí chjasin Sodoma, na mé nka̱jní kui̱xi̱n xrohi la ko azufre, na mé tíha kꞌuenxín kaín xín tí sín ntiha. ");
INSERT INTO poeNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Mé xi̱kaha tso̱nhen tí ya̱on itsi tí Xje̱en Dios Kꞌóna Chojni. ");
INSERT INTO poeNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’A̱ ntá tí ya̱on i tí tjejó jnkojín nkexro chrítaón nchia tjejótꞌo̱kꞌéhe sín, a̱ ntá ichrén nkehe chónta sín kuíto̱he sín nkaxenhen nchia la í chrókꞌuinkajinhya sín chrókuakitsje sín tí nkehe chónta sín, tjoka sáchrókjui sín ókjé. Kja̱xin xi̱kaha jnkojin chojni tjejó sín no̱nte̱e sín la í chrókjanhya sín nto̱e sín. ");
INSERT INTO poeNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Xráxinkáonrá nkehe kónhen ichjién chꞌín Lot. ");
INSERT INTO poeNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Tí nkexro tjinkaon kíxin kohya nkehe chrókónhen na mé tsꞌitjáyan. A̱ ntá tí nkexro chrókjuinchekꞌitjáyanxín a̱sén kíxin chróchronka itén Dios la mé tsaá. ");
INSERT INTO poeNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","A̱ ntá tsontáxrja̱n kíxin tí tie a jnkoko̱á tsꞌejójua yaá chojni la ijnko la sátsji̱ la ko tí í jnko la tsito̱he. ");
INSERT INTO poeNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Yaá chojni chjin itsꞌo sín jnkoko̱á, la ijnko la sátsji̱ la ko ijnko la tsito̱he. ");
INSERT INTO poeNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Yaá chojni tsꞌejóchꞌe sín xra̱ nonte, la ijnko la sátsji̱ a̱ ntá ijnko la tsito̱he ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ntá kuínhin sín tíha ntá kjuanchankíhi sín chꞌán kíxin: ―¿Xá nketí tso̱nhen tíha, Ìnchéni? ―ichro sín. A̱ ntá jehe chꞌán kjuáte̱he chꞌán ntáchro chꞌán kíxin: ―Tí tjen tí cuerpo kuènte chojni tsíkꞌen la mé ntiha tso̱jnkotsé tí konte̱xjue̱n ―ichro chꞌán.﻿ ");
INSERT INTO poeNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","A̱ ntá chꞌín Jesús kjuíncheyóe̱xin chꞌán kjua̱ko̱xi̱n chꞌán kíxin jnkochríxín chrónixje̱he̱ chojni Dios la ko chrókóxrjéhya sín. ");
INSERT INTO poeNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ntá ntáche chꞌán sín kíxin: ―Ijnko chjasin kjuákꞌe ijnko chꞌín juez kjuikosáyehya chꞌán Dios la ko kꞌuéchóntehya chꞌán kjuasáyé ninkexró. ");
INSERT INTO poeNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Kja̱xin chjasin ntiha kjuákꞌe ijnko tjan kꞌán, jnkoya̱xón sákjuítsjehe tjan tí chꞌín juez kjuanchia tjan jie̱ ntáchro tjan kíxin chrókuito̱exín kíxin ijnko chojni nínkakonhen tjan ntiha. ");
INSERT INTO poeNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Nchónhya veces tjitsjehe tjan tí chꞌín juez la chrohya chꞌán chrókjuinchekito̱exín chꞌán. Ntá chrꞌéxi̱n kjuenka̱yáxin chꞌán ntáchro chꞌán kíxin: “Kjónté í tsjíkosáyàhya Dios la ko ninkexró tsjíkosáyàhya ");
INSERT INTO poeNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","a̱ ntá tí tjan kꞌán jnkoya̱xón tjanchia tjan jie̱, la tsjínki̱tsa tjan tsito̱exín tí jie̱ tjanchia tjan kíxin í jnkoya̱xónhya itsi tjan tsochronòa tjan kíxin ó kjuixin kónínka̱van jie”, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ntá ntáchro Ìnchéni kíxin: ―Mé xi̱kaha ichro tí chꞌín juez jínahya. ");
INSERT INTO poeNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿Xá chrókjuinki̱tsahya Dios tí sín kjueyá chꞌán tí chróchronóe̱he̱ sín chꞌán ncha̱kotjin la ko tie? ¿Á tjokahya chrókjuate̱he chrókjuinki̱tsa sín chꞌán? ");
INSERT INTO poeNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ntáxrja̱n kíxin kjá tjoka chrókjuinki̱tsa sín chꞌán. A̱ ntá tió itsi tí Xje̱en Dios Kꞌóna Chojni, ¿á na̱xa̱ chrókꞌuitja chꞌán chojni tinkáchónki tí jehe chꞌán ntihi chjasintajni? ―mé chro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ntá chꞌín Jesús kjuíncheyóe̱xin chꞌán nixje̱he̱ chꞌán iso chojni tjenka̱yáxin sín kíxin imá jína sín a̱ ntá tí í so sín la náhí, ichro sín. Ntá ntáchro chꞌán kíxin: ");
INSERT INTO poeNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Iyó sín ntoa sákjui̱ nkaxenhen ni̱nko kíxin tsonixje̱he̱ sín Dios. Ijnko la fariseo la ko ijnko la chꞌín nchekjènki̱. ");
INSERT INTO poeNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","A̱ ntá tí chꞌín fariseo tjexín chꞌán to̱té chꞌán nixje̱he̱ chꞌán Dios ntáchro chꞌán kíxin: “Itꞌéni Dios, kjuasáya tja̱há kíxin jeheni la chóntahyani jie̱ éxí tí sín í so kíxin teé sín la ko chꞌiyehe kíchó sín la ko chꞌiyehe sín chojni chjin. Kja̱xin jeheni la jehya éxí tí chꞌín nchekjènki̱ tjinhin. ");
INSERT INTO poeNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Jeheni la nehyani iyó ya̱on jnkojnko semana la ko kja̱xin tjanjonni tí chichaon tjachani tí diezmo kuèntá”, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","A̱ ntá tí chꞌín nchekjènki̱ la imá kjín kuíto̱he chꞌán kóxakonhen chꞌán chrókonta chꞌán nka̱jní la mé chjéhe chꞌán ntakuin chꞌán ntáchro chꞌán kíxin: “Itꞌéni Dios ti̱konóe̱héni tí jeheni kíxin nchónhya jie̱ chóntani”, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Tjo̱nka̱rá kíxin tí chꞌín nchekjènki̱ tió kjan chꞌán nto̱e chꞌán la Dios kui̱konóe̱he̱ tí jehe chꞌán la kjuìinhin chꞌán tí jie̱ chónta chꞌán, a̱ ntá tí chꞌín fariseo la náhí. Kíxin kaín chojni nchehnkehe a̱sén kíxin imá jína tí jehe sín la mé imá tso̱ntsí. A̱ ntá tí chojni nchehnkehya a̱sén la imá tsꞌánkí tí kjuaxrexinkaon kuènte sín. ");
INSERT INTO poeNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Kja̱xin kjui̱ka̱o sín chánjan ntsíntsí tí tjen chꞌín Jesús kíxin chrókjuincheyaon chꞌán xjan. Kjánchó tió kꞌuíkon tí sín kꞌuájiko chꞌán la í kjuanjonhya sín kjuachaxin kíxin tso̱chjinako sín xjan. ");
INSERT INTO poeNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","A̱ ntá chꞌín Jesús kꞌuíye̱he̱ chꞌán sín ntáchro chꞌán kíxin: ―Ti̱to̱hérá chánjan méhe̱ xrakoa tí tjèn janhan la tꞌínka̱kuènhyará xjan kíxin tí sín kuènte kjuachaxin kuènte Dios la mé tóyóhe̱ tí jehe xjan. ");
INSERT INTO poeNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ntá chaxín ntáxrja̱n kíxin tí nkexro tsꞌónahya éxí ijnko chánjan xitjahya tsꞌejó sín tí tsꞌe̱to̱an Dios tí kjuachaxin kuènte chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ijnko chꞌín tꞌe̱to̱an kuènte ni̱nko kjuanchankíhi chꞌán tí chꞌín Jesús kíxin: ―Jaha la ijnko maestro jína la, ¿nkehe na̱xa̱ tꞌitjáyan chrókjuichꞌeni kíxin chróchóntani kjuachón jnkochríxín? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―¿Nkekuènte ntáchrua kíxin jína tí janhan? Jnkoko̱á nkexro la mé jína la tíha mé Dios. ");
INSERT INTO poeNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Jaha la ó noha nkehe tí kꞌue̱to̱an Dios kíxin chrókjuacheéhya kíchuárá, la ko chrókꞌoyánhya chojni, la ko chrókue̱ehya, la ko chróntáchrohya ninkehó nkehe chaxínhya kuènte ókjé chojni, la ko chrókjuíkosáyehé itꞌá la ko ìná ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","A̱ ntá jehe chꞌán kjuáte̱he chꞌán ntáchro chꞌán kíxin: ―Kaín tíha kjuínchexiteyáni desde xja̱nntsíni ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","A̱ ntá kuínhin chꞌín Jesús kaín tíha ntá jehe chꞌán ntáchro chꞌán kíxin: ―A̱ ntá jnkoko̱á nkehe na̱xa̱ tꞌitjáyan chrókjui̱chꞌe, chrókjui̱nchekjia kaín nkehe chonta la chróchje̱hé tí chichaon tí sín nòa. A̱ ntá tí nkehe tjete la tsochonta nkaya nka̱jní. A̱ ntá tió tsjixin si̱ncheki̱to̱nhén sín nkehe, a̱ ntá tsjihá ntá chréhé tí janhan ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","A̱ ntá tí chꞌín a kuínhin chꞌán xi̱kaha la kóxakonhen chꞌán kíxin imá itsjé nkehe chónta chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Tió kꞌuíkon chꞌín Jesús kíxin kóxakonhen tí chꞌín a la ntá ntáchro chꞌán kíxin: ―Imá xra̱ kíxin tí chojni chónta itsjé nkehe chrókꞌuixenhen sín tí tjen Dios tꞌe̱to̱an. ");
INSERT INTO poeNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","A̱ntsí xra̱hya chrókꞌuatsínka ijnko kocamello ijnko tja̱rꞌi ntachica tjexrja, a̱ ntá a̱ntsí má xra̱ kíxin ijnko chojni chónta itsjé nkehe chrókjuakꞌe tí tꞌe̱to̱an Dios ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","A̱ ntá kuínhin sín kíxin xi̱kaha ntáchro chꞌán ntá ntáchro sín kíxin: ―¿Xá nkexro chrókjuacha chrókuaá? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ntá ntáchro chꞌín Jesús kíxin: ―Tí nkehe tsjachahya chojni chrókjuinchexiteyá, la Dios la tsjacha chꞌán sichꞌe chꞌán kaín tíha ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","A̱ ntá chꞌín Pedro ntáchro chꞌán kíxin: ―Ìnchéni, jeheni la ó kuíto̱heni kaín nkehe chóntani kíxin tsochréhe̱ni tí jaha ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Ntá chaxín tso̱tjo̱nka̱rá kíxin jnkojínrá chrókui̱to̱hérá nto̱a, la o̱ chrókui̱to̱hérá itꞌá la ko ìná, la o̱ chrókui̱to̱hérá kíchuárá, la o̱ chrókui̱to̱hérá ichjiánrá, la o̱ chrókui̱to̱hérá xja̱anrá kíxin chrókjui̱chꞌerá xra̱ kuènte Dios ");
INSERT INTO poeNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","la a̱ntsí nkehe tsꞌayéhérá ntihi chjasintajni la ko tí chrꞌéxi̱n la tsꞌayéhérá kjuachón jnkochríxín ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ntá chꞌín Jesús kꞌuíye̱he̱ chꞌán jehó tí teyó sín kꞌuájiko chꞌán ntá chrónka chꞌán kíxin: ―Ijie sátsji̱ni Jerusalén. A̱ ntá ntaha tsoxiteyá kaín tí nkehe tsíkjin tí sín tsíchronka itén Dios ósé nkexrí tso̱nhen tí Xje̱en Dios Kꞌóna Chojni. ");
INSERT INTO poeNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Tsjikaán sín chꞌán tí tjejó tí sín jehya judío la ko tsjanoá sín chꞌán la ko tsꞌántaxínhi̱n sín chꞌán la ko nta̱te sín tsi̱ki̱te sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Tsjate sín chꞌán, a̱ ntá chrꞌéxi̱n la tsꞌóyán sín chꞌán. A̱ ntá níxin ya̱on tsoxechón chꞌán ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","A̱ ntá jehe sín la ninkehó kienxínhya sín tí nkehe nixja chꞌán kíxin tíha ijnko nkehe na̱xa̱ tsjachahya sín chrókienxín sín. ");
INSERT INTO poeNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","A̱ ntá chꞌín Jesús tió chjina chrókꞌuixenhen chꞌán chjasin Jericó ntá ntiha chrínta nti̱a tjetja̱xi̱n ijnko chꞌín tꞌikonhya tjanchakꞌá chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ntá xrína̱hya kuínhin tí chꞌín tꞌikonhya kíxin sítꞌatsínka nchónhya chojni, ntá kjuanchankí chꞌán kíxin: ―¿Xa nkerí sítónhen? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ntá chénka sín chꞌán kíxin chꞌín Jesús tsíkji̱xi̱n chjasin Nazaret tsꞌatsínka chꞌán ntiha. ");
INSERT INTO poeNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ntá kꞌuèya chꞌán ntáchro chꞌán kíxin: ―Jaha Jesús tsíkꞌaxrjeníxian chꞌín David, ti̱konóe̱héni ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","A̱ ntá tí sín tsítaón nti̱a la kꞌue̱tue̱nhen sín chꞌán kíxin tso̱tání chꞌán. Kjánchó jehe chꞌán a̱ntsí tsen kꞌuèya chꞌán ntáchro chꞌán kíxin: ―Jaha tsíkꞌaxrjeníxian chꞌín David, ti̱konóe̱héni ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","A̱ ntá chꞌín Jesús ntá ntahó kjuákꞌechónhen chꞌán ntá kꞌue̱to̱an chꞌán kíxin tsjikakjín sín tí chꞌín a. Ntá tió kui̱ka̱o sín chꞌán tí chjinaxón tjen chꞌín Jesús ntá kjuanchankí chꞌín Jesús kíxin: ");
INSERT INTO poeNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Nkehe tjinkávan si̱tꞌaha? ―ichro chꞌán. Ntá kjuáte̱he tí chꞌín tꞌikonhya ntáchro chꞌán kíxin: ―Jaha Ìnchéni, tjinkaonni chrókjui̱nchekꞌikuanni ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ntá ntáchro chꞌín Jesús kíxin: ―Ó tsꞌikuan. Ó kuíto̱ha jína kíxin kuítekávan tí janhan ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ntá tuénxín kꞌuíkon tí chꞌín kꞌuékꞌikonhya, a̱ ntá jehe chꞌán chréhe̱ chꞌán tí chꞌín Jesús la ko kjuanchehe chꞌán kjuasáyé Dios. La ko kaín tí sín kꞌuíkon kíxin xi̱kaha kónhen kjuanchehe sín kjuasáyé Dios.﻿ ");
INSERT INTO poeNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","A̱ ntá chꞌín Jesús kꞌuíxenhen chꞌán chjasin Jericó la ntá kꞌuátsínka chꞌán tí chjasin a. ");
INSERT INTO poeNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","A̱ ntá ntiha tjen ijnko chojni ríco itꞌin chꞌán Zaqueo, tꞌe̱tue̱nhen chꞌán tí sín nchekjènki̱. ");
INSERT INTO poeNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Tjinkaon chꞌán chrókjuatso̱an chꞌán nkexro tí chꞌín Jesús, kjánchó nchónhya chojni siín la xitjahya tꞌikon chꞌán kíxin intsí chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ntá kuinká chꞌán kuítaón chꞌán nti̱a kíxin tjinkaon chꞌán chrókꞌuikon chꞌán. Ntá kuátsé chꞌán ijnko nta sicómoro chjinaxón tí tsꞌatsínka chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","A̱ ntá tió kꞌuatsínka chꞌín Jesús ntiha konta chꞌán tí nta ntáchro chꞌán kíxin: ―Zaqueo, tjoka tjasinka̱jián kíxin nto̱a ntahó tsito̱na jie ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ntá chꞌín Zaqueo la tjoka kꞌuínkajin chꞌán kóchéhe̱ chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ntá kaín sín kꞌuíkon sín xi̱kaha ntá kjuankíxin sín tjonta sín tí chꞌín Jesús, ntáchro sín kíxin nto̱e ijnko chojni chónta nchónhya jie̱ tsito̱he chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ntá chꞌín Zaqueo kjuákꞌexín to̱té chꞌán ntáche chꞌán Ìnchéni kíxin: ―Jaha Ìnchéni, chrókónoha kíxin tsjánjuan jnko̱siné tí nkehe chonta si̱ntaki̱to̱nha̱n tí sín nòa. A̱ ntá tí jnkojín nkexro kjui̱tꞌáyaha̱ kuaáha la noó veces tsꞌokja̱nha̱n sín tí chichaon jie ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","A̱ ntá ntáchro chꞌín Jesús kíxin: ―A̱ ntá jie la tsaá chojni tí nchia i kíxin tí chꞌín a mé kꞌuaxrjeníxin chꞌín Abraham. ");
INSERT INTO poeNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","A̱ ntá tí Xje̱en Dios Kꞌóna Chojni mé kuikjeyá la ko sinchekaá tí chojni chónta jie̱. ");
INSERT INTO poeNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","A̱ ntá tí chojni siín ntiha nachrohe tjejótinhin sín nkerí tjechro chꞌín Jesús, a̱ ntá jehe chꞌán kjuíncheyóe̱xin chꞌán nkehe kíxin ó tjen chꞌán chjinaxón chjasin Jerusalén, a̱ ntá jehe sín kjuenka̱yáxin sín kíxin tí kjuachaxin kuènte Dios la áchꞌe ó tuénxín tsi, ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","A̱ ntá ntáchro chꞌán kíxin: ―Itjen ijnko nkexro tsíkꞌaxrjeníxin ijnko nkexro imá kꞌuékꞌe̱to̱an. Ntá sákjuí chꞌán ókjé nación kíxin tsꞌáyéhe̱ chꞌán kjuachaxin tsꞌóna chꞌán rey, a̱ ntá chrꞌéxi̱n la xíkjan chꞌán ínaá. ");
INSERT INTO poeNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","A̱ ntá tió chjina sátsji chꞌán ntá kꞌuíye̱he̱ chꞌán ite tí sín chꞌehe chꞌán xra̱ ntá chjéhe chꞌán jnkojnko tí jehe sín jnkojnko chichaon imá tjete sínkí. Ntá kꞌue̱to̱an chꞌán kíxin: “Tsjankíxinrá chꞌekoará xra̱ tí chichaon hasta tí tsokjanjian”, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","A̱ ntá tí sín chjasén chꞌán ntiha imá kónínkakonhen sín chꞌán, ntá ichrꞌán sín iso chojni chréhe̱ sín tí sákjuí chꞌán tsochenka sín tí sín siín ntiha kíxin tjinkakonhya sín tí nkexro a tsꞌóna rey tsꞌe̱tue̱nhen sín. ");
INSERT INTO poeNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Kjónté xi̱kaha ichro tí sín a la kꞌuáyéhe̱ chꞌán kjuachaxin tsꞌóna chꞌán rey. Ntá kjan chꞌán chjasén chꞌán. Ntá kꞌue̱to̱an chꞌán xrakoa tí sín chꞌehe chꞌán xra̱, na mé tí sín tsíkꞌáyéhe̱ tí chichaon, kíxin tso̱nohe chꞌán nkehe tí xra̱ kjuíchꞌeko sín tí chichaon kꞌuáyéhe̱ sín. ");
INSERT INTO poeNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","A̱ ntá tí chꞌín xrankíxixín kóchjina la ntáchro chꞌán kíxin: “Tí chi̱cha̱ko̱an la kjuachani ite chichaon ínaá”, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","A̱ ntá kjuáte̱he tí chꞌín rey kíxin: “Ó ncho̱xon tí xi̱kaha jaha la ijnko chojni jína chꞌe xra̱. Jína kjui̱chꞌe xra̱ kjónté jehya xra̱ jié ntá tsjánjuan kjuachaxin tséto̱an ite chjasin”, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","A̱ ntá kóchjina tí chꞌín í jnko a ínaá ntáchro chꞌán kíxin: “Tí chi̱cha̱ko̱an la kjuachani inꞌó chichaon ínaá”, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","A̱ ntá xi̱kaha ínaá kjuáte̱he tí chꞌín rey kíxin: “Tsjánjuan kjuachaxin tséto̱an inꞌó chjasin”, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","A̱ ntá kóchjina tí chꞌín níxin ntáchro chꞌán kíxin: “Tí chi̱cha̱ko̱an la tjinhin. Kꞌuánkíntani paníto̱éni ");
INSERT INTO poeNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","kíxin chrakonhanni kíxin jaha la jia̱ha la tjinkávan tsákjá tí nkehe jehya jaha kjuaké la ko tso̱tja̱ tí nkehe jehya jaha kuènka̱xian”, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","A̱ ntá tí rey ntáchro chꞌán kíxin: “Jehya chojni jína chꞌe xra̱ jaha. Tí nkehe ntáchrua tsjáncháxian jie̱. Jaha la ó noha kíxin jie̱na janhan tsákjaá tí nkehe kjuakéhya, ichrua, la ko tso̱tja̱ tí nkehe kuènka̱hya. ");
INSERT INTO poeNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Ntá nkekuènte kíxin chrꞌanhya tí chichaon ijnko banco chrókjuichꞌexín xra̱? A̱ ntá tió kjan nto̱na la a̱ntsí tsjé chichaon chrókꞌuayáha̱ tí chrókjuacha kíchó chica”, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","A̱ ntá ntáche chꞌán tí sín siín ntiha kíxin: “Takítsjehérá chꞌán tí chichaon tsíkꞌáyéhe̱ chꞌán la ntá chje̱hérá tí chꞌín chónta ite chichaon”, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","A̱ ntá jehe sín ntáchro sín kíxin: “¿Nkekuènte chrókꞌuáyéhe̱ chꞌán kíxin ó chónta chꞌán ite chichaon?” ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","A̱ ntá tí chꞌín rey kjuáte̱he chꞌán ntáchro chꞌán kíxin: “Kjónté jnkojín nkexro itsjé chónta la tsꞌáyéhe̱ má. A̱ ntá tí nkexro chóntahya la kjónté tí ntsí chónta chꞌán la tsꞌaxrjehe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","A̱ ntá tí sín nínkakonna sín tjinkakonhya sín kíxin tsꞌónana rey la xrákoará sín ntihi tsꞌíko̱nxín kua̱n tsꞌochrínjinrá kja sín.” ");
INSERT INTO poeNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Tió kjuixin ntáchro chꞌín Jesús tíhi ntá chrìin chꞌán sátsji̱ chꞌán chjasin Jerusalén. ");
INSERT INTO poeNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","A̱ ntá ó kjuíji chjinaxón tí chjasin Betfagé la ko chjasin Betania chjinaxón tí jna̱ nchekꞌin sín Olivo, ntá kꞌue̱tue̱nhen chꞌán iyó tí sín kꞌuájiko chꞌán ");
INSERT INTO poeNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ntáche chꞌán sín kíxin: ―Sátjirá tí chjasin ntsí chokꞌèxin ntihi, a̱ ntá tió tsjasánrá ntiha tsꞌitjará ijnko kolocho tjechroé va na̱xa̱ ninkexró tjitákꞌáhya va. Tjasinta̱nke̱hérá va la tsjíkuanará va ntihi. ");
INSERT INTO poeNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","A̱ ntá tí jnkojín nkexro tsjanchankíhará nkekuènte tjasinta̱nke̱hérá va la ntácherá sín kíxin: “Ìnchéni tsꞌichjánxi̱nhin va”, tsixrorá. ");
INSERT INTO poeNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","A̱ ntá tí sín kꞌuítuenhen sákjuí sín kꞌuitja sín éxí ntáchro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","A̱ ntá tió tjejótjasinta̱nke̱he sín va la ntá tí sín ìnché va kjuanchankíhi sín kíxin: ―¿Nkekuènte tjasinta̱nke̱hérá tí kolócho? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","A̱ ntá jehe sín kjuáte̱he sín kíxin: ―Ìnchéni tsꞌichjánxi̱nhin va ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ntá sákjuíkohe sín va tí chꞌín Jesús, la ntá tí iké sín kjuínchekamá sín va, ntá kjuítákꞌá chꞌín Jesús tí kolócho a. ");
INSERT INTO poeNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","A̱ ntá tinkákji̱ tí kolócho tjekjen chꞌán la tinkákꞌikjínxi̱n sín tí iké sín nti̱a kíxin nátaón tí ka tsꞌatsínka tí kolocho tjekjen chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ntá tió kjuíjichjina sín tí chjinaxón tí tꞌinkaji̱nxi̱n chojni tí jna̱ Olivo, a̱ ntá kaín tí sín kuítekaon tí jehe chꞌán chréhe̱ sín kjuankíxin sín itsen nixja sín chéhe̱ sín kjuanchehe sín kjuasáyé Dios kíxin kaín tí kjuaxroan kꞌuíkonxín kon sín. ");
INSERT INTO poeNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ntá ntáchro sín kíxin: ―Jína tí nkexro Rey kjui̱xi̱n kjuachaxin ihni̱é Dios. Tsjakꞌe kjuaxróxin nkaya nka̱jní la ko kjuasáyé Dios tjen nkaya nka̱jní ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","A̱ ntá iso tí sín fariseo tjejóyákjan sín í so chojni tjejónchexroan sín ntiha ntáchro sín kíxin: ―Maestro, tétue̱nhén tí sín chréhe̱ tí jaha kíxin tso̱tání sín ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","A̱ ntá chꞌín Jesús kjuáte̱he chꞌán ntáche chꞌán sín kíxin: ―A̱ ntá tí sín i tso̱tání sín la ixro̱ tsotsje ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","A̱ ntá tió kjuíjichjina chꞌán chjasin Jerusalén ntá kꞌuíkon chꞌán tí chjasin la ntá tsjánka chꞌán kíxin kuítekakonhya sín ");
INSERT INTO poeNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ntáchro chꞌán kíxin: ―Chrókuiénxinrá la ko chrókónohará nkexrí chrókꞌuayèxinrá tí kjuaxróxin, kjánchó jahará kuítekákonhyará. A̱ ntá ó kjuixin kꞌuátsínka tí kjuaxróxin chrókꞌuikonrá la xitjahya tsꞌikonrá jie. ");
INSERT INTO poeNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","A̱ ntá tsi iso ya̱on jínahya itsi tí sín nínkakonhanrá la sichꞌéna sín ijnko tja̱tꞌo̱ tsꞌántatjen tí chjasin tjejorá ntihi tsꞌinkákonhe̱n kíxin xitjahya tsꞌaxrjéxi̱nrá chjasin ntihi kíxin nkuíxín tsꞌejó sín tsꞌinkákonha̱nrá sín ");
INSERT INTO poeNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ntá tsꞌóxíka sín kaín tí tja̱tꞌo̱ siín ntihi la ko tsꞌóyán sín kaín tí chojni siín la ko tsíto̱ehya sín kíxin ninkehó xro̱ na̱xa̱ tsꞌejókjen kíchó, kíxin jahará kjuátso̱anhyará kíxin kuitsjehe Dios tí chjasin tjejorá ntihi. ");
INSERT INTO poeNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","A̱ ntá chꞌín Jesús kꞌuíxenhen chꞌán tí ni̱nko jié, a̱ ntá kjuankíxin chꞌán kuakitsje chꞌán tí sín nchekji nkehe la ko tí sín tꞌe̱na nkehe ntiha. ");
INSERT INTO poeNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ntá ntáchro chꞌán kíxin: ―A̱ ntá ntáchro xroon itén Dios chrónka kíxin: “Tí nto̱na i mé itꞌin nchia tsonixjanaxián chojni”, ichro. A̱ ntá jahará tí nchia i tsíkji̱chꞌénará itjue̱é xíche̱e ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","A̱ ntá tí ni̱nko ntiha kjuákꞌe chꞌín Jesús kjuako chꞌán kaín ya̱on. A̱ ntá tí sín ncha̱tꞌá tꞌe̱to̱an la ko tí maestro tjako tí ley la ko kja̱xin tí sín tꞌe̱to̱an tí chjasin ntiha kjueyá sín nkexrí chrókꞌóyán sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Kjánchó kꞌuitjahya sín nkexrí chrókꞌóyán sín chꞌán kíxin kaín chojni tjejótinhin tí nkehe tjechronka chꞌán.﻿ ");
INSERT INTO poeNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","A̱ ntá ijnko ya̱on kjuákꞌe chꞌín Jesús tí ni̱nko ntiha kjua̱ko̱he̱ chꞌán chojni tí tan jína tsaáxin sín. A̱ ntá kjui tí sín ncha̱tꞌá tꞌe̱to̱an la ko tí sín maestro tjako tí ley la ko kja̱xin tí sín tꞌe̱to̱an kuènte ni̱nko. ");
INSERT INTO poeNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ntá kjuanchankíhi sín chꞌán kíxin: ―Chro̱nka nkehe tí kjuachaxin chonta kíxin xi̱kaha chꞌe. ¿Nkexro kjuanjon tí kjuachaxin a? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Kja̱xin janhan tsjánchánkíhará ijnko nkehe siná nkexrí tsjate̱herá. ");
INSERT INTO poeNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿A̱ ntá nkexro kꞌue̱tue̱nhen tí chꞌín Juan kíxin tsi̱ki̱te chꞌán chojni? ¿Á Dios ní o̱ chojni ó? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ntá kjuankíxin sín tjo sín kíchó sín ntáchro sín kíxin: ―¿Nkehe chrókjuate̱heni? A̱ ntá tí tsontáchroni kíxin Dios tsíchrꞌán tí chꞌín Juan la ntá tsjanchankí chꞌán kíxin nkekuènte kuítekakuenhyani chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","A̱ ntá tí tsontáchroni kíxin chojni ó kꞌue̱tue̱nhen sín chꞌán la ntá kaín chojni tso̱nínkaon sín la ixro̱ tsꞌóyánxinni sín kíxin tjenka̱yáxin sín kíxin chꞌín Juan chaxín kꞌuékjako chꞌán itén Dios ―mé xi̱kaha ikjo sín. ");
INSERT INTO poeNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ntá kjuáte̱he sín kíxin noehya sín nkexro tsíchrꞌán tí chꞌín Juan. ");
INSERT INTO poeNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ntá ntáchro chꞌín Jesús kíxin: ―Kja̱xin janhan tso̱xrja̱nkahya nkexro kjuanjon kjuachaxin tjétꞌa̱ tíhi ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ntá tuénxín kjuankíxin chꞌín Jesús nixje̱he̱ chꞌán chojni kjuíncheyóe̱xin chꞌán ntáchro chꞌán kíxin: ―Kjuákꞌe ijnko chojni kꞌue̱nka̱xin chꞌán nta to uva tí no̱nte̱e chꞌán, a̱ ntá chrꞌéxi̱n kjuínchekjen chꞌán tí iso tí sín chꞌe xra̱. A̱ ntá kjuixin ntá sákjuí chꞌán imá sé. ");
INSERT INTO poeNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","A̱ ntá kui tí ya̱on tsakjinjin sín to uva. Ntá kꞌue̱tue̱nhen chꞌán ijnko nkexro chꞌehe chꞌán xra̱ kíxin tsjikjanchehe chꞌán tí sín chꞌe xra̱ no̱nte̱e chꞌán kíxin tsjanjon sín tí to tónhen chꞌán tocar. A̱ ntá jehe sín kjuate sín tí chꞌín a la ntá kꞌuinkíté sín chꞌán la ninkehó tsíchjéhya sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","A̱ ntá tí chꞌín no̱nte̱e ichrꞌán chꞌán í jnko nkexro chꞌehe chꞌán xra̱. A̱ ntá kja̱xin kꞌuántaxínhi̱n sín chꞌán la ko kjuate sín chꞌán la ko kja̱xin ninkehó tsíchjéhya sín chꞌán ínaá. ");
INSERT INTO poeNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","A̱ ntá tí chꞌín no̱nte̱e ichrꞌán chꞌán í jnko nkexro. A̱ ntá tí sín chꞌe xra̱ kja̱xin xi̱kahó tsíkjichꞌehe sín ínaá, tsíkꞌinkíté sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Ntá tí chꞌín no̱nte̱e ntáchro chꞌán kíxin: “¿Nkexrí chrókjui̱tꞌa jie? Tsochrꞌan tí xja̱nna imá tjua̱ha̱. Áchꞌe chrókuitekakonhen sín chꞌán chróchóntehe sín chꞌán kjuasáya”, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","A̱ ntá kjónté kui chꞌán la kꞌuíkon tí sín chꞌe xra̱ ntá chénka sín kíchó sín kíxin: “Tí chꞌín i mé tsꞌáyéhe̱ chꞌán kaín nkehe kuènte itꞌé chꞌán. Tsꞌóyánni chꞌán kíxin jeheni tsito̱ekoni kaín tí nkehe a,” ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","A̱ ntá kuakitsjexín sín chꞌán tí nonte ntiha la kꞌóyán sín chꞌán. A̱ ntá kjuanchankí chꞌín Jesús kíxin: ―A̱ ntá tí ìnché nonte la, ¿nkehe chrókjuichꞌe chꞌán kíxin xi̱kaha kónhen tí xje̱en chꞌán? ");
INSERT INTO poeNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Chrókui chꞌán chrókjuinchekꞌitjáyan chꞌán tí sín chꞌe xra̱ kíxin xi̱kaha kjuíchꞌe sín kꞌóyán sín tí xje̱en chꞌán, a̱ ntá chróchjéhe chꞌán í so nkexro chrókjuichꞌe xra̱ tí nonte a ―ichro chꞌán. A̱ ntá tió kuínhin sín xi̱kaha ntáchro sín kíxin: ―Kjá Dios la xi̱kahya tjinkaon chꞌán ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","A̱ ntá chꞌín Jesús komá chꞌán tí jehe sín ntáchro chꞌán kíxin: ―¿A̱ ntá nkehe tꞌaxrjexín tí nkehe ntáchro xroon itén Dios ntáchro xi̱kihi?: Tí xro̱ náxrjónhya kuíto̱enta tí sín chꞌéna tja̱tꞌo̱, a̱ ntá mé jie kꞌóna tí xro̱ tjetoan. ");
INSERT INTO poeNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","A̱ ntá jnkojín chojni tsjitsínka chrítaón tí xro̱ i tso̱kuen chꞌán. A̱ ntá tsꞌánótjen tí xro̱ i tsoxratja ijnko chojni la tso̱kuen, tsꞌóna nche. ");
INSERT INTO poeNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","A̱ ntá tí ncha̱tꞌá tꞌe̱to̱an la ko tí maestro tjako tí ley tjinkaon sín chrótsé sín tí chꞌín Jesús tuénxín tí hora a kíxin ó kónohe sín kíxin jehe sín kuakitsjexín tí nkehe nixja chꞌán. Kjánchó xitjahya tsotsé sín chꞌán kíxin chrako̱nhe̱n sín tí chojni siín. ");
INSERT INTO poeNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ntá kꞌue̱tue̱nhen sín chojni tsotsáyehe sín chꞌán, éxí chojni chónta kjuasáyé chꞌán chrókjo sín chꞌán jnkojína kíxin áchꞌe ichrén nkehe ntoáhya tsonixja chꞌán. A̱ ntá jína tsjanchaxín sín jie̱ tsjikaán sín chꞌán tí tjen tí chꞌín gobernador. ");
INSERT INTO poeNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Mé xi̱kaha kjuanchankíhi sín chꞌán nkehe, a̱ ntá ntáchro sín kíxin: ―Maestro, ó noheni kíxin kaín nkehe ntáchrua la ko kaín nkehe tjàkua la chaxín ntoá la ko jehya nkexrí tsjehe chojni tjenka̱yáxixián kíxin á jína sín, la ntá ntoá tjàkua nti̱e Dios. ");
INSERT INTO poeNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","A̱ ntá jie la chro̱nka, ¿á jína chrókjue̱nke̱heni tí gobierno romano o̱ náhí? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","A̱ ntá chꞌín Jesús la ó kónohe chꞌán kíxin ntoáhya tjenka̱yáxin sín ntá ntáchro chꞌán kíxin: ―¿Nkekuènte chrokjua̱cha̱xi̱nráni? ");
INSERT INTO poeNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Tjákonará ijnko tí chichaon méhe̱. ¿Nkexro tí tsíkꞌaxrjexín tjenkáni tí chichaon i la ko nkexro ihni̱é chónta méhe̱? ―ichro chꞌán. Ntá kjuáte̱he sín kíxin: ―Tí chꞌín tꞌe̱to̱an mé tjenkáni chꞌán ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ntá ntáchro chꞌán kíxin: ―Chróchje̱hérá tí chꞌín gobierno tꞌe̱to̱an tí nkehe kuènte chꞌán; a̱ ntá tí nkehe kuènte Dios chróchje̱hérá Dios ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","A̱ ntá ninkehó kjuachahya sín kjua̱cha̱xi̱n sín chꞌán tí nkehe ntáchro chꞌán nkayakon chojni chjasin ntiha. A̱ ntá chrakon sín kuínhin sín kaín nkehe kjuáte̱he chꞌán la ntá tí sín kjuanchankí la tání sín kohya nkehe ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","A̱ ntá chrꞌéxi̱n iso tí sín saduceo sákjuítsjehe sín tí chꞌín Jesús. Kjánchó tí sín saduceo titekakonhya sín kíxin tsoxechón chojni tsíkꞌen. Xi̱kaha ntáche sín tí chꞌín Jesús kíxin: ");
INSERT INTO poeNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Maestro, chꞌín Moisés tsíkjin chꞌán tí xroon ley ntáchro kíxin tió tsꞌen ijnko chojni la ntá tsito̱he ichjién, tí chóntahya sín xje̱en, la tꞌichjánxi̱n kíxin kíchó tí chꞌín tsíkꞌen tso̱te̱he tí tjan kꞌán kíxin tsochónta sín xje̱en sín éxí xje̱en tí chꞌín sa̱o tsíkꞌen tsꞌikon sín. ");
INSERT INTO poeNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","A̱ ntá kꞌuéjó sín yato sín jnkoko̱á kíchó sín. A̱ ntá tí chꞌín sa̱o la kóte̱he chꞌán. Ntá kꞌuén chꞌán la chóntahya chꞌán ninkehó xje̱en chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","A̱ ntá tí chꞌín yóxin kíchó chꞌán la kóte̱he tí tjan kꞌán. Kja̱xin kꞌuén chꞌán chóntahya sín xje̱en sín. ");
INSERT INTO poeNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","A̱ ntá tí chꞌín níxin xíkóte̱he jehe tjan ínaá. Kja̱xin xi̱kaha kayatoé sín. Kaín sín kꞌuén sín ninkehó xje̱en sín chóntahya sín. ");
INSERT INTO poeNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","A̱ ntá kjuixixín kja̱xin jehe tjan ikꞌuén tjan. ");
INSERT INTO poeNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","A̱ ntá tió tsoxechón chojni tsíkꞌen, ¿ntá nkexro tí jehe sin tsꞌóna ichjién tí jehe tjan kíxin yato tí jehe sín kóte̱he tjan? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ntá chꞌín Jesús kjuáte̱he chꞌán ntáchro chꞌán kíxin: ―Ntihi chjasintajni tí chojni ntoa la ko ti chojni chjin tóte̱he sín takja kíchó sín. ");
INSERT INTO poeNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","A̱ ntá tí sín kuítekaon sín tí janhan ntá tsjacha sín tsoxechón sín ínaá la í tso̱te̱ehya sín la koí tso̱te̱ehya tí xje̱en sín. ");
INSERT INTO poeNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Kíxin tí sín a la xitjahya tsꞌen kíxin éxí tí sín ángel tsꞌejó sín kíxin xje̱en Dios tí jehe sín kíxin Dios kjuínchexechón chꞌán sín. ");
INSERT INTO poeNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Kja̱xin chꞌín Moisés tió chrónka chꞌán kuènte tí nta tjeche kjuínchenoheni chꞌán kíxin tí sín tsíkꞌen tsoxechón sín. Ntáchro chꞌán kíxin Ìnchéni Dios na mé tí Dios tinkáchónki chꞌín Abraham la ko chꞌín Isaac la ko chꞌín Jacob. ");
INSERT INTO poeNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Tí Dios i la jehya tinkáchónki tí sín tsíkꞌen. Náhí. Tí Dios i la tinkáchónki tí sín tjejóchón, la Dios la tꞌikon chꞌán kíxin kaín chojni la síchón ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","A̱ ntá iso tí sín tjako tí ley la ntáchro sín kíxin: ―Jína kjuàkua la ko jína ntáchrua, Maestro― ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","A̱ ntá chrakon sín la í ninkehó kjuanchankíehya sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ntá ntáchro chꞌín Jesús kíxin: ―¿Nkexrí kíxin ntáchro sín kíxin tí Cristo mé tsꞌaxrjeníxin tí chꞌín David? ");
INSERT INTO poeNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","A̱ ntá chꞌín David ikjin chꞌán tí libro Salmos la ntáchro chꞌán kíxin: Ìnchéni Dios ntáche tí Ìnchéni kíxin: “Tjakꞌe tjaná chjina ntihó tséto̱an ");
INSERT INTO poeNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","tsjixinjian kaín xín tí sín nínkakonhan la tsjachahya sin tsꞌe̱to̱an sín kíxin jahvá mé tséto̱an.” ");
INSERT INTO poeNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿Xá nkexrí kíxin Cristo chrókꞌóna itꞌé David, kíxin jehe David kui̱ki̱texín chꞌán Ìnché chꞌán tí Cristo? ―ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Kaín chojni tjejótinhin sín nixje̱he̱ chꞌín Jesús tí sín kꞌuájiko chꞌán ntáchro chꞌán kíxin: ");
INSERT INTO poeNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Chrókóxakonhanrá chrókuankíehyará tí sín maestro tjako tí ley. Tóxrjínhi̱n sín chrókꞌuinkáya sín ka kjínjin la ko tjinkaon sín kíxin kaín chojni chrókjuikosáyehe sín tsoxeta sín ntasin la ko tjeyá sín silla a̱ntsí náxrjón chrókꞌuejóyá sín nkaxenhen ni̱nko la ko tjeyá sín kíxin jína chrókꞌuejó sín tí sátsji sín kia, ");
INSERT INTO poeNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","la ko kja̱xin takitsjehe sín nto̱e tí chojni chjin kꞌán. A̱ ntá kjuixin kjuíchꞌiyehe sín chojni ntá náxrjón nixje̱he̱ sín Dios. A̱ ntá jehe sín a̱ntsí má sinchekjasóte sín Dios kíxin xi̱kaha kjuíchꞌia sín.﻿ ");
INSERT INTO poeNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","A̱ ntá tí nkaxenhen ni̱nko chꞌín Jesús kꞌuíkon chꞌán kíxin tí sín ricó kjui̱ka̱o sín chichaon chrꞌáxenhen sín tí ntacajón tjetóxroyéya chichaon. ");
INSERT INTO poeNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","A̱ ntá kja̱xin kꞌuíkon chꞌán ikjui ijnko tjan kꞌán nòa la ntá jehe tjan chrꞌáxenhen tjan yaá chichaon ntsíntsí. ");
INSERT INTO poeNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ntá ntáchro chꞌín Jesús kíxin: ―La chaxín ntáxrja̱n kíxin tí tjan kꞌán i nòa tjan kjánchó a̱ntsí tjete sínkí tí chichaon kjuanjon tjan kíxin kaín a̱sén tjan kjuanjon tjan, a̱ ntá tí sín kjuanjon nchónhya la náhí. ");
INSERT INTO poeNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kíxin kaín tí chichaon kjuanjon sín la chichaon síxèhe sín. A̱ ntá jehe tjan kjónté nòa tjan na kjuanjon tjan kaín tí chichaon chrókuicháxi̱nhin tjan ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Iso sín tjejótjo sín kíxin nkexrí tsjehe ni̱nko tsíkꞌóna xro̱ náxrjón la ko í so nkehe tsíkjanjon chojni éxí ijnko nkehe chjéhe sín Dios. A̱ ntá chꞌín Jesús ntáchro chꞌán kíxin: ");
INSERT INTO poeNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―A̱ ntá tsi ijnko ya̱on tí ni̱nko tjejokomárá ntihi la tsoxíka. A̱ ntá tso̱kohya ninkehó xro̱ tsꞌejókjen kíchó ínaá ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ntá kjuanchankíhi sín chꞌán kíxin: ―Maestro, ¿nkesá tso̱nhen tíha? ¿Nkexrí tso̱nhen tí tso̱noexínni tí nkehe tso̱nhen? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ntá ntáchro chꞌín Jesús kíxin: ―Chrókóxakonhanrá ti̱to̱éhyará sitꞌáyahará chojni. Nchónhya chojni tsi tsontáchro sín kíxin jehe sín tí Cristo, tsixro sín, la ko tsontáchro sín kíxin: “Ijie mé tsoxiteyá tso̱nhen.” Kjónté xi̱kaha tsontáchro sín la chrókuítekákuenhyará tí jehe sín. ");
INSERT INTO poeNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","A̱ ntá tió tsinhínrá tsontáchro chojni kíxin ó siín kjuanínkaon tjanjo̱nko kíchó sín, kjónté xi̱kaha na̱xa̱ chróchrakonhyará kíxin kaín tíha tꞌichjánxi̱n tsꞌatsínka senó tí na̱xa̱ tsjixixínhya tsꞌitjáyan chjasintajni ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Na̱xa̱ tjechrónka chꞌán ntáchro chꞌán kíxin: ―Ijnko nación la tsjanjo̱nko í jnko nación la ko ijnko chjasin tsjanjo̱nko í jnko chjasin. ");
INSERT INTO poeNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kja̱xin imá tji̱a̱n tsínkí nonte la ko tso̱kjinta la ko tso̱níhi chojni nchónhya chjasin, a̱ ntá nka̱jní nchónhya kjuachrakon jié tsꞌixin tsꞌikon chojni. ");
INSERT INTO poeNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Na̱xa̱ tsꞌatsínkahya tíha la tso̱nínkakonhanrá sín tsotsérá sín sátsjikoará sín tí ni̱nko tsjanchia sín jie̱ la ko sátsjikoará sín tsꞌíkjahará la ko sátsjikoará nkayakon tí sín rey la ko tí sín gobernador kíxin tinkachónkirá ni̱na. ");
INSERT INTO poeNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","A̱ ntá tí ya̱on xi̱kaha tso̱nhen la tsꞌixin kjuachaxin kíxin tso̱chro̱nkará nkexro tinkachónkirá. ");
INSERT INTO poeNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Tóxakuanhyará senó nkexrí tsjate̱herá tí nkehe tsjanchankíhará sín ");
INSERT INTO poeNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","kíxin janhan la tsjánjuan kjuaxrexinkaon jína tsonixjará kíxin nijnko tí sín nínkakonhanrá xitjahya tsontáchro sín kíxin ntoáhya tí nkehe tsjate̱herá. ");
INSERT INTO poeNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Kíxin kjónté itꞌárá la ko kíchuárá la ko tí sín kjéhyará la ko tí sín tjórá jína mé sintakjirá sín. Jehe sín tsꞌóyán sín jnkojínrá. ");
INSERT INTO poeNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Kaín chojni chjasintajni tso̱nínkakonhanrá sín kíxin tinkachónkirá ni̱na. ");
INSERT INTO poeNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Kjánchó xi̱kaha la nijnko ka̱xi̱hi̱ chónta kjárá tsꞌitjáyanhya. ");
INSERT INTO poeNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Tí tsi̱to̱éhyará tinkachónkirá tí janhan la tsochontará kjuachón jnkochríxín. ");
INSERT INTO poeNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’A̱ ntá tió tsꞌikonrá kíxin kuenté chjasin Jerusalén tsíkꞌántatjen sín soldado ntá tso̱noaxínrá kíxin í séhya tsꞌitjáyan tí chjasin a. ");
INSERT INTO poeNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","A̱ ntá tí sín tjejó sín Judea la tꞌichjánxi̱n sátsjixín sín ntiha sátsji sín jna̱. A̱ ntá tí sín siín chjasin Jerusalén kja̱xin tꞌichjánxi̱n sátsjixín sín ntiha la ko ti sin tjejó sín no̱nte̱e sín la í xitjahya tsokjan sín chjasin. ");
INSERT INTO poeNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kíxin tí ya̱on tsꞌixin tsjasóte chojni tsoxiteyá tso̱nhen kaín nkehe nixja xroon itén Dios. ");
INSERT INTO poeNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Nòa tí chojni chjin tjejóyá tí ya̱on a la ko tí sín chónta xjanhnte̱ na̱xa̱ nchekakí sín. Kíxin tí ya̱on a la tsꞌixin kjuatjoté tí chjasin la Dios tsjanjon kjuachaxin kíxin imá tsjasóte chojni ntiha. ");
INSERT INTO poeNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Jnkojínrá tsꞌénxinrá tí siín kjuanínkaon ntiha la ko jnkojínrá tsotsérá sín sátsjikoará sín sinchekjasótiará kaín tí í so nación. A̱ ntá tí sín jehya judío tsji̱xi̱n ókjé nación tsinkátja sín chjasin Jerusalén kíxin Dios mé tsjanjon kjuachaxin iso ya̱on xi̱kaha tso̱nhen. A̱ ntá chrꞌéxi̱n tsontáchro chꞌán kíxin: “La í kohya nkehe tso̱nhen.” ");
INSERT INTO poeNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’A̱ ntá tso̱noaxínrá nkexrí tso̱nhen tí ya̱on la ko nkexrí tso̱nhen nitjó la ko nkexrí tso̱nhen konotsé. A̱ ntá chjasintajni tso̱kohya kjuaxróxin kaín nación la ko tsochrakon chojni kíxin imá tso̱jna̱ nta̱yaon. ");
INSERT INTO poeNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","A̱ ntá chojni la tso̱ti̱nhi̱n sín kíxin tsochrakon sín tsjenka̱yáxin sín nkehe tso̱nhen chjasintajni kíxin kaín tí nkehe sínkáni nka̱jní la tsinkí. ");
INSERT INTO poeNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ntá xi̱kaha tsꞌikon chojni kíxin itsi tí Xje̱en Dios Kꞌóna Chojni itsi chꞌán chríkjan ijnko tjui̱ tsi̱ka̱o chꞌán tí kjuachaxin jié kuènte nkaya nka̱jní. ");
INSERT INTO poeNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","A̱ ntá tió tsoxrankíxin tso̱nhen kaín tíha chrókócháhará chrókjuaya kjárá ntá chróntáchrorá kíxin kjínhya tjen tí nkexro tsaáxinrá ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Kja̱xin kjuíncheyóe̱xin chꞌán í jnko nkehe ntáchro chꞌán kíxin: ―Tjenka̱yáxinrá nkexrí siín tí nta tꞌóna to higo la ko kaín tí í so nta. ");
INSERT INTO poeNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Tió tsꞌikonrá kíxin tinkákꞌayan kahnte̱ tí nta, ntá tso̱noaxínrá kíxin í séhya tsꞌixenhen ncha̱kuen chrin. ");
INSERT INTO poeNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Mé kja̱xin xi̱kaha tió tsꞌikonrá kíxin kaín tí nkehe sítónhen, ntá tso̱noaxínrá kíxin tí kjuachaxin kuènte Dios la ó chjino tjen. ");
INSERT INTO poeNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Mé chaxín ntáxrja̱n kíxin kaín tíhi tso̱nhen senó na̱xa̱ tꞌenhya chojni tjejó jie. ");
INSERT INTO poeNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","A̱ ntá tí nka̱jní la ko tí chjasintajni mé tsꞌitjáyan. A̱ ntá tí nkehe ntáxrja̱n la tsꞌitjáyanhya, tsoxiteyá tíha. ");
INSERT INTO poeNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Chrókóxakonhanrá chrókui̱to̱éhyará kíxin chrókjuichròerá kíxin tí imá chrókjónterá la ko tí chrókókoanrá. Kíxin tí xi̱kaha la ntá titàya̱ tsi tí ya̱on la chrókꞌuejochoénhyará. ");
INSERT INTO poeNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Na mé éxí ijnko trampa xrína̱hya tsꞌikjehe̱ mé xi̱kaha itsi tí ya̱on a, la ko xi̱kaha tso̱nhen kaín chojni siín chjasintajni tí tsꞌejóchóenhya sín. ");
INSERT INTO poeNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Méxra̱ listo chrókꞌuejorá la ko chrónixje̱hérá Dios kaín ya̱on chronóe̱hérá chꞌán kíxin tió tsi kaín tí kjuaxikaon xi̱kaha la ntá tsjinki̱tsará chꞌán tsaárá kíxin ntá tsjachará tso̱chjineherá tí tjen tí Xje̱en Dios Kꞌóna Chojni ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Chꞌín Jesús kjuákꞌekja̱ko̱xi̱n chꞌán tí ni̱nko ntiha jnkojnko ya̱on, a̱ ntá tie la sákjuí chꞌán tí jna̱ nchekꞌin sín Olivo, la ntaha kuíto̱he chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","A̱ ntá kaín chojni kóchjina sín tí ni̱nko jnkojnko nchítjen kíxin tsinhin sín tí nkehe tsochronka chꞌán.﻿ ");
INSERT INTO poeNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ntá kuichjina tí ya̱on kia sine sín tí nio̱tja̱ tjikohya tí xro̱a̱n tꞌánkíxin nio̱tja̱ na mé tí kia nchekꞌin sín pascua. ");
INSERT INTO poeNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ntá tí ncha̱tꞌá tꞌe̱to̱an la ko tí sín maestro tjako tí ley kjuenka̱yáxin sín nkexrí chrókꞌóyán sín tí chꞌín Jesús kíxin chrako̱nhe̱n sín tí chojni chjasin ntiha. ");
INSERT INTO poeNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","A̱ ntá chꞌín Tsochren kꞌuíxenhen a̱sén chꞌín Judas, mé kja̱xin itꞌin chꞌán Iscariote, mé jehe chꞌán ijnko tí teyó tí sín kꞌuájiko chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Tí chꞌín a mé sákjuítsjehe tí sín ncha̱tꞌá tꞌe̱to̱an la ko tí sín tꞌe̱to̱an kuènte ni̱nko, ikjo kíchó sín kíxin nkexrí tsjikaán sín tí chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ntá jehe sín kóchéhe̱ sín la ko ntáchro sín kíxin tsje̱nke̱he sín tí chꞌín Judas. ");
INSERT INTO poeNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ntá kjuáte̱he chꞌán sinchexiteyá chꞌán ntá kjueyá chꞌán nkexrí tsotsé sín tí chꞌín Jesús tí kohya chojni. ");
INSERT INTO poeNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ntá ó kui ya̱on kia sine sín nio̱tja̱ tjikohya tí xro̱a̱n tꞌánkíxin nio̱tja̱, a̱ ntá tꞌichjánxi̱n tsꞌóyán sín tí kolélo sine sín kuènte tí kia pascua. ");
INSERT INTO poeNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","A̱ ntá chꞌín Jesús kꞌue̱tue̱nhen chꞌán tí chꞌín Pedro la ko tí chꞌín Juan kíxin sátsji sín sincheyaxín sín tí nkehe sine sín kuènte tí kia pascua. ");
INSERT INTO poeNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ntá jehe sín kjuanchankíhi sín chꞌán kíxin: ―¿Nketí tjinkávan sincheyaxíxinni? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ntá kjuáte̱he chꞌán kíxin: ―Tió tsꞌixe̱nhenrá chjasin Jerusalén tsoxetará ijnko chojni ntoa yámá ijnko tóa tjiá nta̱. Chréhérá chꞌán sátsjirá tí nchia tsꞌixenhen chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Tsontácherá tí ìnché tí nchia kíxin: “Ntáchro Maestro kíxin: ¿Nketí tjen tí cuarto tsjánjuan kjuachaxin tso̱yaxíxin sineko chꞌán tí sín teyó xriko chꞌán tí ya̱on pascua?” tsixrorá. ");
INSERT INTO poeNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","A̱ ntá jehe chꞌán tsjakohará chꞌán ijnko cuarto jié tí yóxin piso la ntiha siín nkehe tꞌichjánxi̱n, la ntaha si̱ncheyaxíxinrá tí sineni tso̱njín ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","A̱ ntá jehe sín sákjuí sín kꞌuitja sín kaín nkehe éxí tsíchronka chꞌín Jesús. Ntá ntiha kjuíncheyaxíxin sín sine sín kuènte pascua. ");
INSERT INTO poeNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","A̱ ntá kui tí hora, a̱ ntá chꞌín Jesús la ko tí sín kꞌuájiko chꞌán kjuíji sín ntiha kꞌuéjótja̱xi̱n sín tí tjen tí mesa. ");
INSERT INTO poeNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ntá ntáchro chꞌín Jesús kíxin: ―Imá tjínka̱van kíxin tsjasinni kia sine̱kianrá tí ya̱on pascua na̱xa̱ tsꞌénhya janhan. ");
INSERT INTO poeNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ntáxrja̱n kíxin sine̱hya janhan xi̱kaha ínaá tí na̱xa̱ tsoxiteyáhya tíha tió tsi kjuachaxin kuènte Dios ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ntá kuákja chꞌán tí nkehe tjiá ìnté to uva ntá chjéhe chꞌán kjuasáya Dios ntá ntáchro chꞌán kíxin: ―Tákjárá tíhi la itsꞌirá kaín rá ");
INSERT INTO poeNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","kíxin ntáxrja̱n kíxin xíkꞌikianhyará tí ìnté to uva tí na̱xa̱ tihya tí kjuachaxin kuènte Dios ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","A̱ ntá kjuixin ntá kuákja chꞌán tí nio̱tja̱ ntá kjuanchehe chꞌán kjuasáyé Dios, ntá kóchrítꞌo̱ chꞌán chjéhe chꞌán tí jehe sín ntáchro chꞌán kíxin: ―Tíhi mé cuerpo kuènta̱na kíxin tsꞌényákonhanrá. Mé xi̱kaha tsoxráxinkákonxínrá tí janhan ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Kja̱xin xi̱kaha kjuanjon chꞌán tí nkehe tjiá ìnté to uva tió kjuixin kjóne sín la ntáchro chꞌán kíxin: ―Tí nkehe tjiá tí vaso chronkaxín tí nkehe ni̱xin tso̱nhen tsoxiteyá kíxin tí jni̱na tsꞌitjí tso̱tjuáxin tí iji̱árá. ");
INSERT INTO poeNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Tí nkexro sinchekjina mé tjeki̱an tí tjen mesa ntihi. ");
INSERT INTO poeNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Méxra̱ tí Xje̱en Dios Kꞌóna Chojni itsꞌen éxí kꞌuítuenhen; kjánchó nòa tí chꞌín sinchekji chꞌán kíxin tsjasóte chꞌán ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","A̱ ntá jehe sín kjuankíxin sín tjanchankíhi kíchó sín: ―¿Xá nkexro sinchekji chꞌán? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","A̱ ntá jehe sín mé tjo sín kíxin nkexro a̱ntsí tsꞌe̱to̱an. ");
INSERT INTO poeNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","A̱ ntá ntáchro chꞌín Jesús kíxin: ―Tí sín reyes kuènte tí naciones imá tꞌe̱to̱an sín. A̱ ntá tí chojni mé ntáchro sín kíxin tí sín tꞌe̱to̱an la mé chojni chꞌe xra̱ jína. ");
INSERT INTO poeNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","A̱ ntá jahará xi̱kahya chrókjui̱chꞌerá. Íchá jína tí nkexro imá tꞌe̱to̱an chrókꞌóna éxí tí nkexro a̱ntsí ntasoá chróchóxin chrókꞌuítuenhen, na mé tí nkexro tꞌe̱to̱an chrókꞌóna éxí ijnko nkexro chꞌexón xra̱. ");
INSERT INTO poeNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿A̱ ntá nkexro tí a̱ntsí tꞌe̱to̱an, á tí nkexro lámo̱ tjetja̱xi̱n tí tjen mesa ntá sine chꞌán, o̱ á a̱ntsí tꞌe̱to̱an tí nkexro kui̱ka̱o tí nkehe sine chꞌán? Náhí. Tí nkexro tjetja̱xi̱n tí tjen mesa mé a̱ntsí tꞌe̱to̱an chꞌán. Mé xi̱kaha janhan tjénka̱kjánrá éxí ijnko nkexro chꞌexón xra̱ tí janhan. ");
INSERT INTO poeNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Jahará xráxín kꞌuéjóntaxínrá kꞌuíkonrá kaín nkehe náxrjónhya kònna. ");
INSERT INTO poeNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Méxra̱ janhan tsjánjuan kjuachaxin tséto̱anrá éxí chjìna Tꞌaná tí této̱an janhan ");
INSERT INTO poeNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","kíxin sinterá la ko itsꞌirá tí tsjakꞌe mesa kuènta̱na tí tséto̱an janhan nkaya nka̱jní la ko tséto̱anrá si̱nchekito̱exínrá tí iji̱é kaín tí sín kꞌuaxrjeníxin tí teyó xje̱en chꞌín Israel. ");
INSERT INTO poeNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ntá ntáchro Ìnchéni kíxin: ―Simón, Simón, chrókónoha jaha kíxin chꞌín Tsochren kjuanchia chꞌán tí jahará chrókꞌótsjéyehe chꞌán tí jahará éxí noatrigo. ");
INSERT INTO poeNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Kjánchó janhan xrja̱nóa̱ha̱ Tꞌaná kíxin jaha chrókui̱to̱éhya tí tinkachónkia tí janhan. A̱ ntá jaha kjónté tsjásian jie̱, a̱ ntá tsokjan ínaá tsꞌitjáyanhya tinkachónkia tí janhan ntá si̱nchechéhé kíchuárá ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","A̱ ntá ntáchro chꞌín Simón kíxin: ―Ìnchéni, listo tjenni sátsjini tsꞌikjéhe̱koani la jehya tsꞌikjéhe̱ni ó la kja̱xin tsꞌenkoani ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","A̱ ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Pedro, ntáxrja̱n kíxin ijie jaí na̱xa̱ tsjehya kochínto̱a si̱nchemána iníya kíxin chonhya tí janhan, tsixrua ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ntá chꞌín Jesús kjuanchankíhi chꞌán tí jehe sín kíxin: ―Tió kuétua̱nhanrá sákjuírá kjuíkoahyará kabolsa la ko kjuíkoahyará tí nkehe tꞌinka chichaon la ko kjuíkoahyará to̱ka̱te̱ na, ¿á na̱xa̱ tꞌitjáyan ichrén nkehe ní? ―ichro chꞌán. Ntá kjuáte̱he tí jehe sín ntáchro sín kíxin: ―Náhí. Ninkehó nkehe tꞌitjáyanhya ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ntá ntáchro chꞌán kíxin: ―A̱ ntá jie tí nkexro chónta kabolsa la tsakja sátsjiko la ko kja̱xin tí nkehe tꞌinka chichaon. A̱ ntá tí nkexro chóntahya chica espada chrókjuinchekji chꞌán tí ka tꞌinkáya chꞌán kíxin chrókꞌue̱naxín chꞌán ijnko chica. ");
INSERT INTO poeNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ntáxrja̱n kíxin tꞌichjánxi̱n tsoxiteyá tso̱na éxí nixja xroon itén Dios ntáchro kíxin: “Éxí yóhe̱ ijnko chojni kjuasin jie̱ mé xi̱kaha tsꞌikon sín chꞌán.” Mé xi̱kaha kaín nkehe chrónka xroon itén Dios kíxin tso̱na mé tꞌichjánxi̱n tsoxiteyá ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","A̱ ntá jehe sín ntáchro sín kíxin: ―Ìnchéni, ntihi tjejó yaá chica espada ―ichro sín. Ntá kjuáte̱he chꞌán kíxin: ―Kjónté ó táhó la ó ncho̱xon ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ntá chꞌín Jesús sákjui̱xin chꞌán chjasin Jerusalén sákjui̱ chꞌán ijna̱ Olivo kíxin xi̱kaha kuènhen chꞌán kꞌuékjichꞌe chꞌán la koí tí sín kꞌuájiko chꞌán tinkáchréhe̱ sín. ");
INSERT INTO poeNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ntá kjuíji sín ntiha ntá ntáchro chꞌán kíxin: ―Nixje̱hérá Dios kíxin tsjinki̱tsa chꞌán tí jahará kíxin tsjásinhyará jie̱ ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ntá chꞌín Jesús kꞌuaxrjenta chꞌán tí jehe sín sákjuí chꞌán ijnko kjínxi̱n éxí chrókꞌue chojni xro̱. Ntá kjuákꞌexín tochꞌin chꞌán kíxin tsonixje̱he̱ chꞌán Dios. ");
INSERT INTO poeNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ntá ntáchro chꞌán kíxin: ―Itꞌéni, tí tjinkávan chrókjui̱nchekaáni kaín nkehe náxrjónhya chrókꞌuatsínkani. Kjánchó jehya éxí tjinkaonni jeheni chrókónhenni. Náhí. Éxí tjinkávan jaha ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ntá xrína̱hya kꞌuíkon chꞌán itjen ijnko ángel tsíki̱xi̱n nkaya nka̱jní kíxin tsjinki̱tsa chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","A̱ ntá imá tóxakonhen chꞌán, a̱ ntá a̱ntsí fuerte nixje̱he̱ chꞌán Dios, ntá kꞌuíxin chꞌán nta̱chjin éxí yóhe̱ jni̱ xi̱kaha kꞌuítji kꞌuánótjen nonte. ");
INSERT INTO poeNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ntá tió kjuixin nixje̱he̱ chꞌán Dios ntá kꞌuínkatjen chꞌán ntá sákjuí chꞌán tí tjejó tí sín kꞌuájiko chꞌán, ntá kꞌuitjaxín chꞌán kíxin tjejójua tí jehe sín kíxin kjuachahya sín imá tꞌává sín. ");
INSERT INTO poeNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","A̱ ntá ntáchro chꞌán kíxin: ―¿Nkekuènte tjejochrinrá? Tꞌàyará. Nixje̱hérá Dios kíxin tsjinki̱tsará chꞌán kíxin tsjachroehyará chꞌín Tsochren ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","A̱ ntá chꞌín Jesús na̱xa̱ tjenixja chꞌán ntá xrína̱hya kui nchónhya chojni yámá chica. Tí chꞌín itꞌin Judas, ijnko tí teyo sín kꞌuájiko chꞌín Jesús, kuítaón chꞌán nti̱a, ntá kóchjinehe chꞌán tí chꞌín Jesús kíxin sineko chꞌán kochíto. ");
INSERT INTO poeNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","A̱ ntá ntáchro chꞌín Jesús kíxin: ―Judas, ¿á ijnko kochíto ó si̱nchekjíxian tí Xje̱en Dios Kꞌóna Chojni? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","A̱ ntá tí sín tjejóko chꞌín Jesús tió kꞌuíkon sín kíxin xi̱kaha kónhen ntá kjuanchankíhi sín chꞌán kíxin: ―Ìnchéni, ¿á chrókuatéxinni sín chica espada? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","A̱ ntá ijnko tí jehe sín kjuíncheníhi chꞌán ijnko chꞌín chꞌehe xra̱ ncha̱tꞌá tꞌe̱to̱an, kóchrínjin chꞌán ntatsjon chꞌán chjina. ");
INSERT INTO poeNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","A̱ ntá ntáchro chꞌín Jesús kíxin: ―Táhó, ti̱to̱hé, ó tjen ―ichro chꞌán. Ntá chꞌín Jesús itsé chꞌán tí ntatsjon tí chꞌín chꞌe xra̱ a, ntá kjuínchekito̱he chꞌán jína. ");
INSERT INTO poeNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ntá tuénxín chꞌín Jesús ntáche chꞌán tí sín ncha̱tꞌá tꞌe̱to̱an la ko tí sín tꞌe̱to̱an kuènte ni̱nko la ko tí sín táda tꞌe̱to̱an mé tí sín tsíki sátsjiko sín chꞌán ntáchro chꞌán kíxin: ―¿Nkekuènte kꞌuinkakoará chica espada la ko inta éxí chrótse̱rá ijnko xíche̱e? ");
INSERT INTO poeNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","A̱ ntá kaín ya̱on kjuakꞌé janhan kꞌuejóni kjuákoáxinrá tí ni̱nko ntiha la ninkehó tse̱hyará tí janhan. A̱ ntá jie mé tí hora kuèntará ntá kjuacha tí kjuachaxin kuènte sítié ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ntá itsé sín tí chꞌín Jesús kjuínchenteto sín chꞌán sákjuíko sín chꞌán nto̱e ncha̱tꞌá tꞌe̱to̱an. A̱ ntá chꞌín Pedro ikjín tinkáchréhe̱ chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","A̱ ntá tí nta̱sin ntiha kjuaka sín xrohi síxro̱he sín. A̱ ntá chꞌín Pedro kja̱xin kjuákꞌentaxín chꞌán tí tjejó sín ntiha. ");
INSERT INTO poeNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","A̱ ntá ijnko tjachjin chꞌe xra̱ tió kꞌuíkon tjan kíxin koí chꞌín Pedro tjechjíxro̱he chꞌán ntiha ntá komá tjan tí jehe chꞌán ntá ntáchro tjan kíxin: ―Kja̱xin tí chꞌín i xriko tí chꞌín Jesús ―ichro tjan. ");
INSERT INTO poeNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ntá chꞌín Pedro kjuínchemá chꞌán ntáchro chꞌán kíxin: ―¿Nkekuènte xi̱kaha ichrua jaha? Ni chonhya tí nkexro a ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","A̱ ntá a̱ntsíkoá chrꞌéxi̱n ikui í jnko chojni kꞌuíkon tí jehe chꞌán ntá ntáchro kíxin: ―Kja̱xin jaha xríkoa tí nkexro a ―ichro. Ntá chꞌín Pedro ntáchro chꞌán kíxin: ―Náhí, janhya ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ntá éxí ijnko hora chrꞌéxi̱n ntá nixja í jnko chꞌín chénka tí í so sín kíxin: ―Tí chꞌín i chaxín xriko tí chꞌín Jesús kíxin kja̱xin tsíkji̱xi̱n chꞌán estado Galilea ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ntá ntáchro chꞌín Pedro kíxin: ―Nonahya janhan nkehe tí ntáchrua ―ichro chꞌán. Ntá tuénxín na̱xa̱ tjenixja chꞌán ntá xrína̱hya ó tsje kochínto̱a. ");
INSERT INTO poeNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ntá Ìnchéni kuinkátjíá chꞌán komá chꞌán tí chꞌín Pedro. Ntá chꞌín Pedro xraxinkaon chꞌán kíxin xi̱kaha tsíchronka Ìnchéni kíxin: “Na̱xa̱ tsotsjehya kochínto̱a si̱nchemána iníya.” ");
INSERT INTO poeNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ntá chꞌín Pedro sákjuí chꞌán ntója, tsjánka chꞌán xraxinkaon chꞌán tí jie̱ kjuasin chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Tí sín sákjuíko chꞌín Jesús kjuanoá sín chꞌán la ko kjuate sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Kꞌuikjéhe̱ sín ka kon chꞌán ntá kjuate sín chꞌán ntá kjuanchankíhi sín chꞌán kíxin: ―Ijie la tónoha nkexro kjuatia ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","La ko í so nkehe ntáchro sín kꞌuántaxínhi̱n sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","A̱ ntá kóya̱on ncha̱kotjin la kójnkotsé kaín tí sín táda tꞌe̱tue̱nhen tí sín judío, la ko tí ncha̱tꞌá tꞌe̱to̱an, la ko tí sín maestro tjako tí ley la sákjuíko sín tí chꞌín Jesús nkayakon tí sín imá tꞌe̱to̱an. Ntá ntiha kjuanchankíexín sín chꞌán kíxin: ");
INSERT INTO poeNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Ijie la chro̱nka, ¿á jaha tí Cristo? ―ichro sín. Ntá jehe chꞌán kjuáte̱he chꞌán kíxin: ―Tí tsontáxrja̱n kíxin chaxín janhan na tsitekákonhyará. ");
INSERT INTO poeNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","A̱ ntá tí chrókjuánchánkíhará ichrén nkehe la chrókjuáte̱ehyará la ko chrókꞌuatjántahyarána. ");
INSERT INTO poeNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","A̱ ntá jie tí Xje̱en Dios Kꞌóna Chojni mé tsjakꞌetja̱xi̱n tí tja chjina kuènte Dios chónta kaín xín kjuachaxin ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","A̱ ntá tuénxín kaín sín kjuanchankíhi sín chꞌán kíxin: ―¿Á chaxín jaha tí Xje̱en Dios? ―ichro sín. A̱ ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Chaxín janhan xi̱kaha ntáchrorá tí jahará ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ntá kjo sín kíchó sín kíxin: ―¿Nkehe tso̱nhen na̱xa̱ chróchrónka í so chojni? Jeheni kaín ni kuínhinni nkehe kꞌuaxrjexín irꞌva chꞌán ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ntá kaín sín kꞌuínkatjen sín ntá sákjuíko sín tí chꞌín Jesús nkayakon tí chꞌín Pilato. ");
INSERT INTO poeNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","A̱ ntá ntiha kjuankíxin sín tꞌeka sín jie̱ tí jehe chꞌán ntáchro sín kíxin: ―Kꞌuitjani tí nkexro i tjachroe chꞌán chojni nación kuènténi ntáchro chꞌán kíxin chrókjue̱nke̱ehyani tí gobierno romano, la ko kja̱xin ntáchro chꞌán kíxin jehe chꞌán mé Cristo chꞌán, na mé ijnko rey tíha ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","A̱ ntá chꞌín Pilato kjuanchankíhi chꞌán tí chꞌín Jesús ntáchro chꞌán kíxin: ―¿Á jaha tí Rey tꞌe̱tue̱nhen tí sín judío a ní? ―ichro chꞌán. Ntá chꞌín Jesús kjuáte̱he chꞌán ntáchro chꞌán kíxin: ―Chaxín xi̱kaha ntáchrua jaha ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","A̱ ntá chꞌín Pilato ntáche chꞌan tí sín ncha̱tꞌá tꞌe̱to̱an la ko tí chojni tsíki̱ka̱o sín kíxin: ―Tꞌitjáhya nijnko jie̱ chónta tí nkexro i ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","A̱ ntá jehe sín a̱ntsí itsen nixja sín ntáchro sín kíxin: ―Tjachroe chꞌán kaín xín chojni estado Judea kíxin tí nkehe tjako chꞌán. Kjuankíxin chꞌán kjuako chꞌán estado Galilea, a̱ ntá jie ó kui chꞌán ntihi la xi̱kaha tjako chꞌán ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","A̱ ntá kuínhin chꞌín Pilato xi̱kaha ntáchro sín ntá kjuanchankí chꞌán á tí chꞌín i la á Galilea tsíkji̱xi̱n chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","A̱ ntá kjuáte̱he sín kíxin ntaha tsíkji̱xi̱n chꞌán, ntá kꞌue̱to̱an chꞌín Pilato kíxin sátsjiko sín chꞌán tí tjen chꞌín Herodes kíxin jehe chꞌán mé gobernador tí estado Galilea kíxin kja̱xin chꞌán tjen chꞌán chjasin Jerusalén tí ya̱on a. ");
INSERT INTO poeNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","A̱ ntá chꞌín Herodes kꞌuíkon chꞌán kjuíji tí chꞌín Jesús ntá imá kóchéhe̱ chꞌán kíxin isé tjinkaon chꞌán chrókꞌuikon chꞌán tí chꞌín Jesús kíxin tsíkinhin chꞌán chrónka chojni nkexrí tjako chꞌán, ntá tjinkaon chꞌán chrókꞌuikon chꞌán ijnko kjuaxroan chrókjua̱ko̱xi̱n chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Nchónhya nkehe kjuanchankíhi chꞌán tí chꞌín Jesús, kjánchó chꞌín Jesús ninkehó kjuáte̱ehya chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Kja̱xin ntiha kꞌuejó tí sín ncha̱tꞌá tꞌe̱to̱an la ko tí sín maestro tjako tí ley la ntá nchónhya jie̱ kꞌueka sín chꞌán kíxin nínkakonhen sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","A̱ ntá chꞌín Herodes la ko tí sín soldado kuènte chꞌán kjuankíxin sín kjuikosáyehya sín chꞌán la ko kjuanoá sín chꞌán kjuínchekꞌinkáya sín chꞌán ka tjete náxrjón éxí tꞌinkáya tí sín rey. A̱ ntá tuénxín chꞌín Herodes kꞌue̱to̱an chꞌán kíxin sátsji chꞌán ínaá tí tjen chꞌín Pilato. ");
INSERT INTO poeNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","A̱ ntá tí ya̱on a chꞌín Pilato la ko chꞌín Herodes kjuankíxin sín tjuèhe kíchó sín kíxin tí senó la kꞌuénínkakonhen kíchó sín. ");
INSERT INTO poeNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","A̱ ntá chꞌín Pilato kꞌuíye̱he̱ chꞌán tí ncha̱tꞌá tꞌe̱to̱an la ko tí sín gobernador la ko kaín chojni chjasin ntiha kíxin tso̱jnkotsé sín ");
INSERT INTO poeNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ntá ntáche chꞌán sín kíxin: ―Jahará kjuíkua̱nará tí nkexro i ntáchrorá kíxin ntoáhya tja̱ko̱he̱ chꞌán chojni kíxin chrókónínkakonhen sín tí gobierno. Kjánchó janhan kjuánchánkíha̱ chꞌán itsjé nkehe kuínhínrá ntá kꞌuíkonrá kíxin kꞌuítjahya ninkehó tí jie̱ tékará chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","La ko kja̱xin chꞌín Herodes kꞌuitjahya chꞌán tí jie̱ tékará tí chꞌín Jesús ntá chrꞌán chꞌán ínaá ntihi. Ó kꞌuíkonrá kíxin ninkehó jie̱ chóntahya chꞌán chrókꞌuenxín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Si̱ntakjasóte chꞌán ntá chrꞌéxi̱n tsjánjuan kjuachaxin sátsji chꞌán ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","A̱ ntá tí ya̱on kia a la tꞌichjánxi̱n kíxin chꞌín Pilato tsjanjon kjuachaxin sátsji ijnko chojni tjechjina kíxin xi̱kaha kuènhen sín ósé. ");
INSERT INTO poeNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ntá kaín sín kjuankíxin sín kꞌóyako sín ntáchro sín kíxin: ―¡Tí nkexro la náhí! ¡Chꞌín Barrabás mé tꞌa̱tjánta! ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","A̱ ntá chꞌín Barrabás tsíkꞌikjéhe̱ sín chꞌán kíxin jehe chꞌán la ko í so chojni kónínkakonhen sín tí chjasin ntiha la ko tsíkꞌóyán chꞌán chojni. ");
INSERT INTO poeNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","A̱ ntá chꞌín Pilato tjinkaon chꞌán chrókjuanjon chꞌán kjuachaxin sáchrókjui chꞌín Jesús. A̱ ntá xíkjanchankíhi chꞌán tí chojni siín ntiha ínaá. ");
INSERT INTO poeNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Kjánchó jehe sín a̱ntsí má tsen kꞌóyako sín ntáchro sín kíxin: ―¡Tjakéka̱nirá chꞌán ntacruz! ¡Tjakénka̱nirá chꞌán ntacruz! ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Níxin xíkjanchankí chꞌín Pilato ntáchro chꞌán kíxin: ―¿Xá nkehe ntoáhya kjuíchꞌe chꞌán? Janhan la kꞌuítjahya ninkehó jie̱ chónta chꞌán chrókꞌuenxín chꞌán. Si̱ntakjasóte chꞌán la ntá chrꞌéxi̱n tsjánjuan kjuachaxin sátsji chꞌán ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Kjánchó jehe sín a̱ntsí tsen kjuanchia sín ntáchro sín kíxin chrókjuakꞌenkáni chꞌán ntacruz. A̱ ntá kꞌóyako sín la ko kꞌóyako tí sín ncha̱tꞌá tꞌe̱to̱an ntá kjuacha sín kjuanchia sín tí nkehe tso̱nhen. ");
INSERT INTO poeNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","A̱ ntá chꞌín Pilato kjuanjon chꞌán kjuachaxin xi̱kaha tso̱nhen tí nkehe kjuanchia sín. ");
INSERT INTO poeNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","A̱ ntá kjuanjon chꞌín Pilato kjuachaxin sátsji tí chꞌín Barrabás éxí kjuanchia sín, na mé tí chꞌín kꞌuikjéhe̱ sín kíxin kꞌuékje chꞌán kjuanínkaon la ko kꞌuékꞌóyán chꞌán chojni. A̱ ntá chꞌín Pilato kjuanjon chꞌán kjuachaxin kíxin sátsjiko sín tí chꞌín Jesús sinchekjasóte sín chꞌán éxí tjinkaon sín. ");
INSERT INTO poeNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","A̱ ntá tió sákjuíko sín chꞌín Jesús tsja̱kꞌe̱nka̱ni sín chꞌán ntacruz, ntá itsé sín ijnko chꞌín tsíkji̱xi̱n chjasin Cirene itꞌin chꞌán Simón, mé kjui̱xi̱n chꞌán no̱nte̱e chꞌán, ntá kjuínchekamá sín chꞌán tí ntacruz tsjakꞌenkáni chꞌín Jesús la tinkáchréhe̱ chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Kja̱xin chréhe̱ nchónhya chojni ntoa la ko nchónhya chojni chjin chréhe̱ sín tsjánkàma̱ sin chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Kjánchó chꞌín Jesús nkátjíá chꞌán komá chꞌán tí jehe sín kíxin tsjánka sín ntáchro chꞌán kíxin: ―Jahará chojni chjin chjasin Jerusalén, chrótsja̱nkama̱hyará tí janhan. Chrótsja̱nkará kíxin tí nkehe tso̱nhanrá jahará la ko xja̱anrá. ");
INSERT INTO poeNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kíxin itsi ya̱on tsontáchrorá kíxin náxrjón tí sín chóntahya xjan la ko tí sín kjuínchekokjíehya xjan la ko tí sín kjuínchekakíhya ninkehó xjan. ");
INSERT INTO poeNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ntá tsjankíxin chojni tsontáche sín tí jna̱ kíxin tsoxrátja sín la ko tsontáche sín tjo kíxin tsja̱vá sín. ");
INSERT INTO poeNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kjónté tí nta yoa la ó sítónhen kaín tíhi la íchá tió chróxámá tí nta la ¿nkehe tí kaá chrókónhen tí nta tsíxámá? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Kja̱xin sákjuíko sín iyó sín tsíkjasin jie̱ kíxin tsꞌóyánko sín chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ntá tió kjuíji sín tí jna̱ ti̱ki̱texín sín tí jna̱ Nta Hueso Kja Chojni, na mé ntiha kjua̱kꞌe̱nka̱ni sín chꞌín Jesús tí ntacruz la ko kja̱xin tí iyó sín chónta jie̱, la ijnko la tja chꞌán chjina la í jnko la tja chꞌán kjon tjejóyáni sín ntacruz kja̱xin. ");
INSERT INTO poeNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ntá tió kjuixin kjua̱kꞌe̱nka̱ni sín tí chꞌín Jesús tí ntacruz ntá nixje̱he̱ chꞌán tí Itꞌé chꞌán Dios ntáchro chꞌán kíxin: ―Itꞌéni, tónínkákuènhya sín kíxin tí nkehe kjuíchꞌeheni sín kíxin noehya sín nkehe tí kjuíchꞌe sín ―ichro chꞌán. A̱ ntá tí sín soldado kꞌóxika̱ye̱he sín iké chꞌán chꞌexín sín suerte kíxin tso̱noexín sín nkexro tsakja tí ka a. ");
INSERT INTO poeNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Kaín chojni chjasin ntiha tjejótsjehe sín kíxin xi̱kaha sítónhen la ko kja̱xin tí sín tꞌe̱to̱an tjanoá sín tí jehe chꞌán ntáchro sín kíxin: ―Kjuínchekaá chꞌán ókjé chojni, a̱ ntá jie jehe chꞌán chrókjuinchekaá chꞌán a̱sén chꞌán tí chaxín jehe chꞌán tí Cristo tí nkexro tsíkjeyá Dios ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","La ko kja̱xin tí sín soldado kjuanoá sín chꞌán kóchjinehe sín chꞌán kui̱ka̱o sín xranvino náxrjónhya chjéhe sín chꞌán chrókꞌui chꞌán, ");
INSERT INTO poeNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ntáche sín chꞌán kíxin: ―Tí jaha chaxín rey kuènte tí sín judío ntá jahvá chrókjui̱nchekaá a̱sán ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Kja̱xin ntiha ikja tí ntacruz kjua̱kꞌe̱nka̱ni sín ijnko ntachiso ntsí tsíkjin sín nkìva griego la ko nkìva latín la ko nkìva hebreo ntáchro kíxin: “Tíha mé Rey kuènte tí sín judío”, ichro. ");
INSERT INTO poeNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ijnko tí sín chónta jie̱ tjenkáni ntacruz kꞌuántaxínhi̱n chꞌán tí chꞌín Jesús ntáchro chꞌán kíxin: ―Tí jaha chaxín Cristo, jahvá chrókjuínkajian a̱sán, ntá tsjixin ntá chrókjuínkajian tí jeheni ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","A̱ ntá tí chꞌín jnko a kꞌue̱tue̱nhen tí í jnko chꞌín a kíxin tso̱tání chꞌán, ntáchro chꞌán kíxin: ―Ntáchrohya xi̱kaha. ¿Á chrakuenhya Dios kíxin xi̱kaha ichrua kíxin kja̱xin jeheni na ó tjejótjasóteni? ");
INSERT INTO poeNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Yóíni na ncho̱xon tjejótjasóteni tjejótje̱nka̱ni tí jie̱ kjuasinni. A̱ ntá tí nkexro i ninkehó nkehe jínahya kjuíchꞌe chꞌán, la ntá koí chꞌán tjetjasóte chꞌán ―ichro tí chꞌín a. ");
INSERT INTO poeNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ntá ntáchro chꞌán kíxin: ―Jesús, xráxinkávan tí janhan tió tsꞌayéhé kjuachaxin tséto̱an jaha ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Chaxín ntáxrja̱n kíxin ijie jaí tsꞌejóko kíchó ni nkaya nka̱jní ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ntá ó chjina chonkíxin. A̱ ntá kꞌuíxin tie kuenté chjasintajni hasta las tres kónjín. ");
INSERT INTO poeNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ikꞌuén ya̱on, la ko tí ka tꞌinkákuènxín nkaxenhen ni̱nko kꞌuichje jnko̱siné. ");
INSERT INTO poeNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ntá chꞌín Jesús kꞌuèya chꞌán itsen ntáchro chꞌán kíxin: ―Itꞌéni tjen nkaya nka̱jní, jaha tsꞌayéhé a̱sénni ―ichro chꞌán. Xi̱kaha ichro chꞌán ntá kꞌuén chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","A̱ ntá kꞌuíkon tí chꞌín capitán romano kaín xi̱kaha kónhen ntá kjuanchehe chꞌán kjuasáyé Dios ntáchro chꞌán kíxin: ―Chaxín tí nkexro la jína la ninkehó jie̱ chóntahya ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","A̱ ntá kaín tí chojni tsíkójnkotsé ntiha kꞌuíkon sín xi̱kaha kónhen ntá sákjuíxin sín ntiha chrakon sín tjate sín ntakuin sín kíxin xi̱kaha kónhen. ");
INSERT INTO poeNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","A̱ ntá kaín tí sín chóxin chꞌín Jesús la ko kja̱xin tí chojni chjin kꞌuékinkáchónki sín chꞌán tsíkji̱xi̱n sín estado Galilea ikjín tjejó sín tjejótsjehe sín nkerí sítónhen. ");
INSERT INTO poeNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","A̱ ntá ntiha tjen ijnko chꞌín itꞌin José, chjasén chꞌán mé Arimatea estado Judea. Kja̱xin jehe chꞌán ijnko tí sín imá tꞌe̱to̱an kuènte tí sín judío, jehe chꞌán mé ijnko nkexro jína. ");
INSERT INTO poeNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Jehe chꞌán kjuákꞌechónhen chꞌán itsi tí kjuachaxin kuènte Dios. Méxra̱ kóxrjíe̱nhya chꞌán nkexrí kjuíchꞌe tí sín í so tꞌe̱to̱an. ");
INSERT INTO poeNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Méxra̱ sákjuítsjehe chꞌán tí chꞌín Pilato kjuíkjanchia chꞌán tí cuerpo kuènte chꞌín Jesús. A̱ ntá chꞌín Pilato kjuanjon chꞌán kjuachaxin. ");
INSERT INTO poeNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ntá sákjuí sín tsjinkaji̱nxi̱n sín chꞌán ntacruz. Ntá kjuixin kjuinkajin sín chꞌán ntá kjuínchekꞌísímá sín chꞌán ijnko ka jié, ntá sákjuíko sín tsoxravá chꞌán ijnko tòye̱ xráxín tsíkjichꞌéna chꞌín José jehó tjo̱ la ko na̱xa̱ ninkexró tsíxraváhya ntiha. ");
INSERT INTO poeNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Kaín tíha kónhen tí ya̱on viernes kónjín. Tí ya̱on mé tjejóyaxínhin sín kíxin í séhya tsoxrankíxin tí ya̱on tꞌo̱kꞌéhe sín sábado kíxin kohya kjuachaxin sichꞌe sín ninkehó xra̱. ");
INSERT INTO poeNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","A̱ ntá tí chojni chjin nkáchréhe̱ kjui̱koxín chꞌín Jesús estado Galilea kja̱xin sákjuíko sín sákjuítsjehe sín tí tòye̱ tsoxravá chꞌán la ko kꞌuíkon sín jína nkexrí kjuakꞌe sín tí cuerpo kuènte chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","A̱ ntá tió kjan sín tí nchia tjejó sín kꞌóyaxínhin sín kjueyá sín xro̱a̱n xraxé náxrjón itsa nto̱é chꞌán kíxin xi̱kaha kꞌuékinkáchónki tí sín judío. A̱ ntá kꞌo̱kꞌéhe sín tí ya̱on sábado éxí tꞌe̱to̱an tí ley.﻿ ");
INSERT INTO poeNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Tí ya̱on domingo, mé tí ya̱on xrankíxixín semana tí chojni chjin na xíkjan sín ínaá tí tsíxravá chꞌín Jesús sákjuíko sín xro̱a̱n xraxé tsíkꞌe̱na sín. La ko í so chojni chjin sákjuíkotoxi̱n sín. ");
INSERT INTO poeNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ntá ó kjuíji sín ntiha kꞌuíkon sín tí xro̱ tsíkjèxín tí tòye̱ la í xi̱kahya tjen tí sákjuí sín. ");
INSERT INTO poeNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ntá kꞌuíxenhen sín tòye̱ ntá kꞌuitjahya sín cuerpo kuènte Ìnchéni Jesús. ");
INSERT INTO poeNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ntá chrakon sín ntá noehya sín nkehe sichꞌe sín. Ntá xrína̱hya kꞌuíkon sín iyó chojni ntoa tjejóxin to̱té chjinaxón tí tjejó sín, la iké sín la tjáki̱ni tsjehe. ");
INSERT INTO poeNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","A̱ ntá tí chojni chjin kjuínchekꞌisén kja sín tjejótsjehe sín nonte kíxin imá chrakon sín, a̱ ntá tí chojni ntoa ntáchro sín kíxin: ―¿Nkekuènte xrítjéyárá tí nkexro tjechón tí siín tí sín tsíkꞌen? ");
INSERT INTO poeNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Tjenhya chꞌán ntihi la ó xechón chꞌán. Xráxinkáonrá nkehe ntáchro chꞌán tí kjuákꞌe chꞌán estado Galilea ");
INSERT INTO poeNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ntáchro chꞌán kíxin jehe chꞌán tí Xje̱en Dios Kꞌóna Chojni tꞌichjánxi̱n tsotsé tí sín chónta jie̱ tsja̱kꞌe̱nka̱ni sín chꞌán ntacruz la ko tí níxin ya̱on tsoxechón chꞌán ínaá ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","A̱ ntá tí síchjin xráxinkaon sín kíxin nkexrí tsíchronka chꞌín Jesús, ");
INSERT INTO poeNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","a̱ ntá tió kja̱nxi̱n sín tí tsíxravá chꞌán ntá chénka sín tí tejnko tí sín kꞌuékꞌajiko chꞌán la ko kaín tí í so sín. ");
INSERT INTO poeNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","A̱ ntá tí sín sákjuíchenka tí sín apóstol la mé tjan María Magdalena la ko tjan Juana la ko tjan María ìné chꞌín Jacobo la ko tí í so chojni chjin. ");
INSERT INTO poeNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","A̱ ntá tí sín apóstol kuínhin sín éxí ijnko nkehe chaxínhya tí nkehe chrónka tí jehe sín ntá kuítekakonhya sín. ");
INSERT INTO poeNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Kjánchó chꞌín Pedro kꞌuaxrjexín chꞌán nchia tinká chꞌán sákjuítsjehe chꞌán tí tsíkji̱xravá chꞌín Jesús. Ntá kjuíji chꞌán kꞌuíkon chꞌán tí nkaxenhen tòye̱ kꞌuíkon chꞌán kíxin jehó tí ka tsíkꞌísímá chꞌán ntaha tjen. Ntá kjan chꞌán tí nchia tjen chꞌán chrakon chꞌán kíxin xi̱kaha tsíkónhen. ");
INSERT INTO poeNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","A̱ ntá tí ya̱on a iyó sín sákjuí sín ijnko chjasin ntsí itꞌin Emaús, mé kjínxi̱n tejnko kilómetro tí chjasin Jerusalén. ");
INSERT INTO poeNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Tinkákjo sín kíchó sín kíxin kaín tí nkehe tsíkónhen tí chjasin Jerusalén. ");
INSERT INTO poeNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","A̱ ntá nachrohe nixja sín tinkákjo sín, a̱ ntá chꞌín Jesús kóchjinehe chꞌán tí jehe sín sákjuíko sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Kjónté kꞌuíkon sín chꞌán la kjuanjonhya Dios kjuachaxin kíxin chrókjuatso̱an sín tí jehe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","A̱ ntá chꞌín Jesús kjuanchankíhi chꞌán sín ntáchro chꞌán kíxin: ―¿Nkehe tí tinkakjórá tí kꞌuinkará nti̱a? ¿Nkekuènte kíxin tꞌavárá? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","A̱ ntá ijnko tí jehe sín mé itꞌin Cleofas, mé kjuáte̱he chꞌán kíxin: ―Kaín chojni ó nohe sín nkehe tí tsíkónhen chjasin Jerusalén. A̱ ntá jaha kja̱xin kjuákꞌe ntiha la ¿á jahvá noahya nkehe tí tsíkónhen tí ya̱on a ní? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","A̱ ntá jehe chꞌán kjuanchankíhi chꞌán tí jehe sín kíxin: ―¿Xá nkehe tsíkónhen? ―ichro chꞌán. Ntá chénka sín chꞌán kíxin: ―Tí nkehe tsíkónhen chꞌín Jesús tsíkji̱xi̱n chꞌán chjasin Nazaret. Jehe chꞌán na ijnko nkexro kꞌuéchronka itén Dios, na mé kjua̱ko̱xi̱n chꞌán kjuachaxin kuènte nkaya nka̱jní kaín tí nkehe kꞌuékjichꞌe chꞌán la ko kaín nkehe kꞌuéntáchro chꞌán mé xi̱kaha kꞌuíkon Dios la ko kꞌuíkon tí chojni. ");
INSERT INTO poeNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","A̱ ntá tí ncha̱tꞌá tꞌe̱to̱an la ko tí sín gobierno kjuínchekꞌáyéhe̱ sín chꞌán kíxin itsꞌen chꞌán la tsja̱kꞌe̱nka̱ni sín chꞌán ntacruz. ");
INSERT INTO poeNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","A̱ ntá jeheni kꞌuejóchónhenni kíxin jehe chꞌán chrókjuinchekaá chꞌán tí sín Israel. A̱ ntá jie ó chónta iní ya̱on xi̱kaha kónhen. ");
INSERT INTO poeNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","A̱ ntá iso chojni chjin kja̱xin kꞌuékinkáchónki sín chꞌán kjuínchechrakon sín tí jeheni kíxin jehe sín tsíkji̱tsjehe sín tí tsíxravá chꞌán imá nchítjén ");
INSERT INTO poeNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","la mé tsíkꞌitjahya sín tí cuerpo kuènte chꞌán, ntá kjan sín chrónka sín kíxin tsíkꞌikon sín iyó sín ángel chrónka sín kíxin chꞌín Jesús la tjechón chꞌán, ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ntá tuénxín iyó tí sín kꞌuájikoni kja̱xin sákjui̱tsjehe sín tí tsíxravá chꞌán la kuikꞌitja sín éxí chrónka tí chojni chjin, kjánchó chꞌín Jesús la kꞌuíkonhya sín ―ichro tí yaá sín a. ");
INSERT INTO poeNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Lo̱nti̱rá jahará la tjokahya kuítekáonrá tí nkehe kꞌuéchronka tí sín profeta kꞌuéjó ósé. ");
INSERT INTO poeNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Xá tꞌichjánxi̱nhya chrókjuasóte Cristo senó ntá chrókꞌuáyéhe̱ chꞌán tí kjuachaxin chrókꞌue̱to̱an chꞌán? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ntá kjuankíxin chꞌán chronkaxín chꞌán nkexrí tꞌaxrjexín kaín tí nkehe nixja xroon itén Dios kíxin nkehe tso̱nhen tí jehe chꞌán la mé kjuankíxixín chꞌán chronkaxín chꞌán tí nkehe tsíkjin chꞌín Moisés la ko kjuintaxín chronkaxín chꞌán tí nkehe tsíkjin tí í so sín profeta. ");
INSERT INTO poeNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ntá kjuíji sín tí chjasin ntsí a, a̱ ntá chꞌín Jesús tsjehe chꞌán éxí na̱xa̱ sáchrókjui chꞌán kjín. ");
INSERT INTO poeNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","A̱ ntá jehe sín mé chronóe̱he̱ sín chꞌán kíxin ntahó chrókuito̱he chꞌán, ntáchro sín kíxin: ―Tito̱ha tsꞌejóni ntihi kíxin ntá ó kóntó la ó tsꞌixitie ―ichro sín. Ntá chꞌín Jesús la kꞌuíxenhen chꞌán nchia kíxin tsito̱eko sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","A̱ ntá tjejótja̱xi̱nko sín chꞌán tí tjen tí ntamesa, ntá ntiha xranjon nkehe sine sín, ntá kuákja chꞌán tí nio̱tja̱ la kjuanchehe chꞌán kjuasáyé Dios la kóchrítꞌo̱ chꞌán kuákja tí jehe sín. ");
INSERT INTO poeNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ntá tuénxín xraxinkaon sín ntá kjuátso̱an sín tí jehe chꞌán. Ntá tuénxín kꞌuitjáyankoá chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ntá jehe sín itjo sín kíchó sín ntáchro sín kíxin: ―¿Á chaxínhya chéhe̱ a̱sénni tí kui̱ka̱oni chꞌán nti̱a kíxin chronkaxín chꞌán nkexrí tꞌaxrjexín tí itén Dios tsíkjin sín ósé? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ntá tuénxín kꞌuínkatjen sín kjan sín chjasin Jerusalén. A̱ ntá ntaha kꞌuitja sín tí tejnko sín jnkoko̱á tjejó sín la ko tí í so sín. ");
INSERT INTO poeNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","A̱ ntá tí sín ntiha chrónka sín kíxin: ―Chaxín tjechón Ìnchéni la mé chꞌín Simón tsíkꞌikon chꞌán tí jehe chꞌán ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ntá jehe sín kja̱xin chrónka sín nkehe tsíkónhen tí nti̱a sákjuí sín kíxin nkexrí kjuátso̱anxín sín tí chꞌín Jesús tí kóchrítꞌo̱ chꞌán nio̱tja̱ kjuanjon chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","A̱ ntá jehe sín na̱xa̱ tjejótjo sín kaín tí nkehe tsíkónhen, a̱ ntá xrína̱hya chꞌín Jesús kjuákꞌe jnko̱siné tí tjejó sín, nixje̱he̱ chꞌán tí jehe sín ntáchro chꞌán kíxin: ―¿Á kjuaxróxin tjejorá? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","A̱ ntá jehe sín la imá chrakon sín kjuenka̱yáxin sín kíxin kꞌuíkon sín ijnko xri̱nto̱e chojni. ―Áchꞌe kjuachani ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","A̱ ntá ntáche chꞌín Jesús tí jehe sín kíxin: ―¿Nkekuènte chrakonrá? ¿Nkekuènte xi̱kaha tjenka̱yáxin a̱sánrá? ");
INSERT INTO poeNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Tsjehérá tjaná la ko to̱tená kíxin chaxín janhan. Itse̱rána la ko komárána, kíxin ijnko xri̱nto̱e chojni chóntahya nto la ko chóntahya hueso éxí tꞌikonrá kíxin chonta janhan ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","A̱ ntá xi̱kaha ichro chꞌán ntá kjuako chꞌán itja chꞌán la ko to̱té chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ntá kjónté xi̱kaha kꞌuíkon sín la na̱xa̱ kuítekakonhya sín kíxin chéhe̱ sín la ko chrakon sín. A̱ ntá chꞌín Jesús ntáchro chꞌán kíxin: ―¿Á chontará ichrén nkehe sineni ntihi ní? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ntá chjéhe sín chꞌán itꞌo̱ koche tsíchjántaón xrohi la ko ijnko tꞌo̱ katjé kotsje̱nta tjiá tsje̱n. ");
INSERT INTO poeNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","A̱ ntá jehe chꞌán kuákja chꞌán kjóne chꞌán kꞌuíkonxín kon sín. ");
INSERT INTO poeNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Na ntá ntáchro chꞌán kíxin: ―Kaín tí nkehe kꞌuátsínka tí janhan mé kꞌuéntáxrja̱n tí na̱xa̱ kꞌuékꞌejóni senó; kíxin tꞌichjánxi̱n tsoxiteyá kaín tí nkehe chrónka tí ley tsíkjin chꞌín Moisés la ko tí nkehe tsíkjin tí sín profeta la ko tí nkehe ntáchro tí salmo kíxin nkexrí tso̱na janhan ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ntá kjuanjon chꞌán kjuachaxin kíxin tsienxín sín tí xroon itén Dios tsíkjin sín ósé. ");
INSERT INTO poeNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ntá chénka chꞌán sín kíxin: ―Mé xi̱kaha nixja tí xroon itén Dios kíxin tí Cristo la tꞌichjánxi̱n tsꞌen, la níxin ya̱on tꞌichjánxi̱n tsoxechón chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","A̱ ntá tꞌichjánxi̱n tsja̱ko̱xi̱n sín ihni̱é chꞌán tsjankíxixín sín chjasin Jerusalén la ko chrókuinhin chojni kuenté chjasintajni kíxin chrókuíto̱he sín iji̱é sín chrókuitekaon sín tí jehe chꞌán kíxin jehe chꞌán mé chrókjuincheyaon tí iji̱é sín. ");
INSERT INTO poeNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","A̱ ntá jahará mé tso̱chro̱nka̱xínrá kíxin xi̱kaha kꞌuíkonrá kaín tíha. ");
INSERT INTO poeNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ntá tsochrꞌan janhan tí Ncha̱kuen Tꞌaná éxí tsíntáchro chꞌán. Kjánchó chjasin Jerusalén ntahó tito̱hará tsoxiteyájia tsꞌayéhérá kjuachaxin tsi̱xi̱n nkaya nka̱jní. ");
INSERT INTO poeNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","A̱ ntá chꞌín Jesús sákjuíko sín chꞌán kꞌuaxrjexín sín chjasin Jerusalén sákjuí sín chjasin Betania. Ntá kjuàya̱ chꞌán tja chꞌán kjuíncheyaon chꞌán tí jehe sín. ");
INSERT INTO poeNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","A̱ ntá kjuixin kjuíncheyaon chꞌán sín ntá kꞌuaxrjenta chꞌán tí jehe sín ntá sákjui̱ chꞌán nkaya nka̱jní. ");
INSERT INTO poeNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","A̱ ntá jehe sín kꞌuíkon sín xíkaha, a̱ ntá xraxinkaon sín chꞌán, ntá kjan sín chjasin Jerusalén chéhe̱ sín. ");
INSERT INTO poeNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","A̱ ntá kaín ya̱on tjejó sín nkaxenhen ni̱nko tjanchehe sín Dios kjuasáya. Amén.");
INSERT INTO poeNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","12A̱ ntá tí xrankíxixín na̱xa̱ kꞌónahya tí chjasintajni a na mé xráxín tjen tí nkexro chrónkaxín nkexrí tjen Dios, na mé Cristo tíha, na mé kjuákꞌeko Dios na mé kja̱xin Dios tíha. ");
INSERT INTO poeNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Tí xrankíxixín na mé tí nkexro xráxín kjuákꞌeko Dios ");
INSERT INTO poeNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","la ko kjuachaxin kuènte chꞌán na mé kꞌónaxín kaín xín nkehe siín jie. A̱ ntá kohya ninkehó nkehe kꞌónakoá, na mé kaín xín nkehe siín na mé kꞌónaxín tí kjuachaxin kuènte chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Jehe chꞌán na mé kjuanjon kjuachaxin kaín nkehe síchón siín chjasintajni la ko jehe chꞌán mé xrohi tꞌinkaséyanxínhin jnkojnko nti̱e chojni chjasintajni. ");
INSERT INTO poeNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Tí xrohi a mé tꞌinkaséyanxín tí sítié a. A̱ ntá tí sítié a mé tjinkaon chrókꞌókꞌa̱nka tí xrohi a, kjánchó kjuachahya kꞌókꞌa̱nka. ");
INSERT INTO poeNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ntá kjuákꞌe ijnko chojni kꞌue̱tue̱nhen Dios kui mé itꞌin chꞌán Juan. ");
INSERT INTO poeNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ikui chꞌán kjuákꞌechrónka chꞌán nkexrínchi tjen tí xrohi tꞌinkaséyanxín chjasintajni kíxin kaín xín chojni chrókuitekaon sín tí tjechrónka chꞌán a. ");
INSERT INTO poeNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","A̱ ntá tí chꞌín Juan la jehya tí xrohi a. Ó kꞌuítuenhón chꞌán kui chꞌán kíxin tsochrónka chꞌán nkerí kuènte tí xrohi a. ");
INSERT INTO poeNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","A̱ ntá tí xrohi chaxín tꞌinkaséyanxínhin kaín xín chojni na ó tsíki chꞌán chjasintajni jie. ");
INSERT INTO poeNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Kjuákꞌe chꞌán chjasintajni na mé Dios tsíkjichꞌénaxín chꞌán chjasintajni tí kjuachaxin kuènte tí nkexro a na kjónté kjuákꞌe chꞌán chjasintajni na na̱xa̱ kjuátso̱anhya sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ikui chꞌán tí tjejó tí sín judío kꞌuaxrjeníxin chꞌán, kjánchó kuítekakuenhya sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","A̱ ntá tí sín kuítekaon sín chꞌán mé kꞌuáyéhe̱ sín kjuachaxin kíxin tsꞌóna sín xje̱en Dios. ");
INSERT INTO poeNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ntá yóe̱hya tsꞌaxrjeníxin sín itꞌé sín chjasintajni ntihyó la ko yóe̱hya ijnko itꞌé chrókjuenka̱yáxin chꞌán chrókjuichꞌéna chꞌán ijnko xjan. Náhí. Dios mé kjueyá chꞌán nkexro tsꞌóna xje̱en chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","A̱ ntá tí nkexro chrónkaxín nkexrí tjen Dios na mé kꞌóna ijnko chojni chjasintajni kjuákꞌenkákjanni chꞌán na mé imá kꞌuétjuèhé chꞌán chojni chjasintajni la ko imá ntoá chrónka chꞌán. Kuayeni kꞌuíkonni kíxin imá tꞌe̱to̱an chꞌán kíxin jehe chꞌán mé tí jnkoko̱áxón Xje̱en Itꞌéni tjen nkaya nka̱jní na mé xi̱kaha imá tꞌe̱to̱an chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Chꞌín Juan mé chrónka chꞌán nkexrí tjen tí nkexro a. Ntáchro chꞌán kíxin: ―Senó kꞌuékjákohárá kíxin chrꞌéxi̱n tsi tí nkexro a, na mé a̱ntsí má tꞌe̱to̱an chꞌán, a̱ ntá janhan la náhí kíxin tí janhan na̱xa̱ kohyana la tí jehe chꞌán la ó xráxín tjen chꞌán ―mé xi̱kaha chrónka chꞌín Juan. ");
INSERT INTO poeNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Kaínni ó kꞌuáyéhe̱ni tí kjuachaxin jié tjetjanjon chꞌán la ko a̱ntsí má tjencheyaonni chꞌán la ko tjencheyaonni chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Dios mé tsíkꞌe̱tue̱nhen chꞌín Moisés kíxin tsokjin chꞌán tí ley. A̱ ntá Ìnchéni Jesucristo mé kjua̱ko̱xi̱n chꞌán kíxin nkexrí imá tjuèhé Dios tí chojni chjasintajni. A̱ ntá kaín nkehe chrónka chꞌán mé a̱ntsí ntoá. ");
INSERT INTO poeNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Kohya ninkexró chjasintajni kꞌuíkon sín Dios a. A̱ ntá tí jnkoko̱áxón Xje̱en chꞌán na mé xráxín jnkoko̱á tjenka̱yáxinko Itꞌé chꞌán la mé jehe chꞌán mé ó kjuínchekónoheni chꞌán nkexrí tjen Itꞌé chꞌán nkaya nka̱jní. ");
INSERT INTO poeNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Iso tí sín judío kꞌuéjó sín chjasin Jerusalén na ntá ichrꞌán sín iso chojni ncha̱tꞌá la ko iso tí sín levita, ikui sín kuinixje̱he̱ sín tí chꞌin Juan kjuanchankíhi sín chꞌán kíxin: ―¿Nkexro tí jaha? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ntá kjuínchemáhya chꞌán, ntáchro chꞌán kíxin: ―Náhí. Jehya janhan tí Cristo ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ntá xíkjanchankíhi sín chꞌán ínaá, ntáchro sín kíxin: ―¿Xá nkexro tí jaha? ¿Á jaha tí profeta Elías? ―ichro sín. Ntá chꞌín Juan la xíkjate̱he chꞌán ntáchro chꞌán kíxin: ―Náhí. Jehya janhan Elías ―ichro chꞌán. Ntá xíkjanchankíhi sín chꞌán ínaá kíxin: ―¿Á jaha tí nkexro tjejóchónhenni itsi tsochrónka itén Dios? ―ichro sín. Na ntá ntáchro chꞌín Juan ínaá kíxin: ―Náhí. Janhya ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ntá kjuanchankíhi sín chꞌán ínaá kíxin: ―¿Ntá nkexro jaha? Tꞌichjánxi̱n tso̱noheni tsochénkani tí sín ichrꞌánni ikuini. ¿Nkehe tso̱chro̱nka kíxin nkexro tí jaha? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ntá kjuáte̱he chꞌín Juan ntáchro chꞌán kíxin: ―Janhan mé tí nkexro tsjakꞌe nte̱je̱ tsꞌèya tso̱xrja̱nka kíxin: “Takitje̱hérá ijnko nti̱a ntoí tsi̱xi̱n Ìnchéni” ―mé xi̱kaha ichro chꞌán kjuáte̱exín chꞌán itén chꞌín Isaías kꞌuéchrónka xroon itén Dios ósé. ");
INSERT INTO poeNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","A̱ ntá tí sín fariseo mé tsíchrꞌán tí jehe sín kuikjanchankíhi sín tí chꞌín Juan. ");
INSERT INTO poeNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","A̱ ntá kjuanchankíhi sín chꞌán kíxin: ―Ó ntáchrua kíxin jahya tí Cristo tí nkexro tsaáxin chojni la ko jahya tí Elías, la ko jahya nijnko tí nkexro kꞌuéchrónka itén Dios ósé. ¿A̱ ntá nkekuènté tíki̱te chojni tí xi̱kaha? ―mé ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ntá ntáchro chꞌín Juan kíxin: ―Janhan na mé ìnta̱ ó tíki̱texián chojni. Ó ntihi tjenkákjan ijnko nkexro na̱xa̱ tjátso̱anhyará. ");
INSERT INTO poeNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Jehe chꞌán mé tsi chꞌán nóton tí janhan. A̱ ntá a̱ntsí má tꞌe̱to̱an chꞌán, a̱ ntá janhan na kénhyó. A̱ ntá tósuàna chrókjuasínta̱nka̱ tí correa to̱ka̱té chꞌán ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Kaín tíha mé tsíkónhen tí chjasin itꞌin Betábara tí nó tji̱to̱xi̱n ya̱on tóhe tí nta̱río Jordán tí kjuákꞌe chꞌín Juan kui̱ki̱te chojni. ");
INSERT INTO poeNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","A̱ ntá tí ya̱on chrꞌéxi̱n mé kꞌuíkon chꞌín Juan kíxin ó tjekui chꞌín Jesús. Ntá nixje̱he̱ chꞌán tí sín tsíkóchjina ntáchro chꞌán kíxin: ―Tsjehérá tí nkexro tjekui mé tí Kolélo kuènte Dios jehe chꞌán. Tíha mé tsjìinxín iji̱é chojni chjasintajni. ");
INSERT INTO poeNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Janhan mé kꞌuéxrja̱nka kíxin tí iton tí janhan mé tsichréhe̱ ijnko nkexro a̱ntsí tꞌe̱to̱an, a̱ ntá janhan la kénhyó této̱an kíxin na̱xa̱ kohyana na jehe chꞌán la ó xráxín tjen chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Kja̱xin janhan na̱xa̱ chonhya nkexro tíha. A̱ ntá xra̱ ó kꞌuinka kjuakꞌé kuíki̱texián chojni ìnta̱ kíxin tí chojni nación Israel mé chrókjuátso̱anxín sín chꞌán ―ichro chꞌín Juan ");
INSERT INTO poeNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Kjuintaxín ntáchro chꞌín Juan kíxin: ―Ó kꞌuíkua̱n kíxin tí Ncha̱kuen Dios mé kꞌuínkaji̱nxi̱n nkaya nka̱jní na éxí yóhe̱ ijnko kontóá kꞌuínkajin la ko kjuákꞌe va ntoí tí tjen chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","A̱ ntá janhan kja̱xin na̱xa̱ chonhya nkexro tíha. A̱ ntá tí nkexro kꞌue̱tua̱nna kíxin tsjakꞌé tsíki̱texián chojni ìnta̱ mé tsíchrónka chꞌán kíxin tí Ncha̱kuen Dios mé tsꞌinkajin tsjakꞌe ntoí tí tjen ijnko chojni na mé tsjatso̱anxián janhan kíxin tí nkexro a mé tsi̱ki̱texín chꞌán Ncha̱kuen Dios chojni. ");
INSERT INTO poeNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","A̱ ntá janhan jie mé ó kꞌuíkonxín kua̱n kíxin xi̱kaha kónhen tí jehe chꞌán, a̱ ntá xrja̱nkaxián kíxin táha mé Xje̱en Dios tíha ―mé xi̱kaha chrónka chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Tí ya̱on chrꞌéxi̱n kjuákꞌe chꞌín Juan la ko iyó tí sín kꞌuájiko chꞌán, ");
INSERT INTO poeNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","a̱ ntá xrína̱hya kꞌuíkon chꞌán kꞌuátsínka chꞌín Jesús. Ntá ntáchro chꞌín Juan kíxin: ―Tsjehérá tí nkexro i mé tí Kolélo kuènte Dios ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ntá kuínhin tí yóí sín kꞌuájiko chꞌín Juan na ntá sákjuíchréhe̱ sín tí chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ntá kuinkátjíá chꞌín Jesús kꞌuíkon chꞌán kíxin tinkáchréhe̱ sín ntá kjuanchankíhi chꞌán sín kíxin: ―¿Xá nkehe xritjéyárá? ―ichro chꞌán. Ntá ntáchro sín kíxin: ―Maestro, ¿xá nketí nchia itjen? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ntá kjuáte̱he chꞌán ntáchro chꞌán kíxin: ―Ìntá sátsjini tsꞌikonrá nketí ―ichro chꞌán. Ntá kuinkáchréhe̱ sín chꞌán kꞌuíkon sín nketí nchia kjuákꞌe chꞌán ntá kꞌuéjóko sín chꞌán kuenté tí kónjín kíxin kjuíji sín ntiha como las cuatro kónjín. ");
INSERT INTO poeNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","A̱ ntá yóí sín tsíkinhin sín tí chrónka chꞌín Juan ntá sákjuíchréhe̱ sín tí chꞌín Jesús na mé ijnko mé itꞌin Andrés. Jehe chꞌán chónta chꞌán ijnko sa̱vé mé itꞌin Simón Pedro. ");
INSERT INTO poeNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Na ntá tuénxín tí chꞌín Andrés sákjuíkjeyá chꞌán tí sa̱vé chꞌán Simón. Ntá chénka chꞌán tí sa̱vé chꞌán kíxin: ―Ó kꞌuitjani tí nkexro Mesías ―ichro chꞌán. Tíha mé tꞌaxrjexín kíxin Cristo. ");
INSERT INTO poeNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","A̱ ntá chꞌín Andrés mé kui̱ka̱o chꞌán tí sa̱vé chꞌán Simón tí tjen chꞌín Jesús. Ntá chꞌín Jesús mé komá chꞌán tí chꞌín Simón ntáchro chꞌán kíxin: ―Jaha mé Simón, itꞌá mé itꞌin Jonás. Ntá jie si̱ntakꞌian Cefas ―ichro chꞌán. A̱ ntá tí palabra Cefas la ko tí palabra Pedro na mé yóí mé tꞌaxrjexín kíxin ixro̱ tíha. ");
INSERT INTO poeNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","A̱ ntá tí ya̱on chrꞌéxi̱n mé sáchrókjui chꞌín Jesús tí estado Galilea. Ntá kꞌuitja chꞌán tí chꞌín Felipe, na ntá ntáche chꞌán kíxin: ―Chréhé tí janhan ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","A̱ ntá tí chꞌín Felipe mé chjasén chꞌán mé itꞌín Betsaida tí chjasén chꞌín Andrés la ko chꞌín Pedro. ");
INSERT INTO poeNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ntá tí chꞌín Felipe mé sákjuíkjeyá chꞌán tí chꞌín Natanael na ntá chénka chꞌán kíxin: ―Ó kꞌuitjani tí nkexro tsi éxí kꞌuéchrónka tí chꞌín Moisés tí tsíkjin chꞌán tí xroon chrónka tí nkehe kꞌue̱to̱an Dios. Kja̱xin tí sín kꞌuéchrónka tí itén Dios chrꞌéxi̱n mé kꞌuéchrónka sín kíxin itsi tí nkexro a. Na ntá ó kꞌuitjani chꞌán na mé jehe chꞌán mé itꞌin Jesús, la itꞌé mé itꞌin José, la mé chjasén chꞌán mé Nazaret ―ichro chꞌín Felipe. ");
INSERT INTO poeNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","A̱ ntá ntáchro chꞌín Natanael kíxin: ―¿Xá kjuánchí má chrókójína tí nkehe chrókꞌuaxrjexín tí chjasin Nazaret a? ―ichro chꞌán. Ntá kjuáte̱he chꞌín Felipe ntáchro chꞌán kíxin: ―Xrákiá tsꞌikuan ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Na ntá kꞌuíkon chꞌín Jesús kíxin ó kui tinkákóchjina chꞌín Natanael, na ntáchro chꞌán kíxin: ―Ó kui ijnko chꞌín chaxín israelita la kohya nijnko kjuachꞌia xriko chꞌán ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Na ntá ntáchro chꞌín Natanael kjuanchankíhi chꞌán tí chꞌín Jesús kíxin: ―¿Nkexrí kíxin tjátso̱anna? ―ichro chꞌán. Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Na̱xa̱ nixja̱ahya tí chꞌín Felipe mé kꞌuíkua̱n tí jaha tjenka̱nkiá tí nta tꞌóna to higo ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Na ntá ntáchro chꞌín Natanael kíxin: ―Maestro, jaha la chaxín tí Xje̱en Dios tjen nkaya nka̱jní tsétue̱nhén tí nación Israel ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Jehya tí nkehe ntáxrja̱n kꞌuíkua̱n tjenka̱nkiá nta tꞌóna to higo, jehya táhó tsítekákonxian. Náhí. Chrꞌéxi̱n xiki í jnko kjuaxroan a̱ntsí má jié tsꞌíkuan, a̱ ntá tíhi la kénhyó ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Kja̱xin ntáchro chꞌín Jesús kíxin: ―Ijnko nkehe ntoá tso̱xrja̱nka kíxin tsoxitje̱he̱ tí nka̱jní tsꞌikonrá itsi itsjé tí sín ángel kuènte Dios mé tsꞌi̱tꞌótjen la ko tsꞌinkajin tí tjén janhan mé tí Xje̱en Dios Kꞌóna Chojni ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","A̱ ntá iní ya̱on chrꞌéxi̱n ntá kóte̱he ijnko chꞌín chjasin Caná estado Galilea. Mé koí tí ìné chꞌín Jesús tsíkꞌíye̱he̱ sín tjan la ntiha tjen tjan koí. ");
INSERT INTO poeNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Kja̱xin tsíkꞌíye̱he̱ sín tí chꞌín Jesús la ko tí sín kꞌuájiko chꞌán kíxin sátsji sín tí tsíkóte̱he sín ntiha. ");
INSERT INTO poeNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ntá ó tsíkꞌanke̱he̱ sín tí xranvino ikꞌuí sín na ntá tí ìné chꞌín Jesús mé ntáche tjan tí jehe chꞌán kíxin: ―Ó tsíkꞌànka̱ xranvino itsꞌi sín ―ichro tjan. ");
INSERT INTO poeNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ntá ntáchro chꞌín Jesús kíxin: ―Naná, ¿nkehe tso̱nhen chro̱nka? Na̱xa̱ kjuixrakáhya tí ya̱on tsjásian kjuaxroan ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","A̱ ntá tí ìné chꞌán na mé ntáche tjan tí sín chꞌe xra̱ kíxin: ―Tí chrén nkehe chrókꞌue̱tua̱nhanrá chꞌán chrókjui̱nchexiteyárá ―ichro tjan. ");
INSERT INTO poeNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","A̱ ntá siín ntiha injon chi̱ tsíkꞌóna xro̱ na mé tíha tjiá nta̱ tꞌònti sín kíxin xi̱kaha mé tsꞌaxrjehe tí jie̱ chónta sín koí, mé xi̱kaha kuinkáchónki tí sín judío. Na mé jnkojnko chi̱ mé tjacha tikia ochenta litro la o̱ ciento litro nta̱. ");
INSERT INTO poeNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ntá kꞌue̱tue̱nhen chꞌín Jesús tí sín chꞌe xra̱ kíxin: ―Tíki̱a̱rá nta̱ kaín tí chi̱ a tso̱kaón ―ichro chꞌán. Ntá kjuínchexiteyá sín kjuínchekaón sín nta̱ jnkojnko tí chi̱ a. ");
INSERT INTO poeNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","A̱ ntá ntáche chꞌín Jesús tí jehe sín ínaá kíxin: ―Tákjá intsí nta̱ tjiá chi̱ tjikuehé tí chꞌín tꞌe̱to̱an tí kia a ―ichro chꞌán. Ntá xi̱kaha kjuíchꞌe sín kjuínchexiteyá sín. ");
INSERT INTO poeNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","A̱ ntá tí chꞌín tꞌe̱to̱an tí kia a mé tsjexín chꞌán tí nta̱ tsíkꞌóna xranvino kjónté noehya chꞌán nketí kui̱xi̱n tí xran a. Jehó tí sín chꞌe xra̱ kui̱ka̱o sín mé nohe sín kíxin jehe sín mé tsíkakitsje sín nta̱. Ntá tí chꞌín tꞌe̱to̱an mé kꞌuíye̱he̱ chꞌán tí chꞌín tsíkóte̱he. ");
INSERT INTO poeNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ntáche chꞌán kíxin: ―Xráxín tí sín tjasin kia la senó tí xranvino náxrjón tjanjon sín na tió chrókꞌuihya tí sín tsíkóchjina na ntá tjanjon sín tí xranvino náxrjónhya. A̱ ntá jaha la náhí. Senó kjuakéchji̱na tí xranvino a̱ntsí má náxrjón, a̱ ntá tí jie tjetjánjuan jaha ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Tí kjuaxroan a kjuíchꞌe chꞌín Jesús chjasin Caná estado Galilea mé tí kjuaxroan sa̱oxín kjuasin chꞌán mé kjua̱ko̱xi̱n chꞌán nkexrí imá jié tí kjuachaxin kuènte chꞌán, a̱ ntá tí sín kꞌuájiko chꞌán mé kuítekaon sín tí jehe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ntá ó kꞌuátsínka kia, a̱ ntá sákjuí chꞌán chjasin Capernaum, sákjuíko chꞌán ìné chꞌán la ko kíchó chꞌán la ko tí sín kꞌuájiko chꞌán, kóxrjenhen sín ntiha iso ya̱on. ");
INSERT INTO poeNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","A̱ ntá ó kuichjina tí ya̱on kia kuènte pascua kuènte tí sín judío. Ntá chꞌín Jesús sákjui̱ chꞌán chjasin Jerusalén. ");
INSERT INTO poeNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ntá nkaxenhen tí ni̱nko jié ntiha kꞌuíkon chꞌán tí sín nchekjixin koxinta la ko kolélo la ko kontóá. La ko ntiha kja̱xin tjejótja̱xi̱n tí sín tjinkíxixín chichaon. ");
INSERT INTO poeNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ntá chꞌín Jesús mé kuákja chꞌán ihno̱ tsíxehe̱ sín ntiha, kjuíchꞌéna chꞌán ijnko chikoté, ntá kuakitsjexín chꞌán sín nkaxenhen ni̱nko kaín xín sín la ko tí kolélo la ko tí koxinta. Na ntá tí ntamesa tjinkítóxixín sín tí chichaon mé kótéka chꞌán tsíkjaminkí xènjin tí chichaon a. ");
INSERT INTO poeNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ntá kꞌue̱tue̱nhen chꞌán tí sín nchekji tí kontóá a kíxin: ―Takítsjerá kaín tí nkehe a. Chꞌénahyará ijnko ntasin tí nto̱e Tꞌaná ntihi ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ntá xráxinkaon tí sín kꞌuájiko chꞌán ti nkehe tsíkjin sín ósé kíxin: “Éxí xrohi kꞌuákjen a̱senná nínka̱van kíxin tí nto̱a tjikosáyehya sín.” ");
INSERT INTO poeNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ntá tí sín judío mé kjuanchankíhi sín chꞌán kíxin: ―¿Xá nkerí kjuaxroan tsjásixián tsjáko̱xian nketí kjuachaxin chonta kíxin xi̱kaha kjui̱chꞌe tíhi? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ntá kjuáte̱he chꞌín Jesús kíxin: ―Tí tsꞌoxíkará tí ni̱nko i ntá iníkoá ya̱on la ó si̱tꞌána ni̱xin tsjakꞌe ínaá ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Na ntá ntáchro tí sín judío a kíxin: ―Cuarenta y seis nánó kꞌuéjó sín kjuíchꞌéna sín tí ni̱nko i, a̱ ntá jaha ntáchrua kíxin iní ya̱on koá si̱chꞌéna ínaá, ichrua ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Kjánchó kienxínhya sín kíxin tí ni̱nko ntáchro chꞌín Jesús la tí cuerpo kuènte chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ntá tió kjuixin xechón chꞌán ntá xráxinkaon tí sín kꞌuájiko chꞌán kíxin xi̱kaha tsíchrónka chꞌán, ntá kuítekaon sín tí xroon itén Dios tsíkjin sín ósé la ko tí nkehe tsíchrónka chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Tió kjuákꞌe chꞌín Jesús chjasin Jerusalén tí kia pascua, a̱ ntá itsjé chojni kuinkáchónki sín tí jehe chꞌán kíxin ó kꞌuíkon sín tí kjuaxroan kjuasin chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Kjánchó chꞌín Jesús la kuítekakuenhya chꞌán tí jehe sín kíxin jehe chꞌán la ó nohe chꞌán jína nkexrí tónhen a̱sén jnkojnko chojni ");
INSERT INTO poeNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","a̱ ntá tꞌichjánxi̱enhya chꞌán kíxin ninkexró chróchenka chꞌán nkexrí tjenka̱yáxin chojni kíxin ó kónohe chꞌán kaín nkehe tónhen a̱sén kaín xín chojni.﻿ ");
INSERT INTO poeNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Kjuákꞌe ijnko chꞌán kuènte tí sín fariseo a mé itꞌin chꞌán Nicodemo. Jehe chꞌán mé ijnko nkexro imá tjetoan kuènte tí sín Israel. ");
INSERT INTO poeNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","A̱ ntá ijnko tie kjuíchréhe̱ chꞌán tí chꞌín Jesús a nixje̱he̱ chꞌán ntáchro chꞌán kíxin: ―Maestro, kónoheni kíxin Itꞌéni tjen nkaya nka̱jní mé tsíchrꞌán kꞌuinka tsjákohéni kíxin tí jehya Dios chrókjuakꞌekoa la xitjahya chrókjuásian kjuaxroan jié ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―A̱ ntá tso̱tjo̱nka ijnko nkehe imá tjetoan. Tí nkexro tsokjíehya ni̱xien mé xitjahya tsꞌikon tí kjuachaxin tsꞌe̱to̱an Dios ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","A̱ ntá chꞌín Nicodemo kjuanchankí chꞌán ntáchro chꞌán kíxin: ―Ó tádana, ¿nkexrí chrókokjína ni̱xien? ¿Á chrókꞌuíxa̱nha̱n tse̱e na̱ná ínaá ntá chrókokjína ni̱xien ní? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ntá kjuáte̱he chꞌín Jesús ntáchro kíxin: ―Ntá tso̱tjo̱nka ijnko nkehe imá tjetoan. Jehó tí sín tsíkokjíexín nta̱ la ko kja̱xin tsíkokjíexín Ncha̱kuen Dios mé tsꞌáyéhe̱ sín tí kjuachaxin kuènte Dios. ");
INSERT INTO poeNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Tió ijnko xjan tsꞌaxrjeníxin chojni na mé tí xjan mé chojni ó. A̱ ntá tí Ncha̱kuen Dios tsokjíexín ni̱xien ijnko chojni na ntá tsꞌáyéhe̱ sín tí Ncha̱kuen Dios a. ");
INSERT INTO poeNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Chrakonhya tí nkehe xrja̱nka kíxin “Kaín chojni tꞌichjánxi̱n tsokjíhi ni̱xien.” ");
INSERT INTO poeNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Éxí yóhe̱ tí tinhín tí chjéhe xri̱nto̱ ntá noahya nketí kui̱xi̱n tí xri̱nto̱ la ko noahya nketí sátsji na mé kja̱xin xi̱kaha kónhen kaín tí nkexro tsíkokjíexín Ncha̱kuen Dios ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ntá xíkjanchankí chꞌín Nicodemo ínaá kíxin: ―¿Nkekuènté kíxin xi̱kaha chrókónhen? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―¿Jaha ijnko maestro imá tꞌe̱to̱an tí nación Israel ntá na̱xa̱ tiénxinhya tí nkehe ní? ");
INSERT INTO poeNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Chaxín tjétjo̱nka tí nkehe nòna la ko tí nkehe kꞌuíkua̱n ntá títekákonnahya jaha. ");
INSERT INTO poeNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Tí nkehe tjétjo̱nka la kuènte chjasintajni ó ntá kjónté la títekákonnahya jaha. ¿Ntá nkexrí chrókuítekávan tí chrótjo̱nka nkehe kuènte nkaya nka̱jní? ");
INSERT INTO poeNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Kohya í jnko nkexro kꞌui̱tꞌótjen chjasin nkaya nka̱jní. Jehó tí Xje̱en Dios Kꞌóna Chojni mé kjuákꞌe chjasin nkaya nka̱jní la ko ntiha kui̱xi̱n chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Éxí yóhe̱ chꞌín Moisés tió kꞌuíxin sín tí nte̱je̱, a̱ ntá Dios mé kꞌue̱to̱an kíxin sinchekjano̱ya chꞌán ijnko konche tsja̱kꞌe̱nka̱ni chꞌán ijnko nta, ntá xi̱kaha kjuíchꞌe chꞌán kjua̱kꞌe̱nka̱ni chꞌán tí konche tí nta a komá sín tí konche ntá kuaá sín kꞌuénhya sín, mé xi̱kaha tso̱nhen tí Xje̱en Dios Kꞌóna Chojni mé tꞌichjánxi̱n kíxin tsjakꞌenkáni chꞌán ijnko ntacruz ");
INSERT INTO poeNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","kíxin mé xi̱kaha kaín nkexro tsinkáchónki tí jehe chꞌán mé tsaá sín tsochónta sín kjuachón jnkochríxín. ");
INSERT INTO poeNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Kíxin Dios mé imá tjuèhe chꞌán chojni chjasintajni ntá kjuanjon chꞌán jnkoko̱áxón Xje̱en chꞌán, kíxin ntá jnkojnko chojni tsinkáchónki tí Xje̱en chꞌán mé tsꞌitjáyanhya sín tsochónta sín kjuachón jnkochríxín. ");
INSERT INTO poeNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Chrꞌánhya Dios tí Xje̱en chꞌán chjasintajni kíxin sinchekjasóte chojni kíxin tí jie̱ kjuasin sín. Náhí. Ó jehí ichrꞌán chꞌán tí Xje̱en chꞌán chjasintajni kíxin sinchekaá chojni. ");
INSERT INTO poeNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Na mé tí sín tsitekaon tí Xje̱en Dios la tsjasótehya sín. A ntá tí sín titekakuenhya sín na mé ó kjuixin kjuínchekito̱exín Dios tí iji̱é sín tsjasóte sín kíxin titekakuenhya sín tí jnkoko̱áxón Xje̱en Dios. ");
INSERT INTO poeNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Na mé xi̱kaha Dios sinchekjasóte sín jnkochríxín kíxin ó kui tí nkexro tꞌinkaséyanxín chjasintajni na kjónté ntá a̱ntsí má tóxrjínhi̱n sín tí sítié a. A̱ ntá tí tꞌinkaséyan la náhí kíxin na̱xa̱ tóxrjínhi̱n sín tí nkehe jínahya tjejóchꞌe sín. ");
INSERT INTO poeNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kaín tí sín tjejóchꞌe nkehe jínahya na mé tóxrjíe̱nhya sín tꞌinkaséyan chrókóchjinehya sín kíxin tso̱noxínhya tí nkehe jínahya tjejóchꞌe sín. ");
INSERT INTO poeNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","A̱ ntá tí sín tjejóchꞌe sín tí jína a na mé chéhe̱ sín tóchjinehe sín tí tꞌinkaséyan kuènte Dios kíxin tso̱noxín tí nkehe chꞌe sín kíxin ntá kaín xín chojni mé tsjatso̱an sín kíxin tjejóchꞌe sín tí nkehe tóxrjínhi̱n Dios. ");
INSERT INTO poeNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Na ntá chrꞌéxi̱n chꞌín Jesús la ko tí sín kꞌuájiko chꞌán na sákjuí sín estado Judea. Ntaha kꞌuéjóko sín chꞌán kui̱ki̱te chꞌán chojni. ");
INSERT INTO poeNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Kja̱xin chꞌín Juan kjuákꞌe chꞌán chjasin Enón chjino tí chjasin Salim na mé ntiha kjuákꞌe kui̱ki̱te chꞌán chojni kíxin ntiha mé yeé nta̱ siín. Na ntá nkáki sín kuíkite sín. ");
INSERT INTO poeNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Mé xi̱kaha kónhen na̱xa̱ kjuákꞌechjinahya chꞌín Juan. ");
INSERT INTO poeNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ntá tí sín kꞌuájiko chꞌín Juan la ko tí sín judío mé kjua̱cha̱xi̱n kíchó sín kíxin nkexrí íchá jína chrókótjuáxin chojni, ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","A̱ ntá tí sín kꞌuájiko chꞌín Juan sákjuítsjehe sín chꞌán chénka sín chꞌán kíxin: ―Maestro, tí chꞌín kjuákꞌekoa tóhe nta̱río Jordán, na mé tí nkexro tsíchro̱nka kuènte chꞌán, la mé itjen chꞌán ti̱ki̱te chꞌán chojni la ko kaín xín chojni mé tjichréhe̱ sín chꞌán ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Na ntá ntáchro chꞌín Juan kixin: ―Tí chrókjuanjonhya Dios kjuachaxin ntá chrokjuahya chrókꞌuáyéhe̱ chojni. ");
INSERT INTO poeNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ó kuínhínrá ntoá kꞌuéxrja̱nka senó kíxin janhya tí Cristo. Náhí. Janhan ó kuítuannuá kuíto̱nxián nti̱a tso̱xrja̱nka kíxin ó tsi chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Éxí yóhe̱ ijnko chꞌín tso̱te̱he na mé jehe chꞌán mé tsꞌáyéhe̱ chꞌán tí ichjién chꞌán. A̱ ntá tí chꞌín chóxin chꞌán mé chéhe̱ a̱sén chꞌán tjetinhin chꞌán tjenixja tí chꞌín tsꞌáyéhe̱ ichjién a. Mé xi̱kaha janhan imá chàna kíxin xi̱kaha sítónhen kíxin itsjé chojni sítóchjinehe sín tí chꞌín Jesús tsinhin sín nkehe tí tjenixja chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","A̱ ntá jehe chꞌán tꞌichjánxi̱n a̱ntsí tsꞌe̱to̱an chꞌán. A̱ ntá janhan la kénhyó ―mé chro chꞌín Juan. ");
INSERT INTO poeNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Tí nkexro kui̱xi̱n nkaya nka̱jní mé kaín nkehe tꞌe̱tue̱nhen chꞌán. A̱ ntá ijnko chojni kuènte chjasintajni ó mé chrónka kuènte chjasintajni ó. A̱ ntá tí nkexro kui̱xi̱n nkaya nka̱jní mé kaín nkehe tꞌe̱tue̱nhen chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Jehe chꞌán mé chrónka chꞌán tí nkehe tsíkꞌikon chꞌán la ko tí nkehe tsíkinhin chꞌán. Kjánchó kohya chojni titekaon sín tí nkehe chrónka chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","A̱ ntá jnkojín nkexro titekaon sín tí nkehe chrónka chꞌán na mé xi̱kaha tja̱ko̱xi̱n chꞌán jie kíxin chaxín ntoá chrónka Dios ");
INSERT INTO poeNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","kíxin tí nkexro ichrꞌán Dios mé nixja itén Dios kíxin jehya intsíkoá tí Ncha̱kuen Dios kꞌuáyéhe̱ chꞌán. Náhí. ");
INSERT INTO poeNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Itꞌéni Dios mé tjuèhe chꞌán tí Xje̱en chꞌán na mé xi̱kaha ó tsíchjéhe chꞌán kjuachaxin kíxin kaín xín nkehe tsꞌe̱tue̱nhen chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","A̱ ntá tí nkexro tsitekaon tí Xje̱en Dios mé xi̱kaha tsochónta sín tí kjuachón jnkochríxín. A̱ ntá tí sín titekakuenhya sín tí Xje̱en Dios mé tsochóntahya sín tí kjuachón jnkochríxín xi̱kaha. Tí sín a mé Dios sinchekjasóte sín jnkochríxín.﻿ ");
INSERT INTO poeNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","A̱ ntá tí sín fariseo mé kónohe sín kíxin a̱ntsí tsjé chojni chréhe̱ sín tí chꞌín Jesús kui̱ki̱te chꞌán sín na ntá tí chojni chréhe̱ sín tí chꞌín Juan la kánhyó tsjé sín. ");
INSERT INTO poeNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Kjánchó jehya chꞌín Jesús kui̱ki̱te chꞌán chojni. Méxra̱ tí sín kꞌuájiko chꞌán mé kui̱ki̱te sín chojni. ");
INSERT INTO poeNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","A̱ ntá tió kónohe chꞌín Jesús kíxin xi̱kaha tsíkinhin tí sín fariseo ntá kꞌuaxrjexín chꞌán tí estado Judea xíkjan chꞌán estado Galilea ínaá. ");
INSERT INTO poeNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ntá tꞌichjánxi̱n tsꞌátsínka chꞌán estado Samaria. ");
INSERT INTO poeNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","A̱ ntá kjuíji chꞌán ijnko chjasin mé itꞌin Sicar kuènte estado Samaria, mé chjino tí nonte tsíkjincheki̱to̱nhe̱n chꞌín Jacob tí xje̱en chꞌán José. ");
INSERT INTO poeNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","La ó chjino tjen tí tòye̱ takitsje chojni ìnta̱ mé itꞌin Ìnté Jacob. Na ntá ó chonkíxin kjui sín ntiha. Méxra̱ tí chꞌín Jesús la imá kóxrjé chꞌán kíxin imá kjín tí nti̱a kjui̱xi̱n chꞌán ntá kjuákꞌetja̱xi̱n chꞌán chrínta tí tòye̱ takitsje sín ìnta̱. ");
INSERT INTO poeNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Ntahó kuíto̱he chꞌán. A̱ ntá tí sín kꞌuájiko chꞌán sákjuí sín tí chjasin chjinaxón sákjuíkꞌe̱na sín nkehe sineko sín chꞌán. Ntá séhyó ikui ijnko tjan kuènte estado Samaria ikui tjan tsakitsje tjan ìnta̱. Ntá ntáchro tí chꞌín Jesús kíxin: ―Chjìna intsí nta̱ itsꞌia ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","A̱ ntá tí tjan samaritana mé kjuanchankíhi tjan tí chꞌín Jesús kíxin: ―¿Nkekuènté kíxin jaha ijnko chojni judío mé chrókjuanchana nta̱ kíxin janhan ijnko chojni samaritana? ―mé chro tí tjan a. (Mé xi̱kaha kjuanchankí tjan kíxin tí sín judío mé ninkehó tꞌikonhya tí sín samaritano.) ");
INSERT INTO poeNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Na ntá ntáchro chꞌín Jesús kíxin: ―Chrókónoha tí nkehe tjanjon Dios la ko chrókjuatso̱an jaha nkexro tí tjetjanchaha nta̱ ntá chrókjuanchana nta̱, ntá chrótja̱ha tí nta̱ tjechón chaxín ―ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Na ntá ntáchro tí tjan a kíxin: ―¿Ntá nkexrí kíxin xraahya jaha ninkehó nkehe tsakítsjeyá nta̱ kíxin tí tòye̱ i la imá ni̱nka? ¿Ntá nkexrí tsochjìna tí nta̱ tjechón tjimé? ");
INSERT INTO poeNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Tí nkexro kꞌuaxrjeníxinni mé Jacob mé kuíto̱eheni tí tòye̱ tjiá nta̱ ntihi la ko kja̱xin ikꞌuí chꞌán tí nta̱ la ko kja̱xin ikꞌuí tí xje̱en chꞌán la ko tí iko kuènte chꞌán. ¿A̱ ntá xá jaha la xá a̱ntsí má tjetoan jaha, a̱ ntá jehe chꞌán la kénhyó ní? ―mé kjuanchankíhi tjan tí chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Na ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Tí sín itꞌi sín tí nta̱ ntihi tí tòye̱ i nánta̱xón itsꞌen sín nta̱ ínaá. ");
INSERT INTO poeNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","A̱ ntá tí sín itsꞌi sín tí nta̱ si̱ntaki̱to̱nha̱n sín mé í tsꞌenhya sín nta̱ ínaá. Tí nta̱ si̱ntaki̱to̱nha̱n sín mé tsꞌóna éxí yóhe̱ ijnko nta̱ tsꞌaxrje nkaya a̱sén sín mé tsinkákjanjon tí kjuachón tsochónta sín jnkochríxín ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ntá ntáchro tí tjan a ínaá kíxin: ―Chjìna tí nta̱, a̱ ntá tsꞌénhyana nta̱ ínaá la ko tsꞌinkahya ntihi tsakítsje nta̱ ―ichro tjan. ");
INSERT INTO poeNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ntá kꞌue̱to̱an chꞌín Jesús kíxin: ―Sátjia tjíkꞌi̱ye̱hé xìá ntá tsꞌinkará ntihi ínaá ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ntá ntáchro tjan kíxin: ―Chontahya xìná ―ichro tjan. Ntá ntáchro chꞌín Jesús kíxin: ―Chaxín ntáchrua kíxin chontahya jaha xìá. ");
INSERT INTO poeNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Kꞌuéchonta jaha inꞌó xìá, a̱ ntá tí chꞌín chonta jie jehya xìá. Na mé chaxín tí nkehe ntáchrua kíxin chontahya xìá chaxín ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Na ntá kuínhin tjan tíha ntá ntáchro tjan kíxin: ―Tꞌíkua̱n kíxin jaha ijnko nkexro chrónka itén Dios. ");
INSERT INTO poeNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","A̱ ntá tí sín kꞌuaxrjeníxinni kꞌuíxin ósé mé kꞌuéxraxinkakonxín sín Dios tí jna̱ ntihi. Kjánchó jahará chojni judío mé ntáchrorá kíxin tí ni̱nko jié chjasin Jerusalén kaín ni chróxraxinkakonxínni Dios ―ichro tjan. ");
INSERT INTO poeNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ntá chꞌín Jesús ntáche chꞌán tjan kíxin: ―Títekávan kíxin tjetsi tí hora a tsoxráxinkákonxínhyará Itꞌéni Dios tí jna̱ ntihi la ko tsoxráxinkákonxínhyará chꞌán chjasin Jerusalén kja̱xin. ");
INSERT INTO poeNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Jahará chojni samaritano chonhyará tí nkexro xráxinkáonrá. Ntá kaín ni chojnini judío mé chóxinni tí nkexro xráxinkaonni. Méxra̱ tí nkexro tsjakjìinhin chojni tí jie̱ yámá sín mé tsꞌaxrjeníxin tí sín judío. ");
INSERT INTO poeNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ntá tjetsi tí hora a na mé tí jie ó kui tí hora a na tí sín chaxín tjinkaon sín chróxraxinkaon sín Itꞌéni la mé a̱sén sín ó tsoxraxinkakonxín sín Itꞌéni Dios. Dios mé tóxrjínhi̱n chꞌán kíxin chojni xi̱kaha chrókjuichꞌe sín chróxraxinkakonxín sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Jehe Dios na mé ncha̱kuen ó, a̱ ntá tí sín chróxraxinkaon sín chꞌán na mé tꞌichjánxi̱n kíxin a̱sén sín ó tsoxraxinkakonxín sín chꞌán ―mé xi̱kaha chrónka chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","A̱ ntá ntáchro tí tjan a kíxin: ―Ó nòna kíxin itsi tí nkexro Mesías, tí nkexro a mé Cristo. Tió tsi chꞌán ntá tsja̱ko̱he̱ni chꞌán kaín xín nkehe ―ichro tjan. ");
INSERT INTO poeNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ntá ntáchro chꞌín Jesús kíxin: ―Tí nkexro a la mé janhan tjétjuá jie ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Na ntá tí sín kꞌuájiko chꞌán mé kja̱nxi̱n sín tí chjasin a, ntá chrakon sín kꞌuíkon sín kíxin tjenixje̱he̱ chꞌán ijnko chojni chjin. Kjánchó nijnko sín kjuanchankíehya sín chꞌán kíxin nkehe tjinkaon chꞌán na nkekuènté nixje̱he̱ chꞌán tí tjan a. ");
INSERT INTO poeNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","A̱ ntá tí tjan mé kjuakꞌe tjan tí tóa nonte ntá sákjuí tjan tí chjasin ntaha ntáche tjan tí sín ntaha kíxin: ");
INSERT INTO poeNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Ìntárá sátsjitsjeheni ijnko chꞌín chrónka chꞌán kaín xín nkehe kjui̱tꞌa tí senó a. ¿Xá chrókójehya tí nkexro i Cristo? ―ichro tjan. ");
INSERT INTO poeNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Na ntá tí chojni a mé xrákua̱xi̱n sín tí chjasin a ntá kuitsjehe sín tí chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Na̱xa̱ tihya sín nachrohe tí sín kꞌuájiko chꞌán mé chrónóe̱he̱ sín chꞌán ntáchro sín kíxin: ―Maestro, kja̱xian chrókjónte nkehe ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Kjánchó ntáchro chꞌán kíxin: ―Ó chonta janhan nkehe siné. Jahará la kjá na̱xa̱ noahyará ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","A̱ ntá tí sín kꞌuájiko chꞌán mé kjuanchankíhi sín kíchó sín kíxin: ―¿Xá jnkojín sín tsíki̱ka̱o sín nkehe kjóne chꞌán? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Kjánchó ntáchro chꞌín Jesús kíxin: ―Éxí yóhe̱ chrókjoné nkehe mé tí si̱tꞌa tí xra̱ la ko tsjixinna tí xra̱ kuènte tí nkexro chrꞌánna kꞌuinka. ");
INSERT INTO poeNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ntáchrorá kíxin: “Noó nitjó na̱xa̱ tꞌitjáyan tsochónhenni ntá tsotjáni noatrigo”, ichrorá. Kjánchó ntáxrja̱n kíxin chrótsjehérá tí no a kíxin ó tsícha la ko ó tinkáxámá kíxin ó jína chrótjáni. ");
INSERT INTO poeNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Tí sín chꞌe xra̱ tjá sín mé tsoxenkehe sín. A̱ ntá tí nkehe tjá sín mé tsꞌáyéhe̱ kjuachón jnkochríxín. Ntá tí sín kꞌue̱nka̱ sín nonte la ko tí sín tjá sín jnkokón tso̱chéhe̱ sín. ");
INSERT INTO poeNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Mé xi̱kaha tsoxiteyá tí nkehe ntáchro sín kíxin: “Ijnko nkexro mé tꞌe̱nka̱ noa, a̱ ntá ókjé sín tsotjá sín tí noa a”, ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","A̱ ntá janhan ichrꞌan tí jahará tso̱tja̱rá ijnko nonte tsíkꞌénka̱hyará. Na mé ókjé sín kjuíchꞌe sín xra̱ ntá jahará tsjachará tí xra̱ kjuíchꞌe tí sín a ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","A̱ ntá itsjé tí sín samaritano kuènte tí chjasin ntiha mé kjuankíxin kuinkáchónki sín tí jehe chꞌán kíxin xi̱kaha chrónka tjan kíxin jehe chꞌán ó chrónka chꞌán kaín xín nkehe kjuíchꞌe tjan tí senó a. ");
INSERT INTO poeNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","A̱ ntá tió kuínhin sín tí nkehe chrónka tjan ntá kui sín tí tjen chꞌín Jesús ntá chrónóe̱he̱ sín chꞌán kíxin tsito̱he chꞌán ntiha. Ntá kuíto̱he chꞌán ntiha iyó ya̱on. ");
INSERT INTO poeNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ntá itsjé sín kja̱xin kuinkáchónki sín chꞌán kíxin tí nkehe kuínhin sín nixja chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ntá ntáche sín tí tjan a kíxin: ―Ntá jie jehya jehó tí nkehe chro̱nka kuítekaonni. Náhí. Tí jie ó kuínhinni nixja chꞌán ntá kónoheni kíxin jehe chꞌán chaxín tí nkexro Cristo sinchekaá tí chojni chjasintajni ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","A̱ ntá kꞌuátsínka iyó ya̱on ntá chꞌín Jesús kꞌuaxrjexín chꞌán estado Samaria ntá sákjuí chꞌán nó estado Galilea. ");
INSERT INTO poeNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","A̱ ntá jehe chꞌán tsíntáchro chꞌán kíxin tí nkexro chrónka itén Dios la tí chjasén sín mé tjikosáyehya sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Kjánchó tió kjuíji chꞌán tí estado Galilea na mé kꞌuáyéhe̱ sín chꞌán la ko kjuikosáyehe sín chꞌán jína kíxin kja̱xin sín sátsíkji̱ sín tí kia pascua chjasin Jerusalén tsíkꞌikon sín kaín tí kjuaxroan kjuasixín chꞌán tí kia ntiha. ");
INSERT INTO poeNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ntá xíkjan chꞌín Jesús ínaá chjasin Caná, estado Galilea, na mé ntiha tsíkjinchekjaminca chꞌán tí nta̱ tí xranvino a. Ntaha mé kjuákꞌe ijnko chꞌín chꞌehe xra̱ gobierno. A̱ ntá níhi tí xje̱en chꞌán ntoa itjen chjasin Capernaum. ");
INSERT INTO poeNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ntá kuínhin tí chꞌín chꞌehe xra̱ gobierno kíxin itjen chꞌín Jesús tí estado Galilea tsíki̱xi̱n chꞌán estado Judea ntá sákjuíchréhe̱ chꞌán chrónóe̱he̱ chꞌán tí chꞌín Jesús kíxin sáchrókjui chꞌín Jesús nto̱e chꞌán sinchekito̱he jína tí xje̱en chꞌán ó tjetꞌen xjan. ");
INSERT INTO poeNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ntá ntáchro chꞌín Jesús kíxin: ―Kja̱ tí jahará tí chrókꞌuikonhyará kjuaxroan chrókjuásian la chrókuinkachónkihyará tí janhan ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ntá chrónòa tí chꞌín chꞌehe xra̱ gobierno ntáchro chꞌán kíxin: ―¿Á chrókójínahya sáchrókjui̱ni nto̱na jaí kíxin xja̱nna ó tjetꞌen? ―ichro tí chꞌín a. ");
INSERT INTO poeNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Ikjan sátjia nto̱a kíxin tí xja̱an na ó jína tjen jie ―ichro chꞌán. Ntá kuítekaon chꞌán nkerí ichro chꞌín Jesús ntá sákjuí chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","A̱ ntá kjuíji chꞌán chjino nto̱e chꞌán ntá xrína̱hya tí sín chꞌehe sín chꞌán xra̱ kjuíxinhin sín nti̱a chrónka sín kíxin: ―Xja̱an la ó jína tjen ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ntá kjuanchankíhi chꞌán sín kíxin nkehora kjuankíxin kuíto̱he xjan jína, na ntá chrónka sín kíxin: ―Ijna la una kónjín mé kjuìin tí sóa ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ntá kónohe tí itꞌé xjan kíxin xi̱kaha tí hora tsíntáchro chꞌín Jesús kíxin tí xje̱en chꞌán na ó jína tjen. A̱ ntá jehe chꞌán la ko kaín tí sín siín nto̱e chꞌán mé kuinkáchónki sín tí chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Tíha mé tí yóxin kjuaxroan kjuasin chꞌín Jesús tió kui̱xi̱n chꞌán estado Judea ikjan chꞌán estado Galilea. ");
INSERT INTO poeNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ntá chrꞌéxi̱n tí sín judío mé kjuasin sín ijnko kia na ntá chꞌín Jesús xíkjan chꞌán chjasin Jerusalén ínaá. ");
INSERT INTO poeNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","A̱ ntá ntaha chjino tí ntója tꞌixenxín kolélo chjasin mé tjen ijnko pila tóxroyéya nta̱ mé nkìva hebreo tí nta̱ mé itꞌin Betesda. A̱ ntá chrínta tí pila siín inꞌó cuarto ntsíntsí. ");
INSERT INTO poeNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ntaha tjejótsínka nchónhya chojni níhi, iso sín tꞌikonhya la ko iso sín xitjahya tji la ko iso sín tsíkꞌen to̱té. Tjejóchónhen sín kíxin nkehora tsinkí nta̱ ");
INSERT INTO poeNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","kíxin nánta̱xón kꞌuínkajin ijnko ángel kjuiánkí nta̱ kjuínchekinkí nta̱. A̱ ntá tí nkexro senó tsjiánkí nta̱ mé tsito̱he jína kjónté cualquiera chin chónta. ");
INSERT INTO poeNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","A̱ ntá ntaha kjuákꞌe ijnko chꞌín na mé chónta chꞌán treinta y ocho nánó níhi chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","A̱ ntá tió kꞌuíkon chꞌín Jesús kíxin tjetsínka tí chꞌín a la ko kónohe chꞌán kíxin ósé níhi chꞌán, ntá kjuanchankí chꞌán kíxin: ―¿Á tjinkávan tsito̱ha jína? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ntá ntáchro tí si̱nníhi kíxin: ―Chóntahyani ninkexró tsjinki̱tsani tsjiánkíni nta̱. A̱ ntá tí tjinkaonni chrókjuiánkíni nta̱ la ntá ókjé nkexro tjítaón nti̱a tjiánkí nta̱ senó ―mé chro tí si̱nníhi. ");
INSERT INTO poeNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","A̱ ntá kꞌue̱to̱an chꞌín Jesús kíxin: ―Ijie la tꞌinkatjen, tjatsíyan ka̱nia̱a, itjia ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ntá tuénxín kuíto̱he chꞌán jína, ntá kjua̱tse̱n chꞌán ka̱nie̱e chꞌán kjuankíxin itji chꞌán. Kjánchó ya̱on sábado tíha mé tí ya̱on tꞌo̱kꞌéhe sín. ");
INSERT INTO poeNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Mé xi̱kaha tí sín judío ntáche sín tí chꞌín kuíto̱he jína kíxin: ―Ijie tí ya̱on tꞌo̱kꞌéheni ntá kohya kjuachaxin tsamá ka̱nia̱a ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","A̱ ntá ntáchro tí chꞌín a kíxin: ―Tí nkexro kjuínchekito̱na jína mé kꞌue̱tua̱nna kíxin tsjatsíyan ka̱nia̱na la ko sátsjia ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ntá kjuanchankíhi sín chꞌán kíxin: ―¿Nkexéhe tí nkexro kꞌue̱tua̱nhan kíxin tsjatsíyan ka̱nia̱a la ko sátsjia? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","A̱ ntá tí chꞌín tsíkito̱he jína na í kjuátso̱anhya chꞌán tí nkexro kjuínchekito̱he chꞌán jína kíxin ntaha la siín nchónhya chojni, a̱ ntá ntahó kꞌuítjáyanxín chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","A̱ ntá chrꞌéxi̱n chꞌín Jesús xeta chꞌán tí chꞌín a nkaxenhen tí ni̱nko jié ntá ntáchro chꞌán kíxin: ―Tsjehé kíxin ijie la ó jína tjen jaha la í tjásinhya jie̱ ínaá. A̱ ntá tí tsjásian jie̱ ínaá a̱ ntá a̱ntsí má jínahya tso̱nhan ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","A̱ ntá sákjuí tí chꞌín a ntá chénka chꞌán tí sín judío kíxin jehe chꞌín Jesús mé kjuínchekito̱he chꞌán jína. ");
INSERT INTO poeNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Mé xi̱kaha tí sín judío kjuankíxin sín chónkíhi sín tí chꞌín Jesús la ko chrókꞌóyán sín chꞌán kíxin kjuínchekito̱he chꞌán chojni jína tí ya̱on tꞌo̱kꞌéhe sín. ");
INSERT INTO poeNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Kjánchó chꞌín Jesús ntáche chꞌán tí jehe sín kíxin: ―Méxra̱ Tꞌaná na̱xa̱ tjechꞌe chꞌán xra̱. A̱ ntá janhan kja̱xin tjétꞌa̱ xra̱ ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Méxra̱ xi̱kaha tí sín judío a̱ntsí tjinkaon sín chrókꞌóyán sín chꞌán kíxin kuítekakuenhya chꞌán tí ley kuènte tí ya̱on tꞌo̱kꞌéhe sín la ko kja̱xin ntáchro chꞌán kíxin tí Itꞌé chꞌán la mé Dios, mé xi̱kaha ncheyóhe̱ chꞌán a̱sén chꞌán Dios. ");
INSERT INTO poeNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ntá ntáche chꞌín Jesús tí jehe sín kíxin: ―Ijnko nkehe tjetoan tso̱tjo̱nka̱rá kíxin tí Xje̱en Dios nkaya nka̱jní tí jehó kjuachaxin kuènte ó la mé xitjahya sichꞌe xra̱. Jehó tí xra̱ tꞌikon chꞌán tjechꞌe Itꞌé chꞌán mé kja̱xin chꞌán xi̱kaha chꞌe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","A̱ ntá tí Itꞌé mé tjuèhe tí Xje̱en chꞌán, la ko tja̱ko̱he̱ chꞌán kaín xín xra̱ chꞌe chꞌán, la ko a̱ntsí tjetoan tí xra̱ na̱xa̱ tsja̱ko̱he̱ chꞌán kíxin ntá tsochrakonrá kíxin tsꞌikonrá tí xra̱ sichꞌe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tí Itꞌé mé chónta kjuachaxin nchexechón tí sín tsíkꞌen la ko chjéhe chꞌán sín kjuachón. A̱ ntá tí Xje̱en kja̱xin chónta kjuachaxin tsochjéhe kjuachón tí nkexro tjinkaon tsochjéhe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","A̱ ntá Itꞌé la í sinchekito̱exínhya chꞌán iji̱é ninkexró. Kaín tí kjuachaxin kuènte chꞌán chjéhe chꞌán tí Xje̱en kíxin sinchekito̱exín chꞌán iji̱é chojni chjasintajni ");
INSERT INTO poeNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","kíxin ntá kaín chojni tsjikosáyehe sín tí Xje̱en éxí yóhe̱ tjikosáyehe sín tí Itꞌé chꞌán. Tí sín tjikosáyehya tí Xje̱en xi̱kaha kja̱xin tjikosáyehya sín tí Itꞌé kíxin jehe chꞌán mé tsíchrꞌán tí Xje̱en. ");
INSERT INTO poeNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Ijnko nkehe tjetoan tso̱tjo̱nka̱rá kíxin tí jnkojínrá tjejotinhínrá tí nkehe tjàkua la ko tinkachónkirá tí Tꞌaná, mé tí nkexro ichrꞌánna, na mé xi̱kaha ó chontará tí kjuachón la ko tsjasótiahyará, na mé kui̱to̱hérá tí nti̱a chrókꞌuénxinrá, la ntá jie kjuankíxinrá tsochontará tí kjuachón jnkochríxín. ");
INSERT INTO poeNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ijnko nkehe tjetoan tso̱tjo̱nka̱rá kíxin ó tsi tí ya̱on, na mé jie tíha, mé xi̱kaha tso̱nhen kíxin tí sín tsíkꞌen tsinhin sín tsonixja tí Xje̱en Dios. A̱ ntá tí sín tsitekaon sín na mé tsꞌejóchón sín. ");
INSERT INTO poeNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tí Itꞌé mé chónta chꞌán kjuachaxin tsjanjon chꞌán tí kjuachón la ko jehe chꞌán mé chjéhe chꞌán kjuachaxin tí Xje̱en kíxin kja̱xin tí Xje̱en tsjanjon tí kjuachón ");
INSERT INTO poeNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","la ko kja̱xin chjéhe chꞌán kjuachaxin tí Xje̱en chꞌán sinchekito̱exín tí iji̱é chojni chjasintajni kíxin jehe mé tí Xje̱en Dios Kꞌóna Chojni. ");
INSERT INTO poeNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Chrakonhyará tjétjo̱nka̱rá xi̱kaha. Na mé ó tsi tí ya̱on kíxin kaín tí sín tsíkꞌen mé tsinhin sín tsonixja chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","A̱ ntá tsꞌaxrjexín sín tí tòye̱ la tí sín kjuíchꞌe sín xra̱ jína mé tsoxechón sín ntá tsochónta sín tí kjuachón. A̱ ntá tí sín kjuíchꞌe sín xra̱ jínahya na mé kja̱xin tsoxechón sín ntá sátsji sín tsjasóte sín. ");
INSERT INTO poeNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Tí jehó kjuachaxin kuènta̱na xitjahya si̱tꞌa ninkehó xra̱. A̱ ntá jie nta̱kito̱axián tí ijie̱ éxí kꞌue̱tua̱nna Tꞌaná. A̱ ntá tí nkehe nta̱kito̱axián la jína ntoá kíxin tjínka̱konhya si̱tꞌa éxí tjínka̱van. Náhí. Éxí tjinkaon Tꞌaná, tí nkexro ichrꞌánna, mé xi̱kaha tjétꞌa̱. ");
INSERT INTO poeNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","A̱ ntá tí chróxrja̱nka kíxin nkexrí imá jína janhan la tíha la ninkehó kjuachaxin chróchóntahya. ");
INSERT INTO poeNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Itjen í jnko nkexro tjechrónka nkexrí tjén janhan a̱ ntá ó nòna kíxin tí nkehe chrónka chꞌán la sínkí. ");
INSERT INTO poeNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Jahará tsíkétue̱nhénrá chojni kjuíkjanchankíhi sín tí chꞌín Juan kíxin nkexrínchi tjén janhan. A̱ ntá tí nkehe tsíkjate̱he chꞌán la chaxín ntoá tiha. ");
INSERT INTO poeNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Kjánchó cho̱ntia̱xi̱nhya tí nkehe tsochrónka nijnko chojni chjasintajni nkexrínchi tjén janhan. Jehí ntáxrja̱n tíha kíxin jahará jína chrókuaárá. ");
INSERT INTO poeNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Tí chꞌín Juan kjuákꞌe éxí yóhe̱ ijnko xrohi kjuákꞌeche kꞌuínkaséyanxín la ko jahará kócháhará xi̱kaha, kjánchó séhya kóxrjínhanrá tí xrohi a. ");
INSERT INTO poeNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Kjánchó siín nkehe a̱ntsí tjetoan tja̱ko̱xi̱n nkexrí tjén janhan, a̱ ntá kánhyó tjetoan tí nkehe tsíchrónka tí chꞌin Juan. Tí xra̱ tjétꞌa̱, mé tí xra̱ kjuanjon Tꞌaná si̱tꞌa tsjixinna tí xra̱, na mé tíha mé tja̱ko̱xi̱n kíxin chaxín Tꞌaná tsíchrꞌán kꞌuinka. ");
INSERT INTO poeNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Kja̱xin jehe Tꞌaná, tí nkexro ichrꞌánna, mé chrónkaxín chꞌán nkexrí tjén janhan. A̱ ntá jahará na̱xa̱ kiénhyará tí nkehe nixja chꞌán la ko kꞌuíkonhyará chꞌán ");
INSERT INTO poeNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","la ko kja̱xin itén chꞌán kuíto̱ehya nkaya kjárá kíxin tjinkákonhyará tsítekáonrá tí Xje̱en Dios tsíchrꞌán tsíki. ");
INSERT INTO poeNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Jahará nchekuáxinrá jína tí xroon tsíkjin tí sín tsíchrónka itén Dios ósé kíxin ntáchrorá kíxin ntaha tsꞌitjaxínrá tí kjuachón tsochontará jnkochríxín. A̱ ntá tí nkehe tsíkjin sín ósé mé chrónka kuènte janhan. ");
INSERT INTO poeNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Kjánchó jahará tjinkákonhyará tsochjinará tí tjén janhan kíxin chrókꞌuayéhérá tí kjuachón a. ");
INSERT INTO poeNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Janhan na tjéyáhya kíxin chojni chrókjuikosáyana sín. ");
INSERT INTO poeNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","A̱ ntá janhan ó nòna kíxin jahará la tjuèhyará Dios. ");
INSERT INTO poeNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Mé kꞌuinkaxian janhan tí kjuachaxin kuènte Tꞌaná. Kjánchó jahará la títekákonnahyará. A̱ ntá tí chrókui í jnko nkexro kjuachaxin chrókuakitsjeníxin a̱sén ó, a̱ ntá tíha mé tjinkáonrá chrókuítekákonhénrá. ");
INSERT INTO poeNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Nkexrí chrókuítekáonrá jahará kíxin tjéyárá kíxin tí chojni chjasintajni chrókjuikosáyahará sín, a̱ ntá tjéyáhyará tí kjuachaxin chrókjuanjon jnkoko̱á Dios? ");
INSERT INTO poeNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Tsontáchrohyará kíxin janhan tsjánchíá jie̱ tí jahará nkayakon Tꞌaná. Náhí. Chꞌín Moisés mé tsjanchia chꞌán jie̱ tí jahará kíxin tsontáchrorá kíxin jehe chꞌán kuinkachónkirá. ");
INSERT INTO poeNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Kja̱ tí jahará chrókuítekáonrá nkehe tsíntáchro chꞌín Moisés ntá chrókuítekáonrá tí janhan kíxin tí xroon tsíkjin chꞌán mé chrónka kuènte tí janhan. ");
INSERT INTO poeNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","A̱ ntá tí títekákonhyará tí nkehe tsíkjin chꞌán, ¿ntá nkexrí chrókuítekákonnará nkehe ntáxrja̱n janhan? ―ichro chꞌán.﻿ ");
INSERT INTO poeNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","A̱ ntá chrꞌéxi̱n ntá sákjuí chꞌín Jesús kꞌuátòye̱ chꞌán tí nta̱yaon Galilea na mé tí nta̱yaon Tiberias tíha. ");
INSERT INTO poeNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","A̱ ntá nchónhya chojni tinkáchréhe̱ sín kíxin kꞌuíkon sín tí kjuaxroan jié kjuasin chꞌán kjuínchekito̱he chꞌán jína tí si̱nníhi. ");
INSERT INTO poeNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","A̱ ntá jehe tí chꞌín Jesús chrìin chꞌán ijnko jna̱ na ntá ntaha kjuákꞌetja̱xi̱n chꞌán la koí tí sín kꞌuájiko chꞌán a. ");
INSERT INTO poeNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","A̱ ntá í séhya tsꞌixin tí kia pascua a mé kié tí sín judío a. ");
INSERT INTO poeNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","A̱ ntá tí chꞌín Jesús kꞌuíkon chꞌán kíxin nchónhya chojni chrìin sín kjuichréhe̱ sín chꞌán ntá kjuanchankíhi chꞌán tí chꞌín Felipe kíxin: ―¿Nketí chrókꞌue̱nani nkehe sine kaín tí chojni a? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Mé xi̱kaha ntáchro chꞌán kíxin siná nkehe tsixro chꞌín Felipe. A̱ ntá tí chꞌín Jesús la ó nohe chꞌán nkehe tí kjuaxroan tsjasin chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ntá kjuáte̱he chꞌín Felipe ntáchro chꞌán kíxin: ―Kjónté doscientos chichaon denario chróchóntani chrókꞌuínáxin tí nio̱tja̱ la na̱xa̱ chrókjuachahya chrókꞌuáyéhe̱ jnkojnko sín to̱tꞌo̱ tí nio̱tja̱ a ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","A̱ ntá chꞌín Andrés, ijnko tí sín kꞌuájiko chꞌín Jesús la sa̱vé mé chꞌín Simón Pedro mé ntáchro chꞌán kíxin: ");
INSERT INTO poeNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Ntihi tjen ijnko xjan ntoa chónta inꞌó nio̱tja̱ tsíkꞌóna noa cebada la ko chónta chꞌán yaá koche. ¿Xá chrókjuacha tíhó kíxin nchónhya chojni siín? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","A̱ ntá ntáchro chꞌín Jesús kíxin: ―Tétue̱nhén tí sín siín a kíxin tsꞌixitja̱xi̱n sín ―ichro chꞌán. A̱ ntá nchónhya ika yoa siín na ntá ntaha kꞌuíxitja̱xi̱n sín na mé éxí inꞌó mil chojni kꞌuíxin sín. ");
INSERT INTO poeNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","A̱ ntá chꞌín Jesús kuákja chꞌán tí nio̱tja̱ ntá kjuanchehe chꞌán Dios kjuasáya ntá chjéhe chꞌán tí sín kꞌuájiko chꞌán. A̱ ntá jehe sín kꞌóxika̱ye̱he sín chjéhe sín kaín tí sín sítja̱xi̱n a. Xi̱kaha kja̱xin kꞌóxika̱ye̱he sín tí koche. A̱ ntá kaín sín kjóne sín éxí tjinkaon sín. ");
INSERT INTO poeNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Kjuixin kjóne sín ntá kꞌue̱tue̱nhen chꞌín Jesús tí sín kꞌuájiko chꞌán ntáchro chꞌán kíxin: ―Tjénájínrá tí nkehe to̱tꞌo̱ síxèhe sín kíxin tsꞌitjáyanhya ninkehó ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ntá xi̱kaha jehe sín kjuenájín sín kjuínchekaón sín teyó ntaxra tí to̱tꞌo̱ tí inꞌó nio̱tja̱ tsíkꞌóna noa cebada síxèhe sín tí kjuixin tsíkjine sín. ");
INSERT INTO poeNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","A̱ ntá tí sín kjóne tí nio̱tja̱ kꞌuíkon sín tí kjuaxroan jié kjuasin chꞌín Jesús ntáchro sín kíxin: ―Jehe chꞌán mé chaxín tí nkexro tsíchrꞌán Dios kíxin itsi tí chjasintajni tsja̱ko̱he̱ni chꞌán ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Kjánchó chꞌín Jesús mé kónohe chꞌán kíxin tjinkaon sín sáchrókjuiko sín chꞌán chróchrꞌáxenhen sín chꞌán tí xra̱ rey kíxin chrókꞌue̱to̱an chꞌán. A̱ ntá jehe chꞌán tjinkakonhya chꞌán tíha ntá jehó chꞌán sáxíkji chꞌán nte̱je̱ ínaá kjuákꞌe chꞌán ntiha. ");
INSERT INTO poeNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","A̱ ntá ó kóntó ntá tí sín kꞌuájiko chꞌín Jesús kꞌuínkaji̱nxi̱n sín jna̱ sákjuí sín chrínta nta̱yaon ");
INSERT INTO poeNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","kꞌui̱tꞌótjen sin ijnko ntabárco̱ kjuankíxin sín tsꞌatòye̱ sín nta̱yaon sátsji sín chjasin Capernaum. Na ó kꞌuíxin tie na na̱xa̱ kjanhya chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ntá kjuankíxin chjéhe xri̱nto̱ tsa̱nka̱ ntá kjuankíxin tinkákjaminkí nta̱. ");
INSERT INTO poeNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","A̱ ntá tió kjuacha sín á inꞌó o̱ injon kilómetro ntá xrína̱hya kꞌuíkon sín tí chꞌín Jesús tinkákóchjinehe chꞌán tí ntabárco̱, éxí ijnko nti̱a tjetjitaón chꞌán tí nta̱, ntá kꞌuíkon sín ntá imá chrakon sín. ");
INSERT INTO poeNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Kjánchó ntáchro chꞌán kíxin: ―Janhan tíha. Chrakonhyará ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ntá imá chéhe̱ sín kꞌui̱tꞌótjen chꞌán tí ntabárco̱. Ntá ó tuénxín kjuíji sín tí chjasin sátsji sín. ");
INSERT INTO poeNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","A̱ ntá tí ya̱on chrꞌéxi̱n na mé tí sín kuíto̱he tóhe nta̱yaon na mé ó nohe sín kíxin jnkoko̱áxón ntabárco̱ kꞌuékjakꞌe ntiha la ko ó nohe sín kíxin chꞌín Jesús kjá ni sátsíkjikohya sín chꞌán na mé kꞌuíkon sín kíxin jehó tí sín kꞌuájiko chꞌán sátsíkji sín. ");
INSERT INTO poeNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Kjánchó siín ntabárco̱ ti̱xi̱n chjasin Tiberias tinkákóchjinehe tí nó kjónexín sín tí nio̱tja̱ kjuanchaxín chꞌín Jesús kjuasáyé Dios. ");
INSERT INTO poeNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","A̱ ntá tió kꞌuíkon sín kíxin kohya chꞌín Jesús la ko kja̱xin kohya tí sín kꞌuájiko chꞌán, ntá jehe sín mé kꞌui̱tꞌótjen sín iso ntabárco̱ ntá sákjuí sín chjasin Capernaum sákjuíkjeyá sín tí chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","A̱ ntá tóhe nta̱yaon xéta sín tí chꞌín Jesús ntá kjuanchankíhi sín chꞌán kíxin: ―Maestro, ¿nkesá kꞌuinka ntihi? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Ó nòna kíxin jahará tjéyárá tí janhan kíxin kjónterá nio̱tja̱ kókja̱hará, la jehya kíxin kiénxinrá tí kjuaxroan kjuásian. ");
INSERT INTO poeNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Chrókjui̱chꞌehyará tí xra̱ chrókꞌuite tí nkehe chrókjónterá tjoka tsjeje̱ ó. Náhí. Chrókjuéyárá tí nkehe chrókjueje̱hya chrókjónterá chrókꞌuayéxínrá tí kjuachón jnkochríxín. Tí nkehe tjanjon tí Xje̱en Dios Kꞌóna Chojni mé chrókjónterá kíxin Itꞌé chꞌán mé tja̱ko̱xi̱n chꞌán kíxin tí Xje̱en chꞌán mé chónta kjua̱cha̱xién tí jehe chꞌán ―ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","A̱ ntá kjuanchankíhi sín chꞌán kíxin: ―¿Nkexrí chrókjuichꞌeni chrokjuinchexiteyáni nkexrí tjinkaon Dios? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","A̱ ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Dios mé tjinkaon chꞌán kíxin chrókuinkachónkirá tí nkexro tsíchrꞌán chꞌán ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ntá kjuanchankíhi sín chꞌán kíxin: ―¿Nkehe tí kjuaxroan chrókjuáko̱éxianni chrókꞌuikonni kíxin ntá chrókuitekaonni tí jaha? ¿Nkehe tí xra̱ chꞌe jaha? ");
INSERT INTO poeNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Tí sín tsíkꞌaxrjeníxinni kꞌuéjó sín ósé mé kjóne sín maná kꞌóna nio̱tja̱ tió kꞌuíxin sín nte̱je̱ mé xi̱kaha tí xroon kuènte Dios tsíkjin ijnko nkexro ósé ntáchro kíxin: “Kjuanjon chꞌán tí nkehe kjóne sín mé nio̱tja̱ tsíki̱xi̱n nkaya nka̱jní” ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","A̱ ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Ijnko nkehe tjetoan tjo̱nka̱rá kíxin jehya chꞌín Moisés kjuanjon tí maná kꞌóna nio̱tja̱ kꞌuínkaji̱nxi̱n nkaya nka̱jní. Náhí. Tꞌaná mé tjetjanjon tí nio̱tja̱ chaxín jína kꞌuínkaji̱nxi̱n nkaya nka̱jní. ");
INSERT INTO poeNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Tí nio̱tja̱ tjanjon Dios mé tí nkexro kꞌuínkaji̱nxi̱n nkaya nka̱jní tjejóchónxin chojni chjasintajni ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Na ntá kjuanchia sín kíxin: ―Jaha Ìnchéni, jnkochríxín chje̱héni tí nio̱tja̱ a ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","A̱ ntá ntáchro chꞌín Jesús kíxin: ―Janhan mé tí nio̱tja̱ tjanjon kjuachón. Tí sín tóchjina sín tí janhan í tsꞌenhya sín kjinta, la ko tí sín tsitekaon sín tí janhan í tsꞌenhya sín nta̱. ");
INSERT INTO poeNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Kjánchó éxí kꞌuétjo̱nka̱rá senó na ó kꞌuíkonrá tí janhan na kjónté na̱xa̱ títekákonhyará. ");
INSERT INTO poeNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","A̱ ntá kaín tí sín chjìna Tꞌaná la tso̱chjina sín tí janhan. A̱ ntá kaín tí sín tjejótóchjinehe sín tí janhan la tsétua̱nhya sín kíxin sátsji sín. ");
INSERT INTO poeNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Janhan kꞌuinkaxian nkaya nka̱jní jehya tí xra̱ tóxrjìna chrókjui̱tꞌa. Náhí. Kꞌuinka kíxin chrókjui̱tꞌa tí xra̱ tóxrjínhin tí nkexro tsíchrꞌánna. ");
INSERT INTO poeNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","A̱ ntá Tꞌaná mé tí nkexro tsíchrꞌánna mé tjinkaon chꞌán kíxin si̱ntakꞌitjáyanhya ninkexró tí sín chjìna chꞌán na mé tjinkaon chꞌán kíxin janhan mé si̱ntaxechón kaín sín tí ya̱on tsjixixín. ");
INSERT INTO poeNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Mé xi̱kaha tjinkaon tí nkexro tsíchrꞌánna kíxin kaín tí sín tsꞌikon sín tí janhan mé tí Xje̱en Dios la ko tsitekaon sín tí janhan chrókꞌuáyéhe̱ sín kjuachón jnkochríxín. A̱ ntá janhan si̱ntaxechón sín tí ya̱on tsjixixín ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","A̱ ntá tí sín judío kjuankíxin sín kjonta sín tí chꞌín Jesús kíxin tsíntáchro chꞌán kíxin jehe chꞌán mé tí nio̱tja̱ kꞌuínkaji̱nxi̱n nkaya nka̱jní. ");
INSERT INTO poeNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Mé ntáchro sín kíxin: ―¿Á jehya tí Jesús, itꞌé mé itꞌín José, na mé chóxinni tí itꞌé la ko tí ìné chꞌán? ¿Ntá nkekuènté ntáchro chꞌán kíxin nka̱jní kꞌuínkaji̱nxi̱n chꞌán? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Ti̱to̱hérá tjóntahyará tí janhan. ");
INSERT INTO poeNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Kohya nkexro chrókóchjina tí tjén janhan tí chrókjuínki̱tsahya Tꞌaná. A̱ ntá tí sín tóchjina na mé si̱ntaxechón sín tí ya̱on tsjixixín. ");
INSERT INTO poeNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Na mé tí sín kꞌuéchrónka itén Dios ósé mé tsíkjin sín xroon ntáchro kíxin: “Dios mé tsja̱ko̱he̱ chꞌán kaín chojni.” A̱ ntá kaín tí sín tsíkinhin tí nixja Tꞌaná la ko kjua̱ko̱he̱ chꞌán sín mé sítóchjina sín tí tjén janhan. ");
INSERT INTO poeNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Jehya kíxin itjen ijnko chojni tsíkꞌikon Tꞌaná. Náhí. Jehó tí nkexro kui̱xi̱n tí tjen Dios mé tsíkꞌikon chꞌán Dios. ");
INSERT INTO poeNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Chaxín tí nkehe tjéxrja̱nka kíxin tí sín titekaon sín tí janhan mé ó tsochónta sín kjuachón jnkochríxín. ");
INSERT INTO poeNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Janhan na mé tí nio̱tja̱ tjanjon kjuachón. ");
INSERT INTO poeNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Tí sín kꞌuaxrjeníxinrá kꞌuéjó ósé kjóne sín tí maná kꞌóna nio̱tja̱ tió kꞌuéjó sín nte̱je̱, a̱ ntá kjónté ikꞌuén sín kꞌuítjáyan sín. ");
INSERT INTO poeNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Tí nkehe xrja̱nka mé tí nio̱tja̱ kꞌuínkaji̱nxi̱n nkaya nka̱jní, a̱ ntá tí sín sine tí nio̱tja̱ a mé tsꞌenhya sín. ");
INSERT INTO poeNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Janhan mé tí nio̱tja̱ tjechón kꞌuínkaji̱nxi̱n nkaya nka̱jní. A̱ ntá tí sín sine tí nio̱tja̱ a mé tsꞌejóchón sín jnkochríxín. Tí nio̱tja̱ tsjánjuan tsꞌejóchónxin chojni chjasintajni mé nto̱na tíha ―ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","A̱ ntá tí sín judío mé sítjité sín itjo sín kíchó sín ntáchro sín kíxin: ―¿Nkexrí chrókjuanjon chꞌán nto̱e chꞌán chrókjóneni? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","A̱ ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Ntá tso̱tjo̱nka̱rá kíxin tí sintehyará nto̱e tí Xje̱en Dios Kꞌóna Chojni, la ko tí tsꞌihyará ijni̱é chꞌán, ntá tsochontahyará kjuachón jahará. ");
INSERT INTO poeNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Tí sinterá nto̱na la ko itꞌirá jni̱na ntá tsochontará kjuachón jnkochríxín la ko janhan mé si̱ntaxechónrá tí ya̱on tsjixixín. ");
INSERT INTO poeNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kíxin nto̱na na mé chaxín nkehe ine chojni la ko jni̱na na mé chaxín nkehe itꞌi chojni. ");
INSERT INTO poeNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Tí sín ine nto̱na la ko itꞌi sín jni̱na mé jnkoko̱á tjenka̱yáxinkian sín la ko janhan mé xríki̱an sín. ");
INSERT INTO poeNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tꞌaná tsíchrꞌán chꞌán tí janhan mé chónta kjuachaxin, a̱ ntá janhan mé tjécho̱nxian tí jehe chꞌán. Ntá tí sín sine tí nto̱na mé tsꞌejóchónxin sín tí janhan. ");
INSERT INTO poeNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","A̱ ntá tjéníxja̱ kuènte tí nio̱tja̱ kꞌuínkaji̱nxi̱n nkaya nka̱jní na mé yóe̱hya tí maná tsíkꞌóna nio̱tja̱ kjóne tí sín tsíkꞌaxrjeníxinrá ósé kíxin jehe sín na kjóne sín na kjónté kꞌuén sín. A̱ ntá tí sinterá tí nio̱tja̱ kꞌuínkaji̱nxi̱n nkaya nka̱jní ntá tsꞌejochónrá jnkochríxín ―mé chro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Kaín tíha mé kjua̱ko̱he̱ chꞌán tí sín tsíkójnkotséxin tí ni̱nko Israel chjasin Capernaum. ");
INSERT INTO poeNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","A̱ ntá tió kuínhin sín tí nkehe kjuako chꞌín Jesús ntá itsjé tí sín kꞌuájiko chꞌán ntáchro sín kíxin: ―Imá xra̱ tí nkehe chrónka chꞌán. ¿Xá nkexro chrókuinhin tíha? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","A̱ ntá kónohe chꞌín Jesús kíxin xi̱kaha tóxakonhen sín kíenxínhya sín tí nkehe tsíntáchro chꞌán ntá kjuanchankíhi chꞌán sín kíxin: ―¿Á kja̱xinrá tjinkákonhyará tsinhínrá tíhi? ");
INSERT INTO poeNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Ntá nkexrí tso̱nhen chrókꞌuikonrá kíxin tí Xje̱en Dios Kꞌóna Chojni mé sátsji̱ chꞌán ínaá tí nó tsíki̱xi̱n chꞌán tí tsíkjakꞌe chꞌán ósé? ");
INSERT INTO poeNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Tí Ncha̱kuen Dios mé tjanjon tí kjuachón, a̱ ntá tí nto la ninkehó sínkíhya. Na ntá tí nkehe tjétjo̱nka̱rá na mé kuènte tí Ncha̱kuen Dios na mé tjejóchónxin chojni. ");
INSERT INTO poeNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Kjánchó isorá na̱xa̱ títekákonnahyará ―ichro chꞌán. Mé xi̱kaha ichro chꞌán kíxin tí xrankíxixín ó kónohe chꞌán kíxin nkexro tí sín tsitekakuenhya sín chꞌán la ko kónohe chꞌán kíxin nkexro sinchekji chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","A̱ ntá ntáchro chꞌán kíxin: ―Méxra̱ xi̱kaha kꞌuétjo̱nka̱rá kíxin ninkexró tso̱chjina tí tjén janhan tí tsjinki̱tsahya Tꞌaná ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","A̱ ntá kjuixin tíha ntá nchónhya tí sín kꞌuékꞌajiko chꞌín Jesús ntá xrína̱hya kuíto̱he sín, í chrèhya sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ntá kjuanchankíhi chꞌán tí teyó sín kꞌuájiko chꞌán ntáchro chꞌán kíxin: ―¿Á kja̱xinrá tjinkáonrá xi̱kaha sáchrókjuirá? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ntá kjuáte̱he chꞌín Simón Pedro kíxin: ―Jaha Ìnchéni, ¿nkekuènté tjanchankíhíni á sáchrókjuini ókjé? Jaha tí tan chro̱nka a mé tsochóntaxínni kjuachón jnkochríxín ");
INSERT INTO poeNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ntá kuítekaonni ntá ó noheni chaxín kíxin jaha tí Cristo mé Xje̱en Dios tjechón ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Janhan kjuéyá tí kaín rá teyórá la ko jnkojínrá ntihi mé tsꞌónará ijnko jínahya ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Tíha mé tꞌaxrjexín tí ntáchro chꞌín Jesús chrónka chꞌán kíxin chꞌín Judas Iscariote, tíha itꞌé mé itꞌin Simón, mé ijnko tí teyó sín tsíkjeyá chꞌán ntá kjónté sinchekji chꞌán tí chꞌín Jesús.﻿ ");
INSERT INTO poeNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ntá kjuixin tíha ntá kꞌuáji chꞌín Jesús tí estado Galilea. Chrókꞌuajihya chꞌán tí estado Judea kíxin tí sín judío tjinkaon sín chrókꞌóyán sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Kjánchó ó kuichjina tí ya̱on kia ntá tí sín judío sichꞌéna sín itsjé itsꞌvan tsjasixín sín kia. ");
INSERT INTO poeNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","A̱ ntá tí sín kíchó chꞌín Jesús ntáche sín chꞌán kíxin: ―Chrókuito̱ahya ntihi. Sáchrókjuia estado Judea kíxin ntá kja̱xin tí sín chréhe̱ tí jaha tjejó ntiha chrókꞌuikon sín tí kjuaxroan tsjásian. ");
INSERT INTO poeNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kíxin tió tjinkaon ijnko nkexro kíxin chojni tsochóxin sín chꞌán ntá móhya chrókjuichꞌe chꞌán xra̱. A̱ ntá tí chaxín tjetjásian kjuaxroan la jehya mó chrókjuásian kjuaxroan. Náhí. Chrókꞌuikon kaín xín chojni siín chjasintajni ―mé chro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Xi̱kaha ntáchro tí sín kíchó chꞌán kíxin kja̱xin jehe sín titekakuenhya sín tí jehe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","A̱ ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Na̱xa̱ kjuixrakáhya tí hora kuènta̱na tsjásian kjuaxroan. Ntá jahará la cualquier hora tjinkáonrá jína chrókꞌuikonrá kjuaxroan. ");
INSERT INTO poeNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Tí sín chjasintajni xitjahya tso̱nínkakonhanrá sín tí jahará. Ntá janhan na imá nínkakonna sín kíxin ntátjan sín kíxin jehya jína tí nkehe tjejóchꞌe sín. ");
INSERT INTO poeNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Jahará la sátjírá tí kia a. A̱ ntá janhan la tjíhya kíxin na̱xa̱ kjuixrakáhya tí hora kuènta̱na ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Mé xi̱kaha ntáchro chꞌán ntá kuíto̱he chꞌán estado Galilea. ");
INSERT INTO poeNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","A̱ ntá ó kjuixin sátsíkji̱ tí sín jnkoko̱á kíchó chꞌín Jesús ntá jehe chꞌán la kja̱xin sákjui̱ chꞌán tí kia a kjánchó noxínhya xritjakꞌe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","A̱ ntá tí sín judío mé xriteyá sín chꞌán tí kia a la ntáchro sín kíxin: ―¿Xá nketí tjen tí chꞌín a? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","A̱ ntá itsjé sín ntiha mé kjo sín kíchó sín kíxin nkexrí tjen chꞌán. Iso sín ntáchro sín kíxin: “Jína chꞌán”; kjánchó í so sín ntáchro sín kíxin: “Jehya chojni jína chꞌán, méxra̱ imá chꞌiyehe chꞌán chojni”, ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Kjánchó noxínhya kjo sín xi̱kaha kíxin chrako̱nhe̱n sín tí sín judío a. ");
INSERT INTO poeNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","A̱ ntá ó kjuíji jnko̱siné tí kia a ntá kꞌuíxenhen chꞌín Jesús tí ni̱nko jié ntá kjuankíxin chꞌán kjuako chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","A̱ ntá tí sín judío chrakon sín komá sín chꞌán ntáchro sín kíxin: ―¿Xá nkexrí nohe tí chꞌín i nchónhya tí nkehe kíxin tsíxrako̱e̱hya chꞌán? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Tí nkehe tjàkua la jehya kuènta̱na na mé tí xra̱ kuènte tí nkexro tsíchrꞌánna kꞌuinka. ");
INSERT INTO poeNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Tí jnkojinrá tjinkáonrá chrókjui̱nchexiteyéhérá éxí tóxrjínhi̱n Dios la tso̱nohará á chaxín kuènte Dios tí nkehe tjàkua o̱ á kuènta̱na tíha. ");
INSERT INTO poeNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","A̱ ntá tí nkexro tjako tí nkehe tꞌaxrjeníxin kja sín ó mé xi̱kaha chꞌe kíxin tjinkaon sín kíxin tí chojni ó mé chróchóntehe sín chꞌán kjuasáya. A̱ ntá tí nkexro tjinkaon kíxin tí chojni a mé chrókjuikosáyehe sín tí nkexro tsíchrꞌán chꞌán na mé jehe chꞌán mé tjako chꞌán tí nkehe chaxín ntoá la ko ninkehó chꞌiyahya tí jehe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’¿Á jehya chꞌín Moisés tjáhará tí itén Dios chrókuítekáonrá? Kjánchó nijnkorá kuítekákuenhyará tí nkehe tsíkjin chꞌán. ¿Méxra̱ nkekuènté tjinkáonrá chrókꞌoyánrá tí janhan? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ntá kjuáte̱he tí sín a ntáchro sín kíxin: ―Jaha chonta ijnko ncha̱kuen tí jínahya. ¿Xá nkexro chrókꞌóyán tí jaha? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Jnkoko̱á kjuaxroan kjuásian tí ya̱on tꞌo̱kꞌéheni ntá chrakonrá. ");
INSERT INTO poeNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","A̱ ntá chꞌín Moisés tsíkꞌe̱to̱an kíxin xja̱anrá ntoa itsa xjan xro̱ye, (kjánchó jehya chꞌín Moisés kjuankíxin chꞌán kjuako chꞌán tíha, na mé tí sín tsíkꞌaxrjeníxinrá kjuankíxin sín kjuako sín tíha). Mé xi̱kaha nchekará xjan tí xro̱ye a kjónté ya̱on tꞌo̱kꞌéheni. ");
INSERT INTO poeNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","A̱ ntá xi̱kaha nchekará xjan xro̱ye tí ya̱on tꞌo̱kꞌéheni kíxin xi̱kaha chrókjui̱nchekꞌitjáyankíhyará ninkehó tí nkehe kꞌue̱to̱an chꞌín Moisés, ¿ntá nkekuènté kíxin ninkákonnará tí janhan kíxin kjui̱ntaki̱to̱ha̱ jína ijnko chojni tí ya̱on tꞌo̱kꞌéheni? ");
INSERT INTO poeNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Chrókjuanchahyará jie̱ kíxin tí nkehe tꞌikonxínrá ikonrá ó. Chrókjuenka̱yáxinrá tí nkehe jína tóxrjínhi̱n Dios ―mé chro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","A̱ ntá iso sín chjasin Jerusalén kjuankíxin sín kjo sín kíchó sín kjuanchankí sín kíxin: ―¿Á jehya tí chꞌín a xritjeyá sín chrókꞌóyán sín? ");
INSERT INTO poeNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ntá jie noxín tjen chꞌán nixja chꞌán kohya ninkexró nínkakonhen chꞌán. Kjá tí síxre̱é titekaon sín kíxin tí nkexro a chaxín Cristo tíha. ");
INSERT INTO poeNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Kjánchó ó noheni nketí tsíkji̱xi̱n chꞌán. A̱ ntá tió tsi tí nkexro Cristo ntá ninkexró tso̱noehya nketí tsi̱xi̱n chꞌán ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","A̱ ntá chꞌín Jesús kjuákꞌekjako chꞌán tí ni̱nko jié ntá kuínhin chꞌán kíxin xi̱kaha kjo sín, ntá itsen nixja chꞌán ntáchro chꞌán kíxin: ―Chaxín choxinrá tí janhan la ko nohará nketí chjasin tsíkjíxian. Kjánchó jehya kíxin kꞌuinka si̱ntaxiteyá tí nkehe ntáchro a̱senná ó. Ó kꞌuinka kíxin ichrꞌánna tí nkexro chaxín tjechón tjen nkaya nka̱jní. Jahará na̱xa̱ chonhyará tí nkexro a. ");
INSERT INTO poeNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Janhan la choxian chꞌán kíxin ntaha tsíkꞌinkaxian na mé jehe chꞌán mé tsíchrꞌánna chꞌán ―ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ntá chrótsé sín chꞌán chrókjua̱kꞌe̱chji̱na sín chꞌán ntá kjónté ninkexró tséhya sín chꞌán kíxin na̱xa̱ kjuanjonhya Dios kjuachaxin chrótsé sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Kjánchó itsjé chojni kuítekaon sín tí jehe chꞌán. A̱ ntá ntáchro sín kíxin: ―A̱ ntá tió chrókui tí Cristo la, ¿á má jié kjuaxroan chrókjuasin chꞌán, a̱ ntá tí chꞌín i la kénhyó ní? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","A̱ ntá tí sín fariseo kuínhin sín nkehe tí ntáchro chojni kíxin nkexrí tjen chꞌín Jesús, ntá jehe sín la ko tí sín ncha̱tꞌá tꞌe̱to̱an kꞌue̱tue̱nhen sín iso sín policía kuènte ni̱nko tsotsé sín chꞌán tsja̱kꞌe̱chji̱na sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","A̱ ntá ntáchro chꞌín Jesús kíxin: ―Kja̱xin í séhya tsjakꞌé ntihi tsꞌejóni ntá sáxikji̱ya tí tjen tí nkexro ichrꞌánna. ");
INSERT INTO poeNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","A̱ ntá jahará tsjéyárá tí janhan na tsꞌitjahyará kíxin xitjahya tsjasánrá tí tsjakꞌé janhan ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","A̱ ntá tí sín judío kjuankíxin sín kjuanchankíhi sín kíchó sín kíxin: ―¿Ntá nketí nó sátsji̱ chꞌán kíxin tsjachahyani tsꞌitjani chꞌán? ¿Xá sátsjichréhe̱ chꞌán tí sín judío tjejóyákjan tí sín nixja nkìva griego kíxin ntá tsja̱ko̱he̱ chꞌán tí sín griego? ");
INSERT INTO poeNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Nkexrí tꞌaxrjexín tí nkehe ntáchro chꞌán kíxin tsjeyáni chꞌán na kjónté tsꞌitjahyani chꞌán la tsjachahyani tsjichréhe̱ni chꞌán tí tsjakꞌe chꞌán? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","A̱ ntá tí ya̱on tsjixixín tí kia a mé tí ya̱on jié mé kꞌuínkatjen chꞌín Jesús, a̱ ntá itsen nixja chꞌán ntáchro chꞌán kíxin: ―Kja̱ tí jnkojínrá ikꞌuénrá nta̱ xrákirá itsꞌirá nta̱. ");
INSERT INTO poeNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","A̱ ntá éxí ntáchro xroon Itén Dios kíxin tí sín titekaon sín tí janhan na mé nkaya a̱sén sín tsꞌóna ijnko río tsꞌaxrje ìnta̱ tjechón ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Mé xi̱kaha chrónkaxín chꞌín Jesús nkexrí tjen tí Ncha̱kuen Dios tsꞌáyéhe̱ tí sín tsitekaon sín tí jehe chꞌán. Kjánchó na̱xa̱ tihya tí Ncha̱kuen Dios kíxin chꞌín Jesús na̱xa̱ sátji̱hya chꞌán nkaya nka̱jní. ");
INSERT INTO poeNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","A̱ ntá iso sín tió kuínhin sín tí nkehe ntáchro chꞌín Jesús ntá ntáchro sín kíxin: ―Kja̱ chaxín tí chꞌín i mé tí profeta ó tsíkji ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ikjé sín ntáchro sín kíxin: ―Jehe chꞌán mé tí nkexro Cristo ―ichro sín. A̱ ntá í so sín ntáchro sín kíxin: ―¿Xá nkekuènté chrókjui̱xi̱n Galilea tí nkexro Cristo? ");
INSERT INTO poeNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Tí xroon tsíkjin sín ósé mé chrónka kíxin tí nkexro Cristo mé tsꞌaxrjeníxin tí sín kꞌuaxrjeníxin tí chꞌín rey David la ko tsji̱xi̱n chꞌán chjasin Belén mé tí chjasin kꞌuékjakꞌe chꞌín David ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Mé xi̱kaha jnkoko̱áhya kjuenka̱yáxin sín kaín sín kíxin nkexro tí chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Iso sín tjinkaon sín sáchrókjuiko sín chꞌán chrókjuikjehe̱ sín chꞌán kjánchó ninkexró kjuíchꞌehya xi̱kaha. ");
INSERT INTO poeNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","A̱ ntá tí sín policía kuènte ni̱nko mé kjan sín tí tjejó tí sín fariseo la ko tí sín ncha̱tꞌá tꞌe̱to̱an. Ntá tí sín a mé kjuanchankíhi sín tí sín policía kíxin: ―¿Nkekuènté kjuíkoahyará chꞌán? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ntá kjuáte̱he tí sín policía kíxin: ―Kohya ninkexró nixja éxí xi̱kaha nixja tí chꞌín a ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ntá ntáche tí sín fariseo tí sín policía kíxin: ―¿Á kja̱xinrá kui̱to̱hérá kjuítꞌayahará chꞌán? ");
INSERT INTO poeNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Á kuítekaon tí jehe chꞌán jnkojín tí sín tꞌe̱to̱an kuènténi o̱ tí sín fariseo? ");
INSERT INTO poeNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","A̱ ntá tí sín a mé chónhya sín tí ley na mé tsjasóte sín ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","A̱ ntá tí chꞌín Nicodemo, tí chꞌín kjuítsjehe tí chꞌín Jesús ijnko tie senó na mé jehe chꞌán fariseo chꞌán na ntá ntáche chꞌán sín kíxin: ");
INSERT INTO poeNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Tí ley kuènténi la kohya kjuachaxin sinchekjasóteni ijnko chojni tí na̱xa̱ kíenhyani nkehe nixja chꞌán la ko kíenhyani tí jie̱ kjuasin chꞌán ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ntá kjuáte̱he sín ntáchro sín kíxin: ―¿Á kja̱xian jaha kjuíxian estado Galilea ní? Nchekuáxian tí xroon itén Dios ntá tso̱noha kíxin nijnko tí sín kꞌuéchrónka itén Dios tsíkji̱xi̱nhya sín tí estado Galilea ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ntá jnkojnko tí sín xíka sín sákjuí sín nto̱e sín. ");
INSERT INTO poeNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ntá chꞌín Jesús mé sákjui̱ chꞌán tí jna̱ Olivo. ");
INSERT INTO poeNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ntá tí kóya̱on nchítjen ikjan chꞌán kꞌuíxenhen chꞌán tí ni̱nko jié a la ko kaín xín tí chojni mé kóchjinehe sín chꞌán. Ntá kjuákꞌetja̱xi̱n chꞌán kjuankíxin chꞌán kjuako chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ntá tí sín tjako tí ley la ko tí sín fariseo mé kjui̱ka̱o sín ijnko tjachjin kónoxíxin kíxin chónta tjan ókjé chojni ntoa. Ntá kjua̱kꞌe̱ sín tjan jnko̱siné tí sín tjejó ntiha. ");
INSERT INTO poeNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ntá ntáche sín tí chꞌín Jesús kíxin: ―Maestro, tí tjan i kónoxíxin kíxin kjuasin tjan jie̱ chónta tjan ókjé chojni ntoa. ");
INSERT INTO poeNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","A̱ ntá tí ley tsíkjin chꞌín Moisés mé tꞌe̱to̱an kíxin ixro̱ chrókꞌóyánxinni tí chojni chjin xi̱kaha chꞌe. ¿A̱ ntá jaha, nkechrua? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Mé xi̱kaha ichro sín kíxin tjinkaon sín kíxin áchꞌe ntoáhya chrókjuate̱he chꞌín Jesús ntá chrókjuanchia sín jie̱. Ntá chꞌín Jesús mé kꞌuísén chꞌán kji̱nxi̱n chꞌán dedo tja chꞌán nonte a. ");
INSERT INTO poeNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ntá na̱xa̱ tinkákjanchankíhi sín chꞌán. Ntá kꞌuínkatjen chꞌán kꞌue̱to̱an chꞌán kíxin: ―Xá nkexro tí tjejorá ntihi chóntahya ninkehó jie̱ mé sa̱oxín chróchjéhe sín tjan xro̱ ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ntá xíkꞌisén chꞌán ínaá ikjin chꞌán tí nche ínaá. ");
INSERT INTO poeNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ntá tí sín a mé kuínhin sín tí nkehe kꞌue̱to̱an chꞌín Jesús ntá kósuèhe̱ sín kíxin koí sín chónta sín jie̱, ntá jnkojnko jnkojnko sín, sásítji sín na mé sa̱oxín tí chꞌín a̱ntsí má táda chꞌán sákjuí chꞌán, ntá kaín tí sín í so a sákjuí sín kja̱xin sín. Ntá jehó tí chꞌín Jesús la ko tí tjan a kuíto̱he sín ntiha. ");
INSERT INTO poeNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ntá xrentoá chꞌán la kjuanchankíhi chꞌán tjan kíxin: ―¿Nkekjá tí sín kjuanchia jie̱? ¿Á kohya ninkexró kjuínchekjasótiahya ní? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ntá ntáchro tjan kíxin: ―Náhí, Ìnchéni, ninkexró ―ichro tjan. Ntá ntáchro chꞌín Jesús kíxin: ―Kja̱xin janhan si̱ntakjasótiahya. Sátjia la í tjásinhya jie̱ ínaá ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ntá chꞌín Jesús xínixje̱he̱ chꞌán tí sín tsíkóchjina ínaá ntáchro chꞌán kíxin: ―Janhan mé xrohi tꞌinkaséyanxín chjasintajni. Tí tsochréhérá tí janhan ntá tsꞌajirá tí tꞌinkaséyan tsochontaxínrá tí kjuachón a la ko í tsꞌajihyará tí sítié a ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ntá tí sín fariseo ntáchro sín kíxin: ―Jahvá tjechro̱nka nkexrí tjen jaha na mé chaxínhya tíha kíxin jahvá tjechro̱nka ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Janhván tjétjo̱nka̱rá nkexrí tjén na kjónté chaxín xrja̱nka kíxin ó nòna nketí nó kꞌuinkaxian la ko nòna nketí sátsjiyá. A̱ ntá jahará noahyará nketí kꞌuinkaxian la ko noahyará nketí sátsjiyá. ");
INSERT INTO poeNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Jahará la éxí chojni chjasintajni ó tékará jie̱. A̱ ntá janhan la tékahya jie̱ ninkexró. ");
INSERT INTO poeNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Kjánchó ntoá chrókjui̱ntakito̱axián iji̱é chojni kíxin jehya janhván tꞌa̱ tíha, Tꞌaná tjéki̱an, na mé tí nkexro kꞌue̱tua̱nna kꞌuinka ntihi na mé jehe chꞌán mé tjéki̱an chꞌán ntihi ntakito̱axínkian iji̱é chojni. ");
INSERT INTO poeNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","A̱ ntá tí ley tsíkjin chꞌin Moisés mé ntáchro kíxin tí tso̱noxín iyó sín tsochrónka á chaxín xi̱kaha tsíkónhen ntá chrókuitekaon chojni. ");
INSERT INTO poeNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ntá janhan na mé tjéxrja̱nka nkexrí tjén janhan la ko kja̱xin Tꞌaná mé tí nkexro kꞌue̱tua̱nna kꞌuinka mé jehe chꞌán kja̱xin chrónka chꞌán nkexrí tjén janhan ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ntá kjuanchankíhi sín chꞌán kíxin: ―¿Nketí tjen Itꞌá? ―ichro sín. Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Jahará la chonhyará tí janhan la ko kja̱xin chonhyará Tꞌaná. Tí chrókóchoxinrá tí janhan ntá kja̱xin chrókóchoxinrá tí Tꞌaná ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Mé xi̱kaha chro chꞌín Jesús tí kjuákꞌekja̱ko̱xi̱n chꞌán tí ni̱nko jié chjino ntacajón tjetóxroyéya chichaon tjanjon sín. Kjánchó ninkexró tséhya sín chꞌán kíxin na̱xa̱ kjuixrakáhya tí hora tsotsé sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ntá chꞌín Jesús ntáche chꞌán sín ínaá kíxin: ―Ntá sátsjiyá janhan. Ntá jahará tsjéyárá tí janhan, ntá tió tsꞌénrá na̱xa̱ yamárá iji̱árá. Xitjahya tsjasánrá tí nó sátsjiyá janhan ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ntá ntáchro tí sín judío ikjo sín kíchó sín kíxin: ―¿Á tsꞌóyán chꞌán a̱sén chꞌán kíxin xi̱kaha ntáchro chꞌán kíxin xitjahya tsjijini tí nó sátsji̱ chꞌán? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ntá ntáche chꞌín Jesús tí jehe sín kíxin: ―Jahará la nonte ntihi kꞌuaxrjéníxinrá. A̱ ntá janhan la nkaya nka̱jní kꞌuaxrjéníxia̱n. Jahará la kuènte chjasintajni ntihi. A̱ ntá janhan la janhya kuènte chjasintajni. ");
INSERT INTO poeNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Mé xi̱kaha tjo̱nka̱rá kíxin tió tsꞌénrá na̱xa̱ tsochontará iji̱árá kíxin tí tsítekákonhyará tí janhan, mé tí nkexro xráxín tjen, ntá kjónté tsꞌénrá na̱xa̱ tsochontará tí iji̱árá ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ntá kjuanchankí sín ntáchro sín kíxin: ―¿Nkexro tí jaha? ―ichro sín. Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Tí xrankíxixín kjuankíxian tjo̱nka̱rá kíxin nkexro tí janhan. ");
INSERT INTO poeNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Itsjé nkehe chonta chróntáxrja̱n kíxin chrókjui̱ntakito̱axián tí jie̱ chontará. Kjánchó tí nkexro kꞌue̱tua̱nna kꞌuinka na mé tí nkehe chrónka chꞌán la chaxín. A̱ ntá jehó tí nkehe kui̱nha̱n chrónka chꞌán mé tjáko̱ha̱ tí sín chjasintajni ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Kjánchó jehe sín mé kíenxínhya sín kíxin nixja chꞌán kuènte Itꞌé chꞌán tjen nkaya nka̱jní. ");
INSERT INTO poeNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","A̱ ntá ntáchro chꞌán kíxin: ―Tió si̱nchekꞌi̱tꞌótjenrá noi tí Xje̱en Dios Kꞌóna Chojni, ntá tso̱nohará kíxin janhan mé tí nkexro xráxín tjen. Ntá tso̱nohará kíxin jehya janhan této̱an tí xra̱ tjétꞌa̱. Náhí. Jehó tí nkehe kjua̱ko̱na Tꞌaná mé tjétjàkua. ");
INSERT INTO poeNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Tjéki̱an tí nkexro kꞌue̱tua̱nna kꞌuinka kíxin jehí xráxín Tꞌaná la kuíto̱nahya janhván kíxin xráxín nta̱xiteyáha̱ tí nkehe tóxrjínhi̱n chꞌán ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Mé xi̱kaha ntáchro chꞌán ntá nchónhya chojni kuítekaon sín tí jehe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ntá nixje̱he̱ chꞌín Jesús tí sín judío kuinkáchónki sín chꞌán ntáchro chꞌán kíxin: ―Tí tsi̱to̱éhyará tí tan kjuákohará ntá jahará chaxín discípulo kuènta̱na ");
INSERT INTO poeNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","la ko tsjátso̱anrá tí nkehe chaxín, la ko tí nkehe chaxín mé tsotjáhará kjuachaxin tsaáxinrá, a̱ ntá tso̱kohya nkehe tsꞌinkákonhe̱n ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ntá kjuáte̱he sín ntáchro sín kíxin: ―Jeheni mé tsíkꞌaxrjeníxinni chꞌín Abraham na í xráxín kohya nkexro kꞌue̱na tí jeheni. ¿Nkekuènté ntáchrua jaha kíxin tsꞌáyéhe̱ni kjuachaxin tsaáxinni? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ntá ntáchro chꞌín Jesús kíxin: ―Tjetoan tí nkehe tjétjo̱nka̱rá kíxin tí sín tjasin jie̱ mé éxí chojni kꞌuíná chrokjuahya tsito̱he sín iji̱é sín. ");
INSERT INTO poeNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","A̱ ntá ijnko chojni kꞌuíná la jnkochríxínhya tsjakꞌe chꞌán tí nto̱e tí nkexro a. A̱ ntá tí xje̱en tí nkexro na mé jnkochríxín tsito̱he ntiha. ");
INSERT INTO poeNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ntá tí tsaáxinrá tí Xje̱en Dios ntá chaxín tsochontará kjuachaxin, a̱ ntá tso̱kohya nkehe tsꞌinkákonhe̱n. ");
INSERT INTO poeNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ó nòna kíxin jahará tsíkꞌaxrjeníxinrá chꞌín Abraham. Kjánchó tjinkáonrá chrókꞌoyánrá tí janhan kíxin títekákonhyará tí nkehe tjéxrja̱nka. ");
INSERT INTO poeNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Janhan xrja̱nka tí nkehe kꞌuíkua̱n kíxin nkexrí tjen Tꞌaná. A̱ ntá jahará tjejonchexiteyéhérá tí nkehe kuínhínrá chrónka itꞌárá ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","A ntá jehe sín kjuáte̱he sín ntáchro sín kíxin: ―Itꞌéni mé chꞌín Abraham ―ichro sín. Kjánchó ntáchro chꞌín Jesús kíxin: ―A̱ ntá tí jahará chrókóchaxín xje̱en chꞌín Abraham ntá chrókjui̱chꞌerá éxí kjuíchꞌe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","A̱ ntá tjétjo̱nka̱rá tí tan chaxín kui̱nha̱n chrónka Dios na kjónté chrókꞌoyánrá tí janhan. A̱ ntá chꞌín Abraham xi̱kahya kjuíchꞌe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Jahará tjejochꞌerá éxí kjuíchꞌe itꞌárá ―ichro chꞌán. Ntá ntáchro sín kíxin: ―Jehya kꞌónamá tí jeheni. Náhí. Chóntani jnkoko̱á Itꞌéni mé Dios ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ntá ntáche chꞌín Jesús tí jehe sín kíxin: ―Tí chrókóchaxín kíxin Dios mé Itꞌárá la ntá chrótjua̱nará kíxin janhan kja̱xin kꞌuaxrjeníxinna Dios kꞌuinkaxian tí tjen chꞌán. Jehya kíxin janhván kꞌuinka. Náhí. Dios mé ichrꞌánna kꞌuinka. ");
INSERT INTO poeNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Nkekuènté kíxin tiénxinhyará tí nkehe tjo̱nka̱rá? Jehí tjinkákonhyará chrókuinhínrá tí nkehe xrja̱nka. ");
INSERT INTO poeNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Jahará mé xje̱en Tsochren la ko jahará tsíkꞌaxrjeníxinrá chꞌán la ko tjinkáonrá si̱nchexiteyárá tí nkehe tjinkaon chꞌán. Tsochren mé xrankíxixín kjuaya chꞌán. Nunca kꞌuénixja chꞌán ntoá. Xráxín chꞌia chꞌán kíxin xi̱kahó tjenka̱yáxin chꞌán. Jehe chꞌán mé itꞌé kaín tí kjuachꞌia. ");
INSERT INTO poeNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","A̱ ntá janhan tjétjo̱nka̱rá nkehe ntoá ntá títekákonnahyará. ");
INSERT INTO poeNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Á tjejorá jnkojínrá nohará nkerí jie̱ kjuásian janhan? A̱ ntá tí ntáxrja̱n tí nkehe ntoá, ¿ntá nkekuènté títekákonnahyará? ");
INSERT INTO poeNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Tí sín tinkáchónki Dios mé tjinkaon sín chrókuinhin sín itén Dios. A̱ ntá jahará la tinkachónkihyará Dios ntá tjinkákonhyará chrókuinhínrá itén chꞌán ―ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","A̱ ntá tí sín judío ntáche sín tí chꞌín Jesús kíxin: ―Chaxín ntoá ntáchroni kíxin jaha mé ijnko chojni samaritano la ko chonta ijnko ncha̱kuen tí jínahya ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Janhan chontahya ninkehó ncha̱kuen tí jínahya. Tí xra̱ tꞌa̱ mé tjikosáya̱ha̱ Tꞌaná. Ntá jahará mé chontahyará kjuasáyé tí janhan. ");
INSERT INTO poeNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Janhan na tjéyáhya nkexro tsjikosáyana. Kjánchó itjen ijnko nkexro tjinkaon chꞌán chrókjuikosáyana chojni, a̱ ntá jehe chꞌán mé tsjanchia jie̱ tí sín kuítekakonhya. ");
INSERT INTO poeNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Imá tjetoan tí nkehe tjétjo̱nka̱rá kíxin tí tsítekáonrá tí nkehe tjàkua la í tsꞌénhyará ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ntá kjuáte̱he tí sín judío ntáchro sín kíxin: ―Ntá ó noheni kíxin chaxín chonta ijnko ncha̱kuen tí jínahya. Chꞌín Abraham la ko kaín tí sín kꞌuéchrónka itén Dios ósé la mé ikꞌuén sín. Ntá jaha ntáchrua kíxin tí tsitekaonni tí nkehe tjàkua jaha ntá í tsꞌenhyani, ichrua. ");
INSERT INTO poeNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Xá imá této̱an jaha la ntá kánhyó tꞌe̱to̱an itꞌéni Abraham? Jehe chꞌán la ikꞌuén chꞌán la ko kja̱xin ikꞌuén tí sín kꞌuéchrónka itén Dios ósé. ¿Xá nkexro tí jaha, ichrua? ―mé chro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Tí chrókjuíkosáya̱ha̱ a̱senná na mé sínkíhya tíha. A̱ ntá Tꞌaná mé tjikosàyana chꞌán na ntá jahará ntáchrorá kíxin jehe chꞌán mé Dios kuèntárá. ");
INSERT INTO poeNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Kjánchó chonhyará chꞌán. A̱ ntá janhan choxian chꞌán. Tí chróntáxrja̱n kíxin janhan chonhya chꞌán ntá chrókóyòna tí jahará chrókjui̱tꞌayahará. Kjánchó janhan na choxian chꞌán la ko nta̱xiteyáha̱ tí nkehe tꞌe̱to̱an chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Chꞌín Abraham tí nkexro tsíkꞌaxrjeníxinrá la imá kóchéhe̱ chꞌán kíxin tsꞌikon chꞌán tí ya̱on tsꞌinka janhan. Ntá ó kjuixin kꞌuíkon chꞌán ntá kóchéhe̱ chꞌán ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","A̱ ntá tí sín judío ntáche sín tí chꞌín Jesús kíxin: ―Jaha na̱xa̱ chontahya cincuenta nánó, ¿na ntá nkekuènté ntáchrua kíxin ó kꞌuíkuan tí chꞌín Abraham? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Imá tjetoan tí nkehe tjétjo̱nka̱rá kíxin na̱xa̱ kohya chꞌín Abraham mé xráxín itjén janhan ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ntá kuákja sín xro̱ chróchjéhe sín tí chꞌín Jesús. Kjánchó kjuákꞌemá chꞌán ni̱nko ntá chrꞌéxi̱n kꞌuaxrjexín chꞌán ntiha. Kꞌuátsínka chꞌán jnko̱siné tí tjejó sín sákjuí chꞌán.﻿ ");
INSERT INTO poeNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Kꞌuátsínka sín ijnko nti̱a ntá kꞌuíkon chꞌín Jesús ntiha tjen ijnko chꞌín tsíkokjíexín tꞌikonhya chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ntá tí sín kꞌuájiko chꞌín Jesús kjuanchankíhi sín chꞌán kíxin: ―Maestro, ¿Nkekuènté tsíkokjíexín chꞌán tꞌikonhya chꞌán? ¿Á iji̱é itꞌé o̱ ìné chꞌán o̱ á iji̱é chꞌán? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Jehya iji̱é chꞌán la ko jehya iji̱é itꞌé la ko ìné chꞌan. Náhí. Jehí xi̱kaha tsíkónhen chꞌán kíxin tí kjua̱cha̱xién Dios tsja̱ko̱xi̱n kíxin tsito̱exín chꞌán jína. ");
INSERT INTO poeNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Na̱xa̱ ncha̱kotjin tꞌichjánxi̱n si̱tꞌa tí xra̱ tjinkaon tí nkexro tsíchrꞌánna. Ntá tsꞌixin tie ntá kohya ninkexró tsjacha sichꞌe xra̱. ");
INSERT INTO poeNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Na̱xa̱ itjén janhan mé ntihi chjasintajni na mé janhan xrohi tꞌinkaséyanxín tí chjasintajni ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ntá ó kjuixin ntáchro chꞌán tíha ntá kui̱ki̱te chꞌán nta̱ten chꞌán intsí nche kꞌóna nche̱tꞌo̱ ntá kuátematóxin chꞌán ikon tí chꞌín tꞌikonhya. ");
INSERT INTO poeNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ntá kꞌue̱tue̱nhen chꞌán tí chꞌín tꞌikonhya kíxin: ―Sátjia tí pila tjiá nta̱ itꞌin Siloé tꞌontia kuan ―ichro chꞌán. (A̱ ntá tí ihni̱é Siloé mé tꞌaxrjexín nkíve̱e sín kíxin Kꞌuítuenhen.) Ntá sákjuí tí chꞌín tꞌikonhya kꞌónti chꞌán ikon chꞌán ntá kjan chꞌán kꞌuíkon chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ntá tí sín nto̱e chjinaxón nto̱e chꞌán la ko tí sín kꞌuékꞌikon sín kíxin tꞌikonhya chꞌán mé ntáchro sín kíxin: ―¿Á jehya tí chꞌín i kꞌuékjakꞌetja̱xi̱n chꞌán kꞌuékjanchakꞌá chꞌán? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Iso sín ntáchro sín kíxin: ―Kjá chaxín jehe chꞌán ―ichro sín. Ikjé sín ntáchro sín kíxin: ―Náhí, jehya jehe chꞌán. Tóyóhó chꞌán tí chꞌín a ―ichro sín. Kjánchó jehe chꞌán kjuáte̱he chꞌán kíxin: ―Chaxín janhan ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ntá kjuanchankíhi sín chꞌán kíxin: ―¿Nkexrí kíxin jaí tꞌikuan jaha? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ntá kjuáte̱he chꞌán ntáchro chꞌán kíxin: ―Ijnko chꞌín mé itꞌin Jesús mé kjuíchꞌéna chꞌán nche̱tꞌo̱ kuátematóxin chꞌán kua̱n la ntá kꞌue̱tua̱nna chꞌán kixin satsjia ti pila tjiá nta̱ nchekꞌin sín Siloé tsꞌontia kua̱n, ichro chꞌán. Ntá sákjuia kꞌontia, ntá xrína̱hya ó kꞌuíkua̱n ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ntá kjuanchankíhi sín chꞌán ntáchro sín kíxin: ―¿Nketí tjen tí chꞌín a? ―ichro sín. Ntá kjuáte̱he chꞌan ntachro chꞌan kixin: ―Nonahya janhan ―ichro chꞌan. ");
INSERT INTO poeNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ntá tí sín a sákjuíko sín tí chꞌín kꞌuékꞌikonhya sákjuíchréhe̱ sín tí sín fariseo a. ");
INSERT INTO poeNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","A̱ ntá tí ya̱on tꞌo̱kꞌéhe sín mé tsíkjichꞌéna chꞌín Jesús tí nche̱tꞌo̱ kjuínchekito̱exín jína tí chꞌín kꞌuékꞌikonhya. ");
INSERT INTO poeNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","A̱ ntá tí sín fariseo xíkjanchankíhi sín chꞌán ínaá kíxin nkexrí kuíto̱he chꞌán jína tꞌikon chꞌán jie. Ntá kjuáte̱he chꞌán ntáchro chꞌán kíxin: ―Kuátematóxin chꞌán nche̱tꞌo̱ kua̱n, ntá kꞌontia kua̱n ntá jie tꞌíkua̱n ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ntá iso tí sín fariseo ntáchro sín kíxin: ―Tí chojni a jehya kuènte Dios kíxin chóntahya chꞌán kjuasáyé tí ya̱on tꞌo̱kꞌéheni ―ichro sín. Kjánchó ikjé sín ntáchro sín kíxin: ―¿Xá nkexrí chrókjuasin chꞌán kjuaxroan jié tí chónta chꞌán jie̱? ―ichro sín. Mé xi̱kaha jnkokónhya kjuenka̱yáxin tí jehe sín. ");
INSERT INTO poeNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ntá xíkjanchankíhi sín tí chꞌín kꞌuékꞌikonhya ínaá kíxin: ―¿Ntá jaha nkechrua nkexro tíha tí nkexro kjuíntakꞌikuan? ―ichro sín. Ntá kjuáte̱he chꞌán ntáchro chꞌán kíxin: ―Janhan ntáxrja̱n kíxin jehe chꞌán mé ijnko nkexro chrónka itén Dios ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Kjánchó tí sín judío kuítekakonhya sín kíxin chaxín kꞌuékꞌikonhya chꞌán ntá jie tꞌikon chꞌán. Ntá kꞌuíye̱he̱ sín tí itꞌé la ko tí ìné tí chꞌín tsíkito̱he jína. ");
INSERT INTO poeNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Kjuanchankíhi sín ntáchro sín kíxin: ―¿Á xja̱an tíhi tí ntáchrorá kíxin tí tsíkokjíexín chꞌán tꞌikonhya chꞌán? ¿Ntá nkexrí jie tꞌikon chꞌán? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ntá kjuáte̱he tí itꞌé la ko tí ìné chꞌán ntáchro sín kíxin: ―Ó noheni kíxin xje̱enni chꞌán la ko noheni kíxin tí kokjíexín chꞌán tꞌikonhya chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Kjánchó noehyani nkexrí kíxin tꞌikon chꞌán jie la ko noehyani nkexro kjuínchekito̱he chꞌán jína. Tjanchankíhírá chꞌán, ó nte̱to chꞌán, ntá jehe chꞌán tsochrónka chꞌán kíxin nkexrí kuíto̱he chꞌán jína ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Mé xi̱kaha kjuáte̱he tí itꞌé la ko tí ìné chꞌán kíxin chrako̱nhe̱n sín tí sín judío kíxin ó kjuixin chrónka tí sín judío kíxin tsjanjonhya sín kjuachaxin tsꞌixenhen ni̱nko tí sín titekaon kíxin chꞌín Jesús mé tí nkexro Cristo. ");
INSERT INTO poeNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Mé xi̱kaha ntáchro tí itꞌé la ko tí ìné chꞌán kíxin chrókjuanchankíhi sín chꞌán, ó nte̱to chꞌán, ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ntá yóxin xíkꞌíye̱he̱ tí sín judío tí chꞌín kꞌuékꞌikonhya ntá kꞌue̱tue̱nhen sín chꞌán kíxin: ―Tjetsjehe Dios ntá ntoá chro̱nka kíxin ó noheni kíxin tí chꞌín a na chónta chꞌan jie̱ ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ntá tí chꞌín kꞌuékꞌikonhya kjuáte̱he chꞌán kíxin: ―Nonahya á chónta chꞌán jie̱ o̱ á chóntahya chꞌán jie̱. Jnkoko̱á nkehe nòna kíxin senó kꞌuékꞌíko̱nhya ntá jie tꞌíkua̱n ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ntá xíkjanchankíhi sín chꞌán ínaá kíxin: ―¿Nkexrí kjuíchꞌe chꞌán kíxin kjuíntakꞌikuan chꞌán? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ntá kjuáte̱he chꞌán ntáchro chꞌán kíxin: ―Ó kjuixin tjo̱nka̱rá kjánchó títekákonhyará. ¿Nkekuènté tjinkáonrá kíxin tso̱tjo̱nka̱rá ínaá? ¿Á kja̱xinrá tjinkáonrá tsochréhérá chꞌán? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ntá kónínkakonhen sín chꞌán la kꞌuántaxínhi̱n sín chꞌán la ko kjuáte̱he sín kíxin: ―Jaha la chréhé tí chojni a. A̱ ntá jeheni na chréhe̱ni tí nkehe kꞌue̱to̱an chꞌín Moisés. ");
INSERT INTO poeNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ó noheni kíxin Dios kꞌuénixje̱he̱ chꞌín Moisés. A̱ ntá tí chꞌín a la noehyani nketí tsíkji̱xi̱n chꞌán ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ntá kjuáte̱he tí chꞌín ntáchro kíxin: ―Imá ókjé tíha. Tí chꞌín a mé kjuínchekꞌikonna. A̱ ntá jahará ntáchrorá kíxin noahyará nketí tsíkji̱xi̱n chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ó noheni kíxin tienhya Dios tí nkehe tjanchia tí chojni chónta jie̱. Jehó tinhin chꞌán tí nkehe tjanchia tí sín titekaon Dios la ko nchexiteyéhe̱ sín tí nkehe tjinkaon chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nunca kienhyéni kíxin ijnko nkexro chrókjuinchekꞌikon ijnko chojni tsíkokjíexín tꞌikonhya. ");
INSERT INTO poeNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","A̱ ntá tí nkexro a tí chrókui̱xi̱nhya chꞌán tí tjen Dios la kjá ninkehó nkehe xitjahya chrókjuichꞌe chꞌán ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ntá kjuáte̱he tí sín fariseo ntáchro sín kíxin: ―Jaha la nchónhya jie̱ chonta tió kokjíha. A̱ ntá jie ¿á tjinkávan kíxin jaha chrókjuákohéni ní? ―ichro sín. Ntá kótéka sín tí chꞌín a kíxin tsꞌaxrjexín chꞌán tí ni̱nko a sátsji chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ntá kuínhin chꞌín Jesús kíxin xi̱kaha kꞌue̱tue̱nhen tí sín judío kíxin tsꞌaxrjexín ni̱nko tí chꞌín kꞌuékꞌikonhya. Ntá xeta chꞌín Jesús tí chꞌín a ntá kjuanchankí chꞌán kíxin: ―¿Á tinkachónkia tí Xje̱en Dios Kꞌóna Chojni? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ntá kjuáte̱he tí chꞌín a ntáchro chꞌán kíxin: ―Tjákohéni nkexro tíha kíxin ntá tsinkáchónkini chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Ó kꞌuíkuan jaha. Janhan mé tí nkexro tjetjuá jaha ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ntá kjuákꞌexín tochꞌin chꞌán to̱té chꞌín Jesús ntáchro chꞌán kíxin: ―Ijie kuíteka̱van tí jaha Ìnchéni ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ntá ntáchro chꞌín Jesús kíxin: ―Kꞌuinka ntihi chjasintajni kíxin si̱ntakito̱axián iji̱é chojni kíxin ntá tí sín tꞌikonhya la mé tsꞌikon sín, a̱ ntá tí sín tꞌikon jie la í tsꞌikonhya sín ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","A̱ ntá iso tí sín fariseo kꞌuéjóntaxín kuínhin sín kíxin xi̱kaha ntáchro chꞌín Jesús, ntá kjuanchankíhi sín chꞌán kíxin: ―¿Xá kja̱xin jeheni ntakótáni? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―A̱ ntá tí jahará tí chaxín chrókꞌuikonhyará ntá chróchontahyará jie̱. Kjánchó ntáchrorá kíxin tꞌikonrá. Méxra̱ chontará jie̱ ―ichro chꞌán.﻿ ");
INSERT INTO poeNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ntá ntáchro chꞌín Jesús kíxin: ―Imá tjetoan tí nkehe tjétjo̱nka̱rá kíxin tí tsꞌixenhen ijnko chojni tí tꞌinkachjina kolélo ntá jehya puerta tí corral tꞌixenxín chꞌán na mé ókjé chrokꞌuixenxín chꞌán na mé xíche̱e tíha la tjinkaon chrókueé. ");
INSERT INTO poeNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","A̱ ntá tí nkexro tꞌixenxín tí puerta na mé nkexro tꞌayakonhen tí kolélo a. ");
INSERT INTO poeNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","La ko tí chꞌín tjetꞌayakonhen tí puerta a mé tsakitje̱he̱ chꞌán tí puerta a kíxin tsꞌixenhen tí nkexro chaxín tꞌayakonhen tí kolélo a. A̱ ntá tí kolélo a mé tsjatso̱an va itén chꞌán. Ntá tꞌíye̱xi̱n chꞌán jnkojnko ihni̱é jnkojnko tí kolélo kuènte chꞌán ntá tsꞌaxrjexín va nto̱e va. ");
INSERT INTO poeNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ntá tꞌikon chꞌán kíxin kꞌuaxrje kaín va ntá kuítonhen chꞌán va nti̱a ntá tinkáchréhe̱ va kíxin tjatso̱an va itén chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Chrohya va tjichréhe̱ va ijnko chojni ókjé na mé tsinkéhe va tí chojni a kíxin tjatso̱anhya va itén ókjé chojni ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Mé xi̱kaha ntáchro chꞌín Jesús kjuíncheyóe̱xin chꞌán. Kjánchó tienxínhya sín nkexrí tꞌaxrjexín tíha. ");
INSERT INTO poeNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ntá chrónka chꞌín Jesús ínaá ntáchro chꞌán kíxin: ―Ijnko nkehe tjetoan tso̱tjo̱nka̱rá kíxin janhan la éxí tí puerta tꞌixenxín tí kolélo tí tꞌinkachjina va. ");
INSERT INTO poeNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Kaín tí sín kuitónxin nti̱a kui senó mé xíche̱e la ko chrókueé. La ntá tí kolélo la ánto̱sén va tí nkehe ntáchro tí jehe sín. ");
INSERT INTO poeNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Janhan mé tí puerta a mé tꞌixe̱nxínrá tí janhan mé tsaárá la mé tso̱yóha̱rá tí kolélo siín kjuachaxin tsꞌaxrjexín va tí kòrré va sátsjikjine va la ko siín kjuachaxin tsꞌixenhen va tí tsꞌinkachjina va ínaá. ");
INSERT INTO poeNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’A̱ ntá xíche̱e mé jehó chrókueé la ko tjinkaon chrókꞌóyán la ko chrókjuinchekꞌitjáyan kaín nkehe. A̱ ntá janhan kꞌuinka kíxin tsochontaxinrá kjuachón na mé kjuachón jnkochríxín. ");
INSERT INTO poeNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Janhan mé ijnko pastor jína a̱ ntá tí pastor jína mé tsꞌenyákonhe̱n tí kolélo a. ");
INSERT INTO poeNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","A̱ ntá tí nkexro chꞌe xra̱ tjinkaon chrókjuacha ó na mé tsꞌikon chꞌán itsi ijnko kolobo tsíto̱he chꞌán tí kolélo sátsji chꞌán kíxin jehe chꞌán la jehya tí nkexro tꞌayakonhen tí kolélo la ko jehya kolélo kuènte chꞌán. Ntá tí kolobo mé tsotsé va tí kolélo ntá tsinká va la sátsjichroe va. ");
INSERT INTO poeNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Mé xi̱kaha tí chojni tjinkaon chrókjuacha tí xra̱ chrókjuichꞌe ó la mé sátsji. A̱ ntá tí kolélo la ánto̱sén chꞌán kuáhya chꞌán kuenté tí jehe va. ");
INSERT INTO poeNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","’A̱ ntá janhan mé ijnko pastor jína. Mé xi̱kaha Tꞌaná chóxin chꞌán tí janhan la ko kja̱xin janhan choxian tí jehe chꞌán mé xi̱kaha choxian janhan tí sín éxí kolélo kuènta̱na la ko jehe sín mé chóxin sín tí janhan. Ntá tsꞌényákonha̱n tí sín éxí kolélo kuènta̱na. ");
INSERT INTO poeNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Kja̱xin chonta kolélo na̱xa̱ jehya kòrré va ntihi mé kja̱xin tꞌichjánxi̱n sátsjícakjián va. A̱ ntá tí tsitekakonna va ntá tsꞌóna jnkoko̱á kòrré va la ko jnkoko̱á nkexro tsꞌayakonhen va. ");
INSERT INTO poeNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Tjua̱na Tꞌaná kíxin kjónté itsꞌén la tsoxechónna ínaá. ");
INSERT INTO poeNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Kohya nkexro tsakitsjena tí kjuachón chonta janhan tí chrókjuánjonhya kjuachaxin. Chonta janhan kjuachaxin itsꞌén la ko chonta janhan kjuachaxin tsoxechónna ínaá. Tíhi mé kꞌue̱tua̱nna Tꞌaná ―ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Tió kuínhin tí sín judío tí nkehe ntáchro chꞌín Jesús ntá kjuankíxin jnkoko̱áhya kjuenka̱yáxin sín. ");
INSERT INTO poeNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Nchónhya tí jehe sín ntáchro sín kíxin: ―¿Nkekuènté tinhínrá tí nkehe ntáchro chꞌán? Jehe chꞌán mé chónta chꞌán ncha̱kuen tí jínahya la ko lóco chꞌán ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ntá ikjé sín ntáchro sín kíxin: ―Xi̱kahya chrónixja ijnko chojni chónta ncha̱kuen tí jínahya. ¿Á ijnko ncha̱kuen tí jínahya la á jína chrókjuinchekꞌikon ijnko chojni tꞌikonhya? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","A̱ ntá tí ncha̱kuen kin tí chjasin Jerusalén kꞌuíxin kia xraxinkakonxín sín tí ya̱on tsíkjixin tsíkꞌóna ni̱nko. ");
INSERT INTO poeNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ntá chꞌín Jesús itjen chꞌán tí ni̱nko tí nta̱sin kuènte Salomón. ");
INSERT INTO poeNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ntá tí sín judío kꞌuántatjen sín tí chꞌín Jesús kjuanchankíhi sín chꞌán kíxin: ―¿Hasta nkesá tsꞌejóchónhenni tsinhinni jína? A̱ ntá jie chro̱nka ntoá kíxin á chaxín jaha tí Cristo ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ntá kjuáte̱he chꞌín Jesús kíxin: ―Ó tjo̱nka̱rá ntá na̱xa̱ títekákonhyará. Kaín tí xra̱ tjétꞌa̱ janhan tí kjuachaxin kuènte Tꞌaná mé tja̱ko̱xi̱n nkexro tí janhan. ");
INSERT INTO poeNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Kjánchó jahará títekákonhyará kíxin jahará la jehya kolélo kuènta̱na éxí tjo̱nka̱rá senó. ");
INSERT INTO poeNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Tí kolélo kuènta̱na mé tjatso̱an va tí tanná la ko kja̱xin janhan tjátso̱an tí jehe va la ko jehe va mé chréhe̱ va tí janhan. ");
INSERT INTO poeNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Janhan mé tja̱ha̱ va tí kjuachón jnkochríxín la í tsꞌitjáyanhya va la ko ninkexró tsjachahya tsakitsjexín va tjaná. ");
INSERT INTO poeNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ó kjuanjon Tꞌaná, mé tí nkexro tjetóxin tꞌe̱to̱an, na ninkexró tsjacha tsakitsjexín va tí tja chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Janhan la ko Tꞌaná na mé jnkoko̱á nkexro tíha ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ntá tí sín judío kuákja sín xro̱ chróchjéhe sín chꞌán ínaá. ");
INSERT INTO poeNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Nchónhya nkehe jína kꞌuíkonrá kjuáko̱xia̱n kjuachaxin kuènte Tꞌaná. ¿Ntá nkekuènté chróchjìnárá xro̱? ―mé chro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ntá kjuáte̱he tí sín judío kíxin: ―Jehya tí kjuaxroan jína tjásian chrótjiáxiánni xro̱. Náhí. Jaha ijnko chojni ó ntá kjui̱ncheyóhé a̱sán Dios na mé tsotjiáxiánni xro̱ ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ntá ntáchro chꞌín Jesús kíxin: ―Ntá ntáchro xroon itén Dios tsíkjin sín ósé kíxin ntáchro Dios kíxin: “Kja̱xinrá éxí Dios tí jahará.” ");
INSERT INTO poeNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ntá ó noheni nkehe ntáchro xroon itén Dios na ntá xitjahya tsitekakonhyani tíha. Mé xi̱kaha ntáchro Dios kíxin éxí Dios jnkojnko nkexro kꞌuáyéhe̱ itén chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","A̱ ntá kjueyána Dios ichrꞌánna chꞌán chjasintajni, ¿ntá nkekuènté ntáchrorá kíxin kꞌuántaxínha̱n Dios kíxin janhan ntáxrja̱n kíxin Xje̱en Dios tí janhan? ");
INSERT INTO poeNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Kja̱ tí chrókjui̱tꞌahya tí xra̱ ichꞌe Tꞌaná la chrókuítekákonhyará. ");
INSERT INTO poeNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","A̱ ntá kjónté tjétꞌa̱ tí xra̱ a kjónté títekákonhyará tí janhan na mé chrókuítekáonrá tí xra̱ tjétꞌa̱ chrókónoaxínrá chrókiénxinrá kíxin Tꞌaná la ko janhan mé jnkoko̱á tjékian chꞌán ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Mé xi̱kaha chrótsé sín tí chꞌín Jesús ínaá chrókꞌuikjéhe̱ chꞌán ntá kjuachahya sín ntá sákjuí chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ntá chꞌín Jesús xíkjan chꞌán tí í jnko lado nta̱río Jordán ínaá tí kꞌuékjakꞌe chꞌín Juan kꞌuéki̱ki̱texín chꞌán chojni senó. ");
INSERT INTO poeNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ntá nchónhya chojni sákjuíchréhe̱ sín chꞌán tsꞌikon sín chꞌán ntáchro sín kíxin: ―Chaxín chꞌín Juan kjuasinhya chꞌán kjuaxroan jié la kjónté ntoá tí nkehe chrónka chꞌán kuènte tí chꞌín i ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ntá nchónhya sín kuítekaon sín tí chꞌín Jesús tí kjuíji sín ntiha.﻿ ");
INSERT INTO poeNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Itjen ijnko chꞌín níhi mé itꞌin chꞌán Lázaro, chjasén chꞌán na mé Betania, mé tí chjasén tí tjan María la ko tí kja̱vé tjan Marta. ");
INSERT INTO poeNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Tí tjan María mé jnkoko̱á kíchó tí chꞌín Lázaro mé tí chꞌín níhi na mé jehe tjan mé tí tjan kui̱ki̱texín aceite xraxé to̱té Ìnchéni la ko kjuínchexámáxin tjan ka̱xi̱hi tjan to̱té chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","A̱ ntá yóí tí kíchó chꞌán chjin ichrꞌán sín ijnko nkexro tsochénka tí chꞌín Jesús kíxin: ―Ìnchéni jaha, tí nkexro choxian tjuèhé la níhi chꞌán ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ntá kuínhin chꞌín Jesús ntá ntáchro chꞌán kíxin: ―Tí chin chónta chꞌán jehya kíxin ónaá chrókꞌuitjáyanxón chꞌán tí tsꞌen chꞌán. Náhí. Tíha mé tsja̱ko̱xi̱n tí kjuachaxin jié kuènte tí Xje̱en Dios ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","A̱ ntá tí chꞌín Jesús la imá tjuèhé chꞌán tí tjan Marta la ko tí tjan kíchó tjan la ko tí chꞌín Lázaro. ");
INSERT INTO poeNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Na ntá tió kuínhin chꞌán kíxin níhi chꞌín Lázaro na kjónté kuíto̱he chꞌán iyó ya̱on ínaá tí nó kjuákꞌe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","A̱ ntá chrꞌéxi̱n ntáche chꞌán tí sín kꞌuájiko chꞌán kíxin: ―Sátsjini estado Judea ínaá ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ntá kjuáte̱he tí sín kꞌuájiko chꞌán kíxin: ―Maestro, na̱xa̱ séhya tí sín judío ntiha chrótjáha sín xro̱ tjinkaon sín chrókꞌóyánxian sín xro̱. ¿Á tjinkávan sátsjia ntiha ínaá? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ntá ntáchro chꞌín Jesús kíxin: ―Jnkojnko ya̱on mé chónta teyó hora. Tió ixri chojni ncha̱kotjin tsóténki̱xi̱nhya sín ninkehó kíxin tꞌinkaséyanxín xrohi chjasintajni a. ");
INSERT INTO poeNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Tí sín ixri tie mé tsóténki̱xi̱n sín nkehe kíxin chóntahya sín xrohi ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ntá chrꞌéxi̱n ntáche chꞌín Jesús tí sín kꞌuájiko chꞌán kíxin: ―Ó kꞌuájua tí nkexro chóxinni mé chꞌín Lázaro. Ntá sátsjia si̱ntakjaya̱ha̱ chꞌán ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ntá ntáchro tí sín kꞌuájiko chꞌán kíxin: ―Ìnchéni, tí kꞌuájua chꞌán la mé chrókuito̱he chꞌán jína ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Kjánchó tí nkehe ntáchro chꞌín Jesús mé tꞌaxrjexín kíxin ó tsíkjixin tsíkꞌen tí chꞌín Lázaro. Ntá tí sín kꞌuájiko chꞌán kjuenka̱yáxin sín kíxin ó jehí tjejua chꞌín Lázaro. ");
INSERT INTO poeNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ntá ntoá chrónka chꞌín Jesús kíxin: ―Ó tsíkꞌen chꞌín Lázaro. ");
INSERT INTO poeNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ntá chàna kíxin kohyana ntiha kíxin mé xi̱kaha tsítekákonxínrá. A̱ ntá jie ìntárá sátsjitsjeheni chꞌán ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ntá chꞌín Tomás, kja̱xin ti̱ki̱texín sín chꞌán chꞌín Nóhé, mé ntáche chꞌán tí í so sín kíxin: ―Sátsjini koíni kaín ni tsꞌenka̱oni Ìnchéni ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ntá kjuíji chꞌín Jesús kuínhin chꞌán kíxin chꞌín Lázaro la ó chónta noó ya̱on tsíkji̱xravá chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","A̱ ntá tí chjasin Betania mé chjinaxón tí chjasin Jerusalén, chónta iyó kilómetro ko tꞌo̱ kjínxi̱n. ");
INSERT INTO poeNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","A̱ ntá itsjé tí sín judío sátsíkjitsjehe sín tí tjan Marta la ko tí tjan María tjejónixje̱he̱ sín kíxin kánhyó tsꞌává sín kíxin tsíkꞌén tí kíchó sín a. ");
INSERT INTO poeNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ntá kuínhin tjan Marta kíxin ó kui chꞌín Jesús ntá kꞌuaxrjexín tjan nchia tsjíxinhin nti̱a. A̱ ntá tí tjan María kuíto̱he tjan nchia. ");
INSERT INTO poeNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ntá tí tjan Marta ntáche tí chꞌín Jesús kíxin: ―Ìnchéni jaha. Chrókjuakꞌe ntihi ntá chrókꞌuenhya kíchó ni. ");
INSERT INTO poeNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Kjánchó ó nòna kíxin Dios tso̱tjáha kaín nkehe tsjanchehé chꞌán ―ichro tjan. ");
INSERT INTO poeNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ntá ntáchro chꞌín Jesús kíxin: ―Tsoxechón kíchuá ínaá ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ntá ntáchro tjan Marta kíxin: ―Ó nòna kíxin tsoxechón chꞌán tió tsoxechón kaín tí sín tsíkꞌen, tí ya̱on tsjixixín ―ichro tjan. ");
INSERT INTO poeNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ntá ntáchro chꞌín Jesús kíxin: ―Janhan mé nta̱xechón chojni la ko tsochónta sín kjuachón. Tí nkexro tsitekaon sín tí janhan na kjónté ó tsíkꞌen sín la na̱xa̱ si̱ntaxechón sín ínaá. ");
INSERT INTO poeNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","La ko kaín xín tí sín na̱xa̱ tjejóchón sín la tsitekaon sín tí janhan na tsꞌenhya sín. ¿Á títekávan xi̱kaha ní? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ntá ntáchro tjan kíxin: ―Chaxín Ìnchéni títeka̱van kíxin jaha mé Cristo, mé Xje̱en Dios, mé tí nkexro kui chjasintajni ―ichro tjan. ");
INSERT INTO poeNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ó kjuixin ntáchro tjan Marta xi̱kaha ntá sákjuíkꞌíye̱he̱ tjan kíchó tjan María ntá imó chénka tjan kíxin: ―Ntiha tjen Maestro tꞌiya̱há chꞌán ―ichro tjan. ");
INSERT INTO poeNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ntá kuínhin tjan María ntá tuénxín kꞌuínkatjen tjan sákjuítsjehe tjan tí chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Na̱xa̱ tsíkꞌixenhya chꞌán chjasin na̱xa̱ tjen chꞌán tí xéta chꞌán tjan Marta. ");
INSERT INTO poeNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ntá tí sín judío tjejónixje̱he̱ tjan María kíxin kánhyó tsꞌává tjan, mé kꞌuíkon sín kíxin tjoka kꞌuaxrjexín tjan nchia, ntá kjuíchréhe̱ sín tjan kjuenka̱yáxin sín kíxin sátsji tjan tí tsíkji̱xravá kíchó tjan, ntaha tsjitsjánkàma̱ tjan chꞌán, ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ntá tí tjan María mé kjuíji tjan tí tjen chꞌín Jesús ntá kjuákꞌexín tochꞌin tjan to̱té chꞌán ntáchro tjan kíxin: ―Ìnchéni jaha, chrókjuakꞌe jaha ntihi ntá chrókꞌuenhya kíchiná ―ichro tjan. ");
INSERT INTO poeNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ntá kꞌuíkon chꞌín Jesús kíxin tsjánka tí tjan María la ko tí sín judío kjuikotoxi̱n tjan ntá imá kꞌuává chꞌán kóxakonhen a̱sén chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ntá kjuanchankí chꞌán kíxin: ―¿Nketí kjua̱várá chꞌán? ―ichro chꞌán. Ntá ntáchro sín kíxin: ―Ìnchéni, ¿á sátsjitsjehé? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ntá tsjánka chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ntá ntáchro tí sín judío kíxin: ―Tsjehérá kíxin imá tjuèhe chꞌán tí chꞌín tsíkꞌen ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Kjánchó í so sín ntáchro sín kíxin: ―Jehe chꞌán mé kjuínchekꞌikon tí chꞌín tꞌikonhya. ¿Á xitjahya chrókjuanjon chꞌán intsí kjuachaxin chrókꞌuenhya tí chꞌín Lázaro ní? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ntá imá tꞌává a̱sén chꞌín Jesús kóchjinehe chꞌán tí tòye̱. Tí tòye̱ mé ijnko tjo̱, a̱ ntá tí ntója tí tjo̱ mé tsíkꞌikjèxin ijnko xro̱. ");
INSERT INTO poeNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ntá kꞌue̱to̱an chꞌín Jesús kíxin: ―Tjakjíyan tí xro̱ a ―ichro chꞌán. A̱ ntá tí tjan Marta mé kíchó tí nkexro kꞌuén mé ntáchro tjan kíxin: ―Ìnchéni, kjá noha kíxin kjá imá xra kíxin ó chónta noó ya̱on tsíkꞌen chꞌán ―ichro tjan. ");
INSERT INTO poeNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Ó tjo̱nka kíxin tsítekávan ntá tsꞌikuan tí kjuachaxin jié kuènte Dios ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ntá kjuakjìin sín tí xro̱ a. Ntá chꞌín Jesús konta chꞌán nka̱jní ntáchro chꞌán kíxin: ―Itꞌéni, tjáncháha kjuasáya kíxin ó kuínhín tí nkehe ntáxrja̱n. ");
INSERT INTO poeNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Janhan na ó nòna kíxin xráxín tjetinhín tí nkehe ntáxrja̱n ntá xi̱kaha ntáxrja̱n jie kíxin tsinhin tí sín tjejóntaxín ntihi ntá tsitekaon sín kíxin jaha mé kuéto̱an kꞌuinka ―mé ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ntá kjuixin nixja chꞌán tíha ntá itsen kꞌuèya chꞌán kíxin: ―¡Lázaro, tꞌaxrjéxian méhe̱! ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ntá tí chꞌín tsíkꞌen kꞌuaxrjexín chꞌán tòye̱, na tí tja chꞌán la ko tí to̱té chꞌán na̱xa̱ tjejóchróntetoxín ka la ko tí nkayakon chꞌán tjekjèxin ijnko ka. Ntá kꞌue̱to̱an chꞌín Jesús kíxin: ―Tjasinta̱nka̱rá tí ka chróntetoxín chꞌán kíxin jína tsji chꞌán ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ntá itsjé tí sín judío sákjuíkotoxi̱n sín tí tjan María mé kꞌuíkon sín tí kjuaxroan kjuasin chꞌín Jesús ntá kuítekaon sín tí jehe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Kjánchó iso tí jehe sín sákjuítsjehe sín tí sín fariseo kjuíchénka sín tí kjuaxroan tsíkjasin chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ntá tí sín fariseo la ko tí sín ncha̱tꞌá tꞌe̱to̱an jnkoko̱á kójnkotséko sín tí sín a̱ntsí tꞌe̱to̱an, la ntáchro sín kíxin: ―¿Xá nkexrí chrókjuichꞌeheni tí chꞌín a kíxin jehe chꞌán mé tjasin chꞌán kjuaxroan jié? ");
INSERT INTO poeNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","A̱ ntá tí chrókuíto̱heni chꞌán xi̱kahó ntá kaín xín chojni chrókuitekaon sín tí jehe chꞌán, ntá tsi tí sín romano tꞌe̱to̱an sinchekꞌitjáyan sín tí ni̱nko̱éni la ko tí xra̱ chóntani la ko tí nación kuènténi ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ntá chꞌín Caifás mé tí nkexro tꞌe̱tue̱nhen tí sín ncha̱tꞌá tí nánó a ntáche chꞌán tí jehe sín kíxin: ―Jahará la noahyará ninkehó tíha ");
INSERT INTO poeNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","la ko kjá ní tjenka̱yáxinhyará kíxin íchá jína kíxin jnkoko̱á chojni chrókꞌuenyákonhe̱n chjasénni kíxin ntá chrókꞌuitjáyanhya kuenté tí nación kuènténi ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kjánchó chꞌín Caifás la jehya jehó chꞌán chrókjuenka̱yáxin chꞌán tíha. Náhí. Jehe chꞌán mé kꞌue̱tue̱nhen tí sín ncha̱tꞌá tí nánó, a̱ ntá tí Ncha̱kuen Dios kjuínchekónohe chꞌán kíxin chꞌín Jesús mé tsꞌenyákonhe̱n tí nación judía. ");
INSERT INTO poeNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","A̱ ntá jehya tí nación kuènte sín ó chrókꞌuenyákonhe̱n chꞌán. Náhí. Kja̱xin kíxin sinchekaá chꞌán kaín tí sín tsꞌóna xje̱en Dios tjejó sín kuenté chjasintajni. ");
INSERT INTO poeNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","A̱ ntá tí ya̱on a tí sín tꞌe̱tue̱nhen tí sín judío mé kjuankíxin sín kjuenka̱yáxin sín kíxin chrókꞌóyán sín tí chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","A̱ ntá chꞌín Jesús la í noxínhya kꞌuáji tí kꞌuéjó tí sín judío, na mé kꞌuaxrjexín chꞌán tí estado Judea, sákjuí chꞌán chjinaxón nte̱je̱, tí tjen ijnko chjasin itꞌin Efraín. Ntaha kuíto̱eko chꞌán tí sín kꞌuájiko chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ntá í séhya ntá tsꞌixin tí kia pascua mé ijnko kié tí sín judío. Ntá itsjé chojni kꞌuaxrjexín sín chjasén sín sákjui̱ sín chjasin Jerusalén kíxin ntaha tso̱yaxínhin sín kíxin tsotjóá sín kjónté na̱xa̱ xrankíxinhya tsꞌixin tí kia pascua. ");
INSERT INTO poeNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ntaha kꞌuájikjeyá sín tí chꞌín Jesús kꞌuéjóxenhen sín tí ni̱nko jié ntá kjuanchankíhi sín kíchó sín kíxin: ―¿Jahará nkechrorá? ¿Á chrókjui chꞌán tí kia ní o̱ náhí? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","A̱ ntá tí sín fariseo la ko tí sín tꞌe̱tue̱nhen tí sín ncha̱tꞌá na ó kꞌue̱to̱an sín kíxin tí siín ijnko nkexro nohe nketí tjen chꞌín Jesús chróchrónka sín kíxin ntá jína chrókjuitsé sín chꞌán chrókjuinchenteto sín chꞌán la ko chrókjua̱kꞌe̱chji̱na sín chꞌán.﻿ ");
INSERT INTO poeNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Na̱xa̱ tꞌitjáyan injon ya̱on ntá tsꞌixin tí kia pascua. A̱ ntá chꞌín Jesús sákjui̱ chꞌán chjasin Betania tí tjen chꞌín Lázaro. Tí chꞌín Jesús mé tsíkjinchexechón chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ntá ntiha kjóne sín ijnko kónjín kjuikosáyehe sín tí chꞌín Jesús. A̱ ntá tí tjan Marta mé kjuíncheyaxín tjan. A̱ ntá tí chꞌín Lázaro la ko í so sín kꞌuéjó sín kjóneko sín tí chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ntá tjan María kui̱ka̱o tjan itꞌo̱ litro aceite tsíkꞌóna xro̱a̱n nardo imá tjete tsíkꞌe̱naxín tjan ntá kjuíncheka tjan to̱té chꞌín Jesús ntá ka̱xi̱hi tjan kjuínchexámáxin tjan tí to̱té chꞌán. Na mé kuenté nkaxenhen nchia kókaxraxé tí xro̱a̱n. ");
INSERT INTO poeNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ntá chꞌín Judas Iscariote, itꞌé chꞌán mé itꞌin Simón, jehe chꞌán mé ijnko tí sín kꞌuájiko chꞌín Jesús, na mé tí chꞌín sinchekji tí chꞌín Jesús chrꞌéxi̱n, mé ntáchro chꞌán kíxin: ");
INSERT INTO poeNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿Nkekuènté kóxihya tí xro̱a̱n xraxé, chrókóxi̱xi̱n iní ciento chichaon denario kíxin chrókjuinki̱tsa tí sín nòa? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Kjánchó chꞌín Judas la jehya ntáchro chꞌán xi̱kaha kíxin chrókui̱konóe̱he̱ chꞌán tí sín nòa. Náhí. Ntáchro chꞌán tíhi kíxin xráxín che̱e chꞌán kíxin jehe chꞌán tꞌayakonhen chꞌán tí nkehe tjinká chichaon ntá xráxín teé chꞌán tí chichaon tsíxrenájín ntiha. ");
INSERT INTO poeNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ntá ntáchro chꞌín Jesús kíxin: ―Nté ti̱to̱hérá tjan. Tsíkja̱kꞌe̱chji̱na tjan tí xro̱a̱n a kíxin tí ya̱on tsoxrávána. ");
INSERT INTO poeNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Tí sín nòa jnkochríxín tsꞌejokoará sín. A̱ ntá janhan jnkochríxínhya tsꞌejóni ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","A̱ ntá itsjé tí sín judío kꞌuíxikónohe sín kíxin chꞌín Jesús kjuákꞌe chꞌán tí chjasin Betania, a̱ ntá sákjuí sín ntiha. Jehya kíxin chrókjuitsjehe sín tí chꞌín Jesús ó. Náhí. Kja̱xin tjinkaon sín chrókjuitsjehe sín tí chꞌín Lázaro mé tí chꞌín tsíkjinchexechón chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ntá tí sín ncha̱tꞌá tꞌe̱to̱an mé kójnkotsé sín kjuenka̱yáxin sín chrókꞌóyán sín tí chꞌín Lázaro kja̱xin ");
INSERT INTO poeNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","kíxin itsjé tí sín judío kuítekaon sín tí chꞌín Jesús kíxin xi̱kaha kjuínchexechón chꞌán tí chꞌín Lázaro ntá kꞌuaxrjekjanxín sín tí sín ncha̱tꞌá. ");
INSERT INTO poeNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Nchónhya chojni sátsíkji̱ sín chjasin Jerusalén kíxin tí kia pascua. A̱ ntá tí ya̱on chrꞌéxi̱n kꞌuíxikónohe sín kíxin tsjiji chꞌín Jesús tí chjasin ntiha. ");
INSERT INTO poeNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ntá kóchrínjin sín chaan ntakajni kjuíxinhin sín nti̱a itsji chꞌín Jesús, itsje sín, ntáchro sín kíxin: ―Tjancheheni Dios kjuasáya. Imá jína tí nkexro kui̱xi̱n tí kjua̱cha̱xién Itꞌéni tjen nkaya nka̱jní. Imá jína tí chꞌín Rey tsꞌe̱tue̱nhen tí nación Israel ―ichro sín itsje sín. ");
INSERT INTO poeNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ntá tsíkꞌitja chꞌín Jesús ijnko kolócho la ntá kjuákꞌekjen chꞌán, éxí nixja itén Dios kíxin: ");
INSERT INTO poeNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Chrakonhyará jahará tjejorá chjasin Jerusalén, tsjehérá ó tjekui tí chꞌín Rey kuèntárá, tjekjen chꞌán ijnko kolócho. ");
INSERT INTO poeNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","A̱ ntá tió kónhen tíha kíenxínhya tí sín kꞌuájiko chꞌín Jesús kíxin nkekuènté xi̱kaha kónhen. A̱ ntá chrꞌéxi̱n tió kjuixin sákjui̱jia chꞌán nkaya nka̱jní ntá xraxinkaon sín kíxin xi̱kaha tsíkjin tí sín kꞌuéchrónka itén Dios ósé nkexrí tso̱nhen chꞌán, na ntá xi̱kaha chaxín xiteyá tí chrónka sín senó kíxin xi̱kaha tso̱nhen chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Mé xi̱kaha kaín tí sín tsíkójnkotsé tí kjuákꞌe chꞌín Jesús tió kꞌuíye̱he̱ chꞌán tí chꞌín Lázaro kíxin tsꞌaxrjexín chꞌán tí tòye̱ tsíkji̱xravá chꞌán ntá xechón chꞌán mé tí sín a mé chrónka sín tí nkehe kꞌuíkon sín. ");
INSERT INTO poeNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Mé xi̱kaha sákjuíxinhin sín tí nti̱a tsji̱xi̱n chꞌín Jesús, kꞌuíxikónohe sín kíxin xi̱kaha tsíkjasin chꞌín Jesús tí kjuaxroan jié. ");
INSERT INTO poeNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Mé xi̱kaha ntáchro tí sín fariseo itjo sín kíchó sín kíxin: ―Tsjehérá kaín rá, ninkehó tsjachahyani sichꞌeni kíxin kaín xín chojni sákjuíchréhe̱ tí jehe chꞌán ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Iso sín nixja griego kꞌuéjóyákjan tí sín sákjui̱ sín tí kia chjasin Jerusalén tsoxraxinkakonxín sín Dios. ");
INSERT INTO poeNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ntá kóchjinehe sín tí chꞌín Felipe, chjasén chꞌán mé Betsaida, estado Galilea, chrónóe̱he̱ sín chꞌán kíxin: ―Tjinkaonni chrókꞌuikonni tí chꞌín Jesús ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ntá chꞌín Felipe sákjuíchenka chꞌán tí chꞌín Andrés. Na ntá yóí sín sákjuíchenka sín tí chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ntá ntáchro chꞌín Jesús kíxin: ―Ó kjuixraká tí ya̱on, a̱ ntá tí Xje̱en Dios Kꞌóna Chojni mé sátsji̱ chꞌán tsꞌáyéhe̱ chꞌán tí kjuachaxin kuènte Itꞌé. ");
INSERT INTO poeNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","A̱ ntá tso̱tjo̱nka̱rá ijnko nkehe chaxín kíxin tí chrókjuítsínkahya ijnko noatrigo tí nche chrókꞌuenhya tí noa a, ntá jnkoko̱á noa chrókjuakꞌe. A̱ ntá tí chrókꞌuen tí noa a ntá chrókꞌóna nchónhya noa kíxin chrótjá sín. ");
INSERT INTO poeNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","A̱ ntá tí nkexro imá tjuèhe̱ a̱sén kíxin kohya nkehe chrókꞌuatsínka na mé tsochóntahya chꞌán kjuachón jnkochríxín. A̱ ntá tí nkexro tjekuènhya a̱sén kjónté chrókꞌuénxin ntihi chjasintajni tí chrónka chꞌán itén Dios na mé chrꞌéxi̱n tsochónta chꞌán kjuachón jnkochríxín. ");
INSERT INTO poeNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","A̱ ntá tí jnkojín nkexro tjinkaon chrókjuichꞌena sín xra̱ tꞌichjánxi̱n tsochréhe̱ sín tí janhan. A̱ ntá tí tjén janhan na mé kja̱xin tjejó tí sín chꞌena sín xra̱. A̱ ntá jnkojín sín sichꞌena sín xra̱ xi̱kaha na mé Tꞌaná mé tsjikosáyehe tí jehe sín. ");
INSERT INTO poeNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Ntá jie imá tóxakonhen a̱senná. ¿Nkehe chróntáxrja̱n? ¿Á chrókjuáncháha̱ Tꞌaná kíxin sinchekaána chꞌán tí nkehe tso̱na jie o̱ náhí? Kjánchó xra̱ ó kꞌuinka xi̱kaha tso̱na. ");
INSERT INTO poeNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Jaha Itꞌéni, tjáko̱xian tí kjuachaxin kuènte ihni̱á ―ichro chꞌán. Ntá kuínhin sín nixja ijnko nkexro nka̱jní ntáchro kíxin: ―Ó kjuixin kjuáko̱xia̱n tí kjuachaxin la ko xi̱kaha xikjáko̱xia̱n ínaá. ");
INSERT INTO poeNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","A̱ ntá tí sín tjejóntaxín tsíkinhin sín mé ntáchro sín kíxin kjónta, la ko í so sín ntáchro sín kíxin: ―Ijnko chꞌín ángel nixje̱he̱ chꞌán ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Kjánchó ntáchro chꞌín Jesús kíxin: ―Náhí. Jehya kíxin janhan tí jie chrókui̱nha̱n tí nixja chꞌán. Náhí. Nixja chꞌán kíxin tsinhínrá jahará. ");
INSERT INTO poeNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ntá jie tsito̱exín tí iji̱é chojni chjasintajni na mé tí nkexro tꞌe̱to̱an chjasintajni mé tsꞌaxrjehe chꞌán tí xra̱ tꞌe̱to̱an chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","A̱ ntá tió tsjakꞌénka̱nia ijnko ntacruz ntá nchónhya sín tsꞌikon sín ntá tsitekaon sín tí janhan ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Mé xi̱kaha chrónkaxín chꞌán kíxin nkexrí tsꞌenxín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","A̱ ntá kjuáte̱he tí sín ntiha ntáchro sín kíxin: ―Kuínhinni nchekuáxin sín tí xroon tsíkjin sín ósé chrónka kíxin Cristo la jnkochríxín tsjakꞌe chꞌán. ¿Ntá nkekuènté ntáchrua kíxin tí Xje̱en Dios Kꞌóna Chojni tꞌichjánxi̱n tsjakꞌenkáni chꞌán ijnko ntacruz? ¿Xá nkexéhe tí Xje̱en Dios Kꞌóna Chojni? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ntá ntáchro chꞌín Jesús kíxin: ―Na̱xa̱ tjen tí xrohi tjejókoará, kjánchó í séhya tsjakꞌe. Chrókꞌuajirá tí na̱xa̱ tjen ti xrohi tꞌinkaséyanxín nti̱a. A̱ ntá náhí la ó tsꞌixin tie. A̱ ntá tí sín ixri tí sítié a mé noehya sín nketí sátsji sín. ");
INSERT INTO poeNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Títekáonrá tí xrohi tí na̱xa̱ tjen tꞌinkaséyan kíxin mé tsꞌónará chojni kuènte tꞌinkaséyan ―ichro chꞌán. Ntá kjuixin chrónka chꞌín Jesús tíha ntá sákjuí chꞌán kjuákꞌeméhe chꞌán tí jehe sín. ");
INSERT INTO poeNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Kꞌuékjasin chꞌín Jesús nchónhya kjuaxroan jié kꞌuíkonxín kon sín ntá kjónté kuítekakuenhya sín chꞌán ");
INSERT INTO poeNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","kíxin mé xi̱kaha tsoxiteyá tí nkehe tsíntáchro chꞌín Isaías tsíkjin chꞌán ósé kíxin: Ìnchéni, kohya nkexro kuítekaon tí nkehe chrónkani. Kohya nkexro kjuínchenohe Dios tí kjuachaxin jié kuènte chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Méxra̱ kuítekakuenhya sín tí chꞌín Jesús éxí tsíkjin chꞌín Isaías kja̱xin kíxin: ");
INSERT INTO poeNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Dios kjuínchekꞌikonhya chꞌán sín la ko kjuínchecha chꞌán a̱sén sín, kíxin ntá chrókꞌuikonhya sín, la ko chrókienxínhya sín, kíxin ntá chrókóchjinehya sín tí janhan kíxin chrókjui̱ntakito̱ha̱ sín jína. ");
INSERT INTO poeNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Xi̱kaha kꞌuéchrónka chꞌín Isaías imá ósé kíxin kꞌuékꞌikon chꞌán tí kjuachaxin jié kuènte Jesús ntá kꞌuéchrónka chꞌán nkexrí tsjakꞌe tí chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Kjánchó itsjé tí sín judío tꞌe̱to̱an kuítekaon sín tí chꞌín Jesús kjánchó noxínhya chrónka sín. Chrako̱nhe̱n sín tí sín fariseo kíxin chrókónínkaon sín la í chrókjuanjonhya sín kjuachaxin chrókꞌuixenhen sín tí ni̱nko̱e sín judío. ");
INSERT INTO poeNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Mé xi̱kaha imá kóxrjínhi̱n sín kíxin chojni chjasintajni chrókjuikosáyehe sín ntá kánhyó kjueyá sín kíxin chrókjuikosáyehe sín Dios. ");
INSERT INTO poeNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ntá itsen nixja chꞌín Jesús ntáchro chꞌán kíxin: ―Tí títekáonrá tí janhan na mé jehya janhván títekáonrá na mé kja̱xin títekáonrá Tꞌaná, mé tí nkexro kꞌue̱tua̱nna kꞌuinka. ");
INSERT INTO poeNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Éxí tí tꞌikonrá tí janhan mé xi̱kaha tꞌikonrá tí nkexro kꞌue̱tua̱nna kꞌuinka. ");
INSERT INTO poeNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","A̱ ntá janhan mé xrohi kꞌuinka chjasintajni kíxin tí sín titekaon sín tí janhan tsꞌejóhya sín tí sítié a. ");
INSERT INTO poeNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","A̱ ntá tí jnkojínrá tinhínrá tí nkehe xrja̱nka ntá títekákonnahyará la jehya janhan si̱ntakjasótiará kíxin jehya kíxin kꞌuinka si̱ntakjasóte chojni chjasintajni. Náhí. Kꞌuinka kíxin si̱ntakaá chojni. ");
INSERT INTO poeNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","A̱ ntá tí títekákonhyará tí janhan la ko títekákonhyará tí tan kuènta̱na la ó siín nkexrí tsito̱exíxin iji̱árá, na mé éxí tí tan xrja̱nka mé Dios sinchekito̱exín iji̱árá tí ya̱on tsjixixín chjasintajni. ");
INSERT INTO poeNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Jehya tí nkehe kuènta̱na tjéxrja̱nka. Náhí. Tꞌaná na mé tí nkexro kꞌue̱tua̱nna kꞌuinka mé kꞌue̱tua̱nna nkehe tso̱xrja̱nka la ko nkehe tsjàkua. ");
INSERT INTO poeNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","A̱ ntá nòna kíxin tí nkehe kꞌue̱to̱an Tꞌaná mé xranjonxín tí kjuachón jnkochríxín. Mé xi̱kaha tí nkehe ntáxrja̱n mé tjéxrja̱nka kíxin Tꞌaná mé kꞌue̱tua̱nna. ");
INSERT INTO poeNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","A̱ ntá tí ya̱on xi̱ka tí ntóye tsjasin sín tí kia pascua. A̱ ntá chꞌín Jesús ó nohe chꞌán kíxin ó kjuixraká tí hora tsíto̱he chꞌán chjasintajni sátsji̱chréhe̱ chꞌán Itꞌé chꞌán. Xráxín tjuèhé chꞌán tí sín kuènte chꞌán chjasintajni, a̱ ntá jie tsja̱ko̱xi̱n chꞌán kíxin imá tjuèhe chꞌán tí jehe sín. ");
INSERT INTO poeNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","A̱ ntá tí chꞌín Tsochren tsíkꞌe̱tue̱nhen a̱sén chꞌín Judas Iscariote, itꞌé mé itꞌin Simón, kíxin sinchekji chꞌán tí chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ntá chꞌín Jesús la ó nohe chꞌán kíxin tsíki̱xi̱n chꞌán tí tjen Dios la ko xikjan chꞌán sátsji̱chréhe̱ chꞌán Dios ínaá. La ko ó nohe chꞌán kíxin Itꞌé chꞌán tsíkjanjon kjuachaxin tsꞌe̱tue̱nhen chꞌán kaín xín nkehe. ");
INSERT INTO poeNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ntá na̱xa̱ tjejóne sín ntá kꞌuínkatjen chꞌín Jesús kuakitsje chꞌán tí ka titsáte chꞌán la kuákja chꞌán ijnko ka xámáxin chojni tꞌónti kꞌuínkatꞌóxin chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ntá kui̱ki̱a̱ chꞌán ijnko nkehe nta̱, ntá kjuankíxin chꞌán kjuínchekꞌònti chꞌán to̱té jnkojnko tí sín kꞌuájiko chꞌán la ko kjuínchexámáxin chꞌán tí ka kꞌuínkatꞌóxin chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Na ntá tió kjuíjixraká tí tjen chꞌín Pedro, a̱ ntá ntáchro chꞌín Pedro kíxin: ―Jaha Ìnchéni la, ¿nkekuènté chrókjui̱nchekꞌóntia to̱téni? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Jaha la na̱xa̱ tiénxinhya tí nkehe tjétꞌa̱ janhan. Chrꞌéxi̱n ntá tsiénxian nkekuènté tjétꞌa̱ tíha ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ntá ntáchro chꞌín Pedro kíxin: ―Jaha la si̱nchekꞌóntihya to̱téni ―ichro chꞌán. Ntá ntáchro chꞌín Jesús kíxin: ―Tí si̱ntakꞌóntihya tí jaha la kjá ninkehó tsochontahya tí janhan ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ntá kjuáte̱he chꞌín Simón Pedro ntáchro chꞌán kíxin: ―Náhí, Ìnchéni. Jehya tí to̱téni ó chrókjui̱nchekꞌóntia. Kja̱xin itjani la ko ikjani chrókjui̱nchekꞌóntia ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ntá ntáchro chꞌín Jesús ínaá kíxin: ―Tí sín tsíkjixin tsíkꞌónti la tꞌichjánxi̱nhya kuenté sín tsꞌónti sín ínaá. Náhí. Jehó to̱té sín ó mé tꞌichjánxi̱n na̱xa̱ tsꞌónti kíxin kuenté la ó tjóá. A̱ ntá jahará la ó tjóárá, kjónté kénhyará ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Mé xi̱kaha ntáchro chꞌín Jesús kíxin kénhya sín tjóá sín kíxin ó nohe chꞌán nkexro sinchekji chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ntá tió kjuixin kjuínchekꞌónti chꞌán to̱té sín kaín sín ntá xíkꞌinkáya chꞌán ínaá tí ka kuítsáte chꞌán ntá kjuákꞌetja̱xi̱n chꞌán tí kꞌuínkatje̱nxi̱n chꞌán. Ntá ntáchro chꞌán kíxin: ―¿Á kiénxinrá tí nkehe kjui̱tꞌa? ");
INSERT INTO poeNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Jahará la ntáchrorá kíxin janhan Maestro kuèntárá la ko Ìnchárá. Chaxín ntoá ntáchrorá kíxin janhan tíha. ");
INSERT INTO poeNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Janhan tí Maestro kuèntárá la ko ìnchárá kjui̱ntakꞌóntia to̱tárá. A̱ ntá jahará kja̱xin xi̱kaha chrókjui̱nchekꞌóntirá to̱té kíchuárá. ");
INSERT INTO poeNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Janhan mé kjuáko̱xia̱n kíxin xi̱kaha chrókjui̱chꞌerá éxí kjui̱tꞌa janhan. ");
INSERT INTO poeNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ijnko nkehe chaxín tso̱tjo̱nka̱rá kíxin tí sín chꞌexón xra̱ mé tꞌe̱to̱anhya sín éxí tꞌe̱to̱an tí lámo̱e sín, la ko tí sín kꞌuáyéhe̱ sín ijnko xra̱ tꞌe̱to̱anhya sín éxí tꞌe̱to̱an tí sín kjuanjon tí xra̱ a. ");
INSERT INTO poeNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Tí chrókiénxinrá nkehe tíha la ko chrókjui̱nchexiteyárá la chrókócháhará má. ");
INSERT INTO poeNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Jehya kaín rá xi̱kaha ntáxrja̱n. Ó nòna kíxin nkexro kjuéyá janhan. Kjánchó tꞌichjánxi̱n tsoxiteyá tí nkehe tsíkjin sín ósé ntáchro kíxin: “Ijnko nkexro tjéne̱kian mé tsjanjo̱nkian.” ");
INSERT INTO poeNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Mé xi̱kaha tjétjo̱nka̱rá senó kíxin tió tsꞌatsínka tíha ntá tsítekáonrá kíxin janhan mé tí nkexro xráxín tjen. ");
INSERT INTO poeNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ijnko nkehe tjetoan tjétjo̱nka̱rá kíxin tí tsjánjonrá kjuachaxin tsito̱he tí chojni ichrꞌan janhan, mé éxí yóhe̱ chrókjuánjonrá kjuachaxin chrókuito̱he tí janhan, a̱ ntá tí tsjánjonrá kjuachaxin tsito̱na janhan mé éxí yóhe̱ chrókjuánjonrá kjuachaxin chrókuito̱he tí nkexro kꞌue̱tua̱nna kꞌuinka ―ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ntá kjuixin chrónka chꞌín Jesús tíha, ntá kóxakonhen a̱sén chꞌán má ntá ntoá chrónka chꞌán kíxin: ―Ijnko nkehe tjetoan tso̱tjo̱nka̱rá kíxin jnkojínrá tjejorá ntihi mé si̱nchekjiráni ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ntá tí sín kꞌuájiko chꞌán kjuanjíxin komáxin la ko í komáxin kíchó sín kíxin noehya sín nkexro tí ntáchro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","A̱ ntá ijnko chꞌín kꞌuájiko chꞌín Jesús imá tjuèhe chꞌán itjen chꞌán chjinaxón tí tjen chꞌín Jesús tjejóne sín. ");
INSERT INTO poeNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ntá chꞌín Simón Pedro kjua̱ko̱exín seña kꞌue̱tue̱nhen chꞌán tí í jnko chꞌín a kíxin: ―Tjanchankíhí chꞌán nkexro tíha ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","A̱ ntá tí chꞌín a na mé a̱ntsí kóchjinehe chꞌán tí chꞌín Jesús, ntá kjuanchankí chꞌán ntáchro chꞌán kíxin: ―Ìnchéni, ¿nkexro tíha? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","A̱ ntá kjuáte̱he chꞌín Jesús ntáche chꞌán tí chꞌín a kíxin: ―Si̱ntakjata itꞌo̱ nio̱tja̱, a̱ ntá tí nkexro tso̱tja̱ha̱ tí tꞌo̱ nio̱tja̱ a mé tí nkexro a ―ichro chꞌán. A̱ ntá mé xi̱kaha kjuínchekjata chꞌín Jesús itꞌo̱ nio̱tja̱ ntá chjéhe chꞌán tí chꞌín Judas Iscariote, itꞌé chꞌán mé itꞌin Simón. ");
INSERT INTO poeNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ntá kꞌuáyéhe̱ chꞌán tí nio̱tja̱ ntá tuénxín kꞌuíxenhen a̱sén chꞌán tí chꞌín Tsochren. Ntá ntáche chꞌín Jesús tí jehe chꞌán kíxin: ―Tí xra̱ tjinkávan si̱chꞌe la jaí tóxakonhan ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Kjánchó nijnko tí sín tjejóne ntiha kienxínhya sín nkekuènté xi̱kaha ntáchro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Chꞌín Judas la tꞌayakonhen chꞌán tí nkehe tjinká chichaon ntá iso sín kjuenka̱yáxin sín kíxin áchꞌe chꞌín Jesús mé kꞌue̱tue̱nhen chꞌán tí chꞌín Judas kíxin ichrén nkehe sátsjikꞌe̱na chꞌán kuènte tí kia a, o̱ áchꞌe ichrén nkehe sincheki̱to̱nhe̱n chꞌán tí sín nòa a. ");
INSERT INTO poeNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ntá kꞌuáyéhe̱ chꞌín Judas tí nio̱tja̱, a̱ ntá kꞌuaxrjexín chꞌán ntiha. A̱ ntá ó kꞌuíxin tie. ");
INSERT INTO poeNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","A̱ ntá ó kjuixin sátsíkji chꞌín Judas, ntá ntáchro chꞌín Jesús kíxin: ―A̱ ntá jie tso̱noxín tí kjuachaxin jié kuènte tí Xje̱en Dios Kꞌóna Chojni la ko tsja̱ko̱xi̱n chꞌán tí kjuachaxin jié kuènte Dios. ");
INSERT INTO poeNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Na mé xi̱kaha tí Xje̱en Dios Kꞌóna Chojni mé tsja̱ko̱xi̱n tí kjuachaxin jié kuènte Dios. A̱ ntá Dios mé tsja̱ko̱xi̱n chꞌán tí kjuachaxin kuènte Xje̱en chꞌán la tjoka tsoxiteyá. ");
INSERT INTO poeNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Xje̱enni, í séhya na̱xa̱ tsjakꞌé janhan tsꞌejókoará ntihi. Ntá jahará mé tsꞌajikjéyárá tí janhan. Ntá éxí yóhe̱ kꞌuétja̱nka tí sín judío mé tjo̱nka̱rá kja̱xinrá kíxin: Ninkexró xitjahya tsjiji sín tí sátsjiyá janhan. ");
INSERT INTO poeNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ijnko nkehe ni̱xin tétua̱nhanrá ijie kíxin chrótjuèhérá kíchuárá éxí yóhe̱ tjua̱hará mé xi̱kaha chrótjuèhérá kíchuárá. ");
INSERT INTO poeNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Tí tsotjuèhérá kíchuárá ntá tso̱noexín kaín xín chojni siín chjasintajni kíxin tinkachónkirá tí janhan ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ntá kjuanchankíhi chꞌín Simón Pedro tí chꞌín Jesús kíxin: ―Ìnchéni, ¿nketí sátsjia? ―ichro chꞌán. Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Tí nó sátsjiyá xitjahya tsochréhérá jaí. Ntá chrꞌéxi̱n tsjasánchréhérá ntiha ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","A̱ ntá ntáchro chꞌín Pedro kíxin: ―¿Nkekuènté xitjahya tsochráha̱ tí jaha jaí? Kjónté chrókꞌuényákonhán ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―¿Á chaxín tsꞌenyákònna jaha? Ijnko nkehe chaxín tso̱tjo̱nka kíxin na̱xa̱ tsotsjehya tí kochínto̱a la ó tsjixin si̱nchemána níya kíxin chonhyana, tsixrua.﻿ ");
INSERT INTO poeNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","’Tóxakuanhyará jahará. Títekáonrá Dios la ko kja̱xin títekáonrá tí janhan. ");
INSERT INTO poeNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Nto̱e Tꞌaná nchónhya nchia siín tsꞌejóni. A̱ ntá tí xi̱kahya chrókꞌuixin la xi̱kahya chrótjo̱nka̱rá. Méxra̱ sátsjiyá si̱ntayóxian tí chrókꞌuejóni. ");
INSERT INTO poeNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","A̱ ntá tí sátsjiyá si̱ntayóxian, ntá tió tsjixin ntá tsꞌinka ínaá, ntá sátsji̱ni kíxin jahará kja̱xin chrókꞌuejorá ntiha tí tsjakꞌé janhan. ");
INSERT INTO poeNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Jahará la ó nohará nketí sátsjiyá la ko ó nohará tí nti̱a a ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ntá kjuáte̱he chꞌín Tomás ntáchro chꞌán kíxin: ―Ìnchéni, noehyani nketí sátsjia jaha. ¿A̱ ntá nkexrí chrókónoheni tí nti̱a a? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Janhan mé tí nti̱a la ko janhan mé tí tan chaxín la ko janhan mé tsjánjuan tí kjuachón. Jehó tí nkexro tsitekaon tí janhan mé jína tsjiji tí tjen Tꞌaná. ");
INSERT INTO poeNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Tí chrókjuátso̱anrá tí janhan ntá xi̱kaha chrókjuátso̱anrá Tꞌaná kja̱xin. Na ntá ó choxínrá chꞌán jie la ko ó tjejókomárá chꞌán ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ntá ntáchro chꞌín Felipe kíxin: ―Ìnchéni, ti̱to̱héni kíxin tsochóxinni Itꞌá. Táhó mé tjinkaonni ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Felipe, ósé tjejóni, ¿a̱ ntá na̱xa̱ tjátso̱anhya tí janhan ní? A̱ ntá xi̱kaha tí tꞌikonrá tí janhan na mé xi̱kaha chrókꞌuíkonrá Tꞌaná. ¿Nkekuènté tjanchàna kíxin chrókui̱to̱ha̱ chrókꞌuikonrá tí Tꞌaná? ");
INSERT INTO poeNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Á títekákonhya jaha kíxin janhan jnkoko̱á tjéki̱an Tꞌaná, la ko Tꞌaná tjen tí tjén janhan? Tí nkehe níxja janhan la jehya kuènta̱na. Náhí. Tꞌaná tjéki̱an janhan mé tjechꞌe chꞌán tí xra̱ kuènte chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Títekáonrá kíxin jnkoko̱a tjéki̱an Tꞌáná, a̱ ntá Tꞌaná itjen tí tjén janhan. Kjónté kuítekákonhyará xi̱kaha la chrókuítekáonrá kíxin tí kjuaxroan jié kjuáko̱xia̱n kꞌuíkonrá. ");
INSERT INTO poeNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ijnko nkehe chaxín tjo̱nka̱rá kíxin tí chaxín tsítekáonrá tí janhan ntá kja̱xinrá tsjachará si̱chꞌerá xra̱ yóhe̱ tjétꞌa̱ la ko kja̱xin ixra̱ a̱ntsí jié tsjachará si̱chꞌerá kíxin janhan la ó sátsjiyá tí tjen Tꞌaná. ");
INSERT INTO poeNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Kaín nkehe tsjanchatóxixínrá tí ni̱na na mé tsjánjuan kíxin xi̱kaha tsjáko̱xia̱n tí kjuachaxin kuènte Tꞌaná. ");
INSERT INTO poeNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Tí chrén nkehe tsjanchatóxixínrá ni̱na la janhan la tsjánjuan. ");
INSERT INTO poeNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Tí chaxín tjuèhérá tí janhan ntá chrókjui̱nchexiteyéhérá tí nkehe kuétua̱nhanrá. ");
INSERT INTO poeNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ntá tsoxrja̱nnóa̱ha̱ Tꞌaná kíxin tsochrꞌán chꞌán Ncha̱kuen chꞌán kíxin tsjinki̱tsa tí jahará la ko sinchechéhe̱ a̱sánrá la mé tsꞌejokoará jnkochríxín. ");
INSERT INTO poeNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Jehe chꞌán mé Ncha̱kuen chaxín. Tí sín chjasintajni xitjahya tsꞌáyéhe̱ sín chꞌán kíxin tꞌikonhya sín chꞌán la ko chónhya sín chꞌán. Kjánchó jahará ó choxínrá chꞌán kíxin tjejokoará chꞌán la ko tsꞌejokoará chꞌán jnkochríxín. ");
INSERT INTO poeNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Janhan na tsi̱to̱áhyará nòerá jahórá, na mé tsokjan ínaá kíxin tsꞌejóni. ");
INSERT INTO poeNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","A̱ ntá séhya ntá tí sín chjasintajni tsꞌikonhya sin tí janhan ínaá. Kjánchó jahará mé tsꞌikonrá tí janhan. Ntá kja̱xinrá tsꞌejochónrá kíxin janhan na tjéchua̱n. ");
INSERT INTO poeNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","A̱ ntá tí ya̱on a chrókónohará kíxin Tꞌaná la ko janhan jnkoko̱á tjéki̱an la ko kja̱xin jahará la ko janhan jnkoko̱á tjejóni. ");
INSERT INTO poeNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Tí nkexro nohe tí nkehe této̱an la ko sinchexiteyéhe̱ sín mé xi̱kaha tsja̱ko̱xi̱n sín kíxin chaxín tjuèhe sín tí janhan. A̱ ntá tí tjuèhe sín tí janhan ntá Tꞌaná mé tsotjuèhe tí jehe sín la ko kja̱xin janhan tsotjua̱ha̱ sín la ko tsjáko̱xia̱n nkexrí tjén janhan ―ichro chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","A̱ ntá tí chꞌín Judas, jehya tí chꞌín Iscariote tíha, na mé kjuanchankí chꞌán kíxin: ―Ìnchéni, ¿nkekuènté jehóni tjákoxian, a̱ ntá tjáko̱éxinhya tí chojni chjasintajni? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Tí nkexro tjuèhe tí janhan mé sinchexiteyéhe̱ tí nkehe této̱an. La ko Tꞌaná mé tsotjuèhe tí jehe sín la ntá Tꞌaná la ko janhan tsꞌejókoni sín. ");
INSERT INTO poeNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","A̱ ntá tí sín tjuèhya tí janhan la mé nchexiteyèhya sín tí nkehe tjàkua. A̱ ntá tí nkehe tjàkua tjejotinhínrá la jehya kuènta̱na. Náhí. Kuènte Tꞌaná tí nkexro kꞌue̱tua̱nna kꞌuinka. ");
INSERT INTO poeNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Na̱xa̱ tjejóni la tjétjo̱nka̱rá kaín tíhi. ");
INSERT INTO poeNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","A̱ ntá Ncha̱kuen Tꞌaná tsochrꞌán chꞌán kjuachaxin ni̱na mé tsjinki̱tsa tí jahará la ko sinchechéhe̱ a̱sánrá la ko tsja̱ko̱hará kaín nkehe la ko sinchexraxinkaonrá kaín nkehe xrja̱nka. ");
INSERT INTO poeNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Kjuaxróxin tsi̱to̱ha̱ la ko kjuaxróxin kuènta̱na tso̱tja̱hárá. Jehya éxí tí kjuaxróxin chrókjuanjon tí sín chjasintajni. Náhí. Chrókóxakuenhya a̱sánrá la ko chróchrakonhyará. ");
INSERT INTO poeNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ó kuínhínrá ntáxrja̱n kíxin sátsjiyá la ko tsokjan janhan tsꞌejóni ínaá. Tí chaxín tjuèhérá tí janhan ntá chrókócháhará tí kuínhínrá kíxin sátsjiyá tí tjen Tꞌaná kíxin a̱ntsí tꞌe̱to̱an chꞌán la kánhyó této̱an janhan. ");
INSERT INTO poeNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Senó tjétjo̱nka̱rá tíhi kíxin tió tso̱nhen tíha la tsꞌikonrá ntá tsítekáonrá jahará. ");
INSERT INTO poeNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Ntá jie la í séhya tsonixja̱hará kíxin tí jie itsi tí chꞌín Tsochren, mé tí nkexro tꞌe̱tue̱nhen tí sín chjasintajni. A̱ ntá jehe chꞌán la ninkehó tꞌe̱tua̱nnahya tí janhan. ");
INSERT INTO poeNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Kjánchó tꞌichjánxi̱n kíxin xi̱kaha tso̱nhen ntá tí sín chjasintajni mé tso̱nohe sín kíxin tjua̱ha̱ Tꞌaná la ko nchexiteyáha̱ tí nkehe kꞌue̱tua̱nna chꞌán. Ntá jie tꞌinkatjenrá sátsjixínni ntihi. ");
INSERT INTO poeNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","’Janhan mé éxí yóhe̱ ijnko ntanòa tjechón itsa to uva la ko Tꞌaná mé éxí yóhe̱ tí nkexro tꞌayakonhen tí nta a. ");
INSERT INTO poeNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Tsochrínjin chꞌán tí chaan nta tꞌónahya to. A̱ ntá tí chaan nta tꞌóna to mé nchetjuákꞌá chꞌán kíxin ntá tsꞌóna a̱ntsí má tsjé to. ");
INSERT INTO poeNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","A̱ ntá jahará la kótjuáxinrá tí tanná kꞌuétjo̱nka̱rá senó. ");
INSERT INTO poeNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Tí tsi̱to̱éhyará tí janhan ntá kja̱xin janhan tsi̱to̱a̱hya tí jahará. Mé xi̱kaha ijnko chaan nta tsꞌaxrjentehe tsjachahya jehó tsꞌóna to, la ko xi̱kaha jahórá tsjachahyará si̱chꞌerá tí xra̱ kuènta̱na tí tsi̱to̱hérá tí janhan. ");
INSERT INTO poeNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Janhan na mé yóhe̱ tí ntanòa, a̱ ntá jahará la tí chaan tí ntanòa tsíkꞌayanta. Tí nkexro jnkoko̱á tjenka̱yáxinkian mé tsjacha tsꞌóna nchónhya to. A̱ ntá tí tsinkáchónkihya sín tí janhan la ninkehó xra̱ tsjachahya sín sichꞌe sín. ");
INSERT INTO poeNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","A̱ ntá tí nkexro jnkoko̱áhya tjenka̱yáxinkian na mé éxí yóhe̱ tí nta chꞌehya xra̱ tsíkóchrínjin sín tsíkꞌitjí sín chrínta tí nonte a tso̱xámá ntá tsoxrejo ntá tsoche. ");
INSERT INTO poeNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Ntá tí chaxín tsi̱to̱éhyará tsinkachónkirá tí janhan la ko tsꞌitjáyanhyará tí nkehe kjuákohará ntá tsjanchiará ichrén nkehe tjinkáonrá la tsꞌayéhérá. ");
INSERT INTO poeNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","A̱ ntá Tꞌaná la tso̱chéhe̱ chꞌán tí tsꞌónará itsjé to. Mé xi̱kaha tsjáko̱xi̱nrá kíxin tinkachónkirá tí janhan. ");
INSERT INTO poeNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Janhan tjua̱hará tí jahará éxí tjua̱na Tꞌaná. Chrókónohará kíxin tjua̱hará. ");
INSERT INTO poeNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Tí tsítekáonrá tí nkehe kuétua̱nhanrá ntá tso̱nohará kíxin tjua̱hará éxí yóhe̱ kja̱xin janhan nta̱xiteyá tí nkehe kꞌue̱tua̱nna Tꞌaná ntá kónòna janhan kíxin tjua̱na chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Mé xi̱kaha tjo̱nka̱rá kaín tíha kíxin ntá éxí chàna mé xi̱kaha tsjintaxín tso̱chéhe̱ a̱sánrá. ");
INSERT INTO poeNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Tí nkehe kuétua̱nhanrá la mé tíhi kíxin chrótjuèhérá kíchuárá éxí tjua̱hará xi̱kaha. ");
INSERT INTO poeNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ninkexró chrókóyóhe̱ éxí tí nkexro imá tjuèhe tí sín chóxin chꞌán ntá tsꞌenyákonhe̱n chꞌán tí jehe sín. ");
INSERT INTO poeNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Jahará la chojni choxian tí tsítekáonrá tí nkehe tétua̱nhanrá. ");
INSERT INTO poeNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ntáxrja̱nhya janhan kíxin jahará chojni chꞌexón xra̱ kíxin tí chojni xi̱kaha chꞌexón xra̱ mé noehya sín nkehe tí xra̱ chꞌe tí lámo̱e sín a. Náhí. A̱ ntá jahará la chojni choxian kíxin kaín xín nkehe kjua̱ko̱na Tꞌaná mé kjuákohárá. ");
INSERT INTO poeNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Jehya kíxin jahará kjuéyárá tí janhan. Náhí. Janhan mé kjuéyá tí jahará kíxin tsotja̱hárá xra̱, a̱ ntá éxí yóhe̱ to xé mé chrókꞌuaxrje jína tí xra̱ si̱chꞌenará kíxin chrókꞌuitjáyanhya. A̱ ntá Tꞌaná mé tsotjáhará chꞌán kaín xín nkehe tsjanchexínrá ni̱na. ");
INSERT INTO poeNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Mé xi̱kaha tétua̱nhanrá kíxin tsotjuèhérá kíchuárá. ");
INSERT INTO poeNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Tí tso̱nínkakonhanrá tí chojni chjasintajni ntá chrókónohará kíxin senó janhan nínkakonna sín. ");
INSERT INTO poeNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Tí chrókókuèntárá chjasintajni ntá tí sín chjasintajni chrótjuàhárá sín kíxin na̱xa̱ kjéhyará sín. Kjánchó janhan kjuéyá tí jahará kíxin chrókꞌuaxrjékjanxínrá tí sín siín chjasintajni. A̱ ntá tí sín chjasintajni nínkakonhanrá sín kíxin jahará jahyará kuèntárá chjasintajni. ");
INSERT INTO poeNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Xráxinkáonrá tí nkehe tsítjo̱nka̱rá kíxin tí sín chꞌehe lámo̱e sín xra̱ tjetóxinhya tsꞌe̱to̱an sín. Éxí yóhe̱ chónkìna sín mé xi̱kaha tsochónkíhi sín tí jahará. A̱ ntá tí kuítekaon sín tí nkehe kjuáko̱ha̱ sín ntá kja̱xin tsitekaon sín tí nkehe na̱xa̱ tsjákohérá sín. ");
INSERT INTO poeNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Mé xi̱kaha sitꞌahará sín kíxin jahará tinkachónkirá tí janhan la ko jehe sín chónhya sín tí nkexro ichrꞌánna kꞌuinka ntihi. ");
INSERT INTO poeNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Tí chrókꞌuinkahya janhan ntihi chrónixja̱hya sín ntá chrókuamáhya sín jie̱. Ntá jié kohya nkerí tsaáxin sín kíxin tí jie̱ tinkákjasin sín. ");
INSERT INTO poeNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Tí sín nínkakonna mé xi̱kaha nínkakonhen sín Tꞌaná. ");
INSERT INTO poeNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Chróchóntahya sín jie̱ tí chrókꞌuejókianhya sín ntihi chrókjuásinhya janhan kjuaxroan jié éxí tsíkjasinhya ninkexró senó. Ntá jie ó kꞌuíkon sín kaín tí kjuaxroan, a̱ ntá kjónté nínkakonna sín tí janhan la ko nínkakonhen sín Tꞌaná kja̱xin. ");
INSERT INTO poeNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Mé xi̱kaha tso̱nhen kaín tíha kíxin ntá tsoxiteyá tí nkehe ntáchro tí ley kuènte sín kíxin: “Kohya jie̱ kjuásian janhan ntá kjónté kónínkakonna sín.” ");
INSERT INTO poeNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","A̱ ntá tsi tí nkexro tsjinki̱tsa la ko sinchechéhe̱ a̱sánrá. Tíha mé tí Ncha̱kuen Dios chaxín. Janhan mé tsochrꞌan chꞌán kíxin tí kjuachaxin kuènte Tꞌaná. A̱ ntá jehe chꞌán mé tsochrónka nkexrí tjén janhan ");
INSERT INTO poeNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","la ko jahará kja̱xinrá tso̱chro̱nka̱rá nkexrí tjén janhan kíxin tí xrankíxixín la kꞌuéjóni jnkoko̱á.﻿ ");
INSERT INTO poeNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Kaín tíhi tjétjo̱nka̱rá kíxin chrókui̱to̱éhyará tí nkehe kjuákohárá. ");
INSERT INTO poeNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Tí sín judío tsjanjonhya sín kjuachaxin tsꞌixe̱nhenrá ni̱nko̱é sín la ko tsjixraká tí ya̱on kíxin tí sín tsꞌóyán sín tí jahará tsontáchro sín kíxin xi̱kaha mé tjejóchꞌe sín xra̱ kuènte Dios, tsixro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Mé xi̱kaha sichꞌe sín kíxin chónhya sín Tꞌaná la ko chónhyana sín. ");
INSERT INTO poeNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","A̱ ntá tjo̱nka̱rá kaín tíhi kíxin tió tsjixraká tí ya̱on xi̱kaha tso̱nhen ntá tsoxráxinkáonrá kíxin ó kꞌuétjo̱nka̱rá senó a. ’Tí xrankíxixín kꞌuétjo̱nka̱hyará tíhi kíxin jnkoko̱á kꞌuékꞌejóni. ");
INSERT INTO poeNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ntá jie sátsjiyá tí tjen tí nkexro ichrꞌánna kꞌuinka. Kjánchó nijnkorá tjanchankíhyará nketí sátsjiyá. ");
INSERT INTO poeNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ntá kjuixin tjo̱nka̱rá tíha ntá imá tꞌavárá kíxin kuínhínrá xi̱kaha xrja̱nka. ");
INSERT INTO poeNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","A̱ ntá chaxín tí nkehe tjétjo̱nka̱rá kíxin íchá jína sátsjiyá kíxin jahará jína chrókꞌuejorá. A̱ ntá tí sáchrókjuíhya ntá chrókuihya tí nkexro tsjinki̱tsará. A̱ ntá tí sátsjiyá janhan ntá tséto̱an kíxin itsi chꞌán ntihi. ");
INSERT INTO poeNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","A̱ ntá tió tsi chꞌán mé sinchexraxinkaon chꞌán tí chojni chjasintajni kíxin jehe sín mé tjasin sín jie̱, la ko itjen ijnko nti̱a ntoá chrókuakja sín la ko Dios mé sinchekito̱exín tí jie̱ kjuasin sín. ");
INSERT INTO poeNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Xi̱kaha chónta sín jie̱ kíxin tinkáchónkihya sín tí janhan. ");
INSERT INTO poeNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","A̱ ntá tso̱nohe sín kíxin itjen tí nti̱a ntoá kíxin sátsjiyá tí tjen Tꞌaná ntá tsꞌikonhyará tí janhan ínaá, ");
INSERT INTO poeNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","la ko tso̱nohe sín kíxin Dios sinchekito̱exín ijie̱ kíxin ó kjuixin kuíto̱exín iji̱é tí nkexro tꞌe̱to̱an chjasintajni kíxin tsjasóte. ");
INSERT INTO poeNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Na̱xa̱ chonta janhan itsjé nkehe chrótjo̱nka̱rá, kjánchó chrókjuachahyará chrókiénxinrá jie. ");
INSERT INTO poeNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","A̱ ntá tió tsi tí Ncha̱kuen Dios chaxín ntoá ntá jehe tí Ncha̱kuen Dios mé tsja̱ko̱hará chꞌán kaín xín nkehe ntoá. Méxra̱ jehya tí nkehe kuènte chꞌán tsochrónka chꞌán na mé tí nkehe tsinhin chꞌán mé tsochrónka chꞌán tsja̱ko̱hará chꞌán tí nkehe tso̱nhen chrꞌéxi̱n. ");
INSERT INTO poeNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Jehe chꞌán mé tsjikosàyana chꞌán kíxin tsꞌáyéhe̱ chꞌán tí nkehe kuènta̱na ntá tsja̱ko̱hará chꞌán nkehe tíha. ");
INSERT INTO poeNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Kaínxín nkehe chónta Tꞌaná na mé kuènta̱na. Mé xi̱kaha ntáxrja̱n kíxin tí Ncha̱kuen Dios chaxín ntoá mé tsꞌáyéhe̱ chꞌán tí nkehe kuènta̱na ntá tsja̱ko̱hará chꞌán nkehe tíha. ");
INSERT INTO poeNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Ntá í séhya la í tsꞌikonhyará tí janhan. La ko kja̱xin séhya xikꞌikonrá tí janhan ínaá kíxin sátsjiyá tí tjen Tꞌaná ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ntá iso tí sín kꞌuájiko chꞌán mé kjuanchankíhi sín kíchó sín kíxin: ―¿Nkexrí tꞌaxrjexín tí nkehe ntáchro chꞌán kíxin í séhya tsꞌikonhyani chꞌán la ko kja̱xin séhya ntá xikꞌikonni chꞌán ínaá kíxin sátsji̱ chꞌán tí tjen Itꞌé chꞌán? ");
INSERT INTO poeNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Nkexrí tꞌaxrjexín tí ntáchro chꞌán kíxin “í séhya”? Méxra̱ tienxínhya nkehe tí ntáchro chꞌán ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ntá kónohe chꞌín Jesús tí nkehe chrókjuanchankíhi sín chꞌán ntá ntáche chꞌán sín kíxin: ―Xi̱kaha tjo̱nka̱rá kíxin í séhya tsꞌikonhyará tí janhan la ko kja̱xin séhya xikꞌikonrá tí janhan ínaá. ¿Á tíha mé tjejotjanchankíhírá kíchuárá ní? ");
INSERT INTO poeNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Tjétjo̱nka̱rá ijnko nkehe chaxín kíxin imá tsotsja̱nkará la ko tsꞌavárá. A̱ ntá tí chojni chjasintajni la tso̱chéhe̱ sín. A̱ ntá jahará tsꞌavárá la ko si̱ntaníhará kjónté chrꞌéxi̱n tso̱cháhará má. ");
INSERT INTO poeNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Éxí yóhe̱ ijnko tjan sinchekokjíhi tjan xje̱en tjan mé imá tóxakonhen tjan kíxin ó kjuixraká tsjoté tjan. A̱ ntá tsjixin tsokjíhi xjan ntá í xraxinkakonhya tjan nkexrí kjoté tjan kíxin chéhe̱ tjan kokjíhi ijnko xjan ntihi chjasintajni. ");
INSERT INTO poeNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Mé xi̱kaha jahará ijie tꞌavárá. Ntá xikꞌíkua̱n tí jahará ínaá ntá imá tso̱chéhe̱ a̱sánrá la ko tso̱kohya ninkexró tsakitsajahará tí kjuachéhe̱ tsochontará. ");
INSERT INTO poeNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Tió tsi tí ya̱on a ntá tsjanchankínahyará ninkehó. Chaxín tí nkehe tjétjo̱nka̱rá kíxin Tꞌaná tsotjáhará chꞌán kaín nkehe tsjanchatóxixínrá ni̱na. ");
INSERT INTO poeNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Na̱xa̱ kjuánchatóxixínhyará ninkehó tí ni̱na. Ntá jie tjanchiará la tsꞌayéhérá, a̱ ntá tsjintaxín tso̱cháhará. ");
INSERT INTO poeNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Tí nkehe tjétjo̱nka̱rá mé kjui̱ntayóa̱xián ó. Ntá tsjixraká tí ya̱on la í ninkehó si̱ntayóa̱xián na mé ntoá tso̱tjo̱nka̱rá nkexrí tjen Tꞌaná. ");
INSERT INTO poeNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","A̱ ntá tí ya̱on a mé tsjanchaxínrá nkehe ni̱na. Ntá ntáxrja̱nhya tíhi kíxin tsonixja̱yákonhanrá tí tjen Tꞌaná ");
INSERT INTO poeNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","kíxin jehe Tꞌaná mé tjuahará jahará. Na mé tjuahará chꞌán kíxin jahará tjua̱nará tí janhan la ko kíxin kuítekáonrá kíxin janhan kꞌuinkaxian tí tjen Dios. ");
INSERT INTO poeNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Kꞌuaxrjéxian tí tjen Tꞌaná kꞌuinka chjasintajni. Ntá jie la ó tsi̱to̱ha̱ chjasintajni ntá sátsjiyá ínaá tí tjen Tꞌaná ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ntá ntáchro tí sín kꞌuájiko chꞌán a kíxin: ―Ntá jie ntoá tjéchro̱nka ninkehó ncheyoéxinhya. ");
INSERT INTO poeNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ntá jie tienxínni kíxin jaha mé noha kaín xín nkehe la ko tꞌichjánxi̱nhya kíxin jnkojín nkexro chrókjuanchankíha sín ichrén nkehe. Méxra̱ xi̱kaha titekaonni kíxin jaha mé kꞌuinkaxian tí tjen Dios ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―¿Á jie kuítekáonrá ní? ");
INSERT INTO poeNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ntá tsi tí ya̱on na mé jie tíha na ntá tsochrakonrá jnkojnkorá tsoxíkará sátsjirá ntá tsi̱to̱nará janhván tsjakꞌé. Kjánchó jehya janhván tjén. Tꞌaná mé tjéki̱an. ");
INSERT INTO poeNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Tjétjo̱nka̱rá kaín tíhi kíxin ntá kjuaxróxin tsꞌejó a̱sánrá tinkachónkirá tí janhan. A̱ ntá ntihi chjasintajni kjónté kjuaxróxinhya tjejorá tjejotjasóterá kjánchó chrakonhyará kíxin janhan mé ó kjuixin kjuacha tséto̱an. A ntá tí chjasintajni la kjuachahya tsꞌe̱to̱an ―ichro chꞌán.﻿ ");
INSERT INTO poeNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ntá ó kjuixin chrónka chꞌín Jesús kaín tíha ntá konta chꞌán nka̱jní ntáchro chꞌán kíxin: ―Jaha Itꞌéni, ó kjuixraká tí ya̱on a. A̱ ntá jie chróchje̱hé tí Xja̱an a̱ntsí má kjuachaxin kíxin kja̱xin tí Xja̱an chrókjuikosáyehe tí jaha. ");
INSERT INTO poeNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Jaha tsíchje̱hé kjuachaxin tí Xja̱an kíxin tsꞌe̱tue̱nhen chꞌán kaín xín chojni na ntá jehe chꞌán tsochjéhe kjuachón jnkochríxín kaín tí sín tsíchje̱hé chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Tí kjuachón jnkochríxín mé tꞌaxrjexín kíxin tsochóxian sín tí jaha tí jnkoko̱á Dios chaxín tjechón la ko kja̱xin tsochóxin sín Jesucristo la mé jaha kuétue̱nhén chꞌán kui chꞌán ntihi chjasintajni. ");
INSERT INTO poeNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Ó kjuixin kjuíkosáya̱ha tí jaha ntihi chjasintajni kjuixinna tí xra̱ chjìna si̱tꞌa. ");
INSERT INTO poeNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","A̱ ntá jie Itꞌéni, chjìna jaha tí kjuachaxin jié kꞌuéchonta janhan tí kꞌuéjóni jnkoko̱á na̱xa̱ kꞌónahya chjasintajni. ");
INSERT INTO poeNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Ó kjuixin kjuáko̱ha̱ tí sín chjìna chjasintajni kíxin nkexro tí jaha. Jaha mé kꞌuékuèntá sín tí ósé ntá jie chjìna tí janhan la ó kjuáko̱ha̱ sín itán la ntá ijie la ó kuítekaon sín. ");
INSERT INTO poeNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ntá jie ó kjuátso̱an sín kíxin kaín tí kjuachaxin chonta janhan la jaha tsíkjánjuan. ");
INSERT INTO poeNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Kíxin ó kjuixin kjuáko̱ha̱ sín tí tán chjìna jaha, ntá kuítekaon sín, ntá kuíenxín sín kíxin mé chaxín tsíkꞌinkaxian tí tjen jaha, na mé kuítekaon sín kíxin jaha kuétua̱nna kꞌuinka. ");
INSERT INTO poeNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Janhan mé xrja̱nóa̱ha kíxin chrókꞌuayakonhén tí jehe sín. Jehya kíxin xrja̱nnóa̱ha kíxin chrókꞌuayakonhén kaín tí chojni siín chjasintajni. Náhí. Jehó xrja̱nóa̱ha kíxin chrókꞌuayakonhén tí sín chjìna kíxin kuèntá sín. ");
INSERT INTO poeNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","A̱ ntá kaín tí nkehe chonta janhan na mé kuèntá jaha la ko kaín tí nkehe kuèntá la mé kuènta̱na kja̱xin. A̱ ntá tí kjuachaxin jié kuènta̱na mé tsꞌinkaséyanxín tí jehe sín. ");
INSERT INTO poeNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’A̱ ntá jie tsito̱nahya janhan ntihi chjasintajni. Kjánchó jehe sín na̱xa̱ tsito̱he sín chjasintajni. A̱ ntá jie tsjasán tí tjen jaha. Jaha Itꞌéni imá jína jaha, tꞌayakuenxián sín tí kjuachaxin tí ihni̱á kíxin ntá jnkoko̱á chrókjuenka̱yáxin sín éxí tí jaha la ko janhan jnkoko̱á tjenka̱yáxinni. ");
INSERT INTO poeNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","A̱ ntá tí na̱xa̱ kꞌuéjóki̱an tí jehe sín ntihi chjasintajni la kꞌuàyakuànxián sín tí kjuachaxin tí ihni̱á chjìna. Nijnko tí jehe sín kꞌuitjáyanhya sín. A̱ ntá jnkoko̱á nkexro mé kꞌuítjáyan mé tí chꞌín xráxín tsꞌitjáyan kíxin xi̱kaha tsoxiteyá éxí nixja tí xroon tsíkjin sín. ");
INSERT INTO poeNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Ntá jie ó tsjasán tí tjen jaha. A̱ ntá na̱xa̱ itjén janhan chjasintajni mé ntáxrja̱n tíhi kíxin ntá tso̱chéhe̱ sín éxí yóhe̱ imá chàna. ");
INSERT INTO poeNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Janhan mé kjuáko̱ha̱ sín itán jaha, a̱ ntá jie tí sín chjasintajni mé nínkakonhen tí jehe sín kíxin jehe sín la jehya kuènte chjasintajni éxí kja̱xin janhan na janhya kuènta̱na chjasintajni. ");
INSERT INTO poeNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Tjáncháhya kíxin chrókuakítsjehé sín chjasintajni. Náhí. Tjáncháhá kíxin chrókꞌuayakonhén sín kíxin chrókjuichꞌiyehya sín tí Jínahya. ");
INSERT INTO poeNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Jehe sín la jehya kuènte chjasintajni éxí yóhe̱ janhan kja̱xin janhya kuènte chjasintajni. ");
INSERT INTO poeNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Nchetjuáxian sín tí kjuachaxin kuèntá kíxin itán jaha mé tí tan chaxín ntoá. ");
INSERT INTO poeNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Éxí yóhe̱ jaha kuétua̱nna kꞌuinka chjasintajni mé xi̱kaha janhan tétua̱nha̱n sín kíxin chrókꞌuejóyákjan sín tí sín chjasintajni. ");
INSERT INTO poeNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Jehó tí xra̱ kuèntá chrókjui̱tꞌa kíxin chrókjuinki̱tsa tí jehe sín, a̱ ntá jehe sín kja̱xin chrókjuichꞌe sín tí xra̱ kuèntá kíxin kuínhin sín itán chaxín ntoá. ");
INSERT INTO poeNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Kjánchó jehya kíxin xrja̱nóa̱ha kíxin chrókjuínki̱tsa tí jehó sín. Náhí. Kja̱xin xrja̱nóa̱ha kíxin chrókjuínki̱tsa kaín tí sín tsitekaon sín chrꞌéxi̱n tsinhin sín tí nkehe tsochrónka tí sín a. ");
INSERT INTO poeNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Mé xi̱kaha xrja̱nóa̱ha kíxin kaín tí jehe sín jnkoko̱á chrókjuenka̱yáxin sín éxí jaha Itꞌéni la ko janhan jnkoko̱á tjenka̱yáxinni mé xi̱kaha xrja̱nóa̱ha kíxin kaín tí jehe sín la ko jaha la ko janhan jnkoko̱á chrókjuenka̱yáxinni. A̱ ntá tí sín chjasintajni chrókuitekaon sín kíxin jaha tsíkétua̱nna kꞌuinka ntihi. ");
INSERT INTO poeNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","A̱ ntá tí kjuachaxin jié chjìna na mé tja̱ha̱ tí jehe sín kíxin ntá kaín sín jnkoko̱á chrókjuenka̱yáxin sín éxí yóhe̱ jaha la ko janhan jnkoko̱á tjenka̱yáxinni. ");
INSERT INTO poeNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Janhan la ko jehe sín jnkoko̱á chrókjuenka̱yáxinni éxí jaha la ko janhan jnkoko̱á tjenka̱yáxinni. Mé xi̱kaha tí sín chjasintajni chrókónohe sín kíxin jaha kuétua̱nna kꞌuinka la ko kja̱xin chrókónohe sín kíxin jaha tjuèhé tí jehe sín éxí yóhe̱ tjua̱na tí jaha. ");
INSERT INTO poeNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Jaha Itꞌéni, tí sín kjuánjuan la tjínka̱van kíxin tí jehe sín chrókꞌuejóki̱an sín tí tsjakꞌé janhan kíxin chrókꞌuikon sín tí kjuachaxin jié chjìna; kíxin xráxín na̱xa̱ kꞌónahya chjasintajni kꞌuétjua̱na jaha. ");
INSERT INTO poeNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Itꞌéni jaha, imá jína jaha. Kjónté tí sín chjasintajni na̱xa̱ chónhya sín tí jaha, ntá janhan na ó xráxín choxian tí jaha la ko kaín tí sín i kja̱xin ó nohe sín kíxin jaha kuétua̱nna kꞌuinka. ");
INSERT INTO poeNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ó kjuáko̱ha̱ sín kíxin nkexro tí jaha la ko xi̱kaha na̱xa̱ tsjáko̱ha̱ sín, kíxin éxí tjua̱na jaha mé xi̱kaha chrótjuèhe sín kíchó sín la ko janhan chrókꞌuejóki̱an tí jehe sín ―mé xi̱kaha chrónóe̱he̱ chꞌín Jesús tí Itꞌé chꞌán.﻿ ");
INSERT INTO poeNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ó kjuixin ntáchro chꞌín Jesús kaín tíha ntá jehe chꞌán la ko tí sín kꞌuájiko chꞌán kꞌuaxrjexín sín ntiha kꞌuatòye̱ sín tí tsa̱ka Cedrón. Ntaha tjen ijnko nonte siín nchónhya nta kꞌuíxenhen chꞌín Jesús la ko tí sín kꞌuájiko chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Kja̱xin chꞌín Judas tí chꞌín sinchekji tí chꞌín Jesús mé nohe chꞌán kíxin ntaha tjen tí huerto a kíxin ntaha jnkoya̱xón kójnkotséko chꞌín Jesús tí sín kꞌuájiko chꞌán a. ");
INSERT INTO poeNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","A̱ ntá chꞌín Judas ó kjui̱ka̱o chꞌán nchónhya sín soldado la ko iso sín policía kuènte ni̱nko tsíkꞌe̱tue̱nhen tí sín ncha̱tꞌá tꞌe̱to̱an la ko tí sin fariseo. Ntá kjui sín kaín sín xraá sín chica la ko kjui̱ka̱o sín xrohi tꞌinkaséyanxín tí kjui̱xi̱n sín. ");
INSERT INTO poeNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","A̱ ntá chꞌín Jesús ó nohe chꞌán kaín xín nkehe tsꞌatsínka chꞌán, ntá sákjuí chꞌán kjuanchankíhi chꞌán sín ntáchro chꞌán kíxin: ―¿Nkexro xritjéyárá? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ntá kjuáte̱he sín ntáchro sín kíxin: ―Tjeyáni tí chꞌín Jesús tsíkji̱xi̱n chjasin Nazaret ―ichro sín. Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Janhan tíha ―ichro chꞌán. A̱ ntá chꞌín Judas tí chꞌín tsíkjinchekji tí chꞌín Jesús mé koí tjenkákjan chꞌán tí jehe sín ntiha. ");
INSERT INTO poeNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","A̱ ntá tió kjuáte̱he chꞌín Jesús kíxin jehe chꞌán tíha, ntá jehe sín xráchonka sín kjuítsínka sín nonte. ");
INSERT INTO poeNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ntá xíkjanchankí chꞌín Jesús ínaá ntáchro chꞌán kíxin: ―¿Nkexro xritjéyárá? ―ichro chꞌán. Ntá xíntáchro sín kíxin: ―Tjeyáni tí chꞌín Jesús tsíkji̱xi̱n chjasin Nazaret ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ntá ntáchro chꞌín Jesús kíxin: ―Ó kjuixin tjo̱nka̱rá kíxin janhan tíha. Tí xritjéyárá tí janhan ntá ti̱to̱hérá sátsji tí í so sín xríki̱an ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Mé xi̱kaha ntáchro chꞌín Jesús kíxin ntá tsoxiteyá tí nkehe tsíntáchro chꞌán kíxin: “Tí sín kjuanjon Tꞌaná la ninkexró kjui̱ntakꞌitjáyanhya.” ");
INSERT INTO poeNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ntá chꞌín Simón Pedro kuakitsje chꞌán tí chica espada chrinkatoxi̱n chꞌán kóchrínjin chꞌán ta̱tsjon chjina ijnko chꞌín itꞌin Malco, mé ijnko chꞌín chꞌehe ncha̱tꞌá tꞌe̱to̱an xra̱. ");
INSERT INTO poeNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Kjánchó chꞌín Jesús ntáche chꞌán tí chꞌín Pedro kíxin: ―Chrꞌa̱xenhén tjo̱e chica espada méhe̱. Kjá ntáchrua kíxin tsjasótehyana, kjá ichrua. Kjánchó Tꞌaná kjuanjon kjuachaxin kíxin nchónhya tsjasótena ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","A̱ ntá tí sín soldado la ko tí chꞌín comandante tꞌe̱tue̱nhen sín la ko tí sín policía judío kuènte ni̱nko mé itsé sín tí chꞌín Jesús kjuínchenteto sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","A̱ ntá sákjuíko sín chꞌán nto̱e chꞌín Anás ichꞌe̱e tí chꞌín Caifás mé tí nkexro tsíkꞌáyéhe̱ xra̱ ncha̱tꞌá tꞌe̱to̱an tí nánó a. ");
INSERT INTO poeNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","A̱ ntá tí chꞌín Caifás, jehe chꞌán na mé tí nkexro tsíntáche tí sín judío kíxin íchá jína kíxin jnkoko̱á chojni chrókꞌuenyákonhe̱n kaín tí sín chjasén chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Chꞌín Simón Pedro la ko í jnko chꞌín kꞌuékꞌajiko chꞌín Jesús mé kuinkáchréhe̱ sín chꞌán. Tí chꞌín ijnko a mé chóxin chꞌán tí ncha̱tꞌá tꞌe̱to̱an. Ntá kꞌuíxenko chꞌán tí chꞌín Jesús tí nta̱sin nto̱e tí ncha̱tꞌá tꞌe̱to̱an. ");
INSERT INTO poeNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Kjánchó chꞌín Pedro kuíto̱he chꞌán ntója nta̱sin ó. Ntá tí chꞌín ijnko a chóxin tí ncha̱tꞌá tꞌe̱to̱an mé kꞌuaxrje chꞌán nta̱sin nixje̱he̱ chꞌán tí tjan tꞌayakonhen tí ntója nta̱sin chrónóe̱he̱ chꞌán tjan ntá xranjon kjuachaxin ntá kꞌuíxenhen chꞌín Pedro kja̱xin. ");
INSERT INTO poeNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Na ntá tí tjan tꞌayakonhen tí ntója nta̱sin kjuanchankíhi tjan tí chꞌín Pedro kíxin: ―¿Á jahya kja̱xin xríkoa tí chꞌín a? ―ichro tjan. Ntá kjuáte̱he chꞌín Pedro kíxin: ―Náhí, janhya ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ntá imá kin ntá tí sín chꞌexón xra̱ la ko tí sín policía kjuaka sín xrohi ntaha tjejóxin to̱té sín tjejóchjixro̱he sín. La ko koí chꞌín Pedro tjechjixro̱he chꞌán ntiha. ");
INSERT INTO poeNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ntá tí ncha̱tꞌá tꞌe̱to̱an kjuankíxin kjuanchankíhi chꞌán tí chꞌín Jesús kíxin nkexro tí sín kꞌuájiko chꞌán la ko nkehe tí kjua̱ko̱he̱ chꞌán sín. ");
INSERT INTO poeNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Noxín kjuakꞌé kjuàkua, la ntá kaín xín chojni kuínhin sín. Xráxín kꞌuékjáko̱xia̱n kaín xín tí ni̱nko ntsí la ko tí ni̱nko jié tójnkotséxin kaín xín sín judío. Ninkehó nkehe kjuákohya imó. ");
INSERT INTO poeNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Nkekuènté tjanchankìna tí janhan xi̱kaha? Chrókjuanchankíhí tí sín kuínhin kíxin nkexrí kjuáko̱ha̱ sín. Jehe sín mé nohe sín nkehe kjuáko̱ha̱ sín ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Kjuixin ntáchro chꞌín Jesús tíhi ntá ijnko chꞌín policía kuènte ni̱nko mé tjentaxín chꞌán ntiha chjéhe chꞌán nkayakon tí chꞌín Jesús ntáchro chꞌán kíxin: ―¿Á xi̱kaha jie̱he tsjáte̱hé tí ncha̱tꞌá tꞌe̱to̱an ní? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Tí ntoáhya tí nkehe xrja̱nka ntá chro̱nka nkehe tí ntoáhya. A̱ ntá tí ntoá tí nkehe xrja̱nka, ¿ntá nkekuènté kíxin tjatena? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ntá kꞌue̱to̱an chꞌín Anás kíxin tjechróntetoxinhín chꞌín Jesús sátsji chꞌán tí tjen chꞌín Caifás tí ncha̱tꞌá tꞌe̱to̱an. ");
INSERT INTO poeNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ntá chꞌín Simón Pedro mé na̱xa̱ tjexín to̱té chꞌán tjechjixro̱he chꞌán. Ntá kjuanchankíhi sín chꞌán kíxin: ―¿Á kja̱xinhya jaha xríkoa tí nkexro i ní? ―ichro sín. Ntá chꞌín Pedro kjuínchemá chꞌán ínaá ntáchro chꞌán kíxin: ―Náhí, janhya ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","A̱ ntá ijnko chꞌín chꞌehe tí ncha̱tꞌá tꞌe̱to̱an xra̱, na mé tí chꞌín a mé na̱xa̱ kjéhya chꞌán tí chꞌín tsíkóchrínjin chꞌín Pedro ntatsjon, na mé kjuanchankí chꞌán kíxin: ―¿Á jehya jaha tí kꞌuíkua̱n tjekoa chꞌán tí huerto ní? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ntá chꞌín Pedro xíkjinchemá chꞌán ínaá kíxin jehya chꞌán, ichro chꞌán. Ntá xrína̱hya tuénxín itsje ijnko kochínto̱a. ");
INSERT INTO poeNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ntá kꞌuaxrjexín sín nto̱e chꞌín Caifás, sákjuíko sín chꞌín Jesús tí palacio tꞌe̱to̱anxín tí chꞌín gobernador. Ntá ó kjuankíxin kꞌuínkaséyan kjuíji sín ntiha. A̱ ntá tí sín judío la mé í kꞌuíxenhya sín tí palacio kíxin tí xi̱kaha chrókꞌuixenhen sín tí nchia a la chrókuamá sín tí jie̱ siín ntiha la í xitjahya sine sín tí kia pascua, ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","A̱ ntá chꞌín Pilato kꞌuaxrjexín chꞌán tí nchia tꞌe̱to̱anxín chꞌán kjuanchankíhi chꞌán sín kíxin: ―¿Nkehe tí jie̱ chónta tí nkexro i? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ntá kjuáte̱he sín ntáchro sín kíxin: ―Tí chróchóntahya chꞌán jie̱ jié la chrókjui̱ko̱ahyani chꞌán ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ntá kꞌue̱to̱an chꞌín Pilato kíxin: ―Sátjíkoará chꞌán nchekito̱exínrá nkerí jie̱ chónta chꞌán kíxin éxí ntáchro tí ley kuèntárá ―ichro chꞌán. Ntá kjuáte̱he tí sín judío ntáchro sín kíxin: ―Jeheni chojni judíoni la chóntahyani kjuachaxin tsꞌóyánni ninkexró ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Mé xi̱kaha tsoxiteyá tí nkehe tsíntachro chꞌín Jesús kíxin nkexrí tsꞌenxín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ntá chꞌín Pilato xíkꞌixenhen chꞌán tí nchia tꞌe̱to̱anxín chꞌán ntá kꞌuíye̱he̱ chꞌán tí chꞌín Jesús kjuanchankíhi chꞌán kíxin: ―¿Á jaha tí nkexro Rey tꞌe̱tue̱nhen tí sín judío ní? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ntá ntáchro chꞌín Jesús kjuanchankí chꞌán kíxin: ―Tí nkehe tjanchankìná, ¿á jahyá kjuenka̱yáxian xi̱kaha, o̱ á í jnko nkexro kjuanchia jie̱ kíxin tí janhan? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ntá kjuáte̱he chꞌín Pilato ntáchro chꞌán kíxin: ―¿Á kjanhya janhan tí judío kíxin? Tí sín chjasán la ko tí sín ncha̱tꞌá tꞌe̱to̱an mé kjuikaán sín tí jaha. ¿Xá nkehe kjui̱chꞌe kíxin? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Tí kjuachaxin chonta janhan jehya kíxin chjasintajni chrókuéto̱an. Náhí. Tí chrókuéto̱an chjasintajni ntá tí sín xríki̱an chrókjuanjo̱nko sín tí sín judío kíxin chrótséhyana sín la chrókjuikánhyana sín ntihi. Kjánchó tí kjuachaxin chonta janhan jehya kíxin chjasintajni chrókuéto̱an ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ntá ntáchro chꞌín Pilato kíxin: ―¿Á jaha chaxín ijnko rey? ―ichro chꞌán. Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Janhan tí rey éxí ntáchrua jaha. Tí xra̱ ó kokjìna la ko tí xra̱ ó kꞌuinka chjasintajni kíxin tso̱xrja̱nka nkehe tí chaxín ntoá. Kaín tí sín titekaon tí nkehe chaxín ntoá mé tjejótinhin sín tí nkehe tjàkua ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ntá ntáchro chꞌín Pilato kíxin: ―¿Xá nkehe tí nkehe chaxín ntoá, ichrua? ―ichro chꞌán. Ntá kjuixin kjuanchankí chꞌín Pilato tíha ntá kꞌuaxrjexín chꞌán ntiha ntá sákjuí chꞌán tí tjejó tí sin judío nixje̱he̱ chꞌán sín ntáchro chꞌán kíxin: ―Kꞌuítjáhya ninkehó jie̱ chónta tí nkexro i. ");
INSERT INTO poeNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Kjánchó jahará la ó kuánhanrá kíxin tí kia pascua tsjánjuan kjuachaxin kíxin tsꞌatjánta ijnko nkexro tjechjina. ¿Á tjinkáonrá kíxin tsꞌatjánta tí chꞌín Rey tꞌe̱tue̱nhen tí sín judío? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ntá kaín sín kꞌóyako sín kjuanchia sín kíxin: ―Tí chꞌín a la náhí. Tꞌatjánta tí chꞌín Barrabás ―ichro sín. Kjánchó tí chꞌín Barrabás mé ijnko chojni che̱e tíha.﻿ ");
INSERT INTO poeNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ntá chꞌín Pilato mé kꞌue̱to̱an chꞌán kíxin tsjate sín tí chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ntá tí sín soldado kjuíchꞌéna sín ntachꞌi̱ ijnko corona ntá kjua̱kꞌe̱nka̱ya sín ikja tí chꞌín Jesús. La ko kjuínchekꞌinkáya sín chꞌán ijnko ka kjátse tié kíxin jehe sín tsjikosáyehe sín chꞌán éxí ijnko rey, kjánchó chaxínhya tíha. ");
INSERT INTO poeNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ntá kóchjinehe sín tí tjen chꞌán ntáchro sín kíxin: ―Isé tsjakꞌe tsétue̱nhén tí sín judío ―ichro sín. Kjánchó chaxínhya tíha kjuanoá sín chꞌán. La ntá tuénxín itja sín kjuatexín sín nkayakon chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ntá chꞌín Pilato kꞌuaxrjexín chꞌán tí nchia tꞌe̱to̱anxín chꞌán ínaá nixje̱he̱ chꞌán tí sín tsíkójnkotsé ntáchro chꞌán kíxin: ―Tsjehérá tsakítsjexián chꞌán ntihi kíxin tso̱nohará kíxin kꞌuítjáhya janhan ninkehó jie̱ chónta chꞌán ―ichro chꞌín Pilato. ");
INSERT INTO poeNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ntá kꞌuaxrjexín chꞌín Jesús ntiha tjenkáya kja chꞌán tí corona tsíkꞌóna ntachꞌi̱ la ko tjenkáya chꞌán tí ka kjátse tié. Ntá ntáchro chꞌín Pilato kíxin: ―Tsjehérá, ntihi tjen chꞌán ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","A̱ ntá tió kꞌuíkon tí sín ncha̱tꞌá tꞌe̱to̱an la ko tí sín policía kuènte ni̱nko ntá kjuankíxin sín tꞌóyako sín ntáchro sín kíxin: ―¡Tjakénka̱nirá chꞌán ntacruz! ¡Tjakénka̱nirá chꞌan ntacruz! ―ichro sín. Ntá ntáchro chꞌín Pilato kíxin: ―Jahará tjíkoará chꞌán tjaké nka̱nirá chꞌán ntacruz kíxin janhan kꞌuítjáhya ninkehó jie̱ chónta tí jehe chꞌán ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ntá kjuáte̱he tí sín judío kíxin: ―Jeheni chojni judío mé chóntani ijnko ley tꞌe̱to̱an kíxin chrókꞌuen chꞌán kíxin ncheyóhe̱ chꞌán a̱sén chꞌán kíxin Xje̱en Dios tí jehe chꞌán ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ntá tió kuínhin chꞌín Pilato tíha ntá a̱ntsí chrakon chꞌán ");
INSERT INTO poeNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ntá xíkꞌixenhen chꞌán tí nchia tꞌe̱to̱anxín chꞌán ínaá kjuanchankíhi chꞌán tí chꞌín Jesús kíxin: ―¿Nketí kꞌuinkaxian jaha? ―ichro chꞌán. Ntá chꞌín Jesús ninkehó kjuáte̱ehya chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ntá ntáchro chꞌín Pilato kíxin: ―¿Jaha nkekuènté tjáte̱ehya nkehe tjánchánkíha? ¿Á noahya jaha kíxin chonta janhan kjuachaxin tséto̱an tsjakꞌenka̱nia ntacruz la ko kja̱xin chonta janhan kjuachaxin tsontáxrja̱n kíxin sátsjia kohya nkehe tso̱nhan? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ntá kjuáte̱he chꞌín Jesús ntáchro chꞌán kíxin: ―Ninkehó kjuachaxin chróchontahya jaha chrókuéto̱an chrókꞌuén o̱ sáchrókjuia tí Dios chrótjáhya tí kjuachaxin. A̱ ntá tí chojni kjuikaána tí tjen jaha la a̱ntsí jié jie̱ chónta sín, a̱ ntá jaha la kánhyó ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ntá kuínhin chꞌín Pilato tíhi ntá kjuankíxin chꞌán kjueyá chꞌán nkexrí chrókꞌue̱to̱an chꞌán kíxin sáchrókjui chꞌín Jesús kohya nkehe chrókónhen chꞌán. Kjánchó tí sín judío kꞌóyako sín ntáchro sín kíxin: ―Kja̱ tí tsi̱to̱hé sátsji chꞌán kohya nkehe tso̱nhen chꞌán ntá jaha jnkoko̱áhya tjenka̱yáxinkoa tí chꞌín tꞌe̱tue̱nhen tí nación kuènténi. Tí nkexro chꞌéna a̱sén chꞌán éxí ijnko rey mé nínkakonhen chꞌán tí chꞌín tꞌe̱tue̱nhenni ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ntá kuínhin chꞌín Pilato tíhi ntá kꞌue̱to̱an chꞌán kíxin tsakitsje sín tí chꞌín Jesús ntója ntá chꞌín Pilato kjuákꞌetja̱xi̱n chꞌán tí silla nchekito̱exín chꞌán jie̱, mé nkìva hebreo mé itꞌin Gabata, mé tꞌaxrjexín kíxin tja̱tꞌo̱ noi jehó xro̱ tsíkꞌóna. ");
INSERT INTO poeNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Na mé ó chjina chonkíxin ntá tí tso̱njín la mé ó tsjasin sín tí kia pascua. Ntá chꞌín Pilato ntáche chꞌán tí sín judío kíxin: ―Ntihi itjen tí chꞌín rey kuèntárá ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Kjánchó jehe sín kꞌóyako sín ntáchro sín kíxin: ―¡Itsꞌen chꞌán! ¡Itsꞌen chꞌán! ¡Tsjakꞌenkáni chꞌán ntacruz! ―ichro sín. Ntá ntáchro chꞌín Pilato kíxin: ―¿Á tjinkáonrá kíxin janhan chrókjuakénka̱nia ijnko ntacruz tí chꞌín rey kuèntárá ní? ―ichro chꞌán. Kjánchó tí sín ncha̱tꞌá tꞌe̱to̱an mé kjuáte̱he sín kíxin: ―Náhí. Chóntahyani í jnko rey, jehó tí chꞌín César ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ntá chꞌín Pilato kjuanjon chꞌán kjuachaxin sátsjiko sín tí chꞌín Jesús tsja̱kꞌe̱nka̱ni sín chꞌán ntacruz. Ntá sákjuíko sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ntá sákjuíko sín tí chꞌín Jesús kuámá chꞌán tí ntacruz tsjakꞌenkáni chꞌán. Ntá kjuíjiko sín chꞌán ijnko tjo ti̱ki̱texín sín Hueso Kja Chojni. A̱ ntá nkìva hebreo mé ti̱ki̱texín sín Gólgota. ");
INSERT INTO poeNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ntaha mé kjua̱kꞌe̱nka̱ni sín chꞌán tí ntacruz. Ntá kja̱xin yaá sín nánánko kꞌuéjó jnkojnko sín ntá jnko̱siné kjuákꞌe chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ntá kꞌue̱to̱an chꞌín Pilato kíxin tsokjin sín ijnko ntachiso tsja̱kꞌe̱nka̱ni sín ikja tí ntacruz ntáchro kíxin: “Chꞌín Jesús kjui̱xi̱n chꞌán chjasin Nazaret, mé tí chꞌín Rey kuènte tí sín judío”, tsixro. ");
INSERT INTO poeNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","A̱ ntá itsjé tí sín judío mé kjuínchekuáxin sín tí letra tsíkꞌóna kíxin chjino tí chjasin Jerusalén tsíkja̱kꞌe̱nka̱ni sín chꞌín Jesús ntacruz la ko iní nkìva tsíkjin sín, na mé ijnko nkìva la hebreo, la ijnko nkìva la griego, la ijnko nkìva la latín. ");
INSERT INTO poeNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ntá tí sín ncha̱tꞌá tꞌe̱to̱an kuènte tí sín judío mé ntáche sín tí chꞌín Pilato kíxin: ―Chrókjinhya jaha xi̱kaha kíxin jehe chꞌán mé tí “Chꞌín Rey kuènte tí sín judío.” Náhí. Íchá jína chrókjian jaha kíxin “Jehe chꞌán ntáchro chꞌán kíxin jehe chꞌán mé tí chꞌín Rey kuènte tí sín judío” ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Kjánchó kjuáte̱he chꞌín Pilato kíxin: ―Tí letra kuéto̱an kꞌóna la ó kꞌóna, kjónté xi̱kahó tsito̱he ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ntá tí sín soldado tió tsíkjixin tsíkja̱kꞌe̱nka̱ni sín tí chꞌín Jesús tí ntacruz ntá kuákja sín tí ké chꞌán la kꞌóxika̱ye̱he sín jnkojnko ka kuákja sín kanoé sín. La ko kja̱xin kuákja sín tí ka kjínjin kꞌuékꞌinkáya chꞌán. Tí ka mé tsíxro̱nhya ka la me jnkoko̱á ka tíha. ");
INSERT INTO poeNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ntá tí sín soldado kjo sín kíchó sín ntáchro sín kíxin: ―Tsótséchjehyani tí ké chꞌán. Íchá jína sichꞌexínni suerte ntá tsotsjeheni siná nkexro tsꞌáyéhe̱ tí ka. Mé xi̱kaha xiteyá éxí ntáchro xroon itén Dios tsíkjin sín ósé ntáchro kíxin: “Kjuíchꞌexín sín suerte ntá kꞌóxika̱ye̱he sín kaná.” Mé xi̱kaha kjuíchꞌe tí sín soldado. ");
INSERT INTO poeNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","A̱ ntá chjino tí ntacruz kjuákꞌenkáni chꞌín Jesús mé kjuákꞌe tí ìné chꞌán la ko tí tjan kíchó tjan mé tjan María ichjién chꞌín Cleofas, la ko tí tjan María Magdalena. ");
INSERT INTO poeNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","A̱ ntá tió kꞌuíkon chꞌín Jesús kíxin itjen tí ìné chꞌán la ko chjino tjen tí chꞌín a̱ntsí tjuèhé chꞌán kꞌuékꞌajiko chꞌán, ntá nixje̱he̱ chꞌán tí ìné chꞌán, ntáchro chꞌán kíxin: ―Naná, tsjehé kíxin ntaha tjen xja̱an ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ntá nixje̱he̱ chꞌín Jesús tí chꞌín a ntáchro chꞌán kíxin: ―Tsjehé kíxin ntaha itjen ìná ―ichro chꞌán. A̱ ntá tí chꞌín a mé kꞌuáyéhe̱ chꞌán tí tjan a sákjuíko chꞌán tjan nto̱e chꞌán kꞌóna éxí ìné chꞌán xi̱kaha. ");
INSERT INTO poeNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ntá ó nohe chꞌín Jesús kíxin kaín xra̱ ó kjuixin xiteyá ntá tjinkaon chꞌán kíxin tsoxiteyá kaín nkehe ntáchro tí xroon tsíkjin sín ósé ntá xi̱kaha ntáchro chꞌán kíxin: ―Ikꞌuén nta̱. ");
INSERT INTO poeNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ntá ntiha tjen ijnko nchésen tsíkaón xranvino sán ntá kjuínchekjataxín sín ijnko ka tí xranvino, a̱ ntá tí ka a kjua̱kꞌe̱kjen sín ijnko nta kjínjin, ntá kjuínchechrìin sín tí tjen irꞌva chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ntá ikꞌuí chꞌín Jesús tí xranvino sán ntá ntáchro chꞌán kíxin: ―Ó kjuixin xiteyá kaín xín nkehe ―ichro chꞌán. Ntá kꞌuísén kja chꞌán ntá ó kjuixin kꞌuén chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","A̱ ntá xi̱kaha ya̱on ntóye mé tí ya̱on kia pascua ntá tí sín judío tjinkakonhya sín kíxin tí cuerpo kuènte tí sín tsíkꞌen na̱xa̱ tsꞌejóyáni tí ntacruz tí ya̱on tꞌo̱kꞌéhe sín kíxin tí ya̱on pascua mé ijnko ya̱on imá jié, ichro sín. Mé xi̱kaha kjuanchehe sín tí chꞌín Pilato kíxin tsꞌe̱to̱an chꞌán kíxin tsochjenjin to̱té tí sín tjejóyáni tí ntacruz la ko tsꞌinkajin tí cuerpo kuènte tí sín tsíkꞌen. ");
INSERT INTO poeNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ntá tí sín soldado sákjuí sín kꞌóchjenjin sín tí to̱té tí chꞌín sa̱oxín tjen la ko kꞌóchjenjin sín tí to̱té tí chꞌín tjen nánko a tjejóyáni sín tí ntacruz tí tjen chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ntá kjuíji sín tí tjen chꞌín Jesús ntá kꞌuíkon sín kíxin ó tsíkjixin tsíkꞌen chꞌán, ntá í kꞌóchjenjinhya sín to̱té chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","A̱ ntá ijnko chꞌín soldado mé chrꞌáte chꞌán chica yo tí chjia tí chꞌín Jesús ntá tuénxín kꞌuaxrje jni̱ la ko ìnta̱. ");
INSERT INTO poeNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","A̱ ntá janhan mé tjékjian tí xroon i mé kjuakꞌé ntiha kꞌuíkua̱n kíxin xi̱kaha kónhen ntá ntoá tjéxrja̱nka kíxin jahará kja̱xinrá chrókuítekáonrá. ");
INSERT INTO poeNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Mé xi̱kaha kónhen tíha kíxin tsoxiteyá tí nkehe ntáchro xroon itén Dios tsíkjin sín ntáchro kíxin: “Kꞌóchjenjinhya sín ninkehó huéso̱e chꞌán.” ");
INSERT INTO poeNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Kja̱xin itjen í jnko nketí nixja tí xroon itén Dios tsíkjin sín ósé ntáchro kíxin: “Tsokomá sín tí nkexro tsíchrꞌáte sín chica.” ");
INSERT INTO poeNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ntá ó kjuixin kónhen kaín tíha ntá chꞌín José, mé ijnko chꞌín kjui̱xi̱n chjasin Arimatea, mé kjuanchehe chꞌán tí chꞌín Pilato kjuachaxin kíxin tsjinkaji̱nxi̱n chꞌán tí ntacruz tí cuerpo kuènte chꞌín Jesús sátsjiko chꞌán tsja̱vá chꞌán. Jehe chꞌán imó kuinkáchónki chꞌán tí chꞌín Jesús kíxin chrako̱nhe̱n chꞌán tí sín judío. Ntá chꞌín Pilato mé kjuanjon chꞌán kjuachaxin ntá sákjuíko chꞌín José tí cuerpo kuènte chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Kja̱xin chꞌín Nicodemo, tí chꞌín kjuínixje̱he̱ tí chꞌín Jesús ijnko tie a mé kjui chꞌán kjui̱ka̱o chꞌán treinta kilo xro̱a̱n xraxé tjiko xro̱a̱n mirra la ko xro̱a̱n áloes. ");
INSERT INTO poeNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Mé xi̱kaha chꞌín José la ko chꞌín Nicodemo kꞌuáyéhe̱ sín tí cuerpo kuènte chꞌín Jesús kjuínchekꞌísímá sín ijnko ka kjínjin tsíka tí xro̱a̱n xraxé a kíxin xi̱kaha kꞌuékinkáchónki tí sín judío kꞌuékja̱vá sín chojni tsíkꞌen. ");
INSERT INTO poeNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Tí kjuákꞌenkáni chꞌín Jesús ntacruz ntá chjinaxón ntiha tjen ijnko huerto itjen ijnko tòye̱ ni̱xin na̱xa̱ ninkexró tsíxráváhya ntiha. ");
INSERT INTO poeNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ntaha kjua̱vá sín tí chꞌín Jesús kíxin chjinaxón tjen tí tòye̱ a la ko í séhya tsoxrankíxin tí ya̱on tꞌo̱kꞌéhe tí sín judío.﻿ ");
INSERT INTO poeNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","A̱ ntá tí ya̱on xrankíxixín semana ntá tí tjan María Magdalena na̱xa̱ sítié sákjui̱ tjan tí tjen tí tòye̱, ntá kꞌuíkon tjan kíxin ó tsíkjìin tí xro̱ tsíkꞌikjèxin tí tòye̱ a. ");
INSERT INTO poeNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ntá kuinká tjan sákjuí tjan tí tjen tí chꞌín Simón Pedro la ko tí chꞌín í jnko, mé tí nkexro imá kꞌuétjuèhe chꞌín Jesús, ntá ntáchro tjan kíxin: ―Ó tsíkakitsjexín sín tòye̱ tí cuerpo kuènte Ìnchéni ntá noehyani nketí tsíkjakꞌe sín ―ichro tjan. ");
INSERT INTO poeNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ntá chꞌín Pedro la ko tí chꞌín í jnko mé kuínhin sín xi̱kaha ntá sákjui̱ sín tí tjen tí tòye̱ a. ");
INSERT INTO poeNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ntá yóí sín kuinká sín sákjui̱ko kíchó sín. Kjánchó tí chꞌín í jnko a̱ntsí tji̱a̱n kuinká chꞌán ntá kánhyó tji̱a̱n kuinká chꞌín Pedro, ntá tí chꞌín í jnko senó chꞌán kjuíji chꞌán tí tjen tí tòye̱ a. ");
INSERT INTO poeNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Kꞌuísén chꞌán tsjehe chꞌán nkaxenhen tí tòye̱ a. A̱ tí ka tsíkꞌisímá chꞌín Jesús mé na̱xa̱ tjejó kꞌuíkon chꞌán, kjánchó jehe chꞌán kꞌuíxenhya chꞌán tí tòye̱ a. ");
INSERT INTO poeNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ntá kjónté chrꞌéxi̱n kjuíji chꞌín Simón Pedro ntá kꞌuíxenhen chꞌán tí tòye̱ a. Ntá kja̱xin kꞌuíkon chꞌán kíxin tjejó tí ka tsíkꞌisímá chꞌín Jesús ");
INSERT INTO poeNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","la ko kꞌuíkon chꞌán tí ka tsíkꞌisímá ikja chꞌán na mé tí ka tsíxrèya ka la ókjé tjen ka, a̱ ntá tí í so ka na mé ókjé tjejó ka kja̱xin. ");
INSERT INTO poeNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Na ntá tí chꞌín í jnko kꞌuékꞌajiko chꞌín Jesús, mé tí chꞌín tsíkjiji senó na kja̱xin kꞌuíxenhen chꞌán tí tòye̱ ntá kꞌuíkon chꞌán tí nkehe tsíkónhen ntá kuítekaon chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Kíxin na̱xa̱ kꞌuékienxínhya sín tí nkehe kꞌuéchrónka xroon itén Dios kíxin tꞌichjánxi̱n tsoxechón tí chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","A̱ ntá tí sín sátsíkji̱tsjehe tòye̱ la xíkjan sín nto̱e sín. ");
INSERT INTO poeNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ntá tjan María mé ntahó kuíto̱he tjan ntója tí tòye̱ tsjánka tjan. Na̱xa̱ tsjánka tjan kꞌuísén tjan tsjehe tjan nkaxenhen tí tòye̱ ");
INSERT INTO poeNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ntá xrína̱hya kꞌuíkon tjan yaá sín ángel tjejóyá sín ka tjóá tjejótja̱xi̱n sín tí tsíkjakꞌe tí cuerpo kuènte chꞌín Jesús na mé ijnko chꞌín ángel na mé tjen chꞌán tí tsíkjakꞌe ikja chꞌín Jesús la ko tí í jnko a itjen chꞌán tí tsíkꞌejó to̱té chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","A̱ ntá tí sín ángel mé kjuanchankí sín kíxin: ―Naná, ¿kuènte tsja̱nka? ―ichro sín. Ntá kjuáte̱he tjan ntáchro tjan kíxin: ―Sátsíkjiko sín Ìnchéni, ntá nonahya nketí tsíkjakꞌe sín chꞌán ―ichro tjan. ");
INSERT INTO poeNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Kjuixin ntáchro tjan tíha ntá kuinkátjíá tjan ntá kꞌuíkon tjan kíxin itjen chꞌín Jesús, kjánchó kjuátso̱anhya tjan kíxin jehe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ntá chꞌín Jesús kjuanchankíhi chꞌán tjan ntáchro chꞌán kíxin: ―Naná, ¿nkekuènté tsja̱nka? ¿Nkexro tjéyá? ―ichro chꞌán. A̱ ntá jehe tjan kjuenka̱yáxin tjan kíxin jehe chꞌán mé tꞌayakonhen chꞌán tí huerto, a̱ ntá ntáchro tjan kíxin: ―Kja̱ tí jaha sákjuíkoa chꞌán ntá jie chro̱nka nketí sákjuíkoa chꞌán kíxin janhan sátsji̱ki̱an chꞌán jie ―ichro tjan. ");
INSERT INTO poeNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ntá chꞌín Jesús mé nixje̱he̱ chꞌán tjan ntáchro chꞌán kíxin: ―¡María! ―ichro chꞌán. Ntá kuinkátjíá tjan ntá nixja̱xi̱n tjan nkìva hebreo ntáchro tjan kíxin: ―¡Raboni! ―ichro tjan. Tíha mé tꞌaxrjexín kíxin Maestro. ");
INSERT INTO poeNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ntá ntáchro chꞌín Jesús kíxin: ―Tatjántana kíxin na̱xa̱ sátjíhya janhan tí tjen Tꞌaná. Sátjia tjítsjehé tí sín kíchiná chénka sín kíxin sátsjiyá tí tjen Tꞌaná na mé kja̱xin Itꞌárá tí jahará na mé Dios kuènta̱na la ko kja̱xin Dios kuèntárá ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ntá tí tjan María Magdalena sákjuíchénka tjan tí sín kꞌuékꞌajiko chꞌín Jesús chrónka tjan kíxin xi̱kaha tsíkꞌikon tjan Ìnchéni. La ko kja̱xin chrónka tjan kíxin xi̱kaha tsíntáchro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","A̱ ntá ó kónjín tí ya̱on a mé tí ya̱on xrankíxixín semana, a̱ ntá tí sín kꞌuékꞌajiko chꞌín Jesús jnkoko̱á kójnkotsé sín nkaxenhen nchia tsíkꞌikjehe̱ sín ntója nchia jína kíxin chrako̱nhe̱n sín tí sín judío. Ntá xrína̱hya titàya̱ kónohe sín kꞌuíkon sín kíxin jnko̱siné tí tjejó sín itjen chꞌín Jesús, ntá nixje̱he̱ chꞌán kjua̱jna̱ tí sín kꞌuékꞌajiko chꞌán ntáchro chꞌán kíxin: ―Jína tjejorá ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ntá kjuixin ntáchro chꞌán tíhi ntá kjuako chꞌán itja chꞌán la ko chjia chꞌán. Ntá kóchéhe̱ tí sín kꞌuékꞌajiko chꞌán kíxin kꞌuíkon sín Ìnchéni. ");
INSERT INTO poeNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ntá ntáchro chꞌín Jesús ínaá kíxin: ―Kjuaxróxin tsꞌejorá. Yóhe̱ Tꞌaná kꞌue̱tua̱nna kꞌuinka, a̱ ntá jie la janhan tétua̱nhan tí jahará ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ntá kꞌuánote chꞌán tí jehe sín ntáchro chꞌán kíxin: ―Tꞌayéhérá Ncha̱kuen Dios. ");
INSERT INTO poeNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Tí tsꞌitjáyanhanrá tí jie̱ kjuasin jnkojín chojni ntá xi̱kaha tsjìin tí iji̱é sín. Ntá tí tsꞌitjáyanhyará tí jie̱ kjuasin jnkojín chojni ntá na̱xa̱ kjuìinhya tí iji̱é sín ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","A̱ ntá tí chꞌín Tomás, ijnko tí teyóxin sín kꞌuékꞌajiko chꞌín Jesús mé kja̱xin ti̱ki̱texín sín chꞌín Nóhé mé kohya chꞌán tí kui chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ntá chrꞌéxi̱n tí í so sín kꞌuékꞌajiko chꞌín Jesús ntáche sín chꞌán kíxin: ―Ó kꞌuíkonni Ìnchéni ―ichro sín. Kjánchó ntáchro chꞌín Tomás kíxin: ―Tí tsꞌíko̱nhya janhan tí tsíkjiatexín chica clavo itja chꞌán la ko tsochrꞌánxianhya dedo tjaná ntiha la ko tí tsochrꞌánxianhya tjaná tí chjia chꞌán, ¿na mé nkexrí chrókuíteka̱van? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","A̱ ntá tí kꞌuátsínka ijnko semana ntá jnkoko̱á kójnkotsé sín nkaxenhen nchia la ko kja̱xin kjuákꞌeko sín chꞌín Tomás. Tsíkꞌikjehe̱ sín ntója nchia jína ntá xrína̱hya titàya̱ kónohe sín kꞌuíkon sín kíxin jnko̱siné tí tjejó sín itjen chꞌín Jesús, ntá nixje̱he̱ chꞌán tí jehe sín kꞌuékꞌajiko chꞌán ntáchro chꞌán kíxin: ―Kjuaxróxin tsꞌejorá ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ntá ntáche chꞌán tí chꞌín Tomás kíxin: ―Chrꞌaxénhén dedo tjá tí tsíkjiatexín chica clavo tjaná la ko xrákoa tjá chrꞌaxénhén chji̱a̱na. Chróntáchrohya kíxin chaxínhya. Tsítekávan kíxin chaxín ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ntá kjuáte̱he chꞌín Tomás ntáchro chꞌán kíxin: ―¡Ìnchéni jaha la ko Dios kuènta̱na! ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ntá ntáche chꞌín Jesús tí chꞌín Tomás kíxin: ―Jaha Tomás kꞌuíkonjian ntá kuítekávan. Ntá a̱ntsí náxrjón tjejó tí sín kjónté kꞌuíkonhya la titekaon sín ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Chꞌín Jesús kjuasin chꞌán itsjé í so kjuaxroan náxrjón kꞌuíkon tí sín kꞌuájiko chꞌán kjónté chrónkahya tí xroon i kíxin xi̱kaha kónhen. ");
INSERT INTO poeNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Tí nkehe chrónka tí xroon i ikjian janhan kíxin chrókuítekáonrá jahará kíxin Jesús mé tí Cristo, mé tí Xje̱en Dios kíxin ntá kaín ni chróchóntani kjuachón jnkochríxín kíxin chrókuitekaonni chꞌán.﻿ ");
INSERT INTO poeNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","A̱ ntá chrꞌéxi̱n tí sín kꞌuékꞌajiko chꞌín Jesús titàya̱ xíkꞌikon sín tí jehe chꞌán ínaá chrínta nta̱yaon Tiberias. Mé xi̱kaha kónhen ");
INSERT INTO poeNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","kíxin jnkoko̱á kꞌuéjó sín chꞌín Simón Pedro la ko chꞌín Tomás, me tí chꞌín ti̱ki̱texín sín chꞌín Nóhé, la ko chꞌín Natanael kui̱xi̱n chꞌán chjasin Caná estado Galilea, la ko tí yaá xje̱en chꞌín Zebedeo la ko tí yaá sín ínaá kꞌuékꞌajiko chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ntá ntáchro chꞌín Simón Pedro kíxin: ―Sátsjitse̱ koche ―ichro chꞌán. Ntá kjuáte̱he sín kíxin: ―Koíni sátsjikoani ―ichro sín. Ntá sákjuí sín kꞌui̱tꞌótjen sín ijnko ntabárco̱. Kjánchó ninkehó koche tséhya sín kuenté tie. ");
INSERT INTO poeNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","A̱ ntá ó chjina tsꞌinkaséyan ntá xrína̱hya titàya̱ kꞌuíkon sín itjen chꞌín Jesús chrínta nta̱yaon, kjánchó kjuátso̱anhya tí sín kꞌuékꞌajiko chꞌán kíxin jehe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ntá kjuanchankíhi chꞌán sín kíxin: ―Jahará ntasoá, ¿á na̱xa̱ ninkehó koche tse̱hyará? ―ichro chꞌán. Ntá kjuáte̱he sín ntáchro sín kíxin: ―Na̱xa̱ ninkehó ko tséhyani ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ntá chꞌín Jesús ntáche chꞌán sín kíxin: ―Itérá tí nchísén tí nánko chjia chjina tí ntabárco̱ la tso̱tse̱rá va ―ichro chꞌán. Ntá xi̱kaha kjuíchꞌe sín kꞌue sín nchísén ntá í tjachahya sín tsakitsjenkíxin sín nta̱ tí nchísén kíxin nchónhya koche tjinká. ");
INSERT INTO poeNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","A̱ ntá tí chꞌín a̱ntsí tjuèhe chꞌín Jesús mé ntáche chꞌán tí chꞌín Pedro kíxin: ―¡Ìnchéni tí méhe̱! ―ichro chꞌán. Ntá kuínhin chꞌín Simón Pedro kíxin Ìnchéni tíha ntá kꞌuinkáya chꞌán iké chꞌán ínaá (kíxin tsíkakitsje chꞌán iké chꞌán) ntá kjuiánkí chꞌán nta̱. ");
INSERT INTO poeNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Tí í so sín kꞌuékꞌajiko chꞌín Jesús mé kjuíji sín tí chrínta nta̱yaon kjui̱ka̱o sín tí ntabárco̱ tinkánkákjentóxin tí nchísén tjinká koche chrítaón nta̱ kíxin ijnko ciento metro kjínxi̱n tí chrínta nta̱ kꞌuéjó sín. ");
INSERT INTO poeNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ntá kjuíji sín chrínta nta̱ ntá kꞌuínkaji̱nxi̱n sín tí ntabárco̱ ntá kꞌuíkon sín tjeche xrohi síxènki̱ xrinta ntá chrítaón tí xrinta tjekjen ijnko koche la ko nánko siín nio̱tja̱. ");
INSERT INTO poeNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ntá kjuanchia chꞌín Jesús ntáchro chꞌan kíxin: ―Xrákoará iso koche tsítse̱rá na̱ntá ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ntá chꞌín Simón Pedro kꞌui̱tꞌótjen chꞌán tí ntabárco̱ kuákja chꞌán tí nchísén kuinkánkákjen chꞌán xráka̱o chꞌán tí nchísén tjinká koche iye na mé ijnko ciento cincuenta y tres va. Ntá kjónté nchónhya va la kꞌuichjehya tí nchísén a. ");
INSERT INTO poeNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ntá ntáchro chꞌín Jesús kíxin: ―Xrákirá, interá ―ichro chꞌán. A̱ ntá nijnko tí sín kꞌuékꞌajiko chꞌán chrókjuanchankíhi sín chꞌán kíxin nkexro tí jehe chꞌán kíxin ó kjuátso̱an sín kíxin Ìnchéni tíha. ");
INSERT INTO poeNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ntá kóchjina chꞌín Jesús kuákja chꞌán tí nio̱tja̱ chjéhe chꞌán tí jehe sín la ko xi̱kaha xíkjanjon chꞌán tí koche. ");
INSERT INTO poeNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Tíhi mé níxin kꞌuíkon tí sín kꞌuékꞌajiko chꞌín Jesús kíxin tsíxechón chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Kjuixin kjóne sín ntá kjuanchankíhi chꞌín Jesús tí chꞌín Simón Pedro kíxin: ―Jaha Simón, xje̱en Jonás, ¿á a̱ntsí tjua̱na jaha, a̱ ntá tí í so la kánhyó? ―ichro chꞌán. Ntá kjuáte̱he chꞌín Pedro ntáchro chꞌán kíxin: ―Jeén, Ìnchéni, ó noha kíxin tjínka̱van tí jaha ―ichro chꞌán. Ntá ntáchro chꞌín Jesús kíxin: ―Ntá xi̱kaha la tꞌayakonhén tí kolélo kuènta̱na ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ntá yóxin kjuanchankí chꞌín Jesús ínaá kixin: ―Jaha Simón, xje̱en Jonás, ¿á tjua̱na jaha? ―ichro chꞌán. Ntá kjuáte̱he chꞌín Pedro ntáchro chꞌán kíxin: ―Jeén, Ìnchéni, ó noha kíxin tjínka̱van tí jaha ―ichro chꞌán. Ntá ntáchro chꞌín Jesús kíxin: ―Ntá xi̱kaha la tꞌayakonhén tí kolélo kuènta̱na ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ntá níxin kjuanchankí chꞌín Jesús kíxin: ―Jaha Simón, xje̱en Jonás, ¿á tjinkávan tí janhan? ―ichro chꞌán. A̱ ntá kꞌuává chꞌín Pedro kíxin níxin kjuanchankí chꞌín Jesús kíxin á tjinkaon chꞌán tí jehe chꞌán ntá ntáchro chꞌán kíxin: ―Jaha Ìnchéni, ó noha kaín xín nkehe. Ó noha kíxin tjínka̱van tí jaha ―ichro chꞌán. Ntá ntáchro chꞌín Jesús kíxin: ―Ntá xi̱kaha tꞌayakonhén tí kolélo kuènta̱na. ");
INSERT INTO poeNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ntá ijnko nkehe chaxín tjétjo̱nka kíxin tí na̱xa̱ kꞌuéntasoyá jaha kꞌuékꞌinka̱ya ká jahvá la ko kꞌuékjia tí kꞌuékóxrjínhan jaha. A̱ ntá tió tso̱táda jaha ntá tsjéntoá tjá ntá í jnko nkexro sintakꞌinkáya ka la ko sátsjikoa sín tí tóxrjía̱nhya sáchrókjuia ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","A̱ ntá tíhi mé chrónkaxín chꞌín Jesús kíxin nkexrí tsꞌenxín chꞌín Pedro na mé tꞌaxrjexín nkexrí tsochjéhe chꞌán Dios kjuasáya. Ntá kjuixin ntáchro chꞌín Jesús kíxin: ―Chréhé tí janhan ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ntá kuinkátjíá chꞌín Pedro ntá kꞌuíkon chꞌán kíxin tinkáchréhe̱ tí chꞌín a̱ntsí tjuèhe chꞌín Jesús, na mé tí nkexro kjuákꞌe chjinaxón tí kjuákꞌe chꞌín Jesús tí kjóne sín tsíkjanchankíhi chꞌán tí chꞌín Jesús kíxin nkexro sinchekji chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ntá chꞌín Pedro kꞌuíkon chꞌán kíxin tinkáchréhe̱ tí chꞌín a ntá kjuanchankíhi chꞌán tí chꞌín Jesús kíxin: ―Ìnchéni, ¿a̱ ntá tí chꞌín i la nkehe tso̱nhen chꞌán a? ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ntá kjuáte̱he chꞌín Jesús kíxin: ―Tí tjínka̱van na̱xa̱ chrókjuakꞌechón chꞌán tí chrókjan la jaha la chrókjuia̱téhya tíha. Ntá jaha la chréhé tí janhan ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ntá kjuankíxin kjo tí sín kꞌuékꞌajiko chꞌín Jesús kíxin tsꞌenhya tí chꞌín a. Ntá jehya kíxin ntáchro chꞌín Jesús kíxin chrókꞌuenhya tí chꞌín a. Náhí. Ó jehí ntáchro chꞌán kíxin tí tjinkaon chꞌán na̱xa̱ chrókjuakꞌechón tí chꞌín a tí chrókjan chꞌán chrókui chꞌán chrókjuiatéhya tí chꞌín Pedro chrókjuanchankí chꞌán nkehe tso̱nhen í jnko chojni. ");
INSERT INTO poeNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","A̱ ntá tí nkexro a mé tí nkexro chrónka kíxin chaxín kónhen kaín tíha la ko ikjin chꞌán tí xroon i. Ntá ó noheni kíxin tí nkehe tsíkjin chꞌán la chaxín ntoá tíha. ");
INSERT INTO poeNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Na̱xa̱ siín nchónhya nkehe kjua̱ko̱xi̱n chꞌín Jesús kjinhya janhan. Tí chrókꞌóna jnkojnko jnkojnko tíha ntáxrja̱n kíxin kjá chrókjuachahya tí chjasintajni chrókꞌuinka kaín tí xroon chrókꞌóna xi̱kaha. Amén. Ó tjen.");
INSERT INTO poeNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tjua̱ha jaha Teófilo na tí libro sa̱oxín mé kjia̱n kaín nkehe kjuako chꞌín Jesús la ko tí xra̱ kjuíchꞌe chꞌán tí xrankíxixín ");
INSERT INTO poeNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","hasta tí ya̱on sákjui̱ chꞌán nkaya nka̱jní. A̱ nta̱ ti na̱xa̱ sákjui̱hya chꞌán nka̱jní la kjueyá chꞌan tí sín sichꞌehe chꞌán xra̱ la ntá tí Ncha̱kuen Dios mé kjuínki̱tsa chꞌán ntá nixje̱he̱ chꞌán sín la kꞌue̱tue̱nhen chꞌán sín kíxin tso̱nohe sín nkehe tí xra̱ chrókjuichꞌe sín. ");
INSERT INTO poeNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Tió kjuixin kꞌuén chꞌán ntá kónoxín kíxin tjechón chꞌán, kꞌuíkon tí jehe sín la ko cuarenta ya̱on mé kꞌuíkon sín chꞌán jnkoya̱xón. Itsjé nkehe kjua̱ko̱xi̱n chꞌán kíxin tso̱noexín sín kíxin chaxín tjechón chꞌán la ko kjuako chꞌán nkexrí tí kjuachaxin kuènte Dios. ");
INSERT INTO poeNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ti na̱xa̱ kójnkotséko chꞌán tí sín kꞌuájiko chꞌán la jehe chꞌán mé kꞌue̱tue̱nhen chꞌán sín kíxin na̱xa̱ sátsjixinhya sín tí chjasin Jerusalén. Chrónka chꞌán kíxin: ―Chróchonhénrá ntihó chrókꞌuayéhérá tí nkehe tsjanjon Tꞌaná, me tí nkehe kuinhínrá xrja̱nka janhan. ");
INSERT INTO poeNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","A̱ ntá chaxín chꞌín Juan ìnta̱ ó kui̱ki̱texín chꞌán chojni. A̱ ntá ijie kánhyó itsjé ya̱on ntá jahará la Ncha̱kuen Dios la tsikitiaxínrá. ");
INSERT INTO poeNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ntá ti na̱xa̱ kójnkotséko sín chꞌín Jesús, kjuanchankíhi sín chꞌán kíxin: ―Jaha Ìnchéni, ¿á tsjánjonhya kjuachaxin jaí tsꞌe̱to̱anni chjasénni Israel ínaá? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ntá kjuáte̱he chꞌín Jesús kíxin: ―Náhí. Chontahyará kjuachaxin tso̱nohará nkesá tso̱nhen tíha. Jehó Tꞌaná chónta kjuachaxin tsꞌe̱to̱an tíha. ");
INSERT INTO poeNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ntá itsi tí Ncha̱kuen Dios ntá tsꞌayéhérá kjuachaxin sátsjichro̱nkará nkehe tí xra̱ kjui̱tꞌa, mé sátsjirá tsjákohérá kaín sín chjasin Jerusalén, la ko estado Judea, la ko estado Samaria, la ko kuenté chjasintajni. ");
INSERT INTO poeNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ntá kjuixin nixja chꞌín Jesús ntá xrína̱hya tinkákꞌi̱tꞌótjen chꞌán sákjui̱ chꞌán la tjejótsjehe sín. Sákjui̱ chꞌán hasta kjuákꞌenkákjan chꞌán ijnko tjui̱. Ntá í tꞌikonhya sín nkerí kjuíji chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ntá na̱xa̱ tjejókonta sín tí sákjui̱ chꞌín Jesús nka̱jní, a̱ ntá xrína̱hya titàya̱ kꞌuíkuèn sín yaá chojni ntoa tjejóyá sín ka tjóá tjejó sín chji̱naxón tí tjejó tí jehe sín. ");
INSERT INTO poeNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ntá tí sín a mé ntáchro sín kíxin: ―Jahará chojni kjuíxinrá estado Galilea, ¿nkehe tso̱nhen na̱xa̱ kontará nka̱jní? Xi̱kaha tjejokontará sákjui̱ Jesús la ko mé xi̱kaha xiki chꞌán ínaá ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Na ntá kja̱nxi̱n sín tí jna̱ itꞌin Olivo na ikjan sín chjasin Jerusalén. Tíha a mé kjínhyó tjen kíxin ó xi̱kahó kꞌue̱to̱an tí ley sátsji sín tí ya̱on tꞌo̱kꞌéhe sín. ");
INSERT INTO poeNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Na ntá kjuíji sín tí chjasin ntiha ntá kꞌui̱tꞌótjen sín tí yóxin piso tí nchia tsíkjen sín kꞌuékꞌejó sín. Mé ntiha tjen chꞌín Pedro, la ko chꞌín Jacobo, la ko chꞌín Juan, la ko chꞌín Andrés, la ko chꞌín Felipe, la ko chꞌín Tomás, la ko chꞌín Bartolomé, la ko chꞌín Mateo. La kja̱xin chꞌín Jacobo, mé itꞌé chꞌán itꞌin Alfeo, la ko chꞌín Simón, mé tí chꞌín a mé kuènte tí partido cananista, la ko kja̱xin chꞌín Judas, sa̱vé chꞌán mé itꞌin Jacobo. ");
INSERT INTO poeNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Kaín sín kójnkotsé sín ntiha tsonixje̱he̱ sín Dios la ko kꞌuéjóko sín tí kíchó tí chꞌín Jesús la ko tí tjan María, ìné chꞌán, la ko iso chojni chjin. ");
INSERT INTO poeNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ntá tí ya̱on a tí chꞌín Pedro kꞌuínkatjen chꞌán kjuákꞌexín to̱té chꞌán jnko̱siné tí tjejó tí sín tinkáchónki Ìnchéni mé ijnko ciento ikán chojni mé tsíkójnkotsé ntiha. Ntá ntáchro chꞌán kíxin: ");
INSERT INTO poeNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Kíchóni, tꞌichjánxi̱n tsoxiteyá éxí nixja xroon itén Dios éxí tsínixja chꞌín David tsíchrónka Ncha̱kuen Dios nkehe sichꞌe chꞌín Judas. Tí chꞌín Judas mé kjui̱ka̱o chꞌán tí sín tsotsé chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Jehe chꞌán mé kja̱xin kꞌuékꞌajikoni la jnkokón xra̱ kꞌuáyèkoni chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","A̱ ntá jehe chꞌán mé sákjuíkꞌe̱naxín chꞌán ijnko nonte tí chichaon kjuacha chꞌán kíxin tí jie̱ kjuasin chꞌán. Ntá kꞌuánótjen chꞌán la ikja chꞌán kꞌuitja nonte la xitje̱he̱ tse̱e chꞌán kꞌuaxrje kaín si̱ntanòé chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ntá xi̱kaha kónohe kaín tí sín chjasin Jerusalén ntá tí nonte kjuínchekꞌin sín nkíve̱e sín Acéldama mé tꞌaxrjexín kíxin ijnko nonte siín ijni̱. ");
INSERT INTO poeNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Tí xroon Salmo mé nixja xi̱kihí: Tsito̱he nto̱é chꞌán a, la kohya nkexro tsꞌejó ntiha. La ko kja̱xin ntáchro kíxin: Í jnko nkexro tsꞌáyéhe̱ tí xra̱ kuènte chꞌán. Mé xi̱kaha tsíkjin chꞌín David. ");
INSERT INTO poeNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’Tí tjejóni ntihi la siín chojni ó kꞌuájikoni xráxín tí kꞌuékꞌajikoni Ìnchéni Jesús ");
INSERT INTO poeNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","desde kꞌuíkonni nkexrí kui̱ki̱te chꞌín Juan tí jehe chꞌán la ko hasta kꞌuíkonni sákjui̱ chꞌán nkaya nka̱jní. Ntá ijie tꞌichjánxi̱n tsoxreyá jnkojín tí sín a tso̱jnkotsékoni sín kíxin kja̱xin tsochrónka sín kíxin chaxín xechón Ìnchéni Jesús ―mé xi̱kaha chrónka chꞌín Pedro. ");
INSERT INTO poeNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ntá kjuenka̱yáxin sín tso̱noxín yaá chojni mé tí chꞌín José, tꞌiko̱n chꞌán Barsabás la ko Justo, la ko kja̱xin í jnko chꞌán itꞌin Matías. ");
INSERT INTO poeNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ntá nixje̱he̱ sín Dios la ntáchro sín kíxin: ―Ìnchéni jaha mé choxian a̱sén kaín chojni. Tjákohéni nkexro tso̱nhen tocar xra̱ tí yaá tí nkexro í kónoxín ");
INSERT INTO poeNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","tsjia̱téhe xra̱ apóstol kuènte chꞌín Judas. A̱ ntá tí chꞌín Judas mé kuíto̱he chꞌán tí xra̱ kíxin kjuasin chꞌán ijie̱ la ntá ijie sákjuí chꞌán tjetjasóte chꞌán ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ntá kjuíchꞌe sín suerte ntá xrína̱hya kónhen tocar tí chꞌín Matías, ntá tuénxín tí hora a kuákja chꞌán xra̱ kꞌuéjóko chꞌán tí tejnko tí sín kjueyá Ìnchéni. ");
INSERT INTO poeNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ntá ó kui tí ya̱on kia Pentecostés ntá kaín tí sín tinkáchónki Jesús mé kójnkotsé sín jnkoko̱á tjejó sín. ");
INSERT INTO poeNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Xrína̱hya kuínhin sín ijnko tóvéntó kui̱xi̱n nka̱jní. Tí tóvéntó mé éxí ijnko xri̱nto̱ fuerte chjéhe. Kuenté tí nchia tjejóxenhen sín mé kóvéntó kja̱xin. ");
INSERT INTO poeNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ntá xrína̱hya kꞌuíkon sín nkehe éxí xrohi nene tsjehe. Ntá tíha xíka̱ye̱he la kꞌuéjókjen jnkojnko kja tí jehe sín. ");
INSERT INTO poeNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Na ntá kaín sín kꞌuáyéhe̱ sín tí Ncha̱kuen Dios ntá kjuankíxin sín nixja sín í jnko nkìva kíxin Ncha̱kuen Dios kjuínki̱tsa sín nixja sín. ");
INSERT INTO poeNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","A̱ nta tí ya̱on a la tí chjasin Jerusalén kꞌuéjó chojni judío tjinkaon sín sinchexiteyéhe̱ sín tí nkehe tinkáchónki sín, mé tsíkji̱xi̱n sín nkuíxín chjasintajni. ");
INSERT INTO poeNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","A̱ ntá jehe sín mé tsíkinhin sín tí tóvéntó ntá tsíkóchjina nchónhya chojni. Ntá í noehya sín nkehe chrókjuenka̱yáxin sín kíxin jnkojnko tí jehe sín mé kuínhin sín kíxin nixja tí sín a jnkojnko nkíve̱e sín. ");
INSERT INTO poeNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ntá síxrànka̱ sín, chrakon sín ntá jehe sín mé tjo sín kíchó sín kíxin: ―¿Á jehya kaín tí sín tjejónixja mé tsíkji̱xi̱n sín estado Galilea? ");
INSERT INTO poeNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","La ¿nkekuènté tjejótinhinni kíxin nixja sín jnkojnko nkíve̱eni? ");
INSERT INTO poeNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Kíxin ntihi mé siín chojni tsíkji̱xi̱n chjasin Partia, la ko Media, la ko Elam, la ko Mesopotamia, la ko Judea, la ko Capadocia, la ko Ponto, la ko Asia, ");
INSERT INTO poeNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","la ko Frigia, la ko Panfilia, la ko Egipto la ko nkuíxín Africa a̱ntsí nó ntaha Cirene. La ko kja̱xin chojni romano tjejó ntihi. Iso tí sín a mé chaxín tsíkokjíexín judío, la í so la tinkáchónki sín Dios éxí tí sín judío xi̱kaha. ");
INSERT INTO poeNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","La kja̱xin siín chojni tsíkji̱xi̱n Creta, la ko Arabia. Mé xi̱kaha kaín ni tsíkji̱xi̱nni tí chjasin a mé tsíkinhinni tjejónixja tí sín a tí kjuaxroan kuènte Dios jnkojnko nkíve̱eni ―mé xi̱kaha ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ntá tóxakonhen kaín sín la chrakon sín ntá kjuanchankíhi kíchó sín kíxin: ―¿Nkehe tꞌaxrjexín kaín tíha? ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","A̱ ntá iso sín kjuanoá sín ntáchro sín kíxin: ―Tsékoan tí sín a ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ntá jehe chꞌín Pedro mé kꞌuínkatjen chꞌán, kjuákꞌexín to̱té chꞌán la ko tí tejnko sín apóstol mé kꞌuínkatjen sín la ntá chꞌín Pedro mé itsen nixja chꞌán. Ntáchro chꞌán kíxin: ―Jahará chojni judío la ko jahará tjejorá chjasin Jerusalén. Kaínrá tjejorá tinhínrá tí nkehe tso̱xrja̱nka. ");
INSERT INTO poeNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Tí sín tjejó ntihi la jehya tsékoan sín éxí ntáchrorá, kíxin na ntá las nueve nchítjen la kohya nkexro tsékoan. ");
INSERT INTO poeNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Tíhi mé tsíchrónka chꞌín profeta Joel: ");
INSERT INTO poeNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Ntáchro Dios kíxin: Itsi ijnko ya̱on tsjixixín ntá tsochrꞌan Ncha̱kuenná ntá tsꞌáyéhe̱ chojni. Ntá tí xja̱anrá ntoa la ko tí xja̱anrá chjin mé tsonixja tan kuènta̱na. La ko tí sín ntasoá mé titàya̱ tsꞌíkuèn sín tí nkehe tsjáko̱ha̱ sín. La ko tí sín ó táda la kotáchrién sín tsꞌikonxín sín kíxin nkexrí tjinkaon Dios. ");
INSERT INTO poeNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Tí ya̱on tso̱nhen kaín tíha la tsochrꞌan tí Ncha̱kuenná tsꞌáyéhe̱ kaín tí sínntoa chꞌena xra̱ la ko tí síchjin kja̱xin la tsochrónka sín tanná. ");
INSERT INTO poeNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ntá janhan mé tsjáko̱xia̱n ijnko kjuachrakon nka̱jní. A̱ ntá chjasintajni tsjáko̱xia̱n kjuaxroan: mé tsꞌixin ijni̱ la ko xrohi la ko itjui̱ tsíkꞌóna ihnchi. ");
INSERT INTO poeNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Mé tí ya̱on la tsꞌinkaséyanxínhya, tsꞌóna tsꞌixin tie. A̱ ntá tí nitjó mé tsꞌóna ijni̱. Xi̱kaha senó tso̱nhen ntá itsi Ìnchéni. Tíhi mé ijnko ya̱on imá jié la imá náxrjón. ");
INSERT INTO poeNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","A̱ ntá kaín tí nkexro tsjanchehe ihni̱é Ìnchéni kíxin tsjinki̱tsa sín mé tsaá sín. Mé xi̱kaha tsíchrónka chꞌín Joel. ");
INSERT INTO poeNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","ꞌJahará chojni israelita tinhínrá tí nkehe tso̱xrja̱nka. Tí chꞌín Jesús tsíkji̱xi̱n chjasin Nazaret mé Dios kjua̱ko̱xi̱n chꞌán kíxin tsíchrꞌán chꞌán kíxin kjuasin chꞌán itsjé kjuaxroan jié kꞌuíkonrá la ko kjuako chꞌán kíxin Dios tsíchjéhe chꞌán kjuachaxin kíxin tjinkaon chꞌán chrókꞌuikonrá. Jahará ó jína nohará kaín tíha. ");
INSERT INTO poeNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Kjónté xi̱kaha kꞌuíkonrá la jahará itse̱rá chꞌán éxí tsíkjenka̱yáxin Dios ósé. A̱ ntá jahará kjui̱nchekꞌayéhérá chꞌán tí sín jínahya, a̱ ntá tí sín jínahya mé kꞌóyán sín chꞌán, kjua̱kꞌe̱nka̱ni sín chꞌán ijnko ntacruz. ");
INSERT INTO poeNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Kjánchó Dios la kjuínchexechón chꞌán ínaá la kjua̱tse̱n chꞌán tí kjuatjoté kuènte kjuachꞌén kíxin ntá ti kjuachꞌén xitjahya tsꞌe̱tue̱nhen tí jehe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","A̱ ntá ósé tí chꞌín rey David tsíchrónka chꞌán kuènte Jesús ntáchro chꞌán kíxin: Jaha Ìnchéni tꞌíkua̱n kíxin jnkochríxín tjétaón nti̱a tí xritjakꞌé janhan. Jaha mé itjen tjaná chjina kíxin chrókohya jie̱ chrókjuásian. ");
INSERT INTO poeNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Méxra̱ imá chéhe̱ a̱senná. Irꞌva̱ tsje̱xia̱n tí nkehe náxrjón. Ó nòna kíxin kohya nkehe tsꞌatsínka kjónté itsꞌén. ");
INSERT INTO poeNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ó nòna kíxin tí jaha tsi̱to̱éhya a̱senná chríkjan tí siín chojni tsíkꞌen. Tsjánjonhya kjuachaxin kíxin tso̱xíka nto̱na kíxin janhan mé ijnko nkexro tꞌa̱ha xra̱ jína tjuèhe. ");
INSERT INTO poeNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Jaha mé kjuáko̱na tí nti̱a tsjanjon kjuachón. Jaha mé nchechàna kíxin tꞌayakonna. Mé xi̱kaha tsíkjin chꞌín David. ");
INSERT INTO poeNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","ꞌKíchóni ti̱to̱hérá tsontáxrja̱n kíxin chꞌín David, tí nkexro kꞌuaxrjeníxinni mé tsíkꞌén chꞌán la ko tsíkji̱xravá chꞌán. Ntá na̱xa̱ noheni nketí tsíxravá chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","A̱ ntá chꞌín David mé ijnko nkexro tsíchrónka itén Dios la ó nohe chꞌán kíxin chaxín Dios chrónka kíxin ijnko nkexro tsꞌaxrjeníxin chꞌán mé tsꞌóna rey mé tsꞌe̱to̱an éxí jehe chꞌán kꞌue̱to̱an chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Mé xi̱kaha chꞌín David la ósé ó nohe chꞌán nkehe tso̱nhen la mé chrónka chꞌán kíxin tsoxechón Cristo la ko ntáchro chꞌán kíxin tí a̱sén chꞌán tsito̱ehya tí siín tí sín tsíkꞌen la tsꞌitjáyanhya tí cuerpo kuènte chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Méxra̱ Dios kjuínchexechón tí chꞌín Jesús, mé kꞌuíkonni kaín ni la mé chrónkani kíxin chaxín tíha. ");
INSERT INTO poeNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ntá ijie Jesús mé sákjui̱ko chꞌán Dios la nànko itja chjina Dios mé tjen chꞌán. Ntá tsíntáchro Itꞌé chꞌán Dios kíxin tsochrꞌán chꞌán tí Ncha̱kuen chꞌán. Ntá jie ó kui la ó kꞌuíkonrá la ko kuínhínrá nkehe kónhen. ");
INSERT INTO poeNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Tí chꞌín David la jehya jehe chꞌán sákjui̱ nkaya nka̱jní, kíxin jehe David ntáchro chꞌán kíxin: Ìnchéni Dios mé ntáche tí Ìnchéni kíxin: “Tjakꞌe tjaná chjina ntihó tséto̱an, ");
INSERT INTO poeNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","tsjixinjian kaín xín tí sín nínkakonhan la tsjachahya sín tsꞌe̱to̱an sín kíxin jahvá mé tséto̱an.” Mé xi̱kaha tsíkjin chꞌín David. ");
INSERT INTO poeNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","ꞌNtá kaín rá chojni israelita chrókónohará chaxín kíxin jehe tí chꞌín Jesús ó kjuakénka̱nirá tí ntacruz la Dios mé kjuíchꞌéna Ìnchárá ijie, mé tí Cristo ―mé xi̱kaha chrónka chꞌín Pedro. ");
INSERT INTO poeNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ntá ti kuínhin sín tíha ntá imá kóxakonhen a̱sén sín. La ntá kjuanchankíhi sín chꞌín Pedro la ko tí í so sín kjueyá chꞌín Jesús. Ntáchro sín kíxin: ―Kíchóni, a̱ ntá jie la ¿nkexrí chrókjuichꞌeni? ");
INSERT INTO poeNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ntá kjuáte̱he chꞌín Pedro ntáchro chꞌán kíxin: ―Chrókui̱to̱hérá tí iji̱árá la chróxráxinkáonrá Dios. Ntá chrókuikitiaxínrá ihni̱é Jesucristo ntá Dios mé tsjakjìinhanrá tí iji̱árá ntá jehe chꞌán tsjanjon chꞌán Ncha̱kuen chꞌán tsꞌayéhérá. ");
INSERT INTO poeNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Dios mé sincheki̱to̱nhanrá chꞌán tí Ncha̱kuen chꞌán tsꞌayéhérá jahará la ko xja̱anrá la ko kja̱xin tsochjéhe chꞌán Ncha̱kuen chꞌán kaín xín tí sín tjejó ikjín. Mé jehe chꞌán tsochjéhe chꞌán Ncha̱kuen chꞌán jnkojnko tí nkexro tsjeyá chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Mé xi̱kaha ntáchro chꞌín Pedro la ko í so nkehe ntáchro chꞌán. Nta nixje̱he̱ chꞌán sín ínaá, ntáchro chꞌán kíxin: ―Chrókui̱to̱hérá tí jínahya tjenka̱yáxin tí chojni siín chjasintajni kíxin jahará me jína chrókuaárá. ");
INSERT INTO poeNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ntá kaín tí sín kuítekaon tí nkehe chrónka chꞌán la ntá kuíkite sín la tí ya̱on a kóchjina iní mil chojni kjuankíxin tinkáchónki Ìnchéni Jesús la kꞌuíto tí sín ó xráxín siín. ");
INSERT INTO poeNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ntá kaín sín mé jína kꞌuékꞌejó sín mé kuítekaon sín tí nkehe kjuako tí sín kjueyá Jesús la kjuínki̱tsa sín kjuanjon sín tí nkehe chrókjóne tí í so sín la ko chjéhe sín Dios kjuasáya la ko kójnkotsé sín kíxin sine sín nio̱tja̱ xraxinkakonxín sín kíxin ikꞌuén Ìnchéni. ");
INSERT INTO poeNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","La ntá kaín tí í so sín mé chrakon sín kíxin tí sín tsíkjeyá Jesús kjuasin sín itsjé kjuaxroan. ");
INSERT INTO poeNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","La kaín tí sín tinkáchónki Jesús mé jnkoko̱á kꞌuéjó sín la jnkoko̱á chónta sín tí nkehe sine sín. ");
INSERT INTO poeNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Kjuínchekji sín tí nkehe chónta sín ntá kꞌóxika̱ye̱he sín tí chichaon la chjéhe sín tí sín chóntahya. ");
INSERT INTO poeNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Jnkojnko ya̱on kójnkotsé sín tí ni̱nko la ntá jnkojnko nto̱e sín kjóneko kíchó sín. La ko kjóne sín nio̱tja̱ kíxin xraxinkakonxín sín kíxin ikꞌuén Ìnchéni la ko kjuaxróxin kꞌuéjó sín la kohya nkexro kjuínchehnke. ");
INSERT INTO poeNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Kjuanchehe sín kjuasáyé Dios. Ntá kaín chojni kꞌuéchóntehe sín kjuasáya. A̱ ntá jnkojnko ya̱on Ìnchéni mé kjueyá iso chojni kíxin tso̱tsjé tí sín tsaá. ");
INSERT INTO poeNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ijnko ya̱on tí chꞌín Pedro la ko chꞌín Juan mé chrìin sín sákjui̱ sín tí tjen tí ni̱nko. Mé kjuíji sín las tres kónjín, tí hora mé nixje̱he̱ sín Dios. ");
INSERT INTO poeNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Kaín ya̱on kjuákꞌe ntiha ijnko chꞌín tsíkokjíexín xitjahya tji. Sátsíkjiko sín chꞌán tí ni̱nko la tsíkja̱kꞌe̱tja̱xi̱n sín chꞌán tí ntója puerta mé itꞌin Ntója Náxrjón. Ntaha tjetjanchakꞌéhe chꞌán chichaon tí sín sítꞌixenhen ntiha. ");
INSERT INTO poeNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ntá xrína̱hya kꞌuíkon tí chꞌín xitjahya tji kjuíji tí chꞌín Pedro la ko chꞌín Juan tsꞌixenhen sín ni̱nko, a̱ ntá kjuanchakꞌéhe chꞌán sín chichaon. ");
INSERT INTO poeNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Na ntá chꞌín Pedro la ko chꞌín Juan mé komá sín tí chꞌín a la ntá ntáchro chꞌín Pedro kíxin: ―Tsjehé ntihi. ");
INSERT INTO poeNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","A̱ ntá tí chꞌín a tjetsjehe chꞌán jína kíxin áchꞌe ichrén nkehe tsjanjon tí sín a, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","A̱ ntá chꞌín Pedro ntáchro kíxin: ―Na chontahya plata ni oro kjánchó tí nkehe chonta la tso̱tja̱há. Mé kjuachaxin ihni̱é Jesucristo, tí nkexro tsíkji̱xi̱n chjasin Nazaret, la tꞌinkatjen itjia ―mé xi̱kaha ichro chꞌín Pedro. ");
INSERT INTO poeNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ntá chꞌín Pedro mé itsé chꞌán tí tja chjina tí chꞌín xitjahya tji ntá kꞌuínkatjen chꞌán. Ntá xrína̱hya ó kósóji tí nta ntoá to̱té chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ntá tí chꞌín xitjahya tji la chrika chꞌán la kjuákꞌexín to̱té chꞌán ntá kjuankíxin chꞌán itji chꞌán. Ntá kꞌuíxenko sín chꞌán nkaxenhen ni̱nko. Tjetji chꞌán la ko chrika chꞌán la chjéhe chꞌán kjuasáya Dios. ");
INSERT INTO poeNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Na ntá kaín tí chojni siín tí chjasin ntiha la kꞌuíkon sín kíxin ó tji chꞌán la ko chjéhe chꞌán kjuasáya Dios. ");
INSERT INTO poeNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ntá chrakon sín kíxin xi̱kaha tsíkónhen kíxin tsíkjatso̱an sín kíxin jehe tí nkexro kjuákꞌetja̱xi̱n kjuanchakꞌá chꞌán chichaon ntója ni̱nko itꞌin Ntója Náxrjón. ");
INSERT INTO poeNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Na tí chꞌín xitjahya tji la mé títo̱ehya chꞌán tí chꞌín Pedro la ko chꞌín Juan. Ntá kaín xín tí sín siín ntiha chrakon sín kuinká sín sákjuítsjehe sín tí nta̱sin kuènte ni̱nko itꞌin nta̱sin Salomón kíxin ntaha tjejó tí sín a. ");
INSERT INTO poeNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ntá tí kꞌuíkon chꞌín Pedro xi̱kaha la ntáche chꞌán sín kíxin: ―Jahará chojni israelita, ¿nkekuènte chrakonrá jahará la ko nkekuènte komáráni? ¿Á tjenka̱yáxinrá kíxin jehóni kjuínchekito̱heni jína tí chꞌín i kíxin jehóni chóntani kjuachaxin la ko kíxin imá tinkáchónkini Dios? ");
INSERT INTO poeNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Náhí. Tí Dios kꞌuékinkáchónki chꞌín Abraham, la ko Isaac, la ko Jacob mé imá chjéhe chꞌán kjuachaxin tí Xje̱en chꞌán Jesús. Kjánchó jahará tsíkjike̱nhenrá chꞌán tí sín tꞌe̱to̱an. Ntá tí chꞌín Pilato mé tjinkaon chꞌán chrókꞌuátjánta chꞌán tí chꞌín Jesús kjánchó jahará la tjinkákonhyará xi̱kaha. ");
INSERT INTO poeNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","A̱ ntá jahará chrókjuanchiará chrókuíto̱he sáchrókjui tí nkexro tjóá jína a̱sén. A̱ ntá náhí. A̱ ntá jahará mé tjinkáonrá sátsji ijnko chojni chónta nchónhya jie̱. ");
INSERT INTO poeNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","A̱ ntá jahará tsíkꞌoyánrá tí nkexro tjanjon kjuachón. A̱ ntá Dios mé kjuínchexechón tí jehe chꞌán la mé xi̱kaha kꞌuíkonni la chrónkani. ");
INSERT INTO poeNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Tí kjua̱cha̱xién ihni̱é Jesús mé tinkáchónkini la ntá tíha mé kuíto̱exín jína tí nkexro kꞌuíkonrá la ko choxinrá. Tí chꞌín a mé kuítekaon chꞌán ntá kuíto̱he chꞌán jína. Mé xi̱kaha ó kꞌuíkonrá kaín rá. ");
INSERT INTO poeNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Kíchóni ó nòna kíxin tió jahará la ko tí sín tꞌe̱to̱an kꞌoyánrá Jesús la ni kónoahyará nkehe kjui̱chꞌerá. ");
INSERT INTO poeNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ntá ó xiteyá tí nkehe tsíntáchro Dios tsínixja̱xi̱n tí sín tsíchrónka itén chꞌán kíxin tí Cristo tꞌichjánxi̱n tsjasóte chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Méxra̱ tsi̱to̱hérá iji̱árá ntá xráxinkáonrá Dios ntá jehe chꞌán mé tsꞌóxíka iji̱árá ntá Ìnchéni mé sinchekito̱hará chꞌán jína. ");
INSERT INTO poeNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ntá jehe chꞌán mé tsochrꞌán Jesucristo ínaá la xra̱ ó tsi kíxin tsaáxinrá. ");
INSERT INTO poeNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Na ntá ijie la Jesucristo la nkaya nka̱jní ntahó tsito̱he chꞌán hasta tsjasiyóxinjian Dios kaín nkehe éxí tsíntáchro chꞌán tsínixja̱xi̱n chꞌán tí sín tsíchrónka itén chꞌán ósé. ");
INSERT INTO poeNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","A̱ ntá senó tí chꞌín Moisés tsíchénka tí sín tsíkꞌaxrjeníxinni kíxin: “Ìnchéni Dios mé tsochrꞌán ijnko nkexro tsꞌaxrjeníxinrá tsochrónka itén chꞌán éxí tsíchrꞌán chꞌán tí janhan. Tꞌichjánxi̱n tinhínrá kaín tí nkehe tsontáchro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","A̱ ntá tí chojni titekakonhya tí nixja tí nkexro a la tsꞌitjáyan sín la tsíto̱he sín tí nación Israel,” mé xi̱kaha tsíchrónka chꞌín Moisés. ");
INSERT INTO poeNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Kaínxín tí sín tsíchrónka itén Dios kjuankíxixín chꞌín Samuel la ko kaín tí sín kui chrꞌéxi̱n mé chrónka sín kíxin kaín tíha tso̱nhen xi̱kaha tí ya̱on i. ");
INSERT INTO poeNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Mé tí nkehe tsíntáchro Dios tsínixja̱xi̱n chꞌán tí sín tsíchrónka itén chꞌán kíxin xi̱kaha chrókꞌuayéhérá jahará tí nkehe chrókjuanjon chꞌán kíxin chrókꞌuejorá jína. Dios tsíkjichꞌéna chꞌán ijnko pacto mé nixje̱he̱ chꞌán tí sín tsíkꞌaxjeníxinrá mé tsíntáche chꞌán tí chꞌín Abraham kíxin: “Kaínxín chojni chjasintajni mé tso̱yaonxín sín kíxin ijnko nkexro tsꞌaxrjeníxin tí jaha.” ");
INSERT INTO poeNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Dios kjuínchexechón chꞌán tí Xje̱en chꞌán la sa̱oxín ichrꞌán chꞌán tí tjejorá jahará israelitará kíxin chrókjuintayaonrá chꞌán kíxin jnkojnko tí jahará chrókui̱to̱hérá tí nkehe jínahya ichꞌerá ―ichro tí chꞌín Pedro. ");
INSERT INTO poeNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Chꞌín Pedro la ko chꞌín Juan la na̱xa̱ tjejónixje̱he̱ sín tí sín tsíkójnkotsé ntá xrína̱hya ikui tí sín ncha̱tꞌá la ko tí chꞌín tꞌe̱tue̱nhen tí sín soldado kuènte tí ni̱nko la ko tí sín saduceo. ");
INSERT INTO poeNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Imá kónínkaon sín kíxin chꞌín Pedro la ko chꞌín Juan kjua̱ko̱he̱ sín tí sín tsíkójnkotsé nkexrí tsoxechón chojni tsíkꞌen kíxin xi̱kaha xechón chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ntá kuínhin sín xi̱kaha ntá itsé sín tí sín a ntá sákjuíko sín, chrꞌáxenhen sín nto̱echiso. Ntahó kꞌuéjó sín hasta kóya̱on kíxin ó ntá kóntó. ");
INSERT INTO poeNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","A̱ ntá nchónhya tí sín tsíkinhin tí tan a la kuítekaon sín. Ntá kjuixraká tí número tí chojni ntoa mé inꞌó mil chojni ntoa ó. ");
INSERT INTO poeNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","A̱ ntá tí ya̱on chrꞌéxi̱n kójnkotsé tí chjasin Jerusalén tí sín tꞌe̱to̱an kuènte tí sín judío la ko tí sín tjako tí ley. ");
INSERT INTO poeNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Mé kja̱xin ntaha tjen chꞌín Anás, mé jehe chꞌan mé tí ncha̱tꞌá imá tꞌe̱to̱an, la ko chꞌín Caifás, la ko kja̱xin chꞌín Juan, la ko chꞌín Alejandro, la ko kaín tí chojni kjéhya tí ncha̱tꞌá tꞌe̱to̱an. ");
INSERT INTO poeNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ntá kꞌue̱to̱an sín kíxin síxrakoa chꞌín Pedro la ko chꞌín Juan. Ntá kꞌuéjó sín jnko̱siné la ntá kjuanchankíhi sín ntáchro sín kíxin: ―¿Nkexro kjuanjon kjuachaxin o̱ nkexro kjuachaxin ihni̱é kíxin xi̱kaha ichꞌerá tí nkehe? ");
INSERT INTO poeNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ntá chꞌín Pedro imá chónta chꞌán kjuachaxin kuènte Ncha̱kuen Dios ntá kjuáte̱he chꞌán ntáchro chꞌán kíxin: ―Jahará chojni tꞌe̱to̱an kuènte chjasin la ko jahará sín táda kuènte chjasin Israel, ");
INSERT INTO poeNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","jahará mé tjanchankírá kíxin nkexrí kuíto̱he ijnko chojni níhi jína kíxin tjinkáonrá tso̱nohará. ");
INSERT INTO poeNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ntá tinhínrá jína tí nkehe tsochrónkaxínni kíxin kaín rá chojni chjasin Israel tso̱nohará kíxin tí chꞌín i itjen ntihi mé kuíto̱he chꞌán jína kjua̱cha̱xién ihni̱é Jesucristo, tí nkexro tsíkji̱xi̱n chjasin Nazaret. A̱ ntá jahará mé tsíkjakénka̱nirá chꞌán tí ntacruz la ntá Dios kjuínchexechón chꞌán ínaá. ");
INSERT INTO poeNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Tí chꞌín Jesús i mé tí xro̱ náxrjónhya kui̱to̱éntará tió kjui̱chꞌénará tja̱tꞌo̱ ntá mé jie kꞌóna tí xro̱ tjetoan. ");
INSERT INTO poeNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Kohya í jnko nkexro chónta kjuachaxin chrókuaáxinni kíxin kohya í jnko ihni̱é chojni ntihi chjasintajni chrókuinkáchónkini chrókuaáni ―mé xi̱kaha ichro chꞌín Pedro. ");
INSERT INTO poeNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Tí síxre̱é mé kꞌuíkon sín kíxin chꞌín Pedro la ko chꞌín Juan mé nixja sín kaín a̱sén sín la ntá kónohe sín kíxin tí sín a mé noehya sín xroon la tjetuanhya sín. Ntá chrakon tí sín tꞌe̱to̱an ntá kjuátso̱an sín kíxin tí sín a mé tsíkꞌajiko chꞌín Jesús. ");
INSERT INTO poeNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","A̱ ntá tí chꞌín tsíkito̱he jína mé ntiha tjejóko sín chꞌán. Méxra̱ xitjahya tsjanchia sín jie̱ tsjasóte tí sín a. ");
INSERT INTO poeNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ntá tí síxre̱é a mé kꞌue̱to̱an sín kíxin tí sín a tsꞌaxrje sín ntója ntá jehó sín kꞌuéjóxenhen sín nchia ikjo sín kíchó sín. ");
INSERT INTO poeNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ntá ntáchro sín kíxin: ―¿Nkehe chrókjuichꞌeheni tí sín a? Kaínxín tí chojni ntihi chjasin Jerusalén mé ó kꞌuíkon sín kíxin kjuínki̱tsa Dios tí sín a ntá kjuasin sín ijnko kjuaxroan jié ntá xitjahya tsontáchroni kíxin chaxínhya tíha. ");
INSERT INTO poeNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Í tjinkakonhyani kíxin na̱xa̱ tsochrónka sín tíha kíxin na̱xa̱ tsinhin chojni. Méxra̱ tsꞌe̱to̱anni kíxin í tsochénkahya sín ninkexró tí ihni̱é Jesús. ");
INSERT INTO poeNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Na ntá kꞌuíye̱he̱ sín tí sín a ínaá ntá kꞌue̱tue̱nhen sín kíxin ninkehó chrónixja sín la ko chrókjuako sín ihni̱é Jesús, ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","A̱ ntá chꞌín Pedro la ko chꞌín Juan kjuáte̱he sín ntáchro sín kíxin: ―Tjenka̱yáxinrá jahará, ¿á chrókóxrjínhi̱n Dios chrókjuintaxiteyáharáni jahará o̱ chrókjuinchexiteyéhe̱ni tí jehe chꞌan? ");
INSERT INTO poeNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","A̱ ntá jeheni la xitjahya tsíto̱heni tsochrónkani tí nkehe ó kꞌuíkonni la ko tí nkehe kuínhinni ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","A̱ ntá kjónté xi̱kaha kuínhin tí síxre̱é la jie̱he kꞌue̱to̱an sín ntá kjuanjon sín kjuachaxin kíxin sátsji tí sín a kíxin kꞌuitjahya sín nkexrí sinchekjasóte sín tí sín a kíxin kaín tí sín chjasin ntiha chjéhe sín Dios kjuasáya kíxin tí kjuaxroan kjuíchꞌe sín. ");
INSERT INTO poeNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Na mé tí chꞌín kuíto̱he jína kíxin tí kjuaxroan mé chjina kꞌuaxitjehe chꞌán cuarenta nánó a. ");
INSERT INTO poeNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ntá tí chꞌín Pedro la ko chꞌín Juan tsíxranjon kjuachaxin sátsji sín na ntá sákjuí sín tí tsíkójnkotsé iso tí sín chóxin sín. Ntá chrónka sín kaín nkehe kꞌue̱to̱an tí sín ncha̱tꞌá tꞌe̱to̱an la ko tí sín táda. ");
INSERT INTO poeNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ntá kjuixin kuínhin tí sín tsíkójnkotsé na ntá kaín sín nixje̱he̱ sín Dios la ntáchro sín kíxin: ―Ìnchéni, jaha mé kjui̱chꞌéna nka̱jní la ko chjasintajni la ko tí nta̱yaon la ko kaín xín tí nkehe siín. ");
INSERT INTO poeNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Jaha mé kjua̱cha̱xién Ncha̱kuan nixjaxian chꞌín David tí nkexro kjuítꞌaha xra̱. Ntáchro chꞌán kíxin: ¿Nkekuènte kíxin kónínkaon kaín tí chojni nación ókjé? A̱ ntá tí chojni israelita mé tjenka̱yáxin nkehe ninkehó sínkíhya. ");
INSERT INTO poeNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Tí sín rey siín chjasintajni la ko kaín tí sín tí chjasin kójnkotsé sín nínkakonhen sín Ìnchéni la ko Cristo. Mé xi̱kaha tsíkjin chꞌín David ósé. ");
INSERT INTO poeNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Mé xi̱kaha chaxín chꞌín Herodes, la ko chꞌín Poncio Pilato, la ko kja̱xin tí chojni tsíkji̱xi̱n ókjé, la ko tí sín israelita mé tsíkójnkotsé sín tí chjasin ntihi kíxin kónínkakonhen sín tí Xja̱an Jesús chóntahya jie̱, mé tí nkexro tsíkjéyá jaha sitꞌaha xra̱. ");
INSERT INTO poeNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Mé xi̱kaha kjuínchexiteyá sín tí nkehe ósé tsíkjenka̱yáxian kíxin tꞌichjánxi̱n xi̱kaha tso̱nhen. ");
INSERT INTO poeNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","A̱ ntá Ìnchéni, tsjehé kíxin imá jie̱he kꞌue̱to̱an tí sín a. La ntá jaha tsjínki̱tsa tí sín sitꞌaha xra̱ tsochrakonhya sín tsochrónka sín itán. ");
INSERT INTO poeNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","La ko tí kjua̱cha̱xián si̱nchekito̱exín jína tí chojni níhi la ko tsjáko̱xian kjuaxroan kjua̱cha̱xién ihni̱é tí nkexro Jesús tꞌaha xra̱ ―mé xi̱kaha nixje̱he̱ sín Dios nkaya nka̱jní. ");
INSERT INTO poeNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","A̱ ntá tí kjuixin nixje̱he̱ sín Dios a̱ ntá tí tjejó sín mé kuínkí nonte. La ntá kaín sín a̱ntsí kꞌuáyéhe̱ sín Ncha̱kuen Dios ntá kaín a̱sén sín kjuankíxin sín chrónka sín itén Dios. ");
INSERT INTO poeNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","La kaín tí sín kuinkáchónki sín Jesús mé jnkoko̱á kjuenka̱yáxin sín. Kohya nkexro ntáchro kíxin jehó kuènte tí nkehe siín. Náhí. Kaín sín mé kuènte sín. ");
INSERT INTO poeNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Tí sín tsíkjeyá Jesús mé kaín a̱sén sín chrónkaxín sín kíxin nkexrí xechón Ìnchéni Jesús. Ntá Dios a̱ntsí kjuíncheyaon kaín sín. ");
INSERT INTO poeNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kohya ninkexró nóa̱xi̱nhya tjejó ntiha kíxin kaín tí sín chónta no̱nte̱e sín o̱ nto̱e sín kjuínchekji sín. Na ntá tsíkji̱ka̱o sín tí chichaon ");
INSERT INTO poeNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","chjéhe sín tí sín kjueyá Jesús. A̱ ntá tí sín kꞌóxika̱ye̱he sín tí chichaon, kuákja tí sín nòa. ");
INSERT INTO poeNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Mé xi̱kaha kjuíchꞌe ijnko chꞌín levita itꞌin José. Jehe chꞌán la tsíkji̱xi̱n chꞌán nonte Chipre jnko̱siné nta̱yaon. Tí sín kjueyá Jesús mé kjuínchekꞌin sín chꞌán Bernabé, mé tꞌaxrjexín kíxin tí chꞌín nchechéhe̱ a̱sén chojni. ");
INSERT INTO poeNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Jehe chꞌán a mé kjuínchekji chꞌán ijnko no̱nte̱e chꞌán ntá kjui̱ka̱o chꞌán tí chichaon kjuínchekꞌáyéhe̱ chꞌán tí sín kjueyá Jesús.﻿ ");
INSERT INTO poeNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","A̱ ntá í jnko chꞌán mé itꞌin Ananías, a̱ ntá ichjién chꞌán mé itꞌin Safira, mé jehe sín mé kjuínchekji sín ijnko no̱nte̱e sín. ");
INSERT INTO poeNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","A̱ ntá tí chꞌín a kjuenka̱yáxinko ichjién chꞌán ntá kuakitsjentehe sín iso tí chichaon. Ntá í so mé sákjuíko chꞌán la chjéhe chꞌán tí sín kjueyá Jesús la kjuanjon chꞌán éxí kaín. ");
INSERT INTO poeNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ntá ntáchro chꞌín Pedro kíxin: ―Ananías, ¿kuènté chje̱hé kjuachaxin tí Tsochren kíxin kꞌue̱tue̱nhen a̱sán? Ntá kjui̱chꞌiyehé tí Ncha̱kuen Dios kíxin kjui̱nchemá iso chichaon kjui̱nchekjixián no̱nta̱a. ");
INSERT INTO poeNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Á jehya no̱nta̱a tíha? Ntá tió kjui̱nchekjia la, tí chichaon la, ¿á jehya kuèntá? ¿Kuènte kjuenka̱yáxian si̱chꞌe tíha? Kjui̱chꞌiyehé Dios, jehya chojni kjui̱chꞌiyehé. ");
INSERT INTO poeNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Na ntá kuínhin tí chꞌín Ananías ntá kjuítsínka chꞌán ntá ikꞌuén chꞌán. La ko kaín xín tí sín ntiha kónohe sín nkehe kónhen tí chꞌín a la imá chrakon sín. ");
INSERT INTO poeNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Na ntá ikjui iso sín ntasoá la ntá kjuínchekꞌísímá sín ika tí cuerpo kuènte chꞌán la ntá sákjui̱ko sín, sákjuíkja̱vá sín. ");
INSERT INTO poeNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ntá kꞌuátsínka iní hora ntá kjuíji ichjién chꞌín Ananías kꞌuíxenhen tjan tí nchia ntaha a. La noehya tjan nkehe tsíkónhen tí ntiha. ");
INSERT INTO poeNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ntá chꞌín Pedro mé kjuanchankíhi tí tjan a, ntáchro chꞌán kíxin: ―Chro̱nka, ¿á chaxín xi̱kahó kóxi̱xi̱n tí nonte ó kjui̱nchekjirá? ―ichro chꞌán. Ntá kjuáte̱he tjan kíxin: ―Chaxín xi̱kahó kóxi̱xi̱n. ");
INSERT INTO poeNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ntá ntáchro chꞌín Pedro kíxin: ―¿Nkekuènte jnkoko̱á kjuenka̱yáxinrá kjui̱chꞌiyehérá Ncha̱kuen Ìnchéni? Kjá ntáchrorá kohya nkehe chrókónhanrá. Ntihi ó kui tí sín ntasoá sákjuíkjává sín xìa na ntá jaí sátsjiko sín tí jaha ―mé xi̱kaha ichro chꞌín Pedro. ");
INSERT INTO poeNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ntá tuénxín kjuítsínka tjan Safira to̱té tí itjen chꞌín Pedro ntá ikꞌuén tjan. Ntá kꞌuíxenhen tí sín ntasoá tí nchia a ntá kꞌuíkon sín kíxin tsíkjixin tsíkꞌen tjan. La ntá sákjuíko sín tí cuerpo kuènte tjan la kjua̱vá sín tjan tí chjinaxón tsíxrává tí xìi tjan. ");
INSERT INTO poeNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Na kaín tí sín kuènte ni̱nko la ko tí í so sín kuínhin tí xi̱kaha tsíkónhen, mé imá chrakon sín. ");
INSERT INTO poeNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","A̱ ntá tí sín kjueyá Jesús mé kjua̱ko̱xi̱n sín nchónhya kjuaxroan tí siín chojni ntiha la ko kaín sín mé kójnkotsé sín tí nta̱sin itꞌin Salomón. ");
INSERT INTO poeNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Chrakon iso sín kꞌuítohya tí jehe sín la kjónté la kaín chojni tjikosáyehe tí jehe sín. ");
INSERT INTO poeNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","La ntá xrína̱hya nchónhya chojni ntoa la ko chojni chjin kjuankíxin tinkáchónki sín Ìnchéni. ");
INSERT INTO poeNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ntá itsjé chojni mé kuakitsje sín tí chojni níhi kꞌuejo sín nti̱a. Tjejótákꞌá sín chrítaón cama la ko kania kíxin tsꞌatsínka chꞌín Pedro ntá kjónté itsꞌue̱en chꞌán ó tsꞌatsínka tí tjejó sín mé chrókuito̱exín sín jína. ");
INSERT INTO poeNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Kja̱xin tí chjasin chjino mé kjui̱xi̱n nchónhya chojni ikjui sín chjasin Jerusalén la kjui̱ka̱o sín tí chojni níhi la ko tí chojni chónta ncha̱kuen tí jínahya. La kaín sín a mé kuíto̱he sín jína. ");
INSERT INTO poeNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Na ntá tí sín ncha̱tꞌá tꞌe̱to̱an la ko tí sín kuènte tí sín saduceo mé imá kóchji̱no̱xínhin sín. ");
INSERT INTO poeNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Na ntá itsé sín tí sín kjueyá Jesús la chrꞌáxenhen sín nto̱echiso. ");
INSERT INTO poeNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","A̱ ntá ijnko ángel kuènte Ìnchéni ikui tí tie a kuakitje̱he̱ chꞌán ntója nto̱echiso ntá kuakitsje chꞌán tí sín a. La ntá kꞌue̱tue̱nhen chꞌán sín kíxin: ");
INSERT INTO poeNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Sátjirá ni̱nko la tsjákohérá kaín tí sín ntiha tí tan ni̱xin tsjanjon kjuachón. ");
INSERT INTO poeNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Kjuixin kuínhin sín ntá sákjuí sín ntá tí kꞌuínkaséyan kꞌuíxenhen sín tí ni̱nko kjuako sín. A̱ ntá tí ncha̱tꞌá tꞌe̱to̱an la ko tí sín kꞌuéjóko chꞌán mé kꞌuíye̱he̱ sín tso̱jnkotsé kaín tí síxre̱é, mé tí sín tꞌe̱to̱an kuènte Israel. Na ntá kꞌue̱to̱an sín kíxin tsoxrakoa tí sín tjejóchjina tsíkjeyá Ìnchéni. ");
INSERT INTO poeNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","A̱ ntá kjuíji tí sín policía tí nto̱echiso a ntá kꞌuitjahya sín tí sín a. La ntá ikjan sín la ");
INSERT INTO poeNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","ntáchro sín kíxin: ―Kjuíjini ntiha la kꞌuíkonni tsíkjehe̱ jína nto̱echiso a la kꞌuéjó tí sín soldado a ntója. Ntá kuakitje̱he̱ni nto̱echiso la kꞌuitjahyani ninkexró tí nkaxenhen ―ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ntá kaín tí ncha̱tꞌá tꞌe̱to̱an la ko tí chꞌín kꞌue̱tue̱nhen tí policía kuènte ni̱nko la ko i so tí sín ncha̱tꞌá tꞌe̱to̱an mé kuínhin sín ntá ntáchro sín kíxin xá nkexrí chrókónhen chrókꞌuitjáyan tí xra̱ kuènte tí sín a. ");
INSERT INTO poeNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Na ntá tuénxín kjuíji ijnko nkexro ntáchro kíxin: ―Tí sín kꞌuejochji̱na̱rá jahará mé ó nkaxenhen ni̱nko ntaha tjejó sín tjejótja̱ko̱he̱ sín chojni ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","La ntá tí chꞌín kꞌue̱tue̱nhen tí sín policía mé sákjuíko chꞌán tí sín policía la kjuíkakjín tí sín tjako. Ninkehó kjuíchꞌehya tí sín policía tí sín tjako kíxin chrakon sín kíxin áchꞌe tí sín siín ntiha mé tsjakꞌe sín xro̱, ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Na ntá tió kjui̱ka̱o sín tí sín a la kꞌuejó sín nkayakon tí sín tꞌe̱to̱an ntá tí ncha̱tꞌá tꞌe̱to̱an ntáchro chꞌán kíxin: ");
INSERT INTO poeNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―Jeheni kjuanjonhyani kjuachaxin kíxin tsjákorá ihni̱é tí nkexro a. ¿A̱ ntá nkehe kjui̱chꞌerá jahará? Kuenté chjasin Jerusalén tsíkjákorá. La tjinkáonrá tsékaráni jie̱ kíxin jeheni tsíkꞌóyánni tí chꞌín a ―ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","A̱ ntá chꞌín Pedro la ko tí iso sín kjueyá Jesús ntáchro sín kíxin: ―A̱ ntá jeheni tꞌichjánxi̱n sinchexiteyéhe̱ni Dios senó. A̱ ntá chrꞌéxi̱n sinchexiteyéhe̱ni chojni. ");
INSERT INTO poeNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Tí Dios tsíkinkáchónki tí sín tsíkꞌaxjeníxinni ósé mé kjuínchexechón Jesús, ti nkexro a mé kjuakénka̱nirá tí ntacruz tsíkꞌoyánrá. ");
INSERT INTO poeNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ntá ijie tjeko chꞌán Dios nkaya nka̱jní la nánko itja chjina Dios mé tjen chꞌán la Dios kjuíchꞌéna chꞌán ijnko nkexro tꞌe̱to̱an kíxin sinchekaá chꞌán chojni kíxin tí nación Israel chrókjan chrókuinkáchónki sín Dios ntá chrókꞌuitjáyan tí jie̱ chónta sín. ");
INSERT INTO poeNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","La ko kja̱xin jeheni chrónkani kaín tí nkehe kꞌuíkonni kjua̱cha̱xién Ncha̱kuen Dios. Tí Ncha̱kuen chꞌán mé chjéhe Dios kaín tí nkexro chaxín sinchexiteyéhe̱ tí jehe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","La ntá tí sín tꞌe̱to̱an a mé kuínhin sín tíha ntá kónínkaon sín la ko tjinkaon sín chrókꞌóyán sín tí sín a. ");
INSERT INTO poeNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Na ntá tjen ijnko chojni fariseo mé ijnko síxre̱é itꞌin chꞌán Gamaliel. Jehe chꞌán mé ijnko maestro kjuako tí ley la kaín chojni chjasin ntiha chóntehe chꞌán kjuasáya. Mé kꞌuínkatjen chꞌán kjuákꞌexín to̱té chꞌán la nixja chꞌán kꞌue̱to̱an chꞌán kíxin tí sín tsíkjeyá Ìnchéni mé tsꞌaxrje sín ntója intsí, ichro chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Na ntá nixje̱he̱ chꞌán kaín tí síxre̱é ntáchro chꞌán kíxin: ―Jahará chojni israelita, tóxakonhanrá kíxin kohya nkehe chrókjui̱chꞌeherá tí sín a. ");
INSERT INTO poeNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Xráxinkáonrá kíxin senó kjuákꞌe ijnko chꞌín itꞌin Teudas la tónhen a̱sén chꞌán kíxin imá tꞌe̱to̱an chꞌán. Ntá itsjé sín mé noó ciento chojni kjuíchréhe̱ chꞌán. Na ntá ókjé chojni kꞌóyán sín tí chꞌín a la ntá kaín tí sín kuinkáchréhe̱ tí jehe chꞌán mé xíka sín sákjuí sín ntá ntahó kjuèxín tí xra̱ kꞌuékjichꞌe sín. ");
INSERT INTO poeNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ntá chrꞌéxi̱n tió xrenájín kaín ihni̱é chojni kꞌuéjó na ntá ikjui í jnko chꞌín mé itꞌin chꞌán Judas la kjui̱xi̱n chꞌán estado Galilea. Ntá itsjé chojni kjuíchréhe̱ chꞌán. La ntá kja̱xin kꞌóyán sín chꞌán la ntá kaín xín tí sín kjuíchréhe̱ chꞌán xíka sín sákjuí sín ínaá. ");
INSERT INTO poeNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Méxra̱ ti̱to̱hérá tjia̱téhyará tí jehe sín a. A̱ ntá tí tjejóchꞌe sín xra̱ kuènte chojni ó la kja̱xin tsꞌitjáyan. ");
INSERT INTO poeNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","A̱ ntá tí chaxín tjako sín kjua̱cha̱xién Dios ntá tsjachahyará si̱nchekꞌitjáyanrá tíha. Méxra̱ ti̱to̱hérá sín kíxin tsjánjo̱nkohyará Dios. ");
INSERT INTO poeNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Na ntá kaín tí síxre̱é mé kuítekaon sín la ntá kꞌuíye̱he̱ sín tí sín kjueyá Jesús. La ntá kjuate sín la xíkꞌe̱tue̱nhen sín kíxin í tsonixjahya sín ihni̱é Jesús la ntá kjuanjon sín kjuachaxin kíxin sátsji sín. ");
INSERT INTO poeNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ntá tí sín kjueyá Jesús mé kꞌuaxrjexín sín tí tjejó tí sín tꞌe̱to̱an kjónté xi̱kaha kónhen sín la chéhe̱ sín kíxin Dios kjuanjon kjuachaxin kjuasóte sín kíxin tí kjuako sín ihni̱é Jesús. ");
INSERT INTO poeNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Kuíto̱ehya sín tsjako sín kuènte Jesucristo kaín ya̱on tí nkaxenhen ni̱nko la ko tí jnkojnko nto̱e chojni.﻿ ");
INSERT INTO poeNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Na ntá tí ya̱on a tjoka sítinkákótsjé tí sín tinkáchónki Ìnchéni. A̱ ntá tí sín nixja nkìva griego mé kónínkakonhen sín tí sín nixja nkìva hebreo. Ntáchro sín kíxin tí sín chjin kꞌán kuènte sín la kánhyó jína kꞌuáyéhe̱ tí nkehe síxika̱ye̱he sine sín jnkojnko ya̱on, ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Na ntá tí teyó tí sín tsíkjeyá Jesús mé kꞌuíye̱he̱ sín kaín tí sín tinkáchónki Ìnchéni. Ntá nixje̱he̱ sín, ntáchro sín kíxin: ―Jeheni la jehya jína tsíto̱heni tí xra̱ tjakoni itén Dios, kíxin ntá sitꞌaharáni xra̱ tsꞌóxíka̱ye̱heni tí nkehe sine tí sín kꞌán. ");
INSERT INTO poeNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Méxra̱ jahará kíchó ni tsjéyárá yato chojni ntoa tí tjejorá, tí chojni jína choxinrá la ko nohe sín la ko a̱ntsí chónta sín Ncha̱kuen Dios mé tí sín a sinchekꞌáyéhe̱ni tí xra̱ a. ");
INSERT INTO poeNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","A̱ ntá jeheni la tsonixje̱he̱ni Dios la ko tsinkákjakoni itén chꞌán ―mé xi̱kaha ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","La ntá kaín sín mé kuínhin sín xi̱kaha ntá jnkoko̱á kjuenka̱yáxin sín. La ntá kjueyá sín chꞌín Esteban, mé ijnko nkexro imá tinkáchónki Ìnchéni la ko a̱ntsí chónta chꞌán tí Ncha̱kuen Dios. La kja̱xin kjueyá sín chꞌín Felipe, la ko chꞌín Prócoro, la ko chꞌín Nicanor, la ko chꞌín Timón, la ko chꞌín Parmenas la ko chꞌín Nicolás. Jehe chꞌán mé tsíkji̱xi̱n chꞌán chjasin Antioquía la ósé mé tsíkinkáchónki chꞌán ti nkehe tinkáchónki tí sín judío. ");
INSERT INTO poeNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ntá kjuixin kjueyá sín tí sín a ntá kjui̱ka̱o sín ti tjejó tí sín tsíkjeyá Ìnchéni. La ntá tí sín a mé nixje̱he̱ sín Dios la ko kꞌuejotja tja sín chrítaón tí ikja tí sín tsíkónoxín. ");
INSERT INTO poeNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Tí itén Dios sítinkákji la tinkákótsjé tí sín tinkáchónki Ìnchéni chjasin Jerusalén. Kja̱xin itsjé tí sín ncha̱tꞌá judío kjuankíxin sín tinkáchónki sín Ìnchéni. ");
INSERT INTO poeNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Tí chꞌín Esteban mé ijnko nkexro kꞌuéchónta kjuachaxin kíxin Dios tsíkjincheyaon chꞌán la nchónhya kjuaxroan kjua̱ko̱xi̱n chꞌán tí siín chojni. ");
INSERT INTO poeNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","A̱ ntá iso sín tsíkji̱xi̱n tí ni̱nko judío kuènte tí sín senó kꞌuejó esclavo sín tsíkji̱xi̱n sín chjasin Cirene, la ko Alejandría, la ko Cilicia, la ko estado Asia, mé kjuankíxin sín ikjo sín chꞌín Esteban. ");
INSERT INTO poeNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Kjónté xi̱kaha la kjuachahya sín kíxin Ncha̱kuen Dios mé kjuínki̱tsa tí chꞌín Esteban nixja chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Na ntá jehe sín mé kjue̱nke̱he sín ókjé chojni kíxin tsochrónka sín kíxin kuínhin sín kꞌuántaxínhi̱n chꞌán chꞌín Moisés la ko Dios, ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Mé xi̱kaha kꞌuíxité kaín chojni la ko tí sín tꞌe̱to̱an kuènte ni̱nko la ko tí sín tjako tí ley. La ntá itsé sín tí chꞌín Esteban la tinkánkákjen sín chꞌán sákjui̱ko sín chꞌán tí siín tí síxre̱é a. ");
INSERT INTO poeNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Kja̱xin kjueyá sín chojni tsochrónka kíxin ntoáhya kjuako chꞌín Esteban la ntáchro tí sín a kíxin: ―Tí chꞌín a mé títo̱ehya chꞌán tꞌántaxínhi̱n chꞌán tí ni̱nko kuènténi la ko tí ley. ");
INSERT INTO poeNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ó kuínhinni kíxin chrónka chꞌán kíxin tí chꞌín Jesús, tí chꞌín tsíkji̱xi̱n chjasin Nazaret, mé sinchekꞌitjáyan chꞌán tí ni̱nko̱eni ntihi la ko tsjitóxi̱nhin chꞌán tí nkehe tinkáchónkini mé tí nkehe tsíkꞌe̱to̱an chꞌín Moisés ―mé xi̱kaha ichro sín. ");
INSERT INTO poeNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ntá tí síxre̱é la ko kaín tí sín sítja̱xi̱n ntiha la komá sín tí chꞌín Esteban la mé kꞌuíkon sín kíxin tí kàré chꞌán mé éxí ijnko ángel mé xi̱kaha tsjehe tí jehe chꞌán.﻿ ");
INSERT INTO poeNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","A̱ ntá tí sín ncha̱tꞌá tꞌe̱to̱an kjuanchankíhi sín tí chꞌín Esteban kíxin: ―¿Á chaxín kaín tíhi tsíntáchrua? ");
INSERT INTO poeNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Na ntá jehe chꞌán kjuáte̱he chꞌán ntáchro chꞌán kíxin: ―Kaínrá kíchó ni Israel la ko sín táda tinhínrá tí nkehe tsontáxrja̱n. Dios kuènteni chónta kjuachaxin mé kjua̱ko̱he̱ chꞌín Abraham tí nkexro kꞌuaxrjeníxinni tió kjuákꞌe chꞌán nación Mesopotamia tí na̱xa̱ sátjihya chꞌán tsjakꞌe chꞌán nonte Harán. ");
INSERT INTO poeNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Dios tsíntáchro kíxin: “Ti̱to̱hé chjasán la ko kaín tí nkexro kjéhya. Na ntá sátjia tí nonte tsjákohá jaha.” ");
INSERT INTO poeNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Na ntá chꞌín Abraham kꞌuaxrjexín chꞌán tí nonte Caldea. Ntá sákjuí chꞌán kjuákꞌe chꞌán tí nonte Harán. Na ntá kjuixin ikꞌuén itꞌé chꞌán na ntá Dios kjui̱ka̱o tí jehe chꞌán tí nonte tjejorá ijie. ");
INSERT INTO poeNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Kjánchó chꞌín Abraham la kuákjahya chꞌán nítꞌo̱ nonte hasta ni tí tsjakꞌe to̱té chꞌán la chóntahya chꞌán. A̱ ntá chrónka Dios kíxin chaxín chrꞌéxi̱n tió tsjixin tsꞌen chꞌín Abraham la tí sín tsꞌaxrjeníxin chꞌán mé tsꞌáyéhe̱ sín tíha. Kjónté na̱xa̱ kohya nijnko xje̱en chꞌán la mé xi̱kaha ntáchro Ìnchéni. ");
INSERT INTO poeNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Kja̱xin tsíntáchro Dios kíxin tí sín tsꞌaxrjeníxin chꞌín Abraham la tsꞌejó sín ókjé nonte, la ko sichꞌexón sín xra̱ la ko náxrjónhya tsꞌejó sín noó ciento nánó. ");
INSERT INTO poeNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","La kja̱xin xíntáchro Dios ínaá kíxin: “Ntá chrꞌéxi̱n janhan si̱ntakjasóte tí sín kjuínchekjasóte xja̱an. La ntá tí xja̱an mé tsokjan sín ntihi ntá tsoxraxinkakonxín sín tí janhan,” mé xi̱kaha ichro Dios. ");
INSERT INTO poeNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Na ntá Dios mé tsíkjo chꞌín Abraham kíxin kaín tí chojni ntoa tsꞌaxrjeníxin chꞌán mé itsa sín xro̱ye. Na ntá xi̱kaha tió kokjíhi xje̱en chꞌan Isaac ntá chꞌín Abraham mé chjéhe chꞌán xjan xro̱ye tió xétjehe xjan ijní ya̱on. Ntá kja̱xin xi̱kaha kjuíchꞌe chꞌín Isaac tió chónta chꞌán xje̱en chꞌán Jacob, la ntá chꞌín Jacob la xi̱kaha kjuíchꞌe chꞌán ínaá. Ntá tí sín a mé kꞌóna itꞌé tí teyó tribu tsíkꞌaxrjeníxin tí sín Israel. ");
INSERT INTO poeNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Tí xje̱en chꞌín Jacob mé tí sín kꞌuaxrjeníxinni ósé la jehe sín kꞌuéchji̱no̱xínhin sín tí kíchó sín José ntá kjuínchekji sín chꞌán la tí sín kꞌue̱na la sákjuíko sín chꞌán nó nación Egipto, kjánchó Dios mé kjuínki̱tsa tí jehe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Dios mé kjuínchekaá chꞌán tí náxrjónhya kꞌuékjakꞌe chꞌán. La ko Dios kjuanjon kjuachaxin kíxin imá tso̱nohe chꞌán. Na ntá kꞌuíkon chꞌín Faraón tí rey kuènte nación Egipto a xi̱kaha tí xra̱ jína kjuíchꞌe chꞌín José ntá kjuanjon chꞌán kjuachaxin kíxin tsꞌe̱to̱an chꞌín José tí nación Egipto la ko tí nto̱e chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","ꞌNa ntá kókjinta xrína̱hya la náxrjónhya kꞌuejó tí sín nación Egipto la ko nonte Canaán la tí sín tsíkꞌaxrjeníxinni la kꞌuitjahya sín nkehe sine sín. ");
INSERT INTO poeNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","A̱ ntá tsíkinhin chꞌín Jacob kíxin tí nación Egipto mé sítóxi noa trigo ntá kꞌue̱tue̱nhen chꞌán tí sín xje̱en chꞌán kíxin sátsji sín ntiha tsjikꞌe̱na sín noa, la jehe tí sín a mé tí sín tsíkꞌaxrjeníxinni. Tíha mé tí sa̱oxín sákjuí sín. ");
INSERT INTO poeNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ntá tí yóxin sákjuí sín ntiha ntá chꞌín José kjuínchenohe chꞌán sín kíxin tí sín a la sa̱vé chꞌán. La ntá kjua̱ko̱he̱ chꞌán tí chꞌín Faraón tí sín na̱xa̱ kjéhya chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","La ntá kꞌue̱to̱an tí chꞌín José kíxin sátsjikakjín sín itꞌé chꞌán Jacob la ko kaín tí sín kjéhya chꞌán, mé ijnko setenta y cinco chojni kjéhya chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Mé xi̱kaha kónhen la tí chꞌín Jacob mé sákjuí chꞌán la kjuákꞌe chꞌán nación Egipto ntá chrꞌéxi̱n ntiha mé kꞌuénxin chꞌán. La ntá chrꞌéxi̱n kja̱xin tí sín tsíkꞌaxrjeníxinni kꞌuénxin sín ntiha. ");
INSERT INTO poeNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ntá chrꞌéxi̱n kuakitsjexín sín tòye̱ tí huéso̱é tí chꞌín Jacob la sákjuíko sín tí nonte Siquem, la ntá ntiha mé kjua̱vá sín tí nonte tsíkꞌe̱na chꞌín Abraham mé tsíkꞌe̱nehe chꞌán tí xje̱en chꞌín Hamor chjasin Siquem. ");
INSERT INTO poeNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’La ntá ó kuichjina tsoxiteyá tí nkehe tsíntáchro Dios tsíkjo chꞌín Abraham ntá tí sín Israel imá kótsjé sín nación Egipto. ");
INSERT INTO poeNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","A̱ ntá xrína̱hya í jnko chꞌín rey kjuankíxin kꞌue̱to̱an nación Egipto la kꞌuéchónhya chꞌán tí chꞌín José. ");
INSERT INTO poeNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","La ntá tí chꞌín rey kjuíchꞌiyehe chꞌán tí sín na̱xa̱ kjéhyani la ko kjuínchekjasóte chꞌán sín. La tsíkꞌe̱to̱an chꞌán kíxin tí xjan ntoa na ntá kokjíhi mé tsjikꞌitjí sín xjan kíxin itsꞌen xjan. ");
INSERT INTO poeNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Na ntá tí ya̱on a tsíkokjíhi chꞌín Moisés ntá imá kóxrjínhi̱n Dios tí xjan a. Itꞌé la ko ìné xjan mé kꞌuéchónta sín xjan iní nitjó koá nto̱e sín. ");
INSERT INTO poeNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ntá chrokjuahya tsja̱kꞌe̱ma̱ sín xjan la ntá kjuíkjáka sín xjan. La ntá xje̱en tí chꞌín rey kuènte Egipto mé kjuíkakja tjan xjan la sákjuíko tjan nto̱e tjan la kjuínchekꞌánkí tjan xjan éxí xje̱en tjan xi̱kaha. ");
INSERT INTO poeNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","La ntá tí chꞌín Moisés mé kꞌuitja chꞌán kaín nkehe nohe tí sín Egipto a la imá tjetoan tí nkehe kꞌuéntáchro chꞌán la ko tí nkehe kꞌuékjichꞌe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’La ntá tió chónta tí chꞌín Moisés cuarenta nánó ntá tjinkaon chꞌán tsjitsjehe chꞌán tí sín israelita na̱xa̱ kjéhya chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ntaha mé kꞌuíkon chꞌán kíxin ijnko chojni Egipto kjuate ijnko chojni na̱xa̱ kjéhya tí jehe chꞌán. Ntá chrókjuinki̱tsa chꞌán tí sín na̱xa̱ kjéhya chꞌán ntá kꞌóyán chꞌán tí chꞌín Egipto a. ");
INSERT INTO poeNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Kjuenka̱yáxin chꞌán kíxin tí sín na̱xa̱ kjéhya chꞌán, mé tí sín israelita, mé tso̱noexín sín kíxin Dios mé tsíchrꞌán tí jehe chꞌán sinchekaá sín chꞌán. Kjánchó tí sín a kjuátso̱anhya sín. ");
INSERT INTO poeNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","La ntá í jnko ya̱on tí chꞌín Moisés kꞌuíkon chꞌán kíxin yaá sín israelita tjanjo̱nko kíchó sín. La ntá tjinkaon chꞌán chrókjuítꞌo̱xin chꞌán kíxin chrokjuanjo̱nhya sín. La ntáchro chꞌán kíxin: “Jahará jnkoko̱á kíchuárá la, ¿nkekuènté tjánjo̱nrá?”. ");
INSERT INTO poeNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","A̱ ntá tí nkexro chónta tí jie̱ mé kónínkaon chꞌán la kótéka chꞌán tí chꞌín Moisés. Ntá ntáchro chꞌán kíxin: “¿Nkexro kjuanjon kjuachaxin kíxin jaha kꞌóna juez kuènténi? ");
INSERT INTO poeNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Á tjinkávan tsꞌoyánni kja̱xinni éxí kꞌoyán tí chꞌín Egipto ijna ní?” ");
INSERT INTO poeNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","A̱ ntá kuínhin tí chꞌín Moisés tíha ntá tjoka sákjuí chꞌán. Sákjuí chꞌán tí nación Madián ntá ntiha kjuákꞌe chꞌán éxí ijnko chojni tsíkji̱xi̱n ókjé. Ntá ntaha tsíkóte̱he chꞌán la ko kjuíchꞌéna chꞌán yaá xjan ntoa. ");
INSERT INTO poeNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Na ntá kꞌuátsínka cuarenta nánó ntá tí nte̱je̱ chjino jna̱ itꞌin Sinaí mé xrína̱hya kꞌuíkon chꞌán ijnko ángel tjenkákjan tí xrohi chríkjan tí ntayoa tjeche. ");
INSERT INTO poeNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ntá tí chꞌín Moisés la chrakon chꞌán kíxin xi̱kaha kꞌuíkon chꞌán la ntá kóchjinehe chꞌán kíxin chrótsjehe chꞌán la ntá kuínhin chꞌán itén Ìnchéni ntáchro kíxin: ");
INSERT INTO poeNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Janhan mé Dios tinkáchónki tí sín tsíkꞌaxrjeníxian mé Abraham, la ko Isaac, la ko Jacob,” mé xi̱kaha ichro Dios. Ntá tí chꞌín Moisés la kjuankíxin chrakon chꞌán la síxrànka̱ chꞌán ntá í tjinkakonhya chꞌán tsotsjehe chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Na ntá ntáchro Ìnchéni kíxin: “Takítsje to̱ka̱tá kíxin tí nonte tinkatja la nonte tjóá chóntahya jie̱. ");
INSERT INTO poeNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ó kꞌuíkua̱n kíxin tí sín kuènta̱na mé imá tjejotjasóte sín nación Egipto. La ó kui̱nha̱n kíxin tꞌèya sín. La ntá ijie ó kꞌuinka kíxin tsjínki̱tsa sín. Méxra̱ xrákiá jaha tsétua̱nhan jaha sátsjia nación Egipto,” ichro Dios. ");
INSERT INTO poeNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Tí sín israelita mé kjuanoá sín tí chꞌín Moisés. Tsíntáchro sín kíxin: “¿Nkexro kjuanjon kjuachaxin kíxin jaha kꞌóna juez?” ichro sín. Kjánchó Dios ichrꞌán chꞌán tí chꞌín Moisés kíxin tsꞌe̱to̱an chꞌán la ko sinchekaá chꞌán tí sín israelita kjuachaxin tí ángel kꞌuíkon chꞌán chríkjan tí nta. ");
INSERT INTO poeNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ntá tí chꞌín Moisés kuakitsjexín chꞌán Egipto tí sín tsíkꞌaxrjeníxinni ósé. La imá itsjé kjuaxroan kjuasin chꞌán la itsjé kjua̱ko̱xi̱n chꞌán tí nación Egipto, la ko tí Nta̱yaon Kjátse, la ko tí nte̱je̱ kꞌuáji sín cuarenta nánó. ");
INSERT INTO poeNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Jehe tí chꞌín Moisés a mé chénka tí sín israelita kíxin: “Dios mé tsochrꞌán ijnko chojni tsoníxja itén Dios tsꞌaxrjeníxin tí sín kíchuárá éxí ichrꞌán chꞌán tí janhan. Títekákonhénrá tí jehe chꞌán.” ");
INSERT INTO poeNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Tí chꞌín Moisés mé kjuákꞌeko chꞌán tí chojni tí kꞌuéjó sín tí nte̱je̱. Nta ijnko ángel mé nixje̱he̱ chꞌán tí jna̱ Sinaí la ko tí sín kꞌuaxrjeníxinni mé kꞌuáyéhe̱ sin tí tan tjanjon kjuachón, ntá tí tan mé kꞌuátsínka tí jeheni ijie. ");
INSERT INTO poeNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’A̱ ntá tí sín kꞌuaxrjeníxinni ósé mé tjinkakonhya sín kíxin chrókuitekaon sín la kjuanoá sín tí chꞌín Moisés la ko tjinkaon ínaá chrókjan sín nación Egipto. ");
INSERT INTO poeNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","A̱ ntá ntáche sín chꞌín Aarón kíxin: “Tjinkaonni si̱chꞌéna ijnko dios kíxin tsinkáchónkini kíxin í noehyani nkehe kónhen tí chꞌín Moisés, tí nkexro kjuínki̱tsa kꞌuaxrjexínni nación Egipto.” ");
INSERT INTO poeNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ntá kjuínchekjano̱ya sín ijnko koxintáxjan la ntá kꞌóyán sín iko kjo̱ke̱he̱ tí nkehe tsíkjano̱ya a la imá kóchéhe̱ sín kꞌuíkon sín tí nkehe tsíkꞌónaxín tja chojni. ");
INSERT INTO poeNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","A̱ ntá Dios mé kuíto̱he tí jehe sín kíxin tsinkáchónki sín tí konotsé siín nka̱jní. Tíhi mé tsíkjin ijnko nkexro kꞌuéchrónka itén Dios ntáchro xi̱kihi: Jahará chojni Israel, ¿á kꞌoyánrá tí iko kjóka̱nará tí janhan tí cuarenta nánó kꞌuejorá nte̱je̱ ní? ");
INSERT INTO poeNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Kja̱ náhí, jehó tí nkehe kjui̱chꞌénará mé kjóke̱hérá tí ko a. Kjuíkoará tí ni̱nko̱e tí dios Moloc la ko kja̱xin kjuíkoará tí konotsé kuènte dios Renfán. A̱ ntá tí nkehe tsíkji̱chꞌénará jahará mé xráxinkákonxínrá éxí Dios kuèntará. Méxra̱ janhan tsakítsjexínrá tí tjejorá la tsétua̱nhánrá sátsjirá chjasin Babilonia. Mé xi̱kaha ntáchro Dios ósé. ");
INSERT INTO poeNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Na̱xa̱ kꞌuéjó tí sín kꞌuaxrjeníxinni tí nte̱je̱ la chónta sín ijnko ni̱nko kamantá chónta tí ley tsíkꞌe̱toan Dios. Tíhi kjuíchꞌéna sín éxí tsíkꞌe̱tue̱nhen Dios tí chꞌín Moisés kíxin sichꞌéna chꞌán kaín nkehe kꞌuíkon chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ntá tí sín tsíkꞌaxrjeníxinni mé kꞌuáyéhe̱ sín tí ni̱nko kui̱to̱nhe̱n sín. Ntá tí sín kjui̱ka̱o chꞌín Josué mé kjui̱ka̱o sín tí ni̱nko tió kjuacha sín kꞌuáyéhe̱ sín í jnko nonte kuènte í so chojni kuakitsje Dios, kíxin tsꞌáyéhe̱ tí jehe sín. Mé xi̱kaha kónhen hasta tí ya̱on kjuankíxin kꞌue̱to̱an chꞌín David. ");
INSERT INTO poeNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Imá kjuíncheyaon Dios tí chꞌín rey David la ntá tí chꞌín David mé tjinkaon chꞌán sichꞌéna chꞌán ijnko ni̱nko kuènte Dios mé tí Dios kꞌuékinkáchónki chꞌín Jacob. ");
INSERT INTO poeNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Kjánchó jehe chꞌán kjuíchꞌénahya chꞌán tí ni̱nko a. Tí chꞌín Salomón mé kjuíchꞌéna. ");
INSERT INTO poeNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Kjánchó Dios nkaya nka̱jni chrohya tsjakꞌexenhen ijnko nchia tsíkjichꞌénaxín chojni itja. Ntáchro ijnko chꞌín nixja itén Dios kíxin: ");
INSERT INTO poeNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Janhan Dios nkaya nka̱jní itjén této̱anxián ntá chjasintajni tjekjen to̱tená. ¿Xá nkexéhe̱ tí nchia chrókjui̱chꞌénará? ¿Xá nketí chrókjuakꞌé chrókꞌo̱kꞌánaxián? ");
INSERT INTO poeNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Xá jehya tjaná kjui̱tꞌánaxián kaín tí nkehe ní? Mé xi̱kaha ichro Dios. ");
INSERT INTO poeNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","’A̱ ntá jahará la icha a̱sánrá xráxín títekákonhyará. Jahará tinhínrá kjánchó ichꞌerá éxí chojni chónhya Dios. Xráxín tjánjo̱nkoárá Ncha̱kuen Dios. Jahará mé tóyóha̱rá tí sín tsíkꞌaxrjeníxinrá ósé. ");
INSERT INTO poeNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Tí sín tsíkꞌaxrjeníxinrá kjuínchekjasóte kaín tí sín tsíchrónka itén Dios. Kꞌóyán sín tí sín kꞌuéchrónka kíxin itsi tí nkexro chóntahya jie̱. A̱ ntá ó kui tí nkexro a ntá jahará kjui̱nchekjirá chꞌán ntá kꞌóyán sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Jahará kꞌuayéhérá tí nkehe kꞌue̱to̱an Dios senó, mé tí nkehe chrónka tí ángel, la kjónté xi̱kaha kuítekákonhyará ―ichro chꞌín Esteban. ");
INSERT INTO poeNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ntá tí kuínhin tí jehe sín tí nkehe ntáchro tí chꞌín Esteban ntá imá kónínkaon sín la netaón neno sín kíxin nínkakonhen sín chꞌán. ");
INSERT INTO poeNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","A̱ ntá chꞌín Esteban a̱ntsí chónta chꞌán Ncha̱kuen Dios la konta chꞌán nka̱jní kꞌuíkon chꞌán kjua̱cha̱xién Dios la ko kꞌuíkon chꞌán kíxin chꞌín Jesús tjexín to̱té chꞌán nánko tja chjina Dios. ");
INSERT INTO poeNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ntá ntáchro chꞌín Esteban kíxin: ―Tsjehérá kíxin kꞌuíkua̱n kíxin xitje̱he̱ nka̱jní la ntaha itjen tí Xje̱en Dios Kꞌóna Chojni nánko tja chjina Dios. ");
INSERT INTO poeNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","A̱ ntá jehe sín la kꞌuikjehe̱ sín ntatsjon sín la itsen kꞌuíxité sín ntá sákjuí sín kꞌuíxitja sín chꞌán ");
INSERT INTO poeNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","sákjui̱ko sín chꞌán ikon chjasin ntá ixro̱ chjéhe sín chꞌán. La tí sín tjanchia jie̱ mé kuakitsje sín iké sín la kꞌuejo sín to̱té ijnko chꞌín ntasoá itꞌin Saulo kíxin tsꞌayakonhen chꞌán tí ka a. ");
INSERT INTO poeNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","La itꞌe sín xro̱ ntá chꞌín Esteban mé chrónóe̱he̱ chꞌán Ìnchéni la ntáchro chꞌán kíxin: —Ìnchéni Jesús takjá ncha̱kuenná. ");
INSERT INTO poeNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ntá tuénxín kjuákꞌexín tochꞌin chꞌán la kꞌuèya chꞌán itsen ntáchro chꞌán kíxin: ―Ìnchéni jaha mé tahya kuentá tí jie̱ kjuasin sín. Mé xi̱kaha ichro chꞌán ntá ikꞌuén chꞌán.﻿ ");
INSERT I