﻿USE sofia;
DROP TABLE IF EXISTS sofia.pmy_vpl;
CREATE TABLE pmy_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES pmy_vpl WRITE;
INSERT INTO pmy_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Waktu pertama skali, Allah bikin langit deng bumi ni smua. ");
INSERT INTO pmy_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Waktu itu, bumi ni masi trada bentuk, trada apapa ada air saja, baru smua glap. Roh Allah ada mlayang-mlayang di atas air situ. ");
INSERT INTO pmy_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Trus begini Allah bilang, “Sa mau ada trang skarang!” Langsung trang de jadi. ");
INSERT INTO pmy_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Allah liat kalo trang ni de bagus. Baru trang deng glap ni, Allah kas pisa dorang. ");
INSERT INTO pmy_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Allah kas nama trang tu ʻsiangʼ baru glap tu ʻmalam.ʼ Suda, malam su lewat trus pagi muncul. Begitu suda, hari pertama de jadi. ");
INSERT INTO pmy_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Habis itu, Allah bilang begini, “Sa mau ada batas di tenga-tenga air skarang! Supaya air di bagian atas deng air di bagian bawa tapisa.” ");
INSERT INTO pmy_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Jadi, Allah bikin batas itu trus kas pisa air jadi dua, satu di atas batas itu, trus satu lagi di bawa batas itu. Suda, de jadi begitu. ");
INSERT INTO pmy_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Allah kas nama batas itu ʻlangit.ʼ Trus malam su lewat, pagi muncul lagi. Begitu suda, hari kedua de jadi. ");
INSERT INTO pmy_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Habis itu, Allah bilang begini, “Sa mau, smua air yang ada di bawa langit kumpul di satu tempat, trus ada tempat yang kring juga.” Suda, de jadi begitu. ");
INSERT INTO pmy_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Allah kas nama tempat kring tu ʻdarat.ʼ Baru tempat yang air ada kumpul tu, Allah kas nama ʻlaut.ʼ Allah liat kalo smua ni su bagus. ");
INSERT INTO pmy_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Trus, Allah bilang lagi, “Sa mau tana kas tumbu macam-macam tanaman skarang! Dari tanaman biji sampe pohon-pohon yang ada bua.” Suda, de jadi begitu. ");
INSERT INTO pmy_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Langsung tana kas tumbu macam-macam tanaman. Dari tanaman biji sampe pohon-pohon yang ada bua. Allah liat kalo smua ni su bagus. ");
INSERT INTO pmy_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Trus malam su lewat, pagi muncul lagi. Begitu suda, hari ketiga de jadi. ");
INSERT INTO pmy_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Habis itu, Allah bilang begini, “Sa mau, ada barang trang di langit! Supaya dong kas pisa siang dari malam. Nanti barang trang ini yang kasi tanda untuk musim-musim, hari-hari, deng taun-taun. ");
INSERT INTO pmy_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Trus, barang trang di langit ni yang nanti kas trang bumi.” Suda, de jadi begitu. ");
INSERT INTO pmy_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Jadi Allah bikin dua barang trang yang besar untuk kas trang bumi. Yang paling besar, de urus siang. Baru yang satu lagi, de urus malam. Allah juga bikin bintang-bintang. ");
INSERT INTO pmy_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Allah taru dong smua di langit situ, untuk kas trang ke bumi. ");
INSERT INTO pmy_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Juga supaya dong bisa urus siang deng malam, trus untuk kas pisa trang dari glap. Allah liat kalo smua ni su bagus. ");
INSERT INTO pmy_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Trus malam su lewat, pagi muncul lagi. Begitu suda, hari keempat de jadi. ");
INSERT INTO pmy_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Habis itu, Allah bilang begini, “Sa mau ada banyak yang hidup dalam air skarang! Sa juga mau, ada burung-burung yang terbang di atas bumi, terbang di langit situ.” ");
INSERT INTO pmy_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Jadi, Allah bikin binatang-binatang laut yang besar. Allah juga bikin macam-macam binatang lain yang hidup deng jalan-jalan di air. Allah juga bikin macam-macam burung. Allah liat kalo smua ni su bagus. ");
INSERT INTO pmy_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Trus Allah kas berkat smua yang De su bikin itu, Allah bilang, “Kas lahir kam pu anana cucu, trus tamba banyak supaya bisa bikin air dalam laut ni penu deng kam. Burung-burung, kam juga tamba banyak!” ");
INSERT INTO pmy_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Trus malam su lewat, pagi muncul lagi. Begitu suda, hari kelima de jadi. ");
INSERT INTO pmy_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Habis itu, Allah bilang lagi begini, “Sa mau tana kas tumbu macam-macam binatang yang hidup di tana skarang! Binatang piara, binatang yang mrayap, deng macam-macam binatang liar.” Suda, de jadi begitu. ");
INSERT INTO pmy_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Begitu suda, Allah bikin macam-macam binatang liar deng macam-macam binatang piara, sama macam-macam binatang yang mrayap. Allah liat kalo smua ni su bagus. ");
INSERT INTO pmy_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Trus Allah bilang begini, “Skarang, mari Tong bikin manusia yang sperti Kitong! Sa mau, dong yang pu kuasa untuk atur ikan-ikan smua, burung-burung smua, deng smua binatang piara sama binatang-binatang yang mrayap smua, trus dong yang atur bumi ni smua.” ");
INSERT INTO pmy_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Jadi begitu suda, Allah bikin manusia yang sperti Allah sendiri. Allah bikin laki-laki deng prempuan sperti Allah sendiri. ");
INSERT INTO pmy_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Habis itu, Allah kas berkat dong dua begini, “Kas lahir anana deng cucu-cucu trus tamba banyak! Kas penu bumi trus pegang kuasa untuk atur bumi. Atur ikan-ikan smua, burung-burung smua, deng smua binatang yang hidup di darat.” ");
INSERT INTO pmy_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Trus Allah bilang lagi, “Liat! Smua dari tanaman biji sampe pohon-pohon yang ada bua, Sa kasi dong smua untuk jadi kam pu makanan. ");
INSERT INTO pmy_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Trus untuk smua binatang yang di darat deng smua burung yang di udara deng smua yang mrayap, smua yang hidup, Sa kasi tanaman-tanaman smua untuk jadi dong pu makanan.” Suda, smua itu jadi begitu. ");
INSERT INTO pmy_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Habis itu, Allah liat smua yang De su bikin ni, memang su bagus skali. Trus malam su lewat, pagi muncul lagi. Begitu suda, hari keenam de jadi. ");
INSERT INTO pmy_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Jadi begitu suda, bagemana langit deng bumi sama de pu isi smua dapa bikin sampe slesai. ");
INSERT INTO pmy_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Waktu hari ketuju, Allah su kas slesai kerja yang De bikin itu. Suda, hari ketuju tu Allah brenti dari smua kerja itu. ");
INSERT INTO pmy_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Trus Allah kas berkat hari ini, baru De kas kusus hari ketuju ini. Allah bikin begini karna pas hari ketuju, Allah brenti dari smua kerja yang De su kas slesai itu. ");
INSERT INTO pmy_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Ini crita, bagemana sampe langit deng bumi ni bisa ada. Waktu TUHAN Allah bikin langit deng bumi ini, ");
INSERT INTO pmy_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","blum ada tanaman apapa, mo rumput juga blum ada yang tumbu di bumi. Itu karna TUHAN Allah blum kas turun hujan ke bumi deng blum ada orang yang kerja tana ini. ");
INSERT INTO pmy_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Tapi begini, ada air yang kluar dari tana yang bikin basa bagian atas tana smua. ");
INSERT INTO pmy_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Trus TUHAN Allah bentuk manusia dari debu tana, baru Allah tiup napas yang kasi hidup ke dalam manusia pu hidung. Jadi manusia de hidup. ");
INSERT INTO pmy_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Habis itu, TUHAN Allah bikin taman di sebla timur, di daera yang de pu nama Eden. Manusia yang su dapa bentuk ni Allah taru di taman itu. ");
INSERT INTO pmy_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Trus dari tana, TUHAN Allah kas tumbu macam-macam pohon. Pohon yang kliatan bagus, deng pohon yang de pu bua bagus untuk jadi makanan. Baru, di bagian tenga taman itu juga, tumbu pohon yang de pu bua bikin orang bisa tetap hidup trus, sama pohon yang de pu bua bikin orang bisa tau mana yang baik deng mana yang jahat. ");
INSERT INTO pmy_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Di daera Eden ini ada kali besar satu. Kali ini de yang lewat dari taman ini untuk kas basa de pu tana. Begitu kluar dari daera Eden, kali besar ini de tabagi jadi empat bagian. ");
INSERT INTO pmy_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","De pu bagian yang pertama tu, de pu nama kali Pison. Kali ini de mngalir kliling tana Hawila smua, ini tana tempat emas asli. ");
INSERT INTO pmy_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Tana ini pu emas tu, emas paling bagus suda. Di tana ini juga ada pohon yang de pu geta harum skali. Trus ada Krisopras juga, batu yang kilat, de pu harga mahal skali. ");
INSERT INTO pmy_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Bagian yang kedua, de pu nama kali Gihon. Kali ini de mngalir kliling tana Kus smua. ");
INSERT INTO pmy_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Bagian yang ketiga de pu nama kali Tigris. Kali ini de mngalir di bagian timur tana Asyur. Kalo bagian yang keempat, de pu nama kali Efrat. ");
INSERT INTO pmy_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","TUHAN Allah taru manusia de dalam taman Eden untuk kerja deng jaga liat taman itu. ");
INSERT INTO pmy_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Baru, TUHAN Allah kasi printa begini ke manusia dia, “Ko bisa makan bua apa saja dari tiap pohon di taman ini. ");
INSERT INTO pmy_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Tapi, pohon yang de pu bua bikin orang bisa tau mana yang baik deng mana yang jahat tu, ko tra bole makan de pu bua, karna ko pasti mati waktu ko makan.” ");
INSERT INTO pmy_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Baru TUHAN Allah bilang, “Tra baik juga eh, kalo manusia de sendiri begini. Sa mo bikin de pu kawan. Kawan yang cocok deng dia, untuk tolong dia.” ");
INSERT INTO pmy_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Trus TUHAN Allah bikin smua binatang dari tana, binatang yang di darat deng burung yang di udara. Trus Allah bawa datang binatang smua ke manusia itu supaya manusia de kas nama binatang-binatang itu. Dari nama yang manusia de kasi, itu yang nanti binatang-binatang ini dapa panggil begitu. ");
INSERT INTO pmy_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Manusia de kas nama binatang piara smua, binatang liar smua, sama smua burung di udara. Tapi manusia de tra ketemu kawan untuk de pu diri. Kawan yang cocok deng dia, yang bisa tolong dia. ");
INSERT INTO pmy_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Jadi, TUHAN Allah bikin manusia de tidur sono skali. Waktu de su tidur, TUHAN Allah ambil manusia pu tulang rusuk satu, trus tutup bagian itu deng daging. ");
INSERT INTO pmy_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Dari tulang rusuk yang su dapa ambil dari manusia itu, TUHAN Allah bentuk prempuan satu. Trus Allah bawa prempuan ini datang ke manusia itu. ");
INSERT INTO pmy_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Trus manusia itu de bilang begini, “Memang, de ini suda! De pu tulang deng sa pu tulang, itu satu. De pu daging deng sa pu daging, satu juga. Nanti de dapa panggil ʻprempuan,ʼ karna Allah bentuk de dari laki-laki.” ");
INSERT INTO pmy_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Itu jadi laki-laki tra tinggal lagi sama de pu bapa deng mama, tapi hidup satu hati deng de pu istri, biar dong dua jadi satu. ");
INSERT INTO pmy_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Waktu itu, manusia deng de pu istri tlanjang tapi dong dua tra rasa malu. ");
INSERT INTO pmy_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Waktu TUHAN Allah bikin binatang-binatang liar, dari dong smua, ada binatang satu yang paling pintar putar balik kata skali, de tu ular. Satu kali begini, ular de pigi bicara ke prempuan. De bilang begini, “Betul ka, Allah larang kam makan bua dari smua pohon dalam taman ini?” ");
INSERT INTO pmy_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Trus prempuan de jawab, “Trada, bukan begitu. Bua-bua dari pohon dalam taman ni, tong bole makan. ");
INSERT INTO pmy_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Tapi Allah bilang kalo bua dari pohon yang ada di bagian tenga taman tu yang tong tra bole makan ato raba de pu bua, supaya tong jang mati. ” ");
INSERT INTO pmy_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Tapi ular de bilang prempuan begini, “Eh, kam trakan mati. Trada skali. ");
INSERT INTO pmy_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Allah bilang begitu karna De tau kalo kam makan bua itu, nanti kam pu mata tabuka, kam jadi tau mana yang baik deng mana yang jahat, macam Allah Dia.” ");
INSERT INTO pmy_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Prempuan de liat pohon ni de pu bua macam enak trus de kliatan bagus skali, baru bisa bikin de mngerti smua deng baik. Jadi, de ambil pohon itu pu bua trus de makan. Trus de kasi bua itu ke de pu suami yang ada sama-sama deng de juga. Trus de pu suami juga makan. ");
INSERT INTO pmy_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Habis makan, langsung dong dua pu mata tabuka, trus dong tau kalo dong ada tlanjang. Jadi, dong dua ikat daun-daun dari pohon ara trus pake tutup dong pu badan. ");
INSERT INTO pmy_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Sore-sore begini, dong dengar TUHAN Allah ada jalan-jalan di taman situ. Jadi, manusia deng de pu istri tu, dong dua sembunyi dari TUHAN Allah di cla-cla pohon yang ada dalam taman situ. ");
INSERT INTO pmy_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Tapi, TUHAN Allah panggil manusia itu, “Ko dimana?” ");
INSERT INTO pmy_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Manusia itu de jawab, “Ah... waktu sa dengar Tuhan ada jalan di taman sini, sa takut jadi sa sembunyi. Sa tlanjang jadi.” ");
INSERT INTO pmy_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","TUHAN Allah tanya dia, “Sapa yang kastau kalo ko tlanjang? Ko pasti su makan bua dari pohon yang Sa larang ko makan itu to?” ");
INSERT INTO pmy_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Manusia itu de jawab, “Prempuan de yang kasi sa bua dari pohon itu, prempuan yang Tuhan kasi untuk jadi sa pu istri tu. Itu yang sa makan.” ");
INSERT INTO pmy_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Trus TUHAN Allah bicara ke prempuan, “Knapa sampe ko bisa bikin begitu?” Prempuan itu de jawab, “Ular tu, de yang tipu saya, itu yang sa makan bua itu.” ");
INSERT INTO pmy_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Habis itu, TUHAN Allah bicara ke ular begini, “Karna ko su bikin begitu, Sa kasi kutuk ini ke ko: Dari smua binatang piara deng smua binatang liar, ko yang nanti jalan mrayap pake perut, trus debu tana yang jadi ko pu makanan sampe nanti ko mati. ");
INSERT INTO pmy_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Sa nanti bikin ko deng prempuan ini baku musu. Ko pu turunan deng prempuan ini pu turunan nanti baku musu juga. Nanti de pu turunan kas hancur ko pu kepala, trus ko nanti patok de pu tumit.” ");
INSERT INTO pmy_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Trus TUHAN Allah bicara ke prempuan begini, “Nanti ko pu rasa stenga mati waktu ko hamil, Sa kas tamba banyak. Trus nanti waktu ko mo lahir anak, ko rasa sakit skali. Biar su begitu tapi, ko nanti tetap mau deng ko pu suami, tapi ko pu suami yang nanti pu kuasa atas ko.” ");
INSERT INTO pmy_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Baru ke Adam, TUHAN Allah bilang begini, “Ko su ikut ko pu istri pu kata-kata untuk makan bua dari pohon yang Sa larang ko makan. Gara-gara ko pu klakuan itu, Sa kasi kutuk ke tana ini. Slama ko hidup, ko harus kerja tana ini stenga mati untuk bisa dapat makanan dari situ. ");
INSERT INTO pmy_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Tana ini yang nanti kas tumbu apa yang ko makan, tapi ada rumput deng tanaman duri juga yang tumbu dari situ. ");
INSERT INTO pmy_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ko harus kerja sampe kringat-kringat untuk dapat ko pu makanan dari tana ini. Ko pu hidup nanti begitu trus sampe ko kembali ke tana. Ko ini dari debu, jadi ko nanti kembali jadi debu lagi.” ");
INSERT INTO pmy_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adam de panggil de pu istri deng nama Hawa, karna nanti prempuan ini de jadi mama yang lahir moyang-moyang dari smua manusia. ");
INSERT INTO pmy_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Habis itu, TUHAN Allah bikin pakean dari binatang pu kulit untuk kas pake ke Adam deng de pu istri. ");
INSERT INTO pmy_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Habis itu smua, TUHAN Allah bicara begini, “Skarang, manusia de su sama macam Kitong, tau mana yang baik deng mana yang jahat. Tong harus jaga baik-baik, jang sampe nanti de ambil bua dari pohon yang de pu bua bikin orang tetap hidup trus, baru makan itu. Begitu nanti de tetap hidup trus.” ");
INSERT INTO pmy_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Jadi suda, TUHAN Allah usir dong dua kluar dari taman Eden. Allah bikin manusia dari tana, tapi skarang De suru manusia pigi kerja tana itu. ");
INSERT INTO pmy_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Habis itu, Allah taru malaikat-malaikat penjaga di bagian timur taman Eden. Trus Allah taru pedang api yang taputar ke smua ara juga. Allah taru dong disitu, untuk jaga jalan yang mo ke pohon yang de pu bua bikin orang hidup trus. ");
INSERT INTO pmy_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adam deng de pu istri Hawa tidur sama-sama, trus Hawa hamil. Hawa de lahir anak laki-laki satu. Trus de bilang begini, “TUHAN su tolong sa sampe sa bisa dapat anak laki-laki satu.” Itu yang, de kas nama anak itu Kain. ");
INSERT INTO pmy_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Habis itu, Hawa de lahir anak laki-laki satu lagi, Kain pu ade. De kas nama anak itu Habel. Dong dua su besar trus Habel de pu kerja tu jaga liat kambing domba, baru Kain de pu kerja tu bikin kebun. ");
INSERT INTO pmy_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Satu kali begini, Kain de bawa de pu hasil kebun sbagian untuk jadi de pu persembahan ke TUHAN. ");
INSERT INTO pmy_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Habel juga, de potong kambing domba pu anana pertama brapa, baru ambil dong pu bagian lemak-lemak yang paling bagus ni untuk jadi de pu persembahan ke TUHAN. TUHAN snang trima Habel deng de pu persembahan. ");
INSERT INTO pmy_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Tapi TUHAN tra trima Kain deng de pu persembahan. Jadi, Kain de su tabakar emosi. De su bikin muka tra baik suda. ");
INSERT INTO pmy_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Trus, TUHAN bilang ke Kain, “Knapa ko bikin muka tra baik begitu? Knapa ko emosi skali? ");
INSERT INTO pmy_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Kalo ko bikin yang baik, ko pasti senyum. Tapi kalo ko bikin yang tra baik, dosa de ada tunggu ko. De siap mo srang trus tarik ko supaya masuk dalam de pu kuasa. Tapi ko harus kuat lawan de supaya ko yang pegang kuasa.” ");
INSERT INTO pmy_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Skarang begini, Kain de pigi bilang ke de pu ade Habel, “We... mari tong dua pigi kluar.” Pas dong dua di daera sepi tempat rumput saja, kaget begini Kain de srang de pu ade trus bunu de mati. ");
INSERT INTO pmy_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Trus TUHAN tanya Kain, “Kain, ko pu ade Habel ada dimana?” Kain de jawab, “Tratau. Memang sa ini de pu penjaga ka?” ");
INSERT INTO pmy_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","TUHAN bicara lagi, “Knapa ko bikin begitu? Ko pu ade pu dara ada triak dari tana, de minta Sa untuk balas ke orang yang su bunu dia. ");
INSERT INTO pmy_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Tana ini yang su buka de pu mulut, su tada ko pu ade pu dara dari ko pu tangan. Jadi mulai dari skarang ko dapat kutuk tra bole tinggal di tana ini lagi. ");
INSERT INTO pmy_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Trus kalo ko coba tanam apa saja, tana trakan kas kluar hasil. Nanti ko trakan tinggal di satu tempat, ko jadi orang yang tratau mo kemana di bumi ini.” ");
INSERT INTO pmy_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Trus Kain jawab ke TUHAN, “Adu TUHAN, hukuman itu brat skali ka, sa tra bisa. ");
INSERT INTO pmy_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","TUHAN su usir sa dari tana ini trus sa juga harus jau dari TUHAN. Su begitu, sa juga trakan tinggal di satu tempat baru tratau mo kemana di bumi ini. Kalo ada yang ketemu sa, nanti de pasti bunu saya.” ");
INSERT INTO pmy_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Tapi TUHAN jawab de begini, “Trakan. Kalo ada yang bunu ko, de nanti dapa balas sampe tuju kali lipat.” Habis itu, TUHAN kasi tanda di Kain dia, supaya sapa saja yang ketemu de, trakan bunu dia. ");
INSERT INTO pmy_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Jadi suda, Kain de pigi jau dari TUHAN trus de hidup di tana Nod. Tana itu ada di bagian timur taman Eden. ");
INSERT INTO pmy_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Skarang begini, Kain de tidur deng de pu istri. De pu istri hamil trus lahir anak laki-laki satu. Anak itu pu nama Henok. Trus Kain de bangun kota satu baru kas nama kota itu deng de pu anak pu nama. ");
INSERT INTO pmy_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Henok juga pu anak yang de nama Irad. Irad juga pu anak yang nama Mehuyael. Mehuyael juga pu anak yang nama Metusael. Metusael juga pu anak yang nama Lamek. ");
INSERT INTO pmy_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamek de pu istri ada dua. Yang satu de pu nama Adah, trus yang satu lagi de pu nama Zila. ");
INSERT INTO pmy_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","De pu istri Adah ni lahir anak yang nama Yabal. Yabal ni orang pertama yang kerja jaga-jaga binatang piara deng tinggal dalam tenda. ");
INSERT INTO pmy_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Yabal pu ade nama Yubal. Yubal ini orang pertama yang main alat musik kecapi deng suling. ");
INSERT INTO pmy_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Lamek pu istri Zila juga lahir anak yang nama Tubal-Kain. Tubal-Kain ni yang jadi tukang tembaga deng besi. Tubal-Kain de ada ade prempuan yang nama Naama. ");
INSERT INTO pmy_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Satu kali begini, Lamek de bicara deng de pu istri dua ni begini, “Adah deng Zila, kam dengar yang sa mo bilang ini, kam dua pasang tlinga baik-baik! Ada anak muda satu de mo kas luka saya, anak kecil baru, de mo kas lecet saya, sa su bunu dia. ");
INSERT INTO pmy_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Kalo untuk Kain, orang yang su bunu de nanti dapa balas tuju kali lipat, brarti untuk Lamek, 77 kali lipat.” ");
INSERT INTO pmy_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam deng de pu istri Hawa dong tidur sama-sama lagi, trus de pu istri hamil baru lahir anak laki-laki satu. Hawa bilang begini, “Allah su kasi anak laki-laki satu lagi ke sa, untuk ganti Habel yang Kain su bunu.” Dari situ yang Hawa kas nama anak itu Set. ");
INSERT INTO pmy_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Set juga pu anak, yang de kas nama Enos. Di Enos pu jaman baru orang-orang dong mulai semba TUHAN. ");
INSERT INTO pmy_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","2","Allah bikin laki-laki deng prempuan dong sperti Allah. Allah kas berkat dorang trus panggil dong ʻmanusia.ʼ Ini manusia pertama yang nama Adam ni de pu daftar anana cucu. ");
INSERT INTO pmy_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Waktu Adam pu umur su masuk 130 taun, de pu anak satu yang sperti de, lahir. Adam kas nama de pu anak tu, Set. ");
INSERT INTO pmy_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Habis itu, Adam masi hidup sampe 800 taun lagi. Stela Set, Adam pu anana laki-laki deng prempuan yang lain juga lahir. ");
INSERT INTO pmy_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Jadi, Adam pu umur tu sampe 930 taun, baru de mninggal. ");
INSERT INTO pmy_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Waktu Set pu umur su masuk 105 taun, de pu anak yang nama Enos lahir. ");
INSERT INTO pmy_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Habis itu, Set masi hidup sampe 807 taun lagi. Stela Enos, masi ada anana laki-laki deng prempuan lagi yang lahir untuk Set. ");
INSERT INTO pmy_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Jadi, Set pu umur tu sampe 912 taun, baru de mninggal. ");
INSERT INTO pmy_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Waktu Enos pu umur su masuk 90 taun, de pu anak yang nama Kenan lahir. ");
INSERT INTO pmy_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Habis itu, Enos masi hidup sampe 815 taun lagi. Stela Kenan, masi ada anana laki-laki deng prempuan lagi yang lahir untuk Enos. ");
INSERT INTO pmy_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Jadi, Enos pu umur tu sampe 905 taun, baru de mninggal. ");
INSERT INTO pmy_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Waktu Kenan pu umur su masuk 70 taun, de pu anak yang nama Mahalaleel lahir. ");
INSERT INTO pmy_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Habis itu, Kenan masi hidup sampe 840 taun lagi. Stela Mahalaleel, masi ada anana laki-laki deng prempuan lagi yang lahir untuk Kenan. ");
INSERT INTO pmy_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Jadi, Kenan pu umur tu sampe 910 taun, baru de mninggal. ");
INSERT INTO pmy_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Waktu Mahalaleel pu umur su masuk 65 taun, de pu anak yang nama Yared lahir. ");
INSERT INTO pmy_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Habis itu, Mahalaleel masi hidup sampe 830 taun lagi. Stela Yared, masi ada anana laki-laki deng prempuan lagi yang lahir untuk Mahalaleel. ");
INSERT INTO pmy_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Jadi, Mahalaleel pu umur tu sampe 895 taun, baru de mninggal. ");
INSERT INTO pmy_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Waktu Yared pu umur su masuk 162 taun, de pu anak yang nama Henok lahir. ");
INSERT INTO pmy_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Habis itu, Yared masi hidup sampe 800 taun lagi. Stela Henok, masi ada anana laki-laki deng prempuan lagi yang lahir untuk Yared. ");
INSERT INTO pmy_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Jadi, Yared pu umur tu sampe 962 taun, baru de mninggal. ");
INSERT INTO pmy_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Waktu Henok pu umur su masuk 65 taun, de pu anak yang nama Metusala lahir. ");
INSERT INTO pmy_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Habis itu, Henok masi hidup sampe 300 taun lagi. Dalam 300 taun itu, Henok de baku teman dekat skali deng Allah. Habis Metusala, masi ada anana laki-laki deng prempuan lagi yang lahir untuk Henok. ");
INSERT INTO pmy_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Henok hidup sampe umur 365 taun. ");
INSERT INTO pmy_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","De hidup baku teman dekat skali deng Allah, trus de hilang. Karna Allah angkat de langsung dari dunia ini. ");
INSERT INTO pmy_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Waktu Metusala pu umur su masuk 187 taun, de pu anak yang nama Lamek lahir. ");
INSERT INTO pmy_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Habis itu, Metusala masi hidup sampe 782 taun lagi. Stela Lamek, masi ada anana laki-laki deng prempuan lagi yang lahir untuk Metusala. ");
INSERT INTO pmy_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Jadi, Metusala pu umur tu sampe 969 taun, baru de mninggal. ");
INSERT INTO pmy_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Waktu Lamek pu umur su masuk 182 taun, de pu anak satu lahir. ");
INSERT INTO pmy_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Lamek bilang begini, “Anak ini, de nanti bikin tong rasa lega dari tong pu kerja stenga mati di tana yang TUHAN su kutuk ini.” Itu yang, Lamek kas nama de Nuh. ");
INSERT INTO pmy_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Habis itu, Lamek masi hidup sampe 595 taun lagi. Stela de pu anak Nuh ini lahir, masi ada anana laki-laki deng prempuan lagi yang lahir untuk Lamek. ");
INSERT INTO pmy_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Jadi, Lamek pu umur tu sampe 777 taun, baru de mninggal. ");
INSERT INTO pmy_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Waktu Nuh pu umur su masuk 500 taun, de pu anana laki-laki tiga lahir. Dong pu nama tu Sem, Yafet, deng Ham. ");
INSERT INTO pmy_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Orang-orang su mulai tamba banyak kas penu sluru bumi. Dong pu anana prempuan juga lahir. ");
INSERT INTO pmy_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Waktu itu anana laki-laki yang asal dari Allah dong liat kalo manusia pu anana prempuan ni dong bagus-bagus skali. Jadi, dong ambil anana prempuan tu untuk jadi dong pu istri. Dong ambil sapa saja yang dong suka. ");
INSERT INTO pmy_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Trus TUHAN bilang begini, “Sa pu Roh yang kas hidup manusia, De trakan tinggal di manusia lama-lama. Karna manusia itu dara deng daging saja. De pu hidup nanti hanya sampe 120 taun saja.” ");
INSERT INTO pmy_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Waktu dulu tu orang-orang tinggi besar macam raksasa begitu dong ada di bumi ini. Itu waktu, anana laki-laki yang asal dari Allah ni dong kawin deng manusia pu anana prempuan. Dari dong ni yang orang-orang tinggi besar ini lahir. Orang-orang tinggi besar ini ada di jaman itu deng jaman stela itu juga. Orang-orang tinggi besar ini dong paling jago baru paling dapa knal skali dulu. ");
INSERT INTO pmy_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Waktu TUHAN liat begini, manusia pu jahat su tamba para skali di bumi ini. Manusia dong pu hati deng pikiran ni tinggal pikir yang jahat-jahat saja trus. ");
INSERT INTO pmy_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Itu bikin TUHAN De pu hati sedi skali liat begitu. De mnyesal skali su bikin baru taru manusia di bumi. ");
INSERT INTO pmy_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Jadi, TUHAN bilang begini, “Sa mo kas hilang manusia-manusia yang Sa su bikin dari bumi ini, deng binatang-binatang darat, binatang-binatang yang mrayap, sama burung-burung di udara juga. Sa mnyesal skali su bikin dong smua.” ");
INSERT INTO pmy_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Tapi Nuh de ni yang TUHAN snang. ");
INSERT INTO pmy_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Ini crita tentang Nuh deng de pu kluarga. Nuh itu orang benar. Dari smua orang yang hidup waktu itu, hanya Nuh sendiri yang hidup ikut yang Allah mau. De baku teman dekat skali deng Allah. ");
INSERT INTO pmy_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nuh de pu anana ada tiga. Dong pu nama Sem, Yafet, deng Ham. ");
INSERT INTO pmy_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Begini Allah liat kalo orang-orang pu klakuan su rusak para, baru apa saja yang jahat su tamba banyak di bumi. ");
INSERT INTO pmy_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Waktu Allah cek bumi, De liat, memang bumi ni su rusak para gara-gara manusia dong pu hidup yang jahat itu. ");
INSERT INTO pmy_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Jadi, Allah bilang ke Nuh, “Sa mo sapu bersi smua yang hidup di dunia ini, karna dong su bikin bumi penu deng hal-hal jahat. Jadi, Sa nanti sapu bersi dong smua lapis deng bumi pu smua-smua. ");
INSERT INTO pmy_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Jadi, ko bikin untuk ko, kapal paling besar skali dari kayu yang kuat. Baru tutup de pu cla-cla pake aspal cair dari luar deng dari dalam. Di bagian dalam ko bikin ruang sendiri-sendiri. ");
INSERT INTO pmy_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ini de pu panjang deng lebar kapal bentuk kotak besar itu: Kapal de pu panjang 133 meter, de pu lebar 22 meter, de pu tinggi 13 meter. ");
INSERT INTO pmy_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ko bikin kapal pu tutup atas, tapi kas jarak 44 sentimeter di atas de pu dinding kapal. Bikin de tiga tingkat. Baru pasang pintu satu di bagian samping kapal. ");
INSERT INTO pmy_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Dengar ini! Sa mo kas datang banjir besar skali kas tutup bumi ini smua. Supaya smua yang hidup di bawa langit, yang ada di bumi ni nanti mati. ");
INSERT INTO pmy_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Tapi ko, nanti Sa mo ikat janji deng ko. Ko harus masuk ke dalam kapal itu, ko deng ko pu istri sama ko pu anana deng dong pu istri-istri. ");
INSERT INTO pmy_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Dari smua yang hidup, dari smua binatang-binatang ini, ko harus bawa satu pasang, jantan deng betina, bawa dong masuk ke kapal itu sama-sama. Bikin begitu supaya dong bisa tetap hidup sama-sama deng ko. ");
INSERT INTO pmy_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Dari macam-macam burung, juga smua jenis binatang yang mrayap di tana, deng dari smua binatang-binatang yang ada di darat. Dong smua nanti datang satu-satu pasang ke ko, supaya dong bisa tetap hidup. ");
INSERT INTO pmy_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Trus, ko juga bawa smua yang kam bisa makan. Ko kumpul itu smua, supaya nanti kam smua ada makanan.” ");
INSERT INTO pmy_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Habis dengar itu Nuh de bikin itu smua sama sperti yang Allah su printa dia. ");
INSERT INTO pmy_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Stela itu, TUHAN bicara ke Nuh begini, “Nuh, masuk ke dalam kapal besar itu. Ko deng ko pu kluarga juga. Karna dari yang Sa liat di orang-orang jaman ini, hanya ko saja yang orang benar. ");
INSERT INTO pmy_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Trus dari smua binatang-binatang yang tra pamali, ko ambil tuju-tuju pasang, betina deng jantan. Tapi untuk binatang-binatang yang pamali, ko ambil satu-satu pasang saja, betina deng jantan. ");
INSERT INTO pmy_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Untuk burung-burung juga, ko ambil tuju-tuju pasang, jantan deng betina. Bikin begitu, supaya dong pu turunan tetap hidup trus di bumi. ");
INSERT INTO pmy_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Karna nanti tuju hari lagi, Sa mo kas turun hujan dari pagi sampe malam sampe pagi lagi. Hujan de tetap turun trus sampe 40 hari. Sa mo sapu rata smua yang ada hidup di bumi ini, smua yang Sa su bikin itu.” ");
INSERT INTO pmy_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Nuh de bikin smua yang TUHAN printa dia. ");
INSERT INTO pmy_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Waktu banjir besar tutup bumi itu, Nuh pu umur 600 taun. ");
INSERT INTO pmy_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nuh deng de pu istri, sama de pu anana deng dong pu istri, dong smua masuk ke dalam kapal itu untuk kas slamat diri dari banjir paling besar itu. ");
INSERT INTO pmy_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Trus binatang yang tra pamali deng yang pamali, dari burung-burung sampe smua binatang yang mrayap di tana, ");
INSERT INTO pmy_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","dong datang satu-satu pasang ke Nuh dalam kapal itu. Dong smua, jantan deng betina, datang sperti yang Allah su suru Nuh. ");
INSERT INTO pmy_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Pas su tuju hari begini, banjir besar mulai datang tutup bumi smua. ");
INSERT INTO pmy_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Itu pas di bulan dua, hari ke-17, waktu Nuh de pu umur 600 taun. Di hari itu suda, smua mata air yang ada dalam tana, smua kas hambur de pu air kluar. Baru tempat-tempat air yang ada di langit smua dapa buka. ");
INSERT INTO pmy_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Trus hujan de turun tra stop-stop sampe hari ke-40. ");
INSERT INTO pmy_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Hari itu juga, Nuh deng de pu istri, sama de pu anana Sem, Yafet, deng Ham, sama dong pu istri masing-masing, dong smua masuk ke dalam kapal itu sama-sama. ");
INSERT INTO pmy_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Nuh dong sama-sama deng macam-macam binatang liar sama macam-macam binatang piara, macam-macam binatang mrayap di atas tana, macam-macam burung, deng smua binatang yang ada sayap. ");
INSERT INTO pmy_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Dari smua yang hidup, yang ada napas, dong datang satu-satu pasang ke Nuh di dalam kapal itu. ");
INSERT INTO pmy_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Satu pasang, jantan deng betina, dari smua yang hidup tu, dong smua masuk sperti yang Allah su suru ke Nuh. Habis smua masuk, TUHAN tutup kapal itu pu pintu. ");
INSERT INTO pmy_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Dalam 40 hari tu, banjir su mulai tamba besar di bumi. De pu air naik trus sampe angkat kapal itu. Bikin sampe kapal itu naik tinggi skali di atas bumi. ");
INSERT INTO pmy_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Waktu air su mulai tamba banyak baru de pu tinggi tu su dasyat skali, kapal ni de su trapung di atas air. ");
INSERT INTO pmy_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Air juga tinggal tamba tinggi trus sampe smua gunung-gunung tinggi su tenggelam juga. ");
INSERT INTO pmy_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Air tinggal naik trus sampe su tuju meter di atas gunung paling tinggi pu bagian paling atas. ");
INSERT INTO pmy_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Smua yang bergerak di bumi, burung-burung, binatang-binatang piara, binatang liar, smua binatang yang mrayap di atas tana, sama manusia smua, mati tasapu bersi. ");
INSERT INTO pmy_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Smua yang di darat, yang ada napas, smua mati. ");
INSERT INTO pmy_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Begitu suda, Allah sapu bersi smua yang ada, smua yang ada di bumi, mo itu manusia ka, binatang di darat ka, binatang yang mrayap ka, burung-burung yang terbang ka, smua tasapu bersi. Cuma Nuh deng smua yang sama-sama deng de dalam kapal itu yang tetap hidup. ");
INSERT INTO pmy_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Sampe su hari ke-150 juga, air de tra turun-turun. ");
INSERT INTO pmy_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Begini, Allah ingat Nuh deng smua binatang, yang ada sama-sama deng Nuh dalam kapal besar itu. Trus Allah kirim angin datang tiup, sampe air mulai turun. ");
INSERT INTO pmy_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Trus smua mata air yang ada dalam tana tatutup. Baru tempat-tempat air yang ada di langit juga tatutup. Itu yang, hujan lebat langsung brenti dari langit. ");
INSERT INTO pmy_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Trus air yang tutup bumi su mulai turun sdikit-sdikit. Jadi, habis 150 hari itu air su surut. ");
INSERT INTO pmy_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Pas bulan tuju, hari ke-17, kapal ni de su takandas di daera gunung-gunung yang de pu nama Ararat. ");
INSERT INTO pmy_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Air de tinggal turun trus sampe masuk bulan spulu juga de tetap turun trus. Pas di hari pertama, bulan spulu ini, gunung-gunung pu bagian paling atas su kliatan. ");
INSERT INTO pmy_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Waktu su lewat 40 hari begini, Nuh buka jendela yang de bikin di kapal itu, ");
INSERT INTO pmy_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","trus de kas lepas burung bangke satu. Burung ini de terbang bolak-balik sampe air su kring dari atas tana. ");
INSERT INTO pmy_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Habis itu, de kas lepas burung merpati satu untuk liat kalo air ni su surut dari atas tana ka blum. ");
INSERT INTO pmy_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Tapi waktu burung merpati de terbang, de tra ketemu tempat untuk hinggap gara-gara air masi tutup tana smua. Jadi, de pulang kembali ke Nuh di kapal situ. Nuh de kas kluar de pu tangan dari kapal situ baru de ambil burung trus bawa ke dalam kapal lagi. ");
INSERT INTO pmy_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Nuh de tunggu tuju hari lagi. Habis tuju hari, de lepas burung merpati itu lagi dari kapal itu. ");
INSERT INTO pmy_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Pas matahari su mulai masuk begini, burung merpati de pulang ke Nuh deng bawa daun pohon zaitun segar satu di de pu mulut. Dari situ, Nuh de su tau kalo air di atas bumi ni su surut betul-betul. ");
INSERT INTO pmy_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Dari waktu ini, Nuh de tunggu tuju hari lagi. Baru, de lepas burung merpati itu lagi. Tapi begini, burung merpati ni de tra kembali lagi ke Nuh. ");
INSERT INTO pmy_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Waktu Nuh pu umur 601 taun, di bulan pertama pu hari pertama, tana su kring. Trus, Nuh buka kapal de pu tutup atas untuk liat-liat. Begini de liat memang tana su kring. ");
INSERT INTO pmy_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Waktu bulan dua, hari ke-27, tana di bumi su kring betul-betul. ");
INSERT INTO pmy_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Trus Allah bicara ke Nuh, ");
INSERT INTO pmy_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Ko deng ko pu istri, sama ko pu anana deng dong pu istri-istri, kam smua kluar suda dari kapal. ");
INSERT INTO pmy_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Kam kluar deng smua binatang-binatang yang ada sama-sama deng kam juga. Smua yang hidup, mo burung-burung ka, binatang-binatang darat ka, binatang yang mrayap ka, bawa dong smua kluar deng ko. Supaya dong bisa tamba banyak trus tasebar di smua tempat di bumi.” ");
INSERT INTO pmy_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Habis itu, Nuh de kluar dari kapal itu sama-sama deng de pu istri, de pu anana deng dong pu istri-istri juga. ");
INSERT INTO pmy_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Smua binatang yang bergerak di bumi, dari binatang yang mrayap di atas tana sampe smua burung, deng dong pu jenis masing-masing, dong smua kluar dari kapal itu. ");
INSERT INTO pmy_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Habis dong smua kluar, Nuh de susun batu, bikin tempat bakar korban untuk TUHAN. Dari binatang-binatang yang tra pamali, trus dari burung-burung yang tra pamali, Nuh de ambil brapa-brapa trus de bakar kas korban untuk TUHAN di atas tempat bakar korban itu. ");
INSERT INTO pmy_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","TUHAN cium bau korban yang de bakar itu, De snang deng bau itu, trus TUHAN bilang ke De pu diri, “Sa trakan kutuk bumi lagi gara-gara manusia. Biar dari waktu de kecil, cuma ada hal jahat yang de pikir ato de bikin juga, Sa trakan kas sapu bersi smua yang pu hidup lagi, sperti yang Sa su bikin. ");
INSERT INTO pmy_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Jadi, sampe nanti bumi ini hilang, ini tetap ada: mo itu waktu tanam ato waktu panen, mo waktu dingin ato waktu panas, mo waktu musim hujan ato musim kring, mo waktu siang ato waktu malam, smua itu, tetap baku ganti-ganti trus.” ");
INSERT INTO pmy_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Habis itu, Allah kas berkat Nuh deng de pu anana, Allah bilang begini ke dorang, “Tamba banyak suda. Lahir anana deng cucu-cucu! Kas penu bumi ini! ");
INSERT INTO pmy_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Dari smua binatang yang ada di darat sampe smua burung-burung, dong smua nanti takut kam. Dari smua yang mrayap di tana sampe smua ikan di laut, Sa kasi dong smua ke dalam kam pu kuasa. ");
INSERT INTO pmy_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Smua binatang-binatang itu, kam su bole makan, sperti dulu Sa kasi kam tanaman untuk kam makan. ");
INSERT INTO pmy_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Tapi kam tra bole makan binatang yang de pu daging masi ada dara. Karna dara itu nyawa, de yang bikin binatang itu hidup. ");
INSERT INTO pmy_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Trus kalo orang pu nyawa hilang, mo itu karna binatang yang bunu ato manusia lain yang bunu, Sa yang nanti tuntut tanggung jawab dari dong. ");
INSERT INTO pmy_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Sapa saja yang ambil manusia pu nyawa, manusia lain nanti ambil de pu nyawa. Karna Sa bikin manusia sperti Sa, Allah. ");
INSERT INTO pmy_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Trus untuk kam, tamba banyak suda. Kas banyak kam pu anana cucu supaya dong bisa kas penu bumi ni smua. Iyo, kam tamba banyak trus kas penu bumi ini.” ");
INSERT INTO pmy_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Trus Allah bilang ke Nuh sama Nuh pu anana yang ada sama-sama deng de disitu, ");
INSERT INTO pmy_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Skarang, Sa mo ikat Sa pu janji deng ko, sama ko pu anana cucu. ");
INSERT INTO pmy_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Juga deng smua yang hidup yang ada sama-sama deng kam, dari burung-burung, binatang-binatang piara sama smua binatang liar, smua binatang yang kluar sama-sama deng ko dari kapal besar itu, Sa mo ikat janji deng kam. ");
INSERT INTO pmy_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Begini Sa pu janji: Mulai dari skarang, Sa trakan sapu bersi smua yang hidup di bumi ni deng banjir paling besar macam begini lagi. Trakan ada lagi banjir paling besar macam begini untuk kas hancur bumi. ” ");
INSERT INTO pmy_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Trus Allah bilang begini, “Ini yang jadi tanda dari Sa pu janji untuk kam sama smua yang ada hidup di bumi deng kam. Nanti janji ini tetap ada trus, janji ini nanti turun ke kam pu anana cucu deng dong pu anana cucu juga. ");
INSERT INTO pmy_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Sa su taru Sa pu busur di langit untuk jadi tanda dari Sa pu janji deng smua yang ada di bumi. ");
INSERT INTO pmy_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Kalo Sa kas datang awan hitam di atas bumi trus Sa pu busur, plangi tu, de muncul disitu, ");
INSERT INTO pmy_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","nanti Sa ingat janji yang Sa bikin deng kam, juga deng smua yang hidup di bumi ini. Janji kalo air trakan jadi banjir paling besar untuk sapu bersi smua yang hidup di bumi lagi. ");
INSERT INTO pmy_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Jadi, begitu busur itu muncul di awan, nanti Sa liat itu trus Sa ingat deng janji itu. Janji yang sampe nanti juga tetap ada, janji yang Sa, Allah, bikin deng manusia, juga deng smua yang hidup di bumi ini.” ");
INSERT INTO pmy_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Allah bilang Nuh begini, “Itu suda, tanda janji yang Sa bikin deng smua yang hidup di bumi.” ");
INSERT INTO pmy_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Nuh pu anana yang kluar sama-sama deng de dari kapal tu, dong pu nama Sem, Yafet, deng Ham. Ham ni Kanaan pu bapa. ");
INSERT INTO pmy_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Dong tiga ini suda Nuh pu anana. Dari dong tiga ini lahir smua orang yang tasebar ke mana-mana di bumi. ");
INSERT INTO pmy_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nuh itu orang yang biasa kerja kebun. De tu orang pertama yang bikin kebun anggur. ");
INSERT INTO pmy_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Satu kali begini, Nuh minum air anggur trus de mabuk, baru de lepas de pu pakean smua. Trus de tidur dalam de pu tenda tu tlanjang-tlanjang begitu. ");
INSERT INTO pmy_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Waktu Kanaan pu bapa Ham ni de masuk ke dalam tenda begini, de liat de pu bapa ada tlanjang, trus de pigi kastau de pu sodara dua yang ada di luar itu. ");
INSERT INTO pmy_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Tapi waktu dengar itu, Sem deng Yafet dong dua ambil kain besar satu. Dong buka kain itu trus taru di dong dua pu bahu baru dong jalan mundur masuk ke dalam tenda, trus tutup dong pu bapa yang ada tlanjang itu. Dong dua pu muka hadap blakang deng Nuh supaya dong tra liat dong pu bapa pu badan tlanjang itu. ");
INSERT INTO pmy_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Skarang begini, pas Nuh de sadar dari de pu mabuk, de dengar yang de pu anak bungsu su bikin ke dia, ");
INSERT INTO pmy_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","trus de bilang begini, “Kanaan, biar kutuk ini turun ke dia: de nanti jadi budak untuk de pu sodara-sodara lain, de jadi budak yang paling hina.” ");
INSERT INTO pmy_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Baru Nuh de tamba, “Puji TUHAN, Allah yang Sem semba! Kanaan, biar de nanti jadi Sem pu budak. ");
INSERT INTO pmy_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Sa minta Allah kas tamba banyak Yafet pu tana, biar de pu anana cucu bisa tinggal tenang sama-sama deng Sem pu anana cucu. Tapi Kanaan de nanti jadi Yafet de pu budak.” ");
INSERT INTO pmy_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Nuh de masi hidup 350 taun stela banjir paling besar itu. ");
INSERT INTO pmy_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Jadi, Nuh de pu umur su sampe 950 taun baru de mninggal. ");
INSERT INTO pmy_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Ini daftar anana cucu dari Sem, Yafet deng Ham, Nuh pu anana. Slesai banjir paling besar itu dong tiga pu anana lahir. ");
INSERT INTO pmy_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yafet pu anana tu Gomer, Magog, Madai, Yawan, Tubal, Mesek, deng Tiras. ");
INSERT INTO pmy_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomer pu anana cucu tu orang Askenas, orang Rifat, deng orang Togarma. ");
INSERT INTO pmy_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Kalo Yawan pu anana cucu tu yang orang Elisa, orang Tarsis, orang Kitim, deng orang Dodanim dorang. ");
INSERT INTO pmy_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Dari dorang-dorang ini yang orang-orang pante mulai tasebar. Ini suda, Yafet pu anana cucu. Masing-masing deng dong pu bahasa, tana, bangsa, deng dong pu kluarga besar. ");
INSERT INTO pmy_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ham pu anana tu Kus, Mesir, Put, deng Kanaan. ");
INSERT INTO pmy_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kus pu anana cucu tu orang Seba, orang Hawila, orang Sabta, orang Raema, deng orang Sabteka. Kalo Raema pu anana cucu tu orang Syeba deng orang Dedan. ");
INSERT INTO pmy_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kus juga pu anak yang nama Nimrod. Nimrod de tu orang pertama yang pegang kuasa untuk printa di bumi ini. ");
INSERT INTO pmy_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","TUHAN bikin de jadi orang yang paling jago buru skali. Itu yang, dulu orang dong biasa bilang begini, “TUHAN bikin ko jago buru macam Nimrod.” ");
INSERT INTO pmy_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nimrod de jadi raja yang pimpin tana Babel, tana Erek, deng tana Akad. Kota ini smua ada di tana Sinear. ");
INSERT INTO pmy_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Dari tana ini de pigi ke tana Asyur, trus bikin kota Niniwe, kota Rehobot-Ir, kota Kala, ");
INSERT INTO pmy_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","deng kota Resen. Kota Resen ni kota besar yang ada di tenga-tenga kota Niniwe deng kota Kala. ");
INSERT INTO pmy_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Kalo Mesir pu anana tu moyang-moyang dari orang Ludim, orang Anamim, orang Lehabim, orang Naftuhim, ");
INSERT INTO pmy_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","orang Patrusim, orang Kasluhim, deng orang Kaftorim dorang. Dari orang Kasluhim ini yang, orang Filistin dong lahir. ");
INSERT INTO pmy_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaan pu anana tu Sidon, yang tua, deng Het. ");
INSERT INTO pmy_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Baru Kanaan pu anana cucu tu orang Yebus, orang Amori, orang Girgasi, ");
INSERT INTO pmy_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","orang Hewi, orang Arki, orang Sini, ");
INSERT INTO pmy_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","orang Arwadi, orang Semari, deng orang Hamati. Orang-orang Kanaan ini dong nanti tasebar di mana-mana. ");
INSERT INTO pmy_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Orang Kanaan pu tana tu dari batas kota Sidon ke ara-ara kota Gerar, sampe ke batas kota Gaza, trus ke ara kota Sodom, kota Gomora, kota Adma, deng kota Zeboim sampe batas kota Lasa. ");
INSERT INTO pmy_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ini suda, Ham pu anana cucu. Masing-masing deng dong pu bahasa, tana, bangsa, deng dong pu kluarga besar. ");
INSERT INTO pmy_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Yafet pu kaka Sem, de juga pu anana, dong ini yang jadi orang Eber dong pu moyang. ");
INSERT INTO pmy_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sem pu anana juga: Elam, Asyur, Arpaksad, Lud, deng Aram. ");
INSERT INTO pmy_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aram pu anana cucu itu orang Us, orang Hul, orang Geter, deng orang Mas. ");
INSERT INTO pmy_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpaksad pu anak tu Sela. Sela pu anak tu Eber. ");
INSERT INTO pmy_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber pu anak dua juga lahir, yang satu nama Peleg, karna waktu de hidup itu bumi su tabagi-bagi. Eber pu anak yang satu lagi nama Yoktan. ");
INSERT INTO pmy_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yoktan pu anana cucu tu orang Almodad, orang Selef, orang Hazar-Mawet, orang Yera, ");
INSERT INTO pmy_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","orang Hadoram, orang Uzal, orang Dikla, ");
INSERT INTO pmy_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","orang Obal, orang Abimael, orang Syeba, ");
INSERT INTO pmy_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","orang Ofir, orang Hawila, deng orang Yobab. Smua itu suda, Yoktan pu anana cucu. ");
INSERT INTO pmy_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Dong pu tana tu mulai dari daera Mesa sampe batas daera Sefar, daera gunung-gunung di bagian timur. ");
INSERT INTO pmy_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Itu suda, Sem pu anana cucu dorang. Masing-masing deng dong pu bahasa, tana, bangsa, deng dong pu kluarga besar. ");
INSERT INTO pmy_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Ini suda, Nuh pu anana cucu deng dong pu kluarga besar. Habis banjir besar itu, dari dong ini suda asal smua bangsa-bangsa yang ada tasebar di dunia ini. ");
INSERT INTO pmy_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Dulu orang smua bicara pake satu bahasa yang sama. ");
INSERT INTO pmy_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Waktu dong jalan ke timur, dong ketemu tana yang rata di daera yang nama Sinear, trus dong tinggal disitu. ");
INSERT INTO pmy_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Satu kali begini, yang satu bilang ke yang lain, “Ayo, tong buat batu bata dari tana liat, trus tong bakar sampe kras.” Batu bata itu yang dong pake ganti batu, trus dong pake aspal cair untuk kas lengket batu bata itu. ");
INSERT INTO pmy_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Trus dong bilang juga, “Mari tong bangun kota satu deng de pu bangunan tinggi sampe ke langit. Supaya tong dapa knal, trus jang tong tapisa-pisa ke sluru bumi.” ");
INSERT INTO pmy_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Begini, TUHAN turun liat kota deng bangunan tinggi yang orang-orang dong bangun itu. ");
INSERT INTO pmy_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Baru TUHAN bilang begini, “Dong smua ni satu bangsa yang pu bahasa satu saja. Apa yang dong bikin skarang ni, itu baru langka pertama saja. Apa lagi nanti, dong bisa bikin apa saja yang dong mau. ");
INSERT INTO pmy_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Mari Tong turun bikin dong bingung deng dong pu bahasa, supaya dong tra baku mngerti bahasa satu sama yang lain.” ");
INSERT INTO pmy_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Jadi begitu suda, TUHAN bikin sampe dong tapisa-pisa ke sluru bumi. Karna itu dong stop bangun kota. ");
INSERT INTO pmy_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Itu yang knapa kota itu pu nama Babel, karna disitu TUHAN bikin sluru bumi babingung deng dong pu bahasa, trus dari situ TUHAN kas pisa-pisa dong ke sluru bumi. ");
INSERT INTO pmy_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ini daftar anana cucu dari Sem. Pas su lewat dua taun dari waktu banjir paling besar tu, waktu Sem pu umur 100 taun, de pu anak Arpaksad lahir. ");
INSERT INTO pmy_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Sem masi hidup 500 taun lagi habis de pu anak Arpaksad ni lahir. De juga ada anana laki-laki deng anana prempuan yang lain. ");
INSERT INTO pmy_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Waktu Arpaksad pu umur su 35 taun, de pu anak Sela lahir. ");
INSERT INTO pmy_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Arpaksad de masi hidup 403 taun lagi, habis de pu anak Sela lahir. De juga ada anana laki-laki deng anana prempuan yang lain. ");
INSERT INTO pmy_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Waktu Sela pu umur su 30 taun, de pu anak Eber lahir. ");
INSERT INTO pmy_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Sela de masi hidup 403 taun lagi, habis de pu anak Eber lahir. De juga ada anana laki-laki deng anana prempuan yang lain. ");
INSERT INTO pmy_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Waktu Eber pu umur su 34 taun, de pu anak Peleg lahir. ");
INSERT INTO pmy_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Eber masi hidup 430 taun lagi, habis de pu anak Peleg lahir. De juga ada anana laki-laki deng anana prempuan yang lain. ");
INSERT INTO pmy_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Waktu Peleg pu umur su 30 taun, de pu anak Rehu lahir. ");
INSERT INTO pmy_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Peleg masi hidup 209 taun lagi, habis de pu anak Rehu lahir. De juga ada anana laki-laki deng anana prempuan yang lain. ");
INSERT INTO pmy_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Waktu Rehu pu umur su 32 taun, de pu anak Serug lahir. ");
INSERT INTO pmy_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Habis Serug lahir, Rehu masi hidup 207 taun lagi. De juga ada anana laki-laki deng anana prempuan yang lain. ");
INSERT INTO pmy_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Waktu Serug pu umur su 30 taun, de pu anak Nahor lahir. ");
INSERT INTO pmy_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Serug masi hidup 200 taun lagi, habis de pu anak Nahor lahir. De juga ada anana laki-laki deng anana prempuan yang lain. ");
INSERT INTO pmy_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Waktu Nahor pu umur su 29 taun, de pu anak Terah lahir. ");
INSERT INTO pmy_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Nahor masi hidup 119 taun lagi, habis de pu anak Terah lahir. De juga ada anana laki-laki deng anana prempuan yang lain. ");
INSERT INTO pmy_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Waktu Terah pu umur su 70 taun, de pu anak tiga lahir. De pu anana tu Abram, Nahor, deng Haran. ");
INSERT INTO pmy_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Ini crita tentang Terah pu anana cucu. Terah pu anana tu Abram, Nahor, deng Haran. Haran de pu anak laki-laki nama Lot. ");
INSERT INTO pmy_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Trus waktu Terah de masi hidup, de pu anak Haran mninggal di kota Ur di tana Babilonia, kota tempat dong lahir itu. ");
INSERT INTO pmy_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram de kawin deng prempuan satu yang nama Sarai, trus Nahor kawin deng prempuan yang nama Milka. Milka ni Haran pu anak prempuan. Haran juga pu anak prempuan lain yang pu nama Yiska. ");
INSERT INTO pmy_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai ni de mandul, de trada anak. ");
INSERT INTO pmy_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Satu kali begini, Terah de bawa de pu anak Abram deng Abram pu istri Sarai, sama de pu cucu Lot, Haran pu anak ini. Dong sama-sama pigi kas tinggal kota Ur yang di tana Babilonia tu, trus dong mo pigi ke tana Kanaan. Tapi pas waktu dong sampe di kota satu yang de nama tu Haran, dong stop trus tinggal disitu. ");
INSERT INTO pmy_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Di kota Haran ni Terah de mninggal. Terah pu umur su masuk 205 taun waktu de mninggal. ");
INSERT INTO pmy_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Begini TUHAN bicara ke Abram, “Abram, kluar kas tinggal ko pu tana deng ko pu kluarga besar, kluar dari ko pu bapa pu ruma! Ko pigi ke tana yang nanti Sa kas tunjuk ke ko. ");
INSERT INTO pmy_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Nanti Sa bikin ko pu anana cucu banyak sampe dong jadi bangsa yang besar. Sa nanti kas berkat ko. Nanti Sa bikin sampe smua orang tau ko pu nama, sampe ko nanti jadi berkat untuk orang lain. ");
INSERT INTO pmy_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Nanti Sa kas berkat orang-orang yang kas berkat ko. Trus kalo ada sapa saja yang kutuk ko, nanti Sa kutuk dia. Lewat ko, nanti Sa kas berkat smua kluarga di dunia ini.” ");
INSERT INTO pmy_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Jadi suda, Abram de pigi, de bikin sperti yang TUHAN bilang ke dia. Lot juga ada ikut sama-sama deng Abram waktu itu. Abram de pu umur su masuk 75 taun waktu de pigi dari kota Haran. ");
INSERT INTO pmy_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abram de bawa de pu istri Sarai sama dong pu barang-barang deng dong pu budak-budak smua yang dong dapat di kota Haran. Abram pu ade laki-laki pu anak laki-laki yang nama Lot ni, Abram bawa ikut dong juga. Dong smua jalan pigi sampe ke tana Kanaan. ");
INSERT INTO pmy_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram dong jalan di tana itu sampe ke tempat satu yang ada pohon besar skali. Tempat itu di More, dekat kota Sikem. Waktu itu, orang-orang Kanaan dong masi tinggal disitu. ");
INSERT INTO pmy_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Waktu itu, TUHAN datang kas tunjuk De pu diri sama Abram, baru bilang, “Nanti Sa kasi tana ini sama ko pu anana cucu.” Jadi, Abram de susun batu trus bikin tempat bakar korban satu untuk TUHAN yang su kas tunjuk De pu diri sama Abram dia. ");
INSERT INTO pmy_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Dari tempat yang de tinggal tu, Abram de pinda ke gunung-gunung yang di sebla timur kota Betel baru de pasang de pu tenda disitu. Tenda pu sebla barat tu, kota Betel, baru kota Ai ada di de pu sebla timur. Disitu, Abram de susun batu lagi trus bikin tempat bakar korban untuk TUHAN baru de semba TUHAN. ");
INSERT INTO pmy_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Habis itu Abram dong jalan dari satu tempat ke tempat satu lagi, trus-trus sampe di bagian slatan tana Kanaan situ, di daera Negeb. ");
INSERT INTO pmy_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Satu kali begini, tana Kanaan yang Abram dong tinggal tu kena klaparan yang para sampe trada makanan lagi. Gara-gara itu, Abram dong pigi tinggal jadi pendatang di Mesir. ");
INSERT INTO pmy_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Pas waktu dong baru mo masuk ke tana Mesir, Abram de bilang ke de pu istri Sarai begini, “Sarai, ko dengar. Sa tau skali kalo ko ni memang cantik skali. ");
INSERT INTO pmy_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Kalo orang-orang Mesir dong liat ko, nanti dong bilang, ‘Itu pasti de pu istri.’ Itu yang, nanti bikin dong bunu sa baru kas biar ko hidup. ");
INSERT INTO pmy_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Jadi, ko bilang ke dorang kalo ko tu sa pu ade prempuan. Supaya dong buat baik sama sa karna ko, trus kas tinggal sa hidup.” ");
INSERT INTO pmy_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Waktu Abram dong su masuk ke tana Mesir, orang-orang Mesir dong liat Abram pu istri ni cantik skali. ");
INSERT INTO pmy_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Trus pas raja Mesir pu kepala-kepala pemrinta ni dong liat Sarai, dong tinggal bicara-bicara tentang Sarai pu cantik tu di depan raja dia. Jadi, raja suru bawa Sarai ke de pu istana. ");
INSERT INTO pmy_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Raja de bikin baik skali sama Abram karna de mau deng Sarai. Itu yang, raja de kasi Abram budak-budak laki-laki deng prempuan, kambing domba, sapi, kledai, deng unta-unta. ");
INSERT INTO pmy_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Tapi TUHAN hukum raja Mesir deng de pu satu istana, dong kena penyakit-penyakit para, karna Abram pu istri Sarai. ");
INSERT INTO pmy_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Langsung raja Mesir panggil Abram baru bilang, “Knapa ko tipu saya? Knapa ko tra kastau sa kalo de ni ko pu istri? ");
INSERT INTO pmy_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Baru knapa ko bilang kalo de ni ko pu ade prempuan? Bikin sampe sa ambil de jadi sa pu istri lagi? Ini! Ambil ko pu istri! Ambil de trus kam dua pigi dari sini!” ");
INSERT INTO pmy_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Baru raja Mesir suru orang-orang brapa untuk bawa kluar Abram sama de pu istri tamba deng dong pu barang-barang smua. ");
INSERT INTO pmy_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Waktu Abram de kluar dari Mesir, de kembali ke daera Negeb sama-sama deng de pu istri, lapis deng smua yang de punya, deng Lot juga. Lot ini anak dari Abram pu sodara laki-laki. ");
INSERT INTO pmy_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram de paling kaya skali. De pu binatang-binatang piara, de pu emas deng de pu perak tu paling banyak skali. ");
INSERT INTO pmy_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Abram dong jalan dari tana Negeb ke tempat satu lagi, begitu trus sampe dekat kota Betel, pas di tenga-tenga kota Betel deng kota Ai. Ini tempat yang pertama skali de bikin tenda dulu. ");
INSERT INTO pmy_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Tempat ini yang dulu de perna bikin tempat bakar korban. Di tempat ini, Abram de semba TUHAN. ");
INSERT INTO pmy_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot yang ada ikut sama-sama deng Abram dorang ni, de juga ada bawa de pu kluarga deng de pu orang-orang kerja, kambing domba, sama de pu sapi-sapi. ");
INSERT INTO pmy_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Tapi tana tempat dong tinggal ni tra bisa tanggung dong smua. Abram deng de pu sodara pu anak ni, dong dua pu binatang-binatang piara paling banyak skali. Itu yang bikin sampe, tana tempat dong tinggal ni tra bisa tampung dong dua sama-sama. ");
INSERT INTO pmy_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Gara-gara itu juga yang, Abram pu orang-orang yang jaga de pu binatang piara ni, dong mulai baku ribut deng Lot pu orang-orang yang jaga de pu binatang piara. Baru pas waktu itu, orang Kanaan deng orang-orang Feris dong masi tinggal di tana situ juga. ");
INSERT INTO pmy_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Jadi suda, satu kali begini Abram de pigi bicara ke Lot begini, “Kitong dua ni sodara jadi, lebi baik tong tra baku ribut begini. Sa deng ko, sama sa pu orang-orang yang jaga kambing domba deng ko pu orang-orang yang jaga kambing domba juga, tra bole baku ribut. ");
INSERT INTO pmy_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Skarang ko liat, tana ni besar to? Daripada tong begini, lebi baik tong dua bagi jalan. Kalo ko ke kiri, sa ke kanan. Kalo ko ke kanan, sa ke kiri.” ");
INSERT INTO pmy_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Suda, Lot de buang mata trus de liat kliling. Pas di daera tana renda di daera kali Yordan sampe ke kota Zoar tu, de liat tempat itu smua ada air banyak, kliatan macam TUHAN pu taman Eden begitu, hampir sama deng tana Mesir. Ini waktu TUHAN blum kas hancur kota Sodom deng Gomora rata deng tana. ");
INSERT INTO pmy_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Dari situ dong dua pisa. Lot de pili tana renda di daera kali Yordan tu smua. Jadi Lot de brangkat ke ara timur. ");
INSERT INTO pmy_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","De pigi tinggal dekat kota-kota di bagian tana renda di daera Yordan. De bikin tenda disana, di dekat kota Sodom. Tapi Abram de tinggal di tana Kanaan tetap. ");
INSERT INTO pmy_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Waktu itu, orang di kota Sodom dong paling jahat trus dong pu dosa ke TUHAN su terlalu banyak skali. ");
INSERT INTO pmy_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Waktu Lot su kas tinggal tempat itu, TUHAN bicara lagi ke Abram. TUHAN bilang, “Dari tempat yang ko ada bediri ni, ko liat kliling skarang, liat baik-baik ke ara timur, barat, utara deng slatan! ");
INSERT INTO pmy_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Tana smua yang ko ada liat itu, nanti Sa kasi tana itu ke ko deng ko pu anana cucu. Sampe nanti, tana ini tetap dong punya. ");
INSERT INTO pmy_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Juga nanti Sa bikin ko pu anana cucu jadi banyak skali. Dong pu banyak tu macam debu tana pu banyak, tra bisa hitung dong pu banyak. ");
INSERT INTO pmy_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Skarang, ko siap-siap! Jalan pigi cek trus liat tana ini de pu panjang deng lebar, karna tana ini Sa nanti kasi ke ko.” ");
INSERT INTO pmy_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Suda, habis itu Abram de kas rapi de pu tenda trus de pinda ke Hebron. Trus de kas bediri de pu tenda dekat pohon-pohon besar skali yang di daera Mamre. Baru, Abram de susun batu untuk bikin tempat bakar korban untuk TUHAN disitu. ");
INSERT INTO pmy_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Pas waktu itu, orang Babilonia pu raja Amrafel, orang Elasar pu raja Ariok, orang Elam pu raja Kedorlaomer, deng orang Goyim pu raja Tideal, ");
INSERT INTO pmy_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","dong ada mo baku prang lawan kota Sodom pu raja Bera, kota Gomora pu raja Birsya, kota Adma pu raja Syinab, kota Zeboim pu raja Syemeber, gabung deng kota Bela pu raja. Kota Bela tu kota Zoar suda. ");
INSERT INTO pmy_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Jadi, lima raja ni dong gabung sama-sama di bagian tana renda di Sidim, di daera Laut Mati. ");
INSERT INTO pmy_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Dong su 12 taun dapa injak-injak sama raja Kedorlaomer jadi, pas taun ke-13, lima raja ini dong balik lawan. ");
INSERT INTO pmy_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Di taun ke-14, raja Kedorlaomer deng raja-raja yang sama-sama deng dia, dong gabung untuk mo baku lawan deng raja lima itu. Dong mulai deng kas kala orang-orang dari suku-suku lain dulu. Mulai dari orang-orang Refaim di daera Asterot-Karnaim, orang-orang Zuzim di daera Ham, deng orang-orang Emim di daera Syawe-Kiryataim. ");
INSERT INTO pmy_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Trus dong kas kala orang-orang Hori yang di gunung-gunung Seir tu, dong kejar sampe ke daera El-Paran pas di batas tempat sepi yang kring. ");
INSERT INTO pmy_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Habis dari situ, dong balik ke daera En-Mispat, yang orang lebi knal deng nama Kades. Trus raja-raja itu dong kas kala orang Amalek trus ambil dong pu daera smua. Dong juga kas kala orang Amori yang tinggal di daera Hazezon-Tamar. ");
INSERT INTO pmy_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","9","Habis empat raja ini dong kas kala orang-orang smua tu, dong siap-siap pigi baku lawan deng lima raja yang ada gabung di daera tana renda di Sidim. Dong mo pigi kas kala lima raja itu. Jadi, kota Sodom, kota Gomora, kota Adma, kota Zeboim, deng kota Bela yang pu nama lain Zoar ni, dong pu raja-raja atur barisan pigi prang lawan orang Elam pu raja Kedorlaomer, orang Goyim pu raja Tideal, orang Babilonia pu raja Amrafel, deng orang Elasar pu raja Ariok. Jadi, ada empat raja lawan lima raja. ");
INSERT INTO pmy_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Di daera tana renda di Sidim ni, ada sumur aspal banyak disitu. Jadi, pas waktu kota Sodom pu raja deng kota Gomora pu raja dong mo lari dari prang, ada yang jatu ke dalam situ. Orang-orang lain yang masi hidup tu, dong lari pigi ke daera gunung-gunung. ");
INSERT INTO pmy_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Kota Sodom deng kota Gomora pu barang-barang smua deng makanan-makanan juga, dong pu lawan ambil smua, trus bawa pigi. ");
INSERT INTO pmy_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Waktu itu, Lot yang Abram pu sodara pu anak tu dapa bawa juga. Lot pu barang-barang smua juga dong bawa pigi. Itu gara-gara Lot dong waktu itu tinggal di kota Sodom. ");
INSERT INTO pmy_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Begini, ada orang satu yang slamat. De lari trus pigi crita yang jadi tu sama Abram, orang Ibrani itu. Waktu itu, Abram de tinggal di tenda dekat pohon-pohon besar yang di Mamre pu tempat itu. Mamre itu orang Amori, de pu sodara Eskol deng Aner. Dong tiga deng Abram su baku janji untuk baku bantu waktu ada prang nanti. ");
INSERT INTO pmy_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Waktu Abram dengar kalo de pu sodara pu anak ada dapa tahan, Abram de kas kumpul de pu orang-orang yang memang su dapa kas siap untuk prang. De pu orang-orang ni yang memang lahir besar di de pu ruma. Dong pu banyak tu ada 318 orang. Dong kejar dong pu lawan ni sampe ke daera tana Dan. ");
INSERT INTO pmy_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Pas malam yang dong mo mulai srang, Abram bagi-bagi de pu orang-orang jadi brapa klompok, trus dong maju srang dong pu lawan dari smua ara. Abram dong kas kala, trus dong kejar dong pu lawan tu sampe ke daera Hoba di kota Damsik pu sebla utara. ");
INSERT INTO pmy_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Baru, Abram de bawa kembali smua barang-barang yang de pu lawan bawa itu. Abram juga bawa de pu sodara pu anak Lot ni deng Lot de pu barang-barang smua juga. Prempuan-prempuan deng orang-orang lain yang dapa tahan juga tu, Abram bawa kembali. ");
INSERT INTO pmy_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Stela Abram de kas kala Kedorlaomer deng raja-raja yang sama-sama deng Kedorlaomer itu, Abram de kembali. Trus, kota Sodom pu raja kluar sambut dia, di daera tana renda Syawe. Ini tempat yang dong biasa bilang ʻRaja pu Tana Renda.ʼ ");
INSERT INTO pmy_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Waktu itu, Melkisedek yang jadi raja tana Salem ni, de juga datang bawa roti deng minuman anggur. De ni juga imam dari Allah Yang Paling Besar. ");
INSERT INTO pmy_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","De datang trus de kas berkat Abram. De bilang begini, “Sa minta Allah Yang Paling Besar, yang bikin langit deng bumi, kas berkat Abram. ");
INSERT INTO pmy_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Puji Allah Yang Paling Besar! Karna Allah su kasi ko pu lawan-lawan ke ko, supaya ko kas kala dorang.” Baru, Abram de kasi seperspulu dari smua barang yang de ada bawa tu. ");
INSERT INTO pmy_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Habis itu, kota Sodom pu raja bilang ke Abram begini, “Abram, barang-barang yang ko ada bawa kembali tu, ko bisa ambil. Tapi, sa pu orang-orang yang ko ada bawa pulang tu, mari! Kas kembali ke sa suda.” ");
INSERT INTO pmy_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Tapi Abram bilang ke Sodom pu raja itu begini, “Sa su sumpa pake nama TUHAN, Allah Yang Paling Besar yang bikin langit deng bumi, begini, ");
INSERT INTO pmy_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","‘Sa trakan ambil apapa dari yang ko punya ini. Biar mo benang ato sendal pu tali juga, sa trakan ambil.’ Itu supaya, jang sampe nanti ko bilang kalo ko yang bikin Abram jadi kaya lagi. ");
INSERT INTO pmy_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Kalo sa, sa trakan ambil apapa! Hanya yang sa pu orang-orang dong su makan itu, deng Aner, Eskol, sama Mamre dong yang pigi ikut sa prang, biar dong saja yang ambil dong pu bagian masing-masing.” ");
INSERT INTO pmy_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Su lewat brapa waktu begini, TUHAN datang bicara sama Abram sperti mimpi. TUHAN bicara ke de begini, “Abram, ko jang takut! Sa yang jaga ko dari musu. Nanti ko dapat bagian yang besar.” ");
INSERT INTO pmy_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Tapi Abram jawab begini, “TUHAN Allah, Tuhan mo kasi sa apa lagi? Sa ni trada anak. Baru nanti sa mninggal, yang dapat sa pu barang-barang smua tu Eliezer mo, yang dari Damsik itu.” ");
INSERT INTO pmy_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Trus Abram de bilang lagi, “TUHAN tra kasi sa anak. Baru waktu sa mninggal, sa pu orang kerja ini, de yang nanti dapat sa pu barang-barang smua ini.” ");
INSERT INTO pmy_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Begini Abram dengar TUHAN bilang de lagi, “Bukan ko pu orang kerja yang nanti dapat ko pu harta smua, tapi ko pu anak laki-laki sendiri.” ");
INSERT INTO pmy_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Trus TUHAN bawa Abram kluar baru bilang ke de begini, “Abram, ko liat ke langit! Skarang, kalo ko bisa, coba ko hitung bintang-bintang itu!” TUHAN tamba lagi, “Nanti ko pu anana cucu pu banyak sama macam begitu.” ");
INSERT INTO pmy_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Waktu itu, Abram de percaya yang TUHAN bilang. Itu jadi, TUHAN liat de tu orang yang benar karna de pu percaya ini. ");
INSERT INTO pmy_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","TUHAN bilang lagi ke Abram, “Sa ini TUHAN yang bawa ko kluar dari kota Ur di tana Babilonia, supaya Sa kasi tana Kanaan ni untuk jadi ko pu milik.” ");
INSERT INTO pmy_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Tapi Abram de tanya, “TUHAN Allah, bagemana sa tau kalo tana ini nanti jadi sa pu milik?” ");
INSERT INTO pmy_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","TUHAN jawab dia, “Ko pigi ambil untuk Sa, sapi betina satu, kambing betina satu, deng domba jantan satu. Dong masing-masing yang umur tiga taun. Trus ambil juga burung merpati puti deng merpati hitam yang masi muda satu-satu.” ");
INSERT INTO pmy_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abram de ambil smua yang TUHAN suru de itu. De bla, bagi tenga binatang-binatang ni jadi dua bagian. Baru, de taru yang de su potong tu, baku sebla-sebla dalam satu baris. Tapi untuk yang burung de tra bla jadi dua. ");
INSERT INTO pmy_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Pas burung-burung yang biasa makan bangke ni datang hinggap di daging-daging yang Abram taru itu, tapi Abram usir. ");
INSERT INTO pmy_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Waktu pas matahari su mo masuk begini, Abram tatidur sono. Begini, glap yang tra baik punya, turun tutup dia sampe de rasa takut. ");
INSERT INTO pmy_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Baru TUHAN bilang ke Abram begini, “Abram, ko dengar baik-baik ini! Ko pu anana cucu nanti jadi orang pendatang di tana satu, tana yang bukan dong punya. Nanti dong jadi budak, trus dong tinggal dapa injak-injak trus sampe 400 taun. ");
INSERT INTO pmy_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Tapi bangsa yang bikin dong jadi budak ini nanti dapa hukum dari Saya. Habis itu, nanti dong kluar deng bawa banyak barang-barang. ");
INSERT INTO pmy_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Tapi untuk ko, ko nanti hidup sampe ko su masuk umur yang tua baru ko gabung deng ko pu moyang dong yang su duluan. Nanti ko mninggal deng tenang trus ko dapa kubur waktu ko pu rambut su puti. ");
INSERT INTO pmy_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Habis ko pu turunan keempat dong pu jaman su lewat, ko pu anana cucu yang di jaman itu, nanti dong kembali ke tana ini, trus ambil tana ini dari orang Amori. Karna, di waktu itu baru orang Amori dong pu dosa su cukup untuk dapa hukum, skarang masi blum.” ");
INSERT INTO pmy_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Pas matahari su masuk baru su glap, kaget begini blanga yang isi bara deng asap-asap tu muncul deng obor yang mnyala besar skali. Blanga deng obor tu muncul, baru jalan dari tenga-tenga daging yang Abram su atur itu. ");
INSERT INTO pmy_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Waktu itu juga, TUHAN ikat janji deng Abram. TUHAN bilang, “Sa janji, nanti Sa kasi tana ini smua untuk ko pu anana cucu dorang. Tana yang pu luas dari sungai di Mesir sampe di sungai besar Efrat ini. ");
INSERT INTO pmy_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Tana yang dari orang Keni, orang Kenas, orang Kadmon, ");
INSERT INTO pmy_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","orang Het, orang Feris, orang Refaim, ");
INSERT INTO pmy_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","orang Amori, orang Kanaan, orang Girgasi, deng orang Yebus dorang.” ");
INSERT INTO pmy_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Skarang begini, Abram pu istri Sarai de trada anak. Tapi, Sarai de ada budak satu, prempuan Mesir yang de pu nama Hagar. ");
INSERT INTO pmy_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Jadi, Sarai de bilang ke Abram begini, “Abram, ko dengar, TUHAN De tra kas ijin sa untuk lahir anak. Jadi, ko pigi tidur deng sa pu budak prempuan itu eh. Mungkin sa bisa dapat anak lewat dia ka.” Abram de stuju yang Sarai bilang itu. ");
INSERT INTO pmy_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Jadi Abram pu istri Sarai ni, de bawa de pu budak orang Mesir yang nama Hagar tu ke de pu suami Abram, supaya de kawin deng de pu suami Abram. Ini smua jadi waktu Abram su tinggal spulu taun di tana Kanaan situ. ");
INSERT INTO pmy_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abram de pigi tidur deng Hagar. Trus Hagar de hamil. Waktu Hagar de tau kalo de hamil, de jadi sombong baru de anggap reme de pu nyonya Sarai. ");
INSERT INTO pmy_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Trus Sarai bilang ke Abram, “Sa su kasi sa pu budak prempuan ke ko, tapi waktu de tau kalo de hamil dari ko, de anggap reme saya. Ini gara-gara ko! Skarang, biar TUHAN yang kas tunjuk sapa yang bikin sala, sa ka ko.” ");
INSERT INTO pmy_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Tapi Abram de jawab Sarai, “Sarai, de tu ko pu budak! Ko yang pu kuasa untuk suru-suru Hagar dia. Bikin sama dia apa saja yang ko pikir ko harus bikin.” Suda, Sarai de bikin tra baik ke de pu budak Hagar itu. Itu yang, Hagar de lari dari Sarai. ");
INSERT INTO pmy_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Begini, TUHAN pu Malaikat datang ketemu Hagar dekat mata air satu di tempat sepi yang kring, yang di jalan ke ara-ara daera Syur. ");
INSERT INTO pmy_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Trus Malaikat itu bilang begini, “Hagar, ko yang jadi Sarai pu budak, ko dari mana trus mo kemana?” De jawab, “Sa lari dari sa pu nyonya Sarai.” ");
INSERT INTO pmy_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Trus TUHAN pu Malaikat tu bilang lagi ke dia, “Ko kembali ke ko pu nyonya. Smua yang de suru ko, ko ikut.” ");
INSERT INTO pmy_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Trus TUHAN pu Malaikat de bilang lagi, “Sa nanti bikin ko pu anana cucu jadi banyak skali, sampe mo hitung saja, su trakan sanggup.” ");
INSERT INTO pmy_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","TUHAN pu Malaikat lanjut lagi bilang, “Skarang ko ada hamil. Nanti ko lahir anak laki-laki satu. Ko harus kas nama de Ismael. De pu nama Ismael karna TUHAN su dengar ko pu susa. ");
INSERT INTO pmy_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Nanti ko pu anak laki-laki satu ni de pu hidup sama macam kledai liar, trada yang bisa atur dia. De nanti tinggal baku lawan deng orang-orang trus, baru orang-orang juga lawan dia. De tinggal baku musu deng de pu sodara dorang.” ");
INSERT INTO pmy_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Hagar de kasi nama sama TUHAN yang ada bicara deng de tu begini, “Memang betul, Ko itu El-Roi! Karna di tempat ini sa su liat Allah yang ada jaga liat saya.” ");
INSERT INTO pmy_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Dari situ yang, orang kas nama sumur itu, ʻsumur dari Lahai-Roi.ʼ Sumur ini ada di tenga-tenga Kades deng daera Bered. ");
INSERT INTO pmy_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Trus Hagar de lahir anak laki-laki satu untuk Abram. Abram kas nama anak yang Hagar de lahir tu Ismael. ");
INSERT INTO pmy_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abram pu umur su 86 taun, waktu Hagar de lahir Ismael untuk dia. ");
INSERT INTO pmy_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Waktu Abram pu umur 99 taun, TUHAN kas tunjuk Diri ke de lagi trus bilang begini, “Sa ini Allah Yang Pu Kuasa Paling Besar. Ko pu hidup harus ikut yang Sa mau, trus tetap setia deng Saya. ");
INSERT INTO pmy_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Trus Sa mo ikat Sa pu janji deng ko: Sa nanti bikin ko pu anana cucu jadi paling banyak skali.” ");
INSERT INTO pmy_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Dengar begitu, Abram langsung tunduk sampe muka ke tana. Trus Allah bilang Abram lagi, ");
INSERT INTO pmy_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Ko dengar! Ini yang Sa janji ke ko: Sa nanti bikin ko jadi bapa dari bangsa-bangsa yang banyak skali. ");
INSERT INTO pmy_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Itu jadi, skarang ko pu nama bukan Abram lagi, tapi Abraham. Karna Sa su kas tetap ko jadi bapa dari bangsa yang banyak skali. ");
INSERT INTO pmy_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Sa nanti bikin ko ada anana cucu yang paling banyak skali. Ko pu anana cucu dong nanti jadi bangsa-bangsa. Nanti raja-raja juga lahir dari ko pu anana cucu ini. ");
INSERT INTO pmy_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Janji yang Sa bilang ko ini, ini janji yang trakan perna hilang. Biar sampe ko deng ko pu anana cucu yang lahir nanti juga, janji ini tetap ada. Sa janji Sa tetap jadi Allah untuk ko deng ko pu anana cucu. ");
INSERT INTO pmy_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Tana yang ko ada tinggal jadi pendatang ini, nanti Sa kasi ke ko deng ko pu anana cucu. Smua tana Kanaan ini, Sa nanti kasi ke kam, untuk tetap jadi kam pu milik sampe batas waktu yang trada akir. Trus Sa nanti tetap jadi Allah untuk dorang.” ");
INSERT INTO pmy_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Allah bicara lagi ke Abraham begini, “Trus untuk ko Abraham, ko deng ko pu anana cucu yang nanti lahir juga, kam harus tetap bikin tanda janji yang Sa bilang ini. ");
INSERT INTO pmy_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Sa su ikat janji deng ko sama ko pu anana cucu. Untuk kas tanda janji yang Sa su bikin ini, kam harus tetap bikin ini: tiap laki-laki yang ada tinggal sama-sama deng kam, harus dapa sunat. ");
INSERT INTO pmy_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Sunat pu cara tu begini: Potong kam pu kulit di bagian ujung klamin. Nanti itu yang kas tanda kalo Sa deng ko su ikat janji. ");
INSERT INTO pmy_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Kam pu anana yang baru lahir pas masuk dlapan hari, dong smua harus dapa sunat. Smua laki-laki dalam ko pu orang-orang ini, sampe kam pu anana cucu juga, smua yang lahir di kam pu kluarga ato orang luar yang dapa bli deng uang, yang tra masuk ko pu kluarga juga. ");
INSERT INTO pmy_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Smua laki-laki yang masuk dalam kam pu rombongan harus dapa sunat, itu jadi tanda cap di kam pu daging yang nanti kas ingat kam, kalo janji yang Sa kasi tu trakan perna hilang. ");
INSERT INTO pmy_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Laki-laki sapa saja yang tra dapa sunat, yang de pu kulit bagian ujung klamin tra dapa potong, de tra bole gabung deng orang-orang yang dapat Sa pu janji ini. Karna de tra bikin tanda janji yang Sa suru ini.” ");
INSERT INTO pmy_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Allah bilang Abraham lagi begini, “Trus untuk ko pu istri Sarai, jang ko panggil Sarai lagi. Mulai skarang de pu nama su ganti jadi Sara. ");
INSERT INTO pmy_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Sa nanti kas berkat dia, mala de nanti lahir anak laki-laki satu untuk ko. Sa nanti kas berkat de sampe de nanti jadi mama dari bangsa-bangsa. Mala, dari de pu anana cucu tu nanti ada raja-raja yang pimpin bangsa-bangsa.” ");
INSERT INTO pmy_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Dengar begitu, Abraham langsung tunduk hormat Allah sampe ke tana baru Abraham de pikir, “Sa pu umur su mo masuk 100 taun. Sara pu umur su 90 taun. Baru Sara de mo lahir anak untuk sa di umur begini? Bisa eh?” Langsung Abraham de ketawa rasa lucu. ");
INSERT INTO pmy_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Trus Abraham de bilang ke Allah, “Ah Tuhan, janji yang Tuhan kasi tu biar untuk Ismael saja suda. Biar dari de saja suda sa pu anana cucu lahir.” ");
INSERT INTO pmy_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Tapi Allah jawab begini, “Tra bole. Ko pu istri Sara nanti de lahir anak laki-laki satu untuk ko. Ko harus kas nama anak itu Isak. Nanti Sa bikin Sa pu janji deng dia juga deng de pu anana cucu, janji yang trakan perna hilang. ");
INSERT INTO pmy_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Yang ko minta tentang Ismael tu nanti Sa bikin juga. Nanti Sa kas berkat de deng kasi de anana cucu yang paling banyak skali juga. De nanti jadi moyang dari 12 kepala suku. De pu anana cucu juga nanti Sa bikin jadi bangsa yang besar. ");
INSERT INTO pmy_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Tapi Sa pu janji, itu janji yang nanti turun ke Isak, ko pu anak yang nanti Sara de lahir taun depan, pas di waktu-waktu macam skarang ini.” ");
INSERT INTO pmy_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Habis Allah bicara begitu, Allah naik kas tinggal Abraham disitu. ");
INSERT INTO pmy_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Trus Abraham panggil de pu anak Ismael deng smua orang laki-laki yang ada deng Abraham. Smua laki-laki yang lahir di Abraham pu ruma ato yang dapa bli, Abraham panggil dong trus potong dong pu kulit klamin bagian ujung. Sperti yang Allah bilang, hari itu juga Abraham kas sunat dong smua. ");
INSERT INTO pmy_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Jadi, Abraham pu umur su 99 taun waktu de dapa sunat. ");
INSERT INTO pmy_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Abraham pu anak Ismael ni, de pu umur 13 taun waktu de dapa sunat. ");
INSERT INTO pmy_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Hari itu juga, Abraham deng de pu anak Ismael dapa sunat langsung. ");
INSERT INTO pmy_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Trus, Abraham pu orang laki-laki smua juga, mo yang lahir di de pu ruma ato yang de bli, smua dapa sunat sama-sama deng dia. ");
INSERT INTO pmy_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Satu siang pas ada panas pica ni, Abraham de duduk-duduk depan de pu pintu tenda yang dekat pohon-pohon besar di Mamre. Begini, TUHAN kas tunjuk De pu diri ke Abraham. ");
INSERT INTO pmy_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Waktu Abraham de buang mata begini, de liat ada tiga orang bediri tra jau dari dia. Pas de liat dorang, dari de pu pintu tenda tu de pigi lari sambut dong. De tunduk hormat sama dong sampe ke tana. ");
INSERT INTO pmy_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Trus de bilang, “Tuan, kalo bapa mau, mari kam singga dulu sbentar di sa pu tenda. ");
INSERT INTO pmy_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Biar sa suru orang ambil air untuk cuci tuan-tuan pu kaki trus tuan dong bisa istirahat sbentar di bawa pohon ini.” ");
INSERT INTO pmy_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Baru Abraham bilang lagi, “Tuan dong su datang jadi, biar sa taru makanan sdikit supaya tuan-tuan bisa isi tenaga. Habis itu baru, nanti tuan dong lanjut jalan lagi.” Trus dong jawab, “Iyo, baik! Bikin yang ko bilang itu suda.” ");
INSERT INTO pmy_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Abraham langsung kembali ke tenda cepat-cepat trus bilang ke Sara, “Cepat! Ko pigi ambil tepung yang paling bagus satu sak trus bikin roti bulat dari situ!” ");
INSERT INTO pmy_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Habis itu, Abraham de lari ke tempat binatang piara. De ambil anak sapi satu yang de pu daging bagus skali trus de kasi ke de pu orang kerja. De pu orang ni langsung kas siap daging itu. ");
INSERT INTO pmy_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Dari situ Abraham de pigi ambil susu sapi, trus de ambil susu kental yang asam, deng daging yang su masak itu. Baru de pigi taru itu depan de pu tamu-tamu itu. Waktu de pu tamu ni dong makan, Abraham de bediri dekat dong di bawa pohon situ. ");
INSERT INTO pmy_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Baru orang-orang ini tanya Abraham, “Ko pu istri Sara, ada dimana?” Abraham jawab, “De ada disana, dalam tenda situ.” ");
INSERT INTO pmy_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Satu dari dong tiga bilang ke Abraham, “Taun depan di waktu yang sama macam skarang ini, Sa pasti datang ketemu ko lagi. Waktu itu, ko pu istri Sara ni nanti su lahir anak laki-laki satu.” Waktu itu, tuan itu ada duduk depan tenda, trus Sara de ada duduk dengar dari blakang pintu tenda. ");
INSERT INTO pmy_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Waktu itu, Abraham deng Sara su tua skali, trus Sara su brenti datang bulan. ");
INSERT INTO pmy_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Jadi, waktu dengar itu Sara de rasa lucu trus de ketawa dalam hati, de pikir, “Sa yang su layu begini? Macam sa masi mo rasa snang tidur deng sa pu suami ka, tamba lagi sa pu tuan Abraham juga su tua begitu.” ");
INSERT INTO pmy_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","TUHAN tanya ke Abraham, “Knapa Sara de ketawa? Knapa de tra percaya kalo de bisa lahir anak di de pu umur yang su tua ka? ");
INSERT INTO pmy_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Sa ini TUHAN! Trada yang susa untuk Sa! Taun depan, di waktu yang Sa su bilang itu, Sa nanti datang ketemu ko lagi. Waktu itu, Sara de nanti su lahir anak laki-laki satu.” ");
INSERT INTO pmy_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Karna Sara de takut jadi, de alasan bilang, “Sa tra ketawa.” Tapi TUHAN jawab dia, “Trada. Ko memang ketawa tadi!” ");
INSERT INTO pmy_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Habis itu Abraham antar tiga orang ni dong lanjut jalan lagi. Pas dong sampe di tempat yang dari jau dong bisa liat kota Sodom di bawa sana, ");
INSERT INTO pmy_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","TUHAN De pikir, “Masa Sa tra kastau Abraham apa yang Sa mo bikin sama kota Sodom? ");
INSERT INTO pmy_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Abraham ini yang, de pu anana cucu nanti jadi bangsa besar yang pu kuasa besar. Trus, lewat de Sa mo kas berkat smua bangsa di dunia ini baru? ");
INSERT INTO pmy_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Tra bisa! Karna Sa su pili de supaya de ajar de pu anana deng cucu-cucu hidup ikut Sa pu mau. Dong pu hidup tu harus benar trus bikin yang adil. Kalo dong bikin smua yang Sa bilang ini, Sa, TUHAN, pasti nanti bikin smua yang Sa su janji ke Abraham itu.” ");
INSERT INTO pmy_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Habis itu, TUHAN bicara ke Abraham begini, “Abraham, ada banyak orang yang triak tentang Sodom deng Gomora, trus memang dong pu dosa su terlalu banyak skali. ");
INSERT INTO pmy_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Itu jadi, Sa ada mo turun kesana untuk liat kalo memang yang dong triak tentang Sodom deng Gomora tu betul ka tra.” ");
INSERT INTO pmy_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Trus Abraham pu tamu-tamu ni dong jalan pigi ke kota Sodom. Tapi Abraham de masi tetap bediri deng TUHAN disitu. ");
INSERT INTO pmy_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Baru Abraham de ke dekat-dekat baru de tanya TUHAN, “Betul ka, Tuhan mo kas lenyap orang-orang jahat, lapis deng de pu orang-orang benar juga? ");
INSERT INTO pmy_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Bagemana kalo ada 50 orang benar di kota situ, Tuhan tetap kas lenyap kota itu smua ka? Tuhan betul-betul trakan kas ampun kota itu ka, supaya 50 orang tu slamat? ");
INSERT INTO pmy_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Pasti Tuhan tra mau kas lenyap orang benar sama-sama deng orang jahat to? Su pasti skali, Tuhan tra mungkin bikin begitu. Tra mungkin Tuhan hukum orang jahat deng orang benar sama-sama to? Tuhan tu hakim untuk sluru dunia, pasti bikin yang adil.” ");
INSERT INTO pmy_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Trus TUHAN bilang, “Kalo Sa ketemu 50 orang benar di kota Sodom itu, Sa nanti kas ampun dong satu kota tu smua, karna ada 50 orang benar ini.” ");
INSERT INTO pmy_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abraham lanjut tanya lagi, “Tuhan, Sa ni memang cuma debu tana saja tapi, jang mara sa ka, karna sa mo tanya lagi. ");
INSERT INTO pmy_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Bagemana kalo hanya ada 45 orang benar di kota Sodom, Tuhan tetap kas lenyap dong smua ka, karna hanya ada 45 orang saja?” TUHAN jawab, “Kalo sa ketemu 45 orang benar, Sa trakan kas lenyap tana itu.” ");
INSERT INTO pmy_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abraham lanjut lagi, “Bagemana kalo ada 40 orang benar, Tuhan?” TUHAN jawab, “Kalo ada 40 orang benar saja, Sa trakan kas lenyap tana itu.” ");
INSERT INTO pmy_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abraham tanya lagi, “Tuhan, tolong jang mara karna sa mo tanya lagi. Bagemana kalo ada 30 orang benar saja?” TUHAN jawab, “Kalo sa ketemu 30 orang benar, Sa trakan kas lenyap tana itu.” ");
INSERT INTO pmy_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abraham tanya lagi, “Tuhan, sa memang su terlalu brani skali tapi, bagemana kalo ada 20 orang benar saja?” TUHAN jawab, “Kalo Sa ketemu 20 orang benar, Sa trakan kas lenyap tana itu.” ");
INSERT INTO pmy_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Trakir Abraham bilang, “Tuhan, jang mara eh, ini yang trakir sa tanya. Bagemana kalo ada spulu orang benar saja di tana itu?” TUHAN jawab, “Karna spulu orang benar itu, Sa trakan kas lenyap tana itu.” ");
INSERT INTO pmy_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Habis bicara deng Abraham, TUHAN pigi dari situ trus Abraham de pulang ke de pu ruma. ");
INSERT INTO pmy_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Malaikat dua yang dari Abraham pu tenda tu, dong pigi ke kota Sodom. Dong dua tiba disana pas su malam. Waktu itu, Lot yang ada duduk di pintu masuk kota situ. Waktu Lot de liat dong dua, de bediri pi sambut baru tunduk hormat sampe ke tana depan dong dua. ");
INSERT INTO pmy_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Trus de bilang, “Tuan-tuan, mari singga di sa pu ruma dulu. Tuan kam bisa cuci kaki trus tidur di sa pu ruma malam ini, nanti besok kalo kam mau, kam bisa lanjut jalan pagi-pagi.” Tapi dong jawab, “Trapapa. Malam ini, tong dua tinggal di tana kosong di kota ni saja.” ");
INSERT INTO pmy_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Tapi Lot tinggal paksa dong trus, jadi suda dong jalan ikut masuk ke de pu ruma. Habis itu, Lot de kas siap makanan untuk dong dua, de bakar roti yang tra pake ragi, trus dong dua makan. ");
INSERT INTO pmy_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Tapi waktu tamu dong dua blum masuk tidur, laki-laki smua di satu kota Sodom, mo yang muda sampe yang tua ka, smua datang kliling Lot pu ruma ini. ");
INSERT INTO pmy_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Trus dong mulai batariak ke Lot begini, “Mana orang-orang yang tadi datang deng ko ke ko pu ruma? Kas kluar dong sini, supaya tong bisa pake dong!” ");
INSERT INTO pmy_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lot de kluar ketemu dong smua depan de pu pintu ruma trus de tutup pintu di blakang dia. ");
INSERT INTO pmy_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Trus de bilang ke dong begini, “Sodara, sa minta kam jang bikin yang jahat begitu. ");
INSERT INTO pmy_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Kam tau to, sa pu anak prempuan dua ni blum tidur deng laki-laki. Biar sa kasi dong saja ke kam suda. Dari kam saja, tersera kam mo bikin apa ke sa pu anana itu. Tapi jang bikin apapa ke orang-orang ini, dong ini sa pu tamu jadi, sa harus jaga dorang.” ");
INSERT INTO pmy_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Tapi orang-orang Sodom dong bilang ke Lot, “Pigi sana! Ko ni, pendatang saja baru mo atur-atur kitong lagi. Pigi! Ato ko mo tong bikin ko lebi para daripada dua orang itu nanti? Heh!” Suda. Dong paksa dorong-dorong Lot ni baru dong mo serbu pintu tu, mo dobrak masuk. ");
INSERT INTO pmy_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Tapi dua orang itu dong kas kluar dong pu tangan trus tarik Lot masuk dalam ruma. Trus dong tutup pintu. ");
INSERT INTO pmy_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Baru dong bikin orang-orang Sodom yang depan ruma ni pu mata buta, smua orang dari yang kecil sampe besar smua tra bisa dapa liat pintu. ");
INSERT INTO pmy_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Trus dua orang itu bilang ke Lot begini, “Ko pu sodara sapa lagi yang ada disini? Ko pu mantu, anak laki-laki, anak prempuan, ato ko pu kluarga sapa saja yang ada di kota ini, bawa dong kluar dari kota ini! ");
INSERT INTO pmy_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Karna tong mo kas hancur tempat ini rata deng tana. Su banyak orang yang triak ke TUHAN gara-gara kota ini pu jahat. Itu yang, TUHAN sampe suru tong untuk kas hancur rata kota ini.” ");
INSERT INTO pmy_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Jadi, Lot de pigi kluar trus pigi bicara deng de pu mantu dua, laki-laki dua yang nanti mo kawin deng de pu anana prempuan dua itu. Lot bilang dong begini, “Wei, kam cepat kluar dari tempat ini! TUHAN su mo kas hancur rata kota ini!” Tapi Lot pu anak mantu dua ni pikir de main-main saja. ");
INSERT INTO pmy_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Seblum matahari muncul, malaikat dua ni paksa-paksa Lot untuk cepat pigi dari situ. Dong bilang, “Cepat suda! Bawa ko pu istri deng anak prempuan dua ni kluar dari sini! Cepat, supaya kam jang ikut hancur waktu kota ni dapa kas hancur rata deng tana.” ");
INSERT INTO pmy_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Waktu Lot de ragu-ragu, tamu dua tu langsung pegang Lot pu tangan, Lot pu istri pu tangan, deng Lot pu anak prempuan dua ni pu tangan trus bawa dong kluar dari kota. Dong bikin begitu karna TUHAN rasa kasian deng Lot jadi. ");
INSERT INTO pmy_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Habis dua orang itu bawa dong kluar, orang yang satu de bilang begini, “Lari suda! Kas slamat kam pu diri. Jang balik-balik liat ke blakang eh! Jang brenti-brenti di tana renda juga! Lari trus ke daera gunung-gunung, supaya kam jang mati!” ");
INSERT INTO pmy_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lot de bilang ke dua orang itu, “Adooo bapa, jang suru tong lari ke gunung-gunung ka. ");
INSERT INTO pmy_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Memang betul, tuan su kas tunjuk tuan pu baik, tuan juga su kas tunjuk tuan pu sayang waktu kas slamat sa dari kota Sodom. Tapi kalo sa harus lari ke gunung-gunung, pasti sa nanti mati gara-gara bencana ni de su kena sa duluan. ");
INSERT INTO pmy_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Liat! Kota disana tu cukup dekat, kas ijin sa lari ke kota itu. De kota kecil saja to? Kas biar sa lari kesana biar sa slamat.” ");
INSERT INTO pmy_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Malaikat de jawab ke Lot, “Iyo suda, sa kas ijin yang ko minta itu. Kota yang ko bilang itu, sa trakan kas hancur. ");
INSERT INTO pmy_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Skarang, cepat! Lari suda! Karna sa blum bisa bikin apapa sampe ko su tiba disana dulu.” Gara-gara Lot bilang kota itu kota kecil jadi, dari situ kota itu pu nama jadi Zoar. ");
INSERT INTO pmy_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Matahari su naik, waktu Lot dong sampe di Zoar. ");
INSERT INTO pmy_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Trus begini, TUHAN bikin barang yang macam lahar panas deng api-api ni turun ke Sodom deng Gomora. Dong turun macam hujan begitu, langsung dari langit. ");
INSERT INTO pmy_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","TUHAN kas hancur dua kota ni betul-betul. Smua daera tana renda Yordan juga kena, lapis deng orang-orang smua deng tanaman smua juga, dapa kas hancur. ");
INSERT INTO pmy_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Kaget begini, Lot pu istri yang ada jalan di blakang Lot ni de balik liat ke blakang, trus de bruba jadi tiang garam batu. ");
INSERT INTO pmy_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Besok, pas pagi-pagi skali, Abraham de pigi ke tempat yang waktu itu de bediri depan TUHAN itu, ");
INSERT INTO pmy_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","baru de liat ke bawa, ke ara Sodom deng Gomora. De liat ke daera tana renda Yordan smua, begini de liat ada asap tebal naik dari tana situ, asap yang macam dari tungku besar skali. ");
INSERT INTO pmy_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Itu suda, waktu Allah kas hancur rata kota-kota di tana renda tempat Lot tinggal itu, Allah ingat Abraham. Jadi Allah kas kluar Lot dari tempat yang De kas hancur itu. ");
INSERT INTO pmy_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Gara-gara takut tinggal di kota Zoar situ, Lot deng de pu anak prempuan dua dong pigi dari situ, pigi ke daera gunung-gunung trus tinggal dalam goa satu. ");
INSERT INTO pmy_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Satu kali begini, Lot pu anak prempuan yang pertama bilang ke de pu ade, “Tong pu bapa ni de su mo tua. Trus dari daera smua ni juga, su trada laki-laki lagi yang bisa tidur deng kitong supaya tong bisa dapat anak, macam yang orang-orang biasa bikin. ");
INSERT INTO pmy_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Jadi, mari tong bikin tong pu bapa mabuk deng anggur, trus tong tidur deng dia, supaya bapa pu anana cucu tra sampe di tong dua saja.” ");
INSERT INTO pmy_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Pas malam itu juga, dong kas minum anggur ke dong pu bapa. Trus anak prempuan yang pertama de masuk baru tidur deng de pu bapa. Dong pu bapa mabuk skali sampe tratau yang de pu anak su tidur trus su bangun juga. ");
INSERT INTO pmy_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Pas hari brikut, prempuan yang pertama ni de bilang ke de pu ade lagi, “Tadi malam sa su tidur deng bapa. Ayo sbentar malam tong bikin de mabuk deng anggur lagi, baru ko masuk tidur deng dia. Supaya bapa pu anana cucu tra sampe di tong dua saja.” ");
INSERT INTO pmy_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Jadi malam itu juga, dong kas minum anggur ke dong pu bapa. Trus anak prempuan yang kedua de masuk trus tidur deng de pu bapa. Dong pu bapa mabuk skali sampe tratau yang de pu anak su tidur trus su bangun juga. ");
INSERT INTO pmy_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Trus Lot pu anak prempuan dua ni dong hamil dari dong pu bapa Lot ini. ");
INSERT INTO pmy_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","De pu anak prempuan yang pertama de lahir anak laki-laki satu, trus de kas nama Moab. Moab ini yang skarang jadi moyang dari orang-orang Moab dorang. ");
INSERT INTO pmy_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Lot pu anak prempuan yang kedua, de lahir anak laki-laki satu juga. Trus de kas nama Ben-Ami. Ben-Ami ini yang skarang jadi moyang dari orang-orang Amon dorang. ");
INSERT INTO pmy_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abraham de kluar dari Mamre trus pigi ke tana Negeb. De tinggal pas di tenga daera Kades deng Syur. Habis itu, de tinggal di kota Gerar jadi pendatang disitu. ");
INSERT INTO pmy_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Waktu itu, Abraham de bilang ke orang-orang kalo de pu istri Sara tu de pu sodara prempuan. Itu yang, raja Abimelek di kota Gerar ni de suru pigi ambil Sara untuk jadi de pu istri. ");
INSERT INTO pmy_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Tapi, satu malam begini, Allah datang ke Abimelek dalam mimpi trus bilang ke de begini, “Dengar! Sa mo hukum mati ko karna prempuan yang ko ambil itu. Prempuan itu su pu suami.” ");
INSERT INTO pmy_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Tapi karna Abimelek de blum tidur deng Sara, jadi raja Abimelek ni de bilang ke Allah begini, “Tuhan! Sa deng sa pu bangsa tra bikin sala apapa. Masa Tuhan mo hukum mati bangsa yang tra sala? ");
INSERT INTO pmy_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abraham sendiri yang bilang kalo Sara tu de pu sodara prempuan, trus Sara juga bilang Abraham tu de pu sodara laki-laki. Sa trada rencana jahat ke dorang, sa tra bikin sala.” ");
INSERT INTO pmy_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Allah bilang ke de lagi dalam mimpi, “Iyo. Sa su tau itu. Sa tau kalo ko trada rencana jahat ke dorang. Itu yang, Sa ada cegat ko supaya tra tidur deng prempuan itu, supaya ko tra bikin dosa ke Saya. ");
INSERT INTO pmy_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Jadi skarang, kas kembali orang itu pu istri suda! De tu nabi satu. Nanti de yang berdoa untuk ko supaya ko tetap hidup. Tapi kalo ko tra kas kembali prempuan itu, ko tau saja eh, ko deng ko pu orang-orang smua pasti mati.” ");
INSERT INTO pmy_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Besok begini, masi pagi-pagi ni, Abimelek panggil de pu pegawai-pegawai smua, trus de kastau smua yang su jadi itu. Waktu de pu orang-orang ni dong dengar, dong smua langsung jadi takut skali. ");
INSERT INTO pmy_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Habis itu, Abimelek de panggil Abraham. Baru de bilang begini ke Abraham, “Knapa ko bikin begitu ke kitong? Sa bikin sala apa sama ko? Knapa ko bikin sa deng sa pu orang-orang sampe bikin dosa besar begini? Yang ko bikin ke sa ini, su tra betul skali.” ");
INSERT INTO pmy_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abimelek de bilang ke Abraham lagi begini, “Apa yang ko pikir sampe ko bikin begini?” ");
INSERT INTO pmy_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraham jawab begini, “Sa pikir tu orang-orang disini trada yang kas tunjuk hormat ke Allah jadi pasti nanti sa dapa bunu gara-gara dong mau dapat sa pu istri ini. ");
INSERT INTO pmy_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Trus de ini memang sa pu sodara prempuan juga. Tong dua pu bapa sama, mama yang beda. Tapi skarang de su jadi sa pu istri. ");
INSERT INTO pmy_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Dulu, waktu Allah suru sa kluar dari sa pu bapa pu ruma trus jalan ke tana-tana lain, sa su bilang sa pu istri begini, ‘Kalo ko sayang sa, bikin begini: kemana saja tong pigi, bilang ke orang-orang di tempat itu sa ini ko pu sodara.’ ” ");
INSERT INTO pmy_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Suda. Habis itu, Abimelek de ambil kambing domba deng sapi-sapi, sama budak laki-laki deng budak prempuan, trus de kasi itu smua ke Abraham. Trus Abraham pu istri Sara juga de kas kembali ke Abraham. ");
INSERT INTO pmy_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Baru Abimelek bilang begini, “Ko bisa tinggal dimana saja ko mau. Sa pu tana ni bebas untuk trima ko.” ");
INSERT INTO pmy_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Trus Abimelek bilang begini ke Sara, “Ko liat! Sa kasi 1.000 potong perak ke ko pu sodara laki-laki, untuk kas slesai masala ini trus kas tunjuk ke orang smua disini kalo ko memang tra sala.” ");
INSERT INTO pmy_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Habis itu, Abraham de berdoa ke Allah, trus Allah kas sembu Abimelek deng de pu istri sama de pu budak prempuan dong, supaya dong bisa pu anak lagi. ");
INSERT INTO pmy_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Karna waktu itu TUHAN bikin smua prempuan di Abimelek pu istana tu tra bisa hamil, gara-gara yang jadi ke Abraham pu istri Sara itu. ");
INSERT INTO pmy_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","TUHAN bikin macam yang De su janji dulu, De liat Abraham pu istri Sara, trus De kasi berkat ke Sara sperti yang De su bilang. ");
INSERT INTO pmy_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Jadi Sara de hamil, trus de lahir anak laki-laki satu untuk Abraham. Anak ini lahir waktu Abraham de su tua. De lahir pas deng waktu yang dulu Allah su kastau. ");
INSERT INTO pmy_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abraham kas nama de pu anak yang Sara lahir tu Isak. ");
INSERT INTO pmy_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Trus Abraham sunat Isak waktu de pu umur su dlapan hari, untuk bikin tanda janji yang Allah su suru de bikin itu. ");
INSERT INTO pmy_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abraham pu umur waktu itu su 100 taun, waktu de pu anak Isak ni lahir. ");
INSERT INTO pmy_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Trus Sara bilang begini, “Allah su bikin sa snang sampe sa ketawa! Smua orang yang dengar ini, dong juga nanti ketawa snang sama-sama deng saya.” ");
INSERT INTO pmy_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Trus de tamba lagi, “Dulu trada orang yang mo bilang ke sa pu suami Abraham, ‘Sara nanti kas susu anak.’ Tapi skarang, kam liat! Sa su lahir anak laki-laki satu untuk Abraham pas di de pu umur yang su tua ini.” ");
INSERT INTO pmy_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Isak de su tamba besar. Pas waktu de mo lepas susu, Abraham bikin acara makan-makan besar untuk itu. ");
INSERT INTO pmy_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Tapi waktu acara ni, Sara liat Ismael ada main deng de pu anak Isak. Ismael tu Abraham pu anak dari Hagar, prempuan Mesir yang Sara pu budak itu. ");
INSERT INTO pmy_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Jadi, Sara bilang ke Abraham begini, “Bapa, usir suda, budak prempuan itu deng de pu anak! De pu anak tra bole trima bagian dari smua harta yang ko punya ini. Sa pu anak Isak yang harus dapat smua itu.” ");
INSERT INTO pmy_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Yang Sara bilang ni bikin Abraham pu hati tra snang skali, karna Ismael tu de pu anak juga. ");
INSERT INTO pmy_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Tapi Allah bicara ke Abraham begini, “Jang ko kuatir tentang ko pu anak deng ko pu budak prempuan itu. Smua yang Sara bilang ke ko, ko harus dengar trus bikin itu. Karna yang masuk anana cucu yang Sa su janji ke ko tu, yang dari Isak. ");
INSERT INTO pmy_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Tapi Sa juga nanti bikin bangsa satu dari budak ini pu anak, karna anak itu juga ko pu anak.” ");
INSERT INTO pmy_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Pas besok, pagi-pagi skali Abraham de bangun trus de pigi ambil makanan deng air minum dalam kantong kulit satu, trus de taru di Hagar pu bahu. Trus Abraham kasi anak itu sama Hagar deng suru de pigi. Jadi Hagar pigi dari situ, trus jalan kliling dekat kota Bersyeba, di tempat sepi yang kring. ");
INSERT INTO pmy_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Waktu air di dalam kantong kulit yang Abraham kasi tu habis, Hagar de taru anak itu di bawa pohon kecil, pas di de pu sombar situ. ");
INSERT INTO pmy_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","De bilang, “Sa tra sanggup liat anak ni de mati!” Itu yang, de langsung pigi duduk jau-jau dari de pu anak tu, macam 100 meter begitu suda de pu jau. Baru de bongkar mnangis disitu. ");
INSERT INTO pmy_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Begini, Allah dengar anak itu de pu suara mnangis juga, trus Allah pu Malaikat bicara dari langit ke Hagar, De bilang begini, “Hagar, ko rasa susa untuk? Jang takut! Allah su dengar anak itu de pu suara dari tempat de ada. ");
INSERT INTO pmy_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Ko bangun suda! Angkat anak itu, trus ko urus dia. Karna dari anak itu pu anana cucu, Sa mo bikin bangsa yang besar.” ");
INSERT INTO pmy_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Trus Allah bikin Hagar jadi bisa liat sumur satu dekat situ. Jadi, Hagar de pigi isi air di de pu kantong kulit tu. Trus de kas minum anak itu. ");
INSERT INTO pmy_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Allah yang ada sama-sama deng anak itu trus, sampe nanti de su jadi besar. Anak itu de tinggal di tempat sepi yang kring trus de jadi orang yang pintar pana-pana binatang. ");
INSERT INTO pmy_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Jadi, Ismael de tinggal di Paran, ini tempat sepi yang kring. Trus Ismael de pu mama pigi masuk minta prempuan Mesir satu untuk jadi Ismael de pu istri. ");
INSERT INTO pmy_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Waktu itu, Abimelek deng Pikol pigi bicara sama Abraham. Pikol ni Abimelek pu kepala tentara. Dong dua pigi, baru Abimelek de bilang begini, “Sa liat ni, memang, dalam smua yang ko bikin, ada Allah yang sama-sama deng ko trus. ");
INSERT INTO pmy_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Itu jadi, sa minta ko sumpa pake nama Allah depan sa disini. Ko sumpa kalo ko trakan tipu-tipu sa ato sa pu anana deng sa pu cucu-cucu. Sperti sa su bikin ko macam sa pu sobat, sa minta ko tetap bikin ke sa deng ke tana, tempat ko ada tinggal jadi pendatang ini.” ");
INSERT INTO pmy_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Jadi Abraham bilang, “Iyo, sa sumpa.” ");
INSERT INTO pmy_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Habis itu, Abraham de protes ke Abimelek. Abraham de bilang tentang sumur satu yang Abimelek pu orang kerja dong ambil paksa dari Abraham dorang. ");
INSERT INTO pmy_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Trus Abimelek bilang, “Ado, sa tratau. Sa baru dengar ini! Sapa yang bikin begitu ka? Ko juga tra perna kastau sa lagi!” ");
INSERT INTO pmy_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Jadi, Abraham ambil kambing domba deng sapi brapa, baru de kasi smua tu ke Abimelek, trus dong dua ikat janji. ");
INSERT INTO pmy_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Habis itu, dari de pu binatang piara, Abraham de kas pisa lagi anak domba tuju. ");
INSERT INTO pmy_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Trus Abimelek tanya Abraham begini, “Teman, ko kas pisa anak domba tuju tu untuk apa?” ");
INSERT INTO pmy_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abraham jawab de begini, “Bapa harus trima anak domba tuju ni langsung dari sa pu tangan, supaya ini jadi tanda kalo sumur ini sa yang gale.” ");
INSERT INTO pmy_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Abimelek trima anak domba itu. Itu yang, orang kas nama tempat itu Bersyeba, karna dong dua bikin sumpa disitu. ");
INSERT INTO pmy_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Habis Abraham deng Abimelek su ikat janji di Bersyeba situ, Abimelek deng de pu kepala tentara Pikol tu pulang ke dong pu tempat di orang Filistin pu daera. ");
INSERT INTO pmy_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Trus Abraham tanam pohon tamariska di Bersyeba situ baru Abraham semba TUHAN, Allah Yang Slalu Ada. ");
INSERT INTO pmy_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Suda, dari situ Abraham masi tinggal lama di orang Filistin pu daera situ. Abraham tinggal jadi orang pendatang disitu. ");
INSERT INTO pmy_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Su brapa waktu lewat begini, Allah tes Abraham pu percaya. Allah bilang begini ke dia, “Abraham!” Abraham jawab, “Ya Tuhan!” ");
INSERT INTO pmy_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Allah bilang, “Bawa ko pu anak yang satu saja tu, anak yang paling ko sayang, yang de nama Isak, kam dua pigi ke daera Moria. Trus, ko kasi de jadi persembahan untuk Sa. Ko potong baru bakar kas korban de ke Sa, di atas gunung satu yang nanti Sa kastau ko.” ");
INSERT INTO pmy_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Jadi, besok begini pagi-pagi skali Abraham de su bangun. De bla kayu untuk bakar kas korban ke Allah, trus de ikat di de pu kledai. Baru de panggil de pu orang kerja dua deng de pu anak Isak. Trus, dong smua jalan ke tempat yang Allah su bilang sama dia. ");
INSERT INTO pmy_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Pas su tiga hari dong jalan, dari jau ni Abraham buang mata trus de dapa liat tempat yang Allah bilang de tu. ");
INSERT INTO pmy_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Abraham bilang ke de pu orang kerja dua tu, “Kam dua tinggal disini deng kledai ni. Sa deng Isak mo pigi kesana, tong dua mo pigi sembayang dulu. Habis sembayang baru nanti tong dua balik ke kam sini.” ");
INSERT INTO pmy_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abraham de ambil kayu yang pake bakar kas korban ke Allah tu, baru de taru di de pu anak Isak pu bahu. Trus Abraham de bawa bara api deng pisou di tangan. Baru dong dua jalan sama-sama. ");
INSERT INTO pmy_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Pas dong ada jalan, begini Isak bilang ke de pu bapa Abraham begini, “Bapa?” Abraham jawab, “Bagemana anak?” Isak tanya, “Sa liat, kitong su ada api deng kayu bakar tapi, mana anak domba yang nanti tong potong baru bakar kas korban ke Allah?” ");
INSERT INTO pmy_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraham bilang dia, “Anak, Allah sendiri yang nanti kasi anak domba yang nanti tong bakar kas korban untuk Allah Dia.” Trus dong dua lanjut jalan lagi sama-sama. ");
INSERT INTO pmy_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Waktu dong dua sampe di tempat yang Allah bilang ke Abraham tu, Abraham de susun batu untuk bikin tempat bakar korban disitu. De susun kayu di atas tempat itu, trus de ikat de pu anak Isak. Baru, de taru de pu anak Isak di atas kayu yang di tempat bakar korban itu. ");
INSERT INTO pmy_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Habis itu, Abraham ambil de pu pisou. Tapi pas de mo potong de pu anak begini, ");
INSERT INTO pmy_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","TUHAN pu Malaikat bicara dari surga deng suara besar ke dia, “Abraham! Abraham!” Abraham jawab, “Ya Tuhan!” ");
INSERT INTO pmy_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Trus TUHAN bilang begini lewat De pu Malaikat, “Jang ko bunu anak itu. Jang bikin apapa ke dia, karna skarang Sa su tau kalo ko memang hormat skali sama Sa sampe ko dengar yang Sa suru ko. Ko tra main-main untuk kasi ko pu anak yang cuma satu saja tu untuk Saya.” ");
INSERT INTO pmy_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abraham de langsung buang mata, de liat ke blakang begini ada domba jantan satu yang de pu tanduk tasangkut di pohon-pohon kecil yang de pu batang talingkar. Jadi Abraham de ambil domba tu, trus de potong baru de bakar kas korban untuk Allah, ganti de pu anak Isak. ");
INSERT INTO pmy_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Jadi Abraham kas nama tempat itu pake nama yang de pu arti ʻTUHAN yang kas siap apa yang tong perlu.ʼ Dari situ yang orang biasa bilang begini, “Di atas TUHAN pu gunung, TUHAN su kas siap smua yang tong perlu.” ");
INSERT INTO pmy_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Trus TUHAN pu Malaikat bicara dari surga deng suara besar lagi ke Abraham, ");
INSERT INTO pmy_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","De bilang begini, “TUHAN bilang, ‘Karna ko su bikin begitu, trus ko tra main-main kasi ko pu anak yang cuma satu tu saja untuk Sa, jadi Sa sumpa deng Sa pu nama sendiri! ");
INSERT INTO pmy_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Sa sumpa, Sa nanti kas berkat ko banyak skali. Sa nanti bikin ko pu anana cucu pu banyak macam bintang di langit deng pasir di pinggir pante, baru ko pu anana cucu nanti dong yang pegang dong pu lawan-lawan pu kota. ");
INSERT INTO pmy_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Dari ko pu anana cucu, bangsa di bumi ni smua nanti dapa berkat juga. Nanti smua ni Sa bikin, karna ko su dengar-dengar Saya.’ ” ");
INSERT INTO pmy_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Habis itu, Abraham deng Isak dong kembali ke de pu orang kerja dua tu, trus dong smua pulang sama-sama ke Bersyeba. Abraham de tinggal trus di Bersyeba situ. ");
INSERT INTO pmy_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Habis dari gunung Moria, Abraham de dapa kabar kalo de pu sodara Nahor pu istri Milka su lahir anana laki-laki untuk Nahor. Anana dong pu nama-nama tu: ");
INSERT INTO pmy_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Us, de yang tua, trus de pu ade Bus, baru Kemuel, de ini yang nanti jadi moyang dari orang Aram. ");
INSERT INTO pmy_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Habis dong tiga, ada Kesed, Hazo, Pildas, Yidlaf, baru Betuel. ");
INSERT INTO pmy_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuel de pu anak prempuan nama Ribka. Dlapan orang ini suda yang lahir dari Milka, Nahor pu istri. Nahor yang Abraham pu sodara. ");
INSERT INTO pmy_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nahor de juga pu budak prempuan yang nama Reuma, yang de ambil jadi de pu istri. Nahor pu anana yang lahir dari Reuma, dong pu nama tu, Tebah, Gaham, Tahas, deng Maaka. ");
INSERT INTO pmy_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara hidup sampe 127 taun, sampe situ suda de pu umur. ");
INSERT INTO pmy_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Waktu dong di Kanaan di kota Kiryat-Arba, yang orang knal deng nama Hebron, Sara de mninggal. Waktu itu, Abraham de sedi skali baru bongkar mnangis untuk Sara. ");
INSERT INTO pmy_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Habis itu, Abraham bediri kas tinggal de pu istri baru pigi ke orang Het pu tua-tua. Abraham bilang dong begini, ");
INSERT INTO pmy_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Sa ini hanya pendatang saja yang singga di kam pu tana ini. Sa mo minta ijin untuk bli satu petak tana supaya sa bisa bikin kuburan untuk kubur sa pu istri ini.” ");
INSERT INTO pmy_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Orang Het dong jawab Abraham, dong bilang, ");
INSERT INTO pmy_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Begini, tuan ini orang yang tong paling hormati, yang tinggal sama-sama deng kitong. Jadi, tuan pake suda tong pu kuburan yang paling bagus untuk kubur tuan pu istri. Trada dari tong yang nanti mo tolak untuk kasi kuburan sama tuan, untuk kubur tuan pu istri.” ");
INSERT INTO pmy_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Abraham de langsung bediri trus tunduk hormat sampe ke tana ke orang Het, dong yang pu tana disitu. ");
INSERT INTO pmy_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Trus Abraham bilang dong begini, “Kalo kam trima untuk kubur sa pu istri disini, tolong dengar ini: tolong minta ke Zohar pu anak laki-laki yang nama Efron ka, ");
INSERT INTO pmy_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","supaya de mo jual de pu goa Makpela yang ada di pinggir de pu kebun itu. Kam bilang de kasi tana itu ke saya, nanti sa bayar itu deng harga penu depan kam smua, supaya sa bisa ambil tana ni untuk bikin tong pu kuburan.” ");
INSERT INTO pmy_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Baru waktu itu pas orang Het yang nama Efron ni, de deng orang-orang Het lain ni, dong ada duduk bicara di pintu masuk kota situ. Jadi, Efron de kasi jawaban ke Abraham pas depan orang-orang Het deng smua orang yang ada datang di pintu masuk kota itu. De bilang begini, ");
INSERT INTO pmy_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Trada tuan, depan orang-orang yang satu bangsa deng sa ini, sa kasi kebun itu lapis deng de pu goa. Tuan ambil suda, baru kubur tuan pu istri.” ");
INSERT INTO pmy_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Trus Abraham de tunduk lagi hormat sampe ke tana ke orang-orang suku Het itu. ");
INSERT INTO pmy_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Baru Abraham bilang ke Efron depan orang-orang disitu, “Jang begitu! Sa minta, tolong ko dengar yang sa bilang ini. Sa mo bli kebun itu ikut de pu harga. Tolong kas biar sa bayar saja suda. Begitu baru sa bisa kubur sa pu istri disana.” ");
INSERT INTO pmy_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Trus Efron de jawab Abraham begini, ");
INSERT INTO pmy_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Tuan eee! Tana spanggal tu de pu harga 400 potong perak. Tapi, trada arti skali untuk tuan deng saya. Tuan ambil suda, baru kubur tuan pu istri disitu.” ");
INSERT INTO pmy_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraham stuju deng harga yang Efron bilang. Trus de timbang perak untuk Efron supaya pas sperti yang Efron su bilang depan orang Het dorang, pas 400 potong perak, ikut cara hitung yang penjual biasa pake. ");
INSERT INTO pmy_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Jadi suda, Efron pu kebun yang di daera Makpela, di sebla timur Mamre tu, itu jadi Abraham pu milik. Kebun deng goa yang ada disana, juga smua pohon yang ada di ujung-ujung kebun itu, ");
INSERT INTO pmy_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Efron kasi ke Abraham jadi tana yang Abraham punya, depan orang Het dorang, depan smua orang yang ada datang di pintu masuk kota itu. ");
INSERT INTO pmy_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Habis itu, Abraham pigi kubur de pu istri Sara di dalam goa yang di kebun Makpela itu. Ini di Kanaan, di bagian timur daera Mamre, yang skarang orang tau deng nama Hebron. ");
INSERT INTO pmy_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Jadi begitu suda, kebun deng goa yang orang Het punya itu, dong kasi ke Abraham untuk jadi de pu milik, yang de bikin jadi tempat kuburan. ");
INSERT INTO pmy_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Apa saja yang Abraham bikin, TUHAN tinggal kas berkat de trus. Skarang begini, waktu Abraham su tua skali, ");
INSERT INTO pmy_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Abraham de bicara ke orang yang biasa urus de pu harta smua, kepala dari de pu orang-orang kerja smua, Abraham de bilang begini, “Sa mau ko taru ko pu tangan di bawa sa pu paha untuk kas tanda kalo ko sumpa sunggu-sunggu ke saya. ");
INSERT INTO pmy_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Ko sumpa pake nama TUHAN, Allah yang pu dunia ni, kalo ko trakan ambil prempuan dari Kanaan, tempat yang sa ada tinggal skarang ni, untuk kasi jadi sa pu anak pu istri. ");
INSERT INTO pmy_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Tapi ko harus sumpa, kalo ko nanti pigi ke sa pu tana asal. Trus dari sa pu sodara-sodara tu, ko ambil prempuan satu untuk sa pu anak Isak.” ");
INSERT INTO pmy_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Baru Abraham pu orang kerja tu bilang ke dia, “Tapi bapa, kalo prempuan itu de tra mau ikut sa ke tana sini, sa harus bawa pigi bapa pu anak ke bapa pu negri asal ka?” ");
INSERT INTO pmy_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Tapi Abraham bilang dia, “Tra bole! Jang sampe ko bawa sa pu anak kembali kesana. ");
INSERT INTO pmy_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","TUHAN Allah yang pu langit ni, De yang su bawa sa kluar dari sa bapa pu ruma juga dari sa pu sodara dong pu tana. De Allah yang sumpa ke sa begini, ‘Sa kasi tana ini ke ko pu anana cucu nanti.’ Allah juga yang nanti suru De pu malaikat untuk jalan depan ko, supaya ko bisa dapat prempuan dari sana untuk jadi sa pu anak pu istri. ");
INSERT INTO pmy_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Kalo prempuan itu tra mo ikut ko, brarti ko su bebas dari ko pu sumpa ke sa ini. Tapi ko harus ingat! Jang perna ko bawa sa pu anak kembali kesana.” ");
INSERT INTO pmy_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Habis itu, orang kerja itu de taru de pu tangan di bawa de pu tuan Abraham pu paha, trus de bilang sumpa yang Abraham suru de itu. ");
INSERT INTO pmy_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Baru orang kerja itu ambil spulu dari de pu tuan Abraham pu unta-unta. De bawa itu pigi deng hadia-hadia dari de pu tuan tu smua, hadia yang paling bagus. Trus de ke kota, tempat Abraham pu sodara Nahor de tinggal. Kota tu ada di Mesopotamia pu sebla utara. ");
INSERT INTO pmy_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Waktu de su dekat-dekat Nahor dong pu kota, de kas stop de pu unta-unta untuk istirahat di bagian luar kota, dekat sumur satu. Waktu itu pas su sore, waktu untuk prempuan dong biasa kluar dari kota untuk timba air. ");
INSERT INTO pmy_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Trus Abraham pu orang kerja itu de berdoa dalam hati begini, “TUHAN Allah yang sa pu tuan Abraham semba, tolong sa ka, supaya apa yang sa harus bikin, bisa jadi deng baik hari ini juga! Tolong kas tunjuk TUHAN pu sayang yang tra perna stop itu ke sa pu tuan Abraham. ");
INSERT INTO pmy_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Tuhan, skarang sa ada bediri dekat sumur, trus ini juga su waktu untuk nona-nona dari dalam kota dong kluar untuk timba air. ");
INSERT INTO pmy_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Jadi, ini yang sa minta: Nanti kalo sa bilang ke nona satu begini, ‘Tolong, kasi bapa minum air dari nona pu tempat itu ka,’ trus nona itu de bilang begini, ‘Mari bapa, minum suda! Sa juga nanti ambil air untuk bapa pu unta-unta ni minum.’ Kalo smua jadi begitu baru, sa tau kalo de itu nona yang Tuhan su pili untuk Isak. Trus, sa tau kalo Tuhan su kas tunjuk Tuhan pu sayang yang tra perna stop itu ke sa pu tuan Abraham.” ");
INSERT INTO pmy_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Waktu de blum slesai berdoa, kaget begini ada nona satu datang pikul tempat untuk isi air di de pu bahu. Nona ini de pu nama Ribka, bapa Betuel pu anak prempuan. Bapa Betuel tu Nahor deng Milka pu anak laki-laki. Nahor tu Abraham pu sodara. ");
INSERT INTO pmy_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Nona Ribka ni de cantik skali, de juga blum kawin trus blum perna tidur deng laki-laki. Nona Ribka de turun ke sumur tempat ambil air. De isi de pu tempat air itu, trus de naik kembali. ");
INSERT INTO pmy_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Abraham pu orang kerja tu de lari cepat-cepat ke de trus bilang, “Nona, bapa bisa minta air sdikit dari nona pu tempat air tu ka, untuk bapa minum?” ");
INSERT INTO pmy_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ribka de jawab, “Bisa bapa! Mari minum suda.” Jadi, de cepat-cepat kas turun tempat air dari de pu bahu ke tangan, baru de kasi air untuk Abraham pu orang kerja tu de minum. ");
INSERT INTO pmy_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Waktu orang kerja itu de minum slesai, Ribka de bilang begini, “Bapa, biar sa pigi timba air untuk kas minum bapa pu unta-unta juga eh, nanti sa kas minum dong sampe puas.” ");
INSERT INTO pmy_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Jadi de tumpa air dari de pu tempat ke binatang dong pu tempat minum tu. Trus de lari cepat-cepat ke sumur lagi baru timba air sampe orang kerja itu pu unta smua su minum slesai. ");
INSERT INTO pmy_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Waktu Ribka de bikin begitu, orang kerja ini de liat baik-baik tapi tra bicara apapa. Karna de mo tau kalo ini TUHAN yang ada tolong supaya apa yang de harus bikin ni bisa jadi deng baik ka trada. ");
INSERT INTO pmy_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Habis unta-unta smua su minum sampe puas, Abraham pu orang kerja ni de ambil anting emas paling bagus yang biasa pake di hidung. De pu brat hampir sama deng enam gram. Trus de juga ambil gelang emas dua. Gelang tangan yang de pu brat lebi dari 100 gram. ");
INSERT INTO pmy_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Baru de bilang ke Ribka, “Bisa kastau bapa ka, ko ni sapa pu anak? Di ko pu bapa pu ruma ada tempat untuk sa deng sa pu orang-orang ni bisa tinggal malam ini ka?” ");
INSERT INTO pmy_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Baru Ribka jawab dia, “Sa pu bapa Betuel. Betuel itu nene Milka deng tete Nahor pu anak laki-laki.” ");
INSERT INTO pmy_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Trus Ribka de bilang lagi, “Mo rumput untuk unta-unta pake tidur ka, mo makanan untuk unta ka, smua itu tong pu ada banyak. Tempat untuk mo tinggal malam ini juga ada.” ");
INSERT INTO pmy_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Langsung orang kerja itu de tunduk hormat sampe ke tana, baru semba TUHAN. ");
INSERT INTO pmy_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","De bilang begini, “TUHAN Allah yang sa pu tuan Abraham semba memang pantas dapa puji! De Tuhan yang tra perna tarik De pu sayang kembali, baru De tra perna stop kas tunjuk De pu setia sama sa pu tuan. TUHAN De yang su pimpin sa di jalan yang benar, ke sa pu tuan de pu kluarga dorang!” ");
INSERT INTO pmy_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Habis itu, nona Ribka de lari pulang ke de pu mama, di dong pu ruma. Trus de crita smua yang tadi baru jadi tu. ");
INSERT INTO pmy_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Ribka de pu sodara laki-laki satu, de pu nama Laban. Waktu Laban dengar Ribka pu crita, tamba deng de liat anting deng gelang yang de pu sodara prempuan pake tu, de langsung lari kluar kota ke sumur situ. De pi ketemu deng Abraham pu orang kerja itu yang masi bediri dekat de pu unta-unta dekat sumur situ. ");
INSERT INTO pmy_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Laban pigi trus bilang, “Mari bapa! Bapa ni orang yang TUHAN kas berkat memang. Knapa bapa masi bediri di luar sini? Mari, ikut sa suda! Sa su siap tempat di sa pu ruma untuk bapa dong tinggal. Su ada tempat untuk bapa pu unta-unta juga.” ");
INSERT INTO pmy_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Jadi, Abraham pu orang kerja tu, de ke Betuel pu ruma. Laban de kas turun barang-barang yang unta-unta bawa, trus de kasi makanan untuk unta makan, sama rumput bekas gandum untuk unta-unta tidur. Baru de bawa air supaya orang kerja itu deng de pu orang brapa tu yang ada ikut dia, dong bisa cuci kaki. ");
INSERT INTO pmy_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Skarang begini, pas waktu dong taru makanan depan orang kerja itu, de bilang begini, “Sa blum bisa makan sampe sa bilang pesan yang sa ada bawa ni dulu.” Laban jawab, “Ooo iyo. Bapa bicara suda.” ");
INSERT INTO pmy_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Trus orang kerja itu de bilang, “Sa ini Abraham pu orang kerja. ");
INSERT INTO pmy_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","TUHAN memang paling kasi berkat skali ke sa pu tuan. Itu yang bikin de suda jadi orang kaya skarang. TUHAN su kasi de kambing domba, sapi-sapi, emas deng perak, budak laki-laki sama prempuan juga ada, unta deng kledai juga ada. ");
INSERT INTO pmy_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Baru sa pu tuan pu istri Sara juga, padahal de su tua tapi de lahir anak laki-laki untuk sa pu tuan. De pu anak ini yang nanti dapat smua yang tuan Abraham punya. ");
INSERT INTO pmy_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Sa pu tuan de su suru sa sumpa begini, ‘Ko trakan ambil prempuan dari Kanaan, tempat yang sa ada tinggal skarang ni, untuk kasi jadi sa pu anak Isak pu istri. ");
INSERT INTO pmy_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Tapi ko harus sumpa, kalo ko nanti pigi ke sa pu bapa pu ruma. Trus dari sa pu kluarga besar tu, ko ambil satu prempuan untuk jadi sa pu anak pu istri.’ ");
INSERT INTO pmy_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Trus sa bilang ke sa pu tuan, ‘Kalo prempuan itu de tra mo ikut sa ke tana sini bagemana?’ ");
INSERT INTO pmy_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Tapi sa pu tuan de bilang begini ke saya, ‘TUHAN yang sa ada ikut De pu printa ni, nanti De suru De pu malaikat untuk jalan depan ko. TUHAN De nanti tolong supaya apa yang ko harus bikin ni, bisa jadi deng baik. Sampe nanti ko ambil istri untuk sa pu anak dari sa pu kluarga besar dorang, dari sa pu bapa pu kluarga. ");
INSERT INTO pmy_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Tapi kalo ko su sampe di sa pu kluarga besar, trus dong tra mo kasi prempuan itu untuk ko, brarti ko su bebas dari ko pu sumpa ke sa ni.’ ");
INSERT INTO pmy_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Jadi hari ini, waktu sa sampe di sumur tadi, sa berdoa begini, ‘TUHAN Allah yang sa pu tuan Abraham semba, tolong sa ka, supaya apa yang sa harus bikin, bisa jadi deng baik hari ini. ");
INSERT INTO pmy_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Tuhan, skarang sa ada bediri dekat sumur, jadi sa minta begini: Kalo nona satu kluar mo timba air, trus sa bilang dia: Tolong, kasi bapa minum air dari ko pu tempat air itu ka, ");
INSERT INTO pmy_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","trus nona itu de bilang: Mari bapa, minum suda. Sa juga nanti ambil air untuk bapa pu unta-unta minum. Kalo smua jadi begitu baru, sa tau kalo nona itu yang TUHAN su pili untuk tuan Abraham pu anak.’ ");
INSERT INTO pmy_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Waktu sa blum slesai berdoa dalam hati ni, nona Ribka muncul! De datang pikul de pu tempat air di atas bahu, trus de turun ke sumur baru de timba air. Trus sa pigi bilang dia, ‘Nona, bapa bisa minta air sdikit ka?’ ");
INSERT INTO pmy_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","De langsung cepat-cepat kas turun tempat air dari de pu bahu baru de bilang, ‘Bisa bapa, mari minum suda! Bapa pu unta-unta juga nanti sa kas minum.’ Jadi sa minum. Baru de kas minum unta-unta ini. ");
INSERT INTO pmy_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Habis itu, sa tanya dia, ‘Ko ni sapa pu anak?’ De jawab, ‘Sa pu bapa Betuel. Betuel itu tete Nahor deng nene Milka pu anak laki-laki.’ Trus sa kas pake de anting di de pu hidung sama gelang di de pu tangan. ");
INSERT INTO pmy_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Baru sa langsung tunduk sampe ke tana baru semba TUHAN. Trus sa puji TUHAN Allah yang sa pu tuan Abraham semba. De yang pimpin sa di jalan yang benar untuk dapat anak prempuan dari sa pu tuan pu sodara ni, buat jadi de pu anak pu istri. ");
INSERT INTO pmy_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Jadi skarang, kalo kam mo kas tunjuk kam pu baik deng kam pu setia ke sa pu tuan yang kam pu sodara tu, tolong kastau saya. Kalo kam tra mau juga, tolong kastau saya. Supaya sa bisa bikin rencana lanjut.” ");
INSERT INTO pmy_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Laban deng Betuel dong jawab, “Su jlas kalo smua yang jadi ni, TUHAN yang rencana. Tong tra bisa bilang apapa lagi. ");
INSERT INTO pmy_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Skarang liat, Ribka su ada di depan bapa. Jadi, sperti yang TUHAN su bilang ke bapa, bawa de pigi suda. Supaya de bisa jadi istri buat anak dari bapa pu tuan.” ");
INSERT INTO pmy_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Waktu Abraham pu orang kerja ni dengar yang dong bilang, de langsung tunduk hormat TUHAN sampe ke tana, semba TUHAN. ");
INSERT INTO pmy_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Trus orang kerja itu de kas kluar emas deng perak yang biasa dong pake untuk hias-hias badan, deng pakean-pakean mahal baru kasi ke Ribka. Trus de kasi hadia-hadia yang bagus juga ke Ribka pu sodara deng Ribka pu mama. ");
INSERT INTO pmy_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Habis itu, orang kerja itu deng smua orang yang ada disitu, dong smua makan deng minum trus tinggal malam itu disitu. Besok pagi, waktu dong bangun, Abraham pu orang kerja tu de bilang begini, “Sodara, sa mo minta ijin supaya tong bisa pulang skarang ke sa pu tuan pu ruma.” ");
INSERT INTO pmy_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Tapi Ribka pu sodara deng de pu mama dong bilang, “Ado bapa, kas biar tong tinggal deng tong pu anak prempuan ni barang spulu hari begitu ka? Slesai itu baru kam bawa de pulang.” ");
INSERT INTO pmy_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Tapi orang kerja itu bilang ke dorang, “Tolong, jang tahan sa lagi, TUHAN su tolong sa kas slesai apa yang sa harus bikin ni deng baik. Skarang, kam kas biar sa pulang ke sa pu tuan suda.” ");
INSERT INTO pmy_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Trus dong bilang, “Lebi baik tong panggil nona Ribka baru tanya de langsung saja.” ");
INSERT INTO pmy_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Jadi dong panggil Ribka baru dong tanya dia, “Bagemana? Ko mau pigi deng bapa ini skarang?” Ribka jawab, “Mau.” ");
INSERT INTO pmy_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Jadi suda, dong kas biar dong pu sodara Ribka deng mama satu yang su jaga Ribka dari de kecil tu pigi, sama-sama deng Abraham pu orang kerja deng de pu orang-orang. ");
INSERT INTO pmy_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Trus dong kas berkat Ribka, dong bilang begini, “Tong pu sodara Ribka, tong berdoa minta supaya ko bisa pu anana yang paling banyak skali sampe tra bisa hitung! Trus tong berdoa supaya ko pu anana cucu dong bisa ambil dong pu lawan-lawan pu tempat, trus tinggal disitu.” ");
INSERT INTO pmy_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Habis itu, Ribka deng de pu budak-budak prempuan dong kas siap-siap dong pu barang-barang, trus dong naik unta ikut bapa ini. Jadi begitu suda, Abraham pu orang kerja ni de bawa Ribka jalan pulang. ");
INSERT INTO pmy_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Pas waktu itu juga, Isak su datang dari ara sumur Lahai-Roi, trus de tinggal di tana Negeb, di Kanaan pu sebla slatan. ");
INSERT INTO pmy_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Sore-sore begini, Isak de ada jalan-jalan di daera sepi tempat rumput saja tu. Pas de buang mata, de liat ada rombongan unta-unta datang. ");
INSERT INTO pmy_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ribka juga, de buang mata begini de liat Isak, jadi de langsung turun dari de pu unta. ");
INSERT INTO pmy_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Trus de bilang ke Abraham pu orang kerja itu, “Bapa, laki-laki yang ada jalan di daera rumput-rumput tu, de sapa ka? Yang ada jalan kemari tu?” Orang kerja itu de jawab, “De tu yang sa pu tuan Isak.” Jadi, Ribka de ambil de pu syal trus de pake tutup de pu muka. ");
INSERT INTO pmy_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Habis itu, orang kerja itu de crita smua yang su jadi tu sama Isak. ");
INSERT INTO pmy_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Trus Isak bawa Ribka ke tenda, tempat Isak pu mama Sara dulu tinggal. Trus de ambil Ribka jadi de pu istri. Isak paling sayang Ribka skali. Dari waktu Isak pu mama Sara mati, Ribka de yang bikin Isak pu hati snang lagi. ");
INSERT INTO pmy_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham de kawin lagi deng prempuan satu yang nama Ketura. ");
INSERT INTO pmy_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Prempuan itu de lahir anana untuk Abraham. De pu anana nama tu Zimran, Yoksan, Medan, Midian, Isbak, deng Suah. ");
INSERT INTO pmy_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yoksan pu anana tu Syeba deng Dedan. Trus Dedan pu anana tu yang jadi moyang dari orang Asyur, orang Letus, deng orang Leum. ");
INSERT INTO pmy_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midian pu anana tu Efa, Efer, Henok, Abida, deng Elda. Smua ni Ketura pu anana cucu dorang. ");
INSERT INTO pmy_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abraham de kasi smua harta yang de punya ke de pu anak Isak. ");
INSERT INTO pmy_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Tapi waktu Abraham de masi hidup, de kasi hadia-hadia ke de pu anana dari istri-istri lain, budak yang de ambil jadi de pu istri itu. Baru de suru dong pigi tinggal di daera sebla timur, di Tana Timur, jang tinggal sama-sama deng Isak. ");
INSERT INTO pmy_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abraham hidup sampe umur 175 taun, ");
INSERT INTO pmy_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","baru de mninggal, de gabung deng de pu orang-orang tua dorang. De su hidup lama, waktu de mninggal tu de su tua skali. ");
INSERT INTO pmy_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","10","Trus de pu anana Isak deng Ismael dong kubur de di goa Makpela, dalam kebun yang dulu de bli dari orang Het yang nama Efron, Zohar pu anak itu. Goa tu ada di sebla timur daera Mamre. Di tempat ini Abraham deng de pu istri Sara dapa kubur. ");
INSERT INTO pmy_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Waktu Abraham su mninggal, Allah tetap kas berkat Isak, Abraham pu anak ini. Trus Isak de tinggal dekat sumur Lahai-Roi. ");
INSERT INTO pmy_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ini daftar anana cucu dari Ismael. Ismael tu Abraham pu anak yang dari Hagar, Sara pu budak prempuan Mesir itu. ");
INSERT INTO pmy_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ini Ismael pu anana dong pu nama-nama, mulai dari yang lahir paling duluan: Nebayot, ini anak yang tua. Habis itu Kedar, Adbeel, Mibsam, ");
INSERT INTO pmy_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Duma, Masa, ");
INSERT INTO pmy_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Yetur, Nafis, deng Kedma. ");
INSERT INTO pmy_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Itu suda, Ismael pu anana smua. Dari dorang lahir 12 kepala suku yang pimpin dong pu suku masing-masing, trus dong pu nama tu yang jadi nama-nama kampung tempat dong tinggal. ");
INSERT INTO pmy_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismael pu umur su 137 taun baru de mninggal, de gabung deng de pu orang-orang tua dorang. ");
INSERT INTO pmy_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","De pu anana cucu dong tinggal dari daera Hawila sampe ke Syur. De pu tempat ada di sebla timur Mesir, ke ara-ara tana Asyur. Dong tinggal baku musu deng dong pu sodara-sodara yang lain. ");
INSERT INTO pmy_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Ini crita tentang Isak pu anana cucu. Isak tu Abraham pu anak. ");
INSERT INTO pmy_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Waktu Isak de pu umur 40 taun, de kawin deng Ribka, Betuel pu anak prempuan. Isak pu istri ni Laban pu sodara prempuan. Betuel deng Laban ni dong dari suku Aram yang di Padan-Aram. ");
INSERT INTO pmy_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isak pu istri de tra bisa dapat anak. Itu jadi, Isak de minta sama TUHAN supaya de pu istri bisa dapat anak. TUHAN dengar, trus bikin yang de minta itu jadi. Itu yang, Isak pu istri Ribka de hamil. ");
INSERT INTO pmy_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Tapi waktu de hamil, de pu anana dua baku tolak-tolak dalam perut, trus de bilang, “Knapa sa pu hidup macam begini ka?” Jadi de pigi tanya TUHAN. ");
INSERT INTO pmy_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Trus TUHAN bilang de begini, “Ada dua bangsa dalam ko pu perut, yang satu pu orang-orang nanti lebi kuat daripada yang satu lagi pu orang-orang. Anak yang tua, nanti de kerja untuk anak yang muda. Mulai dari dalam perut sampe nanti juga, dong dua tetap trakan baku cocok.” ");
INSERT INTO pmy_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Pas waktu su mo lahir begini, memang ada anak kembar dalam de pu perut. ");
INSERT INTO pmy_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Waktu anak yang pertama kluar, de pu badan mera, baru penu bulu-bulu macam de pake baju bulu-bulu begitu. Itu yang, dong kas nama de Esau. ");
INSERT INTO pmy_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Habis itu, de pu ade yang kluar, de pu tangan pegang Esau pu tumit. Itu yang, dong kas nama de Yakub. Isak pu umur su masuk 60 taun waktu dong dua lahir. ");
INSERT INTO pmy_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Anana dua tu dong su tamba besar. Esau de su jadi orang yang paling pintar buru binatang, de suka ada di daera sepi tempat buru binatang. Tapi Yakub, de tu orang yang tenang, de suka tinggal di ruma. ");
INSERT INTO pmy_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isak de suka makan daging dari binatang yang orang biasa buru. Itu yang bikin de lebi sayang Esau. Tapi Ribka, de lebi sayang Yakub. ");
INSERT INTO pmy_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Satu kali, pas Yakub de ada masak makanan begini, Esau de datang dari daera tempat buru binatang. Esau de su mati lapar skali. ");
INSERT INTO pmy_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Baru Esau de bilang sama Yakub, “Sa su lapar skali ni! Mari, kasi sa makan sdikit barang mera-mera yang ko masak itu dulu.” Gara-gara bilang begitu yang Esau de dapa panggil Edom. ");
INSERT INTO pmy_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Tapi Yakub de balas, “Ko pu hak anak pertama tu, ko kasi ke sa dulu bole.” ");
INSERT INTO pmy_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","“Aih, ko ambil suda. Ini orang su mo mati gara-gara lapar ni. Untuk apa juga hak anak pertama itu, bisa bikin kenyang ka?” Esau de bilang ke Yakub. ");
INSERT INTO pmy_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Trus Yakub de balas, “Ko sumpa sama sa dulu.” Jadi suda, de sumpa sama Yakub, trus de pu hak anak pertama tu, de kasi itu ke Yakub. ");
INSERT INTO pmy_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Trus Yakub kasi Esau roti deng de pu masakan biji-biji mera itu. Esau de makan, de minum, trus de bediri baru pigi dari situ. Jadi begitu suda, Esau yang jadi anak pertama ni, de anggap reme de pu hak. ");
INSERT INTO pmy_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Skarang begini, ada klaparan di tana yang Isak tinggal itu. Klaparan macam begini dulu su perna ada juga di Abraham dong pu jaman. Gara-gara ini yang bikin Isak dong pigi ke kota Gerar, ke orang Filistin dong pu raja Abimelek. ");
INSERT INTO pmy_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Waktu itu, TUHAN kas tunjuk De pu diri sama Isak baru bilang de begini, “Jang pigi ke Mesir! Ko pigi tinggal dulu di daera yang nanti Sa kas tunjuk ko. ");
INSERT INTO pmy_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ko tinggal di tana ini jadi pendatang saja dulu. Sa yang nanti ada sama-sama ko, trus kas berkat ko, karna Sa mo kasi tana ni smua untuk ko deng ko pu turunan nanti. Sa pu sumpa ke ko pu bapa Abraham itu, pasti Sa bikin. ");
INSERT INTO pmy_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Nanti Sa bikin ko pu anana cucu banyak macam bintang di langit, trus Sa kasi tana ni smua untuk ko pu anana cucu dorang. Dari ko pu turunan, bangsa di bumi ni smua nanti dapa berkat juga. ");
INSERT INTO pmy_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Sa pasti bikin itu, karna Abraham de su dengar-dengar Saya. Baru de jaga de pu diri supaya tetap bikin Sa pu hukum, praturan, deng printa smua.” ");
INSERT INTO pmy_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Itu yang, Isak dong tinggal di kota Gerar. ");
INSERT INTO pmy_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Waktu laki-laki dari Gerar dong tanya Isak tentang de pu istri ni, Isak de bilang, “De itu sa pu sodara prempuan.” De takut mo bilang, “De itu sa pu istri.” Habis de pikir begini, “Jang sampe nanti sa dapa bunu dari orang-orang disini lagi, habis Ribka ni cantik skali jadi.” ");
INSERT INTO pmy_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Waktu Isak de su tinggal lama di Gerar, satu kali begini, orang Filistin pu raja Abimelek ni de ada liat-liat dari de pu jendela ke bawa begini, de liat Isak ada baku polo deng de pu istri Ribka. ");
INSERT INTO pmy_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Suda. Abimelek de suru panggil Isak trus de bicara deng Isak begini, “Knapa ko bilang kalo de itu ko pu sodara prempuan? Padahal de itu ko pu istri baru.” Isak de jawab begini, “Habis, sa pikir kalo sa bilang de tu sa pu istri, nanti sa dapa bunu jadi.” ");
INSERT INTO pmy_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimelek bilang dia, “Yang ko ada bikin ke kitong ini tra baik skali! Bagemana kalo sampe orang Gerar satu tidur deng ko pu istri? Kalo sampe jadi begitu, brarti ko su bikin kitong bikin dosa besar skali.” ");
INSERT INTO pmy_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Trus Abimelek de printa de pu bangsa smua. De bilang begini, “Sapa saja yang brani ganggu orang ini ato ganggu de pu istri, nanti dapa hukum mati.” ");
INSERT INTO pmy_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Jadi, Isak de bikin kebun di tana itu. Taun itu Isak de dapa hasil panen sampe 100 kali lipat dari yang de su tanam itu. Itu karna TUHAN yang kas berkat dia. ");
INSERT INTO pmy_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Isak ni jadi orang kaya. De pu barang-barang tinggal tamba banyak trus, sampe de jadi orang paling kaya suda. ");
INSERT INTO pmy_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","De pu kambing, domba, sapi, deng budak paling banyak skali. Bikin sampe orang Filistin dong iri hati deng dia, gara-gara de pu barang lebi banyak dari dorang. ");
INSERT INTO pmy_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Orang Filistin dong timbun sumur-sumur pake tana, smua sumur yang Isak pu bapa Abraham dong su gale itu. ");
INSERT INTO pmy_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Trus Abimelek bilang Isak begini, “Karna ko su lebi kuat dari kitong disini, jadi lebi baik ko kluar dari tana ini suda.” ");
INSERT INTO pmy_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Jadi suda, Isak de pinda dari situ, de bikin tenda di kota Gerar pu daera tana renda, trus de tinggal disitu brapa lama. ");
INSERT INTO pmy_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Baru Isak de gale lagi sumur-sumur yang perna orang gale waktu Abraham masi hidup, yang orang Filistin dong su timbun waktu Abraham de mninggal tu. Isak de gale baru de kas nama lagi pake nama yang dulu de pu bapa su kas nama. ");
INSERT INTO pmy_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Waktu Isak pu orang-orang kerja ni, dong ada gale-gale, begini dong gale pas di bagian mata air, jadi de pu air kluar banyak skali. ");
INSERT INTO pmy_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Trus begini, orang-orang dari kota Gerar yang jaga kambing domba ni, dong baku ribut deng Isak pu orang-orang yang jaga kambing domba. Orang-orang Gerar bilang, “Sumur ini tong punya!” Gara-gara itu yang, Isak de kas nama sumur itu deng nama Esek. ");
INSERT INTO pmy_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Trus Isak pu orang-orang kerja dong gale sumur lain lagi. Begini dong baku ribut gara-gara sumur itu lagi, jadi Isak kas nama sumur itu Sitna. ");
INSERT INTO pmy_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Isak dong pinda lagi trus dong gale sumur lain lagi. Disini baru, dong tra baku ribut gara-gara sumur, jadi Isak kas nama sumur ini Rehobot, karna TUHAN su kasi dong tempat yang luas, jadi dong su bisa tamba banyak disitu. ");
INSERT INTO pmy_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Dari Rehobot sini, Isak dong pinda ke Bersyeba. ");
INSERT INTO pmy_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Pas malam itu, TUHAN kas tunjuk De pu diri ke Isak trus bilang de begini, “Sa ini Allah yang ko pu bapa Abraham semba. Jang takut, karna Sa yang ada sama-sama deng ko. Nanti Sa kas berkat ko trus bikin ko pu anana cucu banyak, karna Sa su ikat janji deng Abraham, Sa pu pesuru itu.” ");
INSERT INTO pmy_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Habis itu, Isak de bikin tempat bakar korban, trus semba TUHAN. Trus dong bikin dong pu tenda disana baru Isak pu orang kerja dong gale sumur disitu. ");
INSERT INTO pmy_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Satu hari begini, raja Abimelek datang dari kota Gerar untuk ketemu Isak. Raja Abimelek de bawa de pu kepala tentara yang nama Pikol deng Ahuzat, orang yang biasa kasi naseat sama raja dia. ");
INSERT INTO pmy_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Jadi Isak tanya dong begini, “Kam datang ketemu sa untuk? Dulu kam yang tra snang trus usir sa dari kam pu tana baru?” ");
INSERT INTO pmy_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Trus dong jawab begini, “Skarang tong su tau kalo TUHAN yang ada sama-sama deng ko. Jadi, tong pikir lebi baik tong bikin janji deng ko. Ko sumpa ke kitong begini: ");
INSERT INTO pmy_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Ko trakan bikin jahat ke kitong, sama deng tong juga tra perna bikin jahat ke ko. Dulu tong su bikin baik ke ko deng kas tinggal ko kluar baik-baik dari tong pu tana to? Skarang tong su tau skali kalo memang TUHAN De yang kas berkat ko.” ");
INSERT INTO pmy_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Habis itu, Isak bikin acara makan-makan besar untuk dorang. Trus dong rame-rame makan deng minum. ");
INSERT INTO pmy_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Pas besok pagi baru, dong masing-masing bilang dong pu sumpa. Trus Isak bilang slamat jalan ke dorang baru dong baku pisa baik-baik. ");
INSERT INTO pmy_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Pas hari itu juga, Isak pu orang-orang kerja datang lapor tentang sumur yang dong gale. Dong bilang begini, “Bapa, kitong su ketemu air!” ");
INSERT INTO pmy_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Jadi suda, Isak de kas nama sumur itu Syeba. Dari sini yang tempat ini dapa nama Bersyeba sampe skarang. ");
INSERT INTO pmy_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Waktu Esau pu umur su masuk 40 taun, de kawin deng nona dua dari suku Het. Yang satu tu, bapa Beeri pu anak prempuan yang nama Yudit. Trus yang satu lagi, bapa Elon pu anak prempuan yang nama Basmat. ");
INSERT INTO pmy_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Prempuan dua ni, dong bikin Isak deng Ribka pu hati rasa tra snang skali. ");
INSERT INTO pmy_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Waktu Isak su tua, trus de pu mata su kabur skali sampe tra bisa liat lagi, de panggil Esau, de pu anak pertama ni. Trus de bilang begini, “Anak!” “Ya bapa?” Esau de jawab. ");
INSERT INTO pmy_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isak bilang, “Dengar baik-baik yang bapa mo bilang ini! Bapa ni su tua, baru tratau kapan bapa mninggal. ");
INSERT INTO pmy_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Jadi skarang, ambil ko pu pana deng busur, trus pigi ke daera sepi tempat buru binatang baru buru binatang satu untuk bapa. ");
INSERT INTO pmy_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Ko bikin makanan yang enak, bikin macam yang bapa snang makan. Habis itu, ko bawa kemari untuk bapa makan. Supaya seblum bapa mninggal, bapa kasi berkat ke ko.” ");
INSERT INTO pmy_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ribka de dengar yang Isak bilang ke Esau. Itu yang, waktu Esau de pigi ke daera sepi untuk mo buru binatang, ");
INSERT INTO pmy_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Ribka bilang sama de pu anak Yakub begini, “Mama tadi ada dengar, kalo ko pu bapa bilang ke ko pu kaka Esau begini, ");
INSERT INTO pmy_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Pigi buru binatang satu, trus masak enak-enak untuk bapa. Supaya habis makan itu, bapa kasi berkat ke ko di depan TUHAN, seblum bapa mninggal.’ ” ");
INSERT INTO pmy_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Trus Ribka lanjut bilang, “Jadi anak, nanti ko bikin macam yang mama suru ini: ");
INSERT INTO pmy_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Ko pigi ke tong pu kambing domba pu tempat, pili anana kambing yang gemuk dua. Bawa kesini supaya mama masak, bikin jadi makanan yang enak, macam yang ko pu bapa snang makan. ");
INSERT INTO pmy_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Habis itu, ko bawa ke ko pu bapa supaya de makan, trus nanti bapa kasi berkat ke ko, seblum ko pu bapa de mninggal.” ");
INSERT INTO pmy_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Tapi, Yakub de bilang de pu mama begini, “Mama, sa pu kaka Esau pu badan penu deng bulu-bulu, tapi sa pu badan trada bulu-bulu ni, bagemana? ");
INSERT INTO pmy_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Jang sampe nanti bapa pegang sa pu badan baru de tau kalo sa su tipu dia? Bukan berkat tapi, nanti kutuk yang sa dapat lagi.” ");
INSERT INTO pmy_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Trus de pu mama jawab, “Tra usa takut, biar nanti mama yang tanggung kalo ko dapa kutuk. Ko bikin saja yang mama suru. Ko pigi ambil kambing-kambing itu!” ");
INSERT INTO pmy_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Jadi Yakub de pigi ambil kambing-kambing, trus de bawa ke de pu mama Ribka. Ribka de masak makanan yang enak, yang Isak suka. ");
INSERT INTO pmy_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Trus Ribka de ambil de pu anak pertama Esau pu pakean paling bagus yang ada tasimpan dalam ruma, baru de kas pake ke Yakub, de pu anak bungsu ini. ");
INSERT INTO pmy_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Trus de pasang kulit-kulit dari anana kambing ni ke Yakub, untuk tutup Yakub pu tangan deng leher yang trada bulu itu. ");
INSERT INTO pmy_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Baru, makanan enak deng roti yang de bikin tu, de kasi ke Yakub. ");
INSERT INTO pmy_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Habis itu, Yakub pigi ke de pu bapa baru bilang, “Bapa!” “Yo, bagemana?” Isak de jawab. “Ko sapa, Esau ka Yakub?” ");
INSERT INTO pmy_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakub jawab, “Sa Esau, bapa pu anak yang tua. Yang bapa suru tu, sa su bikin. Bapa bangun trus duduk suda, makan daging binatang buru yang sa ada bawa ini. Supaya habis itu, bapa bisa kasi berkat ke saya.” ");
INSERT INTO pmy_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isak bilang, “Anak, ko dapat cepat skali?” Yakub jawab, “Itu karna TUHAN Allah yang bapa semba, De yang tolong sa untuk dapat ini!” ");
INSERT INTO pmy_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Trus Isak bilang Yakub, “Mari, datang ke dekat sini biar bapa bisa pegang ko, untuk tau kalo ko memang Esau ka bukan.” ");
INSERT INTO pmy_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jadi, Yakub de ke dekat de pu bapa. Waktu Isak pegang dia, Isak bilang begini, “Suara ni, Yakub pu suara. Tapi tangan ni, Esau pu tangan.” ");
INSERT INTO pmy_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Jadi de tratau kalo itu Yakub. Habis, de pu tangan ada bulu-bulu penu, sama macam de pu kaka Esau pu tangan. Waktu de su siap mo kasi berkat ke Yakub, ");
INSERT INTO pmy_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","de tanya lagi, “Betul to, ko ni sa pu anak Esau?” “Iyo bapa,” Yakub de bilang. ");
INSERT INTO pmy_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Trus Isak bilang, “Mari, kasi daging tu kesini! Biar bapa makan daging yang bapa pu anak su kas siap. Supaya habis makan, bapa bisa kasi berkat ni ke ko.” Jadi Yakub kasi makanan ke dekat de pu bapa, baru de pu bapa makan. Trus de pu bapa minum anggur yang Yakub ada bawa juga. ");
INSERT INTO pmy_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Habis itu, de pu bapa Isak bilang dia, “Mari anak, datang ke dekat sini trus ko cium bapa.” ");
INSERT INTO pmy_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Jadi Yakub ke dekat de pu bapa trus cium de pu bapa. Waktu Isak cium bau pakean yang Yakub pake, de kasi berkat ke Yakub. De bilang begini, “Memang benar, bau ini ni dari sa pu anak Esau. Ini bau dari daera sepi tempat buru binatang, yang dapa berkat dari TUHAN. ");
INSERT INTO pmy_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Sa minta Allah untuk kasi ko embun dari langit, trus kasi ko tana-tana subur di bumi sama gandum deng anggur yang banyak skali. ");
INSERT INTO pmy_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Bangsa-bangsa nanti kerja untuk ko. Suku-suku dari bangsa itu juga, nanti tunduk hormat ko sampe ke tana. Ko nanti jadi kepala dari ko pu sodara dorang. Ko pu mama pu anana cucu juga nanti tunduk hormat ko sampe ke tana. Kalo sapa saja yang kutuk ko, nanti de dapa kutuk. Trus sapa saja kas berkat ko, de nanti dapa berkat.” ");
INSERT INTO pmy_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Waktu Isak slesai kasi berkat untuk Yakub, pas Yakub baru saja kluar kas tinggal de pu bapa Isak ni, Yakub pu kaka Esau ni de pulang dari buru binatang. ");
INSERT INTO pmy_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","De juga bikin makanan enak baru bawa ke de pu bapa. De bilang ke de pu bapa begini, “Bapa, mari bangun. Bapa makan daging binatang yang sa baru dapat ini dulu, supaya bapa bisa kasi berkat ke saya.” ");
INSERT INTO pmy_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Trus Isak tanya, “Ko sapa?” De jawab, “Sa Esau, bapa. Bapa pu anak yang tua.” ");
INSERT INTO pmy_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isak de kaget skali sampe gementar. Trus Isak de bilang, “Baru, sapa yang tadi datang bawa daging yang de dapat trus kasi ke sa?! Sa su makan daging tu smua, seblum ko datang. Trus sa su kasi sa pu berkat tu ke dia. Sampe nanti juga, de tetap jadi orang yang dapat berkat itu!” ");
INSERT INTO pmy_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Waktu Esau dengar de pu bapa bilang begitu, de batariak kras-kras, de pu hati hancur skali. De bilang ke de pu bapa, “Bapa eee! Kasi berkat ke sa juga ka!” ");
INSERT INTO pmy_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Trus de pu bapa jawab dia, “Ko pu ade de su datang pura-pura jadi ko. Trus de su ambil berkat yang bapa mo kasi untuk ko.” ");
INSERT INTO pmy_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esau bilang lagi, “Memang, de cocok deng nama Yakub suda mo, su dua kali ni de tipu saya! Sa yang anak pertama yang pu hak, tapi de su ambil. Baru skarang! De ambil lagi berkat yang bapa mo kasi untuk saya.” Baru de bilang ke de pu bapa lagi, “Bapa, trada berkat lain lagi ka untuk sa?” ");
INSERT INTO pmy_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isak jawab Esau, de bilang begini, “Anak, bapa su angkat de untuk jadi kepala di atas ko. Sa su kasi de pu sodara smua untuk nanti jadi de pu budak. Berkat gandum deng anggur juga, sa su kasi dia. Jadi untuk ko, apa lagi yang sa bisa kasi, anak?” ");
INSERT INTO pmy_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau bilang sama de pu bapa, “Bapa, bapa pu berkat cuma satu itu saja ka? Tolong kasi berkat ke sa juga ka, bapa!” Trus de bongkar mnangis. ");
INSERT INTO pmy_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Esau pu bapa Isak ni bilang sama de begini, “Anak, tempat yang ko tinggal nanti tu, jau dari tana-tana yang subur di bumi ini, trus tempat itu juga jau dari embun dari langit yang bikin tana subur. ");
INSERT INTO pmy_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ko nanti cari hidup deng baku prang, baru ambil ko pu lawan pu barang-barang. Trus ko yang nanti kerja untuk ko pu ade. Tapi, satu hari nanti, kalo ko memang usaha sunggu-sunggu, nanti ko bisa bebas. Ko trakan kerja untuk ko pu ade lagi.” ");
INSERT INTO pmy_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esau ni de su emosi skali sama Yakub, gara-gara berkat yang dong pu bapa kasi ke Yakub. Jadi, Esau bilang ke de pu diri sendiri begini, “Bapa pu waktu su tra lama lagi. Habis bapa mninggal, trus waktu duka su slesai, sa nanti bunu sa pu ade.” ");
INSERT INTO pmy_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Waktu Ribka dapa dengar yang Esau ada rencana tu, de suru orang pigi panggil Yakub trus de kastau Yakub begini, “Ko pu kaka Esau de su emosi ko skali. De ada rencana mo bunu ko, supaya de bisa rasa tenang. ");
INSERT INTO pmy_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Jadi Yakub, skarang ko dengar yang mama mo bilang: Ko lari pigi ke Laban, mama pu sodara laki-laki yang tinggal di kota Haran itu. ");
INSERT INTO pmy_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Tinggal disitu brapa lama saja, sampe ko pu kaka pu mara deng ");
INSERT INTO pmy_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","de pu emosi ni hilang dulu, sampe de lupa apa yang ko su bikin ke dia. Nanti mama suru orang pigi jemput ko dari situ.” Ribka bicara lagi, “Sa tra mau kam dua dapa bunu. Masa tu dalam satu hari saja kam dua hilang dari saya.” ");
INSERT INTO pmy_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Trus Ribka bilang Isak, “Sa su cape skali gara-gara tong pu anana mantu Het itu. Kalo Yakub pu istri juga satu dari prempuan-prempuan yang ada di tempat ini, macam prempuan Het yang Esau pu istri dorang, lebi baik sa mati saja.” ");
INSERT INTO pmy_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Habis itu, Isak panggil Yakub trus kas berkat dia, baru pesan de begini, “Yakub, ko tra bole ambil prempuan Kanaan untuk jadi ko pu istri. ");
INSERT INTO pmy_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Skarang juga, ko pigi ke Padan-Aram, ke Betuel, ko pu mama pu bapa. Trus ambil istri satu untuk ko, dari ko pu mama pu sodara Laban pu anana prempuan. ");
INSERT INTO pmy_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Sa minta Allah Yang Pu Kuasa Paling Besar De kas berkat ko. De kasi ko anana cucu yang banyak, sampe ko nanti jadi moyang dari bangsa-bangsa yang banyak. ");
INSERT INTO pmy_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Biar berkat yang De kasi ke Abraham, de turun ke ko deng ko pu anana cucu dorang. Supaya tana yang ko ada tinggal jadi pendatang ni bisa jadi kam pu milik juga, tana yang Allah su kasi ke Abraham ini.” ");
INSERT INTO pmy_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Jadi begitu suda, Isak de kirim Yakub pigi. Habis itu, Yakub de jalan ke Padan-Aram, ke Betuel pu anak Laban, yang orang Aram itu. De itu Esau deng Yakub pu mama Ribka pu sodara laki-laki. ");
INSERT INTO pmy_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esau de tau kalo Isak su kas berkat Yakub baru kirim Yakub ke Padan-Aram untuk pigi cari istri disana. Esau de juga tau kalo waktu Isak kas berkat Yakub, de pesan begini, “Yakub, ko tra bole ambil prempuan Kanaan untuk jadi ko pu istri.” ");
INSERT INTO pmy_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Baru de liat kalo Yakub de dengar trus bikin yang de pu bapa deng mama bilang itu, Yakub de pigi ke Padan-Aram. ");
INSERT INTO pmy_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Dari situ yang, Esau de sadar langsung kalo de pu bapa Isak tra suka deng prempuan Kanaan itu. ");
INSERT INTO pmy_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Jadi, Esau de pigi ke Ismael yang tete Abraham pu anak untuk ambil Mahalat jadi de pu istri, tamba deng de pu istri dua yang su ada. Mahalat tu Ismael pu anak prempuan, Nebayot pu ade. ");
INSERT INTO pmy_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Waktu Yakub de jalan dari Bersyeba pigi ke kota Haran, ");
INSERT INTO pmy_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","de sampe di tempat satu. Karna su mo glap jadi de tinggal satu malam disitu. Yakub de ambil batu satu yang ada disitu untuk taru de pu kepala. Habis itu, de tidur di tempat situ. ");
INSERT INTO pmy_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Begini Yakub de mimpi. Di de pu mimpi tu de liat: Dari bumi ni, ada tangga yang de pu ujung tu sampe ke langit. Begini, ada Allah pu malaikat-malaikat yang jalan turun naik tangga itu. ");
INSERT INTO pmy_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Trus begini de liat TUHAN ada bediri di sebla, baru bilang de begini, “Sa ini TUHAN, ko pu tete Abraham pu Allah, juga Isak pu Allah. Tana tempat ko ada tidur ni, nanti Sa kasi itu ke ko deng ko pu anana cucu dorang. ");
INSERT INTO pmy_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ko pu anana cucu nanti banyak skali, macam debu tana pu banyak begitu. Baru dong nanti tamba banyak ke smua ara, dari timur sampe ke barat trus dari utara sampe ke slatan. Nanti lewat ko deng ko pu anana cucu, Sa kas berkat smua kluarga di dunia ini. ");
INSERT INTO pmy_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Dengar ini! Sa ada sama-sama deng ko. Kemana saja ko pigi, Sa yang nanti jaga ko. Nanti Sa bawa ko kembali ke negri ini. Karna Sa ini trakan kas tinggal ko. Mala, Sa juga tetap bikin yang Sa su janji ke ko itu.” ");
INSERT INTO pmy_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Waktu Yakub de bangun tidur, de bilang begini, “Sunggu! Memang TUHAN ada di tempat ini! Baru, masa sa tratau tu!” ");
INSERT INTO pmy_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Yakub de rasa takut langsung, trus de bilang begini, “Memang, tempat ini dasyat! Tra sala lagi, pasti ini Allah pu ruma, pasti ini surga pu pintu masuk.” ");
INSERT INTO pmy_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Pas besok, pagi-pagi skali Yakub de bangun trus ambil batu yang de pake taru kepala tu, trus de kas bediri batu itu untuk jadi tanda untuk kas ingat orang nanti. Trus de tumpa minyak ke bagian atas batu itu, untuk kas kusus itu. ");
INSERT INTO pmy_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","De kas nama tempat itu Betel, dulu tempat ini pu nama Lus. ");
INSERT INTO pmy_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Trus Yakub de ikat janji deng Allah begini, “Kalo nanti Allah De tetap ada sama-sama deng sa, trus De tetap jaga sa waktu sa ada jalan ni, trus kalo De kasi sa makanan deng pakean, ");
INSERT INTO pmy_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","supaya sa bisa kembali ke sa pu bapa pu ruma deng slamat, brarti nanti TUHAN jadi sa pu Allah. ");
INSERT INTO pmy_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Trus batu ini, yang sa su bikin jadi tanda untuk kas ingat orang, itu nanti jadi tempat untuk semba Allah disini. Juga, apa saja yang Tuhan kasi, nanti sa kasi seperspulu ke Tuhan.” ");
INSERT INTO pmy_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Habis itu, Yakub de lanjut jalan, de pigi ke orang-orang yang tinggal di sebla timur. ");
INSERT INTO pmy_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Waktu de su sampe, pas de ada liat-liat begini, de ketemu sumur di daera sepi tempat rumput saja. Trus de liat ada tiga rombongan kambing domba yang ada istirahat dekat situ, karna dari sumur ini orang biasa kas minum dong pu kambing domba. Baru sumur itu dong su tutup deng batu besar. ");
INSERT INTO pmy_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Kalo rombongan kambing domba smua su kumpul sama-sama baru, orang-orang yang jaga kambing domba tu dong nanti geser kas pinda batu itu dari sumur situ, trus dong kas minum dong pu kambing domba. Habis itu, dong kas kembali batu tu lagi ke atas sumur. ");
INSERT INTO pmy_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yakub de tanya orang-orang itu, “Sodara, kam ni dari mana ka?” Dong jawab, “Tong dari kota Haran.” ");
INSERT INTO pmy_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","De tanya dong lagi, “Kam tau bapa Laban ka? Nahor pu cucu tu?” Dong bilang, “Iyo, tong tau.” ");
INSERT INTO pmy_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Trus Yakub tanya dong lagi, “De baik-baik ka?” Dong jawab, “Iyo, de baik-baik. Itu liat! De pu anak prempuan Rahel ada datang deng de pu kambing domba tu.” ");
INSERT INTO pmy_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Baru, Yakub bilang dorang, “Sodara, kam liat! Matahari masi tinggi ni. Ini blum waktu untuk kas masuk binatang piara dalam kandang. Kam kas minum kam pu kambing domba, trus bawa dong kembali makan rumput suda.” ");
INSERT INTO pmy_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Tapi dong jawab, “Kitong tra bisa bikin begitu, rombongan kambing domba yang lain masi blum datang. Kalo dong ada baru, batu dari sumur ni bisa dapa geser kas pinda, trus tong bisa kas minum kambing domba smua.” ");
INSERT INTO pmy_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Waktu de ada bicara-bicara sama dong, Rahel datang deng de pu bapa pu kambing domba, karna de yang jaga kambing domba itu. ");
INSERT INTO pmy_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yakub liat Laban pu anak Rahel datang deng Laban pu kambing domba. Laban ni Yakub pu mama pu sodara. Pas liat Rahel begitu, Yakub de pigi geser kas pinda batu dari atas sumur trus de kas minum de pu om Laban pu kambing domba itu. ");
INSERT INTO pmy_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Habis itu, Yakub de pigi cium Rahel baru de bongkar mnangis skali. ");
INSERT INTO pmy_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Trus Yakub crita ke Rahel kalo de deng Rahel pu bapa masi kluarga, trus kalo Yakub de itu tanta Ribka pu anak. Jadi, Rahel lari pigi kastau de pu bapa. ");
INSERT INTO pmy_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Waktu Laban dengar crita tentang Yakub, de pu sodara pu anak ini, de langsung lari pigi sambut Yakub. De peluk trus cium Yakub juga, baru de bawa Yakub ke de pu ruma. Trus Yakub crita smua tentang dia ke Laban. ");
INSERT INTO pmy_vpl VALUES ("GN29_14a","002_29_14a","GEN","29","14a","14a","Baru Laban bilang dia, “Tra sala lagi! Ko deng sa memang satu dara. Ko ni sa pu kluarga suda.” ");
INSERT INTO pmy_vpl VALUES ("GN29_14b","002_29_14b","GEN","29","14b","14b","Yakub tinggal di Laban dong situ sampe su masuk satu bulan. ");
INSERT INTO pmy_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Baru Laban bilang Yakub begini, “Yakub, bukan brarti karna ko tu om pu kluarga jadi ko harus kerja untuk om baru tra dapa bayar to? Kastau om suda, ko mo dapa bayar brapa?” ");
INSERT INTO pmy_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Waktu itu, Laban pu anak prempuan ada dua. Yang tua, de pu nama Lea trus yang muda de pu nama Rahel. ");
INSERT INTO pmy_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea de pu mata tu mata sayup, tapi Rahel de pu badan lebi bagus baru de cantik. ");
INSERT INTO pmy_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakub de suka sama Rahel. Itu yang de bilang begini, “Om, sa mo kerja tuju taun baru nanti om bisa kasi Rahel, om pu anak yang lebi muda itu untuk jadi sa pu istri.” ");
INSERT INTO pmy_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban bilang, “Lebi baik sa kasi de ke ko daripada kasi ke orang lain. Jadi suda, ko tinggal kerja disini dulu suda.” ");
INSERT INTO pmy_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Jadi, Yakub kerja sampe tuju taun untuk dapat Rahel. Tapi karna de pu rasa suka sama Rahel, de rasa tu macam cuma brapa hari saja begitu. ");
INSERT INTO pmy_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Habis tuju taun tu, Yakub pigi bicara ke Laban, “Bapa, ini su pas tuju taun sa kerja. Jadi mari suda, bapa kasi sa pu calon istri, supaya sa bisa kawin deng dia.” ");
INSERT INTO pmy_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Jadi, Laban de undang orang-orang di tempat situ, baru de bikin acara nika ini. ");
INSERT INTO pmy_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Tapi, pas malam begini, de ambil de pu anak Lea trus bawa ke Yakub. Jadi Yakub de tidur deng Lea. ");
INSERT INTO pmy_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Laban juga su kasi de pu budak prempuan yang nama Zilpa untuk jadi Lea pu budak prempuan. ");
INSERT INTO pmy_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Pas besok pagi Yakub de liat begini, itu Lea! Jadi de pigi bicara deng Laban, “Knapa ko bikin begitu ke saya? Sa kerja untuk bisa dapat Rahel baru? Knapa ko tipu sa begini?” ");
INSERT INTO pmy_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban jawab dia, “Di tempat sini, ade tra bole lewat kaka begitu. Tong tra kas kawin ade lebi duluan daripada de pu kaka. ");
INSERT INTO pmy_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Jadi ko kas slesai satu minggu acara kawin ni dulu. Habis itu baru, tong kasi sa pu anak Rahel. Tapi, habis itu ko harus kerja tuju taun lagi.” ");
INSERT INTO pmy_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jadi, Yakub bikin macam begitu. De kas slesai de pu satu minggu deng Lea. Habis itu baru, Laban kasi de pu anak Rahel untuk jadi Yakub pu istri. ");
INSERT INTO pmy_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laban juga kasi de pu budak prempuan yang nama Bilha ke Rahel, untuk jadi Rahel pu budak prempuan. ");
INSERT INTO pmy_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yakub tidur deng Rahel juga. Baru de lebi sayang Rahel daripada Lea. Trus de lanjut kerja tuju taun lagi untuk Laban. ");
INSERT INTO pmy_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Waktu TUHAN liat Yakub de tra sayang Lea, TUHAN bikin Lea bisa dapat anak. Tapi Rahel de mandul. ");
INSERT INTO pmy_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea hamil trus de lahir anak laki-laki satu. De kas nama anak itu Ruben karna de bilang, “Ini karna TUHAN su liat sa pu susa. Skarang pasti sa pu suami mo sayang saya.” ");
INSERT INTO pmy_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Trus Lea hamil lagi baru de lahir anak laki-laki satu. De kas nama anak itu Simeon karna de bilang, “Memang! TUHAN su dengar kalo sa tra dapa sayang dari sa pu suami, trus De kasi anak ini untuk saya.” ");
INSERT INTO pmy_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Begini de hamil lagi trus de lahir anak laki-laki satu, trus de bilang begini, “Skarang sa deng sa pu suami bisa lebi dekat lagi, karna sa su lahir anak laki-laki tiga untuk dia.” Dari situ, de kas nama de pu anak itu Lewi. ");
INSERT INTO pmy_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Trus begini, de hamil lagi trus de lahir anak laki-laki satu lagi. Trus de bilang, “Skarang, sa hanya mo puji TUHAN.” Itu yang, de kas nama anak itu Yehuda. Habis itu, de su tra hamil lagi. ");
INSERT INTO pmy_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Waktu Rahel liat kalo de tra bisa lahir anak untuk Yakub, de iri hati skali deng de pu kaka. Jadi de bilang Yakub begini, “Bikin bagemana ka, supaya sa bisa pu anak juga. Kalo trada ni lebi baik sa mati saja.” ");
INSERT INTO pmy_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Langsung Yakub jadi mara sama Rahel. De bilang, “Ko pikir sa ni yang ganti Allah ka? Memang sa ka yang bikin sampe ko tra bisa dapat anak?” ");
INSERT INTO pmy_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Trus Rahel bilang, “Ini Bilha, sa pu budak prempuan. Ko tidur deng dia, supaya sa bisa angkat anak yang de lahir tu jadi sa pu anak sendiri. Trus sa juga bisa punya anana cucu.” ");
INSERT INTO pmy_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Rahel kasi de pu budak prempuan yang nama Bilha tu ke Yakub untuk kawin deng Yakub. Jadi, Yakub tidur deng budak prempuan itu. ");
INSERT INTO pmy_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Begini, Bilha de hamil baru de lahir anak laki-laki satu untuk Yakub. ");
INSERT INTO pmy_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Baru Rahel bilang begini, “Allah su kas tunjuk kalo sa benar. Allah juga su dengar yang sa minta trus kasi sa anak laki-laki satu.” Itu jadi, de kas nama anak itu Dan. ");
INSERT INTO pmy_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Rahel pu budak prempuan yang nama Bilha tu de hamil lagi trus de lahir anak laki-laki yang kedua untuk Yakub. ");
INSERT INTO pmy_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Baru Rahel bilang lagi, “Sa su usaha stenga mati lawan sa pu kaka, trus sa yang menang.” Itu yang, de kas nama anak itu Naftali. ");
INSERT INTO pmy_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Waktu Lea liat kalo de su tra bisa pu anak lagi, de ambil de pu budak prempuan yang nama Zilpa tu baru de kasi ke Yakub untuk kawin deng Yakub. ");
INSERT INTO pmy_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Trus Lea pu budak Zilpa tu de hamil baru de lahir anak laki-laki satu untuk Yakub. ");
INSERT INTO pmy_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Jadi Lea bilang begini, “Sa memang paling untung skali.” Itu jadi, de kas nama anak itu Gad. ");
INSERT INTO pmy_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Trus Lea pu budak prempuan Zilpa ni de hamil lagi baru de lahir anak yang kedua untuk Yakub. ");
INSERT INTO pmy_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Jadi Lea bilang, “Sa ni orang yang paling bahagia skali! Skarang prempuan-prempuan pasti mo bilang kalo sa ni orang yang paling bahagia.” Itu yang, de kas nama de pu anak tu Asyer. ");
INSERT INTO pmy_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Waktu pas musim panen gandum begini, Ruben de jalan-jalan baru de dapa liat tanaman satu di daera tempat tanam gandum, tanaman yang de pu akar tu obat. Ruben bawa tanaman ni ke de pu mama Lea. Baru Rahel de bilang sama Lea, “Sa bisa minta ko pu tanaman obat tu sdikit ka? Yang ko pu anak Ruben bawa itu.” ");
INSERT INTO pmy_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Lea jawab, “Sa pu suami yang ko ambil tu tra cukup ka? Skarang ko masi brani minta tanaman obat yang sa pu anak dapat?” Rahel bilang, “Kalo begitu, malam ini biar Yakub tidur deng ko. Tapi ko kasi sa tanaman obat itu bole.” ");
INSERT INTO pmy_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Jadi waktu sore Yakub de pulang dari daera tempat tanam gandum begini, Lea kluar ketemu dia baru bilang, “Ko harus tidur deng sa malam ini karna sa su bayar deng tanaman obat yang sa kasi ke Rahel. Padahal tanaman obat itu sa pu anak bawa untuk saya.” Jadi Yakub pi tidur deng Lea malam itu. ");
INSERT INTO pmy_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Allah dengar Lea de pu doa, itu yang Lea de hamil trus de lahir anak yang kelima untuk Yakub. ");
INSERT INTO pmy_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Trus Lea bilang, “Karna sa kasi sa pu budak prempuan ke sa pu suami, jadi Allah kasi sa pu bagian untuk apa yang sa su bikin.” Itu yang, de kas nama de pu anak ini Isakar. ");
INSERT INTO pmy_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Begini Lea hamil lagi trus de lahir anak keenam untuk Yakub. ");
INSERT INTO pmy_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Lea bilang, “Allah su kasi hadia yang bagus skali untuk saya. Skarang sa pu suami pasti tunjuk hormat ke saya, karna sa su lahir anak laki-laki enam orang untuk dia.” Itu yang de kas nama de pu anak tu Zebulon. ");
INSERT INTO pmy_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Habis itu, de juga lahir anak prempuan satu trus de kas nama anak itu Dina. ");
INSERT INTO pmy_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Trus, Allah juga ingat ke Rahel. Allah dengar yang Rahel minta trus bikin de juga bisa hamil. ");
INSERT INTO pmy_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Jadi, Rahel de hamil trus de lahir anak laki-laki satu. Rahel bilang begini, “Allah su bikin sampe sa tra rasa malu lagi skarang.” ");
INSERT INTO pmy_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Jadi de kas nama anak itu Yusup, trus de bilang, “Biar TUHAN mo tamba anak laki-laki satu lagi untuk saya.” ");
INSERT INTO pmy_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Stela Rahel de lahir Yusup, Yakub pigi bilang de pu bapamantu Laban begini, “Bapa, kas ijin sa pigi ka, supaya sa pulang ke sa pu tana, tempat sa lahir. ");
INSERT INTO pmy_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Kasi sa pu anana deng istri-istri yang bapa su bayar ke sa waktu sa kerja untuk bapa disini suda. Supaya sa bisa pulang deng dorang. Bapa tau to, sa su kerja stenga mati.” ");
INSERT INTO pmy_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Tapi Laban bilang sama dia, “Kalo ko snang deng saya, ko dengar yang sa mo bilang dulu. Dari tanda yang sa su dapa ni, sa tau kalo TUHAN su kas berkat sa karna ko ada disini jadi.” ");
INSERT INTO pmy_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Trus Laban de bilang lagi, “Ko tinggal suda! Ko kastau sa, ko mo dapa bayar brapa? Nanti sa pasti kasi.” ");
INSERT INTO pmy_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yakub jawab de pu bapamantu, “Bapa sendiri su tau to, sa kerja ni macam bagemana, trus bapa pu binatang piara pu keadaan bagemana waktu sa yang jaga binatang-binatang itu. ");
INSERT INTO pmy_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Karna waktu sa datang kesini, bapa pu barang-barang blum banyak macam skarang ini. Dimana saja sa kerja, disitu bapa pasti dapa berkat dari TUHAN. Tapi skarang sa mo kerja untuk sa pu kluarga sendiri juga.” ");
INSERT INTO pmy_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Laban jawab, “Apa yang ko mau sa kasi ke ko?” Yakub jawab, “Bapa tra usa kasi sa apapa. Sa mo jaga liat bapa pu kambing domba lagi, tapi bapa kas ijin sa ka, untuk bikin begini: ");
INSERT INTO pmy_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Hari ini sa mo lewat dari tenga-tenga bapa pu kambing domba smua itu. Trus nanti sa kas kluar stiap binatang yang bintik-bintik deng yang strep-strep, juga smua anak domba yang hitam sama kambing yang strep-strep deng bintik-bintik. Itu sa pu bagian. ");
INSERT INTO pmy_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Nanti besok-besok kalo bapa datang trus priksa sa pu kambing domba yang jadi sa pu bagian, bapa bisa tau kalo sa ni memang jujur ka trada. Kalo kambing-kambing smua yang sa punya itu ada yang trada bintik-bintik deng strep-strep, trus kalo ada domba-domba tra hitam, brarti bapa bisa pikir saja kalo memang sa ni yang curi.” ");
INSERT INTO pmy_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Trus Laban bilang, “Iyo, tong bikin macam yang ko bilang itu suda.” ");
INSERT INTO pmy_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Tapi, hari itu juga Laban de langsung pigi kas pisa de pu kambing jantan yang ada strep-strep. Trus de kas pisa smua kambing betina yang ada bintik-bintik deng strep-strep. Jadi, smua kambing yang ada warna puti, de kas pisa sendiri. Trus anana domba yang warna hitam juga, de kas pisa sendiri. Habis itu, de kasi kambing domba yang de su kas pisa tu ke de pu anana laki-laki lain untuk jaga liat. ");
INSERT INTO pmy_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Jadi, Laban deng de pu anana laki-laki dong bawa binatang-binatang itu pigi jau-jau, de pu jau tu macam tiga hari jalan kaki begitu. Yakub de tetap tinggal jaga liat Laban pu kambing domba yang dong ada kas tinggal tu. ");
INSERT INTO pmy_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Tapi, Yakub de ambil batang kayu hijou dari pohon hawar, pohon almon, deng pohon berangan. De kas lepas batang-batang itu pu kulit sbagian, sampe batang itu ada kliatan de pu kayu warna puti bagian dalam, trus de pu bentuk tu macam strep-strep. ");
INSERT INTO pmy_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Trus de taru batang-batang kayu yang de su bikin tu dalam tempat yang kambing domba biasa pake minum. Jadi waktu kambing domba ni dong minum, batang kayu tu pas depan dong pu mata. De taru itu karna kambing domba ni waktu dong minum, biasa dong suka kawin-kawin juga. ");
INSERT INTO pmy_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Kalo kambing domba ni dong kawin dekat batang yang de taru itu, nanti dong branak kambing domba yang ada bintik-bintik deng strep-strep. ");
INSERT INTO pmy_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Habis itu, Yakub de kas pisa anana domba itu. Baru, Yakub bikin kambing domba yang lain dong pu kepala baku hadap deng Laban pu kambing domba yang ada strep-strep deng kambing domba yang warna hitam. Jadi begitu suda, Yakub dapat kambing domba sendiri. De kas pisa de pu kambing domba sendiri dari Laban pu kambing domba. ");
INSERT INTO pmy_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Trus stiap kambing domba yang kuat-kuat dong mo kawin, Yakub de taru batang itu dalam kambing domba pu tempat minum, pas di depan dong pu mata. Supaya dong kawin dekat batang-batang yang de taru itu. ");
INSERT INTO pmy_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Tapi kalo yang datang kambing domba yang loyo-loyo, de tra taru batang-batang yang de bikin tu dalam air. Jadi, Laban pu binatang tu yang loyo-loyo trus Yakub pu binatang tu yang kuat-kuat. ");
INSERT INTO pmy_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Dari situ yang, Yakub pu barang-barang jadi tamba banyak skali. De pu kambing domba, unta, kledai, budak prempuan deng budak laki-laki juga, smua de punya. ");
INSERT INTO pmy_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Begini Yakub de dengar kalo de pu ipar-ipar, Laban pu anana laki-laki ni bicara begini, “Yakub ni de su ambil tong bapa pu harta deng barang smua. Harta yang bikin de kaya skali tu, de ambil dari tong pu bapa tu.” ");
INSERT INTO pmy_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Trus Yakub juga de liat dari Laban pu muka ni, Laban su mulai bikin muka tra baik ke dia, su tra sama macam dulu lagi. ");
INSERT INTO pmy_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Baru TUHAN bilang sama Yakub, “Pulang suda. Kembali ke ko pu bapa dong, ke ko pu kluarga dorang. Sa nanti ada sama-sama deng ko.” ");
INSERT INTO pmy_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Jadi, Yakub de suru orang pigi panggil Rahel deng Lea untuk ketemu de di daera sepi tempat biasa de jaga liat kambing domba. ");
INSERT INTO pmy_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Pas dong dua datang, de bilang ke dong dua, “Sa su liat dari kam pu bapa pu muka ni, su tra macam dulu lagi, de su mulai bikin muka tra baik ke saya. Tapi Allah yang sa pu bapa semba, De yang tetap ada sama-sama deng saya. ");
INSERT INTO pmy_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Kam juga su tau to, sa ni memang su kerja betul-betul skali untuk kam pu bapa. ");
INSERT INTO pmy_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Tapi kam pu bapa su tipu-tipu saya. De su ganti sa pu ongkos kerja sampe ulang-ulang. Tapi Allah tra kas tinggal de bikin jahat ke saya. ");
INSERT INTO pmy_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Kalo de bilang de mo bayar sa deng kambing domba yang ada bintik-bintik, kambing domba dong smua branak anana yang ada bintik-bintik. Tapi kalo de bilang de mo bayar sa deng yang ada strep-strep, kambing domba dong branak anana yang ada strep-strep. ");
INSERT INTO pmy_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Jadi begitu suda, Allah ambil kam pu bapa pu binatang piara untuk kasi ke saya. ");
INSERT INTO pmy_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Satu kali pas kambing domba pu musim kawin begini, sa ada dapat mimpi. Sa liat di mimpi tu, kambing domba jantan yang kawin deng kambing domba lain tu, dong ada strep-strep trus ada juga yang bintik-bintik. ");
INSERT INTO pmy_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Trus dalam mimpi tu, Allah pu Malaikat bicara sama saya. De bilang begini, ‘Yakub!’ Sa jawab, ‘Ya, Tuhan!’ ");
INSERT INTO pmy_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Trus Malaikat De bilang lagi, ‘Angkat ko pu muka trus ko liat! Smua kambing domba jantan yang ada kawin tu, dong smua ada strep-strep deng bintik-bintik to? Itu karna, Sa su liat apa yang Laban de bikin ke ko. ");
INSERT INTO pmy_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Sa ni Allah yang di Betel tu, tempat yang ko ikat janji ke Saya, deng ko ada tumpa minyak di batu untuk kas kusus itu. Batu yang ko kas bediri untuk kas ingat ko deng apa yang su jadi disitu. Jadi skarang juga, ko siap-siap trus pigi ke tana tempat ko lahir.’” ");
INSERT INTO pmy_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Trus Rahel deng Lea dong dua bilang ke de begini, “Tong dua su trada hak deng harta di tong pu bapa ruma juga mo. ");
INSERT INTO pmy_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Bapa de su jual tong dua, baru hasil jual tu, smua de su kas habis. Kitong su dapa bikin macam orang lain ka. ");
INSERT INTO pmy_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Smua harta deng barang yang Allah su ambil dari tong pu bapa, itu tong deng tong pu anana punya. Jadi skarang, ko bikin saja apa yang Allah suru ke ko.” ");
INSERT INTO pmy_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Jadi Yakub siap-siap. De kas naik de pu istri-istri deng de pu anana dong ke atas unta. ");
INSERT INTO pmy_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","De bawa de pu kambing domba deng smua binatang piara yang lain, lapis deng de pu barang-barang smua yang de dapat di Padan-Aram, untuk pigi ke de pu bapa Isak di tana Kanaan. ");
INSERT INTO pmy_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Waktu itu, Laban ada pigi gunting de pu domba-domba pu bulu. Baru waktu itu juga, Rahel de curi de pu bapa pu patung-patung terafim yang de pu bapa biasa semba. ");
INSERT INTO pmy_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Trus Yakub ni de tipu de pu bapamantu Laban tu waktu de pigi tra bilang-bilang Laban, orang Aram itu. ");
INSERT INTO pmy_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Jadi begitu suda, de lari dari Laban bawa de pu harta smua. De jalan pigi, trus mnyebrang kali Efrat baru jalan ke gunung-gunung di Gilead. ");
INSERT INTO pmy_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Su pas tiga hari begini, ada yang kasi kabar ke Laban kalo Yakub de su lari. ");
INSERT INTO pmy_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Langsung Laban bawa brapa orang dari de pu kluarga ni deng dia, dong pigi kejar Yakub. Habis dong su kejar sampe tuju hari, dong ketemu Yakub di gunung-gunung di daera Gilead. ");
INSERT INTO pmy_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Pas malam begini, Allah datang dalam mimpi ke Laban, orang Aram tu. Trus Allah bilang dia, “Hati-hati! Jaga ko pu mulut waktu ko bicara deng Yakub!” ");
INSERT INTO pmy_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Waktu Laban ketemu Yakub, Yakub de su pasang tenda di daera gunung-gunung situ, jadi Laban deng de pu kluarga dong pasang tenda di gunung-gunung Gilead situ juga. Pas Laban pigi ketemu Yakub, ");
INSERT INTO pmy_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Laban de bilang begini sama Yakub, “Knapa ko bikin klakuan tra baik ke sa begini? Su begitu, ko bawa lari sa pu anana prempuan macam dong ni orang yang dapa kurung mati ka. ");
INSERT INTO pmy_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Knapa ko pigi diam-diam? Knapa ko tipu sa begini? Coba ko kastau sa ka, supaya sa bisa antar kam deng prasaan snang, deng acara pisa pake rebana sama kecapi deng mnyanyi. ");
INSERT INTO pmy_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ko juga tra kasi sa waktu untuk sayang sa pu cucu-cucu laki-laki deng sa pu anana prempuan untuk lepas dong pigi. Knapa ko tra pikir baik yang ko bikin ini? ");
INSERT INTO pmy_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Kalo sa mau, sa bisa kas hancur kam pu hidup. Tapi tadi malam, Allah yang ko pu bapa semba, De su bilang sama sa begini, ‘Hati-hati! Jaga ko pu mulut waktu ko bicara deng Yakub!’ ");
INSERT INTO pmy_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Jadi skarang, kalo memang ko harus pigi karna ko su rindu skali deng ko pu bapa dong pu ruma, knapa ko pigi curi sa pu patung-patung yang sa semba itu?” ");
INSERT INTO pmy_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Trus Yakub bilang Laban, “Sa takut, bapa. Habis, sa pikir jang sampe nanti bapa ambil bapa pu anana prempuan dari sa lagi. ");
INSERT INTO pmy_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Tapi, kalo bapa ketemu patung yang bapa semba tu di sapa saja, jang kas tinggal de tetap hidup. Di depan tong pu orang-orang smua ni, bapa priksa suda! Kalo memang ada bapa pu barang-barang di sa pu barang smua ni, bapa ambil kembali saja.” Yakub de tratau kalo Rahel yang curi patung itu. ");
INSERT INTO pmy_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Jadi suda, Laban de pigi cek Yakub pu tenda. Habis itu de ke Lea pu tenda trus de ke budak prempuan dua ni pu tenda, tapi de tra ketemu patung-patung yang de semba tu. Habis kluar dari Lea pu tenda, de masuk ke Rahel pu tenda. ");
INSERT INTO pmy_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Tapi Rahel su kas sembunyi patung yang de pu bapa semba itu. De kas masuk dalam sak-sak yang biasa dong kas pake di unta, baru de duduk di atas sak-sak itu. Laban de priksa-priksa Rahel pu tenda baik-baik, tapi de tra ketemu de pu patung. ");
INSERT INTO pmy_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Baru Rahel bilang ke de pu bapa begini, “Bapa, jang mara eh. Sa tra bisa bangun untuk bediri depan bapa, habis sa ada datang bulan jadi.” Jadi, Laban de su cari baik-baik skali tapi tra ketemu patung itu. ");
INSERT INTO pmy_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Suda. Yakub de langsung emosi skali. De bilang sama Laban begini, “Sa pu sala apa ka? Sa bikin dosa apa sampe bapa ko cari sa macam begini? ");
INSERT INTO pmy_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Bapa ko su priksa sa pu barang smua. Skarang, ada bapa pu barang yang bapa ketemu ka? Mari! Bawa taru depan sa deng ko pu orang-orang ini, biar dong yang kas tunjuk sapa yang sala, bapa ka saya? ");
INSERT INTO pmy_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Su 20 taun, sa ada sama-sama deng bapa dorang. Bapa pu domba deng kambing betina pu anana tra perna mati waktu masi dalam perut. Trus, yang bapa pu domba jantan juga, sa tra perna ambil untuk sa makan. ");
INSERT INTO pmy_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Kambing domba yang dapa makan sama binatang liar juga, sa tra kas tunjuk ke bapa, tapi sa sendiri yang ganti itu. Baru yang dapa curi dari orang lain, mo itu siang ka malam ka, bapa tinggal tuntut sa yang ganti trus. ");
INSERT INTO pmy_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Siang, matahari bakar saya, malam juga, sa dingin stenga mati. Tra perna skali sa bisa tidur sono. ");
INSERT INTO pmy_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Su 20 taun sa di bapa pu ruma. Sa su kerja sampe 14 taun untuk dapat bapa pu anak prempuan dua ni. Trus sa kerja enam taun lagi, untuk dapat binatang piara ni. Su begitu, bapa tinggal ganti-ganti sa pu ongkos kerja trus. ");
INSERT INTO pmy_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Kalo Allah yang sa pu tete Abraham deng sa pu bapa Isak dong semba De tra sama-sama deng saya, pasti skarang bapa ko su kas biar sa pulang deng tra bawa apapa. Tapi Allah De ada liat sa pu susa deng sa pu kerja stenga mati ni. Jadi tadi malam, De su kas tunjuk De pu adil ke bapa.” ");
INSERT INTO pmy_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Habis itu, Laban bilang ke Yakub begini, “Prempuan dua ni, sa pu anana. Dong pu anana ni juga, sa pu cucu-cucu. Trus binatang-binatang piara ni, ini juga sa punya. Smua yang ko ada liat disini, itu sa punya. Tapi mo bagemana lagi? Sa su tra bisa bikin apapa untuk tahan sa pu anana prempuan deng sa pu cucu-cucu lagi skarang. ");
INSERT INTO pmy_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Jadi skarang, mari tong dua ikat janji deng bikin tanda. Supaya tanda itu nanti bisa kas ingat kitong dua deng tong dua pu janji ini.” ");
INSERT INTO pmy_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Yakub lanjut ambil batu satu. Trus de kas bediri batu tu untuk jadi tanda yang nanti kas ingat dong dua. ");
INSERT INTO pmy_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Habis itu Yakub bilang ke de pu orang-orang begini, “Mari, kam juga kumpul batu.” Jadi, dong ambil batu trus tumpuk disitu. Habis itu, dong smua duduk makan sama-sama, dekat batu yang dong tumpuk itu. ");
INSERT INTO pmy_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban kas nama batu yang dong su tumpuk tu Yegar-Sahaduta. Yakub kas nama batu-batu itu Galed. ");
INSERT INTO pmy_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Trus Laban bilang begini, “Batu-batu yang tong tumpuk hari ini, ini yang jadi tanda untuk kas ingat sa deng ko.” Dari situ yang, tempat itu dapat nama Galed. ");
INSERT INTO pmy_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Dong juga kas nama tempat itu Mizpa, karna de bilang begini, “Waktu tong tra baku liat, biar nanti TUHAN yang jaga liat apa yang sa deng ko bikin.” ");
INSERT INTO pmy_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Trus Laban bilang lagi, “Kalo ko bikin yang tra baik ke sa pu anana prempuan, ato kalo ko pigi ambil istri lain, tamba deng sa pu anana prempuan ini, biar trada yang tau itu tapi, ko ingat ini baik-baik! Allah, De yang jaga liat apa yang sa deng ko bikin.” ");
INSERT INTO pmy_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Baru Laban de tamba bilang begini lagi ke Yakub, “Ko liat batu yang su tatumpuk ni deng batu yang ada bediri yang kas ingat sa deng ko! ");
INSERT INTO pmy_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Batu yang ada tatumpuk deng batu yang ada bediri itu, dong tu tanda kalo sa trakan lewat dari batu yang tatumpuk ini untuk pigi bikin jahat ke ko. Batu yang tatumpuk deng bediri ini juga jadi tanda yang kas ingat ko, kalo ko trakan lewat dari batu-batu ini untuk pigi bikin jahat ke saya. ");
INSERT INTO pmy_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Biar Allah dari ko pu tete Abraham, sa pu tete Nahor, deng dong dua pu bapa pu Allah, itu yang kas tunjuk sapa yang sala deng sapa yang benar, kalo ada masala antara sa deng ko.” Jadi, Yakub sumpa deng nama Allah yang de pu bapa Isak semba. ");
INSERT INTO pmy_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Trus di gunung situ, Yakub de potong binatang untuk kasi korban ke Allah. De undang de pu orang smua, dong duduk makan sama-sama. Trus dong tidur di gunung situ malam itu. ");
INSERT INTO pmy_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Pas besok begini, masi pagi-pagi skali, Laban de su datang cium de pu cucu-cucu deng de pu anana prempuan. Trus Laban de kas berkat dorang. Habis itu, Laban de jalan pulang kembali ke de pu tempat tinggal. ");
INSERT INTO pmy_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Trus, Yakub dong lanjut jalan. Begini, de baku ketemu deng Allah pu malaikat-malaikat. ");
INSERT INTO pmy_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Waktu Yakub liat dorang, de langsung bilang, “Sunggu! Allah pu pasukan dong ada disini.” Jadi de kas nama tempat itu Mahanaim. ");
INSERT INTO pmy_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Habis itu, Yakub de suru orang brapa begitu, untuk jalan duluan ke tana Seir di daera Edom, pigi ketemu de pu kaka Esau duluan. ");
INSERT INTO pmy_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","De suru dong begini, “Kam bilang ke bapa Esau, ke orang yang sa hormati tu begini, ‘Ini bapa Yakub pu pesan: Sa ini Yakub, ko pu pesuru. Sa su lama tinggal di Laban pu tempat, jadi orang pendatang disana. ");
INSERT INTO pmy_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Skarang sa su ada sapi, kledai, kambing domba, deng budak-budak. Sa suru orang datang ke bapa untuk kastau kalo sa ada datang, supaya bapa bisa kas tunjuk bapa pu baik ke saya.’ ” ");
INSERT INTO pmy_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Habis orang brapa yang bawa pesan tu kembali ke Yakub, dong bilang begini, “Tong su pigi ketemu bapa pu kaka Esau itu. Bapa Esau de ada jalan kemari, mo ketemu deng bapa. De ada bawa 400 orang sama-sama deng de juga.” ");
INSERT INTO pmy_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Dengar begitu, Yakub langsung stres gara-gara takut skali. De langsung bagi de pu orang-orang yang ada jalan sama-sama tu, jadi dua rombongan. De juga bagi de pu kambing domba, de pu sapi, unta-unta smua untuk jalan dalam dua rombongan itu. ");
INSERT INTO pmy_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Karna de pikir begini, “Kalo sampe Esau datang mo srang, trus rombongan yang satu ni dong smua kala, brarti rombongan yang satu lagi bisa lari kas slamat dong pu diri.” ");
INSERT INTO pmy_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Habis itu Yakub de minta ke Allah begini, “Allah! Allah yang sa pu tete Abraham deng sa pu bapa Isak semba. TUHAN, Ko yang perna bilang ke sa begini, ‘Pulang suda. Kembali ke ko pu tana, tempat ko lahir, ke ko pu kluarga dorang. Nanti Sa bikin baik ke ko.’ ");
INSERT INTO pmy_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Tuhan, sa ni paling tra pantas skali mo dapat Tuhan pu setia deng baik smua, sa yang budak saja ini. Waktu dulu sa mnyebrang kali Yordan, sa hanya ada tongkat spanggal ini saja untuk jalan. Tapi skarang, sa su bisa bagi smua yang sa punya ni jadi dua rombongan begini. ");
INSERT INTO pmy_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Sa mohon Tuhan, tolong kas slamat sa dari sa pu kaka Esau ini, karna sa takut dia. Jang sampe de nanti datang bunu sa deng sa pu istri dong ini lapis deng sa pu anana juga. ");
INSERT INTO pmy_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Tapi Tuhan su bilang sa begini to, ‘Sa pasti bikin baik ke ko, trus bikin ko pu anana cucu nanti banyak macam pasir di laut begitu, sampe tra bisa hitung lagi.’ ” ");
INSERT INTO pmy_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Malam itu, Yakub de tetap tinggal disitu. Dari yang de punya, Yakub ambil barang-barang yang de mo kasi hadia untuk Esau. ");
INSERT INTO pmy_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","De kas pisa kambing betina 200 deng kambing jantan 20, trus domba betina 200 deng domba jantan 20. ");
INSERT INTO pmy_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Unta yang masi kasi susu 30, tamba deng unta pu anana juga. Trus sapi betina 40 deng sapi jantan spulu. Tamba lagi kledai betina 20 deng kledai jantan spulu. ");
INSERT INTO pmy_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","De kasi itu smua ke de pu budak-budak untuk dong jaga di dong pu rombongan sendiri-sendiri. Trus de bilang dorang begini, “Kam jalan duluan. Kam baku jaga jarak waktu jalan eh. Jang sampe kam jalan baku dekat deng rombongan yang lain.” ");
INSERT INTO pmy_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Trus de suru rombongan yang jalan paling duluan begini, “Kalo sa pu kaka Esau baku dapat deng kam, trus de tanya, ‘Kam pu tuan sapa? Trus kam mo pigi kemana ini? Baru binatang-binatang piara yang depan kam ni, sapa punya?’ ");
INSERT INTO pmy_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Kam jawab begini, ‘Ini bapa pu pesuru yang nama Yakub punya. Ini hadia yang de kirim untuk bapa Esau. Trus, de ada datang dari blakang tu.’” ");
INSERT INTO pmy_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Yakub de juga suru rombongan yang nomor dua, deng rombongan yang nomor tiga, trus de bilang juga ke smua orang yang ada jalan sama-sama deng binatang-binatang yang de su bagi-bagi itu. De bilang begini, “Waktu kam ketemu deng Esau, kam juga bilang ke Esau macam yang sa su bilang tadi tu eh. ");
INSERT INTO pmy_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Trus kam bilang lagi, ‘Bapa pu pesuru yang nama Yakub, de ada datang dari blakang.’” Yakub de bilang begitu karna de pikir begini, “Biar sa kas tenang de pu hati deng hadia-hadia yang ada dapa antar duluan ini dulu. Habis itu baru, nanti sa pi ketemu dia. Mungkin deng begitu, de bisa trima sa kembali.” ");
INSERT INTO pmy_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Jadi, Yakub de pu hadia-hadia untuk Esau tu jalan duluan, tapi malam itu Yakub de tinggal di tenda yang dong bikin disitu. ");
INSERT INTO pmy_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Skarang begini, pas malam itu juga, Yakub de bangun trus de bawa de pu istri dua, de pu budak prempuan dua ni, sama de pu anana laki-laki yang 11 orang itu. Dong pigi mnyebrang dari tempat dangkal yang ada di kali Yabok ini. ");
INSERT INTO pmy_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Habis de kas mnyebrang dong smua ke kali pu sebla, de kas mnyebrang de pu barang-barang smua juga. ");
INSERT INTO pmy_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Yakub de tinggal sendiri saja di sebla kali situ. Begini, ada laki-laki satu yang datang trus baku banting deng Yakub sampe su mo masuk pagi. ");
INSERT INTO pmy_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Waktu orang itu de rasa kalo de tra bisa kas kala Yakub, de pukul Yakub pu ujung atas paha, sampe Yakub pu tulang paha tasala. ");
INSERT INTO pmy_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Trus orang itu de bilang Yakub, “Karna matahari su mo muncul jadi, kas tinggal sa pigi suda.” Tapi Yakub bilang, “Sa trakan kas biar ko pigi, kalo ko tra kas berkat sa dulu.” ");
INSERT INTO pmy_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Orang itu de tanya, “Ko pu nama sapa?” Yakub bilang, “Sa Yakub.” ");
INSERT INTO pmy_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Orang itu bilang lagi, “Ko pu nama bukan Yakub lagi. Skarang ko pu nama Israel, karna ko su baku lawan sama Allah deng manusia, trus ko su menang.” ");
INSERT INTO pmy_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Yakub bilang, “Bapa, bilang bapa pu nama dulu ka?” Tapi orang itu de jawab, “Ko tanya sa pu nama untuk?” Habis itu, de kas berkat Yakub disitu. ");
INSERT INTO pmy_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Trus Yakub de kas nama tempat itu Pniel, karna de bilang, “Sa su baku hadap muka deng Allah langsung, tapi sa masi hidup!” ");
INSERT INTO pmy_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Pas waktu Yakub jalan kas tinggal Pniel, matahari muncul. Yakub de jalan pincang gara-gara de pu paha atas yang tasala. ");
INSERT INTO pmy_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Itu yang, sampe skarang orang Israel dong tra makan binatang pu daging yang di bagian paha atas, karna orang itu de su pukul Yakub pu bagian paha atas, pas di de pu otot. ");
INSERT INTO pmy_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Waktu Yakub buang mata begini de liat Esau deng de pu anana bua 400 orang, dong ada jalan mnuju ke Yakub dorang. Jadi, Yakub de bagi de pu anana masing-masing deng dong pu mama-mama: Lea, Rahel, trus de budak prempuan dua. ");
INSERT INTO pmy_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Yakub de taru budak prempuan dua tu deng dong pu anana di bagian depan. Trus habis itu, Lea deng de pu anana di blakang, baru Rahel deng Yusup yang paling blakang skali. ");
INSERT INTO pmy_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Yakub de sendiri jalan paling depan skali dari dong smua. De jalan, trus de tunduk hormat sampe ke tana ke Esau. De bikin begitu tuju kali sampe ke dekat de pu kaka itu. ");
INSERT INTO pmy_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Tapi Esau ni de lari pigi ke Yakub, de peluk trus de sayang Yakub, baru dong dua bongkar mnangis. ");
INSERT INTO pmy_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Waktu Esau de buang mata begini, de liat ada prempuan-prempuan deng anana. Jadi de tanya, “Orang-orang yang ada ikut deng ko itu sapa?” Yakub jawab ke Esau begini, “Itu anana yang sa dapat karna Allah su kas tunjuk De pu baik ke sa, yang jadi kaka pu pesuru ini.” ");
INSERT INTO pmy_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Habis itu, budak prempuan dua tu deng dong pu anana datang ke dekat dorang. Trus dong tunduk kasi hormat sampe muka ke tana di depan Esau. ");
INSERT INTO pmy_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Begini, Lea deng de pu anana juga datang dekat trus tunduk sampe muka ke tana. Yang trakir, Yusup deng Rahel dong datang dekat trus dong tunduk sampe muka ke tana. ");
INSERT INTO pmy_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esau de lanjut bicara, “Ade, tadi sa ketemu rombongan-rombongan deng binatang-binatang yang ko kirim itu. Ko bikin begitu untuk?” Yakub jawab, “Itu untuk kaka Esau. Supaya kaka bisa kas tunjuk kaka pu baik ke saya.” ");
INSERT INTO pmy_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Tapi Esau de jawab, “Adeee, sa pu juga banyak. Jadi, ko punya tu, simpan untuk ko saja.” ");
INSERT INTO pmy_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Tapi Yakub jawab, “Ah kaka, jang begitu. Kalo memang kaka sayang sa, kaka trima hadia-hadia yang sa kasi ni suda. Karna bisa baku hadap muka deng kaka langsung begini saja, sa su rasa macam liat Allah pu muka begitu. Sampe kaka su mo datang sambut sa lagi. ");
INSERT INTO pmy_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Jadi, kaka trima suda, sa pu tanda salam yang sa su bawa ini. Allah su kas tunjuk De pu baik ke sa sampe sa punya smua-smua ini.” Yakub de tinggal paksa trus sampe Esau de mo trima. ");
INSERT INTO pmy_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Trus Esau bilang sama dia, “Yo suda! Mari tong jalan lanjut! Nanti sa jalan sama-sama deng ko.” ");
INSERT INTO pmy_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Tapi Yakub de alasan ke Esau begini, “Kaka Esau, macam yang kaka su tau, anana ni, dong masi tra kuat jalan jau. Trus ada kambing domba sama sapi yang masi kas susu dong pu anana. Jadi, kalo dong harus jalan cepat-cepat dalam satu hari ini saja, binatang-binatang piara ni dong smua mati nanti. ");
INSERT INTO pmy_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Jadi, biar kaka jalan duluan suda. Sa yang jadi kaka pu pesuru ni, nanti jalan plan-plan ikut binatang piara yang jalan depan kitong ini. Sa ikut anana ini dong pu tempo jalan, sampe nanti sa ketemu kaka dong di tana Seir.” ");
INSERT INTO pmy_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Trus Esau de bilang, “Kalo begitu, biar sa kas tinggal sa pu anana bua brapa untuk jaga kam suda.” Yakub balas bilang, “Ah, tra usa kaka! Kaka su kas tunjuk kaka pu baik ke sa saja, su cukup.” ");
INSERT INTO pmy_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Jadi suda, Esau dong langsung jalan pulang ke tana Seir hari itu juga. ");
INSERT INTO pmy_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Tapi Yakub dong tra ke tana Seir, dong pigi ke daera Sukot trus bikin tempat tinggal disitu. Baru de bikin tempat lindung disitu untuk de pu binatang-binatang piara. Dari situ yang, dong kas nama tempat itu Sukot. ");
INSERT INTO pmy_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Yakub dong jalan dari Padan-Aram tu, trus dong sampe deng slamat di kota Sikem di tana Kanaan. De bikin tenda di bagian timur kota itu trus dong tinggal disitu. ");
INSERT INTO pmy_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Tempat yang de bikin de pu tenda tu, de bli dari Hemor pu anana dorang deng harga 100 uang perak. Hemor tu Sikem pu bapa. ");
INSERT INTO pmy_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Trus Yakub de bikin tempat bakar korban untuk Allah disitu. De kas nama tempat bakar korban itu El Elohe Israel. ");
INSERT INTO pmy_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Satu kali begini, Yakub deng Lea dong pu anak prempuan yang nama Dina ni de pigi jalan-jalan ke prempuan-prempuan Kanaan yang tinggal disitu. ");
INSERT INTO pmy_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Waktu itu, yang jadi raja di tana itu tu orang Hewi yang nama Hemor. Waktu Hemor pu anak laki-laki yang nama Sikem de liat Dina, de bawa lari Dina baru de paksa tidur deng dia. ");
INSERT INTO pmy_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Tapi habis itu, Sikem de suka skali deng Dina, de su sayang skali deng Yakub pu anak prempuan ini. Jadi, Sikem de bicara baik-baik deng Dina. ");
INSERT INTO pmy_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Trus, Sikem pigi bicara deng de pu bapa Hemor. De bilang begini, “Bapa, pigi ambil nona itu untuk jadi sa pu istri ka.” ");
INSERT INTO pmy_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Baru, Yakub ni de dengar kalo Sikem su kas rusak de pu anak prempuan pu harga diri. Tapi Yakub de tra bikin apapa karna de pu anana laki-laki dong ada pigi ke daera sepi untuk jaga liat binatang-binatang piara ini. Jadi, Yakub de tunggu dong pulang dulu. ");
INSERT INTO pmy_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Tra lama begini, Sikem pu bapa Hemor pigi ketemu baru bicara deng Yakub. ");
INSERT INTO pmy_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Waktu itu pas Yakub pu anana dong su pulang dari tempat jaga liat binatang-binatang piara. Pas dengar yang su jadi deng dong pu sodara prempuan itu, dong emosi deng sakit hati skali. Karna kalo Sikem su paksa tidur deng Yakub pu anak prempuan, itu sama saja deng Sikem su bikin malu orang Israel dong smua. Yang begini ni, tra bole skali orang bikin. ");
INSERT INTO pmy_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hemor de bicara ke Yakub dong begini, “Sa pu anak Sikem de su suka skali deng bapa pu anak prempuan. Jadi, sa minta supaya bapa bisa kasi bapa pu anak prempuan untuk jadi anak laki-laki ni pu istri. ");
INSERT INTO pmy_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Mari tong ikat janji begini: Kam kasi kam pu anana prempuan untuk tong pu anana laki-laki. Baru kam bisa ambil tong pu anana prempuan juga. ");
INSERT INTO pmy_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Trus, kam tinggal saja disini deng bebas. Tempat ini de tabuka untuk kam tinggal disini. Kam bole bli tana disini untuk jadi kam pu milik juga.” ");
INSERT INTO pmy_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Trus Sikem bicara ke Dina pu bapa deng Dina pu sodara-sodara. Sikem bilang begini, “Bapa deng sodara-sodara smua, tolong kasi yang tong minta itu ka. Nanti sa kasi apa saja yang kam minta. ");
INSERT INTO pmy_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Bilang saja mas kawin brapa yang kam minta, trus hadia apa yang kam mau? Sa nanti kasi apa saja yang kam minta, yang penting kam kas ijin sa untuk ambil Dina jadi sa pu istri.” ");
INSERT INTO pmy_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Tapi karna Sikem su duluan bikin tra baik ke dong pu ade prempuan Dina ni, jadi Yakub pu anana dong kasi jawaban tipu-tipu ke Sikem deng de pu bapa Hemor. ");
INSERT INTO pmy_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Dong bilang begini ke dong dua, “Kitong tra bisa bikin begitu. Kitong tra bole kasi tong pu ade prempuan ke laki-laki yang blum dapa sunat. Kalo tong bikin begitu, brarti tong su injak-injak tong pu diri skali. ");
INSERT INTO pmy_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Tong bisa stuju kalo kam bikin begini: Kam smua harus jadi sama macam kitong. Tong pu maksud tu, kam deng kam pu orang-orang, sapa saja yang laki-laki, harus dapa sunat. ");
INSERT INTO pmy_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Kalo kam bikin begitu baru, tong bisa kasi tong pu anana prempuan untuk kawin deng kam, trus tong juga bisa ambil kam pu anana prempuan untuk kawin deng tong. Kalo begitu baru, tong bisa tinggal sama-sama deng kam, trus kitong bisa jadi satu bangsa. ");
INSERT INTO pmy_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Tapi kalo kam tra mo dengar yang tong bilang ini, kalo kam tra mo dapa sunat, brarti tong bawa Dina trus tong kas tinggal tempat ini.” ");
INSERT INTO pmy_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Hemor deng de pu anak Sikem dong stuju untuk bikin yang dong bilang. ");
INSERT INTO pmy_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Suda, Sikem tra pake lama lagi langsung pigi bikin yang dong minta itu, karna de pu hati su suka Dina skali. Sikem ni orang paling dapa hormat di de pu kluarga smua. ");
INSERT INTO pmy_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Jadi de deng de pu bapa Hemor dong dua pigi ke pintu masuk kota trus dong bicara deng orang-orang yang tinggal di kota itu. Dong bilang begini, ");
INSERT INTO pmy_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Orang-orang ini dong mo hidup baik-baik deng kitong, jadi kas biar dong tinggal di tana ini saja. Biar dong tinggal bebas disini. Tong pu tana juga besar mo to? Jadi, tong bisa ambil dong pu anana prempuan untuk jadi tong pu istri, trus tong pu anana prempuan juga tong bisa kasi untuk dorang. ");
INSERT INTO pmy_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Tapi orang Israel dong mo tinggal hanya kalo smua laki-laki dapa sunat, laki-laki sapa saja yang ada sama-sama deng kitong. Supaya tong sama deng dong yang su dapa sunat juga. Begitu baru, kitong bisa tinggal jadi satu bangsa sama-sama. ");
INSERT INTO pmy_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Coba kam pikir, nanti dong pu binatang piara ato binatang apa saja, deng dong pu barang milik smua tu, pasti jadi tong pu milik juga to? Jadi, mari suda, tong ikut yang dong minta supaya dong tetap tinggal deng kitong disini.” ");
INSERT INTO pmy_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Smua orang yang datang kumpul di pintu masuk kota tu, dong dengar trus dong stuju deng yang Hemor sama de pu anak Sikem bilang itu. Suda, smua laki-laki yang tinggal di kota itu dapa sunat, smua laki-laki yang su besar. ");
INSERT INTO pmy_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Pas waktu su lewat tiga hari, waktu dong masi rasa sakit-sakit ni, Dina pu kaka Simeon deng Lewi, dong datang deng pedang. Yakub pu anak dua ni, dong dua srang kota itu waktu orang-orang kota dong tra siap mo prang. Trus dong dua bunu laki-laki yang ada di kota itu smua. ");
INSERT INTO pmy_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Dong dua juga bunu Hemor deng de pu anak Sikem pake dong pu pedang itu. Trus dong ambil Dina dari Sikem pu ruma trus bawa pigi. ");
INSERT INTO pmy_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Habis dong bantai smua orang laki-laki disitu, Yakub pu anana lain datang ambil barang-barang yang ada di kota itu. Dong bikin begitu untuk balas dong pu ade prempuan pu harga diri yang dapa kas rusak waktu itu. ");
INSERT INTO pmy_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Dong angkat kambing, domba, lapis deng sapi, kledai smua. Smua yang ada di dalam kota sampe yang di luar kota juga, dong angkat. ");
INSERT INTO pmy_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Smua barang-barang yang bagus-bagus deng mahal dong angkat juga, smua yang ada dalam ruma. Trus dong angkat prempuan-prempuan deng anana dari kota itu juga. ");
INSERT INTO pmy_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Begitu tau yang su jadi itu, Yakub bicara ke Simeon deng Lewi begini, “Kam dua ini bikin susa sa skali! Skarang ini, orang Kanaan deng orang Feris dong pasti su tra suka sa skali. Kam liat, tong pu orang-orang ni tra banyak. Bagemana kalo dong smua baku gabung trus maju srang kitong ni, pasti tong kala. Bisa-bisa nanti sa deng sa pu kluarga smua hilang dari bumi ni.” ");
INSERT INTO pmy_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Tapi dong bilang dong pu bapa begini, “Bapa, baru? Trapapa ka, kitong kas tinggal tong pu sodara prempuan dapa bikin macam placur begitu?” ");
INSERT INTO pmy_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Satu hari, Allah bilang ke Yakub begini, “Siap-siap skarang! Pigi ke Betel trus tinggal disana. Ko bikin tempat bakar korban untuk Sa, Allah yang dulu kas tunjuk diri ke ko waktu ko lari dari ko pu kaka Esau.” ");
INSERT INTO pmy_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Jadi, Yakub bilang ke de pu orang-orang satu ruma deng orang-orang yang su jalan sama-sama deng dia, “Buang kam pu patung-patung smua, patung yang kam bawa untuk semba. Bikin bersi kam pu diri trus pake pakean yang bersi untuk pigi ketemu Allah. ");
INSERT INTO pmy_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Skarang, mari tong pigi ke Betel. Sa mo bikin tempat bakar korban untuk Allah disana. Allah yang su tolong sa waktu sa rasa sengsara skali, Allah yang su ada sama-sama deng sa kemana saja sa pigi.” ");
INSERT INTO pmy_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Dong smua kasi dong pu patung-patung yang dong semba ni ke Yakub, trus dong pu anting-anting yang ada di tlinga juga dong kasi. Baru Yakub kubur itu smua di bawa pohon besar yang ada di Sikem situ. ");
INSERT INTO pmy_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Habis itu, dong siap-siap brangkat. Waktu dong jalan, Allah bikin orang-orang di kota-kota tempat dong lewat tu, rasa takut skali deng dorang. Jadi, trada orang yang brani srang Yakub dorang. ");
INSERT INTO pmy_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Brapa hari begini Yakub deng smua orang yang sama-sama deng dia sampe di tempat yang nama Lus, yang orang knal deng nama Betel. Tempat ini ada di Kanaan juga. ");
INSERT INTO pmy_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Di tempat itu, Yakub de bangun tempat bakar korban untuk Allah. Trus de kas nama tempat itu El Betel karna dulu, waktu de lari dari de pu kaka, Allah kas tunjuk De pu diri ke dia di tempat itu. ");
INSERT INTO pmy_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Disitu yang, Debora, orang yang dulu biasa jaga-jaga Ribka ni, de mninggal. Trus de dapa kubur di sebla slatan kota Betel itu, di bawa pohon besar yang disitu. Dari sini yang, pohon itu dapat nama Pohon Mnangis. ");
INSERT INTO pmy_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Jadi waktu Yakub masi tinggal di Betel, yang habis de su pulang dari Padan-Aram tu, Allah kas tunjuk De pu diri lagi ke Yakub trus kas berkat dia. ");
INSERT INTO pmy_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Allah bilang de begini, “Nama Yakub ini, skarang su bukan ko pu nama lagi. Ko pu nama skarang tu Israel.” Jadi Allah kas nama de Israel. ");
INSERT INTO pmy_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Trus Allah bilang de begini lagi, “Sa ini Allah Yang Pu Kuasa Paling Besar. Ko nanti pu anana deng cucu-cucu yang jadi tamba banyak trus. Ko pu anana cucu nanti jadi satu bangsa, sampe bangsa-bangsa juga nanti lahir dari ko, trus raja-raja juga nanti datang dari ko. ");
INSERT INTO pmy_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Tana yang Sa su kasi ke Abraham deng Isak ini juga, nanti Sa kasi ke ko deng ko pu anana cucu.” ");
INSERT INTO pmy_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Habis itu, Allah naik pigi kas tinggal Yakub di tempat yang tadi De ada bicara ke Yakub itu. ");
INSERT INTO pmy_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Trus Yakub de bikin tanda pake batu besar di tempat itu, tanda untuk kas ingat kalo Allah perna bicara deng de disitu. Baru de tumpa persembahan air anggur deng minyak ke bagian atas batu itu, untuk kas kusus itu. ");
INSERT INTO pmy_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Yakub kas nama tempat yang Allah ada bicara deng de tu Betel. ");
INSERT INTO pmy_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Habis itu, Yakub dong kas tinggal Betel. Waktu dong su mo dekat-dekat Efrata, Rahel de rasa de pu anak su mo lahir, de rasa sakit yang tra sperti biasa. ");
INSERT INTO pmy_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Waktu de pu rasa sakit tu su mulai tamba para, bidan yang bantu de untuk lahir tu bilang begini, “Ko jang takut! Ko pu anak ni laki-laki lagi.” ");
INSERT INTO pmy_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Waktu Rahel pu napas-napas trakir, seblum de pu napas putus, de kas nama anak itu Ben-Oni. Tapi anak itu pu bapa Yakub kas nama de Benyamin. ");
INSERT INTO pmy_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Jadi begitu suda, Rahel de mninggal, trus dong kubur de di pinggir jalan yang mo ke Efrata, skarang tempat ini nama Betlehem. ");
INSERT INTO pmy_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yakub bikin tanda dari batu di atas de pu kuburan. Batu itu yang masi jadi tanda kalo Rahel ada dapa kubur disitu. ");
INSERT INTO pmy_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Habis itu, Israel dong lanjut jalan, trus dong bikin tenda di sebla tempat yang nama Migdal-Eder. ");
INSERT INTO pmy_vpl VALUES ("GN35_22a","002_35_22a","GEN","35","22a","22a","Waktu Israel dong tinggal di tempat ini yang, Ruben de sampe tidur deng Bilha, budak yang de pu bapa su ambil jadi istri. Trus Israel de dengar apa yang de pu anak tua ni bikin. ");
INSERT INTO pmy_vpl VALUES ("GN35_22b","002_35_22b","GEN","35","22b","22b","Yakub pu anana laki-laki smua ada 12 orang. ");
INSERT INTO pmy_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Lea pu anana tu Ruben, de ini Yakub pu anak yang tua. Habis de ada Simeon, Lewi, Yehuda, Isakar, deng Zebulon. ");
INSERT INTO pmy_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rahel pu anana tu Yusup deng Benyamin. ");
INSERT INTO pmy_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Kalo Bilha, Rahel pu budak prempuan, de pu anana tu Dan sama Naftali. ");
INSERT INTO pmy_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Trus kalo Zilpa, Lea pu budak prempuan, de pu anana tu Gad sama Asyer. Itu suda, Yakub pu anana smua yang lahir untuk dia di Padan-Aram. ");
INSERT INTO pmy_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Trakir tu, Yakub ketemu deng de pu bapa Isak pas de sampe di daera Mamre, tempat yang dekat Kiryat-Arba, yang orang knal deng nama Hebron. Itu tempat yang Isak deng Abraham tinggal jadi pendatang dulu. ");
INSERT INTO pmy_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Isak de mninggal, de gabung deng de pu orang-orang tua dorang. De pu umur su 180 taun waktu de mninggal. De su tua skali. De pu anak Esau deng anak Yakub yang kubur dia. ");
INSERT INTO pmy_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Ini Esau de pu daftar anana cucu. Esau de yang orang knal deng nama Edom. ");
INSERT INTO pmy_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau de ambil prempuan Kanaan untuk jadi de pu istri. De kawin deng Adah, bapa Elon yang orang Het ni pu anak prempuan. De juga kawin deng Oholibama. Oholibama ni bapa Anah pu anak prempuan, bapa Zibeon yang orang Hewi tu pu cucu prempuan. ");
INSERT INTO pmy_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Trus Esau de kawin deng Basmat juga, Ismael pu anak prempuan, Nebayot pu ade prempuan. ");
INSERT INTO pmy_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Adah de lahir Elifas untuk Esau. Basmat lahir Rehuel. ");
INSERT INTO pmy_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Trus Oholibama lahir Yeus, Yaelam, deng Korah. Ini suda, Esau pu anana laki-laki yang lahir di tana Kanaan. ");
INSERT INTO pmy_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esau de pisa deng de pu ade Yakub di Kanaan situ baru de brangkat ke daera lain. Esau de bawa de pu istri-istri, de pu anana smua, mo laki-laki ka prempuan ka, lapis deng de pu orang-orang smua. Trus de bawa binatang-binatang piara deng de pu harta smua yang de dapat di tana Kanaan. ");
INSERT INTO pmy_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Karna tana tempat dong dua tinggal ni su tra sanggup tampung dong dua lagi, dong pu binatang-binatang piara su terlalu banyak jadi. ");
INSERT INTO pmy_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Itu yang, Esau yang orang knal deng nama Edom juga ni, de pigi tinggal di daera gunung-gunung Seir. ");
INSERT INTO pmy_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ini Esau pu daftar anana cucu. Esau de tu moyang orang Edom, orang-orang yang tinggal di daera gunung-gunung Seir. ");
INSERT INTO pmy_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Esau pu anana tu: Elifas, dari de pu istri Adah, deng Rehuel, dari de pu istri Basmat. ");
INSERT INTO pmy_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","12","Esau deng Adah pu cucu-cucu dari dong pu anak Elifas tu: Teman, Omar, Zefo, Gaetam, deng Kenas. Elifas de juga ambil budak prempuan jadi de pu istri, de pu nama Timna. Elifas deng Timna pu anak yang nama Amalek. ");
INSERT INTO pmy_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Esau deng de pu istri Basmat pu cucu-cucu yang dari dong pu anak Rehuel tu: Nahat, Zerah, Syama, deng Miza. ");
INSERT INTO pmy_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esau pu istri Oholibama ni, de juga lahir anak untuk Esau. Dong pu anana tu: Yeus, Yaelam, deng Korah. Oholibama tu Anah pu anak prempuan, trus Anah tu Zibeon pu anak laki-laki. ");
INSERT INTO pmy_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Ini kepala-kepala suku dari Esau pu orang-orang yang lahir dari de pu anak yang tua, Elifas ini: Teman, Omar, Zefo, Kenas, ");
INSERT INTO pmy_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Korah, Gaetam, deng Amalek. Dong ini yang jadi moyang dari dong pu suku masing-masing. Itu smua Adah pu anak Elifas pu anana yang lahir di tana Edom. ");
INSERT INTO pmy_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Ini kepala-kepala suku dari Esau pu anak Rehuel: Nahat, Zerah, Syama, deng Miza. Dong ini yang jadi moyang dari dong pu suku masing-masing. Itu smua Esau deng Basmat pu anak Rehuel pu anana yang lahir di tana Edom. ");
INSERT INTO pmy_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Ini kepala-kepala suku dari Esau deng Oholibama pu anana: Yeus, Yaelam, deng Korah. Dong ini yang jadi moyang dari dong pu suku masing-masing. Itu smua Esau pu anana yang lahir dari de pu istri Oholibama, bapa Anah pu anak prempuan itu. ");
INSERT INTO pmy_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Jadi, dong ini smua anana cucu yang lahir dari Esau, yang orang knal deng nama Edom. Dong ini yang jadi moyang dari dong pu suku masing-masing. ");
INSERT INTO pmy_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Orang asli yang tinggal di tana Edom tu orang Hori. Dong pu moyang nama Seir yang de pu anana tu: Lotan, Syobal, Zibeon, Anah, ");
INSERT INTO pmy_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Disyon, Ezer, deng Disyan. Seir pu anana ini suda yang jadi moyang dari suku-suku orang Hori di tana Edom. ");
INSERT INTO pmy_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan pu anana tu: Hori deng Heman. Lotan pu sodara prempuan yang nama Timna. ");
INSERT INTO pmy_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Syobal pu anana tu: Alwan, Manahat, Ebal, Syefo, deng Onam. ");
INSERT INTO pmy_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Zibeon pu anana tu: Aya deng Anah. Anah ni, de yang ketemu mata air panas di tempat sepi yang kring itu. De ketemu tu waktu de ada jaga liat de pu bapa Zibeon pu kledai-kledai. ");
INSERT INTO pmy_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Anah pu anana tu: Disyon deng anak prempuan satu yang nama Oholibama. ");
INSERT INTO pmy_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Disyon pu anana tu: Hemdan, Esban, Yitran, deng Keran. ");
INSERT INTO pmy_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ezer pu anana tu: Bilhan, Zaawan, deng Akan. ");
INSERT INTO pmy_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disyan pu anana tu: Us deng Aran. ");
INSERT INTO pmy_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Dong ini suda yang jadi moyang dari bangsa orang Hori dorang. Moyang orang Lotan, moyang orang Syobal, moyang orang Zibeon, moyang orang Anah, ");
INSERT INTO pmy_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","moyang orang Disyon, moyang orang Ezer, deng moyang orang Disyan. Smua ini moyang-moyang dari suku orang Hori di tana Seir. ");
INSERT INTO pmy_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Waktu Israel blum ada raja, Edom dong su ada raja-raja yang pimpin dorang. ");
INSERT INTO pmy_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Yang pertama jadi raja di Edom tu Bela, Beor pu anak. De yang printa dari de pu kota Dinhaba. ");
INSERT INTO pmy_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Waktu Bela mninggal, Yobab ganti jadi raja. Yobab pu bapa nama Zera, yang dari kota Bozra. ");
INSERT INTO pmy_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Waktu Yobab mninggal, Husyam ganti jadi raja. Husyam ini dari daera Teman. ");
INSERT INTO pmy_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Waktu Husyam mninggal, Hadad ganti jadi raja. Hadad pu bapa nama Bedad. Hadad ini yang kas kala orang Midian di daera Moab. Raja Hadad de yang printa dari de pu kota Awit. ");
INSERT INTO pmy_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Waktu Hadad mninggal, Samla ganti jadi raja. Samla ni de dari Masreka. ");
INSERT INTO pmy_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Waktu Samla mninggal, Saul ganti jadi raja. Saul de asal dari Rehobot, kota yang di pinggir kali. ");
INSERT INTO pmy_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Waktu Saul mninggal, Baal-Hanan ganti jadi raja. Baal-Hanan pu bapa nama Akbor. ");
INSERT INTO pmy_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Waktu Akbor pu anak Baal-Hanan ni de mninggal, Hadar ganti jadi raja. Raja Hadar de yang printa dari de pu kota Pahu. De pu istri nama Mahetabeel. Mahetabeel itu mama Matred pu anak prempuan, nene Mezahab pu cucu prempuan. ");
INSERT INTO pmy_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Ini Esau pu anana cucu pu nama-nama. Dong pu nama ini yang pake jadi dong pu nama kluarga deng nama kampung. Dong itu: Timna, Alwa, Yetet, ");
INSERT INTO pmy_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibama, Ela, Pinon, ");
INSERT INTO pmy_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenas, Teman, Mibzar, ");
INSERT INTO pmy_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel, deng Iram. Dong pu nama-nama ini suda, yang pake jadi nama-nama kluarga di bangsa Edom, yang dong pake kas nama tana tempat dong tinggal juga. Jadi begitu, Edom itu Esau suda, de yang jadi moyang orang Edom dorang. ");
INSERT INTO pmy_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yakub ni de lanjut tinggal di tana Kanaan, tempat yang dulu de pu bapa Isak tinggal jadi pendatang disitu. ");
INSERT INTO pmy_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ini crita tentang Yakub pu kluarga. Skarang begini, Yakub pu anak yang nama Yusup ni, de umur 17 taun. Yusup de biasa bantu jaga liat bapa Yakub pu kambing domba. Yusup de kerja deng de pu kaka-kaka yang dari bapa Yakub pu istri Zilpa deng Bilha. Kalo de pu kaka dong bikin jahat pas dong kerja, Yusup de pi lapor ke Yakub, dong pu bapa ni. ");
INSERT INTO pmy_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Karna Yusup de lahir pas waktu Yakub su tua jadi, Yakub ni de lebi sayang Yusup daripada de pu anana yang lain. Itu yang, Yakub de suru bikin pakean bagus skali yang panjang untuk Yusup pu hadia. ");
INSERT INTO pmy_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Waktu Yusup pu kaka dong liat bapa Yakub ni lebi sayang Yusup daripada dong yang lain, Yusup pu kaka dong langsung tra snang Yusup skali, sampe dong su tra mo bicara baik-baik deng Yusup lagi. ");
INSERT INTO pmy_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Satu kali begini, Yusup de mimpi, baru de crita de pu mimpi tu sama de pu kaka dorang. Waktu Yusup pu kaka dong dengar de pu mimpi itu, dong langsung tamba tra suka de skali. ");
INSERT INTO pmy_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Yusup crita de pu mimpi begini, “Kaka, coba kam dengar dulu sa pu mimpi ni. ");
INSERT INTO pmy_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Sa mimpi, tong ada di kebun, ada ikat-ikat gandum. Trus begini sa pu gandum yang su dapa ikat tu, de bediri lurus. Trus begini kaka kam pu gandum yang su dapa ikat juga tu, datang kliling sa pu gandum baru dong tunduk kasi hormat ke sa pu gandum itu.” ");
INSERT INTO pmy_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Dengar begitu, langsung Yusup pu kaka dong bilang sama Yusup, “Jadi, ko mo jadi raja trus suru-suru kitong, iyo?” Dari situ tu Yusup pu kaka dong jadi tamba tra suka de skali, gara-gara dengar Yusup de crita de pu mimpi itu. ");
INSERT INTO pmy_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Satu kali begini, Yusup de mimpi lagi, baru de pigi crita de pu mimpi tu sama de pu kaka dorang. De bilang begini, “Kaka-kaka, sa ada mimpi lagi ni. Dalam mimpi tu sa liat matahari deng bulan sama bintang 11, dong smua tunduk trus kasi hormat sama saya.” ");
INSERT INTO pmy_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Habis de crita de pu mimpi itu ke de pu kaka dong deng ke de pu bapa, de pu bapa langsung mara dia, “Mimpi apa itu?! Ko pikir bapa, mama, deng ko pu sodara dong mo tunduk hormat ko sampe ke tana, iyo?” ");
INSERT INTO pmy_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Dari situ, de pu kaka dong tamba iri hati deng de skali, gara-gara de pu mimpi-mimpi itu. Tapi de pu bapa tinggal ingat Yusup pu mimpi trus. ");
INSERT INTO pmy_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Satu hari begini, Yusup pu kaka dong su pigi ke tempat dekat kota Sikem. Dong mo pigi kas makan dong bapa pu kambing domba disitu. ");
INSERT INTO pmy_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Lewat brapa hari begini, Yakub bilang sama Yusup, “Yusup, sa mau ko pigi liat ko pu kaka dong dulu. Dong ada kas makan kambing domba dekat kota Sikem situ.” Yusup de jawab, “Iyo bapa.” ");
INSERT INTO pmy_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Trus Yakub bilang Yusup lagi, “Ko pigi liat ko pu kaka dong sama kambing domba itu. Dong baik-baik saja ka trada. Baru, nanti ko datang lapor ke bapa sini.” Jadi suda, Yusup pu bapa kirim de ke tempat dekat kota Sikem situ, dari tana renda Hebron. Lewat brapa hari begini, Yusup de su sampe di kota Sikem. ");
INSERT INTO pmy_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Waktu Yusup de ada jalan kliling-kliling di daera sepi tempat rumput saja tu, ada bapa satu yang liat dia. Bapa itu de tanya Yusup, “Anak, ko cari apa ka?” ");
INSERT INTO pmy_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yusup de jawab, “Sa cari sa pu kaka dorang, bapa. Bapa tau ka, dong ada jaga liat kambing domba di sebla mana eh?” ");
INSERT INTO pmy_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Trus bapa itu de jawab, “O... iyo betul, tadi dong ada disini. Tadi sa dengar dong bilang dong mo pigi ke kota Dotan.” Jadi, Yusup de langsung pigi ke Dotan trus de ketemu deng de pu kaka dorang. ");
INSERT INTO pmy_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Dari jau ni, de pu kaka dong su liat dia. Jadi, waktu de masi jau, dong su baku atur untuk mo bunu dia. ");
INSERT INTO pmy_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","De pu kaka dong baku kastau, “We, kam liat eh! Tukang mimpi de ada datang tu. ");
INSERT INTO pmy_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Mari! Tong bunu baru buang de ke dalam satu dari sumur kring ini. Nanti tong tinggal bilang saja kalo ada binatang liar satu yang makan dia. Baru nanti tong liat, de pu mimpi tu jadi ka trada!” ");
INSERT INTO pmy_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Waktu dong pu kaka Ruben, de dengar dong pu rencana tu, de mulai cari jalan untuk kas slamat Yusup. Jadi, Ruben de bilang begini, “Suda, tong tra usa bunu dia! ");
INSERT INTO pmy_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Lebi baik tong tra bikin de luka-luka. Tong lempar de ke dalam sumur kring di tempat sepi ini saja, tapi tong tra usa bikin apapa ke dia.” Ruben de bilang begitu karna de mo kas slamat Yusup trus bawa Yusup balik ke de pu bapa. ");
INSERT INTO pmy_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Jadi, waktu Yusup su sampe di de pu kaka dong pu tempat, dong langsung tarik de pu pakean bagus yang panjang tu kas lepas. ");
INSERT INTO pmy_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Baru dong seret de ke sumur, baru lempar de ke dalam sumur yang su kring itu. ");
INSERT INTO pmy_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Habis itu, Yusup pu kaka dong duduk makan. Pas dong angkat muka begini, dong liat ada orang Ismael satu rombongan yang datang dari Gilead. Orang-orang itu dong mo ke Mesir deng dong pu unta-unta yang ada bawa ramuan-ramuan sama geta-geta kental yang biasa dong pake untuk obat gosok sama untuk kas wangi-wangi. ");
INSERT INTO pmy_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Langsung Yusup pu kaka Yehuda ni, de kas suara ke de pu sodara-sodara dorang, “We kam, untuk apa juga tong bunu tong pu ade baru kas sembunyi dia? Trada untung juga mo. ");
INSERT INTO pmy_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Tong jual de ke orang Ismael dong suda, tra usa bikin apapa dia. De juga tong pu sodara satu bapa mo.” De pu sodara-sodara dong stuju deng yang Yehuda bilang. ");
INSERT INTO pmy_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Jadi waktu tukang jual-bli dari Midian ni dong lewat, Yusup pu kaka dong tarik de kluar dari sumur trus jual de ke orang-orang Ismael itu. Yusup pu sodara dong jual de deng harga 20 uang perak. Jadi, orang-orang itu dong bawa Yusup sama-sama deng dong ke Mesir. ");
INSERT INTO pmy_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Pas waktu Ruben de kembali, de pi cek ke sumur begini, Yusup su trada disitu. De pu hati langsung rasa sedi skali sampe de langsung robek de pu pakean. ");
INSERT INTO pmy_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Trus de balik baru de bilang sama de pu sodara dorang, “We kam! Yusup su trada! Bagemana ni, sa mo bikin apa lagi skarang?!” ");
INSERT INTO pmy_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Trus, de pu sodara dong ambil Yusup pu pakean bagus yang panjang tu, dong potong kambing satu, trus dong colo Yusup pu pakean bagus ni dalam kambing pu dara tu. ");
INSERT INTO pmy_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Baru dong suru antar Yusup pu pakean bagus yang su ada dara tu ke dong pu bapa. Trus dong bilang dong pu bapa begini, “Bapa, coba bapa liat ini dulu, pakean yang tong ada dapat ni. Mungkin ini bapa pu anak Yusup de pu pakean kapa?” ");
INSERT INTO pmy_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Pas Yakub de liat pakean itu, de langsung knal trus bilang, “Iyo, ini sa pu anak Yusup pu pakean! Pasti binatang liar su makan dia ini! Pasti Yusup su dapa srang dari binatang itu!” ");
INSERT INTO pmy_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Yakub juga langsung robek de pu pakean trus de pake kain kabung, habis de sedi skali. Yakub de tinggal mnangis trus untuk de pu anak, sampe su lewat brapa hari juga de tra brenti. ");
INSERT INTO pmy_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Biar de pu anana laki-laki deng anana prempuan dong datang kas tenang de juga tapi, de tetap tra mau. De bilang begini, “Sa trakan brenti mnangis untuk Yusup, sampe sa juga mninggal ikut dia.” Jadi begitu suda, Yusup pu bapa ni tinggal mnangis de trus. ");
INSERT INTO pmy_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Baru pas waktu itu tu, orang dari Midian yang bawa Yusup tu, dong jual Yusup ke Mesir pu orang penting satu, ke bapa Potifar. De tu kepala dari raja pu pasukan kusus. ");
INSERT INTO pmy_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Habis itu, Yehuda de pigi dari de pu sodara-sodara trus tinggal deng orang satu dari kota Adulam yang nama Hira. ");
INSERT INTO pmy_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Waktu disana, ada orang Kanaan satu yang nama Syua. Yehuda de knalan deng bapa Syua pu nona satu, baru Yehuda ambil nona itu jadi de pu istri. Trus de tidur deng prempuan itu. ");
INSERT INTO pmy_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Prempuan itu de hamil trus de lahir anak laki-laki satu trus Yehuda kas nama de Er. ");
INSERT INTO pmy_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Trus prempuan itu de hamil lagi, trus lahir anak laki-laki satu lagi baru kas nama de Onan. ");
INSERT INTO pmy_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Baru de lahir anak laki-laki satu lagi trus kas nama anak itu Syela. Waktu Syela lahir, Yehuda dong su ada di daera Kezib. ");
INSERT INTO pmy_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Waktu Yehuda pu anana su besar, Yehuda kas kawin de pu anak pertama yang nama Er ni, deng prempuan satu yang nama Tamar. ");
INSERT INTO pmy_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Tapi TUHAN liat kalo Er, Yehuda pu anak pertama ni, de pu klakuan paling jahat skali. Jadi, TUHAN ambil Er pu hidup kembali. ");
INSERT INTO pmy_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Trus Yehuda suru de pu anak Onan begini, “Ko kawin deng ko pu kaka pu istri itu suda, ikut tong pu adat. Supaya kalo prempuan itu pu anak, anak itu bisa lanjut ko pu kaka pu nama kluarga.” ");
INSERT INTO pmy_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Tapi Onan de tau kalo anak yang nanti lahir trakan lanjut de pu nama kluarga. Jadi waktu de tidur deng de pu kaka pu janda, de kas tumpa de pu air mani kluar supaya prempuan ini tra bisa hamil dari dia. De bikin begitu supaya de pu kaka trada anana cucu. ");
INSERT INTO pmy_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Tapi, TUHAN liat kalo yang de bikin ni jahat skali. Jadi, TUHAN juga ambil Onan pu hidup kembali. ");
INSERT INTO pmy_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Suda. Yehuda de pigi bicara ke de pu mantu Tamar ini. De alasan bilang begini, “Mantu, ko pulang ke ko pu bapa dong pu ruma dulu eh. Tinggal jadi janda dulu disana, tunggu sampe sa pu anak Syela ni de besar dulu baru.” Yehuda bilang begitu karna de pikir, “Jang sampe nanti Syela juga nanti mninggal macam de pu kaka dua itu lagi.” Jadi suda, Tamar de kembali pigi tinggal di de pu bapa dong pu ruma. ");
INSERT INTO pmy_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Su lewat brapa taun begini, Syua pu anak prempuan yang jadi Yehuda pu istri ni, de mninggal. Begitu waktu duka su slesai, Yehuda de ajak de pu teman Hira yang dari Adulam tu pigi ke Timna, tempat de pu domba-domba pu bulu dapa pangkas. ");
INSERT INTO pmy_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Tamar dengar ada orang bilang begini, “Eh, ko pu bapamantu ada jalan ke Timna untuk pangkas de pu domba-domba pu bulu.” ");
INSERT INTO pmy_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Jadi, Tamar de ganti pakean janda yang de pake tu deng pakean lain. De tutup de pu muka deng syal trus de pigi duduk di pintu masuk kota Enaim. Kota Enaim ni ada di tenga jalan yang mo ke Timna. Waktu itu, Tamar de su tau skali kalo Yehuda pu anak bungsu Syela de su besar, tapi Yehuda blum kasi Syela untuk kawin deng dia. ");
INSERT INTO pmy_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Skarang begini, Yehuda de lewat dari situ. Karna Tamar duduk tutup de pu muka deng syal, jadi Yehuda kira Tamar ni placur. ");
INSERT INTO pmy_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Trus Yehuda de pigi ke pinggir jalan situ trus bicara ke Tamar begini, “Mari tidur deng sa.” De bilang begini karna de tratau kalo ini de pu anak mantu. Tamar jawab de begini, “Ko bisa kasi sa apa, kalo sa tidur deng ko?” ");
INSERT INTO pmy_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Yehuda jawab, “Nanti sa kirim sa pu anak kambing satu untuk ko.” Tamar bilang, “Bisa, asal ada apapa yang sa bisa tahan sampe kambing tu tiba di sa pu tangan.” ");
INSERT INTO pmy_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Yehuda tanya, “Ko mo sa kasi ko apa?” Tamar bilang, “Ko pu stempel tanda tangan, kalung, deng tongkat yang ko ada pegang itu.” Yehuda kasi itu smua ke dia trus de tidur deng prempuan itu. Dari situ yang Tamar de hamil nanti. ");
INSERT INTO pmy_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Habis yang de bikin itu, Tamar de pulang, trus de buka syal yang de pake tutup muka tu, baru de pake de pu pakean janda lagi. ");
INSERT INTO pmy_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Skarang begini, Yehuda de kirim anak kambing yang de bilang tu lewat de pu teman yang nama Hira, orang Adulam ni, supaya de bisa ambil kembali barang-barang yang de su kasi prempuan itu. Tapi Hira de tra ketemu prempuan itu lagi. ");
INSERT INTO pmy_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Hira de tanya orang-orang yang tinggal dekat situ, “Kam tau ka, placur yang biasa di pinggir jalan ke Enaim tu de ada dimana?” Dong jawab dia, “Tra perna ada placur disini.” ");
INSERT INTO pmy_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Suda, Hira kembali ke Yehuda trus bilang de begini, “Sa tra ketemu prempuan itu. Orang-orang disitu juga bilang kalo di dong pu tempat tu trada placur.” ");
INSERT INTO pmy_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yehuda bilang lagi, “Suda, kas biar prempuan itu de pegang sa pu barang-barang saja, daripada tong malu lagi. Yang penting, sa su usaha untuk kirim anak kambing ke dia, tapi ko tra bisa ketemu prempuan itu.” ");
INSERT INTO pmy_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Pas su lewat tiga bulan, Yehuda dapat kabar begini, “Ko pu mantu Tamar tu, de su pigi jual diri. Skarang de ada hamil dari hasil de jual diri itu.” Yehuda langsung bilang orang begini, “Kam pigi ambil prempuan itu, trus bakar de sampe mati.” ");
INSERT INTO pmy_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Pas dong bawa Tamar kluar dari de pu ruma, Tamar de kirim pesan ke de pu bapamantu begini, “Sa hamil dari laki-laki yang pu barang-barang ini. Bapa cek baik-baik dulu: stempel, kalung, deng tongkat ini sapa punya?” ");
INSERT INTO pmy_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yehuda de knal barang-barang itu, trus de bilang begini, “Prempuan ini tra sala, sa yang sala. Sa harus kas kawin de deng sa pu anak Syela tapi sa tra bikin itu.” Habis ini, Yehuda de su tra perna tidur deng Tamar lagi. ");
INSERT INTO pmy_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Pas Tamar pu waktu untuk lahir anak begini, dong tau kalo de pu anak tu kembar. ");
INSERT INTO pmy_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Waktu de pu anana mo kluar, anak yang satu de kas kluar de pu tangan, trus bidan pegang anak itu pu tangan baru ikat deng benang mera. Bidan de bilang begini, “Anak ini yang pertama kluar eh.” ");
INSERT INTO pmy_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Begini anak ini de tarik de pu tangan masuk lagi baru de pu sodara laki-laki yang satu yang kluar duluan. Trus bidan de bilang, “Ko kuat skali, bisa dorong diri untuk kluar duluan.” Jadi dong kas nama anak itu Peres. ");
INSERT INTO pmy_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Habis anak ini lahir baru, de pu sodara laki-laki yang tadi de pu tangan ada dapa ikat deng benang mera tu kluar. Jadi dong kas nama anak ini Zerah. ");
INSERT INTO pmy_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Orang-orang Ismael su bawa Yusup sampe di Mesir. Disana, dong jual Yusup ke orang Mesir satu, yang de pu nama Potifar. Potifar ni raja Mesir pu orang penting. De tu kepala dari pasukan raja Mesir. ");
INSERT INTO pmy_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Waktu Yusup tinggal di de pu tuan orang Mesir pu ruma, TUHAN yang ada sama-sama deng dia, sampe apa saja yang Yusup de kerja, pasti smua jadi bagus skali. ");
INSERT INTO pmy_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Brapa lama begini, Yusup pu tuan sadar kalo TUHAN yang ada sama-sama deng Yusup, trus TUHAN yang bikin sampe apa saja yang Yusup de kerja tu, pasti jadi bagus skali. ");
INSERT INTO pmy_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Dari situ Potifar de mulai snang deng Yusup. Trus de angkat Yusup jadi pesuru kusus. Potifar kas tugas Yusup untuk urus de pu urusan di ruma sama atur de pu barang-barang smua. ");
INSERT INTO pmy_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Mulai dari Yusup dapa tunjuk untuk jaga liat Potifar pu ruma deng barang-barang, TUHAN kas berkat orang Mesir ini de pu barang-barang smua juga: yang di ruma ka, yang di kebun ka, de pu binatang-binatang piara ka, TUHAN kas berkat smua. ");
INSERT INTO pmy_vpl VALUES ("GN39_6a","002_39_6a","GEN","39","6a","6a","Itu jadi, apa saja yang Potifar de punya, de kasi Yusup yang atur smua. Karna Yusup su urus smua, jadi Potifar de cuma perlu atur de pu makanan saja, tra perlu sibuk deng de pu barang-barang yang lain lagi. ");
INSERT INTO pmy_vpl VALUES ("GN39_6b","002_39_6b","GEN","39","6b","6b","Yusup ni de muka bagus baru de badan juga bagus. ");
INSERT INTO pmy_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Lewat brapa lama begini, Potifar pu istri mulai liat Yusup trus de mau-mau dia. Jadi de bilang, “Yusup, mari suda, tong dua pigi tidur sama-sama.” ");
INSERT INTO pmy_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Tapi Yusup de tolak, de bilang begini, “Bapa Potifar de tra kuatir deng de pu barang-barang karna su percaya sa untuk urus itu smua. ");
INSERT INTO pmy_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Memang bapa Potifar su kasi sa kuasa untuk urus de pu barang-barang smua, jadi disini trada yang pu kuasa lebi besar dari saya. Tapi hanya nyonya saja yang sa tra bole kore karna nyonya ni bapa Potifar pu istri. Sa trakan bikin barang yang jahat begitu! Kalo sa sampe bikin begitu, sa su bikin dosa ke Allah.” ");
INSERT INTO pmy_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Tiap hari Potifar pu istri tinggal ganggu trus minta Yusup pigi tidur deng dia, tapi tetap Yusup de tra mau, sampe Yusup de tra mau dekat deng Potifar pu istri. ");
INSERT INTO pmy_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Satu kali begini, Yusup de masuk ke Potifar pu ruma mo kerja. Baru hari itu tu pas orang kerja dong trada sama skali dalam ruma situ. ");
INSERT INTO pmy_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Kaget begini, Potifar pu istri tarik Yusup pu pakean baru bilang, “Yusup, mari tidur deng sa suda!” Yusup langsung lari kluar, kas tinggal de pu pakean di Potifar pu istri pu tangan. ");
INSERT INTO pmy_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Waktu de liat Yusup su lari kluar, baru Yusup pu pakean masi tatinggal di de pu tangan, ");
INSERT INTO pmy_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","Potifar pu istri panggil anana laki-laki yang kerja di dong situ baru de bilang dong begini, “Kam liat! Potifar pu orang Ibrani yang de bawa datang tu, de mo kas tipu kitong! Orang itu de masuk ke sa pu kamar baru paksa mo tidur deng sa, tapi sa langsung batariak besar-besar. ");
INSERT INTO pmy_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","De dengar sa batariak tu yang de langsung lari kluar. Ini kam liat! De pu pakean ada tatinggal di sa ni.” ");
INSERT INTO pmy_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Jadi Potifar pu istri simpan Yusup pu pakean tu di dia, sampe nanti de pu suami pulang. ");
INSERT INTO pmy_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Waktu de pu suami pulang, de crita lagi begini, “Orang kerja Ibrani yang ko bawa kesini tu, de tadi mo bikin kurang ajar deng saya! ");
INSERT INTO pmy_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Tapi sa langsung batariak kras-kras, itu yang de langsung lari kluar. Ini ko liat! De pu pakean ada tatinggal ni.” ");
INSERT INTO pmy_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Dengar de pu istri crita tu, Yusup pu tuan de emosi skali. ");
INSERT INTO pmy_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Langsung de suru de pu orang-orang pigi tangkap Yusup baru kas masuk de ke penjara, di tempat raja biasa kurung-kurung orang. Jadi begitu suda, Yusup de dapa kurung di penjara situ. ");
INSERT INTO pmy_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Waktu Yusup de di penjara, TUHAN yang ada sama-sama deng dia. TUHAN tra perna stop kas tunjuk De pu sayang sama Yusup. TUHAN yang bikin sampe kepala penjara tu, de snang deng Yusup. ");
INSERT INTO pmy_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Kepala penjara ni de kas tugas sama Yusup untuk urus smua orang yang dapa tahan dalam penjara, trus untuk bikin smua kerja yang ada di penjara itu juga. ");
INSERT INTO pmy_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Karna TUHAN yang ada sama-sama deng Yusup jadi TUHAN bikin smua yang Yusup de kerja jadi bagus skali. Itu yang, kepala penjara ni, de juga su tra perlu jaga liat Yusup pu kerja lagi. ");
INSERT INTO pmy_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Brapa waktu begini, raja Mesir pu orang kerja dua ni bikin masala besar deng raja. Satu tu kepala dari tukang minuman, trus yang satu lagi tu kepala dari tukang masak. ");
INSERT INTO pmy_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Raja mara skali sama raja pu orang penting dua ni, kepala dari tukang minuman deng kepala dari tukang masak tu. ");
INSERT INTO pmy_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Itu yang, raja de kas masuk dong dua ke dalam penjara. Dong dapa tahan di penjara yang sama deng Yusup, di penjara yang ada di kepala pasukan raja pu ruma. ");
INSERT INTO pmy_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Kepala pasukan raja ni de kas tugas Yusup untuk jaga liat dong dua ni dalam penjara situ. Jadi begitu suda, dong dua tinggal di penjara ni lama juga. ");
INSERT INTO pmy_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Baru satu malam begini, raja Mesir pu orang penting dua yang ada dalam penjara ni, kepala dari tukang minuman deng kepala dari tukang masak tu, dong dua mimpi. Tapi dong pu mimpi tu beda-beda trus de pu arti juga beda. ");
INSERT INTO pmy_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Waktu pagi-pagi Yusup pigi liat dong dua begini, dong kliatan macam ada rasa susa skali. ");
INSERT INTO pmy_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Jadi Yusup de tanya raja pu orang penting dua tu, “Sodara, knapa hari ini kam kliatan macam susa skali?” ");
INSERT INTO pmy_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Baru dong dua jawab, “Tadi malam tong ada mimpi, tapi trada orang yang bisa kas arti tong dua pu mimpi.” Yusup bilang sama dong dua, “Sodara, cuma Allah saja yang bisa bikin orang tau arti mimpi. Coba, kam crita kam pu mimpi itu dulu, sa dengar.” ");
INSERT INTO pmy_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Itu baru kepala dari tukang minuman, de crita de pu mimpi ke Yusup, de bilang begini, “Di sa pu mimpi tu, sa liat ada tanaman anggur pas depan saya. ");
INSERT INTO pmy_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Tanaman tu de pu ranting ada tiga. Pas daun baru mo tumbu di de pu ranting-ranting, begini de pu bunga-bunga su mulai kluar. Langsung begini bua-bua anggur juga su kluar, tapi begini de pu bua anggur su masak-masak. ");
INSERT INTO pmy_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Baru di sa pu tangan, sa ada pegang raja pu cangkir. Jadi, sa ambil anggur tu trus sa ramas kas kluar de pu air anggur ke raja pu cangkir itu, baru sa kasi cangkir itu ke raja.” ");
INSERT INTO pmy_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Habis dengar mimpi tu, Yusup bilang sama dia, “Sodara pu mimpi de pu arti begini: Ranting tiga tu, de pu arti tiga hari. ");
INSERT INTO pmy_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Tiga hari lagi raja nanti kas naik sodara ke atas. Trus de bikin ko nanti kembali kerja lagi sama raja dia sperti dulu, jadi kepala dari tukang minuman lagi. ");
INSERT INTO pmy_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Tapi kalo sodara pu keadaan su baik, jang lupa sa ka. Sodara bisa kas tunjuk sodara pu baik ke saya, deng kastau sa pu masala ini sama raja. Supaya raja bisa kas kluar sa dari penjara sini ka. ");
INSERT INTO pmy_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Habis dulu orang paksa bawa sa kesini dari orang Ibrani pu tempat sana. Trus, disini juga, sa tra bikin sala apapa tapi dong kas masuk sa ke penjara.” ");
INSERT INTO pmy_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Waktu kepala dari tukang masak de dengar kalo mimpi tu de pu arti bagus, de lagi bilang Yusup, “Sa juga ada mimpi. Di sa pu mimpi tu sa ada bawa kranjang tiga di sa pu kepala, kranjang itu yang biasa pake untuk isi kue. ");
INSERT INTO pmy_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Dalam kranjang yang paling atas tu, ada kue macam-macam yang tukang masak dong bikin untuk nanti sa kasi raja. Tapi burung-burung dong datang trus makan kue-kue itu.” ");
INSERT INTO pmy_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Habis de crita, Yusup bilang, “Sodara pu mimpi de pu arti begini: Kranjang tiga tu, de pu arti tiga hari. ");
INSERT INTO pmy_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Jadi, dalam tiga hari ni, raja de nanti kas naik sodara ke atas. De kas naik sodara di atas tiang satu, trus sodara pu badan dapa gantung disitu. Nanti burung-burung makan sodara pu daging-daging di badan.” ");
INSERT INTO pmy_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Su tiga hari begini, pas raja pu ulang taun, raja de bikin acara deng de pu orang-orang penting smua. Raja panggil kepala dari tukang minuman deng kepala dari tukang masak dari penjara, trus bawa dong dua ke depan orang-orang itu. ");
INSERT INTO pmy_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Habis itu, raja panggil kepala dari tukang minuman kembali kerja lagi sama raja. De kembali bawa minuman untuk raja lagi. ");
INSERT INTO pmy_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Tapi kepala dari tukang masak ni, raja suru orang gantung de di tiang satu macam yang Yusup su bilang sama dong dua. ");
INSERT INTO pmy_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Tapi kepala dari tukang minuman tu, de su tra ingat Yusup sama skali. ");
INSERT INTO pmy_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Skarang begini, su dua taun lewat, baru raja Mesir ni de mimpi. Di de pu mimpi tu, de ada bediri di pinggir sungai Nil. ");
INSERT INTO pmy_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Kaget begini, ada sapi tuju yang bagus-bagus baru gemuk-gemuk lagi. Dong kluar dari sungai Nil situ, baru makan rumput alang-alang di pinggir sungai tu. ");
INSERT INTO pmy_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Trus begini, ada sapi tuju yang muncul lagi. Tapi dong kurus skali, baru badan tra baik. Sapi yang kurus skali tu dong bediri di sebla sapi yang gemuk, di pinggir sungai Nil situ. ");
INSERT INTO pmy_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Trus begini sapi-sapi yang kurus skali tu dong makan sapi yang gemuk-gemuk itu. Pas liat itu tu yang raja de bangun. ");
INSERT INTO pmy_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Tra lama begini, raja de tatidur baru mimpi lagi. Dalam de pu mimpi tu, de liat ada bulir tuju yang tumbu di tangke gandum satu. Begini bulir-bulir tuju tu dong su taisi penu deng biji-biji gandum baru su kuning-kuning lagi. ");
INSERT INTO pmy_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Tapi begini, ada bulir tuju lagi yang muncul. Bulir-bulir tu dong kurus skali, baru de kring macam gara-gara kena angin panas dari ara tempat kring. ");
INSERT INTO pmy_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Kaget begini, bulir kring yang tuju tu, dong telan bulir tuju yang taisi penu itu. Langsung raja de bangun, baru de sadar kalo tadi de cuma mimpi saja. ");
INSERT INTO pmy_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Besok pagi begini, raja de su gelisa skali. De suru panggil orang-orang yang biasa pake fui-fui sama smua orang-orang pintar yang ada di Mesir, baru de crita de pu mimpi sama dorang. Tapi trada orang yang bisa kastau mimpi dua tu pu arti. ");
INSERT INTO pmy_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Begini, kepala dari tukang minuman yang dulu sama-sama deng Yusup di penjara tu de bilang, “Bapa raja, sa baru ingat skarang. Memang sa su bikin sala besar suda! ");
INSERT INTO pmy_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Waktu bapa raja mara sama sa deng kepala dari tukang masak dulu, bapa raja kas masuk tong dua di penjara yang di kepala pasukan raja pu tempat. ");
INSERT INTO pmy_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","12","Satu malam begini tong dua mimpi. Baru ada anak muda dari Ibrani yang dulu de kerja sama kepala dari pasukan raja. Sa deng kepala dari tukang masak crita tong pu mimpi sama dia, trus de kastau arti dari tong dua pu mimpi masing-masing. ");
INSERT INTO pmy_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Baru, arti yang de kastau tong tu memang itu jadi smua. Bapa raja panggil sa kembali kerja lagi, trus bapa raja suru orang gantung kepala tukang masak tu di tiang satu.” ");
INSERT INTO pmy_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Habis dengar itu, raja langsung suru pigi ambil Yusup dari penjara tu. Dong cepat-cepat pigi kas kluar Yusup, baru Yusup pigi cukur trus ganti pakean, baru pigi ke depan raja. ");
INSERT INTO pmy_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Pas sampe, raja bilang Yusup, “Sa ada mimpi, tapi trada orang yang bisa kas arti sa pu mimpi. Trus ada yang bilang sama sa kalo ko bisa kas arti mimpi.” ");
INSERT INTO pmy_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Trus Yusup de bilang raja, “Bapa raja, sa tra bisa kas arti mimpi. Allah yang bisa. Allah nanti kas arti mimpi yang de pu arti tu baik untuk bapa raja.” ");
INSERT INTO pmy_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Suda, raja de bilang, “Sa mimpi, sa ada bediri di pinggir sungai Nil. ");
INSERT INTO pmy_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Trus begini, sapi tuju yang badan bagus-bagus baru gemuk-gemuk kluar dari sungai Nil tu, baru dong makan rumput alang-alang disitu. ");
INSERT INTO pmy_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Trus begini, sapi tuju muncul lagi, tapi dong kurus skali baru tra baik skali, tinggal kulit lapis tulang suda. Sa tra perna liat sapi yang tra baik begitu di Mesir sini. ");
INSERT INTO pmy_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Sapi-sapi yang kurus skali baru badan tra baik tu, dong makan sapi tuju yang gemuk-gemuk tadi tu. ");
INSERT INTO pmy_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Tapi sapi-sapi kurus skali tu, dong tetap kurus skali, padahal dong su makan sapi yang gemuk-gemuk itu. Pas disitu, sa bangun. ");
INSERT INTO pmy_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Begini sa tidur lagi baru sa mimpi lagi. Sa liat ada bulir tuju yang tumbu di tangke gandum satu. Begini bulir-bulir tu dong su taisi penu deng biji-biji gandum baru su kuning-kuning. ");
INSERT INTO pmy_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Begini, tuju bulir gandum tumbu lagi, tapi dong kurus skali baru su layu karna kena angin panas dari ara tempat kring. ");
INSERT INTO pmy_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Bulir kurus tu dong telan bulir yang taisi penu itu satu kali, dong telan tuju-tuju tu. Sa su kastau sa pu mimpi ni sama orang-orang yang biasa pake fui-fui, tapi trada yang bisa kas arti sa pu mimpi.” ");
INSERT INTO pmy_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Trus Yusup de jawab raja, “Bapa pu mimpi dua-dua tu pu arti sama. Allah su kastau bapa raja apa yang Allah mo bikin. ");
INSERT INTO pmy_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Sapi tuju yang bagus-bagus tu, de pu arti tuju taun. Bulir tuju yang isi penu itu juga sama, de pu arti tuju taun. Mimpi dua-dua tu pu arti sama. ");
INSERT INTO pmy_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Sapi tuju yang kurus skali baru badan tra baik tu, yang muncul habis itu, dong pu arti tuju taun. Sama juga deng bulir tuju yang kurus baru kring macam gara-gara kena udara panas dari tempat kring, dong pu arti tu nanti ada klaparan tuju taun. ");
INSERT INTO pmy_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Allah su kas tunjuk bapa raja apa yang Allah mo bikin nanti, sperti yang sa su bilang tadi. ");
INSERT INTO pmy_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Jadi, tuju taun yang pertama yang su mo datang ni, di Mesir pu tempat smua nanti makanan banyak skali sampe ful-ful. ");
INSERT INTO pmy_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Tapi habis itu, nanti ada tuju taun klaparan yang para skali sampe orang-orang lupa kalo perna ada makanan yang ful-ful di Mesir. Klaparan ni bikin sampe Mesir ni jadi kring skali, trada hasil tana lagi. ");
INSERT INTO pmy_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Klaparan ni para skali sampe, trada yang ingat sama skali kalo perna ada makanan yang ful-ful di Mesir sini. ");
INSERT INTO pmy_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Allah kasi bapa raja mimpi dua kali karna Allah pasti bikin arti mimpi tu de jadi betul-betul. Trus Allah su mo bikin itu dalam waktu dekat ini. ");
INSERT INTO pmy_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Itu jadi, lebi baik bapa raja pili satu orang yang pintar yang de pu cara pikir bagus untuk pimpin. Baru bapa raja kasi de kuasa atur tana Mesir ni smua. ");
INSERT INTO pmy_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Lebi baik raja juga pili orang-orang yang jaga liat hasil panen. Dong ni yang nanti ambil satu dari tiap lima hasil kebun pas tuju taun yang makanan ada ful-ful di Mesir ni. ");
INSERT INTO pmy_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Trus bapa raja kasi dong kuasa untuk kumpul makanan yang dari tuju taun pas tong pu makanan ada banyak tu di raja Mesir pu kota-kota. Trus dong jaga makanan tu smua dari tuju taun itu supaya nanti ada makanan di kota situ. ");
INSERT INTO pmy_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Makanan tu nanti tong simpan supaya nanti waktu klaparan tuju taun di Mesir tu jadi, tong tetap ada makanan. Begitu supaya bapa pu orang-orang dong trakan mninggal gara-gara lapar.” ");
INSERT INTO pmy_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Raja Mesir sama de pu orang-orang penting dong smua stuju deng yang Yusup bilang. ");
INSERT INTO pmy_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Jadi, raja Mesir de bilang de pu orang-orang penting, “Tong trakan dapat orang yang sperti Yusup ini, yang Roh Allah ada sama-sama deng dia.” ");
INSERT INTO pmy_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Trus raja Mesir de bilang sama Yusup begini, “Karna Allah su kastau itu smua sama ko, jadi pasti su jlas kalo trada orang yang lebi pintar trus yang pu cara pikir bagus macam ko begini. ");
INSERT INTO pmy_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Sa angkat ko untuk jadi sa pu wakil. Nanti sa pu orang-orang smua dengar ko pu printa. Trakan ada orang yang bisa printa ko, kecuali sa yang duduk di kursi raja ini saja.” ");
INSERT INTO pmy_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Jadi, raja Mesir de bilang Yusup begini, “Skarang, sa tunjuk ko jadi sa pu wakil untuk pimpin Mesir ini smua.” ");
INSERT INTO pmy_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Habis itu, raja Mesir de lepas cincin dari de pu tangan, cincin yang biasa raja Mesir dong pake untuk cap-cap surat penting, baru pasang di Yusup pu jari. Habis itu, de kas pake Yusup pakean dari kain halus trus kas pake kalung emas di Yusup pu leher. ");
INSERT INTO pmy_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Baru, raja Mesir de kasi Yusup kreta prang yang paling nomor satu habis raja pu kreta prang. Jadi kalo de mo lewat situ, nanti ada orang yang triak, “Buka jalan! Buka jalan!” Jadi, begitu suda, Yusup dapa angkat jadi raja pu wakil untuk pimpin tana Mesir smua. ");
INSERT INTO pmy_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Trus raja bilang Yusup, “Memang sa ni raja Mesir. Tapi sa bilang orang-orang smua, kalo trada ko pu ijin, tra bole ada orang yang bikin apapa di Mesir sini.” ");
INSERT INTO pmy_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Baru raja Mesir kas nama Yusup deng nama Mesir satu. Itu jadi, Yusup pu nama ganti jadi Safnat-Paaneah. Baru raja kasi Asnat untuk jadi Yusup pu istri. Asnat ni Potifera pu anak prempuan. Potifera tu imam di kuil On. Jadi mulai dari situ Yusup de muncul jadi raja pu wakil yang pu kuasa untuk Mesir smua. ");
INSERT INTO pmy_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Waktu raja Mesir angkat Yusup jadi de pu wakil tu, Yusup pu umur su 30 taun. Habis itu, Yusup kluar dari istana baru jalan kliling tana Mesir smua. ");
INSERT INTO pmy_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Waktu tuju taun pertama yang makanan ada ful-ful di Mesir tu, orang Mesir dong pu hasil kebun tu sarat skali. ");
INSERT INTO pmy_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Jadi, dalam tuju taun tu, Yusup pu orang kerja dong kumpul hasil gandum yang masi ada sisa banyak tu, baru dong simpan itu di kota-kota. Masing-masing kota di Mesir tu ada de pu tempat simpan sendiri, untuk hasil panen yang dong dapat di kebun-kebun dekat kota itu. ");
INSERT INTO pmy_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Hasil panen yang Yusup dong kumpul tu banyak skali, sampe dong su tra sanggup hitung lagi. Habis, itu macam hitung pasir di pante satu-satu begitu. ");
INSERT INTO pmy_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Baru waktu itu tu, waktu dong blum masuk taun-taun klaparan, Yusup pu anak laki-laki dua lahir. Yusup pu anana dari istri Asnat, Potifera pu anak prempuan. Potifera tu imam di kuil On. ");
INSERT INTO pmy_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Jadi, Yusup de kas nama de pu anak Manasye, karna de bilang, “Allah su bikin sa lupa sa pu susa smua dulu, deng bikin sa lupa sa bapa pu satu ruma.” ");
INSERT INTO pmy_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Trus Yusup kas nama de pu anak yang kedua Efraim, karna de bilang begini, “Allah su kasi sa anana di tana ini, tempat yang dulu sa dapat susa banyak.” ");
INSERT INTO pmy_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Skarang begini, Mesir pu tuju taun waktu makanan ful-ful tu su slesai. ");
INSERT INTO pmy_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Trus tuju taun waktu klaparan para tu su mulai, sama sperti yang Yusup de su bilang dulu. Di smua tempat trada makanan sama skali, tapi di Mesir pu daera smua ada makanan. ");
INSERT INTO pmy_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Jadi waktu smua orang di Mesir ni su mulai mendrita klaparan juga, dong pigi ke raja Mesir minta makanan. Trus raja suru dong pigi ke Yusup baru bilang dorang begini, “Apa saja yang Yusup de suru, kam bikin itu!” ");
INSERT INTO pmy_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Jadi, pas waktu klaparan su tamba para skali di Mesir pu tempat smua ni, Yusup de mulai buka tempat-tempat yang dulu de pake simpan gandum itu, baru de jual ke orang-orang Mesir dorang. ");
INSERT INTO pmy_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Orang-orang dari mana-mana juga tu, dong smua datang ke Mesir untuk bli gandum dari Yusup juga. Habis, klaparan yang para betul-betul tu, jadi di smua tempat lain juga. ");
INSERT INTO pmy_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Waktu Yakub de dengar kalo di Mesir ada gandum, de bilang sama de pu anana, “Anana, kam bingung-bingung untuk? ");
INSERT INTO pmy_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Bapa dengar di Mesir dong ada jual gandum tu. Kam pigi bli suda! Daripada tong mati lapar disini.” ");
INSERT INTO pmy_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Jadi, Yusup pu kaka yang spulu orang tu, dong smua pigi ke Mesir untuk bli gandum. ");
INSERT INTO pmy_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Tapi Yakub de tra kas ijin Yusup pu sodara sunggu yang nama Benyamin ni ikut dorang, karna de takut nanti de juga kena apapa lagi. ");
INSERT INTO pmy_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Kanaan dong juga ada kena klaparan, jadi Yakub pu anana deng orang-orang lain dari mana-mana tu, dong smua pigi ke Mesir. ");
INSERT INTO pmy_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Di Mesir ni, Yusup su jadi raja pu wakil. Baru Yusup de ni juga yang atur bagian jual-jual gandum ke orang-orang smua. Jadi, waktu Yusup pu kaka dong datang, dong tunduk hormat ke Yusup sampe ke tana. ");
INSERT INTO pmy_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Pas Yusup liat de pu kaka dorang, de langsung knal dorang. Tapi de bikin diri macam orang lain begitu, trus de bentak-bentak tanya de pu sodara dorang, “Kam ni dari mana?” Dong jawab, “Dari Kanaan, bapa. Tong datang mo bli makanan.” ");
INSERT INTO pmy_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Memang Yusup de knal de pu sodara dong tapi de pu sodara dong trada yang knal dia. ");
INSERT INTO pmy_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Pas disitu tu yang Yusup de ingat de pu mimpi dulu yang tentang de pu sodara dorang. Trus de bilang sama dorang, “Kam ni pasti mata-mata! Kam pasti mo liat Mesir ni bisa dapa srang dari sebla mana to?!” ");
INSERT INTO pmy_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Baru dong jawab Yusup, “Trada bapa! Tong datang cuma untuk bli makanan saja. ");
INSERT INTO pmy_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Tong smua ni sodara satu bapa. Tong bukan mata-mata. Tong ni orang jujur bapa.” ");
INSERT INTO pmy_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Tapi Yusup balik bilang dorang, “Trada! Kam datang untuk liat tong pu negara untuk srang tong pu negara pasti.” ");
INSERT INTO pmy_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Trus dong jawab, “Bapa, tong ini ada 12 orang baku sodara, kitong smua satu bapa. Tong pu ade bungsu ada tinggal deng tong pu bapa dong di Kanaan. Trus tong pu sodara laki-laki satu lagi juga ada, tapi de su mninggal.” ");
INSERT INTO pmy_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Tapi Yusup langsung bilang, “Suda! Yang sa bilang ni benar. Kam ni memang mata-mata. ");
INSERT INTO pmy_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Sa mo tes kam dulu. Bawa kam pu ade bungsu tu ke mari. Sa sumpa deng raja Mesir pu nama, kam trakan kas tinggal tana ini kalo kam pu ade bungsu tra datang. ");
INSERT INTO pmy_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Kirim satu orang dari kam pigi ambil kam pu ade bungsu itu. Tapi kam yang lain sa tahan di penjara sini sampe ada bukti kalo yang kam bilang tu benar. Kalo tra benar, deng raja Mesir pu nama, sa sumpa, kam ni pasti mata-mata.” ");
INSERT INTO pmy_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Jadi suda, Yusup pu sodara-sodara dong smua dapa tahan tiga hari dalam penjara. ");
INSERT INTO pmy_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Pas hari ketiga begini, Yusup bilang de pu kaka dorang, “Sa ini orang yang hormat Allah jadi, kam bikin yang sa bilang ni supaya kam tetap hidup. ");
INSERT INTO pmy_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Untuk kas bukti kalo kam ini memang orang jujur, satu orang dari kam harus dapa tahan disini. Tapi kam yang lain bawa pulang makanan ni ke kam pu kluarga yang klaparan di ruma. ");
INSERT INTO pmy_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Tapi, kam harus bawa kam pu ade bungsu tu waktu kam kembali, supaya kas bukti yang kam bilang tu benar, trus sa trakan hukum mati kam.” Yusup pu kaka-kaka dong stuju deng yang Yusup bilang. ");
INSERT INTO pmy_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Habis itu, Yusup pu sodara spulu tu dong baku bicara sendiri, “Pasti tong dapa hukum gara-gara tong pu sala sama tong pu sodara dulu. Dulu de mohon-mohon sama kitong baru tong smua bikin tra mo tau. Padahal tong liat de su stenga mati skali. Skarang baru tong rasa de pu susa.” ");
INSERT INTO pmy_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Itu baru Ruben de angkat bicara, “Itu to, waktu itu sa su bilang kam, jang bikin sala sama anak itu. Tapi kam tra mo dengar saya, kam liat skarang! Tong dapa hukum dari Allah gara-gara tong bunu dia.” ");
INSERT INTO pmy_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Tapi dong tratau kalo Yusup de mngerti apa yang dong bicara, karna dong bicara ke de tu lewat satu orang yang kastau arti bahasa. ");
INSERT INTO pmy_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Waktu Yusup de dengar yang dong ada bicara tu, de pigi kas tinggal dorang, baru de bongkar mnangis. Sampe su habis mnangis baru de balik baru lanjut bicara deng dorang lagi. Trus Yusup de suru orang ikat Simeon pas depan de pu kaka-kaka yang lain. ");
INSERT INTO pmy_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Habis itu, Yusup de suru de pu orang kerja dong untuk isi gandum ke de pu kaka dong pu karung-karung. Baru de suru kas masuk uang yang dong pake bayar tu kembali ke de pu kaka dong pu karung masing-masing. Trus Yusup suru kasi makanan untuk dong bawa makan di jalan nanti. De pu orang kerja dong bikin yang de suru. ");
INSERT INTO pmy_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Habis itu, Yusup pu sodara dong taru dong pu karung yang ada biji gandum tu di atas dong pu kledai, baru dong bawa jalan pulang. ");
INSERT INTO pmy_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Waktu dong brenti di tempat satu untuk tidur karna su malam, satu dari dong buka de pu karung gandum untuk kas makan de pu kledai. Pas de buka karung begini, de liat de pu uang ada di atas biji-biji gandum dalam karung ni. ");
INSERT INTO pmy_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Itu tu, de langsung kastau de pu sodara dorang, “We kam, liat eh! Sa pu uang dapa kas kembali eh! Ada dalam sa pu karung ini.” Pas dong liat begitu, dong pu jantung kaya mo talepas ka, baru dong su takut skali. Dong baku liat trus bilang, “Allah su bikin apa sama tong lagi ni?” ");
INSERT INTO pmy_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Pas dong sampe di Kanaan, dong crita smua yang su jadi sama dong ke dong pu bapa Yakub. Dong bilang begini, ");
INSERT INTO pmy_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Bapa, orang yang jadi raja Mesir pu wakil tu, de bentak-bentak kitong. Baru de bilang kalo kitong ni mata-mata yang mo srang dong pu negara. ");
INSERT INTO pmy_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Tapi tong bilang de begini, ‘Tong bukan mata-mata, tong ni orang jujur. ");
INSERT INTO pmy_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Tong ini ada 12 orang baku sodara, kitong smua satu bapa. Tong pu sodara satu su mninggal, trus yang bungsu tu, de ada deng bapa di ruma di Kanaan.’ ");
INSERT INTO pmy_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Baru raja pu wakil tu de bilang kitong, ‘Bikin begini supaya sa bisa tau kalo kam tu orang jujur ka trada: Satu orang dari kam harus tinggal disini. Kam yang lain bisa bawa pulang gandum ni untuk kam pu kluarga yang ada klaparan. ");
INSERT INTO pmy_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Trus bawa kam pu ade yang bungsu tu kesini waktu kam balik ke Mesir. Begitu baru sa percaya kam ni memang orang jujur, bukan mata-mata. Itu baru nanti sa kas lepas kam pu sodara tu. Trus kam bisa bli-bli ato mo jual juga bisa di Mesir sini.’ ” ");
INSERT INTO pmy_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Skarang begini, pas dong smua kas kosong dong pu karung, dong kaget liat di dong pu karung masing-masing ada uang yang tadi dong pake bayar! Dong smua langsung su takut skali, dong pu bapa Yakub juga takut. ");
INSERT INTO pmy_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Bapa Yakub langsung bilang dorang, “Kam mo bikin sa pu anana smua hilang ka? Yusup su trada, Simeon juga su trada, baru skarang kam mo ambil Benyamin dari sa juga! Sa harus susa macam bagemana lagi?” ");
INSERT INTO pmy_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Jadi Ruben de jawab de pu bapa, “Bapa, kasi Benyamin sama sa suda. Sa nanti jaga de baik-baik, sa pasti bawa de kembali. Kalo sa tra bawa de kembali, bapa bisa bunu sa pu anak laki-laki dua itu.” ");
INSERT INTO pmy_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Tapi Yakub de tetap bilang, “Tra bole! Sa pu anak kam tra bole bawa. De pu kaka kandung su mninggal jadi tinggal de saja yang sa punya skarang. Sa ni su tua, kalo de kena apapa di jalan, kam yang bikin sa pu hati susa, sampe sa bisa mninggal ni nanti.” ");
INSERT INTO pmy_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Satu kali begini, klaparan di Kanaan su tamba para skali. ");
INSERT INTO pmy_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Baru gandum yang Yusup pu sodara-sodara dong bawa dari Mesir su habis. Jadi, Yakub bilang de pu anana, “Kam pigi bli gandum lagi untuk kitong suda.” ");
INSERT INTO pmy_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Tapi Yehuda bilang, “Bapa, raja Mesir pu wakil tu de bilang tong tra bole liat de pu muka lagi kalo tong tra bawa tong pu ade bungsu. Raja pu wakil ni de bicara sunggu-sunggu ni. ");
INSERT INTO pmy_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Kalo bapa kas ijin tong pu ade Benyamin ni de ikut, tong mo pigi ke Mesir bli makanan. ");
INSERT INTO pmy_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Tapi kalo bapa tra kas ijin ade Benyamin de ikut, tong tra mo pigi. Habis raja Mesir pu wakil de su bilang, tong tra bole liat de pu muka lagi kalo tong pu ade bungsu de tra ikut.” ");
INSERT INTO pmy_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Baru Yakub bilang, “Knapa kam bikin masala yang bikin susa sa skali ka? Knapa kam pigi kastau raja pu wakil kalo kam masi ada ade?” ");
INSERT INTO pmy_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Baru dong jawab, “Habis raja pu wakil tu de tinggal tanya-tanya trus jadi. De tanya-tanya tentang tong deng tong pu kluarga. De tanya tong pu bapa masi hidup ka su trada. De juga tanya tong masi pu sodara yang lain ka trada. Jadi kitong jawab saja to. Kitong juga tratau kalo nanti de mo bilang tong bawa tong pu ade bungsu mo.” ");
INSERT INTO pmy_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Baru Yehuda bilang de pu bapa Yakub lagi, “Iyo bapa, tong bawa Benyamin suda. Nanti sa yang jaga dia. Daripada bapa deng tong pu kluarga, anana dorang sama tong smua mati gara-gara lapar lagi, lebi baik tong jalan skarang deng Benyamin, bapa. ");
INSERT INTO pmy_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Nanti sa yang tanggung jawab. Bapa bisa tuntut sa nanti kalo sa tra bawa de pulang trus taru de depan bapa. Sampe sa mninggal, nanti sa yang tanggung itu. ");
INSERT INTO pmy_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Kalo tong tra lama-lama begini, tong su bisa bolak-balik dua kali ni.” ");
INSERT INTO pmy_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Trus Yakub bilang, “Kalo memang mo begitu, mo bagemana lagi? Kam bawa hadia ke raja pu wakil itu skalian. Bawa sdikit dari tong pu geta-geta kental yang bisa pake untuk obat gosok tu, deng madu, ramuan-ramuan, bua kemiri, sama kacang almon yang paling bagus skali tu, baru pi kasi raja pu wakil itu. ");
INSERT INTO pmy_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Trus kam bawa uang lebi, kas dobol yang pertama kam bawa. Karna uang yang waktu itu ada dalam kam pu karung tu, kam harus bawa kembali. Sapa tau dulu ada yang sala kas masuk itu. ");
INSERT INTO pmy_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Suda! Kam jalan ke orang itu di Mesir suda. Bawa Benyamin, kam pu ade tu deng kam juga. ");
INSERT INTO pmy_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Waktu kam masuk mo ketemu raja pu wakil itu, sa minta Allah Yang Pu Kuasa Paling Besar supaya De bikin raja pu wakil tu de rasa kasian sama kam, baru de kas kembali Benyamin deng Simeon. Kalo sa, biar suda kalo memang sa pu anana mo hilang, mo bikin apa lagi.” ");
INSERT INTO pmy_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Jadi, Yusup pu sodara-sodara dong ambil hadia-hadia tu deng uang lebi, kas dobol yang pertama, trus dong brangkat ke Mesir sama-sama deng Benyamin. Pas sampe di Mesir, dong ketemu Yusup. ");
INSERT INTO pmy_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Waktu Yusup liat Benyamin ada sama-sama deng de pu sodara dorang, Yusup suru de pu orang yang biasa urus de pu ruma begini, “Bawa orang-orang itu ke sa pu ruma. Trus, potong binatang piara satu baru kas siap untuk nanti siang sa mo makan sama-sama deng dorang.” ");
INSERT INTO pmy_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Jadi orang itu de bikin sperti yang Yusup suru dia. De bawa Yusup pu sodara-sodara tu ke Yusup pu ruma. ");
INSERT INTO pmy_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Tapi Yusup pu sodara-sodara dong su takut stenga mati waktu dong dapa bawa ke raja pu wakil pu ruma. Dong su baku bicara, “Ini pasti gara-gara uang yang tong ketemu dalam tong pu karung waktu itu. Pasti nanti dong mo srang trus tangkap tong, bikin tong jadi dong pu budak, trus ambil tong pu kledai-kledai ini.” ");
INSERT INTO pmy_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Itu jadi, pas sampe di Yusup pu pintu ruma, dong bicara sama orang yang urus Yusup pu ruma itu. ");
INSERT INTO pmy_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Dong bilang begini, “Permisi bapa, begini, tong su perna datang satu kali untuk bli makanan di Mesir sini. ");
INSERT INTO pmy_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Tapi pas tong brenti di tempat satu untuk tidur, tong ketemu tong pu uang smua su dapa kas kembali dalam tong pu karung. Jadi skarang tong ada bawa uang ini kembali. ");
INSERT INTO pmy_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Tong juga ada bawa uang lain lagi untuk nanti bli makanan lagi. Tong tratau skali sapa yang taru uang itu dalam tong pu karung.” ");
INSERT INTO pmy_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Tapi orang itu de jawab, “Trapapa. Tenang saja, sodara jang takut. Kam pu Allah, kam pu bapa pu Allah tu yang kasi kam uang dalam karung itu. Uang yang kam pake bayar tu, sa su trima.” Trus orang itu de bawa Simeon ke dorang. ");
INSERT INTO pmy_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Orang itu bawa dong ke Yusup pu ruma. Trus, de kasi dong air untuk cuci kaki baru de kas makan dong pu kledai-kledai juga. ");
INSERT INTO pmy_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Habis itu, orang itu de kastau Yusup pu sodara dong kalo nanti dong mo makan sama-sama deng Yusup disitu. Jadi dong kas siap-siap dong pu hadia yang nanti siang dong mo kasi, pas Yusup datang kesitu. ");
INSERT INTO pmy_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Waktu Yusup su pulang, dong bawa dong pu hadia itu ke Yusup baru dong tunduk hormat Yusup sampe ke tana. ");
INSERT INTO pmy_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Habis itu, Yusup tanya dorang, “Bagemana, kam baik-baik saja ka? Kam pu bapa yang su tua, yang kam waktu itu bilang sa tu, de pu kabar bagemana? De masi ada to?” ");
INSERT INTO pmy_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Dong jawab, “Iyo bapa. Kitong pu bapa yang hormat bapa wakil ni, de ada baik-baik saja. De masi hidup.” Habis itu dong tunduk hormat Yusup sampe ke tana lagi. ");
INSERT INTO pmy_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Waktu Yusup liat de pu ade Benyamin yang satu mama deng dia, de bilang, “Ini kam pu ade bungsu yang kam perna crita itu ka?” Baru Yusup bilang Benyamin, “Sodara, sa minta Allah kas tunjuk De pu sayang sama ko.” ");
INSERT INTO pmy_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Trus Yusup de pigi dari situ habis de pu hati su tra bisa tahan skali. De su rindu de pu ade yang de paling sayang skali. Itu jadi, de masuk ke de pu kamar baru mnangis disana. ");
INSERT INTO pmy_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Habis itu de cuci muka baru de kluar lagi, trus de suru pigi taru makanan di meja-meja. Yusup de bicara tu de tahan prasaan skali. ");
INSERT INTO pmy_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Waktu dong taru makanan tu, Yusup pu makanan di meja sendiri, de pu sodara-sodara punya di meja sendiri. Trus orang Mesir dong yang ikut makan, dong juga di meja sendiri, habis orang Mesir dong rasa paling tra bisa skali kalo mo makan satu meja deng orang Ibrani dorang. ");
INSERT INTO pmy_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Yusup taru de pu sodara-sodara dong duduk baku hadap deng dia. De atur tu dari yang paling tua sampe yang paling bungsu. Waktu Yusup pu sodara-sodara dong liat dong pu tempat duduk dapa atur macam begitu, dong langsung baku liat, dong heran jadi. ");
INSERT INTO pmy_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Yusup suru de pu orang kerja untuk ambil makanan dari Yusup pu meja, trus taru di de pu sodara-sodara pu meja. Benyamin dapat makanan lima kali lipat lebi banyak dari de pu sodara-sodara yang lain. Habis itu dong makan deng minum sama-sama deng Yusup sampe dong puas. ");
INSERT INTO pmy_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Habis Yusup makan deng de pu sodara-sodara, de suru orang yang urus de pu ruma tu begini, “Ko isi gandum ke orang-orang ini pu karung. Takar banyak-banyak yang dong bisa bawa pulang. Trus taru dong pu uang di atas gandum di ujung karung. ");
INSERT INTO pmy_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Taru sa pu cangkir perak tu dalam dong pu ade bungsu pu karung, sama-sama deng de pu uang yang de pake bayar gandum.” Jadi, Yusup pu orang kerja ni de bikin sperti yang Yusup de suru. ");
INSERT INTO pmy_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Pas besok begini, subu-subu ni, Yusup pu sodara-sodara dong dapa kas ijin untuk pulang. Dong pulang deng dong pu kledai. ");
INSERT INTO pmy_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Pas dong baru kluar dari kota ni, blum jau juga tapi, Yusup bilang de pu orang yang urus ruma, “Siap-siap! Pigi kejar orang-orang yang tadi tu. Kalo ko su dapat dorang, bilang dong begini, ‘Knapa kam balas tong pu baik deng bikin jahat begini? ");
INSERT INTO pmy_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Knapa kam curi sa pu tuan pu cangkir perak itu? Cangkir itu yang de biasa pake minum, trus de juga pake untuk ilmu-ilmu. Kam su bikin hal yang jahat skali!’ ” ");
INSERT INTO pmy_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Waktu Yusup pu orang kerja ni baku dapat deng Yusup pu sodara-sodara dorang, de bilang dong sama sperti yang Yusup kastau de tadi. ");
INSERT INTO pmy_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Yusup pu sodara-sodara dong langsung bilang, “Bapa, knapa bapa bilang begitu? Tong tra mungkin skali bikin begitu, bapa. ");
INSERT INTO pmy_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Dulu saja, uang yang tong dapat dalam tong pu karung tu, tong bawa balik lagi kesini dari Kanaan sana. Jadi, tra mungkin skali tong mo ambil perak ka emas ka dari bapa wakil pu ruma! ");
INSERT INTO pmy_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Begini saja suda, kalo bapa dapat cangkir tu di sapa saja dari tong ini pu karung, biar de dapa hukum mati saja, trus tong ini nanti jadi bapa pu budak.” ");
INSERT INTO pmy_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Jadi Yusup pu orang kerja ni de jawab, “Iyo, apa yang kam bilang itu bagus juga, tapi hanya orang yang pegang cangkir saja yang nanti jadi sa pu budak. Kam yang lain nanti bebas dari sala.” ");
INSERT INTO pmy_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Jadi dong cepat-cepat kas turun dong pu karung smua ke tana baru buka dong pu karung-karung. ");
INSERT INTO pmy_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Trus Yusup pu orang kerja ni de mulai priksa baik-baik dong pu karung satu-satu. De mulai pertama dari anak yang paling tua sampe ke anak yang paling bungsu. Trus begini, de dapat cangkir tu dalam Benyamin pu karung. ");
INSERT INTO pmy_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Begitu tu, Benyamin pu kaka-kaka hati su paling susa skali, sampe dong robek dong pu baju. Suda, dong langsung kas naik dong pu karung tu ke kledai, baru dong kembali ke kota. ");
INSERT INTO pmy_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Waktu Yehuda deng de pu sodara-sodara dong su sampe di Yusup pu ruma, Yusup masi ada. Jadi dong datang langsung tunduk hormat Yusup sampe ke tana. ");
INSERT INTO pmy_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yusup langsung bilang dorang, “Barang apa yang kam bikin ini? Kam tratau ka kalo orang sperti sa ini bisa tau apa yang kam bikin deng ilmu-ilmu?” ");
INSERT INTO pmy_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yehuda de jawab, “Bapa, tong tratau mo bilang apa sama bapa. Tong mo jawab apa? Bagemana tong mo bikin benar diri? Allah su kas tunjuk tong ni sala. Jadi suda! Tong ini bapa pu budak suda, kitong sama-sama deng orang yang pegang cangkir tu juga.” ");
INSERT INTO pmy_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Tapi Yusup bilang, “Sa trakan bikin begitu! Kam yang lain bisa pulang baik-baik ke kam pu bapa. Tapi orang yang bawa sa pu cangkir itu, de saja yang tetap disini jadi sa pu budak.” ");
INSERT INTO pmy_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Jadi Yehuda de pigi ke dekat Yusup baru bicara, “Bapa, sa permisi bicara dulu. Sa minta ijin mo bilang barang satu sama bapa, tapi sa minta bapa jang mara. Karna bapa ni su macam raja Mesir. ");
INSERT INTO pmy_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Bapa wakil raja perna tanya kitong, ‘Kam masi punya bapa deng sodara lain lagi ka?’ ");
INSERT INTO pmy_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Trus tong jawab, ‘Tong masi ada bapa yang su tua sama ade yang masi muda yang lahir pas waktu bapa su tua. De pu kaka su mninggal jadi tinggal de sendiri yang masi hidup dari dong dua yang satu mama. Itu yang, tong pu bapa paling sayang de skali.’ ");
INSERT INTO pmy_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Trus bapa wakil raja bilang, ‘Bawa de kesini, supaya sa bisa liat dia.’ ");
INSERT INTO pmy_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Trus tong jawab, ‘Anak itu tra bisa kas tinggal tong pu bapa, karna kalo de kas tinggal bapa, nanti bapa de bisa mninggal.’ ");
INSERT INTO pmy_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Trus bapa wakil raja bilang, ‘Kam tra bole datang liat sa lagi kalo kam tra bawa kam pu ade itu.’ ");
INSERT INTO pmy_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Jadi waktu tong kembali ke tong pu bapa dulu, tong kastau yang bapa wakil raja bilang sama kitong itu. ");
INSERT INTO pmy_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Trus pas tong pu bapa bilang tong kembali bli makanan lagi, ");
INSERT INTO pmy_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","tong jawab, ‘Tong tra bisa pigi kesana lagi kalo tra bawa tong pu ade bungsu sama-sama deng kitong. Tong cuma bisa ketemu bapa wakil ni kalo sama-sama deng ade Benyamin ni bole.’ ");
INSERT INTO pmy_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Trus tong pu bapa jawab, ‘Kam tau kalo sa pu istri Rahel lahir anak dua itu saja untuk sa to? ");
INSERT INTO pmy_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Yang pertama su pigi dari saya, pasti binatang liar su bunu dia jadi skarang ni sa su tra perna liat de lagi. ");
INSERT INTO pmy_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Kalo kam ambil anak ini juga dari saya, trus de kena apapa lagi, kam cuma bikin sa pu hati rasa susa skali, sampe sa yang su tua ini mninggal nanti.’” ");
INSERT INTO pmy_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Yehuda de lanjut bicara, “Jadi, bapa wakil, kalo sa kembali ke sa pu bapa tra sama-sama deng tong pu ade bungsu ini, tong pu bapa pasti hati susa skali. De hidup tu cuma untuk anak ini saja. Tong pu bapa ni su tua skali, jadi kalo tong tra bawa ade ini, de pasti mninggal. ");
INSERT INTO pmy_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Tapi sa su bilang sa pu bapa kalo nanti sa yang tanggung sa pu ade Benyamin ini. Sa su bilang sa pu bapa begini, ‘Bapa bisa bilang sa yang tanggung jawab kalo nanti sa tra bawa de pulang. Sampe sa mninggal, nanti sa yang tanggung itu.’ ");
INSERT INTO pmy_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Jadi bapa wakil raja, biar sa yang tinggal disini ganti sa pu ade suda. Sa yang jadi bapa pu budak saja suda. Bapa bisa kas biar de pulang saja sama-sama deng de pu sodara-sodara yang lain ka. ");
INSERT INTO pmy_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Sa tra mungkin bisa pulang ke sa pu bapa kalo de pu anak satu ini tra kembali! Sa tra sampe hati mo liat apa yang nanti jadi deng tong pu bapa.” ");
INSERT INTO pmy_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Dengar Yehuda bilang begitu, Yusup su tra bisa tahan de pu hati depan de pu orang-orang kerja lagi. Jadi, de suru dong smua kluar kas tinggal de deng de pu sodara dong sendiri. Jadi, trada orang lain waktu Yusup de kastau de pu sodara dong kalo de tu Yusup, dong pu sodara. ");
INSERT INTO pmy_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Habis itu, Yusup de mnangis hancur sampe orang Mesir yang di luar ruangan tu, dong juga dengar de mnangis. Sampe orang-orang di raja pu istana juga su dengar kabar kalo Yusup de ada mnangis. ");
INSERT INTO pmy_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Trus Yusup bilang de pu sodara dorang, “Sa ini Yusup! Bapa betul masi hidup to?” Tapi waktu Yusup de pu sodara dong dengar de bilang begitu, dong langsung jadi takut skali sampe dong tra bisa buka mulut untuk jawab apa yang Yusup de tanya. ");
INSERT INTO pmy_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Trus Yusup bilang dorang, “Mari, dekat sa sini!” Trus dong maju ke dekat Yusup. Yusup bilang lagi, “Sa ni Yusup, kam pu sodara yang waktu itu kam jual ke Mesir. ");
INSERT INTO pmy_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Tapi kam jang rasa brat begitu, jang kas sala kam pu diri juga karna su jual sa dulu. Karna Allah De yang kirim sa duluan dari kam, untuk kas slamat orang-orang pu hidup skarang ni. ");
INSERT INTO pmy_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Klaparan ni baru dua taun. Nanti trakan ada orang yang bisa tanam ka panen ka, dalam lima taun ke depan ini. ");
INSERT INTO pmy_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Itu jadi, knapa Allah bawa sa kesini duluan dari kam, supaya sa bisa liat kam pu hidup deng kam pu anana cucu di bumi ni, trus kas slamat tong pu hidup deng cara luar biasa begini. ");
INSERT INTO pmy_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Jadi, bukan kam yang bikin sa sampe kesini, tapi Allah yang bikin sampe sa bisa ada disini. Allah De yang bikin sampe, sa bisa jadi orang penting yang raja de percaya skali. Raja Mesir kasi sa kuasa untuk urus de pu istana deng smua tana Mesir ini. ");
INSERT INTO pmy_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Skarang, kam pulang cepat trus bilang begini ke bapa, ‘Bapa pu anak Yusup bilang begini: Allah su bikin sampe sa jadi orang paling penting di Mesir. Jadi skarang juga, mari datang kesini suda! Jang tunggu lama lagi. ");
INSERT INTO pmy_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Bapa nanti tinggal di daera Gosyen, dekat deng saya. Bapa, anana cucu dorang, kambing domba, sapi, deng smua barang apa saja yang bapa punya. ");
INSERT INTO pmy_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Kalo bapa su di Gosyen, sa nanti jaga bapa. Klaparan ni masi tetap ada sampe lima taun lagi. Itu jadi, biar sa yang nanti jaga liat bapa pu kluarga smua, deng bapa pu binatang-binatang piara, supaya trakan kurang apapa lagi.’ ” ");
INSERT INTO pmy_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Trus Yusup bilang lagi, “Skarang kam su liat sendiri to, Benyamin ko juga, sa yang ada bicara ni saya suda, kam pu sodara Yusup. ");
INSERT INTO pmy_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Jadi, kam pigi bilang bapa suda kalo sa ni pu kuasa yang besar skali di Mesir sini. Smua yang kam su liat di Mesir sini juga tu, kastau bapa dia. Baru kam cepat bawa bapa de kesini.” ");
INSERT INTO pmy_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Yusup de langsung polo Benyamin baru de mnangis. Benyamin juga ikut mnangis di Yusup pu bahu langsung. ");
INSERT INTO pmy_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Masi mnangis-mnangis, Yusup de polo de pu sodara dong smua trus de cium dorang, baru dong mulai crita-crita deng dia. ");
INSERT INTO pmy_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Waktu raja pu satu istana dong dengar kalo Yusup pu sodara-sodara ada datang, raja deng de pu orang-orang kerja dong juga rasa snang. ");
INSERT INTO pmy_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Trus raja Mesir bilang Yusup begini, “Suru ko pu sodara dong bikin begini, ‘Taru gandum ni di atas binatang-binatang tu, trus pulang ke Kanaan. ");
INSERT INTO pmy_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Jemput kam pu bapa sama orang-orang yang satu ruma deng kam juga, baru pinda kesini. Nanti sa kasi kam tana di Mesir sini yang paling bagus. Karna tana tu de subur jadi, kam bisa dapat hasil yang paling bagus nanti.’ ");
INSERT INTO pmy_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Trus ko harus bilang dong untuk bikin begini, ‘Bawa kreta brapa dari Mesir sini untuk pigi jemput kam pu anana yang masi kecil deng kam pu istri-istri, jemput juga kam pu bapa baru bawa datang kesini. ");
INSERT INTO pmy_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Tra usa rasa sayang deng barang-barang yang kam kas tinggal itu, karna nanti disini kam dapat barang-barang paling bagus yang Mesir punya.’” ");
INSERT INTO pmy_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Jadi suda, Yakub pu anana dong bikin sperti yang raja Mesir printa dong bikin. Yusup kasi dong kreta sperti yang raja suru, trus de juga kasi dong makanan untuk nanti dong makan di jalan. ");
INSERT INTO pmy_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","De kasi dong masing-masing pakean baru satu-satu pasang, tapi de kasi Benyamin uang perak 300 deng pakean baru lima stel. ");
INSERT INTO pmy_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Yusup juga kirim kledai jantan spulu deng barang-barang paling bagus di Mesir di atas kledai-kledai itu untuk de pu bapa, waktu dong balik ke Mesir. Baru de kasi kledai betina spulu lagi yang nanti pikul gandum deng roti sama makanan lain juga. ");
INSERT INTO pmy_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Habis itu smua, Yusup suru de pu sodara dong pulang baru bilang dong begini, “Kam jang baku mara di jalan eh!” ");
INSERT INTO pmy_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Jadi Yusup de pu sodara dong kas tinggal Mesir baru dong pulang ke dong pu bapa Yakub. Pas sampe di Kanaan, ");
INSERT INTO pmy_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Yusup pu sodara dong bilang dong pu bapa, “Bapa, Yusup de masi hidup! Baru skarang ni Yusup de su jadi raja pu wakil yang pu kuasa untuk smua Mesir!” Tapi Yakub de cuma diam saja, de tra percaya sama dorang. ");
INSERT INTO pmy_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Tapi pas Yusup pu sodara dong kastau sama bapa Yakub smua yang Yusup suru dong kastau tu, tamba lagi waktu Yakub de liat kreta yang Yusup kirim untuk bawa de ke Mesir, langsung bapa Yakub ni de jadi smangat lagi. ");
INSERT INTO pmy_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Trus Yakub de bilang, “Sa pu anak Yusup masi hidup! Sa harus pigi liat de dulu seblum sa mninggal, cuma itu saja yang sa mau.” ");
INSERT INTO pmy_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Jadi suda, Yakub de kas siap de pu barang-barang smua baru de brangkat ke Mesir. Waktu de sampe di daera Bersyeba, de potong binatang untuk kasi korban ke Allah yang de pu bapa Isak semba. ");
INSERT INTO pmy_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Pas malam begini, Allah datang bicara sama Yakub sperti mimpi, Allah panggil dia, “Yakub, Yakub!” De jawab, “Ya Tuhan.” ");
INSERT INTO pmy_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Trus Allah bilang dia, “Sa ini Allah yang ko pu bapa semba. Jang takut, pigi saja ke Mesir, karna nanti Sa pasti bikin ko pu anana cucu jadi bangsa yang besar disana. ");
INSERT INTO pmy_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Sa pasti jalan sama-sama deng ko ke Mesir, baru nanti Sa bawa ko kembali kesini lagi. Trus, Yusup nanti ada di samping ko waktu ko mninggal.” ");
INSERT INTO pmy_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Habis itu, Yakub de kas tinggal daera Bersyeba, de lanjut jalan. Yakub pu anana dong bawa Yakub dong pu bapa, deng dong pu anana sama dong pu istri di kreta-kreta yang raja su kasi. ");
INSERT INTO pmy_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Dong bawa dong pu binatang piara deng barang-barang yang dong kumpul di tana Kanaan, trus dong smua sampe di Mesir, Yakub deng de pu anana cucu smua. ");
INSERT INTO pmy_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Anana deng cucu-cucu yang laki-laki ka prempuan ka, yang ada tu, de bawa dong smua ke Mesir. ");
INSERT INTO pmy_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Ini daftar nama dari Yakub deng de pu anana cucu yang pigi ke Mesir. Dong ini suda, orang Israel. Yakub pu anak pertama Ruben. ");
INSERT INTO pmy_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ruben pu anana tu Henok, Palu, Hezron, deng Karmi. ");
INSERT INTO pmy_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Trus Simeon pu anana tu Yemuel, Yamin, Ohad, Yakin, Zohar, sama Saul yang prempuan Kanaan pu anak. ");
INSERT INTO pmy_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Baru Lewi pu anana tu Gerson, Kehat, deng Merari. ");
INSERT INTO pmy_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Trus Yehuda pu anana tu Er, Onan, Syela, Peres, deng Zerah. Tapi Er deng Onan mninggal di tana Kanaan. De pu anak Peres pu anana tu Hezron deng Hamul. ");
INSERT INTO pmy_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Kalo Isakar pu anana tu Tola, Pua, Ayub, deng Simron. ");
INSERT INTO pmy_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Baru Zebulon pu anana tu Sered, Elon, deng Yahleel. ");
INSERT INTO pmy_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Enam anak laki-laki itu yang lahir dari Yakub pu istri Lea waktu dong di Padan-Aram, tamba deng anak prempuan satu yang nama Dina. Jadi dong smua, anana laki-laki deng prempuan tu ada 33 orang. ");
INSERT INTO pmy_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Baru Gad de pu anana tu Sifyon, Hagi, Syuni, Esbon, Eri, Arodi, deng Areli. ");
INSERT INTO pmy_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Kalo Asyer de pu anana tu Yimna, Yiswa, Yiswi, Beria, deng dong pu sodara prempuan Serah. Beria pu anana tu Heber deng Malkiel. ");
INSERT INTO pmy_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Kalo Gad deng Asyer tu Yakub pu anana laki-laki yang lahir dari Zilpa, budak prempuan yang Laban kasi ke de pu anak Lea. Dong pu banyak ada 16 orang. ");
INSERT INTO pmy_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Yakub pu istri Rahel pu anana tu Yusup deng Benyamin. ");
INSERT INTO pmy_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Waktu Yusup ada di tana Mesir, de dapa kas kawin deng Asnat. Asnat pu bapa tu Potifera, de yang jadi imam untuk dong pu tuhan di kuil On. Yusup pu istri Asnat ni lahir dua anak laki-laki yang pu nama Manasye deng Efraim. ");
INSERT INTO pmy_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benyamin pu anana tu Bela, Beker, Asbel, Gera, Naaman, Ehi, Ros, Mupim, Hupim, deng Ared. ");
INSERT INTO pmy_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Dong smua tu Yakub pu anana cucu dari de pu istri Rahel. Dong pu banyak ada 14 orang. ");
INSERT INTO pmy_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Trus Dan pu anak tu Husim. ");
INSERT INTO pmy_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naftali pu anana tu Yahzeel, Guni, Yezer, deng Syilem. ");
INSERT INTO pmy_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Dong ini yang lahir ari Yakub pu istri Bilha, budak prempuan yang Laban kasi ke de pu anak Rahel. Dong pu banyak ada tuju orang. ");
INSERT INTO pmy_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Yakub pu kluarga smua yang tiba di Mesir sama-sama deng Yakub tu ada 66 orang. Tapi ini blum hitung de pu mantu-mantu prempuan dong lagi. ");
INSERT INTO pmy_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Yusup pu anana yang lahir di Mesir ada dua orang. Jadi Yakub pu kluarga yang ada di Mesir smua tu ada 70 orang. ");
INSERT INTO pmy_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Waktu dong masi di jalan, Yakub suru Yehuda untuk jalan duluan pigi ketemu Yusup, baru panggil Yusup datang ke Gosyen untuk pigi liat de pu bapa Yakub. Waktu dong smua baru sampe di Gosyen, ");
INSERT INTO pmy_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yusup kas siap de pu kreta, trus pigi ke Gosyen untuk ketemu deng de pu bapa Yakub. Pas de ketemu de pu bapa Yakub ini, de polo de pu bapa baru de mnangis lama skali di de pu bapa pu bahu. ");
INSERT INTO pmy_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Trus Yakub ni bilang sama Yusup begini, “Skarang, sa su liat ko pu muka, trus su liat ko masi hidup. Jadi suda, Tuhan su bisa ambil saya.” ");
INSERT INTO pmy_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Habis itu Yusup bilang de pu sodara-sodara deng de pu bapa pu kluarga smua begini, “Sa mo pigi ketemu raja Mesir trus kastau dia kalo sa pu sodara-sodara deng sa pu bapa pu kluarga yang tinggal di Kanaan, su datang ke sa sini. ");
INSERT INTO pmy_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Nanti sa bilang raja, ‘Dong tukang jaga kambing domba deng sapi. Dong ada bawa dong pu binatang piara smua sama dong pu barang-barang smua juga.’ ");
INSERT INTO pmy_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Jadi waktu raja Mesir panggil kam baru tanya, ‘Kam pu kerja apa?’ ");
INSERT INTO pmy_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","nanti kam jawab, ‘Bapa, tong ini biasa jaga-jaga binatang piara dari waktu tong masi kecil sampe skarang, dari tong pu nene moyang memang su biasa kerja begitu.’ Bikin begitu supaya, nanti raja Mesir pasti kasi kam tinggal di daera Gosyen situ.” Yusup bilang begitu karna orang Mesir dong rasa paling tra bisa skali kalo mo sama-sama deng orang-orang yang biasa piara kambing domba itu. ");
INSERT INTO pmy_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","2","Habis itu, Yusup de bawa de pu sodara lima orang sama-sama deng dia untuk pigi ke raja. Baru Yusup de kastau raja Mesir begini, “Bapa raja, sa pu bapa sama sodara-sodara deng dong pu binatang piara, kambing domba, deng sapi smua su datang dari Kanaan. Dong datang deng dong pu barang-barang smua dari Kanaan juga, skarang dong su di Gosyen.” ");
INSERT INTO pmy_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Jadi, raja Mesir de tanya Yusup pu sodara lima orang itu, “Kam pu kerja apa?” Dong jawab, “Bapa, tong ini biasa jaga-jaga kambing domba, dari tong pu nene moyang memang su biasa kerja begitu.” ");
INSERT INTO pmy_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Baru dong bilang ke raja lagi, “Bapa, tong datang untuk mo tinggal di tana ni jadi pendatang saja. Habis su trada rumput lagi yang bisa jadi tong pu kambing domba ni pu makanan, gara-gara klaparan yang para di Kanaan sana. Jadi bapa tolong kas ijin tong untuk tinggal di daera Gosyen ka, kalo bisa.” ");
INSERT INTO pmy_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Trus raja Mesir bilang Yusup, “Skarang ko pu bapa deng ko pu sodara-sodara dong su ada disini deng ko. ");
INSERT INTO pmy_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Tana-tana di Mesir ni siap trima dong untuk tinggal disini. Kas tunjuk ko pu bapa deng sodara-sodara dong tempat yang paling baik di tana ini, kas biar dong tinggal di Gosyen. Trus ko juga liat, kalo ada dari ko pu sodara dong yang de jago jaga-jaga binatang, kasi dong tugas untuk jadi orang yang jaga liat sa pu binatang piara juga.” ");
INSERT INTO pmy_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Habis itu, Yusup bawa de pu bapa Yakub pigi ketemu raja Mesir juga. Baru Yakub de kas berkat raja Mesir ini. ");
INSERT INTO pmy_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Trus raja tanya Yakub, “Bapa pu umur su brapa taun?” ");
INSERT INTO pmy_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakub jawab, “Bapa raja, sa su hidup 130 taun, baru sa tinggal pinda-pinda dari satu tempat ke tempat lain trus, sama macam sa pu nene moyang dorang. Sa pu hidup ni susa, trus sa pu umur ni lebi pendek daripada sa pu nene moyang dong pu hidup.” ");
INSERT INTO pmy_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Habis itu, Yakub de kas berkat raja Mesir lagi, baru de kluar dari tempat raja situ. ");
INSERT INTO pmy_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Yusup bantu de pu bapa deng sodara-sodara dong untuk tinggal di Mesir. Yusup kasi dong tana paling bagus di Mesir untuk jadi milik, dekat kota Rameses, sperti yang raja Mesir suru Yusup de bikin. ");
INSERT INTO pmy_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yusup juga yang biasa liat-liat de pu bapa deng de pu sodara-sodara sama dong pu kluarga smua. Yusup kasi dong smua makanan, sampe dong pu anana kecil smua juga dapat makanan. ");
INSERT INTO pmy_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Waktu itu tu klaparan su paling para skali, sampe dimana saja tu trada makanan lagi. Orang-orang Mesir deng orang-orang Kanaan dong su trada tenaga karna lapar. ");
INSERT INTO pmy_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Dong su pake dong pu uang smua untuk bli gandum. Orang-orang Mesir deng Kanaan dong pu uang yang dong pake bayar gandum tu, Yusup yang kumpul, baru de bawa smua ke raja pu istana. ");
INSERT INTO pmy_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Jadi waktu orang Mesir deng orang Kanaan dong pu uang su habis sama skali, orang Mesir dong smua datang ke Yusup baru bilang, “Bapa, tolong kasi tong makan ka! Tong su trada uang sama skali ni bapa. Tolong, jang kas biar tong mati ka.” ");
INSERT INTO pmy_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Trus Yusup jawab, “Kalo kam pu uang su habis, kasi kam pu binatang piara kalo begitu. Baru sa kasi kam makanan.” ");
INSERT INTO pmy_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Jadi dong bawa dong pu binatang piara baru kasi Yusup. Trus Yusup kasi dong makanan tukar deng dong pu kuda, kambing domba, sapi-sapi deng kledai-kledai smua. Jadi taun itu tu Yusup kasi dong makanan ganti deng dong pu binatang-binatang piara smua. ");
INSERT INTO pmy_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Pas taun brikut tu, dong datang lagi ke Yusup baru bilang begini, “Bapa, tong tra tipu tapi, tong pu uang su habis, tong pu binatang piara juga tong su kasi smua sama bapa. Jadi skarang su trada apapa lagi yang tong bisa kasi untuk bisa dapat makanan, hanya tong pu diri deng tong pu tana saja. ");
INSERT INTO pmy_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Jang kas biar tong mati, trus tong pu kebun-kebun jadi kring, tapi tukar tong pu diri sama tana deng makanan saja suda. Nanti tong jadi raja Mesir pu budak, tong pu tana juga jadi raja Mesir pu tana. Kasi tong biji-biji gandum saja, supaya tong bisa hidup jang tong mati, trus supaya jang tana tu jadi kring.” ");
INSERT INTO pmy_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Jadi suda, Yusup bli tana di Mesir smua tu untuk raja Mesir. Orang Mesir smua harus jual dong pu tana, gara-gara klaparan ni su para skali. Dari situ, smua tana yang di Mesir tu jadi raja Mesir pu tana. ");
INSERT INTO pmy_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Baru orang-orang di kota-kota Mesir tu, dari ujung pukul ujung, Yusup bikin dong smua jadi raja Mesir pu budak. ");
INSERT INTO pmy_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Tapi imam di kuil-kuil, dong pu tana tra dapa ambil. Karna dong pu makanan tu tra perna kurang. Raja Mesir tetap kasi dong makanan trus jadi, dong tra perlu jual tana untuk bli makanan. ");
INSERT INTO pmy_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Habis itu, Yusup bilang orang-orang itu smua, “Dengar! Hari ni sa su bli kam pu diri deng kam pu tana untuk raja Mesir. Ini biji-biji yang kam bisa pake tanam di tana itu! ");
INSERT INTO pmy_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Tapi waktu kam panen, kam harus kasi satu dari tiap lima barang yang kam panen smua tu sama raja Mesir. Trus yang sisa kam bisa ambil untuk kam tanam lagi, trus kam deng kam pu anana kecil, sama kam pu orang ruma dong pu makanan.” ");
INSERT INTO pmy_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Orang-orang Mesir langsung bilang, “Bapa, ko su kas slamat kitong. Jadi kalo memang bapa snang deng kitong, tong siap jadi raja Mesir pu budak!” ");
INSERT INTO pmy_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Jadi, Yusup yang bikin sampe di Mesir tu ada aturan kalo orang-orang harus kasi satu dari tiap lima hasil dari dong pu kebun ke raja Mesir. Sampe skarang orang-orang Mesir masi ikut aturan itu. Hanya imam-imam di kuil saja yang masi pu tana sendiri. Dong pu tana tra jadi raja pu tana. ");
INSERT INTO pmy_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Jadi Yakub dong ni su tinggal di Mesir, di daera Gosyen. Dong dapat tana di Gosyen situ, trus dong pu anana cucu juga tamba banyak disitu. ");
INSERT INTO pmy_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakub de masi hidup 17 taun di tana Mesir. Jadi Yakub de hidup sampe de pu umur 147 taun. ");
INSERT INTO pmy_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Waktu pas Yakub de su mo mninggal, de panggil de pu anak Yusup baru de bilang, “Yusup, kalo ko sayang bapa, ko sumpa sunggu-sunggu trakan kubur bapa di Mesir sini. Deng begitu ko kas tunjuk ko pu sayang deng setia sama bapa. ");
INSERT INTO pmy_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Sa su mo ikut sa pu nene moyang dong ke tempat orang mati. Jadi, nanti bawa sa pu mayat dari Mesir ni, trus pigi kubur di tempat yang sa pu nene moyang dong ada dapa kubur.” Yusup de janji, “Sa pasti bikin yang bapa bilang ini.” ");
INSERT INTO pmy_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Trus Yakub bilang Yusup lagi, “Skarang ko sumpa dulu kalo ko pasti bikin yang sa bilang.” Jadi suda, Yusup de sumpa. Habis itu, Yakub de tunduk semba Allah di sebla kepala, di de pu tempat tidur. ");
INSERT INTO pmy_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Brapa waktu begini, ada orang yang kasi kabar sama Yusup kalo de pu bapa ada sakit para. Itu jadi Yusup langsung bawa de pu anana Manasye deng Efraim ni, pigi liat Yakub di Gosyen. ");
INSERT INTO pmy_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Pas dong sampe disana, ada yang kastau Yakub kalo Yusup dong ada datang mo liat dia. Jadi, Yakub kumpul de pu tenaga untuk duduk di de pu tempat tidur. ");
INSERT INTO pmy_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Baru Yakub de bicara ke Yusup, “Waktu sa di Betel di tana Kanaan situ, Allah Yang Pu Kuasa Paling Besar, De kas tunjuk De pu Diri ke saya, baru De kas berkat saya. ");
INSERT INTO pmy_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Allah De bilang begini, ‘Pasti Sa nanti bikin ko ada anana cucu yang banyak. Sampe ko nanti jadi moyang dari bangsa-bangsa yang banyak. Sa pasti kasi tana ni ke ko pu anana cucu dorang untuk nanti jadi dong pu tana trus.’ ” ");
INSERT INTO pmy_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Yakub bilang lagi, “Jadi Yusup, ko pu anak Efraim deng Manasye yang lahir di Mesir waktu sa blum datang ke Mesir ni, dong dua tu su jadi sa pu anak, su sama macam Ruben deng Simeon, sa pu anana itu. ");
INSERT INTO pmy_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Tapi ko pu anana yang habis dong dua, itu ko punya tetap. Nanti waktu bagi-bagi warisan, ko pu anana cucu yang habis Efraim deng Manasye ni, nanti dapat warisan dari Efraim deng Manasye dong pu bagian. ");
INSERT INTO pmy_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Waktu sa kembali dari tana Padan, ko pu mama Rahel mninggal di tana Kanaan, waktu tong su mo dekat Efrata. Waktu itu sa rasa sedi skali. Sa kubur ko pu mama di pinggir jalan mo dekat-dekat Efrata situ.” Efrata pu nama lain Betlehem. ");
INSERT INTO pmy_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Waktu Yakub liat Yusup pu anana, de tanya, “Ini sapa?” ");
INSERT INTO pmy_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yusup jawab, “Ini sa pu anana yang Allah kasi sama sa di Mesir sini.” Yakub bilang, “Kasi dekat dong dua kesini, sa mo kas berkat dong dua.” ");
INSERT INTO pmy_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Waktu itu Yakub pu mata su kabur karna de su tua, jadi de tra bisa liat baik. Jadi Yusup kas dekat de pu anana itu ke Yakub, baru Yakub de cium dong dua trus de peluk dorang. ");
INSERT INTO pmy_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Trus Yakub bilang Yusup, “Sa tra pikir skali kalo sa bisa ketemu ko lagi, tapi skarang ni Allah kasi sa untuk liat ko pu anana juga.” ");
INSERT INTO pmy_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Habis itu Yusup ambil de pu anana dua tu dari de pu bapa pu kaki baru de tunduk ke de pu bapa sampe ke tana. ");
INSERT INTO pmy_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Baru Yusup pegang de pu anak dua itu. Di kanan de pegang Efraim trus di kiri de pegang Manasye, supaya Manasye pas ada di sebla kanan Yakub trus Efraim di sebla kiri. Baru de bawa dekat ke de pu bapa Yakub. ");
INSERT INTO pmy_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Tapi Yakub de kas ulur de pu tangan kanan baru de taru di Efraim pu kepala, Efraim ni yang bungsu. Trus de taru de pu tangan kiri di Manasye, padahal Manasye yang tua. Jadi Yakub de pu tangan tasilang. ");
INSERT INTO pmy_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Habis itu de kas berkat Yusup, de bilang begini, “Sa pu tete Abraham deng sa pu bapa Isak, dong percaya sama Allah. Allah itu suda, yang jaga sa trus sampe skarang ini. ");
INSERT INTO pmy_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","De itu Malaikat yang su kas lepas sa dari bahaya apa saja. Sa minta Allah kas berkat anana ini. Supaya Abraham, Isak deng Yakub, nama-nama ini ni tetap dapa ingat karna ada anana ini. Sa minta supaya dong pu anana cucu tamba banyak skali di bumi ini.” ");
INSERT INTO pmy_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Tapi waktu Yusup liat de pu bapa taru tangan kanan di de pu anak Efraim de pikir itu kurang baik, jadi de pegang de pu bapa pu tangan untuk kas pinda dari Efraim pu kepala ke Manasye pu kepala. ");
INSERT INTO pmy_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Baru Yusup de bilang sama de pu bapa, “Jang begitu bapa! Ini ni yang anak tua, jadi bapa pu tangan kanan taru di anak yang tua ini.” ");
INSERT INTO pmy_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Tapi de pu bapa tolak de pu tangan. Trus bapa Yakub de bilang, “Sa tau, anak Yusup, sa tau. Manasye nanti dapat kuasa yang besar trus de pu anana cucu juga nanti jadi bangsa yang besar. Tapi de pu ade Efraim nanti pu kuasa lebi besar trus de pu anana cucu nanti jadi bangsa-bangsa yang lebi besar lagi.” ");
INSERT INTO pmy_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Jadi, Yakub kas berkat dong waktu itu, de bilang begini, “Orang Israel dong smua nanti pake kam pu nama waktu dong kas berkat orang lain. Nanti dong bilang, ‘Sa minta Allah bikin ko jadi sama macam Efraim deng Manasye.’” Waktu bilang Efraim pu nama duluan daripada Manasye pu nama, Yakub bikin Efraim yang ade ni, jadi lebi penting dari de pu kaka Manasye. ");
INSERT INTO pmy_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Baru habis itu Yakub bilang sama Yusup, “Yusup, sa ni sbentar lagi su mo mninggal. Tapi Allah nanti sama-sama deng kam trus. Allah nanti pimpin kam kembali ke kam pu nene moyang pu tana Kanaan itu. ");
INSERT INTO pmy_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Skarang sa kasi ko satu tana lebi dari yang sa su kasi sama ko pu sodara-sodara. Sa kasi ko tana Sikem, tempat subur di gunung tu, yang sa ambil dari orang Amori dorang, pake sa pu pedang deng pana sendiri.” ");
INSERT INTO pmy_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Habis itu, Yakub de panggil de pu anana smua baru de bilang dorang begini, “Kam smua, mari dekat sa sini! Sa mo kastau kam apa yang nanti jadi ke kam di hari-hari yang mo datang ni. ");
INSERT INTO pmy_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Anana, kam kumpul smua! Pasang kam pu tlinga, mari dengar bapa mo bicara! ");
INSERT INTO pmy_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben, ko ni sa pu anak yang tua. Ko ni bukti pertama kalo sa ni dulu kuat. Ko ni anak yang paling dapa hormat. ");
INSERT INTO pmy_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Tapi ko macam air, ko tra bisa tahan diri sampe ko tidur deng sa pu istri. Ko su kas kotor sa pu tempat tidur, jadi ko su bukan yang paling dapa hormat lagi. ");
INSERT INTO pmy_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon deng Lewi, dong dua ni yang biasa satu otak untuk bikin jahat ke orang-orang. ");
INSERT INTO pmy_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Sa trakan perna ikut gabung deng dong dua pu urusan. Sa juga trakan gabung deng dong pu kumpul-kumpul tu. Habis dong dua su bunu orang kalo dong emosi. Baru cuma untuk bikin dong pu hati snang saja, dong su kas putus banteng pu urat kaki sampe de tra bisa jalan lagi. ");
INSERT INTO pmy_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Tuhan yang nanti hukum dong dua, karna dong pu mara tu kasar skali, dong kalo ganas tu jahat skali. Jadi dong pu anana cucu nanti hidup tapisa-pisa, dong trakan tinggal sama-sama satu suku. Dong nanti tasebar di Israel pu suku-suku yang lain. ");
INSERT INTO pmy_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yehuda, ko pu sodara-sodara nanti puji ko. Ko langsung injak-injak orang-orang yang brani lawan ko, jadi ko pu sodara dong nanti tunduk kasi hormat sama ko. ");
INSERT INTO pmy_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yehuda tu macam anak singa, yang habis bunu de pu musu, baru de kembali ke de pu ruma, kas lurus-lurus badan baru tidur. Trada yang brani ganggu dia. ");
INSERT INTO pmy_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Kuasa untuk pimpin bangsa-bangsa trakan perna lepas dari Yehuda. De pu tanda kuasa tu trakan perna hilang dari dia. Sampe nanti orang yang pu hak untuk pimpin bangsa-bangsa tu, de datang. Itu baru, bangsa-bangsa nanti tunduk kas tunjuk dong pu hormat sama orang itu. ");
INSERT INTO pmy_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Yehuda de nanti pu anggur yang banyak skali. Kalo mo ikat de pu kledai betina di tanaman anggur yang paling bagus juga trapapa. Kalo mo cuci pakean pake anggur juga bisa, air anggur asli yang blum campur apapa ni. ");
INSERT INTO pmy_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","De pu mata nanti mera-mera gara-gara minum anggur, de pu gigi juga puti gara-gara minum susu. ");
INSERT INTO pmy_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zebulon de nanti tinggal di pinggir laut, de pu tempat tu kapal-kapal biasa singga disitu. De pu batas tana tu baku sebla deng tana Sidon. ");
INSERT INTO pmy_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isakar tu macam kledai yang kuat. Kledai yang baring-baring deng sak-sak penu yang de masi pikul di sebla-sebla dia. ");
INSERT INTO pmy_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Kalo de liat tempat yang enak untuk istirahat, trus de pu tana juga bagus skali, baru de nanti mo kas tunduk de pu badan. De trima saja biar de dapa paksa kerja deng tra dapa bayar. ");
INSERT INTO pmy_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan de nanti pimpin de pu suku sendiri. Macam Israel pu suku-suku lain yang pimpin dong pu suku sendiri, de juga nanti begitu. ");
INSERT INTO pmy_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan de nanti macam ular yang di jalan-jalan. Ular bisa di pinggir-pinggir jalan potong, yang patok kuda pu tumit, sampe orang yang naik kuda tu talempar ke blakang.” ");
INSERT INTO pmy_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Baru Yakub de sembayang, de bilang begini, “TUHAN! TUHAN pu waktu untuk kas slamat orang-orang tu, itu yang sa paling tunggu skali.” ");
INSERT INTO pmy_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Trus Yakub lanjut bicara ke de pu anana lagi, “Gad, nanti de dapa srang dari rombongan orang jahat. Tapi, de balik srang orang-orang itu lagi. ");
INSERT INTO pmy_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Asyer, de pu tana nanti kas kluar hasil makanan yang enak-enak. De pu makanan tu, makanan yang raja dong biasa makan. ");
INSERT INTO pmy_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naftali, de sperti rusa hutan betina yang de lari bebas, de pu anana tu nanti bagus-bagus skali. ");
INSERT INTO pmy_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yusup tu macam tanaman anggur yang de pu bua banyak skali. Tanaman anggur yang pas dekat mata air, yang de pu ranting-ranting tumbu sampe lewat de pu pagar-pagar. ");
INSERT INTO pmy_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Gara-gara tra suka skali sama dia, orang dong pana dia. Dong srang dia, gara-gara tra snang de skali. ");
INSERT INTO pmy_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Tapi de pu tangan tetap kuat, pana yang de pegang juga tra goyang-goyang. Itu karna de dapat kuat dari sa pu Allah Yang Paling Kuat Skali. Trus yang jaga de tu, sa pu Allah yang kuat macam gunung batu. ");
INSERT INTO pmy_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Sa pu Allah, De pasti tolong ko. Itu karna, De tu Allah Yang Pu Kuasa Paling Besar. De nanti kasi ko berkat yang banyak, macam hujan dari langit deng air dari tana. Tamba lagi berkat dari anana deng binatang-binatang. ");
INSERT INTO pmy_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Berkat-berkat yang ko pu bapa trima dari orang-orang tua dulu tu, itu lebi besar dari berkat yang datang dari gunung-gunung yang tra perna hilang itu. Sa minta berkat ni turun juga ke Yusup pu kepala. Ke atas orang yang paling spesial daripada de pu sodara-sodara lain, ke de pu testa. ");
INSERT INTO pmy_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benyamin, de macam anjing hutan yang paling jahat skali. Pagi-pagi de bunu de pu musu, pas sampe malam de bagi-bagi de pu musu dong pu barang-barang.” ");
INSERT INTO pmy_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Itu suda, Israel pu 12 suku smua, trus kata-kata ini yang dong pu bapa de bilang dorang untuk kas berkat dorang seblum de mninggal. Berkat yang Yakub bilang dong tu memang pas deng dong masing-masing suda. ");
INSERT INTO pmy_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Habis itu, Yakub pesan sama de pu anana, “Sbentar lagi sa su mo tutup mata gabung deng sa pu orang-orang tua dorang. Kam kubur sa di dekat sa pu bapa deng tete dorang, dalam goa yang dulu orang Het nama Efron tu, de punya. ");
INSERT INTO pmy_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Goa ini yang ada di kebun di Makpela, di bagian timur daera Mamre di tana Kanaan, tempat yang Abraham su bli dari orang Het yang nama Efron tu, untuk jadi tong pu kuburan nanti. ");
INSERT INTO pmy_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Disitu tete Abraham, nene Sara, deng bapa Isak sama mama Ribka dong dapa kubur. Disitu juga sa kubur sa pu istri Lea. ");
INSERT INTO pmy_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Tana deng goa tu, sa pu tete Abraham su bli dari orang Het, jadi kam kubur sa disitu nanti.” ");
INSERT INTO pmy_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Waktu Yakub slesai kastau itu ke de pu anana, de kembali tidur. Dari situ, Yakub de langsung mninggal, de gabung deng de pu orang-orang tua dorang. ");
INSERT INTO pmy_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Dari situ Yusup langsung tunduk polo de pu bapa pu kepala, de mnangis baru cium de pu bapa. ");
INSERT INTO pmy_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Habis itu, Yusup suru orang-orang yang biasa bikin ramuan-ramuan untuk bikin mayat tahan lama tu, urus de pu bapa pu mayat. Jadi orang-orang itu dong bikin ramuan-ramuan baru kasi ke Yakub pu mayat. ");
INSERT INTO pmy_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Dong pu cara bikin mayat tahan lama tu, pake waktu sampe 40 hari. Orang-orang Mesir dong duka 70 hari untuk Yakub. ");
INSERT INTO pmy_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Habis dong pu waktu duka su lewat, Yusup bilang sama orang-orang di raja Mesir pu istana, “Kalo kam snang deng saya, nanti tolong kastau pesan ni sama raja Mesir, ");
INSERT INTO pmy_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Waktu sa pu bapa su mo mninggal, de suru sa sumpa ke dia kalo nanti sa kubur de di kuburan yang de su siap di tana Kanaan. Itu jadi, sa mo minta ijin untuk pi kubur sa pu bapa. Habis itu nanti sa kembali.’” ");
INSERT INTO pmy_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Habis dong bawa pesan itu, raja Mesir de jawab, “Pigi suda ke Kanaan! Pi kubur ko pu bapa! Bikin yang ko su sumpa sama ko pu bapa itu.” ");
INSERT INTO pmy_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Jadi waktu Yusup de pigi kubur de pu bapa tu, raja pu orang penting smua, tua-tua di istana deng tua-tua di tana Mesir, dong smua pigi sama-sama deng Yusup. ");
INSERT INTO pmy_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Yusup pu kluarga, de pu sodara-sodara, deng de bapa pu sodara-sodara yang lain juga ikut. Tapi anana kecil deng binatang piara macam kambing domba deng sapi-sapi tu tetap tinggal di daera Gosyen. ");
INSERT INTO pmy_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Orang-orang yang pake kreta kuda deng pasukan-pasukan yang pake kuda juga ikut. Itu bikin sampe dong pu rombongan yang antar tu, panjang skali. ");
INSERT INTO pmy_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Pas dong sampe di tempat yang nama Goren-Haatad, yang ada di kali Yordan pu bagian timur, dong smua bongkar mnangis gara-gara dong sedi skali. Yusup bikin acara duka untuk de pu bapa lagi disitu tu sampe tuju hari. ");
INSERT INTO pmy_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Waktu pas orang-orang Kanaan yang tinggal disitu dengar orang dong mnangis kuat-kuat di Goren-Haatad tu, orang Kanaan dong bilang begini, “Ini memang orang Mesir pu acara duka paling sedi suda.” Jadi dari situ suda, tempat tu dong kas nama Abel-Mizraim. De pu tempat tu pas di sebla kali Yordan. ");
INSERT INTO pmy_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Jadi memang, apa yang Yakub de suru de pu anana bikin, dong bikin itu. ");
INSERT INTO pmy_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Yakub pu anana dong bawa de pu mayat ke Kanaan. Dong kubur de di kuburan dalam goa di kebun Makpela. Tempat itu dulu Abraham de bli dari orang Het yang nama Efron, untuk bikin jadi dong pu kuburan. De pu tempat ada di sebla timur daera Mamre. ");
INSERT INTO pmy_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Habis kubur de pu bapa, Yusup sama de pu sodara dorang deng rombongan smua yang ikut pigi kubur tu, dong kembali ke Mesir. ");
INSERT INTO pmy_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Habis Yusup pu sodara-sodara liat kalo dong pu bapa su mninggal, dong mulai baku bilang, “We, bagemana kalo Yusup de masi mara deng kitong? Bagemana kalo de balik bikin tong macam dulu tong bikin jahat de begitu?” ");
INSERT INTO pmy_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Jadi dong kirim pesan begini ke Yusup, “Waktu ko pu bapa su mo mninggal, ");
INSERT INTO pmy_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","de suru kitong bilang begini sama ko, ‘Yusup, kas ampun ko pu sodara dorang suda, yang dulu perna bikin sala besar sama ko.’ Itu jadi, tong mo minta ko untuk kas ampun kitong pu sala paling besar yang dulu tong bikin sama ko. Tong ni semba Allah yang sama, Allah yang tong pu bapa semba.” Waktu dengar pesan tu, Yusup de langsung mnangis. ");
INSERT INTO pmy_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Waktu itu Yusup pu sodara dong datang trus tunduk kasi hormat depan Yusup baru bilang, “Tong ini ko pu budak.” ");
INSERT INTO pmy_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Tapi Yusup bilang sama dorang, “Sodara eee, kam takut untuk? Sa ni Allah ka? ");
INSERT INTO pmy_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Memang dulu kam bikin rencana jahat ke saya, tapi Allah bikin kam pu rencana tu jadi baik. Allah pake itu untuk kas slamat orang banyak pu hidup skarang ni. ");
INSERT INTO pmy_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Jadi sodara, kam jang takut! Sa nanti tanggung kam deng kam pu anana pu hidup.” Waktu bilang begitu, Yusup bikin de pu sodara dong langsung tenang. De bikin dong pu hati langsung tra rasa takut lagi. ");
INSERT INTO pmy_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yusup deng de pu kluarga smua dong tetap tinggal di Mesir. Yusup de masi hidup sampe de pu umur 110 taun. ");
INSERT INTO pmy_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Yusup masi hidup sampe de pu cucu pu anana lahir. Jadi Yusup masi liat Efraim pu cucu-cucu. Trus Manasye pu anak Makir pu anana juga tu, Yusup bikin dong macam de pu anana sendiri begitu. ");
INSERT INTO pmy_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Begini, Yusup bilang sama de pu sodara-sodara, “Tra lama lagi ni sa su mo mninggal. Tapi Allah pasti datang liat kam nanti, trus pimpin kam kluar dari tana ini ke tana yang Allah De su janji deng sumpa sama Abraham, Isak, deng Yakub.” ");
INSERT INTO pmy_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Habis itu Yusup suru Yakub pu anana cucu dong sumpa juga. De bilang, “Allah pasti datang liat kam nanti. Waktu itu, kam harus bawa sa pu tulang-tulang kluar dari tana ini sama-sama deng kam juga.” ");
INSERT INTO pmy_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Jadi Yusup de mninggal di Mesir, waktu de pu umur su masuk 110 taun. Orang-orang Mesir kasi ramuan-ramuan untuk bikin de pu mayat bisa tahan lama, trus dong taru de pu mayat dalam peti di Mesir.");
INSERT INTO pmy_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2","Jaman dulu, hakim-hakim yang pimpin di Israel, begini ada klaparan yang para skali. Ada orang satu de pu nama Elimelek, de pu maitua Naomi, de pu anak laki-laki dua Mahlon deng Kilyon. Dong orang Efrata dari Betlehem di daera Yehuda. Karna dong susa dapat makanan disitu jadi dong pigi ke daera suku Moab, dong tinggal disana untuk brapa taun saja. ");
INSERT INTO pmy_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Begini Naomi pu paitua mati jadi de tinggal deng de pu anana dua saja. ");
INSERT INTO pmy_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Trus Mahlon deng Kilyon kawin deng prempuan Moab. Satu pu nama Rut, yang satu lagi pu nama Orpa. Dong tinggal disitu sampe spulu taun. ");
INSERT INTO pmy_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Trus de pu anak laki-laki dua juga mati, jadi Naomi tinggal sendiri trada paitua deng de pu anana dua. ");
INSERT INTO pmy_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Waktu Naomi masi tinggal di Moab, begini de dengar kalo TUHAN su tolong de pu orang-orang sampe dong dapat hasil kebun yang baik. Jadi de siap-siap mo pulang ke de pu kampung deng mantu dua. ");
INSERT INTO pmy_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Jadi suda Naomi dong pigi dari situ. Waktu dong masi di tenga jalan mo pulang ke daera Yehuda di Israel, ");
INSERT INTO pmy_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Naomi bilang sama Rut deng Orpa tu begini, “Kam dua pulang suda ke kam pu orang tua. Smoga TUHAN kas tunjuk De pu setia buat kam, sperti yang kam su buat untuk sa deng dong yang su mati. ");
INSERT INTO pmy_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Smoga TUHAN tolong kam bisa kawin lagi supaya kam dua bisa hidup tenang di kam pu paitua pu ruma.” Habis itu de peluk trus cium dong dua, tapi Rut deng Orpa dong pica mnangis kras-kras. ");
INSERT INTO pmy_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Dong dua bilang, “Tong tra mau kembali ke tong pu orang tua, tong mo ikut mama pulang ke mama pu orang.” ");
INSERT INTO pmy_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Tapi Naomi bilang, “Anak kam kembali suda, kam knapa mo ikut? Kam tau kalo sa su tra bisa pu anak lagi, yang mo jadi kam pu paitua. ");
INSERT INTO pmy_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Anak, kam pulang suda, karna sa su tua tra mungkin kawin lagi. Kalo mungkin malam ini sa bisa kawin trus lahir anak laki-laki, ");
INSERT INTO pmy_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","kam dua mo tunggu sampe dong besar ka? Masa hanya begitu saja kam dua tra kawin deng orang lain. Jang begitu anak, sa pu hidup tu susa karna TUHAN su kasi sengsara sa pu hidup, sa sedi kalo kam dua pu hidup juga susa.” ");
INSERT INTO pmy_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Dengar begitu Rut deng Orpa mnangis lagi kras-kras. Habis itu Orpa cium de pu mamamantu baru de pulang kembali, tapi Rut masi disitu deng de pu mamamantu. ");
INSERT INTO pmy_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Naomi bilang, “Rut, dengar! Ko pu ade su mo pulang ke de pu orang-orang deng de pu roh-roh nene moyang. Ko pigi suda, ikut de kembali ke ko pu kampung.” ");
INSERT INTO pmy_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Tapi Rut bilang, “Mama jang bilang-bilang sa kas tinggal mama. Sa mo ikut mama kemana saja mama mo pigi, disitu juga sa mo tinggal. Mama pu orang tu sa pu orang, Allah yang mama percaya itu yang sa percaya. ");
INSERT INTO pmy_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Dimana mama mati deng kubur disitu juga sa mau. Biar sa dapat hukuman yang kras dari TUHAN kalo kas tinggal mama, yang bisa kas pisa sa deng mama cuma kalo ada satu dari tong dua mati.” ");
INSERT INTO pmy_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Naomi liat Rut de su nekat skali mo ikut, jadi de tra bisa bicara lagi. ");
INSERT INTO pmy_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Habis itu dong dua jalan trus ke Betlehem. Trus dong sampe begini, banyak orang bicara-bicara dong dua trus mace-mace dong liat Naomi su lain jadi dong heran trus bilang, “Betul itu Naomi ka?” ");
INSERT INTO pmy_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Trus Naomi de bilang, “Jang panggil sa Naomi (yang pu arti ʻsnangʼ), panggil saja sa ʻMaraʼ yang pu arti ʻpahitʼ karna Tuhan Paling Kuasa bikin sa hidup susa. ");
INSERT INTO pmy_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Waktu sa pigi dari sini lengkap sama sa pu paitua deng anak dua, tapi TUHAN bawa sa pulang kembali trada apapa! Jadi jang panggil sa Naomi lagi! Karna Tuhan Paling Kuasa bikin sa hidup sengsara skali.” ");
INSERT INTO pmy_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Begitu suda Naomi de pulang dari daera suku Moab deng de pu mantu Rut prempuan Moab itu. Dong tiba di Betlehem pas musim panen makanan pokok (biji jelai) baru mulai. ");
INSERT INTO pmy_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Naomi pu paitua Elimelek yang su mati de pu satu sodara. De pu nama Boas, de tu orang penting di Betlehem. ");
INSERT INTO pmy_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Satu hari begini Rut prempuan Moab tu de bilang de pu mamamantu, “Mama biar suda sa ke kebun disana tempat orang-orang dong panen, kalo dong baik kasi sa ambil sisa-sisa jelai yang dong kas tinggal.” Trus mace bilang, “Iyo, anak pigi suda.” ");
INSERT INTO pmy_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Jadi Rut jalan kluar dari kampung pigi ke kebun satu, de kumpul sisa-sisa jelai yang dong kas tinggal dari blakang orang-orang yang masi panen. Pas skali itu Boas pu kebun, de masi satu marga deng Rut pu bapamantu. ");
INSERT INTO pmy_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Tra lama begini Boas de datang dari Betlehem ke de pu kebun, trus kasi suara sama orang yang kerja di de pu kebun. De bilang, “Sa minta TUHAN ada sama-sama deng kam smua!” Trus dong balas, “TUHAN berkati bapa.” ");
INSERT INTO pmy_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Trus Boas de tanya sama mandor, “Prempuan itu sapa?” ");
INSERT INTO pmy_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Mandor bilang, “O... de tu prempuan Moab, de tu yang ikut Naomi pulang kesinidari daera Moab. ");
INSERT INTO pmy_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Tadi de minta sama sa mo kumpul sisa-sisa jelai dari blakang orang yang ada potong jelai. Dari pagi de kumpul trus, de cuma istirahat sdikit saja di pondok situ.” ");
INSERT INTO pmy_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Habis tu Boas de bilang Rut, “Anak dengar, tra usa suda pigi ke kebun lain. Kumpul disini saja dekat deng prempuan-prempuan yang kerja untuk saya. ");
INSERT INTO pmy_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Liat baik-baik di kebun dimana laki-laki dong potong jelai trus ko ikut di blakang prempuan-prempuan itu supaya laki-laki tra ganggu ko. Juga laki-laki dong su isi air, kalo ko haus pigi ambil trus minum saja, sa su kastau dong.” ");
INSERT INTO pmy_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Dengar begitu Rut tunduk hormat sampe muka kena tana, baru de bilang, “Bapa, knapa bapa baik skali sama sa padahal sa ni bukan orang dari sini?” ");
INSERT INTO pmy_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Boas bilang, “Sa su dengar smua yang ko su buat, ko tetap tolong ko pu mamamantu dari ko pu paitua de mati. Ko kas tinggal ko pu orang tua deng ko pu kampung, datang kesini tinggal deng orang-orang yang ko tra knal. ");
INSERT INTO pmy_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Sa minta TUHAN balas smua hal baik yang ko su bikin. Sa minta biar ko dapat berkat banyak dari TUHAN, Allah yang orang Israel semba, karna ko su datang sama Dia untuk dapa jaga.” ");
INSERT INTO pmy_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Rut bilang, “Pace bos sa ni orang kecil tra pantas bediri di depan bapa tapi bapa su bikin sa snang deng baik hati sama saya. Sa harap bisa bikin bapa pu hati snang trus.” ");
INSERT INTO pmy_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Waktu dong mo makan siang, Boas bilang Rut, “Anak mari sini, ambil roti trus colo di kua asam baru makan.” Trus Rut duduk sebla orang kerja dong trus Boas kasi de biji gandum yang dong su bakar. Rut makan sampe kenyang trus masi ada sisa makanan. ");
INSERT INTO pmy_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Habis makan, Rut de pigi kumpul jelai lagi, Boas suru sama de pu orang kerja, “Biar de kumpul dekat ikatan yang kam su ikat, jang kam mara dia. ");
INSERT INTO pmy_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Kam kas biar satu dua batang jatu dari yang kam mo ikat itu, biar de ambil. Jang larang dia!” ");
INSERT INTO pmy_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Rut de kumpul sampe su mo glap trus de toki-toki batang jelai mo kasi lepas de pu biji-biji. De kumpul kira-kira 12 kilogram. ");
INSERT INTO pmy_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Trus de pulang ke kota bawa hasil yang de su kumpul. Sampe di ruma trus de kasi tunjuk sama de pu mamamantu jelai yang de dapat, deng kasi makanan lebi tadi. ");
INSERT INTO pmy_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Naomi tanya, “Ko kumpul jelai dimana? Hari ini ko kerja di sapa pu kebun? Sa minta TUHAN kasi berkat sama orang yang su baik sama ko.” Trus Rut crita smua sama de pu mamamantu. Rut bilang kalo, “Mama sa hari ini kerja di pace Boas pu kebun.” ");
INSERT INTO pmy_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Naomi bilang sama de pu mantu, “TUHAN berkati dia! Sunggu... TUHAN De setia sama De pu janji buat tong yang hidup deng dong yang su mati. Boas tu tong pu kluarga, de tu satu orang yang harus tolong deng tanggung kitong supaya tong pu turunan trus ada.” ");
INSERT INTO pmy_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Trus Rut bilang, “Mama, tamba juga pace Boas bilang lagi kalo sa bisa pigi trus-trus kumpul jelai di de pu kebun sama-sama deng pace de pu orang-orang kerja sampe musim panen habis.” ");
INSERT INTO pmy_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Naomi bilang, “Anak, memang lebi baik begitu. Ko kerja disitu saja deng Boas pu orang-orang kerja yang prempuan. Kalo ko pigi ke orang lain pu kebun, nanti dong bisa ganggu ko.” ");
INSERT INTO pmy_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Jadi Rut ikut prempuan dong yang kerja di Boas pu kebun sampe musim jelai deng gandum habis. De tinggal trus deng de pu mamamantu. ");
INSERT INTO pmy_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","2","Satu hari begini Naomi bilang sama de pu anak mantu Rut, “Anak dengar, mama mo bilang, ingat to kalo Boas tong pu sodara, ko kerja deng pace pu orang kerja prempuan to? Sore ini pace de mo pigi ke tempat toki jelai untuk kas lepas biji jelai dari kulit. Begini anak, mama ni musti tolong biar ko bisa kawin lagi, ko kawin biar hidup tenang deng ko pu paitua. ");
INSERT INTO pmy_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Jadi skarang ni, ko mandi, pake minyak wangi deng pakean yang baik baru ko pigi ke tempat situ. Ko pigi tunggu, jang sampe pace de tau kalo ko su disitu, tunggu sampe Boas de slesai makan. ");
INSERT INTO pmy_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Kalo pace de mo tidur, ko liat dimana de mo tidur. Trus, ko pigi ke situ, slimut yang de pake, ko buka slimut sdikit yang di de pu kaki baru tidur disitu untuk minta bantu. Nanti pace de bangun, trus de kastau ko apa yang harus ko bikin.” ");
INSERT INTO pmy_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Rut bilang sama Naomi, “Iyo, sa nanti bikin smua yang mama su bilang ini.” ");
INSERT INTO pmy_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Habis itu, Rut pigi ke tempat toki jelai. De bikin smua yang Naomi suru sama dia. ");
INSERT INTO pmy_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Boas habis makan, pace de pu hati snang, trus de pi tidur di dekat tempat biji-biji jelai dong tumpuk. Tra lama Rut diam-diam datang buka kain yang di Boas pu kaki baru de tidur situ. ");
INSERT INTO pmy_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Tenga malam, Boas kaget bangun mo balik badan, begini de kaget karna liat ada prempuan tidur dekat de pu kaki. ");
INSERT INTO pmy_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Trus Boas de tanya, “Ko ni sapa?” Rut de jawab, “Bapa sa ini Rut, orang kecil yang tra pantas bediri di depan bapa. Sa harap bapa mo tolong deng ambil sa jadi bapa pu maitua. Karna bapa tu sa paitua pu sodara dekat yang harus tolong deng tanggung supaya tong pu turunan trus ada.” ");
INSERT INTO pmy_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Boas bilang, “Anak, TUHAN berkati ko. Yang ko bikin sama ko mamamantu dulu itu kas tunjuk ko sayang dia. Skarang yang ko minta ni kas tunjuk ko setia deng de pu kluarga lebi lagi. Habis ko ni tra pi cari paitua muda yang kaya ato miskin. ");
INSERT INTO pmy_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Jadi begini anak, smua yang ko bilang nanti sa urus dulu, ko tra usa takut. Memang smua orang disini tau kalo ko prempuan yang pu klakuan paling baik. ");
INSERT INTO pmy_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Memang sa ni ko pu paitua pu sodara dekat yang musti tolong deng tanggung supaya kam pu turunan trus ada. Tapi masi ada satu pace lagi, kam pu sodara lebi dekat yang harus tolong tanggung ko pu hidup duluan. ");
INSERT INTO pmy_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Skarang ni su malam, tinggal sampe pagi. Besok sa tanya dia, kalo de mau ka tra tolong deng tanggung ko. Kalo de mau, itu baik. Kalo de tra bisa sa janji demi TUHAN yang hidup sa sendiri yang nanti tolong deng tanggung ko. Skarang ko tidur dulu sampe pagi.” ");
INSERT INTO pmy_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Habis tu Rut de tidur dekat Boas pu kaki sampe pagi. De bangun pagi-pagi skali biar trada orang yang tau. Boas bilang, “Tra bole skali orang dong tau ko ke tempat sini. ");
INSERT INTO pmy_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Bawa sini kain yang di ko pu bahu trus tahan. (Kain itu pakean luar sperti kain lebar yang biasa pake di bahu stela baju panjang.)” Rut taru kain yang di de pu bahu deng pegang. Trus Boas isi dalam kain itu 30 kilogram jelai trus de angkat taru di Rut pu kepala. Trus Boas pigi ke kota. ");
INSERT INTO pmy_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Rut sampe ruma trus Naomi tanya sama dia, “Anak bagemana deng Boas?” Trus Rut de crita smua yang suda Boas de buat. ");
INSERT INTO pmy_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Rut bilang, “Jelai yang banyak ini pace Boas yang kasi sama sa. Karna de bilang, ‘Jang pulang ke ruma mamamantu deng tra bawa apapa.’ ” ");
INSERT INTO pmy_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Naomi bilang, “Tong tunggu saja apa yang Boas de nanti bikin, de trakan stop sampe de bikin apa yang de bilang hari ini juga.” ");
INSERT INTO pmy_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Boas langsung pigi ke pintu gerbang kota trus duduk disitu. Orang dong kumpul di tempat itu untuk kas slesai masala. Boas kesitu tunggu pace yang harus tolong deng tanggung Rut pu hidup. Boas duduk begini pace itu lewat disitu. Boas de bilang, “Sodara mari duduk di sini.” Pace itu datang duduk. ");
INSERT INTO pmy_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Trus Boas panggil spulu tua-tua adat di kota situ bilang, “Pace-pace mari lagi duduk di sini.” Trus dong smua duduk. ");
INSERT INTO pmy_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Boas bilang sama pace yang harus tolong tanggung itu, “Sa mo bicara soal tong pu sodara Elimelek yang su mati tu de pu tana. De pu maitua Naomi baru pulang dari daera Moab de mo jual tana itu. ");
INSERT INTO pmy_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Sa pikir pace ko harus tau soal ini. Kalo ko mau, bli suda biar pace-pace dong disini jadi saksi. Kalo pace tra mau, ko bilang sama sa supaya sa tau. Karna pace ko musti duluan yang tolong deng tanggung. Kalo ko tra mau, baru saya.” Pace itu bilang, “Sa mo bli tana itu.” ");
INSERT INTO pmy_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Trus Boas bilang, “Kalo ko mo bli tana dari Naomi ko juga musti kawin deng Rut, Mahlon pu janda. Ko musti kawin deng dia supaya de lahir anak laki-laki, nanti anak itu yang pu hak deng jaga tana itu.” ");
INSERT INTO pmy_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Pace tu bilang, “Kalo musti begitu sa tra bisa bli tana itu. Percuma nanti sa pu anak dong tra bisa pu hak deng jaga tana itu, lebi baik ko saja yang tolong deng tanggung supaya de pu turunan trus ada.” ");
INSERT INTO pmy_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","(Dulu di Israel biasa mau bli, tukar barang ato tolong tanggung, satu orang de musti buka sendal trus kasi sama orang lain. Ini cara kalo dong dua su satu hati untuk jual ato tukar barang.) ");
INSERT INTO pmy_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Pace yang harus tolong tanggung itu bilang sama Boas, “Pace bli suda tana itu.” Trus de buka de pu sendal. ");
INSERT INTO pmy_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Trus Boas de bilang sama tua-tua adat deng smua yang disitu, “Hari ini kam jadi saksi, sa su bli smua tana deng harta Elimelek, Mahlon sama Kilyon dari Naomi. ");
INSERT INTO pmy_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Juga sa ambil Rut jadi sa pu maitua. De tu prempuan Moab, Mahlon pu janda. Supaya tana itu tetap jadi milik orang yang su mati itu. Deng begitu de pu turunan deng smua orang Betlehem tra lupa dia, trus hari ini kam smua su jadi saksi.” ");
INSERT INTO pmy_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Jadi tua-tua adat deng smua yang liat bilang, “Yo, tong su jadi saksi, tong berdoa biar TUHAN buat ko pu maitua de lahir anak banyak sperti TUHAN su buat sama Rahel deng Lea, Yakub pu maitua. Dong lahir anak banyak yang jadi nene moyang suku Israel. Smoga ko pu hidup juga dapat berkat banyak di Efrata trus banyak orang tau ko pu nama di Betlehem. ");
INSERT INTO pmy_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Tong berdoa supaya dari anak yang nanti TUHAN kasi ko deng Rut pu kluarga jadi terkenal macam Peres pu kluarga, Yehuda deng Tamar pu anak.” ");
INSERT INTO pmy_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Jadi Boas kawin deng Rut, pace de tidur deng Rut. Tuhan berkati Rut, de hamil trus lahir anak laki-laki. ");
INSERT INTO pmy_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Waktu anak itu de lahir mace-mace di Betlehem bilang sama Naomi, “Puji TUHAN! Hari ini TUHAN su kasi cucu laki-laki buat ko. TUHAN De tra kas tinggal ko sendiri tapi De kasi anak yang nanti tolong tanggung ko pu hidup. Tong minta sama TUHAN biar nanti smua orang di Israel knal anak itu. ");
INSERT INTO pmy_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Anak itu yang nanti bikin snang sama jaga mace ko pu hidup waktu ko tua nanti. Karna de anak dari ko pu mantu yang paling sayang ko, jadi pasti de buat sperti yang de mama su buat untuk ko, lebi baik ko punya Rut daripada pu tuju anak laki-laki.” ");
INSERT INTO pmy_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Trus Naomi gendong jaga anak itu baik-baik. ");
INSERT INTO pmy_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Mace-mace yang tinggal dekat situ dong bilang, “Naomi su pu cucu laki-laki.” Dong kasi nama anak itu Obed. Obed pu anak Isai, trus Isai ini pu anak Daud. ");
INSERT INTO pmy_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Begini Peres pu anak cucu: Peres de pu anak Hezron. ");
INSERT INTO pmy_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Hezron pu anak Ram. Trus turunan dari Ram sampe Boas: ");
INSERT INTO pmy_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Aminadab. Nahason. ");
INSERT INTO pmy_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Salmon. Boas. Boas pu anak Obed. ");
INSERT INTO pmy_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Obed pu anak Isai. Isai pu anak Daud.");
INSERT INTO pmy_vpl VALUES ("ET1_1","018_1_1","EST","1","1","1","Crita ini jadi waktu jaman Raja Ahasyweros, raja yang printa di krajaan Persia, yang de pu luas tu 127 propinsi, itu dari India sampe Etiopia. ");
INSERT INTO pmy_vpl VALUES ("ET1_2","018_1_2","EST","1","2","2","Pas waktu itu Raja Ahasyweros de yang pegang printa dari de pu istana yang ada dalam benteng di Kota Susan, di krajaan Persia. ");
INSERT INTO pmy_vpl VALUES ("ET1_3","018_1_3","EST","1","3","3","Waktu taun ketiga de jadi raja, de bikin pesta besar skali, untuk smua tua-tua daera deng pegawai-pegawai di propinsi itu. Trus kepala-kepala tentara dari Persia deng Media, sama smua gubernur deng tua-tua daera juga hadir di pesta ini. ");
INSERT INTO pmy_vpl VALUES ("ET1_4","018_1_4","EST","1","4","4","Pesta besar ni de bikin sampe 180 hari. Di pesta itu, raja de mo kas pamer de pu harta deng barang-barang. De mo kas liat de pu krajaan ini pu besar deng bagus. ");
INSERT INTO pmy_vpl VALUES ("ET1_5","018_1_5","EST","1","5","5","Habis pesta besar itu, raja de bikin pesta lagi untuk smua orang yang tinggal di benteng Kota Susan, mo itu orang-orang penting sampe orang-orang biasa. Raja bikin pesta itu di taman depan istana, tuju hari penu. ");
INSERT INTO pmy_vpl VALUES ("ET1_6","018_1_6","EST","1","6","6","Di taman itu ada kain-kain lenan, warna biru deng puti yang bagus skali. Dong ikat pake tali lenan puti deng ungu yang dong kas gantung di gelang-gelang perak yang dong pasang di tiang-tiang batu puti yang mahal. Trus disana juga ada bangku pendek dari emas deng perak. Bangku-bangku itu dong taru di atas lantai yang dong hias deng macam-macam jenis batu mahal, kulit mutiara deng batu warna-warni yang mahal. ");
INSERT INTO pmy_vpl VALUES ("ET1_7","018_1_7","EST","1","7","7","Raja pu pesuru-pesuru dong kas siap anggur untuk tamu, pake cawan-cawan dari emas yang pu jenis macam-macam. De pu anggur tu, anggur yang biasa raja minum yang ful-ful skali, yang pantas untuk raja. ");
INSERT INTO pmy_vpl VALUES ("ET1_8","018_1_8","EST","1","8","8","Smua orang bisa minum suka-suka dorang, trada yang larang ato paksa dorang. Karna raja su kasi printa ke de pu pesuru-pesuru di istana untuk bikin apa saja yang dong mau. ");
INSERT INTO pmy_vpl VALUES ("ET1_9","018_1_9","EST","1","9","9","Pas waktu itu, Ratu Wasti juga de bikin pesta untuk prempuan-prempuan yang ada di Raja Ahasyweros pu istana itu. ");
INSERT INTO pmy_vpl VALUES ("ET1_10","018_1_10","EST","1","10","10","Pas hari yang ketuju, waktu itu Raja Ahasyweros de su minum anggur sampe de pu hati snang skali. Jadi raja de panggil de pu tuju pegawai istana, yang pu nama Mehuman, Bizta, Harbona, Bigta, Abagta, Zetar deng Karkas, dong ini yang biasa urus raja. ");
INSERT INTO pmy_vpl VALUES ("ET1_11","018_1_11","EST","1","11","11","Raja kas printa dong untuk bawa Ratu Wasti lengkap deng de pu makota krajaan ke depan raja, untuk mo kas tunjuk de pu istri pu cantik ke tua-tua daera deng smua orang yang de undang. Karna Ratu Wasti ni, de cantik skali. ");
INSERT INTO pmy_vpl VALUES ("ET1_12","018_1_12","EST","1","12","12","Tapi waktu raja pu pegawai-pegawai istana kastau raja pu printa ke Ratu Wasti, ratu de tolak untuk datang ke depan raja. Itu bikin sampe raja de emosi skali, de su tabakar deng mara skali. ");
INSERT INTO pmy_vpl VALUES ("ET1_13","018_1_13","EST","1","13","13","Waktu dengar Ratu Wasti pu jawab, raja langsung minta naseat dari tuju orang penting yang biasa kas naseat raja di de pu krajaan. Dong ini paling tau aturan adat di jaman itu deng hukum di krajaan itu. ");
INSERT INTO pmy_vpl VALUES ("ET1_14","018_1_14","EST","1","14","14","Dong juga paling dekat deng raja, dong itu: Karsena, Setar, Admata, Tarsis, Meres, Marsena deng Memukan, dong tuju ni krajaan Persia deng Media pu tua-tua daera. Dong yang biasa sama-sama deng raja, dong tu orang paling penting di krajaan itu. ");
INSERT INTO pmy_vpl VALUES ("ET1_15","018_1_15","EST","1","15","15","Raja de bilang ke dong tuju, “Apa yang tong harus bikin ke Ratu Wasti kalo ikut tong pu aturan, karna de tra mo ikut sa pu printa yang pegawai-pegawai su bilang?” ");
INSERT INTO pmy_vpl VALUES ("ET1_16","018_1_16","EST","1","16","16","Satu dari raja pu orang penting yang nama Memukan ni, de bilang sama raja deng tua-tua daera itu, “Bapa Raja, apa yang Ratu Wasti de bikin ni, tra cuma bikin sala ke Bapa Raja saja, tapi de juga su bikin sala sama smua tua-tua daera deng smua orang di smua propinsi yang Raja Ahasyweros printa! ");
INSERT INTO pmy_vpl VALUES ("ET1_17","018_1_17","EST","1","17","17","Karna smua prempuan nanti dengar apa yang ratu su bikin trus dong tra hormat dong pu suami lagi. Trus nanti dong bilang, ‘Raja Ahasyweros de kas printa sama Ratu Wasti untuk datang ke dia, tapi ratu de tra datang.’ ");
INSERT INTO pmy_vpl VALUES ("ET1_18","018_1_18","EST","1","18","18","Skarang ini juga, Raja pu tua-tua daera di daera Persia deng Media dong pu istri-istri nanti dengar tentang ratu pu klakuan, dong juga nanti bicara tentang itu ke dong pu suami. Dong trakan tunjuk hormat ke dong pu suami lagi. Gara-gara itu, dong pu suami-suami bisa emosi skali. ");
INSERT INTO pmy_vpl VALUES ("ET1_19","018_1_19","EST","1","19","19","Jadi kalo Bapa Raja anggap ini baik, tong minta biar Bapa kas kluar surat printa satu, yang nanti bisa masuk dalam krajaan Persia deng Media pu buku hukum, supaya orang tra bisa hapus. Aturan itu pu isi begini: Ratu Wasti tra bole datang ke depan Raja Ahasyweros lagi. Trus Bapa Raja nanti kasi de pu posisi ratu tu sama prempuan lain yang lebi baik dari dia. ");
INSERT INTO pmy_vpl VALUES ("ET1_20","018_1_20","EST","1","20","20","Deng begitu, smua orang yang ada di krajaan ini bisa dengar Bapa Raja pu printa, biar Raja pu krajaan ni besar skali. Trus smua istri-istri, mo itu orang penting dong pu istri, sampe orang-orang biasa dong pu istri, dong bisa tunjuk hormat ke dong pu suami.” ");
INSERT INTO pmy_vpl VALUES ("ET1_21","018_1_21","EST","1","21","21","Raja deng tua-tua daera dong stuju deng apa yang Memukan de bilang, jadi raja de langsung kas kluar surat printa itu. ");
INSERT INTO pmy_vpl VALUES ("ET1_22","018_1_22","EST","1","22","22","Raja de suru dong kirim surat printa itu ke smua propinsi di krajaan itu, pake bahasa deng tulisan di masing-masing daera itu. Surat printa itu dong tulis begini: “Smua laki-laki harus jadi kepala di de pu kluarga deng bicara ikut bahasa dari de pu bangsa.” ");
INSERT INTO pmy_vpl VALUES ("ET2_1","018_2_1","EST","2","1","1","Habis smua yang su jadi itu, begitu Raja Ahasyweros de su tra mara lagi, raja de ingat Ratu Wasti deng apa yang de su bikin juga deng de pu printa yang de kasi untuk hukum ratu. ");
INSERT INTO pmy_vpl VALUES ("ET2_2","018_2_2","EST","2","2","2","Jadi raja de pu pesuru-pesuru ni dong bilang, “Bagemana kalo Bapa Raja suru orang-orang untuk cari nona-nona cantik untuk Bapa Raja. ");
INSERT INTO pmy_vpl VALUES ("ET2_3","018_2_3","EST","2","3","3","Trus lebi baik Bapa Raja kas tugas ke orang-orang penting di smua propinsi yang Raja printa, supaya dong cari prempuan cantik yang masi nona-nona. Trus bawa dong tinggal di tempat kusus untuk prempuan di istana yang ada dalam benteng di Kota Susan, supaya nanti Hegai yang urus dorang. De ni Raja pu pegawai kusus yang urus prempuan dorang, trus de rawat dong kasi wangi-wangi biar bikin dong cantik-cantik. ");
INSERT INTO pmy_vpl VALUES ("ET2_4","018_2_4","EST","2","4","4","Trus prempuan yang Raja liat de bagus tu, prempuan itu de yang nanti jadi ratu ganti Wasti.” Apa yang dong bilang itu raja de snang, trus de bikin begitu. ");
INSERT INTO pmy_vpl VALUES ("ET2_5","018_2_5","EST","2","5","5","Pas waktu itu dalam benteng di Kota Susan ada orang Yahudi satu de pu nama tu Mordekhai, de ni Bapa Yair pu anak, Simei pu cucu, Kish pu cici, orang dari suku Benyamin. ");
INSERT INTO pmy_vpl VALUES ("ET2_6","018_2_6","EST","2","6","6","De satu orang dari dong yang dapa buang dari Yerusalem, sama-sama deng Yekhonya, Raja Yehuda. Dong dapa buang dari Raja Nebukadnezar, raja Babel. ");
INSERT INTO pmy_vpl VALUES ("ET2_7","018_2_7","EST","2","7","7","Mordekhai de tu yang biasa jaga Ester, karna Ester de su trada bapa deng mama lagi. Ester de pu nama lain tu Hadasa, Mordekhai pu om pu anak. Ester pu badan bagus trus de cantik. Waktu de pu bapa deng mama mati, Mordekhai bawa Ester jadi de pu anak. ");
INSERT INTO pmy_vpl VALUES ("ET2_8","018_2_8","EST","2","8","8","Habis raja pu printa deng de pu aturan-aturan su tasebar di krajaan, dong bawa banyak prempuan dalam benteng di Kota Susan. Hegai yang jaga dorang, trus Ester de juga dapa bawa masuk dalam raja pu istana, untuk dapa jaga dari Hegai, de ini yang biasa urus prempuan dorang. ");
INSERT INTO pmy_vpl VALUES ("ET2_9","018_2_9","EST","2","9","9","Hegai liat kalo Ester ni de baik skali, trus Hegai paling sayang deng dia. Itu jadi Hegai langsung kasi wangi-wangi deng kasi de makanan yang kusus. De kasi tuju nona yang dong pili dari raja pu istana untuk sama-sama deng dia. Trus de kas pinda Ester deng nona-nona itu ke tempat yang paling bagus di dalam tempat kusus untuk prempuan. ");
INSERT INTO pmy_vpl VALUES ("ET2_10","018_2_10","EST","2","10","10","Mordekhai de larang Ester untuk jang kastau sapa-sapa kalo de itu orang Yahudi. ");
INSERT INTO pmy_vpl VALUES ("ET2_11","018_2_11","EST","2","11","11","Stiap hari Mordekhai de jalan-jalan di halaman depan tempat kusus prempuan, untuk mo cari tau kalo Ester baik-baik ka trada, trus apa yang jadi nanti sama dia. ");
INSERT INTO pmy_vpl VALUES ("ET2_12","018_2_12","EST","2","12","12","Prempuan satu-satu dapa giliran untuk masuk ketemu Raja Ahasyweros. Tapi seblum prempuan satu de masuk, de harus dapa rawat ikut aturan untuk smua prempuan slama 12 bulan. Karna begini suda, de pu waktu untuk pake wangi-wangi: De harus pakai minyak mur enam bulan, trus enam bulan lagi pake minyak wangi-wangi lain. ");
INSERT INTO pmy_vpl VALUES ("ET2_13","018_2_13","EST","2","13","13","Trus prempuan itu masuk ketemu raja. Smua yang de minta dari tempat kusus prempuan, dong kasi untuk de pake trus masuk ke dalam raja pu istana. ");
INSERT INTO pmy_vpl VALUES ("ET2_14","018_2_14","EST","2","14","14","Pas waktu malam de masuk, baru pagi de kluar, trus de pigi masuk ke dalam tempat kusus prempuan yang kedua. De tra bole masuk lagi ketemu raja, kecuali kalo raja de pu hati snang deng dia, trus nanti raja panggil pake de pu nama. Yang jaga bagian lain tu Saasgas, raja pu pegawai, de biasa jaga raja pu maitua-maitua. ");
INSERT INTO pmy_vpl VALUES ("ET2_15","018_2_15","EST","2","15","15","Waktu Ester pu giliran untuk masuk ketemu deng raja, de tra minta apapa, de cuma mau apa yang de dapa kastau dari Hegai, raja pu pegawai kusus yang jaga prempuan dorang. Ester ni, Bapa Abihail pu anak yang Mordekhai su angkat jadi de pu anak, trus Abihail ni Mordekhai pu om. Smua orang yang liat Ester ni dong snang deng dia. ");
INSERT INTO pmy_vpl VALUES ("ET2_16","018_2_16","EST","2","16","16","Trus dong bawa Ester masuk ketemu Raja Ahasyweros dalam de pu istana, pas bulan kespulu, pas waktu bulan Tebet, taun ketuju raja de printa. ");
INSERT INTO pmy_vpl VALUES ("ET2_17","018_2_17","EST","2","17","17","Raja de snang deng Ester lebi dari prempuan-prempuan lain, jadi de kas tunjuk de pu sayang sama Ester lebi dari nona-nona lain, bikin sampe raja de kas pake makota untuk ratu ke Ester pu kepala trus pili Ester jadi ratu ganti Wasti. ");
INSERT INTO pmy_vpl VALUES ("ET2_18","018_2_18","EST","2","18","18","Habis itu raja de bikin pesta besar untuk hormat Ester, de undang smua tua-tua daera deng pegawai. Raja de kas libur smua propinsi dari bayar pajak, trus de juga bagi-bagi hadia yang bagus-bagus untuk de pu rakyat. ");
INSERT INTO pmy_vpl VALUES ("ET2_19","018_2_19","EST","2","19","19","Waktu prempuan yang masi nona dong dapa kumpul yang kedua kali begini, Mordekhai de duduk di dekat raja pu istana pu pintu gerbang. ");
INSERT INTO pmy_vpl VALUES ("ET2_20","018_2_20","EST","2","20","20","Ester de blum kastau kalo de itu orang Yahudi, sperti yang Mordekhai bilang ke dia. Karna Ester tetap bikin yang Mordekhai bilang, sperti waktu de masi jaga Ester. ");
INSERT INTO pmy_vpl VALUES ("ET2_21","018_2_21","EST","2","21","21","Pas waktu Mordekhai de duduk di depan istana pu pintu gerbang, Bigtan deng Teresh ada bikin rencana mo bunu Raja Ahasyweros karna dong dua rasa sakit hati deng raja. Dong dua ni raja pu pegawai-pegawai yang biasa jaga istana pu pintu. ");
INSERT INTO pmy_vpl VALUES ("ET2_22","018_2_22","EST","2","22","22","Waktu Mordekhai de su tau dong pu rencana itu, de kastau sama Ratu Ester, trus Ester de kastau ke raja pake Mordekhai pu nama. ");
INSERT INTO pmy_vpl VALUES ("ET2_23","018_2_23","EST","2","23","23","Dong cek-cek masala itu begini, memang betul, trus dua orang itu dong gantung mati di tiang. Trus masala itu dong tulis di buku yang crita tentang krajaan pu sejara, ikut raja pu printa. ");
INSERT INTO pmy_vpl VALUES ("ET3_1","018_3_1","EST","3","1","1","Habis smua itu jadi, Raja Ahasyweros de angkat Haman untuk jadi orang paling penting trus tamba de pu jabatan lebi tinggi dari smua orang penting yang ada di krajaan. Haman tu Bapa Hamedata pu anak laki-laki, dong orang dari Agag. ");
INSERT INTO pmy_vpl VALUES ("ET3_2","018_3_2","EST","3","2","2","Trus raja pu pegawai smua yang di istana pu pintu gerbang dong tikam lutut deng tunduk ke Haman, karna itu raja pu printa tentang dia. Tapi Mordekhai de tra tunduk depan dia untuk kas tunjuk hormat. ");
INSERT INTO pmy_vpl VALUES ("ET3_3","018_3_3","EST","3","3","3","Jadi raja pu pegawai-pegawai yang di istana pu pintu gerbang tu bilang sama Mordekhai, “Knapa ko langgar raja pu printa?” ");
INSERT INTO pmy_vpl VALUES ("ET3_4","018_3_4","EST","3","4","4","Dong tegur de deng hari-hari, tapi de tetap tra mo dengar juga. Karna itu dong kastau sama Haman untuk liat Mordekhai pu klakuan itu bisa begitu trus ka, karna de su crita sama dong kalo de ni orang Yahudi. ");
INSERT INTO pmy_vpl VALUES ("ET3_5","018_3_5","EST","3","5","5","Waktu Haman de liat kalo Mordekhai de tra mo tunduk deng kas hormat sama dia, Haman de emosi skali. ");
INSERT INTO pmy_vpl VALUES ("ET3_6","018_3_6","EST","3","6","6","Tapi de rasa rugi skali untuk mo bunu Mordekhai saja, karna orang su kastau Mordekhai pu bangsa. Jadi Haman cari cara untuk kas habis smua orang Yahudi yang satu bangsa deng Mordekhai yang tasebar di Ahasyweros pu krajaan. ");
INSERT INTO pmy_vpl VALUES ("ET3_7","018_3_7","EST","3","7","7","Haman de cari tanggal yang pas untuk mo kas habis dorang. Jadi di bulan pertama, itu bulan Nisan, waktu Raja Ahasyweros su pegang printa 12 taun, orang buang undi depan Haman. Undi itu biasa dong bilang Pur. Undi itu jatu pas di bulan duablas, itu bulan Adar. ");
INSERT INTO pmy_vpl VALUES ("ET3_8","018_3_8","EST","3","8","8","Jadi Haman de pigi kastau Raja Ahasyweros, “Ada bangsa satu yang hidup tapisa deng tasebar di antara bangsa-bangsa dari smua propinsi yang Raja printa. Dong pu aturan-aturan tu lain dari smua bangsa, trus dong tra ikut Raja pu aturan. Karna itu, tra pantas Raja kas biar dong bebas bikin apa saja. ");
INSERT INTO pmy_vpl VALUES ("ET3_9","018_3_9","EST","3","9","9","Kalo Bapa Raja anggap ini baik, sa minta biar Bapa kas kluar surat printa untuk bunu dorang. Nanti sa timbang koin perak 10.000 kantong trus kasi ke orang yang urus Raja pu harta tu pu tangan, supaya dong kas masuk perak itu dalam Raja pu tempat simpan uang.” ");
INSERT INTO pmy_vpl VALUES ("ET3_10","018_3_10","EST","3","10","10","Begitu jadi raja de cabut cincin yang ada tanda cap dari de pu jari trus kasi sama Haman, orang Yahudi pu musu besar. Haman ni de orang Agag, Bapa Hamedata pu anak. ");
INSERT INTO pmy_vpl VALUES ("ET3_11","018_3_11","EST","3","11","11","Habis itu raja bilang ke Haman, “Perak itu tersera ko saja, juga bangsa itu, ko bisa bikin sperti yang ko liat baik.” ");
INSERT INTO pmy_vpl VALUES ("ET3_12","018_3_12","EST","3","12","12","Karna itu, tanggal 13 di bulan pertama Haman de kumpul raja pu sekretaris dorang, trus dong tulis smua yang Haman printa. Dong tulis surat untuk raja pu wakil-wakil, gubernur-gubernur dari tiap propinsi, deng tua-tua daera. Dong tulis itu ikut dong pu bahasa deng cara dong tulis. Surat itu dong tulis pake Raja Ahasyweros pu nama trus cap pake raja pu cincin yang ada tanda cap. ");
INSERT INTO pmy_vpl VALUES ("ET3_13","018_3_13","EST","3","13","13","Trus surat-surat itu dong kirim lewat tukang lari cepat ke tiap propinsi yang raja printa. Dalam surat itu ada pesan kalo smua orang Yahudi yang tua ka, muda ka, prempuan ka, anana ka, harus dapa kas sapu bersi, dapa bunu deng dapa kas hancur betul-betul, trus rampas dong pu harta. Smua ini harus jadi di tanggal 13 bulan yang keduablas, itu bulan Adar. ");
INSERT INTO pmy_vpl VALUES ("ET3_14","018_3_14","EST","3","14","14","Surat pu isi harus jadi aturan hukum tiap-tiap daera. Jadi surat-surat itu dong kas banyak untuk kastau ke smua orang supaya dong siap untuk hari itu. ");
INSERT INTO pmy_vpl VALUES ("ET3_15","018_3_15","EST","3","15","15","Jadi raja pu tukang lari tu, dong pigi cepat-cepat dong bawa ke smua tempat, atas raja pu printa, baru aturan hukum itu dong kas kluar di benteng Kota Susan juga. Aturan itu kluar begini, raja deng Haman dong duduk minum-minum, tapi di Kota Susan ni orang ribut skali. ");
INSERT INTO pmy_vpl VALUES ("ET4_1","018_4_1","EST","4","1","1","Pas Mordekhai de su tau smua itu, de kas robek de pu pakean trus de pake pakean duka trus de taru abu di de pu kepala. Habis itu de jalan-jalan dalam kota, de mnangis kras deng sedi skali. ");
INSERT INTO pmy_vpl VALUES ("ET4_2","018_4_2","EST","4","2","2","Begini de sampe di depan raja pu istana pu pintu gerbang, baru de brenti disitu karna trada yang bisa masuk kalo pake pakean duka. ");
INSERT INTO pmy_vpl VALUES ("ET4_3","018_4_3","EST","4","3","3","Di smua propinsi yang raja de pu printa su sampe tu, pasti disitu tu orang Yahudi dong rasa sedi skali. Dong tra makan baru dong mnangis kras-kras. Banyak orang yang alas kain macam pakean duka, baru dong taru abu untuk pake tidur di atas. ");
INSERT INTO pmy_vpl VALUES ("ET4_4","018_4_4","EST","4","4","4","Waktu nona-nona yang sama-sama Ester deng pegawai-pegawai datang kastau Ester tentang apa yang Mordekhai ada bikin, ratu de pu hati gelisa. Baru de suru orang bawa pakean ke Mordekhai, untuk de ganti deng de pu pakean duka itu, tapi Mordekhai de tra mau. ");
INSERT INTO pmy_vpl VALUES ("ET4_5","018_4_5","EST","4","5","5","Jadi, Ester de suru pegawai satu, de pu nama Hatah. De ini raja suru untuk bikin apa saja yang Ester mau. Ester suru de ke Mordekhai sana baru tanya knapa de bikin begitu. ");
INSERT INTO pmy_vpl VALUES ("ET4_6","018_4_6","EST","4","6","6","Jadi Hatah de kesana mnuju Mordekhai yang ada di kota pu lapangan, yang pas di depan istana pu pintu gerbang. ");
INSERT INTO pmy_vpl VALUES ("ET4_7","018_4_7","EST","4","7","7","Trus Mordekhai kastau de tentang smua yang jadi, lapis deng crita tentang brapa uang perak yang Haman de bilang mo kasi, yang de mo kas masuk ke raja pu harta supaya dong kas habis orang Yahudi smua. ");
INSERT INTO pmy_vpl VALUES ("ET4_8","018_4_8","EST","4","8","8","Mordekhai de kasi sama Hatah surat printa dari raja yang su kluar di Kota Susan, yang pu isi tu untuk mo kas hancur orang Yahudi. De suru Hatah kasi surat itu ke Ester trus kastau masala itu, juga de minta supaya Ester ketemu deng raja untuk mohon sama raja, supaya raja bisa kasian de pu bangsa. ");
INSERT INTO pmy_vpl VALUES ("ET4_9","018_4_9","EST","4","9","9","Trus Hatah de masuk kembali baru de kastau hal-hal yang Mordekhai de pesan ke Ester. ");
INSERT INTO pmy_vpl VALUES ("ET4_10","018_4_10","EST","4","10","10","Tapi Ester de suru Hatah kastau Mordekhai dia, ");
INSERT INTO pmy_vpl VALUES ("ET4_11","018_4_11","EST","4","11","11","“Raja pu pegawai smua deng smua orang dari stiap propinsi di krajaan, yang mo pigi ketemu raja di raja pu istana, padahal tra dapa panggil, nanti de dapa kas mati. Tapi de bisa slamat kalo raja tunjuk de deng raja de pu tongkat emas. Trus sa ni su 30 hari tra dapa panggil untuk ketemu raja.” ");
INSERT INTO pmy_vpl VALUES ("ET4_12","018_4_12","EST","4","12","12","Pas Ester de pu pesan tu dapa kastau ke Mordekhai, ");
INSERT INTO pmy_vpl VALUES ("ET4_13","018_4_13","EST","4","13","13","Mordekhai de suru kastau lagi sama Ester begini, “Jang ko kira ko ada dalam raja pu istana jadi ko saja yang nanti tra dapa bunu sperti orang Yahudi yang lain. ");
INSERT INTO pmy_vpl VALUES ("ET4_14","018_4_14","EST","4","14","14","Karna kalo skarang ko tutup mulut saja, nanti orang Yahudi dong pasti dapa tolong deng dapa kas slamat dari yang lain. Tapi ko deng ko pu kluarga nanti hancur. Mungkin saja, untuk waktu ini ni yang ko harus jadi ratu.” ");
INSERT INTO pmy_vpl VALUES ("ET4_15","018_4_15","EST","4","15","15","Jadi suda, Ester de suru kastau begini sama Mordekhai, ");
INSERT INTO pmy_vpl VALUES ("ET4_16","018_4_16","EST","4","16","16","“Pigi suda, baru kumpul orang Yahudi smua yang ada di Kota Susan trus jang kam makan deng minum tiga hari, biar siang ato malam. Sa deng nona-nona yang sama-sama deng saya nanti bikin sperti begitu juga. Habis itu baru sa masuk ketemu raja, padahal kalo aturan tu tra bisa begitu. Kalo sa harus mati, suda, sa mati saja.” ");
INSERT INTO pmy_vpl VALUES ("ET4_17","018_4_17","EST","4","17","17","Jadi Mordekhai de pigi baru de bikin sperti yang Ester de bilang. ");
INSERT INTO pmy_vpl VALUES ("ET5_1","018_5_1","EST","5","1","1","Pas hari ketiga, Ester de pake pakean ratu baru bediri di halaman, pas di depan raja pu istana. Raja de duduk di de pu kursi raja di dalam de pu istana, lurus deng pintu masuk. ");
INSERT INTO pmy_vpl VALUES ("ET5_2","018_5_2","EST","5","2","2","Waktu raja de liat Ratu Ester bediri di halaman, de pu hati snang deng dia. Raja tunjuk Ester deng de pu tongkat emas yang de pegang, baru Ester de jalan ke dekat raja trus de pegang raja pu tongkat bagian ujung. ");
INSERT INTO pmy_vpl VALUES ("ET5_3","018_5_3","EST","5","3","3","Raja de tanya Ester, “Ada apa deng ko, Ratu Ester, apa yang ko mau? Biar ko minta sa pu krajaan stenga juga, sa nanti kasi untuk ko.” ");
INSERT INTO pmy_vpl VALUES ("ET5_4","018_5_4","EST","5","4","4","Baru Ester de bilang, “Bapa Raja, sa su kas siap pesta kecil untuk Bapa Raja. Kalo Bapa Raja anggap ini baik, sa minta Bapa Raja deng Haman datang ke pesta itu.” ");
INSERT INTO pmy_vpl VALUES ("ET5_5","018_5_5","EST","5","5","5","Trus raja de printa, “Suru Haman de datang skarang juga. Supaya tong bisa bikin apa yang Ester minta.” Trus raja deng Haman dong ke Ester pu pesta makan-makan. ");
INSERT INTO pmy_vpl VALUES ("ET5_6","018_5_6","EST","5","6","6","Pas dong ada minum anggur begini raja de tanya Ester lagi, “Ko mau apa? Pasti nanti sa bikin, biar ko minta sa pu krajaan stenga juga, sa nanti kasi untuk ko.” ");
INSERT INTO pmy_vpl VALUES ("ET5_7","018_5_7","EST","5","7","7","Trus Ester de jawab, “Nanti di pesta satu lagi tu baru sa bilang apa yang sa mo minta dari Bapa Raja. ");
INSERT INTO pmy_vpl VALUES ("ET5_8","018_5_8","EST","5","8","8","Kalo Bapa Raja sayang saya, trus kalo Bapa Raja anggap ini baik untuk dengar deng ikut yang sa minta, sa mau Raja deng Haman datang lagi ke pesta kecil yang sa bikin besok. Nanti waktu pesta, sa kastau apa yang Raja tanya.” ");
INSERT INTO pmy_vpl VALUES ("ET5_9","018_5_9","EST","5","9","9","Hari itu juga Haman de kluar deng hati snang skali, tapi pas Haman de liat Mordekhai ada duduk di depan raja pu istana pu pintu gerbang, baru Mordekhai de tra bediri untuk hormat Haman, itu yang bikin Haman de emosi skali. ");
INSERT INTO pmy_vpl VALUES ("ET5_10","018_5_10","EST","5","10","10","Tapi de tahan saja, trus de pulang, de panggil de pu teman-teman deng de pu istri Zeresh. ");
INSERT INTO pmy_vpl VALUES ("ET5_11","018_5_11","EST","5","11","11","Baru de crita smua ke de pu istri deng de pu teman-teman kalo de pu harta banyak, de pu anak laki-laki banyak, deng smua kuasa yang raja kasi ke dia, trus tamba lagi raja kasi de posisi paling tinggi dari smua tua-tua daera deng pegawai-pegawai di raja pu istana. ");
INSERT INTO pmy_vpl VALUES ("ET5_12","018_5_12","EST","5","12","12","Trus Haman de bilang lagi, “Baru Ratu Ester de tra minta orang lain untuk datang ke de pu pesta makan-makan deng raja, tapi Ester de minta sa yang datang deng raja, sampe besok juga sa yang nanti pigi deng raja ke Ester de pu pesta. ");
INSERT INTO pmy_vpl VALUES ("ET5_13","018_5_13","EST","5","13","13","Tapi smua itu tra penting skali kalo sa masi liat Mordekhai, orang Yahudi itu de duduk di raja pu istana pu pintu gerbang.” ");
INSERT INTO pmy_vpl VALUES ("ET5_14","018_5_14","EST","5","14","14","Baru de pu istri Zeresh deng de pu teman-teman smua bilang begini, “Suru orang bikin tiang yang de pu tinggi 22 meter, trus kastau ke raja besok pagi, biar Mordekhai de dapa gantung di tiang itu. Deng begitu ko bisa snang sdikit untuk pigi ke pesta makan-makan deng raja.” Haman de pikir apa yang dong bilang itu bagus juga, jadi de langsung suru orang dong bikin tiang gantung itu. ");
INSERT INTO pmy_vpl VALUES ("ET6_1","018_6_1","EST","6","1","1","Malam itu juga raja de tra bisa tidur. Jadi de suru dong bawa buku yang crita tentang krajaan pu sejara, baru baca di depan raja. ");
INSERT INTO pmy_vpl VALUES ("ET6_2","018_6_2","EST","6","2","2","Disitu baru dong baca kalo Mordekhai de perna kastau ke raja tentang Bigtan deng Teresh, raja pu pegawai yang biasa jaga pintu, yang dulu bikin rencana mo bunu Raja Ahasyweros. ");
INSERT INTO pmy_vpl VALUES ("ET6_3","018_6_3","EST","6","3","3","Jadi raja de tanya, “Mordekhai dapat tanda hormat deng hadia apa dari yang de su bikin itu?” Langsung raja pu pesuru-pesuru jawab, “De tra dapat apapa.” ");
INSERT INTO pmy_vpl VALUES ("ET6_4","018_6_4","EST","6","4","4","Raja tanya lagi, “Sapa yang ada di halaman tu?” Itu pas Haman de baru datang di halaman, di bagian luar raja pu istana, untuk kastau raja kalo de mo gantung Mordekhai di tiang yang de su bikin. ");
INSERT INTO pmy_vpl VALUES ("ET6_5","018_6_5","EST","6","5","5","Raja pu pesuru bilang ke raja, “Itu Haman, de ada bediri di depan.” Trus raja printa, “Suru de masuk.” ");
INSERT INTO pmy_vpl VALUES ("ET6_6","018_6_6","EST","6","6","6","Pas Haman su masuk, raja tanya ke dia, “Tong harus bikin apa ke orang yang mo dapa hormat dari Raja?” Haman de pikir dalam hati, “Sapa lagi yang raja de mo kas hormat kalo bukan saya?” ");
INSERT INTO pmy_vpl VALUES ("ET6_7","018_6_7","EST","6","7","7","Karna itu Haman de jawab raja, “Kalo orang yang Raja mo hormat, ");
INSERT INTO pmy_vpl VALUES ("ET6_8","018_6_8","EST","6","8","8","dong harus ambil pakean yang Raja biasa pake, baru kuda yang biasa Raja de naik tu harus dong kas pake makota krajaan di kuda pu kepala. ");
INSERT INTO pmy_vpl VALUES ("ET6_9","018_6_9","EST","6","9","9","Trus kasi pakean deng kuda itu ke satu orang dari Raja pu orang-orang penting. Trus de kas pake pakean itu ke orang yang Raja mo kas hormat tu, baru orang penting itu bawa de pawai deng kuda itu, putar-putar di kota pu lapangan, trus de harus batariak kras-kras begini, ‘Eh, dengar! Bapa Raja bikin begini sama orang yang de hormati!’” ");
INSERT INTO pmy_vpl VALUES ("ET6_10","018_6_10","EST","6","10","10","Baru raja suru Haman, “Cepat ko pigi ambil pakean deng kuda itu, sperti yang ko su bilang tadi, baru ko bikin begitu ke Mordekhai, orang Yahudi yang ada duduk di depan raja pu istana pu pintu gerbang. Smua yang ko bilang itu, ko harus bikin, tra bole kurang apa saja dari smua yang ko su bilang tu.” ");
INSERT INTO pmy_vpl VALUES ("ET6_11","018_6_11","EST","6","11","11","Trus Haman ambil pakean deng kuda itu, de kas pake Mordekhai, baru de bawa putar-putar di kota pu lapangan tu, baru de batariak kras-kras, “Eh, dengar! Bapa Raja bikin begini sama orang yang de hormati!” ");
INSERT INTO pmy_vpl VALUES ("ET6_12","018_6_12","EST","6","12","12","Baru Mordekhai kembali ke depan raja pu istana pu pintu gerbang, tapi Haman de pulang ke ruma cepat-cepat, de tutup de pu muka deng kain karna de malu skali. ");
INSERT INTO pmy_vpl VALUES ("ET6_13","018_6_13","EST","6","13","13","Haman de crita ke de pu istri Zeresh, baru ke de pu teman baik dorang, de crita smua. Baru de pu teman-teman yang pintar, deng de pu istri Zeresh, dong bilang ke dia, “Ko su mulai kala dari Mordekhai. Karna de tu orang Yahudi, ko pasti tra bisa mlawan dia. Mala ko pasti kala nanti!” ");
INSERT INTO pmy_vpl VALUES ("ET6_14","018_6_14","EST","6","14","14","Baru pas ada bicara-bicara begini, raja pu pegawai tu dong datang langsung bawa Haman untuk pigi ikut pesta kecil yang Ester ada bikin. ");
INSERT INTO pmy_vpl VALUES ("ET7_1","018_7_1","EST","7","1","1","Jadi suda, raja deng Haman ni dong dua datang untuk makan sama-sama deng Ratu Ester. ");
INSERT INTO pmy_vpl VALUES ("ET7_2","018_7_2","EST","7","2","2","Pas pesta yang kedua, waktu dong ada minum anggur, raja de tanya Ester lagi, “Ko mo apa, Ratu Ester? Pasti nanti sa kasi. Trus yang ko mau tu apa? Biar sa pu krajaan stenga juga, sa nanti kasi untuk ko.” ");
INSERT INTO pmy_vpl VALUES ("ET7_3","018_7_3","EST","7","3","3","Trus Ratu Ester de jawab, “Kalo Bapa Raja sayang saya, trus kalo Bapa Raja anggap ini baik, tolong kas slamat sa pu nyawa, itu yang sa minta, trus kas slamat sa pu orang-orang pu nyawa juga, itu yang sa mau. ");
INSERT INTO pmy_vpl VALUES ("ET7_4","018_7_4","EST","7","4","4","Karna tong su dapa jual, sa deng sa pu orang-orang, supaya tong dapa kas sapu bersi, dapa bunu, deng dapa kas hancur betul-betul. Kalo tong hanya dapa jual jadi budak laki-laki deng budak prempuan saja, sa trakan kas sibuk Raja deng ini. Sa tra mau bikin susa Raja deng alasan macam begitu.” ");
INSERT INTO pmy_vpl VALUES ("ET7_5","018_7_5","EST","7","5","5","Langsung Raja Ahasyweros tanya ke Ratu Ester, “Sapa orang itu? De brani skali mo bikin begitu! De ada dimana skarang?” ");
INSERT INTO pmy_vpl VALUES ("ET7_6","018_7_6","EST","7","6","6","Baru Ester de jawab, “Kitong pu musu besar tu, orang jahat ini! Haman!” Haman langsung takut skali, pas depan raja deng ratu. ");
INSERT INTO pmy_vpl VALUES ("ET7_7","018_7_7","EST","7","7","7","Suda, raja de emosi skali, de bediri, kas tinggal dong pu minum-minum anggur tu, trus pigi ke istana pu taman. Tapi Haman ni de masi tinggal, de minta ke Ratu Ester untuk kas slamat de pu nyawa, karna de liat kalo raja su putuskan untuk kas claka dia. ");
INSERT INTO pmy_vpl VALUES ("ET7_8","018_7_8","EST","7","8","8","Waktu raja de kembali dari istana pu taman ke tempat dong minum anggur begini, Haman de ada kas jatu diri ke bangku panjang yang Ester ada pake duduk. Langsung raja bilang, “Orang ini masi brani skali ka, mo perkosa sa pu ratu depan saya, di sa pu ruma sendiri!” Waktu raja de bilang begitu, orang-orang langsung tutup Haman pu muka deng kain. ");
INSERT INTO pmy_vpl VALUES ("ET7_9","018_7_9","EST","7","9","9","Trus, raja pu pegawai istana satu yang nama Harbona ni de datang depan raja baru bilang, “Bapa Raja, Haman de juga kas siap tiang satu untuk mo gantung Mordekhai, orang yang kastau brita yang kas slamat Bapa Raja dulu tu. Tiang itu ada bediri dekat Haman pu ruma, de pu tinggi tu 22 meter.” Trus raja de bilang, “Pigi gantung de di tiang itu.” ");
INSERT INTO pmy_vpl VALUES ("ET7_10","018_7_10","EST","7","10","10","Jadi suda, dong gantung Haman di tiang yang de kas siap untuk Mordekhai itu. Habis itu, raja de pu emosi mulai turun. ");
INSERT INTO pmy_vpl VALUES ("ET8_1","018_8_1","EST","8","1","1","Hari itu juga, Raja Ahasyweros kasi ke Ratu Ester smua harta benda dari Haman, yang orang Yahudi pu musu besar tu. Trus Mordekhai datang ketemu raja, karna Ester su kastau tentang Mordekhai tu de pu sapa. ");
INSERT INTO pmy_vpl VALUES ("ET8_2","018_8_2","EST","8","2","2","Jadi raja de lepas cincin yang ada tanda cap dari de pu jari, yang de su ambil dari Haman tu, trus de kasi ke Mordekhai. Baru Ester kasi kuasa penu ke Mordekhai untuk pegang Haman pu harta benda smua itu. ");
INSERT INTO pmy_vpl VALUES ("ET8_3","018_8_3","EST","8","3","3","Begini, Ester de tunduk depan raja pu kaki trus de bilang lagi ke raja deng mnangis sedi skali, de mohon supaya raja bisa kas batal rencana deng tujuan jahat yang Haman, orang Agag tu, bikin sama orang Yahudi. ");
INSERT INTO pmy_vpl VALUES ("ET8_4","018_8_4","EST","8","4","4","Jadi raja kas maju de pu tongkat emas tunjuk Ester. Ester de bangun trus de bediri di depan raja, ");
INSERT INTO pmy_vpl VALUES ("ET8_5","018_8_5","EST","8","5","5","trus de bilang, “Kalo Bapa Raja anggap ini baik, trus kalo Bapa Raja sayang saya, deng Bapa Raja anggap ini benar, trus kalo Bapa Raja pu hati snang deng saya, sa mohon supaya Bapa bisa kas kluar surat printa untuk tarik kembali surat-surat yang Haman, orang Agag yang Bapa Hamedata pu anak tu, de tulis de pu rencana untuk kas sapu bersi orang Yahudi di smua propinsi yang Bapa Raja printa. ");
INSERT INTO pmy_vpl VALUES ("ET8_6","018_8_6","EST","8","6","6","Karna bagemana sa bisa tahan mo liat sa pu orang-orang yang kena claka? Bagemana sa bisa tahan liat sa pu kluarga dong dapa kas hancur begitu?” ");
INSERT INTO pmy_vpl VALUES ("ET8_7","018_8_7","EST","8","7","7","Jadi suda, Raja Ahasyweros de jawab Ratu Ester deng Mordekhai, orang Yahudi tu begini, “Haman pu harta benda sa su kasi ke Ratu Ester. Trus Haman juga dapa gantung di tiang karna de su bikin rencana jahat ke orang Yahudi dorang. ");
INSERT INTO pmy_vpl VALUES ("ET8_8","018_8_8","EST","8","8","8","Jadi kam tulis suda deng Raja pu nama apa yang kam anggap baik tentang orang Yahudi, trus kas tanda cap pake Raja pu cincin. Karna surat yang su tulis deng Raja pu nama trus su ada tanda cap pake Raja pu cincin, su tra bisa dapa tarik kembali.” ");
INSERT INTO pmy_vpl VALUES ("ET8_9","018_8_9","EST","8","9","9","Waktu itu juga, raja pu sekretaris-sekretaris dapa panggil, pas di tanggal 23, bulan ketiga, dong bilang itu bulan Siwan. Dong tulis surat tentang smua yang Mordekhai su bilang ke orang Yahudi, ke raja pu wakil-wakil, ke gubernur-gubernur deng ke tua-tua daera, yang ada di India sampe ke Etiopia. Smua ada 127 propinsi. Dong tulis ke masing-masing daera pake daera itu pu tulisan, trus ke tiap bangsa pake bangsa itu pu bahasa, dong juga kirim ke orang Yahudi pake orang Yahudi pu tulisan deng bahasa. ");
INSERT INTO pmy_vpl VALUES ("ET8_10","018_8_10","EST","8","10","10","Jadi suda, surat itu dapa tulis pake Raja Ahasyweros pu nama, trus dong kas tanda cap deng raja pu cincin. Trus dong pake tukang lari cepat yang naik kuda-kuda linca, untuk kirim surat-surat itu. Kuda-kuda linca itu dari raja pu kandang kusus. ");
INSERT INTO pmy_vpl VALUES ("ET8_11","018_8_11","EST","8","11","11","Surat de pu isi tu, raja kas ijin orang Yahudi di tiap kota untuk kumpul jadi satu trus bela dong pu nyawa. Dong dapa kas ijin untuk kas sapu bersi, bunu, trus kas hancur betul-betul smua tentara dari stiap bangsa deng daera yang mo srang dorang, sampe dong pu anana deng prempuan-prempuan. Trus dong juga dapa kas ijin untuk ambil orang-orang itu pu harta untuk jadi dong pu milik. ");
INSERT INTO pmy_vpl VALUES ("ET8_12","018_8_12","EST","8","12","12","Dong bikin begitu di smua propinsi yang Raja Ahasyweros printa di hari yang sama, tanggal 13 bulan duablas di bulan Adar. ");
INSERT INTO pmy_vpl VALUES ("ET8_13","018_8_13","EST","8","13","13","Surat itu pu isi harus jadi aturan hukum tiap-tiap daera, jadi surat-surat itu dong kas banyak untuk kastau ke smua orang supaya orang Yahudi dong siap untuk balas dong pu musu-musu di hari itu. ");
INSERT INTO pmy_vpl VALUES ("ET8_14","018_8_14","EST","8","14","14","Jadi tukang lari cepat yang ada bawa pesan ni, dong pake raja pu kuda-kuda linca ni cepat-cepat brangkat ikut raja pu printa. Trus dong kas kluar aturan itu di dalam benteng Kota Susan itu juga. ");
INSERT INTO pmy_vpl VALUES ("ET8_15","018_8_15","EST","8","15","15","Habis itu Mordekhai de juga pigi dari depan raja. De pigi pake pakean dari kain biru deng kain lenan puti macam raja-raja pu pakean begitu, de pu baju luar itu dari kain lenan halus deng kain ungu muda, trus de pake makota emas yang paling bagus skali. Langsung orang-orang di Kota Susan juga dong batariak snang deng smangat skali. ");
INSERT INTO pmy_vpl VALUES ("ET8_16","018_8_16","EST","8","16","16","Orang Yahudi dong su talepas dari beban, dong su rasa snang skali deng rasa hormat. ");
INSERT INTO pmy_vpl VALUES ("ET8_17","018_8_17","EST","8","17","17","Begitu juga di tiap daera deng kota, dimana saja raja pu printa deng aturan itu su sampe, ada snang skali di orang Yahudi dorang. Dong bikin pesta trus dong rasa snang deng hari yang baik itu. Mala banyak orang di propinsi yang raja printa ni, dong ganti dong pu bangsa jadi bangsa Yahudi karna dong takut deng orang Yahudi dorang. ");
INSERT INTO pmy_vpl VALUES ("ET9_1","018_9_1","EST","9","1","1","Di tanggal 13 bulan duablas yang dong bilang bulan Adar ni, itu waktu yang dong su kas tetap untuk bikin raja pu printa deng aturan. Orang Yahudi pu musu-musu pikir kalo di hari itu dong kas kala orang Yahudi. Begini, yang jadi tu mala orang Yahudi yang kas kala orang-orang yang benci dorang. ");
INSERT INTO pmy_vpl VALUES ("ET9_2","018_9_2","EST","9","2","2","Di smua propinsi yang Raja Ahasyweros printa ni, orang Yahudi dong kumpul sama-sama dalam dong pu kota masing-masing, untuk bunu orang-orang yang rencana mo kas claka dorang. Trada satu orang juga yang mampu lawan orang Yahudi karna smua bangsa tu dong takut skali deng orang Yahudi dorang. ");
INSERT INTO pmy_vpl VALUES ("ET9_3","018_9_3","EST","9","3","3","Trus smua tua-tua daera deng raja pu wakil-wakil deng gubernur-gubernur dari tiap propinsi trus orang-orang yang urus raja pu harta, dong dukung orang Yahudi juga, karna dong takut skali deng Mordekhai. ");
INSERT INTO pmy_vpl VALUES ("ET9_4","018_9_4","EST","9","4","4","Itu karna Mordekhai pegang kuasa besar di raja pu istana. Trus brita tentang de tu, tasebar ke smua propinsi karna Mordekhai ni, de pu kuasa tinggal tamba besar trus. ");
INSERT INTO pmy_vpl VALUES ("ET9_5","018_9_5","EST","9","5","5","Jadi suda, orang Yahudi dong kas kala dong pu musu-musu smua, dong ayun deng pedang, dong bunu deng kas sapu bersi dong pu musu. Dong bikin apa saja yang dong mau ke orang-orang yang benci dong itu. ");
INSERT INTO pmy_vpl VALUES ("ET9_6","018_9_6","EST","9","6","6","Di benteng Kota Susan saja, orang Yahudi dong bunu deng kas sapu bersi sampe 500 orang. ");
INSERT INTO pmy_vpl VALUES ("ET9_7","018_9_7","EST","9","7","7","Dong juga bunu Parsandata, Dalfon, Aspata, ");
INSERT INTO pmy_vpl VALUES ("ET9_8","018_9_8","EST","9","8","8","Porata, Adalya, Aridata, ");
INSERT INTO pmy_vpl VALUES ("ET9_9","018_9_9","EST","9","9","9","Parmasta, Arisai, Aridai, deng Waizata. ");
INSERT INTO pmy_vpl VALUES ("ET9_10","018_9_10","EST","9","10","10","Dong spulu tu Hamedata pu cucu, anak dari Haman, orang Yahudi pu musu besar. Tapi orang Yahudi tra ambil dong yang dapa bunu tu pu harta benda. ");
INSERT INTO pmy_vpl VALUES ("ET9_11","018_9_11","EST","9","11","11","Di hari itu juga, dong kastau ke raja brapa banyak orang-orang yang dapa bunu di dalam benteng Kota Susan situ. ");
INSERT INTO pmy_vpl VALUES ("ET9_12","018_9_12","EST","9","12","12","Trus raja bilang ke Ratu Ester begini, “Dalam benteng Kota Susan saja, orang Yahudi su bunu deng kas sapu bersi 500 orang tamba deng Haman pu anak spulu orang itu. Di propinsi lain lagi yang raja printa, tra tau dong su bikin apa. Jadi skarang, ko mo apa? Pasti sa kasi, trus yang ko mau juga tu apa? Pasti ko dapat.” ");
INSERT INTO pmy_vpl VALUES ("ET9_13","018_9_13","EST","9","13","13","Trus Ester de jawab begini, “Kalo Bapa Raja anggap ini baik, biar orang Yahudi yang di Kota Susan ni besok juga dong bikin smua aturan sperti hari ini. Trus untuk Haman pu anak spulu orang tu, biar kas gantung dong di tiang.” ");
INSERT INTO pmy_vpl VALUES ("ET9_14","018_9_14","EST","9","14","14","Suda, raja suru bikin begitu. Jadi dong kas kluar aturan satu di Kota Susan, trus Haman pu anak spulu orang tu dapa gantung di tiang. ");
INSERT INTO pmy_vpl VALUES ("ET9_15","018_9_15","EST","9","15","15","Orang-orang Yahudi yang di Kota Susan dong kumpul sama-sama lagi pas di tanggal 14 bulan Adar tu, trus dong bunu 300 orang di Kota Susan situ. Tapi, dong tra ambil orang-orang itu pu harta benda. ");
INSERT INTO pmy_vpl VALUES ("ET9_16","018_9_16","EST","9","16","16","Orang Yahudi yang lain, yang ada dalam propinsi-propinsi yang raja printa ni, dong kumpul sama-sama untuk bela dong pu diri deng untuk kas aman diri dari dong pu musu. Orang Yahudi dong bunu 75.000 orang yang benci dorang. Tapi, dong tra ambil orang-orang itu pu harta benda. ");
INSERT INTO pmy_vpl VALUES ("ET9_17","018_9_17","EST","9","17","17","Ini smua jadi pas tanggal 13 bulan Adar. Pas tanggal 14, dong brenti, trus dong kas kusus hari itu untuk pesta yang bikin snang skali. ");
INSERT INTO pmy_vpl VALUES ("ET9_18","018_9_18","EST","9","18","18","Tapi, orang Yahudi yang di Kota Susan tu, dong kumpul di tanggal 13 deng tanggal 14 di bulan itu. Dong brenti pas hari ke 15 trus hari itu dong bikin jadi hari pesta yang bikin dong snang skali. ");
INSERT INTO pmy_vpl VALUES ("ET9_19","018_9_19","EST","9","19","19","Itu jadi, orang Yahudi yang di kampung, yang tinggal di kota-kota kecil, dong bikin tanggal 14 di bulan Adar ni jadi dong pu hari kusus untuk pesta yang bikin snang skali, untuk baku antar makanan. ");
INSERT INTO pmy_vpl VALUES ("ET9_20","018_9_20","EST","9","20","20","Mordekhai de tulis smua yang jadi ini, trus de kirim surat ke smua orang Yahudi yang tinggal di smua propinsi yang Raja Ahasyweros printa, mo yang dekat ka, ato yang jau. ");
INSERT INTO pmy_vpl VALUES ("ET9_21","018_9_21","EST","9","21","21","De kas harus dong untuk tiap taun harus kas kusus tanggal 14 deng 15 di bulan Adar. ");
INSERT INTO pmy_vpl VALUES ("ET9_22","018_9_22","EST","9","22","22","Karna pas di hari-hari itu suda, orang Yahudi dong aman dari dong pu musu-musu. Trus pas di bulan Adar ni juga dong pu rasa sedi skali dapa ganti deng rasa snang skali. Trus hari duka tu, su jadi hari yang besar. Karna itu dong harus bikin pesta yang snang skali di hari-hari itu, sama hari untuk baku antar makanan deng bikin baik ke orang-orang miskin. ");
INSERT INTO pmy_vpl VALUES ("ET9_23","018_9_23","EST","9","23","23","Jadi orang Yahudi dong ikut apa yang Mordekhai su tulis dalam surat trus dong su mulai bikin pesta, itu nanti jadi dong pu adat tiap taun. ");
INSERT INTO pmy_vpl VALUES ("ET9_24","018_9_24","EST","9","24","24","Karna Hamedata orang Agag tu pu anak Haman, yang smua orang Yahudi pu musu besar, su bikin rencana untuk kas sapu bersi orang Yahudi. De juga su buang undi yang dong bilang itu pur, untuk kas hancur deng kas sapu bersi orang Yahudi dorang. ");
INSERT INTO pmy_vpl VALUES ("ET9_25","018_9_25","EST","9","25","25","Tapi waktu hal ni dapa kastau ke depan raja, raja de kas printa pake surat, supaya rencana jahat yang Haman de mo bikin untuk orang Yahudi ni dong kas balik ke Haman. Itu yang Haman deng de pu anana dong dapa gantung di tiang. ");
INSERT INTO pmy_vpl VALUES ("ET9_26","018_9_26","EST","9","26","26","Itu jadi, hari-hari itu tu dong bilang Purim, ikut de pu kata pur. Juga karna smua isi surat itu deng karna apa yang dong liat deng apa yang su jadi ke dong itu, ");
INSERT INTO pmy_vpl VALUES ("ET9_27","018_9_27","EST","9","27","27","orang Yahudi dong trima itu jadi dong pu aturan untuk dong pu diri sendiri sama dong pu anana cucu deng sapa saja yang mo gabung deng dorang, kalo dong trakan kas lewat dua hari ini untuk bikin pesta ini stiap taun, sperti yang su tatulis deng pas di waktu yang dong su kas tetap. ");
INSERT INTO pmy_vpl VALUES ("ET9_28","018_9_28","EST","9","28","28","Dari yang dong su kas tetap itu, di tiap turunan, di tiap kluarga besar, di tiap propinsi, deng tiap kota, orang Yahudi harus ingat deng bikin pesta untuk hari-hari Purim itu. Supaya hari-hari ini tra hilang dari dorang, trus dong pu anana cucu trakan perna stop bikin pesta untuk ingat apa yang su jadi. ");
INSERT INTO pmy_vpl VALUES ("ET9_29","018_9_29","EST","9","29","29","Ratu Ester yang Bapa Abihail pu anak, sama-sama deng Mordekhai orang Yahudi, tulis surat yang kedua ni tentang hari besar Purim deng kuasa yang de punya untuk kas tegas itu. ");
INSERT INTO pmy_vpl VALUES ("ET9_30","018_9_30","EST","9","30","30","Baru dong kirim surat-surat itu deng kata-kata damai deng aman ke smua orang Yahudi di dalam 127 propinsi yang Raja Ahasyweros pimpin itu. ");
INSERT INTO pmy_vpl VALUES ("ET9_31","018_9_31","EST","9","31","31","Surat-surat itu kastau kalo orang Yahudi harus kas ingat dong pu diri untuk bikin hari-hari Purim itu ikut de pu waktu yang Mordekhai orang Yahudi tu deng Ratu Ester su kas tetap untuk dorang, sama sperti yang dong sendiri su kas harus dong pu diri deng dong pu anana cucu tentang puasa deng mnangis-mnangis itu. ");
INSERT INTO pmy_vpl VALUES ("ET9_32","018_9_32","EST","9","32","32","Jadi begitu suda, Ester pu printa yang su kas tetap hari Purim ini, trus dong tulis dalam buku sejara. ");
INSERT INTO pmy_vpl VALUES ("ET10_1","018_10_1","EST","10","1","1","Raja Ahasyweros de printa ke smua orang yang ada di darat deng di pinggir-pinggir laut untuk harus bayar pajak brat. ");
INSERT INTO pmy_vpl VALUES ("ET10_2","018_10_2","EST","10","2","2","Smua yang besar deng yang hebat-hebat yang raja de bikin, trus crita lengkap tentang bagemana de bikin Mordekhai jadi pejabat tinggi, smua itu dong su tulis di buku sejara yang crita tentang raja-raja Media deng Persia to? ");
INSERT INTO pmy_vpl VALUES ("ET10_3","018_10_3","EST","10","3","3","Mordekhai orang Yahudi tu, de yang jadi orang kedua di bawa Raja Ahasyweros, baru orang Yahudi paling hormat de skali, trus de pu kluarga besar dong juga snang dia. Karna de slalu cari yang baik untuk de pu bangsa, trus de juga bicara untuk kas slamat smua orang yang satu bangsa deng dia.");
INSERT INTO pmy_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Dulu skali ada orang satu, de pu nama Yunus. De pu bapa nama Amitai. Satu kali begini TUHAN bicara sama Yunus, TUHAN bilang, ");
INSERT INTO pmy_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","“Yunus! Skarang ko pigi ke kota Niniwe, kota yang besar tu, trus ko tegur dong di sana, bilang dong kalo Sa su tau dong pu jahat.” ");
INSERT INTO pmy_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Tapi Yunus de tra mau pigi ke Niniwe baru de ke Tarsis, karna de pikir biar de bisa jau dari TUHAN. Pertama, de ke kota Yope, trus de ketemu kapal yang mo ke Tarsis. Langsung de bli tiket, naik kapal sama-sama deng anana bua kapal dong ke Tarsis. De mo ke Tarsis biar de bisa jau dari TUHAN. ");
INSERT INTO pmy_vpl VALUES ("JH1_4","033_1_4","JON","1","4","5","Jadi suda dong pigi layar, dong layar begini Yunus de turun ke dek yang paling bawa baru de tidur, de tidur sono skali. Begini TUHAN De kas turun angin besar di laut, bikin sampe ada badai. Badai besar itu yang hantam kapal sampe hampir kapal de hancur. Bikin sampe anana bua kapal dong pu takut apa, dong masing-masing batariak-batariak minta tolong ke dong pu dewa-dewa. Trus dong buang barang-barang yang ada di atas kapal tu supaya kas ringan kapal. ");
INSERT INTO pmy_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Waktu kapten kapal de turun ke dek yang paling bawa, de ketemu Yunus trus bilang, “Beee bisa eh, ko tidur sono begini? Bangun suda! Baru ko lagi berdoa minta tolong sama ko pu allah. Sapa tau ko pu allah de dengar baru de mo tolong tong biar tong smua tra mati di sini!” ");
INSERT INTO pmy_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Stela itu dong dua naik ke atas, begini anana bua kapal dong baku bicara trus dong bilang, “Suda, tong buang undi saja biar tong tau sapa yang bikin sampe tong bisa kena susa begini.” Trus dong buang undi begini, Yunus yang kena, de yang sala. ");
INSERT INTO pmy_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Baru dong tanya dia, “Ko ini sapa? Ko kerja apa? Ko asal dari mana? Dari kampung mana? Kastau kitong, sapa pu sala yang bikin sampe tong kena susa begini?” ");
INSERT INTO pmy_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Trus Yunus de bilang, “Sa ni orang Ibrani. Sa semba TUHAN, Allah yang ada di surga, yang su bikin laut sama darat.” ");
INSERT INTO pmy_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Trus Yunus de crita sama dorang, bagemana de lari dari TUHAN. Dengar Yunus pu jawab bikin sampe dong smua takut skali. Baru dong bilang lagi sama Yunus, “Bisa tu ko bikin begitu?” ");
INSERT INTO pmy_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Waktu dong ada bicara, ombak tamba besar trus. Jadi dong tanya dia, “Tong bikin apa ko, supaya laut ini tedu?” ");
INSERT INTO pmy_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","De bilang, “Karna sa su tau, kalo sa ini yang bikin sampe badai besar datang bikin susa kam. Jadi kam angkat buang sa ke laut suda! Kalo kam angkat buang sa ke laut, nanti laut de tedu baru tra bikin susa kam lagi.” ");
INSERT INTO pmy_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Tapi anana bua kapal tu dong tra mau buang Yunus ke laut, jadi dong dayung kuat-kuat ke darat. Tapi tra bisa ke darat karna ombak tamba besar lagi jadi. ");
INSERT INTO pmy_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Trus dong berdoa sama TUHAN, dong bilang, “TUHAN, tong minta skali, jang bunu kitong, karna tong buang orang ini ke laut. Trus TUHAN jang hukum tong yang bunu orang ini kalo memang de ini tra sala. Karna smua yang jadi ni sperti apa yang TUHAN mau.” ");
INSERT INTO pmy_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Habis berdoa, anana bua kapal dong angkat buang Yunus ke laut, itu baru ombak besar-besar tu tedu. ");
INSERT INTO pmy_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Liat ombak besar-besar tu tedu itu yang bikin sampe dong smua takut skali sama TUHAN, jadi dong potong binatang untuk jadi persembahan ke TUHAN sama dong bikin janji sama TUHAN. ");
INSERT INTO pmy_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Waktu dong buang Yunus ke laut, TUHAN De suru ikan besar satu untuk datang telan Yunus. Trus Yunus de tinggal dalam ikan besar itu pu perut slama tiga hari tiga malam. ");
INSERT INTO pmy_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Dari dalam ikan besar tu de pu perut, Yunus de berdoa sama TUHAN, de pu Allah. ");
INSERT INTO pmy_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","De bilang, “Waktu sa tenggelam, sa susa skali, sa batariak minta tolong sama TUHAN, baru TUHAN tolong saya. Sa su hampir mati, sa batariak minta tolong sama TUHAN, baru TUHAN dengar sa pu doa. ");
INSERT INTO pmy_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","TUHAN su lempar sa ke dasar laut yang paling dalam, ke lautan pu dasar yang paling dalam. Arus air su kurung saya, baru TUHAN pu ombak besar-besar su tutup saya. ");
INSERT INTO pmy_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Baru dalam hati sa bilang, ‘TUHAN su usir sa, usir sa jau-jau dari TUHAN. Tapi tetap sa percaya, sa lagi nanti bisa liat TUHAN pu tempat tinggal yang suci.’ ");
INSERT INTO pmy_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Air laut smua su tutup sa, dong smua su kas tenggelam sa. Baru rumput-rumput laut su ikat sa pu kepala. ");
INSERT INTO pmy_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Sa tenggelam sampe ke dasar gunung-gunung di dalam pusat lautan. Sa takurung! Trada jalan kluar, macam sa ada di dalam lobang kubur. Tapi TUHAN kas slamat sa, ya TUHAN, sa pu Allah. ");
INSERT INTO pmy_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Waktu pas sa su tra kuat lagi, sa ingat TUHAN, trus TUHAN dengar sa pu doa dari dalam TUHAN pu tempat tinggal yang suci. ");
INSERT INTO pmy_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Sa tau, smua orang yang percaya skali sama dong pu dewa-dewa yang tra bisa tolong dorang tu, dong itu yang kas tinggal TUHAN, deng tra mau trima De pu sayang. ");
INSERT INTO pmy_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Tapi kalo saya, sa mo mnyanyi puji TUHAN, sama sa mo potong binatang untuk jadi persembahan buat TUHAN. Apa yang sa su janji, itu suda yang nanti sa bikin. Hanya TUHAN saja yang bisa kas slamat orang.” ");
INSERT INTO pmy_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Habis Yunus de berdoa, TUHAN suru ikan besar itu de munta Yunus di darat, trus ikan besar itu bikin sperti TUHAN bilang. ");
INSERT INTO pmy_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Begini TUHAN bicara sama Yunus untuk yang kedua kali, TUHAN bilang, ");
INSERT INTO pmy_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","“Yunus! Skarang ko pigi ke Niniwe, kota yang besar tu, trus ko kastau orang-orang Niniwe Sa pu pesan yang Sa bilang sama ko.” ");
INSERT INTO pmy_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Yunus de siap-siap, trus pigi ke Niniwe, de bikin sperti yang TUHAN suru. Niniwe tu kota yang besar skali, tiga hari jalan kaki baru bisa liat kota Niniwe pu smua-smua. ");
INSERT INTO pmy_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Waktu Yunus de sampe di kota itu, de jalan slama satu hari, baru de mulai batariak tegur orang-orang di situ. De bilang, “40 hari lagi, Niniwe nanti dapa kas hancur rata deng tana.” ");
INSERT INTO pmy_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Waktu orang-orang Niniwe dengar yang Yunus de bilang tu, dong langsung percaya sama Allah. Baru dong smua bilang, “Tong smua di Niniwe harus puasa, tra bole makan deng minum.” Baru dong smua, orang besar, anana kecil, smua pake kain kabung tutup dong badan. ");
INSERT INTO pmy_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Stela raja Niniwe de dengar lagi kalo TUHAN mo kas hancur Niniwe, de turun dari de pu kursi raja. Baru de lepas de pu baju panjang krajaan, baru de pake kain kabung tutup de badan, trus de duduk di atas abu. ");
INSERT INTO pmy_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Baru raja deng de pu orang-orang penting dong suru pesuru-pesuru untuk kastau orang-orang di Niniwe begini, “Kam smua deng kam pu binatang-binatang piara, sapi ka, kambing ka, domba ka, kam smua tra bole makan apapa deng tra bole minum. ");
INSERT INTO pmy_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Kam smua, manusia ka, binatang-binatang yang kam piara ka, harus tutup kam pu badan deng kain kabung baru harus berdoa sunggu-sunggu minta ampun sama Allah. Trus masing-masing orang harus kas tinggal de pu klakuan yang jahat sama stop tindas orang lain. ");
INSERT INTO pmy_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Sapa tau, kalo tong buat begitu Allah bisa bruba pikiran baru tra mara tong lagi sama tra bunu tong smua.” ");
INSERT INTO pmy_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Waktu Allah liat smua yang dong su bikin, deng liat dong juga su tra buat jahat lagi, jadi Allah bruba pikiran untuk tra bikin sperti yang De su bilang sama Yunus. Allah tra jadi kas hancur Niniwe rata deng tana. ");
INSERT INTO pmy_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Karna TUHAN De tra jadi kas hancur Niniwe, bikin sampe Yunus de tra snang skali, trus de mara skali. ");
INSERT INTO pmy_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Baru de berdoa sama TUHAN, de bilang, “TUHAN, sa su bilang to, waktu sa masi di sa pu negri, kalo nanti TUHAN bikin sperti begini. Sa tau kalo TUHAN tu Allah yang paling baik sama sayang manusia. TUHAN juga paling sabar, tra perna stop kas tunjuk TUHAN pu baik sama smua orang. Sa su tau skali mo, kalo TUHAN pasti bruba pikiran jadi tra hukum dorang. Itu yang, knapa dulu sa lari ke Tarsis. ");
INSERT INTO pmy_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Jadi, TUHAN, bunu sa saja suda, karna lebi baik sa mati daripada sa hidup.” ");
INSERT INTO pmy_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Tapi TUHAN De bilang begini, “Ko sapa lagi jadi ko mara?” ");
INSERT INTO pmy_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Suda, trus Yunus de jalan kluar kas tinggal Niniwe. De jalan ke sebla timur, de ke tempat yang de bisa pake pantau kota itu. Baru de bikin pondok kecil satu di situ, untuk duduk tunggu apa yang nanti jadi di kota Niniwe. ");
INSERT INTO pmy_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Baru TUHAN Allah De kas tumbu tanaman yang de pu daun banyak, baru tanaman itu tumbu lewat Yunus pu kepala supaya bikin sombar Yunus dia, sampe de pu kepala tra kena panas lagi. Baru Yunus de snang skali sama tanaman itu. ");
INSERT INTO pmy_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Tapi besok pagi waktu masi pagi-pagi skali, Allah suru ulat satu kesitu makan tanaman tu pu batang sampe tanaman tu de layu, layu itu yang tra bisa bikin sombar Yunus de lagi. ");
INSERT INTO pmy_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Waktu pas matahari su tinggi, Allah kasi angin timur yang panas tatiup ke ara Yunus. Baru panas matahari lagi bakar Yunus de pu kepala sampe Yunus de hampir pingsan. Baru de harap supaya de mati saja, de bilang begini, “Lebi baik sa mati saja daripada sa hidup!” ");
INSERT INTO pmy_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Tapi Allah De bilang ke Yunus, “Ko kecewa karna tanaman itu de mati ka? Ko sapa lagi jadi ko mara?” Trus Yunus de bilang, “Sa pu hak to untuk mara, sa mara sampe sa tra mau hidup lagi!” ");
INSERT INTO pmy_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Trus TUHAN De bilang begini, “Ko sayang eee, sama tanaman itu, jadi ko pu hati susa pas de layu. Padahal ko tra bantu sdikit juga untuk bikin de tumbu. Tanaman yang de tumbu satu malam trus de mati satu malam juga. ");
INSERT INTO pmy_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Baru Sa lagi tra bole sayang sama Niniwe ka? Niniwe, kota yang besar tu, yang ada 120.000 orang lebi yang tinggal di situ, blum lagi dong pu binatang-binatang piara yang banyak skali tu. Dong tu orang-orang yang tra bisa kas beda mana yang baik deng mana yang jahat. Sa lagi tra bole sayang dong ka?”");
INSERT INTO pmy_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ini Yesus Kristus pu daftar nene moyang. De ni Daud deng Abraham pu turunan. Ini dong pu nama-nama dari Abraham sampe Daud: ");
INSERT INTO pmy_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham pu anak Ishak, Ishak pu anak Yakub, Yakub pu anak Yehuda deng de pu sodara-sodara laki-laki, ");
INSERT INTO pmy_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yehuda pu anak Peres deng Zerah, dong pu mama tu Tamar. Peres pu anak Hezron, Hezron pu anak Ram, ");
INSERT INTO pmy_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram pu anak Aminadab, Aminadab pu anak Nahason, Nahason pu anak Salmon, ");
INSERT INTO pmy_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon pu anak Boas, Boas pu mama tu Rahab. Boas pu anak Obed, Obet pu mama tu Rut. Obed pu anak Isai, ");
INSERT INTO pmy_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isai pu anak Raja Daud. Ini dong pu nama-nama, dari Raja Daud sampe waktu bangsa Israel dapa buang ke Babel. Daud pu anak Salomo, Salomo pu mama tu dulu Uria pu istri. ");
INSERT INTO pmy_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomo pu anak Rehabeam, Rehabeam pu anak Abia, Abia pu anak Asa, ");
INSERT INTO pmy_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa pu anak Yosafat, Yosafat pu anak Yoram, Yoram pu anak Uzia, ");
INSERT INTO pmy_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzia pu anak Yotam, Yotam pu anak Ahas, Ahas pu anak Hizkia, ");
INSERT INTO pmy_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hizkia pu anak Manasye, Manasye pu anak Amon, Amon pu anak Yosia. ");
INSERT INTO pmy_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosia pu anak Yekhonya deng de pu sodara-sodara laki-laki, itu waktu bangsa Israel dapa buang ke Babel. ");
INSERT INTO pmy_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ini dong pu nama-nama dari waktu dong dapa buang ke Babel: Yekhonya pu anak Sealtiel, Sealtiel pu anak Zerubabel, ");
INSERT INTO pmy_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubabel pu anak Abihud, Abihud pu anak Elyakim, Elyakim pu anak Azor, ");
INSERT INTO pmy_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor pu anak Zadok, Zadok pu anak Akhim, Akhim pu anak Eliud, ");
INSERT INTO pmy_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud pu anak Eleazar, Eleazar pu anak Matan, Matan pu anak Yakub. ");
INSERT INTO pmy_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakub pu anak Yusup. Yusup tu Maria pu suami, Maria yang lahir Yesus yang orang panggil Kristus, Raja Yang Allah Pili. ");
INSERT INTO pmy_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Jadi dari Abraham sampe Daud, jumla smua ada 14 turunan. Trus dari Daud sampe waktu Israel dapa buang ke Babel, ada 14 turunan. Trus ada 14 turunan juga dari waktu Israel dapa buang ke Babel sampe waktu Kristus lahir. ");
INSERT INTO pmy_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ini crita tentang Yesus Kristus lahir. Waktu itu Maria, Yesus pu mama, su tunangan deng Yusup. Tapi seblum dong dua tinggal sama-sama, Maria ni de su hamil karna kuasa dari Roh Allah. ");
INSERT INTO pmy_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Karna de pu suami Yusup ni orang yang hidup ikut Allah pu mau, trus de tra mau bikin Maria malu di depan orang banyak, jadi de mo pisa deng Maria diam-diam. ");
INSERT INTO pmy_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Tapi waktu de masi pikir-pikir masala itu, begini Tuhan pu malaikat datang sama de dalam mimpi baru bilang, “Yusup, Raja Daud pu turunan, ko jang takut ambil Maria jadi ko pu istri, karna anak yang ada di dalam de pu perut tu dari Roh Allah. ");
INSERT INTO pmy_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","De pasti lahir anak laki-laki baru ko kas nama De Yesus, karna De yang mo kas slamat De pu orang-orang dari dong pu dosa-dosa.” ");
INSERT INTO pmy_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Smua ini jadi supaya Tuhan pu kata-kata dulu lewat De pu nabi tu su jadi, ");
INSERT INTO pmy_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Nanti ada nona satu yang hamil trus lahir anak laki-laki, baru nanti dong kas nama De Imanuel,” yang de pu arti, ʻAllah ada sama-sama deng kitong.ʼ ");
INSERT INTO pmy_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Waktu Yusup de bangun, de bikin sama sperti yang Tuhan pu malaikat kas printa sama dia. De ambil Maria jadi de pu istri. ");
INSERT INTO pmy_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Tapi dong dua tra tidur sama-sama sampe Maria lahir anak laki-laki trus Yusup kas nama De Yesus. ");
INSERT INTO pmy_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesus lahir di Betlehem di propinsi Yudea waktu Herodes yang jadi raja disana. Waktu itu, tukang baca bintang dong datang dari timur ke Yerusalem. ");
INSERT INTO pmy_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Waktu dong sampe di Yerusalem, dong tanya-tanya, “Anak yang lahir untuk jadi orang Yahudi pu raja itu dimana? Tong su liat De pu bintang di timur, jadi tong datang untuk semba Dia.” ");
INSERT INTO pmy_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Waktu raja Herodes dengar begitu, de kaget skali, begitu juga deng smua orang di Yerusalem. ");
INSERT INTO pmy_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Jadi de kumpul imam kepala smua deng orang Yahudi pu guru-guru agama, trus de cari tau dari dong, Raja Yang Allah Pili mo lahir dimana. ");
INSERT INTO pmy_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Dong bilang dia, “Di Betlehem di propinsi Yudea, karna ada tatulis di nabi satu pu kitab begini, ");
INSERT INTO pmy_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Betlehem, yang di Yehuda pu tana, ko sama skali bukan kota yang paling kecil di tenga-tenga kota-kota yang penting di Yehuda, karna dari ko nanti muncul satu orang yang jadi gembala untuk Sa pu orang-orang Israel.’ ” ");
INSERT INTO pmy_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Trus Herodes de panggil tukang baca bintang itu diam-diam. Baru de tanya dong kapan bintang itu muncul. ");
INSERT INTO pmy_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Habis itu de suru dong ke Betlehem, de bilang, “Pigi trus cari anak itu baik-baik. Habis kam ketemu Dia cepat kastau sa lagi, biar sa juga pigi semba Dia.” ");
INSERT INTO pmy_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Habis dengar raja pu kata-kata, dong pigi. Trus bintang yang dulu dong liat di timur tu jalan duluan dong, trus bintang itu brenti pas di atas ruma tempat anak itu tinggal. ");
INSERT INTO pmy_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Waktu liat bintang itu, dong snang skali. ");
INSERT INTO pmy_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Trus dong masuk ke dalam ruma itu baru liat anak itu ada sama-sama deng Maria, De pu mama, trus dong tunduk semba Dia. Habis itu dong kas kluar emas, kemenyan, deng mur dari dong pu tempat harta, baru kasi hadia untuk Dia. ");
INSERT INTO pmy_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Karna Allah su kas ingat dalam mimpi untuk jang kembali ke Herodes, jadi dong pulang ke dong pu negri lewat jalan lain. ");
INSERT INTO pmy_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Habis tukang baca bintang itu dong pulang, Tuhan pu malaikat datang ke Yusup dalam mimpi baru bilang, “Yusup, ko bangun, ambil Anak itu deng De pu mama, kam lari ke Mesir. Tinggal disana sampe Sa bicara lagi deng ko, karna Herodes mo cari Anak itu untuk bunu Dia.” ");
INSERT INTO pmy_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Jadi malam itu juga, Yusup bangun ambil Anak itu deng De pu mama, trus dong lari ke Mesir. ");
INSERT INTO pmy_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Dong tinggal disana sampe Herodes mati. Begitu supaya Tuhan pu kata-kata dulu lewat Nabi Hosea tu su jadi, De bilang begini, “Sa panggil Sa pu Anak kluar dari Mesir.” ");
INSERT INTO pmy_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Waktu Herodes sadar kalo de su dapa tipu dari orang-orang tukang baca bintang itu, de mara skali. Trus de suru bunu anak laki-laki kecil smua yang di Betlehem deng daera-daera sebla, anana yang umur dua taun ke bawa, pas deng waktu yang tukang baca bintang dong pertama kali liat bintang itu. ");
INSERT INTO pmy_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Begitu supaya Allah pu kata-kata dulu lewat Nabi Yeremia tu su jadi, ");
INSERT INTO pmy_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Di kota Rama, ada suara orang mnangis sedi skali, itu Rahelyang mnangis de pu anana, baru de tra mau dapa hibur karna de pu anana su trada lagi.” ");
INSERT INTO pmy_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Habis Herodes mati, Tuhan pu malaikat datang ke Yusup dalam mimpi di Mesir. ");
INSERT INTO pmy_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Trus malaikat itu bilang ke Yusup, “Yusup, ko bangun. Ambil Anak itu deng De pu mama, trus kembali ke tana Israel karna dong yang mo bunu Anak itu su mati.” ");
INSERT INTO pmy_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Jadi Yusup bangun, ambil Anak itu deng De pu mama untuk mo kembali ke tana Israel. ");
INSERT INTO pmy_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Tapi waktu Yusup dengar kalo Arkelaus su jadi raja di daera Yudea ganti de pu bapa Herodes, Yusup jadi takut mo kesana. Trus karna Allah su kas ingat lagi dalam mimpi, jadi Yusup pigi ke daera Galilea. ");
INSERT INTO pmy_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Di Galilea, dong tinggal di kota yang nama Nasaret. Begitu supaya Allah pu kata-kata dulu lewat nabi-nabi tu su jadi, kalo De nanti dapa panggil ʻOrang Nasaret.ʼ ");
INSERT INTO pmy_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Brapa pulu taun su lewat begini, ada orang satu yang nama Yohanes, de tu tukang baptis. De datang ke tempat sepi yang kring di Yudea, trus de biasa kastau begini, ");
INSERT INTO pmy_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Tobat dari kam pu dosa-dosa, karna Krajaan Surga su dekat!” ");
INSERT INTO pmy_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yohanes ni suda orang yang dulu Nabi Yesaya maksud waktu de bilang, “Ada suara yang batariak di tempat sepi yang kring, ‘Kas siap jalan untuk Tuhan, kas lurus jalan untuk Dia.’ ” ");
INSERT INTO pmy_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohanes pake baju panjang dari bulu unta, de pu ikat pinggang dari binatang pu kulit. Trus de pu makanan belalang deng madu hutan. ");
INSERT INTO pmy_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Trus orang-orang dari Yerusalem, dari smua Yudea deng dari smua daera skitar kali Yordan datang trus-trus ke dia. ");
INSERT INTO pmy_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Dong mngaku dong pu dosa-dosa trus dapa baptis dari Yohanes di kali Yordan. ");
INSERT INTO pmy_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Tapi waktu Yohanes liat orang Farisi deng orang Saduki banyak yang datang untuk dapa baptis, de bilang ke dong begini, “Kam ini ular bisa pu turunan! Sapa yang kas ingat kam untuk lari dari Allah pu mara besar yang nanti datang? ");
INSERT INTO pmy_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Kalo memang kam su tobat dari dosa, kas hasil bua yang pantas untuk orang yang su tobat. ");
INSERT INTO pmy_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Jang kam pikir dalam hati, ‘Tong slamat karna bapa Abraham tu tong pu nene moyang!’ Dengar eh, Allah bisa bikin anana buat bapa Abraham dari batu-batu ini! ");
INSERT INTO pmy_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Kapak su siap mo tebang pohon sampe ke akar-akar, jadi pohon yang tra kas hasil bua yang baik, pasti dapa tebang trus buang ke api. ");
INSERT INTO pmy_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Sa baptis kam deng air untuk jadi tanda kalo kam su tobat dari kam pu dosa-dosa tu. Tapi De yang mo datang stela saya, De mo baptis kam deng Roh Allah juga deng api. De pu kuasa lebi besar dari saya, mo buka De pu spatu saja sa tra pantas. ");
INSERT INTO pmy_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","De su mo kas pisa orang yang baik deng yang jahat, macam orang yang su pegang tapis untuk kas pisa biji gandum dari ampas. Biji gandum De kumpul ke de pu tempat, tapi smua ampas De nanti bakar di api yang tra bisa padam.” ");
INSERT INTO pmy_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Begini Yesus datang dari daera Galilea ke Yohanes di kali Yordan untuk dapa baptis dari dia. ");
INSERT INTO pmy_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Tapi Yohanes coba tolak Yesus pu mau, Yohanes bilang, “Sa yang harus dapa baptis dari Bapa, knapa Bapa yang datang sama saya?” ");
INSERT INTO pmy_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Tapi Yesus jawab, “Bikin sperti yang Sa minta, karna tong harus bikin smua yang Allah mau.” Jadi Yohanes ikut saja apa yang Yesus bilang. ");
INSERT INTO pmy_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Habis dapa baptis, Yesus langsung kluar dari air. Tiba-tiba langit tabuka trus De liat Roh Allah turun sperti burung merpati ke atas Dia. ");
INSERT INTO pmy_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Trus ada suara dari surga yang bilang, “Ini suda Sa pu Anak yang Sa sayang, De yang bikin Sa pu hati snang.” ");
INSERT INTO pmy_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Habis itu Roh Allah bawa naik Yesus ke tempat sepi yang kring untuk dapa coba dari Iblis. ");
INSERT INTO pmy_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Di tempat itu, Yesus puasa slama 40 hari 40 malam, sampe Yesus rasa lapar. ");
INSERT INTO pmy_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Begini Iblis yang suka coba orang datang baru bilang sama Dia, “Ko ni Allah pu Anak to? Coba Ko suru batu-batu ini jadi roti.” ");
INSERT INTO pmy_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Tapi Yesus bilang, “Ada tatulis begini, ‘Manusia hidup tu bukan dari roti saja, tapi dari stiap kata-kata yang kluar dari Allah pu mulut.’ ” ");
INSERT INTO pmy_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Habis itu Iblis bawa Yesus ke Yerusalem, kota yang suci itu, trus bawa De di ujung bagian atas Ruma Allah. ");
INSERT INTO pmy_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Baru de bilang ke Yesus, “Ko ni Allah pu Anak to, coba Ko lompat ke bawa, karna ada tatulis begini, ‘Tentang Ko, Allah pasti kas printa De pu malaikat-malaikat untuk tada Ko deng dong pu tangan, supaya Ko pu kaki juga jang kena batu.’ ” ");
INSERT INTO pmy_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesus bilang, “Ada tatulis juga, ‘Jang ko coba-coba ko pu Tuhan Allah!’ ” ");
INSERT INTO pmy_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Habis itu Iblis bawa Yesus ke atas gunung yang tinggi skali, baru de kas liat krajaan dunia smua deng dong pu bagus-bagus smua. ");
INSERT INTO pmy_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Baru de bilang ke Yesus, “Ini smua sa nanti kasi untuk Ko, kalo Ko mo tunduk semba saya.” ");
INSERT INTO pmy_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Begini Yesus bilang, “Jau suda Iblis! Karna ada tatulis, ‘Ko harus semba ko pu Tuhan Allah, trus ko harus kerja hanya untuk De saja!’ ” ");
INSERT INTO pmy_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Trus Iblis kas tinggal Dia, baru malaikat-malaikat datang layani Yesus. ");
INSERT INTO pmy_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Waktu Yesus dengar kalo Yohanes su dapa tangkap, De pigi ke daera Galilea. ");
INSERT INTO pmy_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Di Galilea Yesus pigi ke Nasaret. Habis itu de pinda baru tinggal di Kapernaum di pinggir danau Galilea, di daera Zebulon deng daera Naftali. ");
INSERT INTO pmy_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Begitu supaya Tuhan pu kata-kata dulu lewat Nabi Yesaya tu su jadi, ");
INSERT INTO pmy_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Suku Zebulon deng suku Naftali pu tana, yang ada di jalan mnuju danau Galilea, di sebla kali Yordan, itu daera Galilea, dimana banyak orang yang bukan Yahudi tinggal disitu. ");
INSERT INTO pmy_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Orang-orang yang tinggal dalam glap, dong su liat cahaya yang trang skali. Orang-orang yang takut mati, untuk dong su muncul sinar yang trang.” ");
INSERT INTO pmy_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Pas waktu itu suda, Yesus mulai kastau, “Tobat dari kam pu dosa-dosa, karna Krajaan Surga su dekat!” ");
INSERT INTO pmy_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Waktu Yesus ada jalan di pinggir danau Galilea, De liat ade kaka dua orang, yang satu pu nama Simon yang biasa dapa panggil Petrus, deng de pu sodara Andreas. Dong dua ada buang jala di danau, karna dong dua tu tukang tangkap ikan. ");
INSERT INTO pmy_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Trus Yesus bilang ke dong dua, “Mari, ikut Saya. Nanti Sa kas ajar kam dua untuk jadi orang yang jala manusia.” ");
INSERT INTO pmy_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Trus dong dua langsung kas tinggal dong pu jala baru ikut Dia. ");
INSERT INTO pmy_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Habis itu Yesus lanjut jalan lagi trus De liat dua orang ade kaka yang lain lagi, dong tu Yakobus deng de pu sodara Yohanes, dong dua ni Zebedeus pu anana. Dong ada kas baik jala di dalam prahu deng dong pu bapa. Yesus panggil dong juga untuk ikut Dia. ");
INSERT INTO pmy_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Trus dong dua langsung kas tinggal prahu deng dong pu bapa, baru ikut Dia. ");
INSERT INTO pmy_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesus jalan kliling smua daera di Galilea, De ajar di dalam dong pu tempat-tempat ibada deng kastau Brita Baik tentang Krajaan Surga, trus kas sembu orang-orang dari tenga-tenga bangsa itu yang mendrita macam-macam sakit deng cacat. ");
INSERT INTO pmy_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Crita tentang Yesus tu tasebar sampe di smua daera Siria juga. Jadi dong bawa banyak orang yang pu keadaan su para ke Dia, ada yang mendrita deng macam-macam penyakit deng yang rasa sakit skali, ada yang mati-mati ayam, ada yang lumpu, deng ada yang krasukan setan juga, trus Yesus kas sembu dong smua. ");
INSERT INTO pmy_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Jadi ada orang banyak skali yang ikut Dia. Dong datang dari daera Galilea deng Dekapolis, dari Yerusalem deng daera Yudea, deng dari sebla timur kali Yordan. ");
INSERT INTO pmy_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Waktu Yesus liat ada orang banyak yang ikut Dia, De naik ke atas bukit. Trus, De duduk disitu baru De pu pengikut datang ke dekat Dia. ");
INSERT INTO pmy_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Yesus mulai bicara deng kas ajar dong begini, ");
INSERT INTO pmy_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Orang yang sadar kalo dong perlu Allah, dong untung skali, karna dong su jadi Allah pu orang-orang di Krajaan Surga! ");
INSERT INTO pmy_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Orang yang skarang rasa hati sedi, dong untung skali, karna nanti dong dapa hibur. ");
INSERT INTO pmy_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Orang yang renda hati, dong untung skali, karna pasti Allah kasi bumi yang baru jadi dong pu milik. ");
INSERT INTO pmy_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Orang yang rindu kalo Allah pu mau jadi, dong untung skali, karna nanti Allah kas puas dong deng hal itu. ");
INSERT INTO pmy_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Orang yang suka kasian sama orang lain, dong untung skali, karna nanti dong dapa kasian dari Allah juga. ");
INSERT INTO pmy_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Orang yang pu hati bersi, dong untung skali, karna nanti dong yang liat Allah di surga. ");
INSERT INTO pmy_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Orang yang suka bikin orang baku damai, dong untung skali, karna nanti dong dapa sebut Allah pu anana. ");
INSERT INTO pmy_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Orang yang dapa siksa karna ikut Allah pu mau, dong untung skali, karna dong su jadi Allah di surga pu orang-orang. ");
INSERT INTO pmy_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Kam untung skali, waktu kam dapa ejek baru dapa siksa karna kam ikut Saya, trus dong bicara smua yang jahat tentang kam padahal itu tra benar. ");
INSERT INTO pmy_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Kam harus snang deng rasa syukur skali, karna kam pu hadia besar di surga, karna begitu juga nabi-nabi yang seblum kam su dapa siksa.” ");
INSERT INTO pmy_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Kam tu sperti garam untuk smua orang. Tapi kalo de su tra rasa asin, bisa ka bikin de pu rasa asin lagi? Garam itu tra bisa pake untuk bikin apapa, jadi pasti dapa buang trus dapa injak dari orang. ");
INSERT INTO pmy_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Kam tu sperti trang untuk smua orang. Sperti kota yang ada di atas gunung, tra mungkin tasembunyi. ");
INSERT INTO pmy_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Trada orang yang pasang plita baru tutup deng loyang, tapi de pasti taru plita di tempat yang tinggi supaya bisa kas trang smua orang di dalam ruma itu. ");
INSERT INTO pmy_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Begitu juga kam pu trang harus kentara untuk smua orang, supaya dong puji-puji kam pu Bapa yang di surga waktu dong liat hal-hal baik yang kam bikin.” ");
INSERT INTO pmy_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Kam jang pikir kalo Sa datang untuk kas hapus hukum Musa ato nabi-nabi pu ajaran. Sa datang bukan untuk kas hapus, tapi mo bikin smua hal jadi benar sperti yang dong su bilang. ");
INSERT INTO pmy_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Yang Sa bilang ini benar: Slama langit deng bumi ni blum hilang, satu huruf ato satu bagian yang paling kecil dalam hukum Musa trakan hilang sampe smua benar-benar jadi. ");
INSERT INTO pmy_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Jadi sapa saja yang langgar satu printa saja biar yang paling kecil dari hukum Musa, baru kas ajar begitu ke orang lain, nanti de dapat tempat yang paling renda dalam Krajaan Surga. Tapi sapa saja yang bikin deng kas ajar orang untuk ikut hukum Musa, nanti de dapat tempat yang paling tinggi dalam Krajaan Surga. ");
INSERT INTO pmy_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Sa bilang kam, kalo kam tra bikin apa yang Allah mau deng setia lebi dari guru-guru agama deng orang-orang dari klompok Farisi, brarti kam tra bisa masuk dalam Krajaan Surga. ");
INSERT INTO pmy_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Kam su perna dengar yang tong pu moyang dapa kas ajar, ‘Jang bunu orang,’ sapa yang bunu harus dapa hukum. ");
INSERT INTO pmy_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Tapi Sa bilang kam, sapa saja yang mara sama orang harus dapa hukum. Sapa saja yang hina orang, de harus dapa bawa ke sidang agama. Trus sapa saja yang bilang, ʻBodok!ʼ, de pantas dapa buang ke api neraka. ");
INSERT INTO pmy_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Jadi, kalo ko ada bawa persembahan ke tempat bakar, tapi ko ingat deng ko pu sodara yang ada sakit hati sama ko, ");
INSERT INTO pmy_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","kas tinggal ko pu persembahan di depan tempat bakar itu baru pigi damei dulu deng ko pu sodara, baru kembali kasi ko pu persembahan itu. ");
INSERT INTO pmy_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Kalo ada ko pu lawan yang lapor ko ke sidang, cepat kas slesai ko pu masala sama orang itu waktu di jalan. Supaya ko pu lawan tra kasi ko ke hakim, baru hakim kasi ko ke polisi, trus polisi kas masuk ko dalam penjara. ");
INSERT INTO pmy_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Yang Sa bilang ini benar: Ko pasti trakan kluar sampe ko bayar denda lunas. ");
INSERT INTO pmy_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Kam su perna dengar ajaran tentang, ‘Jang tidur deng orang yang bukan ko pu pasangan.’ ");
INSERT INTO pmy_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Tapi Sa bilang kam, sapa saja yang liat prempuan trus ada pikir untuk mo tidur deng prempuan itu, de su tidur deng prempuan itu dalam de pu pikiran. ");
INSERT INTO pmy_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kalo ko pu mata kanan bikin sampe ko bikin dosa, cungkil baru buang suda! Karna lebi baik ko pu anggota badan satu hilang, daripada ko pu badan deng lengkap dapa buang ke neraka. ");
INSERT INTO pmy_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kalo ko pu tangan kanan bikin sampe ko bikin dosa, potong baru buang suda! Karna lebi baik buat ko kalo ko pu anggota badan satu hilang, daripada ko pu badan deng lengkap masuk ke neraka. ");
INSERT INTO pmy_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ada ajaran juga tentang, ‘Sapa saja yang kas cerai de pu istri, harus kasi surat cerai ke de pu istri.’ ");
INSERT INTO pmy_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Tapi Sa bilang kam, sapa saja yang kas cerai de pu istri, kecuali kalo de pu istri bikin barang kurang ajar, itu de su bikin de pu istri nanti tidur deng orang yang bukan de pu pasangan. Begitu juga kalo sapa yang kawin deng prempuan yang su cerai, itu de su bikin dosa karna de su tidur deng orang yang bukan de pu pasangan. ");
INSERT INTO pmy_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Kam su perna dengar yang tong pu moyang dapa kas ajar, ‘Jang langgar ko pu sumpa, apa yang ko su janji deng sumpa depan Tuhan, harus ko bikin itu.’ ");
INSERT INTO pmy_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Tapi Sa bilang kam, tra bole sama skali ko sumpa biar demi langit ka, karna langit tu Allah pu kursi raja, ");
INSERT INTO pmy_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ato demi bumi ka, karna bumi tu Allah pu tempat taru kaki, ato demi Yerusalem ka, karna Yerusalem tu Raja Besar pu kota. ");
INSERT INTO pmy_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Jang juga ko sumpa demi ko pu kepala, karna ko tra pu kuasa untuk kas puti ato kas hitam satu urat rambut juga. ");
INSERT INTO pmy_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kalo iyo, bilang iyo. Kalo tidak, bilang tidak. Apa yang lebi dari itu, de pu asal dari De Yang Jahat. ");
INSERT INTO pmy_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Kam su dengar ajaran tentang, ‘Mata ganti mata, gigi ganti gigi.’ ");
INSERT INTO pmy_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Tapi Sa bilang kam, kam jang balas orang yang bikin jahat sama kam. Mala sapa saja yang tampar ko pu pipi kanan, kasi ko pu pipi kiri juga. ");
INSERT INTO pmy_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kalo ada orang yang lapor ko ke hakim deng mo dapa bayar pake ko pu baju, kasi ko pu baju panjang luar juga. ");
INSERT INTO pmy_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kalo ada orang yang paksa ko jalan jau sampe satu kilometer, jalan trus deng de sampe dua kilometer. ");
INSERT INTO pmy_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Kasi sama orang yang minta sama ko, trus jang ko tolak kalo ada orang yang mo pinjam dari ko. ");
INSERT INTO pmy_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Kam su dengar ajaran tentang, ‘Sayang orang lain trus tra suka skali sama kam pu musu.’ ");
INSERT INTO pmy_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Tapi Sa bilang kam, sayang sama kam pu musu-musu trus doa dong yang siksa kam. ");
INSERT INTO pmy_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Karna deng bikin begitu, kam su ikut kam pu Bapa di surga pu klakuan, De yang kas terbit matahari untuk orang yang jahat deng orang yang baik, trus kas turun hujan untuk orang yang benar deng orang yang tra benar. ");
INSERT INTO pmy_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kalo kam sayang sama orang yang sayang sama kam saja, kam pikir nanti Allah kasi kam hadia untuk itu? Tra to! Karna tukang tagi pajak juga bikin begitu to? ");
INSERT INTO pmy_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Kalo kam hanya kasi salam ke kam pu sodara-sodara saja, kam pu beda apa deng orang lain? Orang-orang yang tra knal Allah juga dong kasi salam ke dong pu sodara-sodara saja to? ");
INSERT INTO pmy_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Itu jadi, kam harus sempurna, sama sperti kam pu Bapa yang di surga juga sempurna.” ");
INSERT INTO pmy_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Ingat, kam jang bikin baik di depan orang untuk dong liat. Karna kalo kam bikin begitu, kam trakan dapat bagian dari kam pu Bapa di surga. ");
INSERT INTO pmy_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Jadi, kalo kam ada bantu orang miskin, kam jang kas tunjuk untuk orang tau, macam orang yang pura-pura baik biasa bikin di tempat-tempat ibada deng di tempat-tempat rame, supaya orang puji dorang. Yang Sa bilang ini benar: Hanya bagian itu saja yang dong dapat. ");
INSERT INTO pmy_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Tapi kalo kam ada bantu orang miskin, kam pu tangan kiri tra bole tau apa yang kam pu tangan kanan bikin. ");
INSERT INTO pmy_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Apa yang kam bikin tu biar trada orang yang tau. Deng bikin begitu, kam pu Bapa yang liat apa yang kam bikin deng diam-diam, nanti balas itu sama kam.” ");
INSERT INTO pmy_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Kalo kam ada doa, jang doa macam orang yang pura-pura baik. Dong suka bediri di dalam tempat-tempat ibada deng di pinggir-pinggir jalan raya untuk doa, supaya orang liat dorang. Yang Sa bilang ini benar: Hanya itu saja bagian yang dong dapat. ");
INSERT INTO pmy_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Tapi kalo kam mo doa, masuk ke dalam kam pu kamar, tutup pintu baru doa sama kam pu Bapa yang ada di tempat tasembunyi. Deng begitu, kam pu Bapa yang liat apa yang kam bikin deng diam-diam, nanti balas itu sama kam. ");
INSERT INTO pmy_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Trus dalam kam pu doa tu jang putar-putar macam orang yang tra knal Allah. Dong kira kalo deng atur kata banyak-banyak nanti Allah jawab dong pu doa. ");
INSERT INTO pmy_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kam jang sperti dorang, karna kam pu Bapa su tau apa yang kam perlu, seblum kam minta ke Dia. ");
INSERT INTO pmy_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Jadi, harus doa begini, Tong pu Bapa yang di surga, biar Bapa pu nama yang suci dapa kas tinggi. ");
INSERT INTO pmy_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Bapa pu Krajaan datang, apa yang Bapa mau jadi di bumi sama sperti di surga. ");
INSERT INTO pmy_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Kasi tong makanan yang cukup untuk hari ini. ");
INSERT INTO pmy_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Kas ampun tong pu sala, sperti tong juga kas ampun orang yang sala sama kitong. ");
INSERT INTO pmy_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Jang kas biar tong bikin dosa kalo dapa uji, tapi kas slamat tong dari De Yang Jahat. Karna Bapa saja Raja yang pu kuasa, yang pantas dapa puji sampe trada akir. Amin. ");
INSERT INTO pmy_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Kalo kam su kas ampun orang pu sala, nanti kam pu Bapa yang di surga kas ampun kam pu sala juga. ");
INSERT INTO pmy_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Tapi kalo kam tra kas ampun orang lain, kam pu Bapa juga nanti tra kas ampun kam pu sala.” ");
INSERT INTO pmy_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Kalo kam puasa, kam pu muka jang kentara loyo macam biasa orang yang pura-pura baik dong bikin. Dong sengaja tra urus diri supaya orang liat kalo dong ada puasa. Yang Sa bilang ini benar: Hanya bagian itu saja yang dong dapat. ");
INSERT INTO pmy_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Tapi waktu kam puasa, cuci kam pu muka trus sisir rambut, ");
INSERT INTO pmy_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","supaya trada orang yang tau kalo kam ada puasa, tapi hanya kam pu Bapa yang ada di tempat tasembunyi. Deng begitu, kam pu Bapa yang liat apa yang kam bikin deng diam-diam, nanti balas itu sama kam.” ");
INSERT INTO pmy_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Kam jang kumpul harta di bumi; di bumi kakarlak deng karat bisa bikin rusak baru pencuri bisa bongkar deng curi ko pu harta. ");
INSERT INTO pmy_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Lebi baik kumpul kam pu harta di surga; di surga kakarlak deng karat tra bisa bikin rusak baru pencuri tra bisa bongkar deng curi ko pu harta. ");
INSERT INTO pmy_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Karna ko pu harta ada dimana, ko pu hati juga ada disitu. ");
INSERT INTO pmy_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ko pu mata itu plita untuk ko pu diri. Kalo ko pu mata trang, ko pu diri juga trang. ");
INSERT INTO pmy_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Tapi kalo ko pu mata glap, ko pu diri juga glap. Jadi, kalo trang yang ada di ko tu jadi glap, de pu glap tu tamba glap skali. ");
INSERT INTO pmy_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Tra bisa satu orang jadi pesuru untuk dua tuan. Karna pasti de lebi sayang tuan yang satu dari yang lain, ato de lebi setia sama tuan yang satu dari yang lain. Tra bisa Allah deng harta jadi kam pu tuan sama-sama.” ");
INSERT INTO pmy_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Itu yang Sa bilang kam, jang kam kuatir deng kam pu hidup, nanti kam makan apa ato minum apa, ato kuatir tentang badan, apa yang nanti kam pake. Hidup tu lebi penting dari makanan, juga badan lebi penting dari pakean to? ");
INSERT INTO pmy_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Liat burung-burung di udara, dong tra tau tanam, tra tau panen, juga tra kumpul makanan dalam tempat simpan makanan. Tapi kam pu Bapa di surga kas makan dorang. Kam lebi penting dari burung-burung itu to? ");
INSERT INTO pmy_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Kalo kam kuatir deng hal-hal itu, apa kam pu kuatir itu bisa kas panjang kam pu umur biar mo sdikit saja? Pasti tra bisa to! ");
INSERT INTO pmy_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Trus knapa kam kuatir tentang pakean? Liat bagemana bunga-bunga liar tumbu disana, yang tra kerja deng tra bikin pakean. ");
INSERT INTO pmy_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Tapi Sa bilang kam, Raja Salomo yang paling kaya saja de tra pake pakean yang bagus macam bunga-bunga liar itu. ");
INSERT INTO pmy_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Jadi kalo rumput yang hari ini de tumbu trus besok dapa buang dalam api saja, Allah tetap bikin de bagus, lebi lagi deng kam pu hidup. Tapi kam ini masi tra percaya? ");
INSERT INTO pmy_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Jadi jang kam kuatir trus bilang, ‘Apa yang nanti tong makan? Apa yang nanti tong minum? Apa yang nanti tong pake?’ ");
INSERT INTO pmy_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Orang-orang yang tra knal Allah yang cari hal-hal sperti itu. Tapi kam pu Bapa yang di surga tau kalo memang kam perlu smua itu. ");
INSERT INTO pmy_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Tapi kam harus cari Allah pu Krajaan dulu trus bikin apa yang Allah mau. Deng begitu, smua itu nanti Allah kasi juga sama kam. ");
INSERT INTO pmy_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Jadi kam jang kuatir tentang kam pu hidup besok. Karna besok ada de pu susa sendiri. Hari ini pu susa cukup untuk hari ini saja.” ");
INSERT INTO pmy_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Jang kam adili orang lain, supaya kam tra dapa adili dari Allah. ");
INSERT INTO pmy_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Karna nanti Allah kas sala kam sama sperti kam kas sala orang lain. Kam pu cara ukur itu yang nanti Allah pake untuk ukur kam. ");
INSERT INTO pmy_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Knapa kam bisa liat ampas kayu dalam kam pu sodara pu mata, baru balok dalam ko pu mata ko tra liat? ");
INSERT INTO pmy_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Bagemana ko bisa bilang ko pu sodara, ‘Mari, biar sa kas kluar ampas kayu dari ko pu mata,’ padahal ada balok di dalam ko pu mata? ");
INSERT INTO pmy_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Kam yang pura-pura baik! Kas kluar dulu balok yang di kam pu mata, baru ko bisa liat jlas untuk kas kluar ampas kayu itu dari ko pu sodara pu mata.” ");
INSERT INTO pmy_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Kam jang kasi barang yang suci ke anjing, trus kam jang lempar kam pu mutiara ke babi, supaya dong jang injak-injak pake dong pu kaki, trus dong balik srang ko.” ");
INSERT INTO pmy_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Minta trus sama Allah supaya kam bisa trima. Cari dari Allah supaya kam bisa dapat. Toki pintu supaya Allah buka kam pintu. ");
INSERT INTO pmy_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Karna orang yang minta, de trima; orang yang cari, de dapat; orang yang toki pintu, untuk de pintu tabuka. ");
INSERT INTO pmy_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Kalo kam pu anak minta roti, tra mungkin kam kasi de batu to? ");
INSERT INTO pmy_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ato kalo de minta ikan, tra mungkin kam kasi de ular bisa to? ");
INSERT INTO pmy_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Jadi kalo kam yang pu sifat jahat saja tau kasi yang baik sama kam pu anana, lebi lagi kam pu Bapa di surga! De pasti kasi apa yang baik untuk sapa saja yang minta.” ");
INSERT INTO pmy_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Bikin apa saja ke orang lain sama sperti yang kam snang orang bikin itu untuk kam. Ini yang hukum Musa deng nabi-nabi pu kitab kas ajar. ");
INSERT INTO pmy_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Masuk dari pintu yang sempit itu, karna pintu yang lebar deng jalan yang luas tu mnuju ke neraka, trus banyak orang yang masuk lewat pintu itu. ");
INSERT INTO pmy_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Tapi pintu yang mnuju ke hidup yang trada akir tu sempit skali, trus de pu jalan kesana tu susa skali, cuma sdikit orang yang ketemu jalan itu.” ");
INSERT INTO pmy_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Kam harus hati-hati sama orang-orang yang pura-pura jadi nabi, yang datang ke kam deng bikin diri baik macam domba, padahal dong tu jahat macam serigala. ");
INSERT INTO pmy_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Dari dong pu bua kam bisa tau dong tu sapa. Bisa ka orang petik bua anggur dari duri yang jalar ato petik bua ara dari rumput duri? ");
INSERT INTO pmy_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Begitu juga deng pohon yang subur kas hasil bua yang bagus, tapi pohon yang tra subur kas hasil bua yang tra bagus. ");
INSERT INTO pmy_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Tra mungkin pohon yang subur kas hasil bua yang tra baik, ato pohon yang tra subur kas hasil bua yang bagus. ");
INSERT INTO pmy_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Trus stiap pohon yang tra kas hasil bua yang bagus, pasti dapa tebang baru dapa buang ke dalam api. ");
INSERT INTO pmy_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Jadi dari dong pu bua kam bisa tau dong tu sapa. ");
INSERT INTO pmy_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Bukan stiap orang yang panggil Saya, ‘Tuhan, Tuhan,’ yang nanti masuk dalam Krajaan Surga, tapi de yang bikin apa yang Sa pu Bapa di surga mau. ");
INSERT INTO pmy_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Di hari yang trakir ada orang banyak yang bilang ke Saya, ‘Tuhan, Tuhan, tong jadi nabi pake Ko pu nama, deng usir setan pake Ko pu nama, baru bikin tanda luar biasa pake Ko pu nama juga to?’ ");
INSERT INTO pmy_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pas waktu itu suda nanti Sa bicara trus trang ke dong baru bilang, ‘Sa tra perna knal kam! Pigi dari sini, kam smua yang bikin jahat!’ ” ");
INSERT INTO pmy_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Stiap orang yang dengar trus bikin apa yang Sa bilang ni, de sperti orang yang pu cara pikir paling baik, yang mo bangun de pu ruma di atas batu fondasi. ");
INSERT INTO pmy_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Waktu hujan turun baru banjir datang, trus angin kencang hantam ruma itu, ruma itu tra rubu karna orang bangun di atas batu fondasi. ");
INSERT INTO pmy_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Mala stiap orang yang dengar Sa pu kata-kata tapi habis itu de tra bikin, de sperti orang yang pu cara pikir kurang baik, yang bikin de pu ruma di atas pasir saja. ");
INSERT INTO pmy_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Waktu hujan turun baru banjir datang, trus angin kencang hantam ruma itu, langsung ruma itu rata deng tana trus hancur skali.” ");
INSERT INTO pmy_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Trus habis Yesus slesai bicara itu smua, orang banyak itu heran dengar apa yang De kas ajar, ");
INSERT INTO pmy_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","karna De kas ajar dong deng kuasa, tra sperti dong pu guru-guru agama. ");
INSERT INTO pmy_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Habis Yesus turun dari bukit, ada rombongan orang banyak yang ikut Dia. ");
INSERT INTO pmy_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Begini ada satu orang yang sakit kulit busuk datang baru de tunduk depan Yesus pu kaki, trus bilang, “Tuhan, kalo Tuhan mau, Tuhan pasti bisa kas sembu saya.” ");
INSERT INTO pmy_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Trus Yesus kas tangan pegang orang itu deng bilang, “Sa mau, ko sembu suda.” Waktu itu juga orang itu sembu dari de pu sakit kulit busuk. ");
INSERT INTO pmy_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Trus Yesus bilang, “Ingat e, jang kastau ke sapa-sapa. Tapi pigi, kas liat ko pu diri ke imam, trus kasi persembahan yang Musa de printa, itu jadi bukti ke dorang.” ");
INSERT INTO pmy_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Waktu Yesus masuk ke Kapernaum, perwira satu datang ketemu Yesus baru minta tolong deng sunggu-sunggu ke Yesus, ");
INSERT INTO pmy_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Bapa, sa pu pesuru ada sakit di ruma, de mendrita skali baru de tra bisa bikin apapa karna de lumpu.” ");
INSERT INTO pmy_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesus bilang, “Sa mo pigi kas sembu dia.” ");
INSERT INTO pmy_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Tapi perwira itu de jawab, “Bapa, sa ni tra pantas trima Bapa di sa pu ruma, bicara satu kata saja, pasti sa pu pesuru sembu. ");
INSERT INTO pmy_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Sa tau, karna sa juga ikut printa dari orang yang di atas saya, trus di bawa sa juga ada prajurit. Kalo sa suru prajurit satu, ʻPigi!ʼ pasti de pigi, trus sa printa yang lain, ʻMari sini!ʼ pasti de datang, trus kalo sa kas printa sa pu pesuru, ʻBikin ini!ʼ pasti de bikin yang sa suru.” ");
INSERT INTO pmy_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Dengar begitu, Yesus heran trus bicara ke dong yang ikut Dia, “Yang Sa bilang ini benar: Sa blum perna ketemu orang yang percaya skali sperti ini, biar mo itu di tenga orang Israel. ");
INSERT INTO pmy_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Sa bilang kam, nanti banyak orang datang dari timur deng barat, untuk duduk makan sama-sama deng Abraham, Ishak, deng Yakub dalam Krajaan Surga. ");
INSERT INTO pmy_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Tapi orang-orang Yahudi yang harus jadi Allah pu orang-orang di De pu Krajaan, nanti dapa buang ke dalam tempat yang paling glap. Disana tu tempat orang mnangis sedi skali sampe gigi bunyi.” ");
INSERT INTO pmy_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Trus Yesus balik bicara ke perwira itu begini, “Bapa pulang suda, yang bapa percaya itu su jadi.” Waktu itu juga de pu pesuru itu langsung sembu. ");
INSERT INTO pmy_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Habis itu Yesus pigi ke Petrus pu ruma, disitu Yesus liat Petrus pu mama mantu ada tidur karna panas tinggi. ");
INSERT INTO pmy_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jadi Yesus pegang mama itu pu tangan, langsung de pu panas tinggi hilang. Langsung mama itu bangun trus kas siap makanan untuk Yesus dorang. ");
INSERT INTO pmy_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Pas su mo malam begini, dong bawa orang banyak yang krasukan setan ke Yesus, trus Yesus usir setan-setan itu deng satu kata saja. Trus De kas sembu smua orang yang sakit. ");
INSERT INTO pmy_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Begitu supaya Allah pu kata-kata lewat Nabi Yesaya dulu tu su jadi, de bilang, “De yang kas hilang tong pu sakit deng yang kas lepas tong yang mendrita cacat.” ");
INSERT INTO pmy_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Waktu Yesus liat ada orang banyak di dekat Dia, De suru murid-murid pigi deng prahu ke sebla. ");
INSERT INTO pmy_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Begini guru agama satu datang baru bilang, “Sa mo ikut Bapa guru, kemana saja Bapa mo pigi.” ");
INSERT INTO pmy_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesus bilang ke dia, “Serigala ada tempat untuk tinggal, burung juga ada sarang. Tapi Sa Anak Manusia trada tempat untuk taru kepala.” ");
INSERT INTO pmy_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Begini De pu pengikut satu yang lain bilang, “Bapa, kas ijin sa pulang urus sa pu bapa sampe sa pu bapa mati dulu.” ");
INSERT INTO pmy_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Tapi Yesus bilang sama dia, “Kas biar orang mati kubur orang mati. Kalo ko, ikut Sa saja.” ");
INSERT INTO pmy_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Habis itu Yesus naik prahu trus De pu murid-murid juga ikut Dia. ");
INSERT INTO pmy_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Begini, tiba-tiba angin kencang skali muncul di danau itu. Ombak hantam prahu sampe hampir tenggelam, tapi Yesus ada tidur. ");
INSERT INTO pmy_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Trus murid-murid datang kas bangun Dia, dong bilang, “Tuhan, tolong, tong mo mati tenggelam!” ");
INSERT INTO pmy_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Trus Yesus bilang sama dorang, “Knapa kam takut skali? Kam kurang percaya Saya!” Trus Yesus bediri baru suru angin deng danau itu tenang, begini danau tu jadi tedu skali. ");
INSERT INTO pmy_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Yesus pu murid-murid heran baru baku tanya, “De ni orang macam apa ka, sampe angin deng danau juga ikut yang De bilang?” ");
INSERT INTO pmy_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Waktu Yesus sampe di sebla, di orang Gadara pu tempat, ada dua orang yang krasukan setan datang dari goa-goa kubur baru ketemu Yesus. Dong dua jahat skali, sampe trada orang yang brani lewat jalan itu. ");
INSERT INTO pmy_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Begini dong batariak, “Ko mo bikin apa deng kitong, Allah pu Anak? Ko datang kesini untuk siksa tong seblum de pu waktu ka?” ");
INSERT INTO pmy_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Tra jau dari situ ada babi-babi banyak yang cari makan. ");
INSERT INTO pmy_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Trus setan-setan itu mohon sama Yesus, “Kalo Ko usir tong kluar dari orang-orang ini, suru tong pinda saja ke babi-babi itu ka.” ");
INSERT INTO pmy_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesus bicara sama dorang, “Pigi suda!” Trus dong kluar dari dua orang itu baru masuk ke dalam babi-babi. Rombongan babi itu lari ke jurang masuk ke dalam danau trus mati di dalam air. ");
INSERT INTO pmy_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Orang-orang yang jaga babi-babi itu langsung lari. Waktu dong sampe di kota, dong crita smua yang su jadi itu, juga tentang orang-orang yang krasukan setan itu. ");
INSERT INTO pmy_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Smua orang di kota itu kluar untuk ketemu Yesus. Trus pas ketemu deng Dia, dong minta deng sunggu-sunggu supaya De pigi kas tinggal dong pu daera. ");
INSERT INTO pmy_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Habis itu, Yesus naik ke dalam prahu trus pigi ke sebla, trus de sampe di kota yang De ada tinggal. ");
INSERT INTO pmy_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Begini orang dong bawa ke Yesus orang lumpu satu yang ada tidur di tikar. Waktu Yesus liat dong percaya skali, De bilang sama orang lumpu itu, “Anak, kas kuat ko pu hati, ko pu dosa-dosa su dapa kas ampun.” ");
INSERT INTO pmy_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Dengar begitu, guru-guru agama brapa orang bicara dalam hati, “Orang ini hina Allah!” ");
INSERT INTO pmy_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Tapi Yesus su tau apa yang dong pikir jadi De bilang, “Knapa kam pikir hal-hal yang jahat dalam kam pu hati? ");
INSERT INTO pmy_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Kam pikir lebi gampang bilang, ‘Ko pu dosa-dosa su dapa kas ampun,’ ato bilang, ‘Bediri deng jalan suda’? ");
INSERT INTO pmy_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Tapi, supaya kam tau kalo di dunia ini Sa Anak Manusia pu kuasa kas ampun dosa, liat ini!” Trus Yesus bilang sama orang lumpu itu, “Bediri, angkat ko pu tikar trus pulang ke ko pu ruma!” ");
INSERT INTO pmy_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Orang itu langsung bediri trus pulang. ");
INSERT INTO pmy_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Waktu orang banyak liat apa yang su jadi, dong takut trus puji Allah yang su kasi kuasa yang sperti begitu ke manusia. ");
INSERT INTO pmy_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Trus waktu Yesus jalan lewat situ, De liat satu orang tukang tagi pajak, de pu nama Matius, de ada duduk di tempat tagi pajak, trus Yesus bilang ke dia, “Mari, ko ikut Saya.” Dengar begitu, Matius de bediri trus ikut Dia. ");
INSERT INTO pmy_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Trus waktu Yesus ada makan di Matius pu ruma, banyak tukang tagi pajak deng orang-orang yang bikin dosa yang datang makan sama-sama Yesus deng De pu murid-murid. ");
INSERT INTO pmy_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Waktu orang Farisi liat begitu, dong bilang sama Yesus pu murid-murid, “Ih, bisa eh, kam pu guru duduk makan sama-sama deng tukang tagi pajak deng orang-orang yang bikin dosa?” ");
INSERT INTO pmy_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesus dengar yang dong bicara, trus De bilang, “Bukan orang sehat yang perlu dokter tapi orang sakit. ");
INSERT INTO pmy_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Jadi pigi cari tau Allah pu kata-kata ini pu arti, ‘Yang Sa mau tu, kam kas tunjuk kam pu rasa kasian ke orang lain, daripada kam kas korban binatang.’ Karna Sa tra datang untuk panggil orang yang rasa diri benar, tapi untuk panggil orang yang bikin dosa.” ");
INSERT INTO pmy_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Begini, Yohanes pu murid-murid dong datang baru bilang ke Yesus, “Knapa tong deng orang Farisi biasa puasa tapi Bapa pu murid-murid tidak?” ");
INSERT INTO pmy_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesus jawab dong begini, “Bisa ka, kalo pengantin laki-laki pu teman-teman rasa hati sedi skali waktu pengantin itu ada sama-sama deng dorang? Tapi nanti ada de pu waktu untuk pengantin itu dapa ambil dari dorang, pas waktu itu baru dong puasa. ");
INSERT INTO pmy_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Trada orang yang tempel kain spanggal yang baru di baju lama to? Karna kalo bikin begitu, kain yang baru itu nanti bikin robek baju itu, trus de pu robek tamba besar lagi. ");
INSERT INTO pmy_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Begitu juga trada orang yang isi air anggur yang baru ke dalam kantong kulit yang lama. Karna kalo bikin begitu, nanti air anggur yang baru itu bikin robek kantong itu jadi air anggur itu tabuang, trus nanti kantong itu rusak. Jadi air anggur yang baru tu orang harus simpan di dalam kantong kulit yang baru juga, supaya dua-dua tetap aman.” ");
INSERT INTO pmy_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Waktu Yesus masi bicara deng dorang, begini ada satu orang yang datang, de ni kepala tempat ibada. De tunduk depan Yesus baru bilang, “Sa pu anak prempuan baru saja mati, tapi Bapa datang baru taru tangan di de ka, pasti de bisa hidup kembali.” ");
INSERT INTO pmy_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Trus Yesus bediri trus ikut orang itu, De pu murid-murid juga ikut. ");
INSERT INTO pmy_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Waktu itu, ada prempuan satu yang su 12 taun sakit pendarahan, de pigi ke dekat Yesus dari blakang baru kore Yesus pu ujung baju panjang. ");
INSERT INTO pmy_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Karna de pikir, “Sa pasti sembu kalo sa kore De pu baju saja.” ");
INSERT INTO pmy_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Tapi Yesus balik liat de baru bilang, “Anak, ko pu hati harus kuat, karna ko percaya Saya, ko sembu.” Jam itu juga langsung prempuan itu sembu. ");
INSERT INTO pmy_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Waktu Yesus sampe di kepala tempat ibada itu pu ruma, De liat ada orang-orang yang tiup suling deng ada orang banyak yang mnangis-mnangis. ");
INSERT INTO pmy_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jadi De bicara sama dorang, “Kam kluar suda, karna anak ini tra mati de cuma tidur saja.” Tapi smua orang bicara ejek Dia. ");
INSERT INTO pmy_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Habis dong kas kluar orang banyak itu, Yesus masuk pegang anak itu pu tangan, trus anak itu langsung hidup. ");
INSERT INTO pmy_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Crita ini tasebar sampe ke smua daera disitu. ");
INSERT INTO pmy_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Waktu Yesus lanjut jalan lagi, begini ada dua orang buta yang ikut Dia baru batariak-batariak begini, “Daud pu turunan, kasian tong ka!” ");
INSERT INTO pmy_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Waktu Yesus masuk ke dalam ruma, dua orang buta itu datang ke Dia. Trus Yesus bicara sama dorang, “Kam percaya ka, kalo Sa bisa bikin kam sembu?” Dong jawab, “Iyo Bapa, tong percaya.” ");
INSERT INTO pmy_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Trus De pegang dong pu mata deng bilang, “Biar jadi sama sperti yang kam percaya.” ");
INSERT INTO pmy_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Langsung dong bisa liat. Trus Yesus deng tegas pesan ke dorang, “Jang sampe ada orang lain tau tentang hal ini.” ");
INSERT INTO pmy_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Tapi habis dong dua pigi dari situ, langsung dong dua crita tentang Yesus ke smua daera itu. ");
INSERT INTO pmy_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Pas waktu dua orang buta itu kluar, dong bawa orang bisu yang krasukan setan ke Yesus. ");
INSERT INTO pmy_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Habis Yesus usir setan itu, langsung orang itu bisa bicara lagi. Baru orang banyak dong heran baru bilang, “Yang sperti begini tra perna jadi di Israel.” ");
INSERT INTO pmy_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Tapi orang Farisi bilang, “De usir setan pake kuasa dari setan pu bos.” ");
INSERT INTO pmy_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesus jalan kliling smua kota deng kampung-kampung. De ajar di dong pu tempat-tempat ibada, deng kastau Brita Baik tentang Krajaan Surga, trus kas sembu orang-orang yang mendrita macam-macam sakit deng cacat. ");
INSERT INTO pmy_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Waktu Yesus liat orang banyak itu, De rasa kasian skali sama dorang, karna dong rasa susa baru trada yang peduli deng dong macam domba yang tra pu gembala. ");
INSERT INTO pmy_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Trus De bilang sama De pu murid-murid, “Bua yang siap panen ada banyak. Tapi sdikit orang yang mo panen itu. ");
INSERT INTO pmy_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Jadi minta ke Bapa yang punya itu smua, untuk kirim orang-orang yang kerja panen itu.” ");
INSERT INTO pmy_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Satu hari begini, Yesus panggil De pu duablas murid baru kasi dong kuasa untuk usir setan-setan deng kas sembu smua penyakit deng orang yang cacat. ");
INSERT INTO pmy_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ini duablas utusan itu pu nama-nama. Pertama Simon yang dapa sebut Petrus deng de pu ade Andreas, trus Yakobus deng de pu sodara Yohanes, dong dua ni Zebedeus pu anana, ");
INSERT INTO pmy_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipus deng Bartolomeus, Tomas, Matius yang dulu tukang tagi pajak, Yakobus bapa Alfeus pu anak, Tadeus, ");
INSERT INTO pmy_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon dari klompok orang Zelot, deng Yudas Iskariot yang jual Yesus. ");
INSERT INTO pmy_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Duablas murid itu dapa utus dari Yesus deng De kas pesan ke dong begini, “Kam jang pigi ke orang-orang yang bukan Yahudi pu daera, ato masuk ke orang Samaria pu kota-kota, ");
INSERT INTO pmy_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","tapi pigi ke orang-orang Israel yang sperti domba-domba yang sesat. ");
INSERT INTO pmy_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Pigi baru kastau ke orang-orang, ‘Krajaan Surga su dekat.’ ");
INSERT INTO pmy_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Kas sembu orang sakit, kas hidup orang mati, kas sembu orang yang sakit kulit busuk, usir setan-setan. Kam su trima deng cuma-cuma, itu jadi kasi juga deng cuma-cuma. ");
INSERT INTO pmy_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Jang bawa uang emas ato perak ato tembaga dalam kam pu ikat pinggang. ");
INSERT INTO pmy_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Jang kam bawa tas waktu di jalan, jang kam bawa pakean ganti, sendal ato tongkat, karna orang yang kerja de pantas trima de pu bagian. ");
INSERT INTO pmy_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Kalo kam masuk di kota ato kampung satu, cari satu orang disitu yang mo trima kam, baru tinggal di de pu ruma saja sampe kam kas tinggal kota itu. ");
INSERT INTO pmy_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Waktu kam masuk di orang itu pu ruma, kam harus kasi salam damai ke dorang. ");
INSERT INTO pmy_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kalo dong trima kam deng baik, biar kam pu damai itu turun untuk orang-orang di ruma itu. Tapi kalo trada, kam pu damai tu kembali sama kam. ");
INSERT INTO pmy_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Trus kalo trada satu orang juga yang mo trima kam deng dengar apa yang kam bicara, kluar deng kas tinggal ruma ato kota itu baru kas bersi debu dari kam pu kaki. ");
INSERT INTO pmy_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Yang Sa bilang ini benar: Di hari hukuman trakir, Kota Sodom deng Gomora nanti dapa hukum lebi ringan dari kota itu.” ");
INSERT INTO pmy_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Dengar ni, Sa utus kam sperti domba ke tenga-tenga serigala, itu jadi kam harus pintar sperti ular, deng hati bersi sperti merpati. ");
INSERT INTO pmy_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Tapi hati-hati sama smua orang, karna ada yang mo kasi kam ke sidang-sidang agama trus nanti dong cambuk kam di dong pu tempat ibada. ");
INSERT INTO pmy_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Trus karna kam jadi Sa pu pengikut, nanti kam dapa bawa ke depan pemimpin-pemimpin deng raja-raja supaya kam bisa kastau tentang Sa ke dong deng orang-orang yang bukan Yahudi. ");
INSERT INTO pmy_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Waktu dong kasi kam ke sidang, kam jang takut tentang bagemana deng apa yang harus kam bicara, karna nanti Roh Allah kastau apa yang harus kam bicara pas waktu itu. ");
INSERT INTO pmy_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Karna itu bukan kam yang bicara, tapi kam pu Bapa pu Roh, De yang nanti bicara lewat kam. ");
INSERT INTO pmy_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Nanti ada orang yang kasi de pu sodara sendiri untuk dapa bunu, begitu juga deng bapa sama de pu anak. Anana nanti mlawan dong pu orang tua, trus kasi dong pu orang tua untuk dapa bunu. ");
INSERT INTO pmy_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Trus nanti smua orang tra suka kam skali karna kam ikut Saya, tapi orang yang tahan sampe trakir pasti slamat. ");
INSERT INTO pmy_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kalo dalam kota satu dong siksa kam, lari ke kota yang lain. Yang Sa bilang ini benar: Seblum kam slesai pigi ke smua kota di Israel, Sa Anak Manusia su datang. ");
INSERT INTO pmy_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Karna trada murid yang bisa lebi dari de pu guru, ato satu pesuru yang bisa lebi dari de pu tuan. ");
INSERT INTO pmy_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Su cukup untuk murid kalo de su sperti de pu guru, trus untuk pesuru kalo de su sama deng de pu tuan. Jadi kalo Sa sperti tuan ruma dapa sebut Beelzebul, lebi lagi kam yang sperti Sa pu satu ruma. ");
INSERT INTO pmy_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Jadi jang kam takut deng dorang, karna trada rahasia yang nanti tra dapa buka, juga trada yang tasembunyi yang nanti tra dapa liat. ");
INSERT INTO pmy_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Apa yang Sa bilang ke kam dalam glap, bilang itu di dalam trang, juga apa yang Sa bisik di tlinga, kastau itu dari atas ruma. ");
INSERT INTO pmy_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Trus jang kam takut sama dong yang cuma bunu kam pu badan tapi tra pu kuasa untuk bunu kam pu roh, kam harus takut sama Tuhan yang pu kuasa untuk kas hancur kam pu roh deng badan juga di dalam neraka. ");
INSERT INTO pmy_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Coba kam pikir, burung pipit dua ekor orang jual deng harga satu uang koin. Biar begitu tapi satu ekor juga trakan jatu karna mati kalo kam pu Bapa tra kas ijin. ");
INSERT INTO pmy_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Sampe rambut di kam pu kepala Tuhan su tau de pu jumla. ");
INSERT INTO pmy_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Jadi kam jang takut, karna kam jau lebi penting dari banyak burung pipit itu. ");
INSERT INTO pmy_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Sapa yang mngaku knal Sa di depan orang-orang, nanti Sa juga mngaku knal de di depan Sa pu Bapa di surga. ");
INSERT INTO pmy_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Juga sapa yang pura-pura tra knal Sa di depan orang-orang, nanti Sa juga bilang tra knal de di depan Sa pu Bapa di surga.” ");
INSERT INTO pmy_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Kam jang kira kalo Sa datang untuk bikin damei di bumi, Sa datang bukan untuk orang baku damei, tapi untuk orang baku lawan. ");
INSERT INTO pmy_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Karna Sa datang untuk anak laki-laki lawan de pu bapa, anak prempuan lawan de pu mama, mantu prempuan lawan de pu mama mantu. ");
INSERT INTO pmy_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Trus yang nanti jadi orang pu musu besar tu de pu kluarga sendiri. ");
INSERT INTO pmy_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Sapa saja yang sayang de pu bapa ato mama lebi dari de sayang Saya, de tra pantas untuk Saya. Trus sapa saja yang sayang de pu anak laki-laki ato prempuan lebi dari de sayang Saya, de tra pantas untuk Saya. ");
INSERT INTO pmy_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Sapa saja yang tra pikul de pu salib trus ikut Saya, orang itu tra pantas untuk Saya. ");
INSERT INTO pmy_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Sapa saja yang kas slamat de pu hidup, de trakan dapat hidup yang trada akir. Tapi orang yang kasi de pu hidup untuk Saya, de pasti dapat hidup yang trada akir. ");
INSERT INTO pmy_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Sapa saja yang trima kam, itu de trima Saya, trus sapa saja yang trima Saya, itu de trima De yang su utus Saya. ");
INSERT INTO pmy_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Sapa saja yang trima satu orang karna de tau orang itu nabi, nanti de trima sama sperti nabi pu bagian. Trus sapa saja yang trima satu orang karna de tau orang itu orang benar, nanti de trima sama sperti orang benar pu bagian. ");
INSERT INTO pmy_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Trus Yang Sa bilang ini benar: Sapa saja yang trima satu orang yang tra penting ini karna de tau orang itu Sa pu pengikut, Allah pasti kasi de pu bagian, biar de cuma kasi air dingin satu glas saja.” ");
INSERT INTO pmy_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Habis Yesus slesai kas ajar ke De pu duablas murid, De pigi dari sana untuk kas ajar deng kastau Brita Baik di kota-kota di daera itu. ");
INSERT INTO pmy_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Di dalam penjara Yohanes dengar smua tentang Raja Yang Allah Pili De su bikin, ");
INSERT INTO pmy_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","trus de suru de pu murid-murid pigi tanya ke Yesus, “Bapa ni Orang yang mo datang sperti Allah pu janji ka ato tong harus tunggu orang lain?” ");
INSERT INTO pmy_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesus jawab dorang, “Kembali sama Yohanes trus kastau apa yang kam dengar deng liat. ");
INSERT INTO pmy_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Orang buta bisa liat, orang yang tra bisa jalan su bisa jalan, orang yang sakit kulit busuk bisa sembu, orang tuli bisa dengar, orang mati hidup kembali, orang yang trada apapa dong dengar Brita Baik dari Allah. ");
INSERT INTO pmy_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Orang yang tra tolak Saya, dong untung skali.” ");
INSERT INTO pmy_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Habis Yohanes de pu murid-murid dong pigi, Yesus mulai bicara lagi begini sama orang banyak tentang Yohanes, “Waktu kam pigi ke Yohanes Tukang Baptis di tempat sepi yang kring, kam mo liat apa? Kam mo pigi liat rumput yang goyang karna angin ka? ");
INSERT INTO pmy_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Kalo trada, kam pigi mo liat apa? Kam pigi kesana mo liat orang deng pakean bagus ka? Orang yang pu pakean bagus itu tinggal di istana. ");
INSERT INTO pmy_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Jadi untuk apa kam pigi kesana? Untuk mo liat nabi ka? Betul. Sa kastau kam, de ni lebi dari nabi-nabi lain. ");
INSERT INTO pmy_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Karna ada tatulis tentang de begini, ‘Liat! Sa suru Sa pu utusan duluan Ko, de nanti kas siap Ko pu jalan di depan Ko.’ ");
INSERT INTO pmy_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Yang Sa bilang ini benar: Dari antara dong yang lahir dari prempuan, tra perna ada orang yang lebi besar dari Yohanes Tukang Baptis. Tapi orang yang renda skali dalam Krajaan Surga, de lebi besar dari Yohanes. ");
INSERT INTO pmy_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Mulai waktu Yohanes Tukang Baptis de muncul sampe skarang, ada orang yang mo coba rampas Krajaan Surga deng srang Tuhan pu orang-orang. ");
INSERT INTO pmy_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Karna seblum Yohanes de muncul, nabi-nabi smua deng hukum Musa su kastau tentang apa yang mo jadi skarang. ");
INSERT INTO pmy_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Yohanes tu Elia yang datang kembali sperti yang nabi-nabi perna kastau, kalo kam bisa trima ini. ");
INSERT INTO pmy_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Sapa yang pu tlinga, de harus dengar baik-baik! ");
INSERT INTO pmy_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Macam apa eh Sa mo kas conto orang-orang jaman ini? Dong sperti dua klompok anana yang duduk di pasar, klompok satu bilang sama klompok lain, ");
INSERT INTO pmy_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Tong su toki tifa supaya kam mnari, tapi kam tra mnari. Tong su mnyanyi lagu sedi, tapi kam tra sedi.’ ");
INSERT INTO pmy_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Kam sperti itu, karna Yohanes datang, de biasa puasa, trus kam bilang, ‘De krasukan setan!’ ");
INSERT INTO pmy_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Sa Anak Manusia, makan deng minum, trus kam bilang, ‘Liat orang itu! De rakus, tukang mabuk, De kawan deng orang yang bikin dosa sama tukang tagi pajak.’ Tapi Allah pu cara pikir yang paling baik dapa kas bukti yang benar lewat orang yang ikut Dia.” ");
INSERT INTO pmy_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Trus Yesus mulai tegur kota-kota yang tra mau tobat dari dong pu dosa-dosa, padahal di kota-kota itu Yesus paling banyak bikin De pu tanda-tanda luar biasa. ");
INSERT INTO pmy_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Yesus bilang lagi, “Claka skali orang-orang di Kota Korazim deng Kota Betsaida! Karna kalo di Kota Tirus deng Sidon tanda-tanda luar biasa jadi sperti yang su jadi di tenga-tenga kam, pasti orang-orang disana langsung dong pake pakean duka deng duduk di atas abu. Itu karna dong rasa sala deng dong pu dosa-dosa. ");
INSERT INTO pmy_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Tapi Sa bilang kam, di hari hukuman trakir, orang-orang jahat di dua kota itu nanti dapa hukum lebi ringan dari kam. ");
INSERT INTO pmy_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Juga orang-orang di Kapernaum! Kam pikir nanti kam dapa kas naik sampe ke surga? Trakan! Kam nanti dapa buang ke neraka! Karna kalo di Sodom tanda-tanda luar biasa itu jadi sperti yang su jadi di tenga-tenga kam, pasti kota itu masi bediri sampe hari ini. ");
INSERT INTO pmy_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Tapi Sa bilang kam, di hari hukuman trakir, Kota Sodom nanti dapa hukum lebi ringan dari kam.” ");
INSERT INTO pmy_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Waktu itu Yesus doa begini, “Sa kas naik syukur sama Bapa, Tuhan yang punya langit deng bumi! Karna smua tentang Allah printa jadi Raja, Bapa kas tunjuk itu untuk orang-orang biasa, tapi Bapa kas rahasia dari orang-orang yang pu ilmu deng orang yang pintar, ");
INSERT INTO pmy_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","sperti itu yang Bapa snang. ");
INSERT INTO pmy_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Smua-smua Bapa su kas percaya sama Saya. Trada orang yang knal Anak, cuma Bapa. Trus trada yang knal Bapa, cuma Anak deng orang yang Anak De pili untuk kastau tentang Bapa.” ");
INSERT INTO pmy_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Baru Yesus bilang, “Mari suda, datang ke Saya kam smua yang cape deng yang pu beban yang brat, nanti Sa bikin kam pu hati tenang. ");
INSERT INTO pmy_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ikut Sa pu printa deng blajar dari Saya. Karna Sa pu hati baik baru Sa ni renda hati, nanti kam pu hati jadi tenang. ");
INSERT INTO pmy_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Karna ajaran yang Sa kasi tu tra susa, trus printa yang sa kasi sama kam tu ringan.” ");
INSERT INTO pmy_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Satu kali begini, waktu orang Yahudi pu hari Sabat, Yesus deng De pu murid-murid jalan di kebun gandum. Karna lapar, De pu murid-murid petik biji-biji gandum trus makan de pu isi. ");
INSERT INTO pmy_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Liat begitu, orang-orang Farisi bilang ke Yesus, “Liat tu, Bapa pu murid-murid bikin apa yang hukum Musa larang orang bikin di tong pu hari Sabat.” ");
INSERT INTO pmy_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Tapi Yesus jawab dorang, “Kam tra perna baca yang Daud bikin ka, waktu de sama orang-orang yang ikut dia, dong lapar? ");
INSERT INTO pmy_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Bagemana de masuk ke dalam Ruma Allah trus bagemana dong makan roti yang su kasi sama Allah? Roti ini orang tra bole makan, mo untuk de ka untuk dong yang ikut de juga tra bole, hanya imam-imam saja yang bisa makan itu. ");
INSERT INTO pmy_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ato kam tra perna baca di hukum Musa ka, yang tentang imam-imam potong binatang di dalam Ruma Allah pas di hari Sabat? Tapi Allah tra anggap dong bikin sala to? ");
INSERT INTO pmy_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Sa bilang kam, disini ada Orang yang lebi penting dari Ruma Allah. ");
INSERT INTO pmy_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kalo memang kam mngerti Allah pu kata-kata ini pu maksud, ‘Yang Sa mau tu, kam kas tunjuk kam pu rasa kasian ke orang lain, daripada kam kas korban binatang,’ pasti kam trakan bilang kalo orang yang tra sala tu de su bikin sala. ");
INSERT INTO pmy_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Karna Sa Anak Manusia pu kuasa atas hari Sabat.” ");
INSERT INTO pmy_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Habis pigi dari sana, Yesus masuk ke dong pu tempat ibada. ");
INSERT INTO pmy_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Disitu ada orang satu yang de pu tangan sebla mati. Trus dong tanya sama Yesus, “Bisa kas sembu orang pas hari Sabat ka?” Dong pu maksud supaya bisa kas sala Dia. ");
INSERT INTO pmy_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Tapi Yesus bilang sama dorang, “Kalo dari kam ada satu orang yang piara domba satu, baru domba itu jatu dalam lobang pas hari Sabat, pasti de usaha tarik kas kluar domba itu to? ");
INSERT INTO pmy_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Manusia pasti lebi penting dari domba itu to? Brarti tong bisa buat baik pas hari Sabat.” ");
INSERT INTO pmy_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Trus Yesus bilang ke orang itu, “Kas lurus ko pu tangan!” Trus de kas lurus de pu tangan, langsung de pu tangan itu sembu, trus jadi sehat sperti de pu tangan yang sebla. ");
INSERT INTO pmy_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Trus orang-orang Farisi dong kluar baru atur rencana untuk bunu Yesus. ");
INSERT INTO pmy_vpl VALUES ("MT12_15a","070_12_15a","MAT","12","15a","15a","Tapi Yesus su tau dong pu maksud jadi De pigi dari sana. ");
INSERT INTO pmy_vpl VALUES ("MT12_15b","070_12_15b","MAT","12","15b","15b","Ada orang banyak yang ikut Yesus baru De kas sembu dong smua yang sakit. ");
INSERT INTO pmy_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","De larang dong deng kras untuk tra bole kastau De tu sapa, ");
INSERT INTO pmy_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","supaya Allah pu kata-kata dulu lewat Nabi Yesaya tu su jadi, ");
INSERT INTO pmy_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Liat, ini ni Sa pu Pesuru yang Sa pili, yang Sa sayang, De yang bikin Sa pu hati snang. Nanti Sa kuasai Dia deng Sa pu Roh, trus De kastau ke bangsa-bangsa kalo nanti Sa mo adili deng cara yang adil. ");
INSERT INTO pmy_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","De trakan baku mara deng trakan batariak, trus orang trakan dengar De pu suara di jalan-jalan. ");
INSERT INTO pmy_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Sama sperti De trakan kas putus bulu yang pata, trus De trakan kas mati plita yang hampir padam. De pasti usaha sampe adili deng cara adil itu menang. ");
INSERT INTO pmy_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Trus hanya sama De saja nanti bangsa-bangsa taru dong pu harap.” ");
INSERT INTO pmy_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Habis itu dong bawa satu orang ke Yesus, orang yang krasukan setan. Orang itu de tra bisa liat deng bisu, trus Yesus kas sembu dia, jadi de bisa bicara deng liat lagi. ");
INSERT INTO pmy_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Jadi orang banyak itu heran skali deng bilang, “Mungkin De ini suda yang Daud pu Anak.” ");
INSERT INTO pmy_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Tapi waktu orang Farisi dengar tentang itu, dong bilang, “De usir setan pake kuasa Beelzebul, setan pu bos.” ");
INSERT INTO pmy_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Tapi Yesus tau apa yang dong pikir jadi De bilang ke dong, “Stiap negara yang baku musu, pasti hancur. Trus stiap kota ato kluarga yang baku musu, pasti tra bisa tahan lama. ");
INSERT INTO pmy_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Sama juga kalo Iblis usir Iblis, dong juga baku lawan deng dong sendiri, bagemana krajaan itu bisa tahan? ");
INSERT INTO pmy_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Kalo betul Sa usir setan pake Beelzebul pu kuasa, kam pu murid-murid usir setan-setan itu pake sapa pu kuasa? Jadi biar kam pu murid-murid yang kas tunjuk apa yang kam tudu tu sala! ");
INSERT INTO pmy_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Tapi Sa usir setan pake Roh Allah pu kuasa, trus ini kas bukti kalo Allah pu Krajaan su datang ke kam. ");
INSERT INTO pmy_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ato bagemana orang bisa masuk ke orang yang kuat pu ruma untuk rampas de pu harta, kalo de blum ikat orang yang kuat itu dulu? Habis itu baru de bisa rampas orang itu pu harta smua. ");
INSERT INTO pmy_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Orang yang tra sama-sama Saya, su jlas de lawan Saya. Trus orang yang tra mo kerja untuk Saya, su jlas de kas rusak Sa pu kerja. ");
INSERT INTO pmy_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Sa bilang kam, orang yang bikin dosa deng hina-hina orang lain, nanti bisa dapa kas ampun. Tapi kalo hina Roh Allah, de trakan dapa kas ampun. ");
INSERT INTO pmy_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kalo orang bilang satu hal yang mlawan Sa Anak Manusia, nanti bisa dapa kas ampun. Tapi kalo orang yang bicara jahat mlawan Roh Allah, de trakan dapa kas ampun, mo di dunia ini juga di dunia yang nanti datang. ");
INSERT INTO pmy_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Kalo pohon yang subur, pasti de pu bua juga bagus, kalo pohon satu kam bilang tra subur, pasti de pu bua juga tra bagus. Orang knal pohon tu dari bua. ");
INSERT INTO pmy_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Kam jahat macam ular bisa! Bagemana kam bisa bicara hal-hal yang baik, padahal kam sendiri jahat? Karna apa yang orang bicara tu kluar dari yang de simpan dalam de pu hati. ");
INSERT INTO pmy_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Orang baik kas kluar hal-hal baik yang de simpan dalam hati, orang jahat kas kluar hal-hal jahat yang de simpan dalam hati. ");
INSERT INTO pmy_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Sa bilang kam, nanti waktu Allah adili manusia, stiap orang harus tanggung jawab untuk stiap de pu kata-kata yang trada guna. ");
INSERT INTO pmy_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Karna lewat ko pu kata-kata sendiri nanti Allah anggap ko benar, trus ko pu kata-kata sendiri juga yang Allah pake untuk kas hukum ko.” ");
INSERT INTO pmy_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Waktu itu ada brapa guru agama deng orang-orang dari klompok Farisi yang bilang ke Yesus, “Bapa Guru, tong mo liat Bapa buat satu tanda heran.” ");
INSERT INTO pmy_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Tapi Yesus bilang sama dorang, “Kam tu orang-orang yang jahat deng tra setia, kam tuntut satu tanda heran. Tapi sama kam Sa tra kasi satu tanda juga, hanya tanda Nabi Yunus. ");
INSERT INTO pmy_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Karna sama sperti Yunus de tinggal dalam ikan besar itu pu perut slama tiga hari tiga malam, begitu juga Sa Anak Manusia nanti tinggal dalam perut bumi tiga hari tiga malam. ");
INSERT INTO pmy_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Jadi waktu trakir, orang-orang Niniwe nanti bangkit trus adili kam orang-orang jaman ini, karna orang-orang Niniwe itu dong tobat dari dong pu dosa-dosa waktu dong dengar yang Yunus kastau.” Trus Yesus lanjut bicara, “Liat! Yang lebi besar dari Yunus ada disini. ");
INSERT INTO pmy_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Waktu trakir, ratu dari negri slatan de nanti bangkit trus adili orang-orang jaman ini. Karna ratu itu de datang dari jau untuk dengar Salomo pu ajaran yang bikin mngerti deng baik. Liat! Yang lebi besar dari Salomo ada disini!” ");
INSERT INTO pmy_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Trus Yesus bilang, “Kalo setan kluar dari satu orang, roh itu de pigi ke tempat-tempat yang kosong cari tempat untuk de tinggal, tapi de tra dapat. ");
INSERT INTO pmy_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Jadi de bilang, ‘Sa mo kembali ke sa pu tempat yang dulu sa tinggal.’ Jadi waktu de kembali, de liat orang itu sperti tempat kosong yang bersi deng rapi. ");
INSERT INTO pmy_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Trus de pigi bawa tuju roh yang lebi jahat dari dia, dong masuk ke orang itu baru tinggal. Pasti orang itu pu hidup lebi rusak daripada yang dulu. Ini suda yang jadi sama kam smua orang-orang jahat di jaman ini.” ");
INSERT INTO pmy_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Waktu Yesus masi bicara deng banyak orang itu, De pu mama deng De pu sodara-sodara tunggu di luar baru brusaha untuk ketemu Dia. ");
INSERT INTO pmy_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Trus orang satu bilang ke Dia, “Bapa liat, Bapa pu mama deng sodara-sodara ada di luar, dong brusaha mo ketemu Bapa.” ");
INSERT INTO pmy_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Tapi Yesus bilang ke orang yang kastau pesan itu begini, “Sapa Sa pu mama? Sapa Sa pu sodara-sodara?” ");
INSERT INTO pmy_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Trus De lanjut bicara deng tunjuk ke De pu murid-murid, “Ini suda, Sa pu mama deng Sa pu sodara-sodara! ");
INSERT INTO pmy_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Karna sapa saja yang bikin Sa pu Bapa di surga pu mau, de suda Sa pu sodara laki-laki, deng Sa pu sodara prempuan, deng Sa pu mama.” ");
INSERT INTO pmy_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Di hari itu Yesus kluar dari ruma itu trus pigi duduk di pinggir danau. ");
INSERT INTO pmy_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Trus ada banyak orang dong rame-rame datang kumpul dekat Dia. Jadi De naik ke prahu baru duduk disitu, trus orang banyak itu smua bediri di pinggir danau. ");
INSERT INTO pmy_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Trus De kas ajar banyak hal deng crita conto ke dong begini, “Ada orang satu de kluar pigi hambur bibit. ");
INSERT INTO pmy_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Waktu de hambur bibit, ada bibit yang jatu di pinggir jalan, trus begini burung datang baru makan bibit itu sampe habis. ");
INSERT INTO pmy_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ada yang jatu di tempat yang banyak batu-batu yang de pu tana sdikit saja, trus bibit itu tumbu deng cepat karna de pu tana tipis. ");
INSERT INTO pmy_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Tapi waktu matahari naik, de layu trus kring, karna akar tra masuk ke tana baik-baik. ");
INSERT INTO pmy_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Bibit lain lagi jatu di rumput duri, trus rumput duri itu tamba besar baru baku dempet sampe tanaman itu mati. ");
INSERT INTO pmy_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Tapi ada juga yang jatu di tana yang subur baru de ada bua. Ada yang 100 kali lebi banyak, ada yang 60 kali lebi banyak, ada yang 30 kali lebi banyak. ");
INSERT INTO pmy_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Sapa yang pu tlinga, de harus dengar baik-baik!” ");
INSERT INTO pmy_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Trus De pu murid-murid datang baru tanya Dia, “Knapa Bapa slalu pake conto untuk kas ajar orang-orang ini?” ");
INSERT INTO pmy_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesus jawab, “Kam su dapa kastau rahasia-rahasia tentang Krajaan Surga. Tapi sama dorang, tidak. ");
INSERT INTO pmy_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Sapa yang trima apa yang de dapat, nanti de dapa kasi lebi banyak lagi sampe de mngerti betul-betul, tapi sapa yang tra mo trima apa yang de dapat, nanti itu juga dapa ambil dari dia. ");
INSERT INTO pmy_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Itu yang Sa bicara pake conto-conto ke dorang. Karna biar dong liat, macam dong tra liat, trus biar dong dengar, macam dong tra dengar deng tra mngerti. ");
INSERT INTO pmy_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Jadi dong su bikin apa yang Nabi Yesaya dulu bilang, ‘Nanti kam dengar ulang-ulang, tapi tra mngerti, nanti kam liat ulang-ulang, tapi tra tau apa yang kam liat. ");
INSERT INTO pmy_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Karna bangsa ini pu hati su kras, dong pu tlinga su tebal, dong pu mata su tutup mati, supaya jang liat deng dong pu mata, dengar deng dong pu tlinga, mngerti deng dong pu hati, biar dong jang balik untuk Sa kas sembu dorang.’ ");
INSERT INTO pmy_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Tapi kam untung skali, karna kam pu mata deng tlinga yang bisa liat deng dengar. ");
INSERT INTO pmy_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Yang Sa bilang ini benar: Jaman dulu banyak nabi-nabi deng orang benar mau skali liat deng dengar apa yang kam su liat deng dengar, tapi dong tra bisa liat deng dengar itu. ");
INSERT INTO pmy_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Jadi, kam dengar arti dari conto tentang orang yang hambur bibit itu. ");
INSERT INTO pmy_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Bibit yang jatu di pinggir jalan itu sama deng orang yang dengar Allah pu kata-kata tentang Krajaan Surga, tapi de tra mngerti, trus De Yang Jahat datang rampas Allah pu kata-kata itu dari dalam orang itu pu hati. ");
INSERT INTO pmy_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Bibit yang jatu di tana yang batu-batu, itu sama deng orang yang dengar Allah pu kata-kata trus langsung trima itu deng snang skali. ");
INSERT INTO pmy_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Tapi kata-kata itu tra masuk baik-baik dalam de pu hati, jadi tinggal sbentar saja. Waktu kena susa ato dapa siksa karna su percaya Allah pu kata-kata itu, langsung orang itu tra percaya lagi. ");
INSERT INTO pmy_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Bibit yang jatu di rumput duri itu sama deng orang yang dengar Allah pu kata-kata itu, tapi de lebi kuatir deng de pu hidup di dunia, trus tapancing untuk mo hidup kaya. Smua ni yang bikin de lupa Allah pu kata-kata itu makanya trada hasil apapa dalam de pu hidup. ");
INSERT INTO pmy_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Trus orang yang dengar deng mngerti Allah pu kata-kata itu sama deng bibit yang jatu di tana yang subur. Itu jadi de kas hasil bua, ada yang 100 kali lebi banyak, ada yang 60 kali lebi banyak, ada yang 30 kali lebi banyak.” ");
INSERT INTO pmy_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesus crita satu conto lain lagi ke dorang, De bilang, “Krajaan Surga tu sama sperti orang hambur bibit yang bagus di de pu kebun. ");
INSERT INTO pmy_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Tapi waktu smua orang ada tidur, musu de datang baru hambur bibit alang-alang di tenga-tenga gandum itu, trus pigi. ");
INSERT INTO pmy_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Waktu gandum itu tumbu baru mulai bua, alang-alang itu juga mulai kliatan. ");
INSERT INTO pmy_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Trus orang yang pu kebun pu pesuru-pesuru pigi baru bilang ke dia, ‘Bapa, yang bapa hambur di kebun tu bibit yang bagus saja to? Bagemana sampe alang-alang itu bisa ada disana eh?’ ");
INSERT INTO pmy_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Orang yang pu kebun tu de jawab, ‘Pasti sa pu musu yang bikin.’ Trus pesuru-pesuru itu bilang ke dia, ‘Bapa mau ka tong cabut alang-alang itu?’ ");
INSERT INTO pmy_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Tapi de bilang, ‘Tra bole, karna mungkin gandum itu ikut tacabut waktu kam cabut alang-alang itu. ");
INSERT INTO pmy_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Kas biar dong dua tumbu sama-sama sampe waktu mo panen. Di waktu itu tu nanti sa bilang sama orang-orang yang mo panen: Kas kumpul alang-alang itu dulu, ikat trus bakar. Habis itu, kumpul gandum itu ke dalam sa pu tempat simpan.’ ” ");
INSERT INTO pmy_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesus crita satu conto lain lagi ke dorang, De bilang, “Krajaan Surga tu sperti biji sesawi yang orang ambil baru tanam di de pu kebun. ");
INSERT INTO pmy_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Memang biji itu yang paling kecil dari smua jenis bibit, tapi kalo su tumbu, sesawi itu lebi besar daripada sayur yang lain. Itu bisa jadi pohon, sampe burung-burung liar datang bikin sarang di cabang-cabang di pohon itu.” ");
INSERT INTO pmy_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","De crita conto ini juga ke dorang, “Krajaan Surga tu sama sperti ragi. Prempuan satu de ambil ragi sdikit trus de campur deng tepung 30 kilo, bikin sampe adonan naik smua.” ");
INSERT INTO pmy_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesus kas ajar ke orang banyak itu smua pake conto. Kalo tra pake conto, De tra kas ajar apapa ke dorang. ");
INSERT INTO pmy_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Supaya benar apa yang Allah bicara lewat De pu nabi begini, “Sa mo buka Sa pu mulut hanya untuk crita conto-conto. Sa mo kas ajar tentang smua yang tasembunyi dari waktu Allah bikin dunia ini.” ");
INSERT INTO pmy_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Habis itu Yesus kas tinggal orang banyak itu, trus pulang ke ruma. Trus De pu murid-murid bilang sama Dia, “Bapa, kastau sama tong conto tentang alang-alang di kebun tu de pu arti.” ");
INSERT INTO pmy_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","De jawab begini, “Orang yang hambur bibit yang bagus tu Sa Anak Manusia, ");
INSERT INTO pmy_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","trus kebun tu dunia. Bibit yang bagus tu Allah pu orang-orang di De pu Krajaan, baru alang-alang tu De Yang Jahat pu orang-orang. ");
INSERT INTO pmy_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Musu yang hambur bibit alang-alang tu Iblis. Waktu panen tu akir jaman, trus orang-orang yang panen tu malaikat. ");
INSERT INTO pmy_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Jadi sperti alang-alang itu dong kumpul deng bakar dalam api, begitu juga waktu akir jaman. ");
INSERT INTO pmy_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nanti waktu Sa printa jadi Raja, Sa Anak Manusia suru Sa pu malaikat-malaikat trus dong kumpul smua yang bikin sesat deng smua yang bikin jahat, ");
INSERT INTO pmy_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","trus buang dong ke dalam api neraka. Disana tu tempat orang mnangis sedi skali sampe gigi bunyi. ");
INSERT INTO pmy_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Pas waktu itu suda orang-orang yang ikut Allah pu mau nanti dong jadi trang sperti matahari di dong pu Allah Bapa pu Krajaan. Sapa yang pu tlinga, de harus dengar baik-baik!” ");
INSERT INTO pmy_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Krajaan Surga tu sama sperti barang mahal yang takubur di kebun, yang orang ketemu, trus de kubur lagi. Karna de snang skali, jadi de pigi jual de pu barang-barang smua trus bli kebun itu. ");
INSERT INTO pmy_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Begitu juga Krajaan Surga tu sama sperti orang yang pu usaha jual bli yang cari mutiara yang mahal skali. ");
INSERT INTO pmy_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Habis de ketemu mutiara satu yang mahal skali tu, de pigi jual de pu barang-barang smua trus bli mutiara itu.” ");
INSERT INTO pmy_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Begitu juga Krajaan Surga tu sama sperti jala besar yang dong buang di laut untuk tangkap ikan, trus dong dapat macam-macam ikan. ");
INSERT INTO pmy_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kalo jala besar itu su penu, dong tarik ke pinggir pante, trus dong duduk baru kumpul ikan yang baik ke dalam tempat, trus ikan yang tra baik dong buang. ");
INSERT INTO pmy_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Begitu juga waktu di akir jaman. Nanti malaikat-malaikat datang kas pisa orang jahat dari orang benar, ");
INSERT INTO pmy_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","trus buang orang jahat ke dalam api neraka. Disana tu tempat orang mnangis sedi skali sampe gigi bunyi. ");
INSERT INTO pmy_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Kam mngerti smua itu ka?” Dong jawab, “Iyo, tong mngerti.” ");
INSERT INTO pmy_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Trus Yesus bilang sama dorang, “Itu jadi stiap guru agama yang su mngerti tentang Krajaan Surga, de sama sperti tuan ruma yang bawa kluar barang mahal yang baru deng yang lama dari de pu tempat simpan.” ");
INSERT INTO pmy_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Habis Yesus slesai crita conto-conto itu, De pigi dari situ. ");
INSERT INTO pmy_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Waktu Yesus sampe di De pu kampung, De kas ajar orang-orang disitu, di dong pu tempat ibada. Trus dong heran skali deng bilang, “De tau smua hal deng baik skali tu dari mana? Baru De dapat kuasa dari mana sampe bisa bikin tanda-tanda luar biasa itu? ");
INSERT INTO pmy_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","De tu tukang kayu pu Anak to? De pu mama tu Maria to, baru De pu sodara-sodara tu Yakobus, Yusup, Simon deng Yudas to? ");
INSERT INTO pmy_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Baru De pu sodara-sodara prempuan ada disini sama-sama tong to? Jadi De dapat itu smua dari mana?” ");
INSERT INTO pmy_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Jadi dong kecewa trus tolak Dia. Yesus bilang ke dorang, “Nabi tu dimana saja de dapa hormat, tapi di de pu kampung sendiri deng di de pu ruma de tra dapa hormat.” ");
INSERT INTO pmy_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Karna dong tra percaya jadi Yesus tra bikin banyak tanda luar biasa disitu. ");
INSERT INTO pmy_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Waktu itu brita-brita tentang Yesus sampe ke Herodes, yang pimpin daera Galilea. ");
INSERT INTO pmy_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Trus de bilang ke de pu pegawai-pegawai, “Ini pasti Yohanes Tukang Baptis yang dulu su mati tapi skarang de hidup kembali, itu yang De pu kuasa untuk bikin tanda-tanda luar biasa itu.” ");
INSERT INTO pmy_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Memang Herodes su suru dong tangkap Yohanes, trus ikat de baru kas penjara dia, karna masala Herodias. Herodes de su ambil Herodias, de pu sodara Filipus pu istri untuk kawin deng dia. ");
INSERT INTO pmy_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Yohanes ulang-ulang kali tegur Herodes begini, “Ko tra bole kawin deng Herodias!” ");
INSERT INTO pmy_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodes mau skali untuk bunu Yohanes, tapi de takut orang-orang, karna ada banyak orang yang percaya kalo Yohanes tu nabi. ");
INSERT INTO pmy_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pas waktu Herodes pu hari ulang taun, Herodias pu anak prempuan mnari di depan dorang, itu yang bikin Herodes pu hati snang skali. ");
INSERT INTO pmy_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Sampe Herodes sumpa nanti kasi apa saja yang de minta. ");
INSERT INTO pmy_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Karna dapa suru dari de pu mama jadi de bilang, “Sa minta Yohanes Tukang Baptis pu kepala skarang di atas piring besar!” ");
INSERT INTO pmy_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Trus raja Herodes pu hati sedi skali, tapi karna de su sumpa di depan de pu tamu-tamu jadi de suru kasi saja. ");
INSERT INTO pmy_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","De suru potong Yohanes pu kepala di penjara. ");
INSERT INTO pmy_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Trus dong bawa kepala itu di piring besar satu trus kasi ke anak prempuan itu, trus de bawa ke de pu mama. ");
INSERT INTO pmy_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Habis itu Yohanes Tukang Baptis pu murid-murid datang ambil de pu mayat baru pigi kubur. Trus dong pigi kastau hal itu ke Yesus. ");
INSERT INTO pmy_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Habis Yesus dong dengar kalo Yohanes su mati, dong pigi dari situ pake prahu ke tempat yang sunyi, dong mo sendiri saja. Tapi waktu orang banyak tau tentang hal itu, dong jalan kaki dari dong pu kota-kota ikut Dia. ");
INSERT INTO pmy_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Waktu sampe di darat, Yesus liat orang banyak ada kumpul. Trus De kas sembu dong yang sakit karna De rasa kasian skali sama dorang. ");
INSERT INTO pmy_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Waktu hari su mo malam, De pu murid-murid datang sama De baru bilang, “Bapa, tempat ini sunyi, baru su mo malam. Suru dong pigi ke kampung-kampung dekat sini suda, supaya dong bisa bli makan.” ");
INSERT INTO pmy_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Tapi Yesus bilang ke dorang, “Tra perlu dong pigi, kam yang harus kasi dong makan.” ");
INSERT INTO pmy_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Trus dong bilang, “Yang tong punya hanya lima roti deng dua ikan.” ");
INSERT INTO pmy_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesus bilang, “Mari, bawa ke Sa sini.” ");
INSERT INTO pmy_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Trus De suru orang banyak itu duduk di rumput. Habis itu De ambil lima roti deng dua ikan itu baru liat ke langit trus doa syukur ke Allah. De pata-pata roti tu baru kasi sama De pu murid-murid, trus De pu murid-murid kasi sama orang banyak. ");
INSERT INTO pmy_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Dong smua makan sampe kenyang. Habis itu orang dong kumpul roti-roti yang lebi, ada 12 loyang penu. ");
INSERT INTO pmy_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Orang-orang yang ikut makan laki-laki saja kira-kira 5.000 orang, tapi prempuan deng anana blum dapa hitung. ");
INSERT INTO pmy_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Habis itu, Yesus langsung suru De pu murid-murid naik ke prahu baru bilang dong duluan ke sebla. Trus De suru orang banyak itu pulang. ");
INSERT INTO pmy_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Habis De suru orang banyak itu pulang, Yesus naik ke atas bukit untuk berdoa sendiri. De sendiri saja disitu sampe malam. ");
INSERT INTO pmy_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Waktu itu De pu murid-murid pu prahu su brapa kilometer dari pante baru prahu dapa hantam dari ombak-ombak karna angin baku lawan ara deng prahu. ");
INSERT INTO pmy_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kira-kira jam tiga malam, Yesus datang ke dong deng jalan di atas air. ");
INSERT INTO pmy_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Waktu De pu murid-murid liat De jalan di atas air, dong kaget deng takut baru batariak, “Itu setan!” trus dong batariak-batariak karna takut. ");
INSERT INTO pmy_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Tapi langsung Yesus bilang ke dorang, “Ini Saya, jang takut! Kas kuat kam pu hati!” ");
INSERT INTO pmy_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Trus Petrus bicara ke Yesus, “Bapa, kalo memang itu Bapa, suru sa jalan ke Bapa di atas air juga ka.” ");
INSERT INTO pmy_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesus bilang, “Datang suda!” Trus Petrus turun dari prahu baru jalan di atas air mnuju Yesus. ");
INSERT INTO pmy_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Tapi, pas waktu de rasa ada angin kencang begini de takut baru de mulai tenggelam trus de batariak, “Tuhan, tolong sa ka!” ");
INSERT INTO pmy_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yesus langsung ulur De pu tangan pegang Petrus baru bilang, “Petrus, ko ni kurang percaya, knapa ko ragu-ragu begitu?” ");
INSERT INTO pmy_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Habis itu dong naik ke prahu, trus angin langsung tenang. ");
INSERT INTO pmy_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Dong smua yang ada dalam prahu semba Yesus deng bilang, “Bapa ni benar-benar Allah pu Anak.” ");
INSERT INTO pmy_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Waktu sampe di sebla, dong turun di Genesaret. ");
INSERT INTO pmy_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Waktu orang-orang disitu knal Yesus, dong kastau ke smua daera itu. Jadi smua orang yang sakit dong bawa ke Yesus. ");
INSERT INTO pmy_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Dong mohon ke Dia supaya kas ijin dong biar hanya pegang De pu baju panjang pu ujung saja. Smua orang yang pegang De pu baju itu jadi sembu. ");
INSERT INTO pmy_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Habis itu, ada orang Farisi deng guru-guru agama brapa yang datang dari Yerusalem untuk ketemu Yesus. Dong bilang, ");
INSERT INTO pmy_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Knapa Ko pu murid-murid tra ikut tua-tua adat pu aturan? Dong tra cuci tangan seblum makan.” ");
INSERT INTO pmy_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Tapi Yesus jawab ke dorang, “Trus knapa kam tra bikin Allah pu printa hanya karna mo ikut kam pu aturan adat? ");
INSERT INTO pmy_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Karna Allah bilang, ‘Hormati ko pu bapa deng mama,’ deng juga, ‘Sapa yang hina de pu bapa ato mama harus dapa hukum mati.’ ");
INSERT INTO pmy_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Tapi yang kam kas ajar, orang tra bikin sala kalo bilang ke de pu bapa ato mama, ‘Smua barang yang sa harus kasi ke bapa deng mama, sa su janji untuk kasi itu ke Allah.’ ");
INSERT INTO pmy_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Itu sama saja kam su kas ajar orang untuk tra kas tunjuk hormat ke de pu bapa ato mama. Deng begitu, kam kas hilang Allah pu printa hanya untuk ikut kam pu aturan adat sendiri. ");
INSERT INTO pmy_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Kam ni pura-pura baik! Memang betul yang Nabi Yesaya bilang tentang kam, ");
INSERT INTO pmy_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Bangsa ini puji-puji Sa deng dong pu mulut, padahal dong pu hati jau dari Saya. ");
INSERT INTO pmy_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Percuma saja dong semba Saya, karna ajaran yang dong kas ajar tu hanya ikut manusia pu aturan.’ ” ");
INSERT INTO pmy_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Trus Yesus panggil orang banyak baru bilang ke dorang, “Dengar baik-baik yang Sa bilang ni supaya kam mngerti: ");
INSERT INTO pmy_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Apa yang masuk ke dalam mulut, itu trakan bikin orang jadi tra bersi depan Allah, tapi apa yang kluar dari mulut, itu yang bikin orang jadi tra bersi.” ");
INSERT INTO pmy_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Begini Yesus pu murid-murid dong datang baru bilang, “Bapa tau, apa yang Bapa bicara tu su bikin orang-orang Farisi dong mara?” ");
INSERT INTO pmy_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesus jawab, “Stiap tanaman yang Sa pu Bapa di surga tra tanam, nanti dapa cabut deng akar-akar. ");
INSERT INTO pmy_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Kas biar dong suda. Dong tu orang buta yang bawa orang buta. Kalo orang buta bawa orang buta, pasti dong dua jatu ke dalam lobang.” ");
INSERT INTO pmy_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Trus Petrus bilang ke Yesus, “Kas jlas tentang conto itu sama kitong.” ");
INSERT INTO pmy_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesus jawab, “Kam juga blum bisa mngerti ka? ");
INSERT INTO pmy_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Kam tra tau ka, kalo apa saja yang masuk ke dalam mulut turun ke dalam perut trus dong buang di tempat buang air besar? ");
INSERT INTO pmy_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Tapi apa yang kluar dari mulut, de pu asal dari hati, itu yang bikin orang tra bersi depan Allah. ");
INSERT INTO pmy_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Karna dari hati muncul smua pikiran jahat untuk bunu orang, tidur deng orang yang bukan de pu pasangan, bikin barang kurang ajar, curi, jadi saksi yang tra benar, deng bikin rusak orang pu nama. ");
INSERT INTO pmy_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Hal-hal ini suda yang bikin orang tra bersi depan Allah. Tapi kalo makan deng tangan yang tra cuci, itu tra bikin orang tra bersi depan Allah.” ");
INSERT INTO pmy_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Habis itu, Yesus kas tinggal tempat itu trus pigi ke daera yang dekat Kota Tirus deng Kota Sidon. ");
INSERT INTO pmy_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Begini ada prempuan Kanaan satu dari daera itu datang trus bilang deng suara kras, “Bapa, Daud pu turunan, kasian sa ka. Sa pu anak prempuan krasukan setan baru de mendrita skali.” ");
INSERT INTO pmy_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Tapi Yesus tra jawab apapa sama prempuan itu. Trus De pu murid-murid datang baru mohon ke Yesus, “Suru de pigi suda, de ikut tong deng batariak-batariak tu.” ");
INSERT INTO pmy_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesus bilang sama prempuan itu, “Sa dapa utus hanya untuk domba-domba yang hilang dari orang Israel.” ");
INSERT INTO pmy_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Tapi prempuan itu datang trus tanam lutut di depan Yesus deng bilang, “Bapa, tolong sa ka.” ");
INSERT INTO pmy_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Tapi Yesus bilang, “Tra baik ambil anana pu makanan baru lempar ke anjing.” ");
INSERT INTO pmy_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Prempuan itu de jawab, “Betul Bapa, tapi anjing itu juga makan de pu tuan pu sisa-sisa makanan yang jatu dari de pu meja.” ");
INSERT INTO pmy_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Trus Yesus bilang ke prempuan itu, “Mama, ko pu percaya ke Sa besar skali. Itu yang, jadi suda sama sperti apa yang ko minta.” Jam itu juga langsung de pu anak sembu. ");
INSERT INTO pmy_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Habis kas tinggal daera itu, Yesus kembali jalan di pinggir danau Galilea trus naik ke bukit baru duduk disitu. ");
INSERT INTO pmy_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ada orang banyak skali yang datang ke Dia. Dong bawa orang pincang, orang buta, orang lumpu, orang bisu, deng banyak lagi orang yang lain. Orang-orang sakit itu dong taru di depan Yesus, trus Yesus kas sembu dong smua. ");
INSERT INTO pmy_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Langsung orang banyak itu heran skali waktu liat orang bisu bisa bicara, orang pincang sembu, orang lumpu bisa jalan, orang buta bisa liat, trus dong smua puji-puji kas tinggi orang Israel pu Allah. ");
INSERT INTO pmy_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Habis itu Yesus panggil De pu murid-murid baru bilang, “Sa kasian skali sama orang banyak ini. Su tiga hari dong ada sama-sama deng Sa baru dong tra pu makanan. Sa tra mau suru dong pulang deng perut kosong, nanti dong bisa pingsan di jalan.” ");
INSERT INTO pmy_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Jadi De pu murid-murid bilang, “Tong mo dapat roti yang cukup untuk kas makan orang banyak ini di tempat sunyi sperti begini bagemana?” ");
INSERT INTO pmy_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jadi Yesus tanya ke dorang, “Kam pu roti ada brapa?” Dong jawab, “Tuju, deng ada brapa ikan kecil lagi.” ");
INSERT INTO pmy_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Trus Yesus suru orang banyak itu dong duduk di tana. ");
INSERT INTO pmy_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Trus De ambil roti tuju deng ikan-ikan itu, baru De doa syukur ke Allah. Habis itu De pata-pata trus kasi roti itu ke De pu murid-murid baru De pu murid-murid bagi-bagi ke orang banyak itu. ");
INSERT INTO pmy_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Dong smua makan sampe kenyang. Habis itu, dong kumpul roti-roti yang lebi, smua ada tuju loyang besar baru penu. ");
INSERT INTO pmy_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Orang-orang yang ikut makan waktu itu, laki-laki ada 4.000, tapi prempuan deng anana blum dapa hitung. ");
INSERT INTO pmy_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Trus Yesus suru orang banyak itu pulang. Habis itu De naik prahu trus pigi ke daera Magadan. ");
INSERT INTO pmy_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Begini ada orang Farisi deng Saduki brapa orang datang untuk coba Yesus. Dong minta supaya De kas liat sama dong satu tanda kalo De dari surga. ");
INSERT INTO pmy_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Tapi Yesus jawab, “Waktu matahari su mo tenggelam baru langit kliatan mera-mera, langsung kam bilang, ‘Besok cuaca cera.’ ");
INSERT INTO pmy_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Trus kalo waktu matahari mo terbit baru langit kliatan mera baru glap, langsung kam bilang, ‘Hari ini mo hujan.’ Tanda-tanda di langit kam bisa mngerti, tapi tanda-tanda yang Sa ada bikin di jaman ini kam tra bisa mngerti. ");
INSERT INTO pmy_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kam tu orang-orang yang jahat deng tra setia, kam tuntut satu tanda heran. Tapi sama kam Sa tra kasi satu tanda juga, hanya tanda Nabi Yunus.” Trus Yesus pigi kas tinggal dorang. ");
INSERT INTO pmy_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Waktu Yesus pu murid-murid dong sampe deng prahu di danau sebla, dong baru sadar kalo dong lupa bawa roti. ");
INSERT INTO pmy_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Trus Yesus bilang sama dorang, “Ingat eh, kam harus hati-hati deng ragi dari klompok Farisi deng Saduki.” ");
INSERT INTO pmy_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Trus dong yang satu bilang ke yang lain, “De bicara begitu karna tong tra bawa roti.” ");
INSERT INTO pmy_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Tapi Yesus tau apa yang dong ada bicara-bicara, trus De bilang, “Knapa kam bicara tentang trada roti? Kam orang-orang yang kurang percaya Saya! ");
INSERT INTO pmy_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Kam blum mngerti juga ka? Kam tra ingat ka tentang lima roti untuk 5.000 orang itu, baru habis itu kam kumpul roti yang lebi ada brapa loyang? ");
INSERT INTO pmy_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ato tentang tuju roti untuk 4.000 orang itu, baru habis itu brapa loyang yang kam kumpul? ");
INSERT INTO pmy_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Knapa sampe kam tra mngerti kalo Sa bukan bicara deng kam tentang roti? Hati-hati deng ragi dari klompok Farisi deng Saduki.” ");
INSERT INTO pmy_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Itu baru dong mngerti kalo Yesus pu maksud bukan hati-hati deng ragi untuk roti, tapi hati-hati deng ajaran dari klompok Farisi deng Saduki. ");
INSERT INTO pmy_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesus dong pigi ke daera dekat Kota Kaisarea Filipi, baru De tanya ke De pu murid-murid, “Orang dong bilang Sa Anak Manusia ini sapa?” ");
INSERT INTO pmy_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Dong jawab, “Ada yang bilang Yohanes Tukang Baptis, ada yang bilang Elia, ada juga yang bilang Yeremia ato satu dari nabi-nabi yang lain.” ");
INSERT INTO pmy_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Trus Yesus tanya ke dorang, “Tapi kam bilang, Sa ni sapa?” ");
INSERT INTO pmy_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Petrus jawab, “Bapa itu Raja Yang Allah Pili, Allah yang hidup pu Anak!” ");
INSERT INTO pmy_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesus bilang sama dia, “Simon, bapa Yunus pu anak, ko untung skali karna bukan manusia yang kastau itu ke ko, tapi Sa pu Bapa yang di surga. ");
INSERT INTO pmy_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Skarang Sa bilang sama ko, ko tu Petrus, yang de pu arti batu yang kuat. Di atas batu ini, nanti Sa kas bediri Sa pu jemaat, biar dong kena siksa sampe mati juga itu trakan kas hancur dorang. ");
INSERT INTO pmy_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nanti Sa kasi ko kunci Krajaan Surga. Apa yang ko larang di bumi, Allah di surga juga larang itu. Trus apa yang ko kas ijin di bumi, Allah di surga juga kas ijin itu.” ");
INSERT INTO pmy_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Trus Yesus larang De pu murid-murid supaya jang kastau ke sapa-sapa kalo De tu Raja Yang Allah Pili. ");
INSERT INTO pmy_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Mulai dari situ, Yesus mulai bicara trus trang ke De pu murid-murid kalo De harus pigi ke Yerusalem, disana nanti De dapa siksa dari orang Yahudi pu tua-tua deng imam-imam kepala deng guru-guru agama, trus dapa bunu, tapi hari ketiga Allah kas hidup kembali. ");
INSERT INTO pmy_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Tapi Petrus tarik Yesus ke pinggir baru tegur Dia, “Tuhan, jang bilang begitu! Hal itu tra bole kena Bapa.” ");
INSERT INTO pmy_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Trus Yesus balik ke Petrus baru bilang, “Iblis, pigi dari sini! Ko su jadi batu yang mo bikin Sa jatu, karna ko bukan pikir apa yang Allah pikir, tapi apa yang manusia pikir.” ");
INSERT INTO pmy_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Trus Yesus bilang sama De pu murid-murid, “Kalo ada orang yang mo ikut Saya, de tra bole ikut de pu mau, trus harus pikul de pu salib deng ikut Saya. ");
INSERT INTO pmy_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Karna sapa saja yang kas slamat de pu hidup, de trakan dapat hidup yang trada akir. Tapi orang yang kasi de pu hidup untuk Saya, de pasti dapat hidup yang trada akir. ");
INSERT INTO pmy_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ada untung ka kalo satu orang de dapat smua harta di dunia ini, tapi de tra dapat hidup yang trada akir itu? Apa yang de bisa kasi untuk dapat hidup yang trada akir itu ka? ");
INSERT INTO pmy_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Karna Sa Anak Manusia deng Sa pu malaikat-malaikat nanti datang deng cahaya yang penu kuasa dari Sa pu Bapa. Di waktu itu tu nanti Sa kasi apa yang pantas ke stiap orang, pas deng yang dong bikin. ");
INSERT INTO pmy_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Yang Sa bilang ini benar: Dari tenga-tenga kam yang hadir disini, ada yang trakan mati sampe dong liat Sa Anak Manusia datang untuk printa di Sa pu Krajaan.” ");
INSERT INTO pmy_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Lewat enam hari begini, Yesus bawa Petrus, Yakobus deng de pu sodara Yohanes, De sama-sama dong naik ke gunung satu yang tinggi. Dong sendiri saja disitu. ");
INSERT INTO pmy_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Trus Yesus kliatan jadi lain di depan dorang. De pu muka sperti matahari pu sinar, trus De pu pakean jadi puti trang skali. ");
INSERT INTO pmy_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Tiba-tiba dong liat Musa deng Elia ada bicara deng Yesus. ");
INSERT INTO pmy_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Petrus bilang ke Yesus, “Tuhan, snang skali tong ada disini. Kalo Bapa mau, biar sa kas bediri tiga kema disini, satu untuk Bapa, satu untuk Musa baru satu untuk Elia.” ");
INSERT INTO pmy_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Waktu Petrus masi bicara begini, tiba-tiba awan puti yang trang turun tutup dong. Baru ada suara dari awan itu bilang, “Ini Sa pu Anak yang Sa sayang, De yang bikin Sa pu hati snang. Kam harus dengar Dia.” ");
INSERT INTO pmy_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Dengar begitu dong langsung takut skali trus jatu. ");
INSERT INTO pmy_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Trus Yesus datang pegang dong deng bilang, “Jang takut, bediri suda!” ");
INSERT INTO pmy_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Waktu dong angkat kepala, dong tra liat sapa-sapa hanya Yesus sendiri saja. ");
INSERT INTO pmy_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Waktu dong turun dari gunung itu, Yesus larang dorang, “Apa yang kam liat tadi, jang crita ke sapa-sapa sampe Sa Anak Manusia hidup kembali dari tenga-tenga orang mati.” ");
INSERT INTO pmy_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Trus De pu murid-murid tanya ke Dia, “Kalo memang Ko tu Raja Yang Allah Pili, knapa guru-guru agama bilang kalo Elia harus datang duluan?” ");
INSERT INTO pmy_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesus jawab, “Memang Elia harus datang untuk bikin smua-smua jadi baik lagi. ");
INSERT INTO pmy_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Trus Sa bilang kam, Elia su datang, tapi orang tra knal dia, baru bikin de tra baik sperti dong pu mau. Begitu juga nanti dong siksa Sa Anak Manusia.” ");
INSERT INTO pmy_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Waktu itu baru De pu murid-murid mngerti kalo yang De bicara tu tentang Yohanes Tukang Baptis. ");
INSERT INTO pmy_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Waktu Yesus dong kembali ke orang banyak itu, satu orang datang ketemu Yesus baru tunduk depan Dia. ");
INSERT INTO pmy_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Orang itu de bilang, “Tuhan, kasian sa pu anak ka, de sakit mati-mati ayam baru mendrita skali. Biasa de jatu ke dalam api, biasa ke dalam air juga. ");
INSERT INTO pmy_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Sa su bawa de ke Bapa pu murid-murid tapi dong tra bisa kas sembu dia.” ");
INSERT INTO pmy_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jadi Yesus bilang, “Kam memang orang-orang yang tra percaya deng tra ikut yang benar, mo sampe kapan Sa harus tinggal di tenga kam? Sampe kapan Sa harus sabar deng kam? Bawa anak itu kemari!” ");
INSERT INTO pmy_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesus printa setan itu, baru setan kluar dari anak itu trus de langsung sembu. ");
INSERT INTO pmy_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Habis itu waktu De sendiri, De pu murid-murid datang trus dong tanya begini, “Knapa tong tra bisa usir setan itu e?” ");
INSERT INTO pmy_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","De bilang ke dorang, “Karna kam kurang percaya. Yang Sa bilang ini benar: Kalo kam pu percaya sperti biji yang paling kecil saja, kam bisa bilang sama gunung ini, ‘Pinda dari tempat ini kesana,’ nanti gunung ini pinda, trakan ada yang tra mungkin untuk kam.  ");
INSERT INTO pmy_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Kalo kam tra doa deng puasa, kam tra bisa usir yang macam ini.” ");
INSERT INTO pmy_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Waktu Yesus deng De pu murid-murid kumpul sama-sama di Galilea, De bilang ke dorang, “Sa Anak Manusia nanti dapa kasi ke dalam tangan manusia. ");
INSERT INTO pmy_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Baru nanti dong bunu Saya, tapi tiga hari nanti Allah kas hidup Sa kembali.” Jadi De pu murid-murid pu hati rasa susa skali. ");
INSERT INTO pmy_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Waktu Yesus dong sampe di Kapernaum, tukang tagi pajak untuk Ruma Allah datang ke Petrus baru bilang, “Kam pu Guru tra bayar pajak yang orang Yahudi biasa bayar untuk Ruma Allah ka?” ");
INSERT INTO pmy_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","De jawab, “Bayar to.” Waktu Petrus masuk ruma, Yesus duluan tanya ke de begini, “Simon, coba ko pikir tentang ini, raja-raja dunia ini dong kumpul pajak-pajak dari sapa? Dari orang-orang yang de pimpin ka ato dari orang asing?” ");
INSERT INTO pmy_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petrus jawab, “Dari orang asing!” Trus Yesus bilang, “Kalo begitu, raja pu orang-orang bebas. ");
INSERT INTO pmy_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Tapi supaya tong jang bikin dong mara, pigi mancing di danau, tangkap ikan pertama yang ko mancing baru buka de pu mulut. Di dalam de pu mulut nanti ko ketemu koin satu yang cukup untuk bayar tong dua pu pajak Ruma Allah. Ambil uang itu baru bayar ko deng Sa pu pajak ke dorang.” ");
INSERT INTO pmy_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Waktu itu murid-murid datang ke Yesus baru tanya, “Sapa yang paling penting dari antara Allah pu orang-orang dalam Krajaan Surga ka?” ");
INSERT INTO pmy_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Trus Yesus panggil anak kecil satu baru kas bediri di tenga-tenga dong ");
INSERT INTO pmy_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","deng bilang, “Yang Sa bilang ini benar: Kalo kam tra tobat dari dosa-dosa deng jadi sperti anak kecil, kam tra bisa masuk dalam Krajaan Surga. ");
INSERT INTO pmy_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Tapi orang yang kas renda diri macam anak kecil ini, nanti de yang paling penting dalam Krajaan Surga. ");
INSERT INTO pmy_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Sapa saja yang trima satu anak sperti ini karna de percaya dalam Sa pu nama, itu de trima Saya.” ");
INSERT INTO pmy_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Tapi sapa saja yang bikin sampe satu dari anana kecil yang percaya Sa ni bikin dosa, lebi baik untuk de kalo orang ikat batu besar di de pu leher baru kas tenggelam de ke laut. ");
INSERT INTO pmy_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Claka skali dunia ini karna ada banyak hal yang bikin sampe orang bikin dosa. Memang hal-hal itu pasti ada, tapi claka skali orang yang umpan itu. ");
INSERT INTO pmy_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Kalo ko pu tangan ato kaki yang bikin sampe ko bikin dosa, potong baru buang suda! Karna lebi baik ko masuk ke dalam hidup yang trada akir deng tangan putus ato kaki putus daripada ko pu tangan deng kaki dua-dua lengkap tapi dapa buang ke dalam api yang tra bisa padam. ");
INSERT INTO pmy_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Kalo ko pu mata bikin sampe ko bikin dosa, cungkil baru buang suda! Karna lebi baik ko masuk ke dalam hidup yang trada akir deng mata sebla daripada ko pu mata dua-dua lengkap tapi dapa buang ke dalam api neraka. ");
INSERT INTO pmy_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Awas! Jang anggap reme satu dari anana kecil ini. Sa bilang sama kam, ada dong pu malaikat di surga yang slalu ada di muka Sa pu Bapa di surga.  ");
INSERT INTO pmy_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Karna Sa Anak Manusia, datang untuk kas slamat orang yang hilang.” ");
INSERT INTO pmy_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Kam pikir bagemana? Kalo satu orang de pu domba 100 ekor, trus satu ekor hilang, apa yang orang itu de bikin? Pasti de taru 99 domba itu di daera gunung, baru pigi cari yang hilang itu sampe dapat to? ");
INSERT INTO pmy_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Yang Sa bilang ini benar: Kalo de su dapat, de pu snang lebi besar karna satu ekor itu dari 99 ekor yang tra hilang. ");
INSERT INTO pmy_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Begitu juga deng kam pu Bapa di surga, De tra mau kalo satu dari anana ini hilang.” ");
INSERT INTO pmy_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Kalo ko pu sodara dalam Tuhan bikin dosa, ko pigi ke dia. Trus waktu kam dua sendiri saja, ko bisa bicara masala itu deng dia. Kalo de dengar ko pu naseat, de su jadi ko pu sodara lagi. ");
INSERT INTO pmy_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Kalo de tra mau dengar ko, bawa satu ato dua orang lagi, karna di Kitab Suci ada tulis, ‘Paling sdikit perlu dua ato tiga saksi untuk kas jlas satu masala.’ ");
INSERT INTO pmy_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kalo de bikin malas tau deng dorang, bicara masala itu ke jemaat. Kalo de tra mau dengar jemaat juga, bikin de sperti orang lain yang tra knal Allah ato tukang tagi pajak. ");
INSERT INTO pmy_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Yang Sa bilang ini benar: Apa yang kam larang di bumi, Allah di surga juga larang itu. Trus apa yang kam kas ijin di bumi, Allah di surga juga kas ijin itu. ");
INSERT INTO pmy_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Yang Sa bilang ini benar juga: Kalo dua orang dari tenga-tenga kam di dunia ini sama-sama satu hati minta apa saja, Sa pu Bapa di surga nanti bikin apa yang kam minta. ");
INSERT INTO pmy_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Karna dimana dua ato tiga orang kumpul karna Saya, disitu Sa ada di tenga-tenga dorang.” ");
INSERT INTO pmy_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Habis itu Petrus datang baru bilang ke Yesus, “Tuhan, sampe brapa kali sa harus kas ampun sa pu sodara kalo de bikin sala ke saya? Sampe tuju kali?” ");
INSERT INTO pmy_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesus jawab, “Tidak! Dengar yang Sa bilang ni, bukan sampe tuju kali, tapi sampe 77 kali. ");
INSERT INTO pmy_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Karna Krajaan Surga tu sama sperti raja satu yang mo priksa de pu pesuru-pesuru yang ada utang ke dia. ");
INSERT INTO pmy_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Waktu de mulai priksa, dong bawa pesuru satu yang pu utang 10.000 kantong koin emas. ");
INSERT INTO pmy_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Tapi karna orang itu tra mampu kas lunas de pu utang, raja itu kas printa supaya dong jual dia, de pu istri, de pu anana, deng de pu barang-barang smua untuk bayar de pu utang. ");
INSERT INTO pmy_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Trus pesuru itu mohon deng tunduk di depan raja, de bilang, ‘Tuan, sabar dulu ka, nanti sa kas lunas sa pu utang smua.’ ");
INSERT INTO pmy_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Raja itu rasa kasian, jadi de kas bebas trus kas hapus pesuru itu pu utang smua. ");
INSERT INTO pmy_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Tapi waktu pesuru itu kluar, de ketemu deng pesuru lain yang ada utang ke de sdikit saja. De tangkap deng ramas de pu kawan itu pu batang leher, baru bilang, ‘Bayar ko pu utang!’ ");
INSERT INTO pmy_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Trus de pu kawan itu tunduk di depan de deng mohon, ‘Sabar dulu ka, nanti sa kas lunas sa pu utang.’ ");
INSERT INTO pmy_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Tapi de tra mau, trus de kasi de pu kawan itu ke dalam penjara sampe de pu kawan kas lunas de pu utang. ");
INSERT INTO pmy_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","De pu kawan-kawan lain yang liat itu rasa hati susa skali, trus kastau smua yang jadi tu ke dong pu tuan. ");
INSERT INTO pmy_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Jadi, raja suru panggil orang itu baru bilang ke dia, ‘Ko ni pesuru yang jahat! Ko pu utang smua sa su kas hapus karna ko mohon ke saya. ");
INSERT INTO pmy_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ko juga harus kasian ko pu kawan sperti sa su kasian ko to!’ ");
INSERT INTO pmy_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Raja langsung mara, trus kasi de ke orang-orang yang jaga penjara untuk siksa de sampe de kas lunas de pu utang smua. ");
INSERT INTO pmy_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Begitu juga yang nanti Sa pu Bapa di surga bikin sama kam, kalo kam tra kas ampun kam pu sodara deng kam pu hati.” ");
INSERT INTO pmy_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Habis Yesus slesai bicara itu smua, De dari Galilea pigi ke daera Yudea yang di sebla kali Yordan. ");
INSERT INTO pmy_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ada banyak orang skali yang ikut Dia, trus De kas sembu dong disana. ");
INSERT INTO pmy_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Trus orang-orang Farisi datang untuk coba Dia. Dong tanya begini, “Di tong pu hukum agama, bisa ka orang cerai deng de pu istri deng alasan apa saja?” ");
INSERT INTO pmy_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesus jawab, “Kam blum perna baca ka, kalo dari pertama Allah bikin dong tu laki-laki deng prempuan? ");
INSERT INTO pmy_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Trus Allah juga bilang, ‘Itu jadi laki-laki tra tinggal lagi sama de pu bapa deng mama, tapi hidup satu hati deng de pu istri, biar dong dua jadi satu.’ ");
INSERT INTO pmy_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Jadi dong dua bukan dua orang lagi, tapi satu. Jadi apa yang Allah su kas satu, manusia tra bole kas pisa.” ");
INSERT INTO pmy_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Dong bilang ke Yesus begini, “Kalo begitu, knapa Musa kas printa untuk kasi surat cerai kalo orang kas cerai de pu istri?” ");
INSERT INTO pmy_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Trus Yesus bilang, “Dari dulu tu tra begitu, karna kam pu kepala batu jadi Musa kas ijin kam kas cerai kam pu istri. ");
INSERT INTO pmy_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Tapi Sa bilang kam, sapa saja yang kas cerai de pu istri, kecuali kalo de pu istri bikin barang kurang ajar, baru pigi kawin lagi deng prempuan lain, itu de su bikin dosa karna de su tidur deng orang yang bukan de pu pasangan.” ");
INSERT INTO pmy_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Murid-murid bilang sama Dia, “Kalo memang suami tra bole cerai de pu istri begitu saja, lebi baik tra usa nika suda.” ");
INSERT INTO pmy_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jadi De bilang sama dorang, “Tra smua orang bisa trima yang kam bilang itu, hanya orang-orang yang Allah su pili saja. ");
INSERT INTO pmy_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ada orang yang tra bisa kawin karna dari lahir memang de su begitu, ada juga orang yang tra bisa kawin karna orang lain bikin de untuk begitu, trus ada orang yang tra kawin karna de pu mau sendiri supaya bisa layani untuk Krajaan Surga. Orang yang bisa trima ajaran ini, biar de trima deng baik.” ");
INSERT INTO pmy_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Trus orang-orang bawa anana kecil ke Yesus, supaya De taru tangan doa dorang. Tapi De pu murid-murid mara orang-orang itu. ");
INSERT INTO pmy_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Baru Yesus bilang, “Kas biar anana kecil itu datang ke Saya, jang larang-larang dong, karna orang-orang sperti begini yang punya Krajaan Surga.” ");
INSERT INTO pmy_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Trus De taru tangan untuk berkati dorang, habis itu De pigi dari situ. ");
INSERT INTO pmy_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ada orang muda satu datang sama Yesus baru bilang, “Bapa Guru, hal baik apa yang sa harus bikin supaya sa bisa hidup trus sampe trada akir?” ");
INSERT INTO pmy_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesus jawab, “Knapa sampe ko bisa tanya hal yang baik ke Saya? Hanya Satu Orang yang baik. Tapi kalo mo dapat hidup yang trada akir, ikut Allah pu printa-printa.” ");
INSERT INTO pmy_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Orang itu bilang, “Printa yang mana?” Yesus jawab, “Jang bunu orang, jang tidur deng orang yang bukan ko pu pasangan, jang curi, jang jadi saksi yang tra benar, ");
INSERT INTO pmy_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","hormati ko pu bapa deng mama, sama sayang orang lain sama sperti ko sayang ko pu diri sendiri.” ");
INSERT INTO pmy_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Orang muda itu bilang ke Dia, “Allah pu printa itu smua sa su bikin, apa lagi yang sa harus bikin?” ");
INSERT INTO pmy_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesus bilang, “Kalo ko mo jadi sempurna, pigi baru jual smua yang ko punya trus kasi itu sama orang-orang miskin, deng bikin begitu ko nanti dapat harta di surga. Habis itu baru ko datang ikut Saya.” ");
INSERT INTO pmy_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Dengar begitu, orang muda itu pigi deng rasa sedi skali, karna de pu harta banyak. ");
INSERT INTO pmy_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yesus bilang ke De pu murid-murid, “Yang Sa bilang ini benar: Susa skali orang kaya masuk dalam Krajaan Surga. ");
INSERT INTO pmy_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Sa bilang kam lagi, lebi gampang satu ekor unta masuk lewat lobang jarum daripada satu orang kaya masuk dalam Allah pu Krajaan.” ");
INSERT INTO pmy_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Waktu murid-murid dengar itu, dong heran skali deng bilang, “Kalo begitu, sapa yang bisa slamat?” ");
INSERT INTO pmy_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesus liat dong baru bilang, “Manusia tra bisa kas slamat de pu diri sendiri, tapi untuk Allah apa saja pasti bisa.” ");
INSERT INTO pmy_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Trus Petrus bilang ke Yesus, “Liat, tong su kas tinggal smua-smua untuk ikut Bapa, jadi apa yang nanti tong dapat?” ");
INSERT INTO pmy_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesus bilang, “Yang Sa bilang ini benar: Nanti waktu Allah bikin dunia ini jadi baru, waktu Anak Manusia duduk di De pu kursi raja yang luar biasa, kam yang su jadi Sa pu murid-murid nanti duduk di atas duablas kursi raja untuk adili duablas suku Israel. ");
INSERT INTO pmy_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Orang yang kas tinggal de pu ruma, de pu sodara laki-laki ato prempuan, de pu mama ato bapa, de pu anana ato de pu kebun karna jadi Sa pu pengikut, orang itu pasti dapat 100 kali lebi banyak dari yang de su kas tinggal, juga nanti dapat hidup yang trada akir. ");
INSERT INTO pmy_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Tapi banyak orang yang pertama nanti jadi yang trakir. Trus yang trakir nanti jadi yang pertama.” ");
INSERT INTO pmy_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yesus bilang lagi, “Krajaan Surga tu sama sperti begini, ada satu orang yang pu kebun anggur. Pagi-pagi skali de kluar cari orang-orang untuk kerja di kebun itu. ");
INSERT INTO pmy_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Habis de stuju deng orang-orang kerja itu untuk kasi gaji sperti biasa satu hari satu uang perak, de suru dong ke de pu kebun anggur. ");
INSERT INTO pmy_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Kira-kira jam sembilan pagi, de kluar lagi baru de liat ada orang-orang lain lagi yang tra kerja apapa di pasar. ");
INSERT INTO pmy_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Trus de bilang sama dorang, ‘Kam juga pigi kerja di sa pu kebun anggur suda, nanti sa bayar kam deng gaji yang pantas.’ Trus dong pigi. ");
INSERT INTO pmy_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Kira-kira jam 12 siang deng jam tiga sore, de kluar lagi trus bikin hal yang sama. ");
INSERT INTO pmy_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Habis itu, kira-kira jam lima sore, de kluar lagi trus de liat ada orang-orang lain lagi yang trada kerja apapa, jadi de bilang sama dorang, ‘Knapa satu hari ini kam buang-buang waktu saja disini deng tra kerja apapa?’ ");
INSERT INTO pmy_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Dong bilang sama dia, ‘Karna trada orang yang kasi tong kerja.’ De bilang sama dong, ‘Kam juga pigi kerja di sa pu kebun anggur suda.’ ");
INSERT INTO pmy_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Waktu hari su mo glap, orang yang pu kebun tu de bilang ke orang yang jaga-jaga liat orang kerja begini, ‘Panggil orang-orang kerja itu baru bayar dong pu uang kerja, mulai dari dong yang masuk trakir sampe dong yang masuk pertama.’ ");
INSERT INTO pmy_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Trus dong yang kerja kira-kira jam lima sore datang baru dong masing-masing trima satu uang perak. ");
INSERT INTO pmy_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Begini dong yang masuk pertama datang, dong pikir nanti dong dapa bayar lebi banyak, tapi dong juga trima masing-masing satu uang perak. ");
INSERT INTO pmy_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Waktu dong trima uang itu, dong sungut-sungut sama orang yang punya kebun anggur itu. ");
INSERT INTO pmy_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Dong bilang begini, ‘Dong yang masuk trakir ni cuma kerja satu jam saja. Masa bapa bayar dong sama deng tong yang tahan panas matahari kerja brat satu hari penu!’ ");
INSERT INTO pmy_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Tapi orang yang pu kebun anggur tu de bilang sama satu orang dari dong begini, ‘Kawan, sa tra bikin barang yang tra adil sama ko. Ko su stuju uang kerja satu hari satu uang perak to? ");
INSERT INTO pmy_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ambil ko pu bagian trus pigi suda, memang sa mo kasi sama orang yang masuk trakir tu sama deng yang sa kasi ke ko. ");
INSERT INTO pmy_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Sa pu hak untuk bikin apa saja deng sa pu uang sendiri to? Ato ko tra snang ka, karna sa baik hati sama orang-orang?’ ");
INSERT INTO pmy_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Begitu juga orang yang trakir nanti jadi yang pertama. Trus yang pertama nanti jadi yang trakir.” ");
INSERT INTO pmy_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Waktu Yesus mo pigi ke Yerusalem, di tenga jalan Yesus panggil De pu duablas murid dong kumpul sendiri baru bilang sama dorang, ");
INSERT INTO pmy_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Skarang tong pigi ke Yerusalem, baru nanti Sa Anak Manusia dapa kasi ke imam-imam kepala deng guru-guru agama, trus dong hukum mati Saya. ");
INSERT INTO pmy_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Nanti dong kasi Sa ke orang-orang bukan Yahudi, supaya dong ejek-ejek Saya, cambuk, trus kas salib Saya. Tapi pas hari ketiga pasti Allah kas hidup Sa kembali.” ");
INSERT INTO pmy_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Habis itu Zebedeus pu istri deng de pu anana dua itu datang ke Yesus, trus tunduk depan Yesus untuk minta satu hal ke Dia. ");
INSERT INTO pmy_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesus bilang, “Apa yang mama mau?” Mama itu jawab, “Waktu nanti di Bapa pu Krajaan, sa mau sa pu anana duduk printa sama-sama di samping Bapa, yang satu di sebla kanan deng yang satu lagi di sebla kiri.” ");
INSERT INTO pmy_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Tapi Yesus jawab dong begini, “Kam tra tau apa yang kam minta. Kam sanggup minum dari glas sengsara yang nanti Sa minum ka?” Trus dong jawab, “Tong sanggup.” ");
INSERT INTO pmy_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesus bilang dong dua, “Memang nanti kam juga sengsara macam Saya. Tapi kalo soal duduk di Sa pu sebla kanan ato kiri, Sa tra pu hak untuk kasi, itu nanti Sa pu Bapa yang kasi ke orang-orang yang De su pili.” ");
INSERT INTO pmy_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Dengar begitu, spulu murid yang lain dong mara sama ade kaka dua itu. ");
INSERT INTO pmy_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Tapi Yesus panggil dong baru bilang, “Kam su tau kalo pemimpin-pemimpin bangsa biasa tindas orang-orang yang dong pimpin, sama orang-orang yang pegang kuasa bikin apa saja yang dong mau ke dorang. ");
INSERT INTO pmy_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Tapi kam tra bole begitu. Sapa saja yang mo jadi lebi hebat dari yang lain, de harus layani yang lain, ");
INSERT INTO pmy_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","trus sapa saja dari kam yang mo jadi yang pertama, de harus jadi kam pu pesuru. ");
INSERT INTO pmy_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Sama sperti Sa Anak Manusia bukan datang untuk orang layani Saya, tapi untuk layani orang trus untuk kasi Sa pu hidup ganti banyak orang untuk kas bebas dorang.” ");
INSERT INTO pmy_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Waktu Yesus deng De pu murid-murid pigi dari Kota Yerikho, ada banyak orang yang ikut Dia. ");
INSERT INTO pmy_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Trus ada dua orang buta yang duduk di pinggir jalan. Waktu dong dengar kalo Yesus ada lewat, dong batariak, “Tuhan, Daud pu turunan, kasian tong ka!” ");
INSERT INTO pmy_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Tapi orang banyak itu tegur supaya dong diam. Tapi dong batariak lebi kras lagi, “Tuhan! Daud pu turunan, kasian tong ka!” ");
INSERT INTO pmy_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Dengar itu Yesus brenti baru panggil dorang. De bilang, “Kam mau Sa bikin apa untuk kam?” ");
INSERT INTO pmy_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Dong jawab, “Tuhan, tong mau supaya tong pu mata bisa liat.” ");
INSERT INTO pmy_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Dengar begitu, Yesus rasa kasian sama dorang, jadi De pegang dong pu mata. Waktu itu juga dong bisa liat trus dong dua ikut Yesus. ");
INSERT INTO pmy_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Waktu Yesus deng De pu murid-murid su dekat Kota Yerusalem, dong sampe di kampung Betfage yang di dekat kaki Bukit Zaitun, trus Yesus suru De pu murid dua orang ");
INSERT INTO pmy_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","deng bilang, “Kam dua pigi ke kampung yang di depan sana. Disana nanti kam dua ketemu kledai satu sama de pu anak yang dong ikat, kam dua kas lepas tali trus bawa ke Sa sini. ");
INSERT INTO pmy_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kalo ada orang yang tanya kam, bilang saja, ‘Tuhan De perlu ini. Nanti De langsung kas kembali lagi.’” ");
INSERT INTO pmy_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Begitu supaya Allah pu kata-kata dulu lewat De pu nabi tu su jadi, de bilang begini, ");
INSERT INTO pmy_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Bilang sama orang-orang Yerusalem, ‘Liat, kam pu Raja su datang, De renda hati jadi De duduk di atas kledai, kledai pu anak yang masi muda.’ ” ");
INSERT INTO pmy_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Trus murid dua itu pigi trus bikin sperti yang Yesus suru dong bikin. ");
INSERT INTO pmy_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Dong bawa kledai betina deng de pu anak, trus alas kledai pu blakang pake dong pu baju panjang, baru Yesus duduk di atas kledai. ");
INSERT INTO pmy_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ada orang banyak skali yang alas jalan pake dong pu baju-baju panjang, ada juga yang potong ranting-ranting pohon baru alas di jalan. ");
INSERT INTO pmy_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Banyak orang yang jalan di depan Yesus deng yang ikut De dari blakang batariak bilang, “Hosana!Mari puji Daud pu turunan! Allah berkati De yang datang dalam nama Tuhan, hosana di tempat tinggi!” ");
INSERT INTO pmy_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Waktu De masuk ke Yerusalem, kota itu jadi ribut skali baru orang-orang dong tanya, “Orang ini sapa ka?” ");
INSERT INTO pmy_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Trus orang banyak itu jawab, “Ini suda Nabi Yesus dari Nasaret di daera Galilea.” ");
INSERT INTO pmy_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Trus Yesus masuk ke Ruma Allah pu halaman baru usir orang smua yang ada jual bli disitu. De kas balik tukang tukar uang pu meja-meja deng tukang jual merpati pu bangku-bangku. ");
INSERT INTO pmy_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Baru De bilang sama dorang, “Ada tatulis to kalo Allah bilang, ‘Sa pu ruma harus jadi ruma doa.’ Tapi kam ni su bikin itu jadi pencuri pu tempat.” ");
INSERT INTO pmy_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Trus orang-orang buta deng orang-orang pincang datang ke De di halaman Ruma Allah itu baru De kas sembu dorang. ");
INSERT INTO pmy_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Tapi waktu imam-imam kepala deng guru-guru agama liat tanda-tanda heran yang De bikin baru anana yang batariak deng suara kras di halaman Ruma Allah, “Hosana! Mari puji Daud pu turunan!” dong jadi mara skali. ");
INSERT INTO pmy_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Trus dong bilang sama Yesus begini, “Ko dengar ka apa yang anana ini bicara?” Yesus bilang, “Iyo, Sa dengar. Kam blum perna baca ayat ini ka, ‘Tuhan su kas ajar bayi-bayi deng anana yang masi dapa kas susu supaya dong puji-puji Allah?’” ");
INSERT INTO pmy_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Habis itu De kas tinggal dong trus pigi kluar kota ke Betania baru tidur disitu. ");
INSERT INTO pmy_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","De pu besok begini, pagi-pagi skali Yesus dong kembali ke Yerusalem. Waktu di jalan Yesus rasa lapar. ");
INSERT INTO pmy_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Begini Yesus De liat ada pohon ara satu di pinggir jalan trus De pigi kesitu, tapi De tra ketemu apapa di pohon itu, hanya daun-daun saja. Begini De bilang ke pohon itu, “Mulai skarang ko trakan bua lagi trus-trus!” Tiba-tiba pohon ara itu langsung kring. ");
INSERT INTO pmy_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Waktu Yesus pu murid-murid liat apa yang su jadi tu, dong heran skali, deng bilang, “Apa yang bikin sampe pohon ara itu bisa langsung kring?” ");
INSERT INTO pmy_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesus jawab ke dorang, “Yang Sa bilang ini benar: Kalo kam percaya deng tra ragu-ragu, kam bukan cuma bisa bikin apa yang Sa ada bikin deng pohon ara itu saja, tapi kalo kam bicara ke gunung ini, ‘Trangkat baru talempar ke laut!’ pasti itu jadi. ");
INSERT INTO pmy_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Apa saja yang kam minta dalam kam pu doa, kam pasti trima itu kalo kam percaya.” ");
INSERT INTO pmy_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Trus Yesus masuk ke Ruma Allah. Waktu De ada kas ajar disitu, imam-imam kepala deng orang Yahudi pu tua-tua dong datang trus dong tanya, “Deng kuasa apa Ko bikin ini? Sapa yang kasi Ko kuasa untuk bikin ini smua?” ");
INSERT INTO pmy_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesus jawab dorang, “Sa juga mo tanya kam. Kalo kam bisa jawab apa yang Sa tanya, nanti Sa juga kastau kam deng kuasa apa Sa bikin hal-hal itu. ");
INSERT INTO pmy_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Deng kuasa dari mana Yohanes de kas baptis orang? Allah ato manusia?” Dengar begitu, dong sendiri bahas itu baru bilang, “Kalo tong bilang, ‘Deng Allah pu kuasa,’ De nanti bilang sama kitong, ‘Kalo begitu, knapa kam tra percaya dia?’ ");
INSERT INTO pmy_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Tapi kalo tong bilang, ‘Dari manusia,’ tong takut sama orang banyak, karna smua orang anggap Yohanes tu nabi.” ");
INSERT INTO pmy_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Jadi dong jawab Yesus, “Tong tra tau.” Yesus jawab sama dorang, “Kalo begitu, Sa juga tra kastau sama kam deng kuasa apa Sa bikin ini smua.” ");
INSERT INTO pmy_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesus lanjut bicara, “Coba kam pikir tentang conto satu ini. Ada bapa satu, de punya anak laki-laki dua orang. De pigi ke anak yang tua baru bilang, ‘Anak, hari ni ko pigi kerja di kebun anggur.’ ");
INSERT INTO pmy_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Anak itu jawab, ʻSa tra mau.ʼ Tapi habis itu de mnyesal trus de pigi. ");
INSERT INTO pmy_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Trus orang itu pigi ke de pu anak yang kedua baru bilang begitu juga. Anak itu jawab, ʻIyo bapa,ʼ tapi de tra pigi. ");
INSERT INTO pmy_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Dari antara anak dua itu, sapa yang bikin de pu bapa pu mau?” Dong jawab, “Anak yang tua.” Trus Yesus bilang sama dorang, “Yang Sa bilang ini benar: Tukang tagi pajak deng placur yang nanti duluan dari kam untuk masuk dalam Allah pu Krajaan. ");
INSERT INTO pmy_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Karna Yohanes datang untuk kas tunjuk jalan yang benar ke kam, trus kam tra percaya dia. Tapi tukang tagi pajak deng placur dong percaya dia. Padahal kam su liat apa yang dong bikin tapi kam tra bruba pikiran untuk percaya apa yang de bilang.” ");
INSERT INTO pmy_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesus lanjut bicara lagi, “Kam dengar satu conto lagi. Ada satu orang yang bikin kebun anggur deng bikin pagar kliling kebun. De gali lobang untuk tempat ramas anggur sama de bangun tempat jaga yang tinggi di dalam kebun itu. Habis itu de kas sewa kebun sama orang-orang yang kerja kebun itu, trus de brangkat ke tempat yang jau. ");
INSERT INTO pmy_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Waktu su masuk musim panen begini, de suru de pu pesuru-pesuru pigi ke orang-orang yang sewa kebun itu untuk trima hasil yang jadi de pu bagian. ");
INSERT INTO pmy_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Tapi dong tangkap de pu pesuru-pesuru itu, yang satu dong pukul, yang satu lagi dong bunu, yang lain lagi dapa lempar deng batu. ");
INSERT INTO pmy_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Habis itu, orang yang pu kebun itu suru de pu pesuru-pesuru yang lain lagi, lebi banyak dari yang pertama, tapi dong dapa bikin sama sperti dong pu teman-teman yang lain. ");
INSERT INTO pmy_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Jadi yang trakir de suru de pu anak yang pigi ke dorang. Karna de pikir, ‘De ini sa pu anak jadi pasti dong hormati dia.’ ");
INSERT INTO pmy_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Tapi begitu dong liat de pu anak itu, dong baku kastau begini, ‘De ini yang nanti pu hak di tana ini, mari tong bunu de supaya tana ini tong bisa ambil.’ ");
INSERT INTO pmy_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Jadi dong tangkap baru lempar de kluar kebun trus dong bunu anak itu.” ");
INSERT INTO pmy_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Trus Yesus tanya ke dorang, “Kalo orang yang pu kebun anggur itu datang, apa yang nanti de bikin sama orang-orang yang sewa kebun itu?” ");
INSERT INTO pmy_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Dong bilang sama Dia, “Pasti de bunu orang-orang jahat itu deng trada ampun, trus de kas sewa de pu kebun anggur ke orang-orang kerja kebun yang lain, yang nanti bisa kasi de pu hasil waktu musim panen.” ");
INSERT INTO pmy_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesus bilang sama dorang, “Kam blum perna baca dalam Kitab Suci ka, ‘Batu yang tukang-tukang bangunan dong buang, skarang jadi batu fondasi yang paling penting. Itu smua Tuhan yang bikin, itu hal luar biasa yang bikin tong heran skali.’ ");
INSERT INTO pmy_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Itu jadi, Sa mo bilang sama kam kalo kam pu hak untuk jadi Allah pu orang-orang di De pu Krajaan nanti dapa ambil dari kam, trus nanti hak itu dapa kasi ke bangsa lain yang kas hasil bua yang baik untuk Allah pu Krajaan. ");
INSERT INTO pmy_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Orang yang jatu kena batu itu, pasti de hancur. Juga kalo orang tatindis deng batu itu pasti de lebi hancur lagi.” ");
INSERT INTO pmy_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Waktu imam-imam kepala deng orang-orang Farisi dong dengar conto-conto yang Yesus bicara, dong tau kalo conto itu Yesus bicara kas sala dorang. ");
INSERT INTO pmy_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Dong cari cara untuk tangkap Yesus, tapi dong smua takut sama orang banyak, karna orang banyak dong anggap Yesus tu nabi. ");
INSERT INTO pmy_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Trus Yesus bicara pake conto-conto lagi sama dong begini, ");
INSERT INTO pmy_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Krajaan Surga tu sama sperti begini: Ada raja satu bikin pesta nika untuk de pu anak laki-laki. ");
INSERT INTO pmy_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","De suru de pu pesuru-pesuru panggil orang-orang yang su dapa undang ke pesta nika itu, tapi orang-orang itu tra mau datang. ");
INSERT INTO pmy_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Trus de suru de pu pesuru-pesuru yang lain lagi, deng pesan, ‘Bilang sama orang-orang yang su dapa undang tu: Sa su potong sapi jantan deng sa pu binatang piara lain yang gemuk, sa su kas siap smua. Jadi datang suda ke pesta nika ini.’ ");
INSERT INTO pmy_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Tapi orang-orang yang dapa undang tu tra peduli deng undangan itu, ada yang pigi ke de pu kebun, ada yang pigi urus de pu usaha. ");
INSERT INTO pmy_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Trus yang lain tangkap raja pu pesuru-pesuru itu, baru siksa deng bunu dorang. ");
INSERT INTO pmy_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Jadi raja de mara skali, trus suru de pu tentara-tentara kesana untuk bunu orang-orang yang su bunu de pu pesuru-pesuru itu trus bakar dong pu kota. ");
INSERT INTO pmy_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Habis itu de bilang pesuru-pesuru yang lain, ‘Pesta nika su siap, tapi orang-orang yang dapa undang tadi tra pantas untuk itu. ");
INSERT INTO pmy_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Jadi pigi ke jalan-jalan raya trus undang orang-orang yang kam ketemu disana untuk ikut pesta nika ini.’ ");
INSERT INTO pmy_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Trus pesuru-pesuru itu pigi baru dong kumpul orang smua yang dong ketemu di jalan-jalan, mo orang-orang jahat ka, ato orang-orang baik ka, sampe ruang tempat pesat nika tu penu deng tamu. ");
INSERT INTO pmy_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Waktu raja itu masuk untuk ketemu deng tamu-tamu itu, de liat ada orang satu yang tra pake pakean untuk pesta nika. ");
INSERT INTO pmy_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Raja itu bilang sama dia, ‘Sodara, bagemana sampe ko bisa masuk kesini deng tra pake pakean untuk pesta nika?’ Tapi orang itu de diam saja. ");
INSERT INTO pmy_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Trus raja itu bilang ke de pu pesuru-pesuru begini, ‘Ikat orang ini pu kaki deng tangan baru buang de ke tempat yang paling glap. Disana tu tempat orang mnangis sedi skali sampe gigi bunyi.’ ");
INSERT INTO pmy_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Karna ada banyak orang yang dapa panggil, tapi sdikit orang yang dapa pili.” ");
INSERT INTO pmy_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Habis itu brapa orang dari klompok Farisi dong pigi baru bikin rencana bagemana dong bisa jrat Yesus deng cara tipu-tipu tanya. ");
INSERT INTO pmy_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Dong suru dong pu pengikut-pengikut deng orang-orang yang dukung Herodes tanya sama Yesus, “Bapa Guru, tong tau Bapa ni orang yang jujur, trus kas ajar Allah pu mau deng benar, baru Bapa tra takut sapa-sapa karna Bapa tra kas beda-beda orang. ");
INSERT INTO pmy_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Jadi coba Bapa kastau sama kitong, mnurut tong pu aturan agama, tong bisa bayar pajak sama Raja Besar Roma ka tra bisa?” ");
INSERT INTO pmy_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Tapi Yesus tau dong pu rencana jahat itu jadi De bilang, “Eh! Orang-orang yang pura-pura baik, knapa kam coba Saya? ");
INSERT INTO pmy_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Coba kas liat sama Sa mata uang untuk pake bayar pajak.” Dong bawa uang logam perak satu ke Dia. ");
INSERT INTO pmy_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Trus De tanya sama dorang, “Ini sapa pu gambar deng nama?” ");
INSERT INTO pmy_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Dong jawab, “Raja Besar Roma pu gambar deng nama.” Trus Yesus bilang sama dorang, “Kalo begitu kasi sama Raja Besar Roma apa yang jadi Raja Besar Roma pu hak, trus kasi sama Allah apa yang jadi Allah pu hak.” ");
INSERT INTO pmy_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Dengar begitu, dong jadi heran skali, trus dong pigi kas tinggal Yesus. ");
INSERT INTO pmy_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Hari itu juga, orang-orang dari klompok Saduki datang ke Yesus, dong itu tra percaya kalo orang-orang mati nanti hidup kembali. Jadi dong tanya sama Yesus, ");
INSERT INTO pmy_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Bapa Guru! Dulu Musa bilang, ‘Kalo satu laki-laki de mati tapi dong tra pu anak, de pu sodara laki-laki musti kawin deng de pu istri supaya ada turunan untuk laki-laki yang su mati itu.’ ");
INSERT INTO pmy_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Tapi disini perna ada tuju orang sodara dong smua laki-laki. Yang sodara pertama kawin, tapi begini de mati. Tapi karna de trada anak, jadi de kas tinggal de pu istri untuk de pu sodara. ");
INSERT INTO pmy_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Sodara yang kedua deng sodara yang ketiga juga sama saja sampe yang ketuju. ");
INSERT INTO pmy_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Habis dong smua mati, prempuan itu juga mati. ");
INSERT INTO pmy_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Jadi waktu orang mati hidup kembali, dari tuju orang itu, sapa yang jadi prempuan itu pu suami? Karna dong smua su kawin deng dia.” ");
INSERT INTO pmy_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesus jawab dong begini, “Kam su sala skali, karna kam tra mngerti Kitab Suci deng juga Allah pu kuasa! ");
INSERT INTO pmy_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Karna di waktu orang-orang mati hidup kembali, dong tra kawin deng tra dapa kawin tapi dong sperti malaikat di surga. ");
INSERT INTO pmy_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Trus tentang orang mati nanti hidup kembali itu kam blum perna baca ka apa yang Allah bilang? ");
INSERT INTO pmy_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Sa ini Abraham, Ishak, deng Yakub dong pu Allah.’ Jadi De bukan Allah dari orang mati, tapi Allah dari orang yang hidup.” ");
INSERT INTO pmy_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Waktu orang banyak dengar Yesus pu ajaran, dong jadi heran skali. ");
INSERT INTO pmy_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Waktu orang-orang dari klompok Farisi dengar kalo Yesus su bikin orang-orang dari klompok Saduki tra bisa bicara apapa lagi, dong kumpul. ");
INSERT INTO pmy_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Baru satu orang dari dorang, de tu guru agama, de tanya untuk mo coba Dia, ");
INSERT INTO pmy_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Bapa Guru, printa mana yang paling penting dalam hukum Musa ka?” ");
INSERT INTO pmy_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesus jawab, “ ‘Sayang ko pu Tuhan Allah deng spenu hati, deng smua ko pu hidup, deng smua yang ko pikir.’ ");
INSERT INTO pmy_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Itu suda printa yang paling penting deng yang pertama. ");
INSERT INTO pmy_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Printa yang kedua, yang sama penting deng itu tu, ‘Sayang orang lain sama sperti ko sayang ko pu diri sendiri.’ ");
INSERT INTO pmy_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Dua printa ini suda yang jadi dasar dari smua hukum Musa deng nabi-nabi pu kitab.” ");
INSERT INTO pmy_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Waktu orang-orang dari klompok Farisi masi kumpul disitu, Yesus tanya sama dorang, ");
INSERT INTO pmy_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Apa yang kam pikir tentang Raja Yang Allah Pili? De tu sapa pu turunan?” Dong bilang, “Daud pu turunan.” ");
INSERT INTO pmy_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesus bilang, “Kalo begitu, waktu Roh Allah kuasai Daud, knapa sampe Daud sebut Raja Yang Allah Pili tu Tuhan? Yang Daud de bilang, ");
INSERT INTO pmy_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Tuhan Allah su bilang sama sa pu Tuhan: Duduk di Sa pu sebla kanan, sampe Ko pu musu-musu Sa taru di bawa Ko pu kaki.’ ");
INSERT INTO pmy_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Daud sebut De itu ʻTuhan,ʼ jadi De bukan hanya Daud pu turunan saja.” ");
INSERT INTO pmy_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Trada satu orang yang bisa jawab apa yang Yesus tanya. Jadi mulai dari hari itu, trada satu orang yang brani tanya-tanya lagi sama Dia. ");
INSERT INTO pmy_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Habis itu, Yesus bicara ke orang banyak deng De pu murid-murid begini, ");
INSERT INTO pmy_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Guru-guru agama deng orang-orang Farisi su duduk di Musa pu kursi. ");
INSERT INTO pmy_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Itu jadi, ikut deng bikin smua yang dong kas ajar ke kam. Tapi kam jang ikut apa yang dong bikin, karna dong tra bikin apa yang dong kas ajar. ");
INSERT INTO pmy_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Dong paksa orang ikut banyak aturan agama yang susa skali orang ikut, tapi dong sendiri tra mau tolong orang untuk ikut aturan itu mo sdikit juga. ");
INSERT INTO pmy_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Smua yang dong bikin tu untuk cari muka saja. De pu conto tu, dong bikin dong pu kotak ayat lebi besar deng di dong pu ujung baju panjang dong pake tali-tali lebi panjang. ");
INSERT INTO pmy_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Dong snang duduk paling depan di pesta-pesta deng di tempat ibada, ");
INSERT INTO pmy_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","trus dong mau skali dapat hormat di pasar, trus dong snang orang panggil dong ʻGuru.ʼ ");
INSERT INTO pmy_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Tapi kam jang mo dapa panggil ʻGuru,ʼ karna kam pu Guru hanya satu saja, baru kam smua tu baku sodara. ");
INSERT INTO pmy_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Di dunia ini kam jang panggil sapa saja ʻbapaʼ untuk hormat dia, karna kam pu Bapa hanya satu, itu De yang di surga. ");
INSERT INTO pmy_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kam jang mo dapa panggil ʻpemimpin,ʼ karna kam pu Pemimpin tu hanya satu saja, De tu Raja Yang Allah Pili. ");
INSERT INTO pmy_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Orang yang paling hebat di antara kam tu orang yang layani orang lain. ");
INSERT INTO pmy_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Sapa saja yang angkat diri, nanti de dapa kas renda, tapi orang yang kas renda diri, nanti de dapa angkat. ");
INSERT INTO pmy_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Claka kam, guru-guru agama deng orang-orang Farisi, kam tu orang-orang yang pura-pura baik! Kalo ada orang yang mo masuk dalam Krajaan Surga, kam pele-pele. Kam sendiri tra mo masuk, trus untuk orang lain yang mau, kam pele-pele dong.  ");
INSERT INTO pmy_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Kam claka skali, guru-guru agama deng orang-orang Farisi, kam tu orang-orang yang pura-pura baik! Karna kam biasa tipu janda-janda untuk ambil paksa dong pu ruma. Trus untuk tutup kam pu klakuan jahat itu, kam doa yang panjang-panjang. Itu jadi kam pasti trima hukuman yang lebi brat. ");
INSERT INTO pmy_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Kam claka skali, guru-guru agama deng orang-orang Farisi, kam tu orang-orang yang pura-pura baik! Karna kam pigi ke mana-mana lewat laut deng jalan darat, untuk bikin satu orang saja masuk kam pu agama. Habis itu kam bikin de jadi dua kali lebi jahat dari kam, de pantas masuk neraka sama macam kam. ");
INSERT INTO pmy_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Kam claka skali, kam orang buta yang pimpin orang lain! Kam kas ajar kalo ambil sumpa pake nama Ruma Allah, orang itu tra taikat deng sumpa itu, tapi kalo ambil sumpa pake nama emas yang ada di Ruma Allah, orang itu taikat deng sumpa itu. ");
INSERT INTO pmy_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Kam tu orang-orang bodok deng buta! Mana yang lebi penting, emas ato Ruma Allah yang kas kusus emas itu? ");
INSERT INTO pmy_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kam kas ajar juga kalo ambil sumpa pake nama tempat bakar, orang itu tra taikat deng sumpa itu, tapi kalo ambil sumpa pake nama persembahan yang di atas tempat bakar, orang itu taikat deng sumpa itu. ");
INSERT INTO pmy_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Kam memang buta skali! Mana yang lebi penting? Persembahan ato tempat bakar yang kas kusus persembahan itu? ");
INSERT INTO pmy_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Itu jadi, sapa saja yang ambil sumpa pake nama tempat bakar, de su ambil sumpa pake nama tempat bakar deng juga pake nama barang yang ada di atas situ. ");
INSERT INTO pmy_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Sapa saja yang ambil sumpa pake nama Ruma Allah, de su ambil sumpa pake nama Ruma Allah deng juga pake nama Allah yang tinggal disitu. ");
INSERT INTO pmy_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Sapa saja yang ambil sumpa pake nama surga, de su ambil sumpa pake nama Allah pu kursi raja deng juga pake nama Allah yang ada duduk di kursi raja itu. ");
INSERT INTO pmy_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Kam claka skali, guru-guru agama deng orang-orang Farisi, kam tu orang-orang yang pura-pura baik! Kam pu tanaman bumbu macam selasi, adas manis, deng jintan, kam kasi de pu seperspulu sama Allah. Tapi yang lebi penting dari hukum Musa kam tra bikin, sperti bikin yang betul sama orang lain, kasian orang, deng setia. Itu yang harus kam bikin, trus jang lupa bikin yang lain juga. ");
INSERT INTO pmy_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Kam tu orang buta yang pimpin orang lain! Kam tapis lalat kecil dari dalam kam pu minum, tapi unta yang ada di dalam kam pu minum, kam telan. ");
INSERT INTO pmy_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Kam claka skali, guru-guru agama deng orang-orang Farisi, kam tu orang-orang yang pura-pura baik! Karna piring deng mangkok kam kas bersi de pu sebla luar, tapi de pu sebla dalam penu deng kotoran dari kam rampas orang pu harta karna kam rakus. ");
INSERT INTO pmy_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Kam tu orang Farisi yang buta! Kas bersi baik-baik mangkok pu sebla dalam dulu, supaya de pu sebla luar nanti ikut bersi. ");
INSERT INTO pmy_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Kam claka skali, guru-guru agama deng orang-orang Farisi, kam tu orang-orang yang pura-pura baik! Karna kam sama deng kubur yang dong cet puti, yang de pu sebla luar memang kliatan bagus skali, tapi de pu sebla dalam penu deng orang mati pu tulang-tulang deng macam-macam barang-barang busuk. ");
INSERT INTO pmy_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Begitu juga deng kam, dari luar kam kliatan baik sama smua orang, tapi di dalam kam paling jahat. Betul-betul kam pura-pura baik saja. ");
INSERT INTO pmy_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Claka skali kam, guru-guru agama deng orang-orang Farisi, kam tu orang-orang yang pura-pura baik! Karna kam bikin kubur bagus-bagus untuk nabi-nabi, deng kas hias tugu dari orang-orang yang ikut Allah pu mau. ");
INSERT INTO pmy_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Baru kam bilang, ‘Kalo tong hidup di jaman tong pu moyang ni, tong trakan ikut dong bunu nabi-nabi itu.’ ");
INSERT INTO pmy_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Deng begitu, kam sendiri su kas bukti kalo kam memang turunan dari orang-orang yang su bunu nabi. ");
INSERT INTO pmy_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Jadi, bikin sampe slesai suda apa yang kam pu nene moyang dong su bikin! ");
INSERT INTO pmy_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Kam tu ular-ular, kam tu turunan ular bisa! Allah pasti hukum kam masuk neraka! Jang harap kam bisa lolos! ");
INSERT INTO pmy_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Jadi, dengar baik-baik, nanti Sa utus nabi-nabi, orang-orang yang mngerti smua deng baik, deng guru-guru agama ke kam. Brapa dari dong nanti ada yang kam bunu, ada yang kam kas salib, yang lain nanti kam cambuk di kam pu tempat-tempat ibada baru kam kejar-kejar dong dari kota ke kota. ");
INSERT INTO pmy_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Jadi nanti kam dapa hukum karna smua orang yang tra sala yang dapa bunu di bumi, mulai dari Habel yang tra sala tu, sampe waktu Berekhya pu anak Zakharia yang kam pu nene moyang bunu di Ruma Allah di tenga dari Tempat Suci deng tempat bakar korban. ");
INSERT INTO pmy_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Yang Sa bilang ini benar: Kam yang skarang tinggal di jaman ini yang nanti dapa hukum karna smua yang dong bikin itu!” ");
INSERT INTO pmy_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Sayang skali orang-orang Yerusalem! Kam yang bunu nabi-nabi, trus Allah pu utusan kam lempar deng batu sampe mati! Ulang-ulang kali Sa mo kas kumpul kam smua sperti ayam betina kas kumpul de pu anana di bawa de pu sayap, tapi kam tra mau. ");
INSERT INTO pmy_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Itu jadi Allah De mo lepas tangan dari kam smua deng kam pu kota jadi sunyi. ");
INSERT INTO pmy_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Sa bilang kam, mulai skarang kam trakan liat Sa lagi, sampe kam bilang, ‘Allah berkati De yang datang dalam nama Tuhan.’ ” ");
INSERT INTO pmy_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Habis itu Yesus kluar dari Ruma Allah, trus pigi. De pu murid-murid datang ke De baru kas tunjuk gedung-gedung Ruma Allah pu bagus-bagus. ");
INSERT INTO pmy_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yesus bilang ke dorang, “Kam su liat itu smua? Yang Sa bilang ini benar: Nanti trada satu batu disini yang dapa kas biar tinggal di atas batu yang lain, smua gedung ini nanti dapa kas hancur.” ");
INSERT INTO pmy_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Waktu Yesus duduk di Bukit Zaitun, De pu murid-murid datang untuk bicara sendiri deng Dia. Baru dong bilang, “Kastau sama kitong, kapan itu mo jadi, trus apa de pu tanda kalo Bapa pu waktu untuk datang kembali su tiba, trus tanda apa yang kas tunjuk kalo itu su akir jaman?” ");
INSERT INTO pmy_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesus jawab, “Hati-hati, supaya jang ada orang yang tipu kam! ");
INSERT INTO pmy_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Karna nanti ada orang banyak yang datang pake Sa pu nama baru bilang, ‘Sa ini Raja Yang Allah Pili,’ trus dong tipu orang banyak. ");
INSERT INTO pmy_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nanti kam dengar suara-suara prang ato brita-brita tentang prang. Tapi ingat, kam jang gelisa, karna smua itu harus jadi, tapi itu blum akir jaman. ");
INSERT INTO pmy_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Karna bangsa satu mo prang deng bangsa lain, juga negara satu deng negara lain. Nanti ada klaparan deng gempa bumi di mana-mana. ");
INSERT INTO pmy_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Tapi smua itu baru tanda-tanda awal saja untuk akir jaman, sama sperti prempuan yang de mulai rasa sakit waktu mo lahir anak. ");
INSERT INTO pmy_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Di waktu itu tu nanti dong kasi kam untuk dapa siksa, baru dong bunu kam. Trus smua bangsa nanti tra suka kam skali karna kam ikut Saya. ");
INSERT INTO pmy_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Trus ada banyak orang percaya yang kecewa trus tolak Saya, sampe dong baku tra suka deng baku jual teman sendiri. ");
INSERT INTO pmy_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Nanti muncul banyak orang yang pura-pura jadi nabi, baru dong kas sesat orang banyak. ");
INSERT INTO pmy_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Trus karna banyak orang yang tamba jahat, jadi banyak orang pu rasa sayang ke orang lain mulai hilang. ");
INSERT INTO pmy_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Tapi orang yang tahan sampe trakir pasti slamat. ");
INSERT INTO pmy_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Nanti orang-orang kastau Brita Baik tentang Allah pu Krajaan ke sluru bumi sama ke smua bangsa. Smua itu harus jadi, baru akir jaman.” ");
INSERT INTO pmy_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Dulu Nabi Daniel su tulis tentang ini: Nanti kam liat satu barang yang paling jahat yang bikin hancur, bediri di tempat suci di Ruma Allah ‒ yang baca harus pratikan ini baik-baik. ");
INSERT INTO pmy_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Waktu itu orang-orang yang di Yudea harus lari ke gunung-gunung. ");
INSERT INTO pmy_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Waktu itu, orang yang ada di atas ruma, jang de masuk untuk ambil de pu barang-barang di dalam de pu ruma. ");
INSERT INTO pmy_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Trus orang yang ada di kebun, jang kembali untuk ambil de pu pakean. ");
INSERT INTO pmy_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kasian skali prempuan-prempuan yang ada hamil ato yang masi kas susu bayi pas waktu itu. ");
INSERT INTO pmy_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Berdoa supaya waktu kam lari untuk sembunyi jang jadi di musim dingin ato di hari Sabat. ");
INSERT INTO pmy_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Karna di waktu itu nanti orang dapa siksa yang hebat skali sperti yang blum perna jadi, mulai dari dunia ini ada sampe skarang, deng nanti siksa sperti itu trakan perna jadi lagi. ");
INSERT INTO pmy_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Kalo Tuhan tra kas kurang waktu itu, nanti trada satu orang juga yang slamat, tapi karna ada orang-orang yang De su pili jadi De kas kurang waktu itu. ");
INSERT INTO pmy_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Pas waktu itu kalo ada orang yang bilang ke kam, ‘Liat, Raja Yang Allah Pili ada disini,’ ato ‘Raja Yang Allah Pili ada disana,’ kam jang percaya. ");
INSERT INTO pmy_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Karna nanti dong yang pura-pura jadi Raja Yang Allah Pili sama dong yang pura-pura jadi nabi-nabi, dong datang baru bikin tanda-tanda heran deng hal-hal yang luar biasa, supaya kalo bisa, dong kas sesat orang-orang yang Allah pili juga. ");
INSERT INTO pmy_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ingat baik-baik, Sa su kastau smua ini duluan ke kam. ");
INSERT INTO pmy_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Jadi, kalo orang bicara ke kam, ‘Liat, De ada di tempat sepi yang kring,’ kam jang pigi kesitu, ato ‘Liat, De ada sembunyi di dalam kamar sini,’ kam jang percaya. ");
INSERT INTO pmy_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Karna nanti waktu Sa Anak Manusia datang itu sperti kilat pica di langit, yang kas kluar de pu sinar dari timur sampe ke barat. ");
INSERT INTO pmy_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Dimana bangkai ada, disitu ada banyak burung bangkai yang kumpul.” ");
INSERT INTO pmy_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Begitu pas waktu sengsara itu habis, matahari jadi glap deng bulan pu sinar trada lagi. Trus bintang-bintang jatu-jatu dari langit, sama kuasa-kuasa di langit jadi kaco. ");
INSERT INTO pmy_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Pas waktu itu nanti ada tanda Sa Anak Manusia muncul di langit, trus smua suku bangsa di bumi mnangis deng sedi skali baru dong liat Sa Anak Manusia datang deng awan-awan di langit deng kuasa yang besar deng sinar yang trang. ");
INSERT INTO pmy_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Trus Sa nanti suru Sa pu malaikat-malaikat kluar waktu ada bunyi trompet yang kuat skali, baru dong kumpul orang-orang yang Sa pili dari smua tempat di bumi, dari ujung langit yang satu ke ujung langit yang lain.” ");
INSERT INTO pmy_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Coba blajar dari conto pohon ara. Kalo di de pu cabang-cabang mulai lembek baru kas kluar tunas, kam tau kalo su mo musim panas. ");
INSERT INTO pmy_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Begitu juga kalo kam liat smua itu jadi, kam tau kalo de pu waktu su dekat, su ada di depan pintu. ");
INSERT INTO pmy_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Yang Sa bilang ini benar: Seblum smua orang yang hidup skarang ini mati, smua itu jadi dulu. ");
INSERT INTO pmy_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Langit deng bumi nanti hilang, tapi Sa pu kata-kata trakan hilang. ");
INSERT INTO pmy_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Tapi tentang hari itu deng de pu waktu, trada satu orang juga yang tau, malaikat-malaikat di surga juga tra tau, Sa Allah pu Anak sendiri juga tra tau, cuma Bapa sendiri yang tau.” ");
INSERT INTO pmy_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Begitu juga waktu Sa Anak Manusia datang kembali, orang-orang pu hidup sama sperti Nuh pu jaman. ");
INSERT INTO pmy_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Karna di jaman seblum banjir besar itu, orang-orang makan, minum, kawin deng dapa kawin, begitu trus sampe Nuh masuk dalam kapal besar. ");
INSERT INTO pmy_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Dong tra tau apapa, sampe banjir besar itu datang baru kas habis dong smua. Nanti de pu keadaan sperti begitu suda waktu Sa Anak Manusia datang kembali. ");
INSERT INTO pmy_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Di waktu itu, kalo ada dua orang di kebun, yang satu dapa bawa trus yang satu dapa kas tinggal. ");
INSERT INTO pmy_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Kalo ada dua prempuan yang putar batu untuk giling biji gandum, yang satu dapa bawa trus yang satu dapa kas tinggal. ");
INSERT INTO pmy_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Jadi kam harus jaga-jaga, karna kam tra tau kapan kam pu Tuhan datang. ");
INSERT INTO pmy_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ingat conto ini, kalo tuan ruma de tau jam brapa pencuri mo datang, pasti de su jaga-jaga, trus tra kas biar de pu ruma dong bongkar to? ");
INSERT INTO pmy_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Itu jadi, kam juga harus siap-siap, karna Sa Anak Manusia datang di waktu-waktu yang kam tra kira.” ");
INSERT INTO pmy_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Kalo ada pesuru yang setia deng yang pu cara pikir paling baik, pasti de pu tuan angkat de jadi kepala dari pesuru yang lain supaya de yang atur dong pu makan. ");
INSERT INTO pmy_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kalo de pu tuan kembali trus liat de ada bikin de pu tugas, untung skali pesuru itu. ");
INSERT INTO pmy_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Yang Sa bilang ini benar: Tuan itu pasti kasi pesuru itu untuk atur de pu harta smua. ");
INSERT INTO pmy_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Tapi kalo pesuru itu jahat pasti de bicara dalam de pu hati, ");
INSERT INTO pmy_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","‘Sa pu tuan ini de lama baru kembali,’ trus de mulai pukul pesuru-pesuru yang lain baru makan deng minum sama tukang mabuk dorang. ");
INSERT INTO pmy_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Baru de pu tuan kembali di hari deng jam yang de tra kira. ");
INSERT INTO pmy_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Jadi pesuru itu de dapa hajar sampe habis-abis dari de pu tuan trus de dapa buang ke tempat orang-orang yang pura-pura baik. Disana tu tempat orang mnangis sedi skali sampe gigi bunyi.” ");
INSERT INTO pmy_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yesus bilang lagi, “Krajaan Surga tu sama sperti nona spulu yang ambil dong pu plita baru pigi sambut pengantin laki-laki. ");
INSERT INTO pmy_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Dari antara dorang, ada lima nona yang bodo deng lima yang pu cara pikir paling baik. ");
INSERT INTO pmy_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Nona-nona yang bodo tu bawa dong pu plita tapi tra bawa minyak lebi untuk jaga-jaga, ");
INSERT INTO pmy_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","baru nona-nona yang pu cara pikir paling baik tu bawa dong pu plita deng minyak lebi juga dalam dong pu tempat minyak. ");
INSERT INTO pmy_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tapi karna pengantin itu datang lambat jadi dong smua tunggu sampe mngantuk trus tatidur. ");
INSERT INTO pmy_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Waktu tenga malam begini, dong dengar suara orang batariak, ‘Pengantin datang! Mari, sambut dia!’ ");
INSERT INTO pmy_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Nona-nona itu smua bangun baru kas beres dong pu plita. ");
INSERT INTO pmy_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Nona-nona yang bodo bilang sama nona-nona yang pu cara pikir paling baik, ‘Kasi kam pu minyak sdikit untuk tong ka, karna tong pu plita mo padam.’ ");
INSERT INTO pmy_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Tapi nona-nona yang pu cara pikir paling baik itu dong jawab, ‘Tra bisa, nanti tra cukup untuk tong deng untuk kam juga. Lebi baik kam pigi ke tukang jual minyak baru bli disitu.’ ");
INSERT INTO pmy_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Tapi waktu dong ada pigi untuk bli minyak begini, pengantin itu datang. Dong yang su siap tu masuk sama-sama deng pengantin itu ke ruang pesta nika, baru orang dong tutup pintu. ");
INSERT INTO pmy_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Habis itu, nona-nona yang lain itu datang baru bilang, ‘Bapa, bapa, buka pintu untuk tong ka!’ ");
INSERT INTO pmy_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Tapi pengantin de jawab, ‘Yang sa bilang ini benar, sa tra knal kam.’ ");
INSERT INTO pmy_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jadi kam harus jaga-jaga trus. Karna kam tra tau kapan de pu hari ato de pu waktu.” ");
INSERT INTO pmy_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Krajaan Surga tu sama sperti satu orang yang mo pigi ke tempat yang jau, yang panggil de pu pesuru-pesuru baru de kasi stiap orang satu tanggung jawab. ");
INSERT INTO pmy_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Yang satu de kasi koin emas lima kantong, yang satu lagi dua kantong trus yang satu lagi satu kantong, masing-masing dapa kasi sama sperti yang de bisa, baru tuan itu brangkat. ");
INSERT INTO pmy_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Pesuru yang trima koin emas lima kantong tu langsung pigi pake uang itu kas jalan satu usaha trus de dapat untung koin emas lima kantong lagi. ");
INSERT INTO pmy_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Pesuru yang trima koin emas dua kantong tu bikin begitu juga, trus dapat untung koin emas dua kantong lagi. ");
INSERT INTO pmy_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Tapi pesuru yang trima koin emas satu kantong ni, de pigi baru gali lobang di tana trus kas sembunyi de pu tuan pu uang itu. ");
INSERT INTO pmy_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Habis itu, lama skali baru dong pu tuan pulang. Trus de panggil dong untuk hitung dong pu hasil dari uang itu. ");
INSERT INTO pmy_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Pesuru yang trima koin emas lima kantong tu datang baru de bawa hasil lima kantong lagi, baru de bilang, ‘Tuan, koin emas lima kantong yang tuan su kas percaya ke saya, tuan liat, sa su dapat untung lima kantong lagi.’ ");
INSERT INTO pmy_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Trus de pu tuan bilang sama dia, ‘Bagus skali yang ko su bikin, ko pesuru yang baik deng bisa dapa percaya. Untuk hal kecil ko su bisa dapa percaya, nanti sa kasi sama ko tanggung jawab yang besar. Masuk suda baru ikut snang-snang deng saya.’ ");
INSERT INTO pmy_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Habis itu, pesuru yang trima koin emas dua kantong tu datang baru bilang, ‘Tuan, koin emas dua kantong yang tuan su kas percaya ke saya, tuan liat, sa su dapat untung dua kantong lagi.’ ");
INSERT INTO pmy_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Trus de pu tuan bilang sama dia, ‘Bagus skali yang ko su bikin, ko pesuru yang baik deng bisa dapa percaya. Untuk hal kecil ko su bisa dapa percaya, nanti sa kasi sama ko tanggung jawab yang besar. Masuk suda baru ikut snang-snang deng saya.’ ");
INSERT INTO pmy_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Habis itu, pesuru yang trima koin emas satu kantong tu datang deng bilang, ‘Tuan, sa tau kalo tuan orang yang kras. Tuan petik bua di tempat yang tuan tra perna tanam, trus tuan ambil hasil di tempat yang tuan tra perna tanam bibit. ");
INSERT INTO pmy_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Itu jadi, sa takut trus pigi kas sembunyi tuan pu koin emas itu di dalam tana. Ini tuan, ambil tuan pu uang kembali!’ ");
INSERT INTO pmy_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","De pu tuan jawab, ‘Eh, ko tu pesuru yang jahat baru pamalas! Jadi ko su tau sa petik bua di tempat yang sa tra perna tanam, trus sa ambil hasil di tempat yang sa tra perna tanam bibit? ");
INSERT INTO pmy_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Kalo begitu ko harus kasi sa pu uang itu ke bank, supaya waktu sa kembali, sa bisa trima sama de pu bunga lagi.’ ");
INSERT INTO pmy_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Jadi tuan itu bilang ke pesuru yang lain, ‘Ambil uang itu dari orang itu trus kasi sama orang yang pu spulu kantong koin emas itu. ");
INSERT INTO pmy_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Karna orang yang urus deng baik apa yang de dapat, nanti de dapa kasi lebi banyak lagi sampe de punya banyak skali, tapi orang yang tra urus deng baik apa yang de dapat, nanti itu juga dapa ambil dari dia. ");
INSERT INTO pmy_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Jadi skarang, buang pesuru yang trada guna tu ke tempat yang paling glap. Disana tu tempat orang mnangis sedi skali sampe gigi bunyi.’ ” ");
INSERT INTO pmy_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Waktu Sa Anak Manusia datang kembali jadi Raja deng malaikat smua ikut sama-sama deng Saya, nanti Sa duduk di Sa pu kursi raja yang luar biasa. ");
INSERT INTO pmy_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Trus bangsa-bangsa smua di bumi dapa kumpul di depan Saya, baru Sa kas pisa dong jadi dua bagian, sama sperti gembala kas pisa domba dari kambing. ");
INSERT INTO pmy_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Trus Sa taru orang-orang yang ikut Allah pu mau di Sa pu sebla kanan, baru orang-orang lain di Sa pu sebla kiri. ");
INSERT INTO pmy_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Trus Sa yang jadi Raja nanti bilang sama dong yang di Sa pu sebla kanan, ‘Mari, kam ni orang-orang yang su dapat berkat dari Sa pu Bapa. Masuk suda ke dalam Krajaan yang Allah su kas siap untuk kam dari waktu Allah bikin dunia ini. ");
INSERT INTO pmy_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Karna waktu Sa lapar, kam kasi Sa makan. Waktu Sa haus, kam kasi Sa minum. Waktu Sa jadi orang pendatang, kam trima Sa di kam pu ruma. ");
INSERT INTO pmy_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Waktu Sa trada pakean, kam kasi Sa pakean. Waktu Sa sakit, kam pigi urus Saya. Waktu Sa dapa tahan di penjara, kam pigi liat Saya.’ ");
INSERT INTO pmy_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Trus orang-orang yang ikut Allah pu mau tu dong jawab, ‘Tuhan, kapan tong liat Tuhan lapar baru kasi Tuhan makan, ato haus baru tong kasi Tuhan minum? ");
INSERT INTO pmy_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kapan tong liat Tuhan jadi orang pendatang trus trima di tong pu ruma, ato trada pakean trus tong kasi Tuhan pakean? ");
INSERT INTO pmy_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kapan tong liat Tuhan sakit ato dalam penjara baru tong pigi liat Tuhan?’ ");
INSERT INTO pmy_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Trus Sa yang jadi Raja nanti jawab, ‘Yang Sa bilang ini benar: Smua yang kam bikin untuk satu dari Sa pu sodara yang paling renda ni, itu kam su bikin untuk Saya.’ ");
INSERT INTO pmy_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Baru Sa bilang juga sama orang-orang yang di Sa pu sebla kiri, ‘Pigi dari sini! Allah su kutuk kam, pigi ke dalam api yang tra bisa padam yang Allah su kas siap untuk Iblis deng de pu pesuru-pesuru. ");
INSERT INTO pmy_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Karna waktu Sa lapar, kam tra kasi Sa makan. Waktu Sa haus, kam tra kasi Sa minum. ");
INSERT INTO pmy_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Waktu Sa jadi orang pendatang, kam tra trima Sa di kam pu ruma. Waktu Sa trada pakean, kam tra kasi Sa pakean. Waktu Sa sakit deng dalam penjara, kam tra pigi liat Saya.’ ");
INSERT INTO pmy_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Trus dong juga jawab, ‘Tuhan, kapan tong ada liat Tuhan lapar, ato haus, ato sperti orang pendatang, ato trada pakean, ato sakit ato dalam penjara baru tong tra tolong Tuhan?’ ");
INSERT INTO pmy_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Baru Sa jawab dong begini, ‘Yang Sa bilang ini benar: Waktu kam tra tolong satu dari orang yang paling renda ini, brarti kam tra tolong Sa juga.’ ");
INSERT INTO pmy_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Orang-orang ini nanti masuk ke tempat dapa hukum yang trada akir, tapi orang-orang yang ikut Allah pu mau nanti dapat hidup yang trada akir.” ");
INSERT INTO pmy_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Habis Yesus slesai kas ajar smua itu, Yesus bilang ke De pu murid-murid begini, ");
INSERT INTO pmy_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Kam tau to, kalo dua hari lagi ada hari besar Paska, pas waktu itu, ada yang mo kasi Sa Anak Manusia untuk dapa kas salib.” ");
INSERT INTO pmy_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Pas waktu itu, imam-imam kepala deng orang Yahudi pu tua-tua dong smua kumpul di Kayafas pu istana. De ni Pemimpin Imam. ");
INSERT INTO pmy_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Dong atur rencana mo tangkap Yesus diam-diam deng cara tipu, untuk bunu Dia. ");
INSERT INTO pmy_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Tapi dong bilang, “Tra bole pas di hari besar supaya orang-orang dong jang kaco.” ");
INSERT INTO pmy_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Waktu Yesus ada di Betania, di Simon yang dulu sakit kulit busuk pu ruma, ");
INSERT INTO pmy_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","waktu Yesus ada duduk makan, ada prempuan satu yang datang bawa minyak wangi yang mahal di dalam botol dari batu puti. De kas pake minyak itu ke atas Yesus pu kepala. ");
INSERT INTO pmy_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Murid-murid yang liat itu dong tra snang trus bilang, “Untuk apa de buang-buang minyak sperti itu? ");
INSERT INTO pmy_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Karna minyak itu kalo jual de pu harga mahal trus uang itu bisa kasi ke orang-orang miskin.” ");
INSERT INTO pmy_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Tapi Yesus tau yang dong bicara, jadi De bilang, “Knapa kam bikin susa prempuan ini? De su bikin yang baik ke Saya. ");
INSERT INTO pmy_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Karna orang-orang miskin tu ada trus deng kam. Tapi Sa trakan ada sama-sama trus deng kam. ");
INSERT INTO pmy_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","De kas pake Sa minyak ini untuk kas siap Sa pu badan nanti dapa kubur. ");
INSERT INTO pmy_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Yang Sa bilang ini benar: Dimana saja Brita Baik ini orang kastau di sluru dunia, dong juga nanti ingat apa yang de bikin ini.” ");
INSERT INTO pmy_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Habis itu, satu orang dari Yesus pu duablas murid yang de pu nama Yudas Iskariot, pigi ke imam-imam kepala. ");
INSERT INTO pmy_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","De bilang, “Apa yang nanti kam kasi untuk saya, kalo sa jual De ke kam?” Dong bayar de deng 30 uang perak. ");
INSERT INTO pmy_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Trus dari situ, de mulai cari waktu yang pas untuk jual Yesus. ");
INSERT INTO pmy_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pas hari pertama dari hari besar Roti Tra Pake Ragi, Yesus pu murid-murid datang ke Dia. Baru dong bilang, “Dimana Bapa mau tong kas siap makanan Paska untuk Bapa?” ");
INSERT INTO pmy_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yesus jawab, “Pigi ke laki-laki satu yang di kota situ baru bilang de begini, ‘Guru De pesan: Sa pu waktu su dekat. Sa deng Sa pu murid-murid mo makan Paska di ko pu ruma.’ ” ");
INSERT INTO pmy_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Habis itu, De pu murid-murid bikin sperti yang Yesus kas tugas ke dong, trus dong kas siap makanan Paska. ");
INSERT INTO pmy_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Waktu hari su malam, Yesus duduk makan deng De pu duablas murid itu. ");
INSERT INTO pmy_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Waktu dong ada makan, De bilang, “Yang Sa bilang ini benar: Ada satu orang dari kam yang nanti jual Saya.” ");
INSERT INTO pmy_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Trus deng hati yang sedi skali dong satu-satu orang bilang ke Dia, “Tuhan, bukan sa to?” ");
INSERT INTO pmy_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","De jawab, “Orang yang ada colo roti ke dalam mangkok sama-sama deng Saya, de yang mo jual Saya. ");
INSERT INTO pmy_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Sa Anak Manusia memang nanti mati, sama sperti yang ada tatulis tentang Saya, tapi claka untuk orang yang jual Sa Anak Manusia. Lebi baik untuk orang itu kalo de tra perna lahir.” ");
INSERT INTO pmy_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yudas, yang mo jual Yesus tu de bilang begini, “Guru, bukan sa to?” Yesus bilang, “Ko sendiri yang su bilang itu.” ");
INSERT INTO pmy_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Waktu dong ada makan, Yesus ambil roti, baru doa syukur ke Allah. Trus De pata-pata roti, baru kasi ke De pu murid-murid deng bilang, “Ambil baru makan, ini Sa pu badan.” ");
INSERT INTO pmy_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Habis itu De ambil glas anggur, doa syukur ke Allah trus kasi ke dong baru bilang, “Kam smua minum dari glas anggur ini. ");
INSERT INTO pmy_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Karna ini Sa pu dara yang bikin sah Allah pu janji, yang tatumpa untuk banyak orang, untuk kas ampun dosa. ");
INSERT INTO pmy_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Sa bilang kam, habis ini, Sa trakan minum hasil anggur sperti ini lagi sampe hari yang Sa minum hasil anggur yang baru sama-sama deng kam, di Sa pu Allah Bapa pu Krajaan.” ");
INSERT INTO pmy_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Habis mnyanyi puji-puji Allah, Yesus deng De pu murid-murid pigi ke Bukit Zaitun. ");
INSERT INTO pmy_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Trus Yesus bilang ke dorang, “Malam ini, nanti kam smua kas tinggal Saya, karna apa yang mo jadi sama Sa. Sperti ada tatulis, Allah bilang, ‘Sa nanti pukul kas mati gembala, trus domba-domba itu lari tapisa-pisa.’ ");
INSERT INTO pmy_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Tapi stela Sa hidup kembali, Sa nanti duluan kam ke Galilea.” ");
INSERT INTO pmy_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petrus jawab Dia, “Biar dong smua kas tinggal Bapa karna apa yang mo jadi sama Bapa, sa sama skali tidak!” ");
INSERT INTO pmy_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesus bilang ke dia, “Yang Sa bilang ini benar: Malam ini seblum ayam berkokok, ko su bilang tra knal Sa tiga kali.” ");
INSERT INTO pmy_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petrus bilang, “Biar sa harus mati sama-sama deng Bapa juga, sa trakan bilang sa tra knal Bapa.” Smua murid-murid yang lain juga bilang begitu. ");
INSERT INTO pmy_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Habis itu Yesus deng De pu murid-murid pigi ke tempat satu yang de pu nama Getsemani. Trus Yesus bilang ke De pu murid-murid, “Kam duduk disini, Sa mo pigi berdoa dulu disana.” ");
INSERT INTO pmy_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Trus De bawa Petrus deng Zebedeus pu dua anak lagi ikut sama-sama deng Dia. Trus De mulai rasa susa deng gelisa, ");
INSERT INTO pmy_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","trus De bilang ke dorang, “Sa pu hati hancur skali, rasa macam mo mati. Kam tinggal disini trus jaga-jaga deng Saya.” ");
INSERT INTO pmy_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Habis itu De maju sdikit, trus tunduk sampe muka ke tana baru berdoa, De bilang, “Bapa, kalo bisa, kas jau sengsara ini dari Sa ka, tapi jang Sa pu mau yang jadi, biar Bapa pu mau saja yang jadi.” ");
INSERT INTO pmy_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Habis itu De kembali ke murid-murid, begini De liat dong ada tidur. Trus De bilang ke Petrus, “Masa satu jam saja kam tra bisa jaga-jaga deng Saya? ");
INSERT INTO pmy_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Jaga-jaga deng berdoa suda, supaya kam jang jatu waktu dapa uji. Memang kam pu hati mo bikin yang benar, tapi kam pu badan tra kuat mo bikin itu.” ");
INSERT INTO pmy_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Trus De pigi untuk berdoa lagi, De bilang, “Bapa, kalo memang trada jalan lain hanya kalo Sa harus tanggung sengsara ini, biar Bapa pu mau yang jadi suda!” ");
INSERT INTO pmy_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Trus waktu De kembali lagi, De liat dong ada tidur, karna dong pu mata su brat skali. ");
INSERT INTO pmy_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","De kas biar dong disitu, trus pigi untuk berdoa yang ketiga kali deng doa yang sama. ");
INSERT INTO pmy_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Habis itu Yesus kembali ke De pu murid-murid baru bilang ke dorang, “Kam masi istirahat deng tidur ka? Liat! Skarang waktu untuk Sa Anak Manusia dapa jual ke orang-orang yang bikin dosa pu tangan. ");
INSERT INTO pmy_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Bangun suda, mari! Tong pigi. De yang jual Sa su datang.” ");
INSERT INTO pmy_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Waktu Yesus masi bicara, Yudas de datang, de tu satu orang dari duablas murid dorang. Ada satu rombongan besar orang yang sama-sama deng dia, dong bawa pedang deng tongkat kayu, dong dapa suru dari imam-imam kepala deng orang Yahudi pu tua-tua. ");
INSERT INTO pmy_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Orang yang jual Yesus su kastau tanda ini ke dorang, “Orang yang nanti sa cium, itu De suda, tangkap Dia.” ");
INSERT INTO pmy_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Waktu dong sampe disitu, de langsung ke Yesus baru bilang, “Slamat malam Guru,” trus de cium Yesus. ");
INSERT INTO pmy_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Tapi Yesus bilang dia, “Kawan, jadi ko datang untuk ini ka?” Habis itu dong maju trus pegang Yesus deng tangkap Dia. ");
INSERT INTO pmy_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Tapi satu orang dari dong yang sama-sama deng Yesus cabut de pu pedang, trus srang kas putus Pemimpin Imam pu pesuru pu tlinga. ");
INSERT INTO pmy_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Trus Yesus bilang dia, “Kas masuk pedang itu kembali ke de pu tempat, karna sapa yang bakalai deng pedang, nanti de dapa bunu deng pedang juga. ");
INSERT INTO pmy_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ato kam pikir, Sa tra bisa minta tolong ke Sa pu Bapa, baru De langsung kirim lebi dari 12 pasukan malaikat untuk bantu Saya? ");
INSERT INTO pmy_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Tapi kalo Sa bikin begitu, apa yang ada tatulis dalam Kitab Suci tentang yang harus jadi, bagemana mo jadi?” ");
INSERT INTO pmy_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Habis itu Yesus bilang ke orang banyak, “Kam kira Sa ni prampok ka, jadi kam datang lengkap deng pedang sama tongkat kayu untuk tangkap Saya? Padahal tiap hari Sa biasa duduk kas ajar orang banyak di Ruma Allah, tapi kam tra tangkap Saya. ");
INSERT INTO pmy_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Tapi memang smua ini harus jadi begini, supaya apa yang ada tatulis dalam kitab nabi-nabi tu jadi.” Trus De pu murid-murid smua lari kas tinggal Dia. ");
INSERT INTO pmy_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Habis dong tangkap Yesus, dong bawa De ke depan Pemimpin Imam yang de pu nama Kayafas. Guru-guru agama deng Yahudi pu tua-tua su kumpul disitu. ");
INSERT INTO pmy_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Tapi Petrus ikut Yesus dari jau sampe masuk ke Pemimpin Imam pu halaman. Habis de masuk ke dalam, de duduk deng orang-orang yang jaga Ruma Allah, untuk liat bagemana hasil dari masala itu. ");
INSERT INTO pmy_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Imam-imam kepala deng anggota Sidang Agama smua brusaha cari orang untuk tudu-tudu Yesus, supaya De dapa hukum mati. ");
INSERT INTO pmy_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Biar ada banyak orang yang maju untuk tudu-tudu Yesus tapi dong tra dapat bukti apapa. Begini ada dua orang yang maju, ");
INSERT INTO pmy_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","dong bilang begini, “Orang ini De bilang, ‘Sa bisa kas hancur Ruma Allah trus bangun kembali dalam tiga hari.’ ” ");
INSERT INTO pmy_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Trus Pemimpin Imam bediri deng bilang ke Yesus, “Ko tra mo jawab yang dong tudu-tudu ke Ko ini ka?” ");
INSERT INTO pmy_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Tapi Yesus diam saja. Trus Pemimpin Imam itu bilang, “Demi Allah yang hidup, kastau sama kitong, Ko tu Raja Yang Allah Pili, Allah pu Anak ka, ato bukan?” ");
INSERT INTO pmy_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesus jawab, “Ko sendiri yang bilang begitu. Tapi Sa bilang kam, mulai skarang nanti kam liat Sa Anak Manusia, duduk di sebla kanan Yang Pu Kuasa Paling Besar, trus datang deng awan-awan di langit.” ");
INSERT INTO pmy_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Begini, Pemimpin Imam robek de pu pakean deng bilang, “De su hina Allah. Buat apa tong cari saksi lagi? Skarang kam su dengar De hina Allah to. ");
INSERT INTO pmy_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Kam pikir bagemana?” Trus dong jawab, “De pantas dapa hukum mati!” ");
INSERT INTO pmy_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Habis itu dong luda De pu muka baru pukul Dia, trus orang-orang lain juga tampeleng Dia. ");
INSERT INTO pmy_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Baru dong bilang, “We, Raja Yang Allah Pili, coba kastau, sapa yang pukul Ko?” ");
INSERT INTO pmy_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Petrus ada duduk di luar, di halaman situ. Begini pesuru prempuan satu datang ke dia, baru bilang, “Ko juga biasa sama-sama deng Yesus, orang Galilea itu to?” ");
INSERT INTO pmy_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Tapi Petrus bilang tra knal di depan smua orang, de bilang, “Sa tra tau ko pu maksud apa.” ");
INSERT INTO pmy_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Waktu de pigi ke pintu gerbang begini, ada pesuru lain lagi liat dia, baru bilang ke orang-orang yang ada disitu, “Orang ini juga sama-sama deng Yesus, orang Nasaret itu.” ");
INSERT INTO pmy_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Petrus de bilang tra knal lagi deng sumpa, de bilang, “Sumpa, sa tra knal orang itu.” ");
INSERT INTO pmy_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Tra lama begini orang-orang yang ada disitu datang ke Petrus baru bilang, “Pasti ko juga satu orang dari dorang, kentara skali dari ko pu bahasa.” ");
INSERT INTO pmy_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Begini Petrus bilang, “Sa sumpa, sa tra knal orang itu, kalo sa tipu pasti Tuhan hukum saya.” Pas waktu itu ayam berkokok. ");
INSERT INTO pmy_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Begini Petrus ingat yang Yesus perna bilang, “Seblum ayam berkokok, ko su tiga kali bilang tra knal Saya.” Trus de pigi kluar baru mnangis deng hati hancur. ");
INSERT INTO pmy_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Waktu hari mo trang, imam kepala smua deng orang Yahudi pu tua-tua dong kumpul baru bikin rencana bagemana cara yang pas untuk bunu Yesus. ");
INSERT INTO pmy_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Trus dong ikat Yesus baru bawa kasi De ke Gubernur Pilatus. ");
INSERT INTO pmy_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Waktu itu Yudas, yang jual Yesus, liat kalo Yesus dapa kas hukum mati, de mnyesal skali. Trus de kas kembali 30 uang perak itu ke imam-imam kepala deng Yahudi pu tua-tua. ");
INSERT INTO pmy_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Baru de bilang, “Sa su bikin dosa, karna sa su jual orang yang tra pu sala apapa untuk dapa bunu.” Tapi dong bilang, “Tong tra mo tau, itu ko pu urusan!” ");
INSERT INTO pmy_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Habis itu, Yudas lempar uang perak itu ke dalam Ruma Allah, baru pigi dari situ trus gantung diri. ");
INSERT INTO pmy_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Imam-imam kepala dong ambil uang perak itu baru bilang, “Tra bole simpan uang ini di tempat persembahan, karna ini uang dara.” ");
INSERT INTO pmy_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Habis dong baku atur, deng uang itu dong bli tukang tana liat pu tana, untuk dong bikin jadi orang bukan Yahudi yang mati di dong pu daera pu kuburan. ");
INSERT INTO pmy_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Itu jadi, tana itu sampe hari ini dapa sebut Tana Dara. ");
INSERT INTO pmy_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Deng begitu supaya Allah pu kata-kata dulu lewat Nabi Yeremia tu su jadi, “Dong ambil 30 uang perak, orang Israel nilai itu harga yang pantas untuk bli Dia, ");
INSERT INTO pmy_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","trus dong kasi uang itu untuk tukang tana liat pu tana. Sama sperti yang Tuhan kas pesan ke saya.” ");
INSERT INTO pmy_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jadi dong bawa Yesus ke depan Gubernur Pilatus. Baru gubernur tanya Yesus, “Betul ka, Ko ni orang Yahudi pu Raja?” Yesus jawab, “Ko sendiri yang bilang.” ");
INSERT INTO pmy_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Tapi waktu imam-imam kepala deng Yahudi pu tua-tua dong tudu-tudu Yesus, De tra jawab apapa. ");
INSERT INTO pmy_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Itu jadi Pilatus bilang ke Dia, “Ko tra dengar yang dong su tudu-tudu Ko banyak skali ka?” ");
INSERT INTO pmy_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Tapi De tra jawab satu kata juga, jadi gubernur de heran skali. ");
INSERT INTO pmy_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Stiap kali hari besar Paska, gubernur biasa kas bebas tahanan satu yang orang banyak pili. ");
INSERT INTO pmy_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Pas waktu itu ada satu orang di dalam penjara, orang-orang knal de karna de jahat skali, de pu nama Yesus Barabas. ");
INSERT INTO pmy_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Karna orang banyak su kumpul disana, jadi Pilatus bilang ke dorang, “Sapa yang kam mau sa kas bebas untuk kam, Yesus Barabas ato Yesus yang dapa panggil Raja Yang Allah Pili?” ");
INSERT INTO pmy_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Karna de memang tau, kalo dong kasi Yesus ke de karna dong tra snang liat De lebi dari dorang. ");
INSERT INTO pmy_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Waktu Pilatus su duduk di kursi sidang, de pu istri kirim pesan untuk dia, “Ko tra bole ikut campur orang benar itu pu masala, karna tadi malam sa ada mimpi Dia, mimpi itu bikin sa takut skali.” ");
INSERT INTO pmy_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Tapi imam-imam kepala deng Yahudi pu tua-tua dong kas pengaru orang banyak trus, supaya dong minta kas bebas Barabas baru kasi hukum mati ke Yesus. ");
INSERT INTO pmy_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Gubernur bilang lagi ke dorang, “Dari dua orang ini, sapa yang kam mau sa kas bebas untuk kam?” Dong bilang, “Barabas!” ");
INSERT INTO pmy_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilatus bilang dorang, “Kalo begitu, sa harus bikin apa ke Yesus yang dapa panggil Raja Yang Allah Pili?” Dong smua batariak, “Kas salib Dia!” ");
INSERT INTO pmy_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilatus tanya, “Tapi De bikin jahat apa ka?” Begini dong batariak tamba kras lagi, “Kas salib Dia!” ");
INSERT INTO pmy_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Waktu Pilatus sadar kalo de tra bisa bikin apapa lagi, mala keadaan mulai kaco, de ambil air trus cuci de pu tangan di depan smua orang baru bilang, “Sa tra bikin sala deng orang ini pu dara, itu kam pu urusan sendiri!” ");
INSERT INTO pmy_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Trus smua orang itu dong jawab, “Biar tong deng tong pu anana yang tanggung hukuman dari De pu dara!” ");
INSERT INTO pmy_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Habis itu Pilatus kas bebas Barabas untuk dorang, tapi de suru orang cambuk Yesus baru kasi De untuk dong kas salib. ");
INSERT INTO pmy_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Habis itu, gubernur pu tentara-tentara bawa Yesus ke dalam gubernur pu halaman istana, baru panggil pasukan smua kumpul kliling Yesus. ");
INSERT INTO pmy_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Dong kas lepas De pu pakean trus dong kas pake De baju panjang ungu. ");
INSERT INTO pmy_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Dong anyam ranting-ranting duri bikin macam makota, baru dong taru di De pu kepala. Trus dong kasi De pegang tongkat di De pu tangan kanan. Habis itu, dong tikam lutut di depan De trus ejek-ejek Dia, dong bilang, “Hormat, orang Yahudi pu Raja!” ");
INSERT INTO pmy_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Dong luda De trus ambil tongkat itu baru pukul ke De pu kepala. ");
INSERT INTO pmy_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Habis dong hina-hina Dia, dong kas lepas baju panjang itu dari De trus kas pake De pu pakean itu lagi ke Dia. Habis itu, dong bawa De kluar dari situ untuk kas salib. ");
INSERT INTO pmy_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Waktu dong jalan kluar kota, dong ketemu satu orang yang de pu nama Simon yang asal dari Kota Kirene. Dong paksa de pikul Yesus pu kayu salib. ");
INSERT INTO pmy_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Begini dong su sampe di tempat satu yang de pu nama Golgota, yang de pu arti Tempat Tengkorak. ");
INSERT INTO pmy_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Trus dong kasi Yesus minum anggur campur empedu. Waktu rasa anggur itu, De tra mau minum lagi. ");
INSERT INTO pmy_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Habis kas salib Yesus, dong baku bagi De pu pakean deng cara buang undi. ");
INSERT INTO pmy_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Baru dong duduk disitu jaga Yesus. ");
INSERT INTO pmy_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Di atas De pu kepala juga dong pasang tulisan yang kastau alasan knapa De dapa hukum. Dong tulis begini, “De ni Yesus, orang Yahudi pu Raja.” ");
INSERT INTO pmy_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Dong kas salib De sama-sama deng prampok dua orang, satu di sebla kanan deng satu di sebla kiri. ");
INSERT INTO pmy_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Orang-orang yang lewat disana geleng-geleng kepala untuk hina Dia. ");
INSERT INTO pmy_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Baru dong bilang, “We, Ko yang bilang mo kas rubu Ruma Allah trus mo bangun kembali dalam tiga hari to? Kas slamat Ko pu diri suda. Kalo Ko Allah pu Anak, Ko turun suda dari salib itu!” ");
INSERT INTO pmy_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Begitu juga imam-imam kepala deng guru-guru agama sama orang Yahudi pu tua-tua hina-hina De deng bilang, ");
INSERT INTO pmy_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Orang lain De bisa kas slamat, tapi De pu diri sendiri De tra bisa kas slamat! Kalo memang De ni Israel pu Raja, coba De turun dari salib itu baru tong bisa percaya Dia. ");
INSERT INTO pmy_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","De taru De pu harapan ke Allah, kalo Allah mau biar Allah kas slamat Dia! Karna De su bilang, ‘Sa ni Allah pu Anak.’ ” ");
INSERT INTO pmy_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Sampe prampok-prampok yang dapa salib sama-sama deng De juga hina De begitu. ");
INSERT INTO pmy_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Mulai dari jam 12 siang, smua daera itu jadi glap sampe jam tiga sore. ");
INSERT INTO pmy_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Kira-kira jam tiga sore, Yesus batariak deng suara kras, “Eli, Eli, lama sabakhtani?” De pu arti, ʻSa pu Allah, Sa pu Allah, knapa Ko kas tinggal Saya?ʼ ");
INSERT INTO pmy_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Dengar begitu, brapa orang yang bediri disitu bilang, “De panggil Elia.” ");
INSERT INTO pmy_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Begini, satu orang dari dong pigi cepat-cepat, de ambil spons, baru colo ke dalam anggur asam, trus ikat di tongkat baru de kas minum Yesus. ");
INSERT INTO pmy_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Tapi orang-orang lain dong bilang, “Tunggu! Tong liat dulu, nanti Elia datang kas slamat De ka trada.” ");
INSERT INTO pmy_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Trus Yesus batariak lagi deng kras baru kasi De pu nyawa ke Allah. ");
INSERT INTO pmy_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Begini hordein tebal di Ruma Allah tarobek jadi dua dari atas sampe ke bawa. Baru ada gempa bumi, sama batu-batu besar tabla. ");
INSERT INTO pmy_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Trus kubur-kubur tabuka baru Allah pu orang-orang yang su mati banyak yang hidup kembali. ");
INSERT INTO pmy_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Habis Yesus hidup kembali, dong kluar dari dong pu kubur baru masuk ke Yerusalem, kota suci itu, trus kas tunjuk diri ke orang banyak. ");
INSERT INTO pmy_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Perwira deng de pu tentara-tentara yang jaga Yesus jadi takut skali waktu dong liat gempa bumi deng smua yang su jadi. Baru dong bilang, “Betul, De ni suda Allah pu Anak.” ");
INSERT INTO pmy_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Trus disitu ada banyak prempuan yang liat dari jau, dong ni yang ikut Yesus dari Galilea untuk layani Dia. ");
INSERT INTO pmy_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Dari antara dorang, ada Maria dari Magdala, sama Maria yang Yakobus deng Yusup pu mama, trus Zebedeus pu anana pu mama. ");
INSERT INTO pmy_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Waktu su mo malam, ada orang kaya satu yang datang. De orang Arimatea, de pu nama Yusuf, de juga su jadi Yesus pu pengikut. ");
INSERT INTO pmy_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","De pigi ketemu Pilatus untuk minta Yesus pu mayat. Trus Pilatus kas printa untuk kasi Yesus pu mayat ke Yusuf. ");
INSERT INTO pmy_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Trus Yusuf ambil mayat itu, baru bungkus pake kain lenan halus yang bersi. ");
INSERT INTO pmy_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Habis itu, de taru mayat itu di dalam de pu kubur yang masi baru, yang de bikin di dalam bukit batu. Habis guling batu besar satu untuk tutup kubur itu pu pintu, Yusuf de pigi. ");
INSERT INTO pmy_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Tapi Maria dari Magdala deng Maria yang lain tinggal disitu, duduk di depan kubur itu. ");
INSERT INTO pmy_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","De pu besok, pas di orang Yahudi pu hari Sabat, imam-imam kepala deng orang-orang Farisi pigi sama-sama ketemu Pilatus. ");
INSERT INTO pmy_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Baru dong bilang, “Bapa, tong ingat kalo tukang tipu itu waktu De hidup, De ada bilang, ‘Pas tiga hari nanti Sa hidup kembali.’ ");
INSERT INTO pmy_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Itu jadi kas kluar printa supaya ada yang jaga kubur itu sampe hari yang ketiga. Kalo tidak, De pu murid-murid bisa datang untuk curi De pu mayat, baru bilang ke orang-orang, ‘De su hidup kembali dari tenga-tenga orang mati,’ baru nanti dong tipu-tipu orang lebi para lagi daripada yang pertama.” ");
INSERT INTO pmy_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Trus Pilatus bilang ke dorang, “Ini tentara-tentara jaga, kam bawa dong pigi trus jaga kubur itu baik-baik skali.” ");
INSERT INTO pmy_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Habis itu dong deng tentara-tentara pigi ke kubur, trus dong segel pintu batu itu baru jaga kubur itu. ");
INSERT INTO pmy_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Waktu orang Yahudi pu hari Sabat su lewat, di hari Minggu pagi-pagi skali, Maria dari Magdala deng Maria yang lain, pigi liat kubur itu. ");
INSERT INTO pmy_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tiba-tiba ada gempa bumi yang kencang skali, karna Tuhan pu malaikat satu turun dari surga baru pigi kas guling batu kubur itu, trus de duduk di batu itu. ");
INSERT INTO pmy_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Malaikat itu kliatan trang sperti kilat, baru de pu pakean puti sperti salju. ");
INSERT INTO pmy_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Dong yang tugas jaga tu jadi takut skali sampe gementar, dong jadi sperti orang mati. ");
INSERT INTO pmy_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Tapi malaikat itu bilang ke prempuan-prempuan itu, “Kam tra usa takut, sa tau kalo kam cari Yesus yang dapa salib itu to? ");
INSERT INTO pmy_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","De su trada disini, karna De su hidup kembali, sama sperti yang De su perna bilang. Mari, liat tempat yang dong taru De pu mayat. ");
INSERT INTO pmy_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Pigi cepat kastau ke De pu murid-murid kalo Allah su kas hidup De kembali dari tenga-tenga orang mati. De duluan kam ke Galilea, nanti kam liat De disana. Ini sa pu pesan buat kam.” ");
INSERT INTO pmy_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Prempuan-prempuan itu langsung pigi kas tinggal kubur deng rasa takut tapi snang skali, dong lari cepat-cepat untuk kastau hal itu ke Yesus pu murid-murid. ");
INSERT INTO pmy_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Tiba-tiba Yesus ketemu deng prempuan-prempuan itu baru bilang, “Salam untuk kam.” Dong ke dekat Yesus trus pegang De pu kaki untuk semba Dia. ");
INSERT INTO pmy_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Trus Yesus bilang ke dorang, “Kam jang takut. Pigi baru kastau ke Sa pu sodara-sodara, biar dong pigi ke Galilea. Nanti dong liat Sa disana.” ");
INSERT INTO pmy_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Waktu prempuan-prempuan itu di tenga jalan, brapa orang dari tentara-tentara yang ada jaga kubur tu pigi ke kota untuk kastau ke imam-imam kepala tentang smua yang su jadi. ");
INSERT INTO pmy_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Trus habis rapat deng Yahudi pu tua-tua, dong stuju untuk kasi uang deng jumla besar ke tentara-tentara itu. ");
INSERT INTO pmy_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Trus dong bilang, “Kam harus crita, kalo De pu murid-murid datang malam-malam baru curi De pu mayat waktu kam ada tidur. ");
INSERT INTO pmy_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Trus kalo gubernur dengar crita itu, nanti tong yang bicara deng dia, supaya kam trakan kena masala apapa.” ");
INSERT INTO pmy_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Trus tentara-tentara itu ambil uang itu baru bikin sama sperti yang dong dapa suru. Crita ini masi tasebar di tenga-tenga orang Yahudi sampe skarang. ");
INSERT INTO pmy_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Trus Yesus pu seblas murid pigi ke Galilea, ke bukit yang Yesus su kastau ke dorang. ");
INSERT INTO pmy_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Waktu dong liat Yesus, dong semba Dia, tapi ada brapa orang yang ragu-ragu. ");
INSERT INTO pmy_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesus ke dekat dong baru bilang, “Sa pu Bapa su kasi kuasa smua di surga deng di bumi ke Saya. ");
INSERT INTO pmy_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Itu jadi pigi ke smua bangsa, bikin dong jadi Sa pu pengikut. Baptis dong dalam nama Bapa, Anak, deng Roh Allah. ");
INSERT INTO pmy_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Kas ajar dong untuk dengar-dengar smua hal yang Sa su kas printa ke kam. Trus kam ingat eh, Sa pasti sama-sama deng kam trus sampe akir jaman.”");
INSERT INTO pmy_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ini Brita Baik tentang Yesus Kristus, Allah pu Anak. ");
INSERT INTO pmy_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Brita itu mulai sperti yang tatulis dalam kitab Nabi Yesaya, “Liat! Sa suru Sa pu utusan duluan Ko, de nanti kas siap Ko pu jalan. ");
INSERT INTO pmy_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ada suara yang batariak di tempat sepi yang kring, ‘Kas siap jalan untuk Tuhan, kas lurus jalan untuk Dia.’ ” ");
INSERT INTO pmy_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Sama deng yang Nabi Yesaya bilang itu, begitu suda Yohanes Tukang Baptis datang ke tempat sepi yang kring, baru kastau kalo orang harus tobat, trus dapa baptis supaya dapa kas ampun dari dong pu dosa-dosa. ");
INSERT INTO pmy_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Trus smua orang dari daera Yudea deng Yerusalem, datang trus-trus ke dia. Dong mngaku dong pu dosa-dosa trus dapa baptis dari Yohanes di kali Yordan. ");
INSERT INTO pmy_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohanes pake baju panjang dari bulu unta, de pu ikat pinggang dari binatang pu kulit. Trus de makan belalang deng madu hutan. ");
INSERT INTO pmy_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ini yang de kastau, “Stela saya, orang yang pu kuasa lebi besar dari sa nanti datang, tunduk untuk mo buka De pu tali spatu saja sa tra pantas. ");
INSERT INTO pmy_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Sa baptis kam deng air, tapi De nanti baptis kam deng Roh Allah.” ");
INSERT INTO pmy_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Tra lama begini, Yesus datang dari Kota Nasaret di daera Galilea, trus De dapa baptis dari Yohanes di kali Yordan. ");
INSERT INTO pmy_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Pas De kluar dari air, tiba-tiba De liat langit tabuka trus Roh Allah turun sperti burung merpati ke atas Dia. ");
INSERT INTO pmy_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Trus ada suara dari surga yang bilang, “Ko ini Sa pu Anak yang Sa sayang, Ko bikin Sa pu hati snang.” ");
INSERT INTO pmy_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Langsung stela itu, Roh Allah bawa Yesus ke tempat sepi yang kring. ");
INSERT INTO pmy_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Yesus tinggal 40 hari disana trus De dapa coba dari Iblis. De tinggal sama-sama deng binatang-binatang liar, trus Allah pu malaikat-malaikat datang layani Dia. ");
INSERT INTO pmy_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Habis Yohanes dapa tangkap, Yesus pigi ke daera Galilea untuk kastau Brita Baik dari Allah. ");
INSERT INTO pmy_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Yesus bilang, “Waktu yang Allah janji su tiba, Allah pu Krajaan su dekat. Jadi kam harus tobat dari kam pu dosa-dosa deng percaya sama Brita Baik dari Allah.” ");
INSERT INTO pmy_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Waktu Yesus ada jalan di pinggir danau Galilea, De liat Simon deng Simon pu sodara Andreas. Dong dua ada buang jala di danau, karna dong dua tu tukang tangkap ikan. ");
INSERT INTO pmy_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesus bilang ke dong dua, “Mari, ikut Saya. Nanti Sa kas ajar kam dua untuk jadi orang yang jala manusia.” ");
INSERT INTO pmy_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Trus dong dua langsung kas tinggal dong pu jala baru ikut Dia. ");
INSERT INTO pmy_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Habis itu Yesus lanjut jalan sdikit lagi trus De liat Yakobus deng de pu sodara Yohanes, dong dua ni bapa Zebedeus pu anana. Dong dua ada kas baik jala di dalam prahu. ");
INSERT INTO pmy_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Begini Yesus langsung panggil dong dua, trus dong dua kas tinggal dong pu bapa Zebedeus deng de pu orang-orang kerja di prahu, baru ikut Dia. ");
INSERT INTO pmy_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesus dong tiba di Kota Kapernaum. Pas orang Yahudi pu hari Sabat mulai, Yesus langsung masuk ke tempat ibada deng mulai kas ajar orang disitu. ");
INSERT INTO pmy_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Dong smua heran dengar apa yang De kas ajar, karna De kas ajar dong deng kuasa, tra sperti guru-guru agama. ");
INSERT INTO pmy_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Waktu itu di dalam dong pu tempat ibada ada satu orang yang krasukan setan. Orang itu batariak, bilang, ");
INSERT INTO pmy_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“He Yesus orang Nasaret, Ko mo bikin apa deng kitong? Ko datang mo kas hancur tong ka? Sa tau Ko tu sapa, Ko itu Orang Suci yang Allah utus.” ");
INSERT INTO pmy_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Tapi Yesus printa dia, “Diam, kluar dari dia!” ");
INSERT INTO pmy_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Setan itu bikin de pu badan kejang-kejang baru kluar dari de deng batariak kras-kras. ");
INSERT INTO pmy_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Dong smua heran skali, sampe dong baku tanya, “Itu apa ka? Itu ajaran baru, trus De pu kata-kata penu kuasa! De kas printa setan-setan trus dong dengar Dia!” ");
INSERT INTO pmy_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Trus brita tentang Yesus itu tasebar cepat skali ke smua tempat di daera Galilea. ");
INSERT INTO pmy_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Habis Yesus dong kluar dari tempat ibada, dong pigi ke Simon deng Andreas pu ruma. Yakobus deng Yohanes juga ikut. ");
INSERT INTO pmy_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Waktu itu Simon pu mama mantu ada tidur karna panas tinggi, jadi langsung dong kastau ke Yesus kalo mama de ada sakit. ");
INSERT INTO pmy_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jadi Yesus ke mama itu, trus pegang de pu tangan baru kas bangun dia, begini langsung de pu panas tinggi hilang. Habis sembu langsung mama de kas siap makanan untuk Yesus dorang. ");
INSERT INTO pmy_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Pas su mo malam, stela matahari masuk, dong bawa orang-orang sakit smua deng yang krasukan setan ke Yesus. ");
INSERT INTO pmy_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Orang banyak skali dari kota itu yang kumpul di depan ruma itu. ");
INSERT INTO pmy_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesus kas sembu orang banyak yang mendrita sakit macam-macam, sama usir setan banyak. De tra kas ijin setan-setan itu bicara karna dong tau De itu sapa. ");
INSERT INTO pmy_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Pagi-pagi skali, waktu masi glap, Yesus bangun baru kluar, trus pigi ke tempat yang sunyi baru berdoa disana. ");
INSERT INTO pmy_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Tapi Simon deng de pu teman-teman cari Dia. ");
INSERT INTO pmy_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Trus waktu dong ketemu Dia, dong bilang, “Bapa, smua orang ada cari Bapa.” ");
INSERT INTO pmy_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesus bilang, “Mari tong pigi ke tempat yang lain, ke kota-kota yang dekat, supaya Sa kastau Brita Baik disana juga, karna Sa datang untuk itu.” ");
INSERT INTO pmy_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Trus De pigi ke smua tempat di daera Galilea untuk kastau Brita Baik dalam dong pu tempat-tempat ibada, deng usir setan-setan. ");
INSERT INTO pmy_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Satu kali begini, ada satu orang yang sakit kulit busuk datang ke Yesus trus tanam lutut depan Dia. De mohon ke Yesus untuk tolong dia, de bilang, “Bapa, kalo Bapa mau, Bapa pasti bisa kas sembu saya.” ");
INSERT INTO pmy_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesus kasian de skali, jadi De kas tangan pegang orang itu trus bilang ke dia, “Sa mau. Ko sembu suda!” ");
INSERT INTO pmy_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Waktu itu juga de pu sakit kulit busuk itu hilang baru de sembu. ");
INSERT INTO pmy_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Trus Yesus langsung suru de pigi baru kas ingat de deng kras, ");
INSERT INTO pmy_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Ingat e, jang kastau ke sapa-sapa, tapi pigi kas liat ko pu diri ke imam trus kasi persembahan yang Musa de printa untuk kas bersi ko pu diri, itu jadi bukti ke dorang.” ");
INSERT INTO pmy_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Tapi de pigi crita smua itu ke mana-mana, sampe Yesus tra bisa kas tunjuk muka di kota apa saja. De pigi tinggal di tempat-tempat sunyi di luar kota. Biar begitu juga, orang-orang dari mana saja, datang trus-trus ke Dia. ");
INSERT INTO pmy_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Lewat brapa hari begini, waktu Yesus kembali ke Kapernaum, kabar tasebar ke mana-mana kalo Yesus su ada di ruma. ");
INSERT INTO pmy_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Trus orang banyak skali datang sampe tempat penu, di depan pintu juga trada tempat kosong lagi. Waktu Yesus kastau Allah pu pesan ke dorang, ");
INSERT INTO pmy_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ada orang-orang datang bawa orang lumpu satu ke Yesus, empat orang dari dong yang bantu bawa dia. ");
INSERT INTO pmy_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Dong tra bisa bawa de ke Yesus karna orang banyak skali, jadi dong buka atap yang Yesus ada bediri di bawa, trus waktu atap su tabuka dong kas turun orang lumpu itu deng tikar yang de pake tidur. ");
INSERT INTO pmy_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Waktu Yesus liat dong percaya skali, De bilang sama orang lumpu itu, “Anak, ko pu dosa-dosa su dapa kas ampun!” ");
INSERT INTO pmy_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Tapi ada brapa guru agama yang ada duduk disitu pikir, ");
INSERT INTO pmy_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Brani skali De bicara begitu, De hina Allah! Cuma Allah saja yang bisa kas ampun dosa.” ");
INSERT INTO pmy_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Tapi, dalam hati Yesus su tau apa yang dong pikir, jadi De bilang dorang, “Knapa kam pikir begitu dalam kam pu hati? ");
INSERT INTO pmy_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Mana yang lebi gampang, bilang ke orang lumpu ini, ‘Ko pu dosa-dosa su dapa kas ampun’ ato bilang, ‘Bediri suda! Angkat ko pu tikar baru jalan’? ");
INSERT INTO pmy_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Tapi, supaya kam tau kalo di dunia ini, Sa Anak Manusia pu kuasa kas ampun dosa, liat ini!” Trus Yesus bilang sama orang lumpu itu, ");
INSERT INTO pmy_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Sa bilang ko, bediri, angkat ko pu tikar trus pulang ke ko pu ruma!” ");
INSERT INTO pmy_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Orang itu langsung bediri trus angkat de pu tikar baru jalan kluar di depan smua orang, jadi dong smua heran trus puji Allah. Dong bilang, “Tong blum perna liat yang macam begini.” ");
INSERT INTO pmy_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Habis itu Yesus ke pinggir danau Galilea lagi. Orang banyak smua datang ke Dia, trus De kas ajar dorang. ");
INSERT INTO pmy_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Trus waktu Yesus jalan lewat disitu, De liat Lewi, bapa Alfeus pu anak, ada duduk di tempat tagi pajak, trus Yesus bilang ke dia, “Mari, ko ikut Saya.” Dengar begitu, langsung Lewi de bediri trus ikut Dia. ");
INSERT INTO pmy_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Trus waktu Yesus ada makan di Lewi pu ruma, banyak tukang tagi pajak deng orang-orang yang bikin dosa yang makan sama-sama Yesus deng De pu murid-murid, karna banyak orang juga yang ikut Dia. ");
INSERT INTO pmy_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Waktu guru-guru agama dari klompok orang Farisi dong liat kalo De ada makan deng tukang tagi pajak deng orang-orang yang bikin dosa itu, dong bilang ke De pu murid-murid, “Ih, bisa eh, De makan sama-sama deng tukang tagi pajak deng orang-orang yang bikin dosa?” ");
INSERT INTO pmy_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesus dengar yang dong bicara trus De bilang ke dorang, “Bukan orang yang sehat yang perlu dokter, tapi orang sakit. Sa tra datang untuk panggil orang yang rasa diri benar, tapi untuk panggil orang yang bikin dosa.” ");
INSERT INTO pmy_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Satu kali begini, waktu Yohanes Tukang Baptis pu murid-murid deng orang-orang Farisi ada puasa, orang-orang datang baru bilang ke Yesus, “Knapa Yohanes pu murid-murid deng orang Farisi pu murid-murid dong biasa puasa, tapi Bapa pu murid-murid tidak?” ");
INSERT INTO pmy_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesus jawab dong begini, “Bisa ka, kalo pengantin laki-laki pu teman-teman dong puasa waktu pengantin itu ada sama-sama deng dorang? Dong tra bisa puasa slama pengantin itu ada sama-sama deng dorang. ");
INSERT INTO pmy_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Tapi nanti ada de pu waktu untuk pengantin dapa ambil dari dorang, pas waktu itu baru dong puasa. ");
INSERT INTO pmy_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Trada orang yang tempel kain spanggal yang baru di baju lama to? Karna kalo bikin begitu, kain yang baru itu nanti bikin robek baju yang lama itu, trus de pu robek tamba besar lagi. ");
INSERT INTO pmy_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Begitu juga trada orang yang isi air anggur yang baru ke dalam kantong kulit yang lama. Karna kalo bikin begitu, nanti air anggur yang baru itu bikin robek kantong itu, jadi nanti kantong rusak trus anggur tabuang. Jadi, air anggur yang baru itu orang harus simpan di dalam kantong kulit yang baru juga.” ");
INSERT INTO pmy_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Satu hari begini, waktu orang Yahudi pu hari Sabat, Yesus deng De pu murid-murid jalan di kebun gandum. Waktu dong jalan, De pu murid-murid petik biji-biji gandum. ");
INSERT INTO pmy_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Trus orang-orang Farisi bilang ke Yesus, “Liat! Knapa di tong pu hari Sabat dong bikin apa yang hukum Musa larang?” ");
INSERT INTO pmy_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","De jawab dorang, “Kam blum perna baca ka yang Daud bikin, waktu de sama orang-orang yang ikut dia dong trada apapa trus dong lapar? ");
INSERT INTO pmy_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","De masuk ke dalam Ruma Allah waktu Abyatar jadi Pemimpin Imam, trus makan roti yang su kasi sama Allah itu, baru kasi sama dong yang ikut de juga. De bikin begitu padahal hukum Musa larang orang-orang makan roti itu, hanya imam-imam saja yang bisa makan.” ");
INSERT INTO pmy_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Trus Yesus bilang ke dorang, “Hari Sabat itu Allah bikin untuk tolong manusia, Allah tra bikin manusia cuma untuk ikut praturan hari Sabat saja. ");
INSERT INTO pmy_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","24 Jadi, Sa Anak Manusia pu kuasa atas hari Sabat juga.” ");
INSERT INTO pmy_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Trus Yesus masuk ke tempat ibada lagi. Disitu ada orang satu yang de pu tangan sebla mati. ");
INSERT INTO pmy_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Dong jaga liat Yesus trus, supaya kalo De kas sembu orang itu pas hari Sabat, dong bisa kas sala Dia. ");
INSERT INTO pmy_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesus bilang ke orang yang de pu tangan sebla mati itu, “Mari bediri di tenga sini.” ");
INSERT INTO pmy_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Trus Yesus tanya dorang, “Mana yang tong bisa buat pas hari Sabat? Buat baik ato buat jahat? Kas slamat orang ato bunu orang?” Tapi dong diam saja. ");
INSERT INTO pmy_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesus sedi skali karna dong pu hati kras trus De liat kliling ke dong deng rasa mara, trus De bilang ke orang itu, “Kas lurus ko pu tangan!” Trus de kas lurus de pu tangan, langsung de pu tangan itu sembu. ");
INSERT INTO pmy_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Trus orang-orang Farisi dong kluar baru langsung atur rencana deng orang-orang yang dukung Herodes untuk bunu Yesus. ");
INSERT INTO pmy_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Habis itu, Yesus deng De pu murid-murid pigi ke danau Galilea. Trus orang banyak skali dari daera Galilea yang ikut Yesus, deng juga dari daera Yudea, ");
INSERT INTO pmy_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","dari Yerusalem, dari Idumea, dari sebla timur kali Yordan, deng dari daera yang dekat deng Kota Tirus deng Sidon. Dong smua datang ke Yesus, karna dong su dengar apa yang De su bikin. ");
INSERT INTO pmy_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Karna orang-orang yang ikut De banyak skali jadi De suru De pu murid-murid untuk kas siap prahu satu untuk Dia, supaya jang dong dempet ke Dia. ");
INSERT INTO pmy_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Karna De su kas sembu banyak orang, jadi smua orang yang sakit dempet ke Dia supaya bisa pegang Dia. ");
INSERT INTO pmy_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Stiap kali setan-setan liat Dia, orang-orang yang krasukan setan itu dong tunduk sampe muka ke tana baru batariak bilang, “Ko itu Allah pu Anak!” ");
INSERT INTO pmy_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Tapi De larang kras setan-setan untuk tra bole kastau De tu sapa. ");
INSERT INTO pmy_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Trus Yesus naik ke atas gunung satu. De panggil orang-orang yang De pili trus dong datang ke Dia. ");
INSERT INTO pmy_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","De pili duablas orang untuk sama-sama Dia, deng juga dapa utus dari De untuk pigi kastau Brita Baik dari Allah. De juga sebut dong itu utusan. ");
INSERT INTO pmy_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Trus De juga kasi kuasa ke dong untuk usir setan. ");
INSERT INTO pmy_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Duablas orang yang De pili, dong itu: Simon yang De juga kas nama Petrus, ");
INSERT INTO pmy_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakobus deng de pu sodara Yohanes, dong dua ni bapa Zebedeus pu anana, De kas nama dong dua Boanerges yang de pu arti ʻanana guntur.ʼ ");
INSERT INTO pmy_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Trus Andreas, Filipus, Bartolomeus, Matius, Tomas, Yakobus bapa Alfeus pu anak, Tadeus, Simon yang de dari klompok orang Zelot, ");
INSERT INTO pmy_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","deng Yudas Iskariot yang jual Yesus. ");
INSERT INTO pmy_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Trus Yesus masuk ke ruma satu. Tapi banyak orang yang datang kumpul disitu lagi, sampe dong tra bisa makan. ");
INSERT INTO pmy_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Waktu Yesus pu kluarga dong dengar tentang itu, dong datang untuk mo ambil De karna orang-orang bilang kalo De su gila. ");
INSERT INTO pmy_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Trus guru-guru agama yang datang dari Yerusalem bilang, “Beelzebul su masuk di Dia, De usir setan pake kuasa dari setan pu bos.” ");
INSERT INTO pmy_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesus panggil dong trus bilang ke dong deng crita conto begini, “Iblis bisa usir Iblis ka? ");
INSERT INTO pmy_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kalo satu negara baku musu, negara itu pasti hancur. ");
INSERT INTO pmy_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Trus kalo satu kluarga baku musu, kluarga itu pasti tra bisa tahan lama. ");
INSERT INTO pmy_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Sama juga kalo Iblis brontak baku lawan deng dong sendiri, kalo dong baku musu nanti dong tra bisa tahan lama, itu suda dong pu akir. ");
INSERT INTO pmy_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Trada orang yang bisa masuk ke orang yang kuat pu ruma untuk rampas de pu harta, kalo de blum ikat orang yang kuat itu dulu. Habis itu baru de bisa rampas orang itu pu harta smua. ");
INSERT INTO pmy_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Yang Sa bilang ini benar: Orang yang bikin dosa deng hina-hina orang lain, nanti bisa dapa kas ampun. ");
INSERT INTO pmy_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Tapi sapa saja yang hina Roh Allah, de trakan dapa kas ampun. De su bikin dosa yang tra bisa dapa kas ampun sampe trada akir.” ");
INSERT INTO pmy_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","De bilang begitu karna dong bilang kalo setan su masuk di Dia. ");
INSERT INTO pmy_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Habis itu, Yesus pu mama deng sodara-sodara datang. Dong tunggu di luar trus dong suru orang panggil Dia. ");
INSERT INTO pmy_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Waktu itu banyak orang duduk kliling Yesus. Dong bilang ke Dia, “Bapa liat, Bapa pu mama deng sodara-sodara ada di luar, dong brusaha mo ketemu Bapa.” ");
INSERT INTO pmy_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesus bilang ke dorang, “Sapa Sa pu mama? Sapa Sa pu sodara-sodara?” ");
INSERT INTO pmy_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","De liat orang-orang yang duduk kliling De itu trus De bilang, “Ini suda, Sa pu mama deng Sa pu sodara-sodara! ");
INSERT INTO pmy_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Sapa saja yang bikin Allah pu mau, de suda Sa pu sodara laki-laki, Sa pu sodara prempuan, deng Sa pu mama.” ");
INSERT INTO pmy_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Satu kali begini, Yesus mulai kas ajar orang-orang lagi di pinggir danau. Orang banyak skali yang datang kumpul kliling Dia, jadi De naik ke prahu yang ada berlabu baru duduk disitu, trus orang banyak itu smua bediri di pinggir danau. ");
INSERT INTO pmy_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Trus De kas ajar banyak hal deng crita conto ke dorang, De bilang ke dong begini, ");
INSERT INTO pmy_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Dengar baik-baik! Satu kali ada orang satu, de kluar pigi hambur bibit. ");
INSERT INTO pmy_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Waktu de hambur bibit, ada bibit yang jatu di pinggir jalan, trus begini burung datang baru makan bibit itu sampe habis. ");
INSERT INTO pmy_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ada yang jatu di tempat yang banyak batu-batu yang de pu tana sdikit saja, trus bibit itu tumbu deng cepat karna de pu tana tipis. ");
INSERT INTO pmy_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Tapi waktu matahari naik, de layu trus kring karna akar tra masuk ke tana baik-baik. ");
INSERT INTO pmy_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Bibit lain lagi jatu di rumput duri, trus rumput duri itu tamba besar, baru baku dempet sampe tanaman itu mati, jadi de trada bua. ");
INSERT INTO pmy_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Trus ada juga yang jatu di tana yang subur. Bibit itu tumbu tamba besar baru de ada bua, ada yang 30 kali lebi banyak, ada yang 60 kali lebi banyak deng ada yang 100 kali lebi banyak.” ");
INSERT INTO pmy_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Trus De bilang, “Sapa yang pu tlinga untuk dengar, de harus dengar baik-baik!” ");
INSERT INTO pmy_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Waktu Yesus sendiri, De pu pengikut-pengikut deng De pu duablas murid tanya De tentang conto-conto itu. ");
INSERT INTO pmy_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jadi Yesus bilang ke dorang, “Kam su dapa kastau rahasia tentang Allah pu Krajaan. Tapi kalo untuk orang lain, smua-smua Sa pake conto untuk kastau ");
INSERT INTO pmy_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","supaya, ‘biar dong liat juga nanti dong tra tau apa yang kam liat, biar dong dengar juga nanti dong tra mngerti. Begitu supaya dong jang balik ke Allah baru Allah kas ampun dorang.’” ");
INSERT INTO pmy_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Trus Yesus bilang ke dorang, “Kam masi blum mngerti conto ini ka? Kalo begitu nanti kam mo mngerti conto yang lain bagemana? ");
INSERT INTO pmy_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Bibit yang orang itu de hambur itu Allah pu kata-kata. ");
INSERT INTO pmy_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Yang jatu di pinggir jalan itu sama deng orang yang dengar Allah pu kata-kata. Habis dong dengar, langsung Iblis datang ambil Allah pu kata-kata yang dong baru trima itu. ");
INSERT INTO pmy_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Trus bibit yang jatu di tana yang batu-batu, itu sama deng orang-orang yang dengar Allah pu kata-kata trus langsung trima itu deng snang skali, ");
INSERT INTO pmy_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","tapi kata-kata itu tra masuk baik-baik dalam dong pu hati jadi tinggal sbentar saja. Waktu kena susa ato dapa siksa karna su percaya Allah pu kata-kata itu, dong langsung tra percaya lagi. ");
INSERT INTO pmy_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Bibit yang jatu di rumput duri itu, orang yang dengar Allah pu kata-kata itu, ");
INSERT INTO pmy_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","tapi de lebi kuatir deng de pu hidup di dunia trus tapancing untuk mo hidup kaya, sama mo dapat macam-macam hal yang lain juga. Smua ni yang bikin de lupa Allah pu kata-kata itu makanya trada hasil apapa dalam de pu hidup. ");
INSERT INTO pmy_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Yang trakir tu, bibit yang jatu di tana yang subur. Itu sama deng orang yang dengar deng trima Allah pu kata-kata itu trus ada bua, ada yang 30 kali lebi banyak, ada yang 60 kali lebi banyak, deng ada yang 100 kali lebi banyak.” ");
INSERT INTO pmy_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Trus Yesus bilang ke dorang, “Orang bawa plita bukan untuk taru di bawa loyang ato taru di bawa tempat tidur, tapi taru plita itu di tempat yang tinggi. ");
INSERT INTO pmy_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Sama juga deng trada satu hal yang tasembunyi yang nanti tra dapa liat, trus trada rahasia yang nanti tra dapa tau. ");
INSERT INTO pmy_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Sapa yang pu tlinga untuk dengar, de harus dengar baik-baik!” ");
INSERT INTO pmy_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Trus De bilang lagi, “Dengar yang Sa bilang ni baik-baik! Kam pu cara ukur itu yang nanti Allah pake untuk ukur kam, trus juga Allah nanti tamba lagi ke kam. ");
INSERT INTO pmy_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Karna sapa yang trima apa yang de dapat, nanti de dapa kasi lebi banyak lagi. Tapi sapa yang tra mo trima apa yang de dapat, nanti itu juga dapa ambil dari dia.” ");
INSERT INTO pmy_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Trus Yesus bilang, “Allah pu Krajaan itu de pu conto sperti satu orang yang hambur bibit di de pu kebun. ");
INSERT INTO pmy_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Kalo malam de tidur, siang de bangun kerja, begitu trus-trus stiap hari. Trus bibit tu de tumbu baru ada tunas. Tapi orang tu de tra tau bagemana bibit itu de tumbu. ");
INSERT INTO pmy_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tana itu sendiri yang bikin de tumbu sampe ada hasil, pertama tu tunas, trus tangke, baru ada biji gandum di bunga. ");
INSERT INTO pmy_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Kalo biji gandum itu su tua, petani tu langsung datang ambil de pu hasil, karna itu de pu waktu untuk panen.” ");
INSERT INTO pmy_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","De bilang lagi, “Allah pu Krajaan itu sama deng apa eh? Sa kas jlas pake conto apa eh? ");
INSERT INTO pmy_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Waktu Allah jadi Raja, itu sperti biji sesawi yang orang tanam di tana. Memang biji itu yang paling kecil dari smua jenis bibit yang ada di bumi. ");
INSERT INTO pmy_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Tapi kalo su tanam, de tumbu lebi besar daripada smua sayur yang lain deng kas kluar cabang-cabang besar, sampe burung-burung liar juga bisa bikin sarang di de pu sombar.” ");
INSERT INTO pmy_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Conto macam begitu banyak yang Yesus pake untuk kastau Allah pu kata-kata itu ke dorang, ikut apa yang dong bisa mngerti. ");
INSERT INTO pmy_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Kalo tra pake conto, De tra kas ajar apapa ke dorang, tapi waktu sendiri deng De pu murid-murid, De kastau arti smua itu ke dorang. ");
INSERT INTO pmy_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Pas sore itu juga, Yesus bilang ke dorang, “Mari tong pigi ke sebla.” ");
INSERT INTO pmy_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Dong kas tinggal orang banyak itu trus naik prahu yang Yesus duduk, baru dong pigi sama-sama deng Dia, trus ada prahu brapa juga yang baku ikut ke sebla danau. ");
INSERT INTO pmy_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tra lama begini ada angin kencang skali. Ombak mulai hantam prahu itu sampe air hampir penu di prahu. ");
INSERT INTO pmy_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Waktu itu Yesus ada tidur di prahu bagian blakang pake bantal. Begini De pu murid-murid datang kas bangun De trus bilang, “Guru, Guru tra pikir tong ka? Sdikit lagi tong mo mati tenggelam!” ");
INSERT INTO pmy_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jadi Yesus bangun trus suru angin itu, deng bilang ke danau, “Diam! Tenang!” Begini angin tu langsung brenti deng danau tu tedu skali. ");
INSERT INTO pmy_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Trus Yesus bilang sama dorang, “Knapa kam takut skali? Knapa kam masi tra percaya Saya?” ");
INSERT INTO pmy_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Jadi dong takut skali baru baku tanya, “Orang ini De sapa ka, sampe angin deng danau juga ikut yang De bilang?” ");
INSERT INTO pmy_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Trus dong sampe di sebla danau, di orang Gerasa pu tempat. ");
INSERT INTO pmy_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Pas Yesus baru turun dari prahu begini, ada satu orang yang krasukan setan, de datang dari goa-goa kubur ke Yesus. ");
INSERT INTO pmy_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Orang itu de tinggal disana. Su trada orang lagi yang mampu ikat dia, biar pake rante juga. ");
INSERT INTO pmy_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Biasa de pu tangan deng kaki dapa ikat deng rante, tapi de kas putus rante itu deng de banting kas hancur. Trada orang yang kuat untuk mo tahan dia. ");
INSERT INTO pmy_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Siang malam de tinggal jalan batariak-batariak di goa-goa kubur deng bukit-bukit, trus de pukul-pukul deng kas luka de pu badan deng batu. ");
INSERT INTO pmy_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Waktu de liat Yesus dari jau, de lari ke Yesus trus tunduk di depan Yesus. ");
INSERT INTO pmy_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Trus de batariak besar bilang, “Ko mo bikin apa deng saya, Yesus Allah Yang Paling Tinggi pu Anak? Sa mohon Ko janji deng Allah pu nama, jang siksa sa ka!” ");
INSERT INTO pmy_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Karna seblum itu Yesus bilang ke dia, “He, setan ko kluar dari orang ini!” ");
INSERT INTO pmy_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Trus Yesus tanya sama orang itu, “Ko pu nama sapa?” De jawab, “Sa pu nama Legion, karna tong ini banyak skali.” ");
INSERT INTO pmy_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Legion tinggal mohon-mohon supaya Yesus jang usir dong kluar dari daera itu. ");
INSERT INTO pmy_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Dekat situ ada babi-babi banyak yang cari makan di dekat jurang. ");
INSERT INTO pmy_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Trus setan-setan itu mohon sama Yesus, bilang, “Suru tong pinda saja ke babi-babi itu, kas biar tong masuk ke dong ka!” ");
INSERT INTO pmy_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesus kas ijin dorang. Trus setan-setan itu dong kluar dari orang itu baru masuk ke dalam babi-babi itu. Rombongan babi itu skitar 2.000, dong lari ke jurang masuk ke dalam danau trus mati tenggelam. ");
INSERT INTO pmy_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Orang-orang yang jaga babi-babi itu lari, trus crita smua yang su jadi itu di kota deng kampung-kampung yang dekat situ. Trus orang-orang kluar kesana untuk liat smua yang su jadi itu. ");
INSERT INTO pmy_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Dong datang ke Yesus trus liat begini orang yang krasukan itu ada duduk, de su pake pakean, juga de su sadar, de yang tadi krasukan Legion itu. Jadi dong liat begini dong takut. ");
INSERT INTO pmy_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Orang-orang yang liat smua itu sendiri crita ke dong yang baru datang, tentang apa yang jadi sama orang yang krasukan setan deng babi-babi itu. ");
INSERT INTO pmy_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Trus dong mulai mohon ke Yesus supaya pigi kas tinggal dong pu daera. ");
INSERT INTO pmy_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Waktu Yesus naik kembali ke prahu, orang yang tadi krasukan setan itu mohon supaya de mo ikut Dia. ");
INSERT INTO pmy_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Tapi Yesus tra kas ijin de ikut, trus bilang ke dia, “Pulang ke ko pu ruma deng ke ko pu orang-orang satu kampung baru kastau dong smua yang Tuhan su buat untuk ko deng De pu baik ke ko!” ");
INSERT INTO pmy_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Jadi orang itu de pigi ke daera Dekapolis trus kastau smua yang Yesus su buat ke dia baru dong smua heran. ");
INSERT INTO pmy_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Habis itu, Yesus dong menyebrang lagi pake prahu ke sebla danau. Waktu Yesus masi ada di pinggir danau, orang banyak skali yang datang kliling Dia. ");
INSERT INTO pmy_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Begini ada satu orang yang datang, de ini satu orang dari kepala-kepala tempat ibada, de pu nama Yairus. Waktu de liat Yesus, de langsung tunduk depan Yesus pu kaki. ");
INSERT INTO pmy_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","De minta deng sunggu baru bilang, “Sa pu anak prempuan ada sakit para, de su mo mati. Bapa datang baru taru tangan di de ka, supaya de sembu deng tetap hidup.” ");
INSERT INTO pmy_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Trus Yesus pigi deng orang itu. Orang banyak skali yang ikut deng dempet ke Dia. ");
INSERT INTO pmy_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Disitu ada prempuan satu yang su 12 taun sakit pendarahan. ");
INSERT INTO pmy_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","De su pake de pu uang smua untuk brobat ke dokter ulang-ulang, tapi dong pu obat-obat bikin de susa skali, de tra sembu mala de pu sakit tamba para. ");
INSERT INTO pmy_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","De ini su dengar-dengar crita tentang Yesus, makanya biar orang banyak juga de brusaha dekat ke Yesus dari blakang baru kore Yesus pu baju panjang. ");
INSERT INTO pmy_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Karna de pikir, “Sa pasti sembu kalo sa kore De pu baju saja.” ");
INSERT INTO pmy_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Pas de pegang langsung de pu pendarahan itu brenti, trus de rasa kalo de pu sakit itu su sembu. ");
INSERT INTO pmy_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Pas waktu itu Yesus rasa kalo ada kuasa yang kluar dari Dia, jadi de balik trus tanya ke orang banyak yang ada disitu, “Sapa yang kore Sa pu baju tadi?” ");
INSERT INTO pmy_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","De pu murid-murid bilang, “Bapa su liat kalo ini orang banyak dempet Bapa, baru Bapa masi mo tanya sapa yang kore Bapa tadi?” ");
INSERT INTO pmy_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Tapi Yesus tinggal liat kliling untuk cari sapa yang tadi su bikin itu. ");
INSERT INTO pmy_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Prempuan itu takut deng gementar karna tau apa yang su jadi sama dia. Jadi de maju trus tunduk muka ke tana depan Yesus baru mngaku smua ke Dia. ");
INSERT INTO pmy_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Trus Yesus bilang sama prempuan itu, “Anak, karna ko percaya Saya, ko sembu! Skarang ko bisa pulang deng hati tenang, karna ko su sembu dari ko pu sakit.” ");
INSERT INTO pmy_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Waktu Yesus masi bicara, ada orang-orang datang dari kepala tempat ibada itu pu kluarga baru bilang, “Bapa pu anak su mati, jadi tra usa bikin susa Guru lagi.” ");
INSERT INTO pmy_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Tapi Yesus tra mo dengar dong pu kata-kata baru bilang ke Yairus, “Jang takut, percaya saja!” ");
INSERT INTO pmy_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Trus Yesus pigi tapi tra kas ijin orang ikut deng Dia, hanya Petrus, sama ade kaka dua itu, Yakobus deng Yohanes. ");
INSERT INTO pmy_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Waktu dong sampe di kepala tempat ibada itu pu ruma, disana Yesus liat orang-orang ribut skali, karna mnangis suara besar. ");
INSERT INTO pmy_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Trus Yesus masuk baru bilang ke dorang, “Knapa kam ribut deng mnangis? Anak ini de tra mati, de cuma tidur saja!” ");
INSERT INTO pmy_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Tapi dong smua bicara ejek Dia. Habis De suru dong smua kluar, De bawa anak itu de pu bapa deng mama, tamba deng De pu murid tiga orang itu, dong masuk ke dalam anak itu de pu kamar. ");
INSERT INTO pmy_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Trus Yesus De pegang anak itu pu tangan baru bilang, “Talita kum,” yang de pu arti, “Anak prempuan, Sa bilang ko, bangun suda!” ");
INSERT INTO pmy_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Langsung anak prempuan itu bangun baru jalan, de pu umur su 12 taun. Orang-orang smua yang hadir disitu dong heran skali. ");
INSERT INTO pmy_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","De larang dong deng kras untuk jang kastau ke sapa-sapa. Trus De bilang, “Kas anak ni de makan.” ");
INSERT INTO pmy_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Habis itu, Yesus brangkat dari situ deng de pu murid-murid ke De pu kampung. ");
INSERT INTO pmy_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Pas orang Yahudi pu hari Sabat, Yesus mulai kas ajar di tempat ibada. Orang banyak heran skali waktu dengar yang De kas ajar trus bilang, “De dapat smua itu dari mana? Bagemana De bisa tau smua hal deng baik skali? Bagemana De bisa bikin tanda-tanda luar biasa macam begitu? ");
INSERT INTO pmy_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","De tu tukang kayu to? Mama Maria pu anak, De pu sodara-sodara tu Yakobus, Yoses, Yudas deng Simon. De pu sodara-sodara prempuan juga ada disini sama-sama tong to?” Jadi dong kecewa trus tolak Dia. ");
INSERT INTO pmy_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Trus Yesus bilang ke dorang, “Nabi tu dimana saja de dapa hormat, tapi de tra dapa hormat di de pu kampung sendiri, di tenga-tenga de pu kluarga sama di de pu ruma.” ");
INSERT INTO pmy_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yesus tra bisa bikin tanda-tanda luar biasa apapa disana, cuma taru tangan ke brapa orang yang sakit untuk kas sembu dorang. ");
INSERT INTO pmy_vpl VALUES ("MK6_6a","071_6_6a","MRK","6","6a","6a","De heran karna dong tra percaya. ");
INSERT INTO pmy_vpl VALUES ("MK6_6b","071_6_6b","MRK","6","6b","6b","Trus Yesus jalan kliling dari kampung ke kampung untuk kas ajar orang-orang. ");
INSERT INTO pmy_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","De panggil De pu duablas murid deng mulai utus dong dua-dua orang, sama kasi dong kuasa untuk usir setan-setan. ");
INSERT INTO pmy_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Trus De pesan ke dong supaya jang bawa apapa untuk di jalan, mo makanan, tas, deng uang dalam ikat pinggang juga tra bole, cuma tongkat saja, ");
INSERT INTO pmy_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","bisa pake sendal, tapi jang bawa pakean ganti. ");
INSERT INTO pmy_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Trus De bilang lagi ke dorang, “Kalo di satu tempat kam ketemu ruma yang dong trima kam, kam tinggal disitu saja sampe kam kas tinggal kota itu. ");
INSERT INTO pmy_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Tapi kalo ada satu tempat yang dong tra trima kam deng tra mo dengar kam, kam kluar saja dari situ, trus kas bersi debu dari kam pu kaki supaya jadi tanda kalo nanti kota itu dapa hukum.” ");
INSERT INTO pmy_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jadi dong pigi kastau orang-orang untuk tobat dari dong pu dosa-dosa. ");
INSERT INTO pmy_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Dong usir banyak setan, trus gosok minyak zaitun di orang banyak yang sakit deng kas sembu dorang. ");
INSERT INTO pmy_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Raja Herodes juga dengar brita tentang Yesus, karna orang su knal Yesus pu nama di smua tempat, trus orang bilang, “Yohanes Tukang Baptis yang dulu su mati tapi skarang de hidup kembali. Itu yang De pu kuasa untuk bikin tanda-tanda luar biasa itu.” ");
INSERT INTO pmy_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Tapi ada orang lain yang bilang, “De itu Elia.” Yang lain lagi bilang, “De itu nabi lain, sama deng nabi yang dulu perna hidup.” ");
INSERT INTO pmy_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Tapi waktu Herodes de dengar itu, de bilang, “Bukan, de tu Yohanes yang sa perna suru orang potong de pu kepala, tapi skarang de su hidup kembali.” ");
INSERT INTO pmy_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Karna memang Herodes yang perna suru orang tangkap Yohanes trus ikat dia, kas masuk de di penjara karna masala Herodias. Herodes de su ambil Herodias, de pu sodara Filipus pu istri untuk kawin deng dia. ");
INSERT INTO pmy_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yohanes ulang-ulang kali tegur Herodes begini, “Ko tra bole kawin deng ko pu sodara pu istri itu!” ");
INSERT INTO pmy_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Makanya Herodias dendam ke Yohanes baru mo bunu Yohanes, tapi de tra bisa, ");
INSERT INTO pmy_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","karna Herodes takut Yohanes. De takut karna de tau Yohanes itu orang benar deng hidup kusus untuk Allah, jadi de jaga dia. Stiap kali de dengar Yohanes kas ajar, de rasa tra enak skali, tapi de tetap snang dengar apa yang Yohanes bilang. ");
INSERT INTO pmy_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Satu kali begini, Herodias dapat waktu yang pas. Waktu itu Herodes pu hari ulang taun, jadi de bikin acara untuk orang-orang penting di pemrinta, komandan-komandan deng orang-orang yang pu pengaru di Galilea. ");
INSERT INTO pmy_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Waktu itu Herodias pu anak prempuan de masuk trus mnari. De bikin Herodes deng de pu tamu-tamu pu hati snang skali, jadi raja bilang ke anak prempuan itu, “Ko bisa minta apa saja yang ko mau, nanti sa kasi itu ke ko.” ");
INSERT INTO pmy_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Trus Herodes sumpa ke de baru bilang, “Nanti sa kasi apa saja yang ko minta, biar ko minta stenga dari sa pu krajaan juga!” ");
INSERT INTO pmy_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Jadi, anak prempuan itu pigi tanya de pu mama, bilang, “Mama, sa minta apa bole eh?” Trus de pu mama bilang, “Ko minta Yohanes Tukang Baptis pu kepala.” ");
INSERT INTO pmy_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Langsung de kembali cepat-cepat ke raja Herodes trus bilang, “Sa mau skarang ini bapa kasi sa Yohanes Tukang Baptis pu kepala di atas piring besar!” ");
INSERT INTO pmy_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Trus raja Herodes pu hati sedi skali, tapi de tra bisa tolak itu, karna de su sumpa di depan de pu tamu-tamu. ");
INSERT INTO pmy_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Jadi de langsung suru de pu tentara satu untuk ambil Yohanes pu kepala. Orang itu de pigi baru de potong Yohanes pu kepala di penjara. ");
INSERT INTO pmy_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","De bawa kepala itu di piring besar satu trus kasi ke anak prempuan itu, trus anak prempuan itu kasi juga ke de pu mama. ");
INSERT INTO pmy_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Waktu Yohanes pu murid-murid dengar smua tu, dong datang ambil de pu mayat trus bawa taru di tempat kubur. ");
INSERT INTO pmy_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Waktu Yesus pu utusan-utusan kembali trus kumpul deng Dia, dong crita smua yang dong su bikin deng smua yang dong su kas ajar. ");
INSERT INTO pmy_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Trus De bilang ke dorang, “Mari tong pigi ke tempat sunyi, supaya tong bisa sendiri trus kam bisa istirahat sbentar!” Karna memang orang banyak skali yang datang trus pigi, bikin sampe dong mo makan juga tra bisa. ");
INSERT INTO pmy_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Jadi dong pake prahu pigi sendiri ke tempat yang sunyi. ");
INSERT INTO pmy_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Tapi waktu dong pigi, orang banyak yang liat dong deng tau dong mo kemana. Jadi orang-orang dari smua kota di wilaya itu cepat-cepat jalan kaki duluan dorang. ");
INSERT INTO pmy_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Waktu sampe di darat, Yesus liat orang banyak ada kumpul. De rasa kasian skali sama dorang, karna dong macam domba yang tra pu gembala, trus De mulai kas ajar dong banyak hal. ");
INSERT INTO pmy_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Pas waktu su mo malam, De pu murid-murid datang sama De baru bilang, “Bapa, tempat ini sunyi baru su mo malam. ");
INSERT INTO pmy_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Suru dong pigi ke kampung-kampung deng tempat-tempat dekat sini suda, supaya dong bisa bli makan untuk dorang.” ");
INSERT INTO pmy_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Tapi Yesus bilang ke dorang, “Kam yang harus kasi dong makan!” Dong bilang ke Dia, “Tra mungkin tong mo dapat 200 uang perak untuk pigi bli roti kas makan dong to?” ");
INSERT INTO pmy_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Tapi Yesus bilang dorang, “Roti brapa yang ada di kam situ? Coba cek dulu!” Habis cek dong bilang, “Ada lima roti deng dua ikan.” ");
INSERT INTO pmy_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Trus De suru orang-orang itu duduk klompok-klompok di atas rumput yang hijou. ");
INSERT INTO pmy_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Jadi dong smua duduk klompok-klompok, ada yang 100 orang, ada yang 50 orang. ");
INSERT INTO pmy_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Habis ambil lima roti deng dua ikan itu, De liat ke langit trus doa syukur ke Allah, trus pata-pata roti tu baru kasi sama De pu murid-murid supaya dong kasi ke orang-orang yang banyak itu. Ikan dua itu juga sama, de bagi-bagi ke dong smua. ");
INSERT INTO pmy_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Trus dong smua makan sampe kenyang. ");
INSERT INTO pmy_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Habis itu orang kumpul roti-roti yang lebi deng ikan-ikan yang sisa, smua tu ada 12 loyang penu. ");
INSERT INTO pmy_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Orang-orang yang ikut makan roti tu laki-laki saja ada 5.000 orang. ");
INSERT INTO pmy_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Habis itu, Yesus langsung suru De pu murid-murid naik ke prahu, baru bilang dong pigi duluan ke sebla, ke Betsaida. Trus De suru orang banyak itu pulang. ");
INSERT INTO pmy_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Stela dong baku pisa, De pigi ke bukit untuk berdoa. ");
INSERT INTO pmy_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Waktu su mo malam prahu tu su di tenga-tenga danau, baru Yesus sendiri di darat. ");
INSERT INTO pmy_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Waktu itu De liat dong ada penggayu stenga mati skali karna angin baku lawan ara deng prahu. Begini kira-kira jam tiga malam, Yesus datang ke dong deng jalan di atas air trus macam mo lewat dorang. ");
INSERT INTO pmy_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Waktu dong liat De jalan di atas air, dong pikir De tu setan, jadi dong takut deng batariak-batariak. ");
INSERT INTO pmy_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Karna dong smua liat Dia, trus dong kaget skali. Tapi langsung De bilang ke dorang, “Ini Saya, jang takut! Kas kuat kam pu hati!” ");
INSERT INTO pmy_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Habis itu De naik ke prahu yang dong su duduk trus angin langsung tenang. Dong smua heran skali, ");
INSERT INTO pmy_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","karna biar dong su liat Yesus kas makan orang banyak itu juga, dong tetap tra mngerti karna dong pu hati kras. ");
INSERT INTO pmy_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Waktu sampe di sebla, Yesus deng De pu murid-murid turun di Genesaret trus dong ikat prahu disitu. ");
INSERT INTO pmy_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Waktu dong kluar dari prahu, orang-orang langsung knal Yesus. ");
INSERT INTO pmy_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Jadi dong pigi cepat-cepat ke smua tempat di daera itu, trus dong mulai bawa orang-orang sakit di atas dong pu tikar ke tempat mana yang dong dengar Yesus ada. ");
INSERT INTO pmy_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Biar Yesus pigi kemana saja, ke kota-kota ka, ke kampung-kampung ka, ke tempat-tempat yang jau dari kota ka, orang tetap bawa orang-orang sakit ke tempat-tempat yang biasa orang kumpul. Trus dong mohon ke Dia, supaya kas ijin dong biar hanya pegang De pu baju panjang pu ujung saja, trus smua orang yang pegang De pu baju itu jadi sembu. ");
INSERT INTO pmy_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Orang-orang Farisi deng guru-guru agama brapa yang datang dari Yerusalem ketemu Yesus. ");
INSERT INTO pmy_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Dong liat begini Yesus pu murid-murid brapa orang makan pake tangan yang tra bersi mnurut agama, seblum makan dong tra cuci tangan ikut aturan agama. ");
INSERT INTO pmy_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Karna orang Farisi dong sama deng orang Yahudi smua trakan makan kalo tra cuci tangan mnurut de pu cara, karna dong tu pegang dong pu nene moyang pu adat kuat skali. ");
INSERT INTO pmy_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Dong tu kalo baru pulang dari pasar, dong trakan makan kalo dong blum kas bersi dong pu badan. Ada banyak aturan lain lagi yang dong pegang mati, sperti cara cuci glas, tempayan deng barang-barang dari tembaga deng tempat tidur. ");
INSERT INTO pmy_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Makanya orang-orang Farisi deng guru-guru agama dong tanya ke Yesus, “Ko pu murid-murid knapa tra ikut tua-tua adat pu aturan? Knapa dong makan deng tangan tra bersi?” ");
INSERT INTO pmy_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Tapi Yesus bilang ke dong begini, “Kam ni pura-pura baik! Memang betul yang Nabi Yesaya bilang tentang kam. Sperti ada tatulis, ‘Bangsa ini puji-puji Sa deng dong pu mulut, padahal dong pu hati jau dari Saya. ");
INSERT INTO pmy_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Percuma saja dong semba Saya, karna ajaran yang dong kas ajar tu hanya ikut manusia pu aturan.’ ");
INSERT INTO pmy_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Kam malas tau deng Allah pu printa, baru kam pegang mati manusia pu aturan.” ");
INSERT INTO pmy_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Trus Yesus bilang ke dorang, “Kam memang paling pintar cari alasan untuk tra ikut Allah pu printa biar kam bisa ikut kam pu aturan sendiri. ");
INSERT INTO pmy_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Karna memang dalam Kitab Suci Musa bilang, ‘Hormati ko pu bapa deng mama!’ Deng, ‘Sapa yang hina de pu bapa ato mama harus dapa hukum mati.’ ");
INSERT INTO pmy_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Tapi yang kam kas ajar, orang tra bikin sala kalo bilang ke de pu bapa ato mama, ‘Smua barang yang sa harus kasi ke bapa deng mama, sa su janji untuk kasi itu ke Allah.’ ");
INSERT INTO pmy_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Brarti kam kas biar orang itu de tra bikin apapa lagi untuk tolong de pu bapa ato mama. ");
INSERT INTO pmy_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Jadi deng aturan yang kam ajar itu, kam kas hilang Allah pu printa. Yang begini tu banyak skali yang kam bikin.” ");
INSERT INTO pmy_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Trus Yesus De panggil orang banyak itu lagi baru bilang ke dorang, “Kam smua, dengar apa yang Sa bilang ni baik-baik: ");
INSERT INTO pmy_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Trada apa saja yang dari luar, yang masuk ke dalam orang pu hati yang bikin de tra bersi depan Allah, tapi yang kluar dari de pu hati itu yang bikin de tra bersi.”  ");
INSERT INTO pmy_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Sapa saja yang pu tlinga untuk dengar, de harus dengar baik-baik! ");
INSERT INTO pmy_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Habis itu Yesus kas tinggal orang banyak itu trus masuk ke ruma satu, begini De pu murid-murid tanya De tentang conto itu pu arti. ");
INSERT INTO pmy_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Trus Yesus jawab, “Kam juga masi tra mngerti ka? Kam tra tau ka, kalo apa saja yang masuk dari luar ke dalam tra bisa bikin orang tra bersi di depan Allah? ");
INSERT INTO pmy_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Karna apa yang orang makan tu tra masuk ke dalam hati tapi ke dalam de pu perut trus dong buang di tempat buang air besar.” Jadi deng bilang begitu De kastau kalo makanan smua bersi. ");
INSERT INTO pmy_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","De bilang lagi, “Apa yang kluar dari dalam orang pu hati, itu yang bikin de tra bersi depan Allah. ");
INSERT INTO pmy_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Karna dari dalam, dari orang pu hati, muncul smua pikiran jahat untuk bikin barang kurang ajar, curi, bunu orang, ");
INSERT INTO pmy_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","tidur deng orang yang bukan de pu pasangan, mata besar uang, bikin jahat, pintar tipu, hidup ikut de pu napsu jahat, iri hati, bikin rusak orang pu nama, sombong, deng kepala batu. ");
INSERT INTO pmy_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Smua hal jahat ini yang muncul dari dalam trus bikin orang tra bersi depan Allah.” ");
INSERT INTO pmy_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Trus Yesus kas tinggal tempat itu baru pigi ke daera dekat Kota Tirus. De masuk ke ruma satu trus De tra mau orang tau kalo De ada disitu. Tapi tetap saja orang bisa tau De ada. ");
INSERT INTO pmy_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Mala prempuan satu, yang de pu anak prempuan krasukan setan, waktu de dengar kalo Yesus ada disitu, de langsung datang trus tunduk depan Yesus pu kaki. ");
INSERT INTO pmy_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Prempuan itu de orang Yunani, de dari daera Fenisia, Propinsi Siria. De mohon Yesus untuk usir setan tu kluar dari de pu anak prempuan. ");
INSERT INTO pmy_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Tapi Yesus bilang ke dia, “Kas biar anana makan kenyang dulu, karna tra baik ambil anana pu makanan baru lempar ke anjing.” ");
INSERT INTO pmy_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Tapi prempuan tu de jawab, “Betul Bapa, tapi anjing-anjing yang di bawa meja juga dong makan sisa-sisa makanan yang anana kas jatu.” ");
INSERT INTO pmy_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Trus Yesus bilang ke prempuan itu, “Karna ko pu kata-kata itu, pulang suda skarang, setan tu su kluar dari ko pu anak.” ");
INSERT INTO pmy_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Prempuan tu pulang ke de pu ruma, begini de liat de pu anak itu ada baring di tempat tidur trus setan itu su kluar dari dia. ");
INSERT INTO pmy_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Habis itu, Yesus pigi dari daera dekat Kota Tirus ke danau Galilea lewat Kota Sidon deng lewat daera Dekapolis. ");
INSERT INTO pmy_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Disitu dong bawa satu orang yang tuli baru mou-mou ke Yesus trus mohon untuk De taru tangan di dia. ");
INSERT INTO pmy_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jadi, Yesus kas pisa de dari orang banyak itu, supaya dong sendiri. De kas masuk De pu jari ke orang itu tlinga, trus luda baru raba orang itu de pu lida. ");
INSERT INTO pmy_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Trus Yesus tarik napas dalam-dalam, liat ke langit baru bilang ke dia, “Efata!” yang de pu arti, “Tabuka!” ");
INSERT INTO pmy_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Waktu itu juga orang itu de pu tlinga tabuka trus de bisa kas grak de pu lida, baru de mulai bicara jlas. ");
INSERT INTO pmy_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesus larang dong supaya jang crita ke sapa-sapa. Tapi kalo Yesus tamba larang, dong tamba pigi crita ke mana-mana. ");
INSERT INTO pmy_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Trus orang-orang yang dengar smua tu dong heran skali baru bilang, “Apa saja yang De bikin tu baik skali. De bikin orang yang tuli bisa dengar deng yang bisu bisa bicara.” ");
INSERT INTO pmy_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Tra lama begini, ada rombongan orang banyak lagi yang datang kumpul dekat Yesus. Trus karna dong tra pu makanan, jadi Yesus panggil De pu murid-murid baru bilang, ");
INSERT INTO pmy_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Sa kasian skali sama orang banyak ini. Su tiga hari dong ada sama-sama deng Sa baru dong tra pu makanan. ");
INSERT INTO pmy_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Kalo Sa suru dong pulang ke dong pu ruma deng perut kosong, nanti dong bisa pingsan di jalan, apalagi dong yang datang dari jau.” ");
INSERT INTO pmy_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Yesus pu murid-murid jawab, “Tong mo kas makan orang banyak ini deng roti di tempat sunyi sperti begini bagemana?” ");
INSERT INTO pmy_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesus tanya ke dorang, “Kam pu roti ada brapa?” Dong jawab, “Ada tuju.” ");
INSERT INTO pmy_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jadi De suru orang banyak itu dong duduk di tana. Trus De ambil roti tuju itu, baru doa syukur ke Allah. Habis itu De pata-pata roti itu trus kasi ke De pu murid-murid supaya dong bagi-bagi ke orang banyak itu, jadi dong ambil trus bagi-bagi. ");
INSERT INTO pmy_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Dong juga ada pu ikan kecil brapa. De doa syukur ke Allah untuk ikan itu, trus De suru bagi-bagi ikan itu juga. ");
INSERT INTO pmy_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Trus dong makan sampe kenyang. Habis itu, dong kumpul roti-roti yang lebi, smua ada tuju loyang besar. ");
INSERT INTO pmy_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Dong smua kira-kira ada 4.000 orang. Habis itu Yesus suru dong pulang. ");
INSERT INTO pmy_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Trus De naik ke prahu sama-sama deng De pu murid-murid baru dong pigi ke daera Dalmanuta. ");
INSERT INTO pmy_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Begini orang-orang Farisi dong datang trus mulai baku tawar deng Yesus. Dong minta De buat satu tanda kalo De dari surga, karna dong mo coba Dia. ");
INSERT INTO pmy_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Pas dengar begitu, Yesus rasa hati susa trus bilang ke dorang, “Apa yang bikin sampe kam orang-orang jaman ini tuntut satu tanda heran? Yang Sa bilang ini benar: sama kam Sa tra kasi satu tanda juga.” ");
INSERT INTO pmy_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Trus De kas tinggal dong baru naik kembali ke prahu, baru pigi menyebrang ke sebla. ");
INSERT INTO pmy_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yesus pu murid-murid lupa bawa roti, baru roti yang ada di dong pu prahu itu cuma satu saja. ");
INSERT INTO pmy_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Trus Yesus kas ingat dorang, “Awas, kam harus hati-hati deng ragi dari klompok Farisi deng ragi dari Raja Herodes.” ");
INSERT INTO pmy_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Begini dong baku bilang yang satu ke yang lain, “De bicara begitu karna tong tra pu roti.” ");
INSERT INTO pmy_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Tapi Yesus tau kalo dong ada bicara begitu jadi De bilang, “Knapa kam bicara tentang trada roti? Kam masi blum tau deng blum mngerti juga ka? Kam pu hati masi kras ka? ");
INSERT INTO pmy_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Kam pu mata tapi knapa kam tra liat? Kam pu tlinga tapi knapa kam tra dengar? Kam tra ingat ka? ");
INSERT INTO pmy_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Waktu Sa pata-pata lima roti untuk 5.000 orang itu, kam kumpul roti yang lebi ada brapa loyang penu?” Dong jawab, “12 loyang.” ");
INSERT INTO pmy_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yesus tanya lagi, “Waktu Sa pata-pata tuju roti untuk 4.000 orang itu, kam kumpul roti-roti yang lebi ada brapa loyang penu?” Dong jawab, “Tuju loyang.” ");
INSERT INTO pmy_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Trus De bilang lagi ke dorang, “Kam masi blum mngerti ka?” ");
INSERT INTO pmy_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Habis itu Yesus deng De pu murid-murid tiba di Kota Betsaida. Disitu orang-orang bawa orang buta satu ke Yesus trus mohon ke Dia, supaya De taru tangan di orang buta itu. ");
INSERT INTO pmy_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jadi Yesus pegang orang buta tu de pu tangan trus bawa de kluar dari kota itu. Trus Yesus luda di orang itu pu mata baru taru tangan di dia, trus tanya dia, “Ko bisa liat apa begitu?” ");
INSERT INTO pmy_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Orang itu de liat ke depan trus bilang, “Sa liat orang-orang jalan, tapi dong kliatan macam pohon.” ");
INSERT INTO pmy_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Trus Yesus taru tangan lagi di orang itu pu mata, langsung de betul-betul su bisa liat. De su sembu, jadi de bisa liat smua-smua deng jlas. ");
INSERT INTO pmy_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Trus Yesus bilang ke dia, “Pulang skarang suda, tapi jang lewat kota itu.” ");
INSERT INTO pmy_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Habis itu, Yesus deng De pu murid-murid pigi ke kampung-kampung di skitar Kota Kaisarea Filipi. Di tenga jalan De tanya ke De pu murid-murid, “Orang dong bilang Sa ni sapa?” ");
INSERT INTO pmy_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Dong jawab ke Dia, “Ada yang bilang Yohanes Tukang Baptis, ada yang bilang Elia, ada juga yang bilang satu dari nabi-nabi.” ");
INSERT INTO pmy_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","De tanya ke dorang, “Tapi kam bilang, Sa ni sapa?” Petrus jawab, “Bapa itu Raja Yang Allah Pili.” ");
INSERT INTO pmy_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Trus Yesus larang dong deng kras supaya jang kastau ke sapa-sapa tentang Dia. ");
INSERT INTO pmy_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Habis itu, Yesus mulai kas ajar dong kalo Anak Manusia harus dapa siksa banyak deng dapa tolak dari orang Yahudi pu tua-tua deng imam-imam kepala sama guru-guru agama, trus dapa bunu, tapi hidup kembali di hari ketiga. ");
INSERT INTO pmy_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesus bilang itu smua di depan-depan, tapi Petrus tarik Yesus ke pinggir baru tegur Dia. ");
INSERT INTO pmy_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Tapi Yesus balik badan liat De pu murid-murid baru De tegur Petrus, De bilang, “Iblis, pigi dari sini! Karna ko bukan pikir yang Allah pikir tapi apa yang manusia pikir.” ");
INSERT INTO pmy_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Trus Yesus panggil orang banyak deng De pu murid-murid baru bilang ke dorang, “Kalo ada orang yang mo ikut Saya, de tra bole ikut de pu mau, trus harus pikul de pu salib deng ikut Saya. ");
INSERT INTO pmy_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Karna sapa saja yang mo kas slamat de pu hidup, nanti de tra dapat hidup yang trada akir. Tapi orang yang kasi de pu hidup untuk Sa deng karna Brita Baik, de yang nanti slamat. ");
INSERT INTO pmy_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ada untung ka, kalo satu orang de dapat smua harta di dunia ini tapi de tra dapat hidup yang trada akir itu? ");
INSERT INTO pmy_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ada ka yang de bisa kasi untuk dapat hidup yang trada akir itu? ");
INSERT INTO pmy_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Sapa saja yang malu akui Sa deng Sa pu kata-kata di depan orang-orang yang tra setia deng yang bikin dosa ini, Sa Anak Manusia juga nanti malu karna orang itu waktu Sa datang deng cahaya yang penu kuasa dari Sa pu Bapa, sama-sama deng Allah pu malaikat-malaikat.” ");
INSERT INTO pmy_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesus bilang lagi ke dorang, “Yang Sa bilang ini benar: Dari kam yang hadir disini ada yang trakan mati sampe dong liat Allah pu Krajaan datang di bumi ini deng penu kuasa.” ");
INSERT INTO pmy_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Lewat enam hari begini, Yesus bawa Petrus, Yakobus deng Yohanes, De sama-sama dong naik ke gunung satu yang tinggi. Dong sendiri saja disitu. Trus Yesus kliatan jadi lain di depan dorang. ");
INSERT INTO pmy_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","De pu pakean jadi puti trang skali. Trada orang di dunia ini yang bisa bikin puti pakean macam begitu. ");
INSERT INTO pmy_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Tiba-tiba dong liat Elia deng Musa, dong dua ada bicara deng Yesus. ");
INSERT INTO pmy_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Petrus bilang ke Yesus, “Guru, snang skali tong ada disini. Lebi baik tong kas bediri tiga kema, satu untuk Guru, satu untuk Musa baru satu untuk Elia.” ");
INSERT INTO pmy_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","De bilang begitu karna de tra tau mo bilang apa lagi, karna dong takut yang tra baik punya. ");
INSERT INTO pmy_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Trus awan puti datang tutup dong baru ada suara dari awan itu bilang, “Ini Sa pu Anak yang Sa sayang, kam harus dengar Dia.” ");
INSERT INTO pmy_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Waktu dong liat kliling, tiba-tiba dong tra liat sapa-sapa lagi deng dorang, cuma Yesus sendiri saja. ");
INSERT INTO pmy_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Waktu dong turun dari gunung itu, Yesus larang dong supaya jang crita apa yang dong su liat itu ke sapa-sapa sampe De Anak Manusia hidup kembali dari tenga-tenga orang mati. ");
INSERT INTO pmy_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Jadi, dong tra crita apa yang dong su liat itu ke sapa-sapa, tapi dong baku tanya tentang apa yang Yesus maksud deng, ʻmati trus hidup kembali dari tenga-tenga orang mati.ʼ ");
INSERT INTO pmy_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Trus dong tanya ke Dia, “Knapa guru-guru agama bilang kalo Elia harus datang duluan?” ");
INSERT INTO pmy_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesus jawab, “Memang Elia harus datang duluan untuk bikin smua-smua jadi baik lagi. Tapi apa yang ada tatulis tentang Sa Anak Manusia yang Allah utus? Sa harus mendrita banyak deng dapa hina to? ");
INSERT INTO pmy_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Tapi Sa bilang kam, memang Elia su datang. Tapi orang-orang bikin de tra baik sperti dong pu mau. Itu sama deng apa yang ada tatulis tentang de di Kitab Suci.” ");
INSERT INTO pmy_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Waktu Yesus, Petrus, Yakobus deng Yohanes dong kembali ke murid-murid yang lain, dong liat orang banyak skali disitu trus guru-guru agama brapa orang ada baku tawar deng Yesus pu murid-murid dorang. ");
INSERT INTO pmy_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Waktu orang-orang itu dong liat Yesus, dong kaget skali baru lari pigi jemput Dia. ");
INSERT INTO pmy_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Trus Yesus tanya ke dorang, “Kam baku tawar apa deng dorang?” ");
INSERT INTO pmy_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Begini satu orang dari orang banyak itu bilang, “Bapa Guru, sa datang bawa sa pu anak ke Guru karna de krasukan setan sampe de bisu. ");
INSERT INTO pmy_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kalo setan itu srang dia, de tabanting ke tana baru de mulut busa kluar, trus de pu gigi deng de pu badan takancing. Sa su minta Bapa pu murid-murid supaya dong usir setan itu tapi dong tra bisa.” ");
INSERT INTO pmy_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jadi Yesus bilang ke dorang, “Kam memang orang-orang yang tra percaya, mo sampe kapan Sa harus tinggal di tenga kam? Sampe kapan Sa harus sabar deng kam? Bawa anak itu ke Saya!” ");
INSERT INTO pmy_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Dong langsung bawa de ke Yesus. Waktu setan itu de liat Yesus, de bikin anak itu langsung kejang-kejang trus jatu taguling-guling di tana baru busa kluar dari de pu mulut. ");
INSERT INTO pmy_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Trus Yesus tanya ke anak itu pu bapa, “De su begini brapa lama?” De pu bapa bilang, “Dari de masi kecil. ");
INSERT INTO pmy_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Setan itu biasa seret de ke dalam api ato ke dalam air untuk bunu dia. Tapi kalo Bapa bisa tolong, Bapa tolong ka! Kasian tong Bapa!” ");
INSERT INTO pmy_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Tapi Yesus bilang ke dia, “Knapa ko bilang, ‘Kalo Bapa bisa’? Apa saja bisa jadi untuk orang yang percaya.” ");
INSERT INTO pmy_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Langsung anak itu de pu bapa batariak bilang, “Sa percaya, tapi tolong sa supaya sa lebi percaya lagi!” ");
INSERT INTO pmy_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Waktu Yesus liat orang-orang mulai tamba banyak, De printa setan itu baru bilang, “He ko setan yang bikin sampe anak ini bisu deng tuli, Sa bilang ko, ko kluar dari anak ini trus jang perna masuk ke dalam de lagi!” ");
INSERT INTO pmy_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Setan itu batariak, baru bikin anak itu kejang-kejang, trus kluar dari dia. Anak itu kliatan macam orang mati. Jadi banyak orang yang bilang, “De su mati.” ");
INSERT INTO pmy_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Tapi Yesus pegang anak itu de pu tangan untuk kas bangun dia, baru de bediri. ");
INSERT INTO pmy_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Waktu Yesus su masuk ke ruma trus De pu murid-murid sendiri deng Dia, dong tanya ke Dia, “Knapa tong tra bisa usir setan itu e?” ");
INSERT INTO pmy_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","De bilang ke dorang, “Setan macam begitu tra bisa usir deng cara lain cuma deng doa saja.” ");
INSERT INTO pmy_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesus deng De pu murid-murid pigi dari situ trus dong jalan lewat daera Galilea. Yesus tra mau orang-orang tau De ada dimana, ");
INSERT INTO pmy_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","karna De ada kas ajar De pu murid-murid. De bilang ke dorang, “Sa Anak Manusia nanti dapa kasi ke dalam tangan manusia baru nanti dong bunu Saya, tapi hari ketiga stela Sa dapa bunu, nanti Sa hidup kembali!” ");
INSERT INTO pmy_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Dong tra mngerti kata-kata itu, tapi dong tra brani untuk mo tanya ke Dia. ");
INSERT INTO pmy_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Trus Yesus deng De pu murid-murid sampe di Kota Kapernaum. Waktu Yesus su di ruma, De tanya ke De pu murid-murid, “Apa yang kam bicara-bicara waktu tong jalan tadi?” ");
INSERT INTO pmy_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Tapi dong diam, karna di jalan tadi dong baku ribut tentang sapa yang paling penting dari dorang. ");
INSERT INTO pmy_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Trus Yesus duduk baru panggil De pu duablas murid baru De bilang ke dorang, “Kalo satu orang mo jadi yang pertama, de harus jadi yang trakir dari smua deng harus layani smua orang.” ");
INSERT INTO pmy_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Trus Yesus ambil anak kecil satu baru kas bediri di tenga-tenga dong baru De peluk anak itu deng bilang ke dorang, ");
INSERT INTO pmy_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Sapa saja yang trima satu anak sperti ini karna de percaya dalam Sa pu nama, itu de trima Saya. Trus sapa saja yang trima Saya, bukan Sa saja yang de trima, tapi de trima De yang su utus Saya.” ");
INSERT INTO pmy_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yohanes bilang ke Yesus, “Guru, tong liat satu orang de usir setan pake Guru pu nama. Karna de tra ikut tong jadi tong larang dia!” ");
INSERT INTO pmy_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Tapi Yesus De bilang, “Jang kam larang dia! Karna trada orang yang bisa bikin tanda luar biasa pake Sa pu nama, baru langsung mo balik bicara-bicara tra baik tentang Saya. ");
INSERT INTO pmy_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Sapa saja yang tra mlawan kitong, de tu tong pu teman. ");
INSERT INTO pmy_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Yang Sa bilang ini benar: Sapa saja yang bantu kam biar cuma kasi air satu glas saja untuk kam minum, karna kam Kristus pu pengikut, Allah pasti kasi de pu bagian.” ");
INSERT INTO pmy_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Yesus bilang lagi, “Sapa saja yang bikin sampe satu dari anana kecil yang percaya Sa ni bikin dosa, lebi baik untuk de kalo orang ikat batu besar di de pu leher baru buang de ke laut. ");
INSERT INTO pmy_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kalo ko pu tangan bikin sampe ko bikin dosa, potong suda! Karna lebi baik ko masuk ke dalam hidup yang trada akir deng ko pu tangan putus daripada ko pu tangan dua-dua lengkap tapi ko masuk neraka, yang de pu api tra bisa padam. ");
INSERT INTO pmy_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Di tempat itu api tra bisa padam deng ulat yang makan manusia pu mayat tra mati. ");
INSERT INTO pmy_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Kalo ko pu kaki bikin sampe ko bikin dosa, potong suda! Karna lebi baik ko masuk ke dalam hidup yang trada akir deng kaki putus daripada ko pu kaki dua-dua lengkap tapi ko dapa buang ke dalam neraka.  ");
INSERT INTO pmy_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Di tempat itu api tra bisa padam deng ulat yang makan manusia pu mayat tra mati. ");
INSERT INTO pmy_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Kalo ko pu mata bikin sampe ko bikin dosa, cungkil suda! Karna lebi baik ko masuk ke dalam Allah pu Krajaan deng mata sebla daripada ko pu mata dua-dua lengkap tapi dapa buang ke neraka, ");
INSERT INTO pmy_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","yang de pu api tra bisa padam sama ulat yang makan manusia pu mayat juga tra mati. ");
INSERT INTO pmy_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Smua orang nanti dapa uji sperti ada di dalam api, sama deng orang taru garam di korban persembahan. ");
INSERT INTO pmy_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Garam itu baik, tapi kalo de su tra rasa asin, bisa ka bikin de pu rasa asin lagi? Kam harus sperti garam yang masi baik, kam harus hidup baku damei satu deng yang lain.” ");
INSERT INTO pmy_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Habis itu, Yesus brangkat ke daera Yudea deng daera di sebla kali Yordan, trus banyak orang datang lagi kumpul kliling Dia, trus De kas ajar dong sperti biasa lagi. ");
INSERT INTO pmy_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Trus orang-orang Farisi datang untuk coba Yesus, dong tanya ke Dia, “Di tong pu hukum agama, bisa ka kalo suami cerai deng de pu istri?” ");
INSERT INTO pmy_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesus jawab, “Musa printa apa ke kam?” ");
INSERT INTO pmy_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Dong jawab, “Musa kas ijin bikin surat cerai baru cerai.” ");
INSERT INTO pmy_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Trus Yesus bilang ke dorang, “Karna memang kam pu kepala batu jadi Musa tulis aturan itu untuk kas ijin kam cerai. ");
INSERT INTO pmy_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Tapi dari pertama waktu Allah bikin dunia ini, ‘Allah bikin dong tu laki-laki deng prempuan. ");
INSERT INTO pmy_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Itu jadi laki-laki tra tinggal lagi sama de pu bapa deng mama, tapi hidup satu hati deng de pu istri, ");
INSERT INTO pmy_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","biar dong dua jadi satu.’ Jadi dong dua bukan dua orang lagi tapi satu. ");
INSERT INTO pmy_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Jadi, apa yang Allah su kas satu, manusia tra bole kas pisa.” ");
INSERT INTO pmy_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Waktu dong su di ruma, murid-murid tanya lagi ke Yesus tentang itu. ");
INSERT INTO pmy_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Trus De bilang ke dorang, “Sapa saja yang kas cerai de pu istri baru pigi kawin lagi deng prempuan lain, itu de su bikin dosa ke de pu istri karna su tidur deng orang yang bukan de pu pasangan. ");
INSERT INTO pmy_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Begitu juga deng prempuan yang kas cerai de pu suami trus kawin lagi deng laki-laki lain, itu de su bikin dosa karna su tidur deng orang yang bukan de pu pasangan.” ");
INSERT INTO pmy_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Trus orang-orang bawa anana kecil ke Yesus supaya De taru tangan untuk berkati dorang. Tapi De pu murid-murid mara orang-orang itu. ");
INSERT INTO pmy_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Waktu Yesus liat dong bikin begitu, De mara baru bilang ke dorang, “Kas biar anana kecil itu datang ke Saya, jang larang-larang dong, karna orang-orang sperti begini yang punya Allah pu Krajaan. ");
INSERT INTO pmy_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Yang Sa bilang ini benar: Sapa saja yang tra mo trima Allah pu Krajaan di de pu hidup sperti anak kecil, de tra bisa masuk dalam Allah pu Krajaan.” ");
INSERT INTO pmy_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Trus De peluk anana itu baru De taru tangan untuk berkati dorang. ");
INSERT INTO pmy_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Waktu Yesus De jalan lanjut lagi, ada satu orang yang lari ke De baru tanam lutut depan De trus tanya, “Bapa Guru yang baik, sa harus bikin apa supaya bisa hidup trus sampe trada akir?” ");
INSERT INTO pmy_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesus jawab, “Knapa ko bilang Sa baik? Trada satu orang yang baik cuma Allah saja. ");
INSERT INTO pmy_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ko pasti tau Allah pu printa-printa, ‘Jang bunu orang, jang tidur deng orang yang bukan ko pu pasangan, jang curi, jang jadi saksi yang tra benar, jang tipu-tipu orang, juga hormati ko pu bapa deng mama. ’” ");
INSERT INTO pmy_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Trus orang itu bilang ke Dia, “Guru, Allah pu printa itu smua sa su bikin dari sa muda.” ");
INSERT INTO pmy_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesus liat de deng rasa sayang, baru bilang ke dia, “Tinggal satu lagi yang ko blum bikin. Pigi baru jual smua yang ko punya trus kasi itu sama orang-orang miskin, deng bikin begitu ko nanti dapat harta di surga. Habis itu baru ko datang ikut Saya.” ");
INSERT INTO pmy_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Dengar begitu langsung de pu hati hancur, trus de pigi deng rasa sedi skali, karna de pu harta banyak. ");
INSERT INTO pmy_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Trus Yesus liat De pu murid-murid yang ada kliling De baru bilang ke dorang, “Memang susa skali orang yang pu harta banyak masuk dalam Allah pu Krajaan.” ");
INSERT INTO pmy_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","De pu murid-murid heran dengar apa yang De bilang itu. Tapi Yesus bilang lagi, “Sa pu anana, memang susa skali masuk dalam Allah pu Krajaan. ");
INSERT INTO pmy_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Lebi gampang satu ekor unta masuk lewat lobang jarum daripada satu orang kaya masuk dalam Allah pu Krajaan.” ");
INSERT INTO pmy_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Dong tamba heran lagi, trus bilang ke yang lain, “Kalo begitu sapa yang bisa slamat?” ");
INSERT INTO pmy_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesus liat dong baru bilang, “Manusia tra bisa kas slamat de pu diri sendiri, tapi tra begitu untuk Allah, karna apa saja pasti bisa untuk Allah.” ");
INSERT INTO pmy_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Trus Petrus bilang ke Yesus, “Liat, tong su kas tinggal smua-smua untuk ikut Bapa!” ");
INSERT INTO pmy_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesus jawab, “Yang Sa bilang ini benar: Orang yang kas tinggal de pu ruma, de pu sodara laki-laki ato sodara prempuan, de pu mama ato bapa, de pu anana ato de pu kebun karna Saya, deng karna mau kastau Brita Baik, ");
INSERT INTO pmy_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","orang itu di waktu skarang ini pasti dapat 100 kali lebi banyak: ruma, sodara laki-laki, sodara prempuan, mama, anana deng kebun. Biar de dapa siksa banyak juga, di jaman yang datang nanti de hidup trus sampe trada akir. ");
INSERT INTO pmy_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Tapi banyak orang yang pertama nanti jadi yang trakir, trus yang trakir nanti jadi yang pertama.” ");
INSERT INTO pmy_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesus deng De pu murid-murid dong jalan ke Yerusalem trus Yesus jalan depan dorang. Yesus pu murid-murid dong heran tapi orang-orang yang ada ikut De, dong takut. Yesus panggil De pu duablas murid satu kali lagi baru kastau ke dong apa yang nanti jadi sama Dia. ");
INSERT INTO pmy_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","De bilang, “Skarang tong pigi ke Yerusalem, baru Sa Anak Manusia nanti dapa kasi ke imam-imam kepala deng guru-guru agama, trus nanti dong hukum mati Saya. Nanti dong kasi Sa ke orang-orang bukan Yahudi, ");
INSERT INTO pmy_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","baru nanti dong ejek, dong luda, dong cambuk deng bunu Saya, tapi hari ketiga Sa nanti hidup kembali.” ");
INSERT INTO pmy_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Trus Yakobus deng Yohanes, bapa Zebedeus pu anana, dong dua jalan dekat ke Yesus trus bilang ke Dia, “Guru, tong ingin Guru kasi apa yang tong mo minta ke Guru ini.” ");
INSERT INTO pmy_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesus tanya dong dua, “Apa yang kam dua mo Sa bikin buat kam dua?” ");
INSERT INTO pmy_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Dong dua bilang, “Tong dua mo Guru kas ijin tong dua duduk di samping Guru, yang satu di sebla kanan deng yang satu lagi di sebla kiri, waktu nanti Guru jadi Raja yang printa deng kuasa.” ");
INSERT INTO pmy_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Tapi Yesus bilang dong dua, “Kam tra tau apa yang kam minta. Kam sanggup minum dari glas sengsara yang Sa minum ato sanggup trima baptisan siksa macam Sa nanti ka?” ");
INSERT INTO pmy_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Dong dua jawab, “Tong sanggup.” Yesus bilang ke dong dua, “Memang nanti kam juga minum dari glas sengsara yang Sa minum deng trima baptisan siksa macam Saya. ");
INSERT INTO pmy_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Tapi kalo soal duduk di Sa pu sebla kanan ato kiri, Sa tra pu hak untuk kasi. Itu nanti Allah yang kasi ke orang-orang yang De su pili.” ");
INSERT INTO pmy_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Dengar begitu, spulu murid yang lain dong mara sama Yakobus deng Yohanes. ");
INSERT INTO pmy_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Trus Yesus panggil dong baru bilang, “Kam su tau kalo dong yang dapa anggap pemimpin-pemimpin dari bangsa-bangsa lain, biasa tindas orang-orang yang dong pimpin, sama orang-orang yang pegang kuasa bikin apa saja yang dong mau ke dorang. ");
INSERT INTO pmy_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Tapi kam tra bole begitu. Sapa saja yang mo jadi lebi hebat dari yang lain, de harus layani yang lain. ");
INSERT INTO pmy_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Trus sapa saja dari kam yang mo jadi yang pertama, de harus jadi pesuru untuk kam smua. ");
INSERT INTO pmy_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Karna Sa Anak Manusia juga datang bukan untuk orang layani Saya, tapi untuk layani orang trus untuk kasi Sa pu hidup ganti banyak orang untuk kas bebas dorang.” ");
INSERT INTO pmy_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Trus Yesus deng de pu murid-murid tiba di Kota Yerikho. Trus waktu Yesus pigi dari kota itu sama-sama De pu murid-murid deng orang banyak skali, ada orang buta satu yang biasa minta-minta, de pu nama Bartimeus, bapa Timeus pu anak. Bartimeus de duduk di pinggir jalan. ");
INSERT INTO pmy_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Waktu de dengar kalo yang ada lewat itu Yesus orang Nasaret, de mulai batariak bilang, “Yesus, Daud pu turunan, kasian sa ka!” ");
INSERT INTO pmy_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Banyak orang yang tegur supaya de diam. Tapi de batariak lebi kras lagi, “Daud pu turunan, kasian sa ka!” ");
INSERT INTO pmy_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesus brenti trus bilang, “Suru de datang kemari!” Jadi dong panggil orang buta itu trus bilang ke dia, “Kas kuat ko pu hati! Bediri, Yesus suru ko ke Dia.” ");
INSERT INTO pmy_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Langsung orang buta itu lepas de pu baju panjang luar, bediri cepat-cepat baru pigi ke Yesus. ");
INSERT INTO pmy_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesus tanya dia, “Ko mau Sa bikin apa untuk ko?” Orang buta itu jawab, “Guru, sa mau supaya sa bisa liat!” ");
INSERT INTO pmy_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Trus Yesus bilang ke dia, “Ko bisa pigi, karna ko percaya Saya, ko sembu!” Waktu itu juga de bisa liat, trus de ikut jalan sama-sama deng Yesus. ");
INSERT INTO pmy_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Waktu Yesus deng De pu murid-murid su dekat Kota Yerusalem, di kampung Betfage deng kampung Betania yang di dekat kaki Bukit Zaitun, Yesus suru de pu murid dua orang ");
INSERT INTO pmy_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","deng bilang, “Kam dua pigi ke kampung yang di depan sana! Pas sampe disana, nanti kam dua ketemu anak kledai satu yang dong ikat, yang blum perna ada orang yang naik duduk di atas kledai itu. Kam dua kas lepas tali trus bawa kledai itu kemari. ");
INSERT INTO pmy_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kalo ada orang yang tanya, ‘Knapa kam dua kas lepas anak kledai itu?’ jawab saja, ‘Tuhan De perlu ini. Nanti De langsung kas kembali lagi kesini.’ ” ");
INSERT INTO pmy_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Jadi, dong dua pigi trus ketemu anak kledai yang ada dapa ikat di pintu ruma yang di pinggir jalan, trus dong kas lepas. ");
INSERT INTO pmy_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Brapa orang yang ada bediri disitu tanya, “Kam dua bikin? Knapa kam dua kas lepas anak kledai itu?” ");
INSERT INTO pmy_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Jadi, dong dua bilang sperti yang Yesus su bilang, itu yang orang-orang tu kas biar dong ambil. ");
INSERT INTO pmy_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Dong bawa anak kledai itu ke Yesus, trus alas kledai tu pu blakang pake dong pu baju panjang, baru Yesus naik duduk di atas. ");
INSERT INTO pmy_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ada orang banyak yang alas jalan pake dong pu baju-baju panjang, ada juga yang alas jalan deng ranting-ranting yang pu daun hijou banyak, yang dong ambil dari kebun. ");
INSERT INTO pmy_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Orang-orang yang jalan di depan deng dong yang ikut dari blakang batariak bilang, “Hosana! Allah berkati De yang datang dalam nama Tuhan. ");
INSERT INTO pmy_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Allah berkati De yang mo datang printa jadi Raja, yang De pu kuasa sama deng Raja Daud tong pu moyang. Hosana di tempat tinggi!” ");
INSERT INTO pmy_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Waktu Yesus sampe di Yerusalem, De masuk ke Ruma Allah, trus jalan liat-liat smua yang ada disitu. Tapi karna su mo malam, jadi De pigi ke Betania sama-sama deng De pu duablas murid. ");
INSERT INTO pmy_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","De pu besok, habis Yesus deng de pu duablas murid pigi dari Betania, begini Yesus rasa lapar. ");
INSERT INTO pmy_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Dari jau De liat ada pohon ara yang su ada daun-daun. De jalan ke dekat pohon itu untuk liat kalo ada bua, tapi waktu sampe di pohon itu, De tra ketemu apapa hanya daun-daun saja, karna memang waktu itu bukan musim bua ara. ");
INSERT INTO pmy_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Begini De bilang ke pohon ara itu, “Mulai skarang trada satu orang yang makan ko pu bua lagi.” De pu murid-murid dong dengar apa yang De bilang. ");
INSERT INTO pmy_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Waktu Yesus deng De pu murid-murid sampe di Yerusalem, Yesus masuk ke Ruma Allah pu halaman, baru De mulai usir orang-orang yang ada jual bli disitu. De kas balik tukang tukar uang dong pu meja-meja deng tukang jual merpati dong pu bangku-bangku, ");
INSERT INTO pmy_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","deng De tra kas ijin orang-orang bawa apa saja lewat Ruma Allah pu halaman. ");
INSERT INTO pmy_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Trus Yesus kas ajar orang-orang disitu deng bilang, “Ada tatulis to kalo Allah bilang, ‘Sa pu ruma harus jadi ruma doa untuk smua bangsa.’ Tapi kam ni su bikin itu jadi pencuri pu tempat.” ");
INSERT INTO pmy_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Imam-imam kepala deng guru-guru agama dong dengar tentang smua yang Yesus su bikin itu, jadi dong cari jalan untuk bunu Dia, karna dong takut Dia. Dong takut karna smua orang heran skali deng De pu ajaran. ");
INSERT INTO pmy_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Pas su mo malam Yesus deng De pu murid-murid dong kluar dari kota. ");
INSERT INTO pmy_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","De pu besok pagi-pagi, waktu Yesus deng De pu murid-murid dong ada jalan ke Yerusalem, dong liat pohon ara yang kmarin itu de su kring smua sampe ke akar. ");
INSERT INTO pmy_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Trus Petrus langsung ingat, jadi de bilang, “Guru, coba liat! Pohon ara yang Guru kutuk itu su kring.” ");
INSERT INTO pmy_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesus jawab ke dorang, “Kam harus percaya Allah. ");
INSERT INTO pmy_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Yang Sa bilang ini benar: Sapa saja yang bilang sama gunung ini, ‘Trangkat baru talempar ke laut!’, de pasti bisa dapat yang de minta itu, yang penting de tra ragu-ragu tapi percaya kalo apa yang de bilang itu pasti jadi. ");
INSERT INTO pmy_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Jadi sa bilang kam, kalo kam berdoa minta apa saja ke Allah, kam pasti bisa dapat yang kam minta itu, yang penting kam percaya kalo kam su trima itu. ");
INSERT INTO pmy_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Tapi kalo kam berdoa, baru kam pu hati masi tra snang orang lain, kam harus kas ampun orang itu dulu, supaya kam pu Bapa di surga juga kas ampun kam pu sala. ");
INSERT INTO pmy_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Tapi kalo kam tra kas ampun orang itu nanti kam pu Bapa di surga juga tra kas ampun kam pu sala.” ");
INSERT INTO pmy_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Trus Yesus deng De pu murid-murid kembali ke Yerusalem lagi. Waktu Yesus jalan di halaman Ruma Allah, begini imam-imam kepala deng guru-guru agama sama orang Yahudi pu tua-tua, dong datang ke Dia. ");
INSERT INTO pmy_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Trus dong tanya, “Deng kuasa apa Ko bikin ini smua? Sapa yang kasi Ko kuasa untuk bikin ini smua?” ");
INSERT INTO pmy_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesus jawab dorang, “Sa mo tanya kam, kalo kam jawab Saya, nanti Sa juga kastau kam deng kuasa apa Sa bikin hal-hal itu. ");
INSERT INTO pmy_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Coba jawab! Yohanes de kas baptis orang deng sapa pu kuasa, Allah ato manusia?” ");
INSERT INTO pmy_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Dengar begitu, dong sendiri bahas itu baru bilang, “Kalo tong bilang, ‘Deng Allah pu kuasa,’ De nanti bilang, ‘Kalo begitu knapa kam tra percaya dia?’ ");
INSERT INTO pmy_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Tapi tong juga tra bisa bilang, ‘Dari manusia.’ ” Dong takut sama orang banyak karna smua orang anggap Yohanes tu betul-betul nabi. ");
INSERT INTO pmy_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Jadi dong jawab Yesus, “Tong tra tau.” Trus Yesus bilang sama dorang, “Kalo begitu, Sa juga tra kastau sama kam, deng kuasa apa Sa bikin ini smua.” ");
INSERT INTO pmy_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Trus Yesus mulai crita conto ke dorang, begini, “Ada satu orang yang bikin kebun anggur deng bikin pagar kliling kebun itu. De gali lobang untuk tempat ramas anggur sama de bangun tempat jaga yang tinggi di dalam kebun itu. Habis itu de kas sewa kebun itu sama orang-orang yang kerja kebun itu, trus de brangkat ke tempat yang jau. ");
INSERT INTO pmy_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Waktu su mo panen, orang yang pu kebun tu suru de pu pesuru pigi ke orang-orang yang sewa kebun tu untuk ambil sbagian hasil panen itu dari dorang. ");
INSERT INTO pmy_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Tapi dong tangkap pesuru itu baru dong pukul de trus suru de pigi deng tangan kosong. ");
INSERT INTO pmy_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Trus orang yang pu kebun itu suru de pu pesuru yang lain lagi pigi ke dorang. Tapi dong pukul de di kepala sampe luka deng dong bikin malu dia. ");
INSERT INTO pmy_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Trus de suru de pu pesuru satu lagi, tapi dong bunu dia. De suru de pu pesuru banyak pigi ke dong tapi sama saja, ada yang dong pukul deng ada yang dong bunu. ");
INSERT INTO pmy_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Skarang tinggal satu orang saja yang ada deng dia, itu de pu anak yang paling de sayang. Jadi, yang trakir de suru de pu anak itu pigi ke dorang, karna de pikir, ‘De ini sa pu anak jadi pasti dong hormati dia.’ ");
INSERT INTO pmy_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Tapi dong baku kastau begini, ‘De ini yang nanti pu hak di tana ini, mari tong bunu de supaya tana ini tong bisa ambil.’ ");
INSERT INTO pmy_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Jadi dong tangkap baru bunu anak itu, trus dong lempar de kluar kebun itu.” ");
INSERT INTO pmy_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Trus Yesus tanya ke dorang, “Kam pikir orang yang pu kebun anggur itu nanti de bikin apa? De pasti pigi bunu orang-orang yang sewa kebun anggur itu, trus kasi kebun itu sama orang-orang lain. ");
INSERT INTO pmy_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Kam blum perna baca ayat ini ka, ‘Batu yang tukang-tukang bangunan dong buang, skarang jadi batu fondasi yang paling penting. ");
INSERT INTO pmy_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Itu smua Tuhan yang bikin, itu hal luar biasa yang bikin tong heran skali.’” ");
INSERT INTO pmy_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Trus dong cari cara untuk tangkap Yesus, karna dong tau kalo conto itu pu maksud Yesus bicara kas sala dorang. Tapi dong takut sama orang banyak, jadi dong pigi kas tinggal Dia. ");
INSERT INTO pmy_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Trus orang Yahudi pu pemimpin-pemimpin dong suru orang Farisi brapa deng orang-orang yang dukung Herodes brapa untuk pigi jebak Yesus deng cara tanya-tanya Dia. ");
INSERT INTO pmy_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Dong datang trus bilang ke Dia, “Bapa guru, tong tau Bapa ni orang yang jujur, baru Bapa tra takut sapa-sapa, karna Bapa tra kas beda-beda orang, tapi kas ajar Allah pu mau deng benar. Jadi coba Bapa kastau sama kitong, mnurut tong pu aturan agama, tong bisa bayar pajak sama Raja Besar Roma ka tra bisa? Tong harus bayar ka tidak?” ");
INSERT INTO pmy_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Tapi Yesus tau kalo dong cuma pura-pura baik, jadi De bilang sama dorang, “Knapa kam coba Saya? Bawa uang logam perak satu sama Saya, supaya Sa liat!” ");
INSERT INTO pmy_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Trus dong bawa uang logam perak satu untuk Dia baru De tanya dorang, “Ini sapa pu gambar deng nama?” Dong jawab, “Raja Besar Roma pu gambar deng nama.” ");
INSERT INTO pmy_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Trus Yesus bilang sama dorang, “Kalo begitu, kasi sama Raja Besar Roma apa yang jadi Raja Besar Roma pu hak, trus kasi sama Allah apa yang jadi Allah pu hak.” Dong smua heran skali pas dengar apa yang De bilang. ");
INSERT INTO pmy_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Habis itu orang-orang dari klompok Saduki datang ke Yesus. Dong itu tra percaya kalo orang-orang mati nanti hidup kembali. Jadi, dong tanya sama Yesus, ");
INSERT INTO pmy_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Bapa Guru! Musa de su tulis printa ini untuk kitong, ‘Kalo satu laki-laki de mati kas tinggal de pu istri baru dong dua tra pu anak, de pu sodara laki-laki musti kawin deng de pu istri supaya ada turunan untuk laki-laki yang su mati itu.’ ");
INSERT INTO pmy_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ada crita satu begini, tuju orang sodara dong smua laki-laki. Yang sodara pertama kawin, trus mati tra pu anak. ");
INSERT INTO pmy_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Trus yang kedua juga kawin deng janda itu, tapi de juga mati baru tra pu anak, yang ketiga juga sama saja. ");
INSERT INTO pmy_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Dong smua begitu sampe yang ketuju, dong smua mati tapi trada anak. Habis dong smua mati, prempuan itu juga mati. ");
INSERT INTO pmy_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Jadi waktu orang mati hidup kembali, sapa yang jadi prempuan itu pu suami? Karna tuju orang itu su kawin deng dia.” ");
INSERT INTO pmy_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesus bilang ke dorang, “Kam su sala skali, karna kam tra mngerti Kitab Suci deng juga Allah pu kuasa. ");
INSERT INTO pmy_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Karna kalo orang mati dong hidup kembali, dong tra kawin deng tra dapa kawin tapi dong sperti malaikat di surga. ");
INSERT INTO pmy_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Trus tentang orang mati nanti hidup kembali, kam blum perna baca dalam kitab Musa ka, yang crita tentang pohon duri lebat itu? Waktu itu Allah bicara ke Musa begini, ‘Sa ini Abraham, Ishak, deng Yakub dong pu Allah.’ ");
INSERT INTO pmy_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Jadi De bukan Allah dari orang mati, tapi Allah dari orang yang hidup. Kam su sala mngerti!” ");
INSERT INTO pmy_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Waktu itu ada guru agama satu yang dengar Yesus baku tawar deng orang-orang klompok Saduki. De liat apa yang Yesus jawab ke dong itu pas skali, jadi de datang ke Yesus trus tanya, “Printa mana yang paling penting?” ");
INSERT INTO pmy_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesus jawab, “Printa yang paling penting itu: ‘Orang Israel dengar ini, Tuhan itu tong pu Allah, Tuhan itu cuma satu. ");
INSERT INTO pmy_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Sayang ko pu Tuhan Allah deng spenu hati, deng smua ko pu hidup, deng smua yang ko pikir, deng juga smua tenaga.’ ");
INSERT INTO pmy_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Trus printa yang kedua itu: ‘Sayang orang lain sama sperti ko sayang ko pu diri sendiri.’ Trada printa yang lebi penting dari printa dua ini.” ");
INSERT INTO pmy_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Trus begini guru agama itu bilang ke Yesus, “Apa yang Guru bilang tu benar skali, ‘Tuhan Allah itu cuma satu, trada Allah yang lain lagi, cuma De saja.’ ");
INSERT INTO pmy_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Memang harus ‘sayang Allah deng spenu hati, deng smua yang ko pikir, deng smua tenaga,’ deng juga ‘sayang orang lain sama sperti ko sayang ko pu diri sendiri.’ Bikin printa dua ini lebi penting daripada smua korban binatang yang bakar deng persembahan yang lain juga.” ");
INSERT INTO pmy_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesus liat kalo guru agama tu de jawab baik skali, jadi Yesus bilang ke Dia, “Sdikit lagi ko jadi Allah pu orang dalam De pu Krajaan.” Habis itu, trada satu orang yang brani tanya-tanya lagi sama Yesus. ");
INSERT INTO pmy_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Waktu Yesus ada ajar di Ruma Allah, De bilang, “Knapa guru-guru agama bisa bilang kalo Raja Yang Allah Pili itu Daud pu turunan? ");
INSERT INTO pmy_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Padahal Daud sendiri waktu Roh Allah kuasai dia, de bilang, ‘Tuhan Allah su bilang sama sa pu Tuhan: Duduk di Sa pu sebla kanan, sampe Ko pu musu-musu Sa taru di bawa Ko pu kaki.’ ");
INSERT INTO pmy_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Daud sendiri sebut De itu ʻTuhan,ʼ jadi De bukan hanya Daud pu turunan saja.” Orang yang banyak-banyak itu dong snang dengar yang De bilang. ");
INSERT INTO pmy_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Waktu Yesus kas ajar orang banyak itu, De bilang, “Kam harus hati-hati deng guru-guru agama. Dong snang jalan pake baju-baju panjang trus dong mau skali dapat hormat di pasar, ");
INSERT INTO pmy_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","dong juga suka duduk paling depan di tempat ibada deng di pesta-pesta. ");
INSERT INTO pmy_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Tapi dong biasa tipu janda-janda untuk ambil paksa dong pu ruma. Trus untuk tutup dong pu klakuan jahat itu, dong doa yang panjang-panjang. Dong ini pasti trima hukuman yang lebi brat.” ");
INSERT INTO pmy_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Satu kali begini, Yesus duduk baku depan deng kotak persembahan trus pratikan orang-orang dong kasi uang ke dalam kotak itu bagemana. Orang kaya banyak yang kas masuk uang besar. ");
INSERT INTO pmy_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Trus ada janda satu yang miskin datang baru kas masuk uang logam dua yang de pu nilai paling kecil. ");
INSERT INTO pmy_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesus panggil De pu murid-murid trus bilang ke dorang, “Yang Sa bilang ini benar: Janda miskin ini de kasi lebi banyak dari smua orang yang kas masuk uang ke dalam kotak persembahan. ");
INSERT INTO pmy_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Karna dong smua kasi dong pu persembahan dari dong pu uang yang banyak, tapi janda ini de su kasi smua yang de punya, smua yang de perlu untuk pake hidup.” ");
INSERT INTO pmy_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Waktu Yesus kluar dari Ruma Allah, De pu murid satu bilang ke Dia, “Guru, coba liat gedung-gedung deng batu-batu itu bagus skali!” ");
INSERT INTO pmy_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Trus Yesus bilang ke dia, “Ko liat gedung-gedung bagus ini? Nanti trada satu batu disini yang dapa kas biar tinggal di atas batu yang lain, smua gedung ini nanti dapa kas hancur.” ");
INSERT INTO pmy_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Trus Yesus pigi duduk di Bukit Zaitun yang baku depan deng Ruma Allah. Begini Petrus, Yakobus, Yohanes deng Andreas dong datang untuk bicara sendiri deng Yesus, dong tanya, ");
INSERT INTO pmy_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Kastau sama kitong, kapan itu mo jadi, trus apa de pu tanda kalo itu de pu waktu?” ");
INSERT INTO pmy_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Trus Yesus bilang ke dorang, “Hati-hati supaya jang ada orang yang tipu kam! ");
INSERT INTO pmy_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Nanti orang banyak yang datang pake Sa pu nama baru bilang, ‘Sa ini yang Allah utus,’ trus dong tipu orang banyak. ");
INSERT INTO pmy_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Trus kalo kam dengar suara-suara prang ato brita-brita tentang prang, kam jang gelisa. Smua itu harus jadi, tapi itu blum akir jaman. ");
INSERT INTO pmy_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Karna bangsa satu mo prang deng bangsa lain, juga negara satu deng negara lain. Nanti ada gempa bumi di mana-mana deng nanti ada klaparan. Smua tu baru tanda-tanda awal saja untuk akir jaman, sama sperti prempuan yang de mulai rasa sakit waktu mo lahir anak. ");
INSERT INTO pmy_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Kam harus hati-hati! Karna kam nanti dapa kasi ke tangan sidang-sidang agama, trus kam nanti dapa pukul di tempat-tempat ibada. Trus karna kam jadi Sa pu pengikut nanti kam dapa bawa ke depan pemimpin-pemimpin deng raja-raja, supaya kam bisa kastau tentang Sa ke dorang. ");
INSERT INTO pmy_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Trus Brita Baik dari Allah harus tasebar ke smua bangsa dulu. ");
INSERT INTO pmy_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Waktu kam dapa tangkap trus dapa bawa untuk dong adili kam, kam jang takut deng apa yang nanti harus kam bicara, kam bilang saja apa yang Roh Allah kastau untuk kam pas waktu itu, karna itu bukan kam yang bicara, tapi itu dari Roh Allah. ");
INSERT INTO pmy_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Nanti ada orang yang kasi de pu sodara sendiri untuk dapa bunu, begitu juga deng bapa sama de pu anak. Anana nanti mlawan dong pu orang tua, trus kasi dong pu orang tua untuk dapa bunu. ");
INSERT INTO pmy_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Trus nanti smua orang tra suka kam skali karna kam ikut Saya. Tapi orang yang tahan sampe trakir pasti slamat.” ");
INSERT INTO pmy_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Nanti kam liat satu barang yang paling jahat yang bikin hancur, bediri di tempat yang de tra bole ada disitu ‒ yang baca harus pratikan ini baik-baik. Waktu itu orang-orang yang ada di Yudea harus lari ke gunung-gunung. ");
INSERT INTO pmy_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Orang yang ada di atas ruma, jang turun deng masuk untuk ambil apa saja di dalam de pu ruma, ");
INSERT INTO pmy_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","trus orang yang ada di kebun jang kembali untuk ambil de pu pakean. ");
INSERT INTO pmy_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kasian skali prempuan-prempuan yang ada hamil ato yang masi kas susu bayi pas waktu itu. ");
INSERT INTO pmy_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Berdoa supaya smua tu jang jadi di musim dingin. ");
INSERT INTO pmy_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Karna di waktu itu nanti orang dapa siksa sperti yang blum perna jadi, dari waktu Allah bikin dunia ini sampe skarang, deng nanti siksa sperti itu trakan perna jadi lagi. ");
INSERT INTO pmy_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kalo Tuhan tra kas kurang waktu itu, nanti trada satu orang juga yang slamat, tapi karna ada orang-orang yang De su pili jadi De kas kurang waktu itu. ");
INSERT INTO pmy_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Pas waktu itu kalo ada orang yang bilang ke kam, ‘Liat, Raja Yang Allah Pili ada disini,’ ato, ‘Liat, Raja Yang Allah Pili ada disana,’ kam jang percaya. ");
INSERT INTO pmy_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Karna nanti dong yang pura-pura jadi Raja Yang Allah Pili sama dong yang pura-pura jadi nabi-nabi, dong datang baru bikin tanda-tanda heran deng hal-hal yang luar biasa, supaya kalo bisa, dong kas sesat orang-orang yang Allah pili. ");
INSERT INTO pmy_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Jadi, kam harus hati-hati! Sa su kastau smua ini duluan ke kam.” ");
INSERT INTO pmy_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Yesus bilang lagi, “Tapi pas waktu sengsara itu habis, ‘matahari jadi glap deng bulan pu sinar trada lagi. ");
INSERT INTO pmy_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Trus bintang-bintang jatu-jatu dari langit sama kuasa-kuasa di langit jadi kaco.’ ");
INSERT INTO pmy_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Pas waktu itu orang liat Sa ‘Anak Manusia datang di awan-awan’ deng kuasa yang besar deng sinar yang trang. ");
INSERT INTO pmy_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Trus waktu itu, Sa Anak Manusia nanti suru malaikat-malaikat kluar baru nanti dong kumpul orang-orang yang Sa pili dari smua tempat di bumi, dari ujung bumi sampe ke ujung langit. ");
INSERT INTO pmy_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Coba blajar dari conto pohon ara: Kalo di de pu cabang-cabang mulai lembek baru kas kluar tunas, kam tau kalo su mo musim panas. ");
INSERT INTO pmy_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Begitu juga kalo kam liat hal-hal itu jadi, kam tau kalo de pu waktu su dekat, su ada di depan pintu. ");
INSERT INTO pmy_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Yang Sa bilang ini benar: Seblum smua orang yang hidup skarang ini mati, smua itu jadi dulu. ");
INSERT INTO pmy_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Langit deng bumi nanti hilang, tapi Sa pu kata-kata trakan hilang. ");
INSERT INTO pmy_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Tapi tentang hari itu ato de pu waktu trada satu orang juga yang tau, malaikat-malaikat di surga juga tra tau, Sa Allah pu Anak sendiri juga tra tau, cuma Bapa saja yang tau.” ");
INSERT INTO pmy_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","“Jadi kam harus jaga-jaga deng slalu siap karna kam tra tau de pu waktu kapan datang. ");
INSERT INTO pmy_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Itu de pu conto sama sperti satu orang yang kas tinggal de pu ruma baru pigi ke tempat yang jau. Seblum de pigi, de kasi tugas ke de pu pesuru smua untuk urus de pu ruma, de bagi tugas ke dong masing-masing. De suru orang yang jaga pintu supaya slalu siap. ");
INSERT INTO pmy_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Jadi, kam harus jaga-jaga, karna kam tra tau kapan tuan ruma tu de pulang, bisa sore-sore, bisa tenga-tenga malam, bisa subu-subu, bisa juga pagi-pagi, ");
INSERT INTO pmy_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","supaya kalo de datang tiba-tiba jang de ketemu kam ada tidur. ");
INSERT INTO pmy_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Apa yang Sa bilang ke kam ni, Sa bilang juga ke smua orang: Kam harus jaga-jaga!” ");
INSERT INTO pmy_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Dua hari lagi orang Yahudi dong pu hari besar Paska deng hari besar Roti Tra Pake Ragi mulai. Imam-imam kepala deng guru-guru agama dong cari jalan untuk tangkap trus bunu Yesus diam-diam deng cara tipu. ");
INSERT INTO pmy_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Dong bilang, “Tra bole pas di hari besar supaya orang-orang dong jang kaco.” ");
INSERT INTO pmy_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Waktu Yesus ada di Betania, di Simon yang dulu sakit kulit busuk pu ruma, Yesus ada duduk makan. Begini prempuan satu datang bawa botol dari batu puti yang de pu isi minyak wangi asli yang de pu nama narwastu. Minyak ini de pu harga mahal. Prempuan itu de buka botol deng cara kas pata tutup botol trus kas pake minyak itu ke atas Yesus pu kepala. ");
INSERT INTO pmy_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ada brapa orang yang tra snang trus bilang ke yang lain, “Untuk apa de buang-buang minyak narwastu sperti itu? ");
INSERT INTO pmy_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Karna minyak itu kalo jual de pu harga lebi dari 300 uang perak, trus uang itu bisa kasi ke orang-orang miskin.” Trus dong mara prempuan itu. ");
INSERT INTO pmy_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Tapi Yesus bilang, “Kas biar dia. Knapa kam bikin susa dia? De su bikin yang baik ke Saya. ");
INSERT INTO pmy_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Karna orang-orang miskin tu ada trus deng kam, jadi kam bisa tolong dong kapan saja kalo kam mau. Tapi Sa trakan ada sama-sama trus deng kam. ");
INSERT INTO pmy_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","De su bikin apa yang de bisa bikin. Sa pu badan ni de su kas pake minyak untuk kas siap Sa nanti dapa kubur. ");
INSERT INTO pmy_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Yang Sa bilang ini benar: Dimana saja Brita Baik orang kastau di sluru dunia, dong juga nanti ingat apa yang de bikin ini.” ");
INSERT INTO pmy_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Trus Yudas Iskariot de pigi, de tu satu orang dari Yesus pu duablas murid. De pigi ke imam-imam kepala supaya de bisa jual Yesus ke dorang. ");
INSERT INTO pmy_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Dong smua snang skali waktu dengar apa yang de bilang, baru dong janji untuk kasi uang sama dia. Habis itu de mulai cari waktu yang pas untuk jual Yesus. ");
INSERT INTO pmy_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pas hari pertama dari hari besar Roti Tra Pake Ragi, waktu orang potong domba Paska, Yesus pu murid-murid tanya ke Dia, “Bapa mau tong kemana untuk kas siap makanan Paska untuk Bapa?” ");
INSERT INTO pmy_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Langsung Yesus suru De pu murid dua orang, “Kam dua pigi ke kota, nanti kam dua ketemu laki-laki satu yang pikul air dalam tempayan. Kam ikut dia, ");
INSERT INTO pmy_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","nanti de masuk ke ruma satu, trus kam bilang ke orang yang pu ruma itu, ‘Guru De tanya: Tempat mana yang Sa deng Sa pu murid-murid mo makan Paska?’ ");
INSERT INTO pmy_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Trus orang itu nanti kas tunjuk kam ruang besar satu di tingkat atas, yang su lengkap karna smua su ada. Nanti disitu kam dua kas siap makan Paska untuk kitong.” ");
INSERT INTO pmy_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Trus Yesus pu murid dua orang itu pigi ke kota, begini smua jadi sperti yang Yesus su bilang ke dorang. Trus dong kas siap makanan Paska. ");
INSERT INTO pmy_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Waktu hari su malam, Yesus datang sama-sama deng De pu duablas murid itu. ");
INSERT INTO pmy_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Waktu dong ada duduk makan, Yesus bilang, “Yang Sa bilang ini benar: Ada satu orang dari kam yang nanti jual Saya. De ada makan sama-sama deng Saya.” ");
INSERT INTO pmy_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Begini dong smua sedi, trus satu-satu orang bilang ke Dia, “Tuhan, bukan sa to?” ");
INSERT INTO pmy_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","De jawab, “Orang itu, de tu satu orang dari kam Sa pu duablas murid ini, de yang ada colo roti sama-sama deng sa dalam satu mangkok ini. ");
INSERT INTO pmy_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Sa Anak Manusia memang nanti mati, sama sperti yang ada tatulis tentang Saya, tapi claka untuk orang yang jual Sa Anak Manusia. Lebi baik untuk orang itu kalo de tra perna lahir.” ");
INSERT INTO pmy_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Waktu Yesus deng De pu murid-murid ada makan, Yesus ambil roti, doa syukur ke Allah, trus pata-pata roti baru kasi ke dong deng bilang, “Ambil, ini Sa pu badan.” ");
INSERT INTO pmy_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Habis itu De ambil glas anggur, doa syukur ke Allah trus kasi ke dorang, baru dong smua minum dari glas anggur itu. ");
INSERT INTO pmy_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Trus De bilang ke dorang, “Ini Sa pu dara yang bikin sah Allah pu janji, yang tatumpa untuk banyak orang. ");
INSERT INTO pmy_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Yang Sa bilang ini benar: Sa trakan minum hasil anggur lagi sampe hari yang Sa minum hasil anggur yang baru, di Allah pu Krajaan.” ");
INSERT INTO pmy_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Habis Yesus deng De pu murid-murid mnyanyi puji-puji Allah, dong pigi ke Bukit Zaitun. ");
INSERT INTO pmy_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Trus Yesus bilang ke dorang, “Nanti kam smua kas tinggal Saya. Sperti ada tatulis, ‘Sa Allah, nanti pukul kas mati gembala, trus domba-domba itu lari tapisa-pisa.’ ");
INSERT INTO pmy_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Tapi stela Sa hidup kembali, Sa nanti duluan kam ke Galilea.” ");
INSERT INTO pmy_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Trus Petrus jawab Dia, “Biar dong smua kas tinggal Bapa tapi sa trakan kas tinggal Bapa.” ");
INSERT INTO pmy_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Trus Yesus bilang ke dia, “Yang Sa bilang ini benar: Hari ini, malam ini juga seblum ayam berkokok dua kali, ko su bilang tra knal Sa tiga kali.” ");
INSERT INTO pmy_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Tapi Petrus bilang lagi sunggu-sunggu, “Biar sa harus mati sama-sama deng Bapa juga, sa trakan bilang sa tra knal Bapa.” Yang lain smua juga bilang begitu. ");
INSERT INTO pmy_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Trus Yesus deng De pu murid-murid pigi ke tempat satu yang de pu nama Getsemani. Yesus bilang ke De pu murid-murid, “Kam duduk disini, Sa mo berdoa dulu.” ");
INSERT INTO pmy_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Trus De bawa Petrus, Yakobus deng Yohanes ikut sama-sama deng Dia. De rasa susa deng gelisa. ");
INSERT INTO pmy_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Trus De bilang ke dorang, “Sa pu hati hancur skali, rasa macam mo mati. Kam tinggal disini trus jaga-jaga.” ");
INSERT INTO pmy_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","De maju sdikit trus tunduk sampe muka ke tana baru berdoa supaya kalo bisa, De tra usa kena susa itu. ");
INSERT INTO pmy_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","De bilang, “Bapa, Sa pu Bapa. Trada yang tra bisa untuk Bapa. Jang kas biar Sa kena sengsara ini ka, tapi jang Sa pu mau yang jadi, biar Bapa pu mau saja yang jadi.” ");
INSERT INTO pmy_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Habis itu De kembali, begini De liat dong ada tidur. Trus De bilang ke Petrus, “Simon, ko tidur ka? Ko tra bisa jaga-jaga satu jam saja ka? ");
INSERT INTO pmy_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Jaga-jaga deng berdoa suda, supaya kam jang jatu waktu dapa uji. Memang kam pu hati mo bikin yang benar, tapi kam pu badan tra kuat mo bikin itu.” ");
INSERT INTO pmy_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Trus De pigi lagi baru berdoa ulang sperti yang pertama. ");
INSERT INTO pmy_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Trus waktu De kembali lagi, De liat dong ada tidur karna dong pu mata su brat skali, baru dong tra tau mo bilang apa ke Dia. ");
INSERT INTO pmy_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Habis itu De kembali yang ketiga kali baru bilang ke dorang, “Kam masi istirahat deng tidur ka? Cukup suda. De pu waktu su tiba. Liat, Sa Anak Manusia dapa jual ke orang-orang yang bikin dosa pu tangan. ");
INSERT INTO pmy_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Bangun suda, mari! Tong pigi. De yang jual Sa su datang.” ");
INSERT INTO pmy_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Waktu Yesus masi bicara, Yudas de muncul, de tu satu orang dari duablas murid dorang. Ada satu rombongan orang yang sama-sama deng dia, dong bawa pedang deng tongkat kayu, dong dapa suru dari imam-imam kepala, guru-guru agama, deng orang Yahudi pu tua-tua. ");
INSERT INTO pmy_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Orang yang jual Yesus su kastau tanda ini ke dorang, “Orang yang nanti Sa cium, itu De suda, tangkap De trus kam bawa deng jaga De baik-baik.” ");
INSERT INTO pmy_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Trus waktu de sampe disitu, de langsung ke Yesus baru bilang, “Guru!” trus de cium Yesus. ");
INSERT INTO pmy_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Jadi dong pegang Yesus trus tangkap Dia. ");
INSERT INTO pmy_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Tapi satu orang dari dong yang ada disitu, cabut de pu pedang trus srang kas putus Pemimpin Imam pu pesuru pu tlinga. ");
INSERT INTO pmy_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesus bilang ke dorang, “Kam kira Sa ni prampok ka, jadi kam datang lengkap deng pedang sama tongkat kayu untuk tangkap Saya? ");
INSERT INTO pmy_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Stiap hari Sa ada deng kam dalam Ruma Allah untuk kas ajar orang banyak tapi kam tra tangkap Saya. Tapi memang smua ini harus jadi begini supaya apa yang ada tatulis dalam Kitab Suci itu jadi.” ");
INSERT INTO pmy_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Trus De pu murid-murid smua lari kas tinggal Dia. ");
INSERT INTO pmy_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Pas waktu itu ada anak muda satu yang cuma pake kain lenan untuk pake tutup de pu badan, trus ikut Yesus. Dong tangkap dia, ");
INSERT INTO pmy_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","begini de lepas de pu kain itu trus lari tlanjang-tlanjang. ");
INSERT INTO pmy_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Habis itu Yesus dapa bawa ke depan Pemimpin Imam, trus imam kepala smua, orang Yahudi pu tua-tua deng guru-guru agama, smua kumpul disitu. ");
INSERT INTO pmy_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Trus Petrus su ikut Yesus dari jau sampe masuk ke Pemimpin Imam pu halaman, trus de duduk disana deng orang-orang yang jaga Ruma Allah, baru kas hangat badan dekat api. ");
INSERT INTO pmy_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Imam-imam kepala deng anggota Sidang Agama smua brusaha cari bukti untuk kas sala Yesus supaya De dapa hukum mati, tapi dong tra dapat bukti apapa. ");
INSERT INTO pmy_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ada orang banyak juga yang kas saksi tipu-tipu untuk tudu Dia, tapi apa yang dong kas saksi tu smua beda-beda. ");
INSERT INTO pmy_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Baru brapa orang bediri karang crita, dong bilang, ");
INSERT INTO pmy_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Tong perna dengar Orang ini De bilang, ‘Sa nanti kas hancur Ruma Allah ini yang manusia bikin deng dong pu tangan. Trus dalam tiga hari nanti Sa bikin Ruma Allah yang lain, yang bukan manusia bikin deng dong pu tangan.’ ” ");
INSERT INTO pmy_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Tapi apa yang dong kas saksi itu juga beda-beda. ");
INSERT INTO pmy_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Begini Pemimpin Imam bediri di depan orang-orang smua trus de tanya ke Yesus, “Ko tra mo jawab yang dong tudu-tudu ke Ko ini ka?” ");
INSERT INTO pmy_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Tapi De diam deng tra bicara apapa. Pemimpin Imam itu, tanya De satu kali lagi, de bilang, “Ko tu Raja Yang Allah Pili ka, Ko tu De yang tong puji-puji pu Anak?” ");
INSERT INTO pmy_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesus jawab, “Sa ini suda Dia, trus nanti kam liat Sa Anak Manusia, duduk di sebla kanan Yang Pu Kuasa Paling Besar, trus datang di awan-awan di langit.” ");
INSERT INTO pmy_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Begini Pemimpin Imam robek de pu pakean deng bilang, “Buat apa tong cari saksi lagi? ");
INSERT INTO pmy_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Kam su dengar De hina Allah! Kam pikir bagemana?” Trus dong smua satu suara baru bilang kalo Yesus sala deng pantas dapa hukum mati. ");
INSERT INTO pmy_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Trus brapa orang mulai luda Yesus deng tutup De pu muka baru pukul Dia, trus bilang, “Wei, nabi, Ko coba tebak, sapa yang pukul Ko?” Trus orang-orang yang jaga Ruma Allah dong juga pukul Dia. ");
INSERT INTO pmy_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Waktu Petrus masi ada di halaman, begini Pemimpin Imam pu pesuru prempuan satu datang, ");
INSERT INTO pmy_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","trus waktu de liat Petrus ada kas hangat badan dekat api, de pratikan baik-baik trus bilang, “Ko juga biasa sama-sama deng Yesus orang Nasaret itu to?” ");
INSERT INTO pmy_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Tapi Petrus pura-pura tra knal deng bilang, “Sa tra tau deng tra mngerti ko pu maksud tu apa.” Trus de pigi ke pintu gerbang trus ayam berkokok. ");
INSERT INTO pmy_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Waktu pesuru prempuan itu liat Petrus lagi, de bilang lagi ke orang-orang yang ada disitu, “Orang ini satu dari dorang.” ");
INSERT INTO pmy_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Tapi Petrus bilang lagi, de tra knal Dia. Tra lama begini orang-orang yang ada disitu dong juga bilang ke Petrus, “Pasti ko juga satu orang dari dorang, karna ko orang Galilea!” ");
INSERT INTO pmy_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Begini Petrus bilang, “Sa sumpa! Sa tra knal orang yang kam ada bilang-bilang ini! Kalo sa tipu pasti Tuhan hukum saya!” ");
INSERT INTO pmy_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Pas waktu itu ayam berkokok yang kedua kali. Jadi langsung Petrus ingat, kalo Yesus perna bilang ke dia, “Seblum ayam berkokok dua kali, ko su tiga kali bilang tra knal Saya.” Jadi Petrus mulai mnangis hancur. ");
INSERT INTO pmy_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Pagi-pagi skali Sidang Agama dong smua, termasuk imam-imam kepala, orang Yahudi pu tua-tua deng guru-guru agama, dong su spakat. Trus dong ikat Yesus baru bawa kasi De ke Pilatus. ");
INSERT INTO pmy_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatus de tanya Yesus, “Betul ka, Ko ni orang Yahudi pu Raja?” Yesus jawab, “Ko sendiri yang bilang.” ");
INSERT INTO pmy_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Trus imam-imam kepala dong tudu-tudu banyak ke Yesus. ");
INSERT INTO pmy_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Jadi, Pilatus tanya lagi ke Dia, bilang, “Ko tra mo jawab? Ko dengar, dong tudu-tudu Ko banyak skali!” ");
INSERT INTO pmy_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Tapi Yesus tra jawab sama skali, jadi Pilatus de heran. ");
INSERT INTO pmy_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Stiap kali hari besar Paska, Pilatus biasa kas bebas tahanan satu yang orang banyak minta. ");
INSERT INTO pmy_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Pas waktu itu, ada satu orang de pu nama Barabas, de ada dapa kas penjara sama-sama deng orang lain, dong smua ni bunu orang waktu dong brontak lawan pemrinta Roma. ");
INSERT INTO pmy_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Trus begini, orang banyak datang baru minta ke Pilatus supaya de kas bebas satu orang sperti yang biasa de bikin. ");
INSERT INTO pmy_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilatus jawab dong deng tanya, “Kam mau sa kas bebas orang Yahudi pu Raja ini untuk kam ka?” ");
INSERT INTO pmy_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Karna de memang tau, kalo imam-imam kepala kasi Yesus ke de karna dong tra snang liat De lebi dari dorang. ");
INSERT INTO pmy_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Tapi imam-imam kepala dong tusuk-tusuk mulut ke orang banyak supaya dong minta ke Pilatus untuk kas bebas Barabas buat dorang. ");
INSERT INTO pmy_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Jadi, Pilatus tanya satu kali lagi ke dorang, “Kalo begitu, sa harus bikin apa ke Dia, yang kam bilang-bilang orang Yahudi pu Raja ini?” ");
INSERT INTO pmy_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Begini dong batariak bilang, “Kas salib Dia!” ");
INSERT INTO pmy_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Trus Pilatus bilang ke dorang, “Tapi De bikin jahat apa ka?” Begini dong batariak tamba kras lagi, “Kas salib Dia!” ");
INSERT INTO pmy_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Trus karna Pilatus mau bikin snang dong smua pu hati, jadi de kas bebas Barabas untuk dorang. Trus de suru orang cambuk Yesus, baru kasi De untuk dong kas salib. ");
INSERT INTO pmy_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Habis itu tentara-tentara dong bawa Yesus ke dalam halaman istana di gubernur pu tempat tinggal, trus panggil pasukan smua untuk kumpul. ");
INSERT INTO pmy_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Dong kas pake De baju panjang ungu, trus anyam ranting-ranting duri bikin macam makota, baru taru di De pu kepala. ");
INSERT INTO pmy_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Habis itu dong hormat De trus bilang, “Hormat, orang Yahudi pu Raja!” ");
INSERT INTO pmy_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Dong pukul De pu kepala deng tongkat trus dong luda Dia, baru tunduk tikam lutut bikin macam dong semba Dia. ");
INSERT INTO pmy_vpl VALUES ("MK15_20a","071_15_20a","MRK","15","20a","20a","Habis dong hina-hina Dia, dong kas lepas baju panjang ungu itu dari De trus kas pake De pu pakean itu lagi ke Dia. ");
INSERT INTO pmy_vpl VALUES ("MK15_20b","071_15_20b","MRK","15","20b","20b","Trus dong bawa Yesus kluar untuk dapa kas salib. ");
INSERT INTO pmy_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Waktu dong jalan, ada satu orang yang lewat, de baru datang dari luar kota. De pu nama Simon, de orang Kirene. De itu Aleksander deng Rufus pu bapa. Dong paksa de pikul Yesus pu kayu salib. ");
INSERT INTO pmy_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Dong bawa Yesus ke tempat yang de pu nama Golgota yang de pu arti Tempat Tengkorak. ");
INSERT INTO pmy_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Trus dong kasi De anggur yang dong campur deng obat mur, tapi De tra mau minum. ");
INSERT INTO pmy_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Habis itu dong kas salib Dia, baru dong bagi De pu pakean deng cara buang undi, untuk liat sapa yang nanti dapat bagian yang mana. ");
INSERT INTO pmy_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Hari itu, Yesus dapa kas salib jam sembilan pagi. ");
INSERT INTO pmy_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Trus alasan knapa De dapa hukum itu tatulis, “Orang Yahudi pu Raja.” ");
INSERT INTO pmy_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Dong kas salib De sama-sama deng prampok dua orang. Satu di sebla kanan deng satu di sebla kiri.  ");
INSERT INTO pmy_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Supaya kata-kata yang ada tatulis dalam Kitab Suci itu jadi, “Dong nanti anggap De macam orang jahat.” ");
INSERT INTO pmy_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Orang-orang yang lewat disana geleng-geleng kepala untuk hina Dia. Baru dong bilang, “We, Ko yang bilang mo kas rubu Ruma Allah trus mo bangun kembali dalam tiga hari to? ");
INSERT INTO pmy_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ko turun suda dari Ko pu salib itu, trus kas slamat Ko pu diri!” ");
INSERT INTO pmy_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Begitu juga imam-imam kepala deng guru-guru agama hina-hina Dia, dong yang lain bilang ke yang lain, “Orang lain De kas slamat, tapi De pu diri sendiri De tra bisa kas slamat! ");
INSERT INTO pmy_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kalo memang De ini Raja Yang Allah Pili, yang Israel pu Raja itu, coba De turun dari salib itu! Supaya tong bisa liat baru percaya!” Dua orang yang dapa salib sama-sama deng De juga hina Dia. ");
INSERT INTO pmy_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Waktu jam 12 siang, smua daera itu jadi glap sampe jam tiga sore. ");
INSERT INTO pmy_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Trus waktu jam tiga sore, Yesus batariak deng suara kras, “Eloi, Eloi, lama sabakhtani?” Yang de pu arti itu, ʻSa pu Allah, Sa pu Allah, knapa Ko kas tinggal Saya?ʼ ");
INSERT INTO pmy_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Dengar begitu, brapa orang yang bediri disitu bilang, “Liat, De panggil Elia.” ");
INSERT INTO pmy_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Begini ada satu orang cepat-cepat pigi ambil spons, baru colo ke dalam anggur asam, trus ikat di tongkat, baru de kas minum Yesus deng bilang, “Iyo, tong tunggu saja trus tong liat, nanti Elia datang kas turun De ka trada.” ");
INSERT INTO pmy_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Trus Yesus batariak deng suara kras baru lepas napas trakir. ");
INSERT INTO pmy_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Waktu itu hordein tebal di Ruma Allah tarobek jadi dua dari atas sampe ke bawa. ");
INSERT INTO pmy_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Waktu perwira yang bediri baku depan deng Dia liat De lepas napas trakir sperti itu, de bilang, “Betul, De ni suda Allah pu Anak!” ");
INSERT INTO pmy_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ada prempuan brapa yang liat dari jau juga, dari dong itu ada Maria dari Magdala, trus Maria yang Yakobus muda deng Yoses pu mama, sama Salome. ");
INSERT INTO pmy_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Dong smua juga su ikut Yesus deng bantu urus apa yang Yesus perlu waktu De di Galilea. Disitu ada banyak prempuan lain juga, yang su ikut sama-sama deng Yesus ke Yerusalem. ");
INSERT INTO pmy_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Waktu itu su mo malam, trus hari itu, hari untuk orang Yahudi kas siap smua-smua untuk masuk dong pu hari Sabat. ");
INSERT INTO pmy_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Itu yang, satu orang yang pu nama Yusuf de bikin brani trus pigi ketemu Pilatus untuk minta Yesus pu mayat. Yusuf ini de orang Arimatea. De itu anggota Sidang Agama yang paling dapa hormat dari orang-orang, de juga orang yang tunggu-tunggu Allah pu Krajaan. ");
INSERT INTO pmy_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Waktu itu Pilatus heran pas dengar kalo Yesus su mati. Jadi de panggil perwira untuk tanya dia, “Yesus su mati ka?” ");
INSERT INTO pmy_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Habis de dengar yang perwira itu de bilang, langsung de stuju untuk kasi Yesus pu mayat ke Yusuf. ");
INSERT INTO pmy_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Trus Yusuf bli kain lenan halus, trus kas turun Yesus pu mayat dari salib baru bungkus pake kain itu. Habis itu de taru Yesus pu mayat di kubur yang dong bikin dalam bukit batu. Trus de dorong batu besar satu untuk tutup kubur pu pintu. ");
INSERT INTO pmy_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Waktu itu Maria dari Magdala deng Maria yang Yoses pu mama liat baik-baik, Yesus pu mayat dapa taru dimana. ");
INSERT INTO pmy_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Habis orang Yahudi dong pu hari Sabat, Maria dari Magdala deng Maria yang Yakobus pu mama, sama Salome bli minyak wangi karna mo pigi gosok minyak itu di Yesus pu mayat. ");
INSERT INTO pmy_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Trus pas hari Minggu pagi-pagi skali, habis matahari baru naik, dong pigi ke kubur. ");
INSERT INTO pmy_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Di tenga jalan dong baku tanya, “Sapa yang nanti kas guling batu itu dari kubur pu pintu untuk kitong?” ");
INSERT INTO pmy_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Tapi pas sampe, dong liat begini batu besar itu su taguling pinda tempat. ");
INSERT INTO pmy_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Trus dong masuk ke dalam kubur begini dong liat laki-laki muda satu pake baju panjang puti duduk di sebla kanan. Jadi dong takut skali. ");
INSERT INTO pmy_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Tapi laki-laki muda itu de bilang ke dorang, “Jang takut! Kam cari Yesus orang Nasaret yang dapa salib itu to? De su hidup kembali, De su trada disini. Liat! Ini tempat yang dong taru de pu mayat itu. ");
INSERT INTO pmy_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Skarang juga kam pigi, kastau ke De pu murid-murid deng ke Petrus juga kalo De duluan kam ke Galilea. Nanti kam liat De disana, sperti yang De su bilang ke kam.” ");
INSERT INTO pmy_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Trus dong lari kluar kas tinggal kubur itu deng gementar karna dong heran skali. Dong tra crita apapa ke sapa saja karna dong takut.  Dong cepat-cepat kastau pesan itu smua ke Petrus deng de pu teman-teman. Habis itu Yesus sendiri yang utus De pu murid-murid untuk kastau ke orang-orang dari timur sampe ke barat, pesan tentang bagemana orang bisa dapat slamat sampe trada akir. Pesan ini pesan yang suci deng trakan perna bisa hilang, nanti ada trus. 16:9-18  ");
INSERT INTO pmy_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Habis Yesus hidup kembali, pas hari pertama dari minggu itu, De kas tunjuk diri pertama kali ke Maria dari Magdala. Maria ni yang perna Yesus kas kluar tuju setan dari dia. ");
INSERT INTO pmy_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Jadi Maria pigi kastau ke dong yang biasa sama-sama deng Yesus, dong itu yang ada masi sedi deng mnangis. ");
INSERT INTO pmy_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Tapi waktu dong dengar kalo Yesus su hidup kembali, trus Maria su liat Dia, dong tra percaya. ");
INSERT INTO pmy_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Habis itu Yesus kas tunjuk diri lagi ke dua orang dari dong tapi Yesus kliatan beda, waktu dong dua ada pigi kluar kota. ");
INSERT INTO pmy_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Trus dong dua kembali baru kastau ke yang lain, tapi dong masi tra percaya. ");
INSERT INTO pmy_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Jadi trakir tu, De kas tunjuk diri ke De pu seblas murid waktu dong ada duduk makan, trus De tegur kras dong pu tra percaya itu deng dong pu kras kepala, karna tra mo percaya orang-orang yang su liat deng mata kepala kalo Yesus su hidup kembali. ");
INSERT INTO pmy_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Trus De bilang dorang, “Kam pigi ke smua tempat di dunia ni, trus kastau Brita Baik ke smua orang. ");
INSERT INTO pmy_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Sapa yang percaya trus dapa baptis nanti dapa kas slamat, tapi sapa yang tra percaya nanti dapa hukum. ");
INSERT INTO pmy_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Orang-orang percaya tu, nanti dong bikin tanda-tanda heran. Dong nanti usir setan-setan pake Sa pu nama, dong nanti bicara bahasa-bahasa yang baru yang dong tra tau. ");
INSERT INTO pmy_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Kalo dong pegang ular ato minum racun, dong trakan kena claka, kalo dong kas taru tangan ke orang yang sakit, orang itu nanti de sembu.” ");
INSERT INTO pmy_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Habis Tuhan Yesus bicara ke dong begitu, De trangkat naik ke surga, trus duduk di Allah pu sebla kanan. ");
INSERT INTO pmy_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Jadi dong pigi kastau Brita Baik ke smua tempat, trus Tuhan tolong dong lewat tanda-tanda heran untuk kas tunjuk kalo smua yang dong pigi kastau itu benar.");
INSERT INTO pmy_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Bapa Teofilus yang sa hormat. Banyak orang su usaha tulis pristiwa-pristiwa yang su jadi di tenga kitong. ");
INSERT INTO pmy_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Dong tulis apa yang dong dengar dari orang-orang yang liat sendiri waktu smua jadi trus pigi kastau brita itu ke mana-mana. ");
INSERT INTO pmy_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Juga sa cek smua itu dari awal, jadi sa rasa perlu sa tulis ikut deng smua yang jadi waktu itu untuk bapa. ");
INSERT INTO pmy_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Deng begitu, bapa bisa tau deng pasti kalo smua yang orang su kas ajar ke bapa itu betul. ");
INSERT INTO pmy_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Waktu Herodes jadi raja di Yudea, disitu ada satu imam de pu nama Sakaria. De ni dari klompok Abia, de pu istri pu nama Elisabet. Dong dua ni Harun pu turunan. ");
INSERT INTO pmy_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Dong dua orang yang benar di depan Allah, slalu ikut Tuhan deng tra perna lupa bikin Tuhan pu printa. ");
INSERT INTO pmy_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Dong dua su tua trus trada anak karna Elisabet de mandul. ");
INSERT INTO pmy_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Satu hari waktu klompok Abia pu giliran, Sakaria de tugas jadi imam di Ruma Allah. ");
INSERT INTO pmy_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Biasa imam-imam dong buang undi untuk kasi tugas. Jadi Sakaria yang dapa pili untuk bakar kemenyan dalam Allah pu Tempat Suci. ");
INSERT INTO pmy_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Waktu de bakar kemenyan itu, smua orang dong kumpul di luar Tempat Suci itu trus dong berdoa. ");
INSERT INTO pmy_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Waktu itu Tuhan pu malaikat kas tunjuk diri sama Sakaria, de bediri di sebla kanan dekat meja tempat bakar kemenyan. ");
INSERT INTO pmy_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Liat begitu Sakaria de kaget deng takut. ");
INSERT INTO pmy_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Tapi malaikat itu bicara sama dia, “Sakaria ko jang takut, karna Tuhan su dengar ko pu doa. Ko pu istri Elisabet de nanti lahir anak laki-laki. Ko kasi nama de Yohanes. ");
INSERT INTO pmy_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Waktu anak itu lahir, ko nanti snang skali trus orang lain juga dong snang sama anak itu. ");
INSERT INTO pmy_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Karna nanti de jadi orang yang penting depan Tuhan. Trus de tra bole minum anggur ato minum minuman kras. Nanti Roh Allah kuasai de mulai dari dalam de pu mama pu perut. ");
INSERT INTO pmy_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","De nanti bawa banyak orang Israel balik kembali sama Tuhan, dong pu Allah. ");
INSERT INTO pmy_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Trus de yang duluan buka jalan untuk Tuhan. De pu kuasa yang kuat sama sperti Elia dulu. De kas damei bapa-bapa deng dong pu anana kembali. Trus, orang yang su jalan sala de bikin dong kembali pikir yang benar. Deng begitu de kas siap orang-orang yang mo hidup ikut Tuhan.” ");
INSERT INTO pmy_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Habis tu Sakaria bilang sama malaikat begini, “Bagemana sa mo tau kalo yang sa dapa kastau itu nanti jadi? Karna sa ni su tua baru sa pu istri juga su tua.” ");
INSERT INTO pmy_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Malaikat de jawab dia, “Sa ni Gabriel yang bediri dekat Allah, sa dapa printa untuk kastau tentang brita baik ini sama ko. ");
INSERT INTO pmy_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Dengar ini! Apa yang sa bilang pasti jadi pas de pu waktu nanti, tapi karna ko tra percaya apa yang sa bilang, ko tra bisa bicara sampe smua yang sa bilang ini jadi.” ");
INSERT INTO pmy_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Di luar Tempat Suci itu orang-orang dong su tunggu-tunggu Sakaria. Dong heran karna de su lama di dalam Tempat Suci itu. ");
INSERT INTO pmy_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Begini waktu Sakaria de kluar, de su tra bisa bicara sama dorang, de cuma pake kode-kode saja. Jadi orang-orang dong tau kalo Tuhan ada kas tunjuk satu hal sama Sakaria dalam Tempat Suci itu. ");
INSERT INTO pmy_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Begitu de pu tugas kerja di Ruma Allah slesai, Sakaria de pulang ke de pu ruma. ");
INSERT INTO pmy_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Tra lama de pu istri Elisabet hamil, trus Elisabet ni de tinggal dalam ruma saja sampe lima bulan. ");
INSERT INTO pmy_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","De bilang, “Tuhan yang tolong sampe sa bisa hamil, Tuhan su bikin sa tra malu lagi depan orang-orang.” ");
INSERT INTO pmy_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Begini Elisabet su hamil enam bulan, Allah suru malaikat Gabriel pigi ke kampung Nasaret di daera Galilea. ");
INSERT INTO pmy_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","De ke prempuan satu yang pu nama Maria, de masi nona deng blum kawin. Maria de ni su calon istri dari laki-laki satu pu nama Yusup, dari raja Daud pu turunan. ");
INSERT INTO pmy_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Malaikat de datang bilang Maria begini, “Salam Maria, Tuhan su kasi ko berkat besar. Tuhan ada sama-sama deng ko!” ");
INSERT INTO pmy_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Dengar begitu Maria takut deng bingung, trus de tanya dalam hati, “De pu maksud apa eee?” ");
INSERT INTO pmy_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Trus malaikat itu bilang, “Maria jang takut, Allah su kas tunjuk De pu baik sama ko. ");
INSERT INTO pmy_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Dengar ini! Ko nanti hamil trus lahir anak laki-laki satu, ko harus kasi nama anak itu Yesus. ");
INSERT INTO pmy_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Anak ini nanti De jadi orang penting, trus nanti dong sebut De Allah Yang Paling Tinggi pu Anak. Juga nanti Tuhan Allah kasi De kursi raja dari De pu nene moyang Raja Daud. ");
INSERT INTO pmy_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Trus De ni nanti jadi raja yang printa Yakub pu anana cucu trus-trus, De pu krajaan trada akir.” ");
INSERT INTO pmy_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Tapi Maria de bilang malaikat itu, “Bagemana smua ni bisa jadi? Karna sa blum perna tidur deng laki-laki.” ");
INSERT INTO pmy_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Malaikat itu bilang, “Roh Allah nanti turun sama ko, trus Allah Yang Paling Tinggi pu kuasa tutup ko, karna begitu Anak yang nanti ko lahir itu dong sebut De Allah pu Anak, De nanti hidup kusus untuk Allah. ");
INSERT INTO pmy_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Dengar ini! Ko pu sodara Elisabet de su hamil enam bulan, padahal de su tua trus orang bilang de tra bisa pu anak. ");
INSERT INTO pmy_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Karna bagi Allah trada yang tra bisa.” ");
INSERT INTO pmy_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Trus Maria de bilang, “Sa ni cuma Tuhan pu pesuru, biar smua jadi sperti yang ko bilang itu.” Trus, malaikat itu de pigi kas tinggal Maria. ");
INSERT INTO pmy_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Habis tu lewat brapa hari Maria pigi cepat-cepat ke kota satu yang ada di gunung di daera Yudea. ");
INSERT INTO pmy_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","De pigi ke Sakaria pu ruma, pas sampe di sana, Maria kasi suara ke Elisabet. ");
INSERT INTO pmy_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Begitu Elisabet dengar Maria pu suara, anak dalam de pu perut grak kuat-kuat. Trus Roh Allah kuasai Elisabet, ");
INSERT INTO pmy_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","trus Elisabet batariak deng snang, “Heee, ko ni yang paling dapa berkat dari smua prempuan, begitu juga deng Anak yang dalam ko pu perut ini. ");
INSERT INTO pmy_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Sa ni sapa ka sampe sa pu Tuhan pu mama de datang liat sa? ");
INSERT INTO pmy_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Dengar ini! Waktu sa dengar ko pu suara, anak dalam sa pu perut ni grak kuat-kuat karna snang skali. ");
INSERT INTO pmy_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ko untung skali, karna ko yang percaya kalo apa yang Tuhan kastau sama ko itu pasti jadi.” ");
INSERT INTO pmy_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria bilang, “Sa pu hati puji deng hormat sama Tuhan! ");
INSERT INTO pmy_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Sa pu hati snang skali, karna Allah kas slamat saya. ");
INSERT INTO pmy_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","De ingat saya, De pu pesuru yang trada arti ini! Mulai skarang smua orang di dunia bilang sa ni prempuan yang paling untung. ");
INSERT INTO pmy_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Karna Allah Yang Pu Kuasa Paling Besar su bikin hal besar sama saya, Allah tu suci deng trada sala apapa. ");
INSERT INTO pmy_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Tuhan slalu kas tunjuk De pu sayang trus-trus ke orang yang dong pu hidup takut Tuhan. ");
INSERT INTO pmy_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Tuhan kas tunjuk De pu kuasa besar, De juga kas kaco orang yang tinggi hati. ");
INSERT INTO pmy_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Tuhan kas turun orang-orang besar dari dong pu kursi raja, baru De kasi kuasa sama orang-orang yang di bawa. ");
INSERT INTO pmy_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","De kasi smua hal yang baik sama orang-orang lapar sampe dong puas, trus orang-orang kaya De suru pigi deng tra dapat apapa. ");
INSERT INTO pmy_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Tuhan su tolong Israel, De pu pesuru, karna Tuhan ingat De pu sayang, sperti De su janji sama tong pu nene moyang. Tuhan janji kalo De nanti bikin smua yang baik sama Abraham deng de pu anana cucu sampe trada akir.” ");
INSERT INTO pmy_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Kira-kira sampe tiga bulan Maria tinggal sama Elisabet, habis itu de pulang kembali. ");
INSERT INTO pmy_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Pas su waktu untuk Elisabet mo lahir anak, de lahir anak laki-laki. ");
INSERT INTO pmy_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Waktu orang-orang di tempat itu deng de pu sodara dong dengar kalo Tuhan su kas tunjuk De pu sayang sama dia, dong smua ikut snang sama-sama deng dia. ");
INSERT INTO pmy_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Waktu anak kecil su dlapan hari, dong smua datang liat anak itu dapa sunat ikut dong pu aturan agama. De pu sodara dong mo kas nama de Sakaria sperti de bapa, ");
INSERT INTO pmy_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","tapi anak itu pu mama bilang, “Tra usa! Kas nama de Yohanes saja.” ");
INSERT INTO pmy_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Trus dong bilang de, “Tapi trada ko pu sodara yang nama begitu baru?” ");
INSERT INTO pmy_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Trus dong kode sama Sakaria, dong tanya de pu anak mo kasi nama apa. ");
INSERT INTO pmy_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sakaria de minta tempat tulis untuk de tulis, “De pu nama tu Yohanes.” Baru dong smua langsung heran. ");
INSERT INTO pmy_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Waktu itu juga Sakaria langsung bisa bicara lagi trus de mulai puji Allah. ");
INSERT INTO pmy_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Smua orang yang tinggal samping-samping ruma dong jadi takut, trus pristiwa itu orang crita dari mulut ke mulut di smua tempat di daera gunung Yudea. ");
INSERT INTO pmy_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Smua orang yang dengar dong bilang dalam hati, “Anak ini kalo besar nanti de jadi apa eee?” Karna dong liat Tuhan pu kuasa ada sama-sama deng anak ini. ");
INSERT INTO pmy_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Begini Roh Allah kuasai anak itu pu bapa Sakaria, trus de bapa bawa Allah pu pesan, de bilang begini, ");
INSERT INTO pmy_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Puji Tuhan, Allah yang kitong orang Israel percaya! De su datang mo tolong kas bebas De pu orang-orang. ");
INSERT INTO pmy_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Tuhan kasi satu Orang yang De pu kuasa besar, datang kas slamat kitong. Orang itu turunan dari Tuhan pu pesuru, Raja Daud. ");
INSERT INTO pmy_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","De buat sperti De janji dulu skali dari mulut nabi-nabi yang De pili itu, ");
INSERT INTO pmy_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","untuk kas slamat kitong dari musu-musu pu kuasa deng smua yang tra suka skali sama kitong. ");
INSERT INTO pmy_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Allah bikin begitu untuk kas tunjuk De pu hati yang sayang sama tong pu nene moyang, karna De ingat De pu janji yang suci yang pasti jadi. ");
INSERT INTO pmy_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Itu janji yang De su bilang deng sumpa sama tong pu moyang Abraham: ");
INSERT INTO pmy_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Supaya tong bebas dari musu-musu, trus bisa ikut layani Tuhan deng trada rasa takut. ");
INSERT INTO pmy_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Slama tong hidup musti hidup untuk Tuhan trus mo bikin yang baik di depan Dia. ");
INSERT INTO pmy_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Baru ko Yohanes sa pu anak ni, nanti orang panggil ko tu Allah Yang Paling Tinggi pu nabi. Ko yang nanti jalan duluan supaya ko kas siap Tuhan pu jalan. ");
INSERT INTO pmy_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ko juga mo kastau Tuhan pu orang yang De pili kalo De mo kas slamat dorang, deng cara kas ampun dong dari dong pu dosa-dosa. ");
INSERT INTO pmy_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Karna Allah sayang sama kitong sampe De mo kas slamat kitong. Itu sama sperti sinar matahari pagi yang muncul. ");
INSERT INTO pmy_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","De datang mo kas trang smua orang yang hidup dalam glap deng yang takut mati. Trus untuk kas tunjuk tong pu langka kaki ke jalan hidup yang penu rasa damai.” ");
INSERT INTO pmy_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Anak ini de tamba besar trus de pu roh tamba kuat. Trus de tinggal di tempat sepi yang kring, sampe hari de musti kas tunjuk diri sama orang Israel. ");
INSERT INTO pmy_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Satu kali begini, Raja Besar Roma yang orang panggil Raja Agustus de kas printa untuk daftar smua orang yang ada di krajaan Roma. ");
INSERT INTO pmy_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Daftar sensus nama-nama ni pertama kali dong bikin waktu Kirenius de jadi gubernur Siria. ");
INSERT INTO pmy_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Smua orang dong pigi daftar dong pu nama-nama ke dong pu kota asal. ");
INSERT INTO pmy_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yusup de pigi dari kampung Nasaret di Galilea ke Kota Betlehem di Yudea. Betlehem ni dong biasa bilang juga Kota Daud, de pigi daftar nama disitu karna de asal dari kluarga deng turunan Raja Daud. ");
INSERT INTO pmy_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","De pigi daftar disana deng Maria de pu calon istri yang ada hamil. ");
INSERT INTO pmy_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Waktu dong di Betlehem, su waktu untuk Maria mo lahir anak. ");
INSERT INTO pmy_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Karna dong tra dapat tempat untuk tinggal, jadi dong tinggal dalam kandang binatang. Maria de lahir anak laki-laki, anak yang pertama. De bungkus deng kain, trus kas tidur di tempat taru makanan untuk binatang. ");
INSERT INTO pmy_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Pas malam itu tra jau dari kampung Betlehem di tempat luas yang ada rumput-rumput, orang-orang jaga dong pu domba. ");
INSERT INTO pmy_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kaget begini, dekat dong muncul Tuhan pu malaikat satu, baru Tuhan pu sinar kas trang dong, baru orang-orang yang jaga domba dong takut skali. ");
INSERT INTO pmy_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Trus malaikat bilang dong begini, “Kam jang takut, karna sa mo kastau brita baik ke kam. Brita baik ini nanti bikin smua orang pu hati snang skali. ");
INSERT INTO pmy_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Hari ini su lahir di Daud pu kampung Betlehem, Anak satu yang nanti kas slamat kam. De tu Tuhan, Raja Yang Allah Pili. ");
INSERT INTO pmy_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Begini De pu tanda: Kam nanti pigi trus liat bayi satu dong bungkus pake kain, baru De tidur dalam binatang pu tempat makan.” ");
INSERT INTO pmy_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kaget begini, muncul sama-sama deng malaikat itu malaikat-malaikat banyak skali dari surga yang puji Allah, dong bilang, ");
INSERT INTO pmy_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Puji Allah di tempat yang paling tinggi, juga damai di bumi untuk orang-orang yang Tuhan pili.” ");
INSERT INTO pmy_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Habis malaikat-malaikat pigi kembali ke surga kas tinggal dong, orang-orang yang jaga domba tu dong baku bilang, “Ayo tong skarang pigi ke Betlehem liat apa yang su jadi, sperti yang Tuhan su kastau sama torang.” ");
INSERT INTO pmy_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Dong cepat-cepat pigi begini dong ketemu Maria deng Yusup, baru dong liat bayi De tidur dalam binatang pu tempat makan. ");
INSERT INTO pmy_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Waktu orang-orang yang jaga domba su liat Dia, dong kastau apa yang malaikat tu su bilang sama dong tentang bayi itu. ");
INSERT INTO pmy_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Trus smua orang yang dengar crita itu heran. ");
INSERT INTO pmy_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Tapi Maria ni de pikir trus simpan smua tu dalam de pu hati. ");
INSERT INTO pmy_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Orang-orang yang jaga domba dong kembali ke tempat luas yang ada rumput, deng puji-puji kas tinggi Allah, karna dong su dengar deng su liat smua jadi sperti yang malaikat kastau. ");
INSERT INTO pmy_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Begitu su dlapan hari, Anak itu dapa sunat. Dong kasi nama De Yesus, nama yang malaikat kasi, waktu De blum ada dalam perut. ");
INSERT INTO pmy_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Pas hari untuk Maria mo kas bersi diri ikut hukum Musa, Yusup deng Maria dong pigi bawa Yesus ke Yerusalem untuk kasi sama Tuhan. ");
INSERT INTO pmy_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Karna dalam hukum Tuhan tatulis begini, “Smua anak laki-laki yang lahir pertama itu kas kusus untuk Tuhan.” ");
INSERT INTO pmy_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Dong juga mo kas korban persembahan dua ekor anak burung merpati puti ato dua ekor burung merpati hitam, sperti ada tulis di hukum Tuhan. ");
INSERT INTO pmy_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Pas skali di Yerusalem tu ada orang satu, de pu nama Simeon. De orang benar, de sunggu-sunggu ikut Tuhan pu mau, de juga ada tunggu Tuhan pu janji yang mo kas slamat orang Israel, trus Roh Allah slalu ada sama dia. ");
INSERT INTO pmy_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Roh Allah kastau de kalo seblum de mati de pasti liat Raja Yang Tuhan Pili. ");
INSERT INTO pmy_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Hari itu Roh Allah kas grak Simeon pu hati, untuk pigi ke Ruma Allah pas Yusup sama Maria juga ada bawa Yesus yang masi bayi, untuk bikin yang harus dong ikut dari hukum Musa. ");
INSERT INTO pmy_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Baru Simeon de gendong Anak itu trus de puji Allah de bilang, ");
INSERT INTO pmy_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Sunggu eh! Tuhan pu janji buat saya, skarang su jadi. Tuhan biar skarang sa mati deng hatitenang, karna sa pu hati su snang. ");
INSERT INTO pmy_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Karna deng sa pu mata sendiri sa liat, De yang mo kas slamat, yang datang dari Bapa. ");
INSERT INTO pmy_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Tuhan sendiri yang su kas siap Dia depan smua bangsa. ");
INSERT INTO pmy_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","De sperti trang yang kas tunjuk jalan untuk bangsa-bangsa lain, trang itu yang bawa hormat bagi Tuhan pu umat Israel.” ");
INSERT INTO pmy_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Dengar Simeon bicara tentang Anak itu, De pu bapa deng mama dong heran. ");
INSERT INTO pmy_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Trus Simeon kasi berkat sama dong baru de bilang sama Anak itu pu mama Maria begini, “Dengar, Allah su pili Anak ini. Nanti lewat Anak ini banyak orang Israel dapa hukum juga banyak orang Israel yang dapa slamat. De ni sperti tanda dari Allah, tapi banyak orang yang tantang Dia. ");
INSERT INTO pmy_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ini jadi supaya jlas apa yang ada dalam banyak orang pu pikiran. Juga ko rasa sedi skali dalam ko pu hati sperti tusuk deng parang yang tajam.” ");
INSERT INTO pmy_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Pas disitu ada satu prempuan yang tua, de pu nama Hana, de ni nabi. De dari suku Asyer, Fanuel pu anak. De su perna kawin trus de hidup deng de pu suami sampe tuju taun. ");
INSERT INTO pmy_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Skarang de su janda. De su umur 84 taun. De slalu ada di Ruma Allah, siang malam de sembayang sama Allah deng puasa. ");
INSERT INTO pmy_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Pas waktu itu de datang ke dekat Anak itu, baru de puji Allah deng bicara tentang Anak itu sama smua orang yang ada tunggu-tunggu Allah pu waktu kas bebas orang Yerusalem. ");
INSERT INTO pmy_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Habis Yusup sama Maria bikin smua ikut hukum Tuhan, dong pulang ke dong pu kampung Nasaret di Galilea. ");
INSERT INTO pmy_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Anak itu tamba besar deng kuat. De mngerti smua deng baik, trus Allah kas tunjuk De pu baik sama Anak itu. ");
INSERT INTO pmy_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Stiap taun Yesus pu orang tua dong pigi ke Yerusalem, untuk dong ikut orang Yahudi pu hari besar Paska. ");
INSERT INTO pmy_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Waktu Yesus pu umur 12 taun, dong pigi ke Yerusalem sperti yang biasa dong buat di hari besar itu. ");
INSERT INTO pmy_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Habis ikut hari besar itu, waktu dong jalan pulang, Yesus De masi di Yerusalem tapi De pu bapa deng mama tra tau. ");
INSERT INTO pmy_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Karna dong dua pikir De ada sama-sama deng orang-orang yang ada jalan. Sampe su jalan satu hari penu baru, dong dua cari De di tenga dong pu kluarga deng orang-orang yang dong knal. ");
INSERT INTO pmy_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Karna dong tra dapat-dapat, dong kembali ke Yerusalem deng trus cari Dia. ");
INSERT INTO pmy_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Su cari sampe tiga hari baru dong dapat De dalam Ruma Allah. Yesus De duduk tenga guru-guru agama dengar deng tanya-tanya sama dong. ");
INSERT INTO pmy_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Smua orang yang dengar, dong heran skali sama Dia, karna De tau smua trus De jawab smua deng baik. ");
INSERT INTO pmy_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","De pu orang tua saja heran liat itu. Trus De pu mama bilang sama Dia, “Anak, knapa Ko bikin tong begini? Sa deng Ko pu bapa tong dua pu hati tra bisa tenang cari-cari Ko.” ");
INSERT INTO pmy_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yesus De bilang, “Knapa bapa deng mama mo cari Saya? Bapa deng mama tratau kalo Sa musti ada di Sa pu Bapa pu ruma?” ");
INSERT INTO pmy_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Tapi dong tra mngerti apa yang Yesus bilang. ");
INSERT INTO pmy_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Trus Yesus ikut dong pulang sama-sama ke Nasaret, De paling dengar-dengar sama De pu orang tua. De pu mama simpan smua hal itu dalam hati. ");
INSERT INTO pmy_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Trus Yesus tamba besar deng tamba mngerti smua deng baik, Allah deng manusia tamba snang deng Dia. ");
INSERT INTO pmy_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Waktu su 15 taun Tiberius jadi Raja Besar Roma, Pontius Pilatus de gubernur daera Yudea, Herodes raja wilaya Galilea. Trus Herodes pu sodara Filipus, de raja wilaya Iturea deng Trakonitis, trus Lisanias raja wilaya Abilene. ");
INSERT INTO pmy_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Waktu itu juga, Hanas sama Kayafas yang jadi Pemimpin Imam. Trus Allah bicara sama Yohanes, Sakaria pu anak yang waktu itu de tinggal di tempat sepi yang kring. ");
INSERT INTO pmy_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Trus Yohanes de pigi ke smua daera Yordan deng kastau kalo dong harus tobat, trus dapa baptis supaya dapa kas ampun dari dong pu dosa-dosa. ");
INSERT INTO pmy_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Sperti yang tatulis dalam kitab Nabi Yesaya, “Ada suara yang batariak di tempat sepi yang kring, ‘Kas siap jalan untuk Tuhan, kas lurus jalan untuk Dia. ");
INSERT INTO pmy_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Timbun tempat-tempat yang renda, kas rata gunung-gunung deng tempat yang tinggi, kas lurus jalan yang belok-belok, trus kas rata jalan yang batu-batu. ");
INSERT INTO pmy_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Smua orang nanti liat bagemana Allah kas slamat orang-orang!’ ” ");
INSERT INTO pmy_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Banyak orang yang datang untuk Yohanes baptis dong. Yohanes kastau sama dong begini, “Kam ini ular bisa pu turunan! Sapa yang kas ingat kam untuk lari dari Allah pu mara besar yang nanti datang? ");
INSERT INTO pmy_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kalo memang kam su tobat dari dosa, kas hasil bua yang pantas untuk orang yang su tobat dari dosa. Jang kam pikir dalam hati, ‘Tong slamat karna bapa Abraham tu tong pu nene moyang!’ Dengar eh, Allah bisa bikin anana buat bapa Abraham dari batu-batu ini! ");
INSERT INTO pmy_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Kapak su siap mo tebang pohon sampe ke akar-akar, jadi pohon yang tra kas hasil bua yang baik, pasti dapa tebang trus buang ke api.” ");
INSERT INTO pmy_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Orang-orang dong tanya Yohanes, “Kalo begitu, apa yang musti tong buat?” ");
INSERT INTO pmy_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yohanes de bilang, “Sapa yang punya dua baju, de musti kasi satu sama yang tra pu baju, juga orang yang pu makanan, de musti bagi sama orang yang trada makanan.” ");
INSERT INTO pmy_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Orang-orang tukang tagi pajak dong juga datang mo baptis trus dong tanya sama dia, “Bapa guru, apa yang musti tong buat?” ");
INSERT INTO pmy_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yohanes kastau, “Jang tagi lebi banyak dari yang musti ko tagi.” ");
INSERT INTO pmy_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Pasukan tentara juga tanya sama dia, “Kalo tong, apa yang musti tong buat?” Yohanes de jawab sama dong, “Jang kam kuras deng pras orang, kas cukup kam pu hidup deng kam pu gaji.” ");
INSERT INTO pmy_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Waktu itu orang-orang dong tanya-tanya, kalo Yohanes ni ka Raja Yang Allah Pili yang dong tunggu-tunggu. ");
INSERT INTO pmy_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Jadi Yohanes jawab deng bilang smua orang dong begini, “Orang yang pu kuasa lebi besar dari saya, De nanti datang, mo buka De pu tali spatu saja sa tra pantas. Sa baptis kam deng air, tapi De nanti baptis kam deng Roh Allah juga deng api. ");
INSERT INTO pmy_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","De su mo kas pisa orang yang baik deng yang jahat, macam orang yang su pegang tapis untuk kas pisa biji gandum dari ampas. Biji gandum De kumpul ke De pu tempat, tapi smua ampas De nanti bakar di api yang tra bisa padam.” ");
INSERT INTO pmy_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yohanes de trus pake kata-kata sperti itu kas naseat orang, deng kastau Brita Baik. ");
INSERT INTO pmy_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Juga, Yohanes tegur Herodes yang pu kuasa di Galilea karna masala Herodias, de pu sodara pu istri, juga tentang smua hal jahat yang de su buat. ");
INSERT INTO pmy_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Tapi Herodes tamba bikin jahat lagi, de suru orang kas masuk Yohanes ke penjara. ");
INSERT INTO pmy_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Waktu smua orang banyak itu su dapa baptis, Yesus juga dapa baptis. Baru De ada doa begini, tiba-tiba langit tabuka, ");
INSERT INTO pmy_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","trus Roh Allah De turun ke Yesus bentuk sperti burung merpati di atas Dia. Trus ada suara dari langit, “Ko ini Sa pu Anak yang Sa sayang. Ko bikin Sa pu hati snang.” ");
INSERT INTO pmy_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Waktu Yesus mulai De pu kerja, De pu umur kurang lebi 30 taun. Orang-orang dong tau Yesus tu Yusup pu anak. Yusup pu bapa tu Eli. ");
INSERT INTO pmy_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli pu bapa tu Matat, Matat pu bapa Lewi, Lewi pu bapa Melki, Melki pu bapa Yanai, Yanai pu bapa Yusup. ");
INSERT INTO pmy_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yusup pu bapa Matica, Matica pu bapa Amos, Amos pu bapa Nahum, Nahum pu bapa Hesli, Hesli pu bapa Nagai. ");
INSERT INTO pmy_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai pu bapa Maat, Maat pu bapa Matias, Matias pu bapa Semein, Semein pu bapa Yosek, Yosek pu bapa Yoda. ");
INSERT INTO pmy_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda pu bapa Yohanan, Yohanan pu bapa Resa, Resa pu bapa Zerubabel Zerubabel pu bapa Sealtiel, Sealtiel pu bapa Neri. ");
INSERT INTO pmy_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri pu bapa Melki, Melki pu bapa Adi, Adi pu bapa Kosam, Kosam pu bapa Elmadam, Elmadam pu bapa Er. ");
INSERT INTO pmy_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er pu bapa Yosua, Yosua pu bapa Elieser, Elieser pu bapa Yorim, Yorim pu bapa Matat, Matat pu bapa Lewi. ");
INSERT INTO pmy_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lewi pu bapa Simeon, Simeon pu bapa Yehuda, Yehuda pu bapa Yusup, Yusup pu bapa Yonam, Yonam pu bapa Elyakim. ");
INSERT INTO pmy_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elyakim pu bapa Melea, Melea pu bapa Mena, Mena pu bapa Matata, Matata pu bapa Natan, Natan pu bapa Daud. ");
INSERT INTO pmy_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Daud pu bapa Isai, Isai pu bapa Obet, Obet pu bapa Boas, Boas pu bapa Salmon, Salmon pu bapa Nahason. ");
INSERT INTO pmy_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahason pu bapa Aminadab, Aminadab pu bapa Admin, Admin pu bapa Arni, Arni pu bapa Hezron, Hezron pu bapa Peres, Peres pu bapa Yehuda. ");
INSERT INTO pmy_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yehuda pu bapa Yakub, Yakub pu bapa Ishak, Ishak pu bapa Abraham, Abraham pu bapa Tera, Tera pu bapa Nahor. ");
INSERT INTO pmy_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor pu bapa Seruk, Seruk pu bapa Rehu, Rehu pu bapa Pelek, Pelek pu bapa Eber, Eber pu bapa Salmon. ");
INSERT INTO pmy_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Salmon pu bapa Kenan, Kenan pu bapa Arpaksad, Arpaksad pu bapa Sem, Sem pu bapa Nuh, Nuh pu bapa Lamek. ");
INSERT INTO pmy_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek pu bapa Metusala Metusala pu bapa Henok, Henok pu bapa Yared, Yared pu bapa Mahalaleel, Mahalaleel pu bapa Kenan. ");
INSERT INTO pmy_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan pu bapa Enos, Enos pu bapa Set, Set pu bapa Adam, Adam ni Allah pu anak. ");
INSERT INTO pmy_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Roh Allah kuasai Yesus, trus De pigi dari kali Yordan. Roh Allah bawa De ke tempat sepi yang kring. ");
INSERT INTO pmy_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Disitu Yesus dapa coba dari Iblis 40 hari. 40 hari itu Yesus tra makan apapa jadi De rasa lapar. ");
INSERT INTO pmy_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Begini Iblis bilang sama Yesus, “Ko ni Allah pu Anak to? Coba Ko suru batu ini jadi roti.” ");
INSERT INTO pmy_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesus bilang dia, “Ada tatulis begini, ‘Manusia hidup tu bukan dari roti saja.’ ” ");
INSERT INTO pmy_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Trus Iblis de bawa Yesus ke tempat satu yang tinggi, disana deng cepat skali Iblis kas liat smua krajaan di dunia. ");
INSERT INTO pmy_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Iblis bilang Dia, “Smua kuasa itu deng harta yang banyak itu, sa nanti kasi smua untuk Ko, karna smua itu sa su dapa kasi. Trus sa bisa kasi smua itu sama sapa saja yang sa mau. ");
INSERT INTO pmy_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Jadi sa mo kasi smua sama Ko tapi, kalo Ko mo tunduk semba sama saya.” ");
INSERT INTO pmy_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Tapi Yesus jawab, “Ada tatulis, ‘Ko harus semba ko pu Tuhan Allah, trus ko harus kerja hanya untuk De saja!’ ” ");
INSERT INTO pmy_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Habis itu de bawa Yesus ke Yerusalem trus bawa De di ujung bagian atas Ruma Allah. Baru de bilang ke Yesus, “Ko ni Allah pu Anak to, coba Ko lompat dari sini ke bawa. ");
INSERT INTO pmy_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Karna ada tatulis begini, ‘Tentang Ko, Allah pasti kas printa De pu malaikat-malaikat untuk jaga Ko. ");
INSERT INTO pmy_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Trus dong nanti tada Ko deng dong pu tangan supaya Ko pu kaki juga jang kena batu.’” ");
INSERT INTO pmy_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesus jawab de, “Ada tatulis, ‘Jang ko coba-coba ko pu Tuhan Allah!’ ” ");
INSERT INTO pmy_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Stela Iblis slesai coba Yesus, de mundur dari Yesus trus de tunggu waktu yang baik. ");
INSERT INTO pmy_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Stela itu deng kuasa Roh Allah, Yesus De kembali ke daera Galilea. Di daera itu, di mana-mana tempat orang-orang crita tentang Yesus. ");
INSERT INTO pmy_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Waktu itu De kas ajar di tempat-tempat ibada situ, smua orang dong puji-puji Dia. ");
INSERT INTO pmy_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesus De pigi juga ke Nasaret tempat dulu De besar disitu. Sperti biasa Yesus masuk ke tempat ibada pas orang Yahudi pu hari Sabat, trus bediri untuk baca Kitab Suci. ");
INSERT INTO pmy_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Dong kasi Yesus baca kitab yang Nabi Yesaya de tulis. Habis buka kitab itu, De dapat ayat yang tulis begini, ");
INSERT INTO pmy_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Tuhan pu Roh ada sama Saya, karna De su pili Saya untuk kastau Brita Baik ke orang miskin. De utus Sa untuk kas lepas orang yang dapa tangkap, kas sembu mata yang tra bisa liat, untuk kas lepas orang yang dapa injak, ");
INSERT INTO pmy_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","trus kastau kalo Tuhan su mulai kas liat De pu sayang ke De pu umat.” ");
INSERT INTO pmy_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Habis tu Yesus tutup kitab itu baru kas kembali sama yang tugas disitu, trus duduk. Smua orang dalam tempat ibada tu liat baik-baik ke Dia. ");
INSERT INTO pmy_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Trus Yesus mulai kas ajar dong, De bilang, “Hari ini smua yang tadi kam su dengar tu, skarang su jadi.” ");
INSERT INTO pmy_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Smua orang puji De baru dong heran kata-kata bagus skali yang De bilang, trus dong bilang, “Tra sangka eh! De tu Yusup pu Anak.” ");
INSERT INTO pmy_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jadi Yesus bilang sama dong begini, “Pasti kam mo bicara Sa kata pepata yang bilang,‘Dokter, kas sembu ko pu diri dulu.’ Coba buat disini di Ko pu kampung smua yang tong su dengar yang Ko su bikin di Kapernaum! ” ");
INSERT INTO pmy_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yesus tamba bicara lagi, “Yang Sa bilang ini benar: Trada nabi yang dapa hormat di de pu kampung sendiri. ");
INSERT INTO pmy_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Tapi Sa kastau kam: Waktu jaman Nabi Elia, disitu hujan tra turun sampe tiga stenga taun, ada musiba lapar di smua negri itu. Waktu itu ada banyak janda-janda di Israel, ");
INSERT INTO pmy_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","tapi Allah tra utus Elia ke satu orang dari dong, tapi ke satu prempuan janda di Sarfat, di tana Sidon. ");
INSERT INTO pmy_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Waktu Nabi Elisa pu jaman, banyak orang yang sakit kulit busuk di Israel, juga trada satu orang yang dapa kas sembu dari dong, cuma Naaman, orang Siria itu.” ");
INSERT INTO pmy_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Dengar itu smua orang di tempat ibada dong mara skali. ");
INSERT INTO pmy_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Dong bediri trus usir Yesus kluar kota baru bawa De ke pinggir gunung, tempat kota itu dong bangun. Dong mo dorong De ke jurang itu. ");
INSERT INTO pmy_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Tapi Yesus De jalan dari tenga-tenga dong trus pigi. ");
INSERT INTO pmy_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Trus Yesus pigi ke Kota Kapernaum di daera Galilea. Disitu Yesus kas ajar stiap hari Sabat. ");
INSERT INTO pmy_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Dong smua heran dengar apa yang De kas ajar, karna De pu kata-kata penu deng kuasa. ");
INSERT INTO pmy_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Di dalam tempat ibada itu, ada satu orang yang krasukan setan, de batariak deng suara kras, ");
INSERT INTO pmy_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“He Yesus, orang Nasaret, Ko mo bikin apa deng kitong? Ko datang mo kas hancur tong ka? Sa tau Ko tu sapa, Ko itu Orang Suci yang Allah utus.” ");
INSERT INTO pmy_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Tapi Yesus printa dia, “Diam! Kluar dari dia!” Setan itu banting orang itu di tenga-tenga orang banyak, trus de kluar baru tra bikin sakit orang itu. ");
INSERT INTO pmy_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Trus smua orang yang liat tu heran, dong baku bicara, “Sunggu, hebat skali kata-kata ini! Karna deng penu kuasa De kas printa setan-setan, trus dong kluar.” ");
INSERT INTO pmy_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Trus tasebar brita tentang Yesus di smua daera itu. ");
INSERT INTO pmy_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesus kas tinggal tempat ibada, trus pigi ke Simon pu ruma. Simon pu mama mantu sakit panas tinggi, jadi dong minta Yesus tolong mama. ");
INSERT INTO pmy_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Trus Yesus pigi bediri di samping mama baru usir sakit itu. Panas tinggi tu hilang, langsung mama de bangun deng kas siap makanan untuk Yesus dorang. ");
INSERT INTO pmy_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Pas matahari masuk, banyak orang bawa dong pu kluarga yang mendrita sakit macam-macam. Trus Yesus De taru tangan di dong smua yang sakit satu-satu trus kas sembu dorang. ");
INSERT INTO pmy_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Dari banyak orang kluar setan-setan deng batariak, “Yesus, Ko ni Allah pu Anak.” Tapi Yesus tegur suru dong diam, karna dong tau kalo Yesus tu Raja Yang Allah Pili. ");
INSERT INTO pmy_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Pas matahari baru mo naik, Yesus pigi ke tempat yang sunyi. Orang-orang dong cari De, pas dong dapat, baru dong coba tahan Yesus supaya jang kas tinggal dorang. ");
INSERT INTO pmy_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Tapi Yesus bilang, “Di kota-kota lain juga Sa harus kastau Brita Baik tentang Allah pu Krajaan, karna untuk itu Sa dapa utus ke dunia ini.” ");
INSERT INTO pmy_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Trus De kastau Brita Baik dalam tempat-tempat ibada di daera Yudea. ");
INSERT INTO pmy_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Satu hari Yesus bediri di pinggir danau Genesaret. Banyak orang dempet-dempet kliling Yesus supaya dong mo dengar Allah pu kata-kata. ");
INSERT INTO pmy_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Begini Yesus liat ada prahu dua di danau situ, orang-orang tukang tangkap ikan su turun dari prahu itu, dong ada kas bersi dong pu jala. ");
INSERT INTO pmy_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesus naik dalam prahu satu, yang pu prahu tu Simon. Trus Yesus suru Simon dorong de pu prahu ke tenga sdikit, baru Yesus duduk dalam prahu deng mulai kas ajar orang banyak. ");
INSERT INTO pmy_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Habis kas ajar, Yesus bilang Simon, “Ko tolak prahu ke tempat yang dalam trus buang jala, supaya kam tangkap ikan.” ");
INSERT INTO pmy_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon de jawab, “Bapa guru, spanjang malam tong kerja kras tapi tra tangkap apapa, tapi karna Bapa yang suru, sa mo lepas jala lagi.” ");
INSERT INTO pmy_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Dong kas lepas jala begini, dong dapat ikan banyak skali sampe jala mo robek. ");
INSERT INTO pmy_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Jadi dong kode panggil teman-teman di prahu lain supaya bantu dong. Teman-teman dong datang baru sama-sama dong isi prahu dua tu deng ikan sampe mo tenggelam. ");
INSERT INTO pmy_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Waktu Simon Petrus de liat itu, de tunduk depan Yesus pu kaki baru bilang, “Tuhan! Sa ni tra pantas dekat Tuhan. Kas tinggal sa suda, karna sa ni orang yang bikin dosa!” ");
INSERT INTO pmy_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simon bicara begitu, karna Simon deng orang yang sama-sama disitu, heran skali liat ikan yang dong dapat sampe banyak begitu. ");
INSERT INTO pmy_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Begitu juga Simon pu teman kerja Yakobus deng Yohanes, bapa Zebedeus pu anak dua. Trus Yesus bilang sama Simon, “Jang takut! Skarang ko jadi orang yang jala manusia.” ");
INSERT INTO pmy_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Habis itu Simon deng de pu teman-teman tarik prahu kas naik di darat, trus dong kas tinggal smua disitu trus pigi ikut Dia. ");
INSERT INTO pmy_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Satu kali begini, Yesus De di kota satu. Disitu ada satu orang yang pu kulit penu deng luka busuk. Waktu de liat Yesus, de tunduk sampe muka kena tana di depan Yesus pu kaki trus minta, “Tuhan, kalo Tuhan mau, Tuhan pasti bisa kas sembu saya.” ");
INSERT INTO pmy_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Trus Yesus kas tangan pegang orang itu, deng bilang, “Sa mau, ko sembu suda.” Waktu itu juga, de pu sakit kulit busuk hilang. ");
INSERT INTO pmy_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesus larang de jang kastau ke sapa-sapa trus bilang, “Pigi, kas liat ko pu diri ke imam trus kasi persembahan untuk kas bersi ko pu diri. Kasi sperti yang Musa de printa, itu jadi bukti ke dorang.” ");
INSERT INTO pmy_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Tapi smakin banyak orang crita tentang Yesus. Jadi banyak orang datang mo dengar deng mo dapa kas sembu dari dong pu sakit. ");
INSERT INTO pmy_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Tapi Yesus biasa pigi ke tempat sepi yang kring untuk doa. ");
INSERT INTO pmy_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Satu hari Yesus kas ajar banyak orang di ruma satu, disitu ada orang-orang Farisi deng guru-guru agama juga duduk dengar. Dong smua datang dari Yerusalem, juga dari kampung-kampung di Galilea deng Yudea. Kuasa Tuhan ada sama Yesus untuk kas sembu orang-orang sakit. ");
INSERT INTO pmy_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Pas waktu itu ada orang-orang yang bawa orang lumpu satu yang ada tidur di tikar, dong coba mo bawa masuk orang itu taru depan Yesus. ");
INSERT INTO pmy_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Tapi dong tra bisa bawa de masuk, karna orang banyak skali disitu. Dong naik ke ruma itu pu bagian atas, dong bongkar atap yang Yesus ada bediri di bawa baru kas turun orang itu deng de pu tikar di tenga orang-orang pas depan Yesus. ");
INSERT INTO pmy_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Waktu Yesus liat dong percaya skali, De bilang, “Sodara, ko pu dosa-dosa su dapa kas ampun.” ");
INSERT INTO pmy_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Guru-guru agama deng orang Farisi dong pikir dalam hati, “Orang ini sapa yang brani hina Allah? Cuma Allah saja yang bisa kas ampun dosa.” ");
INSERT INTO pmy_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Tapi Yesus su tau yang dong pikir jadi De bilang dorang, “Knapa kam pikir begitu dalam kam pu hati? ");
INSERT INTO pmy_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Mana lebi gampang, bilang, ‘Ko pu dosa-dosa su dapa kas ampun,’ ato bilang, ‘Bediri deng jalan suda’? ");
INSERT INTO pmy_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Tapi, supaya kam tau kalo di dunia ini Sa Anak Manusia pu kuasa kas ampun dosa.” Trus Yesus bilang sama orang lumpu itu, “Sa bilang ko, bediri, angkat ko pu tikar trus pulang ke ko pu ruma!” ");
INSERT INTO pmy_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Langsung orang yang tra bisa jalan tu, de bangun di depan dong smua. Habis tu de angkat tempat yang de tidur baru pulang deng puji Allah. ");
INSERT INTO pmy_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Orang smua disitu dong heran, trus dong puji Allah. Deng rasa takut dong bilang begini, “Luar biasa skali pristiwa yang tong liat hari ini!” ");
INSERT INTO pmy_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Trus waktu Yesus kluar, De liat satu orang yang tukang tagi pajak. De pu nama Lewi, de ada duduk di tempat tagi pajak. Begini Yesus bilang ke dia, “Mari ko ikut Saya.” ");
INSERT INTO pmy_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Dengar begitu, Lewi de bediri kas tinggal smua-smua trus ikut Dia. ");
INSERT INTO pmy_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Habis tu, Lewi bikin pesta makan-makan yang besar di de pu ruma untuk Yesus. Banyak orang-orang, tukang tagi pajak deng orang-orang lain juga ikut makan sama-sama deng Dia. ");
INSERT INTO pmy_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Orang Farisi deng dong pu guru-guru agama sungut-sungut sama Yesus pu murid-murid, dong bilang, “Ih, bisa eh, kam makan minum sama-sama deng tukang tagi pajak deng orang-orang yang bikin dosa?” ");
INSERT INTO pmy_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesus jawab ke dong, “Bukan orang sehat yang perlu dokter, tapi orang sakit. ");
INSERT INTO pmy_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Sa tra datang untuk panggil orang yang rasa diri benar tapi untuk panggil orang yang bikin dosa, supaya dong kas tinggal dong pu sala baru balik sama Allah.” ");
INSERT INTO pmy_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Orang-orang Farisi bilang ke Yesus, “Yohanes pu murid-murid biasa dong doa deng puasa, begitu juga tong pu murid-murid, tapi Ko pu murid-murid ni dong tinggal makan deng minum.” ");
INSERT INTO pmy_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesus jawab dong begini, “Bisa ka, pengantin laki-laki pu teman dapa suru puasa pas pengantin itu ada sama-sama deng dorang? ");
INSERT INTO pmy_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Tapi nanti ada de pu waktu untuk pengantin itu dapa ambil dari dorang, pas waktu itu baru dong puasa.” ");
INSERT INTO pmy_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Trus Yesus tamba crita satu conto lagi untuk dong tu begini, “Trada orang to yang robek kain spanggal dari baju yang baru trus tempel di baju yang lama, percuma de su robek baju yang baru trus kain dari baju baru tu tra cocok deng baju yang lama itu. ");
INSERT INTO pmy_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Begitu juga, trada orang yang isi air anggur yang baru ke dalam kantong kulit yang lama, karna kalo bikin begitu nanti air anggur yang baru itu bikin robek kantong itu, jadi air anggur itu tabuang trus kantong itu rusak. ");
INSERT INTO pmy_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Jadi air anggur yang baru harus orang simpan di dalam kantong kulit yang baru juga. ");
INSERT INTO pmy_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Begitu juga orang tra mo minum air anggur yang baru kalo de su rasa air anggur yang lama. Karna de bilang, ‘Anggur yang lama tu lebi enak.’ ” ");
INSERT INTO pmy_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Satu hari begini, waktu orang Yahudi pu hari Sabat, Yesus deng De pu murid-murid dong jalan di kebun gandum. Murid-murid petik biji-biji gandum, gosok dalam dong pu tangan trus makan de pu isi. ");
INSERT INTO pmy_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Tapi orang-orang Farisi bilang, “Knapa di tong pu hari Sabat kam bikin apa yang hukum Musa larang?” ");
INSERT INTO pmy_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Trus Yesus jawab dorang, “Kam tra perna baca yang Daud bikin ka, waktu de sama orang-orang yang ikut dia, dong lapar? ");
INSERT INTO pmy_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Bagemana de masuk dalam Ruma Allah trus ambil roti yang su kasi sama Allah, de makan baru kasi sama dong yang ikut dia. Padahal hanya imam-imam saja yang bisa makan itu to?” ");
INSERT INTO pmy_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yesus bilang lagi sama dorang, “Sa Anak Manusia pu kuasa atas hari Sabat.” ");
INSERT INTO pmy_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Satu hari begini pas orang Yahudi pu hari Sabat lain lagi, Yesus masuk tempat ibada baru kas ajar orang banyak. Disitu ada orang satu yang de pu tangan sebla kanan mati. ");
INSERT INTO pmy_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Guru-guru agama sama orang Farisi dong trus jaga liat Yesus, jang sampe De kas sembu orang itu pas hari Sabat, supaya dong bisa kas sala Dia. ");
INSERT INTO pmy_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Tapi Yesus su tau dong pu pikiran, trus Yesus bilang ke orang yang de pu tangan mati, “Mari bediri di tenga sini!” Trus de bangun deng bediri. ");
INSERT INTO pmy_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Habis itu, Yesus tanya dong, “Sa mo tanya kam: Mana yang tong bisa buat pas hari Sabat? Buat baik ato buat jahat? Kas slamat orang ato kas tinggal de mati?” ");
INSERT INTO pmy_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Habis itu De liat kliling ke dong smua baru bilang sama orang yang sakit itu, “Kas lurus ko pu tangan!” Orang itu bikin begitu, langsung de pu tangan sembu. ");
INSERT INTO pmy_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Tapi guru-guru agama deng orang Farisi yang disitu dong mara skali, jadi dong mulai bicara atur rencana tentang apa yang bisa dong bikin sama Yesus. ");
INSERT INTO pmy_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Pas hari-hari itu Yesus naik ke gunung satu untuk doa, Yesus De doa spanjang malam sama Allah. ");
INSERT INTO pmy_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Habis doa, pas hari su trang, De panggil De pu murid-murid datang, trus De pili dari tenga dong duablas orang yang De juga sebut dong itu utusan. ");
INSERT INTO pmy_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon yang juga De kas nama Petrus, deng de pu ade Andreas, Yakobus, Yohanes, Filipus, Bartolomeus, ");
INSERT INTO pmy_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matius, Tomas, Yakobus, bapa Alfeus pu anak, Simon de dari klompok Zelot, ");
INSERT INTO pmy_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yudas, bapa Yakobus pu anak, deng Yudas Iskariot yang nanti jual Yesus. ");
INSERT INTO pmy_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Habis Yesus De pili De pu duablas utusan, dong smua turun dari bukit. Dong brenti di tempat yang rata. Di tempat itu su kumpul orang banyak skali yang ikut Dia, juga banyak orang yang datang dari smua daera Yudea deng Yerusalem juga dari pinggir laut, Kota Tirus deng Sidon. ");
INSERT INTO pmy_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Orang-orang ini datang mo dengar Yesus pu ajaran deng dapa sembu dari dong pu sakit, juga yang krasukan setan dapa kas sembu. ");
INSERT INTO pmy_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Smua orang mo coba pegang Yesus, karna ada kuasa yang kluar dari Yesus yang kas sembu smua orang itu. ");
INSERT INTO pmy_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesus liat ke De pu murid-murid dong trus bilang, “Kam yang tra pu apapa, kam untung skali, karna kam nanti jadi Allah pu orang-orang di De pu Krajaan! ");
INSERT INTO pmy_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Kam yang skarang lapar, kam untung skali, karna nanti kam dapa kas kenyang. Kam yang mnangis skarang, kam untung skali, karna nanti kam tertawa. ");
INSERT INTO pmy_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Kam untung skali waktu orang tra suka skali sama kam, waktu kam dapa tolak, dapa ejek trus dong bilang kam orang jahat karna kam ikut Saya Anak Manusia! ");
INSERT INTO pmy_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Waktu itu kam rasa syukur deng snang skali, karna yang betul itu, kam pu hadia besar di surga. Begitu juga dulu dong pu nene moyang bikin ke nabi-nabi. ");
INSERT INTO pmy_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Tapi claka kam yang kaya skarang, karna kam su dapat yang cukup. ");
INSERT INTO pmy_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Claka kam yang skarang kenyang, karna nanti kam lapar! Claka kam yang skarang tertawa, karna nanti kam pu hati sedi skali deng mnangis. ");
INSERT INTO pmy_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Kam claka, kalo smua orang puji-puji kam, karna dulu begitu juga dong pu nene moyang puji orang yang pura-pura jadi nabi.” ");
INSERT INTO pmy_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Tapi buat kam yang skarang dengar Sa ni, Sa mo kastau ini: Kam harus sayang sama kam pu musu-musu trus kam buat baik ke orang yang tra suka skali sama kam. ");
INSERT INTO pmy_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Kas berkat orang yang kutuk kam, doa dong yang hina kam. ");
INSERT INTO pmy_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kalo orang tampar ko pu pipi sebla, kasi pipi sebla juga. Kalo dong paksa ambil kam pu baju panjang luar, kas tinggal dong ambil baju lain juga. ");
INSERT INTO pmy_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Kasi sama smua orang yang minta sama ko, kalo dong ambil deng paksa, jang ko minta kembali. ");
INSERT INTO pmy_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Bikin apa saja ke orang lain sama sperti yang kam snang orang bikin itu untuk kam. ");
INSERT INTO pmy_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Trus kalo kam sayang sama orang yang sayang sama kam saja, kam pikir nanti Allah puji kam untuk itu? Tra to! Karna orang-orang yang bikin dosa juga sayang sama orang yang sayang dong. ");
INSERT INTO pmy_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Trus kalo kam bikin baik sama orang yang baik sama kam, kam pikir nanti Allah puji kam untuk itu? Tra to! Karna orang yang bikin dosa juga dong buat baik ke orang yang baik sama dong. ");
INSERT INTO pmy_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Trus kalo kam kas pinjam uang hanya ke orang yang bisa kas kembali, kam pikir nanti Allah puji kam untuk itu? Orang yang bikin dosa juga kas pinjam supaya dong bisa dapat kembali dong pu uang sama banyak. ");
INSERT INTO pmy_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Kam jang begitu! Kam harus sayang sama kam pu musu trus buat baik sama dorang. Kam harus bisa kas pinjam, tra bole harap untuk dong mo kas kembali. Deng begitu nanti Allah kasi kam bagian yang besar di surga, trus kam nanti jadi Allah Yang Paling Tinggi pu anana. Karna Allah De pu hati baik sama orang yang tra tau trima kasi, juga sama orang yang jahat. ");
INSERT INTO pmy_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kam musti pu rasa sayang sama sperti kam pu Bapa, yang penu deng rasa sayang sama orang!” ");
INSERT INTO pmy_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Jang kam adili orang lain, supaya kam tra dapa adili dari Allah. Jang kas hukum orang lain, supaya kam sendiri tra dapa hukum dari Allah. Kas ampun orang lain, supaya Allah juga kas ampun kam. ");
INSERT INTO pmy_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Kasi ke orang lain, supaya Allah nanti kasi sama kam lebi-lebi, sperti orang yang kasi bras, de isi bras trus goyang-goyang supaya padat trus tamba lagi sampe tumpa-tumpa. Kam pu cara ukur itu yang nanti Allah pake untuk ukur kam.” ");
INSERT INTO pmy_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Trus Yesus De crita conto satu lagi sama dong begini, “Bisa ka orang buta yang bawa orang buta? Pasti dong dua jatu ke dalam lobang to. ");
INSERT INTO pmy_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Trada murid yang bisa lebi dari de pu guru. Tapi sapa saja yang su slesai de pu plajaran nanti sperti de pu guru. ");
INSERT INTO pmy_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Knapa kam bisa liat ampas kayu dalam kam pu sodara pu mata, baru balok dalam ko pu mata sendiri ko tra liat? ");
INSERT INTO pmy_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Bagemana ko bisa bilang ko pu sodara, ‘Sodara, mari biar sa kas kluar ampas kayu yang di ko pu mata,’ baru balok yang di ko pu mata ko tra liat ka? Kam yang pura-pura baik! Kas kluar dulu balok yang di kam pu mata, baru ko bisa liat jlas untuk kas kluar ampas kayu itu dari ko pu sodara pu mata.” ");
INSERT INTO pmy_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Trada pohon yang subur kas hasil bua yang tra bagus, juga pohon yang tra subur kas hasil bua yang bagus. ");
INSERT INTO pmy_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Karna dari bua tong bisa tau itu pohon apa. Karna tra mungkin orang petik bua ara di duri yang jalar ato petik bua anggur di rumput duri-duri. ");
INSERT INTO pmy_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Orang baik kas kluar hal-hal baik yang de simpan dalam hati, orang jahat kas kluar hal-hal jahat yang de simpan dalam de pu hati. Karna apa yang orang bicara tu kluar dari dalam de pu hati.” ");
INSERT INTO pmy_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Trus Yesus bilang lagi, “Kam panggil Sa, ‘Tuhan, Tuhan!’ Knapa kam tra bikin apa yang Sa bilang? ");
INSERT INTO pmy_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Begini Sa mo kas conto orang yang datang sama Sa, trus dengar Sa pu kata-kata baru de bikin. ");
INSERT INTO pmy_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","De sperti orang yang mo bangun ruma. De gali tana dalam-dalam trus bikin fondasi di atas batu. Jadi waktu ada banjir dari sungai trus air tabrak ruma itu, ruma itu tra rusak, karna su bikin ruma itu di fondasi yang baik. ");
INSERT INTO pmy_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Tapi orang yang dengar Sa pu kata-kata, habis itu de tra bikin, itu sperti orang yang bikin ruma trada fondasi. Kalo banjir dari sungai tabrak ruma itu, langsung ruma rata deng tana trus hancur skali!” ");
INSERT INTO pmy_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Habis bicara smua hal-hal itu sama orang banyak, Yesus De pigi masuk ke Kapernaum. ");
INSERT INTO pmy_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Disitu ada perwira satu, de pu pesuru satu yang de sayang, de ada sakit kras sampe mo mati. ");
INSERT INTO pmy_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Waktu perwira ni de dengar tentang Yesus, de suru orang Yahudi pu tua-tua dong pigi minta Yesus datang tolong kas sembu de pu pesuru. ");
INSERT INTO pmy_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Waktu dong baku dapat deng Yesus, dong minta deng sunggu sama Yesus, dong bilang, “Perwira ini pantas Bapa tolong dia, ");
INSERT INTO pmy_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","karna de ni sayang tong pu suku, trus de juga su bangun tong pu tempat ibada.” ");
INSERT INTO pmy_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Trus Yesus pigi ikut sama-sama dorang. Tra jau dari perwira itu pu ruma, pewira de suru de pu teman-teman bilang sama Yesus begini, “Tra usa Bapa cape-cape, sa ni tra pantas trima Bapa di sa pu ruma, ");
INSERT INTO pmy_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","itu yang sa rasa tra pantas ketemu deng Bapa. Jadi Bapa bicara satu kata saja pasti sa pu pesuru sembu. ");
INSERT INTO pmy_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Sa tau karna sa juga ikut printa dari orang yang di atas saya, trus di bawa sa juga ada prajurit. Kalo sa suru prajurit satu, ʻPigi!ʼ pasti de pigi, trus kalo sa printa yang lain, ʻMari sini!ʼ pasti de datang. Trus kalo sa kas printa sa pu pesuru, ʻBikin ini!ʼ pasti de bikin yang sa suru.” ");
INSERT INTO pmy_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Dengar begitu Yesus heran trus balik liat deng bicara ke orang banyak yang ikut Dia, “Sa kastau kam, orang yang percaya skali sperti ini, Sa blum perna ketemu, biar mo itu di tenga orang Israel!” ");
INSERT INTO pmy_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Waktu teman-teman yang dapa suru itu kembali pulang ke ruma, dong liat pesuru itu de su sembu. ");
INSERT INTO pmy_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Tra lama begini, Yesus pigi ke kampung Nain. Yesus pu murid-murid deng orang banyak juga ikut. ");
INSERT INTO pmy_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Waktu Yesus sampe dekat pintu gerbang kampung itu, ada orang-orang dong bawa jenasa kluar kampung. Orang yang mati itu, janda satu de pu anak laki-laki satu itu saja. Banyak orang dari kampung itu ikut prempuan itu. ");
INSERT INTO pmy_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Waktu Tuhan Yesus liat dia, Yesus kasian dia trus bilang, “Mama, jang ko mnangis!” ");
INSERT INTO pmy_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Habis tu Yesus De pigi dekat baru pegang tempat pikul mayat. Orang-orang yang angkat mayat tu brenti, baru Tuhan Yesus De bilang, “Anak muda, Sa suru ko bangun!” ");
INSERT INTO pmy_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Anak muda yang su mati tu, bangun duduk trus mulai bicara. Habis tu Yesus kas kembali anak itu ke de pu mama. ");
INSERT INTO pmy_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Smua orang yang disitu heran skali, trus dong puji Allah. Dong bilang, “Satu Nabi besar ada di tenga-tenga kitong! Allah su datang kas slamat De pu orang-orang.” ");
INSERT INTO pmy_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Crita tentang Yesus, orang-orang dong pigi crita di smua daera Yudea deng daera-daera dekat situ. ");
INSERT INTO pmy_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Waktu Yohanes di penjara de pu murid-murid dong kastau smua yang su jadi sama dia. ");
INSERT INTO pmy_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Trus Yohanes de panggil de pu murid dua, baru suru pigi tanya Yesus begini, “Bapa ni Orang yang mo datang sperti Allah pu janji ato tong harus tunggu orang lain?” ");
INSERT INTO pmy_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Yohanes pu murid dua, pigi ketemu Yesus baru bilang, “Yohanes Tukang Baptis, de suru tong tanya sama Bapa, ‘Bapa ni Orang yang mo datang sperti Allah pu janji ka ato tong musti tunggu orang lain?’ ” ");
INSERT INTO pmy_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Waktu itu Yesus ada kas sembu banyak orang yang sakit deng usir banyak setan juga buat banyak orang buta bisa liat. ");
INSERT INTO pmy_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Karna begitu Yesus jawab dorang, “Kembali sama Yohanes trus kastau apa yang kam dengar deng liat: orang buta bisa liat, orang yang tra bisa jalan su bisa jalan, orang yang sakit kulit busuk bisa sembu, orang tuli bisa dengar, orang mati hidup kembali, orang yang trada apapa dong dengar Brita Baik dari Allah. ");
INSERT INTO pmy_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Orang yang tra tolak Saya, dong untung skali.” ");
INSERT INTO pmy_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Habis Yohanes de pu murid-murid dong pigi, Yesus mulai bicara lagi begini sama orang banyak tentang Yohanes, “Waktu kam pigi ke Yohanes Tukang Baptis di tempat sepi yang kring, kam mo liat apa? Kam mo pigi liat rumput yang goyang karna angin ka? ");
INSERT INTO pmy_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Kalo trada, kam pigi mo liat apa? Kam pigi kesana mo liat orang deng pakean bagus ka? Orang yang pu pakean bagus trus pu hidup kaya skali itu tinggal di istana. ");
INSERT INTO pmy_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Jadi untuk apa kam pigi kesana? Untuk mo liat nabi ka? Betul. Sa bilang kam, de ni lebi dari nabi-nabi lain. ");
INSERT INTO pmy_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Karna ada tatulis tentang de begini, ‘Liat! Sa suru Sa pu utusan duluan Ko, de nanti kas siap Ko pu jalan di depan Ko.’ ");
INSERT INTO pmy_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Sa bilang kam, dari antara dong yang lahir dari prempuan, tra perna ada orang yang lebi besar dari Yohanes. Tapi orang yang renda skali dalam Allah pu Krajaan, de lebi besar dari Yohanes.” ");
INSERT INTO pmy_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Smua orang yang dengar deng tukang tagi pajak juga, dong akui kalo Allah pu pesan itu benar, karna dong su dapa baptis dari Yohanes. ");
INSERT INTO pmy_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Tapi orang Farisi deng guru-guru agama, dong tolak Allah pu mau untuk dong pu hidup, karna dong tra mau dapa baptis dari Yohanes. ");
INSERT INTO pmy_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jadi Yesus bicara lagi begini, “Macam apa eh Sa mo kas conto orang-orang jaman ini? Dong tu sama deng apa eh? ");
INSERT INTO pmy_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Dong sperti dua klompok anana yang duduk di pasar, klompok satu bilang sama klompok lain, ‘Tong su toki tifa supaya kam mnari, tapi kam tra mnari. Tong su mnyanyi lagu sedi, tapi kam tra mnangis.’ ");
INSERT INTO pmy_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Kam sperti itu, karna Yohanes Tukang Baptis de datang, de tra makan makanan yang orang makan deng minum yang orang minum, begitu kam bilang, ‘De krasukan setan.’ ");
INSERT INTO pmy_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Sa Anak Manusia makan deng minum, trus kam bilang, ‘Liat orang itu! De rakus, tukang mabuk, De kawan deng orang yang bikin dosa sama tukang tagi pajak.’ ");
INSERT INTO pmy_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Tapi Allah pu cara pikir yang paling baik dapa kas bukti yang benar lewat orang yang ikut Dia.” ");
INSERT INTO pmy_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ada orang satu de pu nama Simon, de ni dari klompok Farisi. De ajak Yesus makan di de pu ruma. Yesus pigi ke de pu ruma baru dong makan disitu. ");
INSERT INTO pmy_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Begini di kota itu, ada prempuan satu yang bikin dosa. Waktu de dengar Yesus ada makan di orang Farisi pu ruma tu, de datang bawa minyak wangi yang mahal dalam botol dari batu puti. ");
INSERT INTO pmy_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","De bediri mnangis di blakang dekat Yesus pu kaki. De kas basa Yesus pu kaki deng de pu air mata baru de lap-lap pake de pu rambut. Trus de cium Yesus pu kaki ulang-ulang baru de gosok Yesus pu kaki pake minyak wangi. ");
INSERT INTO pmy_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Waktu orang Farisi, yang undang Yesus tu liat begitu, de pikir dalam hati, “Kalo benar De Nabi, pasti De tau prempuan macam apa yang ada pegang De, kalo de ni prempuan yang bikin dosa.” ");
INSERT INTO pmy_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Trus Yesus bicara sama Simon, “Simon, Sa mo kastau ko.” Simon de bilang, “Iyo, Bapa Guru kastau suda.” Yesus bilang, ");
INSERT INTO pmy_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“Ada dua orang yang pu utang, sama orang yang tukang kas pinjam uang. Yang satu pu utang 500 uang perak baru yang satu lagi pu utang 50 uang perak. ");
INSERT INTO pmy_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Karna dong tra bisa bayar, jadi de hapus dong dua pu utang. Jadi sapa dari dong dua yang paling sayang sama orang itu?” ");
INSERT INTO pmy_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon jawab, “Mnurut sa, orang yang pu utang lebi banyak.” Yesus jawab, “Betul yang ko bilang.” ");
INSERT INTO pmy_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Trus Yesus De balik ke prempuan itu, baru De bilang Simon, “Ko liat prempuan ini? Sa masuk ke ko pu ruma, ko tra kasi Sa air untuk cuci Sa pu kaki. Tapi de kas basa Sa pu kaki deng air mata baru lap pake de pu rambut. ");
INSERT INTO pmy_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ko tra trima Sa deng cium, tapi dari Sa masuk de tra stop-stop cium Sa pu kaki. ");
INSERT INTO pmy_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ko tra gosok minyak di Sa pu kepala, tapi de gosok minyak wangi di Sa pu kaki. ");
INSERT INTO pmy_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Liat, de pu kasi yang besar itu kas tunjuk kalo de pu dosa yang banyak suda dapa kas ampun. Tapi orang yang dapa kas ampun sdikit, sdikit juga de buat kasi.” ");
INSERT INTO pmy_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Trus Yesus bilang sama prempuan itu, “Ko pu dosa su dapa kas ampun.” ");
INSERT INTO pmy_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Orang-orang yang ada makan deng Yesus pikir dalam hati, “Orang ini De sapa, sampe bisa kas ampun dosa?” ");
INSERT INTO pmy_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Tapi Yesus bilang sama prempuan itu, “Karna ko percaya Saya, Allah su kas slamat ko. Pigi deng hati tenang!” ");
INSERT INTO pmy_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Habis itu Yesus pigi jalan kliling dari kota ke kota deng dari kampung ke kampung kastau Brita Baik tentang Allah pu Krajaan. De sama-sama deng De pu duablas murid-murid. ");
INSERT INTO pmy_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Juga ada prempuan-prempuan yang ikut, dong ni su dapa kas sembu dari sakit deng ada juga yang su dapa kas lepas dari setan-setan. Dong ni: Maria yang dong panggil Magdalena, de ni su dapa kas lepas dari tuju setan, ");
INSERT INTO pmy_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","trus Yohana, de pu paitua Khuza, Herodes pu pegawai, juga Susana deng banyak prempuan lain. Prempuan-prempuan ini dong ikut bantu Yesus dong pake dong pu uang sendiri. ");
INSERT INTO pmy_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Waktu banyak orang dong rame-rame datang dari smua kota, dong kumpul baru Yesus crita satu conto begini, ");
INSERT INTO pmy_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ada orang satu de kluar pigi hambur de pu bibit tanaman. Waktu de hambur bibit tanaman, ada bibit yang jatu di jalan trus orang dong injak trus burung-burung di udara dong makan sampe habis. ");
INSERT INTO pmy_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Trus ada bibit yang jatu di tana yang banyak batu-batu, bibit tumbu trus de jadi kring karna tra dapat air. ");
INSERT INTO pmy_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Bibit lain lagi jatu di rumput duri trus rumput duri itu tumbu baku dempet sampe tanaman itu mati. ");
INSERT INTO pmy_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Trus ada juga yang jatu di tana yang subur, de tumbu deng bua banyak skali, dari satu bibit bisa bua sampe 100 kali lebi banyak.” Habis crita itu trus Yesus bicara deng suara kras, “Sapa yang pu tlinga untuk dengar, de harus dengar baik-baik!” ");
INSERT INTO pmy_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Baru De pu murid-murid dong tanya sama De conto itu pu arti. ");
INSERT INTO pmy_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Trus Yesus De jawab, “Kam su dapa kastau rahasia-rahasia tentang Allah pu Krajaan, tapi sama orang-orang lain itu Sa pake conto, supaya ‘biar dong liat macam dong tra liat, biar dong dengar nanti dong tra mngerti.’ ");
INSERT INTO pmy_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Begini conto itu pu arti: Bibit itu Allah pu kata-kata. ");
INSERT INTO pmy_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Bibit yang jatu di pinggir jalan itu sama deng orang yang su dengar, trus Iblis datang ambil Allah pu kata-kata itu dari dalam dong pu hati, supaya dong jang percaya trus dapa kas slamat. ");
INSERT INTO pmy_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Yang jatu di tana yang batu-batu itu orang-orang yang su dengar Allah pu kata-kata itu, dong trima deng snang skali. Tapi kata-kata itu tra masuk baik-baik dalam dong pu hati, dong percaya sbentar tapi waktu dapa uji langsung dong tra percaya lagi. ");
INSERT INTO pmy_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Trus yang jatu di rumput duri tu, orang-orang yang su dengar Allah pu kata-kata itu, tapi dong slalu rasa kuatir tentang dong pu hidup, juga dong mo hidup kaya saja, sampe dong tra bisa bikin yang baik di dong pu hidup. ");
INSERT INTO pmy_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Yang jatu di tana yang subur itu orang-orang yang dengar Allah pu kata-kata, baru simpan di dong pu hati yang baik deng bersi. Dong slalu bikin yang baik karna dong bisa sabar deng tahan mendrita.” ");
INSERT INTO pmy_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Trada orang yang pasang plita trus mo tutup deng loyang, ato mo taru di bawa tempat tidur. Tapi de pasti taru plita di tempat yang tinggi, supaya smua orang yang masuk dalam ruma bisa liat trang itu. ");
INSERT INTO pmy_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Sama juga trada yang tasembunyi yang nanti tra dapa liat, trus trada rahasia yang nanti tra dapa tau. ");
INSERT INTO pmy_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Jadi, dengar baik-baik apa yang kam dengar. Karna sapa yang trima apa yang de dapat, nanti de dapa kasi lebi banyak lagi, tapi sapa yang tra mo trima banyak, nanti sdikit yang de pikir de su trima, itu juga dapa ambil dari dia.” ");
INSERT INTO pmy_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yesus pu mama deng sodara-sodara datang sama Dia, tapi dong tra bisa dekat De karna banyak orang kliling Dia. ");
INSERT INTO pmy_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Trus ada satu orang datang kastau Yesus, “Bapa pu mama deng sodara-sodara ada di luar, dong mo ketemu deng Bapa.” ");
INSERT INTO pmy_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Tapi Yesus bilang dong, “Sa pu mama deng sodara-sodara tu, dong yang dengar trus buat Allah pu kata-kata.” ");
INSERT INTO pmy_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Satu hari Yesus deng De pu murid-murid dong naik prahu, baru Yesus bilang ke dong, “Mari tong pigi ke sebla.” Trus dong tolak prahu pigi. ");
INSERT INTO pmy_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Waktu dong di tenga danau, Yesus De tidur. Begini tiba-tiba angin kencang skali di danau, sampe air masuk dalam prahu itu baru dong su mo tenggelam. ");
INSERT INTO pmy_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Trus murid-murid datang kas bangun Dia, dong bilang “Guru, guru, tong mo mati tenggelam!” De langsung bangun, trus suru angin deng ombak itu tenang. Angin deng air itu langsung brenti trus danau itu jadi tedu. ");
INSERT INTO pmy_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Trus De bilang sama dong, “Kam knapa tra percaya Saya?” Dong smua takut deng heran, trus dong baku tanya, “Orang ini De sapa ka, sampe De bisa kas printa angin deng air trus dong ikut yang De bilang?” ");
INSERT INTO pmy_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Trus Yesus deng murid-murid dong sampe di orang Gerasa pu tempat, yang ada di sebla timur danau Galilea. ");
INSERT INTO pmy_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Waktu Yesus turun dari prahu, orang satu datang dari tempat itu ke Yesus. Orang itu krasukan setan, trus de su lama tra pake pakean deng tra tinggal di ruma. De tinggal di goa-goa kubur. ");
INSERT INTO pmy_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Waktu de liat Yesus, de batariak trus tunduk depan Yesus deng bicara kras-kras, “Ko mo bikin apa deng saya, Yesus Allah Yang Paling Tinggi pu Anak? Sa mohon, jang siksa sa ka!” ");
INSERT INTO pmy_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Orang itu bilang begitu karna Yesus kas printa setan kluar dari dia. Su biasa setan tu masuk ke dia. Baru de pu tangan su dapa rante deng kaki su dapa ikat kuat trus dong jaga de, tapi de masi bisa kas putus rante itu. Trus setan biasa bawa de ke tempat sepi yang kring. ");
INSERT INTO pmy_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Begini Yesus tanya sama orang itu, “Sapa ko pu nama?” De jawab, “Legion,” karna banyak setan yang su masuk. ");
INSERT INTO pmy_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Setan-setan itu dong mohon supaya Yesus jang usir dong ke orang mati pu tempat. ");
INSERT INTO pmy_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Dekat situ ada babi-babi banyak yang cari makan di dekat jurang, trus setan-setan itu mohon sama Yesus, supaya De kas ijin dong masuk ke babi-babi itu. Yesus kas ijin dorang. ");
INSERT INTO pmy_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Trus setan-setan itu kluar dari orang itu baru masuk ke dalam babi-babi. Trus rombongan babi itu lari ke jurang masuk ke dalam danau trus mati tenggelam. ");
INSERT INTO pmy_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Habis orang-orang yang jaga babi-babi itu liat smua yang jadi tu, dong lari deng crita smua itu di kota deng kampung-kampung yang dekat situ. ");
INSERT INTO pmy_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Dengar begitu, orang-orang datang dari kota deng kampung untuk liat apa yang su jadi. Dong datang ke Yesus, trus liat orang yang krasukan su dapa kas tinggal dari setan-setan itu de duduk dekat Yesus pu kaki. De su pake pakean, juga de su sadar. Jadi dong smua takut. ");
INSERT INTO pmy_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Orang-orang yang liat smua itu sendiri, kastau ke dong, bagemana orang yang krasukan itu bisa sembu. ");
INSERT INTO pmy_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Karna begitu orang-orang Gerasa smua minta Yesus supaya De kas tinggal dorang, karna dong takut skali. Jadi Yesus De naik prahu mo pigi. ");
INSERT INTO pmy_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Orang yang su bebas dari setan-setan tu, de mohon supaya de mo ikut Yesus. Tapi Yesus suru de, ");
INSERT INTO pmy_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Pulang ke ko pu ruma trus crita smua yang Allah su buat sama ko.” Orang itu de pigi ke smua tempat di kota itu baru kastau smua yang Yesus su buat ke dia. ");
INSERT INTO pmy_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Waktu Yesus kembali, orang banyak trima deng snang skali, karna dong smua su tunggu-tunggu Dia. ");
INSERT INTO pmy_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Begini ada satu orang de pu nama Yairus, de ni kepala tempat ibada orang Yahudi. De datang tunduk depan Yesus pu kaki baru minta deng sunggu supaya Yesus mo ke de pu ruma, ");
INSERT INTO pmy_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","karna de pu anak sakit para, de su mo mati. De pu anak ni satu itu saja, prempuan umur 12 taun. Waktu Yesus dong jalan ke Yairus pu ruma, orang banyak dempet-dempet Yesus dari smua ara. ");
INSERT INTO pmy_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Di tenga situ, ada prempuan satu yang su 12 taun sakit pendarahan. Trus trada yang bisa kas sembu biar su kas habis de pu harta untuk brobat ke dokter tapi trada hasil apapa. ");
INSERT INTO pmy_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Prempuan itu de pigi ke dekat Yesus dari blakang, baru kore Yesus pu ujung baju panjang. Waktu itu juga de pu pendarahan langsung stop. ");
INSERT INTO pmy_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Trus Yesus tanya, “Sapa yang kore Saya?” Karna dong smua tra mngaku, jadi Petrus de bilang, “Bapa tra liat ka? Orang banyak dempet-dempet dekat Bapa.” ");
INSERT INTO pmy_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Tapi Yesus bilang, “Ada orang yang kore Saya, karna Sa rasa ada kuasa yang kluar dari Saya.” ");
INSERT INTO pmy_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Prempuan itu sadar kalo yang de bikin tadi, Yesus su tau, jadi de maju deng gementar tunduk muka ke tana depan Yesus, trus de crita sama smua orang yang ada knapa de kore Yesus pu baju juga de bisa langsung sembu. ");
INSERT INTO pmy_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Trus Yesus bilang sama prempuan itu, “Anak, karna ko percaya Saya, ko sembu. Pulang deng hati tenang.” ");
INSERT INTO pmy_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Waktu Yesus masi bicara, datang satu orang dari kepala tempat ibada itu pu kluarga baru bilang, “Bapa pu anak su mati. Bapa tra usa bikin susa Guru lagi.” ");
INSERT INTO pmy_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Tapi Yesus dengar begitu deng bilang ke Yairus, “Jang takut, percaya saja, pasti ko pu anak sembu.” ");
INSERT INTO pmy_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Habis sampe di Yairus pu ruma, Yesus tra kas ijin orang ikut masuk deng De, hanya Petrus, Yohanes, Yakobus deng anak itu pu bapa mama saja. ");
INSERT INTO pmy_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Smua orang mnangis anak itu deng suara besar. Trus Yesus bilang, “Jang mnangis, de tra mati de cuma tidur saja.” ");
INSERT INTO pmy_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Karna dong smua tau kalo anak itu su mati jadi smua orang bicara ejek Dia. ");
INSERT INTO pmy_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Trus Yesus masuk pegang anak itu pu tangan baru bilang deng suara kras, “Mari anak, bangun!” ");
INSERT INTO pmy_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Anak itu de pu nyawa kembali, waktu itu juga de bangun. Trus Yesus suru dong kas makan anak itu. ");
INSERT INTO pmy_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Anak itu pu bapa mama heran skali. Tapi Yesus larang dong jang kastau apa yang su jadi tu, sama sapa saja. ");
INSERT INTO pmy_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Begini Yesus panggil De pu duablas murid, trus kasi dong hak deng kuasa untuk usir setan-setan deng kas sembu penyakit-penyakit. ");
INSERT INTO pmy_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Juga De utus dong pigi kastau tentang Allah pu Krajaan, deng kas sembu orang sakit. ");
INSERT INTO pmy_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Yesus bilang dong, “Jang kam bawa apapa untuk di jalan, jang kam bawa tongkat ato tas, makanan ato uang, ato pakean ganti. ");
INSERT INTO pmy_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Kalo kam mo masuk ruma satu, tinggal disitu sampe kam kas tinggal kota itu. ");
INSERT INTO pmy_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Tapi kalo orang dong tra trima kam, kluar dari dong pu kota deng kas bersi debu dari kam pu kaki. Supaya jadi tanda nanti kota itu dapa hukum.” ");
INSERT INTO pmy_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Habis itu murid-murid dong pigi, dong pigi kliling smua tempat dari kampung ke kampung untuk kastau Brita Baik deng kas sembu orang-orang sakit. ");
INSERT INTO pmy_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Waktu Herodes yang printa daera Galilea, de dengar smua hal yang Yesus su buat, de bingung skali karna ada orang yang kastau kalo Yohanes yang tukang baptis, yang dulu su mati, skarang de hidup kembali. ");
INSERT INTO pmy_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Juga ada yang kastau kalo Elia su muncul lagi, baru juga ada yang bilang kalo satu dari nabi-nabi dulu su hidup kembali. ");
INSERT INTO pmy_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Tapi Herodes bilang, “Yohanes pu kepala sa su suru orang potong, orang ini sapa ka? Sa su dengar crita banyak tentang Dia.” Jadi Herodes de usaha mo ketemu deng Yesus. ");
INSERT INTO pmy_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Waktu utusan-utusan dong kembali ke Yesus, dong crita smua yang dong su bikin. Yesus bawa dong sendiri saja pigi ke dekat Kota Betsaida. ");
INSERT INTO pmy_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Tapi orang banyak su tau, trus dong ikut Dia. Yesus trima deng bicara sama dong tentang Allah pu Krajaan. De juga kas sembu orang-orang yang sakit di tenga dong. ");
INSERT INTO pmy_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Pas waktu su mo malam, De pu duablas murid datang sama Yesus baru bilang, “Bapa tempat ini sunyi, suru dong pigi ke kampung-kampung deng tempat-tempat dekat sini, supaya dong dapat makan deng tempat buat tidur.” ");
INSERT INTO pmy_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Tapi Yesus bilang ke dorang, “Kam yang harus kasi dong makan!” Dong jawab, “Yang tong punya hanya lima roti deng dua ikan, kalo tong yang kasi makan brarti tong musti pigi bli makanan untuk smua orang banyak ini.” ");
INSERT INTO pmy_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Dong bilang begitu karna laki-laki saja kira-kira 5.000 orang. Trus Yesus bilang sama De pu murid-murid, “Suru dong duduk klompok-klompok, kira-kira satu klompok 50 orang.” ");
INSERT INTO pmy_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Murid-murid dong suru orang-orang bikin sperti apa yang Yesus bilang. ");
INSERT INTO pmy_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Habis itu Yesus ambil lima roti deng dua ikan itu, baru liat ke langit, doa syukur ke Allah, trus pata-pata roti baru kasi sama De pu murid-murid, trus dong bagi-bagi sama orang banyak itu. ");
INSERT INTO pmy_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Dong smua makan sampe kenyang. Habis itu dong kumpul roti yang lebi, sampe 12 loyang. ");
INSERT INTO pmy_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Satu kali waktu Yesus ada doa sendiri, De pu murid-murid dong datang ke Dia. Trus De tanya sama dong, “Orang banyak dong bilang Sa ni sapa?” ");
INSERT INTO pmy_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Dong jawab, “Ada yang bilang Yohanes Tukang Baptis, ada yang bilang Elia, ada juga yang bilang, kalo satu dari nabi-nabi yang skarang su hidup kembali.” ");
INSERT INTO pmy_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yesus tanya ke dong, “Tapi kam bilang, Sa ni sapa?” Petrus jawab, “Raja Yang Allah Pili, yang Allah su janji.” ");
INSERT INTO pmy_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Trus Yesus larang dong deng kras, supaya jang kastau hal itu ke sapa-sapa. ");
INSERT INTO pmy_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yesus bilang lagi sama De pu murid-murid, “Sa Anak Manusia harus dapa siksa banyak deng dapa tolak dari orang Yahudi pu tua-tua deng guru-guru agama sama imam-imam kepala, trus dapa bunu, tapi hari ketiga Allah kas hidup kembali.” ");
INSERT INTO pmy_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Habis itu Yesus bilang sama dong smua, “Orang yang mo ikut Saya, de tra bole ikut de pu mau, trus harus pikul de pu salib stiap hari deng ikut Saya. ");
INSERT INTO pmy_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Karna sapa saja yang mo kas slamat de pu hidup, de tra dapat hidup yang trada akir. Tapi orang yang kasi de pu hidup untuk Saya, de yang nanti slamat. ");
INSERT INTO pmy_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ada untung ka kalo satu orang de dapat smua harta di dunia ini, tapi de sendiri tra dapat hidup yang trada akir. ");
INSERT INTO pmy_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Karna sapa saja yang malu akui Sa deng Sa pu ajaran, Sa Anak Manusia juga nanti malu karna orang itu, waktu Sa datang deng cahaya yang penu kuasa dari Sa pu Bapa, juga deng Allah pu malaikat-malaikat! ");
INSERT INTO pmy_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Yang sa bilang ini benar: Dari tenga-tenga kam yang hadir disini ada yang trakan mati sampe dong liat Allah pu Krajaan di bumi.” ");
INSERT INTO pmy_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Habis Yesus kas ajar tentang smua itu, kira-kira lewat dlapan hari begitu, Yesus bawa Petrus, Yohanes, sama Yakobus, naik ke gunung satu untuk pigi doa. ");
INSERT INTO pmy_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Waktu Yesus De doa disitu, De pu muka bruba kliatan lain trus De pu pakean jadi puti trang skali. ");
INSERT INTO pmy_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Tiba-tiba ada dua orang muncul, dong bicara deng Yesus, dong tu Musa deng Elia. ");
INSERT INTO pmy_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Dong kliatan ada cahaya trang dari surga. Dong dua bicara sama Yesus tentang De su mo mati di Yerusalem sperti yang Allah pu utusan dong bilang dulu. ");
INSERT INTO pmy_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Waktu itu, Petrus deng de pu teman-teman dong su tidur sono. Begitu dong bangun, dong kaget liat Yesus De trang skali trus De ada bediri deng dua orang itu. ");
INSERT INTO pmy_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Habis itu pas dua orang itu mo pigi kas tinggal Yesus, Petrus de bilang sama Yesus begini, “Bapa Guru! Snang skali tong ada disini. Lebi baik tong kas bediri tiga kema: satu untuk Bapa Guru, satu untuk Musa baru satu untuk Elia.” Tapi Petrus de tra tau apa yang de bicara itu. ");
INSERT INTO pmy_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Waktu Petrus masi bicara begitu, awan puti datang tutup dong. Waktu dong masuk awan itu, dong takut skali. ");
INSERT INTO pmy_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Trus ada suara dari awan itu bilang, “Ini Sa pu Anak yang Sa pili, kam harus dengar Dia.” ");
INSERT INTO pmy_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Habis dong dengar suara itu, dong liat Yesus sendiri saja yang bediri disitu. Yesus pu murid-murid dong kas diam smua itu, trus waktu itu dong tra kastau sama sapa-sapa apa yang dong liat. ");
INSERT INTO pmy_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","De pu besok begini, Yesus deng murid-murid tiga turun dari gunung itu, banyak orang datang rame-rame ketemu Yesus. ");
INSERT INTO pmy_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Begini satu orang dari orang banyak itu bicara deng suara kuat, “Bapa Guru, sa minta tolong liat sa pu anak, karna sa pu anak satu ini saja. ");
INSERT INTO pmy_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Setan biasa kalo srang, de batariak-batariak badan gementar goyang-goyang sampe de mulut busa kluar. Setan itu siksa kas rusak de pu badan trus tra mau kas tinggal dia. ");
INSERT INTO pmy_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Sa su minta Bapa pu murid-murid supaya dong usir setan itu, tapi dong tra bisa.” ");
INSERT INTO pmy_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jadi Yesus bilang, “Kam memang orang-orang yang tra percaya deng tra ikut yang benar, mo sampe kapan Sa harus tinggal di tenga kam deng sabar? Bawa ko pu anak kemari!” ");
INSERT INTO pmy_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Waktu anak itu mo dekat Yesus, setan banting de ke tana deng gementar trus de pu badan kejang-kejang. Tapi Yesus printa setan kluar trus kas sembu anak itu, trus kasi anak itu kembali sama de pu bapa. ");
INSERT INTO pmy_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Smua orang heran liat Allah De pu kuasa yang besar. 9:43b-45 Orang-orang dong masi heran liat smua yang De buat, Yesus bilang sama De pu murid-murid, ");
INSERT INTO pmy_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Kam dengar baik, jang kam lupa yang Sa bilang ini: Sa Anak Manusia nanti dapa kasi ke dalam tangan manusia.” ");
INSERT INTO pmy_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Dong tra mngerti kata-kata itu, karna Allah tutup arti kata itu. Jadi dong tra tau, trus dong tra brani tanya kata itu pu arti sama Yesus. ");
INSERT INTO pmy_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Trus ada baku ribut di tenga Yesus pu murid-murid tentang sapa yang paling penting dari dorang. ");
INSERT INTO pmy_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Tapi Yesus su tau yang dong pikir, jadi De ambil anak kecil satu baru kas bediri di samping Dia. ");
INSERT INTO pmy_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Trus bilang sama dorang, “Sapa saja yang trima anak ini karna de percaya dalam Sa pu nama, itu de trima Saya. Trus sapa yang trima Saya, itu de trima De yang su utus Saya. Karna sapa yang paling kecil dari kam, de yang paling besar.” ");
INSERT INTO pmy_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Begini Yohanes de bilang sama Yesus, “Guru, tong liat satu orang de usir setan pake Guru pu nama. Karna de tra ikut tong jadi tong larang dia!” ");
INSERT INTO pmy_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Trus Yesus bilang, “Jang kam larang dia, karna sapa saja yang tra mlawan kitong, de tu tong pu teman.” ");
INSERT INTO pmy_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Satu hari, waktu mo dekat Yesus trangkat ke surga, Yesus nekat deng jalan pigi ke Kota Yerusalem. ");
INSERT INTO pmy_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Jadi De suru orang pigi duluan. Dong pigi, trus masuk ke kampung satu di daera Samaria buat kas siap smua yang Yesus perlu. ");
INSERT INTO pmy_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Tapi orang-orang di kampung tu tra mau trima Yesus, karna dong tau kalo Yesus mo pigi ke Yerusalem. ");
INSERT INTO pmy_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Pas waktu Yesus pu murid Yakobus deng Yohanes dong tau itu, dong bilang, “Tuhan, bagemana Tuhan mau ka, tong minta api turun dari surga supaya kas hilang orang-orang ini?” ");
INSERT INTO pmy_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yesus balik trus mara dong. ");
INSERT INTO pmy_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Habis itu dong pigi ke kampung yang lain. ");
INSERT INTO pmy_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Waktu Yesus deng De pu murid-murid dong masi lanjut jalan, ada satu orang de bilang sama Yesus, “Sa mo ikut Bapa kemana saja Bapa mo pigi.” ");
INSERT INTO pmy_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesus bilang ke dia, “Serigala ada tempat untuk tinggal, burung juga ada sarang, tapi Sa Anak Manusia trada tempat untuk taru kepala.” ");
INSERT INTO pmy_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Trus Yesus bilang satu orang yang lain, “Mari ko ikut Saya!” Tapi orang itu de bilang, “Tuhan, kas ijin sa pulang urus sa pu bapa sampe sa pu bapa mati dulu.” ");
INSERT INTO pmy_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Tapi Yesus bilang sama dia, “Kas biar orang mati kubur orang mati. Tapi ko, pigi kastau brita tentang Allah pu Krajaan.” ");
INSERT INTO pmy_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Trus satu orang lain lagi bilang, “Bapa, sa mo ikut Bapa tapi sa mo ijin pigi kastau sa pu kluarga dong dulu.” ");
INSERT INTO pmy_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Tapi Yesus bilang sama orang itu, “Orang yang su siap mo cangkul tana tapi de balik liat ke blakang, de tra pantas jadi Allah pu orang di De pu Krajaan.” ");
INSERT INTO pmy_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Habis itu Tuhan Yesus pili lagi murid-murid 70 orang, trus De mo utus dong dua-dua orang untuk mo pigi lebi dulu ke smua tempat deng kota yang nanti De mo pigi. ");
INSERT INTO pmy_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","De bilang sama dong, “Bua yang siap panen ada banyak. Tapi sdikit orang yang mo panen itu. Jadi, minta ke Bapa yang punya itu smua, untuk kirim orang-orang yang kerja panen itu. ");
INSERT INTO pmy_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Skarang kam pigi deng ingat, Sa utus kam sperti anak domba ke tenga-tenga serigala. ");
INSERT INTO pmy_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Kalo pigi jang kam bawa tas ato dompet ato sendal ganti. Jang kam buang-buang waktu mo bicara banyak sama orang di jalan. ");
INSERT INTO pmy_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Kalo kam mo masuk ruma satu, bilang dulu begini, ‘Tuhan kasi damai sama smua orang dalam ruma ini.’ ");
INSERT INTO pmy_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Trus kalo disitu ada yang snang damai, brarti kam pu damai itu tetap sama dia. Tapi kalo trada, kam pu damai tu kembali sama kam. ");
INSERT INTO pmy_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Trus kalo ada orang yang su trima kam, tinggal di ruma itu saja. Makan deng minum apa yang dong kasi sama kam, karna orang yang kerja de pantas trima de pu bagian. Jang kam pinda-pinda ruma. ");
INSERT INTO pmy_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Kalo kam masuk kota satu trus kam dapa trima deng baik, makan saja apa yang dong kas siap untuk kam. ");
INSERT INTO pmy_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Kas sembu orang-orang sakit di kota itu deng kastau dong, ‘Allah pu Krajaan su dekat ke kam!’ ");
INSERT INTO pmy_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Tapi kalo kam masuk kota satu trus disitu dong tra trima kam, pigi ke jalan-jalan besar di kota itu baru kam kastau deng suara kras begini, ");
INSERT INTO pmy_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Mo debu dari kam pu kota yang tempel di tong pu kaki, tong kebas kas bersi, supaya itu jadi tanda kalo nanti kam dapa hukum. Juga kam harus tau kalo Allah pu Krajaan su dekat!’ ");
INSERT INTO pmy_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Sa kastau kam, pas hari trakir, Kota Sodom nanti dapa hukum lebi ringan dari kota itu!” ");
INSERT INTO pmy_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Yesus bilang lagi, “Claka skali orang-orang di Kota Korazim deng Kota Betsaida! Karna kalo di Kota Tirus deng Sidon tanda-tanda luar biasa jadi sperti yang su jadi di tenga-tenga kam, pasti orang-orang disana langsung dong pake pakean duka deng duduk di atas abu, itu karna dong rasa sala deng dong pu dosa-dosa. ");
INSERT INTO pmy_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Tapi nanti pas waktu hukuman trakir, orang-orang jahat di kota dua itu nanti dapa hukum lebi ringan dari kam. ");
INSERT INTO pmy_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Juga orang-orang di Kapernaum! Kam pikir nanti kam dapa kas naik sampe ke surga? Trakan! Kam nanti dapa buang ke neraka! ");
INSERT INTO pmy_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Sapa saja yang dengar kam, de dengar Saya, trus sapa saja yang tolak kam, de tolak Saya. Juga sapa saja yang su tolak Saya, de tolak Dia yang su utus Saya.” ");
INSERT INTO pmy_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tra lama begini 70 murid-murid yang dapa utus itu dong kembali deng snang skali trus kastau sama Yesus, “Tuhan, mo setan-setan juga dong smua tunduk waktu tong usir dalam Tuhan pu nama.” ");
INSERT INTO pmy_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Trus Yesus bilang sama dorang, “Sa liat Iblis jatu dari langit sperti kilat. ");
INSERT INTO pmy_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Kam tau to! Sa su kasi kam kuasa untuk injak ular deng kalajengking, juga untuk kas kala Iblis pu kuasa, sampe trada yang bisa kas claka kam. ");
INSERT INTO pmy_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Tapi jang kam rasa snang karna setan-setan itu tunduk sama kam, lebi baik kam rasa snang skali karna Tuhan su daftar kam pu nama di surga.” ");
INSERT INTO pmy_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Waktu itu juga Yesus pu hati snang skali karna penu deng Roh Allah trus De bicara begini, “Sa kas naik syukur sama Bapa, Tuhan yang punya langit deng bumi! Karna smua tentang Allah printa jadi Raja, Bapa kas tunjuk itu untuk orang-orang biasa, tapi Bapa kas rahasia dari orang-orang yang pu ilmu deng orang yang pintar, sperti itu yang Bapa snang. ");
INSERT INTO pmy_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Smua-smua Bapa su kas percaya sama Saya. Trada orang yang knal Anak, cuma Bapa. Trus trada yang knal Bapa, cuma Anak deng orang yang Anak De pili untuk kastau tentang Bapa.” ");
INSERT INTO pmy_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Habis itu Yesus balik bilang ke De pu murid-murid dong saja, “Untung skali karna su liat apa yang kam liat skarang ini. ");
INSERT INTO pmy_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Sa bilang kam, jaman dulu banyak raja-raja deng nabi-nabi, dong mau skali liat deng dengar apa yang kam su liat deng dengar, tapi dong tra bisa liat deng dengar itu.” ");
INSERT INTO pmy_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Satu kali begini guru agama satu, bediri mo coba Yesus, de bilang, “Bapa Guru, sa harus bikin apa supaya sa bisa hidup trus sampe trada akir?” ");
INSERT INTO pmy_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesus jawab, “Apa yang ada tatulis di hukum Musa? Apa yang Bapa baca disitu?” ");
INSERT INTO pmy_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Orang itu de jawab, “Sayang ko pu Tuhan Allah deng spenu hati, deng smua ko pu hidup, deng smua tenaga, deng juga smua yang ko pikir, juga sayang orang lain sama sperti ko sayang ko pu diri sendiri.” ");
INSERT INTO pmy_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesus bilang, “Itu betul, buat begitu supaya ko pu hidup trus deng Allah.” ");
INSERT INTO pmy_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Tapi orang itu mo bela diri deng bilang begini, “Sapa orang lain itu?” ");
INSERT INTO pmy_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesus jawab, “Ada pace satu de turun dari Yerusalem ke Yerikho. Di tenga jalan de dapa srang dari orang jahat, dong rampas de pu pakean deng de pu barang-barang smua, trus de dapa pukul sampe de hampir mo mati baru dong kas tinggal de di jalan. ");
INSERT INTO pmy_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Pas begini ada satu imam de jalan dari situ, de liat orang itu tapi de pinda ke sebla jalan deng pigi trus. ");
INSERT INTO pmy_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Begitu juga deng orang satu dari suku Lewi de jalan disitu, sampe di tempat itu de liat tapi de juga pinda ke sebla jalan deng pigi trus. ");
INSERT INTO pmy_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Tapi tra lama satu orang Samaria mo pigi lewat dari tempat itu. Waktu de liat orang itu, de rasa kasian skali sama orang itu. ");
INSERT INTO pmy_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","De pigi dekat orang itu, trus kas bersi de pu luka-luka kas obat pake anggur deng minyak. Trus de tutup de pu luka-luka habis tu kas naik de ke atas de pu kledai trus bawa de ke tempat mnginap deng urus orang itu. ");
INSERT INTO pmy_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Begini besok, orang yang tolong tu kasi uang perak dua deng bilang sama yang pu tempat itu, ‘Jaga deng urus dia. Kalo ada ongkos lain, nanti sa kasi ko waktu sa kembali.’ ” ");
INSERT INTO pmy_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesus tutup crita deng tanya, “Ko pikir sapa dari tiga orang itu, yang sayang sama orang lain yang dapa curi itu?” ");
INSERT INTO pmy_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Guru agama de jawab, “Orang yang su buat baik sama dia.” Trus Yesus bilang, “Ko pigi baru ko harus buat sperti itu juga.” ");
INSERT INTO pmy_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Begini Yesus dong lanjut jalan, dong masuk di satu kampung. Disitu ada satu prempuan yang undang Yesus ke de pu ruma, de pu nama Marta. ");
INSERT INTO pmy_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta de pu ade prempuan pu nama Maria. De pu ade ni trus duduk dekat Tuhan Yesus pu kaki mo dengar Yesus pu kata-kata. ");
INSERT INTO pmy_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Tapi Marta sibuk kerja kas siap smua. Begini Marta datang sama Yesus deng bilang, “Tuhan ini tra liat ka, sa pu ade kas biar sa kerja smua sendiri. Coba suru de bantu sa dulu.” ");
INSERT INTO pmy_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Tapi Yesus jawab de, “Marta, Marta, ko sibuk kerja deng kuatir hal yang banyak. ");
INSERT INTO pmy_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Tapi hanya satu yang penting! Maria su pili yang baik, itu trakan dapa ambil dari dia.” ");
INSERT INTO pmy_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Satu kali Yesus pigi doa di tempat satu. Habis doa, De pu murid satu bilang, “Tuhan, kas ajar tong doa sperti Yohanes kas ajar de pu murid-murid dong doa.” ");
INSERT INTO pmy_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesus De jawab dong, “Kalo kam mo doa, bilang, ‘Biar Bapa pu nama yang suci dapa kas tinggi, Bapa pu Krajaan datang di bumi. ");
INSERT INTO pmy_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Kasi tong makanan yang cukup stiap hari. ");
INSERT INTO pmy_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Kas ampun tong pu dosa-dosa sperti tong juga kas ampun orang yang sala sama kitong. Jang kas biar tong bikin dosa kalo dapa uji.’ ” ");
INSERT INTO pmy_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Trus Yesus bilang dorang, “Kalo satu dari kam pu teman, trus tenga malam kam pigi ke kam pu teman itu baru bilang, ‘Teman sa minta roti tiga, nanti sa ganti. ");
INSERT INTO pmy_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Karna sa pu teman satu ni baru datang dari jau de singga di ruma. Tapi sa trada apapa buat kasi de makan.’ ");
INSERT INTO pmy_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Bagemana kalo ko pu teman bilang, ‘Jang ganggu saya, pintu su tutup, sa deng sa pu anana su tidur. Sa tra bisa bangun kasi ko.’ ");
INSERT INTO pmy_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Sa kastau kam: Memang, biar de tu ko pu teman, mungkin tadi de tra mau bangun kasi yang ko minta, tapi karna ko tra malu minta de trus-trus jadi de bangun deng kasi apa yang ko perlu. ");
INSERT INTO pmy_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Jadi Sa kastau kam: Minta trus sama Allah supaya kam bisa trima; cari dari Allah supaya kam bisa dapat; toki pintu supaya Allah buka kam pintu. ");
INSERT INTO pmy_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Karna orang yang minta, de trima; orang yang cari, de dapat; orang yang toki pintu, untuk de pintu tabuka. ");
INSERT INTO pmy_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Bapa mana yang mo kasi ular bisa, kalo de pu anak minta ikan? ");
INSERT INTO pmy_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ato kasi kalajengking, kalo de pu anak minta telur? ");
INSERT INTO pmy_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Jadi kalo kam yang pu sifat jahat saja tau kasi yang baik sama kam pu anana, lebi lagi Bapa di surga! De pasti kasi kam Roh Allah untuk sapa saja yang minta.” ");
INSERT INTO pmy_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Pas satu kali begini Yesus De usir setan kluar dari satu orang yang setan itu bikin sampe de bisu. Habis setan itu kluar, orang itu langsung bisa bicara lagi baru orang banyak dong heran. ");
INSERT INTO pmy_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Tapi ada dari tenga dong yang bilang, “De usir setan pake kuasa Beelzebul, setan pu bos.” ");
INSERT INTO pmy_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ada juga orang-orang yang mo coba Yesus jadi dong minta De buat satu tanda kalo De dari surga. ");
INSERT INTO pmy_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Tapi Yesus tau apa yang dong pikir trus bilang ke dong, “Stiap negara yang baku musu pasti hancur. Trus satu kluarga yang baku musu pasti hancur. ");
INSERT INTO pmy_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Jadi kalo Iblis juga dong baku lawan deng dong sendiri, bagemana krajaan itu bisa tahan? Karna kam bilang kalo Sa usir setan pake Beelzebul pu kuasa. ");
INSERT INTO pmy_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Kalo Sa usir setan pake Beelzebul pu kuasa, kam pu murid-murid usir setan-setan itu pake sapa pu kuasa? Jadi biar kam pu murid-murid yang kas tunjuk apa yang kam tudu tu sala! ");
INSERT INTO pmy_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Tapi Sa usir setan pake Allah pu kuasa, trus ini kas bukti kalo Allah pu Krajaan su datang ke kam. ");
INSERT INTO pmy_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Kalo satu orang yang kuat deng senjata lengkap jaga de pu ruma, pasti de pu milik smua aman. ");
INSERT INTO pmy_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Tapi kalo ada orang yang lebi kuat datang srang trus kas kala dia, orang itu nanti rampas de pu senjata lengkap yang de kas andal itu trus pigi bagi-bagi smua barang-barang yang de rampas. ");
INSERT INTO pmy_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Orang yang tra sama-sama Saya, su jlas de lawan Saya, trus orang yang tra mo kerja untuk Saya, su jlas de kas rusak Sa pu kerja!” ");
INSERT INTO pmy_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Trus Yesus bilang, “Kalo setan kluar dari satu orang, roh itu de pigi ke tempat-tempat yang kosong cari tempat untuk de tinggal, tapi de tra dapat. Jadi de bilang, ‘Sa mo kembali ke sa pu tempat yang dulu sa tinggal.’ ");
INSERT INTO pmy_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Jadi waktu de kembali, de liat orang itu sperti tempat kosong yang bersi deng rapi. ");
INSERT INTO pmy_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Trus de pigi bawa tuju roh yang lebi jahat dari dia, dong masuk ke orang itu baru tinggal. Pasti orang itu pu hidup lebi rusak daripada yang dulu.” ");
INSERT INTO pmy_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Waktu Yesus masi bicara, satu prempuan de angkat suara dari tenga-tenga orang banyak itu, “Sunggu! Prempuan yang su lahir deng kas susu Ko, de tu untung skali.” ");
INSERT INTO pmy_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Tapi Yesus De bilang, “Yang paling untung skali tu orang yang mo dengar Allah pu kata-kata trus mo bikin itu.” ");
INSERT INTO pmy_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Orang banyak datang krumun trus Yesus De bilang, “Orang-orang jaman ini tu orang jahat. Kam minta satu tanda heran. Tapi sama kam Sa tra kasi satu tanda juga, hanya tanda Nabi Yunus. ");
INSERT INTO pmy_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Sperti Yunus de jadi tanda untuk orang-orang Niniwe, begitu juga Sa Anak Manusia nanti jadi tanda untuk orang-orang jaman ini. ");
INSERT INTO pmy_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Waktu trakir, ratu dari negri slatan de nanti bangkit trus adili orang-orang jaman ini. Karna ratu itu de datang dari jau untuk dengar Salomo pu ajaran yang bikin mngerti deng baik.” Trus Yesus lanjut bicara, “Liat! Yang lebi besar dari Salomo ada disini! ");
INSERT INTO pmy_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Jadi waktu trakir, orang-orang Niniwe nanti bangkit trus adili kam orang-orang jaman ini, karna orang-orang Niniwe itu dong tobat dari dong pu dosa-dosa waktu dong dengar yang Yunus kastau. Liat! Yang lebi besar dari Yunus ada disini.” ");
INSERT INTO pmy_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Trus Yesus bilang satu conto sama orang banyak, “Trada orang yang pasang plita trus taru di tempat sembunyi ato di bawa loyang. Tapi de pasti taru plita di tempat yang tinggi, supaya smua orang yang masuk dalam ruma bisa liat trang itu. ");
INSERT INTO pmy_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ko pu mata itu plita untuk ko pu diri. Kalo ko pu mata trang, ko pu diri juga trang, tapi kalo ko pu mata glap, ko pu diri juga glap. ");
INSERT INTO pmy_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Jadi, jaga supaya ko pu trang jang de jadi glap. ");
INSERT INTO pmy_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kalo ko pu diri trang smua, trada yang glap, deng begitu smua itu nanti trang sama sperti kalo cahaya plita kas trang ko.” ");
INSERT INTO pmy_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Waktu Yesus slesai bicara, ada satu orang dari orang Farisi de ajak Yesus makan di de pu ruma. Jadi Yesus pigi makan disitu. ");
INSERT INTO pmy_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Orang Farisi itu heran liat kalo Yesus tra cuci De pu tangan sperti dong pu aturan, seblum makan. ");
INSERT INTO pmy_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Tapi Tuhan Yesus bicara sama dia, “Kam orang-orang Farisi, hanya tau kas bersi piring deng mangkok pu sebla luar. Tapi kam pu hati penu deng pikiran jahat deng rampas orang pu harta. ");
INSERT INTO pmy_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Kam orang-orang bodo! Tra tau ka kalo De yang bikin kam pu bagian luar, De juga yang bikin bagian dalam kam pu hati. ");
INSERT INTO pmy_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Kasi sama orang-orang miskin deng hati yang baik, deng begitu kam pu hidup smua jadi bersi. ");
INSERT INTO pmy_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Kam claka skali orang-orang Farisi! Kam pu hasil kebun sampe tanaman bumbu macam selasi, inggu, deng smua macam sayur-sayur juga kam kasi de pu seperspulu sama Allah, tapi untuk bikin yang betul sama orang lain deng sayang sama Allah kam tra bikin. Itu yang harus kam bikin, trus jang lupa bikin yang lain juga. ");
INSERT INTO pmy_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Claka skali kam orang-orang Farisi, karna kam mau dapat tempat yang paling depan di tempat ibada trus kam mau skali dapat hormat di pasar. ");
INSERT INTO pmy_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Kam claka skali karna kam sama deng kubur yang tra kliatan sperti kubur, orang-orang tra sadar kalo dong ada injak di atas kubur.” ");
INSERT INTO pmy_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Satu orang dari guru-guru agama itu bilang sama Yesus, “Bapa Guru pu kata-kata begitu sperti hina tong juga.” ");
INSERT INTO pmy_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Trus Yesus jawab, “Kam juga claka skali guru-guru agama! Kam kasi orang lain beban yang tra bisa dong pikul, tapi kam sendiri tra mau tolong orang untuk ikut aturan itu mo sdikit juga. ");
INSERT INTO pmy_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Claka skali kam! Kam bikin kubur bagus-bagus untuk nabi-nabi, biar dong dapa bunu dari kam pu nene moyang sendiri. ");
INSERT INTO pmy_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Deng begitu kam akui kalo kam stuju smua yang kam pu nene moyang dong bikin, karna dong su bunu nabi trus kam yang bikin dong pu kuburan. ");
INSERT INTO pmy_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Gara-gara itu Allah yang tau smua hal bilang tentang kam begini, ‘Sa nanti utus nabi-nabi deng utusan dong untuk pigi ke orang Israel, tapi nanti ada yang orang Israel dong siksa trus yang lain lagi dapa bunu!’ ");
INSERT INTO pmy_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Jadi Allah mo hukum kam orang-orang jaman ini, karna kam pu nene moyang dong su bunu nabi-nabi, mulai dari dunia ini jadi sampe skarang. ");
INSERT INTO pmy_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Mulai Habel dapa bunu sampe waktu Zakharia de dapa bunu di Ruma Allah itu di tenga dari tempat bakar korban deng Tempat Suci. Dengar ini! Orang jaman ini nanti dapa hukum karna smua nabi itu. ");
INSERT INTO pmy_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Claka kam, guru-guru agama! Kam simpan kunci yang bisa buka pintu untuk tau Allah pu mau, tapi kam tra mo masuk ke dalam. Mala kam bikin orang lain yang mo masuk jadi susa untuk masuk.” ");
INSERT INTO pmy_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Waktu Yesus kas tinggal ruma itu, guru-guru agama deng orang-orang Farisi dong mulai tra skali sama Yesus, dong juga tanya-tanya untuk mo pancing Dia. ");
INSERT INTO pmy_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Dong pu rencana mo jrat Dia. Dong usaha untuk cari Yesus pu sala waktu De ada bicara. ");
INSERT INTO pmy_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Waktu itu, ada ribuan orang banyak su krumun, sampe dong baku dempet-dempet. Trus Yesus mulai kas ajar pertama sama De pu murid-murid dong, De bilang begini, “Hati-hati, jaga kam pu diri! Jang sampe kam kena ragi dari klompok Farisi, karna dong mo kas pengaru kam deng dong pu klakuan yang pura-pura baik. ");
INSERT INTO pmy_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Trada rahasia yang nanti tra dapa buka, juga trada yang tasembunyi yang nanti tra dapa liat. ");
INSERT INTO pmy_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Karna apa yang kam bicara dalam glap nanti pasti orang dengar di dalam trang, juga apa yang kam bisik di orang pu tlinga dalam kamar pasti nanti dapa kastau dari atas ruma supaya orang banyak tau. ");
INSERT INTO pmy_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Teman-teman, ingat eh! Jang kam takut sama dong yang cuma bunu kam pu badan tapi tra bisa bikin lebi dari itu. ");
INSERT INTO pmy_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Sa mo kastau sama kam sapa yang harus kam takut. Kam harus takut sama Tuhan, Tuhan pu kuasa bukan cuma bunu tapi juga pu kuasa lagi untuk lempar orang ke dalam neraka. Memang yang kam harus takut itu Dia! ");
INSERT INTO pmy_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Coba kam pikir! Lima ekor burung pipit jual deng harga dua uang koin yang pu nilai paling kecil. Biar begitu, trada satu ekor yang Allah lupa itu. ");
INSERT INTO pmy_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Jadi kam jang takut, kam jau lebi penting dari banyak burung pipit itu. Sampe rambut di kam pu kepala Tuhan su tau de pu jumla. ");
INSERT INTO pmy_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Sa kastau kam, sapa yang mngaku knal Sa depan orang-orang, Sa Anak Manusia juga nanti mngaku knal de di depan Allah pu malaikat-malaikat. ");
INSERT INTO pmy_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Juga sapa yang pura-pura tra knal Sa di depan orang-orang, Sa juga pura-pura tra knal de di depan Allah pu malaikat-malaikat. ");
INSERT INTO pmy_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Stiap orang yang bilang satu hal yang mlawan Sa Anak Manusia, nanti bisa dapa kas ampun. Tapi sapa saja yang hina Roh Allah, de trakan dapa kas ampun. ");
INSERT INTO pmy_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Waktu orang tangkap deng bawa kam ke depan pemimpin di tempat-tempat ibada orang Yahudi, ato ke pejabat pemrinta yang pu kuasa untuk adili, kam jang takut apa yang harus kam bicara ato bagemana kam bela kam pu diri. ");
INSERT INTO pmy_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Karna pas waktu itu Roh Allah kas ajar kam apa yang harus kam bicara.” ");
INSERT INTO pmy_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Begini satu orang dari tenga orang banyak itu bilang sama Yesus, “Bapa Guru, tolong bilang sa pu kaka untuk bagi deng sa harta yang tong pu orang tua kas tinggal.” ");
INSERT INTO pmy_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesus bilang, “Sodara, sapa yang angkat Sa jadi hakim ato tukang bagi warisan untuk kam dua?” ");
INSERT INTO pmy_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Yesus bilang lagi sama dong smua, “Hati-hati! Jaga jang sampe kam mata besar uang. Karna manusia pu hidup tra bangun di atas de pu harta yang banyak.” ");
INSERT INTO pmy_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Trus Yesus crita satu conto begini, “Ada orang kaya satu, de dapat hasil yang banyak dari tana itu. ");
INSERT INTO pmy_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Orang kaya itu pikir dalam hati, ‘Su tra cukup tempat untuk simpan sa pu hasil tana, skarang sa mo buat bagemana?’ ");
INSERT INTO pmy_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Trus de pikir dalam de pu hati, ‘Sa buat begini saja, sa bongkar tempat simpan gandum ini baru bikin yang lebi besar, tempat yang bisa simpan biji gandum deng barang-barang lain. ");
INSERT INTO pmy_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Habis tu sa nanti bilang ke sa pu diri: Sa untung skali! Sa pu smua yang baik yang sa perlu untuk sa pu hidup, taun-taun datang ni sa pu harta tra habis. Jadi skarang sa mo istirahat, makan, minum deng snang-snang trus!’ ");
INSERT INTO pmy_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Tapi Allah bilang, ‘He orang bodok! Malam ini juga ko mati, trus sapa yang nanti dapat ko pu harta smua yang ko su kumpul tu?’ ");
INSERT INTO pmy_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Begitu suda kalo orang mo usaha jadi kaya untuk de pu diri, tapi tra mau usaha jadi kaya di mata Allah.” ");
INSERT INTO pmy_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Trus Yesus De bilang sama De pu murid begini, “Itu yang Sa bilang kam, jang kam kuatir deng kam pu hidup, nanti kam makan apa, ato kuatir tentang badan, apa yang nanti kam pake. ");
INSERT INTO pmy_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Karna hidup tu lebi penting dari makanan juga badan lebi penting dari pakean. ");
INSERT INTO pmy_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Coba kam liat burung-burung gagak! Dong tra tau tanam, tra tau panen, juga tra punya gudang ato tempat simpan makanan. Tapi Allah kas makan dorang. Kam jau lebi penting dari burung-burung itu! ");
INSERT INTO pmy_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Kalo kam kuatir deng hal-hal itu, apa kam pu kuatir itu bisa kas panjang kam pu umur biar mo sdikit? Pasti tra bisa to! ");
INSERT INTO pmy_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Kalo hal paling kecil saja tra bisa kam buat, jadi hal apa saja kam tra usa kuatir! ");
INSERT INTO pmy_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Coba kam liat bagemana bunga-bunga liar de tumbu, bunga-bunga itu dong tumbu tra kerja juga dong tra bikin dong pu pakean. Sa bilang kam, Raja Salomo yang paling kaya saja de tra pake pakean yang bagus macam bunga-bunga liar itu! ");
INSERT INTO pmy_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Jadi kalo rumput yang hari ini de tumbu trus besok dapa buang dalam api saja, Allah tetap bikin de bagus, lebi lagi deng kam pu hidup. Tapi kam ini masi tra percaya! ");
INSERT INTO pmy_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Jadi jang kam kuatir deng pikir banyak tentang apa yang nanti kam mo makan ato minum. ");
INSERT INTO pmy_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Orang-orang yang tra knal Allah yang cari hal-hal sperti itu. Tapi kam pu Bapa di surga tau, kalo memang kam perlu smua itu. ");
INSERT INTO pmy_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Tapi kam harus cari Allah pu Krajaan dulu, deng begitu smua itu nanti Allah kasi juga sama kam. ");
INSERT INTO pmy_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Jang kam takut, biar kam itu sperti kumpulan kecil domba! Karna kam pu Bapa snang kalo kam printa sama-sama deng De di De pu Krajaan. ");
INSERT INTO pmy_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Jual saja smua kam pu harta baru kasi uang hasil jual itu sama orang miskin. Deng bikin begitu sama deng kam ada bikin kotak harta yang tra bisa rusak, trus simpan kam pu harta di surga, yang trakan perna habis. Kam pu harta aman disana karna trada pencuri yang mo ke dekat itu trus kakarlak tra bisa kas rusak itu. ");
INSERT INTO pmy_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Karna kam pu harta ada dimana, kam pu hati juga ada disitu.” ");
INSERT INTO pmy_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Trus Yesus bilang lagi begini, “Lebi baik kam siap pake kam pu baju kerja deng pasang kam pu lampu, ");
INSERT INTO pmy_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","sama sperti pesuru-pesuru yang su siap tunggu dong pu tuan pulang dari pesta nika. Supaya kalo de datang toki-toki pintu, pasti nanti dong buka cepat. ");
INSERT INTO pmy_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Waktu dong pu tuan datang trus liat pesuru-pesuru ada jaga-jaga, dong untung skali. Yang Sa bilang ini benar: Tuan itu de ganti pakean biasa sperti pakean pesuru trus kas silakan de pu pesuru-pesuru itu duduk makan, trus de yang layani dorang. ");
INSERT INTO pmy_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Untung skali pesuru-pesuru itu kalo dong pu tuan itu datang tenga malam ato hampir pagi trus liat dong ada siap tunggu dia! ");
INSERT INTO pmy_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ingat conto ini, kalo tuan ruma de tau jam brapa pencuri mo datang, de pasti tra kas biar de pu ruma dong bongkar to. ");
INSERT INTO pmy_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Jadi kam juga harus siap-siap, karna Sa Anak Manusia datang di waktu-waktu yang kam tra kira.” ");
INSERT INTO pmy_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Begini Petrus de bilang, “Tuhan, yang tadi Tuhan bilang itu untuk kitong ato untuk smua orang?” ");
INSERT INTO pmy_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Tuhan De jawab, “Jadi, kalo ada pesuru yang setia deng yang pu cara pikir paling baik, nanti pesuru itu pu tuan angkat de jadi kepala dari pesuru yang lain supaya de yang atur makanan untuk pesuru dong smua. ");
INSERT INTO pmy_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kalo de pu tuan kembali trus liat de ada bikin de pu tugas, untung skali pesuru itu. ");
INSERT INTO pmy_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Yang Sa bilang ini benar: Tuan itu pasti kasi pesuru itu untuk atur de pu harta smua. ");
INSERT INTO pmy_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Tapi kalo pesuru itu jahat pasti de bicara dalam de pu hati, ‘Sa pu tuan ini de lama baru kembali,’ trus de mulai pukul pesuru yang lain, laki-laki deng prempuan, baru de makan deng minum sampe mabuk. ");
INSERT INTO pmy_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Baru de pu tuan kembali di hari deng jam yang de tra kira. Jadi pesuru itu de dapa hajar sampe habis-abis dari de pu tuan trus de dapa buang ke tempat orang-orang yang tra setia sama Allah. ");
INSERT INTO pmy_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Pesuru yang tau de pu tuan pu mau, tapi de tra siap-siap trus tra bikin apa yang de pu tuan mau itu, de nanti dapa rotan. ");
INSERT INTO pmy_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Tapi kalo pesuru yang tra tau de pu tuan pu mau trus bikin yang sala trus de harus dapa pukul, nanti de dapat hukuman yang ringan saja. Karna sapa su dapa kasi dari Allah berkat banyak, de musti banyak kasi juga. Trus sapa yang Tuhan su kas percaya dia, de pu tanggung jawab lebi besar.” ");
INSERT INTO pmy_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Sa datang untuk lempar api ke bumi, jau lebi baik kalo api itu su menyala! ");
INSERT INTO pmy_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Tapi Sa harus trima sengsara yang brat dulu. Sa pu hati susa skali seblum itu de jadi. ");
INSERT INTO pmy_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Kam kira kalo Sa datang untuk bikin damei di bumi? Tra begitu, tra bikin damei tapi bikin orang baku musu. ");
INSERT INTO pmy_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Karna mulai skarang, kalo ada lima orang dalam satu ruma dong mo baku mlawan, tiga lawan dua ato dua lawan tiga. ");
INSERT INTO pmy_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Bapa nanti lawan de pu anak laki-laki ato de pu anak laki-laki lawan de pu bapa. Mama lawan deng anak prempuan trus de pu anak prempuan lawan deng mama. Mama mantu lawan deng de pu mantu prempuan trus mantu prempuan lawan deng de pu mama mantu.” ");
INSERT INTO pmy_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesus bicara sama orang banyak, “Kalo kam liat awan de naik sebla barat, langsung kam bilang itu, ‘Hari ini hujan mo turun,’ baru memang benar hujan turun. ");
INSERT INTO pmy_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Kalo kam rasa angin datang dari bagian slatan trus kam bilang, ‘Hari ini pasti panas,’ baru memang panas. ");
INSERT INTO pmy_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Kam orang yang pura-pura baik! Kam bisa tau cuaca deng liat dari tanda-tanda di langit sama bumi. Baru knapa tanda-tanda jaman ini kam tra bisa nilai?” ");
INSERT INTO pmy_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Trus Yesus bilang, “Knapa ko tra pikir sendiri mana yang benar? ");
INSERT INTO pmy_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Karna, kalo ko deng ko pu lawan pigi ke pengadilan, usaha kas slesai kam pu masala sama orang waktu di jalan. Supaya jang ko dapa paksa ke hakim baru hakim kasi ko ke polisi, trus polisi kas masuk ko dalam penjara. ");
INSERT INTO pmy_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Sa kastau ko, ko pasti trakan kluar sampe ko bayar denda lunas.” ");
INSERT INTO pmy_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Waktu itu ada orang-orang yang datang sama Yesus, trus dong kastau kalo ada orang-orang Galilea yang Gubernur Pilatus de bunu. Dong dapa bunu waktu dong ada kas korban binatang untuk Allah. ");
INSERT INTO pmy_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Dengar begitu Yesus bilang, “Kalo orang-orang Galilea yang dapa bunu sperti itu, kam pikir dong orang yang lebi banyak bikin dosa dari smua orang Galilea yang lain? ");
INSERT INTO pmy_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Tra begitu! Sa kastau kam: Kalo kam tra mo tobat dari kam pu dosa-dosa, kam smua nanti mati kena claka sperti dorang. ");
INSERT INTO pmy_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ato kam masi ingat 18 orang yang mati karna dapa tindis dari bangunan tinggi yang rubu dekat kolam Siloam to? Kam pikir, dong pu dosa lebi besar dari smua orang yang tinggal di Yerusalem ka? ");
INSERT INTO pmy_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Tra begitu! Sa kastau kam lagi, kalo kam tra mo tobat dari kam pu dosa-dosa, kam smua juga pasti mati kena claka sperti dorang.” ");
INSERT INTO pmy_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Trus Yesus crita satu conto begini, “Ada orang satu, de pu kebun anggur trus disitu ada tumbu juga pohon bua ara. Satu hari de datang untuk cari bua di pohon itu, tapi de tra dapat satu bua juga. ");
INSERT INTO pmy_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Jadi orang yang pu kebun tu de bilang sama orang yang jaga kebun itu, ‘Ko liat, slama tiga taun sa datang cari bua di pohon ara ini tapi trada bua. Ko tebang saja pohon ini, percuma de tumbu untuk makan smua dari tana ini.’ ");
INSERT INTO pmy_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Tapi orang yang jaga kebun tu bilang, ‘Bapa, kas tinggal de taun ini lagi, nanti sa skop tana dekat pohon itu deng kas pupuk. ");
INSERT INTO pmy_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Sapa tau taun depan de bisa bua, tapi kalo trada bua juga, baru Bapa bisa tebang.’ ” ");
INSERT INTO pmy_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Pas hari Sabat, Yesus De kas ajar di orang Yahudi dong pu tempat ibada satu. ");
INSERT INTO pmy_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Disitu ada prempuan satu, setan bikin de sakit 18 taun sampe de pu blakang bongkok deng tra bisa bediri lurus. ");
INSERT INTO pmy_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Waktu liat prempuan itu, Yesus De panggil prempuan itu baru bilang, “Mama skarang ko sembu dari ko pu sakit.” ");
INSERT INTO pmy_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Trus Yesus taru tangan di atas prempuan itu, waktu itu juga prempuan de bisa bediri lurus trus de puji-puji Allah. ");
INSERT INTO pmy_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Kepala tempat ibada itu mara karna Yesus kas sembu orang pas di hari Sabat, trus de bilang ke orang banyak, “Ada enam hari to untuk kerja, kam bisa datang di hari-hari itu supaya kam dapa kas sembu, jang kam datang pas hari Sabat.” ");
INSERT INTO pmy_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Dengar begitu, Tuhan jawab, “Kam ini orang-orang yang pura-pura baik, pas hari Sabat kam smua pigi kas lepas kam pu sapi ato kledai dari kandang, trus bawa kluar pigi kas minum. ");
INSERT INTO pmy_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Liat mama ini! De ini turunan Abraham, trus Iblis su ikat de 18 taun. Tra bole ka, kas lepas mama ini di hari Sabat?” ");
INSERT INTO pmy_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesus bicara begitu, smua orang yang lawan Yesus jadi malu skali, tapi smua orang yang lain dong snang liat Yesus bikin hal-hal luar biasa. ");
INSERT INTO pmy_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Habis tu Yesus De tanya, “Sa mo crita, kira-kira Allah pu Krajaan itu sperti apa? Sa kas jlas pake conto apa eh? ");
INSERT INTO pmy_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Allah jadi Raja tu sperti biji sesawi yang kecil skali, yang orang ambil trus pigi tanam di de pu kebun. Lama-lama biji yang tadi dong tanam itu de tumbu trus de jadi pohon, baru burung-burung liar bikin sarang di cabang-cabang di pohon itu.” ");
INSERT INTO pmy_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesus crita lagi, “Deng apa lagi Sa mo kas conto tentang Allah pu Krajaan? ");
INSERT INTO pmy_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Allah jadi raja tu sama sperti ragi. Prempuan satu de ambil ragi sdikit trus de campur deng tepung 30 kilo, bikin sampe adonan naik smua.” ");
INSERT INTO pmy_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Waktu dong jalan pigi ke Yerusalem, Yesus lewat dari kampung ke kampung juga dari kota ke kota deng trus kas ajar ke orang-orang dong. ");
INSERT INTO pmy_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Trus ada satu orang de tanya sama Yesus, “Bapa, hanya sdikit orang saja ka yang nanti dapa kas slamat?” ");
INSERT INTO pmy_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Trus Yesus jawab begini, “Pintu surga tu kecil, jadi kam musti usaha mo masuk dari pintu yang sempit itu. Karna, ingat! Banyak orang coba mo masuk tapi tra bisa. ");
INSERT INTO pmy_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Karna kalo tuan ruma su tutup de pu pintu, kam nanti bediri di luar trus ketuk-ketuk pintu baru bilang, ‘Bapa, bapa, buka pintu untuk tong ka!’ Dengar begitu tuan ruma itu de nanti jawab kam, ‘Kam sapa? Sa tra knal kam, sa tra tau kam datang dari mana.’ ");
INSERT INTO pmy_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Trus kam mo jawab, ‘Bapa tra knal kitong ka! Tong ni yang biasa duduk makan minum deng bapa, juga Bapa yang su kas ajar di tong pu kota-kota!’ ");
INSERT INTO pmy_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Tapi nanti tuan itu de bilang lagi, ‘Sa tra knal kam, kam datang dari mana. Pigi dari sini, kam smua yang bikin jahat!’ ");
INSERT INTO pmy_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Disana tempat orang mnangis sedi skali sampe gigi bunyi. Karna kam sendiri liat Abraham, Ishak sama Yakub deng smua nabi-nabi dong di dalam Allah pu Krajaan, tapi kam sendiri dapa buang kluar! ");
INSERT INTO pmy_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Orang nanti datang dari timur deng barat, utara deng slatan, dong nanti datang duduk makan sama-sama di dalam Allah pu Krajaan. ");
INSERT INTO pmy_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Dengar baik-baik, ada orang yang pertama de yang nanti jadi trakir, trus orang yang trakir de yang nanti jadi orang pertama.” ");
INSERT INTO pmy_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Waktu itu ada orang-orang Farisi dong datang bicara sama Yesus begini, “Bapa, Ko pigi cepat, kas tinggal tempat ini, karna Herodes de mo bunu Ko.” ");
INSERT INTO pmy_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Trus Yesus jawab, “Kam pigi trus kastau Herodes tukang tipu itu, ‘Hari ini deng besok Sa usir setan deng kas sembu orang trus hari ketiga baru Sa pu kerja slesai.’ ");
INSERT INTO pmy_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Biar begitu hari ini, besok sama besok lusa Sa harus jalan trus sampe ke Yerusalem, karna nabi tra bole dapa bunu di luar Yerusalem. ");
INSERT INTO pmy_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Sayang skali orang-orang Yerusalem! Kam yang bunu nabi-nabi trus Allah pu utusan kam lempar deng batu sampe mati! Ulang-ulang kali Sa mo kas kumpul kam smua sperti ayam betina kas kumpul de pu anana di bawa de pu sayap, tapi kam tra mau. ");
INSERT INTO pmy_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Itu jadi Allah de mo lepas tangan dari kam smua deng kam pu kota. Sa bilang kam, kam trakan liat Sa lagi, sampe pas waktu nanti kam bilang, ‘Allah berkati De yang datang dalam nama Tuhan.’ ” ");
INSERT INTO pmy_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Satu kali pas hari Sabat, Yesus pigi makan di pemimpin satu pu ruma. De tu dari klompok Farisi. Disitu smua orang dong trus jaga liat Yesus untuk liat apa yang nanti De buat. ");
INSERT INTO pmy_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Begini orang satu datang bediri depan Yesus, orang itu sakit yang bikin de pu badan bengkak-bengkak. ");
INSERT INTO pmy_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Trus Yesus tanya guru-guru agama deng orang Farisi yang ada disitu, “Kas sembu orang sakit pas di hari Sabat bisa ka tra, mnurut tong pu aturan agama?” ");
INSERT INTO pmy_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Dong smua diam saja. Trus Yesus pegang orang sakit itu, kas sembu de trus suru de pigi. ");
INSERT INTO pmy_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Habis itu Yesus bilang sama dorang, “Conto saja kam pu anak ato sapi jatu dalam sumur, kam pasti pigi cepat tarik kas kluar to, biar mo hari Sabat juga!” ");
INSERT INTO pmy_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Dong smua tra bisa lawan Yesus pu kata-kata. ");
INSERT INTO pmy_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Waktu itu, Yesus liat kalo tamu-tamu yang dapa undang, dong baku lomba mo duduk di tempat yang paling depan, begitu jadi Yesus crita conto ini sama dong, ");
INSERT INTO pmy_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Kalo ada orang undang kam ke pesta nika, jang kam pigi cari tempat paling depan. Karna jang sampe de ada undang orang lain yang lebi penting dari kam. ");
INSERT INTO pmy_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Jang sampe orang yang undang kam itu de datang trus de bilang sama kam, ‘Jang mara eh! Tolong pinda ke blakang karna ini tempat untuk orang yang itu.’ Deng begitu kam bediri pigi ke blakang deng rasa malu. ");
INSERT INTO pmy_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Begitu jadi, kalo kam dapa undang, kam cari tempat yang di blakang, sapa tau orang yang undang kam de nanti datang deng bilang, ‘Sodara mari sini, ko pu tempat di depan.’ Deng begitu kam dapa hormat di depan smua tamu yang lain. ");
INSERT INTO pmy_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Karna sapa saja yang angkat diri nanti de dapa kas renda, tapi orang yang kas renda diri nanti de dapa angkat.” ");
INSERT INTO pmy_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Trus Yesus kastau ke orang yang undang itu, “Kalo ko mo undang orang untuk makan siang ato makan malam, jang kam undang teman, sodara, kluarga ato orang-orang sebla ruma yang kaya saja. Karna pasti dong nanti undang kam juga, deng begitu pasti kam dapa balas apa yang kam bikin sama dorang. ");
INSERT INTO pmy_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Tapi kalo ko bikin pesta, undang lagi orang miskin, orang cacat, orang lumpu, sama orang buta. ");
INSERT INTO pmy_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ko nanti untung skali, karna dong trada apapa untuk balas ko, nanti ko dapa balas waktu orang-orang yang ikut Allah pu mau dong hidup kembali.” ");
INSERT INTO pmy_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Waktu satu orang yang ada makan sama-sama disitu dengar Yesus bicara, de bilang, “Orang yang nanti makan sama-sama deng Allah di De pu Krajaan, de untung skali!” ");
INSERT INTO pmy_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Tapi Yesus bilang conto satu sama orang itu begini, “Satu kali ada orang satu bikin pesta besar, de undang banyak orang. ");
INSERT INTO pmy_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Pas mo mulai pesta, de suru de pu pesuru ke orang-orang yang dapa undang baru bilang, ‘Mari datang, smua su siap.’ ");
INSERT INTO pmy_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Tapi smua satu-satu kasi alasan. Yang satu bilang sama pesuru itu, ‘Maaf eh, sa baru bli tana deng kebun jadi sa musti pigi liat tana deng kebun itu.’ ");
INSERT INTO pmy_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Satu lagi bilang, ‘Sa baru bli sapi lima pasang jadi skarang sa mo pigi coba sapi-sapi itu, maaf eh, sa tra ikut.’ ");
INSERT INTO pmy_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Yang lain lagi bilang, ‘Sa baru kawin jadi tra bisa pigi.’ ");
INSERT INTO pmy_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Habis itu, pesuru de pulang deng kastau smua itu ke de pu tuan. Tuan de mara skali deng bilang pesuru itu, ‘Cepat ko pigi ke jalan-jalan deng gang-gang di kota ini. Bawa datang smua orang miskin, orang cacat, orang buta deng orang yang lumpu.’ ");
INSERT INTO pmy_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Trus pesuru itu de buat smua tu baru de bilang, ‘Tuan, smua yang tuan kas printa, sa su buat tapi masi ada tempat kosong.’ ");
INSERT INTO pmy_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Trus tuan itu bilang, ‘Pigi kluar kota ini di jalan besar sampe ke jalan-jalan tikus, pigi tarik orang-orang sapa saja disitu datang kas penu sa pu ruma. ");
INSERT INTO pmy_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Sa bilang kam, trada satu orang juga yang dapa undang itu nanti makan Sa pu makanan pesta.’ ” ");
INSERT INTO pmy_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Habis itu banyak orang dong ikut Yesus jalan sama-sama. Begitu balik liat dong, Yesus bilang, ");
INSERT INTO pmy_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Sapa yang betul-betul mo ikut Saya, de musti sayang Sa lebi dari de pu bapa, de pu mama, de pu istri, de pu anana, de pu sodara-sodara laki-laki ato prempuan, juga lebi dari de pu diri. Kalo tra begitu, de tra bisa ikut Saya. ");
INSERT INTO pmy_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Sapa saja yang tra pikul de pu salib trus ikut Saya, orang itu tra bisa jadi Sa pu murid-murid. ");
INSERT INTO pmy_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Jadi, kalo mo ikut Saya, kam musti pikir baik-baik dulu. Sperti orang yang mo bikin ruma yang besar, pasti de harus duduk pikir dulu de pu biaya smua. Supaya de bisa kira-kira kalo de pu uang itu cukup untuk bikin ruma sampe slesai ka tra. ");
INSERT INTO pmy_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kalo tra pikir itu baik-baik, jang sampe baru fondasi saja uang su habis. Baru smua orang yang liat de bisa tertawa dia. ");
INSERT INTO pmy_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Nanti dong bilang, ‘Ih orang ini de mo bikin ruma besar tapi tra bisa kas slesai!’ ");
INSERT INTO pmy_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Conto yang lain tu begini: Ada raja satu de pu pasukan prang 10.000 orang, trus ada raja satu lagi de mo srang. Raja ini de pu pasukan 20.000 orang. Raja yang pu pasukan 10.000 orang tu musti pikir baik-baik dulu, de bisa ka kas kala de pu lawan itu? ");
INSERT INTO pmy_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kalo de su tau de tra kuat, pasti waktu de pu musu masi jau de su utus orang-orang pigi ke musu dong untuk urus damei. ");
INSERT INTO pmy_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Begitu juga deng kam. Pikir baik-baik dulu, karna kam tra bisa ikut Saya, kalo kam tra mo kas lepas smua yang ada sama kam. ");
INSERT INTO pmy_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Garam itu baik, tapi kalo de su tra rasa asin, bisa ka bikin de pu rasa asin lagi? ");
INSERT INTO pmy_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Garam itu tra bisa pake mo itu di pupuk untuk kas subur tana, jadi lebi baik buang saja. Sapa yang pu tlinga untuk dengar, de harus dengar baik-baik!” ");
INSERT INTO pmy_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Begini satu hari orang-orang yang tukang tagi pajak deng orang-orang yang bikin dosa, dong datang dengar Yesus. ");
INSERT INTO pmy_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Orang Farisi deng guru agama disitu liat, trus dong sungut-sungut deng bilang, “Ih, De kawan deng orang-orang yang bikin dosa deng makan sama-sama dong!” ");
INSERT INTO pmy_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jadi Yesus kasi conto ini sama dong: ");
INSERT INTO pmy_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Kalo satu orang dari kam, de pu domba 100 ekor, trus satu ekor hilang, apa yang de buat? Pasti de taru 99 domba tu di tempat makan rumput, baru pi cari yang hilang itu sampe dapat to? ");
INSERT INTO pmy_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Trus kalo de su dapat, pasti de snang skali sampe de gendong domba itu ");
INSERT INTO pmy_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","bawa pulang. Trus de panggil de pu teman-teman deng orang-orang sebla ruma baru bilang, ‘Mari tong snang-snang, karna sa pu domba yang hilang, sa su dapat lagi!’ ");
INSERT INTO pmy_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Sa bilang kam, begitu juga smua yang di surga snang skali, karna ada satu orang yang bikin dosa de tobat dari dosa, daripada 99 orang benar yang tra perlu tobat.” ");
INSERT INTO pmy_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Ato conto lagi, ada prempuan yang de pu spulu uang perak. Kalo satu hilang, pasti de kas menyala lampu baru sapu de pu ruma untuk cari di smua tempat dalam ruma sampe de dapat uang itu. ");
INSERT INTO pmy_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Begitu de su dapat uang itu, de panggil de pu teman-teman prempuan deng orang-orang sebla ruma baru bilang, ‘Mari tong snang-snang, karna sa pu uang yang hilang, sa su dapat lagi!’ ");
INSERT INTO pmy_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Sa kastau kam, begitu juga Allah pu malaikat yang di surga snang skali kalo ada satu orang yang bikin dosa tobat dari dosa.” ");
INSERT INTO pmy_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesus bicara lagi, “Ada pace satu, de pu anak laki-laki dua orang. ");
INSERT INTO pmy_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Satu hari yang bungsu bilang sama de pu bapa begini, ‘Bapa, kasi sa pu bagian harta ka!’ Trus bapa bagi de pu harta sama dong dua. ");
INSERT INTO pmy_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Tra lama, anak bungsu pigi jual de pu bagian harta itu trus pigi ke negri lain yang jau. Disana de kas hambur-hambur de pu uang, deng hidup bebas sembarang. ");
INSERT INTO pmy_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Pas waktu de pu uang su habis, smua negri itu kena klaparan besar. De hidup susa deng tra punya apapa lagi. ");
INSERT INTO pmy_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Jadi de pigi kerja di satu orang masyarakat negri itu, trus orang itu suru de pigi jaga de pu babi. ");
INSERT INTO pmy_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","De lapar skali jadi de mo makan sampe kenyang babi pu makanan, tapi trada yang mo kasi makanan sama de. ");
INSERT INTO pmy_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Suda begini de sadar deng ingat, ‘Orang-orang yang kerja di sa pu bapa tu, pu makanan banyak baru sa disini mo mati lapar. ");
INSERT INTO pmy_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Jadi sa mo pulang nanti ke sa pu bapa baru bilang begini: Sa su buat dosa sama Allah juga sama Bapa. ");
INSERT INTO pmy_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Sa rasa tra pantas jadi Bapa pu anak, trima sa jadi tukang bantu-bantu saja. ’ ");
INSERT INTO pmy_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Habis tu, de langsung pulang ke de pu bapa. Masi jau dari ruma, de pu bapa su liat de. Bapa kasian skali sama de. Trus bapa lari, peluk de deng cium. ");
INSERT INTO pmy_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Anak tu bilang, ‘Bapa, sa su buat dosa sama Allah juga sama bapa, sa tra pantas jadi bapa pu anak.’ ");
INSERT INTO pmy_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Tapi bapa panggil de pu pesuru-pesuru deng bilang, ‘Cepat kam pigi ambil baju yang paling bagus kas pake de, pasang cincin di de pu jari trus kas pake de spatu! ");
INSERT INTO pmy_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Habis itu potong anak sapi yang gemuk, mari tong mo snang-snang deng makan. ");
INSERT INTO pmy_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Karna sa pu anak ini de macam su mati, skarang hidup kembali, de su hilang, skarang ketemu de lagi.’ Jadi dong smua mulai acara suda. ");
INSERT INTO pmy_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Masi acara, anak yang tua di kebun. Pas de pulang mo sampe dekat ruma, de dengar bunyi musik deng tarian. ");
INSERT INTO pmy_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Trus de panggil pesuru satu deng tanya, ‘Knapa ada acara di ruma?’ ");
INSERT INTO pmy_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Pesuru de jawab, ‘Tuan pu ade su kembali! Jadi tuan pu bapa suru potong anak sapi yang gemuk, karna bapa pu anak yang hilang su pulang deng slamat.’ ");
INSERT INTO pmy_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Dengar begitu, anak yang tua de mara skali, de tra mau masuk ruma. Jadi de pu bapa kluar minta skali untuk de masuk ke ruma. ");
INSERT INTO pmy_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Tapi de bilang, ‘Bapa dengar, su deng taun-taun sa kerja stenga mati untuk bapa. Tra perna sa lawan bapa pu printa. Bapa kasi apa buat sa? Satu anak kambing saja tra perna bapa mo kasi untuk sa acara deng sa pu kawan-kawan dong. ");
INSERT INTO pmy_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Tapi liat bapa pu anak bungsu yang su kas habis bapa pu harta deng placur! Begitu de pulang bapa potong anak sapi yang gemuk untuk de!’ ");
INSERT INTO pmy_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","De pu bapa bilang, ‘Anak eh, ko slalu deng sa disini. Smua yang bapa punya itu ko punya. ");
INSERT INTO pmy_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Tapi ko pu ade ini macam su mati, skarang de hidup. De su hilang, skarang su ketemu de lagi, itu yang tong harus snang skali.’ ” ");
INSERT INTO pmy_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesus crita lagi sama De pu murid-murid dong begini, “Ada orang kaya satu, de kas kerja satu orang yang de percaya yang bisa urus de pu harta. Orang kaya itu dapa lapor kalo orang yang de percaya tu ada hambur-hambur de pu uang. ");
INSERT INTO pmy_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Jadi de panggil orang yang de percaya itu baru bilang, ‘Sa su dengar tentang ko pu kerja yang tra benar, skarang kasi sa laporan lengkap tentang ko pu kerja urus sa pu harta. Karna ko tra bole urus sa pu harta lagi.’ ");
INSERT INTO pmy_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Jadi orang itu bicara dalam hati, ‘Sa mo buat apa, kalo nanti sa dapa pecat? Angkat pasir, sa tra kuat, minta-minta orang, sa malu. ");
INSERT INTO pmy_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Sa tau apa yang sa mo buat, biar nanti orang-orang mo trima sa di dong pu ruma waktu sa dapa pecat!’ ");
INSERT INTO pmy_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Trus de panggil satu-satu orang yang pu utang sama de pu bos. De bilang sama yang pertama, ‘Ko pu utang brapa sama sa pu bos?’ ");
INSERT INTO pmy_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Orang tu de jawab, ‘Minyak zaitun 20 drem.’ Trus de bilang orang itu, ‘Ini ko pu surat utang. Ko duduk trus cepat ko tulis jadi spulu drem.’ ");
INSERT INTO pmy_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Trus de bilang ke yang satu lagi, ‘Baru sodara brapa ko pu utang?’ Orang tu de jawab, ‘20 ton gandum.’ De bilang sama orang itu, ‘Ini ko pu surat utang, duduk trus cepat ko tulis 16 ton gandum.’ ");
INSERT INTO pmy_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","De bikin tra jujur sampe de pu bos tau. Tapi de pu bos puji orang yang urus de pu harta itu, karna de pu pintar.” Yesus bilang lagi, “Orang-orang dunia pu akal panjang atur dong pu urusan, daripada orang-orang yang hidup dalam Tuhan. ");
INSERT INTO pmy_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Sa kastau kam! Pake harta dunia untuk tolong orang, supaya kam dapat teman. Jadi waktu kam pu harta dunia habis, nanti kam dapa trima di tempat tinggal di surga yang trada akir. ");
INSERT INTO pmy_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Kalo satu orang setia urus hal kecil, de juga setia urus hal besar. Juga kalo orang yang tra jujur urus hal kecil, de juga tra jujur urus hal besar. ");
INSERT INTO pmy_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Jadi, kalo kam tra setia urus harta dunia, Tuhan tra percaya kam deng harta di surga. ");
INSERT INTO pmy_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Trus kalo kam tra setia urus orang lain pu harta, Tuhan tra mau kasi kam pu harta di surga. ");
INSERT INTO pmy_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Tra bisa satu orang jadi pesuru untuk dua tuan. Karna pasti de lebi sayang tuan yang satu dari yang lain, ato de lebi setia sama tuan yang satu dari yang lain. Tra bisa Allah deng harta jadi kam pu tuan sama-sama.” ");
INSERT INTO pmy_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Orang-orang Farisi dong suka uang. Itu yang dong dengar Yesus bicara smua ini, dong tertawa hina Yesus. ");
INSERT INTO pmy_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Tapi Yesus bilang sama dong, “Depan orang kam mo tunjuk diri benar, tapi Allah tau kam pu isi hati. Karna apa yang orang anggap paling bagus, itu Allah paling tra suka. ");
INSERT INTO pmy_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Sampe Yohanes datang, tong hanya knal hukum Musa deng nabi-nabi pu ajaran saja. Pas waktu itu Brita Baik tentang Allah pu Krajaan mulai dapa kastau, trus banyak orang mo coba rampas deng masuk Allah pu Krajaan. ");
INSERT INTO pmy_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Biar begitu, lebi gampang langit deng bumi hilang, daripada satu huruf dalam hukum Musa itu batal. ");
INSERT INTO pmy_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Sapa saja yang kas cerai de pu istri baru pigi kawin lagi deng prempuan lain, itu de su bikin dosa karna su tidur deng orang yang bukan de pu pasangan, begitu juga kalo sapa yang kawin deng prempuan yang cerai dari de pu suami, itu de su bikin dosa karna su tidur deng orang yang bukan de pu pasangan.” ");
INSERT INTO pmy_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yesus crita lagi, “Ada satu orang kaya de pu pakean bagus-bagus deng mahal, de pake de pu harta untuk hidup snang-snang stiap hari. ");
INSERT INTO pmy_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Juga ada orang miskin satu de pu nama Lasarus, de pu badan penu deng luka-luka busuk. Orang dong biasa taru de di orang kaya tu pu pintu ruma. ");
INSERT INTO pmy_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","De mo skali makan makanan yang jatu dari orang kaya itu pu meja. Trus anjing-anjing yang datang jilat de pu luka-luka. ");
INSERT INTO pmy_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Satu hari orang miskin itu mati. Trus malaikat bawa de ke tempat paling hormat sebla bapa Abraham di surga. Orang kaya itu juga mati, dong kubur dia. ");
INSERT INTO pmy_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","De sengsara skali di orang mati pu tempat. Waktu de angkat muka liat ke atas, dari jau de liat bapa Abraham deng Lasarus di sebla. ");
INSERT INTO pmy_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","De batariak, ‘Bapa Abraham! Kasian sa ka, sa mendrita skali dalam api! Suru Lasarus kas masuk jari ke air baru datang kas basa sa pu lida.’ ");
INSERT INTO pmy_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Tapi Abraham bilang, ‘Anak, ko ingat, waktu hidup di dunia ko dapat smua yang baik, tapi Lasarus de sengsara. Skarang de dapa hibur, tapi ko sengsara. ");
INSERT INTO pmy_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Tra hanya itu saja, di tenga ko deng tong ada jurang yang besar, jadi orang dari sini tra bisa ke kam, juga kam tra bisa ke sini.’ ");
INSERT INTO pmy_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Orang kaya itu de bilang, ‘Kalo begitu bapa, sa mohon bapa suru Lasarus pi ke sa pu bapa pu ruma. ");
INSERT INTO pmy_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Karna masi ada sa pu sodara lima. Suru Lasarus kas ingat dong supaya jang dong masuk ke tempat siksa ini.’ ");
INSERT INTO pmy_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham de jawab, ‘Dong bisa baca Musa pu buku-buku deng buku-buku dari nabi! Biar dong ikut pesan dari buku-buku itu!’ ");
INSERT INTO pmy_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Orang kaya itu de jawab, ‘Bapa Abraham, itu tra bisa. Tapi kalo ada orang mati hidup kembali baru datang sama dong, pasti dong tobat dari dong pu dosa.’ ");
INSERT INTO pmy_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abraham bilang, ‘Kalo dong tra bisa dengar trus ikut Musa deng nabi, biar mo orang mati hidup kembali, dong pasti trakan percaya pesan dari orang yang hidup kembali itu.’ ” ");
INSERT INTO pmy_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesus bicara sama De pu murid-murid, “Pasti ada saja yang bisa umpan sampe orang mo bikin dosa. Tapi claka skali orang yang umpan itu! ");
INSERT INTO pmy_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Lebi baik untuk de kalo orang ikat batu besar di de pu leher trus lempar de ke laut, daripada de bikin sampe satu dari orang-orang yang kecil ini bikin dosa. ");
INSERT INTO pmy_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Jadi, kam harus hati-hati! Kalo ko pu sodara bikin dosa, ko tegur dia. Kalo de rasa sala baru de tobat, ko trima dia. ");
INSERT INTO pmy_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Kalo de bikin sala sama ko tuju kali dalam satu hari trus slalu datang minta maaf deng bilang sama ko, ‘Sa tobat dari sa pu sala,’ ko harus kas ampun dia.” ");
INSERT INTO pmy_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Trus Yesus pu utusan dong bicara ke Yesus, “Tuhan, kas kuat tong pu percaya ka.” ");
INSERT INTO pmy_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Yesus jawab, “Kalo kam pu percaya sperti biji yang paling kecil saja, kam bisa bilang sama pohon itu, ‘Ko pinda ke laut!’ Pasti pohon itu de ikut ko pu printa.” ");
INSERT INTO pmy_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Yesus bilang sama De pu murid-murid begini, “Kalo satu orang dari kam ada yang pu budak. Budak itu, de pu kerja bikin kebun ato pigi jaga binatang piara. Waktu budak itu de pulang, tra mungkin kam bilang sama dia, ‘Mari tong makan sama-sama.’ ");
INSERT INTO pmy_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Tra to! Yang ada tu kam nanti bilang sama budak itu, ‘Cepat ko kas siap sa makanan, ko pigi ganti pakean yang bagus trus ko siap smua, jaga sampe sa makan slesai baru ko bisa makan.’ ");
INSERT INTO pmy_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ada ka de dapa puji karna su kerja apa yang de musti bikin? Trada to! ");
INSERT INTO pmy_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Begitu juga deng kam. Waktu su bikin smua yang musti kam bikin, kam bilang begini, ‘Kitong cuma budak, tong cuma bikin apa yang harus tong bikin.’ ” ");
INSERT INTO pmy_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Waktu lanjut ke Yerusalem, Yesus lewat jalan tenga, batas tenga daera Samaria deng daera Galilea. ");
INSERT INTO pmy_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Begitu masuk kampung satu, disitu ada spulu orang yang sakit kulit busuk, dong ketemu Yesus. Dong bediri dari jau. ");
INSERT INTO pmy_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Baru dong batariak deng kras, “Yesus, Guru, kasian kitong ka!” ");
INSERT INTO pmy_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesus liat dong baru bilang, “Kam pigi sama imam-imam supaya dong priksa kalo kam su sembu.” Begini waktu masi di tenga jalan spulu orang yang sakit kulit busuk ni dong smua sembu. ");
INSERT INTO pmy_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","16","Satu orang dari dong, de ni orang Samaria, de kembali puji-puji Allah deng suara kras karna de su liat kalo de sembu. Trus depan Yesus de tunduk sampe muka ke tana de bilang, “Bapa trima kasi.” ");
INSERT INTO pmy_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Trus Yesus bilang ke orang, “Dong spulu orang yang tadi su sembu, mana dong sembilan itu? ");
INSERT INTO pmy_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Knapa cuma de yang bukan orang Yahudi yang mo kembali puji Allah?” ");
INSERT INTO pmy_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Trus Yesus bilang orang itu, “Bangun deng pigi, karna ko percaya Saya, ko slamat.” ");
INSERT INTO pmy_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Orang-orang Farisi dong tanya sama Yesus kapan Allah pu Krajaan mo datang. Trus Yesus jawab dong begini, “Allah pu Krajaan tra mo datang deng tanda-tanda yang orang dong bisa liat. ");
INSERT INTO pmy_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Deng begitu orang tra bisa bilang, ‘Coba kam liat De ada disini!’ ato ‘Coba liat De ada disana!’ Karna Allah pu Krajaan su mo datang di tenga kam smua.” ");
INSERT INTO pmy_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Habis itu Yesus bilang sama De pu murid-murid dong, “Nanti satu hari kam rindu mo liat hari yang Sa Anak Manusia datang kembali, tapi kam tra bisa. ");
INSERT INTO pmy_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Trus nanti orang dong bilang sama kam, ‘Pigi liat De ada disana!’ ato ‘Mari liat De ada disini!’ Jang kam mo ikut pigi cari. ");
INSERT INTO pmy_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Karna nanti waktu Sa Anak Manusia datang itu sperti kilat pica di langit, de pu cahaya tu dari ujung ke ujung sampe smua orang bisa liat. ");
INSERT INTO pmy_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Tapi Sa musti kena banyak sengsara dulu trus dapa tolak dari orang-orang jaman ini. ");
INSERT INTO pmy_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Waktu Sa Anak Manusia datang kembali, orang-orang pu hidup sama sperti Nuh pu jaman. ");
INSERT INTO pmy_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Dong makan, minum, deng baku kawin, begitu trus sampe Nuh masuk dalam kapal besar, trus banjir besar datang tutup bumi sampe orang-orang smua mati tenggelam. ");
INSERT INTO pmy_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Begitu juga waktu Lot pu jaman. Dong makan deng minum, dong pigi bli deng pigi jual, juga dong bikin kebun deng bikin ruma. ");
INSERT INTO pmy_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Tapi waktu Lot deng de pu kluarga kluar dari Kota Sodom, hari itu api deng lahar panas turun dari langit trus kas hancur dong smua. ");
INSERT INTO pmy_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Begitu suda yang jadi waktu Sa Anak Manusia nanti balik kembali. ");
INSERT INTO pmy_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Sapa saja pas hari itu kalo de ada di atas ruma deng de pu barang-barang ada di dalam ruma, jang de masuk untuk ambil barang-barang. Trus orang yang ada di kebun, jang de mo kembali. ");
INSERT INTO pmy_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ingat to apa yang jadi sama Lot pu istri! ");
INSERT INTO pmy_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Sapa saja yang usaha mo kas slamat de pu hidup, nanti de tra bisa hidup yang trada akir. Tapi orang yang kasi de pu hidup, de yang nanti slamat. ");
INSERT INTO pmy_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Sa kastau kam, waktu malam itu ada dua orang di satu tempat tidur, yang satu dapa bawa trus yang satu dapa kas tinggal. ");
INSERT INTO pmy_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Trus ada dua prempuan dong giling biji gandum, yang satu dapa bawa trus yang satu dapa kas tinggal.  ");
INSERT INTO pmy_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Dua orang dong kerja di kebun, satu dapa bawa trus yang satu lagi dapa kas tinggal.” ");
INSERT INTO pmy_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Yesus pu murid-murid dong tanya, “Tuhan dimana nanti itu jadi?” Yesus jawab sama dong, “Dimana bangkai ada, disitu ada banyak burung bangkai yang kumpul.” ");
INSERT INTO pmy_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Satu kali begini Yesus crita satu conto sama De pu murid-murid, supaya dong pu smangat tra hilang untuk slalu doa sama Tuhan. ");
INSERT INTO pmy_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Yesus bilang, “Di kota satu ada hakim satu. De ni tra takut sama Allah, de juga tra peduli sama orang lain. ");
INSERT INTO pmy_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Di kota itu juga ada janda satu, yang dapa kas rugi, de ulang-ulang pigi sama hakim trus de bilang, ‘Bapa, bantu sa pu masala deng sa pu lawan.’ ");
INSERT INTO pmy_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Lama skali hakim de tra mau tolong janda itu. Tapi karna janda de datang ulang-ulang, jadi hakim ni de pikir dalam hati, ‘Biar sa ni tra takut Allah trus tra peduli sama orang lain, ");
INSERT INTO pmy_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","tapi daripada de datang ulang-ulang ganggu saya, lebi baik janda ini pu masala sa kas slesai deng baik.’ ” ");
INSERT INTO pmy_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Trus Tuhan bilang, “Kam coba pikir baik-baik apa yang hakim jahat itu bilang! ");
INSERT INTO pmy_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Jadi kalo hakim yang jahat itu saja bisa tolong janda itu, lebi lagi Allah nanti De tolong orang-orang yang De pili, kalo dong mo datang minta tolong sama Allah siang deng malam. Allah trakan lama untuk tolong dorang. ");
INSERT INTO pmy_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Kam dengar eh! Allah pasti cepat kas slesai dong pu masala. Tapi kalo Sa Anak Manusia datang kembali, masi ada orang di bumi yang percaya sama Sa ka?” ");
INSERT INTO pmy_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesus crita conto ini untuk orang-orang yang anggap diri benar trus dong anggap orang lain tra baik. ");
INSERT INTO pmy_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Yesus De bilang, “Satu kali begini, ada dua orang dong pigi doa di Ruma Allah. Yang satu de dari klompok Farisi, baru yang satu lagi de dari tukang tagi pajak. ");
INSERT INTO pmy_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Orang Farisi de bediri sendiri saja baru de doa, ‘Ya Allah! Sa ni mo doa syukur karna sa ni beda deng orang lain, sa tra curi-curi, tra bikin jahat, tra tidur deng orang yang bukan sa pu pasangan, sa ni juga tra sperti tukang tagi pajak itu. ");
INSERT INTO pmy_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Sa puasa satu minggu dua kali, sa kasi seperspulu dari sa pu hasil smua.’ ");
INSERT INTO pmy_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Tapi tukang tagi pajak ni de bediri jau-jau, de tra brani angkat muka. De pukul-pukul de pu dada baru bilang, ‘Ya Allah, kasian saya, sa ni orang yang bikin dosa!’ ” ");
INSERT INTO pmy_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yesus bilang, “Kam dengar eh! Waktu dua orang ini pulang ke dong pu ruma, tukang tagi pajak yang Allah anggap benar, bukan Farisi yang rajin ikut hukum Musa. Sapa saja yang angkat diri nanti de dapa kas renda. Tapi orang yang kas renda diri nanti de dapa angkat.” ");
INSERT INTO pmy_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Satu kali begini ada orang-orang yang datang bawa dong pu anana kecil ke Yesus, supaya De taru tangan untuk berkati dorang. Tapi De pu murid-murid mara orang-orang itu. ");
INSERT INTO pmy_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Tapi Yesus panggil anana kecil trus De bilang, “Kas biar anana kecil itu datang ke Saya, jang larang-larang dong, karna orang-orang sperti begini yang punya Allah pu Krajaan. ");
INSERT INTO pmy_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Yang Sa bilang ini benar: Sapa saja yang tra mo trima Allah pu Krajaan di de pu hidup sperti anak kecil, de tra bisa masuk dalam Allah pu Krajaan.” ");
INSERT INTO pmy_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ada orang Yahudi pu pemimpin satu de tanya sama Yesus, “Bapa Guru yang baik, sa harus bikin apa supaya sa bisa hidup trus sampe trada akir?” ");
INSERT INTO pmy_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesus jawab, “Knapa ko bilang Sa baik? Trada satu orang yang baik cuma Allah saja. ");
INSERT INTO pmy_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ko pasti tau Allah pu printa-printa, ‘Jang tidur deng orang yang bukan ko pu pasangan, jang bunu orang, jang curi, jang jadi saksi yang tra benar, juga hormati ko pu bapa deng mama.’ ” ");
INSERT INTO pmy_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Orang itu bilang, “Allah pu printa itu smua sa su bikin dari sa muda.” ");
INSERT INTO pmy_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Dengar begitu Yesus bilang, “Masi ada satu yang kurang dari ko. Jual smua yang ko punya trus bagi-bagi itu sama orang-orang miskin, deng bikin begitu ko nanti dapat harta di surga. Habis itu baru ko datang ikut Saya.” ");
INSERT INTO pmy_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Waktu de dengar begitu, de rasa sedi skali karna de kaya skali. ");
INSERT INTO pmy_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Waktu Yesus liat orang itu de sedi skali trus bilang, “Memang susa skali orang yang pu harta banyak masuk dalam Allah pu Krajaan. ");
INSERT INTO pmy_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Lebi gampang satu ekor unta masuk lewat lobang jarum daripada satu orang kaya masuk dalam Allah pu Krajaan.” ");
INSERT INTO pmy_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Dong yang dengar itu bilang, “Kalo begitu, sapa yang bisa slamat?” ");
INSERT INTO pmy_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesus bilang, “Apa yang tra bisa untuk manusia, pasti bisa untuk Allah.” ");
INSERT INTO pmy_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Petrus bilang, “Liat, tong su kas tinggal apa yang tong punya, trus ikut Bapa.” ");
INSERT INTO pmy_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesus bilang sama dorang, “Yang Sa bilang ini benar: Orang yang kas tinggal de pu ruma, de pu istri, de pu sodara, de pu orang tua ato juga de pu anana karna de mau layani untuk Allah pu Krajaan, ");
INSERT INTO pmy_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","di waktu skarang ini orang itu pasti dapat lebi banyak skali dari yang de su kas tinggal. Juga di jaman yang datang nanti de hidup trus sampe trada akir.” ");
INSERT INTO pmy_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesus panggil De pu duablas murid, baru bilang sama dong, “Skarang tong pigi ke Yerusalem, trus smua yang nabi-nabi dong tulis tentang Sa Anak Manusia, su mo jadi. ");
INSERT INTO pmy_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Karna Sa nanti dapa kasi ke orang-orang bukan Yahudi, dapa ejek-ejek, dapa hina deng dapa luda. ");
INSERT INTO pmy_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Dong nanti cambuk deng bunu Saya, tapi pas hari ketiga Sa nanti hidup kembali.” ");
INSERT INTO pmy_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Biar begitu dong tra mngerti smua itu, arti dari kata-kata itu tasembunyi, trus dong tra tau Yesus pu maksud. ");
INSERT INTO pmy_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Waktu Yesus dong mo masuk Kota Yerikho, disitu ada orang buta satu de duduk minta-minta di pinggir jalan. ");
INSERT INTO pmy_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Waktu de dengar banyak orang dong lewat, de tanya, “Eee, ada apa ka?” ");
INSERT INTO pmy_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Dong jawab, “Yesus orang Nasaret De ada lewat.” ");
INSERT INTO pmy_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Dengar begitu, orang buta itu batariak, “Yesus, Daud pu turunan, kasian sa ka!” ");
INSERT INTO pmy_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Dong yang jalan di depan, tegur supaya de diam. Tapi de batariak lebi kras lagi, “Daud pu turunan, kasian sa ka!” ");
INSERT INTO pmy_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Trus Yesus brenti baru suru dong bawa orang yang buta itu sama Dia. Waktu de su ada dekat, trus Yesus tanya dia, ");
INSERT INTO pmy_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ko mau Sa bikin apa untuk ko?” De bilang, “Tuhan, sa mau supaya sa bisa liat!” ");
INSERT INTO pmy_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Trus Yesus bilang ke dia, “Skarang ko liat suda! Karna ko percaya Saya, ko sembu.” ");
INSERT INTO pmy_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Waktu itu juga de bisa liat. De langsung ikut Yesus puji-puji Allah. Waktu orang banyak liat yang jadi, dong smua juga kas tinggi-tinggi Allah. ");
INSERT INTO pmy_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Waktu Yesus sampe di Kota Yerikho, De jalan lewat kota itu. ");
INSERT INTO pmy_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Disitu ada satu orang kaya, de kepala dari tukang tagi pajak, de nama Sakeus. ");
INSERT INTO pmy_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","De mo skali liat Yesus itu sapa, tapi de tra bisa liat karna orang banyak skali, baru de pu badan pendek. ");
INSERT INTO pmy_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Begitu jadi de su duluan lari kemuka dari orang banyak itu, trus de panjat satu pohon supaya de bisa liat Yesus yang nanti mo lewat dari situ. ");
INSERT INTO pmy_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Pas Yesus sampe di pohon itu, De liat ke atas pohon baru bilang dia, “Sakeus, cepat ko turun karna Sa mo singga di ko pu ruma hari ini.” ");
INSERT INTO pmy_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Dengar begitu Sakeus de snang skali trus cepat-cepat de turun trus de bawa Yesus ke de pu ruma. ");
INSERT INTO pmy_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Smua orang yang liat itu dong tra snang trus dong baku bicara suda, dong bilang, “Ih, masa tu De pigi singga di ruma orang yang bikin dosa!” ");
INSERT INTO pmy_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Tapi di de pu ruma, Sakeus bediri baru bilang sama Yesus, “Tuhan, stenga dari sa punya sa kasi sama orang miskin, juga sapa saja yang perna sa ambil deng paksa nanti sa kas kembali empat kali dari yang sa ambil.” ");
INSERT INTO pmy_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Trus Yesus balik baru bilang, “Hari ini, ko deng ko pu kluarga smua dapa kas slamat dari Allah, karna yang ko su bikin ini kas tunjuk kalo ko ni Abraham pu turunan. ");
INSERT INTO pmy_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Karna Sa Anak Manusia datang untuk cari deng kas slamat orang yang hilang.” ");
INSERT INTO pmy_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Waktu orang masi dengar Yesus bicara, De crita sama dong satu conto lagi. Karna, De su dekat Kota Yerusalem, trus orang banyak dong kira kalo De su sampe disitu, Allah pu Krajaan mo datang. ");
INSERT INTO pmy_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Jadi Yesus De crita begini, “Ada satu orang penting yang kaya, de pigi ke tempat yang jau untuk dapa lantik jadi raja di de pu negara, baru nanti de kembali. ");
INSERT INTO pmy_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Seblum brangkat, de panggil de pu pesuru spulu orang, baru de kasi stiap orang satu uang logam emas. Trus de kastau dong, ‘Waktu sa pigi, uang ini kam pake usaha supaya nanti sa bisa dapat untung.’ ");
INSERT INTO pmy_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Tapi orang-orang di de pu negara dong tra suka skali sama dia. Stela de brangkat dong kirim orang-orang untuk bilang, ‘Tong tra mau orang ini yang jadi raja untuk kitong.’ ");
INSERT INTO pmy_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Tapi orang kaya itu dapa lantik jadi raja, habis itu de kembali. De suru panggil de pu pesuru-pesuru yang dapat uang itu supaya de mo tau brapa hasil yang dong dapat dari dong pu usaha. ");
INSERT INTO pmy_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Pembantu yang pertama de datang baru bilang, ‘Tuan, satu uang logam emas yang tuan punya itu, sa dapat hasil spulu uang logam emas.’ ");
INSERT INTO pmy_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Tuan itu de bilang, ‘Bagus skali yang ko su bikin, ko pesuru yang baik! Karna untuk hal kecil ko su bisa dapa percaya, sa kasi ko kuasai spulu kota.’ ");
INSERT INTO pmy_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Pembantu yang kedua de datang trus bilang, ‘Tuan, satu uang logam emas yang tuan punya itu, sa dapat hasil lima uang logam emas.’ ");
INSERT INTO pmy_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","De bilang sama pesuru itu, ‘Ko nanti pu kuasa untuk lima kota.’ ");
INSERT INTO pmy_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Pembantu ketiga de datang deng bilang, ‘Tuan, ini tuan pu uang, sa simpan dalam lenso. ");
INSERT INTO pmy_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Sa takut karna tuan orang yang kras, tuan ambil apa yang tuan tra simpan, juga tuan ambil hasil di tempat tuan tra perna tanam.’ ");
INSERT INTO pmy_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","De bilang sama orang itu, ‘Ko ini pesuru yang jahat! Deng ko pu kata-kata sendiri sa nanti adili ko. Jadi ko su tau sa orang yang kras, sa ambil apa yang sa tra simpan juga sa ambil hasil yang tra perna sa tanam. ");
INSERT INTO pmy_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Kalo begitu knapa ko tra kas masuk uang itu di bank saja supaya waktu sa kembali sa bisa dapat uang itu sama de pu bunga lagi?’ ");
INSERT INTO pmy_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Habis itu tuan de bilang sama orang-orang yang bediri disitu, ‘Ambil uang logam emas dari orang itu trus kasi sama orang yang pu spulu uang logam emas itu.’ ");
INSERT INTO pmy_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Tapi orang-orang itu bilang, ‘Tuan, de su punya spulu mo.’ ");
INSERT INTO pmy_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Tuan de jawab, ‘Sa kastau kam, orang yang urus deng baik apa yang de dapat, nanti de dapa kasi lebi banyak lagi. Tapi orang yang tra urus deng baik apa yang de dapat, nanti itu juga dapa ambil dari dia. ");
INSERT INTO pmy_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Jadi skarang, bawa kesini sa pu musu-musu yang tra mau kalo sa jadi dong pu raja. Bunu saja dong smua di depan sa pu mata!’ ” ");
INSERT INTO pmy_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Habis crita smua, Yesus jalan depan dong untuk pigi ke Kota Yerusalem. ");
INSERT INTO pmy_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Waktu sampe dekat kampung Betfage deng kampung Betania yang di dekat kaki Bukit Zaitun, Yesus suru De pu murid dua orang ");
INSERT INTO pmy_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","deng bilang, “Kam dua pigi ke kampung yang di depan sana! Pas sampe disana, nanti kam dua ketemu anak kledai satu yang dong ikat, yang blum perna ada orang yang naik duduk di atas kledai itu. Kam dua kas lepas tali, trus bawa kledai itu kemari. ");
INSERT INTO pmy_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kalo ada orang yang tanya sama kam dua, ‘Knapa kledai itu kam dua lepas?’ Kam dua bilang begini, ‘Tuhan De perlu ini.’ ” ");
INSERT INTO pmy_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Trus dong dua yang dapa suru itu pigi, trus smua jadi sperti yang Yesus su bilang. ");
INSERT INTO pmy_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Pas dong dua ada kas lepas anak kledai itu, orang yang pu kledai tu tanya, “Knapa kledai itu kam lepas?” ");
INSERT INTO pmy_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Dong bilang, “Tuhan De perlu ini.” ");
INSERT INTO pmy_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Dong bawa kledai itu ke Yesus, trus alas kledai tu pu blakang pake dong pu baju panjang baru dong bantu Yesus naik duduk di atas. ");
INSERT INTO pmy_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Waktu Yesus duduk di kledai itu trus jalan, orang-orang alas jalan pake dong pu baju-baju panjang di tempat yang Yesus mo lewat. ");
INSERT INTO pmy_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Waktu Yesus dekat Yerusalem, di jalan turun dari Bukit Zaitun, smua orang yang ikut mulai puji kas tinggi Allah deng suara yang kras deng snang skali karna smua tanda luar biasa yang dong su liat sendiri. ");
INSERT INTO pmy_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Dong bilang, “Allah berkati De yang datang jadi Raja dalam nama Tuhan. Skarang manusia su bisa baku damei deng Allah di surga, mari tong puji Allah yang di tempat tinggi!” ");
INSERT INTO pmy_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Begini ada satu klompok orang yang ikut disitu, dong dari klompok Farisi, dong bilang sama Yesus, “Heee Guru! Tegur Ko pu pengikut-pengikut, karna dong tra bole bilang begitu.” ");
INSERT INTO pmy_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Trus Yesus jawab, “Sa kastau sama kam, kalo dong diam, batu-batu ini yang nanti puji kas tinggi Allah.” ");
INSERT INTO pmy_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Waktu Yesus su dekat Kota Yerusalem, Yesus liat kota itu baru De mnangis. ");
INSERT INTO pmy_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Yesus bilang, “Kasian, lebi baik kalo hari ini juga kam tau baik apa yang perlu untuk kam baku damei deng Allah! Tapi skarang kam tra bisa liat itu. ");
INSERT INTO pmy_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Karna hari itu nanti datang, kam pu musu srang kam, nanti dong timbun tana kliling kam pu kota. Trus dong kurung kam dari timur, barat, utara deng slatan sampe kam tra bisa kluar. ");
INSERT INTO pmy_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Dong mo kas hancur kam pu kota trus bunu smua orang yang tinggal di dalam, dong tra mo kas biar batu satu juga tinggal di atas batu yang lain. Smua itu jadi karna kam tra trima Allah waktu De datang untuk kas slamat kam!” ");
INSERT INTO pmy_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Trus Yesus masuk Ruma Allah baru mulai usir smua orang yang jual-jual disitu. ");
INSERT INTO pmy_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Yesus bilang sama dorang, “Ada tatulis to kalo Allah bilang, ‘Sa pu ruma harus jadi ruma doa,’ tapi kam ni su bikin itu jadi pencuri pu tempat.” ");
INSERT INTO pmy_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Stiap hari Yesus ajar trus di Ruma Allah. Imam-imam kepala deng guru-guru agama sama orang-orang besar dari orang Yahudi, dong smua cari jalan untuk bunu Yesus. ");
INSERT INTO pmy_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Tapi dong tra tau pake cara apa, karna orang smua di tempat situ snang skali mo dengar Yesus pu kata-kata smua. ");
INSERT INTO pmy_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Satu waktu Yesus kas ajar orang banyak di Ruma Allah deng kastau Brita Baik. Begini imam-imam kepala, guru-guru agama sama orang Yahudi pu tua-tua dong datang. ");
INSERT INTO pmy_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Trus dong bilang sama Yesus, “Coba Ko kastau sama kitong dulu, deng kuasa apa Ko bikin ini? Sapa yang kasi Ko kuasa untuk bikin ini smua?” ");
INSERT INTO pmy_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesus jawab dorang, “Sa mo tanya dulu. Coba kam kastau Saya, ");
INSERT INTO pmy_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yohanes de kas baptis orang deng sapa pu kuasa, Allah ato manusia?” ");
INSERT INTO pmy_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Dong sendiri bahas itu baru bilang, “Kalo tong bilang, ‘Deng Allah pu kuasa,’ De nanti bilang, ‘Knapa kam tra percaya dia?’ ");
INSERT INTO pmy_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Tapi kalo tong bilang ‘Dari manusia,’ smua orang nanti lempar tong deng batu, karna dong tau kalo Yohanes tu nabi.” ");
INSERT INTO pmy_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Jadi dong jawab kalo dong tratau deng kuasa dari mana baptisan itu. ");
INSERT INTO pmy_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Trus Yesus jawab sama dorang, “Kalo begitu Sa juga tra kastau sama kam deng kuasa apa Sa bikin ini smua.” ");
INSERT INTO pmy_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Trus Yesus crita conto ini sama orang banyak, “Ada satu orang bikin kebun anggur. Trus de kas sewa sama orang-orang yang kerja kebun itu, trus de brangkat ke tempat yang jau trus tinggal disana untuk waktu yang lama. ");
INSERT INTO pmy_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Waktu su mo panen, orang yang pu kebun tu suru de pu pesuru pigi ambil sbagian hasil panen di orang-orang yang sewa kebun. Tapi dong pukul pesuru itu baru dong suru pulang deng tangan kosong. ");
INSERT INTO pmy_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Habis itu de suru satu pesuru lain lagi, tapi dong pukul juga baru bikin malu de trus suru pulang deng tra bawa apapa. ");
INSERT INTO pmy_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Trus de suru pesuru yang ketiga, tapi orang itu dapa pukul sampe luka-luka baru dong lempar de kluar kebun. ");
INSERT INTO pmy_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Jadi orang yang pu kebun tu pikir, ‘Sa harus buat apa lagi? Sa mo kirim sa pu anak yang paling sa sayang. Pasti dong nanti hormati dia.’ ");
INSERT INTO pmy_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Tapi begitu dong liat de pu anak itu, dong atur rencana trus bilang, ‘De ini yang nanti pu hak di tana ini, mari tong bunu de supaya tana ini tong bisa ambil.’ ");
INSERT INTO pmy_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Trus dong lempar de kluar kebun trus dong bunu anak itu.” Trus Yesus tanya ke dorang, “Kam pikir orang yang pu kebun anggur itu nanti de bikin apa sama orang-orang itu? ");
INSERT INTO pmy_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","De pasti pigi bunu orang-orang yang sewa kebun itu, trus kasi kebun itu sama orang-orang lain.” Dengar begitu dong bilang sama Yesus, “Sperti begitu jang kas biar jadi sama kitong!” ");
INSERT INTO pmy_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Tapi Yesus liat dong baru bilang, “Kalo begitu apa arti ayat ini: ‘Batu yang tukang-tukang bangunan dong buang, skarang jadi batu fondasi yang paling penting.’ ");
INSERT INTO pmy_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Orang yang jatu kena batu itu, pasti de hancur. Juga kalo orang tatindis deng batu itu pasti de lebi hancur lagi.” ");
INSERT INTO pmy_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Guru-guru agama deng imam-imam kepala, dong tau kalo conto itu pu maksud Yesus bicara kas sala dorang. Itu yang dong cari cara tangkap Yesus disitu juga, tapi dong smua takut sama orang banyak. ");
INSERT INTO pmy_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Jadi dong cari waktu yang baik. Dong bayar orang untuk jadi mata-mata, dong pura-pura jadi orang baik trus tanya-tanya untuk bisa jebak Yesus supaya Yesus kas kluar kata-kata yang lawan pemrinta Roma, supaya dong bisa kasi De sama gubernur yang pu kuasa untuk adili. ");
INSERT INTO pmy_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Begini orang-orang itu tanya sama Yesus, “Bapa guru, tong tau kalo smua yang Bapa bilang deng kas ajar itu benar. Tong tau juga kalo Bapa tra kas beda-beda orang tapi kas ajar Allah pu mau deng benar. ");
INSERT INTO pmy_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Jadi coba Bapa kastau sama kitong, mnurut tong pu aturan agama, tong bisa bayar pajak sama Raja Besar Roma ka tra bisa?” ");
INSERT INTO pmy_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Tapi Yesus tau dong pu maksud tra baik itu jadi De bilang, ");
INSERT INTO pmy_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Coba kas liat sama Saya, uang logam perak satu. Gambar deng sapa pu nama yang ada disitu?” Dong jawab, “Raja Besar Roma.” ");
INSERT INTO pmy_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Trus Yesus bilang sama dorang, “Kalo begitu, kasi sama Raja Besar Roma, apa yang jadi Raja Besar Roma pu hak, trus kasi sama Allah, apa yang jadi Allah pu hak.” ");
INSERT INTO pmy_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Dong smua diam deng heran dengar Yesus jawab begitu. Itu yang dong tra bisa mo jrat Yesus di depan orang banyak. ");
INSERT INTO pmy_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Habis itu orang-orang dari klompok Saduki datang ke Yesus, dong tra percaya kalo orang-orang mati nanti hidup kembali. Jadi dong tanya sama Yesus, ");
INSERT INTO pmy_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Bapa Guru! Musa de su tulis printa ini untuk kitong, kalo satu laki-laki de mati baru de pu istri masi ada tapi dong tra pu anak, de pu sodara laki-laki musti kawin deng de pu istri supaya ada turunan untuk laki-laki yang su mati itu. ");
INSERT INTO pmy_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ada crita satu begini, tuju orang sodara dong smua laki-laki. Yang sodara pertama kawin, trus mati tra pu anak. ");
INSERT INTO pmy_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Abis itu sodara kedua de kawin deng de pu janda itu, tapi de juga mati baru tra pu anak. ");
INSERT INTO pmy_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Begitu juga sodara yang ketiga sampe yang ketuju smua tra pu anak juga. ");
INSERT INTO pmy_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Sampe prempuan itu juga de mati. ");
INSERT INTO pmy_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Jadi kalo orang mati hidup kembali, dari dong smua sapa yang jadi prempuan itu pu suami? Karna tuju orang itu su kawin deng dia.” ");
INSERT INTO pmy_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesus jawab sama dong, “Orang-orang yang hidup skarang ini dong baku kawin. ");
INSERT INTO pmy_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Tapi orang-orang yang pantas hidup kembali stela dong mati, hidup kembali di jaman yang nanti datang, dong tra kawin deng dapa kawin lagi. ");
INSERT INTO pmy_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Dong sama sperti malaikat, tra bisa mati lagi. Dong su jadi Allah pu anana, karna Allah su kas hidup dong kembali. ");
INSERT INTO pmy_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Musa sendiri su kastau deng jlas kalo orang mati nanti hidup kembali. Waktu de tulis tentang pohon duri lebat yang mnyala itu de bilang Tuhan itu, ‘Abraham, Ishak, deng Yakub dong pu Allah.’ ");
INSERT INTO pmy_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","De bukan Allah dari orang yang mati, tapi Allah dari orang yang hidup! Karna di depan Allah smua orang hidup.” ");
INSERT INTO pmy_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Dengar begitu ada guru-guru agama yang bilang, “Guru, yang Ko bilang ini betul skali.” ");
INSERT INTO pmy_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Begitu jadi sapa saja tra brani lagi mo tanya-tanya sama Yesus. ");
INSERT INTO pmy_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Tapi Yesus tanya sama dorang, “Bagemana orang bisa bilang, kalo Raja Yang Allah Pili itu Daud pu turunan? ");
INSERT INTO pmy_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Karna Daud sendiri bilang dalam kitab Mazmur, ‘Tuhan Allah su bilang sama sa pu Tuhan: Duduk di Sa pu sebla kanan, ");
INSERT INTO pmy_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","sampe Ko pu musu-musu Sa taru di bawa Ko pu kaki.’ ");
INSERT INTO pmy_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Kalo Daud sebut De itu ʻTuhan,ʼ jadi De bukan hanya Daud pu turunan saja.” ");
INSERT INTO pmy_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Waktu orang-orang masi dengar Yesus bicara, Yesus kastau De pu murid-murid dong, ");
INSERT INTO pmy_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Kam harus hati-hati deng guru-guru agama. Dong snang jalan pake baju-baju panjang trus dong mau skali dapat hormat di pasar, dong juga suka duduk paling depan di tempat ibada deng di pesta-pesta. ");
INSERT INTO pmy_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Tapi dong biasa tipu janda-janda untuk ambil paksa dong pu ruma. Trus untuk tutup dong pu klakuan jahat itu, dong doa yang panjang-panjang. Dong pasti trima hukuman yang lebi brat.” ");
INSERT INTO pmy_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Satu kali di Ruma Allah, Yesus liat orang-orang kaya kas masuk dong pu uang dalam kotak persembahan. ");
INSERT INTO pmy_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Trus Yesus liat juga ada janda miskin satu kas masuk uang logam dua yang de pu nilai paling kecil dalam kotak persembahan. ");
INSERT INTO pmy_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Begini Yesus bilang, “Yang Sa bilang ini benar: Janda miskin ini de kasi lebi banyak dari smua orang itu. ");
INSERT INTO pmy_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Karna dong smua kasi dong pu persembahan dari dong pu uang yang banyak, tapi janda ini biar de miskin de su kasi smua yang de punya, sampe smua yang de perlu untuk de pu hidup.” ");
INSERT INTO pmy_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Waktu orang-orang dong ada bicara-bicara bagemana Ruma Allah dapa kas hias deng batu yang bagus-bagus, juga sama barang-barang yang dong kas persembahan sama Allah, begini Yesus bicara sama dong, ");
INSERT INTO pmy_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Nanti ada waktu dimana smua yang kam liat ini hancur, trada satu batu disini yang nanti dapa kas biar tinggal di atas batu yang lain!” ");
INSERT INTO pmy_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Trus dong tanya sama Yesus, “Guru, kapan itu mo jadi? Trus apa de pu tanda kalo itu su mo jadi?” ");
INSERT INTO pmy_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesus bilang, “Hati-hati supaya jang sampe kam dapa tipu. Karna nanti orang banyak datang pake Sa pu nama baru bilang, ‘Sa ini yang Allah utus,’ deng, ‘Su dekat akir jaman.’ Tapi kam jang ikut dorang. ");
INSERT INTO pmy_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Trus kalo kam dengar brita-brita tentang prang deng ada yang brontak, kam jang takut. Karna smua itu harus jadi dulu, tapi itu tra brarti su mo akir jaman.” ");
INSERT INTO pmy_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yesus lanjut bilang dorang, “Bangsa satu mo prang deng bangsa lain juga negara satu deng negara lain. ");
INSERT INTO pmy_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Di mana-mana nanti ada gempa bumi yang besar, klaparan deng penyakit para. Nanti juga ada tanda heran yang ngeri skali di langit. ");
INSERT INTO pmy_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Tapi seblum smua itu, kam nanti dapa tangkap trus dapa siksa. Trus kam nanti dapa kasi ke tempat-tempat ibada baru kas masuk dalam penjara-penjara. Trus karna kam jadi Sa pu pengikut, nanti kam dapa bawa ke depan raja-raja deng pemimpin-pemimpin. ");
INSERT INTO pmy_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Itu jadi waktu untuk kam kastau tentang Sa ke dorang. ");
INSERT INTO pmy_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Jadi kam musti yakin dalam kam pu hati, kam trakan kuatir tentang apa yang harus kam bicara untuk mo bela diri. ");
INSERT INTO pmy_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Karna Sa sendiri yang nanti kasi kata-kata yang pas, sampe trada satu dari kam pu musu-musu yang bisa mlawan ato banta apa yang kam bicara. ");
INSERT INTO pmy_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Kam dapa kasi dari kam pu orang tua, sodara-sodara, kluarga besar, deng teman-teman, trus nanti dari tenga kam ada yang dapa bunu. ");
INSERT INTO pmy_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nanti smua orang tra suka kam skali karna kam ikut Saya. ");
INSERT INTO pmy_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Tapi trada satu rambut juga dari kam pu kepala yang nanti hilang. ");
INSERT INTO pmy_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kalo kam tetap tahan deng sabar, kam nanti dapat kam pu hidup.” ");
INSERT INTO pmy_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Kalo nanti kam liat tentara-tentara kepung Yerusalem, kam su tau tra lama lagi kota itu nanti hancur. ");
INSERT INTO pmy_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Pas waktu itu orang-orang yang ada di Yudea harus lari ke gunung-gunung. Orang-orang yang ada dalam kota harus pinda, trus orang-orang yang ada di luar kota jang kam masuk lagi ke dalam kota. ");
INSERT INTO pmy_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ini waktu yang Tuhan mo hukum orang Yahudi, supaya apa yang ada tulis di Kitab Suci su mo jadi. ");
INSERT INTO pmy_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kasian skali prempuan-prempuan yang ada hamil ato yang ada kas susu bayi pas waktu itu! Karna negri itu nanti alami susa yang besar, bangsa itu kena Tuhan pu mara. ");
INSERT INTO pmy_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Dong nanti dapa bunu deng pedang, yang lain dapa bawa jadi tahanan ke smua bangsa. Yerusalem nanti dapa injak dari bangsa-bangsa yang tra knal Allah sampe waktu yang Tuhan kasi sama dong slesai.” ");
INSERT INTO pmy_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Nanti ada tanda-tanda heran di matahari, bulan deng bintang-bintang. Orang-orang di smua negri di dunia ini dong takut deng bingung dengar ombak besar di laut pu bunyi. ");
INSERT INTO pmy_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Orang nanti takut stenga mati karna kuatir apa yang jadi di sluru dunia ini, karna kuasa-kuasa di langit jadi kaco. ");
INSERT INTO pmy_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Pas waktu itu orang liat Sa Anak Manusia datang di awan-awan deng kuasa yang besar deng sinar yang trang. ");
INSERT INTO pmy_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Trus kalo macam begitu su mulai jadi, bediri deng angkat ko pu muka liat ke depan, karna tra lama lagi ko su mo bebas.” ");
INSERT INTO pmy_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Trus Yesus De crita satu conto begini, “Coba kam liat pohon ara deng pohon-pohon yang lain. ");
INSERT INTO pmy_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kalo pucuk daun mulai kluar, kam tau kalo su mo musim panas. ");
INSERT INTO pmy_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Begitu juga kalo kam liat hal-hal itu jadi, kam tau kalo Allah pu Krajaan su dekat. ");
INSERT INTO pmy_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Yang Sa bilang ini benar: Seblum smua orang yang hidup skarang ini mati, smua itu jadi dulu. ");
INSERT INTO pmy_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Langit deng bumi nanti hilang, tapi Sa pu kata-kata 