﻿USE sofia;
DROP TABLE IF EXISTS sofia.pma_vpl;
CREATE TABLE pma_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES pma_vpl WRITE;
INSERT INTO pma_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","En avong mulamu, Ahi mumon out nesa ka out netan. ");
INSERT INTO pma_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","En avong enek, out netan vi heite hon, tounah tovuol ien. Atas vil koe out vasi, ka out vi mankoli. Ka ninin onen Ahi mul nesa en atas. ");
INSERT INTO pma_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","En avong enek, Ahi viteni vit, “!Maen meneai vakistal!” Ka meneai kistal. ");
INSERT INTO pma_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ahi lesi keke meneai tahos, ka mumoni muka ran mankoli. ");
INSERT INTO pma_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Meneai enek, kei ling isen vi ‘Meneai;’ ka mankoli, ling isen vi ‘Vongien.’ Vongien va, meneai mai, koanek vi avong tai. ");
INSERT INTO pma_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Evus, Ahi viteni vit, “!Maen mesaiuai tai vatiti vas atas vakeka out valu!” ");
INSERT INTO pma_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Ka kistal suval koa viteni. En sakien koanek, Ahi mumon mesaiuai tai ka lingi luhu en atas koa mul netan ka oai koa mul nesa en mahmah keil. ");
INSERT INTO pma_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ka mesaiuai enek, ling isen vi ‘Teilang.’ Vongien va, meneai mai, koanek vi avong elu (2). ");
INSERT INTO pma_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Evus, Ahi viteni vit, “Maen atas koa mul netan vamai en out vatas, ka atan hemai hekikistal rani.” Ka kistal suval koa viteni. ");
INSERT INTO pma_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Atan, kei ling isen vi ‘Atan,’ ka atas koa mai out tas, ling isen vi ‘Atas.’ Ka Ahi lesi keke lutahos. ");
INSERT INTO pma_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Evus, kei viteni vit, “Maen out netan valing tounah keil vamoul ien: koakeil iling utite, koakeil iling aneite, ka koakeil ison heite koa utite mul ien.” Ka kistal suval koa viteni. ");
INSERT INTO pma_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Sakini, out netan vitehiteh en tounah houlu tateisav. Ka Ahi lesi keke atahos. ");
INSERT INTO pma_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Vongien va, meneai mai, koanek vi avong etel (3). ");
INSERT INTO pma_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Evus, Ahi viteni vit, “Maen tounah keil koa aritin ikistal en teilang avoumon meneai hersuvaltei vongien. Itie lat avong keil ka sua keil, ka itie lati mun avong mal ten tounah keil ikistal ien. ");
INSERT INTO pma_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Keil ititin en teilang ka isan meneai ka maim hemita en out netan.” Ka kistal suval koa viteni. ");
INSERT INTO pma_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Sakini, Ahi mumon marmari laet elu: meteiai koa keih van en meneai, ka avati koa merau vatitin en vongien. Ka kei mumon hitu keil emun koa vilahil. ");
INSERT INTO pma_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Kei ling keil en teilang avatitin va mita en out netan, ");
INSERT INTO pma_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","tai koa mukan en meneai, ka tai en vongien keke avong keilu enek luheteisav. Ahi lesi keke lutahos. ");
INSERT INTO pma_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Vongien va, meneai mai, koanek vi avong ehat (4). ");
INSERT INTO pma_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Evus, Ahi viteni vit, “Maen tounah keil koa amoul ihilelau en atas. Ka maen aman keil ihilelau en teilang.” ");
INSERT INTO pma_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Sakini, Ahi mumon mari mesau keil ten atas ka tounah sav emun keil koa amoul amul ien. Kei mumon aman tateisav emun keil koa amuka. Ahi lesi keke atahos. ");
INSERT INTO pma_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Kei san tokolkatien onen min keil, viteni min koakeil amul en atas vit, “Mihehas hehi houlu ka hesakin atas hehilelau en kami.” Ka min aman keil viteni vit, “Kami mun, mihehas hehi houlu ka hesakin out netan hehilelau en kami.” ");
INSERT INTO pma_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ka vongien va, meneai mai, koanek vi avong elim (5). ");
INSERT INTO pma_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Evus, Ahi viteni vit, “Maen tounah vasi koa moul keil ikikistal en out netan: koakeil amah, ka koakeil ten eivorohus; koakeil amarite, ka koakeil avi havipi.” Ka mai kistal suval koa viteni. ");
INSERT INTO pma_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Sakini, Ahi mumon keil vasi, ka lesi keke atahos. ");
INSERT INTO pma_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Evus, Ahi viteni vit, “Ekek, tovoumon meatin koa hesuval iatel. Ka tounah sav keil ten out netan hel en hen: mesau keil ka aman keil; tirendan keil koa amah ka koakeil ten eivorohus; koakeil amarite, ka koakeil avi havipi.” ");
INSERT INTO pma_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Sakini, Ahi mumon meatin, mumoni suval kei enges. Tai mumoni vi meahos, ka tamun mumoni vi ahin. ");
INSERT INTO pma_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ka kei san tokolkatien onen min keilu ka viteni vit, “Milhekur titamil keil ihi houlu ka milhesakin keil ihilelau en out netan. Ka niling tounah keil koa moul en out netan hel en hemil: mesau keil ten atas, aman keil koa amuka en teilang, ka tounah sav emun koa amul en out netan. ");
INSERT INTO pma_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","?Millesi? En out netan, namumon tounah tateisav avitehiteh: koakeil aling utite, koakeil aling aneite, ka koakeil ason heite. Keil vasi taanien. ");
INSERT INTO pma_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ka min tounah sav keil koa amoul en out netan, nasan oumunai ka ouai keil iani. Nasani min tirendan keil ten out netan ka aman keil amuka en teilang: koakeil amarite ka koakeil avi havipi.” Ka kistal suval koa viteni. ");
INSERT INTO pma_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ahi les tounah vasi koa kei mumoni keke atahos imok. Vongien va, meneai mai, koanek vi avong ahetai (6). ");
INSERT INTO pma_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","En sakien enek, Ahi mum vasi out nesa, out netan, ka tounah vasi keil koa amul ien en avong ahetai (6). ");
INSERT INTO pma_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ka en avong koa oulu (7), kei museh en umen onen. ");
INSERT INTO pma_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Sakini, kei ling koe avong oulu (7) vi votut. Veni en avong enek, asa koa mumoni en out netan evus ka kei museh en umen onen. ");
INSERT INTO pma_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Koanik vi tunien usil asa kur out en avong Iahova mumon out nesa ka out netan. En avong koa Iahova mumoni, ");
INSERT INTO pma_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","vatiai keil tovuol veah ka utiai mun rovitehitehtei veah en out netan veni Iahova rosakintei ous vous. Ka meatin keil tovuol veah avoum revi atan. ");
INSERT INTO pma_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Ka en avong enek, tilep kistal ran atan ka kas vasi out netan. ");
INSERT INTO pma_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Evus, Iahova kur hati atan tai ka mumon meatin eni. Mumoni evus, museh en eang onen ten moulien va en vulingasin, ka meatin moul mea. ");
INSERT INTO pma_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","En out koa ist, Iahova mumon mari ah tai en out koa avise en ‘Iden.’ Ka en out enek, kei ling meatin koa mumoni mul ien. ");
INSERT INTO pma_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Ka en ah koanek, Iahova sakin mormore vatiai tateisav vasi keil amoul ason heite tahos imok. Ka luhu en ah enek, vatiai elu lumul ien: tai koa heite teni kilea vasan moulien ten lisenges, ka tamun koa heite teni kilea vasan ileilien ten asa koa tahos ka asa koa tisa. ");
INSERT INTO pma_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Evus, Iahova ling meatin en Ah Iden, voum en atan ka valosil kati. ");
INSERT INTO pma_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Ka viteni mini vit, “Keik kokilea kovaan heiai vasi keil koa amul en ah ekok. ");
INSERT INTO pma_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Ka vatiai tas koa kilea vasan ileilien ten asa koa tahos ka asa koa tisa navong kokan heite teni, vatiai enek konaantei varei heite. Veni en hati avong koa kiani, kimat.” ");
INSERT INTO pma_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Evus, Iahova viteni vit, “Rotahostei keke meatin vato sasen. Numon meatin tamun hekatauni, ka keilu luheto out hetas.” ");
INSERT INTO pma_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Sakini, tirendan vasi keil ka aman keil koa Iahova mumon keil tuai en atan, lah ruain keil umai ven meatin enek keke valesi ka valing ise. En sise enek, keil akur ise. ");
INSERT INTO pma_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Mukonek, meatin enek ling isen aman vasi keil ka en tirendan keil emun. Ka rovotin etai koa vavinvin vato vatal mini ka vakatauni. ");
INSERT INTO pma_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Sakini, Iahova mumon meatin meten mulong ka matil ravobong. Ka navong kei matil, kulat sin tai ten koun, ka mum revi aven eris. ");
INSERT INTO pma_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","En sin enek, mumon ahin eni, ka kuri va min meahos. ");
INSERT INTO pma_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ka navong meahos lesi vit, “Anatin eli, koanek suval inau varei. Sin amumoni ran sik; aven amumoni ran avek. Sakini, niling isen hehi ‘ahin’ veni kei kistal ran meatin.” ");
INSERT INTO pma_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Ven koanek, meahos hemea ran tata ka mama onen, ka heapil hetal min ahin onen, ka keilu luhetas. ");
INSERT INTO pma_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ka meahos keilu ahin lukaka hon, ka lurmemoutei eni. ");
INSERT INTO pma_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","En Ah Iden, tetal tai mul ien koa ongon kas mulin tirendan vasi keil koa Iahova mumoni. Kei mai ka vis ahin enek, “?Anatin keke Ahi viteni min kamil vit milherkantei heiai ten vatiai vasi koa mul ekok?” ");
INSERT INTO pma_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Ka ahin vit risi mini vit, “Melkilea melvan heiai vasi keil koa mul en ah ekek. ");
INSERT INTO pma_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Ka vatte tas koa mul luhu keke Ahi vit koe vit melherkantei ka melhertokoltei. Veni munak melheani vuo melhetokoli, melhemat varei.” ");
INSERT INTO pma_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Ka tetal vit risi, “Koanik rovitei anatin. Milsakras milvamat. ");
INSERT INTO pma_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Ahi viteni mukonek veni kilea keke munak milheani, ileilien onamil hemai hesuval kei, ka milheilea asa tahos ka asa tisa.” ");
INSERT INTO pma_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Evus, ahin lesi keke vatiai enek tahos imok, ka heite teni mun tahos taanien. Ka en vati vasak visi vakur ileilien. Sakini kur heite koan ka kani. Evus, san koan min meatin onen, kei mun kani. ");
INSERT INTO pma_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Hatte tas, rendemien onealu maluv ka lukileile, ka lulei kilea suk keke lukaka hon ka lumemou veni. Sakini, lulah ou fik keil, lupar ruaini ka lukav koe keilu eni. ");
INSERT INTO pma_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","En mendilah enek, luraengon Iahova mul retoun en ah. Navong luraengoni, luro suai en vatiai keil. ");
INSERT INTO pma_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Ka Iahova vise meatin vit, “?Meatin? ?Keik kave?” ");
INSERT INTO pma_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ka meatin vit risi mini vit, “Naraengonuk koretoun en ah, ka nametau veni inau nakaka hon. Sakini, naro suai enuk.” ");
INSERT INTO pma_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Iahova visi vit, “?Isei viteni vit keik kovakaka hon? ?Mukave? ?Keik kokan heiai koa naviteni navit konaantei?” ");
INSERT INTO pma_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ka meatin viteni vit, “Ahin koa kolingi ro ral minau san heiai enek minau, nakani.” ");
INSERT INTO pma_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Ka Iahova vis ahin vit, “?Vensa komumoni mukok?” Ka kei viteni mini vit, “Amot luvos nau, sakini nakani.” ");
INSERT INTO pma_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Evus, Iahova viteni min tetal vit, “Ven koa komumoni mukok, nisan mahien minuk kos en tirendan vasi keil ka tounah sav koa amoul. Mahien koa nasani minuk ekek: kosa hetokol keite ten moulien onom, en avong vasi keil, kikea en vangom ka vulimeas hel en ongom lises. ");
INSERT INTO pma_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Numon keik hetal min ahin, tinomil heat kamil, ka titam ka titan ahin, tine mun heat keil. Titan keil ititi lin vatum, ka keik, kiat ale tanetan.” ");
INSERT INTO pma_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ka Iahova viteni min ahin vit, “Numon keik kilonge hetisa navong kikur titam, eisilum hemah hemariso. Avaseini kilong mahien, ka kiles kindem kat meatin onom, ka kei hehi avat minuk.” ");
INSERT INTO pma_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ka Iahova viteni min meatin vit, “Keik kolong ren ahin onom, ka korlong kattei nau. Kokan heiai koa naviteni minuk navit konaantei. Ven asa koa komumoni, sesendaen hel en atan. Sakini, en avong vasi en moulien onom, keik kum hekeih keke kumon anien keil ikistal ien. ");
INSERT INTO pma_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Oumunai tatisa hehi houlu hehitehiteh ien ka hesar koe anien am. Ka avong tei, kian anien enges ten eivorohus. ");
INSERT INTO pma_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","En avetin ten umen onom, kikur tounah taanien heha vis … kimat, ka kimai ris kihi atan. Veni keik, namumonuk en atan, ka kiha ris en atan.” ");
INSERT INTO pma_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Meatin koa mulamu, isen ‘Adam’ koa aneite teni vi ‘meatin.’ Ka en ahin onen, kei ling isen ‘Iv’ koa aneite teni vi ‘moulien’ veni kei vi mama onen meatin vasi keil koa amoul en out netan. ");
INSERT INTO pma_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Ka Iahova mumon eisin omealu en hiliven tirendan ka sani min keilu lumusin koe keilu eni. ");
INSERT INTO pma_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Lumusin evus, Iahova selus sasen vit, “Ekek, meatin mai suval iatel keke lumai lukileile en asa tahos ka asa tisa. Mukonek, tehermaentei keilu luhekur heiai tamun ran vatiai koa kilea vasan moulien ten lisenges. Veni munak luheani, lusakras luvamat.” ");
INSERT INTO pma_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Sakini, Iahova sila lat keilu ran Ah Iden. Ka mumon keilu lumum en atan koa kei mumon keilu eni. ");
INSERT INTO pma_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Kei sila lat keilu evus, ling angelo keil koa avise keil en ‘Sereb’ avalei kokoe meteau ten Ah Iden en usite koa ist. Ka Iahova ling naef koa ahang vilhili eni ka mul vilehiles val koe sise vaha en vatiai koa san moulien ten lisenges. ");
INSERT INTO pma_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Evus, Adam ro ral min ahin onen ka kei meas en titiali tai. Avong muli, ka kur titiali tai ka ling isen vi ‘Ken’ koa aneite teni vi ‘nakuri’ veni viteni vit, “Ven kataunien onen Iahova, inau nakur ehon tai.” ");
INSERT INTO pma_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Katau suk, Iv meas eris. Ka avong mai vinvin, kur titiali tamun, ka ling isen vi ‘Ebel.’ Navong lumoul lumai lumarite, Ebel mai vi meatin koa mul lei kat sipsip keil, ka Ken mai vi meatin koa mum en ah. ");
INSERT INTO pma_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Sua vahis muli ka en avong tai, Ken vit vasan ui umen onen min Iahova. Sakini lah anien tei koa luhi, ka sani vahi sanien votut onen ten masmasien min Iahova. ");
INSERT INTO pma_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Evus, Ebel emun kur ui umen onen koa vi moeite ten sipsip tai esen, muasi mat, ka san usiven keil tetahos vahi sanien votut onen ten masmasien vina min Ahi. Ka Iahova lele tahos en Ebel ka sanien votut onen. ");
INSERT INTO pma_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Ka en Ken ka sanien votut onen, lei seseini. Sakini, Ken tin tisa ka vurohien sakin nan langlango. ");
INSERT INTO pma_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Evus, Iahova viteni min Ken vit, “?Vensa komul kovuroh mukonek? ?Vensa nam langlango? ");
INSERT INTO pma_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Munak komumon sakien koa mal, kimai kimal en metok. Ka munak komumon sakien koa tisa, tisaen mul suai vapurunuk suval tirendan tisa tai. Tisaen enek vit vahi hetetamen en moulien onom, ka keik esuk, kuasi heha netan ka kimai kihi hetetamen eni.” ");
INSERT INTO pma_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Evus, Ken viteni min tunali vit, “Lovamea ran out ekek, lovoual lovaha nah.” Ka navong lurokol out enek, Ken viles min tunali ka muasi mat. ");
INSERT INTO pma_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Evus, Iahova vis Ken vit, “?Tumali Ebel kave?” Ka Ken vit risi mini vit, “Nareingeingeni. ?Inau keke nil nilei kat tuak onak?” ");
INSERT INTO pma_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Ka Iahova viteni mini vit, “?Ken, komumon sa? ?Korraengontei? !Ran tumali mul murang minau ran atan vit kihinat asa koa komumoni! ");
INSERT INTO pma_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Sakini, sesendaen hel enuk keke atan hersantei mun anien minuk, veni mun ran tumali koa komu vini. ");
INSERT INTO pma_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Navong kiluh vis etai tounah, atan hersan kestei ui umen onom. Ka keik, lises kilohosai ran meatin sav keil ka out tato revi ien onom hetovuol.” ");
INSERT INTO pma_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Sua vahis muli, Adam ro ral min ahin onen ka Iv meas eris ka kur titaealu tamun koa meahos. Ling isen vi ‘Set’ koa aneite teni vi ‘sani’ veni viteni vit, “Ahi san ris titiali tamun vakur vulin Ebel, koa Ken muasi mat.” ");
INSERT INTO pma_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Navong Set mai mariso, kur ahin tai. Ka navong ro ral mini, ahin onen kur natnali tai ka ling isen ‘Inos.’ En hati avong enek, meatin keil avita netan min Ahi ka avise rohtoh en ‘Iahova,’ isen kati koa vi votut. Set, moeite onen vi Inos. Inos, moeite onen vi Kenan. Kenan, moeite onen vi Mahalalel. Mahalalel, moeite onen vi Sered. Sered, moeite onen vi Inok. Inok, moeite onen vi Metuselah. Metuselah, moeite onen vi Lamek. Lamek, moeite onen vi Noah. Ka Noah, natnali etel, Sem, Ham ka Sevet. Meatin keil enek aka en vatiamal onen Adam ka moulien one tetaveah. Keil akur titae houlu mok ka avilelau en out vasi. Ka houlu en keil armusiltei mun Ahi. ");
INSERT INTO pma_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Navong meatin keil umai avi houlu en out netan, Iahova les sakien keil one rotahostei. Rendemien one vilelau en tisaen lisenges. ");
INSERT INTO pma_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Sakini, Iahova tin mah ven sakien one, ka longe tisa ven meatin keil koa kei mumoni. ");
INSERT INTO pma_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Sakini, viteni min kei sasen vit, “Koakeil namumoni ekek, nu rasilin keil ran out netan. Keil ral min tirendan keil, aman keil, ka tounah keil emun koa amoul, veni nalonge tisa houlu vis houlu mok ven keil. Tahos imok vahit marmumontei keil.” ");
INSERT INTO pma_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ka meatin tanges, Iahova si veni, isen Noah. ");
INSERT INTO pma_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Koanik tunien usil Noah. En avong onen, kei enges vi more meatin koa musil kat Ahi en moulien onen ka sakien keil onen mutolas. ");
INSERT INTO pma_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Kei, natnali etel: Sem, Ham ka Sevet. ");
INSERT INTO pma_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Ka meatin sav vasi keil en out netan artahostei en meten Ahi. Keil asakin out netan vilelau en huhuen keil. ");
INSERT INTO pma_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Ahi lele mita netan, ka lesi keke tounah tisa revi mok, veni tounah vasi koa amoul amusil sakien tatisa keil enges. ");
INSERT INTO pma_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Sakini, en avong tai, Ahi viteni min Noah vit, “Namundemi navit nu rasilin tounah vasi koa amoul, veni asakin out netan vilelau en huhuen keil. Anatin, keil vasi en out netan nu rasilini varei. ");
INSERT INTO pma_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Sakini, kumon mari sip tai koa kilea voulal. Kumoni en ai tetahos, kiti kokoteh out neim eni, ka kiting koe en koltar neim ka hae keke oai sakras vaha neim. ");
INSERT INTO pma_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Kumoni hemukok: mita ten taveah teni hehi handred tai ka hanumau elu ka halualim emun (150 m), mita ten aven hehi hanumau tai ka elim (25 m), ka mita hehina nesa hehi teindan elim (15 m). ");
INSERT INTO pma_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Hoite teni helin uriov en hap mita (½ m). Ka en out neim, kumon out toualien hetel: tai hel nesa, tai hel luhu, ka tai hel netan. Ka en valite, kumon voiteh hetas. ");
INSERT INTO pma_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Kumoni hemukonek ven inau, numon oai hemai hemarite ka hemai hetaluh koe out vasi. Ka houe, hou vasin tounah keil koa amoul en out netan. Keil vasi imatmat varei. ");
INSERT INTO pma_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ka keik, inau numon hatkatien takeih hetal minuk keke nikur koe keik ka onom keil. Miheha en mari sip enek: keik, ahin onom, ka titam keil hetal min ahin one keil. ");
INSERT INTO pma_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","“En mari sip enek, kikur tirendan vasi keil ka aman vasi keil helualu, tai koa meahos ka tai koa ahin. ");
INSERT INTO pma_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","En tounah vasi koa moul en out netan kumoni vatinetinek: elu en koakeil amuka, elu en koakeil amual, ka elu en koakeil akekelau. Kisakin keil imoul hetal min kami. ");
INSERT INTO pma_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Evus, kikur anien tateisav vasi keil koa hehi ami ka ae, ka kiling revi en mari sip enek.” ");
INSERT INTO pma_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Ka Noah mum vasin tounah koa Ahi meng kati mini voumoni. ");
INSERT INTO pma_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Navong Noah keitel telmum vasi mari sip enek, Iahova viteni min Noah vit, “Kiha en mari sip hetal min onom vasi keil. Veni inau, navotini keke keik tas en out netan komumon asa koa mal en metok. ");
INSERT INTO pma_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Kikuri hetal minuk buluk ka sipsip keil koa kokilea kovouas keil avahi ten sanien, teindan ehat (14) en tateisav keil, oulu (7) koa ihi meahos ka oulu (7) koa ihi ahin. Ka en buluk ka sipsip keil koa armutotei en metok, kikuri helu enges en tateisav keil, meahos tai ka ahin tai. ");
INSERT INTO pma_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Ka aman keil emun, kumoni vatinetinek en tateisav keil, kikur oulu (7) koa ihi meahos ka oulu (7) koa ihi ahin. Hesakini, keil vasi enek akilea imoul ka ihasi ris titae. ");
INSERT INTO pma_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Kumoni hemukonek veni avong oulu (7) sesuk keke nisan mari ous hous. Ous hous meneai ka vongien heha vio … hetokol avong hanumau elu (40). Ka en avong enek, tounah sav vasi keil koa amoul koa namumon keil, inau nu lin keil ran out netan.” ");
INSERT INTO pma_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ka Noah mum vasi tounah koa Iahova meng kati mini voumoni. ");
INSERT INTO pma_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Ka navong amulamun meahos keilu ahin ten tounah tateisav keil koa amoul en out netan uva neim en mari sip tuai, suval koa Iahova meng kati, Iahova koteh kat voiteh. ");
INSERT INTO pma_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Evus, ous mus vis mus, romusehtei rokol avong hanumau elu (40). Oai vilelau en out vasi, ka sakin mari sip enek moulal eni. ");
INSERT INTO pma_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","En sise koanek, Iahova mu lin vasi tounah keil koa amoul en out netan: meatin keil, tirendan keil ka aman keil emun. Ka Noah enges sesuk moul, ral min koakeil emun amul en mari sip enek ral mini. ");
INSERT INTO pma_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Evus, Ahi viteni min Noah vit, ");
INSERT INTO pma_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Keik hetal min ahin onom ka titam keitel hetal min ahin one keil, mihemea ran mari sip ekek. ");
INSERT INTO pma_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Aman keil ka tirendan vasi keil, kilokovein keil vasi isisital. Keil ihaha ika vasi out, ka ihasi titae keil ihi houlu mok.” ");
INSERT INTO pma_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Sakini, Noah keilu ahin onen, titan keil ral min ahin one keil asital. ");
INSERT INTO pma_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Tirendan vasi keil ka aman vasi keil asisital ran mari sip enek, ka keil uva ral min one keil. ");
INSERT INTO pma_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Evus, Noah mumon avet tai ten sanien min Iahova, ka kur retai en buluk ka sipsip keil ka aman keil koa amuto en meten Ahi. Evus, muas keil, munit keil, ka ahang kan vasin ave keke vatie lat masmasien one mini. ");
INSERT INTO pma_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Ka navong vite ten sanien enek vina nesa, Iahova musi tahos ka si veni. Sakini vit sasen eni vit, “Nirsantei mun mahien en out netan ven sakien tisa onen meatin keil. Veni nakilea keke navong keil avi ehon rokol avong umat, e vati avousil sakien keil ten tisaen enges. Nirmu lintei mun tounah keil koa amoul en out netan suval koa namumoni ekek. ");
INSERT INTO pma_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“Navat kati keke: Kosa hetokol keite ten out netan, avong ten tounah vasi hemai hekistal: avong taluhluhien ka avong tasuhutien, avong ten anni ka avong out hetin, avong ten ous ka avong ten annimes. Ka meneai keilu vongien luhemai lises ka lisenges.” ");
INSERT INTO pma_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Evus, Ahi san tokolkatien min Noah ka ehon onen keil vit, “Titami keil ihi houlu vis ihi houlu mok hesakin out vasi netan hehilelau en keil. ");
INSERT INTO pma_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Tounah vasi keil koa amoul en out netan imetaun kami: tirendan keil, aman keil ka mesau keil emun. Keil vasi, naling moulien one en hemi. ");
INSERT INTO pma_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Mulamu, nasan heiai ka aneite ten anien enges min meatin keil akani. Ka kosa, nisan vuseri emun min kami taanien. ");
INSERT INTO pma_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Ka minaantei vuseri koa ara mul veah eni veni ara vi vatte ten moulien onen. ");
INSERT INTO pma_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","“Ka en usite ten ran meatin, munak meatin tai houas meatin sav hemat, inau, nisan mahien mini. Ka tirendan keil emun koa uas meatin tai hemat, nisan mahien emun mini. ");
INSERT INTO pma_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Meatin keil, namumon keil asuval nau. Sakini, munak meatin tai houas meatin sav hemat, kei mun, uasi hemat varei. ");
INSERT INTO pma_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","“Ka kami, ek vati keke titami keil ihi houlu, hesakin keil ihilelau en out vasi netan.” ");
INSERT INTO pma_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Evus, Ahi viteni mun min Noah ka min titan keitel vit, ");
INSERT INTO pma_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Ekek, inau namumon hatkatien takeih ral min kami ka ral min onami keil koa ikatau en kami. ");
INSERT INTO pma_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Namumoni mun ral min tounah vasi keil koa amoul: tirendan ka aman keil, ka tounah vasi keil koa amemea ral minuk ran mari sip enek. ");
INSERT INTO pma_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Navat kati keke nirmu lintei mun tounah vasi koa amoul hetal oai. Anatin, oai hermu lintei mun out netan. ");
INSERT INTO pma_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Hatkatien enek, namumoni ral min kami ka tounah sav keil koa amoul en out netan, ka nitie lati hetal min metai tai. ");
INSERT INTO pma_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","?Milesi? Naling mitiet koanik mul en mahmah ten teilang. Ka navong vasi koa meatin keil ilesi, indem kati keke hatkatien onak vi anatin. ");
INSERT INTO pma_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Sakini, navong nakav koe out netan en mahmah ten ous, mitiet emun hekistal. ");
INSERT INTO pma_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Ka navong nilesi, nindem kat hatkatien takeih onak koa namumoni ral minuk ka ral min tirendan vasi keil keke nirmu lintei mun keil en mari oai tai.” ");
INSERT INTO pma_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","En avong mulamu, meatin vasi keil ten out netan aselus en selusien tas. ");
INSERT INTO pma_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Ka navong umai avi houlu vis avi houlu mok, amual en out koa ist. Amual va vio … ales mari out tai koa vi aet koa mul en mari atan koa avise en ‘Saenar.’ Keil amundemi avit tahos keke avato ien. ");
INSERT INTO pma_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Evus, keil aviteni min keil eris avit, “!Almai! Tahos keke rehoumon brikis en tanvili koanik ka rehetan keil en avul tai hemai hekeih.” Sakini, keil amumon eim keil one en brikis keil enek ka akapil vituaini en koltar. ");
INSERT INTO pma_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Amumoni evus, ka aviteni avit, “Almai, rehoumon mari meteimal tai hetal min mari eim tai koa vahina nesa vatokol teilang. Koanek hesakin ir rehertasiltei ka meatin sav keil ilonglong en iser.” ");
INSERT INTO pma_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Evus, Iahova mita netan ka les mari meteimal ka mari eim koa vina nesa koa keil amumoni. ");
INSERT INTO pma_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Navong lesi viteni vit, “Telmali, meatin keil eke amul amumon marmari tounah. Keil amum out tas ka selusien one tas. Koanek vi vatte ten umen one. Ka hervitei tuetin, keil ilea um vasi asa koa iling rendemien one eni. ");
INSERT INTO pma_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Mukonek, tovahita netan ka tovahilehiles selusien one vasakin keil irlong kileatei keil eris.” ");
INSERT INTO pma_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Sakini, Iahova riti rasilin meatin keil en out netan avaha, ka armum vasitei mari meteimal enek. ");
INSERT INTO pma_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Sakini, avise mari meteimal enek en ‘Babilon’ koa aneite teni vi ‘vilehiles’ veni en out enek, Iahova vilehiles selusien onen meatin vasi keil ka riti rasilin keil vasi en out netan. Meatin keil arasil aro en out sav keil va vio … meatin tai avasi en vatiamal onen Sem, natin Noah, isen Ebram. ");
INSERT INTO pma_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","En avong tai, Iahova viteni min Ebram vit, “Kimea ran out onom, onom keil, ka teim sen tata onom. Kiha en out tai koa inau, nitie minuk. ");
INSERT INTO pma_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Mukonek, nisakin vatiamal onom hehi houlu mok, hemai hehi mari vangi meatin tai en out netan. Nitokol katuk ka numon isom heka vasi out ka meatin keil ilonglong eni. Ka heka enuk, tokolkatien onak heha min meatin keil ten out netan. ");
INSERT INTO pma_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Koakeil asan selusien ten tokolkatien minuk, inau nisan tokolkatien min keil. Ka koakeil asesenda enuk, numoni hetisa en keil. Ka keik kihi sise ten tokolkatien onak heha min vatiamal vasi keil ten out netan.” ");
INSERT INTO pma_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Sakini, navong Ebram long kat ren Iahova ka mea ran out Haran, sua onen rokol hanumau etel ka teindan elim (75). ");
INSERT INTO pma_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Ebram kur ahin onen, isen ‘Serae.’ Ka titan tunali mun musili, isen ‘Lot.’ Tounah vasi keil oneatel ral min slev keil one ka buluk ka sipsip keil emun eseatel koa tellei kati en out Haran avi houlu ramat. Ka tounah vasi, telsak meseini keke avakuri. Navong asak mesein tounah keil evus, amual avaha en out Kenan. Avong telrokol out Kenan, ");
INSERT INTO pma_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Ebram ka meatin keil onen aka pas kantri enek va vio … umai en out koa avise en ‘Sekem.’ Ka en out enek, en out koa avise en ‘Morah,’ amumon votevav keil one vesesal en mari vatiai tai koa matu vis matu, out koa meatin sav keil uva netan min ahi keil one ien. (En avong koanek, koakeil ten out Kenan avi horetan veah en out enek.) ");
INSERT INTO pma_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Evus, Iahova mai kistal ven Ebram ka viteni mini vit, “Atan ten out enek, nisani min koakeil ika en vatiamal onom.” Evus, Ebram kur mari ahat keil ka mumon ahor ten sanien keke vanit sanien votut vahina min Iahova koa mai kistal veni. ");
INSERT INTO pma_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Titan tunali Ebram musili, isen Lot, kei ral min ahin onen, titan keil ka meatin toumien onen keil. Ka keil akur sipsip, buluk, ka nani ese keil emun. ");
INSERT INTO pma_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ka ven buluk ka sipsip keil esen Lot ka Ebram avi houlu ramat, oumunai ae rovinvintei avato out vatas. ");
INSERT INTO pma_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ven koanek, Ebram viteni min Lot vit, “Hetahos lehetasil ekok. Keik kihiten etai hati atan koa keik em vati, ka inau, niha en out sav.” ");
INSERT INTO pma_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lot lei rahit out, ka les Oaisal Sodan ka hou keil koa amul vesesal veni va rokol meteimal ten out Soar. Lesi tahos imok suval Ah Iden koa Iahova luhi, vuo suval atan ten out Isip koa Oaisal Nael mul ien. (En avong koanek, Iahova romu rasilintei veah taon ten out Sodom ka Komorah.) ");
INSERT INTO pma_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Sakini Lot kur out vasi koa vesesal ven Oaisal Sodan vi onen enges. Ven koanek, keilu luka rasil en out enek, ka Lot mea va en out ist ral min tounah keil onen. ");
INSERT INTO pma_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Ebram ro nges en out Kenan, ka Lot vita mumon votevav keil onen vesesal en taon ten out Sodom. ");
INSERT INTO pma_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Ka meatin keil ten out enek asak kalkali ka tisaen one houlu en meten Iahova. ");
INSERT INTO pma_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Navong Lot va ran Ebram, Iahova viteni min Ebram vit, “En out koa koro ien kisepat, kilele rahit out vasi keil. ");
INSERT INTO pma_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Out vasi keil enek koa komul kolesi, nisani minuk hetal min vatiamal keil koa ika venuk. Hehi onami enges lises ka lisenges. ");
INSERT INTO pma_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Vatiamal keil onom koa nisani minuk hehi houlu vis hehi houlu mok. Suval meatin sakras vahuli nehi atan vasi keil ten out netan, hesakras vahuli vasin onom keil. ");
INSERT INTO pma_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Ekek, kiha kual kiles atan vasi keil enek ven inau nisa vasi minuk.” ");
INSERT INTO pma_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Sakini Ebram mea va ral min onen keil, uva vio … arokol out Hibron. Ka amumon votevav keil ome en out koa avise en ‘Mamre,’ vesesal en mari vatiai koa matu vis matu, out koa meatin sav keil uva netan min ahi keil one ien. Ka en out enek, Ebram kur mari ahat keil ka mumon ahor ten sanien ka munit sanien votut vina min Iahova. ");
INSERT INTO pma_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Evus, Iahova selus min Ebram en leisanien tai vit, “Ebram, konametautei. Nikur koe keik en avong keil takeih ka nisan sanien tai minuk koa hemarite mok ven longkatien onom.” ");
INSERT INTO pma_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Ka Ebram vit risi mini vit, “?Iahova, sanien koanek hekataunau hemukave, veni titiali onak tovuol veah? Meatin koa vi houlu en teim onak hekur vasi tounah onak navong nimat, isen Eliesar ten out Damaskas. ");
INSERT INTO pma_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Anatin, kei koa vi slev enges onak koa avasi en teim onak hekur vasi tounah onak veni korsan etai titiali minau.” ");
INSERT INTO pma_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Evus, raengon Iahova selus eris mini vit, “Slev Eliesar enek herkurtei vulum ka tounah vasi keil onom. !Vuo! Ehon kati onom, kei enges hekur vulum ka tounah vasi keil onom.” ");
INSERT INTO pma_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Evus, Iahova mulamuni va hae ka vit, “Kilele hehina nesa en teilang ka kihuli vis hitu keil. Kosakras. Ka vatiamal keil onom isuval hitu keil enek.” ");
INSERT INTO pma_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Sakini, Ebram ling demkatien onen en hatkatien onen Iahova. Ka ven koanek, Iahova si veni ka les moulien onen mal en meten. ");
INSERT INTO pma_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sua houlu muli, ka Serae koa vi ahin onen Ebram, rokur etai titaealu. Ka kei kur slev tai koa vi ahin Isip, isen Hakar. ");
INSERT INTO pma_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Ka Serae viteni min meatin onen vit, “Iahova sakinau nasakras makur ehon. Sakini, keik kikur ahin toumien onak ka kimatil hetal mini. Vahesa nakilea makur etai ehon heka eni vahi titaralu.” Navong Ebram longe, maeni. ");
INSERT INTO pma_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Sakini, Serae san Hakar mini ka kei kuri. Koanek kur out avong aro en out Kenan sua halualim (10). ");
INSERT INTO pma_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Avati vahis muli, ka Hakar kur titan Ebram, ka kei ling isen ‘Ismael’ koa aneite teni vi ‘Ahi raengoni.’ ");
INSERT INTO pma_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","En avong koanek, Ebram, sua onen vi hanumau ehat ka ahetai mun (86). ");
INSERT INTO pma_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Navong Ebram, sua onen vesesal vatokol handred tai (99), Iahova kistal veni ka viteni mini vit, “!Inau, navi Ahi ten keihoen! Kilong kat nau ka lises kumon tounah koa mal en metok. ");
INSERT INTO pma_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Num ris hatkatien takeih hetal minuk ka numon vatiamal keil koa hekistal enuk hehi houlu mok.” ");
INSERT INTO pma_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Ebram malingling mini, nan rokol atan. Ka Ahi vit risi mini vit, ");
INSERT INTO pma_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Inau namumon hatkatien koanek ral minuk: navat kati keke vatiamal keil onom imai ihi mari vangi meatin houlu. ");
INSERT INTO pma_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Sakini, isom hervitei mun ‘Ebram,’ ka hehi ‘Ebraham’ veni numonuk kihi mari avu onen mari vangi meatin houlu. ");
INSERT INTO pma_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Nisakin vatiamal keil koa ikistal ika enuk imai ihi mari kantri keil, ka keil koa imai ihi asuv houlu keil.” ");
INSERT INTO pma_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Ka Ahi vit risi min Ebraham vit, “Hatkatien takeih onak, keik kusil kati, keik hetal min vatiamal onom keil koa ikatau enuk. ");
INSERT INTO pma_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Keik ka onom keil mihemaeni mivoumon vekahoi min ehon vasi keil onami. ");
INSERT INTO pma_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Ekek, navong mihoumon vekahoi en ehon keil onami, hetie lati keke mimusil hatkatien takeih oralu. ");
INSERT INTO pma_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","En avong keil koa hemai, koakeil en kami koa avi meahos iha en vekahoi navong avong one vi oulim (8). Slev onami keil koa mikuri en out sav ral min titae keil koa avasi en teim onami. ");
INSERT INTO pma_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Keil vasi iha en vekahoi. Mukonek, out koa amumon vekahoi eni en avemi hetie lati min meatin keil vasi keke mimusil kat hatkatien takeih onak koa reingeingeni vavus. ");
INSERT INTO pma_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Munak meatin etai hervatei en vekahoi, hervitei mun meatin tai onak, veni kei rolong kattei hatkatien takeih onak.” ");
INSERT INTO pma_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Ka Ahi vit risi min Ebram vit, “Ahin onom, kirvisetei mun en ‘Serae.’ Kosa heha, isen hehi ‘Serah.’ ");
INSERT INTO pma_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Nitokol kati ka nimaeni hekur ehon tai onamil. Numoni hemai hehi mama ten mari vangi meatin keil ka asuv houlu emun keil ikistal rani.” ");
INSERT INTO pma_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ebraham malingling ven Ahi, nan rokol atan, ka mul viteai min kei sasen. En rendemien onen vit, “?Meatin kilea vasan ehon min ahin tai navong sua onen rokol handred tai (100)? ?Ka Serah emun kilea veah vakur ehon navong sua onen rokol hanumau ehat ka halualim emun (90) tuai?” ");
INSERT INTO pma_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Kei vis Ahi vit, “?Kosakras kovamaeni li keke Ismael vakur tokolkatien koa kosani minau?” ");
INSERT INTO pma_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Ka Ahi vit, “!Vuo! Ahin onom, Serah, hekur ehon tai onamil, ka kiling isen hehi ‘Aesak.’ Hatkatien takeih koa namumoni ral minuk, num risi hetal mini ka hetal min vatiamal onen lises ka lisenges. ");
INSERT INTO pma_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ka naraengon asa koa koviteni minau usil Ismael. Hesakini, nitokol kati ka titan keil emun ihi houlu vis ihi houlu mok. Hehi mari tata ten vatiamal teindan elu (12) koa imai ihi mari vangi meatin tai. ");
INSERT INTO pma_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ka hatkatien takeih onak, numoni hetal min natmali Aesak koa Serah hekuri en avati koanek en sua koa hemai.” ");
INSERT INTO pma_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Navong Ahi selus evus, va rani. ");
INSERT INTO pma_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","En avong etin enek, Ebraham long kat Ahi ka mumon vekahoi en meahos vasi keil koa aro ral mini: Ismael, slev keil onen ka meatin sav keil koa amusili. ");
INSERT INTO pma_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ebraham, sua onen rokol hanumau ehat ka teindan ouhat emun (99) navong va en vekahoi. ");
INSERT INTO pma_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Ka Ismael, sua onen en avong koanek rokol teindan etel (13). ");
INSERT INTO pma_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Ebraham ka natnali, keilu vasi luva en vekahoi avong tas, ");
INSERT INTO pma_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","ral min slev keil onen. ");
INSERT INTO pma_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Suval koa Iahova vat kati, rokol kat Serah. ");
INSERT INTO pma_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sakini kei meas ka mal en avong koa Ahi vat kati, kur titan. Anatin, navong Ebraham vi ulmatu tuai, Serah kur ehon tai onealu. ");
INSERT INTO pma_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ebraham ling isen vi ‘Aesak’ koa aneite teni vi ‘viteai,’ ");
INSERT INTO pma_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","ka navong avong onen rokol ouhat (8), Ebraham mumoni va en vekahoi suval koa Ahi vat kati mini. ");
INSERT INTO pma_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Ebraham, sua onen handred tai (100) navong Aesak avasi. ");
INSERT INTO pma_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Ka Serah vit, “Ahi san sien houlu minau ka sakinau naviteai. Koakeil vasi itaengoni ihiteai hetal minau. ");
INSERT INTO pma_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","?Isei kilea vahitehiteni min Ebraham keke inau etin, nitounat en titiali tai? Mukos navi tovuli, ka nakur titan ulmatu onak.” ");
INSERT INTO pma_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Titiali enek moul, ka navong lokovein susu omon, tata onen mumon mari anien tai. ");
INSERT INTO pma_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","En avong ten anien enek, Ismael, natin Hakar ten out Isip, mul rohtoh karen Aesak, natin Serah. ");
INSERT INTO pma_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Navong Serah lesi, viteni min Ebraham vit, “Sila lat ahin toumien enek keilu natnali luvaha. Naman kivuol navong etai, natin ahin enek nakur etai tounah keil onom koa hehi onen natkuli Aesak.” ");
INSERT INTO pma_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Koanik sakin Ebraham rendem houlu ven Ismael emun vi natnali keinek. ");
INSERT INTO pma_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ka Ahi viteni min Ebraham vit, “Konandemkotei en ehon enek ka mama onen koa vi slev onom. Kumon asa koa Serah viteni minuk veni vatiamal keil koa navat kati minuk, keil ikistal ika en Aesak. ");
INSERT INTO pma_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ka en Ismael, natin ahin toumien enek, inau numon vatiamal keil koa ikistal ika eni imai ihi mari vangi meatin tai veni kei emun vi natmali.” ");
INSERT INTO pma_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Sakini, visokon semau, Ebraham san anien ka veioai tai min Hakar ka lingi en vatisin. Evus, sila lat kei ka natnali luva. Keilu luva luka vasi out volvol ten out Bersiba. ");
INSERT INTO pma_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Navong oai vus, lokovein titan en nimal ten holeai tai. ");
INSERT INTO pma_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Kei va rani soutin neli ka rondan netan ka mul mis vit, “!Aue li, ek rovattei males natkuli vamat!” ");
INSERT INTO pma_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Rovitei tuetin, ehon emun mis ka Ahi raengoni. Ka angelo onen Ahi selus ka out nesa mai ven Hakar vit, “?Hakar, komundemko en sa? !Konametautei! Ahi raengoni titiali mis. ");
INSERT INTO pma_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Kimea, kiha veni, kitali lati. Veni inau, numon koakeil ikistal ika en vatiamal onen imai ihi mari vangi meatin tai.” ");
INSERT INTO pma_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Evus, Ahi sakin Hakar les vulvul tai koa oai mul ien. Sakini kei seh oai va en veioai onen ka san hatte tai min natnali muni. ");
INSERT INTO pma_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Evus, Ismael mai matu, ka Ahi katauni. En out volvol ten out Paran, kei mai vi meatin hau tai koa vi more meatin talauien. ");
INSERT INTO pma_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Navong mai mariso, mama onen votin atouli tai ten out Isip mai retalihe ral mini. ");
INSERT INTO pma_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Avong muli, Ahi vit vasak vis Ebraham. Sakini vise vit, “!Ebraham!” Ka Ebraham vit, “!O-o, inau li ke!” ");
INSERT INTO pma_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ahi viteni mini vit, “Kikur natmali kati koa Aesak, koa envatien onom mariso mul ien, ka kihina en atan ten out Moraea. Ekonek en hou tai koa nitie minuk, ku vini ka kiniti hehi sanien tai onom minau.” ");
INSERT INTO pma_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Sakini, out mulan, Ebraham ra ruain av, sak mesein tounah keil ka lingi en dongki sen. Kur Aesak ka meatin toumien onen elu telvita en out koa Ahi viteni mini. ");
INSERT INTO pma_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Telmual va vio … en avong etel teni, telles out koa Ahi vat kati mini mul soutin neli veah. ");
INSERT INTO pma_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Navong lesi mukok, Ebraham viteni min meatin toumien keilu onen vit, “Milheto ekok hetal dongki ekek. Ehon ekek ka inau melheha en out keiva ekek, ka melheha netan min Ahi. Evus, melhemai ris ven kamil.” ");
INSERT INTO pma_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ebraham san av ten sanien min Aesak vousi, ka kei kur naef ka vatihang. Navong lumual ruai luva, ");
INSERT INTO pma_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Aesak viteni min tata onen vit, “!Tata!” Tata onen vit, “?Asa natkuli?” Aesak visi vit, “?Nalesi lokur av ka ahang, ka sipsip koa lovaniti vahi sanien kave?” ");
INSERT INTO pma_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ebraham vit, “Ahi, kei varei hesani.” Ka keilu lumual ruai luva. ");
INSERT INTO pma_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Navong lurokol out koa Ahi vat kati, Ebraham kur ahat keil, mumon ahor ten sanien eni ka ling av ien. Evus, par kat natnali ka lingi matil kat av keil nesa. ");
INSERT INTO pma_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Evus, kahut lat naef onen vit vasal vini. ");
INSERT INTO pma_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Ka hatte tas, angelo onen Iahova viso ka en out nesa vit, “!Ebraham, Ebraham!” Ka kei vit risi vit, “O-o, inau li ke.” ");
INSERT INTO pma_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","“Konou vinitei ehon onom. Konoumontei tounah nasut natmali. Ekek nakilea keke keik kovouhou min Ahi ka kolong kati, veni keik kormutut kattei natmali ran Ahi, natmali kati koa tas koa vi onom.” ");
INSERT INTO pma_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ebraham lele ka les nani rendan koa meahos, hon verai mul en holeai tai. Sakini, luv lat viau ran Aesak ka va kur nani keke vakur vulin natnali. Muasi mat ka muniti suk vi sanien onen vina min Ahi. ");
INSERT INTO pma_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ebraham ling isen out enek vi ‘Iahova Jaerah’ koa aneite teni vi ‘Iahova sani.’ Ka selusien koanik, meatin keil amul aviteni rokol kosa avit, “En hou onen Iahova, kei varei hesani.” ");
INSERT INTO pma_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Angelo onen Iahova selus min Ebraham hatte elu vit, ");
INSERT INTO pma_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Ahi viteni mukok: ‘Numon hatkatien hetal minuk en isok keke nitokol katuk hehi houlu mok veni keik kormutut kattei natmali ranau, natmali kati koa tas koa vi onom. ");
INSERT INTO pma_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Navat kati keke nitokol katuk, numon vatiamal onom koa ikistal enuk ihi houlu vis ihi houlu mok isuval hitu ten teilang vuo isuval veien ten atas. Onom keil u vasi meatin keil koa avit avoumon rea vatal min keil. ");
INSERT INTO pma_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Vatiamal onom keil ihi sise ten tokolkatien onak heha min vangi meatin vasi keil ten out netan. Koanek hehi sanien onak minuk veni kolong kat inau.’” ");
INSERT INTO pma_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Ebraham keilu natnali luva ris ven meatin toumien keilu onen. Ka telva ris en out koa amul ien koa avise en Bersiba, ka aro ien ral min one keil sua houlu. Navong sua onen Serah rokol handred tai hanumau tai ka oulu mun (127), kei mat. Ebraham rangisi ka vit vatahini ka sakras ven atan kati onen tovuol. Sakini, vul titi atan ran meatin tai en out enek ka rahin ahin onen mul ien. Sua etel muli, ka navong sua onen Aesak rokol hanumau elu (40), kei retalihe suk ral min ahin tai ten out Haran, isen Rebekah. Kei vi natin Nahor, tunali Ebraham. Rovitei tuetin, avu Ebraham mat ka titan keilu, Aesak ka Ismael, lurahini vesesal en out koa arahin Serah ien. Navong mat, sua onen Ebraham rokol handred tai, hanumau etel ka teindan elim emun (175). ");
INSERT INTO pma_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Koanik tunien onen Aesak, natin Ebraham. ");
INSERT INTO pma_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Aesak, sua onen hanumau elu (40) navong retalihe ral min Rebekah, natnahin Betuel (koan Aramea ten out Mesopotemia) ka ahinali Leban. ");
INSERT INTO pma_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Aesak ro ral min Rebekah ka kei sakras vakur tivava. Sakini Aesak vis min Iahova en usite onen, Iahova long hisien onen ka sakin Rebekah meas. ");
INSERT INTO pma_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Ka en vangen, maeh keilu lumul ien ka lumul lukumkum neim. Sakini mama onealu long mahien houlu. Ven koanek, Rebekah mundemi vit, “?Vensa nalong mahien houlu mukok?” Ka va vis min Ahi ven aneite teni. ");
INSERT INTO pma_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Ka Iahova viteni mini vit, “Ehon elu lumul en vangom. Tai koa hekatau hemai hemarite mok helin koa helamu. Anatin, koa helamu hel en hen koa katau. Ka luhemai luhehi mari tata ten mari vangi meatin elu, ka vangi meatin elu enek koa kikur keilu, luhetisa min keilu. Ka koakeil ikistal ika en koa katau ikeih imok isulin onen koa mulamu.” ");
INSERT INTO pma_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Avong mal vinvin Rebekah vakur tivava, ka kur maeh keilu koa luvi meahos. ");
INSERT INTO pma_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Koa mulamu, amuven vilhili moul ka vasi aven, sakini luling isen ‘Esao’ koa aneite teni vi ‘amuven houlu.’ ");
INSERT INTO pma_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Koa katauni, navong avasi, vuli kat vasehen tunali, sakini luling isen ‘Siekob’ koa aneite teni vi ‘meatin koa vuli kat vasehen.’ Ka Aesak, sua onen hanumau etel (60) navong ahin onen kur maeh keilu enek. ");
INSERT INTO pma_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Navong ehon keilu lumoul lumai lumariso, Esao vi meatin talauien koa en vati mok vato en eivorohus. Ka Siekob vi tiraeng ka rotos teim. ");
INSERT INTO pma_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Aesak, envatien onen mul en Esao veni en vati mok val van vuseri koa Esao muasi. Ka Rebekah, envatien onen mul en Siekob. ");
INSERT INTO pma_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","En avong tai, Siekob ros teim ka mul kukon sup bin. Ka Esao ka en eivorohus, mai amai kati houlu. ");
INSERT INTO pma_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Sakini viteni min Siekob vit, “!Amai katnau vareis! !San tei sup tahilhili keisom maani!” Ven koanek, aling isen tamun vi ‘Edom’ koa aneite teni vi ‘vilhili.’ ");
INSERT INTO pma_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Siekob vit risi mini vit, “Nakilea nisan tei minuk munak keik kisani minau vulum ten moeite.” ");
INSERT INTO pma_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esao vit, “Tahosis, kuri. ?Veni munak amai heat vini inau nimat, vuluk ten moeite hekataunau hemukave?” ");
INSERT INTO pma_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Siekob vit risi mini vit, “Helamu, kumon hatkatien keke keik kisa lat vulum ten moeite minau.” Sakini, Esao maeni ka mumoni suvali. ");
INSERT INTO pma_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Katau suk, Siekob san sup ka veret mini. Kei kanian ka mun hati oai tai, evus, mea va. Mukos, Esao mundem maen vulin kati ten moeite. ");
INSERT INTO pma_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Avong sav tai ris, ous romustei avong houlu ka sakin anien tovuol en out koa Aesak ral min onen keil aro ien (amai koanek teisav en asa koa kur out en avong onen avu Ebraham). Sakini, uva ales asuv houlu onen me-Pilistin keil koa ro en taon ten out Kerar, isen Abimelek, veni alonge keke anien mul en kantri onen. ");
INSERT INTO pma_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Iahova mai kistal min Aesak ka viteni mini vit, “Konahatei Isip. Kito nges en out koa inau nitie lati minuk. ");
INSERT INTO pma_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Kito ekok en atan onen meatin sav keil hati avong havivi, ka inau nito hetal minuk ka nitokol katuk. Out vasi keilek emun, nisani minuk ka min vatiamal keil koa ikistal ika enuk. Hatkatien koa namumoni mulamu ral min tata onom Ebraham, numoni hekistal hemai hehi anatin. ");
INSERT INTO pma_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Numon titam keil koa ikistal en vatiamal onom ihi houlu vis ihi houlu mok, isuval hitu en teilang. Ka nisani min keil out vasi keilek. Ka keik ka onom keil mihehi sise ten tokolkatien onak vaha min vangi meatin vasi keil ten out netan. ");
INSERT INTO pma_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Nitokol kat kami veni tata onom Ebraham long kat nau ka musil mengkatien keil onak.” ");
INSERT INTO pma_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Sakini, Aesak ro nges en out Kerar ral min onen keil. ");
INSERT INTO pma_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Avong muli va, ka Aesak mai vi ulmatu ka meten var. Avong tai, san selusien va min natnali koa moeite vit vamai veni. Ka navong Esao mai, Aesak visi vit, “?Natkuli, keik somok eke?” Ka Esao vit risi mini vit, “Inau ke.” ");
INSERT INTO pma_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Aesak viteni mini vit, “?Kolesi? Inau namatu, ka vahesa nimat hervitei tuetin. ");
INSERT INTO pma_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Sakini, kikur hisuput ka atuv keil onom kiha en eivorohus, ka kuas etai tirendan minau. ");
INSERT INTO pma_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Kikukoni hesuval koa kokilea inau ek vati. Navong nianian hevus, inau nisan tokolkatien ekor ten moeite esuk minuk, veni nareingeingeni nimat nengeis.” ");
INSERT INTO pma_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Navong Aesak mul selus min Esao, Rebekah mul raengon suain asa mul viteni. Ka navong Esao va en eivorohus, ");
INSERT INTO pma_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebekah viteni min Siekob vit, “Naraengon asa tata onom mul viteni min Esao. ");
INSERT INTO pma_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Kei viteni mini mukok vit, ‘Kuas etai tirendan venau ka kikukoni hesuval koa kokilea inau ek vati. Navong nianian hevus, en meten Iahova, inau nisan tokolkatien onak esuk minuk, veni nareingeingeni nimat nengeis.’” ");
INSERT INTO pma_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Ka Rebekah vit risi mini vit, “Natkuli, kitaengonau ka kumon asa nihiteni minuk. ");
INSERT INTO pma_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Kiha en out koa alei kat sipsip keil eni, ka kikur nani elu koa avealu musising, kihousi hemai venau. Nikukoni hesuval koa tata onom en vati. ");
INSERT INTO pma_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Keik kikuri heha veni ka navong heani hevus, hesan tokolkatien onen minuk, veni roreingeingeni hemat nengeis.” ");
INSERT INTO pma_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Ka Siekob viteni min mama onen vit, “?Ka mukave, amuvek tovuol ka amuven Esao houlu? ");
INSERT INTO pma_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Ka vahesa tata hetokol avek, heilea keke rovitei Esao ka hehotini keke namul naluvosi. Nasakini tokolkatien natovuol varei en moulien onak, nametau tata nasesendanau.” ");
INSERT INTO pma_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Mama onen viteni mini vit, “Natkuli, munak hemukonek, sesendaen enek hersuttei keik, hesut inau nges. Kikalah, kumon asas naviteni, kiha kikur nani elu hemai venau.” ");
INSERT INTO pma_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Sakini va, kuri mai veni ka kei kukon vati anien koa tata onen en vati. ");
INSERT INTO pma_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Evus, Rebekah kur more eisin omon Esao koa ling revi mul, ka musin eni suk en Siekob. ");
INSERT INTO pma_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Evus, kur hiliven nani ka kav koe hen ka hiren Siekob eni. ");
INSERT INTO pma_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Sak meseini evus, san more anien enek mini ral min veret koa kei mumoni. ");
INSERT INTO pma_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Evus, Siekob va ven tata onen ka vise vit, “!Tata!” Ka tata onen visi vit, “!O-o, inau li ke! ?Ka kamil en sei ke?” ");
INSERT INTO pma_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Siekob vit, “Inau Esao, titam koa moeite. Namumoni suval koa koviteni minau. Mea, tondan revi ka kian vuseri koa nakuri minuk. Ka navong kiani hevus, kokilea kovasan tokolkatien onom minau.” ");
INSERT INTO pma_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Aesak vit, “?Natkuli, kovotini kalah mukave?” Siekob vit, “Iahova, Ahi onom, kataunau eni.” ");
INSERT INTO pma_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Aesak viteni mini vit, “Amai li vesesal venau hesakini nakilea matokoluk mailea keik somok Esao.” ");
INSERT INTO pma_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Sakini va vesesal ven tata onen, ka ulmatu kamus hen ka viteni vit, “Rem suval Siekob, ka hem keilu lusuval hen Esao.” ");
INSERT INTO pma_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Ka kei lei ras Siekob varei veni amuven houlu suval Esao. Sakini mumon rendemien onen keke vasan tokolkatien onen mini, ");
INSERT INTO pma_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","ka vis risi vit, “?Keik somok Esao?” Ka Siekob vit, “He-e, inau varei.” ");
INSERT INTO pma_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Aesak viteni mini vit, “!San vuseri ak maani! Niani hevus, nitokol katuk.” Sakini, kuri, sani mini, ka san hati uaen muni. ");
INSERT INTO pma_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Evus tata onen viteni mini vit, “Natkuli, kimai vesesal venau ka kiav katnau.” ");
INSERT INTO pma_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Navong kav kati, Aesak mus vi eisin mon ka rokol kati. Navong musi mukok, kei mundemi keke Esao kati, ka san tokolkatien onen mini vit, “Natkuli, vi vem tahos suval eivorohus katau en avong Iahova san ous mita netan. ");
INSERT INTO pma_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Ahi hesani minuk tilep ten out nesa hekas ah esom keil ka houmon keik kil en amas. Ahi houmon ah ten uit esom italeha ka nei grep keil esom ihi houlu. ");
INSERT INTO pma_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ahi houmon meatin keil um minuk, meatin keil ten kantri sav keil ihouhou minuk. Kihi hetetamen helin tumali keil, titan mama onom keil iha netan enuk. Meatin keil koa isesenda enuk, Ahi hesesenda en keil. Ka koakeil isan selusien ten tokolkatien minuk, Ahi hetokol kat keil!” ");
INSERT INTO pma_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Navong Aesak san tokolkatien mini evus, Siekob va rani. Ka katau suk, tunali koa Esao mai ris ran eivorohus. ");
INSERT INTO pma_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Kei mun kukon more anien tai ka kuri va ven tata onen vani. Ka vit, “Tata, mea li, tondan ka kian vuseri koa nakuri minuk. Ka hevus, kisan tokolkatien onom minau.” ");
INSERT INTO pma_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","“?Keik sei?” Esao vit, “Inau Esao, moeite onom.” ");
INSERT INTO pma_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Navong Aesak longe mukok, mutimanin ka maleilei houlu ka visi vit, “?Isei keke muas tirendan ka kuri mai venau? Nakani etin vus, keik kumai. Nasan vasi tokolkatien ekor onak mini. Ka nasakras mahilesi, tokolkatien enek heles eni lises.” ");
INSERT INTO pma_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Navong Esao raengoni, longe tisa ka muai roha vit, “!Tata, tokol kat nau li mun!” ");
INSERT INTO pma_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ka Aesak vit, “Tumali mai luvos nau ka kur vasi tokolkatien onom tuai.” ");
INSERT INTO pma_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esao viteni vit, “Hatte elu keinek keke kei sak luvos nau. Isen koa vi Siekob mal varei. Mulamu, kei kulat vuluk ten moeite ranau, ka kosa, kei kulat tokolkatien emun ten moeite ranau. ?Korling etai li hati tokolkatien onom vahi onak?” ");
INSERT INTO pma_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Aesak vit risi mini vit, “Kei, namumoni tuai mai vi hetetamen mulik, ka namumon vatiamal keil vasi onen imai ihi meatin toumien onen. Nasani mini anien ka uaen. ?Natkuli, asa ris nakilea masani minuk?” ");
INSERT INTO pma_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esao mulelis peah tata onen vit, “?Tokolkatien onom tas eli? !Tokol kat nau li mun! !Tata, tokol kat nau li mun!” Ka muai roha. ");
INSERT INTO pma_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Sakini, Aesak viteni mini vit, “Ahi hersantei tilep hekas ah esom keil, ka amas hetovuol enuk. ");
INSERT INTO pma_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Keik kiles en huhuen ka kihuli kat naef onom lises. Ka avaseini, kihi eiloheh onen tumali. Ka hekatau, navong kihit kovaso sesein keihoen onen tumali, kokilea kovamaluv rani.” ");
INSERT INTO pma_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esao vuroh kat Siekob veni tata onen sa vasin tokolkatien mini. Kei mundemi min kei sasen vit, “Avong mul mai vesesal itangis tata onak. Evus, nu vini Siekob.” ");
INSERT INTO pma_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Navong Rebekah long usil rendemien onen Esao, vise Siekob vamai veni. Navong mai, viteni mini vit, “Natkuli kitaengonau. Tumali mul ling suain vurohien onen, ka mul mumon sise vouasuk kovamat. ");
INSERT INTO pma_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Sakini kumon asa koa nihiteni minuk. Keitinesek, kiha ven tuak Leban koa ro en out Haran. ");
INSERT INTO pma_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Ka kito hetal mini en out enek hetokol avong vurohien onen tumali heha netan. ");
INSERT INTO pma_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Ka navong en hevobongen asa koa komumoni mini, nisila meatin etai hehat hekuruk kimai ris. Nametau keke kei nouasuk konamat, ka evus anahiteni keke kei mun namat. Ek rovattei kamil vasi milvavupuol ranau en avong vatas.” ");
INSERT INTO pma_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Sakini, Rebekah va ven Aesak ka viteni mini vit, “Avek mah varei ven sakien onen ahin Hitaet keitel eke koa Esao kuri. Munak Siekob emun hekur ahin Hitaet etai, tahos imok inau nimat enges.” ");
INSERT INTO pma_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Sakini, Aesak vise Siekob ka meng kati vit, “More minuk natkuli. Ek vati konatetalihetei natal min ahin ten out Kenan. ");
INSERT INTO pma_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Hemukonek, kiha en out Mesopotemia en teim sen avu onom Betuel, ka kikur ahin en out enek. Natnahin avov onom, Leban, sua one vinvin avatetalihe.” ");
INSERT INTO pma_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Evus, Aesak san tokolkatien mini vit, “Ahi ten keihoen hetokol katuk en tetaliheien onom ka hesani minuk ehon keil ihi houlu. Hesakinuk kimai kihi mari tata onen vangi meatin keil houlu. ");
INSERT INTO pma_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Ahi hetokol katuk hetal min vatiamal keil koa ikistal ika enuk suval koa rokol kat avu onom Ebraham. En avong koa hemai, hekataunuk kikur vasi atan koanek koa, kosa, komul ien suval heou tai, hemai hehi onom kati. Veni atan enek, Ahi sani mulamu min avu onom Ebraham.” ");
INSERT INTO pma_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Evus, Aesak sila Siekob va en out Mesopotemia ven Leban koa vi natin Betuel ten out Eram. Kei vi tunali Rebekah, mama onen Siekob ka Esao. ");
INSERT INTO pma_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Siekob lokovein Bersiba ka kei sasen musil sise va en out Haran koa mul soutin. ");
INSERT INTO pma_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Navong out vong, va kistal en out tai en sise koa tahos ka ro en out enek. Kur ahat tai, mulung eni ka matil. ");
INSERT INTO pma_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Navong mul matil, matil vovoi ka les sise tai koa vatte mul netan ka keite vina rokol out nesa, ka angelo keil amusili avina nesa ka amita netan eni. ");
INSERT INTO pma_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Siekob lele vina nesa ka les Iahova mulomal nesa en sise enek ka viteni mini vit, “Inau Iahova, Ahi koa Ebraham ka Aesak lumusili. Atan koa komul komatil ien, nisani minuk ka min vatiamal keil koa ikistal ika enuk. ");
INSERT INTO pma_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Vatiamal keil onom enek hehi houlu vis hehi houlu mok. Suval koa meatin sakras vahuli nehi atan vasi keil ten out netan, meatin keil asakras avahuli vasin onom keil. Ihi houlu ihilelau isien vasi out netan iha itokol out wes ka out ist, out not ka out saot. Ka keil ihi sise ten tokolkatien onak heha min vatiamal sav keil ten out netan. ");
INSERT INTO pma_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Kindem kati keke inau, nito venuk ka nikur koek en out vasi kiha en. Nikur risuk kimai en atan koanek ka nirlokoveintei keik hetokol avong num vasi asa koa navat kati minuk.” ");
INSERT INTO pma_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Navong lesi evus, Siekob muli en metavinavong ka viteni vit, “!Anatin eli, Iahova eli ro ko, ka inau nareingeingeni li!” ");
INSERT INTO pma_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ka annivul kati ka viteni vit, “!Aue li, nahi oute vi out votut tai! Nahi Ahi ro ko ka oute vi meteau koa vina veni en out nesa. !Ei, nametau houlu en out ekek!” ");
INSERT INTO pma_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Out mulan, Siekob muli ka kur ahat koa mulung eni ka vati mulomal vi metai mini keke hendem kat asa koa lesi. Evus, kur oel ten olip ka mutahi eni vatie lati vi out votut onen Ahi. ");
INSERT INTO pma_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ling isen out enek ‘Bet-el’ koa aneite teni vi ‘eim onen Ahi.’ Taon koa mul vesesal en out enek, isen Lus. Evus, Siekob va en out Haran, teim sen avov onen, Leban. Navong les atouli elu onen, Siekob, envatien onen mul en tasite koa Resel, ka vis avov onen eni. Leban vit tahos hekuri, ka helamu, houm veni sua oulu (7) keke kilea vahuli. Navong Siekob longe mukok, si veni ka maeni. Ka navong sua oulu (7) evus, Leban en rovattei keke Siekob vakur Resel ka valohosai rani vatal tounah keil onen. Laban en vati keke Siekob vato vatali sua vahis emun veni lesi keke tokolkatien onen Ahi mul en umen vasi keil onen. Sakini, en avong ten tetaliheien onealu, Laban keih kat Resel vamaen tunahin vakur vulin. Navong out mulan, Siekob lei kilea suk keke ro ral min Leah, ka tin katiat. Navong va les Laban ven usite enek, kei maeni keke vakur Resel en wik tai munak voumon hatkatien vatal mini keke houm mini sua oulu (7) emun. Ka Siekob maeni eris. En moulien onen, tounah koa Siekob mumoni, tokolkatien onen Ahi mul ien. Ka en out enek, ahin keilu onen ral min atouli toumien onealu telkur titan houlu. Evus, Ahi selus mini vit avong vinvin hemea ran out enek, heha ris en out onen tata onen. Ka navong telmual telva, kei metaun Esao ka meatin onen keil anouasi natal onen keil. ");
INSERT INTO pma_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Navong Siekob mea ran out Mesopotemia, Ahi kistal veni en out Betel hatte tamun ka rokol kat risi. ");
INSERT INTO pma_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Ahi viteni mini mukok, “Kosa isom ‘Siekob’ koa aneite teni vi ‘meatin tasakluvosien,’ ka kosa heha, isom hehi ‘Isrel’ koa aneite teni vi ‘meatin koa lehkao min Ahi.’ ");
INSERT INTO pma_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Inau navi ‘El-Sadai,’ koa aneite teni vi ‘Ahi ten Keihoen.’ Mihelah titiali keil hehi houlu. Mari vangi meatin keil houlu ika enuk ka tei en keil imai ihi asuv houlu keil. ");
INSERT INTO pma_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Atan keil koa nasani min avu Ebraham ka tata onom Aesak, nisani minuk ka min vatiamal onom keil koa ikistal ika venuk.” ");
INSERT INTO pma_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Navong Ahi selus mini evus, mea rani. ");
INSERT INTO pma_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Ka en out koa Ahi selus mini, Siekob vati lat ahat tai mulomal vahi out koa hendem kati asa koa Ahi viteni mini. Evus, kur oel ten olip ka uaen, mutah keilu eni vatie lati vi out votut onen Ahi. ");
INSERT INTO pma_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Out koanek, Siekob ling isen vi ‘Bet-el,’ ‘eim onen Ahi.’ ");
INSERT INTO pma_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Avong vahis muli, Siekob ka onen keil amea ran out Betel. Ka navong amul amual semau, soutin neli ran out Efrat, avong mai keke Resel vakur tivava ka kei votini keih. ");
INSERT INTO pma_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Navong longe tisa houlu, ahin koa mul katauni viteni mini vit, “Konandemkotei, ehon tamun keinek.” ");
INSERT INTO pma_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Ka mukos, mahien onen vi ten matien. Ka navong Resel leh ekor en eang, ling isen ehon ‘Ben-oni’ koa aneite teni vi ‘natin ten mahien.’ Ka tata onen viles isen mai vi ‘Ben-samin’ koa aneite teni vi ‘natin ten hek matu.’ ");
INSERT INTO pma_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Navong Resel mat, arahini en vali sise koa va Efrat (kosa, out enek avise en Betlehem). ");
INSERT INTO pma_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Siekob kur mari ahat tai ka vati lati mulomal vatie lat tehitan onen. Ka mari ahat enek mules en out enek rokol kosa. Siekob, ahin onen ehat (4) ka natnali keil teindan elu (12). ");
INSERT INTO pma_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Ehon keil koa aka en Leah mukok: Ruben (koa moeite onen Siekob), Simeon, Livae, Sudah, Isekar, ka Sebiulon. ");
INSERT INTO pma_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Ehon keil koa aka en Resel mukok: Siosep ka Bensamin. ");
INSERT INTO pma_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Ehon keil koa aka en Bilah, ahin toumien onen Resel, mukok: Dan ka Navtali. ");
INSERT INTO pma_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Ehon keil koa aka en Silpah, ahin toumien onen Leah, mukok: Kat ka Aser. Koakeil enek avi natin Siekob keil koa mama one avasi keil en kantri ten out Mesopotemia. ");
INSERT INTO pma_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Siekob ro nges en atan ten out Kenan, out koa tata onen ro ien mulamu. ");
INSERT INTO pma_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Koanek tunien usil Siekob ral min onen keil: En avong vasi, natnali Siekob keil amul alei kat sipsip ka nani keil esen. Tai en keil, isen Siosep, koa sua onen teindan oulu (17) mul kataun tunali keil koa mama one Bilah ka Silpah. Ka en avong tai, kur longlongien koa rotahostei usil sakien onen tunali keil min tata one koa Siekob ka avuroh kati. ");
INSERT INTO pma_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Siekob, envatien onen mul en Siosep suli natnali sav keil veni kei matu navong avasi. Siekob mumon eisin taveah omon Siosep koa moreite mok ka musin eni en kei. ");
INSERT INTO pma_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ka navong tunali keil ales envatien onen tata one mul en Siosep suli keil, mete tisa kati ka arselustei vatahos mini. ");
INSERT INTO pma_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","En vongien tai, Siosep matil vovoi, ka navong vit usili min tunali keil, tine kati houlu mok. ");
INSERT INTO pma_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Kei vit, “Mihelong matil vovoien onak. ");
INSERT INTO pma_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Romum out tas en ah ten uit ka romul ropar ruain uit keil. Evus, koa napar ruaini mulomal ka koa onami akarahiti ka uva netan mini.” ");
INSERT INTO pma_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ka tunali keil avisi avit, “?Keik komundemi kovit kihi asuv houlu hesulin komai?” Ka tine kati mok ven matil vovoien onen ka ven asa kei vit usili. ");
INSERT INTO pma_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Evus, Siosep matil vovoi eris ka viteni min tunali keil vit, “Namatil vovoi eris, ka nales meteiai, avati ka hitu teindan tai (11) uva netan minau.” ");
INSERT INTO pma_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Kei vit usil matil vovoien onen emun min tata onen ka tata onen vul kati vit, “?Matil vovoien sa ke? ?Keik komundemi kovit tumali keil, mama onom, ral min inau mun mehemai meheha netan minuk?” ");
INSERT INTO pma_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Tunali keil avi elu kati mok ka tata mules mundem usil tounah koa Siosep viteni. ");
INSERT INTO pma_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Avong tai, tunali Siosep keil amulamun sipsip esen tata one uva en out koa oumunai ae tahos vesesal en taon ten out Sekem. ");
INSERT INTO pma_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Avong vahis muli, ka Siekob vise Siosep ka viteni mini vit, “Ek vati keik kovaha en out Sekem, kovasao en tumali keil koa amul alei kat sipsip keil oseratel.” Ka Siosep vit, “Tahos, maha.” ");
INSERT INTO pma_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Tata onen viteni mini vit, “Keik kiha kilei vis tumali keil. ?Aro tahosis? ?Ka sipsip emun keil, tounah tovuol vakula keil? Evus, kimai ris kihiteni minau.” Sakini, Siosep musil ren tata onen ka mea ran vatihou keil ten out Hibron, va Sekem. Navong Siosep rokol out Sekem, ");
INSERT INTO pma_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","mules karahit out vasi, ka meatin tai lesi ka visi vit, “?Komul kolekat etai tounah?” ");
INSERT INTO pma_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Kei vit, “Namul nalekat tuak keil koa amul alei kat sipsip keil. ?Kokilea kovahiteni minau out kave amul ien?” ");
INSERT INTO pma_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Meatin enek vit, “Uva tuai. Naraengoni avit avaha en taon ten out Dotan.” Sakini Siosep mual valekat keil, ka votin keil en out Dotan. ");
INSERT INTO pma_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Navong tunali keil alesi mul soutin veah, arun lekat sise koa avouasi vamat. ");
INSERT INTO pma_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Aviteni min keil eris avit, “Meatin ten matil vovoien enek mul mai. ");
INSERT INTO pma_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Almai rovaha rovouasi vamat ka rovason teiai onen vaha en vulvul tai koa mul en out enek. Hevus, rokilea rovahiteni keke tirendan tai rali vahasi ka kani. Hesakini, reheles asa varei hekistal en matil vovoien keilu onen.” ");
INSERT INTO pma_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Navong Ruben raengon rendemien one, mundemi vit hekur koe tunali. Sakini, viteni min keil vit, “Ronouastei. ");
INSERT INTO pma_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","En out volvol en out enek, rehesoni hehita en vulvul ten oai keisom koa memes, ronasontei her napoen.” Viteni mukok veni mundemi keke hekulati ran he ka hesila risi heha ven tata one. ");
INSERT INTO pma_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Navong Siosep mai vesesal ven keil, asakit lat eisin koa moreite koa musin eni. ");
INSERT INTO pma_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Evus, avuli kati ka asoni vita en vulvul tai koa memes. ");
INSERT INTO pma_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Evus, uva akanian. Ka navong amul semau akanian, amusil en vange meatin keil ten out Ismael amul umai ral min kamel keil ese. Aka en out Kilead avaha en out Isip. Amul akur ouai ka toeai koa vite tahos keke meatin keil avahul lati ran keil. ");
INSERT INTO pma_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Sudah viteni min tunali keil vit, “Munak rehou suain tuak orer, rosakras rovakur etai tounah koa tahos. ");
INSERT INTO pma_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Ka munak rehesani min me-Ismael keil ekek, akilea avahul lati ran ir. Hesakini, ir rehermuastei veni kei vi tuak orer, rokistal en ara tas.” Ka tunali sav keil amaeni. ");
INSERT INTO pma_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Ka navong tei en keil umai vesesal, tunali keil aleh lat Siosep ran vulvul ka amaen lati ven keil. Me-Mid keil enek avul lati en mani koa silva vi hanumau (20), ka akuri uva en out Isip. ");
INSERT INTO pma_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Navong tunali savsav keil amumoni, Ruben mul en out sav. Ka navong Ruben mai ris, sao en avul enek ka votini keke Siosep vuol tuai en out enek. Sakini, rali vas eisin omon veni longe tisa houlu mok. ");
INSERT INTO pma_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Kei va ris ven tunali keil ka vit, “!Siosep vuol! ?!Numon sa li varei!?” ");
INSERT INTO pma_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Evus, amuas nani tai ka akur more eisin omon Siosep ka alelini en ran. ");
INSERT INTO pma_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Ka keil akur eisin omon va ven tata one ka avit, “Meles tounah ekek. ?Rovitei onen natmali?” ");
INSERT INTO pma_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Kei lesi, lei kilea ka viteni vit, “!Anatin eli, onen varei! !Tirendan tai rali vahas natkuli, ka kani li varei vus!” ");
INSERT INTO pma_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Siekob longe tisa ka rali vas eisin omon ka musin en musi eisin tatangien. Kei rangis natnali avong taveah. ");
INSERT INTO pma_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Natnali keil ka natnahin keil umai veni avit avakatauni, ka kei seseini. Viteni min keil vit, “Nitos nitangisi hetokol keite ten moulien onak, hetokol avong koa nihita en out ten matien.” Sakini mules rangis Siosep. ");
INSERT INTO pma_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Ka me-Ismael keil akur Siosep uva en out Isip keke hemai hehi slev. Ka meatin tai vuli, isen Potifar. Kei vi avat onen meatin taleikokoeien keil koa alosil kat mari eim omon Asuv Houlu ten out Isip. ");
INSERT INTO pma_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Ka avong Siosep ro teim onen Potifar en out Isip, Iahova katauni en tounah vasi koa mumoni ");
INSERT INTO pma_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","ka sakin hetamen onen lei kilea keke Iahova mumon umen vasi koa mumoni tahos imok. ");
INSERT INTO pma_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Potifar si houlu veni ka lingi vi avat en teim onen, lei kat tounah vasi keil onen. ");
INSERT INTO pma_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Ka en hen Siosep, Iahova rokol kat teim ka ah keil onen koan Isip enek. ");
INSERT INTO pma_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Sakini, veni Siosep mul lei kat revi tounah vasi onen, Potifar romundem etai mun tounah. Mundem anien enges koa kei vani. Siosep, aven tahos ka veinan malikuh imok, ");
INSERT INTO pma_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","ka avong vahis muli, ahin onen Potifar ling rendemien onen mul ien ka visi vit vamatil vatal mini. ");
INSERT INTO pma_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ka Siosep seseini ka viteni mini vit, “!Ei, asuv onak mundesinau ka ling tounah vasi onen en hek keke nilei kati. Kei romundem etai mun tounah en teim onen. ");
INSERT INTO pma_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Kei san keihoen minau keke rek suval ren, ka, en teim onen, maen tounah vasi minau. Ka keik enges, koa kovi ahin onen, kei mututi vit nirrokoltei. Sakini, nasakras moumon asa koa koviteni, koanek romaltei en meten Ahi.” ");
INSERT INTO pma_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Avong vasi varei mul keih kat Siosep vahi keilu, ka kei seseini. ");
INSERT INTO pma_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Ka avong tai, Siosep va neim voumon umen onen, ka meatin sav keil atovuol neim. ");
INSERT INTO pma_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Ka navong ahin onen Potifar lesi, vuli kat eisin onen ka vit, “!Amai, matil vatal minau!” Ka kei seseini, mul lohosai rani, ka ling eisin tai omon mules en hen. ");
INSERT INTO pma_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Navong ahin enek les Siosep mul lohosai rani ka eisin omon mules, ");
INSERT INTO pma_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","kei visohiso keih min meatin toumien onen keil vit, “Alles eisin ekek, omon koan Hibru koa meatin onak kuri ka lingi ro teim. Kei vit voum vatisa min ir. Mai en out namatil ien, vit vasak tisa enau, ka inau, navisohiso keih. ");
INSERT INTO pma_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Ka navong raengoni navisohiso keih mukok, ling eisin omon mules venau, muloh va hae.” ");
INSERT INTO pma_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Kei vuli kat eisin omon Siosep mules veni rokol avong Potifar muris mai teim. ");
INSERT INTO pma_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Navong meatin onen mai veni, vit usil tunien enek mini vit, “Koan Hibru koa kolingi mum en teim vit vasak tisa enau. ");
INSERT INTO pma_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ka navong raengoni navisohiso keih, ling eisin omon mules venau, muloh va hae.” ");
INSERT INTO pma_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Navong Potifar raengon tunien enek, tin tisa houlu ka vuroh kat Siosep. ");
INSERT INTO pma_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Sakini viteni min meatin taleikokoeien keil onen avuli kati ka alingi va en eim takeih, out koa asuv houlu ten out Isip mul ling meatin keil koa amum tisa ien. Ka kei ro kat en out enek. ");
INSERT INTO pma_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ka en eim takeih enek, Iahova ro ven Siosep ka rokol kati mun. Kei sakin meatin koa lei kat eim takeih lele tahos eni. ");
INSERT INTO pma_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Avong vahis muli, kei ling Siosep vi houlu en eim takeih. Kei mul lei kat meatin sav keil koa aro eni ka umen keil amumoni. ");
INSERT INTO pma_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Sakini, meatin koa lei kat eim takeih romundem etai mun tounah koa lingi en hen Siosep. Lei kilea tounah vasi koa kei mumoni tahos imok, veni Iahova mul katauni. ");
INSERT INTO pma_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Sua vahis muli va, ka en avong tai, meatin toumien elu onen asuv houlu ten out Isip lumum romaltei en meten. ");
INSERT INTO pma_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Tai vi avat onen meatin koa amutah uaen omon, ka tamun vi avat onen meatin keil koa amul aran veret an. Ka ven tounah tai, tin kat keilu ");
INSERT INTO pma_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","ka ling keilu en hen asuv ten meatin taleikokoeien keil koa lei kat eim takeih onen, out koa Siosep ro ien. ");
INSERT INTO pma_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Ka kei ling keilu esuk en hen Siosep helei kat keilu. Luro ral mini avong taveah neli. ");
INSERT INTO pma_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","En vongien tai, meatin keilu enek lumatil vovoi. Matil vovoien onealu tateisav ka aneite teni mun tateisav. ");
INSERT INTO pma_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Navong Siosep mai ven keilu en visokon, les keilu lumundemko houlu. ");
INSERT INTO pma_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Sakini vis keilu vit, “?Vensa namil langlangis kosa?” ");
INSERT INTO pma_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Keilu luvit, “Komal vasi melmatil vovoi, ka meatin tovuol ekok vata usili.” Ka Siosep viteni min keilu vit, “Ahi enges kilea vahit luvat matil vovoien keil. Matil vovoien onamil, luhiteni minau.” ");
INSERT INTO pma_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Sakini avat onen meatin koa amutah uaen vit, “En matil vovoien onak, nales vati grep tai ");
INSERT INTO pma_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","koa angoite etel. Ka navong son oute, hatte tas ling hungeite ka heite keil umen. ");
INSERT INTO pma_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Navuli kat veiuaen onen asuv houlu ten out Isip ka nalah hei grep enek, navuhus eni va ien. Evus, nasani mini.” ");
INSERT INTO pma_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Siosep vit, “Aneite ten matil vovoien onom mukok: angoi grep etel, aneite teni vi avong etel. ");
INSERT INTO pma_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","En avong etel, asuv houlu hehisok kiha veni, hemaenuk kimaluv ran eim takeih, ka heling risuk en umen onom. Keik kisan veiuaen mini hesuval koa komumoni mini mulamu. ");
INSERT INTO pma_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ka napeahik, kindem kat nau li munak tounah vasi tahos minuk ka kihit usil nau min asuv houlu. Mukonek vahera kikataunau nimea ran eim takeih ekek. ");
INSERT INTO pma_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Kihiteni mini keke meatin keil avenan nau enges ran atan onomai, me-Hibru keil. Kihiteni mun keke inau narmumon etai tounah vatisa vasakinau mato en eim takeih ekek.” ");
INSERT INTO pma_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Navong avat onen meatin keil koa aran veret lesi keke aneite ten matil vovoien koa Siosep viteni tahos, kei suk vit lat onen mini vit, “Inau mun namatil vovoi. Navous ateli ten veret etel mul en vatuk. ");
INSERT INTO pma_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Koa nesa varei, veret tetahos an asuv houlu amul ien, ka aman keil umai amul akani.” ");
INSERT INTO pma_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Siosep viteni mini vit, “Aneite ten matil vovoien onom mukok: ateli koa etel, aneite teni vi avong etel. ");
INSERT INTO pma_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","En avong etel, asuv houlu hehisok kiha veni, hemaenuk kimaluv ran eim takeih, ka meatin onen keil itei koteh vatum. Itekei lat teiai onom en ai tai ka aman keil imai ka ian avem.” ");
INSERT INTO pma_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Avong etel muli, ka vi avong amundem kat avong asuv houlu ten out Isip avasi eni. Sakini mumon mari anien ven hetetamen keil onen. Ka en avong koanek, kei sila meatin tai onen va, vamaen avat onen meatin keil tatah uaenien vatal avat onen meatin keil koa amul aran veret lumaluv ran eim takeih. Evus, kur keilu luva lumulomal en meten asuv houlu ten out Isip ral min hetetamen keil onen. ");
INSERT INTO pma_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Kei ling ris meatin koa mutah uaen en vati umen onen eris, ");
INSERT INTO pma_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","ka en kei koa ran veret, sila meatin onen keil avuli kati, amu vini, ka arekei lat teiai onen en ai tai. Tounah keil enek kistal suval koa Siosep viteni. ");
INSERT INTO pma_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ka meatin tatah uaenien romundemtei mun Siosep, en vobongeni li varei. ");
INSERT INTO pma_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Sua elu muli, asuv houlu ten out Isip matil vovoi keke mulomal en vali Oaisal Nael. ");
INSERT INTO pma_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Navong ro en out enek, les buluk oulu (7) amea ran oai ka avengan keil en oumunai. Ave tahos ka amusising. ");
INSERT INTO pma_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Evus, les buluk oulu (7) eris akatau amea ran oai emun, ka ave tisa ka avi sikou. Keil avatimal en vali oaisal enek vesesal en koakeil ave tahos. ");
INSERT INTO pma_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Ka koakeil avi sikou, akan vasi koakeil ave tahos. Ka asuv houlu muli mea. ");
INSERT INTO pma_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Evus, kei matil eris, ka les matil vovoien tateisav tai. Les hunge uit oulu (7) mul en vatte tas, keil vasi umen revi. ");
INSERT INTO pma_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Evus, heite oulu (7) eris akikistal en vatte enek, avitehiteh rotahostei ka amukou ven eang sisil koa ka en out volvol muh lini. ");
INSERT INTO pma_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Lesi keke koakeil artahostei amoul koe koakeil atahos, sakini u vin li vasi. Navong asuv houlu mea, kilea keke kei matil vovoi. ");
INSERT INTO pma_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","En visokon teni, kei mundemko houlu ka san selusien va min lingling temat keil ral min meatin taleileien keil ten out Isip vit avamai. Navong umai, viten matil vovoien onen min keil ka tovuol en etai keke vata usili mini. ");
INSERT INTO pma_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Navong avat ten meatin keil tatah uaenien lesi, kei mai ka selus min asuv houlu vit, “Kosa, namundem ris tounah tai koa namumoni romaltei. ");
INSERT INTO pma_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Avong tai, keik tinom kat nau ral min avat onen meatin keil koa aran veret am. Sakini koling komal en hen asuv onen meatin taleikokoeien keil koa lei kat eim takeih onom. ");
INSERT INTO pma_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","En vongien tai, komal vasi melmatil vovoi, ka matil vovoien onomal, aneite ten keilu luteteisav. ");
INSERT INTO pma_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Meatin hau tai koa vi koan Hibru ro ral min komal, vi slev onen asuv onen meatin taleikokoeien keil. Navong melviten matil vovoien onomal mini, kei ra usil aneite teni min komal. ");
INSERT INTO pma_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Tounah vasi mai kistal suval koa viteni, keik koling ris nau en vati umen onak, ka komuas koa mul ran veret am.” ");
INSERT INTO pma_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Sakini asuv houlu sila meatin onen tai vakur Siosep, ka hatte tas, akulati ran eim takeih. Kalah enges asev eni, asak moteini, ka amusin eni en eisin hau. Evus, amulamuni va mulomal en meten asuv houlu ten out Isip. ");
INSERT INTO pma_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Ka asuv houlu viteni mini vit, “Namatil vovoi ka meatin tovuol vata usili minau. Naraengoni keke keik kokilea kovata usil aneite ten matil vovoien keil.” ");
INSERT INTO pma_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Siosep vit risi mini, “Asuv houlu, inau nasakras, ka Ahi enges kilea voumon aneite teni vamai vakistal kovailea.” ");
INSERT INTO pma_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Navong Siosep long matil vovoien elu onen, viteni mini vit, “Matil vovoien keilu enek, aneite teni vatte tas. Ahi mul viteni minuk asa koa houmoni en avong keil koa hemai. ");
INSERT INTO pma_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Buluk koa oulu (7), ave tahos, ka hunge uit koa oulu (7), umen revi, aneite ten keilu vasi vatte tas, luvi sua oulu (7). ");
INSERT INTO pma_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Buluk koa oulu (7), ave tisa, ka hunge uit koa oulu (7), amukou ven eang sisil koa ka en out volvol muh lini, aneite ten keilu emun luvi sua oulu (7) ten amai koa anien hetovuol ien. ");
INSERT INTO pma_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Suval koa naviteni tuai minuk, Ahi mul rie lati minuk asa koa houmoni. ");
INSERT INTO pma_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Sua oulu (7) hehi sua keil ten amas koa anien hehi houlu vis hehi houlu mok en out Isip. ");
INSERT INTO pma_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Evus, sua oulu (7) hekatau koa anien hetovuol. Sua keil ten amas, er hevobongeni ven avong ten amai heat lin tounah vasi en kantri onom. ");
INSERT INTO pma_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Anatin, avong ten amas keil, er hevobongeni veni avong keil koa hekatau, hetisa revi mok. ");
INSERT INTO pma_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ahi viteni minuk hatte elu keke keik kilea revi asa koa kei ling kati ka houmoni hekistal hervitei tuetin. ");
INSERT INTO pma_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Sakini, kitie lat etai meatin koa vi meteisau ka kur ileilien. Evus, kilingi helei kat kantri onom. ");
INSERT INTO pma_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Kilekat tei mun meatin keil koa ihi avat keil keke avalei kat umen vasi keil ten ah en sua keil ten amas. En vangi uit keil koa bak elim amul ien, iling revi bak tai heha en out sav. ");
INSERT INTO pma_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Evus, san keihoen min keil keke ilah ruain anien koa aling revi tuai heha en mari eim keil en taon keil, ka ilei kokoe eni. ");
INSERT INTO pma_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Anien keil enek heles hetokol avong keil ten amai koa hemai en out Isip. Mukonek, meatin keil asakras avamatmat ven amai.” ");
INSERT INTO pma_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Asuv houlu ral min meatin keil onen asi keil ven rendemien onen Siosep. ");
INSERT INTO pma_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Ka viteni min keil vit, “Rosakras rovahotin meatin etai vasuval Siosep koa ninin onen Ahi mul ien.” ");
INSERT INTO pma_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Sakini viteni min Siosep vit, “Veni Ahi rie lati minuk tounah keil enek, melei kilea keke keik kovi meteisau ka kokur ileilien mulin meatin sav vasi keil. ");
INSERT INTO pma_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Nilinguk kihi houlu en kantri onak ka meatin onak keil ilong kat asa kihiteni. Keihoen ten tounah vasi, nilingi en hem, ka vuluk tatondanien enges nututi. ");
INSERT INTO pma_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Kosa, naling hek enuk keke komai kovi ‘Avat ten Kavmen’ ten out Isip.” ");
INSERT INTO pma_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Ka asuv houlu kulat ring ten keihoen onen ka lingi en kalihen. Evus, kei musin en Siosep en more eisin koa muoh ka ling gol sen tai mul en hiren. ");
INSERT INTO pma_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Evus, san kat koa hos lehei keke Siosep heloh eni, koanek vi onen meatin koa vi he matu onen asuv houlu. Ka navong mul muloh eni, meatin keil avisohiso avit, “!Almalingling! !Avat ten Kavmen mul mai, almalingling!” Mukonek, Siosep mai vi Avat ten Kavmen ten out Isip. ");
INSERT INTO pma_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","En sua oulu (7) ten amas, anien houlu vis houlu mok. ");
INSERT INTO pma_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","En out vasi, Siosep lah ruain teisao en uti uit keil ka lingi mul en mari eim tai en taon keil. Uti uit koa mul en taon vasi keil ka ran ah keil koa mul rahiti. ");
INSERT INTO pma_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Uti uit houlu vis houlu mok keke Siosep sakras vahuli vasi, asuval veien ten atas. ");
INSERT INTO pma_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Mulamu en avong ten amai, Siosep kur ahin tai, isen Asenat, natnahin pris tai, isen Potefara. Kei kur titan Siosep elu. ");
INSERT INTO pma_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","En moeite onen ling isen Manase koa aneite teni vi ‘ek vobong’ veni vit, “Ahi sakinau ek vobongen mahien onak ka koakeil en teim onen tata onak.” ");
INSERT INTO pma_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Ka en koa katau, ling isen ‘Efrem’ koa aneite teni vi ‘san titiali’ veni vit, “Ahi san titiali keil minau en out tasakvisien keil onak.” ");
INSERT INTO pma_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Navong sua oulu (7) ten amas en out Isip mai va, ");
INSERT INTO pma_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","avong ten amai mai suval koa Siosep viteni. Mari amai mul en kantri sav keil emun, ka en out Isip enges, anien mul ien. ");
INSERT INTO pma_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Avong amai kat meatin keil ten out Isip, umai apeah asuv houlu ven anien. Sakini viteni min keil vit iha ven Siosep ka umon asa hehiteni min keil. ");
INSERT INTO pma_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Avong ten amai mai tisa revi mok, sakini Siosep maeni meatin keil onen asehen voiteh ten mari eim ten uit en taon vasi keil. Ka me-Isip keil umai avuli. ");
INSERT INTO pma_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Meatin keil umai en out Isip aka en out sav houlu avahul uti uit veni anien tovuol en out vasi. ");
INSERT INTO pma_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","En out Kenan, an tisa mai rokol keil emun ka meatin keil, amai kat keil. Ka Siekob long kilea keke pulaoa mul en out Isip, kei viteni min natnali keil vit, “?Kami mimul mileles kami vensa? ");
INSERT INTO pma_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Naraengoni keke pulaoa mul en out Isip. Miheha en out enek, mihehul tei hesakini rehermattei ven amai.” ");
INSERT INTO pma_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Sakini, halualim (10) en tunali hahah keil onen Siosep uva avul pulaoa en out Isip. ");
INSERT INTO pma_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Ka tunali Siosep kati koa isen Bensamin, Siekob rosilatei vousil keil veni metau keke tounah tei nasuti en sise. ");
INSERT INTO pma_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Sakini natnali Siekob keil uva ral min teisav keil keke avahul pulaoa, veni anien tovuol emun en out Kenan. ");
INSERT INTO pma_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","En avong koanek, Siosep vi Avat ten Kavmen en out Isip, ka meatin keil aka en out savsav keil umai veni avahul pulaoa rani. Sakini tunali Siosep keil umai veni ka uva netan mini, veinae vita rokol atan. ");
INSERT INTO pma_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Navong Siosep les keil, lei kilea tunali keil ka mumoni suval koa kei reingeingen keil. Vis keih imok min keil vit, “?!Mika kave!?” “Komai meka en out Kenan. Emai vati mivahul tei pulaoa.” ");
INSERT INTO pma_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Avaseini keke Siosep lei kilea keil, ka keil alei ras nan. Tunali Siosep keil avul pulaoa rani ka akuri suk uva ven tata one en out Kenan. Katau ris, navong akan vasi pulaoa koa akuri, uva ris Isip avahul tei ris pulaoa. ");
INSERT INTO pma_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Evus, Siosep viteni min keil vit, “Almai vesesal.” Ka uva veni suval ka viteni. “Inau, tuak onami, Siosep. Kei koa mimaen me-Isip keil avuli. ");
INSERT INTO pma_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Minalongtei natisa vuo minaselus kattei kami ven asa koa mimumoni. Tounah koa mimumoni enau vi hatkatien onen Ahi. Kei sila nau namulamu en kami makataun moulien onen meatin keil. ");
INSERT INTO pma_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Sua elu suk keke anien tovuol en out ekok, ka sua elim (5) hemai veah keke meatin sakras voumon etai tounah en ah esen. ");
INSERT INTO pma_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Ahi sila nau numai ekok moumoni vatiamal onami varvupuoltei, ka titiali keil orer koa ikistal en ir imoul lises. ");
INSERT INTO pma_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Sakini, rovitei kami mivasa lat nau mamai ekok. Ahi keinek, kei vati lat inau navi hen matu onen asuv houlu ten out Isip. Navi houlu en teim onen ka navi Avat ten Kavmen ten mari kantri koanik. ");
INSERT INTO pma_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Mihekalah miheha ven tata, mihehiteni mini mihehit, ‘Natmali Siosep vit Ahi mumon kei vi Avat ten Kavmen en out Isip. Konatontei, kikalah kiha. ");
INSERT INTO pma_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Kito en atan ten out Kosen vesesal venau: keik, natmali keil, avu onom keil, sipsip keil esom, nani keil esom, ka buluk keil esom emun. Mihekur vasi tounah keil onami imai. ");
INSERT INTO pma_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Munak kito en atan en out Kosen, nakilea malei kat kami. Sua elim (5) veah mul mai keke anien hetovuol. Ka ek rovattei keik, vuo onom keil vuo tounah keil koa milei kati avamat ven amai.’” ");
INSERT INTO pma_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Sakini alokovein out Isip ka uva ris teim ven tata one en out Kenan. ");
INSERT INTO pma_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Aviteni min tata one avit, “!Tata! !Siosep mul moul veah! !Kei vi Avat ten Kavmen en out Isip!” Siekob en von ka rokurtei anatin en keil. ");
INSERT INTO pma_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ka navong aviten tounah koa Siosep viteni min keil, ka les kat koa hos mul lehei koa Siosep sani vakur kei vaha en out Isip, kei leh revi ris eang onen ka lei kilea anatinien en selusien one. ");
INSERT INTO pma_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Kei vit, “!Anatin eli! Natkuli, Siosep, moul veah! Rovaha malesi mau. Nakilea hervitei tuetin nimat.” ");
INSERT INTO pma_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Sakini Siekob lah vasi tounah keil onen ka va mau en out Bersiba. En out enek, kei mumon sanien votut min Ahi koa Aesak, tata onen, va netan mini. ");
INSERT INTO pma_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","En vongien, Ahi selus mini en matil vovoien tai vit, “!Siekob! !Siekob!” Siekob vit, “?O-o, inau li ke?” ");
INSERT INTO pma_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","“Inau Ahi, navi Ahi onen tata onom. Konametautei kovaha en out Isip. Numon vatiamal onom hemai hehi mari kantri tai. ");
INSERT INTO pma_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Inau niha hetal minuk ka nikur koek en sise vaha en out Isip. Ka hekatau, nilah ris vatiamal onom hemai ris ekok. Ka Siosep emok heoteh koe metom navong kimat.” ");
INSERT INTO pma_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Navong Siekob mea ran out Bersiba, natnali keil aling kei ka titae keil ka ahin one keil en kat ten hos koa Asuv Houlu ten out Isip maeni ven keil. ");
INSERT INTO pma_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Keil alah buluk ka sipsip ese keil ka tounah keil koa alahi avong aro en out Kenan. Siekob va en out Isip ral min vatiamal onen. ");
INSERT INTO pma_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Anatin, va ral min natnali keil, natnahin keil, ka havinali ka havinahin keil emun. ");
INSERT INTO pma_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Siekob sila Sudah va mulamu vahis Siosep keke vahisu mini en out Kosen. Navong arokol out enek, ");
INSERT INTO pma_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Siosep vut en kat ten hos ka muloh va en out Kosen vahisu min tata onen. Navong luvisu, lukav kat keilu ka Siosep murang taveah emok. ");
INSERT INTO pma_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Siekob viteni min Siosep vit, “Munak nimat kosa, nimat hetal min tomat veni nalesuk en metok keke komoul.” ");
INSERT INTO pma_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Me-Isrel keil aro en out Kosen en kantri ten out Isip. Tounah keil one mai vi houlu ka titae keil umai avi houlu vis avi houlu mok. ");
INSERT INTO pma_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Siekob ro en out Isip sua teindan oulu (17), rokol avong sua onen vi handred tai hanumau elu ka oulu mun (147). ");
INSERT INTO pma_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Avong vahis muli, Siosep kur selusien tai koa vit, “Tata onom mesai.” Sakini, kur titan keilu, Manase ka Efrem, telva telsao eni. ");
INSERT INTO pma_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Navong Siekob longe keke natnali Siosep mai valesi, mun tina mea ka rondan en avet onen. ");
INSERT INTO pma_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Siekob viteni mini vit, “Navong naro veah en out Lus en atan ten out Kenan, Ahi ten Keihoen kistal venau ka rokol kat nau ");
INSERT INTO pma_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","vit, ‘Inau nisakin titam keil ihi houlu vis ihi houlu mok. Keil imai ihi mari vangi meatin keil. Ka atan ekek, nisani min vatiamal onom keil enek keke ito eni lises ka lisenges.’” ");
INSERT INTO pma_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Evus, Siekob viteni mun vit, “Siosep, ehon onom koa avasi keilu en out Isip mulamu en avong numai ekok, nikur kan keilu luhehi onak. Efrem ka Manase luhesuval ehon onak keilu, Ruben ka Simeon. ");
INSERT INTO pma_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Munak ehon tei ris ikistal enuk, ihi onom esuk. Atan koa keil ikuri, ikuri ran out koa nisani min Efrem ka Manase.” ");
INSERT INTO pma_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Sakini Siosep ling Efrem en usiven Siekob koa meil, ka Manase en usiven matu. ");
INSERT INTO pma_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ka Siekob mupes en hen esuk, ka ling hen matu mul en vatin Efrem, avaseini vi tasite. Ka hen meil, lingi mul en vatin Manase koa vi moeite. ");
INSERT INTO pma_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Evus, rokol kat Siosep vit, “Ahi koa Ebraham ka Aesak, tata keilu onak, lumusili, kei hetokol kat ehon keilu ekek. Ahi koa lei kat revi moulien onak rokol avong kosa, hetokol kat keilu. ");
INSERT INTO pma_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Ka angelo koa kur koe nau en avong tatisa keil, hetokol kat keilu. Isok ka isen tata onak keilu, Ebraham ka Aesak, telhemoul en ehon keilu ekek. Titaealu keil ihi houlu, ka vatiamal onealu ihi houlu mok en out netan.” ");
INSERT INTO pma_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Navong Siosep les tata onen ling hen matu mul en vatin Efrem, rositei veni. Sakini mul sak vakulat hen tata onen ran vatin Efrem ka valingi en vatin Manase. ");
INSERT INTO pma_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Kei viteni min tata onen vit, “!Vuo, romukteinek! Kiling hem matu hemai ekok en vatin koa moeite.” ");
INSERT INTO pma_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Tata onen seseini vit, “!Natkuli, nakilea! Vatiamal onen Manase imai ihi vangi meatin tai koa hemarite. Ka vatiamal onen tunali koa tasite imai ilin onen keil, imai ihi mari vangi meatin keil koa hehi houlu mok.” ");
INSERT INTO pma_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Sakini kei rokol kat keilu en avong enek vit, “Me-Isrel keil ihit usil keilu en avong ten tokolkatien ihit, ‘Ahi hetokol katuk hesuval koa kei mumoni en Efrem ka Manase.’” En sakien enek, Siekob ling Efrem mulamu en Manase. ");
INSERT INTO pma_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Evus, Siekob viteni min Siosep vit, “?Kolesi? Vesesal mamat. Ka Ahi heto venuk ka hekur keik kiha ris en atan esen avu onom keil.” Evus, Siekob vise ruain natnali sav keil, rokol kat keil ka viten tounah koa hekistal en vatiamal one keil en avong koa hemai veah. Ka min Sudah, viten selusien koanik: ");
INSERT INTO pma_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Sudah, tumali keil ihou lat isom. Keik ku vasin koakeil ivae hetal minuk, ka tumali keil iha netan enuk. ");
INSERT INTO pma_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Sudah suval laeon koa mu vini tirendan tai ka kani. Evus, va ris en vulin, mutelan ka matil. Ka meatin tovuol vaha vesesal veni. ");
INSERT INTO pma_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Hiasuvien ten keihoen onen asuv houlu keil hel lisenges en Sudah ka vatiamal onen. Meatin keil ten kantri sav ihouhou mini, ilong kati ka isan sanien keil one mini.” ");
INSERT INTO pma_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Navong Siekob san selusien ekor min natnali keil evus, mutelan risi en avet onen ka mat. ");
INSERT INTO pma_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Siosep ro nges ral min me-Isrel keil en out Isip rokol navong sua onen vi handred tai ka halualim mun (110). ");
INSERT INTO pma_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Kei moul semau les titan Efrem keil ka havinali keil. Les titan Makir koa vi natnali Manase, ka kur revi keil umai en vatiamal onen. ");
INSERT INTO pma_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Kei viteni min tunali keil vit, “Vesesal mamat, ka nakilea keke Ahi helei kat kami ka helah lat kami mihemea ran atan koanik. Helamun kami miheha en atan koa kei vat kati min Ebraham, Aesak ka Siekob.” ");
INSERT INTO pma_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Evus Siosep vis keil avoumon hatkatien tai mini vit, “Mihehat kati minau keke navong Ahi helamun kami miheha en atan enek, mihekur kat sik ran von tatetahinien onak hetal min kami ka mihetahini ien.” ");
INSERT INTO pma_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Rovitei tuetin, Siosep mat. Sua onen rokol handred tai ka halualim mun (110). Musil sakien onen me-Isip keil, asak revi teiai onen keke navotei ka alingi matil en bokis ten matien. ");
INSERT INTO pma_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Navong Siekob va en out Isip, natnali keil amusili ral min ahin one ka titae keil. ");
INSERT INTO pma_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Isen natnali keil koa amusili mukok: Ruben, Simeon, Livae, Sudah, ");
INSERT INTO pma_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isekar, Sebiulon, Bensamin, ");
INSERT INTO pma_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Navtali, Kat, ka Aser. ");
INSERT INTO pma_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Keil enek koa akistal en ran Siekob ral min titae keil, keil vasi arokol hanumau etel ka halualim emun (70). Natnali koa vi Siosep mul tuai en out Isip. ");
INSERT INTO pma_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Avong houlu muli, ka Siosep ral min tunali keil ka meatin sav keil koa umai en avong enek umatmat. ");
INSERT INTO pma_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Ka titae keil aro en out enek ka akur titae va vio … umai avi houlu vis avi houlu mok. Navong vesesal sua handred ehat (400) mai muli, me-Isrel keil umai avi houlu en out Isip, vesesal vahi keil enges. ");
INSERT INTO pma_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Evus, aling asuv houlu hau tai valosil kat kantri ten out Isip, ka kei en rovattei vailea Siosep ka umen keil onen. ");
INSERT INTO pma_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Kei viteni min meatin onen keil vit, “Me-Isrel keil avi houlu ramat ka keihoen one muli ir. ");
INSERT INTO pma_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Munak kantri sav tai houmon rea hetal min ir, me-Isrel keil akilea avatas vatal min keil ka u vini ir ka ilohosai ran kantri orer. Ven koanik, rehelekat sise koa vasakin keil irvitei mun houlu.” ");
INSERT INTO pma_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Sakini me-Isip keil asakin keil umai avi slev keil one. Aling meatin koan avi houlu en keil ka asak purun me-Isrel keil. Avetin onen me-Isrel keil mumon mari meteimal keilu ten out Pitom ka Rameses avaling seh en tounah keil onen asuv houlu ten out Isip val ien. ");
INSERT INTO pma_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Ka navong meatin keil ten out Isip amum keih min me-Isrel keil, keil esuk avi houlu tamun ka asien out vasi. Meatin vasi keil ten out Isip umai amul ametaun keil. ");
INSERT INTO pma_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Sakini me-Isip keil asak visi avou vini keil en umen. ");
INSERT INTO pma_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Asakin keil amumon mari eim keil, avous tounah keil tameas, amum keih en ah ese, ka amumon umen tateisav keil koa takeih. En sise houlu, amul asakin moulien onen me-Isrel keil keih ramat, e romahistei keil. ");
INSERT INTO pma_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Mukos, me-Isrel keil umai avi houlu mok. Sakini, asuv houlu ten out Isip meng kat meatin onen keil vit, “Mihekur tivava vasi keil one koa avi meahos, ka mihetitivin keil ihaha en mari Oaisal Nael. Ka tivava keil koa avi atouli, mihemaen keil imoul.” ");
INSERT INTO pma_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","En avong enek, meatin tai koa kistal en vatiamal onen Livae retalihe ral min ahin tai en mari vatiamal eris onen. ");
INSERT INTO pma_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Ka ahin onen kur titaealu tai koa vi meahos. Navong lesi keke tivava enek moreite mok, kei ling suaini avati etel. ");
INSERT INTO pma_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Ka navong lesi keke sakras emun valing suaini, kur ateli tai koa amumoni en vati oumunai koa marite. Evus, muta koe en koltar vasakini oai sakras vaha neim ien. Evus, ling tivava onen eni ka lingi sesai en vali Oaisal Nael koa oumunai tetaveah amoul ien. Evus, kei va. ");
INSERT INTO pma_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Ka ahinali tivava enek vati mul soutin neli vales asa vakula, isen Miriam. ");
INSERT INTO pma_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","En hati avong koanik, natnahin asuv houlu mita en vali oaisal vakul. Kei mita ral min atouli toumien onen keil ka amul akarahiti ka alei kokoe eni. Rovitei tuetin, atouli enek lei silat ateli enek en oumunai keil koa tetaveah ka sila atouli toumien tai onen vakuri. ");
INSERT INTO pma_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Navong sani mini, natnahin asuv houlu poh lat meten ka lesi keke titi ehon mul ien, mul mis. Kei en mahisi ka vit, “Kei vi ehon tai li onen me-Isrel keil.” ");
INSERT INTO pma_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Navong ahinali titi ehon lesi mukok, mea visi vit, “?Maha mahis etai ahin Isrel vamai vatounat eni minuk?” ");
INSERT INTO pma_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Ka viteni mini vit, “Tahos, kumoni.” Sakini atouli va, kur mama kati onen ehon mai veni. ");
INSERT INTO pma_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Natnahin asuv houlu viteni mini vit, “Kikur titi ehon ekek ka kisan susu mini. Navong helokovein susu, inau nikuri hehi onak ka nihul keik ven umen onom.” Sakini, kuri ka rounat eni. ");
INSERT INTO pma_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Navong ehon enek mai mariso, kur risi ka sani min natnahin asuv houlu. Natnahin enek kur kani mai suval natnali kati ka ling isen vi ‘Mosis’ koa aneite teni vi ‘naleh lati’ veni vit, “Nihise hemukonek veni naleh lati ran oai.” ");
INSERT INTO pma_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Sua houlu muli ka Mosis moul mai vi mari meatin tai. Ka avong tai, kei va mul sao en meatin onen keil ka lesi keke me-Isip keil asak purun me-Isrel keil en umen takeih keil. Lesi mun koan Isip mul mu vini koan Isrel tai, ka Mosis lei kilea vi tue tai. ");
INSERT INTO pma_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Mosis lei rahit out ka lesi keke meatin tovuol valesi, sakini mu vini koan Isip, rahin suaini en veien en out enek, ka va ris teim sen. ");
INSERT INTO pma_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Out mulan eni, va ris ka les me-Isrel elu lumul lumuti keilu. Viteni min kei koa mum tisa vit, “?Vensa komul komuti ris tumali?” ");
INSERT INTO pma_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Meatin viteni vit, “?Isei linguk kovi asuv onomai keke kovalei revi usite onomai? ?Kovit kovouas nau vasuval koa komu vini koan Isip nenganeh?” Selusien onen sakin Mosis metau ka vit sasen eni vit, “Meatin keil akilea tuai asa koa namumoni.” ");
INSERT INTO pma_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Ka navong asuv houlu ten out Isip raengon asa koa kur out, kei lekat sise vouas Mosis. Ka Mosis lohosai va soutin en atan ten out Midia. Navong Mosis rokol Midia, pris tai onen me-Mid keil koa isen Setro maen Mosis ro ral mini. Avong muli, ka pris san natnahin mini. Kei kur titan ka aling isen vi ‘Kersom.’ Ka Mosis kataun keil ka lei kat sipsip ese keil vesesal sua hanumau elu (40). ");
INSERT INTO pma_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Avong tai, Mosis mul lei kat sipsip ral nani keil esen avu tisa onen koa isen Setro koa vi pris tai onen me-Mid keil. Mosis mulamun keil amu koteh out volvol ka uva vesesal ven Vatihou Senae koa vi votut onen Ahi. ");
INSERT INTO pma_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Ekonek, angelo tai onen Iahova kistal veni suval ahang koa mul rekau en holeai tai. Mosis lesi keke ahang enek mul mukan ka rokantei varei holeai koanek. ");
INSERT INTO pma_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Kei mundemi vit, “!Koanik vi tounah sal tai! ?Vensa ahang rokan lintei holeai enek? Maha vesesal malei visi.” ");
INSERT INTO pma_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Navong Iahova les Mosis mul mai vesesal, vise ka en holeai enek vit, “!Mosis, Mosis!” Ka Mosis vit risi mini vit, “O-o, inau li ke.” ");
INSERT INTO pma_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Ahi viteni mini vit, “Konamaitei vesesal. Kulat sandel onom veni atan koa komulomal ien vi votut. ");
INSERT INTO pma_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Inau navi Ahi onen avu onom keil: onen Ebraham, onen Aesak ka onen Siekob.” Navong longe mukok, Mosis kur koe nan veni ulin metau vales Ahi. ");
INSERT INTO pma_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Evus, Iahova viteni mini vit, “Nales mahien onen meatin keil onak en hen me-Isip keil. Nalong tangien one ven avat toumien one keil amumoni keih min keil. Anatin, inau nakilea mahien keil vasi one, ");
INSERT INTO pma_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","sakini namita netan malah lat keil ran hen me-Isip keil. Nilamun keil iha en out tai koa tahos imok, out koa amas mul ien. Atan koanek, kosa meatin sav keil ekek amul ien: me-Kenan keil, me-Hit keil, me-Amor keil, me-Peres keil, me-Hiv keil, ka me-Sebus keil emun. Avaseini, nikulat keil ka nisani suk min me-Isrel keil. ");
INSERT INTO pma_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Nalong tangien onen meatin keil onak ka nalesi mukave meatin keil ten out Isip amul apurun keil en umen takeih. ");
INSERT INTO pma_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Sakini, kosa, nisilak kihita ven asuv houlu ten out Isip keke kovalah lat meatin keil onak ran kantri onen.” ");
INSERT INTO pma_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Ka Mosis viteni min Ahi vit, “Inau navi meatin kuren enges. Nasakras maha ven asuv houlu ka malah lat me-Isrel keil ran out Isip.” ");
INSERT INTO pma_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Ahi vit kesi mini vit, “Inau ialu minuk. Ka navong kilah lat meatin keil ran out Isip, kilamun keil mihemai en vatihou koanik ka kimot venau. Hemukonek, keik kilea keke inau nasilak.” ");
INSERT INTO pma_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Ka Mosis vit risi mini vit, “?Ka munak niha ven me-Isrel keil ka nihiteni min keil nihit, ‘Ahi onen avu onami keil, kei sila inau numai ven kami,’ ka keil ihis inau ihit, ‘?Isen isei?’ ka nihiten sa min keil?” ");
INSERT INTO pma_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Ahi viteni mini vit, “!Inau navi kei koa NAVI! Kiha kihiteni mok min keil kihit, ‘Kei koa isen Iahova koa aneite teni vi “NAVI,” kei sila nau numai ven kami.’ ");
INSERT INTO pma_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Kihiteni min keil keke Iahova sanuk kuva ven keil. Inau, Iahova, navi Ahi onen avu one keil: onen Ebraham, onen Aesak, onen Siekob. Iahova hehi isok, hel sesuk, ka koakeil ikatau en kami ihise nau eni.” Navong Mosis selus min Ahi evus, va ris teim ka sak mesein kei keke vaha en kantri ten out Isip. Ka navong musil sise vaha en out Isip, visu min tunali koa isen Eron koa Ahi sila veni. Mosis viteni mini tounah keil koa Ahi mumoni mini. Evus, luva. Ka navong lurokol kantri ten out Isip, luva lules hetetamen keil onen me-Isrel keil. Ka navong along selusien onealu, asi keil keke Ahi les mahien one ka san meatin tai vamai vakataun keil. ");
INSERT INTO pma_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Katau en marmari tounah keil ekek, Iahova viteni min Mosis vit, “Nisan mahien hetas sesuk heha min asuv houlu ten out Isip ka meatin keil onen. Evus, kei hemaen kami miheha. Anatin, hekeih esuk keke kami miheha hetal min tounah vasi keil onami. ");
INSERT INTO pma_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Helamu, kihiteni min me-Isrel keil keke keil vasi ihis me-Isip keil koa aro vesesal ven keil keke isani min keil mormore tounah keil koa amumoni en gol ka silva.” ");
INSERT INTO pma_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Ka Iahova sakin me-Isip keil avouhou min keil esuk. Ka Mosis emun mai vi mari meatin tai en meten hetetamen keil onen asuv houlu ka meatin vasi keil ten out Isip. ");
INSERT INTO pma_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Mosis va ris ven asuv houlu ten out Isip ka viteni mini vit, “Koanik vi selusien onen Iahova, ‘En metavinavong, nika vasi atan ten out Isip, ");
INSERT INTO pma_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","ka nisakin moeite vasi keil ten out Isip koa avi meahos imatmat: kei koa hekur vulin asuv houlu hekatau, hehita hevus en moeite onen ahin keil toumien koa amul asak mesein anien. Ka en buluk ka sipsip keil emun, moeite one imatmat. ");
INSERT INTO pma_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Tangien heka vasi out Isip. Hetisa mok helin asa koa kur out en avong telamu, vuo asa koa hekur out en avong keil koa hemai. ");
INSERT INTO pma_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Ka en out onen me-Isrel keil, tangien hetovuol, out hetaeng. Huli keil emun irmis kattei meatin vuo buluk ka sipsip keil. Hemukonek, miheilea keke inau, Iahova, nalei kan me-Isrel keil ateisav ran me-Isip keil.’” ");
INSERT INTO pma_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Navong Mosis mul selus, tin kati ka viteni mun mini vit, “En avong koanek, hetetamen keil onom imai, iha netan minau. Keil ipeah nau keke malah lat meatin keil onak iha ran keil. Hevus, niha suk.” Navong selus evus, Mosis mea ran asuv houlu enek. ");
INSERT INTO pma_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Iahova selus min Mosis ka Eron en out Isip vit, ");
INSERT INTO pma_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Avati koanik hemai hehi avati koa helamun avati sav keil en sua keil koa hemai. ");
INSERT INTO pma_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Milhehit mesein selusien koanik min me-Isrel vasi keil: en avong koa hehi halualim (10) ten avati koanik, meatin vasi keil iling revi sipsip vuo nani tai koa avaani en teim se. ");
INSERT INTO pma_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Ka munak keil en teim tai asakras avaan vasin sipsip tai, akilea avatiti vuseri koanek vatal min teim tamun koa mul vesesal ven keil. Keil ititi hemal en meatin ehis koa avaani. ");
INSERT INTO pma_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Mihekur sipsip vuo nani koa hemukok: sua onen hetas, hehi meahos enges, ka tounah hetovuol hekula. ");
INSERT INTO pma_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Mihelei kati teim hetokol avong koa vi teindan ehat (14) ten avati koanik. Ka navong out vong, me-Isrel keil vasi u vinvini sipsip keil enek. ");
INSERT INTO pma_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Navong meatin tai hou vini esen hevus, hesien lelat tei ara ka hekuri heha en out koa ian vuseri ien. Hevus, hekas pos ten metareh eni, en out nesa ka en usite keilu teni. ");
INSERT INTO pma_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","En vongien enek, meatin keil ikur vuseri enek ka ilengasi enges. Iani hetal ouai keil koa kon ka veret koa is tovuol eni. ");
INSERT INTO pma_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Minaantei koa romastei vuo koa akukoni en oai. Ka mihelengas mouni enges, hetal vatin, alen keil ka tin vasi koa tahos taanien. ");
INSERT INTO pma_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Minaan rantei natokol visokon. Munak hatte etai heles, mihenit lini. ");
INSERT INTO pma_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Navong mihean anien koanek, mihoumoni hesuval mimual en sise mivaha: mihesin en eisin keil toualien, miheheas sandel onami, mihekur kat eisal onami, ka mihean kekerati. Anien ten Mul Laui koanik hehi sanien votut min Iahova. ");
INSERT INTO pma_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“En vongien enek, nika vasi out Isip, nu vasi moeite keil koa avi meahos, onen meatin vasi keil ka onen buluk ka sipsip vasi keil emun. Inau, navi Iahova, ka nisan mahien heha kat ahi keil onen me-Isip keil. ");
INSERT INTO pma_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Navong nimai ka niles ara mul en pos ten metareh keil, hetie lati minau keke miro ien ka nil laui teim sami. Hesakini mahien koa nisani min me-Isip keil hersuttei kami. ");
INSERT INTO pma_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“Avong koanek, mihekur kati lises. Mihesakin avong enek hemai hehi avong votut tai. Mihoumon ale teni en sua vasi keil koa hemai, hesakin kami mihendem kat ris tounah koa inau, Iahova, namumoni.” ");
INSERT INTO pma_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Ahi viteni vit, “Avong heite oulu (7), miherkantei veret koa is mul ien. Mihean enges veret koa mahinhin. En avong koa mulamu en keil, mihelah lat vasi is keil ran teim sami. Mihetivini heha, veni en avong koa heite oulu (7) enek, meatin koa hean veret koa is mul ien, kei, mihesila lati heha ran kami, hervitei mun koan Isrel tai. ");
INSERT INTO pma_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","En avong oulu (7) enek, koan mulamu ka koan ekor en keil, mihelah ruai keke miheha netan minau. Umen hetovuol en avong keilu enek, ka mikileas mivasak mesein anien. ");
INSERT INTO pma_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Mihehuli kat avong keil ten veret koa is tovuol ien enek en sua vasi keil koa hel hemai, ven koa en avong enek, inau nalah lat kami ran out Isip.” ");
INSERT INTO pma_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Navong avong teni mai, en metavinavong ten vongien, Iahova mita ka mu vinvini moeite vasi keil ten out Isip koa avi meahos: koa vakur vulin asuv houlu hekatau, vita rokol moeite onen koakeil amul en eim takeih. Moeite vasi keil emun onen buluk ka sipsip keil umatmat. ");
INSERT INTO pma_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","En vongien enek, asuv houlu ral min hetetamen onen keil, ka meatin vasi keil ten out Isip amuli. Mari tangien karahit out Isip veni teim tovuol keke ehon etai varmattei ien. ");
INSERT INTO pma_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","En vongien enek, asuv houlu sisil en Mosis keilu Eron ka vit, “!Mihemea, miheha ran meatin keil onak ka miheha ran kantri onak, kamil hetal min me-Isrel vasi keil! Miheha netan min Iahova suval koa milvis inau eni. ");
INSERT INTO pma_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Suval koa milviteni, mihekur kat sipsip, nani ka buluk keil esomi ka mihehaha. Ka navong mihoumoni, milhehisi li mun min Iahova keke hetokol kat inau mun.” ");
INSERT INTO pma_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Me-Isip keil vasi emun apeah keil keke aloh konakon avamea lah ran out one veni avit, “Komai vasi mehematmat munak kami mihervatei.” ");
INSERT INTO pma_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Me-Isrel keil amea ran taon ten out Rameses en out Isip, amuales arokol meteimal ten out Sakot. Keil avi houlu vis avi houlu mok: amo keil enges rokol handred taosen ahetai (600,000), ka atou keil ral min titiali keil one, arvulitei keil. ");
INSERT INTO pma_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Meatin houlu mun koa arvitei tai en me-Isrel keil amusil keil. Ka meatin keil amulamun sipsip, nani ka buluk sav emun keil koa avi houlu. ");
INSERT INTO pma_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Keil aran veret koa is tovuol ien koa asak mesein pulaoa teni tuai en out Isip. Ven me-Isip keil akeih kat keil, keil aro konakon avaha. Sakini avong rovinvintei keke avatosil is vasuv lat pulaoa, vuo avasak revi anien sav keil ten sise. ");
INSERT INTO pma_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Avong koa me-Isrel keil umai rohtoh en out Isip rokol avong avaha rani, aro en out Isip sua handred ehat hanumau tai ka halualim emun (430). ");
INSERT INTO pma_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Ahi viteni min Mosis keilu Eron vit, “Koanik vi mengkatien keil ten Anien ten Mul Laui: meatin keil ten kantri sav asakras avaani. ");
INSERT INTO pma_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Ka slev keil koa mivuli ka mimumon vekahoi en keil, keil akilea avaani. ");
INSERT INTO pma_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Meatin koa hemai ten avong havivis, vuo avuli ven umen ten avong havivis, kei sakras vani. ");
INSERT INTO pma_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Anien vasi keil enek, iani en eim koa amumoni ien. Anakurtei naha hae ka anakur vul etai sin sipsip enek. ");
INSERT INTO pma_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Me-Isrel vasi keil umon ale koanik.” ");
INSERT INTO pma_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Iahova viteni min Mosis vit, ");
INSERT INTO pma_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Moeite vasi keil koa avi meahos ihi onak: onen me-Isrel keil ka onen buluk ka sipsip keil ese emun.” ");
INSERT INTO pma_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Sakini Mosis viteni min meatin keil vit, “Iahova helamun kami miheha en atan esen me-Kenan keil, out koa vat kati tuai min kami ka avu onami keil. Navong hesani min kami ka miheto ien, ");
INSERT INTO pma_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","mihesan risi mini moei ehon ihi onen. Mihoumoni emun min moeite onen buluk ka sipsip vasi keil esomi koa avi meahos. ");
INSERT INTO pma_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Ka en moeite ten dongki tai esomi koa vi meahos, mikilea mivahul lati ran Iahova en sipsip tai. Munak emi hervattei mivahul lati, mihekur vul hiren enges. Ka en moei ehon onami keil emun, mihehul lati ran Iahova. ");
INSERT INTO pma_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Sakini en avong keil koa hemai, munak natmali hehisuk en usite ten aneite ten sakien koanik, kihiteni mini kihit, ‘Navong rovi slev veah en out Isip, Iahova lah lat ir ran out enek ral min mari keihoen onen. ");
INSERT INTO pma_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Navong lesi keke asuv houlu ten out Isip, vatin keih ka en rovattei vamaen ir rovaha, kei mu vasin moei ehon keil vasi onen me-Isip keil vita rokol moeite ten buluk ka sipsip keil ese. Ven koanik varei, rosa vasi moulien onen moeite koa avi meahos ten buluk ka sipsip keil oser avahi sanien votut vaha min Iahova. Ka en moei ehon keil orer, rovul lat keil rani.’ ");
INSERT INTO pma_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Sakien keil ekek hehi metai hesuval tounah tai koa ropar kati hel en vatir vuo her vasakin ir rehendem kati keke Ahi lah lat ir ran out Isip ral min mari keihoen onen.” ");
INSERT INTO pma_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Katau en avong koanek, me-Isrel keil amemea ran meteimal ten out Sakot ka uva en out Itam koa mul en valite ten out volvol. Ekonek, amumon votevav keil. ");
INSERT INTO pma_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Ka Ahi mulamun keil, en meneai alesi suval mahmah koa mulomal vina nesa ka mul mulamun keil, ka en vongien, viles mai vi mari ahang koa ritin en sise vasan meneai min keil. Sakini keil akilea avoual en meneai ka vongien. ");
INSERT INTO pma_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Navong asuv houlu ten out Isip raengoni keke me-Isrel keil avaha tuai, kei ral min hetetamen onen keil, rendemien one viles ka avit, “?Asanei ke romul romumoni? !Romaen me-Isrel keil alohosai ran ir, ka keil irmumontei mun umen keil orer!” ");
INSERT INTO pma_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Sakini asuv houlu vita ka vis meatin tavaeen keil onen isak mesein keil ka hos esen keke heleh kat tavaeen onen. ");
INSERT INTO pma_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Asak mesein keil evus, asuv houlu muloh en kat onen ka rie lat more kat tavaeen sav keil heite handred ahetai (600) koa hos mul lehei keke avat tavaeen keil onen akilea avaloh eni. Ka hetetamen tavaeen sav keil emun onen akur kat teisav keil ka amusil keil. ");
INSERT INTO pma_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Iahova sakin rendemien onen asuv houlu keih tamun keke valikat me-Isrel keil. Ka navong asuv houlu ka meatin keil onen amul umai, me-Isrel keil areingeingeni. Amual amarir ka rendemien konakon tovuol emun en keil. ");
INSERT INTO pma_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Ka meatin keil tavaeen ten out Isip amuloh akatau usil keil: koakeil koa amuloh en kat tavaeen, koa mun amuloh en hos, ka koakeil emun amual enges. Avotin me-Isrel keil esuk navong keil amul amuseh en vali Atas Tahilhili, vesesal en taon elu koa avise keilu en Vi-Hahirot ka Baal-Sevon. ");
INSERT INTO pma_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Navong me-Isrel keil ales asuv houlu ka meatin tavaeen onen keil umai, keil ametau vis ametau ka amurang vina min Iahova ven kataunien. ");
INSERT INTO pma_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Keil aviles ka aviteni min Mosis avit, “?Koles asa koa komumoni navong kolah lat komai ran out Isip? ?Out tatetahinien rovinvintei en out Isip keke sakin keik kolah lat komai memai en out volvol ekek mevamatmat? ");
INSERT INTO pma_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Koanik suval tounah koa meviteni minuk hemai hekistal. Navong romul veah en out Isip, meviteni minuk mevit kovasokovein komai mevales mevahi slev onen me-Isip keil. Hetahos imok keke mehehi slev keil keiva, helohlin koa mehematmat en out volvol ekek.” ");
INSERT INTO pma_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Ka Mosis viteni min keil vit, “!Minametautei! Mehelomal hekeih ka miheles asa koa Iahova houmoni ven kami kosa. Me-Isip keil enek, miherlestei mun keil. ");
INSERT INTO pma_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Iahova keinges hehu en usite onami, ka kami mihermumon etai tounah.” ");
INSERT INTO pma_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Iahova viteni min Mosis vit, “?Vensa komul korangis kataunien venau? Hiteni min me-Isrel keil avamea avasak mesein keil avaha. ");
INSERT INTO pma_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Kihat lat eisal onom ka kihuli kati hehina nesa en atas. Hesakin atas heleh vasi helu, ka meatin keil akilea avoual koteh atas en atan tames. ");
INSERT INTO pma_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Inau numon rendemien onen me-Isip keil hekeih keke avakatau usil kami. Nihat lat isom helohlin isen asuv houlu ten out Isip navong nilin kei hetal min meatin tavaeen onen keil: koakeil amuloh en kat one, koakeil amuloh en hos, ka koakeil emun amual enges. ");
INSERT INTO pma_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Navong nilin keil, me-Isip vasi keil ilea suk keke inau navi Iahova.” ");
INSERT INTO pma_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Angelo tai onen Ahi koa mul mulamun meatin keil tavaeen onen me-Isrel keil en ualien one, kei viles va en eisile keke vating koe keil. Ka mahmah onen Ahi emun musili, ");
INSERT INTO pma_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","mul vas me-Isrel keil ka me-Isip keil. Mahmah enek san mankoli min me-Isip keil, ka en usite onen me-Isrel keil, san meneai min keil. Sakini en vongien enek, keil asakras avamai vesesal ven me-Isrel keil. ");
INSERT INTO pma_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","En vongien enek, Mosis mutea lat eisal onen nesa en atas, ka Iahova sakin mari eang tai ka en out ist, mai muh vas atas. Ka navong me-Isrel keil alele, alesi keke atas leh vasi tuai, out luhu mai vi atan tames. ");
INSERT INTO pma_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Atas vi vieh en usite keilu, ka en vongien enek, me-Isrel keil amual kotehei en atan tames enges. ");
INSERT INTO pma_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Navong me-Isip keil alei kilea keke me-Isrel keil amul uva, keil amuloh alikat keil en out tames en atas enek: koakeil en kat one, koakeil en hos keil, ka koakeil emun amual enges. ");
INSERT INTO pma_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Vesesal out valan, Ahi mules en ahang koa taveah vina nesa ka les meatin tavaeen keil ten out Isip. Evus, mumon keil alei konakon ka arendem konakon. ");
INSERT INTO pma_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Ahi mumon wil ten kat one averai, asakras avakarali revi. Sakini me-Isip keil avit, “!Rovahaha ran me-Isrel keil ven Iahova mul vuhu en usite one!” ");
INSERT INTO pma_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Iahova viteni min Mosis vit, “Kitea lat hem heha nesa en atas, ka hemai suk hemavul koe me-Isip keil ral min hos ka kat keil one.” ");
INSERT INTO pma_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Sakini, navong meteiai roha, Mosis mutea lat hen ka atas mai ris en vulin. Me-Isip keil asak somok avamea, ka Iahova sakin atas rein keil vasi uva en huinev. ");
INSERT INTO pma_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Atas muris mai, mutaluh koe vasin meatin tavaeen keil ten out Isip ral min hos keil ka kat keil one koa amusil me-Isrel keil uva en atas. Tovuol en keil vamoul. ");
INSERT INTO pma_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Ka me-Isrel keil, keil amual koteh atas en atan tames, atas vi vieh en usite vasi keilu. ");
INSERT INTO pma_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","En avong enek, Iahova lah lat me-Isrel keil ran hen me-Isip keil, ka ales teiai keil one umatmat amul en vali atas. ");
INSERT INTO pma_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Navong me-Isrel keil ales mari keihoen koa Iahova rie lati navong mu vini me-Isip keil, ametauni ka avouhou mariso mini. Keil aling demkatien one eni ka en Mosis koa vi meatin toumien onen. ");
INSERT INTO pma_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Evus, Mosis mulamun me-Isrel keil ran Atas Tahilhili ka uva en out volvol ten out Sur. Avong etel keke amual koteh out volvol enek, ka arvotin etai oai. ");
INSERT INTO pma_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Umai suk en out tai koa oai mul ien, ka oai enek kon, asakras avamuni. Sakini avise out enek en ‘Marah’ koa aneite teni vi ‘kon.’ ");
INSERT INTO pma_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Meatin keil arun kutut kat Mosis avit, “?Asa suk keke rehemuni?” ");
INSERT INTO pma_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Mosis murang min Iahova en hisien, sakini rie lat mavuli ai tai mini. Ka navong soni va en oai koa kon, sakin oai mai kas. Ka meatin keil akilea suk avamuni. ");
INSERT INTO pma_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Avong vahis muli, me-Isrel vasi keil uva ran out avise en Alim. Ka en avong koa vi teindan elim (15) ten avati koa elu, mulin avati tai katau en avong amea ran out Isip, keil umai en out volvol koa avise en ‘Saen.’ Saen mul luhu Alim keilu Vatihou Senae. ");
INSERT INTO pma_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Ekonek, keil vasi arun kutut kat Mosis keilu Eron ");
INSERT INTO pma_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","avit, “Tahos imok keke Iahova vou vinvini komai tuai en out Isip. Ekonek mekilea mevatondan ka mevan vuseri ka tounah sav teimun keil vahi houlu. ?Vensa kamil millah komai memai en out volvol ekek amai val vat komai ka mevamatmat?” ");
INSERT INTO pma_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Iahova viteni min Mosis vit, “Kosa numon anien hetivtiv hesuval ous koa mus heka en teilang hemita ven kami vasi. Meatin keil iha en avong vasi, ilahi hevinvin enges ten avong enek. En sise koanik inau nisak vis keil keke nihotini usil kat selusien keil onak vuo irmusiltei. ");
INSERT INTO pma_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","En avong ahetai (6) ten wik vasi keil, akilea avalahi ka avasak meseini vavinvin ten avong elu.” ");
INSERT INTO pma_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Iahova viteni min Mosis vit, ");
INSERT INTO pma_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Naraengon selkututien onen me-Isrel keil. Kihiteni min keil keke en mendilah enek, keil ian vuseri, ka en visokon, keil akan vini keil en veret. Hesakini keil ilea keke inau, Iahova, navi Ahi one.” ");
INSERT INTO pma_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","En mendilah enek, aman keil koa avise keil en ‘kuel’ umai asien out koa amul ien, ka amuas keil ka akan vini keil eni. Ka en visokon, out vasi memer en tilep. ");
INSERT INTO pma_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Navong meteiai kan out memes, ales tilep mai vi tounah tai koa mahinhin ka mukut, mul en atan ka tounah vasi. Ka navong arokoli, merangle. ");
INSERT INTO pma_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Navong me-Isrel keil alesi, alei rasi ka amul avis ris keil en selusien one avit, “?Manna?” koa aneite teni vi “?Asa keinek?” Mosis viteni min keil vit, “Koanik anien koa Iahova sani min kami mivani. ");
INSERT INTO pma_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Iahova meng kat kami keke kami vasi mihesien mari kap helu ven meatin tetai. Mihelahi hevinvin en asa koa teim onami akilea avaani en avong vatas.” ");
INSERT INTO pma_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Me-Isrel keil amumoni suval kei viteni: koan en keil alahi houlu, ka keil en koa alahi havivi enges. ");
INSERT INTO pma_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Navong avuli kap teni, koakeil alahi houlu alesi vinvin en teim one, ka koakeil alahi havivi enges, keil emun alesi vinvin en teim one. Keil vasi alahi vinvin en keil. ");
INSERT INTO pma_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Mosis viteni min keil vit, “Tovuol en kami helingi hetokol visuvong.” ");
INSERT INTO pma_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Ka keil koa arlong kattei Mosis ka avit avaling tei vales vatokol visokon. Ka en visokon enek, manna enek, oul keil akikistal ien ka vite vo. Navong Mosis lesi, vuroh kat keil. ");
INSERT INTO pma_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","En visokon vasi, meatin vasi keil uva alahi vinvin enges ven teim se. Ka navong meteiai sakin out mai mutin, asa koa mules en atan mukurle. ");
INSERT INTO pma_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","En avong ahetai (6) ten wik, keil alahlah manna vinvin ten avong elu, kap ehat onen meatin tetai. Hetetamen keil ten vatiamal keil umai ales Mosis ka avit usili mini. ");
INSERT INTO pma_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Kei viteni min keil vit, “Ahi meng kati keke visuvong hehi avong votut tasehien, vi Sabat onen. Sakini kosa, asa koa mivit mivani, kei mihetani vuo mihekukoni en oai usil rendemien onami. Ka hatte koa hehi teisao, miheling revi heles hehi ten visuvong.” ");
INSERT INTO pma_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Suval koa Mosis meng kat keil eni, keil aling revi koa teisao rokol avong out mulan ka kei rotisatei, oul keil arkistaltei ien. ");
INSERT INTO pma_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Mosis vit, “Kosa, mihean koanik ven kosa vi Sabat onen Ahi, avong votut tasehien. Mihervotin etai anien hae en out roro ien. ");
INSERT INTO pma_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Avong ahetai en wik miheha mihelah anien ami, ka en avong oulu (7) koa vi Sabat, mihervotintei.” ");
INSERT INTO pma_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Avaseini Mosis viteni mukonek, en avong oulu ten wik, meatin keil koan uva avalahlah anien ka arvotintei. ");
INSERT INTO pma_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Sakini Iahova viteni min Mosis vit, “?Kami miheles mihesesein mengkatien keil onak hetokol avong sa? ");
INSERT INTO pma_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","!Milesi! Inau, Iahova, nasan avong tai tasehien min kami. Ven koanik, en avong koa vi ahetai (6) ten wik vasi keil, nisan anien min kami hevinvin ten avong helu. Ka en avong oulu (7) ten wik, meatin vasi keil itos en out koa keil amul ien, meatin hetovuol houal ran teim onen.” ");
INSERT INTO pma_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Sakini, meatin keil armumtei en avong oulu. ");
INSERT INTO pma_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Me-Isrel keil avise anien enek en ‘manna.’ Kei suval titi utiai koa muoh, ka akani kas suval kek koa hani mul ien. ");
INSERT INTO pma_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Me-Isrel keil vasi amemea ran out volvol ten out Saen, umai en out tai. Evus, uva en out sav, musil selusien onen Iahova. Amumon votevav one en out tai koa avise en Revidim, ka oai tovuol en out enek koa avamuni. ");
INSERT INTO pma_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Keil aselus kutut kat Mosis avit, “!San oai min komai mevamuni!” Ka Mosis vit, “?Vensa misel kutut kat nau? ?Vensa mivit mivasak vis Iahova keke hetie lat keihoen min kami lises?” ");
INSERT INTO pma_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Ka meatin keil, maroro kat keil houlu ka amules aselus kutut kati ka avit, “?Vensa kokulat komai ran out Isip? ?Titiali keil onomai ka buluk ka sipsip keil emun tive memes, kovit kovou vini komai en maroro?” ");
INSERT INTO pma_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Sakini Mosis vis keih min Iahova vit, “?Numon sa min meatin keil ekek? Vesesal avov nau.” ");
INSERT INTO pma_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Iahova viteni min Mosis vit, “Kikur hetetamen tei keil onen me-Isrel keil, kilah ruain keil mihelamu en meatin sav keil. Kikur kat eisal onom koa komuas Oaisal Nael eni. ");
INSERT INTO pma_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Nilomal vesesal ven mari ahat tai en Vatihou Senae. En out enek, kuas ahat enek ka oai hekistal houe rani ka meatin keil imuni suk.” Sakini, Mosis mumoni mukonek en meten hetetamen onen me-Isrel keil. ");
INSERT INTO pma_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","En out enek aling isen ‘Meribah’ koa aneite teni vi ‘selkututien’ veni aselus kutut kat Mosis. Ka aling isen tamun vi ‘Massah’ koa aneite teni vi ‘sakvisien’ veni asak vis Iahova navong avisi avit, “?Iahova mul ven ir vuo romultei?” ");
INSERT INTO pma_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Navong me-Isrel keil amul en out Revidim, me-Amelek keil umai ka avit avahu vatal keil. ");
INSERT INTO pma_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Mosis viteni min Sosua vit, “Kitie lat tei meatin keil miheha mihouas me-Amelek keil. Visuvong, out helan, inau nikur eisal onak koa Ahi viteni keke makuri, ka nihatimal vina nesa en hou ekek.” ");
INSERT INTO pma_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Sakini Sosua mumon tounah suval koa Mosis viteni mini, mulamun meatin onen keil uva avuhu ral min me-Amelek keil. Ka Mosis kur Eron ka Hur, telvina en hou nesa. ");
INSERT INTO pma_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Mosis san hen vina nesa, ka navong hen mul nesa me-Isrel keil amulin me-Amelek keil. Ka navong hen keilu mita ris netan, me-Amelek amuli keil esuk. ");
INSERT INTO pma_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Navong hen Mosis maimai, Eron keilu Hur luvous ahat tai mai mini vatondan ien. Ka keilu lumulomal en usiven keilu, lusuv kat hen Mosis rokol avong meteiai munu. ");
INSERT INTO pma_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","En sakien enek, Sosua ka meatin keil onen amu lin me-Amelek keil. ");
INSERT INTO pma_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Avu tisa onen Mosis, kei vi pris onen me-Mid keil ka isen Setro. Kei raengon longlongien usil tounah vasi koa Ahi mumoni min me-Isrel keil en hen Mosis navong lah lat keil ran out Isip. ");
INSERT INTO pma_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Sakini Setro mul mai ven keil en out volvol, en out koa amumon votevav one vesesal en Vatihou Senae koa vi out votut onen Ahi. Kei mul mai ka kur ahin onen Mosis ral min natnali keilu. ");
INSERT INTO pma_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Kei san selusien va min Mosis keke telmul telmai. ");
INSERT INTO pma_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Sakini Mosis mea ka va visu mini. Navong lesi, va netan mini en sakien ten houhouen ka mea kav kati. Telvis keitel keke telro mukave. Evus, telva en eim tavolin omon Mosis. ");
INSERT INTO pma_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Navong va neim, Mosis vit vasin tounah keil koa Iahova mumoni min asuv houlu ten out Isip ral min meatin onen keil keke kilea valah lat me-Isrel keil ran hen me-Isip keil. Kei vit usili mun mini mahien keil koa meatin keil akuri en sise ka mukave Iahova rali lat keil rani. ");
INSERT INTO pma_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Navong Setro long tounah keil enek, kei si houlu mok ka vit, ");
INSERT INTO pma_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","“!Nasan masmasien min Iahova koa rali latuk ran hen asuv houlu ten out Isip ka meatin onen keil! !Nasan masmasien min Iahova koa rali lat meatin keil onen koa avi slev onen me-Isip keil ran mahien one! ");
INSERT INTO pma_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Kosa nakur anatin keke Iahova, kei houlu lohlin ahi teisav vasi keil, veni mumon tounah enek vasakin me-Isrel keil avamaluv ran hen me-Isip keil navong amules veah alei heisav en keil.” ");
INSERT INTO pma_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Out mulan eni, Mosis va mumon kot ven titi rea keil onen me-Isrel keil. Ka visokon va varei rokol vongien, mul rondan ka mul sak revi titi rea keil ka me-Isrel keil amulomal rahiti. ");
INSERT INTO pma_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Navong Setro les tounah vasi koa Mosis mumoni, visi vit, “?Komul komumon sa en meatin keil? ?Vensa komul korondan keik sasom enges, ka meatin keil amul umai amulomal avahisuk ven rendemien onom en visokon va rokol vongien?” ");
INSERT INTO pma_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Mosis vit kesi mini vit, “Numon tounah somok keil enek ven meatin keil amul umai venau, e vati availea rendemien onen Ahi en moulien one. ");
INSERT INTO pma_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Navong meatin elu luvae, lumai venau. Ka inau, naviten koa kave mal. Evus, navit kilea selkatien ka mengkatien onen Ahi min keilu.” ");
INSERT INTO pma_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Evus Setro viteni mini vit, “Kormumontei vamal keinek. ");
INSERT INTO pma_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Keik komum vinik ka kosakin meatin keil emun akur mahien navong arosin rendemien onom taveah. Umen enek meas ramat keke keik sasom kovakuri. ");
INSERT INTO pma_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Kosak, masan more selkatien tai minuk vasakin Ahi heto hetal minuk. Mal enges keke keik kilong usil titi rea keil onen meatin keil ka kihatuk en meten Ahi en usite one. ");
INSERT INTO pma_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Mal keke kihisein keil en selkatien keil ka en mengkatien keil onen Ahi ka kihit kilea min keil sakien keil tetahos ka asa koa keil umoni. ");
INSERT INTO pma_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Ka hetahos imok keke kitie lati mun tei meatin keil koa kolesi avinvin avakataunuk, ka kiling keil ihi metai avalosil kat vangi meatin keil: vangi meatin koa halualim (10) amul ien; vangi meatin koa hanumau elu ka halualim mun (50) amul ien; vangi meatin koa handred tai (100) amul ien; ka vangi meatin koa taosen tai (1000) amul ien. Koakeil enek ihi vati meatin koa avouhou min Ahi, desien onen meatin sav keil amul en keil, ka asakras avakur mani en sise ten luvosien. ");
INSERT INTO pma_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Kiling koakeil enek ilei revi usite onen meatin keil. Lises keil akilea avasak revi titi rea koa maes. Ka tounah koa keih ramat, ikuri hemai venuk. Hemukonek, keil ikulat umen koa meas ranuk, ka hesakini hemaes minuk. ");
INSERT INTO pma_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Munak kumon sakien koanek, suval koa Ahi mul meng kati minuk, kirmum viniktei. Ka hesakin meatin keil vasi enek ilonge hetahos, ka iha ris teim en tomat.” ");
INSERT INTO pma_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Mosis long kat selkatien onen Setro. ");
INSERT INTO pma_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Sakini rie lat meatin keil koa avinvin ven umen koanek ka ling keil avi metai alosil kat vangi meatin keil: vangi meatin koa halualim (10) amul ien; vangi meatin koa hanumau elu ka halualim mun (50) amul ien; vangi meatin koa handred tai (100) amul ien; ka vangi meatin koa taosen tai (1000) amul ien. ");
INSERT INTO pma_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Keil alei revi usite onen meatin keil. Lises keil asak revi titi rea koa maes. Ka tounah koa keih ramat enges, akuri mai ven Mosis. ");
INSERT INTO pma_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Evus, Setro vit vaha ris teim sen. Sakini Mosis viten ‘more’ mini, ka Setro va ris en out kati onen. ");
INSERT INTO pma_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Me-Isrel keil amemea ran out Revidim ka amual taveah neli. Ka en avati etel kati katau en avong koa amemea ran out Isip, me-Isrel keil umai en out volvol vesesal en tavoite ten Vatihou Senae. Ka amumon votevav keil one en out enek. ");
INSERT INTO pma_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Ka Mosis vina en vatihou vaselus min Ahi. Iahova mul en hou ka vise vit, “Mosis, kihita kihiteni hemukok min me-Isrel keil kihit: ");
INSERT INTO pma_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Kami miles asa keke inau, Iahova, namumoni min me-Isip keil. Ka milesi mukave nakur kami mimai mirokol inau ekok en keihoen ka envatien suval veivakum kur titan en apouen. ");
INSERT INTO pma_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Sakini kosa, munak mihelong kat rek ka mihousil kat mengkatien keil onak, mihehi meatin keil kati onak. Anatin keke tounah vasi en out netan vi onak, ka kami suk, envatien onak hel en kami helohlin meatin sav keil ten out netan. ");
INSERT INTO pma_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Kami mihehi vangi meatin kati onak koa hehi votut ka miheha netan minau suval vangi pris keil koa hiasuvien onak hel en moulien onami.’” ");
INSERT INTO pma_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Navong Iahova selus mini evus, Mosis mita ris netan ka vise ruain meatin keil. Tounah vasi koa Iahova viteni mini, kei vit meseini min keil. ");
INSERT INTO pma_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Navong meatin keil alonge, avit, “Tahos, mehoumon tounah vasi keil koa Iahova viteni.” Evus, Mosis vina ris, vit mesein selusien one min Ahi. ");
INSERT INTO pma_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Evus, en avong etel, en visokon teni, voulul muroh ka ahil vil. Mari mahmah tai kistal ka mutaluh koe vatihou nesa. Evus, mari amaru tai musel keih. Tounah keil ekek sakin meatin vasi keil amaleilei ka ametau houlu en out koa amumon tavolin keil ome eni. ");
INSERT INTO pma_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Mosis mulamun keil amea ran out amumon votevav ome ien, ka uva avahisu min Ahi. Keil vasi uva ka avati keil en tave hou. ");
INSERT INTO pma_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Alesi keke Iahova mita en Vatihou Senae suval ahang ka mul rupas mutaluh koe usite vasi keil teni. Out kulul keih ka rupas vina nesa suval vane. ");
INSERT INTO pma_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Verien ten amaru mul musel keih vis keih imok, mul mita vesesal ven keil. Mosis selus min Ahi, ka Ahi vit kesi en voulul. ");
INSERT INTO pma_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Iahova mita en hoite ten Vatihou Senae, ka vise Mosis vahina vahisu mini en out enek. Sakini, Mosis veou vina. ");
INSERT INTO pma_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Evus, Ahi selus min meatin vasi keil en selusien keil ekek: ");
INSERT INTO pma_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Inau navi Iahova, Ahi onami, koa nalah lat kami ran out Isip, out koa kami mivi slev keil enges ien. ");
INSERT INTO pma_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Minahatei netan min ahi sav keil, miheha netan min inau nges. ");
INSERT INTO pma_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Minoumontei nana koa nakur niniven tounah keil amul nesa en teilang, vuo amul netan en atan, vuo en huinev ten atas. ");
INSERT INTO pma_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Minamalinglingtei ka minahatei netan min etai nana, veni inau navi Iahova, Ahi onami, ka ek rovattei kami mivousil ahi savsav keil. Koakeil aseseinau, nisan mahien heat keil, titae keil, havine keil ka hehita hetokol titae keil one mun. ");
INSERT INTO pma_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Ka koakeil e vat nau ka amusil kat mengkatien keil onak, nitie more envatien onak min keil ka min vatiamal one lises ka lisenges. ");
INSERT INTO pma_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Minaselus entei en isok natal rendemien tisa vuo heisav enges veni inau navi Iahova, Ahi onami, ka nisan mahien min meatin koa kur heisav en isok. ");
INSERT INTO pma_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Mihehuli kat avong ten Sabat ka mihehouhou eni veni kei vi votut. ");
INSERT INTO pma_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Avong onami heite ahetai (6) keke mihoumon umen onami keil eni. ");
INSERT INTO pma_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Ka avong koa oulu (7) vi Sabat, avong koa miheling lati hehi onak, Iahova, Ahi onami. En avong enek, kami, titami, slev onami, buluk ka sipsip esomi, ka meatin keil ten out sav emun koa umai aro ral min kami, kami vasi mihermumtei. ");
INSERT INTO pma_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","En avong ahetai (6), inau Iahova namumon teilang, out netan ka atas, ka namumon tounah vasi keil koa amul en keitel. Ka en avong koa oulu (7), namuseh. Ven tounah enek, inau Iahova narokol kat avong ten Sabat ka naling lati vi votut. ");
INSERT INTO pma_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Mihehouhou min tata ka mama onami keil, hesakini moulien onami hetaveah en atan koa nisani min kami. ");
INSERT INTO pma_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Minouastei meatin namat. ");
INSERT INTO pma_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Minakurtei ahin vuo meatin onen hanu sav. ");
INSERT INTO pma_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Minahenantei tounah onen meatin sav. ");
INSERT INTO pma_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Minoumontei luvosien naha kat isen meatin sav. ");
INSERT INTO pma_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Envatien onami nalentei eim mon hanu sav, vuo ahin onen, vuo slev onen, vuo buluk ka sipsip esen, vuo dongki esen, vuo tounah sav keil onen.” ");
INSERT INTO pma_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Navong meatin keil araengon voulul ka amaru koa musel keih, ka ales ahil vil ka rupas mul en vatihou, keil amaleilei en metauen ka amulomales soutin. ");
INSERT INTO pma_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Keil aviteni min Mosis avit, “Munak keik kos kiselus min komai, mihetaengonuk. Ka munak Ahi heselus eris min komai, mihematmat varei.” ");
INSERT INTO pma_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Mosis vit risi min keil vit, “!Minametautei! Ahi mita netan enges keke voumon kami mivailea keihoen onen, hesakini, mihelong kati lises, ka mihermumontei mun tisaen keil.” ");
INSERT INTO pma_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Ka meatin keil amulomales soutin, ka Mosis enges mual va vesesal en out koa Ahi mul ien, en mari mahmah koa malikelik. ");
INSERT INTO pma_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Iahova viteni min Mosis vit, “Meatin koa houas hanu sav hemat, kei mun uasi hemat. ");
INSERT INTO pma_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Ka munak kei romundemtei voumoni ka inau namaen tounah enek kur out esuk, kei kilea valohosai vaha en out tai koa inau nitie min kami. Ka en out enek, kei kilea heto hetahosis. ");
INSERT INTO pma_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Ka munak meatin tai tin tisa kat meatin sav tai ka mumon rendemien suai tai onen vit vouasi vamat, ka muasi mat; meatin koa vuhu enek, kei mun uasi hemat. Avaseini meatin enek helohosai heha heto kus en ahor ten sanien onak. ");
INSERT INTO pma_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Meatin koa houas tata onen vuo mama onen, kei mun uasi hemat. ");
INSERT INTO pma_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Meatin koa hehenan meatin sav keke hemai hehi slev onen vuo keke hanu sav tai hehul lati rani, meatin enek uasi hemat. ");
INSERT INTO pma_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Meatin koa hesili tata vuo mama onen, kei uasi hemat. ");
INSERT INTO pma_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Munak atouli tai mul koa reingeingen meatin veah ka meatin tovuol vating koe vahi onen, ka munak meatin tai run luvosi ka matil ral mini, kei hehul tata onen veni ka hekuri hehi onen ka hetetalihe suk hetali. ");
INSERT INTO pma_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Ka munak tata onen heseseini keke meatin enek vakuri, meatin enek hehul tata enek en mani koa hevinvin en mani koa avahul atouli koa reingeingen meatin veah eni. ");
INSERT INTO pma_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Isan matien min ahin koa hel houmon eimas. ");
INSERT INTO pma_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Isan matien min meatin koa hesak tisa en buluk ka sipsip hesuval meatin koa sak tisa en ahin. ");
INSERT INTO pma_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Isan matien min meatin koa hesan sanien votut heha min ahi sav tai. Keil isan sanien votut minau nges, Iahova. ");
INSERT INTO pma_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Minapuruntei vuo minakarentei meatin koa rovitei horetan. Mihendem kati keke mulamu, kami mun mirvitei horetan en out Isip. ");
INSERT INTO pma_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Minapuruntei vatina vuo timaru keil. ");
INSERT INTO pma_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Ka munak misak purun keil, inau, Iahova, nilong tangien keil one ka nimai nikataun keil. ");
INSERT INTO pma_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Nivuroh kat kami ka nuas kami mihematmat en rea keil. Nisakin ahin onami keil ihi vatina ka titiali onami keil ihi timaru. ");
INSERT INTO pma_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Munak mimaen livere tai hekur hati mani ranuk, minoumontei nasuval meatin keil ten bangk, minahistei nasa kesi min kami natal titan. ");
INSERT INTO pma_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Munak meatin kur tounah tai ran kami ka mihuli kat eisin omon hetokol avong koa hemai ris hehul lati; minahuli kattei eisin omon natokol meteiai nanu. ");
INSERT INTO pma_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Mihesa kekerati mini veni mireingeingeni keke eisin koa netinek keke kei kav koe aven eni valikat anni. ?Asa suk keke kei hematil eni? Ka navong tangien onen hemai hetokol inau, nilonge ka nikatauni veni inau, nakur enmahisien en vati meatin keil koa mukonek. ");
INSERT INTO pma_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Minoumontei selusien taluvosien naka vasi out. Ka minakatauntei meatin koa vit vasan selusien taluvosien vakat meatin sav. ");
INSERT INTO pma_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Minousiltei sakien onen meatin sav keil navong asak kalkali vuo navong aviles anatinien mai vi luvosien en avong ten kot.” ");
INSERT INTO pma_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Navong Iahova selus mini evus, Mosis mita ris ven meatin keil ka vit meseini min keil mengkatien ka selkatien vasi keil enek. Ka navong alonge, keil vasi aviteni avit, “Mehoumon tounah vasi keil Iahova viteni.” ");
INSERT INTO pma_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Mosis mutis kat mengkatien vasi keil onen Ahi va en Tus ten Hatkatien Takeih onen Ahi. Out mulan, en visokon semau, kei kur ahat keil ka mumon avet tai ten sanien en tave Vatihou Senae. Evus, kei vati lat mari ahat teindan elu (12) amulomal keke ihi metai keil ten hatkatien takeih koa mari vatiamal teindan elu (12) onen me-Isrel keil amumoni ral min Iahova. ");
INSERT INTO pma_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Evus, sila meatin hau keil koa uva amuas buluk ka sipsip koa, ka amunit lin keil en ahor ten sanien vaha min Iahova. Evus, akur buluk ka sipsip koa mun, ka amumon sanien keil ten lahruaien eni. ");
INSERT INTO pma_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Mosis sien lelat ran buluk ka sipsip keil enek, ka hatte tai va en pesin keil, ka hatte tamun, kukuvin eni va kat vali ahor ten sanien. ");
INSERT INTO pma_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Evus, kur ‘Tus ten Hatkatien Takeih’ koa mengkatien keil onen Ahi amul ien, ka mul vuli en meten meatin keil avalonge. Vuli vus, keil avit, “Mengkatien keil vasi onen Iahova, mihelong kati, ka mihousil kat selusien vasi keil onen.” ");
INSERT INTO pma_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Navong aviteni mukok, Mosis kur ara koa mul en pesin keil ka kukuvin eni va en meatin keil vit, “Koanik vi ara koa san keihoen min hatkatien takeih koa Ahi mumoni ral min kami en avong koa miviten selusien keil ekek.” ");
INSERT INTO pma_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Evus, Ahi viteni min Mosis vit, “Ama nesa minau en vatihou enek. Ka navong kito keie, nisan ahat elu minuk koa namutis mengkatien keil eni koa vahi selkatien onen meatin keil.” ");
INSERT INTO pma_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Sakini Mosis kur meatin tai takataunien onen, isen Sosua, lusak mesein keilu keke luvahina en vatihou onen Ahi. ");
INSERT INTO pma_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Mosis viteni min metai keil vit, “Kami miheto ekok hetokol avong melhemai ris. Eron keilu Hur luheles hetal kami, ka meatin etai koa en vati vamal en selkututien onen en kot kilea vaha ven keilu.” ");
INSERT INTO pma_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Evus, Mosis vina en Vatihou Senae ka mahmah mutaluh koe. ");
INSERT INTO pma_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","17","Muohien onen Iahova mita netan en hoi hou nesa. Kei vilahil houlu ka me-Isrel keil amul netan alesi suval ahang rekau en vatihou nesa. Mahmah mutaluh koe vatihou enek avong ahetai (6). Ka en avong koa oulu (7), ren Ahi kistal en mahmah vise Mosis vahina veni. ");
INSERT INTO pma_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Sakini Mosis vina nesa en vatihou, va neim en mahmah enek. Mules en out enek avong hanumau elu (40). ");
INSERT INTO pma_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Iahova viteni min Mosis vit, ");
INSERT INTO pma_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Kihiteni min me-Isrel keil avoumon etai sanien vamai venau hekataun umen ten Eim Tavolin onak. Kimaen tounah vasis koa meatin keil e vati avasani minau. ");
INSERT INTO pma_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“Meatin keil umon etai mok eim tavolin koa hehi out koa inau nakilea nihita nito hetal min keil eni. ");
INSERT INTO pma_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Umon eim tavolin enek ka tounah vasi keil koa hel neim housil asa koa nitie lati minuk. ");
INSERT INTO pma_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Umon etai bokis en vati akasia hemarite hemukok: eitu koa taveah teni sentamita hehi handred tai ka halualim (110 cm), eitu koa tamurei teni sentamita hehi hanumau elu ka ehat mun (44 cm), ka usite keil koa hehina nesa sentamita hehi hanumau elu ka ehat mun (44 cm). ");
INSERT INTO pma_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Itemal kati neim ka hae en gol, ka imosan eni en rel koa vi gol hekarahiti. ");
INSERT INTO pma_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Umon out tatetalien hehat en gol ka isar kati en alen ehat teni: out tatetalien elu hel en usite tai, ka elu hel en usite sav. ");
INSERT INTO pma_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Umon ai elu en vati akasia koa avahousi eni, itemal kat keilu en gol, ");
INSERT INTO pma_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","ka ilingi luhekirisil en out tatetalien keil en usite keilu ten bokis koanik. ");
INSERT INTO pma_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Ai tahohoien enek heles en out tatetalien ka irkulattei mun. ");
INSERT INTO pma_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Hevus, ahat keilu koa namutis mengkatien keil mul ien koa nisani minuk, kiling keilu heha en bokis enek. ");
INSERT INTO pma_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Umon hoite en gol, ka taveah teni sentamita hehi handred tai ka halualim mun (110 cm) ka tamurei teni sentamita hehi hanumau elu ka ehat emun (44 cm). ");
INSERT INTO pma_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Umon angelo helu koa apouealu houlu koa avise en ‘sereb’ ka itemal kat keilu en gol koa amuti mai mahinhin enges. ");
INSERT INTO pma_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Umon keilu leheapil hetal min hoi bokis, tai hetondan en usite tai teni ka tamun en usite sav. ");
INSERT INTO pma_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Sereb keilu enek luheleles keilu en usite keilu ten hoi bokis ka lehetelan apouealu heav koe hoi bokis enek. ");
INSERT INTO pma_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Ahat keilu koa namutis ien, iling keilu luheha ien ka kipoh koe revi. ");
INSERT INTO pma_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","En out enek, luhu en sereb keilu koa luhetondan en hoi bokis koanik, inau nitondan ka nihisu minuk ka nisan mengkatien vasi keil onak minuk koa keik kihitehiteni min me-Isrel keil.” Ahi viteni min Mosis keke houmon avet tai taling tounah ien, out ten amunit senta ien, ka out koa avaling kandel vahi oulu (7) val ien. Ka viteni mun min Mosis keke houmon eim tavolin koa vi votut, rum elu hel neim, ileh kotehei en kaliko, ka vieh tai hekarahit eim tavolin enek. Evus, viteni mun mini vit umon avet en brons koa akilea avanit buluk ka sipsip ten sanien votut vaha min Ahi hetal min mari pesin tai takas ahe ien. ");
INSERT INTO pma_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Iahova viteni mun min Mosis vit, “Kihise tumali Eron ka natnali keil telhemai: Natab, Apihu, Eliesar, ka Itamar. Kilei kan keil ran me-Isrel sav keil keke keil umon umen onak isuval pris keil. ");
INSERT INTO pma_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Kumon eisin omon Eron koa tahos imok, hevinvin ven umen onen pris tai koa hesakin meatin keil ihouhou mini. ");
INSERT INTO pma_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Ka kihise ruain koakeil koa nasan meteisau ten tatitilien min keil, imai itili eisin omon. Hevus, kiling hem en Eron hetie lati keke hekur umen onak hesuval pris tai onak.” ");
INSERT INTO pma_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Navong meatin keil amumoni mukonek, Iahova viteni min Mosis vit, “Kikalah kihita netan veni meatin onom keil koa kolah lat keil ran out Isip asak kalkali ka umai atisaso. ");
INSERT INTO pma_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Keil akalah amemea tuai ran sise koa navit kati keke avousili. Amumon buluk tai en gol ka amul uva netan mini ka amul amuas buluk ka sipsip keil ka amuniti vi sanien va mini. Keil amul aviteni keke nana enek vi ahi one koa mulamun keil amea ran out Isip. ");
INSERT INTO pma_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Nakilea keke keil avi vatkeih. ");
INSERT INTO pma_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Navuroh kat keil ka, kosa, nu rasilin keil varei. Konoumontei konahit kovahiles rendemien onak, numon asa koa ek vati. Hevus, numon keik ka vatiamal onom imai ihi mari vangi meatin tai.” ");
INSERT INTO pma_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Ka Mosis peah Iahova, Ahi onen, keih imok vit, “Iahova, komulamun keil en tounah houlu tuai. ?Vensa kovuroh kat meatin onom keil koa kolah lat keil ran out Isip en mari keihoen onom? ");
INSERT INTO pma_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","?Vensa me-Isip keil ihiteni ihit keik kolah lat meatin onom keil ran out Isip keke kokilea kovalamun keil avahina en vatihou keil ka kovou lin keil? Konavuroh kattei li keil, kihiles rendemien onom eli. Iahova, konasantei li mahien koanek min meatin onom keil. ");
INSERT INTO pma_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Kindem kat meatin toumien onom keil: Ebraham, Aesak ka Siekob. Kindem kat hatkatien takeih koa komumoni ral min keitel. Kovit titaeatel hehi houlu vis hehi houlu mok hesuval hitu keil ten teilang. Kovat kati min keitel keke kisan atan hehi onen koakeil ikistal en vatiamal oneatel lises ka lisenges.” ");
INSERT INTO pma_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Sakini, Iahova viles ris rendemien onen, ka rosantei mahien vaha min meatin keil onen suval koa kei viteni. ");
INSERT INTO pma_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","16","Evus, Mosis suvul eris vita netan en vatihou. Mul vous ahat elu koa Ahi keinges ra lati ran mari ahat tai ka mahinhin. En ahat elu enek, Ahi mutis mengkatien onen mul vasi usite keilu. ");
INSERT INTO pma_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Navong Mosis mul mai vesesal ven keil, les buluk keke keil amul uvol rahiti. Navong lesi, tin katiat vis katiat. Ka en out enek, en tave vatihou, kei kopahas ahat keilu koa vousi mita. ");
INSERT INTO pma_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Kei mita kulat buluk koa keil amumoni ka soni va en ahang mukurle. Evus, muti lini mai vi vulimeas, ka so rasilini va en oai. Mumoni evus, sakin me-Isrel keil vasi umai amuni. ");
INSERT INTO pma_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Kei viles, les Eron ka viteni mini vit, “?Meatin keilek amumon sa enuk keke sakin keik komumon keil umot en mari tisaen ekek?” ");
INSERT INTO pma_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Eron vit risi mini vit, “Mosis eli, konavuroh kattei nau li. Keik kokilea keke meatin keil ekek, lises envatien one mul en sakien tisa keil. ");
INSERT INTO pma_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Keil aviteni minau avit, ‘Komai mereingeingen asa koa kula Mosis koa lah lat komai ran out Isip. Sakini, kumon ahi tai koa kilea valamun komai.’” ");
INSERT INTO pma_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Out mulan, Mosis mulomal en meten meatin keil ka viteni min keil vit, “!Kami mimumon mari tisaen tai! Ka kosa, mahina ris en vatihou nesa mahisu min Iahova. Vahera nakilea mapeah enmahisien onen keke naleletei natisa en kami ven tisaen onami.” ");
INSERT INTO pma_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Sakini, Mosis vina ris ven Iahova ka viteni mini vit, “!Aue li! Meatin keil ekek amumon mari tisaen tai li. Amumon ahi tai en gol ka uva netan mini. ");
INSERT INTO pma_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Napeahik, kumon methos onom eli min keil. Ka munak em rovattei, kisulin varei isok emun ran Tus ten Moulien onom koa komutis kat isen meatin onom keil amul ien.” ");
INSERT INTO pma_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Iahova vit risi mini vit, “Koakeil koa amumon tisaen va kat inau, keil enges nisulin ise ran Tus ten Moulien onak. ");
INSERT INTO pma_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Kiha kilamun meatin keil miheha en out koa naviteni tuai minuk. Kindem kati keke angelo onak helamun kami miheha. Ka kilea emun keke avong mul mai keke nisan mahien min meatin keil ekek ven tisaen one.” ");
INSERT INTO pma_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Sakini Iahova san mari mesaien tai va kat meatin keil ven buluk koa asakin Eron mumoni. ");
INSERT INTO pma_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Iahova viteni min Mosis vit, “Kumon ahat elu hesuval koa namumoni mulamu, ka inau nitis ris selusien keil koa namutisi mul en ahat keilu mulamu, koa keik kokopahas keilu. ");
INSERT INTO pma_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Kisak mesein tounah keil, ka visuvong, en visokon, kima nesa en Vatihou Senae. En out enek, kilomal en metok.” ");
INSERT INTO pma_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Sakini, Mosis ra lat ris ahat elu mun koa mahinhin tatisien. Out mulan, vus keilu vina nesa en Vatihou Senae, suval koa Ahi meng kati. ");
INSERT INTO pma_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Evus, Iahova mita netan en mahmah tai ka mulomal vesesal ven Mosis ka vothot en isen votut vit, “Inau Iahova.” ");
INSERT INTO pma_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Evus, Iahova ka pas Mosis ka vitehiteni vit, “Inau navi Iahova, kei koa NAVI. Ahi tai koa enmahisien ka more envatien mul ien. Ahi tai koa tin taveah ka tinahos mul ien. Ahi tai koa mum vasin hatkatien keil onen. ");
INSERT INTO pma_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Anatin, nihuli kat hatkatien onak hetal min meatin keil ka titae keil heha vio … keite teni hetovuol. Koakeil asak kalkali, arali koteh mengkatien keil onak, ka amumon tisaen keil, inau nakilea nitie envatien onak min keil ka numon methos en keil. Ka mukos, nisan mahien min keil enek ven tisaen keil amumoni, ka mahien teni heat keil eris, hetal min titae keil one emun hetokol havine keil.” ");
INSERT INTO pma_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Hatte tas, Mosis vita netan mini ka malingling, nan rokol atan ");
INSERT INTO pma_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","ka viteni mini vit, “Iahova, munak kolele tahos enau, napeahik kusil komai. Anatin keke meatin keil ekek, vate keih ramat, ka kisan methos onom eli min komai ka konaleletei natisa mun ven sakkalkalien keil onomai. Kikur vilei komai li mehemai mehehi meatin keil onom.” ");
INSERT INTO pma_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Iahova vit risi min Mosis vit, “Kosa, numon hatkatien takeih tai hetal min me-Isrel keil. En mete, numon marmari tounah keil heteisav en asa koa mul kistal en kantri sav keil. Meatin vasi keil en out netan iles marmari tounah keil koa inau, Iahova, nakilea moumoni. Keil itimanin ven numon sakien keil ikistal en kami koa hemarite vis hemarite mok.” ");
INSERT INTO pma_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Mosis ro en out enek ral min Iahova avong hanumau elu (40). Ka meneai ka vongien, rokaniantei ka romun etai tounah. Mul rei selusien ten hatkatien onen Ahi en ahat elu, koanek Mengkatien Halualim. ");
INSERT INTO pma_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Navong Mosis muris mita netan en Vatihou Senae, vus Mengkatien Halualim ral mini. Navong mita ven meatin keil, kei reingeingeni keke nan vihil veni kei selus ral min Iahova. ");
INSERT INTO pma_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Ka navong Eron ka meatin sav keil alesi mukok, ametau ka arvatei vesesal veni. ");
INSERT INTO pma_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Ka navong Mosis vise ruain meatin keil, Eron ral min metai keil ten vatiamal keil umai veni, ka Mosis selus min keil. ");
INSERT INTO pma_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Navong selus min keil evus, me-Isrel vasi keil emun umai vesesal veni, ka Mosis sani min keil mengkatien keil koa Ahi sani mini en Vatihou Senae. ");
INSERT INTO pma_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Navong Mosis selus evus, kav koe veinan en kaliko koa kei kilea valei retal eni. ");
INSERT INTO pma_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Ka en avong vasi koa Mosis vaha en Eim Tahisuen keke vaselus vatal min Iahova, kei kulat kaliko enek. Ka navong kistal eris, mai vitehiten tounah keil koa Ahi meng kati mini vahiteni min meatin keil. ");
INSERT INTO pma_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Navong meatin keil umai alesi, alesi keke veinan vihil. Selus evus, ling ris kaliko kav koe veinan rokol avong sav koa heha ris heselus hetal min Iahova. ");
INSERT INTO pma_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Sakini, en avong mulamu en avati koa mulamu en sua hau, sua kati katau en avong amemea ran out Isip, keil avat lat Mari Eim Tavolin onen Iahova. ");
INSERT INTO pma_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Mosis sakin meatin keil avous ai keil teni ka aling kati en vulie ral min eitu keil teni. Evus, hatur ka vatiseng teni, aleh mal eni mulomal. ");
INSERT INTO pma_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Navong alehei evus, keil aleh tavolin kav koe ai keil teni. Ka tavolin tamun, alehei mul kati, musil asa koa Ahi meng kati min Mosis. ");
INSERT INTO pma_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Evus, vus ahat elu koa Mengkatien Halualim mul ien ka ling keilu en Bokis ten Hatkatien onen Ahi. Keil aling ai tahohoien elu lukirisil en out tatetalien ten Bokis. Ka apoh kat bokis en hoite teni. ");
INSERT INTO pma_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Evus, alah Bokis ten Hatkatien va alingi neim en Eim Tavolin, ka rekein kaliko mul koe out koa mul ien. En sakien enek, Mosis musil asa koa Iahova meng kati mini. ");
INSERT INTO pma_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Mosis viteni min keil avus avet taling tounah keil ien va neim en Eim Tavolin, hae en kaliko, en usite matu. ");
INSERT INTO pma_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Ka ling veret ten sanien onen Iahova en hoite suval koa Iahova meng kati mini. ");
INSERT INTO pma_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Ka en usite meil, aling laet koa mulomal eni. ");
INSERT INTO pma_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Ka en out enek, en meten Ahi, kei munit laet musil asa koa Iahova meng kati mini. ");
INSERT INTO pma_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Ka luhu en keilu, vesesal ven kaliko, kei ling titi out ten sanien koa amumoni en gol. ");
INSERT INTO pma_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Ling tounah koa vite tahos mul ien ka muniti musil asa koa Iahova meng kati mini. ");
INSERT INTO pma_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Amumoni evus, Mosis vis keil arekein kaliko en voiteh ten Eim Tavolin. ");
INSERT INTO pma_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Ka en out enek, hae en voiteh teni, vis keil aling mari ahor keke avanit sanien votut keil ien eni. Alingi evus, Mosis muas sipsip tai ka muniti eni ral min sanien votut ten uti uit keil musil asa koa Iahova meng kati mini. ");
INSERT INTO pma_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Vis keil aling pesin takas ahe ien mul vas Eim Tavolin ka mari ahor ten sanien. Evus, amutah oai va ien. ");
INSERT INTO pma_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","32","Alingi mukok keke avong vasis koa Mosis, Eron ka natnali keil avit avaha en Eim Tavolin vuo avanit sanien en avet teni, akilea avakas motein he vuo ale tanetan en out enek musil asa koa Iahova meng kati min Mosis. ");
INSERT INTO pma_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Katau en tounah keil enek, Mosis sakin meatin keil amumon vieh en kaliko karahit Eim Tavolin ka ahor ten sanien. Ka en meteau teni, aleh koe en kaliko tamun. Mukonek, umen ten Eim Tavolin enek, Mosis mum vasi. ");
INSERT INTO pma_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Evus, mahmah mita mutaluh koe Out Tahisuen karahit Eim Tavolin, ka muohien onen Iahova mita va sien Eim Tavolin enek. ");
INSERT INTO pma_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Ven tounah enek, Mosis sakras vaha neim en Eim Tahisuen vuo en Eim Tavolin. ");
INSERT INTO pma_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Me-Isrel keil amul ales mahmah koa mul nesa en Eim Tavolin. Navong mahmah mea, keil emun amemea, alah lat votevav keil one ka amusili. ");
INSERT INTO pma_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Ka navong mahmah mules en out enek, keil emun amules. ");
INSERT INTO pma_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","En avong vasis koa keil amul amual, akilea ales mahmah onen Ahi mul nesa en Eim Tavolin, ka en vongien keil alesi viles mai vi ahang koa vilhili. ");
INSERT INTO pma_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Navong Iahova mul en Eim Tavolin, vise Mosis va vesesal veni ka selus mini vit, ");
INSERT INTO pma_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Kiselus min me-Isrel keil ka kisan mengkatien keil usil sakien ten sanien min keil kihit, ‘Navong meatin etai hesan buluk vuo sipsip vahi sanien onen, hekur buluk, sipsip, vuo nani tai esen. ");
INSERT INTO pma_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Munak tai, sanien onen vi buluk, hekur buluk koa meahos koa aven heto, tounah tovuol hekula. Kei helamuni heha en metareh ten Eim Tavolin onak. Hesakini, inau, Iahova, nikur buluk koanek en usite koa vi onen keke hemal en metok. ");
INSERT INTO pma_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Meatin enek heling hen en vatin buluk vatie lati keke ling tisaen keil onen mul ien. Hesakini navong buluk mat, inau nilesi keke meatin enek mal en metok ka methos onak hel ien. ");
INSERT INTO pma_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Kei hou vini buluk onen en out enek ka natnali keil onen Eron koa avi pris keil itie ran minau, Iahova. Evus, hekukuvin eni heha en vali ahor ten sanien koa mul vesesal en metareh ten Eim Tavolin. ");
INSERT INTO pma_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Hevus, meatin enek houul lat hiliven buluk ka heteh lin vuseri teni. ");
INSERT INTO pma_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Pris keil isak mesein av en ahor ten sanien ka initi. ");
INSERT INTO pma_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Navong ahang mukan, pris keil iling revi vatin buluk, amur teni, ka vuseri sav keil teni. ");
INSERT INTO pma_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Meatin enek hekas motein alen ka tina keil teni, ka pris koa mul mumon sanien enek henit lin vasi sanien keil onen en ahor ten sanien. Ka vite ten sanien enek hetahos imok minau, Iahova.’” Ahi vit kilea min Mosis sakien koa meatin keil akilea avasan sanien sav keil one mini: suval sipsip, nani vuo ame. Ahi viteni keke meatin keil isani min pris keil avou vini ka initi en ahor ten sanien. Sanien votut keil enek hesakin methos onen Iahova hel en keil, ka ito en tomat hetal mini. ");
INSERT INTO pma_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Iahova viten selusien tai min Mosis ");
INSERT INTO pma_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","vahit meseini min me-Isrel keil vahit, “!Kami mihehi votut, veni inau, Iahova, Ahi onami, navi votut! ");
INSERT INTO pma_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“Konakurtei rendemien tatisa naha kat meatin sav keil koa aro vesesal venuk. Ka munak tounah tai sakin kamil millele tisa en kamil, mihetali mal eni keke hesakinuk kirmumontei tisaen. ");
INSERT INTO pma_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Konasa kestei sakien tisa mini ka rendemien onom natisa kattei. !Vuo! Envatien onom hel en meatin sav keil hesuval koa keik em vat keik eris. Inau navi Iahova. ");
INSERT INTO pma_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“Munak meatin tai en vati vahiles eisilin ranau keke vakur rendemien etai en koakeil akilea avaselus min ninin tisa keil; inau mun, nihiles eisiluk rani ka nirkur revitei kei hesuval meatin onak tai. ");
INSERT INTO pma_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Mihesan kami minau ka miheles mihousil sakien keil koa vi votut, veni inau, navi Iahova, Ahi onami. ");
INSERT INTO pma_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Mihelong kat revi mengkatien keil onak, veni inau, navi Iahova koa nasakin kami mivi votut.” ");
INSERT INTO pma_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Iahova viteni min Mosis vit, ");
INSERT INTO pma_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Navong Eron ka natnali keitel telhesan tokolkatien min me-Isrel keil, keitel telhehiteni hemukok telhehit, ");
INSERT INTO pma_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‘Iahova hetokol kat kami ka helei kat kami. ");
INSERT INTO pma_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Iahova hetahos min kami ka more envatien onen hel ven kami. ");
INSERT INTO pma_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Iahova helele hetahos en kami ka hesan tomat onen hel ven kami.’ ");
INSERT INTO pma_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“Ka munak keitel telhesan tokolkatien min me-Isrel keil en isok, anatin eli, inau nitokol kat keil.” Me-Isrel keil vasi umai ka metai keil one asan sanien votut keil min Iahova. Evus, Ahi vis Mosis helei kan koakeil amul en vatiamal onen Livae keke imai ikataun pris keil. Navong kei mumoni evus, amumon Anien ten Mul Laui. Koanek vi sua tai kati koa amemea ran out Isip. Evus, mahmah onen Ahi mea ka mulamun keil uva en out tai vesesal en out Kenan. ");
INSERT INTO pma_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Iahova viteni min Mosis vit, ");
INSERT INTO pma_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“En mari vatiamal teindan elu (12), kitie lat metai keil ikeka ran hetetamen sav keil keke kisila keil iha ilei suai en out Kenan, out koa namul nasani min me-Isrel keil.” ");
INSERT INTO pma_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Sakini, en out volvol en out Paran, Mosis long kat ren Iahova ka sila metai teindan elu (12) koa amul alei kat vangi me-Isrel keil. ");
INSERT INTO pma_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Navong Mosis sila lat keil, viteni min keil vit, “Miheha miheka koteh out Kenan, evus, mihelei rahit hou keil en usite. ");
INSERT INTO pma_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Mihelei vis out. ?Atan enek mukave? ?Meatin keil avi houlu vuo arvitei houlu, keil ave keih vuo ave memerau? ");
INSERT INTO pma_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Miheha mihelei visi. ?Out enek tahos vuo tisa? ?Meatin keil aro en taon keil koa vieh takeih karahiti vuo vieh tovuol ien? ");
INSERT INTO pma_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Mihelei vis atan. ?Kei tahos vuo tisa? ?Ka vatiai keil avi houlu vuo atovuol? Miheha en rendemien koa hetahos ka mihendem kati navong mihemai ris, mihekur kat tei heiai koa amoul en out enek.” (Koanek vi avong koa hei grep keil mul men.) ");
INSERT INTO pma_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Sakini, meatin keil uva ka alei suain out vasi: out volvol en out Saen koa mul en usite saot, uva arokol out Rehob, vesesal en out Hamat, en usite not. ");
INSERT INTO pma_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Meatin keil taleisuaien out amual alei vasin out Kenan avong hanumau elu (40). Evus, umai ris ");
INSERT INTO pma_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","ven Mosis, Eron ka me-Isrel vasi keil koa arosin keil en out volvol ten out Paran. Navong umai ris, aviten tounah koa alesi ka arie heiai keil koa akuri. ");
INSERT INTO pma_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Keil aviteni min Mosis avit, “Komai meles out enek, ka atan teni tahos imok ka amas mul ien. Koanik vi heiai teni. ");
INSERT INTO pma_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Ka meatin keil koa amul en out enek avi avkeih keil. Taon keil one emun amariso, ka vieh keil koa karahiti keih vis keih. Ka tisa mok, meles marmari meatin keil en out enek koa atetaveah koa aka en vatiamal onen Anak. ");
INSERT INTO pma_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Me-Amelek keil aro en usite saot, ka me-Hit, me-Sebus, ka me-Amor aro en hou keil. Ka me-Kenan keil aro vesesal ven atas ka out keil koa musil vali Oaisal Sodan.” ");
INSERT INTO pma_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Ka Kelep mai vesesal ven Mosis en meten meatin keil, mumon keil tine merau ka vit, “!Rovaha varei, rovakur out! !Veni rokileas rovou lin keil!” ");
INSERT INTO pma_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Ka meatin sav keil koa uva ral min Kelep avit, “!Vuo! Ir rorkeihtei rovou lin keil. Meatin keil ten out enek, ave keih imok mulin ir.” ");
INSERT INTO pma_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Sakini asakin selusien ten luvosien karahit me-Isrel keil usil atan koa uva alesi koa sakin rendemien one mot. Keil avit, “Atan enek mul san matien min koakeil aro ien. Ka koakeil vasi koa aro en out enek atetaveah. ");
INSERT INTO pma_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Komai meles keil ave marmarite ka atetaveah, melonge keke mesuval titi kal keil, ka keil iles komai hemukonek eli varei.” ");
INSERT INTO pma_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","En vongien enek, me-Isrel keil alonge tisa houlu ka amul amuai. ");
INSERT INTO pma_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Keil asel kutut kat Mosis ka Eron avit, “Tahos imok munak komai mevamatmat en out Isip vuo en out volvol ekek. ");
INSERT INTO pma_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","?Vensa Iahova vit vakur ir rovaha en atan ekek? U vinvini ir ka ikur ahin keil orer ka titiali keil emun. Vahit vatahos imok keke rovaha ris en out Isip.” ");
INSERT INTO pma_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Sakini, aviteni min keil eris avit, “!Rovatie lat etai meatin hemai hehi hetetamen orer ka reheha ris Isip!” ");
INSERT INTO pma_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Navong Mosis keilu Eron lulonge, luva netan min Iahova en meten me-Isrel keil. ");
INSERT INTO pma_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Ka elu en koakeil ales out Kenan: Sosua koa natin Nan, keilu Kelep koa natin Sepuneh, keilu lulonge tisa ka lurali vas eisin omealu. ");
INSERT INTO pma_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Ka luviteni min meatin keil luvit, “!Atan koa komai melesi tahos imok! ");
INSERT INTO pma_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Munak Iahova hesi ven ir, kei hekur ir reheha en more atan enek, atan koa tahos imok ka amas mul ien. ");
INSERT INTO pma_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Minahilestei eisilumi ran Iahova ka minametauntei meatin keil koa amul en out enek. Ahi hesakin ir rehouas keil hemae enges veni ro ral min ir ka kulat tounah koa ring koe keil tuai. Anatin, minametautei.” ");
INSERT INTO pma_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Meatin vasi keil en out enek amul avit avov keitel telvamat. Ka hatte tas, muohien onen Ahi kistal en Eim Tavolin onen en mete. ");
INSERT INTO pma_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Iahova viteni min Mosis ka Eron vit, ");
INSERT INTO pma_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“?Meatin keil ekek isel kutut kat nau hetokol nengeis? !Inau naraengon selkututien keil one vinvin! ");
INSERT INTO pma_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Milhehit mesein selusien enek min keil milhehit, ‘Navat kati hehi anatin, tounah vasi koa tisa koa lises mimul mivit namumoni min kami, kei varei numoni hemai hehi anatin. Inau Iahova naselus. ");
INSERT INTO pma_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Kami vasi mihematmat ka teiai keil onami il retai en out volvol ekek. Anatin, kami koa misel kutut kat nau, koa sua onami mulin hanumau (20), ");
INSERT INTO pma_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","mihervatei mun en atan en out enek. Anatin keke navat kati nisani min kami, ka mihervatei ien. Kelep enges keilu Sosua luheha en out enek. ");
INSERT INTO pma_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Kami mivit meatin keil ten out enek ihuli kat titiali onami keil. Ka inau nikur titiali onami keil iha keke umon teim se en atan koa kami milei seseini. ");
INSERT INTO pma_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Ka kami, mihematmat en out volvol ekek. ");
INSERT INTO pma_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Titami keil iles ual tetoun en out volvol ekek sua hehi hanumau elu (40). Ka ven mirvitei anatin minau, keil ilong mahien hetokol avong koa kami vasi mihematmat. ");
INSERT INTO pma_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Mihean hei tisaen onami sua hehi hanumau elu (40), sua tai ten avong keil koa avi hanumau elu (40) koa meatin onom keil alei vasin out enek. Miheilea inau suk ka vati vurohien onak. ");
INSERT INTO pma_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Navat kati keih keke numon tounah ekek min kami, meatin tisa keil koa mimai en rendemien tas va kat inau. Sakini, en out volvol ekek, kami vasi mihematmat. Anatin eli, inau Iahova namul naselus.’” ");
INSERT INTO pma_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Evus, koakeil Mosis rie lat keil keke avaha avalei suain atan enek, koakeil vasi umai ris ka asan selusien tisa va kat atan enek, ");
INSERT INTO pma_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Sakini, Ahi sakin mari mesaien tai mai ka muas keil umat. ");
INSERT INTO pma_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Ka, en meatin taleisuaien keil koa uva en atan enek, Sosua (natin Nun) keilu Kelep (natin Sepuneh) enges lumoul. ");
INSERT INTO pma_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Navong Mosis vit mesein selusien onen Iahova min me-Isrel keil, keil vasi amurang ka amurang. ");
INSERT INTO pma_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Sakini, out mulan, keil amemea ka asak mesein keil keke avaha avakur atan ten out Kenan, out koa hou keil amul ien. Uva mau ales Mosis ka aviteni mini avit, “Komai melei kilea tisaen onomai. Sakini, reheha rehekur atan koa Iahova vat kati min ir.” ");
INSERT INTO pma_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Ka Mosis vit risi min keil vit, “?Vensa varei kami mimules mirali koteh mengkatien keil onen Ahi? !Misakras mivakur atan enek! ");
INSERT INTO pma_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Minahatei, veni Iahova rorotei mun vatal min kami. Minamaen vativieh keil onami anu vini kami en vaeen. ");
INSERT INTO pma_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","En out enek, mihehisu min me-Amelek keil ka me-Kenan keil emun, ka keil isal vini kami hetal min naef tavaeen keil one. Keil umoni hemukok veni kami milokovein Iahova tuai. Sakini, kei emun lokovein kami.” ");
INSERT INTO pma_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Ka avaseini keke Mosis viteni mukok, keil uva en hou keil ten out Kenan keke avakuri. Uva, avaseini keke Mosis ka Bokis ten Hatkatien Takeih onen Iahova lurmusiltei keil, lumules en out koa amumon tavolin keil ome eni. ");
INSERT INTO pma_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Ka me-Amelek keil ka me-Kenan keil koa amul en hou keil ekek, umai uvae ral min keil ka amu lin me-Isrel keil. Anatin, keil alikat rasilin keil soutin va rokol out koa avise en Hormah. Evus, me-Isrel keil koa amules aviles ka amusil Mosis ka Eron koa Iahova rie lat keilu keke luvahi avat one. Amusil keilu va vio … rokol avong aro en out volvol sua hanumau elu (40). Ka keil avisu en avong takeih keil houlu en ualien one. ");
INSERT INTO pma_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","En avati koa mulamu ten sua hau, me-Isrel keil umai en out volvol ten out Saen, ka amumon votevav one en out koa avise en Kates. Ka en out enek, Miriam, ahinali Mosis, mat ka arahini. ");
INSERT INTO pma_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","En out koa aro ien, oai tovuol ka meatin keil umai akarahit Mosis ka Eron ");
INSERT INTO pma_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","ka aselus kutut kat Mosis avit, “Tahos imok keke komai mivamatmat en hen Iahova, navong mu vini onomai keil en metareh ten Eim Tavolin onen. ");
INSERT INTO pma_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","?Vensa komulamun komai memai en out volvol ekek keke mevamatmat vatal min buluk ka sipsip esomai keil? ");
INSERT INTO pma_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","?Vensa komulamun komai romemea ran out Isip keke romai en out koa vi heite hon? ?Kilesi? Ekonek, anien tovuol ka heiai tovuol. !Ka oai tovuol emun rovamuni!” ");
INSERT INTO pma_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Mosis ka Eron lumea ran meatin keil ka luvati keilu en metareh ten Eim Tavolin. Luvita netan, naealu vita rokol atan, ka lules muohien onen Iahova ritin kistal en keilu. ");
INSERT INTO pma_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Iahova viteni min Mosis vit, ");
INSERT INTO pma_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Kikur eisal onom ka milhehiteni min meatin keil imai out hetas. En mete, kiselus min mari ahat en vili kei va keke oai voue rani. En sakien enek, kisan oai min keil imuni ka min buluk ka sipsip emun keil ese.” ");
INSERT INTO pma_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Sakini Mosis va, kur eisal onen ran Eim Tavolin suval koa Iahova meng kati. ");
INSERT INTO pma_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Evus, Mosis ka Eron luvise ruain meatin keil uva vesesal ven mari ahat enek, ka Mosis selus keih min keil vit, “!Kami koa mivi uti selkututien, mihetaengonau! ?Mukave, milhekur oai ran ahat ekek ven kami?” ");
INSERT INTO pma_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Evus, Mosis mutelan eisal koa vuli kati, muas ahat enek eni hatte elu, ka mari oai mue rani. Sakini, meatin keil vasi amuni ral min buluk ka sipsip keil ese. ");
INSERT INTO pma_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Ka Iahova viteni min Mosis ka Eron vit, “Ven desien onamil enau rovinvintei keke milvahouhou en hivotutien onak en meten me-Isrel keil keke milromusil kattei asa naviteni, milhermulamuntei mun keil iha en atan koa inau navat kati min keil.” ");
INSERT INTO pma_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Me-Isrel vasi keil alokovein out Kates ka uva akistal en Vatihou Hor. ");
INSERT INTO pma_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Ekonek, en hakot ten out Edom, Iahova viteni min Mosis ka Eron vit, ");
INSERT INTO pma_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Eron hervatei en atan koa navat kati min me-Isrel keil. Kei hemat veni kamil milromusil kattei asa nameng kati min kamil en out Meribah. ");
INSERT INTO pma_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Sakini kikur Eron hetal Eliesar koa vi natnali, mithehina en Vatihou Hor. ");
INSERT INTO pma_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Ekonek, kikulat eisin keil ten pris ran Eron, kisin eni en Eliesar. Ka Eron, kei hemat en out enek.” ");
INSERT INTO pma_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Mosis musil asa koa Iahova meng kati mini. Ka en meten meatin vasi keil, keitel telvina en Vatihou Hor. ");
INSERT INTO pma_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Ka Mosis kulat eisin ten pris ran Eron ka musin en Eliesar eni. Ka en out enek, en hoi hou nesa, Eron mat. Ka Mosis keilu Eliesar lumita ris netan. ");
INSERT INTO pma_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Navong me-Isrel vasi keil akur longlongien keke Eron mat, keil vasi arangisi, ka araleh matien veni avong hanumau tai ka halualim emun (30). ");
INSERT INTO pma_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Me-Isrel keil alokovein Vatihou Hor ka amusil sise koa va en Atas Tahilhili. Amumoni mukonek ven e vati avakarahit atan esen me-Edom keil. Ka navong amul semau en sise, tine tamurei. ");
INSERT INTO pma_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Sakini aselus kutut kat Ahi ka Mosis avit, “?Vensa kokulat komai ran out Isip ka komulamun komai en out volvol mevamatmat? En out enek, anien ka oai tovuol varei. !Anien tisa enek, emai rovattei mun!” ");
INSERT INTO pma_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Sakini Ahi sakin tetal tisa keil houlu uva ven keil ka akat houlu en me-Isrel keil umatmat. ");
INSERT INTO pma_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Navong amul umatmat mukok, keil umai ven Mosis ka avit lat tisaen one avit, “Komai memum tisa navong meselus kutut kat Iahova ka keik. Kihis eli min Iahova hekulat tetal keil ihaha.” Sakini Mosis vis ven meatin keil. ");
INSERT INTO pma_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Evus, Iahova viteni min Mosis vit houmon hati aean tai hekur niniven tetal ka heti kati hel en ai tai. Hesakini navong tetal heat meatin tai, helele hehina nesa helesi ka hemai ris hetahos. ");
INSERT INTO pma_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Sakini Mosis mumon tetal tai en aean tai koa avise en brons ka muti kati en ai tai. Ka meatin keil koa tetal kat keil, navong alele vina nesa ales tetal enek, umai ris atahos. ");
INSERT INTO pma_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Me-Isrel keil uva ka amumon votevav one en aet ten out Moab, en usite ten Oaisal Sodan koa teisav en usite koa taon ten out Seriko mul ien. ");
INSERT INTO pma_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","En avong enek, asuv houlu ten out Moab, isen Balak, natin Sipor, kei longe mukave me-Isrel keil amu lin me-Amor keil ka longe mun keke avi houlu ramat. ");
INSERT INTO pma_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Sakini kei ka meatin keil onen ametau houlu ven keil. ");
INSERT INTO pma_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Me-Moab keil aviteni min hetetamen keil onen me-Mid keil avit, “Tali meatin keil ekek, hervitei tuetin, ian vasi tounah koa mul rahit ir, asuval buluk tai koa mul kan vasi oumunai en vieh onen.” Sakini asuv houlu Balak ");
INSERT INTO pma_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","sila eiloheh keil onen uva avahise Balaam, natnali Beor, koa ro en taon ten out Pethor, vesesal ven Oaisal Upretis en atan ten out Amao. Keil akur selusien onen asuv houlu Balak mai veni koa vit, “Tali meatin keil koa mariso ramat aka en out Isip. Meatin keil teni amul asien vasi out, ka amul asak avalah lat atan oser. ");
INSERT INTO pma_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Keil avi houlu mok amulin ir. Sakini napeahik eli kovamai kovasesenda en keil en usite onak. Hesakini, ir rokilea rovou lin keil ka rovalikat keil avamea ran atan oser. Namul navisuk veni nakilea keke koakeil koviten tokolkatien va min keil, keil enek akur tokolkatien. Ka koakeil kosesenda en keil, asas koviteni mai kistal vi anatin.” ");
INSERT INTO pma_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Navong hetetamen keil onen me-Moab keil ka onen me-Mid keil uva ven Balaam, akur uite ten sesendaen ral min selusien onen asuv houlu Balak. ");
INSERT INTO pma_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Ka Balaam viteni min keil vit, “En vongien kosa, mihetos hetal minau. Ka visuvong, nihiten asa koa Iahova hehiteni minau.” Sakini hetetamen keil enek aros ral min Balaam. ");
INSERT INTO pma_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","En vongien enek, Ahi viteni min Balaam vit, “Konahatei natal meatin keil keisom, ka konoumontei sesendaen min me-Isrel keil, veni tokolkatien onak mul en keil.” ");
INSERT INTO pma_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Out mulan eris, en visokon, Balaam va ven eiloheh keil onen Balak ka viteni min keil vit, “Alha ris teim. Iahova seseini keke inau maha vatal kami.” ");
INSERT INTO pma_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Sakini uva ris ven Balak ka avit meseini mini keke Balaam seseini vousil keil. ");
INSERT INTO pma_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Sakini Balak sila ris hetetamen oteta keil emun koa avi houlu mok ka avi hetetamen amulin koakeil amulamu. ");
INSERT INTO pma_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Keil emun uva ven Balaam ka aviten selusien onen asuv houlu Balak mini avit, “Napeahik eli keke konamaentei tounah nating koek kovamai venau. ");
INSERT INTO pma_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Nisan uite hehi houlu vis hehi houlu mok minuk, ka tounah sa koa kihis nau eni, numoni minuk. Napeahik kimai li ka kisesenda en meatin keil ekek en usite onak.” ");
INSERT INTO pma_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Ka Balaam vit kesi min keil vit, “Avaseini keke Balak hesa vasin silva ka gol ten mari eim onen minau, nasakras malong sesein etai titi selusien ten mengkatien onen Iahova. ");
INSERT INTO pma_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Ka kami mihetos en vongien koanik hesuval tuomi keil amumoni. Hesakini, inau nakilea mailea keke Iahova hesan ris etai selusien minau mahiteni min kami.” ");
INSERT INTO pma_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","En vongien enek, Ahi mai ven Balaam ka viteni mini vit, “Munak meatin keil ekek imai avahisuk kovaha, kisak mesei ka kiha hetal min keil. Ka kumon asas varei koa nihiteni minuk.” ");
INSERT INTO pma_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Out mulan en visokon, Balaam sak mesein dongki esen ka musil hetetamen keil ten out Moab. Anatin keke Ahi maen Balaam vousil hetetamen keil ten out Moab, ka Ahi lei kilea rendemien onen Balaam koa en vati mok vakur uite ten sesendaen. Ven rendemien ten metenan onen, Ahi sila angelo tai onen keke vating koe sise onen. Balaam mul rondan en dongki esen ka reingeingeni keke angelo ring koe sise. Dongki enges lesi ka vati. Navong vati mukonek, Balaam tin katiat ka muasi. Avong etel mumoni mukonek, ka Balaam mul esuk muasi keih. ");
INSERT INTO pma_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Evus Iahova sakin dongki kilea vaselus, ka viteni min Balaam vit, “?Namumon sa minuk? ?Vensa komuas nau hatte etel?” ");
INSERT INTO pma_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balaam vit kesi mini vit, “Veni keik kosakinau namemou vareis en meten hetetamen keil ekek. Vahit makur naef, kosa, masahuk kovamat.” ");
INSERT INTO pma_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Dongki vit kesi mini vit, “Inau navi vati dongki etin koa komul komuloh eni lises en moulien onom. ?Mukave, namumon sakien koanik minuk mulamu?” Balaam vit, “Vuo.” ");
INSERT INTO pma_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Evus, Iahova maen Balaam les angelo onen vatimal ral min naef onen. Navong Balaam lesi, mot va netan ka nan rokol atan. ");
INSERT INTO pma_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Evus, angelo vis katiati keih vit, “?Vensa komuas dongki esom hatte etel mukok? Numai mating koek veni sise onom romaltei en meten Ahi. ");
INSERT INTO pma_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Ka dongki esom les inau ka viles hatte etel va en usite. Vahit varvilestei, inau mou vinik ka mamaen dongki vamoul vaha.” ");
INSERT INTO pma_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balaam vit kesi mini vit, “Inau namumoni eli romaltei. Nareingeingeni keke keik kovatimal en sise kovating koe inau. Ka ekek, munak kovit tisa keke inau maha, niha ris teim.” ");
INSERT INTO pma_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Ka angelo viteni vit, “Kiha hetal meatin keil ekek, ka kihiten asas varei koa naviteni minuk kovahiteni.” Sakini Balaam musil ris keil uva. ");
INSERT INTO pma_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Ka Balaam va ral min Balak en taon ten out Husot. ");
INSERT INTO pma_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Ekonek, Balak muas buluk ka sipsip keil ka san hatte koa min Balaam ka hetetamen keil emun koa uva ral mini. ");
INSERT INTO pma_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Out mulan eris, asuv houlu Balak mulamun Balaam luvina en hou ten out Bamot-Baal. En out enek, Balaam kilea vales tei en me-Isrel keil. ");
INSERT INTO pma_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Evus, Balaam viteni min Balak vit, “Umon avet tasanien votut oulu (7) ekok, ka kikur buluk oulu (7) ka sipsip emun koa vi meahos hehi oulu (7).” ");
INSERT INTO pma_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balak mumoni suval koa kei viteni, ka keilu Balaam, lumumon sanien en buluk ka sipsip en avet retai keil ten sanien, ka lumunit keil. ");
INSERT INTO pma_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Evus, Balaam viteni min Balak vit, “Kilomal ekok hetal min sanien votut onom. Ka inau, maha malei visi keke Iahova vahisu vatal minau. Asas koa hehothot eni minau, nimai ris nihiteni minuk.” Sakini, kei enges vina nesa en hou. ");
INSERT INTO pma_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Ekonek, Ahi visu mini ka Balaam viteni mini vit, “Inau namumon ahor ten sanien oulu (7) ka namunit retai en buluk ka sipsip keil ien.” ");
INSERT INTO pma_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Iahova viteni min Balaam selusien koa heha hehiteni min Balak. ");
INSERT INTO pma_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Evus, kei va ris, les Balak mules mulomal vesesal ven ahor ten sanien onen ral hetetamen keil ten out Moab. ");
INSERT INTO pma_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Balaam vit mesein ren Ahi vit: “Asuv houlu Balak kur nau ran hou keil ten out Aram en usite ist. Kei vise inau vit, ‘Amai selus en usite onak. !Kisesenda en me-Isrel keil!’ ");
INSERT INTO pma_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Hemukave nisesenda en koakeil koa Ahi rosesendatei en keil? Nasakras masan mahien min koakeil Iahova rosantei mahien min keil. ");
INSERT INTO pma_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Navong naro en hoi hou nesa, nakilea matapehai en keil, namul en vatihou nesa ka nalei usil keil. Keil avi meatin sase enges, akilea keke tokolkatien mul en keil mulin kantri savsav keil. ");
INSERT INTO pma_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Vatiamal keil koa akikistal ran Siekob avi houlu suval vulimeas; me-Isrel keil, asakras avahuli keil. Navong moulien onak hevus, ek vat keite teni hesuval tai en meatin keil ekek onen Ahi. Ek vati nimat en tomat hesuval koakeil enek koa amutolas en meten Ahi.” ");
INSERT INTO pma_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Evus, asuv houlu Balak viteni min Balaam vit, “?Komumon sa minau? Nakuruk kumai ekok kovasesenda en koakeil avi vativieh ral nau, ka keik kosan tokolkatien esuk min keil.” ");
INSERT INTO pma_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Ka Balaam vit risi mini vit, “Inau nihiten asas varei koa Iahova viteni minau maselus eni.” Asuv houlu Balak kur Balaam luvina en hou elu sav eris keke Balaam vasak visi vasesenda en me-Isrel keil ien. Ka en avong vasi, Iahova maeni vasan selusien ten tokolkatien enges va min keil. ");
INSERT INTO pma_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Navong Balak raengon selusien onen Balaam, pulin hen en vurohien ka viteni mini vit, “!Navisok kovasesenda en koakeil avi vativieh minau, ka avong etel ekek, keik korokol kat keil! ");
INSERT INTO pma_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","!Keitinek, kiha ris teim! Inau navat kati nisan uite minuk, ka Iahova sakinuk kosakras kovakuri.” ");
INSERT INTO pma_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balaam vit kesi mini vit, “Inau naviteni tuai min eiloheh keil onom koa kosila keil umai venau keke ");
INSERT INTO pma_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","avaseini kisani minau silva ka gol vasi keil koa mul en mari eim omom, inau nasakras malong ras mengkatien onen Iahova. Anatin, nasakras moumon etai tounah koa tahos vuo tisa inau sasok enges, ka nakilea nihiten asas koa Iahova viteni minau mahiteni.” ");
INSERT INTO pma_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Evus, Balaam viteni min Balak vit, “Kosa, inau niha ris ven meatin onak keil. Ka hekatau niha, inau nisan selkatien minuk usil asa koa me-Isrel keil umoni min meatin keil onom en avong koa veite veah.” ");
INSERT INTO pma_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Evus, kei vit mesein ren Ahi enek mini vit: “Koanik vi selusien onen Balaam natin Beor, selusien onen meatin koa lei kilea en tounah. ");
INSERT INTO pma_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Koanik selusien onen kei koa mul long kilea selusien onen Ahi, ka mul kur ileilien ka ven Ahi ten out nesa. Selusien enek ka ven kei koa les matil vovoien keil ka romatiltei, koa kur leisanien ka ven Ahi ten Keihoen: ");
INSERT INTO pma_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Inau nalele soutin, en avong keil koa hemai veah, ka nales kantri ten out Isrel. Nales asuv houlu tai koa hekistal ien koa hesuval hitu koa vihil tahos imok, kei hekistal hehina nesa helosil kat me-Isrel keil. Hou vasin hetetamen keil ten out Moab, ka hou lin vasi meatin keil ten out Set. ");
INSERT INTO pma_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Kei hou vini me-Edom keil ka hesakin me-Seir keil itovuol emun. Houmon atan ese hemai hehi onen, ka keihoen onen me-Isrel keil hel lises. ");
INSERT INTO pma_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Kei koa heka ran me-Isrel keil hehitan en koakeil avi vativieh eni, ka u vasin meatin sav emun keil ten taon ten out Ir koa amoul amules.” ");
INSERT INTO pma_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Evus Balaam mea ka va ris teim sen. Ka Balak emun, va ris en sise onen. ");
INSERT INTO pma_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Avati keil muli, ka Iahova viteni min Mosis vit, “Kikur Sosua, natin Nun, koa vi tinahos ka ninin onak mul ien. Kitokol kati ");
INSERT INTO pma_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","ka kumoni helomal en meten pris Eliesar ka en meten meatin vasi keil. Ka navong komumoni mukok, kihit meseini min keil keke kei hekur vulum. ");
INSERT INTO pma_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Ka hiasuvien koa mul en hem, kisan hatte tai mini vasakin me-Isrel keil ilong kati.” ");
INSERT INTO pma_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Sakini Mosis musil asa koa Iahova meng kati mini. Kei ling Sosua mulomal en meten pris Eliesar ka en meten meatin emun keil. ");
INSERT INTO pma_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Ka musil ren Iahova, Mosis rokol kati ka vitehiteni keke kei hekur vulin. ");
INSERT INTO pma_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","Ka navong Mosis mulomal en meten me-Isrel keil, sel kat keil vit, “!Me-Isrel keil, mihelonge! Iahova, kei tanges varei vi Ahi orer. ");
INSERT INTO pma_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Emi hehat Iahova koa vi Ahi onami en tinomi, en moulien vasi keil onami, ka en umen vasi keil onami. ");
INSERT INTO pma_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","Emi navobongentei mengkatien keil koa nisani min kami kosa. ");
INSERT INTO pma_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","Ka mihehiseini min titami keil. En avong vasi, mihehitehiteni min keil: navong miheto teim ka navong mihoual; navong miheseh, ka navong emun mihoum. ");
INSERT INTO pma_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","“Iahova, Ahi onami, helamun kami miheha en atan koa mivaha mivato ien. En out enek, vangi meatin keil oulu (7) aro ien. Keil vasi avi houlu mok ka akur keihoen mulin kami: me-Hit keil ka me-Kirkas keil; me-Amor keil ka me-Kenan keil; me-Peres keil ka me-Hiv keil; ka me-Sebus keil emun. Ka navong mivaha en out enek, Ahi helikat rasilin keil vasi ran out enek. ");
INSERT INTO pma_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","Navong Iahova, Ahi onami, heling keil heha en hemi, mihou vasin keil imatmat. Anatin, navong moulien one hel en hemi, minoumontei hatkatien ten tomat natal min keil. !Vuo! Emi namahistei keil. ");
INSERT INTO pma_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","“Minatetalihetei natal min keil ka minamaentei titami keil anatetalihetei natal min keil, ");
INSERT INTO pma_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","veni keil akilea ilamun titami keil iha soutin ran Iahova ka iha netan min ahi sav keil. Munak hemukonek, hatte tas, Iahova hevuroh kat kami ka hou rasilin kami. ");
INSERT INTO pma_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","Hesakini mihoumoni hemukonek: ahor ten sanien one, mihou rasilini; ahat lou keil one, mihou pahasi hemahoiahoi; ai lou keil one, miheta kokotehei; ka nana keil one, mihesoni heha en ahang. ");
INSERT INTO pma_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","Mihoumoni hemukonek ven koa Iahova, Ahi onami, mumon kami mivi votut ka mivi onen. En vangi meatin keil ten out netan, Iahova rie lat kami keke mivi onen enges varei, miteisav ran meatin sav keil. ");
INSERT INTO pma_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","“Iahova rolei kantei kami ka rolingtei envatien onen val en kami veni mivi houlu mok en vangi meatin sav keil. !Vuo! Veni en out netan, mivi havivi mok en vangi meatin sav vasi keil. ");
INSERT INTO pma_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","Ka mukos, Iahova, envatien onen mul en kami ka en vat vousil kat hatkatien takeih koa mumoni ral min avu onami keil telamu. Ven koanik, kei mutut kami ka kulat kami ran hen asuv houlu ten out Isip. ");
INSERT INTO pma_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","Sakini mihendem kati keke Iahova, Ahi onami, kei tanges vi anatin. Kei, en rovobongentei hatkatien keil onen. !Vuo! Lises kei musil kati. Koakeil e vati ka amusil kat mengkatien keil onen, kei houm vasin hatkatien takeih onen ka hetie lat envatien onen min keil: min koakeil ten avong kosa, ka min koakeil ikatau veah heha vio … keite teni hetovuol. ");
INSERT INTO pma_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","Ka Ahi roka merautei, koakeil aseseini, hesan mahien min keil hekalah. ");
INSERT INTO pma_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","Hesakini, mihelosil kat kami keke mivalong kat tounah vasi koa navisein kami eni. Hihiseien keil ka mengkatien keil vasi koa nasani min kami kosa, mihousil kati hekeih. ");
INSERT INTO pma_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","“Mihendem kat sise koa taveah en out volvol koa Iahova mulamun kami eni sua hanumau elu (40). Ka en avong keil enek, Iahova san sakvisien keil mai en kami keke helei kilea rendemien onami: mihesak mesein kami keke mivalong kat mengkatien keil onen vuo miherlong kattei. ");
INSERT INTO pma_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","Kei sakin rendemien onami vita netan navong maen amai kat kami. Ka katau eni, san manna mikani. Manna enek vi heite hau, rosuvaltei anien sav keil koa kami vuo avu onami keil avaan kilea en avong mulamu. Kei mumoni mukonek vit vahisein kami keke meatin romoultei en anien enges. !Vuo! Meatin mul moul en selusien keil vasi koa ka en ren Iahova. ");
INSERT INTO pma_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","“Mihelei kati keke emi navobongentei Iahova, Ahi onami. Minalokoveintei mengkatien keil onen koa nasani min kami kosa. Mihelong kat keil vasi. ");
INSERT INTO pma_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","En avong koa hemai, vangomi hehil ka miheto hetahos en more eim keil koa mihoumoni. ");
INSERT INTO pma_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","Buluk ka sipsip esomi keil imai ihi houlu mok ka moulien onami hehilelau en mani ka tounah sav emun keil. ");
INSERT INTO pma_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","En avong enek, minavuttei kami. Emi navobongentei keke Iahova, Ahi onami, kei kulat kami mimaluv ran hen me-Isip keil navong mivi slev keil veah. ");
INSERT INTO pma_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","Kei varei mulamun kami en mari out volvol, out koa tisa mok koa tetal keil ka skopion keil amul ien. Oai emun tovuol ien, ka kei mumon oai kistal en ahat tai keke mimuni. ");
INSERT INTO pma_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","En out volvol enek, kei san manna mikani, anien tai koa avu onami keil telamu areingeingeni. Ka kei san avong takeih min kami vasak vis kami ka houmon rendemien onami heha netan. Mumoni mukonek vasakini, en keite teni, kilea vatokol kat kami en mormore tounah keil. ");
INSERT INTO pma_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","Hesakini, minandemtei minahit kami mikur tounah houlu en keihoen onami enges. ");
INSERT INTO pma_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","Mihendem kati keke Iahova, Ahi onami, kei enges san keihoen min kami mikilea mivahilelau en tounah keil. Kei mumoni mukok ven kei musil kat hatkatien takeih koa mumoni ral min avu onami keil telamu. ");
INSERT INTO pma_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","Emi navobongentei Iahova, Ahi onami, vuo minahilestei minousil ahi sav keil ka minahatei netan min keil. Munak mihoumoni hemukonek, miheilea keke kami vasi mihematmat. ");
INSERT INTO pma_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","Munak mirlong kattei Iahova, kei hou rasilin kami. Anatin, houmoni min kami vati sakien keil koa houmoni min vangi meatin keil koa aro en atan koa miheha ien. ");
INSERT INTO pma_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","“Mihendem kat mengkatien keil enek, ka mihekur kati en moulien onami. Mihetis keil, ka mihepar kati hel en hemi ka en vatumi keke mihendem kati lises. ");
INSERT INTO pma_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","Mihehiseini min titami keil. Anatin, en avong vasi, mihehitehiteni min keil: navong miheto teim ka navong mihoual; navong miheseh, ka navong emun mihoum. ");
INSERT INTO pma_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","“Kosa, naling sise elu en metomi: sise ten tokolkatien ka sise ten mahien. ");
INSERT INTO pma_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","Munak mihelong kat mengkatien keil onen Iahova, Ahi onami, koa nasani min kami kosa, kei hetokol kat kami. ");
INSERT INTO pma_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","Ka munak mihermusiltei mengkatien keil enek ka mihiles ran Iahova keke miheha netan min ahi hau keil, Iahova hesan mahien houlu heha kat kami. ");
INSERT INTO pma_vpl VALUES ("DT18_9","006_18_9","DEU","18","9","9","“Navong miva en atan koa Iahova, Ahi onami, mul sani min kami, minousiltei sakien onen vangi meatin sav keil koa amul en out enek koa atisaso en meten Ahi. ");
INSERT INTO pma_vpl VALUES ("DT18_10","006_18_10","DEU","18","10","10","Minalingtei titami keil en ahor ten sanien ka minanittei keil ien. Minoumontei sakien ten lingling temat, minahotin vistei asa koa hemai heka en tounah keil koa amul akistal en out netan, ka minoumontei sakien ten eimas. ");
INSERT INTO pma_vpl VALUES ("DT18_11","006_18_11","DEU","18","11","11","Minoumontei vati sakien ten masing, tukoi vuo mae. Ka minahistei tounah ran ninin onen meatin keil koa umat tuai. ");
INSERT INTO pma_vpl VALUES ("DT18_12","006_18_12","DEU","18","12","12","Iahova, Ahi onami, tin kat vati meatin koa musil sakien keil enek, keil avi amus en meten. Kei hou rasilin vangi meatin keil ran atan enek veni keil amumon vati sakien keil enek. ");
INSERT INTO pma_vpl VALUES ("DT18_13","006_18_13","DEU","18","13","13","Sakini, mihousil kat revi Iahova, koa vi Ahi onami.” ");
INSERT INTO pma_vpl VALUES ("DT18_14","006_18_14","DEU","18","14","14","Evus, Mosis viteni vit, “En atan koa misak mesein kami mivakuri, meatin koa, amusil sise ten sakien ten lingling temat ka avotin vis asa koa hemai ka en tounah keil koa amul akistal en out netan. Ka Iahova, Ahi onami, kei romaentei kami mivoumoni. ");
INSERT INTO pma_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","Sakini, kei hesan provet tai hesuval nau heka ven onami keiles, ka kami mihelong kat ren. ");
INSERT INTO pma_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","“Navong milah ruai en Vatihou Senae, mipeahi keke mivarlongtei mun ren Ahi ka mivarlestei mun mari ahang onen veni kami mimetau minamatmat. ");
INSERT INTO pma_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","Ka Iahova viteni minau vit, ‘Asa koa aviteni mal. ");
INSERT INTO pma_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","Inau nisan provet tai hesuvaluk heka enges ven one keil. Nihiteni mini asa koa hehiteni ka tounah vasi koa inau nameng kati mini, kei hehit meseini suk min meatin keil. ");
INSERT INTO pma_vpl VALUES ("DT18_19","006_18_19","DEU","18","19","19","Kei heselus en isok ka inau nisan mahien min meatin koa seseini valong kat ren. ");
INSERT INTO pma_vpl VALUES ("DT18_20","006_18_20","DEU","18","20","20","Ka munak provet tai heselus en etai tounah koa inau narvitentei mini, kei hemat hehinati. Vati hetas en provet emun koa heselus en isen ahi sav keil.’ ");
INSERT INTO pma_vpl VALUES ("DT18_21","006_18_21","DEU","18","21","21","?Ka kami miheilea keke selusien onen provet tai rokatei ven Iahova hemukave? ");
INSERT INTO pma_vpl VALUES ("DT18_22","006_18_22","DEU","18","22","22","Munak provet tai heselus en isen Iahova, ka asa viteni romaitei vahi anatin, miheilea keke koanek rovitei selusien onen Iahova. Provet enek selus enges en rendemien onen, ka kami minametauntei.” ");
INSERT INTO pma_vpl VALUES ("DT26_1","006_26_1","DEU","26","1","1","“Navong mikur atan koa Iahova, Ahi onami, mul sani min kami ka mimumon teim onami mul ien, ");
INSERT INTO pma_vpl VALUES ("DT26_2","006_26_2","DEU","26","2","2","hetetai en kami heling tei moei anien en tounah vasi koa imoul en ah ese keil, ka mihelingi en atuvoi ka mihekuri miheha en out koa Iahova, Ahi onami, hetie lati keke kei heto ien. ");
INSERT INTO pma_vpl VALUES ("DT26_3","006_26_3","DEU","26","3","3","Miheha ven pris koa lei kat out en avong enek, ka mihehiteni mini mihehit, ‘Inau mahitehiteni en meten Iahova, Ahi onak, keke narokol atan tuai koa kei vat kati hesani min avu orer keil telamu. ");
INSERT INTO pma_vpl VALUES ("DT26_9","006_26_9","DEU","26","9","9","Kei mulamun ir romai ekok ka san atan ekek min ir, atan koa tahos imok ka amas mul ien. ");
INSERT INTO pma_vpl VALUES ("DT26_10","006_26_10","DEU","26","10","10","Kosa nalahi mai ven Iahova moei anien koa kei sani min ir.’ Evus, miheling atuvoi ten anien netan en meten Iahova ka miheha netan mini. ");
INSERT INTO pma_vpl VALUES ("DT26_11","006_26_11","DEU","26","11","11","Mihemasmas Iahova, Ahi onami, ven mormore tounah koa kei sani min kami ral min koakeil en teim sami. Ka koakeil en vatiamal onen Livae ka koakeil emun ten kantri sav koa aro ral min kami, mihemaen keil iapil hetal min kami en mari ale enek.” ");
INSERT INTO pma_vpl VALUES ("DT31_7","006_31_7","DEU","31","7","7","Navong Mosis selus min me-Isrel keil evus, vise Sosua mai ka viteni mini en meten me-Isrel keil vit, “Kilomal hekeih ka konametautei. Keik enges varei keke kilamun meatin keil ekek mihekur atan koa Iahova vat kati min avu one keil telamu. ");
INSERT INTO pma_vpl VALUES ("DT31_8","006_31_8","DEU","31","8","8","Iahova kei enges helamunuk ka heto venuk. Kei houmon vasi asas koa vat kati minuk, kei sakras valokoveinuk. Sakini konandemkotei ka konametautei.” ");
INSERT INTO pma_vpl VALUES ("DT34_1","006_34_1","DEU","34","1","1","Navong Mosis selus min me-Isrel keil evus, mea ran out Moab koa vi aet, ka veou vina en hoi Vatihou Nebo nesa. Vina nesa mok en Vatihou Piska en usite va taon ten out Seriko. Ekonek en hoi hou nesa, Iahova rie lat atan vasi keil mini: atan koa hehi onen Kilead koa mul en usite koa saot rokol hakot ten atan koa hehi onen Dan koa mul soutin en usite koa not. ");
INSERT INTO pma_vpl VALUES ("DT34_2","006_34_2","DEU","34","2","2","Iahova rie lati mini atan vasi keil koa hehi onen Navtali, atan koa hehi onen Efrem ka Manase, atan koa hehi onen Sudah, ka lesi va va vio … rokol out koa meteiai vanu ien en Atas Medeterenia. ");
INSERT INTO pma_vpl VALUES ("DT34_3","006_34_3","DEU","34","3","3","Kei les hakot ten atan koa hehi onen Sudah koa mul en usite saot, va rokol mari aet koa mul luhu en Soar ka taon ten out Seriko koa avise en ‘taon ten vati vipi keil.’ ");
INSERT INTO pma_vpl VALUES ("DT34_4","006_34_4","DEU","34","4","4","Evus, Iahova viteni min Mosis vit, “Koanik vi atan koa navat kati ven Ebraham, Aesak ka Siekob keke nisani min vatiamal keil one. Namaeni kolesi soutin, ka narmaentei keik kovaha en out enek.” ");
INSERT INTO pma_vpl VALUES ("DT34_5","006_34_5","DEU","34","5","5","Ka en out enek, en atan ten out Moab, Mosis, koa vi eiloheh onen Iahova mat musil selusien onen Iahova. ");
INSERT INTO pma_vpl VALUES ("DT34_6","006_34_6","DEU","34","6","6","Iahova rahin Mosis en poal tai en out Moab, en usite va en taon ten out Betpeor. Ka meatin tovuol vailea out kave kati kei rahini ien rokol kosa. ");
INSERT INTO pma_vpl VALUES ("DT34_7","006_34_7","DEU","34","7","7","Navong Mosis mat, avaseini keke sua onen vi handred tai ka hanumau tai (120), aven keih enges ka meten keilu tahosis. ");
INSERT INTO pma_vpl VALUES ("DT34_8","006_34_8","DEU","34","8","8","Me-Isrel keil araleh matien veni avati tai en aet ten out Moab. ");
INSERT INTO pma_vpl VALUES ("DT34_9","006_34_9","DEU","34","9","9","Navong arangis Mosis evus, Sosua, natnali Nun, koa Mosis rokol kati, mai kur vulin. Iahova sakini vilelau en meteisauen. Ka me-Isrel keil along kat Sosua ka amusil kat mengkatien keil koa Iahova sani min keil ka en Mosis. ");
INSERT INTO pma_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","Katau en matien onen Mosis koa vi eiloheh onen Iahova, Iahova selus min Sosua, natin Nun vit, ");
INSERT INTO pma_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","“Mosis koa vi eiloheh onak mat tuai. Sakini kosa, kisak meseinuk, keik ka me-Isrel vasi keil, ka mihou koteh Oaisal Sodan ka miheha en atan koa namul nasani min keil. ");
INSERT INTO pma_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","Suval koa navat kati min Mosis, atan vasi keil koa mihoual ien, inau nasani tuai min kami. ");
INSERT INTO pma_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","Hakot keil ten atan onami mul en out volvol en usite saot vina rokol vatihou keil ten out Lebanon en usite not; ka en mari Oaisal Upretis en usite ist, atan vasi keil onen me-Hit keil, va rokol Atas Medeterenia en usite wes. ");
INSERT INTO pma_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","“En avong vasi komoul koro, out vasi koa kiha ien, vangi meatin sav keil hetovuol helinuk. Inau, nito venuk hesuval koa naro ral min Mosis. Anatin, inau nito hetal minuk lisenges ka nasakras malokoveinuk. ");
INSERT INTO pma_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","Rendemien onom hekeih ka konametautei, kilomal hekeih veni keik kihi avat onen meatin keil enek ka kilamun keil iha ikur atan koa navat kati min avu one keil telamu. ");
INSERT INTO pma_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","Anatin, rendemien onom hekeih ka konametautei. Kilei katuk keke kusil kat mengkatien vasi keil koa eiloheh onak Mosis sani minuk. Konasesein etai mengkatien keil enek ka tounah vasi keil koa kum visi en out vasi kiha ien, hekistal hemai hehi anatin. ");
INSERT INTO pma_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","Tus ten mengkatien keil, kihuli lises en meten meatin keil. Kindem usili meneai ka vongien. Hemukonek, kokilea kovoum vousil asa koa amutisi mul ien. Hesakini tounah vasi koa kiling hem eni hekur aneite ka asa koa kum visi hekistal hemai hehi anatin. ");
INSERT INTO pma_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","“Anatin, navit mahit risi minuk keke rendemien onom hekeih ka konametautei. Tinom namaleileitei vuo konandem maenuktei, veni inau, Iahova, Ahi onom, nito venuk en out vasi kiha ien.” ");
INSERT INTO pma_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","Evus, Sosua sila meatin elu taleisuaien ran out Akasia, out koa aro ien. Meng kat keilu keke luvalei suain atan ten out Kenan, ka luhelei revi mok taon ten out Seriko. Navong luva ka lurokol taon enek, luva luro en teim tai onen hoeaso tai, isen Rehab. ");
INSERT INTO pma_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","En vongien enek, asuv houlu ten out Seriko raengoni keke me-Isrel elu lumai luvalei suai en out. ");
INSERT INTO pma_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","Sakini, san selusien koanik va ven Rehab koa vit, “!Meatin elu koa lumul en teim onom, lumai luvalei suai en out vasi! !Lah lat keilu luvasital!” ");
INSERT INTO pma_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","6","Ka navong raeng kotehei keke meatin keil onen asuv houlu avamai veni, Rehab kur meatin keilu enek ka kav koe keilu en vangi flakis koa ling revi en hoi eim onen. Sakini, navong meatin keil onen asuv houlu umai avisi, kei vit, “Anatin, meatin oteta keil umai en teim onak ka inau narkileatei keke keil ten out kave. Ka keilu lulokovein teim sak navong meteiai munu ka akoteh en meteau ten taon. Inau narkileatei luva kave. Ka munak mihekatau sil keil hekalah, mikilea mivatokol keil.” ");
INSERT INTO pma_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","Sakini meatin keil onen asuv houlu, alokovein taon ka akoteh en meteau. Keil uva amul alekat me-Isrel keilu taleisuaien uva soutin rokol out koa sise ka pas Oaisal Sodan. ");
INSERT INTO pma_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","Navong meatin keilu taleisuaien lusak mesein keilu luvamatil, Rehab vina nesa en hoi eim, sao en keilu ");
INSERT INTO pma_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","ka vit, “Nakilea keke Iahova san atan ekek min kami. Meatin vasi keil en kantri ekek ametau vareis en kami. ");
INSERT INTO pma_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","Komai melonge mukave Iahova mumon Atas Tahilhili memes ven kami navong mimul milokovein out Isip. Melonge mun mukave mimu vini Sihon ka Og, asuv houlu keilu ten out Amor en out ist ten Oaisal Sodan. ");
INSERT INTO pma_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","Komai memetau houlu navong melonge mukok, ahang onomai mat varei ka keihoen onomai vasi tovuol emun. Anatin eli, Iahova, Ahi onami, kei vi Ahi ten out nesa ka ten out netan. ");
INSERT INTO pma_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","Kosa milhehat kati minau en isen Iahova keke milhoumoni min onak keil hetahos hesuval koa inau namumoni min kamil. Ka milhoumon etai metai minau keke malei kilea ka maling desien onak en kamil. ");
INSERT INTO pma_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","Milhehat kati minau keke navong meatin keil onamil imai ekok, milhoutut tata ka mama onak, tuak keil ka tukahin keil, hetal min one keil emun. !Milnamaentei anou vini komai li!” ");
INSERT INTO pma_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","Keilu luviteni mini luvit, “Iahova hekur moulien onomal munak melhermumontei tounah koa melviteni. Munak kirvitentei min meatin etai asa koa melmumoni, melvat kati minuk keke navong Iahova hesan atan ekek min komai, milhoumoni hetahos minuk, milhehi anatin en selusien keil onomal.” ");
INSERT INTO pma_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","16","Rehab viteni vit, “Milhehina lah en hou keil keiva veni meatin onen asuv houlu anahotin kamil. Milheto suai en out enek avong hetel hetokol avong keil imai ris. Hekatau suk, milkilea milvaha en sise onamil.” Eim koa Rehab ro ien amumoni kapil ral min vieh ten taon koanik. Sakini navong aselus evus, kei ling viau ka en titi metareh ten eim onen, ka maen lumali lusuvul ien luvita netan luva. ");
INSERT INTO pma_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","Meatin keilu taleisuaien luva en hou keil ka luro suai. Meatin keil onen asuv houlu, alekat keilu en out vasi avong etel, ka arvotintei keilu. Sakini uva ris en out Seriko. ");
INSERT INTO pma_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","Evus, meatin keilu taleisuaien lumita netan ran hou keil, lumu koteh Oaisal Sodan ka luva ris ven Sosua. Navong lulesi, luvitehiteni mini tounah vasi koa kistal ven keilu. ");
INSERT INTO pma_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","Ka luviteni mun luvit, “Komal melkilea keke Iahova sa vasi atan enek min ir. Meatin vasi ten out enek ametau vareis en ir.” ");
INSERT INTO pma_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","Sosua viteni min meatin keil vit, “Mihesak motein moulien onami, veni visuvong, Iahova houmon merikel keil hekistal en metomi mihelesi.” ");
INSERT INTO pma_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","Evus, kei viteni min pris keil avakur Bokis ten Hatkatien onen Ahi ka iha hetali ilamu en meatin keil. Ka amumoni suval koa kei viteni. ");
INSERT INTO pma_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","15","Avong koanek vi avong tasuhutien, mal en avong koa oaisal mul mue mariso. Meatin keil alokovein out aro ien keke avou koteh Oaisal Sodan, ka pris keil avous Bokis ten Hatkatien onen Ahi amulamu en keil. Navong pris keil aling ale vita en oaisal, ");
INSERT INTO pma_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","oai vati ka romuetei mun. Kei vileral out tas nesa soutin neli, vesesal en taon ten out Adam ka taon ten out Saretan. Koanik sakin sise ten oai memes, oai romuetei mun vatokol atas. Ka meatin keil akilea avoual kotehei en out vesesal en taon ten out Seriko. ");
INSERT INTO pma_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","Ka navong meatin keil amual koteh atan tames, pris keil koa avous Bokis ten Hatkatien onen Ahi amulomal luhu en atan tames en Sodan rokol avong meatin vasi keil arokol usite. ");
INSERT INTO pma_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","Longlongien keke Iahova mumon Oaisal Sodan memes rokol avong me-Isrel vasi keil amual kotehei ka vasi out. Rokol asuv houlu vasi keil ten out Amor koa amul wes ten Oaisal Sodan, ka rokol asuv houlu keil emun ten out Kenan koa aro vesesal en Atas Medeterenia. Ka navong alonge, ahang one mat varei ka ametaun keil houlu. ");
INSERT INTO pma_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","Evus, Iahova viteni min Sosua vit, “Kumon tei naef en ahat takan koa avise en flint ka kumon vekahoi en me-Isrel keil koa arvi vekahoitei veah.” ");
INSERT INTO pma_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","Sakini Sosua mumoni suval koa Iahova meng kat kei eni. Ka kei mumon vekahoi en me-Isrel keil en out tai koa avise en Hou ten Vekahoi. ");
INSERT INTO pma_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","6","Mulamu, en avong me-Isrel keil alokovein out Isip, meahos vasi keil avi vekahoi tuai. Ka ven keil enek along ras Iahova, meahos keil koa avinvin avahu en avong enek umatmat en ualien one en out volvol. Suval koa Iahova viteni, kei romaentei keil avales atan koa vat kati min avu one keil, atan koa tahos imok ka amas mul ien. Sakini me-Isrel keil amual koteh out volvol sua hanumau elu (40), ka tivava one keil koa meahos arvatei en vekahoi. ");
INSERT INTO pma_vpl VALUES ("JS5_7","007_5_7","JOS","5","7","7","Sakini koakeil enges avi heite hau en avong enek, Sosua mumon vekahoi en keil veni arvatei veah en vekahoi. ");
INSERT INTO pma_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","Navong amumon vekahoi evus, me-Isrel keil vasi aro out tas en votevav keil one rokol avong manu one mah. ");
INSERT INTO pma_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","Iahova viteni min Sosua vit, “Kosa nakulat memouen ten out Isip ran kami, out koa mivi slev keil ien.” Sakini out enek avise en ‘Kilkal’ koa aneite teni vi ‘kulati,’ ka eis enek mul veah rokol kosa. ");
INSERT INTO pma_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","Navong me-Isrel keil amul veah en out Kilkal, en mari aet vesesal en out Seriko, keil amumon mari ale ten Anien ten Mul Laui. Amumoni en mendilah en avong teindan ehat (14) en avati Aviv. ");
INSERT INTO pma_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","Out mulan eris, akan rohtoh en anien ten out Kenan. Alengas uti uit ka akan veret koa is tovuol ien. ");
INSERT INTO pma_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","En avong enek varei, manna rorivtivtei mun, ka me-Isrel keil arkantei mun. Avong koanek va, keil akan anien keiles koa amoul en atan ten out Kenan. ");
INSERT INTO pma_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","En taon ten out Seriko, meteau mules koteh ka meatin tavaeen keil alosil kati keke me-Isrel keil irvatei neim. Amumoni meatin tovuol vaha neim vuo vamea hae rani. ");
INSERT INTO pma_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","Ka Iahova viteni min Sosua vit, “Inau nasa lat taon ten out Seriko vaha en hem, ral min asuv houlu ka meatin keil tavaeen teni. ");
INSERT INTO pma_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","Keik ka meatin keil tavaeen onom mihekarahit mari taon enek avong hetas en avong vasi hetokol avong ahetai (6). ");
INSERT INTO pma_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","Ka pris oulu (7) ikur hon ten mari sipsip ka uhi ilamu en Bokis ten Hatkatien onen Ahi. Ka en avong oulu (7) teni, keik ka meatin tavaeen keil onom miheha mihekarahit taon avong oulu (7) navong pris keil il uh hon keil one. ");
INSERT INTO pma_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","Evus, pris keil uhi hekeih hatte hetah ka hetaveah. Ka navong miraengoni, meatin vasi keil imakul hekeih, ka mari vieh ten taon hemerangle. Hesakini meatin tavaeen keil onom akilea ika mal iha neim en taon enek.” ");
INSERT INTO pma_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","Sakini Sosua vise ruain pris keil ka viteni min keil vit, “Mihekur Bokis ten Hatkatien ka kami oulu (7) mihekur hon onami ka miheha mihelamu eni.” ");
INSERT INTO pma_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","Evus, kei meng kat meatin keil keke aval avakarahit mari taon ten out Seriko. Ka meng kat vangi meatin tavaeen keil iha ilamu en Bokis ten Hatkatien onen Iahova. ");
INSERT INTO pma_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","8","Ka suval koa Sosua viteni min meatin keil, pris keil oulu (7) amuh hon one ka ilamu en Bokis ten Hatkatien. ");
INSERT INTO pma_vpl VALUES ("JS6_9","007_6_9","JOS","6","9","9","Ka meatin keil tavaeen, vangite tai akaka amulamu en pris keil, ka vangite tai akaka akatau en Bokis ten Hatkatien. Ka hon keil, pris keil amuhi muleleh. ");
INSERT INTO pma_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","Ka Sosua meng kat meatin keil keke anamakultei mau ka anahiten etai selusien hetokol avong kei hehiteni min keil. ");
INSERT INTO pma_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","Sakini meatin keil enek akur Bokis ten Hatkatien onen Iahova ka akarahit mari taon enek heite tas. Evus, keil umai ris en out koa amumon votevav one mul ien ka akur vongien en out enek. ");
INSERT INTO pma_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","12","Out mulan eris en avong elu eni, en visokon semau, pris keil avous Bokis ten Hatkatien onen Iahova. ");
INSERT INTO pma_vpl VALUES ("JS6_13","007_6_13","JOS","6","13","13","Keil uva amual amusil vati sakien koa amumoni mulamu: meatin keil tavaeen amual amulamu, ka pris keil koa, amuh hon one akatau en keil. Evus, pris keil koa mun, avous Bokis ten Hatkatien, ka vangi meatin tavaeen keil akatau en keil vasi. Ka hon keil, pris keil amuhi muleleh. ");
INSERT INTO pma_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","En avong elu enek, amual rahit eris taon, ka uva ris en out one. Amumoni mukonek rokol avong ahetai (6). ");
INSERT INTO pma_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","Out mulan en avong oulu (7) teni, amea ka amual akarahit eris taon enek en vati sakien koa amumoni tuai. Ka en avong enesek, amual rahiti avong oulu (7). ");
INSERT INTO pma_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","Ka navong akarahiti evus, en avong oulu (7) teni, navong pris keil armuhtei mau hon ten mari sipsip one, Sosua viso keih va min meatin keil vit, “!Almakul, veni Iahova san taon ekek min kami! ");
INSERT INTO pma_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","Taon enek ka tounah vasi koa mul ien, mihou rasilini suval sanien votut tai min Iahova. Rehab enges ral min onen keil, minou vinitei keil veni kei ling suain meatin taleisuaien orer.” ");
INSERT INTO pma_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","Ka navong pris keil amuh hon keil one, meatin keil araengoni ka amakul keih. Navong amumoni mukonek, mari vieh ten taon ten out Seriko merangle ka meatin keil tavaeen avina varei en hou. Uva neim en taon ka asoso koe meatin keil teni. ");
INSERT INTO pma_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","Uva ral min naef tavaeen keil one ka amu vini tounah vasi koa amul ien: meahos ka ahin keil; titiali keil ka ulmatu keil; ka buluk, sipsip ka dongki keil emun. ");
INSERT INTO pma_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","Navong amumoni mukonek, Sosua viteni min meatin elu onen koa lulei suai en out vit, “Milheha neim en eim onen Rehab. Milhekur kei hetal min onen keil imemea ran out enek hesuval koa kamil milvat kati mini.” ");
INSERT INTO pma_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","Sakini luva lukur Rehab ral min tata ka mama onen, ka onen vasi keil. Alah keil avaha ran out ten rea ka luling keil vesesal en out me-Isrel keil amumon votevav ome mul ien. ");
INSERT INTO pma_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","Evus, alah tounah keil koa amumoni en gol, silva, brons ka aean, ka alingi en out aso ruain tounah keil onen Iahova mul ien. Evus, asan ahang kan rekau en taon ka kan lini vita rokol atan ral min tounah vasi koa amul ien. ");
INSERT INTO pma_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","Ka Sosua kur koe moulien onen Rehab ka onen keil. Kei mumoni mukonek veni kei ling suain meatin keilu taleisuaien koa sila keilu luva Seriko. Ka titan keil koa akistal eni amul veah en out Isrel rokol kosa. Evus, Sosua ka me-Isrel keil uvae ral min me-Kenan keil en usite tai va rokol usite sav ten kantri enek. Meatin houlu ten out enek, amu vini keil, ka keil koa, akur koe keil keke avato vatal min keil. Navong amumon rea evus, Sosua riti atan min vatiamal keil onen me-Isrel koa avi tai tan elu (12). Keil uva en out savsav keil one ka aro en meteimal keil koa me-Kenan keil amumoni. Sua houlu muli va, Sosua lah ruain me-Isrel keil umai ris out tas. ");
INSERT INTO pma_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","Sosua vise ruai vatiamal vasi keil onen me-Isrel umai veni en out Sekem. Vise metai keil one umai en meten Ahi: elda keil, hetetamen keil, koakeil alei revi usite onen meatin keil, ka avat ten meatin keil tavaeen emun. ");
INSERT INTO pma_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","Sosua viteni min meatin keil vit, “Iahova, Ahi onen me-Isrel keil, viteni mukok vit, ‘En avong telamu, avu onami keil aro en usi vali Oaisal Upretis, ka uva netan min ahi sav keil. Tai en avu keil enek vi Terah, tata onen Ebraham ka Nahor. ");
INSERT INTO pma_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","Evus, nakur Ebraham koa vi avu onami ran atan ten out Upretis ka namulamuni va kistal en atan ten out Kenan. Nasani mini titan Aesak, ka vatiamal keil onen Ebraham akistal aka ien. ");
INSERT INTO pma_vpl VALUES ("JS24_13","007_24_13","JOS","24","13","13","Inau nasan atan ka mari taon keilek min kami, atan koa mirmumtei veah ien ka taon keil koa mirvati lattei. Kosa miro en out enek ka mikan hei grep keil ka hei olip keil koa kami mirluhtei.’” ");
INSERT INTO pma_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","Sosua mules viteni min keil vit, “Kosa heha, mihousil kat Iahova hetal min envatien onami ka miheha netan mini lises. Mihelokovein ahi sav keil koa avu onami keil uva netan min keil en out Mesopotemia ka Isip. Anatin, mihousil kat Iahova ka miheha netan mini enges. ");
INSERT INTO pma_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","Munak emi rovattei mivousili, kosa, mihehit kilea keke mihousil sei: ahi keil koa avu onami keil uva netan mini en out Mesopotemia, vuo ahi keil onen me-Amor keil koa atan ese miro ien kosa. !Anatin, mihehit kilea mihousil kat ahi sa! Ka en usite onak ka onak keil, komai mehousil kat Iahova ka meheha netan mini enges.” ");
INSERT INTO pma_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","Meatin keil aviteni avit, “!Komai mesakras mevalokovein Iahova vuo mevaha netan min ahi sav keil! ");
INSERT INTO pma_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","Veni Iahova, Ahi onomai, kei kulat komai ka tata onomai keil ran hen me-Isip keil. Komai meles merikel keil koa kei mumoni. En out vasi keil meva ien ka kantri keil koa meka vasi, kei kur koe komai. ");
INSERT INTO pma_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","Navong memul meka vas atan koanik, Iahova likat rasilin me-Amor keil koa amul ien en metomai. Sakini komai mun mehousil kat Iahova ka meheha netan enges mini veni kei vi Ahi onomai.” ");
INSERT INTO pma_vpl VALUES ("JG2_6","008_2_6","JDG","2","6","6","Navong Sosua selus min me-Isrel keil evus, sila retai en keil uva avato en atan kati one. ");
INSERT INTO pma_vpl VALUES ("JG2_7","008_2_7","JDG","2","7","7","Ka en avong keil koa Sosua moul ro, me-Isrel keil along kat Iahova. Ka navong Sosua mat, meatin keil amules along kati rokol navong hetetamen one keil koa ales marmari tounah keil koa Iahova mumoni en usite onen me-Isrel keil umatmat. ");
INSERT INTO pma_vpl VALUES ("JG2_8","008_2_8","JDG","2","8","8","Navong Sosua, natin Nun, sua onen rokol handred tai ka halualim (110), kei mat. Kei vi more meatin toumien onen Iahova ");
INSERT INTO pma_vpl VALUES ("JG2_9","008_2_9","JDG","2","9","9","ka arahini en atan kati osen en hou keil ten out Timnat Serah, not en Hou Kas. ");
INSERT INTO pma_vpl VALUES ("JG2_10","008_2_10","JDG","2","10","10","Avong muli ka meatin keil vasi koa amoul en avong enek, keil vasi umatmat. Ka titae keil koa amea katau suk en keil, keil e vobongen Iahova ka tounah vasi koa kei mumoni en usite onen me-Isrel keil. ");
INSERT INTO pma_vpl VALUES ("JG2_11","008_2_11","JDG","2","11","11","Sakini me-Isrel keil amumon tisaen en meten Iahova ka uva netan min ahi sav. ");
INSERT INTO pma_vpl VALUES ("JG2_12","008_2_12","JDG","2","12","12","Keil alokovein Iahova, Ahi koa onen avu one keil, Ahi koa kulat keil ran out Isip. Ka amul amusil ahi savsav keil onen meatin keil koa amul rahit keil ka uva netan min keil. Asakin Iahova vuroh kat keil. ");
INSERT INTO pma_vpl VALUES ("JG2_13","008_2_13","JDG","2","13","13","Keil arvatei mun netan min Iahova, ka keil amules esuk uva netan min ahi meahos keil koa avise keil en Baal ka ahi ahin keil koa avise keil en Astata. ");
INSERT INTO pma_vpl VALUES ("JG2_14","008_2_14","JDG","2","14","14","Sakini Iahova tin katiat imok ven me-Isrel keil ka maen vangi tarhena keil umai apurun keil ka avenan tounah keil one. Meatin sav keil amul rahit keil, keil emun uvae kat keil. Ka Iahova maeni keke meatin savsav keil avakur keihoen vali me-Isrel keil, ka alesi keke asakras avating koe keil. ");
INSERT INTO pma_vpl VALUES ("JG2_15","008_2_15","JDG","2","15","15","Avong vasi keil avaha en rea, rendemien onen Iahova keih kat keil suval koa vat kati min keil houmoni. Sakini, keil alonge tisa houlu. ");
INSERT INTO pma_vpl VALUES ("JG2_16","008_2_16","JDG","2","16","16","Evus, Iahova san metai keil min me-Isrel keil koa umai alei revi usite keil one ka akataun keil ven vangi tarhena keil enek. ");
INSERT INTO pma_vpl VALUES ("JG2_17","008_2_17","JDG","2","17","17","Mukos, me-Isrel keil alei sesein metai one keil enek. Arlong kattei mun Iahova ka amai kat keil ven ahi sav keil ka uva netan min keil. Mengkatien keil onen Iahova koa tata keil along kati en avong onen Sosua, titae keil esuk alokoveini. ");
INSERT INTO pma_vpl VALUES ("JG2_18","008_2_18","JDG","2","18","18","Ka navong Iahova san metai tai min me-Isrel keil, kei san kataunien mini. Ka navong metai koanek moul ro, Iahova kulat me-Isrel keil ran hen meatin keil koa uvae ral min keil. En mahis keil mukonek veni long kilea mahien one ven koakeil asak purun keil. ");
INSERT INTO pma_vpl VALUES ("JG2_19","008_2_19","JDG","2","19","19","Ka navong metai enek mat, meatin keil aviles uva ris en sakien matu one, ka amumon sakien keil esuk tatisaso lohlin koakeil aro mulamu. Keil amusil kat ahi sav keil ka uva netan min keil. Aseseini avalokovein sakien tatisaso keil one. ");
INSERT INTO pma_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2","En avong mulamu, avong koa Iahova mul san metai keil avakataun me-Isrel keil veni arkurtei veah asuv houlu tai valosil kat keil, an tisa mai en out koa me-Isrel keil aro ien. Anatin, ous romustei avong houlu ka sakin anien tovuol ka amai kat meatin keil. Sakini, meatin tai ten out Betlehem mul en atan onen me-Sudah keil, kei va en kantri ten out Moab, isen Elimelek, ka kei kistal en mari vatiamal onen Efrat. Kei va ral min ahin onen, isen Noume, ka ral min natnali keilu, isealu Malon ka Kilion. Telva telro en atan onen me-Moab keil sua vahis. ");
INSERT INTO pma_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Ka navong telro en out enek, Elimelek mat, sakini Noume ro nges ral min natnali keilu. ");
INSERT INTO pma_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Evus, natnali keilu enek luretalihe ral min ahin Moab elu, isealu Oripa ka Rut. Navong telro en out enek sua halualim (10), ");
INSERT INTO pma_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Malon keilu Kilion emun lumat. Sakini, Noume kei sesuk ro, meatin onen ka natnali keilu emun teltovuol. ");
INSERT INTO pma_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Avati vahis muli, ka Noume kur longlongien keke Ahi rokol kat meatin keil onen ka sakin anien ose moul tahos eris. Sakini, Noume sak mesein kei valokovein kantri ten out Moab ral min ahineli keilu enek. ");
INSERT INTO pma_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Keitel vasi enek telva ruai telva ris en atan onen me-Sudah keil. Ka navong telmul telvaha, ");
INSERT INTO pma_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Noume viteni min keilu vit, “Kamil milheha ris milheles mama kati onamil ka milheto ris hetal min keilu. Inau navis min Ahi keke hetie lat tahosien min kamil hesuval koa milrie lati minau ka min natkuli keilu koa lumat tuai. ");
INSERT INTO pma_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Navisi mun keke Ahi hesakin kamil milhetetalihe eris ka milhehotin tahosien hetal min meatin hau keilu onamil.” Evus, Noume kav kat keilu ka vit valokovein keilu luvaha. Ka keilu lurangis Noume ");
INSERT INTO pma_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","ka luviteni mini luvit, “!Melsakras melvalokoveinuk eli! Melhousiluk, tovaha tovato vatal min meatin keil onom.” ");
INSERT INTO pma_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Ka Noume vit kesi min keilu vit, “Ahineli keilu, tahos imok milheha ris. ?Vensa varei milvit milvousil nau? ?Milmundemi keke nakilea makur ris ehon elu mun keke milhetetalihe hetal min keilu? ");
INSERT INTO pma_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","!Vuo! !Milheha ris! Inau navi tovuli ramat keke matetalihe eris. ?Avaseini munak navit matetalihe ris kosa, ka nikur ris ehon elu mun, ");
INSERT INTO pma_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","kamil milkilea milvatosil keilu vaha vio … luvamatu vinvin luvatetalihe? Vuo, koanek sakras vakur out. Ahineli keilu, kamil milkilea veah milvales tahosien, ka inau nasakras. Milnousiltei nau. En moulien onak, nalonge mah houlu veni hen Iahova keih kat nau.” ");
INSERT INTO pma_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Keilu lumuai eris. Evus, Oripa kav kat avu tisa onen, selus kor ral mini, ka lokoveini va ris en vatiamal onen. Ka Rut, kei vuli kati keih, en rovattei vaha rani. ");
INSERT INTO pma_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Sakini, Noume viteni mini vit, “?Rut, kolesi? Tumahin va ris ven meatin keil onen ral min ahi keil onen. Keik emun kusili kiha en vatiamal onom.” ");
INSERT INTO pma_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Ka Rut vit kesi mini vit, “!Konasilatei nau nanaha ranuk! Kimaenau mousiluk. !Out kave kiha ien, inau mun niha ien! !Out kito ien, inau mun nito ien! Meatin onom keil ihi meatin keil onak emun. Ka Ahi onom hehi Ahi onak emun. ");
INSERT INTO pma_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Out koa kimat ien, inau mun nimat ien, ka itahin nau en out enek. Inau nirmaen etai tounah hekulat nau niha ranuk heha vio … ialu tai hemat esuk. !Koanek vi hatkatien onak ka Iahova hesan mahien koa hekeih ramat hemai kat inau munak nitali kotehei!” ");
INSERT INTO pma_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Navong Noume lei kilea keke Rut, rendemien onen keih vousili, kei rosak vistei mun vasila vaha. ");
INSERT INTO pma_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Sakini, keilu lumual va vio … lurokol meteimal ten out Betlehem. Ka navong lukistal en out enek, meatin keil ten out enek amutimanin en keilu. Ka ahin keil amutimanin avit, “?Noume ekek?” ");
INSERT INTO pma_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Ka Noume vit kesi min keil vit, “Minahisetei nau li mun en ‘Noume’ ka mihehise nau en ‘Mara’ veni Iahova sakin moulien onak vilelau en mahien. ");
INSERT INTO pma_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Navong namea ran out ekek, hek keilu vilelau en tounah keil koa tahos. Ka kosa, Iahova kur ris nau numai hek heite hon enges. ?Vensa varei kami mivise nau en Noume veni Ahi ten Keihoen mumoni keih ramat minau ka san mahien keil minau?” ");
INSERT INTO pma_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","En sakien enek, Noume mea ran kantri ten out Moab ka va ris kantri ten out Isrel ral min ahineli Rut koa vi ahin Moab. Ka avong lurokol meteimal ten out Betlehem, bale men tuai en ah osen me-Isrel keil. ");
INSERT INTO pma_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","En meteimal ten out Betlehem, hetetamen tai ro ien koa tounah onen houlu, isen Boas. Kei kistal en vatiamal kati onen Elimelek, meatin onen Noume. ");
INSERT INTO pma_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","En avong tai, Rut vis Noume vit, “Kimaenau maha en ah etai keke malah ruain bale keil koa meatin toumien keil alokoveini merangle avahi anien ar. Vahesa nihotin meatin etai koa hemaenau moum en ah osen.” Sakini, Noume maeni vit, “Ahineli, tahosis, kiha kumoni.” ");
INSERT INTO pma_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Sakini Rut va en ah tai ka mul mum katau sil meatin toumien keil koa alah ruain bale. Ka kei lah hati bale koa keil alokoveini mules netan. Ka Rut, kei reingeingeni keke ah koa mul mum ien osen Boas koa kistal en vatiamal kati onen Elimelek, meatin onen Naomi. ");
INSERT INTO pma_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Rovitei tuetin, Boas ka en meteimal ten out Betlehem ka mai kistal min meatin toumien keil onen ka viso min keil vit, “!Iahova heto ven kami!” Ka avit kesi mini avit, “!Iahova hetokol katuk emun!” ");
INSERT INTO pma_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Evus, Boas vis avat toumien onen vit, “?Ahin hau eke onen sei?” ");
INSERT INTO pma_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Sakini avat enek vit kesi mini vit, “Ahin enek ten out Moab ka mai ral min Noume. ");
INSERT INTO pma_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Kei vis nau mamaeni vakatau sil meatin toumien keil koa amul alah ruain bale keil keke valah hati bale koa alokoveini mules. Kei mai en visokon semau ka mul mum rokol avong enek, museh avong havivis en votevav keie.” ");
INSERT INTO pma_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Evus, Boas va selus ral min Rut vit, “Ei atouli. Kitaengonau, ek vati keke kum en ah osak vesesal ven ahin toumien keil onak. Konahatei en ah sav tai keke kovalah ruain bale ien. ");
INSERT INTO pma_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Out kave keil amum ien, keik emun kitos vesesal ven keil. Naselus koe min meatin keil onak anoumtei natisa enuk. Ka munak maroro katuk, kiha kimun hati oai koa mul en veioai koa asehei tuai mul.” ");
INSERT INTO pma_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Navong Rut longe, retengeiril netan ka veinan rokol atan. Kei vit kesi mini vit, “?Vensa komul komundemko venau? ?Vensa komul komumoni tahos minau koa navi heou tai enges?” ");
INSERT INTO pma_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Boas vit risi mini vit, “Inau nakur longlongien usil sakien tetahos keil koa korie lati min avu tisa onom navong meatin onom mat. Nakilea keke keik kolokovein tata ka mama onom ka kantri kati onom keke kumai kovato vatal min meatin keil koa koreingeingen keil mulamu. ");
INSERT INTO pma_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Navis min Iahova hesa kesi minuk tahosien koa keik komul korie lati mini. Anatin, Iahova, Ahi onen me-Isrel keil, hesan sanien tai koa hetahos imok minuk veni keik koling desien onom eni valei kat revi keik ka vating koe moulien onom.” ");
INSERT INTO pma_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Evus, Rut vit kesi mini vit, “Hetamen, keik komumoni tahos imok minau li. Avaseini inau narvinvintei keke mamai mahi ahin toumien tai onom, keik koselus revi minau ka kovati lat rendemien onak.” ");
INSERT INTO pma_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","En taviai, navong meatin keil amul akanian, Boas viteni min Rut vit, “Amai vesesal, an vis etai veret ka kikasi en uaen koa kun koanek.” Sakini, rondan ral min meatin toumien keil, ka Boas san hati bale koa alengasi mini. Rut kanian vinvin ka ling revi anien koa mules. ");
INSERT INTO pma_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Navong Rut muris va voum, Boas sel kat meatin toumien keil onen vit, “Mihemaeni valah ruain bale en out vasi keil koa en vati. Avaseini munak lah ruaini ran vangite keil koa kami mipar kati tuai, minavul kattei. ");
INSERT INTO pma_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Ka tamun, tahos mihelah lat tei bale ran vangite keil ka mihesoni heha netan keke ahin enek hemai helah ruaini.” ");
INSERT INTO pma_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Sakini, Rut lah ruain bale en ah enek va rokol mendilah. Ka navong mu rangrangi, votini keke uti bale keil koa lahi, kilo teni vi teindan elu (12 kg). ");
INSERT INTO pma_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Vous uti bale keil enek va ris teim ka rie lati min avu tisa onen. Evus, anien koa kei ling revi mules, kei mun, Rut sani mini. ");
INSERT INTO pma_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Navong Noume lesi, mutimanin eni ka visi vit, “?Kosa, kolah ruain uti bale keil enek en out kave? ?Ah sen sei varei keke komum ien? Tokolkatien onen Ahi hel en meatin koa lesuk ka mumoni tahos minuk.” Sakini, Rut viteni min Noume vit, “Namum en ah sen meatin tai koa isen Boas.” ");
INSERT INTO pma_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Noume viso keih vit, “!Tokolkatien onen Iahova hel en kei! Iahova rie lat tahosien onen min ialu koa lomoul loro veah ka min meatin keilu oralu koa lumat tuai. Meatin koanek vi tai en vatiamal kati onen meatin onak. Musil sakien onen me-Isrel keil, kei varei helei kat usite oralu.” ");
INSERT INTO pma_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Ka Rut vit, “Ka koa tahos imok, kei viteni minau vit niles nilah ruain bale hetal min meatin toumien keil onen heha hetokol avong koa alah vasin anien ran ah keil osen Boas.” ");
INSERT INTO pma_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Noume viteni min Rut vit, “O ahineli, hetahos imok kiles kum hetal min ahin keil koa amul amum en ah sen Boas. Veni munak kiha kum en ah sen meatin sav, vahesa meatin etai houm hetisa enuk.” ");
INSERT INTO pma_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Sakini, Rut mum ral min ahin toumien keil onen Boas va vio … rokol avong koa alah ruain bale keil, ka katau, alah ruain uit emun ran ah vasi keil osen Boas. Ka Rut ro nges ral min avu tisa onen enek. ");
INSERT INTO pma_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","En avong tai, Noume viteni min Rut vit, “Havukahin, hetahos imok keke inau nihotin etai meatin vatetalihe vatal minuk ka helei kat revi keik. ");
INSERT INTO pma_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","?Kindem kat Boas, meatin koa komum ral min ahin toumien keil onen? Kei ka en vatiamal onen meatin keilu oralu. Sakini, kitaengon revi inau. En mendilah kosa, kei heha hou rangrang uti bale ran ingeite keil teni. ");
INSERT INTO pma_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Sakini, keik kiha kikul, kisin hetahos ka kikasuk en senta. Hevus, kiha en out toumien onen, ka konoumontei keke kei nakilea komul en out enek. Kitosin avong koa kei heanian ka hemun hati uaen hevus ");
INSERT INTO pma_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","ka kilei revi out koa kei va matil ien. Navong matil ravobong, kiha vesesal veni, kikulat pulangit ran alen tanetan ka kimatil kat vase alen keilu vatie lati keke kovisi helei katuk ka usite keil onom. Hevus, kei hehiteni suk minuk asa kovoumoni.” ");
INSERT INTO pma_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Rut vit kesi mini vit, “Inau num vasi tounah koa koviteni minau moumoni.” ");
INSERT INTO pma_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Sakini, Rut va en out toumien onen Boas ka mumoni suval koa avu tisa viteni mini. ");
INSERT INTO pma_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Navong Boas kanian ka mun hati uaen evus, kei longe tahos. Evus, va vesesal en usite tai ten mari vangi bale koa arivini out tas ka va matil ien. Navong meten mulong houlu, Rut mul ka lelau mai, kulat pulangit ran vase alen tanetan ka matil kat keilu. ");
INSERT INTO pma_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","En metavinavong, Boas mutimanin ven tounah tai. Ka navong viles, lesi keke ahin tai mul matil kat vase alen tanetan. ");
INSERT INTO pma_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Sakini visi vit, “?Ei, keik sei?” Ka Rut vit kesi vit, “Inau etin, Rut, ahin toumien onom. Asuv, keik kovi tai en vatiamal onen meatin onak koa mat tuai. Sakini, musil sakien keil onami, keik kilei kat usite onak ka kokilea kovakur nau nimai nihi ahin onom.” ");
INSERT INTO pma_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Ka Boas vit kesi mini vit, “Rut, Iahova hetokol katuk. Komul korie lat sakien tetahos keil min vatiamal keil onomai koa marite mok mulin asa koa korie lati tuai min avu tisa onom koa vi vatina tai onomai. Keik, kokilea kovaha kovahotin etai meatin hau koa tounah onen houlu vuo koa tounah onen tovuol, ka kormumontei. ");
INSERT INTO pma_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Sakini, konandemtei nahi houlu usil asa koa hekistal. Inau num vasi tounah koa kovis inau eni keke nilei katuk ka usite keil onom veni kovi ahin tai koa meatin keil vasi alei kilea tahosien onom. ");
INSERT INTO pma_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Anatin keke inau navi kei koa helei kat usite onom veni navi vatiamal kati onen meatin onom koa mat. Ka meatin sav tamun mul en vatiamal onomai koa vesesal imok min meatin onom, ka kei kilea valamu enau keke vakur keik ka valei kat usite onom. Ka munak kei en rovattei, inau numoni suk. ");
INSERT INTO pma_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Ka en vongien enek, hetahos kitos. Hevus, out mulan, lehehotini keke en vati valei katuk vuo en rovattei. Munak en vati, tahosis, ka munak en rovattei, naviteni anatin en meten Iahova keke inau suk, nikuruk ka nilei kat revi usite keil onom. Ka vongien enek, kitos kimatil en out enek hetokol visokon.” ");
INSERT INTO pma_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Sakini, Rut matil kat vase alen tanetan rokol visokon. Ka en visokon semau veah, kei muli mea keke vaha veni Boas en rovattei meatin etai vailea keke ahin tai mul matil en out toumien onen. ");
INSERT INTO pma_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Ka mulamu en avong vaha, Boas viteni mini vit, “Kulat kot omom ka kihoeini en out enek.” Navong Rut vueni, Boas mutah uti bale keil koa kilo teni rokol hanumau tai ka halualim emun (30 kg) va ien. Evus, katauni lingi en eisilin ka Rut vousi va ris teim. Ka Boas va en meteimal. ");
INSERT INTO pma_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Navong Rut rokol teim sen, avu tisa onen visi vit, “?Ahineli, mukave?” Sakini Rut vit vasin tounah koa Boas viteni mini. ");
INSERT INTO pma_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Ka Rut viteni mun vit, “Ka en rovattei keke hek vahi heite hon navong mamai ris malesuk en out teim, sakini san uti bale keil koa kilo teni rokol hanumau tai ka halualim emun (30 kg) enek minau.” ");
INSERT INTO pma_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Noume vit risi mini vit, “Konandemkotei. Kitosini keke kiles tounah keil enek hekistal hemukave, veni Boas sakras vaseh kosa vatokol avong koa hetali mal en usite keil onom.” ");
INSERT INTO pma_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","En visokon enek, Boas va rondan en out tatondanien vesesal en metareh ten vieh ten meteimal ten out Betlehem. Evus, Boas les meatin koa viteni vit kei vi vesesal imok en meatin onen Rut mulin kei. Navong Boas lesi mul mual emai vali, vise vit, “Tuak, amai mau, tondan netan ekok.” Sakini, meatin enek mai veni ka rondan. ");
INSERT INTO pma_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Evus, Boas va vahotin hetetamen halualim (10) ten meteimal enek keke avamai avalong usite onealu. Navong keil vasi alah ruai, ");
INSERT INTO pma_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Boas viteni min tunali vit, “Noume koa mai ris ran kantri ten out Moab vit vasa lat atan onen Elimelek koa vi meatin onen min tai en vatiamal onen keke vahul lati rani. ");
INSERT INTO pma_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Ka inau namundemi navit mal keke nihit kilea minuk. Munak keik em vati, kokilea kovahul lati en meten koakeil arondan ekok. Ka munak em rovattei, kihiteni, veni keik kovi vesesal imok ven meatin onen Noume mulinau ka kokilea kovahuli lat atan enek helamu. Ka munak kirvultei, inau suk nihuli.” Ka meatin enek vit, “Vuo, inau nihul lati.” ");
INSERT INTO pma_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Evus, Boas viteni mini vit, “Tahos imok. Ka en avong koa kihul lat atan enek ran Noume, kikur vatina Rut emun koa vi ahin Moab. En sise enek, moeite onamil kilea vakur atan ka tounah sav keil onen meatin onen Rut koa mat tuai keke vatiamal onen sakras vavuol.” ");
INSERT INTO pma_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Navong meatin enek longe mukok, kei vit kesi mini vit, “Ven koanek, inau nirvultei atan koanek, veni nasakras masa lati min natkuli kati keil vahi one. Munak hehi en sise koanek, keik kos kihuli, inau ek rovattei mun.” ");
INSERT INTO pma_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","(En avong enek, sakien onen meatin keil mukok: navong keil e vati avahul atan tai, meatin koa atan onen hekulat usi sandel onen, ka hesani min koa kei vuli. Sakien koanek rie lati keke keilu luselus revi tuai avahul lat atan enek.) ");
INSERT INTO pma_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Sakini navong meatin enek mae lat atan enek min Boas keke vahuli, kei kulat sandel onen ka sani mini. ");
INSERT INTO pma_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Evus, Boas vitehiteni min hetetamen keil ka koakeil tateisav emun vit, “Kami vasi miles asa kur out kosa keke inau navul lat tounah vasi ran hen Noume koa vi onen Elimelek ka natnali keilu koa isealu Kilion ka Malon. ");
INSERT INTO pma_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Ka en usite tamun, nakur Rut emun koa vi ahin Moab koa retalihe ral min Malon mulamu keke vamai vahi ahin onak. Suval sakien orer, moei ehon onomal kilea hekur tounah vasi koa vi onen Malon. Koanek hesakin vatiamal onen Elimelek hervuoltei, keil iles ito hetal min komai en avong keil veah koa hemai. Kami vasi miles asa koa kur out kosa.” ");
INSERT INTO pma_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Hetetamen keil ka meatin tateisav keil emun aviteni mini avit, “Anatin, komai meles tounah keil koa kur out kosa. Mevisi keke Iahova houmon ahin enek koa hemai heto en teim som hemai hesuval Resel keilu Leah koa lukur ehon keil houlu onen avu Siekob koa umai avi mari vatiamal keil ten out Isrel. Ka en usite onom, mehis Iahova houmonuk kimai kihi hetetamen tai koa meatin keil koa akistal en mari vatiamal onen Efrat ihouhou mini. Anatin, mehis mini keke hesan eis tai minuk koa hehi hetetamen imok en meteimal ten out Betlehem. ");
INSERT INTO pma_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Mevis Iahova keke hesan ehon keil minuk koa heka en ahin hau enek koa hesakin amal onom hehi houlu hesuval vatiamal onen Peres, natin Sudah koa Tamar kuri.” ");
INSERT INTO pma_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Sakini, Boas kur Rut mai vi ahin onen ka Iahova rokol kati. Sakini kei meas en titiali, ka kuri vi meahos. ");
INSERT INTO pma_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Ahin keil aviteni min Noume avit, “!Rovahati lat isen Iahova! Kosa, kei san havmali tai valei kat usite onom navong komai kovi tovuli. Ehon enek hemai hehi hetamen tai en out Isrel. ");
INSERT INTO pma_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Ahineli onom, envatien onen enuk mariso mok. Tounah vasi keil koa kei mumoni minuk tahos imok mulin munak natmali keil onom avahi oulu (7). Ehon koa Rut kuri sakin moulien onom vi heite hau eris, veni navong kimai kihi tovuli revi, kei kilea valei kat revi keik.” ");
INSERT INTO pma_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Sakini, Noume kur tivava enek, kav kati ka rounat eni. ");
INSERT INTO pma_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Ahin keil koa aro vesesal ven keil umai aling isen tivava enek vi ‘Obed.’ Keil aviteni min meatin keil avit, “Titi ehon tai avasi ven Noume.” Navong moul mai mariso, Obed mai vi tata onen Tiese koa vi tata onen asuv houlu Deved. ");
INSERT INTO pma_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Ka koanek vi vatiamal koa kistal en Peres: Peres vi tata onen Hesron ");
INSERT INTO pma_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Hesron vi tata onen Ram koa vi tata onen Aminatap. ");
INSERT INTO pma_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Aminatap vi tata onen Nason koa vi tata onen Salmon. ");
INSERT INTO pma_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Salmon vi tata onen Boas koa vi tata onen Obed. ");
INSERT INTO pma_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Ka Obed vi tata onen Tiese koa vi tata onen asuv houlu Deved. ");
INSERT INTO pma_vpl VALUES ("S11_1","010_1_1","1SA","1","1","1","En avong tai, en taon ten out Ramah koa mul en vatihou keil koa vi en atan ten out Efrem, meatin tai ro en out enek, isen Elkanah. Kei vi natin Seroham, koa vi natin Elihu, koa vi natin Tohu, koa vi natin Sup, koa ka en mari vatiamal onen Efrem. ");
INSERT INTO pma_vpl VALUES ("S11_2","010_1_2","1SA","1","2","2","Elkanah retalihe ral min ahin elu, Hanah keilu Peninah. Peninah kur titiali keil ka Hanah sakras, vi lumalum. ");
INSERT INTO pma_vpl VALUES ("S11_3","010_1_3","1SA","1","3","3","En sua vasi keil, Elkanah ral min onen keil alokovein taon ten out Ramah ka avina en taon ten out Saeloh keke Elkanah vaha netan min ‘Iahova Sabaot’ koa aneite ten isen vi ‘Iahova, Asuv Houlu ten out nesa’ ka vasan sanien keil en usite ten onen keil mini. En out enek, pris elu lumul ien, isealu Hopni keilu Pinias koa luvi natin pris Ilae. ");
INSERT INTO pma_vpl VALUES ("S11_4","010_1_4","1SA","1","4","4","En avong keil vasi koa Elkanah san sanien onen, musil sakien teni, hatte sani min Iahova, hatte koa sani min pris keil, ka hatte koa mun vi an. Evus, koa an, kuri ka riti vasi min koakeil aro en teim sen. Min Peninah ka natnali ka natnahin keil, kei riti mal en keil vasi. ");
INSERT INTO pma_vpl VALUES ("S11_5","010_1_5","1SA","1","5","5","Ka koa sani min Hanah vi houlu mok, veni envatien onen mul ien mulin tateisav keil, avaseini keke Iahova ring koe keke herkurtei titiali. ");
INSERT INTO pma_vpl VALUES ("S11_6","010_1_6","1SA","1","6","6","Peninah vit kei tahos imok muli Hanah, sakini, mules selus katiati ka mumon karien mini veni Iahova mumoni vi lumalum. ");
INSERT INTO pma_vpl VALUES ("S11_7","010_1_7","1SA","1","7","7","Peninah mumoni mukok mini en sua vasi keil. Ka avong koa uva en Eim Tavolin onen Ahi, Peninah sakin Hanah longe tisa va vio … mis ka vit herkaniantei. ");
INSERT INTO pma_vpl VALUES ("S11_8","010_1_8","1SA","1","8","8","Ka avong koa meatin onen, Elkanah, lesi mukok, visi vit, “?Hanah, mukave? ?Komis vensa? ?Vensa kovit kirkaniantei? Kilonge hetahos e lahruaien oralu veni koanek tahos imok mulin munak ehon keil oralu avi houlu.” ");
INSERT INTO pma_vpl VALUES ("S11_9","010_1_9","1SA","1","9","9","En avong tai, uva Saeloh ka asan sanien one en Eim Tavolin onen Iahova. Ka avong koa akanian evus, Hanah mea ka va en Eim Tavolin keke vahis. En avong enek, pris Ilae mul rondan en out tatondanien onen vesesal ven voiteh ka lesi. ");
INSERT INTO pma_vpl VALUES ("S11_10","010_1_10","1SA","1","10","10","Hanah longe tisa houlu, ka navong mul vis min Ahi, simeten merahrah. ");
INSERT INTO pma_vpl VALUES ("S11_11","010_1_11","1SA","1","11","11","Hanah mumon hatkatien takeih tai keih ral min Ahi vit, “!O Iahova, Asuv Houlu ten Out Nesa, kilele ka kiles inau li koa navi ahin toumien onom! Kilele ka kiles mahien keil onak eli ka em hemahis inau li. !Em navobongentei nau li! Navat kati minuk keke munak kisan titiali tai koa hehi meahos minau, inau nisan risi minuk hehi meatin votut tai onom en moulien vasi onen. Ka nitie lati hehi anatin heka en usite koa mihersouitei hilen en moulien vasi onen ka hermuntei varei oai takeih keil.” ");
INSERT INTO pma_vpl VALUES ("S11_12","010_1_12","1SA","1","12","13","Hanah mul vis mukok tuetin ka selus raeng enges. Hiliongon mum ka selusien rokistaltei eni. Sakini, pris Ilae koa mul lei mamah kati mundemi keke Hanah munmun. ");
INSERT INTO pma_vpl VALUES ("S11_14","010_1_14","1SA","1","14","14","Sakini viteni mini vit, “?Kumon sakien ten munmunien enek heha vio hetokol nengeis? !Hevus kosa! !Kiseh en munmunien onom!” ");
INSERT INTO pma_vpl VALUES ("S11_15","010_1_15","1SA","1","15","15","Ka Hanah vit risi mini vit, “O hetamen, vuo, inau narmuntei uaen vuo oai takeih. Namul nalonge tisa, ka namul navis navit lat longtisaen keil onak min Iahova. ");
INSERT INTO pma_vpl VALUES ("S11_16","010_1_16","1SA","1","16","16","Konandemtei konahit inau navi ahin tisa tai. Namul navis mukok veni tinok mah ka nalonge tisa houlu.” ");
INSERT INTO pma_vpl VALUES ("S11_17","010_1_17","1SA","1","17","17","Sakini Ilae viteni mini vit, “Kiha hetal min tomat, ka namundesini keke Ahi ten out Isrel hesan asa koa keik kovisi veni.” ");
INSERT INTO pma_vpl VALUES ("S11_18","010_1_18","1SA","1","18","18","Hanah vit risi mini vit, “Namasmasuk. Ka kindemi hetahos minau li.” Navong lokoveini va, veinan viles, longe tahos, ka kanian esuk. ");
INSERT INTO pma_vpl VALUES ("S11_19","010_1_19","1SA","1","19","19","Out mulan visokon, Elkanah ral min onen keil amea ka uva en Eim Tavolin onen Ahi. Ka avong koa uva netan min Iahova evus, uva ris teim se en taon ten out Ramah. Avong vahis muli va, Elkanah va les Hanah, ka Iahova san ui hisien onen mini. ");
INSERT INTO pma_vpl VALUES ("S11_20","010_1_20","1SA","1","20","20","Sakini en avong mal teni, kei meas ka kuri vi meahos. Evus, ling isen vi ‘Samuel’ koa aneite teni vi ‘navis Ahi veni,’ veni viteni vit, “Inau navis Iahova veni.” ");
INSERT INTO pma_vpl VALUES ("S11_21","010_1_21","1SA","1","21","21","Evus, en avong koa mal teni, Elkanah ka onen keil asak mesein keil keke iha ris en taon ten out Saeloh avasan sanien one keil koa amumoni avong tai en sua vasi. Ka Elkanah vit vasan sanien tai mun koa vat kati min Iahova. ");
INSERT INTO pma_vpl VALUES ("S11_22","010_1_22","1SA","1","22","22","Ka en avong enek, Hanah rovatei ka viteni min meatin onen vit, “En avong koa ehon enek helokovein susu omon, inau nikuri suk ka nisani min Iahova hehi Meatin Votut tai onen, ka hetos en Eim Tavolin onen Iahova. Hermaitei mun teim.” ");
INSERT INTO pma_vpl VALUES ("S11_23","010_1_23","1SA","1","23","23","Elkanah vit risi mini vit, “Tahosis. Kumoni hesuval koa komundemi. Kitos en teim heha hetokol avong koa titiali onom helokovein susu omon. Navis keke Iahova hekataunuk kovoumon asa koa kovat kat mini.” Sakini Hanah ro nges teim, ka rounat en ehon onen. ");
INSERT INTO pma_vpl VALUES ("S11_24","010_1_24","1SA","1","24","24","Sua vahis muli, ka ehon koanek ling susu omon. Sakini, mama onen kuri luva Saeloh ral min buluk tai koa meahos koa sua onen etel, bak pulaoa tai, ka veiuaen tai koa marite. Hanah kuri va en Eim Tavolin onen Iahova en out Saeloh, avaseini keke kei vi titi ehon enges. ");
INSERT INTO pma_vpl VALUES ("S11_25","010_1_25","1SA","1","25","25","Elkanah ral min Hanah lumuas buluk koanek ka lusani min Iahova. Evus, lukur titi ehon onealu ka lusa lati min pris Ilae. ");
INSERT INTO pma_vpl VALUES ("S11_26","010_1_26","1SA","1","26","26","Ka Hanah viteni mini vit, “?Keik kolei kilea nau? Anatin eli, inau etin koles nau namulomal ekok ka namul navis. ");
INSERT INTO pma_vpl VALUES ("S11_27","010_1_27","1SA","1","27","27","Navis Iahova ven ehon koanek, ka kei san ui hisien onak. ");
INSERT INTO pma_vpl VALUES ("S11_28","010_1_28","1SA","1","28","28","Sakini, kosa namul nasan risi mini, ka hel houm min Iahova en moulien vasi onen.” Evus, keitel telva netan min Iahova en out enek. ");
INSERT INTO pma_vpl VALUES ("S12_11","010_2_11","1SA","2","11","11","Evus, Elkanah keitel telva ris teim en taon ten out Ramah. Ka Samuel, kei ro nges en taon ten out Saeloh ka mul mum min Iahova suval eiloheh onen pris Ilae. ");
INSERT INTO pma_vpl VALUES ("S12_19","010_2_19","1SA","2","19","19","Ka en sua keil vasi, mama onen rili eisin tamuoh hau tai onen Samuel suval koa pris keil amusin eni. Ka avong koa musil meatin onen luva keke iha netan min Iahova ka avasan sanien one mini, Hanah kur eisin enek ka sani mini. ");
INSERT INTO pma_vpl VALUES ("S12_20","010_2_20","1SA","2","20","20","Ka avong koa Ilae les Elkanah keilu Hanah, san tokolkatien tai min keilu ka viteni min Elkanah vit, “Navisi keke Iahova hesan ehon sav keil emun minuk heka en ahin koanek keke keil ikur vulin ehon koa milsani mini.” Evus, Elkanah ka onen keil uva ris teim se. ");
INSERT INTO pma_vpl VALUES ("S12_21","010_2_21","1SA","2","21","21","Ka Iahova san heite ten hisien koanek en usite onen Hanah, ka maeni kur ehon etel emun ka atouli elu. Ka Samuel mul moul ka mul mum en Eim Tavolin onen Iahova. ");
INSERT INTO pma_vpl VALUES ("S12_26","010_2_26","1SA","2","26","26","Ka avong koa Samuel mul moul, aven mai keih ka Iahova ral min meatin keil asi keil veni. En Eim Tavolin onen Ahi, natin pris Ilae keilu luvi pris. Ka keilu lumul lumum tisa houlu en meten Ahi, ka pris Ilae roring koetei sakien tatisa keil onealu. Sakini en avong tai, Ahi sila provet tai va ven Ilae koa viteni mini vit, “Ven koa korring koetei ehon onom keilu ven sakien keil koa tisa, Iahova hou vasi keilu luhemat en avong hetas. Ka vatiamal keil vasi onom imatmat navong avi meatin hau veah.” ");
INSERT INTO pma_vpl VALUES ("S13_1","010_3_1","1SA","3","1","1","En avong keil enek, avong koa Samuel mul mum min Iahova en hen pris Ilae, Ahi roselus ramattei min meatin keil ka rosantei leisanien keil vahi houlu. ");
INSERT INTO pma_vpl VALUES ("S13_2","010_3_2","1SA","3","2","2","Ka en vongien tai, pris Ilae mul matil en out tamatilien onen, ka vesesal meten vavar. ");
INSERT INTO pma_vpl VALUES ("S13_3","010_3_3","1SA","3","3","3","Ka Samuel, kei mul matil neim en Eim Tavolin onen Iahova, vesesal en out koa Bokis ten Hatkatien Takeih onen Ahi mul ien. Ka laet onen Ahi koa mul en eim enek mules mukan veni out romulantei veah. ");
INSERT INTO pma_vpl VALUES ("S13_4","010_3_4","1SA","3","4","4","En vongien enek, Iahova vise Samuel vit, “!Samuel, Samuel!” Ka kei vit risi mini vit, “!O-o!” ");
INSERT INTO pma_vpl VALUES ("S13_5","010_3_5","1SA","3","5","5","Evus, muloh va ven pris Ilae ka visi vit, “?Mukave? ?Keik keke kovise nau? Inau eke.” Ka pris Ilae viteni mini vit, “Vuo. Inau narvisoktei. Kiha ris kimatil.” Sakini, Samuel va ris ka matil. ");
INSERT INTO pma_vpl VALUES ("S13_6","010_3_6","1SA","3","6","6","Evus, Iahova vise Samuel hatte tamun, ka kei mea ka va ris ven Ilae ka visi vit, “?Keik keke kovise nau? Inau eke.” Ka pris Ilae vit risi mini vit, “Natkuli, inau narvisoktei. Kiha ris kimatil.” ");
INSERT INTO pma_vpl VALUES ("S13_7","010_3_7","1SA","3","7","7","Samuel reingeingeni keke Iahova mul vise veni roselustei veah mini. ");
INSERT INTO pma_vpl VALUES ("S13_8","010_3_8","1SA","3","8","8","Ka, hatte etel eni, Iahova vise ris Samuel. Sakini, Samuel mea, va ris ven Ilae ka visi vit, “?Keik keke kovise nau? Inau eke.” Ka pris Ilae mundem kilea keke Iahova varei keke mul vise ehon koanek. ");
INSERT INTO pma_vpl VALUES ("S13_9","010_3_9","1SA","3","9","9","Sakini, kei viteni mini vit, “Kiha ris kimatil. Ka munak kilong rea koanek koa mul visok, kihiteni kihit, ‘Iahova, kiselus minau. Inau, meatin toumien onom, namul naraengonuk.’” Sakini, Samuel va ris en out tamatilien onen. ");
INSERT INTO pma_vpl VALUES ("S13_10","010_3_10","1SA","3","10","10","Evus, Iahova mai ris veni ka mulomal vesesal veni ka vise suval koa mumoni tuai vit, “Samuel, Samuel.” Ka Samuel vit, “O-o. Kiselus veni inau, meatin toumien onom, namul naraengonuk.” ");
INSERT INTO pma_vpl VALUES ("S13_11","010_3_11","1SA","3","11","11","Sakini, Iahova viteni mini vit, “Kilonge. Hervitei tuetin, inau numon tounah tai en meten me-Isrel keil koa hetisa revi mok. Hesakin meatin vasi keil koa ilonglong eni, e hehon. ");
INSERT INTO pma_vpl VALUES ("S13_12","010_3_12","1SA","3","12","12","En avong enek, num vasi tounah koa navat kati keke numoni heha kat pris Ilae ka meatin vasi keil ten vatiamal onen. Anatin, nasakras malokovein tai vales. ");
INSERT INTO pma_vpl VALUES ("S13_13","010_3_13","1SA","3","13","13","Inau naviteni tuai min pris Ilae keke nisan mahien enek min vatiamal keil onen koa keite teni hetovuol veni natnali keilu lumum tisa va kat nau en selusien ka sakien keil onealu. Pris Ilae kilea en tounah vasi koa lumumoni, ka roring koetei keilu. ");
INSERT INTO pma_vpl VALUES ("S13_14","010_3_14","1SA","3","14","14","Sakini, navat kati keih min Ilae ka koakeil akistal en vatiamal onen keke nasakras moumon methos onak vatal min keil, avaseini munak asan buluk vuo sipsip keil avahi sanien votut one minau, vuo etai mun tounah.” ");
INSERT INTO pma_vpl VALUES ("S13_15","010_3_15","1SA","3","15","15","Navong Iahova selus mini evus, Samuel mules en out tamatilien onen rokol visokon. Evus, mea seh voiteh ten Eim Tavolin onen Iahova. Kei en rovattei vaha ven Ilae veni metau vatun usil leisanien onen mini. ");
INSERT INTO pma_vpl VALUES ("S13_16","010_3_16","1SA","3","16","16","Ka Ilae vise vit, “Natkuli Samuel, amai ekok.” Emai veni ka viteni vit, “?O-o, kovise nau?” ");
INSERT INTO pma_vpl VALUES ("S13_17","010_3_17","1SA","3","17","17","Ka Ilae visi vit, “?Iahova viten sa minuk? Konaling suaintei tounah ranau. Hemukonek, Ahi hesan mahien heha katuk hekeih munak kirvit vasitei tounah koa kei viteni minuk minau.” ");
INSERT INTO pma_vpl VALUES ("S13_18","010_3_18","1SA","3","18","18","Sakini, Samuel vit vasin tounah mini, roling suain etai tounah rani. Ka navong longe, Ilae viteni vit, “Kei vi Iahova. Tahosis keke houm housil asa koa kei lesi vit mal.” ");
INSERT INTO pma_vpl VALUES ("S13_19","010_3_19","1SA","3","19","19","Navong Samuel mul moul, Iahova ro veni ka mumon tounah vasi koa kei viteni ka en Samuel mai vi anatin. ");
INSERT INTO pma_vpl VALUES ("S13_20","010_3_20","1SA","3","20","20","Sakini, me-Isrel keil vasi, koakeil ten out Dan, koa mul en usite tai ten kantri one, va rokol taon ten out Bersiba en usite sav, keil akilea keke Samuel vi provet anatin onen Iahova. ");
INSERT INTO pma_vpl VALUES ("S13_21","010_3_21","1SA","3","21","21","Sakini, en taon ten out Saeloh, Iahova mules kistal ven Samuel ka mul selus ral mini. Ka kei vit meseini min me-Isrel vasi keil. ");
INSERT INTO pma_vpl VALUES ("S18_1","010_8_1","1SA","8","1","1","Navong Samuel mai vi ulmatu, kei ling natnali keilu keke luvalei revi usite onen meatin keil ka luvasak revi titi vaeen keil onen me-Isrel keil. ");
INSERT INTO pma_vpl VALUES ("S18_2","010_8_2","1SA","8","2","2","Moeite onen, isen Soel, ka koa katau, isen Abitsa. Keilu lumum en taon ten out Bersiba. ");
INSERT INTO pma_vpl VALUES ("S18_3","010_8_3","1SA","8","3","3","Ka keilu luviles eisilealu ran sakien tetahos onen tata onealu. Keilu luvi uti mani enges, ka lumaen meatin keil avahul keilu vakataun usite one en kot navong lusak revi usite onen meatin keil. ");
INSERT INTO pma_vpl VALUES ("S18_4","010_8_4","1SA","8","4","4","Sakini, hetetamen keil onen me-Isrel keil alah ruai en taon ten out Ramah keke avaha avales provet Samuel. ");
INSERT INTO pma_vpl VALUES ("S18_5","010_8_5","1SA","8","5","5","Keil aviteni mini avit, “Samuel, keik komai kovi ulmatu ke. Ka natmali keilu, lurmusil revitei sakien tetahos keil onom. Ven koanek, komai memundemi keke hetahos kitie lat asuv houlu tai keke helosil kat komai hesuval kantri sav keil.” ");
INSERT INTO pma_vpl VALUES ("S18_6","010_8_6","1SA","8","6","6","Ka navong umai ka avisi keke vatie lat asuv houlu tai valosil kat keil, Samuel lesi romaltei, sakini va vis min Iahova veni. ");
INSERT INTO pma_vpl VALUES ("S18_7","010_8_7","1SA","8","7","7","Iahova viteni mini vit, “Samuel, kum usil asa koa meatin keil amul avisuk eni. Veni keil arseseinuktei, amul aseseinau enges keke nirvitei mun asuv houlu one. ");
INSERT INTO pma_vpl VALUES ("S18_8","010_8_8","1SA","8","8","8","Kosa, meatin keil enek amul amumoni minau suval koa amumoni minau en avong mulamu. Navong nalah lat keil ran out Isip rokol kosa, amul aviles eisile ranau ka uva netan min ahi sav keil. ");
INSERT INTO pma_vpl VALUES ("S18_9","010_8_9","1SA","8","9","9","Sakini, kiha, kusil rendemien keil one. Ka kisel kat keil hekeih imok ka kihit kilea min keil sakien takeih keil onen asuv houlu koa hemai helosil kat keil.” ");
INSERT INTO pma_vpl VALUES ("S18_10","010_8_10","1SA","8","10","10","Evus, Samuel va ka vit vasin tounah koa Iahova viteni mini min meatin keil koa avisi valing asuv houlu tai vahi one. ");
INSERT INTO pma_vpl VALUES ("S18_11","010_8_11","1SA","8","11","11","Kei vit kilea min keil vit, “Koanek hehi sakien keil onen asuv houlu koa hemai helosil kat kami. Kei hemai hekur ehon keil iha ivae en usite onen: tei en keil iloh en hos osen keil, tei en keil iloh en kat tavaeen keil onen koa hos mul lehei, ka tei mun en keil ihi meatin taleikokoeien keil onen koa heloh helamu en kat keil onen. ");
INSERT INTO pma_vpl VALUES ("S18_12","010_8_12","1SA","8","12","12","Asuv houlu enek hesakin tei en keil imai ihi avat keil avalosil kat vangi meatin keil tavaeen koa meatin keil hanumau elu ka halualim emun (50) amul ien. Ka tei mun en keil, ihi avat keil avalosil kat vangi meatin keil tavaeen koa meatin keil taosen tai (1000) amul ien. “Kei hekur tei mun en ehon keil onami keke um mini en mari ah esen keil. Keil ikah atan esen, ka hevus, isuhut en anien teni hehi an. Keil umon kat talohien onen ral min tounah vasi keil tavaeen onen emun. ");
INSERT INTO pma_vpl VALUES ("S18_13","010_8_13","1SA","8","13","13","Kei hekur atouli keil onami emun keke iha um mini. Keil umon senta keil onen, anien an, ka itan veret an. ");
INSERT INTO pma_vpl VALUES ("S18_14","010_8_14","1SA","8","14","14","“Kei hekur more atan onami hetal min nei grep keil osami ka nei olip keil emun. Hevus, hesani suk min hetetamen keil onen koa amum en teim sen. ");
INSERT INTO pma_vpl VALUES ("S18_15","010_8_15","1SA","8","15","15","Kei helah taet ten anien ka grep keil osami keke hetiti min hetetamen keil onen ka min meatin toumien keil onen emun. ");
INSERT INTO pma_vpl VALUES ("S18_16","010_8_16","1SA","8","16","16","Kei hekur slev keil onami hetal min mormore buluk ka dongki osami keil keke imai ihi onen. ");
INSERT INTO pma_vpl VALUES ("S18_17","010_8_17","1SA","8","17","17","Kei helah lat tei en sipsip ka nani osami keil hesuval takis vasakini imai ihi osen. Ka houmon kami mun mihemai mihoum mini suval mihehi slev keil onen enges. ");
INSERT INTO pma_vpl VALUES ("S18_18","010_8_18","1SA","8","18","18","Ka navong avong keil enek hemai, kami miheis minau keke mivamea ran sakien takeih koa asuv houlu enek mul mumoni min kami, asuv houlu koa kami enges mipeah Ahi ven. Ka Iahova en hervattei vailea en uaien keil onami.” ");
INSERT INTO pma_vpl VALUES ("S18_19","010_8_19","1SA","8","19","19","Ka meatin keil amundem maen selkatien onen Samuel. Keil aviteni avit, “Avaseini hemukonek, ka komai emai vati mok keke asuv houlu helosil kat komai. ");
INSERT INTO pma_vpl VALUES ("S18_20","010_8_20","1SA","8","20","20","Hesakini, komai mehemai mehesuval kantri sav keil koa asuv houlu mul helosil kat komai ka helamun komai meheha en vaeen keil.” ");
INSERT INTO pma_vpl VALUES ("S18_21","010_8_21","1SA","8","21","21","Navong Samuel long asa koa meatin keil aviteni, va ka vit meseini min Iahova. ");
INSERT INTO pma_vpl VALUES ("S18_22","010_8_22","1SA","8","22","22","Ka Iahova viteni mini vit, “Kiha kum hesuval koa keil e vati. Kiling asuv houlu tai one.” Sakini, Samuel va ka vit meseini min me-Isrel keil. Evus, sila keil uva ris teim se. ");
INSERT INTO pma_vpl VALUES ("S19_1","010_9_1","1SA","9","1","1","En mari vatiamal onen Bensamin, hetamen tai mul ien koa tounah onen houlu, isen Kis. Tamen, isen Apiel, natin Seror. Ka Seror, kei vi natin Bekorat, natin Afia. ");
INSERT INTO pma_vpl VALUES ("S19_2","010_9_2","1SA","9","2","2","Kis, natnali mul, isen Sol. Ka Sol, kei vi vati meatin tai koa meatin sav keil alesi tahos imok mulin meatin hau sav keil ten out Isrel veni kei taveah ka veinan tahos vis tahos imok. ");
INSERT INTO pma_vpl VALUES ("S19_15","010_9_15","1SA","9","15","15","En avong tai, Sol vit vahita en taon ten out Ramah. Ka mulamu en avong koa kei vahita, Iahova kistal min Samuel ka viteni mini vit, ");
INSERT INTO pma_vpl VALUES ("S19_16","010_9_16","1SA","9","16","16","“Visuvong, en hati avong enek, inau nisila meatin tai hehita venuk koa ka en out koa me-Bensamin keil amul ien. Kei varei narie lati. Sakini, kitah oel en vatin vatie lati keke kei hemai hehi avat houlu koa valosil kat meatin onak keil ten out Isrel. Kei houtut keil imea ran hen me-Filistia keil veni inau nales mahien keil one ka nalong tangien keil one.” ");
INSERT INTO pma_vpl VALUES ("S19_17","010_9_17","1SA","9","17","17","Ka navong Samuel les Sol, Iahova viteni mini vit, “Meatin koa naviteni minuk, keie. Kei varei helosil kat meatin keil onak.” ");
INSERT INTO pma_vpl VALUES ("S110_1","010_10_1","1SA","10","1","1","Navong Sol mai veni, Samuel kur oel ka mutahi en vatin. Evus, ling hen eni ka viteni vit, “Kosa, Iahova rie latuk keke kimai kihi asuv houlu kilosil kat meatin keil onen ka kiting koe keil ran vativieh keil one.” ");
INSERT INTO pma_vpl VALUES ("S110_17","010_10_17","1SA","10","17","17","Katau en tounah enek, Samuel vise ruain me-Isrel keil keke avahisu min Iahova en out lou ten out Mispah. ");
INSERT INTO pma_vpl VALUES ("S110_18","010_10_18","1SA","10","18","18","Navong umai out tas, kei viteni min keil vit, “Iahova, Ahi onen me-Isrel keil, mul viteni min kami vit, ‘Inau nges, nalah lat kami ran atan ten out Isip ka ran he. Ka navong meatin keil ten kantri sav keil amum keih en kami, inau nalah lat kami ran he emun. ");
INSERT INTO pma_vpl VALUES ("S110_19","010_10_19","1SA","10","19","19","Inau navi Ahi onami koa mul mutut kami ran mahien keil onami ka avong takeih keil emun. Ka kosa, misesein losilkatien onak ka mivis nau masan asuv houlu tai min kami. Mukonek, almai, mihelomal ekok en metok housil mari vatiamal keil onami. Evus, mihetiti vas kami housil titi amal keil koa mika ien.’” Sakini, Iahova viteni min Samuel keke hehotin asuv houlu onen me-Isrel keil en sakien koa aleh isen meatin eni. Ka Samuel mumoni en mari vatiamal keil, ka leh isen vatiamal onen Bensamin. Mumoni min titi amal keil, min famle keil ka min meahos keil emun ten famle koanek va vio … Samuel leh isen Sol. Ka navong uva avalekati Sol, avotini ro suai en out koa meatin keil aling ateli one ien veni kei metau. ");
INSERT INTO pma_vpl VALUES ("S110_24","010_10_24","1SA","10","24","24","Evus, Samuel mulamun Sol va mulomal luhu en meatin keil ka viteni min keil vit, “Meatin koanek vi kei koa Iahova rie lati keke vahi houlu valosil kat kami. Meatin tovuol emun en kami vasuval kei.” Navong alesi, meatin vasi keil avisohiso keih avit, “!Kei vi asuv houlu onomai, losilkatien onen hel hetaveah!” Navong Sol mai vi asuv houlu onen me-Isrel keil, sua onen vi hanumau tai ka halualim emun (30). Ka me-Isrel keil koa arsitei keil ven hiasuvien onen ka asel kutut kati. Ka kei vise ruai meatin tavaeen keil ten out Isrel ka mulamun keil uva avavae vatal min me-Amon keil ka amu lin keil. Sakini, me-Isrel vasi keil asi keil suk ven hiasuvien onen. ");
INSERT INTO pma_vpl VALUES ("S111_14","010_11_14","1SA","11","14","14","Ka provet Samuel viteni min keil vit, “Rovaha en out Kilkal vatie lati keke Sol vi asuv houlu orer anatin.” ");
INSERT INTO pma_vpl VALUES ("S111_15","010_11_15","1SA","11","15","15","Sakini, keil vasi uva Kilkal. Ka en out enek, keil uva netan min Iahova, ka avati lat Sol mai vi asuv houlu one. Evus, amuas buluk ka sipsip keil ka amunit keil en ahor ten sanien. Ka ral min vuseri tei ten sanien votut keil enek, Sol kanian ruai ral min me-Isrel keil, ka keil vasi asi keil. ");
INSERT INTO pma_vpl VALUES ("S113_13","010_13_13","1SA","13","13","13","Navong Samuel kistal ka lesi keke Sol mumon sanien votut tuai, kei selus keih mini vit, “!Ei, komumon tounah hit kovi varu! Keik kormusiltei mengkatien keil onen Iahova koa vi Ahi onom. Munak kovousil mengkatien keil onen, kei vamaenuk ka natmali keil koa ikistal ika enuk keke mivalosil kat me-Isrel keil heha vio … keite teni hetovuol. ");
INSERT INTO pma_vpl VALUES ("S113_14","010_13_14","1SA","13","14","14","Ka kosa, losilkatien onom mai rokol keite teni veni kormusiltei selusien onen. Sakini, Iahova ling kati keke hehotin meatin etai koa rendemien ka envatien keil onen housil kat rendemien ka envatien onen. Vati meatin enek, Iahova helingi helosil kat meatin keil onen.” ");
INSERT INTO pma_vpl VALUES ("S113_15","010_13_15","1SA","13","15","15","Evus, Samuel lokovein Sol en out Kilkal ka musil sise va. ");
INSERT INTO pma_vpl VALUES ("S115_1","010_15_1","1SA","15","1","1","Avong sav tai, Samuel va ven Sol ka viteni mini vit, “Mulamu, Iahova sila nau matokol katuk keke kovamai kovahi asuv houlu onen meatin keil onen. Sakini, kosa, kitaengonau mahit mesein asa koa en vati vahiteni minuk. ");
INSERT INTO pma_vpl VALUES ("S115_2","010_15_2","1SA","15","2","2","Iahova, Asuv Houlu ten out nesa, hesan mahien min me-Amelek keil veni avu one keil uvae ral min me-Isrel keil navong alokovein out Isip umai. ");
INSERT INTO pma_vpl VALUES ("S115_3","010_15_3","1SA","15","3","3","Miheha mihevae hetal min me-Amelek keil ka mihou lin tounah vasi keil one. Mihou vinvini meatin vasi keil: amo keil ka ahin keil, titiali keil ka tivava keil one emun. Mihou vinvini buluk, sipsip, kamel ka dongki keil ose. Mihouas keil vasi, miherling etai tounah hemoul.” ");
INSERT INTO pma_vpl VALUES ("S115_4","010_15_4","1SA","15","4","4","Sakini, Sol vise ruain meatin keil onen koa avinvin avaha avavae, ka umai out tas en taon ten out Telaim. Ka navong avuli meatin keil, avotini keke me-Isrel keil arokol handred taosen elu (200,000), ka me-Sudah keil arokol taosen halualim (10,000). ");
INSERT INTO pma_vpl VALUES ("S115_7","010_15_7","1SA","15","7","7","Navong Sol ka meatin keil onen uvae ral min me-Amelek keil, amu vinvini keil varei, en taon ten out Havila va rokol taon ten out Sur koa mul en hakot ten atan ten out Isip. ");
INSERT INTO pma_vpl VALUES ("S115_8","010_15_8","1SA","15","8","8","Keil amu vasi meatin keil, ka asuv houlu one koa isen Akak, avuli kati ka armuastei vamat, moul enges. ");
INSERT INTO pma_vpl VALUES ("S115_9","010_15_9","1SA","15","9","9","Anatin, Sol ka meatin keil onen armu vinitei asuv houlu Akak. Ka sipsip ka buluk keil koa ave tahos, ka titae keil emun koa ave musising, armu vinvinitei keil. Ka navong ales tounah tai koa tahos imok, alahi veni e rovattei avapuruni. Ka tounah keil koa alesi rotahostei vuo romaltei, amu rasilini. ");
INSERT INTO pma_vpl VALUES ("S115_10","010_15_10","1SA","15","10","10","Ka Iahova selus min Samuel vit, ");
INSERT INTO pma_vpl VALUES ("S115_11","010_15_11","1SA","15","11","11","“Nalonge tisa houlu keke namumon Sol mai vi asuv houlu, veni kei viles eisilin ranau ka romusiltei selusien keil onak.” Navong Samuel raengon tounah enek, longe tisa houlu ka mules vis min Iahova va vio … out mulan. ");
INSERT INTO pma_vpl VALUES ("S115_12","010_15_12","1SA","15","12","12","En visokon semau, Samuel va lei kat Sol. Navong mul semau mual en sise, raengoni keke Sol mul en taon ten out Karmel ka kei ling mari ahat tai vahi metai keke meatin keil indem kat keihoen onen en avong ten vaeen keil. Ka navong mul mual va, longe suk keke Sol va en out Kilkal. ");
INSERT INTO pma_vpl VALUES ("S115_13","010_15_13","1SA","15","13","13","Sakini, Samuel va en out Kilkal ka votin Sol ien. Ka navong Sol lesi, mai veni ka viteni mini vit, “!Samuel, Iahova hetokol katuk. Inau namum vasi tounah koa kei meng kat inau keke moumoni.” ");
INSERT INTO pma_vpl VALUES ("S115_14","010_15_14","1SA","15","14","14","Ka Samuel visi vit, “?Munak koanek anatin, vensa namul naraengon buluk keil amis ka sipsip keil uver?” ");
INSERT INTO pma_vpl VALUES ("S115_15","010_15_15","1SA","15","15","15","Sol vit kesi mini vit, “Meatin onak keil alah lati ran me-Amelek keil. Keil aling revi sipsip ka buluk keil koa ave tahos keke avasani min Iahova, Ahi onom. Ka teisav keil, memu lin keil.” ");
INSERT INTO pma_vpl VALUES ("S115_16","010_15_16","1SA","15","16","16","Samuel vul kati vit, “!Kito raeng! Ka inau nihit meseini minuk asa koa Iahova viteni minau en vongien.” Ka Sol vit, “Tahos. Hiteni minau.” ");
INSERT INTO pma_vpl VALUES ("S115_17","010_15_17","1SA","15","17","17","Ka Samuel vit risi mini vit, “Avaseini keke, mulamu, kolei heisav enuk, kosa, komai kovi avat ten vatiamal keil vasi onen me-Isrel keil. Iahova keke rie latuk kumai kovi asuv houlu onen me-Isrel keil. ");
INSERT INTO pma_vpl VALUES ("S115_18","010_15_18","1SA","15","18","18","Ka kei silak kovoumon umen onen. Kei en vati keik kovou vasi meatin tisa keil ten out Amelek. Viteni minuk vit kilamun meatin keil onom miheha mihevae heha vio … mihou vinvini keil vasi. ");
INSERT INTO pma_vpl VALUES ("S115_19","010_15_19","1SA","15","19","19","?Munak koanek anatin, vensa korlong kattei selusien onen? ?Vensa kokalah kolah ruain tounah vasi one koa tetahos? !En meten Iahova, asa koa komumoni tisa vareis!” ");
INSERT INTO pma_vpl VALUES ("S115_20","010_15_20","1SA","15","20","20","Ka Sol viteni mini vit, “Anatin eli, inau nalong kat selusien onen Iahova. Nuva suval koa viteni minau, namu vinvini meatin keil vasi ten out Amelek ka navuli kat asuv houlu Akak ka nakuri emai ekok. ");
INSERT INTO pma_vpl VALUES ("S115_21","010_15_21","1SA","15","21","21","Ka meatin keil onak armu vinvinitei sipsip ka buluk keil ose koa atahos. Keil e vati avalah keil vamai ekok, en taon ten out Kilkal, keke avasani min Iahova, Ahi onom.” ");
INSERT INTO pma_vpl VALUES ("S115_22","010_15_22","1SA","15","22","22","Ka Samuel viteni mini vit, “?Asa varei keke Iahova en vati mok? ?Longkatien vuo sanien keil? Munak rolong kat selusien keil onen, koanek tahos imok mulin buluk ka sipsip keil koa romuas keil, ka sanien votut sav keil koa rosani mini. ");
INSERT INTO pma_vpl VALUES ("S115_23","010_15_23","1SA","15","23","23","En meten, navong komul kosesein hiasuvien onen, tisaen enek suval tisaen ten lingling temat. Ka sakien ten vatkeih suval sakien koa uva netan min nana keil. Sakini, veni kosesein selusien onen Iahova, kei mun mul sesein losilkatien onom en me-Isrel keil.” ");
INSERT INTO pma_vpl VALUES ("S115_27","010_15_27","1SA","15","27","27","Navong Samuel selus evus, viles keke vaha. Ka Sol longe tisa houlu ka vuli kat eisin omon ka rali vasi. ");
INSERT INTO pma_vpl VALUES ("S115_28","010_15_28","1SA","15","28","28","Navong Samuel lesi, viteni min Sol vit, “Suval koa komumoni en eisin omak, kosa, Iahova rali vas losilkatien onom en me-Isrel keil va ranuk, ka hesani min tai en tumali keil koa kei lesi tahos imok mulik. ");
INSERT INTO pma_vpl VALUES ("S115_29","010_15_29","1SA","15","29","29","Iahova ten lisenges onen me-Isrel keil sakras vahiles rendemien onen. Anatin, kei rosuvaltei meatin keil koa amul aluvos ka amul aviles rendemien one.” ");
INSERT INTO pma_vpl VALUES ("S115_34","010_15_34","1SA","15","34","34","Sakini, Samuel va ris en out Ramah, ka asuv houlu Sol va ris va teim sen en out Kibea. ");
INSERT INTO pma_vpl VALUES ("S115_35","010_15_35","1SA","15","35","35","Ka avong enek va rokol keite ten moulien onen Samuel, rolestei mun Sol. Ka avong vasi, kei longe tisa houlu veni. Ka Iahova emun longe tisa houlu veni kei varei rie lat Sol vamai vahi asuv houlu onen me-Isrel keil. ");
INSERT INTO pma_vpl VALUES ("S116_1","010_16_1","1SA","16","1","1","En avong tai, Iahova kistal min Samuel ka viteni mini vit, “?Kiles kilonge hetisa ven Sol heha vio … hevus nengeis? Inau naseseini tuai keke hervitei mun asuv houlu onen me-Isrel keil. Sakini, kosa, kikur oel ka kiha en taon ten out Betlehem. En out enek, kihisu min meatin tai, isen Tiese, veni narie lat natnali tai tuai vamai vahi asuv houlu onen meatin keil onak.” ");
INSERT INTO pma_vpl VALUES ("S116_2","010_16_2","1SA","16","2","2","Samuel visi vit, “?Numoni hemukave? Munak Sol hetaengoni, kei hemai houas inau nimat.” Ka Iahova vit kesi mini vit, “Kilamun buluk koa vi atahas hau hetal minuk, ka kihiteni keke kovoual kovaha en out ekek kovasan sanien votut tai vaha minau. ");
INSERT INTO pma_vpl VALUES ("S116_3","010_16_3","1SA","16","3","3","Evus, kisisil en Tiese keke hemai en sanien enek, ka inau nihiteni minuk asa kumoni. Meatin koa nitie minuk, kitah oel en vatin vatie lati keke kei hekes Sol hemai hehi asuv houlu.” ");
INSERT INTO pma_vpl VALUES ("S116_4","010_16_4","1SA","16","4","4","Sakini, Samuel mumon asa koa Iahova viteni mini ka va en out Betlehem. Ka navong hetetamen keil ten out enek alesi mul mai, umai vesesal veni ral metauen ka avisi avit, “?Provet, kumai kovahiten tounah koa tahos, vuo tounah koa tisa?” ");
INSERT INTO pma_vpl VALUES ("S116_5","010_16_5","1SA","16","5","5","Ka vit kesi min keil vit, “Numai en rendemien koa tahos masan sanien votut tai vaha min Iahova. Sakini, miheha mihesak motein kami mivato. Hevus, mihemai ris.” Evus, sisil en Tiese ka natnali keil umai veni voumon keil avato keke iha en sanien votut koa houmoni. ");
INSERT INTO pma_vpl VALUES ("S116_6","010_16_6","1SA","16","6","6","Navong Tiese ka natnali keil umai akistal veni, Samuel meten rei navong les moeite, koa isen Eliab, ka mundem sasen eni vit, “Anatin eli, meatin koa mulomal ekek, kei varei Iahova rie lati.” ");
INSERT INTO pma_vpl VALUES ("S116_7","010_16_7","1SA","16","7","7","Ka Iahova viteni mini vit, “Vuo, inau nalei sesein koanek. Konandemtei usil aven meatin, koa taveah mukave vuo veinan tahos mukave. Inau narlei kantei meatin vasuval meatin keil ten out netan. Meatin keil amul ales aven meatin keil enges, ka inau, nalei kirisil va en rendemien onen.” ");
INSERT INTO pma_vpl VALUES ("S116_10","010_16_10","1SA","16","10","10","En sise enek, Tiese lah natnali keil koa avi oulu (7) ka rie keil min Samuel. Ka Samuel viteni mini vit, “Vuo, Iahova rorie lat etai koakeil ekek.” ");
INSERT INTO pma_vpl VALUES ("S116_11","010_16_11","1SA","16","11","11","Evus, visi vit, “?Keil vasi keiek?” Tiese vit risi mini vit, “Tai koa vi tasikor, kei mul losil kat sipsip keil osak enges.” Ka Samuel viteni mini vit, “San selusien vaha mini vamai. Rehertotantei hetokol kei hemai.” ");
INSERT INTO pma_vpl VALUES ("S116_12","010_16_12","1SA","16","12","12","Sakini, Tiese sila meatin tai va vahiteni mini vamai. Navong emai, Samuel lesi keke vi litetai tai koa aven malekuh ka veinan tahos. Ka Iahova viteni min Samuel vit, “!Kei varei! Mea kitah oel en vatin vatie lati keke kei hemai hehi asuv houlu hau onen me-Isrel keil.” ");
INSERT INTO pma_vpl VALUES ("S116_13","010_16_13","1SA","16","13","13","Sakini provet Samuel kur oel ka mutahi en vatin Deved en meten tunali keil. Hatte tas, ninin onen Iahova mai sien Deved ka mul katauni en avong enek va. Evus, provet Samuel mumon sanien votut onen va min Iahova, ka va ris teim onen en out Ramah. ");
INSERT INTO pma_vpl VALUES ("S116_14","010_16_14","1SA","16","14","14","Ka en asuv houlu Sol, Iahova kulat ninin onen rani, ka sa kes ninin tisa tai mini koa sakin metauen mul ien. ");
INSERT INTO pma_vpl VALUES ("S117_1","010_17_1","1SA","17","1","1","En avong enek, me-Filistia keil alah ruai keke avavae vatal min me-Isrel keil. Umai vesesal en taon ten out Sokah en atan onen koakeil aka en mari vatiamal onen Sudah. Keil amumon votevav keil ome en atan tai koa avise en Efes Damin koa mul luhu en taon ten out Sokah ka taon ten out Aseka. ");
INSERT INTO pma_vpl VALUES ("S117_2","010_17_2","1SA","17","2","2","Ka Sol ral min me-Isrel keil, keil emun alah ruai ka amumon votevav ome en Sesai Elah. En out enek, keil asak mesein keil keke avavae vatal min me-Filistia keil. ");
INSERT INTO pma_vpl VALUES ("S117_3","010_17_3","1SA","17","3","3","Me-Filistia keil amul en usi hou tai, ka me-Isrel keil amul en usi hou sav, ka sesai mul vas keilu. ");
INSERT INTO pma_vpl VALUES ("S117_4","010_17_4","1SA","17","4","4","Evus, meatin tavaeen tai ten out Kat kistal ran out koa me-Filistia keil amumon votevav ome ien, isen Kolaeot. Kei vi hetetamen imok en meatin tavaeen keil one ka taveah ramat, mulin mita etel (3). ");
INSERT INTO pma_vpl VALUES ("S117_8","010_17_8","1SA","17","8","8","Kolaeot mai mulomal ka visohiso keih va min me-Isrel keil vit, “?Vensa kami vasi misak mesein kami keke mivavae? Tahos imok keke kami mihetie lat etai en kami keke vamai vavae en usite onami, ka inau, nivae en usite onen me-Filistia keil. ");
INSERT INTO pma_vpl VALUES ("S117_9","010_17_9","1SA","17","9","9","Munak kei hevae helinau ka houas nau nimat, komai vasi mehemai mehehi slev keil onami. Ka munak inau, nivae nilin kei ka nouasi hemat, kami vasi suk mihemai mihehi slev keil onomai. ");
INSERT INTO pma_vpl VALUES ("S117_10","010_17_10","1SA","17","10","10","Kosa, nasan selusien koanik vat min kami meatin tavaeen onen me-Isrel keil: munak etai en kami mundemi keke kei vi ame, kei varei hemai melhevae.” ");
INSERT INTO pma_vpl VALUES ("S117_11","010_17_11","1SA","17","11","11","Navong Sol ka meatin keil onen alonge mukok, ametau houlu. ");
INSERT INTO pma_vpl VALUES ("S117_13","010_17_13","1SA","17","13","13","Natin Tiese etel koa telmulamu en keil, telva telmusil meatin tavaeen keil onen Sol. Koa moeite en keil, isen Eliab, koa katau eni, isen Abinadab, ka koa vi etel en keitel, isen Samah. ");
INSERT INTO pma_vpl VALUES ("S117_14","010_17_14","1SA","17","14","14","Ka navong keitel telro ral min Sol, Deved, koa vi tasikor en keil, ");
INSERT INTO pma_vpl VALUES ("S117_15","010_17_15","1SA","17","15","15","kei mum suval eiloheh takataunien onen Sol. Ka en avong koa, kei va ris teim sen en out Betlehem valosil kat sipsip keil osen tamen. ");
INSERT INTO pma_vpl VALUES ("S117_16","010_17_16","1SA","17","16","16","En visokon ka mendilah keil vasi va rokol avong hanumau elu (40), Kolaeot mai selus kekar en me-Isrel keil. ");
INSERT INTO pma_vpl VALUES ("S117_20","010_17_20","1SA","17","20","20","En avong tai, Tiese meng kat Deved keke vakur anien vaha min tunali keil. Sakini, en visokon semau, Deved mea ka ling sipsip keil osen tamen en hen meatin sav valosil kat keil. Evus, lah anien enek va. Navong rokol out ten vaeen, vi avong varei koa me-Isrel keil amul asak mesein keil keke avaha en out ten vaeen. Ka navong uva, keil avisohiso keih va kat vativieh keil one. ");
INSERT INTO pma_vpl VALUES ("S117_21","010_17_21","1SA","17","21","21","Meatin tavaeen keil ten out Filistia ka koakeil emun onen me-Isrel keil umai amulomal en vulie, ka alei mamah en keil keke avavae. ");
INSERT INTO pma_vpl VALUES ("S117_22","010_17_22","1SA","17","22","22","Evus, Deved lokovein anien koa lahi mul en hen meatin koa mul lei kokoe en ateli keil onen meatin tavaeen keil. Evus, kei muloh va vales tunali keitel en out tavaeen ka vahis revi keitel keke telro mukave. ");
INSERT INTO pma_vpl VALUES ("S117_23","010_17_23","1SA","17","23","23","Ka navong kei mul veah selus ral min keitel, Kolaeot mai ris mulomal, ka selus kekar en me-Isrel keil suval koa mumoni lises. Ka Deved longe suk. ");
INSERT INTO pma_vpl VALUES ("S117_24","010_17_24","1SA","17","24","24","Navong me-Isrel keil ales Kolaeot, ametau houlu ka alohosai. ");
INSERT INTO pma_vpl VALUES ("S117_25","010_17_25","1SA","17","25","25","Keil aviteni min keil eris avit, “!Ei telmali! ?Miles meatin eke? Avong vasi kei selus kekar min ir me-Isrel keil. ?Ka miraengoni? Asuv houlu Sol vat kati keke hesan mari sanien tai min meatin koa houasi hemat. Ka vat kati mun vit hesan natnahin hehi ahin onen. Ka kei, hetal min titi amal onen, keil irvultei mun takis.” ");
INSERT INTO pma_vpl VALUES ("S117_26","010_17_26","1SA","17","26","26","Deved vis meatin keil koa amul vesesal veni vit, “?Meatin enek koa rokileatei Ahi mundemi kei vi isei keke vamai vaselus kekar en meatin tavaeen keil onen Ahi koa moul? ?Munak meatin etai houasi hemat ka hekulat memouen ran me-Isrel keil, isan asa varei mini?” ");
INSERT INTO pma_vpl VALUES ("S117_27","010_17_27","1SA","17","27","27","Sakini, keil avit kilea mini asa koa Sol vat kati vasani min meatin koa houas Kolaeot hemat. ");
INSERT INTO pma_vpl VALUES ("S117_31","010_17_31","1SA","17","31","31","Meatin keil koa along asa koa Deved viteni, ka uva avit meseini min Sol. Sakini Sol sisil eni. ");
INSERT INTO pma_vpl VALUES ("S117_32","010_17_32","1SA","17","32","32","Navong Deved va lesi, kei viteni min Sol vit, “Asuv, kami minametauntei meatin koanek ten out Filistia. Inau niha nivae hetal mini en usite orer.” ");
INSERT INTO pma_vpl VALUES ("S117_33","010_17_33","1SA","17","33","33","Sol vit kesi mini vit, “!Keik kovi ehon tai enges! Kosakras kovaha kovavae vatal mini veni kei mai vi meatin tavaeen tuetin tuai, navong kei vi ehon semau rokol avong kosa.” ");
INSERT INTO pma_vpl VALUES ("S117_34","010_17_34","1SA","17","34","34","Ka Deved vit risi mini vit, “Asuv houlu, inau nalosil kat sipsip keil osen tata onak. Ka navong laeon vuo bear tai mai ka venan titi sipsip tai, ");
INSERT INTO pma_vpl VALUES ("S117_35","010_17_35","1SA","17","35","35","inau nalikati ka namu vini. Evus, nakulat titi sipsip koanek ran ongon. Ka navong laeon vuo bear tai viles minau, inau nuvut navuli kat hilin ten hiren, ka namu vini mat. ");
INSERT INTO pma_vpl VALUES ("S117_36","010_17_36","1SA","17","36","36","Inau namuas laeon ka bear keil umat, ka en sakien enek, nu vini meatin ekek ten out Filistia. Kei mul veah en mankoli, ka mul selus kekar en meatin tavaeen keil onen Ahi koa moul. ");
INSERT INTO pma_vpl VALUES ("S117_37","010_17_37","1SA","17","37","37","Ka inau, naling desien onak en Iahova koa mutut moulien onak ran laeon ka bear keil, ka namundesini keke houtut moulien onak ran hen meatin eke ten out Filistia.” Sakini Sol vit risi mini vit, “Tahosis. Kiha kivae hetal mini, ka Iahova heto venuk.” ");
INSERT INTO pma_vpl VALUES ("S117_40","010_17_40","1SA","17","40","40","Deved kur eisal onen, va en valengei poal, votin meralihat elim (5) koa vupu revi mok, ka sien keil uva en ateli onen. Evus, sak mesein kei ral min siling talauien onen ka mual va ven Kolaeot. ");
INSERT INTO pma_vpl VALUES ("S117_41","010_17_41","1SA","17","41","41","Ka Kolaeot, kei mun mual mai ral min meatin tai koa mul vous eikokoe onen. Ka navong mai vesesal ven Deved, ");
INSERT INTO pma_vpl VALUES ("S117_42","010_17_42","1SA","17","42","42","lesi keke vi litetai tai enges koa aven malekuh ka veinan tahos. Ka navong lesi, lei maeni enges. ");
INSERT INTO pma_vpl VALUES ("S117_43","010_17_43","1SA","17","43","43","Les eisal onen Deved ka viteni mini vit, “?Ai enek ten sa? ?Keik komundemi kovit inau navi huli tai?” Ka viso va ven ahi keil onen keke imai ipurun Deved. ");
INSERT INTO pma_vpl VALUES ("S117_44","010_17_44","1SA","17","44","44","Evus, viso va min Deved vit, “!Amai! !Inau nisal vinik ka nisan teiai onom min aman ka tirendan keil iani.” ");
INSERT INTO pma_vpl VALUES ("S117_45","010_17_45","1SA","17","45","45","Ka Deved vit risi mini vit, “Keik kumai kovavae vatal minau ral min naef tavaeen ka ai takan keil. Ka inau, numai mavae vatal minuk en isen Iahova, Asuv Houlu ten Out Nesa. Kei varei vi Ahi onen meatin keil tavaeen onen me-Isrel keil koa komul koselus kekar eni. ");
INSERT INTO pma_vpl VALUES ("S117_46","010_17_46","1SA","17","46","46","!Ka kosa, Iahova helinguk kil en hek! !Nouasuk kimat ka nita koteh vatum! Hevus, nisan teiai onen meatin keil tavaeen ten out Filistia iha min aman ka tirendan keil iani. En sakien koanek, meatin vasi keil ten out netan ilea suk keke Ahi onen me-Isrel keil kur keihoen ka mul mum en usite onomai. ");
INSERT INTO pma_vpl VALUES ("S117_47","010_17_47","1SA","17","47","47","Kosa, meatin vasi keil koa amul ekok ilei kilea keke Ahi mul mutut moulien onen meatin keil onen. Ka romututtei keil en sise ten naef tavaeen keil ka metas keil. Vuo, kei varei hevae hetal min kami ka heling kami mihel en hemai.” ");
INSERT INTO pma_vpl VALUES ("S117_48","010_17_48","1SA","17","48","48","Navong Kolaeot mul mual va ven Deved, Deved muloh kekerat va vesesal veni keke vavae vatal mini. ");
INSERT INTO pma_vpl VALUES ("S117_49","010_17_49","1SA","17","49","49","Kei san hen va en ateli onen, kur meralihat tai, ka lingi en siling talauien onen. Evus, kuvini mal va ven Kolaeot ka meralihat enek va va vio … bon vatin, ka kanu varei va neim. Ka Kolaeot mot, muas vatin en atan. ");
INSERT INTO pma_vpl VALUES ("S117_50","010_17_50","1SA","17","50","51","Evus, Deved muloh va, mulomal vesesal veni, ka kulat naef tavaeen onen Kolaeot ran ateli teni. Evus, sal vini mat ka ra koteh vatin. En sakien enek, Deved koa tounah keil tavaeen onen tovuol, kei muas Kolaeot mat ral min siling talauien ka meralihat tanges. Ka navong me-Filistia keil alesi keke avkeih ten meatin tavaeen keil one mat, keil alohosai uva. ");
INSERT INTO pma_vpl VALUES ("S117_52","010_17_52","1SA","17","52","52","Evus, meatin tavaeen keil ten out Isrel ka Sudah amakul kat keil ka alikat keil va vio … houlu en me-Filistia keil umatmat en vali sise koa ka en out Saeram. Teiai keil one mul retai en out vasi, en hakot ten out Kat va soutin rokol meteau ten taon ten out Ekron. En avong enek, asuv houlu Sol kur Deved mai vi meatin tavaeen tai onen. ");
INSERT INTO pma_vpl VALUES ("S118_6","010_18_6","1SA","18","6","6","Katau en vaeen koa Deved muas Kolaeot mat, meatin tavaeen keil amusil sise avaha ris teim keil ose ka asi keil houlu. Ka navong meatin tavaeen keil enek arokol taon keil, ahin keil teni umai avisu min asuv houlu Sol ral min masmasien. Keil amusau ral min sien, amuas ave, apilei en iukalele ka uver en seka keil one. ");
INSERT INTO pma_vpl VALUES ("S118_7","010_18_7","1SA","18","7","7","Navong ahin keil amul uvol, keil amusau avit, “Sol muas meatin taosen tai (1000), ka Deved esuk muas taosen halualim (10,000).” ");
INSERT INTO pma_vpl VALUES ("S118_8","010_18_8","1SA","18","8","8","Navong Sol longe mukok, longe tisa ka tin vepeng. Kei vit sasen eni vit, “Keil aviteni keke Deved muas meatin taosen halualim (10,000), ka inau, avit taosen tas (1000). !Hervitei tuetin, keil ilingi hemai hehi asuv houlu one!” ");
INSERT INTO pma_vpl VALUES ("S118_9","010_18_9","1SA","18","9","9","Sakini, en hati avong enek varei va, Sol rendem tisa en Deved. Sol mules sila Deved vaha vavae vasakin kei vamat en vaeen. Ka lises, Deved mu vinvini vativieh keil one umatmat koa sakin meatin keil avati lat isen vina nesa mok. Sakini, rendemien onen Sol mai tisa revi mok va en Deved ka kei mun sak visi vouasi vamat, ka sakras. Ka navong Deved mundem kilea rendemien onen Sol, lohosai rani keke Sol nouasi namat. Deved va ro suai en out sav tai ka lah ruain vangi meatin keil amusili, ka kei mai vi avat one. Ka navong meatin keil tavaeen ten kantri sav keil umai keke avavae vatal min vangi me-Isrel keil en out tai, Deved ral min meatin keil onen umai uvae kokoe en keil. Sol ral min meatin tavaeen keil onen uva akarahit out vasi keke avalekat Deved ka avousi vamat, ka arvotintei. Hatte elu keke Deved kilea vouas Sol vamat ka romumontei veni en rovattei vapuruni, veni Ahi rie lati vi asuv houlu. ");
INSERT INTO pma_vpl VALUES ("S131_1","010_31_1","1SA","31","1","1","Avong tai, me-Filistia keil amumon vaeen ral min me-Isrel keil en Vatihou Kilboa. Houlu en me-Isrel keil umatmat ka houlu mun en keil alohosai. ");
INSERT INTO pma_vpl VALUES ("S131_2","010_31_2","1SA","31","2","2","Me-Filistia keil alikat Sol ral min meatin sav keil onen va vio … avuli kat natnali keitel ka amuas keitel telmat, iseatel Sionatan, Abinadab, ka Malkisua. ");
INSERT INTO pma_vpl VALUES ("S131_3","010_31_3","1SA","31","3","3","Evus, vaeen enek mai keih imok en out koa Sol mul ien. Koakeil akur hisuput, uvan eni, ka atuv bon Sol, vesesal vamat. ");
INSERT INTO pma_vpl VALUES ("S131_4","010_31_4","1SA","31","4","4","Sakini, Sol viles vis litetai koa mul lah tounah keil tavaeen onen vit, “!Leh lat naef tavaeen onom ka kisal vini nau nimat! !Ek rovattei koakeil enek koa areingeingen Ahi avamai avoumon tohtohien minau navong uas nau nimat!” Ka litetai enek metau voumoni. Sakini Sol enges viles naef onen, mot va ien, ka sal vini kei sasen. ");
INSERT INTO pma_vpl VALUES ("S131_5","010_31_5","1SA","31","5","5","Navong litetai enek lesi keke Sol mat, kei mun mot va en naef onen, ka sal vini kei sasen mat. ");
INSERT INTO pma_vpl VALUES ("S131_6","010_31_6","1SA","31","6","6","En sakien enek, Sol, natnali keitel, litetai takataunien onen, ka meatin vasi keil onen umatmat en avong tas. ");
INSERT INTO pma_vpl VALUES ("S25_1","011_5_1","2SA","5","1","1","Evus, mari vatiamal keil vasi ten out Isrel umai avales Deved en taon ten out Hibron, ka aviteni mini avit, “Komai mevi tumali kati keil. ");
INSERT INTO pma_vpl VALUES ("S25_2","011_5_2","2SA","5","2","2","Mulamu, navong Sol vi asuv houlu onomai, keik komulamun me-Isrel keil uva en vaeen keil. En avong enek, Iahova vat kati minuk keke keik kilosil kat meatin keil onen ten out Isrel. Anatin, kei viteni vit keik kihi avat onomai.” ");
INSERT INTO pma_vpl VALUES ("S25_3","011_5_3","2SA","5","3","3","Sakini, hetetamen keil vasi ten out Isrel umai ales Deved en taon ten out Hibron. En out enek, Deved mumon hatkatien takeih tai ral min keil. Evus, keil amutah oel en vatin vatie lati keke kei mai vi asuv houlu one. ");
INSERT INTO pma_vpl VALUES ("S25_4","011_5_4","2SA","5","4","4","Navong Deved mai vi asuv houlu, sua onen hanumau tai ka halualim emun (30), ka kei losil kat me-Isrel keil sua hanumau elu (40). Evus, Deved lah ruain meatin keil tavaeen onen, uva akur taon ten out Serusalem vahi one ka aro ien. Evus, Deved meng kat meatin keil onen avati mari eim tai keke vato ien en taon enek. Katau suk, Deved vis pris keil ka avous Eim Tavolin onen Ahi ka tounah vasi koa mul ien ral min masmasien, ka uva asesalini en taon onen Deved, vesesal en out Serusalem. Evus, keil aling Bokis ten Hatkatien Takeih mul ien. ");
INSERT INTO pma_vpl VALUES ("S27_1","011_7_1","2SA","7","1","1","Avong vahis muli, Deved ro tahosis en mari eim onen asuv houlu en out Serusalem, ka Iahova sakin vativieh keil onen arvaetei mun vatal mini. ");
INSERT INTO pma_vpl VALUES ("S27_2","011_7_2","2SA","7","2","2","Evus, en avong tai, asuv houlu Deved viteni min provet Netan vit, “?Kolesi? Kosa, inau naro en more eim tai koa amumoni en more vati sida keil. Ka Bokis ten Hatkatien Takeih onen Ahi mul enges en eim tavolin tai.” ");
INSERT INTO pma_vpl VALUES ("S27_3","011_7_3","2SA","7","3","3","Sakini, Netan vit kesi mini vit, “Tahos imok keik kumon asa koa komundemi veni Iahova ro venuk lisenges.” ");
INSERT INTO pma_vpl VALUES ("S27_4","011_7_4","2SA","7","4","4","Ka, en vongien enek, Iahova viteni min provet Netan vit, ");
INSERT INTO pma_vpl VALUES ("S27_5","011_7_5","2SA","7","5","5","“Kiha kihiteni min Deved koa vi eiloheh onak keke Iahova san selusien koanek mini vit, ‘Hervitei keik kumon eim onak keke mato ien.’ ");
INSERT INTO pma_vpl VALUES ("S27_8","011_7_8","2SA","7","8","8","“Kihiteni mun mini keke inau, Iahova, Asuv Houlu ten Out Nesa, naviten selusien koanek mini navit, ‘Inau, nakulatuk ran out koa kolosil kat sipsip keil ien, ka nalinguk kumai kovi avat kovalosil kat meatin onak keil ten out Isrel. ");
INSERT INTO pma_vpl VALUES ("S27_9","011_7_9","2SA","7","9","9","Naro ral minuk en out vasi kuva ien. Ka navong komul kuvae, namu lin vativieh keil onom. Inau nisakin isom hemai hehi hetetamen imok hesuval eis hetetamen sav keil ten out netan. ");
INSERT INTO pma_vpl VALUES ("S27_10","011_7_10","2SA","7","10","11","Navong meatin keil onak umai rohtoh en atan koanek ka naling metai keil avalosil kat keil rokol kosa, vativieh keil umai apurun keil houlu. Ka kosa, narie lat out tai koa maling meatin onak keil ten out Isrel avato ien. En out enek, nisakin keil itos en tomat en kantri kati one. “‘Inau, Iahova, navat kati minuk keke nisakin vatiamal keil koa ikistal ika enuk isosor en losilkatien onom min me-Isrel keil. ");
INSERT INTO pma_vpl VALUES ("S27_12","011_7_12","2SA","7","12","12","Navong keik kimai kimatu revi ka kimat, itahinuk vesesal ven avu onom keil. Hevus, numon natmali kati tai hekur vulum hemai hehi asuv houlu. Numoni helomal hekeih en losilkatien onen. ");
INSERT INTO pma_vpl VALUES ("S27_13","011_7_13","2SA","7","13","13","Hehi kei keke heti eim koa inau nito ien. Ka numon losilkatien onen koakeil ikistal ika en vatiamal onen hel heha vio … keite teni hetovuol. ");
INSERT INTO pma_vpl VALUES ("S27_14","011_7_14","2SA","7","14","14","Numoni mini hesuval koa kei vi natkuli kati ka navi tamen. Munak mot en tisaen, inau nitali mal eni hesuval tata tai san mahien min natnali vatalimal eni. ");
INSERT INTO pma_vpl VALUES ("S27_15","011_7_15","2SA","7","15","15","Ka nirkulattei envatien onak heha rani nasuval koa namumoni min Sol koa nakulati keke keik kikur vulin kovahi asuv houlu. ");
INSERT INTO pma_vpl VALUES ("S27_16","011_7_16","2SA","7","16","16","Nisakin vatiamal onom keil koa ikistal ika enuk il lisenges, ka keil ihi asuv houlu keil ilosil kat me-Isrel keil heha vio … keite teni hetovuol.’” ");
INSERT INTO pma_vpl VALUES ("S27_17","011_7_17","2SA","7","17","17","Sakini, provet Netan va les asuv houlu Deved ka vit vasin selusien onen Iahova mini. ");
INSERT INTO pma_vpl VALUES ("S211_1","011_11_1","2SA","11","1","1","Avati keil muli, ka avong ten ous evus, sakini vi avong kati koa asuv houlu keil uva ral min meatin tavaeen keil one keke avavae. Sakini, Deved sila Soab, koa vi houlu en meatin keil tavaeen ten out Isrel, ral min avat keil onen, ka meatin vasi keil tavaeen emun one keke avavae vatal min me-Amon keil. Ka meatin keil onen Deved amu rasilin me-Amon keil ka akarahit taon one ten out Raba. Ka Deved rovatei, kei ro nges en out Serusalem. ");
INSERT INTO pma_vpl VALUES ("S211_2","011_11_2","2SA","11","2","2","Avong tai, en taviai, Deved va matil. Ka navong kei mea ris, mual retoun nesa en teim sen en out tasehien tai. Ka en out enek nesa, lele vita en eim sav tai ka les ahin tai koa mul mukul. Kei lesi keke ahin enek tahos vis tahos imok. ");
INSERT INTO pma_vpl VALUES ("S211_3","011_11_3","2SA","11","3","3","Sakini, kei sila meatin onen tai vaha vahotini keke ahin enek onen sei. Ka votini keke ahin enek, isen Batsiba. Kei vi natnahin Eliam ka retalihe kur Uraea koa vi koan Hit tai. ");
INSERT INTO pma_vpl VALUES ("S211_4","011_11_4","2SA","11","4","4","Deved sila eiloheh tei onen keke avakur ahin enek vamai veni. Navong Batsiba mai veni, kei kuri ka matil ral mini. (Ka navong Batsiba emai, kei mukul motein kei tuai ran mesaien koa onen ahin keil musil sakien matu onen me-Isrel keil.) Evus, ahin enek va ris teim sen. ");
INSERT INTO pma_vpl VALUES ("S211_5","011_11_5","2SA","11","5","5","Katau suk, ahin enek lei kilea keke avati onen li. Sakini san selusien va min asuv houlu Deved. ");
INSERT INTO pma_vpl VALUES ("S211_6","011_11_6","2SA","11","6","6","Navong Deved longe keke Batsiba meas, kei san selusien va min Soab, houlu onen meatin tavaeen keil onen vit, “Kisila Uraea, koan Hit, hemai ris venau.” Sakini, Soab sila va veni. ");
INSERT INTO pma_vpl VALUES ("S211_7","011_11_7","2SA","11","7","7","Navong Uraea kistal, asuv houlu Deved visi usil Soab ka meatin keil tavaeen onen, ka vaeen mul va mukave. ");
INSERT INTO pma_vpl VALUES ("S211_8","011_11_8","2SA","11","8","8","Evus, kei viteni min Uraea vit, “Tahos. Ha seh mau en teim som.” Ka Uraea va, ka Deved san sanien tai musili vaha en teim sen. ");
INSERT INTO pma_vpl VALUES ("S211_9","011_11_9","2SA","11","9","9","Ka navong Uraea va, rovatei teim sen. Kei va ka matil vesesal en vali metareh ten eim onen asuv houlu ral min meatin taleikokoeien keil onen Deved. ");
INSERT INTO pma_vpl VALUES ("S211_10","011_11_10","2SA","11","10","10","Navong Deved raengoni keke Uraea rovatei en teim sen, va visi vit, “Kovuol ran teim som tuetin ?Ka kosa komai ris, vensa korvatei teim?” ");
INSERT INTO pma_vpl VALUES ("S211_11","011_11_11","2SA","11","11","11","Uraea vit kesi mini vit, “!Asuv, nasakras! Kosa, me-Isrel keil ka me-Sudah keil amules en votevav keil ome. Ka Bokis ten Hatkatien Takeih onen Ahi mules matil en eim tavolin tai enges. Avat onak, Soab, ral min avat tavaeen sav keil onom, keil amules amatil hae en mesaiuai. Sakini, romaltei keke inau maha teim, maanian vatahos, mamun hati uaen ka mamatil vatal ahin onak. !Navat kati keih minuk keke nasakras moumoni!” ");
INSERT INTO pma_vpl VALUES ("S211_12","011_11_12","2SA","11","12","12","Sakini, Deved viteni mini vit, “Kito avong tai ris, ka visuvong esuk, inau nisilak kiha ris.” Sakini, Uraea ro nges Serusalem avong koanek evus, ka avong sav teni emun. ");
INSERT INTO pma_vpl VALUES ("S211_13","011_11_13","2SA","11","13","13","Deved sisil eni vamai vaanian vatal mini en vongien enek, ka mumon kei munmun vini kei. Ka en vongien enek emun, Uraea rovatei teim. Va matil en out koa kei matil ien mulamu ral min meatin taleikokoeien keil onen Deved. ");
INSERT INTO pma_vpl VALUES ("S211_14","011_11_14","2SA","11","14","14","En visokon, Deved mutis leta tai ka sani min Uraea vakuri vasa lati min Soab. ");
INSERT INTO pma_vpl VALUES ("S211_15","011_11_15","2SA","11","15","15","En leta onen, kei mutis selusien enek vit, “Kiling Uraea heha helamu en meatin tavaeen keil en out koa vaeen keih vis keih imok. Ka navong amul uvae, kihis meatin sav keil keke ilokovein Uraea hevae kei sasen keke vativieh keil u vini hemat.” ");
INSERT INTO pma_vpl VALUES ("S211_16","011_11_16","2SA","11","16","16","Sakini, navong Soab mul karahit taon ten out Ramah, sila Uraea va en out koa kilea vativieh keil one akeih amul ien. ");
INSERT INTO pma_vpl VALUES ("S211_17","011_11_17","2SA","11","17","17","Ka navong meatin keil tavaeen onen me-Amon keil amea ran taon enek keke avavae vatal min meatin tavaeen keil onen Soab, keil amu vini meatin tei keil tavaeen onen Deved, ka Uraea, koan Hit, kei mun mat. ");
INSERT INTO pma_vpl VALUES ("S211_26","011_11_26","2SA","11","26","26","Navong Batsiba longe keke meatin onen amuasi mat, longe tisa houlu ka murang veni. ");
INSERT INTO pma_vpl VALUES ("S211_27","011_11_27","2SA","11","27","27","Ka navong avong keil tatangien koa avi oulu (7) muli va, Deved sisil eni. Sakini mai en teim sen asuv houlu ka Deved kuri vi ahin onen. Katau, kei kur ehon tai onen Deved. Ka Iahova rositei en asa koa Deved mumoni. ");
INSERT INTO pma_vpl VALUES ("S212_1","011_12_1","2SA","12","1","1","En avong tai, Iahova sila provet Netan va ven asuv houlu Deved. Ka navong va veni, kei viteni mini vit, “?Asuv houlu Deved, kokilea kovalei revi en usite tai onak? Meatin elu luro en taon tai. Tai, tounah onen houlu, ka tamun, tounah onen rovitei houlu. ");
INSERT INTO pma_vpl VALUES ("S212_2","011_12_2","2SA","12","2","2","Koa tounah onen houlu, buluk ka sipsip osen keil avi houlu ramat. ");
INSERT INTO pma_vpl VALUES ("S212_3","011_12_3","2SA","12","3","3","Ka koa tounah onen rovitei houlu, kei mul losil kat titi sipsip osen tas koa kei vuli. Kei lei kat revi titi sipsip osen ka mul moul en teim sen ral min titiali keil onen. Mul san hati anien an koa mini, maeni vamun oai en kap onen, ka maeni vamatil en avet omon. Anatin, kei lei kat revi titi sipsip enek suval koa vi natnahin kati. ");
INSERT INTO pma_vpl VALUES ("S212_4","011_12_4","2SA","12","4","4","Avong tai, meatin tai ka soutin ka mual mai en teim onen kei koa tounah onen houlu. Ka meatin koa tounah onen houlu en rovattei vouas etai buluk vuo sipsip osen keke vasak mesein anien vahi an. Sakini, va suk kur titi sipsip osen koa tounah onen rovitei houlu. Evus, muasi ka lengasi mesei keke meatin koa emai heani.” ");
INSERT INTO pma_vpl VALUES ("S212_5","011_12_5","2SA","12","5","5","Navong Netan viteni mukok, Deved tin tisa houlu ka vit, “!Inau navat kati keih imok en meten Iahova koa moul keke mal meatin enek hemat ven asa koa mumoni! ");
INSERT INTO pma_vpl VALUES ("S212_6","011_12_6","2SA","12","6","6","Veni tounah koa mumoni tisa revi mok ka enmahisien onen tovuol, kei hesan kes titi sipsip osen hehat (4).” ");
INSERT INTO pma_vpl VALUES ("S212_7","011_12_7","2SA","12","7","7","Sakini Netan viteni min Deved vit, “!Keik varei kovi meatin enek! Ka koanek vi asa koa Iahova, Ahi onen me-Isrel keil, en vati vahiteni minuk, ‘Inau namumonuk komai kovi asuv houlu onen me-Isrel keil, ka naring koek ran asa koa Sol vit voumoni minuk. ");
INSERT INTO pma_vpl VALUES ("S212_8","011_12_8","2SA","12","8","8","Ka navong nakulat Sol, tounah keil koa mul en hen, nasa lati minuk. Ahin onen emun keil, nasani minuk. Me-Isrel keil ral min me-Sudah keil, inau naling keil vasi amul en hem. Ka munak tounah vasi enek rovinvintei veah, inau nakilea masani vahi houlu tamun emau. ");
INSERT INTO pma_vpl VALUES ("S212_9","011_12_9","2SA","12","9","9","?Sakini, vensa korlong kattei rek? ?Vensa komumon tounah koa tisa en metok? Keik varei komuas Uraea mat en naef tavaeen onen me-Amon keil. !Evus, kokur ahin onen mai vi onom! ");
INSERT INTO pma_vpl VALUES ("S212_10","011_12_10","2SA","12","10","10","Ven komumon koanek, vatiamal tei keil onom, lises imatmat en naef tavaeen onen meatin sav keil. Koanek hekistal en vatiamal onom kati veni kosesein rek navong kokur ahin onen Uraea, koan Hit, vi onom.’ ");
INSERT INTO pma_vpl VALUES ("S212_11","011_12_11","2SA","12","11","11","“Iahova viteni mun minuk vit, ‘Naviteni anatin keke nisakin koakeil en teim onom kati imea um hetisa heha katuk. Kilesi en metom navong inau nikulat ahin keil onom ranuk ka nisani keil iha min tai koa hemea en vatiamal onom. Kei hematil hetal min keil en mesaiuai enges. ");
INSERT INTO pma_vpl VALUES ("S212_12","011_12_12","2SA","12","12","12","Anatin, asa komumoni, komum suaini. Ka asa koa inau numoni, numoni hekistal en mesaiuai en meten me-Isrel keil vasi.’” ");
INSERT INTO pma_vpl VALUES ("S212_13","011_12_13","2SA","12","13","13","Navong Deved longe, viteni min Netan vit, “!Aue li! !Inau namum tisa houlu li en meten Iahova!” Ka provet Netan vit kesi mini vit, “Iahova sahulin tisaen ran moulien onom ka keik, kirmattei. ");
INSERT INTO pma_vpl VALUES ("S212_14","011_12_14","2SA","12","14","14","Ka veni koviles eisilum rani ka komumon sakien tatisa enek, tivava onom koa avasi, kei hemat.” ");
INSERT INTO pma_vpl VALUES ("S212_15","011_12_15","2SA","12","15","15","Evus, provet Netan va ris teim sen. Ka navong provet Netan va, Iahova sakin tivava onen Deved, koa ahin onen Uraea kuri, mesai houlu. ");
INSERT INTO pma_vpl VALUES ("S212_16","011_12_16","2SA","12","16","16","Sakini, Deved va mul vis min Ahi keke titiali onen vamai ris vatahos. Kei val ran anien, ka kei matil en atan en vongien vasi va rokol out mulan. ");
INSERT INTO pma_vpl VALUES ("S212_17","011_12_17","2SA","12","17","17","Hetetamen keil onen koa amul vesesal veni, uva asak visi avatali lati. Ka kei en rovattei ka seseini keke vaha vaanian vatal min keil. ");
INSERT INTO pma_vpl VALUES ("S212_18","011_12_18","2SA","12","18","18","Wik tai muli, ka titiali enek emat esuk. Ka navong mat, hetetamen keil onen Deved ametau avaha avahiteni mini. Keil amundemi avit, “Navong titiali enek mul veah moul, Deved en rovattei valong selusien orer. ?Sakini, rehehit mesein matien onen titiali enek hemukave? Vahesa noumon etai tounah natisa suk min kei sasen enges.” ");
INSERT INTO pma_vpl VALUES ("S212_19","011_12_19","2SA","12","19","19","Navong Deved les keil amul aselus lelau en keil, kilea varei keke titan mat. Sakini vis keil vit, “?Mukave? ?Titiali mat?” Ka keil avit kesi mini avit, “Anatin eli, kei li mat.” ");
INSERT INTO pma_vpl VALUES ("S212_20","011_12_20","2SA","12","20","20","Navong Deved longe, mea ran atan, va mukul, sahula aven en oel, ka kekes en eisin omon. Evus, va en Eim Tavolin onen Iahova ka vita netan mini. Ka navong va ris teim sen, vis anien. Sakini, asan anien mini, ka kanian esuk. ");
INSERT INTO pma_vpl VALUES ("S212_21","011_12_21","2SA","12","21","21","Navong hetetamen keil onen ales sakien keil onen, keil umai veni avisi avit, “?Komumon sakien keil enek vensa? Navong titiali onom mul veah moul, korangisi ka kuval ran anien. Ka navong kei mat, keik komea ka kokanian esuk.” ");
INSERT INTO pma_vpl VALUES ("S212_22","011_12_22","2SA","12","22","22","Asuv houlu Deved vit kesi min keil vit, “Anatin keke nuval ran anien ka namurang navong titiali enek mul veah moul. Namundemi navit vahesa Iahova en hemahis inau, ka hermaentei titiali enek hemat. ");
INSERT INTO pma_vpl VALUES ("S212_23","011_12_23","2SA","12","23","23","Ka kosa, kei mat tuai. ?Vensa mahal ran anien? ?!Nakilea masakin titiali enek vamoul eris!? !Vuo, nasakras! Avong etai, inau niha en out koa kei ro ien, ka kei sakras vamai ris venau.” ");
INSERT INTO pma_vpl VALUES ("S212_24","011_12_24","2SA","12","24","24","Sakini, asuv houlu Deved va selus tahos min ahin onen, Batsiba, vahati lat rendemien onen vamai ris vatahos. Luro vituai ka kei meas. Avati keil muli va, kur tivava tai koa vi meahos, ka Deved ling isen vi ‘Solomon.’ Iahova en vat titiali enek houlu mok. ");
INSERT INTO pma_vpl VALUES ("S212_25","011_12_25","2SA","12","25","25","Sakini viteni min provet Netan keke hesan eis sav tai mini koa vi ‘Sedidaea’ koa aneite teni vi ‘kei koa Iahova en vati.’ ");
INSERT INTO pma_vpl VALUES ("K12_10","012_2_10","1KI","2","10","10","Navong asuv houlu Deved vi ulmatu revi, kei mat, ka arahini en out Serusalem, koa avise en ‘taon onen Deved.’ ");
INSERT INTO pma_vpl VALUES ("K12_11","012_2_11","1KI","2","11","11","Kei losil kat me-Isrel keil sua hanumau elu (40). Sua oulu (7) teni, ro en taon ten out Hibron, ka sua hanumau tai ka teindan etel (33) teni, ro en taon ten out Serusalem. ");
INSERT INTO pma_vpl VALUES ("K12_12","012_2_12","1KI","2","12","12","Ka navong mat, natnali Solomon kur vulin ka mai vi asuv houlu. En avong koa kei losil kat meatin keil, keil aro en tomat ka vativieh keil one tovuol. ");
INSERT INTO pma_vpl VALUES ("K13_3","012_3_3","1KI","3","3","3","Solomon en vat Iahova ka musil kat asa koa tamen Deved viseini eni. Ka kei san sanien votut keil ka munit senta en hoi hou keil veni Eim Votut onen Ahi tovuol veah. ");
INSERT INTO pma_vpl VALUES ("K13_4","012_3_4","1KI","3","4","4","En avong tai, Solomon va en out Kibion keke vasan sanien votut vaha min Ahi en mari ahor en out enek koa houlu mok mulin ahor ten out sav keil. Ka en out enek, kei meng kati keke avouas buluk keil hehi taosen tai (1000) ka avanit lin keil en ahor enek en avong tas. ");
INSERT INTO pma_vpl VALUES ("K13_5","012_3_5","1KI","3","5","5","En vongien enek, Iahova mai selus mini en matil vovoien tai vit, “Asa koa em vati, kihis inau eni, ka nisani minuk.” ");
INSERT INTO pma_vpl VALUES ("K13_6","012_3_6","1KI","3","6","6","Solomon vit kesi mini vit, “Lisenges, keik korie lat mari envatien onom min tata onak Deved koa vi meatin toumien onom. Komumoni mukonek veni kei vi meatin tai koa musiluk ral min moulien vasi keil onen, sakien onen mal, ka rendemien onen mutolas en metom. Ka kosa emun, komules korie lat envatien onom mini en sakien koa kosan ehon tai mini vakur vulin. ");
INSERT INTO pma_vpl VALUES ("K13_7","012_3_7","1KI","3","7","7","O Iahova, Ahi onak, keik komaenau makur vulin tata onak mamai mahi asuv houlu, avaseini navi meatin hau tai ka narkileatei nilosil kat meatin keil hemukave. ");
INSERT INTO pma_vpl VALUES ("K13_8","012_3_8","1KI","3","8","8","Keik koling nau navi meatin toumien onom mato luhu en vangi meatin keil koa kolei kan keil ka kosakin keil umai avi houlu ramat keke meatin sakras vahuli vasin keil. ");
INSERT INTO pma_vpl VALUES ("K13_9","012_3_9","1KI","3","9","9","Sakini, navisuk kovasan meteisauen keke malosil kat revi meatin keil onom en sise koa mal keke malei kilea asa koa tahos ka asa koa tisa. ?Veni munak kirkatauntei nau, nilosil kat meatin onom keil koa avi houlu mok hemukave?” ");
INSERT INTO pma_vpl VALUES ("K13_10","012_3_10","1KI","3","10","10","Navong Ahi Asuv long hisien onen Solomon, kei si houlu veni. ");
INSERT INTO pma_vpl VALUES ("K13_11","012_3_11","1KI","3","11","11","Sakini, viteni mini vit, “Nasi nau keke kovis nau ven meteisauen kovalosil kat revi meatin keil, ka korvistei nau masan moulien koa tetaveah, vuo mani, vuo matien onen vativieh keil onom minuk. ");
INSERT INTO pma_vpl VALUES ("K13_12","012_3_12","1KI","3","12","12","Sakini, inau nisani minuk asa koa kovis inau eni. Anatin, meteisauen koa nisani minuk helohlin meteisauen koa meatin sav keil koa amulamu enuk akuri, ka helohlin meteisauen onen koakeil ikatau enuk ikuri. ");
INSERT INTO pma_vpl VALUES ("K13_13","012_3_13","1KI","3","13","13","Ka tounah vasi koa korvistei inau eni, keil emun nisani minuk. En avong vasi koa komoul koro, keik kikur houhouen ka tounah vasi keil onom helohlin asuv houlu savsav keil ten out netan. ");
INSERT INTO pma_vpl VALUES ("K13_14","012_3_14","1KI","3","14","14","Ka munak kilong katnau ka kusil kat mengkatien keil onak hesuval koa tata onom Deved mumoni, inau nisakin moulien onom hetaveah.” ");
INSERT INTO pma_vpl VALUES ("K13_15","012_3_15","1KI","3","15","15","Navong Solomon muli mea, kilea suk keke Ahi selus mini ka en matil vovoien tai. Evus, va ris Serusalem, ka mulomal vesesal ven Bokis ten Hatkatien Takeih onen Iahova. En out enek, Solomon muas buluk koa ka munit lin keil en ahor keke vahi sanien votut onen min Ahi. Evus, muas buluk tei mun keke vahi sanien ten lahruaien ral min Ahi ka rei lat tei vuseri keil teni keke voumon mari anien tai vahi onen hetetamen keil onen. ");
INSERT INTO pma_vpl VALUES ("K14_20","012_4_20","1KI","4","20","20","En hen Solomon, me-Sudah ka me-Isrel keil akanian revi, amunmun revi, ka asi keil en avong vasi. Keil umai avi houlu vis avi houlu mok asuval veien ten atas. ");
INSERT INTO pma_vpl VALUES ("K14_21","012_4_21","1KI","4","21","21","Solomon losil kat mari out tai: out keil en vali Oaisal Upretis en usite koa ist va rokol hakot ten kantri ten out Isip en usite koa wes, ka out keil emun en out Filistia en usite koa saot va rokol Atas Medeterenia en usite koa not. Meatin vasi keil koa aro en out keil enek asan takis keil one va mini ka amul en hen en avong vasi koa kei moul ro. ");
INSERT INTO pma_vpl VALUES ("K14_25","012_4_25","1KI","4","25","25","Ka navong Solomon moul mules, me-Sudah keil ka me-Isrel keil aro en tomat ka ales amas en teim se. ");
INSERT INTO pma_vpl VALUES ("K16_1","012_6_1","1KI","6","1","1","Navong Solomon vi asuv houlu sua ehat (4) tuai, kei vis meatin keil onen avoum rohtoh en Eim Votut onen Ahi. Koanek kur out sua handred ehat ka hanumau ehat emun (480) katau en avong koa me-Isrel keil alokovein kantri ten out Isip keke avamai avakur atan kati ose. ");
INSERT INTO pma_vpl VALUES ("K16_11","012_6_11","1KI","6","11","11","En avong tai, Iahova viteni min Solomon vit, ");
INSERT INTO pma_vpl VALUES ("K16_12","012_6_12","1KI","6","12","12","“Navong komul komumon Eim Votut onak, ek vati keke kovousil kat rendemien keil koa nalingi, kilong kat hihiseien keil onak, ka kihuli kat mengkatien keil onak emun. Munak kumoni hemukonek, hatkatien koa namumoni ral min tata onom Deved, inau numoni hekistal hehi anatin en moulien onom. ");
INSERT INTO pma_vpl VALUES ("K16_13","012_6_13","1KI","6","13","13","Inau, nito en Eim Votut enek koa komul komumoni. Anatin, nito hetal min meatin onak keil ka nirlokoveintei keil.” ");
INSERT INTO pma_vpl VALUES ("K16_14","012_6_14","1KI","6","14","14","Sakini meatin toumien keil onen Solomon amumon eim enek va vio … amum vasi. ");
INSERT INTO pma_vpl VALUES ("K18_1","012_8_1","1KI","8","1","1","Navong Eim Votut onen Iahova evus, Solomon sisil en elda keil ten out Isrel ral min avat ka asuv keil ten vatiamal keil vasi onen me-Isrel keil keke avalah ruai en out Serusalem. Evus, vis pris keil keke avaha en out Saeon, taon onen Deved, avasak mesei avahulat Bokis ten Hatkatien Takeih onen Iahova koa mul en Eim Tavolin, ka avahousi vamai avalingi en Eim Votut en out Serusalem koa vesesal. ");
INSERT INTO pma_vpl VALUES ("K18_3","012_8_3","1KI","8","3","3","Ka navong hetetamen vasi keil onen meatin keil umai out tas, pris keil avous Bokis ten Hatkatien umai. ");
INSERT INTO pma_vpl VALUES ("K18_4","012_8_4","1KI","8","4","4","Ka en hati avong enesek, amo keil ten vatiamal onen Livae ral min pris tei keil amusil keil ka avous Eim Tavolin onen Ahi ral min tounah sav keil emun teni uva en Eim Votut enek. ");
INSERT INTO pma_vpl VALUES ("K18_5","012_8_5","1KI","8","5","5","Evus, asuv houlu Solomon ral min me-Isrel keil umai out tas vesesal ven Bokis ten Hatkatien Takeih, ka amuas sipsip ka buluk keil houlu vis houlu mok koa meatin keil asakras avahuli keil keke avahi sanien votut keil one min Ahi. ");
INSERT INTO pma_vpl VALUES ("K18_6","012_8_6","1KI","8","6","6","Evus, pris keil avous Bokis ten Hatkatien Takeih enek uva alingi en vulin kati neim en out tai koa vi votut vis vi votut imok. Anatin, alingi luhu en angelo elu koa avise keilu en ‘sereb,’ en hehen apouealu. ");
INSERT INTO pma_vpl VALUES ("K18_10","012_8_10","1KI","8","10","10","Ka navong pris keil alokovein out koa vi votut vis vi votut imok, mahmah tai mita sien Eim Votut, ");
INSERT INTO pma_vpl VALUES ("K18_11","012_8_11","1KI","8","11","11","ka muohien ten keihoen onen Iahova ritin koe out neim. Sakini, pris keil asakras emun avoumon umen keil one ien. ");
INSERT INTO pma_vpl VALUES ("K18_22","012_8_22","1KI","8","22","22","Evus, en meten meatin keil, Solomon mulomal vesesal ven ahor ten sanien votut keil onen Iahova, vati lat hen keilu vina nesa ");
INSERT INTO pma_vpl VALUES ("K18_23","012_8_23","1KI","8","23","23","ka vis min Ahi vit, “O Iahova, Ahi onen me-Isrel keil, ahi sav tovuol emun en out nesa vuo en out netan koa vasuvaluk. Keik korie lat envatien onom ka komumon hatkatien keil onom umai akistal avi anatin min meatin onom keil koa along katuk ral min moulien vasi keil one. ");
INSERT INTO pma_vpl VALUES ("K18_27","012_8_27","1KI","8","27","27","“?O Ahi Asuv, kovit kovamita en out netan ka kito en eim koanek hemukave? Keik komarite mok, teilang ka out nesa havivis, arvinvintei kovato ien. ?Ka Eim Votut enek koa komai memumoni havivi ramat, kito ien hemukave? ");
INSERT INTO pma_vpl VALUES ("K18_28","012_8_28","1KI","8","28","28","O Iahova, Ahi onak, navi meatin toumien onom. Kitaengon revi hisien onak koa masani minuk kosa ekek, ka kisan uite teni minau li. ");
INSERT INTO pma_vpl VALUES ("K18_29","012_8_29","1KI","8","29","29","Kilosil kat revi en meneai ka vongien keil vasi, veni keik kolei kan Eim Votut enek keke koling Isom mul ien. Sakini, navong naviles nak mal en eim enek, kitaengon revi hisien keil onak. ");
INSERT INTO pma_vpl VALUES ("K18_30","012_8_30","1KI","8","30","30","Anatin, kitaengon hisien keil onak, ka hisien keil onen meatin keil onom navong aviles nae mal en out ekek ka avis vat minuk. En out koa koro ien en out nesa, kitaengon revi komai ka kisak motein komai ran tisaen keil onomai ka kumon methos onom hel ven komai. ");
INSERT INTO pma_vpl VALUES ("K18_41","012_8_41","1KI","8","41","42","“Ka munak meatin tai ten kantri sav tai koa mul soutin hekur longlongien keil usil Isom, keihoen onom, ka mari tounah keil koa komumoni, hesakin kei hemai en out ekek keke vahita netan minuk. Ka munak viles nan mal en Eim Votut onom keke vahis vahat minuk, ");
INSERT INTO pma_vpl VALUES ("K18_43","012_8_43","1KI","8","43","43","kitaengon hisien keil onen. En out koa koro ien en out nesa, kilong hisien keil onen ka kisan uite teni hekistal. En sise enek, meatin keil vasi en out netan imai ilong kilea Isom ka ihouhou minuk suval meatin keil onom ten out Isrel amul amumoni. Anatin, ilea suk keke Isom mul moul en eim koanek koa komai memumoni.” ");
INSERT INTO pma_vpl VALUES ("K111_1","012_11_1","1KI","11","1","1","Asuv houlu Solomon, envatien onen mul en ahin keil houlu ten kantri savsav keil. Kur natnahin asuv houlu ten out Isip. Evus, retalihe mun ral min ahin savsav keil emun: koakeil ten out Hit, ten out Moab, ten out Amon, ten out Edom, ka ten out Saedon emun. ");
INSERT INTO pma_vpl VALUES ("K111_2","012_11_2","1KI","11","2","2","Solomon retalihe ral min keil, avaseini Ahi sel kat me-Isrel keil keke irtetalihetei hetal min koakeil aka en kantri keil enek. Ahi kilea keke munak umoni hemukonek, keil isakin me-Isrel keil ihiles rani ka usil ahi savsav keil. ");
INSERT INTO pma_vpl VALUES ("K111_3","012_11_3","1KI","11","3","3","Solomon retalihe ral min natnahin asuv houlu keil handred oulu (700) ten kantri savsav keil. Ka atou sav keil onen arokol handred etel (300). Ahin keil enek asakin Solomon viles ran Iahova. ");
INSERT INTO pma_vpl VALUES ("K111_4","012_11_4","1KI","11","4","4","Sakini, navong kei mai vi ulmatu, ahin onen keil asakin kei viles ka vita netan min ahi ten kantri sav keil. Kei romusil kat revitei mun Iahova vakeih koa vi Ahi kati onen vasuval tamen Deved mumoni mulamu. ");
INSERT INTO pma_vpl VALUES ("K111_5","012_11_5","1KI","11","5","5","Ka vita netan min ahi koa vi ahin onen me-Saedon keil koa isen ‘Astata,’ ka min ahi onen me-Amon keil koa isen vi ‘Molek’ koa tisa revi mok en meten Iahova. ");
INSERT INTO pma_vpl VALUES ("K111_7","012_11_7","1KI","11","7","7","En hoi hou tai koa mul en usite ist ten taon ten out Serusalem, Solomon mumon ahor ten sanien tai min ahi tisa onen me-Moab keil koa isen ‘Simos,’ ka ahor tei mun min Molek, ahi tatisaso onen me-Amon keil. ");
INSERT INTO pma_vpl VALUES ("K111_8","012_11_8","1KI","11","8","8","Solomon mumoni vati tas min ahi vasi keil onen ahin keil onen. Kei mumon ahor ten sanien min ahi keil enek keke ahin keil onen koa aka en kantri savsav keil akilea avaha netan min keil, avanit senta ten hisien vaha min keil, ka avasan sanien votut keil one min keil. ");
INSERT INTO pma_vpl VALUES ("K111_9","012_11_9","1KI","11","9","10","Ven sakien onen keil enek, Iahova vuroh kat Solomon. Avaseini Iahova, Ahi onen me-Isrel keil, kistal mini avong elu (2) vasel kati keke nahatei netan min ahi savsav keil ten kantri sav keil, Solomon rolong kattei ren ka viles esuk ran mengkatien keil onen. ");
INSERT INTO pma_vpl VALUES ("K111_11","012_11_11","1KI","11","11","11","Sakini, Iahova viteni mini vit, “Veni komumon rendemien onom keke korali vas hatkatien takeih onak ka mengkatien keil onak koa nasani minuk, kosa navat kati minuk keke nisav lat keihoen ten asuv houlu ran hem, ka nisani suk min meatin toumien onom tai. ");
INSERT INTO pma_vpl VALUES ("K111_12","012_11_12","1KI","11","12","12","Ka ven usite onen tata onom Deved, nirmumontei sakien enek hekistal en avong koa komoul koro veah. Numoni suk hemai hekistal min natmali navong hemai hekur vulum hehi asuv houlu. ");
INSERT INTO pma_vpl VALUES ("K111_13","012_11_13","1KI","11","13","13","Ka nirsav lattei mari vatiamal keil vasi ten out Isrel ran hen. Vuo, nimaeni helosil kati veah mari vatiamal tanges veni namundem usil Deved koa vi meatin toumien onak, ka namundemi mun usil taon ten out Serusalem koa nalei kani vahi out kati onak.” ");
INSERT INTO pma_vpl VALUES ("K111_26","012_11_26","1KI","11","26","26","Koanek vi tunien usil hetamen tai onen asuv houlu Solomon koa viles rani ka sesein keihoen onen, isen Sereboam. Tata onen mat tuai koa isen Nebat ten out Seredah en provins ten out Efrem. Ka mama onen vi vatina tai, isen Seruah. ");
INSERT INTO pma_vpl VALUES ("K111_27","012_11_27","1KI","11","27","27","En avong tai, Solomon meng kat meatin keil onen avasak revi vieh koa keih koa ring koe taon ten out Serusalem ral min vali hou koa mul en usite koa ist. ");
INSERT INTO pma_vpl VALUES ("K111_28","012_11_28","1KI","11","28","28","Navong Solomon va vales umen keil enek, lesi keke Sereboam vi meatin hau tai koa mum tahos. Sakini lingi vi avat onen vangi meatin toumien keil koa aka en mari vatiamal onen Manase ka Efrem. ");
INSERT INTO pma_vpl VALUES ("K111_29","012_11_29","1KI","11","29","29","Avong vahis muli, ka en avong tai, navong Sereboam lokovein out Serusalem ka mul mual en out tai koa vi mesaiuai, kei visu min provet tai ten out Saeloh koa mual kei sasen enges ka musin en eisin hau keil, isen Ahisah. Keilu enges lumul en sise, meatin sav keil atovuol. ");
INSERT INTO pma_vpl VALUES ("K111_30","012_11_30","1KI","11","30","30","Evus, provet enek kulat kot hau omon enek koa musin eni ka rali vasi vi samureite teindan elu (12). ");
INSERT INTO pma_vpl VALUES ("K111_31","012_11_31","1KI","11","31","31","Navong rali vasi evus, viteni min Sereboam vit, “En samure eisin ekek, keik kikur halualim (10) ihi onom veni Iahova, Ahi onen me-Isrel keil, mul viteni vit, ‘Inau nisav lat keihoen ten hiasuvien ran hen asuv houlu Solomon, ka niling hiasuvien ten mari vatiamal halualim (10) ten out Isrel il en hem. ");
INSERT INTO pma_vpl VALUES ("K111_32","012_11_32","1KI","11","32","32","Solomon helosil kat koakeil aka en mari vatiamal onen Sudah enges hetal min koakeil emun aka en vatiamal onen Bensamin veni inau namundem usil tata onen veah, Deved, koa vi meatin toumien onak. Ka namundem kat out Serusalem emun koa inau nalei kani ran meteimal sav keil ten out Isrel keke vahi out kati onak. ");
INSERT INTO pma_vpl VALUES ("K111_33","012_11_33","1KI","11","33","33","Numon koanek veni Solomon sesein nau, ka va netan min ahi sav keil: min Astata, ahi koa vi ahin onen me-Saedon keil; min Kimos, ahi onen me-Moab keil; ka min Molek, ahi onen me-Amon keil. Solomon romusiltei sise onak ka long sesein nau. Kei mum kalkali ka rolong kattei rek vasuval tamen Deved mumoni mulamu.’” ");
INSERT INTO pma_vpl VALUES ("K111_40","012_11_40","1KI","11","40","40","Navong Solomon raengoni, kei sak visi vouas Sereboam vamat. Ka kei lohosai rani ka va les asuv houlu ten out Isip koa isen vi Sisak. Sereboam ro en kantri ten out Isip va rokol avong koa asuv houlu Solomon mat. ");
INSERT INTO pma_vpl VALUES ("K111_42","012_11_42","1KI","11","42","42","Asuv houlu Solomon ro en out Serusalem ka losil kat me-Isrel keil sua hanumau elu (40). ");
INSERT INTO pma_vpl VALUES ("K111_43","012_11_43","1KI","11","43","43","Evus, mat ka arahini en out Serusalem, taon onen tata onen, Deved. Ka natnali, Rehoboam, kur vulin mai vi asuv houlu. ");
INSERT INTO pma_vpl VALUES ("K112_1","012_12_1","1KI","12","1","1","Navong asuv houlu Solomon mat, Rehoboam va en taon ten out Sekem, ka en out enek, me-Isrel keil koa aro en out not umai ruai keke avahati lati vamai vahi asuv houlu one. ");
INSERT INTO pma_vpl VALUES ("K112_2","012_12_2","1KI","12","2","2","Longlongien usili va rokol Isip. Ka navong Sereboam, natin Nepat, koa lohosai ran asuv houlu Solomon longe, kei lokovein kantri ten out Isip ka va ris en out Isrel. ");
INSERT INTO pma_vpl VALUES ("K112_3","012_12_3","1KI","12","3","3","Navong me-Isrel keil alonge, asan selusien mini keke vamai en lahruaien one ka vaselus en usite one. Sakini Sereboam emai ka viteni min Rehoboam vit, ");
INSERT INTO pma_vpl VALUES ("K112_4","012_12_4","1KI","12","4","4","“Tata onom, Solomon, romumtei vatahos min komai. Kei sakin komai memum keih ramat mini. Ka munak keik kikulat tei umen takeih ran komai ka kumoni hemelala mok min komai, mehemai mehehi meatin keil onom ka mehelong katuk lisenges.” ");
INSERT INTO pma_vpl VALUES ("K112_5","012_12_5","1KI","12","5","5","Ka asuv houlu Rehoboam vit risi min keil vit, “Miheha mau. Ka navong avong etel heli, mihemai ris ka inau nihit ris usi selusien onami en asa koa mivis inau eni.” Sakini, meatin keil enek uva. ");
INSERT INTO pma_vpl VALUES ("K112_6","012_12_6","1KI","12","6","6","Evus, asuv houlu Rehoboam vise ruain elda keil koa akataun tata onen Solomon en rendemien keil onen. Navong umai, vis keil vit, “?Mukave? ?Meteisauen sa mihesani minau keke inau niha nihiteni min meatin keil enek?” ");
INSERT INTO pma_vpl VALUES ("K112_7","012_12_7","1KI","12","7","7","Sakini avit risi mini avit, “Munak keik kitie lati min keil keke kovi meatin takataunien one ka kisan selusien tetahos min keil, keil esuk ihi meatin takataunien keil onom lisenges.” ");
INSERT INTO pma_vpl VALUES ("K112_8","012_12_8","1KI","12","8","8","Ka asuv houlu Rehoboam mundem maen selusien onen elda keil enek. Ka va suk vis rendemien onen meatin hau keil koa amoul vituai. ");
INSERT INTO pma_vpl VALUES ("K112_9","012_12_9","1KI","12","9","9","Kei vis keil vit, “?Mukave? ?Meteisauen sa mihesani minau keke ir reheha rehehiteni min meatin keil enek koa avis nau keke nikulat tei umen ran keil?” ");
INSERT INTO pma_vpl VALUES ("K112_10","012_12_10","1KI","12","10","10","Meatin hau keil enek avit risi mini avit, “Kiha kihiteni min meatin keil enek kihit, ‘!Kami mimundemi keke tata onak vi meatin takeih, ka inau nakeih tamun muli! !Anatin, hovorakiki ten hek matetel imok mulin horan tata onak! ");
INSERT INTO pma_vpl VALUES ("K112_11","012_12_11","1KI","12","11","11","Tata onak sakin kami mimum keih mini, ka inau nisan umen koa keih tamun heha min kami. Kei mutah kami en viau takeih, ka inau nitah kami en aovan koa tisa mok.’” ");
INSERT INTO pma_vpl VALUES ("K112_12","012_12_12","1KI","12","12","12","Navong avong etel muli, Sereboam ka meatin vasi keil umai ris ven asuv houlu Rehoboam suval koa viteni min keil. ");
INSERT INTO pma_vpl VALUES ("K112_13","012_12_13","1KI","12","13","13","Ka navong mai kistal en meatin keil enek, asuv houlu romusiltei meteisauen koa elda keil onen asani mini. Kei selus ral min vurohien va kat meatin keil ");
INSERT INTO pma_vpl VALUES ("K112_14","012_12_14","1KI","12","14","14","suval koa meatin hau keil aviteni mini. Sakini viteni min meatin keil vit, “Tata onak sakin kami mimum keih mini, ka inau nisan umen koa hekeih tamun heha min kami. Tata onak mutah kami en viau takeih, ka inau nitah kami en aovan koa tisa mok.” ");
INSERT INTO pma_vpl VALUES ("K112_15","012_12_15","1KI","12","15","15","Iahova varei sakin rendemien onen asuv houlu Rehoboam keih keke rolongtei selusien onen me-Isrel keil. Koanek kistal vasakin selusien koa Iahova sani min provet Ahisah ten out Saeloh keke vasani min Sereboam, natin Nebat, vamai vahi anatin. ");
INSERT INTO pma_vpl VALUES ("K112_16","012_12_16","1KI","12","16","16","Navong meatin keil alei kilea keke asuv houlu Rehoboam sakras valong selusien one, keil aselus keih mini avit, “!Komai mehertotei mun en hen koakeil aka en vatiamal onen Deved! !Anatin, mehermusiltei mun koakeil akistal ran natin Tiese! ?Keil asan asa varei min ir? !Tounah tovuol! !Me-Isrel keil, rovaha ris teim! !Rehelokovein meatin ekek helosil kat koakeil akistal ran vatiamal kati onen enges!” Sakini, me-Isrel keil aviles eisile rani, ka aretasil uva ris teim se. ");
INSERT INTO pma_vpl VALUES ("K112_17","012_12_17","1KI","12","17","17","Ka Rehoboam mai vi asuv houlu onen koakeil akistal aka en vatiamal onen Sudah enges. ");
INSERT INTO pma_vpl VALUES ("K112_20","012_12_20","1KI","12","20","20","Navong me-Isrel keil alonge keke Sereboam mai ris ran out Isip, alah ruai out tas ka asilsil eni emai. Ka en avong enek, avati lati mai vi asuv houlu onen me-Isrel keil. Ka meatin keil koa akistal en mari vatiamal onen Sudah, keil enges amules amusil asuv houlu Rehoboam koa ka en vatiamal onen Deved. ");
INSERT INTO pma_vpl VALUES ("K112_25","012_12_25","1KI","12","25","25","Navong meatin keil avati lat Sereboam mai vi asuv houlu one, kei va ro en taon ten out Sekem koa mul en vatihou keil en provins ten out Efrem. En out enek, kei sakin meatin keil onen avoumon vieh takeih tai vakarahiti. Evus, va en taon ten out Penuel, ka en out enek emun, amumon vieh takeih karahiti. ");
INSERT INTO pma_vpl VALUES ("K112_26","012_12_26","1KI","12","26","27","Avati vahis muli, ka asuv houlu Sereboam mundemko ka mundemi vit, “Munak meatin keil onak iha en out Serusalem lises keke avaha netan min Iahova en Eim Votut onen ka isan sanien votut one mini, keil indem ris asuv houlu Rehoboam ten out Sudah koa ka en vatiamal onen Deved. Anatin, keil ihiles ka u vini nau, ka usil risi suk.” ");
INSERT INTO pma_vpl VALUES ("K112_28","012_12_28","1KI","12","28","28","Sakini Sereboam vis rendemien onen meatin sav keil keke houmon sa. Ka musil rendemien one, vis meatin tei keke avoumon nana elu (2) en gol koa lukur niniven buluk. Navong amumoni evus, lah ruain meatin keil onen ka viteni min keil vit, “Me-Isrel keil, kami miva en out Serusalem lises keke mivaha netan eni. !Ka ahi onami keiek! !Koakeilu ekek lulah lat kami ran out Isip!” ");
INSERT INTO pma_vpl VALUES ("K112_29","012_12_29","1KI","12","29","29","Kei kur nana tai ka lingi mul en taon ten out Betel, ka nana tamun lingi en taon ten out Dan. ");
INSERT INTO pma_vpl VALUES ("K112_30","012_12_30","1KI","12","30","30","Sakini, me-Isrel keil koa uva Betel keke avaha netan min tai en nana keilu enek, ka tei en keil uva soutin en taon ten out Dan keke avaha netan min nana tamun. Ka sakien koanek mai vi mari tisaen tai en me-Isrel keil. ");
INSERT INTO pma_vpl VALUES ("K112_31","012_12_31","1KI","12","31","31","Ka Sereboam vis tei en meatin keil onen keke avoumon ahor onen ahi savsav keil en hoi hou keil. Evus, lei kan meatin keil ran vatiamal keil keke avamai avahi pris keil teni. Ka pris keil enek arkistaltei ran mari vatiamal onen Livae koa vi votut. Navong asuv houlu Sereboam mul losil kat mari vatiamal halualim (10) onen me-Isrel keil en out not, asuv houlu Rehoboam ro en out Serusalem ka mul losil kat me-Sudah keil sua teindan oulu (17) en out saot. Ka navong asuv houlu Rehoboam losil kat me-Sudah keil, houlu en meatin keil onen uva netan min ahi savsav keil ka Iahova maen me-Isrel keil umai uvae ral min keil ka alah lat tounah houlu koa tetahos ran Eim Votut ka ran mari eim omon asuv houlu. Ka sua houlu, asuv houlu keilu enek lumules luvae. En usite onen me-Sudah keil en out saot, navong Rehoboam mat, natnali kur vulin mai vi asuv houlu one, isen Abitsa. Kei losil kat meatin keil onen sua etel (3) enges, ka kei mun mul vae ral min asuv houlu Sereboam. Navong Abitsa mat, natnali koa isen Asa kur vulin. Asuv houlu Asa vi more meatin tai koa musil kat Iahova, Ahi onen Deved. Kei losil kat me-Sudah keil sua hanumau elu ka tai mun (41). Ka, en losilkatien onen, kei mu rasilin ahor ka nana keil onen ahi savsav keil. Ka lisenges, kei mun vae ral min asuv houlu onen me-Isrel keil. Ka navong Asa mat, natnali Sehosavat kur vulin mai vi asuv houlu onen me-Sudah keil. Ka en usite onen me-Isrel keil en out not, navong Sereboam mat, natnali Nadab mai kur vulin. Sakien keil onen tisa revi mok en meten Ahi, ka losil kat me-Isrel keil sua elu enges (2). Evus, meatin tai, isen Basa, mai ka mu vini Nadab ka titi amal kati keil vasi onen. Evus, kei kur vulin mai vi asuv houlu onen me-Isrel keil ka losil kat keil sua hanumau tai ka ehat emun (24). Navong Basa mat, natnali koa isen Elah kur vulin ka losil kat me-Isrel keil sua elu enges (2). Evus, en avong tai, meatin tavaeen tai koa isen Simri, kei mea, mu vini Elah, ka ling kei sasen mai vi asuv houlu. Kei mulomal en hiasuvien onen wik tas, ka me-Isrel keil aseseini. Sakini, avati lat avat sav tavaeen koa isen Omri keke vamai vahi asuv houlu one. Ka navong Simri longlong eni, kei mu vini kei sasen enges. Evus, asuv houlu Omri losil kat me-Isrel keil sua teindan elu (12). Ka navong mat, natnali Ehab kur vulin mai vi asuv houlu ka losil kat me-Isrel keil sua hanumau tai ka elu mun (22). ");
INSERT INTO pma_vpl VALUES ("K116_30","012_16_30","1KI","16","30","30","En avong koa asuv houlu Ehab losil kat me-Isrel keil en usite koa not, kei mum tisa en meten Iahova mulin asuv houlu savsav keil koa amulomal mulamu en kei. ");
INSERT INTO pma_vpl VALUES ("K116_31","012_16_31","1KI","16","31","31","Anatin keke musil sakien tatisa keil onen asuv houlu Sereboam telamu, ka kei mumon tounah koa tisa revi mok. Kei kur natnahin asuv houlu Etbal ten out Saedon mai vi ahin onen, isen Sesebel. Ka ahin enek sakin kei va netan min ahi Baal. ");
INSERT INTO pma_vpl VALUES ("K116_32","012_16_32","1KI","16","32","32","Kei mumon ahor onen ahi Baal en out Sameria, ka va netan mini en out enek. ");
INSERT INTO pma_vpl VALUES ("K116_33","012_16_33","1KI","16","33","33","Ka tamun, asuv houlu Ehab meng kat meatin keil onen avoumon nana tai onen ahi Astata koa vi ahin. Sakien tisa keil ekek onen sakin Iahova, Ahi onen me-Isrel keil, vuroh kati mok mulin asuv houlu sav keil koa amulamu eni. ");
INSERT INTO pma_vpl VALUES ("K117_1","012_17_1","1KI","17","1","1","En avong enek, provet tai ro en taon ten out Tisbe en atan ten out Kilead, isen Ilaetsa. Ahi sila va selus min asuv houlu Ehab vit, “Inau koa nuva netan min Iahova koa moul, Ahi onen me-Isrel keil, navit meseini minuk en isen keke ous hermustei mun ka tilep hetovuol sua vahis hetokol avong koa inau nihiteni.” ");
INSERT INTO pma_vpl VALUES ("K117_2","012_17_2","1KI","17","2","2","Navong selus min Ehab evus, Iahova viteni min Ilaetsa vit, ");
INSERT INTO pma_vpl VALUES ("K117_3","012_17_3","1KI","17","3","3","“Kimea ran out ekok ka kiha en usite koa ist hetokol Poal Kerat koa mul en ist ten Oaisal Sodan. En out enek, kito suai keke asuv houlu Ehab hervotintei keik. ");
INSERT INTO pma_vpl VALUES ("K117_4","012_17_4","1KI","17","4","4","Titi oaisal en poal enek hesan oai minuk kimuni, ka nameng kat aman keil koa avise keil en ‘revan’ keke imai ikur anien am.” ");
INSERT INTO pma_vpl VALUES ("K117_5","012_17_5","1KI","17","5","5","Sakini, Ilaetsa mumoni suval koa Iahova meng kati mini. Kei va ro en out enek. ");
INSERT INTO pma_vpl VALUES ("K117_6","012_17_6","1KI","17","6","6","Ka en visokon ka mendilah vasi keil, mun oai en titi oaisal ka revan keil alah veret ka vuseri an mai. ");
INSERT INTO pma_vpl VALUES ("K117_7","012_17_7","1KI","17","7","7","Ro mukonek avati vahis va vio … titi oaisal enek memes esuk, veni ous tovuol varei. ");
INSERT INTO pma_vpl VALUES ("K117_8","012_17_8","1KI","17","8","8","Navong oai omon provet Ilaetsa vus, Iahova viteni mini vit, ");
INSERT INTO pma_vpl VALUES ("K117_9","012_17_9","1KI","17","9","9","“Kosa, kiha en meteimal ten out Serafat, vesesal en taon ten out Saedon koa romultei en atan onen me-Isrel keil. En out enek, nameng kat vatina tai koa rovitei ahin Isrel keke hesan anien minuk.” ");
INSERT INTO pma_vpl VALUES ("K117_10","012_17_10","1KI","17","10","10","Sakini Ilaetsa va en out Serafat, ka navong mai vesesal en meteau ten taon, votin vatina tai koa mul lah ruain angosis. Navong lesi, visi vit, “?Kokilea kovasan etai hati oai minau?” ");
INSERT INTO pma_vpl VALUES ("K117_11","012_17_11","1KI","17","11","11","Ka navong vatina va vakuri, Ilaetsa viso vit, “Ka kikur etai hati veret emun niani.” ");
INSERT INTO pma_vpl VALUES ("K117_12","012_17_12","1KI","17","12","12","Ka vatina vit risi mini vit, “!Aue li! Nasakras. Navat kati li anatin en isen Iahova, Ahi onom koa moul, veret tovuol emun eli teim. Asa koa mul teim, kap pulaoa tas koa mul en pesin teni, ka hati oel koa havivis mul en veite, ka anien sav keil tovuol varei li. Numai ekok malah ruain angosis keitel ekek keke niha ris teim, nisak mesein hati anien vahi anien ekor eli amal min natkuli. Hevus, amai heat vini komal heha vio … melhematmat esuk.” ");
INSERT INTO pma_vpl VALUES ("K117_13","012_17_13","1KI","17","13","13","Ilaetsa vit risi mini vit, “Konandemkotei. Kiha kumon asa koa koviteni. Ka helamu, kumon hati veret tai ka kikur risi hemai minau. Hevus, hati koa mul, kumoni hehi amil min natmali. ");
INSERT INTO pma_vpl VALUES ("K117_14","012_17_14","1KI","17","14","14","Kiha kumon asa koa naviteni veni Iahova, Ahi onen me-Isrel keil viteni vit, ‘Pulaoa sakras vavus ran pesin koanek, ka veioel sakras vamemes vio … inau, Iahova, nisakin ous hous hekas tounah vasi en out netan.’” ");
INSERT INTO pma_vpl VALUES ("K117_15","012_17_15","1KI","17","15","15","Sakini, vatina va ris teim sen ka mumon asa koa Ilaetsa viteni mini. Ka lesi keke, anatin eli, anien vinvin min keitel vasi ten avong enek, ka ten avong houlu emun. ");
INSERT INTO pma_vpl VALUES ("K117_16","012_17_16","1KI","17","16","16","Suval koa Iahova viteni min Ilaetsa, pulaoa sakras vavus ran pesin, ka veioel sakras vamemes. ");
INSERT INTO pma_vpl VALUES ("K117_17","012_17_17","1KI","17","17","17","Avati vahis muli, ka natin vatina koanek mesai. Mesaien koanek muasi va vio … sehien onen vus varei ka mat. ");
INSERT INTO pma_vpl VALUES ("K117_18","012_17_18","1KI","17","18","18","Sakini vatina enek mai les Ilaetsa ka viteni mini vit, “!Aue li! ?Meatin onen Ahi, vensa komumon koanek minau? ?!Mukave, keik kumai venau kovasakin inau mandem ris tisaen keil onak, ka kovoumon natkuli vamat!?” ");
INSERT INTO pma_vpl VALUES ("K117_19","012_17_19","1KI","17","19","19","Sakini, Ilaetsa viteni mini vit, “San natmali minau.” Kulati ran hen mama onen, vousi vina nesa en teim va en out tamatilien onen, ka lingi matil en avet onen. ");
INSERT INTO pma_vpl VALUES ("K117_20","012_17_20","1KI","17","20","20","Evus, kei mis ven Iahova vit, “?O Iahova, Ahi onak eli, vensa kopurun moulien onen vatina koanek? Kei lei kat revi nau, ka keik, kokulat moulien onen natnali. ?!Vensa komumon koanek!?” ");
INSERT INTO pma_vpl VALUES ("K117_21","012_17_21","1KI","17","21","21","Evus Ilaetsa retengeiril netan ka mutelan hen keilu en aven ehon enek. Mumoni mukonek hatte etel ka vis min Ahi vit, “!O Iahova, Ahi onak eli, san moulien onen ehon ekek vamai ris eni!” ");
INSERT INTO pma_vpl VALUES ("K117_22","012_17_22","1KI","17","22","22","Ka Iahova long hisien onen Ilaetsa ka san heite ten hisien onen. Sakini ehon enek leh ris eang ka moul. ");
INSERT INTO pma_vpl VALUES ("K117_23","012_17_23","1KI","17","23","23","Evus, Ilaetsa leh lat ehon enek, vousi va, san risi min mama onen ka viteni mini vit, “!Les visi! !Natmali moul enges!” ");
INSERT INTO pma_vpl VALUES ("K117_24","012_17_24","1KI","17","24","24","Sakini vatina enek vit kesi mini vit, “!Namasmasuk houlu mok! Kosa nalei kilea keke keik kovi meatin tai onen Ahi, ka selusien onen Iahova koa kistal ka en ongom vi anatin.” ");
INSERT INTO pma_vpl VALUES ("K118_1","012_18_1","1KI","18","1","1","Avati vahis muli. Ka navong ous romustei rokol sua etel (3), Iahova viteni min Ilaetsa vit, “Ha lomal en meten asuv houlu Ehab. Hevus, inau numon ous hous.” ");
INSERT INTO pma_vpl VALUES ("K118_2","012_18_2","1KI","18","2","2","Sakini, Ilaetsa va en out Sameria keke valesi. Out enek memes imok mulin out sav keil ka anien an meatin keil tovuol. ");
INSERT INTO pma_vpl VALUES ("K118_17","012_18_17","1KI","18","17","17","Navong asuv houlu Ehab les provet Ilaetsa, viteni mini vit, “?!Ei, vensa komul kopurun meatin keil ten out Isrel!?” ");
INSERT INTO pma_vpl VALUES ("K118_18","012_18_18","1KI","18","18","18","Ka Ilaetsa vit kesi mini vit, “!Vuo! Rovitei inau keke mal mapurun meatin keil. Keik varei, ral min amal onen tata onom keke mimul mipurun me-Isrel keil. Veni kami misesein mengkatien keil onen Iahova ka miva netan min nana keil ka ahi Baal. ");
INSERT INTO pma_vpl VALUES ("K118_19","012_18_19","1KI","18","19","19","Kosa, kimeng kat me-Isrel keil imai out hetas en Vatihou Karmel. Ka kimeng kat provet keil onen ahi Baal koa avi handred ehat hanumau elu ka halualim emun (450) keke imai hetal min provet handred ehat (400) onen ahi Astata, koa ahin onom Sesebel mul san anien min keil.” ");
INSERT INTO pma_vpl VALUES ("K118_20","012_18_20","1KI","18","20","20","Sakini, asuv houlu Ehab san mengkatien min me-Isrel keil ral min provet keil emun, ka keil vasi umai out tas en Vatihou Karmel. ");
INSERT INTO pma_vpl VALUES ("K118_21","012_18_21","1KI","18","21","21","Evus, Ilaetsa mai mulomal en meten meatin keil ka viteni vit, “?Rendemien onami elu hevus nengeis? !Munak mimundemi keke Iahova vi Ahi anatin, miheha netan enges mini! !Ka munak mimundemi keke Baal vi ahi anatin, miheha netan mini enges!” Ka meatin keil aro raeng. ");
INSERT INTO pma_vpl VALUES ("K118_22","012_18_22","1KI","18","22","22","Evus, Ilaetsa vit risi min keil vit, “En provet keil onen Iahova, inau nges namul veah namoul. Ka provet keil onen ahi Baal avi handred ehat hanumau elu ka halualim emun (450). ");
INSERT INTO pma_vpl VALUES ("K118_23","012_18_23","1KI","18","23","23","Mihelamun buluk helu (2) koa meahos luhemai. Provet keil onen ahi Baal ilei kan tai, uasi, itetehei, ka ilingi en ahor ten sanien votut one. Ka keil irmunittei en ahang. Ka inau mun, numoni vatte hetas en tamun en buluk keilu enek. ");
INSERT INTO pma_vpl VALUES ("K118_24","012_18_24","1KI","18","24","24","Hevus, provet keil onen ahi Baal ihis min ahi one, ka inau, nihis min Iahova. Isei en ahi keilu enek hesan ahang hemita hean lin sanien onen, kei varei vi Ahi anatin.” Ka navong meatin keil along selusien onen, keil asi keil veni ka amaeni. ");
INSERT INTO pma_vpl VALUES ("K118_25","012_18_25","1KI","18","25","25","Evus, Ilaetsa viteni min provet keil vit, “Kami mihoumoni helamu veni kami mivi houlu. Mihelei kan buluk onami ka mihesak meseini hehi sanien votut onami. Hevus, mihehis ahi onami ka minalingtei ahang en sanien onami.” ");
INSERT INTO pma_vpl VALUES ("K118_26","012_18_26","1KI","18","26","26","Sakini provet keil enek uva aso ruain ahat keil mai vi ahor ten sanien votut one. Evus, amulamun buluk one emai, asak meseini, ka alingi en ahor. Evus, visokon va rokol taviai, keil uvol rahit ahor enek ka amis va min ahi Baal avit, “!O Baal, kilong komai!” Ka ahi one roselustei min keil, kei romumon etai tounah. ");
INSERT INTO pma_vpl VALUES ("K118_27","012_18_27","1KI","18","27","27","Evus, en taviai, Ilaetsa selus karen keil vit, “?!Ei mukave, ahi onami vi anatin vuo …!? ?Nahi kei mul rendem usil tounah sav, vuo va en klosis, vuo kei mual va en out sav tai? ?Nahi mul matil? !Kami mihesisil eni, tahos imok mihehis hekeih tamun!” ");
INSERT INTO pma_vpl VALUES ("K118_28","012_18_28","1KI","18","28","28","Sakini provet keil avis keih tamun. Ka musil sakien keil one, keil arei ave en naef ka asal keil en metas keil va vio … rae mul mue. ");
INSERT INTO pma_vpl VALUES ("K118_29","012_18_29","1KI","18","29","29","Keil amumon verien one va rokol mendilah, ka ahi one ro raeng enges, roselustei ka romumon etai tounah. ");
INSERT INTO pma_vpl VALUES ("K118_30","012_18_30","1KI","18","30","30","Evus, Ilaetsa viteni min meatin keil vit, “Almai vesesal venau.” Ka navong umai veni, en mete, kei va, mum revi ahor ten sanien onen Iahova koa merangle tuetin. ");
INSERT INTO pma_vpl VALUES ("K118_31","012_18_31","1KI","18","31","31","Kei lah ruain ahat teindan elu (12), mal en mari vatiamal keil onen me-Isrel keil koa akistal aka en Siekob mulamu, koa Iahova ling isen vi ‘Isrel.’ ");
INSERT INTO pma_vpl VALUES ("K118_32","012_18_32","1KI","18","32","32","Ral min ahat keil enek, kei sak revi ahor ten sanien en isen Iahova. Evus, kei kil rahit ahor enek rokol avong koa kilea vasieni en oai koa lita teni valin hanumau elu (40). ");
INSERT INTO pma_vpl VALUES ("K118_33","012_18_33","1KI","18","33","33","Evus, kei ling av en ahor, muas buluk onen, ra kotehei, ka lingi nesa en av. Evus, viteni min meatin keil onen vit, “Mihesien marmari veioai hehat, ka mihemai mihetahi hememer en sanien hetal av teni.” Sakini, keil amumoni. ");
INSERT INTO pma_vpl VALUES ("K118_34","012_18_34","1KI","18","34","34","Evus, viteni min keil vit, “Hatte tai ris.” Ka amumoni. Ka vit risi vit, “Mihoumoni hatte tai ris.” Sakini amumoni hatte etel eni. ");
INSERT INTO pma_vpl VALUES ("K118_35","012_18_35","1KI","18","35","35","Oai kas vasin ahor enek ka mue vita en atan, sien avul koa kei kili va vio … mue lei. ");
INSERT INTO pma_vpl VALUES ("K118_36","012_18_36","1KI","18","36","36","Navong sak mesein tounah vasi onen, vi mendilah, avong mal ten sanien. Ka Ilaetsa mai vesesal en ahor ka vis vit, “O Iahova, Ahi onen Ebraham, onen Aesak, ka onen Siekob, kosa, kitie min komai keke keik kovi Ahi onen me-Isrel keil. Ka kitie min komai keke keik korie lat nau numai navi meatin toumien onom ka namumon tounah keil enek musil rem. ");
INSERT INTO pma_vpl VALUES ("K118_37","012_18_37","1KI","18","37","37","O Iahova, san heite ten hisien onak. Kisani vatie lati min meatin keil ekek keke keik enges kovi Iahova, Ahi anatin. Kisan ahang vatie lati min keil keke em vati kovahiles moulien one avousiluk eris.” ");
INSERT INTO pma_vpl VALUES ("K118_38","012_18_38","1KI","18","38","38","Hatte tas, Iahova san ahang ka nesa mita netan, kan lin vasi sanien, av teni, ahat keil, atan, ka oai emun. ");
INSERT INTO pma_vpl VALUES ("K118_39","012_18_39","1KI","18","39","39","Navong meatin keil alesi, keil vasi umot avita netan ka avisohiso avit, “!Iahova, kei vi Ahi anatin! !Iahova, kei enges vi Ahi!” ");
INSERT INTO pma_vpl VALUES ("K118_40","012_18_40","1KI","18","40","40","Evus, Ilaetsa meng kat meatin keil vit, “!Alha alhuli kat provet keil onen Baal! !Minamaen etai en keil nalohosai!” Sakini meatin keil avuli kat keil vasi. Evus, Ilaetsa mulamun keil uva en Poal Kison, ka en out enek, amu vinvini provet keil vasi onen Baal. ");
INSERT INTO pma_vpl VALUES ("K118_41","012_18_41","1KI","18","41","41","Evus, Ilaetsa va selus min asuv houlu Ehab vit, “Kimea, kiha kianian ka kimun hati uaen veni hervitei tuetin, rehelong ous hous.” ");
INSERT INTO pma_vpl VALUES ("K118_42","012_18_42","1KI","18","42","42","Navong Ehab va vaanian, Ilaetsa vina en hoite ten Vatihou Karmel. Ekonek, retengeiril vita netan ka veinan rokol atan. ");
INSERT INTO pma_vpl VALUES ("K118_43","012_18_43","1KI","18","43","43","Kei viteni min meatin toumien onen vit, “Ha lele hehita netan en atas.” Sakini, kei va lele ka mai ris viteni mini vit, “Narles etai tounah.” Ilaetsa sila va hatte oulu (7). ");
INSERT INTO pma_vpl VALUES ("K118_44","012_18_44","1KI","18","44","44","Ka en ualien kor onen, navong meatin toumien enek mai ris, viteni vit, “Nales mahmah tai koa alesi havivi suval hen meatin mul mea ran atas.” Evus, Ilaetsa viteni mini vit, “Ha les asuv houlu Ehab. Kihiteni mini keke hekalah hepar kat kat en hos keil osen ka heloh eni heha lah teim keke ous nating koe sise onen.” ");
INSERT INTO pma_vpl VALUES ("K118_45","012_18_45","1KI","18","45","45","Rovitei tuetin, mahmah keil koa vopoli mul koe teilang, eang mea, ka ous mus houlu vis houlu mok. Sakini Ehab vut en kat ten hos onen ka muloh va en taon ten out Sesrehel. ");
INSERT INTO pma_vpl VALUES ("K118_46","012_18_46","1KI","18","46","46","Ka Ilaetsa, keihoen onen Ahi mai sieni. Kei lum kat kele eisin omon koa taveah mai nesa ka mutoh eni. Evus, muloh vis muloh mulin hos osen Ehab, ka rokol taon ten out Sesrehel mulamu eni. ");
INSERT INTO pma_vpl VALUES ("K119_1","012_19_1","1KI","19","1","1","Navong Ehab muris va vales ahin onen, Sesebel, run mini usil tounah keil koa Ilaetsa mumoni, ka mukave mu vinvini provet keil vasi onen ahi Baal ral min naef tavaeen. ");
INSERT INTO pma_vpl VALUES ("K119_2","012_19_2","1KI","19","2","2","Sakini, Sesebel tin tisa houlu ka san selusien va min Ilaetsa vit, “Navat kati keih keke nuasuk kimat hesuval koa komumoni min provet onak keil. Ka navong nirmumontei heha hetokol mendilah visuvong, ahi onak keil akilea uas nau nimat.” ");
INSERT INTO pma_vpl VALUES ("K119_3","012_19_3","1KI","19","3","3","Navong Ilaetsa kur longlongien koanek, kei metau houlu ka lohosai. Keilu meatin toumien onen, luva en taon ten out Bersiba en atan onen me-Sudah keil. Evus, Ilaetsa va ling meatin toumien onen en out enek, ");
INSERT INTO pma_vpl VALUES ("K119_4","012_19_4","1KI","19","4","4","ka, visokon rokol mendilah, kei mual sasen enges va en out volvol. Evus, rondan en nimal ten vatiai tai ka longe tisa, vit vamat enges. Sakini vis Ahi vit, “!O Iahova, moulien onak keih varei ka ek rovattei mun mamoul! Tahos imok kikulat moulien onak ka kuas inau nimat.” ");
INSERT INTO pma_vpl VALUES ("K119_5","012_19_5","1KI","19","5","5","Navong vis evus, kei matil en nimal ten vatiai koanek ka matil usae. Hatte tas, angelo tai mita rokoli ka viteni mini vit, “Mea, anian.” ");
INSERT INTO pma_vpl VALUES ("K119_6","012_19_6","1KI","19","6","6","Navong Ilaetsa lele rahiti, kei les veret ral veioai tai mul vesesal ven vatin. Sakini kuri, kani ka muni. Evus, kei matil eris. ");
INSERT INTO pma_vpl VALUES ("K119_7","012_19_7","1KI","19","7","7","Evus, hatte tai ris, angelo onen Iahova mita rokoli ka vit, “Mea, anian. Munak kirkaniantei, ualien onom hekeih ramat minuk.” ");
INSERT INTO pma_vpl VALUES ("K119_8","012_19_8","1KI","19","8","8","Sakini, Ilaetsa mea, kanian ka mun hati oai. Anien enek san keihoen mini voual en meneai ka vongien. Avong hanumau elu (40) romusehtei, mual va vio … rokol Vatihou Senae koa vi vatihou votut onen Ahi. ");
INSERT INTO pma_vpl VALUES ("K119_9","012_19_9","1KI","19","9","9","En out enek, kei votin valengeihat tai, ka va matil ien. Evus, Iahova selus mini vit, “?Ilaetsa, komul komumon sa ekok?” ");
INSERT INTO pma_vpl VALUES ("K119_10","012_19_10","1KI","19","10","10","Ka kei vit kesi mini vit, “O Iahova, Ahi ten out nesa, en moulien vasi onak, namum keih minuk. Ka me-Isrel keil aviles eisile ran hatkatien takeih koa komumoni ral min keil. Amu lin ahor ten sanien keil onom, ka amu vinvini provet keil vasi onom en naef tavaeen. !Inau sasok namoul, ka keil avit avouas inau mun mamat!” ");
INSERT INTO pma_vpl VALUES ("K119_11","012_19_11","1KI","19","11","11","Sakini Iahova viteni mini vit, “Ha hae, kilomal en hoi hou keke kiles nau navong nimai nili.” Ka navong ro veah en valengeihat, Ilaetsa long eang takeih tai mea koa sakin hou keil apas ka muti lin ahat keil … ka Iahova romultei ien. Navong eang va, Ilaetsa long alu tai kulul … ka Iahova romultei ien. ");
INSERT INTO pma_vpl VALUES ("K119_12","012_19_12","1KI","19","12","12","Alu vus, Ilaetsa les ahang tai kistal ka mukan … ka Iahova romultei ien. Ahang evus, kei long rea tai koa mul selus merau. ");
INSERT INTO pma_vpl VALUES ("K119_13","012_19_13","1KI","19","13","13","Ka navong Ilaetsa longe, kei ling suain nan en kot omon ka va hae, mulomal en metareh ten valengeihat. Ka en out enek, rea koanek viteni mini vit, “?Ilaetsa, komul komumon sa ekok?” ");
INSERT INTO pma_vpl VALUES ("K119_14","012_19_14","1KI","19","14","14","Ka kei vit kesi mini vit, “O Iahova, Ahi ten out nesa, en moulien vasi onak, namum keih minuk. Ka me-Isrel keil aviles eisile ran hatkatien takeih koa komumoni ral min keil. Amu lin ahor ten sanien keil onom, ka amu vinvini provet keil vasi onom en naef tavaeen. !Inau sasok namoul, ka keil avit avouas inau mun mamat!” ");
INSERT INTO pma_vpl VALUES ("K119_15","012_19_15","1KI","19","15","15","Evus, Iahova viteni mini vit, “Kiha ris, kusil sise onom. Kiha en out volvol en atan ten out Damaskas ka kihotin meatin tai, isen Hasael. Navong kovotini, kitah oel en vatin vatie lati keke kei hemai hehi asuv houlu ten out Siria. ");
INSERT INTO pma_vpl VALUES ("K119_16","012_19_16","1KI","19","16","16","Hevus, kihotin meatin tamun, isen Sehu, natin Nimsi, ka kitah oel en vatin vatie lati keke hemai hehi asuv houlu onen me-Isrel keil. Evus, kiha en meteimal ten out Ebel Mehola, ka kihotin Elisa, natin Savet. Kitah oel emun en vatin vatie lati keke kei hemai hekesuk hesuval provet onak. ");
INSERT INTO pma_vpl VALUES ("K119_17","012_19_17","1KI","19","17","17","Navat kati keke koa keitel ekek telhou motein kantri onak hetal naef tavaeen oneatel. Koakeil alohosai ran naef onen asuv houlu Hasael, Sehu houas keil imat. Ka koakeil alohosai ran naef onen Sehu, Elisa suk houas keil imat. ");
INSERT INTO pma_vpl VALUES ("K119_18","012_19_18","1KI","19","18","18","Ka avaseini koanek hekur out, inau naring koe meatin keil taosen oulu (7000) amoul veni keil amul amusil kat nau. Koakeil enek, arvatei veah netan min ahi Baal ka armusmustei veah nana keil onen.” ");
INSERT INTO pma_vpl VALUES ("K119_19","012_19_19","1KI","19","19","19","Sakini Ilaetsa va, ka votin Elisa, natin Savet. Kei mul mum en mari ah tai ral min meatin sav keil koa amul aviles atan en aho keil koa buluk keil alehei. Vangi buluk teindan elu (12) amul amum lualu. Ka koa katau en keil vasi, mul en hen Elisa. Sakini, Ilaetsa mai vesesal veni ka muli. Ka navong muli, kei son kot omon mutaluh koe, vatie lati keke lei kan kei vousili ka vakesi. ");
INSERT INTO pma_vpl VALUES ("K119_20","012_19_20","1KI","19","20","20","Hatte tas, Elisa lokovein buluk keilu osen ka muloh musili ka visi vit, “?Nakilea maselus kor min tata ka mama onak? Hevus, nusiluk.” Ka Ilaetsa vit kesi mini vit, “Tahos. Narring koetei keik. Kiha mau kumoni ka kindem usil asa koa namumoni minuk.” ");
INSERT INTO pma_vpl VALUES ("K119_21","012_19_21","1KI","19","21","21","Sakini, Elisa va ris ven buluk keilu osen, muas keilu lumat, ka rei pahas kat koa lulehei vahi av. Evus, lengas buluk keilu ka sani min meatin keil akani. Navong akanian evus, Elisa mea ka musil Ilaetsa suval meatin takataunien onen. ");
INSERT INTO pma_vpl VALUES ("K22_7","013_2_7","2KI","2","7","7","Navong lumul lumual luva, provet sav keil koa avi hanumau elu ka halualim emun (50) amusil keilu uva en Oaisal Sodan. En out enek, Ilaetsa keilu Elisa lumulomal vesesal en oaisal enek, ka provet sav keil amulomal soutin neli ran keilu. ");
INSERT INTO pma_vpl VALUES ("K22_8","013_2_8","2KI","2","8","8","Evus, Ilaetsa kulat kot omon, lum kati, ka muas oaisal eni. Navong muasi mukok, oai maseh elu. Sakini, keilu lumu koteh oai en atan tames, luva en usite. ");
INSERT INTO pma_vpl VALUES ("K22_9","013_2_9","2KI","2","9","9","Navong lurokol usi oaisal, Ilaetsa viteni min Elisa vit, “Hervitei tuetin, Ahi hekulat nau nilokoveinuk. Sakini helamu, hetahos keik kihiten asa em vati moumoni minuk.” Elisa vit kesi mini vit, “Ek vati kovasan tei keihoen onom minau helin provet sav keil keke nikesuk nikur vulum.” ");
INSERT INTO pma_vpl VALUES ("K22_10","013_2_10","2KI","2","10","10","Ka Ilaetsa viteni mini vit, “Asa komul kovis inau eni vi tounah koa keih keke masani. Ka munak Ahi hemaenuk kiles sise koa hekulat nau nilokoveinuk eni, keik kikur asa koa kovisi. Ka munak kirlestei nau navong nilokoveinuk, keik kirkurtei.” ");
INSERT INTO pma_vpl VALUES ("K22_11","013_2_11","2KI","2","11","11","Ka navong keilu lumul luselus ka lumual luva, hatte tas, ahang tai ka nesa suval kat koa hos lehei. Muloh luhu en keilu ka kat koanek kur Ilaetsa va en out nesa en eang tai koa karali. ");
INSERT INTO pma_vpl VALUES ("K22_12","013_2_12","2KI","2","12","12","Navong Elisa lesi, kei vis keih va min Ilaetsa vit, “!Ilaetsa, tata onak eli! !O tata onak eli! Keik koa kolei kokoe en komai, me-Isrel keil, ral keihoen onom koa mulin hos ka kat keil tavaeen, kosa kolokovein komai.” Ka navong Elisa rolestei mun, rangisi ka rali vas eisin omon. ");
INSERT INTO pma_vpl VALUES ("K22_13","013_2_13","2KI","2","13","13","Evus, les kot omon Ilaetsa koa mot rani. Kuri ka va ris mulomal en usi Oaisal Sodan. ");
INSERT INTO pma_vpl VALUES ("K22_14","013_2_14","2KI","2","14","14","Sakini, vuli kat kot enek ka viteni vit, “?!Iahova, Ahi onen Ilaetsa, koro venau vuo!?” Evus, muas oaisal en kot enek, ka oai maseh va en usite keilu. Sakini, Elisa mual kotehei va ris en usite. ");
INSERT INTO pma_vpl VALUES ("K22_15","013_2_15","2KI","2","15","15","Vangi provet keil koa aka en out Seriko amul amulomal soutin neli. Ka navong keil alesi, avit, “!Alles tei mau! !Keihoen onen provet Ilaetsa mai sien Elisa!” ");
INSERT INTO pma_vpl VALUES ("K24_1","013_4_1","2KI","4","1","1","Avong tai, vatina tai mai ven provet Elisa ka viteni mini vit, “Asuv, meatin onak koa vi tai en provet onom kei mat tuai. Keik kokilea keke kei vi meatin koa vouhou min Iahova. Navong kei mul semau moul, vis meatin tai en mani. Ka kosa, meatin koa san mani enek mini, mai les nau keke vakur titiali elu onak luvahi slev onen vahul lat kaon onen meatin onak.” ");
INSERT INTO pma_vpl VALUES ("K24_2","013_4_2","2KI","4","2","2","Elisa viteni min vatina enek vit, “?Em vati makataunuk vamukave? ?Kihiteni minau, asa kovuli kati mul teim?” Vatina vit kesi mini vit, “Tounah tovuol. Veioel ten olip tanges mul.” ");
INSERT INTO pma_vpl VALUES ("K24_3","013_4_3","2KI","4","3","3","Sakini Elisa viteni mini vit, “Kiha ven meatin keil koa aro vesesal venuk, ka kihis keil keke avasan veioel keil minuk koa avi heite hon. Kilahi hehi houlu. ");
INSERT INTO pma_vpl VALUES ("K24_4","013_4_4","2KI","4","4","4","Hevus, keik hetal min natmali keilu, mitheha en eim ka mitheoteh kat voiteh. Hevus, kitah oel heha en veioel keil enek. Navong kitah oel heha en tai hehil, kilingi heles ka kikur teisav. Kumoni hemukonek heha vio … keil vasi ihilelau.” ");
INSERT INTO pma_vpl VALUES ("K24_5","013_4_5","2KI","4","5","5","Sakini, vatina enek va ka mum usil selusien onen. Kei va teim ral min natnali keilu ka telkoteh en voiteh. Evus, kur titi veioel onen, ka mutah oel teni va en veioel keil koa natnali keilu lulahi lumai lusani mini. ");
INSERT INTO pma_vpl VALUES ("K24_6","013_4_6","2KI","4","6","6","Navong telsien veioel keil enek vil, vatina vis keilu en veioel tamun. Ka tai en natnali keilu viteni mini vit, “Mama, veioel tovuol emun.” Mal en hati avong enek, oel memes revi varei. ");
INSERT INTO pma_vpl VALUES ("K24_7","013_4_7","2KI","4","7","7","Evus, vatina enek muris va les provet Elisa, ka provet viteni mini vit, “Kiha, ihul lat oel enek ranuk ka kihul kaon onom. Ka hati mani koa heles, hevinvin hekataunuk ka natmali keilu.” ");
INSERT INTO pma_vpl VALUES ("K25_1","013_5_1","2KI","5","1","1","En kantri ten out Siria, avat tai tavaeen mul ien, isen Neman. Ka en hen meatin enek, Iahova mumon meatin tavaeen keil ten kantri ten out Siria uvae mulin kantri sav keil. Ven koanek, asuv houlu ten out Siria vouhou mini ka mumoni mai vi mari hetamen tai. Ka avaseini keke Neman kur eis tai koa marite, mesaien ten leprosi mul purun vasi aven. ");
INSERT INTO pma_vpl VALUES ("K25_2","013_5_2","2KI","5","2","2","Avong tai, meatin keil tavaeen onen uva en taon tai onen me-Isrel keil keke avahenan tounah keil ran keil, ka en avong enek, avuli kat atouli tai one. Evus, asani min Neman mai vi slev onen ahin onen. ");
INSERT INTO pma_vpl VALUES ("K25_3","013_5_3","2KI","5","3","3","Avong tai, atouli enek viteni min ahin onen Neman vit, “Namundemi keke tahos asuv onak vaha vales vis provet onomai ten out Isrel koa mul en provins ten out Sameria. Kei kilea vasak revi aven keke mesaien ten leprosi enek vavus rani.” ");
INSERT INTO pma_vpl VALUES ("K25_9","013_5_9","2KI","5","9","9","Navong Neman longe, kur meatin onen vahis amusili ka amuloh en kat keil onen koa hos keil osen alehei ka uva avales provet Elisa. Ka navong arokol teim sen, amulomal vesesal en voiteh. ");
INSERT INTO pma_vpl VALUES ("K25_10","013_5_10","2KI","5","10","10","Ka provet Elisa sila meatin toumien onen va vahit meseini min Neman keke heha hemarindu en kei en Oaisal Sodan hatte hehi oulu (7). Kei viteni mini keke munak houmoni, mesaien ten leprosi hetovuol emun ka aven hemai ris hetolas. ");
INSERT INTO pma_vpl VALUES ("K25_11","013_5_11","2KI","5","11","11","Navong Neman longe, tin katiat ka vut va en kat onen ka va. Kei viteni min meatin keil onen vit, “!Inau navi hetamen tai! Namundemi keke provet enek hesital heles inau nges. Namundemi keke helomal hehis min Iahova, Ahi onen, ka hetelan hen en out koa mesaien ten leprosi mul ien keke hesak revi avek heto. !Ka vuo! !Kei romumon etai tounah! ");
INSERT INTO pma_vpl VALUES ("K25_12","013_5_12","2KI","5","12","12","En out kati onak en out Damaskas, Oaisal Abana ka Oaisal Parpar lumul ien. Koakeilu enek lutahos imok mulin oaisal keil vasi koa mul en atan ten out Isrel. ?Vensa nasakras makul en tai en koakeilu enek keke avek vamai ris vato?” ");
INSERT INTO pma_vpl VALUES ("K25_13","013_5_13","2KI","5","13","13","Meatin toumien keil onen umai veni ka aviteni mini avit, “Asuv, munak provet enek visuk kovoumon etai tounah takeih, keik kumon asas koa viteni. ?Ka mukave? ?Kosakras kovaha kovamarindu en keik en oaisal enek vasuval koa kei viteni minuk keke avem vamai vato ris?” ");
INSERT INTO pma_vpl VALUES ("K25_14","013_5_14","2KI","5","14","14","Sakini, Neman maeni ka va en Oaisal Sodan. Kei mual vita en oai ka marindu en kei eni hatte oulu (7) suval asa koa provet Elisa viteni mini. Navong kei mea ran oai, lesi keke aven vasi mutolas. Hiliven mai ris tahos suval hiliven titiali tai. ");
INSERT INTO pma_vpl VALUES ("K25_15","013_5_15","2KI","5","15","15","Navong lesi mukok, kei muris ral min meatin keil onen uva avales Elisa. Kei viteni min Elisa vit, “Kosa nakilea suk keke ahi sav tovuol emun. Ahi onen me-Isrel keil, kei tas moul.” ");
INSERT INTO pma_vpl VALUES ("K217_5","013_17_5","2KI","17","5","5","Navong asuv houlu Hosea onen me-Isrel keil mules en eim takeih en out Asiria, asuv houlu Salmanesa ten out Asiria mai ral min meatin keil tavaeen onen keke avavae vatal min me-Isrel keil. Umai akarahit mari taon ten out Sameria suval vieh keke me-Isrel keil asakras avamea rani. Amumoni mukonek sua etel (3) varei. ");
INSERT INTO pma_vpl VALUES ("K217_6","013_17_6","2KI","17","6","6","Sakini, en keite ten sua etel enek, en sua ouhat (9) ten losilkatien onen asuv houlu Hosea, me-Isrel keil koa aro en mari taon ten out Sameria amaen keil uva en hen asuv houlu ten out Asiria. Sakini, me-Asiria keil amulamun keil uva en kantri one ka asakin keil umai avi slev keil one. Keil koa, aling keil aro en taon ten out Halah, keil koa mun, aling keil aro vesesal ven Oaisal Habor koa mul en atan ten out Gosan. Ka keil koa mun, aling keil aro en taon ten out Midia. ");
INSERT INTO pma_vpl VALUES ("K217_7","013_17_7","2KI","17","7","7","Iahova, Ahi onen me-Isrel keil koa lah lat keil ran hen asuv houlu ten out Isip mulamu, kei sakin me-Isrel keil uva amules en hen me-Asiria keil veni aviles eisile rani ka uva netan min ahi savsav keil. ");
INSERT INTO pma_vpl VALUES ("K217_8","013_17_8","2KI","17","8","8","Anatin, keil amusil sakien tatisa onen me-Kenan keil. Ka ven sakien tisa keil one varei, Iahova viteni min me-Isrel keil keke u rasilin keil ran atan enek ka ikuri suk hemai hehi one. Ka asuv houlu keil kati one varei amulamun keil en vati sakien tatisa keil enek. ");
INSERT INTO pma_vpl VALUES ("K217_9","013_17_9","2KI","17","9","9","Me-Isrel keil amum suai en tounah houlu koa romaltei en meten Iahova, Ahi one. En titi meteimal keil one va rokol mari taon keil one emun, me-Isrel keil amumon ahor houlu keke avaha netan min ahi savsav keil ien. ");
INSERT INTO pma_vpl VALUES ("K217_10","013_17_10","2KI","17","10","10","Ka en hoi hou vasi keil ka en nimal ten vatiai houlu, aling ahat votut keil ka nana keil onen ahi Astata koa vi ahin keke avatetengeiril min keil. ");
INSERT INTO pma_vpl VALUES ("K217_24","013_17_24","2KI","17","24","24","Asuv houlu ten out Asiria kur tei en meatin keil onen ran taon keil ten out Babilon, Kut, Iva, Hamat ka Separvaem ka sakin keil akur atan koa alah lati ran me-Isrel keil. Sakini, keil umai en atan ka taon keil ten out Sameria, ka aro ien suval out kati one. ");
INSERT INTO pma_vpl VALUES ("K217_25","013_17_25","2KI","17","25","25","Navong umai aro en out enek, arvatei netan min Iahova. Sakini, Iahova sila laeon keil umai akat vinvini tei en keil umat. ");
INSERT INTO pma_vpl VALUES ("K217_26","013_17_26","2KI","17","26","26","Longlongien teni va rokol asuv houlu ten out Asiria keke meatin keil koa ling keil en taon keil ten out Sameria arkileatei mengkatien keil vuo sakien keil onen ahi ten out enek. Sakini, ahi ten out enek sila laeon keil uva akat vinvini meatin keil onen umat. ");
INSERT INTO pma_vpl VALUES ("K217_27","013_17_27","2KI","17","27","27","Navong asuv houlu kur longlongien enek, kei meng kati vit, “Sila ris etai en pris keil ten out Isrel koa rolah lat keil ran atan koanek. Kei heha ris, heto hetal min meatin keil onak ka hehisein keil en mengkatien keil onen ahi ten out enek keke avousili.” ");
INSERT INTO pma_vpl VALUES ("K217_28","013_17_28","2KI","17","28","28","Sakini tai en pris keil ten out Isrel koa alah lat keil ran out Sameria, kei mai ris ro en taon ten out Betel. Ka en out enek, visein meatin keil en sise koa akilea avaha netan min Iahova ien. ");
INSERT INTO pma_vpl VALUES ("K217_29","013_17_29","2KI","17","29","29","Ka avaseini, vangi meatin savsav keil koa amul en atan enek amules uva netan min nana keil one musil sakien matu one. Keil uva aling nana keil ten kantri kati one amul en ahor keil koa me-Isrel keil amumoni en hoi hou keil koa mul vesesal en taon keil ten out Sameria. ");
INSERT INTO pma_vpl VALUES ("K218_1","013_18_1","2KI","18","1","1","Navong asuv houlu Hosea, natin Elah, losil kat me-Isrel keil sua etel (3), me-Sudah keil avati lat Hesekaea, natin Ehas, mai vi asuv houlu one. ");
INSERT INTO pma_vpl VALUES ("K218_2","013_18_2","2KI","18","2","2","Navong mai vi asuv houlu, kei, sua onen vi hanumau tai ka elim emun (25). Kei ro en out Serusalem ka losil kat meatin keil ten out Sudah sua hanumau tai ka ouhat emun (29). Mama onen, isen Abitsa koa vi natnahin Sakaraea. ");
INSERT INTO pma_vpl VALUES ("K218_3","013_18_3","2KI","18","3","3","Asuv houlu Hesekaea mumon sakien keil koa mal en meten Iahova suval avu onen telamu, asuv houlu Deved. ");
INSERT INTO pma_vpl VALUES ("K218_4","013_18_4","2KI","18","4","4","Kei mu rasilin ahor onen ahi savsav keil, kopahas ahat votut keil vi soksokeite, ka ra kokoteh nana keil onen ahi Astata. Ka tamun, kei kopahas tetal koa Mosis mumoni en brons koa me-Sudah keil avise en ‘Nahustan’ veni keil uva netan veni ka amunit senta keil vi sanien one mini. ");
INSERT INTO pma_vpl VALUES ("K218_5","013_18_5","2KI","18","5","5","Hesekaea ling desien onen keih en Iahova, Ahi onen me-Isrel keil. Losilkatien onen tahos imok mulin losilkatien onen koakeil amulamu eni, vuo koakeil akatau eni. ");
INSERT INTO pma_vpl VALUES ("K218_6","013_18_6","2KI","18","6","6","Musil kat Iahova ka rolong rastei ren. Kei kur kat revi mengkatien keil vasi koa Ahi sani min Mosis mulamu. ");
INSERT INTO pma_vpl VALUES ("K218_7","013_18_7","2KI","18","7","7","Sakini, Iahova ro veni ka mumon tounah vasi koa Hesekaea mumoni mai tahos. Asuv houlu Hesekaea long sesein ren asuv houlu ten out Asiria ka en rovattei valong kati. ");
INSERT INTO pma_vpl VALUES ("K218_8","013_18_8","2KI","18","8","8","Kei va ral min meatin tavaeen keil onen uva amulin me-Filistia keil en out vasi koa amul ien, en titi meteimal keil koa amul vesesal ven keil va rokol mari taon keil one en out Gasa. Navong asuv houlu Hesekaea mat, natnali Manase mai kur vulin. ");
INSERT INTO pma_vpl VALUES ("K221_1","013_21_1","2KI","21","1","1","Navong me-Sudah keil aling Manase, natin Hesekaea, mai vi asuv houlu one, sua onen vi teindan elu (12). Kei ro en taon ten out Serusalem ka losil kat meatin keil onen sua hanumau elu ka teindan elim emun (55). Ka mama onen, isen Hepsiba. ");
INSERT INTO pma_vpl VALUES ("K221_2","013_21_2","2KI","21","2","2","Asuv houlu Manase mum tisa en meten Iahova veni musil sakien tatisa keil onen meatin keil koa Iahova mu rasilin keil ran atan enek keke vasani suk min me-Isrel keil. ");
INSERT INTO pma_vpl VALUES ("K221_3","013_21_3","2KI","21","3","3","Kei va en hoi hou keil ka mum revi ahor keil onen ahi savsav keil koa tata onen, Hesekaea, kopahas keil mulamu. Kei mumon ahor onen ahi Baal keke meatin keil avaha netan mini, ka sakin tei en meatin keil amumon nana tai onen ahi Astata suval asa koa asuv houlu Ehab mumoni mulamu. Ka Manase va netan min meteiai, avati ka hitu keil emun. ");
INSERT INTO pma_vpl VALUES ("K221_4","013_21_4","2KI","21","4","4","Mumon ahor keil emun onen ahi sav keil neim en Eim Votut onen Iahova varei, out koa Ahi vit isen hel ien lisenges. ");
INSERT INTO pma_vpl VALUES ("K221_5","013_21_5","2KI","21","5","5","Ka hae en Eim Votut enek, en out ten sanien varei, kei mumon ahor keke vaha netan min meteiai, avati ka hitu keil emun ien. ");
INSERT INTO pma_vpl VALUES ("K221_6","013_21_6","2KI","21","6","6","Kei mu vini natnali ka muniti vi sanien tai onen min ahi sav tai. Kei mumon eimas ka vis koakeil ales sise, koakeil avi lingling temat, ka koakeil emun aselus min ninin tisa keil keke vailea asa koa hemai hekistal. Sakien keil ekek atisaso revi mok en meten Iahova ka sakin kei vuroh kat asuv houlu Manase. ");
INSERT INTO pma_vpl VALUES ("K221_10","013_21_10","2KI","21","10","10","Iahova selus ka en provet onen keil koa avi meatin toumien onen vit, ");
INSERT INTO pma_vpl VALUES ("K221_11","013_21_11","2KI","21","11","11","“Sakien keil onen asuv houlu Manase atisaso mok mulin sakien tatisa keil onen me-Amor keil koa aro en atan enek mulamu. Kei sakin me-Isrel keil umot en tisaen navong uva netan min nana keil koa kei ling keil en vulie. ");
INSERT INTO pma_vpl VALUES ("K221_12","013_21_12","2KI","21","12","12","Sakini, inau, Iahova, Ahi onen me-Isrel keil, nisan mahien tai koa hemariso vis hemariso mok hemai heha kat meatin keil ten out Serusalem ka Sudea. Ka longlongien keil teni hesakin koakeil ilonge, e hehon eni. ");
INSERT INTO pma_vpl VALUES ("K221_13","013_21_13","2KI","21","13","13","Anatin, nisan mahien min meatin keil ten out Serusalem, hesuval koa namumoni min meatin keil ten out Sameria. Numoni en keil hesuval koa namumoni min asuv houlu Ehab ten out Isrel navong keil amu vinvini vasi ehon keil ten amal onen. Anatin, inau nikulat vasi meatin keil ran out Serusalem ka out enek hemai heto hesuval pelet tai koa amumoteini muto ka avovoh eni. ");
INSERT INTO pma_vpl VALUES ("K221_14","013_21_14","2KI","21","14","14","Avaseini munak tei en meatin onak keil imoul ilohosai, inau nilokovein keil ka nisan keil iha en hen vativieh keil one. Anatin, koakeil avi vativieh keil one ihuli kat keil ka ilah tounah keil one hehi one. ");
INSERT INTO pma_vpl VALUES ("K221_15","013_21_15","2KI","21","15","15","Numon koanek min meatin keil onak veni keil amules amumon tisaen en metok ka asakin nau tinok vepeng houlu kat keil. Meatin keil enek amules amumoni mukok minau en avong avu one keil alokovein out Isip mai rokol kosa.” ");
INSERT INTO pma_vpl VALUES ("K221_16","013_21_16","2KI","21","16","16","En moulien onen asuv houlu Manase, kei sakin me-Sudah keil uva netan min ahi savsav keil ka amum tisa houlu en meten Iahova. Ka en meten Ahi emun, kei mumon taon ten out Serusalem vilelau en ran meatin tetahos keil koa kei mu vinvini keil. Asuv houlu Manase va en eim takeih en out Babilon ka, en out enek, rendemien onen va netan ka lei kilea suk tisaen keil onen. Sakini, Ahi maeni vaha ris Serusalem. ");
INSERT INTO pma_vpl VALUES ("K221_19","013_21_19","2KI","21","19","19","Navong Amon mai vi asuv houlu ten out Sudah, sua onen vi hanumau tai ka elu mun (22). Mama onen, isen Mesulemet, natnahin Harus ten out Sotbah. Asuv houlu Amon losil kat me-Sudah keil en out Serusalem ten sua elu nges (2). ");
INSERT INTO pma_vpl VALUES ("K221_20","013_21_20","2KI","21","20","20","Kei mumon tounah koa tisa en meten Iahova suval koa tata onen Manase mumoni mulamu. ");
INSERT INTO pma_vpl VALUES ("K221_21","013_21_21","2KI","21","21","21","Kei musil vasi sakien tatisaso keil onen tata onen: nana keil koa tata onen va netan mini, kei mun va netan mini. ");
INSERT INTO pma_vpl VALUES ("K221_22","013_21_22","2KI","21","22","22","Asuv houlu Amon sesein Iahova, Ahi onen avu onen tata keil one telamu, ka romusiltei sakien keil koa Iahova en vati. ");
INSERT INTO pma_vpl VALUES ("K221_23","013_21_23","2KI","21","23","23","Ka en avong tai, hetetamen keil onen asuv houlu Amon aviles mini, ka amuasi mat en teim sen. ");
INSERT INTO pma_vpl VALUES ("K221_24","013_21_24","2KI","21","24","24","Ka meatin keil ten out Sudah amuas hetetamen keil esuk enek, ka aling natin Amon kur vulin vahi asuv houlu one, isen Sosaea. ");
INSERT INTO pma_vpl VALUES ("K222_1","013_22_1","2KI","22","1","1","Navong me-Sudah keil aling Sosaea vi asuv houlu one, sua onen vi outel (8) enges. Mama onen, isen Sededah, natnahin Adaea ten out Boskat. Ka Sosaea losil kat me-Sudah keil en taon ten out Serusalem sua hanumau tai ka teindan tai mun (31). ");
INSERT INTO pma_vpl VALUES ("K222_2","013_22_2","2KI","22","2","2","Sosaea mumon sakien keil koa mal ka Iahova si houlu veni. Kei musil sakien tetahos keil onen avu onen, asuv houlu Deved, mumoni mulamu, ka musil kat revi mengkatien keil vasi onen Iahova. Navong asuv houlu Sosaea losil kat me-Sudah keil, kei meng kat meatin keil toumien onen avoum revi ris Eim Votut onen Iahova. Ka navong amul amumoni, keil avotin tus tai koa mengkatien keil onen Mosis mul ien. Sakini, keil akuri uva asani min asuv houlu Sosaea, ka meatin tai onen vuli mini raengoni. ");
INSERT INTO pma_vpl VALUES ("K222_11","013_22_11","2KI","22","11","11","Navong Sosaea long selusien keil koa avuli en tus enek, kei longe tisa houlu ka rali vas eisin omon veni kei kilea suk keke kei ral min meatin onen keil amul soutin ran asa koa Iahova en vati. ");
INSERT INTO pma_vpl VALUES ("K222_12","013_22_12","2KI","22","12","12","Evus, kei san selusien va min meatin keil ekek: pris Hilkia, Ahikam (natin Safan), Akbor (natin Mikaeah), Safan (klak onen asuv houlu), ral min Asaea (meatin takataunien onen asuv houlu). Ka navong umai, asuv houlu Sosaea meng kat keil vit, ");
INSERT INTO pma_vpl VALUES ("K222_13","013_22_13","2KI","22","13","13","“Miheha mihehis min Iahova venau ka ven me-Sudah keil usil selusien keil koa mul en tus koanek. Nakilea keke Iahova tin vepeng houlu kat ir ka hesan mahien min ir veni avu orer keil telamu arlong kattei selusien keil koa mul en tus koanek ka armumtei vousili.” Evus, Sosaea sila meatin keil enek uva ales ahin tai koa vi provet onen Ahi, isen Hulda. ");
INSERT INTO pma_vpl VALUES ("K222_16","013_22_16","2KI","22","16","16","Sakini provet Hulda san selusien va min asuv houlu vit, “Koanek vi selusien onen Iahova, ‘Anatin keke inau nipurun meatin keil ten out Serusalem hesuval selusien keil koa asuv houlu vuli en tus koanek. ");
INSERT INTO pma_vpl VALUES ("K222_17","013_22_17","2KI","22","17","17","Numon koanek veni meatin keil aseseinau ka uva netan min ahi sav keil ka asan sanien votut one va min keil. Sakien tisa keil one sakinau tinok vepeng houlu va kat keil. Anatin, vurohien onak mariso va kat me-Serusalem keil ka sakras vaha netan.’” ");
INSERT INTO pma_vpl VALUES ("K222_18","013_22_18","2KI","22","18","18","Evus, provet Hulda vit risi vit, “Ka min asuv houlu koa san kami mimai, mihehiten selusien koanek onen Iahova usil selusien keil koa kei longe en tus enek, ");
INSERT INTO pma_vpl VALUES ("K222_19","013_22_19","2KI","22","19","19","‘Navong kolong selusien keil onak keke nipurun out Serusalem hetal min meatin keil teni, keik komundemko houlu ka komumon rendemien onom va netan en metok. Anatin, navong kolonge keke inau numon taon koanek hemai hehi out ten sesendaen keke tounah hetovuol hemoul ien, keik, korali vas eisin omom ka komurang mai venau. Sakini, inau, Iahova, nalong hisien onom. ");
INSERT INTO pma_vpl VALUES ("K222_20","013_22_20","2KI","22","20","20","Ka mahien koa nisani hemai heha kat Serusalem, hermaitei mau kosa en avong keil koa keik komoul veah. Nimaenuk kimat en tomat.’” ");
INSERT INTO pma_vpl VALUES ("K223_1","013_23_1","2KI","23","1","1","Asuv houlu Sosaea vise ruain hetetamen keil vasi ten out Sudah ka Serusalem. ");
INSERT INTO pma_vpl VALUES ("K223_2","013_23_2","2KI","23","2","2","Evus, kei va en teahu ten Eim Votut onen Iahova ral min pris keil, provet keil ka meatin keil vasi ten out Sudah ka Serusalem, koakeil avi hetetamen va rokol koakeil avi meatin kuren enges. Navong alah ruai, Sosaea mulomal ka vuli vasin selusien keil koa amul en Tus ten Hatkatien Takeih onen Ahi koa avotini en Eim Votut. ");
INSERT INTO pma_vpl VALUES ("K223_3","013_23_3","2KI","23","3","3","Evus, kei va mulomal vesesal en vatiseng ten Eim Votut ka kei mumon hatkatien takeih tai ral min Iahova. Asuv houlu Sosaea vat kati keke housil Iahova lises, helong kat mengkatien keil onen hetal moulien vasi onen, ka houm vasi tounah keil ten mengkatien koa amutisi mul en tus koanek. Evus, meatin vasi keil emun avat kati keke usil kat hatkatien takeih enek hetal min Iahova. ");
INSERT INTO pma_vpl VALUES ("K223_4","013_23_4","2KI","23","4","4","Evus, asuv houlu Sosaea san mengkatien onen min Hilkia koa vi asuv houlu onen pris keil ral min tei en pris keil onen ka meatin keil taleikokoeien ten Eim Votut keke avalah lat tounah keil koa meatin keil amul uva netan eni min ahi Baal, min ahi Astata, ka min meteiai, avati ka hitu keil vaha ran Eim Votut onen Iahova. Keil alah lati mai hae en out Serusalem, ka asuv houlu san ahang kan lin keil vasi. Evus, kei lah lat vulimeas teni eva en taon ten out Betel. Katau en tounah keil ekek, asuv houlu Sosaea va en out vasi en atan ten out Sudah ka Isrel keke vou lin ahor keil onen ahi savsav keil ka vou vini pris keil teni. Asuv houlu Sosaea losil kat me-Sudah keil sua teindan outel (18) ka kei musil kat Iahova ka mengkatien keil onen. Evus, kei mat en vaeen tai. Ka asuv houlu keil koa umai akatau en Sosaea, keil arvouhoutei min Iahova. Keil amumon tounah houlu tisa en meten. ");
INSERT INTO pma_vpl VALUES ("R233_10","015_33_10","2CH","33","10","10","Ka avaseini Iahova sel kat Manase ral min meatin keil onen, keil e rovattei avalonge. ");
INSERT INTO pma_vpl VALUES ("R233_11","015_33_11","2CH","33","11","11","Sakini, Iahova maen avat keil tavaeen ten out Siria umai uvae ral min me-Sudah keil ka amulin keil. Keil avuli kat asuv houlu Manase ka arili vas vulingasin en huk tai. Evus, keil apar kati ral sen koa vi brons ka amulamuni uva en mari taon one ten out Babilon. ");
INSERT INTO pma_vpl VALUES ("R233_12","015_33_12","2CH","33","12","12","En avong ten mahien onen, Manase lei kilea suk en sise onen ka mumon rendemien onen va netan. Kei mul peah Iahova ven kataunien, Ahi onen avu onen keil telamu. ");
INSERT INTO pma_vpl VALUES ("R233_13","015_33_13","2CH","33","13","13","Ka navong kei vis mini, Iahova long isien onen, en mahisi, ka san heite ten hisien onen mini. Ahi maeni va ris Serusalem ka ling risi valosil kat meatin keil onen. Sakini Manase mundem kilea suk keke Iahova enges vi Ahi anatin. ");
INSERT INTO pma_vpl VALUES ("R233_15","015_33_15","2CH","33","15","15","Asuv houlu Manase va en Eim Votut onen Iahova, ka kulat nana keil ral min ahor ten sanien onen ahi savsav keil koa kei ling keil ien. Evus, kei va lah lat ahor sav keil koa kei lingi en Hou Saeon ka hou savsav keil vesesal en out Serusalem. Navong kei mumoni evus, lah ruain keil ka revin keil uva soutin ran taon onen. ");
INSERT INTO pma_vpl VALUES ("R233_16","015_33_16","2CH","33","16","16","Evus, kei mum revi ahor votut onen Iahova ka munit buluk ka sipsip keil avi sanien votut ten lahruaien ral sanien votut keil ten masmasien vaha mini. Katau suk, asuv houlu Manase meng kat meatin vasi keil ten out Sudah keke iha netan min Iahova koa vi Ahi onen me-Isrel keil. ");
INSERT INTO pma_vpl VALUES ("R233_17","015_33_17","2CH","33","17","17","Katau en avong enek, meatin keil amules avina en hoi hou keil keke avaha netan ka avasan sanien votut keil one ien, ka amumoni va min Iahova enges. ");
INSERT INTO pma_vpl VALUES ("R233_20","015_33_20","2CH","33","20","20","Sua keil muli, asuv houlu Manase mat, ka uva arahini vesesal en mari eim omon. Evus, natnali Amon kur vulin mai vi asuv houlu onen me-Sudah keil. ");
INSERT INTO pma_vpl VALUES ("R236_14","015_36_14","2CH","36","14","14","Hetetamen keil onen me-Sudah keil, pris keil ka meatin vasi keil amules amusil sakien tatisa keil suval meatin keil ten kantri sav keil amul amumoni, ka tisaen keil one vilelau ka vasi out. Ka Eim Votut onen Iahova koa kei varei mumoni vi votut, keil amumoni mai vilehilu en meten. ");
INSERT INTO pma_vpl VALUES ("R236_15","015_36_15","2CH","36","15","15","Avaseini keil amumon koanek, Iahova, Ahi onen avu one keil, lises san provet keil onen avasel kat keil veni kei en mahis meatin keil onen ka en rovattei vapurun Eim Votut onen. ");
INSERT INTO pma_vpl VALUES ("R236_16","015_36_16","2CH","36","16","16","Ka keil amumon karien va kat eiloheh keil onen Ahi, asesein selusien keil onen, ka aviteai karen provet keil onen. Amumoni mukok va vio … vurohien onen Ahi mariso va kat keil ka sakras emun vaha netan. ");
INSERT INTO pma_vpl VALUES ("R236_17","015_36_17","2CH","36","17","17","Sakini, Iahova san asuv houlu ten out Babilon va vae ral min keil, isen Nebukanesa. Kei mu vinvini litetai keil ten out Sudah, ral koakeil emun aro suai en Eim Votut onen Ahi. Ahi en romahis etai meatin. Ehon keil ral min atouli keil, meahos keil ral min atou keil, koakeil amesai ka koakeil ave tahos, ka ulmatu ka tovuli keil emun, Ahi mumon keil vasi uva en hen asuv houlu Nebukanesa ten out Babilon. ");
INSERT INTO pma_vpl VALUES ("R236_18","015_36_18","2CH","36","18","18","Ka Nebukanesa ral min meatin keil onen alah vuol en tounah vasi keil onen me-Sudah keil: tounah keil en Eim Votut onen Iahova ral mani keil koa mul ien, ka tounah keil vasi koa mul en mari eim onen asuv houlu ral min eim keil onen hetetamen keil onen. Tounah vasi keil onen me-Sudah keil, me-Babilon keil akuri vi one suk. ");
INSERT INTO pma_vpl VALUES ("R236_19","015_36_19","2CH","36","19","19","Keil aling ahang kan lin Eim Votut onen Ahi, amu lin vieh koa karali taon ten out Serusalem ral min more eim keil onen asuv houlu ral min hetetamen keil onen. Tounah keil koa arlahtei, aling ahang kan lin vasi. ");
INSERT INTO pma_vpl VALUES ("R236_20","015_36_20","2CH","36","20","20","Me-Sudah keil vasi koa armu vinitei keil ka amoul amules, me-Babilon keil alah keil uva en out ose keke avoumon keil avahi slev keil one ka onen ehon one keil koa ikatau. Sakini, me-Sudah keil amules en hen me-Babilon keil rokol avong koa asuv houlu ten out Persia mai vae mulin keil ka tounah one mai vi onen. ");
INSERT INTO pma_vpl VALUES ("R236_21","015_36_21","2CH","36","21","21","En sakien enek, selusien koa Iahova sani min provet Seremaea mai vi anatin koa vit, “Atan ekek hehi heite hon, meatin hetovuol houm ien hetokol sua hanumau etel ka halualim emun (70), hemal en sua keil koa arali koteh Sabat keil ien.” ");
INSERT INTO pma_vpl VALUES ("R236_22","015_36_22","2CH","36","22","22","Navong asuv houlu Saeros ten out Persia kur rohtoh en keihoen onen, Iahova mumon selusien koa sani min provet Seremaea mai vi anatin. Ahi sakin asuv houlu Saeros vasan mengkatien tai vaha en out vasi koa kei losil kati keke amutis selusien tai onen keke avahuli en meten meatin vasi keil onen koa vit, ");
INSERT INTO pma_vpl VALUES ("R236_23","015_36_23","2CH","36","23","23","“Koanek vi selusien onen Saeros, asuv houlu ten out Persia. Iahova, Ahi ten out nesa, ling kantri vasi keil ten out out netan en hek. Kei rie lat nau moumon Eim Votut onen en taon ten out Serusalem en atan ten out Sudah. Sakini, kosa, kami koa mivi meatin keil onen, mikilea mivaha ris en out Serusalem. En hisien keil onak, navis Iahova, Ahi onami, heto ven kami en ualien keil onami.” ");
INSERT INTO pma_vpl VALUES ("ER3_1","016_3_1","EZR","3","1","1","Me-Isrel keil uva ris en out kati one ka aling revi tounah keil one. Evus, en avati koa vi oulu (7) en sua koanek, keil vasi umai alah ruai out tas en taon ten out Serusalem. ");
INSERT INTO pma_vpl VALUES ("ER3_2","016_3_2","EZR","3","2","2","En out enek, Sosua (natin Sehosadak), pris sav keil, Serubabel (natin Seltil), ka tunali sav keil emun, keil amum revi ahor ten sanien votut onen Ahi onen me-Isrel keil. Amumoni keke avanit sanien votut keil one vaha min Ahi vasuval koa mengkatien keil onen Mosis viteni, kei koa vi meatin onen Ahi. ");
INSERT INTO pma_vpl VALUES ("ER3_3","016_3_3","EZR","3","3","3","Avaseini keke ametaun meatin savsav keil koa aro en out keil akarahit keil, me-Isrel keil amum revi ahor onen Ahi en out kati koa mul ien mulamu. Evus, en visokon ka mendilah vasi keil, umai amunit ris sanien votut keil one ien. ");
INSERT INTO pma_vpl VALUES ("ER3_7","016_3_7","EZR","3","7","7","Me-Isrel keil asan mani one keke avahul kapenda keil ka koakeil emun aling sosorin en ahat keil ten eim. Evus, keil alah ruain anien, uaen ka oel ten olip mai out tas, ka asani min me-Taer keil ka me-Saedon keil keke sip keil one avalah vati sida keil ran out Lebanon ka avasoni vaha ut en out Sopa vasuval koa asuv houlu Saeros ten out Persia meng kati. ");
INSERT INTO pma_vpl VALUES ("ER3_8","016_3_8","EZR","3","8","8","Navong avati oulu (7) muli va, Serubabel, Sosua, ral min pris sav keil ka koakeil emun akistal en vatiamal onen Livae, aling rendemien one keke avoum ris Eim Votut onen Iahova en out Serusalem. Sakini, arie lat meatin vasi keil koa akistal en vatiamal onen Livae koa sua one mulin hanumau tai (20) keke avalosil kat me-Isrel sav keil koa um en Eim Votut enek. Navong asak mesein tounah keil enek evus, me-Isrel keil umai alah ruai out tas ka amum rohtoh en umen hau ten Eim Votut onen Iahova. ");
INSERT INTO pma_vpl VALUES ("ER6_14","016_6_14","EZR","6","14","14","Avat keil onen me-Isrel keil amum keih en Eim Votut onen Iahova. Ka provet Hagae ka provet Sakaraea, lusan selusien ten kataunien min meatin keil. En sakien enek, keil amum vasin Eim Votut enek musil mengkatien onen Ahi onen me-Isrel keil, ka musil selusien koa Saeros, Derias ka Ataksekses, asuv houlu keitel ten out Persia telmeng kati. ");
INSERT INTO pma_vpl VALUES ("ER6_15","016_6_15","EZR","6","15","15","Sakini, en avong koa vi teindan elu (12) ten avati Mars, navong asuv houlu Derias losil kat kantri ten out Persia sua ahetai (6), me-Isrel keil amum vasi Eim Votut onen Ahi. ");
INSERT INTO pma_vpl VALUES ("ER6_16","016_6_16","EZR","6","16","16","Evus, me-Isrel keil koa umai ris ran out Babilon, keil umai alah ruai ral min pris keil ka koakeil emun akistal en vatiamal onen Livae. Keil aseh Eim Votut onen Ahi ka asan tokolkatien eni ral min sien. ");
INSERT INTO pma_vpl VALUES ("ER6_17","016_6_17","EZR","6","17","17","Keil amuas buluk handred tai (100), mari sipsip keil koa meahos handred elu (200), ka sipsip handred ehat (400) ka amunit keil avi sanien votut ten masmasien va min Ahi. Ka ven mari vatiamal teindan elu (12) onen me-Isrel keil amuas nani teindan elu (12) vakas motein meten Ahi keke hermundemtei mun tisaen keil one. ");
INSERT INTO pma_vpl VALUES ("NH8_1","017_8_1","NEH","8","1","1","Navong me-Isrel keil aro semau en out kati one avati oulu (7) tuai, en avong koa tai ten avati koanek, meatin keil alah ruai en taon ten out Serusalem en out ten lahruaien vesesal en meteau ten vieh koa avise en Meteau ten Vulioai. Navong alah ruai evus, avis Esra koa vi tiser tai ten mengkatien keil onen Mosis keke helah tus ten mengkatien keil onen Mosis koa Iahova sani min me-Isrel keil ka hehuli min keil. ");
INSERT INTO pma_vpl VALUES ("NH8_2","017_8_2","NEH","8","2","2","Sakini Esra lahi mai ven meatin keil ekek: amo keil, atou keil, ehon keil ka atouli keil emun koa akilea tounah. ");
INSERT INTO pma_vpl VALUES ("NH8_5","017_8_5","NEH","8","5","5","Esra mai mulomal en avet tai nesa, out koa meatin keil vasi akilea avalesi. Ka navong vue tus enek, keil amea amulomal. ");
INSERT INTO pma_vpl VALUES ("NH8_6","017_8_6","NEH","8","6","6","Evus, Esra viso keih min meatin keil enek vit, “!Mihemasmas Iahova, Ahi koa vi hetetamen imok!” Ka meatin keil akukuvin he vina nesa ka avit kesi avit, “!Anatin! !Anatin eli!” Evus, uva netan min Iahova, aretengeiril ka nae vita rokol atan. ");
INSERT INTO pma_vpl VALUES ("NH8_8","017_8_8","NEH","8","8","8","Evus, navong Esra mul vuli mengkatien keil onen Ahi en selusien ten Hibru, tei en pris keil avit leini min meatin keil en selusien ten Arameak ten out Babilon. Amumoni mukonek keke selusien teni vamai vailea revi en meatin keil koa akilea selusien ten Arameak. ");
INSERT INTO pma_vpl VALUES ("NH8_9","017_8_9","NEH","8","9","9","Navong meatin keil along kilea asa koa mengkatien onen Ahi mul viteni, keil alonge tisa houlu ka amurang veni akilea keke armusiltei. Sakini, Nehemaea koa vi meatin ten kavmen, pris Esra koa vi tiser ten mengkatien keil onen Ahi, ka koakeil akistal en vatiamal onen Livae koa amul avisein meatin keil aviteni avit, “Kami, me-Isrel keil, minalongtei natisa ka minatangtei mun. Kosa vi avong votut onen Iahova, Ahi onami.” ");
INSERT INTO pma_vpl VALUES ("NH8_10","017_8_10","NEH","8","10","10","Evus, Nehemaea viteni min keil vit, “Kosa, miheha ris teim sami, mihoumon ale tai. Ka mihesan tei anien ka uaen min koakeil anien ae rovinvintei. Mihoumoni hemukonek veni kosa vi avong votut onen Iahova, Ahi orer. Ven koanek, minalongtei mun natisa veni sien koa Iahova hesani min kami hesakin kami mihelomal hekeih, avaseini avong keil takeih imai.” ");
INSERT INTO pma_vpl VALUES ("NH8_12","017_8_12","NEH","8","12","12","Sakini, meatin keil vasi uva ris teim se ka akanian revi ka amun hati uaen, ka hati anien ae tei, asani va min meatin sav keil. Me-Isrel keil alonge tahos veni, kosa, keil along kilea selusien onen Ahi koa avuli min keil. ");
INSERT INTO pma_vpl VALUES ("NH8_13","017_8_13","NEH","8","13","13","En visokon, asuv keil ten mari vatiamal keil vasi onen me-Isrel keil, ral min pris keil ka koakeil akistal en vatiamal onen Livae, keil vasi umai ruai ven Esra, tiser ten mengkatien keil onen Ahi. Keil umai ris avalong vilei selusien koa mul en tus ten mengkatien keil onen Mosis. ");
INSERT INTO pma_vpl VALUES ("NH8_14","017_8_14","NEH","8","14","14","Ka navong kei mul vuli tus koa Mosis mutisi min keil, avotini keke Iahova meng kat me-Isrel keil keke umon votevav keil ome mal en avong amumon mari ale tai en avati koa vi oulu (7) ten sua vasi. ");
INSERT INTO pma_vpl VALUES ("NH8_15","017_8_15","NEH","8","15","15","Navong keil alonge mukok, asuv keil ral min meatin sav keil koa umai, asan selusien va min meatin keil ten out Serusalem ka meteimal sav keil avit, “Ir rehoumon votevav keil housil mengkatien keil onen Mosis. Sakini, miheha en hou keil ekek ka mihelah ai keil en vatiai keil koa amukok: vati olip, vati mertal, vati maman, vati paen, vati vipi ka vatiai savsav keil koa ouai keil amul ien.” ");
INSERT INTO pma_vpl VALUES ("NH8_16","017_8_16","NEH","8","16","16","Sakini, meatin keil along kati ka uva arei ai keil ka alah risi umai. Evus, keil amumon votevav keil ome en out vasi keil: nesa en hoi eim one koa vi aet, vuo neim en teahu one, vuo tei en meatin keil koa amumon ome vesesal ven Eim Votut onen Ahi. Ka koakeil koa mun, amumon ome en out ten lahruaien vesesal en Metareh ten Vulioai vuo en out ten lahruaien vesesal en Metareh onen Efrem. ");
INSERT INTO pma_vpl VALUES ("NH8_17","017_8_17","NEH","8","17","17","Meatin keil vasi koa akistal ran hen me-Babilon keil ka umai akur ris atan kati ose, keil vasi amumon votevav keil ka aro ien. Avong Sosua, natin Nun, mulamun rohtoh en me-Isrel keil avakur atan koanek rokol avong enek, keil armusiltei mengkatien koanek. Sakini, asi keil houlu veni alei kilea esuk sise one. ");
INSERT INTO pma_vpl VALUES ("NH8_18","017_8_18","NEH","8","18","18","Avong oulu (7), me-Isrel keil aro en votevav keil ome, ka en meneai vasi, alah ruai ka Esra vuli selusien ten tus ten mengkatien keil onen Mosis min keil. Ka en avong koa vi outel (8) en keil, umai out tas keke avoum ekor en ale enek vasuval koa mengkatien keil onen Mosis viteni. ");
INSERT INTO pma_vpl VALUES ("NH9_1","017_9_1","NEH","9","1","1","En avong koa vi hanumau tai ka ehat emun (24) ten avati oulu (7) koanek, me-Isrel keil umai ris alah ruai ka amusin en musi eisin keil, amukul en vulimeas, ka uval ran anien vatie lati min Ahi keke keil alonge tisa ven tisaen keil one ka tisaen keil koa avu one keil telamu amumoni. ");
INSERT INTO pma_vpl VALUES ("NH9_2","017_9_2","NEH","9","2","2","Koakeil avi me-Isrel keil kati, ariti vas keil ran meatin ten out sav keil, ka umai vituai. Keil amulomal ka avit lat tisaen keil one ka sakien tisa keil onen avu one keil telamu. ");
INSERT INTO pma_vpl VALUES ("NH9_3","017_9_3","NEH","9","3","3","Evus, keil vasi amulomal eris ka meatin tei avuli mengkatien keil onen Iahova min keil haoa etel (3). Evus, haoa etel (3) mun, keil avit lat tisaen one keil ka uva netan min Iahova, Ahi one. En avong enek, meatin tei keil koa akistal en vatiamal votut onen Livae arun usil tunien keil telamu ten vatiamal keil onen me-Isrel keil rokol avong keil koa amoul ien. Evus, keil amutis hatkatien one ral min Iahova keke usil kat revi mengkatien keil onen. Ka asuv keil onen meatin vasi keil ral min avat savsav keil one aling ise mul en vatie lati keke hatkatien enek vi one. ");
INSERT INTO pma_vpl VALUES ("NH11_1","017_11_1","NEH","11","1","1","En avong enek, asuv keil onen me-Isrel keil amundemi tahos keke avoum ris teim se keil en out Serusalem. Ka meatin sav keil amundemi tahos keke umon taet en meatin keil one koa akilea avato en out Serusalem, avoum revi taon votut onen Ahi. Sakini, aleh eis ten famle keil koa ito ien musil sakien koanek: en famle halualim (10) vasi keil onen me-Isrel keil, aleh isen famle tai. Ka koakeil arlehtei ise, keil uva amumon teim se keil en taon ka en meteimal sav. ");
INSERT INTO pma_vpl VALUES ("NH11_2","017_11_2","NEH","11","2","2","Ka munak meatin sav maen kei sasen keke vato en out Serusalem vakataun koakeil avoum revi taon koanek, meatin sav keil asan masmasien one min keil. ");
INSERT INTO pma_vpl VALUES ("JB1_1","019_1_1","JOB","1","1","1","En avong mulamu, meatin tai ro en kantri ten out Us, isen Siob. Ka kei musil kat Ahi ka va netan mini lises. Kei vi more meatin tai koa sakien onen mutolas, mul lei kat revi kei ka en rovattei voum vatisa. ");
INSERT INTO pma_vpl VALUES ("JB1_2","019_1_2","JOB","1","2","2","Natnali oulu (7) ka natnahin etel (3). ");
INSERT INTO pma_vpl VALUES ("JB1_3","019_1_3","JOB","1","3","3","Sipsip keil osen rokol taosen oulu (7000), kamel keil osen rokol taosen etel (3000), buluk keil osen taosen tai (1000), ka dongki keil osen avi handred elim (500). Meatin toumien keil onen emun avi houlu vis avi houlu mok. En out ist, kei varei vi meatin koa tounah onen houlu lohlin meatin savsav vasi keil. ");
INSERT INTO pma_vpl VALUES ("JB1_4","019_1_4","JOB","1","4","4","Natnali keil, lises amul amum retai en marmari anien keil. Navong tai en keil mumon anien en teim sen, kei sisil en tunali savsav keil ka ahinali keitel. Navong akanian ka amunmun evus, uva ris teim se. Ka rovitei tuetin, tateisav mumoni mukonetinek rokol koa oulu (7) en keil. ");
INSERT INTO pma_vpl VALUES ("JB1_5","019_1_5","JOB","1","5","5","Ka en avong vasi koa mari anien keil one evus, Siob san selusien va ven keil keke isak motein moulien one. Evus, en visokon semau katau en mari anien one, kei mea ka san retai en sanien min Ahi en usite one. Lises, Siob mumoni mukonek keke avato ris en meten Ahi, veni mundemi vit vahesa etai en keil mumon etai tounah koa romaltei en meten Ahi koa kei reingeingeni. ");
INSERT INTO pma_vpl VALUES ("JB1_6","019_1_6","JOB","1","6","6","En avong tai, en out nesa, angelo keil umai avati keil en meten Ahi Asuv. Ka Temat emun mul ral min keil. ");
INSERT INTO pma_vpl VALUES ("JB1_7","019_1_7","JOB","1","7","7","Ka Iahova visi vit, “?Keik, koka kave?” Temat vit risi mini vit, “Naka ko, nuva ko, ka namules naretoun en out netan.” ");
INSERT INTO pma_vpl VALUES ("JB1_8","019_1_8","JOB","1","8","8","Ahi visi vit, “?Keik koles more meatin toumien onak Siob? Meatin tovuol en out netan valong kat nau ka vatahos vasuval kei. Kei mul va netan minau ka losil kat revi kei keke romumon etai tounah vatisa.” ");
INSERT INTO pma_vpl VALUES ("JB1_9","019_1_9","JOB","1","9","9","Temat vit kesi mini vit, “?Mukave? ?Komundemi keke Siob heles heha netan minuk munak kikulat tokolkatien onom ran moulien onen? ");
INSERT INTO pma_vpl VALUES ("JB1_10","019_1_10","JOB","1","10","10","Lises, koring koe kei, onen keil ka tounah vasi keil onen. Korokol kat vasi tounah keil koa kei mumoni ka buluk, sipsip ka dongki keil emun osen avi houlu vis avi houlu mok, avilelau en out vasi. ");
INSERT INTO pma_vpl VALUES ("JB1_11","019_1_11","JOB","1","11","11","Ka munak kilah lat tounah keil enek rani, kosa etin, kei hesilik en metom.” ");
INSERT INTO pma_vpl VALUES ("JB1_12","019_1_12","JOB","1","12","12","Iahova viteni mini vit, “Tahos. Namaen tounah vasi keil onen hel en hem. Ka konatokolteis aven.” Evus, Temat mea va. ");
INSERT INTO pma_vpl VALUES ("JB1_13","019_1_13","JOB","1","13","13","En avong tai, natin Siob keil amul akanian ruai en teim sen tue koa moeite. ");
INSERT INTO pma_vpl VALUES ("JB1_14","019_1_14","JOB","1","14","14","Ka en avong enek, eiloheh tai muloh va ven Siob ka vit, “Memul memumon buluk keil osom amul akah atan, ka dongki keil osom emun amul akanian vesesal ven komai. ");
INSERT INTO pma_vpl VALUES ("JB1_15","019_1_15","JOB","1","15","15","Memutimanin, ka me-Saba keil umai, amu vinvini vasi meatin toumien onom keil ka avenan buluk ka dongki vasi keil. Inau sesuk nalohosai keke numai navit meseini minuk.” ");
INSERT INTO pma_vpl VALUES ("JB1_16","019_1_16","JOB","1","16","16","Navong mul veah selus, meatin toumien tamun onen mai ka vit, “Meatin toumien keil onom amul alei kat sipsip osom keil, ka ahil vil ka en out nesa, ka mita kan lin keil vasi. Inau sesuk nalohosai keke numai navit meseini minuk.” ");
INSERT INTO pma_vpl VALUES ("JB1_17","019_1_17","JOB","1","17","17","Kei mun roselus vasitei mau, meatin toumien tateisav mai ka vit, “Meatin tahenaien keil ten out Kaldea ariti vas keil en vangite etel ka amuloh ven komai. Asal vini meatin keil toumien onom en naef one, ka alah vasi kamel keil osom. Inau sesuk nalohosai keke numai navit meseini minuk.” ");
INSERT INTO pma_vpl VALUES ("JB1_18","019_1_18","JOB","1","18","18","Kei mun roselus vasitei mau, meatin toumien tateisav tamun mai ka vit, “Natmali keil ka natmahin keil amul akanian ruai en teim sen natmali koa moeite. ");
INSERT INTO pma_vpl VALUES ("JB1_19","019_1_19","JOB","1","19","19","Memusil, mari eang koa kileiles ka en out volvol, mai muh lin eim va netan, mutakat vasi keil umatmat. Inau sesuk nalohosai keke numai navit meseini minuk.” ");
INSERT INTO pma_vpl VALUES ("JB1_20","019_1_20","JOB","1","20","20","Navong Siob long tounah vasi keil enek, longe tisa houlu. Sakini rali vas eisin omon, rei kokoteh hilin en vatin, retengeiril vita netan ka san houhouen min Ahi. ");
INSERT INTO pma_vpl VALUES ("JB1_21","019_1_21","JOB","1","21","21","Kei vit, “Navong avasi inau, namai navi heite hon, ka navong nimat, nihi heite hon emun niha. Iahova san tounah vasi minau, ka kosa, kei kulat risi. Nihati lat isen Iahova.” ");
INSERT INTO pma_vpl VALUES ("JB1_22","019_1_22","JOB","1","22","22","Avaseini tounah vasi tisa kistal en Siob, kei romumontei tisaen vuo vahiteni keke Ahi mumoni romaltei mini. ");
INSERT INTO pma_vpl VALUES ("JB2_1","019_2_1","JOB","2","1","1","En avong tai, en out nesa, angelo keil umai ris avati keil en meten Iahova, ka Temat emun ro ral min keil. ");
INSERT INTO pma_vpl VALUES ("JB2_2","019_2_2","JOB","2","2","2","Ka Iahova visi vit, “?Keik, koka kave?” Temat vit kesi mini vit, “Naka ko, nuva ko, ka namules naretoun en out netan.” ");
INSERT INTO pma_vpl VALUES ("JB2_3","019_2_3","JOB","2","3","3","Iahova visi vit, “?Keik koles more meatin toumien onak Siob? Meatin tovuol en out netan valong kat nau ka vatahos vasuval kei. Kei mul va netan minau ka losil kat revi kei keke romumon etai tounah vatisa. Keik kovis nau mamaenuk kovapurun heisav eni enges, ka avaseini, Siob mules musil kat sakien koa mutolas en metok.” ");
INSERT INTO pma_vpl VALUES ("JB2_4","019_2_4","JOB","2","4","4","Temat vit kesi vit, “Meatin tai kilea vasa lat tounah vasi onen keke vasakini vamoul. ");
INSERT INTO pma_vpl VALUES ("JB2_5","019_2_5","JOB","2","5","5","Ka munak kisasa kovapurun aven, nakilea keke kosas eke, kei hesilik varei en metom.” ");
INSERT INTO pma_vpl VALUES ("JB2_6","019_2_6","JOB","2","6","6","Sakini Iahova viteni min Temat vit, “Tahos, nimaeni hel en hem, ka konouasteis namat.” ");
INSERT INTO pma_vpl VALUES ("JB2_7","019_2_7","JOB","2","7","7","Evus, Temat va ran Iahova ka mumon marmari manu keil akikistal ka vasi aven Siob, vatin vita rokol tinealen keilu tanetan. ");
INSERT INTO pma_vpl VALUES ("JB2_8","019_2_8","JOB","2","8","8","Sakini Siob va, ka rondan en vulimeas en out amunit tahul ien. Kur sokeai koa kan ka mukal vahas manu keil onen eni. ");
INSERT INTO pma_vpl VALUES ("JB2_9","019_2_9","JOB","2","9","9","Ahin onen mai ka viteni mini vit, “?Keik komules kovuli kat mormore sakien keil onom enges veah? Tahos imok kisili Ahi ka kimat.” ");
INSERT INTO pma_vpl VALUES ("JB2_10","019_2_10","JOB","2","10","10","Siob vit kesi mini vit, “!Keik komul koselus suval ahin koa vi vau! ?Mukave? ?Ir koa rokur kat tounah koa tahos en hen Ahi, reherkurtei tounah koa tisa emun?” Ka avaseini keke mahien onen Siob mariso, roviten etai tounah vatisa vaha kat Ahi. ");
INSERT INTO pma_vpl VALUES ("JB2_11","019_2_11","JOB","2","11","11","Navong longlongien usil mahien onen Siob ka vasi out, time etel telraengoni. Iseatel vi Elivas ten out Teman, Bildat ten out Suah, ka Sofar ten out Namah. Navong telraengoni, telmai en rendemien keke telvaha telvasan enmahisien oneatel mini ka telvakatauni en selusien. ");
INSERT INTO pma_vpl VALUES ("JB2_12","019_2_12","JOB","2","12","12","Navong telmul semau soutin, telles Siob ka tellei rasi. Navong esuk telmai vesesal ka tellei kilea, tellonge tisa houlu ven tueatel. Sakini telmurang keih, telrali vas eisin omeatel, ka telrivin vulimeas vina en mesaiuai ka en vatiatel. ");
INSERT INTO pma_vpl VALUES ("JB2_13","019_2_13","JOB","2","13","13","Telva telro sasani avong oulu (7). Telrova rantei ka telro raeng enges veni telles mahien koa Siob mul kuri marite ramat. ");
INSERT INTO pma_vpl VALUES ("JB3_1","019_3_1","JOB","3","1","1","Navong aro mukonek avong oulu (7) evus, Siob selus esuk ka rin kat avong avasi eni. ");
INSERT INTO pma_vpl VALUES ("JB3_2","019_3_2","JOB","3","2","2","Siob vit, ");
INSERT INTO pma_vpl VALUES ("JB3_3","019_3_3","JOB","3","3","3","“!Ahi li, vahit kovasesenda en vongien koa avange kat inau eni, ka kovasesenda mun en avong koa avasi nau eni! ");
INSERT INTO pma_vpl VALUES ("JB3_4","019_3_4","JOB","3","4","4","Ahi eli, avong koanek, kihiles meneai teni hemai hehi vongien. Konandem kattei mun avong enek. Konoumontei mun meneai natitin eni. ");
INSERT INTO pma_vpl VALUES ("JB3_5","019_3_5","JOB","3","5","5","Kumoni hehi avong ten malikelik ka mankoli teni hemai hematetel imok. Kiov koe meteiai teni en mahmah keil. ");
INSERT INTO pma_vpl VALUES ("JB3_6","019_3_6","JOB","3","6","6","Kikulat vongien enek hemea ran sua teni, ka konamaentei anahuli ris. ");
INSERT INTO pma_vpl VALUES ("JB3_7","019_3_7","JOB","3","7","7","Kumon vongien enek hehi lumalum, isien onen tivava hau keil hetovuol eni. ");
INSERT INTO pma_vpl VALUES ("JB3_8","019_3_8","JOB","3","8","8","Koakeil akur keihoen keke avasakin Levaetan vamea ran huinev ten atas, kihiteni min keil keke isesenda en avong avasi nau eni. ");
INSERT INTO pma_vpl VALUES ("JB3_9","019_3_9","JOB","3","9","9","Hitu ten menauilan, kihuli kati natitintei, konamaentei vongien enek namai nahi meneai. ");
INSERT INTO pma_vpl VALUES ("JB3_10","019_3_10","JOB","3","10","10","Kisesenda en vongien enek veni kei maeni avasi inau eni, ka maeni nakur moulien keke nakilea makur mahien ka malonge vatisa. ");
INSERT INTO pma_vpl VALUES ("JB3_11","019_3_11","JOB","3","11","11","Tahos imok vahit mamat en vangen mama onak, vuo mamat en hati avong enges varei avasi nau eni. ");
INSERT INTO pma_vpl VALUES ("JB3_12","019_3_12","JOB","3","12","12","?Vensa mama onak ling nau en urulin? ?Vensa san susu minau? ");
INSERT INTO pma_vpl VALUES ("JB3_13","019_3_13","JOB","3","13","13","Vahit mamat tuai en avong enek, kosa, maseh revi ka marlongtei mun mahien. ");
INSERT INTO pma_vpl VALUES ("JB3_25","019_3_25","JOB","3","25","25","“Tounah vasi nametauni, umai asut inau, asas namundemko eni, mai kistal vi anatin. ");
INSERT INTO pma_vpl VALUES ("JB3_26","019_3_26","JOB","3","26","26","Narkurtei tomat, rendemien onak mul konakon, nasakras maseh veni mahien onak sakras vavus.” ");
INSERT INTO pma_vpl VALUES ("JB4_1","019_4_1","JOB","4","1","1","Evus, Elivas ten out Teman mea ka viteni min Siob vit, ");
INSERT INTO pma_vpl VALUES ("JB4_2","019_4_2","JOB","4","2","2","“?Munak niselus minuk, kivuroh? Veni nasakras emun mato raeng. ");
INSERT INTO pma_vpl VALUES ("JB4_3","019_4_3","JOB","4","3","3","Keik kovisein meatin keil houlu ka kosan keihoen min koakeil he memerau. ");
INSERT INTO pma_vpl VALUES ("JB4_4","019_4_4","JOB","4","4","4","Navong meatin tai mot vuo aven memerau vuo aven litu, selusien onom katauni, ka kei mulomal eris. ");
INSERT INTO pma_vpl VALUES ("JB4_5","019_4_5","JOB","4","5","5","Ka kosa, vi avong onom komul en mahien, ka keik korvinvintei kovahisu vatali. ");
INSERT INTO pma_vpl VALUES ("JB4_6","019_4_6","JOB","4","6","6","Munak hehi anatin keke keik kuva netan min Ahi ka moulien onom mutolas en meten, hesakin desien onom hel ka demkoen hetovuol enuk. ");
INSERT INTO pma_vpl VALUES ("JB4_7","019_4_7","JOB","4","7","7","Kosa, kindem usili. ?Meatin koa sakien onen mutolas kilea vakur matien koa tisa? !Vuo! ");
INSERT INTO pma_vpl VALUES ("JB4_8","019_4_8","JOB","4","8","8","Inau nales koanik: meatin koa kil atan ten tisaen ka luh utiai keil tasakkalkalien ien, kosa keil akur hei sakkalkalien ka hei tisaen. ");
INSERT INTO pma_vpl VALUES ("JB4_9","019_4_9","JOB","4","9","9","Suval angu tai, Ahi mu lin keil en vurohien onen. ");
INSERT INTO pma_vpl VALUES ("JB5_17","019_5_17","JOB","5","17","17","Ka sien hel en meatin koa Ahi ralimal eni. Sakini, konavurohtei navong kei sel katuk.” ");
INSERT INTO pma_vpl VALUES ("JB6_1","019_6_1","JOB","6","1","1","Siob vit kesi min Elivas vit, ");
INSERT INTO pma_vpl VALUES ("JB6_2","019_6_2","JOB","6","2","2","“Vahit avaling mahien keil onak ka sakvisien keil emun onak vaha en sikel tai, ");
INSERT INTO pma_vpl VALUES ("JB6_3","019_6_3","JOB","6","3","3","keil akilea avameas valin veien vasi keil ten atas, sakini konatimanintei keke naselus vau ekek. ");
INSERT INTO pma_vpl VALUES ("JB6_24","019_6_24","JOB","6","24","24","“Tahos, kihiseinau. Kihit lati minau asa namumoni tisa. Inau nito raeng ka nilonguk kiselus. ");
INSERT INTO pma_vpl VALUES ("JB6_25","019_6_25","JOB","6","25","25","Selusien ten anatinien, keihoen mul ien, ka selusien keil onom vi heisav enges. ");
INSERT INTO pma_vpl VALUES ("JB6_26","019_6_26","JOB","6","26","26","?Keik komundemi kovit kitalimal en selusien onak? ?Vensa kolong ras selusien onen meatin koa desien onen mot? ");
INSERT INTO pma_vpl VALUES ("JB6_30","019_6_30","JOB","6","30","30","“?Komundemi kovit namul naluvos? ?Komundemi kovit nasakras malei kilea avong takeih keil?” ");
INSERT INTO pma_vpl VALUES ("JB18_1","019_18_1","JOB","18","1","1","Evus, Bildat ten out Suah selus min Siob vit, ");
INSERT INTO pma_vpl VALUES ("JB18_2","019_18_2","JOB","18","2","2","“Meatin keil asuvaluk asakras avato raeng. Munak kiha netan ka kito raeng, mekilea mevaselus minuk. ");
INSERT INTO pma_vpl VALUES ("JB18_5","019_18_5","JOB","18","5","5","“Meatin keil amum tisa, asuval kandel koa amuh vini, koa ahang teni hermukantei mun. ");
INSERT INTO pma_vpl VALUES ("JB18_12","019_18_12","JOB","18","12","12","“Mulamu, tounah one houlu, ka kosa, amai kat keil. Mahien keil aro vesesal ven keil lises. ");
INSERT INTO pma_vpl VALUES ("JB18_13","019_18_13","JOB","18","13","13","Mesaien tatisaso tai ka vasi ave, mul sakin husi keil en he ka ale one mul maleles. ");
INSERT INTO pma_vpl VALUES ("JB18_18","019_18_18","JOB","18","18","18","“Koakeil amum tisa, isila lat keil imea ran meneai, iha en mankoli. Imea ran out ten moulien, iha en out ten matien. ");
INSERT INTO pma_vpl VALUES ("JB18_21","019_18_21","JOB","18","21","21","“Koanek vi keite ten moulien onen meatin keil amumon sakien tatisa, keite onen koakeil arkileatei Ahi.” ");
INSERT INTO pma_vpl VALUES ("JB19_1","019_19_1","JOB","19","1","1","Evus, Siob vit kesi mini vit, ");
INSERT INTO pma_vpl VALUES ("JB19_2","019_19_2","JOB","19","2","2","“Vensa komul veah komumonau nales menehang en selusien keil onom? ");
INSERT INTO pma_vpl VALUES ("JB19_3","019_19_3","JOB","19","3","3","Tuetin koselus tisa va kat nau. ?Kormemoutei en sakien koa komul kopurunau eni? ");
INSERT INTO pma_vpl VALUES ("JB19_21","019_19_21","JOB","19","21","21","“!Tuak onak eli keil, emi hemahis nau li! Veni hen Ahi mul keih kat nau. ");
INSERT INTO pma_vpl VALUES ("JB19_22","019_19_22","JOB","19","22","22","?Vensa mimul misak purunau suval koa Ahi mul mumoni minau? ?Narlongtei veah mahien vavinvin en avek?” ");
INSERT INTO pma_vpl VALUES ("JB20_1","019_20_1","JOB","20","1","1","Evus, Sofar ten out Namah selus min Siob vit, ");
INSERT INTO pma_vpl VALUES ("JB20_2","019_20_2","JOB","20","2","2","“!Siob, kosakin tinok vepeng vareis! Nirto raengtei mun. Kosa, nihit kes selusien onom. ");
INSERT INTO pma_vpl VALUES ("JB20_4","019_20_4","JOB","20","4","4","“Kokilea revi keke en avong keil mulamu, navong meatin keil amul rohtoh en out netan, ");
INSERT INTO pma_vpl VALUES ("JB20_5","019_20_5","JOB","20","5","5","meatin keil avou lat tisaen ten avong tamureis, ka sien onen koakeil amum tisa hevus hatte tas. ");
INSERT INTO pma_vpl VALUES ("JB20_27","019_20_27","JOB","20","27","27","“Tounah vasi en out nesa avothot en tisaen one, ka meatin keil ten out netan avitehiten anatinien va kat keil. ");
INSERT INTO pma_vpl VALUES ("JB20_28","019_20_28","JOB","20","28","28","Suval mari oai, vurohien onen Ahi hetavis vasi tounah keil one heha. ");
INSERT INTO pma_vpl VALUES ("JB20_29","019_20_29","JOB","20","29","29","Koanek hekikistal en meatin keil amum tisa, koanek keite ten moulien one koa Ahi vat kati min keil.” ");
INSERT INTO pma_vpl VALUES ("JB21_1","019_21_1","JOB","21","1","1","Evus, Siob vit kesi min keitel vit, ");
INSERT INTO pma_vpl VALUES ("JB21_2","019_21_2","JOB","21","2","2","“Mithelong revi asa mahiteni. Munak emi vat mivoumon nau malonge vatahos, mithesan ralingomitel enges. ");
INSERT INTO pma_vpl VALUES ("JB21_5","019_21_5","JOB","21","5","5","“!Mithelele ka mitheles inau! !Hesakin mithetimanin ka emitel hevon! ");
INSERT INTO pma_vpl VALUES ("JB21_6","019_21_6","JOB","21","6","6","Navong namundem usil tounah koa sut nau, alok maleilei ka namundemko houlu. ");
INSERT INTO pma_vpl VALUES ("JB21_7","019_21_7","JOB","21","7","7","?Vensa varei meatin tisa keil aro tahos? ?Vensa amatu ka ales amas en moulien one? ");
INSERT INTO pma_vpl VALUES ("JB21_13","019_21_13","JOB","21","13","13","“Keil arokol keite ten moulien one en tomat, ka umat en merauen. ");
INSERT INTO pma_vpl VALUES ("JB21_14","019_21_14","JOB","21","14","14","Meatin tisa keil aviteni min Ahi avit, ‘!Kiling komai mehel sasomai enges! Emai rovattei mevailea sise keil onom. ");
INSERT INTO pma_vpl VALUES ("JB21_15","019_21_15","JOB","21","15","15","?Ahi vi isei keke meheha netan mini? ?Mehekur sa munak mehehis mini?’ ");
INSERT INTO pma_vpl VALUES ("JB21_17","019_21_17","JOB","21","17","17","“?Nengeis roles Ahi muh vini laet ten moulien onen meatin keil koa amukonek? ?Nengeis avisu en avong takeih? ?Nengeis Ahi vuroh kat keil ka san mahien min keil? !Vuo, rolestei varei! ");
INSERT INTO pma_vpl VALUES ("JB21_23","019_21_23","JOB","21","23","23","“Meatin tai, en moulien vasi onen, mul les amas ka tomat. ");
INSERT INTO pma_vpl VALUES ("JB21_24","019_21_24","JOB","21","24","24","Kei longe tahos rokol avong mat. ");
INSERT INTO pma_vpl VALUES ("JB21_25","019_21_25","JOB","21","25","25","Meatin tamun, sien tovuol varei en kei. En avong vasi onen, kei mul les mahien rokol matien. ");
INSERT INTO pma_vpl VALUES ("JB21_26","019_21_26","JOB","21","26","26","Keite ten moulien onealu vatte tas. Lumat, arahin keilu, ka oul kan vasi teiai onealu. ");
INSERT INTO pma_vpl VALUES ("JB21_34","019_21_34","JOB","21","34","34","“?Ka kamitel, mitvit mitvoumon nau malonge vatahos en selusien keil koa vi heisav enges? !Vuo! !Selusien vasi koa mitsani minau vi luvosien!” ");
INSERT INTO pma_vpl VALUES ("JB22_1","019_22_1","JOB","22","1","1","Elivas ten out Teman selus eris min Siob vit, ");
INSERT INTO pma_vpl VALUES ("JB22_2","019_22_2","JOB","22","2","2","“?Meatin tai kilea vasuvasuv en umen onen Ahi? ?Meteisauen onen meatin etai kilea vakatauni? ");
INSERT INTO pma_vpl VALUES ("JB22_4","019_22_4","JOB","22","4","4","“?Mukave, Ahi mul ralimal enuk veni kovouhou mini? ?Vensa mul san mahien minuk? ");
INSERT INTO pma_vpl VALUES ("JB22_5","019_22_5","JOB","22","5","5","Ahi mul mumoni minuk veni tisaen onom keil houlu vareis, ven sakkalkalien vasi keil onom. ");
INSERT INTO pma_vpl VALUES ("JB22_10","019_22_10","JOB","22","10","10","“Sakini eitapolis keil houlu amul rahituk, annivul katuk ka metauen vilelau enuk. ");
INSERT INTO pma_vpl VALUES ("JB22_11","019_22_11","JOB","22","11","11","Mankoli mul koe out koa koro ien, kosakras kovalele. Mari oai mutaluh koe keik.” ");
INSERT INTO pma_vpl VALUES ("JB23_1","019_23_1","JOB","23","1","1","Siob vit kesi min keitel vit, ");
INSERT INTO pma_vpl VALUES ("JB23_2","019_23_2","JOB","23","2","2","“Avaseini mitviten sa minau, niles niselus kutut kat Ahi hekeih, nasakras mahuli kat mahisien onak. ");
INSERT INTO pma_vpl VALUES ("JB23_3","019_23_3","JOB","23","3","3","Hit eli varei mailea out mahotin Ahi ien keke mailea maha en out kei ro ien. ");
INSERT INTO pma_vpl VALUES ("JB23_4","019_23_4","JOB","23","4","4","Vamukonek, mahit lein tounah keil en usite onak mini, ka mahit kilea anatinien ten selusien keil onak mini. ");
INSERT INTO pma_vpl VALUES ("JB23_5","019_23_5","JOB","23","5","5","Ek vati mailea asa hehiteni, ka kei hehit kesi minau hemukave. ");
INSERT INTO pma_vpl VALUES ("JB23_6","019_23_6","JOB","23","6","6","?Mukave, Ahi hesa vasi keihoen onen heha kat nau? Vuo, helong nau navong niselus. ");
INSERT INTO pma_vpl VALUES ("JB23_7","019_23_7","JOB","23","7","7","En meten Ahi, meatin koa mutolas kilea vaselus retavoai vatal mini. Kei hehitehiteni keke inau narmumon etai tounah vatisa keke meatin keil avalong kilea.” ");
INSERT INTO pma_vpl VALUES ("JB27_2","019_27_2","JOB","27","2","2","“Avaseini Ahi ten Keihoen koa moul romumontei vamal minau ka mumon moulien onak emai tisa, naviteni li anatin en mini keke ");
INSERT INTO pma_vpl VALUES ("JB27_3","019_27_3","JOB","27","3","4","ongok sakras vahiten luvosien. Navong namul veah naleh eang koa Ahi sani minau, nirviten etai tounah tatisa. ");
INSERT INTO pma_vpl VALUES ("JB27_5","019_27_5","JOB","27","5","5","Hetokol avong nimat, nihit lati keke narmumon etai tounah vatisa, nasakras mahiteni keke selusien onamitel koa va kat nau vi anatin. ");
INSERT INTO pma_vpl VALUES ("JB27_6","019_27_6","JOB","27","6","6","Namulomal keih en selusien onak keke moulien onak mal. Rendemien onak muto navong namundem usil avong keil onak.” ");
INSERT INTO pma_vpl VALUES ("JB30_20","019_30_20","JOB","30","20","20","Siob viso va min Ahi vit, “Ahi, naviso vat minuk, ka korvit kestei nau varei. Navong navis, kolong seseinau. ");
INSERT INTO pma_vpl VALUES ("JB30_21","019_30_21","JOB","30","21","21","Komumoni minau tisa vilehil vareis, kosak purunau ral min keihoen onom. ");
INSERT INTO pma_vpl VALUES ("JB30_22","019_30_22","JOB","30","22","22","Suval mari angu tai, kovou lat nau vina nesa ka kokulul enau. ");
INSERT INTO pma_vpl VALUES ("JB30_23","019_30_23","JOB","30","23","23","Nakilea komul kokur nau maha en matien onak, keite onen meatin vasi keil.” ");
INSERT INTO pma_vpl VALUES ("JB38_1","019_38_1","JOB","38","1","1","Evus, Iahova selus min Siob ka en angu tai vit, ");
INSERT INTO pma_vpl VALUES ("JB38_2","019_38_2","JOB","38","2","2","“?Koa keik sei, komul kovis rendemien keil onak ral min selusien koa vi heite hon koa meteisauen tovuol ien? ");
INSERT INTO pma_vpl VALUES ("JB38_3","019_38_3","JOB","38","3","3","!Kilomal, munak kovit kovi meahos! Kihit kes selusien koa mahisuk eni. ");
INSERT INTO pma_vpl VALUES ("JB38_4","019_38_4","JOB","38","4","4","?Komul kave navong namumon out netan? Munak kokilea revi en tounah vasi, kihit usili minau. ");
INSERT INTO pma_vpl VALUES ("JB38_5","019_38_5","JOB","38","5","5","?Isei ling kat keite keilu teni? ?Isei kilea taveah teni? ?Keik kokilea? ");
INSERT INTO pma_vpl VALUES ("JB38_6","019_38_6","JOB","38","6","6","?Asa vuli kat vatiseng koa vuli kat out netan? ?Isei ling kat vati ahat ten out netan? ");
INSERT INTO pma_vpl VALUES ("JB38_7","019_38_7","JOB","38","7","7","En avong enek, hitu keil ten menauilan amusau ruai, ka angelo vasi keil ten out nesa amakul en sien. ");
INSERT INTO pma_vpl VALUES ("JB38_8","019_38_8","JOB","38","8","8","“?Isei mumon vati vieh val koe atas navong mue rohtoh ran anev ten atan? ");
INSERT INTO pma_vpl VALUES ("JB38_9","019_38_9","JOB","38","9","9","Inau nakav koe atas en mahmah ka nasakin mankoli mul koe. ");
INSERT INTO pma_vpl VALUES ("JB38_10","019_38_10","JOB","38","10","10","Inau naling hakot en atas keke sakras vahina vapurun atan. ");
INSERT INTO pma_vpl VALUES ("JB38_11","019_38_11","JOB","38","11","11","Inau naviteni mini navit, ‘!Keik kitokol out enek ka kosakras kovali! Tahe takeih keil onom hemavul hehati heles en out enek.’ ");
INSERT INTO pma_vpl VALUES ("JB38_12","019_38_12","JOB","38","12","12","“?Siob, en moulien onom, keik komeng kat etai avong vamai valan? ");
INSERT INTO pma_vpl VALUES ("JB38_13","019_38_13","JOB","38","13","13","?Keik koviteni min meteiai vatitin vaka vasi out netan keke vasil luvat koakeil asak kalkali ran out aro suai ien? ");
INSERT INTO pma_vpl VALUES ("JB38_19","019_38_19","JOB","38","19","19","“?Keik kokilea out meneai ka ien vuo mankoli kistal en out kave? ");
INSERT INTO pma_vpl VALUES ("JB38_20","019_38_20","JOB","38","20","20","?Keik kokilea kovatie min keilu sise onealu mul kave? ?Vuo kovasila keilu luvaha ris en vulealu? ");
INSERT INTO pma_vpl VALUES ("JB38_21","019_38_21","JOB","38","21","21","?Keik kokilea kovoumoni? !Vuo, kosakras! Veni arvasuktei veah ka sua onom keil rovinvintei. ");
INSERT INTO pma_vpl VALUES ("JB38_34","019_38_34","JOB","38","34","34","“?Keik kokilea kovamakul vahina min mahmah keil ka kovasakin ous vamus vakasuk? ");
INSERT INTO pma_vpl VALUES ("JB38_35","019_38_35","JOB","38","35","35","?Keik kokilea kovasakin ahil vahil, ka kei val vatosin mengkatien onom? ");
INSERT INTO pma_vpl VALUES ("JB38_36","019_38_36","JOB","38","36","36","?Isei san meteisauen onen min etai meatin, vuo sakin rendemien onen vamaluv? ");
INSERT INTO pma_vpl VALUES ("JB38_37","019_38_37","JOB","38","37","37","?Isei vi metaluv vavinvin vahuli mahmah keil? ?Isei kilea vatah lin ous vous ");
INSERT INTO pma_vpl VALUES ("JB38_38","019_38_38","JOB","38","38","38","vasakin vulimeas vamai out vatas, ka nehi atan keil ipilit kat keil?” ");
INSERT INTO pma_vpl VALUES ("JB40_1","019_40_1","JOB","40","1","1","Evus Iahova vit risi min Siob vit, ");
INSERT INTO pma_vpl VALUES ("JB40_2","019_40_2","JOB","40","2","2","“Siob, kovit Ahi ten Keihoen mum romaltei. !Keik koselus va kat nau, kihit kes selusien onak!” ");
INSERT INTO pma_vpl VALUES ("JB40_3","019_40_3","JOB","40","3","3","Evus Siob vit kesi min Iahova vit, ");
INSERT INTO pma_vpl VALUES ("JB40_4","019_40_4","JOB","40","4","4","“Iahova, naselus vau eli vareis. ?Nihit kes asa? Inau nirviten etai mun tounah. ");
INSERT INTO pma_vpl VALUES ("JB40_5","019_40_5","JOB","40","5","5","Inau naviten tounah houlu tuai keke marvitentei.” ");
INSERT INTO pma_vpl VALUES ("JB40_6","019_40_6","JOB","40","6","6","Iahova selus min Siob eris kistal en angu vit, ");
INSERT INTO pma_vpl VALUES ("JB40_7","019_40_7","JOB","40","7","7","“!Kilomal, munak kovit kovi meahos! Kihit kes selusien koa mahisi minuk. ");
INSERT INTO pma_vpl VALUES ("JB40_8","019_40_8","JOB","40","8","8","?Keik komul kovatie lati keke inau namum romaltei? ?Keik koselus va kat nau keke kovasakinuk kovamal en meten mesav keil? ");
INSERT INTO pma_vpl VALUES ("JB40_9","019_40_9","JOB","40","9","9","?Keihoen onom suval keihoen onak? ?Rem kilea vamakul vasuval voulul suval rek? ");
INSERT INTO pma_vpl VALUES ("JB40_10","019_40_10","JOB","40","10","10","Munak hemukonek, kilomal en houhouen onom ka tuvutien onom. Kisin en hetetamenien ka muohien onom. ");
INSERT INTO pma_vpl VALUES ("JB40_11","019_40_11","JOB","40","11","11","Kiles koakeil avut keil, kumon vurohien onom heha kat keil ka kumon rendemien one heha netan. ");
INSERT INTO pma_vpl VALUES ("JB40_12","019_40_12","JOB","40","12","12","Anatin, kiles keil ka kisakin keil iha netan. Kihe lin koakeil amum tisa en out amulomal ien. ");
INSERT INTO pma_vpl VALUES ("JB40_13","019_40_13","JOB","40","13","13","Kitahin keil vasi en atan. Kipar kat keil en out ten matien. ");
INSERT INTO pma_vpl VALUES ("JB40_14","019_40_14","JOB","40","14","14","Munak kokilea kovoumon tounah keil enek, inau varei nilamu nimasmasuk, ka nihiteni keke keik kokilea kovoutut keik sasom.” ");
INSERT INTO pma_vpl VALUES ("JB42_1","019_42_1","JOB","42","1","1","Evus, Siob vit kesi min Iahova vit, ");
INSERT INTO pma_vpl VALUES ("JB42_2","019_42_2","JOB","42","2","2","“Iahova, nakilea keke keik kokeih vis kokeih emok. Kokilea kovoumon vasi tounah koa em vati. ");
INSERT INTO pma_vpl VALUES ("JB42_3","019_42_3","JOB","42","3","3","Kovis nau nakeih kat meteisauen onom mukave, navong inau meteisauen onak tovuol. Naselus en tounah keil koa narkileatei, en marmari tounah koa nasakras mailea eni. ");
INSERT INTO pma_vpl VALUES ("JB42_4","019_42_4","JOB","42","4","4","Koviteni minau nitaengonuk navong koselus, ka nisak visi nihit kes selusien keil onom. ");
INSERT INTO pma_vpl VALUES ("JB42_5","019_42_5","JOB","42","5","5","Mulamu, nalong kilea keik ka en asas koa naraengon meatin sav keil aviteni minau, ka kosa, nalei kilea keik esuk en metok varei. ");
INSERT INTO pma_vpl VALUES ("JB42_6","019_42_6","JOB","42","6","6","Sakini namemou en tounah keil naviteni. Nikur ris selusien onak, ka nikul en vulimeas vatie lati keke nalonge tisa houlu ven asa namumoni.” ");
INSERT INTO pma_vpl VALUES ("JB42_7","019_42_7","JOB","42","7","7","Navong Iahova selus min Siob evus, kei viteni min Elivas ten out Teman vit, “Tinok katuk ral time keilu onom, veni korselus entei anatinien enau vasuval more eiloheh onak, Siob, mumoni. ");
INSERT INTO pma_vpl VALUES ("JB42_8","019_42_8","JOB","42","8","8","Kosa, mihekur buluk oulu (7) ka sipsip oulu heha min Siob, ka mihesan keil hesuval sanien votut tai minau en usite onami. Siob hehis ven kami ka inau nilong hisien onen ka nirpuruntei kami hesuval koa mal keke mihekuri ven selusien tavaruen onami. Veni kami merselus entei anatinien enau vasuval koa kei mumoni.” ");
INSERT INTO pma_vpl VALUES ("JB42_9","019_42_9","JOB","42","9","9","Elivas, Bildat, ka Sofar telmumon asa koa Iahova viteni min keitel telvoumoni. Ka Iahova raengon hisien onen Siob en usite onealu. ");
INSERT INTO pma_vpl VALUES ("JB42_10","019_42_10","JOB","42","10","10","Navong Siob vis ven time keitel, Iahova rokol kat ris Siob en tounah keil onen ka ling kati hatte elu eris en tounah keil kei lahi mulamu. ");
INSERT INTO pma_vpl VALUES ("JB42_11","019_42_11","JOB","42","11","11","Tunali Siob vasi keil, ka ahinali keil emun, ral min time sav keil onen umai asao eni. Keil amumon mari anien ral mini en teim sen. Asan enmahisien one mini ka akatauni ven mahien vasi keil Iahova sani mini. Tetai en keil san hati mani ka ring koa vi gol mini. ");
INSERT INTO pma_vpl VALUES ("JB42_12","019_42_12","JOB","42","12","12","Iahova rokol kat avong ekor onen Siob mulin sakien koa rokol kati mulamu. Siob, sipsip osen keil avi taosen teindan ehat (14,000), kamel keil avi taosen ahetai (6,000), buluk keil avi taosen elu (2,000), ka dongki keil osen avi taosen tai (1,000). ");
INSERT INTO pma_vpl VALUES ("JB42_13","019_42_13","JOB","42","13","13","Natnali keil oulu (7) ka natnahin keil etel (3). ");
INSERT INTO pma_vpl VALUES ("JB42_14","019_42_14","JOB","42","14","14","Natnahin koa moeite vise en Semaemah. Koa elu eni vise en Kesiah. Ka koa tasite en keitel vise en Keren-Hapuk. ");
INSERT INTO pma_vpl VALUES ("JB42_15","019_42_15","JOB","42","15","15","En out vasi en out netan, ahin keil atovuol koa avales keil avatahos imok vasuval natnahin Siob keitel. Ka tata oneatel sani min keil atan ka buluk ka sipsip keil suval koa sani min tueatel keil. ");
INSERT INTO pma_vpl VALUES ("JB42_16","019_42_16","JOB","42","16","16","Siob moul handred tai ka hanumau elu (140) eris. Ro taveah keke les havinali ka havinahin keil ral min titae keil emun. ");
INSERT INTO pma_vpl VALUES ("JB42_17","019_42_17","JOB","42","17","17","Navong Siob matu vis matu revi mok, emat esuk. ");
INSERT INTO pma_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Sien hel en koakeil: asesein rendemien koa meatin tatisa keil amul asani; armusiltei sakien onen meatin tisa keil, vuo arkapiltei vatal koakeil amumon tohtohien en tounah keil onen Ahi. ");
INSERT INTO pma_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","Vuo, keil avotin sien navong along kat mengkatien onen Ahi, meneai ka vongien, amundem usili. ");
INSERT INTO pma_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Keil asuval vatiai koa mul en vali oai, son heite mal en avong teni, ka oute sakras varei vakou. Tounah vasi koa amumoni tahos imok. ");
INSERT INTO pma_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Ka meatin tatisa keil armukteinek. Keil asuval sume uit koa rotahostei koa eang mul muh lini ran aneite. ");
INSERT INTO pma_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Sakini, Ahi hesan mahien min meatin tatisa keil, irtotei hetal koakeil ualien one tahos. ");
INSERT INTO pma_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Ven koakeil ualien one tahos, Ahi helosil kat keil ka hekur koe keil. Ka koakeil ualien one tisa, amul en sise ten matien. ");
INSERT INTO pma_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","1","Asuv houlu Deved mutisi O Iahova, kisan ralingom en selusien onak, ka kitaengon mahien onak. ");
INSERT INTO pma_vpl VALUES ("PS5_2","020_5_2","PSA","5","2","2","Ahi ka asuv houlu onak, kilong tangien onak ven kovakataun inau. Namul nasan hisien keil onak minuk; ");
INSERT INTO pma_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","en visokon, kolong rek. Navong meteiai kistal, namul napeahik, ka nakilea keke kisan heite minau. ");
INSERT INTO pma_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","Keik korvitei Ahi koa kovasik ven sakien keil tatisa, kormaentei meatin tatisa keil avamai venuk. ");
INSERT INTO pma_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","Tovuti keil asakras avalomal en metom. Kolele tisa en koakeil koa ualien one romaltei. ");
INSERT INTO pma_vpl VALUES ("PS5_6","020_5_6","PSA","5","6","6","Ku rasilin koakeil amul amumon luvosien. Ahi Asuv, tinom katiat varei ven koakeil ten rea ka vati luvosien keil. ");
INSERT INTO pma_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","Ka ven more envatien onom, nakilea maha en teim som. En Eim Votut onom, navati lat isom, naretengeiril minuk ven ka navouhou minuk. ");
INSERT INTO pma_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","Ahi Asuv, meatin houlu mete tisa enau. Kilamu enau en sise ten maluen, kitie sise koa em vati mousili. ");
INSERT INTO pma_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","Koakeil mete tisa enau ka tine vil en rendemien takarien, nasakras maling desien onak val en selusien one. Selusien one suval ahoung, koa leh rendemien onen meatin ka mu vini. ");
INSERT INTO pma_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","Ahi ten out nesa, hesan mahien min keil. Tounah tatisa koa avit avoumoni min meatin sav, hehiles hemai ris en keil. Kisila keil iha ranuk ven tisaen keil koa amumoni va katuk, veni keil aviles eisile ranuk. ");
INSERT INTO pma_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","11","Ka koakeil aro suai enuk en avong takeih, isi keil; ka lises, isau masmasuk. Kisak ven koakeil e vatuk keke meatin tatisa keil anapuruntei keil, hesakini ihat lat isom. ");
INSERT INTO pma_vpl VALUES ("PS5_12","020_5_12","PSA","5","12","12","Ahi Asuv, tokolkatien onom hel en koakeil ualien one tahos; koring koe keil ral min envatien onom suval ousiel koa asuv lingi mul koe rea. ");
INSERT INTO pma_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","Asuv houlu Deved mutisi Ahi Asuv, konavuroh kattei inau, konaseltei natal minau. Konatin kattei inau, konasantei mahien minau. ");
INSERT INTO pma_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","Ahi Asuv, kisan enmahisien minau ven avek memerau. Kisan keihoen minau ven nasakras moumon etai tounah. ");
INSERT INTO pma_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","Demvoen houlu en tinok. ?Ahi Asuv, kisan heite ten hisien onak nengeis? ");
INSERT INTO pma_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","Konalei vinitei inau, Ahi Asuv; kikataunau veni enmahisien onom mariso. ");
INSERT INTO pma_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","Meatin hesakras vandem katuk navong hemat. ?Isei kilea vamasmasuk navong mul tuai en avul? ");
INSERT INTO pma_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","Namurang vini inau; en vongien vasi, simetok mul kas oulung mak, sakini memer vasi. ");
INSERT INTO pma_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","Nasakras maleilei vatahos veni metok mutetep; namurang houlu veni meatin tatisa keil amul apurunau. ");
INSERT INTO pma_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","Alva soutin ranau, kami keke mimumon tisaen houlu, veni Ahi Asuv raengon tangien onak. ");
INSERT INTO pma_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","Kei long nau navong napeahi ven kataunien onen; ka kei hesan heite ten hisien onak. ");
INSERT INTO pma_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","Meatin keil koa amul apurunau, Ahi hehile lat keil, hesakini, keil imemou, imetau ka ilohosai ranau. ");
INSERT INTO pma_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","Asuv houlu Deved mutisi !Ahi Asuv onomai, isom marite mok en out vasi netan! Muohien ten hetetamenien onom vilelau en out nesa. ");
INSERT INTO pma_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","Masmasien heha minuk heka en titiali keil ka tivava keil. Keik koro en out tetahos ran koakeil uvae ral minuk; Koring koe koakeil avit avapurunuk. ");
INSERT INTO pma_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","Navong nales teilang koa komumoni, naseipat nales more avati ka hitu keil koa kolingi en vulie, ");
INSERT INTO pma_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","narendem usil meatin enges ten out netan. ?Vensa komundem keil? ?Komul kolei kat keil vensa? ");
INSERT INTO pma_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","Keik komumon meatin keil amulin tounah sav keil, kosan keihoen, muohien ka houhouen min keil. Keikos Ahi, kovi hetamen en keil. ");
INSERT INTO pma_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","Koling tounah vasi keil koa komumoni en hen meatin keil; korie lat keil avi hetetamen imok mulin tounah vasi ten out netan: ");
INSERT INTO pma_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","sipsip ka buluk ka tirendan vasi keil koa amual; ");
INSERT INTO pma_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","aman keil koa amuka en teilang, ka mesau keil ka tounah vasi keil emun ten atas. ");
INSERT INTO pma_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","!Ahi Asuv onomai, isom marite mok en out vasi netan! ");
INSERT INTO pma_vpl VALUES ("PS9_1","020_9_1","PSA","9","1","1","Asuv houlu Deved mutisi Ahi Asuv, nimasmasuk eli en moulien onak; Nihitehiten mormore tounah keil koa komumoni. ");
INSERT INTO pma_vpl VALUES ("PS9_2","020_9_2","PSA","9","2","2","Nisau hetal min sien venuk; nisau masmasuk, Ahi ten keihoen. ");
INSERT INTO pma_vpl VALUES ("PS9_3","020_9_3","PSA","9","3","3","Navong kokistal, koakeil amumon rea ral minau alohosai; amusavoi, umot, ka umat. ");
INSERT INTO pma_vpl VALUES ("PS9_4","020_9_4","PSA","9","4","4","Navong kolei revi usite onak, rendemien onom mal ka vi anatin. Kolonge usite onak mal ka komumoni tahos minau. ");
INSERT INTO pma_vpl VALUES ("PS9_5","020_9_5","PSA","9","5","5","Kosan mahien min koakeil amusil ahi sav, komu rasilin meatin tatisa keil. Meatin etai hermundem kattei mun keil. ");
INSERT INTO pma_vpl VALUES ("PS9_6","020_9_6","PSA","9","6","6","Koakeil uvae ral minau, ivupuol, komuas meteimal keil one vi atan sesuk mul. Ka meatin keil e hevobongen moulien one. ");
INSERT INTO pma_vpl VALUES ("PS9_7","020_9_7","PSA","9","7","7","Ka Ahi, kei vi asuv houlu ten lises; kei rondan en avet ral keihoen onen keke voumon kot en meatin keil. ");
INSERT INTO pma_vpl VALUES ("PS9_8","020_9_8","PSA","9","8","8","Kei losil kat out netan ral min maluen; lei revi usite onen meatin keil ten kantri vasi keil ral min rendemien koa mal. ");
INSERT INTO pma_vpl VALUES ("PS9_9","020_9_9","PSA","9","9","9","Ahi Asuv sak ven koakeil meatin sav amumoni keih min keil, kei lei kat revi keil en avong takeih. ");
INSERT INTO pma_vpl VALUES ("PS9_10","020_9_10","PSA","9","10","10","Ahi Asuv, koakeil akileak, indesinuk, kosakras kovalokovein keil navong umai venuk. ");
INSERT INTO pma_vpl VALUES ("PS9_11","020_9_11","PSA","9","11","11","Rehesau masmas Ahi koa rondan en Hou Saeon. Rehehitehiteni en out vasi en out netan asa kei mumoni. ");
INSERT INTO pma_vpl VALUES ("PS9_12","020_9_12","PSA","9","12","12","Ahi mundem kat koakeil akur mahien, en rovobongentei tangien one. Koakeil amum tisa en mesav keil, Ahi hesa kesi min keil. ");
INSERT INTO pma_vpl VALUES ("PS9_13","020_9_13","PSA","9","13","13","!Ahi Asuv, em hemahis inau li! Kilei kilea mahien onak koa meatin keil mete tisa enau amumoni minau. Kikulat nau ran matien, Asuv onak, ");
INSERT INTO pma_vpl VALUES ("PS9_14","020_9_14","PSA","9","14","14","hesakini nakilea malomal en meten meatin keil ten out Serusalem, ka nihiteni min keil tounah vasi koa sakinau namasmasuk. Nasi nau houlu veni kokur koe moulien onak. ");
INSERT INTO pma_vpl VALUES ("PS9_15","020_9_15","PSA","9","15","15","Meatin keil koa areingeingenuk umot en avul koa akili onen meatin sav vamot vaha ien; ka ai tetapolis koa alingi, rapus lat keil eris. ");
INSERT INTO pma_vpl VALUES ("PS9_16","020_9_16","PSA","9","16","16","Ahi Asuv, vothot en kei sasen ka mul lei revi usite onen meatin keil. Ka asa koa meatin tatisa amumoni mai iat ris keil. ");
INSERT INTO pma_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","Matien vi keite onen meatin keil amum tisa, ka onen koakeil asesein Ahi. ");
INSERT INTO pma_vpl VALUES ("PS9_18","020_9_18","PSA","9","18","18","Kosa, alei sesein livere keil, ka hermukteinek en avong vasi; keitinesek, koakeil tounah tovuol desien one mai vi heisavos, ka irtotei hemukonek lisenges. ");
INSERT INTO pma_vpl VALUES ("PS9_19","020_9_19","PSA","9","19","19","!Ahi Asuv, amai! !Konamaentei meatin etai nandem heisav enuk! Kilah ruain koakeil amusil ahi sav keil imai venuk ka kisan mahien min keil. ");
INSERT INTO pma_vpl VALUES ("PS9_20","020_9_20","PSA","9","20","20","Ahi, kumon keil imetaunuk, kisakin keil ilea keke avi meatin enges ten out netan, asakras aval vataveah. ");
INSERT INTO pma_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","Asuv houlu Deved mutisi ?Ahi Asuv, isei heha neim en Eim Votut onom? ?Isei heha netan minuk en Hou Saeon koa vi votut? ");
INSERT INTO pma_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","Vati meatin koa long kat Ahi en tounah vasi, koa mumon sakien koa tahos. Selusien onen vi anatin ka mal, ");
INSERT INTO pma_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","romumontei hithitusilien vaha kat meatin sav keil. Meatin enek romumtei vatisa min tunali keil, ka rosel kututtei meatin sav keil. ");
INSERT INTO pma_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","Kei en rovattei koakeil Ahi sesein keil, ka vouhou min koakeil along kat ren Ahi. Lises, meatin enek mumon asa koa vat kati, ka rovilestei rani. ");
INSERT INTO pma_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","Kei maen mani min meatin sav keil ka rokurtei teisao eni. Ka en rovattei vakur mani en sise koa valuvos meatin koa romumontei tounah vatisa. Vati meatin koa mumon sakien keil koa amukonek, lises, moulien onen helomal hekeih. ");
INSERT INTO pma_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","Asuv houlu Deved mutisi Ahi Asuv, kikur koe inau, namundesinuk konamaentei tounah tisa nasut nau. ");
INSERT INTO pma_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","Naviteni minuk keke, “Keik kovi Asuv onak. Tounah vasi tetahos onak ka venuk.” ");
INSERT INTO pma_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","Meatin keil onen Ahi avi votut ka amoreite mok, ek vati mok nito hetal min keil. ");
INSERT INTO pma_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","Ka koakeil amusil ahi sav keil aleh mahien mai en keil. Navong keil iha netan min ahi one, nirkapiltei hetal keil; ka nirlah ruai tei hetal min keil navong akur sanien keil one. ");
INSERT INTO pma_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","Ahi Asuv, kosa moulien onak mules en hem; en avong keil koa hemai, namundesinuk kisan tounah natamurei eni. ");
INSERT INTO pma_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","Ahi, keik kotahos komulin atan vuo tounah sav keil ten out netan koa nakur kati. Inau nakur kat keik enges. ");
INSERT INTO pma_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","Ahi Asuv, namasmasuk ven korie minau asa numoni. Ka, en vongien emun, nalei kilea sise koa mal. ");
INSERT INTO pma_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","Ahi Asuv, lises nalinguk mulamun enau; veni koro vesesal, tounah tovuol vasak kulul inau. ");
INSERT INTO pma_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","9","Sakini, nasi nau mok, tinok vilelau en sien, ka metauen tovuol enau, ");
INSERT INTO pma_vpl VALUES ("PS16_10","020_16_10","PSA","16","10","10","veni kokur koe nau ran keihoen ten matien. Lises namum vasi umen koa kosani minau, sakini, konaseseintei nau nihas en out ten matien. ");
INSERT INTO pma_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","Kitie minau sise ten moulien. Nalonge tahos imok ven koro ral minau. Vesesal venuk, sien mul lisenges. ");
INSERT INTO pma_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","Asuv houlu Deved mutisi Hitu keil en out nesa amul arie lat muohien ten hetetamenien onen Ahi, ka teilang emun mul vothot en tounah koa kei mumoni. ");
INSERT INTO pma_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","Navong meteiai mea roha, mul eris vit usil keihoen onen Ahi va vio … mea ris out mulan; ka avati emun mules vitehiten ileilien onen Ahi Asuv va vio … mea ris. ");
INSERT INTO pma_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","Koakeil enek arselustei, ka rea tovuol rovataengoni en keil; ");
INSERT INTO pma_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","ka mukos, longlongien keil one usil Ahi karahit out vasi; va rokol meatin vasi keil en out netan. Meteiai en out nesa, Ahi lingi en vulie. ");
INSERT INTO pma_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","En visokon vasi, mea ral min sien; kei suval meatin koa tin si ka sak mesei ven lohlohien tai. ");
INSERT INTO pma_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","Mea en usite ten teilang ka muloh va en usite sav. Kei sakin out vasi mutin, tounah tovuol vato suai eni. ");
INSERT INTO pma_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","Mengkatien onen Ahi Asuv tahos imok, ka sak revi tiner. Hatkatien onen, rokilea rovaling desien orer eni; ka mul san meteisauen min koakeil one tovuol. ");
INSERT INTO pma_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","Mengkatien keil onen Iahova mal vasi, ka koakeil along kati, isi keil. Ren Ahi, rolonge rolong kilea, ka san ileilien min ir vasi. ");
INSERT INTO pma_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","Kei mal keke rorie lat houhouen orer min Ahi, rehoumoni lisenges. Mengkatien keil koa sani min ir avi anatin; keil amal vasi. ");
INSERT INTO pma_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","Keil atahos imok lohlin tounah vasi keil ten out netan, ka kasien teni mulin kasien ten hani. ");
INSERT INTO pma_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","Keil aviseinau, meatin toumien onom, en sakien keil koa tahos. Ka koakeil amum usili, akur uite koa tahos imok. ");
INSERT INTO pma_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","Avaseini koanek anatin, komai mesakras mevalei vasin tisaen keil onomai. Sakini, Ahi Asuv, munak namumon tounah tatisa tai nareingeingeni, kilah lati li ranau. ");
INSERT INTO pma_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","Ka tisaen keil koa namundem maenis namumoni, kiting koe inau li nanamottei mun eni. Konamaentei tisaen keil enek analamunau en sise koa romaltei. Hesakini, moulien onak kilea vatolas, ka nimaluv ran keihoen ten tisaen. ");
INSERT INTO pma_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","Ahi Asuv, komutut inau ka nakilea nito suai enuk. Ek vati mok keke selusien keil onak ka rendemien vasi keil onak, hemal en rendemien onom. ");
INSERT INTO pma_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","Asuv houlu Deved mutisi Ahi Asuv, kei mul losil kat inau suval meatin koa losil kat sipsip keil osen. Tounah vasi koa vakataun moulien onak, kei sani minau. ");
INSERT INTO pma_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Kei kur nau nuva en uteral koa oumunai tahos mul ien, ka mulamunau nuva en out koa oai mekaikai ka mandil. ");
INSERT INTO pma_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Kei san keihoen hau minau ka mulamunau en sise koa mal, suval koa kei vat kati. ");
INSERT INTO pma_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Avaseini munak niha en mari mankoli, nirmetautei, ven keik, Ahi Asuv, komusil inau. Kolei kokoe enau ka koring koe nau. ");
INSERT INTO pma_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Komumon mari anien tai venau en out koa vativieh keil onak akilea avales inau. Kosan more amaien minau suval koa navi mari meatin tai, ka kovus anien vilelau en pelet koa kosani minau. ");
INSERT INTO pma_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Nakilea keke tahosien ka more envatien onom housil kat inau en avong vasi, ka nito en teim som lisenges. ");
INSERT INTO pma_vpl VALUES ("PS24_1","020_24_1","PSA","24","1","1","Asuv houlu Deved mutisi Out netan ka tounah vasi keil koa amul ien avi onen Ahi; koakeil amoul ien, keil avi onen. ");
INSERT INTO pma_vpl VALUES ("PS24_2","020_24_2","PSA","24","2","2","Kei ling kat atan nesa en huinev ten atas; vatte ten out netan, mumoni en anev ten atas. ");
INSERT INTO pma_vpl VALUES ("PS24_3","020_24_3","PSA","24","3","3","!Anatin! !Ahi Asuv vi Ahi ten keihoen! ?Sakini isei kilea vahina en Hou Saeon onen Ahi Asuv? ?Isei kilea vaha en Eim Votut onen en out enek? ");
INSERT INTO pma_vpl VALUES ("PS24_4","020_24_4","PSA","24","4","4","Koakeil enges sakien ka rendemien one mutolas. Koakeil armusiltei ahi sav ka amusil hatkatien onen lises. ");
INSERT INTO pma_vpl VALUES ("PS24_5","020_24_5","PSA","24","5","5","Koakeil enek, Ahi hetokol kat keil ka houtut keil. En meten koakeil alele tisa en keil, hehitehiteni hehit keil amutolas. ");
INSERT INTO pma_vpl VALUES ("PS24_6","020_24_6","PSA","24","6","6","Vati meatin keil amukonek umai ven Ahi. Akilea avamai en meten Ahi onen Siekob. ");
INSERT INTO pma_vpl VALUES ("PS24_7","020_24_7","PSA","24","7","7","!Sehen metareh! Voiteh ten Eim Votut hetah, veni asuv houlu ten muohien hemai neim. ");
INSERT INTO pma_vpl VALUES ("PS24_8","020_24_8","PSA","24","8","8","?Isei vi asuv houlu ten muohien? Kei vi Ahi koa kur hetetamenien ka keihoen, koa marite mok en mari rea keil. ");
INSERT INTO pma_vpl VALUES ("PS24_9","020_24_9","PSA","24","9","9","!Les visi! Asuv houlu ten muohien mul mai. !Sehen mari metareh ten taon veni! !Voiteh ten Eim Votut hetah! ");
INSERT INTO pma_vpl VALUES ("PS24_10","020_24_10","PSA","24","10","10","?Isei vi asuv houlu ten muohien? Iahova, Asuv ten out nesa. !Kei vi asuv houlu ten muohien! ");
INSERT INTO pma_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","Asuv houlu Deved mutisi Ahi Asuv, kei vi meneai minau ka mutut nau. Sakini, narmetauntei meatin keil. Kei kur koe nau en tounah koa vasut nau. ?Sakini, mametaunsa? ");
INSERT INTO pma_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","Navong meatin tisa keil umai avit avouas nau ka asak visi mamat; Ahi hesakin nau nilikat keil, ka keil ilohosai ka isavoi, keil imotmot varei en sise. ");
INSERT INTO pma_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Avaseini keke vangi meatin tavaeen keil imai ikarahit nau, tinok hermaleileitei. Munak koakeil alele tisa enau amea avit avahu vatal minau, desien onak en Ahi hermottei. ");
INSERT INTO pma_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","Tounah tai, navis Ahi veni; keinges ek vati. Ek vati mok nitos en Eim Votut onen lises en moulien onak. En out enek, metok hel en Ahi onak, en more nan lises, ka nihisi ven kataunien onen. ");
INSERT INTO pma_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","En avong takeih, inau nito ven Ahi. Kei kur koe nau en Eim Votut onen ka kur revi nau en out tetahos onen. ");
INSERT INTO pma_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","Hesakini, nilohlin koakeil avit avahu vatal minau. Nisan sanien keil min Ahi Asuv hetal min hisohisoen ten sien; nisau mini ka nimasmasi. ");
INSERT INTO pma_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","!Ahi Asuv, kitaengonau navong navisok! !Em hemahis nau li, ka kisan aneite ten hisien keil onak! ");
INSERT INTO pma_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","Tinok raengonuk navong kovit, “!Kimai venau!” Sakini, en tinok, numai venuk ka navisuk. ");
INSERT INTO pma_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","Konato suaitei ranau. Konavuroh kattei inau, konalei seseintei inau, meatin toumien onom. Ahi koa komutut inau, mulamu, kokataunau; konalokoveintei nau li nanato sasok. ");
INSERT INTO pma_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","Vahesa tata onak keilu mama onak lulokoveinau; ka keik, Ahi Asuv, kilei kat revi nau. ");
INSERT INTO pma_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","Ahi Asuv, kihiseinau en asa koa em vati moumoni; ka kilamunau en sise koa meatin tisa keil areingeingeni avousil inau eni. ");
INSERT INTO pma_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Konamaentei inau min meatin tisa keil enek. Keil aselus karen inau en luvosien, ka lises avit avouas inau. ");
INSERT INTO pma_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","Ka asakras, veni nakilea keke nimoul niles tahosien keil onen Ahi. ");
INSERT INTO pma_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","!Kami miheling desien onami en Ahi Asuv! !Mihehati kami hekeih, minandemkotei! Anatin, miheling desien onami eni. ");
INSERT INTO pma_vpl VALUES ("PS29_1","020_29_1","PSA","29","1","1","Asuv houlu Deved mutisi !Angelo keil ten out nesa, mihesan masmasien min Ahi! !Mihemasmasi ven muohien ka keihoen onen! ");
INSERT INTO pma_vpl VALUES ("PS29_2","020_29_2","PSA","29","2","2","!Mihemasmas Ahi Asuv koa isen hetetamen imok! !Miheha netan min kei koa votut navong muohien onen hekistal! ");
INSERT INTO pma_vpl VALUES ("PS29_3","020_29_3","PSA","29","3","3","Ren Ahi musel en mesaiuai ten atas; Ahi ten muohien, selusien onen suval voulul, mai kistal en teilang nesa en atas. ");
INSERT INTO pma_vpl VALUES ("PS29_4","020_29_4","PSA","29","4","4","Ren Ahi keih imok, mul rie lat hetetamenien onen. ");
INSERT INTO pma_vpl VALUES ("PS29_5","020_29_5","PSA","29","5","5","Ren Ahi suval angu tai koa kilea vakum vul mari vatiai keil, vakum vul vati sida emun. ");
INSERT INTO pma_vpl VALUES ("PS29_6","020_29_6","PSA","29","6","6","Keihoen ten ren mumon atan kulul en hou keil ten out Lebanon ka en Vatihou Hermon. Lukulul suval titan buluk ka luvutahut suval buluk rendan tai. ");
INSERT INTO pma_vpl VALUES ("PS29_7","020_29_7","PSA","29","7","7","Ren Ahi sakin ahil vil. ");
INSERT INTO pma_vpl VALUES ("PS29_8","020_29_8","PSA","29","8","8","Ren sakin atan kulul en out volvol; en out volvol ten out Kates, atan mul kulul. ");
INSERT INTO pma_vpl VALUES ("PS29_9","020_29_9","PSA","29","9","9","Ren Ahi muh rasilin mari vati ok keil, ka sakin eivorohus, ouai tovuol emun val ien. Ka en Eim Votut onen, meatin keil vasi avisohiso keih avit, “!Isen Ahi vina nesa!” ");
INSERT INTO pma_vpl VALUES ("PS29_10","020_29_10","PSA","29","10","10","Ahi Asuv vi asuv ten huinev ten atas. !Anatin! Kei vi asuv ten tounah vasi kosa ka lisenges. ");
INSERT INTO pma_vpl VALUES ("PS29_11","020_29_11","PSA","29","11","11","Ahi Asuv san keihoen min meatin keil onen, ka sakin tomat onen mul en moulien one. ");
INSERT INTO pma_vpl VALUES ("PS30_1","020_30_1","PSA","30","1","1","Asuv houlu Deved mutisi ten avong asehen voiteh ten Eim Votut onen Ahi Ahi Asuv, namasmasuk veni keik kokataunau. Kormaentei koakeil avahu vatal minau avali nau ka avaselus kutut kat nau. ");
INSERT INTO pma_vpl VALUES ("PS30_2","020_30_2","PSA","30","2","2","Ahi Asuv, napeahik eli ven kataunien onom, ka kosakinau namoul. ");
INSERT INTO pma_vpl VALUES ("PS30_3","020_30_3","PSA","30","3","3","Kokur koe nau ran avul ten matien. Vesesal mamat, ka kosan ris moulien minau. ");
INSERT INTO pma_vpl VALUES ("PS30_4","020_30_4","PSA","30","4","4","!Kami koa mimusil Ahi Asuv! !Mihesau masmasi! Ahi vi votut, mihendem kat asa koa kei mumoni min kami, ka mihehiten hihuri veni. ");
INSERT INTO pma_vpl VALUES ("PS30_5","020_30_5","PSA","30","5","5","Vurohien onen mul tamureis, ka tahosien onen mul taveah. Avaseini simetomi houe en vongien; en meneai teni, mihelonge hetahos eris. ");
INSERT INTO pma_vpl VALUES ("PS30_6","020_30_6","PSA","30","6","6","Mulamu, navong nales tahosien en moulien onak, ka navit sasok eni navit, “Tounah hetovuol hesut nau.” ");
INSERT INTO pma_vpl VALUES ("PS30_7","020_30_7","PSA","30","7","7","Ahi Asuv, en avong koanek, kotahos minau, ka koring koe nau suval out tatosuaien. Ka katau suk, koro suai ranau, ka nametau houlu. ");
INSERT INTO pma_vpl VALUES ("PS30_8","020_30_8","PSA","30","8","8","Sakini, navisok, Ahi Asuv. Napeahik ven kataunien onom navit, ");
INSERT INTO pma_vpl VALUES ("PS30_9","020_30_9","PSA","30","9","9","“?Munak nimat, heite teni hehi asa? Heite hetovuol munak nihita en avul. ?Koakeil umatmat, imasmasuk? !Vuo! Asakras avisohiso usil tahosien onom. ");
INSERT INTO pma_vpl VALUES ("PS30_10","020_30_10","PSA","30","10","10","!Sakini, Ahi Asuv, kitaengonau li ka kisan enmahisien minau! !Ahi, navit mahisuk kikataunau!” ");
INSERT INTO pma_vpl VALUES ("PS30_11","020_30_11","PSA","30","11","11","Ka keik, koviles tangien onak mai vi holien ten sien. Isien onak, kokulati ranau, ka kosakinau numai nalonge tahos. ");
INSERT INTO pma_vpl VALUES ("PS30_12","020_30_12","PSA","30","12","12","Sakini, nirto raengtei, nimasmas isom lises. Ahi Asuv, kovi Ahi onak; nil nihiten hihuri minuk lisenges. ");
INSERT INTO pma_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","Asuv houlu Deved mutisi Sien hel en koakeil Ahi roleletei mun vatisa en keil ven tisaen one, en koakeil methos onen mul en keil. ");
INSERT INTO pma_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","Sien hel en koakeil Ahi Asuv roselus kattei keil ven sakkalkalien one, en koakeil luvosien tovuol en keil. ");
INSERT INTO pma_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","Munak narvit lattei sakkalkalien onak, namurang lisenges ka avek mai memerau veni. ");
INSERT INTO pma_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","Meneai ka vongien, kosan mahien minau. Keihoen onak vuol ranau varei, suval tilep vuol ka memes navong meteiai mutin keih. ");
INSERT INTO pma_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","Sakini, navit lat tisaen keil onak minuk Ahi. Sakkalkalien keil onak koa namum suai eni, nirmumontei mun. Ka narendemi navit mahit lat tisaen keil onak minuk, ka keik, kokulat keil ranau, ka methos onom hel eris enau. ");
INSERT INTO pma_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","Hesakini, koakeil amusiluk ihis venuk en avong takeih keil. Ka navong mahien hehi houlu hemai hehit vatahin koe keil, hesakras vasut keil. ");
INSERT INTO pma_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","Keik kovi out tatokusien onak, kikur koe nau en avong takeih. Nisau masmasuk houlu mok, ven koa koring koe moulien onak. ");
INSERT INTO pma_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","Evus, Ahi Asuv mul viteni vit, “Nihiseinuk en sise koa mal kovousili. Nisan rendemien tahos minuk. ");
INSERT INTO pma_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","Sakini konoumontei vatkeih onom nasuval hos tai, koa aling aean tai en ongon vasakini vamah ka voual vamal en sise.” ");
INSERT INTO pma_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","?Milesi? Meatin keil amum kalkali, mahien hehi houlu hemai en keil, ka koakeil aling desien one en Ahi, envatien onen mul kav koe keil. ");
INSERT INTO pma_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","Kami koa mimum mal en meten Ahi, mihelonge hetahos ka mihevut kami. !Kami koa milong kati, mihehisohiso en sien! ");
INSERT INTO pma_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","1","Asuv houlu Deved mutisi Navis Ahi Asuv ven kataunien onen ka narosini. Ka kei san ralingen ka raengon tangien onak. ");
INSERT INTO pma_vpl VALUES ("PS40_2","020_40_2","PSA","40","2","2","Navong namot en mari avul tai, kei kulat nau. Navong namarindu en tanmelmel koa matetel, kei leh lat nau. Kei ling nau en out tahos, koa nakilea mato revi ien. ");
INSERT INTO pma_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","Ahi Asuv viseinau en souen hau tai, souen koa nakilea mamasmas Ahi orer eni. Koakeil araengon longlongien enek ihouhou min Ahi Asuv, ka keil iling desien one eni. ");
INSERT INTO pma_vpl VALUES ("PS40_4","020_40_4","PSA","40","4","4","Sien hel en koakeil aling desien one en Ahi Asuv. Keil armusiltei ninin taluvosien keil, ka arkapiltei vatal min koakeil akur keihoen ran nana keil. ");
INSERT INTO pma_vpl VALUES ("PS40_5","020_40_5","PSA","40","5","5","Ahi Asuv onomai, tounah houlu komumoni min komai. !Tounah tovuol vasuvaluk! Keik koling more hatkatien houlu ven komai. Meatin tovuol vahuli lat keil vasi, avi houlu ramat, nasakras mahit lat keil vasi. ");
INSERT INTO pma_vpl VALUES ("PS40_6","020_40_6","PSA","40","6","6","Sanien keil em rovattei. Koseseini varei navong amunit vuseri en out ten sanien votut, vuo uas buluk vuo sipsip keil vasakin methos onom hel en keil. !Vuo! Keik komumon ralingomai mevalong katuk. ");
INSERT INTO pma_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","7","Sakini, mahiteni minuk mahit, “Kolesi, numai ke. Mengkatien keil koa mul en Tus Votut, komumoni venau. ");
INSERT INTO pma_vpl VALUES ("PS40_8","020_40_8","PSA","40","8","8","!Ahi Asuv, ek vati mok mousil hatkatien keil onom! Lises, nihuli kat hihiseien keil onom en moulien onak.” ");
INSERT INTO pma_vpl VALUES ("PS40_9","020_40_9","PSA","40","9","9","Sakini, en vangi meatin keil ten out Isrel, navit meseini keke kutut komai. Nirmusehtei, niles nihitehiten asa koa komumoni en komai. ");
INSERT INTO pma_vpl VALUES ("PS40_10","020_40_10","PSA","40","10","10","Nirvuli kattei longlongien usil mututien onom. !Vuo! Lisenges, naselus usil leikatien ka kataunien onom min meatin keil. Navong meatin keil onom alah ruai, lises navitehiteni keke rendemien onom mul en komai ka korie lat envatien onom min komai. ");
INSERT INTO pma_vpl VALUES ("PS40_11","020_40_11","PSA","40","11","11","Ahi Asuv, konakulattei enmahisien onom ranau. Lisenges kiting koe nau ven envatien onom ka leikatien tahos onom enau. ");
INSERT INTO pma_vpl VALUES ("PS40_12","020_40_12","PSA","40","12","12","Tounah tatisa houlu akarahit inau, nasakras mahuli vasi. Tisaen onak keil mea en mesai, ka narlei kileatei mun sise mousili. Nalesi keke tisaen keil onak, navuli keil lohlin hiluk, sakini desien onak mot. ");
INSERT INTO pma_vpl VALUES ("PS40_13","020_40_13","PSA","40","13","13","!Ahi Asuv, kiting koe nau! !Kikataunau li! ");
INSERT INTO pma_vpl VALUES ("PS40_14","020_40_14","PSA","40","14","14","Koakeil avit avouas nau, kilikat rasilin keil ka hesakini keil imemou. Koakeil asi keil ven mahien keil onak, ilohosai ka ulie hetisa. ");
INSERT INTO pma_vpl VALUES ("PS40_15","020_40_15","PSA","40","15","15","Koakeil amul arohtoh enau, itimanin navong huhuen keil one ral minau hemai hehi heisavos. ");
INSERT INTO pma_vpl VALUES ("PS40_16","020_40_16","PSA","40","16","16","Ka koakeil umai venuk, ilonge hetahos ka sien hel en keil. Ka koakeil kosak koe keil isi keil, keil ihitehiteni lises ka lisenges ihit, “!Isen Ahi Asuv vina nesa!” ");
INSERT INTO pma_vpl VALUES ("PS40_17","020_40_17","PSA","40","17","17","Ahi Asuv, avek merau ka navi livere enges. Em navobongentei nau li. Keik kovi Ahi onak koa mul kataunau ka kosakinau namaluv ran mahien keil onak. ");
INSERT INTO pma_vpl VALUES ("PS42_1","020_42_1","PSA","42","1","1","Ahi onak, en moulien onak, maroro kat nau venuk. Anatin, nasuval tirendan tai koa maroro kati ven oai koa kistal en oaisal; ");
INSERT INTO pma_vpl VALUES ("PS42_2","020_42_2","PSA","42","2","2","Ek vatuk houlu mok, Ahi ten moulien. ?Nengeis nimai ka niha netan en metom? ");
INSERT INTO pma_vpl VALUES ("PS42_3","020_42_3","PSA","42","3","3","Meneai ka vongien, namis, ka nasakras maanian. Koakeil alele tisa enau amules avis inau avit, “?Ueee … Ahi onom kave?” ");
INSERT INTO pma_vpl VALUES ("PS42_4","020_42_4","PSA","42","4","4","Tinok mis houlu navong namundem usil avong mulamu. Mulamu, namul ral min meatin keil koa meva en Eim Votut. Namulamun keil ka mevilelau en sien, memusau ka memasmasuk, Ahi. ");
INSERT INTO pma_vpl VALUES ("PS42_5","020_42_5","PSA","42","5","5","?Nalonge tisa varei vensa? ?Vensa namundemko mukonek? Ka mukos, naling desien onak enuk, Ahi. Nimasmasuk eris, Ahi onak koa komutut nau. ");
INSERT INTO pma_vpl VALUES ("PS42_6","020_42_6","PSA","42","6","6","En out koa namul ien kosa, soutin ran out sak, nalonge tisa. Navong namul veah en out Sodan, ka Vatihou Hermon ka Hou Misar, rendemien onak vat eris minuk, Ahi. ");
INSERT INTO pma_vpl VALUES ("PS42_7","020_42_7","PSA","42","7","7","Longmahien onak muas nau, suval mari oai koa mue nesa mot muroh en ahat keil netan. ");
INSERT INTO pma_vpl VALUES ("PS42_8","020_42_8","PSA","42","8","8","En meneai, Ahi hetie lat envatien onen enau, hesakini, nisau masmasi en vongien. Anatin, nihis minuk, Ahi ten moulien onak. ");
INSERT INTO pma_vpl VALUES ("PS42_9","020_42_9","PSA","42","9","9","Ahi koa ring koe nau, nihisi nihit, “?Vensa em vobongenau? ?Vensa namual ral min mahien ven tounah tatisa keil koa meatin tisa keil amumoni minau?” ");
INSERT INTO pma_vpl VALUES ("PS42_10","020_42_10","PSA","42","10","10","Vativieh keil onak amul aselus karenau ka nalonge navit mamat veni. Lises avis katiat nau avit, “?Ueee … Ahi onom kave?” ");
INSERT INTO pma_vpl VALUES ("PS42_11","020_42_11","PSA","42","11","11","?Nalonge tisa varei vensa? ?Vensa namundemko mukonek? Ka mukos, naling desien onak enuk, Ahi. Nimasmasuk eris, Ahi onak koa komutut nau. ");
INSERT INTO pma_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","Ahi vi keihoen ka vi out tatosuaien orer, sak mesei lises vakataun ir en avong takeih keil. ");
INSERT INTO pma_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","2","Sakini, rehermetautei, avaseini munak alu houlul ka vatihou keil imaru iha en huinev ten atas. ");
INSERT INTO pma_vpl VALUES ("PS46_3","020_46_3","PSA","46","3","3","Rehermetautei munak atas hevuvu, helohloh ka hemavul, ka sakin atan ka vatihou keil akulul. ");
INSERT INTO pma_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","En taon onen Ahi, oaisal tai mue luhu eni. Taon enek vi out votut koa Ahi ten out nesa mul ien, ka oaisal enek mul sakin meatin keil en out enek asi keil. ");
INSERT INTO pma_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","Ahi varei mul en meteimal enek, sakini asakras avou rasilini. Anatin, en visokon semau, hemai hesan kataunien min koakeil aro ien. ");
INSERT INTO pma_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","Ahi hesel hesuval voulul, ka ren hesakin atan hemasil. Hesakini, meatin keil ten out netan isil, ka keihoen onen asuv houlu keil hemerangle. ");
INSERT INTO pma_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","Iahova, asuv houlu ten out nesa, mul ven ir. Ahi onen Siekob vi out tatosuaien orer. ");
INSERT INTO pma_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","Mihemai, miheles asa koa Ahi Asuv mumoni. Miheles marmari tounah keil koa mumoni en out netan. ");
INSERT INTO pma_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","Huhuen keil ten out netan, kei mumoni evus varei. Kum vulvul hisuput keil ka ai takan keil emun. Ka ai keil tatosuaien, Ahi munit lini. ");
INSERT INTO pma_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","Ahi viteni min keil vit, “!Miheha netan ka miheilea keke inau navi Ahi! !Keihoen onen asuv keil ten out netan mules en hek! Ka moulien onen tounah vasi keil ten out netan emun mules en hek.” ");
INSERT INTO pma_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","Iahova, asuv houlu ten out nesa, mul ven ir. Ahi onen Siekob vi out tatosuaien orer. ");
INSERT INTO pma_vpl VALUES ("PS47_1","020_47_1","PSA","47","1","1","Natin Korah keil amutisi !Meatin vasi keil, miheovasvas hemi en sien! Mihemakul en isen Iahova hetal min masmasien. ");
INSERT INTO pma_vpl VALUES ("PS47_2","020_47_2","PSA","47","2","2","Mihemasmas Iahova koa vi hetetamen mok ka kur keihoen. Kei vi mari asuv houlu koa mul losil kat out vasi netan. ");
INSERT INTO pma_vpl VALUES ("PS47_3","020_47_3","PSA","47","3","3","Kei sakin ir rolohlin meatin sav keil, kei ling kantri sav keil amul en her. ");
INSERT INTO pma_vpl VALUES ("PS47_4","020_47_4","PSA","47","4","4","Atan koa romul ien, kei rie lati hehi orer, ka me-Isrel keil koa kei en vat keil, asi keil veni. ");
INSERT INTO pma_vpl VALUES ("PS47_5","020_47_5","PSA","47","5","5","Ahi vina nesa en vulin ten keihoen onen, Iahova vina nesa ral min makulien ten sien ka verien ten hon keil. ");
INSERT INTO pma_vpl VALUES ("PS47_6","020_47_6","PSA","47","6","6","!Mihesau masmas Ahi! !Mihehati lat isen asuv houlu orer! ");
INSERT INTO pma_vpl VALUES ("PS47_7","020_47_7","PSA","47","7","7","Ahi vi asuv houlu ten out vasi netan, tahos rehou lati hetal min souen keil. ");
INSERT INTO pma_vpl VALUES ("PS47_8","020_47_8","PSA","47","8","8","Ahi mul rondan en vulin ten keihoen onen koa votut, kantri keil ten out netan amul en hen. ");
INSERT INTO pma_vpl VALUES ("PS47_9","020_47_9","PSA","47","9","9","Hetetamen keil ten kantri vasi keil umai en out tas ral min meatin keil onen Ahi koa Ebraham va netan mini. Keihoen onen Ahi lohlin keihoen onen meatin tavaeen keil onen kantri vasi keil, kei mul losil kat out vasi. ");
INSERT INTO pma_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","Sam tai onen asuv houlu Deved navong provet Netan mai veni ka vit lati keke mum tisa ral min Batsiba (2Saml 13:13-17) Ahi, em hemahis nau li, veni envatien mul enuk lises. Ven more enmahisien onom mariso, sahul lin tisaen keil onak. ");
INSERT INTO pma_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Kas lin sakkalkalien keil onak eli, ka kumonau nitolas ran tisaen keil onak. ");
INSERT INTO pma_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Nalei kilea li tounah koa romaltei en moulien onak, lises namundem kilea saktisaen keil onak. ");
INSERT INTO pma_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Tisaen koa namumoni, namumoni va katuk enges, Ahi; sakien onak eli romaltei en metom. Sakini mal keke kolei revi sakien keil onak, keik komal keke kosan mahien minau. ");
INSERT INTO pma_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Sakkalkalien keil mul tuai eli enau navong avasi nau. Anatin, navong mama onak ro enau, natisaso tuai. ");
INSERT INTO pma_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Keik em vati li mok makur anatinien en moulien onak, kisien rendemien onak en meteisauen onom. ");
INSERT INTO pma_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Kisahul lin tisaen onak keke nitolas, kikas motein moulien onak eli hemai hoh vis hoh imok. ");
INSERT INTO pma_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Kimaenau nilonge hetahos eris ka nito en sien, ka avaseini mahien koa kosani minau vulvul nau, kimaenau li nimakul en sien eris. ");
INSERT INTO pma_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Konaleletei mun natisa enau, kisahul lin sakkalkalien keil onak. ");
INSERT INTO pma_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","Ahi kum kes moulien onak eli hemai hetolas, kisan rendemien hau minau koa housil katuk lisenges. ");
INSERT INTO pma_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Konasila lattei nau nanaha ranuk, konakulattei ninin onom koa vi votut naha ranau li. ");
INSERT INTO pma_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Kisan risi minau sien koa nakuri mulamu navong komutut nau, ka kumonau li ek hehati malong katuk en tounah vasi. ");
INSERT INTO pma_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Navong kosak revi nau, inau suk, nihisein meatin tatisa keil en mengkatien keil onom, ka keil emun ihiles ka iha ris venuk. ");
INSERT INTO pma_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","Ahi, kutut moulien onak, konamaentei nau li nanamat, ka inau nimakul usil maluen onom hetal min sien. ");
INSERT INTO pma_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","Ahi Asuv, kikataunau li maselus, ka nihati lat isom hetal rek. ");
INSERT INTO pma_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Em rovattei keke nuas buluk vuo sipsip keil ihi sanien votut keil minuk. Munak ninit sanien onak hehat minuk, kirsiktei veni. ");
INSERT INTO pma_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","Sanien votut onak koa nisani minuk, Ahi, hehi rendemien tai koa merau. Keik kosakras kovasesein meatin koa tin mah ven tisaen keil onen ka koa viles moulien onen ran keil. ");
INSERT INTO pma_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","Ahi onak, kum kes vieh ten taon ten out Serusalem, kitie lat tahosien onom ka kikataun Serusalem koa mul en Hou Saeon. ");
INSERT INTO pma_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","En avong koanek, kilonge hetahos eris ven sanien votut koa mal, ka en sanien votut keil koa meheniti heha venuk. En avong koanek, mehouas buluk keil ka meheling keil iha en ahor ten sanien votut heha venuk. ");
INSERT INTO pma_vpl VALUES ("PS63_1","020_63_1","PSA","63","1","1","Sam tai onen Deved navong ro suai ran asuv houlu Sol en out volvol ten out Sudah (1 Sam1 23:14) Ahi Asuv, keik kovi Ahi onak, amai kat nau venuk. Maroro kat nau venuk suval koa naro en out memes koa oai tovuol ien. ");
INSERT INTO pma_vpl VALUES ("PS63_2","020_63_2","PSA","63","2","2","Ek vati mahisu minuk en Eim Votut onom, ek vati malei vis keihoen ka muohien onom. ");
INSERT INTO pma_vpl VALUES ("PS63_3","020_63_3","PSA","63","3","3","Envatien onom koa korie lati min komai lisenges, kei tahos imok mulin tounah sav keil en moulien onomai, sakini nihati lat isom. ");
INSERT INTO pma_vpl VALUES ("PS63_4","020_63_4","PSA","63","4","4","En avong vasi en moulien onak, nisan masmasien onak minuk, navong navis, nihati lat hek keilu hehina nesa hehat venuk. ");
INSERT INTO pma_vpl VALUES ("PS63_5","020_63_5","PSA","63","5","5","Neim en tinok, kosakinau nito en tahosien hesuval koa nakan more anien tai ka nalonge tahos, ka nisau en souen keil ten masmasien hehat minuk. ");
INSERT INTO pma_vpl VALUES ("PS63_6","020_63_6","PSA","63","6","6","Navong namul en avet, namundem katuk. Vongien va rokol out mulan, namules namundem usiluk. ");
INSERT INTO pma_vpl VALUES ("PS63_7","020_63_7","PSA","63","7","7","Namundem usiluk veni lises kovi kataunien minau. Nisau hetal masmasien ven koa kokav koe inau suval toahin tai mul kav koe titan keil en apouen. ");
INSERT INTO pma_vpl VALUES ("PS63_8","020_63_8","PSA","63","8","8","Avong vasi, naro kos vesesal venuk, ka hem kur koe inau. ");
INSERT INTO pma_vpl VALUES ("PS63_9","020_63_9","PSA","63","9","9","Meatin keil koa asak visi avou vini nau, kumon keil iha netan en out ten matien. ");
INSERT INTO pma_vpl VALUES ("PS63_10","020_63_10","PSA","63","10","10","Kisakin keil imatmat en vaeen keil, ka kisakin huli rendan keil imai ian teiai one. ");
INSERT INTO pma_vpl VALUES ("PS63_11","020_63_11","PSA","63","11","11","Inau koa nihi asuv houlu ten out Isrel, nihilelau en sien navong nilesi keke Ahi ling koakeil avavae vatal minau en hek. Koakeil amumon hatkatien en isen Ahi ihati lat isen, ka koakeil amul aliluvos, keil ito raeng. ");
INSERT INTO pma_vpl VALUES ("PS65_1","020_65_1","PSA","65","1","1","Souen tai onen Deved Ahi onomai, mal keke mevati lat isom en Hou Saeon, ka mehehuli kat hatkatien keil koa memumoni ral minuk, ");
INSERT INTO pma_vpl VALUES ("PS65_2","020_65_2","PSA","65","2","2","veni keik komul kosan aneite ten hisien keil onomai. Meatin keil ten out vasi imai venuk, ");
INSERT INTO pma_vpl VALUES ("PS65_3","020_65_3","PSA","65","3","3","veni sakkalkalien keil onomai amuas komai, ka keik kosahul lin tisaen keil onomai ka konaleletei mun natisa en komai. ");
INSERT INTO pma_vpl VALUES ("PS65_4","020_65_4","PSA","65","4","4","Sien hel en koakeil keik kolei kan keil keke umai avato en teahu ten Eim Votut onom. Komai mehelonge hetahos imok en mormore tounah keil onom ten demkatien koa amul en Eim Votut onom. ");
INSERT INTO pma_vpl VALUES ("PS65_5","020_65_5","PSA","65","5","5","Kosan aneite ten hisien keil onomai navong melohlin meatin sav keil en avong ten rea. En keihoen komutut komai. Meatin keil koa amul rahit out netan ka en usi atas, keil aling desien one enuk. ");
INSERT INTO pma_vpl VALUES ("PS65_6","020_65_6","PSA","65","6","6","Ral min keihoen onom, koling kat vatihou keil, keil arie lat mari keihoen onom. ");
INSERT INTO pma_vpl VALUES ("PS65_7","020_65_7","PSA","65","7","7","Kosakin atas keil amerau, verien ten tahe keil, komumoni va netan. Kosakin koakeil amumon selien, aro raeng. ");
INSERT INTO pma_vpl VALUES ("PS65_8","020_65_8","PSA","65","8","8","Meatin keil ten out vasi en out netan amutimanin ven marmari tounah keil koa komumoni. En keite vasi keil ten out netan, meatin keil amakul en sien venuk. ");
INSERT INTO pma_vpl VALUES ("PS65_9","020_65_9","PSA","65","9","9","Kolei kat revi atan ka kosan ous musani, kosakin amas mul ien ka tounah vasi amoul tahos ien. Kosakin oai vilelau en poal keil, ka kosakin anien mul moul en out netan. Keik komul komumoni mukok: ");
INSERT INTO pma_vpl VALUES ("PS65_10","020_65_10","PSA","65","10","10","navong meatin keil akah lin out evus, kosan ous musani. Atan koa keih, ous sakini mai memerau, ka tounah vasi akilea avahitehiteh eni. ");
INSERT INTO pma_vpl VALUES ("PS65_11","020_65_11","PSA","65","11","11","Ven tahosien onom, kosan amas min komai. Out vasi kova ien, amas musiluk. ");
INSERT INTO pma_vpl VALUES ("PS65_12","020_65_12","PSA","65","12","12","Kosakin tirendan osomai avilelau en atan onomai, hou keil avilelau en sien. ");
INSERT INTO pma_vpl VALUES ("PS65_13","020_65_13","PSA","65","13","13","Buluk ka sipsip keil osomai avi houlu, ka kosakin ah osomai avilelau en anien. Tounah vasi koa moul alonge tahos ven amas onom, ka amusau masmasuk. ");
INSERT INTO pma_vpl VALUES ("PS66_1","020_66_1","PSA","66","1","1","!Meatin vasi keil ten out netan, mihemasmas Ahi hetal makulien ten sien! ");
INSERT INTO pma_vpl VALUES ("PS66_2","020_66_2","PSA","66","2","2","Mihesau usil isen koa vi hetetamen, mihesan masmasien mini ven hetetamenien onen. ");
INSERT INTO pma_vpl VALUES ("PS66_3","020_66_3","PSA","66","3","3","Mihehiteni min Ahi mihehit, “!Tounah vasi koa komumoni tahos imok! Keihoen onom marite mok, mul sakin vativieh onom keil amaleilei en metom. ");
INSERT INTO pma_vpl VALUES ("PS66_4","020_66_4","PSA","66","4","4","Koakeil vasi amul en out netan uva netan minuk, keil amusau masmasuk, amusau masmas isom.” ");
INSERT INTO pma_vpl VALUES ("PS66_5","020_66_5","PSA","66","5","5","Almai ka alles asa Ahi mumoni, mormore tounah keil koa mumoni ven meatin keil ten out netan. ");
INSERT INTO pma_vpl VALUES ("PS66_6","020_66_6","PSA","66","6","6","Kei viles Atas Tahilhili mai vi atan tames, kei sakin avu orer keil amu koteh Oaisal Sodan en ale. Ekonek rosi ir ven asa kei mumoni. ");
INSERT INTO pma_vpl VALUES ("PS66_7","020_66_7","PSA","66","7","7","En keihoen onen, mul losil kat out netan, mul lei kokoe en kantri keil vasi keke koakeil asesein losilkatien onen, anahati lat sasentei keil. ");
INSERT INTO pma_vpl VALUES ("PS66_8","020_66_8","PSA","66","8","8","Meatin keil ten out netan, rehemasmas Ahi orer, masmasien orer heha vasin out. ");
INSERT INTO pma_vpl VALUES ("PS66_9","020_66_9","PSA","66","9","9","Kei kur koe moulien orer, romaentei tounah vasut ir. ");
INSERT INTO pma_vpl VALUES ("PS66_10","020_66_10","PSA","66","10","10","Ahi, keik kosan sakvisien min komai. Suval silva koa ahang kan moteini, komotein moulien onomai en sakvisien keil. ");
INSERT INTO pma_vpl VALUES ("PS66_11","020_66_11","PSA","66","11","11","Komaen komai mimot en eitapolis tai, ka koling tounah keil koa meas en eisilomai. ");
INSERT INTO pma_vpl VALUES ("PS66_12","020_66_12","PSA","66","12","12","Komaen koakeil avi vativieh ral komai avitan en komai, e memu koteh ahang ka oai. Ka kosa, komul kolah lat komai meva en out ten amas. ");
INSERT INTO pma_vpl VALUES ("PS66_13","020_66_13","PSA","66","13","13","Nikur sanien votut hemai en Eim Votut onom ka niniti hehat minuk, nisani minuk asa koa navat kati. ");
INSERT INTO pma_vpl VALUES ("PS66_14","020_66_14","PSA","66","14","14","Asa koa navat kati minuk navong namul en avong tisa, nisani minuk. ");
INSERT INTO pma_vpl VALUES ("PS66_15","020_66_15","PSA","66","15","15","Nikur sipsip keil ka ninit keil en ahor ten sanien venuk, ninit buluk ka nani keil emun hesakin vite hetupan hehat venuk. ");
INSERT INTO pma_vpl VALUES ("PS66_16","020_66_16","PSA","66","16","16","Kami koa mivouhou min Ahi, almai ka allong nau. Nihitehiteni min kami tounah sa koa kei mumoni minau. ");
INSERT INTO pma_vpl VALUES ("PS66_17","020_66_17","PSA","66","17","17","Navis kataunien mini, ka namasmasi ral min souen keil. ");
INSERT INTO pma_vpl VALUES ("PS66_18","020_66_18","PSA","66","18","18","Munak nihuli kat tisaen keil en moulien onak, Ahi Asuv hesakras valong nau. ");
INSERT INTO pma_vpl VALUES ("PS66_19","020_66_19","PSA","66","19","19","Ka Ahi raengonau varei, kei long hisien onak. ");
INSERT INTO pma_vpl VALUES ("PS66_20","020_66_20","PSA","66","20","20","Namasmas Ahi veni kei roseseintei hisien onak, vuo rokulattei envatien onen koa mul lises ka lisenges ranau. ");
INSERT INTO pma_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","Ahi, kitokol kat komai en enmahisien onom, kiles komai hetal min tahosien onom. ");
INSERT INTO pma_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","Kitie lat rendemien onom min meatin keil ten out netan, keke availea sise ten mututien onom. ");
INSERT INTO pma_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","O Ahi, meatin keil ihati latuk. Anatin, meatin vasi keil ihati lat isom. ");
INSERT INTO pma_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","Meatin ten kantri vasi keil isi keil ka isau en sien, keil isau veni keik kosan mahien min meatin keil en sakien ten maluen, keik komulamun meatin ten kantri vasi keil en out netan. ");
INSERT INTO pma_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","O Ahi, meatin keil ihati latuk. Anatin, meatin vasi keil ihati lat isom. ");
INSERT INTO pma_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","Ahi onomai, komul kosan tokolkatien min komai, komul kosakin amas mul en atan osomai. ");
INSERT INTO pma_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","Anatin, tokolkatien onom mul en komai, ka koakeil ten out netan ilesi ka ihouhou minuk. ");
INSERT INTO pma_vpl VALUES ("PS70_1","020_70_1","PSA","70","1","1","Asuv houlu Deved mutisi O Ahi, kutut moulien onak eli. O Iahova, kikalah kimai kikataunau. ");
INSERT INTO pma_vpl VALUES ("PS70_2","020_70_2","PSA","70","2","2","Koakeil avit avou vini nau, keik kilikat rasilin keil keke imemou. Koakeil asi keil ven sakvisien keil onak, ilohosai ka ulie hetisa. ");
INSERT INTO pma_vpl VALUES ("PS70_3","020_70_3","PSA","70","3","3","Koakeil amul amumon tohtohien va kat inau, kisakin huhuen keil one ral minau hemai hehi heisavos keke ilohosai en memouen. ");
INSERT INTO pma_vpl VALUES ("PS70_4","020_70_4","PSA","70","4","4","Ka koakeil umai venuk, isi keil ka ilonge hetahos venuk. Koakeil e vat mututien onom ihitehiteni lises ihit, “!Ahi vi hetetamen imok!” ");
INSERT INTO pma_vpl VALUES ("PS70_5","020_70_5","PSA","70","5","5","O Ahi, avek memerau ka navi livere enges, kikalah kimai venau li. Keik kovi kataunien onak ka korali lat inau lises. O Iahova, konatountei li. ");
INSERT INTO pma_vpl VALUES ("PS71_1","020_71_1","PSA","71","1","1","O Iahova, numai mato suai enuk, konamaentei vativieh keil onak anali nau ka anasakinau nanamemou. ");
INSERT INTO pma_vpl VALUES ("PS71_2","020_71_2","PSA","71","2","2","Kimai kikataunau ka kiting koe nau ran tounah koa vasut nau, veni keik komal revi. Kitaengon isien onak eli ka kutut inau. ");
INSERT INTO pma_vpl VALUES ("PS71_3","020_71_3","PSA","71","3","3","Keik kihi out tatosuaien onak, koa nakilea mato suai ien. Kisan mengkatien keke mututien onak hemai hekistal veni naling desien onak enuk suval koa naling desien onak en eim tai koa keih imok. ");
INSERT INTO pma_vpl VALUES ("PS71_4","020_71_4","PSA","71","4","4","O Ahi onak, kikulat nau ran hen koakeil amum kalkali, ran keihoen onen koakeil amum romaltei ka apurun heisav en mesav keil. ");
INSERT INTO pma_vpl VALUES ("PS71_5","020_71_5","PSA","71","5","5","O Ahi Asuv, naling desien onak enuk. O Iahova, nakur anatin enuk navong navi havivi rokol kosa. ");
INSERT INTO pma_vpl VALUES ("PS71_6","020_71_6","PSA","71","6","6","Navarengein moulien onak enuk. Keik koro ral minau en avong avasi inau rokol kosa. Lisenges, nimasmasuk. ");
INSERT INTO pma_vpl VALUES ("PS71_7","020_71_7","PSA","71","7","7","Kosakin moulien onak suval metai tai koa meatin sav keil alesi ka aleisungeini, veni keik koring koe nau keih. ");
INSERT INTO pma_vpl VALUES ("PS71_8","020_71_8","PSA","71","8","8","En avong vasi, namasmasuk. Navitehiten hetetamenien onom lises. ");
INSERT INTO pma_vpl VALUES ("PS71_9","020_71_9","PSA","71","9","9","Konaso seseintei nau navong nihi ulmatu, konalokoveintei nau navong keihoen onak hetovuol emun. ");
INSERT INTO pma_vpl VALUES ("PS71_10","020_71_10","PSA","71","10","10","Vativieh keil onak avit avou vini nau, keil avit usil inau ka amumon hatkatien va kat inau. ");
INSERT INTO pma_vpl VALUES ("PS71_11","020_71_11","PSA","71","11","11","Aviteni avit, “Ahi lokoveini ka tovuol vakatauni, sakini rovakatau usili ka rovahuli kati.” ");
INSERT INTO pma_vpl VALUES ("PS71_12","020_71_12","PSA","71","12","12","O Ahi onak, konaltei soutin ranau, kikalah kimai kikataunau li. ");
INSERT INTO pma_vpl VALUES ("PS71_13","020_71_13","PSA","71","13","13","Kisakin koakeil avit avapurun nau, imemou ka ise hetisa. Koakeil uvae kat nau, kisakin keil imemou ka ku vinvini keil. ");
INSERT INTO pma_vpl VALUES ("PS71_14","020_71_14","PSA","71","14","14","Ka inau, niling desien onak enuk, ka nil nimasmasuk hehi houlu vis hehi houlu mok. ");
INSERT INTO pma_vpl VALUES ("PS71_15","020_71_15","PSA","71","15","15","Inau, nil nihit usil umen keil onom koa mal, niselus usil sakien keil ten mututien onom lises, avaseini nasakras mahuli vasi. ");
INSERT INTO pma_vpl VALUES ("PS71_16","020_71_16","PSA","71","16","16","Nimai hetal masmasien ven tounah koa keik, Iahova koa kovi Ahi onomai, komumoni ral min keihoen onom. Nihit usil umen keil koa mal koa keik enges, komumoni. ");
INSERT INTO pma_vpl VALUES ("PS71_17","020_71_17","PSA","71","17","17","Koviseinau navong navi ehon rokol kosa, ka namules navitehiten mormore tounah koa komumoni. ");
INSERT INTO pma_vpl VALUES ("PS71_18","020_71_18","PSA","71","18","18","Sakini, navong nihi ulmatu ka hiluk hoh, konalokoveintei nau li, Ahi. Kitos hetal minau navong nihitehiten usil keihoen ka hetetamenien onom min titiali keil koa amul, ka min koakeil il imai veah ikatau. ");
INSERT INTO pma_vpl VALUES ("PS71_19","020_71_19","PSA","71","19","19","Ahi, sakien keil ten maluen onom marite vis marite mok. Komumon marmari tounah keil ka tovuol vasuvaluk. ");
INSERT INTO pma_vpl VALUES ("PS71_20","020_71_20","PSA","71","20","20","Avaseini komaenau navisu en avong takeih ka sakvisien keil, katau eni, kisan ris keihoen minau. Munak namesai vesesal mamat, ka korali lat ris nau ran matien. ");
INSERT INTO pma_vpl VALUES ("PS71_21","020_71_21","PSA","71","21","21","Kisan ris hetetamenien minau heli koa nakuri mulamu. Kisuv lat ris rendemien onak. ");
INSERT INTO pma_vpl VALUES ("PS71_22","020_71_22","PSA","71","22","22","Nisau masmasuk hetal min kitar onak. O Ahi onak, nimasmasuk veni komusil kat hatkatien keil onom lises. Anatin, hetal min iukalele onak, nisau en souen keil heha minuk, Ahi onen me-Isrel keil, kovi votut imok. ");
INSERT INTO pma_vpl VALUES ("PS71_23","020_71_23","PSA","71","23","23","Nimakul en sien, nisau hetal min moulien vasi onak veni keik komutut nau. ");
INSERT INTO pma_vpl VALUES ("PS71_24","020_71_24","PSA","71","24","24","Nihit usil sakien ten maluen onom lises, veni koakeil avit avapurunau, keik kolikat rasilin keil ka kosakin keil alohosai en memouen. ");
INSERT INTO pma_vpl VALUES ("PS84_1","020_84_1","PSA","84","1","1","Natin Korah keil amutisi Iahova, asuv houlu ten out nesa, Eim Votut onom vi moreite mok. ");
INSERT INTO pma_vpl VALUES ("PS84_2","020_84_2","PSA","84","2","2","Ek vati mato en out enek. Ek vati mok mato en Eim Votut onen Iahova. Ral min moulien vasi onak, nisau en sien minuk, Ahi koa moul. ");
INSERT INTO pma_vpl VALUES ("PS84_3","020_84_3","PSA","84","3","3","Tahos imok masuval avervatu keil koa amumon anu ome en Eim Votut onom, keil avise eim onom vahi teim se. Keil aravo kat titae keil vesesal ven ahor onom, O Iahova, asuv houlu ten out nesa, keik kovi asuv houlu onak ka Ahi onak. ");
INSERT INTO pma_vpl VALUES ("PS84_4","020_84_4","PSA","84","4","4","Tokolkatien mul en koakeil aro en Eim onom, veni keil amusau masmasuk lises. ");
INSERT INTO pma_vpl VALUES ("PS84_5","020_84_5","PSA","84","5","5","Tokolkatien hel en koakeil amundesinuk keke kovasan keihoen min keil, min koakeil aling rendemien one keke avaha avasao en Eim Votut onom en Hou Saeon. ");
INSERT INTO pma_vpl VALUES ("PS84_6","020_84_6","PSA","84","6","6","Navong amual aka vas poal tames ten out Baka, keil ales oai mul memela en ahat keil, ka ous mus rohtoh sien vulioai keil. ");
INSERT INTO pma_vpl VALUES ("PS84_7","020_84_7","PSA","84","7","7","Keil akur keihoen en sise one, hetokol avong keil iles Ahi en out Saeon, kei koa vi houlu mulin ahi keil onen meatin sav keil. ");
INSERT INTO pma_vpl VALUES ("PS84_8","020_84_8","PSA","84","8","8","O Iahova, Ahi ten out nesa, kitaengon hisien onak eli. Ahi onen Siekob, kisan ralingom minau. ");
INSERT INTO pma_vpl VALUES ("PS84_9","020_84_9","PSA","84","9","9","O Ahi, kitokol kat asuv houlu onomai koa suval eikokoe onomai. Kilele hetahos min kei koa korie lati. ");
INSERT INTO pma_vpl VALUES ("PS84_10","020_84_10","PSA","84","10","10","Munak nakilea matos en teahu ten Eim Votut onom avong tas, kei tahos imok mulin avong taosen tai en out sav. Ahi onak, munak mal mahi meatin kuren tanges koa lei kokoe voiteh ten Eim Votut onom, nisi nau mok helin munak mato en amas en eim tavolin onen kei koa mum kalkali. ");
INSERT INTO pma_vpl VALUES ("PS84_11","020_84_11","PSA","84","11","11","Iahova, keik komul koring koe komai ka muohien onom suval meteiai. Kosan tahosien ka houhouen min komai. Keik korseseintei kovasan tounah keil tetahos min koakeil ualien one mutolas. ");
INSERT INTO pma_vpl VALUES ("PS84_12","020_84_12","PSA","84","12","12","Iahova, asuv houlu ten out nesa, tokolkatien onom hel en koakeil aling desien one enuk. ");
INSERT INTO pma_vpl VALUES ("PS85_1","020_85_1","PSA","85","1","1","Natin Korah keil amutisi Iahova, kosik kovasan tahosien en atan osom. Anatin, kosan ris amas en atan ten out Isrel. ");
INSERT INTO pma_vpl VALUES ("PS85_2","020_85_2","PSA","85","2","2","Komumon methos onom en komai, meatin keil onom koa memum tisa minuk, korleletei mun vatisa en sakkalkalien keil onomai. ");
INSERT INTO pma_vpl VALUES ("PS85_3","020_85_3","PSA","85","3","3","Tinom rovepengtei mun en komai, kihiles vurohien onom heha ran komai. ");
INSERT INTO pma_vpl VALUES ("PS85_4","020_85_4","PSA","85","4","4","Ahi ten mututien onomai, kiling ris komai en vulumai, ka tinom naattei mun komai. ");
INSERT INTO pma_vpl VALUES ("PS85_5","020_85_5","PSA","85","5","5","?Ahi, mukave? ?Tinom heat komai lisenges? ?Kitie lat vurohien onom min titamai ka havimai keil? ");
INSERT INTO pma_vpl VALUES ("PS85_6","020_85_6","PSA","85","6","6","Kisan ris tahosien min komai li, meatin keil onom, keke mekilea mevamasmasuk. ");
INSERT INTO pma_vpl VALUES ("PS85_7","020_85_7","PSA","85","7","7","O Iahova, kitie lati min komai envatien onom koa sakras vavus, ka kutut moulien keil onomai. ");
INSERT INTO pma_vpl VALUES ("PS85_8","020_85_8","PSA","85","8","8","Kami meatin keil mihetaengonau. Inau, nilong kat asa koa Iahova koa vi Ahi hehiteni minau. Kei vat kati keke hesan tomat min meatin keil onen. Ka meatin votut keil onen irmumontei mun unounien one. ");
INSERT INTO pma_vpl VALUES ("PS85_9","020_85_9","PSA","85","9","9","Anatin eli keke kei sak mesei voutut koakeil avouhou mini. Kei hekataun ir keke toralien onen koa hetetamen imok kilea val en atan oser. ");
INSERT INTO pma_vpl VALUES ("PS85_10","020_85_10","PSA","85","10","10","Ahi hetie lat envatien onen min meatin keil onen ka keil usil kati lisenges. Keil um hemal en meten, ka kei hesan tomat hel ven keil. ");
INSERT INTO pma_vpl VALUES ("PS85_11","020_85_11","PSA","85","11","11","Meatin keil ten out netan iseipat ka usil kat Ahi, ka kei en out nesa hetapehai en keil ka hetali lat keil en maluen onen. ");
INSERT INTO pma_vpl VALUES ("PS85_12","020_85_12","PSA","85","12","12","Anatin keke Iahova houmon amas min ir, hesakin aneite hehi houlu hekistal en atan oser. ");
INSERT INTO pma_vpl VALUES ("PS85_13","020_85_13","PSA","85","13","13","Maluen onen Iahova mulamuni ka mul sak mesein sise onen. ");
INSERT INTO pma_vpl VALUES ("PS92_1","020_92_1","PSA","92","1","1","Tahos imok keke mevasan masmasien vahat minuk, Iahova. Mevati lat isom ral min souen keil, keik koa koro en out nesa. ");
INSERT INTO pma_vpl VALUES ("PS92_2","020_92_2","PSA","92","2","2","En visokon vasi, meselus usil envatien onom, ka vongien vasi, meviteni mun keke komum vasi tounah koa kovat kati. ");
INSERT INTO pma_vpl VALUES ("PS92_3","020_92_3","PSA","92","3","3","Memusau minuk navong mepilei en kitar ka memuas ave venuk. ");
INSERT INTO pma_vpl VALUES ("PS92_4","020_92_4","PSA","92","4","4","Inau nasi nau houlu ven sakien keil onom, veni umen koa komumoni mul sakinau namusau ral min sien. ");
INSERT INTO pma_vpl VALUES ("PS92_5","020_92_5","PSA","92","5","5","Iahova, umen keil onom avi hetetamen imok, rendemien keil onom mul nesa mok. ");
INSERT INTO pma_vpl VALUES ("PS92_6","020_92_6","PSA","92","6","6","Meatin koa vi unu sakras vailea, ka meatin koa vatin tovuol reingeingen tounah keil ekek varei. ");
INSERT INTO pma_vpl VALUES ("PS92_7","020_92_7","PSA","92","7","7","Avaseini meatin tisa keil avi houlu suval oumunai tatisa keil ka rolesi suval koakeil amum romaltei aro tahosis, hekatau, Ahi helei rahit usite one ka hou lin keil vasi. ");
INSERT INTO pma_vpl VALUES ("PS92_8","020_92_8","PSA","92","8","8","Ka keik, Iahova, isom vi hetetamen imok lisenges. ");
INSERT INTO pma_vpl VALUES ("PS92_9","020_92_9","PSA","92","9","9","Iahova, mekilea keke koakeil uvae katuk imat. Vativieh keil onom, keil vasi itetasil ka ivuol. ");
INSERT INTO pma_vpl VALUES ("PS92_10","020_92_10","PSA","92","10","10","Iahova, avek keih veni kosan keihoen minau, ka korokol kat inau ral min sien. ");
INSERT INTO pma_vpl VALUES ("PS92_11","020_92_11","PSA","92","11","11","Nalong isien onen vativieh keil onak ka nalei kilea keke keihoen one tovuol emun. ");
INSERT INTO pma_vpl VALUES ("PS92_12","020_92_12","PSA","92","12","12","Meatin keil koa moulien one mal en metom imoul hesuval vati matou tai, imoul hetaveah hesuval vati avek tai. ");
INSERT INTO pma_vpl VALUES ("PS92_13","020_92_13","PSA","92","13","13","Meatin keil ekek asuval vatiai keil koa aluhi amul vesesal en eim onen Iahova, koa amoul en teahu ten Eim Votut onen Ahi orer. ");
INSERT INTO pma_vpl VALUES ("PS92_14","020_92_14","PSA","92","14","14","Avaseini avi ulmatu tuai, amul veah ason heite en moulien one. Anatin, ales tahosien ka ave keih veah. ");
INSERT INTO pma_vpl VALUES ("PS92_15","020_92_15","PSA","92","15","15","Koanik mul rie lati keke sakien onen Iahova mal revi. Namul naro suai eni, ka tounah tovuol vakalkali eni. ");
INSERT INTO pma_vpl VALUES ("PS93_1","020_93_1","PSA","93","1","1","Iahova, keik vi asuv houlu orer. Komusin en keihoen ka hetetamenien. Keik komum revi out netan, ka tounah tovuol kilea vakaikai eni. ");
INSERT INTO pma_vpl VALUES ("PS93_2","020_93_2","PSA","93","2","2","Iahova, tounah vasi keil amul en hem. Ka en avong telamu koa out netan tovuol veah, keik komul tuai. ");
INSERT INTO pma_vpl VALUES ("PS93_3","020_93_3","PSA","93","3","3","Iahova, navong atas mea ka mavul kat veien, verien teni marite. Navong atas mul mea en mari tahe keil koa amavul kat tounah, suval koa amul avitehiten usil keihoen onom ral min mari ren. ");
INSERT INTO pma_vpl VALUES ("PS93_4","020_93_4","PSA","93","4","4","Iahova, isom hetetamen imok en out nesa. Kokeih imok mulin keihoen ten atas, ka komarite imok mulin marmari tahe keil koa amavul en out ut. ");
INSERT INTO pma_vpl VALUES ("PS93_5","020_93_5","PSA","93","5","5","Mengkatien onom sakras vavuol, ka Eim Votut koa koro ien vi votut vis vi votut imok lisenges. ");
INSERT INTO pma_vpl VALUES ("PS95_1","020_95_1","PSA","95","1","1","!Almai, rovamasmas Iahova! Rehesau min Ahi hetal min sien veni kei mutut moulien orer ka mul lei kokoe en ir. ");
INSERT INTO pma_vpl VALUES ("PS95_2","020_95_2","PSA","95","2","2","Rehemai vesesal veni hetal min masmasien, ka rehesau mini hetal min souen keil ten sien. ");
INSERT INTO pma_vpl VALUES ("PS95_3","020_95_3","PSA","95","3","3","Rehoumoni hemukonek veni Iahova, keihoen onen mariso, ka kei vi asuv houlu koa vi hetetamen imok mulin ahi sav keil. ");
INSERT INTO pma_vpl VALUES ("PS95_4","020_95_4","PSA","95","4","4","Out vasi en out netan amul en hen. Anatin, kei mul losil kat huinev ten atan vina rokol mari vatihou keil nesa vis nesa mok. ");
INSERT INTO pma_vpl VALUES ("PS95_5","020_95_5","PSA","95","5","5","Atas vi onen, veni kei varei mumoni. Ka atan vasi keil vi osen veni hen keilu mumoni. ");
INSERT INTO pma_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","Almai, rovaha netan ka rehemalingling mini. Anatin, rehetetengeiril en meten Iahova koa mumon ir. ");
INSERT INTO pma_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","Suval meatin tai koa mul losil kat revi sipsip keil osen, kei vi Ahi orer ka mul losil kat revi ir koa rovi meatin keil onen. Kosa, mihelong revi asa koa Ahi viteni min kami vit, ");
INSERT INTO pma_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","8","“Minoumontei vatumi nakeih nasuval avu onami keil amumoni en out Meribah, nasuval koa amumoni en avong enek en out volvol ten out Massah. ");
INSERT INTO pma_vpl VALUES ("PS95_9","020_95_9","PSA","95","9","9","Avu onami keil asak vis inau, avaseini keke alei kilea tounah houlu tuai koa namumoni ven keil. ");
INSERT INTO pma_vpl VALUES ("PS95_10","020_95_10","PSA","95","10","10","Sua hanumau elu (40), keil atisaso en metok, veni tine mul soutin ranau ka e rovattei mun availea mengkatien keil onak. ");
INSERT INTO pma_vpl VALUES ("PS95_11","020_95_11","PSA","95","11","11","Sakini, navuroh kat keil ka navat kati keke asakras avaha en out koa nisakin keil avaseh revi eni.” ");
INSERT INTO pma_vpl VALUES ("PS96_1","020_96_1","PSA","96","1","1","!Mihesau en souen hau tai heha min Iahova! !Meatin vasi keil ten out netan, mihesau mini! ");
INSERT INTO pma_vpl VALUES ("PS96_2","020_96_2","PSA","96","2","2","!Mihehati lat Iahova hetal min souen keil! En avong vasi, mihehitehiten more longlongien mihehit kei mul mutut moulien orer. ");
INSERT INTO pma_vpl VALUES ("PS96_3","020_96_3","PSA","96","3","3","Mihehitehiten usil hetetamenien onen heha en out vasi en out netan. Mihehit usil keihoen onen min meatin vasi keil. ");
INSERT INTO pma_vpl VALUES ("PS96_4","020_96_4","PSA","96","4","4","Iahova tahos imok, ka mal keke rehehati lat isen. Rehehouhou min kei sasen, ka rehermusiltei ahi sav keil. ");
INSERT INTO pma_vpl VALUES ("PS96_5","020_96_5","PSA","96","5","5","Ahi keil onen meatin savsav keil avi heisav enges, ka Iahova koa mumon out nesa, kei vi Ahi anatin. ");
INSERT INTO pma_vpl VALUES ("PS96_6","020_96_6","PSA","96","6","6","Kei vi asuv houlu orer ka muohien ten hetetamenien onen mul ritin karahiti. Eim Votut onen vilelau en keihoen ka tahosien onen. ");
INSERT INTO pma_vpl VALUES ("PS96_7","020_96_7","PSA","96","7","7","Rehemasmas Iahova, meatin vasi keil ten out netan, ven keihoen ka hetetamenien onen. ");
INSERT INTO pma_vpl VALUES ("PS96_8","020_96_8","PSA","96","8","8","Rehehati lat isen Ahi hehina nesa, ka rehelah sanien votut keil orer heha en Eim Votut onen. ");
INSERT INTO pma_vpl VALUES ("PS96_9","020_96_9","PSA","96","9","9","Rehetetengeiril en meten Ahi koa vi votut imok. Kami vasi en out netan, mihemaleilei en metauen navong mimai vesesal veni. ");
INSERT INTO pma_vpl VALUES ("PS96_10","020_96_10","PSA","96","10","10","!Mihehiteni min meatin vasi keil en kantri vasi keil keke Iahova vi asuv houlu! Ahi mul vuli kat revi out netan, ka tounah tovuol vating lati. Ahi helei rahit usite onen meatin vasi keil en sakien koa mal. ");
INSERT INTO pma_vpl VALUES ("PS96_11","020_96_11","PSA","96","11","11","Out netan ka teilang nesa, lusi keilu. Atas ka tounah vasi keil koa amul ien, amakul en masmasien min Ahi. ");
INSERT INTO pma_vpl VALUES ("PS96_12","020_96_12","PSA","96","12","12","Tounah keil vasi koa amoul en out netan, asi keil. Vatiai keil ten eivorohus, amusau ral min sien. ");
INSERT INTO pma_vpl VALUES ("PS96_13","020_96_13","PSA","96","13","13","Tounah vasi keil enek asi keil veni Iahova mul mai keke vahi asuv houlu ten out netan. Ahi mul losil kat revi meatin vasi keil ten out netan, ka helei rahit usite one en sakien ten maluen ka anatinien. ");
INSERT INTO pma_vpl VALUES ("PS97_1","020_97_1","PSA","97","1","1","!Iahova vi asuv houlu! Kami vasi en out netan, mihemakul en sien. Kami koa miro en aelan keil, mihesi kami. ");
INSERT INTO pma_vpl VALUES ("PS97_2","020_97_2","PSA","97","2","2","Kei mul losil kat meatin keil musil sakien koa mal ka mul visein keil musil maluen onen. Mahmah keil koa matetel ka vopoli mul kav koe Ahi suval eisin omon asuv houlu tai. ");
INSERT INTO pma_vpl VALUES ("PS97_3","020_97_3","PSA","97","3","3","Navong mul mai, ahang mulamuni, ka mul kan lin vativieh keil onen en usite vasi keil. ");
INSERT INTO pma_vpl VALUES ("PS97_4","020_97_4","PSA","97","4","4","Kei mumon ahil vil en out vasi en out netan, ka koakeil vasi alesi amaleilei en metauen. ");
INSERT INTO pma_vpl VALUES ("PS97_5","020_97_5","PSA","97","5","5","Navong Iahova koa vi asuv ten tounah vasi keil en out netan mul mai, vatihou keil aretengeiril umai ka avi aet. ");
INSERT INTO pma_vpl VALUES ("PS97_6","020_97_6","PSA","97","6","6","Tounah keil vasi koa amul en teilang avitehiteni keke Ahi mal vasi ka meatin vasi keil alei kilea hetetamenien onen. ");
INSERT INTO pma_vpl VALUES ("PS97_7","020_97_7","PSA","97","7","7","Koakeil avasi keil ven nana keil one imemou, veni uva netan min nana keil one koa avi heisav enges, Ka tounah vasi koa uva netan min keil vasuval avahi ahi one, keil vasi enek alei kilea hetetamenien onen Iahova ka iha netan mini. ");
INSERT INTO pma_vpl VALUES ("PS97_8","020_97_8","PSA","97","8","8","O Ahi Asuv, veni komul kolei rahit usite onen meatin keil en sakien koa mal, meatin keil koa aro en Hou Saeon alonge tahos, ka koakeil aro en meteimal keil ten out Sudah, asi keil. ");
INSERT INTO pma_vpl VALUES ("PS97_9","020_97_9","PSA","97","9","9","Keik, Iahova, kovi houlu mok mulin tounah vasi keil ten out netan, ka kovi nesa vis nesa mok mulin ahi savsav keil vasi. ");
INSERT INTO pma_vpl VALUES ("PS97_10","020_97_10","PSA","97","10","10","Iahova, envatien onen mul en koakeil e rovattei tisaen. Kei mul lei kokoe en moulien onen koakeil amusil kati, ka mul mutut moulien one ran hen meatin tisa keil. ");
INSERT INTO pma_vpl VALUES ("PS97_11","020_97_11","PSA","97","11","11","Meneai onen mul ritin en koakeil amal en meten, ka kei mul san sien min koakeil amuto. ");
INSERT INTO pma_vpl VALUES ("PS97_12","020_97_12","PSA","97","12","12","Kami koa mimal, mihesi kami ven Iahova koa vi votut, ka mihesan masmasien mini. ");
INSERT INTO pma_vpl VALUES ("PS98_1","020_98_1","PSA","98","1","1","!Mihesau en souen hau tai min Iahova! !Kei mumon tounah keil koa atahos imok! Kei sasen vitan en vativieh keil onen ral min keihoen ka hivotutien onen. ");
INSERT INTO pma_vpl VALUES ("PS98_2","020_98_2","PSA","98","2","2","Iahova rie lati keke keihoen onen mulin teisav keil ka vothot eni keke mul vae en usite onen meatin keil onen keke voutut keil en meten meatin vasi keil ten out netan. ");
INSERT INTO pma_vpl VALUES ("PS98_3","020_98_3","PSA","98","3","3","Kei en rovobongentei vatie lat envatien onen min me-Isrel keil, ka lisenges kei mum vasin hatkatien keil onen. Meatin keil ten out vasi netan alesi mukave keihoen onen Ahi orer mulin teisav keil. ");
INSERT INTO pma_vpl VALUES ("PS98_4","020_98_4","PSA","98","4","4","Meatin vasi keil ten out netan, mihesau hetal min sien heha min Iahova. Mihemakul en sien ka mihemasmas Ahi hetal min souen keil. ");
INSERT INTO pma_vpl VALUES ("PS98_5","020_98_5","PSA","98","5","5","Mihouas kitar ka mihesau min Iahova, mihemasmasi hetal min souen keil. ");
INSERT INTO pma_vpl VALUES ("PS98_6","020_98_6","PSA","98","6","6","Mihouh amaru ka mihemakul en sien, mihoumoni heha min Iahova koa vi asuv houlu orer. ");
INSERT INTO pma_vpl VALUES ("PS98_7","020_98_7","PSA","98","7","7","Atas ka tounah vasi keil koa amul ien, amakul en masmasien min Ahi. Out netan ka tounah vasi keil koa amoul ien, amusau mini. ");
INSERT INTO pma_vpl VALUES ("PS98_8","020_98_8","PSA","98","8","8","Oai mul mue en sien min Ahi ka eang en vatihou keil mul muhuh en souen keil. ");
INSERT INTO pma_vpl VALUES ("PS98_9","020_98_9","PSA","98","9","9","Tounah vasi keil enek asi keil veni Iahova mul mai keke vahi asuv houlu ten out netan. Ahi helosil kat revi tounah vasi keil ten out netan, ka helei rahit usite one en sakien ten maluen ka anatinien. ");
INSERT INTO pma_vpl VALUES ("PS100_1","020_100_1","PSA","100","1","1","!Meatin keil ten out netan, mihemakul en sien min Iahova! ");
INSERT INTO pma_vpl VALUES ("PS100_2","020_100_2","PSA","100","2","2","Tinomi hehilelau en sien navong miheha netan mini. Mihemai vesesal veni hetal min souen keil. ");
INSERT INTO pma_vpl VALUES ("PS100_3","020_100_3","PSA","100","3","3","Miheilea keke Iahova vi Ahi. Kei varei mumon ir, ka rovi onen. Ir romul en hen, ka kei mul losil kat revi ir suval meatin tai mul losil kat revi sipsip keil osen. ");
INSERT INTO pma_vpl VALUES ("PS100_4","020_100_4","PSA","100","4","4","Miheha en Eim Votut onen hetal min masmasien, mihehati lat isen en teahu teni. ");
INSERT INTO pma_vpl VALUES ("PS100_5","020_100_5","PSA","100","5","5","Iahova tahos vis tahos imok. Envatien onen sakras vavus, ka kei mul mum vasin hatkatien keil onen lisenges. ");
INSERT INTO pma_vpl VALUES ("PS111_1","020_111_1","PSA","111","1","1","!Rehehati lat isen Iahova! Hetal min moulien vasi onak, nil nisan masmasien heha min Iahova. Ka numoni en meten meatin keil onen, en out koakeil amal en meten alah ruai. ");
INSERT INTO pma_vpl VALUES ("PS111_2","020_111_2","PSA","111","2","2","Tounah vasi koa Iahova mumoni tahos imok. Ka koakeil vasi asi keil ven tounah keil enek e vati mok avandem usil aneite teni. ");
INSERT INTO pma_vpl VALUES ("PS111_3","020_111_3","PSA","111","3","3","Umen vasi keil onen Ahi mul rie lati keke kei vi hetetamen imok ka mal keke avouhou mini. Sakien keil onen mal revi mok kosa ka lisenges. ");
INSERT INTO pma_vpl VALUES ("PS111_4","020_111_4","PSA","111","4","4","Iahova mul sakin meatin keil en out vasi netan avou lat isen veni along usil mormore sakien keil onen. Along kilea keke tahosien ka enmahisien onen marite. ");
INSERT INTO pma_vpl VALUES ("PS111_5","020_111_5","PSA","111","5","5","Kei mul san anien min koakeil avouhou mini. En rovobongentei hatkatien takeih onen koa mumoni ral min keil. ");
INSERT INTO pma_vpl VALUES ("PS111_6","020_111_6","PSA","111","6","6","Ahi rie lat keihoen ten umen onen min meatin keil onen. Ka alei kilea eni navong san atan osen meatin keil ten kantri sav keil mai vi ose. ");
INSERT INTO pma_vpl VALUES ("PS111_7","020_111_7","PSA","111","7","7","Ka tounah vasi koa Iahova mumoni mal ka musil rendemien koa tahos. Mengkatien vasi keil onen, rokilea rovaling desien orer eni. ");
INSERT INTO pma_vpl VALUES ("PS111_8","020_111_8","PSA","111","8","8","Mengkatien keil onen hel lisenges, asakras avavuol. Kei sani min meatin keil keke avousili ral min anatinien ka maluen. ");
INSERT INTO pma_vpl VALUES ("PS111_9","020_111_9","PSA","111","9","9","Ahi mumon meatin keil onen amaluv. Kei mumon hatkatien takeih tai ral min keil koa sakras vamahoi en avong etai, veni Isen vi votut ka hetetamen imok. ");
INSERT INTO pma_vpl VALUES ("PS111_10","020_111_10","PSA","111","10","10","Houhouen min Ahi vi vatte ten meteisauen. Koakeil amul along kat ren, rendemien one mekaikai revi. Rehesan masmasien heha mini lisenges. ");
INSERT INTO pma_vpl VALUES ("PS112_1","020_112_1","PSA","112","1","1","!Rehehati lat isen Iahova! Koakeil avouhou min Iahova ito en sien. Koakeil e vati avousil revi mengkatien keil onen, keil isi keil en avong vasi. ");
INSERT INTO pma_vpl VALUES ("PS112_2","020_112_2","PSA","112","2","2","Titiali keil one imai ihi avat keil ten kantri one. Tokolkatien onen Ahi hel en koakeil akistal ran vatiamal onen koakeil amal en meten. ");
INSERT INTO pma_vpl VALUES ("PS112_3","020_112_3","PSA","112","3","3","Vatiamal onen ihotin tahosien ka tokolkatien, umen one koa amumoni musil sakien ten maluen hel lisenges. ");
INSERT INTO pma_vpl VALUES ("PS112_4","020_112_4","PSA","112","4","4","Moulien one mul kataun more meatin keil suval laet koa ritin en out koa malikelik. Keil atahos min mesav keil ka arie lat enmahisien min keil, umen keil one mal imok. ");
INSERT INTO pma_vpl VALUES ("PS112_5","020_112_5","PSA","112","5","5","Hetahos min koakeil amumon umen one en sise tai koa mal, ka asa maen tounah one min meatin sav keil ral min rendemien koa tahos. ");
INSERT INTO pma_vpl VALUES ("PS112_6","020_112_6","PSA","112","6","6","Vati meatin keil koa amal imok mukok, avong keil takeih sakras vapurun keil, ka meatin sav keil e rovobongentei sakien tetahos keil one. ");
INSERT INTO pma_vpl VALUES ("PS112_7","020_112_7","PSA","112","7","7","Keil armetautei navong akur longlongien tai koa tisa, veni demkatien one keih ka akilea keke Ahi hehi eikokoe en keil. ");
INSERT INTO pma_vpl VALUES ("PS112_8","020_112_8","PSA","112","8","8","Keil armundemkotei ka armetaun etai tounah, veni akilea keke Ahi hehitan en vativieh keil one. ");
INSERT INTO pma_vpl VALUES ("PS112_9","020_112_9","PSA","112","9","9","En avong vasi keil asan kataunien min koakeil atamurei en tounah, sakien keil one mal lisenges. Keihoen mul en he ka meatin keil avouhou min keil. ");
INSERT INTO pma_vpl VALUES ("PS112_10","020_112_10","PSA","112","10","10","Navong meatin tisa keil ales keil, tine kat keil ka mete vilhili kat keil. Ka lingkatien keil onen koakeil atisa hemai hehi heisav enges ka ivupuol. ");
INSERT INTO pma_vpl VALUES ("PS113_1","020_113_1","PSA","113","1","1","!Mihehati lat isen Iahova! Anatin, kami koa mivi meatin toumien keil onen, mihou lat isen. ");
INSERT INTO pma_vpl VALUES ("PS113_2","020_113_2","PSA","113","2","2","Isen Iahova mariso mok, kosa ka lisenges. ");
INSERT INTO pma_vpl VALUES ("PS113_3","020_113_3","PSA","113","3","3","Kami vasi koa miro en out koa meteiai ka ien va rokol kami koa miro en out koa meteiai munu ien, mihemasmas Iahova. ");
INSERT INTO pma_vpl VALUES ("PS113_4","020_113_4","PSA","113","4","4","Avou lat isen Iahova en out vasi en out netan, ka hetetamenien onen vina nesa mok mulin teilang. ");
INSERT INTO pma_vpl VALUES ("PS113_5","020_113_5","PSA","113","5","5","Tounah tovuol vasuval Iahova, Ahi orer, koa mul rondan en out nesa ka losil kat tounah vasi. ");
INSERT INTO pma_vpl VALUES ("PS113_6","020_113_6","PSA","113","6","6","Kei malingling ka lele mita netan keke vales tounah keil koa amul en teilang ka en out netan. ");
INSERT INTO pma_vpl VALUES ("PS113_7","020_113_7","PSA","113","7","7","Kei mul rali lat koakeil tounah one tovuol keke avamemea ran out tatisa koa amul ien. Ka mul kulat keil ran mahien keil one. ");
INSERT INTO pma_vpl VALUES ("PS113_8","020_113_8","PSA","113","8","8","Iahova mul san houhouen min keil suval avi hetetamen. Mul sakin keil arondan revi ral min mari meatin keil. ");
INSERT INTO pma_vpl VALUES ("PS113_9","020_113_9","PSA","113","9","9","Kei mul sakin koakeil avi lumalum asi keil en teim se keil, veni mul maen keil avahi mama onen titiali keil. !Sakini, mihehati lat isen Iahova! ");
INSERT INTO pma_vpl VALUES ("PS115_1","020_115_1","PSA","115","1","1","Iahova, komai mervinvintei keke mevakur houhouen. Keik enges kovinvin kovakur houhouen, veni, lisenges, komul korie envatien onom min komai ka komumon tounah vasi koa kovat kati. ");
INSERT INTO pma_vpl VALUES ("PS115_2","020_115_2","PSA","115","2","2","Romaltei keke koakeil areingeingen Ahi avoumon tohtohien en komai avahit, “?Ueee … Ahi onami mul kave?” ");
INSERT INTO pma_vpl VALUES ("PS115_3","020_115_3","PSA","115","3","3","Veni Ahi orer mul en out nesa ka kei mul mumon tounah vasi koa kei en vati voumoni. ");
INSERT INTO pma_vpl VALUES ("PS115_4","020_115_4","PSA","115","4","4","Ka ahi onen mesav keil avi nana keil enges koa amumon keil en silva ka gol, koa amumon keil ral min he enges. ");
INSERT INTO pma_vpl VALUES ("PS115_5","020_115_5","PSA","115","5","5","Amusah onge mul en ahi keil one, ka asakras avaselus, mete mul, ka asakras avales etai tounah. ");
INSERT INTO pma_vpl VALUES ("PS115_6","020_115_6","PSA","115","6","6","Ralinge mul, ka asakras avalonglong, vulingase mul, ka asakras avamusmus. ");
INSERT INTO pma_vpl VALUES ("PS115_7","020_115_7","PSA","115","7","7","He mul, ka asakras avatokol etai tounah, ale mul, ka asakras avoual. Ahi keil one aro raeng enges veni moulien tovuol en keil. ");
INSERT INTO pma_vpl VALUES ("PS115_8","020_115_8","PSA","115","8","8","Ahi keil one arkurtei keihoen, ka vatte hetas en koakeil aling desien one mul en keil. Ka koakeil akur anatin en keil imai ihi heisav enges. ");
INSERT INTO pma_vpl VALUES ("PS115_9","020_115_9","PSA","115","9","9","!Ka kami, me-Isrel keil, miheling desien onami en Iahova! Veni kei mul kataun kami ka mul lei kokoe en kami. ");
INSERT INTO pma_vpl VALUES ("PS115_10","020_115_10","PSA","115","10","10","Pris keil onen Ahi, tahos keke miheling demkatien onami en Ahi, veni kei mul kataun kami ka mul lei kokoe en kami. ");
INSERT INTO pma_vpl VALUES ("PS115_11","020_115_11","PSA","115","11","11","Kami vasi koa mivouhou min Iahova, tahos keke kami miheling demkatien onami eni, veni kei mul kataun kami ka mul lei kokoe en kami. ");
INSERT INTO pma_vpl VALUES ("PS115_12","020_115_12","PSA","115","12","12","Iahova mul mundem kat ir ka hetokol kat ir. Anatin, kei hetokol kat me-Isrel keil ka pris keil onen. ");
INSERT INTO pma_vpl VALUES ("PS115_13","020_115_13","PSA","115","13","13","Hetokol kat koakeil vasi avouhou mini, hetetamen keil heha hetokol meatin kuren keil emun. ");
INSERT INTO pma_vpl VALUES ("PS115_14","020_115_14","PSA","115","14","14","Navisi keke Iahova hetokol kat kami hetal min titiali keil onami, heha hetokol titiali keil one. ");
INSERT INTO pma_vpl VALUES ("PS115_15","020_115_15","PSA","115","15","15","Anatin, tokolkatien onen Iahova, koa mumon out nesa ka out netan, hel en moulien onami. ");
INSERT INTO pma_vpl VALUES ("PS115_16","020_115_16","PSA","115","16","16","Out nesa vi onen Iahova, ka out netan, kei lingi mul en hen meatin keil. ");
INSERT INTO pma_vpl VALUES ("PS115_17","020_115_17","PSA","115","17","17","Koakeil amul en out ten matien aro raeng enges, ka asakras avahou lat isen. ");
INSERT INTO pma_vpl VALUES ("PS115_18","020_115_18","PSA","115","18","18","Ka ir koa romoul veah, rehesau masmasi, kosa ka lisenges. !Sakini, rehehati lat isen Iahova! ");
INSERT INTO pma_vpl VALUES ("PS117_1","020_117_1","PSA","117","1","1","Rehehati lat isen Iahova, meatin vasi keil ten out netan. Mihehou lat isen, kami vasi koa mimul en kantri sav keil. ");
INSERT INTO pma_vpl VALUES ("PS117_2","020_117_2","PSA","117","2","2","Envatien onen min ir mariso, ka lisenges, kei mum vasin hatkatien keil onen. !Sakini, rehehati lat isen Iahova! ");
INSERT INTO pma_vpl VALUES ("PS119_1","020_119_1","PSA","119","1","1","Tokolkatien hel en koakeil ualien one mutolas, koa moulien one musil kat mengkatien keil onen Iahova. ");
INSERT INTO pma_vpl VALUES ("PS119_2","020_119_2","PSA","119","2","2","Tokolkatien hel en koakeil amum musil rendemien koa Ahi viteni ka along kati ral min moulien vasi one. ");
INSERT INTO pma_vpl VALUES ("PS119_3","020_119_3","PSA","119","3","3","Armumontei tounah vatisa, ka amusil kat sise koa kei rie keil avousili. ");
INSERT INTO pma_vpl VALUES ("PS119_4","020_119_4","PSA","119","4","4","Iahova, keik kosan hihiseien keil koa kovit malong kati. ");
INSERT INTO pma_vpl VALUES ("PS119_5","020_119_5","PSA","119","5","5","Ek vati mok keke nirkur tuntei sise onom, ka nilong kat rendemien keil koa koling kati mousili. ");
INSERT INTO pma_vpl VALUES ("PS119_6","020_119_6","PSA","119","6","6","Nilekat revi keke nusil kat mengkatien keil onom. Hemukonek, nirmemoutei en meten mesav keil. ");
INSERT INTO pma_vpl VALUES ("PS119_7","020_119_7","PSA","119","7","7","Navong nalei kilea mukave kolei rahit en usite vasi keil musil rendemien koa mal, namasmasuk ral min rendemien koa mutolas. ");
INSERT INTO pma_vpl VALUES ("PS119_8","020_119_8","PSA","119","8","8","Rendemien vasi keil koa koling kati, inau nusili. Sakini, konalokoveintei nau li. ");
INSERT INTO pma_vpl VALUES ("PS119_9","020_119_9","PSA","119","9","9","?Ehon hau ka atouli hau keil ito en moulien tai koa hetolas hemukave? Ilei kokoe eni hetal min selusien keil onom. ");
INSERT INTO pma_vpl VALUES ("PS119_10","020_119_10","PSA","119","10","10","Inau nusiluk en moulien vasi keil onak, konamaentei nau nanaha ran mengkatien keil onom. ");
INSERT INTO pma_vpl VALUES ("PS119_11","020_119_11","PSA","119","11","11","Inau naling suain selusien onom neim en tinok, keke nirmumontei tisaen naha katuk. ");
INSERT INTO pma_vpl VALUES ("PS119_12","020_119_12","PSA","119","12","12","O Iahova, namasmasuk. Kihiseinau en rendemien keil onom koa koling kati. ");
INSERT INTO pma_vpl VALUES ("PS119_13","020_119_13","PSA","119","13","13","Inau namul navit lein tounah koa kolei usili musil rendemien koa mal. ");
INSERT INTO pma_vpl VALUES ("PS119_14","020_119_14","PSA","119","14","14","Nasi nau keke mousil asa koa koviteni suval koa namul nakur tounah keil koa mani teni mariso. ");
INSERT INTO pma_vpl VALUES ("PS119_15","020_119_15","PSA","119","15","15","Hihiseien keil onom mules en rendemien onak keke nindem kilea aneite ten keil, ka nalei kilea en sise koa korie keke komai mevousili. ");
INSERT INTO pma_vpl VALUES ("PS119_16","020_119_16","PSA","119","16","16","Nasi nau ven rendemien keil koa kosani, ka nirmundem maentei selusien keil onom. ");
INSERT INTO pma_vpl VALUES ("PS119_17","020_119_17","PSA","119","17","17","Inau navi meatin toumien onom. Kumoni hetahos minau keke nakilea mamoul ka malong kat selusien keil onom. ");
INSERT INTO pma_vpl VALUES ("PS119_18","020_119_18","PSA","119","18","18","Sehen metok keke malei revi en more tounah keil koa amul en mengkatien keil onom. ");
INSERT INTO pma_vpl VALUES ("PS119_19","020_119_19","PSA","119","19","19","Inau naro en out netan suval heou tai. Sakini, konaling suaintei mengkatien keil onom ranau. ");
INSERT INTO pma_vpl VALUES ("PS119_20","020_119_20","PSA","119","20","20","En avong vasi, ek vati li mok keke nilea revi en tounah vasi koa mal en rendemien onom. ");
INSERT INTO pma_vpl VALUES ("PS119_21","020_119_21","PSA","119","21","21","Keik kovul kat koakeil akur rendemien ten hetetamenien mul en keil. Sesendaen tai mul en koakeil along ras mengkatien keil onom. ");
INSERT INTO pma_vpl VALUES ("PS119_22","020_119_22","PSA","119","22","22","Koakeil enek amundem maen nau ka amumon tohtohien minau. Kiting koe nau ran keil veni inau namusil kat tounah koa koviteni. ");
INSERT INTO pma_vpl VALUES ("PS119_23","020_119_23","PSA","119","23","23","Avaseini keke hetetamen keil alah ruai keke avalekat sise koa akilea avapurun inau vaka ien, inau, meatin toumien onom, nil nindem usil rendemien keil koa koling kati mousili. ");
INSERT INTO pma_vpl VALUES ("PS119_24","020_119_24","PSA","119","24","24","Inau nasi nau houlu mok ven tounah koa koviteni, veni keil amul arie sise minau keke mousili. ");
INSERT INTO pma_vpl VALUES ("PS119_25","020_119_25","PSA","119","25","25","Nalonge tisa houlu ka namundem sesai. Kitali lat nau li hesuval koa kovat kati en selusien onom. ");
INSERT INTO pma_vpl VALUES ("PS119_26","020_119_26","PSA","119","26","26","Navit lein tounah vasi koa namumoni minuk, ka kovit kes selusien onak. Kihiseinau li en rendemien keil onom koa koling kati mousili. ");
INSERT INTO pma_vpl VALUES ("PS119_27","020_119_27","PSA","119","27","27","Kumonau nilea en hihiseien keil onom, ka nindem usil more tounah keil koa komumoni keke nilea aneite teni. ");
INSERT INTO pma_vpl VALUES ("PS119_28","020_119_28","PSA","119","28","28","Nalonge tisa houlu ka tinok mul mis. Kisan ris keihoen minau li hesuval koa kovat kati en selusien onom. ");
INSERT INTO pma_vpl VALUES ("PS119_29","020_119_29","PSA","119","29","29","Kiting koe nau nanahatei en sise koa romaltei. Ka veni kotahos imok, kihiseinau en mengkatien keil onom. ");
INSERT INTO pma_vpl VALUES ("PS119_30","020_119_30","PSA","119","30","30","Inau naling rendemien onak keke nusil sise ten longkatien en moulien onak. Namundem usil hemukave nusil rendemien keil onom koa koling kati mousili. ");
INSERT INTO pma_vpl VALUES ("PS119_31","020_119_31","PSA","119","31","31","O Iahova, inau namusil kat tounah koa koviteni. Sakini, konasakintei nau nanamemoutei en meten mesav keil. ");
INSERT INTO pma_vpl VALUES ("PS119_32","020_119_32","PSA","119","32","32","Navong nalong mengkatien keil onom, nakalah namum musili, veni nakilea keke kisan tei ris ileilien minau heka ien. ");
INSERT INTO pma_vpl VALUES ("PS119_33","020_119_33","PSA","119","33","33","O Iahova, kihiseinau en aneite ten rendemien keil onom koa koling kati mousili, ka nilong kati lisenges. ");
INSERT INTO pma_vpl VALUES ("PS119_34","020_119_34","PSA","119","34","34","San ileilien minau ka nusil kat mengkatien keil onom. Anatin, nilong kati hetal min moulien vasi onak. ");
INSERT INTO pma_vpl VALUES ("PS119_35","020_119_35","PSA","119","35","35","Kilamunau en sise ten mengkatien keil onom, veni en sise enek nihotin sien. ");
INSERT INTO pma_vpl VALUES ("PS119_36","020_119_36","PSA","119","36","36","Kihiles moulien onak keke nusil kat tounah koa koviteni, keke nanousiltei sakien ten metenan. ");
INSERT INTO pma_vpl VALUES ("PS119_37","020_119_37","PSA","119","37","37","Kihiles metok ran tounah keil avi heisav enges, ka kisan moulien minau heka en mengkatien keil onom. ");
INSERT INTO pma_vpl VALUES ("PS119_38","020_119_38","PSA","119","38","38","Kisakin selusien onom hemai hehi anatin en moulien onen meatin toumien onom, veni hesakini hehouhou enuk. ");
INSERT INTO pma_vpl VALUES ("PS119_39","020_119_39","PSA","119","39","39","Inau namul nametaun selkututien keil koa vativieh keil onak amumoni vaha kat inau. Sakini, kutut inau li veni tounah koa kolei usili musil rendemien koa mal. ");
INSERT INTO pma_vpl VALUES ("PS119_40","020_119_40","PSA","119","40","40","Ek vati li mok hihiseien keil onom. Veni keik komal imok, kisakin moulien onak hehi heite hau. ");
INSERT INTO pma_vpl VALUES ("PS119_105","020_119_105","PSA","119","105","105","Selusien keil onom suval laet koa musil luvat out koa namual ien, ka san meneai minau keke malei kilea revi sise onak. ");
INSERT INTO pma_vpl VALUES ("PS119_130","020_119_130","PSA","119","130","130","Navong kovit kilea hihiseien keil onom, namundem kilea asa koa mal. Avaseini meatin tai rosukul revitei, selusien onom mul san meteisauen mini. ");
INSERT INTO pma_vpl VALUES ("PS119_160","020_119_160","PSA","119","160","160","Anatinien vi vatte ten selusien vasi keil onom. Ka tounah vasi koa koviteni musil rendemien koa mal mul lisenges. ");
INSERT INTO pma_vpl VALUES ("PS119_165","020_119_165","PSA","119","165","165","Tomat mul en moulien onen koakeil vasi envatien one mul en mengkatien keil onom, tounah tovuol vasakin keil avamot. ");
INSERT INTO pma_vpl VALUES ("PS119_176","020_119_176","PSA","119","176","176","Inau navi meatin toumien onom ka nakur tun sise koa mal suval sipsip tai koa vuol. Sakini, kimai li kihotin inau, veni ek rovobongentei mengkatien keil onom. ");
INSERT INTO pma_vpl VALUES ("PS121_1","020_121_1","PSA","121","1","1","Nalele vina nesa en vatihou keil ka navit, “?Kataunien hemai minau heka kave?” ");
INSERT INTO pma_vpl VALUES ("PS121_2","020_121_2","PSA","121","2","2","Nakilea keke kataunien hemai minau heka ven Iahova, kei koa mumon out nesa ka out netan. ");
INSERT INTO pma_vpl VALUES ("PS121_3","020_121_3","PSA","121","3","3","Kei hermaen etai tounah vakula kami, mul ring koe kami ka romatiltei. ");
INSERT INTO pma_vpl VALUES ("PS121_4","020_121_4","PSA","121","4","4","Kei koa mul lei kokoe en me-Isrel keil, rolongtei metalong. ");
INSERT INTO pma_vpl VALUES ("PS121_5","020_121_5","PSA","121","5","5","Iahova vi eikokoe onami. Kei heto en usite matu onami keke tounah hetovuol vapurun kami. ");
INSERT INTO pma_vpl VALUES ("PS121_6","020_121_6","PSA","121","6","6","En meneai, meteiai sakras van vini kami, ka en vongien, avati sakras vapurun kami. ");
INSERT INTO pma_vpl VALUES ("PS121_7","020_121_7","PSA","121","7","7","Iahova heting koe moulien onami keke tounah keil tatisa napuruntei kami. Kei heav koe kami hetal hen keke tounah sakras vamai vakula kami. ");
INSERT INTO pma_vpl VALUES ("PS121_8","020_121_8","PSA","121","8","8","En ualien keil onami, kei helei kat revi kami en usite vasi keil, kosa ka lisenges. ");
INSERT INTO pma_vpl VALUES ("PS135_1","020_135_1","PSA","135","1","1","!Mihehati lat isen Iahova! Kami koa mivi meatin toumien keil onen, mihemasmasi. ");
INSERT INTO pma_vpl VALUES ("PS135_2","020_135_2","PSA","135","2","2","Kami koa miva netan mini en Eim Votut onen, vuo mimul en teahu teni, mihehou lat isen. ");
INSERT INTO pma_vpl VALUES ("PS135_3","020_135_3","PSA","135","3","3","Mihehati lat isen Iahova veni kei tahos. Mihesau mini veni enmahisien onen mariso. ");
INSERT INTO pma_vpl VALUES ("PS135_4","020_135_4","PSA","135","4","4","Rokilea keke vi anatin veni Iahova rie lat avu orer Siekob vahi onen, ka rie lat ir, me-Isrel keil, rovahi onen kati. ");
INSERT INTO pma_vpl VALUES ("PS135_5","020_135_5","PSA","135","5","5","Nakilea keke Iahova vi hetetamen imok, Ahi orer marite mok mulin ahi sav keil. ");
INSERT INTO pma_vpl VALUES ("PS135_6","020_135_6","PSA","135","6","6","En out nesa ka en out netan, Iahova mul sakin tounah vasi mai kistal musil envatien onen. En atas ka en huinev teni, tounah keil koa mul kur out musil rendemien onen. ");
INSERT INTO pma_vpl VALUES ("PS135_7","020_135_7","PSA","135","7","7","Kei sakin mahmah keil amuloh umai ran out keil koa soutin en out netan. Kei mumon ahil vil en avong ten an tisa, ka lah lat eang ran out teni ka sakini muhuh. ");
INSERT INTO pma_vpl VALUES ("PS135_8","020_135_8","PSA","135","8","8","En kantri ten out Isip, vi Ahi koa mu vini moeite vasi keil. Anatin, mu vini moeite onen meatin keil ka onen buluk ka sipsip keil emun. ");
INSERT INTO pma_vpl VALUES ("PS135_9","020_135_9","PSA","135","9","9","En out enek, kei mumon merikel keil ka marmari tounah keil. Kei san mahien min asuv houlu ten out Isip, ka min avat keil onen. ");
INSERT INTO pma_vpl VALUES ("PS135_10","020_135_10","PSA","135","10","10","Vi Ahi koa mu vini meatin keil ten kantri houlu, ka mu vini asuv houlu keil koa akur keihoen. ");
INSERT INTO pma_vpl VALUES ("PS135_11","020_135_11","PSA","135","11","11","Kei mu vini Sihon koa vi asuv houlu ten out Amor, ka Og emun koa vi asuv houlu ten out Basan. Ahi vitan en asuv houlu vasi keil koa aro en atan ten out Kenan. ");
INSERT INTO pma_vpl VALUES ("PS135_12","020_135_12","PSA","135","12","12","Atan koa kulati ran he, kei sani suk min meatin keil onen ten out Isrel keke vahi one. ");
INSERT INTO pma_vpl VALUES ("PS135_13","020_135_13","PSA","135","13","13","Meatin keil indem kat isen Iahova lisenges. Tounah vasi keil koa kei mumoni, meatin keil ihitehiten usili en avong vasi keil koa hemai veah. ");
INSERT INTO pma_vpl VALUES ("PS135_14","020_135_14","PSA","135","14","14","Ihitehiten usil Iahova veni vi eikokoe onen meatin keil onen, ka mul rei lat enmahisien onen min meatin toumien keil onen. ");
INSERT INTO pma_vpl VALUES ("PS135_15","020_135_15","PSA","135","15","15","Ahi keil onen meatin keil ten kantri savsav keil avi nana keil enges koa amumon keil en silva ka gol, amumon keil ral min he enges. ");
INSERT INTO pma_vpl VALUES ("PS135_16","020_135_16","PSA","135","16","16","Amusah onge mul en ahi keil one, ka asakras avaselus, mete mul, ka asakras avales etai tounah. ");
INSERT INTO pma_vpl VALUES ("PS135_17","020_135_17","PSA","135","17","17","Ralinge mul, ka asakras avalonglong; onge mul, ka asakras avaseh. ");
INSERT INTO pma_vpl VALUES ("PS135_18","020_135_18","PSA","135","18","18","Ahi keil one avi heisav enges, ka vatte hetas en koakeil aling desien one mul en keil. Ka koakeil akur anatin en keil emun imai ihi heisav enges. ");
INSERT INTO pma_vpl VALUES ("PS135_19","020_135_19","PSA","135","19","19","Mihehati lat isen Iahova, me-Isrel keil, pris keil onen Ahi, mihehou lat isen. ");
INSERT INTO pma_vpl VALUES ("PS135_20","020_135_20","PSA","135","20","20","Mihehati lat isen Iahova, kami koa mimum en Eim Votut onen, kami vasi koa mivouhou mini, mihou lat isen. ");
INSERT INTO pma_vpl VALUES ("PS135_21","020_135_21","PSA","135","21","21","Kami koa miro en Hou Saeon, mihesan masmasien min Iahova, min kei koa ro en out Serusalem. !Sakini, mihehati lat isen Iahova! ");
INSERT INTO pma_vpl VALUES ("PS136_1","020_136_1","PSA","136","1","1","Mihemasmas Iahova veni kei tahos. ");
INSERT INTO pma_vpl VALUES ("PS136_2","020_136_2","PSA","136","2","2","Mihemasmas Ahi koa mulin ahi sav keil. ");
INSERT INTO pma_vpl VALUES ("PS136_3","020_136_3","PSA","136","3","3","Mihemasmas Ahi Asuv koa mulin asuv sav keil. ");
INSERT INTO pma_vpl VALUES ("PS136_4","020_136_4","PSA","136","4","4","Kei sasen enges mumon mari tounah keil. ");
INSERT INTO pma_vpl VALUES ("PS136_5","020_136_5","PSA","136","5","5","Ka en ileilien onen, kei mumon out nesa. ");
INSERT INTO pma_vpl VALUES ("PS136_6","020_136_6","PSA","136","6","6","Kei varei sakin out netan mea ran atas. ");
INSERT INTO pma_vpl VALUES ("PS136_7","020_136_7","PSA","136","7","7","Kei mumon tounah vasi keil koa ritin en teilang. ");
INSERT INTO pma_vpl VALUES ("PS136_8","020_136_8","PSA","136","8","8","Ling meteiai keke valosil kat meneai. ");
INSERT INTO pma_vpl VALUES ("PS136_9","020_136_9","PSA","136","9","9","Ka ling avati ka hitu keil keke avalosil kat vongien. ");
INSERT INTO pma_vpl VALUES ("PS136_10","020_136_10","PSA","136","10","10","Kei varei mu vini moeite keil ten out Isip. ");
INSERT INTO pma_vpl VALUES ("PS136_11","020_136_11","PSA","136","11","11","Evus, lah lat me-Isrel keil ran out Isip. ");
INSERT INTO pma_vpl VALUES ("PS136_12","020_136_12","PSA","136","12","12","Kei mumoni mukonek ral min keihoen koa mul en hen. ");
INSERT INTO pma_vpl VALUES ("PS136_13","020_136_13","PSA","136","13","13","Kei sasen mumon Atas Tahilhili maseh va en usite elu. ");
INSERT INTO pma_vpl VALUES ("PS136_14","020_136_14","PSA","136","14","14","Kei sakin meatin keil onen amual kotehei. ");
INSERT INTO pma_vpl VALUES ("PS136_15","020_136_15","PSA","136","15","15","Ka sakin atas enek rein vini asuv houlu ten out Isip ral min meatin tavaeen vasi keil onen. ");
INSERT INTO pma_vpl VALUES ("PS136_16","020_136_16","PSA","136","16","16","Kei mulamun meatin keil onen aka vas out volvol. ");
INSERT INTO pma_vpl VALUES ("PS136_17","020_136_17","PSA","136","17","17","Asuv houlu keil koa akur keihoen, kei vitan en keil vasi. ");
INSERT INTO pma_vpl VALUES ("PS136_18","020_136_18","PSA","136","18","18","Mu vinvini asuv houlu keil koa avi hetetamen. ");
INSERT INTO pma_vpl VALUES ("PS136_19","020_136_19","PSA","136","19","19","Anatin, mu vini asuv houlu Sihon ten out Amor. ");
INSERT INTO pma_vpl VALUES ("PS136_20","020_136_20","PSA","136","20","20","Ka mumoni vatte tas min asuv houlu Og emun ten out Basan. ");
INSERT INTO pma_vpl VALUES ("PS136_21","020_136_21","PSA","136","21","21","Evus, san atan ose min meatin keil onen vahi ose esuk. ");
INSERT INTO pma_vpl VALUES ("PS136_22","020_136_22","PSA","136","22","22","Kei sani min me-Isrel keil koa avi meatin toumien keil onen. ");
INSERT INTO pma_vpl VALUES ("PS136_23","020_136_23","PSA","136","23","23","Kei mundem kat ir navong romul en hen mesav keil. ");
INSERT INTO pma_vpl VALUES ("PS136_24","020_136_24","PSA","136","24","24","Mumon ir romaluv ran hen vativieh keil orer. ");
INSERT INTO pma_vpl VALUES ("PS136_25","020_136_25","PSA","136","25","25","Ka mul vengan tounah vasi keil koa amoul en out netan. ");
INSERT INTO pma_vpl VALUES ("PS136_26","020_136_26","PSA","136","26","26","Mihemasmas Ahi ten out nesa. ");
INSERT INTO pma_vpl VALUES ("PS138_1","020_138_1","PSA","138","1","1","Asuv houlu Deved mutisi O Iahova, navati latuk ral min moulien vasi onak. Ka en meten ahi sav keil, nisan masmasien hehat minuk. ");
INSERT INTO pma_vpl VALUES ("PS138_2","020_138_2","PSA","138","2","2","Inau nitetengeiril ka nilele hemal en Eim Votut onom. Nihou lat Isom veni korie lat envatien onom min meatin keil onom ka komum vasin hatkatien keil onom. Anatin, nihati latuk veni korie lati keke Isom ka selusien onom luvi hetetamen imok lumulin tounah sav vasi keil. ");
INSERT INTO pma_vpl VALUES ("PS138_3","020_138_3","PSA","138","3","3","Mal en avong koa naviso vat minuk, keik kolong hisoen onak ka kosan kataunien minau. Kokulat metauen ranau ka kosan keihoen minau. ");
INSERT INTO pma_vpl VALUES ("PS138_4","020_138_4","PSA","138","4","4","O Iahova, asuv houlu vasi keil ten out netan ihati latuk veni along selusien keil onom. ");
INSERT INTO pma_vpl VALUES ("PS138_5","020_138_5","PSA","138","5","5","Keil isau usil more sakien keil onom, veni keihoen onom, Iahova, marite mok. ");
INSERT INTO pma_vpl VALUES ("PS138_6","020_138_6","PSA","138","6","6","Avaseini keik, Iahova, koro en out nesa, komul komalingling vita ka kolele tahos en koakeil rendemien one mul netan. Ka min koakeil amul avut sase en keil, kokilea vasin sakien keil one ka koro soutin ran keil. ");
INSERT INTO pma_vpl VALUES ("PS138_7","020_138_7","PSA","138","7","7","Avaseini nales tounah keil takeih amul akarahit inau, nakilea keik komul koring koe inau. Avaseini vativieh keil onak atisa kat inau, keik komumoni keih va kat keil ka komutut inau ran he. ");
INSERT INTO pma_vpl VALUES ("PS138_8","020_138_8","PSA","138","8","8","Tounah keil koa koling kati keke vakur out en moulien onak, komum vasi. O Iahova, konalokoveintei tounah keil koa komul komumoni en moulien onak. Kumoni veni envatien onom mul lisenges. ");
INSERT INTO pma_vpl VALUES ("PS139_1","020_139_1","PSA","139","1","1","Asuv houlu Deved mutisi O Iahova, keik kolei kirisil en asa koa mul en tinok ka kokilea revi inau. ");
INSERT INTO pma_vpl VALUES ("PS139_2","020_139_2","PSA","139","2","2","Kokilea inau navong narondan ka navong namea. Kokilea vasin rendemien keil onak, avaseini koro soutin. ");
INSERT INTO pma_vpl VALUES ("PS139_3","020_139_3","PSA","139","3","3","Kokilea inau navong namual ka navong namuseh. Kokilea revi sakien keil onak. ");
INSERT INTO pma_vpl VALUES ("PS139_4","020_139_4","PSA","139","4","4","Navong narselustei veah, keik, Iahova, kokilea selusien vasi keil onak tuai. ");
INSERT INTO pma_vpl VALUES ("PS139_5","020_139_5","PSA","139","5","5","Keik kovi vieh koa mul en usite vasi keil onak, ka ral min keihoen onom, koring koe moulien onak. ");
INSERT INTO pma_vpl VALUES ("PS139_6","020_139_6","PSA","139","6","6","Navong namundem usil tounah keil koa komumoni en usite onak, ileilien enek mariso ramat, ka nasakras mailea vasi. ");
INSERT INTO pma_vpl VALUES ("PS139_7","020_139_7","PSA","139","7","7","?Munak nihit malohosai ran Ninin onom, nakilea maha en out kave? ?Out kave niha ien koa keik kormultei ien? Out tovuol. ");
INSERT INTO pma_vpl VALUES ("PS139_8","020_139_8","PSA","139","8","8","Munak nimat ka niha en out nesa, keik komul ien tuai. Ka munak niha en out ten matien en huinev ten atan, en out enek emun, inau nilesuk. ");
INSERT INTO pma_vpl VALUES ("PS139_9","020_139_9","PSA","139","9","9","Munak nakilea maka vaha vio … matokol out koa meteiai kistal ien, vuo maha en out koa va munu ien, ");
INSERT INTO pma_vpl VALUES ("PS139_10","020_139_10","PSA","139","10","10","en out keilu enek emun, komul mulamu enau ka komul katau enau. Veni komul ien tuai keke kovakataun inau vatal min keihoen koa mul en hem. ");
INSERT INTO pma_vpl VALUES ("PS139_11","020_139_11","PSA","139","11","11","Munak namundemi navit mankoli kilea vaav koe inau, vuo nakilea mahiles meneai vamai vahi vongien, nasakras mato suai ranuk. ");
INSERT INTO pma_vpl VALUES ("PS139_12","020_139_12","PSA","139","12","12","Nasakras, veni vongien rovitei mankoli enuk. Anatin, en metom, vongien rovopolitei, ka mankoli suval meneai enges. ");
INSERT INTO pma_vpl VALUES ("PS139_13","020_139_13","PSA","139","13","13","Vi keik, Ahi, koa komum vasin avek. Navong namul semau en vangen mama onak, keik komumon inau. ");
INSERT INTO pma_vpl VALUES ("PS139_14","020_139_14","PSA","139","14","14","Navong namundem usil sise koa keik komum revi inau ka ien, namutimanin ka navati lat isom. Nakilea revi keke tounah vasi keil koa komumoni tahos vis tahos imok. ");
INSERT INTO pma_vpl VALUES ("PS139_15","020_139_15","PSA","139","15","15","Navong naro suai en vangen mama onak, nasakras mato suai ranuk. Veni navong sik keil amul semau asisur en keil, keik kolei kilea enau tuai. ");
INSERT INTO pma_vpl VALUES ("PS139_16","020_139_16","PSA","139","16","16","Navong avek rovus revitei veah, komul koles inau tuai. Avong keil vasi koa koling kati venau, keik komutis lat keil tuai mul en tus onom mulamu en avong koa avasi inau eni. ");
INSERT INTO pma_vpl VALUES ("PS139_17","020_139_17","PSA","139","17","17","O Iahova, rendemien keil onom amariso vareis ka nasakras mandem kilea keil vasi. !Keil avi houlu vis avi houlu mok! ");
INSERT INTO pma_vpl VALUES ("PS139_18","020_139_18","PSA","139","18","18","Vahit masak visi mahuli keil, hulien teni vahi houlu mok valin veien vasi keil ten out netan. Munak namatil ka namule eris, nalesi keke namul veah ral minuk. ");
INSERT INTO pma_vpl VALUES ("PS139_19","020_139_19","PSA","139","19","19","O Ahi, ek vati mok keke ku vini koakeil amum kalkali lises, ka kisakin meatin keil koa e vati avouas inau mamat, iha ranau. ");
INSERT INTO pma_vpl VALUES ("PS139_20","020_139_20","PSA","139","20","20","Meatin keil ekek amul aselus kutut usiluk, ka aselus karen isom. ");
INSERT INTO pma_vpl VALUES ("PS139_21","020_139_21","PSA","139","21","21","O Iahova, tinok tisa va kat koakeil tine tisa katuk, koakeil asesein losilkatien onom, atisaso enges en metok. ");
INSERT INTO pma_vpl VALUES ("PS139_22","020_139_22","PSA","139","22","22","Tinok vepeng va kat keil ka avi vativieh ral minau. ");
INSERT INTO pma_vpl VALUES ("PS139_23","020_139_23","PSA","139","23","23","O Ahi, kilei kirisil en moulien onak, kisak vis inau ka kilea rendemien keil onak. ");
INSERT INTO pma_vpl VALUES ("PS139_24","020_139_24","PSA","139","24","24","Munak kovotini keke namul namusil sise ten tisaen, kilamun inau en more sise onom koa mul lisenges. ");
INSERT INTO pma_vpl VALUES ("PS145_1","020_145_1","PSA","145","1","1","Asuv houlu Deved mutisi Keik kovi Ahi onak ka asuv houlu ten moulien onak. Navouhou minuk ka navati lat isom lisenges. ");
INSERT INTO pma_vpl VALUES ("PS145_2","020_145_2","PSA","145","2","2","En avong vasi, namasmasuk, ka navou lat isom lises ka lisenges. ");
INSERT INTO pma_vpl VALUES ("PS145_3","020_145_3","PSA","145","3","3","Iahova, keik kovi hetetamen imok, ka mal enges keke masan masmasien vahat minuk. Keik komariso mok ka meatin keil asakras availea vasin keihoen onom. ");
INSERT INTO pma_vpl VALUES ("PS145_4","020_145_4","PSA","145","4","4","Asa koa komumoni ven meatin keil, keil ihitehiteni min titae keil. Anatin, keil iselus usil sakien keil onom koa amariso mok. ");
INSERT INTO pma_vpl VALUES ("PS145_5","020_145_5","PSA","145","5","5","Keil iselus usil muohien ten hetetamenien onom ka sakien keil onom koa amormoreite, ka inau nindem usil more umen keil onom. ");
INSERT INTO pma_vpl VALUES ("PS145_6","020_145_6","PSA","145","6","6","Keil iselus usil mari umen keil onom koa arie lat keihoen onom, ka nihit lat sakien keil onom koa avi hetetamen imok. ");
INSERT INTO pma_vpl VALUES ("PS145_7","020_145_7","PSA","145","7","7","Tahosien onom koa marite houmon keil isi keil ka ihit usili min mesav keil, ka isau usil maluen onom hetal min sien. ");
INSERT INTO pma_vpl VALUES ("PS145_8","020_145_8","PSA","145","8","8","Iahova, envatien onom mariso ka komul korie lat enmahisien min meatin keil. Keik korvurohtei vakalah, ka kovilelau en envatien. ");
INSERT INTO pma_vpl VALUES ("PS145_9","020_145_9","PSA","145","9","9","Iahova, komumoni tahos min meatin vasi keil, ka korie lat enmahisien min koakeil komumon keil. ");
INSERT INTO pma_vpl VALUES ("PS145_10","020_145_10","PSA","145","10","10","O Iahova, tounah vasi keil koa komumoni isan masmasien hehat minuk. Ka koakeil amusiluk, keil ihati lat isom. ");
INSERT INTO pma_vpl VALUES ("PS145_11","020_145_11","PSA","145","11","11","Keil iselus usil losilkatien onom koa mariso mok, ka ihit usil keihoen onom. ");
INSERT INTO pma_vpl VALUES ("PS145_12","020_145_12","PSA","145","12","12","Keil umoni hemukonek keke meatin vasi keil ilea sakien keil koa mul rie lat keihoen onom. Anatin, keil ilea suk keke losilkatien onom mariso mok. ");
INSERT INTO pma_vpl VALUES ("PS145_13","020_145_13","PSA","145","13","13","Losilkatien onom hel lisenges, ka kihi asuv houlu onen meatin keil heha vio … hervustei. Iahova, keik komum vasin hatkatien keil onom, ka korie lat envatien onom ka en sakien keil onom. ");
INSERT INTO pma_vpl VALUES ("PS145_14","020_145_14","PSA","145","14","14","Iahova, keik komul kokataun koakeil avotini keih en moulien one, ka korali lat koakeil keihoen one tovuol emun. ");
INSERT INTO pma_vpl VALUES ("PS145_15","020_145_15","PSA","145","15","15","Meten meatin keil amul alele vat venuk keke kovalosil kat keil. Ka komul kosan anien min keil en avong koa mal. ");
INSERT INTO pma_vpl VALUES ("PS145_16","020_145_16","PSA","145","16","16","Tounah vasi koa amoul en out netan, amul akur asa koa e vati ka en hem. ");
INSERT INTO pma_vpl VALUES ("PS145_17","020_145_17","PSA","145","17","17","Iahova, sakien keil onom mal revi, ka umen keil onom rie lat enmahisien onom. ");
INSERT INTO pma_vpl VALUES ("PS145_18","020_145_18","PSA","145","18","18","Keik komul vesesal ven koakeil avis minuk. Anatin, koro vesesal ven koakeil avis minuk ka en tine. ");
INSERT INTO pma_vpl VALUES ("PS145_19","020_145_19","PSA","145","19","19","Koakeil avouhou minuk, komul kosan asa koa e vati. Keik komul kolong hisoen one ka kumai komutut moulien one. ");
INSERT INTO pma_vpl VALUES ("PS145_20","020_145_20","PSA","145","20","20","Iahova, keik kolei kat revi koakeil e vatuk, ka min koakeil amum tisa, ku lin keil. ");
INSERT INTO pma_vpl VALUES ("PS145_21","020_145_21","PSA","145","21","21","Iahova, nimasmasuk lisenges. Ka tounah vasi keil ten out netan ihati lat isom lises ka lisenges. ");
INSERT INTO pma_vpl VALUES ("PS146_1","020_146_1","PSA","146","1","1","!Rehehati lat isen Iahova! !Inau nihou lat isen! ");
INSERT INTO pma_vpl VALUES ("PS146_2","020_146_2","PSA","146","2","2","Nisan masmasien mini en avong vasi koa namul veah namoul. Anatin, nihati lati hetal min souen keil onak. ");
INSERT INTO pma_vpl VALUES ("PS146_3","020_146_3","PSA","146","3","3","Minalingtei desien onami en avat keil ten out netan, veni meatin keil enges asakras avoutut moulien onami. ");
INSERT INTO pma_vpl VALUES ("PS146_4","020_146_4","PSA","146","4","4","Navong keil umat, ave va ris vi atan, ka tounah keil koa aling kati keke avoumoni mai rokol keite teni. ");
INSERT INTO pma_vpl VALUES ("PS146_5","020_146_5","PSA","146","5","5","Ka sien mul en koakeil Ahi onen Siekob mul kataun keil, mul en koakeil aling desien one en Iahova, Ahi one. ");
INSERT INTO pma_vpl VALUES ("PS146_6","020_146_6","PSA","146","6","6","Veni kei varei mumon out nesa, out netan, atas, ka tounah vasi keil emun koa amul en keitel. Kei mul mum vasin hatkatien keil onen. ");
INSERT INTO pma_vpl VALUES ("PS146_7","020_146_7","PSA","146","7","7","Kei varei mul sakin asa koa mal mai kistal en moulien onen koakeil mesav keil amul apurun keil. Kei mul san anien min koakeil amai kat keil. Iahova mul maen koakeil amul en hen mesav keil uva amaluv. ");
INSERT INTO pma_vpl VALUES ("PS146_8","020_146_8","PSA","146","8","8","Koakeil mete var, mumon keil alele ris. Iahova mul rali lat koakeil umot uva netan, ka en vat koakeil sakien keil one mal. ");
INSERT INTO pma_vpl VALUES ("PS146_9","020_146_9","PSA","146","9","9","Iahova vi eikokoe onen heou keil, ka mul kataun vatina ka timaru keil. Ka koakeil akalkali, kei mul purun keil. ");
INSERT INTO pma_vpl VALUES ("PS146_10","020_146_10","PSA","146","10","10","Kami koa miro en Hou Saeon, Iahova helosil kat kami lisenges. Anatin, helosil kat revi kami hetal min vatiamal keil onami koa imai ikatau en kami. !Sakini, rehehati lat isen Iahova! ");
INSERT INTO pma_vpl VALUES ("PS148_1","020_148_1","PSA","148","1","1","!Rehehati lat isen Iahova! !Kami koa miro en out nesa mihehati lat isen Iahova! ");
INSERT INTO pma_vpl VALUES ("PS148_2","020_148_2","PSA","148","2","2","Anatin, kami angelo keil, mihehati lati, kami koa mimul mivae en usite onen, mihehou lat isen. ");
INSERT INTO pma_vpl VALUES ("PS148_3","020_148_3","PSA","148","3","3","Meteiai ka avati, milhehati lati. Hitu keil, mihehou lat isen. ");
INSERT INTO pma_vpl VALUES ("PS148_4","020_148_4","PSA","148","4","4","Tounah keil koa mimul en teilang, mihesakin isen hehina nesa. Mahmah keil, mihetie lat hetetamenien onen. ");
INSERT INTO pma_vpl VALUES ("PS148_5","020_148_5","PSA","148","5","5","Kami vasi, mihehati lat isen Iahova, veni mumon kami vasi ral min ren. ");
INSERT INTO pma_vpl VALUES ("PS148_6","020_148_6","PSA","148","6","6","Anatin, navong kei meng kati, kami miva miro kat en out kati onami, ka misakras mivali hakot keil koa Ahi sani min kami. ");
INSERT INTO pma_vpl VALUES ("PS148_7","020_148_7","PSA","148","7","7","Kami vasi koa miro en out netan, ral min tounah vasi keil koa amoul en huinev ten atas, mihehati lat isen Iahova. ");
INSERT INTO pma_vpl VALUES ("PS148_8","020_148_8","PSA","148","8","8","Ahil koa vil ka voulul koa musel, ous koa mus ka eang koa muhuh keih, kami vasi koa mimul milong kat ren, mihehati lat isen Iahova. ");
INSERT INTO pma_vpl VALUES ("PS148_9","020_148_9","PSA","148","9","9","Hou keil ka vatihou keil, mihehati lat isen Ahi, hetal min vatiai keil koa amul en out teim ka koakeil emun amul en eivorohus. ");
INSERT INTO pma_vpl VALUES ("PS148_10","020_148_10","PSA","148","10","10","Buluk ka sipsip keil koa amah ka tirendan keil emun ten eivorohus, mihehou lat isen, hetal min tounah sav keil koa amul akekelau ka amuka. ");
INSERT INTO pma_vpl VALUES ("PS148_11","020_148_11","PSA","148","11","11","Asuv houlu keil ka meatin savsav keil, mihehouhou min Ahi, hetal min avat keil ka hetetamen sav keil emun ten out netan. ");
INSERT INTO pma_vpl VALUES ("PS148_12","020_148_12","PSA","148","12","12","Meatin hau ka ahin hau keil, mihehati lat isen, hetal min ulmatu ka tovuli keil, ka titi ehon ka atouli keil emun. ");
INSERT INTO pma_vpl VALUES ("PS148_13","020_148_13","PSA","148","13","13","Tounah vasi keil mihehou lat isen Iahova veni isen enges marite mok mulin eis savsav vasi keil. Anatin, isen vi hetetamen imok en out netan ka en out nesa emun. ");
INSERT INTO pma_vpl VALUES ("PS148_14","020_148_14","PSA","148","14","14","Ahi mul san keihoen min meatin keil onen keke akilea avahati lat isen. Kei mul lei kat revi me-Isrel keil veni envatien onen mul en keil. !Sakini, rehehati lat isen Iahova! ");
INSERT INTO pma_vpl VALUES ("PS149_1","020_149_1","PSA","149","1","1","!Rehehati lat isen Iahova! Rehesau min Iahova hetal min souen hau tai. Rehehou lati navong rolah ruai ral min meatin sav keil koa amul amusil kati. ");
INSERT INTO pma_vpl VALUES ("PS149_2","020_149_2","PSA","149","2","2","Me-Isrel keil, mihesi kami ven Ahi koa mumon kami. Mihelonge hetahos, meatin keil koa mimul en Hou Saeon, ven Iahova koa vi asuv houlu onami. ");
INSERT INTO pma_vpl VALUES ("PS149_3","020_149_3","PSA","149","3","3","Mihehati lat isen hetal min holien keil, mihemasmasi hetal min ave ka kitar. ");
INSERT INTO pma_vpl VALUES ("PS149_4","020_149_4","PSA","149","4","4","Mihehati lati veni Iahova si kei ven meatin keil onen ka mul san houhouen min koakeil rendemien one mul netan. Kei mul sakin keil avitan en vativieh keil one. ");
INSERT INTO pma_vpl VALUES ("PS149_5","020_149_5","PSA","149","5","5","Koakeil amusil kat Ahi isi keil navong amulin koakeil amul uvae ral min keil, ka isau hetal min sien navong amuseh. ");
INSERT INTO pma_vpl VALUES ("PS149_6","020_149_6","PSA","149","6","6","Keil ihiso hetal min masmasien ven Ahi one, navong avuli kat naef tahuen keil one. ");
INSERT INTO pma_vpl VALUES ("PS149_7","020_149_7","PSA","149","7","7","Hetal min naef onen meatin keil onen, Ahi helei rahit usite onen meatin savsav keil ten out netan ka hesan mahien min keil. ");
INSERT INTO pma_vpl VALUES ("PS149_8","020_149_8","PSA","149","8","8","Ahi hemaen keil ipar kat alen asuv houlu keil ka avat keil onen vativieh keil one hetal min sen keil takeih. ");
INSERT INTO pma_vpl VALUES ("PS149_9","020_149_9","PSA","149","9","9","Anatin, Ahi hesan mahien min meatin keil ekek hesuval koa vat kati keke voumoni min koakeil amum tisa en meten. Ka hekatau suk eni, Ahi hesan hetetamenien min koakeil amusil kati. !Sakini, rehehati lat isen Iahova! ");
INSERT INTO pma_vpl VALUES ("PS150_1","020_150_1","PSA","150","1","1","!Rehehati lat isen Iahova! Rehehati lat isen Ahi en out nesa, rehou lati en out votut onen. ");
INSERT INTO pma_vpl VALUES ("PS150_2","020_150_2","PSA","150","2","2","Rehehati lati ven tounah keil koa marite koa mul mumoni. Rehehou lati veni isen hetetamen imok. ");
INSERT INTO pma_vpl VALUES ("PS150_3","020_150_3","PSA","150","3","3","Rehehati lati hetal min amaru keil, ka rehehou lati hetal min kitar ka seka keil emun. ");
INSERT INTO pma_vpl VALUES ("PS150_4","020_150_4","PSA","150","4","4","Rehehati lati ka rehetarum en holien mini, ka rehehou lati hetal min iukalele ka ave emun. ");
INSERT INTO pma_vpl VALUES ("PS150_5","020_150_5","PSA","150","5","5","Rehehati lati hetal bonggo ka rehehou lati hetal min okan koa romuhi en onger. ");
INSERT INTO pma_vpl VALUES ("PS150_6","020_150_6","PSA","150","6","6","Kami vasi koa mimoul mihehou lat isen Iahova. !Ir vasi, rehehati lat isen Iahova! ");
INSERT INTO pma_vpl VALUES ("PR3_1","021_3_1","PRO","3","1","1","Natkuli, em navobongentei asa koa naviseinuk eni. Lisenges, kindem kat mengkatien keil onak ka kusil kati. ");
INSERT INTO pma_vpl VALUES ("PR3_2","021_3_2","PRO","3","2","2","Hihiseien onak houmon moulien onom hetaveah ka kiles tahosien. ");
INSERT INTO pma_vpl VALUES ("PR3_3","021_3_3","PRO","3","3","3","En moulien onom, avaseini asa hemai, kitie lat sakien ten more envatien onom en meatin sav keil ka lises kumoni hetahos min keil. Konalokoveintei sise keilu ekek, hetahos keke kitis kati hel en tinom. ");
INSERT INTO pma_vpl VALUES ("PR3_4","021_3_4","PRO","3","4","4","Munak kumon koanek, Ahi ka meatin sav keil isi keil venuk ka isom hetahos. ");
INSERT INTO pma_vpl VALUES ("PR3_5","021_3_5","PRO","3","5","5","Hetal min moulien vasi onom, kiling desien onom en Iahova. Konandesintei ileilien onom enges. ");
INSERT INTO pma_vpl VALUES ("PR3_6","021_3_6","PRO","3","6","6","Kindem kat Iahova en tounah vasi koa komumoni, ka kei hetie sise koa mal minuk. ");
INSERT INTO pma_vpl VALUES ("PR3_7","021_3_7","PRO","3","7","7","Konandem sasom enuktei konahit ileilien onom mulin ileilien onen meatin sav keil. Kihouhou min Iahova ka konahatei vesesal en tisaen. ");
INSERT INTO pma_vpl VALUES ("PR3_8","021_3_8","PRO","3","8","8","Munak kumon koanek, hesak revi avem ka en tinom, kilonge hetahos. ");
INSERT INTO pma_vpl VALUES ("PR3_9","021_3_9","PRO","3","9","9","Kihouhou min Iahova hetal min tounah vasi onom, ka kisan tei anien hau koa moul en ah osom heha mini. ");
INSERT INTO pma_vpl VALUES ("PR3_10","021_3_10","PRO","3","10","10","Munak kumon koanek, kiles tahosien koa hemariso en moulien onom, vah onom hehilelau en anien lises ka kirtamureitei en etai tounah. ");
INSERT INTO pma_vpl VALUES ("PR3_11","021_3_11","PRO","3","11","11","Natkuli, navong Iahova ralimal enuk ven tounah, kisik enges veni ka kindem kati. ");
INSERT INTO pma_vpl VALUES ("PR3_12","021_3_12","PRO","3","12","12","Kumon koanek veni Iahova ralimal en koakeil envatien onen mul en keil. Kei mumoni suval tata tai koa ralimal en natnali koa si veni. ");
INSERT INTO pma_vpl VALUES ("PR3_27","021_3_27","PRO","3","27","27","Hetahos minuk keke konahuli kattei ui umen onen koakeil amum navong mul en hem keke kovasani min keil. ");
INSERT INTO pma_vpl VALUES ("PR3_28","021_3_28","PRO","3","28","28","Munak meatin tai visuk en tounah tai koa kovuli kati mul, tahos keke kisan vareini mini. Konahitentei konahit, “Vuo, visuvong esuk nisani minuk.” ");
INSERT INTO pma_vpl VALUES ("PR3_29","021_3_29","PRO","3","29","29","Konoumontei sise vapurun meatin tai koa ro vesesal venuk veni ro ral minuk ka ling desien onen mul enuk. ");
INSERT INTO pma_vpl VALUES ("PR3_30","021_3_30","PRO","3","30","30","Konasel kutut kattei meatin sav koa romumon etai tounah vapurunuk. ");
INSERT INTO pma_vpl VALUES ("PR3_31","021_3_31","PRO","3","31","31","Konahati lattei meatin tatituen, ka konousiltei sakien keil onen, ");
INSERT INTO pma_vpl VALUES ("PR3_32","021_3_32","PRO","3","32","32","veni Iahova vuroh kat vati meatin koa mukonek, ka koakeil moulien one mal, kei lah keil umai vesesal veni. ");
INSERT INTO pma_vpl VALUES ("PR3_33","021_3_33","PRO","3","33","33","Iahova hesan sesendaen heha kat teim sen meatin keil koa amum tisa. Ka hesan tokolkatien heha en teim sen meatin keil koa amum mal. ");
INSERT INTO pma_vpl VALUES ("PR3_34","021_3_34","PRO","3","34","34","Kei mundem heisav en vati meatin keil koa avut keil ka amundem heisav en meatin sav keil. Ka mul lele tahos min koakeil amumon rendemien one va netan. ");
INSERT INTO pma_vpl VALUES ("PR3_35","021_3_35","PRO","3","35","35","Meatin keil koa avi meteisau, ise hetahos. Ka koakeil avi varu, keil apurun ise. ");
INSERT INTO pma_vpl VALUES ("PR5_15","021_5_15","PRO","5","15","15","Keik koa koretalihe, kitie lat envatien onom min ahin onom ka kito hetal min kei enges. ");
INSERT INTO pma_vpl VALUES ("PR5_16","021_5_16","PRO","5","16","16","?Mukave? ?Tahos keke kiha kiles ahin sav keil? ?Mal keke kiha kisan asa koa vi onen ahin kati onom min teisav keil? !Vuo! ");
INSERT INTO pma_vpl VALUES ("PR5_17","021_5_17","PRO","5","17","17","Tahosien ten tetaliheien onamil enges. Rovitei tounah koa kokilea kovasan heisav eni min mesav keil. ");
INSERT INTO pma_vpl VALUES ("PR5_18","021_5_18","PRO","5","18","18","Hetahos imok kisik ven ahin koa koretalihe ral mini mai vi asom navong kovi meatin hau veah, ka kitos en sien hetal mini lisenges. ");
INSERT INTO pma_vpl VALUES ("PR5_19","021_5_19","PRO","5","19","19","Kimaen kei sasen hesakinuk kilonge hetahos lises. Kihi vau en aven ahin onom enges ka kisik ven envatien onen. ");
INSERT INTO pma_vpl VALUES ("PR5_20","021_5_20","PRO","5","20","20","?Natkuli, vensa kitie lat envatien onom en ahin koa vi hoeaso tai? ?Vensa kiles aven ka kindemi keke kei tahos imok mulin ahin kati onom? !Konomontei vamukonek! ");
INSERT INTO pma_vpl VALUES ("PR8_22","021_8_22","PRO","8","22","22","En avong mulamu, Ahi mumonau, isok vi Meteisauen. Kei mumonau mulamu en tounah savsav keil vasi koa mumoni. ");
INSERT INTO pma_vpl VALUES ("PR8_23","021_8_23","PRO","8","23","23","En avong koa mum rohtoh en tounah keil, inau namulamu en keil. Navong out netan tovuol veah, inau namul tuai. ");
INSERT INTO pma_vpl VALUES ("PR8_24","021_8_24","PRO","8","24","24","Navong atas ka oaisal keil atovuol veah, inau naros. ");
INSERT INTO pma_vpl VALUES ("PR8_25","021_8_25","PRO","8","25","25","Ahi mumonau mulamu en vatihou keil ka mulamu en avong kei ling kat hou keil en out kati one. ");
INSERT INTO pma_vpl VALUES ("PR8_26","021_8_26","PRO","8","26","26","Mulamu en avong koa Ahi mumon out netan ka tounah keil koa amoul ien, navong atan tovuol veah, namul tuai. ");
INSERT INTO pma_vpl VALUES ("PR8_27","021_8_27","PRO","8","27","27","Inau namul en usiven Ahi navong kei ling teilang en out kati onen, ka navong ling hakot teni mai rokol atas. ");
INSERT INTO pma_vpl VALUES ("PR8_28","021_8_28","PRO","8","28","28","Inau nalesi navong kei ling mahmah en teilang, ka sakin oaisal keil amue uva en atas. ");
INSERT INTO pma_vpl VALUES ("PR8_29","021_8_29","PRO","8","29","29","Nalonge navong Ahi viten out koa atas hevus eni, ka navong ling hakot ten atan. ");
INSERT INTO pma_vpl VALUES ("PR8_30","021_8_30","PRO","8","30","30","Inau namum vesesal ven Ahi suval avat toumien onen. Lises, kei si venau, ka inau, nasi nau mun mato vatal mini. ");
INSERT INTO pma_vpl VALUES ("PR8_31","021_8_31","PRO","8","31","31","Nalonge tahos ven out netan koa kei mumoni, ka nasi nau ven meatin keil koa aro ien. ");
INSERT INTO pma_vpl VALUES ("PR9_7","021_9_7","PRO","9","7","7","Munak kovit kovatalimal en vatkeih tai, kei heselus karenuk, ka munak kosel kat meatin tisa tai, kei hepurunuk. ");
INSERT INTO pma_vpl VALUES ("PR9_8","021_9_8","PRO","9","8","8","Sakini, konasak vistei kovatalimal en meatin koa vuti, veni kei hevuroh katuk veni. Ka munak kitalimal en meatin koa vi meteisau, envatien onen hel enuk. ");
INSERT INTO pma_vpl VALUES ("PR9_9","021_9_9","PRO","9","9","9","Munak kosel kat meatin koa vi meteisau, kei hehi meteisau revi mok. Ka munak kosan hihiseien min meatin koa mal, ileilien onen hemariso tamun. ");
INSERT INTO pma_vpl VALUES ("PR9_10","021_9_10","PRO","9","10","10","Houhouen min Iahova vi vatte ten meteisauen. Munak kokilea kei koa vi votut, kokilea en tounah tai koa vi hetetamen imok. ");
INSERT INTO pma_vpl VALUES ("PR13_1","021_13_1","PRO","13","1","1","Titiali keil koa avi meteisau amul along kat tata ka mama one keil navong asel kat keil. Ka vatkeih keil, asakras avalong kat. ");
INSERT INTO pma_vpl VALUES ("PR13_4","021_13_4","PRO","13","4","4","Avaseini taripeng tai en vati mok vakur etai tounah, kei sakras vakuri. Ka meatin koa mum keih, kei helah vasi tounah koa en vati. ");
INSERT INTO pma_vpl VALUES ("PR14_23","021_14_23","PRO","14","23","23","Munak kum, kihotin ui umen onom. Ka munak koselus enges ka kormumtei, kirkur etai tounah. ");
INSERT INTO pma_vpl VALUES ("PR14_24","021_14_24","PRO","14","24","24","Tahosien vi ui umen onen meatin koa vi meteisau, ka varuen vi ui umen onen meatin koa vi varu. ");
INSERT INTO pma_vpl VALUES ("PR15_1","021_15_1","PRO","15","1","1","Navong kosa kes selusien en sakien ten merauen, koanek hesakin vurohien heha netan. Ka selusien takeih hesakin tin meatin sav heatiat. ");
INSERT INTO pma_vpl VALUES ("PR15_2","021_15_2","PRO","15","2","2","Navong meatin koa vi meteisau selus, meatin sav keil asi keil avakur ileilien rani, ka varu keil ason kalah en selusien koa vi varu enges. ");
INSERT INTO pma_vpl VALUES ("PR15_18","021_15_18","PRO","15","18","18","Meatin koa tin tamurei mumon selkututien houlu, ka kei koa merau mumon tin meatin va netan. ");
INSERT INTO pma_vpl VALUES ("PR15_22","021_15_22","PRO","15","22","22","Lingkatien keil onom hemai hetisa munak kirvistei meteisauen ran meatin sav keil, ka munak kihis meteisauen, keik kiles heite teni koa hetahos. ");
INSERT INTO pma_vpl VALUES ("PR18_22","021_18_22","PRO","18","22","22","Munak kovotin ahin tai vahi asom, kovotin tounah tai koa tahos, ka kiles tahosien onen Iahova hel en moulien onom. ");
INSERT INTO pma_vpl VALUES ("PR19_1","021_19_1","PRO","19","1","1","Tahos imok munak sakien keil onom mal ka tounah onom rovitei houlu mulin koa kovi varu tai koa komul koluvos. ");
INSERT INTO pma_vpl VALUES ("PR20_1","021_20_1","PRO","20","1","1","Sakien ten munmunien mumon tituen ka verien, ka koakeil enges avi varu amaen oai takeih valeh keil avaha en sise keil tatisa. ");
INSERT INTO pma_vpl VALUES ("PR20_4","021_20_4","PRO","20","4","4","Taripeng tai koa en rovattei voum en ah osen en avong kati taluhluhien, kei hervotin etai anien en avong tasuhutien. ");
INSERT INTO pma_vpl VALUES ("PR22_6","021_22_6","PRO","22","6","6","Navong kovisein titiali keil onom en sise koa mal keke avousili, keil indem kati en moulien one ka irlokoveintei sise koanek navong imai imatu. ");
INSERT INTO pma_vpl VALUES ("PR23_13","021_23_13","PRO","23","13","13","Konametautei kovatalimal en titam keil. ?Komundemi keke imat munak komulelas keil? Vuo, romukteinek. ");
INSERT INTO pma_vpl VALUES ("PR23_14","021_23_14","PRO","23","14","14","Ka munak komulelas keil, komutut keil keke irvatei en Ahang. ");
INSERT INTO pma_vpl VALUES ("PR23_29","021_23_29","PRO","23","29","29","?Isei vit, ‘Aue li’? ?Isei longe tisa? ?Isei mul mutit? ?Isei mul musel? ?Isei aven mutetep ka reingeingen asa koa kula? ?Isei meten vilhili tisa? ");
INSERT INTO pma_vpl VALUES ("PR23_30","021_23_30","PRO","23","30","30","Koakeil amunmun houlu amukonek. Anatin, koakeil enges amun oai takeih alonge mukonek. ");
INSERT INTO pma_vpl VALUES ("PR23_31","021_23_31","PRO","23","31","31","Konamaentei uaen koa vilhili tahos valeh lat rendemien onom, avaseini kolesi tahos imok en veite teni ka sakin ongom kas eni. ");
INSERT INTO pma_vpl VALUES ("PR23_32","021_23_32","PRO","23","32","32","Ka en keite teni kilong mahien eni hesuval navong ahai ten atas sin rilik ka kolong mahien teni. ");
INSERT INTO pma_vpl VALUES ("PR23_33","021_23_33","PRO","23","33","33","Metom heles tounah keil vilehiles hemai heteisav, ka rendemien onom hermum revitei. ");
INSERT INTO pma_vpl VALUES ("PR23_34","021_23_34","PRO","23","34","34","Kilonge kihit kovatetavel suval komul en sip tai, kilonge hesuval koa komurur en mas teni ka kuvinuk kova en usite evus kova en usite sav. ");
INSERT INTO pma_vpl VALUES ("PR23_35","021_23_35","PRO","23","35","35","Evus, kihiteni kihit, “Amutinau ka narlongtei. Amuas nau ka narkileatei. ?Vensa nasakras mamea? Tahos imok munak mamun etai mun oai takeih.” ");
INSERT INTO pma_vpl VALUES ("PR24_30","021_24_30","PRO","24","30","30","Inau, namual en sise vesesal en ah osen taripeng tai, ka naka vasi neiai osen varu tai. ");
INSERT INTO pma_vpl VALUES ("PR24_31","021_24_31","PRO","24","31","31","Nalesi keke oumunai tatisa keil amusar koe ka viau tatisa keil apar vini. Nalesi keke vieh teni mahoiahoi mules mukonek. ");
INSERT INTO pma_vpl VALUES ("PR24_32","021_24_32","PRO","24","32","32","Munak nalesi mukonek, namundem usili, ka koanek viseinau en tounah tai. ");
INSERT INTO pma_vpl VALUES ("PR24_33","021_24_33","PRO","24","33","33","Munak em vati kovamatil lisenges, tahosis, kiles kimatil. Kiha kihotin more out koa mandil ka kiseh revi ien. ");
INSERT INTO pma_vpl VALUES ("PR24_34","021_24_34","PRO","24","34","34","Ka navong komul komatil veah, tounah vasi keil onom hevupuol ranuk hesuval tarhena tai mai venani ranuk. Anatin, kitimanin kimai kihi heite hon. ");
INSERT INTO pma_vpl VALUES ("PR29_15","021_29_15","PRO","29","15","15","Navong komulelas titiali tai onom keke kovatalimal eni, komul kosan meteisauen mini, ka munak kolei maenis mumon vatin, titiali enek houmon mama onen hememou. ");
INSERT INTO pma_vpl VALUES ("PR29_17","021_29_17","PRO","29","17","17","Munak koralimal en titiali onom, lises houmonuk kiles tomat ka kirmundemkotei. Kei hesakinuk kivutuk veni. ");
INSERT INTO pma_vpl VALUES ("PR31_10","021_31_10","PRO","31","10","10","Keih ramat keke kovahotin ahin tai koa marir en umen onen ka sakien keil onen tahos. Kei tahos imok mulin tounah koa kokilea kovakuri ral mani onom. ");
INSERT INTO pma_vpl VALUES ("PR31_11","021_31_11","PRO","31","11","11","Meatin onen kilea valing desien onen eni. Ven umen onen ahin onen, kei hertamureitei en etai tounah. ");
INSERT INTO pma_vpl VALUES ("PR31_12","021_31_12","PRO","31","12","12","Navong luro vituai en teim onealu, ahin onen mum tahos mini ka ropuruntei. ");
INSERT INTO pma_vpl VALUES ("PR31_13","021_31_13","PRO","31","13","13","Hen vasi keilu lurmusehtei, kei vei suvon keil ka rili revi eisin keil. ");
INSERT INTO pma_vpl VALUES ("PR31_17","021_31_17","PRO","31","17","17","Kei vi ahin toumien tai, ka hen keilu lumum keih lises. ");
INSERT INTO pma_vpl VALUES ("PR31_20","021_31_20","PRO","31","20","20","Kei mul kataun koakeil tounah one tovuol, ka san tounah min koakeil atetamurei en tounah. ");
INSERT INTO pma_vpl VALUES ("PR31_26","021_31_26","PRO","31","26","26","Ahin koa tahos mul selus ral min meteisau ka hihiseien tahos keil akistal ran ongon. ");
INSERT INTO pma_vpl VALUES ("PR31_27","021_31_27","PRO","31","27","27","Kei kilea en tounah koa kur out en teim sen, ka sakien ten taripeng tovuol ien. ");
INSERT INTO pma_vpl VALUES ("PR31_28","021_31_28","PRO","31","28","28","Titiali keil onen amasmasi, ka meatin onen emun vati lat isen. ");
INSERT INTO pma_vpl VALUES ("PR31_29","021_31_29","PRO","31","29","29","Meatin onen mul viteni mini vit, “Ahin sav keil amum tahos, ka keik, komum tahos mulin keil.” ");
INSERT INTO pma_vpl VALUES ("PR31_30","021_31_30","PRO","31","30","30","Ahin koa vi hungevai kilea valuvos meatin, ka more nan hevuol avong tai. Ka ahin koa mul vouhou revi min Iahova, kei ihati lat isen. ");
INSERT INTO pma_vpl VALUES ("PR31_31","021_31_31","PRO","31","31","31","Tahos keke meatin onen hesan ris ui umen min ahin onen, ka hehati lat isen en meten meatin sav keil ven umen tetahos onen. ");
INSERT INTO pma_vpl VALUES ("EC1_1","022_1_1","ECC","1","1","1","Selusien keil ekek avi selusien onen Solomon, Meatin Tahihiseien, koa vi natin asuv houlu Deved ka asuv houlu onen me-Isrel keil koa ro en taon ten out Serusalem. ");
INSERT INTO pma_vpl VALUES ("EC1_2","022_1_2","ECC","1","2","2","Meatin Tahihiseien viteni vit, “Umen vasi keil orer vi heisav vis vi heisav enges. Anatin, tounah vasi koa romul romumoni en moulien orer hemai hehi heisav enges.” ");
INSERT INTO pma_vpl VALUES ("EC1_3","022_1_3","ECC","1","3","3","En avong vasi en moulien onom kolehkao en umen onom en out netan ekek. ?Ka kovotin asa en keite teni? Matien enges. ");
INSERT INTO pma_vpl VALUES ("EC1_4","022_1_4","ECC","1","4","4","Vangi meatin tai, avas keil en out netan, amoul ka umat, ka vangi meatin sav umai akes vulie. Ka out netan lises mul vatte tas, tounah tovuol mul viles. ");
INSERT INTO pma_vpl VALUES ("EC1_5","022_1_5","ECC","1","5","5","En avong vasi, meteiai mea ka muloh va vio … vita munu. Evus, kalah eris vina en vulin keke hemea ris. ");
INSERT INTO pma_vpl VALUES ("EC1_6","022_1_6","ECC","1","6","6","Eang emun, toio mai ka va, ka lengav emun mai ka va, keilu lukarali heisav va vio … luva ris en vulealu. ");
INSERT INTO pma_vpl VALUES ("EC1_7","022_1_7","ECC","1","7","7","Oai keil amue uva en atas, ka atas sakras vahilelau. Oai mul mea mai vi ous. Evus, ous enek mus vita netan ka mue eris vita en atas. ");
INSERT INTO pma_vpl VALUES ("EC1_8","022_1_8","ECC","1","8","8","Tounah vasi rovilestei, mul vatte tas. Avek mah en sakien keil enek, ka nasakras emun mahiten etai tounah usili. Meter lele va vio … ka en vati vales tei ris tounah emau. Ralinger longlong va vio … ka en vati valonglong tei ris emau. ");
INSERT INTO pma_vpl VALUES ("EC1_9","022_1_9","ECC","1","9","9","Tounah vasi koa mai rohtoh, hemai ris hekistal. Ka tounah koa meatin tai mumoni tuai, meatin sav hemai houmoni hesuvali. En out vasi netan, tounah tovuol vahi heite hau. ");
INSERT INTO pma_vpl VALUES ("EC1_10","022_1_10","ECC","1","10","10","?Mukave? Tounah etai koa meatin kilea vahiteni vahit, “Lesi mau, koanek vi tounah hau tai.” Vuo, kistal tuai mulamu en avong koa arvasitei mau ir. ");
INSERT INTO pma_vpl VALUES ("EC1_11","022_1_11","ECC","1","11","11","Meatin keil ten kosa armundem usiltei asa koa kur out mulamu. Ka koakeil imai ikatau en ir, irmundem usiltei asa koa kur out kosa. Ka sakien enek heha vio … keite teni hetovuol. ");
INSERT INTO pma_vpl VALUES ("EC3_1","022_3_1","ECC","3","1","1","Tounah vasi koa kur out en out netan, Ahi ling kat avong keil teni. ");
INSERT INTO pma_vpl VALUES ("EC3_2","022_3_2","ECC","3","2","2","Ahi ling avong tahasuen ka avong ten matien, avong taluhluhien ka avong tasuhutien. ");
INSERT INTO pma_vpl VALUES ("EC3_3","022_3_3","ECC","3","3","3","Kei ling avong tou vini meatin ien ka avong takulat mesaien ien, avong tou rasilin tounah ien ka avong avoumon tounah ien. ");
INSERT INTO pma_vpl VALUES ("EC3_4","022_3_4","ECC","3","4","4","Ahi ling avong touaien ka avong tasien, avong tatangien ka avong taholien. ");
INSERT INTO pma_vpl VALUES ("EC3_5","022_3_5","ECC","3","5","5","Kei ling avong koa meatin vason ahat keil ien ka avong koa valah ruain keil eni, avong tavuavien ka avong talokoveinien. ");
INSERT INTO pma_vpl VALUES ("EC3_6","022_3_6","ECC","3","6","6","Ahi ling avong tahotin tounah ien ka avong koa vavuol ien, avong tahulikatien ka avong koa avasoni vaha. ");
INSERT INTO pma_vpl VALUES ("EC3_7","022_3_7","ECC","3","7","7","Kei ling avong tatal eisin keil ien ka avong tatitilien, avong tatoraengien ka avong taselusien. ");
INSERT INTO pma_vpl VALUES ("EC3_8","022_3_8","ECC","3","8","8","Ahi ling avong tatin katien ka avong ten envatien, avong tavaeen ka avong ten tomat. ");
INSERT INTO pma_vpl VALUES ("EC3_11","022_3_11","ECC","3","11","11","Ahi mumon tounah vasi kur out en avong kati teni. Ka tounah sav emun koa Ahi lingi mul en meatin keil vi ileilien keke amundem usil asa koa kur out tuai ka asa koa hemai veah hekistal. Ka avaseini, keil asakras availea vasi asa koa Ahi mum rohtoh eni va rokol keite teni. ");
INSERT INTO pma_vpl VALUES ("EC3_12","022_3_12","ECC","3","12","12","Sakini namundem kilea keke tahos imok rehesi ir ka reheles tahosien en avong koa romul veah romoul. ");
INSERT INTO pma_vpl VALUES ("EC3_13","022_3_13","ECC","3","13","13","Tahos keke ir vasi reheanian, rehemun hati oai, ka rehesi ir ven tounah keil koa romum veni, veni tounah keil enek avi sanien keil koa Ahi mul sani min ir. ");
INSERT INTO pma_vpl VALUES ("EC3_14","022_3_14","ECC","3","14","14","Nakilea keke tounah vasi koa Ahi mumoni hel lisenges. Ir rosakras rovasosor en etai ris tounah eni, ka rosakras rovakulat etai tounah rani. Ahi mumoni mukonek keke meatin keil ihouhou mini ka iha netan mini. ");
INSERT INTO pma_vpl VALUES ("EC3_15","022_3_15","ECC","3","15","15","Tounah vasi koa amul kosa, amul tuai mulamu; ka asa koa hemai hekatau, kei mul tuai kosa. Ka tounah keil koa kur out mulamu, Ahi helehei hemai hekistal eris. ");
INSERT INTO pma_vpl VALUES ("EC3_16","022_3_16","ECC","3","16","16","Ka navong namul en out netan, nales tounah tamun: en out koa alei revi usite onen meatin keil, inau nales sakkalkalien eni. Anatin, en out ten maluen, tisaen emun mul ien. ");
INSERT INTO pma_vpl VALUES ("EC3_17","022_3_17","ECC","3","17","17","Evus, naselus sasok minau navit, “Ahi hesan asa koa mal min meatin vasi keil, koakeil atahos ka koakeil atisa, veni kei ling kat avong kati ten umen vasi keil ka sakien vasi keil akistal ien.” ");
INSERT INTO pma_vpl VALUES ("EC4_9","022_4_9","ECC","4","9","9","Meatin elu tahos imok mulin meatin tas, veni keilu lukilea luvakakataun keilu en umen onealu valoh. ");
INSERT INTO pma_vpl VALUES ("EC4_10","022_4_10","ECC","4","10","10","Munak tai en keilu mot, tunali kilea vakatauni ka vatali lati vamea. Ka munak meatin tai ro sasen ka mot, koanek tisa, veni meatin tovuol vakatauni. ");
INSERT INTO pma_vpl VALUES ("EC4_11","022_4_11","ECC","4","11","11","Munak out mandil, meatin elu lukilea luvahatin keilu navong lumatil out tas. ?Ka munak meatin tas matil sasen, aven hetin hemukave? ");
INSERT INTO pma_vpl VALUES ("EC4_12","022_4_12","ECC","4","12","12","Munak avkeih tai hemai, kilea vouas meatin koa ro sasen. Ka munak meatin elu lumual vituai, keilu lukilea luvou lat avkeih enek. Munak kopar kat tounah en viau tas, kilea vamaat. Ka munak kovitein viau etel, koanek keih avatali kotehei. ");
INSERT INTO pma_vpl VALUES ("EC5_10","022_5_10","ECC","5","10","10","Munak envatien onom mul en mani houlu, lises kihotini keke mani onom hervinvintei. Ka munak em vati kovalah tounah houlu vahi onom, kilesi keke kosakras kovakur tounah vasi koa em vati. Sakien koanek emun hemai hehi heisav enges. ");
INSERT INTO pma_vpl VALUES ("EC5_11","022_5_11","ECC","5","11","11","Veni navong kokur tounah houlu, koakeil akanian en hem emun umai avi houlu. ?Tounah keil onom hekataunuk hemukave? !Tounah keil enek vi talesien enges! ");
INSERT INTO pma_vpl VALUES ("EC5_12","022_5_12","ECC","5","12","12","Meatin keil koa amum en he, avaseini akanian revi vuo arkanian revitei, keil amatil revi en vongien. Ka koakeil tounah one houlu, armatil revitei veni amundemko houlu ven tounah keil one. ");
INSERT INTO pma_vpl VALUES ("EC5_13","022_5_13","ECC","5","13","13","Koanek vi tounah tamun koa nalesi romaltei en out netan: Meatin keil apurun moulien one enges keke avalah ruain tounah keil one vamai vahi houlu. ");
INSERT INTO pma_vpl VALUES ("EC5_14","022_5_14","ECC","5","14","14","Evus, amutimanin, ka tounah tai kur out koa sakin mani keil one avupuol ran keil. Ka katau, tounah tovuol emun avasani vakataun titiali keil one. ");
INSERT INTO pma_vpl VALUES ("EC5_15","022_5_15","ECC","5","15","15","Navong akur rohtoh en titiali tai, kei kistal hon enges. Ka en sakien enek varei, navong hemat, kei heha ris hehi heite hon. Sakini, avetin onen vi heisav enges. ");
INSERT INTO pma_vpl VALUES ("EC11_9","022_11_9","ECC","11","9","9","Litetai keil, mihesi kami en avong keil koa mivi litetai veah. Anatin, kami mihelonge hetahos en avong keil koa mimoul. Hetahos imok mihoumon asa koa rendemien onami mul ien ka mihousil sise keil koa milesi tahos. Ka mihendem kati keke Ahi helei revi tounah koa mihoumoni ka hesan asa koa mal minuk veni. ");
INSERT INTO pma_vpl VALUES ("EC11_10","022_11_10","ECC","11","10","10","Minamaentei demkoen napurun rendemien onami vuo mahien keil ten avemi nating koe kami, veni rendemien onami ka avemi koa keih veah vi ten avong havivis. ");
INSERT INTO pma_vpl VALUES ("EC12_1","022_12_1","ECC","12","1","1","Navong mivi litetai keil veah, hetahos imok keke mihendem usil kei koa mumon kami. Anatin, mihendem usil kei veni avong keil ten mahien mul mai en sua keil koa hemai veah. En avong enek varei, kami mihersitei mun kami. ");
INSERT INTO pma_vpl VALUES ("EC12_2","022_12_2","ECC","12","2","2","Navong moulien onami vesesal vavus, hesuval meteiai, avati ka hitu keil umai avopoli, ka mahmah keil ten ous sakras valokovein kami. ");
INSERT INTO pma_vpl VALUES ("EC12_3","022_12_3","ECC","12","3","3","Hemi keil koa avi eikokoe en kami, imaleilei. Alomi koa mal kosa, keil ilumpusi. Lohomi koa mikat vahas anien ami eni, houlu hemerahrah ka irmumtei mun hetahos. Ka metomi koa miles tounah vasi eni, imai keke irlei revitei mun tounah. ");
INSERT INTO pma_vpl VALUES ("EC12_4","022_12_4","ECC","12","4","4","Ralingomi hehonhon en tounah koa mul kur out. Miherlongtei mun souen keil vuo anien koa amul avilei. Hisoen onen aman keil, miherlong revitei mun, ka en menauilan, keil isisil enuk ka ipurun matilien onom. ");
INSERT INTO pma_vpl VALUES ("EC12_5","022_12_5","ECC","12","5","5","Mihemetau keke mivoual vuo mivaha en out tai koa vina nesa. Hilumi hoh ka hekeih keke mivamea ran vulumi netan veni keihoen onami hetovuol emun. Hevus, hekatau en tounah keil ekek, miheha suk en out tasehien ekor onami, ka itang ven kami en sise keil ten meteimal. ");
INSERT INTO pma_vpl VALUES ("EC12_7","022_12_7","ECC","12","7","7","Hevus, teiai onami heha ris en atan, ka ninin onami hehina ris ven Ahi koa sani min kami. ");
INSERT INTO pma_vpl VALUES ("EC12_9","022_12_9","ECC","12","9","9","Meatin Tahihiseien enek vi meteisau varei. Ka tounah tamun koa mumoni, kei san ileilien min meatin keil. Kei lei kat selusien keil ten meteisauen, mundem usil aneite keil teni, ka ling revi keil en tus tai. ");
INSERT INTO pma_vpl VALUES ("EC12_10","022_12_10","ECC","12","10","10","Kei sak visi vahotin selusien koa mal, evus, mutis keil keke anatinien teni vamai en mesai. ");
INSERT INTO pma_vpl VALUES ("EC12_11","022_12_11","ECC","12","11","11","Selusien keil ten meteisauen enek asuval ai keil koa meatin talosilkat sipsip ien mul ring koe sipsip osen keil eni keke avoual vamal. Anatin, asuval nil keil koa amuti kat tounah eni keke voumoni vakeih revi. ");
INSERT INTO pma_vpl VALUES ("EC12_12","022_12_12","ECC","12","12","12","Natkuli, kusil revi selusien keil onak veni tus keil houlu mok koa meatin keil amul amutisi lisenges. Ka munak kosak kovahuli vis keil vasi keke kovakur ileilien eni, avem hemah ka hehi ten heisav enges. ");
INSERT INTO pma_vpl VALUES ("EC12_13","022_12_13","ECC","12","13","13","Inau naselus en tounah vasi keil minuk, ka keite teni keiek: kihouhou min Ahi ka kusil kat mengkatien keil onen, veni koanek vi vati rendemien koa Ahi mumonuk veni. ");
INSERT INTO pma_vpl VALUES ("EC12_14","022_12_14","ECC","12","14","14","Ka Ahi helei revi en tounah vasi koa romumoni en moulien orer, koa romumoni en mesaiuai ka koa romum suai eni, tounah koa tahos ka tounah koa tisa mun. Anatin, Ahi hesan asa koa hemal min ir ven tounah vasi koa romumoni. ");
INSERT INTO pma_vpl VALUES ("IS6_1","024_6_1","ISA","6","1","1","En sua koa asuv houlu Usaea ten out Sudah mat, inau, Aesea, nales Iahova mul rondan en vulin ten keihoen koa mul vina nesa. Kot koa musin eni tetaveah, ka ngolite vita netan sien out neim en Eim Votut onen. ");
INSERT INTO pma_vpl VALUES ("IS6_2","024_6_2","ISA","6","2","2","En out koa Iahova mul ien, vati angelo keil koa avise en ‘sereb’ amuka nesa eni ka ave mul vihil houlu. Retai en keil, apoue ahetai (6). En apoue elu, akav koe nae eni; ka en elu mun, akav koe ale tanetan eni; ka en elu mun, amuka eni. ");
INSERT INTO pma_vpl VALUES ("IS6_3","024_6_3","ISA","6","3","3","Ka navong amuka, avisohiso va min keil eris avit, “!Votut, votut, votut! !Iahova, Asuv Houlu ten out nesa, vi votut! Keihoen onen mariso ka sien out netan.” ");
INSERT INTO pma_vpl VALUES ("IS6_4","024_6_4","ISA","6","4","4","Hisoen keil one keih ka sakin eim enek kulul, ka neim en Eim Votut vilelau en eas. ");
INSERT INTO pma_vpl VALUES ("IS6_5","024_6_5","ISA","6","5","5","Navong nalesi, nametau houlu ka naviteni navit, “!Aue li, mamat ke! Selusien vasi keil koa akistal ran ongok romutotei, ka naro luhu en meatin keil koa selusien one mun romutotei en meten Ahi. Anatin eli, navilehilu ka nales Iahova, Asuv Houlu ten out nesa, en metok kati.” ");
INSERT INTO pma_vpl VALUES ("IS6_6","024_6_6","ISA","6","6","6","Evus, sereb tai va en ahor koa amunit senta ien, kaeat kat ahat tai koa mukan vilhili rani, ka kuri mai venau. ");
INSERT INTO pma_vpl VALUES ("IS6_7","024_6_7","ISA","6","7","7","Navong mai, rokol ongok en ahat koa mukan vilhili ka viteni vit, “?Kolesi? Navong narokol ongom en ahat koa mukan vilhili ekek, Ahi sak motein moulien onom ran tisaen keil onom ka sakinuk kirmemoutei mun veni.” ");
INSERT INTO pma_vpl VALUES ("IS6_8","024_6_8","ISA","6","8","8","Evus, naraengon Iahova selus vit, “?Nisila sei? ?Isei hehi provet onomai?” Sakini naviteni navit, “!Inau ke! !Sila nau!” ");
INSERT INTO pma_vpl VALUES ("IS6_9","024_6_9","ISA","6","9","9","Sakini, kei viteni minau vit, “Kiha kihiteni min meatin keil ekek kihit, ‘Avaseini mihetaeng heha vis … kami miherlong kilea etai tounah. Avaseini mihelele heha vis … miherlei kilea etai tounah.’ ");
INSERT INTO pma_vpl VALUES ("IS6_10","024_6_10","ISA","6","10","10","Selusien onom hesakin vatin meatin keil ekek hemai hekeih imok, houmon ralinge hehon ka mete hevar. Veni munak ilei revi en tounah koa numoni en mete, vuo ilong kilea eni en ralinge, keil indem revi ka ihiles ran tisaen keil one ka nimai nikulat mesaien ran moulien one.” ");
INSERT INTO pma_vpl VALUES ("IS7_10","024_7_10","ISA","7","10","10","En avong tai, provet Aesea va les asuv houlu Ehas ka vit mesein selusien onen Iahova mini vit, ");
INSERT INTO pma_vpl VALUES ("IS7_11","024_7_11","ISA","7","11","11","“Munak em vati kovakur anatin en selusien onen Iahova koa vi Ahi onom, kihisi hetie lat tounah tai minuk. Avaseini munak kovisi keke hemai hekistal ran out ten matien en huinev ten atan, vuo ran out nesa, vuo ran out sav koa mul luhu en keilu.” ");
INSERT INTO pma_vpl VALUES ("IS7_12","024_7_12","ISA","7","12","12","Ka asuv houlu Ehas viteni mini vit, “Vuo, inau nirvis etai tounah rani, veni ek rovattei masak vis Iahova.” ");
INSERT INTO pma_vpl VALUES ("IS7_13","024_7_13","ISA","7","13","13","Sakini, provet Aesea viteni mini vit, “!Keik ka kami koa mikistal ran vatiamal onen asuv houlu Deved, mihetaeng revi! Veni vatumi keih, lisenges mimumon provet keil onen Iahova ave mah en selusien. ?Ka mukave? ?Emi vati mivoumon Iahova mun aven vamah en kami? ");
INSERT INTO pma_vpl VALUES ("IS7_14","024_7_14","ISA","7","14","14","Ekek, Iahova keinges hetie lat tounah hehi metai tai minuk keke kilesi. Atouli hau tai hemeas en titiali ka navong hekuri hehi ehon tai, ka heling isen ‘Imanuel’ koa aneite teni vi, ‘Ahi ro ral min ir.’” ");
INSERT INTO pma_vpl VALUES ("IS9_6","024_9_6","ISA","9","6","6","“Anatin, tivava tai, ihasi ven ir. Ehon koanek, Ahi hesani min ir. Losilkatien vasi keil hel en hen. Ihise en ‘More Meatin Tatie Sise en,’ ‘Ahi ten Keihoen,’ ‘Ahi Tamer koa mul lisenges,’ ka ‘Hetetamen ten Tomat.’ ");
INSERT INTO pma_vpl VALUES ("IS9_7","024_9_7","ISA","9","7","7","Losilkatien onen hemai hekeih imok. Anatin, en hen, meatin keil vasi ito en tomat lisenges. Losilkatien onen hesuval losilkatien onen asuv houlu Deved mulamu. Kei hetondan en vulin ten keihoen onen ka helei revi usite onen meatin keil ka houmoni hemal en keil. Ka losilkatien onen hel lisenges hetokol keite ten out netan. Iahova, asuv houlu ten out nesa, en vati mok voumon koanek veni envatien onen min ir marite mok.” ");
INSERT INTO pma_vpl VALUES ("IS11_1","024_11_1","ISA","11","1","1","Iahova selus ka en provet Aesea vit, “Kosa, losilkatien koa ka en vatiamal onen asuv houlu Deved mai rokol keite teni suval vatiai tai koa ara lati. Ka avaseini, asuv houlu hau tai hekistal rani, hesuval silite mul vitehiteh ran vatte. ");
INSERT INTO pma_vpl VALUES ("IS11_2","024_11_2","ISA","11","2","2","Ninin Votut onen Iahova hesieni ka hesan meteisauen ka ileilien mini. Hekatauni vailea en sise koa mal ka hesan keihoen mini keke voum eni. Ninin Votut koanek hesakini heilea revi Iahova ka hehouhou mini. ");
INSERT INTO pma_vpl VALUES ("IS11_3","024_11_3","ISA","11","3","3","Asuv houlu enek hesi kei mok vahouhou min Ahi ka helong kati. En avong ten kot, kei houmoni hemal en meatin keil. Hermusiltei asas koa kei lesi mal en meten, vuo asas koa longe en ralingen. ");
INSERT INTO pma_vpl VALUES ("IS11_4","024_11_4","ISA","11","4","4","Vuo. Navong heles usite onen meatin keil en out netan, houmoni housil sakien ten maluen enges. Anatin, houmoni hemal en koakeil tounah one tovuol ka hekataun koakeil arkeihtei. Ral min selusien onen, helei rahit en usite onen meatin vasi keil ten out netan. Anatin, hetal min selusien takeih onen, heta koteh moulien onen koakeil amum kalkali. ");
INSERT INTO pma_vpl VALUES ("IS11_5","024_11_5","ISA","11","5","5","Vatte ten losilkatien onen hehi maluen ka anatinien. ");
INSERT INTO pma_vpl VALUES ("IS11_6","024_11_6","ISA","11","6","6","En hen, tounah vasi keil koa amoul en out netan ito en tomat. Huli rendan keil ito out hetas en tomat hetal min titi sipsip keil. Taegar keil emun imatil out hetas hetal min nani keil koa avi havivi. Ka laeon keil ito hetal min titan buluk keil koa ave musising ka irkantei keil, ka keil imah revi keke titiali keil enges akilea avalamun keil. ");
INSERT INTO pma_vpl VALUES ("IS11_7","024_11_7","ISA","11","7","7","Buluk keil ianian ruai hetal min bear keil, ka titae keil imatil ruai en tomat. Ka laeon keil ian oumunai hesuval buluk keil. ");
INSERT INTO pma_vpl VALUES ("IS11_8","024_11_8","ISA","11","8","8","Titiali keil koa akea veah ilea ipilei vesesal en out koa tetal tisa keil amul ien. Anatin, keil itokol tetal keil, ka tounah sakras vamai vapurun keil. ");
INSERT INTO pma_vpl VALUES ("IS11_9","024_11_9","ISA","11","9","9","En out vasi keil koa mul rahit Hou Saeon koa vi vatihou votut onen Ahi, tounah tovuol hel ien koa kilea vapurun etai meatin vuo voum vatisa. Ka ileilien usil Iahova hemai hesien revi out netan, hesuval atas mul sien revi vulin. ");
INSERT INTO pma_vpl VALUES ("IS11_10","024_11_10","ISA","11","10","10","Avong hemai keke asuv houlu hau tai koa hekistal en vatiamal onen Deved hemai helomal. Meatin keil vasi ten out netan koa amul soutin iha ilesi ka usili. Anatin, keil imai veni en out kati onen koa hehi moreite vis hehi moreite mok.” ");
INSERT INTO pma_vpl VALUES ("IS40_1","024_40_1","ISA","40","1","1","Ahi viteni min Aesea vit, “Kiha ven meatin keil onak, ka kihati lat rendemien keil one. ");
INSERT INTO pma_vpl VALUES ("IS40_2","024_40_2","ISA","40","2","2","Kiha kiselus min meatin keil onak ten out Serusalem hetal min envatien, ka kihitehiteni min keil keke sua keil one ten mahien vus tuai. Anatin, kihiteni min keil keke mahien koa nasani min keil vinvin tuai ven tisaen keil one.” ");
INSERT INTO pma_vpl VALUES ("IS40_3","024_40_3","ISA","40","3","3","Evus, keil itaengon rea tai hehiso hekeih hehit, “En out volvol, mihesak revi sise onen Iahova. Anatin, en out mes, mihoum motein sise onen Ahi orer. ");
INSERT INTO pma_vpl VALUES ("IS40_4","024_40_4","ISA","40","4","4","Mihetahin revi poal vasi keil, ka vatihou keil vasi, miheil lati hehi aet. Out keil koa vurvuru, mihoumoni hehi aet revi, ka mihetahin vasi vulvul keil. ");
INSERT INTO pma_vpl VALUES ("IS40_5","024_40_5","ISA","40","5","5","Hevus, Iahova hetie lat muohien ten keihoen onen ka meatin keil vasi ilesi en avong hetas. Tounah vasi keil enek hekistal hehi anatin veni Iahova varei vat kati.” ");
INSERT INTO pma_vpl VALUES ("IS40_10","024_40_10","ISA","40","10","10","?Milesi? Iahova ten Keihoen varei mul mai suval meatin tavaeen tai koa mulin vativieh keil onen tuai. Kei losil kat out vasi ral min mari keihoen onen. Mul mai ral min ui umen onen ten vaeen koa vi tounah keil koa lah lati ran vativieh keil onen. Anatin, kei mai ris ral min meatin keil onen koa kulat keil ran hen vativieh keil onen. ");
INSERT INTO pma_vpl VALUES ("IS40_11","024_40_11","ISA","40","11","11","Kei hetounat revi en meatin keil onen hesuval meatin ten sipsip mul rounat en sipsip keil osen. Anatin, Iahova houmoni min meatin keil onen, hesuval meatin koa mul vous titi sipsip keil osen ka kav kat revi mul en veimasen. Anatin, Ahi hesuval meatin tai koa ring meraun sipsip keil osen koa titae keil mul. ");
INSERT INTO pma_vpl VALUES ("IS40_18","024_40_18","ISA","40","18","18","?Kami mimundemi keke Ahi suval asa? ?Asa varei suvali? ");
INSERT INTO pma_vpl VALUES ("IS40_19","024_40_19","ISA","40","19","19","?Mukave? ?Kei suval nana koa meatin enges musahi, ka amosan eni en tounah tetahos keil suval gol ka silva? !Vuo! ");
INSERT INTO pma_vpl VALUES ("IS40_20","024_40_20","ISA","40","20","20","Ka munak mani ten vati ahi koanek keih ramat, meatin kilea valei kat ai tai koa keih koa sakras vamande. Hevus, kei helei kat meatin koa vi meteisau vasah etai nana koa kilea vahatimal revi ka sakras vamot. ?Iahova suval vati ahi koanek? !Vuo! ");
INSERT INTO pma_vpl VALUES ("IS40_21","024_40_21","ISA","40","21","21","?Kami mireingeingeni? ?Mirlongtei asa koa kistal en avong mulamu? ?Mirlongtei veah isei mumon out netan? Iahova varei mumoni. ");
INSERT INTO pma_vpl VALUES ("IS40_22","024_40_22","ISA","40","22","22","Kei mul rondan en vulin ten keihoen nesa mok mulin out netan. Mul les meatin keil ten out netan avi heisavos suval titin keil. Ahi mumon out netan ka leh teilang kav koe. Anatin, leh teilang suval tavolin keke meatin keil avato ien. ");
INSERT INTO pma_vpl VALUES ("IS40_23","024_40_23","ISA","40","23","23","Ral min keihoen onen, Ahi kilea vou tan en avat keil koa amundemi keil akur keihoen ka hesakin keil imai ihi heisav enges. ");
INSERT INTO pma_vpl VALUES ("IS40_24","024_40_24","ISA","40","24","24","Avat keil enek asuval titi holeai keil koa avi heite hau, koa ason rohtoh en lite ka amoul havivis. Evus, Iahova mai ven keil suval eang sisil tai, ka sakin keil amaleles ka amukou, muh lat keil, ka avupuol. ");
INSERT INTO pma_vpl VALUES ("IS40_25","024_40_25","ISA","40","25","25","Ahi koa vi votut imok visi vit, “?Inau nasuval asa? ?Isei komal milvinvin?” ");
INSERT INTO pma_vpl VALUES ("IS40_26","024_40_26","ISA","40","26","26","Mihelele hehina nesa en teilang. ?Isei mumon hitu keil vasi koa milesi? Hitu keil enek asuval meatin keil tavaeen koa Iahova mul mulamun keil amemea ka vise retai en keil en eis kati one. Veni keihoen onen marite, tovuol en keil vavuol. ");
INSERT INTO pma_vpl VALUES ("IS40_27","024_40_27","ISA","40","27","27","?Kami, me-Isrel keil, vensa miselus kutut kat Iahova ka mivit kei reingeingen sakvisien keil onami? ?Vensa mimundemi mivit Ahi en rovattei vailea keke kami milong mahien en hen meatin sav keil? ");
INSERT INTO pma_vpl VALUES ("IS40_28","024_40_28","ISA","40","28","28","?Mukave? ?Mireingeingeni veah, vuo mirlong usiltei veah? Iahova vi Ahi koa mul lises ka lisenges, ka kei varei mumon out netan. Aven sakras vamemerau ka meatin tovuol vailea vasin rendemien keil onen veni mariso ramat. ");
INSERT INTO pma_vpl VALUES ("IS40_29","024_40_29","ISA","40","29","29","Kei varei mul san keihoen min koakeil ave memerau ka arkeihtei. ");
INSERT INTO pma_vpl VALUES ("IS40_30","024_40_30","ISA","40","30","30","Litetai hau keil ka atouli hau keil, avong tei, ave hememerau ka isavoi navong keihoen one mul vus. ");
INSERT INTO pma_vpl VALUES ("IS40_31","024_40_31","ISA","40","31","31","Ka min koakeil aling desien one en Iahova ven kataunien, kei hesan ris keihoen min keil. Tounah vasi keil koa amumoni ral min keihoen koa hesani min keil hemaes hesuval veivakum koa mul muka maes en teilang nesa. Anatin, meatin keil enek ual heha vio … ka ave hermemerautei. Keil akilea iloh heha vio … ave hermahtei. ");
INSERT INTO pma_vpl VALUES ("IS42_1","024_42_1","ISA","42","1","1","Provet Aesea vit mesein selusien onen Iahova vit, “Ekek, meatin toumien onak koa nasan keihoen mini. Kei varei narie lati, ka nasi nau veni. Nasieni en Ninin onak, ka helosil kat revi out vasi keil en sakien ten maluen. ");
INSERT INTO pma_vpl VALUES ("IS42_2","024_42_2","ISA","42","2","2","Kei hervitei meatin koa heselus hekeih, ka en sise keil, hermakultei en selusien onen. ");
INSERT INTO pma_vpl VALUES ("IS42_3","024_42_3","ISA","42","3","3","Ven enmahisien onen, hermumontei hekeih en koakeil mesav keil amumoni keih en keil. Ka koakeil demkatien one rokeihtei mun, kei hesuv kat demkatien one. Navong helei revi en usite onen meatin keil, houmoni hemal min keil vasi. ");
INSERT INTO pma_vpl VALUES ("IS42_4","024_42_4","ISA","42","4","4","Hehati mal hekeih ka rendemien onen sakras vamot heha hetokol avong keke houmon sakien ten maluen hekarahit out vasi netan. Anatin, meatin keil koa aro soutin amul arosin hihiseien keil onen.” ");
INSERT INTO pma_vpl VALUES ("IS42_5","024_42_5","ISA","42","5","5","Evus, provet Aesea vit risi vit, “Koanek selusien onen Iahova koa vi Ahi. ‘Inau namumon teilang koa karahit out netan. Inau namum revi out vasi keil ten out netan ral min tounah vasi keil koa amoul ien. Inau nasan eang ten moulien koa meatin keil amuseh eni. Ka inau naling ninin mul en meatin keil koa amul amual en out netan. ");
INSERT INTO pma_vpl VALUES ("IS42_6","024_42_6","ISA","42","6","6","Ral min maluen onak, inau, Iahova, navisok kum minau, ka nihuli kat hem ka nikataunuk. Nikur koek ka numon hatkatien takeih hetal min meatin keil heka enuk. Nisakinuk kimai kihi laet tai koa hesil en sise ven meatin keil ten kantri sav keil. ");
INSERT INTO pma_vpl VALUES ("IS42_7","024_42_7","ISA","42","7","7","Keik kisakin koakeil avi metovar imai ilele, ka koakeil aro en out koa malikelik en eim takeih, kumon keil imaluv rani.’” ");
INSERT INTO pma_vpl VALUES ("IS49_5","024_49_5","ISA","49","5","5","Meatin toumien onen Iahova viteni vit, “Mulamu, navong arvasitei nau mau, Iahova rie lat nau tuai keke mahi meatin toumien onen. Anatin, rie lat nau malah ris me-Isrel keil koa amul soutin rani. Iahova vati lat inau, ka keihoen onak ka veni.” ");
INSERT INTO pma_vpl VALUES ("IS49_6","024_49_6","ISA","49","6","6","Iahova viteni minau vit, “Keik kovi meatin toumien onak ka kumon tounah keil koa hemariso mok. Anatin, kilah ris me-Isrel keil koa aka rasil ka amoul veah, keil imai ris ito en atan kati one. Ka koa hetetamen imok, nisakinuk kimai kihi laet tai koa hetitin revi heha en kantri vasi keil, keke meatin vasi keil ilea suk keke sise ten mututien onen Ahi mai rokol meatin vasi keil ten out netan.” ");
INSERT INTO pma_vpl VALUES ("IS50_4","024_50_4","ISA","50","4","4","Meatin toumien onen Iahova viteni vit, “Iahova ten Keihoen san ileilien minau keke mahisein meatin sav keil eni, ka masan selusien ten kataunien min koakeil alehkao. En visokon vasi, Ahi sisil en nau keke nitaengon revi asa koa vit vahiseinau eni. ");
INSERT INTO pma_vpl VALUES ("IS50_5","024_50_5","ISA","50","5","5","Iahova sakinau namundem kilea selusien onen. Narseseintei ka narvilestei eisiluk vaha rani. ");
INSERT INTO pma_vpl VALUES ("IS50_6","024_50_6","ISA","50","6","6","Navong meatin keil e vati avatah nau en viau ven umen koa keik kosani minau, namaen eisiluk min keil amutahi. Navong keil aleh lat hiluk ten veimasok ka amutiv kat veinak, narling suaintei veinak ran keil. Ka navong keil aselus karen nau, naro raeng enges. ");
INSERT INTO pma_vpl VALUES ("IS50_7","024_50_7","ISA","50","7","7","Tounah keil amumoni va kat inau sakras voumonau mamemou veni nakilea keke Iahova ten Keihoen mul kataunau. Sakini nasak meseinau makur tounah koa keil umoni minau veni nakilea asakras avasakinau mamemou. ");
INSERT INTO pma_vpl VALUES ("IS50_8","024_50_8","ISA","50","8","8","Keil asakras veni Ahi ro vesesal venau, ka kei hetie lati min keil keke moulien onak muto en meten. ?Isei en vati vason selusien tatisa vaha kat nau? Tahos lovaha en kot lovahatimal ruai keke avatalimal en ialu. En out enek, kei hehit visi asa koa mundemi namumoni tisa eni. ");
INSERT INTO pma_vpl VALUES ("IS50_9","024_50_9","ISA","50","9","9","Iahova ten Keihoen varei heselus en usite onak. ?Sakini, isei kilea vaselus vatisa vaha kat inau? Keil akilea avaselus heha vio … ivupuol enges.” ");
INSERT INTO pma_vpl VALUES ("IS52_13","024_52_13","ISA","52","13","13","Iahova selus ka en provet Aesea vit, “?Kami milesi? Meatin toumien onak houm hetal min meteisauen, ka houm vasi tounah koa nalingi en hen. Ven sakien enek, nihati lati ka nisan houhouen mini. Anatin, nisan more eis ten hetetamenien mini. ");
INSERT INTO pma_vpl VALUES ("IS52_14","024_52_14","ISA","52","14","14","Navong amuti katiat nan ka amutahi aven, amumoni va vio … alesi suval rovitei mun meatin. Sakini, meatin keil houlu amutimanin eni navong alesi. ");
INSERT INTO pma_vpl VALUES ("IS52_15","024_52_15","ISA","52","15","15","Ka navong iles hetetamenien onen, meatin keil houlu ten out netan itimanin eris eni, ka asuv houlu keil e hehon. Veni keil ilei kilea en asa koa arlong usiltei veah, ka indem kilea suk tounah keil areingeingeni veah mulamu.” ");
INSERT INTO pma_vpl VALUES ("IS53_1","024_53_1","ISA","53","1","1","Navong meatin keil iles asa koa hekistal en meatin toumien onen Iahova, keil ihiteni min keil eris ihit, “?Munak meatin tai vit usil longlongien enek mulamu, isei hekur anatin eni? ?Isei kilea valei kilea hen Iahova en sakien keil koa kistal ekek? ");
INSERT INTO pma_vpl VALUES ("IS53_2","024_53_2","ISA","53","2","2","Vi rendemien onen Iahova enges keke meatin toumien onen hemoul hesuval liai koa viteh en atan tames. Tounah tovuol en veinan vuo en aven koa vasakin meatin keil avandem usili vuo avousili. Anatin, tounah tovuol varei eni koa valeh meten meatin keil. ");
INSERT INTO pma_vpl VALUES ("IS53_3","024_53_3","ISA","53","3","3","Meatin keil amundem maeni ka aseseini. Kei vi meatin koa kilea revi sakvisien keil ka mahien keil emun. Kei vi meatin koa meatin sav keil amundem heisav eni ka e rovattei availea kei. ");
INSERT INTO pma_vpl VALUES ("IS53_4","024_53_4","ISA","53","4","4","“Anatin eli, kei lah lat mesaien keil orer, ka kur mahien keil orer en aven. Ir romundemi keke Ahi varei san sakvisien ka mahien keil mini. Anatin, romundemi keke amutah purun aven ven tisaen onen enges. ");
INSERT INTO pma_vpl VALUES ("IS53_5","024_53_5","ISA","53","5","5","Ka asal vini ven tisaen keil orer. Anatin, amuti kareni ven sakien tisa keil koa ir enges romumoni. Amutah puruni keke ir rokilea rovato en tomat vatal min Ahi. Ka out koa lovlovu en aven, sakin aver maluv ran mesaien keil. ");
INSERT INTO pma_vpl VALUES ("IS53_6","024_53_6","ISA","53","6","6","Ir vasi rosuval sipsip keil koa alei ras sise one ka avuol. Anatin, ir vasi romusil retai en sise keil orer. Ka mahien koa mal keke Ahi hesani min ir ven tisaen keil orer, kei sani suk min meatin toumien onen. ");
INSERT INTO pma_vpl VALUES ("IS53_7","024_53_7","ISA","53","7","7","“Avaseini meatin keil amum tisa houlu va kati, rendemien onen mules netan, ro raeng enges. Kei suval titi sipsip tai koa amulamuni vaha avouasi vamat, roviten etai selusien. Anatin, romumontei verien suval sipsip tai navong asoui lin hilin. ");
INSERT INTO pma_vpl VALUES ("IS53_8","024_53_8","ISA","53","8","8","Navong ales usite onen en kot, armumontei vamal eni. Keil amulamuni va vamat, ka meatin keil amundem heisav eni enges. Asan rendemien keke moulien onen vavus ran out netan, ven tisaen keil orer. ");
INSERT INTO pma_vpl VALUES ("IS53_9","024_53_9","ISA","53","9","9","Avaseini e vati avatahin teiai onen vesesal ven koakeil amum tisa, navong mat, arahini en out koa arahin koakeil tounah one houlu amul ien. Keil avit umoni mini mukonek, avaseini kei romumontei rea vuo roluvostei meatin sav keil.” ");
INSERT INTO pma_vpl VALUES ("IS53_10","024_53_10","ISA","53","10","10","Ka en Aesea, Iahova selus eris usil meatin toumien onen vit, “Inau etin, namumon rendemien onak keke kei hekur mahien hesuval amuti kokoa. Inau nisakin moulien onen hemai hehi sanien votut tai koa voutut moulien onen meatin keil. Ka katau, hemoul eris ran matien ka heles titan keil. Anatin, hemoul heto hetaveah ka heles koakeil emun ikistal ika en keil. Ka en meatin toumien onak, rendemien keil koa naling kati hemai hekur heite. ");
INSERT INTO pma_vpl VALUES ("IS53_11","024_53_11","ISA","53","11","11","Katau en mahien onen, kei heles ris sien en moulien onen. Kei heilea suk keke rokur heisav entei mahien onen. Meatin toumien onak, moulien onen mal revi ka houmon moulien onen meatin keil houlu hemai hemal en metok. Helah lat tisaen keil one ran keil keke num ris methos onak hetal min keil. ");
INSERT INTO pma_vpl VALUES ("IS53_12","024_53_12","ISA","53","12","12","Hesakini, inau nisan eis ten hetetamenien mini ka hetondan hetal min hetetamen sav keil ka hetal min koakeil akur keihoen. Numoni hemukonek veni kei mae koteh moulien onen vamat, ka maen kei enges keke avasak puruni vatal min meatin tisa keil. Ka kei lah lat tisaen keil ran meatin keil houlu, ka vis Ahi voumon ris methos onen min keil.” ");
INSERT INTO pma_vpl VALUES ("IS55_1","024_55_1","ISA","55","1","1","Iahova selus min meatin keil onen ka en provet Aesea vit, “!Ei, kami vasi koa maroro kat kami, oai keiek, mihemai mihemuni! Ka kami koa mani onami tovuol, almai alhul anien ranau ka miheani. Anatin, almai venau ka alhul uaen ka melik, veni inau nisa maeni min kami suval sanien enges. ");
INSERT INTO pma_vpl VALUES ("IS55_2","024_55_2","ISA","55","2","2","?Vensa mivul tounah en mani onami koa sakras vakataun moulien onami? ?Vensa mimum keih keke mivahul anien koa sakras val vataveah? Mihetaeng revi enau ka mihoumon asa koa mahiteni. Hemukonek, en tinomi, mihesi kami ven anien koa tahos vis tahos imok koa nisani min kami. ");
INSERT INTO pma_vpl VALUES ("IS55_3","024_55_3","ISA","55","3","3","Meatin keil onak, mihelong nau ka mihemai venau. Mihemai venau, ka mihelei kat moulien koa vi anatin. Inau numon hatkatien takeih hetal min kami koa hel lisenges, ka nitie lat envatien onak min kami musil asa koa navat kati min asuv houlu Deved mulamu.” ");
INSERT INTO pma_vpl VALUES ("IS55_6","024_55_6","ISA","55","6","6","Aesea viteni min meatin keil vit, “Kosa, mihehiles mihelei kat Iahova navong maen kami mivahotini. Mihehiso heha veni navong mul vesesal ven kami. ");
INSERT INTO pma_vpl VALUES ("IS55_7","024_55_7","ISA","55","7","7","Kami, meatin tisa keil, mihelokovein sakien tatisa keil onami ka rendemien keil koa romaltei. Anatin, kami mihehiles moulien onami ka mihemai vesesal ven Iahova. Hemukonek, enmahisien onen hel en kami ka houmon ris methos hetal min kami. Anatin, kei hermundemtei mun tisaen keil onami varei.” ");
INSERT INTO pma_vpl VALUES ("IS55_8","024_55_8","ISA","55","8","8","Evus, Iahova viteni mun min meatin keil onen ka en provet Aesea vit, “Rendemien onak rosuvaltei rendemien keil onami, ka sakien onak teisav ran sakien keil onami. ");
INSERT INTO pma_vpl VALUES ("IS55_9","024_55_9","ISA","55","9","9","Anatin, rendemien ka sakien keil onak vina nesa mok mulin rendemien ka sakien keil onami. Keil amul nesa mok suval koa teilang mul nesa mok mulin out keil vasi en out netan. ");
INSERT INTO pma_vpl VALUES ("IS55_10","024_55_10","ISA","55","10","10","Navong ous motmot ran teilang vakas out netan, mum vasi umen onen. Mul sakin tounah vasi keil koa aluhi en atan moul ka san heite ka aneite min meatin keil avaani. ");
INSERT INTO pma_vpl VALUES ("IS55_11","024_55_11","ISA","55","11","11","En vati sakien enek, selusien onak koa va min meatin keil, sakras vahi heisav enges. Navong nasan selusien tai eva, selusien koanek houm vasi tounah keil koa naling kati tuai voumoni.” ");
INSERT INTO pma_vpl VALUES ("IS59_1","024_59_1","ISA","59","1","1","Provet Aesea sel kat meatin keil vit, “Kami minandemtei minahit Iahova rokurtei keihoen voutut moulien onami. Ka minandemtei mun minahit ralingen vonhon keke rolongtei uaien onami ven kataunien. !Romukteinek varei! ");
INSERT INTO pma_vpl VALUES ("IS59_2","024_59_2","ISA","59","2","2","Tisaen keil onamis mul riti vas kami miva soutin ran Ahi onami. Anatin, tisaen keil enges onami sakin Ahi viles eisilin min kami ka sakin kei rolongtei mun hisien keil onami. ");
INSERT INTO pma_vpl VALUES ("IS59_3","024_59_3","ISA","59","3","3","Sakien keil onami vilehilu en tisaen ka hemi vi amus ral min ran meatin sav keil koa mimuasi mat. Hilingomi vilelau en luvosien ka mimul miselus en tounah koa romaltei. ");
INSERT INTO pma_vpl VALUES ("IS59_4","024_59_4","ISA","59","4","4","En out koa amumon kot ien mirmusiltei sise koa vamal. Ka navong mimulomal keke mivaselus en usite onami, miluvos ka miselus en tounah koa rovitei anatin keke mivaleh rendemien onen meatin sav keil. Kami miling kat sise keke mivapurun meatin sav keil eni, evus, mimusili.” ");
INSERT INTO pma_vpl VALUES ("IS59_9","024_59_9","ISA","59","9","9","Provet Aesea vit lat tisaen en usite onen meatin keil vit, “Ahi rolestei mun usite keil orer ka maluen onen rorokoltei mun out koa roro ien. Komai merosin meneai vakistal en moulien onomai, ka meles mankoli enges. ");
INSERT INTO pma_vpl VALUES ("IS59_10","024_59_10","ISA","59","10","10","Sakini meretavel suval meatin koa meten var. Anatin, memusavoi en taviai enges suval out vong. Avaseini mesav keil ave keih, keihoen tovuol en ir suval memat tuai.” ");
INSERT INTO pma_vpl VALUES ("IS59_12","024_59_12","ISA","59","12","12","Sakini, meatin keil avitehit lat keil min Iahova avit, “O Iahova, sakien tatisa keil onomai koa memumoni va katuk avi houlu ramat. Tisaen keil onomai amul amuas ris komai. Anatin, komai mekilea keil vasi, ka melonge tisa houlu ven keil. ");
INSERT INTO pma_vpl VALUES ("IS59_13","024_59_13","ISA","59","13","13","O Iahova li, komai mevae va katuk, ka memun mevit mereingeingenuk varei. Meseseinuk ka mermusiltei mun keik koa kovi Ahi onomai. Lisenges, meselus usil sise koa mevapurun meatin sav keil eni, ka mukave komai mehemea mehelokovein hem. Luvosien keil amul akistal sase enges ran rendemien onomai, sakini selusien taluvosien mul kistal ran ongomai lises. ");
INSERT INTO pma_vpl VALUES ("IS59_14","024_59_14","ISA","59","14","14","Navong meles revi usite onen meatin keil, mermusiltei mun more sakien keil, ka sakien ten maluen tovuol en komai. Selusien ten anatinien tovuol luhu en meatin keil onomai, ka merkurtei mun anatin en selusien onen meatin sav keil veni komai vasi meluvos. ");
INSERT INTO pma_vpl VALUES ("IS59_15","024_59_15","ISA","59","15","15","Ka veni anatinien tovuol emun en komai, koakeil e vati avalokovein sakien tisa keil one, alesi keke meatin sav keil amea apurun keil.” Sakini, provet Aesea viteni vit, “Sakien tatisa vasi keil onen meatin keil, Iahova lei kilea eni ka rositei veni, veni kei lesi keke maluen tovuol en keil. ");
INSERT INTO pma_vpl VALUES ("IS59_16","024_59_16","ISA","59","16","16","Kei longe tisa navong lele ka lesi keke meatin tovuol vakataun meatin sav keil. Sakini kei vit voutut moulien one en keihoen ka maluen onen enges. ");
INSERT INTO pma_vpl VALUES ("IS59_17","024_59_17","ISA","59","17","17","Sakini, musin en kei suval meatin tavaeen tai. Musin en maluen suval tounah koa mul koe veimasen, ka ling sakien ten mututien suval tounah koa kur koe vatin. Kei hemai hesa kesi min meatin keil usil sakien tisa keil koa amumoni, ka hetie lat vurohien onen min koakeil amum kalkali. ");
INSERT INTO pma_vpl VALUES ("IS59_20","024_59_20","ISA","59","20","20","“Inau, Iahova, nimai en out Serusalem ka nutut moulien onen meatin keil koa amul ien. Anatin, nimai nikur koe me-Isrel keil koa aviles ran tisaen keil one.” ");
INSERT INTO pma_vpl VALUES ("IS61_1","024_61_1","ISA","61","1","1","Koanek selusien onen meatin toumien onen Iahova, “Ninin Votut onen Iahova ten Keihoen mai sienau, veni rie lat nau mahitehiten more longlongien min koakeil tounah one tovuol. Kei sila nau masakin koakeil tine mah, ilonge hetahos eris. Anatin, sila nau mahiteni min koakeil amul en hen mesav keil keke imaluv iha, ka min koakeil amul en mankoli ten eim takeih, keil akilea avasital rani avaha ris teim. ");
INSERT INTO pma_vpl VALUES ("IS61_2","024_61_2","ISA","61","2","2","Kei sila nau mahitehiteni keke Iahova rie lat avong koanek keke kei vatie lat kataunien onen min meatin keil onen, ka vou lin koakeil amum tisa. Kei sila nau numai mahati lat rendemien onen koakeil amurang. ");
INSERT INTO pma_vpl VALUES ("IS61_3","024_61_3","ISA","61","3","3","Numai masakin koakeil amurang en Hou Saeon avakur ris keihoen. Anatin, koakeil arangis meatin tai, nihati lat rendemien one. Nihiles tangien one hemai hehi souen keil ten masmasien. Ka keil ilomal hekeih en sakien ten maluen hesuval vatiai tetaveah keil koa Iahova varei luhi. En sakien enek, moulien one hetie lat muohien ka hetetamenien onen Ahi.” ");
INSERT INTO pma_vpl VALUES ("IS64_4","024_64_4","ISA","64","4","4","Provet Aesea vis min Iahova vit, “O Iahova, meatin tovuol veah valesuk en meten, vuo vakur longlongien usil ahi sav tai koa suvaluk. Veni keik varei komumon marmari tounah vakataun koakeil aling desien one enuk. ");
INSERT INTO pma_vpl VALUES ("IS64_5","024_64_5","ISA","64","5","5","Keik kokur revi koakeil e vati avoumon asa koa mal, koakeil amundem kat mengkatien keil onom ka amusili. Ka min komai, kosel kat komai, ka memules memumon tisaen keil. Anatin, avaseini kovuroh kat komai houlu, en avong onen avu onomai keil mai rokol kosa, komai memules memum romaltei. Mervinvintei kovoutut moulien onomai. ");
INSERT INTO pma_vpl VALUES ("IS64_6","024_64_6","ISA","64","6","6","Komai vasi mermutotei en metom. Anatin, avaseini mesak visi mevoumon sakien keil koa memundemi mevit mal, en metom, sakien keil enek atisaso vilehil. Ven tisaen keil onomai, moulien onomai suval ouai koa maleles ka merangle, ka vuol navong eang muh rasilini vaha. ");
INSERT INTO pma_vpl VALUES ("IS64_7","024_64_7","ISA","64","7","7","Tovuol en komai vahis minuk. Meatin tovuol emun en vati vailea keik. Ven tisaen keil onomai, keik koling suainuk ran komai ka komaen komai mekan heite ten tisaen keil onomai. ");
INSERT INTO pma_vpl VALUES ("IS64_8","024_64_8","ISA","64","8","8","Ka keik, Iahova, kovi Tata onomai. En hem, komai mesuval tanhili koa keik komumoni mai vi pot. Anatin, komai mevi heite ten umen onom. ");
INSERT INTO pma_vpl VALUES ("IS64_9","024_64_9","ISA","64","9","9","Sakini, konavul kattei komai li. O Iahova li, konandemtei mun usil tisaen keil onomai. Kitie lat enmahisien onom min komai li veni mevi meatin keil onom.” ");
INSERT INTO pma_vpl VALUES ("JR1_1","025_1_1","JER","1","1","1","Selusien keil koa mul en tus koanek, inau, provet Seremaea, namutisi. Navi natin Hilkia koa vi pris tai koa mul en taon ten out Anatot koa mul en atan onen koakeil akistal en mari vatiamal onen Bensamin. ");
INSERT INTO pma_vpl VALUES ("JR1_2","025_1_2","JER","1","2","2","Navong asuv houlu Sosaea, natin Amon, losil kat meatin keil ten out Sudah sua teindan etel (13), Iahova selus rohtoh minau. ");
INSERT INTO pma_vpl VALUES ("JR1_3","025_1_3","JER","1","3","3","Ka Ahi selus minau en sua vasi keil koa Sehoiakim, natin Sosaea, vi asuv houlu ka losil kat me-Sudah keil. Anatin, Iahova mul selus minau rokol avong koa asuv houlu Sedekaea, natin Sosaea losil kat me-Sudah keil sua teindan tai (11). En avati koa vi elim en sua koanek, me-Babilon keil umai amu lin me-Sudah keil. Avuli kat keil ka alah vasi keil uva en kantri one ten out Babilon. ");
INSERT INTO pma_vpl VALUES ("JR1_4","025_1_4","JER","1","4","4","En avong enek, Iahova mai selus minau vit, ");
INSERT INTO pma_vpl VALUES ("JR1_5","025_1_5","JER","1","5","5","“Seremaea, mulamu en avong koa namumonuk en vangen mama onom, nakileak tuai. Anatin, mulamu en avong avasuk, nalei kanuk tuai. Nalei kanuk kovamai kovahi provet onak kovaha ven meatin keil ten kantri sav keil.” ");
INSERT INTO pma_vpl VALUES ("JR1_6","025_1_6","JER","1","6","6","Ka navit kesi mini navit, “!O Iahova ten Keihoen! Inau narkilea revitei sakien keil ten selusien veni navi meatin hau enges.” ");
INSERT INTO pma_vpl VALUES ("JR1_7","025_1_7","JER","1","7","7","Ka Iahova viteni minau vit, “Konaselustei konahit keik kovi meatin hau enges. Kiha ven meatin vasi koa nasilak kovaha ven keil, ka kiha kisan selusien vasi keil koa nameng katuk keke kovahiteni. ");
INSERT INTO pma_vpl VALUES ("JR1_8","025_1_8","JER","1","8","8","Konametauntei keil veni, Inau, naro venuk ka niting koek. Inau, Iahova, nasan selusien vasi keilek.” ");
INSERT INTO pma_vpl VALUES ("JR1_9","025_1_9","JER","1","9","9","Evus, Iahova mutelan hen ka rokol ongok ka viteni vit, “Kosa naling selusien keil onak mul en ongom. ");
INSERT INTO pma_vpl VALUES ("JR1_10","025_1_10","JER","1","10","10","?Kolonge? Kosa nalei kanuk kovakur keihoen keke kovahit mesein asa koa hekistal min meatin keil ka en kantri keil emun. Munak kihiteni minau makulat asuv houlu tai ten kantri tai ka mou lin meatin keil onen, inau numoni. Munak kihiteni minau mou rasilin out tai ka maling meatin sav keil avalosil kati, inau numoni. Ka munak kihiteni mahati lat kantri tai ka maluh ris ah keil teni, kei mun, numoni. ");
INSERT INTO pma_vpl VALUES ("JR1_17","025_1_17","JER","1","17","17","“!Seremaea, mea, kisak meseinuk ka kiha! Kiha kilomal ka kihitehiten tounah vasi koa nameng katuk kovahiteni. Kosa, konametautei kovaselus en meten meatin keil. Veni munak kil kimetau, asa koa inau numoni heha katuk hesakinuk kimetau hemarite mok en mete. ");
INSERT INTO pma_vpl VALUES ("JR1_18","025_1_18","JER","1","18","19","Seremaea, kitaengon revi enau. Meatin vasi keil ten kantri koanek ivae heha katuk: asuv houlu keil ten out Sudah, hetetamen keil one, pris keil one, ka me-Sudah vasi keil emun. Ka keil isakras avahitan enuk veni inau niting koek. Kosa nasan keihoen minuk kovamai kovasuval vieh takeih tai koa karahit koe taon tai. Anatin, keik kimai kisuval pos tai ten usi eim koa keih koa amumoni en aean, veni inau, Iahova, naro vesesal venuk ka namese moutut moulien onom.” ");
INSERT INTO pma_vpl VALUES ("JR6_13","025_6_13","JER","6","13","13","“Meatin vasi keil, koakeil avi hetetamen umai arokol koakeil avi havipi, keil vasi avi metenan ka akur mani en sise koa romaltei. Avaseini keil avi pris vuo provet keil, keil amules aluvos meatin keil keke avalah mani one. ");
INSERT INTO pma_vpl VALUES ("JR6_14","025_6_14","JER","6","14","14","Kosa, tounah keil houlu amul apurun meatin keil onak, ka avat keil amum heisav enges. Hetetamen keil enek amul aviteni min meatin keil avit, ‘Tomat onen Ahi hel ven kami.’ Ka kosa, tomat tovuol varei.” ");
INSERT INTO pma_vpl VALUES ("JR17_5","025_17_5","JER","17","5","5","Koanek selusien onen Iahova koa ka en provet Seremaea vit, “Mahien hel en koakeil envatien one romultei enau ka koakeil aviles ranau. Keil aling desien one en keihoen onen meatin enges. ");
INSERT INTO pma_vpl VALUES ("JR17_6","025_17_6","JER","17","6","6","Keil asuval holeai keil koa amoul en out volvol, keil asakras avales tahosien en moulien one. Moulien one hehi heite hon hesuval out tames, ka hesuval out koa sol purun atan teni keke tounah tovuol vamoul ien. ");
INSERT INTO pma_vpl VALUES ("JR17_7","025_17_7","JER","17","7","7","“Ka koakeil aling desien one mul enau, inau nitokol kat keil. ");
INSERT INTO pma_vpl VALUES ("JR17_8","025_17_8","JER","17","8","8","Keil isuval vatiai keil koa aluhi mul en vali oaisal, koa lite keil amoul arokol oai. Avaseini mahien keil umai hesuval meteiai ritin keih, keil asakras avametau veni iles tahosien hesuval vatiai koa oute keil memeasen lises. Avaseini ous romustei, keil amules arekao. ");
INSERT INTO pma_vpl VALUES ("JR17_9","025_17_9","JER","17","9","9","“Tin meatin keil vilehilu, lises mul liluvos. Meatin tovuol vailea vasi en tisaen keil koa mul suai eni. ");
INSERT INTO pma_vpl VALUES ("JR17_10","025_17_10","JER","17","10","10","Ka inau, Iahova, nalei kilea en rendemien onen meatin keil, ka nalei revi tounah koa mul en tine. Sakini, nisa kesi min keil housil sakien keil koa amumoni, ka nisan heite ten umen one min keil. ");
INSERT INTO pma_vpl VALUES ("JR20_5","025_20_5","JER","20","5","5","“En avong keil koa amul umai, vativieh keil onami imai ivae heha kat taon onami ten out Serusalem. Ka keil ilah mani ka tounah vasi onami koa tahos imok koa amumoni en gol, silva ka more ahat keil hehi one. Anatin, keil ilah tounah sav vasi koa tetahos emun koa asuv houlu keil ten out Sudah aling ruaini mul, ka ilahi heha ris en kantri one ten out Babilon.” ");
INSERT INTO pma_vpl VALUES ("JR20_7","025_20_7","JER","20","7","7","Evus, provet Seremaea vis Ahi vit, “O Iahova, keik koluvos inau ka inau nakur anatin eni. Ral min keihoen onom, kokeih kat nau, ka komulinau. !Ven selusien koa kosani minau, meatin vasi keil amul akarenau! !Lises amul aviteai enau! ");
INSERT INTO pma_vpl VALUES ("JR20_8","025_20_8","JER","20","8","8","Ka navong vasi namang vas ongok maselus, keik kosakinau naviso va kat meatin keil ka namakul kat keil navit, ‘!Vaeen keil imai ka u lin tounah vasi onami!’ O Iahova, meatin keil amunge katnau ka avit usil nau veni namul navitehiten selusien onom. ");
INSERT INTO pma_vpl VALUES ("JR20_9","025_20_9","JER","20","9","9","Ka munak naviteni en rendemien onak navit, ‘Nirselustei usil Ahi ka nirvit meseintei mun selusien onen en Isen,’ selusien onom mai suval ahang koa mukan purun tinok. Nasak visi mahuli kat selusien onom, ka nasakras varei. ");
INSERT INTO pma_vpl VALUES ("JR20_10","025_20_10","JER","20","10","10","Nalong meatin keil aselus lelau va kat nau avit, ‘Meatin ekek vi uti metauen varei. !Rovaha rovahit lat kei min avat orer keil!’ More tuak vasi keil e vat nau mamot en selusien onak ka arosinau keke avasak luvos nau. Keil amul avit, ‘Munak rokilea rovasak luvosi, ir rehut kati ka rehouasi vasa kes mahien koa selusien onen mumoni vakat ir.’ ");
INSERT INTO pma_vpl VALUES ("JR20_11","025_20_11","JER","20","11","11","Ka keik, Iahova, komul koring koe nau suval meatin tavaeen tai koa aven keih. Sakini, koakeil asak visi avapurunau, keil imot. Keil isak visi mok ihit avouas nau, ka keil isakras. Keil imemou vareis veni keil asakras avoumon etai tounah vaha kat inau. Memouen one, meatin sav keil asakras e vavobongeni en avong etai. ");
INSERT INTO pma_vpl VALUES ("JR20_12","025_20_12","JER","20","12","12","O Iahova, asuv houlu ten out nesa, keik kolei revi usite onen koakeil amal en metom, ka kokilea asa koa mul en tine ka rendemien one. Sakini, ek vati malesuk kovasa kes mahien min vativieh keil onak, veni naling usite onak mul en hem. ");
INSERT INTO pma_vpl VALUES ("JR20_13","025_20_13","JER","20","13","13","“!Sakini, mihesau min Iahova! !Anatin, mihehati lat Isen! Veni kei mul mutut koakeil meatin sav keil amul apurun keil, ka mul lah lat keil ran hen koakeil atisa.” ");
INSERT INTO pma_vpl VALUES ("JR23_1","025_23_1","JER","23","1","1","Iahova selus min meatin keil ka en provet Seremaea vit, “!Hetisa mok min avat keil onen me-Isrel keil koa amul asak purun meatin keil onak! Keil asuval meatin tisa keil koa arlosil kat revitei sipsip keil ose ka amaen keil aretasil.” ");
INSERT INTO pma_vpl VALUES ("JR23_2","025_23_2","JER","23","2","2","Ven sakien one, koanek vi selusien onen Iahova, Ahi onen me-Isrel keil, va min avat keil koa ling keil avalosil kat revi meatin keil onen. Kei mul viteni vit, “!Kami mirlosil kat revitei meatin keil onak! Milikat rasilin keil avaha. Sakini, nisan mahien min kami ven tounah tisa keil koa mimumoni. ");
INSERT INTO pma_vpl VALUES ("JR23_3","025_23_3","JER","23","3","3","Hevus, inau nilah ruain vangi meatin keil onak imai ris ran kantri savsav keil koa namaen keil aratasil uva aro ien. Anatin, nilah ris keil imai ito en atan kati one ka ikur titiali keil imai ihi houlu eris. ");
INSERT INTO pma_vpl VALUES ("JR23_4","025_23_4","JER","23","4","4","En avong enek, inau nilei kan avat keil koa imai ilosil kat revi keil. Keil isuval meatin keil koa alosil kat revi sipsip ose keil ka umon keil irmetautei mun ka irmundemkotei. Tovuol en keil hevuol.” ");
INSERT INTO pma_vpl VALUES ("JR23_5","025_23_5","JER","23","5","5","Iahova selus eris vit, “Avong tai mul mai keke nihati lat asuv houlu tai koa sakien onen mal revi ran vatiamal onen Deved. Kei helosil kat meatin keil hetahos ka helei revi usite one housil meteisauen onen. Min koakeil amum tisa, kei hesan mahien min keil, ka min koakeil amum tahos, hesan tahosien min keil. ");
INSERT INTO pma_vpl VALUES ("JR23_6","025_23_6","JER","23","6","6","Navong kei vi asuv houlu, me-Sudah keil ito en tahosien, ka me-Isrel keil ito en tomat. Keil ihise en ‘Iahova-sidkenu’ koa aneite teni vi ‘Iahova vi maluen orer.’” ");
INSERT INTO pma_vpl VALUES ("JR29_1","025_29_1","JER","29","1","1","Koanek selusien koa provet Seremaea, koa mul en out Serusalem, mutisi ka sani min elda keil, pris keil, provet keil, ka me-Isrel vasi keil emun koa asuv houlu Nebukanesa lah lat keil ran out Serusalem keke aval en hen en out Babilon. ");
INSERT INTO pma_vpl VALUES ("JR29_10","025_29_10","JER","29","10","10","Provet Seremaea mutisi vit, “Koanek selusien onen Iahova koa vit, ‘Kami miheto en hen me-Babilon keil hetokol sua hanumau etel ka halualim emun (70). Hevus, niha ris niles kami ka num housil hatkatien koa namumoni ral min kami keke malah ris kami mivamai en atan ekek. ");
INSERT INTO pma_vpl VALUES ("JR29_11","025_29_11","JER","29","11","11","Anatin eli, inau, Iahova, namundem kati keih asa koa naling kati keke vakistal en kami. Naling kati keke kami miheles tahosien ka hervitei mahien. Anatin, tounah keil tetahos koa naling kati hemai hekistal en moulien onami, mihendem usili hetal min sien veni mikilea hemai hehi anatin. ");
INSERT INTO pma_vpl VALUES ("JR29_12","025_29_12","JER","29","12","12","En avong enek, navong kami mihehise nau ka mihehis minau, inau nilong hisien onami. ");
INSERT INTO pma_vpl VALUES ("JR29_13","025_29_13","JER","29","13","13","Anatin, navong mihelekat nau hetal min tinomi vasi, mihehotinau. ");
INSERT INTO pma_vpl VALUES ("JR29_14","025_29_14","JER","29","14","14","Anatin, nimaen kami mihehotinau, ka inau, Iahova, nisan ris asa koa vuol ran kami. Nikur ris kami mihemai ran kantri keil ka out vasi koa nalikat kami miva miro ien. Hevus, nikur ris kami miheha miheto en atan koa nasila lat kami rani. Inau, Iahova, nasan selusien vasi keilek.’” ");
INSERT INTO pma_vpl VALUES ("JR31_3","025_31_3","JER","31","3","3","Mulamu, Iahova kistal min ir ka viteni vit, “Inau, ek vat kami ral envatien koa keite teni tovuol. Ral min tahosien koa narie lati min kami, naleh kami mimai vesesal venau. ");
INSERT INTO pma_vpl VALUES ("JR31_31","025_31_31","JER","31","31","31","“Sakini, inau, Iahova, naviteni keke avong tai mul mai keke numon hatkatien hau takeih hetal min me-Isrel keil ka hetal min me-Sudah keil emun. ");
INSERT INTO pma_vpl VALUES ("JR31_32","025_31_32","JER","31","32","32","Hatkatien hau koanek hersuvaltei hatkatien matu koa namumoni ral min avu one keil telamu en avong koa navuli kat he ka namulamun keil alokovein kantri ten out Isip. Inau nalei kat revi keil suval meatin tai mul lei kat revi ahin onen. Ka avaseini, keil arali koteh hatkatien takeih koa amumoni ral minau. ");
INSERT INTO pma_vpl VALUES ("JR31_33","025_31_33","JER","31","33","33","Hatkatien hau koa numoni hetal min me-Isrel keil en avong enek hemukok: Inau, Iahova, niling mengkatien onak keil il en rendemien one, ka nitis kati hel en tine. Inau nihi Ahi one, ka keil ihi meatin keil onak. ");
INSERT INTO pma_vpl VALUES ("JR31_34","025_31_34","JER","31","34","34","Hesakini, keil irviseintei mun tue keil availea en Iahova veni keil vasi ilea enau, koakeil avi havipi heha hetokol koakeil amarite. Anatin, keil ilea enau veni nirleletei mun hetisa en keil ven tounah keil one koa romaltei amumoni. Anatin, nirmundem usiltei mun tisaen keil one koa va kat keil. Inau, Iahova, nasan selusien vasi keilek.” ");
INSERT INTO pma_vpl VALUES ("LM1_8","026_1_8","LAM","1","8","8","Ir, meatin keil ten out Serusalem, tisaen orer houlu ramat, ka amul amumon ir rovilehilu en meten Iahova. Koakeil avouhou min ir mulamu, kosa, keil alei sesein ir, veni tisaen keil orer mai en mesaiuai suval ir rokaka hon. Sakini, romis ka rokav koe nar veni romemou. ");
INSERT INTO pma_vpl VALUES ("LM2_17","026_2_17","LAM","2","17","17","Tounah keil koa Iahova vat kati vit houmoni min ir, kei mum vasi. Kei mu rasilin ir ka tounah keil orer suval koa sel kat ir eni mulamu. Kei rorie lattei mun enmahisien min ir. Kei mumon vativieh keil orer asi keil veni maen keil amu lin ir en vaeen. ");
INSERT INTO pma_vpl VALUES ("LM3_19","026_3_19","LAM","3","19","19","Ka navong namundem usil tounah keil koa purunau kosa, ka mukave tounah onak tovuol suval meatin tai koa out kati onen tovuol, kun en moulien onak suval oai ten measen koa kun. ");
INSERT INTO pma_vpl VALUES ("LM3_20","026_3_20","LAM","3","20","20","Rendemien keil ekek mul en moulien onak lises, ka tinok mul mis veni. ");
INSERT INTO pma_vpl VALUES ("LM3_21","026_3_21","LAM","3","21","21","Ka avaseini, navong narendem sakien onen Iahova, mumonau namundem usil asa koa hemai hetal sien. ");
INSERT INTO pma_vpl VALUES ("LM3_22","026_3_22","LAM","3","22","22","Nakilea keke envatien onen hel lisenges, ka sakras vavus. Ka enmahisien onen emun, keite teni hetovuol. ");
INSERT INTO pma_vpl VALUES ("LM3_23","026_3_23","LAM","3","23","23","Keilu luvi heite hau en visokon vasi. Hatkatien keil onen, kei mum vasi. ");
INSERT INTO pma_vpl VALUES ("LM3_24","026_3_24","LAM","3","24","24","Avaseini tounah onak tovuol, demkatien onak keih en Iahova koa tahos imok mulin tounah keil vasi ten out netan. Sakini, naling desien onak en kei enges. ");
INSERT INTO pma_vpl VALUES ("LM3_25","026_3_25","LAM","3","25","25","Iahova mumoni tahos min koakeil aling desien one en kei, min koakeil amul amusili. ");
INSERT INTO pma_vpl VALUES ("LM3_26","026_3_26","LAM","3","26","26","Sakini, tahos keke ir reheto raeng, ka rehetosin avong koa Iahova hemai houtut moulien orer. ");
INSERT INTO pma_vpl VALUES ("EK2_1","027_2_1","EZK","2","1","1","Ahi viteni minau vit, “!Natin Meatin, mea kilomal! Ek vati maselus minuk.” ");
INSERT INTO pma_vpl VALUES ("EK2_2","027_2_2","EZK","2","2","2","Ka navong mul selus minau, ninin onen mai sien nau ka rali lat nau namulomal. Evus, naraengoni kei selus eris minau vit, ");
INSERT INTO pma_vpl VALUES ("EK2_3","027_2_3","EZK","2","3","3","“Natin Meatin, namul nasilak keke kovaha ven me-Isrel keil. Kiha kiles vatkeih keil koa amul aviles eisile ranau. Keil asuval avu one keil telamu, keil vasi amul along seseinau mai rokol kosa ekek. ");
INSERT INTO pma_vpl VALUES ("EK2_4","027_2_4","EZK","2","4","4","Vatie keih ka arvouhoutei minau. Ka avaseini amumon sakien keil ekek, nasilak kovaha keke kovahit mesein asa koa inau, Iahova, Ahi ten keihoen, ek vati mahiteni min keil. ");
INSERT INTO pma_vpl VALUES ("EK2_5","027_2_5","EZK","2","5","5","Anatin keke vatie keih ka e rovattei availea selusien keil onak. Ka avaseini munak keil ilong kat selusien keil onak vuo ilong seseini, ka ek vati enges keke availea keke provet tai onak mai selus min keil. ");
INSERT INTO pma_vpl VALUES ("EK33_7","027_33_7","EZK","33","7","7","“Natin Meatin, kosa nalinguk kimai kihi meatin tai taleikokoeien keke kovalei kokoe en me-Isrel keil. Sakini, navong nasan selusien tai minuk, keik kiha kisel kat keil eni. ");
INSERT INTO pma_vpl VALUES ("EK33_8","027_33_8","EZK","33","8","8","Munak nihiteni minuk keke meatin tai hemat ven sakien tatisa keil onen ka keik korvatei kovahit meseini mini, kei sakras vahiles sakien keil onen keke inau moutut moulien onen. Hesakini, hehi anatin keke hemat ven tisaen keil onen, ka en metok, ran hel en hem. ");
INSERT INTO pma_vpl VALUES ("EK33_9","027_33_9","EZK","33","9","9","Ka munak kiha kihit meseini mini, ka kei hervilestei ran tisaen keil onen, anatin keke hemat ven tisaen keil onen, ka keik, kutut sasom en moulien onom.” ");
INSERT INTO pma_vpl VALUES ("EK36_16","027_36_16","EZK","36","16","16","Iahova vit risi mini vit, ");
INSERT INTO pma_vpl VALUES ("EK36_17","027_36_17","EZK","36","17","17","“Natin Meatin, navong me-Isrel keil amul veah en atan kati ose, keil asakin atan ose mai vilehilu en tisaen keil ka sakkalkalien keil one. En metok, sakien keil one romutotei suval ara ten mesaien koa onen mama keil. ");
INSERT INTO pma_vpl VALUES ("EK36_18","027_36_18","EZK","36","18","18","Keil aleh vurohien onak va kat keil ven ran meatin keil koa amu vinvini keil en atan koanek, ka veni keil asakin out vi amus ral min nana keil koa aling keil amul ien. ");
INSERT INTO pma_vpl VALUES ("EK36_19","027_36_19","EZK","36","19","19","Inau nalei revi usite keil ten umen ka sakien keil one ka nalesi keke armaltei en metok. Sakini, nasila rasilin keil avaha en kantri sav keil. ");
INSERT INTO pma_vpl VALUES ("EK36_20","027_36_20","EZK","36","20","20","Ka en out vasi koa uva aro ien, keil asakin meatin sav keil avitan en Isok veni koakeil ten kantri keil enek avit, ‘Alah lat me-Isrel keil ekek ran atan kati one veni Iahova, Ahi one, keihoen onen rovinvintei vakur koe keil.’ ");
INSERT INTO pma_vpl VALUES ("EK36_21","027_36_21","EZK","36","21","21","Sakini, namundem usil Isok koa vi votut, veni navong me-Isrel uva en kantri sav keil, sakien tisa one sakin meatin savsav keil alei heisav en Isok. ");
INSERT INTO pma_vpl VALUES ("EK36_22","027_36_22","EZK","36","22","22","“Sakini, kiha kihiteni min me-Isrel keil kihit, ‘Koanik selusien onen Iahova, Ahi anatin. Asa koa inau numoni, nirmumontei ven kami, me-Isrel keil. Numoni vahati lat ris Isok koa vi votut. Anatin, nihati lat Isok koa kami, me-Isrel keil, mimumoni mai vi amus en meten meatin keil ten kantri vasi keil koa miro ien. ");
INSERT INTO pma_vpl VALUES ("EK36_23","027_36_23","EZK","36","23","23","Inau nitie lati min meatin keil vasi ten kantri keil enek keke Isok vi votut. Anatin, Isok koa mimumoni vilehilu en mete, nisakin keil ilei kilea suk keke Isok vina nesa mok. Keil ilea suk isei Iahova koa vi Ahi anatin. Ka en kami, nitie lati min keil keke navi votut. ");
INSERT INTO pma_vpl VALUES ("EK36_24","027_36_24","EZK","36","24","24","Nilah lat kami ran kantri keil koa mimul ien, ka nilamun kami eris mihemai en atan kati onami. ");
INSERT INTO pma_vpl VALUES ("EK36_25","027_36_25","EZK","36","25","25","Inau nitah oai koa muto en kami ka hesakin kami miheto ran sakien tatisaso keil onami ka ran sakien tahilehiluen koa mimumoni navong mimul miva netan min nana keil. ");
INSERT INTO pma_vpl VALUES ("EK36_26","027_36_26","EZK","36","26","26","Inau nisakin rendemien keil onami ka envatien keil onami hemai hehi heite hau. Tinomi koa keih, inau nihilesi ka nisakini hemai hemerau. Hemukonek, kami miheilea mivalong kat nau. ");
INSERT INTO pma_vpl VALUES ("EK36_27","027_36_27","EZK","36","27","27","Niling Ninin onak hel en kami koa hesakin kami mihousil revi mengkatien keil onak ka mihelong kat revi selusien keil koa nasani tuai min kami.’” ");
INSERT INTO pma_vpl VALUES ("DN1_1","028_1_1","DAN","1","1","1","Navong asuv houlu Sehoiakim losil kat me-Sudah keil sua etel (3), asuv houlu Nebukanesa ten out Babilon mai ka mumon vaeen ral min keil, ka meatin onen keil akarahit koe taon ten out Serusalem. ");
INSERT INTO pma_vpl VALUES ("DN1_2","028_1_2","DAN","1","2","2","Ka Ahi Asuv maen asuv houlu Sehoiakim ten out Sudah va en hen me-Babilon keil enek. Sakini, meatin tavaeen keil onen asuv houlu Nebukanesa umai alah tounah keil tetahos koa mul en Eim Votut onen Ahi. Akuri ka alingi en out koa aling revi tounah keil tetahos en eim onen ahi one keil en out Babilon. ");
INSERT INTO pma_vpl VALUES ("DN1_3","028_1_3","DAN","1","3","3","Evus, asuv houlu Nebukanesa meng kat avat toumien en teim sen, koa isen Aspenas, keke vaha valei kan meatin hau keil koa atahos imok en meten koa aka en vatiamal keil onen asuv houlu keil vuo hetetamen keil ten out Isrel. ");
INSERT INTO pma_vpl VALUES ("DN1_4","028_1_4","DAN","1","4","4","Asuv houlu visi keke valei kan meatin hau keil koa nae tahos, ka tounah tovuol vakula ave, avilelau en meteisauen ka ileilien, ka ihi vati meatin keil koa ikur tounah hekalah keke imai ivinvin avoum en mari eim omon asuv houlu. Ka asuv houlu Nebukanesa viteni min avat Aspenas vahisein keil en sakien tahulhulien ka tatisien en selusien Arameak, selusien onen me-Babilon keil. ");
INSERT INTO pma_vpl VALUES ("DN1_5","028_1_5","DAN","1","5","5","Asuv houlu meng kati mun keke helei kat revi keil ka hesan tei anien ka uaen min keil hesuval asa koa koakeil amul en mari teim sen asuv houlu amul akuri. Ka navong ihisein keil sua etel (3) hevus, keil iha um min asuv houlu. ");
INSERT INTO pma_vpl VALUES ("DN1_6","028_1_6","DAN","1","6","6","En meatin hau keil enek koa alei kan keil, ehat (4) en keil telka en mari vatiamal onen Sudah, iseatel Daniel, Hananaea, Misel, ka Asaraea. ");
INSERT INTO pma_vpl VALUES ("DN1_7","028_1_7","DAN","1","7","7","Avat Aspenas viles iseatel mukok: min Daniel, ling isen vi ‘Beltesasar,’ min Hananaea, ling isen vi ‘Sadrak,’ min Misel, ling isen vi ‘Misak,’ ka min Asaraea, ling isen vi ‘Abednego.’ ");
INSERT INTO pma_vpl VALUES ("DN1_8","028_1_8","DAN","1","8","8","Ka Daniel, kei mumon rendemien onen keke aven hetolas en meten Ahi. Sakini, kei vit herkantei anien vuo hermuntei uaen koa ka en teim omon asuv houlu koa romutotei en meten Ahi. Sakini vis avat Aspenas vakatauni. ");
INSERT INTO pma_vpl VALUES ("DN1_9","028_1_9","DAN","1","9","9","Avaseini keke Ahi sakin avat Aspenas rendem tahos en Daniel ka en mahisi, ");
INSERT INTO pma_vpl VALUES ("DN1_10","028_1_10","DAN","1","10","10","viteni min Daniel vit, “Vuo, nasakras eli, veni nametaun asuv houlu onak. Veni kei enges rie lat anien sa koa miheani ka uaen koa mihemuni. Ka munak helesi keke avem hetisa mok en meatin hau sav keil ekek, kei hou vini nau nimat.” ");
INSERT INTO pma_vpl VALUES ("DN1_11","028_1_11","DAN","1","11","11","Sakini Daniel va selus ral min meatin taleikokoeien koa avat Aspenas rie lati valosil kat kei ral min Hananaea, Misel ka Asaraea. Daniel viteni mini vit, ");
INSERT INTO pma_vpl VALUES ("DN1_12","028_1_12","DAN","1","12","12","“Komaitel metpeahik eli keke kovasak vis komaitel avong halualim (10). En avong keil enek, kisan anien hon koa vuseri tovuol ien metheani hetal oai enges methemuni. ");
INSERT INTO pma_vpl VALUES ("DN1_13","028_1_13","DAN","1","13","13","Hevus, kilei vis avemeitel ral min meatin hau sav keil koa amul akan anien koa asuv houlu meng kati keke avaani. Hevus, kilei visi hemukave.” ");
INSERT INTO pma_vpl VALUES ("DN1_14","028_1_14","DAN","1","14","14","Sakini, maen keitel telhoum visi hetokol avong halualim (10). ");
INSERT INTO pma_vpl VALUES ("DN1_15","028_1_15","DAN","1","15","15","Navong avong halualim (10) muli, meatin taleikokoeien enek lesi keke aveatel keih ka tahos imok mulin koakeil akan anien koa asuv houlu meng kati. ");
INSERT INTO pma_vpl VALUES ("DN1_16","028_1_16","DAN","1","16","16","Ven sakien koanek, kei maen keitel keke lises telheanian hon enges hemukonek, ka rosantei mun anien ka uaen koa asuv houlu meng kati min keil. ");
INSERT INTO pma_vpl VALUES ("DN1_17","028_1_17","DAN","1","17","17","Ka min keitel, Ahi san ileilien ka meteisauen ten hihiseien keil, tus keil ka selusien keil onen me-Babilon keil. Ka min Daniel, Ahi sakini mun kilea vahit luvat aneite ten leisanien ka matil vovoien keil. ");
INSERT INTO pma_vpl VALUES ("DN1_18","028_1_18","DAN","1","18","18","En keite ten sua etel (3) koa asuv houlu meng kati, Aspenas lah meatin hau vasi keil avamai avalomal en meten asuv houlu Nebukanesa. ");
INSERT INTO pma_vpl VALUES ("DN1_19","028_1_19","DAN","1","19","19","Ka navong asuv houlu sak vis keil vasi en selusien evus, votini keke Daniel, Hananaea, Misel ka Asaraea, keitel teltahos imok mulin teisav keil en hihiseien keil vasi. Sakini, kei rie lat keitel telvamai telvoum mini. ");
INSERT INTO pma_vpl VALUES ("DN1_20","028_1_20","DAN","1","20","20","Ka en tounah vasi keil koa asuv houlu vis keitel eni, kei votini keke ileilien ka meteisauen oneatel vi halualim (10) nesa mok mulin onen koakeil alei kilea en sise ka onen lingling temat keil koa amul en out vasi koa kei losil kati. ");
INSERT INTO pma_vpl VALUES ("DN1_21","028_1_21","DAN","1","21","21","Ka Daniel mul mum avong taveah va rokol avong koa Saeros mai vi asuv houlu. ");
INSERT INTO pma_vpl VALUES ("DN2_48","028_2_48","DAN","2","48","48","Asuv houlu Nebukanesa vati lat Daniel mai vi avat onen hetetamen sav keil onen ka san sanien tetahos houlu mini. Evus, lingi losil kat mari provins ten out Babilon. ");
INSERT INTO pma_vpl VALUES ("DN2_49","028_2_49","DAN","2","49","49","Ka navong Daniel vis asuv houlu keke vamaen losilkatien ten provins ten out Babilon val en hen Sadrak, Misak ka Abednego, asuv houlu maeni. Ka Daniel, kei mules mum min asuv houlu ka mul san sise mini. ");
INSERT INTO pma_vpl VALUES ("DN3_1","028_3_1","DAN","3","1","1","Avong tai, asuv houlu Nebukanesa meng kat meatin keil onen avoumon mari nana tai. Ka navong alehei avati lati mulomal, mita teni vina nesa rokol hanumau tai ka halualim emun (30 m) ka usi aven rokol usite sav vi mita etel (3 m). Evus, aremal kat nana enek en gol en usite vasi keil, ka avati lati en out tai koa vi aet koa avise en ‘Dura’ en provins ten out Babilon. ");
INSERT INTO pma_vpl VALUES ("DN3_2","028_3_2","DAN","3","2","2","Evus, asuv houlu sisil en hetetamen vasi keil onen avamai avalei rohtoh en nana onen koa amumoni: minista keil onen, avat ten provins keil, koakeil amum suval eria sekreteri, koakeil avit lat sise mini, koakeil alei kat mani keil onen, koakeil alei revi usite onen meatin keil, polis keil onen, asuv vasi keil, ka hetetamen savsav vasi keil emun koa amul en provins enek. ");
INSERT INTO pma_vpl VALUES ("DN3_3","028_3_3","DAN","3","3","3","Navong meatin vasi keil enek alah ruai keke avoumon tokolkatien ven nana koanek, ");
INSERT INTO pma_vpl VALUES ("DN3_4","028_3_4","DAN","3","4","4","meatin tai koa selus en usite onen asuv houlu mai visohiso keih min meatin keil vit, “Koanek vi mengkatien onen asuv houlu vat min kami vasi, meatin savsav keil koa miselus en selusien savsav keil. ");
INSERT INTO pma_vpl VALUES ("DN3_5","028_3_5","DAN","3","5","5","Navong miraengon amaru, eau, kitar, iukalele, ave, ka tounah sav keil emun amusel, kami vasi mihetetengeiril miheha netan min nana koanek koa vi gol koa asuv houlu Nebukanesa lingi mul ekok. ");
INSERT INTO pma_vpl VALUES ("DN3_6","028_3_6","DAN","3","6","6","Ka munak kami koa, mihertetengeiriltei ka mihervatei netan min nana enek, hatte tas, ikur kami ka ison kami miheha en mari oven tai koa ahang teni keih ramat.” ");
INSERT INTO pma_vpl VALUES ("DN3_7","028_3_7","DAN","3","7","7","Sakini, en hati avong enek koa meatin keil along tounah keil enek amusel, keil vasi aretengeiril ka uva netan min nana koa vi gol koa asuv houlu Nebukanesa vati lati. ");
INSERT INTO pma_vpl VALUES ("DN3_8","028_3_8","DAN","3","8","8","En avong enek, tei en koakeil ten out Babilon umai ven asuv houlu Nebukanesa keke avahiles tin vaha kat me-Isrel keil. ");
INSERT INTO pma_vpl VALUES ("DN3_9","028_3_9","DAN","3","9","9","Sakini, umai aselus mini avit, “O asuv houlu, isom va nesa vis va nesa mok, moulien onom hel lisenges. ");
INSERT INTO pma_vpl VALUES ("DN3_10","028_3_10","DAN","3","10","10","Keik, asuv houlu, komeng kati keke navong meatin keil vasi itaengon selien ten tounah keil ekek, koakeil vasi itetengeiril ka iha netan min nana koa vi gol. ");
INSERT INTO pma_vpl VALUES ("DN3_11","028_3_11","DAN","3","11","11","Ka koviteni mun keke munak keil koa arretengeiriltei ka arvatei netan min nana enek, hatte tas, ikur keil ka ison keil iha en mari oven tai koa ahang teni keih ramat. ");
INSERT INTO pma_vpl VALUES ("DN3_12","028_3_12","DAN","3","12","12","Ka tei en me-Isrel keil koa iseatel Sadrak, Misak ka Abednego, koa keik koling keitel tellosil kat provins ten out Babilon arlong kattei. Keitel varei tellong sesein mengkatien keil onom. Telrovatei netan min ahi onom keil ka telroretengeiriltei min nana koa keik kovati lati.” ");
INSERT INTO pma_vpl VALUES ("DN3_13","028_3_13","DAN","3","13","13","Navong asuv houlu longe mukok, tin vepeng houlu ka meng kat meatin keil onen avalamun keitel telvamai telvalomal en meten. ");
INSERT INTO pma_vpl VALUES ("DN3_14","028_3_14","DAN","3","14","14","Navong telmai, selus min keitel vit, “!Sadrak, Misek ka Abednego! ?Mukave? ?!Anatin keke kamitel emitel rovattei mitvaha netan min ahi onak keil ka mitroretengeiriltei min nana koa vi gol koa inau navat lati!? ");
INSERT INTO pma_vpl VALUES ("DN3_15","028_3_15","DAN","3","15","15","Kosa, navong mitraengon selien ten amaru, eau, kitar, iukalele, ave, ka tounah sav keil emun, kamitel vasi, munak mithetetengeiril mitheha netan min nana koa namumoni, hetahos min kamitel. Ka munak mithermumontei, hatte tas, ikur kamitel ka ison kamitel mitheha en mari oven tai koa ahang teni keih ramat. ?Ka munak umoni hemukonek min kamitel, mitmundemi keke ahi etai kilea voutut moulien onamitel ran hek? !Vuo, sakras!” ");
INSERT INTO pma_vpl VALUES ("DN3_16","028_3_16","DAN","3","16","16","Evus, Sadrak, Misak ka Abednego telvit kesi mini telvit, “O asuv houlu Nebukanesa, isom va nesa vis va nesa mok. Komeitel metsakras metvahiten etai tounah en usite onomaitel. ");
INSERT INTO pma_vpl VALUES ("DN3_17","028_3_17","DAN","3","17","17","Munak kison komeitel metheha en ahang ten oven, Ahi onomaitel koa metva netan mini kilea voutut komeitel ka helah lat komeitel ran hem. ");
INSERT INTO pma_vpl VALUES ("DN3_18","028_3_18","DAN","3","18","18","Ka avaseini munak Ahi onomaitel hermumontei hemukonek, emeitel vati keke keik, asuv houlu, kovailea keke metsakras metvaha netan min ahi onom keil vuo metvatetengeiril min nana koa vi gol koa kovati lati.” ");
INSERT INTO pma_vpl VALUES ("DN3_19","028_3_19","DAN","3","19","19","Navong Nebukanesa long selusien oneatel, tin vepeng houlu mok ka meten vilhili kat Sadrak, Misak ka Abednego. Sakini, kei meng kat meatin keil onen keke ison av hehi houlu tamun heha en oven koanek keke titin teni hekeih hehi oulu (7) muli titin teni koa mulamu. ");
INSERT INTO pma_vpl VALUES ("DN3_20","028_3_20","DAN","3","20","20","Ka meng kat tei en meatin keil tavaeen onen koa ave keih keke avapar kat keitel ka ison keitel telheha en oven koa ahang mul mukan keih vis keih imok eni. ");
INSERT INTO pma_vpl VALUES ("DN3_21","028_3_21","DAN","3","21","21","Hatte tas, alah keitel telmai, ka apar kat keitel. Ka telmusin veah en eisin omeatel. Evus, avous keitel keke avaha avason keitel telvaha en ahang. ");
INSERT INTO pma_vpl VALUES ("DN3_22","028_3_22","DAN","3","22","22","Ka navong meatin tavaeen keil enek ason keitel telva en ahang, titin teni rokol meatin tavaeen keil enek ka kan vini keil umat, veni mengkatien koa asuv houlu viteni keih imok, ka amumon ahang mukan mariso vis mariso mok. ");
INSERT INTO pma_vpl VALUES ("DN3_23","028_3_23","DAN","3","23","23","Ka Sadrak, Misak ka Abednego telmot telva en oven koa ahang mul mukan neim eni, ka viau mul kat keitel veah. ");
INSERT INTO pma_vpl VALUES ("DN3_24","028_3_24","DAN","3","24","24","Ka navong asuv houlu Nebukanesa lele vales keitel, kei mutimanin, mulomal ka vis meatin onen keil vit, “?!Ei mukave!? Namundemi navit mipar kat meatin heite etel (3) enges ka mison keitel telva en ahang.” Ka avit kesi mini avit, “Asuv houlu, anatin, etel (3) enges.” ");
INSERT INTO pma_vpl VALUES ("DN3_25","028_3_25","DAN","3","25","25","Sakini asuv houlu vit, “?Ka vensa nales meatin ehat (4) amul amual luhu en ahang koanek? Nalesi keke viau tovuol en keitel ka ahang rokantei keitel. Ka koa ehat en keitel, nalesi keke aven vihil suval angelo tai.” ");
INSERT INTO pma_vpl VALUES ("DN3_26","028_3_26","DAN","3","26","26","Sakini Nebukanesa mual va vesesal en voiteh ten oven ka vise keil vit, “!Sadrak, Misak, ka Abednego, meatin keitel onen Ahi anatin, telmea telmai hae!” Sakini, telmea telkistal ran ahang. ");
INSERT INTO pma_vpl VALUES ("DN3_27","028_3_27","DAN","3","27","27","Ka navong minista keil, avat ten provins keil, koakeil amum suval eria sekreteri, ral min koakeil avit lat sise min asuv houlu ales asa koa kur out, umai vesesal ven keitel. Ka alesi keke ahang ropuruntei keitel varei. Anatin, ahang rokantei hileatel, vuo eisin omeatel, ka armustei vi eas ten ahang en keitel. ");
INSERT INTO pma_vpl VALUES ("DN3_28","028_3_28","DAN","3","28","28","Ka en meten meatin keil enek, asuv houlu viteni vit, “Rehehati lat isen Ahi onen Sadrak, Misek ka Abednego. Veni kei san angelo onen mai kur koe keitel ka mutut moulien oneatel koa telmum mini ka telling desien oneatel eni. Keitel tellong sesein mengkatien onak ka telmae koteh moulien oneatel keke telhervatei netan min ahi sav keil koa arvitei Ahi kati oneatel. ");
INSERT INTO pma_vpl VALUES ("DN3_29","028_3_29","DAN","3","29","29","“Sakini, nameng kat selusien koanek: “Munak etai en meatin keil iselus karen Ahi onen Sadrak, Misek ka Abednego, meatin onak keil itali vahas ave ka u rasilin teim se. Anatin, umoni hemukonek min keil, avaseini aka en vangi meatin sa vuo aselus en selusien sa. Veni ahi sav tovuol koa kilea voutut moulien onen meatin keil onen vamukonek.” ");
INSERT INTO pma_vpl VALUES ("DN3_30","028_3_30","DAN","3","30","30","Evus, asuv houlu vati lat ris Sadrak, Misek ka Abednego telvamai telvakur umen koa hetetamen imok valin koa telkuri mulamu en provins ten out Babilon. ");
INSERT INTO pma_vpl VALUES ("DN4_1","028_4_1","DAN","4","1","1","Asuv houlu Nebukanesa san tisien koanek va min meatin savsav keil onen koa aselus en selusien savsav keil koa amul en kantri vasi keil koa kei losil kati. Tisien enek vit: Amas ka tomat hel en kami. ");
INSERT INTO pma_vpl VALUES ("DN4_2","028_4_2","DAN","4","2","2","Mihetaengon asa koa ek vati mahiteni usil merikel keil ka tounah sav keil koa amariso koa Ahi ten Keihoen rie lati minau. ");
INSERT INTO pma_vpl VALUES ("DN4_3","028_4_3","DAN","4","3","3","Merikel keil koa Ahi rie lati minau tahos imok. Kei rie lat keihoen onen kistal en mari sakien keil koa mul mumoni. Losilkatien onen sakras vavus, ka keihoen hel en hen lisenges. ");
INSERT INTO pma_vpl VALUES ("DN4_4","028_4_4","DAN","4","4","4","Mulamu, inau, Nebukanesa, naro en mari teim sak. Nalonge tahos vis tahos imok, ka nales tahosien lises en moulien onak. ");
INSERT INTO pma_vpl VALUES ("DN4_5","028_4_5","DAN","4","5","5","Evus, en vongien tai, nales matil vovoien tai koa sakinau nametau houlu. Anatin, nales matil vovoien koa sakinau namaleilei houlu. ");
INSERT INTO pma_vpl VALUES ("DN4_6","028_4_6","DAN","4","6","6","Sakini, navise ruain hetetamen keil vasi onak ten out Babilon avamai avahit kilea aneite ten matil vovoien onak minau. ");
INSERT INTO pma_vpl VALUES ("DN4_7","028_4_7","DAN","4","7","7","Navong koakeil alei kilea en sise, eimas keil, lingling temat keil, ka koakeil alei kilea asa hekur out ka en hitu keil umai venau, navit lat matil vovoien onak min keil. Ka keil asakras avahit luvat aneite teni minau. ");
INSERT INTO pma_vpl VALUES ("DN4_8","028_4_8","DAN","4","8","8","Ka koa vi ekor en meatin keil enek mai venau, isen Daniel (koa avise mun en Beltesasar koa suval isen ahi onak). Meatin koanek, ninin onen ahi koa vi votut vilelau eni. Sakini, navit lat matil vovoien onak mini. ");
INSERT INTO pma_vpl VALUES ("DN4_19","028_4_19","DAN","4","19","19","Ka navong Daniel Beltesasar long usili ka rendem kilea aneite teni, en von ka sakras vaselus veni rendemien onen muasi. Sakini naviteni mini navit, “Beltesasar, konamaentei matil vovoien onak ka aneite teni noumonuk konametau.” Sakini Beltesasar viteni minau vit, “O asuv houlu, isom va nesa vis va nesa mok. Ek vati mok keke matil vovoien koanek ka aneite teni hemai hehi anatin en vativieh keil onom, ka hervitei keik. ");
INSERT INTO pma_vpl VALUES ("DN4_20","028_4_20","DAN","4","20","20","Vatiai koa kolesi en matil vovoien onom, aneite teni mul. Kei moul mai mariso ka keih. Kei taveah vina rokol teilang ka meatin vasi keil ten out netan akilea avalesi. ");
INSERT INTO pma_vpl VALUES ("DN4_21","028_4_21","DAN","4","21","21","Oute keil tahos vis tahos imok, ka heite teni vinvin vahengan tounah vasi keil ten out netan. Nimal teni vi out tasehien onen tirendan keil ka aman keil keke umai amumon anu ome en angoite keil. ");
INSERT INTO pma_vpl VALUES ("DN4_22","028_4_22","DAN","4","22","22","O asuv houlu, keik varei, kovi vatiai enek. Keik komai kovi mari hetamen ka keihoen onom marite. Anatin, keihoen onom va nesa ka losilkatien onom va rokol usite vasi keil ten out netan. ");
INSERT INTO pma_vpl VALUES ("DN4_23","028_4_23","DAN","4","23","23","“Avong komul semau koles matil vovoien koanek, angelo tai ka en out nesa mita en out netan ka viteni vit, ‘Ta lat vatiai koanek vaha netan ka kita vuol eni. Ka kiling vatte ka lite keil teni heles en atan. Hevus, kitoh kati hekeih en stirap keil koa avi aean ka brons. Evus, kilingi heles en mesaiuai, out koa oumunai mul moul ien. Vatiai enek vi tatavolien tai usil meatin tai. Kei heha heto hetal min tirendan keil ka tilep hekasi sua hehi oulu (7).’ ");
INSERT INTO pma_vpl VALUES ("DN4_24","028_4_24","DAN","4","24","24","“O asuv houlu koa isom vina nesa vis vina nesa mok, aneite ten matil vovoien koa Ahi ten Keihoen meng kati minuk hekistal hemukok: ");
INSERT INTO pma_vpl VALUES ("DN4_25","028_4_25","DAN","4","25","25","meatin keil ilikatuk kiha kilokovein out koa komul ien ekek kiha kito hetal min tirendan keil ten eivorohus. Sua oulu (7), keik kian oumunai hesuval buluk, kimatil en mesaiuai ka tilep hekasuk. Keik kito hemukonek hetokol avong kimai kindem kilea suk keke losilkatien ten kantri vasi keil ten out netan mul enges en hen Ahi ten Keihoen. Ka kei kilea hesani min meatin sa koa kei en vati vasani mini. ");
INSERT INTO pma_vpl VALUES ("DN4_26","028_4_26","DAN","4","26","26","“Navong angelo meng kati keke aling vatte ka lite keil amules en atan, koakeilu enek, aneite teni mul. Losilkatien ten kantri onom, hemai ris venuk en avong koa kindem kilea suk keke losilkatien ten kantri vasi keil ten out netan mul enges en hen Ahi ten out nesa. ");
INSERT INTO pma_vpl VALUES ("DN4_27","028_4_27","DAN","4","27","27","Sakini, asuv houlu, tahos imok munak keik kusil kat rendemien onak eli. Kihiles ran tisaen keil onom ka kumon sakien keil koa mal. Kilokovein sakkalkalien keil onom ka kilei kat revi koakeil meatin sav keil amul apurun keil. Munak kumon sakien keil koa hemukonek, vahesa Ahi hesan veah tahosien en moulien onom.” ");
INSERT INTO pma_vpl VALUES ("DN4_28","028_4_28","DAN","4","28","28","Ka tounah vasi keil enek kistal mai vi anatin enau, koa navi asuv houlu Nebukanesa. ");
INSERT INTO pma_vpl VALUES ("DN4_29","028_4_29","DAN","4","29","29","Avati teindan elu (12) mai muli, ka inau naros teim en out Babilon. Ka en avong tai, namul namual rahit teim sak, nesa en out tai koa vi aet. ");
INSERT INTO pma_vpl VALUES ("DN4_30","028_4_30","DAN","4","30","30","Ka navong nales mari taon onak ten out Babilon, inau naselus sasok enges navit, “Ei … telmali. Nalesi keke taon onak tahos vis tahos imok. Ral min keihoen onak enges namumoni mai vi vuluk kati vatie lati keke inau navi hetetamen imok ka keihoen onak vina nesa vis vina nesa mok.” ");
INSERT INTO pma_vpl VALUES ("DN4_31","028_4_31","DAN","4","31","31","Navong namules veah naselus, rea tai ka en out nesa ka selus minau vit, “!Asuv houlu Nebukanesa, kitaengonau! Koanek vi asa koa Ahi meng kati keke vakistal en moulien onom. Losilkatien koa mul en hem, Ahi kulati tuai ranuk. ");
INSERT INTO pma_vpl VALUES ("DN4_32","028_4_32","DAN","4","32","32","En hati avong enesek, meatin keil ilikatuk kilokovein out koa koro ien, ka kiha kito nges hetal min tirendan keil en mesaiuai. Sua hehi oulu (7), kian oumunai hesuval buluk keil enges. Keik kitos hemukonek hetokol avong koa keik kindem kilea suk keke losilkatien ten kantri vasi keil ten out netan mul enges en hen Ahi ten Keihoen, ka kei kilea vasani min meatin sa koa kei en vati vasani mini.” ");
INSERT INTO pma_vpl VALUES ("DN4_33","028_4_33","DAN","4","33","33","Hatte tas, selusien keil enek mai kistal vi anatin enau, koa navi asuv houlu Nebukanesa. Meatin keil alikat nau nalokovein keil ka nuva naro sasok enges. Nakan oumunai suval buluk ka tilep kas avek. Hiluk moul tetaveah suval asupoten tomeahos, ka uti hek moul tetaveah suval uti alen veivakum enges. ");
INSERT INTO pma_vpl VALUES ("DN4_34","028_4_34","DAN","4","34","34","Navong sua oulu (7) mai muli, inau, asuv houlu Nebukanesa, naseipat vina en teilang ka rendemien onak mai ris tahos. Evus, navati lat isen Ahi ten Keihoen ka navouhou mini veni kei vi hetetamen imok ka mul lisenges, ka navit, “Losilkatien onen Ahi ten Keihoen sakras vavus en avong etai. Keihoen mules en hen lisenges. ");
INSERT INTO pma_vpl VALUES ("DN4_35","028_4_35","DAN","4","35","35","En lesien onen, meatin keil ten out netan avi heisav enges, ka kei mum musil rendemien onen ral min angelo keil ten out nesa ka meatin keil ten out netan. Meatin tovuol vating koe asa koa kei en vati voumoni, vuo vahisi vahit, ‘?Vensa komumoni mukonek?’” ");
INSERT INTO pma_vpl VALUES ("DN4_36","028_4_36","DAN","4","36","36","Navong naviteni mukonek, rendemien onak maluv mai ris tahos. Evus, hetetamen keil onak alei katnau ka akur revi nau. Keil avouhou minau mulin koa amumoni mulamu, ka asan ris losilkatien ten kantri onak mai ris en hek. ");
INSERT INTO pma_vpl VALUES ("DN4_37","028_4_37","DAN","4","37","37","Sakini, kosa, inau, asuv houlu Nebukanesa, namul nasan masmasien ka houhouen min Ahi koa vi Asuv Houlu ten out nesa ka navati lat Isen. Tounah vasi koa kei mumoni mal revi, ka kei kilea voumon rendemien onen koakeil avut keil vaha netan. Nebukanesa losil kat meatin keil onen sua vahis emun. Evus, mat, ka asuv houlu sav keil umai akur vulin, tai evus, tamun. Ka sua hanumau tai ka elim emun (25) mai mulin matien onen, ka asuv houlu tamun mai losil kat me-Babilon keil, isen Belsesar. ");
INSERT INTO pma_vpl VALUES ("DN5_1","028_5_1","DAN","5","1","1","En avong tai, asuv houlu hau tai koa isen Belsesar, kei mumon mari ale tai ka sisil en avat keil taosen tai (1000) onen me-Babilon keil keke avamai. Ka navong umai alah ruai, asuv houlu enek mul munmun ral min keil. ");
INSERT INTO pma_vpl VALUES ("DN5_2","028_5_2","DAN","5","2","2","Navong amul amunmun, uaen muas asuv houlu Belsesar ka meng kat tei en meatin keil onen keke avaha avalah vanikin ka pesin keil koa amumoni en gol ka silva, veni en vati vamunmun en kap keil enek vatal min avat keil, ahin kati keil onen, ka ahin savsav keil onen. Tounah tetahos keil enek, tata onen koa vi asuv houlu Nebukanesa lah lati ran Eim Votut onen Ahi en out Serusalem. ");
INSERT INTO pma_vpl VALUES ("DN5_3","028_5_3","DAN","5","3","3","Rovitei tuetin, alah vanikin ka pesin koa amumoni en gol ka silva umai. Ka keil vasi amunmun eni. ");
INSERT INTO pma_vpl VALUES ("DN5_4","028_5_4","DAN","5","4","4","Ka navong amules veah amunmun, asan masmasien va min ahi keil one koa avi nana enges koa amumoni en gol, silva, brons, aean, ahat ka ai. ");
INSERT INTO pma_vpl VALUES ("DN5_5","028_5_5","DAN","5","5","5","Hatte tas, hen meatin tai mai kistal ka mutis selusien tai luhu en vali eim omon asuv houlu. Navong ahe enek mul mutis, asuv houlu Belsesar les vareini veni out enek muto ka laet mul ritin eni. ");
INSERT INTO pma_vpl VALUES ("DN5_6","028_5_6","DAN","5","6","6","Ka navong lesi, kei metau houlu, aven mai memerau ka alen maleilei. ");
INSERT INTO pma_vpl VALUES ("DN5_7","028_5_7","DAN","5","7","7","Sakini, vise kekerat meatin tai onen vaha valah koakeil alei kilea en sise, eimas keil, koakeil alei kilea asa hekur out ka en hitu, ka lingling temat keil emun umai veni. Navong meatin keil enek umai veni, asuv houlu viteni min keil vit, “Munak etai en kami kilea vahuli revi tisien ekek ka vahit luvat aneite teni minau, inau nisin en kei en mormore eisin tai hesuval koa asuv houlu keil enges amul amusin eni. Hevus, nuani en sen ten houhouen tai koa vi gol en hiren. Hevus, numoni hemai hehi hetetamen imok helin meatin savsav keil vasi en kantri onak. Inau nges komal mama onak melhehi houlu melhelin kei.” ");
INSERT INTO pma_vpl VALUES ("DN5_8","028_5_8","DAN","5","8","8","Ka navong keil umai ales tisien enek, asakras avahuli vuo avahit luvat aneite ten selusien teni. ");
INSERT INTO pma_vpl VALUES ("DN5_9","028_5_9","DAN","5","9","9","Navong asuv houlu Belsesar raengoni, kei metau houlu ka aven mai memerau. Ka avat keil onen emun areingeingeni umon sa. ");
INSERT INTO pma_vpl VALUES ("DN5_13","028_5_13","DAN","5","13","13","Evus, amulamun Daniel mai ven asuv houlu Belsesar. Ka asuv houlu viteni mini vit, “?Anatin keke keik kovi Daniel, koa tata onak, Nebukanesa, kulatuk ran kantri ten out Sudah keke komai koro en out ekok? ");
INSERT INTO pma_vpl VALUES ("DN5_14","028_5_14","DAN","5","14","14","Naraengoni keke ninin onen ahi savsav keil asienuk ka ileilien ka meteisauen mul enuk ka kolei kilea en sise ten tounah vasi. ");
INSERT INTO pma_vpl VALUES ("DN5_15","028_5_15","DAN","5","15","15","Meatin keil enek, koakeil avi meteisau ka koakeil emun avi lingling temat, inau nasisil en keil umai avuli tisien ekek, ka keil asakras avahit luvat aneite teni minau. ");
INSERT INTO pma_vpl VALUES ("DN5_16","028_5_16","DAN","5","16","16","Ka nalonge keke keik kokilea kovahit luvat aneite ten tounah keil koa aro suai ka kovahit kilea tounah koa keih. Munak keik kihuli tisien enek ka kihit luvat aneite teni minau, nisin en keik en mormore eisin tai hesuval koa asuv houlu keil enges amul amusin eni. Hevus, nuanuk en sen ten houhouen tai en hirem koa vi gol. Hevus, numonuk kimai kihi hetetamen imok helin meatin savsav keil vasi en kantri onak. Inau nges komal mama onak melhehi houlu melhelin keik.” ");
INSERT INTO pma_vpl VALUES ("DN5_17","028_5_17","DAN","5","17","17","Sakini, Daniel vit kesi mini vit, “Asuv houlu onak, kihuli kat sanien keil enek hehi onom, vuo kisani min etai meatin sav. Ka avaseini, inau nihuli tisien koanek minuk ka nihit luvat aneite teni minuk. ");
INSERT INTO pma_vpl VALUES ("DN5_18","028_5_18","DAN","5","18","18","“O asuv houlu kitaengon revi, Ahi Asuv ten out nesa mumon tata onom, Nebukanesa, mai vi asuv houlu tai koa vi hetetamen imok ka san houhouen ka keihoen mini. ");
INSERT INTO pma_vpl VALUES ("DN5_19","028_5_19","DAN","5","19","19","Ka ven keihoen koa Ahi sani mini, meatin keil vasi ten out netan koa aka en kantri vasi keil, vati meatin savsav keil koa aselus en selusien vasi keil, keil vasi ametauni ka amaleilei en meten. Navong tata onom vit vou vini meatin tai vamat, muasi varei. Ka navong vit vamaen meatin vamoul, maenis moul. Kei san houhouen min koakeil en vati vahouhou min keil, ka koakeil en vat keil avamemou, kei mumonis. ");
INSERT INTO pma_vpl VALUES ("DN5_20","028_5_20","DAN","5","20","20","“Ka veni kei vati lat kei sasen enges en rendemien onen ka mum tisa min meatin sav keil veni kei mul vuvuti, Ahi so lati ran vulin ten keihoen onen ka kulat isen ten houhouen rani. ");
INSERT INTO pma_vpl VALUES ("DN5_21","028_5_21","DAN","5","21","21","Alikati va lokovein meatin keil, ka rendemien onen mai suval tirendan tai enges. Kei va ro ral min dongki rendan keil, ka kan oumunai suval buluk tai. Kei matil en mesaiuai ka tilep kasi. Ros mukonek rokol avong koa rendem kilea suk keke Ahi ten Keihoen enges mul losil kat tounah vasi en out netan ka kilea vatie lat meatin sa koa kei en vati vasan losilkatien teni mini. ");
INSERT INTO pma_vpl VALUES ("DN5_22","028_5_22","DAN","5","22","22","“Ka keik, o Belsesar, koa kovi natnali, avaseini kokilea revi en tounah keil enek, kormumontei rendemien onom vaha netan. ");
INSERT INTO pma_vpl VALUES ("DN5_23","028_5_23","DAN","5","23","23","Keik kovati lat sasom enuk enges kovit kovahi nesa mok valin Ahi ten out nesa. Keik kolah vanikin ka pesin keil koa alahi ran Eim Votut onen Ahi keke kami vasi mimunmun eni: keik, avat onom keil, ahin kati keil onom, ral min ahin savsav keil onom emun. Ka navong mimumoni mukonek, misan masmasien vat min ahi keil onami koa avi nana keil enges koa amumoni en gol, silva, brons, aean, ahat ka ai. Ahi keil enek avi ahi kuren keil enges koa asakras avalele, asakras avalonglong, ka asakras availea etai tounah. Ka keik, korvouhoutei min Ahi koa moulien ka ualien onom mules en hen. ");
INSERT INTO pma_vpl VALUES ("DN5_24","028_5_24","DAN","5","24","24","“Veni komumoni mukonek, Ahi san hen meatin enek vamai vatis selusien enek. ");
INSERT INTO pma_vpl VALUES ("DN5_25","028_5_25","DAN","5","25","25","Tisien koanek, selusien teni mukok: MENE, MENE, TEKEL, PERES ");
INSERT INTO pma_vpl VALUES ("DN5_26","028_5_26","DAN","5","26","26","“Ka aneite teni mukok: MENE – aneite teni vi ‘hulien.’ Ahi vuli lat avong keil ten losilkatien onom, ka sakini mai rokol keite teni. ");
INSERT INTO pma_vpl VALUES ("DN5_27","028_5_27","DAN","5","27","27","TEKEL – aneite teni vi ‘sikel.’ Kei sikel enuk ka votini keke korvinvintei en meten. ");
INSERT INTO pma_vpl VALUES ("DN5_28","028_5_28","DAN","5","28","28","PERES – aneite teni vi ‘riti vasi.’ Ahi riti vas losilkatien onom ka sani suk min me-Mid keil ka me-Persia keil.” ");
INSERT INTO pma_vpl VALUES ("DN5_29","028_5_29","DAN","5","29","29","Navong Daniel selus evus, asuv houlu Belsesar meng kat meatin toumien keil onen umai. Keil amusin en Daniel en mormore eisin tai suval koa asuv houlu keil enges amul amusin eni. Evus, amuani en sen ten houhouen tai en hiren koa vi gol. Evus, asan longlongien ka vasi out keke Daniel, amumoni mai vi hetetamen imok helin meatin savsav keil vasi en kantri ten out Babilon. Asuv houlu keilu mama onen enges luvi houlu lohlin kei. ");
INSERT INTO pma_vpl VALUES ("DN5_30","028_5_30","DAN","5","30","30","Ka en hati vongien enek, tei en meatin keil umai suai ka amu vini asuv houlu Belsesar ten out Babilon. ");
INSERT INTO pma_vpl VALUES ("DN5_31","028_5_31","DAN","5","31","31","Evus, Derias ten out Mid kur vulin mai losil kat kantri onen. Sua onen Derias vi hanumau etel ka elu mun (62) navong mai vi asuv houlu. ");
INSERT INTO pma_vpl VALUES ("DN6_1","028_6_1","DAN","6","1","1","Navong Derias mai vi asuv houlu, kei rie lat minista keil onen avi handred tai ka hanumau tai emun (120) keke avalosil kat out vasi koa mul en hen. ");
INSERT INTO pma_vpl VALUES ("DN6_2","028_6_2","DAN","6","2","2","Evus, rie lat Daniel ral min meatin elu mun keke avamai avahi avat keitel onen minista keil enek avoum en usite onen asuv houlu Derias ka avalosil kat revi tounah vasi keil onen vasakini varmundemkotei ven etai tounah. ");
INSERT INTO pma_vpl VALUES ("DN6_3","028_6_3","DAN","6","3","3","Rovitei tuetin, asuv houlu lesi keke umen onen Daniel tahos imok mulin umen onen avat sav keilu ka onen minista sav keil emun veni ninin tetahos mul ien. Sakini, asuv houlu Derias mundemi keke tahos heling Daniel helosil kat tounah vasi koa mul en hen. ");
INSERT INTO pma_vpl VALUES ("DN6_4","028_6_4","DAN","6","4","4","Sakini, avat sav keilu ka minista sav keil emun avi elu kati. Keil asak avahotin tounah koa Daniel voumoni vatisa, ka asakras veni umen vasi keil onen Daniel tahos ka romumon etai tounah vatisa. ");
INSERT INTO pma_vpl VALUES ("DN6_5","028_6_5","DAN","6","5","5","Evus, en avong tai, hetetamen keil enek aviteni min keil eris avit, “Ir rosakras rovahotin etai tounah koa Daniel voumoni vatisa. Ka vahesa rehehotin tounah tai koa rokilea rovahuli kati en usite ten mengkatien keil onen Ahi koa kei mul va netan mini.” ");
INSERT INTO pma_vpl VALUES ("DN6_6","028_6_6","DAN","6","6","6","Sakini, uva ales asuv houlu ka aviteni mini avit, “O asuv houlu Derias, isom vina nesa vis vina nesa mok, moulien onom hetaveah. ");
INSERT INTO pma_vpl VALUES ("DN6_7","028_6_7","DAN","6","7","7","Komai vasi koa korie lat komai memum suval hetetamen keil onom, memai en rendemien tas. Memundemi mevit tahos imok munak keik, asuv houlu, kumon mengkatien tai koa vit meatin keil vasi iha netan ka ihis minuk enges avong hanumau tai ka halualim emun (30). Ka munak meatin etai heha netan vuo hehis min ahi sav tai, ison meatin enek heha en vulvul omon laeon keil. ");
INSERT INTO pma_vpl VALUES ("DN6_8","028_6_8","DAN","6","8","8","O asuv houlu, munak kimaeni, mevisuk keke kitis rendemien koanek hemai hehi mengkatien tai ka kitis isom hel ien. Hesakini, musil sakien ten mengkatien keil orer ten out Mid ka Persia, meatin hetovuol hehilesi vuo hekulati.” ");
INSERT INTO pma_vpl VALUES ("DN6_9","028_6_9","DAN","6","9","9","Sakini asuv houlu Derias maen keil amutis lat mengkatien koanek ka kei ling isen mul ien. ");
INSERT INTO pma_vpl VALUES ("DN6_10","028_6_10","DAN","6","10","10","Ka Daniel, avaseini keke kei raengon longlongien usil mengkatien koanek, mules musil sakien ten hisien va min Ahi onen. Anatin, en out tai nesa en teim sen, vesesal en windo tai koa mul en usite koa viles va en out Serusalem, kei mul vis ka mul masmas Ahi hatte etel (3) en avong vasi keil, musil sakien koa mumoni tuetin tuai. ");
INSERT INTO pma_vpl VALUES ("DN6_11","028_6_11","DAN","6","11","11","Avong tai, vativieh keil onen Daniel umai akistal veni ka avotini keke Daniel mul vis min Ahi onen ven kataunien. ");
INSERT INTO pma_vpl VALUES ("DN6_12","028_6_12","DAN","6","12","12","Sakini, keil vasi uva ris ven asuv houlu ka avis usil mengkatien onen avit, “!O asuv houlu! ?Vi anatin keke keik komutis isom mul en mengkatien tai koa vit meatin keil ihis minuk enges avong hanumau tai ka halualim emun (30)? Ka musil mengkatien onom, meatin koa mul vis min ahi sav tai vuo meatin sav tai en avong keil enek, isoni heha en vulvul omon laeon keil.” Ka asuv houlu vit kesi min keil vit, “!Anatin! Mengkatien koanek mul ka asakras avahilesi musil sakien ten mengkatien keil onen me-Mid keil ka me-Persia keil.” ");
INSERT INTO pma_vpl VALUES ("DN6_13","028_6_13","DAN","6","13","13","Ka keil avit usil Daniel mini avit, “Daniel, koa akulati ran out Sudah, kei mundem maenuk, asuv houlu, ka kei romusil kattei mengkatien onom koa komutis isom mul ien. Kei mules musil sakien ten hisien va min ahi onen hatte etel (3) en avong vasi keil.” ");
INSERT INTO pma_vpl VALUES ("DN6_14","028_6_14","DAN","6","14","14","Navong asuv houlu raengon selusien one, mundemko houlu. Sakini, mul lei kat etai sise vakataun Daniel eni. Mul sak visi va vio … meteiai munu. ");
INSERT INTO pma_vpl VALUES ("DN6_15","028_6_15","DAN","6","15","15","Evus, vativieh keil onen Daniel umai ris ven asuv houlu ka aviteni mini avit, “O asuv houlu, kokilea tuai keke, musil sakien ten mengkatien onen me-Mid keil ka me-Persia keil, meatin hetovuol hehiles mengkatien tai koa asuv houlu lingi mul.” ");
INSERT INTO pma_vpl VALUES ("DN6_16","028_6_16","DAN","6","16","16","Sakini, asuv houlu meng kati keke avalamun Daniel vamai. Evus, asoni vita en vulvul omon laeon keil. Ka asuv houlu viteni min Daniel vit, “Navisi keke Ahi onom, koa kova netan mini lises, hemai houtut moulien onom.” ");
INSERT INTO pma_vpl VALUES ("DN6_17","028_6_17","DAN","6","17","17","Evus, avous mari ahat tai ka aring koe metareh ten vulvul koanek eni. Evus, aling tanhili pil rahit ahat enek. Ka navong tanhili mul semau mermer, asuv houlu ral min hetetamen sav keil onen amumon metai keil ien ral min ring ten hetetamenien keil one koa ise mul ien. Sakien koanek rie lati keke meatin hetovuol hekulat Daniel ran vulvul enek. ");
INSERT INTO pma_vpl VALUES ("DN6_18","028_6_18","DAN","6","18","18","Navong asuv houlu muris va teim sen, en rovattei vaanian ka en rovattei mun meatin sav tai vahati lat rendemien onen. Ka en vongien enek, kei sakras vamatil. ");
INSERT INTO pma_vpl VALUES ("DN6_19","028_6_19","DAN","6","19","19","En visokon semau, asuv houlu mea ka kalah va en vulvul omon laeon keil enek. ");
INSERT INTO pma_vpl VALUES ("DN6_20","028_6_20","DAN","6","20","20","Navong mai vesesal ven vulvul enek, viso ral min demkoen vit, “?Daniel, meatin toumien onen Ahi koa moul, komoul veah? ?Ahi onom koa kuva netan mini lises, keihoen onen vinvin vakur koek ran laeon keil?” ");
INSERT INTO pma_vpl VALUES ("DN6_21","028_6_21","DAN","6","21","21","Ka ren Daniel ka en vulvul enek vit, “O asuv houlu, moulien onom hetaveah. ");
INSERT INTO pma_vpl VALUES ("DN6_22","028_6_22","DAN","6","22","22","Ahi onak sila angelo tai mai mumon ongon laeon keil katiloh. Sakini, keil arkat vinitei nau veni en lesien onen Ahi, inau namutolas en meten. Ka asuv houlu, inau narmumon etai tounah vatisa minuk.” ");
INSERT INTO pma_vpl VALUES ("DN6_23","028_6_23","DAN","6","23","23","Navong asuv houlu raengon ren Daniel, kei si houlu veni ka meng kati keke ileh lati ran vulvul enek. Ka navong aleh lati mah nesa, alesi keke tounah tovuol varei vasut kei veni ling desien onen en Ahi onen. ");
INSERT INTO pma_vpl VALUES ("DN6_24","028_6_24","DAN","6","24","24","Evus, asuv houlu meng kati keke koakeil vasi aselus tisa va kat Daniel, ihuli kat keil. Ka navong avuli kat keil evus, ason keil ral min ahin keil one ka titae keil emun uva en vulvul omon laeon keil. Ka navong arokoltei mau out netan, laeon keil uvut kat keil ka akat vulvul si. ");
INSERT INTO pma_vpl VALUES ("DN6_25","028_6_25","DAN","6","25","25","Evus, asuv houlu Derias mutis selusien koanek ka sani min vati meatin savsav keil koa aselus en selusien savsav keil karahit kantri vasi keil ten out netan. Ka tisien onen viteni vit: “Amas ka tomat hel en moulien onami. ");
INSERT INTO pma_vpl VALUES ("DN6_26","028_6_26","DAN","6","26","26","“Inau nameng kat meatin keil ten kantri vasi koa namul nalosil kati keke ihouhou min Ahi onen Daniel ka imetauni. Veni kei vi Ahi koa moul ka mul lises ka lisenges. Meatin hetovuol hepurun losilkatien onen, ka kei hehi Asuv Houlu onen meatin vasi keil heha vio … hervustei. ");
INSERT INTO pma_vpl VALUES ("DN6_27","028_6_27","DAN","6","27","27","Kei mul kataun meatin keil ka mutut moulien keil one. Kei mumon merikel keil ka marmari tounah sav keil emun en out netan ka en teilang emun. Kei varei mutut moulien onen Daniel ran keihoen onen laeon keil.” ");
INSERT INTO pma_vpl VALUES ("DN6_28","028_6_28","DAN","6","28","28","Sakini Daniel moul ka les tahosien en avong keil koa Derias vi asuv houlu, ka avong keil emun koa Saeros ten out Persia mai vi asuv houlu. ");
INSERT INTO pma_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","En atan ten out Isrel, provet tai mul ien, isen Siona, natin Amitai. En avong tai, Iahova san selusien tai mini vit, ");
INSERT INTO pma_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","“Kikalah kiha en mari taon ten out Nineva, ka kisel kat meatin keil koa aro ekonek. Kihiteni min keil keke sakien keil one vilehilu en metok.” ");
INSERT INTO pma_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Ka Siona, en rovattei vasan selusien onen Iahova min me-Nineva keil koa amul en kantri tai en usite va ist. Sakini, viles, va wes en sise sav keke valohosai rani. Siona va rokol pasis en taon ten out Sopa, ka votin sip tai koa amul asak meseini vaha en out Spen, kantri tai koa mul soutin imok en usite va wes. Sakini, vul sise onen ka vut va en sip ral min boskru keil teni. Evus, sip enek muloh vaha en out Spen ral min Siona koa mul lohosai ran Iahova. ");
INSERT INTO pma_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Navong sip enek mul muloh eva, Iahova sakin mari eang tai muhuh keih ka atas emun tisa vis tisa, ka sip koanik vesesal vamahoiahoi. ");
INSERT INTO pma_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Boskru keil ametau houlu, ka retai en keil amis kai va min ahi keil one keke avasan kataunien min keil. Evus, alah lat tounah keil ran valengei sip ka asoni va en atas vasakin sip vamelala. Avong tounah keil enek mul kur out, Siona mules matil en valengei sip. ");
INSERT INTO pma_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Ka navong vatihos ten sip va neim, kei votin Siona ka viteni mini vit, “!Ei! ?Vensa komul komatil mukok? !Mea ka kihis min ahi onom ven kataunien! Vahesa kei en hemahis ir ka houtut moulien keil orer.” ");
INSERT INTO pma_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Evus, boskru keil alah ruai ka aling revi rendemien keke avaleh eis keke avahotin isei en keil mul lehen an tisa mai kat keil. Ka navong amumoni, aleh isen Siona. ");
INSERT INTO pma_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Sakini avisi avit, “?Ei, hiteni min komai, komumon sa koa sakin an tisa ekek mai muas ir? ?Umen sa varei komumoni? ?Kantri sa varei koka ien ka meatin onom keil avi meatin sa?” ");
INSERT INTO pma_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Ka Siona vit kesi min keil vit, “Inau navi koan Isrel ka namul nuva netan min Iahova, Ahi ten out nesa koa mumon out netan ka atas emun.” ");
INSERT INTO pma_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Siona vit lati min keil keke mul lohosai ran Iahova. Navong boskru keil alonge mukok, ametau houlu ka avul kati avit, “?Vensa varei komumon tisaen enek?” ");
INSERT INTO pma_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Ka navong alesi keke mari eang koanek muhuh keih imok, avis Siona avit, “?Kihiteni min komai, mehoumon sa vasakin mari eang koanek vaha netan?” ");
INSERT INTO pma_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Sakini, Siona vit kesi mini keil vit, “Mihou lat inau ka miheson nau niha en atas. En avong koa mihoumoni, atas hemai ris hetahos. Nakilea keke mari eang koanek mul muas kami venau varei.” ");
INSERT INTO pma_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Ka boskru keil e rovattei avason Siona vaha en atas. Sakini asak visi avahalis en sip enek vaha ut, ka asakras veni tahe keil umai amariso mok ka eang muhuh keih tamun. ");
INSERT INTO pma_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Sakini apeah Iahova avit, “O Iahova, mevisuk eli keke konasantei mahien min komai ven matien onen meatin koanik. Anatin, konouastei komai li veni keik, Iahova, komumon tounah keil enek mai kistal musil rendemien onom etin.” ");
INSERT INTO pma_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Evus, avou lat Siona ka asoni va en atas. Hatte tas, atas mai tahos eris. ");
INSERT INTO pma_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Navong boskru keil enek ales asa koa kur out, keil vasi avouhou min Iahova marite mok. Sakini, keil asan sanien votut keil one mini keke avamasmasi ka retai en keil amumon hatkatien keil one ral mini. ");
INSERT INTO pma_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Ka Siona romattei. Iahova san mari mesau tai emai remi ka Siona moul mules en vangen mesau enek avong etel. ");
INSERT INTO pma_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Navong Siona mul en vangen mesau enek, vis min Iahova, Ahi onen, vit, ");
INSERT INTO pma_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","“O Iahova, navong mahien onak mai mariso, naviso vat minuk eli, kolong nau ka kokataunau. Navong namundemi keke nuva en out ten matien, napeahik, ka koraengonau li. ");
INSERT INTO pma_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Keik kosonau nuva en mesaivuol ka namarindu nuva en huinev ten atas. Ka en out enek, atas mutaluh koe nau ka tahe keil areinau. ");
INSERT INTO pma_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Namundemi kosila lat nau maha ranuk, ka nirlestei mun Eim Votut onom. ");
INSERT INTO pma_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Atas enek kav koe inau, namarindu navita netan ka lumlum ten atas sar kat vatuk. ");
INSERT INTO pma_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Navita netan va vio … narokol vatte ten hou keil koa amul en atas, ka nalonge suval namul en out ten matien ka nito ekonek lises. Ka keik Iahova, Ahi onak, komai suk kokulat nau ran huinev ten atas mamoul eris. ");
INSERT INTO pma_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","O Iahova, navong namundemi keke moulien onak vesesal vavuol, namundem risuk. Navis vat minuk, ka kolong nau en Eim Votut onom. ");
INSERT INTO pma_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Koakeil uva netan min nana kuren keil, alokoveinuk koa kovi vatte ten tahosien one. ");
INSERT INTO pma_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Ka inau, nisau hehat minuk hetal min masmasien, ka nisan sanien votut tai emun minuk. Asa koa navit kati keke numoni, num vasi esuk. O Iahova, keik kos kokilea kovoutut moulien onen meatin keil.” ");
INSERT INTO pma_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Navong Siona vis evus, Iahova meng kat mesau enek keke vaha ut. Sakini, va mulu lat Siona vina en veien. ");
INSERT INTO pma_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Iahova selus eris min Siona vit, ");
INSERT INTO pma_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","“Kiha en mari taon ten out Nineva, ka kihit meseini min keil selusien koa nisani minuk.” ");
INSERT INTO pma_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Sakini Siona long kat Iahova ka va en out Nineva. Taon ten out Nineva marite mok. Munak meatin mul en usite tai ka vit vaha en usite sav tamun, houal avong hetel varei. ");
INSERT INTO pma_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Sakini, Siona va en taon enek ka mual ien avong tas. Evus, navong mul luhu en mari taon enek, kei visohiso va min meatin keil vit, “Avong hanumau elu (40) sesuk keke Ahi hou rasilin mari taon ekek ten out Nineva.” ");
INSERT INTO pma_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Navong meatin keil ten out Nineva alonge mukok, akur anatin en selusien onen Iahova. Sakini avitehiteni min meatin keil vasi, koakeil avi hetetamen vita rokol koakeil avi havivi, keke ihal ran anien ka isin en musi eisin keil vatie lati keke alonge tisa ven tisaen keil one. ");
INSERT INTO pma_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Navong asuv houlu ten out Nineva kur longlongien usil asa koa Siona viteni, kei mun longe tisa. Sakini mea ran vulin ten keihoen ka kulat more eisin omon. Evus, musin en musi eisin keil ka va rondan en vulimeas. ");
INSERT INTO pma_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Evus, meng kati keke avatis mengkatien tai vaha min me-Nineva keil vasi avousili. Mengkatien enek vit: “Koanek vi mengkatien onen asuv houlu ka hetetamen keil onen. Meatin keil vasi ka buluk ka sipsip ose keil emun anaan vistei anien ka anamuntei oai. ");
INSERT INTO pma_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Meatin keil ka buluk ka sipsip keil emun isin en musi eisin keil ka ipeah Ahi keke en hemahis keil. Keil ihiles ran huhuen keil one ka sakien tisa sav keil koa amumoni. ");
INSERT INTO pma_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Munak rehoumoni hemukonek, vahesa Ahi hersantei mun mahien hemai en ir. Vahesa kei hehiles rendemien onen ka hermu vinitei ir hetal min vurohien takeih onen.” ");
INSERT INTO pma_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Navong Ahi les asa koa amumoni, ka lesi keke aviles ran sakien tatisa keil one, kei viles rendemien onen ka rosantei mun mahien vasuval koa kei viteni. ");
INSERT INTO pma_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Navong Siona lesi keke Iahova en mahis meatin keil ten out Nineva, kei longe tisa houlu ka tin katiat. ");
INSERT INTO pma_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Kei vis min Iahova vit, “O Iahova, navong namul veah teim sak, nakilea tuai kumoni hemukonek. Ven sakien enetinek navit malohosai maha en out Spen. Nakilea keke keik kovi vati Ahi koa korie lat envatien ka enmahisien min meatin keil. Keik kovuli kat vurohien keil onom ka korie lat tahosien onom min meatin keil. Lisenges koviles rendemien onom keke korsantei mahien min meatin keil. ");
INSERT INTO pma_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","!O Iahova, kosa, kikulat moulien onak! !Hetahos imok nimat enges, helin munak nimules namoul!” ");
INSERT INTO pma_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Ka Iahova vit kesi mini vit, “?Komundemi kovit mal keke kovavuroh vamukonek?” Ka Siona rovit kestei ris selusien mini. ");
INSERT INTO pma_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Evus, Siona lokovein taon enek ka va rondan en out ist, out koa kilea vales mari taon ten out Nineva ien. En out enek, mumon titi votevav tai ka rondan en nimal teni veni en vati vales asa koa hemai hekula taon enek. ");
INSERT INTO pma_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Ka Iahova sakin viau tai moul kalah ka kav koe votevav vasakin out vamandil neli vakataun Siona. Ka navong Siona lesi, kei si houlu veni. ");
INSERT INTO pma_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Out mulan eris, Ahi san vaeng tai mai kan viau enek ka sakini muko ka mat. ");
INSERT INTO pma_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Ka navong meteiai mai nesa, Ahi san eang tai koa muhuh ka en out ist koa mutin imok. Meteiai mukan purun vatin Siona ka aven mai memerau. Sakini kei en vati vamat ka vit, “!Hetahos imok nimat enges, helin munak niles nimoul!” ");
INSERT INTO pma_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Ka Ahi viteni mini vit, “?Keik komundemi kovit mal keke kovavuroh vamukonek ven viau ekek?” Ka Siona vit kesi mini vit, “!Anatin! Mal keke nilonge hemukonek. !Tinok vepeng houlu veni! !Ka hetahos imok mamat!” ");
INSERT INTO pma_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Sakini Iahova viteni mini vit, “Viau enek moul vina nesa en vongien tas, ka mat en vongien sav. Keik kormumon etai tounah veni, ka kormumontei vamoul. Ka avaseini, keik em mahisi houlu ka korangisi. ");
INSERT INTO pma_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","?Mukave? ?!Romaltei keke nitie lat enmahisien onak min meatin keil ten out Nineva!? !Koakeil amoul en taon enek alohlin taosen handred tai ka halualim emun (120,000) koa areingeingen asa koa tahos ka asa koa tisa! Ka buluk ka sipsip keil ose emun avi houlu vis avi houlu mok. Siona, mal keke ek hemahis meatin keil enek.” ");
INSERT INTO pma_vpl VALUES ("MC5_1","034_5_1","MIC","5","1","1","Provet Maeka selus min me-Isrel keil vit, “Meatin keil ten out Serusalem, rehemai out hetas keke rovaha rovavae, veni vativieh keil orer akarahit koe taon orer. Keil umai avou purun asuv houlu onen me-Isrel keil, umai avouas vatin en ai tai.” ");
INSERT INTO pma_vpl VALUES ("MC5_2","034_5_2","MIC","5","2","2","Ka Iahova vat kati min meatin keil onen ka en provet Maeka vit, “Avaseini keke vatiamal onen Betlehem Efrat vi havivi mok en vatiamal sav keil onen me-Sudah keil ka nisakin asuv houlu tai hekistal ien koa helosil kat revi me-Isrel keil. Anatin, en avong telamu, kei mul tuai, ka hemai ris helosil kat me-Isrel keil.” ");
INSERT INTO pma_vpl VALUES ("MC5_3","034_5_3","MIC","5","3","3","Ka Iahova heling meatin keil onen hel en hen vativieh keil one hetokol avong koa ahin koa mul long mahien en eisilin hekur tivava onen koa hehi meahos. Ka en avong enek, tunali keil imai ris ilah ruai hetal min me-Isrel vasi keil. ");
INSERT INTO pma_vpl VALUES ("MC5_4","034_5_4","MIC","5","4","4","Navong hemai, helosil kat revi meatin keil onen hetal min keihoen koa Iahova hesani mini. Kei houm en isen Iahova koa hetetamen imok. Meatin keil onen ito en tomat, veni meatin vasi keil ten out netan ilei kilea keke kei vi hetetamen imok ka ihouhou mini. ");
INSERT INTO pma_vpl VALUES ("ZC9_9","039_9_9","ZEC","9","9","9","Iahova selus ka en provet Sakaraea vit, “!Mihesi kami! !Meatin keil koa mimul en Hou Saeon, mihesi kami hemariso! Anatin, koakeil aro en taon ten out Serusalem, mihemakul en sien. !Milesi! Asuv houlu onami mai valosil kat kami. Keihoen mul en hen ka vae mulin vativieh keil onen tuai. Ka kur rendemien ten merauen ka muloh en dongki tai. Anatin, rondan en titan dongki tai ka mul mai. ");
INSERT INTO pma_vpl VALUES ("ZC9_10","039_9_10","ZEC","9","10","10","Kei hekopahas kat tavaeen keil en atan ten out Isrel, ka hos tavaeen keil itovuol emun en taon ten out Serusalem. Hisuput tavaeen keil, kei heta vulvuli hehi soksokeite. Asuv houlu onami enek heling tomat hel en kantri keil. Hakot ten losilkatien onen hel en vali Atas Medeterenia en out not heha hetokol vali Atas Tahilhili en out saot. Atan osen, hakot teni hel en vali Oaisal Upretis en out ist heha vio … hetokol keite ten out netan en out wes.” ");
INSERT INTO pma_vpl VALUES ("ZC12_10","039_12_10","ZEC","12","10","10","“En avong enek, inau numon koakeil aka en vatimal onen Deved ral min meatin keil vasi ten out Serusalem, rendemien one hehilelau en enmahisien ka ihis minau nikataun meatin sav keil. Navong iles kei koa asal vini, itangisi hehi houlu hesuval vi titiali kati one koa heite tas. Anatin, keil itangisi veni hesuval koa amumoni navong moei ehon kati one mat. ");
INSERT INTO pma_vpl VALUES ("ZC12_11","039_12_11","ZEC","12","11","11","Tangien koa ilonge en out Serusalem hemariso vis hemariso mok hesuval amurang ven koakeil umat en vaeen vesesal en taon ten out Hadat Rimon koa mul en aet ten out Magedo. ");
INSERT INTO pma_vpl VALUES ("ZC13_1","039_13_1","ZEC","13","1","1","“En avong enek, inau nisak motein meatin keil onak ran amus ten tisaen keil one. Anatin, en vati sakien koa meatin mai mutolas navong mukul en oai koa memela ran atan, inau nisak motein moulien onen koakeil aka en vatiamal onen Deved ral min meatin vasi keil ten out Serusalem.” ");
INSERT INTO pma_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Koanik vi sise onen vati avu keil onen Iesu Kristo, koa vi havinali asuv houlu Deved telamu, koa havinali Ebraham telamu. ");
INSERT INTO pma_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ebraham, kei vi tata onen Aesak, koa vi tata onen Siekob, koa vi tata onen Sudah ka tunali keil. ");
INSERT INTO pma_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Sudah, kei vi tata onen Peres ka Siera, koa mama onealu vi Tamar. Ka Peres, kei vi tata onen Hesron, koa vi tata onen Ram. ");
INSERT INTO pma_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram, kei vi tata onen Aminatap, koa vi tata onen Nashon, koa vi tata onen Salmon. ");
INSERT INTO pma_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon, kei vi tata onen Boas, ka mama onen vi Rehab. Ka Boas vi tata onen Obed, ka mama onen vi Rut. Ka Obed vi tata onen Tiese, ");
INSERT INTO pma_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","koa vi tata onen asuv houlu Deved. Asuv houlu Deved, kei vi tata onen Solomon, ka mama onen vi vatina onen Uraea. ");
INSERT INTO pma_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon, kei vi tata onen Rehoboam, koa vi tata onen Abitsa, koa vi tata onen Asa. ");
INSERT INTO pma_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa, kei vi tata onen Sehosavat, koa vi tata onen Sehoram, koa vi tata onen Usaea. ");
INSERT INTO pma_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usaea, kei vi tata onen Siotam, koa vi tata onen Ehas, koa vi tata onen Hesekaea. ");
INSERT INTO pma_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekaea, kei vi tata onen Manase, koa vi tata onen Amon, koa vi tata onen Sosaea. ");
INSERT INTO pma_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ka Sosaea, kei vi tata onen Sekonaea ka tunali keil. En avong enek, me-Babilon keil umai amu lin me-Isrel keil ka alah lat keil uva en kantri one ten out Babilon. ");
INSERT INTO pma_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Koakeil ekek avi vati avu keil koa umai akatau en avong me-Isrel keil amea ran out Babilon: Sekonaea, kei vi tata onen Seltil, koa vi tata onen Serubabel. ");
INSERT INTO pma_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabel, kei vi tata onen Apiut, koa vi tata onen Eliakim, koa vi tata onen Asor. ");
INSERT INTO pma_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor, kei vi tata onen Sadok, koa vi tata onen Akim koa vi tata onen Eliud. ");
INSERT INTO pma_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud, kei vi tata onen Eliesar, koa vi tata onen Matan, koa vi tata onen Siekob. ");
INSERT INTO pma_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Siekob, kei vi tata onen Siosep, koa vi meatin onen Meri, koa vi mama onen Iesu, koa avise en Mesaea koa Ahi vat kati hesani hemai. ");
INSERT INTO pma_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Sakini, navong avuli vati avu keil koa amul en vatiamal onen Iesu, Ebraham rokol asuv houlu Deved, avotini keke avi teindan ehat (14). Ka en avong onen Deved rokol avong me-Isrel keil amea ran out Babilon, avotini keke vati avu keil avi teindan ehat (14). Ka en avong me-Isrel keil amea ran out Babilon rokol avong Mesaea avasi, vati avu keil enek emun avi teindan ehat (14). ");
INSERT INTO pma_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Koanik vi tunien ten asa koa kur out mulamu en hasuen onen Iesu koa vi Mesaea onen Ahi. Meri, mama onen Iesu, asak koe tuai keke vahi ahin onen Siosep. Ka navong Siosep rovatei veah vesesal veni, avotini keke Meri meas en titiali tuai ka en keihoen onen Ninin Votut. ");
INSERT INTO pma_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ka ven Siosep, meatin onen Meri, sakien keil onen mal en meten Ahi, kei en rovattei vasakin Meri vamemou en meten meatin keil. Sakini, mumon rendemien onen keke keilu luhetali koteh hatkatien onealu en sakien tai koa meatin keil iteingeingeni. ");
INSERT INTO pma_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ka navong Siosep mul veah rendem usil tounah keil enek, angelo tai onen Ahi Asuv kistal mini en matil vovoien tai ka viteni mini vit, “Siosep, havinali asuv houlu Deved telamu, konametautei keke kovakur Meri vahi ahin onom, ven titiali koa kei meas eni ka en keihoen onen Ninin Votut. ");
INSERT INTO pma_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Meri hekuri hehi meahos, ka keik kiling isen hehi ‘Iesu’ koa aneite teni vi ‘Iahova mutut meatin,’ veni kei houtut meatin keil onen ran tisaen keil one.” ");
INSERT INTO pma_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Tounah vasi enek kur out vasakin selusien koa Ahi Asuv viteni ka en provet onen mai vahi anatin koa vit, ");
INSERT INTO pma_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“!Mihelonge! Ahin hau tai koa reingeingen meatin veah hemeas en tivava. Evus, hekuri hehi meahos ka iling isen hehi ‘Imanuel,’ koa aneite teni vi ‘Ahi ro ven ir.’” ");
INSERT INTO pma_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Navong Siosep muli mea, kei mumon asa koa angelo onen Ahi Asuv meng kati mini. Kei va ven Meri ka kuri mai vi ahin onen ka luro vituai. ");
INSERT INTO pma_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ka kei romatiltei vatal mini rokol avong koa Meri kur natnali. Ka navong kur natnali, Siosep ling isen vi Iesu. ");
INSERT INTO pma_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Iesu avasi en meteimal ten out Betlehem en provins ten out Sudea, en avong koa Mari Herod vi asuv houlu ten provins enek. Ka katau en hasuen onen Iesu, hetetamen tei keil aka en out ist ka umai akistal en taon ten out Serusalem. Koakeil enek ales hitu keil keke avalei kilea asa koa hekur out en out netan. ");
INSERT INTO pma_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ka navong arokol Serusalem, amul avis meatin keil avit, “?Titiali koa avasi vi asuv houlu onen Siu keil mul kave? Veni avong mero veah en out ist, komai meles hitu onen kistal rohtoh. Sakini, memai suk keke mevahouhou mini.” ");
INSERT INTO pma_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Navong asuv houlu Mari Herod raeng koteh longlongien koanek, mundemko houlu ral min meatin vasi keil emun koa aro en out Serusalem. ");
INSERT INTO pma_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Sakini Herod vise ruain asuv keil onen pris keil ka tiser keil ten mengkatien onen Mosis ka vis keil vit, “?Mesaea koa Ahi vat kati min Siu keil, ihasi en out kave?” ");
INSERT INTO pma_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ka keil avit risi mini avit, “Ihasi en meteimal ten out Betlehem en provins ten out Sudea, veni Ahi viteni ka en tisien onen provet tai onen vit, ");
INSERT INTO pma_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Avaseini keke vatiamal onen Betlehem vi havivi mok en vatiamal sav keil onen me-Sudah keil, ka nisakin asuv houlu tai hekistal en vatiamal koanek. Kei helosil kat revi meatin keil onak ten out Isrel.’” ");
INSERT INTO pma_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Navong asuv houlu Mari Herod longe mukok, vise lelau en hetetamen keil enek koa alei kilea asa koa kur out ka en hitu keil umai veni. Evus, vis revi keil en avong sa varei keil ales hitu koanek kistal rohtoh eni. ");
INSERT INTO pma_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Evus, Herod sila keil uva en out Betlehem ka viteni min keil vit, “Miheha ka mihelekat revi titiali enek. Navong mihehotini, mihemai ris mihehiteni minau, keke inau mun niha ka nihouhou mini.” ");
INSERT INTO pma_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Navong hetetamen keil enek araengon asa koa asuv houlu viteni min keil, uva keke avahotin titiali enek. Ka navong amusil sise one uva, hitu koa alesi navong aro veah en out ist kistal eris. Ka navong keil ales hitu koanek, asi keil houlu mok. Hitu koanek muloh mulamu en keil ka vati mal en out varei koa titiali ro ien. ");
INSERT INTO pma_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Navong keil uva neim, ales titiali keilu Meri, mama onen. Ka navong ales titiali enek, aretengeiril ka uva netan mini. Evus, alah lat more sanien keil one ka asani mini. Asan gol, frangkansen, ka mir. ");
INSERT INTO pma_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ka, en vongien enek, Ahi sel kat keil en matil vovoien tai vit irvatei mun avales Mari Herod. Sakini amusil sise sav uva ris en kantri one. ");
INSERT INTO pma_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Navong hetetamen keil enek uva, angelo tai onen Ahi Asuv kistal ven Siosep en matil vovoien tai ka viteni mini vit, “!Kimea! !Kikalah kikur titiali ka mama onen ka mithelohosai mitheha en out Isip! Mitheto en out enek hetokol avong koa nihiteni keke mithemai ris. Kumoni veni, hervitei tuetin, asuv houlu Mari Herod helekat titiali koanik keke vouasi vamat.” ");
INSERT INTO pma_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Sakini, en vongien enek varei, Siosep mea vus titiali ka, keilu mama onen, tellohosai telva en kantri ten out Isip. ");
INSERT INTO pma_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Telro en out enek sua vahis rokol avong koa alonge keke asuv houlu Mari Herod mat. Tounah enek kistal vasakin selusien koa Ahi Asuv viteni ka en provet Hosea vamai vahi anatin koa vit, “Navise natkuli hemea ran out Isip.” ");
INSERT INTO pma_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Navong Herod lei kilea keke hetetamen keil enek aluvosi, tin katiat vis katiat. Sakini, sila meatin tavaeen keil onen uva en out Betlehem ka out vasi koa vesesal en out enek keke avou vasin titiali keil eni koa avi meahos koa sua one elu ka vita netan. Mumoni mukonek musil avong kati koa meatin keil ten hitu aviteni min Herod keke ales hitu enek kistal rohtoh eni. ");
INSERT INTO pma_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Tounah keil enek sakin asa koa Ahi viteni ka en provet Seremaea mai vi anatin koa vit, ");
INSERT INTO pma_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Meatin keil ten out Rama araengon tounah tai, along verien ten tangien koa keih. Resel raleh matien onen titan keil. Ka seseini avahat lat ris rendemien onen, veni titan keil avupuol varei.” ");
INSERT INTO pma_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Navong telro veah en out Isip, Mari Herod mat. Sakini angelo tai kistal ven Siosep en matil vovoien tai ");
INSERT INTO pma_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ka viteni mini vit, “!Kimea! Kikalah kihous titiali, ka kamil mama onen, mitheha ris en atan ten out Isrel, veni koakeil avit avou vini titiali enek, umat tuai.” ");
INSERT INTO pma_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Sakini, Siosep mea vus titiali, ka keilu mama onen, telva ris en atan ten out Isrel. ");
INSERT INTO pma_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ka navong Siosep raengoni keke Arkelaos kur vulin tata onen, Mari Herod, mai vi asuv houlu ten provins ten out Sudea, kei metau keke telvaha en out enek. Ka Ahi sel kati en matil vovoien tai keke nahatei en out Sudea. Sakini, telva en provins ten out Kaleli ");
INSERT INTO pma_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ka telro en out enek en taon ten out Nasaret. Sakini asa koa Ahi viteni ka en provet keil mai vi anatin koa vit, “Ihise en koan Nasaret.” ");
INSERT INTO pma_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Sua houlu muli va, ka Sion Baptis va en out volvol en provins ten out Sudea. Kei mul vitehiteni min meatin keil vit, ");
INSERT INTO pma_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“!Mihehiles ran tisaen keil onami, veni hiasuvien onen Ahi mul mai vesesal!” ");
INSERT INTO pma_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Kei vi meatin kati koa Ahi selus usili ka en provet Aesea vit, “Along rea tai mul visohiso en out volvol vit, ‘!Mihesak mesein sise onen Asuv! !Mihoumon sise onen hemal!’” ");
INSERT INTO pma_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Sion, eisin omon amumoni en hilin kamel, ka kei mutoh kati en stirap koa amumoni en hiliven buluk. Anien an vi kal ka hani koa suka bak keil amumoni en out volvol. ");
INSERT INTO pma_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ka meatin keil houlu umai veni ran out Serusalem, ran out vasi en provins ten out Sudea, ka ran out vasi keil emun vesesal en Oaisal Sodan. ");
INSERT INTO pma_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ka navong keil alesi, avit lat tisaen keil one, ka Sion vi baptaes en keil en Oaisal Sodan. ");
INSERT INTO pma_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Farasi ka Satusi keil houlu mun umai ven Sion keke vahi baptaes en keil. Ka navong Sion les keil selus keih kat keil vit, “!Ei, kami mivi vangi tetal tisa keil koa mimul mirili meatin keil en ongomi! ?Isei sel kat kami keke mivalohosai ran mahien koa Ahi hesani min kami? ");
INSERT INTO pma_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Tahos imok keke helamu, mihoumon sakien koa hetie lati keke kami miviles tuai ran tisaen onami. ");
INSERT INTO pma_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ka minandemtei minahit mihelohosai ran mahien enek ven Ebraham vi vati avu onami. !Vuo! Veni naviteni anatin min kami keke Ahi kilea vasakin ahat keil ekek imai ihi havinali Ebraham keil. ");
INSERT INTO pma_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Keitinek, teiai asak meseini tuai en vatte ten vatiai keil vasi. Ka koakeil arsontei heite ten tahosien, itei lat keil ka ison keil ihaha en ahang. ");
INSERT INTO pma_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Inau navi baptaes en kami en oai enges vatie lati keke kami miviles ran tisaen onami, ka koa hemai hekatau enau hehi baptaes en kami en Ninin Votut ka ahang. Keihoen onen mulin onak, ka inau narvinvintei keke mamai mahi slev keke makur sandel onen. ");
INSERT INTO pma_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Kei sak mesei tuai keke vatiti vas meatin keil vasi, suval meatin koa kur savel onen vaso lelat uti uit ran ingeite. Uti uit koa tahos, helah ruaini heha en eim teni, ka ingeite koa tisa, heniti en mari ahang tai koa sakras vamat.” ");
INSERT INTO pma_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","En avong enek, Iesu ka en out Kaleli ka kei mun mai en Oaisal Sodan keke Sion vahi baptaes eni. ");
INSERT INTO pma_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ka navong mai veni, Sion sak visi vahiles rendemien onen Iesu vit, “!Vuo! ?Keik kumai venau vensa? Mal keke keik kihi baptaes enau veni komarite mok komulinau.” ");
INSERT INTO pma_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ka Iesu vit kesi mini vit, “Lehoumoni hemukonek kosa, veni en sise koanik lehoumon tounah vasi koa mal en meten Ahi.” Sakini Sion maeni ka vi baptaes en Iesu. ");
INSERT INTO pma_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ka navong Sion vi baptaes eni evus, Iesu mea ran oai. Hatte tas, teilang mutah, ka kei les Ninin onen Ahi muka mita merau ka rondan eni suval ame. ");
INSERT INTO pma_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ka rea tai selus ka en out nesa ka viteni vit, “Koanik vi natkuli kati, koa envatien onak mul ien. Inau nasi nau mok veni.” ");
INSERT INTO pma_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Evus, Ninin Votut mulamun Iesu va en out volvol keke vakur sakvisien en hen Temat. ");
INSERT INTO pma_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Kei ro en out enek avong hanumau elu (40) ka mul val ran anien, sakini amai kati. ");
INSERT INTO pma_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ka Temat, koa mul sak vis meatin, mai vesesal ven Iesu ka viteni mini vit, “Munak vi anatin keke kovi Natin Ahi, kimeng kat ahat keil ekek keke ihiles imai ihi veret am.” ");
INSERT INTO pma_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ka Iesu vit kesi mini vit, “Vuo nirmumontei, veni Tus Votut viteni vit, ‘Meatin romoultei en anien enges, ka mul moul en selusien keil vasi koa kistal en ongon Ahi.’” ");
INSERT INTO pma_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Evus, Temat kur Iesu luva en out Serusalem, taon votut onen Ahi. En out enek, lingi mulomal en out tai koa nesa mok en hoi Eim Votut. ");
INSERT INTO pma_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Evus, Temat viteni mini vit, “Munak vi anatin keke kovi Natin Ahi, kihut kihita netan, veni Tus Votut viteni vit, ‘Ahi hemeng kat angelo onen keil keke ilei kat revi keik. Keil ihati latuk kihina nesa en he. Hesakini, kirmusavoitei en alom en ahat keil.’” ");
INSERT INTO pma_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ka Iesu vit kesi mini vit, “Vuo nirmumontei, veni Tus Votut viteni mun vit, ‘Minasak vistei Iahova koa vi Ahi onami keke mivahotini kei mul ral min kami.’” ");
INSERT INTO pma_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Evus, Temat kur Iesu va en mari hou tai nesa ka rie lati mini kantri vasi keil en out netan ka mormore tounah keil koa amul en keil ");
INSERT INTO pma_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ka viteni mini vit, “Tounah vasi keil enek, inau nisani minuk, munak kitetengeiril enges ka kiha netan minau.” ");
INSERT INTO pma_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ka Iesu vit kesi vit, “!Temat, keik kiha soutin ranau! Inau nirmumontei, veni Tus Votut viteni vit, ‘!Miheha netan min Iahova koa vi Ahi onami, ka mihelong kat kei enges!’” ");
INSERT INTO pma_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Evus, Temat lokoveini, ka angelo keil umai akatauni. ");
INSERT INTO pma_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Navong Iesu mul en provins ten out Sudea, raengoni keke asuv houlu Herod Antipas son Sion Baptis va en eim takeih onen. Sakini, Iesu va en meteimal ten out Nasaret en provins ten out Kaleli. ");
INSERT INTO pma_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Evus, lokovein meteimal ten out Nasaret, ka va ro en taon ten out Kapaniam koa mul vesesal en Mari Oai ten out Kaleli. Taon koanek mul en atan onen koakeil ten mari vatiamal onen Sebiulon ka Navtali telamu. ");
INSERT INTO pma_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Koanek kur out vasakin asa Ahi viteni ka en provet Aesea hemai hehi anatin koa vit, ");
INSERT INTO pma_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Nakur longlongien tai vaha min meatin keil koa aro en atan onen mari vatiamal onen Sebiulon ka atan onen mari vatiamal onen Navtali. Longlongien koanek heha min koakeil aro vesesal en Mari Oai ten out Kaleli, en usite va en Oaisal Sodan, min koakeil aro en out Kaleli, out koa vilelau en meatin keil koa arvitei Siu. ");
INSERT INTO pma_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Meatin keil koa aro en mankoli ten tisaen, keil iles mari meneai onen Ahi. Anatin, meatin keil koa aro en mankoli veni ametaun matien, kosa alesi keke out mai mulan suk.” ");
INSERT INTO pma_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ka avong enek eva, Iesu mul vitehiten selusien onen Ahi min meatin keil vit, “!Mihehiles ran tisaen keil onami, veni hiasuvien onen Ahi mai vesesal!” ");
INSERT INTO pma_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","En avong tai, Iesu mul mual musil valite ten Mari Oai ten out Kaleli. Ka navong mul mual, kei les lumali time, isealu Saemon (koa aling isen tamun vi Pita) ka Andru (koa vi tunali). Keilu lumul luson net onealu en mari oai veni luvi meatin talah mesauien. ");
INSERT INTO pma_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ka Iesu viteni min keilu vit, “Lumai milhousil kat inau. Kosa milmul millah mesau enges, ka inau nihisein kamil hemukave milhelah meatin keil.” ");
INSERT INTO pma_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ka hatte tas, lulokovein net keil onealu ka luva lumusili. ");
INSERT INTO pma_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Evus, keitel telmual telva ka Iesu les lumali time sav, isealu Tiemes ka Sion, koa luvi natin Sepeti. Keilu lumul en vot ral min tamealu ka telsak revi net keil oneatel. Ka navong Iesu vise keilu luvamai veni, ");
INSERT INTO pma_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","hatte tas, lulokovein vot ka tamealu, ka luva lumusil Iesu. ");
INSERT INTO pma_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Navong Iesu vise keitel telvousili evus, kei va ka vasi out Kaleli. Ka, en out vasi, kei mul visein meatin keil en eim tahihiseien keil onen Siu keil, mul vitehiten more longlongien usil hiasuvien onen Ahi, ka mul sak revi meatin keil koa akur mesaien savsav keil. ");
INSERT INTO pma_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ka longlongien usili ka vasi out en provins ten out Siria emun. Sakini, meatin keil ten out enek alah koakeil amesai en mesaien savsav keil: koakeil ave litu ramat, koakeil ninin tisa mul en keil, koakeil avi leimatmat, ka koakeil hati usive mat. Keil alah keil vasi umai ven Iesu ka kei sak revi keil. ");
INSERT INTO pma_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ka navong Iesu mual, marmari vangi meatin keil amusili. Keil aka en provins ten out Kaleli ka provins ten out Sudea. Aka en taon ten out Serusalem ka taon halualim (10) koa avise keil en ‘Dekapolis.’ Ka aka emun en out sav keil en usite ten Oaisal Sodan. ");
INSERT INTO pma_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","2","Navong Iesu les marmari vangi meatin keil enek, kei vina nesa en hou tai ral min meatin keil onen ka rondan keke vahisein keil. ");
INSERT INTO pma_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Iesu viteni min keil vit, “Tokolkatien hel en koakeil alei kilea arvinvintei en meten Ahi, veni hemukonek, kei hehi asuv houlu one ka helosil kat revi keil. ");
INSERT INTO pma_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Tokolkatien hel en koakeil amurang veni alonge tisa, veni hemukonek, Ahi hehati lat rendemien one. ");
INSERT INTO pma_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Tokolkatien hel en koakeil amerau ka rendemien one mul netan, veni hemukonek, Ahi hesan out vasi netan min keil avalosil kati. ");
INSERT INTO pma_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Tokolkatien hel en koakeil e vati mok keke moulien one hemal vasi en meten Ahi, veni hemukonek, houmoni hehi anatin en moulien one. ");
INSERT INTO pma_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Tokolkatien hel en koakeil e mahis meatin sav keil, veni hemukonek, Ahi hetie lat sakien ten enmahisien min keil. ");
INSERT INTO pma_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Tokolkatien hel en koakeil amusil kat Ahi ral min rendemien koa mutolas, veni hemukonek, keil iles Ahi en mete. ");
INSERT INTO pma_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Tokolkatien hel en koakeil aling tomat en meatin keil, veni hemukonek, ihise keil en titan Ahi. ");
INSERT INTO pma_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Tokolkatien hel en koakeil akur mahien veni amum mal, veni hemukonek, Ahi hehi asuv houlu one ka helosil kat revi keil. ");
INSERT INTO pma_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Tokolkatien hel en kami navong meatin keil aselus karen kami, asan mahien min kami, ka aviten luvosien tatisaso houlu vakat kami veni mimusil kat inau. ");
INSERT INTO pma_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Anatin, en vati sakien koanik, asan mahien min provet keil koa amul amulamu en kami. Ka mihesi kami veni mihekur ui umen onami koa hemariso mok en out nesa.” ");
INSERT INTO pma_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Iesu selus eris vit, “Kami misuval sol koa arivini en meatin keil en out netan. ?Ka munak kasien ten sol vuol rani, umon kasien teni hemai ris eni hemukave? !Asakras avoumoni! Sol koa kasien tovuol ien sakras voumon etai tounah. Tahos avasonis vaha keke meatin keil avahetan eni. ");
INSERT INTO pma_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Kami misuval laet koa ritin va min meatin keil en out netan. Ka suval taon koa mul en hoi hou nesa sakras vato suai veni laet koa mul ien, kami mun, meatin keil ilei kilea laet koa mul en kami. ");
INSERT INTO pma_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Meatin tovuol vanit laet tai ka, evus, mul kav koe en pesin tai. !Vuo! Keil alingi nesa en out arekein laet ien keke kilea vatitin revi out vasi neim ven meatin keil koa aro ien. ");
INSERT INTO pma_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","En vati sakien enek, laet ten demkatien onami hetitin revi ven meatin keil. Hemukonek, navong keil iles more sakien keil onami, keil ihat lat isen Tata onami koa ro en out nesa.” ");
INSERT INTO pma_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Iesu visein meatin keil vit, “Minandemtei minahit inau numai keke maso lat mengkatien onen Mosis ka hihiseien onen provet keil vaha. !Vuo! Narmaitei maso lat keil. Numai masakin asa koa mengkatien keil aselus usili hemai hehi anatin. ");
INSERT INTO pma_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Anatin eli naviteni min kami keke tounah vasi koa mul en mengkatien keil onen Ahi ka titi selusien vasi keil koa provet keil onen amutisi mul asakras avavupuol hetokol avong varei koa um vasi umen one ka out nesa ka out netan luhevupuol. ");
INSERT INTO pma_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Sakini, koakeil arali koteh mengkatien tai onen Ahi koa havivi mok ka avisein meatin sav keil keke umoni hesuvali, en out nesa, keil imai ihi meatin heisav keil enges. Ka koakeil along kat mengkatien onen Ahi ka avisein meatin sav keil keke umoni hesuvali, en out nesa, keil imai ihi hetetamen keil. ");
INSERT INTO pma_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Veni naviteni min kami keke maluen onami helin maluen onen tiser keil ten mengkatien onen Mosis ka Farasi keil, munak mihermumontei, miherlestei hiasuvien onen Ahi.” ");
INSERT INTO pma_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Iesu viteni mun min meatin keil vit, “Kami milonge keke Mosis meng kat avu keil onami telamu vit, ‘Minouastei meatin namat’ ka meatin koa mumoni heha en kot ka isan mahien mini. ");
INSERT INTO pma_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ka inau naviteni min kami keke meatin vasi koa avuroh kat tue keil, Ahi helei rahit usite one ka hesan mahien min keil ven. Anatin, munak meatin tai viteni min tunali vit, ‘vatum tovuol,’ ikur meatin enek heha en mari kot onen Siu keil ka iling mahien eni. Ka munak meatin tai viteni min tunali vit, ‘kovi vau,’ kei mul en sise koa heha en Ahang koa sakras vamat. ");
INSERT INTO pma_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Sakini munak keik kovaha keke kovasan sanien onom vaha min Ahi en ahor ten sanien, ka en out enek komundem kat tounah tai koa meatin sav vit komumoni mini koa romaltei, ");
INSERT INTO pma_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","keik kilokovein sanien onom en out enek vesesal en ahor ten sanien. Hevus, kiha mau ka kumon methos hetal min meatin enek. Ka navong komumoni evus, kimai ris kisan sanien onom esuk min Ahi. ");
INSERT INTO pma_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Ka munak komumon tounah tai koa romaltei va kat meatin tai, ka kei vit vakur keik kovaha en kot, kikalah kisak revi tounah enek hetal mini navong kamil milmul veah milmusil sise keke milvaha en kot. Veni munak kormumontei, navong milhetokol kot, kei helinguk kiha en hen meatin koa mul lei revi usite onen meatin keil. Ka vahesa kei hemae latuk kiha en hen polis, ka polis heson keik kiha suk en eim takeih. ");
INSERT INTO pma_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Anatin eli naviteni minuk, keik kito en out enek ka kosakras kovamaluv heha vio … kihul vasi faen koa alingi enuk.” ");
INSERT INTO pma_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ka Iesu mules visein keil vit, “Kami milonge keke Mosis meng kat avu keil onami telamu vit, ‘Minakurtei ahin vuo meatin onen hanu sav.’ ");
INSERT INTO pma_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ka inau naviteni min kami keke navong meatin tai koa retalihe tuai les ahin tai ka en vati voum vatisa vatal mini, en meten Ahi suval kei kuri tuai veni mum tisa ral mini tuai en rendemien onen. ");
INSERT INTO pma_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Munak usi metom koa matu sakinuk kumot en tisaen, kikis lati ka kisoni heha. Tahos imok hati vem tai hevuol, lohlin munak ason avem vasi hevuol en Ahang koa sakras vamat. ");
INSERT INTO pma_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ka munak hem koa matu sakinuk kumot en tisaen, kita kotehei ka kisoni heha. Tahos imok hati vem tai hevuol, lohlin munak kiha en Ahang koa sakras va mat hetal min avem vasi.” ");
INSERT INTO pma_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Iesu mules visein meatin keil vit, “Kami milonge keke Mosis meng kat avu keil onami telamu vit, ‘Meatin koa vit valokovein ahin onen, hesan Setifiket ten Tasilien mini, evus, kilea valokoveini.’ ");
INSERT INTO pma_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ka inau naviteni min kami keke navong meatin tai ka ahin tai luretalihe, lusakras luvatasil en meten Ahi. Ka munak meatin tai lokovein ahin onen, koa romatiltei ral min meatin sav tai, kei mumon tisaen en meten Ahi. Veni asa koa meatin enek mumoni mul sakin ahin onen va keke vakur meatin sav, ka en meten Ahi, ahin enek mul mum tisa ral mini. Ka meatin hau koa kuri, kei mun mul mum tisa en meten Ahi veni kur ahin onen meatin sav.” ");
INSERT INTO pma_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Iesu mules visein meatin keil vit, “Kami milonge keke Mosis meng kat avu keil onami telamu vit, ‘Minatali kotehtei hatkatien keil onami koa misuv kati en isen tounah tai, ka mihoum vasi asa koa mivat kati min Ahi Asuv keke mihoumoni.’ ");
INSERT INTO pma_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ka inau naviteni min kami keke minasuv kattei hatkatien keil onami en etai tounah en out nesa veni vi vulin ten keihoen onen Ahi. ");
INSERT INTO pma_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ka minoumontei en etai tounah en out netan veni vi out koa Ahi mul ling alen museh ien. Ka minoumontei en isen Serusalem, veni vi taon onen Ahi koa vi asuv houlu. ");
INSERT INTO pma_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ka minasuv kattei selusien onami en vatumi emun veni kami misakras mivahiles ahil vatas vamai voh vuo vavopoli. ");
INSERT INTO pma_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Sakini, navong miviten tounah tai, mihehitenis keke ‘anatin numoni,’ vuo ‘nirmumontei.’ Ka hevus, mihoumoni suk. Veni navong misak visi keke mivasuv kat selusien onami en etai tounah, sakien koanek ka ven Temat.” ");
INSERT INTO pma_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Iesu mules visein meatin keil vit, “Kami milonge keke Mosis meng kat avu keil onami telamu vit, ‘Munak mipurun meten meatin sav, akilea avapurun metomi. Ka munak mimuti lat lohon meatin tai, akilea avati lat lohomi tai.’ ");
INSERT INTO pma_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ka inau naviteni min kami keke minasa kestei tounah koa meatin tai mumoni tisa min kami. Munak meatin tai kovas veasom en usite matu, kimaeni heovas usite meil emun. ");
INSERT INTO pma_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ka munak meatin kur keik milvaha en kot ka keih katuk keke kovasan eisin omom mini, kimaeni hekur kot omom ten anni emun. ");
INSERT INTO pma_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Munak meatin tavaeen tai keih katuk kovahous ateli onen vahi kilomita tai, kihousi kilomita helu. ");
INSERT INTO pma_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ka munak meatin tai visuk en tounah tai, kisani mini. Munak meatin tai vit vakur tounah tai onom ten avong havivis, konaseseintei, kimaeni mini.” ");
INSERT INTO pma_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Iesu mules visein meatin keil vit, “Kami milonge keke Mosis meng kat avu keil onami telamu vit, ‘Emi hehat tuomi keil.’ (Lev 19:18) Ka, ‘Mihetisa min koakeil avi vativieh onami.’ ");
INSERT INTO pma_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ka inau naviteni min kami keke emi hehat koakeil avi vativieh ral min kami ka mihehis ven koakeil asan mahien min kami. ");
INSERT INTO pma_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","En sakien koanek, mihetie lati keke mivi titan Tata onami koa ro en out nesa. Veni kei sakin meteiai ritin en koakeil atisa ka en koakeil emun atahos. Kei sakin ous mus vakas atan osen koakeil amal ka koakeil akalkali emun. ");
INSERT INTO pma_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","?Veni munak em vat koakeil enges e vatuk, komundemi keke Ahi hesan masmasien hehat minuk veni? !Vuo! !Meatin koa alah takis ran meatin sav ral min meatin vasi keil emun amumon vati sakien koanek! ");
INSERT INTO pma_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","?Ka munak miselus tahos min tuomi keil enges, sakien enek tahos mukave? Veni koakeil areingeingen Ahi, ral min meatin vasi keil emun, amumon vati sakien enek. ");
INSERT INTO pma_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","“En sakien vasi keil onami ka en rendemien vasi keil emun, mihemal revi hesuval Tata onami en out nesa mal revi mok.” ");
INSERT INTO pma_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Iesu visein meatin keil vit, “Navong mimumon sakien keil koa tahos min meatin sav keil, mihelei kat revi keke minoumontei en meten meatin keil keke avahouhou min kami. Veni munak mimumoni mukonek, Tata onami en out nesa hersantei mun uite teni min kami. ");
INSERT INTO pma_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Sakini navong misan kataunien min meatin koa tounah onen tovuol, minoumontei nasuval sakien onen koakeil amumonis en hilive. Veni navong asak mesei keke avasan tounah, uva en eim tahihiseien keil ka en mari sise keil, ka asakin meatin toumien one amuh tounah koa suval amaru keke meatin keil imai vituai avales asa koa avoumoni ka avahouhou min keil. Anatin eli naviteni min kami, keil akur ui umen one tuai ka irkurtei mun uite teni en out nesa. ");
INSERT INTO pma_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ka navong mikataun meatin koa tounah onen tovuol, mihoum raeng eni en sise koa time tahos keil emun onami iteingeingeni. ");
INSERT INTO pma_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Hesakini meatin keil iteingeingen sakien tetahos keil onami, ka Tata onami, koa les asa koa meatin keil amum suai eni, kei hesan uite teni min kami.” ");
INSERT INTO pma_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Iesu mules visein meatin keil vit, “Navong mivis, minoumontei nasuval koakeil amumonis en hilive. Veni keil e vati avahatimal ka avahis en eim tahihiseien keil ka en vali sise keil keke meatin keil avales keil eni. Anatin eli naviteni min kami, keil akur vasin uite one tuai. ");
INSERT INTO pma_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ka navong mivis min Ahi, tahos imok keke miheha neim, miheoteh en voiteh, ka mihehis heha min Tata onami koa meatin keil asakras avalesi. Ka Tata onami, koa les asa koa meatin keil amum suaini, kei hesan uite teni min kami. ");
INSERT INTO pma_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Ka navong mivis, minaselustei nahi houlu nasuval koakeil areingeingen Ahi. Veni koakeil enek amundemi avit ahi keil one itaengon hisien keil one munak amang vas onge houlu ral min selusien houlu. ");
INSERT INTO pma_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Anatin, minoumontei nasuval keil, veni navong mirvistei veah mini, Ahi Tata onami kilea tuai asa koa kotamurei eni. ");
INSERT INTO pma_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Sakini navong mivis mihehiteni hemukok, ‘Ahi Tamemai koa koro en out nesa, mal keke mevouhou minuk veni isom vi votut. ");
INSERT INTO pma_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Mevis keke hiasuvien onom hemai hel ven komai ka tounah vasi koa emi vati vakistal hekistal hehi anatin en out netan hesuval mul tuai en out nesa. ");
INSERT INTO pma_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Kisan anien eli min komai hevinvin ten avong kosa. ");
INSERT INTO pma_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Konaleletei mun natisa min komai ven tisaen keil onomai, veni komai mun merleletei mun vatisa min koakeil amumoni romaltei en komai. ");
INSERT INTO pma_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Konamaentei li sakvisien takeih keil anamai anasakin komai menamot en tisaen, ka kiting koe komai ran hen Temat.’ ");
INSERT INTO pma_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Munak methos onami mul en meatin sav koa amumoni romaltei min kami ka minaleletei mun natisa en keil, Tata onami koa mul en out nesa, kei, methos onen hel en kami emun. ");
INSERT INTO pma_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ka munak mirmumontei methos vatal min koakeil enek, Tata onami emun sakras voumon methos vatal min kami ven tisaen keil onami.” ");
INSERT INTO pma_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Iesu mules visein meatin keil vit, “Navong mival ran anien keke mivahis, minoumontei nasuval koakeil amumonis en hilive. Veni navong uval ran anien amumon veinae tisa keke meatin keil avalei kilea keke amai kat keil. Anatin eli naviteni min kami, keil akur vasin uite teni tuai. ");
INSERT INTO pma_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ka navong kami mival ran anien keke mivahis, tahos imok munak mihekas veinami ka mihesak vilei en hilumi hesuval koa mimumoni en avong vasi. ");
INSERT INTO pma_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Hesakini, meatin sav keil asakras avalei kilea keke kami mimul mival ran anien, ka Tata onami koa meatin keil asakras avalesi, kei enges helei kilea eni. Anatin, Ahi Tata onami, koa les asa koa meatin keil amum suaini, kei hesan uite teni min kami.” ");
INSERT INTO pma_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Iesu mules visein meatin keil vit, “Kami minalah kattei tounah onami nahi houlu en out netan. Veni tounah keil onami en out netan, kakoros ka rosta lukilea luvapuruni, ka tarhena keil akilea avaha neim ka avahenani. ");
INSERT INTO pma_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ka tahos imok keke mihelah kat tounah keil onami hehilelau en out nesa. Veni en out enek, kakoros ka rosta lusakras luvapuruni, ka tarhena keil asakras avaha neim ka avahenani. ");
INSERT INTO pma_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Veni moulien onami hel en out koa milah kat tounah tetahos keil onami mul ien. ");
INSERT INTO pma_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Metomi suval laet ten avemi. Munak metomi tahos, mimul en meneai ka avemi kilea voumon sakien keil koa atahos. ");
INSERT INTO pma_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ka munak metomi tisa, mimul en mankoli ka mihoumon sakien keil koa atisaso. Ka munak laet onami vi mankoli, mankoli ten tisaen hemarite mok en moulien onami.” ");
INSERT INTO pma_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ka Iesu vit, “Meatin tai sakras voum min masta elu (2). Veni munak kei hesak visi voumoni, tin heat tai, ka en hehat tai en keilu; vuo rendemien onen hel en tai ka helei sesein tai en keilu. Misakras mivaha netan min Ahi vatal min tounah mani. ");
INSERT INTO pma_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Sakini, veni koanek vi anatin, tahos minandemkotei en usite ten asa koa miheani vuo asa koa mihemuni, vuo asa koa miheav koe avemi eni. ?Mukave, romoul keke rovaanian enges? !Vuo! ?Ka aver mul keke rovav koe en eisin enges? !Vuo! Moulien koa mul en kami tahos imok mulin asa koa mimul mikani. Ka avemi tahos imok mulin eisin koa mikav koe eni. ");
INSERT INTO pma_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Miheles vis aman keil koa amul amuka. Keil arluhluhtei, ka armusuhuttei en anien ae keke avalingi vaha en votevav ome. Avaseini armumontei vamukonek, ka Ahi Tata onami en out nesa mul vengan keil. Ka en meten Tata onami, kami mitahos mulin aman keil enek. Sakini miheilea mihehit Ahi helosil kat revi kami. ");
INSERT INTO pma_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Demkoen ven tounah keil sakras voumon moulien onami vataveah tamun. ");
INSERT INTO pma_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“?Ka mimundemko en usite ten eisin vensa? Mihendem usil vis hungevai keil koa amul amoul. Keil armumtei vuo arrilitei eisin ome. ");
INSERT INTO pma_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ka naviteni min kami keke asuv houlu Solomon telamu, eisin omon tahos vis tahos imok, ka hungevai keil enek amusin tahos imok muli kei. ");
INSERT INTO pma_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ahi mul musin en hungevai keil tahos imok, avaseini amoul en eivorohus avong tanges, ka visuvong teni, amaleles ka umotmot. Ka evus, amuteas ruaini ka asoni va en ahang. ?Ka munak Ahi musin en keil mukok, mimundemi keke kei sakras vasin koe kami? !Ei, demkatien onami havivi ramat! ");
INSERT INTO pma_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Sakini, minandemkotei usil asa koa miheani, asa koa mihemuni, vuo asa koa mihesin eni. ");
INSERT INTO pma_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Veni vati demkoen koanek vi onen koakeil arkileatei Ahi. Veni Ahi Tata onami kilea revi en tounah vasi koa mitamurei eni en moulien onami. ");
INSERT INTO pma_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ka koa hetetamen imok keke mihemaen Ahi hemai hehi asuv houlu en moulien onami ka mihekur maluen onen hehi onami. Navong mimumoni mukonek, tounah vasi emun ten moulien, Ahi hesani min kami. ");
INSERT INTO pma_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Sakini minandemkotei mun usil tounah keil koa mihekuri visuvong, veni miheilea mihendem usili visuvong esuk. Veni sakvisien keil koa mihehisu eni kosa, avinvin ten kosa etin. Minalahtei demkoen keil ten visuvong namai nahi ten avong kosa.” ");
INSERT INTO pma_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Iesu mules visein meatin keil vit, “Minalei revitei usite onen meatin sav keil keke mivahotin tisaen keil one, veni munak mimumoni, Ahi emun helei revi usite keil onom ka hehotin tisaen keil onami. ");
INSERT INTO pma_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Veni Ahi helei revi usite onami housil vati sakien koa kami mimul mimumoni en meatin sav keil. Munak mimumoni en sakien koa merau, Ahi houmoni min kami hemukonek. Ka munak mimumoni en sakien koa keih, Ahi houmoni suk hekeih min kami. ");
INSERT INTO pma_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“?Vensa mimul mirie sokeai koa havivi mok koa mul en meten tuomi, ka emi rovattei mivailea en mari mavuliai koa mules en metomi? ");
INSERT INTO pma_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","?Vensa mimul miviteni min tuomi mivit, ‘Tuo li, kimaenau makulat sokeai ran metom,’ navong mari mavuliai mules en metomi? ");
INSERT INTO pma_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","!Kami mimumon sakien koa tahos en hilivemi enges! Tahos imok keke helamu mihekulat mari mavuliai ran metomi, ka hevus, kami mikilea suk mihelele revi keke mivakulat sokeai ran meten tuomi. ");
INSERT INTO pma_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Tounah keil koa avi votut onen Ahi, minasantei min huli keil koa ihiles ka iat purun kami eris. Anatin, minasontei tounah koa tahos imok min vuas keil veni keil ihetan eni enges.” ");
INSERT INTO pma_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Iesu mules visein meatin keil vit, “Naviteni min kami, tahos keke kami miheles mihehis Ahi en tounah, ka kei hesani min kami. Anatin, asa koa emi vati mivakuri, munak mihelekati, mihehotini. Hisien onami hesuval koa mimul mimutiti voiteh onen Ahi, ka hesakini kei heseh voiteh onen min kami. ");
INSERT INTO pma_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ven meatin vasi koa avisi ven tounah, keil ikuri suk; koakeil amul alekat tounah, keil ihotini; ka voiteh heseha min koakeil amul amutiti. ");
INSERT INTO pma_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“?Isei en kami tata keil hesan meralihat min natnali navong kei visuk en anien? ");
INSERT INTO pma_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","?Vuo hesan tetal tatisa tai mini navong kei visuk en mesau? ");
INSERT INTO pma_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Sakini, avaseini keke kami mivi meatin tisa keil, mikilea en sakien koa mivasan tounah keil tetahos min titiali onami keil. ?Ka mukave en sakien onen Ahi Tata onami en out nesa koa tahos imok? Sakien onen heli onami ka hesan tounah keil tetahos min koakeil amul avisi veni.” ");
INSERT INTO pma_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ka Iesu viteni vit, “En tounah vasi koa mimumoni, mihoumoni min meatin sav keil hesuval koa emi vati keke keil emun umoni min kami. Veni rendemien koanik vi vatte ten mengkatien keil onen Mosis ka Tisien onen provet keil telamu.” ");
INSERT INTO pma_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Iesu viteni vit, “Kami, sakien koa mikilea mivaha en out nesa romaetei. Tahos keke miheha neim eni ka en meteau koa havivi. Veni meteau sav mul koa marite, ka meatin houlu uva neim ien ka amual en sise koa mae. Ka en keite teni, ihotin mahien koa hemariso mok. ");
INSERT INTO pma_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ka meteau koa ten sise takeih ten moulien vi havivis, ka teis en meatin keil ihotini.” ");
INSERT INTO pma_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Iesu sel kat meatin keil vit, “Kami mihelei kat revi kami keke provet taluvosien keil analuvostei kami. Veni en hilive, ales keil asuval sipsip koa atahos ka amerau, ka en tine, keil asuval huli rendan keil koa atisa ka akat purun meatin keil. ");
INSERT INTO pma_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mihelei kilea keil heka en heite ten moulien one. Meatin keil asakras avalah hei tavoi ran aikatiat, vuo hei manggo ran vati ueas. ");
INSERT INTO pma_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","En vati sise enek, vatiai vasi koa atahos amul ason heite koa tahos, ka vatiai keil koa atisa amul ason heite koa tisa. ");
INSERT INTO pma_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Vatiai koa tahos sakras vason heite koa tisa, ka vatiai koa tisa sakras vason heite koa tahos. ");
INSERT INTO pma_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ka vatiai vasi koa hersontei heite koa tahos, itei lati ka isoni heha en ahang. ");
INSERT INTO pma_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","En vati sakien enek, mihelei kilea provet taluvosien keil heka en heite koa mul en moulien one. ");
INSERT INTO pma_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Meatin houlu koa amul avise nau en ‘asuv’ kosa, irvatei en out nesa koa Ahi vi asuv houlu ien. Koakeil enges amumon asa koa Tata onak en out nesa en vat keil avoumoni iha ito hetal mini. ");
INSERT INTO pma_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","En avong koa ilei revi usite onen meatin keil, houlu imai venau ka ihiteni minau usil usite one ihit, ‘!Asuv, Asuv! ?Mukave? En isom mevit lein selusien koa Ahi sani min komai. En isom mevile lat ninin tisa keil ka memumon merikel keil houlu.’ ");
INSERT INTO pma_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Hevus, nihit retai en selusien koanek min keil nihit, ‘!Kiha ranau, keik koa komumon tisaen keil! !Inau narkileatei keik varei!’” ");
INSERT INTO pma_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Evus, Iesu selus ekor min meatin keil ral min tatavolien tai vit, “Munak kami milong selusien keil ekek onak ka mimum usili, misuval meteisau tai koa mumon eim onen mul en atan koa keih. ");
INSERT INTO pma_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ous mus, mari oai mue, ka eang muhuh keih kat eim enek. Ka romerangtei, veni mumoni mul en atan koa keih. ");
INSERT INTO pma_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ka munak kami koa milong selusien keil ekek onak ka mirmumtei usili, kami misuval unu tai koa mumon eim onen en veien enges. ");
INSERT INTO pma_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ous mus, mari oai mue, ka eang muhuh keih kat eim enek. !Ka eim onen merang vita ka rasil li varei!” ");
INSERT INTO pma_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Navong Iesu visein meatin keil evus, marmari vangi meatin keil amutimanin en hihiseien keil onen, ");
INSERT INTO pma_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","veni kei visein keil suval koa kur hihiseien keil ran Ahi varei. Hihiseien keil onen rosuvaltei onen tiser keil ten mengkatien onen Mosis koa avit ris selusien onen tiser sav keil enges. ");
INSERT INTO pma_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Navong Iesu visein meatin keil evus, kei mita netan ran hou enek, ka mari vangi meatin keil amusili. ");
INSERT INTO pma_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Evus, amutimanin, meatin tai koa mesaien ten leprosi mul ien mai luhu en keil, retengeiril en meten Iesu, ka viteni mini vit, “Asuv, munak keik em vati li, kokilea kovasak revi hilivek vamai vato eris.” ");
INSERT INTO pma_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Sakini, Iesu mutelan hen rokoli ka viteni mini vit, “Tahos, ek vat moumoni. !Kito ris!” Hatte tas, meatin enek, mesaien onen evus ka hiliven mai mutolas. ");
INSERT INTO pma_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Evus, Iesu viteni mini vit, “!Kitaengonau! Konahitentei min meatin etai asa koa kur out. Kihas ka kihothot enuk min pris tai en Eim Votut, ka kisan min Ahi sanien koa Mosis meng kati. Tounah enek vatie lati min keil keke avem tahos tuai ka komuto eris.” ");
INSERT INTO pma_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Iesu mual va en taon ten out Kapaniam. Ka navong kistal ien, avat tavaeen tai ten out Rom mai veni ka visi vakatauni vit, ");
INSERT INTO pma_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Asuv, eiloheh onak mules teim ka longe tisa houlu, usi aven mat ka ro nges en vulin.” ");
INSERT INTO pma_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Iesu viteni mini vit, “Niha veni ka nisak revi.” ");
INSERT INTO pma_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ka avat enek vit kesi vit, “O asuv, konandemvu ramattei venau veni narvinvintei keke kovaha teim onak. Ka munak kihitenis, nakilea keke eiloheh onak helonge hetahos eris. ");
INSERT INTO pma_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Veni masta onak mul, ka inau mun navi avat onen meatin tavaeen keil. Sakini, navong naviteni min tai en keil navit, ‘Ha.’ Kei va. Ka navong navit, ‘Amai.’ Kei mai. Ka navong naviteni min eiloheh onak navit, ‘Umon koanik.’ Kei mumoni.” ");
INSERT INTO pma_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Navong Iesu raengon selusien onen, kei mutimanin ka viteni min koakeil amul amusili vit, “Anatin eli naviteni min kami, en me-Isrel keil, narvotintei veah etai meatin koa demkatien onen keih imok vasuval meatin ekek. ");
INSERT INTO pma_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Navong Kristo onen Ahi hemai ka umon mari anien en out koa Ahi vi asuv houlu eni, meatin keil koa arvitei Siu ika en out sav keil en out netan ka imai ianian vituai hetal min Ebraham, Aesak ka Siekob, vati avu keil orer telamu. ");
INSERT INTO pma_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ka houlu en me-Isrel keil kati koa Ahi vit vahi Asuv Houlu one, heso lat keil iha hae en out koa mankoli, ka keil il is ka il ihal lohe ven mahien one.” ");
INSERT INTO pma_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Evus, Iesu viles ka viteni min avat enek vit, “Kiha. Asa koa komundesini kovit hekur out, hekistal hehi anatin keke eiloheh onom helonge hetahos.” Ka en hati avong enek varei, eiloheh onen avat enek, aven mai ris tahos. ");
INSERT INTO pma_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Navong Iesu va rokol teim sen Pita, va neim ka les avu tisa onen Pita mul matil en vulin ka aven mutin. ");
INSERT INTO pma_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Navong lesi mukok, Iesu mutelan hen ka rokol hen tovuli enek. Ka navong rokoli, mesaien va rani ka kei mea. Evus, tovuli enek kur hati anien tai, ka sani min Iesu. ");
INSERT INTO pma_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Navong meteiai munu, meatin keil alah koakeil ninin tisa mul en keil, ka Iesu vile lat ninin tisa keil avaha ran keil ral min selusien enges onen. Ka meatin vasi keil amesai, kei sak revi keil. ");
INSERT INTO pma_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Kei mumon tounah enek vasakin asa koa Ahi viteni ka en provet Aesea hemai hehi anatin koa vit, “Kei lah lat mesaien keil orer ka kur mahien keil orer en aven.” ");
INSERT INTO pma_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ka navong Iesu lesi keke marmari vangi meatin keil amules rahiti, kei meng kat meatin keil onen keke avasak mesein vot tai keke avaha en usi Mari Oai ten out Kaleli. ");
INSERT INTO pma_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ka navong Iesu ka onen keil amul uva, tiser tai ten mengkatien onen Mosis mai veni ka viteni vit, “Tiser, out kave kiha ien, inau nusil katuk.” ");
INSERT INTO pma_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ka Iesu vit kesi mini vit, “Asu keil, vai ome mul, ka aman keil, anu ome mul. Ka Natin Meatin, teim kati onen tovuol tamatil ien.” ");
INSERT INTO pma_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ka meatin tamun koa mul musil Iesu vit, “Asuv, ek vati mousiluk. Ka helamu, kimaen nau niha ris teim ka nilei kat tata onak hetokol avong koa hemat ka nitahini.” ");
INSERT INTO pma_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ka Iesu viteni mini vit, “Kusil kat nau kosa, ka kilokovein koakeil umat en demkatien one keke itahin koakeil one umat.” ");
INSERT INTO pma_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Navong Iesu selus evus, kei vut va en vot ka meatin keil onen amusil kati keke uva en usi oai. ");
INSERT INTO pma_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ka navong amulis uva, Iesu matil usae. Ka rovitei tuetin, amutimanin en mari angu tai koa mea ka muhuh keih. Kei sakin oai langlango, mul rasil va neim en vot, ka vesesal avamarindu. Ka Iesu, kei matil ravobong. ");
INSERT INTO pma_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ka keil uva veni ka asisil eni avit, “!Asuv, kataun komai li! !Rovamat enga ke!” ");
INSERT INTO pma_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Iesu vit kesi vit, “?Mimetau vensa? !Demkatien onami havivi ramat!” Evus, kei mea ka meng kat eang ka oai luvahati keilu, ka out mai mutaeng ka vi tasioh. ");
INSERT INTO pma_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Navong meatin keil onen alesi mukok, amutimanin ka avis keil eris avit, “?Meatin ekek vi vati meatin sa? !Avaseini eang ka oai, keilu mun lulong kat ren!” ");
INSERT INTO pma_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Navong arokol usi oai, Iesu emai en atan ten out Kadara. Ka hatte tas, meatin elu luka en out ten valengeihat keil koa amul arahin meatin keil ien, ka lumai vesesal ven Iesu. Meatin keilu enek, ninin tisa mul en keilu ka asakin keilu lumuas meatin vasi keil koa lulesi umai vesesal en out enek. ");
INSERT INTO pma_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Navong lumai vesesal ven Iesu, luvisohiso keih luvit, “!Natin Ahi! ?Kovoumon sa vatal komai? ?Kumai ekok keke kovasan mahien min komai kosa? ?Kirtosintei avong kati teni koa hemai veah?” ");
INSERT INTO pma_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Rovitei soutin, tali vuas otetai koa marite amul akanian. ");
INSERT INTO pma_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Sakini ninin tisa keil apeah Iesu avit, “Munak keik kihile lat komai, kisila lat komai meheha en vuas keil ke va ekek.” ");
INSERT INTO pma_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Sakini Iesu viteni min keil vit, “!Alva!” Ka keil uva ka uva neim en vuas keil. Ka hatte tas, tali vuas keil vasi enek amuloh avita en veisil, ka uva avamarindu en Mari Oai ten out Kaleli, ka keil vasi umatmat. ");
INSERT INTO pma_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ka meatin keil koa alei kat vuas keil enek ametau ka amuloh uva en taon. Ekonek, keil avit vasi tunien teni ka aviteni mun usil asa koa kur out en meatin keilu koa ninin tisa keil amul en keilu. ");
INSERT INTO pma_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Sakini, meatin vasi keil ten taon enek uva keke avales Iesu. Ka navong keil alesi, apeah Iesu keke heha ran atan one. ");
INSERT INTO pma_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Iesu ka meatin keil onen uvut en vot ka amu koteh Mari Oai ten out Kaleli uva en taon kati onen ten out Kapaniam. ");
INSERT INTO pma_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Navong arokol taon, meatin oteta keil avou kakan meatin tai koa usiven mat mai ven Iesu, meatin enek mules matil en vulin. Navong Iesu lesi keke demkatien one mul, kei viteni min meatin koa usiven mat vit, “Natkuli, konametautei. Ahi roleletei mun vatisa enuk ven tisaen keil onom.” ");
INSERT INTO pma_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Tei en tiser keil ten mengkatien onen Mosis aro vesesal, ka navong alonge mukok aviteni min keil eris avit, “!Ei, meatin ekek mul selus kekar va kat Ahi! !Kei enga vit kur keihoen suval onen Ahi, veni Ahi enges kilea vakulat tisaen!” ");
INSERT INTO pma_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ka Iesu kilea en asa amul amundemi. Sakini kei viteni min keil vit, “?Vensa mimul mivuli kat rendemien tatisa keil enek en tinomi? ");
INSERT INTO pma_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","?Koa kave mae imok keke naviteni, ‘Ahi roleletei mun vatisa enuk ven tisaen keil onom,’ vuo, ‘Kimea ka kikaka’? ");
INSERT INTO pma_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ka vasakin kami miheilea keke Natin Meatin kur keihoen en out netan voumon methos vatal min Ahi ka meatin, miheles koanik …” Ka Iesu viles les meatin koa usiven mat ka viteni mini vit, “!Kimea, kilum lat vulum, ka kiha ris teim som!” ");
INSERT INTO pma_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Hatte tas, meatin enek mea ka kaka va ris teim sen. ");
INSERT INTO pma_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ka navong meatin keil alesi, amutimanin ka ametau, ka amasmas Ahi koa san vati keihoen enek min meatin tai keke kilea voumon sakien koanek. ");
INSERT INTO pma_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ka navong Iesu lokovein out enek ka mul mual va, kei les meatin tai mul rondan en titi eim toumien onen, isen Matiu. Kei mul lah takis ran Siu keil keke vasani suk min kavmen ten out Rom. Ka navong Iesu lesi, vise vit, “!Amai! !Kusil kat nau ka kimai kihi meatin tai onak!” Ka Matiu mea, lokovein umen onen, ka musil kat Iesu. ");
INSERT INTO pma_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Matiu mulamun Iesu ka meatin keil onen uva en teim sen. Ka navong amul akanian, meatin houlu ten takis ka meatin sav keil koa atisa en meten Siu keil umai ka akanian vituai ral min Iesu ka meatin keil onen. ");
INSERT INTO pma_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Navong Farasi keil alesi mukok, avis meatin keil onen Iesu avit, “?Vensa tiser onami mul kanian vituai ral min meatin keil ten takis ka meatin tatisa keil mukok?” ");
INSERT INTO pma_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ka navong Iesu raengoni, kei viteni vit, “Meatin keil koa armesaitei arvatei avales dokta tai. Koakeil enges amesai uva avalesi. ");
INSERT INTO pma_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ka kami, miheha ka mihehotin aneite ten selusien onen Ahi koanek koa mul en Tus Votut koa vit, ‘Ek rovattei sanien votut keil enges onami, ka ek vat imok keke emi hemahis meatin sav keil.’ Veni narmaitei mahise meatin keil koa avit moulien one mal tuai keke avahiles avousil nau. Vuo, numai keke mahise meatin keil koa alei kilea tisaen keil one keke avahiles avousil nau.” ");
INSERT INTO pma_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Evus, meatin keil onen Sion Baptis umai ven Iesu ka avisi avit, “Avong houlu, komai ka Farasi keil meval ran anien ven hisien, ka melesi keke meatin keil onom armumontei sakien koanek. ?Vensa varei?” ");
INSERT INTO pma_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ka Iesu vit kesi min keil vit, “Navong meatin tai retalihe, meatin keil koa umai ven mari ale enek, asi keil veni. ?Mimundemi keke ilonge hetisa ka umon sakien ten tangien navong kei ro veah ral min keil? !Vuo, asakras! Ka avong tai mul mai koa meatin keil imai ka ikulat meatin enek ran keil. En avong enek varei, keil ilonge hetisa ka ihal ran anien.” ");
INSERT INTO pma_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ka Iesu vit ris tatavolien tamun min keil vit, “Meatin tovuol vatili koe eisin koa heite matu vatal soke kaliko hau. Veni navong akasi, hatte koa heite hau mai sim kati ka hetal vas koa heite matu, ka hesakin eisin enek hemahoi suk hemarite mok. ");
INSERT INTO pma_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","“Ka en vati sakien enek, meatin tovuol vatah uaen hau vaha en veite matu koa amumoni en hiliven sipsip veni kei keih tuai. Munak amumoni, uaen hau enek hetatahou ka hesipas veite enek. Hemukonek, hepurun veite enek ka uaen houele en atan. Sakini, meatin keil itah uaen hau heha en veite koa heite hau veni kei memerau veah, kilea vatatahou. Hesakini veite teni hetahos ka uaen koa mul ien emun hetahos.” ");
INSERT INTO pma_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Navong Iesu mul selus veah usil tounah keil enek, hetetamen tai onen Siu keil mai veni, retengeiril va netan mini ka viteni vit, “Natukahin mat keitinek. Kimai li ka kiling hem eni, ka hemoul eris.” ");
INSERT INTO pma_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Sakini, Iesu mea ka kei ral min meatin keil onen amusil hetetamen enek. ");
INSERT INTO pma_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ka navong amul uva, ahin tai mai katau en Iesu ka rokol kele eisin omon. Ahin enek, mesaien onen mama keil muasi sua teindan elu (12) ka reingeingeni vavus. ");
INSERT INTO pma_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Kei rokoli veni mundemi vit, “Vahit matokol kele eisin omon enges, malonge vatahos.” ");
INSERT INTO pma_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Navong ahin enek rokol eisin omon, Iesu viles, lesi ka viteni mini vit, “Mama, konametautei. Ven demkatien onom, mesaien onom vus tuai.” Ka en hati avong enesek, aven ahin enek mai ris tahos. ");
INSERT INTO pma_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Evus, amual uva arokol teim sen hetetamen enek. Ka navong uva neim, Iesu les tali meatin tai apilei en souen keil tatangien, ka meatin houlu asien out ka amul amurang keih ven atouli enek. ");
INSERT INTO pma_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ka Iesu viteni min keil vit, “!Alvaha! Titi atouli romattei, kei mules matil.” Ka meatin keil enek aviteai rohtoh en Iesu. ");
INSERT INTO pma_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ka navong asila lat meatin keil vasi enek uva hae, Iesu va neim. Kei va ven atouli ka vuli kat hen. Ka atouli enek moul eris, mulei ka mea. ");
INSERT INTO pma_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Longlongien ten asa koa kur out ka vasi out enek. ");
INSERT INTO pma_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ka navong Iesu lokovein teim sen hetetamen koanek ka mul mual va, metovar elu lumai veni lumusili. Ka luvisohiso keih mini luvit, “!Natin asuv houlu Deved! !Em hemahis komal eli!” ");
INSERT INTO pma_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Lumusili rokol avong koa Iesu va neim en eim tai. Ka navong uva neim, metovar elu lumai veni ka Iesu vis keilu vit, “?Mukave, milmundemi keke nakilea masak revi kamil?” Ka luvit kesi luvit, “O asuv, melkur anatin eni.” ");
INSERT INTO pma_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Evus, Iesu mutelan hen rokol metealu ka viteni vit, “Nasak revi kamil veni demkatien onamil mul.” ");
INSERT INTO pma_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ka metealu mai tahos ka lukilea luvalele. Ka Iesu meng kat keilu keih vit, “!Milnahitentei asa koa namumoni min kamil min meatin etai!” ");
INSERT INTO pma_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ka navong keilu luva rani, lumang vas ongealu houlu ka longlongien usil tounah koa Iesu mumoni min keilu ka vasi out enek. ");
INSERT INTO pma_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Navong keilu luva hae, meatin oteta keil akur ameng tai mai ven Iesu. Meatin enek sakras vaselus veni ninin tisa tai mul ien. ");
INSERT INTO pma_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ka navong Iesu vile lat ninin tisa enek va rani, meatin enek selus esuk. Navong vangi meatin keil alesi, amutimanin ka aviteni avit, “!Ei telmali, ir me-Isrel keil rorlestei veah etai tounah koa mukonek!” ");
INSERT INTO pma_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ka Farasi keil avit, “Meatin ekek kur keihoen keke vahile lat ninin tisa keil ka ven Temat koa vi asuv onen ninin tisa keil.” ");
INSERT INTO pma_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Iesu mual rokol taon keil ka meteimal vasi keil en out enek. Navong mul va, kei vihisei en eim tahihiseien onen Siu keil, vitehiten more longlongien usil hiasuvien onen Ahi, ka sak revi meatin vasi keil koa akur mesaien savsav keil. ");
INSERT INTO pma_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Navong kei les marmari vangi meatin keil, tin vilelau en enmahisien ven keil, veni rendemien one langlango ka areingeingeni avalekat kataunien en out kave. Iesu les keil asuval sipsip keil koa meatin talosilkatien one tovuol. ");
INSERT INTO pma_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Sakini kei viteni min meatin keil onen vit, “Anien houlu mules en ah, ka meatin toumien keil arvinvintei keke avaha avasuhut eni. ");
INSERT INTO pma_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Sakini, mihehis min Asuv ten ah keke hesila meatin toumien hehi houlu mun iha isuhut en ah osen.” ");
INSERT INTO pma_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Iesu vise meatin teindan elu (12) onen keke umai vesesal veni. Kei san keihoen min keil avahile lat ninin tisa keil ka avasak revi meatin vasi keil koa akur mesaien savsav keil. ");
INSERT INTO pma_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ka koanik isen eiloheh teindan elu (12) enek onen Iesu: Koa mulamu, Saemon (koa isen tamun Pita) ka Andru (tunali Pita). Tiemes (natin Sepeti) ka Sion (tunali Tiemes). ");
INSERT INTO pma_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilip, Batolomiu, Tomas, Matiu (koa lah takis), Tiemes (natin Alveas), ka Tatios. ");
INSERT INTO pma_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saemon (koa mul en vangi meatin keil koa e vati mok keke Siu keil avamaluv ran hen kavmen ten out Rom) ka Sudas Eskariot (koa hesa lat Iesu heha en hen meatin tatisa keil). ");
INSERT INTO pma_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Meatin teindan elu (12) enek onen, Iesu sila lat keil uva ral min selusien keil ekek: “Minahatei ven koakeil arvitei Siu vuo en taon keil onen me-Sameria keil. ");
INSERT INTO pma_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ka miheha enges ven me-Isrel keil koa asuval sipsip keil koa avupuol. ");
INSERT INTO pma_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ka navong mimul mivaha, mihehitehiten more longlongien enek min keil mihehit, ‘!Hiasuvien onen Ahi mul mai vesesal!’ ");
INSERT INTO pma_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mihesak revi meatin keil amesai, mihetali lat koakeil umat ran matien, mihesakin koakeil akur mesaien ten leprosi ave heto ris, ka mihehile lat ninin tisa keil ran meatin keil. Navong mihekataun meatin keil, mihesa maeni, veni tounah vasi koa kami mikuri, Ahi sa maeni min kami. ");
INSERT INTO pma_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","En ualien onami, minahuli kattei mani ");
INSERT INTO pma_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","vuo ateli. Minakurtei eisin tamun, sandel tamun, vuo eisal tamun. Naviteni mukok veni mal keke meatin toumien keil ikur anien en hen koakeil amum min keil. ");
INSERT INTO pma_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Navong mihemai en taon vuo meteimal tai, mihehotin meatin tai koa hesi kei keke vakur revi kami. Miheto en teim sen hetokol avong mihelokovein out enek. ");
INSERT INTO pma_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ka navong miva keke mivato en teim tai, helamu mihehiteni mihehit, ‘Tomat onen Ahi hel ven kami.’ ");
INSERT INTO pma_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Munak meatin keil en eim enek ikur revi kami, tomat onami hel en keil; ka munak keil isesein kami, mihekulat ris tomat onami ran keil ka miheha. ");
INSERT INTO pma_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ka munak meatin tei keil irkur revitei kami vuo e rovattei avalong selusien onami, mihemea ran keil. Ka navong mihemea ran teim se vuo taon one mihesahulin vulimeas ran alomi en mete. Koanek hesakin keil ilea suk keke amumoni romaltei en meten Ahi. ");
INSERT INTO pma_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Anatin eli naviteni min kami, en Avong koa ilei revi usite vasi onen meatin keil, mahien koa Ahi hesani min meatin keil koa aro en taon enek hekeih heli asa koa hesani min meatin keil koa aro en taon ten out Sodom ka Komorah mulamu.” ");
INSERT INTO pma_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Iesu sel kat meatin keil onen vit, “!Mihetaengonau! Inau namul nasila lat kami miva suval sipsip keil koa uva amul luhu en vangi huli rendan keil. Sakini, kami mihelele revi ka sakien onami hetolas. ");
INSERT INTO pma_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Anatin, mihelei kat revi kami, veni hetetamen keil onen Siu keil ihuli kat kami ka iling kami mihelomal en kot keil one. Keil itah kami en viau takan tai en eim tahihiseien keil one. ");
INSERT INTO pma_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ka veni mimusil kat nau, umon kami mihelomal en meten hetetamen keil ten kavmen ka asuv houlu keil emun. Ka hesakini miheilea mihehit lein more longlongien min hetetamen keil enek ka min koakeil arvitei Siu. ");
INSERT INTO pma_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ka navong ihuli kat kami, minandemkotei ven asa mivahiteni vuo hemukave mivahiteni. Veni en avong enek, Ninin Votut hesan asa koa kami mihehiteni. ");
INSERT INTO pma_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Anatin, hervitei kami koa miheselus, ka Ninin onen Ahi Tata heselus heka en kami. ");
INSERT INTO pma_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Meatin keil imae lat tue kati keil keke uas keil imat, ka tata keil umoni hemukonetinek min titae keil. Ka titiali keil emun ihiles min tata ka mama one keil ka imae lat keil keke meatin keil u vini keil. ");
INSERT INTO pma_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Meatin vasi keil tine heat kami veni mimusil kat nau. Ka kami koa mihelomal hekeih hetokol keite ten sakvisien keil enek, Ahi houtut moulien onami. ");
INSERT INTO pma_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Navong keil asan mahien min kami en meteimal tai, mihelohosai miheha en meteimal sav. Anatin eli naviteni min kami keke miherva vasitei mau en taon keil ten out Isrel, ka Natin Meatin hemai ris. ");
INSERT INTO pma_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Meatin koa kur hihiseien en tiser tai nandemtei nahit kei vi hetetamen imok lohlin tiser onen. Ka en vati sakien koanek, slev nandemtei nahit kei vi hetetamen imok lohlin masta onen. ");
INSERT INTO pma_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Sakini, kami koa mikur hihiseien keil onak, tahos mihesi kami keke mihemai mihesuval inau, tiser onami. Anatin, kami koa misuval slev keil onak, mihesi kami keke mihemai mihesuval asuv onami. Ka munak avise karen inau, avat onami, en ‘Belsepul,’ miheilea keke ihise karen kami mun mivi onak keil en tounah koa hetisa mok. ");
INSERT INTO pma_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Sakini, minametauntei keil. Tounah koa meatin sak visi vaav koe, Ahi helah lati hemai en mesai. Anatin tounah koa aling suaini, Ahi hesakini hemai en mesaiuai keke meatin keil ilei kilea eni. ");
INSERT INTO pma_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Tounah koa naviteni min kami enges en vongien, kami mihehit leini min meatin keil en meneai. Ka asa koa navit lelau eni min kami, mihehitehiteni en meten meatin keil. ");
INSERT INTO pma_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“Minametauntei koakeil akilea avou vini avemi ka asakras avou vini ninin onami. Tahos mihemetaun Ahi enges, koa kilea vapurun avemi ka ninin onami emun en Ahang koa sakras vavus. ");
INSERT INTO pma_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","En titi mani tas, mikilea mivahul titi aman valu. Ka munak Ahi Tata onami hermaentei, tai en keil sakras vamot vamat. ");
INSERT INTO pma_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ka kami emun, Ahi vuli vasin hilumi koa amul en vatumi. ");
INSERT INTO pma_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Sakini minametautei veni, en meten Ahi, kami mivi hetetamen imok mulin titi aman keil houlu. ");
INSERT INTO pma_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Meatin koa vit leini keke kei vi meatin onak en meten meatin sav keil, inau mun, nihit leini keke kei vi meatin onak en meten Tata onak en out nesa. ");
INSERT INTO pma_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ka koakeil aviteni en meten meatin keil keke aseseinau, inau mun nihiteni en meten Tata onak en out nesa keke nasesein keil. ");
INSERT INTO pma_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Minandemtei minahit inau numai keke maling tomat en out netan. !Vuo! Narmaitei keke maling tomat, numai masakin meatin keil ivae kat keil. ");
INSERT INTO pma_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Suval Tus Votut viteni, numai keke masakin … ‘meahos keil ihiles ivae hetal min tata one keil, atouli keil ihiles ivae hetal min mama one keil, ka ahineli keil ihiles ivae hetal min avu ahin one keil. ");
INSERT INTO pma_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Anatin, meatin hehi vativieh hetal min koakeil amul en teim kati osen.’ ");
INSERT INTO pma_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Koakeil envatien one mul en tata vuo mama one mulin inau, keil arvinvintei avahi meatin onak. Ka koakeil envatien one mul en ehon vuo atouli keil one mulin inau, keil arvinvintei avahi meatin onak. ");
INSERT INTO pma_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Koakeil arvustei aiveave ten mahien one keke avousil kat inau, keil arvinvintei avahi meatin keil onak. ");
INSERT INTO pma_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Koakeil asak visi keke avahuli kat moulien one en out netan, moulien ten lisenges hevuol ran keil. Ka koakeil amaen moulien one vavuol en out netan veni amusil kat inau, keil ikur moulien ten lisenges en out nesa. ");
INSERT INTO pma_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“En ualien onami, meatin koa hekur revi kami, hesuval koa mul kur revi inau. Ka koakeil akur revi inau, hesuval koa amul akur revi Tata onak koa sila nau numai. ");
INSERT INTO pma_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Anatin, meatin koa kur revi provet tai onen Ahi veni kei vi provet onen, Ahi hesan uite teni mini hesuval kei mun vi provet tai onen. Ka meatin koa kur revi meatin koa moulien onen mal veni kei mal, Ahi hesan uite teni mini hesuval kei mun vi meatin koa mal. ");
INSERT INTO pma_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ka meatin koa san tounah tai vakataun meatin tai onak koa vi havivi mok en meten meatin sav keil veni akilea kei musil kat nau, avaseini vi oai tamandil enges, anatin eli naviteni min kami, kei hekur vasin uite teni.” ");
INSERT INTO pma_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Navong Iesu sel kat meatin teindan elu (12) onen evus, kei sila lat keil avaha. Ka kei mun lokovein out enek ka va en taon sav keil en provins ten out Kaleli. Ka navong mual va, mul visein meatin keil ka vitehiten selusien onen Ahi min keil. ");
INSERT INTO pma_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","En avong enek, Sion Baptis mul veah en eim takeih. Kei raeng koteh usil tounah keil koa Iesu mul mumoni. Sakini, kei sila tei en meatin keil onen keke uva ven Iesu ka avahis revi usil umen onen. ");
INSERT INTO pma_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Sakini, keil umai ven Iesu ka avisi avit, “?Keik varei kovi Mesaea koa Ahi vat kati keke hesila hemai, vuo komai mehetosin meatin etai mun?” ");
INSERT INTO pma_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ka Iesu vit kesi min keil vit, “Miheha ris ka mihehiteni min Sion asa koa meraengoni ka melesi. ");
INSERT INTO pma_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Metovar keil akilea avalele, koakeil asakras avoual amual, koakeil akur mesaien ten leprosi ave tahos eris, koakeil ralinge vonhon araengon tounah, koakeil umat amoul eris, ka koakeil avi livere amul along more longlongien onen Ahi. ");
INSERT INTO pma_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ahi hetokol kat koakeil armottei en demkatien one venau.” ");
INSERT INTO pma_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Navong meatin keil onen Sion uva, Iesu selus min vangi meatin keil usili vit, “?Navong miva en out volvol keke mivales Sion Baptis, mimundemi mivales vati meatin sa? ?Miva keke mivales meatin koa rokeihtei suval oumunai tetaveah koa sakras valomal navong eang mul muhi? !Vuo! ");
INSERT INTO pma_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","?Ka asa varei mivit mivaha mivalesi? ?Meatin tai koa musin en mormore eisin keil? !Vuo! Veni meatin keil koa amusin mukonek aro en mari eim omon asuv houlu keil. ");
INSERT INTO pma_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","?Alhiteni minau, miva keke mivales asa varei? ?Provet tai? !Anatin! Ka naviteni min kami keke meatin enek vi hetetamen imok mulin provet sav keil. ");
INSERT INTO pma_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Veni Sion vi tai koa Tus Votut vit usili vit, ‘Kilesi. Inau nisila eiloheh onak helamu enuk. Kei heha mau keke vasak mesein sise ten amaien onom.’ ");
INSERT INTO pma_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Anatin eli naviteni min kami, meatin sav tovuol koa avasi en out netan koa vahi hetetamen imok valin Sion Baptis. Ka meatin kuren tai koa maen Ahi ten out nesa vahi asuv houlu onen, kei marite mok mulin Sion en meten Ahi. ");
INSERT INTO pma_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","En avong Sion mul vitehiten selusien onen Ahi rokol kosa, Ahi mul sakin hiasuvien onen vamai vakeih imok, ka koakeil akeih akapil ral mini. ");
INSERT INTO pma_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Veni tus keil onen provet vasi keil telamu ral min mengkatien keil onen Mosis aselus usil hiasuvien enek onen Ahi rokol avong koa Sion emai. ");
INSERT INTO pma_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ka munak kami mivasi kami keke mivakur anatinien eni, Sion vi Ilaetsa koa Ahi vat kati keke hesila hemai. ");
INSERT INTO pma_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Munak ralingomi mul, mihetaengon revi selusien koanik. ");
INSERT INTO pma_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“?Kami, meatin keil ten avong kosa, misuval asa? Kami misuval titiali keil koa arondan vesesal en out tahulhulien. Ka tei en keil amul avisohiso va min titiali sav keil avit, ");
INSERT INTO pma_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Navong komai memuas kitar en sien, kami emi rovattei keke mivahol vatal min komai. Ka navong komai memurang suval melonge tisa, kami emi rovattei keke mivouai vatal min komai.’ ");
INSERT INTO pma_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Kami misuval titiali keil veni emi rovattei inau vuo Sion emun. Navong Sion Baptis emai, kei mul val ran anien keke vahis ka romuntei uaen, ka kami miseseini mivit, ‘!Sion, ninin tisa mul ien!’ ");
INSERT INTO pma_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ka evus, navong inau, Natin Meatin, numai, nakanian ka namun uaen. Ka kami misesein inau mivit, ‘!Ales meatin ekek! Kei vi meatin taanien ka meatin tamunmunien. Kei mul vise meatin ten takis ka meatin tatisa keil en tuak.’ Ka meatin keil ilei kilea isei mul musil meteisauen onen Ahi ka en heite teni koa mul kistal en moulien onen.” ");
INSERT INTO pma_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Evus, Iesu selus keih kat meatin keil ten taon keil koa kei mumon merikel keil houlu en mete. Veni avaseini alesi, arvilestei moulien one ran sakien tatisa keil one. ");
INSERT INTO pma_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Kei viteni vit, “!Aue li! !Hetisa min kami, meatin keil ten out Korasin! !Ka hetisa mun min kami, meatin keil ten out Betsaeta! Veni kami milei sesein merikel koa namumoni en metomi, Ahi hesan mahien hehi houlu mok min kami. Munak meatin keil ten out Taer ka Saedon koa arvitei Siu, avales vati merikel keil koa namumoni en metomi, tuetin tuai, avasin en musi eisin ka avativin vulimeas en vate vatie lati keke avahiles ran tisaen keil one. ");
INSERT INTO pma_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ka anatin eli naviteni min kami, en Avong koa ilei revi usite vasi onen meatin keil, Ahi en hemahis meatin keil ten out Taer ka Saedon helin kami. ");
INSERT INTO pma_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","?Ka kami, meatin keil ten out Kapaniam, mimundemi keke Ahi hehati lat kami miheha en out nesa? !Vuo! !Kei heson kami miheha netan, en Ahang koa sakras vavus! Munak meatin keil ten out Sodom avales vati merikel keil koa namumoni en metomi, taon one val veah vatokol kosa. ");
INSERT INTO pma_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ka anatin eli naviteni min kami, en Avong koa ilei revi usite vasi onen meatin keil, Ahi en hemahis meatin keil ten out Sodom helin kami.” ");
INSERT INTO pma_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","En avong enek, Iesu viteni vit, “Tata, keik kovi Asuv ten out nesa ka ten out netan. Namasmasuk houlu mok veni keik koling suain tounah keil enek ran koakeil avi meteisau ka akileile. Ka korie lat aneite teni min koakeil asuval titiali koa arsukul revitei. ");
INSERT INTO pma_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Anatin Tata, koanik mul musil asa koa keik em vati vakistal. Anatin.” ");
INSERT INTO pma_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Navong Iesu vis evus, viteni min meatin keil vit, “Tata onak ling tounah vasi en hek. Meatin keil arlei kileatei Natin Ahi, Tamen enges lei kilea eni. Ka meatin keil arkileatei en Ahi, Natnali enges kilea eni. Ka koakeil enges Natnali enek en vati vahothot en Tamen min keil, keil emun ilea eni. ");
INSERT INTO pma_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Almai venau, kami keil koa milonge mah ven tounah tameas koa mimul mivousi en moulien onami, ka inau nisan sehien min kami. ");
INSERT INTO pma_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mihelong kat nau ka mihousil kat nau, veni inau namerau ka rendemien onak va netan. Hesakini, mihehotin sehien en moulien onami. ");
INSERT INTO pma_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ven hihiseien onak rokeihtei ka tounah koa nilingi en kami keke mivoumoni hemelalas.” ");
INSERT INTO pma_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","En avong enek, avong ten Sabat emai. Ka Iesu ka meatin keil onen amual koteh ah tai ten uit. Navong amul amual, meatin keil onen, amai kat keil, sakini amul alah uti uit keil ka amul akani. ");
INSERT INTO pma_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ka navong Farasi keil alesi, aviteni min Iesu avit, “?Kolesi? Asa koa meatin keil onom amumoni mul rali koteh mengkatien keil ten Sabat.” ");
INSERT INTO pma_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ka Iesu vit kesi min keil vit, “?Mukave? ?Kami mirvulitei asa asuv houlu Deved ka meatin onen keil amumoni navong amai kat keil? ");
INSERT INTO pma_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Deved va neim en Eim Tavolin onen Ahi ka alah veret votut koa pris keil enges akilea avaani. Ka Deved ka meatin keil onen akan veret enek, avaseini keke amul arali koteh mengkatien tai onen Ahi. ");
INSERT INTO pma_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","?Ka mukave? ?En out sav, mirvulitei keke en Sabat vasi keil, pris keil koa amum en Eim Votut amul arali koteh mengkatien ten Sabat, ka en meten Ahi armumontei tisaen? ");
INSERT INTO pma_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ka kosa, meatin tai ro ekok koa vi houlu mok mulin Eim Votut onen Ahi. ");
INSERT INTO pma_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Tus Votut mul viteni vit, ‘Ek rovattei sanien votut keil enges onami, ka ek vati mok keke emi hemahis meatin sav keil.’ Munak mikilea aneite ten selusien koanek, mivarsantei selusien takeih min koakeil armumontei tounah koa tisa. ");
INSERT INTO pma_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Meatin keil onak armumontei tisaen veni amusil kat inau, Natin Meatin, koa navi houlu mok mulin Sabat.” ");
INSERT INTO pma_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Evus, Iesu ka onen keil alokovein out enek ka uva neim en eim tahihiseien onen Siu keil. ");
INSERT INTO pma_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","En out enek, meatin tai mul koa hen kalkali. Ka meatin oteta keil emun amul en out enek ka e vat avaselus karen Iesu en tounah. Sakini keil avis Iesu avit, “Kihiteni min komai. ?Mengkatien onen Mosis maeni keke avasak revi meatin tai en Sabat?” ");
INSERT INTO pma_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Iesu vit kesi min keil vit, “?Mukave? ?Munak tai en kami, sipsip osen tai mot vita en avul en Sabat, houmon sa? Kei heha ka heleh lati rani. ");
INSERT INTO pma_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ka meatin tai vi tounah koa hetetamen imok mulin sipsip tai. Sakini mengkatien orer maen ir rovoumon sakien tahos keil en Sabat.” ");
INSERT INTO pma_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Evus, kei viteni min meatin koa hen kalkali vit, “Kitea en hem.” Sakin kei mutelan en hen ka hen mai ris tahos suval hen tateisav. ");
INSERT INTO pma_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ka Farasi keil uva hae ka arun lekat sise koa akilea avouas Iesu vamat ien. ");
INSERT INTO pma_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ka Iesu kilea en rendemien one; sakini kei lokovein out enek. Ka marmari vangi meatin keil amusili ka Iesu sak revi koakeil vasi amesai. ");
INSERT INTO pma_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ka kei meng kat keil keke anahitentei tounah koa mumoni min meatin sav keil. ");
INSERT INTO pma_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Kei mumon tounah enek vasakin asa koa Ahi viteni ka en provet Aesea vamai vahi anatin koa vit, ");
INSERT INTO pma_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Koanik meatin toumien onak koa narie lati, envatien onak mul ien ka nasi nau houlu mok veni. Nisien kati en Ninin onak, ka kei hehitehiten maluen onen Ahi min meatin vasi en out netan. ");
INSERT INTO pma_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Kei herseltei hetal min meatin sav vuo hermakultei. Meatin tovuol valong ren vaha nesa en sise. ");
INSERT INTO pma_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ven enmahisien, koakeil arkeihtei, kei hermumontei hekeih min keil. Ka koakeil amemerau, herpuruntei keil. Kei heles houm hemukonek hetokol avong koa hesakin sakien ten maluen helin sakien tatisa keil. ");
INSERT INTO pma_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ka vangi meatin vasi keil ten out netan iling desien one eni.” (Aes 42:1-4) ");
INSERT INTO pma_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Evus, meatin keil koa akur meatin tai va min Iesu. Meatin enek, meten var ka sakras vaselus veni ninin tisa mul ien. Ka Iesu sak revi ka meatin enek mai lele ka selus. ");
INSERT INTO pma_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Meatin keil koa alesi, amutimanin ka avit, “?Vahesa meatin enek vi kei koa hekistal heka en vatiamal onen asuv houlu Deved koa Ahi vat kati vit hesani hemai?” ");
INSERT INTO pma_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ka navong Farasi keil araengon selusien onen meatin keil aviteni min keil avit, “Ei, meatin enek kilea vahile lat ninin tisa keil ral min keihoen koa Belsepul, asuv onen ninin tisa keil, mul sani mini.” ");
INSERT INTO pma_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ka Iesu kilea en asa keil amul amundemi. Sakini kei viteni min keil vit, “Munak meatin keil onen asuv houlu tai amumon rea min keil eris, keihoen onen asuv houlu enek hevuol rani. Ka sakien enek vatte tas en taon vuo teim tai. Munak meatin keil teni ariti vas keil ka uvae kat keil eris, meatin keil enek ipurun taon one ka vatiamal one. ");
INSERT INTO pma_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Sakini, munak Temat mul vile lat onen keil, kei mul riti vas keihoen onen eris. Ka hemukonek, hiasuvien onen sakras valomal vakeih. ");
INSERT INTO pma_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","?Ka munak Belsepul mul san keihoen minau mahile lat ninin tisa keil, mukave en meatin keil onami koa keil emun amul avile lat ninin tisa keil? ?Keil amumoni ral min keihoen onen sei? Sakini, umen onen meatin keil onami enges mul rie lati keke selusien keil onami romaltei. ");
INSERT INTO pma_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ka munak namul navile lat ninin tisa keil ral min keihoen koa Ninin onen Ahi mul sani minau, koanek mul rie lati keke hiasuvien onen Ahi mai kistal en kami tuai. ");
INSERT INTO pma_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ka nihit kilea min kami hetal min tatavolien tai. Tarhena tai sakras vaha neim en teim sen avkeih tai navong kei ros teim. !Vuo! Helamu, heha hepar kat avkeih enek. Evus, kilea suk valah vasin tounah keil en eim onen. ");
INSERT INTO pma_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Koakeil arkapiltei vatal inau, keil uvae kat inau. Ka koakeil arkatauntei nau malah vituain meatin keil vasuval alah vituain sipsip keil, keil alikat rasilin keil. ");
INSERT INTO pma_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ka naviteni min kami, Ahi kilea valele vatahos eris en meatin koa mumon tisaen tateteisav keil vuo selus karen Ahi vuo tounah teisav. Ka meatin koa selus kekar va kat Ninin Votut, Ahi sakras emun valele vatahos eni. Anatin, Ahi hesan vasi mahien onen mini. ");
INSERT INTO pma_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Anatin, koakeil aselus tisa va kat nau, Natin Meatin, Ahi kilea valele vatahos eris min keil. Ka koakeil aselus tisa va kat Ninin Votut, Ahi herleletei hetahos min keil en avong kosa, vuo en avong keil koa hemai. ");
INSERT INTO pma_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Munak vatiai tai tahos, heite teni hetahos. Ka munak vatiai tai tisa, heite teni hetisa. Heiai koa vatiai tai mul soni mul rie lati keke vatiai enek tahos vuo tisa. ");
INSERT INTO pma_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","!Kami mivi vangi tetal tisa keil koa mimul mirili vini meatin keil en ongomi! ?Kami koa mivi meatin tisa keil, hemukave suk miheilea miheselus en tounah koa tahos? !Misakras! Veni meatin mul selus en tounah koa mul en tin. ");
INSERT INTO pma_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Meatin koa tahos, tin vilelau en rendemien tetahos, sakini mul selus en tounah koa tahos. Ka meatin koa tisa, tin vilelau en rendemien tatisa, sakini mul selus en tounah koa tisa. ");
INSERT INTO pma_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Naviteni min kami, en Avong koa ilei rahit usite vasi onen meatin keil, Ahi helei rahit selusien varu keil vasi koa meatin keil aviteni ka hesan mahien min keil veni. ");
INSERT INTO pma_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Anatin, hetal min selusien keil onami enges, Ahi hehothot eni keke kami mimal vuo mikalkali ka hesan asa koa mal min kami housili.” ");
INSERT INTO pma_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Evus, tiser otetai keil ten mengkatien onen Mosis ka Farasi keil umai ven Iesu ka avit, “Tiser, emai vati mevalesuk kovoumon etai merikel.” ");
INSERT INTO pma_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ka Iesu vit kesi vit, “Kami meatin keil ten avong kosa, emi vati mivales etai merikel keke mivakur anatin enau eni. Anatin, emi vati mivalesi veni mikalkali ka milokovein Ahi suval ahin tai koa lokovein meatin kati onen keke vamaen kei min meatin sav. Ka nirmumon etai merikel mivalesi, tanges varei mihelesi koa hehi merikel onen provet Siona. ");
INSERT INTO pma_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Veni suval provet Siona ro en vangen mari mesau meneai rokol vongien avong etel (3), en vati sakien enek inau, Natin Meatin, emun nito en vulvul ten matien meneai ka vongien avong etel (3). ");
INSERT INTO pma_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","En Avong koa ilei revi usite vasi onen meatin keil, meatin keil ten out Nineva ilomal ka iselus heha kat sakien onen meatin keil ten avong kosa. Anatin, keil iselus heha kat kami veni navong keil koa arvitei Siu along selusien onen Ahi koa provet Siona vitehiteni min keil, aviles ran tisaen keil one. Ka kosa, tai koa houlu mok mulin Siona ro ekok. ");
INSERT INTO pma_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Anatin, en Avong koa ilei revi usite vasi onen meatin keil, asuv houlu ten out Siba koa vi ahin helomal ka heselus heha kat meatin keil ten avong kosa. Veni kei ka en out tai koa soutin vis soutin keke vamai vataengon meteisauen onen asuv houlu Solomon. Ka kosa, tai koa vi hetetamen imok mulin Solomon ro ekok. ");
INSERT INTO pma_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Munak ninin tisa mea ran meatin tai, kei va en out tames valekat out tasehien keke vato ien. Ka munak hervotin etai out vato ien, ");
INSERT INTO pma_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","hehiteni min kei eris hehit, ‘Maha ris teim onak koa nalokoveini.’ Ka navong hemai heha ris eni, kei hehotini keke eim enek, ninin sav keil tovuol ien, amuteasi tuai, ka aling revi tounah keil koa mul ien. ");
INSERT INTO pma_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Sakini, kei heha ka hekur ninin oulu (7) koa atisa mok helin kei. Ka keil iha neim ka ito en out enek. Eim enek vi meatin tai, ka keil isakin moulien onen meatin enek hetisa mok helin koa mulamu. Koanik asa koa hekistal en kami, meatin tatisa keil ten avong kosa.” ");
INSERT INTO pma_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Navong Iesu mul semau selus min marmari vangi meatin keil, tunali keil ka mama onen umai. Umai avatimal hae ka avit avaselus vatal min Iesu. ");
INSERT INTO pma_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Sakini meatin tai mai ven Iesu ka vit meseini mini vit, “Mama onom ka tumali keil amul amulomal hae, ka e vati avaselus vatal minuk.” ");
INSERT INTO pma_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ka Iesu vit kesi mini vit, “?Isei vi mama onak? ?Isei vi tuak keil?” ");
INSERT INTO pma_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ka rie karahit meatin keil onen ka vit, “?Kolesi? Koakeil ekek avi mama onak ka tuak keil. ");
INSERT INTO pma_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Veni meatin koa mumon asa koa Tata onak en out nesa en vati, kei vi tuak ka ahinkuli ka mama onak.” ");
INSERT INTO pma_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","En avong enek, Iesu va hae ran eim enek ka rondan en valite ten Mari Oai ten out Kaleli. ");
INSERT INTO pma_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ka veni marmari vangi meatin keil alah ruai ka amuting rahiti, kei vut en vot ka rondan eni, ka vangi meatin keil amulomales ut. ");
INSERT INTO pma_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Evus, kei ra usil tatavolien houlu min keil vit, “!Mihelong revi! En avong tai, meatin tai va nah keke vativin uti uit keil. ");
INSERT INTO pma_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ka navong mul rivini, vahis umotmot en sise koa atan keih, ka aman keil umai ara lelati. ");
INSERT INTO pma_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Vahis umotmot en atan koa ahat houlu amul ien ka atan romarisotei. Ekok, uti uit keil enek avitehiteh kalah veni atan mahinhin enges. ");
INSERT INTO pma_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ka navong meteiai mea, kan lin keil, ka amaleles ka umat. Umat veni lite keil armoultei vahita netan. ");
INSERT INTO pma_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Vahis emun umotmot en atan koa oumunai tatisa mul ien, ka navong uti uit keil enek avitehiteh, oumunai tatisa enek amusar koe keil. ");
INSERT INTO pma_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ka vahis en uti uit keil enek umotmot en atan tetahos, amoul, ka ason heite. Koakeil ason heite houlu neli, koakeil araleha, ka koakeil emun araleh vini en heite. ");
INSERT INTO pma_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","!Munak ralingomi mul, mihetaengon revi asa namul naviteni!” ");
INSERT INTO pma_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Navong Iesu selus evus, meatin keil onen umai veni ka avisi avit, “?Keik kora usil tatavolien keil min meatin keil vensa?” ");
INSERT INTO pma_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ka Iesu vit kesi min keil vit, “Aneite ten selusien suai usil hiasuvien onen Ahi, kei mul sani min kami. Ka rosantei min meatin sav keil, mul suai veah en keil. ");
INSERT INTO pma_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Koakeil vasi akilea revi selusien onak, Ahi houmon keil ilea revi mok heha vio … ihilelau en ileilien onen. Ka meatin keil koa arkilea revitei, asa koa akuri, Ahi hekulati ran keil. ");
INSERT INTO pma_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Naselus min keil en tatavolien keil veni avaseini meatin keil alele, asakras avalei kilea eni. Anatin, avaseini keke alonge, arlong kileatei. ");
INSERT INTO pma_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Sakien one mul sakin selusien onen provet Aesea hemai hehi anatin koa vit, ‘Kami mihelonge heha vio … ka miherlong kileatei. Kami mihelele heha vio … ka miherlei kileatei. ");
INSERT INTO pma_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Veni meatin keil enek, tine keih. Ralinge mul ka e rovattei avalong tounah eni. Mete mul ka apol kati. Ka munak namukonek, keil akilea avalei kilea tounah en mete, ka akilea avalong kilea tounah en ralinge. Anatin, munak namukonek, ilea revi en aneite ten selusien onak en tine ka ihiles moulien one, ka inau nimai nisak revi moulien keil one.’ ");
INSERT INTO pma_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Ka tokolkatien onen Ahi mul tuai en kami, meatin keil onak, veni navong miles tounah en metomi, milei kilea eni, ka navong milong tounah en ralingomi, milong kilea eni. ");
INSERT INTO pma_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Anatin eli naviteni min kami, en avong telamu, provet keil houlu ka meatin sav keil koa amal en meten Ahi e vati mok avales asa kami mimul milesi, ka keil arlestei. Ka e vati mok avalong asa kami mimul milonge, ka keil arlongtei. ");
INSERT INTO pma_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Mihetaengon revi aneite ten tatavolien usil meatin koa rivin uti uit en atan tateisav keil. ");
INSERT INTO pma_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Uti uit keil koa umotmot en sise koa atan takeih mul ien, kei suval meatin tai koa long selusien usil hiasuvien onen Ahi ka rolong kilea revitei aneite teni. Ka Temat mai ka kalah kulat selusien koa aluhi mul en tin. ");
INSERT INTO pma_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Uti uit keil koa umotmot en atan koa ahat houlu mul ien, kei suval meatin koa long selusien onen Ahi ka, hatte tas, kei kuri ral min sien. ");
INSERT INTO pma_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ka veni lite ten demkatien onen romoultei veah vatahos, meatin enek mulomal avong havivis en demkatien onen. Ka navong sakvisien ka avong takeih keil emai ven selusien enek, hatte tas, kei mot en demkatien onen. ");
INSERT INTO pma_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ka uti uit koa umotmot en atan koa oumunai keil tatisa amul ien, kei suval meatin koa long selusien onen Ahi ka mundemko houlu usil tounah keil ten out netan ka mul en vat mani mok houlu. Sakini, tounah keilu enek mul sar koe selusien onen Ahi koa kei kuri ka rosontei heite en moulien onen. ");
INSERT INTO pma_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ka uti uit keil koa umotmot en atan koa tahos, kei suval meatin koa long selusien onen Ahi ka long kilea eni. Ka en moulien onen, selusien enek heson heite. En moulien onen koakeil, heson heite houlu; en koa mun, hetaleha; ka koa mun teisav, hetaleh vini en heite.” ");
INSERT INTO pma_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Iesu ra usil tatavolien tamun min meatin keil vit, “Hiasuvien onen Ahi suval meatin tai koa luh more uti uit en ah sen. ");
INSERT INTO pma_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ka navong meatin vasi keil amul amatil, vativieh tai emai en ah ten uit enek, ka rivin uti oumunai tatisa keil va ien ka muloh va. ");
INSERT INTO pma_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Sakini, navong uit keil avitehiteh, amoul avina nesa ka ason hungeite, oumunai tatisa keil emun amoul vituai ral min keil. ");
INSERT INTO pma_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Navong meatin toumien keil onen horetan koanek alesi mukok, uva ven masta one ka aviteni mini avit, ‘!Masta! ?Mukave? ?Uti uit koa kosani min komai keke merivini en ah som, keil atahos vuo atisa? ?Veni munak atahos, oumunai tatisa keil enek aka kave?’ ");
INSERT INTO pma_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Ka masta one vit kesi min keil vit, ‘!Vuo! Vativieh onak mumoni.’ “Sakini meatin toumien keil onen avisi avit, ‘?Ka mukave? ?Em vati keke komai mevaha mevahut lat oumunai tatisa keil enek?’ ");
INSERT INTO pma_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Ka masta one vit kesi min keil vit, ‘Vuo. Mihelokovein keil iles, veni hetisa munak miheahut lat uit tetahos keil navong mimul mivut lat oumunai tatisa. ");
INSERT INTO pma_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mihelokovein uit ka oumunai tatisa luhemoul out hetas hetokol avong tasuhutien. Hevus, nihiteni min meatin keil tasuhutien keke, helamu, ihut lelat oumunai tatisa keil ka ipar ruain keil il en vangite keil keke nimei nison keil iha en ahang. Ka hevus, iha ris isuhut en uit keil ka iling revi en vah onak.’” ");
INSERT INTO pma_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ka Iesu ra usil tatavolien tamun min mari vangi meatin keil vit, “Hiasuvien onen Ahi suval uti mastard koa meatin tai kuri ka luhi en ah sen. ");
INSERT INTO pma_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Avaseini keke uti mastard havivi mok en utiai sav keil, ka navong moul, mul moul tetaveah vina nesa va vio … mai mariso mok mulin tounah sav keil koa amul aluhi en ah. Ka navong matu, kei suval mari holeai tai koa vinvin keke aman keil avamai ka avoumon anu ome keil en angoite keil teni.” ");
INSERT INTO pma_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Iesu ra usil tatavolien tai mun eris min keil vit, “Hiasuvien onen Ahi suval hati is koa ahin tai kuri ka vilesi ral min mari bak pulaoa tai. Ka avaseini keke ling is koa havivis eni, is enek sakin pulaoa vasi retaho mai marite vis marite mok.” ");
INSERT INTO pma_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","En tounah vasi keil enek, Iesu selus usili min marmari vangi meatin keil en tatavolien enges. Kei rovit kileatei tounah min keil. ");
INSERT INTO pma_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Kei mumoni mukok keke voumon selusien onen Ahi koa sani min provet tai mai vi anatin koa vit, “Inau niselus en tatavolien keil; Anatin, en tatavolien keil, nihitehit usil tounah koa mul suai en avong koa Ahi mumon out netan rokol kosa.” ");
INSERT INTO pma_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Navong Iesu selus min marmari vangi meatin keil evus, lokovein keil ka va neim en eim koa ro ien. Ka meatin keil onen amusili, umai vesesal veni ka avisi avit, “?Tatavolien usil oumunai tatisa keil koa amoul en ah, kokilea kovahit kilea aneite teni min komai li?” ");
INSERT INTO pma_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Sakini, Iesu vit kilea min keil vit, “Inau, Natin Meatin, navi meatin koa rivin utiai koa tahos. ");
INSERT INTO pma_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ah enek vi out netan ka uti uit koa moul tahos vi meatin keil koa Ahi vi asuv houlu one. Ka oumunai tatisa keil avi meatin keil koa Temat vi asuv houlu one. ");
INSERT INTO pma_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ka vativieh koa rivin keil vi Temat. Suhutien enek vi avong koa out netan ka tounah vasi koa mul ien hevuol. Ka meatin keil tasuhutien vi angelo keil. ");
INSERT INTO pma_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“En sakien koa avut lelat oumunai tatisa keil ka ason keil uva en ahang, umon vati sakien enek navong out netan ka tounah koa mul ien hevuol. ");
INSERT INTO pma_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Anatin, en avong enek, inau, Natin Meatin, nisila angelo keil onak keke iha en out vasi koa nalosil kati keke ihut lelat koakeil vasi amum tisa ka tounah vasi keil koa amul asakin meatin keil umotmot en tisaen. ");
INSERT INTO pma_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Evus, angelo keil ison meatin tatisa keil iha en mari ahang, ka en out enek, meatin keil enek il is ka il ihal lohe ven mahien one. ");
INSERT INTO pma_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Hevus, koakeil amal en meten Ahi, muohien one hetitin hesuval meteiai en out koa hiasuvien onen Ahi, Tata one, mul ien. !Munak ralingomi mul, mihetaengon revi!” ");
INSERT INTO pma_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Iesu selus eris min meatin keil onen vit, “?Hiasuvien onen Ahi suval asa? Hiasuvien onen Ahi suval bokis tai koa tounah tetahos houlu amul ien koa meatin ling suaini en ah tai. Bokis enek mules, ka meatin sav tai mai ka votini. Navong lesi, longe tahos vis tahos imok. Sakini, ling suaini eris, va ris teim ka salem en tounah vasi keil onen. Evus, kur mani teni ka vul lat atan enek vahi onen. ");
INSERT INTO pma_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“?Anatin, hiasuvien onen Ahi hesuval asa? Hiasuvien onen Ahi suval meatin koa mul lekat tounah tetahos keil keke vasalem eni. Ka kei va valekat veimesau tetahos keil. ");
INSERT INTO pma_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ka navong votin veimesau tai koa tahos imok koa mani teni keih, kei va ris teim ka salem en tounah vasi keil onen. Evus, kur mani teni ka vul lat veimesau enek hehi onen. ");
INSERT INTO pma_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“?Anatin, avong tamun, hiasuvien onen Ahi suval asa? Hiasuvien onen Ahi suval net tai ten mesau. Navong asoni va en mari oai tai, alah mesau tateisav houlu keil eni. ");
INSERT INTO pma_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Navong net vilelau en mesau keil, alehei va ut. Evus, meatin keil ten mesau arondan rahiti ka aling revi mesau tetahos keil uva en veiat keil. Ka mesau keil koa atisa, asoni vaha. ");
INSERT INTO pma_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","En avong koa out netan ka tounah koa mul ien hevuol, angelo keil imai ilei kan meatin keil teni en vati sakien koanik. Keil ilah lat meatin keil atisa ran koakeil atahos, ");
INSERT INTO pma_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ka ison keil iha en mari ahang, ka en out enek, meatin keil enek il is ka il ihal lohe ven mahien one. ");
INSERT INTO pma_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“?Mukave, kami mikilea en tounah vasi keil enek, vuo …?” Ka meatin keil onen avit kesi mini avit, “Anatin, mekilea.” ");
INSERT INTO pma_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Iesu viteni min keil vit, “Musil sakien enek, tiser ten mengkatien onen Mosis keil vasi koa amul akur revi hihiseien usil hiasuvien onen Ahi, keil asuval hetetamen tai koa tounah tetahos houlu mul en teim sen. Kei kilea vaha neim keke vakur tounah tetahos tai koa heite hau, vatal min tounah tetahos emun koa vi heite matu.” ");
INSERT INTO pma_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Navong Iesu selus en tatavolien keil enek evus, kei lokovein out enek. ");
INSERT INTO pma_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Kei va ris en out Nasaret, meteimal kati onen. Ekonek, Iesu va en eim tahihiseien ka rondan visein meatin keil eni. Ka navong along hihiseien keil onen, amutimanin ka aviteni min keil eris avit, “?Meatin ekek kur ileilien ka keihoen enek kave? ");
INSERT INTO pma_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","?Rovitei kei keke vi natin meatin koa muti eim enges? ?Ka rovitei titan Meri, ka tunali Tiemes, Iosev, Saemon ka Sudas? ");
INSERT INTO pma_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","?Ka rovitei ahinali vasi keil keke aro en out ekek ral min ir? !Anatin, kei vi tai en ir enges! ?Ka out kave varei kur tounah keil ekek?” ");
INSERT INTO pma_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Sakini keil alei sesein Iesu. Ka Iesu viteni min keil vit, “Meatin vasi keil avouhou en provet tai onen Ahi. Ka en meteimal kati onen ka vatiamal kati onen emun, onen keil alei seseini varei.” ");
INSERT INTO pma_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Sakini en out enek, Iesu romumontei merikel keil vahi houlu veni demkatien one tovuol eni. ");
INSERT INTO pma_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","En avong enek, Asuv Herod Antipas koa losil kat provins ten out Kaleli raengon longlongien keil usil tounah koa Iesu mul mumoni. ");
INSERT INTO pma_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Sakini, viteni min hetetamen keil onen vit, “Iesu enek vi Sion Baptis varei. Avaseini kei mat, ka moul eris ran matien. Ven koanik, kei mul mumon merikel keil.” ");
INSERT INTO pma_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Asuv houlu Herod Antipas mundemko mukok veni kei varei san ren keke meatin keil tavaeen onen uva avuli kat Sion, apar kati, ka alingi en eim takeih. Kei mumoni mukok veni Sion sel kati keih vit, “Herod, sakien onom romaltei varei veni koretalihe ral min Herodias, ahin onen Pilip, koa vi tumali. Asa koa komumoni rali koteh mengkatien onen Ahi.” ");
INSERT INTO pma_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ka avaseini Herod vit vouas Sion vamat, kei romumontei veni metaun vurohien onen meatin keil veni amundemi keke Sion Baptis vi provet tai. ");
INSERT INTO pma_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ka en avong mal ten avong avasi asuv houlu Herod eni, amumon mari ale tai ka natnahin Herodias vol veni en meten meatin vasi keil. Sakini Herod si mok ");
INSERT INTO pma_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ka mumon hatkatien takeih min atouli enek keke hesani mini asa varei hehisi. ");
INSERT INTO pma_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Sakini, atouli enek va ven mama onen ka selus mini. Evus, mai ris ka viteni min asuv houlu Herod vit, “Keitinek, ek vati keke ku vini Sion Baptis. Evus, kisan vatin minau en out enek en tre tai.” ");
INSERT INTO pma_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Navong Herod longe, kei longe tisa vis tisa mok. Avaseini en rovattei vou vini Sion, kei san ren keke meatin keil onen avoum vousil envatien onen atouli enek. En rovattei vamemou en meten meatin keil veni alonge mumon hatkatien takeih tuai. ");
INSERT INTO pma_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Sakini meatin keil onen uva en eim takeih, ka ara koteh vatin Sion ran teiai onen. ");
INSERT INTO pma_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Navong amumoni evus, aling vatin Sion mul en tre tai, ka akuri asani min atouli enek koa kuri suk va ven mama onen. ");
INSERT INTO pma_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Navong meatin keil onen Sion alonge keke mat, umai avus teiai onen va, ka arahini. Evus, uva avit meseini min Iesu. ");
INSERT INTO pma_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Navong Iesu raengon longlongien keke Sion mat, kei vut en vot ral min onen keil keke avalis uva en out seh tai koa meatin keil tovuol ien. Ka navong meatin keil araengoni, keil aka en taon keil one ka akaka amusili. ");
INSERT INTO pma_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Sakini navong Iesu mea ran vot, kei les marmari vangi meatin keil amul arosini tuai. Navong les keil, en mahis keil ka sak revi koakeil one amesai. ");
INSERT INTO pma_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ka navong meteiai mul munu, meatin keil onen Iesu umai veni ka aviteni avit, “Out ekek vi out seh neli ka out mul vong ke. Tahos keke kisila marmari vangi meatin keil ihaha keke akilea avaha en meteimal keil ka avahul tei anien ae.” ");
INSERT INTO pma_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ka Iesu viteni min onen keil vit, “Ronasila lattei keil anahaha. Kami varei mihesan tei anien min keil iani.” ");
INSERT INTO pma_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ka avit kesi mini avit, “!Ei! ?Mehoumoni hemukave veni anien ar rovinvintei? Ekek, veret elim enges, ka mesau mun elu enges.” ");
INSERT INTO pma_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ka Iesu viteni vit, “Alkuri vamai minau.” ");
INSERT INTO pma_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Evus, kei viteni min marmari vangi meatin keil keke avatondan en more out koa oumunai mul ien. Navong arondan evus, kei kur veret koa heite elim ka mesau elu, seipat vina nesa, ka san masmasien min Ahi veni. Evus, kei vul vahas veret keil ka sani min meatin keil onen keke avatiti veret enek vatal min mesau vaha min marmari vangi meatin keil. ");
INSERT INTO pma_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ka meatin keil vasi akanian ka vange vil revi. Ka navong meatin keil onen Iesu uva ris keke avakur soke anien, veiat teindan elu (12) vil mules. ");
INSERT INTO pma_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ka en avong enek, amo keil koa akanian rokol taosen elim (5000). Ka ahin ka titiali keil arvulitei keil. ");
INSERT INTO pma_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Navong akanian evus, Iesu viteni min meatin keil onen keke ilamu eni, iha en usi Mari Oai ten out Kaleli. Ka kei enges ro vasila marmari vangi meatin keil avahaha. ");
INSERT INTO pma_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Navong sila meatin keil evus, kei mual vina nesa en vatihou tai kei sasen enges keke vahis. Ka navong vongien emai, Iesu enges ro en out enek. ");
INSERT INTO pma_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ka kei les vot mul luhu en Mari Oai ten out Kaleli ka onen keil avotini keih avahalis veni avisu min eang takeih tai. ");
INSERT INTO pma_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","En menauilan, out romulantei mau, Iesu mai ven keil, mul mual en oai suval mual en atan. ");
INSERT INTO pma_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ka navong meatin keil onen alesi mul mual en oai, keil ametau varei ka amis kai avit, “!Ei, ninin tai keinek!” ");
INSERT INTO pma_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ka hatte tas, Iesu selus min keil vit, “!Mihekeih! !Inau netin keinek! !Minametautei!” ");
INSERT INTO pma_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ka Pita vit kesi mini vit, “!Asuv, munak keik anatin, kihiteni minau moual en oai mahat venuk!” ");
INSERT INTO pma_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ka Iesu viteni mini vit, “!Amai!” Sakini Pita mea ran vot ka mual en oai va ven Iesu. ");
INSERT INTO pma_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ka navong les tahe keil amariso ka longe keke eang muhuh keih, Pita metau ka mul visair vita en oai. Navong lesi mukok, kei mis kai vit, “!Asuv, kikataunau li!” ");
INSERT INTO pma_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Hatte tas, Iesu san hen vuli kati ka vit, “!Demkatien onom havivi ramat! ?Vensa kormundesintei nau?” ");
INSERT INTO pma_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ka navong keilu luvut luva en vot, eang va netan. ");
INSERT INTO pma_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Navong alesi mukok, meatin keil koa amul en vot uva netan min Iesu ka aviteni mini avit, “!O anatin eli, keik varei kovi Natin Ahi!” ");
INSERT INTO pma_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Evus, keil amules amu koteh Mari Oai ten out Kaleli va vio … arokol ut en out Kenesaret. ");
INSERT INTO pma_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ka navong meatin keil ten out enek alei kilea en Iesu, asan selusien muloh rahit out vasi keil vesesal. Sakini, meatin keil alah koakeil vasi amesai umai ven Iesu. ");
INSERT INTO pma_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ka apeahi vamaen koakeil amesai avatokol kele eisin omon enges. Ka keil vasi koa arokoli, mesaien one va ran keil. ");
INSERT INTO pma_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","En avong tai, Farasi keil ka tiser keil ten mengkatien onen Mosis aka Serusalem umai ka avis Iesu avit, ");
INSERT INTO pma_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“?Vensa meatin keil onom armusil kattei sakien keil koa elda keil orer telamu asani min ir? !Veni onom keil arkastei he en sise koa muto, ka mukos, akanian!” ");
INSERT INTO pma_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Iesu vit kesi min keil vit, “?Ka vensa varei kami mirali koteh mengkatien onen Ahi varei keke mikilea mimusil hihiseien onami enges? ");
INSERT INTO pma_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Veni Ahi viteni vit, ‘Mihehouhou min tata ka mama onami keil.’ Ka vit risi vit, ‘Meatin koa hesili tata vuo mama onen, kei uasi hemat.’ ");
INSERT INTO pma_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ka kami, mivisein meatin keil keke akilea aviteni min tata ka mama one avahit, ‘Tounah keil onak koa nakilea makataun kamil eni, koanek naling koe tuai vi onen Ahi enges.’ ");
INSERT INTO pma_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Sakini, mivihisein meatin keil enek keke anahouhoutei mun min tata one vatal min tounah keil one. Sakini, hihiseien keil onami mul mumon selusien keil onen Ahi mai vi heisav enges. ");
INSERT INTO pma_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","!Kami mimutolas en hilivemi enges! Asa koa Ahi viteni usil kami ka en provet Aesea mal koa vit, ");
INSERT INTO pma_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Meatin keil ekek avouhou minau ral min selusien keil one, ka tine mul soutin ranau. ");
INSERT INTO pma_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Avaseini keil uva netan minau, ek rovattei mailea. Veni amul avisein meatin keil en hihiseien keil koa ka en meatin keil enges, ka aviteni min keil keke avi hihiseien keil kati onak!’” ");
INSERT INTO pma_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Evus, Iesu viles ka vise vangi meatin keil umai veni ka viteni min keil vit, “!Mihetaengon revi keke mivailea! ");
INSERT INTO pma_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Rovitei tounah koa va neim en ongon meatin vasakini kei varmutotei en meten Ahi. !Vuo, sakras! Ka selusien koa mea ran ongon, kei enges kilea vasakin meatin varmutotei en meten Ahi.” ");
INSERT INTO pma_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Navong alokovein meatin keil, meatin keil onen umai ven Iesu ka aviteni mini avit, “?Keik kokilea keke Farasi keil avuroh katuk navong along selusien onom?” ");
INSERT INTO pma_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Iesu vit kesi vit, “Farasi keil enek asuval vatiai keil koa Tata onak en out nesa roluhtei, iahut lati hetal lite keil teni. ");
INSERT INTO pma_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mihelokovein keil iles. Keil asak visi avalamun meatin sav keil ka avi metovar enges. Ka munak metovar tai helamun metovar tamun, keilu vasi luhemotmot luhehita en vulvul tai.” ");
INSERT INTO pma_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ka Pita viteni mini vit, “Kihit kilea aneite ten tatavolien koanek min komai li.” ");
INSERT INTO pma_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Evus, Iesu vis keil vit, “?!Kami emun, mirkileatei veah!? ");
INSERT INTO pma_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","?Mirkileatei keke tounah vasi koa va en ongomi vitas en vangomi, ka evus, mul mea ran avemi keke hehas hehi tahul? ");
INSERT INTO pma_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ka tounah koa miselus eni ral min ongomi kistal en tinomi, ka keil varei amul amumon meatin romutotei en meten Ahi. ");
INSERT INTO pma_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Veni navong tin meatin tisa, kei kilea voumon vati sakien keil ekek: mundem usil tounah tatisa keil, mu vini meatin sav keil, mul venan ahin sav, mul mum tisa ral min ahin sav keil, mul venan tounah, mul luvos meatin sav keil en kot, ka mul purun isen meatin keil. ");
INSERT INTO pma_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Sakien keil enek mul sakin meatin romutotei en meten Ahi. Ka munak meatin rokastei hen en sise koa muto mulamu en avong taanianien, koanek rosakintei meatin enek vamai varmutotei.” ");
INSERT INTO pma_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Evus, Iesu lokovein out enek ka va vesesal en meteimal keilu ten out Taer ka Saedon. ");
INSERT INTO pma_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ka ahin Kenan tai koa ro en out enek, mai veni ka peahi vit, “!O asuv eli, Natin Deved! !Em hemahis nau li! Ninin tisa tai mul en natukahin ka mul vareis puruni.” ");
INSERT INTO pma_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ka Iesu roviten etai selusien mini. Sakini meatin keil onen Iesu umai veni ka aviteni mini avit, “Kisila lat ahin enek heha veni kei mules visohiso keih ven ir.” ");
INSERT INTO pma_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Sakini viteni min ahin enek vit, “Ahi sila nau keke numai ven me-Isrel keil enges koa asuval sipsip keil koa avuol.” ");
INSERT INTO pma_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ka ahin Kenan enek mai ka retengeiril veni ka peah risi keih vit, “!O Asuv, kikataunau li!” ");
INSERT INTO pma_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ka kei vit kesi mini vit, “Romaltei keke avakur anien an titiali keil ka avasonis vaha min huli keil.” ");
INSERT INTO pma_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ka ahin vit kesi mini vit, “Asuv, koanek anatin eli. Ka huli keil emun koa amul rahiti akilea avaan soke anien koa asuv one kan rani.” ");
INSERT INTO pma_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Evus, Iesu viteni mini vit, “!Ei mama! !Demkatien onom mariso! Asa koa kovis inau eni, kei hekistal hehi anatin.” Ka hatte tas, natnahin mai ris tahos. ");
INSERT INTO pma_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Navong Iesu lokovein taon enek, kei ka onen keil uva amusil vali oai Kaleli. Ekonek, avina en usi hou tai ka arondan. ");
INSERT INTO pma_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ka marmari vangi meatin keil umai veni ka alah leimesai keil one: koakeil asakras avoual, metovar keil, koakeil ale kalkali, koakeil avi ameng, ka houlu emun koa amesai en mesaien savsav keil. Alah keil ka aling retai en keil vesesal en alen Iesu, ka kei sak revi keil vasi. ");
INSERT INTO pma_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ka navong meatin keil ales asa koa mumoni, amutimanin houlu veni koakeil avi ameng, aselus; koakeil ale kalkali, umai ris atahos; koakeil asakras avoual, amual; ka metovar keil, alele. Navong alesi, amasmas Ahi onen me-Isrel keil veni. ");
INSERT INTO pma_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Evus, Iesu vise ruain meatin keil onen ka viteni min keil vit, “Ek mahis meatin keil ekek veni keil aro ral minau avong etel tuai ka anien ae tovuol. Ek rovattei masila lat keil avahaha ris teim ose navong amai kat keil, veni vahesa ave hememerau ka mete hemalikelik en sise.” ");
INSERT INTO pma_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ka meatin keil onen avisi avit, “!Ka romul en out volvol! ?Rehehotin anien en out kave keke rokilea rovahengan marmari vangi meatin keil ekek?” ");
INSERT INTO pma_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Iesu vis keil vit, “?Veret ehis mikur kati?” Avit kesi avit, “Heite oulu (7) enges ka titi mesau vahis.” ");
INSERT INTO pma_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Sakini Iesu viteni min marmari vangi meatin keil keke avatontan en atan. ");
INSERT INTO pma_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Navong arondan evus, Iesu kur veret oulu (7) ka mesau vahis ka san masmasien min Ahi veni. Evus, kei vul vahasi ka sani min meatin keil onen keke avatiti vaha min meatin keil. ");
INSERT INTO pma_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ka keil vasi akanian ka vange vil revi. Ka navong meatin keil onen Iesu uva ris keke avakur soke anien keil, veiat oulu (7) vil mules. ");
INSERT INTO pma_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Amo keil koa akanian en avong enek arokol taosen ehat (4000). Ka arvuli lattei ahin ka titiali keil. ");
INSERT INTO pma_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ka navong Iesu sila marmari vangi meatin keil avahaha, kei ka onen keil uvut en vot ka uva en out koa avise en Makatan. ");
INSERT INTO pma_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","En avong tai, Farasi ka Satusi keil umai ven Iesu keke avasak visi. Sakini avisi voumon mari tounah tai avalesi vatie lati keke kei ka ven Ahi anatin. ");
INSERT INTO pma_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ka Iesu vit kesi min keil vit, “Navong meteiai munu, kami mivit, ‘?Kolesi? Teilang vilhili. Mul rie lati keke an hetahos visuvong.’ ");
INSERT INTO pma_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ka navong out mulan, kami mivit, ‘Kosa, ous hous veni teilang vilhili ka mahmah keil houlu.’ Milei kilea en sakien ten an keil, ka misakras mivalei kilea asa koa mul kur out en avong kosa. ");
INSERT INTO pma_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kami meatin keil ten avong kosa, emi vati mivales etai merikel keke mivakur anatin enau eni. Anatin, emi vati mivalesi veni mikalkali ka milokovein Ahi suval ahin tai koa lokovein meatin kati onen keke vamaen kei min meatin sav. Ka nirmumon etai merikel mihelesi, tanges varei mihelesi koa hehi merikel onen provet Siona.” Evus, Iesu lokovein keil, vut en vot ka va en out sav ral min onen keil. ");
INSERT INTO pma_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Navong Iesu ka meatin keil onen arokol usi Mari Oai ten out Kaleli, meatin keil onen amundem kati keke e vobong avakur veret ae. ");
INSERT INTO pma_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ka navong amual uva, Iesu viteni min keil vit, “Mihelei kat revi kami ven ‘is’ onen Farasi ka Satusi keil.” ");
INSERT INTO pma_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Navong alonge, amul aviteni min keil eris avit, “Kei mul selus min ir usil is veni rorkur etai veret vahi ar.” ");
INSERT INTO pma_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ka Iesu long kilea asa amul aselus usili, sakini va vis keil vit, “!Demkatien onami havivi ramat! ?Vensa mimul miselus min kami usil veret koa tovuol? ");
INSERT INTO pma_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","?!Mirkileatei veah!? ?Emi vobongeni tuai keke navengan amo keil taosen elim (5000) en veret elim enges? ?Ka veiat ehis vilelau keke kami misieni? ");
INSERT INTO pma_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","?Vuo mukave en avong navengan amo keil taosen ehat (4000) en veret oulu (7) enges? ?Veiat ehis vilelau mules koa kami misieni? ");
INSERT INTO pma_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","?Sakini, vensa kami mirkileatei keke narselustei usil veret? Ka mihelei kat revi kami ven is onen Farasi ka Satusi keil.” ");
INSERT INTO pma_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Sakini akilea suk keke rovitentei keke avalei kat revi keil ven is ten veret, ka ven hihiseien keil onen Farasi ka Satusi keil koa romaltei. ");
INSERT INTO pma_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Iesu ka meatin keil onen amual uva, akistal vesesal en taon ten out Sesaria-Pilipae. Ka en out enek, kei vis onen keil vit, “?Meatin keil aviteni keke inau, Natin Meatin, navi isei?” ");
INSERT INTO pma_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ka avit kesi mini avit, “Meatin tei avit kovi Sion Baptis. Ka teisav avit kovi provet Ilaetsa. Ka tateisav emun avit kovi provet Seremaea telamu vuo provet sav emun.” ");
INSERT INTO pma_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ka kei vis keil vit, “?Ka mukave en kami? ?Mivit inau navi isei varei?” ");
INSERT INTO pma_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ka Saemon Pita mea vit, “Keik kovi Mesaea. Anatin, kovi Natin Ahi koa moul.” ");
INSERT INTO pma_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ka Iesu viteni mini vit, “!Tokolkatien onen Ahi mul tuai enuk, Saemon natin Siona! Veni rovitei meatin keke vahothot enau minuk, ka Tata onak varei en out nesa mumoni. ");
INSERT INTO pma_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ka naviteni minuk keke kovi ‘Pita’ koa aneite teni vi ‘ahat.’ Ka en ahat koanek, numon Sios onak hel ien. Ka keihoen vasi ten matien sakras vamai vapuruni. ");
INSERT INTO pma_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nilingi en hem, ki keil ten hiasuvien onen Ahi. Sakini, asa koa koring koe en out netan, Ahi emun heting koe. Ka asa komaeni en out netan, Ahi emun hemaeni.” ");
INSERT INTO pma_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Evus, Iesu vit koe min onen keil keih anahitentei min etai meatin keke kei vi Mesaea koa Ahi vat kati keke hesani hemai. ");
INSERT INTO pma_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","En avong enek eva, Iesu vit kilea min meatin keil onen keke kei heha en out Serusalem. Ka navong itokol Serusalem, kei hekur mahien hehi houlu en hen elda keil, asuv keil onen pris keil, ka tiser keil ten mengkatien onen Mosis. Kei vit meseini min keil keke uasi hemat, ka en avong hetel, kei hemoul eris ran matien. ");
INSERT INTO pma_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Navong Iesu viteni mukok, Pita kur seheni havivi ka selus keih mini vit, “!Asuv, konaselustei namukonek! !Tounah enek sakras vakistal enuk!” ");
INSERT INTO pma_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ka Iesu viles, les Pita ka viteni mini vit, “!Komusil rendemien onen Temat, kiha ranau! Komul kosak visi keke kovoumonau masavoi en sise onak veni komusil rendemien onen meatin keil ten out netan enges, ka kormusiltei rendemien onen Ahi.” ");
INSERT INTO pma_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Evus, Iesu viteni min meatin keil onen vit, “Munak meatin etai en vati vousil nau, kei hesesein moulien onen, hehous aiveave onen, ka housil kat nau. ");
INSERT INTO pma_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Veni meatin koa en vati vahuli kat moulien onen, moulien enek hevuol rani. Ka munak hemaen moulien onen hevuol venau, kei hehotin moulien koa vi anatin. ");
INSERT INTO pma_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","?Asa tahos munak meatin tai kur tounah vasi ten out netan ka moulien onen mul vuol rani? !Tounah tovuol! Kei sakras vasan etai tounah keke vakur ris moulien onen. ");
INSERT INTO pma_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","“Inau, Natin Meatin, nimai ris hetal min muohien koa Tata onak hesani minau ka hetal min angelo keil onen. Ka en avong koanek, nisan retai en ui umen min meatin vasi keil housil asa koa keil amumoni. ");
INSERT INTO pma_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Anatin eli naviteni min kami, tei en kami koa mimul mimulomal ekok kosa, mihermattei mau ka mihelesi navong inau, Natin Meatin, nimai hetal min keihoen ten hiasuvien onak.” ");
INSERT INTO pma_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Avong ahetai (6) muli va, Iesu kur Pita, Tiemes ka tunali koa Sion telmusili ka mulamu en keitel telvina nesa en mari vatihou tai, en out koa keitel telro saseatel enges. ");
INSERT INTO pma_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ekonek, tellele telles aven Iesu viles. Veinan vihil suval meteiai, ka eisin omon vilahil muoh vis muoh suval laet. ");
INSERT INTO pma_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Evus, telmali telles Mosis ka Ilaetsa lumul luselus ral min Iesu. ");
INSERT INTO pma_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Navong Pita les keilu, viteni min Iesu vit, “!Asuv, tahos imok keke komaitel metro ekok! Munak keik em hehati, numon votevav hetel: tai onom, tai onen Mosis, ka tai onen Ilaetsa.” ");
INSERT INTO pma_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ka navong Pita mul veah selus, mahmah tai koa vihil mai mutaluh koe keil, ka along rea tai ka eni koa vit, “Koanik vi Natkuli kati ka envatien onak mul ien. Nasi nau houlu veni. !Mithelong kati!” ");
INSERT INTO pma_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Navong Pita keitel tellong rea enek, telmetau houlu ramat, telmotmot, ka naeatel vita rokol atan. ");
INSERT INTO pma_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Navong telmul veah netan, Iesu mai, rokol keitel, ka viteni vit, “Telmea. Mitnametautei.” ");
INSERT INTO pma_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ka navong tellele vina nesa, telroles etai mun meatin, Iesu enges ro ral min keitel. ");
INSERT INTO pma_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Navong telmita ris netan ran vatihou enek, Iesu meng kat keitel vit, “Mitnahitentei tounah koa mitlesi min etai meatin hetokol avong koa inau, Natin Meatin, nimoul eris ran matien.” ");
INSERT INTO pma_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ka telmali telvisi telvit, “?Vensa tiser keil ten mengkatien onen Mosis aviteni keke Ilaetsa hemae helamu en Mesaea koa Ahi vat kati?” ");
INSERT INTO pma_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Iesu vit kesi vit, “Anatin keke Ilaetsa hemae ka hesak mesein meatin keil ven amaien onen Mesaea. ");
INSERT INTO pma_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ka naviteni min kami keke Ilaetsa mai tuai ka meatin keil arlei kileatei. Keil amum tisa mini suval koa e vati. Ka en vati sakien enek, inau, Natin Meatin, emun nikur mahien en hen meatin keil.” ");
INSERT INTO pma_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Navong Iesu viteni mukok, keitel tellong kilea suk keke mul selus min keitel usil Sion Baptis. ");
INSERT INTO pma_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Navong Iesu keitel telsuvul ran vatihou enek, telvisu en vangi meatin keil. Ka meatin tai mai ven Iesu, retengeiril mini ");
INSERT INTO pma_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ka vit, “Asuv eli, em hemahis natkuli veni kei kur mesaien leimatmat ka mahien onen tisa mok. Avong houlu kei mot va en ahang vuo en oai. ");
INSERT INTO pma_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ka nakuri mai ven meatin keil onom ka asakras avasak revi.” ");
INSERT INTO pma_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Navong longe mukok Iesu viteni vit, “!Ekovei! !Kami meatin keil ten avong kosa, mikalkali ka demkatien onami tovuol vareis! ?Nito hetal kami hetokol nengeis? Avek mah en kami koa demkatien onami tovuol. Alkur ehon vamai venau ekok.” ");
INSERT INTO pma_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ka navong Iesu les ehon enek, vile lat ninin tisa koa mul ien ka va rani. Hatte tas, ehon enek mai ris tahos. ");
INSERT INTO pma_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Katau, navong Iesu ro sasen meatin keil onen umai veni ka avisi avit, “?Vensa varei komai mesakras mevahile lat ninin tisa enek vaha?” ");
INSERT INTO pma_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ka Iesu vit kesi min keil vit, “Veni demkatien onami havivi ramat. Anatin eli naviteni min kami, munak mikur kat demkatien koa havivis suval titi uti mastard, mikilea mivahiteni min vatihou enek mivahit, ‘Kimea ran out ekok ka kiha ke va,’ ka kei heha. Munak demkatien onami mul, tounah tovuol vakeih mivoumoni.” ");
INSERT INTO pma_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Amea ran out enek ka amual uva en provins ten out Kaleli. Ka navong amul amual, Iesu viteni min onen keil vit, “Hervitei tuetin, inau, Natin Meatin, isa lat nau niha en hen meatin keil ten out netan. ");
INSERT INTO pma_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Keil uas nau nimat, ka en avong hetel teni, nimoul eris ran matien.” Navong meatin keil onen alonge mukok, amundemko houlu. ");
INSERT INTO pma_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Avong tai, Iesu ka meatin keil onen amual ka akistal en taon ten out Kapaniam. Ekonek, meatin keil koa alah mani ten takis ten Eim Votut umai ven Pita ka avisi avit, “?Mukave? ?Tiser onom mul vul takis ten Eim Votut vuo rovultei?” ");
INSERT INTO pma_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ka Pita vit kesi min keil vit, “Anatin, kei mul vuli.” Ka navong Pita va neim en eim onen, roselustei veah ka Iesu visi vit, “?Mukave Saemon Pita? ?Komundem sa? ?Asuv houlu keil ten out netan alah takis ka duti ran isei? ?Alahi ran titae keil kati vuo alahi ran meatin sav keil?” ");
INSERT INTO pma_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ka Pita vit kesi mini vit, “Alahi ran meatin sav keil.” Iesu viteni mini vit, “Hemukonek, titae keil kati arvultei takis. ");
INSERT INTO pma_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ka avaseini keke Ahi koa vi Asuv Houlu en tounah vasi vi Tata oralu, lehul takis ten Eim Votut onen veni rotahostei lovoumon meatin keil enek avalele vatisa en ialu. Sakini kiha en Mari Oai ten out Kaleli ka kison huk onom. Mesau koa kisare helamu, kikoh vas ongon ka kihotin mani tai koa hevinvin en takis oralu. Kikuri ka kiha kisani min keil.” ");
INSERT INTO pma_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","En avong enek, meatin keil onen uva ven Iesu ka avisi avit, “?En hiasuvien onen Ahi, isei vi hetetamen imok?” ");
INSERT INTO pma_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Iesu vise titiali tai ka mumoni mulomal en mete. ");
INSERT INTO pma_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Evus, viteni min keil vit, “Anatin eli naviteni min kami, munak mihervilestei rendemien onami keke mihemai mihesuval titiali keil, kami misakras mivaha en out koa Ahi vi Asuv Houlu ien. ");
INSERT INTO pma_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Sakini, koakeil amumon rendemien one va netan suval titiali koanik, keil ihi hetetamen imok en out koa Ahi vi Asuv Houlu ien. ");
INSERT INTO pma_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ka meatin koa hekur revi titiali tai koa mukok en isok, hesuval koa kei mul kur revi inau. ");
INSERT INTO pma_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Ka munak meatin etai hesakin meatin tai koa musil kat nau suval titiali ekek hemot en tisaen, Ahi hesan mahien koa hetisa mok mini. Hetahos imok keke ipar kat mari ahat tai en hiren meatin enek ka imarindu eni en huinev ten atas. ");
INSERT INTO pma_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","!Anatin keke tounah koa hesakin meatin hemot en tisaen il imai, ka hetisa vis hetisa mok en koakeil avi sise teni! ");
INSERT INTO pma_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“!En vati rendemien enek, munak tai en kami, hen vuo alen sakin kei mot en tisaen, heta kotehei ka hesoni heha! Hetahos imok mini keke hati usiven hetisa ka hekur moulien ten lisenges helin munak hen vasi keilu ka alen vasi keilu hetahos ka isoni heha en ahang koa sakras vamat. ");
INSERT INTO pma_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","!Ka munak tai en kami, meten sakin kei mot en tisaen, hekis lati ka hesoni heha! Hetahos imok mini munak meten tai hevuol ka hekur moulien ten lisenges helin munak meten vasi keilu lumul ka isoni heha en ahang koa sakras vamat.” ");
INSERT INTO pma_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Navong titiali enek mules mulomal en mete, Iesu viteni min meatin keil onen vit, “Mihelei kat revi kami keke minalei seseintei meatin keil koa amusil inau suval titiali koanik. Anatin eli naviteni min kami keke angelo keil one aro en meten Tata onak en out nesa, ka ihit lati mini munak meatin tai mul purun keil. ");
INSERT INTO pma_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“?Kami mimundemi mukave? ?Munak meatin tai, sipsip osen keil avi handred tai (100) ka tai en keil vuol, houmon sa? ?Mimundemi keke helokovein sipsip sav keil osen koa avi hanumau ehat ka teindan ouhat emun (99) il en usi hou keke kilea vaha valekat sipsip koa vuol? !Anatin! ");
INSERT INTO pma_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ka anatin eli naviteni min kami, munak hehotini, kei hesi kei hemariso mok ven sipsip koanik mulin sipsip sav keil osen koa arvuoltei. ");
INSERT INTO pma_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","En vati sakien enek, Tata onami en out nesa en rovattei etai meatin koa musil inau suval titiali koanik vavuol.” ");
INSERT INTO pma_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Iesu mules selus min meatin onen keil usil tisaen keil vit, “Munak tumali mum tisa va katuk, keik kos kiha veni ka kitie mini asa koa mumoni romaltei va katuk. Munak kei hetaengonuk ka milhetalimal en usite onamil, keik kisik veni milheto hetahos eris. ");
INSERT INTO pma_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ka munak kei hertaengontei selusien onom, kiha ris veni hetal min meatin hetas vuo helu mun keke keilu luhelesi ka luheselus en usite onom keke kosak visi kovatalimal en kamil. ");
INSERT INTO pma_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ka munak tumali en rovattei vataengon kamitel, mithehitehiteni en meten meatin keil ten sios. Ka munak en rovattei vataengon meatin keil ten sios emun, mihelingi heha hae ka mihoumoni mini hesuval kei vi meatin koa rokileatei Ahi vuo meatin tisa tai suval koakeil alah takis. ");
INSERT INTO pma_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Anatin eli naviteni min kami, asa koa miring koe en out netan, Ahi ring koe tuai en out nesa, ka asa mimaeni en out netan, Ahi maeni tuai en out nesa. ");
INSERT INTO pma_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Anatin eli naviteni mun min kami keke munak elu en kami en out netan ekek milhemai en rendemien hetas usil tounah tai ka milhehis veni, Tata onak en out nesa hesan ui hisien onamil. ");
INSERT INTO pma_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Veni navong meatin elu vuo etel telmai out tas en isok, inau namul en out enek ral min keitel.” ");
INSERT INTO pma_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Evus, Pita mai ven Iesu ka visi vit, “?Asuv, munak tuak onak mum tisa va kat inau, numon methos hetal mini avong hehis? ?Hetokol avong oulu (7)?” ");
INSERT INTO pma_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Iesu vit kesi vit, “Vuo, rovitei avong oulu (7), ka kumoni avong hehi oulu (7), hevus, avong hehi oulu mun (7), hevus, avong hehi oulu mun (7) heha vio … kosakras kovahuli mun. ");
INSERT INTO pma_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Nihit kilea en sakien koanek en tatavolien tai. Hiasuvien onen Ahi suval asuv houlu tai koa en vati vasak revi en kaon onen eiloheh keil onen. ");
INSERT INTO pma_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Navong mul sak revi kaon keil, amulamun meatin tai koa kaon onen mulin gol mani milian halualim (10,000,000). ");
INSERT INTO pma_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ka veni sise tovuol keke meatin enek vahul kes kaon onen, asuv houlu onen meng kati keke avasalem en kei, ahin onen ka titaealu vasi keil avahi slev keil, ka avasalem en tounah vasi one emun. En sise koanek, asuv houlu vit mani teni hehul kes kaon onen. ");
INSERT INTO pma_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Navong meatin enek longe mukok, retengeiril en meten asuv houlu ka peahi keih vit, ‘!Aue li! !Kisani minau li avong havivi mun ka nihul kes tounah vasi koa mul en kaon onak!’ ");
INSERT INTO pma_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ka asuv houlu en mahisi, sahulin kaon onen ral mini, ka maeni maluv ka va. ");
INSERT INTO pma_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Ka navong meatin enek va hae, kei visu min eiloheh sav onen asuv houlu koa kaon onen mul ral mini koa vi gol mani vahis enges. Ka meatin enek, kei kin kat hiren varei ka viteni mini vit, ‘!Kihul kes mani vasi koa kokuri ranau!’ ");
INSERT INTO pma_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Ka eiloheh enek retengeiril en meten ka peahi keih vit, ‘!Aue li! !Kisani minau li avong havivi mun ka nihul kes tounah vasi koa mul en kaon onak!’ ");
INSERT INTO pma_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Ka meatin enek seseini. Kei va suk ka son eiloheh enek va en eim takeih rokol avong kilea vahul lat kaon onen. ");
INSERT INTO pma_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ka navong eiloheh sav keil ales asa koa kur out, keil alonge tisa houlu ka uva ven asuv houlu one ka avit vasin tounah mini. ");
INSERT INTO pma_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Evus, asuv houlu vise meatin enek emai ris veni ka viteni keih mini vit, ‘!Keik kovi meatin tai onak koa kotisa vis kotisa mok! Navong kopeah nau keke ek hemahisuk, inau nasahulin kaon onom ka namaenuk kova maeis. ");
INSERT INTO pma_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","?Sakini, vensa em romahistei eiloheh sav onak en vati sakien koa namumoni minuk?’ ");
INSERT INTO pma_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Asuv houlu tin kat meatin onen enek houlu, sakini sa lati vaha vakur mahien en hen meatin keil ten eim takeih hetokol avong hehul lat vasin kaon onen. ");
INSERT INTO pma_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Ka Tata onak en out nesa emun houmoni min kami vasi housil vati sakien enek munak mihermumontei methos hetal min tuomi keil en tinomi.” ");
INSERT INTO pma_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Navong Iesu selus en tounah keil enek evus, kei ka onen keil alokovein provins ten out Kaleli ka uva en provins ten out Sudea en usi Oaisal Sodan. ");
INSERT INTO pma_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Marmari vangi meatin keil amusili en out enek, ka kei sak revi keil. ");
INSERT INTO pma_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","En avong enek, Farasi keil koan umai veni keke avasak visi. Sakini avisi avit, “Hit visi min komai. ?Mengkatien orer maen meatin hetasil ran ahin onen ven rendemien vasi enges?” ");
INSERT INTO pma_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ka Iesu vit kesi min keil vit, “?Mukave, kami mirvulitei Tus Votut onen Ahi? Veni mul viteni keke mulamu, navong Ahi mumon tounah en out netan, kei ‘mumon meatin, tai mumoni vi meahos ka tamun mumoni vi ahin.’ ");
INSERT INTO pma_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ka viteni mun vit, ‘Ven koanek, meahos hemea ran tata ka mama onen, ka heapil hetal min ahin onen, ka keilu luhetas.’ ");
INSERT INTO pma_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Sakini keilu lurovitei mun elu, ka lumai lutas. Sakini asa koa Ahi kap vituaini, meatin enges noumontei natasil.” ");
INSERT INTO pma_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ka Farasi keil avisi avit, “?Mukonek, vensa varei Mosis meng kati vit, ‘Meatin koa vit valokovein ahin onen, hesan Setifiket ten Tasilien mini, evus, kilea vasila lati?’ ” ");
INSERT INTO pma_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ka Iesu vit kesi vit, “Mosis maen kami milokovein ahin keil onami veni vatumi keih ramat. Ka sakien enek tovuol en avong Ahi mum rohtoh en tounah vasi. ");
INSERT INTO pma_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ka naviteni min kami keke meatin koa lokovein ahin onen, koa romatiltei vatal min meatin sav tai, ka meatin enek kur ahin sav, en meten Ahi, meatin enek mul mum tisa ral mini.” ");
INSERT INTO pma_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Navong selus min keil evus, meatin keil onen Iesu aviteni mini avit, “Munak hemukonek en meatin hetal min ahin onen, hetahos imok keke meatin tai heto sasen ka hertetalihetei.” ");
INSERT INTO pma_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ka Iesu vit kesi min keil vit, “Rovitei meatin vasi koa kilea vousil hihiseien enek, ka meatin keil koan, Ahi san keihoen min keil keke avousili. ");
INSERT INTO pma_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ven meatin keil koan asakras avatetalihe veni out lou one tisa navong avasi keil. Ka meatin keil koan mun asakras avatetalihe veni meatin sav purun out lou one. Ka meatin tateisav emun amumon rendemien one keke anatetalihetei keke voum ven hiasuvien onen Ahi. Meatin koa kilea vousil sakien enek, tahos keke housili.” ");
INSERT INTO pma_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Evus, meatin keil akur titiali keil umai ven Iesu keke valing hen en keil ka vahis ven keil. Ka navong meatin keil onen ales keil avul kat keil. ");
INSERT INTO pma_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ka Iesu selus min keil vit, “Almaen titiali keil avamai venau ka minating koetei keil, veni Ahi vi asuv houlu onen vati meatin keil koa amukonek.” ");
INSERT INTO pma_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Sakini, navong umai veni, Iesu ling hen en keil ka san tokolkatien min keil. Evus, Iesu ka onen keil alokovein out enek. ");
INSERT INTO pma_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Navong Iesu mul mual va, meatin tai mai veni ka visi vit, “Tiser, numon sa koa hetahos keke nakilea makur moulien ten lisenges?” ");
INSERT INTO pma_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Iesu vit kesi vit, “?Kovis nau usil asa koa tahos vensa? Ahi enges, kei sasen tahos. Ka munak em vati kovakur moulien ten lisenges, kilong kat mengkatien keil onen.” ");
INSERT INTO pma_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Meatin enek visi vit, “?Ka mengkatien sa en keil?” Ka Iesu vit kesi vit, “‘Minouastei meatin namat. Minakurtei ahin vuo meatin onen hanu sav. Minahenantei tounah onen meatin sav. Minoumontei luvosien naha kat isen meatin sav. ");
INSERT INTO pma_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Mihehouhou min tata ka mama onami keil.’ Ka, ‘Envatien onami hel en meatin sav keil hesuval koa kami emi vat kami eris.’” ");
INSERT INTO pma_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ka meatin hau enek vit risi min Iesu vit, “Inau nalong kat mengkatien vasi keil enek. ?Asa tamun narvinvintei veah eni?” ");
INSERT INTO pma_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Iesu viteni mini vit, “Munak keik em vati kovamal vasi, kiha kisalem en tounah vasi onom ka kisan mani teni min koakeil tounah one tovuol. Ka munak kumoni hemukonek, tounah onom hehi houlu en out nesa. Hevus, kimai ris ka kusil nau.” ");
INSERT INTO pma_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ka navong meatin hau enek raengon selusien onen, kei longe tisa ka va rani veni tounah keil onen houlu ka en rovattei valokoveini. ");
INSERT INTO pma_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Evus, Iesu viteni min meatin keil onen vit, “Anatin eli naviteni min kami, hekeih vareis min meatin koa tounah onen houlu keke vamaen Ahi vahi asuv houlu onen. ");
INSERT INTO pma_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","?Mimundemi keke mari kamel tai kilea vakirisil en meten nidil tai koa havivi vis havivi mok? !Vuo, sakras! Ka meatin koa tounah onen houlu hekeih imok helin koanek keke vamaen Ahi vahi asuv houlu onen.” ");
INSERT INTO pma_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Navong meatin keil onen Iesu araengoni, keil amutimanin houlu ka avisi avit, “?Mukonek, isei suk kilea vakur moulien ten lisenges?” ");
INSERT INTO pma_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Iesu lei rahit en keil ka vit, “!Keinek! Meatin sakras voumoni, ka Ahi enges kilea voumon tounah vasi.” ");
INSERT INTO pma_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Evus, Pita viteni mini vit, “?Kolesi? Komai melokovein tounah vasi onomai keke mevousil katuk. ?Mukonek, Ahi hesan asa min komai?” ");
INSERT INTO pma_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ka Iesu viteni min keil vit, “Anatin eli naviteni min kami, en avong koa tounah vasi ten out netan hehi heite hau, inau, Natin Meatin, nitondan en vuluk ten keihoen hetal min muohien. Ka en avong enek, kami mun koa mimusil inau mihetondan retai en vulin ten keihoen teindan elu (12) ka mihelosil kat meatin vasi keil koa amul en mari vatiamal teindan elu (12) ten out Isrel. ");
INSERT INTO pma_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ka meatin vasi koa alokovein teim se, vuo tue keil, vuo ahine keil, vuo tata, vuo mama, vuo titiali, vuo ah se keil venau, Ahi hesan ris uite teni hehi houlu vis hehi houlu mok hehi handred tai (100) helin asa koa alokoveini. Ka katau en tounah keil enek, keil ikur moulien ten lisenges emun. ");
INSERT INTO pma_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ka houlu koa avi hetetamen kosa, imai ihi heisav enges, ka houlu koa avi meatin heisav kosa, imai suk ihi hetetamen keil.” ");
INSERT INTO pma_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Navong Iesu mul selus ral min meatin keil onen, ra usil tatavolien enek min meatin keil vit, “Hiasuvien onen Ahi suval horetan tai koa va en visokon semau keke valah meatin toumien keil avoum en neiai osen. ");
INSERT INTO pma_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Navong les keil, kei vat kati keke hesan ui umen min keil hemal en hulien ten avong tai. Evus, sila lat keil uva avoum en neiai osen. ");
INSERT INTO pma_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Navong meteiai va nesa neli, horetan enek va ris ka les meatin sav keil amules amulomal en out avulhul ien, ka armumon etai tounah. ");
INSERT INTO pma_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ka kei viteni min keil vit, ‘Ei, kami mun miheha mihoum en neiai osak, ka nihul kami en asa koa mal.’ ");
INSERT INTO pma_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Sakini, keil emun uva amum. “En taviai, kei va ris ka mumoni vati tas, ka en avong tamun navong meteiai vita netan neli. ");
INSERT INTO pma_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ka vesesal avong koa meteiai vanu, kei va eris ka votin meatin sav keil emun amules amulomal. Sakini kei vis keil vit, ‘?Vensa varei mimules mimulomal ekok ka mirmumon etai tounah visokon rokol mendilah?’ ");
INSERT INTO pma_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Keil avit kesi mini avit, ‘Veni meatin tovuol vamai vakur komai mevoum mini.’ “Sakini horetan enek viteni min keil vit, ‘Kami mun miheha mihoum en neiai osak.’ ");
INSERT INTO pma_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Navong meteiai munu, horetan ten neiai viteni min avat onen meatin toumien keil vit, ‘Kihise meatin toumien keil ka kisan ui umen one min keil. Helamu, kihul lat retai en koakeil umai katau heha vio … kivus en koakeil umai mulamu.’ ");
INSERT INTO pma_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Sakini, koakeil umai vesesal en avong koa meteiai vanu, keil umai ven avat toumien ka navong vul lat keil, sani min keil hulien koa mal vinvin ten avong tai, visokon rokol mendilah. ");
INSERT INTO pma_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Sakini, navong koakeil umai amulamu alesi, keil amundemi avit ikuri hemarite mok. Ka navong umai, keil emun akur retai en hulien koa mal vinvin enges ten avong tas. ");
INSERT INTO pma_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ka navong akuri, keil asel kutut kat horetan enek ");
INSERT INTO pma_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","avit, ‘Koakeil kovise keil katau, vesesal en avong koa meteiai vanu, amum haoa tanges, ka kovul keil vati tas en komai koa memum keih, avetin mue en komai ka meteiai kan purun avemai.’ ");
INSERT INTO pma_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Ka horetan enek vit kesi min tai en keil vit, ‘Tuak, narpuruntei kami. Kami mimaeni mivoum minau ven hulien koa mal vinvin ten avong tas. ");
INSERT INTO pma_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Mihekur mani onami ka miheha. Inau ek vati mahul koakeil umai akatau vati tas en kami. ");
INSERT INTO pma_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Koanek mani onak. Ka nakilea moumon asa ek vati vatal mini. ?Vuo mukave? ?Kami mevi elu veni nasan kataunien min meatin sav keil?’ ");
INSERT INTO pma_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Sakini, en sakien koanek, koakeil avi meatin heisav kosa imai ihi hetetamen imok, ka koakeil avi hetetamen imai ihi heisav enges.” ");
INSERT INTO pma_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Navong Iesu mul va en out Serusalem, kei kur teindan elu (12) onen uva seh ka viteni min keil vit, ");
INSERT INTO pma_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“?Milesi? Rovaha Serusalem ke. Ka en out enek, imae lat nau, Natin Meatin, niha en hen asuv keil onen pris keil ka tiser keil ten mengkatien onen Mosis. Hevus, keil ikuri iha en kot ka imae lat moulien onak hemat. ");
INSERT INTO pma_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Evus, isa lat nau niha ven meatin keil koa arvitei Siu keke umon tohtohien heha kat nau, itah nau en viau takan, ka iti kat nau en aiveave. Avong hetel heli heha, ka nimoul eris ran matien.” ");
INSERT INTO pma_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Evus, mama onen Tiemes keilu Sion, natin Sepeti keilu, mai ven Iesu ral min keilu. Kei malingling veni keke vahis tounah tai veni. ");
INSERT INTO pma_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Iesu visi vit, “?Mama, keik em vat sa?” Ka mama enek viteni mini vit, “Ek vati keke kimaeni li natkuli keilu ekek luvatondan vesesal venuk navong kimai kihi asuv houlu, tai en usivem matu ka tamun en usivem meil.” ");
INSERT INTO pma_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Iesu viles les natnali keilu ka vis keilu vit, “Kamil milreingeingen asa koa milmul milvis inau eni. ?Mukave? ?Kamil milkilea milvakur sakvisien ka mahien keil hesuval koa inau niha nikuri?” Ka luvit kesi mini luvit, “!Anatin, melkilea!” ");
INSERT INTO pma_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Iesu viteni min keilu vit, “Anatin, kamil milhekur mahien hesuval asa koa inau nikuri. Ka avaseini, hervitei inau keke matie lat isei hetondan en usivek matu vuo usivek meil. Vulin ten hetetamenien keilu enek onen koakeilu Tata onak rie lat keilu tuai keke luvakuri.” ");
INSERT INTO pma_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ka navong meatin sav keil onen Iesu koa avi halualim (10) araengoni, avuroh kat time keilu. ");
INSERT INTO pma_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ka Iesu vise ruain keil vasi umai veni ka viteni vit, “Mikilea keke hetetamen keil onen koakeil arvitei Siu e vati mok keke avoumon one keil avalei kilea en hetetamenien one. Ka asuv keil emun one amumoni keih ramat en meatin keil koa alosil kati. ");
INSERT INTO pma_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ka sakien onami hermukteinek. Munak kami tai en vati vahi houlu en kami, kei houmon kei hemai hesuval meatin toumien onami. ");
INSERT INTO pma_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ka munak tai en kami en vati valamu en kami, kei houmon kei hemai hehi slev onami. ");
INSERT INTO pma_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Veni inau mun koa navi Natin Meatin, narmaiteis keke meatin keil avoum avakataunau. !Vuo! Numai keke moum makataun meatin sav keil ka keke masan moulien onak vahul lat meatin keil houlu avamaluv ran keihoen ten tisaen one.” ");
INSERT INTO pma_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Iesu ka onen keil aka pas taon ten out Seriko, ka navong amuli uva, mari vangi meatin keil amul amusili. ");
INSERT INTO pma_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ekonek, metovar elu lurondan en vali sise ka luraengoni keke Iesu mul mual va. Sakini, keilu luvisohiso luvit, “!Asuv! !Natin asuv houlu Deved! !Em hemahis komal eli!” ");
INSERT INTO pma_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ka vangi meatin keil avul kat keilu keke luvato raeng. Ka avaseini, keilu luvisohiso keih imok luvit, “!Asuv! !Natin asuv houlu Deved! !Em hemahis komal eli!” ");
INSERT INTO pma_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Navong Iesu longe, vati ka vise keilu lumai. Evus, vis keilu vit, “?Emil vati moumon sa min kamil?” ");
INSERT INTO pma_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ka luvit, “Asuv eli, emal vati kovasak revi metomal.” ");
INSERT INTO pma_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ka Iesu, tin vilelau en enmahisien ven keilu. Sakini, rokol metealu, ka hatte tas, keilu lukilea luvalele ka lumusil Iesu. ");
INSERT INTO pma_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Navong Iesu ka onen keil umai vesesal en out Serusalem, keil akistal en meteimal ten out Betfas, vesesal en Hou Nei Olip. En out enek, Iesu sila meatin elu onen ");
INSERT INTO pma_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","vit, “Milheha en meteimal koa keisom. Ka hatte tas, milhehotin dongki tai asar kati ral min titan. Milheluvat keilu ka milheti keilu luhemai venau. ");
INSERT INTO pma_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ka munak meatin etai hesak visi keke heting koe kamil, milhehiteni mini milhehit, ‘Asuv en vat keilu,’ ka hatte tas, kei hemaen keilu.” ");
INSERT INTO pma_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Koanik kur out vasakin asa koa Ahi viteni ka en provet onen mai vi anatin koa vit, ");
INSERT INTO pma_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Kihiteni min meatin keil koa aro en taon ten out Serusalem kihit, ‘!Mihelesi! Asuv houlu onami mul mai keke valosil kat kami. Kei, sakien onen merau enges, ka mul muloh en dongki tai. Anatin, mul rondan en sili dongki tai enges ka mul mai.’” ");
INSERT INTO pma_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ka meatin keilu onen Iesu luva ka lumumoni suval koa Iesu viteni. ");
INSERT INTO pma_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Keilu luri dongki ka titan. Evus, lukuvin kot onealu en dongki keilu enek ka Iesu rondan eni. ");
INSERT INTO pma_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Marmari vangi meatin keil umai ka asak mesein revi sise keke Iesu voual ien. Keil avuen kot keil ome en sise ka teisav en keil amusah oumeil ka aling revi en sise. ");
INSERT INTO pma_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Houlu en mari vangi meatin keil enek koa uva amulamu en Iesu ral min koakeil akatau emun avisohiso vina nesa avit, “!Masmasien min Natin asuv houlu Deved! ‘!Tokolkatien hel en kei koa mai en isen Iahova!’ !Masmasien hehina min Ahi en out nesa!” ");
INSERT INTO pma_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ka navong Iesu kistal en out Serusalem, longlongien enek ka vasi taon ka me-Serusalem vasi keil amutimanin ka arun usili houlu “?Isei enek koa mul mai?” ");
INSERT INTO pma_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ka marmari vangi meatin keil avit kesi avit, “Koanik vi Iesu, provet tai ten out Nasaret en provins ten out Kaleli.” ");
INSERT INTO pma_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Navong arokol Serusalem, Iesu va neim en teahu ten Eim Votut ka likat rasilin meatin vasi keil koa asalem en tounah vuo amul avul tounah eni. Kei vou vilehiles avet onen koakeil amul akekes en mani ka out tatondanien onen koakeil asalem en ame keil avahi sanien votut. ");
INSERT INTO pma_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ka navong mumoni, sel kat keil vit, “En Tus Votut amutisi avit, ‘Eim onak ihise en Eim Tahisien.’ Ka kami mimumoni suk mai vi ‘Eim mon tarhena keil.’” ");
INSERT INTO pma_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ka navong Iesu mul en teahu ten Eim Votut, metovar keil ka koakeil asakras avoual umai veni ka kei sak revi keil. ");
INSERT INTO pma_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","En avong enek emun, titiali keil amul avisohiso en teahu ten Eim Votut avit, “Masmasien min Natin asuv houlu Deved.” Ka navong asuv keil onen pris keil ka tiser keil ten mengkatien onen Mosis ales mormore tounah keil koa Iesu mumoni ka alonge asa koa titiali keil avisohiso eni, tine vepeng houlu. ");
INSERT INTO pma_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Sakini keil avis Iesu avit, “?Koraengon asa titiali keil ekek amul aviteni?” Ka Iesu vit kesi vit, “Anatin, nalonge. ?Mukave, kami mirvulitei Tus Votut onen Ahi? Veni kei mul vit, ‘Ahi, keik kosak mesein sise keke kilong masmasien hehat minuk, heka en titiali ka tivava keil.’” ");
INSERT INTO pma_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Evus, Iesu lokovein keil ka mea ran out Serusalem. Kei ka onen keil uva en taon ten out Betani, ka en out enek, amatil. ");
INSERT INTO pma_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","En visokon semau, navong Iesu mul mual va ris en out Serusalem, amai kati en sise. ");
INSERT INTO pma_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ka les vati fik tai mul en vali sise. Ka navong va vesesal veni, votini keke heite tovuol, les outes. Sakini, Iesu viteni min vati fik vit, “!Heiai hetovuol emun enuk!” Ka hatte tas, vati fik enek mukou. ");
INSERT INTO pma_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Navong meatin keil onen Iesu alesi, amutimanin ka avisi avit, “?Vati fik enek mukou hatte tas mukave?” ");
INSERT INTO pma_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ka Iesu vit kesi min keil vit, “Anatin eli naviteni min kami, munak demkatien onami mul ka mihermundem maentei asa koa mivisi, kami mikilea mivoumon asa koa namumoni en vati fik. Ka roviteis koanik, mikilea emun mivahiteni min hou koanik mivahit, ‘Kimea ran vulum ka kiso sasom enuk kiha en atas,’ ka hekur out. ");
INSERT INTO pma_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Munak mikur anatin keke tounah hekistal, tounah vasi koa mihehis Ahi veni, hekistal hehi anatin.” ");
INSERT INTO pma_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Navong arokol Serusalem, Iesu va en teahu ten Eim Votut. Ka navong kei mul visein meatin keil, asuv keil onen pris keil ka elda keil umai veni ka avisi avit, “?Keik komul komumon tounah keil ekek en isen isei? ?Isei maenuk kovoumoni?” ");
INSERT INTO pma_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ka Iesu vit kesi min keil vit, “Inau mun, mahis kami en tounah tai. Munak mihehit kesi minau, inau mun nihiteni min kami isei maen nau moumon tounah keil enek. ");
INSERT INTO pma_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Alhit visi minau. ?Isei maen Sion vahi baptaes en meatin keil? ?Ahi vuo meatin enges?” Keil aselus rahiti min keil eris avit, “?Rehehiten sa? Munak rehehit ‘Ahi maeni,’ kei hehiteni min ir hehit, ‘?Mukonek, vensa suk mirkurtei anatin en selusien onen?’ ");
INSERT INTO pma_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ka munak rehehit, ‘Meatin maeni,’ rehemetau en mari vangi meatin keil veni keil vasi amundemi keke Sion Baptis vi provet tai onen Ahi.” ");
INSERT INTO pma_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Sakini, avit kesi min Iesu avit, “Komai merkileatei isei maeni.” Ka Iesu viteni min keil vit, “Mukonek, inau mun nirvitentei isei maen nau moumon tounah keil ekek.” ");
INSERT INTO pma_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ka Iesu ra usil tatavolien tai min keil vit, “?Kami mirendem sa? Meatin tai, natnali elu. Avong tai, meatin enek va ven moeite ka viteni mini vit, ‘Natkuli, kosa, kiha kum en neiai oseratel.’ ");
INSERT INTO pma_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Ka natnali enek vit kesi mini vit, ‘Ek rovattei.’ Ka katau, rendemien onen viles ka va mum. ");
INSERT INTO pma_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Evus, tata va ven natnali tamun ka viten selusien vati tas. Ka natnali enek vit risi mini vit, ‘Tahos tata, niha.’ Ka evus, kei rovatei. ");
INSERT INTO pma_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“?Isei en keilu mumon asa tata en vati?” Keil avit, “Kei koa mulamu.” Iesu viteni min keil vit, “Anatin eli naviteni min kami, koakeil alah mani ten takis ka hoeaso keil, Ahi mul mai vi Asuv Houlu en moulien one mulamu en kami. ");
INSERT INTO pma_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Veni Sion mai ven kami keke vatie sise ten maluen mivousili. Ka kami mirkurtei anatin en selusien onen, ka koakeil akur mani ten takis ka hoeaso keil alonge ka akur anatin en selusien onen. Ka avaseini miles asa koa amumoni, mirvilestei ran tisaen onami ka mirkurtei anatin eni.” ");
INSERT INTO pma_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Evus, Iesu ra usil tatavolien tamun min keil vit, “En avong tai, horetan tai luh neiai osen. Kei mumon vieh karahiti, ka kil avul tai koa vi out koa avita lin heiai ien keke vasakin site vakistal rani. Evus, muti avet tai vina nesa taleikokoeien. Navong mumoni evus, kei maen meatin sav keil umai alei kati ka keil avat kati keke isan hati heiai keil mini navong men. Evus, kei va en ualien tai. ");
INSERT INTO pma_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Avong houlu mai muli, heiai men. Sakini, horetan enek sila slev keil onen uva keke avahis koakeil alei kat neiai osen avasan hati heiai mini. ");
INSERT INTO pma_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ka navong arokol neiai, meatin keil koa alei kati avuli kat slev keil onen: tai amu puruni, tamun amu vini, ka koa etel en keil, akove. ");
INSERT INTO pma_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Evus, horetan enek sila slev sav keil koa avi houlu mok mulin koa sila mulamu. Ka meatin keil koa alei kat neiai enek amumoni vati tas min keil. ");
INSERT INTO pma_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Katau en keil vasi, horetan sila natnali va ven keil veni kei viteni min kei sasen vit, ‘Keil ihouhou min natkuli.’ ");
INSERT INTO pma_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Ka navong koakeil alei kat neiai ales natnali, aviteni min keil eris avit, ‘!Ei, natin horetan kati keisom! Kei varei hekur neiai koanek navong tata onen hemat. !Almai, rovou vini! !Hesakini, tounah keil onen hemai hehi orer esuk!’ ");
INSERT INTO pma_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Sakini keil uva avuli kati, alisi va hae ran neiai enek, ka amu vini.” ");
INSERT INTO pma_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Evus, Iesu vis hetetamen onen Siu keil koa araengon tatavolien enek vit, “?Ka mukave? ?Navong horetan ten neiai enek hemai ris, houmon sa min meatin keil enek?” ");
INSERT INTO pma_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ka keil avit kesi avit, “Kei hesa kes matien koa tisaso min meatin tatisaso keil enek. Evus, hemaen neiai onen heha min meatin sav keil koa isani mini hati heiai koa men en avong mal teni.” ");
INSERT INTO pma_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Evus, Iesu viteni min keil vit, “?Mukave, kami mirvulitei Tus Votut? Veni kei viteni vit, ‘Pos koa meatin keil toumien alei seseini, kei varei mai vi more vatiseng kati ten eim mulin pos sav keil. Koanik, Iahova mumoni, ka rolesi tahos imok!’ ");
INSERT INTO pma_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Sakini, naviteni min kami, tahosien ten hiasuvien onen Ahi koa mimul mikuri, Ahi helah lati ran kami Siu keil, ka hesani suk min meatin keil ten kantri sav koa akilea along kat ren ka ason heite en moulien one. ");
INSERT INTO pma_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Koakeil asesein vatiseng enek, imot eni ka sie hemavulvul varei. Ka munak vatiseng enek hemot heta kat keil, ave hemakoako.” ");
INSERT INTO pma_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Navong asuv keil onen pris keil ka Farasi keil along tatavolien keil onen Iesu, akilea keke mul selus usil keil. ");
INSERT INTO pma_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Sakini keil alekat sise avahuli kati, ka ametaun marmari vangi meatin keil veni keil amundemi keke Iesu vi provet tai. ");
INSERT INTO pma_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Navong Iesu ro veah en teahu ten Eim Votut, mules ra usil tatavolien keil min meatin keil vit, ");
INSERT INTO pma_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Hiasuvien onen Ahi suval asuv houlu tai koa sak mesein mari anien tai ven tetaliheien onen natnali. ");
INSERT INTO pma_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Kei sila slev keil onen keke avahise koakeil asuv houlu enek sisil en keil tuai keke avamai en anien. Ka meatin keil enek e rovattei avamai. ");
INSERT INTO pma_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Sakini, asuv houlu enek sila slev sav keil onen ka viteni min keil vit, ‘Miheha mihehit meseini min koakeil nasisil en keil mihehit: “Milesi, inau nasak mesein anien houlu tuai: amuas buluk keil osak ka titan buluk keil emun koa navengan revi keil ven anien ten kosa. Anatin, tounah vasi ten anien ten tetaliheien mas tuai. Sakini almai.”’ ");
INSERT INTO pma_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Ka meatin keil enek e rovattei availea ren ka uva suk en umen one. Tai va en ah sen, ka tamun va voum en sitoa onen. ");
INSERT INTO pma_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ka meatin sav keil avuli kat slev keil onen, apurun keil ka amu vini keil. ");
INSERT INTO pma_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ka navong asuv houlu enek longe, tin katiat vis katiat. Sakini sila meatin tavaeen keil onen ka amu rasilin koakeil amu vini slev keil onen ka amunit lin taon one. ");
INSERT INTO pma_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Evus, asuv houlu enek viteni min slev sav keil onen vit, ‘Anien ten tetaliheien mas tuai, ka koakeil nasisil en keil tuai, moulien one rovinvintei keke avamai avaani. ");
INSERT INTO pma_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Sakini, miheha en sise keil ten taon ka mihesisil en meatin keil vasi koa mihehotini keke imai ian anien ten tetaliheien koanik.’ ");
INSERT INTO pma_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Sakini uva en sise keil ka avise ruain meatin vasi keil koa avotini, koakeil atahos ka koakeil atisa. Ka eim taanien ten tetaliheien vilelau revi en meatin keil. ");
INSERT INTO pma_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Koakeil asisil va ven keil, umai amusin en more eisin keil ten tetaliheien. Ka navong asuv houlu mai neim vales koakeil umai, lesi keke meatin tai romusin entei eisin ten tetaliheien. ");
INSERT INTO pma_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Sakini asuv houlu mai veni ka visi vit, ‘!Ei tuak! ?Keik kumai neim ekok mukave keke kormusin entei eisin ten tetaliheien?’ Ka meatin enek ro raeng, reingeingen asa vahiteni. ");
INSERT INTO pma_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Evus, asuv houlu viles ka meng kat meatin toumien keil onen vit, ‘Mihepar kat hen ka alen, ka mihelisi heha hae en mankoli. En out enek, meatin keil il is ka il ihal lohe ven mahien one.’” ");
INSERT INTO pma_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ka Iesu selus ekor en tatavolien enek vit, “Anatin, Ahi sisil en meatin houlu avamai veni, ka vahis enges, rie lat keil avato vesesal veni.” ");
INSERT INTO pma_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Navong Farasi keil along tatavolien keil koa Iesu viteni va kat keil, uva ka arun lekat sise keke avakaluvati en selusien onen. ");
INSERT INTO pma_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Sakini asila tei en meatin one ral min Siu tateisav keil koa asi keil ven losilkatien onen asuv houlu Herod Antipas. Keil umai ven Iesu ka aviteni mini avit, “Tiser, mekilea keke keik kovi vati meatin koa meatin sav keil akilea avaling desien one val enuk. Ka mekilea emun keke komul kovisein meatin keil en sise koa Ahi en vat meatin keil avousili musil anatinien onen. Keik kormundemtei vahi houlu usil hetetamenien onen meatin keil, ka kormaentei rendemien onen meatin keil enges analehtei rendemien onom. ");
INSERT INTO pma_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Mukonek, kisani min komai rendemien onom en usite koanik. ?Hemal enges keke ir, Siu keil, rehehul takis heha min asuv houlu ten out Rom, vuo romaltei?” ");
INSERT INTO pma_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ka Iesu lei kilea rendemien tatisa one ka vit kesi min keil vit, “!Kami mitahos imok en hilivemi enges! ?Vensa misak visi keke mivakaluvat inau? ");
INSERT INTO pma_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Altie minau mani koa amul avul takis eni.” Navong asani mini ");
INSERT INTO pma_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","vis keil vit, “?Nan isei ke? ?Isen sei mul en mani enek?” ");
INSERT INTO pma_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Keil avit kesi avit, “Koanek onen Sisa, mari asuv houlu ten out Rom.” Sakini Iesu viteni min keil vit, “Sakini, mal keke mihesani min Sisa asa koa vi onen, ka mihesani suk min Ahi asa koa vi onen.” ");
INSERT INTO pma_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ka navong keil alonge, keil amutimanin en selusien onen Iesu. Evus, alokoveini uva. ");
INSERT INTO pma_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","En avong enesek, Satusi keil, koa avit meatin sakras vamoul eris ran matien, umai ven Iesu ka avisi avit, ");
INSERT INTO pma_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Tiser, Mosis mutis mengkatien koanik vit, ‘Munak meatin tai mat ran ahin onen ka titaealu tovuol, tunali suk hetetalihe hetal vatina onen. Hesakini, navong luhekur ehon, ilesi hesuval natin meatin koa mat.’ ");
INSERT INTO pma_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Mulamu, time oulu (7) aro ekok ral min komai. Koa moeite retalihe, ka navong mat, titan tovuol. Sakini kei lokovein vatina vatetalihe vatal min tunali. ");
INSERT INTO pma_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Tounah kistal vatte tas en tunali koa katau. Ka en koa etel en keil emun, vatte tas va vio … sakien enek kistal en koa tasikor en time keil enek. ");
INSERT INTO pma_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ka katau en keil vasi, ahin enek emun mat esuk. ");
INSERT INTO pma_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","?Sakini, navong meatin vasi keil imoul eris ran matien, isei en time oulu (7) enek hekur ahin enek hehi onen veni keil vasi aretalihe ral mini?” ");
INSERT INTO pma_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Iesu vit kesi min keil vit, “Kami mimul milei ras sise onami veni mirkilea revitei Tus Votut onen Ahi vuo keihoen onen. ");
INSERT INTO pma_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ven en avong koa meatin keil imoul eris ran matien, isuval angelo keil en out nesa, tetaliheien hetovuol. ");
INSERT INTO pma_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","?Ka vensa mirkurtei anatin eni keke meatin keil imoul eris ran matien? ?Mirvulitei asa koa Ahi viteni min kami? Veni kei vit, ");
INSERT INTO pma_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Inau navi Ahi onen Ebraham, Ahi onen Aesak, ka Ahi onen Siekob.’ ?Milonge? Kei vi Ahi onen koakeil amoul, rovitei onen koakeil umat.” ");
INSERT INTO pma_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ka navong marmari vangi meatin keil alonge, keil amutimanin en hihiseien onen. ");
INSERT INTO pma_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Navong Farasi keil alonge keke Iesu sakin Satusi keil, ahang one mat, keil alah ruai ka uva ven Iesu. ");
INSERT INTO pma_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Tai en keil koa vi tiser ten mengkatien onen Mosis, mai ka vit vakaluvat Iesu en selusien onen. ");
INSERT INTO pma_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Sakini visi vit, “?Tiser, mengkatien koa kave varei keke houlu mok en keil vasi?” ");
INSERT INTO pma_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ka Iesu vit kesi mini vit, “‘Emi hehat Iahova koa vi Ahi onami en tinomi, en moulien vasi keil onami, ka en rendemien vasi keil onami.’ ");
INSERT INTO pma_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Mengkatien koanik vi houlu mok ka mulin keil vasi. ");
INSERT INTO pma_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ka tamun suvali koa elu en keil mul vit, ‘Envatien onom hel en meatin sav keil hesuval koa keik em vat keik eris.’ ");
INSERT INTO pma_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Tounah vasi koa mul en mengkatien onen Mosis ka hihiseien keil onen provet keil mul tuai en mengkatien keilu ekek.” ");
INSERT INTO pma_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ka navong Farasi keil aro vituai ral mini, Iesu vis keil vit, ");
INSERT INTO pma_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“?Kami mimundem sa usil Mesaea? ?Kei hekistal en vatiamal onen sei?” Keil avit kesi avit, “Hekistal en vatiamal onen asuv houlu Deved telamu.” ");
INSERT INTO pma_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Iesu viteni min keil vit, “?Munak koanek anatin, vensa varei Ninin onen Ahi san rendemien min Deved keke vahise Mesaea enek en ‘Asuv’? Veni viteni vit, ");
INSERT INTO pma_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Iahova viteni min Asuv onak vit, “Kitondan ekok en usivek matu, hetokol avong niling koakeil avi vativieh ral minuk iha en hem.”’ ");
INSERT INTO pma_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Asuv houlu Deved varei vise Mesaea en ‘Asuv onen.’ ?Ka veni tata tai sakras vahise natnali en ‘asuv,’ Mesaea heka en vatiamal onen Deved hemukave?” ");
INSERT INTO pma_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ka meatin keil asakras avahit kesi. Ka en avong enek muli va, meatin keil ametauni keke avahisi en etai mun tounah. ");
INSERT INTO pma_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Navong Iesu mul veah en teahu ten Eim Votut, selus min marmari vangi meatin keil ka min onen keil vit, ");
INSERT INTO pma_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Tiser keil ten mengkatien ka Farasi keil amul akur vulin Mosis keke avit kilea mengkatien keil onen Ahi min meatin keil. ");
INSERT INTO pma_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Sakini, kami mihelong kat keil ka mihousil tounah vasi koa keil aviteni mivoumoni. Ka minaleisungeintei sakien keil one, veni keil armusiltei asa koa amul avisein meatin sav keil eni. ");
INSERT INTO pma_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Keil aling kat mengkatien tameas houlu en eisilin meatin keil. Ka keil, e rovattei avasan he avakataun keil avahousi. ");
INSERT INTO pma_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Koakeil enek, tounah vasi amumoni, amumonis avaleh meten meatin sav keil eni keke avahouhou min keil. Munak meatin sav keil apar kat titi bokis en hen koa selusien onen Ahi mul ien, koakeil enek amumon one marmariso mok. Munak meatin sav keil amumon kele eisin ome taveah, koakeil enek amumon ome tetaveah ramat. ");
INSERT INTO pma_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","En mari anien keil ka en eim tahihiseien emun, keil alei kan out tatondanien keil tetahos koa asak koe ven hetetamen keil. ");
INSERT INTO pma_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","En out tahul tounah ien, e vati mok navong meatin keil aviten ‘more’ min keil ral min houhouen ka avise keil en ‘hetetamen.’ ");
INSERT INTO pma_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Ka kami, anahisetei kami en ‘hetetamen’ veni hetamen onami tas, ka kami vasi mivi time keil. ");
INSERT INTO pma_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ka minahisetei meatin etai en out netan en ‘tata’ veni Tata onami tas, kei enges koa ro en out nesa. ");
INSERT INTO pma_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ka tamun, anahisetei kami en ‘tiser’ veni tiser onami tas, kei vi Kristo. ");
INSERT INTO pma_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Kei koa mul kataun kami sav suval vi eiloheh onami, kei hemai hehi houlu mok en kami. ");
INSERT INTO pma_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Veni koakeil aling rendemien one vina nesa, Ahi heling keil iha netan, ka koakeil aling rendemien one vita netan, Ahi hehati lat ise. ");
INSERT INTO pma_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“!Hetisa mok min kami tiser keil ten mengkatien ka Farasi keil koa mimusil kat Ahi en hilivemi enges! Ahi hesan mahien min kami veni miring koe sise onen meatin keil anahatei vesesal ven hiasuvien onen Ahi. Anatin, avaseini e vati avoumon Ahi vahi asuv houlu one, kami emi rovattei, ka miring koe meatin sav keil anoumontei. ");
INSERT INTO pma_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“!Hetisa mok min kami tiser keil ten mengkatien ka Farasi keil koa mimusil kat Ahi en hilivemi enges! Ahi hesan mahien min kami veni mika koteh atas ka atan keke mivahotin meatin tai ka mivahiles rendemien onen vousil kat kami. Ka navong kei viles musil kat hihiseien keil onami, kami mimumoni mai tisa revi mok mulin kami keke mal revi kei mun hekur mahien en ahang koa sakras vavus suval onami. ");
INSERT INTO pma_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“!Hetisa mok min kami koa misak visi keke mivalamun meatin keil, avaseini mivi metovar keil! Mahien koa mihekuri hemariso mok veni mimul mivisein meatin keil mivit, ‘Munak meatin mumon hatkatien onen en isen Eim Votut, hatkatien onen vi heisav enges. Ka munak mumon hatkatien onen en isen gol koa mul en Eim Votut, kei hehatimal hekeih en hatkatien onen.’ ");
INSERT INTO pma_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","!Kami metovar keil, mivi vau! ?Koa kave houlu mok, gol ten Eim Votut vuo Eim Votut varei koa mul sakin gol enek vi votut? ");
INSERT INTO pma_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ka kami mivisein meatin keil emun mivit, ‘Munak meatin mumon hatkatien onen en isen ahor ten sanien, hatkatien onen vi heisav enges. Ka munak mumon hatkatien onen en isen sanien koa alingi ien, kei hehatimal hekeih en hatkatien onen.’ ");
INSERT INTO pma_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","!O kami koa metomi var! ?Koa kave houlu mok, sanien vuo ahor ten sanien koa mul sakin sanien enek mai vi votut? ");
INSERT INTO pma_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Sakini, meatin koa mumon hatkatien onen en isen ahor ten sanien mul mumoni mun en isen tounah vasi koa mul ien. ");
INSERT INTO pma_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ka meatin koa mumon hatkatien onen en isen Eim Votut, kei mul mumoni en isen Ahi koa ro ien. ");
INSERT INTO pma_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ka meatin koa mumon hatkatien onen en isen out nesa, kei mumoni en isen vulin ten keihoen onen Ahi ka en isen kati onen kei koa mul ien. ");
INSERT INTO pma_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“!Hetisa mok min kami tiser keil ten mengkatien ka Farasi keil koa mimusil kat Ahi en hilivemi enges! Ahi hesan mahien min kami veni milong kat titi mengkatien keil suval sakien koa misan taet ten titi ouai keil takukien min Ahi. Ka mengkatien keil koa houlu mok, suval mengkatien keil keke mivatie sakien ten maluen, enmahisien ka demkatien, kami mirlong kattei. Hetahos imok munak mihelong kat mengkatien koa houlu mok hetal min koakeil avi havivi mok emun. ");
INSERT INTO pma_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","!Avaseini mivi metovar, misak visi mivalamun meatin sav keil! Kami misev revi en oai mami keke mivarmuntei titi neno tai koa romutotei, ka mimea mirem vasi mari kamel tai koa tisa mok. ");
INSERT INTO pma_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“!Hetisa mok min kami tiser keil ten mengkatien ka Farasi keil koa mimusil kat Ahi en hilivemi enges! Mahien onami hemariso mok veni moulien onami suval veioai ka pelet onami koa mikas motein revi out hae enges. Ka uaen ka anien koa mul en keilu, mikuri en sakien ten keihoen ka metenan. ");
INSERT INTO pma_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","!Kami mivi metovar varei! Helamu, mihekas motein out neim en tounah keil en moulien onami. Hemukonek, out hae emun hetolas. ");
INSERT INTO pma_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“!Hetisa mok min kami tiser keil ten mengkatien ka Farasi keil koa mimusil kat Ahi en hilivemi enges! Kami misuval tehitan keil koa amum revi ka akasi en oai tamuoh. Out hae, alesi tahos, ka out neim vilelau en sin meatin ka tounah sav keil koa tisa vis tisa mok. ");
INSERT INTO pma_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","En vati sakien enek, mimal revi en hilivemi enges, ka en tinomi neim, mivilelau en luvosien ka tisaen. ");
INSERT INTO pma_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“!Hetisa mok min kami tiser keil ten mengkatien ka Farasi keil koa mimusil kat Ahi en hilivemi enges! Mahien onami hemariso mok veni mimum revi tehitan keil onen provet keil ka mimosan en tehitan onen koakeil amal. ");
INSERT INTO pma_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ka mimul miviteni mivit, ‘Munak komai mevato en avong onen avu onomai keil telamu, komai mevarlah ruaitei vatal min keil navong amu vini provet keil.’ ");
INSERT INTO pma_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ekek, ral min selusien kati onami, miviteni anatin keke mivi vatiamal kati onen koakeil amu vini provet keil. ");
INSERT INTO pma_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ka en avong keil onami, mihoum vasin asa koa avu onami keil telamu amum rohtoh eni. ");
INSERT INTO pma_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“!Kami mivi tetal tisa keil! !Anatin, kami mivi vangi tetal tisa keil koa mimul mirili vini meatin keil en ongomi! ?Mihelohosai ran mahien ten ahang koa sakras vavus hemukave? !Mihesakras! ");
INSERT INTO pma_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Sakini nasila provet keil, koakeil akileile, ka tiser keil iha ven kami keke isel kat kami mivahiles ran tisaen onami. Ka kami, mihouas tei keil imat, ka keil koan mun miheti kat keil en aiveave. Ka teisav en keil, mihetah keil en viau takan en eim tahihiseien keil onami. Mihelikat keil keke mihehuli kat keil en taon keil onami ka en taon tateisav keil emun. ");
INSERT INTO pma_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Hesakini, mahien ven matien onen meatin vasi keil koa amal en meten Ahi hel en hemi. Anatin, matien onen Ebel koa mal koa avu onami amu rohtoh eni rokol matien onen Sakaraea, natin Berekae, koa avu onami akov vini luhu en Eim Votut ka ahor ten sanien teni, matien vasi one heha kat kami. ");
INSERT INTO pma_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Anatin eli naviteni min kami, Ahi hesan mahien ven matien keil vasi enek heha kat kami ten kosa. ");
INSERT INTO pma_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“!O meatin keil ten out Serusalem! Kami, mimu vini provet keil ka mikov vini eiloheh keil koa Ahi sila keil umai ven kami. Avong houlu, ek vati mok mahise ruain kami ka mating koe kami vasuval toahin tai mul vise ruain titan keil ka ring koe keil en apouen. Ka kami emi rovattei. ");
INSERT INTO pma_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","!Sakini mihelesi! Ahi herting koetei mun kami vuo taon onami, hesakini hemai hehi out volvol. ");
INSERT INTO pma_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ka naviteni min kami, kosa heha, miherlestei mun inau hetokol avong koa kami mihehiteni mihehit, ‘!Tokolkatien mul en kei koa mai en isen Iahova!’ ” (Sam 118:26) ");
INSERT INTO pma_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Navong Iesu ka onen keil amul alokovein teahu ten Eim Votut, meatin keil onen umai veni ka arie lat more eim keil ten Eim Votut mini. ");
INSERT INTO pma_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Sakini Iesu viteni min keil vit, “?Miles tounah vasi keil ekek? Anatin eli naviteni min kami, avong tai hemai koa ahat keil enek irkapiltei mun, meatin keil imai u rasilin keil vasi.” ");
INSERT INTO pma_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Evus, Iesu vina en Hou Nei Olip ka ral min meatin keil onen. Ka navong mul rondan, keil umai veni, keil enges, ka avisi avit, “?Hiteni min komai, tounah keil ekek usil Eim Votut hekur out nengeis? ?Ka asa varei hetie lati keke komul kumai ka tounah keil ten out netan hevus?” ");
INSERT INTO pma_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Iesu vit kesi min keil vit, “Mihelei kat revi kami ka minamaentei meatin sav tai nasak luvos kami. ");
INSERT INTO pma_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Veni meatin houlu imai en isok ka ihiteni ihit, ‘!Inau navi Mesaea!’ Sakini iluvos meatin keil houlu. ");
INSERT INTO pma_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mihelonge keke vaeen keil mul mai vesesal ka mihekur longlongien usil rea keil en out soutin. Ka kami minatimanintei eni. Tounah keil enek hemai somok hekistal, ka keite ten out netan hermaitei veah. ");
INSERT INTO pma_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Out tai uas out sav ka kantri keil u ris kantri sav keil. En out houlu en out netan amai heat meatin keil ka alu helu. ");
INSERT INTO pma_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ka avaseini keke tounah keil enek tisa, hemai hetisa mok mulamu en avong hiasuvien onen Ahi hemai hekistal ien. Tounah keil enek asuval mahien koa ahin long rohtoh eni navong hekur tivava. ");
INSERT INTO pma_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Hevus, ihuli kat kami ka isa lat kami miheha keke avasan mahien ka u vini kami. Meatin keil ten kantri vasi keil, tine heat kami veni mimusil inau. ");
INSERT INTO pma_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","En avong enek, meatin houlu ihiles eisile ran demkatien one ka isa lat time keil one min vativieh keil ka tine heat vatiamal kati one. ");
INSERT INTO pma_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ka provet taluvosien keil houlu ikistal ka iluvos meatin keil houlu. ");
INSERT INTO pma_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ka veni sakien tatisa hemai hehi houlu mok, envatien onen meatin houlu hetovuol en meatin sav keil. ");
INSERT INTO pma_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ka koakeil ilomal hekeih en demkatien one hetokol keite ten tounah vasi enek, Ahi houtut keil. ");
INSERT INTO pma_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ka navong more longlongien koanik usil hiasuvien onen Ahi heka vasi out netan keke akilea eni, en avong enek varei, keite ten tounah vasi hemai. ");
INSERT INTO pma_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Kami miheles selusien onen Ahi koa ka en provet Daniel hemai hehi anatin koa vit, ‘Iling tounah tai koa tisaso hel en Eim Votut ka hesakini hermutotei mun en meten Ahi.’ (Kami koa mivuli selusien ekek, miheilea aneite teni.) ");
INSERT INTO pma_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ka navong milesi, koakeil amul en out Sudea ikalah ilohosai iha en vatihou keil ka ito suai. ");
INSERT INTO pma_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Munak meatin etai mul museh hae, avong hervinvintei mun vaha ris neim vakur etai tounah onen. ");
INSERT INTO pma_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ka munak meatin tai mul mum en ah sen, hervatei mun teim vakur etai eisin omon. ");
INSERT INTO pma_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","En avong keil enek, hetisa vareis min ahin keil koa ameas vuo koakeil arounat en tivava keil. ");
INSERT INTO pma_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mihehis min Ahi keke avong koa mihelohosai eni hervitei en avong koa an hetisa vuo en Sabat, ");
INSERT INTO pma_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","veni mahien en avong tatisa enek helohlin avong vasi keil ten out netan: en avong Ahi mumon out netan rokol kosa. Ka vati avong enek hetovuol emun en avong keil koa hemai veah. ");
INSERT INTO pma_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ka Ahi rei avong keil tatisa enek mai tamureis veni mundem usil koakeil rie lat keil avi onen. Veni munak hermumontei, meatin hetovuol emun hemoul. ");
INSERT INTO pma_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Ka en avong enek, ihiteni ihit, ‘!Alesi mau! !Mesaea koa Ahi rie lati keiek!’ Vuo ihit, ‘!Alesi, mul kei va!’ Ka kami minakurtei anatin en selusien keil enek. ");
INSERT INTO pma_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Veni Mesaea taluvosien keil ka provet taluvosien keil emun imai. Ka navong imai, umon merikel keil ka marmari tounah keil vasakin meatin keil itimanin eni. Keil umoni keke avaluvos meatin houlu avousil keil. Ka isak visi keke ileh koakeil emun Ahi rie lat keil avi onen, ka isakras. ");
INSERT INTO pma_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Sakini mihelong revi selusien onak veni naviteni tuai min kami tounah keil koa hemai hekistal. ");
INSERT INTO pma_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Sakini, munak meatin etai hehiteni min kami hehit, ‘Mesaea va ko en out volvol,’ minahatei en out ekok. !Vuo! Munak keil ihiteni ihit, ‘Mesaea keie, kei ros neim en out enek,’ minakurtei anatin eni. ");
INSERT INTO pma_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Veni en avong koa inau, Natin Meatin, nimai ris eni, meatin keil vasi ilei kilea eni hesuval navong ales ahil vil ka ritin ka vasi out en usite tai en out ist rokol usite sav emun en out wes. ");
INSERT INTO pma_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Suval koa meatin keil alei kilea out koa tounah tai mat mul ien navong ales vangi angolu keil, navong Natin Meatin hemai ris, meatin keil ilei kilea eni. ");
INSERT INTO pma_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ka en hati avong enek koa avong tatisa keil enek hevus, ‘Meteiai hemai hemalikelik ka avati hertitintei. Hitu keil imerang ran teilang, ka tounah sav keil emun amul nesa, Ahi hesakulul en keil.’ ");
INSERT INTO pma_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Anatin, en avong koanek varei, tounah hekistal en teilang vatie lati keke inau, Natin Meatin, namul numai, ka meatin vasi ten out netan uai avong ilesi. Keil iles, ‘Natin Meatin hel hemita en mahmah keil ten out nesa’ hetal min keihoen ka mari muohien onen. ");
INSERT INTO pma_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Kei houh mari amaru tai keke vasila angelo keil onen. Ka keil iha en out vasi netan, usite tai hetokol usite sav, keke avalah ruain meatin keil koa Ahi rie lat keil avi onen. ");
INSERT INTO pma_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Kami mihekur hihiseien koa ten vati fik. Navong angoite so lati ka mul son oute hau keil, mikilea keke avong ten romrom mul mai vesesal. ");
INSERT INTO pma_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","En vati sakien enek, navong miles tounah vasi keil enek amul akur out, miheilea keke amairisien onak, Natin Meatin, mul mai vesesal. Anatin, mul tuai en voiteh. ");
INSERT INTO pma_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Anatin eli naviteni min kami, tounah vasi keil enek hekur out en avong koa meatin keil ten kosa amul amoul veah. ");
INSERT INTO pma_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Out netan ka teilang emun luhevupuol, ka selusien onak sakras vavuol.” ");
INSERT INTO pma_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ka Iesu vit, “Meatin tovuol vailea avong kati koa inau, Natin Meatin, nimai ris eni. Anatin, angelo keil en out nesa ka inau, Natin Ahi, emun merkileatei eni. Ahi Tamer enges kilea avong kati teni. ");
INSERT INTO pma_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Amairisien onak, Natin Meatin, hesuval asa koa kur out en avong onen Noah mulamu. ");
INSERT INTO pma_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Veni en avong keil enek mulamu en mari oai, meatin keil amul akanian ka amunmun, meahos keil ka ahin keil amul aretalihe va rokol avong varei Noah va neim en mari sip onen. ");
INSERT INTO pma_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Keil areingeingeni varei en asa koa hemai hekur out rokol avong varei koa mari oai mai ka mutaves vasin keil uva umatmat. En vati sakien enek, meatin keil itimanin en amairisien onak, Natin Meatin. ");
INSERT INTO pma_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","En avong enek, munak meatin elu lumum en ah tas; tai en keilu Ahi hekuri hehina heto hetal mini, ka tamun helokoveini hetos. ");
INSERT INTO pma_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Anatin, munak luahin lumul lusak mesein anien, tai en keilu Ahi hekuri hehina heto hetal mini, ka tamun helokoveini hetos. ");
INSERT INTO pma_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Sakini, mihelei kat revi kami, veni mireingeingen avong sa koa Asuv onami hemai ris eni. ");
INSERT INTO pma_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ka miheilea keke munak meatin koa eim vi onen kilea en avong kati koa tarhena hemai ien, kilea vatos valei kokoe revi ven eim omon keke tarhena enek hervatei neim. ");
INSERT INTO pma_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Sakini, mihesak mesein kami, veni en vati sakien enek, inau, Natin Meatin, nimai ris suval tarhena tai en avong koa mirkileatei eni. ");
INSERT INTO pma_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“?Isei vi meatin toumien koa vi meteisau ka mul long kat ren asuv onen? Kei vi kei koa asuv onen lingi vi houlu en meatin toumien teisav keil en teim keke vasan anien ae en avong mal teni. ");
INSERT INTO pma_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Tokolkatien hel en meatin toumien koa asuv onen hehotini keke mum revi umen vasi keil onen navong mai ris teim. ");
INSERT INTO pma_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Anatin eli naviteni min kami, asuv koanek hehati lat meatin toumien enek keke valei kat vasin tounah sav keil onen emun. ");
INSERT INTO pma_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“Ka munak meatin toumien enek, vatin tisa ka mul viteni min kei sasen vit, ‘Asuv onak mul roun vareis.’ ");
INSERT INTO pma_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Sakini mul mu purun meatin toumien teisav keil ka mul kanian ka mul munmun ral min koakeil avi uti munmunien. ");
INSERT INTO pma_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ka asuv onen hemai ris en avong tai koa meatin toumien enek hermundemtei hehit hemai eni. ");
INSERT INTO pma_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ka navong asuv onen hemai, hou puruni ka helisi heha en out ten mahien hetal min koakeil amusil Ahi en hilive enges, en out koa il is ka il ihal lohe ven mahien one.” ");
INSERT INTO pma_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Navong Iesu mul selus ral min meatin keil onen usil hemukave il isak mesein keil ven amairisien onen, ra usil tatavolien enek min keil vit, “En avong enek, hiasuvien onen Ahi hemai hesuval avong koa atouli hau halualim (10) uva keke avales tetaliheien tai. Navong out mul vavong, akur laet one ka uva avahisu min meatin koa vatetalihe keke avousili avaha en out ten tetaliheien. ");
INSERT INTO pma_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Elim en keil vate tovuol, ka elim vate mul. ");
INSERT INTO pma_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Koakeil vate tovuol akur laet one ka arkur etai mun oel vatal min keil. ");
INSERT INTO pma_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ka koakeil vate mul akur retai en veioel tamun ral min laet one. ");
INSERT INTO pma_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Meatin ten tetaliheien roun en amaien onen, ka atouli hau keil enek amul arae ka amatil. ");
INSERT INTO pma_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ka en metavinavong, along meatin keil avisohiso avit, ‘!Mul mai! !Meatin ten tetaliheien mul mai! !Almai alhisu mini rovousili!’ ");
INSERT INTO pma_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Navong atouli hau keil enek alonge, amule amea ka amum revi laet keil one. ");
INSERT INTO pma_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ka koakeil vate tovuol aviteni min koakeil vate mul avit, ‘Alsan tei oel onami vamai, veni laet onomai mul mat ke.’ ");
INSERT INTO pma_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Ka koakeil vate mul avit kesi min keil avit, ‘Vuo li, veni oel onomai rovinvintei ven laet onami ka laet onomai emun. Mihehas en sitoa teni ka mihehul tei hehi onami.’ ");
INSERT INTO pma_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Ka navong ahin keil enek uva avahul tei oel, meatin ten tetaliheien mai kistal. Ka atouli keil koa asak mesei revi, amusili ka uva neim ral mini en mari anien ten tetaliheien. Evus, meatin keil akoteh en voiteh. ");
INSERT INTO pma_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Ka katau, navong atouli sav keil umai akistal, umai en eim enek ka avisohiso avit, ‘!Asuv, Asuv! !Sehen voiteh ven komai li!’ ");
INSERT INTO pma_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Ka meatin ten tetaliheien vit kesi min keil vit, ‘Anatin eli naviteni min kami, narkileatei kami varei.’” ");
INSERT INTO pma_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ka Iesu selus ekor en tatavolien enek vit, “En sakien enek, kami mihelei kat revi kami, veni mireingeingen avong kati ten amairisien onak.” ");
INSERT INTO pma_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Iesu ra usil tatavolien tamun min meatin keil onen vit, “En avong enek, amaien ten hiasuvien onen Ahi hesuval hetetamen tai koa sak mesein tounah keil onen keke vaha en out soutin. Sakini, vise ruain eiloheh etel (3) onen ka ling keitel telvalei kat tounah keil onen. ");
INSERT INTO pma_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Kei ling retai en tounah keil onen en heatel musil meteisauen one. Min tai, hetetamen enek ling gol mani taosen elim (5,000) en hen. Min tamun, ling gol mani taosen elu (2,000) en hen. Ka min tamun koa teisav, ling gol mani taosen tas (1,000) en hen. Evus, hetetamen enek va suk. ");
INSERT INTO pma_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Navong va, hatte tas, kei koa kur gol mani taosen elim (5,000) eva ka mum sosor en mani enek va vio … kur ris taosen elim (5,000) emun ral mini. ");
INSERT INTO pma_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ka en vati sise enek, meatin koa kur gol mani taosen elu (2,000), kei mun mum sosor en mani enek ka kur ris taosen elu (2,000) mun. ");
INSERT INTO pma_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ka meatin koa kur gol mani taosen tas (1,000), kei va, kil avul tai, ka rahin suain mani onen asuv onen. ");
INSERT INTO pma_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Avong houlu muli va, ka asuv oneatel mai ris ka vise keitel keke valong revi asa telmumoni en mani koa lingi en heatel. ");
INSERT INTO pma_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Meatin toumien onen koa kur gol mani taosen elim (5,000) mai veni ral min taosen elim emun ka vit, ‘Asuv, keik koling gol mani taosen elim (5,000) en hek. Ka kilesi, namum sosor eni ka navotin taosen elim (5,000) emun ka naling kati ral mini.’ ");
INSERT INTO pma_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Navong asuv onen lesi, viteni mini vit, ‘!Tahos imok! Keik kovi eiloheh koa tahos koa nakilea nindesinuk. Ka veni kolei kat revi tounah keil havivis koa nalingi en hem, nisakinuk kilei kat tounah keil houlu onak. Kimai ka kiles tahosien hetal min asuv onom.’ ");
INSERT INTO pma_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Evus, eiloheh onen koa kur gol mani taosen elu (2,000) mai veni ka vit, ‘Asuv, keik koling gol mani taosen elu (2,000) en hek. Ka kilesi, namum sosor eni ka navotin taosen elu (2,000) emun ka naling kati ral mini.’ ");
INSERT INTO pma_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Navong asuv onen lesi, viteni mini vit, ‘!Tahos imok! Keik kovi eiloheh tai koa tahos koa nakilea nindesinuk. Ka veni kolei kat revi tounah keil havivis koa nalingi en hem, nisakinuk kilei kat tounah keil houlu onak. Kimai ka kiles tahosien hetal min asuv onom.’ ");
INSERT INTO pma_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Evus, eiloheh onen koa kur gol mani taosen tas (1,000) mai veni ka vit, ‘Asuv, nakilea keke kovi meatin takeih tai koa mul kur heiai en vatiai keil koa keik korluhtei, ka komul kolah anien koa meatin sav keil aluhi en ah keil osom. ");
INSERT INTO pma_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Sakini nametaunuk ka nuva narahin suain mani onom en avul tai. Kilesi ke, mani keil vasi onom keiek.’ ");
INSERT INTO pma_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Navong asuv onen lesi, viteni mini vit, ‘!Keik kovi taripeng vareis ka eiloheh tai koa tisaso. Keik kokilea keke navi meatin takeih tai koa namul nakur heiai en vatiai keil koa narluhtei, ka namul nalah anien koa meatin sav keil aluhi en ah keil osak. ");
INSERT INTO pma_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Mukonek, tahos imok munak kovaling mani onak enges en bangk tai keke navong numai ris nakilea makur ris mani onak vatal titan.’ ");
INSERT INTO pma_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Evus, hetetamen enek viles ka les eiloheh sav onen ka viteni mini vit, ‘Kulat gol mani ran hen eiloheh enek ka kilingi en hen koa kur kat gol mani taosen halualim (10,000) tuai. ");
INSERT INTO pma_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Veni koakeil amum ral min tounah koa mul en he, isan tamun mini keke vasakin tounah keil koa mul en he hehi houlu mok. Ka koakeil armumtei vatal min asa koa mul en he tuai, avaseini tounah keil havivis, ikulati ran he. ");
INSERT INTO pma_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ka eiloheh tatisa ekek, kilisi heha hae en out koa mankoli heto hetal min koakeil il is ka il ihal lohe ven mahien one.’” ");
INSERT INTO pma_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Iesu mules selus min meatin keil onen vit, “Navong inau, Natin Meatin, nimai ris eni, nimai en mari muohien ka hetal min angelo vasi keil. Hevus, nitondan en vulin ten keihoen onak hetal min hetetamenien keke nilei revi usite onen meatin keil. ");
INSERT INTO pma_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","En avong enek, meatin vasi keil ten kantri vasi keil iso ruai out hetas. Keil ilomal en metok, ka nititi vas keil iha en vangite helu. Numoni hesuval meatin koa lei kat sipsip keil mul riti vas nani keil vaha ran sipsip keil osen. ");
INSERT INTO pma_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Sipsip keil, ling seheni en usite matu ka nani keil, en usite meil. En sakien enek, inau mun niling meatin keil amal en usivek matu, ka koakeil akalkali, nilingi en usivek meil. ");
INSERT INTO pma_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Hevus, inau koa narondan en vulin ten keihoen enek, nihiteni min koakeil amul en usivek matu nihit, ‘Kami koa tokolkatien onen Tata onak mul en kami, almai! Almai ka mihekur asa koa kei sak meseini ven kami navong mumon out netan. ");
INSERT INTO pma_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Veni navong amai kat nau, misan anien minau nakani; navong maroro kat nau, misan oai minau namuni; ka navong navi heou, mikur revi nau en teim onami. ");
INSERT INTO pma_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Anatin, navong eisin omak tovuol, mimusin enau; navong namesai, milei kat revi nau; ka navong namul en eim takeih, kami misau enau.’ ");
INSERT INTO pma_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Evus, meatin keil amal ihit kesi minau ihit, ‘?Asuv, avong sa varei melesuk amai katuk ka mesan anien kokani; vuo maroro katuk ka mesan oai minuk komuni? ");
INSERT INTO pma_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","?Avong sa melesuk kovi heou ka mekur revi keik en teim somai, vuo eisin omom tovuol ka memusin enuk? ");
INSERT INTO pma_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","?Ka avong sa varei melesuk komesai vuo komul en eim takeih ka mesau enuk?’ ");
INSERT INTO pma_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Ka en vuluk ten keihoen nihiteni min keil nihit, ‘Anatin eli naviteni min kami, tounah vasi koa mimumoni min meatin tai koa musil kat nau, avaseini kei vi meatin kuren enges, en metok koanek suval koa kami mimumoni minau varei.’ ");
INSERT INTO pma_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Hevus, nihiteni min koakeil amul en usivek meil nihit, ‘!Kami koa Ahi sesendan kami, miheha ranau! !Miheha en ahang koa sakras vavus, koa Ahi sak meseini tuai ven Temat ka angelo keil onen! ");
INSERT INTO pma_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Veni navong amai kat nau, mirsantei anien minau maani; navong maroro kat nau, mirsantei oai minau mamuni; ");
INSERT INTO pma_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ka navong navi heou, mirkur revitei nau en teim onami. Ka navong eisin omak tovuol, mirmusin entei nau; navong namesai, mirlei kat revitei nau; ka navong namul en eim takeih, kami mirsao entei nau.’ ");
INSERT INTO pma_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Hevus keil ihis nau ihit, ‘?Asuv, avong sa varei melesuk amai vuo maroro katuk, vuo kovi heou, vuo eisin omom tovuol, vuo komesai, vuo komul en eim takeih ka merkatauntei keik?’ ");
INSERT INTO pma_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Ka inau nihit kesi min keil nihit, ‘Anatin eli naviteni min kami, tounah vasi koa mirmumontei min meatin tai koa musil kat nau, avaseini kei vi meatin kuren enges, en metok koanek suval koa mirmumontei minau.’ ");
INSERT INTO pma_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Ka koakeil akalkali, inau nisa lat keil iha en out koa mahien one sakras vavus. Ka koakeil amal iha ikur moulien ten lisenges.” ");
INSERT INTO pma_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Navong Iesu selus min meatin keil onen usil tounah ten Avong koa ilei revi usite vasi onen meatin keil evus, kei viteni min keil vit, ");
INSERT INTO pma_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Suval mikilea eni tuai, avong helu sesuk keke umon Anien ten Mul Laui. Ka en avong enek varei, isa lat nau, Natin Meatin, niha en hen vativieh keil onak keke iti kat nau en aiveave.” ");
INSERT INTO pma_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ka en more teim osen Kaiafas koa vi asuv houlu onen pris keil, asuv keil onen pris keil ka elda keil alah ruai. ");
INSERT INTO pma_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Keil arun lekat sise koa ika suai ien keke akilea avahuli kat Iesu ka avouasi vamat. ");
INSERT INTO pma_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ka aviteni avit, “Rehermumontei en avong ten ale, veni hetisa meatin keil anoumon rea.” ");
INSERT INTO pma_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ka navong Iesu mul veah en out Betani, kei ro teim sen Saemon koa mulamu kur mesaien ten leprosi en hiliven. ");
INSERT INTO pma_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Navong Iesu mul kanian, ahin tai mai veni ka mul kur veite koa amumoni en more ahat koa avise en alabasta. Oel koa vite tahos imok mul ien koa mani teni keih ka kei mai ka mutahi en vatin Iesu. ");
INSERT INTO pma_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ka navong meatin keil onen Iesu alesi, arun kutut usili avit, “?!Vensa kei mul purun oel mukok!? ");
INSERT INTO pma_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Tahos imok vahit kei vasalem en oel koanik en mari mani tai. Vasakini, mani teni kilea vakataun koakeil tounah one tovuol.” ");
INSERT INTO pma_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Iesu kilea en asa amul aselus usili ka viteni min keil vit, “?Mimul mivul kat ahin ekek vensa? Kei mumon more tounah minau. ");
INSERT INTO pma_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Veni koakeil tounah one tovuol ito hetal min kami lisenges, ka inau nirtotei hetal min kami lises. ");
INSERT INTO pma_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Navong kei mutah oel en avek, kei sak mesein nau ten avong tatetahinien onak varei. ");
INSERT INTO pma_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Anatin eli naviteni min kami, en out vasi netan koa ihitehiten more longlongien usil inau, ihiteni mun asa koa ahin ekek mumoni minau. Ka hesakini meatin sav keil indem silat kei.” ");
INSERT INTO pma_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Navong akanian evus, Sudas Eskariot, tai en teindan elu (12) onen Iesu, va ven asuv keil onen pris keil ");
INSERT INTO pma_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ka vis keil vit, “?Munak nisa lat Iesu heha en hemi, mihesan asa minau?” Sakini, keil avuli silva mani hanumau tai ka halualim (30) keke avasani mini. ");
INSERT INTO pma_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Sudas maeni, ka en avong enek va, kei mul lekat sise vaka ien keke vasa lat Iesu vaha en he. ");
INSERT INTO pma_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","En avong tai ten avong oulu (7) ten Ale ten Veret Is Tovuol Ien, meatin keil onen Iesu umai veni ka avisi avit, “?Out kave em vati mevasak mesein Anien ten Mul Laui ien?” ");
INSERT INTO pma_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Iesu vit kesi vit, “Miheha en taon Serusalem ke va, ka mihehotin meatin tai en out enek. Mihehiteni mini mihehit, ‘Tiser viteni vit, “Avong onak mai vesesal. Ka nian Anien ten Mul Laui en teim osom hetal min onak keil.”’” ");
INSERT INTO pma_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Sakini meatin keil onen uva ka amumoni suval koa Iesu viteni min keil. Ekonek, asak mesein Anien ten Mul Laui. ");
INSERT INTO pma_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Navong meteiai munu, Iesu mai ka rondan en anien enek ral min teindan elu (12) onen. ");
INSERT INTO pma_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ka navong amul akanian, Iesu vit leini min keil vit, “Anatin eli naviteni min kami, tai en kami hesa lat nau niha en hen vativieh keil onak.” ");
INSERT INTO pma_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Navong alonge mukok, onen keil alonge tisa houlu ka retai en keil avis Iesu avit, “?Asuv mukave, komundemi kovit inau?” ");
INSERT INTO pma_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Iesu vit kesi min keil vit, “Anatin, tai en kami koa romul rokanian ruai hesa lat nau. ");
INSERT INTO pma_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ka anatin keke inau, Natin Meatin, nimat hesuval koa Tus Votut viteni. !Ka hetisa mok min kei koa hesa lat inau! Meatin enek, hetahos imok vahit avarvasitei veni mahien koa Ahi hesani mini hemariso mok.” ");
INSERT INTO pma_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Evus, Sudas koa hesa lati visi vit “?Tiser mukave, komundemi kovit inau?” Iesu vit kesi mini vit, “Suval keik koviteni.” ");
INSERT INTO pma_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Navong amul akanian, Iesu kur veret ka san masmasien min Ahi veni. Evus vul vahasi ka navong mul riti min meatin keil onen viteni vit, “Mihekuri miheani. Koanik vi avek.” ");
INSERT INTO pma_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Evus, Iesu kur veiuaen, san masmasien min Ahi veni ka navong sani min keil viteni vit, “Kami vasi mihemuni. ");
INSERT INTO pma_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Uaen koanik vi rak vasakin hatkatien hau onen Ahi vakeih ka vamai vahi anatin. Rak houe ven meatin houlu vakas motein meten Ahi keke hermundemtei mun usil tisaen keil one. ");
INSERT INTO pma_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Naviteni min kami, nirmuntei mun uaen koanik hetokol avong koa nimun risi hetal min kami en avong koa Tata onak hesakin hiasuvien onen heka vasi out.” ");
INSERT INTO pma_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Navong akanian ka amusau en souen tai evus, keil asital ka avina en Hou Nei Olip. ");
INSERT INTO pma_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Navong arokol Hou Nei Olip, Iesu selus min meatin keil onen vit, “En vongien ekek varei, kami vasi mihesokovein inau hesuval koa Ahi viteni en Tus Votut koa vit, ‘Nuas meatin koa lei kat sipsip keil, ka sipsip keil onen iloh rasil.’ ");
INSERT INTO pma_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ka navong nimoul eris ran matien, nilamu en kami niha en out Kaleli.” ");
INSERT INTO pma_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ka Pita mea selus vit, “!Avaseini munak meatin sav vasi keil isokoveinuk, inau nasakras masokoveinuk varei!” ");
INSERT INTO pma_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ka Iesu vit risi mini vit, “Anatin eli naviteni minuk, en vongien enek varei, out hermulantei mau ka ato herkokorattei mau, ka keik, kihiteni hatte hetel keke korkileatei inau.” ");
INSERT INTO pma_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ka Pita viteni keih tamun vit, “!Vuo, hermukteinek! !Avaseini munak nimat hetal minuk, inau nasakras mahiteni keke narkileatei keik!” Ka meatin sav keil onen aviteni vatte tas. ");
INSERT INTO pma_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Evus, Iesu va en out tai avise en Ketsemane ral min onen keil. Navong arokol out enek, Iesu viteni min keil vit, “Mihetondan ekok ka mihetosin nau. Inau maha mau keiva ke mahis.” ");
INSERT INTO pma_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Kei kur Pita ka natin Sepeti keilu telmusili. Ka navong telva, rendemien onen Iesu muasi ka longe tisa houlu. ");
INSERT INTO pma_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Sakini viteni min keitel vit, “Tinok vil en demvoen, vit vahonet inau. Mitheto ekok, mithele hetal minau.” ");
INSERT INTO pma_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Evus, Iesu mual ran keitel havivis, retengeiril nan vita netan ka vis min Ahi vit, “Tata, munak sise sav mul, kikulat mahien enek ranau li. Ka kirmumontei hesuval koa inau ek vati. Kumonis hesuval koa keik em vati.” ");
INSERT INTO pma_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Evus, muris va ven keitel ka votini keke telmatil. Ka viteni min Pita vit, “?Mukave? ?Mitsakras mitvalele vatal minau vatokol haoa vatas? ");
INSERT INTO pma_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mithelele ka mithehis keke mithermottei navong sakvisien hemai en kamitel. En tinomi, emi vati mivoumon asa koa mal, ka avemi memerau nges.” ");
INSERT INTO pma_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Hatte tamun, Iesu va ris ka vis vit, “Tata, munak sise sav tovuol ka nil nikur vasi mahien enek, kumoni hesuval koa keik em vati.” ");
INSERT INTO pma_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Navong muris, votini keke keitel telmatil eris veni telsakras telvahuli kat metalong. ");
INSERT INTO pma_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Sakini, lokovein keitel eris ka va ris vis hatte etel eni en vati hisien enek. ");
INSERT INTO pma_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ka navong Iesu muris va ven keitel, kei vit, “?Mitmatil ka mitmuseh veah? !Mitlesi! Ekek, avong mai avasa lat inau, Natin Meatin, vaha en hen meatin tisa keil. ");
INSERT INTO pma_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","!Telmea, tovaha! !Meatin koa vasa lat nau keie, mai tuai!” ");
INSERT INTO pma_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Navong Iesu mul semau selus, Sudas, tai en teindan elu onen mai kistal. Ka mari vangi meatin keil amusili umai. Keil alah kat mari naef ka ai tavaeen keil. Umai musil rendemien onen asuv keil onen pris keil ka elda keil onen Siu keil. ");
INSERT INTO pma_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Sudas koa vat kati vasa lat Iesu mumon metai tai ral min keil vit, “Meatin koa nimusi, kei varei vi meatin koa emi vati. Mihemai mihehuli kati.” ");
INSERT INTO pma_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Sakini Sudas ka mal va ven Iesu, musi ka vit, “!Tiser, more!” ");
INSERT INTO pma_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Iesu vit kesi vit, “Tuak, kumon asas koa kumai veni.” Evus, meatin keil umai ka avuli kat Iesu. ");
INSERT INTO pma_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ka tai en meatin keil onen Iesu leh lat mari naef onen ka musah koteh ralingen slev onen asuv houlu onen pris keil. ");
INSERT INTO pma_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Iesu viteni keih mini vit, “Ling ris naef onom en vulin veni koakeil avuhu en naef tai, imat en naef. ");
INSERT INTO pma_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Munak ek hehati, nakilea mapeah Tata onak, ka hatte tas, hesila mari vangi angelo tavaeen keil heli teindan elu (12) avamai avating koe inau. ");
INSERT INTO pma_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","?Ka munak numoni, Tus Votut hemai hehi anatin hemukave koa viteni keke tounah keil enek hekur out?” ");
INSERT INTO pma_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Evus, Iesu viles les mari vange meatin keil enek ka viteni min keil vit, “?Vensa milah kat naef ka ai tavaeen keil keke mivamai mivahuli kat nau? ?Mimundemi namulamun meatin keil keke mevavae vatal min kavmen orer? !Vuo! En avong vasi, narondan en teahu ten Eim Votut ka navisein meatin keil, ka en out enek mirvuli kattei nau. ");
INSERT INTO pma_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ka tounah vasi enek kur out vasakin asa koa provet keil amutisi en Tus Votut hemai hehi anatin.” Ka navong avuli kati, meatin vasi keil onen alokoveini ka amuloh rasil. ");
INSERT INTO pma_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Koakeil avuli kat Iesu akuri va en teim sen Kaiafas, koa vi asuv houlu onen pris keil. En out enek, tiser keil ten mengkatien ka elda keil onen Siu keil alah ruai tuai. ");
INSERT INTO pma_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ka Pita mul lehni musil vange meatin koa mulamun Iesu va vio … rokol teahu ten teim sen asuv houlu onen pris keil. En out enek, kei va neim en teahu ka rondan ral min meatin taleikokoeien keil ten eim enek keke vales asa avoumoni en Iesu. ");
INSERT INTO pma_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Asuv keil onen pris keil ka hetetamen sav keil emun onen Siu keil amul alekat meatin koa voun kat Iesu en tisaen, vasakini akilea avouasi vamat. ");
INSERT INTO pma_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Avaseini meatin houlu aviten luvosien va kat Iesu, asakras avahotin etai tounah keke akilea avamae lat moulien onen keke avou vini. Evus, meatin elu lumai lumulomal ");
INSERT INTO pma_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ka luviteni min koakeil ten Kaonsel enek luvit, “Komal melong meatin ekek viteni vit, ‘Inau nakilea mou rasilin Eim Votut onen Ahi, ka en avong etel enges, num risi.’” ");
INSERT INTO pma_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Sakini asuv houlu onen pris keil mulomal ka vis Iesu vit, “?Mukave? Kolong selusien keil koa aviteni va katuk. ?Tounah tovuol kovahiteni?” ");
INSERT INTO pma_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ka Iesu mules ro raeng. Sakini asuv houlu enek vis risi vit, “En meten Ahi koa moul, nameng katuk keke kihiten asa koa vi anatin. ?Anatin keke kovi Mesaea, Natin Ahi?” ");
INSERT INTO pma_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Iesu vit kesi vit, “Suval koa koviteni. Ka naviteni min kami, kosa heha, miheles … ‘Natin Meatin hetondan en usite matu onen Ahi Asuv ten Keihoen ka mihelesi hemita en mahmah keil ten out nesa!’” ");
INSERT INTO pma_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Navong asuv houlu onen pris keil long selusien onen, tin tisa houlu, rali vas eisin onen ka viteni keih vit, “?Milonge? !Kei selus kekar en isen Ahi! ?Vensa romul rolekat selusien sav koa vaha kati? !Kami vasi milonge mukave kei selus kekar en isen Ahi! ");
INSERT INTO pma_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","?Rendemien onami mukave?” Keil avit kesi avit, “!Mal enges keke hemat imok!” ");
INSERT INTO pma_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Evus, keil amutiv kat nan ka amuti. Ka tei sav en keil akovasi ");
INSERT INTO pma_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ka avit, “?!Munak kovi Mesaea anatin, hit luvati min komai, isei varei mutik!?” ");
INSERT INTO pma_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Navong Pita mul rondan veah en teahu ten eim omon asuv houlu onen pris keil, atouli toumien tai mai veni ka vit, “Keik emun koro ral min Iesu ten out Kaleli.” ");
INSERT INTO pma_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ka Pita muun keih en meten meatin keil vit, “!Rovitei anatin! !Inau narkileatei tounah koa komul kovit usili!” ");
INSERT INTO pma_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Evus, Pita mea mual va en meteau ten teahu. Ekonek, atouli toumien sav tamun lesi ka viteni min meatin sav keil vit, “!Meatin koanik vi tai en keil koa amusil Iesu ten out Nasaret!” ");
INSERT INTO pma_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ka hatte tamun, Pita viteni min keil vit, “!Navat kati anatin keke narkileatei varei meatin enek!” ");
INSERT INTO pma_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Rovitei tuetin, meatin keil koa amulomal en out enek umai ven Pita ka aviteni mini avit, “Keik varei kovi meatin tai onen veni selusien onom suval koan Kaleli.” ");
INSERT INTO pma_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ka Pita sesendan kei sasen ral min selusien keih vit, “!Inau narkileatei varei meatin koa mimul mivit usili! !Ka Ahi hesan mahien minau munak selusien onak vi luvosien!” Hatte tas, ato tai kokorat. ");
INSERT INTO pma_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ka navong Pita longe, mundem ris asa koa Iesu viteni mini vit, “Out hermulantei mau ka ato herkokorattei mau, ka keik, kihiteni hatte hetel keke korkileatei nau.” Sakini, kei lokovein teahu enek, tin mah houlu ka murang. ");
INSERT INTO pma_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","En visokon semau, asuv keil onen pris keil ka elda keil onen Siu keil, keil vasi umai en rendemien tas keke avouas Iesu vamat. ");
INSERT INTO pma_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Sakini, apar kati ka amulamuni va ven asuv Paelet, avat ten kavmen en out enek, keke avasa lati mini. ");
INSERT INTO pma_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Navong Sudas koa sa lat Iesu lesi keke amaen lat moulien onen Iesu keke avouasi vamat, kei viles rendemien onen ka sak visi vasan ris silva mani hanumau tai ka halualim (30) min asuv keil onen pris keil ka elda keil. ");
INSERT INTO pma_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Kei vit lat kei min keil vit, “Inau namumon tisaen, veni nasa lat meatin tai hemat koa romumon etai tounah vatisa.” Ka keil avit kesi mini avit, “Komai emai rovattei mevailea. Koanek mul enuk.” ");
INSERT INTO pma_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Sakini Sudas rivin mani netan en teahu ten Eim Votut ka muloh va. Evus, va ka par koteh hiren en viau ka murur. ");
INSERT INTO pma_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Asuv keil onen pris keil umai alah lat silva mani keil enek ka aviteni avit, “En mengkatien orer, romaltei rovaling mani enek vaha en ateli ten Eim Votut veni mani enek romutotei, avul lat moulien onen meatin tai eni.” ");
INSERT INTO pma_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Aselus usili ka umai en rendemien tas. Sakini, akur mani enek ka uva ales meatin koa mumon tounah keil en tanvili. Ral min mani enek, avul hati atan rani keke avoumon out tatetahinien tai eni keke avatahin heou keil eni. ");
INSERT INTO pma_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ven koanik, out enek amul avise en ‘Atan ten Ara’ rokol kosa. ");
INSERT INTO pma_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Evus, asa koa Ahi viteni ka en provet Seremaea mai vi anatin koa vit, “Keil akur silva mani hanumau tai ka halualim (30), mal en mani koa me-Isrel keil alingi vi hulien ten moulien onen. ");
INSERT INTO pma_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ka ral min mani enek, avul hati atan ran meatin koa mumon tounah keil en tanvili, suval koa Ahi Asuv meng kat inau eni.” ");
INSERT INTO pma_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Navong koanik mul kur out, Iesu mul mulomal en meten asuv Paelet koa vi avat ten kavmen ten out enek. Ka Paelet visi vit, “?Mukave? ?Anatin keke kovi asuv houlu onen Siu keil?” Iesu vit kesi vit, “Suval koa koviteni.” ");
INSERT INTO pma_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ka navong asuv keil onen pris keil ka elda keil aselus va kati, kei rovit kes etai tounah vakataun usite onen. ");
INSERT INTO pma_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Sakini Paelet visi vit, “?Keik korraengontei selusien houlu koa keil amul aviteni vakatuk?” ");
INSERT INTO pma_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ka Iesu ro raeng mules, rovit kes etai selusien one. Navong asuv Paelet les sakien onen, mutimanin houlu. ");
INSERT INTO pma_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Vi sakien matu onen asuv Paelet keke en avong ten Anien ten Mul Laui, hemae lat meatin tai koa meatin keil arie lati keke va sital ran eim takeih. ");
INSERT INTO pma_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","En avong enek, lariken tai mul en eim takeih, isen Barabas koa meatin keil akilea en tounah keil tatisa koa mumoni. ");
INSERT INTO pma_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Sakini navong asuv Paelet lesi keke mari vangi meatin keil alah ruai, vis keil vit, “?Koa kave emi vati mamaeni vasital: Barabas vuo Iesu koa avise en Mesaea?” ");
INSERT INTO pma_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Kei visi mukonek veni lei kilea tuai keke asuv keil onen pris keil asa lat Iesu mini veni amul avi elu eni. ");
INSERT INTO pma_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ka navong Paelet mul veah rondan en kot onen, ahin onen san selusien mai mini vit, “Konoumon etai tounah naha kat meatin enek veni kei mal revi. Kosa, namundemko houlu ven matil vovoien tai koa nalesi usil meatin enek.” ");
INSERT INTO pma_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ka asuv keil onen pris keil ka elda keil aleh rendemien onen vangi meatin keil keke avahis Paelet hemae lat Barabas vamaluv, ka uas Iesu hemat. ");
INSERT INTO pma_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Paelet va vis vangi meatin keil enek vit, “?Koa kave en keilu emi vati mamae lati vamaluv?” Ka keil avisohiso avit, “!Barabas!” ");
INSERT INTO pma_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Paelet vis keil vit, “?Hemukonek, numon asa en Iesu koa avisi en Mesaea?” Keil vasi avisohiso avit, “!Ti kati en aiveave!” ");
INSERT INTO pma_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ka Paelet vis keil vit, “?Vensa? ?Kei mumon sa tisa?” Ka avisohiso keih imok avit, “!Ti kati en aiveave!” ");
INSERT INTO pma_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Navong Paelet lesi keke sakras vahiles rendemien one ka vesesal avoumon rea, kei kur oai ka kas hen en meten meatin vasi keil. Ka navong mumoni, viteni min keil vit, “Kosa, nakas motein hek ran ara ten matien onen meatin ekek veni, en metok, romumon etai tounah keke vamat veni. !Sakini, munak hemat, ara onen hel en hemi enges!” ");
INSERT INTO pma_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ka vangi meatin keil avit kesi avit, “!Tahos, ran hel en hemai ka en hen titamai keil!” ");
INSERT INTO pma_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Sakini, musil envatien one, Paelet mae lat Barabas sital, ka meng kat meatin tavaeen keil onen avatah Iesu en viau takan ka avalamuni vahina avati kati en aiveave. ");
INSERT INTO pma_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Navong amutah Iesu evus, meatin tavaeen keil onen Paelet amulamuni va en teahu ten mari eim ome ka avise ruain meatin tavaeen sav keil en out enek umai. ");
INSERT INTO pma_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Keil asakit lat eisin omon Iesu ka akav koe en kaliko tai koa vilhili suval omon asuv houlu tai. ");
INSERT INTO pma_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Evus, keil amumon tohtohien eni. Avil vatluvoluv en viau koa sin tetaveah mul ien ka alingi en vatin. Aling eisal tai en hen matu ka aretengeiril en meten suval avouhou mini. Ka navong amumoni aviteni avit, “!O asuv houlu onen Siu keil, mevouhou minuk!” ");
INSERT INTO pma_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Evus, amutiv kati ka asakit lat eisal rani ka amuas vatin eni. ");
INSERT INTO pma_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Navong amumon tohtohien mini evus, akulat kaliko tahilhili rani, ka amusin eni en eisin kati omon. Evus, amulamuni keke avati kati en aiveave. ");
INSERT INTO pma_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Navong meatin tavaeen keil amulamun Iesu uva, ales meatin tai mul en sise, isen Saemon ten out Saerin. Meatin tavaeen keil umai veni ka akeih kati vahus aiveave onen Iesu. ");
INSERT INTO pma_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Amulamun Iesu vina en Hou Kolkota koa aneite teni vi ‘Out ten Asi ten Avat.’ ");
INSERT INTO pma_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","En out enek, asan uaen min Iesu koa avilesi ral min tounah koa kun. Ka navong Iesu mun visi, seseini. ");
INSERT INTO pma_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Evus, amuti kati en aiveave. Navong mul murur, ason daes keke avatiti eisin keil omon min keil. ");
INSERT INTO pma_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ekonek, keil arondan ka alei kokoe. ");
INSERT INTO pma_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ka en aiveave onen, nesa en vatin, aling tisien tai koa amutisi eni avit, ‘Koanik vi Iesu, Asuv Houlu onen Siu keil.’ ");
INSERT INTO pma_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","En avong enek, amuti kat tarhena elu ral mini, tai en usiven matu ka tamun en usiven meil. ");
INSERT INTO pma_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Navong murur en aiveave, meatin keil koa amual vesesal veni akalialin vate ka amunge kat Iesu ");
INSERT INTO pma_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","avit, “!Ei, keik koa kovit ku rasilin Eim Votut ka kum risi en avong hetel enges, hetahos imok keke kikataun vis keik sasom enges! !Munak kovi Natin Ahi anatin, kisuvul ran aiveave enek!” ");
INSERT INTO pma_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","En vati sakien enek, asuv keil onen pris keil, tiser keil ten mengkatien onen Mosis, ral min elda keil emun amumon tohtohien min Iesu. ");
INSERT INTO pma_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Keil amumon tohtohien mini avit, “!Alles visi! Kei kilea vakataun meatin sav keil, ka sakras vakataun kei sasen. !Munak anatin keke kei vi asuv houlu onen me-Isrel keil, hemita netan ran aiveave koanik kosa. Hemukonek, ir rehekur anatin esuk eni. ");
INSERT INTO pma_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Kei ling desien onen en Ahi ka viteni vit, ‘Inau navi Natin Ahi.’ Tahos, munak Ahi en vat meatin eke, kei hemai hekatauni.” ");
INSERT INTO pma_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ka en vati sakien enek, tarhena keilu koa amuti kat keilu en usiven keilu, keilu emun luselus kareni. ");
INSERT INTO pma_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","En taviai varei, mankoli mai mutaluh koe out vasi haoa etel (3). ");
INSERT INTO pma_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ka navong haoa etel enek evus, Iesu visohiso keih en selusien kati onen koa vi Arameak vit, “!Ilae! !Ilae! ?Lama sabaktani?” Aneite ten selusien enek vi, ‘!Ahi onak! !Ahi onak! ?!Vensa kosokoveinau!?’ ");
INSERT INTO pma_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Navong meatin tei keil koa amulomal en out enek araengoni avit, “?Milonge? Kei mul vise provet Ilae-tsa.” ");
INSERT INTO pma_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Hatte tas, tai en keil muloh, kur soke kaliko tai, ka kasi en uaen takun. Evus, lingi en kele ai tai ka sani vina min Iesu vasimi. ");
INSERT INTO pma_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ka tei sav en keil aviteni avit, “Veitir mau ka rovales visi. ?Ilaetsa hemita hekatauni, vuo hermaitei?” ");
INSERT INTO pma_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Evus, Iesu mis roha, leh kor en eang, ka mat. ");
INSERT INTO pma_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","En hati avong enek, kaliko koa matetel koa aleh koe hati out koa vi votut en Eim Votut, sipasi elu en ngolite nesa vita varei rokol ngolite netan. Alu mulu ka ahat keil apas ");
INSERT INTO pma_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ka sakin avul tatetahinien sipasi mutah. Meatin houlu onen Ahi koa umat amul ien, keil amoul eris ran matien. ");
INSERT INTO pma_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Keil asital ran avul tatetahinien one ka amual. (Ka navong Iesu mun moul eris ran matien, meatin houlu ales meatin keil enek en out Serusalem koa vi taon votut onen Ahi.) ");
INSERT INTO pma_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Navong avat onen meatin tavaeen keil ka meatin keil onen koa alei kokoe en Iesu alonge alu mulu ka ales tounah vasi koa kur out, keil ametau houlu ka aviteni avit, “Anatin eli, kei vi Natin Ahi varei.” ");
INSERT INTO pma_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ka ahin houlu avati keil soutin neli ran aiveave ka amul ales tounah koa kur out. Vangi ahin keil enek akataun Iesu navong mum en out Kaleli ka amusili umai en out Serusalem. ");
INSERT INTO pma_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ka en koakeil enek, keitel telvi Meri ten out Makdela, Meri mama onen Tiemes ka Siosep, ka mama onen natin Sepeti keilu. ");
INSERT INTO pma_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Vesesal out vavong ka Sabat vamai. Sakini meatin tai ten out Aramatea koa tounah onen houlu mai ven asuv Paelet, isen Siosep. Kei mun vi tai en koakeil amul amusil kat Iesu. ");
INSERT INTO pma_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Navong mulomal en meten Paelet, visi vamaen teiai onen Iesu mini. Sakini Paelet meng kat meatin tavaeen keil onen uva akulati ka asani mini. ");
INSERT INTO pma_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Sakini Siosep kuri ka kav koe en kaliko tamuoh koa muto. ");
INSERT INTO pma_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Evus, Siosep vousi ka lingi en valengeihat tatetahinien kati onen koa arei meseini tuai vi heite hau. Evus, rein mari ahat tai koteh koe voiteh ten valengeihat enek ka lokoveini va. ");
INSERT INTO pma_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Meri ten out Makdela ka Meri tateisav lumul lurondan soutin neli en out enek, mal en voiteh ten valengeihat. ");
INSERT INTO pma_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Out mulan en Sabat, asuv keil onen pris keil ka Farasi keil uva avales Paelet. ");
INSERT INTO pma_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Umai veni ka aviteni avit, “Asuv, memundem kati keke navong meatin taluvosien enek moul veah kei viteni vit, ‘Avong hetel evus, inau nimoul eris ran matien.’ ");
INSERT INTO pma_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Sakini, keik kimeng kat meatin tavaeen keil onom iha ilei kokoe revi en valengeihat tatetahinien onen hetokol avong hetel heli heha. Veni munak kirmumontei, vahera meatin keil onen iha ka ihenan teiai onen. Hesakini, akilea avahiteni keke moul eris ran matien. Ka munak sakien koanek hekur out, luvosien ekor enek hetisa helohlin luvosien koa mulamu navong kei vit vi Mesaea onen Ahi.” ");
INSERT INTO pma_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Navong asuv Paelet longe, maeni vit, “Tahos, mihekur vangi meatin tavaeen tai onak keke avalei kokoe revi en valengeihat enek musil sakien koa kami emi vati.” ");
INSERT INTO pma_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Sakini keil uva ral min meatin tavaeen keil, aling siil vating koe voiteh teni, ka aling vangi meatin tavaeen keil alei kokoe. ");
INSERT INTO pma_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Navong Sabat evus, out mulan en Sande, Meri ten out Makdela ka Meri tateisav luva keke luvasao en valengeihat tatetahinien onen Iesu. ");
INSERT INTO pma_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Hatte tas, alu mulu keih veni angelo tai onen Ahi Asuv mita netan ran out nesa. Kei rei lat ahat koa mul koe voiteh eva, ka rondan eni. ");
INSERT INTO pma_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Aven angelo enek vihil suval ahil vil, ka eisin omon muoh vis muoh. ");
INSERT INTO pma_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Navong meatin tavaeen keil alesi, ametau houlu ka ale maleilei. Keil umotmot ka e von, asakras avoumon etai tounah. ");
INSERT INTO pma_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ka angelo selus min luahin enek vit, “!Milnametautei! Nakilea milmul millekat Iesu koa amuti kati en aiveave. ");
INSERT INTO pma_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Kei rorotei mun ekok. Anatin, kei moul eris ran matien suval koa kei viteni. Milhemai ekok ka milheles out koa aling teiai onen mul ien. ");
INSERT INTO pma_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ekek, milhekalah milheha ka milhehiteni min onen keil milhehit, ‘Iesu moul eris ran matien ka helamu en kami heha en out Kaleli. Ekonek kami mihelesi.’ Koanik vi selusien koa Ahi sila inau mahiteni min kamil.” ");
INSERT INTO pma_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Sakini keilu lumea ran valengeihat ka lukalah lumuloh luva keke luvahithiteni min meatin keil onen Iesu. Lumetau ka annivul kat keilu, ka mukos, luvilelau en sien. ");
INSERT INTO pma_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Navong lumul veah luva, hatte tas, Iesu visu min keilu ka vit, “!More! Tomat onen Ahi heto ven kamil.” Navong lulesi, lumai veni, ka lumot luvuli kat alen keilu ka luvouhou mini. ");
INSERT INTO pma_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Evus, Iesu viteni min keilu vit, “Milnametautei. Milheha ka milhehiteni min tuak keil en demkatien keke iha en out Kaleli, ka en out enek keil iles inau.” ");
INSERT INTO pma_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Navong luahin enek lumul luva, tei en meatin tavaeen keil koa alei kokoe en valengeihat uva ris Serusalem ka aviteni min asuv keil onen pris keil tounah vasi koa kur out. ");
INSERT INTO pma_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Sakini, asuv keil onen pris keil aselus ruai ral min elda keil ka aling rendemien tai. Avul meatin tavaeen keil enek en mari mani tai ");
INSERT INTO pma_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ka aviteni min keil avit, “Kami mihehithiteni mihehit, ‘Navong komai memul mematil, meatin keil onen Iesu umai en vongien ka avenan teiai onen.’ ");
INSERT INTO pma_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ka munak longlongien koanik hetokol asuv Paelet, komai meheselus en usite onami ka meheting koe kami keke minakurtei mahien veni.” ");
INSERT INTO pma_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Sakini meatin tavaeen keil enek akur mani ka amum usil asa aviteni. Ka selusien koanik mul karahit out vasi koa Siu keil aro ien rokol kosa. ");
INSERT INTO pma_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ka meatin teindan tai (11) onen Iesu koa amules uva en out Kaleli ka avina en hou koa Iesu vit meseini min keil tuai. ");
INSERT INTO pma_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","En out enek, keil ales Iesu. Navong alesi, uva netan mini, ka keil koa arkurtei anatin eni. ");
INSERT INTO pma_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ka Iesu mai vesesal ka viteni min keil vit, “Tata onak ling tounah vasi en out nesa ka en out netan mul en hek. ");
INSERT INTO pma_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Sakini, inau naviteni min kami keke miheha ven meatin keil koa amul en kantri vasi keil ka mihoumon keil emun ihi meatin keil onak. Navong amusil kat nau, mihehi baptaes en keil en isen Tata, en isen Natnali, ka en isen Ninin Votut. ");
INSERT INTO pma_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ka mihehisein keil ilong kat tounah vasi nameng kat kami eni. Ka inau, nito hetal min kami lisenges, hetokol avong koa out netan hevus.” ");
INSERT INTO pma_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Koanik vi more longlongien onen Iesu Kristo, Natin Ahi. ");
INSERT INTO pma_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Longlongien enek usil Mesaea mai rohtoh en ir suval koa Ahi viteni ka en tisien onen provet Aesea vit, “!Kitaengoni! Nisila eiloheh onak vasak revi sise venuk. ");
INSERT INTO pma_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","En out volvol, meatin enek hehisohiso hehit, ‘!Sak revi sise ven Asuv heka ien! !Houmon sise onen hemal!’” ");
INSERT INTO pma_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Eiloheh koa Aesea mul vit usili, isen Sion. Kei va en out volvol ka avise en Sion Baptis veni vi baptaes en meatin keil ka mul san selusien onen Ahi min keil vit, “!Mihehiles moulien onami ran tisaen! Mihemaenau nihi baptaes en kami vatie lati keke methos onen Ahi mul en kami.” ");
INSERT INTO pma_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ka meatin houlu vis houlu mok en provins ten out Sudea ka mari meteimal ten out Serusalem, uva ven Sion. Avitehiten tisaen keil one ka kei vi baptaes en keil en Oaisal Sodan. ");
INSERT INTO pma_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Musin en eisin koa amumoni en hilin kamel ka mutoh eni. Anien an vi kal ka hani koa suka bak keil amumoni en eivorohus. ");
INSERT INTO pma_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ka kei mul viteni min meatin keil vit, “Katau enau, hetamen tai hemai. Kei marite mok mulin inau, narvinvintei li makulat sandel onen. ");
INSERT INTO pma_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Inau navi baptaes en kami en oai enges, ka kei, hehi baptaes en kami en Ninin Votut.” ");
INSERT INTO pma_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","En avong enek, Iesu ka en meteimal ten out Nasaret en provins ten out Kaleli, ka Sion vi baptaes eni en Oaisal Sodan. ");
INSERT INTO pma_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ka navong Iesu mea ran oai, lele vina nesa ka les teilang mutah. Ka Ninin Votut muka mita netan ka rondan eni suval ame tai. ");
INSERT INTO pma_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ka rea tai ka en out nesa vit, “Keik, kovi natkuli. Ka inau, nasi nau venuk.” ");
INSERT INTO pma_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Navong Iesu mea ran oai, Ninin Votut sila vina en out volvol, ");
INSERT INTO pma_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ka kei ro en out enek rokol avong hanumau elu (40). En avong keil enek, Temat mul sak visi. Ka Iesu ro en out enek ral min tirendan keil, ka angelo keil alei kat revi. ");
INSERT INTO pma_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Katau en avong aling Sion en eim takeih, Iesu va en out Kaleli ka vitehiten more longlongien koa ka ven Ahi. ");
INSERT INTO pma_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Kei mul viteni vit, “!Avong mal vinvin koa hiasuvien onen Ahi hemai hel ekok! !Mihehiles moulien onami ran tisaen, ka mihekur anatin en more longlongien koa naviteni min kami!” ");
INSERT INTO pma_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Navong Iesu mul mual va en vali oai en out Kaleli, kei les Saemon Pita ka tunali Andru. Keilu luvi meatin talah mesauien ka lumul luson net onealu vita en oai. ");
INSERT INTO pma_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Viteni min keilu vit, “!Lumai, milhousil nau! Kosa millah mesau enges, ka inau nihisein kamil mukave milhelah meatin keil.” ");
INSERT INTO pma_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Hatte tas, lumali time luling net onealu mules ka lumusil Iesu. ");
INSERT INTO pma_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Iesu mual eva ka les Tiemes ka Sion, koa tata onealu Sepeti. Luro en vot ka lurili revi net onealu. ");
INSERT INTO pma_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Navong les keilu, vise keilu vit, “!Lumai, milhousilnau!” Sakini, luvut ran vot ka lumea ran tata onealu ral min meatin toumien keil oneatel, ka luva lumusil Iesu. ");
INSERT INTO pma_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Iesu ral min meatin onen telva en meteimal ten out Kapaniam. En Sabat, telva en eim tahihiseien onen Siu keil ka Iesu mul vihisei eni. ");
INSERT INTO pma_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Koakeil vasi amutimanin en keihoen ten hihiseien onen, koa rosuvaltei tiser keil ten mengkatien onen Mosis. ");
INSERT INTO pma_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ka rovitei tuetin, navong Iesu mul vihisei veah, meatin tai koa ninin tisa mul ien va neim en out enek. ");
INSERT INTO pma_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Kei visohiso vit, “?Iesu ten out Nasaret, kovit kovoumon sa min komai? ?Kovit kovou rasilin komai? !Inau nakileak! !Keik kovi Meatin Votut onen Ahi!” ");
INSERT INTO pma_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Iesu vul kat ninin tisa enek vit, “!Konavertei! !Mea rani!” ");
INSERT INTO pma_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Sakini, ninin tisa enek maleilei kat meatin enek, visohiso keih ka mea rani. ");
INSERT INTO pma_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ka koakeil vasi koa alesi, amutimanin eni. Amul aviteni min keil eris avit, “?Asa keinek? !Koanek vi hihiseien hau tai koa keihoen mul ien! Kei sel kat ninin tisa keil, ka along kati.” ");
INSERT INTO pma_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ka rovitei tuetin, longlongien usil asa koa Iesu mul mumoni ka vasi out en provins ten out Kaleli. ");
INSERT INTO pma_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ka navong Iesu keitel telmea ran eim tahihiseien, kei ral min Tiemes ka Sion telmusil Saemon Pita keilu Andru telva teim sealu. ");
INSERT INTO pma_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Navong telva en out enek, aviteni min Iesu keke avu tisa onen Saemon Pita mesai, mul en avet veni aven mutin. ");
INSERT INTO pma_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Iesu va veni, vuli kat hen ka rali lati mea. Hatte tas, mesaien vuol rani, kei longe tahos ka mumon anien aeatel. ");
INSERT INTO pma_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","En mendilah enek, navong Sabat evus ka meatin keil akilea avoum, alah koakeil amesai ral min keil koa ninin tisa mul en keil, uva ven Iesu. ");
INSERT INTO pma_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Sakini, meatin keil vasi en meteimal en out enek alah ruai rahit eim koa Iesu ro en. ");
INSERT INTO pma_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ka Iesu lah lat mesaien ran meatin houlu, ka vile lat ninin tisa keil avaha. Ka romaentei ninin tisa keil avaselus ven akilea kei vi Mesaea koa Ahi vat kati keke hemai. ");
INSERT INTO pma_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","En visokon semau, out vong veah, Iesu mea ran keil, va en out tai koa kilea heto kei sa sen, ka mul vis. ");
INSERT INTO pma_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ka navong Saemon Pita ka teisav emun keil amea, amul alekat Iesu. ");
INSERT INTO pma_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ka navong alesi aviteni mini avit, “!Meatin keil vasi e vati avalesuk!” ");
INSERT INTO pma_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ka Iesu viteni min keil vit, “Nakilea. Ka numai ven mailea mahiten more longlongien min meatin vasi keil. Rovaha en out sav.” ");
INSERT INTO pma_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Evus, telva en out vasi en provins ten out Kaleli. Ka kei mul visein meatin keil en eim tahihiseien onen Siu keil ka vile lat ninin tisa keil uva ran meatin keil. ");
INSERT INTO pma_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Navong Iesu keitel telmul veah en provins ten out Kaleli, meatin tai koa kur mesaien ten leprosi va ven Iesu, retengeiril mini, ka peahi vit, “Munak komaeni li, kokilea kovoumon hilivek vamai vato ris.” ");
INSERT INTO pma_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Iesu en mahis meatin enek, ling hen mul ien ka viteni vit, “!Mal! !Kito ris!” ");
INSERT INTO pma_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Hatte tas, mesaien enek va rani ka aven muto varei. ");
INSERT INTO pma_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Evus, Iesu selus keih imok mini mukok vit, ");
INSERT INTO pma_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“!Konahitentei asa koa namumoni minuk min meatin sav! Kihas en Eim Votut, kihit lat keik min pris, ka kikur sanien votut koa Mosis viteni. Hesakini, koakeil vasi ilea keke keik komuto.” Ka Iesu sila meatin enek va. ");
INSERT INTO pma_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ka navong va rani, mang vas ongon houlu ka viteni min meatin savsav keil asa koa Iesu mumoni mini. Sakini, Iesu sakras vaha en out koa meatin keil alango ien. Mukos, rovatei mun en meteimal keil. Ka meatin keil aka soutin en out vasi keke umai avalesi. ");
INSERT INTO pma_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Avong vahis muli, Iesu muris va en taon ten out Kapaniam, ka keil ten out enek alonge keke ro teim tai. ");
INSERT INTO pma_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Keil houlu umai asien teim enek, sakini out mutikoe neim ka meatin houlu mun amules arapehai en voiteh, ka Iesu mul visein keil en selusien onen Ahi. ");
INSERT INTO pma_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Navong Iesu mul semau vihisei, meatin ehat telmai telvou kakan tueatel koa mules en vulin veni hati usiven mat. ");
INSERT INTO pma_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ka veni meatin keil avi houlu, telsakras telvakur tueatel vaha min Iesu. Sakini, telvousi vina en hoi eim ka aleng ahho tai, mal en out koa Iesu ro ien. Evus, telrutun tueatel vita ka vas meatin keil koa amul en out enek. ");
INSERT INTO pma_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ka navong Iesu les asa telmumoni, lei kilea demkatien oneatel ka viteni min meatin enek vit, “Tuak, kosa, Ahi rolestei mun vatisa enuk ven tisaen keil onom.” ");
INSERT INTO pma_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ka navong tiser keil ten mengkatien onen Mosis koa amul arondan en out enek along selusien koa Iesu viteni, asel kutut kati en rendemien one avit, ");
INSERT INTO pma_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“?Vensa kei run mukok? ?Kei mundemi kei vinvin suval Ahi? !Ahi tas kilea valah lat tisaen!” ");
INSERT INTO pma_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Navong amundemi mukok, Iesu kilea ka viteni min keil vit, “?Vensa mimul mirendem en tounah enek? ");
INSERT INTO pma_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Maes imok minau keke nihiteni min meatin ekek koa sakras vakaka nihit, ‘Nikulat tisaen onom,’ veni kami misakras mivalesi munak nakur keihoen keke moumoni. Ka keih keke nihiteni nihit, ‘!Mea! Lum lat vulum ka ha teim,’ veni milei kilea munak nakur keihoen keke moumoni vuo narkurtei. ");
INSERT INTO pma_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ka veni ek vat kami mivalei kilea keke Natin Meatin kur keihoen keke vakulat tisaen ran meatin keil ten out netan, miheles koanik …” Ka Iesu viles, les meatin koa sakras vakaka vit, ");
INSERT INTO pma_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“!Mea! Lum lat vulum ka kiha teim.” ");
INSERT INTO pma_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Hatte tas, meatin enek ravul mea, lum lat vulin ka mea sital ran keil. Ka navong meatin keil koa amul en out enek alesi, amutimanin ka amasmas Ahi veni. Amul arun eni avit, “!Ekovei! !Rorles etai li tounah vamukok!” ");
INSERT INTO pma_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Navong tamun, Iesu va ut en Mari Oai ten out Kaleli. Tali meatin keil umai akarahiti, ka kei mul visein keil. ");
INSERT INTO pma_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ka navong mul mual va, visu min meatin tai koa mul kur takis ran meatin keil en titi eim mon, isen Livae, natin Alveas. Ka Iesu vise vit, “!Amai! !Usil inau!” Ka kei lokovein umen onen mules ka musil Iesu. ");
INSERT INTO pma_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Evus, en mendilah, Iesu ral meatin keil onen amul akanian en teim sen Livae. Meatin houlu ten takis ka meatin tisa keil, amul akanian ral min keil veni houlu en keil emun amusil kat Iesu. ");
INSERT INTO pma_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ka navong tei en Farasi keil koa avi tiser keil ten mengkatien onen Mosis emun ales Iesu mul kanian ral min meatin keil ten takis ka meatin sav keil koa arendem tisa en keil, amutimanin. Avis meatin keil onen Iesu avit, “?Vensa kei mul kanian ral min vati meatin tisa keil koa amukok?” ");
INSERT INTO pma_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ka Iesu raengon selusien one ka vit kesi min keil vit, “Meatin keil koa ave tahos e rovattei avaha avales dokta. Ka koakeil akilea amesai, keil e vati avaha avalesi. Narmaitei mahise meatin keil koa amundemi avit moulien one mal tuai keke avamai avousil inau. Vuo, numai mahise meatin keil koa akilea mesaien ten tisaen mul en keil keke ihiles moulien one ka usil inau.” ");
INSERT INTO pma_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","En avong tai, meatin keil onen Sion Baptis ka Farasi keil amul uval ran anien. Meatin keil umai ka avis Iesu avit, “Meatin onen Sion ka Farasi keil uval ran anien, ka meatin onom keil armumontei. ?Vensa?” ");
INSERT INTO pma_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Iesu vit kesi min keil en tatavolien tai vit, “Navong meatin tai vatetalihe, meatin keil koa umai ven mari ale enek, asi keil veni. Sakini, asakras avahal ran anien navong kei ro veah ral min keil. ");
INSERT INTO pma_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ka avong mul mai keke kei hevuol ran keil. En avong enek, keil ihal ran anien ven ilonge hetisa.” ");
INSERT INTO pma_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ka Iesu vit risi min keil en tatavolien tamun vit, “Meatin etai sakras vatili koe eisin matu en soke eisin hau. Veni navong akasi, hatte koa heite hau mai sim kati ka hetali vas koa heite matu, hesakini hemahoi hemariso suk. ");
INSERT INTO pma_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","En vati sakien enek, meatin etai sakras vatah uaen koa heite hau vaha en veite matu koa amumoni en hiliven sipsip veni keih tuai. Uaen enek hetatahou ka hesipas veite enek, hesakin uaen enek houele. Hesakini, uaen enek koa heite hau heha mok en veite koa heite hau veni kei memerau, kilea vatatahou.” ");
INSERT INTO pma_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","En Sabat tai, Iesu ral meatin onen keil amual uva aka vas ah tai ten uit ka amul alah utite, akokoa, ka amul akani. ");
INSERT INTO pma_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ka Farasi oteta keil alesi ka avis Iesu avit, “?Vensa varei meatin onom keil amum en Sabat? Umen enek rali koteh mengkatien onen Mosis.” ");
INSERT INTO pma_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ka Iesu vit kesi min keil vit, “?Kami mirkileatei asa koa Deved ral min meatin onen keil amumoni navong amai kat keil, ka anien ae tovuol? ");
INSERT INTO pma_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","En avong enek, Abiatar vi asuv houlu onen pris keil, ka Deved va neim en Eim Votut ka visi ven veret koa vi votut, koa pris keil enges ten Eim Votut akilea avaani. Abiatar maeni, ka Deved kani ka riti mun min meatin onen keil akani.” ");
INSERT INTO pma_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Iesu vit kilea min keil vit, “!Ahi mumon Sabat keke vakataun meatin keil! Kei romumontei meatin keil keke avakataun Sabat. ");
INSERT INTO pma_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Sakini, Natin Meatin vi hetetamen imok mulin Sabat.” ");
INSERT INTO pma_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Iesu va ris en eim tahihiseien, ka en out enek meatin tai hen kali. ");
INSERT INTO pma_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ka koakeil aro en out enek, amul alei mamah eni keke avalesi munak kei houmon hen meatin enek hetahos en Sabat veni alekat tounah koa akilea avasan selusien tisa vaha kati. ");
INSERT INTO pma_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ka Iesu viteni min meatin enek helomal en meten meatin keil. ");
INSERT INTO pma_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Evus, vis keil vit, “?Mengkatien onen Mosis maen ir keke rovoumon sa en Sabat? ?Maeni keke rovakataun meatin, vuo rovapuruni? ?Maeni keke rovoutut moulien onen meatin tai, vuo rovou vini?” Ka keil aro raeng enges. ");
INSERT INTO pma_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Navong Iesu lei rahit keil, tin kat keil. Ka longe tisa keke rendemien one koteh en tounah onen Ahi. Evus, Iesu viles ka viteni min meatin koa hen tisa vit, “!Kitea hem!” Ka navong mutea eni, hen mai ris tahos. ");
INSERT INTO pma_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ka navong Farasi keil ales asa koa mumoni, amea ran out enek, ka, hatte tas, uva alah ruai ral min Siu keil koa asuv kat hiasuvien onen asuv houlu Herod. Ka alekat vis sise tai koa akilea avouas Iesu vamat vaka ien. ");
INSERT INTO pma_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Iesu ral min meatin onen keil uva en Mari Oai ten out Kaleli, ka meatin keil houlu amusili. Tei en meatin keil aka en provins ten out Kaleli, Sudea, ");
INSERT INTO pma_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ka Itumea. Ka koakeil emun aka en taon ten out Serusalem, Taer ka Saedon. Ka teisav en keil aka en usite sav ten Oaisal Sodan. Meatin vasi keil enek umai ven Iesu, veni araengon asa koa kei mul mumoni. ");
INSERT INTO pma_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Meatin keil avi houlu ramat, sakini Iesu viteni min meatin keil onen vit isak mesein vot veni keke meatin keil anating kattei kei. ");
INSERT INTO pma_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Koakeil amesai amul amuting keil avatokol Iesu, veni kei mumon meatin houlu atahos eris. ");
INSERT INTO pma_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ka navong meatin keil koa ninin tisa mul en keil alesi, uva netan mini, ka amis kai avit, “!Keik, kovi Natin Ahi!” ");
INSERT INTO pma_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ka Iesu vul kat ninin tisa keil vit anahitentei min meatin keil anahit kei vi isei. ");
INSERT INTO pma_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Evus, Iesu vina en vatihou nesa ka rie lat meatin koa kei en vati avousili, ka umai veni. ");
INSERT INTO pma_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ka kei rie lat meatin teindan elu (12) keke avousili avamai avahi eiloheh keil onen, avaha avahitehiten more longlongien min meatin keil, ");
INSERT INTO pma_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ka avahile lat ninin tisa ran meatin keil vatal min keihoen ten isen. ");
INSERT INTO pma_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Koanik vi isen eiloheh teindan elu (12) koa Iesu rie lat keil: Saemon (koa Iesu ling isen tamun vi Pita); ");
INSERT INTO pma_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Tiemes ka tunali Sion koa Iesu vise keilu en ‘natin voulul’ (koa tata onealu Sepeti); ");
INSERT INTO pma_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andru, Pilip, Batolomiu, Matiu, Tomas, Tiemes (natin Alveas), Tatios, Saemon (koa vi lariken), ");
INSERT INTO pma_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ka Sudas Eskariot koa hemae lat Iesu heha en hen meatin tisa keil. ");
INSERT INTO pma_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Iesu rie lat eiloheh teindan elu (12) onen evus, uva en teim tai en taon ten out Kapaniam. Ekonek, meatin houlu umai avalesi, sakini avong tovuol keke Iesu ka meatin keil onen avaanian. ");
INSERT INTO pma_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Navong mama onen ral min tunali keil akur longlongien usil asa koa Iesu mul mumoni ka mukave meatin keil amul aviteni keke mul mum vau, uva keke avaselus koe ka avahuli kati. ");
INSERT INTO pma_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Tei en tiser keil ten mengkatien onen Mosis aka en out Serusalem. Ka keil asan selusien va kat Iesu avit, “Belsepul koa vi asuv onen ninin tisa keil mul ien ka mul san keihoen mini keke vahile lat ninin tisa keil ran meatin keil.” ");
INSERT INTO pma_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Sakini, Iesu vise Farasi keil umai veni ka selus min keil ka en tatavolien keil vit, “?Temat kilea vahile lat kei eris hemukave? ");
INSERT INTO pma_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Munak meatin keil onen asuv houlu tai amul uvae min keil eris, keihoen onen asuv houlu enek sakras val vataveah. ");
INSERT INTO pma_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ka munak vatiamal tai mul vae ral min keil eris, isen vatiamal enek heha hevuol varei. ");
INSERT INTO pma_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","En vati sakien enek, munak Temat mul vile lat ninin tisa keil onen ka mul vae ral min keil eris, keihoen onen sakras val vataveah ka hevuol varei rani. ");
INSERT INTO pma_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Mahit kilea min kami vaka en tatavolien tai. Meatin sakras vaha en teim sen avkeih tai keke vahenan tounah keil onen navong avkeih koanek mul veah lei kokoe eni. Helamu, heha hepar kat avkeih enek. Hevus, meatin enek kilea vaha en teim sen ka valah vasin tounah keil onen. ");
INSERT INTO pma_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Anatin eli naviteni min kami, Ahi kilea voumon methos onen vatal min meatin keil koa amumon vati tisaen keil houlu, vuo aselus karen isen Ahi varei. ");
INSERT INTO pma_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ka methos onen Ahi sakras val en meatin koa mul selus karen Ninin Votut ka tounah koa kei mul mumoni. Sakien tisa enek heha kat usite onen ka mahien koa hekuri veni sakras vavus.” ");
INSERT INTO pma_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Iesu viteni mukok veni Farasi keil aviteni keke kei mul mum ral min keihoen onen ninin tisa koa mul ien. ");
INSERT INTO pma_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Mama onen Iesu ka tunali keil umai keke avalesi, ka amules hae. Asan selusien va neim keke Iesu vaha hae vales keitel. ");
INSERT INTO pma_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","En avong enek, meatin keil houlu aro rahit Iesu ka aviteni mini avit, “Lesi, mama onom ral min tumali keil aro hae, ka e vati avalesuk.” ");
INSERT INTO pma_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ka Iesu vit kesi min keil vit, “?Isei vi mama onak? ?Isei vi tuak keil?” ");
INSERT INTO pma_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Evus, lei rahit meatin keil enek ka viteni min keil vit, “Milesi. Koakeil enek avi mama onak ka tuak keil. ");
INSERT INTO pma_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Koakeil amumon asa koa Ahi en vati avi mama onak ral min tuak ka ahinkuli keil.” ");
INSERT INTO pma_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","En avong sav tai, Iesu mul visein meatin onen keil en vali Mari Oai ten out Kaleli. Meatin keil houlu aso ruai rahiti, ka keil avi houlu vis avi houlu mok. Sakini, Iesu vut va en vot ka ario lati vita en oai, ka meatin keil aro enges ut. ");
INSERT INTO pma_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Evus, Iesu ra usil tatavolien houlu keke vahisein meatin keil. Viteni vit, ");
INSERT INTO pma_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“!Mihelong revi! En avong tai, meatin tai va nah vativin utite keil. ");
INSERT INTO pma_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Navong va rivini, vahis umotmot en sise ka aman keil umai akan vasi. ");
INSERT INTO pma_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ka vahis umotmot en atan koa vilah, atan romaritetei. Ka keil aviteh kalah ven atan mahinhin enges. ");
INSERT INTO pma_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ka navong meteiai keih, amaleles ka umatmat ven lite keil arretalitei vatahos. Sakini, rovitei tuetin, amukou varei. ");
INSERT INTO pma_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Vahis emun umotmot va en out koa oumunai tatisa mul ien ka amusar koe. Sakini, armoultei vatahos ka arsontei heite. ");
INSERT INTO pma_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ka havivi en utite keil enek umot en atan tetahos, ka amoul, ason heite: keil koa ason heite houlu neli, ka keil koa mun araleha, ka teisav en keil araleh vini keil en heite.” ");
INSERT INTO pma_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Tatavolien vus, Iesu selus vit, “Munak ralingom mul, kitaengon asa namul naviteni.” ");
INSERT INTO pma_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Navong Iesu ro sasen, teindan elu (12) onen ral min meatin sav keil uva avis aneite ten tatavolien enek. ");
INSERT INTO pma_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Sakini, kei vit, “Ahi mul vothot en rendemien suai usil hiasuvien onen min kami enges. Ka meatin sav keil koa Ahi rovitei asuv houlu one, keil araengon selusien onen Ahi ka en tatavolien keil enges koa arlong kileatei. ");
INSERT INTO pma_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ahi vit usil keil vit, ‘Keil ilonge heha vio … ka irlong kileatei. Ilele heha vio … ka irlei kileatei. Veni munak armumontei vamukonek, keil ihiles moulien one ka inau nilele hetahos eris en keil.’” ");
INSERT INTO pma_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ka Iesu viteni min keil, “?Mirlong kileatei tatavolien koanik? ?Hemukave miheilea tateisav esuk? ");
INSERT INTO pma_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","En tatavolien enek, utite keil koa meatin ten ah mul revin keil vi selusien onen Ahi. ");
INSERT INTO pma_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Meatin keil koa asuval sise koa utite keil umot amul ien. Navong araengon selusien, hatte tas Temat mai ka kulati ran keil. ");
INSERT INTO pma_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Keil koa asuval atan koa vilah. Navong araengon selusien onen Ahi, akuri mul en keil ka asi keil veni. ");
INSERT INTO pma_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ka veni lite keil ten demkatien one arretalitei vatahos, keil amulomal en demkatien one ten avong havivis. Ka navong sakvisien mai ven selusien enek, umot en demkatien one. ");
INSERT INTO pma_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Meatin keil koa asuval atan koa oumunai tatisa mul ien. Araengon selusien onen Ahi, ");
INSERT INTO pma_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ka amundemko usil tounah keil ten out netan ka envatien one mul en mani mulin selusien onen Ahi. Hesakini, selusien enek hersontei heite en moulien one. ");
INSERT INTO pma_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ka meatin keil koa mun asuval atan koa tetahos. Navong araengon selusien onen Ahi, akur kati mul en keil, ka selusien enek son heite houlu en moulien one. En moulien onen meatin keil koa heson heite houlu, en koa mun hetaleha, ka en teisav en keil hetaleh vini en heite.” ");
INSERT INTO pma_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Iesu viten tatavolien tamun vit, “Meatin tovuol koa vanit laet onen, evus, ling suaini en pesin tai, vuo ling suaini en hehen avet tamatilien onen. !Vuo! Meatin keil arekein laet one nesa keke koakeil umai neim akilea avalei kilea titinien teni. ");
INSERT INTO pma_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Anatinien koa mul suai, Ahi hekuri hemai en mesai. Ka selusien koa avit suai eni mulamu, ihitehiteni en meten meatin keil keke availea eni. ");
INSERT INTO pma_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","!Munak ralingomi mul, mihetaengon revi asa koa namul naviteni!” ");
INSERT INTO pma_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ka Iesu viteni mun min keil vit, “Mihetaengon revi asa koa naviteni min kami. Veni Ahi hesan ileilien teni min kami housil longkatien onami. Sakini, munak mihelong kati, hesan ileilien hemarite mok min kami. ");
INSERT INTO pma_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Meatin koa kilea revi selusien onak, Ahi houmoni heilea revi mok, ka meatin koa rokilea revitei aneite teni, havivi koa mundemi vit kilea eni tuai, Ahi hekulati rani.” ");
INSERT INTO pma_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ka evus, Iesu viten risi vit, “Hiasuvien onen Ahi suval avong tai, meatin tai va revin utite keil en ah sen. ");
INSERT INTO pma_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","En vongien, kei matil ka en meneai, mules mual vasi out. Ka mukos, utite keil enek amules aviteh, alekat sise one avamoul, ka meatin enek rokileatei keke amoul mukave. ");
INSERT INTO pma_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Atan enges, kei sasen mumon utite keil amoul. Anatin, keil avitehiteh, amumon vatte, ka ason heite. ");
INSERT INTO pma_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ka navong heite emen, meatin ten ah va musuhuti ka lahi va ris teim.” ");
INSERT INTO pma_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ka Iesu vit risi vit, “?Hiasuvien onen Ahi suval asa? ?Nihit kilea eni heka en tatavolien sa? ");
INSERT INTO pma_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kei suval uti avek koa mot vita en vatiai tai. Kei havivi mok en utiai vasi keil. ");
INSERT INTO pma_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ka navong moul mai mariso, mulin ai sav keil. Son angoite keil amariso ka atahos, ka aman keil umai amumon anu ome keil en nimal teni.” ");
INSERT INTO pma_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ka Iesu viten selusien onen Ahi en tatavolien keil enek, mal en asa keil availea avakuri. ");
INSERT INTO pma_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Selus min keil en tatavolien enges. Ka navong kei ro ral min teindan elu (12) onen, kei vit lat aneite teni min keil. ");
INSERT INTO pma_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","En mendilah enek, Iesu viteni min meatin keil onen vit, “Rovaha en usi oai.” ");
INSERT INTO pma_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Sakini, keil aling meatin sav keil amules, uvut uva en vot koa Iesu mul rondan ien, ka amu koteh oai ten out Kaleli uva. Ka meatin sav keil emun amusil Iesu en vot savsav keil one. ");
INSERT INTO pma_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","38","Ka navong amul uva, Iesu mul matil usae en oulung tai en valengei vot. Rovitei tuetin, amutimanin, eang takeih tai muhuh keih. Sakini, oai langlango ka mul rasil va neim en vot, vesesal keil avamarindu. Navong meatin keil onen ales asa koa mul kur out, ametau houlu ka uva asilasil en Iesu avit, “!Tiser, rovamat ke! ?Keik kormundemtei usil moulien orer?” ");
INSERT INTO pma_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ka Iesu mea ka selus keih min eang ka oai vit, “!Luhat kamil!” Hatte tas, lumuseh ka out vi tasioh. ");
INSERT INTO pma_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Evus, viteni min meatin onen keil, “?Vensa mimetau? ?Demkatien onami tovuol veah?” ");
INSERT INTO pma_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ka keil amutimanin ka ametau houlu. Amul aviteni min keil eris avit, “?Isei keinek? Mukos eang ka oai, keilu mun lulong ren.” ");
INSERT INTO pma_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Iesu ral min meatin onen keil amu koteh Mari Oai ten out Kaleli ka umai en out keil koa amul rahit meteimal ten out Kerasa. ");
INSERT INTO pma_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ka navong keil amea ran vot, meatin koa ninin tisa mul ien kistal ran out tatetahinien, mai ven keil. ");
INSERT INTO pma_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Kei matil en valengeihat, en out koa aling teiai onen meatin koa mat mul ien. Meatin tovuol vahuli kati, vuo vapar kati en viau takeih. ");
INSERT INTO pma_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Avong houlu apar kat hen ka alen en viau takeih, ka lises, kei rali kotehei. Meatin tovuol vavinvin vahuli kati. ");
INSERT INTO pma_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Meneai ka vongien, kei mual en out tatetahinien ka hou keil koa amul vesesal, ka mul makul ka mul rei aven en ahat takan keil. ");
INSERT INTO pma_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Navong meatin enek les Iesu soutin neli, muloh va veni ka retengeiril mini. ");
INSERT INTO pma_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ka viso vit, “?Iesu, Natin Ahi ten out nesa, asa kovit kovoumoni minau? !Kihat kati minau en isen Ahi keke konapuruntei inau!” ");
INSERT INTO pma_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","(Meatin enek viteni mukok ven Iesu viteni tuai min ninin tisa keke hemea rani.) ");
INSERT INTO pma_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Sakini, Iesu visi vit, “?Isom isei?” Meatin enek vit risi mini vit, “Isomai ‘Houlu,’ ven komai houlu memusing kat meatin ekek.” ");
INSERT INTO pma_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Kei peah Iesu mok vit nahile lattei ninin tisa keil anaha ran out keil koa vesesal en out enek. ");
INSERT INTO pma_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Vesesales en out enek, vuas houlu amul akanian en usihou tai. ");
INSERT INTO pma_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Sakini, ninin tisa keil apeah Iesu, “Kimaen komai meheha en vuas keil ekek.” ");
INSERT INTO pma_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Hatte tas, Iesu vile lat keil amea ran meatin, uva en vuas keil. Sakini, vuas keil enek, vesesal taosen elu (2000) amuloh avita en veisil, ka uva en Mari Oai ten out Kaleli. Ka keil vasi amarindu, umatmat. ");
INSERT INTO pma_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ka meatin keil koa alei kat vuas ametau, ka amuloh avita en meteimal ka asan longlongien va emun en out sav. Sakini, meatin keil umai avit avahotin asa kur out. ");
INSERT INTO pma_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Navong umai ven Iesu, ales meatin koa ninin tisa mul ien mulamu, kei mul rondan, musin tuai, ka rendemien onen mai tahos. Ka navong meatin keil koa aka en meteimal umai alesi, ulie metau. ");
INSERT INTO pma_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ka koakeil ales asa koa kur out usil meatin enek ka vuas keil, arun usili min meatin sav keil. ");
INSERT INTO pma_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Sakini, meatin keil ten out enek apeah Iesu avit vamea ran out se. ");
INSERT INTO pma_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Navong Iesu 