﻿USE sofia;
DROP TABLE IF EXISTS sofia.plw_vpl;
CREATE TABLE plw_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES plw_vpl WRITE;
INSERT INTO plw_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Itue kesuratan et pengkatan i Jesus Kristo. Ya in mawaꞌ dut pengkatan i Surutan Dabid tagnaꞌ. Itueng Surutan Dabid mawaꞌ gasiʼt pengkatan et upuꞌupuan i Abraham tagnaꞌ tiꞌ. ");
INSERT INTO plw_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Si Abraham in amaꞌ i Isaak, si Isaak gasi tuꞌ, amaꞌ i Jakob. Si Juda bekeꞌ ketipusdan ye in, amaꞌ dye si Jakob. ");
INSERT INTO plw_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Mengeꞌ yegang i Juda dut ki Tamar de Peres bekeꞌ si Sera. Si Peres tuꞌ, amaꞌ i Esrom na amaꞌ i Aram. ");
INSERT INTO plw_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Si Aram in, amaꞌ i Aminadab. Si Aminadab gasi in, amaꞌ i Naason na amaꞌ i Salmon. ");
INSERT INTO plw_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Yegang i Salmon dut ki Rahab in, si Boas. Yegang gasi i Boas dut ki Rut, si Obed. Si Obed in, amaꞌ i Jesse. ");
INSERT INTO plw_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Si Jesse in, amaꞌ i surutan Dabid tagnaꞌ tiꞌ. Yegang i surutan Dabid dut esawa i Urias nekeuna tiꞌ, si Solomon. ");
INSERT INTO plw_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Si surutan Solomon gasi in, amaꞌ i Roboam na amaꞌ i Abias. Si Abias tuꞌ, amaꞌ i Asa. ");
INSERT INTO plw_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Si Asa in, amaꞌ i Josapat na amaꞌ i Joram. Si Joram tuꞌ, amaꞌ i Osias. ");
INSERT INTO plw_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Itueng si Osias, amaꞌ i Jotam na amaꞌ i Akas. Si Akas tuꞌ, amaꞌ i Esekias. ");
INSERT INTO plw_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Si Esekias in, amaꞌ i Manases na amaꞌ i Amon. Na si Amon tuꞌ, amaꞌ i Josias. ");
INSERT INTO plw_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Si Jekonias bekeꞌ ketipusdan ye in, amaꞌ dye si Josias. Atin masa lineges dye negpeubuꞌ mengeꞌ tawʼt Judio dut bangsa et Babilonia. ");
INSERT INTO plw_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Pegketbes pegpeubuꞌ dut bangsa et Babilonia, si Jekonias in, amaꞌ i Salatiel na amaꞌ i Sorobabel. ");
INSERT INTO plw_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Si Sorobabel tuꞌ, amaꞌ i Abiud na amaꞌ i Eliakim. Si Eliakim gasi in, amaꞌ i Asor. ");
INSERT INTO plw_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Si Asor in, amaꞌ i Sadok na amaꞌ i Akim. Si Akim gasi tuꞌ, amaꞌ i Eliyud. ");
INSERT INTO plw_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Si Eliud tuꞌ, amaꞌ i Eleasar. Si Eleasar gasi in, amaꞌ i Matan na amaꞌ i Jakob. ");
INSERT INTO plw_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Itueng si Jakob, amaꞌ i Jose na esawa i Maria. Si Maria tuꞌ, induꞌ i Jesus na pegbetengan si Kristo, ingin bersen, ya in piniling surutan et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Angkansa, ginsan in sempuluꞌ epat neglatun-latun pengkatan mewanan ki Abraham seked ki Surutan Dabid. Sempuluꞌ epat neglatun gasi mawaꞌ ki Dabid seked dut leges neng pegpeubuꞌ et Babilonia. Indyari, sempuluꞌ epat latun gasi mewanan eset pegpeubuꞌ dut Babilonia seked ki Kristo. ");
INSERT INTO plw_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Kwantin neinabu pegkeganak ki Jesus Kristo. Na si Maria in, kenyeng induꞌ bekeꞌ si Jose tuꞌ, megtutunang ne, segwaꞌ, mura dye nebulun, si Maria in megebteng ne sabab et kewasa et Empung Nakem. ");
INSERT INTO plw_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Si Jose tuꞌ, tunang i Maria, metignaꞌ. Angkansa, pikir ye na taguꞌ yeng butasan ya, sabab mendiꞌ ye ipeleew si Maria. ");
INSERT INTO plw_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Sasat pegpipikiren i Jose itue, maya dereakan et Empuꞌ neperenta kenye set seled teginep, kwan, “Jose, keupuꞌupuan i Surutan Dabid, kas takut peburuiꞌ na pebulun ki Maria sabab ya pegmengirem sabab et Nakem et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Indyari, megyegang ya et sembatung lelaki bekeꞌ itue pengeranan muʼt si Jesus, sabab ya in mememawiꞌ et kedusaan et mengeꞌ taaw na nemegkesalaꞌ.” ");
INSERT INTO plw_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ginsan itue neinabu apang metuman pegsugiran et Empuꞌ tagnaꞌ tiꞌ pebiyaꞌ et tarus ye neng si Isaias, kwan, ");
INSERT INTO plw_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Megmengirem itueng sembatung budyang, pegketbes megyegang et sembatung lelaki. Indyari, ngeranaʼt Imanuel, gay bersen eset sinalin, ‘Iba tyu Empuꞌ.’ ” ");
INSERT INTO plw_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Pegkaꞌ neketiyag ne si Jose, inandel ye tahag et dereakan et Empuꞌ. Indyari, megbulun dye ne de Maria. ");
INSERT INTO plw_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Temed kaya inulid i Jose si Maria seked nengganak itue et sembatung memulek na lelaki, pinengeranan yeʼt Jesus. ");
INSERT INTO plw_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ganang si Jesus in pinengganak eset lungsud et Betlehem, dut bangsa et Judea, tagnang ketimpuan i Surutan Herodes. Aluꞌ, nemengdateng tawʼt mependey dye sumiyek et bituen dut lungsud et Jerusalem mewanan eset sebangan. ");
INSERT INTO plw_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Dye in nemengingkut, kwan, “Embe ne pinengganak neng surutan et mengeꞌ tawʼt Judio? Nebiriꞌ kay ne bituen netendaꞌ na ipegyegang na ya. Angkansa, natuꞌ kay apang bentugen ya.” ");
INSERT INTO plw_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ganang nekingeg itue i Surutan Herodes, nebenteng ne ya. Kwantin gasi ginsaʼt tawʼt Jerusalem. ");
INSERT INTO plw_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Angkansa, tinimung ye ginsang pegibuten neng mengeꞌ pariꞌ bekeꞌ mengeꞌ menunulduꞌ et Keseraan et tawʼt Judio, iningkut kedye, kwan, “Embe takuꞌ penggenakan ki Kristo?” ");
INSERT INTO plw_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Kwan dye, “Dut lungsud et Betlehem, eset probinsiya et Judea, sabab kwantin ne sinurat et tarus tagnaꞌ tiꞌ, kwan, ");
INSERT INTO plw_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Na Betlehem, lungsud eset Judea, asal diki peemuri eset mengeꞌ megunang lungsud et Judea, sabab eset dimu mewanan sembatung pegibuten na mekepegewla eset daken neng tawʼt Israel.’ ” ");
INSERT INTO plw_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ganang nesewran itue, taguꞌ ne pinetingkag i Herodes mengeꞌ meuutek neng taaw. Indyari, inintetew kedye baꞌ kengyan neperenta bituen in. ");
INSERT INTO plw_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Pineruntin dye ne dut lungsud et Betlehem, kwan, “Sumurung kew bekeꞌ tulusaꞌ myu banar yengyegang in. Baꞌ netulus myu ne, isugiraꞌ myu megtuy daken, apang keruntin ku gasi mekebantug kenye.” ");
INSERT INTO plw_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Pegkekingeg dyeʼt beres et surutan, neglahyun dye gasi. Naꞌ, bituen neng neperenta kedye in, atin ne pegsusunsunen dye megpepanew seked nekerateng eset tengteng et peglelegdengan et yengyegang in. ");
INSERT INTO plw_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ganang nebiriꞌ dye na nepetaren ne bituen in, kiminsan dye ne banar. ");
INSERT INTO plw_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Pegdateng dye dut benwa, siminled dye, nebiriꞌ dye yengyegang in eset induꞌ yeng si Maria. Siminelukud bekeꞌ binantug dye ya. Tinukasan dye kedyeng susunuan. Pegketbes binggey kenye pegbibiten dyeng bulawan, kamanyang sampay mergang bebengluen neng mira. ");
INSERT INTO plw_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Na timpu ne mugad dye, muliꞌ dut lungsud dye dut lein bebyaan, sabab tinehagan kedye et Empuꞌ set seled teginep na endey dye peuliꞌ dut ki Surutan Herodes. ");
INSERT INTO plw_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Pegugad dye, aluꞌ, neperenta ki Jose set seled teginep sembatung dereakan et Empuꞌ, kwan, “Ganang ketiyag ke ne, ipebeyaaꞌ megtuy yengyegang bekeꞌ induꞌ ye in melegyu dut bangsa et Egipto. Kas kew ugad duntin selyu lang baꞌ kesugid ku ne dimu, sabab pegpeperuan i Herodes peteyen ating yengyegang.” ");
INSERT INTO plw_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Angkansa, megtuy timinyag si Jose atin neng gebi, pinebayaꞌ ye yengyegang bekeꞌ induꞌ in, surung dut bangsa et Egipto. ");
INSERT INTO plw_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Indyari, duntin ne linegdengan dye seked natey si Herodes. Ginsan itue neinabu apang metuman binres et Empuꞌ pebiyaꞌ et tarus, kwan, “Tiningkag ku dakeng yegang mawaʼt bangsa et Egipto.” ");
INSERT INTO plw_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ganang nesewran i Herodes na inekalan lang ya et mengeꞌ meuutek neng taaw, neirek-irek ya banar. Indyari, dineakan ye pemeteyen ginsang keyegangan neng lelaki eset Betlehem, sampay pelilibut neng nelkepaʼt ating lungsud, megumur et duwang teun pesanad, sigun eset timpu na neintatew ye eset mengeꞌ meuutek neng taaw. ");
INSERT INTO plw_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Indyari, netuman ne binres i Jeremias neng tarus et Empuꞌ, kwan, ");
INSERT INTO plw_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Nekingeg mebasag neng siyak sampay meglalam dut lungsud et Rama. Peglalaman i Rakel mengeꞌ yegang ye, mendiꞌ ye ne peimuyuk, sabab patey ne.” ");
INSERT INTO plw_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ganang natey ne si Herodes, naꞌ, neperenta set seled teginep i Jose dereakan et Empuꞌ dut bangsa et Egipto, kwan, ");
INSERT INTO plw_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Pegtiyag ne, bitaꞌ ne muliꞌ dut bangsa et Israel meginduꞌ in, sabab nemematey ne nememahum peteyen ating yengyegang.” ");
INSERT INTO plw_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Pegketiyag ye, binibit ye ne itueng meginduꞌ dut bangsa et Israel. ");
INSERT INTO plw_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Temed ganang nekingeg i Jose na yegang i Herodes neng si Arkilao surutan dut probinsiya et Judea, siminubliꞌ et amaꞌ ye, timinakut ne ya meglembus duntin. Pegketbes pinesewd gasi ki Jose set seled teginep. Angkansa, siminurung dye ne dut probinsiya et Galilea. ");
INSERT INTO plw_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Pegdateng duntin, liminegdeng dye ne dut Nasaret apang metuman binres et mengeꞌ tarus na ya in ingeranaʼt Nasareno. ");
INSERT INTO plw_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Baꞌ meumur ne si Jesus, megpeabar si Juan neng mememewtismu dut kelnangan et Judea. ");
INSERT INTO plw_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Kwan ye, “Pegsusun kew ne, sabab diki ne mekwit megmilik ne atue Empuꞌ!” ");
INSERT INTO plw_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Na pasal ki Juan pegbersen i Isaias neng tarus et Empuꞌ tagnaꞌ, kwan, “Maya pegpeabar dut kelnangan, kwan ye, ‘Penyapaꞌ bekeꞌ tignaiꞌ myu bebyaan et Begerar naꞌ Empuꞌ!’ ” ");
INSERT INTO plw_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Itueng si Juan megbebadyuꞌ, bulbul et kamelyo samat ki tarus Elias tagnaꞌ tiꞌ. Megbebakes gasi si Juan et kulit et sapiꞌ, sampay kenyeng kekanen kumetumban bekeꞌ deges. ");
INSERT INTO plw_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Indyari, nemengduntin kenye tawʼt Jerusalem sampay ginsan et mengeꞌ lungsud et Judea sampay meglelegdeng dut megsembelang bagiꞌ et danum et Jordan. ");
INSERT INTO plw_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Binewtismuan dye i Juan dut danum et Jordan, diningan dye ne pegsugid et kedyeng keselaan dut Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Pegkebiriꞌ ye mekansang pariꞌ na Pariseo bekeꞌ pariꞌ na Saduseo nepekabiꞌ apang megpebewtismu kenye, sinugid ye kedye, kwan, “Kemyu samat mengeꞌ merunding neng seliꞌ! Pebiriꞌbiriꞌ lang na pegsusun kew! Sinu negpesewd apang mepelegyuan myu megderateng neng kedusaan et Empuꞌ? ");
INSERT INTO plw_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ipebirinaꞌ myu teyen pebiyaꞌ et keradya na negsusun kew ne banar! ");
INSERT INTO plw_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Bekeꞌ iba, kasiꞌ myu pegpikiraꞌ na diki medusaan kewʼt Empuꞌ sabab keupuꞌupuan kew i Abraham. Sabab Empuꞌ mekebaal et tantung keupuꞌupuan i Abraham mewanaʼt itueng mengeꞌ batu baꞌ keilangan ye. ");
INSERT INTO plw_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Petetangen ne kapa set puuʼt kayu, sabab ginsan mengeꞌ kayu na kaya megbuaꞌ et menunga, pegputken Ye, pegketbes itimbag dut apuy. Dusaen et Empuꞌ kemyu samat kwantin. ");
INSERT INTO plw_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Pegbewtismuan ku kemyu et danum. Itue tendaꞌ et pegsusun et dimyung mengeꞌ keselaan. Temed, maya megderateng dut emurian ku na mekseg set daken. Diki katu ku kenye, etawa patut na misan mibit et tempaꞌ ye. Ya in gasi memewtismu dimyu et Nakem et Empuꞌ bekeꞌ et apuy. ");
INSERT INTO plw_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Sembatu negang supama sugiren ku dimyu pasal et dusaen et Empuꞌ. Antangan ye, pegkekeptan ye ne nigu apang mepeliran seked mepunpun ye dut beblaran. Timungen ye ne legas in, temed apa in tutungen ye dut apuy neng kaya pepeteyan misan ingyan.” ");
INSERT INTO plw_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Indyari, mewanan i Jesus dut lungsud et Galilea, surung dut danum et Jordan. Inagap ye si Juan apang megpebewtismu kenye. ");
INSERT INTO plw_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Linaang ya i Juan, kwan, “Subaliꞌ aku key teyen bewtismuan mu, temed ikew key gay pegbewtismu daken!” ");
INSERT INTO plw_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Indyari, timinubag kenye si Jesus, kwan, “Pesariꞌ mena na buwaten te itue, apang metuman baꞌ enu ingin et Empuꞌ.” Angkansa, timinugut ne si Juan. ");
INSERT INTO plw_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Na ganang mebewtismuan si Jesus, daꞌdali ne ya neperibuwat dut danum. Neukaban langit bekeꞌ netingaraꞌ ye Nakem et Empuꞌ megiineug, samat begit neng aksang, napun kenye. ");
INSERT INTO plw_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Aluꞌ, maya ne beres teyeg dut langit, kwan, “Itue pegmerganen ku neng yegang na mekeksanan ku banar.” ");
INSERT INTO plw_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Pegketbes, pinebayaꞌ et Empung Nakem si Jesus dut kelnangan, apang sulayan ya i Seytan. ");
INSERT INTO plw_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Na duntin negpuasa si Jesus et seled epatnempulung eldew bekeꞌ epatnempulung gebi. Indyari, ya in inurapan ne banar. ");
INSERT INTO plw_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Naꞌ, nagap kenye menunulay, gay bersen, si Seytan. Negsugid, kwan, “Pagkaꞌ yegang keʼt Empuꞌ, itueng mengeꞌ batu balaꞌ et bengbang!” ");
INSERT INTO plw_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Segwaꞌ siminambag si Jesus, kwan ye, “Nekesurat na, kwan, ‘Diki set bengbang lang megbiyag itueng taaw, baꞌ diki dut pegeandel set ginsang bebresen et Empuꞌ.’ ” ");
INSERT INTO plw_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Pegketbes et atin, binibit gasi si Jesus i Seytan dut pinekemelayug neng timbew et benwang pegempuan dut Jerusalem, ating pinekelungsud et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Negsugid si Seytan kenye, kwan, “Pagkaꞌ yegang keʼt Empuꞌ, peregdag be, sabab nekesurat na, kwan, ‘Tehagen et Empuꞌ mengeꞌ dereakan ye diki ke pesaran. Selwen dye ikew apang diki kesimbakud ke set batu.’ ” ");
INSERT INTO plw_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Siminambag si Jesus, kwan, “Nekesurat gasi, ‘Kasiꞌ pegsulayiꞌ basag et dimung Empuꞌ dut langit!’ ” ");
INSERT INTO plw_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Pegketbes, pinebayaꞌ ya i Seytan dut pinekemelayug neng bukid. Duntin pinepayag kenye ginsan neng bangsa bekeꞌ kedeyahanen dye set ginsaʼt sengkedunyaan. ");
INSERT INTO plw_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Indyari, sinugid i Seytan, kwan, “Igbey ku dimu ginsan itue, baꞌ salungkuran bekeꞌ bentugen mu aku.” ");
INSERT INTO plw_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Siminambag si Jesus kenye, kwan, “Ugad atue, Seytan! Sabab nekesurat, ‘Empuꞌ lang dut dibuwat langit esipen bekeꞌ endelen mu.’ ” ");
INSERT INTO plw_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Angkansa tinirengan ya i Seytan, aluꞌ, maya dereakan et Empuꞌ diminateng na nemeruri kenye. ");
INSERT INTO plw_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Nebaran i Jesus na pinirisu si Juan. Angkansa, nepeuliꞌ ya dut probinsiya et Galilea. ");
INSERT INTO plw_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Indyari, kaya ne timineteg dut lungsud et Nasaret, erapun liminegdeng ne ya dut lungsud et Kapernaum, dut mekabiʼt dagat et Galilea, dut lungsud et pengkatan i Sabulon bekeꞌ Neptali tagnaꞌ, ");
INSERT INTO plw_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","apang metuman binres i Isaias neng tarus tagnaꞌ, kwan, ");
INSERT INTO plw_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“U, lungsud neng Sabulon bekeꞌ Neptali set bebyaan pesurung dagat dut sembelaʼt danum et Jordan, u Galilea, probinsiya et mengeꞌ tawʼt lein Judio! ");
INSERT INTO plw_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Mengeꞌ taaw neng meglelegdeng eset kelingban bekeꞌ sama dut lungsud et kepeteyan, dye in nekebiriꞌ ne et metlang neng siluꞌ kebinyar eset kedye.” ");
INSERT INTO plw_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ating masa timinagnaꞌ ne negpeabar si Jesus, kwan, “Pegsusun kew ne, sabab diki ne mekwit megmilik ne atue Empuꞌ!” ");
INSERT INTO plw_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Sasat megtetalib si Jesus eset deplakaʼt dagat et Galilea, nebiriꞌ ye duwang megtipused neng meneneraꞌ, sembatu in, si Simon, pegbetengaʼt Pedro, bekeꞌ tipused yeng si Andres. Pemengledlad et sibut eset dagat. ");
INSERT INTO plw_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Sinugid i Jesus kedye, kwan, “Aniꞌ kew, ibut kew daken! Penduen ku kemyu menibut et mengeꞌ taaw antangan dye samat seraꞌ, gay bersen ipeibut dye set daken.” ");
INSERT INTO plw_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Megtuy dye tinirengan kedyeng mengeꞌ sibut, pegketbes nibut dye ne ki Jesus. ");
INSERT INTO plw_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Indyari, mewanan dye duntin, nebiriꞌ gasi i Jesus sembatung megtipused, de Jakob bekeꞌ si Juan na yegang i Sebedeo. Dye bekeꞌ amaꞌ in, penginunga et sibut set seled gubang. Ipeibut dye gasi i Jesus set kenye. ");
INSERT INTO plw_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Megtuy dye tinirengan gubang bekeꞌ amaꞌ dye. Pegketbes, nibut dye ki Jesus. ");
INSERT INTO plw_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Linibut i Jesus ginsaʼt probinsiya et Galilea, penulduꞌ ya dut tingtimungan et mengeꞌ tawʼt Judio sampay pepebunayag ya et Menungang Abar pasal et pegmimilik et Empuꞌ. Pinegulinan ye gasi mengeꞌ taaw set ginsang mengeꞌ sakit neng neresanan dye. ");
INSERT INTO plw_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nesewran et ginsaʼt taaw dut probinsiya et Galilea pasal ki Jesus. Angkansa binibit set kenye ginsan neng maya sakit bekeꞌ pepeliyutan et iba-ibang reresanen. Binibit gasi mengeꞌ dineplan et meyaat neng diwata, mengeꞌ pegdetengan, sampay mengeꞌ kaya ne mekepanew. Ginsan dye in pinegulinan i Jesus. ");
INSERT INTO plw_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Indyari, mekansang banar taaw nibut kenye, mawaꞌ et probinsiya et Galilea sampay Dekapolis, teyeg lungsud et Jerusalem, teyeg Judea sampay mengeꞌ lungsud dut sembelaꞌ et danum et Jordan. ");
INSERT INTO plw_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Pegkebiriꞌ si Jesus et kineldaman neng taaw, timinungul dut kilid et bukid bekeꞌ narung. Nepekabiꞌ dut kenye mengeꞌ pepengenaran ye. ");
INSERT INTO plw_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Indyari tinulduan ye dye et kwantin, timinagnaꞌ ye, kwan ye: ");
INSERT INTO plw_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Mesukud sebarang megkesewd naꞌ kurang dye et mengeꞌ keginisan et Empuꞌ, sabab dye in mekebayaꞌ dut pegmimilikan et Empuꞌ Banar na dut langit. ");
INSERT INTO plw_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Mesukud sebarang merurupuk, sabab dye imuyuken nega et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Mesukud sebarang meguep, sabab dye memusakaꞌ et sengkedunyaan. ");
INSERT INTO plw_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Mesukud sebarang geayen bekeꞌ inginen buwaten et ketignaan et Empuꞌ, sabab dye pebiyagan et sukup. ");
INSERT INTO plw_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Mesukud sebarang meingesinen, sabab dye gasi ingesinan et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Mesukud sebarang menungang penedseled sabab mebiriꞌ dye Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Mesukud sebarang menginginunga et kesenangan, sabab dye mesugid na mengeꞌ yegang et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Mesukud sebarang pegtiksaen pasal et keendelen dye dut keberbenaran et Empuꞌ, sabab dye in mekebayaꞌ dut pegmimilikan et Empuꞌ dut langit. ");
INSERT INTO plw_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Mesukud kew baꞌ seruruen kew et mengeꞌ taaw, tiksaen kew sampay pegbenbersan kew et mereraat neng bebresen sabab lang mengengandel kew dut daken. ");
INSERT INTO plw_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Imbes meglami kew bekeꞌ megenep kew, sabab kelaꞌ iganti dimyu et Empuꞌ dut langit. Sabab kwantin gasi pegtiksaen dye mengeꞌ tarus et Empuꞌ na meguna dut dimyu.” ");
INSERT INTO plw_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Antangan kemyu samat asin et ginsaʼt tawʼt sengkedunyaan. Segwaꞌ baꞌ asin dumamal, enungkwan nega kepeuliꞌ et asin ye? Kaya ne kepulusan ye, angkansa itimbag ne lang bekeꞌ pegletlebutan ne lang et taaw. ");
INSERT INTO plw_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Kemyu samat siluꞌ et dunyaꞌ. Megsepantun lungsud na dut timbew et bulud diki metaguꞌ. ");
INSERT INTO plw_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kaya pegsiluan siluꞌ supaya tekluban et baldiꞌ. Erapun pegdatun dut deretunan ye supaya mebenyaran ginsan seled benwa. ");
INSERT INTO plw_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Kwantin gasi, na pebenyaraꞌ myu gasi siluꞌ myu dut elepan et mengeꞌ taaw, supaya mebiriꞌ dye dimyung menunungang keradya. Sabab et atin, bentugen dye dimyung Empuꞌ Amaꞌ na dut Langit.” ");
INSERT INTO plw_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Kasiꞌ myu pegpikiraꞌ na aku natuꞌ supaya ugaran ating Keseraan binggey et Empuꞌ ki Moises, etawa mengeꞌ Ketulduan et mengeꞌ Tarus et Empuꞌ. Kaya ku natuꞌ na ugaren atin. Natuꞌ ku supaya tumanen ginsan atin. ");
INSERT INTO plw_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Sugiran ku kemyu banar, seked ating eldew na lugtaꞌ bekeꞌ langit malam, diki lang meylang misan sengkudlit et bebayaꞌ et susurat na sinurat neng Keseraan, seked atin ginsan in metuman. ");
INSERT INTO plw_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Angkansa, baꞌ sinu lumyu et misan kerinek-rinekan neng bagi et Keseraan na itue bekeꞌ itulduꞌ ye dut iba na buwaten samat kwantin, ya pegbetangen na pinekeisek-isek dut kemilikan et Empuꞌ dut langit. Segwaꞌ baꞌ sinu megpenuman itueng Keseraan, bekeꞌ ipegtulduꞌ ye dut iba na buwaten samat kwantin, ya pegbetangen na kelaꞌ dut kemilikan et Empuꞌ dut langit. ");
INSERT INTO plw_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Isugid ku banar dimyu, selyu dimyung ketignaan lumbi dut mengeꞌ pariꞌ na Pariseo bekeꞌ mengeꞌ menunulduꞌ et Keseraan, diki kew ketentuan kesled dut kemilikan et Empuꞌ dut langit.” ");
INSERT INTO plw_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Sinugid gasi i Jesus, kwan, “Nekingeg myu na pegsugiren et mengeꞌ taaw nekeuna tiꞌ na kwan, ‘Kas kew mengimatey, sabab sebarang nengimatey teyumanen ye dut ukuman.’ ");
INSERT INTO plw_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Segwaꞌ isugid ku dimyu na baꞌ sinu megiseg dut tipused ye teyumanen ye dut ukuman. Na baꞌ sinu gasi megberes et peneruruꞌ dut tipused ye, kwan ye, ‘Meyahuꞌ ke!’ tubagen ye gasi dut mengeꞌ megkepet et Kunsial neng mengeꞌ pegibuten. Segwaꞌ sebarang pegberes dut tipused ye, kwan, ‘Dupang ke!’ ketettakut ne kenye na isugba ya dut apuy et Narkaꞌ. ");
INSERT INTO plw_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Angkansa, baꞌ megsimayaꞌ ke et begey mu dut Empuꞌ eset sisimeyaan bekeꞌ merendeman mu na maya tipused mu na megiseg dimu, ");
INSERT INTO plw_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","tirengiꞌ mena simayaꞌ mu dut sisimeyaan, duntinaꞌ mena ya supaya megerut kew megtipused. Pegketbes mekedyari ke ne peuliꞌ supaya megsimayaꞌ et dimung begey dut Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Baꞌ maya menindal dimu dut ukuman, sementaraꞌ dut dalan kew nega megsutsulut kew ne lagi duun. Baꞌ diki, pekpetan ke dut mengungukum. Indyari igbey et mengungukum dut pegibuten et pulis pegketbes ya megpesled dimu dut pipirisuan. ");
INSERT INTO plw_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Asal isugid ku rimyu, diki ke keliwan seked mebeyaran emuring siin et multa mu.” ");
INSERT INTO plw_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Nekingeg myu pegsugiren tagnaꞌ tiꞌ na kwan, ‘Kas kew pegbeis.’ ");
INSERT INTO plw_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","“Segwaꞌ isugid ku dimyu baꞌ sinu sumiyek dut libun na maya meyaat neng pegsedseleren ye dut seled atey ye, sepantun negkesalaꞌ ne et pegbeis seled atey dut atin libun. ");
INSERT INTO plw_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Baꞌ kewanan neng mata mu mekebibit dimu na megkesalaꞌ, suataꞌ ne lang bekeꞌ itimbagaꞌ! Lebing menunga dimu baꞌ kurangan mu seng bagiꞌ et bilug mu, kasga maya teup ne bilug mu surungen dut Narkaꞌ. ");
INSERT INTO plw_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Baꞌ kewanan neng keremut mu mekebibit dimu na megkesalaꞌ, putkaꞌ ne lang bekeꞌ itimbagaꞌ! Lebing menunga dimu baꞌ kurangan mu seng bagiꞌ et bilug mu, kasga maya teup ne bilug mu surungen dut Narkaꞌ.” ");
INSERT INTO plw_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Pegsugiren gasi tagnaꞌ tiꞌ, ‘Baꞌ sinu meingin mekipegbutas dut kenyeng esawa mekedyari lang igbeyan et kesuratan na dye butas ne.’ ");
INSERT INTO plw_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Segwaꞌ isugid ku dimyu tiban, baꞌ sinu mekibutas dut esawa ye selyu lang baꞌ ya negbeis sebaban, samat sinunggeb ye esawa ye na megkesalaꞌ et pegbeis. Bekeꞌ baꞌ sinu mengesawa et libun na binutasan, ya gasi negkesalaꞌ et pegbeis.” ");
INSERT INTO plw_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Nekingeg myu tagnaꞌ tiꞌ na pegsugiren et mengeꞌ taaw, ‘Kasi peglipati dimung tinangeꞌ, segwaꞌ tumana baꞌ enu pinengakuꞌ mu dut Empuꞌ.’ ");
INSERT INTO plw_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Segwaꞌ tiban isugid ku dimyu, kas kew pemuwat et misan enung tinangeꞌ. Bekeꞌ kas kew pengibet ipebayaꞌ langit, sabab atin metaas na eerungan et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Etawa pengibetan ipebayaꞌ dunyaꞌ, sabab atin lelbutan et tiked et Empuꞌ, etawa pengibetan ipebayaꞌ lungsud neng Jerusalem, sabab atin lungsud et ating Kelang Surutan na Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Bekeꞌ kas kew pengibet ipebayaꞌ biyag mu, sabab misan sengbuek diki mu mebaal na ipeputiꞌ etawa ipeitim. ");
INSERT INTO plw_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Segwaꞌ petignaiꞌ ne lang meres. Baꞌ kwanen mu ‘eꞌ’, atin ‘eꞌ’. Baꞌ kwanen mu ‘diki’, atin ‘diki’. Lumbi atue, atin teyeg ne i Seytan.” ");
INSERT INTO plw_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Nekingeg myu na pegsugiren, na kwan, ‘Belsaꞌ mata, dut mata, bekeꞌ nipen dut nipen.’ ");
INSERT INTO plw_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Segwaꞌ isugid ku dimyu, kasiꞌ pegbelsaꞌ mereraat neng taaw. Baꞌ sinu tumpal dut kewanan neng pesingil mu, ilugutaꞌ gasi gibang neng pesingil mu. ");
INSERT INTO plw_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Baꞌ maya megsumbung dimyu dut ukuman supaya meisiꞌ ye dimung badyuꞌ, igbeyaꞌ atin sampay gasi mebuwat lengen badyuꞌ mu. ");
INSERT INTO plw_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Baꞌ maya mengleges dimu bibiten et embag ye dut sembatung kilometro, ilusuaꞌ seked duwang kilometro. ");
INSERT INTO plw_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Baꞌ sinu megtew dimu, begeyiꞌ, kasiꞌ pegmendiniꞌ baꞌ sinu meingin menglimbas dimu.” ");
INSERT INTO plw_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Nekingeg myu na pegsugiren tagnaꞌ tiꞌ, ‘Inginaꞌ myu sebayaꞌ myu bekeꞌ isgan myu dimyung kebanta.’ ");
INSERT INTO plw_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Segwaꞌ tiban isugid ku dimyu, inginaꞌ myu dimyung kebanta bekeꞌ ipenelangaꞌ myu baꞌ sinu peniksaꞌ dimyu, ");
INSERT INTO plw_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","supaya kemyu mesugid na keyegangan et Empuꞌ Amaꞌ na dut langit. Sabab megpebinyar ye telang et eldew sesaliꞌ dut mengeꞌ meraat neng taaw bekeꞌ menunga, bekeꞌ megpemedlek dut mengeꞌ taaw neng pemuwat et metignaꞌ bekeꞌ mengeꞌ taaw neng pemuwat et meraat. ");
INSERT INTO plw_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Baꞌ ingin myu sebarang mekasi dimyu, enu metagey myu na igbey dimyu et Empuꞌ? Diki be kwantin gasi pegbuwaten et mengeꞌ menunukut et bebayad et lugtaꞌ. ");
INSERT INTO plw_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Baꞌ pegimrewan myu sebarang ketipusdan myu lang, enukwan myu buwaten iba? Diki be atin gasi pegbuwaten et kaya pegandel dut Empuꞌ? ");
INSERT INTO plw_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Megpeketignaꞌ kew sabab dimyung Empuꞌ Amaꞌ dut langit metignaꞌ.” ");
INSERT INTO plw_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Indyari, sinugid i Jesus kedye, kwan ye, “Pegkesukuen myu Empuꞌ, pegnunga-nunga kew na kasiꞌ pegbuwataꞌ na menunungang keradya dut elepan et mengeꞌ taaw, apang ipebiꞌbiriꞌ lang kedye. Baꞌ ikew megpemuwat samat kwantin, kaya lang gantiꞌ et Empuꞌ Amaꞌ mu dut langit. ");
INSERT INTO plw_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Angkansa baꞌ megey ke et ebuluy dut mengeꞌ kayang-kaya kas pebres et budyung, samat mengeꞌ pegbuwaten et pebiꞌbiriꞌ dut dalan bekeꞌ dut mengeꞌ sinagoga, ating pegtitimungan et mengeꞌ tawʼt Judio. Pegbuwaten dye itue supaya bentugen et mengeꞌ taaw. Sugiran ku dimyu et keberbenaran, neterima dye ne ginsan ganti kedye. ");
INSERT INTO plw_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Segwaꞌ baꞌ megebuluy ke dut mengeꞌ kayang-kaya, kasi pesewri gibang neng lengen mu baꞌ enu binwat et kewanan neng lengen mu, ");
INSERT INTO plw_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","supaya dimung pegbegey et ebuluy na dut taguꞌ. Na dimung Empuꞌ Amaꞌ dut langit mekebiriꞌ dut bubuwaten na taguꞌ, maya ganti ye rimu.” ");
INSERT INTO plw_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Baꞌ megpenelang ke gasi, kasiꞌ myu pegsiringaꞌ mengeꞌ pebiꞌbiriꞌ! Sabab meingin dye na megpenelang et petiyeg dut mengeꞌ sinagoga, ating pengempuan et mengeꞌ tawʼt Judio, bekeꞌ dut mengeꞌ simpangan et dalan apang mebiriꞌ ginsan et mengeꞌ taaw. Sugiran ku dimyu et keberbenaran, neterima dye ne ginsan ganti kedye. ");
INSERT INTO plw_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Baꞌ megpenelang ke, sumled keʼt sisingled mu, tenglebaꞌ lelengewan, bekeꞌ megpenelang ke dut Empuꞌ Amaꞌ mu na diki mebiriꞌ. Na dimung Empuꞌ Amaꞌ na mekebiriꞌ et buwat na taguꞌ, gentian ye ikew. ");
INSERT INTO plw_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Bekeꞌ baꞌ megpenelang ke, kas kew mengusal et peseuliꞌseuliꞌ neng bebresen na kaya kegunaan samat mengeꞌ tawʼt kaya pegandel dut Empuꞌ. Sabab kwan dye lang pegkinggen dyeʼt mengeꞌ Empuꞌ dye sabab et keldam et kedyeng bebresen. ");
INSERT INTO plw_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kasiꞌ dye pegsiringaꞌ, sabab sewd et Empuꞌ Amaꞌ baꞌ enu keilangan myu mura inangat myu kenye. ");
INSERT INTO plw_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Samat kwantin kew megpenelangin dut Empuꞌ, kwan, ‘Empuꞌ Amaꞌ kay dut langit, merganen kay teyen ikew. ");
INSERT INTO plw_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ikew megmendyaring pegibuten et ginsan mengeꞌ taaw. Ibuten kay teyen dimung keiregan atueʼt dunyaꞌ na samat pegibuten dut langit. ");
INSERT INTO plw_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Begeyan mu kami et kekanen tiban na keilangan kay itueng eldew. ");
INSERT INTO plw_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Bekeꞌ empunen mu kami eset dameng keselaan binwat kay, samat pegampun kay gasi eset mengeꞌ nekesalaꞌ damen. ");
INSERT INTO plw_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Endey Mu kami ielep eset meliyut neng pegsulay, erapun iperayunaꞌ damen keyeatan i Seytan.’ ");
INSERT INTO plw_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Sabab baꞌ maapen myu sebarang pegkesalaꞌ dimyu, maapen kew gasi et Empuꞌ Amaꞌ dut langit. ");
INSERT INTO plw_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Segwaꞌ baꞌ diki maapen myu mengeꞌ taaw na megkesalaꞌ dimyu, diki gasi maapen kew et Empuꞌ Amaꞌ myu dut langit mengeꞌ pegkesalaꞌ myu.” ");
INSERT INTO plw_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Baꞌ megpuasa kew, kas kew megpedagbes na merupuk kew samat buwaten et mengeꞌ pebiꞌbiriꞌ. Na pepesalaꞌ dye rupa dye supaya ipebiꞌbiriꞌ lang dut mengeꞌ taaw na dye pegpuasa. Sugiran ku dimyu et keberbenaran, neterima dye ne ginsan ganti kedye. ");
INSERT INTO plw_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Segwaꞌ baꞌ megpuasa ke, leneiꞌ buek mu bekeꞌ mengiramus ke et rupa mu ");
INSERT INTO plw_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","supaya atin diki lang mesewran et mengeꞌ taaw na ikew pegpuasa, selyu Empuꞌ Amaꞌ mu lang neng diki tyu mekebiriꞌ. Na, Ya lang mekebiriꞌ set taguꞌ ne mengeꞌ bubuwaten mu neng menunga, maya ganti Ye eset rimu.” ");
INSERT INTO plw_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Kas kew megtimung et kementirian atuʼt dunyaꞌ, na atue maya pengusibaꞌ na aney bekeꞌ garang, na atue pegselden et menenakew ampaꞌ ne tekewan. ");
INSERT INTO plw_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Segwaꞌ timungaꞌ myu mengeꞌ kementirian dut langit, sabab kaya untin pengusibaꞌ aney etawa garang, na diki lang kesled menenakew apang menakew. ");
INSERT INTO plw_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Angkansa, ating kementirian mu subaliꞌ ne atin mengeꞌ pegbuwaten mu sabab et Empuꞌ dut langit, na subaliꞌ duntin gasi pikiran mu. ");
INSERT INTO plw_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Mata mu samat siluꞌ et bilug mu. Baꞌ mata mu meligew, metlangan ginsan bilug mu. ");
INSERT INTO plw_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Segwaꞌ baꞌ mekabu ne mata mu, melingeb ne gasi ginsan bilug mu. Angkansa baꞌ siluꞌ na eset dimu in diki meminyar, abut deklaꞌ banar et kelingban!” ");
INSERT INTO plw_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Kaya sinu mekeibut et duwang pegibuten, sabab isgan ye sembatu in bekeꞌ inginen ye sembatu gasi. Etawa ibuten ye sembatu bekeꞌ reaten ye ikeruwa in. Diki kew mekesukuꞌ tantu dut Empuꞌ bekeꞌ pererwa daran pegsukuan menimung et pirak. ");
INSERT INTO plw_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Angkansa isugid ku rimu, kasiꞌ myu reasiꞌ pasal biyag myu, baꞌ enu kekanen etawa inumen myu etawa baꞌ enu badyuen et bilug myu. Diki takuꞌ biyag lebing mergaꞌ eset pegkaan? Bekeꞌ bilug lebing mergaꞌ dut badyuꞌ? ");
INSERT INTO plw_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Seyekiꞌ mengeꞌ kebebegitan dut lelengew, diki dye pemengluwak etawa pemengeyg etawa memugu et kekanen dut legkew. Segwaꞌ pepekaan dye et Empuꞌ Amaꞌ dut langit. Diki be mergaꞌ kew nega eset begit? ");
INSERT INTO plw_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Sinu dimyu sabab et pegsusa mekepegdugang misan seng lisag dut kenyeng biyag? ");
INSERT INTO plw_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Na manu megmesusa kew sabab et pegbadyu? Seyekiꞌ mengeꞌ kebuburakan dut mengeꞌ uma. Kaya pemegkeradya etawa pemengeket et bebedyuen ");
INSERT INTO plw_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Segwaꞌ sugiran ku kemyu, misan si Surutan Solomon tagnaꞌ tiꞌ kaya nekepegpakay na samat nunga et burak na itue, misan ne dut kenyeng ketaasan. ");
INSERT INTO plw_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Baꞌ mengeꞌ peperasen dut mengeꞌ uma pepebedyuan et Empuꞌ, peperasen na tiban atue, pegdateng et diklem itimbag dut dudurukan. Diki takuꞌ mas lebi nega kemyu na diki ye pepekayan? Na kemyu na isek-isek neng pegandel! ");
INSERT INTO plw_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Angkansa kas kew kesusa, supama sugiren myu, ‘Naꞌ enu ne kanen kay?’ etawa, ‘Enu ne inumen kay?’ etawa, ‘Enu ne pekayen kay?’ ");
INSERT INTO plw_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Sabab pegtulusen ginsan itue et mengeꞌ tawʼt kaya pegandel dut Empuꞌ. Na sewd et Empuꞌ Amaꞌ myu dut langit na keilangan myu ginsan itue. ");
INSERT INTO plw_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Segwaꞌ gaay myu mena pengmilikan et Empuꞌ bekeꞌ buwaten myu kegeayan ye, mendyari ginsan neng ibang keilangan myu igbey ye rimyu. ");
INSERT INTO plw_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Angkansa kasiꞌ myu pegmesusaiꞌ eldew et diklem. Tegeyen myu diklem apang pikiren pasal et kesusaan et diklem. Sabab tatap ne kesusaan et tiban. Sabab menabang Empuꞌ dimyu misan baꞌ enung kesusaan dumateng dimyu.” ");
INSERT INTO plw_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Kasiꞌ myu pengukumaꞌ et sebayaꞌ myu, etawa kemyu gasi meukum et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Sabab baꞌ ukumen myu sebayaꞌ myu taka-taka kwantin gasi iukum dut dimyu. Sampay baꞌ enu isukud myu, kwantin gasi isukud dimyu. ");
INSERT INTO plw_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Kemyu na daran pegukum, manu pegimrewen mu merinek na puling et mata et tipused mu, antangan ye merinek neng keselaan, segwaꞌ kaya penglingen mu usuk dut mata mu, antangan ye kelang keselaan. ");
INSERT INTO plw_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Enungkwan mu mesugid dut tipused mu na kwan, ‘Ugaraꞌ merinek neng keselaan mu’, segwaꞌ dimu maya nega kelang keselaan mu? ");
INSERT INTO plw_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ikew ne pebiriꞌbiriꞌ! Ugaraꞌ mena usuk dut mata mu, supaya metuman mu mengugad et merinek na puling et mata et tipused mu. ");
INSERT INTO plw_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Kasiꞌ pegbegeyaꞌ dut ireng sebarang mengeꞌ keginisan pinesukuꞌ dut Empuꞌ. Kasiꞌ myu pegtimbagaꞌ buligaꞌ dut biyek. Baꞌ binwat myu itue, pegletlebutan dye lang et mengeꞌ tiked dye, sabab pegketbes peulinan dye kemyu sampay peglurey-lureyen dye kemyu in.” ");
INSERT INTO plw_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Mengangat kew, supaya kemyu begeyan. Mengebiyaꞌ kew, supaya kemyu ketulus. Memuhun kew, na kemyu ipetindal. ");
INSERT INTO plw_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Sabab sebarang mengangat, ya begeyan, bekeꞌ baꞌ sinu mengebiyaꞌ, ya ketulus, bekeꞌ baꞌ sinu memuhun, ya ipetindal. ");
INSERT INTO plw_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Kaya megurang megey et batu baꞌ yengyegang ye mengangat et kekanen. ");
INSERT INTO plw_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Etawa kaya kenggurangan baꞌ mengangat et seraꞌ, igbey kenye seli? ");
INSERT INTO plw_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Baꞌ kemyu na mengeꞌ meraat na kesewd megey et menungang ginis dut dimyung keyegangan, lebi ne gasi Empuꞌ Amaꞌ myu dut langit, na ya megey dimyu et menunungang ginis, sebarang mengangat dut kenye. ");
INSERT INTO plw_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Angkansa baꞌ enu gay mu na buwaten et mengeꞌ taaw dut dimu, kwantin gasi buwataꞌ dut sebayaꞌ mu. Sabab et itue neginalep ne banar Keseraan et Empuꞌ na binggey ki Moises bekeꞌ ating penulduꞌ et mengeꞌ tarus ye. ");
INSERT INTO plw_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Sumled kew dut mesigpit neng lelengewan, sabab kelaꞌ lelengewan bekeꞌ melekbang dalan tudyu dut kedusaan et Narkaꞌ, bekeꞌ mekeldam megseled duntin. ");
INSERT INTO plw_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Sabab mepiet lelengewan bekeꞌ mesigpit dalan tudyu dut kebiyagan kaya keskeran abiʼt Empuꞌ, bekeꞌ kaya mekeldam mebiyanen atin lang megseled duntin.” ");
INSERT INTO plw_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Meginget kew dut mengeꞌ membut-embuten neng menunulduꞌ na megkabiꞌ dimyu na kwan mu lang samat menunungang ayup pengetngarat ye, segwaꞌ dut seled ye samat kumekaan neng setwaꞌ. ");
INSERT INTO plw_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mekilala myu membut-embuten neng menunulduꞌ dut kedyeng mengeꞌ keradya. Supama, diki kepupuꞌ kew et buaꞌ et ubas dut kesuksukan, etawa buaꞌ et mengeꞌ igus dut keperasan. ");
INSERT INTO plw_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Temed sebarang menunungang kayu muaꞌ gasi et menunga, baꞌ meyaat neng kayu, meyaat gasi buaꞌ ye. ");
INSERT INTO plw_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Menungang kayu diki muaꞌ et meyeyaat, bekeꞌ meyaat neng kayu diki muaꞌ et menununga. ");
INSERT INTO plw_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Sebarang kayu na diki muaꞌ et menunga pegputken bekeꞌ pegtimbag dut apuy. ");
INSERT INTO plw_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Angkansa mekilala myu et mengeꞌ membut-embuten neng menunulduꞌ dut kedyeng mengeꞌ keradya.” ");
INSERT INTO plw_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Diki ginsan na megtingkag daken na kwan, ‘Empuꞌ, Empuꞌ,’ na kesled dut Kemilikan dut langit, selyu lang dye in pegbuwaten et kegeayan et Empuꞌ Amaꞌ ku. ");
INSERT INTO plw_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Pegkedateng Eldew et Mengukum Empuꞌ, mekeldam megsugid daken dut eldew na atin, kwan, ‘Empuꞌ, Empuꞌ, diki be neneked kay pebiyaꞌ dut kepengdyarian mu, bekeꞌ dut kepengdyarian mu nekepeugad kay et mengeꞌ meyaat neng diwata teyeg et negbegbalig, bekeꞌ nebuwat et mekansang mengeꞌ mekeliluꞌ-liluꞌ?’ ");
INSERT INTO plw_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Angkansa isugid ku dut kedye ginsan, ‘Diki ku kemyu nekilala. Ugad kew atuʼt elepan ku, kemyu na pemuwat et kereatan!’ ” ");
INSERT INTO plw_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Angkansa sebarang megkingeg bekeꞌ megtuman et mengeꞌ bebresen ku, ya sepantun sembatung taaw na mekesewd megpetiyeg et mengeꞌ usuk et benwa ye dut batu. ");
INSERT INTO plw_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Dumateng delek, dumateng liyud, dumres gasi et mebasag, ampaꞌ sinimberan benwa, segwaꞌ diki neugbaꞌ, sabab mengeꞌ usuk ye petitiyeg dut batu. ");
INSERT INTO plw_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Segwaꞌ baꞌ sinung taaw na megkingeg et mengeꞌ bebresen ku segwaꞌ kaya pegtumanen ye, ya sepantun dungdupang neng taaw na negpetiyeg et benwa ye dut egis-egisan. ");
INSERT INTO plw_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Diminateng delek, dimineklaꞌ liyud, diminres gasi et mebasag bekeꞌ siminimber dut benwa. Pegketbes neugbaꞌ bekeꞌ nerungkat ginsan!” ");
INSERT INTO plw_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ganang netbes i Jesus neres et itueng bebresen, negliluꞌ mengeꞌ taaw dut kenyeng penulduꞌ. ");
INSERT INTO plw_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Sabab pegtulduꞌ ye samat maya kepegewlaan ye, diki samat mengeꞌ menunulduꞌ et Keseraan dut kedye. ");
INSERT INTO plw_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ganang si Jesus nepesedsad ne teyeg dut kilid et bukid, pegseselundungen ya et mekansang taaw. ");
INSERT INTO plw_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Kiminabiꞌ eset kenye sembatung taaw neng maya eldew-eldew bekeꞌ siminelukud dut teteyumanan ye, kwan ye, “Empuꞌ, baꞌ keingesian mu aku, teyen peguliniꞌ ku.” ");
INSERT INTO plw_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Kintang i Jesus keremut ye bekeꞌ kinutew ye. Kwan ye, “Keinginan ku. Na, megulinan ke.” Megtuy negulinan pukung ye. ");
INSERT INTO plw_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Indyari kwan i Jesus kenye, “Kinggaꞌ! Kasiꞌ pegsugiraꞌ dut sinu-sinu. Segwaꞌ panew, pebiriꞌ ke dut pariꞌ bekeꞌ megsimayaꞌ ke sabab itue Keseraan teyeg ki Moises na kesebenaran dut ginsan na ikew menunga ne!” ");
INSERT INTO plw_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Pegseled i Jesus dut lungsud neng Kapernaum, nepekabiꞌ kenye sembatung pegibuten et sundalu, na tawʼt lein Judio, supaya mengangat et tabang. ");
INSERT INTO plw_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Empuꞌ,” kwan ye, “daken neng tetehagen ku pebubuntul lang dut benwa sabab nepangkul bekeꞌ mesakit banar reresanen ye.” ");
INSERT INTO plw_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Kwan i Jesus dut kenye, “Surungan ku ya supaya pegulinan.” ");
INSERT INTO plw_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Siminambag kenye pegibuten et sundalu kwan ye, “Empuꞌ, kelew-lelew daken sabab diki teupen na benwa ku na mesled mu. Segwaꞌ isugiraꞌ lang na tetehagen ku megnunga. ");
INSERT INTO plw_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Sabab aku gasi sembatung taaw na maya metaas daken, bekeꞌ aku maya mengeꞌ sundalu na mebaba set daken. Baꞌ sugiren ku dut sembatu, ‘Surung!’ ya gasi megsurung. Bekeꞌ dut sembatu, ‘Matuꞌ ke!’ ya gasi megatuꞌ. Bekeꞌ baꞌ sugiran ku tetehagen ku, ‘Buwataꞌ itue!’ atin gasi buwaten ye.” ");
INSERT INTO plw_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ganang nekingeg i Jesus itue, negliluꞌ ya banar, bekeꞌ sinugid ye dut mengeꞌ megibut kenye, kwan ye, “Sugiran ku kemyu et kebenaran, kaya nekemasa ku atueʼt Israel na samat kwantin deklaꞌ et pegandel ye. ");
INSERT INTO plw_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Asal banar indaniꞌ myu na mekansang taaw mawaꞌ dut sebangan bekeꞌ dut sedpaʼt eldew na dumuntin na kebayaꞌ dut kenkanan na pegempangen de Abraham, Isaak bekeꞌ si Jakob dut Milikan et Empuꞌ dut langit. ");
INSERT INTO plw_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Segwaꞌ mekansang puranak et Israel na itimbag dut liwan, na dut kelingban, na duntin dye memenggerwak bekeꞌ memengringetnget mengeꞌ nipen dye.” ");
INSERT INTO plw_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Kwan i Jesus dut pegibuten et sundalu, “Na panew ne. Sabab et dimung kelang pegandel meinabu dimung pegengaten.” Na, negulinan ne tetehagen et pegibuten atin ne lisag. ");
INSERT INTO plw_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Pegduntin i Jesus dut benwa i Pedro, nebiriꞌ ye pengibanan neng libun i Pedro. Pebubuntul sabab et pegegnewen. ");
INSERT INTO plw_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Pegketbes na mekeptan i Jesus keremut ye, megtuy inibuanan et egnew ye, ampaꞌ ne negbangun, pegketbes ya ne negpelamak kenye et kekanen. ");
INSERT INTO plw_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ganang megngengapun ne, mekansang taaw neng sinleban et mereraat pinemibit dut kenye. Kasa beres ye lang pineliwan ye mengeꞌ meyaat neng diwata bekeꞌ negnunga dye ginsan, sebarang maya atin neng reresanen. ");
INSERT INTO plw_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Neinabu itue supaya metuman sebarang sinugid tagnaꞌ tiꞌ et tarus neng si Isaias, na kwan ye, “Insiꞌ ye in ginsan neng kesekitan tyu bekeꞌ tinenggung ye ginsan neng reresanen tyu.” ");
INSERT INTO plw_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Pegkebiriꞌ i Jesus dut kineldaman dut pelilibut ye, negsugid ya dut pepengenaran ye na dumipag dut sembelang dipag et dagat. ");
INSERT INTO plw_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Na maya menunulduꞌ et Keseraan nepekabiꞌ kenye, kwan ye, “Menunulduꞌ, panyap ku ne mibut ku dimu misan embe surungan mu.” ");
INSERT INTO plw_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Kwan i Jesus dut kenye, “Maya belebaan ireng et talun, bekeꞌ mengeꞌ begit maya mengeꞌ pugad, segwaꞌ aku, atin Yegang et Taaw, kaya lelegdengan supaya mebuntulan et ulu ku bekeꞌ kaya peternan ku.” ");
INSERT INTO plw_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Maya sembatung taaw neng pepengenaran gasi dut ki Jesus kwan ye dut kenye, “Begerar, muliꞌ ku mena teyen bekeꞌ ilbeng ku mena amaꞌ ku.” ");
INSERT INTO plw_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Segwaꞌ kwan i Jesus, “Pesariꞌ ne mengeꞌ taaw antangen dye samat mengeꞌ patey in na menglebeng dut natey neng amaꞌ mu. Ikew key, mibut ke daken dut biyag kaya seskeran!” ");
INSERT INTO plw_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Pegketbes nemenakat ne i Jesus dut gubang, sampay mengeꞌ pepengenaran ye nayaꞌ kenye. ");
INSERT INTO plw_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Kiminlat lang na maya diminateng mebasag neng ambun dut dagat, angkansa derekerang gumbang pegsipuwakan ye gubang. Segwaꞌ si Jesus megigaꞌ ga et ating masa. ");
INSERT INTO plw_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Na mengeꞌ pepengenaran ye nenyag kenye kwan dye, “Empuꞌ, tebangiꞌ kay, melneb tyu ne!” ");
INSERT INTO plw_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Neingkut i Jesus kedye, kwan ye, “Manu megtakut kew? Isek-isek dimyung pegandel.” Indyari, tuminyeg gasi ampaꞌ pinetaren ye deres bekeꞌ dagat. Na limininew banar ne ginsan. ");
INSERT INTO plw_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nemegliluꞌ mengeꞌ taaw, kwan dye, “Sinung taaw itue? Misan deres sampay dagat pengandel kenye.” ");
INSERT INTO plw_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Pegdateng i Jesus dut sembelang dagat dut lungsud et mengeꞌ Gadareno, maya duwang taaw neng sinleban et mekansang na meyeyaat neng diwata siminusup dut kenye. Negliwan itueng duwang taaw teyeg dut kelelbengan. Na meburangit banar itueng duwang taaw, angkansa kaya sinu mekebiyaꞌ duntin. ");
INSERT INTO plw_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Megtuy, megpemara ginsaʼt mengeꞌ diwata, beres dye, “Yegang et Empuꞌ, enu keilangan mu damen? Natuꞌ ke takuꞌ damen supaya peliyutan mu kami et ingga peꞌ timpu?” ");
INSERT INTO plw_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Na, dut mereꞌrayuꞌ set kedye maya banan et mekidram neꞌ mengeꞌ biyek neng megpenginaan. ");
INSERT INTO plw_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Binisara et mengeꞌ meraat neng diwata si Jesus, kwan dye, “Baꞌ ipeliwan mu kami, baꞌ mekedyari teyen iruntinaꞌ kay ne lang dut banan et mengeꞌ biyek tiꞌ.” ");
INSERT INTO plw_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Kwan i Jesus kedye, “Ireꞌ, liwan kew set kedye, bekeꞌ sumled kew dut banan et mengeꞌ biyek!” Angkansa nemengliwan dye ampaꞌ dye siminled dut banan et mengeꞌ biyek. Na mengeꞌ kebikbiyekan nemengdarak surung dut kepengrasan bekeꞌ neregdag dye dut dagat na dun dye nelelmes ginsan. ");
INSERT INTO plw_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Sebarang nemengipat et mengeꞌ biyek nemendarak surung dut kebenbenwanan bekeꞌ sinugid dye ginsan pasal baꞌ enu neinabu dut mengeꞌ biyek bekeꞌ dut mengeꞌ sinleban et mereraat. ");
INSERT INTO plw_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Indyari ginsan neng mengeꞌ taaw dut lungsud naꞌ atin siminurung dut ki Jesus apang sumusup kenye. Baꞌ nebiriꞌ dye ya na ipinengasiꞌasiꞌ dye si Jesus na mugad ne set lungsud dye in. ");
INSERT INTO plw_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Siminakat si Jesus dut gubang diminipag peuliꞌ dut sembelaꞌ neng dagat bekeꞌ siminurung dut diri ye neng lungsud, Kapernaum. ");
INSERT INTO plw_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Na dut Kapernaum, duun mengeꞌ senung ketawan nibit dut ki Jesus et sembatung pangkul na pebubuntul dut demdam. Pegkebiriꞌ i Jesus et kelang pegandel dye, kwan ye dut taaw neng pangkul, “Yegang, kepenggeraꞌ seled mu! Inampun ne salaꞌ mu.” ");
INSERT INTO plw_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Sabab et itueng pinegberes i Jesus, mengeꞌ menulduꞌ et Keseraan nemegberes dye dut diriꞌ dye, kwan dye, “Pepeempuꞌempuꞌ itueng taaw na itue!” ");
INSERT INTO plw_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Segwaꞌ pegsesewren i Jesus kedyeng pegpipikiren, kwan ye, “Manu meraat ne nepikir myu? ");
INSERT INTO plw_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Banar, lebing merugey sugiren, ‘Teyeg ne bekeꞌ panew ne,’ kasga sugiren, ‘Dimung salaꞌ inampun ne,’ ");
INSERT INTO plw_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","sabab Empuꞌ lang mekeampun et keselaan, segwaꞌ supaya mesewran myu na ating Yegang et Taaw maya kepengdyarian na mengampun et salaꞌ atuʼt dunyaꞌ, indaniꞌ itue.” Pegketbes kwan ye dut taaw neng pangkul, “Teyeg ne, bikyataꞌ ne iganigan mu bekeꞌ muliꞌ ke ne.” ");
INSERT INTO plw_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Angkansa ating taaw timinyeg bekeꞌ nuliꞌ dut benwa ye. ");
INSERT INTO plw_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Pegkebiriꞌ et kineldaman et taaw, nemengliluꞌ dye banar, bekeꞌ binantug dye Empuꞌ neng negey et mengeꞌ taaw et kepengdyarian na samat kwantin. ");
INSERT INTO plw_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Pegpelembus i Jesus et panew ye nebiriꞌ ye sembatung taaw na ingaran ye si Mateo na megarung dut benwa neng susukutan et buwis. Na sinugid i Jesus dut kenye, kwan ye, “Mibut ke daken!” Timinyeg si Mateo bekeꞌ nibut kenye. ");
INSERT INTO plw_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ganang megkekaan si Jesus et penengeldewan ye dut benwa i Mateo, mekansang menunukut et buwis bekeꞌ mengeꞌ ibang tegekeselaan na liminamud mengaan dut ki Jesus bekeꞌ dut mengeꞌ pepengenaran ye. ");
INSERT INTO plw_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Pegkebiriꞌ itue et mengeꞌ pariꞌ na Pariseo, nengingkut dye dut mengeꞌ pepengenaran ye, kwan dye, “Manu Menunulduꞌ myu pepelamud mengaan dut mengeꞌ menunukut et buwis bekeꞌ dut mengeꞌ tegekeselaan?” ");
INSERT INTO plw_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Pegkingeg i Jesus, kwan ye, “Kaya nengengeilangan et mengunguru sebarang kaya sakit, segwaꞌ nengengeilangan et mengunguru sebarang maya sakit. ");
INSERT INTO plw_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Manew kew ne bekeꞌ retiaꞌ myu baꞌ enu ingin bersen ye itueng Kesuratan et Empuꞌ, kwan, ‘Ingasiꞌ ingin ku, diki lang mengeꞌ simayaꞌ.’ Sabab diki ku natuꞌ supaya pilinen sebarang keblan dye metitignaꞌ, segwaꞌ natuꞌ supaya tebangen ku et mengeꞌ mekeselaan.” ");
INSERT INTO plw_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Indyari nepekabiꞌ dut kenye mengeꞌ pepengenaran i Juan neng Mememewtismu, kwan dye, “Enungkwan itue na kami bekeꞌ mengeꞌ Pariꞌ na Pariseo pegpuasa, segwaꞌ dimung pepengenaran kaya lang pemegpuasa?” ");
INSERT INTO plw_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Kwan i Jesus, “Enungkwan rumupuk mengeꞌ mengluluruk sementaraꞌ lelaki neng ibulun esentin nega? Diki lang! Segwaꞌ dumateng timpu na ibulun neng lelaki ugaren dut kedye. Atin peꞌ memegpuasa ne.” Neglahyun ne si Jesus neres. ");
INSERT INTO plw_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Kwan ye, “Kaya sinu meketempel et bagung kumut dut lelagi neng badyuꞌ, sabab melanut dut tinimpelan et bagu na tinempel, lebi ne dumeklaꞌ ne banar uyat ye. ");
INSERT INTO plw_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Diki gasi mekedyari isunuꞌ et taaw bagung alak dut lelagi neng susunuan. Sabab baꞌ isunuꞌ dye duntin, mekedyaring lumput ating susunuan, indyari meulaꞌ ne inumen neng alak in bekeꞌ mepsaꞌ ne ating susunuan. Erapun, subaliꞌ isunuꞌ bagu neng alak dut bagung susunuan gasi supaya saliꞌsaliꞌ dye meipat et menunga.” ");
INSERT INTO plw_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Sementaraꞌ megbebres nega si Jesus et itue, sembatung pegibuten et mengeꞌ Judio nepekabiꞌ bekeꞌ siminelukud dut teteyumanan ye, kwan ye, “Ingga peꞌ nekwit pegpatey et yegang ku neng budyang. Segwaꞌ baꞌ mekedyari teyen bayaꞌ kew daken sabab mengarap ku na baꞌ depnen mu ya, asal ya megbiyag.” ");
INSERT INTO plw_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Timinyeg si Jesus bekeꞌ nayaꞌ dut kenye, bekeꞌ mengeꞌ pepengenaran ye nayaꞌ gasi. ");
INSERT INTO plw_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Naꞌ, maya gasi sembatung libun na megkesandalen et sakit neꞌ pegduruguan et sempuluꞌ duwang teun ne, kaya megtuug tapis ye. Na nepekabiꞌ dut lilikuran i Jesus ampaꞌ ye kinutew bingbiring et badyuꞌ i Jesus. ");
INSERT INTO plw_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Kwan et sedseled ye, “Baꞌ mekutew ku lang bingbiring et badyuꞌ ye, megulinan ku ne.” ");
INSERT INTO plw_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Liminingew si Jesus kwan ye dut kenye, “Yegang, kepenggeraꞌ seled mu. Dimung pegandel negpenunga dimu.” Atin negang masa megtuy negulinan libun. Neglahyun gasi si Jesus dut benwa et pegibuten. ");
INSERT INTO plw_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ganang nekerateng, siminled ne si Jesus dut benwa et pegibuten et mengeꞌ Judio bekeꞌ nebiriꞌ ye mengeꞌ menunuling et kelebengen bekeꞌ kineldaman na memeggikgibek. ");
INSERT INTO plw_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Kwan ye dut kedye, “Liwan kew! Ating budyang ingga patey, segwaꞌ megigaꞌ lang!” Segwaꞌ nemengsit dye lang dut kenye. ");
INSERT INTO plw_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Pagkaꞌ mengeꞌ taaw nepeliwan ye ne, siminled gasi i Jesus bekeꞌ kimpetan ye dut keremut et budyang neng libun, angkansa negbangun budyang. ");
INSERT INTO plw_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Tuturan pasal itue limingkep dut sengkelungsuran na atin. ");
INSERT INTO plw_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ganang nugad ne si Jesus teyeg dut lungsud naꞌ atin, maya nepesunud kenye duwang mengeꞌ beleg. Indyari timiningkag dye, kwan dye, “Inupuꞌ i Surutan Dabid, meingasiꞌ ke damen!” ");
INSERT INTO plw_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Pegseled i Jesus dut benwa, negpekabiꞌ dut kenye mengeꞌ beleg neꞌ lelaki. Iningkut dye i Jesus, kwan ye, “Mengandel kew be dut daken na itue mebuwat ku supaya megulinan kew?” “Eꞌ, Begerar, andel kay,” sambag dye. ");
INSERT INTO plw_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Indyari kinutew ye ne kedyeng mata ampaꞌ ne neres, kwan ye, “Kuyun dut pengandel myu dut Empuꞌ, meinabu teyen atin samat keendelen myu.” ");
INSERT INTO plw_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Indyari negnunga ne penyek dye. Pegketbes negbilin si Jesus, kwan ye, “Amay-amay banar, kasi myu pegsugiraꞌ itueng ginis dut misan sinu!” ");
INSERT INTO plw_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Segwaꞌ nugad dye bekeꞌ masi ga pineabar dye kebentugan i Jesus dut ginsaʼt mengeꞌ lungsud pelibut duun. ");
INSERT INTO plw_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ganang megugad dye ne, aluꞌ, maya gasi sembatung lelaki binibit dut ki Jesus na sembatung pegselban et meraat angkan kaya mekebres. ");
INSERT INTO plw_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Pagkaꞌ nepeliwan ne ating meraat, ating lelaki nekebres ne. Indyari mengeꞌ kineldaman nemengliluꞌ, kwan dye, “Atuʼt Israel kayangga peꞌ nebiriꞌ na neinabu samat kwantin!” ");
INSERT INTO plw_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Segwaꞌ kwan ga et mengeꞌ Pariꞌ na Pariseo in, kwan dye, “Sabab lang binggey atin kependyarian et pengibuten et mengeꞌ mereraat in, angkan si Jesus maya basag supaya nekepeliwan et mereraat.” ");
INSERT INTO plw_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Pegketbes siminurung si Jesus dut ginsaʼt mengeꞌ lungsud bekeꞌ dut mengeꞌ kebenbenwanan. Penulduꞌ ye dut mengeꞌ pegpengempuan et mengeꞌ Judio, na pepabar pasal et Menungang Abar et Pengmilikan et Empuꞌ, bekeꞌ pepenunga ye sebarang mengeꞌ maya misan enung reresanen bekeꞌ ginsaʼt mengeꞌ sakit. ");
INSERT INTO plw_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ganang nebiriꞌ ye mengeꞌ kineldaman, nekeingasiꞌ dut kedye sabab dye samat pegelamen mene bekeꞌ mengeꞌ melulumek, samat mengeꞌ ipatan neng bibili na kaya mengingipat. ");
INSERT INTO plw_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Indyari kwan ye dut mengeꞌ pepengenaran ye, “Mengeꞌ keldamen antangan dye samat mengeꞌ uma panyap ne keygen. Mekansang ne kekeygen, segwaꞌ kaya mekansang mengengeyg. ");
INSERT INTO plw_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Angkansa mengangat kew dut Empuꞌ et itueng kekeygan, supaya megpebibit ya et mengengeradya dut kenyeng kekeygan.” ");
INSERT INTO plw_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ipinekabiꞌ i Jesus itueng sempuluꞌ duwang pepengenaran ye bekeꞌ binggeyan ye et kepengdyariang keseg megpeugad et megsaleb neng meyaat neng diwata, bekeꞌ mepegulinan ginsaʼt mengeꞌ keginisan neng reresanen bekeꞌ kesekitan. ");
INSERT INTO plw_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Itue ne ngaran et sempuluꞌ duwang pepengenaran i Jesus. Una in si Simon, pegngeranaʼt Pedro bekeꞌ tipused ye neng si Andres; de Jakob bekeꞌ si Juan neng mengeꞌ keyegangan i Sebedeo; ");
INSERT INTO plw_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","de Pelipe bekeꞌ si Bartolome, si Tomas bekeꞌ si Mateo na menunukut et buwis; si Jakob na yegang i Alpeo, bekeꞌ si Tadeo. ");
INSERT INTO plw_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Indyari iba in si Simon neng memimisara bekeꞌ si Judas Iskariote, na negpeelen ki Jesus. ");
INSERT INTO plw_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Itueng sempuluꞌ duwang pepengenaran pinepanew i Jesus, kenyeng pineeturan, kwan, “Kas kew sumurung dut lungsud dut mengeꞌ taaw lein Judio, etawa misan embeng lungsud et mengeꞌ Samaritano. ");
INSERT INTO plw_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Erapun, duun kew lang eset mengeꞌ tawʼt Israel, sabab sama dyeʼt pegeelamen neng bibili na kaya mengingipat dye. ");
INSERT INTO plw_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Na dut pegsurung myu ipengabar myu ne, ‘Mekabiꞌ ne Pengmilikaʼt Empuꞌ.’ ");
INSERT INTO plw_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Pegulinan myu mengeꞌ mesesakit bekeꞌ biyagen mengeꞌ patey. Pegulinan myu mengeꞌ sakit neng eldew-eldew, bekeꞌ ipeugaraꞌ myu megsaleb neng meyaat neng diwata. Indyari, sabab et penerima kew et kaya bayad, subaliꞌ menggey kew gasi et kaya bayad. Gay bersen meneraka dut Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Kas kew memibit et pirak etawa bulawan, etawa tumbaga eset dimung pitakaꞌ. ");
INSERT INTO plw_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Kas kew gasi memibit et susunuan dut pepenewan myu, etawa seselinan, mengeꞌ tempaꞌ etawa tutungkud. Sabab mengeꞌ mengengeradya subaliꞌ ibgey kedye ne baꞌ enu keilangan dye. ");
INSERT INTO plw_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Indyari misan embeng lungsud etawa baryo detengan myu, menulus kewʼt metindalan na metignaꞌ arat ye, tumerna kew ne esentin seked keugad kewʼt lungsud dye in. ");
INSERT INTO plw_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Pegseled myuʼt benwa dye, ibersaꞌ myu, ‘Megmilik teyen kesenangan atueʼt benwa.’ ");
INSERT INTO plw_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Na baꞌ teup mengeꞌ taaw atueʼt benwa, dumaran kedye dimyung pemangling et kesenangan. Temed baꞌ diki teup, isiaꞌ myu peuliꞌ dimyung penglingaꞌ et kesenangan. ");
INSERT INTO plw_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Na baꞌ diki dye menerima etawa mengingeg et dimyung ipeabar kedye, memengugad kew ne eset lungsud dye in, pegketbes tepnisaꞌ myu tehuk eset dimyung tiked. ");
INSERT INTO plw_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Itangeꞌ ku dimyu na dut Eldewʼt Pegukum, luwas nega yaat iukum et Empuꞌ dut mengeꞌ tawʼt eset lungsud naꞌ atin kasga dut nelebayan et mengeꞌ meyaat neng taaw dut mengeꞌ lungsud et Sodoma bekeꞌ Gomora.” ");
INSERT INTO plw_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Itue tiban, pegdeaken ku kemyu na samat mengeꞌ bibili eset tengaʼt peguunulen neng ireng. Megmendyaring meutek na samat mengeꞌ seli, bekeꞌ tempad naꞌ samat mengeꞌ aksang. ");
INSERT INTO plw_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Pegbeꞌbetiꞌ kew sabab maya mengalew dimyu pesurung dut ukuman, pegketbes lipdasan kew dut mengeꞌ sinagoga. ");
INSERT INTO plw_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Sabab eset daken, ipeelep kew dut mengeꞌ pegibuten bekeꞌ mengeꞌ surutan supaya iukum. Indyari pesebenaran myu dut elepan dye bekeꞌ eset mengeꞌ tawʼt lein Judio pasal et Menungang Abar et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Na baꞌ pegingkuten kew ne dut ukuman, dyangan kew lang mesusa tudyu dut mengeꞌ isambag myu etawa baꞌ enukwan myu itue sembagen. Pegdateng et timpu, ibgey nega dimyu baꞌ enu isambag myu. ");
INSERT INTO plw_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Temed kebenaran ye, lein lang kemyu megebres. Erapun itueng Nakem mawaʼt Empuꞌ Amaꞌ key megebres pebiyaꞌ lang eset dimyu. ");
INSERT INTO plw_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Maya taaw ipealew ye ne diriꞌ yeng tipused apang ipepatey, kwantin gasi buwaten et amaꞌ eset kenyeng yegang. Etuanan ne et mengeꞌ keyegangan kedyeng mengeꞌ kenggurangan, amaꞌ bekeꞌ induꞌ, apang ipepatey. ");
INSERT INTO plw_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Kutukan kew neʼt ginsan sabab lang et daken. Temed dumaran menatap misan ingyan, atin key mebawiꞌ. ");
INSERT INTO plw_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Na baꞌ pegsegkaan kew et sembatung lungsud, lumahyun kew dut ikeruwang lungsud. Pegsugiren ku dimyu, kayangga peꞌ neapet myu ginsang lungsud et Israel supaya ipeabar kedye, mura dumateng ne aku, itueng Yegang et Taaw. ");
INSERT INTO plw_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Kaya lang pepengenaran na mas metaas nega et menunulduꞌ ye, etawa kaya lang uripen metaas eset begerar ye. ");
INSERT INTO plw_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","“Mesdengan itueng pepengenaran na sumaliꞌ dut menunulduꞌ ye, bekeꞌ itueng uripen sumaliꞌ dut begerar ye. Na baꞌ aku samat sembatung pegibuten et kelungsuran, bekeꞌ pegngeranaʼt dye aku si Seytan, lebi dye lang terwanan kemyu mengeꞌ pepengenaran ku dut pegsukuan ku!” ");
INSERT INTO plw_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Angkansa dyangan lang tumakut et misan sinu. Ginsan neng pegteguen in, meketulusan nega, bekeꞌ ginsaʼt mengeꞌ ilimed in mekebunayag nega. ");
INSERT INTO plw_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Misan enu neng pegsugiren dimyu dut kelingban, subaliꞌ ibres myu dut ketemparan, bekeꞌ mengeꞌ pegkinesen dimyu in, subaliꞌ myu ipebasag dut timbew et benwa. ");
INSERT INTO plw_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kasiꞌ myu pegtekutiꞌ inyet pematey et bilug temed kaya mekepatey et kurudua. Erapun ketekutan myu Empuꞌ banar dut langit naꞌ mekepatey et bilug bekeꞌ kurudua dut Narkaꞌ. ");
INSERT INTO plw_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Diki be takuꞌ pepegelnan et duwang dignes dut sembatung pirak ga? Megsepantun, misan sembatu kedye diki lang meregdag dut lugtaꞌ baꞌ diki mene geayen et dimyung Empuꞌ Amaꞌ. ");
INSERT INTO plw_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Na pasal dimyu, misan ga atin ginsan neng buek myu neitung ne. ");
INSERT INTO plw_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Angkansa, kas kew takut, sabab lebi kew negang mergaꞌ eset mengeꞌ laksang-laksang dignes tiꞌ.” ");
INSERT INTO plw_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Mayang sinu mengandel bekeꞌ kumilala eset daken dut elepaʼt mengeꞌ taaw, kilelanen ku gasi dut elepaʼt Empuꞌ neng Amaꞌ ku dut langit. ");
INSERT INTO plw_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Temed, baꞌ ipeilu dye aku dut elepaʼt taaw, aku gasi megpeilu kedye eset elepaʼt Empuꞌ neng Amaꞌ ku dut langit.” ");
INSERT INTO plw_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Kasiꞌ myu pegpikiraꞌ na natuꞌ ku apang memibit et kesenangan dut taaw atueʼt lugtaꞌ. Erapun, natuꞌ ku apang memibit et keeriweraan, lein lang kesenangan. ");
INSERT INTO plw_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Punsabab et pegatuꞌ ku apang ipegatu yegang neng lelaki dut amaꞌ ye, dut yegang naꞌ libun dut induꞌ ye, dut menempil yeng libun bekeꞌ dut pegibanan yeng libun gasi. ");
INSERT INTO plw_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Indyari, mengeꞌ kebanta et sembatung taaw dye in iba ye dut seled benwa ye ne in. ");
INSERT INTO plw_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Indyari mayang megmergaꞌ kenyeng amaꞌ etawa induꞌ na luwas negaʼt daken, diki teup dye mendyaring pepengenaran ku. Na baꞌ atin megmergaꞌ dut yegang naꞌ lelaki etawa libun na luwas negaʼt daken, diki teup dye mendyaring pepengenaran ku. ");
INSERT INTO plw_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Mayang diki tumenggung et kenyeng krus bekeꞌ mibut daken, diki teup dye mendyaring pepengenaran ku. ");
INSERT INTO plw_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Mayang menimurut kenyeng biyag, atin key meugaran. Indyari sebarang igbey et biyag ye sabab daken, atin key megbeyan biyag banar kaya seskeran.” ");
INSERT INTO plw_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Itueng megteterima dimyu, atin megterima daken, bekeꞌ itueng megterima daken atin megterima dut nengdaak daken. ");
INSERT INTO plw_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Misan sinung megterima dut sembatung tarus et Empuꞌ sabab ya in tarus et Empuꞌ, atin keterima et ganti tudyu dut tarus. Na baꞌ tumerima keʼt sembatung taaw naꞌ metignaꞌ sabab ya tuꞌ metignaꞌ, atin keterima et ganti tudyu eset taaw naꞌ metignaꞌ. ");
INSERT INTO plw_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Indyari, misan sinu mekegbey et ganang sembatung sawan neng danum naꞌ meramig dut atin pinekebaba neng tetehagen ku tuꞌ sabab itue mengingibut ku, tentuen ku dimyu na ya in keterimaʼt ganti teyeg Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Pegketbes nebilinan ne i Jesus itueng sempuluꞌ duwang pepengenaran, nugad ya duun apang menulduꞌ bekeꞌ mengabar dut mengeꞌ kelungsuran na mekabiꞌ duntin. ");
INSERT INTO plw_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Sasat si Juan neng Mememewtismu dut seled pipirisuan, neebaran ye itueng mengeꞌ pegbuwaten i Jesus. Indyari tinahag i Juan ibang pepengenaran ye in dut ki Jesus. ");
INSERT INTO plw_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Pineingkut kedye, kwan, “Ikew ne takuꞌ pegtulusen kay tuꞌ? Etawa subaliꞌ tumagey kay ne gasi et lein?” ");
INSERT INTO plw_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Siminambag si Jesus, kwan, “Peuliꞌ kew ki Juan, indyari isugiraꞌ myu kenye itueng mengeꞌ nekingeg bekeꞌ nesiyekan myu. ");
INSERT INTO plw_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Nemekebiriꞌ ne mengeꞌ beleg, nemekepanew ne mengeꞌ pangkul, nemegulinan ne mengeꞌ tegeldew-eldew, nemekekingeg ne mengeꞌ bengel, pemegbiyag ne mengeꞌ patey, bekeꞌ pegpebunayag dut mengeꞌ miskin itueng Menungang Abar. ");
INSERT INTO plw_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Mesukud itueng taaw na kaya lang pegalang-alang dut daken!” ");
INSERT INTO plw_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ganang nemekeugad ne pepengenaran i Juan, negberes si Jesus dut mengeꞌ kineldaman petudyu ki Juan. Neingkut ye kedye, kwan, “Manu angkan takuꞌ nugad kew dut kelnangan ki Juan? Enu takuꞌ gay myu mesyekan? Sembatung taaw antangan ye samat sembatu be neng kilulu na mekedresan? ");
INSERT INTO plw_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Enung ginisan neng taaw takuꞌ gaay myu mesyekan? Sembatung taaw na megbebadyuʼt megseru? Na itueng mengeꞌ megbebadyuʼt megseru na dut kelang benwaʼt surutan. ");
INSERT INTO plw_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Enu takuꞌ gay myu mesyekan? Sembatung tarus et Empuꞌ? Eꞌ be! Indyari isugid ku banar dimyu, ya in luwas nega eset tarus lang. ");
INSERT INTO plw_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Sabab si Juan key pegbebersen et Kesuratan, kwaʼt Empuꞌ, ‘Itue e ne, unang mengengabar na tinahag ku mura ke dumateng. Penyapen ye dimyung bebyaan.’ ");
INSERT INTO plw_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Pegtentuen ku dimyu, dut mengeꞌ pinengganak, kaya lang misan sinu na lebing metaas eset ki Juan neng Mememewtismu. Temed dut megpekebaba dut mengeꞌ taaw neng Pengmilikaʼt Empuꞌ dut langit, atin metaas luwas negaʼt ki Juan. ");
INSERT INTO plw_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Tinegnanan nega na mengabar si Juan neng Mememewtismu sumked sampay tiban tuꞌ, maya dye na sandalen misan enu supaya mengabar pasal et Pengmilikan et Empuꞌ, bekeꞌ maya dye na gasi legesen banar ampaꞌ mekekibayaꞌ dut Pengmilikan ye. ");
INSERT INTO plw_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Sabab itueng mengeꞌ tarus et Empuꞌ bekeꞌ dut Keseraan binggey et Empuꞌ ki Moises negpebunayag pasal et Pengmilikan et Empuꞌ, sumked na kwantin gasi ki Juan in. ");
INSERT INTO plw_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Na baꞌ tantu lang mengarap kew et Kesuratan et Empuꞌ, si Juan ne tuꞌ neng si Elias na tegeyen myu matuꞌ, samat kwaʼt dut Kesuratan in. ");
INSERT INTO plw_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Sebarang maya ikingeg, atin mengingeg! ");
INSERT INTO plw_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Na, dut embe ku takuꞌ mepesiring itueng mengeꞌ taaw tiban? Sama dyeʼt mengeꞌ keyegangan na memegearung dut tetebuan na pemegmara dut kedyeng kebelbengel, kwan dye, ");
INSERT INTO plw_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Binesalan kay kemyu et agung temed kaya kew timinarek. Nenginrurung kay, temed kaya kew siminyak.’ ");
INSERT INTO plw_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Indyari natuꞌ si Juan, negpuasa bekeꞌ kaya lang nenginum et mekelangu, temed ga in, pegbersen dye, kwan, ‘Pegseselban neʼt diwata i Seytan.’ ");
INSERT INTO plw_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Indyari, natuꞌ gasi Yegang et Taaw, pengaan bekeꞌ penginum, indyari pegsudsugiren dye gasi, ‘Birinaꞌ myu itueng taaw tuꞌ! Ya in mereren bekeꞌ melangu, biꞌbilaꞌ et menunukut et buwis bekeꞌ mengeꞌ ibang mekesalaꞌ.’ Temed lang, itueng kesewran et Empuꞌ mekesebenaran sugat pebiyaꞌ dut kenyeng mengeꞌ nebuwat.” ");
INSERT INTO plw_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Pegketbes, inisgan i Jesus itueng mengeꞌ taaw et mengeꞌ kelungsuran na binwatan ye et mekansang neng keliꞌliluꞌ sabab kaya lang pemegsusun na ugaren kedyeng keselaan. ");
INSERT INTO plw_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Kwan i Jesus, “Keingasiꞌ kew mengeꞌ tawʼt Korasin! Keingasiꞌ kew gasi mengeꞌ tawʼt Betsaida! Sabab baꞌ dut tawʼt Tiro bekeꞌ Sidon binwat itueng mengeꞌ keliꞌlilung neinabu dimyu tuꞌ, nekwit dye ne teyen megbebadyuʼt karut bekeꞌ megearung dut abu apang mepesebenaran dye lang na memegsususun ne dut Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Temed pegsugiren ku dimyu, dut Eldewʼt Pegukum et Empuꞌ, luwas nega liyut mebtangan myu kasga mebtangan et mengeꞌ tawʼt Tiro bekeꞌ mengeꞌ tawʼt Sidon. ");
INSERT INTO plw_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Indyari kemyu, mengeꞌ tawʼt Kapernaum! Gay myu na lumangkew seked langit? Erapun, iregdag kew dut Narkaꞌ! Sabab baꞌ dut mengeꞌ tawʼt Sodoma binwat itueng mengeꞌ keliluꞌlilung binwat ku atueʼt dimyu, teyen dumaran nega itueng lungsud sampay tiban. ");
INSERT INTO plw_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Temed pegsugiren ku dimyu, dut Eldew et Pegukum et Empuꞌ, lebi negang meliyut iperasa dimyu kasga eset neresanan et mengeꞌ tawʼt Sodoma.” ");
INSERT INTO plw_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Dut timpuʼt atin, negpenalang si Jesus kwan, “Pegpeselematan ku ikew Empuꞌ Amaꞌ ku, Begerar et langit bekeꞌ lugtaꞌ sabab nilimed mu itueng mengeꞌ ginis dut kesesewran bekeꞌ meuutek, indyari pinebunayag dut mengeꞌ kaya megiskul. ");
INSERT INTO plw_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Eꞌ be, Empuꞌ Amaꞌ, sabab kwantin ke mekeseraan meinabu. ");
INSERT INTO plw_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Pinemgey daken et Empuꞌ Amaꞌ ku itueng ginsan neng keginisan. Kaya lang mekekilala et Yegang selyu Amaꞌ ga in, bekeꞌ kaya lang mekekilala et Amaꞌ selyu Yegang ga in bekeꞌ atin lang neng geayen pegpebunayagan et Yegang in. ");
INSERT INTO plw_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Kumabiꞌ kew daken ginsan kemyu neng peglelehaken bekeꞌ mekebegatan et pegpepsanen, indyari kemyu in ipetaren ku. ");
INSERT INTO plw_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Pesakup kew daken, indyari meganad kew daken. Sabab aku tuꞌ meguep bekeꞌ mesabar, indyari metulusan myu kepeternan et dimyung kurudua. ");
INSERT INTO plw_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Sabab merugey itueng daken neng singkew ibgey ku dimyu, bekeꞌ megangan lang tenggulen itueng ibgey ku dimyu in.” ");
INSERT INTO plw_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Sene tiꞌ, seng Eldewʼt Kepeternan, nekelabay de Jesus dut ketiriguan. Pemegurapan ne iba yeng mengeꞌ pepengenaran, angkansa nemengeyg dyeʼt uheyen, pegketbes pinengaan dye ne betuen in. ");
INSERT INTO plw_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Indyari ganang nebiriꞌ itue et mengeꞌ Pariꞌ et Pariseo, negberes dye dut ki Jesus, kwan dye, “Siyekiꞌ be, pegbuwaten et pepengenaran mu, sagkaꞌ atin baꞌ Eldew et Kepeternan.” ");
INSERT INTO plw_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Siminambag si Jesus, kwan, “Manu kaya takuꞌ nebatsaꞌ myu binwat i Surutan Dabid tagnaꞌ in, ganang inurapan ga ya bekeꞌ kenyeng ketindegan in? ");
INSERT INTO plw_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Siminled ya dut pengempuan neng benwaʼt Empuꞌ, indyari ampaꞌ ne nengaan et bengbang neng sinimayaꞌ dut Empuꞌ, pegketbes pinekaan ye gasi kenyeng ketindegan. Sagkaꞌ dut Keseraan na kanen dye ating bengbang sabab mengeꞌ Pariꞌ lang mekepegewla kekaan et atin. ");
INSERT INTO plw_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Kayangga peꞌ takuꞌ nebebatsaꞌ myu dut Keseraan et Empuꞌ binggey ki Moises na kede Eldew et Kepeternan mengeꞌ Pariꞌ pegkeradya dut pengempuan neng benwa et Empuꞌ, sagkaꞌ et arat pasal et itueng Eldew et Kepeternan. Misan kwantin diki gasi atin ikesalaꞌ kedye? ");
INSERT INTO plw_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Pegsugiren ku dimyu, tiban atue maya lebing metaas eset pengempuan neng benwaʼt Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Diki lang teyen binetangan myu itueng mengeꞌ kaya keselaan, na baꞌ nesewran myu lang retiꞌ et mengeꞌ itueng bebresen teyeg et Kesuratan et Empuꞌ, kwaʼt Empuꞌ, ‘Ingasiꞌ gay ku, lein lang simayaꞌ.’ ");
INSERT INTO plw_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Indyari, itueng Eldew et Kepeternan dut seled penggewman et aku, atin Yegang et Taaw.” ");
INSERT INTO plw_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Tinirengan i Jesus ating lungsud, ampaꞌ ne siminurung dut sinagoga, ingin bersen dut pengempuan naꞌ benwa. ");
INSERT INTO plw_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Maya duntin sembatung lelaki na patey ugat et sembelang lengen ye. Duntin gasi maya mengeꞌ senung taaw na enukwan metulusan et ketekeran ki Jesus. Indyari nemengingkut dye, kwan, “Pegtugut be takuꞌ uyun dut kityung Keseraan na menguru dut Eldewʼt Kepeternan?” ");
INSERT INTO plw_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Sinambag i Jesus, kwan, “Na baꞌ misan sinu dimyu na maya bibili neregdag dut kupung dut Eldew et Kepeternan, diki be takuꞌ bewinen ye itue? ");
INSERT INTO plw_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Na lebi negang mergaꞌ itueng sembatung taaw kasga eset bibili! Angkansa uyun dut Keseraan na memuwat et ikenunga dut Eldewʼt Kepeternan.” ");
INSERT INTO plw_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Pegketbes, sinugid ye dut taaw na patey ugat et sembelang lengen ye, kwan ye, “Iktangaꞌ dimung lengen.” Pinektang ye kenyeng lengen, megtuy selus negulinan, samat sembelang lengen ye ne in. ");
INSERT INTO plw_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Nemengugad ne mengeꞌ tawʼt Pariseo, indyari nemegsudsugid dye ne, na baꞌ enukwan mepatey si Jesus. ");
INSERT INTO plw_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Sewd ne lagi i Jesus itueng paru et mengeꞌ tawʼt Pariseo, angkansa nugad ne megtuy duntin. Mekansang nememayaꞌ kenye. Indyari pinegulinan ye ginsan itueng mengeꞌ meiinglew. ");
INSERT INTO plw_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Temed pineamay-amayan ye na pinenugiran dye ginsan na diki ne ipebunayag pasal kenye. ");
INSERT INTO plw_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Neinabu itue apang metuman pegsugiren et Empuꞌ pebiyaꞌ i tarus Isaias, kwan, ");
INSERT INTO plw_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Atue ne mengengeradya ku, na aku nega piniliꞌ, pegmerganen kuʼt lebi, bekeꞌ teup ye neng kegeayan ku. Daken neng Nakem kenye Ku ibgey, bekeꞌ ipebunayag ye daken neng ketignaan dut ginsang tawʼt mengeꞌ kebangsaan. ");
INSERT INTO plw_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Diki lang ya sumagkaꞌ eset meneyney lang memisara, kenyeng pegberes diki kekingeg dut dalan. ");
INSERT INTO plw_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Diki lang berien ye kilulu neng perurunguk, na diki gasi pesewen ye pekepkerep neng pelitaan. Mesendalen ye sekdan mebetangan et saraꞌ na mepengindeagan ye. ");
INSERT INTO plw_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Indyari itueng ginsang taaw dut kenye lang mengarap.” ");
INSERT INTO plw_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Maya pineuruan dye ki Jesus sembatung lelaki na beleg bekeꞌ umew sabab pegseselban et meraat neng diwata kenye. Pinegulinan i Jesus lelaki in, ampaꞌ megtuy nekebres bekeꞌ nekebiriꞌ ne. ");
INSERT INTO plw_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nemegliꞌliluꞌ ne ginsan, kwan, “Itue ne be takuꞌ inupuꞌ i Surutan Dabid tagnaꞌ tumagey kay ne gasi?” ");
INSERT INTO plw_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ganang nekekingeg itue et mengeꞌ pariꞌ naꞌ Pariseo, nesugid dye, “Diki lang! Mekepeugad et meraat neng diwata ating taaw, sabab binggeyan ya i Seytan neng surutan et mengeꞌ meraat naꞌ diwata neng mekepengdyarian nemuwat atin.” ");
INSERT INTO plw_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Pegsesewren i Jesus kedyeng pegpipikiren, angkansa sinugid ye kedye, “Mereraag kede kelungsuran netahak et megsembelang rungrupung. Indyari mepupuhar misan embeng lelegdengan etawa benwa neng nemegtektahak pegketbes memegeatu-atu ne. ");
INSERT INTO plw_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Megdemikian gasi dut ki Seytan. Na baꞌ si Seytan megpeugad gasi mengeꞌ diwata i Seytan, pegetuanan ye ne kenyeng diri! Enukwan nega takuꞌ mekedaran pengmilikan ye? ");
INSERT INTO plw_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Na baꞌ pegsugiren myu na aku mekepeugad ki Seytan pebiyaꞌ kepengdyarian binggeyan daken i Seytan, sinu gasi nenggeyʼt kepengdyarian dut dimyung eenaran na mekebuwat et kwantin? Dimyung eenaren ne gasi mekepesebanar na negsalaꞌ kew! ");
INSERT INTO plw_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Na baꞌ Nakem et Empuꞌ nenggey daken et kepengdyarian megpeugad et meraat neng diwata teyeg si Seytan, mekepesebanar na itue diminateng ne dimyu Pengmilik et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Enukwan takuꞌ mesled itueng benwa et mebasag neng taaw, ampaꞌ isien artaꞌ ye, baꞌ diki lang ya pungpungen? Na baꞌ nepungpung ne, atin peꞌ kesled neʼt benwa ye ampaꞌ isien artaꞌ ye. ");
INSERT INTO plw_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Na baꞌ maya diki lang pesakup daken, atin pegsegkaan aku. Indyari sebarang diki menabang daken menimung taaw, atin negpeparak dye. ");
INSERT INTO plw_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Angkansa pegsugiren ku dimyu, empunen mengeꞌ taaw misan enu negang keselaan bekeꞌ beres neng meraat, temed diki lang empunen sebarang penerwa dut Nakem et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Sebarang sagkaꞌ dut Yegang et Taaw atin empunen. Temed sebarang sagkaꞌ dut Nakem et Empuꞌ diki lang empunen, misan nega itueng timpu etawa misan ingyan.” ");
INSERT INTO plw_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Ipebetang myu na menunga ating kayu na baꞌ menunga buaꞌ ye, indyari ipebetangaꞌ myu gasi meyaat puuʼt kayu na baꞌ meyaat buaꞌ ye. Sabab dut buaꞌ mekilala ating puun. ");
INSERT INTO plw_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Kemyu na turubuanan et seli! Enukwan kew mekepegberes et menunungang ginis, sementaraꞌ meraat kew? Sabab baꞌ enu legtik et babaꞌ, atin gasi behanen dut seled atey. ");
INSERT INTO plw_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Menunga itueng pegebresen et menungang taaw, sabab bahaʼt kenunganan itueng seled atey ye. Meyaat pegebresen et belingkeg neng taaw, sabab baha et keyeatan itueng seled atey ye. ");
INSERT INTO plw_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Pegebresen ku dimyu, na dut Eldewʼt Pegukum, pemehelaan et taaw itueng kede beres na kaya lang keeturan neng pegsugiren dye. ");
INSERT INTO plw_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Angkansa, mekedyaring empunen et Empuꞌ keselaan mu etawa dusaen ke sigun dut dimung pegebresen.” ");
INSERT INTO plw_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Binres gasi ki Jesus et tawʼt menunulduꞌ et Keseraan bekeꞌ mengeꞌ tawʼt Pariseo, kwan, “Menunulduꞌ, mekedyari be takuꞌ pebirinan mu kami et tendaꞌ mewanan dut Empuꞌ set langit?” ");
INSERT INTO plw_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Siminambag si Jesus, “Itueng turubuanan tiban maya arat meyaat bekeꞌ diki tantu ki Empuꞌ! Penulus kew et tendaꞌ, temed lang kaya mepebiriꞌ dimyu luwas dut tendaꞌ sinupama dut neinabu ki tarus Jonas tagnaꞌ. ");
INSERT INTO plw_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Na baꞌ enukwan kebtangan i Jonas tuꞌ telung eldew bekeꞌ telung gebi dut seled beteng et tendayag, megsepantun kwantin gasi aku, itueng Yegang et Taaw, na telung eldew bekeꞌ telung gebi ne natey dut seled lugtaꞌ. ");
INSERT INTO plw_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Dut Eldew et Pegukum, tumyeg itueng tawʼt Ninibe atu dut itueng bangsa, indyari betangaʼt kedusaan, sabab negsusun dye ne et keselaan dye dut pemitua i Jonas, temed maya atue lebi negaʼt bantug ki Jonas. ");
INSERT INTO plw_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Dut atin Eldew et Pegukum, tumyeg nega Dayang et Timur atu dut bangsaʼt itue, indyari mebtangaʼt kedusaan sabab minewanan ye dut yuntuk et dunyaꞌ apang mekingeg kesesewran i Surutan Solomon tagnaꞌ. Na tantu maya atue lebing bentugen eset ki Solomon!” ");
INSERT INTO plw_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Pegkaꞌ lumiwan mawaꞌ dut sembatung taaw itueng meyaat neng diwata, itue pepepanew dut tuug naꞌ lugtaꞌ, megtutulus et mepeternan. Na baꞌ kaya itue mesbatan, ");
INSERT INTO plw_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","pegbersen yeʼt kenyeng diri, ‘Muliꞌ ku dut lelegdengan na dakeng minewanan.’ Peguliꞌ ye, mesiyekan ye na kaya lang itue sunuꞌ, melinas, bekeꞌ meselusay. ");
INSERT INTO plw_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Angkansa megpelahyun nega ya bekeꞌ mengakit nega et pitung taaw na lebing meyaat eset kenye, megseled dye, indyari tumerna ne duntin. Angkansa dut ketimpusan, lebing megyaat pengrasa et ating taaw kasga nekeuna tiꞌ. Kwantin gasi meinabu dut itueng meyaat neng turubuanan.” ");
INSERT INTO plw_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Sasat megebres nega si Jesus dut mengeꞌ taaw, diminateng kenyeng induꞌ bekeꞌ ketipusdan. Tinagey dye ne lang dut liwan sabab gay dye ya mekesudsugid. ");
INSERT INTO plw_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Indyari maya negsugid kenye, kwan, “Megtetagey induꞌ mu bekeꞌ ketipusdan mu, gay dye na mekepegtuturan dimu.” ");
INSERT INTO plw_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Pegketbes megberes si Jesus, kwan, “Sinu takuꞌ daken neng induꞌ bekeꞌ sinu-sinu takuꞌ itueng mengeꞌ ketipusdan ku?” ");
INSERT INTO plw_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Indyari, pinenulduꞌ ye kenyeng mengeꞌ pepengenaran bekeꞌ negberes kwan, “Itue dakeng induꞌ bekeꞌ ketipusdan! ");
INSERT INTO plw_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Sabab sebarang pengandel dut keirgaʼt dakeng Empuꞌ Amaꞌ dut langit, atin key induꞌ bekeꞌ ketipusdan ku.” ");
INSERT INTO plw_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Atin negang eldew, liminiwan si Jesus et benwa pegketbes narung dut abiʼt deplakan supaya menulduꞌ. ");
INSERT INTO plw_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Rinungrupungan ne ya et mekeldam neng taaw, angkansa siminakat ne lang et gubang ampaꞌ ne narung. Mengeꞌ taaw in eset deplakaʼt dagat memegtitiyeg. ");
INSERT INTO plw_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Indyari nenulduꞌ ya et mekansang neng ginisan kedye pebiyaʼt beleybeyen. Kwan i Jesus, “Maya sembatu na mengunguma nepanew apang menasad. ");
INSERT INTO plw_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Sasat ya penasad, maya pungu neregdag dut dalan. Diminateng mengeꞌ kebegitan pineninduk dye ginsan dut dalan. ");
INSERT INTO plw_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Maya gasi pungu neregdag dut kebetuan, baꞌ embe menipis lang lugtaꞌ. Sabab et menipis lang lugtaꞌ ye, timinuhuꞌ megtuy pungu in. ");
INSERT INTO plw_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Temed lang, ganang neblad et mebarad neng init et eldew netugan, sabab ye kaya nekegamut tantu. ");
INSERT INTO plw_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Maya mengeꞌ pungu gasi neregdag dut kerikutan, nemengapal rikut in, neternung ne pungu in. ");
INSERT INTO plw_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Temed mayang pungu na nesasad dut menungang lugtaꞌ in nemenupang. Maya tegsenggatus betuen, maya tegeenem neng puluꞌ, bekeꞌ tegtelumpulung betuen kede uheyen, na nemenguhey ne na neglebi nega eset nesasad in. ");
INSERT INTO plw_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Sebarang maya ikingeg, atin mengingeg.” ");
INSERT INTO plw_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Kinabiꞌ et mengeꞌ pepengenaran si Jesus na nemengingkut, kwan, “Manu angkan nega itaguꞌ mu et beleybey itueng pegsugiren mu dut mengeꞌ taaw?” ");
INSERT INTO plw_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Siminambag si Jesus, kwan, “Binggey dimyu na mesewran itueng mengeꞌ pegtaguꞌ pasal et Pengmilikaʼt Empuꞌ dut langit, temed lang diki itue ibgey kedye. ");
INSERT INTO plw_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Sabab sebarang maya ne keretian, begeyan nega kenye na meglebi-lebi. Temed sebarang kaya in, misan isek-isek mene eset kenye, isien nega kenye. ");
INSERT INTO plw_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Pegbersen ku itue kedye pebiyaʼt beleybey, sabab megsiyek dye temed lang diki dye mebiriꞌ, bekeꞌ pengingeg dye temed lang kaya pegkinggen dye etawa pegretien. ");
INSERT INTO plw_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Metuman ganaꞌ kedye itueng peneked et Empuꞌ pebiyaꞌ tarus ye si Isaias tagnaꞌ neng pegsugiren, kwan, ‘Mengingeg kew ganaꞌ neng mengingeg, diki kew gasi mekeretiꞌ. Indyari siyekan myu ganaꞌ neng siyekan, diki myu gasi mebiriꞌ. ");
INSERT INTO plw_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Sabab negmendyaring mengarel itueng pikiran et mengeꞌ taaw, meliyut mengingeg itueng kedyeng telinga, indyari pegpereng dye kedyeng mengeꞌ mata. Na baꞌ diki kwantin, teyen mekebiriꞌ itueng mengeꞌ mata dye, nekekingeg itueng telinga dye, nekeretiꞌ itueng mengeꞌ pikiran dye, indyari nengandel dye daken, pegketbes pegulinan ku dye, kwan ku neng Empuꞌ banar dut langit.’ ");
INSERT INTO plw_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Mesukud kew, sabab mekebiriꞌ itueng dimyung mengeꞌ mata, indyari mekekingeg itueng dimyung mengeꞌ telinga. ");
INSERT INTO plw_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Pegsugiren ku dimyu, mekansang tarus et Empuꞌ bekeꞌ mekansang metitignaꞌ neng taaw et Empuꞌ na gay banar mekebiriꞌ et dimyung nebiriꞌ, temed diki lang nebiriꞌ, bekeꞌ mekingeg dut dimyung nekikingeg, temed kaya lang nepekingeg.” ");
INSERT INTO plw_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Tiban kinggen myu itueng reretian et beleybey pasal et pegsasad. ");
INSERT INTO plw_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Sebarang pengingeg et beres pasal et Pengmilikaʼt Empuꞌ temed diki mekeretiꞌ samat pungu na sinasad dut dalan. Memegdateng si Seytan neng Mereraat, indyari pegegewen pinebunayag in dut seled atey dye. ");
INSERT INTO plw_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Pineantang et itueng pungu na nesasad dut kebetuan, itueng mengeꞌ pengingeg et beres et Empuꞌ bekeꞌ menep megtuy itueng menerima. ");
INSERT INTO plw_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Temed lang kaya itue megdaran dut seled atey dye, sabab kaya gamut. Indyari, pegdateng et kerupukan etawa ketiksaan sabab et beres et Empuꞌ, megtuy dye lang mengrungkey. ");
INSERT INTO plw_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Pineantang gasi eset pegsasad dut kerikutan neng megkingeg et beres et Empuꞌ, temed lang megmendyaring pememikir et mengeꞌ keginisan atueʼt lungsud, indyari meiregan et mengeꞌ kementirian, enu ga itueng beres neugad ne dut seled atey dye, angkansa kaya ne nemekebuaꞌ. ");
INSERT INTO plw_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Indyari, pineantang neng nesasad dut menunga neng lugtaꞌ itueng mengeꞌ nengingeg et Beres et Empuꞌ na nemekeretiꞌ. Nememuwat dye mekeldam. Maya tegsesenggatus, maya tegeenem neng puluꞌ, bekeꞌ maya tegtetelumpuluꞌ.” ");
INSERT INTO plw_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Tinuturan gasi i Jesus kedye pebiyaꞌ itueng beleybey, kwan, “Itueng Pengmilikaʼt Empuꞌ dut langit samat itue. Maya sembatung taaw nenasad et menunungang pungu dut uma ye. ");
INSERT INTO plw_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Sembatung gebi, sasat memegigaꞌ taaw, diminateng kebanta ye, pegketbes nenasad et meyeyaat neng ilemunen lamud et pungu dut uma ye, indyari nugad. ");
INSERT INTO plw_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ganang timinuhuꞌ itueng tirigu, nemenguhey ne, na nemenuhuꞌ ne gasi na meyeyaat neng ilemunen in. ");
INSERT INTO plw_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Angkansa nemengabiꞌ tetehagen dut begerar dye, sinugid dye ne itue, kwan, ‘Begerar, diki be takuꞌ menunungang pungu pegsasad myu dut dimyung uma? Manu segwaꞌ maya nega timinuhuꞌ ilemunen duntin?’ ");
INSERT INTO plw_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Siminambag ya, ‘Sembatung kebanta nemuwat et itue.’ Iningkut ya et mengeꞌ tetehagen, ‘Gebuten kay takuꞌ itie e?’ ");
INSERT INTO plw_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","‘Endey ne,’ sambag ye, ‘Kaluꞌ megabut sampay tirigu. ");
INSERT INTO plw_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pesariꞌ myu seked memengdeklaꞌ seꞌsaliꞌ seked na mekeyg. Pegkeyg, sugiran ku mengengeyg na timungaꞌ myu mena ilemunen, pegketbes pegbegkes-begkesen apang tutungen, indyari mengeꞌ tirigu in timungaꞌ myu ne dut legkew ku tiꞌ.’ ” ");
INSERT INTO plw_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Sembatu gasi neng beleybey na tinuturan i Jesus kedye. Kwan ye, “Itueng Pengmilikan et Empuꞌ dut langit samat kwantin. Maya sembatung taaw nengluwak et sengelinseg et mustasa dut kenyeng uma. ");
INSERT INTO plw_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Pinekemerinek itue dut ginsan neng elinseg, segwaꞌ baꞌ itue neluwak ne bekeꞌ dimineklaꞌ, pegmendyaring pinekemereklang puun dut ginsan neng luluwaken. Itue pegmendyaring puuʼt kayu, sengmenu ye, megdateng duun mengeꞌ begit et lelengew supaya mekepugaran nega eset mengeꞌ sanga in.” ");
INSERT INTO plw_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Nenuturan nega si Jesus et leing beleybey. Kwan ye, “Itueng Pengmilikan et Empuꞌ dut langit samat pikembang na peglamud et sembatung libun dut telung susukuran et arina, indyari kiminansang ne bekeꞌ dimineklaꞌ ginsan.” ");
INSERT INTO plw_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Pegbersen i Jesus dut mengeꞌ taaw itueng ginsan pebiyaʼt mengeꞌ beleybey, indyari kaya ye pegsugiren dut kedye baꞌ diki usalan ye et beleybey. ");
INSERT INTO plw_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Binwat ye itue apang metuman itueng pegsugiren et Empuꞌ pebiyaꞌ tarus ye, kwan, “Menuturan ku kedye pebiyaꞌ et mengeꞌ beleybeyen. Ipebunayag ku kedye itueng mengeꞌ kebenaran ne kaya nesewran et taaw mewanan nega dut buwaten itueng kedunyaan.” ");
INSERT INTO plw_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Pegketbes tinirengan ne i Jesus itueng mengeꞌ taaw ampaꞌ ne siminled dut benwa. Nepekabiꞌ kenyeng mengeꞌ pepengenaran na nengingkut kenye, kwan dye, “Iperetiaꞌ be damen itueng beleybey pasal et meyaat neng ilemunen dut uma.” ");
INSERT INTO plw_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Itue sinambag i Jesus kedye, kwan, “Ating sembatu na nenasad et menungang pungu, atin aku neng Yegang et Taaw. ");
INSERT INTO plw_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Itueng uma tuꞌ, atin ne kedunyaan. Sebarang mengeꞌ taaw na pegmilikan et Empuꞌ, atin ne menungang pungu. Indyari sebarang mengeꞌ taaw na pegmilikan i Seytan, atin ne meyeyaat neng ilemunen. ");
INSERT INTO plw_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Naꞌ ating kebanta na nenasad et kwantin, kaya ne sumaliꞌ baꞌ diki si Seytan. Itueng pegkekeyg atin ne ketimpusan et dunyaꞌ, indyari itueng mengeꞌ megpebilinaʼt Empuꞌ, atin ne mengengeyg. ");
INSERT INTO plw_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Na baꞌ enukwan pegtimungen itueng ilemunen pegketbes tutungen, megsepantun kwantin gasi meinabu dut ketimpusaʼt dunyaꞌ. ");
INSERT INTO plw_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Atin masa, tehagen ku neng Yegang et Taaw mengeꞌ dereakan ku, indyari timungen dye mewanan dut pegmilikan ku et itueng ginsan na negmendyaring sebaban et keselaan dut sebayaꞌ dye, bekeꞌ ginsan na megpemuwat et meraat. ");
INSERT INTO plw_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Indyari ipesbur dut megbebaga neng apuy. Duntin dye ne na megsiyak bekeꞌ megringetnget kedyeng mengeꞌ nipen. ");
INSERT INTO plw_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Indyari tumlang samat eldew itueng mengeꞌ metitignaꞌ na taaw dut Pengmilikaʼt kedyeng Empuꞌ. Sebarang maya ikingeg, atin mengingeg!” ");
INSERT INTO plw_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Itueng Pegmilikaʼt Empuꞌ dut langit, antangan ye samat kementirian na limbeng dut sembatung uma. Nekali et sembatung taaw, pegketbes tinimbunan ye peuliꞌ. Dut deklaʼt enep, nanew ya, indyari pinegelen ye ginsan neng pengartaꞌ ye, pegketbes inlen ye ne atin neng uma.” ");
INSERT INTO plw_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Megsepantun kwantin gasi, itueng Pengmilikan et Empuꞌ dut langit, atin samat sembatung taaw megtutulus et mergang buligaꞌ. ");
INSERT INTO plw_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ganang neketulus neʼt sembatung buligaꞌ neng pinekemergaꞌ, ya in nuliꞌ ne, pegketbes pineelen ye ginsan neng pengartaꞌ ye, indyari inlen ye ne buligaꞌ tiꞌ.” ");
INSERT INTO plw_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Indyari negtuturan nega si Jesus et sembatung beleybey, kwan ye, “Itueng Pengmilikan et Empuꞌ dut langit, megsepantun gasi et sembatung melekbang neng rambat na tinaan dut dagat, indyari nekeisiꞌ et lein-leing ginisan et seraꞌ. ");
INSERT INTO plw_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ganang nebaha ne, rinayak ne dut deplakan. Indyari nemengarung itueng mengeꞌ taaw apang tingtimungen ne itueng seraꞌ. Sinunuꞌ dye dut susunuan itueng mengeꞌ menununga, segwaꞌ sebarang meyeyaat in pinenimbag ne. ");
INSERT INTO plw_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Kwantin gasi meinabu dut ketbesan et dunyaꞌ. Dumateng mengeꞌ dereakan et Empuꞌ, seririen mengeꞌ taaw neng negkesalaꞌ bekeꞌ mengeꞌ taaw neng metitignaꞌ. ");
INSERT INTO plw_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Indyari ipesbur ne itueng mengeꞌ mekesesalaꞌ tiꞌ dut megbebaga neng apuy. Duntin memeniyak dye bekeꞌ megriringetnget kedyeng nipen.” ");
INSERT INTO plw_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“Neretian myu ne be takuꞌ itueng ginsan?” ingkut i Jesus kedye. “Eꞌ be,” sambag dye. ");
INSERT INTO plw_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Indyari sinugid ye kedye, kwan, “Angkansa pesi, kede menunulduꞌ et Keseraan na mengandel et Empuꞌ bekeꞌ kenyeng Pegmilik dut langit, atin samat sembatung empuꞌ et benwa na pengisiꞌ et mengeꞌ menungang ginisan na bagu bekeꞌ lelagi dut kenyeng teteguan.” ");
INSERT INTO plw_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ganang netbes ne i Jesus negtuturan et itueng mengeꞌ beleybeyen, nugad ne ya duntin. ");
INSERT INTO plw_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Nuliꞌ ne ya dut lungsud ye. Menulduꞌ ya dut kedyeng Pengempuan naꞌ Benwa, tingkageʼt sinagoga. Nemegliꞌliluꞌ sebarang nekekingeg kenye. Kwan dye, “Embe takuꞌ neisian ye et kesesewran neng itueng taaw tuꞌ? Enukwan takuꞌ ya mekepemuwat et mengeꞌ keliꞌliluꞌ? ");
INSERT INTO plw_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Diki be takuꞌ yegang itue et mememaal et benwa? Diki be takuꞌ si Maria kenyeng induꞌ? Bekeꞌ de Jakob, Jose, Simon, bekeꞌ si Judas na kenyeng mengeꞌ ketipusdan neng mengeꞌ kelelekian? ");
INSERT INTO plw_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Indyari ginsaʼt kenyeng mengeꞌ ketipusdang kelilibunan pegeeldengan dye atue, diki be? Embe takuꞌ nesewran ye itueng ginsan?” ");
INSERT INTO plw_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Pegketbes negkesimbakud dye dut kenye, sampay negmendinan pengandel kenye. Angkansa sinugid i Jesus kedye, “Itueng tarus pegintetewen misan embe, luwas lang eset kenyeng diring peglulungsuran bekeꞌ dut kenyeng diring mengeꞌ binenwa.” ");
INSERT INTO plw_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Indyari, sabab et diki dye mengandel, diki ya memuwat duntin et mekansang neng keliꞌliluꞌ. ");
INSERT INTO plw_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Atin masa si Surutan Herodes et Galilea nekingeg ye itueng abar pasal ki Jesus. ");
INSERT INTO plw_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Bineres i Herodes dut kenyeng mengeꞌ ketabang, kwan, “Itueng si Jesus, ya in si Juan neng Mememewtismu na negbiyag peuliꞌ, angkansa nekepemuwat et mengeꞌ keliꞌliluꞌ!” ");
INSERT INTO plw_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Nekeuna tiꞌ, negtahag si Surutan Herodes ne negpeleew, negpepungpung bekeꞌ negpepirisu ki Juan. Punsabab ye ki Herodias neng esawa et tipused yeng si Pelipe. ");
INSERT INTO plw_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Daran pegbersen i Juan neng Mememewtismu si Surutan Herodes, kwan, “Mesewala dut Empuꞌ baꞌ megbeꞌbayaꞌ kew et esawaʼt tipused mu.” ");
INSERT INTO plw_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Gay i Surutan Herodes na ipepatey si Juan, temed lang megtakut ya dut mengeꞌ tawʼt Judio, sabab pegkilelanen dye na tarus et Empuꞌ si Juan neng Mememewtismu. ");
INSERT INTO plw_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ganang diminateng eldewʼt pinenggenakan ki Surutan Herodes, negbeyli eset elepan et ginsaʼt mengeꞌ taaw yegang neng libun i Herodias. Nesegyaan banar si Surutan Herodes. ");
INSERT INTO plw_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Angkansa nengibet ya na igbey ye misan enung geayen ye in. ");
INSERT INTO plw_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Penahag et induꞌ in atin ne binres et budyang tiꞌ, kwan, “Igbeyaꞌ daken tiban nega, na ulu i Juan neng Mememewtismu pereratun eset rayaꞌ!” ");
INSERT INTO plw_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nekerupuk itueng surutan, segwaꞌ sabab et kenyeng netangeꞌ na nekingeg et mengeꞌ mengungumbaley ye bekeꞌ ibang mengeꞌ taaw esentin, tinehagan na igbey itueng pegengaten dut budyang. ");
INSERT INTO plw_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Angkansa pineputekan yeʼt ulu si Juan dut seled pipirisuan. ");
INSERT INTO plw_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Dinatun ulu dut sembatung rayaꞌ ampaꞌ ne binggey dut budyang tiꞌ, indyari binggey gasi et budyang dut induꞌ ye tiꞌ. ");
INSERT INTO plw_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Diminateng itueng mengeꞌ pepengenaran i Juan. Insiꞌ dye kenyeng bangkay ampaꞌ ne limbeng. Pegketbes siminurung dye ki Jesus, ampaꞌ dye ne tinuturan neinabu. ");
INSERT INTO plw_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ganang nesewran ne i Jesus itueng abar pasal ki Juan, siminakat ya et sembatung gubang, yaya ye lang siminurung dut merayung lungsud. Ganang neebaran gasi atin et mengeꞌ taaw, nugad dye mengeꞌ lungsud dye supaya nememanew dye gasi apang sumunud ki Jesus. ");
INSERT INTO plw_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Pegdungguꞌ i Jesus dut deplakaʼt dagat, nebiriꞌ ye mekeldam neng taaw. Nekeingasiꞌ ya kedye, indyari pinegulinan ye itueng mengeꞌ peginglewen ne pegbibiten dye. ");
INSERT INTO plw_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ganang megerisarem ne, kiminabiꞌ kenye mengeꞌ pepengenaran ye. Sinugid dye, kwan, “Kelnangan itueng lungsud, bekeꞌ iba mekabiꞌ ne sumdep eldew. Penugiriꞌ ne mengeꞌ taaw na sumurung dye mena dut mengeꞌ ketinda-tindaan apang mekeelen dye et kedyeng mekaan.” ");
INSERT INTO plw_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","“Diki ne keilangan mugad dye nega,” negsugid si Jesus, kwan, “Kemyu menggey kedye et kekanen!” ");
INSERT INTO plw_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Siminambag dye, “Ganang lilima bengbang bekeꞌ duruwa tinepaan seraꞌ atue.” ");
INSERT INTO plw_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","“Bitaꞌ myu atue daken,” kwan i Jesus. ");
INSERT INTO plw_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Pinearung ye dut keberirian itueng mengeꞌ taaw, insiꞌ ye limang bengbang in bekeꞌ duwang seraꞌ tiꞌ, timiningaraꞌ ya dut langit, indyari negpeselamat dut Empuꞌ. Pinegbisbitas ye mengeꞌ bengbang in, pegketbes tinehagan ye dut pepengenaran ye na ipemgey ne atin dut mengeꞌ taaw. ");
INSERT INTO plw_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Pinekaan dye ginsan seked na pinemyagan. Tinimung et mengeꞌ pepengenaran neglebi in, indyari nebehanan dye nega sempuluꞌ duwang tabig neng pinegbisbitas neng bengbang bekeꞌ seraꞌ. ");
INSERT INTO plw_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Mayang limang ribu keldamen kelelekian na nemekekaan, seririꞌ gasi kelilibunan bekeꞌ keyegangan ne. ");
INSERT INTO plw_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Indyari pinesakat i Jesus dut gubang kenyeng mengeꞌ pepengenaran, indyari pineuna dye dut sembelang dipag et dagat, sementaraꞌ pineuliꞌ ye ne mengeꞌ taaw in. ");
INSERT INTO plw_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Pagkaꞌ nepeugad ye et mengeꞌ kineldaman, siminurung ne yaya ye dut mepedpetud apang megpenelang. Yaya ye ga seked gebi duntin. ");
INSERT INTO plw_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Sementaraꞌ, sabab et pesungsang deres in, gubang dut lawed tiꞌ pegtumpilan neʼt gumbang. ");
INSERT INTO plw_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ganang kueldew ne, liminundug ne kedye si Jesus na megpepanew dut timbewʼt danum. ");
INSERT INTO plw_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Inirebutan dye neʼt takut itueng mengeꞌ pepengenaran, ganang nebiriꞌ dye na maya taaw megpepanew dut timbewʼt danum. Kwan dye, “Endelimew!” Gerwak ginsan beres dye sabab et takut. ");
INSERT INTO plw_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Segwaꞌ megtuy lang si Jesus neres bekeꞌ negsugid kedye, “Kas kew takut, si Jesus itue!” ");
INSERT INTO plw_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Indyari negberes si Pedro, kwan, “Begerar, na baꞌ kebenaran ikew ne atin, pesentinaꞌ mu aku dut timbewʼt danum eset dimu in.” ");
INSERT INTO plw_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Siminambag si Jesus, kwan, “Aniꞌ ke.” Angkansa nineug si Pedro dut gubang ampaꞌ ne nanew dut timbewʼt danum, pesurung ki Jesus. ");
INSERT INTO plw_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Temed ganang meresanan ye deres, timinakut ya bekeꞌ tumagnaꞌ ne melneb. “Bewinaꞌ mu aku, Begerar!” tingkag ye. ");
INSERT INTO plw_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Megtuy kintang i Jesus keremut ye ampaꞌ ye ne binatun si Pedro. Binres ye ki Pedro, “Merinek pelan pengandel mu! Manu takuꞌ angkan pegalang-alang ke?” ");
INSERT INTO plw_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Pegkesakat dye dut gubang, megtuy timingew deres. ");
INSERT INTO plw_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Indyari, pinengempuꞌ ne ya et mengeꞌ taaw na megsesakat et gubang in. Kwan dye, “Tantu banar na ikew ne tuꞌ Yegang et Empuꞌ!” ");
INSERT INTO plw_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Diminipag dyeʼt dagat, pegketbes diminungguꞌ dut lungsud et Genesaret. ");
INSERT INTO plw_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Nekilala dye si Jesus dut mengeꞌ taaw duntin. Megtuy dye pineabar dut ginsang pelilibut dut atin neng lungsud na diminateng ne si Jesus, angkansa binibit dye kenye ginsang meinglew. ");
INSERT INTO plw_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Pegtewen dye kenye na ipekutew ye teyen misan reped meneʼt badyuꞌ ye. Indyari ginsan neng kekpet megulinan. ");
INSERT INTO plw_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Kasa maya kiminabiꞌ ki Jesus mengeꞌ senung mengeꞌ Pariseo bekeꞌ mengeꞌ menunulduꞌ et Keseraan mewanan et lungsud et Jerusalem. Kedyeng iningkut ya, ");
INSERT INTO plw_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Manu angkan takuꞌ pegsegkaan et mengeꞌ pepengenaran mu itueng penulduꞌ na pinusakaꞌ tyu dut kityung kegungurangan? Pemengaan dye na misan kaya pememasaʼt keremut mura mengaan kuyun dut Keseraan!” ");
INSERT INTO plw_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Sinambag dye i Jesus, kwan, “Manu gasi takuꞌ pegsegkaan myu itueng Keseraan et Empuꞌ sabab et pinusakaꞌ myung netulduꞌ? ");
INSERT INTO plw_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Keseraan et Empuꞌ, ‘Untebiaꞌ myu dimyung amaꞌ bekeꞌ induꞌ.’ Sampay nesurat, ‘Indyari sebarang menerwa dut amaꞌ bekeꞌ eset induꞌ, atin subaliꞌ ipeimatey.’ ");
INSERT INTO plw_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Segwaꞌ pegtulduꞌ myu, kwan na baꞌ pegsugid et sembatung taaw dut kenyeng amaꞌ bekeꞌ induꞌ, kwan ye, ‘Diki mekedyari ku metabang dimyu, sabab ginsaʼt artaꞌ ku binggey ku ne dut Empuꞌ.’ ");
INSERT INTO plw_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Kwan myu na diki ne keilangan na untebien ye kenyeng megurang. Punsabab dut nepusakaꞌ myung penulduꞌ, pegugaran myuʼt kepulusan itueng beres et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Kemyung mengeꞌ pebiꞌbiriꞌ! Metugnaꞌ itueng peneked teyeg Empuꞌ pebiyaꞌ kenyeng tarus si Isaias pasal dimyu tuꞌ, ");
INSERT INTO plw_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Peginturen dye ipelamak dut daken dut beres lang, na pebiꞌbiriꞌ lang, temed mengeꞌ atey dye merayuꞌ set daken. ");
INSERT INTO plw_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Pegbantug, pegempuꞌ, pegbaalen dye daken na kaya kepulusan. Sabab atin penulduꞌ dye samat Keseraan et Empuꞌ na negpependyari, temed atin Keseraan et taaw lang.’ ” ");
INSERT INTO plw_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Pinekabiꞌ i Jesus dut kenye itueng mengeꞌ taaw bekeꞌ kenyeng sinugid, “Kumingeg kew ginsan, indyari retien itueng dakeng bersen. ");
INSERT INTO plw_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Lein lang inyet megseled et babaꞌ et taaw, baꞌ diki inyet megliwan na mekepegperaki dut kenye eset mata et Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Kiminabiꞌ itueng mengeꞌ pepengenaran bekeꞌ kedyeng binres, kwan, “Sewd mu, nenedseled itueng mengeꞌ Pariseo dut bineres mu?” ");
INSERT INTO plw_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Siminambag si Jesus, kwan, “Penggebuten itueng kede luluwaken na lein lang linuwak et amaꞌ ku dut langit. ");
INSERT INTO plw_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Pesariꞌ myu ne lang dye in. Dye ne samat mengeꞌ beleg na mengdurundun. Na baꞌ sembatung beleg dumundun dut ibang beleg, atin seꞌsaliꞌ dye meregdag dut kinelian.” ");
INSERT INTO plw_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Sinugid kenye i Pedro, kwan, “Iperetiaꞌ damen itueng beleybey.” ");
INSERT INTO plw_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Indyari binres dye i Jesus, kwan, “Kemyu be tuꞌ takuꞌ kaya gasi mekeretiꞌ? ");
INSERT INTO plw_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Kaya be takuꞌ mekesewran myu na misan enung isubuꞌ myu dut babaꞌ pemeglahyun dut beteng, pegketbes ipegtei? ");
INSERT INTO plw_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Segwaꞌ ating megliwan dut babaꞌ pegmewanan ye seled atey, indyari itue ne megpeyaat dut taaw. ");
INSERT INTO plw_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Semeketuwid dut seled atey pegmewanan et mereraat neng pikiran, samat pegpatey, mengulid et leing esawa, lein-leing meyaat neng buwaten, menakew, menembut, bekeꞌ menaksiꞌ et kaya keberbenaran dut kesebeyaan. ");
INSERT INTO plw_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Atin ne megperaat et mengeꞌ taaw. Segwaꞌ baꞌ ganang mengaan ke na diki lang mekebasaꞌ et keremut dut nepusakang penulduꞌ, diki atin mekeperaat et taaw.” ");
INSERT INTO plw_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Nugad ne duntin si Jesus, siminurung dut kelungsuran na mekabiꞌ dut lungsud et Tiro bekeꞌ lungsud et Sidon. ");
INSERT INTO plw_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kiminabiꞌ dut kenye sembatung libun tawʼt Kananeo na meglelegdeng duntin, pegketbes mebasag na negberes, kwan, “Begerar, upuꞌ i Surutan Dabid, meingasiꞌ ke daken! Daken neng yegang naꞌ libun sinelban et diwata i Seytan, mekeliyutan ne ya banar.” ");
INSERT INTO plw_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Segwaꞌ misan senglegtik kaya lang neres si Jesus, sabab tawʼt tumpang ye bekeꞌ lein tawʼt Judio. Indyari kiminabiꞌ kenyeng mengeꞌ pepengenaran, na negberes kenye, “Uruiꞌ myu ne apang keugad ne. Megibek ya banar bekeꞌ megsusunud lang kityu.” ");
INSERT INTO plw_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Siminambag si Jesus, kwan, “Aku dinaak et Empuꞌ dut mengeꞌ taaw et bangsa neng Israel ga, antangen dye bibili neng pegeelamen.” ");
INSERT INTO plw_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Segwaꞌ kiminabiꞌ eset kenye itueng libun, siminelukud eset elepan, indyari negberes, kwan, “Tebangaꞌ ku, Begerar!” ");
INSERT INTO plw_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Siminambag si Jesus, kwan, “Diki merapat isien itueng pegkaan et mengeꞌ keyegangan apang yumpen dut mengeꞌ keireng-irengan.” ");
INSERT INTO plw_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Kwan et libun in, “Tantu banar, Begerar ku, segwaꞌ itueng mengeꞌ keireng-irengan memegkekaan nega et mumuꞌ na mekeregdag dut datag et kedyeng pegibuten.” ");
INSERT INTO plw_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Angkansa sinugid kenye i Jesus, “Kelaꞌ pelan dimung pegandel dut Empuꞌ! Metuman itueng pegtewen mu.” Indyari atin negang masa megtuy negnunga itueng kenyeng yegang. ");
INSERT INTO plw_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Pegugad duntin, negpeuliꞌ si Jesus dut abiʼt dagat et Galilea. Indyari ya in timinungul dut pedpetud ampaꞌ ne narung duntin. ");
INSERT INTO plw_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Negdetengan mekeldam banar neng taaw na maya megbebayaꞌ mengeꞌ pangkul, beleg, suwiꞌ lengen, umew, bekeꞌ mekansang nega ibang reresanen. Pinearung dye meiinglew in dut elepan i Jesus pegketbes pinegulinan ne dye in. ");
INSERT INTO plw_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nedingkelatan mengeꞌ taaw ganang nebiriꞌ dye na mekebres ne itueng umew, negulinan ne mengeꞌ suwiꞌ lengen etawa paa, mekepanew ne itueng mengeꞌ pangkul, indyari mekebiriꞌ ne itueng mengeꞌ beleg. Pegketbes negbantug dye dut Empuꞌ itueng mengeꞌ tawʼt Israel. ");
INSERT INTO plw_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Tinimung i Jesus kenyeng mengeꞌ pepengenaran, indyari kwan, “Mekeingasiꞌ ku atueʼt mengeꞌ taaw sabab telung eldew ne tiban kebayaꞌ ku dye, na kaya mekaan dye. Diki gaay ku na ipeuliꞌ ku dyeʼt pemegurapan, kaluꞌ lang liglinugen dye dut dalan.” ");
INSERT INTO plw_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Indyari negberes mengeꞌ pepengenaran, “Embe takuꞌ meisian tyu atueʼt kelnangan et kekanen na meketeped et kwantin kensangen et mengeꞌ taaw?” ");
INSERT INTO plw_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ingkut i Jesus kedye, “Naꞌ senu bengbang myu esentin?” “Pitu ga be,” sambag dye. “Bekeꞌ maya gasi mengeꞌ derinekan neng tinepaan seraꞌ atue.” ");
INSERT INTO plw_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Itueng mengeꞌ taaw pinearung ne i Jesus eset lugtaꞌ. ");
INSERT INTO plw_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Insiꞌ ye ne pitu neng bengbang bekeꞌ tinepaan seraꞌ in pegketbes negpeselamat ne dut Empuꞌ. Pegketbes pinegtektahak, pinegbisbitas ye ne atin, ampaꞌ ne binggey ye dut mengeꞌ pepengenaran ye apang ipemgey ne dut taaw. ");
INSERT INTO plw_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nemekekaan ginsan seked binyagan. Indyari ganang pinenimung et mengeꞌ pepengenaran ye ne neglebi in, nekebaha nega et pitung tabig. ");
INSERT INTO plw_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Maya epat neng ribung lelaki na nemekekaan, seridiꞌ gasi mengeꞌ kelilibunan bekeꞌ keyegangan in. ");
INSERT INTO plw_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Atin peꞌ pinepeuliꞌ ne i Jesus mengeꞌ taaw in, mura ne ya siminakat et gubang, indyari neglahyun ne dut kelungsuran et Magadan. ");
INSERT INTO plw_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Kiminabiꞌ ki Jesus itueng mengeꞌ senung taaw na Pariseo bekeꞌ Saduseo. Gaay dye na mealew ya, angkansa pegtewen dye na megpebiriꞌ ya et tendaꞌ mewanan dut Empuꞌ dut langit, supaya mesewran dye na ya dinaak et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Segwaꞌ timinubag si Jesus, kwan, “Dut megerisarem ne pegsugiren myu, ‘Megmendyaring menunga timpu diklem sabab meregang itueng langit.’ ");
INSERT INTO plw_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Indyari dut kukueldew pegsugiren myu, ‘Dumlek tiban, sabab meitem bekeꞌ mekunem langit.’ Mekesewran myu itueng tendaꞌ dut langit, segwaꞌ diki myu mesewran et mengeꞌ tendaꞌ binggey et Empuꞌ dimyu pasal et megderateng neng timpu. ");
INSERT INTO plw_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Teribuanan neng mereraat bekeꞌ kaya tantu dut Empuꞌ! Megpenulus kew et tendaꞌ, segwaꞌ kaya mepebiriꞌ dimyu selyu ganang tendaꞌ na neinabu ki Jonas tagnaꞌ tiꞌ!” Indyari pegketbes ga in, tinirengan ye dye bekeꞌ nugad ne ya. ");
INSERT INTO plw_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ganang nemekeripag ne dut sembelaꞌ itueng mengeꞌ pepengenaran, nelipatan dye nemibit et bengbang. ");
INSERT INTO plw_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Sinugid i Jesus kedye, kwan, “Meginget kew eset pikembang et mengeꞌ pariꞌ na Pariseo bekeꞌ pariꞌ na Saduseo.” ");
INSERT INTO plw_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Nemegbesberes ne itueng mengeꞌ pepengenaran, kwan dye, “Punsabab et kaya pegbibiten tyu bengbang, angkansa neres ya et kwantin.” ");
INSERT INTO plw_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Pegsesewren itue i Jesus, angkansa dye in pinengingkut ye, kwan, “Manu angkan takuꞌ pegtetekeren myu na kaya lang meglulutuꞌ et bengbang? Sengkerit ga pelan dimyung pegandel! ");
INSERT INTO plw_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Kayangga peꞌ takuꞌ mekeretiꞌ kew? Nelipatan myu ne be takuꞌ na pinegrekrepik ku neng limang bengbang in dut limang ribu neng lelaki, senung tabig et bengbang nega neglebi? ");
INSERT INTO plw_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Megsepantun kwantin gasi dut pitung bengbang bekeꞌ dut epat neng ribu neng lelaki? Bekeꞌ senung tabig nega neglebi? ");
INSERT INTO plw_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Manu takuꞌ angkan diki myu meretian na lein lang tudyu dut bengbang itueng pegsugiren ku dimyu? Meginget kew dut pikembang et mengeꞌ pariꞌ na Pariseo bekeꞌ Saduseo.” ");
INSERT INTO plw_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Indyari neretian dye ne na keilangan pelan meginget dye dut penulduꞌ et mengeꞌ pariꞌ na Pariseo bekeꞌ Saduseo, bekeꞌ lein lang pelan dut pikembang na pegusalen dut bengbang tiꞌ. ");
INSERT INTO plw_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ganang diminateng si Jesus dut kelungsuran mekabiꞌ lungsud et Sesarea dut probinsiya et Pilipos, iningkut ye itueng kenyeng mengeꞌ pepengenaran, kwan ye, “Sinu kunuꞌ aku, itueng ‘Yegang et Taaw’, sigun dut mengeꞌ taaw?” ");
INSERT INTO plw_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Indyari siminambag dye, “Pegsugiren et mengeꞌ iba in, si Juan neng Mememewtismu kew kunuꞌ. Pegsugiren gasi et iba tiꞌ, si Elias kew gasi kunuꞌ. Indyari, maya gasi pegsugid ikew tuꞌ si Jeremias etawa sembatu kew neng tarus et Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","“Kemyu gasi, enu mesugid myu? Sinu takuꞌ aku tuꞌ?” ingkut ye kedye. ");
INSERT INTO plw_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Siminambag si Simon Pedro, kwan, “Ikew ne si Kristo, na Yegang et Empuꞌ biyag kaya seskeran.” ");
INSERT INTO plw_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Negberes kenye si Jesus, kwan, “Mesukud ke, Simon, na yegang i Jonas! Sabab itueng keberbenaran, diki lang pinebunayag dimu dut misan sinung taaw, baꞌ diki dut daken neng Amaꞌ naꞌ Empuꞌ dut langit. ");
INSERT INTO plw_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Indyari Simon, ingeranan ku ikew et Pedro, na gay bersen batu. Indyari, dut timbewʼt batu ku ne itue ipetiyeg daken neng pegtitimungan et mengeꞌ mengengandel daken, naꞌ diki lang mekeraag kenye misan kepengdyarian et kepeteyan. Na antangan mu samat ating batu. ");
INSERT INTO plw_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ibgey ku dimu itueng kepengdyarian teyeg et Pegmilikaʼt Empuꞌ dut langit. Sebarang ipeglaang mu atueʼt lugtaꞌ, atin mengeꞌ ginis ipineglaang ne gasi et Empuꞌ dut langit, bekeꞌ sebarang itugut mu atueʼt lugtaꞌ, atin mengeꞌ ginis ipinegtugut ne gasi et Empuꞌ dut langit.” ");
INSERT INTO plw_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Pegketbes pineamay-amayan ye pemilinan kenyeng mengeꞌ pepengenaran na dyangan lang ipenugid dut misan sinu na ya ne in si Kristo. ");
INSERT INTO plw_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tinegnanan atin neng masa, pegpesewd ne i Jesus dut kenyeng mengeꞌ pepengenaran, kwan ye, “Na subaliꞌ ne aku sumurung dut lungsud et Jerusalem bekeꞌ menandal et mekansang neng keliyutan dut seled kepetan et kegunggurangan et lungsud, dut mengeꞌ pegibuten et mengeꞌ pariꞌ, bekeꞌ mengeꞌ menunulduꞌ et Keseraan. Indyari kedyeng ipepatey ne aku. Segwaꞌ dut iketlung eldew aku ipebiyag nega peuliꞌ et Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ginayat ya i Pedro dut iged-iged na tinegnaan ye ne tembagan ya et kwantin, kwan ye, “Begerar, dyangan teyen itugut et Empuꞌ! Diki merapat meinabu itue dimu.” ");
INSERT INTO plw_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Tineyma i Jesus si Pedro, na binresan ya, kwan, “Kasiꞌ iberesaꞌ daken mengeꞌ beres i Seytan in. Sagkaꞌ ke dut bebyaan ku. Itueng pegpipikiren mu diki lang teyeg dut Empuꞌ, erapun teyeg dut taaw key.” ");
INSERT INTO plw_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Bineres i Jesus dut kenyeng mengeꞌ pepengenaran, “Na baꞌ sinu megaay sumunud daken, lipatan ye tudyu dut kenyeng diri, antangan, pesanen kenyeng krus neng keliyutan, bekeꞌ mayaꞌ ne daken. ");
INSERT INTO plw_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Sebarang pemikir et kebewiaʼt kenyeng biyag, atin melepasan. Segwaꞌ itueng megulmat et kenyeng biyag alang-alang dut daken, atin key keterima biyag kaya seskeran. ");
INSERT INTO plw_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Enu takuꞌ selus meisiꞌisiꞌ et sembatung taaw, meterima ye ganaꞌ sengkedunyaan, na baꞌ sambiꞌ in kenyeng biyag? Etawa enu gasi meganti et taaw apang meisiꞌ peuliꞌ kurudua ye? ");
INSERT INTO plw_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Sabab megderateng aku neng Yegang et Taaw na megbibibit kelang kepengdyarian et Empuꞌ Amaꞌ ku bekeꞌ kebayaꞌ mengeꞌ dereakan ku. Dut atin neng timpu gentian ku kede taaw, kuyun dut kenyeng nebuwat. ");
INSERT INTO plw_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Pegsugiren ku dimyu, maya senu dimyu atue na diki lang matey seked diki ye mebiriꞌ aku, ating Yegang et Taaw na megderateng samat sembatu neng Surutan supaya pemegbeg.” ");
INSERT INTO plw_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nekelabay enem neng eldew, pinebayaꞌ i Jesus si Pedro, bekeꞌ itueng megtipused na de Jakob bekeꞌ si Juan, indyari dye in nemenungul dut sembatung mebukid ne banar. Kaya ibang taaw duun. ");
INSERT INTO plw_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Sasat duntin dye ne in, nebiriꞌ dye na negpinda dagbes i Jesus. Timinlang na samat eldew kenyeng rupa, bekeꞌ nemutiꞌ samat megserinew kenyeng badyuꞌ. ");
INSERT INTO plw_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Atin mene pegrasa dye neng telung pepengenaran de Moises bekeꞌ Elias na pemegsudsugid dye ne ki Jesus. ");
INSERT INTO plw_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Angkansa negberes si Pedro ki Jesus, “Begerar, menunga nega atuꞌ tyu ne lang. Baꞌ gay myu, memaal ku et telung tetluan, sembatu dimu, sembatu ki Moises, indyari sembatu in ki Elias.” ");
INSERT INTO plw_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Sasat megebres nega ya, nekelungan dyeʼt mesingkar na kunem. Indyari, mewanaʼt kunem esentin maya pengluluwaan na negberes, “Itue daken neng pegmerganeng Yegang, tantu na mekeseraan ku kenye. Endelaꞌ myu baꞌ enu sugiren ye!” ");
INSERT INTO plw_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nemeketakut itueng mengeꞌ pepengenaran ganang nekingeg dye itieng pegluluwaan, ampaꞌ dye ne nepekleb dut lugtaꞌ. ");
INSERT INTO plw_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Segwaꞌ kinebiyan dye i Jesus ampaꞌ dye ne kinutew. “Teyeg kew,” kwan ye, “Kas kew takut!” ");
INSERT INTO plw_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Indyari ganang petingaraꞌ dye ne siminyek dye ne in kaya nebiriꞌ dye, bugtung si Jesus ga. ");
INSERT INTO plw_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Pegketbes, sasat megiineug dye net bukid, sinugiran dye i Jesus, “Dyangan lang ipenugid myu dut misan sinu ating neperenta seked ingga peꞌ negbiyag peuliꞌ aku neng Yegang et Taaw teyeg et kepeteyan.” ");
INSERT INTO plw_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Iningkut si Jesus et mengeꞌ pepengenaran, “Manu angkan takuꞌ pegbersen et mengeꞌ menunulduꞌ et Keseraan na subaliꞌ matuꞌ mena si Elias supaya ipanyap ginsan dut si Kristo neng Mesias?” ");
INSERT INTO plw_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Siminambag i Jesus, kwan, “Megeatuꞌ pesi si Elias meuna apang penyapen ginsan neng keginisan. ");
INSERT INTO plw_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Segwa, pegsugiren ku ne dimyu natuꞌ ne si Elias, segwaꞌ kaya lang ya mekekilala et taaw. Indyari kedyeng binwat kenye inyet gay dye in. Megsepantun kwantin gasi, peliyutan dye nega aku, itueng Yegang et Taaw.” ");
INSERT INTO plw_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Indyari, neretian neʼt mengeꞌ pepengenaran na si Juan neng Mememewtismu tiꞌ pegtutudyuen ye. ");
INSERT INTO plw_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Pegpeuliꞌ dye tuꞌ maya neretengan dye mekansang neng taaw. Kiminabiꞌ sembatung lelaki ki Jesus, siminelukud dut elepan ye, kwan, ");
INSERT INTO plw_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Begerar, meingasiꞌ kew ne eset yegang ku neng lelaki! Ya tuꞌ mekelpusan net keliyutan baꞌ detengan, sabab daran ya mekegbaꞌ dut apuy etawa meregdag dut danum. ");
INSERT INTO plw_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Pineuruan ku ne ya dut pepengenaran mu, segwaꞌ lang kaya mekepegulinan dye.” ");
INSERT INTO plw_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Siminambag si Jesus, kwan, “Turubuanan et kaya pemengandel bekeꞌ mektul ulu! Seked ingyan na aku tuꞌ dumaran meiba-iba myu? Seked ingyan ku kemyu mesendalan? Bitaꞌ myu atue daken yengyegang in!” ");
INSERT INTO plw_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Indyari binresan bekeꞌ pineugad i Jesus meyaat neng diwata, pegketbes, nugad ne kenye, indyari negulinan megtuy itueng yengyegang. ");
INSERT INTO plw_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Pegketbes kiminabiꞌ mengeꞌ pepengenaran in ki Jesus, nemengingkut dye na kaya lang megkikingeg, “Manu angkan kaya lang nepeugad kay atin meyaat neng diwata in?” ");
INSERT INTO plw_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Timinubag si Jesus, kwan, “Punsabab et sengkerit ga pegandel myu. Pegsugiren ku dimyu, naꞌ baꞌ samat deklaꞌ lang elinseg et mustasa in pegandel myu dut Empuꞌ, mebres myu dut bukid tuꞌ, ‘Pesalin ke ne duntin!’ Indyari pesalin ne itue. Kaya lang keginisan na diki myu mepeinabu. ");
INSERT INTO plw_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Segwaꞌ kwantin antangaʼt meyaat neng diwata diki lang mepeugad baꞌ diki pebiyaʼt penelang bekeꞌ pegpuasa.” ");
INSERT INTO plw_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ganang nemegtingtimung ne eset kelungsuran et Galilea itueng mengeꞌ pepengenaran, sinugid kedye i Jesus, kwan, “Aku, itueng Yegang et Taaw, ipegdagang ne keptan et keremut et kebanta ku. ");
INSERT INTO plw_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Pegketbes peteyen dye aku, segwaꞌ aku ipebiyag nega peuliꞌ et Empuꞌ dut iketlung eldew.” Tantu na nemengrupuk dye ne ginsan. ");
INSERT INTO plw_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Pegdateng de Jesus bekeꞌ mengeꞌ pepengenaran ye dut lungsud et Kapernaum, kiminabiꞌ ki Pedro mengeꞌ menunukut et buwis eset Pengempuan naꞌ Benwa. Iningkut ya, kwan, “Pegbayad be et buwis apang dut benwa naꞌ Pengempuan dimyung menunulduꞌ?” ");
INSERT INTO plw_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“Eꞌ tuꞌ,” sambag i Pedro. Ganang nekerateng ne si Pedro dut benwa, megtuy ya iningkut i Jesus, kwan, “Enungkwan takuꞌ pebetang mu Simon? Embe takuꞌ pegsukutan et bayad et lisensiya etawa buwis et mengeꞌ surutan et dunyaꞌ? Dut mengeꞌ taaw atueʼt lungsud dye, etawa dut mengeꞌ tawʼt tumpang?” ");
INSERT INTO plw_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","“Dut mengeꞌ tawʼt tumpang,” sambag i Pedro. Sinugid i Jesus, kwan, “Na baꞌ kwantin, diki lang ipebayad itueng mengeꞌ taaw atueʼt lungsud. ");
INSERT INTO plw_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Segwaꞌ, apang kaya mebres dye kite, sumurung ke dut dagat, pegbenit. Isien mu unang seraꞌ na mebnit mu in. Bingataꞌ babaꞌ in, indyari maya mebiriꞌ mu sembatung siin besiꞌ teup et buwis. Isiaꞌ atin, pegketbes ibeyaraꞌ neʼt buwis neng Pengempuan naꞌ Benwa, supaya puwas kay ne.” ");
INSERT INTO plw_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Indyari atin neng timpu, nepekabiꞌ ki Jesus itueng kenyeng mengeꞌ pepengenaran na nemengingkut, “Sinu takuꞌ itueng pinekemetaas dut Pengmilikan et Empuꞌ dut langit?” ");
INSERT INTO plw_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Angkansa, tiningkag i Jesus sembatung yengyegang, pinetiyeg dut elepan dye. ");
INSERT INTO plw_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Indyari negberes kwan, “Indaniꞌ myu itue, na baꞌ diki kew megpinda arat myu bekeꞌ sumulit dut mengeꞌ keyegangan, tantu banar na diki kew kebayaꞌ dut Pegmilikaʼt Empuꞌ dut langit. ");
INSERT INTO plw_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Angkansa, sebarang pepekumbaba et diri ye samat itueng yengyegang, atin key pinekemetaas eset Pengmilikaʼt Empuꞌ dut langit. ");
INSERT INTO plw_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Sebarang sinu megterima et sembatung mebaba neng taaw samat itueng yengyegang ne kwantin sabab et pengandel ye daken, atin pegterimanen aku. ");
INSERT INTO plw_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Gamlang sembatung taaw tekinan et sembatung kelang batu eset liyeg pegketbes iregdag dut lawed et dagat, kasga atin ne megmendyaring punsabab et keselaan et sembatung kebebaang seled neng taaw na kurang pegandel ye daken.” ");
INSERT INTO plw_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Keingasiꞌingasiꞌ kebtangaʼt ginsaʼt tawʼt dunyaꞌ, sabab et mekansang mengeꞌ puuʼt keselaan et taaw! Diki meylang misan ingyan itueng puun et keselaan, segwaꞌ mekepengirabut mebtangaʼt itueng taaw na mewanan in! ");
INSERT INTO plw_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Na baꞌ keremut etawa tiked mu na pegmewanaʼt keselaan mu, putkaꞌ pegketbes ga in itimbagaꞌ ne! Gamlang meruntin keʼt biyag dut langit na putek sembelaꞌ keremut etawa tiked kasga maya ganaꞌ duwa keremut etawa tiked mu na itimbag ke lang dut apuy na kaya seskeran dut Narkaꞌ. ");
INSERT INTO plw_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Na baꞌ mata mu sinebaban et dimung keselaan, suataꞌ ne lang, pegketbes itimbagaꞌ! Gamlang meruntin ke dut langit, na beleg ne sembatu mata mu in, kasga maya ganaꞌ duwa mata mu tebes ipesbur ke lang gasi dut apuy kaya seskeran dut Narkaꞌ.” ");
INSERT INTO plw_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Ingetiꞌ myu, kasiꞌ myu uripenaꞌ sebarang kebebaang seled neng taaw samat itue. Pegsugiren ku dimyu, dut langit, kedyeng mengeꞌ dereakan daran dut teyumanaꞌ et Empuꞌ Amaꞌ ku. ");
INSERT INTO plw_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Sabab natuꞌ ku, neng Yegang et Taaw, apang bewinen neealam in. ");
INSERT INTO plw_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Enu pikir myu buwaten et sembatung taaw na maya senggatus bibili ye, indyari malam ating sembatu? Diki be takuꞌ itektak ye siyam neng puluꞌ siyam in na pemengaan eset kebudbukiran in, tebes apang tulusen ye nealam tiꞌ? ");
INSERT INTO plw_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Pegsugiren ku dimyu, na baꞌ metulusan ye ne itue, lebing mesegyaan ya dut itueng sembatu kasga dut siyam neng puluꞌ siyam na kaya lang nealam in. ");
INSERT INTO plw_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Megsepantun kwantin gasi, mendiꞌ banar et dimyung Empuꞌ Amaꞌ dut langit na mealam etawa mebinasa misan sembatu et mengeꞌ kebebaang seled neng taaw itue in.” ");
INSERT INTO plw_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Na baꞌ negkesalaꞌ dimu saliꞌ mu neng mengengandel, periksanaꞌ ya ampaꞌ ne megsudsugid kew pasal pegkekesalaꞌ ye dimu, segwaꞌ dut kemyu kemyu lang. Na baꞌ nepesulut mu ya in, indyari dimyung pegbeꞌbayaꞌ megtipused megerut samat tagnaꞌ tiꞌ, ampaꞌ ne mepeseuliꞌ mu ya dut Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Segwaꞌ baꞌ diki ya sumulut dimu, mengdangin keʼt sembatu etawa duwang taaw apang ginsan neng mepegsedsewran myu, mepesebenaran et duwa etawa telung saksiꞌ. ");
INSERT INTO plw_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Na baꞌ diki nega ya sumulut kedye, isugiraꞌ ne itue dut pegtingtimung et mengeꞌ mengengandel. Indyari baꞌ diki nega ya sumulut dut pegtingtimung, iantangaꞌ ne ya dut meyaat neng taaw na kaya pengandel dut Empuꞌ, etawa dut sembatung menunukut et buwis.” ");
INSERT INTO plw_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Banar ne pegsugiren ku dimyu, sebarang ipemawal myu eset lugtaꞌ, atin ipinemawal ne dut langit. Indyari sebarang itugut myu eset lugtaꞌ atin itinugut ne dut langit. ");
INSERT INTO plw_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Pegsugiren ku nega dimyu, na baꞌ kemyung duwa atueʼt lugtaꞌ megsulut meneew et misan enung ginisan eset dimyung penelang, ibgey itue dimyu et daken neng Empuꞌ Amaꞌ dut langit. ");
INSERT INTO plw_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Megdemikian misan embe baꞌ maya duwa etawa telu na negrungrupung sabab et pegandel dye daken, untin ku kebayaꞌ kedye.” ");
INSERT INTO plw_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Atin ne pegkabiꞌ i Pedro dut ki Jesus, nengingkut eset kenye, kwan, “Empuꞌ, kesenu ku empunen itueng dakeng saliꞌ mengengandel na peseuliꞌseuliꞌ negkesalaꞌ eset daken? Kepitu ga takuꞌ a?” ");
INSERT INTO plw_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Sinambag ya i Jesus, kwan, “Diki ku sinugid dimu kepitu, erapun kepitungpuluꞌ neꞌ pitu seulinen mu. ");
INSERT INTO plw_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Sabab itueng Pengmilikaʼt Empuꞌ dut langit saliꞌ samat itueng tuturan. Na, ginaay et sembatung surutan na pebeyaren itueng kenyeng mengeꞌ tindeg na meguutang kenye in. ");
INSERT INTO plw_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Mura binibit kenye in, sembatung taaw na maya kelang utang, megargaʼt sempulung ribu. ");
INSERT INTO plw_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Sabab et ya in kaya mekebayad, dinaak et surutan na ipegelen kenyeng bilug dut keuripenan, kenyeng esawa, bekeꞌ mengeꞌ keyegangan ye, sampay ne ginsang pengartaꞌ ye in, apang mekebayad lang ya. ");
INSERT INTO plw_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Siminelukud na negpeingasiꞌ itueng tindeg dut teteyumanan et surutan, ‘Tengguiꞌ ku mena et timpu, indyari beyaran ku dimyu ginsan in.’ ");
INSERT INTO plw_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nekeingasiꞌ eset kenye itueng surutan, angkansa inampun kenyeng mengeꞌ neutang, indyari pineuliꞌ ne ya. ");
INSERT INTO plw_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Segwaꞌ pegkeugad et tindeg dun, netkanan ye sembatung saliꞌ ye tindeg na meguutang kenyeʼt senggatus. Megtuy ye kimpetan itue bekeꞌ pinisek, negberes, kwan, ‘Megbayad ke neʼt utang mu!’ ");
INSERT INTO plw_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Indyari ating saliꞌ ye tindeg siminelukud bekeꞌ negpeingasiꞌ kenye, kwan, ‘Tengguiꞌ ku mena et timpu, indyari beyaran ku nega ikew.’ ");
INSERT INTO plw_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Segwaꞌ mendiꞌ ya tumanggu, erapun pinepirisu ye nega kenyeng seꞌsaliꞌ tindeg seked na nekebayad et utang ye kenye. ");
INSERT INTO plw_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ganang nebiriꞌ itue et ibang seꞌsaliꞌ ye tindeg na kwantin neinabu, dye in nemengrupuk ne banar. Siminurung dye dut surutan supaya dye ne sinugid ginsaʼt neinabu in. ");
INSERT INTO plw_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Angkansa pinetingkag tindeg et surutan, kwan, ‘Ikew, merupang ke neng tindeg! Inampun ku ikew eset ginsaʼt neutang mu daken, sabab negpeingasiꞌ ke eset daken. ");
INSERT INTO plw_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nekeingasiꞌ ku eset dimu, diki be takuꞌ subaliꞌ meingasiꞌ ke gasi dut seꞌsaliꞌ neng tindeg mu?’ ");
INSERT INTO plw_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Indyari, pegkaꞌ niseg ne surutan in, pinepirisu neʼt surutan in ya in apang dusaen, seked mebeyaran ye ginsaʼt kenyeng utang in. ");
INSERT INTO plw_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Megsepantun kwantin gasi buwaten dimyu et daken neng Amaꞌ Empuꞌ dut langit, na baꞌ diki myu empunen dimyung mengeꞌ saliꞌ mengengandel teyeg et atey myu.” ");
INSERT INTO plw_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Pegketbes mesugid i Jesus itueng mengeꞌ keginisan, ya in nugad ne eset probinsiya et Galilea, siminurung dut probinsiya et Judea dut sembelang danumen et Jordan. ");
INSERT INTO plw_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Mekansang neng taaw nibut kenye, indyari pinegulinan dye ne duntin. ");
INSERT INTO plw_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Maya mengeꞌ tawʼt Pariseo na nemengabiꞌ kenye, indyari sinulayan dye elewen pebiyaʼt mengeꞌ keingkutan, na samat kwantin, “Kuyun takuꞌ dut Keseraan tyu na sembatung lelaki butasan ye kenyeng esawa dut misan enung kesebaban?” ");
INSERT INTO plw_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Siminambag si Jesus, kwan, “Kaluꞌ nebatsaꞌ myu dut Kesuratan, na dut sengketegnanan, ginuna dyeʼt Empuꞌ lelaki bekeꞌ libun? ");
INSERT INTO plw_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Pegketbes sinugid et Empuꞌ, ‘Punsabab et itue, itektak et lelaki kenyeng amaꞌ bekeꞌ induꞌ, pegketbes megbayaꞌ ya neʼt kenyeng esawa, indyari dye in megmendyaring sembetuen ne.’ ");
INSERT INTO plw_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Angkansa dye in lein ne duwa, baꞌ diki tibuuk ne. Itueng tinibuuk et Empuꞌ dyangan lang butasen et taaw.” ");
INSERT INTO plw_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Iningkut ya et mengeꞌ Pariseo, kwan, “Manu angkan tinehagan i Moises na begeyan et lelaki itueng kenyeng esawa et kesuratan eset pegbutas mura butasan itie?” ");
INSERT INTO plw_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Siminambag si Jesus, kwan, “Punsabab dut kektulan et ulu myu, angkansa tinugutan ne i Moises na butasan myu dimyung keesewanan. Segwaꞌ diki lang atin kwantin sengketegnanan tiꞌ. ");
INSERT INTO plw_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Angkansa pegsugiren ku dimyu, sebarang taaw na memutas et esawa, pegketbes mengesawa dut iba, atin negkesalaꞌ ne et pegbeis. Maya sembatung neglyu! Tugutan ku memutas taaw baꞌ esawa ye megsalaꞌ et pegbeis dut iba.” ");
INSERT INTO plw_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Pegbersen et mengeꞌ pepengenaran ye kenye, “Na baꞌ kwantin kebtangan et lelaki dut kenyeng esawa, gamlang dyangan ne mengesawa.” ");
INSERT INTO plw_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Siminambag si Jesus, “Diki lang ginsan meketerima et atin neng sengketegnanan, baꞌ diki itie lang neng pegbegeyan et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Sabab maya lein-leing sinebaban na baꞌ manu angkan takuꞌ ibang kelelekian in diki lang mekeesawa. Sengmenu, sabab maya mengeꞌ lelaki na kapun tihad nega et pegyegang kedye megkwantin dye ne. Iba in, kinapun sabab et kebelbealan et leing taaw. Maya gasi mendiꞌ ne mengesawa alang-alang dut pegsukuꞌ et Empuꞌ dut langit. Sebarang keterima et itueng ketulduan, keterima nega.” ");
INSERT INTO plw_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Maya nememibit et mengeꞌ keyegangan ki Jesus apang tewen na ipedpen ye dut mengeꞌ itue kenyeng keremut bekeꞌ ipenelang. Segwaꞌ pinegbebersan dyeʼt mengeꞌ pepengenaran. ");
INSERT INTO plw_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Megdemikian sinugid i Jesus, kwan, “Pesariꞌ myu kumabiꞌ daken ating mengeꞌ keyegangan. Kasiꞌ myu dye leangaꞌ, sabab gaay et Empuꞌ mengmilik kedye gasi.” ");
INSERT INTO plw_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Dimpen ye dut kedye kenyeng keremut apang pesukuran et Empuꞌ, mura nugad. ");
INSERT INTO plw_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Indyari maya gasi sembatung lelaki kiminabiꞌ dut ki Jesus apang mengingkut, kwan, “Menunulduꞌ, enung kenunganan itueng keilangan buwaten ku, apang meterima ku biyag kaya seskeran?” ");
INSERT INTO plw_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Siminambag si Jesus, kwan, “Manu angkan takuꞌ pegingkuten mu aku na baꞌ enu menunga? Sabab Empuꞌ lang menunga. Na baꞌ gaay mu meterima itueng biyag kaya seskeran, telinganen mu itueng mengeꞌ Keseraan et Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","“Embe esen?” ingkut ye. Siminambag si Jesus, kwan, “Kas mengimatey, kas pegbeis, kas penakew, kas pengembut eset dimung pegsaksiꞌ, ");
INSERT INTO plw_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","peruriaꞌ dimung amaꞌ bekeꞌ induꞌ, bekeꞌ merganaꞌ dimung sebayaꞌ, na samat pegmergaꞌ muʼt dimung diri.” ");
INSERT INTO plw_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Bineres et subur in, “Pegtumanen ku ne atin ginsan neng Keseraan. Enu nega merapat ku buwaten?” ");
INSERT INTO plw_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Indyari siminambag si Jesus, kwan ye, “Na baꞌ gaay mu megmendyaring sukup, manew ke, ipegelnaꞌ ginsan neng pengartaꞌ mu, indyari ipemeginaꞌ dut miskin ating nepegelenan. Na baꞌ nebuwat mu atin, megmendyaring megdeyahan ke dut langit. Pegketbes, megpeuliꞌ ke atue na sumunud daken.” ");
INSERT INTO plw_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Pegkekingeg itue e et subur, merupuk na nugad ye, sabab et deyahan ya banar. ");
INSERT INTO plw_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Indyari, bineres i Jesus dut kenyeng mengeꞌ pepengenaran, “Pegbersen ku dimyu, tantu meliyut mepebilang mengeꞌ deyahan dut Pengmilikaʼt Empuꞌ dut langit. ");
INSERT INTO plw_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Indyari pegsugiren ku gasi dimyu, merugey nega kebiyaꞌ sembatung ayup neng kamelyo dut delang et dagum kasga pesakup dut Pengmilikaʼt Empuꞌ dut langit sembatung deyahan.” ");
INSERT INTO plw_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Negliluꞌ banar itueng mengeꞌ pepengenaran ganang mekingeg dye itue, angkansa nekeingkut dye, kwan, “Na baꞌ kwantin, sinu ga takuꞌ mebawiꞌ?” ");
INSERT INTO plw_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Tinengtengan dye i Jesus bekeꞌ negsugid, “Diki itue mekebuwat et taaw, erapun Empuꞌ lang mekebuwat et itue sampay ginsan neng ginis.” ");
INSERT INTO plw_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Indyari negberes si Pedro, “Birinaꞌ be, tinektak kay ne ginsan, indyari kami tuꞌ nememayaꞌ dimu. Enu gasi dut damen?” ");
INSERT INTO plw_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Bineres i Jesus dut kedye, “Indaniꞌ myu itue, na baꞌ megearung ne aku, itueng Yegang et Taaw, eset meayad neng eerungan ku dut bagung dunyaꞌ, kemyung sempulung duwa nememayaꞌ daken marung gasi dut sempuluꞌ duwang eerungan apang ukumen itueng sempuluꞌ duwang bagiꞌ tawʼt Israel. ");
INSERT INTO plw_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Pegketbes sebarang menandal na tirengan dye kedyeng pegeeldengan, mengeꞌ ketipusdan, amaꞌ, induꞌ, mengeꞌ keyegangan, etawa mengeꞌ kelugtaan alang-alang lang eset daken, atin keterimaʼt senggatus peuliꞌpeulinen, indyari begeyan et biyag na kaya seskeran. ");
INSERT INTO plw_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Segwaꞌ mekansang ne nemeketaas na megmendyaring nebaba, indyari mekansang nebaba na megmendyaring nemeketaas.” ");
INSERT INTO plw_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Neglahyun menulduꞌ i Jesus, kwan ye, “Itueng Pengmilikaʼt Empuꞌ dut langit samat kwantin. Kueldew nega nanew ne itueng Empuꞌ et ubasan apang menulus et mengengeradya et ubasan ye. ");
INSERT INTO plw_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ganang negsulut dye ne et penengdan na sembatu pirak neng emas seng eldew, dye in pinekeradya ye ne dut ubasan ye. ");
INSERT INTO plw_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Nanew gasi ya peuliꞌ et lisag siyam et meriklem dut tabuan, nekebiriꞌ ya ibang taaw na petiyeg-tiyeg lang na kaya gasi eluꞌ dye. ");
INSERT INTO plw_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Sinugid ye dut kedye, ‘Sumurung kew apang megkeradya dut daken neng ubasan, indyari beyaran ku kemyu et sukup neng penengdan.’ ");
INSERT INTO plw_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Indyari nemegkeradya dye ne. Nanew gasi ya tengeldew, bekeꞌ megtetelu lisag neʼt mapun, indyari kwantin nega binwat ye. ");
INSERT INTO plw_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ganang meglilima lisag neʼt mapun, nanew nega ya, nekebiriꞌ gasi peuliꞌ et ibang taaw, na petiyeg-tiyeg lang. Binres ye kedye, ‘Manu takuꞌ petiyeg-tiyeg kew lang atue mengsingapun na kaya pegkeredyanen?’ ");
INSERT INTO plw_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","‘Katew, kaya be megpekeradya damen!’ sambag dye. Indyari, negberes ya, ‘Baꞌ kwantin pelan, surung kew, indyari megkeradya dut daken neng ubasan.’ ");
INSERT INTO plw_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Megmemenginsarem ne, sinugid et empuʼt ubasan dut kenyeng tegepegewla, kwan, ‘Peningkagaꞌ ne mengeꞌ mengengeradya, penengdanan te ne dye, tegnanan dut emurian sumked dut timinagnaꞌ nengeradya tiꞌ.’ ");
INSERT INTO plw_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Itueng mengeꞌ nemengeradya na negtagnaꞌ et meglilima lisag et mapun keterima et tegsembatu pirak neng emas. ");
INSERT INTO plw_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Indyari ganang kiminabiꞌ itueng mengeꞌ unang neketagnaꞌ in, keblan dye tuꞌ keterima dye nega et lumebi esentin, segwaꞌ kede sembatu kedye keterima gasi et sembatu pirak neng emas. ");
INSERT INTO plw_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Pegketerima dye in, nenawey dye dut empuʼt ubasan. ");
INSERT INTO plw_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Kwan dye, ‘Seng lisag ga negkeradya ating mengeꞌ emuri diminateng, sementaraꞌ megsingapun kay negsandal et lened et eldew. Manu gasi takuꞌ pinegseꞌsaliꞌ penengdan myu damen?’ ");
INSERT INTO plw_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Indyari sinugid ye dut sembatu kedye, ‘Bilaꞌ, kaya lang peglupigen ku ikew. Diki be takuꞌ negsulut te et sembatu pirak neng emas lang et tengdan et pegkeradya mu? ");
INSERT INTO plw_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Isiaꞌ dimu lang in, indyari mugad ke ne. Manu ganaꞌ baꞌ gaay ku tengdanan itieng emuri tiꞌ neng samat penengdan ku dimu in? ");
INSERT INTO plw_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Kaya be takuꞌ mekedyari ku buwaten dut daken neng megeayan eset pengartaꞌ ku in? Etawa megimbeng ke lang sabab menaram aku?’ ” ");
INSERT INTO plw_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Dut ketimpusan sinugid i Jesus, kwan, “Angkansa itieng mekeemuri, atin key mekeuna, bekeꞌ itieng mekeuna, atin key mekeemuri.” ");
INSERT INTO plw_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ganang eset dalan ne de Jesus petungul dut lungsud et Jerusalem, sineririꞌ ye itueng sempuluꞌ duwang pepengenaran ye. Sinugid ye kedye, kwan, ");
INSERT INTO plw_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Kinggaꞌ myu, tumungul tyu dut lungsud et Jerusalem. Duntin ipeelen eset mengeꞌ metaas neng pariꞌ bekeꞌ dut mengeꞌ menunulduꞌ et Keseraan aku, itueng Yegang et Taaw. Betangan dye aku et kemeteyan. ");
INSERT INTO plw_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Pegketbes ibgey eset mengeꞌ tawʼt lein Judio. Inlelewen dye aku, penglepsan, bekeꞌ iransang dut krus seked patey. Segwaꞌ biyagen aku peuliꞌ et Empuꞌ dut iketlung eldew.” ");
INSERT INTO plw_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Indyari kiminabiꞌ ki Jesus itueng esawa i Sebedeo, kebayaꞌ kenyeng mengeꞌ keyegangan. Maya gaay ye tewen, angkansa siminelukud ya dut teteyumanan i Jesus. ");
INSERT INTO plw_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","“Enu takuꞌ gaay mu?” ingkut i Jesus kenye. Siminambag ya, kwan, “Teyen mebgey mu dut duwa neng keyegangan ku na mekearung eset abiꞌ mu dut dimung pengmilikan, sembatu dut tampaꞌ kewanan, indyari sembatu in dut tampaꞌ gibang.” ");
INSERT INTO plw_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","“Diki myu mekesewran itueng dimyung pegteewen,” kwan i Jesus eset kedye. “Metetasan myu be takuꞌ itueng tasa neng keliyutan na pegtetasan ku tuꞌ?” “Eꞌ be, mekedyari ne kami,” sambag dye. ");
INSERT INTO plw_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Bineres i Jesus, “Itueng keliyutan na pegtetasan ku, metetasan myu nega pelan. Segwaꞌ lein daken mewanan et penggewman na baꞌ sinu takuꞌ marung dut daken neng tampaꞌ kewanan bekeꞌ dut daken neng tampaꞌ gibang. Itueng mengeꞌ eerungan na pegbersen myu tudyu dut mengeꞌ pegpenyapan et daken neng Amaꞌ Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ganang nekingeg itue et mengeꞌ ibang sempulung pepengenaran, nemengiseg dye dut duwang megtipused. ");
INSERT INTO plw_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Angkansa pinepekabiꞌ dye i Jesus bekeꞌ neres kedye, kwan, “Pegsesewren myu ne na mengeꞌ pegibuten et tawʼt atueʼt sengkedunyaan pengmilik banar dut ginsaʼt taaw na sukup kedye. Indyari mayang pegbentugen neng pegibuten, atin key meketuman. ");
INSERT INTO plw_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Segwaꞌ diki kwantin teyen buwaten myu. Erapun, sebarang sinu dimyu megaay megmendyaring bantug, atin key megmendyaring samat tindeg et ginsan. ");
INSERT INTO plw_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Indyari sebarang gaay megmendyaring pegibuten, atin key megmendyaring samat uripen dut mengeꞌ kebebayaꞌ ye. ");
INSERT INTO plw_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Samat aku neng Yegang et Taaw na natuꞌ, diki apang timuruen, erapun apang menimuru sampay ibgey daken neng biyag apang mebawiꞌ kineldaman.” ");
INSERT INTO plw_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ganang pegugad si Jesus sampay mengeꞌ pepengenaran ye dut lungsud et Jeriko, mekansang taaw nemengsunud kedye. ");
INSERT INTO plw_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Maya duwang taaw naꞌ beleg megearung dut abiʼt dalan. Ganang mekingeg dye na megderateng ne si Jesus, dye tuꞌ nemengbensag ne, “Inupuꞌ i Surutan Dabid tagnaꞌ, meingasiꞌ ke ne damen!” ");
INSERT INTO plw_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Pinenugiran dye et mengeꞌ taaw bekeꞌ pegpetngew, segwaꞌ susulu ga nemeningkag, kwan, “Inupuꞌ i Surutan Dabid, meingasiꞌ ke ne damen!” ");
INSERT INTO plw_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Nepetaren si Jesus, tiningkag bekeꞌ iningkut dye, “Enu takuꞌ gaay myu buwaten ku dimyu?” ");
INSERT INTO plw_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Siminambag dye, “Begerar, uruiꞌ dameng mengeꞌ mata na mekebiriꞌ kay ne!” ");
INSERT INTO plw_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Nekeingasiꞌ si Jesus dut kedye, indyari kinutew ye kedyeng mengeꞌ mata. Na megtuy dye nekebiriꞌ, pegketbes siminunud eset kenye. ");
INSERT INTO plw_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ganang mekabiꞌ ne si Jesus sampay mengeꞌ pepengenaran ye dut lungsud et Jerusalem, diminateng dye dut kebenbenwanan et Betpage, dut Bukid et mengeꞌ Olibo. Duun pineuna ne i Jesus itueng duwang pepengenaran ye. ");
INSERT INTO plw_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Sinugid ye kedye, “Sumurung kew dut megsusunud neng kebenbenwanan dut dipag myu tiꞌ. Megtuy mebiriꞌ myu duntin sembatung inaꞌ neng asno na pegsisigtan, bekeꞌ ibun ye. Bebariꞌ myu ampaꞌ ne bibiten atue daken. ");
INSERT INTO plw_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Na baꞌ maya mengingkut dimyu, isugiraꞌ myu, ‘Keilangan et Begerar dye,’ indyari ipebibit ye dye ne dimyu megtuy.” ");
INSERT INTO plw_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Meinabu itue apang metuman itueng pegsugiren et Empuꞌ pebiyaꞌ tarus ye, kwan, ");
INSERT INTO plw_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Isugiraꞌ myu dut lungsud et Sion, siyekiꞌ myu, megderateng ne dimyung surutan, ya tuꞌ mesabar, bekeꞌ nekesakat dut sembatung inaꞌ et asno na megbebayaꞌ kenyeng ibun.” ");
INSERT INTO plw_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Nememanew ne itueng mengeꞌ pepengenaran, indyari tinuman itueng penahag i Jesus. ");
INSERT INTO plw_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Binibit dye itueng inaʼt asno bekeꞌ ibun in. Linempikan dye telikud in et kedyeng repanan, ampaꞌ ne siminakat si Jesus. ");
INSERT INTO plw_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Mekansang dut kineldaman et taaw pinegladlad dye et kedyeng repanan eset dalan, sebarang iba in nememutek et mengeꞌ sanga et kayu pegketbes dinatun gasi dut dalan supaya deyewen dye ya. ");
INSERT INTO plw_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nemegbebensag itueng kineldaman neng memeguna sampay ne ating kineldaman neng megsusurung kenye tiꞌ, kwan dye, “Deyewen itueng Upuꞌ i Surutan Dabid! Kenunganan itueng megderateng dut kepengdyarian et Empuꞌ! Bentugen tyu Empuꞌ dut langit!” ");
INSERT INTO plw_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Pegseled i Jesus dut lungsud et Jerusalem, neeriwaraꞌ sengkelungsuran. “Sinu takuꞌ itue?” ingkut dye. ");
INSERT INTO plw_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","“Itue si Jesus, tarus teyeg dut lungsud et Nasaret, dut probinsiya et Galilea,” penambag gasi et kineldaman. ");
INSERT INTO plw_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Siminled si Jesus dut Pengempuan na benwa naꞌ Templo. Pineugad ye peliwan ginsan et mengeꞌ pemegdengdagang bekeꞌ mengengelen duntin. Pinekleb ye mengeꞌ lemisaan et mengeꞌ menenambiꞌ et pirak bekeꞌ mengeꞌ erungan neng mengeꞌ megdedagang et aksang. ");
INSERT INTO plw_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Sinugid ye kedye, “Nekesurat dut Kesuratan na sinugid et Empuꞌ, kwan ye, ‘Itueng daken neng Benwa neng Pengempuan, usaleʼt benwa neng megpenelenginan.’ Segwaꞌ binwat myuʼt pupugaran et menenakew.” ");
INSERT INTO plw_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Maya mengeꞌ beleg bekeꞌ mengeꞌ pangkul na nemengabiꞌ ki Jesus dut Pengempuan na Benwa, pegketbes pinegulinan ye dye. ");
INSERT INTO plw_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Nemengiseg mengeꞌ pegibuteʼt pariꞌ bekeꞌ itueng mengeꞌ menunulduꞌ et Keseraan, ganang mebiriꞌ itueng keliꞌlilung binwat ye, bekeꞌ mengeꞌ keyegangan megbebensag dut seled Pengempuan naꞌ Benwa neng Templo, “Deyewen itueng Upuꞌ i Surutan Dabid tagnaꞌ!” ");
INSERT INTO plw_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Indyari sinugid dye ki Jesus, “Nekingeg mu takuꞌ ating pegbebersen dye in?” “Nekingeg ku,” kwan i Jesus. “Kaluꞌ, nekebatsaꞌ kew et kwantin neng bebresan dut Kesuratan et Empuꞌ? kwaʼt atin, ‘Pineliwan et Empuꞌ teyeg dut babaꞌ et mengeꞌ keyegangan bekeꞌ mengeꞌ memulek na ating tantung pegbantug.’ ” ");
INSERT INTO plw_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Nugad si Jesus kedye, liminiwan et lungsud pesurung dut lungsud et Betania. Duntin ya negpelabay et senggebi. ");
INSERT INTO plw_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kinerikleman, sasat megpeuliꞌ si Jesus dut lungsud, ya tuꞌ inurapan. ");
INSERT INTO plw_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Nekebiriꞌ ya et sembatung puun et igus eset abiʼt dalan, kinebiyan ye itue. Segwaꞌ kaya lang nekebiriꞌ selyu ga deun. Angkansa binres ye eset puun et igus in, “Diki ke ne muaꞌ misan ingyan!” Indyari megtuy timinuug itueng puun et igus. ");
INSERT INTO plw_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nebiriꞌ itueʼt mengeꞌ pepengenaran bekeꞌ nemegliluꞌ dye. “Enukwan timinuug megtuy itueng puun et igus?” ingkut dye. ");
INSERT INTO plw_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Siminambag si Jesus, kwan, “Indaniꞌ myu itue, na baꞌ pengandel kew dut Empuꞌ bekeꞌ kaya alang-alang, mebuwat myu gasi itueng binwat ku eset puuʼt igus tuꞌ. Diki lang atin! Na baꞌ ibres myu eset bukid ne itue, ‘Mugad ke esentin bekeꞌ lumempud ke dut dagat,’ meinabu atin dimyung beres. ");
INSERT INTO plw_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Megdemikian misan enu nega tewen myu dut dimyung penelang atin meterima, na baꞌ itue pegendelen myu.” ");
INSERT INTO plw_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Neuliꞌ bekeꞌ siminled si Jesus dut Benwa naꞌ Pengempuan. Sasat megtutulduꞌ ya, kiminabiꞌ kenye itueng mengeꞌ pegibuteʼt pariꞌ bekeꞌ mengeꞌ pegibuten et atin neng lungsud, nengingkut kenye, “Enu takuꞌ itueng penggewman mu na memuwat et itueng mengeꞌ keginisan? Sinu dimu nenggeyʼt penggewman?” ");
INSERT INTO plw_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Siminambag si Jesus kedye, “Ingkuten ku gasi kemyu, na baꞌ metubag myu aku, mura ku gasi sembagen na baꞌ enu penggewman ku memuwat et mengeꞌ itueng keginisan. ");
INSERT INTO plw_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Na, itue ingkut ku dimyu. Embe minewanan et penggewman i Juan apang megbewtismu? Teyeg Empuꞌ be etawa teyeg taaw?” Indyari dye tuꞌ nemegsudsugid, “Na baꞌ ibres tyu, ‘Teyeg Empuꞌ,’ mesugid ye gasi kityu, ‘Manu angkan takuꞌ diki myu si Juan endelen?’ ");
INSERT INTO plw_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Segwaꞌ baꞌ isugid tyu, ‘Mewanan dut taaw lang,’ kaluꞌ gasi baꞌ enu buwaten kityu et tawʼt lungsud, sabab pegkilelanen neʼt ginsan na itieng si Juan sembatung tarus et Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Angkansa sinambag dye si Jesus, “Kaya sewd kay atin!” Sinugid i Jesus kedye, “Na diki gasi isugid dimyu na baꞌ enu penggewman ku memuwat et mengeꞌ itueng pegbubuwaten ku tuꞌ.” ");
INSERT INTO plw_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Na, netuturan gasi si Jesus dut kedye, kwan ye, “Enu pemiriꞌ myu atue? Maya sembatung taaw na maya duwang yegang naꞌ lelaki. Dinaak ye keukanan in, kwan, ‘Yegang, sumurung ke bekeꞌ megkeradya dut ubasan tiban.’ ");
INSERT INTO plw_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","‘Mendiꞌ ku tuꞌ,’ sambag ye, segwaꞌ ganang nekwit-kwit negpinda kenyeng pemikir angkansa nenelinga nega bekeꞌ siminurung dut ubasan. ");
INSERT INTO plw_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Indyari sinurungan gasi et amaꞌ kerinan in, kwantin gasi sinugid ye, kwan, ‘Yegang, sumurung ke bekeꞌ megkeradya dut ubasan tiban.’ ‘Eꞌ be, Amaꞌ,’ sambag ye, segwaꞌ pelan kaya lang nengandel. ");
INSERT INTO plw_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Sinu eset duwa in nenelinga eset kegeayan et kenyeng amaꞌ in?” “Ating keukanan,” sambag dye. Indyari sinugid kedye i Jesus, “Pegsugiren ku dimyu, itueng mengeꞌ menunukut et buwis bekeꞌ mengeꞌ mememegbeis neng kelibunan meguna nega dut dimyung mengeꞌ keperian bekeꞌ kegunggurangan. ");
INSERT INTO plw_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Sabab natuꞌ dimyu si Juan neng Mememewtismu penugid et metignaꞌ neng pengengebiyagan, pegketbes diki myu nega ya pegtelinganen. Segwaꞌ pegtelinganen ya et mengeꞌ menunukut et buwis bekeꞌ mengeꞌ mememegbeis neng kelilibunan. Misan et gangang nebiriꞌ myu ne itue, temed mendiꞌ kew megsusun bekeꞌ menelinga kenye pegketbes.” ");
INSERT INTO plw_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Indyari kwan i Jesus, “Kinggen myu itueng sembatu negang beleybey. Maya sembatung empuʼt lugtaꞌ nengluwak et ubas dut kenyeng uma, binekuran ye ne itue. Nemuwat ya duntin et pepegaan et ubas bekeꞌ negpetiyeg et sembatung melayug neng tutungguan. Pegketbes, pinetunggu ye atin ubasan dut mengeꞌ ibang mengunguma, indyari ya in siminurung dut ibang bangsa. ");
INSERT INTO plw_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ganang pemumuwaan ne, tinehagan et empuʼt ubasan kenyeng dereakan na apang isien kenyeng bagiꞌ dut mengunguma ye tiꞌ. ");
INSERT INTO plw_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Segwaꞌ sinegmak et mengeꞌ mengunguma itueng mengeꞌ dereakan, pinegpupukul dye sembatu in, pinatey inyet ikeruwa tiꞌ, bekeꞌ binakal et batu inyet iketlu tiꞌ. ");
INSERT INTO plw_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Tinahag peuliꞌ et empuʼt ubasan ibang dereakan ye na lebing mekansang dye kasga nekeuna tiꞌ, segwaꞌ kwantin nega binwat kedye et mengeꞌ mengunguma ye tiꞌ. ");
INSERT INTO plw_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Dut keemuri-emurian dinaak et Empuꞌ kenyeng yegang neng lelaki. ‘Untebien dye be itueng daken neng yegang,’ kwan et sedseled ye tiꞌ. ");
INSERT INTO plw_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Segwaꞌ ganang mebiriꞌ et mengeꞌ mengunguma ye ating yegang, dye in nemegisun, ‘Itue ne memusakaꞌ. Aniꞌ kew! Peteyen tyu ne lang apang kityu ne mepepusekaan!’ ");
INSERT INTO plw_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Angkansa megtuy dye ya sinegmak, pineliwan eset ubasan pegketbes pinatey ya. ");
INSERT INTO plw_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Pegpeuliꞌ et empuʼt ubasan, enu buwaten ye dut mengeꞌ mengunguma tiꞌ?” iningkut i Jesus. ");
INSERT INTO plw_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Siminambag dye, kwan, “Pengimeteyen ye dye neng mengeꞌ meraat et kaya ne pengingasiꞌingasiꞌ, indyari pinedyegahan ating ubasan dut lein-leing mengunguma na menggeyʼt bagiꞌ kenye dut timpu neng pemumupuan.” ");
INSERT INTO plw_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Iningkut dye i Jesus, “Kaluꞌ nebatsaꞌ myu ne itueng elaren dut Kesuratan et Empuꞌ, kwan ye, ‘Itueng batu na inendian et mengeꞌ megpepetiyeg et benwa, atin key negmendyaring batung penued. Binwat itue et Empuꞌ, angkan itue mekeliluꞌ-liluꞌ banar dut pemiriꞌ tyu?’ ");
INSERT INTO plw_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Angkansa pesi pegsugiren ku dimyu, diki ne kemyu sukup dut pengmilikan et Empuꞌ, erapun ating ugaren set dimyu, indyari igbey ne atin dut sebarang mengeꞌ taaw ne mekepegbuaꞌ et menungang buaꞌ teup dut mengeꞌ tantung mengengandel et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Itueng nekeburtuk eset batu merurunsak, bekeꞌ mepipirsak ating meburtukan.” ");
INSERT INTO plw_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nekingeg et mengeꞌ pegibuten neng pariꞌ bekeꞌ mengeꞌ taaw Pariseo itueng mengeꞌ beleybey i Jesus, indyari neretian na dye ne in pegpepekinggan. ");
INSERT INTO plw_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Na, elewen dye ne teyen ya in, segwaꞌ timinakut dye dut mengeꞌ taaw, sabab pegendelen et mengeꞌ itue na si Jesus sembatung tarus et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Nenuturan gasi peuliꞌ si Jesus kedye antangaʼt beleybey. Sinugid ye, kwan, ");
INSERT INTO plw_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Itueng Pengmilikan et Empuꞌ dut langit samat kwantin. Nenggey et kelang pegkenkaan itueng sembatung surutan eset bulun et kenyeng yegang naꞌ lelaki. ");
INSERT INTO plw_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Tinahag ye kenyeng dereakan apang tingkagen itueng mengeꞌ taaw na pinenggayat ye dut pegkenkaan et bulun. Segwaꞌ mendiꞌ dye sumarung. ");
INSERT INTO plw_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Nenahag gasi ya peuliꞌ et dereakan, indyari kenyeng pinemilinan, ipenugiraꞌ myu dut mengeꞌ pinenggayat, kwan, ‘Nepanyap ku ne kenkeanan, nesumbaliꞌ ne daken neng sapiꞌ bekeꞌ mengeꞌ pinetebaang guya, indyari panyap ne ginsang ginisan. Aniꞌ kew neʼt kenkeanan et bulun!’ ");
INSERT INTO plw_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Segwaꞌ diki lang itue pinren et mengeꞌ pinenggayat tiꞌ. Gam key siminurung dye dut kedyeng pepenewan, sembatu in dut kenyeng uma, bekeꞌ iba in dut kenyeng pegdengdagang. ");
INSERT INTO plw_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Sinegmak gasi et iba in itueng mengeꞌ dereakan, dinusaan, bekeꞌ pinatey. ");
INSERT INTO plw_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Niseg itueng surutan. Tinahag ye kenyeng mengeꞌ sundalu, peteyen itueng mengeꞌ memematey-taaw bekeꞌ pinetutung kedyeng lungsud. ");
INSERT INTO plw_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Bineres ye dut kenyeng mengeꞌ dereakan, ‘Nekepanyap ne kenkeanan, segwaꞌ diki merapat itueng mengeꞌ pinenggayat. ");
INSERT INTO plw_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Angkansa sumurung kew dut mengeꞌ dalan sampay belnek na mekansang taaw, indyari, penggeyataꞌ myu ne dut bubulunan ginsan neng mebiriꞌ myu.’ ");
INSERT INTO plw_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Na, surung ne dut mengeꞌ dalan itueng mengeꞌ dereakan. Indyari, pinebayaꞌ dye ginsan neng metkanan, meyaat bekeꞌ menunga, na enu nega be, atin peꞌ nebehanan neʼt mengluluruk ating bubulunan dut kelang benwa. ");
INSERT INTO plw_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Siminled itueng surutan apang birinen itueng mengeꞌ nemengluruk. Indyari nebiriꞌ esentin sembatung taaw, kaya nekebadyuʼt bagu. ");
INSERT INTO plw_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","‘Ilaꞌ, manu angkan siminled ke atue, na diki lang negbadyuʼt bagu?’ iningkut et surutan kenye. Kaya nekegibek itueng taaw. ");
INSERT INTO plw_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Angkansa sinugid et surutan dut mengeꞌ dereakan, ‘Pungpungaꞌ myu kenyeng keremut bekeꞌ tiked, pegketbes itimbagaꞌ myu dut kelingban dut liwan. Duntin sumiyak ne ya bekeꞌ megringetnget kenyeng nipen.’ ” ");
INSERT INTO plw_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Angkansa netimpus i Jesus dut itueng beres, kwan, “Megsepantun itue na mekansang pinenggayat, segwaꞌ sesenu ga megmendyaring nepiliꞌ et Empuꞌ Pengmilikan ye.” ");
INSERT INTO plw_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Nemengugad itueng mengeꞌ taaw Pariseo bekeꞌ pemegsudsugid na baꞌ enukwan dye mealew si Jesus eset kenyeng pegbebersen pebiyaꞌ meliyut neng mengeꞌ ingkut dye. ");
INSERT INTO plw_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Angkansa nemenahag dye dut kenye mengeꞌ senu itueng kedyeng mengeꞌ tindeg, kebayaꞌ mengeꞌ senung kekampi i Surutan Herodes. Negsugid dye, “Menunulduꞌ, sewd kay ne ikew tuꞌ tantu, indyari pegtulduꞌ mu inyet keberbenaran lang tiꞌ neng geayen et Empuꞌ na buwaten et mengeꞌ taaw. Kaya pegsiyekan mu baꞌ sinu dye, angkansa kaya meglekeꞌ pegtulduꞌ mu sabab et pikiren et taaw. ");
INSERT INTO plw_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Na tiban isugiraꞌ damen, enukwan ipeantang myu? Kuyun be takuꞌ dut Keseraan tyu na memuwis dut ki Surutan Sesar etawa diki?” ");
INSERT INTO plw_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Segwaꞌ sewd i Jesus itueng kedyeng meraat neng pegtetekeren, angkansa bineres ye, “Kemyung pebiꞌbiriꞌ! Manu takuꞌ gaay myu aku elewen? ");
INSERT INTO plw_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Bitaꞌ atuꞌ pirak et pemuwis!” Indyari, tinundulan ne ya et sembatung pirak. ");
INSERT INTO plw_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","“Kinung pataꞌ bekeꞌ ingaran na nekeukir atuꞌ?” ingkut i Jesus. ");
INSERT INTO plw_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“Ki Surutan Sesar tuꞌ atin,” siminambag dye. Indyari, kwan i Jesus dut kedye in, “Na baꞌ kwantin ibgeyaꞌ myu ki Surutan Sesar inyet ki Surutan Sesar in, indyari gasi ibgeyaꞌ myu ki Empuꞌ inyet ki Empuꞌ in.” ");
INSERT INTO plw_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Neperengdeng dye mene ganang mekingeg dye atin, pegketbes tinirengan dye ya bekeꞌ nemengugad dye ne. ");
INSERT INTO plw_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Atin negang eldew kiminabiꞌ ki Jesus itueng mengeꞌ senung pariꞌ na Saduseo, mengeꞌ taaw na kaya pemengandel na megbiyag peuliꞌ mengeꞌ patey dut langit. ");
INSERT INTO plw_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Sinugid dye, kwan, “Menunulduꞌ, sinurat i Moises na baꞌ matey na kaya yegang itueng sembatung lelaki, itueng kenyeng tipused keilangan ne pebulun dut balu apang megyegangan dye alang-alang lang dut natey. ");
INSERT INTO plw_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Naꞌ, supama, baꞌ maya pitung megtitipused naꞌ lelaki atueʼt damen, nengesawa ating keukanan, indyari natey na kaya yegang, angkansa netektak itueng kenyeng esawa dut kenyeng ketipusdan. ");
INSERT INTO plw_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Megsepantun kwantin gasi neinabu dut pengeruwang ketipusdan, bekeꞌ eset pengetlung ketipusdan, sampay napet seked dut ikepitung tipused. ");
INSERT INTO plw_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Pegkaꞌ natey dye ne ginsan, natey ne gasi libun tiꞌ. ");
INSERT INTO plw_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Na tiban, baꞌ pegbiyag peuliꞌ et tawʼt natey, sinu ne dut pitu tiꞌ megmendyaring esawa ye, punsabab et ya in neesawa dye ginsan tiꞌ?” ");
INSERT INTO plw_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Siminambag si Jesus, “Negsalaꞌ kew, seukat ne kaya penedseled myu et mengeꞌ Kesuratan et Empuꞌ sampay eset kepengdyarian et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Sabab dut pegbiyag peuliꞌ et mengeꞌ natey, itueng mengeꞌ taaw diki ne memengesawa. Dye in, mepeantang ne samat mengeꞌ dereakan et Empuꞌ dut langit. ");
INSERT INTO plw_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Pasal gasi dut pegbiyag peuliꞌ et mengeꞌ patey, ingga peꞌ takuꞌ nebatsaꞌ myu dut Kesuratan itueng pegsugiren dimyu et Empuꞌ? Sinugid ye, ");
INSERT INTO plw_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Aku itueng Empuꞌ i Abraham, Empuꞌ i Isaak, bekeꞌ Empuꞌ i Jakob.’ Segwaꞌ itueng Empuꞌ lein Empuꞌ et mengeꞌ patey, erapun Ya in Empuꞌ neng mengeꞌ biyag.” ");
INSERT INTO plw_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Indyari ganang mekingeg itue et mengeꞌ taaw, neperengdeng dye eset kenyeng netulduꞌ. ");
INSERT INTO plw_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Negtingtimung itueng mengeꞌ taaw Pariseo, ganang neebaran dye na nepetngew i Jesus itueng mengeꞌ taaw Saduseo. ");
INSERT INTO plw_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Indyari sembatu eset kedye in na sembatung biaksa dut Keseraan, na nengingkut ki Jesus apang sulayan itue. ");
INSERT INTO plw_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Kwan ye, “Menunulduꞌ, embe itueng pinekemergang saraꞌ eset Keseraan et Empuꞌ?” ");
INSERT INTO plw_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Siminambag si Jesus, “ ‘Merganaꞌ Begerar mu neng si Empuꞌ tibuuk et seled atey mu, tibuuk et seled kurudua, bekeꞌ tibuuk dut seled pikiran mu.’ ");
INSERT INTO plw_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Itue ne tinegnanan bekeꞌ pinekemergang saraꞌ. ");
INSERT INTO plw_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Itue gasi pengeruwang pinekemergang saraꞌ samat una in, ‘Merganaꞌ dimung kesebayaꞌ na samat pegmergaꞌ muʼt dimung diri.’ ");
INSERT INTO plw_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Dut duwang saraꞌ na atue nekebetang ginsan neng Keseraan binggey et Empuꞌ ki Moises bekeꞌ itueng penulduꞌ et mengeꞌ Tarus et Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Sasat negketingtimung itueng mengeꞌ taaw Pariseo, iningkut dye i Jesus, ");
INSERT INTO plw_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Enu pikir myu pasal ki Kristo? Embeng turubuanan minewanan ye?” “Ya in inupuꞌ i Surutan Dabid tagnaꞌ,” sambag dye. ");
INSERT INTO plw_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","“Na baꞌ kwantin pelan,” sugid i Jesus, “Manu takuꞌ tumingkag eset kenye et Begerar itueng si Surutan Dabid ganang lekepan et Nakem et Empuꞌ? Itueng nebres i Surutan Dabid, kwan, ");
INSERT INTO plw_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Binres et Begerar eset daken neng Begerar, kwan ye, Marung ke eset daken neng tampaꞌ kewanan, sekdan na metantu ku mepesukuꞌ dimu itueng mengeꞌ kebanta mu.’ ");
INSERT INTO plw_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Tiban, si Surutan Dabid ne gasi neningkag kenye et Begerar, enukwan mebres na inupuꞌ i Surutan Dabid ating Kristo?” ");
INSERT INTO plw_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kede sembatu kedye kaya nemekesambag, indyari tinegnanan atin neng masa kaya ne mekeseg dye mengingkut eset ki Jesus. ");
INSERT INTO plw_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Pegketbes sinugid i Jesus eset kineldamaʼt taaw bekeꞌ dut kenyeng mengeꞌ pepengenaran, kwan, ");
INSERT INTO plw_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Itueng mengeꞌ menunulduꞌ et Keseraan bekeꞌ mengeꞌ pengibuten neng Pariseo, itueng pegkilelanen megperetiꞌ et Keseraan binggey ki Moises tagnaꞌ tiꞌ. ");
INSERT INTO plw_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Angkansa endelen myu itueng pegtulduꞌ dye bekeꞌ ibuten ginsaʼt itueng kedyeng pegurdin. Segwaꞌ diki lang suliten itueng kedyeng pegbuwaten, sabab kaya dye pegbuwaten itieng kedyeng pegpitua. ");
INSERT INTO plw_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Pemegbetek dye et mebebegat neng pesanen bekeꞌ pepetenggul eset mengeꞌ taaw. Segwaꞌ misan tulduꞌ mendiꞌ dye irikwey apang tumabang na memibit et atin. ");
INSERT INTO plw_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ginsan in pebiꞌbiriʼt sengketaawan itueng kedyeng pegbuwaten. Pepereklaꞌ dye kedyeng mengeꞌ bebresen eset Kesuratan et Empuꞌ na mebibibit dye dut peges bekeꞌ lengen dye. Sampay pepekebuwat yunggu et kedyeng badyuꞌ supaya pebiriꞌ lang ginsan itue dut taaw. ");
INSERT INTO plw_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Peggeayen dye inyet meayad neng eerungan dut kenkeanan bekeꞌ dut unaan neng erungan dut pegrungrupungan et mengeꞌ tawʼt Judio. ");
INSERT INTO plw_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Peggeayen dye na penglingen dut kineldaman neng taaw dut tabuan, bekeꞌ tingkagaʼt Menunulduꞌ, etawa Rabi dut Hinebreo. ");
INSERT INTO plw_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Segwaꞌ kemyu, dyangan kew petingkag et Menunulduꞌ, sabab ginsan kew in megtitipused. Sampay sembatu lang Menunulduꞌ myu, Aku lang. ");
INSERT INTO plw_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Megdemikian kasiꞌ myu pegtingkagiʼt Amaꞌ et misan sinung taaw eset lugtaꞌ, sabab sembatu itueng dimyung Amaꞌ, itieng Empuꞌ Amaꞌ dut langit. ");
INSERT INTO plw_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Etawa kas kew petingkag et Begerar, sabab sembebatu Begerar myu, aku ating Mesias, ingin bersen si Kristo. ");
INSERT INTO plw_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Itueng pinekebantug eset dimyu atin key megmendyaring tindeg myu. ");
INSERT INTO plw_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Itueng pegmetaas, atin ipebaba. Indyari itieng pegpesanad, atin key ipetaas. ");
INSERT INTO plw_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Keeriwaraꞌ dimyu, mengeꞌ menunulduꞌ et Keseraan bekeꞌ mengeꞌ taaw Pariseo! Mengeꞌ pebiꞌbiriꞌ! Pegsegkaan myu itueng mengeꞌ taaw apang diki dye mepegmilikaʼt Empuꞌ. Mendiꞌ kew ne pesakup eset pegmimilik et Empuꞌ, na sampay pegsegkaan myu nega sebarang gaay pesakup! ");
INSERT INTO plw_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Keeriwaraꞌ dimyu mengeꞌ menunulduꞌ et Keseraan bekeꞌ mengeꞌ taaw Pariseo! Mengeꞌ pebiꞌbiriꞌ! Pegeminen myu kebiyagan et kelilibunaʼt balu, bekeꞌ pegdawa myu itieng dimyung pegpenelang et mebuwat. Punsabab et itue lebi ne mebegat ne dimyung dusa! ");
INSERT INTO plw_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Keeriwaraꞌ dimyu, mengeꞌ menunulduꞌ et Keseraan bekeꞌ mengeꞌ taaw Pariseo! Mengeꞌ pebiꞌbiriꞌ! Pegleyagen myu keregatan bekeꞌ pegingkuren myu mengeꞌ sengkebengsaan supaya mekegayat kew lang et misan sembatung tawʼt tumpang, supaya megmendyaring tawʼt Judio. Na baꞌ megayat ne, pegbuwaten myuʼt lebi nega luwas ye eset dimyu, angkansa negmendyaring keruwa teup na sebaban ye apang medusaan dut Narkaꞌ. ");
INSERT INTO plw_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Keeriwaraꞌ dimyu, mengeꞌ beleg neng mengdurundun! Pegtulduꞌ myu, kwan, ‘Na baꞌ itinangeꞌ et misan sinu usalen itueng Benwa naꞌ Pengempuan, sariꞌ lang be. Segwaꞌ baꞌ pegakuꞌ bekeꞌ usalen itueng bulawan dut seled et Benwa naꞌ Pengempuan, subaliꞌ ye tumanen itueng kenyeng itangeꞌ.’ ");
INSERT INTO plw_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Kemyu mengeꞌ dupang naꞌ beleg! Embe takuꞌ lebing mergaꞌ, itueng bulawan etawa ating Benwa naꞌ Pengempuan negpepasek metignaꞌ eset bulawan? ");
INSERT INTO plw_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Pegsugiren myu, kwan, ‘Na baꞌ itangeꞌ et misan sinu itueng simbaan, sariꞌ lang. Segwaꞌ baꞌ itueng itangeꞌ itueng simayaꞌ na eset simbaan, subaliꞌ ye tumanen itueng kenyeng itangeꞌ.’ ");
INSERT INTO plw_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Kemyu mengeꞌ dupang naꞌ beleg! Embe takuꞌ lebing mergaꞌ, itueng simayaꞌ etawa itueng simbaan na negpepasek metignaꞌ dut simayaꞌ? ");
INSERT INTO plw_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Angkansa pesi, baꞌ itangeꞌ et misan sinu, kwan ye, ‘Sabab et itueng ranggar,’ itangeꞌ ye dut ginsan, atin ranggar sampay ne mekesimayaꞌ ne esentin. ");
INSERT INTO plw_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Na baꞌ itangeꞌ et misan sinu, kwan ye, ‘Sabab et itueng Pengempuan na Benwa naꞌ Templo,’ itangeꞌ ye itue sampay Empuꞌ naꞌ mayang megterna duntin. ");
INSERT INTO plw_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Na baꞌ tinangeꞌ et misan sinu, kwan ye, ‘Sabab et itueng langit,’ itangeꞌ ye dut metaas na eerungan et Empuꞌ, kebayaꞌ ne itueng mengeꞌ megearung duntin. ");
INSERT INTO plw_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Keeriwaraꞌ dimyu, mengeꞌ menunulduꞌ et Keseraan bekeꞌ mengeꞌ pengibuten neng Pariseo! Mengeꞌ pebiꞌbiriꞌ! Pegbegey myu dut Empuꞌ itueng ikesempulung bagiꞌ et perinaꞌ kayu bekeꞌ perinaꞌ belagen, segwaꞌ peglipatan myu buwaten itueng lebing mergang tulduꞌ dut Keseraan. Itueng ketignaan, pegingasiꞌ, bekeꞌ ketentuan. Negsugat kew baꞌ buwaten myu atin lebing mergaꞌ, ganang meglahyun myu na buwaten iba in. ");
INSERT INTO plw_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mengeꞌ beleg neng mengdurundun! Pegsenaten myu itueng nek-nek eset dimyung peginumen, segwaꞌ pegtelnen myu itueng kuraꞌ bekeꞌ kaya mebiriꞌ myu! ");
INSERT INTO plw_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Keeriwaraꞌ dimyu mengeꞌ menunulduꞌ et Keseraan bekeꞌ mengeꞌ pengibuten neng Pariseo! Mengeꞌ pebiꞌbiriꞌ! Pegkuskusan myu itieng liwan et tasa bekeꞌ rayaꞌ myu, segwaꞌ samat itieng seled, baha neʼt netimung myu pebiyaꞌ pengreges bekeꞌ keimutan myu. ");
INSERT INTO plw_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Beleg neng Pariseo! Kuskusiꞌ myu mena itueng mengeꞌ seled tasa bekeꞌ rayaꞌ, indyari megmendyaring melinas gasi sampay liwan tiꞌ! ");
INSERT INTO plw_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Keeriwaraꞌ dimyu, mengeꞌ menunulduꞌ et Keseraan bekeꞌ pengibuten neng Pariseo! Mengeꞌ pebiꞌbiriꞌ! Mepesaliꞌ kew eset mengeꞌ lelebngan neng pineputiꞌ, meeayad dut liwan, segwaꞌ dut seled baha neʼt keburukan bekeꞌ tulang et mengeꞌ patey. ");
INSERT INTO plw_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Kwantin mepesaliꞌ kew! Dut penyek et taaw meeayad kew, segwaꞌ itueng keberbenaran baha kew neʼt pebiꞌbiriꞌ bekeꞌ keyeatan. ");
INSERT INTO plw_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Keeriwaraꞌ dimyu, mengeꞌ menunulduꞌ et Keseraan bekeꞌ mengeꞌ pengibuten neng Pariseo! Mengeꞌ pebiꞌbiriꞌ! Pegpetiyegan myu lelebngan et itueng mengeꞌ tarus bekeꞌ pegeyaran itueng mengeꞌ lebeng et mengeꞌ taaw na nemengebiyagan et metignaꞌ. ");
INSERT INTO plw_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Indyari pegbersen myu, ‘Na baꞌ kami teyen negbiyag dut ketimpuan et dameng mengeꞌ keupuꞌupuan, diki kay mekesembatu dut ipepatey itueng mengeꞌ tarus et Empuꞌ.’ ");
INSERT INTO plw_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Dut pegbersen myu neng atin, pegpesebenaran myu na kemyu ne tuꞌ mengeꞌ inupuꞌ et mengeꞌ negpepatey eset mengeꞌ tarus et Empuꞌ! ");
INSERT INTO plw_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ireꞌ! Tebsaꞌ myu itueng mengeꞌ tinegnanan et dimyung keupuꞌupuan. ");
INSERT INTO plw_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Mengeꞌ setwaꞌ! Kemyu neng turubuanan et mengeꞌ taaw neng mengrurunding samat mengeꞌ meraat neng seli! Diki kew mekepelegyu na dusaen dut Narkaꞌ! ");
INSERT INTO plw_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Angkansa pesi, megpebibit Ku dimyu et mengeꞌ tarus, mengeꞌ meuutek, bekeꞌ mengeꞌ menunulduꞌ et Beres et Empuꞌ! Peteyen myu mengeꞌ senu eset kedye, indyari iba in iransang dut krus. Itueng iba in lepsan et dimyung rungrupungan bekeꞌ ekalan dut lungsud seked ibang lungsud. ");
INSERT INTO plw_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Sabab atuꞌ meberbaran et ikedusa myu, dut pegpatey et ginsan neng tawʼt metitignaꞌ et sengketelingkepaʼt dunyaꞌ, mewanan eset pegpatey dut kaya salaꞌ neng si Abel, sekdan dut pegpatey ki Sakarias neng yegang i Barakias. Pinatey et mengeꞌ kegunggurangan myu ya dut eletaʼt Pengempuan na Benwa bekeꞌ simbaan neng tututungan et mengeꞌ simayaꞌ. ");
INSERT INTO plw_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Pegsugiren ku dimyu, itueng kedusaan sabab et ginsan neng itue meberbaran dut mengeꞌ taaw neng tiban neng penimpuen.” ");
INSERT INTO plw_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Pegketbes sinugid i Jesus, kwan ye, “Uy, kemyung tawʼt Jerusalem, uy Jerusalem! Pegpeteyen myu itueng mengeꞌ tarus et Empuꞌ bekeꞌ pegbekalen itueng mengeꞌ pegdeaken ye dut dimyu! Mekesenu ku pegtuyuan na ipaten kemyung ginsan, na samat pegkurumung et sembatung upa eset kenyeng mengeꞌ duruy, segwaꞌ mendiꞌ ke nega. ");
INSERT INTO plw_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Angkansa tantung pinesaran et Empuꞌ ne dimyung lelegdengan. ");
INSERT INTO plw_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Na tiban mesugid ku dimyu, diki myu ne aku mebiriꞌ peuliꞌ, sekdan dumateng itueng timpu na mebres myu, ‘Kenunganan et Empuꞌ teyen dut itueng megderateng dut kepengdyarian et Begerar!’ ” ");
INSERT INTO plw_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Liminiwan si Jesus dut Pengempuan na Benwa naꞌ Templo. Mugad ne ya teyen, ganang nemengabiꞌ itueng mengeꞌ pepengenaran ye, indyari tinulduꞌ kenye keayaran et itueng mengeꞌ derekelang Benwa naꞌ Pengempuan. ");
INSERT INTO plw_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Segwaꞌ sinugid i Jesus kedye, “Nebiriꞌ myu takuꞌ ginsan ating mengeꞌ kelang benwa? Indaniꞌ myu! Dumateng eldew kaya ne metinda misan sembatu benwa. Ginsan neng atin mebubungkar! Kaya ne metinda misan sembatu neng batu dut timbewʼt saliꞌsaliꞌ yeng batu in.” ");
INSERT INTO plw_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Diminuntin de Jesus dut Bukid et Olibo. Sasat ya megearung duntin, kiminabiꞌ kenyeng mengeꞌ pepengenaran supaya petaguꞌ ya iningkut, kwan dye, “Ingyan takuꞌ meinabu pegkerungkat et Pengempuan naꞌ Benwa? Enu takuꞌ megmendyaring tendaꞌ et dimyung pegatuꞌ bekeꞌ itueng ketimpusan et penewnan?” ");
INSERT INTO plw_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Siminambag si Jesus, “Meginget kew na diki kew meekalan et misan sinu! ");
INSERT INTO plw_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Sabab mekansang membut matuꞌ bekeꞌ usalen ngaran ku sampay megsugid, ‘Aku ne tuꞌ Kristo!’ Indyari dye in mekansang meekalan. ");
INSERT INTO plw_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mekekingeg kew et gikgibek et pegbunuan megkabiꞌ dimyu bekeꞌ abar pasal et ibang pegbunuan dut ibang bangsa. Endey kew rumaas. Subaliꞌ meinabu itue, segwaꞌ diki nega itue ketimpusan et sengkedunyaan. ");
INSERT INTO plw_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Sabab memegbunuꞌ itueng bangsa atu dut saliꞌ bangsa bekeꞌ itueng surutan saliꞌ surutan. Ketiksaaʼt urap bekeꞌ yegyeg dut lein-leing bagiꞌ et sengkedunyaan. ");
INSERT INTO plw_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Itueng ginsan tegnanan peꞌ et mengeꞌ keliyutan, samat una-una neng keliyutan dut megyegang. ");
INSERT INTO plw_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Dut mengeꞌ penimpuang atin, pengisegan kew et ginsan sabab et pengandel myu daken. Sampay kemyu ipepirisu apang peliyutan bekeꞌ peteyen. ");
INSERT INTO plw_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Mekansang tumngew eset kedyeng pegandel daken, bekeꞌ megeripuruen eset kede sembatu kedyeng mengeꞌ kesebeyaan, sampay meisgan et kede sembatu. ");
INSERT INTO plw_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Indyari maya dumateng mekeldam membut na tarus bekeꞌ keakal dye et mekansang neng mengeꞌ taaw. ");
INSERT INTO plw_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Sabab et itueng kereatan lemkep, enu pesi memengrungkey itueng pegmergaꞌ et kineldaman. ");
INSERT INTO plw_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Segwaꞌ sebarang dumaran tantu eset pengandel ye seked dut kepuspusan, atin key mebawiꞌ. ");
INSERT INTO plw_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Indyari ipebunayag dut ginsaʼt taaw et sengketelingkepaʼt dunyaꞌ itueng Menunungang Abar pasal et Pengmilikaʼt Empuꞌ apang itue mekilala et ginsan neng bangsa. Mura dumateng kepuspusan et ginsaʼt sengkedunyaan.” ");
INSERT INTO plw_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Sinugid gasi i Jesus, kwan ye, “Dut atin eldew ingyan, mesiyekan myu na ating Mereraat neng Mengrurungkat megtitiyeg dut tengaʼt Pengempuan na Benwa naꞌ Templo. Itueng ketiksaan na pegtudyuen i tarus Daniel tagnaꞌ tiꞌ. Kemyung memematsaꞌ retien itueng pegbersen ku! ");
INSERT INTO plw_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Na baꞌ neinabu ne itue subaliꞌ mengeꞌ tawʼt Judea in memelegyu dut kebukiran. ");
INSERT INTO plw_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Na baꞌ meinabu itue sebarang dut binubungan dyangan ne memikir mineug, apang mengisiꞌ et misan enu negang pengartaꞌ eset kenyeng seled benwa. ");
INSERT INTO plw_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Indyari sebarang dut uma dyangan ne muliꞌ apang mengisiꞌ et kenyeng regmen. ");
INSERT INTO plw_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Keingasiꞌ itieng megebteng bekeꞌ itieng megpeperuruꞌ dut mengeꞌ eldew naꞌ atin! ");
INSERT INTO plw_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ipenelang myu dut Empuꞌ na itueng dimyung pegpelegyu dyangan meginabu et pengdedlekan etawa dut Eldew et Kepeternan. ");
INSERT INTO plw_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Sabab dut atin neng ketimpuan, itueng mengeꞌ taaw mekerasaʼt kelang ketiksaan. Na ingga peꞌ nerasa samat kwantin tihad sengketegnanan na gunaen itueng sengketelingkepaʼt dunyaꞌ seked tiban. Bekeꞌ ganang meinabu itueng timpu et kelang ketiksaan, diki ne melebayan peuliꞌ samat kwantin misan ingyan. ");
INSERT INTO plw_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Na baꞌ diki ne pebeꞌbebaen et Empuꞌ atin neng timpu, kaya ne taaw mebiyag atueʼt dunyaꞌ. Segwaꞌ alang-alang mene eset mengeꞌ taaw piniliꞌ ye, pebeꞌbaen itieng ketimpuan. ");
INSERT INTO plw_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Na baꞌ maya megsugid dimyu, ‘Birinaꞌ, atuꞌ itueng Kristo!’ etawa ‘Esentin ya!’ kas kew penelinga. ");
INSERT INTO plw_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Sabab maya lumiwan mengeꞌ kaya banar naꞌ Kristo bekeꞌ maya mengeꞌ sumbut neng mengeꞌ kaya banar neng tarus. Megpebiriꞌ dyeʼt mengeꞌ metaas naꞌ tendaꞌ bekeꞌ mengeꞌ keliꞌliluꞌ, apang elamen dye baꞌ mekedyari lang, sampay itueng mengeꞌ piniliꞌ et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Indaniꞌ myu. Sabab nesugid ku ne itue dimyu sengketegnanan nega tiꞌ. ");
INSERT INTO plw_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Angkansa na baꞌ isugid dye itue dimyu, ‘Birinaꞌ, duntin ya et kelnangan!’ dyangan kew sumurung duntin. Na baꞌ isugid dye, ‘Birinaꞌ, duntin ya et sisingled!’ dyangan kew menelinga. ");
INSERT INTO plw_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Megsepantun baꞌ enukwan ketikas kumilat mewanan dut sebangan seked pesedpan, kwantin gasi pegatuꞌ ku, ating Yegang et Taaw. ");
INSERT INTO plw_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Samat bersen dye, kwan, ‘Na baꞌ embe esentin mengeꞌ bangkay, duntin gasi negtingtimung itueng mengeꞌ peruni.’ ” ");
INSERT INTO plw_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Megtuy, pegketbes et ketiksaan dut mengeꞌ eldew naꞌ atin, lumingeb eldew, bekeꞌ diki tumbuꞌ bulan, mereregdag mewanan dut langit itueng mengeꞌ bituen, bekeꞌ meyeyegyeg ginsan itueng kepengdyarian et langit. ");
INSERT INTO plw_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Pegketbes peratew eset langit itueng tendaꞌ naꞌ aku, ating Yegang et Taaw. Indyari sumiyak ginsan neng bangsa. Mebiriꞌ dye aku, itueng Yegang et Taaw na eset kunem, megderateng na maya kelang kepengdyarian bekeꞌ kelang kebentugan et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Dut sinyal et mebasag neng budyung et tembuliꞌ, tehagen ku itueng daken mengeꞌ dereakan et Empuꞌ dut epat neng bagiꞌ et dunyaꞌ. Indyari penimungen dye mengeꞌ mengengandel et Empuꞌ na piniliꞌ ye mewanaʼt ginsang bagiꞌ et sengkedunyaan.” ");
INSERT INTO plw_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Indyari, sinugid i Jesus, kwan, “Retien myu itueng penulduꞌ mawaꞌ dut puuʼt igus! Na baꞌ nemenura bekeꞌ negdeuʼt bagu itueng mengeꞌ sanga, sewd myu mekabiꞌ ne bulag. ");
INSERT INTO plw_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Megsepantun gasi, na baꞌ mebiriꞌ myu itueng ginsan meinabu ne, mesewran myu mekabiꞌ ne timpu et pegatuꞌ ku, tumagnaꞌ ne. ");
INSERT INTO plw_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Indaniꞌ myu, meinabu itueng ginsan mura matey itueng mengeꞌ taaw na biyagan tiban. ");
INSERT INTO plw_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Meylang itueng langit bekeꞌ itueng dunyaꞌ, segwaꞌ daken neng beres diki lang meylang.” ");
INSERT INTO plw_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Segwaꞌ kaya misan sembatu kesewd et eldew etawa lisag irateng ku peuliꞌ, misan itueng mengeꞌ dereakan dut langit etawa aku neng Yegang et Empuꞌ. Sabab Empuꞌ Amaꞌ lang nekesewd et itue. ");
INSERT INTO plw_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","38","Itueng pegdateng et Yegang et Taaw, atin mepeantang samat kelang liyud neng tagnaꞌ neng penewnan i Noe. Atin neng masa, mura et kelang liyud, memegkekaan itueng mengeꞌ taaw, pemeginum, bekeꞌ pemengesawa, sekdan atin neng eldew na siminled de Noe lang dut kelang kapal letew. ");
INSERT INTO plw_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Na kaya lang pegsesewran mengeꞌ tawʼt dunyaꞌ na enu meinabu seked peꞌ diminateng ne kelang liyud angkan dye ginsan nebebagus. Megsepantun kwantin gasi neinabu dut pegdateng et aku neng Yegang et Taaw. ");
INSERT INTO plw_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Dut penimpuan et atin, baꞌ maya duwang kelelekian pemengririk dut uma, isien et mengeꞌ dereakan sembatu pesurung dut langit, itektak gasi sembatu in eset ketiksaan. ");
INSERT INTO plw_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Baꞌ maya duwang kelilibunan pemenglebek, isien sembatu et mengeꞌ dereakan pesurung dut langit, itektak gasi sembatu in eset ketiksaan. ");
INSERT INTO plw_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Angkansa pegbetiꞌ kew, sabab diki myu lang mesewran na baꞌ enung eldew matuꞌ itueng dimyung Begerar. ");
INSERT INTO plw_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Indaniꞌ myu itue. Na baꞌ nesewran lang et pegibuten et benwa na baꞌ enung lisag neng gebi dumateng itueng menenakew, ya in megbetiꞌ bekeꞌ diki ye pesaran selden itueng kenyeng benwa. ");
INSERT INTO plw_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Angkansa daran kew megpanyap, sabab dumateng peuliꞌ aku neng Yegang et Taaw atueʼt dunyaꞌ dut timpu na kaya lang nekepanyap kew.” ");
INSERT INTO plw_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Itueng mebentel bekeꞌ meutek neng mengengeradya, atin ya key pinepengerapan et kenyeng begerar dut ibang mengengeradya, apang begeyan dye et kedyeng kekanen eset sugat neng timpu. ");
INSERT INTO plw_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Mesukud ating mengengeradya na baꞌ metkanan ya pegkeradya et kwantin dut pegpeuliꞌ et kenyeng begerar! ");
INSERT INTO plw_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Pegsugiren ku dimyu et keberbenaran, ipemehalaꞌ neʼt begerar atin neng ginsan neng pengartaꞌ ye dut ating mengengeradya. ");
INSERT INTO plw_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Segwaꞌ na baꞌ kaya mebentel ating mengengeradya, isugid ye dut sedseled, ‘Mekwitan nega mura megpeuliꞌ itueng dakeng begerar.’ ");
INSERT INTO plw_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Indyari tegnanan bektulen itueng kenyeng mengeꞌ saliꞌ mengengeradya, indyari mekikaan ne bekeꞌ meginuman ne itueng melelangu. ");
INSERT INTO plw_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Na, megpeuliꞌ ating begerar dut mengengeradya eset eldew na diki lang ya nekepanyap bekeꞌ eset timpu na diki ye mesewran. ");
INSERT INTO plw_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Tantung dusaen ya et begerar, indyari ipelamud eset mengeꞌ taaw naꞌ kaya nengandel dut Narkaꞌ. Duntin sumiyak dye bekeꞌ memengringetnget mengeꞌ nipen dye.” ");
INSERT INTO plw_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Pinenulduꞌ gasi i Jesus kedye eset beleybey, kwan ye, “Atin neng timpu, atuꞌ mepesaliꞌ et pegseled dut Pengmilikaʼt Empuꞌ dut langit. Maya sempulung kebudyangan, nemengliwan apang menusup dut lelaki neng ibulun. Kede sembatu kedye, maya pegbibiten pelitaan dye. ");
INSERT INTO plw_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Itueng lima kedye sempulpuel utek, indyari ating lima gasi in meuutek. ");
INSERT INTO plw_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ating mengeꞌ sempulpuel nememibit et kedyeng pelitaan, segwaꞌ kaya nememibit et nemenglutuꞌ et lana kedye. ");
INSERT INTO plw_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Segwaꞌ itieng mengeꞌ meuutek nememibit et sunuan et lana seririꞌ nega eset kedyeng pelitaan tiꞌ. ");
INSERT INTO plw_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Neemuri et dateng ating lelaki neng ibulun in, angkansa sinulag dye ginsan, nemekeigaꞌ. ");
INSERT INTO plw_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Segwaꞌ ganang tengaꞌ gebi ne, maya memegtingkag, ‘Atuꞌ ne ating lelaki neng bulunen in! Susupaꞌ myu ne!’ ");
INSERT INTO plw_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Megtuy nemegbangun itueng sempulung kebubudyangan bekeꞌ siniluan kedyeng pelitaan. ");
INSERT INTO plw_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Indyari sinugid et sempulpuel utek dut meuutek, ‘Begey kew gasi damen et sengkerit neng lana myu, sabab pekepkerep mene itueng dameng pelitaan.’ ");
INSERT INTO plw_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","‘Kaluꞌ diki megkesdeng itue eset kityung ginsan,’ sambag et mengeꞌ meuutek. ‘Erapun lebing menunga baꞌ sumurung kew mena dut tabuan, mengelen kew ne lang dimyu in.’ ");
INSERT INTO plw_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Indyari nememanew ne itueng limang sempulpuel utek neng mengeꞌ kebubudyangan. Sasat megeelen dye peꞌ, diminateng ne itueng lelaki neng bulunen. Ating lima na nemekepanyap, kebayaꞌ ye siminled dut bubulunan, indyari tinengleb ne lelengewan. ");
INSERT INTO plw_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Pegketbes, diminateng gasi itueng limang sempulpuel utek neng kebubudyangan. ‘Begerar, Begerar! Ipesleraꞌ myu kami!’ tingkag dye. ");
INSERT INTO plw_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Segwaꞌ timinubag ya, ‘Banar be pegsugiren ku dimyu, diki ku kemyu nekilala.’ ");
INSERT INTO plw_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Angkansa megdyaga kew, sabab diki mesewran myu eldew sampay ne lisag dumateng Begerar myu.” ");
INSERT INTO plw_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Atin masa, itueng Pengmilikan et Empuꞌ dut langit mepesaliꞌ et kwantin. Maya sembatung taaw na menglelayag, angkansa pinetingkag ye kenyeng mengeꞌ mengengeradya bekeꞌ pinemilinan in eset kedye et itueng pengartaꞌ ye. ");
INSERT INTO plw_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Binggeyan yeʼt pirak kede sembatu kedye kuyun dut kenye-kenyeng kesesewran. Binggeyan ye sembatu tuꞌ et limang ribu pirak, sembatu tiꞌ gasi duwang ribu pirak, indyari ineʼt sembatu tiꞌ gasi seng ribu pirak. Pegketbes nugad ne ya in dut panew ye. ");
INSERT INTO plw_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Nememanew megtuy itueng mengeꞌ nemeketerima et limang ribu in, negdengdagang ne. Indyari neguntung gasi ya et limang ribu. ");
INSERT INTO plw_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Sepantun kwantin gasi, itieng mengengeradya na neketerima et duwang ribu neguntung gasi et duwang ribu. ");
INSERT INTO plw_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Segwaꞌ itueng mengengeradya na neketerima et seng ribu pirak in kinelian ye lugtaꞌ pegketbes limbeng ye duntin pirak et kenyeng begerar. ");
INSERT INTO plw_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Negketalib et mekwit neng timpu, negpeuliꞌ itueng begerar et mengeꞌ mengengeradya tiꞌ, indyari pinengingkut dye ne. ");
INSERT INTO plw_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Kiminabiꞌ itueng mengengeradya na neketerima et limang ribu pirak, bekeꞌ binibit ye gasi limang ribu pirak neguntung ye, kwan, ‘Begerar, ituꞌ ne limang ribu pirak na binggey mu daken in, nekeuntung ku gasi et limang ribu pirak.’ ");
INSERT INTO plw_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Sinugid kenye et begerar, ‘Menunga banar! Menunga bekeꞌ metignang mengengeradya! Ikew tantung mepengerapan daken dut sengkerit neng siin, angkansa pemehelaen ku ikew et lebing kelang argaꞌ. Sumled ke bekeꞌ meketahak ke et kelang keksegan et begerar mu!’ ");
INSERT INTO plw_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Naꞌ kiminabiꞌ gasi ating mengengeradya na neketerima et duwang ribu pirak in, indyari kwan, ‘Begerar, ituꞌ ne binggey myu neng duwang ribu pirak in. Ituꞌ gasi duwang ribu neuntung ku.’ ");
INSERT INTO plw_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Sinugid et kenyeng begerar, ‘Menunga banar! Menunga bekeꞌ metignang mengengeradya! Ikew tantung mepengerapan daken dut sengkerit neng siin, angkansa pemehelaen ku ikew et lebing kelang argaꞌ. Sumled ke bekeꞌ meketahak ke et kelang keksegan et begerar mu!’ ");
INSERT INTO plw_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Indyari kiminabiꞌ gasi itueng mengengeradya na neketerima et seng ribu pirak in, kwan ye, ‘Sewd ku na ikew tuꞌ meiseg. Pegkeygen mu ating lein mu sinasad, bekeꞌ pegtapasen mu ating lein mu linuwak. ");
INSERT INTO plw_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Timinakut ku, angkansa linebeng ku dut seled lugtaꞌ itueng dimyung pirak. Ituꞌ ne itueng pirak myu neng seng ribu in.’ ");
INSERT INTO plw_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","‘Ikew na sempulpuel bekeꞌ meyahuꞌ neng mengengeradya!’ kwan et begerar ye. ‘Sewd mu ne pelan na megtapas ku et lein ku lang linuwak, bekeꞌ megkeyg ku na lein ku lang sinasad. ");
INSERT INTO plw_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Manu takuꞌ diki mu nega dinatun dut bangku daken neng pirak, na teyen pegpeuliꞌ ku maya neisiꞌ ku pirak ku sampay untung ye tiban?’ ");
INSERT INTO plw_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Indyari, tinehagan ye kenyeng ibang dereakan, kwan, ‘Isiaꞌ myu dut kenye ating seng ribu pirak in, indyari ibgeyaꞌ myu dut maya sempuluꞌ ribu pirak tiꞌ. ");
INSERT INTO plw_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Sabab itieng maya ne, begeyan nega kenye, indyari megsemunsayaꞌ ya. Segwaꞌ itieng kaya, misan ating sengketkerit mene eset kenye isien nega kenye. ");
INSERT INTO plw_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Na, pasal ating mengengeradya na kaya kepulusan, itimbagaꞌ myu ne eset kelingban dut liwan. Duntin sumiyak ya bekeꞌ megringetnget kenyeng nipen sabab et keliyutan.’ ” ");
INSERT INTO plw_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Ganang dumateng aku neng Yegang et Taaw bilang Surutan et ginsan, kebayaꞌ ginsan neng dereakan et Empuꞌ, indyari marung dut metaas neng eerungan ku. ");
INSERT INTO plw_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Atin neng timpu, metitimung eset teteyuman ku ginsang taaw et ginsaʼt mengeꞌ bangsa et sengkedunyaan. Dye in seririen ku eset duwang ketimungan, samat pegbuwaten et mengingipat et mengeꞌ bibili mawaꞌ dut mengeꞌ kambing. ");
INSERT INTO plw_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Iratun ku dut daken neng tampaꞌ kewanan itueng mengeꞌ mengengandel et Empuꞌ, antangen dye samat mengeꞌ bibili. Indyari dut tampaꞌ gibang itieng mengeꞌ ibang taaw antangen dye samat mengeꞌ kambing. ");
INSERT INTO plw_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Indyari iberes ku neng Surutan eset mengeꞌ taaw dut tampaꞌ kewanan ku, ‘Aniꞌ kew ne, mengeꞌ pineruntungan et daken neng Amaꞌ! Sumled kew ne bekeꞌ tumeteg neʼt pegmilik na nepanyap eset dimyu tiharan negaʼt gunaen itueng sengketelingkepan. ");
INSERT INTO plw_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Sabab aku tuꞌ neurapan indyari dimyung pinekaan, tinuknew indyari dimyung pineinum. Aku tuꞌ sembatung tumpang, indyari dimyung pinetindal dut benwa myu. ");
INSERT INTO plw_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Aku tuꞌ kaya mebadyuꞌ, indyari dimyung pinebedyuan, neginglew indyari dimyung pineruri. Aku tuꞌ nepirisu, indyari dimyung inumbeleyan.’ ");
INSERT INTO plw_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Timinubag itueng mengeꞌ mebentel, ‘Begerar, kengyan damen nebirinan ikew neꞌ inurapan, indyari pinekaan kay ikew, etawa netuknew indyari dameng pineinum ke? ");
INSERT INTO plw_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kengyan peꞌ takuꞌ na ikew tuꞌ negmendyaring tumpang, indyari dameng pinetindal, etawa kaya lang mebadyuꞌ bekeꞌ dameng pinebedyuan ke? ");
INSERT INTO plw_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Indyari kengyan peꞌ takuꞌ nebiriꞌ kay na ikew tuꞌ maya sakit etawa dut seled pipirisuan indyari dameng inumbeleyan?’ ");
INSERT INTO plw_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Iberes ku neng Surutan, ‘Pegsugiren ku dimyu, ganang nebuwat myu itue dut pinenguripeng mengeꞌ mengengandel ku tiꞌ, itue na samat nebuwat myu ne daken.’ ");
INSERT INTO plw_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Indyari ibres ku gasi dut mengeꞌ taaw na meilu dut tampaꞌ gibang ku tiꞌ, ‘Perayuꞌ kew eset daken, mengeꞌ tinerwaan et Empuꞌ! Kemyu tuꞌ dut apuy na kaya seskeran dut Narkaꞌ, neng nepanyap tudyu dut ki Seytan bekeꞌ dut kediwataan ye! ");
INSERT INTO plw_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Sabab aku in inurapan, indyari kaya myu pinekaan, tinuknew kaya myu pineinum. ");
INSERT INTO plw_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Aku tuꞌ negmendyaring sembatung tumpang indyari kaya myu pinetindal. Aku tuꞌ neugaraʼt repanan indyari kaya myu pinebedyuan. Aku tuꞌ ininglewan bekeꞌ dut pipirisuan indyari kaya myu inumbeleyan.’ ");
INSERT INTO plw_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Indyari siminambag dye nega, kwan, ‘Begerar, kengyan peꞌ na ikew in nebiriꞌ kay inurapan, tinuknew, negmendyaring tumpang, neugaran et repanan, ininglewan, indyari kaya kay ikew pineruri?’ ");
INSERT INTO plw_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Indyari iberes ku neng Surutan dut kedye, ‘Pegsugiren ku dimyu! Ganang pegimutan myuʼt tabang dut pinenguripeng mengeꞌ mengengandel ku tiꞌ, aku ne atin dimyung inimutan.’ ");
INSERT INTO plw_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Naꞌ, itimbag mengeꞌ itue dut kedusaang kaya seskeran, segwaꞌ itieng mebentel keterima et biyag na kaya seskeran.” ");
INSERT INTO plw_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ganang netbes ne ipenulduꞌ i Jesus ginsang itue, sinugid ye dut kenyeng pepengenaran, ");
INSERT INTO plw_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Samat nesewran myu ne in, duwang eldew mene Kenkaan neʼt Neketalib. Indyari ipegelen ne aku neng Yegang et Taaw, apang iransang dut krus.” ");
INSERT INTO plw_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Atin masa, itueng mengeꞌ pegibuteʼt pariꞌ bekeꞌ mengeꞌ kenggurangaʼt lungsud, sene tiꞌ pemegtingtimung dut kelang benwa et pinekemetaas neng pegibuten neng si Kaipas. ");
INSERT INTO plw_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Pinaru dye na elewen et kaya gibek si Jesus bekeꞌ ipepatey. ");
INSERT INTO plw_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Angkansa sinugid dye, “Dyangan lang dut Kenkeanan, kaluꞌ meeriwaraꞌ mengeꞌ taaw.” ");
INSERT INTO plw_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ganang dut lungsud et Betania, si Jesus eset benwa i Simon neng tegeldew-eldew. ");
INSERT INTO plw_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Sasat si Jesus megkekaan, kiminabiꞌ itueng sembatung libun na megbibibit et katsang alabastro na baha neʼt mergaꞌ banar neng bebengluen. Tinebung ye itue dut ulu i Jesus. ");
INSERT INTO plw_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nemengiseg itueng mengeꞌ pepengenaran ganang mebiriꞌ dye itue. Kwan dye, “Ampaꞌ ne inelulaꞌ ating bebengluen? ");
INSERT INTO plw_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nepeelen teyen atin et mergaꞌ, indyari pinemgey dut mengeꞌ miskin ating nepegelnan!” ");
INSERT INTO plw_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Sewd i Jesus ating kedyeng pegebresen, angkansa kwan ye kedye, “Manu takuꞌ pegeriweraan myu itueng libun? Menunga banar itueng binwat ye daken. ");
INSERT INTO plw_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Misan ingyan kebeꞌbayaꞌ myu itueng mengeꞌ miskin, segwaꞌ aku tuꞌ diki myu mekebeꞌbayaꞌ misan ingyan. ");
INSERT INTO plw_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ingga peꞌ neinabu tinebungan ye ne lagi aku et bebengluen bilang pegpanyap dut peglebeng daken. ");
INSERT INTO plw_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Indaniꞌ myu, misan embe atueʼt sengkedunyaan ipebunayag itueng Menungang Abar, mesugid ne itueng kenyeng nebuwat bilang kerendeman eset kenye.” ");
INSERT INTO plw_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Si Judas Iskariote tuꞌ, sembatu dut sempuluꞌ duwang pepengenaran i Jesus, siminurung dut mengeꞌ pegibuteʼt pariꞌ. ");
INSERT INTO plw_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“Enu takuꞌ ibgey myu daken baꞌ tebangan ku kemyu na mealew si Jesus?” ingkut ye. Megtuy dye ya initungan et telumpulung pirak na emas indyari binggey itue kenye. ");
INSERT INTO plw_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tegnanan et atin, nenulus neʼt timpu apang mepegdagang si Jesus. ");
INSERT INTO plw_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Napet unang eldew et Kenkaan et Bengbang na Kaya Pikembang. Kiminabiꞌ ki Jesus itueng mengeꞌ pepengenaran bekeꞌ nengingkut, “Embe gaay mu na ipegpanyap kay et pengmepunaʼt Kenkaan et Kerendemaʼt Neketalib?” ");
INSERT INTO plw_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Siminambag ya, “Sumurung kew dut lungsud, indyari tulusen myu itueng taaw tuꞌ. Isugiraꞌ eset kenye et kwantin, ‘Binres et Menunulduꞌ, mekabiꞌ ne daken neng timpu. Aku in bekeꞌ daken neng mengeꞌ pepengenaran dut benwa mu mengaan et pengmepunang Kenkaan et Neketalib.’ ” ");
INSERT INTO plw_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Inandel et mengeꞌ pepengenaran itueng tinehagan i Jesus, indyari pinanyap dye ne itueng Kenkaan et Neketalib. ");
INSERT INTO plw_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ganang gimimbi ne, narung ne si Jesus dut perpanggar, kebayaꞌ atin neng sempuluꞌ duwang pepengenaran. ");
INSERT INTO plw_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Sasat megkekaan dye, neres ne si Jesus, “Pegsugiren ku, sembatu eset dimyu megdagang daken.” ");
INSERT INTO plw_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Nemenglumek banar itueng mengeꞌ pepengenaran, indyari pesembatu-sembatu nengingkut kenye, “Begerar, aku tuꞌ takuꞌ a?” ");
INSERT INTO plw_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Siminambag si Jesus, “Itieng megdingan na dumitil eset mangkuk, atin key megdagang daken. ");
INSERT INTO plw_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Matey aku neng Yegang et Taaw kuyun nesurat tagnaꞌ tiꞌ dut Kesuratan et Empuꞌ, segwaꞌ meeriwaraꞌ ating megdagang eset kenye. Lebing menunga diki ne nepengganak itieng taaw.” ");
INSERT INTO plw_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Si Judas tuꞌ, neng megdagang kenye nengingkut nega, “Menunulduꞌ, aku key takuꞌ a?” Siminambag si Jesus, “Ikew ne atin negberes.” ");
INSERT INTO plw_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Sasat memegkekaan dye, nemurut et bengbang si Jesus, indyari netbes ye ga megpeselamat dut Empuꞌ, kenyeng pinegbisbitas ampaꞌ ne binggey eset mengeꞌ pepengenaran ye. Kwan ye, “Kewaaꞌ myu itue bekeꞌ kanen, itue ne daken neng bilug.” ");
INSERT INTO plw_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kineptan ye alak et ubas eset sawan, negpeselamat ki Empuꞌ, indyari binggey eset kedye, kwan ye, “Ginsan kew menginum et itue. ");
INSERT INTO plw_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Sabab itueng alak et ubas antangan ye duguꞌ ku ne, duguꞌ et tendaʼt bagung pinegsulutan et Empuꞌ dut taaw ye. Itue daken neng duguꞌ meulaꞌ dut kemeteyan ku punsabab et kemeapan et mengeꞌ keselaan et kineldaman. ");
INSERT INTO plw_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Pegsugiren ku dimyu na diki ku ne menginum et itueng alak na mewanan et ubas seked dut eldew na itueng bagung alak na inumen ku na kesaru kew dut Pengmilikaʼt daken neng Empuꞌ bekeꞌ Amaꞌ dut langit.” ");
INSERT INTO plw_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Indyari pegkanta et sembatung kanta et Empuꞌ, dye in siminurung ne dut Bukid et mengeꞌ Olibo. ");
INSERT INTO plw_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Bineres i Jesus eset kedye, “Itueng gebi, ginsan kew in tumireng ne daken, na samat nesurat ne dut Kesuratan et Empuꞌ, kwaʼt Empuꞌ, ‘Peteyen ku ne mengingipat, indyari megketkanat ne itueng mengeꞌ bibili et banan.’ ");
INSERT INTO plw_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Segwaꞌ pagkaꞌ megbiyag ku peuliꞌ, meguna ku dimyu dut probinsiya et Galilea.” ");
INSERT INTO plw_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Siminambag si Pedro ki Jesus, “Misan ginsan dye tirengan dimu, diki ku ikew tirengan misan ingyan.” ");
INSERT INTO plw_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Bineres i Jesus si Pedro, “Indaniꞌ be, ituꞌ negang gebi, mura kumerengek lumbuꞌ ketlu mu ne aku ipeilu.” ");
INSERT INTO plw_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Segwaꞌ kinensegan nega i Pedro neres, kwan, “Misan ne aku peteyen kebayaꞌ mu, diki ku ikew ipeilu.” Kwantin gasi itueng pinemeres et ginsan neng pepengenaran. ");
INSERT INTO plw_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Indyari pinebayaꞌ kenyeng mengeꞌ pepengenaran i Jesus dut sembatung luluwakan na pegngeranan Getsemani. Sinugid ye dut kedye, “Atuꞌ kew mena, sasat aku dumuntin bekeꞌ megpenelang ku dut tampar duntin.” ");
INSERT INTO plw_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Segwaꞌ pinebayaꞌ ye si Pedro bekeꞌ duwang yegang i Sebedeo. Indyari timinagnaꞌ ya rumupuk bekeꞌ mesusa itueng kenyeng penedseled. ");
INSERT INTO plw_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Indyari sinugid ye eset kedye, “Itueng seled atey ku baha neʼt kerupukan, pengrasa ku samat matey ku ne in! Tumagey kew atuꞌ bekeꞌ kebayaꞌ kew megsulag daken.” ");
INSERT INTO plw_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Nepereꞌrayuꞌ sengkerit, negpekleb ya ampaꞌ negpenalang, kwan ye, “Amaꞌ ku, na baꞌ mekedyari, iperayunaꞌ daken itueng sawan et itueng keliyutan. Megsepantun kwantin gasi, dyangan lang itueng seled ku, erapun ating gaay et seled mu key na meinabu.” ");
INSERT INTO plw_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Negpeuliꞌ ya dut itieng telung pepengenaran ye, indyari netkanan ye na memegigaꞌ dye. Binres ye ki Pedro, “Tantu be na diki kew mekepesulag na kebayaꞌ myu aku misan seng lisag lang? ");
INSERT INTO plw_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Megsulag kew bekeꞌ megpenelang apang diki meraag et sulay. Geygaay et nakem myu, segwaꞌ merungkey bilug myu.” ");
INSERT INTO plw_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Kasa nega negperayuꞌ si Jesus bekeꞌ negpenalang, “Amaꞌ ku neng Empuꞌ dut langit, na baꞌ diki mekedyari itueng sawan et keliyutan mepetalib daken seked diki ku meinum, meinabu teyen itueng peggeayen mu.” ");
INSERT INTO plw_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Negpeuliꞌ gasi si Jesus dut mengeꞌ pepengenaran, indyari netkanan ye gasi na memegigaꞌ dye nega in, sabab dye tuꞌ pegsusulagen. ");
INSERT INTO plw_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Tinirengan ye gasi peuliꞌ itueng telung pepengenaran, indyari ketelu na negpenalang gasi peuliꞌ, indyari atin nega binres ye peuliꞌ. ");
INSERT INTO plw_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Negpeuliꞌ gasi ya eset mengeꞌ pepengenaran, indyari sinugid ye kedye, “Memegigaꞌ kew nega takuꞌ bekeꞌ pepetaren? Birinaꞌ! Diminateng ne timpu na ipegdagang aku neng Yegang et Taaw eset kepengdyarian et mengeꞌ mekeselaan. ");
INSERT INTO plw_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ireꞌ, pegbekaya kew ne, manew tyu ne. Atuꞌ ne itueng megdagang daken.” ");
INSERT INTO plw_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Megebres nega si Jesus, atin ne pegdateng i Judas, sembatu eset sempuluꞌ duwang pepengenaran i Jesus. Maya megbebayaꞌ kenye mekeldam neng taaw na megbibibit et mengeꞌ keterman bekeꞌ mengeꞌ pupukul, minewanan dye dut mengeꞌ pegibuteʼt pariꞌ bekeꞌ dut mengeꞌ pegibuteʼt lungsud. ");
INSERT INTO plw_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Mura dye dumateng duntin, pinesewd neʼt meakal itueng kwantin neng sinyal, “Itieng imbuan ku, atin ne panew tyu in. Dekepaꞌ myu Ya megtuy!” ");
INSERT INTO plw_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Angkansa kinebiyan i Judas na pinanling si Jesus, kwan, “Megunu ke ga, Menunulduꞌ.” Indyari megtuy ye inimbuan. ");
INSERT INTO plw_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Sinugid kenye i Jesus, “Bilaꞌ, buwataꞌ ne panew mu in.” Indyari kinebiyan ne si Jesus et mengeꞌ taaw bekeꞌ inalew dye ya sampay keptiꞌ banar. ");
INSERT INTO plw_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Nenggabut et keterman sembatung pepengenaran i Jesus. Tinigbas ye dereakan et Pegibuten et Pariꞌ, indyari netigbas telingaʼt atin. ");
INSERT INTO plw_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Sinugid i Jesus kenye, kwan, “Isuubaꞌ dimung keterman! Ginsan dye megusal et keterman, dut keterman nega matey. ");
INSERT INTO plw_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Kaya mu be nesewran na meketeew ku dut daken neng Amaꞌ na lebi nega eset sempuluꞌ duwang panen neng mengeꞌ dereakan et Empuꞌ, indyari pebibitan ye aku megtuy? ");
INSERT INTO plw_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Segwaꞌ enukwan metuman itueng mengeꞌ Kesuratan na negsugid na itue subaliꞌ metuman?” ");
INSERT INTO plw_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Indyari neres ne si Jesus dut kinedraman, kwan, “Aku takuꞌ mengrerampas indyari natuꞌ kew tegeketerman bekeꞌ mengeꞌ pupukul apang mengalew daken? Eldew-pueldew, narung ku bekeꞌ negpenulduꞌ ku dut Pengempuan naꞌ Benwa, indyari kaya myu aku inalew. ");
INSERT INTO plw_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Segwaꞌ meinabu ginsan neng itue, apang metuman itieng sinurat et mengeꞌ tarus et Empuꞌ dut Kesuratan ye.” Nememelegyu ating mengeꞌ pepengenaran, indyari yaya ye mene netektak. ");
INSERT INTO plw_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Binibit si Jesus et mengeꞌ nengalew kenye in dut benwa i Kaipas, ating pinekepegibuten neng Pariꞌ. Duntin negtingtimung itueng mengeꞌ menunulduꞌ et Keseraan bekeꞌ mengeꞌ pegibuten et lungsud. ");
INSERT INTO plw_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Nibut kenye si Pedro, segwaꞌ merayuꞌ eletan dye. Pegdateng dut benwaʼt Metaas neng Pariꞌ, siminled ya dut perpanggar, indyari narung kebayaꞌ dut mengeꞌ mengdidyaga apang meseksian ye baꞌ enu meinabu. ");
INSERT INTO plw_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Megtutulus gasi itueng mengeꞌ pegibuteʼt pariꞌ bekeꞌ ginsan neng tawʼt Bisara neng Sanedrin neng saksiꞌ na mengakal atu ki Jesus, apang mepepatey ya in. ");
INSERT INTO plw_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Segwaꞌ kaya lang metkanan, misan mekeldam tumeyma bekeꞌ pegsugid et keekalan tudyu dut kenye. Ketepus-tepusan, maya duwa timinyeg. ");
INSERT INTO plw_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Indyari negsugid, “Pegsugiren et taaw tuꞌ na rumbaken ye itueng Pengempuan naꞌ Benwa pegketbes beranen ye nega peuliꞌ dut seled telung eldew lang.” ");
INSERT INTO plw_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Timinyeg itueng Metaas naꞌ Pariꞌ bekeꞌ neres ki Jesus, kwan, “Kaya be takuꞌ mesambag mu dut penendes dye dimu tuꞌ?” ");
INSERT INTO plw_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Segwaꞌ kaya giminibek si Jesus. Indyari sinugid kenye et Metaas naꞌ Pariꞌ, “Pegtehagen ku ikew dut ingaran et Empuꞌ na biyag, isugiraꞌ be damen na baꞌ ikew ne tuꞌ Kristo, itueng Yegang et Empuꞌ banar dut langit.” ");
INSERT INTO plw_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Siminambag si Jesus, “Kemyu ne atin negberes. Segwaꞌ pegsugiren ku dimyu, tegnanan tiban mebiriꞌ myu aku neng Yegang et Taaw megearung eset tampaꞌ kewanaʼt Empuꞌ neng mekepengdyarian. Mebiriꞌ myu aku gasi megderateng atueʼt dunyaꞌ eset inarak et langit!” ");
INSERT INTO plw_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ganang mekingeg itue et Metaas neng Pariꞌ, inuyat ye kenyeng diring repanan bekeꞌ neres, “Itue keterwanan dut Empuꞌ! Diki ne keilangan tyu nega saksiꞌ. Nekingeg myu itueng pegterwa ye dut Empuꞌ! ");
INSERT INTO plw_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Enu eset pemikir myu?” Siminambag dye, “Teupen na ya in imeteyen ne!” ");
INSERT INTO plw_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Angkansa inigban dye eset rupa i Jesus bekeꞌ pinegbebektul. Tinpal gasi ya et iba tiꞌ. ");
INSERT INTO plw_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Indyari kwan dye kenye, “Ikew baꞌ si Kristo? Tekeraꞌ be baꞌ sinu siminuntuk dimu!” ");
INSERT INTO plw_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Sementaraꞌ si Pedro megearung dut perpanggar, kinebiyan ya et sembatung uripen neng libun, indyari negberes, “Kebeꞌbayaꞌ mu si Jesus neng tawʼt Galilea, diki be takuꞌ?” ");
INSERT INTO plw_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Segwaꞌ pineiluan ye itue dut elepaʼt ginsan. “Kaya daken nesewran ku itueng pegebresen tuꞌ,” sambag ye. ");
INSERT INTO plw_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Siminurung dut lelengewan et perpanggar si Pedro. Nebiriꞌ gasi ya et sembatung uripen neng libun, bekeꞌ negsugid dut mengeꞌ esentin in, “Itueng lelaki kebeꞌbayaꞌ i Jesus neng tawʼt Nasaret.” ");
INSERT INTO plw_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Negpeilu gasi si Pedro peuliꞌ, kwan ye, “Pegterwa ku kaya kilala ku ating taaw.” ");
INSERT INTO plw_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Sekaliꞌ tuꞌ kiminabiꞌ dye ki Pedro mengeꞌ esentin in, kwan dye, “Tantung ikew ne sembatu eset kedye tiꞌ. Mekekilala eset dimung pememresan.” ");
INSERT INTO plw_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Indyari kwan i Pedro et mebasag, “Katew misan matey ku, tantu na diki ku kilala ating taaw!” sambag i Pedro. Atin ne tiban pegkerengek et lumbuꞌ. ");
INSERT INTO plw_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Indyari nerendeman i Pedro itueng sinugid i Jesus sene tiꞌ, “Mura kumerengek lumbuꞌ, ketlu mu ne aku ipeilu.” Liminiwan ya indyari inukukan neʼt siyak. ");
INSERT INTO plw_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kinerikleman, negtingtimung itueng mengeꞌ pegibuten neng pariꞌ bekeꞌ mengeꞌ kenggunggurangan et sengketaawan pemegisun-isun supaya ipepatey si Jesus. ");
INSERT INTO plw_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Pinengpung dye ya pegketbes binibit ne sampay ibinggey dut ki Gobernador Pilato. ");
INSERT INTO plw_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ganang mebiriꞌ i Judas neng pinegdagang na si Jesus tuꞌ binetangaʼt kemeteyan, negsusun ne ya indyari pineuliꞌ eset mengeꞌ pegibuteʼt pariꞌ bekeꞌ mengeꞌ kegunggurangan itueng mengeꞌ telumpulung pirak naꞌ emas. ");
INSERT INTO plw_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Sinugid ye, “Negkesalaꞌ ne aku tuꞌ! Pinegdagang ku itueng taaw na kaya lang negkesalaꞌ, indyari ya in binetangaʼt kemeteyan.” Sambag mengeꞌ pegibuten, kwan dye, “Enu penglemuren kay? Beꞌbayaꞌ mu ne!” ");
INSERT INTO plw_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Tinimbag i Judas itueng telumpulung pirak naꞌ emas dut seled Pengempuan naꞌ Benwa mura ya nuliꞌ ampaꞌ ne nemikel. ");
INSERT INTO plw_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Pinurut et mengeꞌ pegibuten et pariꞌ itueng mengeꞌ pirak naꞌ emas. Sinugid dye, “Sagkaꞌ dut Keseraan tyu na iratun itueng pirak dut seserakaan et Pengempuan naꞌ Benwa. Sabab itue kebeyaran et biyag et sembatung taaw.” ");
INSERT INTO plw_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Negsembatu pikiran dye na ating pirak ibayad ne dut uma neng mememaal et kuren, apang buwateng lelbengan et mengeꞌ tumpang. ");
INSERT INTO plw_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Angkansa ating uma, pegtingkageʼt mengeꞌ taaw na “Uma et Duguꞌ” seked tiban neng penimpuan. ");
INSERT INTO plw_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Dut kwantin neng antangan netuman itueng sinugid et Empuꞌ pebiyaꞌ tarus ye si Jeremias, kwan, “Insiꞌ dye itueng telumpulung pirak neng emas, ating inergaꞌ kenye et mengeꞌ upuan i Israel. ");
INSERT INTO plw_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Indyari binayad dut uma et mememaal et kuren, kuyun dut tinehagan daken et Begerar.” ");
INSERT INTO plw_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Pineelep si Jesus dut Gobernador, indyari nengingkut Gobernador kenye, “Ikew ne be takuꞌ surutan et mengeꞌ Judio?” Siminambag si Jesus, “Ikew ne atin negberes.” ");
INSERT INTO plw_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Segwaꞌ ganang betangan ya et mengeꞌ pegibuten et pariꞌ bekeꞌ kegunggurangan etawa pegibuteʼt sengketaawan, kaya ne ya siminambag. ");
INSERT INTO plw_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Angkansa sinugid kenye i Pilato, “Kaya be takuꞌ mekekingeg mu itueng mekansang mengeꞌ binetang dye dimu?” ");
INSERT INTO plw_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Segwaꞌ kaya siminambag si Jesus misan senglegtik, angkansa negliluꞌ itueng Gobernador. ");
INSERT INTO plw_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kede Kenkaan et Neketalib, neeratan neʼt Gobernador megpeliwan et sembatung pirisu, na misan sinu mepiliꞌ et tawʼt lungsud. ");
INSERT INTO plw_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Sene tiꞌ, maya sembatung kilala na nepirisu, pegngeranaʼt Barabas. ");
INSERT INTO plw_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Angkansa ganang megtingtimung itueng kineldaman et mengeꞌ taaw, iningkut dye i Pilato, “Sinu takuꞌ gaay myu ipeliwan ku, si Barabas etawa si Jesus na pegngeranaʼt Kristo?” ");
INSERT INTO plw_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Sewd i Pilato na sabab et imbeng lang angkan binibit et mengeꞌ pengibuten et tawʼt Judio si Jesus eset kenye. ");
INSERT INTO plw_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Diki lang atin. Sasat si Gobernador Pilato in megearung dut uukuman, negpesugid eset kenye itueng kenyeng esawa na, “Dyangan ke mekilamud dut taaw na atin, na kaya lang keselaan, sabab kegebi pineliyutan banar aku et daken neng teginep pasal eset kenye.” ");
INSERT INTO plw_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Itueng kineldaman et mengeꞌ taaw gasi pegurungan dye itueng mengeꞌ pegibuten et pariꞌ bekeꞌ kenggurangan et lungsud na tewen ki Pilato na si Barabas ipeliwan, indyari si Jesus ne ipepatey. ");
INSERT INTO plw_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Segwaꞌ pineulian dye gasi ingkuten et Gobernador, “Sinu takuꞌ dut duwa tiꞌ gaay myu ipeliwan ku?” “Si Barabas in!” sambag dye. ");
INSERT INTO plw_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Sinugid kedye i Pilato, “Na baꞌ kwantin, enu buwaten ku ki Jesus na pegtingkagen na Kristo?” Siminambag keginsanan, “Iransang dut krus!” ");
INSERT INTO plw_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Segwaꞌ ingkut i Pilato, “Manu takuꞌ, enu nebuwat ye meyaat?” Segwaꞌ lebi dyeng binensag nega, “Iransang dut krus!” ");
INSERT INTO plw_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ganang nekira-kira i Pilato na kaya mebuwat ye, indyari kaluꞌ lang megeriwaraꞌ itueng kineldaman et mengeꞌ taaw, negpeisiꞌ ya et danum bekeꞌ nemasaꞌ et keremut dut elepaʼt mengeꞌ taaw, kwan ye, “Diki ku pemehelaan kemeteyan et itueng taaw. Pemehelaan dut dimyu!” ");
INSERT INTO plw_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Siminambag itueng mengeꞌ taaw, “Pemehelaan kay bekeꞌ kebayaꞌ ne dameng mengeꞌ keyegangan pasal et pegkepatey ye!” ");
INSERT INTO plw_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Indyari pineliwan ye si Barabas, segwaꞌ pinelepsan ye si Jesus, pegketbes binggey ne kedye apang iransang dut krus. ");
INSERT INTO plw_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Si Jesus tuꞌ binibit et mengeꞌ sundalu dut benwa et gobernador, indyari negtingtimung itueng sengrupungan eset pelilibut kenye. ");
INSERT INTO plw_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Linebasan dye ya bekeꞌ pinebedyuan et sembatung repanan naꞌ meregang banar samat dut surutan. ");
INSERT INTO plw_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Nemupuꞌ dye et mesuksuk neng luluwaken, binaal dye et sepuyuꞌ samat dut surutan, indyari dinatun eset ulu ye, pegketbes pinekeptan et sembatung gegayung eset tampaꞌ kewanan neng lengen samat keptan et surutan. Indyari pinegketkesitan ya, sinelukud-selukuran ya bekeꞌ tinanding, kwan dye, “Bentugen Surutan et mengeꞌ Judio!” ");
INSERT INTO plw_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ya in pinegigban, insiꞌ dye gayung apang ipegpupukul dut ulu ye tiꞌ. ");
INSERT INTO plw_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Indyari pegketbes luluyluluyen dye ne ya, inugaran dye et meregang na repanan ye, pinebedyuan peuliꞌ et diring badyuꞌ, pegketbes pineliwan dye ya apang iransang dut krus. ");
INSERT INTO plw_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Pegliwan dye dut lungsud, nesusup dye itueng sembatung lelaki pegngeranaʼt Simon, sembatung tawʼt Sirene dut bangsa et Aprika. Lineges et mengeꞌ sundalu na ipepsan eset kenye itueng krus i Jesus. ");
INSERT INTO plw_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Pegdatek belnek pegtingkagaʼt Golgota, ingin bersen Belnek et Bengkarak. ");
INSERT INTO plw_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Na duntin binggeyan dye si Jesus et alak na linemuran et ururu na ugaren et sakit. Segwaꞌ ganang mekinaman ye, kaya ne neinum. ");
INSERT INTO plw_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ganang meransang ne ya dut krus, pinegtektahak dye ne kenyeng repanan, metbes mesulayan. ");
INSERT INTO plw_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Indyari narung dye duun apang ya in dyeganan. ");
INSERT INTO plw_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Nekesurat dut tabla na dinatun dye dut dibuwat kenyeng uluan itueng landuꞌ sagkaꞌ dut kenye, kwan atin, “Itue si Jesus, Surutan et mengeꞌ Judio.” ");
INSERT INTO plw_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Duwang mengrerampas kebayaꞌ i Jesus rinansang dut ibang mengeꞌ krus, sembatu in dut tampaꞌ kewanan ye, indyari sembatu in dut tampaꞌ gibang ye. ");
INSERT INTO plw_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Pinegketkesitan si Jesus et mengeꞌ memegtetalib, bekeꞌ pemyungkaꞌyungkaꞌ apang ipelelew dye ya. ");
INSERT INTO plw_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Pegsugiren kenye, “Diki be takuꞌ ikew itueng mengrumbak et Pengempuan naꞌ Benwa, indyari ipetiyeg mu peuliꞌ dut seled telung eldew? Bewinaꞌ tiban dimung diri! Na baꞌ ikew ne tuꞌ Yegang et Empuꞌ, ugaraꞌ bilug mu teyeg et krus supaya mineug ke eset duntin!” ");
INSERT INTO plw_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Megdemikian pinegketkesitan gasi ya et mengeꞌ pegibuten et pariꞌ bekeꞌ mengeꞌ menunulduꞌ et Keseraan bekeꞌ mengeꞌ kenggurangan et sengketaawan. ");
INSERT INTO plw_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Kwan dye, “Binawiꞌ ye iba in, segwaꞌ kenyeng diri diki ye mebawiꞌ! Diki be takuꞌ Ya ne in Surutan et Israel? Baꞌ mineug lang ya tiban eset krus, mengandel ne damen eset kenye! ");
INSERT INTO plw_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Pengandel ya dut Empuꞌ sampay pegsugiran ye, ‘Aku Yegang et Empuꞌ.’ Birinan tyu baꞌ bewinaꞌ ya et Empuꞌ, na baꞌ tantung pegmerganen ya in!” ");
INSERT INTO plw_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Misan mengeꞌ mengrerampas na rinansang dut mengeꞌ krus kebayaꞌ i Jesus penginlelew gasi kenye samat kwantin. ");
INSERT INTO plw_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Na ganang diminateng ne tengaʼt tengeldew, nenglingeb sengketelingkepaʼt dunyaꞌ seked dut lisag telu et mapun. ");
INSERT INTO plw_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ganang mekabiꞌ ne meglilisag telu neʼt mapun, neningkag si Jesus et mebasag, kwan ye, “Eli, Eli, lema sabaktani?” gay bersen, “Empuꞌ ku, Empuꞌ ku, manu takuꞌ pinesaran mu aku?” ");
INSERT INTO plw_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nekingeg itue et mengeꞌ senu eset mengeꞌ megetiyeg esentin in, indyari sinugid dye, “Pegtingkagen ye si Elias!” ");
INSERT INTO plw_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Megtuy diminarak dut kedye sembatu in bekeꞌ nengisiꞌ et belantan, dinitil ye dut megsem neng langgew, dinatun dut yuntuk et sembatung bungbung ampaꞌ ne pinesepsep ki Jesus. ");
INSERT INTO plw_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Segwaꞌ sinugid gasi et iba in, “Tagey mena, siyekan tyu baꞌ dumateng si Elias apang bewinen ya in!” ");
INSERT INTO plw_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Giminerwak peuliꞌ si Jesus, na ibinggey kurudua ye ki Empuꞌ, indyari nebugtuan neʼt ginawa. ");
INSERT INTO plw_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Megtuy neuyat eset tengaꞌ diningding naꞌ kumut dut Pengempuan naꞌ Benwa, mewanaʼt dibuwat pesirib. Giminleng lugtaꞌ, gimintaꞌ mengeꞌ batu, ");
INSERT INTO plw_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","neukaban mengeꞌ lebeng, indyari nemegbiyag itueng mekeldam neng mengeꞌ metignaꞌ et Empuꞌ na nemematey ne. ");
INSERT INTO plw_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Indyari, liminiwan dyeʼt lelbengan. Indyari, pegketbes si Jesus negbiyag peuliꞌ teyeg et kepeteyan, siminurung dye in dut Jerusalem, ating lungsud pegmerganaʼt Empuꞌ, bekeꞌ nebiriꞌ dye duntin dut kineldaman. ");
INSERT INTO plw_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nemeketakut itueng kapitan et mengeꞌ sundalu bekeꞌ mengeꞌ iba ye na megdidiyaga ki Jesus in ganang meresanan dye yegyeg, bekeꞌ meseksian itueng ginsan neng neinabu. Kwan dye, “Tantu na itue Yegang et Empuꞌ!” ");
INSERT INTO plw_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Duntin gasi mekeldam neng kelilibunan na megesiyek tampar dut mereꞌrayuꞌ. Tegnanan nega dut lungsud et Galilea memegsusunud dye ne ki Jesus bekeꞌ megtetabang kenye. ");
INSERT INTO plw_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Kebayaꞌ ne eset kedye in, si Maria Magdalena, si Maria neng induꞌ i Jakob bekeꞌ si Jose, sampay itueng esawa i Sebedeo. ");
INSERT INTO plw_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Mura megmenginsarem, diminateng itueng sembatung deyahan neng tawʼt Arimatea, ingaran ye si Jose. Ya in pepengenaran nega i Jesus. ");
INSERT INTO plw_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Kiminabiꞌ ya ki Gobernador Pilato, indyari tineew itueng bangkay i Jesus. Tinehagan gasi i Pilato na ibgey eset kenye. ");
INSERT INTO plw_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Angkansa inisiꞌ i Jose ating bangkay, indyari binulungan et bagung gedyilew. ");
INSERT INTO plw_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Dinatun ye dut diring lebeng na dingga nekwit kinelian ye dut batu. Pegketbes, pinegulungan ye eset lelengewan et sembatung kelang batu, mura nugad. ");
INSERT INTO plw_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Duntin si Maria Magdalena bekeꞌ itueng sembatu negang Maria, narung eset tengteng et limbengan in. ");
INSERT INTO plw_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ating eldew Biyirnis, na atin Eldew et Pegpanyap et mengeꞌ tawʼt Judio dut Sabadu neng Eldew et Kepeternan dye. Kinedikleman, ganang Eldew et Kepeternan dye, nemegdingdingan ne siminurung dut ki Gobernador Pilato itueng mengeꞌ pegibuten neng pariꞌ bekeꞌ mengeꞌ pariꞌ naꞌ Pariseo. ");
INSERT INTO plw_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Sinugid dye kenye, “Begerar, nerendeman kay ne, na sinugid et atin neng mengrurunding nekeunang biyag nega ya tiꞌ, na ya in kunuꞌ megbiyag nega peuliꞌ teyeg et kepeteyan negketalib et telung eldew. ");
INSERT INTO plw_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Angkansa, menunga baꞌ petungguiꞌ myu et menunga ating limbengan ye seked dut iketlung eldew. Kaluꞌ lang sumurung dun kenyeng mengeꞌ pepengenaran, indyari tekewen itueng bangkay, indyari isugid dut mengeꞌ taaw na ya in negbiyag peuliꞌ teyeg et kepeteyan. Pegketbes itueng emuring pegleug megmendyaring lumebi nega eset una tiꞌ.” ");
INSERT INTO plw_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Sinugid kedye i Pilato, “Pengisiꞌ kew et mengeꞌ sundalu, indyari petungguan et menunga ating lebeng, samat pegpikiren myu.” ");
INSERT INTO plw_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Angkansa nemengduntin dye ne ampaꞌ pinengdetunan et tendaꞌ dut ating kelang batu pinegulungan eset lelengewan bekeꞌ pinetungguan ating lebeng apang metantu dye na diki itue penglemuran et misan sinu. ");
INSERT INTO plw_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Mekelabay Eldew et Kepeternan et mengeꞌ tawʼt Judio, kukueldew et Linggu neng unang eldew et senglinggu, siminurung dut lebeng i Jesus de Maria Magdalena bekeꞌ itueng sembatu negang Maria. ");
INSERT INTO plw_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Megtuy yiminegyeg et mebasag. Nineug mewanan dut langit sembatung dereakan et Empuꞌ, bekeꞌ pinegulung itueng batung neketembel dut lebeng, indyari narung ne dut timbew tiꞌ. ");
INSERT INTO plw_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Deregbesan ye mekepulew na samat kilat, bekeꞌ samat putiꞌ et gedyihilew itueng kenyeng badyuꞌ, siban meneʼt sipal neng keputian. ");
INSERT INTO plw_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Nenggerger et takut itueng mengeꞌ menununggu, indyari negbaꞌ samat patey mene ganang mebiriꞌ dye itueng dereakan et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Segwaꞌ sinugid et dereakan et Empuꞌ dut mengeꞌ kelilibunan, kwan ye, “Kas kew takut. Sewd ku na pegtulusen myu si Jesus na rinansang dut krus. ");
INSERT INTO plw_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Kaya ne Ya atuꞌ, sabab ya in negbiyag ne peuliꞌ na samat kenyeng sinugid in. Aniꞌ kew, siyekiꞌ myu dinetunan kenye niꞌ. ");
INSERT INTO plw_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Na, megtuy, panew kew ne, indyari isugiraꞌ myu dut kenyeng mengeꞌ pepengenaran na ya in negbiyag ne peuliꞌ teyeg et kepeteyan, bekeꞌ neguna ne dut lungsud et Galilea. Mebiriꞌ myu Ya duntin! Indaniꞌ myu itueng pegsugiren ku dimyu.” ");
INSERT INTO plw_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Indyari deꞌdaliꞌ dye ne nugad eset lebeng tiꞌ. Pinegmilikan dyeʼt meglelamud takut bekeꞌ keksan. Indyari agen darak ne siminurung eset mengeꞌ pepengenaran i Jesus apang ituturan itueng neinabu. ");
INSERT INTO plw_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Naꞌ biglaꞌ, sinusup dye i Jesus bekeꞌ pinanling ye kedye, kwan ye, “Kesenangan dimyu.” Indyari nemengabiꞌ dye ne, siminelukud eset kenyeng titikeran ampaꞌ dye ne kinekepan tiked ye supaya nemengempuꞌ dye ne kenye. ");
INSERT INTO plw_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Sinugid kedye i Jesus, “Kas kew takut. Panew kew ne bekeꞌ ipenugiraꞌ myu dut mengeꞌ pepengenaran ku naꞌ samat mengeꞌ ketipusdan ku, na sumurung dye dut probinsiya et Galilea, indyari mebiriꞌ dye aku duntin.” ");
INSERT INTO plw_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ganang memeugad ne mengeꞌ kelilibunan, siminurung gasi dut lungsud et Jerusalem itueng senung mengeꞌ sundalu na nemengtutunggu et lelebengan i Jesus, indyari tinuturan eset mengeꞌ pegibuteʼt pariꞌ itueng ginsan neng neinabu. ");
INSERT INTO plw_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Angkansa nemegtingtimung mengeꞌ pengibuteʼt pariꞌ sampay iba-iba mengeꞌ kenggurangan et sengketaawan. Indyari metbes mekepegrupung dye maya pinegmeupakatan dye, na tinengdanan et kelaꞌ itueng mengeꞌ sundalu, ");
INSERT INTO plw_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","indyari tinehagan dye na, kwan, “Kwantin key ituturan myu, kwan, ‘Sasat memegigaꞌ kay kegebi, natuꞌ itueng kenyeng mengeꞌ pepengenaran, indyari tinakew dye bangkay.’ ” ");
INSERT INTO plw_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Sinugid gasi et mengeꞌ pengibuten dut mengeꞌ sundalu, “Kas kew keraas, misan kerateng itue dut Gobernador, kami mene ipesewd kenye pasal itue ginsan, supaya kaya sasew dimyu.” ");
INSERT INTO plw_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Angkansa tinerima et mengeꞌ memegtutunggu itueng pirak, indyari binwat itueng pemilin kedye. Naꞌ seked tiban, atin nega tuturan nebuar dut mengeꞌ Judio. ");
INSERT INTO plw_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Itueng sempuluꞌ isa neng pepengenaran i Jesus siminurung dut Galilea, dut bukid na tinulduꞌ eset kedye i Jesus. ");
INSERT INTO plw_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ganang nebiriꞌ dye si Jesus, ya in pinengempuꞌ dye, segwaꞌ maya nega mengeꞌ senu megalang-alang. ");
INSERT INTO plw_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Kiminabiꞌ si Jesus bekeꞌ negsugid kedye, kwan ye, “Binggey ne daken ating ginsan neng kepengdyarian dut langit bekeꞌ eset lugtaꞌ. ");
INSERT INTO plw_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Angkansa, panew kew dut ginsaʼt mengeꞌ taaw dut ginsaʼt mengeꞌ bangsa et dunyaꞌ, penulduan myu dye supaya mendyaring dye mengeꞌ pepengenaran ku. Bewtismuan myu dye eset kepengdyarian et Empuꞌ Amaꞌ bekeꞌ Empuꞌ Yegang sampay Empung Nakem. ");
INSERT INTO plw_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Indyari tulduan dye na mibut dut ginsan neng pegtehagan ku dimyu. Indaniꞌ myu, Aku tuꞌ daran mekeiba-iba myu seked ketepus-tepusan et sengkedunyaan.”");
INSERT INTO plw_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Menungang Abar itue pasal ki Jesus Kristo neng Yegang et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Timinagnaꞌ samat sinurat i Isaias neng tarus tagnaꞌ dut kesuratan ye. Bineres et Empuꞌ, kwan, “Kinggaꞌ mu. Ipedaak ku mengengabar ku na meuna dimu. Ya megpanyap et dalan mu. ");
INSERT INTO plw_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Itue beres neng pegbebensag et mengengabar dut kelnangan, kwan, ‘Baꞌ maya sembatung Pegibuten megderateng, pegtignaan bekeꞌ pegpetlangan tyu dalan. Megderateng ne Begerar, angkansa, pegpanyap kew et diri myu.’ ” ");
INSERT INTO plw_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Angkansa, neinabu itue. Diminateng dut kelnangan si Juan neng mememewtismu apang tegnanan ye pegpeabar na megsusun mengeꞌ taaw et keselaan dye bekeꞌ bewtismuan, supaya maapen et Empuꞌ mengeꞌ keselaan dye. ");
INSERT INTO plw_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Mengeꞌ taaw teyeg dut Jerusalem bekeꞌ teyeg dut ginsan neng lungsud et Judea siminurung apang kumingeg kenye. Pegketbes et peglilaꞌ dye et mengeꞌ keselaan dye, binewtismuan ye dye dut danum et Jordan. ");
INSERT INTO plw_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Bulbul et kamelyo badyuꞌ i Juan bekeꞌ kulit bakes ye. Kumetumban bekeꞌ deges et lebten pegkaan ye. ");
INSERT INTO plw_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Itue penulduꞌ na ating pegsugiren ye, “Lebing mekegees ya in pegbikianen ku. Diki ku keteup misan sumelukud apang memabad et siget et tempaꞌ ye. ");
INSERT INTO plw_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Binewtismuan ku kemyu dut danum, segwaꞌ, bewtismuan ye kemyu dut Menungang Nakem.” ");
INSERT INTO plw_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ganang dun negaʼt Judea si Juan sinurungan ya i Jesus teyeg dut Nasaret et Galilea apang bewtismuan ya i Juan dut Danum et Jordan. ");
INSERT INTO plw_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Pegtindal i Jesus dut danum timiningaraꞌ ya bekeꞌ nebiriꞌ ye Menungang Nakem samat aksang megineug kenye teyeg dut lelegdengan et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Nekingeg ye gasi beres teyeg dut lelegdengan et Empuꞌ, kwan, “Ikew yegang na pegkesien ku. Pinanyap mu aku.” ");
INSERT INTO plw_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Pegketbes, pinesurung ya megtuy et Menungang Nakem dut kelnangan. ");
INSERT INTO plw_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Mengeꞌ meklag neng ayup lang iba ye. Timineteg ya duun seked epat neng pulung eldew. Na pegsulayan ya i Seytan, segwaꞌ, tinimuru ya et mengeꞌ dereakan et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Pegketbes nalew si Juan, siminurung si Jesus dut Galilea apang ipabar Menungang Abar teyeg dut Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Timpu ne,” sinugid ye, “Mengmilik ne Empuꞌ. Pegsusun kew sampay mengandel et itueng Menungang Abar.” ");
INSERT INTO plw_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ganang megpepanew dut deplakan et Dagat et Galilea nebiriꞌ i Jesus megtipused, si Simon bekeꞌ si Andres. Pemengrambat sabab meneneraꞌ dye. ");
INSERT INTO plw_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ginayat ye dye, kwan, “Aniꞌ kew. Bayaꞌ kew daken. Samat pegrambat myu et seraꞌ, deaken ku tiban kemyu menulus et taaw apang pebaran apang mengandel dye gasi et Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Tinektak dye megtuy mengeꞌ rambat sampay nayaꞌ kenye. ");
INSERT INTO plw_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ingga peꞌ merayuꞌ nepenewan ye, nebiriꞌ ye megtipused si Santiago bekeꞌ si Juan neng mengeꞌ yegang i Sebedeo. Pegpunaan dye mengeꞌ rambat dut gubang. ");
INSERT INTO plw_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Megtuy ginayat ye gasi dye. Tinektak dye dut gubang amaꞌ dye sampay mengeꞌ taaw neng pegtetengdanan. Nayaꞌ dye kenye. ");
INSERT INTO plw_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Neglembus dye dut Kapernaum. Siminled si Jesus dut sinagoga et Eldew et Kepeternan apang menulduꞌ. ");
INSERT INTO plw_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Negliluꞌ mengeꞌ taaw et pegtulduꞌ ye kedye. Sama ya et taaw neng maya basag, segwaꞌ diki samat mengeꞌ menunulduꞌ et Keseraan. ");
INSERT INTO plw_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Maya lelaki neng negbegbalig et meraat siminled gasi dut sinagoga bekeꞌ mara bebresan ye. ");
INSERT INTO plw_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Enu lamud mu damen, Jesus neng tawʼt Nasaret? Natuꞌ ke takuꞌ apang binesanen mu kami? Kilala kay ikew, Metignaꞌ ke neng teyeg dut Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Binulag i Jesus mengeꞌ meyaat neng nakem, “Kas kegibek. Lumiwan kew kenye.” ");
INSERT INTO plw_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Mura liminiwan dut lelaki meyaat neng nakem pinepulpug ye lelaki sampay giminerwak. ");
INSERT INTO plw_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Negliluꞌ mengeꞌ taaw bekeꞌ negingkut-ingkutan dye, “Enu itue? Bagung tulduꞌ takuꞌ itue? Mebasag banar. Misan mengeꞌ meyaat neng nakem megkingeg baꞌ ya memulag.” ");
INSERT INTO plw_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Metikas limingkep dut mengeꞌ ibang bagiꞌ et lungsud et Galilea abar pasal et keradya ye. ");
INSERT INTO plw_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Pegliwan dye dut sinagoga neglembus dye dut benwa i Simon bekeꞌ i Andres. Iba dye si Santiago bekeꞌ si Juan. ");
INSERT INTO plw_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Pengibanan i Simon neng libun pebubuntul sabab pegegnewan. Sinugid dye megtuy itue ki Jesus. ");
INSERT INTO plw_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Pinekebian ya i Jesus indyari kineptan keremut ye apang ipetiyeg. Timinngew megtuy egnew ye, angkansa, neketimuru ya kedye. ");
INSERT INTO plw_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ganang megurisarem ne binibit ki Jesus ginsan taaw neng tegesakit sampay mengeꞌ negbegbalig. ");
INSERT INTO plw_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kisek mamin-amin mengeꞌ taaw et ating lungsud negtimung dut lelengewan et pegeldengan i Jesus. ");
INSERT INTO plw_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Pinenunga ye mengeꞌ sekiten et mekansang taaw bekeꞌ pineugad ye mengeꞌ meyaat neng nakem. Kaya pinebres ye meyaat neng nakem sabab kilala dye ya. ");
INSERT INTO plw_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kueldew nega pagkaꞌ ingga gikgibek negtiyag si Jesus bekeꞌ yaya lang liminiwan et benwa bekeꞌ kebebenwanan apang menelangin et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Tinulus ya i Simon bekeꞌ mengeꞌ iba ye. Pegkebiriꞌ dye kenye, kwan dye, ");
INSERT INTO plw_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","“Pegtulusen ke et ginsaʼt mengeꞌ taw.” ");
INSERT INTO plw_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Temed sinugid i Jesus, “Sumurung tyu ne lang dut mengeꞌ ibang lungsud apang menulduꞌ gasi duun. Itue sabab angkansa nanew ku atue.” ");
INSERT INTO plw_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Angkansa, linibut ye lungsud et Galilea. Nenulduꞌ ya dut mengeꞌ sinagoga sampay pineugad ye mengeꞌ meyaat neng nakem dut mengeꞌ taaw neng negbegbalig. ");
INSERT INTO plw_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Kasa, nepekabiꞌ ki Jesus sembatung lelaki neng tegeldew-eldew bekeꞌ nepekleb et pegpeingasiꞌ peuru. “Baꞌ mekedyari dimu, ipenunganaꞌ ku.” ");
INSERT INTO plw_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Meingesien si Jesus, angkansa, dinpen ye keremut ye dut lelaki. “Ingin ku numunga ke ne,” sugid i Jesus. ");
INSERT INTO plw_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Pinenunga ya megtuy. ");
INSERT INTO plw_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Indyari pinesurung ya i Jesus bekeꞌ sinugiran ya et kwantin, ");
INSERT INTO plw_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Kasiꞌ itue isugiraꞌ et misan sinu-sinu. Surungiꞌ pariꞌ apang pebiriꞌ ke kenye. Megey ke et sigun et tinahag i Moises apang pebnar dut mengeꞌ taaw na melinis ke ne.” ");
INSERT INTO plw_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Nugad ating taaw neng penenunga i Jesus, segwaꞌ, pinesewd ye dut mengeꞌ taaw baꞌ enu neinabu. Angkansa, kaya ne pepesewd i Jesus dut mengeꞌ taaw baꞌ sumurung ya dut mengeꞌ lungsud. Misan timineteg ya dut kelnangan sinurungan nega ya et mengeꞌ taaw teyeg dut leing-leing lungsud. ");
INSERT INTO plw_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Negpeuliꞌ si Jesus dut lungsud et Kapernaum pegketalib et senung eldew segwaꞌ nebaran et mengeꞌ taaw na nuliꞌ ne ya. ");
INSERT INTO plw_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Negtimung mekansang taaw dut pegeldengan ye seked kaya ne metiyegan misan dut liwan et lelengewan. Ganang pegsusugid ye kedye Menungang Abar pasal et Empuꞌ, ");
INSERT INTO plw_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","maya mengeꞌ taaw nemengdateng megbibibit et sembatung lelaki neng pangkul. Pegpepsanen ya et epat neng kelelekian. ");
INSERT INTO plw_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kaya mekepekabiꞌ dye ki Jesus sabab et mekansang taw, angkansa, linsutan dye sapew dut entek i Jesus. Tinuntun dye lelaki neng pebubuntul et igaan ye. ");
INSERT INTO plw_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ganang nebiriꞌ i Jesus kineradya dye pasal et pengarap dye kenye sinugid ye dut lelaki neng pangkul, kwan, “Yegang, mapen ku mengeꞌ keselaan mu.” ");
INSERT INTO plw_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Temed maya senung Eskriba neng mengeꞌ menunulduꞌ et Keseraan i Moises na megarung duun na pemegingkut-ingkut dut kenye-kenyeng pikiran. ");
INSERT INTO plw_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Manu megbebres et kwantin itueng taw? Keblan ye lengku na mesugid ye mengeꞌ bebresen na Empuꞌ lang teupen meres. Sinu kemaap et mengeꞌ keselaan baꞌ diki Empuꞌ lang?” ");
INSERT INTO plw_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Pegretiꞌ i Jesus na samat kwantin pikir dye, kwantin gasi ingkut ye kedye, “Manu kwantin pikiran myu? ");
INSERT INTO plw_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Embe merugey isugid dut pangkul, ‘Pegmaapen ne mengeꞌ keselaan mu,’ etawa isugid, ‘Teyeg ne. Bitaꞌ igaan mu bekeꞌ panew ne?’ ");
INSERT INTO plw_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Apang mesewran myu na maya basag ku neng Yegang et Taaw mengmaap et mengeꞌ keselaan, ");
INSERT INTO plw_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","tahag ku dimu, ‘Teyeg ne. Bitaꞌ igaan mu bekeꞌ uliꞌ ne.’ ” ");
INSERT INTO plw_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Timinyeg pangkul, bekeꞌ binikyat ye igaan ye. Liminiwan ya dut teteyumanan dye ginsan. Negliluꞌ mengeꞌ taaw bekeꞌ binantug dye Empuꞌ. “Ingga peꞌ nekebiriꞌ kay et samat itue,” sugid dye. ");
INSERT INTO plw_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Siminurung peuliꞌ si Jesus dut deplakan et dagat. Tinulduan ye mekansang taaw neng nepekabiꞌ kenye. ");
INSERT INTO plw_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Peglahyun et panew ye nebiriꞌ ye si Lebi neng yegang i Alpeo. Megarung ya dut pegsukutan et buwis. Ginayat i Jesus, “Bayaꞌ daken.” Timinyeg si Lebi sampay nayaꞌ kenye. ");
INSERT INTO plw_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Neinabu gasi kasa in negpanyap si Lebi dut benwa ye. Ganang megkekaan ne si Jesus bekeꞌ mengeꞌ pepengenaran ye liminamud kenye mengeꞌ menunukut et buwis bekeꞌ mengeꞌ taaw neng tegesalaꞌ. Nepelamud dye dut mengeꞌ taaw neng daran megsusunud kenye. ");
INSERT INTO plw_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Pegkebiriꞌ et mengeꞌ Eskriba et mengeꞌ Pariseo na linemuran ya et itueng mengeꞌ taaw nengingkut dye dut mengeꞌ pepengenaran ye, “Manu megsaru ya dut mengeꞌ menunukut et buwis bekeꞌ mengeꞌ taaw neng tegesalaꞌ?” ");
INSERT INTO plw_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Nekingeg sebarang itue i Jesus bekeꞌ negsugid kedye, “Kaya nengeilangan et mengunguru kaya sakit selyu lang baꞌ tegesakit. Natuꞌ ku apang geyaten na megsusun mengeꞌ maya keselaan, diki mengeꞌ metignaꞌ.” ");
INSERT INTO plw_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Na, tinuud et mengeꞌ pepengenaran i Juan sampay mengeꞌ Pariseo na diki mengaan seked et senung eldew. Maya mengeꞌ taaw siminurung ki Jesus apang iingkut itue kenye. “Manu pegturen et mengeꞌ pepengenaran i Juan bekeꞌ mengeꞌ Pariseo na diki mengaan, temed, mengeꞌ pepengenaran mu pemengaan?” ");
INSERT INTO plw_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Sinugid ye kedye, “Mekedyari takuꞌ metngewan mengaan et mengeꞌ nemengluruk dut bulun kwit sentin nega lelaki neng binulun? Keilangan diki metngewan dye mengaan kwit sentin nega binulun. ");
INSERT INTO plw_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Baꞌ nugad ne kedye lelaki neng binulun mekedyari dye diki mengaan. ");
INSERT INTO plw_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Diki gasi teup itempel bagung kumut dut lelaging kumut. Pegkisek et bagung kumut meuyat lelagi bekeꞌ dumeklaꞌ banar uyat. ");
INSERT INTO plw_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Kwantin gasi dut bagung inumen. Kaya pegsunuꞌ dut lelaging kulit neng susunuan sabab ipelput et inumen lelaging kulit Meulaꞌ inumen sampay saliꞌ dye yumaat. Keilangan bagung inumen isunuꞌ dut bagung susunuan.” ");
INSERT INTO plw_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sembatung Eldew et Kepeternan ganang megpepanew si Jesus kwan, dut ketiriguan, iba ye mengeꞌ pepengenaran ye, nemengurut dye et uhey. ");
INSERT INTO plw_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Iningkut kenye et mengeꞌ Pariseo, “Birinaꞌ. Manu pegkeredyanen et mengeꞌ pepengenaran mu na pegdyenganen atin et Eldew et Kepeternan?” ");
INSERT INTO plw_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Siminambag ya, “Kaya takuꞌ mekebatsaꞌ myu ineluꞌ i Dabid neng pegibuten tagnaꞌ bekeꞌ mengeꞌ iba ye ating masa inurapan dye sabab kaya pegkaan dye? ");
INSERT INTO plw_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Masa et eldew i Abiatar neng pegibuten et mengeꞌ pariꞌ siminled si Dabid dut benwa et Empuꞌ bekeꞌ nengaan et bengbang neng binggey dut Empuꞌ. Nekesurat dut Keseraan et Empuꞌ na mengeꞌ pariꞌ lang mekedyari mengaan et itueng bengbang. Temed kiminaan si Dabid bekeꞌ binggeyan ye mengeꞌ iba ye. ");
INSERT INTO plw_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Pinanduꞌ Eldew et Kepeternan apang ikenunga et mengeꞌ taaw. Diki binaal taaw sabab et Eldew et Kepeternan. ");
INSERT INTO plw_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Angkansa, aku neng Yegang et Taaw maya basag memiliꞌ misan enung keredyanen dut Eldew et Kepeternan.” ");
INSERT INTO plw_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Siminled peuliꞌ si Jesus dut sinagoga. Duntin gasi sembatung lelaki neng patey keremut. ");
INSERT INTO plw_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Pegsisipian dye si Jesus et senung taaw duntin apang mesumbung ya. Pegbirinen dye baꞌ ipenunga ye taaw sabab sungsang dut mengeꞌ Judio baꞌ megkeradya et Eldew et Kepeternan. ");
INSERT INTO plw_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Tinahag i Jesus lelaki neng patey keremut, kwan, “Teyeg. Aniʼt unaan.” ");
INSERT INTO plw_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Iningkut ye dye, “Sungsang takuꞌ megkeradya et menunga baꞌ Eldew et Kepeternan? Diki be sungsang baꞌ megkeradya et meyaat? Embe meyaat keredyanen, memawiꞌ et biyag etawa mematey?” Temed kaya siminambag dye. ");
INSERT INTO plw_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Iseg penyek ye kedye segwaꞌ merupuk ya sabab mektul ulu dye. Tinahag ye lelaki, kwan, “Iktangaꞌ keremut mu.” Nektang ye bekeꞌ niminunga. ");
INSERT INTO plw_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Liminiwan mengeꞌ Pariseo bekeꞌ siminurung megtuy dut mengeꞌ tindeg i Herodes neng pegibuten. Negisun-isun dye baꞌ enukwan peteyen si Jesus. ");
INSERT INTO plw_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Nugad si Jesus iba ye mengeꞌ pepengenaran ye bekeꞌ siminurung dut deplakan et dagat. Nepebiniyan kedye mekansang taaw teyeg dut Galilea bekeꞌ dut Judea. ");
INSERT INTO plw_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Siminurung gasi kenye mekansang taaw teyeg dut Jerusalem, Idumea, Tiro, Sidon, bekeꞌ taaw dut dipag et Jordan sabab nebaran dye mengeꞌ pegkeredyanen ye. ");
INSERT INTO plw_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Pinepanyap i Jesus mengeꞌ pepengenaran sembatung gubang na megamit ye, supaya diki ya merumpiet et mekansang taw. ");
INSERT INTO plw_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Sabab mekansang pinenunga ye, angkansa, pegrumpieten ya et mengeꞌ taaw neng tegesakit apang mekutew dye lang ya. ");
INSERT INTO plw_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Baꞌ mebiriꞌ ya et mengeꞌ taaw neng sinelban et mengeꞌ meyaat neng nakem pepekleb dye dut teteyumanan ye bekeꞌ megegerwak, “Ikew Yegang et Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ininduan dye i Jesus na endey dye isugid baꞌ sinu ya. ");
INSERT INTO plw_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Timinindal si Jesus dut mebudbukid bekeꞌ tiningkag ye sebarang sigun et keinginan ye. Nepekabiꞌ dye. ");
INSERT INTO plw_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Nemiliꞌ ya et sempuluꞌ duwang ketawan na ngaran ye mengeꞌ apostol. Mayaꞌ dye kenye bekeꞌ daaken ye gasi apang menulduꞌ. ");
INSERT INTO plw_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Binggeyan ye dye et basag megpeugad et mengeꞌ meyaat neng nakem baꞌ maya taaw megbegbalig. ");
INSERT INTO plw_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Itue mengeꞌ piniliꞌ ye: Ngaran i Simon sinugpunan ye et Pedro, ");
INSERT INTO plw_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","si Santiago bekeꞌ si Juan neng mengeꞌ yegang i Sebedeo, ngineranan ye dye et Boanerges, gay bersen, “mengeꞌ lelaki neng samat duldug”, ");
INSERT INTO plw_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","si Andres, si Pelipe, si Bartolome, si Mateo, si Tomas, si Santiago neng yegang i Alpeo, si Tadeo bekeꞌ si Simon neng tawʼt Kanaan, ");
INSERT INTO plw_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","sampay si Judas Iskariote neng nengdagang ki Jesus. ");
INSERT INTO plw_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Siminled si Jesus dut sembatung benwa, angkansa, negtimung peuliꞌ mekansang taw. Atin sabab angkansa kaya nekekaan dye. ");
INSERT INTO plw_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ganang nebaran et mengeꞌ usba ye mengeꞌ neinabu siminurung dye duntin apang isien ya sabab negsugid mengeꞌ taaw na nelaman ya et pikiran. ");
INSERT INTO plw_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Sinugid gasi et mengeꞌ Eskriba neng nemengdateng teyeg dut Jerusalem, kwan, “Sinelban ya i Beelsebul, pegibuten et mengeꞌ meyaat neng nakem na megbebgey kenye et basag na megpeugad et mengeꞌ meyaat neng nakem.” ");
INSERT INTO plw_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Angkansa, pinekabiꞌ i Jesus mengeꞌ taaw apang isugid ye kedye mengeꞌ senung karang. “Enukwan mepeugad i Seytan si Seytan? ");
INSERT INTO plw_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Baꞌ megatu-atu dye-megdye mengeꞌ tawʼt sembatung lungsud, diki kesangdan ating lungsud. ");
INSERT INTO plw_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Baꞌ megatu-atu mengeꞌ usba-megusba, diki kesangdan pegusba. ");
INSERT INTO plw_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Baꞌ memanta si Seytan kebanta mengeꞌ siminunud kenye megpekparak ne. Diki ya kesangdan. Keskeran ye ne baꞌ kwantin. ");
INSERT INTO plw_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Diki mekedyaring kesled dut benwa et mebasag neng taaw apang kagew et perekakas ye selyu pungpungen ye mena taaw neng mebasag mura meisiꞌ ye mengeꞌ perekakas dut seled. ");
INSERT INTO plw_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Keberbenaran pegsugiren ku dimyu. Mapen ginsan mengeꞌ keselaan bekeꞌ mengeꞌ penerwa et taw. ");
INSERT INTO plw_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Temed diki mapen misan ingyan mengeꞌ taaw neng megteterwa et Menungang Nakem. Kaya keskeran salaꞌ dye.” ");
INSERT INTO plw_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Sinugid ye itue sabab tinendesan dye na pegseselban ya et meyaat neng nakem. ");
INSERT INTO plw_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Nekeruntin induꞌ bekeꞌ mengeꞌ tipused i Jesus. Dut liwan dye et benwa, temed, maya taaw pinesled dye apang geyaten si Jesus. ");
INSERT INTO plw_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Mekansang taaw megarung et pelibut i Jesus bekeꞌ sinugid dye kenye, “Meputek kay mena pegbersen mu. Dut liwan induꞌ mu bekeꞌ mengeꞌ tipused mu. Pegeyaten dye ikew.” ");
INSERT INTO plw_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Iningkut ye dye, kwan, “Sinu mepantun induꞌ bekeꞌ mengeꞌ tipused ku?” ");
INSERT INTO plw_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Pegseyek ye dut mengeꞌ megarung et pelibut ye sinugid ye, “Itue pantun induꞌ bekeꞌ mengeꞌ tipused ku ");
INSERT INTO plw_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","sabab baꞌ sinu megtutuman et tahag et Empuꞌ itue gasi tipused bekeꞌ induꞌ ku.” ");
INSERT INTO plw_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Timinagnaꞌ peuliꞌ nenulduꞌ si Jesus dut deplakan et dagat. Sabab et mekansang banar taaw pelibut kenye, angkansa, siminakat ya et sembatung gubang. Dut dagat gubang neng pegerungan ye bekeꞌ dut deplakan et dagat gasi mengeꞌ taw. ");
INSERT INTO plw_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Pegkerangen ye lang pegtulduꞌ ye et mekansang neng ginis. Itue sinugid ye. ");
INSERT INTO plw_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Kinggaꞌ myu. Maya mengunguma nanew apang menabug et pungu. ");
INSERT INTO plw_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Pegsabug ye maya pungu na nekapet dut abiʼt dalan. Diminateng mengeꞌ begit apang mengaan et pungu. ");
INSERT INTO plw_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Maya gasi pungu nekapet dut kebebetuan neng mebabew lang lugtaꞌ. Metikas timinuhuꞌ sabab et kaya lang mekapal lugtaꞌ. ");
INSERT INTO plw_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Peginit et eldew nerungley luluwaken sabab kaya mekerarem mengeꞌ gamut. ");
INSERT INTO plw_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Maya gasi nekapet dut lugtaꞌ na maya beririꞌ tagnaꞌ. Timinunas mengeꞌ beririꞌ angkan neternung mengeꞌ luluwaken neng timinuhuꞌ in, angkansa kaya nuaꞌ. ");
INSERT INTO plw_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Mengeꞌ iba nekapet dut menungang lugtaꞌ. Timinuhuꞌ bekeꞌ negbaraꞌ sampay kiminansang elinseg. Maya nuaꞌ et tegtelumpulung elinseg, tegenem neng pulung elinseg bekeꞌ tegsenggatus neng elinseg.” ");
INSERT INTO plw_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Sinugid i Jesus kedye, “Baꞌ maya taaw meingin megkesewd keilangan kumingeg.” ");
INSERT INTO plw_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ganang yaya mene si Jesus mengingkut kenye sempuluꞌ duwang pepengenaran ye bekeꞌ mengeꞌ ibang taaw pasal et mengeꞌ karang. ");
INSERT INTO plw_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Sinugid ye kedye, kwan, “Pinesewd dimyu mengeꞌ taguꞌ pasal baꞌ enukwan mengmilik Empuꞌ. Temed dut mengeꞌ ibang taaw neng mendiꞌ mengandel pegtulduꞌ itue pinebiyaꞌ et karang. ");
INSERT INTO plw_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Atin meinabu apang, ‘Pegseyek dye diki masip misan kebiriꞌ dye. Pegkingeg dye diki keretiꞌ misan mekingeg dye, apang diki dye kepeuliꞌ dut Empuꞌ. Diki gasi mapen mengeꞌ keselaan dye.’ ” ");
INSERT INTO plw_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Iningkut ye kedye, “Ingga peꞌ takuꞌ neretian myu itueng karang? Baꞌ kwantin enukwan meretian myu ibang mengeꞌ karang? ");
INSERT INTO plw_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Itue retian et karang. Pegsabug et mengunguma atin samat pegtulduꞌ et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Maya mengeꞌ taaw samat lugtaꞌ dut abiʼt dalan na neptan et pungu. Pegkingeg dye et beres et Empuꞌ diminateng si Seytan apang ugaren beres neng tinulduꞌ kedye. ");
INSERT INTO plw_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","“Pegkingeg et mengeꞌ iba et beres samat kebebetuan na neptan et pungu. Nenep dye sabab tinerima dye megtuy mengeꞌ beres. ");
INSERT INTO plw_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Temed kaya timineteg dut pikiran dye beres et Empuꞌ, angkansa, kaya diminaran dye. Pegdateng et keliyutan bekeꞌ sawey sabab et pegterima et beres negmendiꞌ dye megtuy. ");
INSERT INTO plw_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","“Mengeꞌ ibang taaw samat maya beririꞌ tagnaꞌ naꞌ neptan et pungu. Kiningeg dye beres et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Pemikir dye pasal et mengeꞌ kesesewan alang et kebiyagan dye bekeꞌ keblan dye mekepesanang mengeꞌ mergang ginis sampay ibang keinginan seked pegternungen beres et Empuꞌ. Angkansa, kaya negbaraꞌ dye. ");
INSERT INTO plw_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","“Temed mengeꞌ iba samat menungang lugtaꞌ neng neptan et pungu. Pegkinggen dye bekeꞌ pegterimanen beres sampay negbaraꞌ dye. Samat pegbuaꞌ et luluwaken sinungtuan dye. Maya nuaꞌ et kikisek bekeꞌ maya mekansang sampay maya nuaꞌ et mekansang banar.” ");
INSERT INTO plw_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Iningkut i Jesus kedye, kwan, “Pegpegketan takuꞌ pelitaan apang tekpan et gentangan etawa dut sirib et igaan? Diki takuꞌ apang iratun dut deretunan et pelitaan? ");
INSERT INTO plw_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Sabab kaya pegtetaguꞌ na diki meblad bekeꞌ kaya lang ginis na taguꞌ na diki ipesewd. ");
INSERT INTO plw_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Baꞌ maya taaw meingin megkesewd keilangan kumingeg.” ");
INSERT INTO plw_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Sinugid ye kedye, “Retiaꞌ myu et menunga sebarang mekekingeg myu,” kwan ye. “Baꞌ enu pegemiten myu neng penukud megdemikian kwantin gasi isukud dimyu et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Dugangan nega mayang maya ne, temed isien nega dut kurang itieng kisek na dut kenye.” ");
INSERT INTO plw_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Sinugid nega i Jesus, kwan, “Kwantin mengmilik Empuꞌ dut taw. Samat sembatung lelaki neng megsesasad et pungu dut lugtaꞌ. ");
INSERT INTO plw_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Eldew gebi baꞌ megigaꞌ etawa megtitiyag menenasad megtutuhuꞌ bekeꞌ megbebaraꞌ pungu misan kaya mekesewran et lelaki baꞌ enukwan. ");
INSERT INTO plw_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Pepetuhuꞌ bekeꞌ pepebuaꞌ et lugtaꞌ mengeꞌ luluwaken. Deun mena, mura uheyen, pegketbes dumunguk. ");
INSERT INTO plw_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Baꞌ lutuꞌ ne, pepekeyg itue sabab sereng ne keygen.” ");
INSERT INTO plw_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Nengingkut gasi si Jesus, “Samat enung ginis kebnaran megmilik banar Empuꞌ? Enung karang gemiten tyu apang itulduꞌ itue? ");
INSERT INTO plw_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Samat elinseg et mustasa itue. Kikisek et ginsan neng alit na ipegluwak dut lugtaꞌ. ");
INSERT INTO plw_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Temed baꞌ linuwak ne pegbaraꞌ bekeꞌ megdeklaꞌ et ginsan neng tutulnuen. Megsanga itue et merapaꞌ, angkansa, mekepugad mengeꞌ begit dut sirib ye.” ");
INSERT INTO plw_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Beres et Empuꞌ daran pegkarang i Jesus dut mengeꞌ taaw sigun et megesan et pengretiꞌ dye. ");
INSERT INTO plw_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Kaya pegbiseranen ye dye baꞌ diki ikarang ye. Pinesewd ye ginsan neng retian et karang dut mengeꞌ pepengenaran ye baꞌ diri ye mene. ");
INSERT INTO plw_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Megegebi ne et ating eldew sinugid i Jesus dut mengeꞌ pepengenaran ye, kwan, “Dumipag tyu dut sembelang deplakan et dagat.” ");
INSERT INTO plw_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Tinirengan dye mengeꞌ taw. Siminakat gasi mengeꞌ pepengenaran et gubang neng pegerungan i Jesus bekeꞌ nemenulak. Maya nega ibang gubang kedingan dye. ");
INSERT INTO plw_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Dinetengan dye et mebasag banar neng ribut. Tinumpilan et mengeꞌ gumbang gubang seked kisek mebaha. ");
INSERT INTO plw_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Megigaꞌ si Jesus et bantal dut embut et gubang. Tiniyag ya et mengeꞌ pepengenaran bekeꞌ iningkut dye ya, kwan, “Menunulduꞌ, kaya takuꞌ megraas ke megtetgeb tyu ne?” ");
INSERT INTO plw_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Negbangun ya. Indyari binulag ye deres bekeꞌ tinahag ye dagat, kwan, “Kas kegibek! Tengew!” Timinngew deres sampay limininew dagat. ");
INSERT INTO plw_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Iningkut ye kedye, “Manu megtetakut kew? Kayangga peꞌ takuꞌ pegandel myu daken?” ");
INSERT INTO plw_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Timinakut dye banar bekeꞌ nengingkut-ingkut dye, kwan, “Sinu takuꞌ itue? Misan deres bekeꞌ dagat penelinga kenye!” ");
INSERT INTO plw_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Diminipag dye dut sembelang dagat dut lungsud et mengeꞌ taaw et Geraseno. ");
INSERT INTO plw_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Pegineug i Jesus et gubang sinusup ya megtuy et lelaki neng pegseselban et meyaat neng nakem. ");
INSERT INTO plw_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Kelelbengan pegeldengan et lelaki. Kaya ne ya mekepungpung misan rantay nega gemiten. ");
INSERT INTO plw_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Daran pegpungpungen et rantay keremut bekeꞌ tiked ye temed pinegliligtuꞌ ye lang rantay dut keremut ye sampay binugtuꞌ besiꞌ dut tiked ye. Kaya taaw mekeraag kenye. ");
INSERT INTO plw_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Eldew gebi pegbegbensag ya dut kelelbengan bekeꞌ dut kebudbuluran. Pepetewanan ye et batu diri ye. ");
INSERT INTO plw_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Merayuꞌ nega ya ganang nepayag ye si Jesus. Diminarak ya apang pekleb dut teteyumanan i Jesus. ");
INSERT INTO plw_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Giminerwak ya et mebasag banar, kwan, “Jesus, Yegang et Empuꞌ neng pegbentugen et ginsan, enu lamud mu daken? Pegpeingasiꞌ ku dimu pebiyaꞌ et Empuꞌ na kasiꞌ ku peliyutiꞌ.” ");
INSERT INTO plw_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Sabab et itue tinahag i Jesus kenye, kwan, “Meyaat neng nakem, mugad ke et lelaki.” ");
INSERT INTO plw_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Iningkut kenye i Jesus, “Sinu ingaran mu?” “Rungrupung ingaran ku,” sinambag et lelaki, “sabab mekansang kay.” ");
INSERT INTO plw_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Tineew dye peuliꞌ ki Jesus na endey dye ipeugad dut ating sakup. ");
INSERT INTO plw_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Maya pepehenen et mekansang biyek neng pemenginan dut kikilid et bulud na mekabiꞌ kedye. ");
INSERT INTO plw_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Negpeingasiꞌ ki Jesus mengeꞌ meyaat neng nakem, “Iperelinaꞌ kay dut mengeꞌ biyek apang kesaleb kay kedye.” ");
INSERT INTO plw_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Tinugutan ye dye. Liminiwan mengeꞌ meyaat neng nakem dut lelaki bekeꞌ sinelban dye mengeꞌ biyek. Nepetibukad surung dut pengpang pepehenen neng biyek na duwang ribu. Neregdag dut dagat sampay nelmes. ");
INSERT INTO plw_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Nelegyu mengeꞌ mengingipat et mengeꞌ biyek, bekeꞌ ipinengabar dye itue dut kebebenwanan bekeꞌ dut kebudbukiran. Diminarak mengeꞌ taaw apang kebiriꞌ baꞌ enu neinabu. ");
INSERT INTO plw_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Pegdateng ki Jesus nebiriꞌ dye lelaki neng sinelban et mekansang meyaat neng nakem tagnaꞌ. Megarung ya bekeꞌ megbebadyuꞌ ne. Menunga ne pikiran ye, angkansa, timinakut dye. ");
INSERT INTO plw_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Nemegbisara-bisara mengeꞌ taaw pasal et neinabu dut lelaki bekeꞌ dut mengeꞌ biyek. ");
INSERT INTO plw_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Angkansa, tineew dye ki Jesus na teyen mugad dut lungsud dye. ");
INSERT INTO plw_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Mura siminakat si Jesus dut gubang kiminabiꞌ kenye lelaki neng sinelban et mengeꞌ meyaat neng nakem tagnaꞌ. Tinew ye na mayaꞌ kenye. ");
INSERT INTO plw_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Temed negmendiꞌ si Jesus. Kwan ye, “Uliꞌ ne tiban dut keusbaan mu. Isugiraꞌ kedye mengeꞌ menungang ineluꞌ et Empuꞌ dimu sampay baꞌ enukwan gasi ya neingasiꞌ dimu.” ");
INSERT INTO plw_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Nugad ya bekeꞌ pinabar ye dut tawʼt Dekapolis mengeꞌ ginis neng ineluꞌ i Jesus kenye. Negliluꞌ mengeꞌ taaw neng kiminingeg kenye. ");
INSERT INTO plw_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Pegdipag peuliꞌ i Jesus dut sembelaꞌ negtimung mekansang banar taaw pelibut kenye dut deplakan et dagat. ");
INSERT INTO plw_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Diminuntin si Jairo neng sembatung lelaki na megkekpet et mengeꞌ taaw neng pemegtimung dut sinagoga. Pegkebiriꞌ ye ki Jesus nepekabiꞌ ya bekeꞌ siminelukud dut teteyumanan ye. ");
INSERT INTO plw_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Timinew kenye et asiꞌasiꞌ banar, kwan, “Mekelpusan budyang ku. Pegtewen ku teyen dimu na mayaꞌ ke daken. Idepnaꞌ mena teyen keremut mu kenye apang numunga ya.” ");
INSERT INTO plw_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Nayaꞌ si Jesus kenye. Sinelundungan ya et mekansang banar mengeꞌ taaw neng nengrumpiet kenye. ");
INSERT INTO plw_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Maya libun duntin na seled et sempuluꞌ duwang teun ne peduꞌduguꞌ kenye. ");
INSERT INTO plw_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Negsusa ya banar sabab et peguru-uru et mengeꞌ mengunguru kenye. Namin pirak bekeꞌ pengartaꞌ ye et pegpeuru, temed, kaya lang negnunga gamlang susulu kiminansang. ");
INSERT INTO plw_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Pegkabar ye pasal ki Jesus negpesitsiet gasi ya dut mengeꞌ taaw seked nekepekabiꞌ et lilikuran i Jesus apang tuldingen ye badyuꞌ i Jesus. ");
INSERT INTO plw_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Sabab pinikir ye, “Numunga ku misan badyuꞌ ye lang metulding ku.” ");
INSERT INTO plw_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Pegtulding yeʼt badyuꞌ i Jesus timinngew megtuy pegduꞌduguꞌ ye bekeꞌ neresanan ye na menunga ne ya et peresaan ye. ");
INSERT INTO plw_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Neresanan megtuy i Jesus na maya basag liminiwan set kenye. Liminingew ya dut mengeꞌ taaw bekeꞌ nengingkut. “Sinu timinulding et badyuꞌ ku?” ");
INSERT INTO plw_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Siminambag kenye mengeꞌ pepengenaran ye, kwan, “Enu be atin? Mekebiriꞌ mu ne na pegrurumpieten ke et mengeꞌ taw, temed pengingkut ke nega baꞌ sinu timinulding dimu?” ");
INSERT INTO plw_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Temed meglilingew-lingew nega si Jesus apang mebiriꞌ ye baꞌ sinu timinulding et badyuꞌ ye. ");
INSERT INTO plw_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Neretian et libun neinabu kenye, angkansa, nepekabiꞌ bekeꞌ nepekleb dut teteyumanan i Jesus. Giminerger ya sabab et takut. Linilaꞌ ye ginsan keberbenaran neng neinabu kenye. ");
INSERT INTO plw_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Sinugid i Jesus kenye, kwan, “Libun, pinenunga ke sabab et pegandel mu daken. Mugad ke ne et menungang pemilugan bekeꞌ megnunga ke banar et peresaan mu.” ");
INSERT INTO plw_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Megbebres nega si Jesus maya taaw diminateng teyeg dut benwa i Jairo apang ipabar itue kenye. “Patey ne yegang mu,” kwan dye. “Endey ne sesewen Menunulduꞌ.” ");
INSERT INTO plw_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Kaya inasip i Jesus bineres dye. Gamlang sinugid ye itue ki Jairo, “Kas raas. Mengandel ke lang daken.” ");
INSERT INTO plw_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Kaya iba pinebayaꞌ ye baꞌ diki si Pedro bekeꞌ si Santiago sampay si Juan lang neng tipused i Santiago. ");
INSERT INTO plw_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Pegdateng dye de Jairo dut benwa ye nebiriꞌ i Jesus na mesasew mengeꞌ taw. Megsisisiyak dye et mebasag sampay pemengerirung. ");
INSERT INTO plw_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Pegseled dye iningkut i Jesus dut mengeꞌ taw, kwan, “Manu ginsaʼt itue pemegsasew bekeꞌ megsisiyak? Diki patey yegang erapun megigaꞌ lang.” ");
INSERT INTO plw_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Temed sinawey ya et mengeꞌ taw. Pineliwan ye dye ginsan lyu et telung pepengenaran ye bekeꞌ gunggurang et budyang. Siminled dye dut pegbubuntulan et budyang in. ");
INSERT INTO plw_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Kineptan i Jesus keremut et budyang bekeꞌ itue tinahag kenye, “Talita kumi” na retian, “Budyang, teyeg ne.” ");
INSERT INTO plw_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Timinyeg megtuy budyang bekeꞌ nekepanew. Negliluꞌ banar gunggurang ye. Sempuluꞌ duwang teun ne umur et budyang. ");
INSERT INTO plw_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Asiꞌasiꞌ banar penektak i Jesus kedye na endey ipesewd itue dut misan sinu. Pinerendem ye gasi na begeyan et pegkaan budyang. ");
INSERT INTO plw_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Nugad si Jesus duntin apang muliꞌ dut minewanan ye. Nayaꞌ kenye mengeꞌ pepengenaran ye. ");
INSERT INTO plw_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Pegeldew et Kepeternan tinulduan ye mengeꞌ taaw neng siminled dut sinagoga. Negliluꞌ mengeꞌ taaw neng nekekingeg kenye, angkansa, nengingkut dye, “Embe minewanan et mengeꞌ tulduꞌ ye? Enu itueng kesewran na inigbey kenye? Enukwan binaal ye mengeꞌ keliluꞌlilung keradya? ");
INSERT INTO plw_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Mememaal lang et benwa lengku itueng taw. Yegang ya i Maria bekeꞌ tipused i Santiago, i Jose, i Judas bekeꞌ i Simon. Liminegdeng atue mengeꞌ tipused yeng libun, diki be?” Angkansa, nengahaꞌ mengeꞌ taaw kenye bekeꞌ sabab nengimbeng dye kenye. ");
INSERT INTO plw_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Pegketbes sinugid i Jesus kedye, kwan, “Pegtewtewen et mengeꞌ taaw tarus dut ibang mengeꞌ lungsud temed kaya pegesipen ya et binenwa ye bekeꞌ keusbaan ye sampay mengeꞌ ibang taaw dut diri yeng lungsud.” ");
INSERT INTO plw_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Kaya kelang keliluꞌlilung keradya neluꞌ i Jesus duntin. Selyu ga ating senu-senung taaw na mesakit dumpen ye et keremut sampay pinenunga ye dye. ");
INSERT INTO plw_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Negliluꞌ si Jesus sabab mendiꞌ dye mengandel. Nepelatun-latun si Jesus dut mengeꞌ ibang rurungan apang menulduꞌ. ");
INSERT INTO plw_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Sembatung eldew binisara i Jesus sempuluꞌ duwang pepengenaran ye apang ipesurung ye dye tegduruwa dut mengeꞌ taaw duntin. Binggeyan ye dye et basag apang ipeugad mengeꞌ meyaat neng nakem. ");
INSERT INTO plw_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Tinahag ye dye, kwan, “Kas kew bibit misan enu lyu et susungkud. Endey mibit et kekanen, tiptingkep sampay pirak. ");
INSERT INTO plw_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Pegtempaꞌ kew lang bekeꞌ endey meglapis et badyuꞌ.” ");
INSERT INTO plw_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Tinahag ye gasi dye, kwan, “Baꞌ embeng benwa tindalan myu, duntin tetegiꞌ myu seked mugad kew et ating lungsud. ");
INSERT INTO plw_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Baꞌ diki kew terimanen et misan enung lungsud etawa mendiꞌ dye kumingeg et beres myu, tultugaꞌ myu tehuk et tiked myu mura kew mugad duntin, na sembatung pebnar na inistiaran dye ne.” ");
INSERT INTO plw_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Angkansa, nanew dye apang itulduꞌ na keilangan susunan et mengeꞌ taaw keselaan dye. ");
INSERT INTO plw_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Nepeugad dye mekansang meyaat neng nakem. Pineyran dye et lana et olibo mengeꞌ taaw neng tegesakit sampay pinenunga ye dye. ");
INSERT INTO plw_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Nebaran i Herodes neng pegibuten mengeꞌ neinabu. Kilala ne banar ingaran i Jesus. Keblan et senung taaw negbiyag peuliꞌ si Juan neng mememewtismu, angkansa, mekedyari balen ye mengeꞌ keliluꞌlilung keradya. ");
INSERT INTO plw_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","“Ya si Elias,” kwaʼt mengeꞌ iba. Keblan gasi et mengeꞌ iba na tarus ya samat mengeꞌ tarus tagnaꞌ. ");
INSERT INTO plw_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Temed pegkabar i Herodes sinugid ye, “Negbiyag peuliꞌ si Juan neng mememewtismu, taaw neng pineputkan ku et liyeg.” ");
INSERT INTO plw_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Sabab et inangat i Herodias bekeꞌ kineradya i Herodes sabab gasi et sumbung i Juan. Sinulayan i Juan dyenganen pegbeꞌbayaꞌ i Herodes ki Herodias neng esawa et tipused yeng si Pelipe. ");
INSERT INTO plw_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Tinumpelakan i Juan si Herodes tagnaꞌ. “Sungsang et Keseraan baꞌ ipeiba esawa et tipused mu,” kwan ye. ");
INSERT INTO plw_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Niseg si Herodias ki Juan, angkansa, ingin ye peteyen si Juan. Temed kaya mebaal ye. ");
INSERT INTO plw_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Sabab takut si Herodes ki Juan, angkansa, pinepetungguan ye ya. Nesewran i Herodes na menunga bekeꞌ metignaꞌ neng taaw si Juan. Ingin ye kumingeg baꞌ meres si Juan temed pegkekingeg ye kenye nesasew pikiran ye. ");
INSERT INTO plw_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nekerateng timpu apang meles si Herodias ki Juan. Negpepanyap si Herodes et kelang kenkaan sabab umanat ye. Inangey ye mengeꞌ pegibuten et gobyerno bekeꞌ mengeꞌ pegibuten et mengeꞌ sundalu sampay mengeꞌ begerar dut Galilea. ");
INSERT INTO plw_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Siminled yegang i Herodias neng libun apang megtarek. Pinenep ye banar si Herodes bekeꞌ ginsan taaw duntin, angkansa, sinugid i Herodes kenye, kwan, “Tewaꞌ daken misan enung neinginan mu, begeyan ke.” ");
INSERT INTO plw_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Negtangeꞌ nega si Herodes kenye, “Misan enung tewen mu daken ibgey ku dimu seked tengaꞌ et pegmilik ku.” ");
INSERT INTO plw_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Liminiwan budyang supaya ingkuten ye induꞌ ye. “Enu tewen ku?” Itue sinambag ye, “Ulu i Juan neng mememewtismu.” ");
INSERT INTO plw_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Negpeuliꞌ ya megtuy ki Herodes. Sinugid ye kenye, “Ingin ku igbey mu daken tiban ulu i Juan na iratun et rayaꞌ.” ");
INSERT INTO plw_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Riminupuk banar pegibuten temed sabab et tinangeꞌ ye dut teteyumanan et mengeꞌ taaw neng inangey ye, diki ye ne ingin bewien tineew et budyang. ");
INSERT INTO plw_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Pinesurung ye megtuy sundalu apang isien ulu i Juan. Pinutek ye liyeg i Juan dut pipirisuan sigun et tahag i Herodes. ");
INSERT INTO plw_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Binibit ye ulu pereratun et rayaꞌ bekeꞌ inibgey itue dut budyang apang ibgey gasi dut induꞌ ye. ");
INSERT INTO plw_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Nebaran itue et mengeꞌ pepengenaran i Juan. Inisiꞌ dye bangkay i Juan indyari linbeng. ");
INSERT INTO plw_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Pegketuman et mengeꞌ apostol neng dinaak i Jesus kedye, negpeuliꞌ kenye. Pinabar kenye ginsan neng kineradya bekeꞌ tinulduꞌ dye. ");
INSERT INTO plw_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ginayat ye dye, kwan, “Bayaꞌ kew daken dut sakup et kelnangan neng kaya gikgibek apang kepetaren kew et kikisek.” Kaya timpu dye mekekaan sabab et mekansang banar taaw sumled lumiwan. ");
INSERT INTO plw_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Siminakat dye et gubang didye lang bekeꞌ siminurung si Jesus kedye. ");
INSERT INTO plw_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Temed pegugad dye nebiriꞌ dye et mengeꞌ taaw neng nekekilala kedye. Negdarak mengeꞌ taaw teyeg dut mengeꞌ sakup et lungsud pesurung dut pegtetenan i Jesus. Nekeuna dye kire Jesus. ");
INSERT INTO plw_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Pegineug i Jesus et gubang tineyuma ye mekansang banar taw. Neingasiꞌ ya banar sabab sama dye et bibili neng kaya mengingipat. Mekansang tinulduꞌ ye kedye. ");
INSERT INTO plw_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ganang megngengapun ne nepekabiꞌ kenye mengeꞌ pepengenaran ye bekeꞌ sinugid, “Kelnangan ne itue, diki be, bekeꞌ mekabiꞌ ne lumdep eldew. ");
INSERT INTO plw_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Teyen ipepenewaꞌ mena mengeꞌ taaw apang kesurung dye dut tetebuan. Duun dye lang kelen et pegkaan.” ");
INSERT INTO plw_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Siminambag ya kedye, kwan, “Keilangan kemyu megey kedye et pegkaan.” Nengingkut dye kenye, “Kelen kay takuꞌ et argaꞌ et duwang gatus denaryong bengbang apang ipekaan kedye?” ");
INSERT INTO plw_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Nengingkut ya kedye, “Senung bengbang myu? Surungiꞌ bekeꞌ birinaꞌ myu.” Pegkesewd dye, siminambag dye, “Limang bengbang bekeꞌ duwang seraꞌ lang.” ");
INSERT INTO plw_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Tinahag ye mengeꞌ pepengenaran na iparung ginsan taw. ");
INSERT INTO plw_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Negdegdalag dye narung, tegsenggatus bekeꞌ teglimampulung taw. ");
INSERT INTO plw_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Pegisiꞌ i Jesus et limang bengbang bekeꞌ duwang seraꞌ timiningaraꞌ ya dut langit bekeꞌ nenelangin et pegbantug et Empuꞌ. Pinegpukputek ye bengbang bekeꞌ binggey dut mengeꞌ pepengenaran apang ipemagiꞌ dut mengeꞌ taw. Pinegbeꞌbagiꞌ ye gasi duwang seraꞌ dut ginsan taw. ");
INSERT INTO plw_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nekekaan dye ginsan bekeꞌ pinemyagan. ");
INSERT INTO plw_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Pegketbes tinimung et mengeꞌ pepengenaran mengeꞌ eped et bengbang bekeꞌ seraꞌ neng neglebi. Nekebaha dye et sempuluꞌ duwang dedekerang tabig. ");
INSERT INTO plw_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Limang ribu keldamen et mengeꞌ lelaki lang neng nemengaan. ");
INSERT INTO plw_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Pinesakat i Jesus megtuy mengeꞌ pepengenaran ye et gubang apang meguna kenye dut Betsaida dut sembelang dagat kwit pepeuliꞌ ye peꞌ mengeꞌ taw. ");
INSERT INTO plw_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Pegtireng ye kedye timinungul ya dut mebudbukid apang menelangin. ");
INSERT INTO plw_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ganang megegebi ne, dut lawed nega mengeꞌ pepengenaran neng megsesakat et gubang, temed, yaya mene si Jesus dut deplakan. ");
INSERT INTO plw_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Nebiriꞌ ye mekeliyutan et pegbegsey mengeꞌ pepengenaran ye sabab serupang dye et deres. Ganang kukueldew ne siminurung si Jesus kedye et pegpanew dut timbew et dagat. Teliban ye teyen dye dut gubang. ");
INSERT INTO plw_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Temed pegbiriꞌ dye megpepanew dut timbew et dagat giminerwak dye sabab keblan dye et ya menglilimew. ");
INSERT INTO plw_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Nebiriꞌ dye et ginsan si Jesus bekeꞌ inirebutan dye. Neres ya megtuy kedye, kwan, “Besagaꞌ myu seled myu. Aku pesi itue. Kas kew takut.” ");
INSERT INTO plw_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Pegsakat ye et gubang netinep deres. Negliluꞌ dye banar ");
INSERT INTO plw_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","sabab kaya neretian dye neinabu pasal et keliluꞌlilung keradya ye et bengbang. Kayangga peꞌ napet et pikiran dye. ");
INSERT INTO plw_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Pegdipag dye diminungguꞌ dye dut deplakan et lungsud et Genesaret. ");
INSERT INTO plw_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Pegineug de Jesus megtuy nekilala et mengeꞌ taaw et Genesaret. ");
INSERT INTO plw_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Negdeꞌdaliꞌ mengeꞌ taaw et ating lungsud menglusu et mengeꞌ mesesakit pagkaꞌ nesewran dye na baꞌ embe si Jesus. ");
INSERT INTO plw_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Misan embe tenan ye dut kebebenwanan etawa ibang lelegdengan peglusu dye mengeꞌ tegesakit dut tetebuan. Tinew dye kenye na misan reped lang et badyuꞌ ye mekeptan dye. Pegnunga mengeꞌ taaw baꞌ kekpet et badyuꞌ ye. ");
INSERT INTO plw_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Nemengdateng mengeꞌ Pariseo sampay senung mengeꞌ Eskriba teyeg dut Jerusalem bekeꞌ nepekabiꞌ ki Jesus. ");
INSERT INTO plw_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Indyari nebiriꞌ dye sengmenu et mengeꞌ tindeg (pepengenaran) i Jesus nemengaan na meraki keremut. (Gay bersen, ingga peꞌ nebesan keremut dye). ");
INSERT INTO plw_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Sabab kaya pemengaan mengeꞌ Judio, lebi ne mengeꞌ Pariseo, baꞌ diki dye mena kebasaꞌ et mengeꞌ keremut dye sigun et arat neng pinenektak kedye et mengeꞌ kegunggurangan dye. ");
INSERT INTO plw_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Baꞌ mawaꞌ dye et tetebuan keilangan memasaꞌ mena muda dye kekaan. Mekeldam nega ibang mengeꞌ arat neng pegsunuren dye samat arat et pegbasaꞌ dye et sawan sampay mengeꞌ susunan neng tumbaga. ");
INSERT INTO plw_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Angkansa, nengingkut kenye mengeꞌ Pariseo bekeꞌ mengeꞌ Eskriba, kwan, “Manu kaya pegsunuren et mengeꞌ pepengenaran mu mengeꞌ arat neng tinulduꞌ et mengeꞌ kegunggurangan tyu? Sabab pengaan dye et kaya lang pememasaꞌ et keremut dye.” ");
INSERT INTO plw_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Siminambag si Jesus kedye, “Sugat pegteked i Isaias pasal et dimyu na mengeꞌ pebiꞌbiriꞌ samat sinurat ye, ‘Penewtaw et mengeꞌ taaw daken babaꞌ lang temed kaya pegkasi dye daken. ");
INSERT INTO plw_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Pegempuꞌ dye daken kaya kegunaan, sabab mengeꞌ peginduꞌ dye teyeg lang et arat et mengeꞌ taaw.’ ");
INSERT INTO plw_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Pegtelikuran myu Keseraan et Empuꞌ, temed, pegsunuren myu banar mengeꞌ leing-leing arat et mengeꞌ taaw.” ");
INSERT INTO plw_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Sinugid gasi i Jesus kedye, kwan, “Menunga pelan tulus myu et pegendiꞌ myu et Keseraan et Empuꞌ apang mepusakaꞌ myu lang mengeꞌ leing-leing arat? ");
INSERT INTO plw_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Sabab sinugid i Moises, ‘Kesiiꞌ amaꞌ bekeꞌ induꞌ mu. Baꞌ sinu meres et meyaat dut amaꞌ bekeꞌ induꞌ ye teup peteyen.’ ");
INSERT INTO plw_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Segwaꞌ, pegtutulduꞌ myu baꞌ ketabang taaw et gunggurang ye temed megsugid lang kedye, ‘Korban’, gay bersen, pegigbey ku itue et Empuꞌ, ");
INSERT INTO plw_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","kaya ne pegtugutan myu ya apang tumabang et gunggurang ye. Pegsebaban ye lang itue. ");
INSERT INTO plw_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Sabab et pegsunud myu et arat et kegunggurangan kaya ne keguna-guna dimyu beres et Empuꞌ. Mekansang negang ginis binwat myu na samat kwantin gasi.” ");
INSERT INTO plw_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Pinekabiꞌ i Jesus peuliꞌ mengeꞌ taaw kenye. Sinugid ye kedye, “Kingeg kew daken ginsan sampay retiaꞌ myu gasi. ");
INSERT INTO plw_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kaya lang mekepesalaꞌ et taaw itieng kekanen na pegkanen ye temed itieng ginis neng megliwan et taaw atin mekepesalaꞌ kenye. ");
INSERT INTO plw_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Baꞌ sinu meingin megkesewd keilangan kumingeg.” ");
INSERT INTO plw_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ganang nepeparak ne si Jesus bekeꞌ siminled ne et benwa iningkut kenye et mengeꞌ pepengenaran ye pasal et kinarang. ");
INSERT INTO plw_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Iningkut i Jesus kedye, kwan, “Kaya gasi takuꞌ neretian myu? Kaya takuꞌ mekebiriꞌ myu. Kaya lang mekepesalaꞌ itieng pegkanen et taw.” ");
INSERT INTO plw_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Sinugid itue i Jesus apang ipebunayag ye na ginsan neng kekanen menunga. ");
INSERT INTO plw_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Sinugid ye nega, “Mekepesalaꞌ lang et taaw itieng megliwan kenye. ");
INSERT INTO plw_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Sabab dut seled pegmewanan. Dut atey et taaw megliwan meyeyaat neng pikiran. Sebaban itue et pegkeradya tyu et mengeꞌ keselaan samat pegbeis, pegtakew, pegimatey et taw, sampay pegsubli et esawa et sebayaꞌ, ");
INSERT INTO plw_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","pegingin et artaꞌ et sebayaꞌ, keyeatan, pegrunding, kesewalanan, pegimbeng, peglimut, pegabu-abu, sampay kerupangan. ");
INSERT INTO plw_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Itieng ginsan neng keyeatan dut atey et taaw pegmewanan. Itie mekepesalaꞌ et taw.” ");
INSERT INTO plw_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Nugad si Jesus et Galilea apang sumurung dut lungsud et Tiro sampay si Sidon. Mendiꞌ teyen pesewd na duntin ya, angkansa, timinindal ya dut sembatung benwa temed kaya neketaguꞌ. ");
INSERT INTO plw_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Temed, nebaran megtuy itue et libun neng tegeyegang et libun neng pegseselban et meyaat neng nakem. Nepekabiꞌ ya bekeꞌ nepekleb dut teteyumanan i Jesus et pegpeingasiꞌ. ");
INSERT INTO plw_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Itieng libun diki Judio baꞌ diki Griego neng ipinengyegang dut Siropenisia. Tineew ye et ingasiꞌ ki Jesus na ipeugad meyaat neng nakem dut yengyegang ye. ");
INSERT INTO plw_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Sinugid kenye i Jesus, kwan, “Pesariꞌ mena biyagan mengeꞌ keyegangan. Sabab kaya patut isien kekanen dut mengeꞌ keyegangan bekeꞌ itimbag dut mengeꞌ ireng.” ");
INSERT INTO plw_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Temed, siminambag kenye libun, “Eꞌ. Banar, Empuꞌ. Segwaꞌ, misan mengeꞌ ireng megkaan et mumuꞌ et mengeꞌ keyegangan dut sirung.” ");
INSERT INTO plw_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Sinugid i Jesus kenye, “Sabab et menungang sambag mu mekedyari ke ne keuliꞌ. Nugad ne meyaat neng nakem dut yengyegang mu.” ");
INSERT INTO plw_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Peguliꞌ ye dut benwa ye neretengan ye yengyegang ye pebubuntul. Neugaran ne et meyaat neng nakem. ");
INSERT INTO plw_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Pegugad i Jesus dut Tiro nayaꞌ ya dut Sidon apang kelegpas dut Dagat et Galilea bekeꞌ neglembus dut lungsud et Dekapolis. ");
INSERT INTO plw_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Binibit kenye et mengeꞌ taaw sembatung lelaki neng bengel bekeꞌ metata. Tineew dye ki Jesus na idpen ye keremut ye dut lelaki apang numunga. ");
INSERT INTO plw_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Pineparak mena i Jesus ating lelaki dut kineldaman. Pinenpen i Jesus et tulduꞌ ye telinga et lelaki tebes nibeg ya apang ipeyd ye dut dilaꞌ et metata. ");
INSERT INTO plw_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Pegtingaraꞌ ye et langit gimininawa ya et merarem. Tebes sinugid i Jesus kenye, “Epata!” Gay bersen, metikwasan. ");
INSERT INTO plw_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Nekekingeg megtuy lelaki sampay nekebres ne et metlaꞌ! ");
INSERT INTO plw_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Binilinan dye i Jesus na endey ipabar et misan sinu. Temed baꞌ kengyan pegbilin kedye, susulu ga pinelkep dye abar. ");
INSERT INTO plw_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Negliluꞌ dye banar bekeꞌ nemegberes, “Menunga pegkeradya ye et ginsan neng ginis. Misan bengel mekepekingeg ye sampay mekepebres ye et metlaꞌ metata!” ");
INSERT INTO plw_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Atin neng mengeꞌ eldew, negtimung peuliꞌ mekansang banar taw. Sabab et kaya ne mekaan dye, angkansa, ginayat i Jesus mengeꞌ pepengenaran ye bekeꞌ sinugid kedye, kwan, ");
INSERT INTO plw_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Meingasiꞌ ku et itueng taaw neng mekansang banar sabab telung eldew ne tiban pebeꞌbayaꞌ dye daken, angkansa, namin ne kekanen dye. ");
INSERT INTO plw_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Baꞌ ipeuliꞌ ku dye et pemegurapan telimpeyuwen dye dut dalan. Lebi ne merayuꞌ nega ulian et iba dye.” ");
INSERT INTO plw_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Siminambag mengeꞌ pepengenaran ye, kwan dye, “Enukwan biyagan et bengbang misan sinu samat itueng kansang et taaw atuʼt kelnangan?” ");
INSERT INTO plw_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Iningkut ye dye, kwan ye, “Senu bengbang myu?” Siminambag dye, “Pitu lang.” ");
INSERT INTO plw_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Tinahag i Jesus mengeꞌ taaw na marung. Inisiꞌ ye pitung bengbang bekeꞌ nenelangin ya et peselamat dut Empuꞌ. Tebes pinegpukputek ye bekeꞌ pinemgey ye dut mengeꞌ pepengenaran ye apang ipemagiꞌ dye gasi dut mengeꞌ taw. Angkansa, sinunud dye tinehagan et Empuꞌ kedye. ");
INSERT INTO plw_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Maya nega gasi senu meririnek seraꞌ dye. Pegketbes menelangin et salamat dut Empuꞌ tinehagan ye gasi itue ipemagiꞌ dut mengeꞌ taw. ");
INSERT INTO plw_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nemengan dye ginsan seked binyagan dye. Tinimung dye mengeꞌ bengbang neng neped seked nekebaha dye et pitung tabig. ");
INSERT INTO plw_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Epat neng ribu dyeng kelelekian. Pinepanew i Jesus dye ginsan. ");
INSERT INTO plw_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Siminakat ya megtuy et gubang iba ye mengeꞌ pepengenaran ye pesurung dut lungsud et Dalmanuta. ");
INSERT INTO plw_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Nemengdateng mengeꞌ Pariseo apang dewaan dye si Jesus. Ingin dye sulayan ya, angkansa, tinewan dye ya et tendaꞌ teyeg dut Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Gimininawa ya et merarem tebes negsugid, kwan ye, “Manu penulus et tendaꞌ et keliluꞌlilung keradya itueng tutusan. Keberbenaran pegsugiren ku dimu, itueng tutusan neng mendiꞌ mengandel et Empuꞌ kaya ne begeyan et samat itueng tendaꞌ.” ");
INSERT INTO plw_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Tinirengan ye dye bekeꞌ siminakat ya et gubang apang dumipag dut sembelaꞌ. ");
INSERT INTO plw_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Nelipatan et mengeꞌ pepengenaran memibit et lutuꞌ dye selyu sembatung bengbang lang. ");
INSERT INTO plw_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Nenektak si Jesus kedye, kwan ye, “Birinaꞌ myu bekeꞌ ingetiꞌ myu bengbang et mengeꞌ Pariseo sampay bengbang i Herodes sabab linemuran et pepebukaꞌ na sungsang baꞌ kanen tyu.” (Gay bersen, ingeten et mengeꞌ pepengenaran na diki meglamud et tulduꞌ dye mengeꞌ tulduꞌ et mengeꞌ Pariseo.) ");
INSERT INTO plw_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Nemegingkut-ingkut mengeꞌ pepengenaran ye kwan dye, “Enu be atin? Kurang takuꞌ kekanen tyu?” ");
INSERT INTO plw_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Nesewran i Jesus pegbersen dye, angkansa, iningkut ye kedye, “Manu bengbang lang pegbibiseranen myu? Manu ingga peꞌ takuꞌ mekapet et pikiran myu gay ku bersen? Mendiꞌ kew takuꞌ tumerima? ");
INSERT INTO plw_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Maya mata myu, kaya takuꞌ meketuun kew? Maya telinga myu, kaya takuꞌ mekeretiꞌ kew? Bekeꞌ kaya takuꞌ mekerendem kew? ");
INSERT INTO plw_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ganang pinegpukputek ku limang bengbang dut limang ribung kelelekian, senung tabig neped tinimung myu?” iningkut ye. Sambag dye kenye, “Sempuluꞌ duwang tabig.” ");
INSERT INTO plw_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Iningkut gasi i Jesus, “Sampay dut pitung bengbang pinegpukputek ku dut limang ribung kelelekian, senung tabig neped tinimung myu?” Sambag dye kenye, “Pitung tabig.” ");
INSERT INTO plw_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Sinugid ye kedye, kwan ye, “Kayangga peꞌ takuꞌ neretian myu?” ");
INSERT INTO plw_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Pegdateng dye dut Betsaida binibit et senung taaw ki Jesus sembatung lelaki neng beleg. Nepasiꞌasiꞌ dye kutewen ya i Jesus. ");
INSERT INTO plw_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Kineptan ye lengen et beleg bekeꞌ dinundun ye dut liwan et kebenbenwanan. Ganang neigban ye ne mata et lelaki kinutew ye mata et lelaki bekeꞌ iningkut ye, kwan ye, “Mekebiriꞌ ke ne?” ");
INSERT INTO plw_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Timiningaraꞌ lelaki. Kwan ye, “Mekebiriꞌ ku ne et taw. Sama dye et kayu neng megpepanew.” ");
INSERT INTO plw_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Kinutew ye peuliꞌ mata et lelaki. Timinengteng banar lelaki bekeꞌ niminunga. Metlang ne pemiriꞌ ye. ");
INSERT INTO plw_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Pineuliꞌ ya i Jesus dut benwa ye. Sinugiran ya i Jesus na endey ya pebiyaꞌ dut kebenbenwanan. ");
INSERT INTO plw_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Siminurung si Jesus iba ye mengeꞌ pepengenaran ye dut lungsud et Sesarea Pelipo. Ganang megpepanew dye iningkut ye mengeꞌ pepengenaran ye. Kwan ye, “Sinu kunuꞌ aku kwaʼt mengeꞌ taw?” ");
INSERT INTO plw_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Siminambag dye, kwan dye, “Sugid et iba si Juan Mememewtismu ke. Sugid et iba si Elias ke, etawa sembatung tarus tagnaꞌ.” ");
INSERT INTO plw_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","“Kemyu gasi, enu mesugid myu baꞌ sinu aku?” Siminambag si Pedro, “Ikew si Kristo.” ");
INSERT INTO plw_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Inistiaran ye dye, kwan ye, “Kasiꞌ myu isugiraꞌ et misan sinu baꞌ sinu aku.” ");
INSERT INTO plw_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Na tinegnaan i Jesus itulduꞌ mengeꞌ pepengenaran ye, kwan ye, “Aku neng Yegang et Taaw keilangan lumabay et mekansang keliyutan, mendinan et mengeꞌ megurang bekeꞌ mengeꞌ pegibuten et Pariꞌ, sampay mendinan et mengeꞌ menunulduꞌ et Keseraan. Peteyen nega aku temed pegketalib et telung eldew, megbiyag ku peuliꞌ.” ");
INSERT INTO plw_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Metlang pegberes ye et itue kedye, angkansa, ginayat ya i Pedro, sembatung pepengenaran ye apang seweyen pegbebersen ye. ");
INSERT INTO plw_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Segwaꞌ, nepeteyuma ya et mengeꞌ pepengenaran ye bekeꞌ sinawey ye gasi si Pedro, kwan ye, “Perayuꞌ ke daken, Seytan, sabab kaya mekabiꞌ pikiran mu dut Empuꞌ baꞌ diki dut taw.” ");
INSERT INTO plw_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Pinekabiꞌ i Jesus et kenye mengeꞌ taaw bekeꞌ tinulduan ye dye, “Baꞌ sinu meingin sumunud daken keilangan mendinan ye mengeꞌ keinginan et diri ye. Keilangan gasi pesanen ye krus ye (gay bersen, pekampi ya daken misan kelabay et keliyutan bekeꞌ kepeteyan sabab et pegandel yeʼt daken), bekeꞌ sumunud daken. ");
INSERT INTO plw_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Mayang meingin memawiꞌ et biyag ye (gay bersen, mendiꞌ matey), atin melepasan, segwaꞌ, mayang meingin megsimayaꞌ et biyag ye sabab et pegsunud et daken bekeꞌ sabab et kepenggeran et Menungang Abar, atin mebawiꞌ (gay bersen, mebiyanan ye biyag neng kaya keskeran dut lelegdengan et Empuꞌ.) ");
INSERT INTO plw_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Enu mepulusan et sembatung taaw misan mebiyanan ye ginsan keinginan ye baꞌ diki ya mepebiyag misan ingyan dut lelegdengan et Empuꞌ? ");
INSERT INTO plw_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Enu ilkat et taaw apang kepeuliꞌ kenye biyag ye? ");
INSERT INTO plw_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Masa et keyeatan bekeꞌ tutusan tiban neng tegesalaꞌ. Baꞌ sinu lumew kumingeg bekeꞌ tumerima et Menungang Abar et Empuꞌ, aku neng Yegang et Taaw lumew gasi kenye dut pegpeuliꞌ ku atuʼt dunyaꞌ, iba ku mengeꞌ metignaꞌ neng dereakan et Empuꞌ. Pekayen ku ketlangan et Amaꞌ ku.” ");
INSERT INTO plw_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Sinugid gasi i Jesus kedye, kwan ye, “Keberbenaran pegsugiren ku dimyu. Maya senung megtitiyeg atue na diki matey seked diki dye melebayan mena baꞌ enukwan mengmilik et kebegbesagan na Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Pegtalib et enem neng eldew pinebayaꞌ i Jesus si Pedro, si Santiago bekeꞌ si Juan. Nemenungul didye lang dut melangkew neng bukid. Megtuy negpinda dagbes i Jesus dut teteyumanan dye. ");
INSERT INTO plw_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Megserinew badyuꞌ ye bekeꞌ meputiꞌ banar, melingkan kaya lang mekepeputiꞌ et samat kwantin atuʼt dunyaꞌ. ");
INSERT INTO plw_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Duntin negpebiriꞌ kedye si Elias iba ye si Moises, bekeꞌ nemegbisara-bisara dye ki Jesus. ");
INSERT INTO plw_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Sinugid i Pedro ki Jesus, “Menunulduꞌ, menunga atuꞌ tyu. Memaal kay et telung elunggung. Sembatu dimu, sembatu ki Moises, bekeꞌ sembatu ki Elias.” ");
INSERT INTO plw_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Nesugid ye lang itue sabab kaya mekesewran i Pedro baꞌ enu iba isugid ye sabab megtakut dye banar. ");
INSERT INTO plw_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kiminalung kedye inarak bekeꞌ maya beres mawaꞌ dut inarak, kwan ye, “Itue Yegang neng pegkesien ku. Kinggaꞌ myu ya.” ");
INSERT INTO plw_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Megtuy timinier dye et pelibut. Kaya ne nebiriꞌ dye ibang taaw selyu si Jesus mene. ");
INSERT INTO plw_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ganang megsesedsad dye et bukid, binilinan dye i Jesus na endey dye isugid et misan sinu itieng nebiriꞌ dye kwit ingga peꞌ ya, neng pegngeranen Yegang et Taw, negbiyag peuliꞌ mawaꞌ dut patey. ");
INSERT INTO plw_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Angkansa, iningtan dye binilin kedye. Nemegingkut-ingkut dye, “Enu gay bersen et ‘megbiyag peuliꞌ mawaꞌ dut patey?’ ” ");
INSERT INTO plw_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Iningkut dye ya, kwan dye, “Manu pegsugiren et mengeꞌ menunulduꞌ et Keseraan na keilangan matuꞌ mena si Elias neng tarus et Empuꞌ tagnaꞌ?” ");
INSERT INTO plw_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Sinambag ye dye, kwan ye, “Keberbenaran, keilangan matuꞌ mena si Elias apang ipeuliꞌ ye kebtangan et taaw tagnaꞌ. Baꞌ kwantin, manu nekesurat pasal et daken neng Yegang et Taw, keilangan kelabay et mekansang keliyutan sampay mendinan et mengeꞌ taw? ");
INSERT INTO plw_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Segwaꞌ, pegsusugid ku dimyu na natuꞌ ne si Elias bekeꞌ kineradya gasi et senung taaw kenye baꞌ enu keinginan dye sigun et nekesurat pasal kenye.” ");
INSERT INTO plw_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Pegpeuliꞌ dut mengeꞌ ibang pepengenaran neng netetektak nebiriꞌ dye mekansang banar taaw set pelibut dye. Pemegdawa kedye mengeꞌ menunulduꞌ et Keseraan. ");
INSERT INTO plw_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Megtuy negliluꞌ banar mengeꞌ kineldaman sabab et pegdateng de Jesus, angkansa, diminarak dye dut kenye apang sumapang. ");
INSERT INTO plw_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ingkut ye kedye, kwan ye, “Enu pinegdewaan myu kedye?” ");
INSERT INTO plw_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Siminambag kenye sembatu dut kineldaman, kwan ye, “Menunulduꞌ, binibit dut dimu yegang ku neng lelaki sabab pegseselban et nakem et umew. ");
INSERT INTO plw_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Baꞌ selban ne in mekegbaꞌ lang bekeꞌ meglabun babaꞌ ye sampay megringetnget nipen ye tebes atin pengsil ne. Tinew ku ne et mengeꞌ pepengenaran mu ipeugad dut kenye ating meyaat neng nakem, segwaꞌ, kaya negesan dye ipeugad.” ");
INSERT INTO plw_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Sinambag i Jesus kedye, kwan ye, “Eꞌ, mengeꞌ tutusan neng kaya pengandel. Senu nega kekwiten tetegan ku dimyu bekeꞌ senu nega kekwiten sendalan ku dimyu? Bitaꞌ myu atuʼt daken.” ");
INSERT INTO plw_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Binibit dye yengyegang dut kenye. Pegbiriꞌ ki Jesus et meyaat neng nakem na siminaleb megtuy pinegerger ye yengyegang. Neugbaꞌ ya bekeꞌ negtedtelubid et lugtaꞌ yengyegang bekeꞌ liminabun babaꞌ ye. ");
INSERT INTO plw_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Iningkut i Jesus amaꞌ et yengyegang, kwan ye, “Kengyan nega pegsaleb kenye?” Siminambag ya, kwan ye, “Tihad nega et kikisek peꞌ ya. ");
INSERT INTO plw_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Epus lang pepesbur dut apuy bekeꞌ dut danum apang peteyen, segwaꞌ, kaluꞌ maya mekeradya mu sampay baꞌ mekedyari meingasiꞌ ke ne damen, tebangiꞌ kay!” ");
INSERT INTO plw_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Sinugid i Jesus kenye, “Enu? Baꞌ mekedyari, kunuꞌ? Pegseseulinen ku beres ku dimu. Mekedyaring balen et mengeꞌ taaw neng maya pegandel daken misan enung keradya.” ");
INSERT INTO plw_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Megtuy siminambag et mebasag amaꞌ et yengyegang, kwan ye, “Empuꞌ, pengandel ku dimu. Baꞌ mekedyari, tebangiꞌ ku et kurang pegandel ku!” ");
INSERT INTO plw_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ganang nebiriꞌ i Jesus na megkekeldam ne mengeꞌ taaw, sinawey ye meyaat neng nakem, kwan ye, “Ikew, nakem et umew bekeꞌ mekepebngel, pegtehagen ku ikew, mugad ke ne et yengyegang sampay kas ne saleb peuliꞌ kenye!” ");
INSERT INTO plw_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ganang megugad ne meyaat neng nakem dut yengyegang pepegerwak bekeꞌ pepesilsig ye yengyegang. Samat patey ne ya. Angkansa, mekansang negsugid, “Patey ne yengyegang.” ");
INSERT INTO plw_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Segwaꞌ, kineptan i Jesus lengen et yengyegang bekeꞌ binangun. Timinyeg ya. ");
INSERT INTO plw_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Pegseled i Jesus dut benwa iningkut ya et mengeꞌ pepengenaran ye et taguꞌ, kwan dye, “Manu kaya mekepeugad kay ating meyaat neng nakem?” ");
INSERT INTO plw_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Siminambag kedye si Jesus, kwan ye, “Samat itue diki lang mepeliwan selyu ipebiyaꞌ et penelangin dut Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Nemengugad dye duntin bekeꞌ Galilea bineyaan dye. Mendiꞌ teyen ipesewd i Jesus et misan sinu baꞌ embe dye. ");
INSERT INTO plw_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Sabab pegtutulduan ye mengeꞌ pepengenaran ye, kwan ye kedye, “Aku neng Yegang et Taaw idagang dut kebanta ku bekeꞌ peteyen dye nega aku. Pegketbes mepatey dye aku, megbiyag ku peuliꞌ pegtalib et telung eldew.” ");
INSERT INTO plw_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Segwaꞌ, kaya neretian dye pegsugiren ye. Megtakut dye gasi mengingkut kenye pasal et tinulduꞌ ye. ");
INSERT INTO plw_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Nemengdateng dye dut Kapernaum. Ganang dun dye net benwa iningkut i Jesus mengeꞌ pepengenaran ye, kwan ye, “Enu pegdewaan myu kwit megpepanew tyu dut dalan?” ");
INSERT INTO plw_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Kaya nemenggibek dye sabab pinegdewaan dye baꞌ sinu kedye bantug banar. ");
INSERT INTO plw_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Narung si Jesus. Ginayat ye sempuluꞌ duwang pepengenaran ye. Sinugid ye kedye, “Baꞌ sinu meingin meguna, pemuri et ginsan bekeꞌ peuripen et ginsan taw.” ");
INSERT INTO plw_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ginayat ye sembatung yengyegang bekeꞌ pinetiyeg ye dut pinegketngaan dye. Tebes sinaney ye bekeꞌ sinugid ye kedye, ");
INSERT INTO plw_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Baꞌ sinu tumerima et samat itueng yengyegang sabab et pegkasi daken, pegterimanen ye gasi aku. Bekeꞌ baꞌ sinu tumerima daken, lein lang aku tinerima, erapun Empuꞌ neng diminaak daken.” ");
INSERT INTO plw_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Negsugid kenye si Juan, “Menunulduꞌ, nekebiriꞌ kay et sembatung taaw neng nepeugad et mengeꞌ meyaat neng nakem sabab et pegbateng ye et ingaran mu, angkansa, dinyangan kay sabab diki ya kekampi tyu.” ");
INSERT INTO plw_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Segwaꞌ, sinugid kedye i Jesus, “Kasiꞌ myu ya pegdyenganaꞌ sabab kaya lang taaw metbes megkeradya et keliluꞌlilung keradya pebiyaꞌ et pegbateng et ingaran ku na megtuy meres et meyaat daken. ");
INSERT INTO plw_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Sabab baꞌ embe diki melbi et kityu, atin kekampi tyu. ");
INSERT INTO plw_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Pegsusugid ku dimyu, baꞌ sinu megey dimyu et sengsawan neng danum apang meinum sabab et kekampi kew daken na ating Kristo, itie diki lang meilangan et beles kenye et Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Baꞌ sinu sebaban na mepesalaꞌ et samat itieng derisekan neng yengyegang neng pengandel daken, menunga peꞌ dut ating taaw tekinan liyeg yeʼt kelang batu bekeꞌ itimbag dut dagat. ");
INSERT INTO plw_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Baꞌ keremut mu sebaban angkansa pegsalaꞌ ke, putekaꞌ. Menunga nega ilabay mu dut kebiyagan neng kaya keskeran putek sembelaꞌ keremut mu bekeꞌ dut maya duwang keremut na kelabay ke dut apuy neng kedusaan na diki mepasew. ");
INSERT INTO plw_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Mengeꞌ uled duntin megkaan kedye kaya megpatey, bekeꞌ kaya kepesewan et apuy. ");
INSERT INTO plw_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Baꞌ tiked mu sebaban angkansa pegsalaꞌ ke, putekaꞌ. Menunga nega ilabay mu dut kebiyagan neng kaya keskeran putek sembelaꞌ tiked mu bekeꞌ dut maya duwang tiked na kelabay ke dut apuy neng kedusaan na diki mepasew. ");
INSERT INTO plw_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Mengeꞌ uled duntin kaya megpatey bekeꞌ kaya kepesewan et apuy. ");
INSERT INTO plw_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Baꞌ mata mu sebaban angkansa pegsalaꞌ ke, sungkitaꞌ. Menunga nega ilabay mu dut milikan et Empuꞌ beleg sembelaꞌ mata mu kasga dut maya duwang mata na kelabay ke dut apuy neng kedusaan na diki mepasew dut Narkaꞌ. ");
INSERT INTO plw_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Mengeꞌ uled duntin megkaan kedye kaya megpatey bekeꞌ kaya kepesewan et apuy. ");
INSERT INTO plw_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Asin kerinas gasi samat apuy. Keilangan melebayan myu baꞌ enukwan mepetignaꞌ kew et Empuꞌ et keliyutan. ");
INSERT INTO plw_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Menunga gasi asin, segwaꞌ, baꞌ meugaran ne et asin ye, enukwan nega rumasa peuliꞌ? Birinaꞌ myu. Inunganaꞌ myu diri myu apang metebangan myu gasi mengeꞌ ibang taw. Mesanang kew lang.” ");
INSERT INTO plw_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Nugad duntin si Jesus apang sumurung dut lungsud et Judea sampay neglembus dut sembelang Danum et Jordan. Pinegtimungan ya peuliꞌ et mengeꞌ taw. Tinulduan i Jesus dye samat kekwiten negang pegtulduꞌ ye. ");
INSERT INTO plw_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Maya mengeꞌ Pariseo nepekabiꞌ kenye apang sulayan dye gasi si Jesus. Angkansa, iningkut dye ya, kwan dye, “Mekedyari takuꞌ dut Keseraan baꞌ butasan et lelaki esawa ye?” ");
INSERT INTO plw_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Sinambag ye, kwan ye, “Enu tahag dimyu i Moises?” ");
INSERT INTO plw_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Siminambag dye gasi, kwan dye, “Pegtugut i Moises na butasan et lelaki esawa ye metbes sengnan et kesuratan et pegbutas.” ");
INSERT INTO plw_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Segwaꞌ, sinugid kedye i Jesus, kwan ye, “Sabab et kektulan et ulu myu, angkansa, sinurat ye itueng arat. ");
INSERT INTO plw_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Sabab sengketegnaan et pegbaal et Empuꞌ binaal ye dye et libun bekeꞌ lelaki. ");
INSERT INTO plw_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Sabab tirengan et lelaki amaꞌ bekeꞌ induꞌ ye apang megbeꞌbayaꞌ dye megesawa, ");
INSERT INTO plw_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","sampay megsembatu dye ne, angkansa, diki ne duwa dye baꞌ diki samat sembatung taaw ne. ");
INSERT INTO plw_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Baꞌ pinegbayaꞌ ne et Empuꞌ keilangan endey peraken et taw.” ");
INSERT INTO plw_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Pegdateng dut benwa iningkut et mengeꞌ pepengenaran ye pasal et tinulduꞌ ye. ");
INSERT INTO plw_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Sinambag ye dye, kwan ye, “Baꞌ sinung lelaki butasan ye esawa ye bekeꞌ mengesawa et iba negkeradya ya et meyaat dut esawa. Negbeis ya. ");
INSERT INTO plw_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Baꞌ butasan et libun esawa ye bekeꞌ mengesawa et iba, negbeis gasi.” ");
INSERT INTO plw_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Binibit et mengeꞌ taaw mengeꞌ keyegangan apang tewen dye ki Jesus na kutewen ye dye. Segwaꞌ, sinawey dye et mengeꞌ pepengenaran. ");
INSERT INTO plw_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Niseg si Jesus ganang nebiriꞌ ye, angkansa, sinugid ye kedye, “Pesariꞌ myu kumabiꞌ daken mengeꞌ keyegangan. Kasiꞌ myu dye bulagaꞌ sabab mengeꞌ taaw neng pegbegbegan et Empuꞌ keilangan mengampun samat itueng mengeꞌ yengyegang. ");
INSERT INTO plw_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Itue indaniꞌ myu baꞌ sinu diki tumerima na pegmimilikan ya et Empuꞌ samat pegterima et keyegangan et begey diki dye kesled dut milikan et Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Sinaney i Jesus mengeꞌ keyegangan. Dinpen ye et keremut ye sampay ininunga ye dye. ");
INSERT INTO plw_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ganang megugad ne si Jesus maya sembatung lelaki diminarak bekeꞌ nepekabiꞌ ki Jesus apang sumelukud dut teteyumanan ye sampay nengingkut, “Menungang Menunulduꞌ, enu keredyanen ku apang mebiyanan ku biyag neng kaya keskeran?” ");
INSERT INTO plw_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Siminambag si Jesus, “Manu pegbikyanan mu aku et menunga? Kaya lang menunga baꞌ diki Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Nesewran mu mengeꞌ saraꞌ, ‘kas pematey, kas pegbeis, kas penakew, kas pegembut et pegpebnar mu, kas pengrunding, esipaꞌ amaꞌ bekeꞌ induꞌ mu.’ ” ");
INSERT INTO plw_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Siminambag lelaki, kwan ye, “Menunulduꞌ, tinuman ku ne atin ginsan masa et yengyegang ku peꞌ.” ");
INSERT INTO plw_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Tinengtengan i Jesus lelaki in bekeꞌ pegmerganen ye ya, bekeꞌ sinugiran ye kenye, kwan ye, “Sembatu nega kurang dimu. Panew. Ipegelnaꞌ mengeꞌ pengartaꞌ mu bekeꞌ ipemgeyaꞌ dut mengeꞌ miskin ating pinelnan apang meterima mu biyag neng kaya keskeran dut lelegdengan et Empuꞌ. Pegketbes, peuliꞌ ke bekeꞌ sunud daken.” ");
INSERT INTO plw_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Negyeat dengdeng et lelaki pegkekingeg ye et itue indyari nugad et merupuk sabab mekansang banar pengartaꞌ ye. ");
INSERT INTO plw_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Siminyek si Jesus et pelibut ye bekeꞌ negsugid dut mengeꞌ pepengenaran ye, kwan ye, “Meliyut banar pemilik et Empuꞌ sembatung taaw neng mekansang pengartaꞌ.” ");
INSERT INTO plw_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Negliluꞌ mengeꞌ pepengenaran sabab et binres i Jesus. Negsugid peuliꞌ si Jesus kedye, kwan ye, “Meliyut banar milikan et Empuꞌ mengeꞌ taaw neng pemengandel et pengartaꞌ dye. ");
INSERT INTO plw_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Baꞌ pegpikiren myu meliyut kebiyaꞌ sembatung taaw neng pengandel et pengartaꞌ ye.” ");
INSERT INTO plw_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Susulu negliluꞌ mengeꞌ pepengenaran, angkansa, nemengingkut-ingkut dye kwan dye, “Baꞌ kwantin, sinu lang mebawiꞌ apang milikan et Empuꞌ?” ");
INSERT INTO plw_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Timinengteng si Jesus kedye bekeꞌ negsugid, kwan ye, “Diki lang mekeradya itue et taw, segwaꞌ, kaya meliyut itue dut Empuꞌ. Mekeradya et Empuꞌ ginsan neng ginis.” ");
INSERT INTO plw_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Negberes si Pedro, kwan ye, “Birinaꞌ, Empuꞌ. Tinektak kay ginsan apang sumunud dimu.” ");
INSERT INTO plw_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Sinugid gasi i Jesus, kwan ye, “Itue indaniꞌ myu, baꞌ sinu tumireng et benwa, ketipusdan, mengeꞌ gunggurang, mengeꞌ keyegangan, etawa mengeꞌ lugtaꞌ sabab lang et pegandel daken bekeꞌ sabab et pegpelkep et Menungang Abar, ");
INSERT INTO plw_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","kelaꞌ peruntung kedye et Empuꞌ. Mengeꞌ benwa, mengeꞌ ketipusdan, mengeꞌ gunggurang, mengeꞌ keyegangan, sampay mengeꞌ lugtaꞌ igbey kedye, segwaꞌ, maya gasi bebebayaꞌ keliyutan. Itue melebayan tiban, segwaꞌ, dut timpung megderateng maya biyag neng kaya keskeran. ");
INSERT INTO plw_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Segwaꞌ, duntin mesanad kebtangan et mengeꞌ taaw neng mekepikir tyu neng melangkew kebtangan tiban, bekeꞌ ipebantug mengeꞌ kaya pegesipen tiban.” ");
INSERT INTO plw_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Neguna si Jesus et mengeꞌ pepengenaran ye ganang megpepanew dye dut Jerusalem. Nemegliluꞌ dye bekeꞌ nemenakut gasi mengeꞌ ibang taaw neng megsusunud. ");
INSERT INTO plw_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Kwan ye, “Megtutungul tyu tiban dut Jerusalem sabab ipegsimayaꞌ aku neng Yegang et Taaw dut mengeꞌ pegibuten et mengeꞌ pariꞌ sampay mengeꞌ menunulduꞌ et Keseraan. Ukumen dye aku et kepeteyan, pegketbes, igbey aku dut mengeꞌ tawʼt lein Judio. ");
INSERT INTO plw_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Seweyen dye aku bekeꞌ igban bekeꞌ lepsan sampay peteyen. Segwaꞌ, megbiyag ku peuliꞌ pegketalib et telung eldew.” ");
INSERT INTO plw_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Nepekabiꞌ ki Jesus si Santiago bekeꞌ si Juan neng mengeꞌ yegang i Sebedeo. Nemegberes, kwan dye, “Menunulduꞌ, maya teyen tewen kay dimu.” ");
INSERT INTO plw_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Iningkut i Jesus, kwan ye, “Enu takuꞌ gay myu tewen daken?” ");
INSERT INTO plw_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Siminambag dye, kwan dye, “Tewen kay dimu na teyen gumaay ke mebantug kay baꞌ karung kay set abiꞌ mu dut milikan mu. Sembatu set kewanan mu, sembatu gasi set gibang.” ");
INSERT INTO plw_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Negberes si Jesus kwan ye, “Kaya lang mekesewran myu baꞌ enu pegtewen myu. Meinuman myu takuꞌ petikuan neng inuman ku etawa mebewtismuan kew et bewtismu neng melebayan ku?” ");
INSERT INTO plw_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","“Ekuanan kay,” sambag dye. Sinugid i Jesus, “Keliyutan neng ekuanan ku mekuanan myu pesi bekeꞌ mebewtismuan kew pesi et bewtismu neng lebayan ku. ");
INSERT INTO plw_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Segwaꞌ, kaya et daken pemikiran baꞌ sinu marung set kewanan bekeꞌ set gibang ku. Bekeꞌ erungan neng pegsugiren myu igbey lang dut atin mengeꞌ pinenyapan et Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ganang nekingeg itue et sempulung pepengenaran inisgan dye si Santiago bekeꞌ si Juan. ");
INSERT INTO plw_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Angkansa, pinekabiꞌ dye ginsan i Jesus bekeꞌ sinugiran, kwan ye kedye, “Nesewran myu mengeꞌ pegibuten et mengeꞌ tawʼt lein Judio. Dye pegempuen bekeꞌ pegsunuren. ");
INSERT INTO plw_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","“Segwaꞌ, diki lang kwantin keilangan et dimyu. Gamlang baꞌ sinu meingin pebantug keilangan menimuru mena et ginsan. ");
INSERT INTO plw_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Baꞌ sinu meingin bantug neng Begerar et ginsan keilangan uripenen mena et ginsan. ");
INSERT INTO plw_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Sabab aku neng Yegang et Taaw natuꞌ diki apang timuruen erapun apang menimuru. Inekuanan ku kepeteyan ku apang mebawiꞌ lang mengeꞌ taaw et keselaan dye.” ");
INSERT INTO plw_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Diminateng si Jesus dut Jeriko iba ye mengeꞌ pepengenaran ye sampay mengeꞌ mekansang taw. Ganang nugad dye ne duntin maya nebiyaan dye sembatung beleg taw. Megarung et abiʼt dalan bekeꞌ megtetew. Ingaran ye si Bartimeo yegang i Timeo. ");
INSERT INTO plw_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Pegkingeg ye atin ne si Jesus neng tawʼt Nasaret, negbensag ya bekeꞌ megbebres, kwan ye, “Jesus, upuꞌ i Dabid, meingasiꞌ ke ne daken!” ");
INSERT INTO plw_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Binresan ya et mengeꞌ taaw bekeꞌ binulag. Segwaꞌ, susulu ga negbegbensag, “Upuꞌ i Dabid, meingasiꞌ ke ne daken.” ");
INSERT INTO plw_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Nepetaren si Jesus bekeꞌ nengdaak, “Geyataꞌ myu ya.” Angkansa, ginayat dye ating beleg, kwan dye, “Besagaꞌ seled mu. Teyeg. Pegeyaten ye ikew.” ");
INSERT INTO plw_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Tinimbag i Bartimeo badyuꞌ ye, timinyeg et deꞌdaliꞌ, bekeꞌ nepekabiꞌ ki Jesus. ");
INSERT INTO plw_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Iningkut i Jesus, kwan ye, “Enu gay mu keredyanen ku dimu?” Siminambag beleg, “Menunulduꞌ, gay ku teyen ipenunganaꞌ ku apang kebiriꞌ ku peuliꞌ.” ");
INSERT INTO plw_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Sinugid i Jesus kenye, “Mekedyari ke ne mugad. Sabab et pegandel mu daken pinenunga ne mata mu.” Neketuun ya megtuy sampay siminunud ki Jesus. ");
INSERT INTO plw_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Mura nekerateng de Jesus dut Jerusalem, ganang duun dye negaʼt Betpage bekeꞌ Betania dut Bukid et mengeꞌ Olibo dinaak ye duwang pepengenaran ye. ");
INSERT INTO plw_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Kwan ye kedye, “Surung kew dut lembus, dut kebebenwanan. Pegdateng myu duntin mebiriꞌ myu megtuy asno neng lelaki. Ibun peꞌ ya bekeꞌ ingga peꞌ nekuraan. Bebariꞌ myu sampay bitaꞌ myu atue. ");
INSERT INTO plw_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Baꞌ maya mengingkut dimyu, kwan, ‘Manu binebaran myu atin?’ Sembagaꞌ myu, ‘Keilangan et Empuꞌ itue bekeꞌ ipeuliꞌ nega megtuy atue.’ ” ");
INSERT INTO plw_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Angkansa, nememanew dye sampay nebiriꞌ dye asno eset abiꞌ et dalan pebebanget set lelengewan et benwa. Ganang binebaran dye ne, ");
INSERT INTO plw_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","iningkut dye et ibang taaw neng petitiyeg duntin, kwan dye, “Manu binebaran myu atin?” ");
INSERT INTO plw_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Sinambag dye et samat binilin kedye i Jesus. Angkansa, pinesaran dye ne mugad. ");
INSERT INTO plw_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Binibit dye ki Jesus asno. Ganang nelempikan dye ne et mengeꞌ ibang badyuꞌ dye kinuraan ne i Jesus. ");
INSERT INTO plw_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Mekansang negdemdam et badyuꞌ dye dut dalan. Mayang iba nengrapiꞌ et medeun neng sanga et kayu apang idemdam dye gasi dut dalan. ");
INSERT INTO plw_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Mengeꞌ taaw dut unaan bekeꞌ dut biniyan ye megbebensag et, “Hosanna! Mesukud et Empuꞌ taaw neng nepeturun et kepegbeꞌbayaꞌ et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Mesukud pegdateng neng pegmilik et gunggurang tyung si Dabid. Hosanna dut dibuwat langit.” ");
INSERT INTO plw_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Diminateng si Jesus dut Jerusalem bekeꞌ siminled et templo. Nebiriꞌ ye ginsan neng ginis duntin. Sabab et megleldep ne eldew, angkansa, liminiwan ya apang peuliꞌ dut Betania iba ye sempuluꞌ duwang pepengenaran ye. ");
INSERT INTO plw_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Pegdiklem ganang mawaꞌ dye ne et Betania inurapan si Jesus. ");
INSERT INTO plw_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Nepayag ye igus neng medeun dut merayuꞌ. Pinekebian ye apang birinen ye baꞌ maya buaꞌ. Segwaꞌ, kaya lang nekebiriꞌ et buaꞌ selyu deun sabab ingga peꞌ pemumuaꞌ ye. ");
INSERT INTO plw_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Angkansa, kwan i Jesus dut igus, “Kaya ne kekaan et buaꞌ mu misan ingyan.” Nekekingeg mengeꞌ pepengenaran ye. ");
INSERT INTO plw_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Pegdateng dye dut Jerusalem siminled si Jesus et templo. Pinenempeg ye mengeꞌ mengderagang dut seled templo bekeꞌ mengeꞌ mengengelen. Pinenwarang ye lemisaan et mengeꞌ menemambiꞌ et pirak. Pinemukyaꞌ ye erung-erungan et mengderagang et kelepatiꞌ ");
INSERT INTO plw_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","sampay dinyangan ye baꞌ sinu mayaꞌ et templo na maya pegbibibiten. ");
INSERT INTO plw_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Tinulduan ye nega dye, kwan ye, “Diki be nekesurat, kwan, ‘Benwa ku bikyanan na benwa neng pepenelenginan et ginsan neng bangsa?’ Segwaꞌ, binaal myu et peteguan et menenakew.” ");
INSERT INTO plw_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Nekekingeg mengeꞌ pegibuten et pariꞌ bekeꞌ mengeꞌ menunulduꞌ et Keseraan. Angkansa, nememikir et tulus baꞌ enukwan mepatey dye si Jesus. Megtetakut dye kenye sabab mekeldam taaw megliluꞌ et tulduꞌ ye. ");
INSERT INTO plw_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ganang gebi ne nemengugad de Jesus. ");
INSERT INTO plw_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Pegpanew dye et diriklem netliban dye igus neng natey seked gamut. ");
INSERT INTO plw_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Nerendeman i Pedro, angkansa, kwan ye, “Menunulduꞌ, birinaꞌ. Natey ne igus neng tinerwanan mu.” ");
INSERT INTO plw_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Siminambag si Jesus, kwan ye kedye, “Pengandel kew et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Keberbenaran pegsugiren ku dimyu, baꞌ sinu menahag et itueng bukid, kwan, ‘Ugad sentin bekeꞌ petimbag dut dagat,’ atin balen kenye et Empuꞌ. Keilangan kaya pegalang-alang pegandel ye apang meinabu baꞌ enu pegsugiren ye. ");
INSERT INTO plw_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Angkansa, tinangeꞌ ku dimyu misan enu tewen myu dut pegpenelangin myu, endelaꞌ myu tinerima myu ne atin, asal meterima myu. ");
INSERT INTO plw_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Baꞌ tumyeg kew apang menelangin, mapaꞌ myu mayang rineatan et pikiran myu apang mampun kew gasi et Empuꞌ Amaꞌ mengeꞌ pegsungsang myu. ");
INSERT INTO plw_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Segwaꞌ, baꞌ diki kew mengmaap, diki gasi maapen kew et Empuꞌ Amaꞌ pegsungsang myu.” ");
INSERT INTO plw_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Siminurung dye peuliꞌ dut Jerusalem. Ganang megpepanew si Jesus dut templo nepekabiꞌ kenye mengeꞌ pegibuten et pariꞌ bekeꞌ mengeꞌ menunulduꞌ et Keseraan, sampay mengeꞌ megurang et Sanedrin. ");
INSERT INTO plw_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Iningkut dye ya, kwan dye, “Manu mekepegbeꞌbayaꞌ ke megkeradya et kwantin dut templo? Sinu negey dimu et itueng kepegbeꞌbayaꞌ?” ");
INSERT INTO plw_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Siminambag si Jesus, kwan ye, “Ingkuten ku kemyu et sembatung ingkut. Sembagaꞌ myu aku apang isugid ku dimyu baꞌ enung kepegbeꞌbayaꞌ pegkeredyanen ku itue. ");
INSERT INTO plw_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Itueng kineradya i Juan neng pegbewtismu bekeꞌ pegabar, sabab takuꞌ et daak et Empuꞌ etawa sabab et daak et mengeꞌ taw? Sembagaꞌ myu aku.” ");
INSERT INTO plw_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Angkansa, nememikir dye sabab kwan dye, “Baꞌ isugid tyu, ‘Dinaak et Empuꞌ,’ sugiren ye gasi et kwan, ‘Manu kaya pegendelen myu ya?’ ");
INSERT INTO plw_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Segwaꞌ isugid tyu takuꞌ kwan, ‘Dinaak et mengeꞌ taw?’ ” Sabab megtakut dye gasi et mengeꞌ taaw sabab pegkilelanen et ginsan na si Juan tarus et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Angkansa, sinambag dye si Jesus, kwan dye, “Diki kay mesewran.” Kwan i Jesus kedye, “Diki ku gasi isugid dimyu baꞌ enung kepegbeꞌbayaꞌ pegkeredyanen ku mengeꞌ ginisan.” ");
INSERT INTO plw_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Negkarang peuliꞌ kedye si Jesus, kwan ye, “Nengluwak sembatung taaw et mekansang ubas dut uma ye. Indyari binekuran ye selus. Nengali ya et pepegaan et ubas, bekeꞌ negpetiyeg et melangkew neng tetluan neng tutungguan. Pinetengdanan ye et ibang mengunguma sabab siminurung ya dut merayung lungsud. ");
INSERT INTO plw_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ganang pemumuaan ne pinesurung et Empuꞌ et luluwaken sembatung tetehagen ye apang ipesukut ye. ");
INSERT INTO plw_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Segwaꞌ inewiran et mengeꞌ iba itueng tetehagen, pinesekitan dye, bekeꞌ pineuliꞌ et kaya lang bibit. ");
INSERT INTO plw_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Pinesurung ye gasi ibang tetehagen ye. Segwaꞌ, pinukul dye ulu ye sampay pinelelew dye. ");
INSERT INTO plw_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nengdaak gasi ya et sembatu nega. Segwaꞌ pinatey dye ating dinaak. Kwantin nega gasi kineradya dye dut mengeꞌ mekeldam neng dinaak. Maya pinesekitan, mayang iba pinatey dye. ");
INSERT INTO plw_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Sembatu mene netektak na mekedyari ipesurung ye. Yegang itue neng pegkesien ye. Ya ne kebiniyanan neng pinesurung ye kedye. Kwan ye, ‘Esipen dye meraliꞌ yegang kung lelaki.’ ");
INSERT INTO plw_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Segwaꞌ mengeꞌ mengunguma nemegisun-isun, kwan dye, ‘Itue ne memumusakaꞌ. Aniꞌ kew. Peteyen tyu apang meisiꞌ tyu pusakaen ye.’ ");
INSERT INTO plw_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Inewiran dye ya, pinatey, bekeꞌ tinimbag dut liwan et luluwakan et ubas. ");
INSERT INTO plw_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Enu ne keredyanen et Empuꞌ et luluwaken? Surungan ye mengingipat et ubas apang peteyen. Petengdanan ye ne ubasan dut ibang mengunguma. ");
INSERT INTO plw_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ingga peꞌ takuꞌ nebatsaꞌ myu nekebtang dut Kesuratan? Kwan, ‘Ating batu neng minendinan et mememaal et benwa, atin ne nekepangger et pidyuruꞌ. ");
INSERT INTO plw_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Sabab kineradya et Empuꞌ itue. Angkansa, keliluꞌliluꞌ banar et kityu!’ ” ");
INSERT INTO plw_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Pinaru et pegibuten et mengeꞌ Judio na elewen si Jesus sabab neisiꞌisiꞌ dye ne na dye pegsusugaten et kekerangan ye. Segwaꞌ, megtakut dye gasi et mengeꞌ taw, angkansa, kaya inenu dye ya. Nemengugad dye lang. ");
INSERT INTO plw_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Senung Pariseo bekeꞌ mengeꞌ tindeg i Herodes pinesurung ki Jesus apang melukuy dye ya dut pegbersen ye. ");
INSERT INTO plw_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Nepekabiꞌ dye kenye bekeꞌ kwan dye, “Menunulduꞌ, nesewran kay metignaꞌ ke bekeꞌ kaya lang mekeguyud ke et misan sinu sabab saliꞌ pemiriꞌ myu et ginsan neng taw. Keberbenaran pegtutulduꞌ mu baꞌ enu keinginan et Empuꞌ dut mengeꞌ taw. Dut Keseraan takuꞌ itueng pegbayad et buwis ki Sesar? Megbayad kay etawa diki?” ");
INSERT INTO plw_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Segwaꞌ, nesewran i Jesus na pebiꞌbiriꞌ dye lang. Angkansa, sinugid ye kedye, kwan ye, “Manu takuꞌ ingin myu aku lukuyen? Begeyiꞌ myu aku et sembatung denaryo. Birinen ku.” ");
INSERT INTO plw_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Binggeyan dye ya. Iningkut dye i Jesus, kwan ye, “Sinung pataꞌ bekeꞌ ingaran nekebtang atue?” Siminambag dye, “Ki Sesar neng pegibuten.” ");
INSERT INTO plw_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Sinugid i Jesus kedye, “Igbeyaꞌ myu ki Sesar barang ki Sesar. Igbeyaꞌ myu gasi dut Empuꞌ barang dut Empuꞌ.” Negliluꞌ dye banar kenye. ");
INSERT INTO plw_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Mengeꞌ Saduseo neng kaya pemengandel et megbiyag peuliꞌ mengeꞌ patey nengingkut ki Jesus, kwan dye, ");
INSERT INTO plw_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Menunulduꞌ, negsurat si Moises damen et Keseraan. Baꞌ matey lelaki bekeꞌ metirengan ye esawa ye et kaya lang yegang dye, ating tipused et lelaki keilangan pebulun dut nebeluan, apang megyegang dye apang ipelembus tutusan et ating natey. ");
INSERT INTO plw_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Maya pitung megtipused neng lelaki. Nengesawa ukaꞌ tebes natey ampaꞌ kaya lang yegang ye. ");
INSERT INTO plw_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Nepebulun dut nebeluan itueng ikeruwa tebes natey gasi. Kaya lang yegang dye. Kwantin gasi neinabu dut iketelu sampay dut mengeꞌ siminunud. ");
INSERT INTO plw_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Seked nemematey pitung lelaki kaya lang nekeyegang dye. Dut ketimpusan natey gasi ating libun neng nebeluan. ");
INSERT INTO plw_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Sinu dut pitung lelaki mesawa ye dut pegbiyag peuliꞌ sabab nesawa ye dye ginsan?” ");
INSERT INTO plw_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Siminambag si Jesus, kwan ye kedye, “Salaꞌ kew. Nesewran tyu baꞌ manu? Kaya mekesewran myu mengeꞌ nekesurat bekeꞌ basag et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Sabab dut pegbiyag peuliꞌ diki ne mengesawa mengeꞌ taw. Megbiyag dye samat mengeꞌ dereakan et Empuꞌ dut lelegdengan et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Pasal gasi et pegbiyag peuliꞌ ingga peꞌ takuꞌ nebatsaꞌ myu dut kesuratan i Moises pasal dut mebeꞌbabang kayu neng diminleg? Duntin nekesurat sinugid et Empuꞌ ki Moises, kwan ye, ‘Aku Empuꞌ i Abraham, Empuꞌ i Isaak, bekeꞌ i Jakob.’ ");
INSERT INTO plw_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Diki ya Empuꞌ et mengeꞌ patey baꞌ diki Empuꞌ et mengeꞌ biyag. Salaꞌ kew banar.” ");
INSERT INTO plw_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Nekekingeg sembatung menunulduꞌ et Keseraan dut pemegdawa-dawa. Netantu ye mependey sumambag si Jesus dut mengeꞌ Saduseo. Angkansa, pinekebian ye si Jesus apang mengingkut, kwan ye, “Embeng saraꞌ mergaꞌ et ginsan?” ");
INSERT INTO plw_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Siminambag si Jesus, kwan ye, “Itue mergang saraꞌ et ginsan. Kinggaꞌ mengeꞌ tawʼt Israel. Empuꞌ tyu sembatu lang Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Kesiiꞌ Empuꞌ mu et seled atey mu sampay dut penedseled bekeꞌ dut pikiran mu sampay dut ginsan et kebegbesagan mu. Itue mergang saraꞌ. ");
INSERT INTO plw_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Itue gasi ikeruwa. Kesiiꞌ sebayaꞌ mu samat pegkasi mu et diri mu. Kaya ne ibang saraꞌ na lebing mergaꞌ selyu et itueng duwa.” ");
INSERT INTO plw_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Siminambag menunulduꞌ et Keseraan, kwan ye, “Banar sinugid mu in, Menunulduꞌ. Sembatu lang Empuꞌ. Kaya ne lyu et kenye. ");
INSERT INTO plw_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kesien Empuꞌ dut seled atey, bekeꞌ dut seled pikiran, sampay dut kebegbesagan. Kesien sebayaꞌ samat pegkasi mu et diri mu. Kelyu nega takuꞌ itue dut ginsan neng pegbegey na pegtutungen bekeꞌ begey na pegimateyen dut Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nebiriꞌ i Jesus samat mependey tubag ye. Angkansa, sinugid ye, “Mekabiꞌ ke ne mepelamud dut mengeꞌ pegmimilikan et Empuꞌ.” Seked duntin kaya ne taaw nekakuꞌ mengingkut kenye. ");
INSERT INTO plw_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ganang megtutulduꞌ si Jesus dut templo sinugid ye, kwan ye, “Enukwan pegsusugid et mengeꞌ menunulduꞌ et Keseraan na yegang i Dabid ating Mesias? ");
INSERT INTO plw_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Misan si Dabid ininduan et Menungang Nakem, negpebnar et samat itue, ‘Sinugid et Empuꞌ dut Empuꞌ ku, arung et kewanan ku, seked iperaag ku kebanta mu.’ ");
INSERT INTO plw_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Si Dabid ne gasi negsugid nega kenye ‘Empuꞌ’. Enukwan mebateng et mengeꞌ menunulduꞌ et Keseraan na yegang lang i Dabid Mesias?” Liminasig et pegkingeg kenye mengeꞌ taaw. ");
INSERT INTO plw_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Sinugid nega i Jesus dut pegtulduꞌ ye, kwan ye, “Ingetiꞌ myu mengeꞌ menunulduꞌ et Keseraan na keinginan dye megbadyuꞌ et mebuwat baꞌ manew dye dut tetebuan sabab ingin dye tyuman et mengeꞌ taw. ");
INSERT INTO plw_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Dut sinagoga gasi ingin dye marung dut teteyumanan et mengeꞌ taaw bekeꞌ mengeꞌ erung-erungan et mengeꞌ pegibuten dut mengeꞌ kenkanan. ");
INSERT INTO plw_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Pegrundingen dye lang pengartaꞌ et mengeꞌ libun neng nebeluan. Keinginan dye menelangin et mebuwat, lebi negang megat banar dusa kedye.” ");
INSERT INTO plw_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Narung si Jesus dut abiꞌ et pegbebgeyan et Empuꞌ dut templo apang serungan ye mengeꞌ taw, sasat pemengdegdag et pirak dut susunan. Mekansang deyahan nenunuꞌ et derekerang argaꞌ. ");
INSERT INTO plw_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Kiminabiꞌ gasi sembatung libun neng nebeluan apang menunuꞌ et duwang siin neng kikisek neng argaꞌ. ");
INSERT INTO plw_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ginayat i Jesus mengeꞌ pepengenaran ye. Sinugiran ye dye, kwan ye, “Keberbenaran pegsusugid ku dimyu itueng miskin neng nebeluan nenunuꞌ et lebi negang argaꞌ et sinunuꞌ dye. ");
INSERT INTO plw_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Sabab mengeꞌ iba sinunuꞌ dye kisek neng bagiꞌ lang et pengartaꞌ dye. Segwaꞌ, sinunuꞌ et itueng miskin neng nebeluan ginsan neng ibiyag ye.” ");
INSERT INTO plw_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Pegliwan de Jesus et templo negsugid kenye sembatung pepengenaran ye, kwan ye, “Menunulduꞌ, birinaꞌ be derekerang batu in pegemiten dye balen et mengeꞌ benwa in. Menunga banar binaal dye.” ");
INSERT INTO plw_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Kwan i Jesus kedye, “Nebiriꞌ myu tiban mengeꞌ derekerang benwa in, diki be, segwaꞌ, pepulid dye ginsan. Misan mengeꞌ batu kaya metinda neng petitimbew et seꞌsaliꞌ.” ");
INSERT INTO plw_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Timinindal dye dut Bukid et mengeꞌ Olibo. Ganang megarung si Jesus set entek et templo iningkut ya et taguꞌ i Pedro, i Santiago, i Juan, bekeꞌ i Andres. Kwan dye, ");
INSERT INTO plw_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Isugiraꞌ damen baꞌ ingyan meinabu itueng mengeꞌ sinugid mu damen. Enu gasi tendaꞌ ye baꞌ mekabiꞌ ne metuman itue?” ");
INSERT INTO plw_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Itue tinegnanan i Jesus negsugid kedye, kwan ye, “Ingetiꞌ myu na kas kew megpawam et misan sinung taw. ");
INSERT INTO plw_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Mekansang matuꞌ na mibit et ngaran ku. Sugiren dye, ‘Aku si Kristo’ bekeꞌ mekansang elamen dye. ");
INSERT INTO plw_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Baꞌ kekingeg kew et mekabiꞌ ne sagkaꞌ bekeꞌ abar-abar et sagkaꞌ dut leing lungsud, kas kew kesusa. Sabab itueng mengeꞌ ginis keilangan meinabu. Segwaꞌ, ingga peꞌ atin ketimpusan et biyag. ");
INSERT INTO plw_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Sabab sumagkaꞌ bangsa et seꞌsaliꞌ yeng bangsa. Kwantin gasi dut mengeꞌ pegmilik. Megsagkaꞌsagkaꞌ dye. Yumegyeg nega atue bekeꞌ dut leing lungsud. Murap gasi. Segwaꞌ, mengeꞌ meinabu sama mene et pegteterman neng libun mura mengganak. Kwantin tegnanan et bagung periama. ");
INSERT INTO plw_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Segwaꞌ, kepangger kew sabab ilusu dye kemyu dut mengeꞌ ukum. Suntuken kew nega dut mengeꞌ sinagoga. Bibiten dye kemyu dut mengeꞌ pegibuten sabab lang et pegandel myu daken. Meinabu itue apang megpebnar kew kedye et Menungang Abar pasal et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Keilangan mepabar mena dut ginsan neng bangsa Menungang Abar pasal et Empuꞌ mura dumateng ketimpusan. ");
INSERT INTO plw_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Segwaꞌ, baꞌ malew kew bekeꞌ bibiten dut ukum kas kew kesusa baꞌ enu ibres myu. Sabab baꞌ ingkuten kew igbey dimyu teyeg dut Menungang Nakem ibres myu kedye. ");
INSERT INTO plw_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Meinabu gasi itue. Tipuen et lelaki tipused ye apang peteyen bekeꞌ kwantin gasi keredyanen et amaꞌ dut yegang ye. Etuanan et mengeꞌ keyegangan mengeꞌ gunggurang dye sampay ipepatey. ");
INSERT INTO plw_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Isgan kew et ginsan taaw sabab et pegandel myu daken. Segwaꞌ, sinu kesandal et pegandel daken misan peteyen ya, atin terimanen et biyag neng kaya keskeran teyeg dut Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Baꞌ ingyan mebiriꞌ myu ‘Meyaat Banar’ na megmilik ne dut diki teup kenye, keilangan meretian et megbatsaꞌ, pelegyu kew mengeꞌ tawʼt Judea dut kebudbukiran. ");
INSERT INTO plw_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Baꞌ maya taaw dut binubungan, keilangan mineug apang melegyu megtuy. Endey sumled apang misiꞌ et enu-enu. ");
INSERT INTO plw_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Mengeꞌ taaw gasi dut uma dye endey ne seulinen badyuꞌ dye. ");
INSERT INTO plw_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Keingasiꞌingasiꞌ banar mengeꞌ megmementung sampay mengeꞌ pepeduruꞌ et ating eldew. ");
INSERT INTO plw_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ipenelenginaꞌ myu na endey meinabu itieng keliyutan et timpuʼt pememeratan ");
INSERT INTO plw_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","sabab itieng timpu et keliyutan ingga peꞌ nelebayan tihad negaʼt binaal et Empuꞌ dunyaꞌ seked tiban. Bekeꞌ diki melebayan peuliꞌ samat itue. ");
INSERT INTO plw_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Baꞌ ipekwit et Empuꞌ ating keliyutan kaya lang taaw metinda. Segwaꞌ, sabab et mengeꞌ taaw neng piniliꞌ ye inupama ye na diki ipekwit,” sinugid i Jesus. ");
INSERT INTO plw_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Sinugid nega i Jesus, “Baꞌ maya megsugid dimyu, kwan, ‘Birinaꞌ. Itue ne si Kristo neng pinesurung et Empuꞌ!’ etawa, ‘Duntin ne ya!’, kas kew pengandel. ");
INSERT INTO plw_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Sabab lumiwan mengeꞌ taaw neng pesingsiring. Rundingan dye mengeꞌ taaw apang ipebluꞌ kedye kwan si Kristo dye etawa mengeꞌ tarus. Pebiriꞌ dye et mengeꞌ tendaꞌ sampay mengeꞌ keliluꞌlilung keradya. Ingin dye elamen mengeꞌ piniliꞌ et Empuꞌ baꞌ mekedyari. ");
INSERT INTO plw_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Segwaꞌ, inget kew. Sinugid ku lagi dimyu itue mura meinabu. ");
INSERT INTO plw_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Baꞌ metbes ne ating keliyutan lumingeb eldew bekeꞌ diki lumantaꞌ bulan. ");
INSERT INTO plw_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Meregdag gasi mengeꞌ bituen bekeꞌ yumegyeg langit. ");
INSERT INTO plw_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Tebes mebiriꞌ et mengeꞌ taaw pegdateng ku neng Yegang et Taaw dut mengeꞌ inarak. Ipebiriꞌ ku kebegbesagan bekeꞌ pegkaꞌ Empuꞌ ku. ");
INSERT INTO plw_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ipetahag ku dereakan ku apang timungen ginsan taaw neng piniliꞌ ku teyeg dut ginsan neng lungsud. Tihad dut kepuspusan et dunyaꞌ seked dut sembelang kepuspusan. ");
INSERT INTO plw_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Retiaꞌ myu karang pasal et puun et igus. Baꞌ tumunas ne bekeꞌ dumeun sanga ye, mesewran myu mekabiꞌ ne pemumuaan. ");
INSERT INTO plw_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Kwantin gasi baꞌ mebiriꞌ myu meinabu ne itueng mengeꞌ keliluꞌlilung keradya. Mesewran myu mekabiꞌ ne irateng ku, esen ku ne et lelengewan. ");
INSERT INTO plw_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Indaniꞌ myu meinabu itueng pebibiyag tiban. Keberbenaran itue. ");
INSERT INTO plw_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Tumalib langit bekeꞌ dunyaꞌ, segwaꞌ, diki meylang mengeꞌ beres ku neng sinugid dimyu. ");
INSERT INTO plw_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Pasal et bineres ku dimyu, kaya kesewd et eldew etawa timpu baꞌ ingyan meinabu misan mengeꞌ dereakan et Empuꞌ dut lelegdengan et Empuꞌ. Misan aku Yegang et Amaꞌ, diki lang gasi kesewd. Empuꞌ Amaꞌ lang megsesewd. ");
INSERT INTO plw_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ingetiꞌ myu. Sulagiꞌ myu sabab diki mesewran baꞌ enung timpu.” ");
INSERT INTO plw_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Dinugangan ye beres ye. Kwan ye, “Siringan ku samat taaw neng mugad et benwa ye apang mepanew et merayung lungsud. Binggeyan ye et kepegbayaꞌ mengeꞌ mengengeradya ye et kekenyeng keredyanen. Tinahag ye megsulag banar et daran endey migaꞌ. ");
INSERT INTO plw_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Angkansa, sulagiꞌ sabab diki mesewran mu baꞌ ingyan irateng ku. Kaluꞌ pegserep et eldew, tengang gebi, memaluꞌ manuk, etawa keririkleman. ");
INSERT INTO plw_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Tetaka dumateng ku et meklat. Kaluꞌ meretengan ku megigaꞌ kew? ");
INSERT INTO plw_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Pegtahag ku dimyu, itahag ku gasi et ginsan taaw, ‘Sulagiꞌ myu. Pegpanyap kew!’ ” tutup i Jesus. ");
INSERT INTO plw_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Keduwanan mene Kenkaan ne et Neketalib bekeꞌ Kenkaan ne et Bengbang neng Kaya Pinekembang. Sinekapan et mengeꞌ pegibuten et pariꞌ sampay mengeꞌ menunulduꞌ et Keseraan baꞌ enukwan pengalew dye ki Jesus pebiyaꞌ et runding apang imeteyen. ");
INSERT INTO plw_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Nemegsudsugid et didye mene, “Segwaꞌ, endey ipetkaꞌ et eldew et Kenkaan apang diki meriwaraꞌ mengeꞌ taaw.” ");
INSERT INTO plw_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Dinetengan de Jesus benwa i Simon neng tegeldew-eldew dut Betania. Ganang megkekaan ya diminateng libun neng megbibibit et susunuan neng batu na pegngeranen alabastro. Sunuꞌ et itue bebengluen teyeg dut sembatung luluwaken na pegngeranen nardu. Mergaꞌ banar itueng nardu. Pinsaꞌ ye katsaꞌ pegketbes inulaꞌ ye et ulu i Jesus. ");
INSERT INTO plw_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Segwaꞌ, mayang iba negberes et diri dye sabab et iseg, kwan dye, “Manu inusibaꞌ bebengluen in? ");
INSERT INTO plw_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mepegelen et lebi nega et telung gatus neng denaryo apang mebgey dut mengeꞌ miskin ating elen.” Sinusun dye libun. ");
INSERT INTO plw_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Segwaꞌ, kwan i Jesus, “Pesariꞌ myu ya. Manu pegsesewen myu ya? Menunga itueng kineradya ye daken. ");
INSERT INTO plw_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Sabab tatap mekeiba-iba myu miskin bekeꞌ misan ingyan. Baꞌ geayen myu keredyanan dye et menunga. Segwaꞌ, diki myu aku tatap meiba-iba. ");
INSERT INTO plw_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Kineradya ye atin ne gees ye. Binalung ye ne lagi et bebengluen bilug ku apang memesen bilug ku mura et peglebeng. ");
INSERT INTO plw_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Keberbenaran pegsugiren ku dimyu misan embeng lungsud mepebnaran et itueng Menungang Abar. Megdemikian gasi kineradya et itueng libun bilang kerendeman kenye.” ");
INSERT INTO plw_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Si Judas Iskariote, sembatung pepengenaran i Jesus, siminurung dut mengeꞌ pegibuten et mengeꞌ pariꞌ apang ipegdagang si Jesus kedye. ");
INSERT INTO plw_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Nenep dye pegkekingeg et beres ye. Inekuanan dye begeyan ya et pirak. Angkansa, nenulus si Judas et timpu apang ipegdagang si Jesus. ");
INSERT INTO plw_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Unang eldew et Bengbang neng Kaya Pinekembang, ganang nebgey dye ne bibili et Kenkaan et Neketalib, nengingkut kenye mengeꞌ pepengenaran ye, kwan dye, “Embe ingin mu penyapan et kanan mu et Kenkaan et Neketalib?” ");
INSERT INTO plw_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Dinaak ye duwang pepengenaran ye. Sinugid ye kedye, kwan ye, “Surung kew dut tetebuan. Kesusup kew et sembatung lelaki neng megbibibit et sengsiburan neng danum. Pesunud kew kenye. ");
INSERT INTO plw_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Baꞌ embe seldan ye isugiraꞌ myu dut empuꞌ et benwa, ‘Na pepeingkut et menunulduꞌ embe kunung sisingled mekedyari kanan ye et Kenkaan et Neketalib kesaru ye mengeꞌ pepengenaran ye.’ ");
INSERT INTO plw_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Itulduꞌ ye dimyu kelang sisingled dut dibuwat. Maya ne mengeꞌ gamit pegpanyap kew kityu duun.” ");
INSERT INTO plw_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Nememanew mengeꞌ pepengenaran bekeꞌ nemenurung dut tetebuan. Nebiriꞌ dye samat sinugid i Jesus kedye. Pinanyap dye Kenkaan et Neketalib. ");
INSERT INTO plw_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ganang gimimbi ne siminurung ya duun iba ye sempuluꞌ duwang pepengenaran ye. ");
INSERT INTO plw_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ganang megkekaan dye ne sinugid i Jesus, kwan ye, “Keberbenaran pegsugiren ku dimyu. Sembatu dimyu neng kesaru ku dumagang daken.” ");
INSERT INTO plw_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Nemengrupuk dye bekeꞌ nemegsubli-subli nengingkut kenye, kwan dye, “Aku takuꞌ a? Lein aku a?” ");
INSERT INTO plw_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Sinambag dye i Jesus, “Sembatu dimyu neng sempuluꞌ duwang pepengenaran ku neng kesaru ku mengditil et bengbang set sembatung mangkuk. ");
INSERT INTO plw_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Manew ku neng Yegang et Taaw sabab et nekesurat ne pasal et daken, segwaꞌ, keingasiꞌingasiꞌ et nengdagang daken in. Menunga nega et ating taaw diki ya pinengyegang.” ");
INSERT INTO plw_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ganang megkekaan dye nurut si Jesus et bengbang bekeꞌ ganang nekepenelangin ne ya et peselamat pinegpukputek ye, tebes pinemgeyan ye dye. Kwan ye, “Isiꞌ kew. Itueng bengbang samat bilug ku.” ");
INSERT INTO plw_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Sampay insiꞌ ye sawan. Ganang nekepenelangin ne ya et peselamat binggey ye kedye bekeꞌ ninum dye ginsan. ");
INSERT INTO plw_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Sinugid ye kedye, “Itueng inumen samat duguꞌ ku neng bagung tinangeꞌ neng meulaꞌ apang lekaten mekeldam. ");
INSERT INTO plw_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Pegsusugid ku dimyu, minum ku mene et duruꞌ et ubas baꞌ meinum ku ne bagung duruꞌ dut ating eldew dut pegmimilikan et Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ganang nemekekanta ne nemenurung dye ne dut Bukid et mengeꞌ Olibo. ");
INSERT INTO plw_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Sinugid i Jesus kedye, “Kesimbakud kew ginsan sabab nekesurat, kwan, ‘Peteyen ku mengingipat, indyari megpekparak mengeꞌ bibili.’ ");
INSERT INTO plw_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Segwaꞌ, pegketbes megbiyag ku peuliꞌ meguna ku dimyu dut Galilea.” ");
INSERT INTO plw_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Negsugid si Pedro kenye, kwan, “Misan kesimbakud ginsan, segwaꞌ aku diki.” ");
INSERT INTO plw_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Sinugid i Jesus kenye, “Keberbenaran pegsugiren ku dimyu, tiban negang gebi mura memaluꞌ manuk et ikeruwa, ketlu mu aku isungu.” ");
INSERT INTO plw_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Segwaꞌ, sinugid ye et mepagen, kwan, “Misan keunung ku dimu matey, diki ku ikew isungu.” Kwantin nega gasi sinugid et ginsan. ");
INSERT INTO plw_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Siminurung dye dut Luluwakan et Olibo neng pegbikyanan et Getsemani. Sinugid ye et mengeꞌ pepengenaran ye, kwan ye, “Arung kew mena atue. Menelangin ku.” ");
INSERT INTO plw_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Segwaꞌ, pinebayaꞌ ye si Pedro, si Santiago, bekeꞌ si Juan. Timinagnaꞌ si Jesus riminupuk sampay negsusa banar. ");
INSERT INTO plw_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Sinugid ye kedye, “Merupuk banar atey ku seked ipatey ku. Atuꞌ kew e bekeꞌ megsulag.” ");
INSERT INTO plw_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ganang nekereꞌrayuꞌ ya sengkerit nepekleb ya apang menelangin na, baꞌ mekedyari lumibuas et kenye keliyutan. ");
INSERT INTO plw_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Kwan ye, “Abba (gay bersen, Amaꞌ ku), kayang ginis na diki mu mekeradya. Ugaraꞌ et daken itueng keliyutan bekeꞌ kemeteyan neng melebayan ku. Segwaꞌ, diki et gay ku baꞌ diki gay mu nega.” ");
INSERT INTO plw_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Pinekebian ye dye bekeꞌ neretengan ye dye memegigaꞌ. Kwan ye ki Pedro, “Simon, megigaꞌ ke takuꞌ a? Diki ke takuꞌ kesulag misan diki mekutkwit? ");
INSERT INTO plw_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Pegsulag kew bekeꞌ menelangin apang diki kew meraag et sulay. Nesewran ku na ingin myu keredyanen menunga, segwaꞌ, melama pemeyuhuan myu.” ");
INSERT INTO plw_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nugad ya peuliꞌ apang menelangin atin negang beres binres ye. ");
INSERT INTO plw_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Nepekabiꞌ ya peuliꞌ. Neretengan ye memegigaꞌ dye gasi, kuigaꞌ dye banar. Kaya lang mekesewran dye baꞌ enu isambag dye kenye. ");
INSERT INTO plw_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Iketlung pegkabiꞌ ye kwan ye kedye, “Megigaꞌ kew nega takuꞌ bekeꞌ petetaren? Sereng ne. Timpu ne et kesusaan. Birinaꞌ myu. Pinegdagang ne aku neng Yegang et Taaw dut mengeꞌ tegesalaꞌ. ");
INSERT INTO plw_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Pegbangun kew ne. Duun tyu ne. Birinaꞌ myu. Mekabiꞌ ne ating nengdagang daken.” ");
INSERT INTO plw_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Sekaliꞌ ganang megbebres nega si Jesus diminateng si Judas, sembatu et sempuluꞌ duwang pepengenaran ye. Megbebayaꞌ kenye mekansang taaw neng megbibibit et mengeꞌ keterman sampay pupukul. Teyeg dye dut mengeꞌ pegibuten et mengeꞌ pariꞌ, mengeꞌ menunulduꞌ et Keseraan, bekeꞌ mengeꞌ megurang et Sanedrin. ");
INSERT INTO plw_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Nengdagang kenye negey mena kedye et sinyal, kwan, “Baꞌ siuman ku ya, atin ne. Dekpaꞌ myu tebes dundunaꞌ myu ya.” ");
INSERT INTO plw_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Pegdateng pinekebian ye megtuy. Itue sinugid ye, kwan ye, “Menunulduꞌ!” Sampay inerkan ye ya. ");
INSERT INTO plw_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Kineptan dye ya apang elewen. ");
INSERT INTO plw_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Segwaꞌ, sembatung iba de Jesus petitiyeg duun giminabut et keterman ye bekeꞌ tinigbas ye uripen et metaas neng pariꞌ. Nebitas telinga et uripen. ");
INSERT INTO plw_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Sinugid i Jesus kedye, kwan ye, “Mengrerampas ku takuꞌ a? Manu megbibibit kew et keterman bekeꞌ pupukul mura elewen myu aku? ");
INSERT INTO plw_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Eldew-peldew iba myu aku dut templo duntin penulduꞌ ku. Segwaꞌ, kaya inalew myu aku. Tiban keilangan meinabu itue apang metuman mengeꞌ beres et Empuꞌ neng sinurat pasal et daken.” ");
INSERT INTO plw_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Angkansa, nememelegyu mengeꞌ pepengenaran. Tinirengan dye si Jesus. ");
INSERT INTO plw_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Maya siminunud kedye subur megsesamut et kedilew. Inewiran dye ya, ");
INSERT INTO plw_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","segwaꞌ tinektak ye kedilew neng samut ye bekeꞌ nelegyu et meglelbas. ");
INSERT INTO plw_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Binibit dye si Jesus dut metaas et pariꞌ bekeꞌ nemegtimung duntin mengeꞌ pegibuten et pariꞌ, mengeꞌ megurang et Sanedrin, sampay mengeꞌ menunulduꞌ et Keseraan. ");
INSERT INTO plw_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Nepesunud kenye si Pedro, segwaꞌ, merayuꞌ elangan dye. Nepelembus ya seked dut legwas et benwa et metaas neng pariꞌ. Sabab pemenengnarang megarung ya set abiʼt apuy iba ye mengeꞌ menununggu. ");
INSERT INTO plw_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Mengeꞌ pegibuten et pariꞌ sampay ginsan neng Sanedrin nemengebiyaꞌ et saksiꞌ ki Jesus apang imeteyen dye ya. Segwaꞌ, kaya nebiyanan dye. ");
INSERT INTO plw_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Sabab mekeldam negsaksiꞌ et embut pasal et kenye, angkansa, kaya negseꞌsaliꞌ mengeꞌ pebnar dye. ");
INSERT INTO plw_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Maya senu timinyeg negembut et pegsaksiꞌ dye, negsugid et samat itue, ");
INSERT INTO plw_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nekingeg kay sinugid ye, kwan, ‘Rungkaten ku itueng templo et Empuꞌ neng binaal et taw, segwaꞌ, pegketalib et telung eldew mebaraꞌ ne na kaya taaw nemaal.’ ” ");
INSERT INTO plw_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Misan ga in kaya pegseꞌsaliꞌ pegsaksiꞌ dye. ");
INSERT INTO plw_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Timinyeg metaas neng pariꞌ dut pinegketngaan et mengeꞌ taaw bekeꞌ iningkut ye si Jesus, kwan ye, “Kaya takuꞌ mesambag mu? Enu pegsumbungan et mengeꞌ taaw dimu?” ");
INSERT INTO plw_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Segwaꞌ, kaya giminibek. Kaya ya siminambag. Iningkut peuliꞌ et metaas neng pariꞌ, kwan, “Ikew takuꞌ si Kristo neng yegang et Empuꞌ na pegbebentugen et taw?” ");
INSERT INTO plw_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Siminambag si Jesus, kwan ye, “Asal aku. Mebiriꞌ myu aku neng Yegang et Taaw pegpeuliꞌ ku dut mengeꞌ inarak dut langit. Mebiriꞌ myu gasi na eset daken kebegbesagan et Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Angkansa, inuyat et metaas neng pariꞌ pekayan ye sabab et iseg. Kwan ye, “Manu keilangan tyu nega saksiꞌ? ");
INSERT INTO plw_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Kemyu ne nekekingeg et penerwa ye dut Empuꞌ. Enu pemikir myu?” Ginsan dye nengukum ne teup ya matey. ");
INSERT INTO plw_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Mayang iba timinagnaꞌ nibeg kenye. Linimbenan dye rupa ye bekeꞌ tinpal nega ya. Sinugiran dye, “Tekeraꞌ. Sinu timimpal dimu?” Sinuntuk nega ya et mengeꞌ menununggu. ");
INSERT INTO plw_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Duun negaʼt legwas si Pedro. Diminateng sembatung libun neng uripen et metaas neng pariꞌ. ");
INSERT INTO plw_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pegbiriꞌ ye penengnarang si Pedro tinengtengan ye ya bekeꞌ neres, “Iba ke nega i Jesus neng Nasareno.” ");
INSERT INTO plw_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Segwaꞌ, siminungu ya, kwan ye, “Kaya mekesewran ku etawa kaya mekeretian ku gay mu bersen.” Liminiwan ya dut lelengewan et bakud. Nemaluꞌ manuk. ");
INSERT INTO plw_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Nebiriꞌ ya et uripen neng libun bekeꞌ sinumbung ye gasi peuliꞌ dut mengeꞌ megtitiyeg duntin, kwan ye, “Itueng taaw iba dye.” ");
INSERT INTO plw_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Segwaꞌ, siminungu ya peuliꞌ. Pegketbes et ingga peꞌ nekutkwit banar sinugid gasi peuliꞌ ki Pedro et mengeꞌ taaw duntin, kwan dye, “Asal sembatu ke et kedye sabab taaw ke et Galilea.” ");
INSERT INTO plw_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Segwaꞌ, timinagnaꞌ ya megsumpaꞌ bekeꞌ mengibet, kwan, “Kaya mekekilala ku ating pegsugiren myu.” ");
INSERT INTO plw_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Sekaliꞌ nemaluꞌ manuk et ikeruwa. Nerendeman i Pedro sinugid i Jesus kenye, kwan, “Mura ikeruwa memaluꞌ manuk, iketelu mu aku isungu.” Angkansa, siminiyak et meklat si Pedro. ");
INSERT INTO plw_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Sekaliꞌ pegdiklem nemegisun-isun metaas neng pariꞌ, mengeꞌ menunulduꞌ et Keseraan, sampay mengeꞌ megurang iba dye keginsanan et Sanedrin. Pinepungpung dye si Jesus bekeꞌ binibit ki Pilato. ");
INSERT INTO plw_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Iningkut ya i Pilato, “Ikew takuꞌ Surutan et mengeꞌ Judio?” Siminambag si Jesus, kwan ye, “Ikew ne negsugid.” ");
INSERT INTO plw_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Mekansang sinumbung kenye et metaas neng pariꞌ. ");
INSERT INTO plw_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Iningkut ya peuliꞌ i Pilato, kwan ye, “Kaya takuꞌ mesambag mu? Nekingeg mu kansang et sinumbung dye pasal dimu.” ");
INSERT INTO plw_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Segwaꞌ, kaya ne siminambag si Jesus. Angkansa, negliluꞌ si Pilato. ");
INSERT INTO plw_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Mapet-mapet teun dut timpuʼt Kenkaan et Neketalib pepeliwan i Pilato sembatung nepipirisu. Misan sinu tewen mengeꞌ taw ipeliwan. ");
INSERT INTO plw_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Dut mengeꞌ megsagkaꞌ et Keseraan neng nekepatey kwit negatu-atu tagnaꞌ sembatung lelaki ingaran ye si Barabas. ");
INSERT INTO plw_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nepekabiꞌ ki Pilato mekansang taaw apang legesen ya na pasal et arat ye ne na megpeliwan nepirisu. ");
INSERT INTO plw_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Segwaꞌ, iningkut dye i Pilato, kwan ye, “Gay myu takuꞌ ipeliwan ku ating Surutan et mengeꞌ Judio?” ");
INSERT INTO plw_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Sabab nesewran ye imbeng lang sinelan et pegibuten et pariꞌ, angkansa, binibit et kenye. ");
INSERT INTO plw_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Segwaꞌ, ininduan et mengeꞌ pegibuten et pariꞌ mengeꞌ taaw na kwan, si Barabas tewen dye ipeliwan. ");
INSERT INTO plw_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Angkansa, iningkut dye peuliꞌ i Pilato, kwan ye kedye, “Baꞌ kwantin, enu gay myu keredyanen ku et pegbikyanan myu neng Mengmimilik et mengeꞌ Judio?” ");
INSERT INTO plw_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Nememres dye et mebasag, kwan dye, “Iransang ya dut krus.” ");
INSERT INTO plw_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Segwaꞌ, nengingkut si Pilato kedye et ketimpusan, kwan ye, “Manu? Enu keselaan ye?” Masi ga nemegberes et mebasag, kwan dye, “Iransang ya dut krus.” ");
INSERT INTO plw_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pagkaꞌ gay i Pilato telinganen mengeꞌ taw, angkansa, pineliwan ye si Barabas. Pineglelepsan ye si Jesus mura binggey ye kedye apang iperansang. ");
INSERT INTO plw_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Binibit si Jesus et mengeꞌ sundalu dut seled pretorio, bekeꞌ tiningkag dye ginsan neng pepehenen et sundalu. ");
INSERT INTO plw_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Pinebedyuan dye ya et meregang samat badyuꞌ et pegibuten et ginsan. Nenulapid dye gasi et suksuk apang ipepleng kenye. ");
INSERT INTO plw_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Timinagnaꞌ dye megmara kenye, kwan dye, “Biyagaꞌ, Surutan et mengeꞌ Judio.” ");
INSERT INTO plw_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Pineglelepsan dye et bungbung ulu ye bekeꞌ pinegigban-igban sampay pinegsedselukuran et ungkaꞌ. ");
INSERT INTO plw_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Pegketbes kesitan, linukasan dye ya et badyuꞌ bekeꞌ pinebadyuꞌ kenye peuliꞌ diri yeng badyuꞌ. Pineliwan apang iransang dut krus. ");
INSERT INTO plw_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Lineges dye mibit et krus i Jesus si Simon neng tawʼt Sirene, amaꞌ i Alejandro bekeꞌ i Rupo. Na timingkaꞌ esentin mawaꞌ ye dut uma ye. ");
INSERT INTO plw_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Binibit dye si Jesus dut Golgota, gay bersen, “Lungsud et Bengkarak.” ");
INSERT INTO plw_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Binggeyan dye et inumen neng mekelangu tegelamud et mebenglu. Segwaꞌ, kaya ininum ye. ");
INSERT INTO plw_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ganang neransang dye ne dut krus pinegbegbegian dye badyuꞌ ye. Pinegsugalan dye apang mesewran et tegsembatu kedye baꞌ enu meisiꞌ ye. ");
INSERT INTO plw_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Lisag siyam et diriklem pegransang dye ki Jesus dut krus. ");
INSERT INTO plw_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Sinurat dye dut ditdibuwat et krus sembatung sinumbungan pasal et kenye. “Surutan et mengeꞌ Judio.” ");
INSERT INTO plw_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Duwang menenakew pineringan dye et kenye rinansang, sembatu set kewanan bekeꞌ sembatu gasi set gibang ye. ");
INSERT INTO plw_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Netuman pegsugiren et Kesuratan, kwan, “Nebluan ya et sembatu dut nenglakad et Keseraan.” ");
INSERT INTO plw_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Sebarang megtetalib mengeꞌ taaw pepepikpirik dye ulu dye bekeꞌ nemenawey, kwan, “Naꞌ! Ikew mengrungkat kunuꞌ et templo pegketbes megpetiyeg pegketalib et telung eldew. ");
INSERT INTO plw_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Bewinaꞌ diri mu. Ineug ne et krus.” ");
INSERT INTO plw_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Kwantin gasi sawey et mengeꞌ pegibuten et pariꞌ sampay mengeꞌ menunulduꞌ et Keseraan, kwan, “Nemawiꞌ ya et iba, segwaꞌ, diri ye diki ye mebawiꞌ. ");
INSERT INTO plw_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Mineug keʼt krus tiban baꞌ ikew si Kristo neng Surutan et Israel apang mebiriꞌ tyu. Kaluꞌ mengandel tyu.” Sinawey gasi ya et iba yeng rinansang dut krus. ");
INSERT INTO plw_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ganang tengeldew ne, eldew liminingeb et sengkedunyaan seked lisag telu et mapun. ");
INSERT INTO plw_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ganang lisag telu net mapun negmara si Jesus et mebasag kwan ye, “Eloi, Eloi, lema sabakhtani?” gay bersen, “Empuꞌ ku, Empuꞌ ku, manu pinesaran mu aku?” ");
INSERT INTO plw_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Pegkingeg et senung megtitiyeg duun nemegsugid, kwan dye, “Birinaꞌ myu. Pegtingkagen ye si Elias.” ");
INSERT INTO plw_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Maya sembatu diminarak apang yagem ye sembatung pepekembang dut inum-inumen neng samat langgew. Dinatun ye et yuntuk et bungbung. Tinundul ye ki Jesus apang ipesepsep kenye, negsugid nega, kwan, “Pesaran mena. Birinen tyu enuʼt dumateng si Elias apang ipeineug ya dut krus.” ");
INSERT INTO plw_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Segwaꞌ, nengurangin et mebasag si Jesus mura nebugtuan et ginawa. ");
INSERT INTO plw_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Dingan gasi neuyat et petngaꞌ kumut neng diningding et templo tinegnanan dibuwat seked sanad. ");
INSERT INTO plw_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Maya lelaki neng petitiyeg dut teteyumanan et krus i Jesus. Kapitan ya et senggatus neng sundalu. Ganang nebiriꞌ ye na natey si Jesus negsugid, kwan, “Tantu banar yegang et Empuꞌ itueng taw.” ");
INSERT INTO plw_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Maya gasi mengeꞌ kelilibunan duun megpepayag et merayuꞌ. Duntin si Maria Magdalena bekeꞌ si Maria neng induꞌ i Jose sampay i Santiago neng ariꞌ ye. Duntin gasi si Salome. ");
INSERT INTO plw_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Kwit duun nega si Jesus et Galilea siminunud dye kenye bekeꞌ nemeruri kenye. Maya nega ibang kelilibunan neng timinungul dut Jerusalem neng iba de Jesus. ");
INSERT INTO plw_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ganang mapun et Eldew et Pegsakap, gay bersen, mura Eldew et Kepeternan, ");
INSERT INTO plw_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","inurem i Jose surungan si Pilato apang engaten ye bilug i Jesus. Tawʼt lungsud et Arimatea si Jose bekeꞌ sembatung pegibuten neng pegesipen dut Sanedrin. Megtetagey ya gasi et pegmilik et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Negliluꞌ si Pilato pegkabar ye natey ne si Jesus. Angkansa, pinetingkag ye kapitan et sundalu apang ingkuten ye baꞌ banar. ");
INSERT INTO plw_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ganang nesewran ye dut kapitan na patey ne tinugutan ye si Jose na isien bilug i Jesus. ");
INSERT INTO plw_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Nengelen si Jose et kedilew apang ibulung ye et bilug i Jesus neng dinatun ye dut batu neng binaal et lebeng, pegketbes tinelubid ye kelang batu dut lelengewan et lebeng apang itengleb. ");
INSERT INTO plw_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Si Maria Magdalena bekeꞌ si Maria neng induꞌ i Jose nekebiriꞌ baꞌ embe dinetunan ki Jesus. ");
INSERT INTO plw_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ganang nekelibuas ne Eldew et Kepeternan, si Maria Magdalena, bekeꞌ si Maria neng induꞌ i Santiago, sampay si Salome nengelen et bebengluen sabab sumurung dye dut lebeng apang ibalung dye et bilug i Jesus. ");
INSERT INTO plw_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Pegdiklem et meriklem nega siminurung dye dut lebeng. ");
INSERT INTO plw_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Nemegsudsugid dye, kwan, “Sinu ne tumelubid kityu et batu dut lelengewan et lebeng tiꞌ?” ");
INSERT INTO plw_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pegdateng dye nebiriꞌ dye netelubid ne peiged batu neng kelaꞌ banar. ");
INSERT INTO plw_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Angkansa, siminled dye et lebeng. Nebiriꞌ dye sembatung subur neng megbebadyuꞌ et meputiꞌ. Megarung ya et tampar kewanan. Nemegliluꞌ dye banar. ");
INSERT INTO plw_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Segwaꞌ, negsugid kedye, kwan ye, “Kas kew pegliluꞌ. Pegtulusen myu si Jesus neng taaw et Nasaret na rinansang. Negbiyag ne peuliꞌ. Kaya ne atue. Birinaꞌ myu dinetunan kenye. ");
INSERT INTO plw_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Segwaꞌ, panew kew, isugiraꞌ myu et mengeꞌ pepengenaran ye, sampay ki Pedro, na muna ya dimyu dut Galilea. Mekita myu ya duntin samat sinugid ye dimyu.” ");
INSERT INTO plw_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nemengdarak dye peugad dut lebeng. Nememigpig et pegliluꞌ sabab et takut dye. Angkansa, kaya lang negsugid dye et misan sinu. ");
INSERT INTO plw_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Itue gasi mengeꞌ ibang neinabu pegketbes et pegbiyag peuliꞌ i Jesus et keririkleman et Linggu. Nepebiriꞌ ya meguna mena ki Maria Magdalena. Itueng libun nepeugaran tagnaꞌ et pitung meyaat neng nakem neng siminaleb. ");
INSERT INTO plw_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Sinurungan i Maria mengeꞌ pepengenaran i Jesus apang ipabar kedye. Merupuk dye bekeꞌ megsisiyak nega. ");
INSERT INTO plw_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Segwaꞌ, kaya nengarap dye et sinugid i Maria kedye na negbiyag si Jesus sampay nepebiriꞌ kedye. ");
INSERT INTO plw_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Pegketbes, negpebiriꞌ gasi ya dut duwang pepengenaran ye et ibang dagbes ganang megpepanew dye peugad dut kebebenwanan. ");
INSERT INTO plw_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nepeuliꞌ dye apang ipabar gasi dut mengeꞌ iba dye, segwaꞌ, kaya lang nemengandel. ");
INSERT INTO plw_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ingga nekwit nepebiriꞌ gasi ya dut sempuluꞌ isa neng pepengenaran ye ganang megkekaan dye. Inusiatan ye dye sabab et kektulan et ulu dye bekeꞌ sabab et kaya lang pemengarap dut mengeꞌ iba neng nekebiriꞌ kenye pegketbes et pegbiyag ye peuliꞌ. ");
INSERT INTO plw_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Sinugid i Jesus kedye, kwan ye, “Surungiꞌ myu ginsan lungsud et dunyaꞌ apang mepelkep myu Menungang Abar dut ginsan neng mengeꞌ taw. ");
INSERT INTO plw_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Sinu mengandel bekeꞌ bewtismuan mapen keselaan dye. Segwaꞌ, sinu diki mengandel ukumen. ");
INSERT INTO plw_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Itue mengeꞌ tendaꞌ neng ipebiriꞌ et mengeꞌ pemengandel daken. Kepegbeꞌbayaꞌ ku gemiten dye apang mepeugad mengeꞌ meyaat neng nakem bekeꞌ kebres dye et lein-leing bebresan. ");
INSERT INTO plw_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Misan kepurut dye et seli etawa keinum dye et kekeilu, diki lang meenu dye. Megnunga gasi mayang tegesakit neng medpen dye et keremut dye.” ");
INSERT INTO plw_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Angkansa, pegketbes neres kedye si Begerar Jesus, pineribuwat ya dut lelegdengan et Empuꞌ bekeꞌ narung set kewanan et Empuꞌ Amaꞌ. ");
INSERT INTO plw_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Nememanew mengeꞌ pepengenaran i Jesus apang mengabar dut misan embeng lungsud. Tinebangan dye et Empuꞌ. Pinebnaran et Empuꞌ beres ye pinebiaꞌ et mengeꞌ tendaꞌ.");
INSERT INTO plw_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Metaas naꞌ si Teopilo: Mekeldam ne siminulay nesurat et usalan naꞌ pasal et mengeꞌ keginisan na netuman ne dut pinegketngaan tyu. ");
INSERT INTO plw_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Samat dut kedyeng pinepusakaꞌ neng mengeꞌ keginisan atuʼt damen na dye sengkepunan mengeꞌ saksiꞌ gasi sampay menunulduꞌ et beres. ");
INSERT INTO plw_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Daken, menang binusiksik banar ginsan neng keginisan neng neinabu tihad sengkepunan. Angkansa minenunga ku na sumurat et meatur naꞌ usulan dut dimu, metaas na si Teopilo, ");
INSERT INTO plw_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","apang mesewran mu ketignaan et ginsan neng usulan na tinulduꞌ dimu. ");
INSERT INTO plw_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Kwit si Herodes surutan dut Judea, maya sembatung pariꞌ, ireg bersen pegibuten et mengempuan ngaran ye si Sakarias, mawaꞌ dut pengkatan i Abias sembatung pengkatan et mengeꞌ pariꞌ. Esawa i Sakarias si Elisabet neng inupuꞌ gasi i Aaron ating munang pariꞌ et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Saliꞌ dye metignaꞌ dut elepan et Empuꞌ, megsunud dye dut ginsan neng saraꞌ sampay mengeꞌ arat et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Megurang dye ne saliꞌsaliꞌ segwaꞌ kayangga yegang dye sabab si Elisabet bantut. ");
INSERT INTO plw_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Negtekaꞌ gasi pangkat i Sakarias megkeradya bilang pariꞌ dut pegpengempuan naꞌ benwa dut elepan et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Samat arat et mengeꞌ pegpariꞌ, pesukuran dye baꞌ sinu kedye, sumled dut pegpengempuan naꞌ benwa indyari neginalep si Sakarias netiruan dye na sumled dut pegpengempuan naꞌ benwa apang mengruhung et kemengyan. ");
INSERT INTO plw_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Sasat kenye pengruhung et kemengyan dut seled, mengeꞌ taaw memegpenalang gasi dut liwan. ");
INSERT INTO plw_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Na maya dereakan et Empuꞌ negpebiriꞌ dut kenye. Megtitiyeg dut tampaꞌ kewanan et pegrungruhungan et kemengyan. ");
INSERT INTO plw_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Neknaran si Sakarias pegkebiriꞌ ye dut dereakan et Empuꞌ, indyari diminateng kenye takut. ");
INSERT INTO plw_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Segwaꞌ kwaʼt dereakan et Empuꞌ dut kenye, “Kas takut Sakarias, pasal dimung penelang kiningeg net Empuꞌ. Esawa mung si Elisabet megyegang et lelaki, na pengeraniꞌ et Juan. ");
INSERT INTO plw_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Dut pegganak kenye diki lang ikew meksanan sampay gasi kineldaman, ");
INSERT INTO plw_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","sabab itueng si Juan megmendyaring metaas dut elepan et Empuꞌ. Diki ya minum et mekelangu etawa meiseg neng mengeꞌ iinumen. Tihad nega dut seled beteng et induꞌ ye, selban ne ya et Empung Menungang Nakem. ");
INSERT INTO plw_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Mekansang keyegangan dut bangsa i Israel na mepeuliꞌ ye dut Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Na itueng si Juan muna dut derateng nemiliꞌ Empuꞌ et memegbeg. Naꞌ sumaleb ki Juan nakem bekeꞌ basag et Empuꞌ samat ki Elias neng tarus et Empuꞌ tagnaꞌ. Supaya si Juan memegsulut mengeꞌ kegunggurangan dut keyegangan bekeꞌ mengeꞌ merurupang megkesewd sumunud dut metignaꞌ. Ipepanyap si Juan sembatung bangsa dut Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Iningkut i Sakarias dereakan et Empuꞌ, kwan, “Enukwan kesesewd ku et itue? Sabab aku megurang ne bekeꞌ esawa ku tinugan net tapis.” ");
INSERT INTO plw_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Siminambag dereakan et Empuꞌ, kwan, “Aku si Gabriel, na megtitiyeg dut elepan et Empuꞌ, na dinaak supaya megsugid et menungang abar dut dimu. ");
INSERT INTO plw_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Sabab diki ke nengandel, birinaꞌ, tihad tiban megumew ke sampay diki ke ne kebres seked dut eldew na metuman ginsan.” ");
INSERT INTO plw_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Negliluꞌ mengeꞌ taaw na baꞌ manu si Sakarias neng pegtetegeyen dye nekwit dut pegpengempuan neng benwa et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Pegliwan i Sakarias kaya ne mekebres angkansa tendes dye maya negpebiriꞌ kenye dut seled pegpengempuan neng benwa. Aluꞌ ye tulduꞌ mene, kaya ne mekebres. ");
INSERT INTO plw_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ganang nepuspus ne timpu et pegkeradya ye, nuliꞌ ne ya dut lelegdengan ye. ");
INSERT INTO plw_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Pegketbes kaya nekwit eldew, negmengirem ne si Elisabet. Seled limang bulan dun lang et seled benwa. ");
INSERT INTO plw_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Ingasiꞌ daken et Empuꞌ itue,” kwan i Elisabet, “Ketimpusan, sinyekan ye aku supaya meugad seseweyan daken et mengeꞌ taaw!” ");
INSERT INTO plw_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ganang ikeenem neng bulan et kebtangan i Elisabet, dinaak et Empuꞌ dereakan neng si Gabriel supaya sumurung dut lungsud et Nasaret sakup et Galilea, ");
INSERT INTO plw_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","dut sembatung umawey naꞌ nemeupakat ibulun dut lelaki ingaran ye si Jose teyeg dut pengkatan i Surutan Dabid tagnaꞌ. Ingaran et umawey in si Maria. ");
INSERT INTO plw_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Negpekabiꞌ kenye si Gabriel, kwan ye, “Mesukud ke sabab ikew lang naꞌ natiruaʼt libung mergaꞌ angkan nepiliꞌ ke et Empuꞌ. Empuꞌ esen net dimu.” ");
INSERT INTO plw_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Neriwaraꞌ ne banar si Maria dut binres et dereakan kenye, pegpikiren ye ne banar baꞌ enu ingin bersen. ");
INSERT INTO plw_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Sinugid et dereakan ki Maria, “Kas takut Maria, sabab maya kasi dimu et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Birinaꞌ lang, megbeteng ke sampay megyegang et sembatung lelaki na ipengaran mu kenye Jesus. ");
INSERT INTO plw_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Megmendyaring metaas ya et ginsan bekeꞌ ngeranen ya na Yegang et Empung metaas ne banar. Igbey kenye et Empuꞌ eerungan et kegunggurangan yeng si Surutan Dabid tagnaꞌ. ");
INSERT INTO plw_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Na, ya memegbeg dut mengeꞌ tungtung-inupuꞌ i Jakob et kaya keskeran. Na, kaya seked pemegbeg ye.” ");
INSERT INTO plw_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Nengingkut si Maria dut dereakan et Empuꞌ, kwan ye, “Enukwan itue meinabu, kayangga peꞌ esawa ku?” ");
INSERT INTO plw_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Siminambung dereakan et Empuꞌ kenye, kwan ye, “Detengan ke et Menungang Nakem et Empuꞌ bekeꞌ mentek dimu basag et Empuꞌ neng metaas banar. Angkansa ating ipegyegang metignaꞌ banar bekeꞌ ngeranen na ya yegang et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Misan si Elisabet na kampung mu meumur ne, segwaꞌ negbeteng nega. Na ya kwit tiꞌ pegsugiren bantut, segwaꞌ tiban enem neng bulan ne kebtangan ye. ");
INSERT INTO plw_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Sabab misan enu nega, kaya meliyut dut Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Kwan i Maria, “Uripen aku et Empuꞌ. Memnar teyen dut daken samat pegbersen mu daken in.” Pegketbes, tinirengan ne ya et dereakan et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Pagkaꞌ kwantin ne et ating eldew negpanyap deꞌdaliꞌ si Maria siminurung dut kebudbukiran et sakup et Judea. ");
INSERT INTO plw_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Pegdateng ye, inempangan ye si Elisabet, pegketbes neglembus ne dut seled benwa i Sakarias. ");
INSERT INTO plw_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Pegkekingeg i Elisabet et ampang i Maria, nenggibek memulek dut seled beteng ye. Indyari nesled si Elisabet et Menungang Nakem naꞌ Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Angkansa neres et merensag si Elisabet ki Maria kwan ye, “Ginsan et mengeꞌ libun ikew lang mesukud, bekeꞌ mesukud gasi memulek na ipengganak mu. ");
INSERT INTO plw_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Segwaꞌ manu takuꞌ aku nega kiminulew daken na ating induꞌ et Begerar ku? ");
INSERT INTO plw_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Sabab birinaꞌ, ganang nekingeg ku ampang mu diminingan gasi nenggibek memulek dut seled beteng ku sabab et ya neksanan. ");
INSERT INTO plw_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Mesukud ke sabab nengandel ke na metuman dut dimu beres et Empuꞌ banar.” ");
INSERT INTO plw_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Kwan i Maria, “Pegbentugen et pusuꞌ ku Begerar in. ");
INSERT INTO plw_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Bekeꞌ meksan nakem ku dut Empuꞌ, sabab ya memawiꞌ daken. ");
INSERT INTO plw_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Sabab dinengdeng et Empuꞌ kelelewan ku neng uripen ye, sabab birinaꞌ tiharan tiban, pangkat-megpangkat naꞌ ginsan neng mengeꞌ taaw sugiren dye aku mesukud. ");
INSERT INTO plw_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Sabab Empuꞌ naꞌ sembatung mekewasa na nemuwat daken et kelang ginis, ya metignaꞌ banar. ");
INSERT INTO plw_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Pegingesinan et Empuꞌ sebarang pemengandel dut kenye teyeg dut pangkat-megpangkat naꞌ mengeꞌ taaw. ");
INSERT INTO plw_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Negpebiriꞌ ya et kenyeng kewasa angkan pinegpekparak ye ginsan neng mengeꞌ pebiꞌbiriꞌ neng mengeꞌ penedseled. ");
INSERT INTO plw_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Pegugaren et Empuꞌ mengeꞌ surutan dut kedyeng mengeꞌ gerar, segwaꞌ pegpetaas sebarang mepekumbaba naꞌ pusuꞌ. ");
INSERT INTO plw_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Pinebiyagan et Empuꞌ mengeꞌ meurap et menunungang ginis, segwaꞌ pineugad ye mengeꞌ mentiriꞌ kaya ne bibit et mengeꞌ enu-enu. ");
INSERT INTO plw_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Tinebangan et Empuꞌ mengeꞌ uripen yeng mengeꞌ tawʼt Israel. Kaya linipatan et Empuꞌ tinangeꞌ ye ne meingesinen ye kityu. ");
INSERT INTO plw_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Samat pinesewd et Empuꞌ dut mengeꞌ kegunggurangan tyu, dut ki Abraham sampay dut mengeꞌ tungtung-inupuꞌ ye.” ");
INSERT INTO plw_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Telung bulan kwit et legdeng i Maria dut ki Elisabet mura nuliꞌ. ");
INSERT INTO plw_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Napet ne timpu et penggenakan i Elisabet negyegang ne ya et sembatung lelaki. ");
INSERT INTO plw_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Nekekingeg mengeꞌ rurungan ye sampay mengeꞌ kekempungan ye na ya iningesinan ne et Begerar naꞌ Empuꞌ. Neksanan dye kenye. ");
INSERT INTO plw_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Pegdateng et ikewalung eldew, negsirateng dye supaya metulian memulek, pengeranan dye teyen si Sakarias samat ingaran et amaꞌ in. ");
INSERT INTO plw_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Segwaꞌ sinugid et induꞌ ye kwan ye, “Diki, segwaꞌ ipengaran kenye Juan.” ");
INSERT INTO plw_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Segwaꞌ kwan dye, “Kaya megngengaran et samat kwantin dut kekempungan mu.” ");
INSERT INTO plw_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Angkansa pinuhunan dye mena amaꞌ apang mesewran dye baꞌ enu ipengaran dut memulek. ");
INSERT INTO plw_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Indyari neneew si Sakarias et mesuratan ye. Pegketbes samat kwantin sinurat ye, “Juan ingaran ye.” Indyari negliluꞌ dye ginsan. ");
INSERT INTO plw_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Atin peꞌ nekelengwaꞌ ne beres ye bekeꞌ metugnaꞌ ne pememresan ye angkansa negbantug ne dut Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Nemenakut mengeꞌ rurungan dye, sampay dut kebudbukiran et Judea, atin lang pegsusugiren dye. ");
INSERT INTO plw_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Sebarang nemekekingeg nemegliluꞌ, kwan dye, “Enu mesurungan et yengyegang naꞌ itue? Sabab pegeebayan ya et Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Si Sakarias neng amaꞌ et yengyegang sineleb et Menungang Nakem naꞌ Empuꞌ bekeꞌ negtetari et samat kwantin: ");
INSERT INTO plw_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Kebegbentugan naꞌ Begerar naꞌ Empuꞌ, Empuꞌ et bangsa et Israel, sabab pineruri ye sampay lingkat ye kenyeng mengeꞌ taaw. ");
INSERT INTO plw_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Negpetiyeg ya dut kityu et ating mekseg neng mememawiꞌ. Na ya teyeg dut tungtung-inupuꞌ i Surutan Dabid neng surutan tagnaꞌ neng uripen ye. ");
INSERT INTO plw_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Samat tinangeꞌ et Empuꞌ tagnaꞌ tiꞌ, pebiyaꞌ et mengeꞌ tarus et Empuꞌ itue: ");
INSERT INTO plw_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Nebawiꞌ tyu ne dut kesagkaꞌ tyu sampay neagew ne kityu dut keremut et ginsan neng pengisegan kityu. ");
INSERT INTO plw_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Buwaten et Empuꞌ itue supaya iperasa Ye Kenyeng ingasiꞌ dut mengeꞌ kegunggurangan tyu sampay merendeman gasi Kenyeng penektak, ");
INSERT INTO plw_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","bekeꞌ tinangeꞌ naꞌ sinumpaan ye dut ki Abraham neng keupuꞌupuan tyu, ");
INSERT INTO plw_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","supaya mepuwas tyu dut mengeꞌ penggewman et kesagkaꞌ tyu, apang kesukuꞌ tyu ne dut kenye na kaya ne takut. ");
INSERT INTO plw_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Dut elepan ye na maya kenunganan bekeꞌ ketignaan sasat kityu pebibiyag. ");
INSERT INTO plw_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Pasal dimu Juan, daken neng yegang, ngeranen ke et tarus et ketaasan banar na Empuꞌ, sabab muna ke dut pegibuten supaya memanyap et dalan ye, ");
INSERT INTO plw_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","bekeꞌ megpesewd dut mengeꞌ taaw ye pasal et kedyeng keselaan na maya ne keempunan. Angkansa nelkat dye ne. ");
INSERT INTO plw_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Itue sabab et menungang ingasiꞌ et Empuꞌ dut kityu, ating mememawiꞌ samat eldew neng siminimpar teyeg dut langit, ");
INSERT INTO plw_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","supaya memenyar dut kedye na sebarang pemengibiyagan dut kelingban bekeꞌ dut kalung et kepeteyan, supaya turunan tiked tyu dut dalan na kaya kesesewan.” ");
INSERT INTO plw_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Suminangpet ne yengyegang i Sakarias bekeꞌ negnekman ne. Dut kelnangan linegdengan ye seked dut eldew na tumagnaꞌ ya et keradya ye dut bangsa Israel. ");
INSERT INTO plw_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ating masa, si Augusto Sesar, surutan et Roma, negbuwat et saraꞌ na megpelista ginsaʼt mengeꞌ taaw dut sengkelungsuraʼt Roma. ");
INSERT INTO plw_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Itue una neng pegpepelista ganang Si Kirenio Gobernador et Siria. ");
INSERT INTO plw_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Angkan mengeꞌ taaw siminurung dut kedye-kedyeng lungsud supaya megpelista. ");
INSERT INTO plw_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Angkansa tihad dut Nasaret, neng lungsud et Galilea, timinungul de Jose dut Betlehem, lungsud et Judea, ating lungsud i Surutan Dabid tagnaꞌ, sabab si Jose tungtung-inupuꞌ nega i Surutan Dabid. ");
INSERT INTO plw_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Siminurung dye supaya megpelista. Iba ye si Maria naꞌ tunang ye, segwaꞌ ating masa mentung ne. ");
INSERT INTO plw_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ganang dun dye ne, diminateng ne timpuʼt penggenakan i Maria. ");
INSERT INTO plw_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Indyari, pinegyegang ye ne uluanak ye, na sembatung lelaki. Kinumutan ye, pegketbes dinatun ye dut kurerewan. Na dye dut sisirungan et mengeꞌ ayup sabab kaya ne sisingled na supaya meigaan dye dut benwa neng pepeigaaʼt mengeꞌ taaw. ");
INSERT INTO plw_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Indyari duntin maya mengeꞌ mengingipat et bibili dut mekabiʼt luluwaken megdidiyaga et daran misan gebi. ");
INSERT INTO plw_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Indyari negpebiriꞌ kedye sembatung dereakan et Begerar naꞌ Empuꞌ, indyari benyar et Begerar naꞌ Empuꞌ nenyar dut pelibut dye. Pagkaꞌ kwantin ne, nemeketakut dye. ");
INSERT INTO plw_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Segwaꞌ kwaʼt dereakan et Empuꞌ dut kedye, “Kas kewʼt takut, sabab maya bibit ku Menungang Abar neng ikeksan dimyu banar sampay dut ginsaʼt mengeꞌ taaw. ");
INSERT INTO plw_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Sabab ye ipinegyegang tiban sembatung Mememawiꞌ dut lungsud i Surutan Dabid tagnaꞌ, na ya ne si Kristo neng Begerar. ");
INSERT INTO plw_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Na, itue mendyaring tendaꞌ dut dimyu: Na baꞌ mebiyanan myu sembatung memulek na pegkukumutan bekeꞌ pebubuntul dut kurerewan na dut benwa neng pepeigaaʼt mengeꞌ ayup.” ");
INSERT INTO plw_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kuminlat lang timimbuꞌ kelang rupung et mengeꞌ dereakan teyeg dut langit na pebebayaꞌ sembatung dereakan et Empuꞌ na megbebantug dut Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Kwan dye, “Kebegbentugan dut Empuꞌ na dut langit banar, bekeꞌ dut sengkedunyaan maya kesenangan dut mengeꞌ taaw neng kekesian ye.” ");
INSERT INTO plw_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Indyari timinireng ne kedye dereakan et Empuꞌ pegketbes siminurung dye ne dut langit. Indyari mengeꞌ mengingipat et mengeꞌ bibili nemegisun-isun dye, kwan dye, “Dumuntin tyu dut Betlehem apang birinen itueng ipinesewd kityu et Begerar naꞌ Empuꞌ in.” ");
INSERT INTO plw_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Deraliꞌ ginsan panew dye. Indyari nebiriꞌ dye si Maria bekeꞌ si Jose, pegketbes nebiyanan dye ne memulek neng pebubuntul et kurerewan et pepekanaʼt sapiꞌ na dut benwa neng pepeigaaʼt ayup in. ");
INSERT INTO plw_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Naꞌ ganang nebiriꞌ dye ne si Jesus, pinesewd dye ne baꞌ enu sinugid kedye et dereakan pasal et memulek naꞌ itue. ");
INSERT INTO plw_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Sebarang nekekingeg negliluꞌ dye pasal dut mengeꞌ sinugid kedye et mengingipat et mengeꞌ bibili in. ");
INSERT INTO plw_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Segwaꞌ tinaguꞌ ne i Maria dut seled pusuꞌ itueng ginis na neinabu, bekeꞌ pegpirpikiren ye ne dut seled pusuꞌ ye. ");
INSERT INTO plw_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Indyari negpeuliꞌ ne mengeꞌ mengingipat et mengeꞌ bibili in, na memegdayew bekeꞌ memegbantug dut Empuꞌ sabab nebiriꞌ dye ginsan neng ginis naꞌ sinugid dut kedye in. ");
INSERT INTO plw_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Pegdateng et ikewalung eldew tinulian ne ya, indyari pinengeranan dye ne ya et si Jesus, ngaran naꞌ binggey et dereakan et Empuꞌ kwit ya ingga peꞌ pinegbeteng. ");
INSERT INTO plw_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ganang diminateng ne epat ne puluꞌ eldew pegketebes pinengganak i Maria, diminuntin dye dut lungsud et Jerusalem apang metuman dye arat et kedyeng kegunggurangan pasal et pegbasaꞌ, sabab atin ne set Keseraan binggey et Empuꞌ ki Moises. Si Jose bekeꞌ si Maria nemibit i Jesus supaya itampar dut elepan et Begerar naꞌ Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Sabab samat kwantin sugid dut Kesuratan naꞌ Keseraan et Begerar naꞌ Empuꞌ, “Itampar dut Empuꞌ Sebarang Uluanak naꞌ lelaki” ");
INSERT INTO plw_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Bekeꞌ kwaʼt Kesuratan, “Megey dye dut Empuꞌ et duwang aksang naꞌ lumbuꞌ etawa upa.” Na itueng tendaꞌ et pegsunud dye dut Keseraan et Begerar naꞌ Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Na maya sembatung lelaki dut Jerusalem si Simeon, ingaran ye. Metignaꞌ sampay meinempuen. Megtetagey ya dut mekekulpas et bangsa et Israel. Atin Nakem et Empuꞌ eset kenye. ");
INSERT INTO plw_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Pinesewran ne lagi et Nakem et Empuꞌ na ya ingga matey seked mebiriꞌ ye Kristo et Empuꞌ naꞌ Begerar. ");
INSERT INTO plw_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Pinepanew ya et Nakem et Empuꞌ na sumurung dut pengempuan neng benwa. Ganang binibit ne yengyegang naꞌ si Jesus et mengeꞌ gunggurang ye supaya buwaten dut kenye arat neng pinegeratan i Moises. ");
INSERT INTO plw_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Pegdateng ye duntin, ginegeꞌ i Simeon yengyegang, peiibut pemantug ye dut Empuꞌ kwan ye: ");
INSERT INTO plw_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Metaas naꞌ Begerar naꞌ Empuꞌ, isiaꞌ ku ne tiban. Sabab nebiriꞌ ku ketumanan et tangeꞌ Mu daken, angkansa mekedyari Mu ne tiban bewinen et biyag et uripen Mu. ");
INSERT INTO plw_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Selus sabab et nebiriꞌ ne et mengeꞌ mata ku Mememawiꞌ Mu, itueng yegang si Jesus, ");
INSERT INTO plw_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","na pinanyap Mu itue dut elepan et ginsan neng mengeꞌ tawʼt dunyaꞌ. ");
INSERT INTO plw_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Pasal kenye, ya samat sembatung siluꞌ mebunayag dut mengeꞌ leing-leing bangsa, na ikebantug gasi dut dimung mengeꞌ tawʼt Israel.” ");
INSERT INTO plw_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Amaꞌ bekeꞌ induꞌ et yengyegang negliluꞌ sabab dut mengeꞌ binres pasal si Jesus yegang dye. ");
INSERT INTO plw_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Indyari ininunga dye i Simeon. Kwan ye dut ki Maria neng induꞌ i Jesus in, “Indaniꞌ negmendyari itueng yengyegang naꞌ itue dut ikeranggaꞌ bekeꞌ ikebawiꞌ et mengeꞌ tege-Israel eset Empuꞌ. Si Jesus sembatung tendaꞌ teyeg dut Empuꞌ na pegsagkaꞌ mekansang mengeꞌ tawʼt Israel. ");
INSERT INTO plw_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Angkansa mebuar pegpipikiren et kineldaman. Bekeꞌ rupuk samat sembatung keterman ketugsuk dut kurudua mu, Maria.” ");
INSERT INTO plw_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Indyari maya gasi sembatung tarus naꞌ libun na si Ana, na yegang i Panuel teyeg dut pengkatan i Aser. Megurang ne ya banar. Seled pitung teun lang kwit et pegesawa dye. ");
INSERT INTO plw_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Indyari nebeluan ne, negumuran lang et walumpuluꞌ epat. Daran lang ye dut Templo neng benwa et Empuꞌ. Aluꞌ ye mengempuꞌ, megpenelang eldew sampay gebi, sengmenu pegpuasa. ");
INSERT INTO plw_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Na ating masa nepekabiꞌ si Ana dut kire Jose, na megpeselamat dut Empuꞌ bekeꞌ negberes pasal dut ki Jesus dut ginsan na megtetagey et kelkatan et lungsud et Jerusalem. ");
INSERT INTO plw_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ganang nebuwat ne de Jose bekeꞌ i Maria ginsan neng usulan pasal Keseraan et Begerar naꞌ Empuꞌ, negpeuliꞌ dye ne dut Nasaret, na kedyeng lungsud et Galilea. ");
INSERT INTO plw_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Siminangpet bekeꞌ basag ating yengyegang, baha et kesesewran sampay enep et Empuꞌ eset kenye. ");
INSERT INTO plw_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Teun-peteun megtungul dut Jerusalem mengeꞌ gunggurang i Jesus sabab et Kenkaan pasal et Neketalib. ");
INSERT INTO plw_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ganang sempuluꞌ duwang teun ne umur ye, nemenungul dye, sabab diminateng ne gasi kenkaan na kenyeng gunggurang pinegeratan. ");
INSERT INTO plw_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pagkaꞌ tebes ne kenkaan peguliꞌ et mengeꞌ gunggurang ye, segwaꞌ si Jesus nepetektak dut Jerusalem. Na kaya pegsesewren dye. ");
INSERT INTO plw_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Seled pikiran dye na si Jesus pebebayaꞌ dut ibang rupungan, angkansa sengmapun ne pinegpenewan dye mura dye nepikir tulusen dut kekempungan bekeꞌ dut mengeꞌ bilaꞌ dye. ");
INSERT INTO plw_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Pagkaꞌ diki ne mebiyanan dye, nepeuliꞌ dye gasi dut Jerusalem supaya menulus kenye. ");
INSERT INTO plw_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Iketlung eldew, nebiriꞌ dye ne si Jesus dut seled et pengempuan naꞌ benwa, megearung dut pinegketngaaʼt mengeꞌ menunulduꞌ megkikingeg bekeꞌ pengingkut dut kedye. ");
INSERT INTO plw_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Indyari sebarang nekekingeg ki Jesus in, neliluꞌ dye dut kenyeng kesesewran bekeꞌ dut mengeꞌ tubag ye. ");
INSERT INTO plw_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ganang nebiriꞌ dye ne ya et gunggurang ye, liniluꞌ dye ya, kwan dye, “Manu itue binwat mu damen? Aku bekeꞌ amaꞌ mu nesusa et penulus dimu.” ");
INSERT INTO plw_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","“Manu pegtulusen myu aku?” kwan i Jesus. “Diki myu be nesewran na aku subaliꞌ dut benwa et Amaꞌ ku?” ");
INSERT INTO plw_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Segwaꞌ kaya neretian de Jose baꞌ enu pinegberes i Jesus dut kedye. ");
INSERT INTO plw_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Indyari timinugpa ne si Jesus pesurung dut Nasaret, iba ye ne mengeꞌ gunggurang ye. Na si Jesus sembatung mesinururen na yegang. Segwaꞌ itueng ginis neng neinabu tinaguꞌ et induꞌ ye dut seled pusuꞌ ye. ");
INSERT INTO plw_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Megsesangpet peꞌ si Jesus, dimineklaꞌ kesesewran ye, negnunga deregbesan ye bekeꞌ keireg-ireg dut Empuꞌ sampay dut mengeꞌ taaw. ");
INSERT INTO plw_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ganang ikesempuluꞌ limang teun ne, atin ne kekwiten et pegkepet i Tiberio Sesar, na ya surutan et Roma, dut timpu naꞌ atin si Ponsio Pilato Gobernador dut Judea, Si Herodes Gobernador et Galilea bekeꞌ tipused yeng si Pelipe Gobernador gasi dut Iturea bekeꞌ Trakonite, Si Lisanias gasi Gobernador dut Abilinia. ");
INSERT INTO plw_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Si Anas bekeꞌ si Kaipas, dye metaas naꞌ pariꞌ ating masa. Indyari diminateng beres et Empuꞌ dut ki Juan naꞌ yegang i Sakarias. Na lumegdeng si Juan et ating masa dut kelnangan. ");
INSERT INTO plw_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Sinurungan ye ginsaʼt mengeꞌ kebeberiuan neng pelilibut dut danumen et Jordan, na pegabar ye pasal et bewtismu et tendaꞌ et pasal pegsusun dye supaya maya kemeapan et keselaan. Naꞌ itueng keradya i Juan. ");
INSERT INTO plw_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Samat dut Kesuratan et Empuꞌ neng sinurat i Isaias naꞌ sembatung tarus et Empuꞌ tagnaꞌ, na samat kwantin tutugnaan ye: “Maya sembatung epelagew et tingkag dut kelnangan, kwanen ye, ‘Penyapaꞌ myu dalan et Empuꞌ, ipetignaaꞌ myu bebyaan ye! ");
INSERT INTO plw_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Sebarang mebelnek subaliꞌ timbunan, sebarang mebukid subaliꞌ tebagen, sebarang mebeliwet naꞌ dalan subaliꞌ petignaen, bekeꞌ mengeꞌ melingkatud subaliꞌ penyasen. ");
INSERT INTO plw_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Indyari mebiriꞌ et ginsaʼt taaw kepuwasan et Empuꞌ!’ ” ");
INSERT INTO plw_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Angkansa binres i Juan dut kineldaman neng memegsusurung dut kenye, kwan ye, “Kemyung mengeꞌ merurupang, samat pengkatan kew et seli! Sinu negpeamay-amay dimyu na menangkis dut iseg et Empuꞌ naꞌ dumateng? ");
INSERT INTO plw_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Angkansa ipebirinaꞌ myu mena buaꞌ et dimyung pegsusun. Na, kasiꞌ myu isugiraꞌ tiban na kemyu tuꞌ keupuꞌupuan i Abraham, sabab isugid ku dimyu sebanar, mekepeliwan Empuꞌ et keyegangan i Abraham atuʼt kebebetuan naꞌ itue. ");
INSERT INTO plw_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Neꞌ, tiban iseg et Empuꞌ dut dimyu samat pereratun naꞌ kapa dut gamut et mengeꞌ kayu. Angkan sebarang mengeꞌ kayu na diki muaꞌ et menununga, atin tuuy ne pemutken ampaꞌ ne iyuntur dut apuy.” ");
INSERT INTO plw_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","“Enu ne buwaten kay tiban?” ingkut et kineldaman. ");
INSERT INTO plw_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Siminambag si Juan kwan ye, “Na baꞌ ya megbebadyuꞌ et duwa, igbey ye sembatu in dut kaya badyuꞌ, bekeꞌ sebarang maya pegkaan demikian kwantin gasi buwaten ye.” ");
INSERT INTO plw_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Indyari maya mengeꞌ menunukut et buwis siminurung kenye, supaya mememewtismu kwan dye, “Begerar, enu ne buwaten kay?” ");
INSERT INTO plw_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Sinambag Ye dye, kwan ye, “Pasal dimyu, kas kewʼt penukut et lebi.” ");
INSERT INTO plw_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Mengeꞌ kesundeluan gasi nemengingkut kenye, kwan dye, “Enu ne damen buwaten kay?” Sinambag ye dye, kwan ye, “Kas kewʼt pengleges dut mengisiꞌ et pirak dut mengeꞌ taaw, bekeꞌ kas kewʼt penaksir misan kaya keberbenaran, bekeꞌ mesdengan kew ne baꞌ senu tengdan dimyu.” ");
INSERT INTO plw_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Memegenep net tagey mengeꞌ taaw. Segwaꞌ ginsan dye nebluan, sabab kwan dye lang tuꞌ si Juan in atin ne si Kristo naꞌ pegtetegeyen dye. ");
INSERT INTO plw_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Segwaꞌ negsugid si Juan dut kedye, kwan ye, “Pegbewtismu ku dimyu pasal danum, temed maya sembatung pesusunud dut daken lebing mekseg dut daken, na ya megbewtismu dimyu pasal dut Empung Nakem, bekeꞌ pasal dut apuy. ");
INSERT INTO plw_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ya samat mengguguyas dut guguyasan. Sebarang mengeꞌ parey, atin puguen ye dut legkew, segwaꞌ sebarang mengeꞌ apa bekeꞌ kilulu, atin tutungen ye dut apuy naꞌ kaya kepesewan.” ");
INSERT INTO plw_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Indyari, mekansang neng ginis pinenektak i Juan sampay nenulduꞌ nega et Menungang Abar dut mengeꞌ taaw. ");
INSERT INTO plw_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Segwaꞌ si Gobernador Herodes binresan i Juan sabab dut ki Herodes neng inagew ye, sampay nemegbulun ne. Sabab si Herodias neng esawa et tipused ye bekeꞌ diki lang et atin mekansang negang mengeꞌ mereraat naꞌ binwat ye. ");
INSERT INTO plw_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Nerugnan ne gasi i Surutan Herodes et atin salaꞌ ye, sabab et pinepirisu ye si Juan. ");
INSERT INTO plw_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Pagkaꞌ nebewtismuan ne i Juan ginsaʼt mengeꞌ taaw neng nemengduntin in, megdemikian sampay si Jesus negpebewtismu ne gasi dut ki Juan. Pegketbes na ya nebewtismuan, negpenalang ne, pegpenelang ye neukaban langit. ");
INSERT INTO plw_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Indyari nineug kenye Menungang Nakem naꞌ Empuꞌ samat dagbes et aksang. Indyari maya beres nekingeg teyeg dut langit, kwan ye, “Ikew lang naꞌ pegmerganen ku naꞌ yegang, mekeksanan ku banar dut dimu.” ");
INSERT INTO plw_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Megumur net telumpuluꞌ si Jesus, atin ne pegtagnaꞌ yeʼt pegkeradya dut pinesukuꞌ kenye. Dut kesesewran et mengeꞌ taaw na si Jesus yegang i Jose na yegang i Eli, ");
INSERT INTO plw_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","si Eli yegang i Matat. Na si Matat yegang i Lebi na yegang i Melki, na bekeꞌ yegang i Jana na yegang i Jose. ");
INSERT INTO plw_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ating si Jose in yegang i Matatias, na yegang i Amos. Itueng si Amos yegang i Nahum naꞌ yegang i Esli, si Esli in yegang i Nage, ");
INSERT INTO plw_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ating si Nage yegang i Maat na yegang i Matatias. Si Matatias in yegang i Semei na yegang i Jose. Si Jose gasi in yegang i Juda. ");
INSERT INTO plw_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ating si Juda yegang i Joana neng yegang i Resa. Si Resa in yegang i Sorobabel neng yegang i Salatiel naꞌ yegang i Neri. ");
INSERT INTO plw_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ating si Neri yegang i Melki neng yegang i Adi naꞌ yegang i Kosam. Si Kosam yegang i Elmodam neng yegang i Er. ");
INSERT INTO plw_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ating si Er yegang i Josue neng yegang i Elieser naꞌ yegang i Jorim. Si Jorim yegang i Matat neng yegang i Lebi. ");
INSERT INTO plw_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Ating si Lebi yegang i Simeon neng yegang i Juda naꞌ yegang i Jose. Si Jose yegang i Jonam neng yegang i Eliakim. ");
INSERT INTO plw_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ating si Eliakim yegang i Melea neng yegang i Mainan naꞌ yegang i Matata. Si Matata yegang i Natan neng yegang i Dabid. ");
INSERT INTO plw_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ating si Dabid yegang i Jesse neng yegang i Obed naꞌ yegang i Boos. Si Boos yegang i Salmon neng yegang i Naason. ");
INSERT INTO plw_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ating si Naason yegang i Aminadab neng yegang i Admin naꞌ yegang i Arni. Si Arni in yegang i Esrom neng yegang i Peres naꞌ yegang i Juda. ");
INSERT INTO plw_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ating si Juda yegang i Jakob neng yegang i Isaak naꞌ yegang i Abraham. Si Abraham yegang i Tera neng yegang i Nahor. ");
INSERT INTO plw_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ating si Nahor yegang i Serug neng yegang i Reu naꞌ yegang i Peleg. Si Peleg in yegang i Eber neng yegang i Sala. ");
INSERT INTO plw_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ating si Sala yegang i Kainan neng yegang i Arpaksad naꞌ yegang i Sem. Si Sem in yegang i Noe neng yegang i Lamek. ");
INSERT INTO plw_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ating si Lamek in yegang i Metusela neng yegang i Enok. Si Enok in yegang i Jared neng yegang i Mahalalel naꞌ yegang i Kainan. ");
INSERT INTO plw_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ating si Kainan in yegang i Enos neng yegang i Set naꞌ yegang i Adan. Si Adan in yegang et Empuꞌ banar. ");
INSERT INTO plw_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Si Jesus pegtetetegan et Empung Menungang Nakem. Indyari neglembus ne si Jesus teyeg dut danumen et Jordan, indyari pinenekmanan et Empung Nakem na ya meglahyun dut kelnangan. ");
INSERT INTO plw_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Pegdateng ye dun, tinuksuꞌ i Seytan si Jesus. Seled epat na pulung eldew si Jesus kaya lang nengaan, angkansa ya inurapan banar. ");
INSERT INTO plw_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Indyari pineinabu net atin i Seytan penuksuꞌ ye dut ki Jesus, kwan ye, “Baꞌ ikew Yegang et Empuꞌ, isugiraꞌ dut batu naꞌ itue e na ipebeluaꞌ et kekanen.” ");
INSERT INTO plw_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Indyari siminambag si Jesus, kwan ye, “Nekesurat dut Kesuratan et Empuꞌ, na, ‘Diki lang megbiyag taaw pasal dut kekanen lang.’ ” ");
INSERT INTO plw_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Indyari pinebayaꞌ gasi i Seytan dut pinekemelangkew naꞌ bukid, pegketbes sengkeperekan lang pinepayag kenye ginsaʼt milikan et sengkedunyaan. ");
INSERT INTO plw_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Indyari negberes gasi si Seytan kenye, kwan ye, “Ibgey ku dimu ginsaʼt penggewman bekeꞌ pegkedeyahan naꞌ itue sabab pinegbayaꞌ ne daken itue, angkansa mekedyari ku mebgey dut sinu-sinu na gaay ku na begeyan. ");
INSERT INTO plw_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Na, baꞌ ikew mengempuꞌ daken, ginsan ibgey ku dimu.” ");
INSERT INTO plw_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Segwaꞌ siminambag si Jesus kenye, kwan ye, “Nekesurat dut beres et Empuꞌ, ‘Pengempuaꞌ Begerar mung Empuꞌ Banar bekeꞌ ya lang sukuan mu.’ ” ");
INSERT INTO plw_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Indyari pinebayaꞌ gasi i Seytan dut lungsud et Jerusalem. Pegdateng duun timinyeg dye dut terimpukpukaʼt Pegpengempuan naꞌ Benwa et Empuꞌ. Indyari sinugiran ye si Jesus, kwan ye, “Baꞌ ikew Yegang et Empuꞌ, tugpa ne. ");
INSERT INTO plw_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Sabab dut Kesuratan et Empuꞌ, ‘Bilinan ye kenyeng dereakan supaya medyeganan ke, ");
INSERT INTO plw_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Beke, sempupuen dye ikew supaya diki ke tegkurihad dut batu.’ ” ");
INSERT INTO plw_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Indyari siminambag si Jesus, kwan ye, “Nesurat, ‘Kasiꞌ pegtuksuaꞌ Begerar mung Empuꞌ in.’ ” ");
INSERT INTO plw_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ganang netbes ne i Seytan ginsan neng penuksuꞌ ye, tinirengan ye ne si Jesus pengsemantaraꞌ segwaꞌ peulinan ye nega baꞌ maya ne menungang timpu gasi. ");
INSERT INTO plw_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Indyari negpeuliꞌ si Jesus dut lungsud et Galilea, asal Empung Menungang Nakem eset kenye. Nehebaran et ginsaʼt taaw naꞌ pelilibut dut lungsud naꞌ atin pasal kenye. ");
INSERT INTO plw_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Sampay negtulduꞌ ya dut mengeꞌ pegtimung-timungan dye, ginsan dye nekebantug kenye. ");
INSERT INTO plw_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Indyari siminurung si Jesus dut lungsud et Nasaret, na baꞌ embe dineklaan ye. Pegdateng et Eldewʼt Kepeternan, diminuntin dut pegtimung-timungan sabab atin ne neeratan ye. Pegdateng dun timinyeg supaya megbatsaꞌ. ");
INSERT INTO plw_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Binggey dut kenye Kesuratan i Isaias neng tarus et Empuꞌ tagnaꞌ. Indyari kinelkad ye ne Kesuratan, nebiyanan ye duntin samat kwantin tugnaꞌ ye, ");
INSERT INTO plw_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Nakem et Empuꞌ dut daken sabab aku piniliꞌ ye supaya menulduꞌ et Menungang Abar dut mengeꞌ miskin. Dinaak ye aku apang ipebunayag dut nepipirisu na dye mepeliwan, ipengmendyari sebarang mengeꞌ beleg kebiriꞌ bekeꞌ merugeyan sebarang mekeliyutan. ");
INSERT INTO plw_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Bekeꞌ ipabar ye ating timpu na bewinen et Empung Begerar kenyeng mengeꞌ taaw.” ");
INSERT INTO plw_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Pegketbes linulun ye ne Kesuratan, indyari pineuliꞌ ye ne dut negey kenye in mura narung supaya menulduꞌ. Indyari ginsaʼt taaw dut seled pegtimung-timungan in nemenengteng dut kenye. ");
INSERT INTO plw_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Indyari tinegnaan ye negsugid dut kedye, kwan ye, “Tiban ating Kesuratan naꞌ nekingeg myu in, netuman ne.” ");
INSERT INTO plw_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Menunga ginsan bebresen dye dut kenye, sampay neliluꞌ sabab et menunungang mengeꞌ bebresen naꞌ liminiwan dut babaꞌ ye. “Diki be itue yegang i Jose?” kwaʼt ingkut dye. ");
INSERT INTO plw_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Siminambag si Jesus dut kedye, kwan ye, “Meraliꞌ samat kwantin ketulduan sugiren myu pasal daken, ‘Mengunguru, uruiꞌ mena bilug mu!’ Sampay sugiren myu gasi, ‘Buwataꞌ mena dut dimung lungsud ginsaʼt nekingeg kay pasal dut mengeꞌ pinemuwat mu dut Kapernaum.’ ");
INSERT INTO plw_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Keberbenaran isugid ku dimyu, kaya lang tarus et Empuꞌ keterima-terima dut kenyeng kebenbenwanan. ");
INSERT INTO plw_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Segwaꞌ sugiran ku kemyuʼt ketentuan, mekansang dut bangsa et Israel naꞌ mengeꞌ kelilibunan naꞌ nebeluan dut penewnan i Elias neng tarus et Empuꞌ tagnaꞌ, sabab et telung teun tengaꞌ kaya lang diminlek, angkansa diminateng kelang urap. ");
INSERT INTO plw_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Temed kaya lang pineruntin et Empuꞌ si Elias dut sinu-sinu selyu ga dut sembatung tumpang naꞌ libun neng nebeluan na tawʼt Sarepat, dut sakup et lungsud et Sidon. ");
INSERT INTO plw_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Mekansang dut bangsa Israel na mengeꞌ tegeldew-eldew dut penewnan i Eliseo neng tarus et Empuꞌ tagnaꞌ, segwaꞌ kaya misan sembatu pinenunga ye selyu si Naaman ga naꞌ tumpang, na sembatung tawʼt Siria.” ");
INSERT INTO plw_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ganang nekingeg itue e et ginsaʼt mengeꞌ taaw dut seled pegtimung-timungan tiꞌ, nemengiseg dye banar. ");
INSERT INTO plw_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Nemeniyeg dye ginsan ampaꞌ dye ne pineliwan, sampay ipegdururung dye dut terimpurukaʼt bukid neng binaal dyeng lungsud supaya ipulid dye ya dut pengras. ");
INSERT INTO plw_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Segwaꞌ nayaꞌ lang dut pinegketngaan dye na kaya nepenu-penu, indyari nugad ne si Jesus. ");
INSERT INTO plw_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Pegketbes timinugpa ne de Jesus dut Kapernaum, na sembatung sakup et lungsud et Galilea, na dut Eldew et Kepeternan timinagnaꞌ pegtulduꞌ i Jesus dut mengeꞌ taaw dut pegtimung-timungan. ");
INSERT INTO plw_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Neliluꞌ dye banar dut kenyeng mengeꞌ tulduꞌ, sabab maya keseg kenyeng mengeꞌ bebresen. ");
INSERT INTO plw_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Dut pegtimung-timungan maya sembatung lelaki neng negbegbalig. Negberes ya et mebasag dut ki Jesus, kwan ye, ");
INSERT INTO plw_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Enu panew mu damen Jesus et Nasaret? Natuꞌ ke be supaya binesanen mu kami? Sewd kay baꞌ sinu ke. Ikew ating Pasek Metignaꞌ teyeg et Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","“Kas kegibek!” kwan i Jesus, “Lumiwan kew dut kenye.” Indyari inugbaꞌ et tawʼt kekelyan ating lelaki in ampaꞌ ne liminiwan ating meraat, na kaya ne nekepesakit kenye. ");
INSERT INTO plw_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Indyari ginsaʼt mengeꞌ taaw neliluꞌ sampay nemegbesberes ne, kwan dye, “Enu itueng tulduꞌ e? Sabab maya keksegan bekeꞌ maya kebesagan. Inempangan ye lang meraat neng nakem nemengliwan ne.” ");
INSERT INTO plw_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Na, pagkaꞌ kwantin ne abar pasal kenye limingkep dut ginsaʼt pelilibut. ");
INSERT INTO plw_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Indyari nugad ne si Jesus dut pegtimung-timungan, ampaꞌ ne diminuntin dut benwa de Simon. Neginabu duntin, libun neng pengibanan i Simon in pegegnewen. Neneew de Simon pekitabang dut ki Jesus. ");
INSERT INTO plw_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Angkansa diminigwang si Jesus dut kenye, ampaꞌ ye ne dinaak ating egnew mugad. Indyari inibuanan ne megtuy ne nemeruri sampay negpekaan ne dut kedye. ");
INSERT INTO plw_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ganang megsesdep ne eldew, nememibit mengeꞌ taaw et indeginis neng mengeꞌ reresanen et mengeꞌ mesesakit. Segwaꞌ ganang pegdepnen ye lang et keremut ye ginsan sembatu-sembatu kedye angkansa pemegnunga dye ne. ");
INSERT INTO plw_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Nemengliwan dut kineldaman mengeꞌ mereraat bekeꞌ megegerwak dye. Kwan et mengeꞌ meraat naꞌ nakem, “Ikew naꞌ Yegang et Empuꞌ!” Segwaꞌ pinemulag i Jesus dye, sampay kaya tinugutan ye dye na meres pasal dut kenye sabab pegsesewren dye na Ya ne in ating Kristo. ");
INSERT INTO plw_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Pegdateng et keririkleman, siminurung si Jesus dut kelnangan. Naꞌ, mengeꞌ taaw memegtulus ne kenye. Ganang nebiyanan dye ne si Jesus, binisara dye ya na endey mena tumireng kedye. ");
INSERT INTO plw_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Segwaꞌ kwan ye, “Keilangan ipabar ku gasi Menungang Abar dut leing kebenbenwanan pasal milikan et Empuꞌ, sabab pasal et atin angkan aku dinaak.” ");
INSERT INTO plw_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Indyari negpeabar ne si Jesus dut mengeꞌ pegtimung-timungan et mengeꞌ tawʼt Judio na dut bangsa et Judea. ");
INSERT INTO plw_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Sembatung eldew, petitiyeg si Jesus dut tindal et dagat et Genesaret, na dut pelilibut ye negsigkit kansang et mengeꞌ taaw sabab memegkikingeg pasal beres et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Indyari nebiriꞌ i Jesus duwang gubang pesesengrad dut deplakaʼt dagat segwaꞌ kaya sentin mengeꞌ empuʼt gubang in sabab pemenggunas et rambat dye. ");
INSERT INTO plw_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Indyari nekepikir si Jesus sumakat dut sembatung gubang in. Ating gubang Empuꞌ ye si Simon. Indyari narung ne si Jesus dut gubang, pegketbes kwan i Jesus dut kenye, “Isundur-sunduraꞌ sengkerit pelawed.” Sasat megearung dut gubang in, sasat gasi pegtutulduan ye ginsaʼt kineldaman in. ");
INSERT INTO plw_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Indyari ganang neketbes net pegtulduꞌ ye, kwan ye dut ki Simon, “Pelawed-leweraꞌ myu gubang in, pegketbes itanaꞌ myu ne ating mengeꞌ rambat in supaya keisiꞌ kew seraꞌ.” ");
INSERT INTO plw_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Segwaꞌ siminambag si Simon, kwan ye, “Menulduꞌ, negsinggebi ne tuyuꞌ kay, segwaꞌ misan sisiꞌ kaya lang nekeisiꞌ kay. Segwaꞌ pagkaꞌ ikew ne pegsugid, itaan kay ne mengeꞌ rambat tuꞌ.” ");
INSERT INTO plw_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Na, pagkaꞌ nebuwat dye ne itue e, nemekeisiꞌ ne et mekansang naꞌ seraꞌ seked-seked kuuyat ne rambat dye. ");
INSERT INTO plw_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Pagkaꞌ kwantin ne, pinengempayan dye ne kedyeng mengeꞌ iba-iba na dut sembatung gubang tiꞌ na pekabiꞌ dut kedye supaya menabang. Indyari nememunsul ne ampaꞌ dye ne pinenunuan duwang gubang. Naꞌ, usa-usa mengeꞌ gubang dye kuelneb ne. ");
INSERT INTO plw_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Pagkaꞌ samat kwantin ne nebiriꞌ i Simon, tahan lang nepekleb dut titikeran i Jesus, indyari kwan ye, “Pereyuniꞌ ku Empuꞌ, sabab aku tuꞌ sembatung tegesalaꞌ.” ");
INSERT INTO plw_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Indyari si Simon bekeꞌ mengeꞌ iba ye nemekeliluꞌ sabab dut deklaʼt seraꞌ neng neisiꞌ dye. ");
INSERT INTO plw_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Megdemikian nemekeliluꞌ si Jakob bekeꞌ si Juan neng keyegangan i Sebedeo, naꞌ mengeꞌ kebeꞌbayaꞌ i Simon. Indyari kwan i Jesus dut ki Simon, “Kas takut, sabab tihad tiban mengrerambat ke ne et mengeꞌ taaw.” ");
INSERT INTO plw_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Indyari pinerungguꞌ dye ne kedyeng gubang, indyari tinirengan dye ne ginsan, ampaꞌ dye ne nayaꞌ dut kenye. ");
INSERT INTO plw_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ganang dun ne si Jesus dut sembatung lungsud, maya dun sembatung tegeldew-eldew. Pegkebiriꞌ ye ki Jesus megtuy lang nepekleb dut lugtaꞌ, supaya mengangat et peingasiꞌ, kwan ye, “Begerar baꞌ gayen mu teyen, peguliniꞌ ku.” ");
INSERT INTO plw_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Indyari kintang i Jesus ne kenyeng lengen, ampaꞌ ye ne kimpetan, kwan ye, “Ingin ku, megnunga ke.” Kenematey, atin lang be nebres i Jesus, megtuy ne negulinan. ");
INSERT INTO plw_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Indyari amay-amay negbilin si Jesus dut kenye kwan ye, “Na asiꞌasiꞌ kasiꞌ pegsugiraꞌ dut misan sinu. Segwaꞌ panew ne, ipebirinaꞌ bilug mu dut pariꞌ, pegketbes megungsud ke et simayaꞌ. Sabab atin ne saraꞌ i Moises baꞌ pesalan samat dimu neng reresanen tuꞌ, bekeꞌ atin tendaꞌ dut mengeꞌ taaw na ikew kebenaran menunga ne.” ");
INSERT INTO plw_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Segwaꞌ pasal ki Jesus nebuar nega dut kineldaman, angkan mengeꞌ taaw memegsurung dut kenye supaya kumingeg bekeꞌ megpeuru et kedyeng mengeꞌ reresanen. ");
INSERT INTO plw_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Segwaꞌ daran megsurung si Jesus dut kaya lang ketaaw-taaw supaya megpenalang sesayu dut Empuꞌ Banar. ");
INSERT INTO plw_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Sembatung eldew ganang pegtulduꞌ ne si Jesus, neginabu mengeꞌ pariꞌ naꞌ Pariseo bekeꞌ mengeꞌ menunulduꞌ et Keseraan i Moises memegarung duntin. Teyeg dye dut iba-ibang mengeꞌ lungsud et Galilea, dut Judea, bekeꞌ dut Jerusalem. Segwaꞌ esen net ki Jesus keksegan et Empuꞌ Banar supaya menguru. ");
INSERT INTO plw_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Indyari, maya mengeꞌ kelelekian memegkekentuang et sembatung rumuy bilug ye na pebubuntul dut demdam ye, ipeglegesan dye na biten dye ya dun supaya meratun dye dut elepan i Jesus. ");
INSERT INTO plw_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pagkaꞌ kaya lang mebiyanan dye sabab et nemegsitsiet ne mengeꞌ taaw. Indyari sembatu inluꞌ dye ninik dye dut timbewʼt sapew, ampaꞌ dye ne linsutan. Pegketbes linsutan dye indyari tinuntun dye ne dut pinegketngaaʼt mengeꞌ taaw nega tiꞌ, neginalep dut teteyumanan i Jesus neretunan ye. ");
INSERT INTO plw_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Pagkaꞌ neerim i Jesus pegandel dye, kwan ye, “Bilaꞌ, mengeꞌ salaꞌ mu inampun ne.” ");
INSERT INTO plw_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Indyari mengeꞌ Pariseo bekeꞌ mengeꞌ menunulduꞌ et Keseraan nemegpikir-pikir et samat kwantin, “Sinu takung taaw itue e na pegberes et kebusungan e? Diki be Empuꞌ lang mekeampun et mengeꞌ keselaan?” ");
INSERT INTO plw_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Segwaꞌ pegsesewren i Jesus sebarang pegpipikiren dye, indyari kwan ye, “Manu pegpikir-pikir kew et samat kwantin? ");
INSERT INTO plw_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Enu merugey sugiren, ‘Inampun ne dimung salaꞌ,’ etawa, ‘Teyeg ampaꞌ panew ne?’ ");
INSERT INTO plw_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Angkansa, menunga mesewran myu banar na aku, itueng Yegang et Taaw, maya kewasa bekeꞌ kepegbayaan et Empuꞌ atuʼt dunyaꞌ supaya mengampun et keselaan.” Indyari kwan ye dut rumuy naꞌ taaw in, “Pegbangun ne, bitaꞌ ne demdam mu ampaꞌ ke ne muliꞌ.” ");
INSERT INTO plw_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Indyari megtuy ne timinyeg dut elepaʼt ginsaʼt mengeꞌ taaw, pinemibit ye ginsaʼt pegbubuntulan ye ampaꞌ ne nuliꞌ, na megbebantug dut Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Indyari, pagkaꞌ kwantin ne neinabu, ginsan dye na dut seled et ating benwa nemegliluꞌ, sampay dye ne gasi nekebantug dut Empuꞌ, kwan dye, “Tiban nekebiriꞌ tyu et keliluꞌlilung buwat.” ");
INSERT INTO plw_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Pegketbes et itue e, liminiwan si Jesus ampaꞌ ne nugad. Indyari nebiriꞌ ye si Lebi na sembatung menunukut et buwis na megarung dut benwa neng pegsutsukutan. “Bayaꞌ daken,” kwan i Jesus dut kenye. ");
INSERT INTO plw_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Indyari timinyeg si Lebi, ampaꞌ ne nayaꞌ dut kenye. Ginsan tinirengan ye. ");
INSERT INTO plw_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Pegketbes negpepanyap si Lebi et kelang pegkenkaan sabab lang dut ki Jesus. Duntin neginabu gasi maya mengeꞌ menunukut et lugtaꞌ bekeꞌ maya mengeꞌ simpir nekilamud mengaan. ");
INSERT INTO plw_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Indyari nemenawey mengeꞌ pariꞌ naꞌ Pariseo bekeꞌ mengeꞌ menunulduꞌ et Keseraan i Moises na teyeg et egama dye dut mengeꞌ pepengenaran i Jesus, kwan dye, “Manu megsesaru kew mengaan dut mengeꞌ mekeselaan bekeꞌ mengeꞌ menunukut et buwis in?” ");
INSERT INTO plw_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Indyari siminambag si Jesus, kwan ye, “Diki mengeilangan et mengunguru sembatung menunga peresaan ye, selyu lang sebarang tegesakit lang in. ");
INSERT INTO plw_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Diki ku natuꞌ supaya peningkagen sebarang metitignaꞌ in, baꞌ diki sebarang mengeꞌ mekeselaan in supaya memegsusun.” ");
INSERT INTO plw_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Sinugid dye dut kenye, kwan dye, “Mengeꞌ pepengenaran i Juan daran megpuasa bekeꞌ meningkag, megdemikian mengeꞌ ketindegan et mengeꞌ Pariseo, segwaꞌ mengeꞌ pepengenaran mu daran dye mengaan sampay menginum.” ");
INSERT INTO plw_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Indyari siminambag si Jesus, kwan ye, “Manu, megpuasa be takuꞌ sebarang mengeꞌ terisabeng in sementaraꞌ iba dye nega lelaki neng ibulun in? ");
INSERT INTO plw_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Segwaꞌ maya timpu, baꞌ lelaki naꞌ ibulun in kaya ne, ‘Atin peꞌ megpuasa dye ne.’ ” ");
INSERT INTO plw_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Indyari si Jesus negberes et elagad mengeꞌ pinegleinan et mengeꞌ tulduꞌ et mengeꞌ Pariseo, bekeꞌ eset kenyeng bagung tulduꞌ, kwan ye, “Kaya lang taaw menabas et bagung kumut supaya lang itempel dut lelagi neng kumut. Na baꞌ binwat ye atin, meusibaꞌ ne ating bagung kumut, bekeꞌ ating tinabas naꞌ tetempel dut bagu naꞌ kumut in, diki lang sumugat na itempel dut lelagi neng kumut. ");
INSERT INTO plw_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","“Bekeꞌ kaya sinu menunuꞌ et bagung alak et ubas dut lelagi neng susunuan naꞌ kulit. Na baꞌ binwat ye, ipelput et bagung alak et ubas susunuan in sabab et galak et labun ye. Indyari meulaꞌ ne alak et ubas in sampay susunuan naꞌ kulit in meusibaꞌ ne. ");
INSERT INTO plw_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Segwaꞌ sebarang bagung alak et ubas in subaliꞌ isunuꞌ dut bagung susunuan gasi. ");
INSERT INTO plw_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Bekeꞌ kaya sinu, baꞌ nekeinum net alak neng ubas in meiregan ye nega bagung alak in, segwaꞌ atuʼt megurang in, atin key sugiren ye na ‘Menunga.’ ” ");
INSERT INTO plw_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sembatung Eldew et Kepeternan, ganang memegtetalib de Jesus dut uma, nememuringguꞌ mengeꞌ pepengenaran ye et seng uheyen. Pinengurut dye bekeꞌ kinukut dye sebarang mengeꞌ elinseg lang in dut pegpanew dye. ");
INSERT INTO plw_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Indyari nemengingkut mengeꞌ pariꞌ naꞌ Pariseo dut kedye, kwan dye, Naꞌ “Manu pememuringguꞌ kew tiban? Sungsang atin dut Eldew et Kepeternan.” ");
INSERT INTO plw_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Siminambag si Jesus dut kedye kwan ye, “Diki myu be takuꞌ nebatsaꞌ pegdatek pinengurapan de Surutan Dabid tagnaꞌ bekeꞌ mengeꞌ iba ye, baꞌ enu binwat dye? ");
INSERT INTO plw_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Diki takuꞌ siminled si Surutan Dabid dut Pegpengempuan naꞌ Benwa in, bekeꞌ diki be nemengaan dye et sinimayaꞌ neng bengbang in, sampay mengeꞌ iba i Dabid pinemgeyan ye nega? Atin teup, mengeꞌ pariꞌ lang mekedyari kekaan.” ");
INSERT INTO plw_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Indyari kwan i Jesus dut kedye, “Aku, ating Yegang et Taaw naꞌ Gerar na lebing metaas dut Eldew et Kepeternan.” ");
INSERT INTO plw_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Pegdatek sembatung Eldew et Kepeternan siminurung si Jesus dut pengempuan naꞌ benwa et mengeꞌ tawʼt Judio apang menulduꞌ. Indyari untin maya sembatung piley kewanan neng lengen ye. ");
INSERT INTO plw_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Mengeꞌ pariꞌ naꞌ Pariseo bekeꞌ mengeꞌ menunulduꞌ et Keseraan megsisipyiꞌ lagi ki Jesus, angkan supaya maya mesumbung dye pasal kenye. Angkansa ating eldew sinipian dye banar baꞌ menguru si Jesus dut ating Eldew et Kepeternan. ");
INSERT INTO plw_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Segwaꞌ pegsesewren ne i Jesus baꞌ enu pegpipikiren dye, indyari kwan ye dut maya piley lengen in, “Teyeg pegketbes peteyuma ke dut elepan et ginsaʼt mengeꞌ taaw.” Indyari timinyeg ne selus. ");
INSERT INTO plw_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Indyari sinugid i Jesus dut kedye, kwan ye, “Tiban ingkuten ku kemyu, enu patut buwaten dut Eldew et Kepeternan, memuwat et menunga etawa memuwat et meraat, memawiꞌ et biyag etawa mengusibaꞌ?” ");
INSERT INTO plw_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Indyari sinyekan i Jesus ginsan eset pelilibut ye in, pegketbes sinugid ye dut lelaki, kwan ye, “Iktangaꞌ lengen mu.” Indyari kintang i Jesus ne lengen ye. Na, pegketang ye megtuy ne negulinan. ");
INSERT INTO plw_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Segwaꞌ susulu ga nemengiseg mengeꞌ pariꞌ naꞌ Pariseo bekeꞌ mengeꞌ menunulduꞌ et Keseraan, indyari nemegisun-isun dye baꞌ enu buwaten dye ki Jesus. ");
INSERT INTO plw_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Sembatung eldew timinungul si Jesus dut bukid. Negsinggebi negpenelang ye dut Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Pegdatek keririkleman tiningkag ye kenyeng mengeꞌ pepengenaran, pegketbes nemiliꞌ ya et sempuluꞌ duwa supaya ngeranen ye et bibilinan dut kenye. ");
INSERT INTO plw_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Indyari ating mengeꞌ pinemiliꞌ ye, ingaran dye, si Simon, ngineranan ye et Pedro, si Andres neng tipused i Simon, de Jakob, Juan, Pelipe, Bartolome, ");
INSERT INTO plw_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomas, bekeꞌ si Jakob naꞌ yegang i Alpeo, si Simon na pegtingkagan ye et Meketaaw, ");
INSERT INTO plw_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","si Judas naꞌ yegang i Jakob, sampay si Judas Iskariote naꞌ negdungdupang gasi. ");
INSERT INTO plw_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Pegketbes nepekenapan si Jesus bekeꞌ mengeꞌ pepengenaran neng mengengandel ye, indyari nepetaren dye dut kebelnekan. Simpir neng mengeꞌ pepengenaran ye esentin gasi, bekeꞌ kineldaman gasi mengeꞌ tawʼt Judea, tawʼt Jerusalem, sampay mengeꞌ tawʼt dagat et bayan et Tiro bekeꞌ Sidon. ");
INSERT INTO plw_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Na dye in nemenurung ki Jesus supaya kumingeg bekeꞌ petabang et kedyeng mengeꞌ reresanen, samat nemegbegbalig in neng nemegnunga. ");
INSERT INTO plw_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ginsaʼt mengeꞌ taaw pemengutew dut ki Jesus, sabab maya basag megliwan teyeg dut kenye, angkan ginsan dye pemegulinan. ");
INSERT INTO plw_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Indyari siminyek si Jesus dut kenyeng mengeꞌ pepengenaran, kwan ye, “Mesukud kew na mengeꞌ miskin sabab dimyu ating Pengmilikan et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Mesukud kew sebarang pemegurapan tiban atuʼt dunyaꞌ sabab kemyu pebiyagan baꞌ leyd ne. “Mesukud kew memegsiyak tiban sabab kemyu tumelengkak leyd tiꞌ. ");
INSERT INTO plw_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Mesukud kew baꞌ kemyu pegreaten et sebayaꞌ myu, pepeugad, peginlelewen bekeꞌ pegbenbersan kew et meyeyaat sabab lang et pegandel myu dut Yegang et Taaw. ");
INSERT INTO plw_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Sabab samat kwit tiꞌ pineliyutan gasi et mengeꞌ kegunggurangan dye mengeꞌ tarus et Empuꞌ tagnaꞌ. Angkansa meglami-lami kew dut eldew naꞌ atin bekeꞌ megtiktindak kew et kesan, sabab kelaꞌ isubli dimyu dut langit. ");
INSERT INTO plw_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Segwaꞌ elulaꞌ myu ne mengeꞌ mentiriꞌ sabab neterima myu ne lagi kesenangan myu. ");
INSERT INTO plw_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Elulaꞌ myu ne sebarang pemegbiyagan tiban, sabab megderateng eldew na kemyu urapan leyd tiꞌ. Elulaꞌ myu ne mengeꞌ memegtelengkak tiban, sabab kemyu rumupuk bekeꞌ sumiyak leyd tiꞌ. ");
INSERT INTO plw_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Elulaꞌ myu ne baꞌ ginsaʼt taaw pemantug dimyu, sabab rendemaꞌ myu kwantin gasi pegbuwaten et mengeꞌ keupuꞌupuan et kedye neng pemantug dimyu dut mengeꞌ embut na mengeꞌ tarus.” ");
INSERT INTO plw_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Temed sugiran ku kemyu mengeꞌ megkikingeg; Inginaꞌ myu dimyung mengeꞌ kebanta, buwatiꞌ myu et menunga sebarang memegiseg dimyu. ");
INSERT INTO plw_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Inunganaꞌ myu sebarang pemenuknaꞌ dimyu, bekeꞌ ipenelangin myu dut Empuꞌ sebarang pemengraat dimyu. ");
INSERT INTO plw_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Baꞌ maya menuntuk et sembelang rupa myu, ipetemparaꞌ gasi kenye sembelaꞌ in. Na baꞌ maya mengagew et repanan mu, pesariꞌ lang misan sampay badyuꞌ mu isien ye. ");
INSERT INTO plw_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Begeyiꞌ myu sebarang memegteew dut dimyu, na baꞌ maya mengagew et mengeꞌ pusakaꞌ myu kasiꞌ myu ne pegisiaꞌ peuliꞌ. ");
INSERT INTO plw_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Buwataꞌ myu dut sebayaꞌ myu sebarang gaay myu buwaten et sebayaꞌ myu dut dimyu. ");
INSERT INTO plw_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Segwaꞌ baꞌ kesien mu lang sebarang memegkasi lang dut dimyu, enung ganti tegeyen mu? Misan mengeꞌ mekeselaan pegkesian dye sebarang memegkasi lang gasi dut kedye in. ");
INSERT INTO plw_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Bekeꞌ baꞌ atin lang buwatan mu et menunga sebarang menunga lang gasi dut dimu, enung pulus na metagey mu? Misan mengeꞌ mekeselaan kwantin gasi pegbuwaten dye. ");
INSERT INTO plw_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Megdemikian gasi baꞌ ipelimbas myu lang sebarang pegsesewren myu na kebayad dut dimu, enung pulus na metagey mu sentin? Misan gang mengeꞌ mekeselaan pepelimbasan dye sebayaꞌ dye, sabab pegsesewren dye na maya mebayad kedye. ");
INSERT INTO plw_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Segwaꞌ inginaꞌ myu sebarang mengeꞌ kebanta myu. Buwatiꞌ myu dye et menunga bekeꞌ pelimbasiꞌ myu dye misan ne pegsesewren myu na kaya lang mebayad dye dimyu. Sabab kelaꞌ pulus myu, bekeꞌ diki lang et atin, sampay gasi teupen na kemyu tantu banar na mengeꞌ yegang et Metaas Banar naꞌ Empuꞌ. Sabab Empuꞌ meingesinen dut mengeꞌ taaw neng kaya medengdeng bekeꞌ dut mengeꞌ mekeselaan. ");
INSERT INTO plw_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Keilangan meingesinen kew, samat dimyung Amaꞌ (Empuꞌ) neng meiningesien.” ");
INSERT INTO plw_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Kas kewʼt pengukum et sebayaꞌ myu, supaya diki kew gasi meukuman et Empuꞌ. Kas kewʼt pengdusa, supaya diki kew gasi dusaen. Empunaꞌ myu sebayaꞌ myu supaya empunen kew gasi et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Megey kew bekeꞌ supaya kemyu gasi mebgeyan. Menungang penggantang, pereten, yegyegen sampay tumudtud ne dut gegentangan seked mepursan ne dut elepan myu. Sabab penggantang neng ginantang myu kwantin gasi penggantang igantang dimyu et Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Indyari negtuturan et itueng beleybey, kwan ye, “Mekedyari takuꞌ na sembatung beleg mengdundun et sembatung beleg gasi? Diki be ginsan dye in mererabuꞌ dut kinelian? ");
INSERT INTO plw_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Sembatung pegiskul diki lang lumbi dut kenyeng menunulduꞌ, segwaꞌ sebarang tinulduan banar sumaliꞌsaliꞌ ne gasi dut kenyeng menunulduꞌ.” ");
INSERT INTO plw_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Manu pegsiyekan mu puling dut mataʼt tipused mu? Segwaꞌ kaya mekebiriꞌ mu batang neng nekepuling dut mata mu? ");
INSERT INTO plw_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Enukwan tiban mesugid mu dut tipused mu, kwanen mu, ‘Tipused, ugaren ku puling dut mata mu,’ segwaꞌ dimu kayangga neugad mu batang neng nekepuling dut mata mu? Ikew naꞌ peleꞌlaluꞌ, ugaraꞌ mena puling dut mata mu supaya menunga penyek mu mengugad et puling dut mataʼt tipused mu.” ");
INSERT INTO plw_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Kaya menungang kayu indyari muaꞌ et diki menungang buaꞌ, etawa meyaat neng kayu indyari muaꞌ et menunga. ");
INSERT INTO plw_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Sabab mengeꞌ kayu mekekilala dut kedyeng mengeꞌ buaꞌ. Angkan kityu diki tyu memuaꞌ et buaꞌ dut mengeꞌ kesuksukan, etawa dut mengeꞌ keserenitan. ");
INSERT INTO plw_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Angkansa mengeꞌ menunungang taaw buwat dye menununga gasi, sabab menunga pusuꞌ dye, segwaꞌ sebarang mengeꞌ mereraat neng mengeꞌ taaw mereraat gasi keradya dye, sabab pusuꞌ dye meraat. Sabab sebarang ibres et babaꞌ dye atin dut pusuꞌ dye nega pegmewanan.” ");
INSERT INTO plw_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Manu pegbetangan myu aku et Begerar, segwaꞌ kaya pegbuwaten myu sebarang mengeꞌ pinegberes ku in? ");
INSERT INTO plw_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Na, pegsusugiren ku dimyu baꞌ enu patus et sebarang memegsurung daken in supaya mengingeg et beres ku, pegketbes buwaten ye atin. ");
INSERT INTO plw_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Patus ye samat negpetiyeg et benwa, negkali et merarem dut batu pegketbes pinetiyeg ye dun usuk ye. Pegdatek liyud, linyuran benwa ye et mebasag, segwaꞌ kaya riminyeg sabab mepangger pengusuk ye. ");
INSERT INTO plw_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Segwaꞌ ating sembatu neng megkingeg et beres ku segwaꞌ kaya pegbuwaten ye, patus ye samat lelaki naꞌ negbenwa segwaꞌ inusukan ye dut egis-egisen, na senu ga pangger ye. Pegdatek linyuran benwa ye, neglahyun lang negbaꞌ seked-seked ginsan in nerumbak.” ");
INSERT INTO plw_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ganang netbes i Jesus ne ginsaʼt tuturan ye neng pemegkikinggen et mengeꞌ taaw in, neglahyun ne si Jesus dut lungsud et Kapernaum. ");
INSERT INTO plw_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Indyari negtekaꞌ duntin sembatung uripen et kapitaʼt sundalu et Roma pegkesian ye banar itueng uripen na pegsesekitan na peglelpusen ne. ");
INSERT INTO plw_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ganang neebaran et kapitaʼt sundalu pasal ki Jesus, dinaak ye mengeꞌ megurang et mengeꞌ tawʼt Judio supaya megsugid ki Jesus ipesurung apang menabang dut kenyeng uripen. ");
INSERT INTO plw_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ganang diminateng dye ne dut ki Jesus, negpeingasiꞌ dye banar, kwan dye, “Ating taaw patut gasi kineradya ye. Angkansa misan tebangan mu ya. ");
INSERT INTO plw_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Sabab melingew si Kapitan dut kityung bangsa, bekeꞌ ya nega gasi negpebaal et benwa naꞌ pegempuan.” ");
INSERT INTO plw_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Angkansa si Jesus nayaꞌ ne lang. Pagkaꞌ mekabiꞌ dye ne dut benwa, pinesusup i Kapitan ne si Jesus dut pireng mengeꞌ bilaꞌ ye supaya megsugid. Na samat kwantin pemilin ye, “Gerar, kas net peluug, sabab diki teupen na kesirung kew dut sapew ku. ");
INSERT INTO plw_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Angkan kaya aku nepekabiꞌ dimu sabab nerim ku na diki aku teupen na tumeyuma dimu. Segwaꞌ mengarap ku ne misan bebresen mu lang ipebibit mu uripen ku megulinan ne. ");
INSERT INTO plw_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Sabab aku itue maya metaas dut daken, megdemikian aku maya gasi pegsesekupan ku na mengeꞌ kesundeluan. Baꞌ daaken ku sembatu ‘Manew ke!’ ya mepanew. Dut iba gasi kwanen ku, ‘Aniꞌ ke!’ ya pepekabiꞌ. Baꞌ sugiran ku daken neng uripen, ‘Buwataꞌ itue!’ atin gasi pegbuwaten ye.” ");
INSERT INTO plw_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ganang nekingeg itue i Jesus, neliluꞌ ya banar. Indyari liminingew ya dut kineldaman neng megseselundung kenye, kwan ye, “Misan mengeꞌ tawʼt Israel kayangga peꞌ nekebiriꞌ ku samat kwantin deklaʼt pegandel.” ");
INSERT INTO plw_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Indyari mengeꞌ kelelekian neng mengeꞌ tinahag in negpeuliꞌ ne dut benwa, segwaꞌ pegdateng dye duntin uripen in negulinan ne. ");
INSERT INTO plw_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Pegketbes et itue, siminurung si Jesus dut lungsud na pegngeranen et Nain. Indyari mengeꞌ pepengenaran ye bekeꞌ mengeꞌ kineldaman nememayaꞌ ne kenye. ");
INSERT INTO plw_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ganang mekabiꞌ ne dut lelengewan et lungsud naꞌ atin, maya sembatung patey pegpepsanen set rarung surung peliwan dut lelelbengan. Na atin bugtung naꞌ lelaki yegang et nebeluan. Mekansang mengeꞌ taaw teyeg dut lungsud naꞌ atin nengiba kenye. ");
INSERT INTO plw_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Pegkebiriꞌ i Jesus dut induꞌ et natey in, nekeingasiꞌ dut kenye, kwan ye, “Kas net siyak.” ");
INSERT INTO plw_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Pegketbes pinekebian ye rarung in, ampaꞌ ye ne kinutew, indyari nepetaren ne mengeꞌ megpepsan et rarung in. “Subur, pegbangun ne!” kwan i Jesus. ");
INSERT INTO plw_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Indyari negbiyag peuliꞌ ating natey bekeꞌ narung ne ya, pegketbes mekebres ne. Indyari dinundun ne i Jesus dut induꞌ ye. ");
INSERT INTO plw_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Pagkaꞌ samat kwantin ne, ginsan dye nemenakut ne bekeꞌ nemegbantug ne dut Empuꞌ, kwan dye, “Maya tiban atuʼt pinegketngaan tyu na metaas naꞌ tarus, natuꞌ Empuꞌ supaya menabang kityu et mengeꞌ taaw ye.” ");
INSERT INTO plw_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Itueng abar pasal ki Jesus nebuar dut ginsaʼt Judea sampay dut pelilibut naꞌ mengeꞌ lungsud. ");
INSERT INTO plw_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Negtuturan mengeꞌ pepengenaran i Juan neng Mememewtismu dut kenye pasal neng mengeꞌ neinabu et ating masa. ");
INSERT INTO plw_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Indyari duwa dye pinetingkag i Juan supaya daaken ye sumurung ki Jesus apang mengingkut na, kwanen dye, “Ikew ne be na ating tineked na megderateng, etawa tumagey kay nega dut iba.” ");
INSERT INTO plw_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ganang nemengdateng ne mengeꞌ kelelekian dut ki Jesus, kwan dye, “Si Juan neng Mememewtismu negdaak damen atuʼt dimu supaya mengingkut dimu na baꞌ ikew ne be itueng pegtetegeyen kay na dumateng, etawa subaliꞌ tumagey et iba?” ");
INSERT INTO plw_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Nekeuna tiꞌ mekansang neng mengeꞌ reresanen pinegulinan i Jesus, mengeꞌ indeginis neng mengeꞌ reresanen bekeꞌ mengeꞌ pepeliyutan et mengeꞌ mereraat neng diwata, sampay mengeꞌ beleg nemekebiriꞌ. ");
INSERT INTO plw_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Angkansa sinugid i Jesus dut mengeꞌ pinengdaak in, kwan ye, “Na, peuliꞌ kew ne, isugiraꞌ myu ki Juan sebarang nebiriꞌ bekeꞌ nekingeg myu ‘Mengeꞌ beleg nemekebiriꞌ, mengeꞌ pangkul nemekepanew, sebarang tegeldew-eldew nemegulinan, mengeꞌ lepak nemekekingeg, mengeꞌ patey nemegbiyag peuliꞌ, bekeꞌ Menungang Abar pineabar dut mengeꞌ miskin.’ ");
INSERT INTO plw_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Mesukud sebarang mengeꞌ taaw na diki duwa-duwa daken.” ");
INSERT INTO plw_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ganang nemengugad ne mengeꞌ dinaak i Juan in, negberes si Jesus, kwan ye dut kineldaman pasal ki Juan, “Enu pegliwanen myu supaya birinen dut kelnangan? Sembatung rebung pegyegyegen et deres? ");
INSERT INTO plw_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Na baꞌ lein lang, enu pegliwanen myu supaya birinen? Sembatung taaw na menungang pekayan? Dein lang, sabab mergaꞌ neng mengeꞌ pinekayan bekeꞌ mesanang pengebiyagan ye, dye in dut benwa lang et mengeꞌ mentiriꞌ. ");
INSERT INTO plw_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Segwaꞌ enu pegliwanen myu supaya birinen? Sembatung tarus et Empuꞌ? Negsugat banar, sabab sugiran ku kemyu, luwas nega dut tarus et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Netuman ne Kesuratan pasal kenye na pegsugiren; ‘Daaken ku daken neng tetehagen muna dut dimu, na ya memanyap et bebyaan dut unaan mu.’ ");
INSERT INTO plw_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“Sugiran ku kemyu, dut ginsan neng mengeꞌ pinegyegang et mengeꞌ kelilibunan, kaya-kaya lang lumbi dut ki Juan. Segwaꞌ sebarang isek-isek dut pengmilikan et Empuꞌ lumbi nega dut kenye.” ");
INSERT INTO plw_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Pagkaꞌ nekingeg ne et ginsaʼt mengeꞌ taaw sampay mengeꞌ menunukut et mengeꞌ buwis in bebresen i Jesus, sabab dye in nebewtismuan gasi i Juan, nesulutan dye banar na metignaꞌ arat et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Segwaꞌ mengeꞌ pariꞌ naꞌ Pariseo bekeꞌ mengeꞌ menunulduꞌ et Keseraan i Moises sabab minendian dye gaay et Empuꞌ pasal kedye. Diki dye nepebewtismu dut ki Juan. ");
INSERT INTO plw_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Indyari, pelembus si Jesus et beres ye, kwan ye, “Enu pesiringan ku itueng mengeꞌ pengkataʼt mengeꞌ taaw naꞌ itue? Enu saliꞌ dye? ");
INSERT INTO plw_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Sama dye lang et mengeꞌ keyengyegangan na memegarung dut pegelnen-elnen na pemeningkag-ningkag dut kesebeyaan dye, ‘Binesalan kay ne kemyu, segwaꞌ kaya lang timinarek kew. Pegnguy-nguyan kay ne damen et siyak, segwaꞌ dimyu memegkesit kew ga.’ ");
INSERT INTO plw_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“Sabab natuꞌ si Juan neng mememewtismu, na ya megpupuasa sampay kaya ne nenginum et kelelangu, segwaꞌ pegtendesen myu ga ya et ‘Pegselban et mereraat.’ ");
INSERT INTO plw_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Indyari natuꞌ gasi aku neng Yegang et Taaw, pengaan bekeꞌ penginum, segwaꞌ pegbersen, ‘Atuꞌ ne si Mereren bekeꞌ si Meininumen, biꞌbilaꞌ et mengeꞌ menunukut et buwis bekeꞌ mengeꞌ mekeselaan!’ ");
INSERT INTO plw_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Segwaꞌ kesesewran et Empuꞌ mekebiriꞌ dut mengeꞌ menungang kebiyagan et kenyeng mengengandel pinesebenaran et kenyeng mengeꞌ keyegangan.” ");
INSERT INTO plw_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Dinangin et sembatung pariꞌ naꞌ Pariseo si Jesus na dut kedye mengaan, angkansa siminurung ya dut benwaʼt Pariseo ampaꞌ ne nampang dut lemisaan. ");
INSERT INTO plw_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ganang nesewran et sembatung libun neng megpengebiyagan dut keselaan na si Jesus dut benwa et pariꞌ naꞌ Pariseo, sinurungan ye ya duntin bekeꞌ nibit et mergaꞌ neng bebengluen naꞌ pesusunuꞌ et katsaꞌ naꞌ alabastro. ");
INSERT INTO plw_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Indyari nepekabiꞌ ya dut titikeran i Jesus segwaꞌ megsisiyak lang, indyari tinuruan et luhaꞌ ye tiked i Jesus. Indyari kinuskusan ye et buek ye pegketbes inimbuan ye bekeꞌ binuakan ye et bebengluen. ");
INSERT INTO plw_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Pegkebiriꞌ et Pariseo neng nengdangin kenye in nekebiriꞌ et itue, kwaʼt pikir ye, “Baꞌ tantu itueng taaw sembatung tarus et Empuꞌ, mekedyaring mesewran ye baꞌ sinu pengutew kenye in bekeꞌ mesewran ye baꞌ enung pegkelibun ye, na ya sembatung mekeselaan.” ");
INSERT INTO plw_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Indyari sinugid i Jesus, kwan ye, “Simon, maya lang sugiren ku dimu.” “Sugiriꞌ ku, Begerar,” kwan i Simon selus. ");
INSERT INTO plw_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Itueng tuturan sinugid i Jesus kenye, kwan ye, “Maya duwang ketawan nengutang dut sembatung pepeutang. Sembatu in neutang ye limang gatus, sembatu in neutang limangpuluꞌ lang. ");
INSERT INTO plw_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ganang diki dye ne kebayad, saliꞌ dye duwa pinetawad dut utang dye, na tiban, sinu kedye megmergaꞌ et banar dut negpeutang in?” ");
INSERT INTO plw_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Indyari siminambag si Simon, kwan ye, “Meraliꞌ, dut pikir ku lang, ating nekeutang et kelaꞌ na pinetawad in.” Kwan i Jesus, “Sugat ukuman mu in.” ");
INSERT INTO plw_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Indyari tineyuma i Jesus libun in, kwan ye dut ki Simon, “Kerangan ku samat itueng libun tuꞌ, sabab siminled kuʼt benwa mu misan danum kaya lang negey ke supaya ibasaꞌ kuʼt tiked ku samat inarat tyu. Segwaꞌ et itueng libun nepenyuꞌ ye tiked kuʼt luhaꞌ ye pegketbes kinuskusan ye et buek ye. ");
INSERT INTO plw_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Kaya mu aku inimbuan samat inarat tyu, segwaꞌ itueng libun tihad nega dut pegseled ye et benwa kaya taren imbu ye dut tiked ku. ");
INSERT INTO plw_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Megdemikian gasi kaya lang binalung mu ulu ku et lana samat inarat tyu, segwaꞌ kenye ga binuakan yeʼt bebengluen tiked ku. ");
INSERT INTO plw_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Angkansa isugid ku dimyu, mengeꞌ keselaan ye minaap ne, angkansa kelaꞌ pegmergaꞌ. Temed sebarang minaap et isek-isek, atin isek-isek gasi pegmergaꞌ ye.” ");
INSERT INTO plw_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Indyari kwan i Jesus dut libun in, “Mengeꞌ keselaan mu pinemaap ne.” ");
INSERT INTO plw_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Indyari mengeꞌ iba yeng pemengaan in nemegsiingkut-ingkutan dye kwan dye. “Sinu takung taaw itue e, misan mengeꞌ keselaan mekemaap ye?” ");
INSERT INTO plw_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Indyari kwan i Jesus dut libun in, “Dimung pengandel, atin nemuwas dimu. Naꞌ pegnunga-nunga et panew mu.” ");
INSERT INTO plw_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Pegketbes et itue siminurung si Jesus dut lungsud sampay negpelatun-latun dut mengeꞌ kebenbenwanan na pepeabar et Menungang Abar pasal et pegmilik et Empuꞌ. Pebebayaꞌ nega kenyeng sempuluꞌ duwang pepengenaran in. ");
INSERT INTO plw_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Megdemikian nememayaꞌ mengeꞌ kelilibunan neng pinegulinan ye et begbalig dye sampay indeginis neng mengeꞌ reresanen dye. Sembatu ne si Maria, pegngeranen gasi et Magdalena, dut kenye nepeliwan pitung mereraat neng diwata, ");
INSERT INTO plw_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","bekeꞌ si Juana esawa i Kusa, na pepengendelan i Gobernador Herodes, bekeꞌ si Susana sampay mekansang nega iba. Itueng kelilibunan memegtabang dye teyeg dut kedyeng kineredyanan kire Jesus. ");
INSERT INTO plw_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Pagkaꞌ mekansang ne mengeꞌ taaw netimung pesusurung dut ki Jesus teyeg dye dut leing-leing mengeꞌ lungsud, tinuturanan ye dye et itueng beleybey. ");
INSERT INTO plw_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Kwan ye, “Sembatung mengunguma siminurung dut uma ye supaya menabug. Ganang pegsabug ye ne pungu ye iba in, nerebsakan ye dut dalan sampay liminantut. Na itue nebiyaan et bekurkur indyari kinaan ye. ");
INSERT INTO plw_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Iba gasing pungu in nerebuan ye dut kebebetuan, ganang timinuhuꞌ ne, nemengrep ne sabab kaya mekenemugan. ");
INSERT INTO plw_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ibang pungu in nerabuꞌ dut tegeilemunen tagnaꞌ kiminansang mengeꞌ ilemunen atin ne nenglemes et luluwaken. ");
INSERT INTO plw_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Segwaꞌ maya iba nerabuꞌ dut menungang lugtaꞌ. Timinuhuꞌ seked-seked nuaꞌ et kesenggatus, lumbi dut pungu naꞌ nesasad.” Ganang nebres i Jesus ne itue, negsugid et mebasag, kwan ye, “Sebarang maya telinga ikingeg, kumingeg. Maya telinga myu, diki be! Angkansa kinggaꞌ myu et menunga.” ");
INSERT INTO plw_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Nengingkut mengeꞌ pepengenaran i Jesus, kwan dye, “Enu ingin bersen et beleybey naꞌ itue?” ");
INSERT INTO plw_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Indyari kwan i Jesus, “Ipebebgey ne dut dimyu kesesewran pasal et mengeꞌ taguꞌ baꞌ pesalan nega dut pegmilik et Empuꞌ, segwaꞌ dut iba pegbersen ku lang kedye et pebeleybey supaya; ‘Misan ne sumyek dye, segwaꞌ diki dye kebiriꞌ bekeꞌ misan ne kumingeg dye, segwaꞌ diki dye meretian.’ ” ");
INSERT INTO plw_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Na itue ingin bersen et beleybey: ating pungu, atin ne bebresen et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Sebarang nerabu dut dalan, atin ne dye na nemekekingeg, pegketbes diminateng si Seytan inugad bebresen dut seled pusuꞌ dye supaya diki dye keandel apang mebawiꞌ. ");
INSERT INTO plw_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Sebarang neregdag dut kebebetuan atin ne dye mengeꞌ memegenep selus et pegterima pegkekingeg dye lang et beres et Empuꞌ, segwaꞌ kaya nekerarem gamut dye. Nemengandel sementaraꞌ, segwaꞌ pegdatek et maya sulay, nelipatan dye ne. ");
INSERT INTO plw_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Sebarang nerebuan ye dut ilamun, atin ne dye nemekekingeg et bebresen et Empuꞌ, temed neraag dye et mengeꞌ ginis neng pegpipikiren, bekeꞌ kementirian, sampay siminangkaꞌ et biyag, angkansa kaya negnunga. ");
INSERT INTO plw_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Sebarang nerebuan ye dut menungang lugtaꞌ, atin ne dye nemekekingeg et beres et Empuꞌ, ipesled ne dye, na maya dye menunga bekeꞌ metignaꞌ neng pusuꞌ, pegsandal dye seked memuaꞌ dye et menunga.” ");
INSERT INTO plw_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Kaya taaw pegsiluꞌ ye et sembatung saleng, pegketbes sekluban ye et siburan, etawa dut sirib et igaan. Erapun iratun ye dut semberikaran supaya sebarang mengungumbaley kebiriꞌ et binyar ye. ");
INSERT INTO plw_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Megdemikian kaya megtetaguꞌ naꞌ, diki nebuar. Sampay kaya lang tinaguꞌ na diki mesewran etawa mebibit nega dut keheyangan. ");
INSERT INTO plw_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Angkansa inunganaꞌ myu dimyung pengingeg, sabab sebarang maya neretian ye, begeyan nega et Empuꞌ. Bekeꞌ sebarang kaya, ugaran nega gasi, sampay erim yeʼt kenye in, isien nega eset kenye in.” ");
INSERT INTO plw_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Naꞌ, nemengduntin ki Jesus kenyeng induꞌ bekeꞌ mengeꞌ ketipusdan ye, segwaꞌ diki dye kepekabiꞌ sabab et kineldamaʼt mengeꞌ taaw. ");
INSERT INTO plw_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Indyari maya negsugid kenye, kwan ye, “Induꞌ, bekeꞌ mengeꞌ ketipusdan mu dut liwan. Ingin dye mekipegkita rimu.” ");
INSERT INTO plw_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Sinambag i Jesus, kwan ye, “Sebarang megkingeg bekeꞌ megtuman et beres et Empuꞌ atin dye in siringan mengeꞌ induꞌ bekeꞌ ketipusdan ku.” ");
INSERT INTO plw_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Sembatung eldew kwan i Jesus dut mengeꞌ pepengenaran ye, “Dumipag tyu dut sembelang dagat.” Indyari siminakat dye ne dut gubang ampaꞌ dye ne timinulak. ");
INSERT INTO plw_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ganang meglelayag dye ne, nekeigaꞌ si Jesus. Kaya enu-enu atin mene inggaꞌ dye diminateng ne ribut, naꞌ nebehanan net dagat gubang dye angkan dye tiban mekedyaring meriwaraꞌ ne. ");
INSERT INTO plw_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Indyari kinebiyan net mengeꞌ pepengenaran ye pegketbes tiniyag ye si Jesus, kwan dye, “Menunulduꞌ, Menunulduꞌ, metgeb tyu ne!” Indyari negbangun si Jesus. Pegketbes binulag ye deres bekeꞌ pemsaꞌ neng mengeꞌ gumbang, negdingat bulag ye megtuy timingew begyu sampay limininew. ");
INSERT INTO plw_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","“Kaya takuꞌ pegandel myu?” binres ye kenyeng mengeꞌ pepengenaran. Bibit meraliꞌ et takut bekeꞌ pengliluꞌ kedye ginsan. Nemegsiingkut-ingkutan dye kwan dye, “Sinu takuꞌ itue e? Misan deres bekeꞌ dagat megibut et bulag ye?” ");
INSERT INTO plw_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Indyari neglenlahyun layag dye surung dut lungsud et Geraseno, dut entek et Galilea. ");
INSERT INTO plw_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Pegdungguꞌ dye nineug si Jesus dut deplakaʼt dagat. Naꞌ maya siminusup kenye sembatung begbalig teyeg et kebenbenwanan dun. Nekwit ne atin kaya ne pegbadyuꞌ bekeꞌ kaya ne dut benwa peglegdengan ye, segwaꞌ daran in dut lelelbengan ne pegigaan ye. ");
INSERT INTO plw_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Pegkebiriꞌ ye ki Jesus, giminerwak ampaꞌ ne nepekleb dut titikeran ye. Pegketbes giminerwak et mebasag, kwan ye, “Enu adyat mu daken, Jesus, Yegang et Ketaas-taasan naꞌ Empuꞌ? Engaten ku teyen dimu asiꞌasiꞌ. Kasiꞌ ku pegpeliyutiꞌ!” ");
INSERT INTO plw_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Angkansa dinaak i Jesus meraat neng diwata na lumiwan dut lelaki, sabab nekwit-kwit ne pegtagnaꞌ et pegbegbalig ye. Bekeꞌ misan tungguan bekeꞌ sigtaʼt rantay et besiꞌ, mekepugtaꞌ ye nega sampay pegbiten ya et meraat neng diwata dut kelnangan. ");
INSERT INTO plw_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Indyari iningkut i Jesus, kwan ye, “Enu ingaran mu?” Siminambag gasi dut kenye, kwan ye, “Ingaran ku si Ribu.” Sabab mekeldam neng mengeꞌ mereraat neng diwata siminled dut kenye. ");
INSERT INTO plw_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Daran atin mengeꞌ mereraat neng diwata negpeasiꞌasiꞌ na endey dye ipeteptap dut kerereman na kaya seskeran, dut Narkaꞌ. ");
INSERT INTO plw_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Indyari dut lugtaꞌ naꞌ atin maya banan et mengeꞌ biyek na pemenginaan dut iged-iged et bulud. Inangat et mengeꞌ mereraat ki Jesus na ipesled dye ne lang dut mengeꞌ biyek tiꞌ. Indyari tinugutan ye ne dye. ");
INSERT INTO plw_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Indyari nemengliwan mengeꞌ mereraat neng diwata ampaꞌ dye ne siminled dut mengeꞌ biyek. Nemengdarak pesedsad mengeꞌ biyek surung dut mepengpang nenestarus dut dagat seked nelelmes dye ginsan. ");
INSERT INTO plw_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ganang nebiriꞌ et mengeꞌ mengingipat kwantin ne neinabu, nemengdarak dye pesurung dut lungsud naꞌ atin sampay dut mengeꞌ kebenbenwanan supaya ipesewd baꞌ enu neinabu. ");
INSERT INTO plw_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Indyari nemengliwan mengeꞌ taaw supaya birinen baꞌ enu neinabu. Pegdateng dye dut ki Jesus nebiriꞌ dye begbalig mena tiꞌ neng taaw megarung ne dut titikeran i Jesus, maya ne badyuꞌ ye sampay menunga ne nakem ye. Segwaꞌ tinekutan dye key. ");
INSERT INTO plw_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Mendyari tinuturanan dye et sebarang mengeꞌ nekesaksiꞌ in baꞌ enukwan pinegulinan i Jesus taaw neng begbalig in. ");
INSERT INTO plw_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Pegketbes et atin ginsaʼt mengeꞌ taaw et ating lungsud et Geraseno negpeasiꞌasiꞌ banar ki Jesus na baꞌ mekedyari mugad ne sabab nesled dye banar et takut. Angkansa siminakat ne ya dut gubang apang tumireng ne kedye. ");
INSERT INTO plw_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ating taaw negulinan et pegbegbalig ye meingin teyen na mayaꞌ ne ki Jesus, segwaꞌ kwan i Jesus kenye, ");
INSERT INTO plw_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Muliꞌ ke ne lang dut benwa mu, ituturanaꞌ kedye baꞌ enung deklaʼt binwat et Empuꞌ dimu.” Indyari nuliꞌ ne kenye pegdateng ye dun tinuturan ye ne dut mengeꞌ taaw et lungsud na atin na baꞌ enung deklang ginis binwat i Jesus dut kenye. ");
INSERT INTO plw_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ganang nekepeuliꞌ ne gasi si Jesus dut dipag et dagat, kineldaman timinerima kenye, sabab ginsan dye megtetagey kenye. ");
INSERT INTO plw_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Nepekabiꞌ kenye sembatung pepengendelan et pengempuan naꞌ benwa, ingaran ye si Jairo. Negpekleb dut titikeran i Jesus bekeꞌ negpeingasiꞌ na mayaꞌ mena kenye dut benwa. ");
INSERT INTO plw_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Sabab meinglew banar kesembatu-sembatung yegang ye naꞌ libun, na megumur peꞌ et sempuluꞌ duwa. Segwaꞌ sasat si Jesus dut dalan pesurung ki Jairo, mekerumpiet ne lagi et mengeꞌ taaw. ");
INSERT INTO plw_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Segwaꞌ pebebayaꞌ dun sembatung libun na pegliwanan et duguꞌ seled sempuluꞌ duwang teun ne kwit ye, temed kaya sinung mengunguru mekepenunga kenye. ");
INSERT INTO plw_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Indyari nepekabiꞌ dut lilikuran ampaꞌ ye ne kinutew seseyuran et badyuꞌ i Jesus, indyari megtuy timingew pegduduguꞌ ye. ");
INSERT INTO plw_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","“Sinu kiminutew daken?” kwan i Jesus. Segwaꞌ kaya sinu nekakuꞌ megsugid, angkan si Pedro kenye neres, kwan ye, “Menunulduꞌ, mekeldam landuꞌ mengeꞌ taaw megrurumpiet dimyu.” ");
INSERT INTO plw_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Segwaꞌ siminambag si Jesus, kwan ye, “Maya kuminutew daken, sabab neresanan ku na maya keseg liminiwan dut daken.” ");
INSERT INTO plw_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Pegkaꞌ nerim-erim et libun na diki metaguꞌ baꞌ enu binwat ye. Angkansa nepekleb dut titikeran i Jesus na megegerger ne. Sinugid ye dut mengeꞌ elepaʼt mengeꞌ taaw baꞌ manu kinutew ye si Jesus bekeꞌ baꞌ enukwan ya negulinan megtuy. ");
INSERT INTO plw_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Indyari kwan ye dut libun, “Yegang, pinegulinan ke et dimung pegandel. Na pegnunga-nunga lang.” ");
INSERT INTO plw_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Sasat megbebres nega si Jesus maya sembatu nepekabiꞌ kenye mawaꞌ ye dut benwa i Jairo neng sembatung pepengendelan et pengempuan naꞌ benwa, indyari negsugid atin dinaak ki Jairo, kwan ye, “Yegang mu patey ne, kasiꞌ ne pegsesewaꞌ Menunulduꞌ in.” ");
INSERT INTO plw_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Pegkekingeg i Jesus et itue, kwan ye dut ki Jairo, “Kas takut, mengandel ke lang. Yegang mu in megulinan.” ");
INSERT INTO plw_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Pegdateng dye dut benwa i Jairo, kaya sinu tinugutan i Jesus na sumled selyu lang si Pedro, si Juan, bekeꞌ si Jakob, bekeꞌ amaꞌ bekeꞌ induꞌ et yengyegang lang in. ");
INSERT INTO plw_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Meglalam net megsiyak ne mengeꞌ ginsaʼt taaw duntin. Segwaꞌ kwan i Jesus kedye, “Kas kewʼt siyak, diki patey ating yengyegang, segwaꞌ megelek lang.” ");
INSERT INTO plw_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Pinegketkesitan et mengeꞌ taaw si Jesus, sabab sewd dye patey ne yengyegang. ");
INSERT INTO plw_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Segwaꞌ kimpetan i Jesus keremut ye, kwan ye, “Yegang, pegbangun ne!” ");
INSERT INTO plw_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Indyari negpeuliꞌ nakem ye, pegketbes negbangun. Nengdaak si Jesus na begeyan megtuy et pegkaan. ");
INSERT INTO plw_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nemegliluꞌ mengeꞌ kegunggurangan et yengyegang, segwaꞌ negpeasiꞌasiꞌ banar si Jesus na dyangan isugid baꞌ enu neinabu. ");
INSERT INTO plw_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Pegkaꞌ pinetingkag ne i Jesus sempuluꞌ duwang pepengenaran in, pinengbegeyan ye ne dye et basag bekeꞌ kepetan naꞌ megpeugad et mengeꞌ mereraat neng diwata na diki sesaliꞌ sampay megpenunga et ginis neng mengeꞌ reresanen. ");
INSERT INTO plw_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Dinaak i Jesus dye supaya gasi megpabar et Menungang Abar pasal et pengmilikan et Empuꞌ, bekeꞌ gasi megpenunga et mengeꞌ mesesakit. ");
INSERT INTO plw_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Kwan ye dut didye, “Kas kewʼt bibit et misan enu dut pepenewan myu, samat tutungkud, sutsuput, lutuꞌ, pirak etawa repanan. ");
INSERT INTO plw_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Segwaꞌ baꞌ embeng benwa na meretengan myu, lumegdeng kew duntin seked ugaran myu lungsud naꞌ atin. ");
INSERT INTO plw_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Na baꞌ maya sembatung lungsud supama tumerima mengeꞌ taaw dimyu, tumireng kew ne et lungsud naꞌ atin itultugaꞌ myu tehuk dut tiked myu, supaya pesebenaran na dye megsesagkaꞌ bekeꞌ kaya pearap dut Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Indyari nememanew dye ne. Pegdateng dye dut mengeꞌ kebenbenwanan sampay negpelatun-latun dye duntin. Pepeabar dye Menungang Abar bekeꞌ negpenunga et mengeꞌ mesesakit baꞌ tumkaꞌ dut misan embeng pepenewan dye. ");
INSERT INTO plw_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Na nekesewd si Herodes neng Gobernador et ginsan baꞌ enu neinabu. Indyari negsusa ne pikiran ye sabab pasal i Jesus, baꞌ iba pesugiren si Juan kunuꞌ negbiyag ne peuliꞌ. ");
INSERT INTO plw_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Segwaꞌ baꞌ iba gasi megsugid si Elias kunuꞌ nepebiriꞌ, kwan gasi et mengeꞌ iba kaluꞌ tagnaꞌ neng tarus negbiyag peuliꞌ. ");
INSERT INTO plw_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Segwaꞌ negberes si Herodes kwan ye, “Si Juan be, pineputkan ku net ulu. Segwaꞌ sinu itueng mekehebaran?” Angkansa gay i Herodes banar na mekita ye si Jesus. ");
INSERT INTO plw_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ganang nemekepeuliꞌ ne mengeꞌ pepengenaran i Jesus, tinuturan dye ginsan ki Jesus baꞌ enu pinemuwat dye. Angkansa, pinebayaꞌ i Jesus ne didye lang pesurung dut sembatung lungsud ingaran ye Betsaida. ");
INSERT INTO plw_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Segwaꞌ nesewran itue et mengeꞌ taaw, angkansa nepesunud dye dut kenye. Pegdateng et mengeꞌ taaw duntin, tinerima de Jesus et menunga. Indyari tinuturanan ye dye pasal et pengmilikan et Empuꞌ, bekeꞌ pinegulinan ye sebarang maya reresanen. ");
INSERT INTO plw_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Pegkaꞌ megsesdep ne eldew, sempuluꞌ duwang pepengenaran in nepekabiꞌ ki Jesus, kwan dye, “Ipeugaraꞌ myu ne mengeꞌ taaw in supaya keruntin dye dut mengeꞌ kebenbenwanan eset pelilibut in, supaya ketulus dye et mengeꞌ pegkaan bekeꞌ meigaan. Sabab tiban itue e atuꞌ tyuʼt kelnangan.” ");
INSERT INTO plw_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Segwaꞌ kwan i Jesus, “Begeyiꞌ myu dye et pegkaan.” Siminambag dye, “Maya atue e segwaꞌ lilimang bengbang bekeꞌ duruwang betuen neng seraꞌ. Kekaan takuꞌ itueng kansang et taaw tuꞌ? Selyu baꞌ ingin mu, mengelen kay et pekanan.” ");
INSERT INTO plw_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ating masa maya limang ribung kelelekian. Negsugid si Jesus dut kenyeng mengeꞌ pepengenaran, kwan ye, “Iperungaꞌ myu dye et teglimangpuluꞌlimangpuluꞌ.” ");
INSERT INTO plw_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Indyari pinarung ne et mengeꞌ pepengenaran i Jesus mengeꞌ taaw, samat sinugid kedye i Jesus in. ");
INSERT INTO plw_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Insiꞌ i Jesus limang bengbang in, bekeꞌ duwang betuen naꞌ seraꞌ in. Indyari timiningaraꞌ dut langit ampaꞌ ne negpeselamat. Pegketbes, pinegtektahak ye ne mengeꞌ bengbang bekeꞌ seraꞌ in. Indyari binggey ye itue dut mengeꞌ pepengenaran ye supaya ipenupaꞌ dut mengeꞌ taaw. ");
INSERT INTO plw_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nemekekaan ginsan seked binyagan. Pegketbes tinimung et mengeꞌ pepengenaran eped in, seked nemekebaha dye nega et sempuluꞌ duwang tabig. ");
INSERT INTO plw_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Sembatung eldew si Jesus negpenalang dut Empuꞌ ating masa, diri ye, iba ye mengeꞌ pepengenaran ye. Pegketbes nengingkut si Jesus kedye kwan ye, “Sinu kunuꞌ aku kwan et kineldaman?” ");
INSERT INTO plw_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Siminambag dye, kwaʼt iba, “Ikew kunuꞌ si Juan neng Mememewtismu. Iba, kwan dye, si Elias. Bekeꞌ maya gasi iba pegsugid na ikew tuꞌ sembatung tarus tagnaꞌ na negbiyag peuliꞌ.” ");
INSERT INTO plw_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","“Segwaꞌ ingkuten ku kemyu pasal daken, sinu aku?” kwaʼt ingkut i Jesus. Indyari siminambag si Pedro, kwan ye, “Kristo et Empuꞌ, piniliꞌ et Empuꞌ na mememegbeg.” ");
INSERT INTO plw_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Indyari negpeamay-amay si Jesus na dyangan isugid itue dut misan sinu. ");
INSERT INTO plw_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Kwan ye, “Aku itueng Yegang et Taaw kelabay et ginis neng ketiksaan, sampay reaten nega et mengeꞌ megurang, bekeꞌ metaas neng mengeꞌ pariꞌ, bekeꞌ mengeꞌ menunulduꞌ et Keseraan, sampay imeteyen nega ya. Segwaꞌ pegdatek iketlung eldew, megbiyag peuliꞌ.” ");
INSERT INTO plw_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Indyari sinugid i Jesus dut ginsan; “Na baꞌ sinu meingin mibut daken, subaliꞌ lipatan ye pasal kenyeng bilug, pesanen ye kenyeng krus, ingin bersen sumandal et keliyutan misan dut kemeteyan, peldew-peldew indyari mibut daken. ");
INSERT INTO plw_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Segwaꞌ baꞌ sinu megmergaꞌ bilug ye, atin meilangan. Temed baꞌ sinu meilangan et biyag ye sabab lang et daken, atin muliꞌ nega kenye biyag ye dut langit. ");
INSERT INTO plw_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Enu kepulusan ye sentin baꞌ sembatung taaw mekeptan ye ganaꞌ ginsaʼt lungsud, segwaꞌ diri ye meruntit kesusaan? ");
INSERT INTO plw_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Na baꞌ aku sampay bebresen ku mendinan mengeꞌ taaw et sinu-sinu, megdemikian dye mendinan gasi ya et Yegang et Taaw dut pegatuꞌ ye peuliꞌ. Na derateng atin Yegang et Taaw dun et ketaasan ye bekeꞌ ketaasan et Amaꞌ bekeꞌ dut metignaꞌ neng mengeꞌ dereakan et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Katew, sugiran ku kemyu, indaniꞌ myu, maya atue tiban na diki matey seked ingga nebiriꞌ dye Pegmilik et Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Maya ne walung eldew tihad et pegberes i Jesus et itue, pinebayaꞌ ye de Pedro, si Juan bekeꞌ si Jakob. Timinungul dye dut bukid. Si Jesus megpenelang dut Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ganang megpenelangin ya ne, negpinda dagbes et rupa i Jesus, badyuꞌ ye kwantin key et seru et eldew in. ");
INSERT INTO plw_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Pegseyek dye, nebiriꞌ dye duwang taaw kelelekian neng natey ne tagnaꞌ, si Moises bekeꞌ si Elias. ");
INSERT INTO plw_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Neperatew kedyeng mengeꞌ bilug memegkidyep-kidyep, bekeꞌ pememisara ki Jesus. Pegsusugiren dye pasal et ketumanan et paru ki Jesus et Empuꞌ na diki ne mekwit meinabu ne dut lungsud et Jerusalem. ");
INSERT INTO plw_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Mememegigaꞌ ne teyen banar de Pedro sampay mengeꞌ iba ye, segwaꞌ nemekektiyag et mebarad bekeꞌ nebiriꞌ dye si Jesus bekeꞌ duwang mengeꞌ kelelekian na megtitiyeg na memegseru mengeꞌ bilug dye. ");
INSERT INTO plw_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ganang memegtitireng ne mengeꞌ kelelekian in, negberes si Pedro, kwan ye, “Menunulduꞌ, menunga lengku baꞌ atuꞌ kay lang mena. Baꞌ gayen mu, memaal kay et telung tetetluan, sembatu dimu, ki Moises sembatu, bekeꞌ ki Elias sembatu.” Nebres ye lang atin sabab kaya hemen-hemen ye. ");
INSERT INTO plw_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Sasat megbebres nega si Pedro, diminateng mekapal naꞌ kunem, bekeꞌ neselikupan dye ginsan. Nemeketakut dye sabab dun dye net seled kunem tiꞌ. ");
INSERT INTO plw_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Indyari maya neres teyeg dut kunem naꞌ atin, kwan ye, “Itue e daken naꞌ yegang, na piniliꞌ ku; Kinggaꞌ myu ya.” ");
INSERT INTO plw_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ganang tebes ne neres, pegseyek dye yaya mene si Jesus. Indyari kaya ne ginibek et mengeꞌ pepengenaran ye bekeꞌ kaya nemegsugid dut sinu-sinu pasal et kedyeng nebiriꞌ. ");
INSERT INTO plw_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Pegkeduwanan, ganang nepesedsad dye ne teyeg dut bukid, mekeldam taaw siminusup ki Jesus. ");
INSERT INTO plw_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Na maya sembatung lelaki teyeg dut kineldaman timiningkag et mebasag. Kwan ye, “Menunulduꞌ, meingasiꞌ ke daken, birinaꞌ mena yegang ku naꞌ lelaki, sabab ya bugtung lang naꞌ yegang ku. ");
INSERT INTO plw_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Maya sembatung meraat neng nakem megsaleb kenye. Na baꞌ sibantuꞌ dumateng meraat neng nakem, megkelat lang gerwak ye; megtuwad mata ye bekeꞌ megkesay-kesay ne mengeꞌ tiked ye, sampay babaꞌ ye meglabun. Usa-usa diki ne mekeseulian bekeꞌ daran pegtiksaen. ");
INSERT INTO plw_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Negpeingasiꞌ ku teyen dut mengeꞌ pepengenaran mu na ipeugad ating meraat neng megdapel kenye. Segwaꞌ kaya lang negeesan dye binwat.” ");
INSERT INTO plw_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Kwan i Jesus, “Asal be pengkataʼt mereraat bekeꞌ kaya pegandel, seked ingyan ku kemyu pegsendalan? Heꞌ, bitaꞌ atue yengyegang in.” ");
INSERT INTO plw_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ganang pinekabiꞌ ne ki Jesus yengyegang neng lelaki in, dineplan et mereraat neng diwata ampaꞌ gasi negdengdengen. Ampaꞌ ne sentin nepermak, na pekeykesay mene. Segwaꞌ tinahag i Jesus meraat neng siminaleb kenye in, indyari negulinan ne ating yengyegang. Pegketbes, inuliꞌ i Jesus ne dut amaꞌ. ");
INSERT INTO plw_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Pegkaꞌ kwantin ne neinabu, ginsan dye neliluꞌ dut ketaasan et Empuꞌ. Segwaꞌ ganang pemegliluꞌliluꞌ dye nega ginsan pasal neng ginis naꞌ binwat i Jesus in, negberes si Jesus, kwan ye dut mengeꞌ pepengenaran ye. ");
INSERT INTO plw_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ipekinggaꞌ myu banar itueng isugid ku dimyu; Ating Yegang et Taaw ipealew dut mengeꞌ keremut et mengeꞌ taaw.” ");
INSERT INTO plw_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Segwaꞌ kaya lang neretian dye baꞌ enu ingin bersen, sabab inawam itue kedye angkan diki dye meretian. Kaya gasi mekeurem dye mengingkut dut kenye pasal et kenyeng pinegberes in. ");
INSERT INTO plw_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Pemegdawa-dawa mengeꞌ pepengenaran i Jesus et baꞌ sinu lebing metaas kedye ginsan. ");
INSERT INTO plw_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Segwaꞌ pegsesewren i Jesus pikiran dye, angkansa, ipinekabiꞌ kenye sembatung yengyegang in, ipinetiyeg set abiꞌ ye. ");
INSERT INTO plw_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Indyari kwan i Jesus dut kedye, “Baꞌ ya sinu menerima et yengyegang sabab lang et daken, megsepantun aku tinerima ye. Bekeꞌ sebarang menerima daken, sepantun tinerima ye Empuꞌ naꞌ negdaak daken. Sabab baꞌ sinu lebing mebaba dut dimyu ginsan, ya in mepantun lebing metaas.” ");
INSERT INTO plw_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","“Menunulduꞌ”, kwan i Juan, “nebiriꞌ kay maya sembatung lelaki megpeliwan et mereraat bekeꞌ pegsimbehaten ye ingaran mu, segwaꞌ linaang kay ya, sabab diki ya kebeꞌbayaꞌ tyu.” ");
INSERT INTO plw_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Kwan i Jesus, “Kasiꞌ myu ya peglaangaꞌ, sabab sebarang diki megsagkaꞌ dimyu atin, kekampi myu.” ");
INSERT INTO plw_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ganang megkekabiꞌ ne timpuʼt iperibuwat i Jesus dut langit, pinaru ye na ya sumurung dut Jerusalem. ");
INSERT INTO plw_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Segwaꞌ negdaak mena et mengeꞌ tetehagen ye na muna set kenye. Siminurung dye dut sembatung kebenbenwanan et Samaria supaya penyapen ginsan pasal et tetegeyan neng melegdengan ye. ");
INSERT INTO plw_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Segwaꞌ mengeꞌ taaw duntin kaya nenerima ki Jesus sabab ya megsusurung dut Jerusalem, bekeꞌ diki lang mekedyari kepetaren si Jesus dut kedye. ");
INSERT INTO plw_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ganang nebiriꞌ et mengeꞌ pepengenaran yeng de Jakob bekeꞌ si Juan na samat kwantin pengasip kedye, kwan dye, “Menunulduꞌ, gay mu takuꞌ na sumegina kay et Empuꞌ apang pesanad apuy teyeg dut langit supaya meruhung dye ne?” ");
INSERT INTO plw_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Segwaꞌ tineyuma dye i Jesus indyari binresan ye dye. ");
INSERT INTO plw_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Pegketbes, nepelatun dye dut sembatung rurungan. ");
INSERT INTO plw_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Sasat dye memegpepanew dut dalan, maya sembatung lelaki negsugid ki Jesus, kwan ye, “Mibut ku dimu misan embe tenaan mu.” ");
INSERT INTO plw_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Siminambag si Jesus kwan ye, “Mengeꞌ ireng et talun maya lelegdengan dye, bekeꞌ mengeꞌ begit maya mengeꞌ pugad dye, segwaꞌ Aku neng Yegang et Taaw kaya misan metindalan ku.” ");
INSERT INTO plw_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Indyari sinugiran ye sembatung lelaki kwan ye, “Mibut ke daken.” Segwaꞌ siminambung lelaki in kwan ye, “Menunulduꞌ tugutiꞌ ku mena menglebeng et amaꞌ ku.” ");
INSERT INTO plw_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Segwaꞌ kwan i Jesus dut kenye, kwan ye, “Pesariꞌ ne mengeꞌ biyag kaya seskeran menglelebeng et mengeꞌ patey, segwaꞌ dimu, sumurung ke apang ipabar mu pegmilik et Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Indyari maya gasi negsugid dut ki Jesus, kwan ye, “Mibut ku dimu, Menunulduꞌ, segwaꞌ muliꞌ ku peꞌ supaya memuhun ku mena dut mengeꞌ kegunggurangan ku.” ");
INSERT INTO plw_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Negberes si Jesus kwan ye, “Baꞌ sinu megeraru na daran meglingew dut lilikuran ye, diki menunga atin. Megdemikian, baꞌ sinu pegsunud daken, temed pegpikiren ye pasal et ibang ginis, diki mekedyari na ya megkeradya dut milikan et Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Pegketbes et itue nemiliꞌ si Jesus et pitungpuluꞌ duwa negang mengeꞌ pepengenaran ye. Dinaak i Jesus dye tegduwa-duwa; Na muna dut sebarang duntinan yeng mengeꞌ lungsud sampay kebeberiuan. ");
INSERT INTO plw_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Negsugid si Jesus kedye, kwan ye, samat itue antangan ye, “Mengeꞌ kekeygen mekeldam, segwaꞌ sesenu ga mengeꞌ mengengeradya. Angkansa mengangat kew dut Empuꞌ et kekeygen, na megpebibit ya et mengengeyg dut uma ye. ");
INSERT INTO plw_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","“Na sumurung kew ne. Pegdeaken ku kemyu samat mengeꞌ ipatan dut tengaʼt mengeꞌ kumekaan. ");
INSERT INTO plw_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Kas kew net bibit et sutsuput et pirak sampay bayung bekeꞌ tempaꞌ, bekeꞌ kas kew net petaren set dalan baꞌ maya mekita myu. ");
INSERT INTO plw_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Pegseled myu dut misan sinung benwa, iempangaꞌ myu mena kedye kwanaꞌ myu, ‘Dumateng et benwa naꞌ itue kenunganan.’ ");
INSERT INTO plw_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Na baꞌ maya sembatung taaw sentin meireg et kenunganan, kenunganan myu tumeteg set kenye. Segwaꞌ baꞌ mendiꞌ dye tumerima dimyu, kenunganan muliꞌ dut dimyu. ");
INSERT INTO plw_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Indyari duntin tetegiꞌ set benwa naꞌ meireg et kenunganan. Kanaꞌ myu bekeꞌ inumaꞌ myu sebarang ipelamak dye dimyu sabab teupen sembatung mengengeradya na menerima et tengdan kenye. Na baꞌ nekelegdeng kew ne, endey ne megpelatun-latun dut ibang mengeꞌ benwa. ");
INSERT INTO plw_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Na baꞌ sumled kew ne gasi dut sembatung lungsud, kanaꞌ myu sebarang ipelamak set elepan myu. ");
INSERT INTO plw_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Peguliniꞌ myu sebarang mesesakit duntin bekeꞌ isugiraꞌ myu kedye, ‘Mekabiꞌ ne dut dimyu pegmilik et Empuꞌ.’ ");
INSERT INTO plw_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Segwaꞌ baꞌ sumled kewʼt sembatung lungsud na mendiꞌ menerima dimyu, lumiwan kew, indyari surung kew dut dalan pegketbes kwanaꞌ myu kedye, ");
INSERT INTO plw_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Misan tehuk et lungsud myu naꞌ simingket dut mengeꞌ tiked kay tultugen kay nega tendaꞌ et kemyu megsesagkaꞌ sabab kemyu ukumen et Empuꞌ. Temed, tantu banar itue baꞌ pasal et pegmilik et Empuꞌ mekabiꞌ ne!’ ");
INSERT INTO plw_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Iperendem ku dimyu pasal et lungsud et Sodoma, ating masa ipnuꞌ et keyeatan. Temed, sugiran ku kemyu, dut eldew naꞌ atin, merugey-rugey ipelabay ketiksaan dut tawʼt lungsud et Sodoma eset lungsud naꞌ atin sebarang diki menerima dimyu in.” ");
INSERT INTO plw_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Elulaꞌ mu ne, tawʼt lungsud et Korasin! Elulaꞌ mu ne, tawʼt lungsud et Betsaida! Sabab baꞌ dut tawʼt lungsud et Tiro bekeꞌ tawʼt lungsud et Sidon neinabu mengeꞌ keliluꞌlilung mengeꞌ binwat ku atue, kwit ne meraliꞌ taaw nemegsusun dye ne, ampaꞌ nemegbadyuꞌ dye ne et karut bekeꞌ nepelpuk dye ne dut abu. ");
INSERT INTO plw_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Segwaꞌ dut eldew et kelang ukuman et Empuꞌ, merugey-rugey ipelabay ketiksaan dut lungsud et Tiro bekeꞌ Sidon eset ipelabay dimyu. ");
INSERT INTO plw_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Megdemikian dimyu, tawʼt lungsud et Kapernaum, meperibuwat kew be dut langit? Diki, segwaꞌ meruntin kew dut Narkaꞌ!” ");
INSERT INTO plw_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Sinugid i Jesus dut mengeꞌ pepengenaran ye, kwan ye, “Na, sebarang megkingeg dimyu sepantun aku pegkinggen dye. Sebarang pegmendiꞌ dimyu, sepantun aku pegmendian dye. Segwaꞌ baꞌ sinu pegmendiꞌ daken, pegmendian ye Empuꞌ na negdaak daken.” ");
INSERT INTO plw_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Indyari memeguliꞌ net enep mengeꞌ pitungpuluꞌ duwa neng mengeꞌ pepengenaran in. Pegdateng dye nemegtuturan ne ki Jesus, kwan dye, “Begerar, misan mengeꞌ meliwanen penelinga damen sabab et pegbateng dut ingaran mu!” ");
INSERT INTO plw_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Sinugid i Jesus kwan ye, “Nebiriꞌ ku si Seytan na neregdag samat kilat teyeg dut langit. ");
INSERT INTO plw_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Katew linugut ku ne dimyu kepengdyarian na lumbut dut mengeꞌ seli, bekeꞌ mengeꞌ bengkenawa bekeꞌ menglaang dut ginsaʼt mengeꞌ keksegan et kebanta tyung si Seytan. Misan enukwan diki dye mekepesakit dimyu. ");
INSERT INTO plw_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Segwaꞌ kas kewʼt enep sabab et penelinga ne dimyu mengeꞌ mereraat neng diwata, segwaꞌ enepiꞌ myu sabab nesurat ne et Empuꞌ Banar ingaran myu dut langit.” ");
INSERT INTO plw_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ating masa, nebahaʼt enep si Jesus sabab dut menungang nakem naꞌ Empuꞌ. Indyari kwan ye, “Pegbentugen te ikew Amaꞌ, Begerar et sengkelangit sampay sengkedunyaꞌ, sabab inawam mu dut mengeꞌ mekesewd pasal et pengmilikan mu kaluꞌ dye gasi megkesewd, segwaꞌ pineretiꞌ myu dut dimung awam peꞌ keyengyegangan. Tantu banar, Amaꞌ, sabab et kwantin mekesulutan ke. ");
INSERT INTO plw_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Ginsan neng keginisan pinegbayaꞌ ne daken et Amaꞌ. Kaya sinu nekesewd baꞌ sinu Yegang selyu lang baꞌ Amaꞌ, bekeꞌ kaya gasi nekesewd et Amaꞌ selyu lang baꞌ Yegang, bekeꞌ baꞌ sinu lang kegeayan et Yegang naꞌ pesewran ye.” ");
INSERT INTO plw_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Indyari pegteyuma i Jesus dut mengeꞌ pepengenaran ye negberes ya dut kedye-kedye lang, kwan ye, “Mesukud kew sabab mekebiriꞌ myu samat itueng nebiriꞌ myu. Sabab nebibiriꞌ myu samat itue mengeꞌ mekebiriꞌ myu. ");
INSERT INTO plw_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Segwaꞌ sugiran ku kemyu na maya mengeꞌ tarus et Empuꞌ bekeꞌ mengeꞌ surutan tagnaꞌ na meingin mebiriꞌ samat mekebiriꞌ myu tuꞌ, temed kaya mekebiriꞌ myu tagnaꞌ bekeꞌ kumingeg samat mekekingeg myu tuꞌ, segwaꞌ diki dye nekingeg.” ");
INSERT INTO plw_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Indyari maya sembatung biaksa dut Keseraan na timinyeg supaya sulayan si Jesus, kwan ye, “Menunulduꞌ, enu buwaten ku supaya mekpetan ku biyag na kaya seskeran?” ");
INSERT INTO plw_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Indyari siminambag si Jesus, kwan ye, “Enu nesurat dut Keseraan i Moises bekeꞌ enu nebatsaꞌ mu duntin?” ");
INSERT INTO plw_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Sinambag ye si Jesus, kwan ye, “Inginaꞌ Begerar naꞌ Empuꞌ mu dut ginsan seled pusuꞌ mu bekeꞌ dut ginsan seled kurudua mu, sampay ginsaʼt basag mu, bekeꞌ ginsaʼt pikiran mu. Bekeꞌ inginaꞌ sebayaꞌ mu samat pegingin mu et bilug mu.” ");
INSERT INTO plw_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","“Sugat banar penambung mu,” kwan i Jesus. “Na, buwataꞌ itue supaya ke megbiyag kaya seskeran.” ");
INSERT INTO plw_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Segwaꞌ ingin ye na mesdengan nega ya banar. Angkan iningkut ye gasi si Jesus, kwan ye, “Sinu mengeꞌ sebayaꞌ ku?” ");
INSERT INTO plw_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Sinugid i Jesus kwan ye, “Maya sembatung tawʼt Judio pekekenapan teyeg dut Jerusalem surung dut Jeriko, na inepaan et mengeꞌ mengrerampas. Limbasan dye ya et badyuꞌ sampay pinegpupukul dye ya, pegketbes tinirengan, singkeran dye tengaꞌ-tengaꞌ mene biyag ye. ");
INSERT INTO plw_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Sukud-sukud teyen timingkaꞌ maya sembatung pariꞌ pekekenapan gasi kenye dut ating dalan. Indyari nepayag ye ating lelaki, segwaꞌ kaya ne neglembus, nepelisang lang ye. ");
INSERT INTO plw_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Megdemikian maya gasi sembatung tawʼt Judio naꞌ Lebita na ketabang et mengeꞌ pariꞌ, pesusurung gasi dut dalan naꞌ atin. Pegkebiriꞌ ye et lelaki na atin, nepelisang gasi ya. ");
INSERT INTO plw_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Segwaꞌ maya sembatung tawʼt Samaria, taaw neng tumpang dut kenye, neng rinampas in. Na pesusurung gasi dut dalan naꞌ atin na duntin ating lelaki. Ganang nebiriꞌ ne ya et tawʼt Samaria, nekeingasiꞌ dut kenye. ");
INSERT INTO plw_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Indyari pinelembusan ye ampaꞌ ye ne binulungan mengeꞌ tawan ye, timbungan ye et lana sampay alak dut mengeꞌ tawan ye. Pegketbes pinesakat ye lelaki in dut kenyeng kukuraan, binibit ye dut sembatung benwa neng pegbeyaran supaya ipetimuru ye duntin. ");
INSERT INTO plw_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Pegdatek dirikleman nepeliwan et pirak (duwang denaryo), pegketbes tinundul ye dut Empuꞌ et benwa in. Indyari kwan ye dut kenye, ‘Timuruaꞌ ya et menunga. Na baꞌ kepeuliꞌ ku ne atue, beyaran ku rimu sebarang gastu mu bekeꞌ sensaraꞌ mu.’ ” ");
INSERT INTO plw_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Na, sinugid i Jesus dut biaksa in, kwan ye, “Dut pikir mu, sinu dut telung ketawan naꞌ atin na negpekilala na tantung melingew et sebayaꞌ ye, dut lelaki naꞌ pinukul et mengeꞌ mengrerampas in?” ");
INSERT INTO plw_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Indyari negberes ating biaksa dut Keseraan kwan ye, “Ating sembatu na nengingasiꞌ kenye in.” Indyari kwan i Jesus dut kenye, “Sigi, buwataꞌ samat kwantin.” ");
INSERT INTO plw_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Indyari si Jesus bekeꞌ mengeꞌ pepengenaran ye negleslembus panew dye. Sekaliꞌ pineretengan kedye dut sembatung benwa et duwang kelilibunan, ingaran dye si Marta bekeꞌ si Maria. ");
INSERT INTO plw_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Indyari ganang dun dye ne, si Maria kenye narung dut abiꞌ i Jesus supaya mengingeg et mengeꞌ tuturan ye. ");
INSERT INTO plw_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Segwaꞌ si Marta kenye pegsusa ne et pegperuri baꞌ enu ipelamak kire Jesus. Pegkaꞌ kaya ne nekesandal, nepekabiꞌ si Marta ki Jesus, kwan ye, “Menunulduꞌ, kaya lang be dut dimu atin na aku pesaran ne lang et tipused ku memeruri? Baꞌ mekedyari teyen isugiraꞌ kenye ne aku tebangan ye!” ");
INSERT INTO plw_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Siminambag dut kenye Begerar Jesus, kwan ye, “Marta, Marta, pegsusa bekeꞌ eriwaraꞌ ke ne banar dut mekansang neng ginis. ");
INSERT INTO plw_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Segwaꞌ seng ginis lang neng menunga keilangan. Ki Maria, kenye piniliꞌ ye atin menunga, na diki itue ugaren kenye.” ");
INSERT INTO plw_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Sembatung eldew si Jesus negpenalang dut Empuꞌ. Ganang neketbes ne, sembatung tindeg ye negsugid dut kenye kwan ye, “Menunulduꞌ, tulduiꞌ kay megpenelang dut Empuꞌ samat ki Juan tinulduan ye kenyeng mengeꞌ pepengenaran.” ");
INSERT INTO plw_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Kwan i Jesus dut kedye, “Baꞌ kemyu megpenelang, kwanaꞌ myu, ‘Amaꞌ tyu dut langit, bentugen ingaran Mu. Dumateng ne teyen pengmilikan Mu. ");
INSERT INTO plw_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Begeyiꞌ kay eldew-peldew et pegkaan. ");
INSERT INTO plw_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Empunaꞌ mengeꞌ keselaan kay sabab pegempunen kay sebarang negkesalaꞌ damen. Bekeꞌ kasiꞌ kay pesariꞌ na metuksuꞌ.’ ” ");
INSERT INTO plw_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Indyari bineres i Jesus gasi dut kedye, kwan ye, “Supama, sembatu dimyu maya biꞌbilaꞌ. Pegdatek tengaꞌ gebi, diminuntin kenye indyari negsugid, kwan ye, ‘Laꞌ, baꞌ mekedyari, teyen pelimbasiꞌ ku mena et telung susu naꞌ begas. ");
INSERT INTO plw_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Sabab maya biꞌbilaꞌ ku nanew dinetengan ye dut daken, na kaya mepekaan ku kenye.’ ");
INSERT INTO plw_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Siminambag gasi biꞌbilaꞌ ye na dut sisingled tiꞌ, kwan ye, ‘Kasiꞌ ku ne pegsesewaꞌ! Bekeꞌ lelengewan netengleb ne bekeꞌ iba mengeꞌ keyegangan ku memegigaꞌ ne. Na, diki ku ne mekedyari megbangun nega supaya begeyan ke.’ ");
INSERT INTO plw_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Isugid ku dimu,” kwan i Jesus, “misan mendiꞌ ne banar megbangun supaya megey et begas dut biꞌbilaꞌ ye, segwaꞌ, sabab et meleges banar, negbangun ne lang supaya mebgey kenyeng pegengaten. ");
INSERT INTO plw_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Angkansa isugid ku dimyu: Meneew kew supaya begeyan kew. Pengebiyaꞌ kew supaya kebiyaꞌ kew. Tumuktuk kew supaya lelengewan ukaban dimyu. ");
INSERT INTO plw_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Sabab sebarang pengangat ya, keterima; Sebarang pengebiyaꞌ, ya ketulus; sebarang megtuktuk, lelengewan ukaban kenye. ");
INSERT INTO plw_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Kaya amaꞌ baꞌ yegang ye megtew et seraꞌ, igbey ye seli? ");
INSERT INTO plw_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Etawa baꞌ mengangat et tilug, enu igbey ye, bengkenawa? ");
INSERT INTO plw_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Deuluꞌ kemyu na mereraat, sewd myu megey et menununga dut mengeꞌ keyegangan myu, kwanaꞌ mene gasi dimyung Amaꞌ dut langit, diki be ya kebgey et Menungang Nakem naꞌ Empuꞌ sebarang megpengangat kenye?” ");
INSERT INTO plw_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Sene in negpeliwan si Jesus eset taaw et sembatung umew neng mereraat neng diwata. Ganang nepeugad ye ne itue, ating lelaki na negumew, nekebres, indyari nemegliluꞌ kineldaman. ");
INSERT INTO plw_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Segwaꞌ mengeꞌ iba negberes, kwan dye, “Nekepeliwan et meraat sabab et ki Beelsebul, gay bersen ki Seytan, surutan et ginsaʼt mereraat neng diwata.” ");
INSERT INTO plw_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Mengeꞌ iba, siminulay ki Jesus, tinewan dye si Jesus pasal et tendaꞌ teyeg dut Langit. ");
INSERT INTO plw_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Segwaꞌ pegsesewren i Jesus baꞌ enu pegpipikiren dye, kwan ye dut kedye, “Misan embeng pengmilikan, baꞌ megbagiꞌbagiꞌ indyari etuanan diri nega, atin mebungkar, bekeꞌ dut sembatung benwa megbanta-banta dye, atin megeriwaraꞌ. ");
INSERT INTO plw_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Na baꞌ si Seytan megbagiꞌbagiꞌ bekeꞌ megbanta dye-megdye nega, enukwan sumandal pengmilikan ye? Pinegberes ku itue sabab pegtendesen myu na aku negpeliwan et mengeꞌ mereraat neng diwata sabab et ki Beelsebul. ");
INSERT INTO plw_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Tiban baꞌ megpeliwan kuʼt mengeꞌ meliwanen sebaban ki Beelsebul, pikir myu kinung kebesagan na meliwanen nepeugad et dimyung mengeꞌ mengingibut? Angkansa dimung mengeꞌ mengibut ne atin mengukum dimyu. ");
INSERT INTO plw_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Segwaꞌ baꞌ aku negpeliwan et mengeꞌ meliwanen in sabab et basag et Empuꞌ, angkan tiban pengmilikan et Empuꞌ atuꞌ net dimyu.” ");
INSERT INTO plw_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Na sembatung antangan sinugid i Jesus kedye, kwan ye, “Na baꞌ si Seytan megtutunggu dut kenyeng benwa mebasag, panyap et mengeꞌ gelaman, diki lang mepenu-penu mengeꞌ pengartaꞌ ye. ");
INSERT INTO plw_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Segwaꞌ baꞌ ating yegang et Empuꞌ neng lebing mebasag rumumpak ki Seytan, atin peꞌ ya meraag, pengisien ginsan mengeꞌ gelaman dut pinengendelan i Seytan sampay pegbenbegien ye sebarang mengeꞌ neisiꞌ ye.” ");
INSERT INTO plw_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Neres gasi kedye si Jesus sembatung antangan, kwan, ye, “Sebarang diki ku kekampi, kebanta ku. Bekeꞌ sebarang diki tumabang daken menimung et taaw dut Empuꞌ, dye keparak.” ");
INSERT INTO plw_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Baꞌ lumiwan sembatung dereakan i Seytan dut sembatung taaw, megsurung atin dut ketugan penulus et mepesngewan ye. Na baꞌ kaya mebiyanan ye, indyari sugiren ye samat kwantin, ‘Peuliꞌ ku gasi dut minewanan neng tinirengan ku tiꞌ.’ ");
INSERT INTO plw_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Pegdateng ye duun mebiriꞌ ye na metlang ne bekeꞌ megkikinunga ne ginsan dut seled et minewanan ye. ");
INSERT INTO plw_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Indyari ugaran ye atin pengsementaraꞌ segwaꞌ megpeiba gasi et pitu negang mengeꞌ dereakan i Seytan na lebing meburangit set kenye. Sumled dye bekeꞌ lumegdeng dye ne duntin. Indyari antangan et ating taaw lebing megkeraat banar, diki samat sene tiꞌ.” ");
INSERT INTO plw_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Sasat megbebres nega si Jesus et itueng ginis, maya sembatung libun teyeg dut tengaʼt kineldaman neres et mebasag, kwan ye, “Mesukud ating induꞌ na negyegang dimu sampay negperuruꞌ”. ");
INSERT INTO plw_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Siminambag si Jesus kwan ye, “Lebing mesukud sebarang megkingeg et beres et Empuꞌ Banar bekeꞌ penuman et atin.” ");
INSERT INTO plw_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ganang megkekedram ne mengeꞌ taaw, negberes si Jesus, kwan ye, “Mengeꞌ mereraat itueng mengeꞌ pengkatan. Megteew dyeʼt mengeꞌ keliluꞌlilung tendaꞌ, segwaꞌ kaya lang mebgey kedye selyu lang, tendaꞌ pasal ki Jonas atin tarus et Empuꞌ Banar tagnaꞌ. ");
INSERT INTO plw_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Sabab baꞌ enukwan tagnaꞌ tiꞌ si Jonas pineketendaꞌ dut mengeꞌ tawʼt Ninibe, megdemikian Yegang et Taaw sembatung tendaꞌ gasi dut itueng pengkatan. ");
INSERT INTO plw_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Pegdateng dut ukuman et Empuꞌ, tumyeg Dengdayang et Selatan, bekeꞌ sumagkaꞌ ne itueng pengkatan. Sabab ya mawaꞌ nega dut kepuspusaʼt dunyaꞌ supaya mengingeg et kesesewran i Surutan Solomon tagnaꞌ. Segwaꞌ tiban maya sembatung lebing metaas dut ki Surutan Solomon, na tiban atue e. ");
INSERT INTO plw_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Mengeꞌ taaw dut Ninibe tagnaꞌ tumyeg ngine dut ukuman et Empuꞌ. Sabab mengeꞌ tawʼt lungsud et Ninibe nemegsusun dut abar i Jonas, atin Tarus et Empuꞌ tagnaꞌ. Angkansa dye sumagkaꞌ itueng pengkatan. Segwaꞌ maya sembatung lebing metaas nega dut ki Jonas na tiban atue e!” ");
INSERT INTO plw_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Kaya sinu megsiluꞌ et saleng, pegketbes iratun ye dut keteguan. Segwaꞌ pegdatun ye atin dut semberikaran, supaya sebarang kesled kebiriꞌ et telang ye. ");
INSERT INTO plw_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Supama, mata myu, atin siluꞌ et bilug myu. Na baꞌ mata myu menunga, metlang ginsaʼt bilug myu, ingin bersen menunga pikiran myu. Segwaꞌ baꞌ mekabu mata myu, melingeb gasi ginsaʼt bilug myu, ingin bersen meraat pikiren myu. ");
INSERT INTO plw_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Na tentuaꞌ myu banar ating telang dut dimyu na diki lang megmendyaring kelingban. ");
INSERT INTO plw_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Angkansa, baꞌ ginsaʼt bilug mu meketlangan, kaya lang bagiꞌ et kelingban, epus metlang ginsan, sama ke et megbibinyar naꞌ siluꞌ.” ");
INSERT INTO plw_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ganang netimpus ne i Jesus bebresen ye, maya sembatung pariꞌ naꞌ Pariseo nengdangin kenye mengaan dut kedye. Angkansa si Jesus siminurung, pegseled ye, lahyun narung bekeꞌ nampang dut kekanan. ");
INSERT INTO plw_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Segwaꞌ negliluꞌ itueng Pariseo, sabab pegkebiriꞌ ye ki Jesus kaya lang nemasaꞌ et keremut ye mura mengaan samat inarat dye. ");
INSERT INTO plw_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Indyari kwan et Begerar dut kenye, “Kemyung mengeꞌ Pariseo, samat mengeꞌ sawan bekeꞌ rayaꞌ pegbesaan liwan lang, temed dut seled myu baha et deren bekeꞌ kereatan. ");
INSERT INTO plw_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Kemyung mengeꞌ merupang naꞌ taaw! Diki be ating pemuwat et liwan et bilug, atin gasi pemuwat et seled? ");
INSERT INTO plw_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Segwaꞌ ipemegiaꞌ myu dut mengeꞌ miskin sebarang baꞌ enu dut seled et rayaꞌ, indyari ginsan neng ginis megmendyaring melnis dut dimyu.” ");
INSERT INTO plw_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Elulaꞌ kew ne kemyung mengeꞌ Pariseo, sabab megbegey kew et ikesempulung bagiꞌ et perinaꞌ sampay ginsaʼt mengeꞌ tutulnuen dut Empuꞌ. Segwaꞌ peglipatan myu keingesinan dut mengeꞌ taaw miskin bekeꞌ kurung kemyung pengmergaꞌ et Empuꞌ. Sugat na buwaten myu ating begeyan ikesempuluꞌ et ginsan dut Empuꞌ neng pinegarat, segwaꞌ kasiꞌ myu gasi peglipatiꞌ keingasinen dut taaw miskin bekeꞌ pegmerganen Empuꞌ. Itueng bagung tulduꞌ. ");
INSERT INTO plw_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Elulaꞌ kew ne kemyung mengeꞌ Pariseo, sabab gey-gaay myu banar marung dut eerungan et mengeꞌ metetaas dut pegtimung-timungan bekeꞌ mengeꞌ kepangling-pangling et mengeꞌ taaw dut tetebuan. ");
INSERT INTO plw_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Sengsayang myu ne sabab patus myu mengeꞌ lebeng na kaya mengeꞌ tendaꞌ na mekelbutan et mengeꞌ taaw na diki dye mekesewran. Angkansa meririꞌ dye ne et Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Maya sembatung biaksa dut Keseraan kwan ye, “Menunulduꞌ, pegbersen mu atin, samat pepelelew mu gasi kami a.” ");
INSERT INTO plw_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Siminambag si Jesus kwan ye, “Kemyu gasing mengeꞌ biaksa dut Keseraan, elulaꞌ myu ne, sabab pegbebgeyan myu mengeꞌ taaw et mengeꞌ saraꞌ bekeꞌ simayaꞌ. Misan meliyutan dye tumanen dye, segwaꞌ kemyu misan sengkerit neng ginis mendiꞌ kew menabang. ");
INSERT INTO plw_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Elulaꞌ myu ne sabab pinebalan myu mengeꞌ lebeng mengeꞌ tarus et Empuꞌ, na dye pinematey et mengeꞌ keupuꞌupuan myu. ");
INSERT INTO plw_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Angkansa kemyu tiban negpesebanar na negpekiuyun kew pasal dut baꞌ enu pinemuwat et mengeꞌ keupuꞌupuan myu. Dye nematey et mengeꞌ tarus et Empuꞌ, bekeꞌ dimyu gasi, kemyu negpebaal et mengeꞌ lebeng et mengeꞌ tarus. ");
INSERT INTO plw_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Sabab et itue, Empuꞌ dut kenyeng kesesewran negsugid et samat kwantin, kwan ye, ‘Pebitan ku dye et mengeꞌ tarus sampay mengeꞌ pepengenaran, segwaꞌ mekeldam kedye pengimeteyen, iba in tiksaen dye.’ ");
INSERT INTO plw_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Angkansa itueng pengkatan maya dusaen kedye, sabab et keselaan keupuꞌupuan dye tagnaꞌ neng pegimatey dyeʼt ginsaʼt mengeꞌ tarus et Empuꞌ tihad negaʼt pegtagnaꞌ et sengkedunyaan, ");
INSERT INTO plw_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Tihad nega pegpatey dut ki Abel seked dut pegpatey ki Sakarias, na bininasa dut pinegketngaan et sisimeyaan bekeꞌ benwa naꞌ pegempuan. Eꞌ, isugid ku dut dimyu, itueng mengeꞌ pengkatan, dye sukuten kedye ngine ginsaʼt itue. ");
INSERT INTO plw_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Elulaꞌ myu ne kemyung biaksa et Keseraan, sabab inugad myu kunsiꞌ et kesesewran, atin kesesewran pasal dalan surung dut Langit. Asal kemyu kaya ne memegseled, sampay sebarang meingin sumled pegleangen myu.” ");
INSERT INTO plw_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Pegketbes nugad ne si Jesus dut lelegdengan naꞌ atin. Sentin ne tinegnaan et mengeꞌ Pariseo bekeꞌ mengeꞌ biaksa et Keseraan na rinaat dye ne banar. Angkan mekansang neng pinegiingkut dye, ");
INSERT INTO plw_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","supaya lang maya malew dye pasal dut kenyeng mengeꞌ bebresen. ");
INSERT INTO plw_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ganang memegderateng mengeꞌ ribu-ribung mengeꞌ taaw angkan sengketaawan memekelbut net mengeꞌ sebayaꞌ dye, negberes mena si Jesus dut mengeꞌ pepengenaran ye kwan ye, “Na, meginget-inget kew dut pikembang et mengeꞌ Pariseo, ingin bersen kenyeng mepupulitika bekeꞌ mekekesewd. ");
INSERT INTO plw_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Sabab kaya lang mengeꞌ pegtetekpan na diki metikwasan, bekeꞌ kaya lang mengeꞌ pegtetaguꞌ na diki mesewran. ");
INSERT INTO plw_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Baꞌ enu ipegberes myu dut kelingban, atin mekingeg pegdatek eldew. Na baꞌ enu kinines myu dut telinga, atin ibensag dut ginsaʼt taaw.” ");
INSERT INTO plw_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Sugiran ku kemyu mengeꞌ biꞌbilaꞌ, kasiꞌ myu pegtekutiꞌ sebarang mekepatey et bilug lang bekeꞌ pegketbes kaya ne mebutbuwat ye. ");
INSERT INTO plw_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Segwaꞌ ipebiriꞌ ku rimyu baꞌ sinu banar tekutan myu: Tekutiꞌ myu Empuꞌ Banar, sabab pegketbes mepatey ye bilug, maya gasi basag ye na menimbag dimyu dut Narkaꞌ. Eꞌ, sugiran ku kemyu, tekutiꞌ myu Empuꞌ dut Langit. ");
INSERT INTO plw_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Diki be limang mengeꞌ dignes pepelen et duwang siin? Segwaꞌ kaya misan sembatu kedye mekelipatan dut elepan et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Angkansa kas kewʼt takut, sabab lebing mergaꞌ kew dut mengeꞌ dignes. Deuluꞌ misan buek et ulu myu, ginsan mekeitung ye.” ");
INSERT INTO plw_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Isugid ku dimyu, sebarang pengilala daken dut elepaʼt mengeꞌ taaw, megdemikian atin Yegang et Taaw mengilala gasi dimyu dut elepaʼt mengeꞌ dereakan et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Segwaꞌ baꞌ sinu megmendiꞌ daken dut elepaʼt mengeꞌ taaw, megdemikian mendinan ku gasi ya dut elepaʼt mengeꞌ dereakan et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Bekeꞌ, sebarang megberes et sagkaꞌ dut Yegang et Taaw, maapen nega. Segwaꞌ baꞌ sinu meres et meraat pasal Menungang Nakem naꞌ Empuꞌ, misan ingyan diki ne empunen. ");
INSERT INTO plw_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","‘Na baꞌ bibiten kew apang periksanen dut elepan et pegtimung-timungan et mengeꞌ pegibuten, bekeꞌ mengeꞌ kepulisan, kas kewʼt pegsusa baꞌ enukwan itubag myu etawa baꞌ enu ibres myu. ");
INSERT INTO plw_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Sabab Menungang Nakem naꞌ Empuꞌ, menulduꞌ dimyu baꞌ enu ipegberes myu dut atin neng lisag.’ ” ");
INSERT INTO plw_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Maya sembatu dut kineldaman negsugid ki Jesus, kwan ye, “Menunulduꞌ, sugiriꞌ tipused ku pasal et pengartaꞌ kay na beginan ye ne aku.” ");
INSERT INTO plw_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Siminambag si Jesus kwan ye, “Lelaki, sinu nenggerar daken na mendyaring ukum etawa memagiꞌ dimyu?” ");
INSERT INTO plw_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Indyari negberes dut mengeꞌ taaw, kwan ye, “Meginget-inget kew, etuaniꞌ myu ginsaʼt dagbes et rurundingan, sabab biyag et taaw kaya dut kesenangan et pemimiyag ye.” ");
INSERT INTO plw_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Pegketbes sinugid itueng beleybey kwan ye, “Uma et sembatung mentiriꞌ nuaꞌ et menunga. ");
INSERT INTO plw_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Indyari nepikir ye, kwanaꞌ ye ne in, ‘Enu ne buwaten ku? Sabab baha ne sisingled et legkew ku supaya puguan kuʼt mengeꞌ parey ku.’ ");
INSERT INTO plw_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Indyari kwan ye, ‘A, sewd ku ne baꞌ enu buwaten ku. Iperungkat ku ne legkew ku, pegketbes megpetiyeg ku et kelaꞌ banar, indyari duntin ku ne puguan ginsaʼt mengeꞌ parey sampay mengeꞌ pengartaꞌ ku.’ ");
INSERT INTO plw_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Indyari sinugid ye nega, kwan, ‘Mekansang ne menunungang ginis neng pinemugu ku in, misan senu negang teun. Megpelahay-lahay ku mene, mengaan, menginum bekeꞌ meglami-lami.’ ");
INSERT INTO plw_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Segwaꞌ Empuꞌ megsugid kenye, ‘Ikew naꞌ merupang. Itueng gebi biyag mu isien ku ne dut dimu. Na, sinu ne tiban megkemudalan et mengeꞌ ginsaʼt pinemanyap mu in?’ ” ");
INSERT INTO plw_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Itue tinutup i Jesus, kwan ye, “Kwantin meinabu dut sebarang pemenimung et pemulawan dut diri dye, segwaꞌ kaya lang dut deklaʼt mentiriꞌ ye na pegsiyekan et Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Indyari negberes si Jesus dut mengeꞌ pepengenaran ye kwan ye, “Angkansa sugiran ku kemyu, kas kewʼt pegsusa pasal et dimyung biyag, baꞌ enu kanen myu, etawa pasal et bilug myu, baꞌ enu bedyuen myu. ");
INSERT INTO plw_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Biyag lebi nega dut pegkaan, bekeꞌ bilug lebi nega dut mengeꞌ pegbadyuꞌ. ");
INSERT INTO plw_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Atin lang pemintangiꞌ myu, mengeꞌ uwak in; dye in kaya lang pemenasad etawa pemengeyg, bekeꞌ kaya lang kuren dye etawa legkew, segwaꞌ pemegumpenan dye et Empuꞌ. Kwanaꞌ mene kemyu lebing mergaꞌ dut Empuꞌ eset mengeꞌ begit. ");
INSERT INTO plw_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Sinu dimyu na baꞌ megsusa mekedyaring mekedugang et misan seng lisag dut biyag ye? ");
INSERT INTO plw_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Na baꞌ misan isek-isek neng ginis diki myu mebuwat, manu pegsusaan myu pasal et ibang ginis? ");
INSERT INTO plw_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Atin lang pemintangiꞌ myu baꞌ enukwan megdeklaꞌ mengeꞌ belugbug in. Kaya lang atin pemegsensaraꞌ etawa pemenahiꞌ. Segwaꞌ sugiran ku kemyu, misan si Surutan Solomon, ya in metaas ne, segwaꞌ kaya lang nekepakay samat burak naꞌ itue e. ");
INSERT INTO plw_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Na baꞌ enukwan pegpekayan et Empuꞌ mengeꞌ peperasen dut mengeꞌ tinimbasan, na tiban atue nega, pegdatek diklem tutungen ne dut apuy. Kwanaꞌ mene kemyu, diki ye pepekayan? U, mengeꞌ taaw na kaya kelaꞌ pegandel! ");
INSERT INTO plw_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Baꞌ kelaʼt atey myu ne pegkaan etawa inumen, endey lang, kasiꞌ myu pegsusaiꞌ baꞌ pasal lang et atin. ");
INSERT INTO plw_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Sabab itueng pinengkataʼt pegngeranen naꞌ taaw ating ginis pegsenseraan dye. Segwaꞌ pegsesewren nega et Amaꞌ myu na keilangan myu atin! ");
INSERT INTO plw_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Segwaꞌ tulusaꞌ myu mena pengmilikan et Amaꞌ Empuꞌ Banar, indyari itueng ginis pegtulusen myu ibgey nega et Empuꞌ dimyu.” ");
INSERT INTO plw_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Kas kewʼt takut, kemyung pepengenaran ku misan sesenu kew lang neng banan, sabab negeayan et Empuꞌ Amaꞌ na ibgey ye dimyu pegbegbeg dut kenyeng pengmilikan. ");
INSERT INTO plw_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ipegelnaꞌ myu mengeꞌ pusakaꞌ myu, indyari ipenabang myu dut mengeꞌ miskin. Baꞌ buwaten myu itue, samat kepulus kew pegsunuꞌ et sutsuput na diki meuley, kementirian myu ne dut Langit na kaya titimpusan. Na dun kaya lang menenakew bekeꞌ kaya aney na mengetket. ");
INSERT INTO plw_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Sabab baꞌ embe mentiriꞌ myu, dun gasi mibut atey myu.” ");
INSERT INTO plw_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Pegketbes, sinugid i Jesus, kwan ye, “Daran penyapen myu dut ulian ku, samat kemyung uripen, megpakay kew et teup naꞌ pinekayan mepengnaꞌ megkeradya, bekeꞌ daran myu ipedleg siluꞌ myu. ");
INSERT INTO plw_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Samat mengeꞌ taaw na megtetagey et kedyeng begerar, baꞌ ingyan ipeuliꞌ ye teyeg dut bulun, supaya baꞌ meguliꞌ ne bekeꞌ ya sumegina ne, megtuy dye lang ya meukaban et tengleb. ");
INSERT INTO plw_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Mesukud sebarang mengeꞌ uripen baꞌ medetnganan et begerar dye na dye megbebtiꞌ. Erapun kwantin pelan isugid ku dimyu, peimeranan begerar in diri ye supaya megpelamak dut kenyeng uripen sampay ipearung ye dye dut kekanan sasat kenye megtetagey supaya sumukuꞌ dut mengeꞌ uripen esentin. ");
INSERT INTO plw_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Mesukud sebarang mengeꞌ uripen na mebiriꞌ et begerar, na dye panyap misan ya dumateng et tengaꞌ gebi etawa kelang kueldew. ");
INSERT INTO plw_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Segwaꞌ retiaꞌ myu itue: baꞌ empuʼt benwa sewd ye baꞌ ingyan dateng et menenakew, diki ye pesaran benwa ye mesled. ");
INSERT INTO plw_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Megdemikian dimyu, keilangan megpanyap kew, sabab taka-taka, aku, atin Yegang et Taaw, dumateng ne kaya pegsesewren myu baꞌ eteg lisag irateng ku.” ");
INSERT INTO plw_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Si Pedro nengingkut kwan ye, “Begerar, pegsugiren mu itueng beleybey dut damen lang, etawa dut ginsan?” ");
INSERT INTO plw_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Bineleybey i Jesus sambag ye kenye, kwan ye, “Baꞌ supama maya sembatung begerar sumurung dut ibang lungsud. Sinu ating metignaꞌ bekeꞌ mependey pengendelan et begerar, atin kumpet et ibang uripen supaya memagiꞌ kedye et mengeꞌ kekanen peldew-peldew. ");
INSERT INTO plw_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Mesukud ating nepengendelan na ya mebiriꞌ et begerar dut pegpeuliꞌ ye pegbuwaten ye sebarang pinesukuꞌ kenye in. ");
INSERT INTO plw_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Sugiran ku kemyu et keberbenaran, megmendyaring ipengandel ne kenye ginsaʼt pengartaꞌ ye. ");
INSERT INTO plw_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Segwaꞌ baꞌ sugiren et uripen kwanen ye, ‘Mekwit-kwit nega peuliꞌ begerar.’ Angkansa tegnaan ye ne pemukulen iba yeng mengeꞌ uripen pelibun pelelaki, sampay eluen ye mengaan lang, bekeꞌ menginum seked lenguan. ");
INSERT INTO plw_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Pegdateng et eldew keuliꞌ ne begerar ye, segwaꞌ diki ya mebtinan ye bekeꞌ mawam baꞌ eteg lisag irateng ye. Pegkaꞌ kwantin meretnganan et Empuꞌ, binesanen ye uripen in sampay iratun ye ya dut mengeꞌ lelegdengan et mengeꞌ taaw neng kaya mengandel. ");
INSERT INTO plw_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Sabab ating uripen na kaya awam dut kegeayan et kenyeng begerar, segwaꞌ diki negpanyap etawa kaya pegbuwaten ye baꞌ enu gaay et begerar ye, keterima ya et mekeldam na lipak. ");
INSERT INTO plw_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Segwaꞌ sebarang awam, segwaꞌ megpemuwat et mengeꞌ bubuwaten na mekedyaring mekedusa, keterima gasi et pireng mengeꞌ lipak. Naꞌ, baꞌ sinu-sinu nepesukuan et kelaꞌ, kelaꞌ gasi tulusen kenye. Bekeꞌ dut pinepengendelan et kelaꞌ banar, kelaꞌ banar gasi tulusen kenye.” ");
INSERT INTO plw_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Natuꞌ ku supaya mibit et apuy atuʼt dunyaꞌ, bekeꞌ nepedlegan ne teyen itue e! ");
INSERT INTO plw_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Segwaꞌ maya nega ketiksaan terimanen ku, atin nega pegrerasan ku seked ingga peꞌ meketuman itue daken. ");
INSERT INTO plw_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Pikir myu natuꞌ ku be supaya mibit et kesenangan atuʼt dunya? ‘Diki! Segwaꞌ, pegbagiꞌbagiꞌ. Atin isugid ku banar dimyu. ");
INSERT INTO plw_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Aku tihad tiban sebaban maya lima angkansa dut sengbenwa na megkampi-kampi dye, telung ketawan mengandel daken atu dut duwa, antangan diki duwa atu dut telu. ");
INSERT INTO plw_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Memeggatu-atu dye, amaꞌ atu dut yegang naꞌ lelaki, yegang naꞌ lelaki atu dut amaꞌ, induꞌ atu dut yegang naꞌ libun, yegang naꞌ libun atu dut induꞌ pengibanan naꞌ libun atu dut menempil naꞌ libun, bekeꞌ menempil naꞌ libun atu dut pengibanan naꞌ libun itueng ginisan aku sebaban.’ ” ");
INSERT INTO plw_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Sinugid i Jesus dut kineldaman kwan ye, “Atuʼt bangsa tyu, baꞌ mebiriꞌ myu kunem periribuwat mawaꞌ dut sedpan, isugid myu megtuy kwan myu, ‘Sibantuꞌ dumlek,’ asal atin meketuman. ");
INSERT INTO plw_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Na baꞌ dumres gasi selatan, sugiren myu, ‘Sibantuꞌ minit,’ asal meginit. ");
INSERT INTO plw_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Mengeꞌ pebiꞌbiriꞌ! Sewd myu mengilala et periama et lugtaꞌ bekeꞌ lelengew, segwaꞌ manu diki myu mesewran mengilala et tiban neng penewnan, baꞌ enu meinabu?” ");
INSERT INTO plw_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Manu diki myu meukum dut diri myu baꞌ enu metignaꞌ? ");
INSERT INTO plw_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Baꞌ maya menindal et bebentanan dut mengeꞌ ukum, dut dalan nega sulayiꞌ myu ne na kemyu megsulut-sulut. Baꞌ diki myu buwaten samat kwantin, kaluꞌ reyaken kew dut elepaʼt ukuman. Indyari ibgey keʼt ukum dut pulis, naꞌ seked ikew pirisuen ye. ");
INSERT INTO plw_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Isugid ku dimyu, diki kew ipeliwan seked myu mebeyaran ginsan multa myu, sampay diki ne kurangan misan sembatu siin.” ");
INSERT INTO plw_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ating masa, maya senung mengeꞌ taaw sentin negsugid ki Jesus pasal et pineimatey et senung taaw dut tawʼt Galilea i Gobernador Pilato, na kedyeng duguꞌ nekelamud dut duguꞌ et sisimeyaan dye. ");
INSERT INTO plw_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Sinugid i Jesus kwan ye, “Pengirakira myu itueng mengeꞌ tawʼt Galilea lebing mekeselaan dut ibang mengeꞌ tawʼt lungsud et Galilea sabab et pineliyutan dye samat kwantin? ");
INSERT INTO plw_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Isugid ku dimyu, ‘Diki!’ Megdemikian dimyu mebinasa kew ginsan nega, selyu lang baꞌ ginsan kew megsusun. ");
INSERT INTO plw_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Etawa samat sempuluꞌ walung ketawan neng natey in sabab neugbaan et melangkew ne benwa dut lungsud et Siloe, pikir myu dye in lebing mesungal dut ibang mengeꞌ taaw naꞌ meglelegdeng dut lungsud et Jerusalem? ");
INSERT INTO plw_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Isugid ku dimyu, ‘Diki!’ Megdemikian kemyu ginsan metiksaꞌ gasi, selyu lang baꞌ megsusun kew et ginsaʼt salaꞌ myu.” ");
INSERT INTO plw_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Pegketbes sinugid i Jesus gasi itueng beleybey, kwan ye, “Maya sembatung taaw na maya sembatu puun et igus peluluwak dut luluwakan ye. Sinurungan ye supaya birinen baꞌ maya ne buaꞌ. Segwaꞌ kaya lang nebiyanan ye, misan sembatu. ");
INSERT INTO plw_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Angkansa sinugiran ye sembatung lelaki neng megtutunggu dut luluwakan naꞌ atin kwan ye, ‘Maya ne telung teun ne pepeuliꞌpeuliꞌ ku supaya memiriꞌ lang et buaꞌ et igus naꞌ itue, segwaꞌ kaya lang misan sembatu buaꞌ ye. Tebngaꞌ ne lang! Sabab keternung lang dut ibang luluwaken.’ ");
INSERT INTO plw_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Sambag et lelaki, ‘Begerar, pesariꞌ lang mena sentin seked seng teun sulayan ku kelian pelibut ye pegketbes burburan ku et pitabaꞌ ye. ");
INSERT INTO plw_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Na baꞌ muaꞌ, menunga! Segwaꞌ baꞌ diki, atin peꞌ ipetbeng ne lang.’ ” ");
INSERT INTO plw_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sembatung Sabadu, atin Eldew et Kepeternan, si Jesus negtulduꞌ dut sembatung pengempuan naꞌ benwa et mengeꞌ tawʼt Judio. ");
INSERT INTO plw_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Negtekaꞌ, maya sembatung libun sentin na maya ne sempuluꞌ walung teun ne sakit ye sabab et mereraat naꞌ meraat na taaw. Kaya ne meketignaꞌ, aluꞌ ye pekekeyutung lang. ");
INSERT INTO plw_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ganang nebiriꞌ i Jesus ya, tiningkag ye na pekabiꞌ dut unaan, kwan ye, “Libun, nepenunga ke ne et reresanen mu.” ");
INSERT INTO plw_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Dimpen i Jesus elima ye dut libun, indyari megtuy nekeunat ne ya. Pegketbes negbantug ne ya dut Empuꞌ Banar dut Langit. ");
INSERT INTO plw_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Segwaꞌ nemengiseg pepengendelan et pengempuan naꞌ benwa et mengeꞌ tawʼt Judio, kwan ye, “Maya enem neng eldew supaya megkeradya.” Indyari kwan ye gasi dut mengeꞌ taaw, “Teyen dut mengeꞌ eldew na atin, kemyu matuꞌ supaya mepenunga kew, diki lang dut Eldewʼt Kepeternan.” ");
INSERT INTO plw_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Sinugid i Jesus kenye, kwan ye, “Kemyu mengeꞌ pebiꞌbiriꞌ! Diki be pegbebaran sinu-sinu dimyu dut kukurungan dimyung kesepian etawa kekuraan misan Eldewʼt Kepeternan, bekeꞌ pepeliwan myu supaya mepeinum? ");
INSERT INTO plw_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Itueng libun naꞌ itue teyeg dut tutusan i Abraham, keilangan na mekulpasan misan ne Eldew et Kepeternan, sabab sempuluꞌ walung teun ne pegsisigtan i Seytan.” ");
INSERT INTO plw_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Nemeglelew mengeꞌ ginsaʼt kesagkaꞌ ye, sabab et ating bebresen i Jesus. Segwaꞌ mengeꞌ ibang taaw neksanan ginsan sabab et atin neng keliluꞌlilung binwat i Jesus. ");
INSERT INTO plw_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Indyari nengingkut si Jesus, kwan ye, “Enukwan ipatus pengmilikan et Empuꞌ? Enu atin peselian ku? ");
INSERT INTO plw_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Itue pelan pesemanan ku. Saliꞌ ye samat sembatung elinseg et mustasa, na insiꞌ et sembatung taaw ampaꞌ ye ne linuwak dut luluwakan ye. Dimineklaꞌ negmendyaring sembatung puuʼt kayu, pegketbes mengeꞌ kebegitan et lelengew nememugad dut mengeꞌ sanga ye.” ");
INSERT INTO plw_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Indyari nengingkut gasi peuliꞌ kwan ye, “Enu gasi pepetusan ku pengmilikan et Empuꞌ? ");
INSERT INTO plw_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Patus ye samat pikembang na insiꞌ et sembatung libun, pegketbes linimbug ye dut kelang timpung na begas seked nepekembang ye itue ginsan.” ");
INSERT INTO plw_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Indyari siminurung si Jesus dut mengeꞌ lungsud bekeꞌ dut mengeꞌ kebenbenwanan na megtutulduꞌ sasat ya pelelembus dut lungsud et Jerusalem. ");
INSERT INTO plw_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Maya sembatu nengingkut kenye, kwan ye, “Menunulduꞌ, meraliꞌ mengeꞌ senu lang be neng mengeꞌ taaw mebawiꞌ?” ");
INSERT INTO plw_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Indyari kwan i Jesus dut kedye, “Pengmilikan et Empuꞌ samat mepiet neng lelengewan na benwa. Legesaꞌ myu banar na mekesled dut mesigpit naꞌ lelengewan, sabab sugiran ku kemyu, mekansang sumulay sumled segwaꞌ diki lang kesled. ");
INSERT INTO plw_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Na baꞌ tinengleb ne et Empuʼt benwa lelengewan, kemyu tumyeg mene dut liwan bekeꞌ megtutuktuk, sampay megtitingkag. Kwanen myu, ‘Empuꞌ, ukabiꞌ damen lelengewan.’ Segwaꞌ kwanen ye, ‘Kaya kilala ku kemyu etawa baꞌ embe mawaꞌ myu.’ ");
INSERT INTO plw_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Indyari sumambag kew, ‘Siminaru kay dimu, nengaan bekeꞌ nenginum bekeꞌ nekeuna tiꞌ ikew negtulduꞌ dut lungsud kay.’ ");
INSERT INTO plw_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Segwaꞌ empuʼt benwa megsugid kedye kwan ye, ‘Kaya kilala ku kemyu, bekeꞌ baꞌ embe teyeg myu. Angkansa perayuꞌ kew daken kemyu ginsan, neng mengeꞌ mememaal et mereraat.’ ");
INSERT INTO plw_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Indyari eluen myu siyak bekeꞌ deringet-nget et nipen myu sabab baꞌ mebiriꞌ myu de Abraham, Isaak, bekeꞌ si Jakob, bekeꞌ ginsaʼt mengeꞌ tarus et Empuꞌ na dut pengmilikan et Empuꞌ, segwaꞌ dimyu dyeganan kew diki liwan kesled lang! ");
INSERT INTO plw_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Dumateng mengeꞌ taaw teyeg dut sebangan bekeꞌ sedpan, iragaꞌ bekeꞌ dut selatan, na lumuruk dut kelang kenkaan dut pengmilikan et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Tantu banar maya ne tiban mengeꞌ taaw emuri, temed duntin mekeuna dye ne. Bekeꞌ maya gasi mengeꞌ taaw nekeuna tiban, temed mekeemuri dye ne duntin.” ");
INSERT INTO plw_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ating masa maya mengeꞌ senung pariꞌ na Pariseo siminurung ki Jesus, kwan dye, “Tirengiꞌ ne itueng lungsud bekeꞌ sumurung ke ne lang dut misan embe, sabab gaay i Gobernador Herodes na imeteyen ke.” ");
INSERT INTO plw_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Indyari, siminambag si Jesus, kwan ye, “Ireꞌ sugiriꞌ ating merunding, kwanaꞌ kenye, ‘Megpeliwan kuʼt mengeꞌ meliwanen bekeꞌ megpenunga et mengeꞌ taaw. Sibantuꞌ diklem bekeꞌ keduwanan mura ku metbesan keradya ku.’ ");
INSERT INTO plw_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Misan enu nega meinabu, keilangan na mepelembus ku panew ku tiban, diklem, sampay keduwanan, sabab asal, kaya lang tarus et Empuꞌ na matey liwan et lungsud et Jerusalem! ");
INSERT INTO plw_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“U, tawʼt lungsud et Jerusalem, kemyu nematey et mengeꞌ tarus et Empuꞌ, bekeꞌ nemakal et batu dut mengeꞌ dinaak surung dimu apang imeteyen. Daran ku ne teyen pegtimungen ginsan dimung taaw, samat pegtimung et sembatung upa dut kenyeng mengeꞌ duruy dut kenyeng mengeꞌ elad, segwaꞌ mendiꞌ kew. ");
INSERT INTO plw_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Birinaꞌ lang, binwat et Empuꞌ metirengan atin mengeꞌ benwa myu na kaya ne sunuꞌ. Sugiran ku kemyu, na diki myu ne aku mebiriꞌ peuliꞌ seked mebres myu, kwanen myu, ‘Bentugen ya na matuꞌ sabab et ingaran et Empuꞌ Banar.’ ” ");
INSERT INTO plw_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sembatung Eldew et Kepeternan ganang pengaan si Jesus dut benwa et sembatung pegkilelanen naꞌ Pariseo, sinipian banar et mengeꞌ Pariseo si Jesus. ");
INSERT INTO plw_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Dut teteyumanan ye maya sembatung lelaki na pegtiksaen et sakit ye neng pemantat. ");
INSERT INTO plw_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Iningkut i Jesus mengeꞌ Pariseo bekeꞌ ating mengeꞌ biaksa dut Keseraan i Moises, kwan ye dut kedye, “Sungsang takuꞌ dut Keseraan baꞌ megpenunga dut Eldew et Kepeternan, etawa diki?” ");
INSERT INTO plw_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Segwaꞌ kaya nemekegibek dye. Indyari kimpetan i Jesus lelaki in ampaꞌ ye ne pinegulinan pegketbes pineugad. ");
INSERT INTO plw_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Pegketbes iningkut i Jesus dye, kwan ye, “Baꞌ maya sembatung yegang myu etawa sembatung sapiꞌ na negdag dut tebud dut Eldew et Kepeternan, diki myu ya betunen megtuy?” ");
INSERT INTO plw_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Segwaꞌ misan legtik kaya lang nemekesambag. ");
INSERT INTO plw_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Nepangling i Jesus na pegpilinen et mengeꞌ mengluluruk sebarang eerungan et mengeꞌ metetaas. Angkansa binulili i Jesus, kwan ye dut kenyeng beleybey. ");
INSERT INTO plw_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Baꞌ maya mengdangin dimyu dut sembatung pegkenkaan dut eldew et bulun, kas kewʼt arung dut eerungan et mengeꞌ metetaas, kaluꞌ maya dinangin dye na lebing kilala dut dimyu. ");
INSERT INTO plw_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Indyari pekebiyan kew et nengdangin in pegketbes sugiran kew et kwantin, kwanen ye, ‘Igbeyaꞌ erungan myu dut taaw naꞌ itue.’ Indyari meglelew kew, bekeꞌ melegesan kew na marung dut eerungan et mengeꞌ sirsimpir lang tiꞌ. ");
INSERT INTO plw_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Segwaꞌ baꞌ kemyu denginen, atin pilinaꞌ myu sebarang eerungan et mengeꞌ simpir in, indyari pegdateng et nengdangin in, kwanen ye dut dimyu, ‘Bilaꞌ, aniꞌ arungiꞌ myu, menunga-nungang eerungan iꞌ.’ Sabab et atin mepetaas kew dut elepaʼt mengeꞌ ibang mengluluruk. ");
INSERT INTO plw_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Sabab baꞌ sinu meingin ipetaas ye diri ye, ya in mepebaba. Bekeꞌ sebarang pepebaba ye diri ye, ya in mepetaas.” ");
INSERT INTO plw_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Indyari sinugiran gasi i Jesus ating pengdangin in, kwan ye, “Baꞌ ikew negpanyap et penengaldew etawa pengmapun, kasiꞌ pegdenginaꞌ sebarang bilaꞌ mu, dimung mengeꞌ ketipusdan etawa mengeꞌ kekempungan etawa mengeꞌ mentiriꞌ neng mengeꞌ rurungan mu. Na baꞌ kwantin buwaten mu, peuliꞌ tiꞌ ikew gasi denginen dye, angkansa dye nekeganti ne rimu. ");
INSERT INTO plw_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Segwaꞌ baꞌ maya pinanyap mu kelang kenkaan, atin denginaꞌ sebarang miskin, mengeꞌ pangkul, mengeꞌ piley bekeꞌ mengeꞌ beleg. ");
INSERT INTO plw_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Indyari ikew pesukuran, misan diki dye keganti rimu, temed ikew maya gantiꞌ et Empuꞌ dimu dut pegbiyag peuliꞌ et mengeꞌ tawʼt metitignaꞌ.” ");
INSERT INTO plw_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Maya sembatu, iba ye dut lemisaan, nekekingeg et itue e, kwan ye dut ki Jesus, “Mesukud sebarang kekaan dut kelang kenkaan dut pengmilikan et Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Siminambag si Jesus et sembatung susugiren, kwan ye, “Maya sembatung lelaki negpanyap et kelang kenkaan, bekeꞌ nengdangin et mekansang neng mengluluruk. ");
INSERT INTO plw_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Pegdateng et eldew ye ne, pinesurung ye kenyeng mengeꞌ uripen, supaya megsugid dut sebarang pinengdangin in, kwanen dye, ‘Aniꞌ kew ne, sabab ginsan nepanyap ne.’ ");
INSERT INTO plw_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Segwaꞌ saliꞌsaliꞌ negpekiampun dye ginsan. Kwaʼt una in, ‘Keeelen ku lang et lugtaꞌ, keilangan meruntin ku ampaꞌ mebiriꞌ. Mengangat ku mene dimyu et ampun sabab diki keruntin ku.’ ");
INSERT INTO plw_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Sembatu gasi negsugid, kwan ye, ‘Nekeelen ku et limang tegduruwa neng sapiꞌ neng pengeraru, keilangan mesingkewan ku supaya mesulayan ku dye, angkansa maapaꞌ myu mene aku sabab diki keruntin ku.’ ");
INSERT INTO plw_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Maya nega sembatu negsugid, kwan ye, ‘Diki ku keruntin sabab bagung bulun ku peꞌ.’ ");
INSERT INTO plw_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Indyari negpeuliꞌ uripen dut pegibuten ye, pegketbes negsugid. Indyari, empuʼt benwa in niseg, ampaꞌ gasi nengdaak, kwan ye, ‘Manew kew gasi, segwaꞌ tikasaꞌ myu lang. Sumurung kew dut mengeꞌ dalan bekeꞌ mengeꞌ mesigpit naꞌ dalan dut lungsud, sampay mengeꞌ miskin pengdenginaꞌ myu, mengeꞌ pangkul, mengeꞌ beleg, bekeꞌ mengeꞌ piley.’ ");
INSERT INTO plw_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Indyari pagkaꞌ nebuwat ne et uripen, kwan ye, ‘Begerar, sebarang daak mu damen in, netuman ne, segwaꞌ melugkew nega.’ ");
INSERT INTO plw_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Angkansa, negsugid gasi begerar kwan ye dut mengeꞌ uripen ye, ‘Sumurung kew gasi peuliꞌ dut mengeꞌ kelsada sampay dut mengeꞌ dalan surungan dut mengeꞌ kebudbukiran. Peglelegesaꞌ myu dye na matuꞌ, supaya mebahanan ne benwa ku. ");
INSERT INTO plw_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Isugid ku dimyu, sebarang unang dinangin tiꞌ misan sembatu diki dye kerasa et mengeꞌ pinepanyap ku neng kelang kenkaan.’ ” ");
INSERT INTO plw_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Mekeldam mengeꞌ taaw megbebayaꞌ ki Jesus. Indyari, liminingew si Jesus dut kedye, kwan ye, ");
INSERT INTO plw_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Baꞌ sinu mibut daken, subaliꞌ pegkasi ye daken luwas nega dut pegkasi ye dut kenyeng amaꞌ etawa induꞌ, kenyeng esawa, etawa kenyeng mengeꞌ yegang, mengeꞌ ketipusdan. Megdemikian, baꞌ diki pegkasi dut diri ye atin ya, diki lang megmendyaring mepengendelan ku. ");
INSERT INTO plw_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Bekeꞌ baꞌ sinu megmendyaring tindeg ku keilangan memsan et diri yeng krus, ingin bersen sumandal et keliyutan misan dut kemeteyan, bekeꞌ mibut daken. ");
INSERT INTO plw_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Supama sembatu dimyu na megpetiyeg et melangkew naꞌ benwa, diki be marung mena ya pegketbes itung-itungen ye baꞌ senu megastu, supaya mesewran ye baꞌ dyukup ne pirak neng penggastu duntin? ");
INSERT INTO plw_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Sabab baꞌ meusuk ne pemidyuruꞌ, indyari sumked ne lang sentin diki ye ne mepetbes benwa ye, sebarang kebiriꞌ menawey kenye. ");
INSERT INTO plw_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Kwanen dye, ‘Itueng taaw negbenwa, segwaꞌ kaya lang mekebaraꞌ ye.’ ");
INSERT INTO plw_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Etawa sembatung surutan megpepanyap supaya menggira dut ibang surutan. Diki be pikir-pikiren ye mena baꞌ sempulung ribu naꞌ mengeꞌ kesundeluan ye enuʼt mekedyaring ilawan ye dut duwangpulung ribu naꞌ mengeꞌ kesundeluan na mekidugpak kenye. ");
INSERT INTO plw_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Na baꞌ nerim ye diki mekedyari, megpeuna ne ya et mengeꞌ taaw ye supaya mekipegsulut-sulut sasat merayuꞌ nega mengeꞌ keatu ye. ");
INSERT INTO plw_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Megdemikian, baꞌ pegkasi daken diki lumuwas dut pegkasi ye et diri ye, diki lang ya memendyaring pepengenaran ku.” ");
INSERT INTO plw_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Asin in menunga. Segwaꞌ baꞌ manag ne, enukwan nega mepeuliꞌ rasa ye? ");
INSERT INTO plw_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Kaya ne guna dut pitabaꞌ et lugtaꞌ etawa misan dut tembakan et dugami. Angkansa itimbag ne lang itue. Na, baꞌ sinu meingin mekesewd, sebarang kumingeg et baꞌ enu bersen dimyu et Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Na, maya mengeꞌ menunukut et buwis bekeꞌ mengeꞌ ibang mekeselaan nepekabiꞌ pelibut dut ki Jesus apang kekingeg. ");
INSERT INTO plw_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Segwaꞌ nemenglimut mengeꞌ pariꞌ naꞌ Pariseo bekeꞌ mengeꞌ menunulduꞌ et Keseraan, kwan dye, “Itueng taaw pegterimanen ye mengeꞌ mekeselaan sampay pemegbeꞌbayaꞌ nega mengaan.” ");
INSERT INTO plw_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Indyari, negtuturan si Jesus kedye et sembatung beleybey, kwan ye, ");
INSERT INTO plw_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Supama sembatu dimyu maya senggatus neng bibili. Indyari nalam sembatu. Diki takuꞌ tirengan ye siyam neng puluꞌ siyam dut kelnangan, pegketbes tulusen ye inyet nalam in seked mebiyanan ye? ");
INSERT INTO plw_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Na baꞌ mebiyanan ye ne ating bibili, tenggulen ye atin, na maya keksanan. ");
INSERT INTO plw_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Muliꞌ ya dut benwa ye. Indyari ipetingkag ye mengeꞌ bilaꞌ ye bekeꞌ mengeꞌ kerurungan ye. Indyari sugiren ye, ‘Mekilami kew daken, sabab nebiyanan ku ne nalam neng bibili ku in.’ ");
INSERT INTO plw_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Sugiran ku kemyu, megdemikian samat kwantin gasi dut langit, mekansang mekeksanan sabab lang dut sembatung mekeselaan na negsusun et salaꞌ ye. Segwaꞌ diki ne banar dut siyam neng puluꞌ siyam neng metignaꞌ in, sabab diki dye ne keilangan megsusun nega.” ");
INSERT INTO plw_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Etawa, supama maya sembatung libun na maya sempuluꞌ dublun ye. Indyari nalam sembatu. Diki takuꞌ siluan ye et pelitaan, menilig dut benwa bekeꞌ tulusen ye banar seked mebiyanan ye atin? ");
INSERT INTO plw_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Na baꞌ nebiyanan ye ne itue, denginen ye kenyeng mengeꞌ bilaꞌ bekeꞌ mengeꞌ rurungan ye, indyari sugiren ye dut kedye, ‘Mekilami kew daken, sabab nebiyanan ku ne dublun ku neng nalam in.’ ");
INSERT INTO plw_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Megdemikian sugiran ku kemyu maya keksanan dut elepaʼt mengeꞌ dereakan et Empuꞌ sabab lang dut sembatung mekeselaan naꞌ negsusun et salaꞌ ye.” ");
INSERT INTO plw_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Neglahyun tuturan i Jesus dut kedye, kwan ye, “Maya sembatung taaw na maya duwang kelelekian yegang ye. ");
INSERT INTO plw_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ating kerinan negsugid dut amaꞌ ye, kwan ye, ‘Amaꞌ, igbeyaꞌ ne daken mengeꞌ bagiꞌ ku dut mengeꞌ pusakaꞌ mu in.’ Angkansa pinegbagiꞌbagiꞌ ne lang et amaꞌ dut kedye. ");
INSERT INTO plw_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Pegketbes et atin, ingga peꞌ nekwitan banar, pinengakut ne et kerinan ginsaʼt bagiꞌ ye in. Siminurung dut merayung lungsud pegdateng ye dun, duntin ye ne pinenggastu kementirian ye, na kaya sewd-sewd neng pineggegestuan. ");
INSERT INTO plw_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Pagkaꞌ negastu ye ne ginsan, diminateng kelang urap dut lungsud naꞌ atin, sampay ya timinagnaꞌ ne gasi kesigpitan ye. ");
INSERT INTO plw_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Angkansa siminled net keradya dut sembatung meglelegdeng duntin, indyari pinekeredyanan kenye dut uma, na megpekaan lang et mengeꞌ kebiyekan duntin. ");
INSERT INTO plw_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ingin ye mesunuan beteng ye et misan mene mengeꞌ apa neng kekanen et mengeꞌ biyek in, segwaꞌ misan sembatu kaya megbegey kenye. ");
INSERT INTO plw_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Ganang netewtewan ye ne, kwanaꞌ ye ne dut diri ye, ‘Dut kineldam-keldam et mengeꞌ uripen et amaꞌ ku, maya peglebi-lebi nega kedye mengeꞌ kekanen, segwaꞌ daken atue megpatey ku net urap. ");
INSERT INTO plw_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Peuliꞌ ku ne lang dut amaꞌ ku.’ Indyari sugiren ku kenye, ‘Amaꞌ, negkesalaꞌ ku dut Empuꞌ Banar bekeꞌ dimu. ");
INSERT INTO plw_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Diki ne megpatut na tingkagan mu nega akuʼt yegang, isiringaꞌ ku ne lang na sembatu mung tetengdanan.’ ");
INSERT INTO plw_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Angkansa timinyeg ne pesurung dut kenyeng amaꞌ. “Segwaꞌ merayuꞌrayuꞌ nega nepayag ne ya et kenyeng amaꞌ, nekeingasiꞌ banar amaꞌ ye. Darak ginsan megsususup et yegang ye, pegdateng megtuy kinekepan ye bekeꞌ inimbuan. ");
INSERT INTO plw_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Negberes yegang, kwan ye, ‘Amaꞌ, negkesalaꞌ ku dut Empuꞌ dut langit bekeꞌ dimu. Diki ne megpatut na tingkagan mu nega akuʼt yegang.’ ");
INSERT INTO plw_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Segwaꞌ sinugid et amaꞌ dut kenyeng mengeꞌ uripen, ‘Sekeliaꞌ myu, bitaꞌ myuʼt menungang pekayan ampaꞌ myu ne pepekayan. Pesingsingiꞌ myu keremut ye bekeꞌ petempaiꞌ myu tiked ye. ");
INSERT INTO plw_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Bitaꞌ myu atue pinetabaꞌ neng ibun et sapiꞌ in ampaꞌ myu ne sumbelien, megkenkaan bekeꞌ meglami-lami tyu. ");
INSERT INTO plw_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Sabab itueng yegang ku samat natey ne pegketbes negbiyag peuliꞌ; Nalam ne teyen segwaꞌ nebiriꞌ ku nega.’ Indyari, tinegnanan dye ne meglami-lami. ");
INSERT INTO plw_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Segwaꞌ ating masa, ukaꞌ in dun negaʼt uma. Ganang megkekabiꞌ ne et benwa, nekekingeg et binesalan bekeꞌ tinrekan. ");
INSERT INTO plw_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Angkansa pinetingkag ye sembatung uripen dye, indyari iningkut ye, kwan ye, ‘Enu neinabu duntin?’ ");
INSERT INTO plw_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Sinugid et uripen, ‘Ariꞌ mu be nekeuliꞌ ne, bekeꞌ amaꞌ myu negpesumbaliꞌ et pinetabaꞌ neng ibun et sapiꞌ, sabab nekeuliꞌ ne na kaya enu-enu ye.’ ");
INSERT INTO plw_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Pagkaꞌ kwantin ne, nengiseg ukaꞌ in bekeꞌ mendiꞌ ne sumled et benwa. Angkansa liminiwan amaꞌ ye, bekeꞌ inimuyuk ye ukaꞌ in. ");
INSERT INTO plw_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Segwaꞌ sinambag et ukaꞌ in dut amaꞌ ye, ‘Birinaꞌ, megsukuꞌ ku dimu et ginsaʼt mengeꞌ teun sampay tiban, na kaya megsemal ku baꞌ menahag kew. Segwaꞌ misan yegang et kambing kaya binggeyan mu aku supaya meglami-lami kay et mengeꞌ biꞌbilaꞌ ku. ");
INSERT INTO plw_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Segwaꞌ itueng yegang mu neng ariꞌ ku, naꞌ nengamin et sentengaꞌ neng mengeꞌ pusakaꞌ mu sabab lang dut megpebeis-beis dut mengeꞌ kelilibunan, temed ga in sinumbelian mu nega ya et pinetabaꞌ neng sapiꞌ!’ ");
INSERT INTO plw_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Siminambag Amaꞌ ye kenye, ‘Yegang, daran te pegbeꞌbayaꞌ bekeꞌ ginsaʼt mengeꞌ pengartaꞌ ku in, atin dimu. ");
INSERT INTO plw_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Segwaꞌ tiban, patut lang na meglami-lami tyu, sabab itueng ariꞌ mu samat natey ne, temed tiban negbiyag peuliꞌ; nalam ne ya, segwaꞌ ya tiban nebiyanan ne.’ ” ");
INSERT INTO plw_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Negsugid si Jesus dut kenyeng mengeꞌ pepengenaran, kwan ye, “Maya sembatung mentiriꞌ neng lelaki, binaal ye et sembatung uripen na pepengendelan ye. Na itueng taaw na pepengendelan na netendes et pengrugiꞌ et mengeꞌ pusakaꞌ et mentiriꞌ neng lelaki. ");
INSERT INTO plw_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Angkansa pinetingkag ye ya bekeꞌ iningkut, kwan ye, ‘Enu itueng mekekingeg ku pasal dimu? Ipeturaꞌ be daken pasal dut pinekpetan ku dimu, sabab diki ku ne ikew baalen nega et pepengendelan ku.’ ");
INSERT INTO plw_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Indyari, nepikir et pepengendelan in, kwan ye, ‘Enu ne buwaten ku tiban? Sabab pegibuten ku, ugaran ye ne akuʼt keradya. Ne, kaya sewd ku megeraru et lugtaꞌ bekeꞌ kelewleew ku ne baꞌ mengangat ku lang et tabang. ");
INSERT INTO plw_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","A, sewd ku ne baꞌ enu buwaten ku, supaya baꞌ meugaran ku net keradya atue e, mengeꞌ taaw menerima daken dut kedyeng mengeꞌ binenwa.’ ");
INSERT INTO plw_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Angkansa pinetingkag ye tegesembatu-sembatu mengeꞌ nekeutang et kenyeng pegibuten. Iningkut ye meguna in, kwan ye, ‘Senu utang mu dut pegibuten ku?’ ");
INSERT INTO plw_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","‘Walung gatus neng galun et lana,’ sambag ye. Indyari sinugiran ya et pepengendelan kwan ye, ‘Isiaꞌ listaan et utang mu, arung sekaliꞌ, indyari buwataꞌ ne lang et epat neng gatus.’ ");
INSERT INTO plw_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Pegketbes iningkut ye gasi pengeruwa in, kwan ye, ‘Dimu senu gasi utang mu?’ ‘Seng ribung gantang et parey,’ sambag ye. Indyari sinugiran ye ya, kwan ye, ‘Isiaꞌ listaan mu, buwataꞌ ne lang et walung gatus.’ ");
INSERT INTO plw_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Pegkaꞌ neliling et pegibuten baꞌ enu ineluꞌ dut mengeꞌ nekeutang tiꞌ ating mengrurunding naꞌ pepengendelan ye dinayew ya, sabab ye mekesewd ne. Sabab asal lebing mependey mengeꞌ taaw na kaya mengandel et Empuꞌ dut mengeꞌ sebayaꞌ dye, eset mengeꞌ taaw et siluꞌ na mengandel et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Sugiran ku kemyu, gemitaꞌ myu mentiriꞌ atuʼt dunyaꞌ naꞌ itue supaya kumeldam bilaꞌ myu. Pegdatek patey kew ne, terimanen dye ikew dut benwa dye na kaya seskeran dut langit. ");
INSERT INTO plw_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Sebarang mekepengendelan et isek-isek mepengendelan gasi et kelaꞌ. Segwaꞌ baꞌ diki mekepengendelan et isek-isek, megdemikian diki gasi mepengendelan et kelaꞌ. ");
INSERT INTO plw_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Angkansa baꞌ diki kew mekepengendelan et mengeꞌ mentiriꞌ atuʼt dunyaꞌ sinu gasi mekepekpet dimyu et tantung mentiriꞌ? ");
INSERT INTO plw_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Bekeꞌ baꞌ diki ke mekepengendelan et pusakaꞌ et sebayaꞌ mu, sinu gasi megey dimu et pemusakaan et diri? ");
INSERT INTO plw_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Kaya sembatung uripen kekeradya dut duwang pegibuten. Merganen ye sembatu, indyari sembatu in bentanen ye, etawa esipen ye sembatu, indyari sembatu in mendinan ye. Pirak bekeꞌ Empuꞌ, diki mekedyari myu mesukuan sama-sama.” ");
INSERT INTO plw_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ganang nekingeg itueng ginis et mengeꞌ tawʼt Pariseo, binulili dye si Jesus sabab meireg dye et pirak. ");
INSERT INTO plw_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Indyari, kwan i Jesus dut kedye, “Kemyung mengeꞌ pebiꞌbiriꞌ dut mengeꞌ taaw kunuꞌ menunga keradya myu, segwaꞌ sewd et Empuꞌ baꞌ enu seled atey myu. Sabab sebarang mergaꞌ banar dut pemiriꞌ et mengeꞌ taaw, segwaꞌ dut pemiriꞌ et Empuꞌ atin kaya keguna-guna.” ");
INSERT INTO plw_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Mengeꞌ Saraꞌ i Moises bekeꞌ kityung mengeꞌ Kesuratan et mengeꞌ tarus et Empuꞌ, atin pinepakay seked mene ki Juan neng mememewtismu diminateng. Pegketbes, Menungang Abar pasal et pengmilikan et Empuꞌ pineabar. Angkansa ginsaʼt taaw memegleges kesled pengmilikan et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Segwaꞌ lebing merugey mepapas langit bekeꞌ lugtaꞌ eset malam sembatung samat ampang et beres et Kesuratan pasal Keseraan et Empuꞌ, atin diki lang mepapas seked keskeran.” ");
INSERT INTO plw_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Sebarang lelaki na memutas et esawa ye, pegketbes, mengesawa ibang libun, ya negkesalaꞌ et pegbeis. Bekeꞌ baꞌ lelaki mengesawa et binutasan neng libun, megdemikian negkesalaꞌ et pegbeis.” ");
INSERT INTO plw_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Maya sembatung lelaki naꞌ mentiriꞌ megbebadyuꞌ et menunungang pemekayan, bekeꞌ piliꞌ lang neng mengeꞌ kekanen pegkanen ye eldew-peldew. ");
INSERT INTO plw_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Bekeꞌ maya pelilitid lang set lelengewan ye, sembatung pemengangat neng taaw ingaran ye si Lasaro. Bilug ye baha net upang. ");
INSERT INTO plw_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Gaay ye mengaan misan mene mengeꞌ mumuꞌ neng mekeregdag teyeg dut lemisaan et mentiriꞌ in. Mengeꞌ ireng megkabiꞌ kenye sampay pegtilaan mengeꞌ tawan ye. ");
INSERT INTO plw_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Diminateng timpu na si Lasaro natey, indyari binibit ne ya et mengeꞌ dereakan et Empuꞌ dut abiꞌ i Abraham dut langit. Indyari lelaki naꞌ mentiriꞌ in natey gasi kenye, pegketbes limbeng ne. ");
INSERT INTO plw_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Segwaꞌ nesurungan ye dut Narkaꞌ, na ya dut seled ketiksaan. Indyari timiningaraꞌ nebiriꞌ ye si Abraham merayuꞌ dut langit, abiꞌ ye si Lasaro. ");
INSERT INTO plw_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Angkansa, timiningkag kenye, kwan ye, ‘Upuꞌ Abraham, ingesiniꞌ ku, daakaꞌ si Lasaro na iditil ye tulduꞌ ye dut danum tebes peremigen ye dilaꞌ ku, sabab meketiksaan kuʼt apuy naꞌ itue eꞌ.’ ");
INSERT INTO plw_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Na siminambag si Abraham, kwan ye, ‘Yegang, rendemaꞌ kwit pebibiyag ke nega, neterima mu ne ginsan neng menunungang ginis. Segwaꞌ si Lasaro, kenye neterima ye mengeꞌ keliyutan ginsan. Kenye tiban melahay ne, segwaꞌ dimu dut keliyutan. ");
INSERT INTO plw_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Bekeꞌ iba set pinegketngaan tyu, kami bekeꞌ ikew, maya elet, kelang pengras, angkan diki ne kesentin sebarang aniꞌ e, bekeꞌ diki ne keaniꞌ sebarang esentin in.’ ");
INSERT INTO plw_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Indyari siminambag mentiriꞌ kwan ye, ‘Baꞌ kwantin pelan upuꞌ Abraham, baꞌ mekedyari teyen dut dimu, daakaꞌ ne lang si Lasaro dut benwa et amaꞌ ku. ");
INSERT INTO plw_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Sabab untin maya nega limang ketipusdan ku neng mengeꞌ kelelekian. Iperuntinaꞌ myu supaya megpeamay-amay kedye, supaya diki dye kesurung atuʼt ketiksaan tuꞌ.’ ");
INSERT INTO plw_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Segwaꞌ siminambag si Abraham kwan ye, ‘Duntin nega maya Keseraan i Moises bekeꞌ Kesuratan et mengeꞌ tarus et Empuꞌ. Atin subaliꞌ endelen dye.’ ");
INSERT INTO plw_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","‘Diki lang, upuꞌ Abraham,’ kwan ye. ‘Baꞌ maya teyen sembatu neng mawaꞌ ne natey sumurung kedye, meraliꞌ megsusun dye ne.’ ");
INSERT INTO plw_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Segwaꞌ sinambag ye ya, kwan ye, ‘Baꞌ diki dye kumingeg ki Moises bekeꞌ dut mengeꞌ tarus et Empuꞌ, megdemikian diki lang gasi endelen dye sembatung patey misan negbiyag ne peuliꞌ.’ ” ");
INSERT INTO plw_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Sinugid i Jesus dut mengeꞌ pepengenaran ye, kwan ye, “Tantu banar, dumateng mengeꞌ indeginis neng pesebaban pasal tiharan et pegkesalaꞌ et taaw. Segwaꞌ keingasiꞌingasiꞌ ating taaw naꞌ tinyegan et pegkekesalaꞌ in. ");
INSERT INTO plw_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Menunga nega kenye baꞌ tekinan et kelang batu liyeg ye bekeꞌ itimbag ya dut dagat, endey lang baꞌ ya teyegan et pegkesalaꞌ et misan sembatung yegang na itue. ");
INSERT INTO plw_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Angkansa inget kew. Baꞌ sebayaꞌ mu megkesalaꞌ dimu, bulagaꞌ megtuy. Na baꞌ megsusun ya, maapaꞌ gasi. ");
INSERT INTO plw_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Baꞌ ya megkesalaꞌ dimu et kepitu seng eldew, indyari kepitu gasi pepeuliꞌpeuliꞌ dimu supaya mengangat et ampun, empunaꞌ ya gasi.” ");
INSERT INTO plw_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Indyari neres mengeꞌ pepengenaran ye dut Begerar, kwan dye, “Dugangiꞌ pegandel kay.” ");
INSERT INTO plw_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Indyari siminambag si Jesus, kwan ye, “Baꞌ maya pegandel myu saliꞌ ye samat isek-isek neng elinseg et mustasa in, mekedyari myu ne sugiran itueng kayu indyari kwanen myu, ‘Megabut ke teyen, pegketbes megubuꞌ ke dut dagat.’ Isugid ku ne sebanar, meinabu dut kayu naꞌ atin baꞌ enu sinugid myu.” ");
INSERT INTO plw_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Supama sembatu dimyu maya sembatung uripen pengeraru etawa megtutunggu et mengeꞌ bibili. Pegdateng ye mawaꞌ dut uma, sugiren be kenye, ‘Arung ne aniꞌ, bekeꞌ pengaan ne?’ ");
INSERT INTO plw_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Diki be takuꞌ sugiran et pegibuten ye, kwanen ye, ‘Penyapaꞌ ne pengmepunan ku, bekeꞌ seliniꞌ mena bilug mu pegketbes sukuiꞌ ku sasat penginum bekeꞌ pengaan ku nega. Pegketbes, mekedyari ke ne menginum bekeꞌ mengaan.’ Diki be takuꞌ samat kwantin? ");
INSERT INTO plw_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Bekeꞌ megpesukur takuꞌ pegibuten ye sabab nebuwat ye baꞌ enu sinugid kenye na buwaten? Diki! ");
INSERT INTO plw_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Megdemikian dimyu, pegkaꞌ mebuwat myu ne ginsaʼt pinanduꞌ dimyu na buwaten, indyari kwanen myu kami tuꞌ, ‘Kami na kaya keguna-guna neng mengeꞌ uripen, pegtumanen kay lang baꞌ enu pinesukuꞌ damen in.’ ” ");
INSERT INTO plw_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Pegsurung i Jesus dut lungsud et Jerusalem, bineyaan ye dut pinegketngaan et bangsa et Samaria bekeꞌ Galilea. ");
INSERT INTO plw_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ganang megkekabiꞌ ne ya dut kebenbenwanan, sempuluꞌ neng kelelekian na maya eldew-eldew siminusup kenye. Indyari nepetaren dye dut mereꞌrayuꞌ. ");
INSERT INTO plw_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Indyari nemeningkag dye lang et mebasag, kwan dye, “Jesus, Begerar, ingesiniꞌ kay!” ");
INSERT INTO plw_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Pegkebiriꞌ ye dut kedye kwan ye, “Panew kew ne, ipebirinaꞌ bilug myu dut mengeꞌ pariꞌ apang mesewran dye ne na pinenunga kew ne.” Ganang megsusurung dye ne, nemegnunga ne. ");
INSERT INTO plw_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Maya sembatu kedye, ganang nebiriꞌ ye bilug ye menunga ne, negpeuliꞌ kenye dut ki Jesus na megbebensag et pegbantug dut Empuꞌ Banar. ");
INSERT INTO plw_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Pegdateng ye dut elepan i Jesus, megtuy nepekleb dut titikeran ye bekeꞌ negpeselamat; segwaꞌ ya lang naꞌ sembatung taaw tumpang teyeg dut bangsa et Samaria. ");
INSERT INTO plw_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Iningkut ya i Jesus, kwan ye, “Diki be sempuluꞌ kew pinenunga in? Embe ne siyam in? ");
INSERT INTO plw_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Kaya lang misan sembatu kedye na nebiriꞌ ku na negpeuliꞌ atue e bekeꞌ negpepeselamat etawa megbebantug dut Empuꞌ Banar, selyu lang itueng taaw na tumpang tuꞌ.” ");
INSERT INTO plw_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Indyari kwan ye dut kenye, “Teyeg ne bekeꞌ panew ne. Pinenunga ke ne et pegandel mu et daken.” ");
INSERT INTO plw_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Sene in, mengeꞌ pariꞌ naꞌ Pariseo nemengingkut ki Jesus, kwan dye, “Ingyan dumateng pengmilikan et Empuꞌ Banar?” Siminambag si Jesus kwan ye, “Pengmilikan et Empuꞌ dumateng na diki lang mebiriꞌ myu. ");
INSERT INTO plw_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kaya taaw kesugid et ‘Atuꞌ neꞌ e!’ etawa, ‘Duntin ne!’ Sabab pengmilikan et Empuꞌ esen net dimyu.” ");
INSERT INTO plw_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Indyari kwan ye dut kenyeng mengeꞌ pepengenaran, “Dumateng timpu na gayen myu teyen na mebiriꞌ misan lang sembatung eldew et Yegang et Taaw, segwaꞌ diki myu mebiriꞌ atin. ");
INSERT INTO plw_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Mengeꞌ taaw megsugid, ‘Duntin ne ya!’ etawa, ‘Atuꞌ ne ya e!’ Segwaꞌ kasiꞌ myu dye pegendelaꞌ. ");
INSERT INTO plw_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Sabab Aku neng Yegang et Taaw, dumateng mesingan ku samat kilat, mebinyaran ginsaʼt lelengew tihad dut sebangan sumked dut sedpan. ");
INSERT INTO plw_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Segwaꞌ subaliꞌ aku sumandal mena et mekansang naꞌ keliyutan bekeꞌ mendinan et mengeꞌ taaw et tiban neng timpu. ");
INSERT INTO plw_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Samat neinabu dut eldew i Noe tagnaꞌ banar, megdemikian eldew ku, atin Yegang et Taaw, kwantin gasi meinabu. ");
INSERT INTO plw_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Mengeꞌ taaw pemengaan, pemenginum, pemengesawa, sampay pepeesawa seked lang siminled si Noe dut kapal letew ye. Pegketbes diminateng ne liyud sampay nebinasa ginsan et mengeꞌ taaw netetektak atuʼt dunyaꞌ. ");
INSERT INTO plw_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Megdemikian, kwantin gasi neinabu dut eldew i Lot. Mengeꞌ taaw pemengaan bekeꞌ pemenginum, pemengelen bekeꞌ pepelen, pemengluwak bekeꞌ pemegbenwa. ");
INSERT INTO plw_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Segwaꞌ ganang diminateng timpu na si Lot pineugad ne dut lungsud et Sodoma, mura diminlek et apuy bekeꞌ mengeꞌ batu neng megdedleg teyeg dut langit indyari ginsan dye netpuꞌ ne. ");
INSERT INTO plw_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Megdemikian samat kwantin gasi meinabu dut eldew na mebunayag ne Aku neng Yegang et Taaw. ");
INSERT INTO plw_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Dut eldew na atin, kaya ne misan sinu endey ne ya mineug supaya mengisiꞌ et mengeꞌ pengartaꞌ ye baꞌ ya dut timbewʼt sapew. Megdemikian gasi baꞌ ya dut uma ye, endey ne ya muliꞌ. ");
INSERT INTO plw_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Rendemaꞌ myu esawa i Lot tagnaꞌ neng mesmal et atin sabab liminingew nega et pengartaꞌ ye! ");
INSERT INTO plw_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Na baꞌ sinu meingin menaguꞌ et biyag ye, malam atin. Segwaꞌ baꞌ sinu meugaran et biyag ye, dumaran atin. ");
INSERT INTO plw_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Sugiran ku kemyu, dut pegdateng ku peuliꞌ, dut gebi naꞌ atin, maya duwang ketawan dut iigaan. Sembatu isien, segwaꞌ sembatu metektak. ");
INSERT INTO plw_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Duwang kelilibunan pemenglebek et parey. Sembatu isien, segwaꞌ sembatu metektak. ");
INSERT INTO plw_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Maya duwang kelelekian pemegkeradya dut uma. Sembatu isien, segwaꞌ sembatu metektak dut sembatung ketulduan.” ");
INSERT INTO plw_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","“Embe meinabuan et atin, Begerar?” ingkut dye. Indyari siminambag si Jesus teyeg et ketulduan, kwan ye, “Na baꞌ embe pegderetunan et bangkay, duntin gasi pemegtimung mengeꞌ peruni.” ");
INSERT INTO plw_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Indyari, si Jesus negtuturan dut pepengenaran ye et sembatung beleybey supaya ipebiriꞌ kedye na dye subaliꞌ daran lang menelangin dut Empuꞌ banar, bekeꞌ endey dye sumuen. ");
INSERT INTO plw_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Kwan ye, “Dut sembatung lungsud maya sembatung ukum na kaya megtakut dut Empuꞌ etawa pengasip et mengeꞌ taaw. ");
INSERT INTO plw_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Indyari maya gasi sembatung nebeluan naꞌ libun dut ating lungsud na daran megkabiꞌ kenye supaya mengangat et ingasiꞌ, kwaʼt libun in, ‘Tebangiꞌ ku sabab dye penaksir daken.’ ” ");
INSERT INTO plw_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Segwaꞌ kepire ne megmendiꞌ ukum in. Segwaꞌ ketepus-tepusan kwan ye dut diri ye, ‘Misan ne kaya megtakut ku dut Empuꞌ etawa penginasip et mengeꞌ taaw, itue ga naꞌ libun e, sabab daran ye lang aku pegsesewen, ");
INSERT INTO plw_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","tebangan ku ne lang ya, taka-taka meperaat ye lang pikiran ku sabab et pegatuꞌatuꞌ ye!’ ” ");
INSERT INTO plw_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Indyari negsugid si Jesus, kwan ye, “Kinggaꞌ myu baꞌ enu binres et meyaat neng ukum in. ");
INSERT INTO plw_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Deuluꞌ Empuꞌ, diki Ye be metebangan mengeꞌ piniliꞌ Ye, na daran lang megtitingkag kenye eldew gebi? ");
INSERT INTO plw_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Sugiran ku kemyu, meterima dye na megtuy, tabang et Empuꞌ. Segwaꞌ, baꞌ Aku neng Yegang et Taaw kepeuliꞌ ne atue, maya nega takuꞌ mebiyanan ku keendelan dut daken atuʼt dunyaꞌ naꞌ itue?” ");
INSERT INTO plw_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Pasal gasi dut mengeꞌ taaw na pemiriꞌ dye et diri dye metignaꞌ, segwaꞌ pememulili dut mengeꞌ sebayaꞌ dye, si Jesus negtuturan et kwantin neng beleybey, ");
INSERT INTO plw_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","kwan ye, “Maya duwang kelelekian siminled dut benwa neng Pegpengempuan naꞌ benwa supaya megpenelang dut Empuꞌ. Sembatu in pariꞌ na Pariseo, indyari sembatu in menunukut et buwis. ");
INSERT INTO plw_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Indyari, Pariseo kenye negpenalang et petitiyeg dut Empuꞌ, kwan ye, ‘Empuꞌ dut langit negpeselamat ku dimu sabab aku diki samat iba naꞌ menenakew, etawa mengeꞌ memumuwat et mereraat, etawa mengbebeis. Bekeꞌ diki aku samat itueng taaw neng menunukut et buwis tuꞌ. ");
INSERT INTO plw_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Pegpuasa ku keruwa seled et senglinggu bekeꞌ pegbegey ku daken neng ikesempuluꞌ neng bagiꞌ ku et ginsaʼt kineredyanan ku dut dimyu, Empuꞌ.’ ");
INSERT INTO plw_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Segwaꞌ ating menunukut et buwis, kenye dut mereꞌrayuꞌ lang pegtitiyegan ye, sabab megleew ya. Tumingaraꞌ dut langit mendiꞌ ne, misan ga in pegbektulen ye ne debdeb ye sabab et susun, kwan ye, ‘Empuꞌ banar dut langit, meingasiꞌ ke daken, na sembatung mekeselaan.’ ");
INSERT INTO plw_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Segwaꞌ sugiran ku kemyu,” binres i Jesus dut kedye, “itue ga neng lelaki e, menunukut et buwis, nuliꞌ bekeꞌ puwas ne salaꞌ ye dut Empuꞌ, diki lang samat atin sembatung pariꞌ na Pariseo in. Sabab sebarang pemantug et kenyeng diri, atin mepebaba, segwaꞌ sebarang pepekumbaba et bilug ye, atin key mepetaas.” ");
INSERT INTO plw_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Mendyari nememibit mengeꞌ taaw et mengeꞌ keyengyegangan dye et ki Jesus supaya ipedpen dye et kenye. Segwaꞌ ganang nebiriꞌ et mengeꞌ pepengenaran ye, pinemulag dye. ");
INSERT INTO plw_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Segwaꞌ pinekabiꞌ nega i Jesus mengeꞌ keyengyegangan dut kenye, kwan ye dut pepengenaran ye, “Pesariꞌ myu lang ating mengeꞌ derisekan naꞌ mengeꞌ keyegangan na pekabiꞌ daken. Kasiꞌ myu dye pegbulagaꞌ, sabab Pengmilikan et Empuꞌ dut mengeꞌ taaw naꞌ mengandel samat itueng mengeꞌ keyengyegangan. ");
INSERT INTO plw_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Sugiran ku kemyu et keberbenaran, sebarang diki tumerima et Pengmilikan et Empuꞌ Banar samat pegterima et mengeꞌ keyengyegangan diki dye kesled et benwa et Empuꞌ dut langit misan ne ingyan.” ");
INSERT INTO plw_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Indyari maya sembatung pegibuten et mengeꞌ tawʼt Judio nengingkut kenye, kwan ye, “Menungang Menunulduꞌ, enu buwaten ku supaya mebiyanan ku biyag naꞌ kaya seskeran?” ");
INSERT INTO plw_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Siminambag i Jesus, “Manu pegtingkagan mu aku et menunga, sabab kaya lang menunga selyu lang baꞌ Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Sewd mu be ating mengeꞌ saraꞌ et Empuꞌ: ‘Kas megbeis, kas pengimatey, kas penakew, kas megsugid et kaya keberbenaran, sampay untebiaꞌ amaꞌ bekeꞌ induꞌ mu.’ ” ");
INSERT INTO plw_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Indyari siminambag ating tawʼt mentiriꞌ, kwan ye, “Ginsaʼt sinugid atin, netuman ku ne tihad aku yengyegang nega.” ");
INSERT INTO plw_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ganang nekingeg itue i Jesus, kwan ye dut mentiriꞌ, “Maya nega sembatu kurang mu. Ipegelnaꞌ ginsaʼt pengartaꞌ mu pegketbes ibgeyaꞌ ating elen dut mengeꞌ miskin, indyari keisiꞌ keʼt kementirian dut langit. Pegketbes, matuꞌ ke supaya mibut ke ne daken.” ");
INSERT INTO plw_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Segwaꞌ ganang nekingeg et ating lelaki itue, nekerupuk banar, sabab ya maya kelang kementirian. ");
INSERT INTO plw_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Indyari siminyek si Jesus dut kenye, kwan ye, “Meliyut banar kesled mentiriꞌ dut pengmilikan et Empuꞌ Banar. ");
INSERT INTO plw_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Gamlang kamelyo merugey-rugey nega kesled dut delang et dagum, kas lang sembatung mentiriꞌ na kesled dut pengmilikan et Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Indyari sebarang nemekekingeg et itue, kwan dye, “Baꞌ kwantin, sinu mekedyaring kebawiꞌ?” ");
INSERT INTO plw_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Siminambag si Jesus, kwan ye, “Sebarang diki lang mekedyari dut mengeꞌ taaw, segwaꞌ dut Empuꞌ ginsan mekedyari meinabu.” ");
INSERT INTO plw_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Indyari neres si Pedro, kwan ye dut ki Jesus, “Na birinaꞌ, pinenirengan kay ginsan sabab lang et kami nibut dimu.” ");
INSERT INTO plw_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Siminambag si Jesus kenye, “Sugiran ku kemyu et keberbenaran. Baꞌ maya taaw na timinireng et benwa ye, etawa esawa ye, etawa mengeꞌ ketipusdan etawa mengeꞌ kegunggurangan, etawa mengeꞌ keyegangan sabab lang dut pengmilikan et Empuꞌ, ");
INSERT INTO plw_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","na ya keterima et lebi nega dut penewnan naꞌ itue, bekeꞌ biyag na kaya seskeran dut penewnan naꞌ megderateng.” ");
INSERT INTO plw_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Indyari, ginayat i Jesus sempuluꞌ duwa neng mengeꞌ pepengenaran ye in, kwan ye dut kedye, “Tiban itue sumurung tyu dut Jerusalem. Na, pesalan gasi dut ginsan neng sinurat et mengeꞌ tarus et Empuꞌ tagnaꞌ pasal dut Yegang et Taaw, diki mekwit atin metuman. ");
INSERT INTO plw_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ipelugut ya dut mengeꞌ taaw neng diki Judio na pegbelbenglan, inlelewen, pegigban-igban, ");
INSERT INTO plw_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","peglelepsan, indyari dut ketimpusan, imeteyen dye gasi ya. Segwaꞌ pegdatek iketlung eldew, ya megbiyag peuliꞌ.” ");
INSERT INTO plw_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Segwaꞌ ginsaʼt itue kaya neretian et mengeꞌ pepengenaran i Jesus baꞌ enu ingin bersen. Indyari tinaguꞌ kedye retian et itue, sabab diki dye nesewran baꞌ enu lang atin pegbebresen i Jesus in. ");
INSERT INTO plw_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ganang megkekabiꞌ ne de Jesus dut Jeriko, maya sembatung beleg dut iged et dalan megarung ne lagi supaya megpeingasiꞌ. ");
INSERT INTO plw_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Pegkaꞌ nekingeg ye kineldaman memegtetalib ne, iningkut ye baꞌ enu neinabu. ");
INSERT INTO plw_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Sinugiran dye ya, kwan dye, “Si Jesus neng tege-Nasaret megtetalib.” ");
INSERT INTO plw_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Indyari timiningkag ne, kwan ye, “Jesus, neng keupuꞌupuan i Surutan Dabid tagnaꞌ, ingesiniꞌ ku.” ");
INSERT INTO plw_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Segwaꞌ binulag et sebarang memeguna in, kwan dye, “Kas kegibek!” Segwaꞌ susulu ga neres et mebasag banar, kwan ye, “Keupuꞌupuan i Dabid, meingasiꞌ ke daken!” ");
INSERT INTO plw_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Indyari nepetaren si Jesus, pegketbes tinehagan ye na ipekabiꞌ dut kenye. ");
INSERT INTO plw_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Sinugid i Jesus, “Enu ingin mu na buwaten ku et dimu?” Siminambag beleg in, “Begerar, ingin ku teyen kebiriꞌ.” ");
INSERT INTO plw_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Kwan i Jesus dut kenye, “Mekebiriꞌ ke ne, dimung pengandel daken negpenunga dimu.” ");
INSERT INTO plw_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Negdingan lang beres i Jesus, megtuy ne ya nekebiriꞌ, sampay neglahyun ne nibut ki Jesus, na megbebantug dut Empuꞌ Banar dut langit. Ganang nebiriꞌ itue et mengeꞌ taaw, negbantug dye gasi dut Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Si Jesus siminled net lungsud et Jeriko, ganang megtetalib ne teyen. ");
INSERT INTO plw_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Maya dun sembatung lelaki ingaran ye si Sakeo, ya sembatung pengibuten naꞌ menunukut et buwis, bekeꞌ sembatung mentiriꞌ. ");
INSERT INTO plw_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ingin ye mebiriꞌ baꞌ sinu takuꞌ itueng Jesus naꞌ pegsugiren. Segwaꞌ sabab et mepandak, enung kwanen ye, sabab et kineldaman meglilimben ki Jesus. ");
INSERT INTO plw_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Angkansa, nekepikir ya dumarak dut unaan, indyari ninik dut kayung sikomoro supaya lang mebiriꞌ ye si Jesus. Sabab nerim ye na si Jesus mayaꞌ dut dalan naꞌ atin. ");
INSERT INTO plw_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ganang nekentek ne si Jesus, timiningaraꞌ, indyari kwan ye, “Sakeo, ineug ne peri, sabab keilangan petaren ku dut benwa mu tiban.” ");
INSERT INTO plw_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Angkansa nineug ne ya et daliꞌdaliꞌ, bekeꞌ tinerima ye dut benwa ye si Jesus et meksan. ");
INSERT INTO plw_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ginsaʼt itue nebiriꞌ et mengeꞌ taaw, indyari nemegkines-kines, kwan dye, “Timinindal ne dut benwa et sembatung mekeselaan bin.” ");
INSERT INTO plw_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Indyari, timinyeg si Sakeo, bekeꞌ negsugid dut Begerar, kwan ye, “Birinaꞌ Begerar, tiban ipemgey ku ne dut mengeꞌ miskin tengaꞌ mengeꞌ pengartaꞌ ku, bekeꞌ baꞌ maya nerugian ku dut sinu-sinu, mekepat ku ne dye beyaran.” ");
INSERT INTO plw_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Indyari kwan i Jesus, “Tiban mengeꞌ taaw seled benwa naꞌ itue maya ne kepuwasan et keselaan dye sabab minaap ne et Empuꞌ samat ki Abraham neng keupuꞌupuan tyu tagnaꞌ. ");
INSERT INTO plw_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Sabab Aku, Yegang et Taaw, natuꞌ supaya menulus bekeꞌ memawiꞌ et sebarang mengeꞌ taaw nalam.” ");
INSERT INTO plw_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Sasat memegkikingeg nega mengeꞌ taaw, negtuturan gasi et sembatung beleybey si Jesus, sabab ya mekabiꞌ ne dut Jerusalem, bekeꞌ seled pikiran et mengeꞌ taaw, dumateng ne megtuy pengmilikan et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Kwan i Jesus, “Maya sembatung metaas naꞌ taaw siminurung dut merayung lungsud supaya buwaten ya et surutan. Pegdatek senung timpu, ya in peuliꞌ nega. ");
INSERT INTO plw_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Indyari pinetingkag ye kenyeng sempulung mengeꞌ uripen, pegketbes binggeyan ye kedye-kedye et sembatung dublun. Sinugid et surutan, kwan ye, ‘Ipeuntungaꞌ myu itueng dublun seked kepeuliꞌ ku.’ Indyari nugad ne. ");
INSERT INTO plw_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Segwaꞌ nemengiseg ne lagi kenye ating mengeꞌ kesekupan ye bekeꞌ nemengdaak dye et mengeꞌ taaw na mebilinan supaya megsugid dut metaas ne surutan, kwanen dye, ‘Mendiꞌ kay na itueng taaw na megmendyaring surutan kay.’ ");
INSERT INTO plw_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Segwaꞌ binwat nega ya et sembatung surutan, pegketbes nepeuliꞌ. Pegdateng ye pinetingkag ye mengeꞌ uripen naꞌ pinemgeyan ye et mengeꞌ dublun in, supaya sewren ye baꞌ senu ne nepeuntung dye. ");
INSERT INTO plw_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Una in nepekabiꞌ, kwan ye, ‘Surutan, ating dublun naꞌ bulawan neng binggey mu daken in, nuntung et sempuluꞌ.’ ");
INSERT INTO plw_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Kwaʼt surutan ye, ‘Mependey, menungang uripen ke. Sabab ikew nepengendelan ku et mengeꞌ binilin ku misan isek-isek neng ginis, na tiban pekpetan dimu sempuluꞌ naꞌ lungsud.’ ");
INSERT INTO plw_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Siminunud gasi keruwang uripen in nepekabiꞌ kenye, kwan ye, ‘Surutan, binggey mu naꞌ sembatung dublun in, nepeuntung ku et lima.’ ");
INSERT INTO plw_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Indyari sinugid et surutan ye, kwan ye, ‘Dimu, keptan mu limang lungsud.’ ");
INSERT INTO plw_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Indyari nepekabiꞌ gasi sembatung uripen, kwan ye, ‘Surutan, binggey mu naꞌ dublun in, tatap nega, binulungan ku pegketbes tinaguꞌ ku lang. ");
INSERT INTO plw_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Sabab megtakut ku dimyu, sabab kemyu tuꞌ taaw naꞌ mepiret. Pegisien myu sebarang diki dimyu, bekeꞌ pegkeygen myu misan diki myu tinugdaꞌ.’ ");
INSERT INTO plw_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Indyari siminambag kenyeng surutan, kwan ye, ‘Iukum ku dimu dut mengeꞌ bebresen mu nega. Ikew naꞌ merupang neng uripen! Sewd mu ne pelan na aku tuꞌ sembatung meburangit naꞌ taaw, pegisien ku sebarang diki daken, bekeꞌ pegkeygen ku sebarang diki ku tinugdaꞌ. ");
INSERT INTO plw_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Kerey, manu diki mu binangku ating dublun supaya dut pegpeuliꞌ ku meisiꞌ, sampay ibun?’ ");
INSERT INTO plw_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Angkansa sinugiran ye sebarang memegtitiyeg duntin in, kwan ye, ‘Isiaꞌ myu dut kenye ating dublun in, pegketbes ibgeyaꞌ myu dut maya sempuluꞌ dublun in.’ ");
INSERT INTO plw_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Kwan dye, ‘Surutan, maya ne tuꞌ kenye sempuluꞌ dublun in.’ ");
INSERT INTO plw_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Indyari sambung et surutan in, kwan ye, ‘Dut sebarang mekedyari pengendelan, kenye, atin pepengendelan banar; segwaꞌ sebarang diki mepengendelan et misan kisek-kisek, atin kisek pinengandel kenye isien nega. ");
INSERT INTO plw_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Segwaꞌ bitaꞌ myu atuꞌ e sebarang kebanta ku neng mendiꞌ daken na ibuten dye. Pegketbes imeteyaꞌ myu dye dut elepan ku.’ ” ");
INSERT INTO plw_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Pegketbes et tuturan i Jesus et itueng beleybey e, nemenungul mengeꞌ pepengenaran peselundung ki Jesus pesurung dut lungsud et Jerusalem. ");
INSERT INTO plw_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ganang napet ye ne mengeꞌ lungsud et Betpage bekeꞌ lungsud et Betania, duntin atin pegngeranen dye et Bukid et mengeꞌ buaꞌ et Olibo, nengdaak si Jesus et duwang pepengenaran ye bekeꞌ negbilin et kwantin, kwan ye, ");
INSERT INTO plw_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Peglembus kew dut sembelaꞌ et kebenbenwanan tiꞌ, indyari baꞌ nekesled kew duntin mebiriꞌ myu maya pesisiget neng ibun et kuraꞌ, misan kasa ingga peꞌ nekuraan. Pegdateng myu dun bebariꞌ myu pegketbes bitaꞌ myu atue e. ");
INSERT INTO plw_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Na baꞌ maya mengingkut dimyu na kwanen dye, ‘Manu pegbebaran myu atin in?’ Indyari isugiraꞌ myu, ‘Maya lang purisnan et Begerar.’ ” ");
INSERT INTO plw_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Indyari, sebarang pinengdaak muna duntin in, nebiriꞌ dye samat sinugid nega dut kedye in. ");
INSERT INTO plw_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ganang pegbebebaran dye ne teyen ibun et kuraꞌ in, empuꞌ et kuraꞌ in nengingkut kedye, kwan ye, “Manu pegbebaran myu ibun et kuraꞌ ku in?” ");
INSERT INTO plw_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Indyari siminambag dye, “Kepurisnan itue et Begerar.” ");
INSERT INTO plw_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Pegketbes tinundan dye ne surung dut ki Jesus. Ganang nelempikan dye ne et kedyeng mengeꞌ repanan ampaꞌ dye pinekuraꞌ si Jesus. ");
INSERT INTO plw_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Dut dalan ganang derateng si Jesus, neng megkukuraꞌ kinelkaran dalan mengeꞌ taaw et kedyeng mengeꞌ repanan apang mengampun dye kenye dut pegtalib ye. ");
INSERT INTO plw_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Surung dye ne pesesedsad, teyeg dye dut Bukid et Olibo. Ganang mekabiꞌ net lungsud et Jerusalem, kineldaman et mengeꞌ pepengenaran ye neng pesusunud kenye in, timinagnaꞌ dye ne neglami-lami sampay nemegbantug dyeʼt mebasag dut Empuꞌ Banar, sabab et ginsaʼt mengeꞌ keliluꞌlilung mengeꞌ tendaꞌ naꞌ nebiriꞌ dye. ");
INSERT INTO plw_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Sinugid dye, kwan dye, “Bentugen tyu tiban itueng surutan naꞌ dinaak atuʼt kityu et Empuꞌ Banar. Begeyan ye kityu et kesenangan teyeg dut langit. Bentugen Empuꞌ!” ");
INSERT INTO plw_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Indyari, maya mengeꞌ pariꞌ naꞌ Pariseo pelelamud dut kineldaman, na negsugid ki Jesus, kwan dye, “Menunulduꞌ, bulagaꞌ peꞌ mengeꞌ pepengenaran mu in.” ");
INSERT INTO plw_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Sinambag i Jesus, “Sugiran ku kemyu, baꞌ dye petimesen, mengeꞌ batu atin ne megmara.” ");
INSERT INTO plw_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ganang megderateng dye ne dut lungsud et Jerusalem, mekepayag i Jesus ne ating lungsud, ampaꞌ ne siminiyak. ");
INSERT INTO plw_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Indyari kwan ye, “U! Baꞌ mekesewran mu lang teyen, baꞌ enu keilangan itueng eldew ampaꞌ mekepegbegey dimu et kesenangan! Segwaꞌ itue tiban petetaguꞌ dut penyek mu. ");
INSERT INTO plw_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Dumateng eldew mengeꞌ kebanta mu memuwat et mengeꞌ pinegparal-paral naꞌ mengeꞌ batu bekeꞌ pelibutan ke, sampay mesled ke bekeꞌ sigpiten ke pesembelaꞌsembelaꞌ. ");
INSERT INTO plw_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Mebungkar ke dut lugtaꞌ, bekeꞌ mengeꞌ taaw mu memematey, bekeꞌ metetegmunan et mengeꞌ dingding mu. Diki dye tindanan misan sembatung batu dut saliꞌsaliꞌ yeng batu, sabab diki mu inasip eldew et pegdateng et Empuꞌ banar dimu.” ");
INSERT INTO plw_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Pegketbes siminled si Jesus dut pengempuan naꞌ benwa, pinenempeg ye mengeꞌ pepelen in, kwan ye, “Ugad kew atuꞌ e! ");
INSERT INTO plw_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Sabab nesurat dut beres et Empuꞌ, kwan, ‘Benwa et Empuꞌ, benwa lang et pepenelenginan.’ Segwaꞌ inantang myu samat ‘Teteluan et mengeꞌ mengrerampas.’ ” ");
INSERT INTO plw_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Peldew-peldew aluꞌ i Jesus megtulduꞌ dut pengempuan naꞌ benwa. Segwaꞌ mengeꞌ pegibuten et mengeꞌ pariꞌ neng Pariseo, sampay mengeꞌ menunulduꞌ et Keseraan, bekeꞌ mengeꞌ pegibuten et mengeꞌ taaw, gaay dye na imeteyen si Jesus. ");
INSERT INTO plw_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Segwaꞌ diki dye mereꞌraliꞌ baalan atin, sabab mekansang mengeꞌ taaw memegkikingeg kenye banar, mendiꞌ mengeꞌ taaw malam misan sembatung beres i Jesus. ");
INSERT INTO plw_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Sembatung eldew ganang megtutulduꞌ si Jesus pasal et Menungang Abar teyeg dut Empuꞌ dut mengeꞌ taaw dut seled et pengempuan naꞌ benwa, indyari nepekabiꞌ kenye mengeꞌ pegibuteʼt mengeꞌ pariꞌ, bekeꞌ mengeꞌ menunulduꞌ et Keseraan, iba dye mengeꞌ megugurang. ");
INSERT INTO plw_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Kwan dye ki Jesus, “Isugiraꞌ damen baꞌ enung kepegbayaan angkan manu pegbuwaten mu itueng keginisan? Sinu negey dimu et kepegbayaan?” ");
INSERT INTO plw_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Indyari siminambag si Jesus kedye, kwan ye, “Na, meingkut ku gasi kemyu et sembatung ingkut. ");
INSERT INTO plw_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Isugiraꞌ myu daken pasal dut pegbewtismu i Juan dut mengeꞌ taaw, pikir myu ating kepegbeꞌbayaꞌ teyeg dut Empuꞌ dut langit etawa teyeg dut taaw lang?” ");
INSERT INTO plw_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Indyari nemegisun-isun mena mura dye siminambag, kwan dye, “Supama, baꞌ sugiren kay teyeg dut Empuꞌ dut langit, indyari sugiren ye damen, ‘Manu diki myu ya pegendelen?’ ");
INSERT INTO plw_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Segwaꞌ baꞌ sugiren tyu teyeg dut mengeꞌ taaw lang, meraliꞌ mengeꞌ taaw tuꞌ memakal ne et batu kityu, sabab andel dye si Juan sembatung tarus et Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Angkansa kwantin ne lang sinambag dye, kwan dye, “Kaya sewd kay baꞌ embe teyeg.” ");
INSERT INTO plw_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Indyari kwan i Jesus, “Megdemikian daken, diki ku gasi mesugid dimyu baꞌ enung kepegbayaan angkan manu pegbuwaten ku itueng ginis e.” ");
INSERT INTO plw_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Negtuturan nega si Jesus pasal et sembatung beleybey, kwan ye, “Maya sembatung taaw nengluwak dut kenyeng ubasan, indyari pinekpetan ye dut mengeꞌ mengunguma, pegketbes siminurung dut merayung lungsud, segwaꞌ mekutkwitan ya duntin. ");
INSERT INTO plw_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Pegdatek pemumuaan nengdaak et sembatung uripen ye na sumurung dut pinenektakan tiꞌ supaya mengisiꞌ et bagiꞌ et empuʼt luluwakan et ubas dut kenyeng mengeꞌ mengunguma. Segwaꞌ, pegdateng dun et ating dinaak, pinegpupukul dye sampay pineuliꞌ dye na kaya lang misan sembatung bibit. ");
INSERT INTO plw_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nengdaak gasi et ibang uripen, segwaꞌ kwantin nega neinabu kenye. Pinegpupukul dye ya, inalew sampay pineuliꞌ et kaya lang bibit. ");
INSERT INTO plw_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Segwaꞌ nengdaak nega peuliꞌ, atin ne iketlung pegdaak ye. Megdemikian, limimbi net atin neinabu, sabab pinetewanan dye ne ya sampay tinimbag dye ya peliwan. ");
INSERT INTO plw_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Indyari sinugid et empuʼt luluwakan in, ‘Enu ne buwaten ku tuꞌ? A, sewd ku ne, yegang ku ne lang daaken ku, pegmerganen ku neng banar in. Na baꞌ ya ne in meraliꞌ kaluꞌ kilelanen dye ne ya.’ ");
INSERT INTO plw_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Segwaꞌ ganang nebiriꞌ et mengeꞌ mengengeradya yegang et empuʼt luluwakan in, nemegisun-isun dye et samat kwantin, kwan dye, ‘Itue ne leyd, mempuan ye.’ Indyari kwan dye, ‘Imeteyen tyu ne lang yegang in supaya ginsaʼt pemusakaan ye, kityu ne mekepusakaꞌ ginsan.’ ");
INSERT INTO plw_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Angkansa pineliwan dye ya dut luluwakan et ubas ampaꞌ dye ne ya inimatey.” Na, sinugid i Jesus, “Pegketbes, enu ne buwaten et empuʼt luluwakan pasal et mengeꞌ mengunguma in? ");
INSERT INTO plw_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Duntinen ye dye, pegketbes imeteyen ye ginsaʼt mengeꞌ mengengeradya in, indyari ipemgey et Empuꞌ ne ginsaʼt luluwakan in dut mengeꞌ ibang taaw.” Ganang nekingeg itue et mengeꞌ taaw, kwan dye, “Endey lang teyen samat kwantin meinabu.” ");
INSERT INTO plw_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Timinengteng si Jesus kedye bekeꞌ nengingkut, kwan ye, “Na, enu ingin bersen pasal ating sinurat tagnaꞌ dut Beres et Empuꞌ? ‘Ating usuk naꞌ inendian et mememaal et benwa, atin key negmendyaring penued et benwa.’ ");
INSERT INTO plw_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“Sebarang tegsimbakud set penued naꞌ atin melipeng banar, segwaꞌ sebarang medeganan et atin penued merunsak.” ");
INSERT INTO plw_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Indyari mengeꞌ menunulduꞌ et Keseraan i Moises bekeꞌ mengeꞌ pegibuten et mengeꞌ pariꞌ nesewran dye na dye pegsisindiren et beleybey, angkansa pegsipian dye ne si Jesus banar, supaya malew dye ne ya et meraliꞌ. Segwaꞌ memegtakut dye dut mengeꞌ mekansang taaw megibut kenye. ");
INSERT INTO plw_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Supaya mesipian et mengeꞌ pegibuten et pariꞌ bekeꞌ mengeꞌ menunulduꞌ et Keseraan et menunga si Jesus, negpebibit dye et mengeꞌ meninipiꞌ na megpebeꞌbaluꞌ dye na, dye mengeꞌ menunungang mengeꞌ taaw. Binwat dye itue supaya malew dye si Jesus dut mengeꞌ bebresen ye, supaya ilugut dye dut basag bekeꞌ kepegbayaan et Gobernador teyeg Roma. ");
INSERT INTO plw_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Angkansa, mengeꞌ meninipiꞌ nengingkut ki Jesus, kwan dye, “Menunulduꞌ, sewd kay sebarang metitignaꞌ atin lang ipesudsugid mu. Diki myu pegtimpangen mengeꞌ taaw angkan ipegtulduꞌ myu sebarang keberbenaran naꞌ dalan et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Sugat takuꞌ na kami megbayad et buwis dut ki Surutan Sesar, etawa diki sugat?” ");
INSERT INTO plw_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Segwaꞌ pegsesewren i Jesus kedyeng mereraat naꞌ pegpipikiren, indyari kwan ye, ");
INSERT INTO plw_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Heꞌ, begeyiꞌ myu aku et sembatung siin neng denaryo. Kinung pataꞌ itue bekeꞌ kinung ingaran nekesurat atue e?” ");
INSERT INTO plw_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","“Ki Sesar,” kwan dye. Indyari kwan i Jesus dut kedye, “Baꞌ kwantin ibgeyaꞌ myu dut ki Surutan Sesar sebarang ki Surutan Sesar, bekeꞌ igbeyaꞌ myu dut Empuꞌ sebarang dut Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Kaya lang mekeisian dye et salaꞌ si Jesus misan enu nega buwaten dye, sabab kenyeng mengeꞌ pegebresen dut elepaʼt mengeꞌ taaw. Bekeꞌ pemegliluꞌ dye banar dut kenyeng sambag. Angkan, kaya dye ne nemekegibek. ");
INSERT INTO plw_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Naꞌ maya ibang mengeꞌ tawʼt Saduseo, pemegsugid dye na kaya ne taaw pegbiyag nega peuliꞌ dut Empuꞌ dut langit. Angkan dye diminuntin dut ki Jesus supaya mengingkut kenye. ");
INSERT INTO plw_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Menunulduꞌ,” kwan dye, “tagnaꞌ tiꞌ beres et Empuꞌ sinurat i Moises damen, kwan, ‘Na, baꞌ mematey ukaꞌ in bekeꞌ metirengan ye esawa ye et kaya nemegyegangan, yeng tipused et lelaki in atin gasi keilangan pesubliꞌ mengesawa kenye supaya maya tutusan dye sabab dut tipused ye.’ ");
INSERT INTO plw_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Segwaꞌ pitu dyeng memegtipused. Ukaꞌ in nengesawa segwaꞌ kaya nemegyegangan seked lang natey. ");
INSERT INTO plw_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Indyari inesawa gasi et sumunud neng tipused in ating libun. ");
INSERT INTO plw_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Pegketbes inesawa gasi et pengetlu in, megdemikian kwantin ginsan neinabu dut pitung mengeꞌ memegtitipused in. Nemematey dye ginsan kaya lang nemegyegangan dye. ");
INSERT INTO plw_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ketepus-tepusan natey ne gasi libun in. ");
INSERT INTO plw_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Na, tiban, dut pegbiyag peuliꞌ et mengeꞌ natey, sinu kedye megmendyaring esawa et libun in, sementaraꞌ pitu in nesawa ye ginsan?” ");
INSERT INTO plw_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Indyari siminambag si Jesus, kwan ye, “Mengeꞌ taaw et itueng penewnan pelibun pelelaki pemengesawa dye ");
INSERT INTO plw_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Segwaꞌ sebarang keruntin dut langit, atin teupen dut ating penewnan pegdatek pegbiyag peuliꞌ teyeg et kemeteyan, kaya dye ne pemengesawa. ");
INSERT INTO plw_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Bekeꞌ diki dye ne matey, sabab mesiringan dye samat mengeꞌ dereakan ne et Empuꞌ. Dye in mengeꞌ yegang et Empuꞌ Banar, sabab dye negbiyag peuliꞌ dut mengeꞌ patey. ");
INSERT INTO plw_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Na, itue pesebenaran dut tuturan pasal dut megdedleg naꞌ kayu. Atin beres et Empuꞌ sinurat i Moises. Misan si Moises pinepesewd duntin na mengeꞌ patey megbiyag nega peuliꞌ, sabab tiningkag ye Empuꞌ, Empuꞌ i Abraham, Empuꞌ i Isaak, bekeꞌ Empuꞌ i Jakob ");
INSERT INTO plw_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Empuꞌ diki lang Empuꞌ et mengeꞌ patey, segwaꞌ Empuꞌ et mengeꞌ biyagan, sabab dut kenye biyagan ginsan.” ");
INSERT INTO plw_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Na maya senung menunulduꞌ et Keseraan siminambag, kwan dye, “Menunga sambag mu, Menunulduꞌ.” ");
INSERT INTO plw_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Angkansa kaya ne misan sembatu nega nengurem mengingkut ki Jesus. ");
INSERT INTO plw_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Indyari kwan i Jesus dut kedye, “Enukwan mesugid dye naꞌ ating Kristo piniliꞌ et Empuꞌ memegbeg, ya upuꞌ i Surutan Dabid tagnaꞌ? ");
INSERT INTO plw_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Misan si Dabid, beres ye nesurat dut buuk et Mengeꞌ Kanta, kwan ye, ‘Empuꞌ negsugid dut daken Gerar ku, marung ke dut tampaꞌ kewanan ku, ");
INSERT INTO plw_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","seked mebuwat ku dimung mengeꞌ kebanta meetagan et tiked mu.’ ");
INSERT INTO plw_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“Naꞌ tiningkagan i Surutan Dabid atin Kristo et ‘Gerar ku.’ Enukwan ya megmendyaring upuꞌ i Dabid?” ");
INSERT INTO plw_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Sasat memegkikingeg nega mengeꞌ taaw dut kenye, negberes si Jesus dut kenyeng mengeꞌ pepengenaran, kwan ye, ");
INSERT INTO plw_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ingetiꞌ myu sebarang mengeꞌ menunulduꞌ et Keseraan. Geygaay dye megbadyuꞌ et sulung ampaꞌ dye manew, bekeꞌ ingin dye na dye tyuman et mengeꞌ taaw dut tetebuan. Gay dye gasi mengeꞌ eerungan et mengeꞌ metetaas na dut mengeꞌ pengempuen na benwa tyu neng mengeꞌ tawʼt Judio, bekeꞌ mengeꞌ peguntebien naꞌ mengeꞌ eerungan dut mengeꞌ pegkenkaan. ");
INSERT INTO plw_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Diki lang et atin, sampay pegrundingan dye kebiyagan et mengeꞌ nebebeluan. Pegketbes dye menelangin naꞌ mebubuwat dut Empuꞌ, supaya ipebiriꞌbiriꞌ dut mengeꞌ taaw ne dye menununga keradya dye. Angkansa ating mengeꞌ taaw lebing mebegat nega idusa kedye.” ");
INSERT INTO plw_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Na, dut seled et benwa pengempuan naꞌ Templo pegseyek i Jesus, nebiriꞌ ye mengeꞌ taaw neng mentiriꞌ nenunuꞌ et kedyeng bebgey dut tungtuung naꞌ pegsunuan et mengeꞌ pirak naꞌ pegbegey dut Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Indyari, nebiriꞌ ye gasi sembatung miskin banar neng libun ne nebeluan nenunuꞌ et ganang duruwang siin lang. ");
INSERT INTO plw_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Indyari kwan i Jesus, “Sugiran ku kemyu et keberbenaran, itueng libun naꞌ miskin neng nebeluan nenunuꞌ et lebi dut kedye ginsan. ");
INSERT INTO plw_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Sabab ginsaʼt itueng mengeꞌ ibang taaw, pinemgey dye neglebi lang dut kedyeng mengeꞌ mentiriꞌ; segwaꞌ ya, misan ne miskin, sinunuꞌ ye ginsaʼt kenyeng ikebiyag.” ");
INSERT INTO plw_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Sengmenung mengeꞌ taaw pemengdayew pasal dut benwa pegpengempuan naꞌ Templo. Pegliluen dye ating mengeꞌ inukir-ukiran naꞌ batu bekeꞌ mengeꞌ penggayun naꞌ bebgey dut Empuꞌ. Segwaꞌ kwan i Jesus, ");
INSERT INTO plw_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Sebarang mengeꞌ nebibiriꞌ myu in, dumateng timpu na kaya misan sembatung batu na petitimbew dut sesaliꞌ yeng batu, ginsaʼt atin ipererban.” ");
INSERT INTO plw_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","“Menunulduꞌ,” kwan dye, “Ingyan itue meinabu? Bekeꞌ enu tendaꞌ na itue meinabu?” ");
INSERT INTO plw_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Indyari siminambag si Jesus, kwan ye, “Peginget-inget kew, supaya diki kew mawam. Sabab mekansang matuꞌ betengen dye ingaran ku. Na ekuen dye, kwanen dye, ‘Aku tuꞌ Kristo!’ bekeꞌ, ‘Ating timpu mekabiꞌ ne mepapas dunyaꞌ!’ Na asiꞌasiꞌ banar, kas kewʼt ibut kedye. ");
INSERT INTO plw_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Na baꞌ kekingeg kewʼt mengeꞌ gira bekeꞌ banta, kas kewʼt takut, sabab itueng pesalan meinabu mena, segwaꞌ baꞌ pasal dut kepuspusan itueng penewnan, ingga peꞌ dumateng megtuy.” ");
INSERT INTO plw_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Pegketbes sinugid i Jesus kedye, kwan ye: “Bangsa megatu dut saliꞌ ye Bangsa, penggewman megatu dut saliꞌ ye penggewman. ");
INSERT INTO plw_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Yumegyeg dut lungsud, kelang urap bekeꞌ damat dut iba-ibang lungsud, bekeꞌ mengeꞌ ketettakut neng mengeꞌ meinabu bekeꞌ kelang mengeꞌ tendaꞌ teyeg dut langit. ");
INSERT INTO plw_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Segwaꞌ mura meinabu ginsaʼt itueng ginis, pengelewen kew sampay peniksaen. Indyari igbey dye kemyu dut mengeꞌ pegempuen naꞌ benwa tyu neng mengeꞌ tawʼt Judio ampaꞌ ukumen, sampay ipepirisu dye kemyu. Bekeꞌ bibiten kew dut elepaʼt mengeꞌ surutan sampay Gobernador apang ukumen sabab lang et pegandel myu daken. ");
INSERT INTO plw_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Segwaꞌ liwanan ye itue, na kemyu mekepeabar kedye pasal daken. ");
INSERT INTO plw_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Segwaꞌ, kasiꞌ myu pegrasiꞌ baꞌ enu ipengdiawab myu pasal dut dimyung diri. ");
INSERT INTO plw_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Sabab aku megey dimyu et bebresen bekeꞌ kesesewran, supaya misan sembatung kebanta myu, diki dye ne kedawa etawa kepeilu. ");
INSERT INTO plw_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Misan mengeꞌ kegunggurangan myu, dye menumbung dimyu. Diki lang et dye in, sampay mengeꞌ ketipusdan myu, mengeꞌ bilaꞌ myu. Na dye megpepatey et senu dimyu. ");
INSERT INTO plw_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ginsaʼt mengeꞌ taaw mengiseg dimyu sabab lang dut daken. ");
INSERT INTO plw_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Segwaꞌ misan sembatung buek myu, diki lang megabut. ");
INSERT INTO plw_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Na baꞌ kesandal kew, maya mepulus myu biyag dut langit kaya keskeran.” ");
INSERT INTO plw_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Na baꞌ mebiriꞌ myu ne Jerusalem nepelibutan net mengeꞌ kesundeluan, retiaꞌ myu ne diki mekwit ipebungkar ating lungsud. ");
INSERT INTO plw_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Na baꞌ negkwantin ne, mengeꞌ tawʼt Judea keilangan sumekaliꞌ sumurung dut kebudbukiran. Bekeꞌ sebarang mengeꞌ taaw dut seled negaʼt lungsud keilangan ne memengliwan, bekeꞌ endey ne sumled et lungsud sebarang dut kebenbenwanan. ");
INSERT INTO plw_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Sabab timpu et pegtiksaꞌ diminateng ne, na atin ne ketumanan et ginsaʼt nesurat dut seled Kesuratan et Empuꞌ Banar. ");
INSERT INTO plw_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ating eldew keingasiꞌingasiꞌ sebarang mengeꞌ libun naꞌ megebteng bekeꞌ mengeꞌ pegdururuan! Sabab kelabay mengeꞌ tawʼt Judio et kelang keliyutan dut lungsud, bekeꞌ iseg et Empuꞌ atu dut mengeꞌ taaw naꞌ itue. ");
INSERT INTO plw_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Senu kedye matey sabab et mengeꞌ keterman, sampay mengeꞌ iba pemungpungen dye bekeꞌ bibiten dye samat mengeꞌ nepipirisu in dut ginsaʼt lungsud. Ating Jerusalem rumbaken et mengeꞌ leing-leing taaw seked timpu et mengeꞌ leing-leing taaw tebes ne.” ");
INSERT INTO plw_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Maya mengeꞌ tendaꞌ mebiriꞌ dut segit, bulan, bekeꞌ mengeꞌ bituen. Dut dunyaꞌ, mengeꞌ leing-leing taaw memenyak bekeꞌ mebebenteng dye sabab et deguk et mengeꞌ derekelang gumbang. ");
INSERT INTO plw_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Mengeꞌ taaw melelpusaʼt takut sabab dut mengeꞌ ketetekutan, bekeꞌ megsusa dut baꞌ enu negang mengeꞌ meinabu dut sengkelingkepaʼt lungsud, sabab mengeꞌ sunuꞌ et lelengew gumleng. ");
INSERT INTO plw_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Dut ating masa, mebiriꞌ dye aku, atin Yegang et Taaw, na dut inarak, megderateng na maya kepengdyarian bekeꞌ kelang ketaasan ku. ");
INSERT INTO plw_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Na baꞌ tuminagnaꞌ ne meinabu itueng ginis, tumyeg kew bekeꞌ tumingaraꞌ mengeꞌ ulu myu, sabab mekabiꞌ ne dimyung kelkatan.” ");
INSERT INTO plw_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Indyari tinuturan i Jesus itueng beleybey, kwan ye, “Seyekiꞌ myu ating puuʼt igus, bekeꞌ mengeꞌ ibang puuʼt kayu in. ");
INSERT INTO plw_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Na baꞌ megdeun bagu ne, mesewran myu na megkekabiꞌ ne pemulagan. ");
INSERT INTO plw_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Megdemikian, baꞌ mebiriꞌ myu ne na meinabu ne itueng ginis, sewd myu ne na mekabiꞌ ne gasi pengmilikan et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Sugiran ku kemyu et keberbenaran, meinabu mena ginsaʼt itueng ginis mura memematey ginsaʼt taaw pebibiyag tiban. ");
INSERT INTO plw_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Langit bekeꞌ dunyaꞌ mepapas, segwaꞌ daken neng bebresen, diki lang mepapas.” ");
INSERT INTO plw_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Segwaꞌ, meginget-inget kew, kaluꞌ mebegatan pusuꞌ myu et kenepsuan, peglangu-langu, bekeꞌ mengeꞌ kesesewan et pikiran. Sabab kaluꞌ ating emuring eldew et pegukum et Empuꞌ diki myu pegsesewren, samat bingkasan kewʼt baweg. ");
INSERT INTO plw_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Sabab atin dumateng dut ginsaʼt meglelegdeng et sengkinlebaʼt lungsud, na kaya misan sinu keilag. ");
INSERT INTO plw_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Angkansa keilangan daran kew minget. Subaliꞌ kew daran megpenalang dut Empuꞌ, supaya metengkisan myu ginsaʼt meinabu, supaya ketiyeg kew et kaya leew dut elepan ku, Yegang et Taaw.” ");
INSERT INTO plw_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Eldew-peldew daran pegtulduꞌ si Jesus dut pengempuan naꞌ benwa. Indyari, pegdatek gebi megliwan pesurung dut Bukid et mengeꞌ Olibo, untin ne pegeldewan kenye. ");
INSERT INTO plw_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Meriklem nega banar mengeꞌ taaw megduntin dye dut pengempuan naꞌ benwa, apang mengingeg et tulduꞌ i Jesus kedye. ");
INSERT INTO plw_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Tiban megkekabiꞌ ne Pegkenkaan et Bengbang na kaya Pikembang na pegngeranen et Neketalib. ");
INSERT INTO plw_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Indyari mengeꞌ pegibuten et mengeꞌ pariꞌ, bekeꞌ mengeꞌ menunulduꞌ et Keseraan i Moises megegnaꞌ et menungang timpu supaya mepatey dye si Jesus et taguꞌ, temed memegtakut dye dut mengeꞌ mekansang taaw. ");
INSERT INTO plw_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Indyari siminaleb si Seytan dut ki Judas, na pegngeranen gasi et Iskariote. Na ya sembatu dut sempuluꞌ duwa pepengenaran i Jesus. ");
INSERT INTO plw_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Pegketbes, siminurung si Judas dut pegibuten et mengeꞌ pariꞌ, bekeꞌ mengeꞌ pegibuten et mengeꞌ mengdidyaga dut pegpengempuan templo naꞌ benwa, supaya mengupakat kedye baꞌ enukwan ye ipegdagang si Jesus kedye. ");
INSERT INTO plw_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Neksanan dye banar bekeꞌ nemegsulut-sulut dye na si Judas begeyan dye et pirak. ");
INSERT INTO plw_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Nesdengan ne si Judas pegketbes atin, sembatu mene pegtetegeyen ye timpu, supaya mepalew ye si Jesus dut kaya lang kineldamaʼt mengeꞌ taaw. ");
INSERT INTO plw_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Indyari diminateng ne eldew et Kenkaan et Bengbang na kaya Pikembang. Pegkaꞌ isien dye ne ibun et bibili neng isimayaꞌ dut Empuꞌ sabab et Kenkaan et Neketalib. ");
INSERT INTO plw_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Dinaak i Jesus si Pedro bekeꞌ si Juan, na samat kwantin pemilin ye, kwan ye, “Ireꞌ panew kew kityu, bekeꞌ penyapaꞌ myu kityu supaya kekaan tyu et Kenkaan et Neketalib tuꞌ.” ");
INSERT INTO plw_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","“Embe gaay mu na penyapan kay et atin in?” kwan dye. ");
INSERT INTO plw_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Indyari kwan i Jesus, “Pegseled myuʼt lungsud, maya sembatung lelaki na mesusup myu na megpepsan et siburan na maya danum. Ating taaw ibutiꞌ myu, seked dut baꞌ embeng benwa seldan ye. ");
INSERT INTO plw_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Pegdateng dun, isugiraꞌ myu dut empuʼt benwa in, kwanaꞌ myu, ‘Negpeingkut damen Menunulduꞌ baꞌ embe kunuꞌ atue bilik et mengeꞌ mengungumbaley, supaya kanan ye et Kenkaan et Neketalib iba ye, kaming mengeꞌ pepengenaran ye?’ ");
INSERT INTO plw_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Indyari turunan ye kemyu dut dibuwat et kelang bilik, panyap ne mengeꞌ kegemitan. Indyari dun, kew ne megpanyap.” ");
INSERT INTO plw_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Indyari nepanew dye ne, pegdateng dye dun nebiyanan dye ginsaʼt sinugid kedye i Jesus in. Angkansa, nepanyap dye pasal lang dut Kenkaan et Neketalib. ");
INSERT INTO plw_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ganang napet ne timpu, si Jesus bekeꞌ mengeꞌ pepengenaran ye, memegampang ne dut kekanan. ");
INSERT INTO plw_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Indyari, kwan ye dut kedye, “Geygaay ku ne banar na mengaan et Kenkaan et Neketalib, na iba ku kemyu, mura ku kelabay et keliyutan. ");
INSERT INTO plw_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Sabab isugid ku dimyu, diki ku ne kekaan peuliꞌ samat itue e, seked metuman banar itue tantung retian ye dut pengmilikan et Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Pegketbes, meisiꞌ i Jesus sawan, ampaꞌ ne pineselematan ye dut Empuꞌ Banar ating sawan. Pegketbes kwan ye, dut mengeꞌ pepengenaran ye, “Kewaaꞌ myu itue, indyari pegbenbegiaꞌ myu minum. ");
INSERT INTO plw_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Sabab isugid ku dimyu, sumked ne tiban diki ku ne keinum peuliꞌ et duruꞌ et buaꞌ et ubas, seked dumateng pengmilikan et Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Pegketbes, nengisiꞌ gasi et bengbang, ampaꞌ ne negpeselamat dut Empuꞌ. Indyari, pinegrekrepik i Jesus, pegketbes binggey ye ne dut kedye, kwan ye, “Itue antangaʼt bilug ku na binggey et dimyu. Na, buwataꞌ myu itue tendaꞌ et pengrendem myu daken.” ");
INSERT INTO plw_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Megdemikian gasi, pegketbes et pengmepunan, nisiꞌ gasi si Jesus et sawan, kwan ye, “Itueng inuman tendaꞌ et bagung pinegsulutan et Empuꞌ bekeꞌ ketaawan et duguꞌ ku, na binuak sabab dut dimyu. ");
INSERT INTO plw_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Birinaꞌ myu, segwaꞌ maya iba ku pengaan atueʼt lemisaan, neng megdagang daken. ");
INSERT INTO plw_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Aku, ating Yegang et Taaw, matey megtuy sabab atin pinanduꞌ et Empuꞌ. Segwaꞌ keingasiꞌingasiꞌ ating taaw na mengdagang daken.” ");
INSERT INTO plw_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Indyari, tinegnanan dye ne megsiingkut-ingkutan na baꞌ sinu kedye memuwat et kwantin in ki Jesus. ");
INSERT INTO plw_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Indyari maya gasi liminiwan pegdawa-dawa dye pasal baꞌ sinu kedye metaas. ");
INSERT INTO plw_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Indyari, kwan i Jesus kedye, “Mengeꞌ surutan et mengeꞌ leing-leing mengeꞌ taaw, atin mengeꞌ pegibuten et ginsan. Bekeꞌ sebarang maya kepegbeꞌbayaꞌ et mengeꞌ taaw, gay dye mesugid et mengeꞌ taaw ‘Meketabang dye et bangsa’. ");
INSERT INTO plw_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Segwaꞌ dimyu endey samat kwantin. Erapun, sebarang pinekemetaas dimyu, ya mantang samat isek-isek neng yengyegang. Bekeꞌ sebarang pegibuten, ya mantang samat tetehagen. ");
INSERT INTO plw_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Segwaꞌ sinu ating metaas, ating megampang dut lemisaan etawa ating pemeruri kenye? Diki be ating megampang dut lemisaan? Segwaꞌ diki kwantin dut daken. Nebiriꞌ myu aku sama ku net tetehagen dut pinegketngaan myu. ");
INSERT INTO plw_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Kemyu, iba ku na timinatas dut mengeꞌ pegsulay neng nelebayan ku. ");
INSERT INTO plw_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Bekeꞌ aku megey dimyu et sembatung pengmilikan ampaꞌ dimyu pemegbeg, samat pengmilikan neng binggey et Amaꞌ ku dut daken ampaꞌ pemegbeg. ");
INSERT INTO plw_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Supaya kemyu kekaan bekeꞌ keinum dut lemisaan ku na dut pengmilikan ku dut langit. Bekeꞌ marung kew dut mengeꞌ metaas naꞌ eerungan. Supaya kemyu, mengukum dut sempuluꞌ duwa na pengkataʼt bangsa et Israel.” ");
INSERT INTO plw_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simon, inangat i Seytan na sulayan ke samat pegtaap et begas apang mepiliꞌ in. ");
INSERT INTO plw_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Segwaꞌ negpenalang ku dut Empuꞌ pasal dimu, na dimung pengandel diki lang meraag. Na baꞌ ikew kepeuliꞌ ne, ipebesagaꞌ pegandel et mengeꞌ iba mung pepengenaran.” ");
INSERT INTO plw_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Segwaꞌ siminambag si Simon, kwan ye, “Begerar, timbes ku ne nemikir, mibut ku dimu misan dut pipirisuan bekeꞌ dut kepeteyan.” ");
INSERT INTO plw_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Siminambag si Jesus, kwan ye, “Isugid ku dimu Pedro, mura sibantuꞌ memaluꞌ lumbuꞌ, meketlu mu ne aku pinesunguan na kwanen mu na diki mu aku kilala.” ");
INSERT INTO plw_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Indyari nengingkut si Jesus kedye, kwan ye, “Kwit pegdeaken ku kemyu, kaya lang sutsuput myu, retrambit etawa mengeꞌ tempaꞌ, kinurang kew be?” “Kaya lang!” sambag dye. ");
INSERT INTO plw_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Indyari sinugiran i Jesus ne dye, kwan ye, “Segwaꞌ tiban, baꞌ maya sutsuput myu bekeꞌ retrambit, bibitaꞌ myu ne. Na baꞌ kaya lang kelang tukew myu, ipegelnaꞌ myu dimyung repanan, pegketbes, mengelen kew et sembatung tukew. ");
INSERT INTO plw_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Angkansa sinugid ku dimyu, subaliꞌ metuman ne atin sinurat dut Kesuratan et Empuꞌ Banar. Kwan ye, ‘Temed, pinebayaꞌ ya dut mengeꞌ meyeyaat taaw.’ Angkansa nesurat mawaꞌ dut daken, bekeꞌ netuman dye ne tiban.” ");
INSERT INTO plw_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Indyari mengeꞌ pepengenaran ye negberes ki Jesus, kwan dye, “Birinaꞌ Begerar, itue ne e, duwang mengeꞌ tukew.” Kwan i Jesus, “Mekedyari ne atin.” ");
INSERT INTO plw_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Megsurung si Jesus dut Bukid et mengeꞌ Olibo samat sene nega in, bekeꞌ gasi sampay mengeꞌ pepengenaran ye megibut kenye duntin. ");
INSERT INTO plw_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Pegdateng ye duntin, kwan ye dut kedye, “Peningkag kew dut Empuꞌ supaya diki meraag kew et mengeꞌ tuksuꞌ.” ");
INSERT INTO plw_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Indyari nepereꞌrayuꞌ ne si Jesus dut kedye. Rayuꞌ ye maya meraliꞌ meptaʼt sengkebekalan et batu, ampaꞌ ne siminelukud pegketbes negpenalang dut Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Kwan i Jesus, “Amaꞌ dut langit, baꞌ megaay ke teyen, ugaraꞌ itueng keliyutan megderateng daken. Segwaꞌ diki teyeg dut gaay ku, erapun metuman gaay mu nega in.” ");
INSERT INTO plw_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Indyari nepebiriꞌ kenye sembatung dereakan et Empuꞌ teyeg dut langit, supaya ipebasag ya. ");
INSERT INTO plw_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Indyari ganang mekesusa ne banar pikiran ye, lebi net atin siminurug ne banar pegpenelang ye dut Empuꞌ, seked-seked linget ye sama meneʼt duguꞌ neng megtetaras dut lugtaꞌ. ");
INSERT INTO plw_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Pegkaꞌ neketbes ne negpenalang, nepeuliꞌ ne si Jesus dut mengeꞌ pepengenaran ye. Neretnganan ye na memegigaꞌ dye ne sabab lupug et rupuk. ");
INSERT INTO plw_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","“Manu megigaꞌ kew?” ingkut i Jesus dut kedye, “Ireꞌ pegbekaya kew ne bekeꞌ pegpenelang kew dut Empuꞌ supaya diki kew meraag et tuksuꞌ.” ");
INSERT INTO plw_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Sasat megbebres nega si Jesus, kineldaman nemengdateng ne. Indyari, si Judas, na sembatu dut sempuluꞌ duwang pepengenaran, ya ne penginunaan dut kedye. Pinekebian ye si Jesus supaya mengarek dut kenye. ");
INSERT INTO plw_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Segwaꞌ si Jesus nengingkut kenye, kwan ye, “Judas, ipegdagang mu be aku, Yegang et Taaw, dut sembatung arek?” ");
INSERT INTO plw_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ganang nebiriꞌ et mengeꞌ pepengenaran i Jesus na kwantin ne neinabu, kwan dye, “Begerar, tigbasen kay ne dye?” ");
INSERT INTO plw_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Indyari maya ne sembatu kedye neketigbas dut sembatung uripen et metaas naꞌ pariꞌ, nesampal kewanan neng telinga ye. ");
INSERT INTO plw_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Segwaꞌ kwan i Jesus, “Tengewiꞌ ne atin!” Ampaꞌ ne, dimpen ye telinga et uripen in, indyari megtuy ne negulinan. ");
INSERT INTO plw_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Indyari negberes si Jesus dut mengeꞌ pegibuteʼt pariꞌ, bekeꞌ mengeꞌ pegibuten et mengeꞌ dyagaʼt benwa dut pegpengempuan naꞌ Templo benwa bekeꞌ dut mengeꞌ megurang naꞌ nemenurung dut ki Jesus supaya mengalew kenye, sugid i Jesus kedye, “Aku be pegibuten et mengeꞌ mengrerampas, angkan manu nibit kew ne et mengeꞌ keterman sampay mengeꞌ pupukul? ");
INSERT INTO plw_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Eldew-peldew pemegbeꞌbayaꞌ tyu dut seled et pegpengempuan naꞌ benwa, kaya myu aku pegsegkewen. Segwaꞌ tiban ne timpu myu banar neng pinanduꞌ et Empuꞌ, apang malew myu aku. Itue timpu et pegibuten et mengeꞌ mereraat neng diwata sampay kepegmilik ne kelingban.” ");
INSERT INTO plw_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Sinagkew dye si Jesus, pegketbes binibit dye ya dut seled benwa et metaas naꞌ pariꞌ. Indyari nibut nega si Pedro dut kenye, segwaꞌ dut mereꞌrayuꞌ lang. ");
INSERT INTO plw_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ganang pemegnengnarang mengeꞌ ibang taaw neng nemegsesarung ne dut tengaʼt legwas et benwa et metaas naꞌ pariꞌ, memegarung dye ginsan, peiibut si Pedro kedye. ");
INSERT INTO plw_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Indyari maya sembatung uripen naꞌ libun duntin dut pegnengnerangan tiꞌ. Dut telang et apuy pegtengtengan ye banar si Pedro, indyari, kwan ye, “Itueng taaw iba i Jesus!” ");
INSERT INTO plw_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Segwaꞌ negpeilu si Pedro, kwan ye, “Libun diki ku ya kilala.” ");
INSERT INTO plw_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ingga peꞌ nekwit et atin, maya gasi sembatung lelaki nekepangling kenye, kwan ye, “Ikew nega sembatung iba dye!” Segwaꞌ keruwa ne siminambag si Pedro, kwan ye, “Lelaki dein lang aku!” ");
INSERT INTO plw_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Indyari maya ne meraliꞌ seng lisag kekwiten ye, maya gasi nekepangling kenye, kwan ye, “Diki megsalaꞌ, itueng taaw naꞌ itue iba nega i Jesus, sabab ya tawʼt Galilea.” ");
INSERT INTO plw_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Indyari ketlu ne siminambag si Pedro, kwan ye, “Lelaki, kaya sewd ku baꞌ enu pegbebresen mu in!” Sasat megbebres nega si Pedro, kiminerengek ne manuk. ");
INSERT INTO plw_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Indyari liminingew si Jesus, pegketbes tinengtengan ye si Pedro. Indyari nerendeman ne i Pedro pasal pinegberes i Jesus kenye sene tiꞌ, na kwan, “Mura sibantuꞌ kumerengek manuk, meketlu mu ne aku sunguan.” ");
INSERT INTO plw_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pagkaꞌ kwantin ne, liminiwan si Pedro, dun ne ya siminiyak banar. ");
INSERT INTO plw_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ating mengeꞌ lelaki naꞌ megtutunggu ki Jesus in, atin neguna nemelbengel bekeꞌ nemukul ki Jesus. ");
INSERT INTO plw_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Pinlengan dye mata i Jesus, ampaꞌ dye ne ingkuten, kwan dye, “Tekeraꞌ, sinu nemukul dimu?” ");
INSERT INTO plw_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Diki lang et atin sampay ginis neng penudiaꞌsudiaꞌ dye ki Jesus. ");
INSERT INTO plw_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Pegdatek simimbut ne eldew, mengeꞌ megurang et mengeꞌ tawʼt Judio, mengeꞌ pegibuteʼt mengeꞌ pariꞌ bekeꞌ menunulduꞌ et Keseraan nemegtimung-timung dye ne. Indyari pinetampar ne si Jesus dut kedye. ");
INSERT INTO plw_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Kwan dye ki Jesus, “Baꞌ ikew ating Kristo, isugiraꞌ damen.” Segwaꞌ siminambag si Jesus kedye, kwan ye, “Baꞌ isugid ku dimyu, diki kew lang gasi mengandel daken. ");
INSERT INTO plw_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Bekeꞌ baꞌ ingkuten ku kemyu, diki kew lang gasi sumambag. ");
INSERT INTO plw_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Segwaꞌ tihad tiban aku, neng Yegang et Taaw, marung ne dut tampaꞌ kewanan et kekinsegan naꞌ Empuꞌ dut Langit.” ");
INSERT INTO plw_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Indyari ginsan dye nengingkut dut kenye, kwan dye, “Baꞌ kwantin, ikew Yegang et Empuꞌ Banar dut langit?” Siminambag si Jesus, “Sugat kew kemyu negsugid, naꞌ aku ne tuꞌ.” ");
INSERT INTO plw_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Indyari kwan dye ginsan, “Manu nega menulus tyuʼt ibang pesebanar? Nekingeg tyu ne gasi dut kenye, sabab dut babaꞌ ye nega liniwanan.” ");
INSERT INTO plw_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Pegketbes nemeniyeg ne ginsaʼt nemegurung-urung in, ampaꞌ ne binibit si Jesus dut ki Gobernador Pilato. ");
INSERT INTO plw_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Pegdateng dun peginteksiren dye ne si Jesus, kwanaꞌ ne et sumbung dye in, “Itueng taaw nesipatan kay na ya pegtulduꞌ dut ginsaʼt bangsa na mengatu. Pegbulilien ye pasal dut pegbayad et buwis dut ki Surutan Sesar, bekeꞌ pegsugiren ye na ya kunuꞌ ating Kristo, sembatung surutan.” ");
INSERT INTO plw_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Angkansa iningkut i Pilato si Jesus, kwan ye, “Ikew ne be tuꞌ surutan et mengeꞌ tawʼt Judio?” Sambag i Jesus, “Banar samat pegsugiren mu in.” ");
INSERT INTO plw_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Indyari pinesewd i Gobernador Pilato dut mengeꞌ metaas naꞌ pariꞌ bekeꞌ dut mengeꞌ taaw, kwan ye, “Kaya mesebaban ku kenye supaya ya meretunat ukuman.” ");
INSERT INTO plw_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Segwaꞌ memegleges dye ga, kukwanaꞌ dye ne in, “Pegeriweraen dye ginsaʼt mengeꞌ tawʼt bangsa et Judea sabab dut kenyeng mengeꞌ ipegtulduꞌ. Tinegnanan ye dut bangsa et Galilea sampay ne nekapet atue e.” ");
INSERT INTO plw_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ganang nekingeg i Gobernador Pilato itue e, iningkut ye gasi si Jesus na baꞌ ya tawʼt Galilea. ");
INSERT INTO plw_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Pagkaꞌ netentuan ye ne na si Jesus seled kapet i Gobernador Herodes, pinelusu i Pilato si Jesus dut ki Herodes, segwaꞌ ating timpu si Herodes dut lungsud et Jerusalem. ");
INSERT INTO plw_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ganang nebiriꞌ i Gobernador Herodes si Jesus, neksanan ya banar, sabab nekwit ne gaay ye na mebiriꞌ si Jesus. Tihad negaʼt pegkesewd ye pasal kenye, na pegeerapen ye ne na mebiriꞌ si Jesus memuwat et keliluꞌlilung mengeꞌ tendaꞌ. ");
INSERT INTO plw_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Indyari iningkut i Herodes si Jesus et mekansang naꞌ ingkut, segwaꞌ kaya lang siminambag si Jesus. ");
INSERT INTO plw_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ating masa, mengeꞌ pegibuteʼt mengeꞌ pariꞌ bekeꞌ mengeꞌ menunulduꞌ et Keseraan memegtitiyeg duntin, pegsusumbung dye banar si Jesus et mebegat. ");
INSERT INTO plw_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Indyari pinegbelbenglan dye ne si Jesus sampay ininlelew ne de Gobernador Herodes bekeꞌ mengeꞌ kesundeluan ye. Pegketbes pinepekayan dye ya et mergaꞌ naꞌ pemekayan et surutan, mura pinelusu i Herodes peuliꞌ dut ki Pilato. ");
INSERT INTO plw_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Atin gang masa de Herodes bekeꞌ si Pilato nemegsutsulut ne, segwaꞌ sene tiꞌ memegbebanta dye. ");
INSERT INTO plw_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Indyari pinetingkag i Gobernador Pilato mengeꞌ pegibuteʼt mengeꞌ pariꞌ, mengeꞌ pegibuten, bekeꞌ mengeꞌ taaw. ");
INSERT INTO plw_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Indyari kwan ye dut kedye, “Itueng taaw binibit myu atuʼt daken sabab ya, pegsugiren myu na sembatung penulduꞌ dut mengeꞌ taaw supaya mengamuk. Segwaꞌ nesewran ku atuʼt elepan myu, na, kaya pesebaban pasal dut dimyung mengeꞌ penendes kenye. ");
INSERT INTO plw_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Misan si Gobernador Herodes, kaya lang nebiriꞌ ye salaꞌ i Jesus, angkan pineuliꞌ ye atuʼt kityu. Nebiriꞌ myu ne atin na kaya mebutbuwat ye supaya mepatut na ya medusa et ikematey. ");
INSERT INTO plw_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Angkansa, pelepsan ku ne lang ya et mekansang, pegketbes ipeliwan ku ne ya.” ");
INSERT INTO plw_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Sinugid i Pilato itue sabab kabaꞌkabaꞌ dumateng timpuʼt Kenkaan et Neketalib si Pilato pepeliwan et sembatung pirisu. ");
INSERT INTO plw_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Segwaꞌ nemegbensag net atin, nemegsaliꞌ, kwan dye, “Imeteyen itueng taaw! Segwaꞌ si Barabas ne lang ipeliwan.” ");
INSERT INTO plw_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Si Barabas nepirisu ating masa sabab ya nengamuk dut lungsud bekeꞌ nengimatey. ");
INSERT INTO plw_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Sabab et gaay i Pilato na ipeliwan si Jesus angkansa negberes gasi peuliꞌ. ");
INSERT INTO plw_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Segwaꞌ kaya ne memegtitinep mara dye, kwan dye, “Iransang dut krus, iransang dut krus, iransang dut krus!” ");
INSERT INTO plw_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Segwaꞌ negberes gasi si Pilato kedye, atin ne pengetlung ingkut ye, kwan ye, “Manu? Enung meraat na nebuwat i Jesus? Sabab daken kaya nesewran ku na ya medusa et ikematey. Angkansa pelepsan ku ne lang ya et mekansang, pegketbes ipeliwan ku ne ya.” ");
INSERT INTO plw_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Segwaꞌ masi-masi dye ga na pemegmara, kwan dye, “Subaliꞌ atin iransang dut krus!” Ketepus-tepusan, nengindaag mara dye nega in. ");
INSERT INTO plw_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Angkansa timinugut ne lang si Pilato pasal et pegayen dye in. ");
INSERT INTO plw_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Indyari pineliwan ye ne lang si Barabas, ating taaw naꞌ nepirisu sabab et nengamuk bekeꞌ nengimatey in. Segwaꞌ nilugut ne lang i Pilato si Jesus dut mengeꞌ sundalu supaya mebaal dye ne keiregan et mengeꞌ taaw, na iransang dut krus. ");
INSERT INTO plw_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ganang peglulusu ne et mengeꞌ sundalu si Jesus, dinundun dye si Simon, neng tawʼt Sirin, mawaꞌ ye dut kebenbenwanan. Pinetaren dye ya ampaꞌ ne pinepepsan dye krus dut kenye na pesusunud dut lilikuran i Jesus. ");
INSERT INTO plw_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Kineldamaʼt mengeꞌ taaw peseselundung dut ki Jesus. Pebebayaꞌ mengeꞌ kelilibunan neng memegsisiyak bekeꞌ memeglelalam sabab et ingasiꞌ dye dut ki Jesus. ");
INSERT INTO plw_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Indyari liminingew si Jesus dut kedye, kwan ye, “Mengeꞌ kelilibunan et lungsud et Jerusalem, kasiꞌ myu aku pegsiyakiꞌ. Segwaꞌ, siyakiꞌ myu dimyung mengeꞌ bilug bekeꞌ dimyung mengeꞌ keyegangan. ");
INSERT INTO plw_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Sabab dumateng timpu na kwantin mebres myu, kwanen myu, ‘Mesukud sebarang mengeꞌ bantut na kelilibunan, mengeꞌ kelilibunan naꞌ kaya nemegmentung, bekeꞌ mengeꞌ kelibunan naꞌ kaya neruruan et memulek.’ ");
INSERT INTO plw_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Indyari, sugiren dye dut mengeꞌ kebudbukiran, ‘Perbaniꞌ kay ne!’ bekeꞌ dut mengeꞌ bulud, ‘Timbuniꞌ kay ne!’ ");
INSERT INTO plw_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Sabab baꞌ kwantin neng ginis buwaten et taaw dut taaw kaya salaꞌ, enu buwaten dye baꞌ dut meraat neng taaw?” ");
INSERT INTO plw_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Indyari maya gasi duwang ketawan naꞌ mereraat, peglulusu peringan dut ki Jesus supaya imeteyen gasi. ");
INSERT INTO plw_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Pagkaꞌ nekeapet dye ne dut bulud ngeranen et “Bengkarak”, rinansang dye ne dun si Jesus dut pinegketngaan et ating duwang mereraat. Sembatu rinensangan kenye dut tampaꞌ kewanan, sembatu dut tampaꞌ gibang i Jesus. ");
INSERT INTO plw_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Indyari negberes si Jesus, kwan ye, “Amaꞌ empunaꞌ dye neng negperansang daken dut krus, sabab kaya pegsesewren dye baꞌ enu binwat dye.” Pegketbes pinegbagiꞌbagiꞌ mengeꞌ sundalu kenyeng mengeꞌ repanan, segwaꞌ pinebiaꞌ dye et pesudsukuran. ");
INSERT INTO plw_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Mengeꞌ taaw in memegsesarung duun, ganang mengeꞌ pegibuten pemenginlelew ne gasi i Jesus, kwan dye, “Mengeꞌ iba pinemawiꞌ i Jesus; subaliꞌ gasi bewinen ye bilug ye, baꞌ ya tantung ating Kristo, atin piniliꞌ et Empuꞌ Banar ampaꞌ memegbeg.” ");
INSERT INTO plw_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Mengeꞌ kesundeluan gasi nepekabiꞌ dut kenye, na pemenginlelew kenye. Indyari binggeyan dye ya et langgew. ");
INSERT INTO plw_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Indyari kwan dye, “Baꞌ ikew Surutan et mengeꞌ tawʼt Judio, ala, bewinaꞌ bilug mu!” ");
INSERT INTO plw_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Sinugid dye itue sabab dut uluan i Jesus maya mebatsaꞌ na nekesurat et samat kwantin: “Itue e Surutan et mengeꞌ Tawʼt Judio.” ");
INSERT INTO plw_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Sembatung meraat naꞌ rinansang set abiꞌ i Jesus in, penginlelew gasi ki Jesus, kwan ye, “Na diki be ikew na ating Kristo? Ala, bewinaꞌ diri mu sampay gasi damen.” ");
INSERT INTO plw_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Segwaꞌ ating iba ye neng meraat nemulag kenye, kwan ye, “Kas pegberes et samat kwantin! Manu kaya ne megtakut ke dut Empuꞌ, misan seꞌsaliꞌ tyu neng telu inukum et kwantin. ");
INSERT INTO plw_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Dinusa kite in, sugat neng pengukum sabab dut mengeꞌ pinemuwat te. Segwaꞌ itue si Jesus, kaya lang nemuwat et mereraat.” ");
INSERT INTO plw_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Indyari kwan ye, “Jesus, rendemaꞌ ku key pegdateng mu dut dimung pengmilikan bekeꞌ baꞌ megmilik ke ne.” ");
INSERT INTO plw_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Indyari siminambag si Jesus, kwan ye, “Sugiran ku ikew et keberbenaran, tiban nega keibut ke ne daken dut lungsud et kesenangan dut langit.” ");
INSERT INTO plw_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ganang meglilisag sempuluꞌ duwa tengeldew, liminingeb ginsaʼt dunyaꞌ seked lisag telu et mapun. ");
INSERT INTO plw_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Sabab eldew kaya negey et binyar ye, bekeꞌ kumut neng diningding dut seled naꞌ pengempuan naꞌ benwa in, diminingan lang neuyat tengaꞌ. ");
INSERT INTO plw_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Indyari negberes si Jesus et mebasag kwan ye, “Amaꞌ Empuꞌ dut langit, ipengarap ku dut keremut mu daken neng kurudua.” Ganang nebres ye lang itue, nebugtuan net ginawa. ");
INSERT INTO plw_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ganang nebiriꞌ et kapitan et mengeꞌ sundalu na samat kwantin neinabu, binantug ye Empuꞌ, kwan ye, “Kebenaran itueng taaw e, tantung metignaꞌ.” ");
INSERT INTO plw_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ganang mengeꞌ kineldaman neng nemegtingtimung ampaꞌ nemekesaksiꞌ et pegransang nebiriꞌ dye ne samat kwantin neinabu, binektul dye debdeb dye sabab et rupuk, ampaꞌ ne nemenguliꞌ. ");
INSERT INTO plw_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Segwaꞌ sebarang nemekekilala ki Jesus in, pebebayaꞌ ne esentin mengeꞌ kelilibunan neng nememayaꞌ kenye tihad nega dut bangsa et Galilea, dut mereꞌrayuꞌ lang pegtitiyegan dye, pegseserungan dye lang ginsaʼt mengeꞌ neinabu ki Jesus in. ");
INSERT INTO plw_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Indyari maya sembatung lelaki ingaran ye si Jose. Na ya sembatung kunsial bekeꞌ sembatung menungang taaw bekeꞌ metignaꞌ. ");
INSERT INTO plw_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Sabab ya kaya nesulutan dut kekunsialan pasal et mengeꞌ pinikir bekeꞌ binwat ki Jesus. Ya in tawʼt lungsud et Arimatea, sakup et Judea, bekeꞌ ya in sembatu gasing megtetagey et pengmilikan et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Sinurungan i Jose si Gobernador Pilato supaya tewen ye bangkay i Jesus dut krus tiꞌ supaya ilbeng. ");
INSERT INTO plw_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Giminaay si Pilato. Indyari, pegdateng i Jose dut krus, binibit ye ne peineug bilug i Jesus. Pegketbes binerugkusan ye et kumut neng gedyilew ampaꞌ ne limbeng ye dut batu naꞌ rinuangan, misan sembatu ingga peꞌ nelbengan. ");
INSERT INTO plw_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Na mapun et Biyirnis ne, ating eldew megtetagnaꞌ ne pegpanyap et Eldew et Kepeternan, Sabbat etawa Sabadu. ");
INSERT INTO plw_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Indyari maya mengeꞌ libun kwit tiꞌ megibut ki Jesus teyeg nega dut lungsud et Galilea, na nepesunud ki Jose angkan nebiriꞌ dye limbengan, bekeꞌ baꞌ enukwan pengdatun duntin et bangkay i Jesus. ");
INSERT INTO plw_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Pegketbes nemenguliꞌ ne dut benwa indyari nemegpanyap net lana bekeꞌ bebengluen supaya ibalung dut bilug i Jesus. Segwaꞌ nepetaren dye dut Eldewʼt Kepeternan, sabab dye megsunud dut Keseraan et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ganang diminateng ne unang eldew et senglinggu, meririklem et linggu nega siminurung ne ating mengeꞌ kelilibunan dut lebeng i Jesus, nememibit et mengeꞌ bebengluen neng pinemanyap dye. ");
INSERT INTO plw_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Pegdateng dye dun, nebiriꞌ ating kelang batu na tinembel eset lebeng i Jesus, netelubid ne perayuꞌ. ");
INSERT INTO plw_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Segwaꞌ ganang nemenled dye ne in, kaya ne nebiriꞌ dye bilug i Jesus naꞌ Begerar in. ");
INSERT INTO plw_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Pegkaꞌ rimineraas dye ne banar, atin mene peginggaꞌ dye tuꞌ duwang kelelekian na memegbebadyuꞌ naꞌ megseruꞌ samat kilat mene, na pemetitiyeg eset abiꞌ dye. ");
INSERT INTO plw_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Sabab et neknaran dye, ating mengeꞌ kelilibunan nepekleb dye mene dut lugtaꞌ. Segwaꞌ negberes ating mengeꞌ kelelekian dut kedye, kwan dye, “Manu pegtulusen myu ating biyag na taaw dut tengaʼt kelbengan? ");
INSERT INTO plw_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Pasal ki Jesus, kaya ne atue e, negbiyag ne peuliꞌ! Mekerendeman myu be kwit pegbersen ye dimyu in sasat ya iba-iba myu nega dut Galilea tiꞌ kwan ye, ");
INSERT INTO plw_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Keilangan Aku, Yegang et Taaw, ilugut dut mengeꞌ mekeselaan, supaya iransang dye aku dut krus, pegketbes biyagen nega peuliꞌ dut iketlung eldew.’ ” ");
INSERT INTO plw_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Indyari nerendeman et mengeꞌ kelibunan baꞌ enu sinugid kedye i Jesus kwit tiꞌ. ");
INSERT INTO plw_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ganang negpeuliꞌ dye ne teyeg dut lebeng tiꞌ, tinuturan dye ginsaʼt itueng ginis dut sempuluꞌ isa neng mengeꞌ pepengenaran i Jesus in sampay dut mengeꞌ iba. Dye in negpabar dut mengeꞌ pepengenaran in. ");
INSERT INTO plw_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ating mengeꞌ kelilibunan de Maria Magdalena, si Juana, si Maria neng induꞌ i Jakob, bekeꞌ mengeꞌ iba neng nememayaꞌ dut kedye in. ");
INSERT INTO plw_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Segwaꞌ, ingga peꞌ nemengandel et atin dut mengeꞌ kelilibunan in, sabab kedyeng tuturan penganal dye samat kaya lang keberbenaran. ");
INSERT INTO plw_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Segwaꞌ timinyeg si Pedro kenye ampaꞌ ne negdarak surung dut lebeng. Pagkaꞌ duun ye ne, pegligat ye supaya siyekan seled, atin mene nebiriꞌ ye mengeꞌ repanan neng binerugkus ki Jesus in, kaya ne iba. Pegketbes nugad ne. Pegliluꞌ pikiren ye baꞌ enu ne neinabu. ");
INSERT INTO plw_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Atin negang eldew, maya diminuntin duwang pepengenaran dut sembatung rurungan na pegngeranen et Emaus, maya mengeꞌ sempuluꞌ isa kilometro rayuꞌ ye teyeg dut lungsud et Jerusalem. ");
INSERT INTO plw_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Pegsusugiren dye pasal ginsaʼt neinabu dut ki Jesus. ");
INSERT INTO plw_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ganang pemegtuturan ne bekeꞌ pemegdawa-dawa dye ne pasal et itueng mengeꞌ neinabu, nepeabay ne si Jesus dut kedye. ");
INSERT INTO plw_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Segwaꞌ ingga peꞌ nekilala dye si Jesus. ");
INSERT INTO plw_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Indyari nengingkut si Jesus kedye, kwan ye, “Enung pesalan pegsusugiren myu sasat kew memegpepanew?” Indyari nepetaren dye, segwaꞌ mengeꞌ rupa dye merupuk. ");
INSERT INTO plw_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Si Kleopas siminambag kenye, kwan ye, “Meraliꞌ ikew lang naꞌ meglelegdeng dut lungsud et Jerusalem na kaya nekesewd et baꞌ enu neinabu duntin et itueng ketetebes lang et senung eldew e?” ");
INSERT INTO plw_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","“Enung ginis?” kwan i Jesus. “Pasal et ki Jesus neng tawʼt Nasaret!” sambag dye. “Ya sembatung tarus et Empuꞌ Banar. Maya basag bebresen ye bekeꞌ mengeꞌ buwat ye dut elepaʼt Empuꞌ bekeꞌ dut mengeꞌ taaw. ");
INSERT INTO plw_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Segwaꞌ damen neng mengeꞌ pegibuten et mengeꞌ pariꞌ, sampay damen neng mengeꞌ pegibuten naꞌ tawʼt Judio, atin linugut ne dut Gobernador Pilato si Jesus supaya dusaen et kepeteyan, sampay ipineransang dye ya dut krus. ");
INSERT INTO plw_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Indyari pegeerapen kay na ating memawiꞌ si Jesus dut mengeꞌ bangsa et Israel. Bekeꞌ iba, itue ne iketlung eldew tihad dut peginabu et itue e. ");
INSERT INTO plw_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Bekeꞌ nerugnan net atin, sabab damen neng mengeꞌ kelilibunan pineliluꞌ dye banar kami, sabab keineng meririklem pegkaꞌ nemengduntin dye dut lebeng i Jesus, ");
INSERT INTO plw_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","kaya ne nebiyanan dye kenyeng bilug. Pegketbes siminurung dye dut damen, indyari nemegsugid na maya nebiriꞌ dye mengeꞌ dereakan et Empuꞌ, na atin ne negsugid kedye na si Jesus negbiyag ne peuliꞌ. ");
INSERT INTO plw_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Indyari, mengeꞌ iba kay nemenurung ne dut lebeng, pegdateng dye dun, samat sinugid nega et mengeꞌ kelilibunan in, temed si Jesus lang in kaya ne nebiriꞌ dye.” ");
INSERT INTO plw_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Kwan i Jesus dut duwang pepengenaran tiꞌ, “Merupang kew pelan, bekeꞌ melalay kew mengretiꞌ bekeꞌ mengandel dut ginsan mengeꞌ pinegberes et mengeꞌ tarus et Empuꞌ kwit tiꞌ! ");
INSERT INTO plw_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Diki be takuꞌ subaliꞌ itueng Kristo kelabay mena et itueng ginis mura ya kesled dut kenyeng ketaasan?” ");
INSERT INTO plw_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Pinesewd i Jesus ne lagi dut Kesuratan et Empuꞌ baꞌ enu nekesurat dut ginsaʼt Kesuratan pasal dut diri ye, bekeꞌ timinagnaꞌ dut Kesuratan i Moises bekeꞌ ginsaʼt tarus et Empuꞌ tagnaꞌ tiꞌ. ");
INSERT INTO plw_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ganang mekabiꞌ dye ne dut pegsusurungan dye neng kebenbenwanan, nengyama si Jesus samat gaay ye na ipelahyun ye nega panew ye. ");
INSERT INTO plw_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Segwaꞌ, lineges dye ya banar, kwan dye, “Petaren ne atuꞌ damen. Iba, megsesdep ne eldew.” Angkansa nayaꞌ ne lang dut kedye. ");
INSERT INTO plw_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ganang memegampang dye ne dut lemisaan, nengisiꞌ si Jesus et bengbang ampaꞌ ye ne pineselematan Empuꞌ Banar. Indyari pinegbisbitas ye bekeꞌ tinegnanan ye ne negey dut kedye. ");
INSERT INTO plw_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Atin lang nebuwat ye megtuy ne netikwasan mata dye sampay nekilala dye ne si Jesus, indyari megtuy ne lang nalam dut penyek dye. ");
INSERT INTO plw_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Indyari nemegingkut-ingkutan dye ne, kwan dye, “Diki be takuꞌ angkan pelan menunga pegresanen et seled pusuꞌ tyu sasat ya pegsudsugid kite dut dalan tiꞌ, sampay pineretiꞌ ye nega Kesuratan et Empuꞌ dut kite?” ");
INSERT INTO plw_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Pagkaꞌ samat kwantin ne, megtuy dye ne timinyeg pesurung muliꞌ dut lungsud et Jerusalem. Pegdateng dye dun, neretnganan dye pemegurung-urung ating sempuluꞌ isa neng mengeꞌ pepengenaran, bekeꞌ maya nega iba dye. ");
INSERT INTO plw_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Indyari kwan et mengeꞌ pepengenaran, “Keberbenaran pelan ating Begerar negbiyag ne peuliꞌ, binaꞌ lang sampay dut ki Simon negpebiriꞌ gasi.” ");
INSERT INTO plw_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Pegketbes ating duwa teyeg et Emaus negtuturan gasi pasal baꞌ enukwan neinabu dut kedyeng pepenewan, bekeꞌ baꞌ enukwan dye nekilala si Jesus ganang pinegbisbitas ye ne bengbang in. ");
INSERT INTO plw_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Sasat pemegsudsugid dye nega pasal et itue, sekaliꞌ peginggaꞌ dye tuꞌ petitiyeg ne si Jesus dut pinegketngaan dye, kwan ye, “Kesenangan meseʼt dimyu.” ");
INSERT INTO plw_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Nemekeknad sampay nemeketakut, sabab nebluan dyeʼt endelimew. ");
INSERT INTO plw_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Indyari si Jesus negberes dut kedye, kwan ye, “Manu nemeketakut kew bekeꞌ manu pegduwa-duwa pikiran myu? ");
INSERT INTO plw_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Birinaꞌ myu mengeꞌ keremut ku bekeꞌ mengeꞌ tiked ku. Aku ne itue! Kutewaꞌ myu sampay seyekiꞌ myu! Sabab sembatung endelimew kaya lang uned bekeꞌ tulang samat mekebiriꞌ myu dut daken in.” ");
INSERT INTO plw_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ganang nebres i Jesus ne itue e, pinebiriꞌ ye tawan ye eset keremut bekeꞌ dut tiked ye dut kedye mawaʼt ransang in. ");
INSERT INTO plw_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Segwaꞌ ingga peꞌ nemekeandel dye segwaꞌ et dye meksan bekeꞌ melililuen. Indyari iningkut i Jesus dye, kwan ye, “Maya mekaan atue e?” ");
INSERT INTO plw_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Indyari, binggeyan dye ya et linagaꞌ naꞌ seraꞌ ");
INSERT INTO plw_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ampaꞌ ye ne kinawaꞌ. Pegketbes kinaan ye dut kedyeng elepan. ");
INSERT INTO plw_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Indyari kwan i Jesus dut kedye, “Netuman ne baꞌ enu pegsugiren ku rimyu kwit tiꞌ, na aku iba-iba myu nega. Ginsan in subaliꞌ metuman samat sinurat dut Kesuratan et Empuꞌ pasal daken samat dut Keseraan i Moises, bekeꞌ dut mengeꞌ buuk et mengeꞌ tarus et Empuꞌ, bekeꞌ dut buuk et mengeꞌ Kanta.” ");
INSERT INTO plw_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Indyari, tinulduan ye kedye supaya meretian dye ating mengeꞌ Kesuratan et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Kwan i Jesus dut kedye, “Itue ne e, baꞌ enu sinurat kwit tiꞌ: Na ating Kristo neng piniliꞌ et Empuꞌ pemegbeg subaliꞌ pengimeteyen, segwaꞌ megbiyag nega ya peuliꞌ mapet iketlung eldew. ");
INSERT INTO plw_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Nesurat ne gasi dut Kesuratan, tiharan dut lungsud et Jerusalem, sumked dut ginsaʼt mengeꞌ bangsa et dunyaꞌ, keilangan ipeabar pasal pegsusun et mengeꞌ taaw dut Empuꞌ, bekeꞌ kemeapan et Empuꞌ mengeꞌ keselaan dye sabab et atin kineradya i Jesus et kedye. ");
INSERT INTO plw_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Kemyu mengeꞌ saksiꞌ et itueng mengeꞌ ginis. ");
INSERT INTO plw_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Aku sumurung supaya melusu dut dimyu ating ipinengakuꞌ et daken neng Amaꞌ Empuꞌ dut langit. Angkansa peteteg kew mena dut lungsud et Jerusalem seked nepeleplep dimyu Empuꞌ et basag teyeg dut dibuwat langit.” ");
INSERT INTO plw_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Indyari pinebayaꞌ i Jesus mengeꞌ pepengenaran ye dut lungsud et Betania. Kintang ye kenyeng mengeꞌ keremut ampaꞌ ye dye pinehandek. ");
INSERT INTO plw_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Sasat pegpepehandek ye dye, amat-amat ne si Jesus periribuwat dut langit. ");
INSERT INTO plw_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Pegketbes binantug dye si Jesus, indyari nemenguliꞌ dye ne dut lungsud et Jerusalem na meksan dye ne banar. ");
INSERT INTO plw_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Pegdateng dye dut lungsud et Jerusalem, eldew-peldew dye dut Templo pengempuan naꞌ benwa, daran-peraran na megbebantug dut Empuꞌ.");
INSERT INTO plw_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Dut sengkepunan maya ne Ya in pegngeranen Beres, kebayaꞌ et Empuꞌ Banar dut langit ating Beres, bekeꞌ atin neng Beres, Empuꞌ Banar. ");
INSERT INTO plw_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ating Beres kebayaꞌ et Empuꞌ dut sengkepunan. ");
INSERT INTO plw_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ginuna et ating Beres ginsan neng keginisan sabab et tahag et Empuꞌ. Dipara ating Beres kaya negmendyari ginsan neng neguna. ");
INSERT INTO plw_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Dut ating Beres puun et biyag, bekeꞌ ating biyag siluꞌ et mengeꞌ taaw. ");
INSERT INTO plw_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ating siluꞌ megtetlang dut kelingban, segwaꞌ ating siluꞌ diki melkepan et kelingban. ");
INSERT INTO plw_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Indyari, maya sembatung lelaki tinahag teyeg dut Empuꞌ ingaran ye si Juan. ");
INSERT INTO plw_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Natuꞌ si Juan supaya megsaksiꞌ, bekeꞌ megpesebanar pasal et ating siluꞌ, apang ginsan taaw kekingeg sampay mengandel et siluꞌ. ");
INSERT INTO plw_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Diki lang si Juan atin siluꞌ, imbes ya natuꞌ supaya menaksiꞌ pasal et ating siluꞌ. ");
INSERT INTO plw_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Na, ating tantung siluꞌ, ingin bersen ating beres, na tumlang dut ginsan et taaw, negeatuꞌ ne atuʼt dunyaꞌ. ");
INSERT INTO plw_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ating siluꞌ in pesi, natuꞌ ne et dunyaꞌ. Misan dunyaꞌ neguna sabab ye, segwaꞌ ketaawan kaya nekekilala dut kenye. ");
INSERT INTO plw_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Nepeatuꞌ ating siluꞌ dut kedye na atin kenyeng bangsa, segwaꞌ dye na atin kenyeng ginuna, kaya megterima kenye. ");
INSERT INTO plw_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Segwaꞌ sebarang megterima ating Beres, sampay pengandel dut ingaran ye, dye in metingkag na mengeꞌ yegang et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Na dye in megmendyaring mengeꞌ yegang et Empuꞌ, diki teyeg dut duguꞌ etawa keinginan et bilug, etawa napsuꞌ et megesawa, temed ipinegyegang dut Empuꞌ sabab et kegeayen et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Na, ating Beres negmendyaring taaw samat kityu bekeꞌ liminegdeng et sementaraꞌ atuʼt kityu. Nebiriꞌ tyu benyar et kenyeng ketaasan. Na itue, ketaasan et kesemba-sembatung yegang et Empuꞌ Amaꞌ. Na Ya baha et redyikiꞌ bekeꞌ keberbenaran. ");
INSERT INTO plw_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Si Juan negpesebanar pasal ating Beres. Merensag beres i Juan, megsusugid kwan ye, “Itue ne pesi Ya, na pegsugiren ku in, ‘Na Ya ne pebibinyan dut daken, temed lebi nega set daken sabab ya una nega dut daken tiyeg negaʼt sengkepunan.’ ” ");
INSERT INTO plw_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Sabab Ya, ating Beres, puspus et kasi. Indyari, ginsan tyu meraliꞌ neketerima et redyikiꞌ ye daran-peraran. ");
INSERT INTO plw_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Sabab ating Keseraan et Empuꞌ binggey tagnaꞌ pebiyaꞌ dut ki Moises, segwaꞌ redyikiꞌ bekeꞌ keberbenaran et Empuꞌ binggey kityu sabab ki Jesus Kristo. Ya in pegingeranen dye Beres et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Kaya sinu-sinu nekebiriꞌ et Empuꞌ, selyu lang ating sembebatung yegang ye, na dut abiꞌ et Empuꞌ Amaꞌ. Na Ya negpebunayag et Empuꞌ dut kityu, sabab ya saliꞌsaliꞌ et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Na, atin masa pesebanar i Juan pasal et Empuꞌ. Ganang diminateng ne mengeꞌ dinaak et mengeꞌ pegibuten et tawʼt Judio mawaʼt lungsud et Jerusalem, dinaak in mengeꞌ pariꞌ bekeꞌ mengeꞌ Lebita supaya ingkuten si Juan baꞌ sinu ya. ");
INSERT INTO plw_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Kaya ne negpeilu si Juan, segwaꞌ pinesebenaran ye ne, kwan ye, “Lein lang aku Kristo neng mememawing megderateng.” ");
INSERT INTO plw_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Iningkut dye ya, “Baꞌ kwantin, sinu ke? Ikew be si Elias neng tarus tagnaꞌ?” Kwan ye, “Lein lang aku.” Nengingkut dye peuliꞌ, kwan dye, “Ikew takuꞌ Atin Tarus?” Sinambag i Juan, “Lein.” ");
INSERT INTO plw_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Dut ketimpus-timpusan kwan dye, “Sinu ke? Tubagaꞌ kay supaya maya mesugid kay dut negtahag damen. Enu mesugid mu pasal et diri mu?” ");
INSERT INTO plw_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Si Juan siminambag dut bebresen i Isaias na tarus et Empuꞌ, kwan ye, “Aku, ‘Atin pegberes na sembatung megtitingkag dut kelnangan: kwan, Ipetignaaꞌ myu dalan et Empuꞌ!’ ” ");
INSERT INTO plw_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Na, itueng mengeꞌ dinaak teyeg et mengeꞌ Pariseo, na metaas neng pegibuten et mengeꞌ tawʼt Judio. ");
INSERT INTO plw_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Nemengingkut gasi kenye, “Manu pegbewtismu ke baꞌ diki ikew Kristo, etawa si Elias, etawa Atin Tarus megtetagey kityung bangsa?” ");
INSERT INTO plw_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","“Pegbewtismu ku daken et danum,” sambag i Juan, “segwaꞌ maya megtitiyeg eset pinegketngaan myu na diki myu nekilala. ");
INSERT INTO plw_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ya na meglulundug daken. Diki lang teupen na aku memabad et sisiget et tempaꞌ ye, sabab diri ya lebing metaas daken.” ");
INSERT INTO plw_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Itue neinabu dut lungsud et Betania dut dipag et danum et Jordan, na baꞌ embe pegbewtismuan i Juan. ");
INSERT INTO plw_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Leing eldew nebiriꞌ i Juan si Jesus megsesentin kenye. Kwan i Juan, “Siyekiꞌ myu si Jesus, antangen ye bibili neng iungsud et Empuꞌ, na mengugad et salaꞌ ginsan taaw et sengkedunyaan! ");
INSERT INTO plw_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ya ne in pesi pegbentuan ku kwit tiꞌ, ‘Na sembatung lelaki na meglulundug daken, lebi nega et daken, sabab meguna nega dut daken tiyeg sengkepunan.’ ");
INSERT INTO plw_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Misan aku, kaya sewd ku na Ya ne atin pesi, segwaꞌ angkan aku pegbewtismu et danum supaya mepebunayag Ya dut mengeꞌ tawʼt bangsa et Israel. ");
INSERT INTO plw_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","“Diki ku banar Ya nekilala sene in, segwaꞌ Empuꞌ na nenahag daken supaya megbewtismu et danum, Ya ne negpekilala. Kwaʼt Empuꞌ, ‘Kebiriꞌ ke et Empung Nakem mineug samat aksang teyeg et langit, sampay sumaleb sembatung lelaki. Ya ne na megbewtismu et Empung Nakem.’ ” Indyari, nepesebenaran i Juan pasal ki Jesus, kwan ye, “Daken, nebiriꞌ ku et Nakem naꞌ Empuꞌ nineug samat aksang tiyeg et langit, sampay siminaleb ki Jesus. ");
INSERT INTO plw_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nebiriꞌ ku na atin neinabu, sampay pepesebenaran ku na itue ne, si Jesus ating Yegang et Empuꞌ Banar.” ");
INSERT INTO plw_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Siminunud neng eldew, nepeuliꞌ gasi dut danum et Jordan si Juan bekeꞌ duwang pepengenaran ye. ");
INSERT INTO plw_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ganang nebiriꞌ i Juan si Jesus megtetalib, kwan ye, “Siyekiꞌ myu tiꞌ be, Bibili neng ipesimayaꞌ et Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ganang nekingeg et duwang pepengenaran ating bebresen i Juan, nepeselundung dye ki Jesus. ");
INSERT INTO plw_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Peglingew i Jesus nebiriꞌ Ye dye na megseselundung kenye. Pegketbes iningkut Ye dye, “Enu pegtutulusen myu?” Kwan dye, “Rabi, retian ye ‘Menunulduꞌ’, embe peglelegdengan Mu?” ");
INSERT INTO plw_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","“Aniꞌ kew,” kwan i Jesus, “Apang mebiriꞌ myu.” Angkansa nememayaꞌ dye bekeꞌ nebiriꞌ dye baꞌ embe peglelegdengan ye. Diminuntin dye mengeꞌ lisag epat et mapun. Na ginebi dye ne duntin. ");
INSERT INTO plw_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Si Andres neng tipused i Simon Pedro na sembatu dut duwa tiꞌ na nekekingeg et pegbebresen i Juan, bekeꞌ nepeselundung ki Jesus. ");
INSERT INTO plw_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Megtuy tinulus i Andres tipused yeng si Simon bekeꞌ tinuturanan ye, “Ne,” kwan ye, “Nebiriꞌ kay ne atin Mesias!” Ingin bersen, atin Kristo. ");
INSERT INTO plw_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Pegketbes binibit ye si Simon dut ki Jesus. Na siminyek kenye si Jesus bekeꞌ negsugid, “Ikew si Simon, yegang i Juan. Pengeranan ku ne ikew tiban et Sepas.” ");
INSERT INTO plw_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Pegdiklem nepikiran i Jesus pinegmenunga sumurung dut Galilea. Nebiriꞌ ye si Pelipe, kwan ye dut kenye, “Mayaꞌ daken.” ");
INSERT INTO plw_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Si Pelipe samat ki Andres bekeꞌ ki Pedro, teyeg dye ginsan dut lungsud et Betsaida. ");
INSERT INTO plw_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Nebiyanan i Pelipe si Natanael. Pegketbes sinugiran ye ya, “Nebiyanan kay ne na sembatung sinurat tagnaꞌ i Moises dut Keseraan et Empuꞌ bekeꞌ gasi sinurat et mengeꞌ tarus et Empuꞌ na Ya si Jesus tawʼt Nasaret, neng yegang i Jose.” ");
INSERT INTO plw_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","“Tawʼt Nasaret! Maya takuꞌ lumiwan na menunga teyeg duntin?” ingkut i Natanael. “Aniꞌ ke, siyekiꞌ!” kwan i Pelipe. ");
INSERT INTO plw_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ganang nebiriꞌ i Jesus si Natanael megsusurung kenye, kwan i Jesus, “Anie e taaw et Israel banar, ya diki mengdurupang.” ");
INSERT INTO plw_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","“Enukwan mu aku nekilala?” ingkut i Natanael. Timinubag si Jesus, “Mura ke tiningkag i Pelipe, nebiriꞌ ku ne lagi ikew dut sirung et puun et igus.” ");
INSERT INTO plw_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Pegketbes negsugid si Natanael, “Rabi, ikew ne tuꞌ yegang et Empuꞌ, ikew ne tuꞌ surutan et Israel.” ");
INSERT INTO plw_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Kwan i Jesus, “Nengandel ke sabab lang dut sinugid ku dimu na nebiriꞌ ku ne lagi ikew dut sirung et puun et igus? Kebiriꞌ ke nega et derekerang ginis na luwas nega et itue.” ");
INSERT INTO plw_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Pegketbes sinugid i Jesus dut ginsan, “Sugiren ku kemyu et keberbenaran, mebiriꞌ myu meukaban langit, bekeꞌ mengeꞌ dereakan et Empuꞌ tumindal mineug pesurung dut daken, ating Yegang et Taaw.” ");
INSERT INTO plw_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ganang iketlung eldew, maya bulun dut lungsud et Kana dut probinsiya et Galilea. Na, duntin induꞌ i Jesus. ");
INSERT INTO plw_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Si Jesus bekeꞌ kenyeng pepengenaran dinangin gasi dut pegbulunan. ");
INSERT INTO plw_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Na ganang kinabus et inumen neng alak, negsugid induꞌ i Jesus kenye, kwan ye, “Kaya ne inumen.” ");
INSERT INTO plw_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Sinugid i Jesus kenye, “Induꞌ, enu pekilamud mu daken? Ingga peꞌ diminateng timpu na ipebiriꞌ basag ku dut mengeꞌ taaw.” ");
INSERT INTO plw_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Negsugid gasi induꞌ ye dut mengeꞌ tetehagen, kwan ye, “Ibutaꞌ myu baꞌ enu sugiren ye dimyu.” ");
INSERT INTO plw_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Na, duun maya enem neng siburan naꞌ batu, kede sembatu mekesunuan lengku mengeꞌ duwangpuluꞌ etawa telumpulung galun et danum. Itueng danum seled et ating mengeꞌ siburan peusalen et mengeꞌ tawʼt Judio et arat pinegarat pasal pegbebasaꞌ et keremut. ");
INSERT INTO plw_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Negsugid si Jesus dut mengeꞌ tetehagen, “Behaniꞌ myu et danum.” Na, ampaꞌ dye binaha ginsan seked dut babaꞌ. ");
INSERT INTO plw_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Pegketbes, sinugid i Jesus kedye, “Na tiban sumeuk kew, bitaꞌ myu dut mengengerigra dut pegkenkaanan.” Angkansa nememibit dye. ");
INSERT INTO plw_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ganang netimtiman et mengengerigra dut pegkenkaanan ating danum na negmendyaring inumen neng alak. Na diki ye nesewran baꞌ embe mawaꞌ et ating inumen, segwaꞌ nesewran et mengeꞌ tetehagen na nemeneuk et danum in. Pegketbes, tiningkag ye lelaki neng pegbubulunen. ");
INSERT INTO plw_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Na,” sinugid ye kenye. “Misan sinu, meguna pepelamak et menunungang alak. Indyari, ganang kelaꞌ ne neinum et mengeꞌ taaw, mura megpelamak et sumirib-sirib neng inumen. Segwaꞌ pinemuri myu pinekemenungang alak seked tiban.” ");
INSERT INTO plw_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Itue una-una et mengeꞌ tendaꞌ na keliluꞌliluꞌ na binwat i Jesus. Binwat ye itue dut lungsud et Kana na dut probinsiya et Galilea. Na untin pinebunayag ye ketaasan ye. Sumampay mengeꞌ pepengenaran ye nemengandel kenye. ");
INSERT INTO plw_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Pegketbes et itue, negpesanad de Jesus dut lungsud et Kapernaum. Megbebayaꞌ induꞌ ye, mengeꞌ ketipusdan ye, sampay mengeꞌ pepengenaran ye. Duntin timineteg dye et senu-senung eldew. ");
INSERT INTO plw_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ganang megapet ne timpu et Kenkaan et Neketalib et mengeꞌ Judio, siminurung si Jesus dut lungsud et Jerusalem. ");
INSERT INTO plw_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Set Templo neng Benwang Pengempuan et mengeꞌ tawʼt Judio, nebiriꞌ ye mengeꞌ taaw pemegdagang-dagang et mengeꞌ sapiꞌ, mengeꞌ bibili, sampay mengeꞌ aksang apang iunsud dut Empuꞌ. Bekeꞌ nebiriꞌ ye gasi mengeꞌ taaw pegsemsembian et pirak memegarung et lemisaan. ");
INSERT INTO plw_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Nemaal si Jesus et lelapes neng tali, ampaꞌ ye ne pineglelepsan peliwan et Templo ginsan mengeꞌ bibili bekeꞌ mengeꞌ kesesepian. Pinegsesabug ye mengeꞌ pekparak neng siin et mengeꞌ menenambiꞌ et pirak, sampay tinuarang mengeꞌ lemisaan dye. ");
INSERT INTO plw_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Sinugid Jesus dut memegdagang et mengeꞌ aksang, kwan ye, “Pengugaraꞌ myu atin atue. Kasiꞌ myu pegbuwataꞌ et benwaʼt deregangan benwa et Amaꞌ ku!” ");
INSERT INTO plw_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ganang nebiriꞌ dye itue, nerendeman et mengeꞌ pepengenaran ye nesurat dut Kesuratan et Empuꞌ, kwaʼt, “Samat megdereleg et apuy seled pusuꞌ ku sabab et peglingew et benwa mu, u Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Pegketbes, nemengingkut mengeꞌ pegibuten et mengeꞌ tawʼt Judio dut ki Jesus, kwan dye, “Enu tendaꞌ na mepebiriꞌ mu damen na maya pesebanar na binwat mu itue?” ");
INSERT INTO plw_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Siminambag si Jesus, kwan ye, “Baꞌ rungkaten myu itueng Templo, pegketbes ipetiyeg ku lang et telung eldew.” ");
INSERT INTO plw_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Negsugid mengeꞌ tawʼt Judio, kwan dye, “Uy naꞌ, epatnempuluꞌ enem neng teun binaal itueng templo. Na dimu, tebsen mu lang et telung eldew?” ");
INSERT INTO plw_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pegbersen ye inantang ye dut templo, segwaꞌ pegsindiren ye bilug ye. ");
INSERT INTO plw_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Leyd, pegketbes na si Jesus negbiyag ne peuliꞌ teyeg et kepeteyan ye dut krus, nerendeman et mengeꞌ pepengenaran ye kwit binres ye. Sampay nengandel dye dut Kesuratan et Empuꞌ bekeꞌ dut beres na pinegberes i Jesus. ");
INSERT INTO plw_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ganang dun ne si Jesus dut lungsud et Jerusalem dut mengeꞌ Eldew neʼt Kenkaan et Neketalib, mekansang taaw nekebiriꞌ et mengeꞌ keliluꞌlilung tendaꞌ na binwat ye, bekeꞌ nemengandel dut kenye. ");
INSERT INTO plw_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Segwaꞌ kaya nengarap si Jesus dut kedye et diri ye, sabab sewd ye pikiran et ginsan et mengeꞌ taaw. ");
INSERT INTO plw_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Na diki keilangan i Jesus maya pegpesebanar kenye et sinu-sinu pasal et taaw, sabab mekesewran ye baꞌ enu dut seled et pusuꞌ et mengeꞌ taaw. ");
INSERT INTO plw_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Maya sembatung lelaki na Pariseo, ingaran ye si Nikodemo na sakup et mememegbeg et taaw et Judio. ");
INSERT INTO plw_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Nengumbaley ya dut ki Jesus sembatung gebi bekeꞌ negsugid, kwan ye, “Menunulduꞌ, nesewran kay ikew tuꞌ sembatung menunulduꞌ na teyeg dut Empuꞌ Banar. Sabab kaya sembatu mekekeradya et kelililuꞌliluꞌ na mengeꞌ tendaꞌ na pegbaalen mu baꞌ Empuꞌ kaya set dimu.” ");
INSERT INTO plw_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Timinubag si Jesus, kwan ye, “Sugiran ku ikew et keberbenaran, selyu lang taaw ipegyegang peuliꞌ, diki ye mebiriꞌ pengmilikan et Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Iningkut i Nikodemo, kwan ye, “Enukwan taaw ipegyegang peuliꞌ baꞌ ya megurang ne? Tantu diki ya keseled keruwa peuliꞌ dut seled beteng et induꞌ ye apang ipegyegang peuliꞌ gasi.” ");
INSERT INTO plw_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Tuminubag si Jesus, “Sugiran ku ikew et keberbenaran, selyu taaw ipegyegang et danum bekeꞌ Nakem et Empuꞌ, diki ya keseled dut Pengmilikan et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Baꞌ ipegyegang et taaw, asal taaw, segwaꞌ baꞌ ipegyegang et Nakem et Empuꞌ, asal ya nemengdyaring meinempuen eset biyag ye. ");
INSERT INTO plw_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Kas ke megliluꞌ et sinugid ku dimu, na, keilangan myu ginsan ipegyegang peuliꞌ,” kwan i Jesus. ");
INSERT INTO plw_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Sinugid gasi i Jesus kenye, kwan ye, “Megtepiyug deres baꞌ embe gaay ye. Mekingeg mu eriweswes ye, segwaꞌ diki mu mesugid baꞌ embe teyeg etawa embe surungan ye. Kwantin antangan ye dut mengeꞌ taaw ne ipinegyegang et Nakem et Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","“Enukwan meinabu ituꞌ?” ingkut i Nikodemo. ");
INSERT INTO plw_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Iningkut i Jesus kenye, “Diki be menunulduꞌ keʼt Israel? Na, diki mu meretian ginsan neng itue? ");
INSERT INTO plw_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Sugiran ku ikew et kebenaran, pegbersen kay mayang nesewran kay, bekeꞌ pepesebenaran mayang nebiriꞌ kay. Segwaꞌ kemyu neng mengeꞌ taaw, diki nega mengasip et damen neng pesebanar. ");
INSERT INTO plw_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Enukwan myu mandel pegbersen ku dimyu pasal et keginisan dut langit, baꞌ diki myu endelen pegbersen ku pasal et keginisan atuʼt dunya? ");
INSERT INTO plw_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Kaya sinu diminuntin dut langit selyu lang ya ne mawaꞌ teyeg dut langit. Kaya iba ya ne Yegang et Taaw. ");
INSERT INTO plw_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Samat kwantin dut kelnangan tagnaꞌ, ganang ipineribuwat i Moises seli neng tumbaga na binaal ye, (apang baꞌ sinu tininduk et seli bekeꞌ sumiyek et atin dibuwat et usuk, megulinan dye.) Angkansa megsepantun gasi aku, Yegang et Taaw, keilangan iperibuwat dut usuk, ");
INSERT INTO plw_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","supaya baꞌ sinu mengandel daken maya biyag na kaya seskeran dut elepan et Empuꞌ Banar. ");
INSERT INTO plw_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Sabab mekasi banar Empuꞌ eset mengeꞌ taaw atueʼt sengkedunyaan, ne binggey ye kenyeng bugtung na Yegang supaya isimayaꞌ, supaya sebarang mengandel kenye diki lang metiksaꞌ dut Narkaꞌ, segwaꞌ maya biyag naꞌ kaya seskeran dut elepan et Empuꞌ Banar. ");
INSERT INTO plw_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Sabab diki lang pinelusu et Empuꞌ kenyeng yegang supaya ukuman apang dusaen mengeꞌ taaw atueʼt sengkedunyaan, imbes supaya puwasen ye mengeꞌ taaw mawaʼt keselaan dye. ");
INSERT INTO plw_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Sebarang mengandel eset ating Yegang et Empuꞌ diki ne meukuman et Empuꞌ. Segwaꞌ sebarang diki mengandel, inukum ne, sabab kaya nengandel daken, na ating kesembatu-sembatung Yegang et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Na inukum dye, sabab natuꞌ ne aku eset dunya, samat siluꞌ dut kelingban, segwaꞌ mengeꞌ taaw et sengkedunyaan iningin dye nega lingeb eset telang, sabab kedyeng keradya mereraat. ");
INSERT INTO plw_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Sebarang megpemuwat et meraat, megiseg et telang, sabab mendiꞌ megpekabiꞌ et telang supaya diki mebunayag mengeꞌ mereraat neng keradya dye. ");
INSERT INTO plw_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Segwaꞌ sebarang megpengebiyagan dut keberbenaran pepekabiꞌ dut telang supaya mebunayag kenyeng mengeꞌ nekeradyang bubuwaten sabab et pegandel ye dut Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Pegketbes et itue, siminurung si Jesus bekeꞌ mengeꞌ pepengenaran ye dut probinsiya et Judea. Na dun dye liminegdeng bekeꞌ nemengbewtismu. ");
INSERT INTO plw_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Si Juan gasi negbewtismu dut Enon abiꞌ et Salem, sabab mekansang danumen, bekeꞌ daran memegsurung kenye duntin mengeꞌ taaw na megpebewtismu. ");
INSERT INTO plw_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Sabab ating masa ingga peꞌ nepirisu si Juan. ");
INSERT INTO plw_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Kasa in nemegsagkaꞌ mengeꞌ pepengenaran i Juan dut sembatung Judio pasal et pegbebasaꞌ neng pinegarat. ");
INSERT INTO plw_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Siminurung dye dut ki Juan, kwan dye, “Rabi, inyet iba-iba mu bekeꞌ pepesebenaran mu pasal kenye dut dipag et Jordan, na ya pegbewtismu gasi. Duun megsurung kenye ginsan.” ");
INSERT INTO plw_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Tuminubag si Juan, “Kaya enu-enu meterima et taaw selyu igbey kenye teyeg et Empuꞌ dut langit. ");
INSERT INTO plw_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kemyu ne mekepegpesebanar baꞌ enu pegsugiren ku, ‘Diki aku Kristo, atin piniliꞌ et Empuꞌ pemegbeg, segwaꞌ aku linusu mena dut kenye.’ ");
INSERT INTO plw_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Sabab pegelban neng libun apang gasi dut nengeleb neng lelaki. Dut terisabeng gasi, sasat ya megtetagey, pegkikinggen ye lang gibek-gibek. Naꞌ pegkekingeg ye et bensag et lelaki na ipebulun, neksanan ne ya banar. Megdemikian ne kwantin tiban aku bekeꞌ si Jesus. Dyukup ne keksanan ku sabab kenyeng pegdateng. ");
INSERT INTO plw_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Sabab keilangan ne si Jesus periribuwat, aku gasi pesesanad ne.” ");
INSERT INTO plw_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Ya ne teyeg dut dibuwat langit metaas eset ginsan. Na ya teyeg dut dunya, dut dunyaꞌ gasi bekeꞌ pegberes samat ya na atuʼt dunya. Angkansa ya ne mawaꞌ dut langit metaas eset ginsan. ");
INSERT INTO plw_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Pepesebenaran ye mengeꞌ nebiriꞌ sampay nekingeg ye dut dibuwat langit. Segwaꞌ merahang lang pengandel et pesebanar ye. ");
INSERT INTO plw_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Sebarang taaw mengandel et kenyeng pesebanar, pepesebenaran et taaw Empuꞌ keberbenaran. ");
INSERT INTO plw_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Sabab ya ne na pinelusu et Empuꞌ, pegberes et beres teyeg et Empuꞌ, sabab Empuꞌ negbegey kenye et Nakem Ye et kesukupan. ");
INSERT INTO plw_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Pegmerganen et Empuꞌ Amaꞌ yegang ye, bekeꞌ binggey ye ginsan neng keginisan dut gewman ye. ");
INSERT INTO plw_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Mayang sinu mengandel et ating Yegang et Empuꞌ maya biyag kaya seskeran. Segwaꞌ baꞌ sinu megmendiꞌ dut ating Yegang et Empuꞌ, diki kebiyaꞌ et biyag kaya seskeran. Segwaꞌ kutuk et Empuꞌ dut kedye, diki mepapas.” ");
INSERT INTO plw_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ganang neebaran et mengeꞌ Pariseo na lebing mekansang ne negayat bekeꞌ nebewtismuan i Jesus eset ki Juan. ");
INSERT INTO plw_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Segwaꞌ banar ye, diki lang si Jesus nengbewtismu, erapun kenyeng mengeꞌ pepengenaran key. ");
INSERT INTO plw_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Pagkaꞌ kwantin ne, atin beres nesewran nega i Jesus. Na tinirengan ye dut probinsiya et Judea, nepeuliꞌ gasi dut probinsiya et Galilea. ");
INSERT INTO plw_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Segwaꞌ keilangan ye tumalib dut probinsiya et Samaria. ");
INSERT INTO plw_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Angkansa duminateng si Jesus dut kebenbenwanan et probinsiya et Samaria pegngeranen Sikar, mekabiꞌ et lugtaꞌ na binggey i Jakob tagnaꞌ dut yegang yeng si Jose. ");
INSERT INTO plw_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Na duntin Tebud i Jakob, narung si Jesus dun sabab et nelupug ne et pegpanew-panew ye. Na meginapet ne et tengeldew. ");
INSERT INTO plw_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Maya sembatung libun na tege-Samaria na duminateng dun apang menageb. Negsugid si Jesus kenye, “Mekedyari be menginum et danum myu?” ");
INSERT INTO plw_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ating masa kaya sentin mengeꞌ pepengenaran ye sabab nemengelen et pegkaan. ");
INSERT INTO plw_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Negsugid ki Jesus libun neng Samaritano, kwan ye, “Ikew Judio, aku Samaritano. Manu megtew ke daken et danum na inumen?” (Sabab diki mekedyari mekeiba-iba tawʼt Judio dut tawʼt Samaritano). ");
INSERT INTO plw_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Siminambag si Jesus, kwan ye, “Baꞌ mekesewran mu lang baꞌ enu binggey et Empuꞌ dut taaw bekeꞌ baꞌ sinu itueng panew dimu et inumen, meraliꞌ tumew ke daken et danum, bekeꞌ begeyan ke et danum neng biyag.” ");
INSERT INTO plw_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Siminambag libun kenye, kwan ye, “Ilaꞌ, kaya tuꞌ teteur mu apang iseuk, sabab merarem itueng tebud. Embe meisian mu et itueng biyag neng danum? ");
INSERT INTO plw_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Na tagnaꞌ tiꞌ negey dameng keupuꞌupuan tyu ne si Jakob et tebud na itue. Na atue sampay ya nekeinum nega, kwantin gasi kenyeng keyegangan bekeꞌ mengeꞌ kesepian, bekeꞌ ibang mengeꞌ ipatan ye. Metaas ke nega be takuꞌ dut damen neng keupuꞌupuan na si Jakob?” ");
INSERT INTO plw_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Timinubag si Jesus, kwan ye, “Sebarang minum et danum na itue tuknewen nega peuliꞌ. ");
INSERT INTO plw_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Segwaꞌ baꞌ sinu keinum et danum naꞌ igbey ku kenye, diki ne ya tuknewen peuliꞌ. Tantu banar, danum neng pegebgey ku in megmendyaring senep dut seled ye, na musbu periribuwat sumked dut biyag na kaya seskeran.” ");
INSERT INTO plw_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Sinugid et libun dut kenye, kwan ye, “Ilaꞌ, kwantin, begeyiꞌ ku et danum na pegsugiren mu in, supaya diki ne tuknewen ku peuliꞌ, sampay pepeuliꞌpeuliꞌ ku nega atue apang menageb et danum.” ");
INSERT INTO plw_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Sinugid i Jesus kenye, “Panew ne, tingkagaꞌ esawa mu mura kemyu peuliꞌ atue.” ");
INSERT INTO plw_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","“Kaya lang esawa ku,” tubag et libun. Segwaꞌ negsugid si Jesus kenye, “Banar pegsugiren mu na kaya esawa mu. ");
INSERT INTO plw_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Temed banar ye, ikew maya ne lima bulnut mu, pegiban-ibanen mu tiban in, lein lang esawa mu. Banar gasi atin pegsugiren mu in.” ");
INSERT INTO plw_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","“Ilaꞌ,” kwan et libun, “kedam ku ga be, tarus ke. ");
INSERT INTO plw_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Mengeꞌ kegunggurangan kay pemegempuꞌ dye set itueng bukid e. Segwaꞌ kemyu na mengeꞌ Judio, pegsugiren myu, subaliꞌ dut Jerusalem lang pegempuan.” ");
INSERT INTO plw_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Sinugid i Jesus, kwan ye, “Mengandel ke daken, libun, mapet timpu baꞌ embe pengempuan myu et Empuꞌ Amaꞌ, diki lang itueng bukid lang, etawa dut Jerusalem lang. ");
INSERT INTO plw_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kemyu mengeꞌ Samaritano, megpengempuꞌ kew, segwaꞌ diki myu mekekilala, ating pegempuen myu. Na, temed damen megpengempuꞌ kay mekesewran kay, sabab ating mememawiꞌ teyeg dut mengeꞌ tawʼt Judio. ");
INSERT INTO plw_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Sabab megderateng ne timpu, na atue ne pesi tiban, na mengeꞌ banar neng mengengempuꞌ, pegempuen dye Empuꞌ Amaꞌ dut Nakem bekeꞌ keberbenaran. Samat atin pegtutulusen et Empuꞌ Amaꞌ na mengeꞌ mengengempuꞌ kenye. ");
INSERT INTO plw_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Empuꞌ Banar tawʼt langit, angkansa mayang mengempuꞌ kenye, subaliꞌ megpeempuꞌ teyeg et seled atey dye bekeꞌ dut keberbenaran.” ");
INSERT INTO plw_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Negsugid libun, kwan ye, “Sewd ku pasal et Mesias, pegsugiren na Kristo, na megderateng. Baꞌ ya dumateng ne, iperetiꞌ ye ginsan damen.” ");
INSERT INTO plw_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Negsugid si Jesus, “Aku ne pesi, itue na megberes dimu!” ");
INSERT INTO plw_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Pegketbes et atin, nemekepeuliꞌ ne mengeꞌ pepengenaran ye, segwaꞌ nemegliluꞌliluꞌ sabab nebiriꞌ dye na nemegsudsugid iba ye libun. Segwaꞌ kaya nesewran dye nengingkut dut libun, “Enu gaay mu?” etawa ki Jesus, “Manu pekisudsugid ke kenye?” ");
INSERT INTO plw_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Pegketbes tinektak et libun kenyeng sesegban ampaꞌ ne nuliꞌ dut lungsud in, bekeꞌ pinegsisampay ye dut mengeꞌ taaw, kwan ye, ");
INSERT INTO plw_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Aniꞌ kew, birinaꞌ myu, maya lelaki na negsugid daken pasal ginsan buwat na nebuwat ku. Itue ne meraliꞌ pegngeranen dye et Kristo.” ");
INSERT INTO plw_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Nemengliwan mengeꞌ taaw dut kebenbenwanan apang dumuntin dut ki Jesus. ");
INSERT INTO plw_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Pinegleleges et mengeꞌ pepengenaran ye, kwan dye, “Rabi, pengaan mena.” ");
INSERT INTO plw_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Segwaꞌ negsugid si Jesus kedye, “Maya pegkaan ku na diki myu pegsesewren.” ");
INSERT INTO plw_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Angkansa nemegbungburung dye, “Kaluꞌ maya nibit kenye et kekanen ye,” kwan dye. ");
INSERT INTO plw_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Kwan i Jesus, “Pegkaan ku bekeꞌ kebiyagan ku, tumanen baꞌ enu keinginan et Empuꞌ banar neng negtahag daken, seked pinekeradya daken tebsen ku. ");
INSERT INTO plw_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Diki be pegsugiren myu na epat negang bulan mura mengeyg? Isugid ku dimyu, imukrataꞌ mata myu, siyekiꞌ myu uma be tiꞌ bekeꞌ siyekiꞌ myu keldamen et mengeꞌ taaw neng pelilibut tyu. Lutuꞌ ne, mekedyari ne keygen. ");
INSERT INTO plw_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Iantang et buaꞌ itueng mengeꞌ taaw, misan tiban pasal et mengengeyg, meketerima ne et bagiꞌ ye. Kwantin gasi tiban megkekeyg ne gasi et buaꞌ dut biyag na kaya seskeran, angkansa mengunguma bekeꞌ mengengeyg memegkesan dye saliꞌsaliꞌ. ");
INSERT INTO plw_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Sabab banar ne itueng pegsugiren, ‘Sembatu negpesasad, iba gasi mengengeyg.’ ");
INSERT INTO plw_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Tinahag ku kemyu supaya mengeyg, atin ne lein kemyu negsasad. Sengketaawan negsensaraꞌ sentin, temed keygen myu kedyeng pinegsenseraan.” ");
INSERT INTO plw_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Mekansang ne mengeꞌ tawʼt Samaritano et itueng lungsud nemengandel ki Jesus, sabab et pesebanar et libun na atin, na kwan ye, “Nesewran ye ginsan baꞌ enu nekeradya ku!” ");
INSERT INTO plw_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Angkansa, ganang negpekabiꞌ dut ki Jesus mengeꞌ Samaritano, inangat dye na tumeteg mena ya dut kedye. Na tumineteg si Jesus dun et duwang eldew. ");
INSERT INTO plw_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Sabab et mengeꞌ bebresen i Jesus kiminansang mengeꞌ mengengandel. ");
INSERT INTO plw_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Sinugid dye dut libun, “Diki lang sabab ye dut bebresen mu nengandel kay, segwaꞌ tiban, tantung ya ne nekingeg et dameng bilug sampay nesewran kay ne, si Jesus ne banar mememawiꞌ et mengeꞌ taaw atuʼt dunyaꞌ.” ");
INSERT INTO plw_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Pegketalib et duwang eldew, nugad si Jesus eset lungsud et Sikar, siminurung dye dut probinsiya et Galilea. ");
INSERT INTO plw_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Sabab pegsugiren ye kwit ne tiꞌ, na sembatung tarus, baꞌ dut kenyeng diring lungsud, kaya kebentugan ye. ");
INSERT INTO plw_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ganang diminateng ne si Jesus dut Galilea, tinerima ya et menunga mengeꞌ tawʼt Galilea, sabab nebiriꞌ dye ginsan na binwat ye dut Kenkaan et Neketalib dut lungsud et Jerusalem, sabab ating masa nemegtekaꞌ dye duntin. ");
INSERT INTO plw_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Angkansa siminurung si Jesus peuliꞌ dut lungsud et Kana dut Galilea. Na dut Kana binelyu ye danum negmendyaring inumen (alak) tagnaꞌ tiꞌ. Na, dun maya sembatung pegibuten na mesakit kenyeng yegang na lelaki dut lungsud et Kapernaum. ");
INSERT INTO plw_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ganang neebaran ye na si Jesus nepeuliꞌ dut Galilea teyeg dut Judea, siminurung ya megtuy dut ki Jesus supaya megpeingasiꞌ na baꞌ mekedyari pesanad dut Kapernaum apang pegulinan kenyeng yegang, sabab kupatey ne. ");
INSERT INTO plw_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Sinugid i Jesus kenye, “Subaliꞌ kebiriꞌ kew mena et mengeꞌ keliluꞌlilung tendaꞌ, temed baꞌ diki kew kebiriꞌ, diki kew mengandel.” ");
INSERT INTO plw_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Negsugid ating pegibuten, kwan ye, “Ilaꞌ, baꞌ mekedyari, duntinaꞌ mena daken, mura yegang ku matey.” ");
INSERT INTO plw_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Sinugid i Jesus, “Muliꞌ ke ne. Negulinan ne yegang mu.” Pagkaꞌ atin ne inandel ye bebresen i Jesus pegketbes nugad. ");
INSERT INTO plw_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ganang dun nega ya et dalan, sinusup ya et kenyeng tetehagen. Na negsugid kenye na menunga ne kenyeng yegang na lelaki. ");
INSERT INTO plw_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Angkansa iningkut ye dye baꞌ eteg lisag negulinan yegang ye. Sinugid dye kenye, “Inibuanan et egnew ye kegapun meglilingkid eldew meglilisag sembatu.” ");
INSERT INTO plw_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Nerendeman ye na neginalep banar lisag na pegsugid kenye i Jesus, na kwan, “Yegang mu negulinan ne.” Angkan ginsan et seled benwa et pegibuten nemengandel ki Jesus, na ya ating Yegang et Empuꞌ Banar. ");
INSERT INTO plw_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Itue ne ikeruwang keliluꞌlilung tendaꞌ na binwat i Jesus pegsurung ye dut probinsiya et Galilea teyeg dut probinsiya et Judea. ");
INSERT INTO plw_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Pegketbes et itue, maya gasi pegkenkaan et mengeꞌ tawʼt Judio. Angkansa tuminungul si Jesus dut lungsud et Jerusalem. ");
INSERT INTO plw_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Dut lungsud et Jerusalem, mekabiꞌ dut Lelengewan et Bibili, maya libtung duntin, na pegngeranen set beres et Hebreo Betesda. Na dut pelilibut ye maya limang benwa tetegeyan et taaw. ");
INSERT INTO plw_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Atue netimung ginsan mengeꞌ bulensekiten ne mengeꞌ taaw. Maya menglulubid mengeꞌ beleg, mengeꞌ pangkul, bekeꞌ mengeꞌ patey sembelaꞌ bilug. ");
INSERT INTO plw_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","(Sabab maya timpu na dereakan et Empuꞌ mineug supaya kewkewen ye libtung. Baꞌ sinu keuna tumlep dut danum, megnunga megtuy, misan enung ginis nega sakit ye.) ");
INSERT INTO plw_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Maya untin sembatung lelaki telumpuluꞌ walung teun ne sakit ye. ");
INSERT INTO plw_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Nebiriꞌ i Jesus na pebubuntul untin bekeꞌ nesewran ye na samat kwantin ne lagi kekwiten et peresaan ye. Iningkut i Jesus ya, “Ingin mu be megnunga?” ");
INSERT INTO plw_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","“Ilaꞌ,” kwan et bulensekiten in, “Kaya lang misan sinu megtabang daken supaya ipesbur aku baꞌ danum kewkewen ne. Sasat ku pesbur ne teyen maya ne nekeuna set daken.” ");
INSERT INTO plw_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Pegketbes negsugid si Jesus kenye, kwan ye, “Teyeg ne! Bitaꞌ ne iigaan mu! Indyari manew ke ne!” ");
INSERT INTO plw_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Negnunga megtuy lelaki in. Binikyat ye iigaan ye, mendyari nanew ne gasi. Atin neng eldew et Sabadu, Eldew et Kepeternan dut mengeꞌ taaw Judio. ");
INSERT INTO plw_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Angkansa nemegsugid mengeꞌ pegibuten et Judio dut lelaki neꞌ pinenunga, kwan dye, “Eldew et Kepeternan tiban! Diki lang mekedyari biten mu iigaan mu.” ");
INSERT INTO plw_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Segwaꞌ tinubag ye, “Maya lelaki na negpenunga daken, sugid ye, ‘Bikyataꞌ igan-igaan mu in, mendyari manew ke!’ ” ");
INSERT INTO plw_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Na iningkut dye ya, kwan dye, “Sinu itueng taaw na negsugid dimu na, ‘Bikyataꞌ igan-igaan mu mendyari manew ke’?” ");
INSERT INTO plw_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Segwaꞌ kaya nekilala ye baꞌ sinu negpenunga kenye, sabab si Jesus nugad ne dut kineldaman. ");
INSERT INTO plw_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Pegketbes et itue nebiyanan i Jesus ya dut Templo (pengempuan neng benwa) bekeꞌ sinugid i Jesus kenye, “Birinaꞌ, menunga ke ne. Kas ne pegkesalaꞌ kaluꞌ lumbi nega sentin meinabu dimu.” ");
INSERT INTO plw_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Nugad ne lelaki ampaꞌ ye ne sinugiran mengeꞌ pegibuten et mengeꞌ tawʼt Judio, kwan ye, “Si Jesus pelan negpenunga daken.” ");
INSERT INTO plw_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Na sabab negpemuwat si Jesus et Eldew et Kepeternan, sentin ne pegtagnaꞌ et pegraat kenye et mengeꞌ pariꞌ et Judio. ");
INSERT INTO plw_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Segwaꞌ timinubag si Jesus kedye, kwan ye, “Misan Amaꞌ ku pegkeradya sampay itueng eldew, megdemikian daken, pegkeradya ku gasi.” ");
INSERT INTO plw_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Sabab et itueng pinegberes, angkan tiban pegsisipian dye si Jesus apang lebing imeteyen ya, diki lamang et pegsungsang et Eldew et Kepeternan, temed sampay pegsugiren dye na pegtingkagen i Jesus Empuꞌ Banar na kenyeng Amaꞌ, bekeꞌ nekisaliꞌ ya dut Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Tinubag ginsan itue i Jesus, kwan ye, “Sugiran ku kemyu et keberbenaran, kaya mebutbuwat et akung Yegang et diriꞌ lang, segwaꞌ mayang pegbuwaten ku atin lang et mekebiriꞌ ku dut pegkeredyanen et Amaꞌ ku. Sabab baꞌ enu buwaten et Amaꞌ, megdemikian akung Yegang ye atin gasi buwaten ku. ");
INSERT INTO plw_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Sabab pegmergaen et Amaꞌ aku, kenyeng Yegang, bekeꞌ pepebiriꞌ ye daken ginsan bubuwaten ye. Sampay megpebiriꞌ ya et daken et mengeꞌ lebi negang keliluꞌlilung ginis dut kepengliluan myu supaya mengliluꞌ kew banar. ");
INSERT INTO plw_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Sabab baꞌ enukwan mengeꞌ patey bengunen et Empuꞌ Amaꞌ peuliꞌ bekeꞌ begeyan yeʼt biyag, megdemikian aku, Yegang et Empuꞌ, kebgey gasi et biyag dut sebarang meinginan ku begeyan et atin. ");
INSERT INTO plw_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Misan Empuꞌ Amaꞌ diki mengukum et sinu-sinu, segwaꞌ pinegbayaꞌ ye ginsan ukuman dut daken, na Yegang ye. ");
INSERT INTO plw_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Supaya ginsan bumantug daken samat pegbantug dut Empuꞌ Amaꞌ. Sebarang diki bumantug dut Yegang et Empuꞌ diki gasi pegbantug dut Empuꞌ Amaꞌ na negtahag daken. ");
INSERT INTO plw_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Asal banar sugiren ku dimyu, sebarang megkingeg et daken neng bebresen, bekeꞌ mengandel kenye na negtahag daken, maya biyag na kaya seskeran. Bekeꞌ diki ne dusaen dut Narkaꞌ, imbes ne inubuꞌ ne ya dut biyag teyeg dut kepeteyan. ");
INSERT INTO plw_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Sugiran ku kemyu banar,” kwan i Jesus, “na megderateng ne timpu, na asal tiban ne, beres et Yegang et Empuꞌ mekekingeg et mengeꞌ taaw na diki mengandel, antangan dye mengeꞌ patey. Sebarang megkingeg bekeꞌ mengandel, na atin megbiyag. ");
INSERT INTO plw_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Sabab Empuꞌ Amaꞌ maya kepengdyarian menggey et biyag, bekeꞌ akung Empuꞌ Yegang binggeyan ye gasi et kepengdyarian na menggey et biyag. ");
INSERT INTO plw_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Na binggeyan gasi aku et Empuꞌ et kepegbayaan mengukum, sabab aku pegtingkagen Yegang et Taaw.” ");
INSERT INTO plw_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Kas kew megliluꞌ pasal itue, sabab maya timpu na misan dun net lebeng kekingeg nega et bebresen ku. ");
INSERT INTO plw_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Pegketbes memengliwan dye eset mengeꞌ lebeng, sebarang negpemuwat et menununga megbangun dut kebiyagan kaya keskeran dut langit. Segwaꞌ sebarang negpemuwat et kereatan megbangun dye dut kedusaan kaya keskeran dut Narkaꞌ.” ");
INSERT INTO plw_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Negsugid si Jesus, “Baꞌ daken lang kaya mekebutbuwat ku. Pegukumen ku mayang mekekingeg ku lang teyeg dut Empuꞌ, angkansa daken neng ukuman metignaꞌ, sabab teyeg dut keinginan et Empuꞌ na negtahag daken. ");
INSERT INTO plw_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Baꞌ aku lang megpesebanar et bilug ku, daken neng pesebanar diki mekedyari terimanen. ");
INSERT INTO plw_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Segwaꞌ maya iba negpesebanar pasal dut daken, bekeꞌ sewd ku na kenyeng pesebanar pasal daken keberbenaran. ");
INSERT INTO plw_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Negtahag kew sumurung dut ki Juan, bekeꞌ negpesebanar ya et keberbenaran pasal dut daken. ");
INSERT INTO plw_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Diki ku keilangan pesebanar et taaw, segwaꞌ pegbersen ku lang pasal ki Juan supaya mebawiꞌ kew. ");
INSERT INTO plw_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Si Juan sepantun siluꞌ na megdedleg bekeꞌ megbebgey et telang, na neksanan kew et diki nekwit dut telang ye. ");
INSERT INTO plw_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Segwaꞌ maya pesebanar pasal dut daken na lebi negaʼt pesebanar i Juan. Sebarang mengeꞌ keradya na binggey et Empuꞌ daken supaya tebsen, na atin ne pesi pegbuwaten ku. Na atin pegbuwaten ku negpesebanar na aku tinahag et Empuꞌ Amaꞌ. ");
INSERT INTO plw_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Empuꞌ Amaꞌ na negtahag daken. Ya ne pesi negpesebanar pasal dut daken. Kekwiten diki myu nekingeg beres ye bekeꞌ nebiriꞌ kenyeng deregbesan. ");
INSERT INTO plw_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Etawa kenyeng bebresen kaya megteteg dut dimyu, sabab diki kew pengandel dut aku neng tinahag ye. ");
INSERT INTO plw_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Pegbatsaꞌ myu banar dut Kesuratan et Empuꞌ sabab nepikir myu duun maya meisiꞌ myu na biyag kaya seskeran dut langit. Bekeꞌ itueng mengeꞌ Kesuratan negpesebanar pasal dut daken. ");
INSERT INTO plw_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Segwaꞌ mendiꞌ kew mengandel eset daken supaya teyen megbiyag kew et kaya seskeran dut langit.” ");
INSERT INTO plw_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Sinugid i Jesus dut mengeꞌ pariꞌ et Judio, kwan ye, “Diki ku kegeayan bentugen aku et teyeg dut taaw. ");
INSERT INTO plw_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Segwaꞌ sewd ku seled pusuꞌ myu. Bekeꞌ sewd ku na kaya pegmergaꞌ et Empuꞌ dut seled pusuꞌ myu. ");
INSERT INTO plw_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Natuꞌ ku atue sabab et tinahag aku et Empuꞌ Amaꞌ ku, segwaꞌ diki myu aku pegterimanen. Temed baꞌ maya ibang taaw matuꞌ et dimyu sabab dut kenyeng ingaran, pegterimanen myu. ");
INSERT INTO plw_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Enukwan kew kepengandel daken baꞌ pegterimanen myu pegbantug lang et taaw petetaaw? Segwaꞌ diki kew megkeradya supaya meisiꞌ myu pegbantug teyeg dut ating sembebatung Empuꞌ Banar dut langit. ");
INSERT INTO plw_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Segwaꞌ kasiꞌ myu pikiraꞌ na aku megsumbung dimyu dut elepaʼt Empuꞌ Amaꞌ dut emuring ukuman ye. Imbes si Moises tagnaꞌ na pegeerapen myu, ya megsumbung dimyu. ");
INSERT INTO plw_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Baꞌ nengandel kew ki Moises, mengandel kew gasi daken, sabab negsurat ya pasal daken dut seled Kesuratan et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Segwaꞌ, sabab diki myu endelen sebarang sinurat ye, enukwan myu meandel mengeꞌ pinegberes ku in?” ");
INSERT INTO plw_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Pegketbes et itue, duminipag si Jesus dut sembelang dipag et dagat et Galilea, na pegtingkagen dye gasi neng dagat et Tiberias. ");
INSERT INTO plw_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Segwaꞌ mekansang taaw nibut dut kenye sabab nekebiriꞌ dye et mengeꞌ keliluꞌlilung tendaꞌ na binwat dut mengeꞌ taaw naꞌ mesakit, ganang ipinenunga ye dye. ");
INSERT INTO plw_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Pegketbes tuminungul de Jesus bekeꞌ mengeꞌ pepengenaran ye dut kilid et bukid bekeꞌ nemengarung duntin. ");
INSERT INTO plw_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Mekabiꞌ ne tagnaꞌ Paskuwa, atin Kenkaan et Kerendeman Neketaliban et mengeꞌ tawʼt Judio. ");
INSERT INTO plw_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Pegsiyek i Jesus mekansang taaw pesusurung dut kenye, kwan ye ki Pelipe, “Embe elnan tyu et mengeꞌ pegkaan supaya maya kanen et mengeꞌ taaw na itue?” ");
INSERT INTO plw_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Nengingkut et itue supaya sulayan ye lang, sabab sewd ye ne lagi baꞌ enu buwaten ye. ");
INSERT INTO plw_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Siminambag si Pelipe kwan ye, “Tengdan dut walung bulan et pegkeradya, diki lang keelen et pegkaan supaya ipekaan dut ginsan, meraliꞌ tegkasa-kasa ga sumubuꞌ sengketaawan.” ");
INSERT INTO plw_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Maya sembatung pepengenaran ye, si Andres tipused i Simon Pedro, negberes, kwan ye. ");
INSERT INTO plw_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Maya anie e, sembatung yegang neng lelaki maya kenye limang betuen neng bengbang neng sebada, bekeꞌ maya duwang derisekan neng seraꞌ. Segwaꞌ senu ga metenaan ye eset keldamen et taaw na itue?” ");
INSERT INTO plw_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Negsugid si Jesus, kwan ye, “Perungaꞌ mengeꞌ taaw in.” Dun maya mekapal neng keberirian. Nemengarung mengeꞌ taaw, na sebarang lelaki lang mengeꞌ limang ribu keldamen dye. (Sampay mengeꞌ kelilibunan bekeꞌ keyegangan duntin pebebayaꞌ gasi.) ");
INSERT INTO plw_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Kimpetan i Jesus bengbang et yengyegang, ampaꞌ ne negpeselamat dut Empuꞌ, pegketbes ampaꞌ dye ne pinenggey dut ginsan et mengeꞌ taaw na memegarung. Megpesangkaꞌ dye lang misan senu nega kanen dye, kwantin gasi binwat ye dut seraꞌ. ");
INSERT INTO plw_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ganang nemeketbes ne nemengaan, sinugiran i Jesus mengeꞌ pepengenaran ye, kwan ye, “Timungaꞌ myu ginsan mengeꞌ eped dye in, supaya diki meudyasan.” ");
INSERT INTO plw_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Angkansa pinenimung dye ne ginsan, nebaha sempuluꞌ duwang tibung et pinegputek-putek neng bengbang na neped dye nengaan. ");
INSERT INTO plw_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ganang nebiriꞌ et mengeꞌ taaw mengeꞌ keliluꞌliluꞌ neng tendaꞌ ne atin binwat i Jesus, sinugid dye kwan dye, “Landuꞌ banar itue ne naꞌ Tarus et Empuꞌ megderateng atuʼt dunya.” ");
INSERT INTO plw_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Nebiꞌbiriꞌ i Jesus samat maya pikir dye na legesen dye ya buwaten dye et surutan, segwaꞌ mendiꞌ megay ye. Imbes neperayuꞌ yaya ye siminurung peuliꞌ dut budbukid. ");
INSERT INTO plw_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Pegdateng et menginsarem ne, nepesanad mengeꞌ pepengenaran ye dut deplakan. ");
INSERT INTO plw_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Na duun nemenakat et gubang supaya dumipag dye sumurung dut lungsud et Kapernaum. Indyari, pegdateng et meliblingeb ne, segwaꞌ si Jesus kayangga peꞌ nekebayaꞌ dut kedye. ");
INSERT INTO plw_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Na, nasag deres bekeꞌ dimineklaꞌ gumbang. ");
INSERT INTO plw_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ganang pegkaꞌ pegayung dye ne, napet dye meraliꞌ mengeꞌ lima etawa enem neng kilometro ne. Nebiriꞌ dye si Jesus megpepanew dut timbew et dagat. Pekekabiꞌ dut gubang si Jesus pegkebiriꞌ dye, nemenakut ne. ");
INSERT INTO plw_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Segwaꞌ sinugid i Jesus kedye, kwan ye, “Kas kewʼt takut, aku itue.” ");
INSERT INTO plw_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Angkansa nemengsan dye na ampaꞌ ne pinesakat dye ya dut gubang. Na megtuy gubang nekerungguꞌ dut durungguan. ");
INSERT INTO plw_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Pegdatek diklem, nepetaren mengeꞌ kineldaman dut sendipag et dagat. Nebiriꞌ dye na maya lang senggubang duntin. Pikir dye, baꞌ kwantin, kaya lang meraliꞌ nekesakat si Jesus dut gubang naꞌ atin. Tantu mengeꞌ pepengenaran ye lang nemengugad. Kaya pebebayaꞌ si Jesus. ");
INSERT INTO plw_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Segwaꞌ maya mengeꞌ gubang na teyeg dut lungsud et Tiberias nemengdungguꞌ mekabiꞌ dut pinegkenkanan i Jesus et mengeꞌ taaw et bengbang. Atin bengbang mura dye negkenkaan si Jesus negpeselamat mena dut Empuꞌ Banar. ");
INSERT INTO plw_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Pegkaꞌ nesewd-sewran et kekeldaman na kaya duntin si Jesus sampay mengeꞌ pepengenaran ye, nemenakat dye dut gubang surung dut lungsud et Kapernaum supaya ebianen si Jesus. ");
INSERT INTO plw_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ganang nebiyanan dye ne dut sendipag et dagat, iningkut dye si Jesus, “Rabi (Menunulduꞌ), kengyan pegdateng mu atue?” ");
INSERT INTO plw_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Siminambag si Jesus, kwan ye, “Sugiran ku kemyu et kebenaran, pegtulusan myu daken, diki lang sabab ye et mengeꞌ keliluꞌlilung mengeꞌ tendaꞌ, temed sabab ye dut bengbang na nekaan myu seked binyagan kew. ");
INSERT INTO plw_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Kasiꞌ myu pegsengseraiꞌ pegkaan na mekeusibaꞌ lang, temed pegsengseraiꞌ myu pegkaan na kumwit dut biyag na kaya seskeran. Na atin igbey ku, ating Yegang et Taaw, rimyu, sabab pinengerapan ne aku et Empuꞌ Amaꞌ.” ");
INSERT INTO plw_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Pegketbes iningkut dye si Jesus, “Enu keredyanen kay apang mekeradya kay mengeꞌ keinginan et Empuꞌ?” ");
INSERT INTO plw_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Siminambag si Jesus, “Keinginan et Empuꞌ itue ga be, mengandel kew daken na kenyeng dinaak.” ");
INSERT INTO plw_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","31","Sinugid dye dut ki Jesus, “Enung mengeꞌ tendaꞌ na pegbuwaten mu apang mebiriꞌ kay bekeꞌ mengandel dimu? Enu buwaten mu? Nemengaan mengeꞌ kegunggurangan tyu et kekanen neng manna dut kelnangan. Tiaʼt dut Kesuratan tiꞌ et Empuꞌ, ‘Binggeyan ye dye et pegkaan teyeg et langit supaya maya kanen dye.’ Enu takuꞌ neng keradya pegbuwaten mu?” ");
INSERT INTO plw_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Negsugid si Jesus kedye, kwan ye, “Sugiran ku kemyu et keberbenaran, diki lang negey si Moises dimyu et banar neng pegkaan teyeg dut langit. Segwaꞌ, atin Amaꞌ ku negey dimyu banar neng pegkaan teyeg dut langit. ");
INSERT INTO plw_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Sabab ating pegkaan et Empuꞌ, atin ne ya megineug mawaꞌ dut langit na megey et biyag na kaya seskeran dut ginsan taaw atueʼt sengkedunyaan.” ");
INSERT INTO plw_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","“Begerar,” kwan dye, “Begeyiꞌ kay ne daran-peraran et ating pegkaan.” ");
INSERT INTO plw_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Pegketbes negsugid si Jesus, “Aku ating pegkaan na mekepegbegey biyag. Baꞌ sinu kumabiꞌ daken, diki ne urapen, bekeꞌ baꞌ sinu mengandel daken diki ne tuknewen. ");
INSERT INTO plw_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","“Segwaꞌ samat pegsugiren ku dimyu, nekebiriꞌ myu ne aku temed diki nega mengandel kew. ");
INSERT INTO plw_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Pepekabiꞌ daken ginsan neng taaw na igbey et Amaꞌ ku. Ginsan dye mengandel daken pepekabiꞌ daken, diki ku dye sempegen. ");
INSERT INTO plw_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nineug ku teyeg dut langit diki apang buwaten ku daken neng keinginan. Imbes, buwaten ku keinginan et Empuꞌ negtahag daken. ");
INSERT INTO plw_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Na itue keinginan et Empuꞌ negtahag daken, na diki ku pesaran na malam misan sembatung taaw na binggey ye daken. Segwaꞌ biyagen ku dye peuliꞌ dut emuring eldew. ");
INSERT INTO plw_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Sabab itue keinginan et Empuꞌ Amaꞌ. Sebarang kebiriꞌ dut daken yegang ye, bekeꞌ mengandel dut daken maya biyag na kaya seskeran, bekeꞌ biyagen ku ya peuliꞌ dut emuring eldew.” ");
INSERT INTO plw_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Na mengeꞌ Judio nemegkiskines pasal ki Jesus sabab dut sinugid ye, “Aku ating pegkaan na teyeg dut langit.” ");
INSERT INTO plw_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Kwan dye, “Diki takuꞌ itue si Jesus, yegang i Jose. Nesewran tyu amaꞌ bekeꞌ induꞌ ye? Enukwan pegsugiren ye tiban atin, kwan ye, ‘Nineug ku teyeg dut langit.’ ” ");
INSERT INTO plw_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Kwan i Jesus, “Kas kew ne pegkiskines. ");
INSERT INTO plw_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Kaya sinu mekepekabiꞌ daken selyu lang ya in ipekabiꞌ et Amaꞌ na negtahag daken. Sebarang mengandel daken mibit na biyagen ku ya peuliꞌ dut emuring eldew. ");
INSERT INTO plw_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Nesurat dut Kesuratan et mengeꞌ Tarus et Empuꞌ, kwan, ‘Na dyeng ginsan penulduan et Empuꞌ.’ “Sebarang megkingeg dut Empuꞌ Amaꞌ bekeꞌ negkesewd dut kenye, atin pepekabiꞌ daken. ");
INSERT INTO plw_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Kaya sinu nekebiriꞌ dut Empuꞌ Amaꞌ selyu lang aku na teyeg dut Empuꞌ. Aku lang na nekebiriꞌ dut Empuꞌ Amaꞌ. ");
INSERT INTO plw_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Isugid ku dimyu et keberbenaran, sebarang mengandel daken maya biyag na kaya seskeran. ");
INSERT INTO plw_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Aku pegkaan na mekepegbegey et biyag,” sinugid i Jesus. ");
INSERT INTO plw_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","“Kegunggurangan myu nemekekaan et manna dut kelnangan tagnaꞌ, segwaꞌ nemematey dye nega. ");
INSERT INTO plw_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Temed itue pegkaan tiban nineug teyeg dut langit, angkansa sebarang taaw kekaan diki lang matey. ");
INSERT INTO plw_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Aku biyag neng kekanen na nineug teyeg dut langit. Baꞌ kanen et taaw itueng kekanen, megbiyag ya misan ingyan. Itueng kekanen, daken neng uned. Na atin ipemgey ku apang pebibiyag et kaya seskeran mengeꞌ taaw atuʼt dunyaꞌ,” kwan i Jesus. ");
INSERT INTO plw_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Na nemegsagkaꞌsagkaꞌ dye banar na mengeꞌ tawʼt Judio, kwan dye, “Enukwan ye igbey kenyeng uned supaya kanen tyu?” ");
INSERT INTO plw_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Kwan i Jesus kedye, “Isugid ku dimyu et keberbenaran, selyu lang kanen myu uned et Yegang et Taaw bekeꞌ inumen kenyeng duguꞌ, kaya lang biyag dut dimyu. ");
INSERT INTO plw_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Sebarang kumaan et uned ku bekeꞌ minum et duguꞌ ku maya biyag na kaya seskeran. Na biyagen ku ya peuliꞌ dut emuring eldew. ");
INSERT INTO plw_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Sabab daken neng uned banar na kekanen, bekeꞌ daken neng duguꞌ banar na inumen. ");
INSERT INTO plw_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Sinu-sinu mengaan et daken neng uned bekeꞌ minum et daken neng duguꞌ petetaren ne dut daken, bekeꞌ aku dut kenye. ");
INSERT INTO plw_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Samat pebibiyag naꞌ Empuꞌ Amaꞌ na negtahag daken, kwantin gasi aku pebibiyag sabab dut Empuꞌ Amaꞌ. Angkansa sinu-sinu megpengaan dut daken megbiyag sabab ku. ");
INSERT INTO plw_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Itue e pegkaan nineug teyeg dut langit. Misan kenggunggurangan tyu nemekekaan et manna, nemematey dye nega. Segwaꞌ sebarang mengaan et itueng kekanen megbiyag et kaya seskeran.” ");
INSERT INTO plw_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Pinegberes i Jesus itue sasat penulduꞌ dut pengempuan na benwa neng sinagoga dut lungsud et Kapernaum. ");
INSERT INTO plw_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ganang nekingeg itue kekensangan et mengeꞌ pepengenaran i Jesus negsugid, “Mebegat neng tulduꞌ itue. Sinu mekedyari kekingeg et atin?” ");
INSERT INTO plw_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Segwaꞌ pegkesewd i Jesus na mengeꞌ pepengenaran ye na nemegkiskines pasal itue. Kwan i Jesus kedye, “Sabab be et itue tirengan myu aku? ");
INSERT INTO plw_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Enukwan gasi baꞌ mebiriꞌ myu aku, atin Yegang et Taaw, peribuwat dut langit na baꞌ embe mawaꞌ ku sene in! ");
INSERT INTO plw_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Empung Nakem megbegey et biyag. Segwaꞌ keseg et taaw kaya kegunaan menggey et biyag et taaw. Sebarang pinegberes ku dimyu, atin igbey biyag sabab atin teyeg nega et Empung Nakem. ");
INSERT INTO plw_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Segwaꞌ maya nega dimyu kaya pengandel daken,” sinugid i Jesus. Sabab sewd i Jesus tihad sengkepunan baꞌ sinu kedye diki mengandel, bekeꞌ baꞌ sinu mengakal supaya ipegdagang diri ye. ");
INSERT INTO plw_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Sinugpatan i Jesus bebresen ye, kwan ye, “Angkan ne itue pegsugiren ku dimyu, kaya sinu kepekabiꞌ daken selyu lang tugutan ya et Amaꞌ Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ating masa mekansang ne pepengenaran i Jesus timinireng kenye, bekeꞌ kaya ne nibut dut kenye. ");
INSERT INTO plw_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Sinugid i Jesus kedye, dut sempuluꞌ duwa in, kwan ye, “Kemyu gasi? Gaay myu mugad?” ");
INSERT INTO plw_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Siminambag si Simon Pedro dut kenye, “Begerar, sinu nega ibuten kay? Eset dimu ne beres et biyag na kaya seskeran. ");
INSERT INTO plw_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nengandel bekeꞌ nesewran kay na ikew ating sembebatung kaya salaꞌ et Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Siminambag si Jesus, kwan ye, “Diki be piniliꞌ ku kemyung sempuluꞌ duwa in? Segwaꞌ, maya sembatu dimyu sinelban i Seytan.” ");
INSERT INTO plw_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Pepetudyaʼt bebresen i Jesus ki Judas, na yegang i Simon Iskariote. Na ya neng sembatu dut sempuluꞌ duwa na mengakal ki Jesus peuliꞌ tiꞌ. ");
INSERT INTO plw_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Pegketbes et itue, siminurung si Jesus dut leing-leing kebenwanan et probinsiya et Galilea. Pikir ye ne lumegdeng et merayuꞌ dut probinsiya et Judea. Sabab duntin maya mengeꞌ tawʼt Judio megtetagey mematey kenye. ");
INSERT INTO plw_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Segwaꞌ ganang mekabiꞌ ne pegkenkaan et mengeꞌ tawʼt Judio pasal et Kerendeman et mengeꞌ Tetetluan et mengeꞌ Judio dut kelnangan, ");
INSERT INTO plw_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","mengeꞌ tipused i Jesus negsugid dut kenye, kwan dye, “Subaliꞌ mugad ke atue e bekeꞌ sumurung ke dut Judea, supaya mengeꞌ pepengenaran mu kebiriꞌ et mengeꞌ bubuwaten mu neng keliluꞌliluꞌ. ");
INSERT INTO plw_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kaya misan sinu pegtaguꞌ et keradya ye baꞌ ingin ye mebantug et ginsang mengeꞌ taaw. Pegbuwaten mu ne lang gasi itueng ginis, pebiriꞌ ke ne dut ginsan mengeꞌ taaw atueʼt dunyaꞌ.” ");
INSERT INTO plw_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Sinugid itue et mengeꞌ tipused i Jesus, sabab kenyeng mengeꞌ ketipusdan, kayangga peꞌ megpengandel dut kenye. ");
INSERT INTO plw_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Kwan i Jesus kedye, “Sugat neng timpu ku ingga peꞌ diminateng; Segwaꞌ dut dimyu misan enung timpu mekedyari. ");
INSERT INTO plw_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Kaya miseg dimyu mengeꞌ taaw. Segwaꞌ dye megiseg daken, sabab pinesebenaran ku kedyeng keradya neng mereraat. ");
INSERT INTO plw_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kemyu mene dumuntin dut kenkeanan dut lungsud et Jerusalem. Mendiꞌ ku mena daken, sabab daken neng sugat neng timpu ingga peꞌ diminateng.” ");
INSERT INTO plw_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Pegimbes et bebresen ye, nepetektak dut Galilea. ");
INSERT INTO plw_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Segwaꞌ, ganang nemekeugad ne mengeꞌ ketipusdan i Jesus pesurung dut kenkeanan dut Jerusalem, nepeselundung gasi ya. Segwaꞌ kaya nesewran et mengeꞌ kineldaman, nepetetaguꞌ lang. ");
INSERT INTO plw_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Maya pegtulusen ya et mengeꞌ tawʼt Judio dut kenkeanan sampay nemengingkut-ingkut ne, “Embe ne ating lelaki?” ");
INSERT INTO plw_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Eset kineldamaʼt taaw limingkep bungburung pasal kenye. Kwan et iba, “Menungang taaw atin.” Kwan et iba gasi, “Meraat, sabab pengakal lang et mengeꞌ taaw.” ");
INSERT INTO plw_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Kaya misan sinu mekeurem na megsugid et enu-enu pasal ki Jesus eset elepan et kineldaman, sabab megtakut dye et mengeꞌ pegibuten et tawʼt Judio. ");
INSERT INTO plw_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Megtetetngaꞌ peꞌ et Kenkaan et Kerendeman et mengeꞌ Tetetluan, si Jesus diminuntin dut Templo na pengempuan neng benwa apang menulduꞌ. ");
INSERT INTO plw_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Nemengliluꞌ mengeꞌ pegibuten et tawʼt Judio sampay nemengingkut, kwan dye, “Enukwan negkesewd itueng taaw sementaraꞌ kaya pinegiskulan?” ");
INSERT INTO plw_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Siminambag si Jesus, kwan ye, “Pegtulduꞌ ku diki teyeg dut pinegiskulan ku. Segwaꞌ mawaꞌ dut Empuꞌ negtahag daken. ");
INSERT INTO plw_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Baꞌ keinginan et sinu-sinu na buwaten ye keinginan et Empuꞌ, mekilala ye na baꞌ daken neng tulduꞌ teyeg dut Empuꞌ etawa baꞌ teyeg dut daken lang. ");
INSERT INTO plw_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Sebarang pegberes pasal et kenyeng bubuwaten, supaya bentugen bilug ye kaya menunga. Segwaꞌ baꞌ sinu pegberes pasal et bubuwaten ye apang ikebantug dut negtahag kenye, ya metignaꞌ neng taaw, banar kaya embut dut kenye.” ");
INSERT INTO plw_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Sinugid gasi i Jesus dut kedye, kwan ye, “Tagnaꞌ tiꞌ, diki be binggey i Moises dimyu atin Keseraan et Empuꞌ? Segwaꞌ kaya misan sembatu dimyu nekesunud. Manu ingin myu aku imeteyen?” ");
INSERT INTO plw_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Siminambag kineldaman, kwan dye, “Banar ne, megsesaleb dimu diwata i Seytan! Sinu meingin mengimatey dimu?” ");
INSERT INTO plw_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Kwan i Jesus kedye, “Sene tiꞌ, maya kineradya ku ganang sembatung keliluꞌlilung tendaꞌ dut Eldew et Kepeternan, na ginsan kew negliluꞌ. ");
INSERT INTO plw_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Diki be negey si Moises et arat et pegtutuliꞌ et mengeꞌ keyegangan myu? (Temed diki teyeg itue ki Moises, imbes dut mengeꞌ kegunggurangan.) Na pegtulien myu yengyegang misan ne dut Eldew et Kepeternan. ");
INSERT INTO plw_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Segwaꞌ baꞌ pegtulien myu yengyegang dut Eldew et Kepeternan supaya diki belegbagen Keseraan i Moises, manu angkan megiseg kew raken sabab et pinenunga ku sengkebilugan et taaw dut Eldew et Kepeternan? ");
INSERT INTO plw_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Kasiꞌ myu pegukumiꞌ sebarang deregbesan, segwaꞌ mengukum kew et metignaꞌ.” ");
INSERT INTO plw_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Pasal et atin maya nemengingkut mengeꞌ taaw et lungsud et Jerusalem, kwan dye, “Diki be itueng taaw pegsenggupan dye peteyen? ");
INSERT INTO plw_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Na itue ne ya, pegberes atuʼt elepan tyu. Manu gasi kaya pegsegkaan dye pasal dut kenye? Meraliꞌ nekilala et mengeꞌ pegibuten na si Jesus ne ating Kristo, ating Mesias tyu? ");
INSERT INTO plw_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Segwaꞌ nesewran tyu baꞌ embe mawaꞌ et itueng lelaki. Segwaꞌ baꞌ dumateng Mesias, kaya sinu mekesewd baꞌ embe banar mawaꞌ ye.” ");
INSERT INTO plw_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ganang megtutulduꞌ si Jesus dut pengempuan neng benwa naꞌ Templo pinerensag ye bebresen ye, kwan ye, “Eꞌ, pegpikiren myu takuꞌ mekekilala myu aku, bekeꞌ baꞌ embe minewanen ku. Segwaꞌ diki natuꞌ ku atue et daken neng gaay, temed sabab et gaay et kebebenaran neng negtahag daken. Na diki myu ya nekilala. ");
INSERT INTO plw_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Segwaꞌ daken, nekilala ku ya sabab mawaꞌ ku dut kenye bekeꞌ ya negtahag daken.” ");
INSERT INTO plw_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Sabab et atin pegperuen dye ya elewen, temed kaya mekeakuꞌ mengalew sabab ingga peꞌ diminateng timpu et ketiksaan ye. ");
INSERT INTO plw_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Maya gasi dut kineldaman na nengandel ki Jesus, kwan dye, “Na, banar, itueng taaw Mesias, sabab kaya ibang taaw kebaal et lebi nega eset mengeꞌ keliluꞌlilung tendaꞌ na binwat et lelaki na itue.” ");
INSERT INTO plw_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Nekingeg et mengeꞌ pariꞌ naꞌ Pariseo bungburung et mengeꞌ kineldaman pasal ki Jesus. Pagkaꞌ kwantin ne mengeꞌ pegibuten et mengeꞌ pariꞌ sampay gasi mengeꞌ Pariseo negtahag et kesundeluan supaya mengalew ki Jesus. ");
INSERT INTO plw_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Kwan i Jesus, “Megbebayaꞌ tyu nega tiban. Segwaꞌ diki ne mekwit, pegketbes in, peuliꞌ ku ne dut negtahag daken. ");
INSERT INTO plw_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Tulusen myu aku, segwaꞌ diki myu aku mebiyanan. Bekeꞌ diki kew keruntin dut pegsusurungan ku.” ");
INSERT INTO plw_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Nemegsudsugid mengeꞌ tawʼt Judio, kwan dye, “Embe takuꞌ tenaan et lelaki na itue na diki tyu ya mebiyanan? Meraliꞌ tenaan ye dut mengeꞌ nemegpekparak neng mengeꞌ kekempungan tyu dut lungsud et Griego, bekeꞌ megtulduꞌ dut mengeꞌ taaw et Griego? ");
INSERT INTO plw_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Enu ingin yeng bersen na pegsugiren ye, ‘Tulusen myu aku, segwaꞌ diki myu aku mebiyanan.’ Bekeꞌ, ‘diki kew keruntin dut pegsurungan ku?’ ” ");
INSERT INTO plw_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Dut ketimpusaʼt pinekemergang eldew et kelang Kenkaan et Kerendeman et mengeꞌ Teteluan, timinyeg si Jesus bekeꞌ negberes et merensag, “Baꞌ sinung taaw pegtutuknewen, pekabiꞌ daken apang keinum. ");
INSERT INTO plw_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Sebarang mengandel daken, samat pegbersen dut Kesuratan et Empuꞌ, ‘Antangan ye murbur danum dut seled ye megmendyaring ikebiyag et kaya seskeran.’ ” ");
INSERT INTO plw_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ingin bersen ye, itue e Nakem et Empuꞌ, sebarang mengengandel dut kenye leyd ne tiꞌ meterima dye itueng Nakem et Empuꞌ. Tatap ating eldew ingga peꞌ negbey Nakem, sasat si Jesus ingga peꞌ neperibuwat peuliꞌ dut langit apang bentugen. ");
INSERT INTO plw_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ganang nekingeg itueng bebresen, mekansang kedye negberes, kwan dye, “Ya ne tantung ating Tarus et Empuꞌ na pegtegeyan tyu.” ");
INSERT INTO plw_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Iba gasi negberes, “Ya ne atin Kristo.” Segwaꞌ iba pemengingkut nega, kwan dye, “Lein ya ating Kristo. Sabab atin Kristo diki teyeg dut Galilea. ");
INSERT INTO plw_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Diki be pegbersen dut Kesuratan et Empuꞌ na ating Kristo teyeg dut tutusan i Surutan Dabid tagnaꞌ, bekeꞌ teyeg dut lungsud et Betlehem, lungsud naꞌ dineklaan i Surutan Dabid?” ");
INSERT INTO plw_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Angkansa mengeꞌ taaw negbagiꞌbagiꞌ ne pasal lang i Jesus. ");
INSERT INTO plw_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Maya taaw meingin ya elewen, segwaꞌ kaya neburwan dye. ");
INSERT INTO plw_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Negpeuliꞌ mengeꞌ kesundeluan dut mengeꞌ pegibuten et mengeꞌ pariꞌ sampay dut mengeꞌ Pariseo. Na dye nengingkut kedye, kwan dye, “Manu diki myu binibit atue?” ");
INSERT INTO plw_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Siminambag mengeꞌ kesundeluan, kwan dye, “Kengyan masa ne kaya sinu nekepegberes samat pinegberes et ating lelaki.” ");
INSERT INTO plw_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","“Ingin myu bersen, nebitbibit ye gasi kemyu?” kwan et mengeꞌ Pariseo. ");
INSERT INTO plw_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","“Maya ne be takuꞌ mengeꞌ pegibuten etawa mengeꞌ Pariseo nengandel kenye? ");
INSERT INTO plw_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Kaya! Segwaꞌ mesuknaan itueng kineldaman, sabab kaya kesewd-sewran dye pasal et mengeꞌ Keseraan i Moises.” ");
INSERT INTO plw_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Si Nikodemo, na sembatung Pariseo iba-iba dye, na siminurung nekeuna tiꞌ dut ki Jesus, nengingkut. ");
INSERT INTO plw_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Kwan ye, “Megsugat be dut ukuman tyu baꞌ sembatung taaw diki mena sewd-sewren baꞌ enu nebuwat ye?” ");
INSERT INTO plw_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Siminambag dye, “Ikew teyeg dut Galilea gasi? Resan-resanaꞌ na mebiriꞌ mu na kaya tumbuꞌ naꞌ tarus dut Galilea.” ");
INSERT INTO plw_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Pegketbes nemenguliꞌ dye tegsembatu dut kenye-kenyeng benwa. ");
INSERT INTO plw_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Segwaꞌ si Jesus siminurung dut Bukid et Olibo. ");
INSERT INTO plw_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ganang meririkleman ne, negpebiriꞌ ya peuliꞌ dut pengempuan neng benwa (Templo). Na, mekansang taaw nepekabiꞌ dut kenye. Narung gasi ampaꞌ ye dye tinulduan. ");
INSERT INTO plw_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Mengeꞌ menunulduꞌ et mengeꞌ saraꞌ bekeꞌ mengeꞌ pariꞌ na Pariseo nemibit et sembatung libun ne netkanan pegbeis. Pinetiyeg dye eset kinetngaan et kineldaman. ");
INSERT INTO plw_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Sinugid dye ki Jesus, kwan dye, “Menunulduꞌ, itueng libun inalew kay sabab netkanan pegbeis. ");
INSERT INTO plw_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Dut Keseraan binggey et Empuꞌ ki Moises tagnaꞌ, si Moises negsugid damen na bekalen et mengeꞌ batu seked matey baꞌ sinu memuwat samat binwat ye tuꞌ. Enu mesugid mu ramen?” ");
INSERT INTO plw_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Kwantin pengingkut dye supaya lang si Jesus sulayan, apang maya mesumbung dye pasal dut kenye. Segwaꞌ diminunguk lang si Jesus bekeꞌ negsutsurat et keremut ye dut lugtaꞌ. ");
INSERT INTO plw_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pegkaꞌ sigi-sigi ne ingkut dye kenye, timinyeg si Jesus et metignaꞌ bekeꞌ negsugid kedye, kwan ye, “Baꞌ sinu dimyu kaya negkesalaꞌ, atin mena meguna ne meakal kenye.” ");
INSERT INTO plw_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Neperunguk gasi si Jesus peuliꞌ, na negsurat gasi dut lugtaꞌ. ");
INSERT INTO plw_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Segwaꞌ ganang nekingeg dye itue, kenye-kenye mene mugad, meguna megurang-gurang, sed-seked si Jesus mene netinda, iba ye libun naꞌ petitiyeg et elepan ye. ");
INSERT INTO plw_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Timinyeg gasi si Jesus bekeꞌ nengingkut kenye, kwan ye, “Libun, embe dye ne? Kaya be misan sembatu kedye nengdusa dimu?” ");
INSERT INTO plw_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","“Menunulduꞌ, kaya misan sembatu!” kwan ye. “Megsepantun daken diki lang mengdusa dimu,” kwan i Jesus, “Manew ke ne, kasiꞌ ne pegerut-erutiꞌ megkesalaꞌ.” ");
INSERT INTO plw_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ganang negberes peuliꞌ si Jesus dut mengeꞌ taaw, kwan ye, “Antangan ku samat siluꞌ et ginsaʼt taaw atueʼt sengkedunyaan. Sebarang mibut daken, diki lang manew dut kelingban, sabab maya siluꞌ et biyag, (na megbebgey et telang eset pikiran et mengeꞌ taaw).” ");
INSERT INTO plw_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Binulili et mengeꞌ Pariseo ya, kwan dye, “Kaya misan sinu pepesebanar dimu selyu ikew lang. Angkansa dimung pesebanar kaya kebenaran.” ");
INSERT INTO plw_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Kwan i Jesus, “Misan ne aku lang pegpesebanar pasal diri kung bilug, pesebanar ku kebenaran. Sabab sewd ku baꞌ embe mawaꞌ ku, sampay baꞌ embe gasi ulian ku. Segwaꞌ dimyu, kaya pegsesewren myu baꞌ embe mawaꞌ ku, etawa baꞌ embe surungan ku. ");
INSERT INTO plw_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ukuman myu, ukuman lang et taaw petaaw. Segwaꞌ daken, kaya neukum ku misan sembatu. ");
INSERT INTO plw_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Segwaꞌ, baꞌ mengukum ku, ukuman ku sugat, sabab diki lang yaya ku. Iba ku si Amaꞌ, neng nengdaak daken. ");
INSERT INTO plw_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Dut dimyung Keseraan nesurat na, kwan, ‘Baꞌ duwang taaw megpesebanar, atin kebenaran.’ ");
INSERT INTO plw_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Aku ne sembatu negpesebanar pasal daken neng bilug, ikeruwa na negpesebanar daken, atin net nengdaak daken, daken neng Amaꞌ.” ");
INSERT INTO plw_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Mendyari iningkut dye si Jesus, “Naꞌ embe tuꞌ amaꞌ mu?” Kwan i Jesus, “Diki myu aku kilala etawa daken neng Amaꞌ. Baꞌ mekilala myu aku, mekilala myu gasi Amaꞌ ku.” ");
INSERT INTO plw_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Pinegberes ye itue sasat pegtulduꞌ ya dut seled benwa pengempuan naꞌ Templo, dut sisingled na maya susunuaʼt keserekaan. Segwaꞌ kaya misan sembatu pengalew kenye sabab ingga napet sugat neng timpu ye. ");
INSERT INTO plw_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Angkansa, pinegberes gasi peuliꞌ i Jesus, kwan ye, “Kepembe-embe ku nega, sampay megtustulus kew raken, segwaꞌ matey kew megbeꞌbayaꞌ nega dimyung keselaan. Diki lang keruntin kew dut sinurungan ku.” ");
INSERT INTO plw_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Sabab et itue nemegsiingkut-ingkut mengeꞌ pegibuten et tawʼt Judio, “Imeteyen ye meraliꞌ bilug ye? Sabab manu itue pinegberes ye, kwan ye, ‘Diki kew kesurung dut pegsusurungan ku?’ ” ");
INSERT INTO plw_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Sinugid i Jesus dut kedye, kwan ye, “Kemyu mawaꞌ atuʼt sirib, aku mawaꞌ dut dibuwat langit. Kemyu mawaꞌ atuʼt dunyaꞌ, segwaꞌ aku diki lang mawaꞌ atuʼt dunyaꞌ. ");
INSERT INTO plw_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Atin angkan sinugid ku dimyu, na, matey kew megbeꞌbayaꞌ dimyung keselaan. Sabab, baꞌ diki mengandel kew na aku in, si Aku Ne Ya, matey kew lang megbebayaꞌ nega mengeꞌ keselaan myu.” ");
INSERT INTO plw_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","“Sinu ke takuꞌ banar?” neingkut dye. Sambag i Jesus, kwan ye, “Atin ne pesi samat pegsugiren ku in, tihad nega tagnaꞌ nega tiꞌ. ");
INSERT INTO plw_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mekansang teyen ipegberes ku dimyu supaya iukum dimyu. Segwaꞌ metignaꞌ ya in nengdaak daken, sampay baꞌ enu nekingeg ku dut kenye, atin ipebunayag ku dimyu atuʼt sengkedunyaan tuꞌ.” ");
INSERT INTO plw_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Segwaꞌ diki dye neretian baꞌ enu pegsugiren i Jesus pasal dut kenyeng Amaꞌ, ingin bersen Empuꞌ Banar. ");
INSERT INTO plw_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Angkansa kwan i Jesus, “Baꞌ meperibuwat myu ne Yegang et Taaw dut erigi, ampaꞌ myu sentin mesewran na asal aku ne atin ne ya. Na mekesewran myu gasi, kaya pegbutbuwaten ku et daken neng bilug baꞌ diki pegbersen ku samat mekekingeg ku teyeg dut Amaꞌ. ");
INSERT INTO plw_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Na iba-iba ku ya, ne nengdaak daken na diki ye aku tirengan et yaya ku, sabab tatap ku pegbuwaten sebarang mekeksan kenye.” ");
INSERT INTO plw_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Sasat megbebres nega si Jesus pasal et itue, mekansang nemengandel dut kenye. ");
INSERT INTO plw_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Sinugid i Jesus dut mengeꞌ tawʼt Judio na nemengandel dut kenye, kwan ye kedye, “Baꞌ mibut kew daran dut mengeꞌ tulduꞌ ku, kemyu tantung mengeꞌ pepengenaran ku. ");
INSERT INTO plw_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Na mesewran myu keberbenaran teyeg et Empuꞌ. Ating keberbenaran memawiꞌ dimyu teyeg dut peguripen.” ");
INSERT INTO plw_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Na sinambag dye ki Jesus, kwan dye, “Pangkat inupuꞌ kami i Abraham. Na kaya misan kasa nenguripen damen. Manu pegsugiren mu na bewinen kay?” ");
INSERT INTO plw_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Siminambag si Jesus, kwan ye, “Asal banar na pegsugiren ku dimyu, sebarang negkesalaꞌ, uripen et keselaan. ");
INSERT INTO plw_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Naꞌ diki dumaran uripen dut sembatung pegkeredyanan ye dut pamilya, segwaꞌ dumaran ating Yegang et pamilya misan ingyan. ");
INSERT INTO plw_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Angkansa baꞌ bewinen ke et Yegang, banar na nekebawiꞌ ke ne, sabab Yegang maya keseg ye. ");
INSERT INTO plw_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Sewd ku na pangkat inupuꞌ kew i Abraham. Segwaꞌ meingin kew na imeteyen aku, sabab kaya ne awang dut seled pusuꞌ myu beberesen ku. ");
INSERT INTO plw_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Pegbersen ku sebarang nekebiriꞌ ku dut elepaʼt Amaꞌ ku, segwaꞌ dut dimyu pegbuwaten myu gasi sebarang nekingeg myu dut Amaꞌ myu.” ");
INSERT INTO plw_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","“Si Abraham amaꞌ kay,” kwan dye. Segwaꞌ kwan i Jesus, “Baꞌ kemyu keyegangan i Abraham, buwataꞌ myu gasi baꞌ enu keradya i Abraham. ");
INSERT INTO plw_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Na atin negsugid dimyu et keberbenaran na nekingeg ku dut Empuꞌ. Segwaꞌ pegsesenggupan myu aku imeteyen. Si Abraham kaya nekekeradya samat kwantin. ");
INSERT INTO plw_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Pegkeredyanen myu tuꞌ samat pegkeredyanen et Amaꞌ myu.” Siminambag dye, kwan, “Diki lang kami yegang dut liwan. Imbes sembatu lang amaꞌ kay, na atin, Empuꞌ lang.” ");
INSERT INTO plw_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Kwan i Jesus kedye, “Baꞌ Empuꞌ banar Amaꞌ myu, teyen inginen myu aku, sabab teyeg ku dut Empuꞌ. Na tiban, natuꞌ ku atue, diki lang natuꞌ kuʼt sabab et ingin ku, imbes dinaak et Empuꞌ aku. ");
INSERT INTO plw_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Manu kaya mekeretian myu baꞌ enu pegbersen ku? Sabab kaya pegkinggen myu baꞌ enu pegbersen ku.” ");
INSERT INTO plw_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Sinugid gasi i Jesus kedye, kwan ye, “Kemyu yegang i Seytan, na keinginan myu samat keinginan et buwaten et amaꞌ myu. Na ya mengingimatey et taaw tihad tagnaꞌ nega. Na, kaya megibut dut keberbenaran sabab kaya dut kenye keberbenaran. Baꞌ mengembut, pegberes et keembutan, na atin ne tubuanan ye, sabab ya puun et ginsaʼt mengeꞌ taaw neng membut. ");
INSERT INTO plw_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Segwaꞌ, sabab pegbersen ku pasal dut keberbenaran, diki megpengandel kew. ");
INSERT INTO plw_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Sinu dimyu mekepesebanar na aku negkesalaꞌ? Baꞌ sembatung taaw pegsugid et kebenaran, manu diki myu endelen? ");
INSERT INTO plw_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Sebarang mengeꞌ taaw na pengandel et Empuꞌ megkingeg dye dut beres et Empuꞌ. Na sebaban angkan manu diki kew megkingeg, sabab diki kew taaw na pengandel et Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Siminambag ki Jesus mengeꞌ tawʼt Judio, kwan dye, “Diki takuꞌ sugat na pegsugiren kay na ikew tawʼt Samaritano, leing tawʼt Judio, bekeꞌ pegselban et diwata i Seytan?” ");
INSERT INTO plw_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Siminambag si Jesus, kwan ye, “Kaya lang aku pegselban et diwata i Seytan. Segwaꞌ, daken, pegbentugen ku Amaꞌ ku. Temed dimyu pegterwanan myu nega aku. ");
INSERT INTO plw_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Kaya pegtulusen ku kebentugan ku. Segwaꞌ maya sembatu megtulus na bentugen ye aku. Itue na ya, atin naꞌ mengungukum. ");
INSERT INTO plw_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Asal banar pegsugiren ku dimyu, sebarang penuman et mengeꞌ bebresen ku, diki kelabay et kemeteyan na kaya seskeran.” ");
INSERT INTO plw_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Segwaꞌ kwaʼt mengeꞌ Judio, “Naꞌ tiban kay netantu na ikew sinlebat diwata i Seytan! Si Abraham natey sampay mengeꞌ tarus et Empuꞌ. Segwaꞌ, pegberes ke nega et baꞌ taaw metuman et beres mu, diki kelabay et (ikeruwang) kemeteyan na kaya seskeran. ");
INSERT INTO plw_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Metaas ke nega be takuꞌ et damen neng amaꞌ neng si Abraham? Na ya natey, kwantin gasi mengeꞌ tarus. Kwan mu lang sinu ke?” ");
INSERT INTO plw_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Siminambag si Jesus, kwan ye, “Baꞌ ipetaas ku bilug ku, kaya guna et ketaasan ku. Segwaꞌ amaꞌ ku pegpetaas daken, na atin ne pegsugiren myu na Empuꞌ myu banar. ");
INSERT INTO plw_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Segwaꞌ diki myu ya nekilala, temed aku mekekilala kenye. Na supama, baꞌ sugiren ku diki ku nekilala Empuꞌ, baꞌ kwantin, membut ku samat dimyu. Temed kilala ku Ya banar bekeꞌ pegtumanen ku Ya. ");
INSERT INTO plw_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Megunang gunggurang myung si Abraham tagnaꞌ tiꞌ neksanan sabab nesewran ye mebiriꞌ ye eldew et pegatuꞌ ku atueʼt dunya. Na nebiriꞌ ye na eldew et pegatuꞌ ku sampay neksanan.” ");
INSERT INTO plw_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Kwan et mengeꞌ tawʼt Judio, “Inggaꞌ peꞌ nekeumur ke et limangpulung teun, segwaꞌ nebiriꞌ mu ne si Abraham?” ");
INSERT INTO plw_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Segwaꞌ kwan i Jesus, “Asal, mura si Abraham pinegyegang, lelagi ku ne!” ");
INSERT INTO plw_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Sabab et itue, nememurut dye et mengeꞌ batu ibakal ki Jesus. Segwaꞌ nepetaguꞌ si Jesus pegketbes liminiwan dut pengempuan neng benwang Templo. ");
INSERT INTO plw_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Pegtalib i Jesus, nebiriꞌ ye sembatung lelaki beleg ne lagi tihad nega dut pegyegang kenye. ");
INSERT INTO plw_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Iningkut et mengeꞌ pepengenaran ye, kwan dye, “Menunulduꞌ, sinu negkesalaꞌ, itueng lelaki etawa kenyeng gunggurang, na ya pinegyegang et beleg?” ");
INSERT INTO plw_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Sinambag i Jesus, kwan ye, “Diki itueng lelaki etawa mengeꞌ gunggurang ye negkesalaꞌ. Segwaꞌ negkwantin itue supaya keradya et Empuꞌ mepebiriꞌ dut kenyeng biyag. ");
INSERT INTO plw_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Sasat eldew nega, subaliꞌ keredyanen tyu mengeꞌ keradya et Empuꞌ Banar negdaak daken. Gebi megapet, ganang kaya ne misan sinu mekekeradya. ");
INSERT INTO plw_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Sementaraꞌ atuꞌ ku nega et dunyaꞌ, aku siluꞌ et sengkedunyaan, megbegey et telang dut pikiran et mengeꞌ taaw.” ");
INSERT INTO plw_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ganang nebres i Jesus itue, nibeg dut lugtaꞌ ampaꞌ ye pinerusuꞌ et ibeg ye. Pegketbes pinadlis yeʼt mata et lelaki neng beleg. ");
INSERT INTO plw_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","“Panew!” kwan i Jesus kenye, “Dumun ke dut libtung et Siloe.” (Na ingin bersen Siloe, Tinahag). Angkansa, lelaki nanew. Pegdateng dun nengiramus, na neketuun ne, ampaꞌ ne nuliꞌ. ");
INSERT INTO plw_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Mengeꞌ rurungan ye bekeꞌ mengeꞌ nekebiriꞌ kenye et kwit nega ya pepeingasiꞌ, nemegsudsugid dye, kwan dye, “Diki be saliꞌ itue neng lelaki kwit tiꞌ megarung atue sampay pengangat et ingasiꞌ?” ");
INSERT INTO plw_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Maya iba pegberes na ya ne. Temed kwaʼt iba, “Lein, kebiriꞌ tyu lang samat ya.” Segwaꞌ kwan ye, “Aku ne pesi itue!” ");
INSERT INTO plw_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Nemengingkut mengeꞌ taaw kenye, kwan dye, “Enukwan neketuun ne mata mu in?” ");
INSERT INTO plw_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Sinambag ye, “Ating lelaki ne pegngeranen si Jesus nemaal et rusuꞌ ampaꞌ ye pinadlis et mata ku. Dinaak ye aku dumun dut libtung et Siloe tiꞌ apang mengiramus. Angkansa, nepanew ku, pegdateng duun ampaꞌ ku ne nengiramus, na neketuun ku ne.” ");
INSERT INTO plw_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","“Embe ne ating lelaki?” kwan dye. “Iste ku,” tinubag ye. ");
INSERT INTO plw_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Pegketbes, ating taaw na beleg na negnunga, binibit dye dut mengeꞌ tawʼt Pariseo. ");
INSERT INTO plw_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Na negkeradya si Jesus et rusuꞌ bekeꞌ negpemukrat et mata et lelaki neng beleg dut eldew et Sabadu, atin eldew et diki pengengeredyanan eset arat et mengeꞌ tawʼt Judio. (Angkansa, dut pikiran et Pariseo binelabag i Jesus arat dye.) ");
INSERT INTO plw_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Angkansa binisara gasi atin taaw neng beleg na neketuun et mengeꞌ Pariseo baꞌ enukwan ya neketuun. Kwan et lelaki, “Pinedlisan i Jesus lang et rusuꞌ mata ku, pegketbes nengiramus ku, naꞌ tiban mekebiriꞌ ku ne.” ");
INSERT INTO plw_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Maya mengeꞌ ibang Pariseo negsugid, kwan dye, “Ating lelaki diki teyeg dut Empuꞌ, sabab kaya pegtumanen ye eldew et diki pengengeradyanan.” Segwaꞌ iba nengingkut kwan dye, “Enukwan kekeradya et keliluꞌlilung tendaꞌ baꞌ ya maya mekeselaan?” Angkansa nemegdapit-dapit ne. ");
INSERT INTO plw_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Sekaliꞌ tuꞌ, iningkut dye peuliꞌ ating lelaki na beleg tagnaꞌ, “Enu mesugid mu kenye? Pasal et mata mu nepetuun ye?” Kwan et lelaki, “Ya in Tarus et Empuꞌ!” ");
INSERT INTO plw_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Kaya nengandel mengeꞌ pegibuten et mengeꞌ tawʼt Judio na ya beleg tagnaꞌ na tiban neketuun ne, sed-seked pinetingkag dye kenyeng gunggurang. ");
INSERT INTO plw_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","“Yegang myu be itue?” ingkut dye. “Ituꞌ be na pegsugiren myu na pinegyegang na beleg? Enukwan na ya nekebiriꞌ tiban?” ");
INSERT INTO plw_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Siminambag mengeꞌ gunggurang ye, kwan dye, “Sewd kay ya yegang kay, asal atin pinegyegang naꞌ beleg. ");
INSERT INTO plw_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Segwaꞌ tiban, baꞌ enukwan ya neketuun etawa mata ye nemukrat, kaya sewd kay. Ingkutaꞌ myu ya, sabab meumur ne. Ya ne megtuturan dimyu.” ");
INSERT INTO plw_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Sinugid et mengeꞌ kegunggurangan ye itue sabab megtakut dye dut mengeꞌ pegibuten et tawʼt Judio. Na atin pelan pegbehumen et mengeꞌ pegibuten ne lagi, na sebarang megsugid na si Jesus in Kristo, ipeugad ya dut benwang sinagoga, ating pengempuan na benwa dye. ");
INSERT INTO plw_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Angkansa samat kwantin ne nesugid et mengeꞌ gunggurang ye, kwan dye, “Ingkutaꞌ myu ne ya sabab meumur ne.” ");
INSERT INTO plw_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ipengeruwa ne pinetingkag dye lelaki na neketuun. Kwan dye kenye, “Isugiraꞌ et kebebenaran! Empuꞌ mekekingeg. Sabab sewd kay itueng lelaki, si Jesus, mekeselanan.” ");
INSERT INTO plw_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Segwaꞌ kwan ye, “Iste ku ne baꞌ ya in mekeselanan, temed sembatu lang sewd ku, aku beleg temed tiban nekebiriꞌ ku ne.” ");
INSERT INTO plw_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Pegketbes iningkut dye ya, kwan dye, “Enu kineradya i Jesus rimu? Enukwan ye ipinetuun mata mu?” ");
INSERT INTO plw_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Segwaꞌ kwan ye, “Kesusugid ku lang, diki myu nekingeg. Manu ingin myu kinggen nega peuliꞌ? Ingin myu takuꞌ kemyu mendyaring sembatung pepengenaran ye?” ");
INSERT INTO plw_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Pegketbes ininlelew dye ya, kwan dye, “Ikew lang pepengenaran et taaw na itue e! Segwaꞌ kami pepengenaran ki Moises. ");
INSERT INTO plw_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nesewran kay na Empuꞌ negberes ki Moises, segwaꞌ itueng lelaki, kaya nesewran kay baꞌ embe teyeg ye.” ");
INSERT INTO plw_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Siminambag lelaki, kwan ye, “Na keliluꞌliluꞌ itue e! Diki myu nesewran baꞌ embe teyeg ye, segwaꞌ ya nekepetuun et mata ku. ");
INSERT INTO plw_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nesewran tyu na kaya pegkinggen et Empuꞌ sebarang mekeselaan. Pegkinggen et Empuꞌ sebarang meinempuen na megtuman et keinginan ye. ");
INSERT INTO plw_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kaya misan sinu na nekekingeg kwit na kwan sembatung pinegyegang na beleg maya nepetuun et mata ye. ");
INSERT INTO plw_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Baꞌ itueng lelaki diki teyeg dut Empuꞌ, kaya mebutbuwat ye.” ");
INSERT INTO plw_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Sabab et itue, kwan dye, “Ikew, ipinegyegang ke dut kaya ne ereteret neng keselaan, manu menginduꞌ ke ramen?” Pegketbes sinempeg dye ne ya peliwan et pengempuan neng benwa. ");
INSERT INTO plw_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Pegkaꞌ kwantin ne, neebaran i Jesus na tinimbag et mengeꞌ pegibuten peliwan ating taaw neng beleg na neketuun. Indyari, pekebiyaꞌ ne kenye, kwan i Jesus, “Mengandel ke takuꞌ dut Yegang et Taaw?” ");
INSERT INTO plw_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","“Sinu ya, Menunulduꞌ? Sugiriꞌ ku supaya mengandel ku kenye!” ");
INSERT INTO plw_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Kwan i Jesus, “Nebiriꞌ mu ne ya. Na ya ne pesi megbebres dimu.” ");
INSERT INTO plw_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Indyari kwan et lelaki, “Begerar, pengandel ku!” Ampaꞌ ne siminelungkud apang pengempuen ya. ");
INSERT INTO plw_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Kwan i Jesus, “Natuꞌ ku atuʼt dunyaꞌ apang meukum mengeꞌ taaw. Seng bagiꞌ dye antangen mengeꞌ beleg, sabab awam dye et kebebenaran pasal et Empuꞌ! Dye in memengdyaring mekebiriꞌ. Sembatung bagiꞌ gasi, antangen dye samat kaya beleg, sabab kebluan dye kesewd dye ginsan pasal et Empuꞌ, temed salaꞌ. Dye in megmengdyaring beleg.” ");
INSERT INTO plw_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Maya mengeꞌ ibang Pariseo na mekabiꞌ dut kenye nekekingeg, kwan dye, “Enu? Kami tuꞌ beleg?” ");
INSERT INTO plw_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Kwan i Jesus, “Baꞌ beleg kew, ingin bersen kemyu banar awam et keberbenaran et Empuꞌ, kaya kedusaan myu. Segwaꞌ tiban sugiren myu na kemyu meketuun, ingin bersen gasi nesewran myu kebebenaran, angkansa megtetaren kedusaan et Empuꞌ eset dimyu, sabab kemyu kaya pengandel et keberbenaran.” ");
INSERT INTO plw_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Tinuturanan i Jesus itueng beleybey, kwan ye, “Sugiran ku kemyu et keberbenaran, baꞌ taaw diki lang mayaꞌ dut lelengewan et kukurungan et mengeꞌ bibili, segwaꞌ minik et ibang bebyaan supaya keseled, na ya menenakew, mengrerampas. ");
INSERT INTO plw_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Segwaꞌ baꞌ mayang taaw megbayaꞌ dut lelengewan et kukurungan et mengeꞌ bibili, atin key mengingipat et mengeꞌ bibili. ");
INSERT INTO plw_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Pegukaban kenye et menununggu lelengewan. Bekeꞌ, megkingeg mengeꞌ bibili ye et beres ye. Pegtingkagen ye kenyeng mengeꞌ bibili dut kedye-kedyeng ngaran sampay ya penguna kedye peliwan et kukurungan. ");
INSERT INTO plw_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Pegkaꞌ nepeliwan ye ne ginsan mengeꞌ bibili ye, ya ne megpenguna kedye, na megsunud kenye sabab sewd dye kenyeng pengluluwaan. ");
INSERT INTO plw_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Segwaꞌ baꞌ ibang taaw mene diki dye megsunud. Sampay peperayuꞌ dye sabab kaya sewd dye pengluluwaan et ibang taaw.” ");
INSERT INTO plw_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ginamit i Jesus itueng beleybey et bebresen, segwaꞌ diki dye meretian baꞌ enu pegbersen ye kedye. ");
INSERT INTO plw_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Angkansa negberes peuliꞌ si Jesus, kwan ye, “Sugiran ku kemyu banar, Aku antangan ye samat lelengewan et mengeꞌ bibili. ");
INSERT INTO plw_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ginsan neng nemeguna daken, dye in nemenulduꞌ et kaya kebeꞌbenaran. Antangan dye samat mengeꞌ menenakew bekeꞌ mengrerampas. Segwaꞌ kaya megkingeg kedye mengeꞌ bibili, (ingin bersen mengeꞌ pengandel daken). ");
INSERT INTO plw_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Aku antangan ye samat lelengewan; baꞌ sinu sumled dut daken, ya mebawiꞌ. Mekedyari ya sumled etawa lumiwan, bekeꞌ kebiyaꞌ et menungang kebiyagan. ");
INSERT INTO plw_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Memegatuꞌ menenakew supaya menakew bekeꞌ mengimatey sampay mengrungkat. Segwaꞌ daken, natuꞌ ku supaya maya biyag dye seked dut epus kesenangan. ");
INSERT INTO plw_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Aku antangan ye samat menungang mengingipat et mengeꞌ bibili. Ipegbayaꞌ et menungang mengingipat kenyeng biyag supaya mebawiꞌ mengeꞌ bibili ye. ");
INSERT INTO plw_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Segwaꞌ baꞌ pegtengdanan lang neng mengingipat et bibili, pegtirengan ye lang mengeꞌ bibili, baꞌ mebiriꞌ ye megderateng ne mengeꞌ ireng et talun. Pegtirengan ye lang seked pinegpekparak mengeꞌ bibili et mengeꞌ ireng et talun. Seukat lein lang ya mengingipat banar, bekeꞌ lein kenye ating mengeꞌ bibili. ");
INSERT INTO plw_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Megpelegyu ya puun sabab pegtengdanan lang bekeꞌ kaya permerganen ye mengeꞌ bibili. ");
INSERT INTO plw_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Aku antangan ye samat menungang mengingipat. Nesewran ku daken neng bibili, bekeꞌ mengeꞌ bibili kilala dye aku. ");
INSERT INTO plw_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Samat Amaꞌ kilala ye aku, bekeꞌ daken kilala ku gasi Amaꞌ. Sampay pepegbayaꞌ ku daken neng biyag dut mengeꞌ bibili ku, ingin bersen mengeꞌ pengandel daken. ");
INSERT INTO plw_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Maya mengeꞌ bibili ku na kaya atuʼt seled kukurungan et bibili. Keilangan biten ku gasi dye atue. Sampay dye kumingeg et daken neng beres, apang megsengbanan, bekeꞌ sembatu mengingipat dye. ");
INSERT INTO plw_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Angkan manu Amaꞌ ku meingin daken sabab pinegbayaꞌ ku biyag ku, pegketbes megbiyag ku peuliꞌ. ");
INSERT INTO plw_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Kaya sinu kepatey daken baꞌ diki itugut ku, segwaꞌ tud ne ipegbayaꞌ ku biyag ku. Sabab maya basag ku matey etawa megbiyag peuliꞌ. Itueng kepengdyarian neisiꞌ ku dut daken neng Empuꞌ Amaꞌ.” ");
INSERT INTO plw_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Sabab et itueng pinegberes, nemegbagiꞌbagiꞌ gasi mengeꞌ tawʼt Judio. ");
INSERT INTO plw_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Maya iba negsugid, “Pegselban ya et mereraat bekeꞌ negbegbalig ne. Manu pegkinggen myu nega ya?” ");
INSERT INTO plw_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Segwaꞌ sinugid et iba, kwan dye, “Diki kwantin bebresen et sembatung sinleban et mereraat. Diki mekedyari mepetuun et mereraat sembatung beleg!” ");
INSERT INTO plw_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Na ating masa, timpu et pememeratan. Diminateng ne Kenkaan et Kerendeman et Pegpepanyap Tagnaꞌ et Puun neng Pengempuan neng Benwa naꞌ Templo dut lungsud et Jerusalem. ");
INSERT INTO plw_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Si Jesus megpepanew dut Benwang Pengempuan dut pentaran i Surutan Solomon tagnaꞌ tiꞌ naꞌ pegsesepewan. ");
INSERT INTO plw_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Nemengagap mengeꞌ tawʼt Judio pelilibut kenye, kwan dye, “Seked ingyan na kami megalang-alang dimu baꞌ sinu ke banar. Tentuaꞌ ne damen megsugid baꞌ ikew banar ating Kristo, ating piniliꞌ et Empuꞌ memegbeg damen.” ");
INSERT INTO plw_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Negsugid si Jesus, kwan ye, “Pegsugiren ku ne dimyu, segwaꞌ kaya pengandel kew. Pegkebiriꞌ myu et mengeꞌ keliluꞌlilung pinemuwat ku dut kepengdyarian et Amaꞌ ku, mesewran myu ne baꞌ sinu banar aku. ");
INSERT INTO plw_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Segwaꞌ diki kew pengandel, sabab diki kemyu mengeꞌ bibili ku, ingin bersen mengeꞌ mengengandel ku. ");
INSERT INTO plw_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mengeꞌ mengengandel ku antangan dye samat bibili ku, megkingeg daken neng beres. Kilala ku dye bekeꞌ megsunud dye raken. ");
INSERT INTO plw_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Pinemgeyan ku dye et biyag neng kaya seskeran dut langit, bekeꞌ diki dye mebinasa dut Narkaꞌ. Kaya lang sinu mekeagew teyeg dut daken. ");
INSERT INTO plw_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Amaꞌ ku, negey kedye dut daken. Lebing metaas Empuꞌ Amaꞌ eset ginsan. Kaya lang sinu keagew teyeg dut Amaꞌ ku. ");
INSERT INTO plw_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Aku bekeꞌ Amaꞌ sembatu.” ");
INSERT INTO plw_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ganang nekingeg dye itue, maya mengeꞌ tawʼt Judio nememurut gasi et batu supaya si Jesus bekalen seked matey. ");
INSERT INTO plw_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Siminambag si Jesus, kwan ye. “Mekansang ne pinebiriꞌ ku dimyu mengeꞌ keliluꞌliluꞌ neng keradya na tinahagen daken et Empuꞌ Amaꞌ. Na, embe dut ginsan neng keradya ku na maya sabab ye na ingin myu aku bekalen seked matey?” ");
INSERT INTO plw_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Kwan et mengeꞌ tawʼt Judio, “Diki kay ikew bekalen sabab et mengeꞌ menungang keradya mu, segwaꞌ bekalen kay ikew sabab megpeempuꞌempuꞌ ke, sabab ikew taaw lang, temed pegpesiring-siring ke et Empuꞌ banar.” ");
INSERT INTO plw_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Kwan i Jesus kedye, “Diki be nekesurat dut Kesuratan myu, ‘Sinugid ku mengeꞌ empuꞌ kew?’ ");
INSERT INTO plw_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Baꞌ pegngeranen ya dut kedye ‘mengeꞌ empuꞌ’ sebarang nenerima et beres et Empuꞌ, bekeꞌ diki mekedyaring berubaen Kesuratan, ");
INSERT INTO plw_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","enukwan gasi pegsugiran myu itue pasal aku neng pinahin et Amaꞌ, bekeꞌ dinaak ye aku dut dunyaꞌ. Pegtendesen myu aku et pegpeempuꞌempuꞌ lang, sabab be et sinugid ku, ‘Naꞌ aku Yegang et Empuꞌ?’ ");
INSERT INTO plw_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Kasiꞌ myu aku pegendelaꞌ baꞌ diki ku buwaten et bubuwaten et Amaꞌ ku. ");
INSERT INTO plw_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Segwaꞌ baꞌ pegbuwaten ku, misan diki kew mengandel daken, endelaꞌ myu mengeꞌ bubuwaten ku na keliluꞌliluꞌ, apang mesewran myu bekeꞌ meretian myu na Amaꞌ atuʼt daken, bekeꞌ aku dut Amaꞌ, sesembatu kay.” ");
INSERT INTO plw_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ingin dye gasi teyen elewen si Jesus, segwaꞌ nekelapas dut kenye. ");
INSERT INTO plw_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Pegketbes, nepeuliꞌ si Jesus dut sendipag et danum et Jordan, dut tampaꞌ pinegbewtismuan i Juan eset mengeꞌ taaw nekeuna tiꞌ. Na, timineteg si Jesus duntin. ");
INSERT INTO plw_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Mekansang taaw siminarung ki Jesus duntin. Nemegsudsugid dye duntin, kwan dye, “Kaya nekekeradya si Juan et keliluꞌlilung tendaꞌ, segwaꞌ kebeꞌbenaran ginsan neng sinugid i Juan pasal ki Jesus.” ");
INSERT INTO plw_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Mekansang gasi nemengandel ki Jesus duntin. ");
INSERT INTO plw_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Maya sembatung lelaki na mesakit, ingaran ye si Lasaro. Ya tawʼt Betania. Duun peglegdengan ye, dut benwa et tipused yeng si Maria bekeꞌ si Marta. ");
INSERT INTO plw_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Na, si Maria, atin ne nengluung et bebengluen dut Begerar bekeꞌ rinipnasan ye et buek tiked i Jesus tagnaꞌ tiꞌ. Atin tipused i Maria, si Lasaro, mesakit ne. ");
INSERT INTO plw_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Angkansa negpebibit et bebresen dut ki Jesus mengeꞌ ketipusdan i Lasaro, kwan dye. “Begerar, si Lasaro neng bilaꞌ mu banar mesakit!” ");
INSERT INTO plw_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ganang nekingeg i Jesus itue, kwan ye, “Itueng sakit na itue diki lang ikepatey. Atin, apang kebentugan et Empuꞌ, supaya Yegang et Empuꞌ mebantug sabab et itue.” ");
INSERT INTO plw_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Kelang pegbiꞌbilaꞌ i Jesus kire Marta, ki Maria, bekeꞌ ki Lasaro. ");
INSERT INTO plw_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ganang neebaran ye na si Lasaro mesakit, duwang eldew nega taren i Jesus dut lelegdengan ye. ");
INSERT INTO plw_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Pegketbes sinugid ye dut kenyeng pepengenaran, “Peuliꞌ tyu mena dut probinsiya et Judea.” ");
INSERT INTO plw_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","“Segwaꞌ Menunulduꞌ,” kwan dye, “ingga nekwit ingin et mengeꞌ pegibuten et mengeꞌ taaw Judio ikew bekalen seked matey, segwaꞌ tiban takuꞌ peuliꞌ ke gasi duntin?” ");
INSERT INTO plw_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Kwan i Jesus kedye, “Endey kew kesusa, diki be sempuluꞌ duwang kelisagan seked gebi? Na baꞌ megpepanew tyu sementaraꞌ eldew nega, diki tyu mesugbak, sabab mekebiriꞌ tyu telang et eldew atuʼt sengkekinleban. ");
INSERT INTO plw_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Segwaꞌ baꞌ manew tyu et gebi, mekesimbakud sabab kaya lang siluꞌ kityu.” ");
INSERT INTO plw_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Pegketbes i Jesus neres, sinugid ye kedye, “Bibilaꞌ tyung si Lasaro megigaꞌ. Angkansa, sumurung ku dun supaya tiyagen ku ya.” ");
INSERT INTO plw_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Siminambag mengeꞌ pepengenaran ye, kwan dye, “Begerar, baꞌ ya megigaꞌ, megnunga nega.” ");
INSERT INTO plw_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Pegsugiren i Jesus, sabab et patey ne si Lasaro. Segwaꞌ mengeꞌ pepengenaran ye penganal dye samat nekeigaꞌ lang in. ");
INSERT INTO plw_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Tinantu i Jesus ne banar susugiren ye kedye, kwan ye, “Si Lasaro patey ne banar. ");
INSERT INTO plw_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Na, sabab dut dimyu, meksan ku na kaya duntin ku, supaya mengandel kew banar. Na, sumurung tyu ne.” ");
INSERT INTO plw_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Si Tomas, pegngeranen dye na si Kambar, negsugid dut mengeꞌ ibang pepengenaran, kwan ye, “Na, sigi mayaꞌ tyu apang megunung-unung tyu matey.” ");
INSERT INTO plw_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Pegdateng i Jesus dut lungsud et Betania, nesewran ye na epat neng eldew ne peglebeng ki Lasaro. ");
INSERT INTO plw_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Rayuꞌ et Betania dut lungsud et Jerusalem, mekabiꞌ et telung kilometro. ");
INSERT INTO plw_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Mekansang mengeꞌ tawʼt Judio memengduntin ki Marta bekeꞌ ki Maria supaya memulilang kedye sabab tipused dye natey. ");
INSERT INTO plw_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ganang nekingeg i Marta si Jesus megderateng, sinusup ye si Jesus, segwaꞌ si Maria nepetektak dut seled benwa. ");
INSERT INTO plw_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","“Begerar,” kwan i Marta ki Jesus, “Baꞌ atuꞌ ke teyen, diki natey tipused ku. ");
INSERT INTO plw_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Segwaꞌ nesewran ku misan tiban igbey rimu et Empuꞌ baꞌ enu engaten mu kenye.” ");
INSERT INTO plw_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Kwan i Jesus kenye, “Tipused mu megbiyag peuliꞌ.” ");
INSERT INTO plw_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Siminambag si Marta, kwan ye, “Sewd ku megbiyag ya peuliꞌ dut pegbiyag peuliꞌ dut emuring eldew.” ");
INSERT INTO plw_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Kwan i Jesus kenye, “Aku kebiyag peuliꞌ et mengeꞌ patey bekeꞌ aku puun et biyag. Sebarang pengandel daken, dye megbiyag, misan dye matey. ");
INSERT INTO plw_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Sampay, sebarang biyagan neng nengandel daken, diki lang matey et misan ingyan. Pegendelen mu itue?” ");
INSERT INTO plw_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","“Eꞌ, Begerar!” kwan i Marta, “Nengandel ku ne ikew Kristo, ating Yegang et Empuꞌ, na ya ne natuꞌ dut ginsan taaw et sengkedunyaan.” ");
INSERT INTO plw_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Pegketbes, na si Marta neres, nuliꞌ ne bekeꞌ tiningkag ye tipused ye si Maria na pekabiꞌ ampaꞌ kininesan ye, kwan ye, “Menunulduꞌ atue ne, pegtingkagen ye ikew.” ");
INSERT INTO plw_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ganang nekingeg i Maria itue, megtuy timinyeg, siminurung dut ki Jesus. ");
INSERT INTO plw_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Segwaꞌ ingga peꞌ nekeseled si Jesus dut kebebenwanan, untin nega ya et pinegsusupan dye i Marta. ");
INSERT INTO plw_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ganang nebiriꞌ et mengeꞌ tawʼt Judio neng iba-iba i Maria dut benwa megpemulilang kenye, nepangling dye deraliꞌ ginsan si Maria timinyeg bekeꞌ liminiwan, pineselundungan dye ya. Nebluan dyeʼt dumuntin si Maria dut lebeng supaya ipesngew ye untin siyak ye. ");
INSERT INTO plw_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ganang nerateng i Maria dut pegpepeternan i Jesus, nepekleb ye eset titikeran i Jesus, kwan ye, “Begerar, baꞌ atuꞌ ke peꞌ teyen, kaya natey tipused ku.” ");
INSERT INTO plw_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Pegkebiriꞌ i Jesus megsisiyak si Maria, sampay mengeꞌ tawʼt Judio na nepeselundung kenye in memegsisiyak gasi. Riminupuk ne gasi si Jesus. ");
INSERT INTO plw_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Iningkut i Jesus kedye, “Embe limbengan myu?” Siminambag dye, “Bayaꞌ damen apang mebiriꞌ mu.” ");
INSERT INTO plw_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Indyari, siminiyak si Jesus. ");
INSERT INTO plw_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Kwan et mengeꞌ tawʼt Judio, “Birinaꞌ myu baꞌ enukwan pegingin ye dut ki Lasaro!” ");
INSERT INTO plw_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Segwaꞌ maya senu nemegsudsugid, “Pinetuun i Jesus mata et beleg. Manu diki ye mebuwat na teyen diki matey si Lasaro?” ");
INSERT INTO plw_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Riminupuk banar gasi peuliꞌ pikiran i Jesus, pegdateng dut limbengan. Itue singkab pegtetengleben et kelang batu. ");
INSERT INTO plw_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Dinaak dye i Jesus, kwan ye, “Ugaraꞌ myu ating batu.” Segwaꞌ kwan i Marta, tipused et natey in, “Begerar, meraliꞌ buruk ne, sabab epat neng eldew ne set seled singkab in.” ");
INSERT INTO plw_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Pegketbes kwan i Jesus, “Diki be sinugid ku ne rimu, baꞌ mengandel ke lang, mebiriꞌ mu kebesagan et Empuꞌ banar?” ");
INSERT INTO plw_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Angkansa, inugad dye ne batu. Pegketbes, timiningaraꞌ si Jesus ampaꞌ negpenalang, kwan ye, “Amaꞌ, megpeselamat ku dimu na kiningeg mu aku. ");
INSERT INTO plw_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nesewran ku, daran mu pegkikinggen aku, segwaꞌ pegsugiren ku itue sabab et kineldaman neng pelilibut atue e megkikingeg, supaya dye mengandel na dinaak mu aku.” ");
INSERT INTO plw_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ganang nesugid i Jesus itue e, timiningkag ya et mebasag, “Lasaro, liwan ne!” ");
INSERT INTO plw_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Liminiwan megtuy ating patey neng taaw na negbiyag peuliꞌ, ginsaʼt bilug ye bekeꞌ lengen sampay tiked ye pegbebedberen et gedyilew, bekeꞌ pegbubulungan et seputangan rupa ye. Kwan i Jesus kedye, “Bukluaꞌ myu gedyilew in, ipepenewaꞌ myu ne.” ");
INSERT INTO plw_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Angkansa mekansang mengeꞌ tawʼt Judio na nemengdateng na kebayaꞌ i Maria, nemengandel ki Jesus, sabab nebiriꞌ dye baꞌ enu kineradya ye. ");
INSERT INTO plw_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Segwaꞌ maya iba diminuntin dut mengeꞌ Pariseo bekeꞌ negtuturan dye pasal et kineradya i Jesus. ");
INSERT INTO plw_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Mendyari mengeꞌ pegibuten et mengeꞌ pariꞌ, bekeꞌ mengeꞌ Pariseo negsetingkag dut mengeꞌ Kekunsialan. “Enu pegisun-isunan tyu?” kwan dye, “Pasal et itueng taaw na pegkeradya et mengeꞌ keliluꞌlilung tendaꞌ. ");
INSERT INTO plw_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Baꞌ pesaran tyu lang et kwantin, ginsaʼt taaw mengandel kenye, bekeꞌ kaluꞌ matuꞌ mengeꞌ kesundeluan et bangsaʼt Romano, na mengrungkat et Pengempuan na Benwa sampay mengagew et bangsa tyu.” ");
INSERT INTO plw_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Segwaꞌ maya sembatung taaw, ngaran ye si Kaipas, na Metaas neng Pariꞌ et teun na atin negsugid kedye, “Kaya banar mekesewran myu. ");
INSERT INTO plw_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Kaya keretian myu naꞌ, gam ne sembatung taaw lang matey sabab eset ginsan neng taaw, sampay sengkebangsanan diki mebinasa.” ");
INSERT INTO plw_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Sinugid ye itue diki lang kwan teyeg kenye, imbes teyeg dut pegkemetaas ye et ating teun. Tineked ye na matey nega si Jesus sabab dut bangsa et Israel. ");
INSERT INTO plw_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Bekeꞌ diki lang atin lang neng bangsa, temed gasi apang pegtingtimungan dut sembatu et mengeꞌ nemegpekparak na keyegangan et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Angkansa tihad et ating eldew, pinaru dye na ipepatey si Jesus. ");
INSERT INTO plw_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Angkansa, baꞌ manew si Jesus, kaya ne pepelamud dut mengeꞌ tawʼt Judio. Segwaꞌ nepesurung dut lungsud na mekabiꞌ dut kelnangan, dut kebenbenwanan pegngeranen Epraim. Dun ya liminegdeng, iba mengeꞌ pepengenaran ye. ");
INSERT INTO plw_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ganang megeapet ne kerendeman et Kenkaan neng Neketalib et mengeꞌ tawʼt Judio. Mekansang nemenungul dut lungsud et Jerusalem supaya tumanen dye arat pinegarat neng pegbasaꞌ et bilug mura dye sumurung eset Kenkaan et Neketalib. ");
INSERT INTO plw_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Na pegtutulusen dye si Jesus. Ganang dun dye net seled Puun neng Pengempuan neng Benwa naꞌ Templo, nemegingkut-ingkut dye ne, kwan dye, “Enu dut pikir myu? Diki ne lengku si Jesus sumarung atuʼt pegkenkaanan?” ");
INSERT INTO plw_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Negpesewd mengeꞌ pegibuten et mengeꞌ pariꞌ sampay mengeꞌ Pariseo, na kwan, “Baꞌ sinu kebiriꞌ ki Jesus, megsugid baꞌ embe, supaya malew.” ");
INSERT INTO plw_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Enem neng eldew mura dumateng Pegkenkaan et Kerendeman et Neketalib tagnaꞌ, si Jesus diminateng dut lungsud et Betania, lungsud na pegeldengan i Lasaro, na binyag i Jesus peuliꞌ. ");
INSERT INTO plw_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Pinenyapan dye si Jesus et pegkaan et mapun. Si Marta negpelamak, si Lasaro neperingan ne kenye nengaan dut lemisaan. ");
INSERT INTO plw_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Si Maria, kenye nengisiꞌ et tengaꞌ litro et mergaꞌ neng bebengluen neng nardu, indyari binuak ye dut tiked i Jesus. Pegketbes, rinipnasan ye et buek ye. Sinet ne et benglu seled benwa. ");
INSERT INTO plw_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Segwaꞌ si Judas Iskariote, na pepengenaran neng mengengakal ki Jesus, negsugid, kwan ye, ");
INSERT INTO plw_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Manu diki pinelen pebengluen in supaya pirak in ipinemgey ne dut mengeꞌ miskin. Sabab, argaꞌ ye megtuuk ne et seng teun neng tengdan et pegkeradya.” ");
INSERT INTO plw_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Sinugid ye itue, diki sabab ye na maya ingasiꞌ ye et mengeꞌ miskin, temed sabab ye ya menenakew. Sabab ya pegpupunduan et pirak dye, iba in pegtaguꞌ ye ne. ");
INSERT INTO plw_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Siminambag si Jesus, kwan ye, “Pesariꞌ myu ne ya na buwaten ye itue, sabab itueng pebengluen pinanyap ye ne lagi mapet dut kelbengan ku. ");
INSERT INTO plw_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Sabab mengeꞌ miskin neng taaw daran atuʼt dimyu, bekeꞌ kemyu ketabang nega kedye. Segwaꞌ aku diki dumaran atue na keiba dimyu.” ");
INSERT INTO plw_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ganang nesewran et kineldamaʼt tawʼt Judio na si Jesus dut Betania, diminuntin dye. Diminuntin dye diki lang sabab si Jesus lang, temed supaya mebiriꞌ dye si Lasaro na binyag i Jesus peuliꞌ. ");
INSERT INTO plw_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Angkansa mengeꞌ pegibuteʼt pariꞌ nemaru na imeteyen dye gasi si Lasaro. ");
INSERT INTO plw_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Sabab et ki Lasaro mekansang mengeꞌ tawʼt Judio na nepeparak dut mengeꞌ pariꞌ et Judio bekeꞌ nemengandel ki Jesus. ");
INSERT INTO plw_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Pegdateng diklem, neebaran et kineldamaʼt taaw neng nemengluruk dut pegkenkaanan na si Jesus pesusurung dut lungsud et Jerusalem. ");
INSERT INTO plw_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Angkansa nemengrapiꞌ dye et deun et mengeꞌ betuꞌ, ampaꞌ ne nemengliwan dye supaya sumusup kenye, kwan dye, “Hosanna! Bentugen ya na megderateng sabab kepengdyarian et Empuꞌ Banar. Bentugen Surutan et Israel.” ");
INSERT INTO plw_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Nebiriꞌ i Jesus sembatung budyang neng asno, ampaꞌ ye kinuraan, samat dut sinurat eset Kesuratan et Empuꞌ, kwan, ");
INSERT INTO plw_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Kas kew takut, mengeꞌ tawʼt lungsud et Jerusalem! Birinaꞌ Surutan myu megderateng, megkukuraꞌ dut budyang neng asno!” ");
INSERT INTO plw_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Mena in, ingga peꞌ itue neretian et mengeꞌ pepengenaran ye. Ganang si Jesus nepetaas ne dut dibuwat langit, atin peꞌ neretian dye ne na itue pelan nesurat ne lagi pasal kenye, na asal pesi kwantin neinabu kenye. ");
INSERT INTO plw_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Mekansang siminusup dut ki Jesus sebarang taaw na nekekingeg et tuturan pasal et mengeꞌ keliluꞌlilung tendaꞌ ye. ");
INSERT INTO plw_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Sabab kineldaman et iba-iba i Jesus ating masa negpesebanar dut kenyeng binwat na pegtingkag ye dut lebeng ki Lasaro, sampay binyag ye peuliꞌ teyeg dut kepeteyan. ");
INSERT INTO plw_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Angkansa mengeꞌ Pariseo nemegsudsugid kwan dye, “Kaya ne mebutbuwat tyu. Birinaꞌ myu, ginsaʼt mengeꞌ tawʼt sengkedunyaan bin megsunud ne dut ki Jesus.” ");
INSERT INTO plw_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Maya gasi mengeꞌ tawʼt Griego na nemenungul dut lungsud et Jerusalem dut pegkenkaanan supaya mengempuꞌ. ");
INSERT INTO plw_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Nepekabiꞌ dye dut ki Pelipe neng pepengenaran i Jesus na tege-Betsaida dut probinsiya et Galilea. Na sinugid kenye keilangan dye, kwan dye, “Ilaꞌ, mekedyari kay be mebiriꞌ si Jesus?” ");
INSERT INTO plw_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Sinugid gasi i Pelipe ki Andres, pegketbes dyeng duwa gasi negpesewd ki Jesus. ");
INSERT INTO plw_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Kwan i Jesus, “Diminateng ne timpu ku. Na pebentugen ne aku atin Yegang et Taaw. ");
INSERT INTO plw_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Tantu banar be pegsugiren ku dimyu, baꞌ diki iluwak myu sembatung elinseg, daran atin sembatu lang. Temed baꞌ iluwak myu dut lugtaꞌ, antangen ye samat natey neng ilbeng, na tumuhuꞌ bekeꞌ kumansang buaꞌ ye. ");
INSERT INTO plw_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Megdemikian gasi dut taaw. Sebarang pegmerganen biyag ye atuʼt dunyaꞌ, matey nega, bekeꞌ diki megbiyag et kaya seskeran dut langit. Segwaꞌ sebarang taaw kaya pegmerganen ye biyag ye atuʼt dunyaꞌ, ya in maya meterima ye dut biyag na kaya seskeran. ");
INSERT INTO plw_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Sebarang pegkeradya daken subaliꞌ mibut daken, baꞌ embe ku, duntin gasi mengengeradya ku. Kekesian banar et Amaꞌ sebarang mengengeradya ku.” ");
INSERT INTO plw_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Na pinebtiꞌ i Jesus, kwan ye, “Na tiban pegsusa atey ku. Enu bersen ku, ‘Amaꞌ, bewinaꞌ ku sabab megderateng ne ketiksaan ku?’ Temed diki! Itue ne pesi, sabab ye angkan natuꞌ ku itueng ketiksaan na resanen ku ne itue. ");
INSERT INTO plw_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Amaꞌ, ipebirinaꞌ bantug mu!” Pegketbes maya nekingeg dye beres et Empuꞌ Amaꞌ teyeg dut langit, kwan, “Pinebiriꞌ ku ne, sampay ipebiriꞌ ku nega peuliꞌ.” ");
INSERT INTO plw_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Nekingeg et kineldaman et taaw kwan dye, “E! Diminuldug ne!” Kwan et iba, “Negberes kenye sembatung dereakan et Empuꞌ!” ");
INSERT INTO plw_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Kwan i Jesus, “Pinekingeg itueng beres na itue sabab et dimyu, diki sabab et daken. ");
INSERT INTO plw_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","“Na, tiban ne timpu et pegukum et Empuꞌ et ginsang taaw atueʼt sengkedunyaan. Na ugaren ku ne tiban pekekes et pegibuten et mengeꞌ meraat neng taaw. Na ya si Seytan neng megmimilik et sengkedunyaan tuꞌ. ");
INSERT INTO plw_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Segwaꞌ, aku, ganang meperibuwat dut erigi ne teyeg dut dunyaꞌ, ipekabiꞌ ku ginsan neng mengeꞌ taaw dut daken.” ");
INSERT INTO plw_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Sinugid i Jesus itue supaya ipesewd baꞌ enukwan ya matey, na ransangen dye ya dut krus et kayu. ");
INSERT INTO plw_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Negberes kineldaman et taaw duntin, “Nekingeg kay dut Kesuratan et Empuꞌ na ating Kristo tumeteg daran-peraran. Manu pegsugiren mu na subaliꞌ iperibuwat dut erigi bekeꞌ peteyen Yegang et Taaw? Sinu takuꞌ itueng Yegang et Taaw?” ");
INSERT INTO plw_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Sinugid i Jesus kedye, kwan ye, “Diki ne mekwit na meiba-iba myu siluꞌ na megpetelang et pikiran myu. Manew kew sasat iba-iba myu nega siluꞌ supaya diki kew melingban. Diki lang mesewran et megpanew et melingeb baꞌ embe surungan ye. ");
INSERT INTO plw_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Angkansa, sasat maya nega siluꞌ, mengandel kew dut siluꞌ supaya megmendyaring pepengenaran kew dut siluꞌ.” Pegkesugid et itue, si Jesus nugad, tebes in nepetaguꞌ. ");
INSERT INTO plw_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Misan ne nemekebiriꞌ et mengeꞌ keliluꞌlilung tendaꞌ na kineradya i Jesus dut elepan et mengeꞌ taaw, temed kaya nega nengandel dye. ");
INSERT INTO plw_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Apang metuman samat sinugid i Isaias naꞌ tarus et Empuꞌ tagnaꞌ, na kwan, “Empuꞌ dut langit, sinu nengandel et beres kay, bekeꞌ sinu pinebirinan et Empuꞌ Banar na kenyeng kebesagen?” ");
INSERT INTO plw_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Angkansa, kaya dye nemengandel sabab samat pegsugiren nega i Isaias, kwan, ");
INSERT INTO plw_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Binleg ye kedyeng mengeꞌ mata sampay pineknel atey dye supaya diki kebiriꞌ mata dye, etawa keretiꞌ pikiran dye. Angkansa,” kwan et Empuꞌ Banar, “apang diki ne kepeuliꞌ daken supaya gasi teyen maapen ku keselaan dye.” ");
INSERT INTO plw_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Si Isaias negsugid et itue sabab nebiriꞌ ye baꞌ enukwan kebentugan et Mesias, bekeꞌ nebres ye pasal ki Jesus. ");
INSERT INTO plw_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Segwaꞌ misan mengeꞌ pegibuten, mekansang nemengandel ki Jesus. Temed kaya negpekilala dye sabab megtakut dye dut mengeꞌ Pariseo na dye ugaren dut sinagoga. ");
INSERT INTO plw_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Sabab kelaʼt atey dye na bentugen dye et taaw luwas nega eset pegbantug kedye teyeg dut Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Pegketbes neres si Jesus et merensag, kwan ye, “Sebarang taaw nengandel daken diki nengandel dut daken lang, temed sampay dut Empuꞌ Banar negtahag daken. ");
INSERT INTO plw_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Sebarang nekebiriꞌ daken, nekebiriꞌ gasi dut negtahag daken. ");
INSERT INTO plw_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Natuꞌ ku atuʼt sengkedunyaan. Na akung antangan samat siluꞌ na megtetelang dut pikiran et mengeꞌ taaw, supaya sebarang mengandel daken diki lang dumaran dut kelingban. ");
INSERT INTO plw_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Baꞌ mayang taaw megkingeg et beres ku, segwaꞌ kaya pegtumanen ye, diki lang ukumen ku ya. Sabab natuꞌ ku atue e diki mengukum et ginsaʼt taaw et sengkedunyaan, segwaꞌ natuꞌ ku supaya memawiꞌ lang. ");
INSERT INTO plw_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Dut emuring eldew maya sembatu mengukum dut sebarang megmendiꞌ daken bekeꞌ kaya megterima et beres ku. Na atin mengukum kenye dut beberesen ku. ");
INSERT INTO plw_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Sabab kaya lang pegbersen ku na teyeg dut daken lang, segwaꞌ teyeg dut Empuꞌ Amaꞌ na negtahag daken. Na dinaak ye aku baꞌ enu keilangan na isugid ku, etawa baꞌ enukwan penugid ku. ");
INSERT INTO plw_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Na pegsesewren ku mengeꞌ daak ye menurun dut biyag na kaya seskeran. Angkansa sebarang pegbersen ku baꞌ enu pegsugiren daken et Empuꞌ Amaꞌ, atin lang gasi ipenugid ku.” ");
INSERT INTO plw_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Mekabiꞌ ne banar Kenkaan et Kerendeman et Neketalib. Pegsesewren ne i Jesus na mekabiꞌ ne timpu ye matey bekeꞌ tumireng ne et dunyaꞌ indyari peuliꞌ ne dut Empuꞌ Amaꞌ. Kelaꞌ pegmerganen i Jesus dut kenyeng mengeꞌ pepengenaran atuʼt dunya, angkansa ipinebiriꞌ ye kepuspusaʼt kasi ye kedye. ");
INSERT INTO plw_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Nemengaan et mapun de Jesus iba ye mengeꞌ pepengenaran ye. Siminaleb ne si Seytan dut pikiran i Judas Iskariote, na yegang i Simon, supaya mengakal ki Jesus. ");
INSERT INTO plw_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Sewd i Jesus na binggey ne kenye et Empuꞌ Amaꞌ ginsan kepengdyarian. Pegsesewren ye na ya teyeg dut Empuꞌ bekeꞌ ya peuliꞌ gasi dut Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Pegketbes nengaan et mapun, timinyeg ne ya, binukluꞌ ye kenyeng lapis ampaꞌ ne negbegkes et gimpew dut bebagan ye. ");
INSERT INTO plw_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Pegketbes in, sinunuan ye et danum pelenggana, ampaꞌ ye ne pinemesaan tiked et mengeꞌ pepengenaran ye. Bekeꞌ pineyran ye et gimpew neng pegkekerbeten ye. ");
INSERT INTO plw_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Nepekabiꞌ si Jesus dut ki Simon, na negsugid ki Jesus, “Begerar, manu ikew memasaꞌ et tiked ku?” ");
INSERT INTO plw_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Siminambag si Jesus, kwan ye, “Diki mu neretian baꞌ enu pegbuwaten ku tuꞌ, segwaꞌ dut leyd ne mesewran mu ne.” ");
INSERT INTO plw_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","“Diki lang!” kwan i Pedro, “Kasiꞌ pegbeseiꞌ tiked ku!” Segwaꞌ kwan i Jesus, “Baꞌ diki pebasaꞌ ke daken, lein lang mengengandel ku ikew.” ");
INSERT INTO plw_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Angkansa kwan i Pedro, “Begerar, diki tiked ku lang, temed sampay lengen bekeꞌ ulu ku gasi!” ");
INSERT INTO plw_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Kwan i Jesus, “Sebarang taaw na nepenyuꞌ ne, kaya ne daki bilug ye, keilangan mene besaan tiked ye lang. Segwaꞌ kemyu melinas ne atey myu, temed diki lang ginsan kew.” ");
INSERT INTO plw_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Sabab nesewran i Jesus baꞌ sinu mengakal kenye. Angkansa sinugid na kwan, “Diki lang ginsan kew melinas.” ");
INSERT INTO plw_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ganang netbes ye ne nemasaꞌ kedyeng mengeꞌ tiked, negbadyuꞌ ne, ampaꞌ ne nepeuliꞌ dut kenyeng inerungan dut kekanan. Sinugid ye kedye, kwan, “Nesewran myu takuꞌ baꞌ enu binwat ku dimyu? ");
INSERT INTO plw_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Pegtingkagen myu aku et Menunulduꞌ bekeꞌ Begerar, asal, sugat aku ne pesi. ");
INSERT INTO plw_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Na, baꞌ aku Begerar bekeꞌ Menunulduꞌ myu, na nemasaꞌ et mengeꞌ tiked myu, kwantin gasi buwaten myu. Subaliꞌ gasi megsibasaꞌ kew et tiked et sebayaꞌ myu. ");
INSERT INTO plw_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Binggeyan ku kemyu et sungtuhan supaya maya sunsunen myu samat binwat ku dimyu.” ");
INSERT INTO plw_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Kwan i Jesus, “Asal banar, kaya tetehagen lebing metaas dut kenyeng pegibuten, etawa dereakan lebi negang metaas dut megdaak kenye. ");
INSERT INTO plw_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Na tiban nesewran myu ne itueng ketulduan ku. Mesukud kew banar baꞌ buwaten myu itue.” ");
INSERT INTO plw_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Sinugid gasi i Jesus kwan ye, “Diki dut dimyu ginsan na pegsugiren ku itue. Sabab megkekilala ku sebarang piniliꞌ ku. Segwaꞌ supaya metuman atin dut Kesuratan et Empuꞌ, kwan, ‘Ya na sumaru et pegkaan ku, ya ne sagkaꞌ daken.’ ");
INSERT INTO plw_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Pegsugiren ku itue rimyu mura meinabu. Sabab baꞌ itue meinabu ne, mengandel kew ne banar na aku si aku ne pesi.” ");
INSERT INTO plw_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Kwan i Jesus, “Pegsugiren ku rimyu, sebarang megterima et mengeꞌ dinaak ku, sepantun atin aku ne tinerima ye. Sebarang penerima daken, terima dye gasi Empuꞌ na negdaak daken.” ");
INSERT INTO plw_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ganang nesugid ne i Jesus itue, negsusa pikiran ye, kwan ye, “Sugiran ku kemyu, maya sembatu dimyu ipegdagang bekeꞌ ipealew aku.” ");
INSERT INTO plw_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Negsisiyek-siyek ne mengeꞌ pepengenaran ye, diki nesewran baꞌ sinu pegsisindiren ye. ");
INSERT INTO plw_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Maya sembatu kedye na pepengenaran ye mekmiꞌ ki Jesus, pesesendig et debdeb i Jesus. ");
INSERT INTO plw_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Kinurit ya i Simon Pedro ampaꞌ ye ne kininesan, kwan ye, “Ingkutaꞌ be baꞌ sinu pegsisindiren ye in?” ");
INSERT INTO plw_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Nepesendig peuliꞌ dut debdeb i Jesus, kwan ye, “Begerar, sinu takuꞌ pegsindiren mu in?” ");
INSERT INTO plw_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Kwan i Jesus, “Baꞌ sinu begeyan ku et bengbang na dinitil ku, ya ne.” Ganang neritil ye ne bengbang ampaꞌ ye ne binggey ki Judas na yegang i Simon Iskariote. ");
INSERT INTO plw_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Pegkaꞌ nekawaꞌ ne i Judas tinapay ampaꞌ ye ne kinaan, si Seytan siminaleb ne kenye. Kwan i Jesus ki Judas, “Buwataꞌ ne sekaliꞌ baꞌ enu pegpipikiren mu!” ");
INSERT INTO plw_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Segwaꞌ kaya neretian et mengeꞌ pepengenaran ye dut lemisaan baꞌ manu kwantin sinugid ye ki Judas. ");
INSERT INTO plw_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Pengretiꞌ sesenu dye tinahag lang si Judas na mengelen et keilangan dye dut Kerendeman et Kenkaan, sabab ya megkekepet et pirak dye. Iba in pengretiꞌ dye na subaliꞌ ya meneraka lang dut mengeꞌ miskin. ");
INSERT INTO plw_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ganang nepurut ye ne tinapay, nugad ne megtuy. Atin negang gebi. ");
INSERT INTO plw_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ganang neketelikud ne si Judas, kwan i Jesus, “Na tiban aku, ating Yegang et Taaw, mebunayag ne ketaasan ku bekeꞌ mebunayag gasi ketaasan et Empuꞌ pebiyaꞌ aku. ");
INSERT INTO plw_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Baꞌ mebunayag ne ketaasan et Empuꞌ sabab aku, kwantin gasi mebunayag ne ketaasan et Empuꞌ megtuy daken, ating Yegang et Taaw. ");
INSERT INTO plw_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Mengeꞌ mergang pepengenaran ku, diki ne mekwit pegbebayaꞌ tyu. Tulusen myu aku temed diki myu aku mebiyanan. Samat sinugid ku dut mengeꞌ tawʼt Judio, megdemikian, sinugid ku tiban dut dimyu, baꞌ embe surungan ku, diki kew keruntin.” ");
INSERT INTO plw_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Sinugid gasi i Jesus, kwan ye, “Bagung tahag igbey ku rimyu, meginginan kew et tegsembatu-sembatu dimyu samat pegingin ku dimyu. Keilangan kwantin gasi dimyu na meginginan kew et tegsembatu-sembatu dimyu, ");
INSERT INTO plw_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","supaya mekilala et ginsaʼt taaw na kemyu mengeꞌ pepengenaran ku, baꞌ neginginan kew et tegsembatu.” ");
INSERT INTO plw_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Sembatu nengingkut ki Jesus, si Simon Pedro, kwan ye, “Begerar, embe surungan mu?” Kwan i Jesus kenye, “Baꞌ embe surungan ku, diki ke keibut tiban, segwaꞌ peuliꞌ tiꞌ keibut ke nega.” ");
INSERT INTO plw_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Segwaꞌ kwan i Pedro, “Begerar, manu diki kebayaꞌ ku dimu tiban? Ipeglilaꞌ ku biyag ku dimu!” ");
INSERT INTO plw_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Pegketbes negsugid si Jesus, kwan ye, “Ipeglilaꞌ mu takuꞌ biyag mu sabab lang et daken? Sugiran ku ikew et kebenaran, mura kumerengek lumbuꞌ, ketlu mu ne sugiren na kaya kilala mu aku.” ");
INSERT INTO plw_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Sinugid gasi i Jesus, kwan ye, “Kasiꞌ myu ipesusaꞌ atey myu sabab et bebresan ku. Mengarap kew dut Empuꞌ, sampay mengarap kew gasi daken. ");
INSERT INTO plw_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Dut benwa et Empuꞌ Amaꞌ ku, mekansang sisingled. Baꞌ diki megkwantin, isugid ku dimyu. Na, sumurung ku dun supaya penyapan ku kemyu et mengeꞌ lelegdengan. ");
INSERT INTO plw_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Baꞌ duntin ku ne, nepenyapan ku ne kemyu et lelegdengan, peuliꞌ ku gasi apang isien ku kemyu. Baꞌ embe legdengan ku, untin gasi legdengan myu. ");
INSERT INTO plw_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Na, mesewran myu dalan sumurung dut lelegdengan na surungan ku.” ");
INSERT INTO plw_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Kwan i Tomas, “Begerar, diki mesewran kay baꞌ embe pegsusurungan mu. Enukwan kesewd kay dalan?” ");
INSERT INTO plw_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Siminambag si Jesus, kwan ye, “Aku dalan surung dut Empuꞌ, bekeꞌ aku puun et keberbenaran, sampay puun et biyag. Kaya misan sinu mekesurung dut Empuꞌ Amaꞌ selyu lang baꞌ ya mengandel daken. ");
INSERT INTO plw_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Baꞌ kilala myu aku, mekilala myu gasi Amaꞌ ku. Tihad tiban, kilala myu ne sampay nebiriꞌ myu ne Ya.” ");
INSERT INTO plw_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Sinusi i Pelipe kwan ye, “Begerar, ipebirinaꞌ damen Amaꞌ supaya mesdengan kay ne.” ");
INSERT INTO plw_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Kwan i Jesus, “Mekwit myu na aku binaꞌbayaꞌ, bekeꞌ diki mu aku nekilala, Pelipe? Sebarang nekebiriꞌ daken, banar nekebiriꞌ ne dut Amaꞌ ku. Manu nega pegsusien mu na kwan, ‘Ipebirinaꞌ be damen Amaꞌ?’ ");
INSERT INTO plw_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Kaya pengandel ke na aku tuꞌ dut Amaꞌ, bekeꞌ Amaꞌ atuꞌ gasi et daken, sesembatu kay? Mengeꞌ beres na sinugid dimu, diki lang daken gaked, imbes teyeg atin dut Amaꞌ. Na atuʼt daken na pegkeradya et kenyeng mengeꞌ bubuwaten. ");
INSERT INTO plw_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Endelaꞌ ku baꞌ sugiren ku na aku dut Amaꞌ, bekeꞌ Amaꞌ atuʼt daken. Etawa, endelaꞌ ku sabab et mengeꞌ keliluꞌlilung tendaꞌ na binwat ku.” ");
INSERT INTO plw_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Kwan i Jesus, “Sugiran ku kemyu et kebenaran, sebarang maya pegandel dut daken, buwaten ye et lebi nega et itueng binwat ku. Mekedyari ye buwaten lebi nega eset binwat ku sabab surungan ku ne dut Empuꞌ Amaꞌ ku. ");
INSERT INTO plw_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Baꞌ enu engaten myu sabab et pegandel myu daken, atin buwaten ku supaya gasi mebantug Amaꞌ sabab et binwat ku, yegang ye. ");
INSERT INTO plw_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Baꞌ maya engaten myu daken sabab et pegandel myu daken, buwaten ku atin.” ");
INSERT INTO plw_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Sinugid gasi i Jesus, kwan ye, “Baꞌ kelaꞌ pegingin myu daken, tumanen myu baꞌ enu tinahag ku. ");
INSERT INTO plw_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Bekeꞌ aku mengangat dut Amaꞌ, na begeyan kew et sembatung menenabang supaya meiba-iba myu et daran, megsubli daken. ");
INSERT INTO plw_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Itueng menenabang, atin ne Menungang Nakem naꞌ Empuꞌ. Mengeꞌ taaw et sengkedunyaan kaya megterima dut Menungang Nakem na penulduꞌ et keberbenaran, sabab kaya mekekilala dye ya etawa mekebiriꞌ. Segwaꞌ dimyu mekekilala myu ya, sabab ya meglelegdeng dut seled myu. Na atin dumaran set dimyu. ");
INSERT INTO plw_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Diki ku tirengan kemyu na samat ilu-ilu. Seulinen ku nega kemyu atuꞌ. ");
INSERT INTO plw_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Diki ne mekwit, mengeꞌ tawʼt sengkedunyaan diki ne kebiriꞌ daken. Segwaꞌ dimyu mebiriꞌ myu nega aku. Sabab aku megbiyag et kaya seskeran, kwantin nega dimyu megbiyag kew gasi et kaya seskeran. ");
INSERT INTO plw_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Dut ating eldew, mesewran myu na aku dun net Amaꞌ ku, sesembatu kay. Bekeꞌ mesewran myu gasi na aku dut dimyu, kemyu dut daken, sesembatu tyu. ");
INSERT INTO plw_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Sebarang megingin daken, pegtumanen ye mengeꞌ daak ku. Na ya ne megingin daken. Sampay atin ya inginen gasi et Amaꞌ ku. Kwantin gasi daken penginginen ku ya, sampay iperetiꞌ ku kenye.” ");
INSERT INTO plw_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Mendyari, sinugid i Judas, diki lang si Judas Iskariote, kwan ye, “Segwaꞌ, Begerar, manu ingin mu na dut damen ke lang megperetiꞌ, diki dut ginsan mengeꞌ taaw et itueng sengkedunyaan?” ");
INSERT INTO plw_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Siminambag si Jesus, kwan ye, “Sebarang megingin daken, tumanen ye daken neng mengeꞌ tulduꞌ. Sampay Amaꞌ ku meingin kenye, bekeꞌ duwa kay et Amaꞌ ku dumun et kenye supaya ya ne baalen kay et lelegdengan. ");
INSERT INTO plw_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Sebarang diki megingin daken, diki ye tumanen daken neng mengeꞌ tulduꞌ. Nekingeg myu itueng beres diki lang daken gaked, temed teyeg ki Amaꞌ na negdaak daken. ");
INSERT INTO plw_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Sinugid ku rimyu ginsan naꞌ itue sasat iba-iba myu nega aku. ");
INSERT INTO plw_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Segwaꞌ daaken et Amaꞌ Empuꞌ surung dimyu Ating Menenabang, na Ya ating Empung Nakem naꞌ Empuꞌ. Na Ya negsubli daken. Ya menulduꞌ dimyu sampay megperendem et ginsan neng sinugid ku dimyu.” ");
INSERT INTO plw_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Sinugid gasi i Jesus, kwan ye, “Kesenangan itektak ku dimyu. Kesenangan ku gaked igbey ku dimyu. Diki lang igbey ku dimyu kesenangan samat pegigbey et mengeꞌ tawʼt sengkedunyaan. Kasiꞌ myu ipesusaꞌ atey myu, bekeꞌ kas kewʼt ketakut. ");
INSERT INTO plw_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Nekingeg myuʼt kwit pinegberes ku dimyu, kwan ku, ‘Mugad ku, segwaꞌ peulinan ku nega kemyu?’ Baꞌ aku iningin myu, meksanan kew sabab surung ku tuꞌ dut Amaꞌ. Sabab, Amaꞌ lebing ketaasan ye dut daken. ");
INSERT INTO plw_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Pinegberes ku ne lagi dimyu tiban mura metuman itue. Na baꞌ metuman ne, atin peꞌ mengandel kew ne daken. ");
INSERT INTO plw_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Diki ku ne pekwiten bebresen ku dimyu, sabab megderateng ne surutan atueʼt dunyaꞌ, ating pegibuten et mengeꞌ meraat na taaw, si Seytan. Diki ya kepegewla daken. ");
INSERT INTO plw_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Angkansa, pegbuwaten ku sebarang mengeꞌ daak et Amaꞌ, supaya mesewran et ginsan neng taaw et sengkedunyaan na peginginen ku Amaꞌ. Naꞌ, tiyeg kew ne, untin tyu ne!” ");
INSERT INTO plw_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Indyari, tinuturan i Jesus, kwan ye, “Aku antangan ku samat banar na puun et ubas. Amaꞌ ku antangan ye samat mengingipat et itueng puun et ubas. ");
INSERT INTO plw_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Pegputken ye sebarang sanga eset daken na diki megbuaꞌ. Sebarang sanga na megbuaꞌ, atin pegpetlangan ye, pegugaran ye et mengeꞌ deluruꞌ supaya kumansang buaꞌ ye. ");
INSERT INTO plw_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Netlangan kew ne, sabab et beres na sinugid ku dimyu. ");
INSERT INTO plw_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Tumeteg kew daken, aku gasi dumaran dut dimyu. Kaya lang sanga muaꞌ baꞌ kaya petetangen dut puun. Kwantin gasi dimyu, diki kew kekeradya et menunga selyu lang mengandel kew daken. ");
INSERT INTO plw_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Aku antangan ye puun et ubas, kemyu mengeꞌ sanga ku. Baꞌ sinu tumeteg daken, aku gasi dumaran dut kenye. Na ya kebuaꞌ et mekeldam, ingin bersen kekeradya et menunga banar. Baꞌ peparak kew daken, kaya menunga mebutbuwat myu. ");
INSERT INTO plw_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Baꞌ sinu diki tumeteg daken, sepantun samat sanga na tinimbag baꞌ metuug ne. Pegpuruten tebes in, na itimbag dut apuy supaya metutung. ");
INSERT INTO plw_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Baꞌ kemyu tumeteg daken, bekeꞌ beres ku tumeteg gasi dimyu, mekedyari misan enu-enung engaten myu, na atin igbey ku dimyu. ");
INSERT INTO plw_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Na baꞌ megbuwat kew et mekeldam neng menungang keradya, na atin kebentugan et Amaꞌ ku dut langit, bekeꞌ mepesebenaran gasi na kemyu pepengenaran ku. ");
INSERT INTO plw_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Baꞌ enukwan pegingin daken et Amaꞌ, kwantin gasi pegingin ku dimyu. Na tiban, tumeteg kew daken neng pegingin. ");
INSERT INTO plw_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Baꞌ tumanen myu mengeꞌ bilin ku, timineteg kew ne et pegingin ku. Samat pegtuman ku et mengeꞌ daak et Amaꞌ ku, na aku megteteteg ne et pegingin ye. ");
INSERT INTO plw_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Sinugid ku itue dimyu supaya mepeeset dimyu keksanan ku, apang dimyung keksanan medyukup. ");
INSERT INTO plw_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Itue e ibilin ku, megsiinginan kew et tegsembatu-sembatu dimyu, samat pegingin ku dimyu. ");
INSERT INTO plw_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kaya pegingin et sembatu luwas nega eset pegingin et sembatung taaw na itue, ililaꞌ ye biyag ye sabab et mengeꞌ biꞌbilaꞌ ye. ");
INSERT INTO plw_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Kemyu mengeꞌ bibilaꞌ ku, baꞌ tumanen myu mengeꞌ bilin ku. ");
INSERT INTO plw_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Tihad tiban, diki ku ne kemyu antangaʼt uripen, sabab diki lang pegsesewren et dereakan sebarang pegbuwaten et pegibuten ye. Angkansa itingkag ku dimyu bibilaꞌ ne. Sabab ginsan nekingeg ku teyeg dut Amaꞌ ku, pineretiꞌ ku dimyu. ");
INSERT INTO plw_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Diki lang kemyu nemiliꞌ daken, imbes aku nemiliꞌ dimyu bekeꞌ nemilin dimyu supaya mepanew kew bekeꞌ megkeradya kew et daran neng menungang keradya. Atin keradya myu mepagen sampay dumaran, diki megpinda. Angkansa igbey dimyu et Amaꞌ misan enu engaten myu dut ingaran ku. ");
INSERT INTO plw_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Itue e daak ku dimyu, meginginan kew et tegsembatu-sembatu dimyu.” ");
INSERT INTO plw_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Sinugid i Jesus dut pepengenaran ye, kwan ye, “Baꞌ megiseg dimyu mengeꞌ taaw et sengkinleban et dunyaꞌ, rendemaꞌ myu na aku mena pegisgan dye. ");
INSERT INTO plw_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Supama baꞌ kemyu sesaliꞌ dut ginsan taaw atueʼt sengkedunyaan na megsagkaꞌ dut Empuꞌ, negkesian kew et taaw sabab kemyu saliꞌ kedye. Segwaꞌ, kemyu diki lang sesaliꞌ dut mengeꞌ taaw atueʼt sengkedunyaan. Temed piniliꞌ ku kemyu teyeg kedye. Angkansa megiseg dye dimyu. ");
INSERT INTO plw_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Rendemaꞌ myu mengeꞌ pinegberes ku dimyu, ‘Kaya tetehagen metaas dut kenyeng pegibuten!’ Baꞌ tiniksaꞌ et ibang taaw aku, kemyu gasi tiksaen dye. Baꞌ inandel dye tulduꞌ ku, endelen dye gasi tulduꞌ myu. ");
INSERT INTO plw_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Kwantin pemibit dye dimyu sabab kemyu megsunud et mengeꞌ ketulduan ku, sabab diki dye nekilala Empuꞌ sembatung negdaak daken. ");
INSERT INTO plw_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Baꞌ diki natuꞌ ku na negberes kedye, kaya teyen nesewran dye salaꞌ dye. Segwaꞌ tiban, misan megenu, diki dye ne kedawa et keselaan dye. ");
INSERT INTO plw_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Sebarang megiseg daken, megiseg gasi dut Amaꞌ ku. ");
INSERT INTO plw_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Baꞌ kaya teyen nekebiriꞌ dye et mengeꞌ keliluꞌlilung nekeradya ku na misan sinu diki kekeradya samat kwantin, kaya lang teyen keselaan dye. Segwaꞌ tiban, nebiriꞌ dye ne mengeꞌ keliluꞌlilung tendaꞌ na binwat ku. Temed ga in megiseg dye nega daken sampay dut Amaꞌ ku. ");
INSERT INTO plw_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Segwaꞌ itueng neinabu supaya metuman baꞌ enu nekesurat dut kedyeng Keseraan teyeg dut Empuꞌ, kwan, ‘Megiseg dye daken na kaya pesebaban.’ ");
INSERT INTO plw_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Segwaꞌ baꞌ katuꞌ ne Menenabang na deaken ku teyeg dut Amaꞌ Empuꞌ, atin Empung Nakem na pegtulduꞌ et keberbenaran na lumiwan teyeg dut Amaꞌ Empuꞌ, Ya in megpesebanar pasal daken. ");
INSERT INTO plw_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Kemyu megpesebanar gasi pasal et daken sabab neiba-iba ku kemyu dut sengkepunan.” ");
INSERT INTO plw_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Sinugid gasi i Jesus dut mengeꞌ pepengenaran ye, kwan ye, “Sinugid ku dimyu ginsan neng itue e supaya diki kew meugaran et pengandel pasal daken. ");
INSERT INTO plw_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Maya eldew megderateng ipeliwan dye kemyu dut sinagoga, atin pengempuan neng benwa. Asal, megapet ne timpu na sinu mengimatey dimyu, keblan dye na nekesukuꞌ dye dut Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Naꞌ keredyanen dye itue dimyu sabab diki dye nekilala Amaꞌ etawa aku. ");
INSERT INTO plw_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Segwaꞌ sinugid ku dimyu itue e, supaya baꞌ dumateng ne timpu et ketiksaan dye, merendeman myu na baꞌ enu pinegberes ku dimyu kwit tiꞌ. Angkan kaya sinugid ku lagi pasal itue dimyu sabab iba-iba myu nega aku.” ");
INSERT INTO plw_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Tiban sumurung ku ne dut negtahag daken. Segwaꞌ misan sembatu dimyu kaya nengingkut daken, na kwan, ‘Embe surungan mu?’ ");
INSERT INTO plw_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Sabab sinugid ku ne itueng ginis, mebaha kew ne banar et kerupukan. ");
INSERT INTO plw_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Segwaꞌ sugiran ku kemyu et kebenaran, dut pegugad ku maya kepulusan myu. Sabab baꞌ diki ku mugad, diki matuꞌ atin Menenabang. Segwaꞌ baꞌ mugad ku, ya daaken ku sumurung dut dimyu. ");
INSERT INTO plw_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Baꞌ dumateng ne Menenabang, pesebenaran Ye dut mengeꞌ tawʼt sengkedunyaan pasal dut keretian et keselaan, keretian et ketignaan, bekeꞌ dut keretian et keukuman et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Iperetiꞌ kedye na maya salaꞌ dye, sabab kaya dye pengandel dut daken. ");
INSERT INTO plw_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Iperetiꞌ kedye pasal dut ketignaan ku, sabab aku mugad sumurung dut Empuꞌ Amaꞌ, na diki myu ne aku mebiriꞌ. ");
INSERT INTO plw_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Iperetiꞌ gasi kedye pasal dut keukuman et Empuꞌ, sabab si Seytan surutan et itueng sengdunyaan sanad, neukuman ne.” ");
INSERT INTO plw_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Sinugid gasi i Jesus, kwan, “Mekansang nega teyen isugid ku dimyu, segwaꞌ ingga mepikiran myu mibit et tiban-tiban nega. ");
INSERT INTO plw_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Temed baꞌ dumateng ne Nakem naꞌ Empuꞌ na petulduꞌ et keberbenaran, ya menulduꞌ dimyu et ginsan neng kebenaran. Diki lang ya mekepegberes dut diri ye lang, segwaꞌ ipegberes ye sebarang nekingeg ye teyeg et Empuꞌ. Na ipebunayag ye ginsan neng keginisan baꞌ enu dumateng. ");
INSERT INTO plw_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ya megbantug daken, sabab sebarang ipebunayag ye dut dimyu ginsan teyeg daken. ");
INSERT INTO plw_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ginsan neng teyeg dut Amaꞌ, yeen ku. Angkansa pegsugiren ku, na Nakem naꞌ Empuꞌ mengisiꞌ dut daken neng bebresen, na ipebunayag ye gasi dut dimyu. ");
INSERT INTO plw_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Diki ne mekwit, diki myu ne aku mebiriꞌ. Diki gasi mekwit-kwitan, mebiriꞌ myu gasi aku.” ");
INSERT INTO plw_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Maya mengeꞌ pepengenaran i Jesus negsisugid-sugid dye, “Enu ingin ye bersen na kwan ye, ‘Na, diki ne mekwit, diki myu ne aku mebiriꞌ. Diki gasi mekwit-kwitan, mebiriꞌ myu gasi aku?’ Bekeꞌ ‘Sabab sumurung ku dut Amaꞌ.’?” ");
INSERT INTO plw_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Negmegsiingkut-ingkutan dye gasi, “Enu ingin ye bersen, ‘Na, diki ne mekwit?’ Diki tyu meretian baꞌ enu pegbersen ye in.” ");
INSERT INTO plw_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Nesewran i Jesus na ingin dye mengingkut kenye pasal et itue e. Angkansa sinugiran i Jesus dye, kwan ye, “Pemegsiingkut-ingkutan kew be baꞌ enu ingin ku bersen tiat sinugid ku dimyu in, ‘Diki ne mekwit, diki myu ne aku mebiriꞌ. Diki gasi mekwit-kwitan, mebiriꞌ myu gasi aku?’ ");
INSERT INTO plw_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Sugiran ku kemyu et kebenaran, kesiyak kew bekeꞌ rumupuk kew, segwaꞌ mengeꞌ taaw atueʼt sengkedunyaan meksan. Rumupuk kew, segwaꞌ rupuk myu megmendyaring keksanan. ");
INSERT INTO plw_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Samat sembatung libun naꞌ mengganak pegteterman sabab diminateng ne timpu ye. Segwaꞌ baꞌ nundas ne memulek, melipatan ye ne sakit sabab et keksan ye na nundas ne memulek dut dunyaꞌ. ");
INSERT INTO plw_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Kwantin gasi dimyu, tiban megrurupuk kew ne gasi. Segwaꞌ baꞌ pekibiriꞌ ku gasi dimyu ne peuliꞌ, meresanan myu gasi meglebi-lebi neng keksanan. Na, kaya sinu mekeugad et keksanan naꞌ atin. ");
INSERT INTO plw_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Pegdateng et eldew naꞌ atin, kaya ne dimyu mengingkut daken et enu. Asal banar igbey dimyu et Amaꞌ ku sebarang engaten myu sabab et pengandel myu daken. ");
INSERT INTO plw_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Seked tiban kaya pengangat kew et enu-enu sabab et pengandel myu daken. Mengangat kew supaya keterima kew, apang keksanan myu mesukup.” ");
INSERT INTO plw_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Sinugid i Jesus kedye, kwan, “Seukat ne pegberes ku dimyu et beleybey. Dumateng timpu na diki ku ne bersen dimyu samat itueng bebresen, segwaꞌ bentelen ku ne dimyu, megsugid pasal dut Amaꞌ ku. ");
INSERT INTO plw_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Pegdateng et eldew naꞌ atin, mengangat kew et Empuꞌ sabab et pengandel myu daken. Kaya pegsugiren ku na engatan ku kemyu dut Amaꞌ ku, ");
INSERT INTO plw_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Sabab Empuꞌ Amaꞌ megingin dimyu, sabab iningin myu aku bekeꞌ nengandel kew na aku teyeg dut Empuꞌ Amaꞌ. ");
INSERT INTO plw_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Banar, teyeg ku dut Empuꞌ Amaꞌ bekeꞌ natuꞌ kuʼt sengkedunyaan. Segwaꞌ tiban tumireng ku gasi dimyu atuʼt sengkedunyaan, bekeꞌ peuliꞌ ku ne dut Empuꞌ Amaꞌ ku dut langit.” ");
INSERT INTO plw_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Na kwan et mengeꞌ pepengenaran ye, kwan dye, “Tiban pegberes ke ne et mebentel, diki ne mekawad neng bebresen. ");
INSERT INTO plw_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Na tiban, nekesewran kay ne na ikew kesewd ginsan neng ginis, diki keilangan na ingkuten ke nega et sinu-sinu. Sabab et itue, nengandel kay ne teyeg ke dut Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Iningkut i Jesus, kwan ye, “Banar be, nengandel kew ne daken tiban? ");
INSERT INTO plw_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Segwaꞌ megderateng timpu, na asal diminateng ne, na kemyu megpekparak, megkenye-kenye kew ne et lelegdengan myu. Tirengan myu aku et aku-aku mene. Segwaꞌ diki lang yaya ku mene, sabab Amaꞌ ku nega iba-iba ku. ");
INSERT INTO plw_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Sinugid ku itueng ginis, supaya maya kesenangan myu sabab negsembatu kew dut daken. Sabab atuʼt sengkekinleban maya ketiksaan myu, sabab et taaw kaya pegendelen dye Empuꞌ. Segwaꞌ kepenggeraꞌ myu seled myu, sabab neraag ku ne dut pegibuten dye, si Seytan.” ");
INSERT INTO plw_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Pegketbes nesugid i Jesus itue e, timiningaraꞌ dut langit ampaꞌ ne negpenalang, kwan ye, “Amaꞌ, diminateng ne timpu, ipebantug aku, dimung yegang, supaya bentugen ke gasi et aku na yegang mu. ");
INSERT INTO plw_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Sabab binggeyan mu aku et kepegewlaan dut ginsan neng taaw na mekedyari ku begeyan et biyag na kaya seskeran dut ginsan na binggey mu daken. ");
INSERT INTO plw_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Dye in sebarang maya biyag na kaya seskeran, subaliꞌ mekilala dye ikew na sembatu lang bekeꞌ banar na Empuꞌ, bekeꞌ aku neng si Jesus Kristo, na dinaak mu atuʼt dunyaꞌ. ");
INSERT INTO plw_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Na Empuꞌ dut dibuwat, nepebunayagen ku dimung kebentugan atuʼt dunyaꞌ sabab nebuwat ku ginsan sebarang keradya na pinekeradya mu daken. ");
INSERT INTO plw_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Na tiban, Amaꞌ, ipetaasaꞌ ku dut elepan mu et ketaasan na pinegiba-ibanan te mura negmendyari sengkedunyaan.” ");
INSERT INTO plw_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Pinebunayag ku ikew dut mengeꞌ taaw na binggey mu daken mawaꞌ dut sengkedunyaan. Dye in dimu, indyari binggey mu dye daken, bekeꞌ tinuman dye dimung beres. ");
INSERT INTO plw_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Na tiban nesewran dye ne na ginsan neng binggey mu daken teyeg dut dimu banar. ");
INSERT INTO plw_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Sabab sinugid ku kedye mengeꞌ bebresen na sinugid mu daken, bekeꞌ itue tinerima dye ne. Nesewran dye na kebenaran na teyeg ku dut dimu, bekeꞌ nengandel dye na ikew negdaak daken. ");
INSERT INTO plw_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Pegpenelang ku dye, diki lang pegpenelang ku eset ginsan taaw atuʼt sengkedunyaan, temed sebarang binggey mu lang daken, sabab dye dimu banar. ");
INSERT INTO plw_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ginsan dut daken dimu, bekeꞌ ginsan dut dimu, atin daken gasi. Maya bantug daken sabab dye pengandel daken. ");
INSERT INTO plw_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Diki mekwit ku atuʼt sengkedunyaan. Sabab megsusurung ku dut dimu. Segwaꞌ dye in binggey mu daken, atuꞌ dye negaʼt sengkedunyaan. Pasek na Amaꞌ, timuruaꞌ dye et kebesagan et kepengdyarian mu, atin kepengdyarian na binggey mu daken supaya dye megsembatu samat kite na negsembatu. ");
INSERT INTO plw_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Sasat aku atuꞌ nega et kedye, pegtimuruen ku dye bekeꞌ kaya nenu dye sabab kebesagen et kepengdyarian mu na binggey daken. Kaya lang nalam, selyu lang dut sembatung mepesurung dut kedusaan supaya metuman Kesuratan et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Megsusurung ku ne dimu tiban, segwaꞌ pegbersen ku itue sasat atuꞌ ku nega et dunyaꞌ, supaya mebehanan seled dye et keksanan ku. ");
INSERT INTO plw_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Binggey ku ne kedye dimung beres. Segwaꞌ mengeꞌ taaw atuʼt sengkedunyaan memegiseg kedye, sabab dye taaw tumpang ne atuʼt dunyaꞌ, samat aku na taaw tumpang gasi atuʼt dunyaꞌ. Sabab amaꞌ kay dut langit. ");
INSERT INTO plw_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Diki ku pegpenelang supaya mengeꞌ pepengenaran ku ugaren mu atuʼt dunyaꞌ, segwaꞌ timuruaꞌ dye dut ki Seytan neng mereraat. ");
INSERT INTO plw_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Dye in taaw tumpang atuʼt sengkedunyaan, kwantin gasi daken. Sabab kaya saliꞌ pikiran kay eset tawʼt kaya pegandel et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ipetignaꞌ mu dye dut keberbenaran. Ating beres mu keberbenaran. ");
INSERT INTO plw_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Samat pegdaak mu daken atuʼt mengeꞌ taaw et sengkedunyaan, daaken ku dye gasi dut mengeꞌ tawʼt sengkedunyaan. ");
INSERT INTO plw_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Sabab dut kedye ililaꞌ ku diri ku dut dimu, kwantin gasi dut kedye na ililaꞌ dye dut dimu ne gasi banar. ");
INSERT INTO plw_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Pegpenelang ku diki dut kedye lang. Pegpenalangan ku gasi sebarang mengandel daken sabab et mengeꞌ pegpeabar dye. ");
INSERT INTO plw_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Na, Empuꞌ Amaꞌ, supaya ginsan dye megmendyaring sembatu kwantin samat ikew set daken, bekeꞌ aku dut dimu, supaya dye tumeteg gasi set kite; apang mengeꞌ tawʼt sengkedunyaan mengandel banar na aku dinaak mu. ");
INSERT INTO plw_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Binggey ku ne kedye kebentugan na binggey mu daken, supaya dye megsembatu samat kite na negsembatu. ");
INSERT INTO plw_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Aku tumeteg dut kedye, samat ikew tumeteg atuʼt daken, supaya dye megsembatu banar. Bekeꞌ mepesewd dye dut sengkekinleban na dinaak mu aku bekeꞌ iningin mu dye samat pegingin mu daken. ");
INSERT INTO plw_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Na Amaꞌ, gay ku sebarang binggey mu daken na megbeꞌbayaꞌ kay ne baꞌ embe ku, bekeꞌ mebiriꞌ dye kebentugan ku, na atin kebentugan na binggey mu daken, sabab minergaꞌ mu ne aku mura neguna sengkedunyaan. ");
INSERT INTO plw_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Metignaꞌ neng Amaꞌ, seukat ne diki ke nekilala et taaw atuʼt sengkedunyaan. Segwaꞌ aku nekekilala dimu, bekeꞌ nesewran et mengeꞌ pepengenaran ku ikew negdaak daken. ");
INSERT INTO plw_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ipinekilala ku ikew dut kedye. Na, ipelembus ku na ipekilala ke kedye, supaya pegingin dye dut mengeꞌ sebayaꞌ dye megmendyaring samat pegingin mu daken bekeꞌ supaya aku medaran dut seled pusuꞌ dye.” ");
INSERT INTO plw_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ganang netbes i Jesus negpenalang, nugad ya iba ye mengeꞌ pepengenaran ye nementel dye dut belnek et Kedron. Dut sembelang kilid maya keluluwakanan et mengeꞌ puun neng olibo. Mengeꞌ pepengenaran ye bekeꞌ ya siminurung duntin. ");
INSERT INTO plw_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Sewd i Judas, na negpelen kenye, baꞌ embe tampar ye, sabab si Jesus daran pemegtingtimung iba ye mengeꞌ pepengenaran ye dut ating Keluluwakanan neng Olibo. ");
INSERT INTO plw_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Angkansa si Judas neperuntin dut Keluluwakanan neng Olibo, megtuturun dut mengeꞌ kesusundeluan et tawʼt Roma bekeꞌ mekansang neng mengdidyaga dinaak et mengeꞌ pegibuten et pariꞌ bekeꞌ mengeꞌ Pariseo. Maya bibit dye mengeꞌ pelyatut, sisiluan, bekeꞌ gelaman. ");
INSERT INTO plw_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Pegsesewren ginsan i Jesus baꞌ enu meinabu kenye, indyari liminiwan bekeꞌ nengingkut, kwan ye, “Sinu keilangan myu?” ");
INSERT INTO plw_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Siminambag dye, kwan dye, “Si Jesus ne tawʼt Nasaret.” Kwan gasi i Jesus, “Aku ne pesi itue.” Si Judas neng mengengakal esentin, iba dye na petitiyeg. ");
INSERT INTO plw_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ganang nesugid i Jesus, “Aku ne pesi itue,” nekepesurut dye pegketbes neugbaꞌ dye dut lugtaꞌ. ");
INSERT INTO plw_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Iningkut i Jesus gasi dye peuliꞌ, “Sinu keilangan myu?” Kwan dye, “Jesus ne tawʼt Nasaret.” ");
INSERT INTO plw_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Siminambag peuliꞌ si Jesus, kwan ye, “Pegsugiran ku ne kemyu, na aku ne pesi itue! Baꞌ aku keilangan myu pesariꞌ myu mengeꞌ pepengenaran ku mugad.” ");
INSERT INTO plw_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Itue neinabu, supaya metuman ating pinegberes dut pegpenalangen ye dut kenyeng Empuꞌ Amaꞌ, “Diki ku pesaran mebinasa misan sembatu na binggey mu daken.” ");
INSERT INTO plw_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Si Simon Pedro na maya sabliꞌ ye, giminabut ampaꞌ ne timinigbas dut sembatung tetehagen et Metaas neng Pariꞌ. Neputek tampaꞌ kewanan neng telinga ye. Ingaran et tetehagen naꞌ atin si Malko. ");
INSERT INTO plw_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Binulag i Jesus si Pedro, “Isubaꞌ peuliꞌ sabliꞌ mu! Manu diki sendalan ku ketiksaan na binggey daken et Empuꞌ Amaꞌ ku?” ");
INSERT INTO plw_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Angkansa nealew si Jesus et mengeꞌ kesundeluan, iba dye pegibuten et kesundeluan bekeꞌ mengeꞌ pegibuten et mengeꞌ tawʼt Judio. Pinungpung dye ya. ");
INSERT INTO plw_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Binibit dye mena dut ki Anas na pengibanan i Kaipas, ating Metaas neng Pariꞌ ating teun na atin. ");
INSERT INTO plw_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Si Kaipas negsugid dut mengeꞌ pegibuten et mengeꞌ tawʼt Judio kwit tiꞌ na lebing menunga na sembatu lang matey sabab dut ginsan et mengeꞌ taaw. ");
INSERT INTO plw_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Si Simon Pedro bekeꞌ sembatung pepengenaran megseselundung ki Jesus. Sabab itueng sembatung pepengenaran kilala et Metaas neng Pariꞌ, na nayaꞌ dut ki Jesus dut seled uukuman et benwa et Metaas neng Pariꞌ. ");
INSERT INTO plw_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Segwaꞌ, si Pedro nepetektak dut liwan et lelengewan. Ating sembatung pepengenaran na kilala et metaas neng pegibuten et Pariꞌ, nepeuliꞌ, ampaꞌ ne binisara ye ating libun na megtutunggu et lelengewan na ipeseled si Pedro. ");
INSERT INTO plw_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Nengingkut ki Pedro ating libun na megtutunggu et lelengewan, kwan ye, “Diki be ikew na sembatu neng pepengenaran et taaw na itie?” Siminambag si Pedro, kwan ye, “Dein lang aku.” ");
INSERT INTO plw_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Na ating gebi meramig, angkansa mengeꞌ tetehagen et pegibuten sampay mengeꞌ pulis memegtitiyeg pelibut et bagat apuy supaya menengnarang. Si Pedro gasi iba dye petitiyeg duntin supaya menengnarang nega in. ");
INSERT INTO plw_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Sementaraꞌ, iningkut et Metaas neng Pariꞌ si Jesus pasal et kenyeng mengeꞌ pepengenaran bekeꞌ mengeꞌ tulduꞌ ye. ");
INSERT INTO plw_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Siminambag si Jesus, kwan ye, “Aku negberes ketemparan dut ginsan taaw. Daran aku pegtulduꞌ dut mengeꞌ sinagoga etawa dut Templo neng pengempuan naꞌ benwa, na baꞌ embe pegtingtimungan et mengeꞌ tawʼt Judio, kaya pegberes ku et petaguꞌ. ");
INSERT INTO plw_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Manu nega ingkuten mu aku? Atin ingkutaꞌ mayang nekekingeg daken. Tantu sewd dye baꞌ enu pinegberes ku.” ");
INSERT INTO plw_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ganang nesugid itue i Jesus, timpal rupa ye et sembatung pegibuten na eset abiꞌ ye. “Kwantin takuꞌ sumambag dut Metaas neng Pariꞌ?” kwan ye. ");
INSERT INTO plw_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Kwan i Jesus, “Baꞌ nekepegberes ku et salaꞌ, pesebenariꞌ baꞌ embe sentin na diki sugat. Segwaꞌ baꞌ pinegberes ku in banar, manu timpal mu aku?” ");
INSERT INTO plw_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Pegketbes, pinelusu i Anas si Jesus na pegpupungpungen nega, dut ki Kaipas ne Metaas neng Pariꞌ. ");
INSERT INTO plw_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Sasat petitiyeg nega si Pedro sabab penengnarang, iningkut gasi ya, “Banar takuꞌ na diki lang ikew na sembatung pepengenaran ye?” Negpeilu gasi, kwan ye, “Lein lang aku.” ");
INSERT INTO plw_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Nengingkut sembatung tetehagen et Metaas neng Pariꞌ na kampung et ating tetehagen na tinigbas i Pedro telinga ye nengingkut kenye, kwan ye, “Diki be ikew atin na nebiriꞌ ku in na iba-iba ye dut Keluluwakan et Olibo?” ");
INSERT INTO plw_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Negpeilu gasi peuliꞌ si Pedro. Negdingan lang et atin kiminerengek manuk. ");
INSERT INTO plw_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Teyeg ki Kaipas linusu si Jesus et mengeꞌ tawʼt Judio dut kelang benwa na lelegdengan i Gobernador Pilato na tinahag dut lungsud et Romano. Na atin kukueldew nega et Eldew et Kenkaan. Angkansa ingga nemenled et tawʼt Judio dut kelang benwa sabab kaluꞌ meririan dye sabab siminled dye dut benwa et tawʼt tumpang. Na baꞌ kwantin diki dye kekaan dut Kenkaan et Kerendeman et Neketalib. ");
INSERT INTO plw_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Angkansa, si Pilato ne lang liminiwan dut kedye bekeꞌ nengingkut, kwan ye, “Enung penaksir myu sagkaꞌ eset taaw na itue?” ");
INSERT INTO plw_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Siminambag dye, kwan, “Baꞌ diki ya mengengeradya et meraat, diki kay biten atuʼt dimung pegukum.” ");
INSERT INTO plw_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Kwan i Pilato, “Isiaꞌ myu ya, ukumaꞌ myu ne ya dut dimyung Keseraan.” Kwan gasi et mengeꞌ tawʼt Judio kenye, “Diki kay kepegewla na mengukum et kepeteyan.” ");
INSERT INTO plw_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Neinabu itue supaya metuman bebresen i Jesus pasal et baꞌ enung kepeteyan na ipatey ye. ");
INSERT INTO plw_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Nepeuliꞌ si Pilato dut seled et kelang benwa, ampaꞌ ye ne pinetingkag si Jesus. Pegketbes, iningkut ye si Jesus, kwan ye, “Ikew takuꞌ surutan et mengeꞌ tawʼt Judio?” ");
INSERT INTO plw_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Siminambag si Jesus, kwan ye, “Nesugid mu atin teyeg lang dimu, etawa sinugid dimu et kineldaman pasal daken?” ");
INSERT INTO plw_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Siminambag si Pilato, kwan ye, “Kwan mu lang, lengku, aku tuꞌ tawʼt Judio? Taaw sampay Metaas neng Pariꞌ mu nega nibit dimu atuʼt daken. Enu takuꞌ binwat mu?” ");
INSERT INTO plw_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Kwan i Jesus, “Pengmilikan ku kaya lang atuʼt sengkedunyaan. Baꞌ sengkedunyaan na itue, atue pengmilikan ku, meraliꞌ mengeꞌ tetehagen ku ipegatu dye aku supaya diki aku mebgey dut mengeꞌ pegibuten et mengeꞌ tawʼt Judio. Segwaꞌ kaya lang atuʼt sengkedunyaan na itue pengmilikan ku.” ");
INSERT INTO plw_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Sinugid i Pilato, kwan ye, “Baꞌ kwantin, ikew sembatung surutan?” Siminambag si Jesus, “Sugat pegsugiren mu in, na aku sembatung surutan. Itue pesi sabab ye na angkan aku pinegyegang. Sabab gasi et itue na natuꞌ kuʼt sengkedunyaan supaya pesebenaran ku keberbenaran. Sebarang dut keberbenaran megkingeg daken.” ");
INSERT INTO plw_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Iningkut i Pilato, “Enu takuꞌ keberbenaran?” Pegkeingkut i Pilato, liniwan ye gasi mengeꞌ tawʼt Judio, kwan ye, “Kaya nebiriꞌ ku salaꞌ dut kenye. ");
INSERT INTO plw_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Temed maya arat myu na aku mekedyaring megpeliwan et sembatung pirisu dut eldew et Kenkaan et Kerendeman et Neketalib. Ingin myu takuꞌ na ipeliwan ku ne lang itueng Surutan et mengeꞌ tawʼt Judio?” ");
INSERT INTO plw_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Negbegbensag dye, “Endey lang! Endey lang ya in! Segwaꞌ, si Barabas ipeliwanaꞌ!” Temed si Barabas sembatung mengrerampas. ");
INSERT INTO plw_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Angkansa pineisiꞌ gobernador Pilato si Jesus, ampaꞌ ye ne pinelepsan. ");
INSERT INTO plw_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Na, maya sundalu nememaal dyeʼt kayu ne suksukan antangan ye samat kuruna et surutan ampaꞌ dye ne pinepleng dut ulu i Jesus. Sampay gasi pinetepisnan dye si Jesus et ubien neng kumut, samat kumut et surutan. ");
INSERT INTO plw_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Mengeꞌ kesundeluan leyd-leyd dye pekabiꞌ dut ki Jesus na supaya inlelewen bekeꞌ sugiren lang kwan, “Megbiyag Surutan et mengeꞌ Tawʼt Judio!” Ampaꞌ dye ne gasi pegtetpalen rupa ye. ");
INSERT INTO plw_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Liminiwan gasi si Pilato kwan ye dut mengeꞌ tawʼt Judio, “Siyekiꞌ myu, ipineliwan ku ne ya dut dimyu supaya mesewran myu na kaya nebiriꞌ ku salaꞌ dut kenye!” ");
INSERT INTO plw_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ganang liminiwan ne si Jesus, segwaꞌ megepleng ne et kuruna neng suksuk, bekeꞌ maya nega tapis ye neng ubien, kwan i Pilato dut kedye, “Atue ne lelaki!” ");
INSERT INTO plw_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Pegkebiriꞌ et mengeꞌ metaas neng pariꞌ bekeꞌ mengeꞌ pegibuten et mengeꞌ tawʼt Judio, nemegbensag kwan dye, “Iransang dut krus! Iransang dut krus!” Segwaꞌ siminambag si Pilato, kwan ye, “Isiaꞌ myu ya bekeꞌ kemyu ne mengransang kenye dut krus. Sabab baꞌ dut daken lang, kaya nebiriꞌ ku salaꞌ dut kenye!” ");
INSERT INTO plw_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Memeglebi ga mengeꞌ tawʼt Judio, kwan dye, “Maya saraꞌ kay na pegsugiren dut Keseraan et Empuꞌ, subaliꞌ ya imeteyen, sabab pegsugiren ye ya Yegang et Empuꞌ!” ");
INSERT INTO plw_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ganang nekingeg itue i Pilato, lebi neng timinakut banar. ");
INSERT INTO plw_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ampaꞌ ne siminled peuliꞌ dut benwa. Pegdateng dun, iningkut i Pilato si Jesus, kwan ye, “Embe takuꞌ teyeg mu?” Segwaꞌ kaya ne timinubag si Jesus kenye. ");
INSERT INTO plw_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Kwan i Pilato dut kenye, “Mendiꞌ ke ne be mekibisara daken! Kaya mu be nesewran na aku maya basag na mekedyari ku ikew mepeliwan etawa megperansang dut krus?” ");
INSERT INTO plw_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Segwaꞌ siminambag si Jesus dut kenye, kwan ye, “Diki lumbi basag mu dut daken, selyu lang igbey rimu basag teyeg et Empuꞌ banar dut dibuwat langit. Angkansa sebarang nemibit daken atuʼt dimu, lebing mebegat keselaan dye.” ");
INSERT INTO plw_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Tihad sentin pegpikir-pikiren teyen i Pilato na ipeliwan si Jesus. Segwaꞌ mengeꞌ tawʼt Judio mara ginsan megsusugid, kwan dye, “Baꞌ ipeliwan mu itueng taaw naꞌ itue, diki ke beybegey et Surutan et bangsaʼt Roma. Sabab mayang sinu pemirmikir megsurutan, atin megsagkaꞌ dut Surutan.” ");
INSERT INTO plw_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ganang nekingeg i Pilato itue, pineliwan gasi si Jesus ampaꞌ ne narung dut eerungan et mengungukum dut “Pentaran na Batu,” pegngeranen dut bebresan et Hebreo atin “Gabata.” ");
INSERT INTO plw_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Eldew na atin, eldew et pegpanyap et Senglinggung Kerendeman et Kenkaan et Neketalib. Na atin ugtu ne eldew. Kwan i Pilato dut mengeꞌ tawʼt Judio, “Itue ne e surutan myu!” ");
INSERT INTO plw_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Segwaꞌ memegberes ga et merensag, kwan dye, “Peteyen ne ya! Peteyen ne ya! Iransang ne dut krus!” Kwan i Pilato kedye, “Iransang ku be ya na dimyung surutan?” Segwaꞌ kwan et mengeꞌ pegibuten et mengeꞌ pariꞌ, “Kaya lang surutan kay selyu lang Surutan dut bangsaʼt Roma!” ");
INSERT INTO plw_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pegketbes et atin, binggey i Pilato kedye si Jesus apang iransang. Angkansa, insiꞌ et mengeꞌ sundalu si Jesus. ");
INSERT INTO plw_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Pinepsan dye si Jesus et krus pesurung dut pegderetunan et “Bengkarak et Taaw” na pegngeranen dut bebresen et Hebreo atin “Golgota.” ");
INSERT INTO plw_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Atue e rinensangan kenye dut krus et kayu. Bekeꞌ maya duwa neginabu rinansang atin neng masa. Pineglimbangan dye ya, si Jesus, ne dut pinegketngaan dye. ");
INSERT INTO plw_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Maya siminurat et tendaꞌ lagi binaal i Pilato supaya ipekpel dut dibuwat yuntuk et krus. Kwaʼt tutugnaan ye, Si Jesus Tawʼt Nasaret neng Surutan et mengeꞌ Tawʼt Judio. ");
INSERT INTO plw_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Mekansang neng mengeꞌ tawʼt Judio nekebatsaꞌ et itueng surat dut rinensangan ki Jesus, sabab mekabiꞌ lang ating lungsud naꞌ atin. Nesurat itue gasi dut mengeꞌ bebresen et Hebreo, Latin, bekeꞌ Griego. ");
INSERT INTO plw_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Angkansa nemegsugid ki Pilato mengeꞌ pegibuteʼt pariꞌ, kwan dye, “Kasiꞌ isurataꞌ, ‘Surutan et mengeꞌ Tawʼt Judio’, erapun, ‘Keblan Ye lang na Ya Surutan et mengeꞌ Tawʼt Judio!’ ” ");
INSERT INTO plw_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Segwaꞌ kwan i Pilato, “Baꞌ enu nesurat ku, atin nesurat ne! Diki ne mekedyari beguen nega peuliꞌ.” ");
INSERT INTO plw_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Dut pegransang ki Jesus et mengeꞌ sundalu, pinengisiꞌ dye badyuꞌ ye ampaꞌ dye pinegbagiꞌbagiꞌ et epat neng kebegian, tegsengbagiꞌ ga sengketaawan. Segwaꞌ atin mene kaya tinahak dye suleb ye in sabab kaya mekansang tangkir ye, sembatu ga tetehian ye teyeg dibuwat surung pesanad. ");
INSERT INTO plw_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","“Dyangan tyu uyaten,” kwan dye, “segwaꞌ pegpesukuran tyu baꞌ sinu mempuan ye.” Neinabu itue supaya metuman atin ne nesurat dut Kesuratan et Empuꞌ, na kwan, “Pinegbeꞌbagiꞌ dye mengeꞌ repanan ku bekeꞌ pinegpesukuran dye badyuꞌ ku.” Na samat kwantin binwat et mengeꞌ kesundeluan. ");
INSERT INTO plw_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Mekabiꞌ dut krus pegtitiyegan et induꞌ i Jesus sampay kenyeng minan, bekeꞌ si Maria na esawa i Kleopas, bekeꞌ si Maria Magdalena. ");
INSERT INTO plw_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Pegkebiriꞌ i Jesus et induꞌ ye bekeꞌ mekmiꞌ neng si Juan na kenyeng pepengenaran na megtitiyeg gasi mekabiꞌ dut krus, kwan i Jesus dut induꞌ ye, kwan ye, “Pegmerganen ku neng libun, atin si Juan negsubli daken yegang mu.” ");
INSERT INTO plw_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Kwan i Jesus gasi dut ki Juan neng mekmiꞌ, kwan ye, “Atin induꞌ mu.” Tihad sentin, itueng pepengenaran ye binibit ye ne induꞌ i Jesus dut benwa ye. ");
INSERT INTO plw_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Pegketbes et itue, pegkesewd i Jesus na netuman ne ginsan. Apang gasi metuman ne banar atin nesurat dut Kesuratan et Empuꞌ, kwan ye, “Pegtutuknewen ku.” ");
INSERT INTO plw_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Maya esentin mangkuk baha et langgew. Angkansa dinitil dye gapas dut langgew ampaꞌ dye siningat dut yuntuk et kayu neng isopo, ampaꞌ dye ne sinuyak dut babaꞌ i Jesus. ");
INSERT INTO plw_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Pegkesepsep i Jesus et langgew, kwan ye, “Nepuwas ne.” Pagkaꞌ kwantin ne nepedunguk si Jesus. Pegpedunguk ye, nebugtuan ne et ginawa. ");
INSERT INTO plw_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Na atin eldew et Biyirnis, Eldew ne et Pegpanyap-panyap dut arat et mengeꞌ tawʼt Judio, sabab diklem Eldew ne et Diki Megkeradya dye. Angkansa, inangat dye ki Pilato na pemerien ne mengeꞌ betiis supaya matey megtuy mengeꞌ taaw neng rinansang dut krus, apang meugad ne bilug dye dut krus mura tumagnaꞌ Eldew et Diki Megkeradya. Mendiꞌ dye mengeꞌ patey neng bilug tumeteg dut krus megsing Eldew et Diki Megkeradya, sabab ating eldew pegmerganen dye. ");
INSERT INTO plw_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Angkansa nemengdateng mengeꞌ kesundeluan supaya memariꞌ et betiis et mengeꞌ taaw. Pegdateng pinemariꞌ dye betiis et unang taaw dut abiꞌ i Jesus, pegketbes sembatu gasi in. ");
INSERT INTO plw_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ganang dut ki Jesus ne, pagkaꞌ nebiriꞌ dye patey ne, kaya ne binariꞌ dye betiis ye. ");
INSERT INTO plw_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Segwaꞌ maya sembatu sundalu siminurak et budyak dut kikilid i Jesus. Pegabut ye, siminpuk mene duguꞌ lamud et danum. ");
INSERT INTO plw_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Mayang taaw nekebiriꞌ et itue negpesebanar bekeꞌ kenyeng pesebanar kaya embut. Sewd ye na pegsusugid keberbenaran, bekeꞌ pepesebenaran ye supaya mengandel kew. ");
INSERT INTO plw_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Sabab neinabu itue supaya metuman atin nesurat dut Kesuratan et Empuꞌ, na pegsugiren, “Misan sembatu neng tulang ye, kaya lang nebariꞌ.” ");
INSERT INTO plw_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Bekeꞌ samat pegsugiren gasi dut sembatung Kesuratan, na kwan, “Pegsisiyekan dye na ya pegsusuraken dye.” ");
INSERT INTO plw_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Pegketbes et itue, si Jose neng tawʼt Arimatea, sembatu gasing pepengenaran i Jesus, siminurung dut ki Pilato, supaya engaten ye bilug i Jesus. Pagkaꞌ tinugutan ne i Pilato, diminuntin ne. Segwaꞌ ganang diminuntin ne, kaya lang negpesewd ya na sembatung pepengenaran i Jesus sabab megtakut dut mengeꞌ tawʼt Judio. Pegdateng dun, megtuy ye insiꞌ bangkay i Jesus dut dibuwat et krus. ");
INSERT INTO plw_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Inibanan ya i Nikodemo, na atin nekeuna tiꞌ diminuntin ki Jesus et tengaꞌ gebi in. Nibit si Nikodemo et limangpulung kilo neng bebengluen neng pineglamud neng mira bekeꞌ aloe. ");
INSERT INTO plw_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Dyeng duwa nengisiꞌ et patey neng bilug i Jesus, nemedbed et bilug neng patey in dut kumut neng gedyilew na maya mamut ye, sabab kwantin arat et mengeꞌ tawʼt Judio baꞌ maya ilbeng. ");
INSERT INTO plw_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Dut pinegrensangan kenye maya duntin keluluwakanan. Dut keluluwakanan naꞌ atin, maya bagung lelbengan misan kasa kayangga peꞌ nelbengan. ");
INSERT INTO plw_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Angkansa duntin ne lang limbengan dye, sabab mekabiꞌ lang. Sabab gasi Eldew et Pegpanyap mura Eldew Diki Megkeradya et mengeꞌ tawʼt Judio. ");
INSERT INTO plw_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Na, ganang meliblingeb nega dut meriklem et eldew et Linggu, si Maria Magdalena siminurung dut lebeng. Pegbiriꞌ ye, netelilid ne pegtetembel neng batu. ");
INSERT INTO plw_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Angkansa diminarak pesurung dut ki Simon Pedro bekeꞌ dut sembatung pepengenaran na mekmiꞌ ki Jesus. Kwan i Maria, “Insiꞌ dye ne Begerar dut lebeng be tiꞌ! Naꞌ, diki kay ne mesewran baꞌ embe ne binitan dye!” ");
INSERT INTO plw_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Angkansa, de Pedro bekeꞌ sembatung pepengenaran ye siminurung gasi dut lebeng. ");
INSERT INTO plw_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Dyeng duwa nemegdarak. Segwaꞌ metikas sembatung pepengenaran in, neunan ye si Pedro diminateng dut lebeng. ");
INSERT INTO plw_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Pegdateng ye, megtuy liminigat. Nebiriꞌ ye mengeꞌ kumut neng gedyilew i Jesus pereratun mene. Segwaꞌ kaya lang kenye siminled. ");
INSERT INTO plw_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Segwaꞌ si Pedro neng nekeemuri, pegdateng ye, megtuy siminled dut lebeng. Nebiriꞌ ye gasi ganang kumut neng gedyilew i Jesus pereratun mene. ");
INSERT INTO plw_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Kumut neng kinurumung dut ulu i Jesus nelulun ne pereratun mene dut iged-iged, neseririꞌ ne dut kumut neng gedyilew. ");
INSERT INTO plw_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Sabab et atin, siminled gasi ating pepengenaran na diminateng meguna dut lebeng. Pegkebiriꞌ ye et atin negkwantin ne, mura nengandel ya na si Jesus megbiyag peuliꞌ. ");
INSERT INTO plw_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Tatap nega, ingga neretian dye na pegsugiren dut Kesuratan et Empuꞌ, na si Jesus megbiyag peuliꞌ teyeg dut kepeteyan. ");
INSERT INTO plw_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Pegketbes nemenguliꞌ ne mengeꞌ pepengenaran dut kedye-kedyeng benwa. ");
INSERT INTO plw_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Segwaꞌ si Maria, petitiyeg nega dut liwan et lebeng, megsisiyak. Sasat megsisiyak nega, liminigat dut seled et lebeng. ");
INSERT INTO plw_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Duntin nebiriꞌ ye duwang dereakan et Empuꞌ, megbebadyuꞌ et gedyilew, megarung dut dinetunan et bilug i Jesus. Sembatu dut uuluan, sembatu dut titikeran. ");
INSERT INTO plw_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Iningkut et duwang dereakan et Empuꞌ, kwan dye, “Libun, manu megsiyak ke?” Kwan et libun, “Pegsiyakan ku sabab insiꞌ dye daken neng Begerar, bekeꞌ kaya nesewran ku baꞌ embe binitan dye.” ");
INSERT INTO plw_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Pegberes yeʼt atin, peglingew ye tuꞌ nebiriꞌ ye si Jesus megtitiyeg, segwaꞌ ingga peꞌ nepiꞌpitewan ye na atin ne si Jesus. ");
INSERT INTO plw_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Kwan i Jesus, “Libun, manu megsiyak ke? Sinu pegtulusen mu?” Siminambag si Maria, kwan ye, “Ilaꞌ, baꞌ ikew nengisiꞌ, isugiraꞌ daken baꞌ embe dinetunan mu supaya isien ku.” Kwantin penugid i Maria sabab nebluan ye lang et mengingipat lang et keluluwakanan esentin. ");
INSERT INTO plw_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Segwaꞌ kwan i Jesus kenye, “Maria.” Ampaꞌ ne nepeteyuma si Maria dut kenye. Ganang nepiꞌpitewan ye ne, sinugid ye, kwan ye, “Raboni!” Atin bebresen et Hebreo gay bersen, “Menunulduꞌ”. ");
INSERT INTO plw_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Kwan i Jesus dut kenye, “Kasiꞌ ku mena pegkeptiꞌ, sabab ingga peꞌ neketurun ku dut Empuꞌ Amaꞌ. Segwaꞌ, sumurung ke dut mengeꞌ pepengenaran ku, bekeꞌ tuturaniꞌ dye naꞌ, ‘Peuliꞌ ku ne dut Amaꞌ ku. Na ating Amaꞌ, Amaꞌ myu gasi. Ya Empuꞌ ku, megdemikian Ya Empuꞌ myu gasi.’ ” ");
INSERT INTO plw_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Pagkaꞌ kwantin ne nepesurung si Maria Magdalena dut mengeꞌ pepengenaran. Pegdateng duntin, pinabar ye na kwan ye, “Nebiriꞌ ku Begerar in!” Ampaꞌ ye ne tinuturan samat sinugid kenye i Jesus. ");
INSERT INTO plw_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Na atin eldew et Linggu, unang eldew et senglinggu dut arat et mengeꞌ tawʼt Judio. Pegdateng et gebi et ating eldew et linggu, ganang negtingtimung mengeꞌ pepengenaran i Jesus, tinengleb dyeʼt meget mengeꞌ lelengewan sampay penendewan, sabab megtetakut dye dut mengeꞌ pegibuten et mengeꞌ tawʼt Judio. Pagkaꞌ kwantin ne, siminled si Jesus, kaya bekbeynek dye, atin mene tuꞌ sinugid ye et pinegketngaan dye, “Kesenangan matuꞌ et dimyu.” ");
INSERT INTO plw_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Pagkaꞌ nebres i Jesus ne itue, pinebiriꞌ ye kenyeng elima bekeꞌ kikilid. Pagkaꞌ nebiriꞌ dye Begerar neksanan dye banar. ");
INSERT INTO plw_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Negsugid si Jesus peuliꞌ dut kedye, “Kesenangan matuꞌ et dimyu. Baꞌ enukwan pegdaak daken et Amaꞌ, kwantin gasi deaken ku kemyu.” ");
INSERT INTO plw_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Na ganang nesugid ye ne itue, binuhaan ye dye, kwan ye, “Terimanaꞌ myu Pasek na Nakem naꞌ Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Baꞌ maapen myu mengeꞌ salaꞌ et mengeꞌ taaw, maapen dye gasi et Empuꞌ. Segwaꞌ baꞌ diki maapen myu mengeꞌ salaꞌ et mengeꞌ taaw, diki gasi maapen et Empuꞌ dye.” ");
INSERT INTO plw_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Segwaꞌ si Tomas pegngeranen na si Didymus, ingin bersen “Kambar”, sembatu dut sempuluꞌ duwang pepengenaran kaya sentin pegdateng i Jesus dut tinengleb neng sisingled. ");
INSERT INTO plw_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Tinuturan et ibang pepengenaran na kwan, “Nebiriꞌ kay Begerar!” Segwaꞌ kwan i Tomas, “Diki ku mengandel, selyu lang baꞌ mebiriꞌ ku lasut et ransang elima ye, bekeꞌ ipeseled kuʼt tulduꞌ ku dut delang et mengeꞌ ransang, bekeꞌ meluek kuʼt keremut ku kikilid ye, atin peꞌ mengmemana ku ne.” ");
INSERT INTO plw_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Pegketalib et senglinggu, nemegtingtimung gasi peuliꞌ mengeꞌ pepengenaran i Jesus dut metingreb neng benwa. Segwaꞌ si Tomas pelelamud ne kedye. Sunggu metingreb ne benwa, atin mene inggaꞌ dye tuꞌ, pegbiriꞌ dye tuꞌ, petitiyeg ne si Jesus dut pinegketngaan dye, kwan ye, “Kesenangan meseʼt dimyu.” ");
INSERT INTO plw_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Negsugid si Jesus ki Tomas, kwan ye, “Tomas, isuwelaꞌ tulduꞌ mu anie, siyekiꞌ be keremut ku in. Na, iktangaꞌ keremut mu ampaꞌ mu ne iluek elima mu dut kikilid ku niꞌ. Na, ingang kas ne pegduruwa, mengandel ke ne.” ");
INSERT INTO plw_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Kwan i Tomas ki Jesus, “Begerar ku bekeꞌ Empuꞌ ku.” ");
INSERT INTO plw_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Kwan i Jesus kenye, “Sabab et nebiriꞌ mu aku, mura ke nengandel. Mesukud sebarang kaya nekebiriꞌ segwaꞌ nengandel daken.” ");
INSERT INTO plw_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Mekansang negang mengeꞌ keliluꞌlilung tendaꞌ nebuwat i Jesus dut elepan et kenyeng mengeꞌ pepengenaran na kaya nekesurat eset buuk na itue. ");
INSERT INTO plw_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Segwaꞌ nesurat itue atuꞌ supaya mengandel kew si Jesus na atin ne Mesias, etawa Kristo, ating Yegang et Empuꞌ, bekeꞌ sebarang mengengandel kenye maya biyag na kaya seskeran dut langit. ");
INSERT INTO plw_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Pegketbes et itue, negpebiriꞌ peuliꞌ si Jesus dut mengeꞌ pepengenaran ye dut abiꞌ et dagat et Tiberias. Neinabu itue samat kwantin tuturan ye: Atin masa, memegbebayaꞌ mengeꞌ pepengenaran i Jesus dut deplakan et dagat. ");
INSERT INTO plw_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Indyari dye in de Simon Pedro, si Tomas pegngeranen Kambar, si Natanael tege-Kana dut probinsiya et Galilea, bekeꞌ duwang yegang i Sebedeo bekeꞌ duwang ibang pepengenaran i Jesus. ");
INSERT INTO plw_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","“Megdyeul ku daken,” kwan i Simon Pedro kedye. “Mayaꞌ kay dimu!” kwan dye. Angkansa neperagat dye ne, pegdateng duun nemenakat ne dut gubang. Segwaꞌ ating gebi kaya lang nekeisiꞌ dye. ");
INSERT INTO plw_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Merimdiklem nega, si Jesus megtitiyeg dut egis, segwaꞌ kaya nepiꞌpitewan et mengeꞌ pepengenaran ye na ya ne si Jesus. ");
INSERT INTO plw_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Timiningkag si Jesus kedye, kwan ye, “Mengeꞌ bilaꞌ, maya seraꞌ myu?” Tubag dye, “Kaya lang.” ");
INSERT INTO plw_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","“Na, irebuaꞌ myu rambat myu dut tampaꞌ kewanan et gubang myu, keisiꞌ kew et mekansang.” Angkansa dinabuꞌ dye. Pegbatun dye tuꞌ usa-usa diki dye mebituaꞌ petindal dut gubang sabab et derekerang mengeꞌ seraꞌ. ");
INSERT INTO plw_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Pepengenaran neng mekmiꞌ ki Jesus, kwan ye dut ki Pedro, “Begerar pelan atin!” Pegkekingeg i Pedro, “Begerar pelan atin,” insiꞌ ye lelepisan ye ampaꞌ ye ne sinamut mura nepesbur dut dagat. ");
INSERT INTO plw_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Segwaꞌ ibang mengeꞌ pepengenaran i Jesus nayaꞌ ne dut gubang peiged megrerayak dye et rambat na baha et mengeꞌ seraꞌ, sabab diki banar merayuꞌ dut deplakan. Maya lang mengeꞌ limangpulung depa lang rayuꞌ ye. ");
INSERT INTO plw_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ganang nekerungguꞌ dye, nebiriꞌ dye na maya ne mengeꞌ seraꞌ bekeꞌ bengbang na pegtetepaan dut baga et apuy. ");
INSERT INTO plw_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Kwan i Jesus kedye, “Bibit kew anie et senu-senung seraꞌ neng neisiꞌ myu.” ");
INSERT INTO plw_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Si Simon Pedro, kenye neperibuwat ne dut gubang, pegketbes rinayak ye ne rambat dut deplakan. Nebaha et senggatus limangpuluꞌ telung mengeꞌ derekerang mengeꞌ seraꞌ. Segwaꞌ misan kwantin keldamen kaya lang neuyat. ");
INSERT INTO plw_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Kwan i Jesus kedye, “Aniꞌ kew ne, mengaan tyu mena et pengdirikleman.” Kaya misan sinu kedye neng mengeꞌ pepengenaran na meketuakal na mengingkut kenye, na kwan, “Sinu ke?” sabab sewd dye atin na Begerar. ");
INSERT INTO plw_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Nepekabiꞌ si Jesus, ampaꞌ nengisiꞌ et bengbang pegketbes pinemgey ye dut kedye. Kwantin gasi kineradya dut seraꞌ. ");
INSERT INTO plw_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Itue ne iketlung pegpebiriꞌ i Jesus dut kenyeng mengeꞌ pepengenaran pegketbes na ya negbiyag peuliꞌ teyeg dut kepeteyan. ");
INSERT INTO plw_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ganang netbes dye ne nengaan, negsugid si Jesus dut ki Simon Pedro, kwan ye, “Simon, yegang i Juan, banar be na peginginen mu aku lebi nega et mengeꞌ itueng kesebeyaan mu peginginen aku?” “Eꞌ, Begerar!” kwan i Pedro, “Pegsesewren mu meingin ku dimu.” “Naꞌ,” kwan i Jesus, “Peruriaꞌ mengeꞌ mengengandel ku samat mengingipat et mengeꞌ ibun et bibili, ipekanaꞌ dye.” ");
INSERT INTO plw_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Negberes gasi peuliꞌ si Jesus, kwan ye, “Simon yegang i Juan, banar be na pegingin mu daken?” “Eꞌ, Begerar!” kwan i Pedro, “Pegsesewren mu na peginginen ku ikew.” Kwan i Jesus, “Mengingipat et mengeꞌ bibili ku, ingin bersen, mengeꞌ mengengandel ku.” ");
INSERT INTO plw_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Iketlu ne mingkut kenye, kwan i Jesus, “Simon, yegang i Juan, peginginen mu takuꞌ aku?” Ruminupuk si Pedro sabab ketlu ne iningkut kenye, kwan ye, “Peginginen mu takuꞌ aku?” Timinubag gasi si Pedro, kwan ye, “Begerar, sewd mu ginsan neng ginis, sewd mu na peginginen ku ikew.” Sinugid i Jesus, “Na, timuruaꞌ mengeꞌ bibili ku, ingin bersen gasi, timuruaꞌ mengeꞌ mengengandel ku.” ");
INSERT INTO plw_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Sinugid i Jesus ki Pedro, kwan ye, “Asal, isugid ku rimu, kwit tiꞌ yengyegang ke nega sewd mu ne megimara, bekeꞌ megsurung ke misan embe gaay mu surungan. Segwaꞌ, pegurang mu ne, iktang mu mene lengen mu supaya pebedyuan ke et sebayaꞌ mu, bekeꞌ dundunen ke mene baꞌ embe diki ingin mu surungan.” ");
INSERT INTO plw_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Sinugid i Jesus itue supaya ipesewd baꞌ enukwan si Pedro matey, supaya sabab et kwantin mebantug ye Empuꞌ. Indyari kwan i Jesus ki Pedro, “Mibut, ke daken!” ");
INSERT INTO plw_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Liminingew si Pedro, nebiriꞌ ye na megsusunud kedye pepengenaran neng mekmiꞌ ki Jesus. Itue ne sembatung nepesendig dut derebdeban i Jesus dut pegkaan dye dut emuring pengmepunan. Na ya nega in negsugid, kwan, “Begerar sinu takuꞌ megperagang dimu?” ");
INSERT INTO plw_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ganang nebiriꞌ i Pedro si Juan, kwan ye, “Begerar, enukwan gasi meinabu kenye?” ");
INSERT INTO plw_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Siminambag si Jesus kenye, “Supama, baꞌ ingin ku na dumaran ya seked et kepeulian ku atuʼt dunyaꞌ, enu dut dimu? Ikew, subaliꞌ mibut daken!” ");
INSERT INTO plw_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Sabab et itue, nebuar pipitnaan sampay dut mengeꞌ mengandel, na itueng pepengenaran diki lang matey. Segwaꞌ kaya lang sinugid i Jesus na ya diki ne matey. Erapun sinugid ye lang, “Supama, baꞌ ingin ku na dumaran ya seked et kepeulian ku atuʼt dunyaꞌ, enu dut dimu?” ");
INSERT INTO plw_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Itueng pepengenaran ye na negpebnar et itueng ginisan, bekeꞌ negsurat et itue. Nesewran kay kenyeng pesebanar keberbenaran. ");
INSERT INTO plw_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Mekansang nega teyen binwat i Jesus. Segwaꞌ baꞌ isurat ginsan, meraliꞌ baꞌ pikiren ku misan sengkedunyaan diki lang kaluꞌ isunuꞌ mengeꞌ buuk pasal et binwat i Jesus.");
INSERT INTO plw_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Pegmerganen neng Teopilo: Tinuturan ku eset daken neng unang buuk binuwat bekeꞌ pegtulduꞌ i Jesus sengketegnaan, ");
INSERT INTO plw_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","seked dut eldew na Ya in ipinedibuwat ne dut langit. Mura si Jesus siminurung duntin, binilinan ye pebiyaʼt Nakem et Empuꞌ itueng mengeꞌ bibilinan na piniliꞌ Ye. ");
INSERT INTO plw_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ganang epat neng pulung eldew neketalib et kenyeng kemeteyan indyari pegkebiyag peuliꞌ, ya in nepebiriꞌ kedye et mekansang neng timpu, apang pesebenaran dye na ya in biyag. Dye in nemekebiriꞌ kenye, bekeꞌ nekipegtuturan ye kedye pasal et pengmilikaʼt Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Indyari sasat Ya in kebeꞌbayaꞌ dye mengaan pinemilinan kedye nega, kwan, “Dyanganaꞌ kew mena mugad dut lungsud et Jerusalem. Tegeyaꞌ myu duntin tinangeꞌ et Amaꞌ ku neng pegsugiren ku dimyu in. ");
INSERT INTO plw_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Sabab negbewtismu pesi si Juan et danum, segwaꞌ diki ne mekwit indyari bewtismuan kew nega et Nakem et Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Angkansa ganang negtingtimung ne si Jesus bekeꞌ kenyeng mengeꞌ bibilinan, nemengingkut dye kenye, kwan, “Begerar, ikew ne be takuꞌ menggey peuliꞌ et tiban neng timpu ating patut na pengmilik dut mengeꞌ tawʼt Israel?” ");
INSERT INTO plw_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Siminambag ya, “Binetang et Amaꞌ et mengeꞌ timpu bekeꞌ eldew atin et kenyeng diring kepengyedian, indyari diki ne keilangan mesewran myu nega baꞌ ingyan takuꞌ atin. ");
INSERT INTO plw_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Segwaꞌ begeyan kew et kepengyedian pegkeineug dimyu et Nakem et Empuꞌ, indyari kemyu tuꞌ megmendyaring mengeꞌ saksiꞌ ku dut lungsud et Jerusalem, dut sengketelingkepaʼt probinsiya et Judea bekeꞌ Samaria, bekeꞌ dut ketimpusaʼt dunyaꞌ.” ");
INSERT INTO plw_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Pegkesugid et itue, ya in periribuwat ne dut langit sasat megesiyek dye dut kenye, indyari nelimbenan ne ya et kunem. ");
INSERT INTO plw_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Sasat memegtetengteng dye nega dut langit, timinyeg megtuy na eset abiꞌ dye in duwang kelelekian megbebadyuꞌ et meputiꞌ. ");
INSERT INTO plw_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Kwan dye, “Mengeꞌ tawʼt Galilea, manu takuꞌ atuꞌ kew na megtitingaraꞌ dut langit? Periribuwat na si Jesus dut langit, atin megpeuliꞌ samat nebiriꞌ myu neng ya in neng periribuwat.” ");
INSERT INTO plw_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Negpeuliꞌ mengeꞌ bibilinan i Jesus dut lungsud et Jerusalem, mawaꞌ dut Bukid et mengeꞌ Puun et Olibo, na lengku mengeꞌ sembatu kilometro rayuꞌ et panew dye sabab atin lang rayuꞌ na pegtutugut mepenewan dye baꞌ Eldew et Kepeternan. ");
INSERT INTO plw_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Pegdateng dye eset kedyeng pegeeldengan eset lungsud in, neglahyun dye dut dibuwat sisingled. Itue mengeꞌ ingaran et mengeꞌ bibilinan negtimung duun: de Pedro, Juan, Jakob, Andres, Pelipe, Tomas, Bartolome, Mateo, bekeꞌ Jakob neng yegang i Alpeo, si Simon neng memimisara, bekeꞌ si Judas neng yegang i Jakob. ");
INSERT INTO plw_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Daran dye pemegbeꞌbayaꞌ megpenelang meglelamud mengeꞌ kelilibunan, bekeꞌ si Maria neng induꞌ i Jesus, sampay mengeꞌ ketipusdan i Jesus. ");
INSERT INTO plw_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Mekelabay mengeꞌ senung eldew, negtingtimung usa-usa mengeꞌ senggatus duwangpulung mengengandel. Indyari, timinyeg si Pedro eset elepan dye apang megpebunayag. ");
INSERT INTO plw_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Kwan ye, “Mengeꞌ ketipusdan, keilangang metuman itueng pegbersen atueʼt Kesuratan neng pegsugiren et Nakem et Empuꞌ pebiyaꞌ et beres i Surutan Dabid tagnaꞌ pasal ki Judas neng nenguna eset mengeꞌ nengalew ki Jesus. ");
INSERT INTO plw_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Sene tiꞌ, kebayaꞌ ya eset damen bekeꞌ kesembatu eset pegsukuꞌ key et pegpebunayag.” ");
INSERT INTO plw_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Itueng kebeyaran eset kenyeng pegakal, inelen i Judas et sembatung sukud neng lugtaꞌ. Atuꞌ ne ya nengurug, negbaꞌ et suwiꞌ, limimput kenyeng beteng bekeꞌ liminiwan kenyeng bituka. ");
INSERT INTO plw_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Nesewran itue et ginsan neng megeeldeng eset lungsud et Jerusalem, angkansa pesi pegngeranan uma na itue Akeldama eset kedyeng bebresan. Ingin bersen atin, Uma et Duguꞌ. ");
INSERT INTO plw_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Sinugid i Pedro, “Tiban, nekesurat dut Mengeꞌ Kanta, ‘Lahyunan lelegdengan ye ne pereyunan. Indyari dyangan ne legdengan et misan sinu nega.’ Nekesurat gasi, ‘Keredyanen neʼt iba in itueng kenyeng bubuwaten.’ ");
INSERT INTO plw_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Angkansa subaliꞌ kay memiliꞌ et sembatung meiba-iba kay bilang saksiꞌ dut pegkebiyag peuliꞌ i Jesus. Keilangan itue sembatung mengeꞌ mekebeꞌbayaꞌ damen et ginsang timpu na mekepemiyagan eset damen si Empung Jesus, tegnanan neng bewtismuan ya i Juan seked na iperibuwat dut langit.” ");
INSERT INTO plw_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Nemiliꞌ dye et duwang lelaki, si Matias bekeꞌ si Jose na pegngeranaʼt Barsabas bekeꞌ pegtingkagan gasiʼt Justo. ");
INSERT INTO plw_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Indyari dye in negpenalang, kwan, “Begerar, sewd myu na baꞌ enu dut seled pusuꞌ et ginsang taaw, ipekilelanaꞌ damen na baꞌ embe eset itueng duwa tuꞌ neng piniliꞌ mu, ");
INSERT INTO plw_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","apang megmendyaring bibilinan na metuman et keradya neng tinelikuran i Judas, ganang ya in siminurung dut lungsud na merapat eset kenye.” ");
INSERT INTO plw_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Nemegetgebutan dye ne, indyari si Matias mesukud. Ya key in nedugang dut sempuluꞌ isa neng bibilinan i Jesus. ");
INSERT INTO plw_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ganang diminateng ne Eldew neʼt Pentekostes, mengtingtimung ginsan neng mengengandel dut rungrupangan tiꞌ. ");
INSERT INTO plw_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Indyari megtuy nekingeg sembatung degurgur mewanaʼt langit meblan neʼt eriweswes et mebasag neng deres, siminled dut benwang pegrungrupungan dye tiꞌ bekeꞌ ginsang seled et benwa nekingeg atin. ");
INSERT INTO plw_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Maya nebiriꞌ dye samaʼt mengeꞌ dilep et apuy neng samat dilaꞌ baꞌ birinen. Liminatap mengeꞌ itue bekeꞌ nineug dut tegsembatu-sembatu et kedye. ");
INSERT INTO plw_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Pinenredan dye ginsan et Nakem et Empuꞌ. Angkansa, nemenagnaꞌ dye nemekebres et leing-leing bebresan et mengeꞌ menunumpang neng sigun et pinebres kedye et Empung Nakem. ");
INSERT INTO plw_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ating timpu, mekansang Judio neng mesinunuren et pegandel dye et Empuꞌ nemenumbaley gasi dut Jerusalem teyeg dut lein-leing lungsud dye. ");
INSERT INTO plw_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ganang nekingeg dye ating beres samat singgurung et mebasag neng deres nemengabiꞌ kineldaman et taaw. Nemegliluꞌ dye banar sabab nekingeg et ginsan neng taaw mengeꞌ pegsusugiren et mengeꞌ bibilinan dut kekenyeng bebresan. ");
INSERT INTO plw_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Kaya dye neretian itue sabab et pegliluꞌ dye. Sinugid dye, kwan, “Diki be mengeꞌ tawʼt Galilea ginsan neng lelaki neng megbebres? ");
INSERT INTO plw_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Enukwan takuꞌ itue? Mekekingeg tyu pegbersen dye et diri tyung bebresan. ");
INSERT INTO plw_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Kityu tuꞌ mengeꞌ tawʼt Partia, mengeꞌ tawʼt Media, mengeꞌ tawʼt Elam, na megeldeng eset probinsiya et Mesopotamia, dut Judea bekeꞌ eset Kapadosia, eset Ponto bekeꞌ dut probinsiya et Asia. ");
INSERT INTO plw_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Iba tyu atue mengeꞌ tawʼt Prigia, mengeꞌ tawʼt Pampilia, mengeꞌ tawʼt Egipto, sampay dut mengeꞌ sakup et Libya mekabiꞌ dut Sirene. Maya gasi kityu na mengeꞌ Judio banar bekeꞌ mengeꞌ taaw leing Judio neng nengandel et tulduꞌ tyu. Maya gasi sebarang mengeꞌ menunumpang na teyeg dut Roma. ");
INSERT INTO plw_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Maya taaw gasi neng teyeg dut pulew et Kreta bekeꞌ teyeg et bangsa et Arabia. Enukwan nekingeg tyu ginsan na megbebres dye et lein-leing bebresan tyu pasal et mengeꞌ keliluꞌlilung keradya et Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Sabab et pegliluꞌ dye neminan dye et pikir. Nemegingkut-ingkut dye, kwan, “Enu takuꞌ retian et itue?” ");
INSERT INTO plw_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Segwaꞌ sebarang iba in, pinesunguan dye ne neres, kwan, “Mengeꞌ langu lang atin!” ");
INSERT INTO plw_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Segwaꞌ timiniyeg si Pedro bekeꞌ sempuluꞌ isang bibilinan, bekeꞌ negberes et mebasag, kwan, “Mengeꞌ biꞌbilaꞌ ku neng tawʼt Judio, bekeꞌ ginsan kew neng mengeꞌ megeeldeng et lungsud et Jerusalem, kinggaꞌ myu et menunga dakeng bersen apang mesewran myu. ");
INSERT INTO plw_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Kaya melangu itueng mengeꞌ taaw, na samat pegpikiren myu, sabab atin peꞌ lisag siyam et meriklem. ");
INSERT INTO plw_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Erapun, atin peꞌ netuman ne tiban itueng pegsugiren i Joel na tarus tagnaꞌ, kwan: ");
INSERT INTO plw_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Kwan et Empuꞌ, Meinabu eset mengeꞌ emuring eldew buwaten ku itue. Begeyan ku et Dakeng Nakem apang sumled dut ginsan neng taaw. Indyari megpebunayag dimyung mengeꞌ yegang, libun lelaki, bebresen Ku; bekeꞌ mekebiriꞌ et mengeꞌ terebinbinen teyeg daken dimyung mengeꞌ kesuburan, indyari maya meteginep teyeg Daken dimyung kelelekian neng umuran. ");
INSERT INTO plw_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Dut mengeꞌ eldew na atin peseleran Ku gasi et Nakem Ku eset Dakeng mengeꞌ tetehagen neng kelelekian bekeꞌ kelilibunan, indyari megpebunayag dye bebresen Ku. ");
INSERT INTO plw_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Megpepebiriꞌ ku et mengeꞌ keliꞌliluꞌ dut dibuwat langit, bekeꞌ mengeꞌ tendaꞌ atuʼt lugtaꞌ samat kwantin: duguꞌ, apuy, bekeꞌ mekapal neng tabuk. ");
INSERT INTO plw_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Lumingeb eldew, indyari rumegang samat duguꞌ bulan mura dumateng Eldew et Empuꞌ, ating metaas bekeꞌ bantug naꞌ eldew. ");
INSERT INTO plw_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Indyari sebarang taaw neng tumeew Daken apang meingesian Ku, atin mengeꞌ taaw mebawiꞌ et pegukum Ku.’ ” ");
INSERT INTO plw_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Pelahyun binres i Pedro, kwan ye, “Mengeꞌ tawʼt Israelita, kinggen myu itue. Itueng si Jesus neng tawʼt Nasaret, Ya in tinahag et Empuꞌ. Pegpesebenaran itue et mengeꞌ keliluꞌlilung kebesagan bekeꞌ mengeꞌ keknad-eknad, bekeꞌ mengeꞌ tendaꞌ na binuwat et Empuꞌ pebiyaꞌ Ye. Sewd myu itue sabab ginsan in neinabu ne dimyu. ");
INSERT INTO plw_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Segwaꞌ itueng si Jesus na isinabar eset dimyu kuyun dut gaay bekeꞌ pegsewd lagi et Empuꞌ dut sengketegnanan nega, atin ipineransang myu dut krus et kayu bekeꞌ ipinepatey eset mengeꞌ mekeselaan. ");
INSERT INTO plw_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Segwaꞌ ya in binyag peuliꞌ et Empuꞌ, bekeꞌ pinelayam eset kepengyedian et kemeteyan. Sabab kepeteyan diki mekedyari tumerna eset kenye. ");
INSERT INTO plw_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Samat sinugid i Surutan Dabid tagnaꞌ pasal ki Jesus, kwan, ‘Nebiriꞌ ku na daran eset abiꞌ ku Empuꞌ, Ya in iba ku angkansa diki ku meparu. ");
INSERT INTO plw_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Sabab ituꞌ nenep dakeng pusuꞌ, bekeꞌ melami na negkanta daken neng dilaꞌ dimu, pegketbes petetaren bilug ku sabab maya pegarap. ");
INSERT INTO plw_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Sabab diki Mu Empuꞌ mepesaran kurudua ku tuꞌ dut dunyaʼt mengeꞌ patey, bekeꞌ diki Mu itugut na muruk dut lebeng ating Pasek Metignang Memegsukuꞌ Mu. ");
INSERT INTO plw_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Tinulduꞌ mu eset daken mengeꞌ dalan surung dut biyag, sabab et Ikew iba ku, aku tuꞌ apew-apew et keenepan.’ ” ");
INSERT INTO plw_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Pelahyun binres i Pedro, kwan ye, “Mengeꞌ sebayaꞌ ku, mesugid ku eset dimyu neng tantu na kegunggurangan tyu neng si Surutan Dabid natey pegketbes linebeng, atue negaʼt kityu kenyeng lebeng seked tiban. ");
INSERT INTO plw_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Segwaꞌ sabab tarus gasi si Dabid, nesewran ye tinangeꞌ et Empuꞌ kenye na megmendyaring surutan samat kenye in sembatung kenyeng mengeꞌ keupuan. ");
INSERT INTO plw_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Na nebiriꞌ yeng lagiꞌ bekeꞌ nenarus i Surutan Dabid tagnaꞌ pasal et keredyanen et Empuꞌ, na ipebiyag ye peuliꞌ ating Mesias neng si Kristo, sabab bineres ye, ‘Na kaya pinesaran ya in eset Narkaꞌ, atin dunyaꞌ et mengeꞌ patey, bekeꞌ kaya tinugut na muruk kenyeng bilug dut lebeng.’ ");
INSERT INTO plw_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“Si Jesus in ating Mesias, sabab ya in binyag peuliꞌ et Empuꞌ. Indyari kaming ginsan saksiꞌ et kenyeng pegbiyag peuliꞌ. ");
INSERT INTO plw_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ganang iperibuwat ya eset kewanan et Empuꞌ, tinerima ye eset kenyeng Amaꞌ tinangeꞌ et Nakem et Empuꞌ, pegketbes binggey ye eset damen itueng Nakem et Empuꞌ, samat nebiriꞌ bekeꞌ nekingeg myu tiban na ating begey ye mepebunayag eset kityu. ");
INSERT INTO plw_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Kaya diminibuwat dut langit si Surutan Dabid, erapun ya key negsugid, ‘Negberes Begerar Empuꞌ dut dakeng Empuꞌ, marung ke eset dakeng tampaꞌ kewanan, ");
INSERT INTO plw_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","seked na tantung mepesukuꞌ ku dimyu itueng mengeꞌ kebanta mu.’ ");
INSERT INTO plw_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Angkansa subaliꞌ myu mesewran, ginsang tawʼt Israel, na itueng si Jesus ne rinansang myu dut krus, Ya ne tuꞌ binwat et Empuꞌ na Begerar na Mesias, ingin bersen, si Kristo!” ");
INSERT INTO plw_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nesusa banar kedyeng pikiran ganang mekingeg itue, indyari iningkut dye si Pedro bekeꞌ ibang mengeꞌ bibilinan, kwan dye, “Mengeꞌ ketipusdan, enu ne dameng buwaten?” ");
INSERT INTO plw_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Siminambag si Pedro, kwan, “Pegsusunan myu ginsan bekeꞌ telikuran itueng dimyung mengeꞌ keselaan, indyari megpebewtismu kew samat mengengandel i Jesus Kristo apang kemyu tuꞌ empunen. Pegketbes tumerima myu begey et Empuꞌ, ating Nakem et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Sabab itueng tangeꞌ et Empuꞌ tudyu eset dimyu bekeꞌ eset dimyung mengeꞌ yegang, bekeꞌ dut ginsan neng mereꞌrayuꞌ, dut kede agitan et Begerar naꞌ Empuꞌ tyu.” ");
INSERT INTO plw_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Mekansang nega tinuturan i Pedro apang pesebenaran itueng kenyeng sinugid, indyari negpesewd ya eset kedye, “Pereyuniꞌ myu itueng belingkeg neng taaw tiban apang kemyu in mebawiꞌ et Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Angkansa sebarang nengandel eset kenyeng sinugid in negpebewtismu. Ating eldew telung ribung ketawan ne nekedugang kedye neng mengeꞌ mengengandel. ");
INSERT INTO plw_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Indyari negpelembus dye eenaran et penenulduꞌ et mengeꞌ bibilinan in, bekeꞌ nemegbeꞌbayaꞌ dye samat memegtitipused dut pegpukputek et bengbang bilang keredeman et kemeteyan i Jesus sampay dut pegpenelang. ");
INSERT INTO plw_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Sabab dut mekansang neng keliꞌliluꞌ bekeꞌ tendaꞌ nebuwat pebiyaꞌ eset mengeꞌ bibilinan, negmilik eset ginsan meglelamud nunga bekeꞌ takut. ");
INSERT INTO plw_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Indyari negbeꞌbayaꞌ ginsan neng mengengandel bekeꞌ pinegbulun dut ginsan kedyeng pengarta. ");
INSERT INTO plw_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Pinegelen dye itueng lugtaꞌ bekeꞌ pengartaꞌ dye, indyari pinegelnan pegbenbeginen dut ginsan kuyun eset pengengeilangan et kede sembatu. ");
INSERT INTO plw_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Eldew-peldew dye in pemegtingtimung dut pengempuan naꞌ benwa neng Templo. Pemegbisbitas et bengbang dut kedyeng benwa, bekeꞌ pemegsesaru na mesegya seled pusuꞌ. ");
INSERT INTO plw_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Pemegbebantug dye dut Empuꞌ bekeꞌ pegesipan dye et ginsang taaw. Kede eldew pegdugangan et Empuꞌ dut kedyeng ketimungan sebarang mengeꞌ mebawiꞌ et mengeꞌ keselaan dye. ");
INSERT INTO plw_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Kasa in dut mengeꞌ lisag telu et mapun, siminurung dut Pengempuan naꞌ Benwa neng Templo de Pedro bekeꞌ si Juan sabab timpu itie et megpenelang. ");
INSERT INTO plw_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Eset mekabiꞌ lelengewang neng pegngeranan et Meayad, maya sembatung lelaki naꞌ pangkul ne lagi sengkeganak. Ya in pegbibiten esentin eldew-peldew apang meneew et pirak dut mengeꞌ megseled dut Benwa Pengempuan naꞌ Templo. ");
INSERT INTO plw_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ganang mebiriꞌ ye de Pedro bekeꞌ si Juan sumled ne dut Pengempuan naꞌ Benwa, ya in neneew et siin. ");
INSERT INTO plw_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Tinengtengan ya et duwa in, indyari sinugiran ya i Pedro, kwan, “Sumiyek ke damen!” ");
INSERT INTO plw_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Siminyek ne ya in kedye, pemikir ye begeyan ne ya et siin in. ");
INSERT INTO plw_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Segwaꞌ sinugid i Pedro kenye, kwan, “Kaya pirak ku etawa bulawan, temed erapun maya ibgey ku dimu. Dut kepengdyarian i Jesus Kristong tawʼt Nasaret, kepanew ke.” ");
INSERT INTO plw_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Kineptan ye eset kewanan keremut itueng pangkul mura timinyeg. Pegketbes nasag sekaliꞌ mengeꞌ tiked bubukuꞌ et lelaki. ");
INSERT INTO plw_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Limineksut ya in bekeꞌ timinagnaꞌ nanew. Peleksut-leksut ya megseled dut Pengempuan naꞌ Benwa megbebayaꞌ dye, bekeꞌ mesegyang megbebantug dut Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Nebiriꞌ et ginsan na ya in megpewpanew bekeꞌ megbebantug dut Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Negliluꞌ dye banar sabab et neinabu kenye ganang nekilala dye nayaꞌ ya neng miskin sene tiꞌ megearung bekeꞌ meneew et siin dut Meayad neng Lelengewan et Pengempuan na Benwa. ");
INSERT INTO plw_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Sasat megekpet ya kire Pedro bekeꞌ ki Juan eset bagiꞌ na Templo neng sarimbar pegneranaʼt Portiko i Solomon, memegderarak na memegkekabiꞌ eset kedye mengeꞌ taaw na nemegliluꞌ eset neinabu. ");
INSERT INTO plw_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pegkebiriꞌ i Pedro eset mengeꞌ taaw, pinegberes ye kedye, kwan, “Mengeꞌ tawʼt Israelita, manu angkan takuꞌ negliluꞌ kew eset neinabung itue? Manu takuꞌ angkan pegsiyekan myu kami et kwantin? Keblan myu takuꞌ pinepanew kay ya pebiyaʼt dameng diring kepengyedian etawa lengku sabab et dameng pasek ketignaan? ");
INSERT INTO plw_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Diki, erapun itueng Empuꞌ et kityung keupuꞌupuan, de Abraham, Isaak bekeꞌ i Jakob, Ya in nenggey et pinekemetaas et kebentugan eset Kenyeng Dedeakan neng si Jesus pebiyaꞌ itueng negulian. Segwaꞌ Ya in binggey myu dut kepengyedian apang imeteyen bekeꞌ pineilu eset teyumanan i Gobernador Pilato, na inukuman ye na ipelayam ne Ya in. ");
INSERT INTO plw_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ya in pasek metignaꞌ bekeꞌ mebentel, segwaꞌ negmendiꞌ kew nega Kenye, bekeꞌ misan ga atin, tineew myu nega sembatung taaw na memematey atin key ipelayam. ");
INSERT INTO plw_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Pinatey myu pegmewanan et biyag, segwaꞌ Ya in biniyag peuliꞌ et Empuꞌ, indyari saksiꞌ kay et itueng neinabu. ");
INSERT INTO plw_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Itueng kepengyedian i Jesus sampay pegandel kenye nepekseg eset lelaking itue na kebiriꞌ bekeꞌ kilala myu. Neinabu itue sabab et pegpengandel kay ki Jesus. Itueng pegpengandel ki Jesus na tantung nekepegulin ginsan eset kenye samat dimyung ginsan mekebiriꞌ in. ");
INSERT INTO plw_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Indyari tiban mengeꞌ ketipusdan, sewd ku na dut pegimatey ki Jesus kaya nesewran myu dimyung pegbuwaten, megsepantun kwantin gasi dimyung mengeꞌ pegibuten. ");
INSERT INTO plw_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Segwaꞌ eset binwat myu netuman ne itueng nekwit neng pegpepebunayag et Empuꞌ eset pebiyaʼt mengeꞌ tarus Ye tagnaꞌ, kwan, na si Kristo neng Mememawiꞌ keilangan metiksaꞌ sampay imeteyen. ");
INSERT INTO plw_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Angkansa megsusun kew ne bekeꞌ peuliꞌ mengandel dut Empuꞌ apang ugaren ye dimyung mengeꞌ keselaan. Indyari begeyan kew et Empuꞌ mengeꞌ timpu et kepeternan teyeg et elepan et Begerar. ");
INSERT INTO plw_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Indyari tehagen gasi et Empuꞌ si Jesus, itueng Mesias na binwat ye tudyu eset dimyu. ");
INSERT INTO plw_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ya in subaliꞌ tumerna mena dut lelegdengan et Empuꞌ seked dumateng timpu et pegbebagu et ginsan neng ginis, kuyun eset pinebunayag et Empuꞌ pebiyaꞌ et mengeꞌ metignaꞌ neng tarus ye mewanan nega sene tiꞌ. ");
INSERT INTO plw_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Supama, sinugid i Moises, ‘Memiliꞌ Begerar neng Empuꞌ et sembatung keduguꞌ myu bekeꞌ buwateng tarus samat daken. Kinggen myu ginsan neng bersen ye dimyu. ");
INSERT INTO plw_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Indyari ginsan neng diki kumingeg eset tarus na atin ipeseriri dut mengeꞌ taaw et Empuꞌ pegketbes binesanen.’ ” ");
INSERT INTO plw_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Sinugid nega i Pedro, kwan, “Asal negpebunayag gasi pasal eset mengeꞌ eldew na itue na ating mengeꞌ tarus, tinegnanan ki Samuel bekeꞌ ginsang sumunud eset kenye. ");
INSERT INTO plw_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Mengeꞌ tinangeꞌ et Empuꞌ pebiyaꞌ et mengeꞌ tarus Ye tudyu eset dimyu eset pinegsulutan binuwat et Empuꞌ bekeꞌ dimyung keupuꞌupuan. Sabab binres Empuꞌ ki Abraham, kwan, ‘Ipenunga ku ginsan neng taaw eset dunyaꞌ pebiyaꞌ et dimyung tungtung-inupuꞌ.’ ");
INSERT INTO plw_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","“Angkansa pinebiyag peuliꞌ et Empuꞌ itueng Kenyeng Dedeakan neng Mesias, indyari Ya in tinahag eset dimyung mengeꞌ tawʼt Judio una-una et ginsan apang ipenunga kew bekeꞌ tebangan tumelikud eset dimyung meraat neng pengebiyagan.” ");
INSERT INTO plw_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ganang megebres nega de Pedro bekeꞌ si Juan dut mengeꞌ taaw, pegdateng mengeꞌ pariꞌ sampay kapitan et mengeꞌ mengdidyaga eset Pengempuan naꞌ Benwa bekeꞌ mengeꞌ Saduseo. ");
INSERT INTO plw_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Megiiseg dye ne banar eset duwang bibilinan in sabab pegpebunayag dye eset mengeꞌ taaw na si Jesus tuꞌ negbiyag peuliꞌ, na itue kebenaran megbiyag peuliꞌ mengeꞌ patey. ");
INSERT INTO plw_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Angkansa inalew dye duwa in, segwaꞌ kinulung menaʼt pipirisuan seked kinedikleman, sabab atin neng masa gebi peꞌ. ");
INSERT INTO plw_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Segwaꞌ megsepantun kwantin, mekansang nekekingeg et kedyeng penulduꞌ eset megpengandel ki Jesus, indyari nekeapet limang ribu itungan et mengeꞌ kelelekian na megpengandel. ");
INSERT INTO plw_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Kinedikleman nemegtimung dut lungsud et Jerusalem mengeꞌ pegibuten et mengeꞌ Judio, iba dye mengeꞌ megurang et bangsa bekeꞌ mengeꞌ menunulduꞌ et Keseraan binggey ki Moises. ");
INSERT INTO plw_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Kebayaꞌ dye de Anas na pinekepegibuten et pariꞌ, sampay de Kaipas, de Juan, de Alejandro bekeꞌ ginsang keusbaan neng metaas na pariꞌ. ");
INSERT INTO plw_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Pineelep dye si Pedro bekeꞌ si Juan bekeꞌ iningkut, kwan, “Dut enung kepengyedian etawa sinu negey dimyu et kepegbeꞌbayaꞌ pegbuwaten neng keulinen itue?” ");
INSERT INTO plw_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Siminambag si Pedro na lulus et Nakem et Empuꞌ, kwan ye, “Mengeꞌ pegibuten bekeꞌ mengeꞌ megurang et mengeꞌ taw, ");
INSERT INTO plw_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","na baꞌ pegingkuten mu kami tiban pasal eset kenunganan kay eset pangkul na itue bekeꞌ baꞌ enukwan ya negulinan, ");
INSERT INTO plw_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","sewraꞌ myu ginsan bekeꞌ ginsang tawʼt Israel na itueng taaw megetiyeg eset dimyung teyumanan na tantung negulinan ne sabab dut kepengyedian i Jesus Kristong tawʼt Nasaret. Ya in dimyung pineransang dut krus, segwaꞌ binyag ya peuliꞌ et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Si Jesus ne tuꞌ pesalan et sinurat et Empuꞌ dut Kesuratan tagnaꞌ tiꞌ, kwan, ‘Itueng batu na minendinan myu na tegepetiyeg et benwa, na ya ne negmendyaring batung penued.’ ");
INSERT INTO plw_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","“Sabab eset sirung et langit atueʼt dunyaꞌ, maya sembatu lang na binggey et Empuꞌ eset mekebawiꞌ et taaw, na ngaran Ye si Jesus Kristo.” ");
INSERT INTO plw_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Negliluꞌ mengeꞌ pegibuten et tawʼt Kekunsialan neng Sanedrin eset keureman pinebiriꞌ de Pedro bekeꞌ i Juan. Lebi ne ganang mesewran dye na mengeꞌ bibilinan itue taaw lang, masi kaya nega pinegiskulan, nesewran dye ne ating kesewran bekeꞌ ketuwakalan i Pedro bekeꞌ i Juan sabab na neiba-iba dye i Jesus sasat biyag Ya nega in. ");
INSERT INTO plw_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Indyari ganang mebiriꞌ dye itueng taaw neng pinegulinan na megetiyeg eset abiꞌ dye, kaya nemekebres atu eset kedye in. ");
INSERT INTO plw_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Angkansa pineliwan mena eset pinegtimungan et Kekunsialan neng Sanedrin mengeꞌ bibilinan sampay taaw neng pinegulinan, mura nemegsudsugid mengeꞌ pegibuten, kwan, ");
INSERT INTO plw_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Enu buwaten tyu eset mengeꞌ taaw tuꞌ?” ingkut dye. “Sabab sewd neʼt ginsang tawʼt lungsud et Jerusalem bekeꞌ diki tyu mepeilu na sembatung keliꞌliluꞌ neinabu pebiyaʼt kedye tuꞌ. ");
INSERT INTO plw_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Apang diki ne itue mepelatun-latun, dyenganen tyu ne dye na endey dye isudsugid dut misan sinu pasal eset ingarang i Jesus.” ");
INSERT INTO plw_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Angkansa pinetingkag dye peuliꞌ de Pedro, bekeꞌ sinugiran na dyangan ne megbesberes etawa menulduꞌ nega pasal et ingaran i Jesus. ");
INSERT INTO plw_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Segwaꞌ siminambag de Pedro bekeꞌ si Juan, kwan, “Kemyu ne mengukum baꞌ embe mebentel dut penyek et Empuꞌ, na menelinga eset dimyu etawa sumunud ki Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Sabab diki mekedyari kay na diki menabar neng dameng nebiriꞌ bekeꞌ nekingeg.” ");
INSERT INTO plw_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Indyari lebi ne ating binresan dye, mura dye pinepanew. Kaya mebirinan dye et kebelingkegan apang medusaan itueng duwa, sabab megbebantug et Empuꞌ ginsan mengeꞌ taaw sabab et keliluꞌlilung tendaꞌ na neinabu. ");
INSERT INTO plw_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Sabab itueng lelaking pinegulinan dye lebi ne epat neng puluꞌ teun ne umur ye. ");
INSERT INTO plw_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ganang nepelayam ne de Pedro bekeꞌ si Juan, siminurung dye ne dut mengeꞌ kesebeyaan dye neng mengengandel, indyari sinugid dye ne itueng bineres et mengeꞌ pegibuteʼt pariꞌ bekeꞌ mengeꞌ megurang et bangsa. ");
INSERT INTO plw_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ganang mekingeg itue, negbeꞌbayaꞌ dye negpenalang dut Empuꞌ. Sinugiran dye, “Pineketaas neng Begerar, ginuna mu et langit bekeꞌ lugtaꞌ, sampay dagat bekeꞌ ginsang ginisan esentin. ");
INSERT INTO plw_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Kemyu negberes pebiyaꞌ eset Pasek Metignaꞌ neng Nakem Mu ganang negsugid dameng keupuꞌupuang si Surutan Dabid na dimyung dereakan, kwan, ‘Manu takuꞌ kelang iseg et mengeꞌ lein Judio sagkaꞌ Empuꞌ? Manu takuꞌ megbahum mengeꞌ taaw neng kaya kepulusan? ");
INSERT INTO plw_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Nekepanyap mengatu mengeꞌ surutan eset dunyaꞌ, indyari negtingtimung mengeꞌ pegibuten atu eset Begerar Empuꞌ bekeꞌ ating Piniliꞌ Ye neng memegbeg et ginsan. Ya ne si Kristo.’ ");
INSERT INTO plw_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Na banar neinbu ating Kesuratan sabab negmegtimung dut lungsud ne itue de Surutan Herodes bekeꞌ de Gobernador Ponsio Pilato, kebayaꞌ mengeꞌ lein Judio bekeꞌ ginsang tawʼt Israel, apang megbahum atu eset dimyung pasek metignaꞌ neng dedeakan na si Jesus, Ya in pineyran mu et lana apang memegbeg. ");
INSERT INTO plw_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Tinuman dye ginsan neng ginisan neng merapat buwaten neng binetang mu sene nega tiꞌ pasal et kebegbesagan mu. ");
INSERT INTO plw_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Indyari tiban Begerar, kinggen Mu baꞌ enu mengeꞌ pegsesenggupan dye kami. Tebangan Mu dimung mengengeradya na mekepengabar et mepangger eset dimung beres. ");
INSERT INTO plw_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Iktangaꞌ dimung lengen et kebesagan apang mekepegulin kay et mengeꞌ sakit bekeꞌ mekebuwat kay et mengeꞌ keliliꞌlilung tendaꞌ sampay mengeꞌ ibang keliꞌliluꞌ pebiyaꞌ dimung pasek metignaꞌ neng dedeakan na si Jesus.” ");
INSERT INTO plw_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Pegketbes dye megpenelang, yiminegyeg et pegtingtimungan dye. Ginsan dye in sinleran ne et Nakem et Empuꞌ bekeꞌ mepangger na mengabar et bebresen i Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Negsembatu seled pusuꞌ bekeꞌ seled pikiran et ginsang mengengandel, indyari kaya dye pegpikiren et misan sinu na diri ye lang pengartaꞌ ye, imbes atin kedyeng ginsan. ");
INSERT INTO plw_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Pelahyun pegpesebanar et kelang kepengyedian mengeꞌ bibilinan eset pegbiyag peuliꞌ et Begerar Jesus. Indyari pegbegey banar et Empuꞌ kenyeng redyikiꞌ eset kedyeng ginsan. ");
INSERT INTO plw_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kaya kekurangan eset kedye, sabab sinu-sinu kedye ne maya lugtaꞌ etawa mengeꞌ benwa, indyari itieng pinegelnan dye. ");
INSERT INTO plw_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Atin pirak pegbegey dye dut keptan eset mengeꞌ bibilinan. Pegbenbeginen gasi itue kuyun dut pengengeilangan et kede sembatu. ");
INSERT INTO plw_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Supama, maya taaw ngaran ye si Jose. Ya sembatung tawʼt Lebitang pinengganak et pulew et Siprus. Kwantin binuwat i Jose, angkansa peningkag eset kenye Bernabe et mengeꞌ bibilinan, gay bersen, “Pengimuyuk etawa Metinebangen”. ");
INSERT INTO plw_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Pinegelen ye kenyeng uma, pegketbes binggey eset mengeꞌ bibilinan itueng pinegelnan tiꞌ. ");
INSERT INTO plw_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Segwaꞌ, maya memegesawa na negpeelen gasi et lugtaꞌ. Si Ananias ingaran et lelaki in, libun in si Sapira. ");
INSERT INTO plw_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Indyari kinurangan i Ananias itieng pinegelnan in, na sewd gasi et kenyeng esawa, pegketbes binggeyan ye gasi itieng dut keptan et mengeꞌ bibilinan in et behagiꞌ. ");
INSERT INTO plw_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Angkansa sinugid i Pedro, “Ananias, manu takuꞌ angkan pineselban ke i Seytan, indyari nengakal ke ki Nakem et Empuꞌ? Manu takuꞌ angkan kinurangan itieng pinegelnan et lugta bekeꞌ akalen mu na ikew ibgey ginsan neng pirak dut Empuꞌ? ");
INSERT INTO plw_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Sasat kayangga peꞌ pinegelen lugtaꞌ in, diki be takuꞌ dimu atin? Indyari ganang nepegelen, diki be dimu itieng nepegelnan? Manu tegahaꞌ nepikiran mu kurangan atin? Lein dut taaw ke nengakal erapun eset Empuꞌ ke key nengakal.” ");
INSERT INTO plw_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ganang nekingeg itue i Ananias, ya in patey ne negbaꞌ, indyari ginsan neng nekekingeg eset neinabung itue in sinleran et kelang takut. ");
INSERT INTO plw_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Indyari timinyeg mengeꞌ kesuburan, binulungan bangkay in, pegketbes binibit dye ya dut liwan, indyari linebeng. ");
INSERT INTO plw_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Pegketalib et mengeꞌ telung kelisagan, diminateng kenyeng esawa si Sapira, segwaꞌ kaya penedsewd eset neinabu. ");
INSERT INTO plw_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Megtuy nengingkut si Pedro eset kenye, kwan, “Isugiraꞌ be daken baꞌ itue ga pinegelnan et lugtaꞌ myu in?” Sambag ye, “Eꞌ be, atin ga be.” ");
INSERT INTO plw_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Angkansa sinugid kenye i Pedro, “Manu takuꞌ pinegsembetuan myu sulayan itieng Nakem et Begerar? Birinaꞌ! Atin eset lelengewan ne itieng mengeꞌ nenglebeng eset dimyung esawa, indyari ikew gasi tiban bibiten dye dut liwan.” ");
INSERT INTO plw_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Megtuy negbaꞌ si Sapira eset titikeran i Pedro pegketbes natey. Pegseled et mengeꞌ kesuburan, nebiriꞌ dye na patey ne ya. Angkansa binibit dye gasi bangkay ye bekeꞌ ilimbeng dye eset abit lebeng et esawa ye. ");
INSERT INTO plw_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Nemeketakut et kelaꞌ ginsang tawʼt mengengandel in bekeꞌ ginsang nemekeabar in pasal et itueng neinabu. ");
INSERT INTO plw_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Mekansang mengeꞌ tendaꞌ bekeꞌ keliꞌliluꞌ binuwat mengeꞌ bibilinan dut pinegtengaan et mengeꞌ taaw. Nemegtingtimung dut Portiko i Surutan Solomon ginsan neng mengengandel in. ");
INSERT INTO plw_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Kaya misan sembatu et mengeꞌ kaya pemengandel in nememayaꞌ eset kedye sabab et takut, misan ne inesipan dye et mengeꞌ taaw. ");
INSERT INTO plw_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Segwaꞌ pekansang neng pekansang itueng mengeꞌ kelelekian bekeꞌ kelilibunan pemengandel dut Empuꞌ sampay nayaꞌ kedye. ");
INSERT INTO plw_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Sabab et ginsaʼt binwat et mengeꞌ bibilinan, binibit dut mengeꞌ dalan mengeꞌ tegesakit indyari pinengdatun eset mengeꞌ degdatag bekeꞌ demdam, apang pegtalib i Pedro mesugat et kenyeng eninu eset misan mengeꞌ senu mene eset kedye in bekeꞌ megnunga dye ne. ");
INSERT INTO plw_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Indyari diminateng gasi mekansang taaw mawaꞌ dut mengeꞌ kebebenwanan dut pelibut-libut et lungsud et Jerusalem, pegbibiten kedyeng mengeꞌ tegesakit bekeꞌ misan sinleban na pepeliyutan et meyaat neng diwata, indyari dyeng ginsan pinegulinan. ");
INSERT INTO plw_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Angkansa megimbeng ne gasi Pinekepegibuteng Pariꞌ bekeꞌ mengeꞌ kesebeyaan ye na kebayaꞌ eset rupungaʼt mengeꞌ Saduseo. Pikiren dye ne keilangan maya buwaten dye atu de Pedro. ");
INSERT INTO plw_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Inalew dye mengeꞌ bibilinan pegketbes pinepirisu. ");
INSERT INTO plw_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Segwaꞌ pegkegebi inukaban et dereakan et Begerar pipirisuan pegketbes pineliwan mengeꞌ bibilinan. Sinugid ye kedye, kwan, ");
INSERT INTO plw_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Sumurung kew dut Pengempuan naꞌ Benwa neng Templo, indyari menulduꞌ pasal et bagung pemimiyag ne itue.” ");
INSERT INTO plw_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Nenelinga gasi mengeꞌ bibilinan, angkansa megkukueldew ne diminuntin dye samat netahagan dye dut Pengempuan naꞌ Benwa, pegketbes nenulduꞌ dyeʼt mengeꞌ taaw duntin. Ganang diminateng Pinekepegibuten et Pariꞌ bekeꞌ kedyeng mengeꞌ kesebeyaan, tiningkag dye ginsan neng meumur eset bangsa et Israel dut pegrupung et ginsang tawʼt Kekunsialan neng Sanedrin. Pineisiꞌ dye dut pipirisuan mengeꞌ bibilinan. ");
INSERT INTO plw_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Segwaꞌ pegdateng duntin et mengeꞌ mengdidyaga in, kaya dye ne esentin. Angkansa negpeuliꞌ dye ne dut kelang benwa et Sanedrin, indyari kwantin penuturan, ");
INSERT INTO plw_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Nebiriꞌ kay nekekunsiꞌ et menunga itueng pipirisuan indyari megetiyeg mengdidyaga in dut lelengewan. Segwaꞌ ganang ukaban kay ne, kaya ne taaw nebiriꞌ kay dut seled!” ");
INSERT INTO plw_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ganang mekingeg itue, nelipeng mengeꞌ pegibuteng pariꞌ bekeꞌ kapitan et mengdidyaga eset Pengempuan naꞌ Benwa, bekeꞌ diki mesewran dye pikiran na baꞌ enu neinabu eset mengeꞌ bibilinan. ");
INSERT INTO plw_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Segwaꞌ maya diminateng bekeꞌ negsugid eset kedye, kwan, “Birinaꞌ! Itueng mengeꞌ kelelekiang pinirisu myu in, duun dye neʼt Templo pemunulduꞌ eset mengeꞌ taaw.” ");
INSERT INTO plw_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Angkansa itieng kapitan siminurung dut Pengempuan naꞌ Benwa, kebayaꞌ kenyeng mengeꞌ tindeg. Nepebayaꞌ dye, segwaꞌ diki dye nengleges sabab metakut dye ne kaluꞌ dye in bekalen et mengeꞌ taaw. ");
INSERT INTO plw_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Pineelep dye dut tawʼt Kekunsialan neng Sanedrin itueng mengeꞌ bibilinan, indyari inukum et pinekemetaas neng pariꞌ. ");
INSERT INTO plw_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Kwan ye, “Asiꞌasiꞌ banar kaya ne tinugutan kay kemyu mengabar dut ingaran na itue, erapun birinaꞌ myu be dimyung binuwat! Latap ne eset ginsaʼt lungsud et Jerusalem dimyung penulduꞌ, indyari gaay myu nega kami negkesalaꞌ eset pegkepatey et taaw ne atin!” ");
INSERT INTO plw_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Segwaꞌ siminambag si Pedro bekeꞌ ibang mengeꞌ bibilinan in, kwan, “Itieng Empuꞌ key subaliꞌ kay endelen, lein itieng taaw! ");
INSERT INTO plw_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Empuꞌ neng kityung keupuꞌupuan na nemiyag peuliꞌ ki Jesus neng pinatey myu in neng pineransang myu dut krus neng usuk. ");
INSERT INTO plw_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Pegketbes pineribuwat ya et Empuꞌ dut kenyeng kewanan apang Mekepenguna bekeꞌ Mememawiꞌ, apang begeyan et Empuꞌ mengeꞌ tawʼt Israelita na lawak apang megsusun ampaꞌ empunen et kedyeng keselaan. ");
INSERT INTO plw_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Saksiꞌ kay eset mengeꞌ keginisan neng itue, kami bekeꞌ Nakem et Empuꞌ neng pinebayaꞌ et Empuꞌ eset mengeꞌ pengandel dut Kenye.” ");
INSERT INTO plw_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ganang mekingeg itue, megkekek neʼt iseg mengeꞌ pegibuteng metetaas et Kekunsialan neng Sanedrin, indyari gaay dye ne ipepatey mengeꞌ bibilinan. ");
INSERT INTO plw_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Segwaꞌ timinyeg sembatung Pariseong megngengaran et Gamaliel na tegepegtulduꞌ et Keseraan et egama bekeꞌ peguntebien et ginsang taaw. Tinahag ye ipeliwan mena diki mekwit-kwit mengeꞌ bibilinan. ");
INSERT INTO plw_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Indyari negberes dut mengeꞌ metetaas, kwan, “Tawʼt Israelita, inget kew na menalaꞌ eset mengeꞌ taaw ne itue. ");
INSERT INTO plw_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Kayangga peꞌ nekwit pegsebut et pebibelung si Teudas, na ya in kunuꞌ sembatung metaas neng pegibuten, nekeakit et epat neng gatus ne taaw na lumamud kenye. Segwaꞌ ganang natey ga in, nemegpekparak na ginsan ating mengeꞌ netulduan ye in, indyari netbes lang et kaya misan nepulusan. ");
INSERT INTO plw_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Pegketbes, simimbut gasi si Judas neng tawʼt Galilea, na ating masa tempuʼt pegpepelista, indyari nekeakit gasi et mekansang neng taaw. Ganang ya in natey ne gasi, nemegpekparak gasi ating mengeꞌ taaw siminunud kenye. ");
INSERT INTO plw_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Angkansa pegsugiren ku dimyu, dyangan myu penglemuran mengeꞌ taaw ne itue, pesariꞌ myu dye! Na baꞌ pegbebehumen dye etawa pegegeesen dye tuꞌ mawaꞌ dut taaw, dye in meraag. ");
INSERT INTO plw_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Segwaꞌ na baꞌ mawaꞌ dut Empuꞌ, diki myu itue mebelebagan bekeꞌ tumbuꞌ nega na pegsegkaan myu Empuꞌ!” ");
INSERT INTO plw_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Nenelinga dye eset penulduꞌ i Gamaliel. Pinesled gasi peuliꞌ mengeꞌ bibilinan, indyari pegketbes pinukul dye bekeꞌ bulagen mengabar pasal et kepengyedian i Jesus. Indyari dye in pinelayam. ");
INSERT INTO plw_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Megeenep na nemengugad itieng mengeꞌ bibilinan eset elepaʼt Sanedrin, sabab ginaay et Empuꞌ, sabab dye in mepebetang eset kelelewan alang-alang dut pengandel dye ki Jesus. ");
INSERT INTO plw_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Indyari eldew-peldew megsurung dye dut Pengempuan naꞌ Benwa neng Templo bekeꞌ dut mengeꞌ kebebenwanan. Indyari kaya terna pemenulduꞌ dye duntin bekeꞌ pemengabar pasal ki Jesus neng pengerim itueng Kristo, etawa Mesias. ");
INSERT INTO plw_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ganang timpung atin megkekansang ne mengengandel, indyari mengeꞌ Judio neng megbebres et Griego nemenawey et mengeꞌ Judio neng megbebres et Hebreo sabab mengeꞌ kelilibunan neng balu dut bagiꞌ dye tiꞌ mekepesaran ne eset pengeldew-peldew dut pegbagiꞌ et ikebiyag dye. ");
INSERT INTO plw_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Angkansa tinimung et mengeꞌ sempuluꞌ duwang bibilinan tuꞌ ginsang kerupungan neng mengeꞌ mengengandel, indyari sinugid kedye, “Diki kay mekedyari pesaran pegpeabar et beres et Empuꞌ apang kumpet lang et pegbagiꞌ et ikebiyag. ");
INSERT INTO plw_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Angkansa mengeꞌ ketipusdan, pemiliꞌ kew ne eset mengeꞌ kesebeyaan myu neng pitung kelelekian, na kilala myu na mepengendelan, meutek bekeꞌ dut ipnuꞌ et Empung Nakem. Indyari ibetang kay dye eset keradyang itue. ");
INSERT INTO plw_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Indyari ipetudyu kay gasi ginsang dameng timpu, eset pegpenelang bekeꞌ dut pegpeabar et beres et Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Negeayan et ginsang kerupungan itueng binahum et mengeꞌ bibilinan, angkansa piniliꞌ dye si Esteban, sembatung lelaki neng mepangger pengandel dut Empuꞌ bekeꞌ bahaʼt Nakem et Empuꞌ, bekeꞌ gasi de Pelipe, Prokoro, Nikanor, Timon, Parmenas bekeꞌ si Nikolas na tawʼt Antiokia, sembatung lein Judio na negayat eset egama et Judaismo. ");
INSERT INTO plw_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Pineelep dye eset mengeꞌ bibilinan na negpenelanginan dye, ganang pinengdepnan dye mengeꞌ keremut eset kedye in. ");
INSERT INTO plw_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Indyari pelahyun na megpeabar mengeꞌ mengengandel itueng bebresen et Empuꞌ dut mekansang taaw. Pekeldam neng pekeldam sekaliꞌ mengeꞌ mengengandel in dut lungsud et Jerusalem, bekeꞌ mekeldam neng mengeꞌ pariꞌ megpengandel ki Jesus. ");
INSERT INTO plw_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Pegbegeyan et Empuꞌ ki Esteban redyikiꞌ bekeꞌ mekepengyedian, angkansa pesi nemuwat ya et mekeldam neng kelang keknad-eknad bekeꞌ mengeꞌ tendaꞌ dut elepan et mengeꞌ taaw. ");
INSERT INTO plw_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Segwaꞌ nekipegsedsagkaꞌ eset kenye mengeꞌ senung nekelamud dut sembatung pegbikianen na Sinagoga neng Mengeꞌ Pinelayam, na sengkerupungan et mengeꞌ tawʼt Judio teyeg et mengeꞌ lungsud et Sirene bekeꞌ et Alejandria, sampay senung-senung mengeꞌ Judio teyeg mengeꞌ probinsiya et Silisia bekeꞌ et Asia. ");
INSERT INTO plw_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Segwaꞌ kaya dye nedaag si Esteban sabab et kesesewran et beres ye pebiyaꞌ et Nakem et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Angkansa petaguꞌ na nemenutsut dye mengeꞌ senung kelelekian na megsugid et kwantin, “Nekingeg kay na pegudyuꞌ-udyuen si Esteban ki Moises bekeꞌ Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Na baꞌ kwantin ineriwaraꞌ dye na miseg ki Esteban mengeꞌ taaw sampay mengeꞌ kenggungurangan eset lungsud bekeꞌ mengeꞌ menunulduꞌ et Keseraan. Ya in inalew dye pegketbes pineelep eset tawʼt Kekunsialan neng Sanedrin. ");
INSERT INTO plw_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Indyari pinegelep dye gasi mengeꞌ meeakal neng saksiꞌ atu ki Esteban. Kwan dye, “Taaw na itue kaya petetngew et besberes et meyaat atu dut pasek metignaꞌ neng Pengempuan naꞌ Benwa tyu bekeꞌ eset Keseraan binggey ki Moises. ");
INSERT INTO plw_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nekingeg kay na pegsugiren ye na rumbaken et Pengempuan naꞌ Benwa si Jesus neng tawʼt Nasaret, indyari sembian et mengeꞌ keeratan pinepusakaꞌ eset kityu i Moises in.” ");
INSERT INTO plw_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Tinengtengan si Esteban et ginsan neng megearung eset elepan et Kekunsialan neng Sanedrin. Nebiriꞌ dye na kenyeng rupa samat rupa mene et dereakan et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Indyari si Esteban tuꞌ iningkut et pinekemetaas neng pariꞌ, kwan, “Banar be takuꞌ itueng ginsan?” ");
INSERT INTO plw_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Siminambag si Esteban, “Mengeꞌ ketipusdan bekeꞌ mengeꞌ kenggurangan, kinggaꞌ myu itueng ibres ku. Itueng metaas bekeꞌ mekepengyediang Empuꞌ nepebiriꞌ eset kityung keupuꞌupuang si Abraham sasat itue dut probinsiya et Mesopotamia nega, mura liminegdeng dut lungsud et Haran. ");
INSERT INTO plw_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Bineres et Empuꞌ eset kenye, kwan, ‘Tirengan mu dimung lugtaꞌ bekeꞌ mengeꞌ keusbaan mu, indyari sumurung ke dut kelugtaan ipebiriꞌ ku dimu.’ ");
INSERT INTO plw_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Angkansa nugad ya dut lungsud et mengeꞌ tawʼt Kaldeo, indyari liminegdeng neʼt lungsud et Haran. Pagkaꞌ natey ne kenyeng amaꞌ, ya in pineubuꞌ neꞌ Empuꞌ dut lungsud ne itue neng peglelegdengan tyu tiban. ");
INSERT INTO plw_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Segwaꞌ kaya ya binggeyan et Empuꞌ misan sengpalad neng lugtaꞌ, segwaꞌ tinangeꞌ Ye itueng lugtaꞌ megmendyaring kenye eset sakup ye, bekeꞌ dut mengeꞌ tungtung-inupuꞌ ye, misan ne kayangga peꞌ yegang ye atin neng masa. ");
INSERT INTO plw_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Indyari itue sinugid kenye et Empuꞌ, kwan, ‘Lumegdeng dut ibang bangsa dimyung mengeꞌ tungtung-inupuꞌ. Uripenen dye duntin bekeꞌ peliyutan dut seled epat neng gatus teun. ");
INSERT INTO plw_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Dusaen ku ating bansang menguripen kedye. Pegketbes mugad dye duntin bekeꞌ mengempuꞌ eset daken dut lungsud ne itue.’ ");
INSERT INTO plw_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Indyari tinahag et Empuꞌ si Abraham pegtutuliꞌ bilang tendaꞌ et kenyeng pinegsulutan eset kedye. Angkansa ganang pinengganak si Isaak, tinuliꞌ ye itue dut ikewalung eldew. Kwantin gasi binuwat i Isaak ki Jakob neng yegang ye, bekeꞌ si Jakob binwat dut sempuluꞌ duwang yegang ye neng lelaki, na dye negmendyaring atin sempuluꞌ duwang kegunggurangan et kityung bangsa et Israel. ");
INSERT INTO plw_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Naꞌ itueng mengeꞌ yegang i Jakob nengimbeng ki Jose neng ariꞌ dye, angkansa pinegelen dye ya na bilang uripen dut bangsa et Egipto, segwaꞌ eset kenye itueng Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Indyari binawiꞌ ya dut ginsan et kenyeng keliyutan. Binggeyan ya et Empuꞌ kesesewran bekeꞌ tinebangan ya na ipenunga ganang umalep ya dut ki Paraon neng surutan dut bangsa et Egipto. Indyari ya in binuwat i Paraon Gobernador et Egipto bekeꞌ ginsang sengkebebenwanan et surutan. ");
INSERT INTO plw_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Naꞌ diminateng tegurap bekeꞌ kelang ketiksaan dut sengketelingkepaʼt bangsa et Egipto bekeꞌ Kanaan, indyari kaya meisian et kekanen kityung mengeꞌ keupuꞌupuan. ");
INSERT INTO plw_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Angkansa ganang neebaran i Jakob na maya tirigu dut bangsa et Egipto, pineruntin ye mengeꞌ yegang ye neng kityung keupuꞌupuan dut megunang panew apang memengley. ");
INSERT INTO plw_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Dut ikeruwang pegduntin dye, negpekilala ne si Jose eset kenyeng mengeꞌ ketipusdan, indyari nekesewran et Paraon pesalan et keusbaan i Jose. ");
INSERT INTO plw_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Pegketbes atin, pineisiꞌ i Jose si Jakob bekeꞌ kenyeng mengeꞌ kekempungan, pitumpuluꞌ lima ginsan. ");
INSERT INTO plw_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Indyari siminurung si Jakob dut Egipto. Indyari mekansang teun leyd, duntin ne ya natey, kwantin gasi kityung mengeꞌ sempuluꞌ duwang keupuꞌupuan tyu. ");
INSERT INTO plw_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Binibit mengeꞌ bangkay dye dut lungsud et Sekem, indyari binetang ne dut lelebengan neng inlen i Abraham eset mengeꞌ keyegangan i Hamor tagnaꞌ. ");
INSERT INTO plw_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Nekwit ne dut Egipto mengeꞌ keupuꞌupuan i Abraham. Ganang megkekabiꞌ ne timpu et pegtuman et Empuꞌ eset kenyeng tangeꞌ ki Abraham, mekeldam ne mengeꞌ tawʼt Israelita eset bangsa et Egipto. ");
INSERT INTO plw_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Na nemegsubli gasi surutan dut Egipto, indyari itueng bagung surutan na kaya mekekilala ye ki Jose. ");
INSERT INTO plw_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Inekalan itueng surutan kityung tutusan, sampay pineliyutan ye dye sampay tinehagan ye kityung keupuꞌupuan et pinelegesan na itimbag kedyeng memulek apang matey. ");
INSERT INTO plw_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Atin neng masa ipengganak si Moises, sembatung yegang na pegmerganen et Empuꞌ bekeꞌ menunga dagbes ye. Telung bulan mena itue tinengman dut benwa et kenyeng amaꞌ. ");
INSERT INTO plw_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Indyari ganang lineges pineliwan ya in ne, inembuan ne ya et yegang neng libun i Paraon, pegketbes pinekilalana samat diring yegang ne in. ");
INSERT INTO plw_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Tinulduan ne ya in neng ginsang kesesewran et mengeꞌ tawʼt Egipto, indyari negmendyaring bantug eset beres bekeꞌ eset buwat. ");
INSERT INTO plw_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Ganang epat neng pulung teun ne umur ye, nepikiran ye sumurung dut kenyeng seꞌsaliꞌ neng tawʼt Israelita apang birinen baꞌ enu kedyeng kebtangan. ");
INSERT INTO plw_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Nebiriꞌ ye megpesekitan et sembatung tawʼt Egipto sembatung tawʼt Israelita, angkansa tinebangan i Moises itue, indyari bilang pegbeles pinatey ye tawʼt Egipto na atin. ");
INSERT INTO plw_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Keblan i Moises meretian atin et kenyeng mengeꞌ seꞌsaliꞌ Israelita na dye in bewinen et Empuꞌ pebiyaꞌ ye, segwaꞌ kaya lang itue meretian dye. ");
INSERT INTO plw_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","“Kinedikleman maya nebiriꞌ ye duwang tawʼt Israelita nemegbanta, indyari ginees ye na dye in bulagen. Kwan ye, ‘Mengeꞌ bilaꞌ, manu takuꞌ kemyu tuꞌ pemegbanta? Saliꞌ kew tawʼt Israelita.’ ");
INSERT INTO plw_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Segwaꞌ sinikwey ga si Moises in et lelaking meiiseg dut iba ye, indyari negberes, kwan, ‘Sinu takuꞌ nenggerar dimu apang mengmendyaring pegibuten bekeꞌ mengungukum kay?’ ");
INSERT INTO plw_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","‘Gay mu be takuꞌ aku peteyen samat binuwat mu kegapun eset tawʼt Egipto in?’ ");
INSERT INTO plw_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ganang nekingeg itue i Moises, nelegyu ya in, indyari liminegdeng dut bangsa et Midian. Nengesawa ne ya duntin bekeꞌ negyegang dye et duwang lelaki. ");
INSERT INTO plw_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Mekelabay epat neng pulung teun, nepebiriꞌ ki Moises sembatung dereakan et Empuꞌ eset sembatung megdedleg neng mebabaʼt puut kayu dut kelnangan na kaya merayuꞌ dut bukid et Sinai. ");
INSERT INTO plw_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Neknaran si Moises eset kenyeng nebiriꞌ, indyari ganang kebian ye apang intetewen et menunga, nekingeg ye beres et Begerar na Empuꞌ, kwan, ");
INSERT INTO plw_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Aku itueng Empuꞌ et dimyung mengeꞌ keupuꞌupuan, itueng Empuꞌ de Abraham, Isaak bekeꞌ i Jakob.’ Si Moises tuꞌ neggerar neʼt takut bekeꞌ diki ne eteyan kesiyek. ");
INSERT INTO plw_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Sinugid kenye et Empuꞌ, kwan, ‘Ugaraꞌ dimung tempaꞌ set tiked mu sabab pasek metignaꞌ itueng lugtaꞌ neng pegeetiyegan mu. ");
INSERT INTO plw_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Mekebiriꞌ ku banar pepeliyutan et mengeꞌ tawʼt Egipto mengeꞌ taaw ku, bekeꞌ mekekingeg ku peningkag et mengeꞌ Israelita. Indyari nineug ku apang dye in bewinen. Aniꞌ ke, tehagen te ikew dut lungsud et Egipto.’ ");
INSERT INTO plw_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Itueng si Moises minendian et mengeꞌ Israelita ganang kedyeng ibres, kwan, ‘Sinu takuꞌ nenggerar dimu apang mengmendyaring pegibuten bekeꞌ mengungukum kay?’ Segwaꞌ itue negang si Moises gasi ginerar et Empuꞌ bilang pegibuten bekeꞌ mememawiꞌ eset tabang et dereakan et Empuꞌ na nepebiriꞌ eset kenye dut mebabang puut kayu na megdedleg. ");
INSERT INTO plw_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Si Moises nega gasi nematun eset keupuꞌupuan i Israel mawaʼt ketiksaan dut Egipto. Apang meinabu itue, ya in nemuwat et mengeꞌ keliꞌlilung keradya bekeꞌ tendaꞌ dut Egipto bekeꞌ dut Dagat na Meregang, bekeꞌ dut kelnangan sasat nemegpanew dye dut seled epat neng pulung teun. ");
INSERT INTO plw_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ya nega Moises na negsugid eset mengeꞌ tawʼt Israelita, ‘Memiliꞌ Empuꞌ dimyu na sembatu eset dimyu na buwateng tarus samat daken.’ ");
INSERT INTO plw_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Si Moises key in kebayaꞌ dut kerupungan neng mengeꞌ tawʼt Israelita dut kelnangan. Ya key in nekipegsudsugid eset dereakan et Empuꞌ na negberes eset kenye, bekeꞌ eset kityung mengeꞌ kegunggurangan dut bukid et Sinai. Ya key in timinerima et mengeꞌ beres na megbegey biyag mawaꞌ dut Empuꞌ apang ibgey kityu. ");
INSERT INTO plw_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Segwaꞌ kaya si Moises inandel et kityung mengeꞌ kegunggurangan, segwaꞌ minendinan dye ya. Gay dye na megpeuliꞌ dut bangsa et Egipto. ");
INSERT INTO plw_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Indyari sinugid dye ki Aaron neng ukaꞌ ye, kwan, ‘Bealan mu kami et mengeꞌ empuꞌempuan na muna eset damen, sabab kaya ne nesewran kay na baꞌ neenu ne itueng Moises ne atin na negpeliwan damen dut lungsud et Egipto!’ ");
INSERT INTO plw_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Indyari nemuwat dye ne sembatung empuꞌempuan neng samat dagbes et ibun neng sapiꞌ. Pinegumenatan dye nega itueng mengeꞌ keradya et keremut dye, bekeꞌ binggeyan et mengeꞌ bebgey dye. ");
INSERT INTO plw_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Sabab esentin, tinelikuran dye et Empuꞌ bekeꞌ pinesaran mengempuꞌ eset mengeꞌ bituen bekeꞌ eldew sampay bulan bilang mengeꞌ empuꞌempuan. Itue ga kuyun dut ipinesurat et Empuꞌ tarus ye dut Kesuratan, kwan, ‘Ginsan mengeꞌ tawʼt Israel, lein aku tantu na sinimeyaan myu et mengeꞌ simayaꞌ bekeꞌ mengeꞌ setwaꞌ na pinatey dut kelnangan neng seled epat neng pulung teun duun. ");
INSERT INTO plw_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Diki ne, sabab ating pegbibiten myu neng ranggar i Molok neng empuꞌempuan myu, bekeꞌ dagbes et bituen et empuꞌempuan myung si Renpan. Binuwat myu mengeꞌ patang apang pengempuen. Angkansa ipenimbag ku kemyu dut sembelaꞌ nega neng bangsa et Babilonia.’ ");
INSERT INTO plw_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Tagnaꞌ tiꞌ, kegunggurangan tyu maya benwang pinegsulutan et Empuꞌ bekeꞌ neng taaw eset nekeunang dye in dut kelnangan. Binuwat itueng benwa kuyun dut Keseraan et Empuꞌ ki Moises bekeꞌ eset sungtuhang pinebiriꞌ eset kenye. ");
INSERT INTO plw_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Pinusakaꞌ itue et kedyeng mengeꞌ yegang bekeꞌ binibit ganang sekupen dye itueng lungsud neng mengeꞌ bangsang pineleug eset kedye et Empuꞌ eset pengunguna i Josue. Bekeꞌ itue dumaran duntin seked dut ketimpuan i Surutan Dabid. ");
INSERT INTO plw_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Minergaꞌ et Empuꞌ si Surutan Dabid bekeꞌ neneew itue et ketugutan na megpetiyeg et benwaʼt Empuꞌ i Jakob. ");
INSERT INTO plw_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Segwaꞌ yegang ye si Solomon mene negpetiyeg et benwang itie. ");
INSERT INTO plw_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Segwaꞌ, megsepantun kwantin ketaas-taasang Empuꞌ in, kaya lang meglegdeng eset mengeꞌ benwa na binuwat et taaw. Kuyun dut pegsugiren et tarus et Empuꞌ tagnaꞌ tiꞌ, kwan Empuꞌ, ");
INSERT INTO plw_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Langit Daken neng erungan, indyari itueng dunyaꞌ eetagan et Dakeng mengeꞌ tiked. Eteg be negang benwa na ipetiyeg myu eset Daken etawa enu beng lungsud na pegpeternan Ku? ");
INSERT INTO plw_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Diki be takuꞌ aku nemuwat neng ginsang itue?’ ” ");
INSERT INTO plw_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Indyari sinugid i Esteban dut kekunsialan, kwan, “Mekektul ulu myu! Kayangga peꞌ pegpinda dimung seled pusuꞌ! Mendiꞌ myu kinggen keberbenaran et ketulduan et Empuꞌ! Na baꞌ enu binwaten tagnaꞌ et mengeꞌ kegunggurangan tyu, kwantin nega pegbuwaten myu. Daran myu pegetuanan itueng Nakem et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Sinung tarus et Empuꞌ kaya pineniksa et dimyung kegunggurangan? Kaya! Pinatey dye mengeꞌ kesewd menarus dut pegatuꞌ et Pasek Metignang Mesias, neng Tehagen et Empuꞌ. Na ya in pinegdagang myu bekeꞌ pinepatey. ");
INSERT INTO plw_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Timinerima kew et Keseraan binggey et Empuꞌ pebiyaꞌ et mengeꞌ dereakan ye, segwaꞌ kaya myu pegesipen itie!” ");
INSERT INTO plw_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ganang mekingeg itue et mengeꞌ sakup neng tawʼt Kekunsialan neng Sanedrin, dye in megkekek neʼt kelang iseg ki Esteban. ");
INSERT INTO plw_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Segwaꞌ si Esteban, sinleran neʼt Nakem et Empuꞌ, na siminyek dut langit, indyari nebiriꞌ megserinew neng kebentugan et pelibut et Empuꞌ bekeꞌ si Jesus na megeetiyeg eset kewanan et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Kwan ye, “Seikiꞌ be, mebiriꞌ ku na ukab kelengitan bekeꞌ Yegang et Taaw megeetiyeg eset tampaꞌ kewanan et Empuꞌ!” ");
INSERT INTO plw_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Tinembel dye kedyeng telinga bekeꞌ nemegbensag. Pegketbes, nemegdingdingan dye rinuhub eset kenye. ");
INSERT INTO plw_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ginuyud dye si Esteban peliwan et lungsud apang bekalen seked matey. Pinenglukas et mengeꞌ saksiꞌ kedyeng repanan, indyari tinektak eset titikeran et sembatung subur na ingaran ye Saulo. ");
INSERT INTO plw_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Indyari ganang pinegbebakal dye si Esteban na pegpenelang et kwantin, kwan, “Empung Jesus terimanen mu dakeng kurudua.” ");
INSERT INTO plw_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Indyari siminelukud si Esteban bekeꞌ negbensag et mebasag, kwan, “Begerar, dyangan mu ne dye sukuten et keselaang itue!” Ganang negberes itue, ya in natey ne. ");
INSERT INTO plw_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Indyari, kesulut dye si Saulo dut pegkepatey i Esteban. Atin neng eldew timinagnaꞌ kelang ketiksaan eset mengeꞌ mengengandel et mengeꞌ ketingtimungan dut Jerusalem. Ganang mengeꞌ bibilinan mene netinda duun, ginsan neng mengeꞌ ibang mengengandel nemegpekparak ne eset probinsiya et Judea bekeꞌ Samaria. ");
INSERT INTO plw_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Naꞌ si Esteban gasi in limbeng neʼt mengeꞌ taaw neng kelang pegarap dut Empuꞌ na nemengrupuk ne banar. ");
INSERT INTO plw_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sementaraꞌ pegeriweraen ne banar i Saulo mengeꞌ mengengandel et mengeꞌ ketingtimungan in. Pegselden ye ne kebenwa-benwanan, pinengrayak ye mengeꞌ pemengandel ki Jesus in, sampay diki ne pilinen lelaki etawa libun pinemerisu ye dye. ");
INSERT INTO plw_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Naꞌ mengeꞌ mengengandel nemegketkanat na sumurung dut kede lungsud et mengeꞌ taaw na endelen itueng Menungang Abar pasal ki Jesus Kristo. ");
INSERT INTO plw_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Siminurung si Pelipe dut sembatung lungsud dut probinsiya et Samaria, bekeꞌ ipineabar ye duntin pasal i Jesus neng Mesias tinahag et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ganang neebaran et keldamen et mengeꞌ taaw sampay nebiriꞌ itueng mengeꞌ keliꞌlilung nebuwat ye, nengingeg dye ne banar et pegbersen ye in. ");
INSERT INTO plw_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Sabab megegerwak mengeꞌ meyaat neng nakem sasat megliliwan dut mekansang taaw neng nesleran dye in. Nepegulinan ye mekansang neng pangkul bekeꞌ mengeꞌ piley. ");
INSERT INTO plw_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Angkansa sabab et ating neinabu dut lungsud dye in, nesegyaan banar mengeꞌ esentin. ");
INSERT INTO plw_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Eset ating probinsiya et Samaria, maya gasi meglelegdeng duntin sembatung lelaki ingaran ye Simon. Atin pe in pineliluꞌ ye mengeꞌ tawʼt Samaria pegpepebiriꞌ et balikmata. Pegsugiren ye dut mengeꞌ taaw na ya in tantung mekepengyedian. ");
INSERT INTO plw_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Indyari ginsang taaw nengingeg ne kenye, tumagnaꞌ dut pegibuten sumked dut uripen. Kwan dye, “Itueng lelaki na ating kepengyedian et sembatung empuꞌ neng pegtingkagaʼt si Basag neng Kepengyedian.” ");
INSERT INTO plw_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Nekwit neng timpu na nepenelinga dye ya sabab et keliꞌliluꞌ et kenyeng balikmata. ");
INSERT INTO plw_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Segwaꞌ ganang itulduꞌ i Pelipe Menungang Abar pasal eset pegmilik et Empuꞌ sampay ki Jesus Kristo megmendyaring Mesias, mekansang dye in nemengandel bekeꞌ negpebewtismu, lelaki libun. ");
INSERT INTO plw_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Misan si Simon nengandel ne, indyari ganang nebewtismuan ne ya in, daran ne megbayaꞌ ki Pelipe. Negliluꞌ ya ganang nebiriꞌ ye mengeꞌ keliluꞌlilung keradya bekeꞌ mengeꞌ tendaꞌ. ");
INSERT INTO plw_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ganang nekekingeg mengeꞌ bibilinan eset Jerusalem na nemengandel neʼt beres et Empuꞌ mengeꞌ tawʼt Samaria, pinesurungan dye si Pedro bekeꞌ si Juan dun kedye. ");
INSERT INTO plw_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Pegdateng, nenelangin dyeng duwa dut Empuꞌ supaya kaluꞌ dumapel dut kedye Empung Nakem. ");
INSERT INTO plw_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Sabab, eꞌ nebewtismuan dye ne gasi dut ingaran et Begerar Jesus, segwaꞌ misan peꞌ sembatu dut kedye kayangga peꞌ nedeplan et Nakem et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ganang nedpen dye ne i Pedro bekeꞌ i Juan et keremut dye, atin peꞌ diminapel ne et kedye Nakem et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Pagkaꞌ nebiriꞌ i Simon na diminapel ating Nakem et Empuꞌ sabab et pegdepen et keremut et mengeꞌ bibilinan, angkansa sinukayan yeʼt pirak si Pedro bekeꞌ si Juan. ");
INSERT INTO plw_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Kwan ye, “Begeyiꞌ myu aku et ating kepengyedian ne itue, apang sebarang medpen ku et keremut ku atin, deplan et Nakem et Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Segwaꞌ sambag i Pedro et kenye, kwan, “Elulaꞌ kuʼt keunung keʼt pirak mu in dut Narkaꞌ! Sabab pegsedseleren mu ating begey ingasiꞌ et Empuꞌ mekedyari lang melen. ");
INSERT INTO plw_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Angkansa, kaya lang lamud mu et itueng keradya kay tuꞌ, sabab pegyeyekinen mu in diki lang patut dut Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Selyu pegsusunan mu ating keyeatan et pegyeyekinen mu in bekeꞌ pegpenelang ke dut Begerar Jesus, kaluꞌ lang gasi maapen ke seʼt samat ating ginis neng pegsedseleren mu in. ");
INSERT INTO plw_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Sabab, mekesipat ku ne na asal ipnuꞌ ke et pegimbeng. Sama keʼt pegsisigtan et keyeatan nega in.” ");
INSERT INTO plw_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Sinugid i Simon ki Pedro bekeꞌ ki Juan, kwan ye, “Baꞌ mekedyari dimyu, ipenelangaꞌ myu aku dut Begerar, apang ating ginis neng sinugid myu in diki meinabu daken.” ");
INSERT INTO plw_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pegketbes negpekubanar pasal et nebiriꞌ dye sampay pegpeabar dye et beres et Begerar Jesus, negpeuliꞌ dye dut Jerusalem. Sampay negsindalan dut mekansang kerurungan et mengeꞌ tawʼt Samaria na nepebnaran dye gasi et Menungang Abar pasal ki Jesus. ");
INSERT INTO plw_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Na dinaak et dereakan et Empuꞌ si Pelipe, kwan ye, “Pegpanyap ke bekeꞌ surung dut tampaꞌ barat dut dalan naꞌ pesanad et lungsud et Gasa teyeg dut lungsud et Jerusalem.” Itue dalan et kelnangan. ");
INSERT INTO plw_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Angkansa, negpanyap si Pelipe bekeꞌ siminurung. Mendyari nebiriꞌ ye sembatung pegibuten et bangsa et Etiopia neng mengengeradya et Kandas etawa Reyna, ating libun neng mememegbeg et mengeꞌ tawʼt Etiopia. Ating lelaki megmimilik gasi et kementirian ye. Siminurung ya dut Jerusalem apang mengempuꞌ. ");
INSERT INTO plw_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ganang pegsesekatan ye keritun, meguliꞌ ne. Pegbebetsaen ye ating buuk et tarus naꞌ si Isaias tagnaꞌ tiꞌ. ");
INSERT INTO plw_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Mendyari, sinugiran et Nakem et Empuꞌ si Pelipe, kwan, “Peringaniꞌ atin keritun tiꞌ.” ");
INSERT INTO plw_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Angkansa, negdeꞌdaliꞌ diminarak si Pelipe, seked mekabiꞌ. Nekingeg yeng pegbebetsaen neng buuk i Isaias naꞌ tarus. Iningkut ye, kwan, “Mekeretian mu be takuꞌ pegbebetsaen mu in a?” ");
INSERT INTO plw_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Indyari siminambag pegibuten, kwan, “Enukwan ku takuꞌ meretian itue baꞌ kaya gasi megpeatur et daken?” Sekaliꞌ ginayat ye si Pelipe seked nekesakat neʼt keritun. ");
INSERT INTO plw_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Itueng behagiꞌ et Kesuratan neng pegbebebetsaen ye, kwan, “Antangan ye samat bibili neng kaya gikgibek na pegbibiten dut susumbelian. Etawa, antangan ye samaʼt sembatung ibun et bibili set elepan et mengingipat naꞌ peggugupitan bulbul ye, temed kaya lang gikgibek ye. ");
INSERT INTO plw_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Sabab et kekimbebaan ye kaya ya inukum et metignaꞌ. Misan sembatu kaya keusul et tutusan ye. Umur ye kaya lang pinesangdan atuʼt dunyaꞌ.” ");
INSERT INTO plw_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Itueng pegibuten nengingkut ki Pelipe, kwan, “Ipeturaꞌ be daken baꞌ pegsugiren i Isaias naꞌ tarus tuꞌ, sindir ye et diri ye etawa pegsindiren ye ibang taaw?” ");
INSERT INTO plw_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Tinegnanan i Pelipe negpeatur kenye teyeg et Kesuratan naꞌ atin. Sinugid i Pelipe kenye pasal et Menungang Abar pasal et ki Jesus Kristo. ");
INSERT INTO plw_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Dut pegpelembus dyeʼt pegpanew dut dalan, nekebiaꞌ dye et danumen. Sekaliꞌ negsugid ating pegibuten in, kwan, “Naꞌ, itue ne e danum. Enu nega sebaban, ampaꞌ diki ku mekedyari kepepebewtismu?”. ");
INSERT INTO plw_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Siminambag si Pelipe, kwan, “Mekedyari ke bewtismuan, baꞌ ating pegandel mu in dut pusuꞌ mu.” “Eꞌ tuꞌ, keberbenaran,” sambag ye. “Pegandel ku na si Jesus Kristo atin Yegang et Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Angkansa pinetaren ne et ating pegibuten pegsesekatan dye in. Nineug dyeng duwa de Pelipe bekeꞌ et pegibuten in dut danum. Sekaliꞌ binewtismuan ya i Pelipe. ");
INSERT INTO plw_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ganang pegbituaꞌ dye ne dut danum, sekaliꞌ si Pelipe megtuy ne pineugad et Nakem naꞌ Empuꞌ. Kaya dye ne negbiꞌbiriꞌ peuliꞌ. Segwaꞌ ating pegibuten in negpelembus lang et pegpanew ye et meksan banar. ");
INSERT INTO plw_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Segwaꞌ pinebibit et Nakem et Empuꞌ si Pelipe dut lungsud et Asoto. Tihad duntin, negsindalan et mengeꞌ tawʼt kebebenwanan naꞌ mebianan ye, pinenulduan ye et Menungang Abar pasal ki Jesus Kristo seked nekerateng ya et lungsud et Sesarea. ");
INSERT INTO plw_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Sasat nega, mebasag nega pegsesenggupan i Saulo menungsang bekeꞌ imeteyen mengeꞌ pepengenaran i Begerar Jesus Kristo. Angkansa, sinurungan ye ating pegibuten et ginsan naꞌ pariꞌ. ");
INSERT INTO plw_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Nengangat ya et mengeꞌ surat tudyu dut mengeꞌ benwa neng pegtingtimungan et mengeꞌ Judio dut Damasko apang sebarang mebianan ye neng memegsusunud et Dalan i Jesus Kristo, misan sinu asal, elewen ye, pelibun, pelelaki. Pungpungen ye dye apang pemiten ye dye ipemeuliꞌ dut Jerusalem. ");
INSERT INTO plw_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ganang megkekabiꞌ ne pegpanew i Saulo dut lungsud et Damasko, sekaliꞌ nenyar dut pelitlibut kenye siluꞌ neng kepupulew banar teyeg dut langit. ");
INSERT INTO plw_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Angkansa, tinegsurmed ye et lugtaꞌ, bekeꞌ nekingeg ye sembatung beres, kwan, “Saulo! Saulo! Manu takuꞌ pegsungsangen mu aku?” ");
INSERT INTO plw_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","“Sinu ke takuꞌ selus, Begerar?” ingkut ye. “Aku ne tuꞌ si Jesus neng pegsungsangen mu in,” sambag gasi et ating beres in. ");
INSERT INTO plw_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","“Segwaꞌ, tiyegiꞌ ne, bekeꞌ sumled ne et lungsud, isugid dimu duntin baꞌ enu teup keredyanen mu.” ");
INSERT INTO plw_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Naꞌ, nemeketaren bekeꞌ kaya nemekegibek mengeꞌ taaw gasi neng memegbebayaꞌ ki Saulo in. Mekekingeg dyeʼt beres, segwaꞌ kaya gasi mekebiriꞌ dye misan enu. ");
INSERT INTO plw_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Timinyeg si Saulo bekeꞌ minukrat ye mata ye. Segwaꞌ kaya ne meketuun. Angkansa dinundun dye mene ya seked dut Damasko. ");
INSERT INTO plw_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Seled telung eldew na ya kaya lang neketuun sampay kaya gasi nekekaan misan nekeinum kaya. ");
INSERT INTO plw_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Dut Damasko, maya gasi sembatung pengenaren i Jesus, ingaran ye si Ananias. Dut penerebinbin ye, tiningkag ya et Empuꞌ, kwan, “Ananias!” “Eꞌ, itue ku, Begerar!” sambag i Ananias. ");
INSERT INTO plw_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Sinugid kenye et Begerar Jesus, kwan, “Pegpanyap bekeꞌ sumurung ke dut benwa i Judas dut dalan pegngeranen et Metignaꞌ. Ingkutaꞌ duntin taaw na pegngeranen et si Saulo naꞌ tawʼt Tarso. Megpenelangin ya tiban dut Empuꞌ, ");
INSERT INTO plw_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","bekeꞌ dut penerebinbin ye tiꞌ, nebiriꞌ ye sembatung lelaki, ingaran ye si Ananias na siminled, tebes kunuꞌ dinpen i Ananias et keremut ye apang ketuun peuliꞌ ya in.” ");
INSERT INTO plw_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Segwaꞌ siminambag si Ananias, kwan, “Eꞌ, Empuꞌ, nekingeg ku ne dut mengeꞌ kineldaman naꞌ pasal et ating taaw, baꞌ enukwan yaat et ginis neng kineradya ye dut mengeꞌ taaw mu dut Jerusalem. ");
INSERT INTO plw_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Sampay diminateng ya atuʼt Damasko na maya puhun yeʼt mengeꞌ pegibuten banar et mengeꞌ pariꞌ, apang pengelewen ye ginsan kay na mengempuꞌ dimu.” ");
INSERT INTO plw_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Segwaꞌ sugid kenye et Begerar Jesus, kwan, “Surung dun, sabab itueng taaw e ginaay ku. Ya usalen ku apang mebunayag bebresen ku dut mengeꞌ tawʼt lein Judio sampay dut mengeꞌ memegbeg dye, bekeꞌ dut mengeꞌ tawʼt Israel. ");
INSERT INTO plw_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Sabab ipebiriꞌ ku ki Saulo ginsan baꞌ enukwan keliyutan neng keilangan lebayan ye, sabab lang et aku sampay bebresen ku.” ");
INSERT INTO plw_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Netuman, siminurung si Ananias bekeꞌ siminled et benwa. Indyari dinpen yeʼt keremut ye si Saulo. Kwan ye, “Bilaꞌ naꞌ Saulo. Pinesurung aku atue et Begerar, si Jesus neng nepebiriꞌ et dimu in dut dalan tiꞌ, ganang megsusurung ke teyen tudyu atue. Pinesurungan ye daken ikew apang, kunuꞌ, ketuun ke peuliꞌ, bekeꞌ meipnuꞌ ke et Nakem et Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Naꞌ sekaliꞌ maya neregdag antang samaʼt sisiꞌ in eset mengeꞌ mata i Saulo sampay neketuun ne ya. Timinyeg ya megtuy apang pebewtismu. ");
INSERT INTO plw_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Nekekaan ne ya, bekeꞌ negulinan peuliꞌ pemegmesagan ye. Nemeneteg et senung eldew dut Damasko si Saulo sampay iba ye mengeꞌ pepengenaran i Jesus. ");
INSERT INTO plw_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Pinenled ye sekaliꞌ mengeꞌ benwa neng pegtitingtimungan et mengeꞌ Judio. Pinabar ye duntin pasal et ki Jesus na Ya ne Yegang et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Nemegliluꞌ sebarang nekekingeg, angkansa, nemegingkut-ingkut, kwan dye, “Diki be itue neng taaw e dut Jerusalem naꞌ nengimatey et sebarang mengempuꞌ ki Jesus? Diki be inatuꞌ ye tiban apang elewen ye dye bekeꞌ pemungpungen sampay ipemeuliꞌ ye dye dut pegibuten banar et pariꞌ tiꞌ?” ");
INSERT INTO plw_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Segwaꞌ, luwas nega nasag banar pengabar i Saulo bekeꞌ mepangger pegpebnar ye na si Jesus atin ne Kristo. Pegdaagen ye mengeꞌ Judio neng memeglelegdeng et Damasko. Angkansa kaya lang memekesambag dye et kenye. ");
INSERT INTO plw_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Pegtalib et mekansang naꞌ eldew, nemegtimung ating mengeꞌ Judio apang pegsulutan dye imeteyen si Saulo. ");
INSERT INTO plw_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Segwaꞌ, sewd i Saulo ne ating paru kenye in. Eldew gebi apaꞌ dye kenye dut lelengewan et lungsud apang imeteyen ya. ");
INSERT INTO plw_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Segwaꞌ, peggebi nemenunuꞌ kenye set kelang tibung mengeꞌ memegsunud kenye in, bekeꞌ tinuntun dye ya dut sembelang metaas na bakud neng batu et Damasko. ");
INSERT INTO plw_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Pegdateng i Saulo dut lungsud et Jerusalem, sinulayan ye kepelamud dut mengeꞌ mengengandel i Jesus duntin. Segwaꞌ kaya lang nemengandel dye na si Saulo mengengandel gasi ki Jesus saliꞌ dye. Angkansa, nemenakut dye ginsan et kenye. ");
INSERT INTO plw_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Segwaꞌ, ginayat ya i Bernabe bekeꞌ inibutan ye dut mengeꞌ bibilinan tiꞌ. Pinabar ye dut kedye baꞌ enukwan pegkebiriꞌ i Saulo et Begerar Jesus bekeꞌ nemisara ki Saulo Begerar ganang dut dalan tiꞌ. Tinuturan ye gasi baꞌ enukwan urem i Saulo nengabar et pasal i Jesus Kristo dut Damasko. ");
INSERT INTO plw_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Angkansa, liminegdeng si Saulo et kedye tetegeyan bekeꞌ rinurut dye Jerusalem. Nengurem gasi duntin negpabar et pasal et Begerar neng si Jesus. ");
INSERT INTO plw_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Nekebisara-bisara nega bekeꞌ nengdawa et mengeꞌ Judio neng megberes et Griego. Segwaꞌ, pinaru dye ya imeteyen. ");
INSERT INTO plw_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ganang nebaran itue et mengeꞌ ketipusdan neng mengengandel, insiꞌ dye si Saulo dut lungsud et Sesarea bekeꞌ pineuliꞌ dut lungsud et Tarso. ");
INSERT INTO plw_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Angkansa, tinaren menunungsang, negkesenangan mengeꞌ ketingtimungan et mengengandel dut sengkelungsuran et Judio bekeꞌ et Galilea sampay et Samaria. Negpangger bekeꞌ kiminansang dye sabab et tabang et Nakem et Empuꞌ. Nemengebiyagan dye et maya takut dut Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Negpewpanew si Pedro apang mesumbaley ye mengeꞌ mengengandel neng memeglelegdeng dut Lida. ");
INSERT INTO plw_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Duntin nebiriꞌ ye sembatung lelaki na ingaran ye si Eneas. Pebubuntul itueng taaw walung teun ne sabab et patey mengeꞌ ugat ye. ");
INSERT INTO plw_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Mendyari, neres et kenye si Pedro, kwan, “Eneas! Pinenunga ke ne i Jesus Kristo. Pegbangun ne bekeꞌ igmetaꞌ ne igaan mu in!” Nekebangun sekaliꞌ bekeꞌ neketiyag ga in si Eneas. ");
INSERT INTO plw_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Nemekebiriꞌ kenye ginsan neng tawʼt Lida bekeꞌ tawʼt Saron. Angkansa, nemengandel dye et Begerar Jesus. ");
INSERT INTO plw_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Na dut lungsud et Jopa, maya gasi sembatung libun naꞌ mengengandel. Ingaran ye si Tabita. Et Griego, ingaran ye si Dorkas, gay bersen Usa. Mekansang menungang keradya ye naꞌ mengeꞌ penabang ye mengeꞌ kemiskinan. ");
INSERT INTO plw_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Mendyari negsakit ye et ating masa seked natey. Indyari nebesan ne bilug ye bekeꞌ dinatun itue dut dibuwat seled bibilik. ");
INSERT INTO plw_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Mekabiꞌ gasi lungsud et Jopa dut lungsud et Lida. Angkansa, ganang nebaran et mengeꞌ mengengandel na dut Lida si Pedro, pinedeakan dye ya et duwang kelelekian apang engaten dye ki Pedro na kwan, “Ketikasaꞌ bayaꞌ mena sekaliꞌ damen dut Jopa.” ");
INSERT INTO plw_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Angkansa tuminyeg si Pedro bekeꞌ nibut kedye. Pegdateng duntin, pineribuwat dye ya dut bibilik. Sekaliꞌ, ginsan neng mengeꞌ kelilibunan naꞌ nebebeluan in nemengabiꞌ et kenye naꞌ memegsisiyak. Pepebiriꞌ dye ki Pedro mengeꞌ tapis sampay ibang repanen neng pinemaal i Dorkas kwiʼt tagnaʼt pebibiyag nega ya. ");
INSERT INTO plw_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Mendyari, pineliwan dye ginsan i Pedro. Siminelukud ya bekeꞌ nenelangin dut Empuꞌ. Pegketbes, tineyuma ye ating patey bekeꞌ kwan ye, “Tabita, pegbangun ne!” Negmukrat mena si Tabita, bekeꞌ pegbiriꞌ ye tuꞌ si Pedro, negbangun ya sampay narung. ");
INSERT INTO plw_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Kineptan i Pedro lengen i Tabita apang ketiyeg. Pegketbes pinetingkag i Pedro mengeꞌ mengengandel bekeꞌ ating mengeꞌ libung nebebeluan. Pineteyuma ye et kedye si Tabita na biyag. ");
INSERT INTO plw_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Limingkep itueng abar dut sengkelungsuran et Jopa. Mekansang mengeꞌ taaw na nemengandel ne dut Begerar Jesus. ");
INSERT INTO plw_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Nekwit gasi legdeng dut Jopa i Pedro dut ki Simon neng mememetuug et mengeꞌ kulit. ");
INSERT INTO plw_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Dut lungsud et Sesarea maya sembatung lelaki na ingaran ye si Kornelio. Kapitan ya et mengeꞌ sundalu et Romano, neng pegbetengan et Rehimyento Italiana. ");
INSERT INTO plw_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ya in tawʼt lein Judio, segwaꞌ meinempuen gasi itueng taaw sampay sengkebenwa ye bekeꞌ maya takut dye dut Empuꞌ. Daran tabang ye et mengeꞌ miskin neng Judio, bekeꞌ epus lang megpenelangin ye dut Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Kasa tiꞌ et lisag telu et mapun, neterebinbin ye banar na kunuꞌ megseled et benwa ye sembatung dereakan et Empuꞌ. Terebinbin ye timiningkag, kwan, “Kornelio!” ");
INSERT INTO plw_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Sekaliꞌ siminiyek ya et megtetakut banar dut dereakan, bekeꞌ siminambag kwan, “Eꞌ enu atin begerar?” Sambag gasi et dereakan et Empuꞌ, kwan, “Mengeꞌ penelang bekeꞌ mengeꞌ pegtabang mu in kiningeg bekeꞌ nebiriꞌ ne et Empuꞌ, sampay rinendem Ye ikew. ");
INSERT INTO plw_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Angkansa tiban daakiꞌ et senung ketetawan supaya pebayaꞌ sembatung lelaki dut Jopa naꞌ ingaran ye si Simon neng pegngeranen gasi et si Pedro. ");
INSERT INTO plw_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ating lelaki meglelegdeng ki Simon neng memetuug et mengeꞌ kulit. Dut abiʼt dagat benwa ye.” ");
INSERT INTO plw_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Pegketbes meres et kwantin ating dereakan et Empuꞌ, nugad ne. Si Kornelio gasi neng sinugiran in, neningkag et duwang ketawan naꞌ tetehagen ye et benwa bekeꞌ sembatung sundalu neng meinempuen gasi naꞌ sembatu dut meninimuru ye. ");
INSERT INTO plw_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Pinatur ye ginsan kedye baꞌ enu neinabu, mura dinaak ye dye dut Jopa. ");
INSERT INTO plw_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Na pegkelenag ne, ganang mekabiꞌ neʼt lungsud et Jopa ating telung tinahag i Kornelio in, si Pedro gasi tuꞌ nenginik dut dibuwat pantay neng sapew et benwa apang megpenelang dut Empuꞌ. Temed ating masa megeapet ne mataʼt tengeldew. ");
INSERT INTO plw_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Pegurapan ye ne teyen banar bekeꞌ gaay yeng mengaan. Segwaꞌ, sasaʼt pegpepenyapen peꞌ pegkaan dye, sekaliꞌ nenerebinbin ya. ");
INSERT INTO plw_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Neukaban kunuꞌ langit bekeꞌ nebiriꞌ ye pegtutuntun et lugtaꞌ sembatung antang samaʼt kelang kumut neng peggegantung et epat naꞌ pidyuruꞌ. ");
INSERT INTO plw_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Duntin ne ginsan ginisan et ayup neng mengeꞌ memegpanew bekeꞌ memeglempey et lugtaꞌ sampay mengeꞌ memeglepad et lelengew, ginsan laanggaꞌ mengaan dut tawʼt Judio. ");
INSERT INTO plw_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Mendyari, nekekingeg ya et beres na, kwan et kenye, “Teyeg Pedro, pegsumbaliꞌ bekeꞌ mengaan ke.” ");
INSERT INTO plw_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Segwaꞌ, siminambag si Pedro, kwan ye, “Embe banar ye, Begerar, misan ingyan diki ku atin mekeradya. Sabab diki ku mekedyari mengaan et ating meridiꞌ, bekeꞌ diki lang kepetpatut kanen dut mengeꞌ tawʼt Judio.” ");
INSERT INTO plw_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Nekingeg ye peuliꞌ beres, kwan, “Kasiꞌ ipentangaꞌ et meridiꞌ naꞌ atin pinantang et Empuꞌ na menunga.” ");
INSERT INTO plw_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ketelu itue neinabu mura nepesintak ne ating kumut peribuwat gasi dut langit. ");
INSERT INTO plw_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ganang pegpipikiren peꞌ i Pedro retian et ating terebinbin ye in, nemengdateng ne gasi mengeꞌ pinengdaak i Kornelio in. Pagkaꞌ neturunan dye ne baꞌ embe benwa i Simon nemeglembus dye duun eset lelengewan et bakud. ");
INSERT INTO plw_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Nemengingkut dye na baꞌ duntin pegeldengan i Simon neng pegngeranan gasi et si Pedro. ");
INSERT INTO plw_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pegsesedseleren nega teyen i Pedro baꞌ enu retian et penerebinbin ye in ganang negsugid kenye Nakem et Empuꞌ kwan, “Kingeg, memegtulus dimu telung kelelekian. ");
INSERT INTO plw_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Angkansa, pegpanyap ke sampay ineug ne, kas ke megbeꞌbangkaꞌ na mayaꞌ ke et kedye. Sabab aku atin nengdaak kedye.” ");
INSERT INTO plw_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Angkansa nineug si Pedro, bekeꞌ nengingkut ya kedye kwan, “Aku ne tuꞌ taaw neng pegtutulusen myu. Enu takuꞌ sebaban et panew myu daken?” ");
INSERT INTO plw_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Sambag dye kwan, “Dinaak bayaꞌ kami i Kapitan Kornelio. Metignaꞌ ya bekeꞌ maya peguntabiꞌ eset Empuꞌ, sampay kelaꞌ banar pegampun kenye et mengeꞌ tawʼt Judio. Sinugiran ya et sembatung dereakan et Empuꞌ na engeyen ke dut benwa ye apang kunuꞌ mekingeg ye gasi baꞌ enu ipeatur mu.” ");
INSERT INTO plw_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Na mendyari pineigaꞌ i Pedro ating kelelekian senggebi. Pegdiklem, negpanyap si Pedro bekeꞌ nayaꞌ et kedye bekeꞌ nememayaꞌ gasi et kenye sampay mengeꞌ mengengandel teyeg dut Jopa. ");
INSERT INTO plw_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Pegdiklem et ating eldew, diminateng ya dut Sesarea. Duntin megtetagey kenye si Kornelio bekeꞌ mengeꞌ keusbaan sampay mengeꞌ biꞌbilaꞌ banar neng pinengangey ye in. ");
INSERT INTO plw_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Ganang sumled ne teyen si Pedro, megtuy sinusup ya i Kornelio et nepekleb set titikeran i Pedro et pegampun. ");
INSERT INTO plw_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Segwaꞌ kwan i Pedro, “Katew teyeg, aku taaw nega seꞌsaliꞌ ikew.” ");
INSERT INTO plw_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pelembus lang et sudsugid dyeng duwa, ganang megsesled dye et benwa. Nebiriꞌ i Pedro mekansang banar neng taaw duntin. ");
INSERT INTO plw_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Neres si Pedro kedye kwan, “Sewd myu na sembatung Judio pegdyenganen et egama ye baꞌ memeꞌbayaꞌ etawa menumbaley et sembatung lein Judio. Segwaꞌ, pinesewd et Empuꞌ daken na misan sinu kunuꞌ endey ku ipeantang et diki keteup-teup etawa meridiꞌ. ");
INSERT INTO plw_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Angkansa, ganang inangey myu aku, kaya lang giminaga ku, sabab gay ku mesewran baꞌ enu tiningkagan myu daken in.” ");
INSERT INTO plw_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Sambag i Kornelio, kwan, “Kinepatan ne tiban samaʼt itue negang meglilisag telu et mapun tuꞌ, mendyari, nenelangin ku dut Empuꞌ, atuʼt benwa ku tuꞌ. Sekaliꞌ, megtuy maya timinyeg set teteyumanan ku sembatung lelaki neng megpepekayan et meseru. ");
INSERT INTO plw_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Kwan et lelaki, ‘Kornelio, kiningeg et Empuꞌ penelangin mu, bekeꞌ inenpan ating mengeꞌ pegtabang mu in dut kemiskin. ");
INSERT INTO plw_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Daakiꞌ misan sinung taaw dut Jopa supaya isian si Simon neng pegngeranan gasi et si Pedro. Meglelegdeng ya dut benwa i Simon neng memetuug et kulit. Abiʼt dagat benwa ye.’ ");
INSERT INTO plw_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Indyari pinedeakan ku ikew megtuy. Megsukur gasi nekatuꞌ ke nega. Angkansa tiban netimung kay atue dut kebirian et Empuꞌ apang kumingeg et baꞌ enu pegpepeturun dimu et Begerar Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Mendyari, neres si Pedro kwan ye, “Tiban ku netentuan banar na seꞌsaliꞌ pemiriꞌ et Empuꞌ dut ginsan neng taaw. ");
INSERT INTO plw_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Pegenpan et Empuꞌ sebarang maya peguntabiꞌ et kenye bekeꞌ sebarang memegkeradya et metitignaꞌ. Kaya ye pegpilinen misan enuteg bangsa, tawʼt Judio etawa lein tawʼt Judio. ");
INSERT INTO plw_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Sewran myu et abar binggey et Empuꞌ dut mengeꞌ tawʼt Israel. Pinebunayag ye dut kedye Menungang Abar pasal et kesenangan dut Empuꞌ pebiyaꞌ ki Jesus Kristo. Demikian Ya Begerar gasi et ginsan taaw. ");
INSERT INTO plw_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Sewran myu baꞌ enu neinabu dut sengkelungsuran et Judea na timinihad dut Galilea, ganang pinabar i Juan pasal et bewtismu. ");
INSERT INTO plw_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Pegbersen ye tuꞌ pasal et ki Jesus Kristo neng tawʼt lungsud et Nasaret. Dinuul Kenye et Empuꞌ itueng Pasek Metignang Nakem Ye sampay keksegan bilang ketentuan na Ya ga in piniliꞌ. Sabab eset kenye Empuꞌ, misan embe tenan ye kenunganan pegkeredyanen ye. Pepenunga ye ginsan sebarang pepeliyutan i Seytan. ");
INSERT INTO plw_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Deuluꞌ kami itue mengeꞌ saksiꞌ dut ginsan neng kineradya ye dut bangsa et mengeꞌ Judio sampay dut Jerusalem. Megdemikian gasi dut pegransang dye ki Jesus Kristo dut krus seked patey. ");
INSERT INTO plw_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Segwaꞌ pegiketlung eldew binyag ya peuliꞌ et Empuꞌ. Demikian saliꞌ megpebiriꞌ ya damen. ");
INSERT INTO plw_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Diki negpebiriꞌ dut ginsan taaw, erapun et damen lang na mengeꞌ saksiꞌ neng piniliꞌ et Empuꞌ megunang masa nega tiꞌ. Pegketbes ya pinebiyag peuliꞌ, kami kesaru ye nengaan bekeꞌ nenginum. ");
INSERT INTO plw_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Binilinan ye kami menulduꞌ eset mengeꞌ taaw sampay megpesebanar na ya in nepiliꞌ et Empuꞌ na megmendyaring ukum et biyag bekeꞌ patey. ");
INSERT INTO plw_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ya ne in pegsindiren et mengeꞌ tarus et Empuꞌ dut pegpebunayag dye et sebarang mengandel ki Kristo keterima et kemeapan et mengeꞌ keselaan dye pebiyaꞌ et kepengyedian i Jesus Kristo.” ");
INSERT INTO plw_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Ganang megbebres nega si Pedro, nineug Nakem et Empuꞌ dut ginsan neng mengeꞌ memegkikingeg et beres. ");
INSERT INTO plw_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Mengeꞌ mengengandel naꞌ Judio neng nememayaꞌ ki Pedro in nemegliluꞌ sabab nebiriꞌ dye misan mengeꞌ lein Judio nemeketerima gasi et begey neng Nakem et Empuꞌ, na binggey kedye et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Megdemikian nekingeg dye nega gasi mengeꞌ lein Judio nemekebres et lein-leing bebresan sampay nememantug dut Empuꞌ. Angkansa kwan i Pedro, ");
INSERT INTO plw_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Dye in saliꞌ tyu nega gasi naꞌ pinemgeyan et Nakem et Empuꞌ. Na! Baꞌ kwantin sinu nega kelaang kedye apang mebewtismuan dye et danum?” ");
INSERT INTO plw_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Indyari dineakan ye na bewtismuan dye apang ipebiriꞌ na kedyeng Begerar neng si Jesus Kristo. Pegketbes tineew dye ki Pedro na tumerna duntin et senung mengeꞌ eldew. ");
INSERT INTO plw_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Nebaran et mengeꞌ bibilinan i Jesus sampay et mengeꞌ mengengandel dut sengkelungsuran et Judea na misan mengeꞌ lein Judio nemenerima gasi et beres et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Angkansa ganang timinungul ne si Pedro dut Jerusalem, sinawey ya et mengeꞌ mengengandel naꞌ Judio. ");
INSERT INTO plw_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Nememres dye kwan, “Manu nepebeꞌbayaꞌ ke dut mengeꞌ lein Judio sampay nekisaru ke et kedye?” ");
INSERT INTO plw_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Angkansa pinatur et mesayu i Pedro kedye ginsan neng baꞌ enu neinabu tihad negaʼt sengketegnanan. ");
INSERT INTO plw_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Timinagnaꞌ si Pedro, kwan ye, “Sasat dun kuʼt lungsud et Jopa, ganang megpenelangin ku dut Empuꞌ, sekaliꞌ tinerebinbin ku teyeg dut langit samaʼt kelang kumut naꞌ peggegantung eset epat neng pidyuruꞌ naꞌ peruruwey et abiꞌ ku. ");
INSERT INTO plw_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Sasat dinengdeng kuʼt menunga, duntin nebiriꞌ ku ginsan ginisan et mengeꞌ mekeklag neng ayup naꞌ memegpanew bekeꞌ memeglempey et lugtaꞌ, sampay mengeꞌ begit naꞌ memeglepad et lelengew. ");
INSERT INTO plw_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Mendyari nekekingeg ku et beres, kwan, ‘Teyeg Pedro, megsumbaliꞌ bekeꞌ mengaan ke.’ ");
INSERT INTO plw_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Segwaꞌ siminambag ku, kwan, ‘Diki, Begerar, diki lang selus mekedyari keredyanen ku atin. Demikian kaya lang gasi pengaan ku et ginis naꞌ meridiꞌ, etawa diki lang kepetpatut kanen in.’ ");
INSERT INTO plw_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Temed nekingeg ku peuliꞌ ating beres naꞌ teyeg dut langit, kwan, ‘Kasiꞌ ne ipentangaꞌ et meridiꞌ ating mengeꞌ pinenunga et Empuꞌ.’ ");
INSERT INTO plw_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ketelu itue neinabu, mura pinesintak ne peribuwat dut langit ating ginis. ");
INSERT INTO plw_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Sekaliꞌ megtuy nemengdateng set benwa neng peglelegdengan ku in naꞌ telung kelelekian teyeg dut Sesarea neng pinedaak et daken. ");
INSERT INTO plw_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Neres et daken Nakem et Empuꞌ na kwan, ‘Endey ke megbeꞌbangkaꞌ mayaꞌ et kedye.’ Nememayaꞌ gasi et daken itueng enem neng ketipusdan. Indyari siminled kay et benwa i Kornelio. ");
INSERT INTO plw_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Duntin pineatur i Kornelio damen na nekebiriꞌ ya et sembatung dereakan et Empuꞌ neng petitiyeg dut seled benwa ye na negsugid kenye, kwan, ‘Daaken mu tehagan mu dut Jopa apang engeyaꞌ si Simon neng pegngeranan gasi et si Pedro. ");
INSERT INTO plw_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Sabab ya megsugid dimyu et pasal et ikebawiꞌ mu sampay dimung sengkebenwa.’ ");
INSERT INTO plw_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ganang megtetagnaꞌ ku peꞌ teyen megbebres, sekaliꞌ nineug ne et kedye Nakem et Empuꞌ, samat pegineug ye et kityu tagnaꞌ tiꞌ. ");
INSERT INTO plw_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Angkansa, nerendeman ku na enung sinugid i Begerar Jesus, kwan, ‘Si Juan pemewtismu dut danum, segwaꞌ bewtismuan gasi dimyu dut Nakem et Empuꞌ.’ ");
INSERT INTO plw_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Na baꞌ Empuꞌ negey kedyeng lein Judio et begey et Nakem et Empuꞌ neng samaʼt binggey ye gasi kityu ganang nengandel tyu et Begerar neng si Jesus Kristo, sinu gasi aku apang menglaang et Empuꞌ?” ");
INSERT INTO plw_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Na! Ganang nekingeg dye itue, nemengew ne et pegsawey. Gam lang nememantug dye dut Empuꞌ. Kwan dye, “Angkansa baꞌ kwantin, binggeyan et lawak gasi et Empuꞌ mengeꞌ lein Judio apang megsusun bekeꞌ keisiꞌ dyeʼt bagung biyag na kaya seskeran in.” ");
INSERT INTO plw_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Mendyari nemegpekparak mengeꞌ mengengandel sene tiꞌ sabab et pegsungsang naꞌ neinabu ganang imeteyen si Esteban. Maya nemekerateng dut probinsiya et Penisia, iba gasi dut pulew et Siprus bekeꞌ iba gasi nemekerateng dut lungsud et Antiokia. Misan embe meretengan dye, ipegabar dye beres et Empuꞌ, segwaꞌ dut mengeꞌ tawʼt Judio lang. ");
INSERT INTO plw_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Segwaꞌ maya iba dye neng tawʼt Siprus bekeꞌ tawʼt Sirini na pegdateng dut Antiokia. Pinenulduan dye gasi et Menungang Abar pasal et ki Jesus Kristo dut mengeꞌ tawʼt lein Judio. ");
INSERT INTO plw_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Neset kedye keseg et Begerar neng Empuꞌ apang penulduꞌ bekeꞌ mekansang nemengarap sampay nemengandel et Begerar Jesus. ");
INSERT INTO plw_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Pagkaꞌ neebaran itue et ketingtimungan et mengengandel dut Jerusalem, indyari dinaak dye si Bernabe pesurung dut Antiokia. ");
INSERT INTO plw_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ganang diminateng ne ya, nebiriꞌ ye redyikiꞌ et Empuꞌ eset kedye. Angkansa nenep si Bernabe bekeꞌ pinenginduan ye dye ginsan na daran megmetignaꞌ dut Begerar Jesus eset ginsaʼt kebesagen dye. ");
INSERT INTO plw_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Menungang taaw si Bernabe bekeꞌ ipnuꞌ et Nakem et Empuꞌ sampay mepangger pegandel ye dut Empuꞌ. Angkansa mekansang negegayat dut pengandel eset Begerar. ");
INSERT INTO plw_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Mendyari siminurung si Bernabe dut Tarso apang tulusen ye si Saulo. ");
INSERT INTO plw_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ganang nebiyanan ye ne, pinebayaꞌ ye dut Antiokia. Nemeneteg dye duntin et seled seng teun, sampay nemegtingtimung iba dye mengeꞌ ketingtimungan et mengengandel bekeꞌ nemenulduꞌ duwa dye dut mekansang taaw. Na, dut Antiokia timinagnaꞌ tiningkag na tegesunud i Jesus Kristo ating mengeꞌ “Mengengandel i Kristo”. ");
INSERT INTO plw_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ating masa gasi maya mengeꞌ tarus et Empuꞌ neng nemengdateng et Antiokia teyeg dut Jerusalem. ");
INSERT INTO plw_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Sembatu et kedye timinyeg, ingaran ye si Agabo. Sabab et basag et Nakem et Empuꞌ, negpebunayag ya et maya megderateng kelang urap seʼt sengkedunyaan. Netuman itue masa et timpu i Emperador Klaudio. ");
INSERT INTO plw_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Angkansa, negpikir mengeꞌ mengengandel i Jesus na megpebibit et tabang dut mengeꞌ mengengandel neng memeglelegdeng et Judea sigun et dut megesan et tegsembatu-sembatu kedye. ");
INSERT INTO plw_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Tinuman dye, bekeꞌ pinebibit dye ki Bernabe bekeꞌ ki Saulo tabang dye dut mengeꞌ megurang et megpegtitimungan et mengengandel dut Jerusalem. ");
INSERT INTO plw_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ating masa tinegnanan i Herodes naꞌ Surutan na pineliyutan senung mengeꞌ mengengandel i Jesus. ");
INSERT INTO plw_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Sampay pineimatey ye et tukew si Jakob neng tipused i Juan. ");
INSERT INTO plw_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Pagkaꞌ gasi nerengdeng ye itue pegenepan et mengeꞌ Judio, angkansa si Pedro gasi pinealew ye. Neinabu itue sasa et Kenkaan et pegngeranan naꞌ Bengbang neng Kaya Pikembang. ");
INSERT INTO plw_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ganang nalew ne si Pedro, naꞌ pinepirisu itue, bekeꞌ pinedyeganan et epat neng panen neng teg-epat naꞌ sundalu. Yakin i Herodes iarap si Pedro dut mengeꞌ tawʼt Judio apang ukumen ye pegketbes ating Kenkaan naꞌ pegngeranen gasi et Neketalib. ");
INSERT INTO plw_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Naꞌ si Pedro dun negaʼt seled pipirisuan. Segwaꞌ, mengeꞌ mengengandel kaya bugtuꞌ amay-amay neng pegpenelangan dye et Empuꞌ si Pedro. ");
INSERT INTO plw_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Naꞌ ganang gebi et ating masa na ipeliwan si Pedro i Herodes apang ukumen ye, megigaꞌ si Pedro seʼt pinegketngaan et duwang sundalu. Pegpupungen si Pedro et duwang rantay, bekeꞌ maya nega ibang mengdidyaga kenye dut lelengewan et pipirisuan. ");
INSERT INTO plw_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Sekaliꞌ megtuy maya timinbuꞌ dut kenye sembatung dereakan et Begerar, sampay timinlang dut sisingled et pipirisuan. Kinuritan ye kikilid si Pedro apang tiyagen. Kwaʼt dereakan et Empuꞌ, “Pegbangun sekaliꞌ!” Naꞌ enu takuꞌ, megtuy lang nebabad ating mengeꞌ rantay neng pinungpung mengeꞌ keremut ye in. ");
INSERT INTO plw_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Mendyari kwaʼt dereakan et Empuꞌ kenye, “Naꞌ, pegbadyuꞌ bekeꞌ pegtempaꞌ ne.” Tinuman i Pedro ginsan atin. Indyari sinugid kenye et dereakan et Empuꞌ, kwan, “Peglapis ne et mekapal neng badyuꞌ mu in bekeꞌ pesunud ne daken.” ");
INSERT INTO plw_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Indyari nepesunud et kenye. Liminiwan si Pedro, segwaꞌ ating peginabu kayangga peꞌ sewd i Pedro na banar, keblan yeʼt megteteginep lang. ");
INSERT INTO plw_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ganang netliban dye ating meguna sampay ikeruwang mengdidyaga, nekerateng dye dut besiꞌ neng lelengewan et lungsud. Naꞌ neukaban lang et kwantin yaya ye, bekeꞌ nemengliwan dye. Pegpelembus dyeʼt panew, pegdateng dut sembatung dalan, megtuy ne nalam et kenye ating dereakan et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Indyari, neintetewan i Pedro ating peginabu, angkansa kwan ye, “Tiban ku peꞌ netentuan ginsan! Asal pelan tinahag et Begerar ating dereakan ye apang kelias ku et keremut i Herodes sampay eset mengeꞌ pegyeyekinen et mengeꞌ tawʼt Judio na meinabu daken.” ");
INSERT INTO plw_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ganang nerengdengan i Pedro, siminurung ya dut benwa i Maria neng induꞌ i Juan naꞌ pegngeranan gasi et si Markus. Mekansang mengeꞌ mengengandel duntin nemegtimung et megpenelangin dut Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Timiningkag ne si Pedro dut liwan et lelengewan, sekaliꞌ kiminabiꞌ sembatung budyang naꞌ ketabang et benwa. Ingaran ye si Roda. Inintetew ye baꞌ sinu itiꞌ. ");
INSERT INTO plw_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Pagkaꞌ neintetewan ye pengluluwaan i Pedro bekeꞌ sabab et delen, angkansa kaya ye ne inukaban lelengewan, gamlang negdarak pesled apang ipabar ye na dut liwan et lelengewan si Pedro. ");
INSERT INTO plw_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Sambag dye kwan, “Kas pegdungdupang.” Segwaꞌ leges ye kwan, “Eꞌ be banar si Pedro!” Angkansa kwan dye, “Tetaka dereakan ye ne lang.” ");
INSERT INTO plw_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Segwaꞌ pelembus nega et pegtingkag si Pedro. Mendyari pegukab dyeʼt lelengewan tuun bekeꞌ pegbiriꞌ dye si Pedro ga in. Angkansa nemegliluꞌ dye banar, temed mengmemana. ");
INSERT INTO plw_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Mendyari sininyalan dye i Pedro et endey gumibek. Indyari pineatur kedye i Pedro baꞌ enukwan ya pineliwan et Empuꞌ dut seled pipirisun. Sinugid kedye i Pedro kwan, “Ipenugiraꞌ myu itue dut mengeꞌ ketipusdan neng mengengandel, sampay ki Jakob.” Tebes nugad ne si Pedro pesurung dut ibang lungsud. ");
INSERT INTO plw_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Pegdiklem et keririkleman, naꞌ neriwaraꞌ ne mengeꞌ kesundeluan sabab et pegkalam i Pedro. Diki lang mekira-kira dye baꞌ enu neinabu kenye. ");
INSERT INTO plw_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Angkansa, pinetulus si Pedro i Herodes. Pagkaꞌ kaya dye nebiyanan, sekaliꞌ pinengsumeria ating mengeꞌ mengdidyaga bekeꞌ tuminahag ye na subaliꞌ imeteyen dye ne. Pegketbes timinugpa si Herodes dut Sesarea mawaꞌ et Judea sampay liminegdeng duntin. ");
INSERT INTO plw_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Nekwit na lagi megiseg si Herodes dut mengeꞌ tawʼt Tiro bekeꞌ dut mengeꞌ tawʼt Sidon. Angkansa pinegsulutan dye kumabiꞌ ki Blasto neng pepengendelan ye dut benwa i Herodes. Binisara dye ya na maya tabang ye. Nemenurung dye ki Herodes apang mengangat dye kenye et kesenangan sabab dut bangsa i Herodes pegmewanan et pegkaan et mengeꞌ taaw. ");
INSERT INTO plw_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Pegdateng et eldew et timpu, negbadyuꞌ si Herodes et pekayan et surutan. Narung ye et erung-erungan et metaas, bekeꞌ neres et kedye. ");
INSERT INTO plw_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Segwaꞌ nemengmara mengeꞌ taaw, kwan dye, “Lein lang taaw megbebres, erapun Empuꞌ!” ");
INSERT INTO plw_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Naꞌ megtuy pinesekitan et dereakan et Empuꞌ si Herodes. Kinan ya et mengeꞌ uled bekeꞌ natey, sabab inembuan ye ating kebentugan na subaliꞌ surung dut Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Segwaꞌ pelembus gasi mengabar mengeꞌ mengengandel et beres bekeꞌ bebresen et Empuꞌ apang kiminansang mengeꞌ mengengandel i Jesus. ");
INSERT INTO plw_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Naꞌ ganang netbes dye ne sukuꞌ dye naꞌ keradya, si Bernabe bekeꞌ si Saulo negpeuliꞌ ne dut Antiokia mawaʼt Jerusalem. Pinebayaꞌ dye si Juan neng pegngeranan gasi et si Markus. ");
INSERT INTO plw_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Naꞌ, maya mengeꞌ tarus et Empuꞌ bekeꞌ mengeꞌ menunulduꞌ eset ketingtimungan et mengengandel dut lungsud et Antiokia. Kebayaꞌ na atue de Bernabe, si Simeon na pegtingkagaʼt Negro, si Lusio na tege-Sirene, si Manaen na kesingumur sampay iba et gobernador si Herodes dut Galilea, bekeꞌ si Saulo. ");
INSERT INTO plw_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Sementaraꞌ dye in pemengempuꞌ dut Empuꞌ bekeꞌ pemegpuasa, sinugid eset kedye et Nakem et Empuꞌ, kwan, “Seririaꞌ myu de Bernabe bekeꞌ Saulo dut keradya neng pinanduꞌ ku eset kedye.” ");
INSERT INTO plw_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Pegketbes dye nekepuasa dye bekeꞌ nenelangin, dinatun dye kedyeng mengeꞌ keremut dut duwa, indyari dye in pinepanew ne. ");
INSERT INTO plw_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Angkansa dinaak et Nakem et Empuꞌ, nepekenapan de Bernabe bekeꞌ Saulo dut lungsud neʼt Selusia. Indyari minewanan duntin neglayag pesurung dut pulew et Siprus. ");
INSERT INTO plw_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ganang nekerateng dye dut lungsud et Salamina, ipinebunayag dye beres et Empuꞌ eset mengeꞌ pegtimung-timungan neng sinagoga neng mengeꞌ Judio duntin. Kebayaꞌ dye si Juan Markus bilang ketabang. ");
INSERT INTO plw_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Sineringkuar dyeʼt libut sengkepulewan seked dut lungsud et Papos. Neretengan dye duntin sembatung mememadyik neng Judio na pemelbaal na ya in tarus et Empuꞌ, temed diki ne. Si Bar-Jesus kenyeng ingaran. ");
INSERT INTO plw_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ya in iba i Gobernador Sergio Paulo, sembatung lelaki neng meutek. Pinetingkag et Gobernador de Bernabe bekeꞌ Saulo sabab gaay ye mekingeg beres et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Temed sinegaan dye et mememadyik na si Elimas, ingaran i Bar-Jesus eset bebresaʼt Griego, apang diki mekeandel ki Jesus itueng Gobernador. ");
INSERT INTO plw_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Indyari nepuspus et Nakem et Empuꞌ si Saulo, na pegtingkagan gasi et Pablo, tinengtengan ye si Elimas, bekeꞌ binres et samat kwantin, kwan, ");
INSERT INTO plw_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Ikew yegang i Seytan! Kebanta ke et ginsan neng metignaꞌ! Ipnuꞌ ke et merinundingen bekeꞌ keyeatan! Manu takuꞌ daran mu pegpebulingkeg et keberbenaran tudyu dut Empuꞌ? ");
INSERT INTO plw_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Tiban, meminasa dimu et Begerar naꞌ Empuꞌ! Mebleg ke et mekwit! Diki ke kebiriꞌ et telang et eldew.” Pegketbes megtuy neresanan i Elimas na samat tinegmunan et meiitem neng kunem kenyeng mengeꞌ mata, bekeꞌ ya nenulus et mengdundun kenye. ");
INSERT INTO plw_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ganang nekebiriꞌ et neinabu, nengandel ne ki Jesus itueng Gobernador, bekeꞌ nengliluꞌ ya eset mengeꞌ tulduꞌ tudyu dut Begerar Jesus. ");
INSERT INTO plw_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Mewanan dut lungsud et Papos, nemeglayag ne si Pablo bekeꞌ kenyeng mengeꞌ kesebeyaan dut lungsud et Perga dut probinsiya et Pampilia, temed nepeparak ne si Juan Markus eset kedye bekeꞌ negpeuliꞌ ne dut lungsud et Jerusalem. ");
INSERT INTO plw_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Mewanan dut Perga, neglahyun dye bekeꞌ diminateng dut lungsud et Antiokia na sakup neng Pisidia. Ganang Sabbat, ating Eldew et Kepeternan, siminled dye dut sinagoga bekeꞌ nemengarung. ");
INSERT INTO plw_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Netbes mebatsa mengeꞌ senung bagiꞌ et mengeꞌ elareʼt buuk neng Keseraan bekeꞌ et mengeꞌ tarus et Empuꞌ, negpesugid kedye mengeꞌ pegpemengendelaʼt sinagoga et mengeꞌ Judio, kwan, “Mengeꞌ ketipusdan, na baꞌ maya kew ipenulduꞌ eset mengeꞌ taaw, meres kew ne be!” ");
INSERT INTO plw_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Angkansa timinyeg si Pablo bekeꞌ sininyalan dye na endey megibek. Kwan ye: “Mengeꞌ tawʼt Israelita bekeꞌ mengeꞌ taaw neng lein Judio na pegempuen dye Empuꞌ, kumingeg kew! ");
INSERT INTO plw_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Itueng Empuꞌ et tawʼt Israelita na piniliꞌ et kityung keupuꞌupuan apang megmendyaring taaw Ye. Dye in binuwat Ye et sembatung kelang bangsa sementaraꞌ megeeldeng samat taaw tumpang eset bangsa et Egipto, indyari pineliwan duntin pebiyaꞌ eset Kenyeng kelang kepengyedian. ");
INSERT INTO plw_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Bekeꞌ sinendalan et Empuꞌ mengeꞌ senung salaꞌ dye, sasat dye pegpepanew-panew dut kelnangan seled na samat epat neng pulung teun. ");
INSERT INTO plw_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Pegketbes tepuen et Empuꞌ pitung bangsa eset lugtaꞌ et Kanaan, bekeꞌ binggey Ye itueng lugtaꞌ neng mengeꞌ atin taaw eset Kenyeng taaw neng Israel bilang pusakaꞌ dye. ");
INSERT INTO plw_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Neinabu atin dut seled na samat epat neng gatus limampuluꞌ neng teun. “Pegketbes binggeyan kedye et Empuꞌ et mengeꞌ memimisara seked et timpu ki Samuel naꞌ tarus et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Indyari nemeneew dye et surutan, binggey kedye et Empuꞌ sembatung lelaki mewanan eset tutusan i Benjamin, si Saulo na yegang i Kis. Negsurutan si Saulo seked epat neng pulung teun. ");
INSERT INTO plw_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Indyari ganang ya in inugad et Empuꞌ, pinesubli si Surutan Dabid apang megsurutan eset kedye. Angkansa kwantin pesebanar et Empuꞌ tudyu eset kenye, ‘Nebiyanan ku ki Surutan Dabid na yegang i Jesse lelaking kuyun et atey ku, sembatung lelaki na panyap metuman eset ginsan neng pegtehagan ku.’ ");
INSERT INTO plw_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Mewanan eset tutusan et lelaki neng itue, binggey et Empuꞌ dut bangsa et Israel si Jesus, kenyeng tinangeꞌ na Mekepemawiꞌ. ");
INSERT INTO plw_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Mura diminateng si Jesus, epegtulduꞌ i Juan eset ginsan et taaw dut sengkebengsaan et Israel na teyen megmendyaring pegsusunan na telikuran itueng kedyeng mengeꞌ keselaan bekeꞌ megpebewtismu. ");
INSERT INTO plw_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ganang megketbes ne pegbubuwaten i Juan, sinugid ye dut mengeꞌ taaw, kwan, ‘Sinu be takuꞌ aku eset kira-kira myu? Lein lang aku ating Mememawiꞌ na pegtegeyan myu. Temed ya megderateng na pesusunud ne eset daken. Indyari diki aku merapat megmendyaring misan tegeugad mene et tampaꞌ Ye samat buwaten et uripen.’ ");
INSERT INTO plw_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Mengeꞌ ketipusdan ku neng mawaꞌ dut duguꞌ i Abraham, bekeꞌ eset mengeꞌ taaw neng lein Judio na pengempuꞌ dut Empuꞌ, kityu key pinebitan et abar ne itue petudyu dut kepuwasan. ");
INSERT INTO plw_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Kaya lang pegkilelanen et mengeꞌ megeeldeng eset lungsud et Jerusalem bekeꞌ kedyeng pegibuten na si Jesus itueng Mememawiꞌ dinaak et Empuꞌ. Kaya dye gasi pegpikiren mengeꞌ teked et mengeꞌ tarus et Empuꞌ na pegbetsaen kede Eldew et Kepeternan; temed dye key gasi nekepetuman et peneked na atin ganang betangan dye et kepeteyan si Jesus. ");
INSERT INTO plw_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Megdemikian misan dye in kaya lang meget neng keterangan apang ya in dusaen et kepeteyan, pegtewen dye nega ki Pilato na ya in ipepatey. ");
INSERT INTO plw_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Indyari ganang metuman dye ne ginsan neng nesusurat petudyu eset kenye, maya mengeꞌ taaw na insiꞌ dye ya dut krus et kayu bekeꞌ limbeng dye ne eset gieb et batu. ");
INSERT INTO plw_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Temed ya in binyag peuliꞌ et Empuꞌ! ");
INSERT INTO plw_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Indyari dut seled et mekansang neng eldew nepebiriꞌ eset mengeꞌ nememayaꞌ kenye ganang ya in siminurung ne dut lungsud et Jerusalem mewanan dut probinsiya et Galilea. Tiban dye ne in mengeꞌ saksiꞌ ye eset kityung mengeꞌ tawʼt Israelita. ");
INSERT INTO plw_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Indyari atuꞌ kay apang ipebunayag eset dimyu itueng mengeꞌ Menungang Abar. Itue ne mengeꞌ tinangeꞌ et Empuꞌ eset kityung mengeꞌ kegunggurangan, ");
INSERT INTO plw_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","na kenyeng tinuman eset kityu neng tutusan dye ganang biyagen ye peuliꞌ si Jesus. Itue ne nesurat eset ikeruwang Kanta, kwan, ‘Ikew daken neng Yegang, tiban Aku mengdyaring dimung Amaꞌ.’ ");
INSERT INTO plw_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Pesalan et pegkebiyag peuliꞌ eset kenye apang diki mekelabay et pegkeburuk, kwantin gasi tinangeꞌ et Empuꞌ dut mengeꞌ taaw Ye, kwan, ‘Ibgey ku dimyu pasek metignaꞌ bekeꞌ meerepeng peruntungan, na tinangeꞌ ku ki Surutan Dabid.’ ");
INSERT INTO plw_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Indyari sinugid gasi dut ibang Kanta i Dabid, kwan, ‘Diki mu itugut na mekerasa et pegkeburuk dimung pasek metignaꞌ.’ ");
INSERT INTO plw_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Ganang metuman i Surutan Dabid itueng sedseleran et Empuꞌ eset kebiyagan ye, ya in natey bekeꞌ limbeng eset seled lelbengan et kenyeng mengeꞌ kenggurangan bekeꞌ nekelabay et pegkeburuk. ");
INSERT INTO plw_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Segwaꞌ si Jesus na binyag peuliꞌ et Empuꞌ na diki nekelabay et pegkeburuk. ");
INSERT INTO plw_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Angkansa mengeꞌ ketipusdan, merapat na mesewran myu teyen, na pegtulduꞌ eset dimyu na itueng pegpeampun et keselaan pebiyaꞌ et kebuwaten i Jesus. ");
INSERT INTO plw_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Indyari ginsan neng mengandel eset kenye pegempunen eset ginsan neng keselaang diki mekepegampun eset dimyu pebiyaꞌ eset pegtuman et Keseraan binggey ki Moises. ");
INSERT INTO plw_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Angkansa meginget kew apang diki meinabu eset dimyu itueng sinugid et Empuꞌ pebiyaꞌ mengeꞌ tarus Ye, ");
INSERT INTO plw_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","kwan dye, ‘Kira-kiranaꞌ myu, kemyung mepengdupang! Memeknegan kew bekeꞌ medusaan sampay mepatey! Sabab buwaten ku eset dimyung ketimpuan, sembatung ginis na diki myu endelen, misan maya ne menuturan itue eset dimyu!’ ” ");
INSERT INTO plw_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ganang megliliwan neʼt sinagoga si Pablo bekeꞌ si Bernabe, ginayat dye et mengeꞌ taaw na meres peuliꞌ pasal eset mengeꞌ indeginis na itue eset sumunud ne Eldew et Kepeternan. ");
INSERT INTO plw_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Pegketbes et tingtimung, nemenelundug kire Pablo bekeꞌ Bernabe mekansang neng Judio bekeꞌ negayat eset egama et Judaismo. Negberes eset kedye itueng mengeꞌ bibilinan de Pablo bekeꞌ tinulduan dye na megpelahyun eset pengebiyagan neng sugat eset redyikiꞌ et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ganang siminunud Eldew et Kepeternan, lengku ginsan neng mengeꞌ taaw eset lungsud in netimung ne apang kinggen beres et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Nemengimbeng ne mengeꞌ tawʼt Judio ganang nebiriꞌ dye nemegsitsiet neng mengeꞌ taaw, angkansa nileew dye bekeꞌ binelebagan ginsan neng pegsugiren i Pablo. ");
INSERT INTO plw_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Temed mekseg na sinugid de Pablo bekeꞌ Bernabe, kwan, “Dut dimyu mena merapat ipebunayag beres et Empuꞌ. Pigay sinikwey myu ne itue, bekeꞌ inukum myu dimyung bilug na diki merapat eset biyag na kaya seskeran, angkansa sumurung kay dut mengeꞌ lein Judio apang mengabar itueng Menungang Abar. ");
INSERT INTO plw_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Sabab kwantin tinahag damen et Begerar, ‘Binetang ku ikew na megmendyaring siluꞌ et mengeꞌ tawʼt lein Judio apang mepebunayag mu kepuwasan ku seked dut kepuspus et dunyaꞌ.’ ” ");
INSERT INTO plw_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ganang mekingeg itue mengeꞌ tawʼt lein Judio, nenep dye bekeꞌ megbantug dut Empuꞌ sabab eset beres Ye. Bekeꞌ ginsan dye ne nepiliꞌ et Empuꞌ apang maya biyag na kaya seskeran, nemengandel dye ne. ");
INSERT INTO plw_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Angkansa liminatap eset sengketelingkepaʼt kelugtaan itueng beres et Empuꞌ pasal ki Begerar Jesus. ");
INSERT INTO plw_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Temed sinutsutan et mengeꞌ tawʼt Judio na kaya mengandel mengeꞌ kelilibunang meinempuen eset Empuꞌ bekeꞌ kilala dut keneldaman, megsepantun gasi mengeꞌ pegibuten neng kelelekiaʼt lungsud, apang ineriwaraꞌ dye de Pablo bekeꞌ Bernabe, pegketbes pineugad dye eset lugtang atin. ");
INSERT INTO plw_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Angkansa tinultug et duwa in tehuk eset kedyeng mengeꞌ tiked bilang saksiꞌ atu eset mengeꞌ tawʼt esentin, indyari dye in siminurung ne dut lungsud et Ikonio. ");
INSERT INTO plw_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Nebaha neʼt enep bekeꞌ et Nakem et Empuꞌ mengeꞌ mengengandel eset lungsud Antiokia. ");
INSERT INTO plw_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Megsepantun kwantin gasi neinabu eset lungsud et Ikonio, de Pablo bekeꞌ de Bernabe siminled dut pegtimung-timungan neng sinagoga et mengeꞌ Judio. Pegeyaran dye ne menulduꞌ, angkansa mekansang tawʼt Judio bekeꞌ tawʼt Griego negandel. ");
INSERT INTO plw_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Segwaꞌ maya mengeꞌ tawʼt Judio mendiꞌ mengandel. Indyari sinutsutan dye mengeꞌ lein Judio bekeꞌ pegekalan pikiran et mengeꞌ itue atu eset mengeꞌ mengengandel. ");
INSERT INTO plw_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Angkansa nekwit-kwit gasi timineteg duntin de Pablo bekeꞌ Bernabe, indyari mekseg na nenulduꞌ pasal eset Begerar Jesus. Pinesebaran gasi i Jesus na tantu penulduꞌ dye eset itueng bebresan pasal et redyikiꞌ Ye pebiyaꞌ et kepengyedian na binggey eset kedye na memuwat et mengeꞌ tendaꞌ bekeꞌ keliꞌlilung keradya. ");
INSERT INTO plw_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Angkansa netahak mengeꞌ taaw eset lungsud. Diminapit iba eset mengeꞌ tawʼt Judio neng kaya mengandel bekeꞌ iba gasi eset mengeꞌ bibilinan. ");
INSERT INTO plw_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Negpanyap megtuy mengeꞌ lein Judio bekeꞌ mengeꞌ tawʼt Judio kebayaꞌ kedyeng mengeꞌ pegibuten atu eset mengeꞌ bibilinan. Pinaru dye na dupangen bekeꞌ pemakalen dye et batu seked patey. ");
INSERT INTO plw_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Temed ganang mesewran itue et mengeꞌ bibilinan, nememelegyu dye ne pesurung dut lungsud et Listra bekeꞌ lungsud et Derbe eset mengeꞌ lungsud et Likaonia, bekeꞌ eset kelugtaan na pelibut. ");
INSERT INTO plw_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Indyari duntin dye ne pinenulduꞌ itueng Menungang Abar. ");
INSERT INTO plw_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Dut lungsud et Listra, maya sembatung lelaki na diki mekepanew, sabab ya in pangkul mewanan nega et sengkeganak. ");
INSERT INTO plw_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Megearung ya na megkikingeg eset penulduꞌ i Pablo. Ganang mebiriꞌ i Pablo na itueng pangkul maya pengandel apang megulinan, tinengtengan ye itue. ");
INSERT INTO plw_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Indyari mebasag na negberes si Pablo, kwan, “Tumyeg ke et metignaꞌ!” Pegketbes limineksut megtuy itueng lelaki bekeꞌ negpanew-panew. ");
INSERT INTO plw_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ganang nebiriꞌ et mengeꞌ tawʼt lungsud itueng binuwat i Pablo, neres dye et mebasag eset bebresaʼt Likaonia, na kwan, “Nineug kityu mengeꞌ empuꞌ na negdagbes et taaw!” ");
INSERT INTO plw_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ngineranan dyeʼt empuꞌ Seus si Bernabe, bekeꞌ empuꞌ Hermes gasi itueng si Pablo sabab ya tegepegberes. ");
INSERT INTO plw_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Eset pegseled et lungsud maya templo i empuꞌ Seus. Ganang nekingeg et pariꞌ et Seus na kwantin neinabu, ya sampay mengeꞌ tawʼt lungsud nemibit et mengeꞌ mendangan neng sapiꞌ sampay mengeꞌ gantung liyeg na bukburak apang isimayaꞌ dye eset mengeꞌ bibilinan. ");
INSERT INTO plw_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ganang nesewran itue de Bernabe bekeꞌ i Pablo, pinenguyat dye kedyeng badyuꞌ apang ipebiriꞌ iseg bekeꞌ rupuk dye, pegketbes diminarak dye na petngaꞌ dut mengeꞌ taaw. Nemegberes dye et mebasag, kwan, ");
INSERT INTO plw_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Mengeꞌ kelelekian, kasiꞌ myu pegbuwataꞌ atin! Kami tuꞌ mengeꞌ taaw gasi na saliꞌ myu! Pegtulduꞌ kay dimyu itueng Menungang Abar pasal i Begerar Jesus apang telikuran myu mengeꞌ ginisan na itue na kaya kepulusan, bekeꞌ megpeuliꞌ kew eset tantu neng Empuꞌ na biyagan na ya neguna et langit, lugtaꞌ, dagat bekeꞌ dut ginsan neng mengeꞌ esentin. ");
INSERT INTO plw_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Itit nekelabay neng mengeꞌ timpu, pinesaran et Empuꞌ dut ginsan neng bangsa na telinganen et kedye-kedyeng keinginan. ");
INSERT INTO plw_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Segwaꞌ nenggey ya et sugat neng keterangan apang mekilala myu ya pebiyaꞌ et kenunganang pegbuwaten ye eset dimyu. Pegbegeyan ye kemyu et delek mewanan dut langit bekeꞌ kelang mekekeyg eset sugat neng timpu. Pepebiyagan ye kemyu et kekanen bekeꞌ pinupuspus et keenepan dimyung atey.” ");
INSERT INTO plw_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Dut sembelang mengeꞌ bebresang itue, mekeliyutan dye nega et pegpetngew eset mengeꞌ taaw eset pegsisimayaꞌ eset kedye. ");
INSERT INTO plw_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Segwaꞌ maya mengeꞌ tawʼt Judio diminateng duntin mewanan eset lungsud et Antiokia bekeꞌ lungsud et Ikonio. Sinutsutan dye mengeꞌ taaw atu ki Pablo bekeꞌ eset kedyeng pinemakal na ya ne in. Pegketbes, ginuyud ya peliwan et lungsud, eset kira-kira dye na patey ne. ");
INSERT INTO plw_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Segwaꞌ ganang pelibutan ya et mengeꞌ mengengandel, timinyeg si Pablo bekeꞌ siminled dut lungsud. Kinedikleman, siminurung duwa dye de Bernabe dut lungsud et Derbe. ");
INSERT INTO plw_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pegtulduꞌ de Pablo bekeꞌ Bernabe Menungang Abar dut lungsud et Derbe, bekeꞌ mekansang negayat dye na megmendyaring mengengandel i Jesus. Pegketbes, negpeuliꞌ dye ne dut mengeꞌ lungsud et Listra bekeꞌ Ikonio sampay dut lungsud et Antiokia et Pisidia. ");
INSERT INTO plw_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Pinepangger dye seled et mengeꞌ mengengandel bekeꞌ pinituanan na dumaran tantu eset pengandel dye. Penulduꞌ dye eset kedye, kwan, “Kityu mekelabay mena et mekansang neng kesusaan mura mekesled dut pengmilikan et Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Dut kede ketingtimungan et mengengandel, nemekegerar dye ne et mengeꞌ megurang mekepegewla, bekeꞌ metbes lang na negpenalang dye sampay negpuasa, na mengeꞌ itue na ipinengandel dye eset Begerar Jesus na kedyeng pegendelen. ");
INSERT INTO plw_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pinenewan dye na timinalib et probinsiya et Pisidia bekeꞌ nemekerateng dut probinsiya et Pampilia. ");
INSERT INTO plw_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Pinenulduꞌ dye beres et Empuꞌ dut lungsud et Perga, bekeꞌ pegketbes nepekenapan dye dut lungsud et Atalia. ");
INSERT INTO plw_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Mewanan duntin, neglayag dye peseuliꞌ dut lungsud et Antiokia. Esentin dye in nepengandel tagnaꞌ eset redyikiꞌ et Empuꞌ apang kebuwat dye et keradya na pinegbuwatan dye ne in. ");
INSERT INTO plw_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Pegdateng duntin, tinimung dye mengeꞌ kesakup eset ketingtimungan et mengengandel bekeꞌ tinuturan ginsan binuwat et Empuꞌ pebiyaꞌ kedye, bekeꞌ na baꞌ enukwan tinegnanan ye dalan apang mekepengandel mengeꞌ tawʼt lein Judio. ");
INSERT INTO plw_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Indyari nekwit neng timpu timinerna dye duntin, kebayaꞌ et mengeꞌ mengengandel i Jesus eset Antiokia. ");
INSERT INTO plw_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Maya senung lelaki nemengdateng eset lungsud et Antiokia, minewanan dut probinsiya et Judea bekeꞌ nemenulduꞌ eset mengeꞌ ketipusdan na samat kwantin, kwan, “Na baꞌ diki kew megpetuliꞌ kuyun dut Keseraan et Empuꞌ na binggey ki Moises, diki mekebawiꞌ Empuꞌ dimyu et kedusaan myu.” ");
INSERT INTO plw_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Sinegkaan itue de Pablo bekeꞌ i Bernabe bekeꞌ nemegbeꞌbanta dye banar ne sabab et itue. Angkansa nepegsulutan na peruntinen dut Jerusalem de Pablo bekeꞌ si Bernabe bekeꞌ megbebayaꞌ mengeꞌ senung mengengandel apang mepegsugsugiran et mengeꞌ bibilinan i Jesus Kristo sampay mengeꞌ megugurang tudyu eset kesusaang itue. ");
INSERT INTO plw_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Indyari dye in tinahag et mengeꞌ mengengandel dut lungsud et Antiokia, bekeꞌ sasat megpepanew de Pablo bekeꞌ si Bernabe eset probinsiya et Penisia bekeꞌ Samaria, pineabar dye ne mengeꞌ leing tawʼt Judio negmendyaring nemengandel ne. Na nemekeksanan ne banar mengeꞌ mengengandel et Empuꞌ eset kedyeng pineabar. ");
INSERT INTO plw_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Pegdateng dut Jerusalem, menungang pegterimaꞌ kedye eset mengeꞌ pegtingtimung et mengeꞌ mengengandel sampay mengeꞌ bibilinan i Jesus, sampay mengeꞌ megugurang. Pegketbes tinuturan dye ginsan neng mengeꞌ pinebuwat et Empuꞌ pebiyaꞌ eset kedye. ");
INSERT INTO plw_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Temed timinyeg mengeꞌ senung mengengandel et Empuꞌ kebayaꞌ eset rupung et mengeꞌ Pariseo bekeꞌ kwan dye, “Subaliꞌ metuliꞌ mengeꞌ lein-leing mengeꞌ taaw naꞌ mengengandel bekeꞌ tehagen tumuman eset Keseraan et Empuꞌ na binggey ki Moises.” ");
INSERT INTO plw_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Nemegsugsugid mengeꞌ bibilinan bekeꞌ mengeꞌ megugurang apang mepikiran pasal et itueng mengeꞌ kesusaan. ");
INSERT INTO plw_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Pegketbes et nekwit neng pegbisara, timinyeg si Pedro bekeꞌ kwan ye, “Mengeꞌ ketipusdan, nesewran myu nekeunang nekelabay neng mengeꞌ eldew piniliꞌ ne aku et Empuꞌ dut dimyu, naꞌ pebiyaꞌ eset daken mengeꞌ lein Judio na mekekingeg dye et Menungang Abar pasal ki Jesus, bekeꞌ dye gasi na nemengandel. ");
INSERT INTO plw_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Mekesewran et Empuꞌ seled pikiran et taaw. Pinebiriꞌ Ye ne Kenyeng pegterima dut mengeꞌ lein Judio pebiyaꞌ et pegbegey ye et Nakem et Empuꞌ, samat binggey Ye kityu. ");
INSERT INTO plw_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Pinebiriꞌ et Empuꞌ na kaya ne pinekeleinen kityu mengeꞌ Judio bekeꞌ dyeng mengeꞌ lein Judio. Inampun gasi et Empuꞌ kedyeng mengeꞌ keselaan sabab et pegandel dye et ki Jesus Kristo.” ");
INSERT INTO plw_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Na nengingkut si Pedro, “Manu takuꞌ peggeayen myu nega miseg Empuꞌ sabab kemyu peniksaꞌ et keliyutan dut mengeꞌ mengengandel eset Empuꞌ? Isugiraꞌ kedye na mibut et Keseraan, lebi ne misan mengeꞌ keupuꞌupuan sampay kityu diki megmendyaring buwaten itue. ");
INSERT INTO plw_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Na endey lang! Nemengandel tyu ki Jesus na Begerar, bekeꞌ melayam tyu eset keselaan tyu sabab et kenyeng redyikiꞌ kityu. Megsepantun gasi puwasen et Empuꞌ mengeꞌ taaw minewanan dut mengeꞌ lein-leing bangsa.” ");
INSERT INTO plw_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Nepehendeng ginsan neng kinensangan. Nemengingeg dye ne ki Bernabe bekeꞌ ki Pablo sasat penuturan pasal et mengeꞌ keliluꞌlilung tendaꞌ na nebuwat dye pebiyaꞌ eset basag et Empuꞌ, na baꞌ embe esentin dye eset mengeꞌ taaw na lein Judio. ");
INSERT INTO plw_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Pegketbes dye tuturanen, si Jakob gasi nepesubli neres, kwan ye, “Mengeꞌ ketipusdan, kingeg kew daken! ");
INSERT INTO plw_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Ketetbes lang ituturan i Pedro dimyu tiban pasal baꞌ enukwan pinebiriꞌ et Empuꞌ kenyeng kasi dut mengeꞌ lein Judio apang misiꞌ dut kedye mengeꞌ taaw gasi megmendyaring taaw et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Kuyun dut Kesuratan et Empuꞌ, na atin sinugid i Pedro pinegsulutan ye na sinurat et tarus et Empuꞌ tagnaꞌ, kwan, ");
INSERT INTO plw_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Pegketbes et itue peuliꞌ ku nega, bekeꞌ ipetiyeg ku peuliꞌ milikan tagnaꞌ i Surutan Dabid neng nerumbak. Inunganen ku sebarang maya nerungkat in sampay baalan kut milikan ye peuliꞌ! ");
INSERT INTO plw_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Apang kebiyaꞌ et Empuꞌ ginsan et mengeꞌ taaw minewanan dut lein-leing bangsa, atin mengeꞌ taaw lein Judio, ginsan dye na piniliꞌ ku gasi. ");
INSERT INTO plw_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Itue bebresen et Begerar, pinesewd ye itueng ginis dut mengeꞌ taaw sengketegnaan.’ ” ");
INSERT INTO plw_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Kwan gasi i Jakob, “Daken neng keinginan, endey tyu sesewen mengeꞌ taaw neng lein Judio na pegandel dut Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Temed, subaliꞌ tyu dye pebibitan et surat, isugid kedye na endey mengaan et mengeꞌ indeginis na mepelamak dut mengeꞌ empuꞌempuan sabab antangen ye meririꞌ ne atin kityu. Sampay, subaliꞌ endey dye mekibeis, subaliꞌ endey dye mengaan et binikel neng setwaꞌ, sampay endey dye mengaan et duguꞌ. ");
INSERT INTO plw_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Sabab itueng Keseraan na binggey et Empuꞌ ki Moises, tagnaꞌ nega tinulduꞌ dut ginsan neng mengeꞌ lungsud bekeꞌ pegbetsaan kede Eldew et Kepeternan dut mengeꞌ pengempuan naꞌ benwa et mengeꞌ Judio.” ");
INSERT INTO plw_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Angkansa minenunga et mengeꞌ bibilinan bekeꞌ mengeꞌ pegibuten et ketingtimungan sampay ginsan neng megpengandel ki Jesus mekepikir memiliꞌ et senung mengeꞌ lelaki eset kedye megbeꞌbayaꞌ ki Pablo bekeꞌ ki Bernabe dut lungsud et Antiokia. Piniliꞌ dye si Judas na pegngeranan et Barsabas, bekeꞌ si Silas, duwang taaw na peguntebien eset mengeꞌ mengengandel. ");
INSERT INTO plw_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Si Judas bekeꞌ si Silas megbibibit et surat na samat kwantin, betsaen: “Itueng surat minewanan dut dimyung ketipusdan, mengeꞌ bibilinan et Begerar, bekeꞌ mengeꞌ megurang atueʼt lungsud et Jerusalem. Pinebibit kay itue dut ginsan et mengeꞌ mengengandel na lein Judio megeldeng eset lungsud et Antiokia, probinsiya et Siria, bekeꞌ probinsiya et Silisia. Pegpenglingen kay kemyu esentin. ");
INSERT INTO plw_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","“Maya neebaran kay, minewanan damen ne megesentin megsasew et dimyung pikiran sabab et kedyeng ketulduan. Kaya atin dinaak kay na buwaten dye. ");
INSERT INTO plw_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Angkansa, nepegsulutan kay na nemiliꞌ et taaw atue mepebibit eset dimyu. Ipebibit kay gasi dimyu si Bernabe sampay si Pablo, mengeꞌ biꞌbilaꞌ na meingin banar. ");
INSERT INTO plw_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Itueng duwa si Pablo bekeꞌ si Bernabe kaya ne pinren dye kedyeng kebiyagan pegkeradya eset kityung Begerar naꞌ si Jesus Kristo. ");
INSERT INTO plw_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Na angkansa pinebibit kay dimyu de Judas bekeꞌ si Silas, apang megsugid dimyu eset elepan myu samat baꞌ enu dameng nesurat. ");
INSERT INTO plw_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Na atin Nakem et Empuꞌ bekeꞌ kami nemegsulut ne na endey pebegatan selyu lang itueng ketehagan na keilangan banar: ");
INSERT INTO plw_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Endey mengaan et indeginis na mepelamak dut mengeꞌ empuꞌempuan, endey mengaan et duguꞌ, endey ne mengaan et binikel neng setwaꞌ, bekeꞌ endey mekibeis. Na baꞌ pekerayu kew et mengeꞌ arat na atin, ikenunga dimyu. Seked atue lang. Pegnunga-nunga kew ne.” ");
INSERT INTO plw_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Indyari pinepanew mengeꞌ tetehagen. Pegdateng eset Antiokia, tinimung dye et mengeꞌ ketipusdan na pemengandel ki Jesus bekeꞌ binggey kedye surat. ");
INSERT INTO plw_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ganang nebatsaꞌ ne et mengeꞌ taaw itueng surat, nemegenep dye kuyun eset bebresen neng megpebasag na kedyeng nekingeg. ");
INSERT INTO plw_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Si Judas bekeꞌ si Silas naꞌ mengeꞌ tarus et Empuꞌ gasi, mekansang sinugid eset mengeꞌ ketipusdan na megmendyaring nepebasag bekeꞌ nepeteger eset kedyeng pegandel. ");
INSERT INTO plw_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Itueng duwa nemenerna et mengeꞌ senung linggu duntin. Pegketbes, dye nepeuliꞌ dut mengeꞌ nenahag kedye. Mura dye minanew, nemegtimung mengeꞌ mengengandel apang pegpenelang dye et kesenangan kedye na tudyu eset kedyeng pepenewan. ");
INSERT INTO plw_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Segwaꞌ ginaay i Silas tumeteg duntin. ");
INSERT INTO plw_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Temed nepetektak nega si Pablo bekeꞌ si Bernabe eset lungsud et Antiokia. Mekansang nega megbebayaꞌ iba dye menunulduꞌ bekeꞌ nengabar et bebresen et Begerar Jesus. ");
INSERT INTO plw_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Pegketbes et mengeꞌ senung eldew, sinugid i Pablo ki Bernabe, kwan, “Seulinen te bekeꞌ beritanen kiteng mengeꞌ ketipusdan ki Jesus dut mengeꞌ lungsud naꞌ baꞌ embe nepeebaran teʼt beres et Empuꞌ, supaya mesewran te baꞌ enu nega kebtangan dye.” ");
INSERT INTO plw_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Gaay i Bernabe ipebayaꞌ si Juan na pegngeranen et Markus. ");
INSERT INTO plw_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Temed eset seled pikiran i Pablo, mendiꞌ ye ipebayaꞌ si Markus kedye, sabab kaya ye negpelahyun nayaꞌ eset kedyeng bubuwaten, imbes nepeparak ye kedye dut probinsiya et Pampilia. ");
INSERT INTO plw_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Banar na nemegsegsagkaꞌ duwa dye in, bekeꞌ nemegparak kede sembatu. Pinebayaꞌ i Bernabe si Markus bekeꞌ neglayag dye pesurung dut pulew et Siprus. ");
INSERT INTO plw_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Temed si Pablo piniliꞌ ye si Silas bekeꞌ nemenyeg ne. Mengeꞌ ketipusdan nemengarap ne dut Empuꞌ na dyeganan dye et redyikiꞌ et Begerar. ");
INSERT INTO plw_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Pinanew de Silas bekeꞌ si Pablo dut probinsiya et Siria bekeꞌ probinsiya et Silisia bekeꞌ pinepangger dye mengeꞌ mengengandel esentin. ");
INSERT INTO plw_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Diminuntin gasi si Pablo dut lungsud et Derbe bekeꞌ lungsud et Listra. Indyari maya sembatung mengengandel duntin na ingaran ye si Timoteo. Induꞌ ye sembatu gasi mengengandel na tawʼt Judio, temed kenyeng amaꞌ tawʼt Griego. ");
INSERT INTO plw_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Pinesebenaran et mengeꞌ ketipusdan dut lungsud et Listra bekeꞌ lungsud et Ikonio na menungang taaw si Timoteo. ");
INSERT INTO plw_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Gaay i Pablo ipebaya si Timoteo. Temed nesewran et ginsan neng mengeꞌ tawʼt Judio na amaꞌ ye Griego, angkansa tinuliꞌ ye itue supaya penguntebien ya et mengeꞌ tawʼt Judio. ");
INSERT INTO plw_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Sebarang meteliban de Pablo mengeꞌ kelungsud-lungsuran, pegpeabar dye dut mengeꞌ mengengandel na nepegsulutan et mengeꞌ bibilinan bekeꞌ mengeꞌ megugurang dut Jerusalem. Sinugid kedye na endelen itueng mengeꞌ saraꞌ. ");
INSERT INTO plw_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Angkansa mengeꞌ mengengandel negmendyaring mepangger et kedyeng pegandel bekeꞌ eldew-peldew mekansang nepelamud naꞌ bagung mengengandel. ");
INSERT INTO plw_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","De Pablo bekeꞌ iba ye, nememanew surung dut pinegketngaan et probinsiya et Prigia bekeꞌ probinsiya et Galasia sabab itueng Nakem et Empuꞌ kaya tinugutan dye na dumuʼt probinsiya et Asia supaya ipengabar beres et Empuꞌ duntin. ");
INSERT INTO plw_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ganang nekerateng dye ne eset seled et probinsiya Misia, sinulayan dye teyen sumurung dut probinsiya et Bitinia, segwaꞌ ating Nakem i Jesus kaya timinugut kedye. ");
INSERT INTO plw_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Angkansa megtuy dye timinalib dut pinegketngaaʼt probinsiya et Misia, ampaꞌ ne negleslembus dye ne dut lungsud et Troas. ");
INSERT INTO plw_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Atin neng gebi, neketeginep si Pablo et sembatung lelaki na tawʼt Masedonia megtitiyeg bekeꞌ megpeingasiꞌ kenye, kwan, “Maniꞌ ke dut probinsiya et Masedonia bekeꞌ tebangiꞌ kay!” ");
INSERT INTO plw_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Ganang kwantin neteginep i Pablo, negpanyap kay ne megtuy supaya mugad dut Masedonia, sabab nepikiran kay ne nepesewd ne damen Empuꞌ, na menulduꞌ et Menungang Abar eset mengeꞌ taaw duntin. ");
INSERT INTO plw_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Indyari, minewanan eset lungsud et Troas, neglenlahyun kay neglayag pesurung dut pulew et Samotrasia, bekeꞌ pegdateng et sembatung eldew dut lungsud et Neapolis. ");
INSERT INTO plw_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Mewanan duntin diminuntin kay dut lungsud et Pilipos, unang bagiʼt probinsiya et Masedonia. Na itue gasi pegeldengan et mekansang neng mengeꞌ tawʼt lungsud et Roma. Timinerna kay et mengeꞌ senung eldew duntin. ");
INSERT INTO plw_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Pegdateng dut Eldew et Kepeternan, siminurung kay dut peliwan et lungsud atin dut abit danum, na baꞌ embe nepikiran kay maya esentin pegpepenelangan et mengeꞌ tawʼt Judio. Narung kay bekeꞌ nenuturan eset mengeꞌ kelilibunan na pemegrungrupung esentin. ");
INSERT INTO plw_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Sembatung libun na megkikingeg damen pegngeranen ye Lidia minewanan ye dut probinsiya et Tiatira. Kenyeng pegkeredyanen pepegelen et mergang tela saat naꞌ meregang. Ya pemantug dut Empuꞌ, bekeꞌ Begerar neng Empuꞌ nenggey kenye et pikiran na mengingeg baꞌ enu itueng pegbebersen i Pablo, bekeꞌ nengandel ne ya. ");
INSERT INTO plw_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Negpebewtismu ne ya bekeꞌ mengeꞌ kenyeng kesengbenwa. Indyari nenggayat ne ya damen, kwan ye, “Aniꞌ kew bekeꞌ tumerna dut benwa kay, baꞌ dut seled pikiran myu na aku pesebenaran nengandel ne dut Begerar neng Empuꞌ!” Indyari neewiran ye ne kami. ");
INSERT INTO plw_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Sembatung eldew ganang megsusurung kay dut pegpepenelenganan, nesusup kay sembatung libung uripen naꞌ yegang. Ating uripen pegseselban et meraat neng diwata na megbebegey kenye et kepengyediang meketeked na baꞌ enu meinabu. Kelaꞌ pirak neprian et mengeꞌ begerar ye sabab et kenyeng peneked. ");
INSERT INTO plw_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Pegsudsunuran ye kami de Pablo bekeꞌ megebres et mebasag samat kwantin, kwan ye, “Itueng mengeꞌ taaw na tetehagen et pineketaas na Empuꞌ Banar dut Langit! Pegpeabar dye dimyu baꞌ enukwan Empuꞌ kebawiꞌ dimyu!” ");
INSERT INTO plw_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Sabab mekansang neng eldew pegbubuwaten ye itue, nerekerek ne si Pablo. Angkansa, inarap ye ne yegang in, bekeꞌ binres ye set meyaat neng diwata, kwan ye, “Pegtetehagen ku ikew eset kepengyedian et ingaran i Jesus Kristo, ‘Lumiwan ke eset bilug et itueng libun!’ ” Megtuy na liminiwan itueng meraat neng diwata. Na tiban, itueng libun diki ne megmendyaring menekedteked. ");
INSERT INTO plw_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ganang nebiriꞌ et mengeꞌ begerar et ating yegang na neugaran dye net meeprian, inalew dye de Pablo bekeꞌ si Silas rinayak pesurung dut mengeꞌ pegibuten neng kinensangaʼt mengeꞌ taaw. ");
INSERT INTO plw_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Nenindal dye eset mengeꞌ pegibuten et lungsud et Roma bekeꞌ itue kwan dye, “Itueng mengeꞌ taaw, tawʼt Judio, dye in pemengungkar et dameng lungsud. ");
INSERT INTO plw_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Megpenulduꞌ dye et mengeꞌ arat sungsang eset ketehagan et kityung mengeꞌ tawʼt Romano. Diki mekedyari terimanen etawa telinganen atin neng keeratan.” ");
INSERT INTO plw_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Nemengagap kedye mengeꞌ taaw bekeꞌ pegketbes na dye na beklewan et mengeꞌ pegibuten, de Pablo bekeꞌ si Silas peseuliꞌseuliꞌ ne lepsan. ");
INSERT INTO plw_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Pegketbes na dye melipak, pinirisu dye ne. Nenahag itueng mengeꞌ pegibuten eset mengdidyaga na tengleben et meget ating lelengewan neng pipirisuan. ");
INSERT INTO plw_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Pegketerima dye et ating daak, megtuy binibit dut pinekesisingled et pipirisuan bekeꞌ kedyeng tiked sinuub dut dinlangan neng kayu. ");
INSERT INTO plw_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ganang megtetengaꞌ gebi ne de Pablo bekeꞌ si Silas negpenalang bekeꞌ negkanta et kekantaan et Empuꞌ na megbebantug, bekeꞌ ibang mengeꞌ nepipirisu in memegkikingeg gasi kedye. ");
INSERT INTO plw_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Kiminlat lang pegliglinug et lugtaꞌ naꞌ mebasag, angkansa yiminegyeg sampay mengeꞌ penued et pipirisuan. Pegketbes neukaban mengeꞌ lelengewan bekeꞌ nepepagtiꞌ mengeꞌ besiꞌ na pesisiget eset ginsaʼt mengeꞌ nepipirisu in. ");
INSERT INTO plw_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Naꞌ, negbanguʼt suiꞌ lang itueng mengdidyagaʼt pipirisuan, indyari ganang nebiriꞌ ye ukab ne lawang keblan ye nemekepelegyu ne mengeꞌ nepipirisu in. Angkansa, ginabut ye kenyeng keterman bekeꞌ imeteyen ye ne teyen kenyeng diri. ");
INSERT INTO plw_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Segwaꞌ neres et mebasag si Pablo, kwan ye, “Kasiꞌ binesanaꞌ dimung bilug! Atuꞌ kay nega ginsan!” ");
INSERT INTO plw_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Neneew dut sembatung taaw et pelitaan itueng mengdidyaga, diminarak pesled bekeꞌ megkikirkir ne et takut na nepekleb eset titikeran de Pablo bekeꞌ de Silas. ");
INSERT INTO plw_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Pineliwan ye dye, bekeꞌ kwan et mengdidyaga, “Mengeꞌ biꞌbilaꞌ, enu merapat buwaten apang aku mebawiꞌ?” ");
INSERT INTO plw_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Sinambag dye, kwan, “Mengandel ke ki Empuꞌ Jesus, indyari mebawiꞌ ke, ikew bekeꞌ dimung kesengbenwa.” ");
INSERT INTO plw_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Na, indyari, itueng beres et Empuꞌ pinebunayag dye eset kenye, bekeꞌ dut ginsan neng megeldeng et seled benwa in. ");
INSERT INTO plw_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Atin negang gebi binesaan et mengdidyaga kedyeng mengeꞌ tawan bekeꞌ negpebewtismu ne ya, sampay ginsan neng meglelegdeng eset seled benwa in. ");
INSERT INTO plw_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Pegketbes dye in pinebayaꞌ ye ne eset kenyeng benwa bekeꞌ negpelamak neʼt kekanen. Ya nebaha neʼt enep sampay ne eset seled neng sengkebenwanan in, sabab dye in ginsan nengandel dut Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Kinerikleman, dinaak et pegibuteʼt lungsud et Roma itueng mengeꞌ kesundeluan na menugid eset mengdidyaga na ipeliwan de Pablo bekeꞌ si Silas. ");
INSERT INTO plw_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Indyari sinugid gasi itue et mengdidyaga dut ki Pablo, kwan, “Mengeꞌ pegibuten nenahag na ipeliwan kew ne. Liwan kew ne bekeꞌ manew et kaya gibek.” ");
INSERT INTO plw_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Temed si Pablo neres dut mengeꞌ kesundeluan, kwan, “Na kami kaya ne nepesebenaran na memahum et indeginis, temed kami pinelepsan et mengeꞌ pegibuteʼt Roma eset memetanan et mengeꞌ taaw, sementaraꞌ kami tawʼt Roma gasi. Indyari megtuy dye lang kami pinesled et pipirisuan. Na tiban, ipeliwan dye kami et kaya gibek. Diki mekedyari itue! Subaliꞌ pegibuten et Roma matuꞌ, supaya megpeliwan damen.” ");
INSERT INTO plw_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Pinesewd et mengeꞌ kesundeluan eset mengeꞌ pegibuteʼt lungsud et Roma, itueng sinugid i Pablo, bekeꞌ nemeketakut dye ganang nesewran na dye tawʼt Romano pelan. ");
INSERT INTO plw_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Angkansa, dye in nemengduntin ne bekeꞌ neneew et pegpekiampun eset duwa dye in. Indyari, pineliwan dye ne itue bekeꞌ sinugiran na mugad ne. ");
INSERT INTO plw_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pegliwan et pipirisuan, nemeglahyun ne si Pablo bekeꞌ si Silas dut benwa i Lidia, netkanan dye duntin mengeꞌ ketipusdang mengengandel. Mura nugad duwa in, tinektakan dye na megpekepangger eset pegpenelang. ");
INSERT INTO plw_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Na tineliban dye lungsud et Ampipolis bekeꞌ lungsud et Apolonia, pegketbes diminateng dye dut lungsud et Tesalonika. Eset lungsud na itue maya pengempuan naꞌ benwa et mengeꞌ Judio. ");
INSERT INTO plw_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Indyari kuyun dut neeratan i Pablo, ya in megseled duntin kede Eldew et Kepeternan seled telung linggu bekeꞌ ya pemegsagkaꞌ-sagkaꞌ iba ye mengeꞌ tawʼt Judio pasal et Kesuratan na beres et Empuꞌ. ");
INSERT INTO plw_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Pinesebenaran ye ne dut seled Kesuratan et Empuꞌ, na si Kristo subaliꞌ mekelabay et ketiksaan bekeꞌ imeteyen. Pegketbes ya megmendyaring megbiyag peuliꞌ mewanan eset kenyeng kepeteyan. Sinugid i Pablo, kwan ye, “Itueng si Jesus pegpepebunayag ku dimyu ya tuꞌ si Kristo, sembatung piniliꞌ et Empuꞌ.” ");
INSERT INTO plw_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Negayat itueng mengeꞌ senu kedye bekeꞌ nengasip dye kire Pablo bekeꞌ ki Silas, kwantin gasi itueng kinensangaʼt Griego na pegpenelang dut Empuꞌ, bekeꞌ mekansang gasi mengeꞌ peguntebien kelilibunan na nepelamud kedye. ");
INSERT INTO plw_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Segwaꞌ nemengimbeng itueng mengeꞌ tawʼt Judio, angkansa pinenimung dye mengeꞌ meyeyahung mengeꞌ taaw na diki mepulusan. Dye in mengeriwaraꞌ et lungsud naꞌ atin. Rinuhub dye benwa i Jason, supaya metulusan dye de Pablo bekeꞌ si Silas apang mepebiriꞌ dye eset mengeꞌ taaw. ");
INSERT INTO plw_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ganang diki metulusan itueng duwa, ginuyud dye si Jason bekeꞌ senung mengeꞌ ketipusdan eset mengeꞌ elepaʼt pegibuten et lungsud. Indyari samat kwantin mara dye, kwan, “Itueng kityung lungsud nesled neʼt mengeꞌ taaw neng mengengeriwaraꞌ misan embe metudyuan, na tiban in, atue dye neʼt lungsud tyu, ");
INSERT INTO plw_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","bekeꞌ pinesled dye ne si Jason. Dyeng ginsan in megpenungsang et ketehagen i Surutan Sesar. Pegbersen dye maya nega ibang surutan na ingaran ye Jesus.” ");
INSERT INTO plw_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Pegketbes neeriwaraꞌ ne mengeꞌ tawʼt Tesalonika bekeꞌ pebebayaꞌ ne mengeꞌ pegibuten et lungsud sabab et kedyeng pegbebersen. ");
INSERT INTO plw_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Si Jason bekeꞌ mengeꞌ sebayaꞌ ye pinegbey menaʼt piansa et mengeꞌ pegibuten mura pineliwan. ");
INSERT INTO plw_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Atin negang gebi, pinesurung et mengeꞌ ketipusdan neng mengengandel de Pablo bekeꞌ si Silas dut lungsud et Berea. Pegdateng duntin, dye in nemenled eset pengempuan naꞌ benwa et mengeꞌ Judio. ");
INSERT INTO plw_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Mas lebing menunga sudsugiren itueng mengeꞌ tawʼt Judio atue kasga eset mengeꞌ tawʼt Tesalonika. Gey-gaay dye kumingeg et pegtulduꞌ i Pablo bekeꞌ pegiskulan dye eldew-peldew et Kesuratan et Empuꞌ apang mesewran baꞌ kebenaran itueng mengeꞌ pegsugiren dye. ");
INSERT INTO plw_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Mekansang nemengandel mengeꞌ tawʼt Judio, kwantin gasi mengeꞌ tawʼt Griego, mekansang mengeꞌ kelilibunan na penguntebien eset atin neng lungsud, sampay mekansang mengeꞌ kelelekian. ");
INSERT INTO plw_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Segwaꞌ ganang neebaran et mengeꞌ tawʼt Judio dut lungsud et Tesalonika na pegtulduꞌ gasi i Pablo dut lungsud et Berea itueng beres et Empuꞌ, dye in nemengduntin sinutsutan dye na memuwat et keeriweraan itueng mengeꞌ tawʼt lungsud. ");
INSERT INTO plw_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Megtuy ne pineugad i Pablo et mengeꞌ mengengandel bekeꞌ pinesurung dut deplakaʼt dagat; segwaꞌ netektak nega de Silas bekeꞌ si Timoteo. ");
INSERT INTO plw_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Itueng mengeꞌ nenglusu ki Pablo nememayaꞌ kenye sekdan dut lungsud et Atinas. Pegketbes negpeuliꞌ dye ne dut lungsud et Berea, pegbibiten itueng pemilin i Pablo kire Silas bekeꞌ ki Timoteo na lumundug megtuy. ");
INSERT INTO plw_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Sasat pegtetegeyen dye i Pablo dut lungsud et Atinas, niseg ne kenyeng atey sabab nepangling ye baha neʼt empuꞌempuan eset atin neng lungsud. ");
INSERT INTO plw_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Angkansa nekipegsedsagkaꞌ ne ya eset mengeꞌ tawʼt Judio bekeꞌ mengeꞌ tawʼt lein Judio na megpenelang eset Empuꞌ dut kedyeng pengempuan naꞌ benwa, bekeꞌ dut misan sinu mesusup ye dut tetebuan eldew-peldew. ");
INSERT INTO plw_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Indyari nekesagkaꞌ ye gasi itueng mengeꞌ menunulduꞌ naꞌ mibut et tulduan tagnaꞌ de Epikurio bekeꞌ de Istoiko. Pegbersen gasi et iba in, “Enu takuꞌ gay bersen kityu et itueng taaw na pegbesberes na kaya kepulus-pulusan?” Pegsugid iba, “Penulduꞌ lengku pasal et ibang mengeꞌ empuꞌ.” Kwantin sinugid dye sabab penulduꞌ si Pablo pasal ki Jesus bekeꞌ pegbiyag ye peuliꞌ. ");
INSERT INTO plw_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Indyari, ya in pinebayaꞌ bekeꞌ pinampang kinensangaʼt taaw eset kekunsialan neng lungsud dut bukid et Areopagus, pegketbes iningkut, kwan, “Mekedyari be takuꞌ mesewran kay na baꞌ enu itueng bagung abar na pegtulduꞌ mu? ");
INSERT INTO plw_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Sabab maya lein-lein ne mekingeg kay et itueng mengeꞌ pegtuturanen mu, angkansa gay kay mesewran na baꞌ enu ingin berseʼt itue.” ");
INSERT INTO plw_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Sabab kaya ne pegkeredyanen et itueng mengeꞌ tawʼt Atinas bekeꞌ mengeꞌ tawʼt tumpang na megteterna duntin, imbes megsing eldew gay dye mengingeg bekeꞌ megsudsugid pasal et mengeꞌ bagung indeginis. ");
INSERT INTO plw_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Indyari timiniyeg si Pablo eset pinegketngaan et mengeꞌ taaw, bekeꞌ kwan ye, “Kemyu mengeꞌ taaw et Atinas, nebibiriꞌ ku ne kebenaran eset seled myu kebentelan. ");
INSERT INTO plw_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Angkansa, sasat ku megpepanew atueʼt dimung lungsud, nebiriꞌ ku na lein-leing ginis pegendelen myu. Nebiriꞌ ku gasi eset dimyung sisimeyaan na samat kwantin nekesurat esentin, kwan, ‘Dut Empuꞌ na kaya nekilala.’ Itueng dimyung pegpenelenganen misan diki myu nekilala atin ne tiban pegpebunayag ku dimyu. ");
INSERT INTO plw_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Itue neng Empuꞌ na baꞌ sinu neguna et sengketelingkepan bekeꞌ lein-leing indeginis ne esentin, atin ne ya Empuꞌ et langit bekeꞌ lugtaꞌ, angkansa kaya ya megterna eset mengeꞌ pengempuan naꞌ benwa na binuwat et taaw. ");
INSERT INTO plw_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Indyari Empuꞌ Banar kaya gasi peneew et tabang eset mengeꞌ taaw sabab ya kaya lang pegkurangen et indeginis. Megdemikian gasi ya key mekegbey et biyag bekeꞌ ginawa bekeꞌ ginsan neng indeginis na keilangaʼt taaw. ");
INSERT INTO plw_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Tinegnaan eset sembatung taaw, nemuwat Empuꞌ Banar et mekansang pengkataʼt taaw na mengebiyagan atueʼt sengketelingkepaʼt lugtaꞌ. Indyari pinandu Ye kedye tantu neng lelegdengan na baꞌ embe dye megmendyaring tumerna sampay sugat neng periama na lelegdengan dye esentin. ");
INSERT INTO plw_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Binuwat ye itue apang tulusen dye Empuꞌ bekeꞌ kaluꞌ eset kedyeng epekepaꞌ-kepaꞌ na mebiyanan Ya. Na, keberbenaran kaya gasi Empuꞌ merayuꞌ eset kede sembatu kityu. ");
INSERT INTO plw_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","‘Angkansa, seled kepetan ye kityung biyag, kityung pegurisik, bekeꞌ kityung pegketaaw.’ Itue samat pegsugiren et mengeꞌ sinu na dimyung menunultul. Na kwan, ‘Kityu ne tuꞌ pesi mengeꞌ keyegangan ye.’ ");
INSERT INTO plw_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Seukat ne kityu keyegangan et Empuꞌ,” kwan i Pablo, “Dyangan tyu pikiren na ating Empuꞌ sama meneʼt dagbes et bulawan, etawa emas, etawa batu na buwat et seled pikiran etawa keremut et taaw. ");
INSERT INTO plw_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Sene tiꞌ, kaya lang pegpenrenen et Empuꞌ itueng mengeꞌ diki pegpengandel kenye segwaꞌ tiban ipegtahag ye ne eset mengeꞌ taaw dut ginsan neng bagiʼt lungsud na megsusun na telikuran itueng kedyeng meyaat neng pengebiyagan. ");
INSERT INTO plw_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Angkansa binetangan Ye neʼt timpu eldewʼt pegukum eset sengketelingkepan bekeꞌ sukup neng ketignaan Yeng buwaten pebiyaꞌ eset Kenyeng Yegang. Itue pinesebenaran Yeʼt ginsan ganang binyag Ye peuliꞌ itueng taaw naꞌ atin.” ");
INSERT INTO plw_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Ganang nekingeg dye itueng pegsugiren i Pablo pasal et pegkebiyag peuliꞌ, iba in nengusik kenye, temed kwan gasi et iba, “Ingin kay mekingeg ke peuliꞌ pasal et itue.” ");
INSERT INTO plw_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Indyari si Pablo nugad ne eset pinegtingtimungan neng kekunsialan et lungsud dut Bukid na Areopagus. ");
INSERT INTO plw_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Maya mengeꞌ senung nengasip kenye bekeꞌ nemengandel et Empuꞌ, nekelamud atue si Dionisio, na sembatung pegibuteʼt kekunsialan et lungsud dut Bukid et Areopagus. Maya gasi nengasip sembatung libun na ingaran ye Damaris bekeꞌ mekansang nega iba nemengandel. ");
INSERT INTO plw_vpl VALUE