﻿USE sofia;
DROP TABLE IF EXISTS sofia.plu_vpl;
CREATE TABLE plu_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES plu_vpl WRITE;
INSERT INTO plu_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Inin kagta akki Kiyapwiye Jesus Cristo gahawkripwi. Ig Kiyapwiye Jesus ig amekene Davi gihiwhi, igme amekene Davi amekene Abrawh gihiwhi. ");
INSERT INTO plu_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Igme amekene Abrawh gikamkayh amekene Izaki, igme amekene Izaki gikamkayh amekene Jakó, igme amekene Jakó gikamkayh amekene Judá gikakkis gisamwipwi. ");
INSERT INTO plu_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Igme amekene Judá gikamkayh amekene Peres gikak amekene Zera, ginagkis guw Tamar. Igme amekene Peres gikamkayh amekene Esroh, igme amekene Esroh gikamkayh amekene Araawh. ");
INSERT INTO plu_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Igme amekene Araawh gikamkayh amekene Aminadabi, igme amekene Aminadabi gikamkayh amekene Nasoh, igme amekene Nasoh gikamkayh amekene Salmoh. ");
INSERT INTO plu_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Igme amekene Salmoh gikamkayh amekene Boaz, ginag guw Rabi. Igme amekene Boaz gikamkayh amekene Obedi, ginag guw Ruti. Igme amekene Obedi gikamkayh amekene Jessé. ");
INSERT INTO plu_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Igme amekene Jessé gikamkayh ukiparawiy amekene Davi. Igme amekene Davi xuwehe amekene Uriyas gihayo. Ayge nikwe egkis kakamkayh amekene Salomawh. ");
INSERT INTO plu_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Igme amekene Salomawh gikamkayh amekene Robawh, igme amekene Robawh gikamkayh amekene Abiyas, igme amekene Abiyas gikamkayh amekene Asa. ");
INSERT INTO plu_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Igme amekene Asa gikamkayh amekene Josafá, igme amekene Josafá gikamkayh amekene Jorawh, igme amekene Jorawh gikamkayh amekene Uziyas. ");
INSERT INTO plu_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Igme amekene Uziyas gikamkayh amekene Jotawh, igme amekene Jotawh gikamkayh amekene Akaz, igme amekene Akaz gikamkayh amekene Ezekíyas. ");
INSERT INTO plu_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Igme amekene Ezekíyas gikamkayh amekene Manassés, igme amekene Manassés gikamkayh amekene Amoh, igme amekene Amoh gikamkayh amekene Josiyas. ");
INSERT INTO plu_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Igme amekene Josiyas gikamkayh amekene Jekoníyas, gikakkis gisamwipwi. Igkis ay amadga inin apim ini hawkri ku aysaw hiyeg israelyenepwi waxepka ta apitit paytwempu Babilôniya. ");
INSERT INTO plu_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ayteke ariwnteke ini ku samah igkis waxepka ta apitit Babilôniya, igme amekene Jekoníyas kakamkayh amekene Salatiyew, igme amekene Salatiyew gikamkayh amekene Zorobabew. ");
INSERT INTO plu_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Igme amekene Zorobabew gikamkayh amekene Abiyúdi, igme amekene Abiyúdi gikamkayh amekene Eliyakih, igme amekene Eliyakih gikamkayh amekene Azor. ");
INSERT INTO plu_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Igme amekene Azor gikamkayh amekene Sadoki, igme amekene Sadoki gikamkayh amekene Akih, igme amekene Akih gikamkayh amekene Eliyúdi. ");
INSERT INTO plu_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Igme amekene Eliyúdi gikamkayh amekene Eleazar, igme amekene Eleazar gikamkayh amekene Matah, igme amekene Matah gikamkayh amekene Jakó. ");
INSERT INTO plu_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Igme amekene Jakó gikamkayh amekene José. Igme amekene José ig kiyapuno Mahi gugihgi. Egme Kiyapwiye Jesus ginag. Igme Kiyapwiye Jesus iggi Cristo ig Uhokri gikanyan adahan ukumaduketniwiy. ");
INSERT INTO plu_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Giwenketeke amekene Abrawh he danuha git amekene Davi ig Kiyapwiye Cristo kadahan madikawku akak paxnika gawnakis (14) gikebyikis gahawkripwi. Ayteke giwenketeke amekene Davi he ignes amekenegben kamaxwika waxepka ta apitit paytwempu Babilônia, ig kadahan madikawku akak paxnika gawnakis (14) gikebyikis gahawkripwi akiw. Ayteke ariwnteke ku samah ignes amekenegben waxepka ta apitit paytwempu Babilônia he danuha git Kiyapwiye Cristo ig kadahan madikawku akak paxnika gawnakis (14) gikebyikis gahawkripwi akiw. ");
INSERT INTO plu_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Kuri nah akkite yit ku samah ig Kiyapwiye Jesus Cristo giwaypuka. Ginag kiyapuno Mahi eg kuwis ahegbet gunetni gikak amekene José. Henneme apit egkis hamah, eg kuwis biyuhkisno giwntak Uhokri Gitip. ");
INSERT INTO plu_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Eg gubetki ig amekene José ig waditye awayg. Nikwe ig awna: ―Eg Mahi biyuhkisno. Ke nuthube eg mehe gumun. Ku henne nikwe amawka nah maytepru. Henneme nah ka muwaka marakwig giwtrikkis hiyeg. Ka sam. Nah mayteprute monye kahadbe hiyeg ka hiyak. ");
INSERT INTO plu_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ig ipegminene gihiyakemni henne, pahaye adahan pahapwi ahj Uhokri giwatni hiyapkiswa git garisunawak. Ig ahj awna git: ―Kiyapwiye José, pis ku pariye amekene Davi gihiwhi, pis ka muwaka apis maripkaw gukak kiyapuno Mahi mmanawa eg biyuhkisno giwntak Uhokri Gitip. ");
INSERT INTO plu_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nore pihayo pamakutaknek eg sarayh guwenyannek pahapwi bakimni awayg. Pis sarayh gukamkayh giw Jesus, inakni giw “Amnihkeputne”, mmanawa ig amnih madikte gihiyegapunek. Ig keh igkis isamtaw ariw gipathawnikis. ");
INSERT INTO plu_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ini madikte danuh henne kahadbe in kahayak ku samah Uhokri awna minikwak gipititak gawnepe. Igme gawnepe awna: ");
INSERT INTO plu_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Aysawnemenek pahapu himano eggu biyuhkisnek eg sarayh gukamkayh awayg, ig kanumkanek Emanuel.” Inakni giw wownaprikwiy, “Uhokri ay ukakwiy”. ");
INSERT INTO plu_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ig amekene José timapni henne, ig kannikaw ig ihe inakni ahj giwn. Ig maripkew gukak kiyapuno Mahi. ");
INSERT INTO plu_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Henneme apit eg pamakutak ig ka hamah gukak. Eg pamakuteke, eg sarayh gukamkayh, igme amekene José sarayh giw Jesus. ");
INSERT INTO plu_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ig Kiyapwiye Jesus amadga wayk apit paytwempu Belém ayhté apit waxri Judeyamnaw. Ig waypuka apim ini ku aysaw amekene Erodis kumadukene madikte hiyeg ayge. Apim ini hawkri awaykemni kannuhwenepwi amin warukma igkis ayta wahamapriktak ta apitit paytwempu Jerusalém. ");
INSERT INTO plu_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Igkis danuh atere, igkis ayá hiyeg: ―Kineyki ig bakimni nukune ku pariye humawnek judeyenepwi gikiparakis? Usuh kuwis hiyá giwarukma pes wahamapriktak. Usuh ayta adahan usuh gikiythetni. ");
INSERT INTO plu_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ig amekene Erodis timé gakkis, ig wadisase ganmap akak inakni giwnkis. Mmanawa ig ka muwaka nawenéwa hiyeg kumaduka gihiyegapu giwenyan. Madikte paytwempuyenepwi ayge Jerusalém igkis hiyapni henne ku samah gikiparakis Erodis wadisasew, nikwe igkis madikte wadisasew hawwata awaku igkis apisasew gibohri. ");
INSERT INTO plu_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ayteke nikwe ig amekene Erodis pahadguhe madikte muwpeg kiyatyepwi payak gikakkis nerras kannuhekeputnepwi amin amekene Moís gikumadukan. Ig awna gitkis: ―Kineyki ner pahapwi ku pariye Uhokri gikanyan adahan ukumaduketniwiy kineyki ig waypuka amadgat wayknek? ");
INSERT INTO plu_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Igkisme kaytwa giwn: ―Ig amadgat wayk apit paytwempu Belém ay apit Judeyamnaw. Uhokri gannasan ta git gawnepe minikwak in awna: ");
INSERT INTO plu_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Yis hiyeg belémyenepwi ayge apit waxri Judeyamnaw, aysawnemenek yiwetri kiyathakanek gapitkis kaayhsima ikiparat apitnenepwi Judeyamnaw. Mmanawa pahapwi ikiparat pes yibetitaknek ku pariye gikapriwtenkis madikte nuhiyegapu israelyenepwi.” ");
INSERT INTO plu_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ig amekene Erodis timapni henne, ig awna: ―Nah kiniste nerras kannuhwenepwi amin warukma adahan nah giwmasepten ner bakimni. Ig watihpigkis monye adahan igkis ayta kinetihwa gikak. Igkisme danuh atere, igme ayaprikis: ―Aysewneneki ig warukma hiyapkiswa yit? Igkisme akki git. ");
INSERT INTO plu_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ayteke pisenwa ig awahkiswigkis ta apitit ini paytwempu Belém. Ig awna ta gitkis: ―Ataknabay ta apitit Belém. Ipegpanabay ner bakimni kabayhtiwa. Ku aysaw yis utipri, uyay wasapanaw numinhu. Nah muwekekere nah atere kiyatig hawwata ke yistabe. ");
INSERT INTO plu_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Pisenwa gitimpankis inakni giwn, igkis tipik. Ayteke igkis apigku ahin, igkis hiyá ig warukma akiw, igwata warukma ku pariye igkis hiyap ayhté wahamapriktak. Ig tipik gapitkigempikis he danuhe apitmin ini iwetrit ku kiney ig bakimni msakwa. ");
INSERT INTO plu_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Igkis hiyá ig warukma henne, igkis kaayhsima batek ginaktinkis. ");
INSERT INTO plu_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ayteke igkis danuh atere, igkis pareke agikut ini payt. Ayge igkis hiyá ig bakimni gukak ginag kiyapuno Mahi. Igkis hiyapni henne, igkis paberetusaw. Igkis kiyatig. Ayteke igkis woka gisakolakis igkis kakanhaw git karukri wahano akak imihgi akak ah adidkan imihnepye kewye “miha”. ");
INSERT INTO plu_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ayteke ig Uhokri awna ta gitkis garisunawakis adahan igkis ka diyuh ta git amekene Erodis. Ayge nikwe igkis diyuhe ta gipinwatkis apigku nawenéwa ahin. ");
INSERT INTO plu_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ayteke ewka giwenkis pahapwi ahj Uhokri giwatni hiyapkiswa ta git amekene José garisunawak. Ig awna git: ―Kannikaw kuri. Ahegbetawnabay adahan yis bisike ta apitit Ejitumnaw. Msakwanabay ayge juktah ku aysaw nah akka pit adahan yis diyuh akiw. Mmanawa kiyapwiye Erodis gipegepten bakimni adahan giwmepten. ");
INSERT INTO plu_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ig amekene José timapni henne, ig kannikaw kibentenwa ig iwé bakimni gukak ginag. Egkis pese nikwenéwa tiyegim. Egkis tipikwiye ta apitit Ejitumnaw. ");
INSERT INTO plu_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Egkis danuh atere, egkis msekwe ayge juktah amekene Erodis miyapi. Madikte ini danuh henne kahadbe in kahayak ku samah Uhokri awna minikwak gipitimpi gawnepe. Ig awna: “Nah humak nukamkayh pes apititak Ejitumnawtak.” Hennewatbaki ig awna. ");
INSERT INTO plu_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ig amekene Erodis hiyapni henne ku ig kiniswika gapitkis nerras kannuhwenepwi amin warukma, ig kaayhsima dagawne. Ayteke nikwe ig awahkise gisuwtatapu adahan igkis umahape madikte bakimnay awayg ayge apit paytwempu Belém, aranwa paytwempu. Ig umahkise madikte bakimnay awayg adahan pikana kamukri gawkis han buttit juktah nopsanyu bakimni, pakeku akak ku samah nerras kannuhwenepwi amin warukma akki git ku kabet ig warukma hiyapkiswa ta gitkis. ");
INSERT INTO plu_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Metakwa in kahayak ku samah Uhokri gawnepe amekene Jeremíyas awna minikwak. Ig awna: ");
INSERT INTO plu_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Timapnay kabimanka aman apititak paytwempu Rama kennesa ahumwa Belém. Kaayhsima tihaki kaayhsima kadniki ayge. Tinogben tihanos ke amakano Rakewbe eg tihano aharit gukamkayupwibe. Yuma hiyeg hiyá gaydhakkis mmanawa gukamkayhkis yuma akiw.” Hennewatbaki ig amekene Jeremíyas awna. ");
INSERT INTO plu_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ayteke ariwnteke amekene Erodis gimiremni, pahapwi ahj Uhokri giwatni hiyapkiswa ta git amekene José garisunawak ayhté Ejitumnaw. ");
INSERT INTO plu_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ig awna git: ―Ahegbetawnaba. Iwepnaba bakimni gukak ginag adahan yis diyuh ta apitit israelyenepwi giwaxrikis. Nerras ku pariye umehkerepye bakimni igkis kuwis miyarap. ");
INSERT INTO plu_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ig amekene José timapni henne, ig kannikaw ig iwé bakimni gukak ginag. Egkis diyuhe ta apitit israelyenepwi giwaxrikis. ");
INSERT INTO plu_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Egkis danuh atere, ig amekene José timé amekene Arkilaw gak ku ig kumadukene Judeyamnaw giwenyan gig amekene Erodis. Nikwe ig apise msakwa ayge. Ayteke ig Uhokri akki git garisunawak adahan egkis ka atak atere akiw. Ayge nikwe egkis tipik ta apitit waxri Galiléyamnaw. ");
INSERT INTO plu_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Egkis danuh atere ta apitit paytwempu Nazaré. Ayge egkis msekwe. In danuh henne kahadbe in kahayak ku samah Uhokri gawnepepu awna minikwak. Igkis awna: “Ig Cristo kanumkanek nazareyene.” ");
INSERT INTO plu_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Apim ini hawkri ku samah ig Kiyapwiye Jesus ayge apit Nazaré, amekene João Batista pes ta amadgat amatap ayhté Judeyamnaw. Ayge ig ekkene giwsapan Uhokri. ");
INSERT INTO plu_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ig awna ta gitkis hiyeg: ―Wagesnabay yihiyakemni ariw yitaraksan mmanawa ahawkanaprik Uhokri gikumadukan kuwis danuh. Hennewatbaki ig amekene João Batista awna ta gitkis hiyeg. ");
INSERT INTO plu_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Minikwak Uhokri gawnepe amekene Isaías ig kinetihwa gimin ig amekene João Batista. Ig tamak inakni giwn amadga gikagtan. Ig awna: “Pahapwi kinetihwanek amadga amatap. Ig awnanek: ‘Ahegbetawnabay gapit Ukiparawiy gaytni. Ig nemnik ig. Wadithanabay yihiyakemni gidahan marihwakam yis kawih gidahan Uhokri gikumadukan.’ ” Hennewatbaki ig Uhokri gawnepe awna minikwak. ");
INSERT INTO plu_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ig amekene João Batista madiptipye. Gikawihni kewa amekene Eliyas gikawihnibe. Ig kasimsapu akak “kamelu” asipri. Ig kakabutikpu akak pak amar. Gimaname tanan akak ahayak anunu. ");
INSERT INTO plu_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Kaayhsima hiyeg danuh atere gimkanit amekene João Batista adahan igkis timepnes ginetni. Igkis danuh apititak paytwempu Jerusalém. Igkis danuh apititak madikte waxri Judeyamnaw. Igkis danuh apititak waxri muwwapu aranwa warik Jordawh. ");
INSERT INTO plu_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ayge igkis ekkepyes gitaraksankis ta git amekene João Batista. Igme kayweprikis apigku eggu warik Jordawh adahan ekkene ku igkis amepene ini ku Uhokri bayahminigkis ariw gitaraksankis. ");
INSERT INTO plu_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Kaayhsima farisewkis gikakkis kannuhekeputnepwi amin amekene Moís gikumadukan igkis hawwata ayta kaywasewpiye ta git amekene João Batista. Ig hiyapni henne, ig awna ta gitkis: ―Yis kaybunyune hiyeg pahaywitniyepwi! Uhokri ka batek akak yihiyakemni kane kibeynema. Mmah yitneki yikewpen keh ig hiyapyi ke wotbe yis kibeynepwibe hiyeg giwtrik? ");
INSERT INTO plu_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Kawa. Ini yikewpen ka kinisri. Amawka ku yis inyerwa wages yihiyakemni ariw yitaraksan. Kapusanabay wew wadit. Ini yiwewni waditye ininewa arakak ku yis inyerwa wages yihiyakemni. ");
INSERT INTO plu_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ka yi muwaka awna: “Wixwiy judeyenepwi wixwiy amekene Abrawh gihiwhipwi. Amun ini wixwiy kuwis Uhokri gihiyegapu. Ayge nikwe ig Uhokri ka aminama ariw utaraksanwiy. Ig hiyapwiy kewa kibeynepwibe giwtrik.” Ka ik adahan yis awna inakni henne. In ka ariknawnama ku wixwiy amekene Abrawh gihiwhipwi. Ka innema keh wixwiy isamtaw. Ik adahan Uhokri keh no tip humaw amekene Abrawh gihiwhipwi. ");
INSERT INTO plu_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ahawkanaprik kabá danuh adahan Uhokri ipuke hiyeg patahwapye hampa arimkanit biyukwiki. Pahapwi ku pariye kane wew wadit amadga hawkri iggi kewa pahakti amutribe ku pariye sarayh guw kane kabaynoma guw. Igme Uhokri ig kewa pahapwi awaygbe ku pariye kuwis ahegbet akak gimegwan adahan ig ahukepten eggu ah kane kabaynoma. Ku pariye gamutra sarayh guw kane kabaynoma guw, eggu ig ihukapepru ig padakapepru ariwtrikut tiket bukahapepru. ");
INSERT INTO plu_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ayteke ig amekene João Batista awna gitkis madikte hiyeg. Giwn: ―Ku aysaw nah kaywepyi nah kawihkis un ta yipitit adahan yis wageswiye yihiyakemni ariw yitaraksan. Henneme pahapwi nemnikumpiye nuhapuh butte ku pariye kaywepyi akak igyerwa Uhokri Gitip adahan ig kawihkis gidahanwa gihiyakemni akak gannu ta yipitit. Yaytakme ig kawihkis tiket ta yipitit. Ig ner kaayhsima pi kiyatte mpiyhan. Nah yuma nukiythanisima gitiput adahan nah ayapig hiyuh gikasotni. ");
INSERT INTO plu_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Aysawnemenek ig ibekhe hiyegnek hawwata ku samah wis ibekhe amutri ayak akak amar. Ig ahegbet ibekhepye hiyeg kuwis ke pahapwibe awayg akak huw ay giwaku adahan ig mihikohbetene amutri ayak ariw amar. Ig ibakhanek ku pariye kibeynepwi akak ku pariye kane kibeynepwima. Ku samah wis bayah amutri ayak agiku payt, amarme wis bukehpig, hawwata ner nemnikumpiye ig bayah hiyeg ku pariye kibeynepwi agiku gipin. Ignesme ku pariye kane kibeynepwima igkis bukehpikanek ariwtrikut eggu tiket ku pariye kane awakti. Hennewatbaki ig amekene João Batista awna. ");
INSERT INTO plu_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Abetnewa ini hawkri ig Kiyapwiye Jesus pes apititak Galiléyamnaw ta apigkut warik Jordawh. Ig danuh atere git amekene João Batista, ig awna git: ―Uyá kaywepun. ");
INSERT INTO plu_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Igme amekene João Batista kaytwa giwn: ―Kawk, Kiyapwiye. Pis yuma pipathawni. Ka ik adahan nah kaywap. Pis kis adahan kaywepun. ");
INSERT INTO plu_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Igme Kiyapwiye Jesus kaytwa giwn: ―Ka sam. Uyá keh ku samah nuwnhu pit. In wadit pis kaywepun mmanawa hennewa Wigwiy gimawkan. Ig amekene João Batista timapni henne, ig ihe giwn. ");
INSERT INTO plu_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ig kaywepri, igme Kiyapwiye Jesus iyak ahakwatak un, en woke. Ig hiyá Uhokri Gitip muhuke ta gipitit, gihipak ke pahapu tukwabe. ");
INSERT INTO plu_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ayteke pahá ikupimnat awna aytontak inugiktak. In awna: ―Pisnewa nukamkayh nubetki. Nah batek pikak kaayhsima. ");
INSERT INTO plu_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Aynewa ig Uhokri Gitip awahkise Kiyapwiye Jesus ta amadgat pahayku amatap. Ig awahkisri atere adahan wapitye gikiparadkis gihikekten adahan hiyá ba hiyá igma taraksasepri. ");
INSERT INTO plu_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ayge amadga amatap ig Kiyapwiye Jesus maxhaw adahan paxnika madikwa (40) hawkri. Ayteke nikwe ig matipwe. ");
INSERT INTO plu_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ig wapitye gikiparadkis hiyapni henne, ig danuh atere git. Ig awna git: ―Ku pis Uhokri gikamkayh, asá awna ta gut no tip adahan eg wageswa bugut pidahan. ");
INSERT INTO plu_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Igme Kiyapwiye Jesus kaytwa giwn: ―Kawk. Mmanawa Uhokri gannasan awna: “Hiyeg ka aymahwa akak bugutwonama henneme ignes aymahwa akak madikte yuwit ku pariye pes gibiyaptak Uhokri.” ");
INSERT INTO plu_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ayteke ig wapitye gikiparadkis ig waxe Kiyapwiye Jesus ta apitit paytwempu Jerusalém. Ayge ig waxwig ta inut apuhekut ini leglis kewye Uhokri Gipin. ");
INSERT INTO plu_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ig awna ta git: ―Ku pis Uhokri gikamkayh, asá watiswa ayteke inutak. Mmanawa Uhokri gannasan minikweknene awna: “Uhokri apuriwkispi ta gitkis ahj adahan igkis amapap amadga giwakkis marihwa pikugku ka tes apit tip.” ");
INSERT INTO plu_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Igme Kiyapwiye Jesus kaytwa giwn: ―Kawk. Mmanawa Uhokri gannasan hawwata awna: “Ka yi muwaka hikek Kiyapwiye yiwohkiga baki igyerwatma ay yikak.” ");
INSERT INTO plu_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ayteke ig wapitye gikiparadkis gihikekten akiw. Ig waxepri ta apitit pahá waxri imuwadnene. Ayge ig akki git madikte gikumadukan amedgene inin akak madikte igiska. ");
INSERT INTO plu_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ig awna git: ―Ku pis paberetusaw ntiput adahan pis kiyathan, nah ikí madikte ini ta piwakuit. ");
INSERT INTO plu_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Igme Kiyapwiye Jesus kaytwa giwn: ―Satanás, su higihwa ayteke. Mmanawa Uhokri gannasan awna: “Kiyathanaba ignewa Kiyapwiye piwohkiga. Kehnaba ignewa gibetki.” ");
INSERT INTO plu_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ig wapitye gikiparadkis timapni henne, ig tipik giw. Ayteke ahj danuh atere, igkis ikene Kiyapwiye Jesus gawaygyi. Pisenwa ig tipik ta gipinwat. ");
INSERT INTO plu_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ayteke ig Kiyapwiye Jesus timé amekene João Batista gak ku ig paraksepka. Ig timapni henne, ig tipik ta apitit Galiléyamnaw ta apitit paytwempu Nazaré ku kiney ig aymuhwa. ");
INSERT INTO plu_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ayteke ig pes apititak ini paytwempu Nazaré, ig tipik msakwa apit paytwempu Kafarnawh. In Kafarnawh in akigbimna mahakwa Galiléya ayhté apit waxri Zebulomnaw akak Naftalimnaw. ");
INSERT INTO plu_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ku samah ig msakwa ayge, metakwa in kahayak ku samah Uhokri gawnepe amekene Isaías awna minikwak. Giwn: ");
INSERT INTO plu_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Kaayhsima kabayka ayge Zebulomnaw akak Naftalimnaw ayge ayegbi parawhokwa akak warik Jordawh, ini waxri ku pariye hiyeg kane judeyenepwima giwaxrikis Galiléyamnaw. Kaayhsima kabayka ayge. ");
INSERT INTO plu_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Nerras hiyeg ayge ku pariye abetnenepwi amisnapyi ignes hiyanek nopsad kabutniki. Ini kabutniki uguhpigkisnek nerras ku pariye abetnenepwi miyaka amisnapyi.” Hennewatbaki ig amekene Isaías awna. ");
INSERT INTO plu_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ig Kiyapwiye Jesus msekwepi ayge Kafarnawh, ig kapusa akki Uhokri giwn ta gitkis hiyeg. Ig awna: ―Wagesnabay yihiyakemni ariw yitaraksan. Ahawkanaprik Uhokri gikumadukan kuwis danuh. ");
INSERT INTO plu_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ig waywe akigbimna mahakwa Galiléya. Ayge ig hiyá piyana gikebyikis awaykemni. Igkis kiyapwiye Simawh Pedru gikak gisamwi kiyapwiye André. Igkis ipuhtyakeputnepwi. Igkis ayge ipuhtyanes akak tagamayh. ");
INSERT INTO plu_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ig Kiyapwiye Jesus hiyapni henne, ig awna ta gitkis: ―Ba yi ayta wew nukakhu. Nah keh yis humaw ipuhtyakeputne hiyeg. Ku samah yis utí im, nah keh yis utí hiyeg ndahan. ");
INSERT INTO plu_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Igkis timapni henne, aynewa igkis ikise gitagmayakis. Igkis tipik gikak adahan igkis humewnes gikannuhnipwi. ");
INSERT INTO plu_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ayteke ig wew aynessa akiw, ig hiyá piyana gikebyikis akiw. Igkis amekene Tiyagumni gikak gisamwi kiyapwiye João, ku pariye amekene Zebedew gikamkayupwi. Igkis amadga pahamku umuh gikak gigkis. Igkis kehepenes gitagmayakis ayge. Ig Kiyapwiye Jesus hiyapni henne, ig humekwigkis ta gimkanit. ");
INSERT INTO plu_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Aynewa igkis ikise gihmunkis gikak gigkis. Igkis tipik gikak Kiyapwiye Jesus adahan igkis hawwata humewnes gikannuhnipwi. ");
INSERT INTO plu_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ayteke ariwnteke ini ig Kiyapwiye Jesus wew muwwapu Galiléyamnaw. Ig kannuhekne agiku judeyenepwi gileglisakis muwwapu ayge. Ig ekkene inakni kibeyne inetit amin ku samah Uhokri kumaduka hiyeg. Ig makniwene hiyeg ariw madikte karaytpiyene ariw madikte mabimnakatru. ");
INSERT INTO plu_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Madikte hiyeg kinetni gak muwwapu Síriyamnaw. Ayteke nikwe igkis waxe git madikte kakahribdapye, nerras ku pariye akak karayt, akak kayahwaki, nerras ku pariye wapityewnapye, nuwiskewenpiye, datpuwapye. Ig Kiyapwiye Jesus hiyapni henne, ig makniwapeprikis madikte. ");
INSERT INTO plu_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kaayhsima hiyeg kabubuknene kurukehe gihapu butte. Igkis danuh atere apititak Galiléyamnaw, apititak Dekápolis, apititak paytwempu Jerusalém, apititak Judéyamnaw, apititak waxri pahambaktak ariw warik Jordawh. ");
INSERT INTO plu_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ig Kiyapwiye Jesus hiyapni henne ku samah nerras hiyeg kabubuknenes ayge, ig wagehe ta apitit pahá waxri imuhgipitnene. Ayge ig batahkiswa adahan gikannuhtenkis. Igkisme gikannuhnipwi atere pahadguhwa ta ganwat. ");
INSERT INTO plu_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Igme gikannuhtenkis. Ig awna gitkis: ");
INSERT INTO plu_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Kaayhsima kabayka ay gidahankisnek hiyeg ku pariye ikewnepwi yumanene gawaygyikis giwntekneswatma. Ayge nikwe ignes kawih Uhokri gikumadukannek. ");
INSERT INTO plu_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","―Kaayhsima kabayka ay gidahankisnek hiyeg ku pariye kadniyepwi adahan gipathawnikis. Ayge nikwe Uhokri aydaptihgikisnek. ");
INSERT INTO plu_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","―Kaayhsima kabayka ay gidahankisnek hiyeg ku pariye tuwatasaw gitiput Uhokri. Ayge nikwe ig Uhokri kumadukasa madikte hiyeg amadga hawkri ta gitkisnek. ");
INSERT INTO plu_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","―Kaayhsima kabayka ay gidahankisnek hiyeg ku pariye mpiksewnepwi adahan igkis wew wadit. Ayge nikwe ig Uhokri ikí gitkisnek ini ku kaharit igkis mpiksaw. ");
INSERT INTO plu_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","―Kaayhsima kabayka ay gidahankisnek hiyeg ku pariye amnihpiyes hiyeg. Ayge nikwe ig Uhokri amnihgikis hawwatanek. ");
INSERT INTO plu_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","―Kaayhsima kabayka ay gidahankisnek hiyeg ku pariye barewbetyepwi gihiyakemnikis. Ayge nikwe igkis hiyap Uhokrinek. ");
INSERT INTO plu_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","―Kaayhsima kabayka ay gidahankisnek hiyeg ku pariye kabeywotepye hiyeg. Ayge nikwe ig Uhokri kanumrikis gikamkayhnek mmanawa gihiyakemnikis kewa gidahanbe. ");
INSERT INTO plu_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","―Kaayhsima kabayka ay gidahankisnek hiyeg ku pariye hiyapkiska mbeyne gitkis apatra ku samah igkis kehne kabayka. Ayge nikwe igkis kawih Uhokri gikumadukannek. ");
INSERT INTO plu_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","―Kaayhsima kabayka ay yidahannek ku aysaw hiyeg arewatay apatra ku samah yis nuhiyegapu. Ku aysaw igkis hiyapkis mbeyne yit nupatra, ku aysaw igkis patehepyes yiw akak wasaymkanen nupatra, ka sam. Yis utí ayge kaayhsima kabayka nikwe. ");
INSERT INTO plu_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Bateknabay yinaktin apim ini ku aysaw yis hiyepne mbeyne nupatra. Bateknay kaayhsima mmanawa yis utí yitiwni kibeynewanek ayhté inugik. Mmanawa hennewa Uhokri gawnepepu pitatyepwi igkis hiyapkiska mbeyne ta gitkis. ");
INSERT INTO plu_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","―Nah kehte yidahan abektey ariwntak pam. Pam muwakapka adahan kibeyhene im. Yis humaw kewa pambe ay gibetkis hiyeg amedgene inin adahan yihiyakemni kibeyhene gihiyakemnikis. Henneme ku pam biyukse aketri, wis ka hiyá wisma kabayhin akiw. In ka kawih adahan ariknawnama akiw. In he kawih adahan padekwiki adahan hiyeg ka aminama niw akiw, ignes sibuh ta nibetit. Yis hawwata ku yis biyuksa yabay, yis ka kawih adahan ariknawnama akiw. ");
INSERT INTO plu_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Hawwata akiw yis humaw kewa pahá abukribe ay gibetkis hiyeg amedgenepwi hawkri adahan yihiyakemni uguhne gihiyakemnikis. Ku samah wis ka hiyá gayamka pahá paytwempu ku pariye apitnene pahá waxri imuwadnene hawwata wis ka muwaka ayam uhiyakemni ku pariye ke wotbe kabutennene. ");
INSERT INTO plu_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Wis ka hakis lalamp adahan wis asabkeptenma anapi suwyeg. Kawa. Wis ikigu ta inut akekrit adahan eg uguhno madikte hiyeg ku pariye agiku payt. ");
INSERT INTO plu_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Yis hawwata amawka yis ka sabuk yihiyakemni ku pariye ke wotbe kabutennene. Amawka yis keh kabayka gikakkis hiyeg kahadbe ignes hiyá in yabay igkis kabayha Wigwiy inugikyene. ");
INSERT INTO plu_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","―Nawenétke yis yipewkan ku nah ayta pisenwehpiye gikak amekene Moís gikumadukan akak Uhokri gawnepepu ginetnikis. Bawa kawa. Nah ka ayta pisenwehpiyema akak inakni giwnkis henneme nah ayta adahan nah kehne madikte ku pariye igkis ayá wotwiy, adahan nah akkamnih yit ku pariye inyerwatnene Uhokri gimawkan ku aysaw ig ikí inakni giwnkis gitkis. ");
INSERT INTO plu_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Hennewatbaki in. Yuma pahatnama yuwit atiksak ay amadga amekene Moís gikumadukan yuma pahatnama mpiyene. Ku samah en akak waxri aynete, inakni giwn ka mpiya aynesnima he danuhe amaksemni hawkri. ");
INSERT INTO plu_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ku pahapwi taraksa amekene Moís gikumadukan pahatwowa, ku ig kannuh hiyeg adahan ignes taraksin, iggi yuma gikiythaninek abet Uhokri gikumadukan. Henneme ku pahapwi igyerwa ihpene amekene Moís gikumadukan, ku ig kannuh hiyeg adahan ignes ihapni, iggi kagikiythanisima abet Uhokri gikumadukan. ");
INSERT INTO plu_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Hennewatbaki in. Amawka ku yis wew pi waditte giwkis nerras farisewkis, giwkis nerras kannuhekeputnepwi amin amekene Moís gikumadukan. Ku ka hennema, yis ka kawihti Uhokri gikumadukan. ");
INSERT INTO plu_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","―Yikannuhten akki yit ku ig amekene Moís awna ta gitkis amekenegben, giwn: “Ka yi muwaka umah hiyeg. Ku pahapwi umah pahapwi, nikwe ig tarakse. Iggi kis adahan hiyaptigi hiyapkis mbeyne git apatra ini gitaraksan.” ");
INSERT INTO plu_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Nahme awna yit, ku pahapwi he dagawne git gikebyi, nikwe ig tarakse. Iggi kis adahan hiyaptigi hiyapkis mbeyne git apatra ini gitaraksan. Hawwata akiw ku pahapwi awna gimin gikebyi: “Ner yuma gihiyakemni”, ay amun ini ig hawwata tarakse. Iggi kis adahan uwewkistenwiy hiyapkis mbeyne git apatra ini gitaraksan. Hawwata akiw ku pahapwi awna gimin gikebyi: “Ner ka kabay. Kuri ig tipik ariwtrikut tiket.” iggi hawwata ig kis adahan ig tipik ariwtrikut tiket ayge amun ini iwetrit ku kiney kaneayhsima kayahwaki. ");
INSERT INTO plu_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","―Nikwe apim ini ku samah pis kakanhewne git Uhokri agiku kakanhewket, ku pahaye adahan tuguh abet pihiyakemni ku pis tarakse gikak pikebyi, ");
INSERT INTO plu_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","amawka ku pis ikis pikan ayge, pis atak gimkat pikebyi pisenwate apit pis kakanhaw git Uhokri. Pis danuh atere, pis wadithebdih pihiyakemni gikak pikebyi. Ayteke nikwe hiyawa pis diyuh kakanhaw git Uhokri. ");
INSERT INTO plu_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Amawka ku pis wadithebdih madikte pitaraksan ku akak inin kibentenwa. Aysawnemenek pis ka kahawkannek. Amadga inin ku pahapwi taraksa gikak pahapwi ig mpiksaw adahan wadithebdihpin kibentenwa. Ku iggi gipetunya waxepri ta git hiyaptigi adahan ig kamiyepri atere, ayge apigku ahin apit igkis danuh atere ig mpiksaw wadithebdih ini gitaraksan gikak. Ku ig ka wadithebdihni, iggi gipetunya kamiyeprinek ta git hiyaptigi, igme hiyaptigi awahkis giwatni, igme giwatni paraksepri ta arikut parakseket. ");
INSERT INTO plu_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ku ig paraksepka atere, ig ka pes ayteke juktah ku aysaw ig katiwnih madikte gimatiwnihni. Pis hawwata. Amawka ku pis wadithebdih pitaraksan pisenwate akak inin kahadbe aysawnemenek pis ka paraksepka gapit Uhokri. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","―Yikannuhten hawwata akki yit ku amekene Moís awna: “Ka yi muwaka powkemnihwa.” ");
INSERT INTO plu_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Nahme awna yit, ku pahapwi he ipegpiyene gumkat pahapu tino adahan ig kiyakan ta gupitit, amun ini nikwe ig kuwis powkemnihwe gukak apit giyakni. ");
INSERT INTO plu_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","―Battukawnaba adahan pis apuriw pihiyakemni adahan pis ka taraksa. Ku pis me taraksemet awaku ku samah pis ipeg gumkat no tino akak piwtyak, pi kabayte pis wareke piwtyak pis padekwin mpinekata pis tarakse. Aysawnemenek pis katiwnih pitaraksannek. Pi kabayte pis biyukse piwtyak mpinekata pis biyukse pipit pahapwite amun ini iwetrit ku kiney kaneayhsima kayahwaki. ");
INSERT INTO plu_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Hawwata akiw ku pis me taraksemet akak piwak, pi kabayte pis bukihpin padekwin mpinekata pis tarakse. Mmanawa pi kabayte pis biyukse piwak pahambakya mpinekata pis biyukse pipit pahapwite amun ini iwetrit ku kiney kaneayhsima kayahwaki. ");
INSERT INTO plu_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","―Nerras yikannuhten hawwata awna: “Ku pahapwi maytwekere gihayo, hiyawa ig ikí gut ini kagta adahan maytwawka.” ");
INSERT INTO plu_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Nahme awna yit, ku pahapwi mayta gihayo waditnepyenen eg ka powkemnihwa, ayge nikwe igwa keh eg ke powkemnipyobe giwtrik Uhokri ku aysaw eg maripkaw akiw. Hawwata akiw ner awayg ku pariye maripkaw gukak no tino ay amun ini nikwe giwtrik Uhokri ig kuwis powkemnihwe gukak. ");
INSERT INTO plu_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","―Nerras yikannuhten hawwata akki yit ku amekene Moís awna gitkis amekenegben, giwn: “Ku pis kanum Uhokri pitemwera adahan ig timá piwn ku in ka kiniskama, nikwe pugamawka hennewa pis ka kinis.” Ayteke igkis yikannuhten idis gihiyakemnikis atere, igkis awna: “Henneme ku pis kanum inugik pitemwera, ku pis kanum waxri pitemwera, nikwe ka sam pis kinis.” ");
INSERT INTO plu_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Nahme awna yit: “Ka ba yi kanum Uhokri yitemwera. Iné kawnata kanum inugik yitemwera mmanawa in Uhokri giwetri. ");
INSERT INTO plu_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Iné kawnata kanum inin waxri adug yitemwera mmanawa in Uhokri gikugkapta. Iné kawnata kanum Jerusalém yitemwera mmanawa in paytwempu gidahan Ukiparawiy detye. ");
INSERT INTO plu_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Iné pitew ka kanum mmanawa ka pisnama kumaduka pitew. Pis ka hiyá pisma wages pahatnama pisemnu iné seye iné pohe. ");
INSERT INTO plu_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Amawka pis ka awnati adahan kinisaka. Apuriwnaba madikte piwn ku pariye pis awnakere. Amawka ku piswa humaw pitemwera adahan pipit. Ku pis awna: “Ihi”, amawka ku inakni piwn hennewa “ihi”. Ku pis awna: “Kawa”, amawka ku inakni piwn hennewa “kawa”. Ku pis muwaka adahan pis awna yuwit mpiya inakni, in awaku pis mbeyepye pihiyakemni. ");
INSERT INTO plu_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","―Yikannuhten hawwata akki yit ku amekene Moís awna: “Ku pahapwi patukwika giwtyak, amawka ku ig diyuhkiska hawwata patukwika giwtyak. Ku pahapwi dunihpika gaybu, amawka ku ig diyuhkiska hawwata dunihpika gaybu.” Bawa ig amekene Moís awna inakni henne he adahan ig mpithene pahapwi adahan ig ka diyuhkiska mpiynama ahawna gitaraksan. Henneme yikannuhten idis gidahankiswa gihiyakemnikis atere, igkis awna: “Inakni giwn awna ku pugamawka wis diyuhkis pahapwi.” ");
INSERT INTO plu_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Nahme awna yit, ku pahapwi tarakse pikak, ka muwaka diyuhkisri. Ku pahapwi biyuhpokap, pi kabayte pis wages pahambakya adahan ig biyuhpokap pegbakte mpinekata pis diyuhkisri. ");
INSERT INTO plu_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ku pahapwi wasaymaptihpep git hiyaptigi adahan ig xuwehe pisimsa, uyá ikepni git payak akak pidagmanpit akiw. ");
INSERT INTO plu_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ku pahapwi suwtat mpiksaptihpi adahan pis hiyuh gisakola piyawakad, hiyuhniba pi piyawakte akiw gapiyukan mpiya ku samah gayapni pit. ");
INSERT INTO plu_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ku pahapwi makehe arikna pit, ikepniba git. Ku pahapwi sunepkere arikna pit, sunapkisniba git. ");
INSERT INTO plu_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","―Yikannuhten akki yit ku amekene Moís awna: “Bateknabay gikakkis hiyeg.” Ayteke igkis idis gidahankiswa gihiyakemnikis atere, igkis awna: “Henneme amiyhanay yipetunyapu.” ");
INSERT INTO plu_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Nahme awna yit, ka ba yi amiyha yipetunyapu henneme bateknabay gikakkis. Piriyepkawnabay gidahankis nerras ku pariye hiyapkis mbeyne yit. ");
INSERT INTO plu_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Kahadbe yis humaw Wigwiy inugikyene gikamkayupwi, awaku yihiyakemni kewa gidahanbe, mmanawa ig Uhokri kabutni kamuw ta gipititkis hiyeg mbayape payak gikakkis hiyeg kibeynepwi. Ig waykkis muwok ta gipititkis hiyeg wadityepwi payak gikakkis hiyeg kane wadityepwima. ");
INSERT INTO plu_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Amnihnabay yipetunyapu. Ku yis amnih nerrasnen ku pariye yamnihten nawenépwime yis ka amnihgikis mmah yis yipewkan Uhokri ikí yit kabayka adahan ini? Kawa. Mmanawa madikte hiyeg kuwis kehni henne. Juktah hiyeg kakehniye keh. ");
INSERT INTO plu_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Hawwata ku yis aytnih yikagmadapunen nawenépwime yis ka aytnihgikis, nikwe yis ka keh kabaytema giwkis madikte hiyeg. Hawwata hiyeg kane Uhokriyanpuma aytnih gikagmadapukis. ");
INSERT INTO plu_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Amawka ku wis amnih hiyeg apigkutaprik ku samah Wigwiy inugikyene amnihpigkis. ");
INSERT INTO plu_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","―Apuriwnabay ba yihiyakemni kibeynewatma. Araytak hiyeg keh kabayka ariwtrik hiyeg kahadbe igkis ikaka ku igkis kibeynepwi hiyeg. Amawka yis ka keh henne. Ku yis keh kabayka kahadbe hiyeg ikiyyi ku yis kibeynepwi hiyeg, nikwe yis ka utí kabayka giwntak Wigwiy inugikyene. ");
INSERT INTO plu_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ku aysaw pis amnih pahapwi, ka ba kinetihwa nimin kema nerrasma hiyapkisnepwi gabaykis. Igkis gibetkikis kinetihwa amin gabaykis ay agiku leglis hawwata ay apigku ahin. Igkis amnih hiyeg kahadbekam igkis ikaka ku igkis kibeynepwi hiyeg. Ku igkis ikaka henne, amun ini igkis kuwis utí kabayka ay amadga inin. Yuma akiw gidahankis ayhté inugik. Hennewatbaki igkis. ");
INSERT INTO plu_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Pisme ku aysaw pis amnih pahapwi, amawka pis amnihgi aparayewa ariw hiyeg marihwa pis ka humaw kawantipyema akak ini pamnihra. Juktah ka muwaka kinetihwa nimin git pikagmada kibeyne. ");
INSERT INTO plu_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ku pis amnih pahapwi aparayewa ariw hiyeg ku kiney ignewa Wigwiy hiyapi, nikwe ig Wigwiy ikí kabayka ta pitnek. ");
INSERT INTO plu_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","―Hawwata akiw ku aysaw pis piriyepkaw, ka ba piriyepkaw kema nerrasma hiyapkisnepwi gabaykis. Igkis batek piriyepkaw agiku leglis, hawwata wadé atusik ahin kahadbe igkis hiyapka gapitkis hiyeg, igkis ikaka ku igkis kibeynepwi hiyeg. Ku igkis ikaka henne, amun ini nikwe igkis kuwis utí kabayka ay amadga inin. Yuma akiw gidahankis ayhté inugik. Hennewatbaki igkis. ");
INSERT INTO plu_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Pisme ku aysaw pis piriyepkaw amawka pis piriyepkaw aparayewa ariw hiyeg marihwa pis ka humaw kawantipyema akak ini pipigyepkawni. Parak ta agikut pahayku xam sabuk lappot. Ayge pis piriyepkaw ta git Wigwiy ku kiney ignewa hiyapi. Ayge nikwe ignewa timá piwn ig ikí kabayka ta pitnek. ");
INSERT INTO plu_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ku aysaw yis piriyepkaw, ka ba yi diyuhpinaw kibereputnema amin yuwit arakembet akiw ku pariye he waditnepyenen kema nerrasma kane Uhokriyanpuma. Ignes gipewkankiskam ku amawka igkis piriyepkaw kihhaw akak kibite yuwit kahadbe giwohkigakis timap giwnkis. ");
INSERT INTO plu_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Yisme ka ba yi piriyepkaw henne kema igkisma. Mmanawa apit yis ayá arikna git Wigwiy, ayipa ig kuwis hiyak ku pariye yimawkanitnene git. ");
INSERT INTO plu_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","―Ku aysaw yis piriyepkaw, awnanay han: “Wighu inugikyene, usuh kabayhap. Pis kapikiythanisima. ");
INSERT INTO plu_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Usuh kaayhsima muwaka pikumadukan danuh atan amadgat inin. Wighu, umawkan pibetki kehka ay amadga inin hawwata ku samah in kehka ayge inugik. ");
INSERT INTO plu_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Iknaba wothu umana takunipti. ");
INSERT INTO plu_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Bayahminaba usuh ariw utaraksan hawwata ku samah usuh bayahmina ku pariye hiyeg taraksapye ukakhu. ");
INSERT INTO plu_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Iknaba wothu wawaygyi adahan usuh ka isaksewpima arit mbayka. Apuriwnaba usuh ariw ini mbeyepyenen wapitye gikumadukan. Usuh kabayhap, Kiyapwiye. Pisnewa kumaduka adahan apanenekwa. Pisnewa kapidatnisima adahan apanenekwa. Pisenwa kapikiythanisima adahan apanenekwa apanenekwa. Ameh.” Hennewatbaki yis piriyepkaw. ");
INSERT INTO plu_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Mmanawa ku yis bayahmina pahapwi ariw gitaraksan yikak, nikwe hawwata Wigwiy inugikyene bayahminay ariw yitaraksan gikak. ");
INSERT INTO plu_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Henneme ku yis ka bayahmina pahapwi ariw gitaraksan, nikwe Wigwiy kawnata bayahminay ariw yitaraksan. ");
INSERT INTO plu_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","―Ku aysaw yis maxhaw adahan yis gikiyetni Uhokri, ka yi muwaka maxhaw kema nerrasma hiyapkisnepwi gabaykis. Igkis gibetkikis waywe bibapyi gihepkakis. Igkis aseneweke gihepkakis kahadbe hiyeg hiyak ku igkis maxhewnes kahadbekam igkis ikaka ku igkis kibeynepwi hiyeg. Ku igkis ikaka henne, amun ini igkis kuwis utí kabayka ay amadga inin. Yuma akiw gidahankis ayhté inugik. Hennewatbaki igkis. ");
INSERT INTO plu_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Pisme ku aysaw pis maxhaw amawka pis maxhaw ayamaw marihwa pis ka humaw kawantipyema akak ini pimaxhawni. Sukuhapa pihepka barewap akuypa pisemnu kabayhtiwa ");
INSERT INTO plu_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","kahadbe hiyeg ka hiyak ba pis maxhewnema. Ayge pis maxhewne gidahannen Wigwiy. Ignewa Wigwiy hiyapi ku samah pis kiyenri nikwe ig ikí kabayka ta pit. ");
INSERT INTO plu_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","―Aharitnabay akebyi ini kabayka. Ka ba yi bayah igiska ay amadga inin ku kiney madikte ewkaki mehwa, ay ku kiney masumsu kagehbeta kamis, ay ku kiney sipari tihebdip, ay ku kiney amepwapye danuh kidis wewkanbet. ");
INSERT INTO plu_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Henneme bayahkisnabay yidahan igiska ayhté inugik ku kiney yumanene ewkaki mehwa, iné masumsu kawnata kagehbeta kamis, iné amepwapye kawnata danuh atere adahan igkis kidisnes wewkanbet. ");
INSERT INTO plu_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ku pis apanenekwa ipegminenekwa pihiyakemni amin arikna amadgaya inin, amun ini pidahan igiska ay amadga inin. Henneme ku pis apanenekwa ipegminenekwa pihiyakemni amin arikna inugikyene, amun ini pis kadahan igiska ayhté inugik. ");
INSERT INTO plu_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","―Wowtyak kewa pahá abukribe adahan upit. Ku wowtyak makniw, nikwe in ke wotbe upit ay abet kabutnikibe. Uhiyakemni hawwata. Ku in makniw, ayge nikwe in ke wotbe uhiyakemni ay abet kabutnikibe. ");
INSERT INTO plu_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Hawwata akiw ku wowtyak ka makniwnama, nikwe in ke wotbe upit ay abet amisnapyibe. Uhiyakemni hawwata. Ku wis ipegminene uhiyakemni amin ini msanpiki patehwepye amadgaya inin, ayge in ke wotbe uhiyakemni ay abet amisnapyadbe adahan wis ka hiyak ku pariye hiyakemniki inyerwatnene. ");
INSERT INTO plu_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","―Pahapwi ibukti ka ik adahan kakiparahaw gitkis gikipara piyamatema. Waké ig piyana gikebyikis gikiparabe, ig pi batektekam gikak pahapwi mpiy giw pahapwi. Ig miniwkam giw pahapwi adahan ig kannipwiye gidahan pahapwiwa. Wixwiy hawwata akiw. Ku wixwiy mpiksewne aharit igiska amadgaya inin adahan upitwiy, ka ik adahan wixwiy mpiksaw keh Uhokri gibetki nikwenéwatma. Amawka wixwiy kaniy pahapwiwa adahan wixwiy kakiparahaw git. ");
INSERT INTO plu_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Inneki keh nah awna yit, ka yi muwaka kiyimwihwa amin ariknawnama ku pariye muwekne yit, iné amin yaxni iné amin yihigpan adahan yih adehetni, iné amin yikawihni adahan yipit. Ku yis hiyá ig Uhokri kuwis ikí udehetniwiy, umanawiykata akiw ig ka ikí wotwiy akiw? Ku yis hiyá ig kuwis keh upitwiy, ukawihniwiykata akiw ig ka ikí wotwiy? ");
INSERT INTO plu_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ipegnay norras kuhipra amarape. Egkis ka mutuh ariknawnama, egkis kawnata taris ariknawnama iné egkis kawnata bayah ariknawnama agiku payt. Henneme Wigwiy inugikyene ikí gumanakis takunipti. Yis kaayhsima pi kapigte git Uhokri mpiy kuhipra. Ig ikí yit hawwata. ");
INSERT INTO plu_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ka ik adahan wis kiyabwih udehetni akak ku samah wis kiyimwihwa nikak. Wis kiyimwihwa nikak waditnepyenen. ");
INSERT INTO plu_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Mmahki nikwe yis kiyimwihwa amin yikawihni? Ipegnay ku samah ipuwiti gubereswankis. Egnes ipuwiti ka kannipwi adahan gupitkis. Egkis kawnata paduk gukawihnikis. ");
INSERT INTO plu_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Henneme egkis kagubereswankissima. Juktah amekene Salomawh gibereswan ka mataka gubereswankis. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Egkis ipuwiti he ewwaktinen egkis waditnepyenen. Ku apim ini egkis ay amadga inin. Takuwanekme egkis yuma akiw egkis bukehpika. Yis kaayhsima pi kapigte git Uhokri mpiy ipuwiti. Ku yis hiyá ig Uhokri ikí gubereswankis, yiskata akiw ig ka ikí yit yikawihni akiw? Mmahki yis ka kamaxwa ta gipitit Uhokri? ");
INSERT INTO plu_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ka yi muwaka kiyimwihwa. Ka yi muwaka amtaw: “Kit wis utí umana kuri? Kit wis utí uhigpan? Kit wis utí ukawihni?” ");
INSERT INTO plu_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ku yis amtaw henne, yis humaw kewa hiyegbe ku pariye kane Uhokriyanpuma. Ignes apanenekwa wakaymni aharit madikte ini. Yisme ka muwaka wakaymni henne. Wigwiy inugikyene ig hiyak madikte ku pariye yimawkanitnene. ");
INSERT INTO plu_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Aharitnabay kawih in kit Uhokri gikumadukan akak gihiyakemni kibeyne hiyakemniki. Ayge nikwe ig ikí yit madikte ku pariye yimawkanitnene. ");
INSERT INTO plu_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ka yi muwaka kiyimwihwa akak ku pariye nemnikumpiye yit takuwanek. Ig Uhokri hiyak nikak takuwanek. Ikeypi ig apuriwyi ku apim inin. ");
INSERT INTO plu_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","―Ka yi muwaka ikiy pahapwi ku ig ka kibeynema kahadbe ig Uhokri kawnata ikayi ku yis kawnata kibeynema. ");
INSERT INTO plu_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ku wis ikiy pahapwi ku ig kibeyne hiyeg, hawwata ig Uhokri ikiy wis ku wis kibeynewata. Henneme ku wis ikiy pahapwi ku ig ka kibeynema hiyeg, nikwe ig Uhokri ikiy wis ku wis kawnata kibeynema. ");
INSERT INTO plu_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mmahki pis apuriw pikebyi gitaraksan? Pis ke wotbe kiyimwihwa akak pahá iget nopsehsabe ay giwtrik pikebyi. Pisme ka hiyaknima ba pahat ahadma nopsadminnene ay piwtrik. ");
INSERT INTO plu_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ku aysaw ini ahad ay piwtrik, pis ka hiyá pisma awna ta git pikebyi: “Isaksanate nah wiwh ini iget piwtriktak.” ");
INSERT INTO plu_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Pis ikewne ke wotbe pis kibeynebe hiyeg bawa pis pi mbayte giw pikebyi. Asá hiyak akak pidahan kit pihiyakemni taraksepye. Ayge nikwe ik adahan pis hiyak akak pikebyi gitaraksan. ");
INSERT INTO plu_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","―Ku samah in ka kis adahan wis ikí kibeynewa axka ta git pahapwi pewru, in kawnata kis adahan wis akka kibeynewa hiyakemniki ta git pahapwi ku pariye kotenene ikte adahan ig pukuha inakni hiyakemniki. Ku wis akki kibeyne hiyakemniki git akebyi ner hiyeg, in ke wotbe wis padekne akabdatbe ta gitiput pahapwi pakirbe. Pakir ka hiyak ku pariye barewka. Nawenétke ig sibuhbetepni, ayteke ig wageswa kagehpew. ");
INSERT INTO plu_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","―Apanenekwa ayepnenekwa ta git Uhokri. Igme ikí yit ku pariye yayapni git. Ku ig ka ikí yit nikwenéwatma apim ini, ka sam. Ikawnay kewa pahapwibe ku pariye ipegpene pahá arikna juktah ig utipni. Ayge nikwe yis utinek ku pariye yimawkan. Ikawnay kewa pahapwibe ku pariye tetesnene anumeku pahapwi gilappota juktah igme woka ta git. Ayge nikwe ig Uhokri kaytwa yiwnnek. ");
INSERT INTO plu_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Mmanawa ku wis ayá kabayka git, ikaka wotnek. Ku wis ipegpene ku pariye umawkan git, wis utipni. Ku wis awna git, kaytwaka wownnek. ");
INSERT INTO plu_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ig ka kiniswi. Nah kehte abektey. Yis awaykemni, ku pahapwi yikamkayh ayá bugut yit, yis ka ikí tipma git. Yuma pahapwinama awayg kinis gikamkayh henne. ");
INSERT INTO plu_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Hawwata akiw ku yikamkayh ayá im yit, yis kawnata ikí kaybunema git. ");
INSERT INTO plu_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ku yis hiyá yis taraksapye ikí kibeyne arikna gitkis yikamkayupwi, igkata akiw Wigwiy inugikyene? Ig ikí kibeynewa arikna ta gitkis nerras ku pariye ayá git. ");
INSERT INTO plu_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Amawka yis kabay gikak pahapwi hawwata ku samah yis muwaka pahapwi kabay yikak. Inakni yuwit in huwase amekene Moís gikumadukan akak Uhokri gawnepepu pitatyepwi giwnkis madikte. ");
INSERT INTO plu_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","―Ay pitahra akebyi ahin adahan uhiyakemni. Ig Uhokri gihiyakemni kewa pahatra ahin mahamwisniyebe ku pariye mahiko wis wew apigku. Henneme paraknabay atere apigkut ini ahin. Mmanawa ku yis ka wew gikakma Uhokri gihiyakemni, in ke wotbe yis apigku pahatra ahin nopsad pugubrad ku pariye tipikwiye arimkat iwetrit ku kiney kaneayhsima hiyapka mbeyne ayge. Kaayhsima hiyeg tipikwiye atere. ");
INSERT INTO plu_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Henneme ini ahin nopsehsa mahamwisnene in tipikwiye arimkat kabayka dehetniki. Ka kiyesradima hiyeg utipni. ");
INSERT INTO plu_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","―Pukuhpawnabay gapitkis hiyeg ku pariye ikawnamahkis ke wotbe igkis Uhokri gawnepepube bawa igkis ka giwntakma Uhokri. Igkis hiyapkiswa yit huwipegepye kewa muttuhbe, henneme abet gihiyakemnikis igkis kewa axtigibe. ");
INSERT INTO plu_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nah akkite yit ku samah yis hiyak baki igkis giwntakwatma Uhokri. Ku yis hiyá ku igkis ka kehnema Uhokri gibetki, nikwe yis hiyakrikis ku igkis ka giwntakma Uhokri. Ku wis hiyá pahakti amutri eg ka sarayh guw kabaynopwima, nikwe wis hiyak ku eg amutri kane kabaynoma. Ke puduku akatbe ke ipeybe egkis ka sarayh guwkis kabaynopwima kema “uvama” kema “figuma”. ");
INSERT INTO plu_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ku pariye ah akat kabaynowa, eg sarayh guw kabaynopwi guw. Egme ah akat ku pariye kane kabaynoma, guw kawnata kabaynopwima. ");
INSERT INTO plu_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Pahakti ah akat ku pariye kabaynowa ka ik adahan eg sarayh guw mbeyepyoma guw. Iné pahakti ah akat ku pariye kane kabaynoma ka ik adahan eg sarayh guw kabaynopwima guw. ");
INSERT INTO plu_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Madikte ah akat ku pariye ka sarayh guwkis kabaynopwima, egnes ihukapepkanek egkis padakapepka ariwtrikut tiket adahan egkis bukahapepka. ");
INSERT INTO plu_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Hawwata yis hiyak ku pariye hiyeg ka kibeynepwima akak ini mbayka ku pariye pes giwntakkis. ");
INSERT INTO plu_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","―Ay hiyeg ku pariye awna nuthu: “Kiyapwiye, pis nukipara”, henneme waditnepyenen. Igkis ka kawih nukumadukan ayhté inugik. Ignewa ku pariye keh Wigwiy inugikyene gibetki, ignewa kawih. ");
INSERT INTO plu_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Aysawnemenek apim ini ku aysaw Uhokri hiyepne hiyeg ba ignes kibeynepwiwatma, ayge apim ini kaayhsima hiyeg awna nuthunek: “Kiyapwiye, Kiyapwiye, ka ba pis hiyak usuh? Minikwak usuh ekkene Uhokri gihiyakemni piwaprik, usuh pekkis kaayhsima wapitye piwaprik, usuh keh kaayhsima annut piwaprik.” ");
INSERT INTO plu_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Nahme kaytwa giwnkisnek: “Nah ka hiyakyiwa ku pariye yis. Higihwanabay aytekihan, yis taraksapye.” ");
INSERT INTO plu_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","―Ku pahapwi hiyeg timá nuwnhu, ku ig ihpene nuwnhu, iggi kewa pahapwi awayg hiyakemniyebe ku pariye mutuhne gipinbe akigbimna warik amadga kayhap. Ig tabirase gipin awaku ta abetit tip. ");
INSERT INTO plu_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ayteke ariwnteke ini muwok wayk kihhaw. Warik digise. Mayg kamayghaw huwit ta apitit gipin. Henneme gipin ka hakuh mmanawa awaku mituw kabayhtiwa ta warikwit abet tip. ");
INSERT INTO plu_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Henneme ku pahapwi hiyeg timá nuwnhu henneme ku ig ka ihpin, iggi kewa pahapwi awayg mahiyakemniyebe ku pariye tabirase gipin awaku ta abetit kayh. ");
INSERT INTO plu_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ayteke muwok wayk kihhaw. Warik digise. Mayg kamayghaw huwit ta apitit gipin. Pahaye adahan gipin hakuhe pahatte. Hennewatbaki ig Kiyapwiye Jesus awna. ");
INSERT INTO plu_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Pisenwa inakni gawnhan nerras hiyeg kabubuknene ayge igkis wakaymnibdi gidahan ku samah gikannuhakni. ");
INSERT INTO plu_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Mmanawa ig ka kannuhak kema nerras kannuhekeputnepwima amin amekene Moís gikumadukan. Henneme ig kannuhekne ayge akak madikte gikiythani. ");
INSERT INTO plu_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ayteke ig Kiyapwiye Jesus muhuke apititak ini waxri. Ku samah ig waywe, hiyeg kuruwnene gihapu butte. ");
INSERT INTO plu_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ayge pahapwi awayg axpusakare apit busukne ig danuh atere git. Ig paberetusaw ta gitiput. Ig awna git: ―Kiyapwiye, uyá amnihun. Ku pis muwaka piyihun, pis hiyá numakniwka. ");
INSERT INTO plu_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ig Kiyapwiye Jesus hiyapni henne, ig sarayh giwak ta gipitit. Ig daxwig atere. Ig awna git: ―Ihi. Nah muwaka. Pis makniw. Aynewa gibuskana miypi. ");
INSERT INTO plu_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ayteke ig Kiyapwiye Jesus awna git: ―Ataybiswanaba nuthu. Ka ba kinetihwa ta arit hiyeg apigkuya ahin amin ku samah pis makniw. Su atak wadé gimkanit muwpeg. Akka pipit ta git kahadbe ig iwasap ig hiyá ku pis makniw. Ayteke pis keh ofan gidahan Uhokri ku samah amekene Moís ayá wot minikwak, adahan arekhetni ta gitkis hiyeg ku pis inyerwa makniw. Igme timapni henne, ig tipik. ");
INSERT INTO plu_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ayteke ariwnteke ini ig Kiyapwiye Jesus danuh atere paytwempu Kafarnawh. Ayge pahapwi romayene suwtat gikiparakis ig danuh atere git. Ig amnihswe git. Ig awna git: ");
INSERT INTO plu_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","―Kiyapwiye, uyá amnihun. Nubukhu ig kakahriye harihte ayhté nupineku. Ig dathupye. Ig kaayhsima kayah. ");
INSERT INTO plu_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Igme Kiyapwiye Jesus kaytwa giwn: ―Nah atere piyihgi. ");
INSERT INTO plu_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Igme suwtat gikiparakis kaytwa giwn: ―Kawa, Kiyapwiye. Nah patehwepye hiyeg. Nah yuma nukiythanisima pitiput adahan pis parak nupinekut. Kiyapwiye, pis karayt akipara. Ku pis he awnepi aytontak piyawakad, ikeypi. Nubukhu makniwnek. ");
INSERT INTO plu_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nah hiyak mmanawa nah hawwata nah kakipara. Nah hawwata nah kumaduka nawenépwi suwtat akiw. Ku nah awna ta git pahapwi: “Su tipik”, ig iha nuwnhu ig tipik. Ku nah awna ta git pahapwiwa akiw: “Ba ayta”, ig iha nuwnhu ig ayta. Ku nah kawatni nubukhu, ig hawwata ig iha nuwnhu. ");
INSERT INTO plu_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ig Kiyapwiye Jesus timapni inakni henne, ig wakaymni kaayhsima. Ig awna ta gitkis nerras ku pariye kaneayhsima gihapu butte. Giwn: ―Ner suwtat kane israelyenema ig pi kamaxwate ta nupitit mpiya madikte nukebyupwi israelyenepwi. Nah ka hiyapti pahapwinama israelyene gikamaxwan kema nerma. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Aysawnemenek kaayhsima hiyeg kane israelyenepwima wahamapriktak upitkiyapriktak ignes kawih Uhokri gikumadukannek. Hennewatbaki in. Ayge igkis darihwaknek ayhté inugik gikak amekene Abrawh, gikak amekene Izaki, gikak amekene Jakó. ");
INSERT INTO plu_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ignesme nerras israelyenepwi ku kadahan ig Uhokri ahegbete ini gikumadukan pitatye, igkis ka darihninek. Igkis ipukapepkanek ta kabaywakat ta abetit amisnapyad. Ayge hiyeg tihebdinek ignes kagah gaybukis. ");
INSERT INTO plu_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ayteke ig Kiyapwiye Jesus awna ta git ner suwtat gikiparakis. Giwn: ―Hiyawa pis diyuhe pipinwate. Ku samah pis kamaxwa nupitit adahan nah piyihgi hennewa in humaw. Pase ig awna inakni, aynewa gibuk makniw. ");
INSERT INTO plu_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ayteke ariwnteke ini ig Kiyapwiye Jesus danuh ta gipinekut kiyapwiye Pedru. Ayge ig uté kiyapwiye Pedru gimatru egme harit akak nawwaki. ");
INSERT INTO plu_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ig Kiyapwiye Jesus hiyapni henne, ig atere gut. Ig sumuhe guwak. Aynewa gunawan mpiye guw. Ayteke eg kannikaw, eg kuwegwano gidahan. ");
INSERT INTO plu_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ayteke msanpi, kaayhsima hiyeg danuh atere git Kiyapwiye Jesus. Igkis waxe git hiyeg wapityewnapye. Igme pekkis wapitye gipititakkis akak gibiynenwa. Apim ini ig makniwe madikte hiyeg ku pariye kakahribdapye. ");
INSERT INTO plu_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","In danuh henne kahadbe in kahayak ku samah Uhokri gawnepe amekene Isaías awna minikwak. Ig awna: “Ig kayah ukayhawniwiy. Ig wiwh ukahriwiy upititakwiy.” ");
INSERT INTO plu_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Kaayhsima hiyeg ayge kabubukne ganwa Kiyapwiye Jesus. Ig hiyapni henne, ig awna ta gitkis gikannuhnipwi. Giwn: ―Uyay manuke ta pahambakaytak mahakwa. Igkisme kaytwa giwn: ―Uyay. ");
INSERT INTO plu_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Igkis tipikwiyes, igme pahapwi kannuhekeputne amin amekene Moís gikumadukan ig danuh atere git. Ig awna git: ―Kiyapwiye, nah tipik pikak ku kitwiye pis. ");
INSERT INTO plu_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Igme Kiyapwiye Jesus kaytwa giwn: ―Ba pis ahegbetnama adahan pis hiyepne mbeyne payak nukakhu? Puwikne kadahan giwetrikis agiku miyokwiye. Kuhipra kadahan guwetrikis apew ah. Nahme ku pariye wageswe awayg amadgaya inin nah yuma nuwetri adahan nah mayekne. ");
INSERT INTO plu_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ayteke pahapwiwa Jesus gikannuhni akiw ig danuh atere git. Ig awna git: ―Kiyapwiye, nah muwaka wew pikak henneme gita nighu miyapinate. Ku aysaw ig miyapi nah apuhpig, nikwe nah tipik pihapti. ");
INSERT INTO plu_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Igme Kiyapwiye Jesus kaytwa giwn: ―Ka sam pis ayta kurinewa. Hiyawa pis isaksa pahapwi ku pariye kuwis ke wotbe ig miyapyebe giw Uhokri, isaksig adahan iggi apuhe giyaki miyapiye. ");
INSERT INTO plu_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ayteke ig Kiyapwiye Jesus katapte ta muhumdakat. Gikannuhnipwi tipik gihapti. Igkis tarekwe ayteke. ");
INSERT INTO plu_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Igkis ku ayhté pakwa amadga mahakwa, pahaye adahan mayg kannikaw gimkanitkis, kaayhsima paraw katapte amadgat gihmunkis. Gihmunkis me buwisemet. Henneme ig Kiyapwiye Jesus himeke ayge gimadgakis. ");
INSERT INTO plu_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Igkis gikannuhnipwi hiyapni henne, igkis atere wadiswig. Igkis awna git: ―Kiyapwiye, uyá amnih usuh. Wixwiy me biyukapmet. ");
INSERT INTO plu_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Igme kaytwa giwnkis: ―Yis awaykemni apisatrupye! Mmahki yis ba yapisa tugun? Uhokri ik adahan yis kamaxwa ta gipitit. Ayteke ig kannikaw ig himehe mayg akak paraw. Aynewa madikte kariswehwe. ");
INSERT INTO plu_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Igkis gikannuhnipwi hiyapni henne, igkis wakaymnibdi gidahan. Igkis awna: ―Pariyeneki ner hiyeg? Juktah mayg akak paraw iha giwn. ");
INSERT INTO plu_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ayteke pisenwa igkis hamah pahambakat igkis minahwa atere apitit giwaxrikis hiyeg gadarayenepwi. Ayge piyana awaykemni wapityewnapye atere patipteke Kiyapwiye Jesus. Igkis pes abetitak imewti. Igkis kagamabyankissima. Ka ik adahan hiyeg wew atere ku kiney igkis msakwa. ");
INSERT INTO plu_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Igkis danuh atere git Kiyapwiye Jesus, igkis kabiman git. Igkis awna: ―Pis Uhokri gikamkayh. Pariye pikehni ukakhu ku apim inin? Mmah pis ayta womkat adahan hiyapkisne mbeyne wothu? Kote uhawkanaprikma adahan usuh hiyapkiska mbeyne wothu. ");
INSERT INTO plu_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ayge pahabunene pakirempu axwenekis ayge piyawakte giwkis aynessa. ");
INSERT INTO plu_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ayteke nikwe nerras wapityempu amnihswe ta git Kiyapwiye Jesus. Igkis ayá git: ―Ku pis pekkis usuh gipititakkis awaykemni, uyá awahkis usuh tahhan gipuritkis pakirempu. ");
INSERT INTO plu_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Igme Kiyapwiye Jesus awna ta gitkis: ―Tipiknay atere. Ayteke nikwe igkis pesbetwikis gipititakkis nerras awaykemni. Igkis pareke ta gipititkis ignes pakirempu. Igkisme pakirempu sigisbetwikis ta asebrikute. Igkis tubohbetwikis ta ahakwate mahakwa. Ayge igkis aniksewbet ahakwa un. ");
INSERT INTO plu_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Pakirempu gikapriwtenkis igkis hiyapni henne, igkis sigisbet kibentenwa ta paytwempuit. Igkis danuh atere, igkis kinetihwa amin gipigkis ku samah arikna danuhe gitkis. Hawwata igkis kinetihwa giminkis nerras awaykemni wapityewnapye. ");
INSERT INTO plu_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Nerras hiyeg paytwempuyenepwi igkis timapni henne, igkis pes apititak paytwempu adahan patiptaka Kiyapwiye Jesus. Igkis danuh atere git, igkis awna git: ―Su tipik aytekihan apititak uwaxri. ");
INSERT INTO plu_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ig Kiyapwiye Jesus timapni henne, ig katapte muhumdakat. Ig manuke mahakwa ig diyuhe ta apitit payhtwempu Kafarnawh ku kiney ig msakwa. ");
INSERT INTO plu_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ayteke hiyeg danuh atere, igkis waxe pahapwi awayg miyapupye ta gimkat Kiyapwiye Jesus. Ig harit amadga gisipamna. Ig Kiyapwiye Jesus hiyapni henne ku samah gikamaxwankis ta gipitit, ig awna ta git awayg miyapupye. Giwn: ―Ka ba barukinama, nukebyi. Nah bayahminap ariw pitaraksan gikak Uhokri. ");
INSERT INTO plu_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Apiminewa ini kaayhsima kannuhekeputnepwi amin amekene Moís gikumadukan igkis ayge. Gaytakkis timapni inakni Kiyapwiye Jesus giwn, igkis awna gimin ginaktinkis. Giwnkis: ―Ner awayg ikewne ke wotbe ig Uhokribe bawa ig ka Uhokrima. Ig miyathene Uhokri ku samah ig awna inakni henne. ");
INSERT INTO plu_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ig Kiyapwiye Jesus hiyakni henne ku samah gihiyakemnikis, ig awna ta gitkis: ―Mmahkay yis ipegminene yihiyakemni amin mbeye hiyakemniki henne? ");
INSERT INTO plu_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Mmah yipewkan ku in mahiko ndahan nah bayahminig ariw gitaraksan? Ku yis hiyá nah hiyá gikankasak nah keh ig wew akiw, ininkata akiw nah ka dat adahan nah bayahminig ariw gitaraksan? ");
INSERT INTO plu_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Nah hiyapkiste yit ku nah ku pariye wageswe awayg amadgaya inin nahnewa detye amadga inin adahan nah bayahminene hiyeg ariw gitaraksankis gikak Uhokri. Ayteke ig awna ta git ner awayg miyapupye. Giwn: ―Kannikaw kuri. Kidisnaba pisipamna. Hiyawa pis diyuhe pipinwate. ");
INSERT INTO plu_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Aynewa ig awayg kannikaw. Ig tipik gipinwate. ");
INSERT INTO plu_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Madikte hiyeg kabubuknene ayge igkis hiyapni henne, igkis wakaymnibdi. Igkis awna: ―Kibeyne, Uhokri, ku samah pis iké pannu henne ta git pahapwi amadgaya inin. ");
INSERT INTO plu_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ayteke ig Kiyapwiye Jesus tipik. Ig waywe apigku ahin, ig hiyapun nah Matews, nah betnene agiku payt ahiwket karukri. Nah ladwan, nah ahiwne karukri gidahan gupelma. Igme awna nuthu: ―Ba ayta wew nukakhu adahan pis humewne nukannuhni. Nah timapni henne, nah kannikew, nah tipik gikak. ");
INSERT INTO plu_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ayteke ig Kiyapwiye Jesus danuh ta nupinekut. Ayge ig axne nukakhu. Kaayhsima ladwan danuh atere payak gikakkis hiyeg akiw ku pariye ikaka kane kibeynepwima hiyeg. Igkis hawwata ax gikak Kiyapwiye Jesus gikakkis gikannuhnipwi. ");
INSERT INTO plu_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nerras farisewkis hiyapni henne, igkis awna ta gitkis gikannuhnipwi. Giwnkis: ―Mmahki ner yikannuhten axne darihwekne gikakkis ladwan gikakkis hiyeg akiw kane kibeynepwima hiyeg? Waké ig kibeyne hiyegbe, ig ka axkam gikakkis gikebyikis nerras hiyeg. ");
INSERT INTO plu_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ig Kiyapwiye Jesus timapni henne, ig kaytwa giwnkis. Ig awna ta gitkis: ―Hiyeg kane kibeynepwima ignes kewa hiyeg kakahribdapyebe. Igkis muwaka pahapwi ayta amnihgikis. Ignesme hiyeg makniwyepwi igkis ka muwaka mekseh. Igkisme hiyeg kakahribdapye igkis muwaka mekseh. ");
INSERT INTO plu_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ataknabay ipegboha Uhokri gannasan minikweknene marihwa yis pukuha inin ku samah nah darihwekne gikakkis hiyeg kane kibeynepwima. Mmanawa ig Uhokri gannasan awna: “Nah ka muwaka yis he kakanhawnen nuthu. Nah pi muwakate yis amnih hiyeg.” Mmanawa nah ka ayta adahan nah humeknema ku pariye hiyeg wadityepwi kuwis adahan ignes wageswiyes gihiyakemnikis. Nah ayta adahanikwa nah humekwiye nerras ku pariye taraksapye adahan ignesnewa wageswiyes gihiyakemnikis. ");
INSERT INTO plu_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ayteke amekene João Batista gikannuhnipwi igkis danuh atere git Kiyapwiye Jesus. Igkis awna git: ―Kiyapwiye, usuh maxhaw adahan kiyene Uhokri. Kibereput usuh maxhaw adahan usuh piriyepkewne. Igkisme farisewkis hawwata akiw igkis maxhaw henne. Pisme pikannuhnipwi ka maxhaw. Mmahki igkis ka maxhaw henne? Mmahki igkis ka kiyatha Uhokri kema nerrasma? ");
INSERT INTO plu_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Igme Kiyapwiye Jesus kaytwa giwnkis: ―Igkis ka maxhaw adahan nukiyetni mmanawa nah kupiknene ay gikakkis. Nah kehte abektey akak pahapwi awayg maripkewpiye. Ku aysaw ig maripkewpiye nikwe gikagmadapu ayta iwasa gimaripkawni. Ku samah ig ayge gikakkis abet ini fet ba igkis kadni giharit? Ba igkis maxhaw? Kawa. Henneme aysawnemenek ku aysaw nah iwepka giwkis nukannuhnipwi, apim ini nikwe igkis maxhawnek. ");
INSERT INTO plu_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ayteke ig Kiyapwiye Jesus keh nawenéwa abektey akiw. Giwn: ―Ka kis adahan wis kahapa simis mugumugupiye akak nukune kamis mmanawa kamis nukune ku pariye kote sukuhate in ik adahan tariswa mmanawa in kote dahwate kema mugumugupiyema. Ku pahapwi kahapa gisimsa mugumugupiye akak nukune kamis, in tariswa. Gisimsa sigka pi kiyeste akiw. ");
INSERT INTO plu_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kawnata kis adahan wis katiyha win nukune agikut pakir amar ayipwipye ipatmakupye. Mmanawa ku aysaw ini win tukurwa in kiyesihwa akiw, in pakir amar ka ahwa payak nikak. In bekwe awaku. Ayge nikwe ini win dimuke. Hawwata ini pakir amar ka kabay akiw. Amawka wis katiyha win nukune ta agikut pakir amar ku pariye mtibetnene. Ayge nikwe win atiy msakwa kabayhtiwa payak akak win. Nuhiyakemni kis gikakkis hiyeg ku pariye kote dahhate gihiyakemnikis. ");
INSERT INTO plu_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ig Kiyapwiye Jesus awnempiye inakni yuwit henne, pahapwi awayg leglis akipara danuh atere git. Ig paberetusaw ta gitiput Kiyapwiye Jesus, ig awna git: ―Kiyapwiye, uyá amnihun. Nukamkayh kuhwekwa eg biyuke. Ba ayta sarayh piwak ta gupitit kahadbe eg kannikaw ariw gumiromni. ");
INSERT INTO plu_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ig Kiyapwiye Jesus timapni henne, ig kannikaw ig tipik gihapti ner awayg. Usuhme gikannuhnipwi tipik gihapti. ");
INSERT INTO plu_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ku samah gitepkemni, pahapu tino danuh gihapu butte. Eg kuwis hiyá mbeyne akak guminewkan adahan kaayhsima kamukri kuwis, madikawkubu akebyi akak pikana arawna (12). Eg danuh atere giharaptak, eg dax gikanwapta akigbimna. ");
INSERT INTO plu_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Mmanawa eg awna gunaktin: ―Ku nah he daxpi gisimsa, ikeypi, nah makniw. ");
INSERT INTO plu_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Igme Kiyapwiye Jesus wagestaw ig hiyapru. Ig awna gut: ―Ka ba barukinama, nukebyi. Pis makniw mmanawa pis kamaxwa ta nupitit. Aynewa eg tino makniw. ");
INSERT INTO plu_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ayteke ig Kiyapwiye Jesus danuh atere gipinekut ner awayg leglis akipara. Ayge ig hiyá kaayhsima hiyeg agighenes kadukmanes adahan igkis ekkenes gikadnikis. ");
INSERT INTO plu_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ig hiyapni henne, ig awna gitkis nerras hiyeg: ―Ayguhwanabay aytekihan. No bakimni ka miyó. Himak eg. Igkisme hiyaraptihpig. ");
INSERT INTO plu_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Igkis pesantenwa, igme Kiyapwiye Jesus parak ta agikut xam. Ayge ig sumuhe no bakimni guwaku. Aynewa eg kannikew. ");
INSERT INTO plu_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ayteke inetit amin ini gannu ibekhewpi muwwapu kiw paytwempu. ");
INSERT INTO plu_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Pisenwa ig Kiyapwiye Jesus tipik ayteke. Ayge apigku ahin piyana gikebyikis motapye waywe gihapu butte. Igkis amnihswenes git. Igkis awna: ―Kiyapwiye Jesus, pis ukipara hawwata ke amekene Davibe. Uyá amnih usuh. ");
INSERT INTO plu_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ayteke ig Kiyapwiye Jesus pareke ta paytrikut. Nerras piyananene motapye hiyapni henne, igkis pareke atere git. Igme Kiyapwiye Jesus awna ta gitkis: ―Ba yis kamaxwa nupitit ku nah detye keh yis hiyap? Igkisme kaytwa giwn: ―Ihi, Kiyapwiye. Usuh kamaxwa pipitit. ");
INSERT INTO plu_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ig Kiyapwiye Jesus timapni henne, ig dax giwtyakkis. Ig awna ta gitkis: ―Ku samah yis kamaxwa nupitit hennewa in humaw. ");
INSERT INTO plu_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Aynewa giwtyakkis hiyap. Ig Kiyapwiye Jesus hiyapni henne, ig awna ta gitkis: ―Ka ba yi kinetihwa amin ini nannuh ta gitkis hiyeg. ");
INSERT INTO plu_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Henneme igkis ka iha giwn, igkis tipik kinetihwa amin ku pariye Kiyapwiye Jesus keh gidahankis. Igkis kinetihwa muwwapu kiw paytwempu. ");
INSERT INTO plu_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Igkis pesantenwa paytrikutak, hiyeg waxe ta git Kiyapwiye Jesus pahapwi awayg monpiye. Ig monpi awaku wapitye ay gipit. ");
INSERT INTO plu_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Igme hiyapni henne, ig pekkise ner wapitye gipititak. Pase ig wapitye pes ayteke gipititak ner awayg, ig awayg kapusaw awna. Nerras hiyeg kabubuknene ayge igkis hiyapni henne, igkis wakaymnibdi kaayhsima. Igkis awna: ―Usuh kote hiyapte akebyi ini ay Israelyamnaw. ");
INSERT INTO plu_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Igkisme nerras farisewkis ayge igkis awna: ―Ig ipuke wapitye gipititak ner awayg akak wapitye gikiparadkis gannu ay gipit. ");
INSERT INTO plu_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ayteke ariwnteke ini ig Kiyapwiye Jesus mpiye muwwapu apuriw paytwempu nopsadmin, apuriw paytwempu nopsanyupnene akiw. Ayge ig kannuhekne agiku judeyenepwi gileglisakis. Ig ekkene inakni kibeyne inetit gimin Uhokri gikumadukan. Ig makniwene hiyeg ariw madikte karaytpiyene, ariw madikte mabimnakatru. ");
INSERT INTO plu_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Apim ini ig sarayh gipegyi ta gimkatkis hiyeg kabubuknekis ayge. Ig kayah apit giyakni. Ig kayah gidahankis ku samah igkis kiymare ginaktinkis, igkis yuma gawaygyikis. Igkis ayge kewa muttuhbe ku pariye yumanene gikiparakis gikapriwtenkis. ");
INSERT INTO plu_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ig hiyapni henne, ig awna ta wothu gikannuhnipwi: ―Kaayhsima hiyeg kuwis ahegbet adahan igkis kamaxwepyes ta nupitit. Ta nuthu igkis kewa pahak wasbe ipatrik ahegbet adahan tariswiki. Henneme ka kiyesradima hiyeg akki ndahan nuhiyakemni gitkis. ");
INSERT INTO plu_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Piriyepkawnabay ta git Kiyapwiye was akipara adahan ig kawatni hiyeg adahan ignes kinetihwenes gitkis numinhu. ");
INSERT INTO plu_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ayteke ariwnteke ini ig Kiyapwiye Jesus pahadguhe usuh giwatnipwi madikawkunene ukebyi akak piyana wawna (12). Ayge ig iké kumadukaki wothu adahan usuhme pekkiswiye wapitye gipititakkis hiyeg adahan usuh makniwene hiyeg ariw madikte karaytpiyene ariw madikte mabimnakatru. ");
INSERT INTO plu_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nah akkite wowhu yit: Pitatye kiyapwiye Simawh kewye Pedru gikak gisamwi kiyapwiye André. Ayteke amekene Tiyagumni gikak gisamwi kiyapwiye João ku pariye amekene Zebedew gikamkayupwi. ");
INSERT INTO plu_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ayteke kiyapwiye Filip gikak kiyapwiye Bartolomew. Ayteke kiyapwiye Tomé nukakhu nah Matews nah ladwan. Ayteke kiyapwiye Tiyagu, ku pariye amekene Alfew gikamkayh, gikak ");
INSERT INTO plu_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","kiyapwiye Tadew. Ayteke kiyapwiye Simawh Zeloti gikak Judas Iskariyotismin ner kamaykistinene Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ig Kiyapwiye Jesus wawahkiswitni usuh muwwapu usuh madikawkunene ukebyi akak piyana wawna (12). Ig awna wothu: ―Ka yi muwaka atak ta apitit hiyeg kane judeyenepwima giwaxrikis iné ka yi muwaka atak ta apitit paytwempu gidahankis hiyeg samariyenepwi. ");
INSERT INTO plu_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Henneme ataknay ta gitkis nerras uyakipwi israelyenepwi. Igkis kewa muttuh biyukapyebe nuthu. ");
INSERT INTO plu_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ataknabay, akkanay ku ahawkanaprik Uhokri gikumadukan kuwis danuh. ");
INSERT INTO plu_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Makniwanabay hiyeg kakahribdapye. Kannikasanabay hiyeg miyarapye. Makniwanabay hiyeg axpusakare apit busukne. Pekkisnabay wapitye gipititakkis hiyeg. Nah ikene ini yannu he nukannenwa yuma atiwni. Kuri yisme amnih hiyeg hawwata yuma atiwni. ");
INSERT INTO plu_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ataknay hennen yiwakyékata. Ka yi muwaka atak akak pahamkunama karukri agiku yipusra, iné karukri wahano kuwikwiye, iné karukri wahano seyno, iné karukri kuriwra. ");
INSERT INTO plu_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Yis kawnata muwaka atak akak yisakola adahan yiwewni. Yis kawnata muwaka atak akak pikanama yisimsa iné akak yikasotni, yasuga. Kis adahan yis utí yimawkanitnene giwntakkis nerras ku pariye yis amnih. ");
INSERT INTO plu_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ku pariye paytwempu yis danuh arit, ipegpanay pahapwi ku pariye kibeyne awayg ayge. Msakwanay ayge gimun he ku aysaw yis pes ayteke paytwemputak. ");
INSERT INTO plu_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ku aysaw yis pitatye parak gipinekut, awnanay ta gitkis hiyeg aygnenepwi, “Uhokri gabay yikaknek.” ");
INSERT INTO plu_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ku igkis hiyeg amapay kabayhtiwa, hennewa ig Uhokri gabay msakwa gikakkis. Henneme ku igkis ka amapay nikwe Uhokri gabay ka msakwa gikakkis. ");
INSERT INTO plu_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ku igkis hiyeg ka amapay, ku igkis ka timepkere yiwn, nikwe pase yis pes ayteke agikutak gipinkis apititak inere paytwempu, yis sassah yikugku ariw apathawni. Ini arekhetni ku samah gitaraksankis. ");
INSERT INTO plu_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Aysawnemenek apim ini ku aysaw hiyeg katiwnipwe apatra gitaraksankisnek, nerras hiyeg apitya inere paytwempu ignes pi hiyapte mbeyne mpiya nerras hiyeg mbeyepye gihiyakemnikis apitya paytwempu Sodoma akak Gomoha. Henneki igkisnek hiyá mbeynenek. ");
INSERT INTO plu_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","―Nah awahkisyi ta gipuriwkis hiyeg ke wotbe nah awahkiswiyebe muttuh ta gibetitkis axtigibe. Nikwe msakwanabay ahegbetnenekwa gapitkis hiyeg ke pahapwi kaybunebe ig ahegbetnenekwa adahan hiyeg ka sibuhgi. Henneme ikawnabay tuwatapye ayge gibetkis ke pahapu tukwabe. ");
INSERT INTO plu_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Msakwanay ahegbet gapitkis hiyeg mmanawa aysawnemenek igkis kamaxweynek waxepyi ta gipetunatkis hiyeg giwewkistenkisnek. Hawwata igkis biyuhyinek agiku gileglisakis. ");
INSERT INTO plu_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Apim ini yis kamiyepkanek ta gitkis hiyaptigi ta gitkis ikiparat. Yis waxepka ta gipetunatkis apatra ku samah yis nuhiyegapu. Ka sam. Ini humaw yihawkanaprik adahan yis kehne temwe ndahan ay giwtrikkis. Ayge yis kehne temwe ndahan giwtrikkis hiyeg judeyenepwi giwtrikkis hiyeg kane judeyenepwima. ");
INSERT INTO plu_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","―Ku aysaw hiyeg kamiyepyi ta gipetunatkis hiyaptigi apatra ku samah yis nuhiyegapu, ka yi muwaka ipegmina yihiyakemni adahan ku pariye yis awna gitkis apim ini hawkri. Mmanawa apiminewa ini yuwit ikaka yit adahan yis awna gitkis apim ini. ");
INSERT INTO plu_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ayge nikwe ka yisnama awnene henneme Wigwiy Gitip ignewa awnene ay yipititak. ");
INSERT INTO plu_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Apim ini hawkri ignespeke pakebyekne kamaykisegbet adahan miyaka. Ignesme igti kamaykis gikamkayhkis. Ignesme ikamkayit hawwata kapetunsa gigkis gukakkis ginagkis. Igkis kamaykiswigkis adahan miyaka. ");
INSERT INTO plu_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ayge madikte hiyeg amiyhepyi awaku ku samah yis nuhiyegapu. Ka sam. Ku yis ka ahkiswa nuwhu juktah amaksemni hawkri, yis isamtawnek. ");
INSERT INTO plu_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ku aysaw yis hiyapkiska mbeyne yit ay apit pahá paytwempu, higihwanay ayteke ta apitit nawenéwa paytwempu akiw. Apit yis muwwapwise paytwempu ay Israelyamnaw, nah danuh akiw nah ku pariye wageswe awayg amadgaya inin. Ihanabay inakni nuwnhu. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Yuma pahapwinama hiyeg pi kiyatte giw gikannuhten. Yuma pahapwinama ibukti pi kiyatte giw gikipara. ");
INSERT INTO plu_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ku pahapwi mataka gikannuhten gikiythani gikipara gikiythani, ikeypi. Ku yis hiyá nah yikipara kanumka wapityeyan, yiskata nuhiyegapu akiw? Yis hawwata kanumka wapityeyannek. ");
INSERT INTO plu_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","―Henneme ka yi muwaka apis gibohrikis hiyeg amadgayapu inin. Gitkis gikehnikis mbayka ka kahayak. Henneme aysawnemenek madikte ku pariye ayempiki ini kahayak kabayhtiwanek. Madikte ku pariye awastepka, aysawnemenek in mawasaptihpikanek. ");
INSERT INTO plu_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nuhiyakemni hawwata akiw. Ku pariye nah akki yit yisyékata, yisme akkin ta gitkis madikte hiyeg. Ku pariye nah akki yit kabayanesa yisme akkin gipuriwkis hiyeg akak madikte yihawna. ");
INSERT INTO plu_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ka yi muwaka apis gibohrikis nerras ku pariye umehpiye upitwiy, utipwiyme igkis ka hiyá ariwmhak. Henneme apisnay gibohri Uhokri ku pariye hiyá ariwmhak upitwiy payak akak utipwiy ayhté amun ini iwetrit ku kiney kaneayhsima kayahwaki. Apisnay gibohgi iggi. ");
INSERT INTO plu_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ig hiyá womhakwiy, ig hawwata hiyá ukapriwkay. Ka ba yis hiyá ku samah ig apuriw madikte kuhipra? Egkis ka ariknawnama egkis piyukka piyana gukebyikis adahan pahamkuwa kirehka henneme Wigwiy apuriwgukis. Yuma pahapunama tuguh waygboit ku ka igma Uhokri isaksepru adahan eg tuguhe waygboit. ");
INSERT INTO plu_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ku yis hiyá ig apuriw kuhipra, wixwiykata akiw ig ka hiyá ukapriwkay hawwata akiw? Yuma aynesnima ig ka hiyakma. Juktah usemnu ig kuwis pukuh madikte. ");
INSERT INTO plu_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ka yi muwaka apis. Wixwiy pi kapigte git Uhokri mpiy madikte kuhipra. Ig apuriwwiy hawwata. ");
INSERT INTO plu_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","―Ku pahapwi keh temwe ndahan ta gitkis hiyeg ay amadga inin, aysawnemenek nah hawwata nah keh temwe gidahannek ta git Wigwiy ayhté inugik. ");
INSERT INTO plu_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Henneme ku pahapwi wihwe nuwhu ay gimunkis hiyeg amadga inin, nah hawwata aysawnemenek nah wihwe giwnek ayhté inugik gimun Wigwiy. ");
INSERT INTO plu_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","―Ka yi muwaka ikiy ku nah ku samah nah danuh atan nah keh madikte hiyeg amadga inin pasamrak pawtak apim inin. Kawa. Apim inin hiyeg kerye yikaknek nupatra. ");
INSERT INTO plu_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ikamkayti kapetunsa gigkis gukakkis gunagkisnek awaku ku samah egkis kamaxwenes nupitit. Ihinyot kapetunsa gumatrukisnek awaku ku samah eg gumatrukis kamaxwanos nupitit. ");
INSERT INTO plu_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Awayg gimunyapu igkiswa humaw gipetunyapunek. ");
INSERT INTO plu_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","―Ku pahapwi pi batekte gikak gig gukak ginag mapiyan, iggi ka kis adahan ig awna ku ig nuhiyega. Ku pahapwi pi batekte gikak gikamkayh mapiyan, ig kawnata kis adahan ig awna ku ig nuhiyega. ");
INSERT INTO plu_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Amawka ku nuhiyegapu umahkis gihiyakemnikis amedgene inin ke wotbe igkis daddahkiswinbe ta aminat ahbe, igkis ka ik adahan igkis keh nibetki akiw. Ku pahapwi ka umahkis gihiyakemni henne hawwata ke nahbe, iggi ka kis adahan ig awna ku ig nuhiyega. ");
INSERT INTO plu_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Pahapwi ku pariye darihkerepye giwskawni amadgaya inin, iggi biyuk akak giwskawni giwntak Uhokri. Henneme pahapwi ku pariye miyeh gidahanwa giwskawni amadgatak inin ndahan, iggi darih giwskawni giwntak Uhokri. ");
INSERT INTO plu_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","―Ku pahapwi amapay, amun ini nikwe in ke wotbe ig kuwis amapan hawwata. Ku pahapwi namerepten, amun ini nikwe in ke wotbe ig kuwis amapa ku pariye nawahkisten atan amadgat inin hawwata. ");
INSERT INTO plu_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ku pahapwi amapa pahapwi Uhokri gawnepe awaku ig Uhokri gawnepe, iggi utí inwata kabayka ku pariye Uhokri gawnepe utinek. Hawwata akiw ku pahapwi amapa pahapwi awayg kibeyne awaku ig kibeyne hiyeg, iggi utí inwata kabayka ku pariye awayg kibeyne utinek. ");
INSERT INTO plu_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Hawwata akiw ku pahapwi amnih pahapwi nukannuhni yumahwatnene gikiythani awaku ig nukannuhni, ku ig he ikí aynessa un kisepye ta git, ayge nikwe ig utí gitiwninek. Ihanabay inakni nuwnhu. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Pisenwa inakni gawnhan ig Kiyapwiye Jesus awahkise usuh giwatnipwi muwwapu usuh madikawkunene ukebyi gikakkis piyana wawna (12). Ayteke nikwe ig tipik uhapu ta apitit mpuse paytwempu adahan ig kannuhekne adahan ig ekkene Uhokri giwn ta gitkis hiyeg aygnenepwi. ");
INSERT INTO plu_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Apim ini ig amekene João Batista ig ayge agiku parakseket. Ayge ig kinetni Cristo gak ku ig kehne kaayhsima annut. Ig timapni henne, ig awahkise gikannuhnipwi atere gimin Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Igkisme tipik danuh atere git, igkis awna git: ―Kiyapwiye João Batista awna wothu ku pahapwi nemnikumpiye gihapu butte. Kame pisnema aytniye? Ba kawk? Ba usuh wahap pahapwi nawenéwa ku pariye nemnikumpiye gihapu butte akiw? ");
INSERT INTO plu_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Igme Kiyapwiye Jesus kaytwa giwnkis: ―Ataknabay akka ta git kiyapwiye João Batista ini annut ku pariye yis timap yis hiyap ku apim inin. ");
INSERT INTO plu_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Yis hiyá motapye hiyap, miyapupye wew. Yis hiyá axpusakare apit busukne miypit, mataybapye timap, miyarapye kannikaw. Yis hiyá nerras ku pariye kane hiyak kabayka, ku apim inin igkis ekkepka kabayka gitkis. ");
INSERT INTO plu_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ku pariye hiyeg ka tukuhun igkis utí kabayka nuwntaknek. ");
INSERT INTO plu_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Igkis amekene João Batista giwatnipwi timapni henne, igkis diyuhe gimkat. Igkis tipikanten, ig Kiyapwiye Jesus awna ta gitkis nerras hiyeg kabubuknene ayge. Ig kinetihwa gimin amekene João Batista. Ig awna: ―Yis kuwis atak iwasa kiyapwiye João Batista ta amadgat amatap. Ku samah yis atere, mmahpa yipewkan yis utipri ayge? Mmah yipewkankama ku yis utipri yuma gidatni ke pahat sipapabe ku pariye mtibetnepye ayge? Kawa. Yis hiyak ku ig ka wagekiswa gimun. ");
INSERT INTO plu_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Mmahpa yipewkan yis utipri ayge? Mmah yipewkankama ku yis utipri akak gisimsa kibeyne mtibete? Kawa. Hiyeg ku pariye kasimsapu mtibete ku pariye igisapye ignes ka msakwa amadga amatap. Igkis msakwa agiku ikiparat gipin barewyewatnene. ");
INSERT INTO plu_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ba yis yipewkan ku yis utipri Uhokri gawnepe ayge? Hennewa. Ignewa Uhokri gawnepe yis utí. Henneme ig mpiybeta Uhokri gawnepepu pitatyepwi mmanawa ig ekkene ku Uhokri gikumadukan kuwis ahawkanaprik. ");
INSERT INTO plu_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Mmanawa ig kiyapwiye João Batista ignewa ku kamin Uhokri gannasan minikweknene kinetihwa. Inakni gannasan akki wot ku pariye Uhokri awna ta git gikamkayh. Giwn: “Nah awahkiste pahapwi nuwatni papitkiya adahan ig ahegbetene madikte papit.” Hennebaki inakni yuwit awna gimin kiyapwiye João Batista. ");
INSERT INTO plu_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Yuma pahapwinama awayg waypuka amadga inin kabaytema giw kiyapwiye João Batista. Henneme pahapwi ku pariye kuwis kawih Uhokri gikumadukan iggi pi kabayte giw kiyapwiye João Batista. Hiyawa ig pahapwi yuma gikiythani giwtrikkis hiyeg amedgenene inin henneme ig pi kabayte giw mmanawa ginetni pi kabaytenene akiw. ");
INSERT INTO plu_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Igme kiyapwiye João Batista ginetni kabayhtiwa. Kibeyne, ku samah ig kapusa akka adawnhan Uhokri gikumadukan juktah kupiknene, kaayhsima hiyeg mpiksewne kawih ini gikumadukan. Igkis mpiksaw niharit akak madikte gidatnikis. ");
INSERT INTO plu_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ig kiyapwiye João Batista pi kabayte giwkis Uhokri gawnepepu pitatyepwi. Mmanawa Uhokri gawnepepu pitatyepwi igkis madikte awnanekwiye ku aysawnemenek Uhokri gikumadukan danuhnek. Amekene Moís gikumadukan akki inaknipahwata. Kurime ig kiyapwiye João Batista ekkene ku gikumadukan ahawkanaprik kuwis danuh. ");
INSERT INTO plu_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","―Igkisme nerras Uhokri gawnepepu pitatyepwi awna: “Aysawnemenek pahapwi awayg kewa amekene Eliyasbe ig danuhnek adahan ig ekkepye adawnhan Uhokri gikumadukan.” Kuri nah akkite yit ku pariye ner awayg. Henneme nah ka hiyak ba yis amapa nuwnhu. Ignewa kiyapwiye João Batista. ");
INSERT INTO plu_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Yis ku pariye katayebnene, ataybiswanabay nuthu. Ihanabay inakni nuwnhu. Hennewatbaki ig ke amekene Eliyasbe. ");
INSERT INTO plu_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","―Mmah nuwnhu kuri adahan nah akki yit ku samah hiyeg gihiyakemnikis amadgaya inin? Gihiyakemnikis ke bakimnaybe nopsahyumni gihiyakemnikisbe. Nah akkite yit abektey akak ku bakimnay arehwene higiwmadga. Ig Uhokri ig kewa bakimnaybe ku pariye wakaymni giminkis gidahewektenkis. Igkis bakimnay kabiman ta gitkis gidahewektenkis. ");
INSERT INTO plu_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Igkis awna gitkis: “Usuh agighene usuh kayepne yisme ka kaykere ukakhu. Yisme ka batekkere payak ukakhu. Ayteke nikwe usuh wages warehwan adahan apuhekwiye usuh tihene. Yisme kawnata tihkere payak ukakhu. Mmahki yis ka amepekere uhiyakemni?” Ihanabay inakni nuwnhu. Hennewatbaki ig Uhokri. Hiyeg amedgenepwi inin ka amepekere pahapwinama Uhokri giwatni ku pariye gawahkisni giminkis. ");
INSERT INTO plu_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Mmanawa ig kiyapwiye João Batista danuh atan, ig maxhewne ig ka higap win. Ignesme hiyeg ka amapig. Igkis awna: “Ig wapitye gipit.” ");
INSERT INTO plu_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nahme nah ku pariye wageswe awayg amadgaya inin, nah danuh atan nah ka hennema. Nah ka maxhaw nah higap win. Henneme kawnata hiyeg amapan. Igkis awna: “Ka ba yis hiyá ner awayg kayhpiye kahigpekepye? Ig gibetki darihwak gikakkis ladwan gikakkis hiyeg kane kibeynepwima akiw. Ig kawnata kibeynema hiyeg.” Ka sam. Ku pariye hiyeg kehnepwi hiyakemniki ignesnewa ka mahikoh Uhokri gihiyakemni. Igkis amapinnek. ");
INSERT INTO plu_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ayteke ig Kiyapwiye Jesus kapusa wakaymni gidahankis hiyeg apitnenepwi madikte paytwempu ku kiney ig keh kaayhsima gannu. Ig kagiwakemnisima awaku ku samah igkis ka wageskere gihiyakemnikis. ");
INSERT INTO plu_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ig awna: ―Akayih. Aysawnemenek kaayhsima mbayka ay yidahannek yis hiyeg paytwempuyenepwi Korazih. Hawwata kaayhsima mbayka yidahanwata yis paytwempuyenepwi Betsayda. Mmahkay yis ka wageskere yihiyakemni? Waké nah kehbe inwata nannuh ayhté paytwempu Tiru akak Sidoh ku samah nah keh ayge yibet, nikwekam igkis paytwempuyenepwi mbayapye igkis ayipakam kayah gitaraksankis, ayipa igkis wages gihiyakemnikiskam. Igkis kawihminawkam akak sak kasiwboye, igkis padakkam tiket ahewra gitewharitkis adahan arekhetni giwakemnikis. ");
INSERT INTO plu_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nikwe aysawnemenek apim ini ku aysaw madikte hiyeg katiwnipwe apatra gitaraksankisnek, yis pi hiyapte mbeyne mpiya nerras paytwempuyenepwi Tiru akak Sidoh. Henneki yisnek hiyá mbeynenek. ");
INSERT INTO plu_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ya yis hiyeg apitya paytwempu Kafarnawh. Yis ikawnamah pi apitminte hiyeg madikte. Henneme yis tukuhpikanek ta warikwit arimkat ini iwetrit ku kiney kaneayhsima kayahwaki. Waké nah kehbe inwata nannuh ayhté paytwempu Sodoma ku samah nah keh ayge yibet, nikwekam ignes paytwempuyenepwi mbayapye ignes ayipa wages gihiyakemnikiskam. Ini paytwempu kupiknene aykam. ");
INSERT INTO plu_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nikwe aysawnemenek apim ini ku aysaw hiyeg katiwnipwe apatra gitaraksankisnek, yis pi hiyapte mbeyne mpiya nerras paytwempuyenepwi Sodoma. Henneki yisnek hiyá mbeynenek. ");
INSERT INTO plu_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Pisenwa gawnhan inakni ig Kiyapwiye Jesus piriyepkaw ta git Uhokri. Ig awna: ―Kibeyne, Nighu. Pis en akipara. Pis waxri akipara. Nah kabayhap awaku ku samah pis ka akki pihiyakemni ta gitkis hiyeg hiyakemniyepwi. Gitkisme hiyeg kene bakimnaybe yumanene gihiyakemnikis giwntekneswa, pis akki pihiyakemni ta gitkis. ");
INSERT INTO plu_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Hennewa Nighu, mmanawa innewa ku pariye pimawkan. ");
INSERT INTO plu_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ayteke ig awna ta gitkis hiyeg ayge. Giwn: ―Ig Wigwiy kuwis ekke nuthu madikte gihiyakemni. Yuma hiyeg nuhiyekten nah Uhokri gikamkayh. Ignewa Wigwiy ig pahapa nuhiyekten. Hawwata akiw yuma hiyeg gihiyekten Wigwiy. Nahnewa gikamkayh gihiyekten. Ku karit nah muwaka akkig, ignes hawwata hiyakri. ");
INSERT INTO plu_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ayteke ig awna akiw: ―Aytninabay numkanit, yis ku pariye mpiksewnepwi ke pahapwibe hiyuhne giheypi mapiy gidatni. Ba yi ayta mayuwase yiheypi nuthu. Nah keh yis mayak ta nupitit. ");
INSERT INTO plu_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Wewnabay pahamteke nukakhu ke piyana pakbe ku pariye pahadguhka akak ah dahak gibitamnakis adahan igkis hiyuhnes awiyka payak. Kannuhwanabay nuthu. Mmanawa nah hiyeg tuwatpiye, nah ikaw warikapte giwkis madikte hiyeg. Ku yis kannuhwa henne nuthu, nikwe yis utí mayakka abet yihiyakemni. ");
INSERT INTO plu_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ku pahapwi wew pahamteke nukakhu, iggi ka mpiksaw mpiynepepyema akiw. Heggehege giheypi. ");
INSERT INTO plu_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Pisenwa inakni gawnhan, ig Kiyapwiye Jesus tipik mpiye amadgew pahak was abet samdi. Usuh gikannuhnipwi tipik gihapti. Usuh matipwe. Nikwe usuh matise fahhin ariw, usuh axwig. ");
INSERT INTO plu_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nerrasme farisewkis hiyapni henne, igkis awna ta git Kiyapwiye Jesus: ―Ipeg nerras pikannuhnipwi. Igkis ka iha amekene Moís gikumadukan. Igkis kannipwiye abet samdi. ");
INSERT INTO plu_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Igme Kiyapwiye Jesus kaytwa giwnkis: ―Mmah yis kote ipegbohate Uhokri gannasan ku kiney in kinetihwa amin ku pariye amekene Davi gikehni? Minikwak ig matipwe payak gikakkis gihaptiyepwi. ");
INSERT INTO plu_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Nikwe ig pareke ta agikut ini leglis kewye Uhokri Gipin. Ayge ig ax ini bugut ku pariye ekkepka ta gipetunat Uhokri. Hawwata ig ikepni ta gitkis gihaptiyepwi. Amekene Moís gikumadukan awna ku muwpegnenwa kis adahan ignes axne ini bugut. Igkisme axni henneme igkis ka taraksa mmanawa ig muwpeg amnihpigkis. ");
INSERT INTO plu_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Hawwata akiw, mmah yis kote ipegbohate amekene Moís gikumadukan ku kiney in kinetihwa amin ku samah muwpegpiyene agiku Uhokri Gipin ignes kannipanene abet samdi? Henneme igkis ka taraksa mmanawa amawka ku igkis keh henne adahan kiyathene Uhokri Gipin. ");
INSERT INTO plu_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Timapnay nuwnhu yit. Ay pahapwi yibet ku pariye pi kiyatte giw Uhokri Gipin. Ihanabay inakni nuwnhu. Hennewatbaki ig. ");
INSERT INTO plu_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Uhokri gannasan minikwekene awna: “Nah ka muwaka yis he kakanhawnen nuthu. Nah pi muwakate yis amnih hiyeg.” Waké yis pukuhabe inakni yuwit, nikwekam yis ka ikiykam ku nerras nukannuhnipwi ku igkis ka kibeynepwima. Igkis ka keh mbaynama. ");
INSERT INTO plu_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Mmanawa nah ku pariye wageswe awayg amadgaya inin nahnewa samdi akipara. ");
INSERT INTO plu_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ayteke ig Kiyapwiye Jesus tipik lammisya agiku judeyenepwi gileglisakis. ");
INSERT INTO plu_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ayge pahapwi awayg kidubetwiye giwak. Igkisme nerras hiyeg ayge hiyapni henne, igkis awna git Kiyapwiye Jesus: ―Ba amekene Moís gikumadukan isaksa adahan wis piyihak samdi abet? Igkis awna inakni henne adahan gihikekten marihwa igkis hiyá ba ig taraksa amekene Moís gikumadukan. Igkis muwaka utí gitaraksan adahan igkis gikamyehpitni. ");
INSERT INTO plu_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Igme Kiyapwiye Jesus kaytwa giwnkis: ―Ku pahapwi yipig muttuh wiwhe agikut miyokwiye mihad abet samdi, mmah ka yisma kahgi ayteke abetnewa ini samdi? ");
INSERT INTO plu_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ku ka sam wis amnih muttuh abet samdi, kawnata sam wis amnih hiyeg abet samdi. Hiyeg kaayhsima pi kapigte git Uhokri ariw muttuh. Amekene Moís gikumadukan isaksa adahan wis keh kabayka abet samdi. ");
INSERT INTO plu_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ayteke ig Kiyapwiye Jesus awna ta git ner awayg kidubetwiye giwak. Giwn: ―Taraknaba piwak. Igme tareke giwak. Aynewa giwak makniw hawwata ku samah giwak pahambakya. ");
INSERT INTO plu_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Igkisme nerras farisewkis hiyapni henne, gitkis ig Kiyapwiye Jesus ig taraksepye hiyeg. Nikwe igkis pes ayteke, igkis ahegbete ginetnikis adahan igkis giwmasepten. ");
INSERT INTO plu_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Igme Kiyapwiye Jesus hiyak ku pariye gikehnikis. Ig hiyapni henne, ig tipik ariwntak ini iwetrit. Kaayhsima hiyeg kuruwnene gihapu butte. Ayge ig makniw madikte ku pariye kakahribdapye. ");
INSERT INTO plu_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Henneme ig awna ta gitkis: ―Ka yi muwaka keh yiwanti nukakhu. ");
INSERT INTO plu_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Inakni giwn danuh henne kahadbe in kahayak ku samah Uhokri gawnepe amekene Isaías awna. Ig awna: ");
INSERT INTO plu_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Uhokri awna: ‘Ipegnay nubukhu nukanyan. Ignewa nah batek gikak. Ig keh nah batek kaayhsima. Nah kawihkis nutiphu ta gipititnek. Ayge nikwe ig ekkene nuhiyakemni waditye ta gitkis madikte hiyeg. ");
INSERT INTO plu_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Henneme ig ka kabayhaknaw ta gitkis hiyeg. Ig ka kabiman adahan kehne giwanti. Ig ikaw tuwatapye giwtrikkis hiyeg. ");
INSERT INTO plu_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ig amnih ku pariye hiyeg yumanene gawaygyikis. Ku ig hiyá pahapwi hiyeg kene yakkot patukwiyebe, ig ka akiwpi atere akiw. Ku ig hiyá pahapwi hiyeg kene lalampbe igiyihpisa, ig kawnata akiwpi atere akiw. Aysawnemenek ig wanegbete gihawkankis gipetunyapu madikte awaku ku samah ig kibeyne hiyeg. ");
INSERT INTO plu_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ayge nikwe muwwapu hiyeg kamaxwenekwiye ta gipititnek.’ ” Hennewatbaki ig amekene Isaías awna. ");
INSERT INTO plu_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ayteke hiyeg waxe pahapwi awayg motpiye monpiye ta git Kiyapwiye Jesus. Ig kadahan wapitye ay gipit. Igme Kiyapwiye Jesus piyihpig. Ig keh ig awna. Ig keh ig hiyap. ");
INSERT INTO plu_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nerras hiyeg hiyapni henne, igkis wakaymnibdi. Igkis kinetihwa pawtak. Igkis awna: ―Mmah ig ukiparawiy hawwata ke amekene Davibe? Ignewatbaki. ");
INSERT INTO plu_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Igkisme nerras farisewkis timapni henne, igkis awna: ―Kawa. Ig pekkis wapitye gipititak ner awayg akak wapitye gikiparadkis gannu ay gipit. Igwa Belzebu ay gipit. ");
INSERT INTO plu_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Igme Kiyapwiye Jesus hiyak ku pariye abet gihiyakemnikis. Nikwe ig awna ta gitkis: ―Ku hiyeg apitya pahanene waxri ku ignesweke kerbetkis, igkis madikekenek. Paytwempuyenepwi hawwata, ku ignesweke kerbetkis, igkis ka ayipwi akiw. Pakebyekne hawwata, ku ignesweke kerbetkis, ignes kawnata ayipwi akiw. ");
INSERT INTO plu_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Wapitye hawwata. Waké ig Satanás pekkis gihiyegapu wapitye gipititakkis hiyeg, amun ini nikwe gikakwakam ig kerye. Waké ig keh hennebe, ig pisenwakam akak gikumadukan. ");
INSERT INTO plu_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mmah nikwe yis awna numinhu ku nah pekkis wapitye gikak Belzebu gannu ay nupithu? Ya yis yikannuhnipwi? Igkis hawwata pekkis wapitye gipititakkis hiyeg. Pariye ikí gidahankis gannukis? Waké nah pekkis wapitye gikak Belzebu gannube, nikwekam ignes yikannuhnipwi nopinawatkam. Igkisnewa arakak ku yis ka awna wadit. ");
INSERT INTO plu_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ka ba yis hiyaknima ku nah pekkis wapitye gipititakkis hiyeg akak Uhokri Gitip gannu ay nupithu? Inineki arakak ku Uhokri gikumadukan kuwis danuh. ");
INSERT INTO plu_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Nah kehte abektey akak pahapwi ku pariye parekkere ta gipinekut pahapwi hiyeg detye adahan ig kidisne gewkanbet atere. Apit ig parak atere amawka ku ig wanakminanete ner hiyeg detye. Pisenwa nikwe ik adahan ig parak atere kidis ku pariye ay gimun. Hennewa nah keh gikak wapitye gikiparadkis. Inneki keh nah detye adahan nah wanegbeta gihawkankis ku pariye wapitye kapinawnene ay gipitkis hiyeg. ");
INSERT INTO plu_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","―Mmahkay yis ka amapan? Ku pahapwi ka amapan, amun ini nikwe ig kuwis kapetunsepun. Ku pahapwi ka darihwak nukakhu, amun ini nikwe ig kuwis siguhpen. Ka ik adahan yis msakwa hennenwatma. ");
INSERT INTO plu_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","―Ik adahan Uhokri bayahmina hiyeg ariw madikte gitaraksankis ariw madikte miyathaki. Henneme ku ignes ka kiyatha Uhokri Gitip, nikwe ig ka hiyá igma bayahminigkis ariw ini gitaraksankis. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ku pahapwi ka kiyathan nah ku pariye wageswe awayg amadgaya inin, ka sam. Nawenétke kuwewanek ig Uhokri Gitip dax apit giyakni adahan ig kiyathan. Ayge nikwe ig Uhokri bayahminig ariw ini gitaraksan ku samah pitatye ig ka kiyathan. Henneme ku pahapwi ka kiyatha Uhokri Gitip, nikwe ka ik adahan ig Gitip dax apit giyakni adahan ig wagese gihiyakemni. Ayge nikwe kawnata ik adahan ig Uhokri bayahminig ariw ini gitaraksan. Iné ku apim inin, iné aysawnemenek akiw. Ini gitaraksan nidukwenewa. ");
INSERT INTO plu_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","―Ku yis hiyá nah keh kabayka, nikwe yis hiyak ku nah kibeyne hiyeg. In ke ahbe akat. Ku pariye ah akat kabaynowa, eg sarayh guw kabaynopwi guw. Egme ah akat ku pariye kane kabaynoma, guw kawnata kabaynopwima. Ku wis hiyá pahakti amutri sarayh guw kabaynopwi, nikwe wis hiyak ku eg amutri kabaynowa. ");
INSERT INTO plu_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Yis kaybunyune hiyeg pahaywitniyepwi! Yis ka ik adahan awna kibeyne yuwit mmanawa yihiyakemni mbeyepyenen. Mmanawa ku pariye ay abet uhiyakemni innewa wis awnin. ");
INSERT INTO plu_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ku pariye kibeynewa hiyeg iggi ipegminenekwa gihiyakemni adahan kabaykanenwa. Nikwe he kabaykanen pes giwntak. Igme ku pariye mbeyepye hiyeg iggi ipegminenekwa gihiyakemni adahan mbaykanenwa. Nikwe he mbaykanen pes giwnktak. ");
INSERT INTO plu_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Aysawnemenek apim ini ku aysaw Uhokri gihiypetnikis hiyeg ba ignes kibeynepwiwatma, apim ini ig keh igkis akkamnih madikte ginetnikis ku pariye tuguh gibiygikutkis. Ihanabay inakni nuwnhu. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ku ig hiyá yis awna kibeyne yuwit, nikwe ig hiyá yis kibeynepwi hiyeg. Henneme ku ig hiyá yis awna mbeyepye yuwit, nikwe ig hiyá yis ka kibeynepwima hiyeg. ");
INSERT INTO plu_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Igkis kannuhekeputnepwi amin amekene Moís gikumadukan gikakkis farisewkis igkis timapni inakni henne, igkis awna git: ―Kiyapwiye, uyá keh annut wowtrik adahan arekhetni pidatni wothu kahadbe usuh hiyakpi ba pis ayta giwntakwatma Uhokri. ");
INSERT INTO plu_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Igme Kiyapwiye Jesus kaytwa giwnkis: ―Aa, yis hiyeg amadgaya hawkri. Yis mbeyepye yihiyakemni. Yis kuwis isahkiswe giw Uhokri kuwis. Inneki keh yis kehkis annut nuthu adahan arekhetni ndatni yit. Pahatwowa annut akkaka yitnek, ini annut hawwata ke Uhokri gawnepe amekene Jonas gannube. ");
INSERT INTO plu_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Minikwak ig amekene Jonas msekwe mpana hawkri im gayhgiku henneme ig ka miyá. In humaw arekhetni gitkis nerras hiyeg apitnenepwi paytwempu Nínive ku ig inyerwa ekkene Uhokri giwn. Nah hawwata nah ku pariye wageswe awayg amadgaya inin, nah msakwanek mpana hawkri waykiku. Inenewa humaw arekhetni ndatni yitnek. ");
INSERT INTO plu_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Aysawnemenek ku aysaw Uhokri gihiypetnikis hiyeg ba ignes kibeynewatma, kaayhsima hiyeg ayge hiyekepyi ku yis mbeyepye yihiyakemni. Apim ini nerras hiyeg apitya paytwempu Nínive, igkis hiyekepyinek ay gipetun Uhokri ku yis mbeyepye yihiyakemni. Mmanawa minikwak igkis ihe amekene Jonas giwn igkis wages gihiyakemnikis. Yisme ka iha nuwnhu. Hiyawa nah pi kiyatte giw amekene Jonas, henneme yis ka iha nuwnhu. ");
INSERT INTO plu_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Hawwata akiw no tino ku pariye gikiparakis amekenegben tiwgikyenepwi eggu hawwata hiyekepyi ayge gipetun Uhokri ku yis mbeyepye yihiyakemni. Eg kane Uhokriyanma eg msakwa piyawakad, hiyaksa eg ayta atan adahan timapno amekene Salomawh giwn awaku ig kagihiyakemnisima. Yisme ka timepkere nuwnhu. Hiyawa nah pi hiyakemnite giw amekene Salomawh, henneme yis ka timepkere nuwnhu. ");
INSERT INTO plu_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","―Yis kewa pahapwi awaygbe ku pariye wapitye pes gipititak. Ig wapitye pes, ig wewpari ku kiney yumanene un. Ig ipegpene pahayku mayekket henneme ig ka utí. ");
INSERT INTO plu_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ig hiyapni henne, ig awna gitwa: “Nah diyuhpite ta nupinwat, ta gipitit ner awayg ku kitak nah pes.” Ig tipik. Ig danuh atere, ig utí gipin miyakegik, barewagik, ahegbet adahan pahapwi parak atere. ");
INSERT INTO plu_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ig hiyapni henne, ig tipik, ig iwé ntewnehker gikebyikis wapityempu akiw ku pariye pi mbaytenene gihiyakemnikis giw. Ayteke nikwe igkis diyuh atere msakwa ayge gipit ner awayg. Nikwe ner awayg giwskawni pi mbayte ariw pitatye. Yis hiyeg amadgaya inin yis kewa ner awaygbe. Yis kuwis wageswiye yihiyakemni kameki yis amapanme. Yihiyakemni mbeyepye. Nikwe aysawnemenek in danuh ta yit hawwata ku samah in danuh ta git ner awayg. Yiwskawni pi mbaytenek ariw pitatye. ");
INSERT INTO plu_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ku samah ig Kiyapwiye Jesus awnempiye inakni yuwit, ginag gikakkis gisamwipwi egkis danuh atere. Egkis msekwe kabaywak. Aytontak kabaywaktak egkis wasapanaw gimin Kiyapwiye Jesus ku egkis kinetihwekepye gikak. ");
INSERT INTO plu_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Pahapwi hiyeg ayge hiyapni henne, ig awna git: ―Kiyapwiye, pinag ay kabaywak gikakkis pisamwipwi. Egkis muwaka kinetihwekepye pikak. ");
INSERT INTO plu_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Igme Kiyapwiye Jesus kaytwa giwn: ―Pariyeki nnaghu? Pariyeki nusamwipwi? Nah akkite pit. ");
INSERT INTO plu_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ig tarak giwak ta gimkatkis nerras hiyeg gikannuhnipwi ayge. Ig awna git: ―Ipeg ayta. Norrasnewa ku pariye nnaghu. Nerrasnewa ku pariye nukebyupwi. ");
INSERT INTO plu_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Mmanawa ku pariye hiyeg kehnenepwi Wigwiy inugikyene gibetki, ignes nah ikiygikis ke nukebyupwibe, egnesme tinogben nah ikiygukis ke nnaghube. ");
INSERT INTO plu_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Abetnewa ini hawkri ig Kiyapwiye Jesus pes paytrikutak. Ig tipik mahakwakigbit. Ayge ig batahkiswa adahan ig kannuhekne. ");
INSERT INTO plu_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ayteke kaayhsima hiyeg pahadguhwa atere git. Igkis kiyaran ganwa. Ba akebentenwa hiyeg ayge. Ig hiyapni henne, ig katapte muhumdakat adahan igkis ka dehegbetig. Ayge ig batahkiswe. Ig gikannuhtenkis hiyeg ayteke gumadgatak umuh. Igkisme hiyeg msekwe tabirbet waxrihbak. ");
INSERT INTO plu_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ayteke ig kinetihwa ta gitkis akak kaayhsima yuwit patuwesbuhka. Ig awna gitkis: ―Minikwak pahapwi awayg tipik giwasra amedgete adahan ig sessehne gamutra ayak. ");
INSERT INTO plu_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ig sessehne gamutra ayak, gaytakkis tuguhe apigku ahin ku kiney wayk adani. Ayteke nikwe kuhipra ayta axahpeprukis. ");
INSERT INTO plu_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Gaytakkisme gamutra ayak tuguhe abetit tipebdi ku kiney ka kiyesradima wayk. Egkis gamutra ayak hiyenpiwatkama kibentenwa mmanawa egkis ka mutuhwa mihadima awaku wayk ka kahogbi. ");
INSERT INTO plu_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Kamuw inutpi, awehe gamutra. Aynewa egkis huruhrup mmanawa gahampabet he inuwew. ");
INSERT INTO plu_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Gaytakkisme gamutra ayak tuguhe apuwit pudukupwi. Egnes pudukupwi hiyenpi payak akak gamutra. Egkis tuwathe gamutra juktah egkis miyorap. ");
INSERT INTO plu_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Gaytakkisme gamutra ayak tuguhe abetit kibeyne wayk. Ayge egkis hiyan. Egkis aymuhwa juktah egkis kew. Egkis sarayh kaayhsima guwkis. Gaytakkis kew sah gukebyikis (100). Gaytakkisme kew puguhkuna madikwa gukebyikis (60). Gaytakkisme kew mpana madikwa gukebyikis (30). ");
INSERT INTO plu_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Pisenwa inakni gawnhan, ig Kiyapwiye Jesus awna akiw. Giwn: ―Yis ku pariye katayebnene, ataybiswanabay numkat. ");
INSERT INTO plu_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ayteke ariwnteke ini usuh Kiyapwiye Jesus gikannuhnipwi usuh atere git, usuh ayapri: ―Mmahki pis kinetihwa ta gitkis hiyeg akak patuwesbuhka yuwit? ");
INSERT INTO plu_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Igme kaytwa wownhu: ―Hiyeg amedgenepwi inin kote hiyakte ku samah Uhokri gikumadukan. Yisme ig Uhokri akkamnihni ta yitnek. Igkisme ka akkaka ta gitkis. Ta gitkis nah awna patuwesbuhkanen yuwit. ");
INSERT INTO plu_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Mmanawa ku pahapwi darih nuhiyakemni kabayhtiwa, nikwe ig Uhokri akki git pi kiyeste akiw kahadbe ig darih nuhiyakemn kaayhsima. Henneme ku pahapwi ka darih nuhiyakemni kiyesradima, nikwe ini nuhiyakemni wiwhpika abetitak gihiyakemni. ");
INSERT INTO plu_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nah awna patuwesbuhka yuwit ta gitkis hiyeg awaku igkis hiyá nannuh, nuhiyakemnime igkis ka hiyepkere. Igkis timap nuwnhu, nuhiyakemnime igkis ka ihpekere igkis ka pukuhpakere. ");
INSERT INTO plu_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Metakwa in kahayak ku samah Uhokri gawnepe amekene Isaías awna giminkis minikwak. Ig awna: “Yis ataybiswa git Uhokri giwn kabayhtiwa henneme yis ka pukuhpin. Yis ikí yitew arimkanit giwn kabayhtiwa henneme ka paduk ta yitiwgikut. ");
INSERT INTO plu_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Hiyeg amadgaya inin pet gihiyakemnikis. Pet gitaybikis. Manan giwtyakkis. Waké ka hennema, ikkam adahan giwtyakkis hiyap ku pariye inyerwatnene, ikkam adahan gitaybikis timap ku pariye hiyakemniki inyerwatnene, ikkam adahan gihiyakemnikis pukuhpin. Ayge nikwe igkis wageskam gihiyakemnikiskam ta numkat, nahme makniwgikiskam.” Hennewatbaki ig Uhokri gawnepe awna. ");
INSERT INTO plu_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Yisme nukannuhnipwi yis ka hennema. Yis kayibunugasima mmanawa yiwtyak hiyap ku pariye hiyakemniki inyerwatnene, yitaybi timap ku pariye hiyakemniki inyerwatnene. ");
INSERT INTO plu_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Minikwak kaayhsima hiyeg Uhokri gawnepepu, kaayhsima hiyeg kibeynepwi igkis kaayhsima hiyepkere ini nannuh ku pariye yis hiyap ku apim inin. Igkis kaayhsima timepkere inakni nuwnhu ku pariye pis timap ku apim inin. Hennewatbaki igkis. Henneme igkis ka hiyapni, igkis ka timapni. ");
INSERT INTO plu_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","―Kuri nah akkamnihte yit inakni nuwnhu patuwesbuhka gimin ner amutriputne. ");
INSERT INTO plu_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ku pahapwi timá nuwnhu amin Uhokri gikumadukan henneme ku ig ka pukuhpin, ayteke nikwe ner mbeyepye gihiyakemni ig Satanás ig danuh atere git. Ig wiwhpiye inakni nuwnhu abetitak gihiyakemni. Ayge nikwe inakni nuwnhu humaw kewa no amutri ayakbe ku pariye tuguhe apigkut ahin. ");
INSERT INTO plu_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Egnesme no amutri ayak ku pariye tuguhe ta abetit tipebdi innebaki arakak gidahan pahapwi ku pariye timá nuwnhu ig amapin kibentenwa akak madikte gibetki. ");
INSERT INTO plu_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Henneme ig ka kamax inakni nuwnhu kabayhtiwatma abet gihiyakemni. In humaw kewa pahakti amutribe ku pariye yumanano guhampabet eg ka dep miyó. Ig batek akak nuwnhu adahan aynessa hawkri. Ayteke pase ig hiyá mbeyne nipatra, aynewa ig miniwpi niw. Ku aysaw hiyeg mahipwihpig nipatra, ig diyuhkiswe butte. ");
INSERT INTO plu_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Egnesme no amutri ayak ku pariye tuguhe ta abetit pudukupwi, innebaki arakak gidahan pahapwi ku pariye timá Uhokri giwn ig amapin. Henneme ig pi ikatuswete adahan arikna amadgaya inin. Ig kinikiswe arit igiska amadgaya inin. Ayge nikwe Uhokri giwn mpithaka abet gihiyakemni. Ig ka kannuhwa keh Uhokri gibetki. Amun ini nikwe ig awayg humaw waditnepyenen kewa pahakti amutribe ku pariye kane kew. ");
INSERT INTO plu_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Egnesme no amutri ayak ku pariye tuguhe ta abetit waxri kibeyne waxri innebaki arakak gidahan pahapwi ku pariye timá nuwnhu ig pukuhpin, ig amapin. Ig keh Uhokri gibetki nikwe. Gaytakkis hiyeg keh Uhokri gibetki kabayhtiwa. Ignes humaw kewa amutribe ku pariye kew sah gukebyikis (100). Gaytakkisme hiyeg humaw kewa amutribe ku pariye kew puguhkuna madikwa gukebyikis (60). Gaytakkisme humaw kewa amutribe ku pariye kew mpana madikwa gukebyikis (30). ");
INSERT INTO plu_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ayteke ig Kiyapwiye Jesus awna nawenéwa yuwit patuwesbuhka akiw. Giwn: ―Nah akkite yit pahat abektey amin ku samah Uhokri gikumadukan. Minikwak pahapwi awayg sassah kibeyne amutri ayak amadga giwasra, fahhin ayak. ");
INSERT INTO plu_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ayteke ariwnteke ini ku aysaw madikte hiyeg himegbet, pahapwi gipetunya ig danuh atere. Ig danuh atere, ig sessehe ipey ayak ta abetit no fahhin ayak. Pisenwa ig tipik. ");
INSERT INTO plu_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ayteke madikte no amutri ayak hiyan. No amutri fahhin eg kew payebitak akak no ipey. Ayge nikwe metakwa no ipey kahayak. ");
INSERT INTO plu_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ayteke ner was akipara gibukpig hiyapni henne, igkis tipik danuh ta git gikiparakis. Igkis awna git: “Kiyapwiye, mmah ahinyan no ipey ay? Mmah pis ka sassah kibeynewatma fahhin ayak?” ");
INSERT INTO plu_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Igme kaytwa giwnkis: “Nupetunya gannip.” Igkisme ayapri: “Mmah usuh keh gukak no ipey kuri? Ba pis muwaka usuh atak warekwig?” ");
INSERT INTO plu_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Igme kaytwa giwnkis: “Kawa. Nawenétke yis warekwiye ipey, yis wareke payak akak fahhin. ");
INSERT INTO plu_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Isaksanabay no fahhin akak ipey aymuhwa payebitak. Ayteke ku aysaw ahawkanaprik danuh adahan hiwhpiki, nikwe apim ini nah awna gitkis nuhiyegapu: ‘Pitatye madipwisnay ipey apuritak fahhin. Wanakinpinwi adahan padekwiki abetit tiket. Ayteke pisenwa, uyá hiwh fahhin ewkni ta agikut fahhin apin.’ ” ");
INSERT INTO plu_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ayteke ariwnteke ini ig Kiyapwiye Jesus kinetihwa gitkis akak nawenéwa yuwit patuwesbuhka. Giwn: ―Uhokri gikumadukan aymuhwa amadga inin ke amutri “mostadbe”. Ku aysaw pahapwi iwé pahow “mostad” ayak, ig mutuhgu amadga giwasra, eg nopsesniyo. ");
INSERT INTO plu_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Eg pi isite ayak ariw madikte amadga inin. Henneme ku aysaw eg hiyan, eg pi wadiswete ariw madikte ipeybet. Eg aymuhwa kaaramusima ke ahbe akatbe. Juktah ik adahan kuhipra ayta kibhaw gupewit. ");
INSERT INTO plu_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ayteke ig Kiyapwiye Jesus awna nawenéwa yuwit patuwesbuhka akiw ta gitkis: ―Uhokri gikumadukan keh hiyeg gihiyakemnikis aymuhwa hawwata ku samah bugut abusan tukurasa bugut. Ku pahapu tino iwé aynessa bugut abusan eg wagesbetepni ta abetit mpana bom fahhin, ayge nikwe madikte in tukurpi. ");
INSERT INTO plu_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ig Kiyapwiye Jesus kinetihwa ta gitkis nerras hiyeg akak yuwit patuwesbuhkanen. Ig ka awnati ariknawnama ta gitkis huwewe. Ig he kinetihwa akak yuwit patuwesbuhkanen. ");
INSERT INTO plu_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ig awna henne kahadbe in kahayak ku samah Uhokri gawnepe awna minikwak. Igme awna: “Nah awnate yuwit patuwesbuhka ta gitkis. Nah akkite gitkis hiyakemniki ku pariye hiyeg kotenene hiyakte ku samah akapuska hawkri.” ");
INSERT INTO plu_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ayteke ig Kiyapwiye Jesus pes gibetitakkis nerras hiyeg. Ig pareke paytrikute. Usuh gikannuhnipwi hiyapni henne, usuh danuh atere git. Usuh awna git: ―Uyá akkamnih wothu inakni yuwit patuwesbuhka amin ipey amadga was. ");
INSERT INTO plu_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Igme kaytwa wownhu. Ig awna: ―Ner awayg ku pariye sessehe kibeyne amutri ayak, ignebaki arakak numinhu nah ku pariye wageswe awayg amadgaya inin. ");
INSERT INTO plu_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Inme giwasra, innebaki arakak adahan inin hawkri. Egnesme kibeyne amutri ayak, egnesbaki arakak gidahankis hiyeg ku pariye kawih Uhokri gikumadukan. Egnesme ipey, egnesbaki arakak gidahankis hiyeg ku pariye kawih wapitye gihiyakemni. ");
INSERT INTO plu_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Nerme ipetunyati ku pariye sessehe ipey ayak, ignebaki arakak gidahan wapitye gikiparadkis. Inme ahawkanaprik adahan hiwhpiki, innebaki arakak adahan amaksemni hawkri. Nerrasme hiwhkeputnepwi, ignesbaki arakak gidahankis ahj. ");
INSERT INTO plu_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ku samah ipey madipwiska in bukahka abet tiket, innebaki arakak adahan ku pariye danuh amaksemni hawkri. ");
INSERT INTO plu_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Apim ini nah ku pariye wageswe awayg amadgaya inin nah awahkis nuwatnipwi ahj adahan igkis wiwhpiyes ariwntak Uhokri gikumadukan madikte patahwaki payak gikakkis madikte hiyeg patahwapye. ");
INSERT INTO plu_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ayteke nikwe igkis padekwigkis ta abetit tiket. Ayge hiyeg tihebdi ignes kagah gaybukis. ");
INSERT INTO plu_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ignesme hiyeg kibeynepwi igkis kabutenne ke kamuwbe ayhté gimun Wigwiy gikumadukan. Yis ku pariye katayebnene, ataybiswanabay numkat. ");
INSERT INTO plu_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ayteke ig Kiyapwiye Jesus awna wothu nawenéwa yuwit patuwesbuhka akiw. Ig awna: ―Uhokri gikumadukan pi kabayte ariw madikte wewkanbet. In kewa pahat igiskabe ayempikanbe amadga pahak was. Pahaye adahan pahapwi awayg utepni. Ig hiyapni henne, ig higihpin akiw. Ig ba gibetkitenwa nikak keh ig piyuk madikte gewkanbet. Ayteke nikwe ig isime ini was akak akakurapig. ");
INSERT INTO plu_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ayteke ig Kiyapwiye Jesus awna nawenéwa yuwit patuwesbuhka. Ig awna: ―Hawwata akiw Uhokri gikumadukan kewa pahatwi akabdatbe kanegubewisima. Nah kehte abektey gikak pahapwi isimkeputne ig mpiksaw kaayhsima aharitne akabdat ku pariye kanegubewikissima, ig hiyá ba ig utí. ");
INSERT INTO plu_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Pahaye adahan ig utí pahatwi akabdat pi barewtenano ku pariye kanegutiwnisima. Ig hiyapni henne, ig piyuk madikte gewkanbet, ig isime no akabdat akak akakurapig. ");
INSERT INTO plu_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ayteke ig Kiyapwiye Jesus awna nawenéwa yuwit patuwesbuhka akiw. Ig awna: ―Nah akkite yit nawenéwa abektey akiw amin ku samah Uhokri gikumadukan. In kewa pahak tagamayhbe. Ku aysaw in subukka ahakwat mahakwa, in kamax arakembete im. ");
INSERT INTO plu_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Pase in kipun, igkis ipuhtyakeputnepwi inú ta ihapkat. Ayteke igkis bat nihumwa. Igkis kaniybete ku pariye kibeyne im, igkis darihapeprikis agiku gipanyakis. Inme im ku pariye kane kibeynepwima, igkis padakapeprikis. ");
INSERT INTO plu_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Innebaki arakak adahan ku pariye danuh amaksemni hawkrinek. Apim ini ahj atak muwwapu igkis kaniybete hiyeg ku pariye kane kibeynepwima gibetakkis hiyeg kibeynepwi. ");
INSERT INTO plu_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ayteke nikwe igkis padekwigkis ta abetit tiket. Ayge hiyeg tihebdi ignes kagah gaybukis. ");
INSERT INTO plu_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Pisenwa ig Kiyapwiye Jesus ayá usuh gikannuhnipwi: ―Ba yis pukuha inakni yuwit? Usuhme kaytwa giwn: ―Ihi. Usuh pukuhpin. ");
INSERT INTO plu_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ayteke nikwe ig awna wothu: ―Amekene Moís gikumadukan ini igiska ayipwipye. Mpuse kannuhekeputne amin amekene Moís gikumadukan, ku ig kannuhwa nuthu amin ndahan nukumadukan hawwata, nikwe ig igisye abet gihiyakemni. Ig kagibunugasima ke pahapwi payt akiparabe ku pariye kadahan igiska nukune akak igiska ayipwipye ay gipineku. ");
INSERT INTO plu_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Pisenwa gawnhan inakni yuwit patuwesbuhka, ig Kiyapwiye Jesus tipik ayteke. ");
INSERT INTO plu_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ig diyuhe ta apitit giwaxri Galiléyamnaw. Ayge ig kannuhne hiyeg agiku judeyenepwi gileglisakis. Nerras timepnepwi giwn ayge igkis wakaymnibdi gidahan. Igkis awna: ―Kitak ig utí ini hiyakemniki? Kitak ig utí ini gannu? ");
INSERT INTO plu_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ka ba pis hiyá ku ner he aheputnenen gikamkayh? Ka ba nernama kinagniyo kiyapuno Mahi? Ka ba Tiyagu gikak José, Simawh, Judas ka ba igkisnama gisamwipwi? ");
INSERT INTO plu_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ba gisamrupwi ka ba egkisnama msakwa ay ubetwiy? Mmahki ig awna inakni henne? ");
INSERT INTO plu_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ayge nikwe igkis kiyimwihwe gikak Kiyapwiye Jesus, igkis tukuhwepwa giw. Igme hiyapni henne, ig awna ta gitkis: ―Madikte hiyeg kiyathenekwiye pahapwi ku pariye Uhokri gawnepe. Ignesnewa hiyegipiyene ku pariye apitya giwaxriwa gikakkis gimunyapu ignes ka kiyatig. ");
INSERT INTO plu_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ayge nikwe ig ka keh kibitema annut ayge awaku yumahwa gikamaxwankis ta gipitit. ");
INSERT INTO plu_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Apim ini hawkri ner hiyaptigi amekene Erodis ig timé Kiyapwiye Jesus gak. ");
INSERT INTO plu_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ig timapni henne, ig awna ta gitkis gihiyegapu: ―Ke nuthube ignewa amekene João Batistamni. Ig kuwis kannikaw akiw ariw gimiremni. Innebaki keh ig kagannusima keh annut. ");
INSERT INTO plu_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ig awna inakni henne mmanawa ignewa kamaykistinene amekene João Batista. Ig wanakkisri, ig sarayhkisri agikut parakseket. Ig keh henne gupatra amakano Erodiyas ku pariye gegni Filip gihayo. ");
INSERT INTO plu_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Mmanawa minikwak ig amekene João Batista himahgi. Ig awna git: ―Pis ka keh wadit ku samah pis kamax pegni gihayo adahan pis maripkaw gukak. Ka hennema Uhokri ayá wotwiy. ");
INSERT INTO plu_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ayge nikwe ig amekene Erodis aharitne giwmasepten. Henneme ig apisemun gibohrikis nerras judeyenepwi awaku igkis ikiy amekene João Batista ku ig Uhokri gawnepe. ");
INSERT INTO plu_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Apim ini ig amekene Erodis keh gipetra adahan ku samah ig amadga wayk. Ayge abet ini fet eg amakano Erodiyas gukamkayh himano eg kayno eg pahapo gidahankis gawnasanpu. Eg keh ig amekene Erodis batek ginaktin mpiynepepye. ");
INSERT INTO plu_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ig ba gibetkitenwa gukak keh ig awna ta gut, giwn: ―Uhokri timá nuwnhu ku nah awna pit. Nah ikaksa pit madikte ku pariye payapni nuthu. ");
INSERT INTO plu_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Egme kaytwa giwn ku samah gunag kuwis akki gut. Eg ayá git: ―Uyá ikí nuthu João Batista gitew. Ikepni nuthu pisenwate amadga pahak miruk. ");
INSERT INTO plu_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ig hiyaptigi hiyapni henne, ig wakaymni mmanawa ig ka ihpekere inakni guwn. Henneme kuwis ig ikaksin gut giwtrikneswa gawnasanpu. Ayteke nikwe ig awna ta git pahapwi gisuwtata: ―Asá ikepni gut. ");
INSERT INTO plu_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Su atak bukih João Batista gibita ayhté parakseket. Ewknaba gitew atan. ");
INSERT INTO plu_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ayteke nikwe gitew ewkka atere amadga pahak miruk, in ikepka ta gut no himano. Egme ewkwin ta gut gunag. ");
INSERT INTO plu_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ayteke ig amekene João Batista gikannuhnipwi danuh atere. Igkis iwé gipit, igkis apuhpig. Pisenwa igkis tipik iké Kiyapwiye Jesus ginetni. ");
INSERT INTO plu_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ig Kiyapwiye Jesus timapni inakni ginetnikis henne, ig tipikwiye muhumdakew. Usuh tipik gihapti. Usuh manukwiye ta apitit pahá iwetrit ku kiney yumanene hiyeg. Henneme pase hiyeg timé gak ku ig kuwis tipik, igkis mpiye akigbimnew mahakwa adahan igkis tipikwiyes gihapti. Igkis pesbetwikis apititak madikte paytwempu ayge. ");
INSERT INTO plu_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Igme Kiyapwiye Jesus sarayhwe atere waxrihpakat. Ayge ig hiyá kaayhsima hiyeg kabubuknekis. Igkis kit danuh giw atere. Ig hiyapni henne, ig kayah gidahankis. Ig amnihpigkis ig makniwe madikte hiyeg kakahribdapye. ");
INSERT INTO plu_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ayteke ariwnteke ini tepti kamuw, usuh gikannuhnipwi danukwa atere git. Usuh awna git: ―Kiyapwiye, kuwis aygete kuwis. Inin iwetrit yuma hiyeg msekwene ay. Wani nerras hiyeg tipik ta paytwempuit adahan igkis isimwi gimanakis atere. ");
INSERT INTO plu_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Igme Kiyapwiye Jesus kaytwa wownhu: ―Kawa. Ka muwaka igkis tipik. Yisnewa ikí axka ta gitkis apim inin. ");
INSERT INTO plu_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Usuhme awna ta git: ―Usuh kadahan pohowkubuwa akebyi bugut akak piyanmowa im masaraku. ");
INSERT INTO plu_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Igme Kiyapwiye Jesus awna ta wothu: ―Ewkninay ayta. ");
INSERT INTO plu_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Usuh ewkwin git, ig keh nerras pahabunene hiyeg batahkiswa abet ini pamatka ayge. Ku aysaw kuwis igkis batebdebdihpikis, ig iwé ini pohowkubunene bugut akak piyananene im. Ig sarayh gipegyi ta inut, ig kabayha Uhokri adahan ini. Ayteke ig sigkabdihapepni. Ig ikepni ta wothu gikannuhnipwi. Usuhme gikannuhnipwi ibekhepni gipuriwkis nerras hiyeg. ");
INSERT INTO plu_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Igkis madikte ax kabihribdape. Ka semeweknama gimanakis. Kaayhsima asemne msekwe. Pisenwa nikwe usuh ahiwapemni, usuh kipunse madikawku akebyi panye akak pisaya arawna (12) akak asemne gimanakis. ");
INSERT INTO plu_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Igkis nerras hiyeg kaayhsima gikebyikis. Awaykemninen pukuhka kabá danuh pohowku mil (5.000) gikebyikis. Ayge hawwata kaayhsima tinogben gikakkis gukamkayhkis henneme egkis ka pukuhka. ");
INSERT INTO plu_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ayteke ariwnteke ini ig Kiyapwiye Jesus awna ta wothu usuh gikannuhnipwi. Giwn: ―Kataptanabay amadgat wahmunwiy. Manukwinay pitati tahhan pahambakat. Kuwewanek nah aterenek. Usuh timapni henne, usuh tipikwiye. Igme msekwe ayge adahan ig ekkewpiye ta gitkis nerras hiyeg. ");
INSERT INTO plu_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Pisenwa gekkewpen, ig awna: ―Nah ta piriyepkawte. Ig wagehe apitit pahá waxri imuwadnene adahan ig piriyepkewne atere. Msanpi gaw, adukwenewa ig ayge pahapo. ");
INSERT INTO plu_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Nikwenéwa apim ini no wahmun piyawakte ariw waxri. Eg padekwika apit paraw mmanawa mayg aytnipa gutiput. ");
INSERT INTO plu_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kabeyweke ig Kiyapwiye Jesus aytweni ta womkanit, ig waywe ahakwew un. ");
INSERT INTO plu_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Usuh hiyapni henne, usuh apisasew gibohri. Usuh awna: ―Ner anmapti. Ayge usuh kabimanape akak wapisni. ");
INSERT INTO plu_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Igme awna ta wothu: ―Kibowkahwanabay. Nahnewa ay. Ka yi muwaka apis. ");
INSERT INTO plu_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ayge nikwe ig kiyapwiye Pedru awna git: ―Kiyapwiye, ku inyerwa pisnewa, uyá isaksan nah atak ta pimkat ahakwew un. ");
INSERT INTO plu_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Igme kaytwa giwn: ―Ba ayta. Igme kiyapwiye Pedru timapni henne, ig sarayhwe amadgatak umuh. Ig kapusa wew ahakwew un ta gimkat Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pahaye adahan ig kayah mayg ahawna. Ig apisasew. Aynewa ig kapusa buwise ahakwa un. Ig hiyapni henne, ig kabiman: ―Kiyapwiye, amnihnan! ");
INSERT INTO plu_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Aynewa ig Kiyapwiye Jesus tarak giwak ig sumuhpig. Ig awna git: ―Awayg apisatrupye. Uhokri ik adahan pis kamaxwa ta gipitit. Mmahki pis pukuhpaw? ");
INSERT INTO plu_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ayteke igkis katapte amadgat wahmun. Aynewa mayg msekwe. ");
INSERT INTO plu_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Usuhme amadgayapu umuh usuh hiyapni henne, usuh kabayhig. Usuh awna: ―Pis igyerwa Uhokri gikamkayh. ");
INSERT INTO plu_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Usuh manuke mahakwa, usuh danuh ta apitit Jenesarémnaw. ");
INSERT INTO plu_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Pase nerras hiyeg ayge murotpi git Kiyapwiye Jesus, igkis wasapanaw giminkis hiyeg muwwapu giwaxrikis. Ayteke nikwe igkis waxape madikte hiyeg kakahribdapye ta gimkat Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Igkis amnihswe ta git adahan ig isaksa nerras kakahribdapye adahan igkis dax he gikanwaptanen akigbimnanenwa. Igme isakseprikis. Madikte hiyeg ku pariye daxni igkis makniw. ");
INSERT INTO plu_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ayteke gaytakkis farisewkis gikakkis gaytakkis kannuhekeputnepwi amin amekene Moís gikumadukan igkis danuh atere git Kiyapwiye Jesus aytontak Jerusalémtak. Igkis danuh atere, igkis ayá git: ");
INSERT INTO plu_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―Mmahki pikannuhnipwi ka iha amekenegben gihiyakemnikis? Igkis ka sukokaw apit igkis ax ku samah amekenegben sukokaw adahan ignes barewpit giwtrik Uhokri. ");
INSERT INTO plu_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Igme Kiyapwiye Jesus kaytwa giwnkis: ―Mmahki yiswa ka iha igwa Uhokri gikumadukan? Mmanawa yis pi ihpate amekenegben gihiyakemnikis awenyan igwa Uhokri gikumadukan. ");
INSERT INTO plu_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Nah akkite yit ku samah. Ig Uhokri awna: “Kiyatha pig, kiyatha pinag.” Hawwata akiw ig awna: “Ku pahapwi miyatha gig, miyatha ginag, pugamawka ig umehpika.” Hennewatbaki ig Uhokri awna. ");
INSERT INTO plu_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Yisme awna: “Ku pahapwi ik adahan ig amnih gigkis henneme ku ig awna ta gutkis: ‘Ka hiyá nahma amnihyi akak ini newkanbet mmanawa nah kuwis ikaksa ku nah kawih madikte newkanbet gidahannen Uhokri.’ ");
INSERT INTO plu_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ku pahapwi awna inakni henne, nikwe ka sam ig ka amnih gig adahan ig kiyatig. Kawnata sam ig ka amnih ginag.” Ku aysaw yis iha inakni giwnkis amekenegben henne, amun ini nikwe yis kuwis ikene amekenegben gihiyakemnikis pi kabayte mpiy igwa Uhokri gikumadukan. Mmanawa yis isiy hiyeg ka kiyatha gigkis. ");
INSERT INTO plu_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Yis ikawnamah ke wotbe yis kibeynepwibe hiyeg bawa yis pi mbayte giwkis nawenépwi hiyeg. Minikwak amekene Isaías kuwis kinetihwa yimin. Ig ekkene Uhokri giwn, ig awna: ");
INSERT INTO plu_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Nerras hiyeg kiyathan ay ginumbukisnen bawa gihiyakemnikisme piyawakad nuwhu. ");
INSERT INTO plu_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Igkis kiyathan waditnepyenen. Igkis kannuhekne amin hiyegnen gihiyakemnikis amadgaya inin ke wotbe in nuhiyakemnibe.” ");
INSERT INTO plu_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ayteke ig Kiyapwiye Jesus pahadguhe madikte hiyeg ayge ta gimkanit. Ig awna ta gitkis: ―Ataybiswanabay numkanit. Pukuhapnabay nuwnhu. ");
INSERT INTO plu_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ku pariye arikna wis ikí ubiygikut ka innema keh wis patehwepye giwtrik Uhokri. Henneme ku pariye mbayka pes ubiyaptak inneki keh wis patehwepye giwtrik Uhokri. ");
INSERT INTO plu_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ayteke ariwnteke ini usuh gikannuhnipwi danukwa kennesa ta gihumwat. Usuh awna git: ―Ka ba pis hiyá ku nerras farisewkis dagawne apatra inakni piwn? ");
INSERT INTO plu_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Igme kaytwa wownhu akak patuwesbuhka yuwit: ―Nerras farisewkis igkis kewa ipeybe mutuhkabe ay abet amutri ku pariye kabaynopwi. Ka sam. Madikte amutri ku pariye Wigwiy inugikyene ka mutuh, aysawnemenek in warekwikanek. ");
INSERT INTO plu_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ka ba yi ipegmina yihiyakemni giminkis nerras farisewkis. Gitkis hiyeg kewa motapyebe abet gihiyakemnikis, igkisme gihuwtentenkis. Bawa igkisnewa ku pariye kene motapyebe abet gihiyakemnikis. Ka ik adahan pahapwi awayg motpiye huwitha giyaki motpiye. Ku ig huwitig, igkis piyamate tuguhenek. ");
INSERT INTO plu_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Igme kiyapwiye Pedru timapni henne, ig awna git: ―Uyá akkamnih wothu inakni yuwit patuwesbuhka amin ku pariye keh hiyeg patehwepye giwtrik Uhokri. ");
INSERT INTO plu_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Igme Kiyapwiye Jesus kaytwa giwn: ―Mmah yis kupiknene ka pukuha nuwnhu? ");
INSERT INTO plu_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ka ba yis hiyá ku pariye arikna wis ikí ubiygikut in ka parak abetit uhiyakemni in he mpiya ta wayhgikut, kuwewa akiw wis ahinaprikuhpin? ");
INSERT INTO plu_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Henneme ku pariye mbayka pes ubiyaptak, in ayta abetitak uhiyakemni. Innebaki ik adahan keh wis patehwepye giwtrik Uhokri. ");
INSERT INTO plu_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Mmanawa abetitak uhiyakemni ayteke pes mbeyepye hiyakemniki, umahaka, powkemniki, mehka imunti, amepwiki, wasaymka, miyathaka. ");
INSERT INTO plu_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Innebaki ku pariye keh wis patehwepye. Henneme ku wis ax ka sukokaw, ka innema keh wis patehwepye giwtrik Uhokri. ");
INSERT INTO plu_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ayteke pisenwa ig Kiyapwiye Jesus tipik ayteke. Usuh tipik gihapti. Usuh danuh ta apitit ini waxri ku kiney paytwempu Tiru akak paytwempu Sidoh msakwa. ");
INSERT INTO plu_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ayge pahapu tino kane judeyanoma ku pariye apitya ini waxri eg danuh atere git. Eg kanaáhyano. Eg amnihswe ta git. Eg awna: ―Kiyapwiye, pis ukipara hawwata ke amekene Davibe. Uyá amnihun. Nukamkayh hiyapno kaayhsima mbeyne awaku eg wapityewnipyo. ");
INSERT INTO plu_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Igme Kiyapwiye Jesus ka kaytwa guwn akak pahatnama yuwit. Ayteke nikwe usuh gikannuhnipwi awna git: ―Higihkisnig ayteke, Kiyapwiye. Eg makekempi uhapu butte eg awnihnen akak guhawna. ");
INSERT INTO plu_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Igme Kiyapwiye Jesus kaytwa wownhu: ―Nah awahkiska adahan gamnihtenkis igkisnewa israelyenepwi. Ignes kewa muttuhbe biyukapyebe nuthu. Kote nuhawkanaprikte adahan nah amnihne hiyeg ku pariye kane judeyenepwima. ");
INSERT INTO plu_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Henneme eg danukwa kennesa atere git, eg paberetusaw ta gikimpuit. Eg awna git: ―Kiyapwiye, uyá amnihun. ");
INSERT INTO plu_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Igme Kiyapwiye Jesus kaytwa guwn: ―Ka kis adahan nah hiyak pikak kuri pis kane judeyanoma. Ku nah hiyak pikak kuri, in ke wotbe nah iwepyebe nukamkayupwi gimanakis nah padekwin ta gitkis pewru. ");
INSERT INTO plu_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Egme kaytwa giwn: ―Hennewa, Kiyapwiye. Henneme juktah pewruyan ax arebdibdi tuguhapye amadgatak gikiparakis gaxten. ");
INSERT INTO plu_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ig Kiyapwiye Jesus timapni henne, ig awna gut: ―Kiyapuno, pis kaayhsima pikamaxwan. In danuh ta pit ku samah payapni nuthu. Ig awna inakni, aynewa gukamkayh makniw. ");
INSERT INTO plu_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Pisenwa ig Kiyapwiye Jesus tipik ayteke. Ig mpiya akigbimnew mahakwa Galiléya. Ayteke ig wagehe ta apitit pahá waxri imuhgipitnene. Ayge ig batahkiswe. ");
INSERT INTO plu_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Nikwe kaayhsima hiyeg danuh atere gimkat. Igkis waxe kaayhsima kakahribdapye ta git. Igkis waxe miyapupye gikakkis kidubetapye, motapye, monapye, kaayhsima nawenéwa kakahrapye akiw. Igkis sarayhpigkis gikimpuit Kiyapwiye Jesus, igme makniwigkis. ");
INSERT INTO plu_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nerras hiyeg hiyapni henne ku samah monapye awna, kidubetapye wadithaw, miyapupye wew, motapye hiyap, igkis hiyapni henne, igkis wakaymnibdi. Igkis awna: ―Uwohkigawiy wixwiy israelyenepwi ig kagabayisima kagidatnisima! ");
INSERT INTO plu_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ayteke ig Kiyapwiye Jesus pahadguh usuh gikannuhnipwi ta gimkanit. Ig awna wothu: ―Nerras hiyeg kuwis msekwe ay ukak mpana hawkri. Gimanakis madike kuwis. Nah wakaymni gidahankis. Nah ka muwaka awahkiswigkis ta gipinwatkis akakma matipwa. Nawenétke gaytakkis tuguhenek pakwa ahin awaku mabimnaki. ");
INSERT INTO plu_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Usuhme gikannuhnipwi ayapri: ―Mmah awitwak wotwiy bugut gidahankis ay amadga inin amatap? Igkis kaneayhsima hiyeg. ");
INSERT INTO plu_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Igme Kiyapwiye Jesus ayá usuh: ―Aysaw akebyi bugut yis kadahan? Usuhme kaytwa giwn: ―Usuh kadahan ntewnehkerbu akebyi akak aynessa im nopsanyopwi masaraku. ");
INSERT INTO plu_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ayteke nikwe ig Kiyapwiye Jesus keh nerras hiyeg batahkiswa waygboit. ");
INSERT INTO plu_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ku aysaw kuwis igkis batebdebdihpikis, ig iwé ini ntewnehkerbunene bugut akak ini im. Ig kabayha Uhokri adahan ini. Ayteke ig sigkabdihapepni. Ig ikepni ta wothu usuh gikannuhnipwi. Usuhme ibekhepni ta gipuriwkis nerras hiyeg. ");
INSERT INTO plu_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Igkisme ax kabihribdape. Ka semeweknama gimanakis. Kaayhsima asemne msekwe. Pisenwa nikwe usuh ahiwapemni, usuh kipunse ntewnehker akebyi panye akak asemne gimanakis. ");
INSERT INTO plu_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Igkis kaayhsima hiyeg. Awaykemninen pukuhka kabá danuh paxnika mil (4.000) gikebyikis. Kaayhsima tinogben ayge hawwata gikakkis gukamkayhkis. ");
INSERT INTO plu_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Pisenwa nikwe ig awahkiswigkis tipik tahhan gupinwatkis. Ayteke ig katapte muhumdakat ig tipik ta apitit Magadamnaw. ");
INSERT INTO plu_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ig danuh atere, gaytakkis nerras farisewkis gaytakkis nerras sadusewkis danuh atere git Kiyapwiye Jesus adahan gihikekten. Igkis kehkis git annut inugiktekne adahan arekhetni gidatni gitkis kahadbe igkis hiyakri ba ig ayta giwntakwatma Uhokri. ");
INSERT INTO plu_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Igme Kiyapwiye Jesus awna gitkis: ―Ku yis hiyá en duruweh wahanbuku kamuw, yis yibetki awna: “Takuwanek barewye hawkri, mmanawa en duruweh.” ");
INSERT INTO plu_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Hawwata akiw ku yis hiyá en duruweh hawkanawa yis yibetki awna: “Muwokad nemnik, mmanawa en duruweh, ukuhne katamnap.” Yis pukuha en kabayhtiwa. Henneme yis ka hiyá yisma pukuha ku pariye Uhokri gikehni ku apim inin hawkri. ");
INSERT INTO plu_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ayteke ig awna akiw: ―Aa, yis hiyeg amadgaya hawkri. Yis mbeyepye yihiyakemni. Yis kuwis isahkiswe giw Uhokri kuwis. Inneki keh yis kehkis annut nuthu adahan arekhetni ndatni yit. Pahatwowa annut akkaka yitnek, iní annut hawwata ke Uhokri gawnepe amekene Jonas gannube ku samah ig wiwhpika abetitak miyaka abet amamnam hawkri. Ig awna inakni, ig tipik ikiswigkis. Usuh tipik gihapti. ");
INSERT INTO plu_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Usuh manuke danuh pahambakat mahakwa. Henneme usuh miyehe ewk bugut ayta uhapti. ");
INSERT INTO plu_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Usuh danuh atere, ig Kiyapwiye Jesus awna ta wothu: ―Apuriwnabay, pukuhpawnabay abohri ini bugut abusan gidahankis nerras farisewkis gikakkis nerras sadusewkis. ");
INSERT INTO plu_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Usuh timapni henne, usuh kinetihwa pawtak amin inakni giwn. Usuh awna: ―Ig awna inakni awaku wixwiy ka ewk bugut ayta uhaptiwiy. ");
INSERT INTO plu_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Igme Kiyapwiye Jesus timapni henne, ig awna wothu: ―Mmahpaki yis yipewkan ku nah awna inakni awaku yis yuma yibuguta? Yis hiyeg apisatrupye. ");
INSERT INTO plu_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Mmah yis kote pukuhpate ku nah ka kiyimwihwa aharit naxni? Mmah yis kuwis miyehe ku samah nah ibakhase pohowkunene bugut gipuriwkis pohowku mil (5.000) gikebyikis hiyeg? Mmah yis hawwata miyehe ku samah yis kipunse kaayhsima panye akak ini bugut asemne? ");
INSERT INTO plu_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Hawwata akiw mmah yis kuwis miyehe ku samah nah ibakhase ntewnehkernene bugut gipuriwkis paxnika mil (4.000) gikebyikis hiyeg? Mmah yis kuwis miyehe ku samah yis kipunse kaayhsima panye akak ini bugut asemne? ");
INSERT INTO plu_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Mmah yis ka pukuha ku nah ka kinetihwa amin bugutma? Pukuhpawnabay abohri ini bugut abusan gidahankis nerras farisewkis nerras sadusewkis. ");
INSERT INTO plu_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Usuh timapni henne, metakwa usuh pukuhe ku ig ka kinetihwa amin bugut abusan bawa ig kinetihwa amin nerras farisewkis nerras sadusewkis gihiyakemnikis mbeyepye adahan usuh ka ikaw hawwata kema igkisma. Mmanawa gihiyakemnikis ik adahan wagesbeta uhiyakemni monye hawwata ku samah bugut abusan tukurasa bugut. ");
INSERT INTO plu_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ariwnteke ini ig Kiyapwiye Jesus danuh ta apitit waxri kennesa amun paytwempu kewye “Sesaréya gidahan Kiyapwiye Filip”. Ayge ig ayá usuh gikannuhnipwi. Giwn: ―Pariyeki gipewkankis nerras hiyeg ikanhu nah kuri, nah ku pariye wageswe awayg amadgaya inin? ");
INSERT INTO plu_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Usuhme kaytwa giwn: ―Gaytakkis hiyeg ikapi ku pis amekene João Batistamni kannikaw akiw. Gaytakkisme ikapi ku pis amekene Eliyas. Igkisme gaytakkis hiyeg ikapi ku pis amekene Jeremíyas, ku kawk pis pahapwi akiw gaytakkis Uhokri gawnepepu pitatyepwi. ");
INSERT INTO plu_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Igme Kiyapwiye Jesus timapni henne, ig awna wothu: ―Ya yis. Mmahpa yis ikanhu kuri? ");
INSERT INTO plu_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Igme kiyapwiye Simawh Pedru kaytwa giwn: ―Pis Cristo pis Uhokri gikanyan adahan ukumaduketni. Pis Uhokri dehetniye gikamkayh. ");
INSERT INTO plu_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Igme Kiyapwiye Jesus kaytwa giwn: ―Simawh, pis ku pariye kiyapwiye João gikamkayh, pis kapibunugasima. Mmanawa ka hiyegima amadgaya ininma akki pit inakni. Ignewa Wigwiy inugikyene ku pariye ekkepni pit. ");
INSERT INTO plu_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Pisme kuwis akki ku pariyene nah, kuri nahme akkite ku pariyene pis. Pis Pedru. Inakni piw “tip nopsadnano”. Ku samah pis kinetihwa inakni numinhu pis humaw nuthu kewa pahow tipbe ku pariye kabayno adahan eg humaw payt akamaxten. Nuhiyegapu hawwata igkis kewa kaayhsima tipbe ku pariye nah ahegpin adahan nah kehne pahá leglis gukakkis adahan Uhokri kapinnene ayge. Pisme humaw kewa ini payt akamaxtenbe. Igkisme nuhiyegapu humaw kewa pahá payt tiptiyebe kaawinisima ku pariye ka hakuh. Mbayapye akak miyaka in ka hiyá gisamanakis adahan wanegbetene gihawkankis. ");
INSERT INTO plu_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Hawwata akiw pis humaw kewa ini payt akapriwtenbe. Ku aysaw payt akipara tipikwiye ig ikí payt arakapig ta giwakuit payt akapriwten. Nah hawwata aysawnemenek nah keh pis humaw giwewkistenkis nerras ku pariye kumadukasewnepwi ta git Uhokri. Apim ini pis awna nuwntakwa. Ku pariye pis wanegbete ahawkan ay amadga inin, ayta inugiktak hawwata wanegbetnata nihawkan. Hawwata akiw ku pariye pis wategbete ahawkan ay amadga inin, ayta inugiktak hawwata wategbetnata nihawkan. ");
INSERT INTO plu_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ayteke ig Kiyapwiye Jesus awna ta wothu: ―Ka yi muwaka kinetihwa ta gitkis hiyeg ku nahnewa ku pariye Uhokri gikanyan adahan yikumaduketni. ");
INSERT INTO plu_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ayteke ariwnteke ini han pitatit, ig Kiyapwiye Jesus kapusa akkamnih wothu huwewe amin ku pariye nemnikumpiye gimkanit. Ig awna wothu: ―Amawka nah danuh atere Jerusalém, nah hiyá mbeyne kaayhsima aygenek ay giwakukis nerras uwewkistenwiy gikakkis muwpeg kiyatyepwi, gikakkis nerras kannuhekeputnepwi. Ayteke nah umehpikanek. Henneme amamnam hawkri nah kannikasaka ariw numiremninek. ");
INSERT INTO plu_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Igme kiyapwiye Pedru timapni henne, ig wewkiswa gikak atakesa aynessa adahan ig awnene git. Ig awna: ―Kiyapwiye, ka muwaka awna inakni henne. Uhokri ka isaksati ini mbayka adahan in danuh ta pit. ");
INSERT INTO plu_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ig awna inakni henne, igme Kiyapwiye Jesus wagese giduhya gimkat kiyapwiye Pedru, ig awna git: ―Pes ayteke, Satanás. Simawh, pis ka awna inakni akakma Uhokri gihiyakemni. Pis awna akak gihiyakemnikis hiyeg amadgaya inin. Ku samah pis kinetihwa inakni numinhu pis mpithan adahan nah ka keh Uhokri gibetki. Amun ini pis humaw nuthu kewa pahow tipbe ku pariye ik adahan nah tes nipitit nah tuguhe dunibdipinek. ");
INSERT INTO plu_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ayteke ig Kiyapwiye Jesus awna ta wothu madikte usuh gikannuhnipwi. Giwn: ―Ku pahapwi wageswekerepye nuhiyega, amawka ku ig ikise gidahan gibetki. Amawka ku ig umahkise gihiyakemni amadgaya inin ke wotbe ig daddahkiswinbe ta aminat ahbe. Amawka ku ig ikaw hawwata ke nahbe. ");
INSERT INTO plu_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Mmanawa pahapwi ku pariye kiyé gipitnen, iggi biyuknek giw Uhokri adahan apanenekwa. Pahapwime ku pariye miyehe gipitwa ndahan, iggi aymuhwanek gimun Uhokri adahan apanenekwa. ");
INSERT INTO plu_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ku pahapwi darih madikte igiska amadgaya inin henneme ku ig biyuke giw Uhokri, amun ini nikwe ini igiska waditnepyenen gidahan. Yuma ariknawnama igiska ik adahan kawenyene pahapwi gidehetni akiw. ");
INSERT INTO plu_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Mmanawa aysawnemenek nah ku pariye wageswe awayg amadgaya inin nah aytanek gikakkis nuhiyegapu ahj gikak Wigwiy gikiythani. Nah danuh atan, nah ikí madikte hiyeg gitiwnikis pakekunawa akak ku samah gikehnikis ay amadga inin. ");
INSERT INTO plu_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Kennesa ndawnhan adahan nah yikumaduketni, nah ku pariye wageswe awayg amadgaya inin. Yaytak ku pariye ay ku akak inin, apit yis miyá yis hiyapninek. Ihanabay inakni nuwnhu. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ayteke ariwnteke ini puguhkuna hawkri, ig Kiyapwiye Jesus iwé kiyapwiye Pedru gikak amekene Tiyagumni gikak gisamwi kiyapwiye João adahan igkis tipik gihapti. Igkis wagehe ta apitit pahá waxri imuwadnene. Igkiswonakis ayge. ");
INSERT INTO plu_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ayge gimunkis ig uniyehwe gihipak nawenéwa akiw. Gihepka amuwe ke kamuwbe, gisimsa wageswe barewye ke kabutnikibe kaahawnasima. ");
INSERT INTO plu_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ayteke pahaye adahan amekene Moís gikak amekene Eliyas igkis hiyapkiswe atere gitkis. Igkis ayge kinetihwenes gikak Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Igme kiyapwiye Pedru hiyapni henne, ig awna ta git Kiyapwiye Jesus. Giwn: ―Kiyapwiye, kibeynekata wixwiy ay kabubuk apim inin. Uyay msakwa ay. Ku pis muwaka, nah keh mpana paytbetyanyupwi ay. Pahá pidahan, paháme gidahan kiyapwiye Moís, paháme gidahan kiyapwiye Eliyas. ");
INSERT INTO plu_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ku samah ig awnempiye inakni yuwit henne, pahaye adahan pahá ukuhne kaneamuwyisima biyuhe ta gipititkis. Ayteke pahá ikupimnat awna gitkis aytontak abetitak ini ukuhne. In awna: ―Ner nukamkayh nubetki. Ig keh nah batek kaayhsima. Ataybiswanabay git. ");
INSERT INTO plu_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Igkisme gikannuhnipwi timapni inakni henne, igkis tuguhkiswa mabuw ta waygboit, igkis wakaymnibdi mpiynepepye. ");
INSERT INTO plu_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Igme Kiyapwiye Jesus atere gitkis, ig daxrikis. Ig awna gitkis: ―Kannikawnay. Ka yi muwaka apis. ");
INSERT INTO plu_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Igkisme sarayh gipegyikis atere, igkis iwasa. Yumehe nerras piyanenene gikebyikis. Igwo Kiyapwiye Jesus msekwe ayge gimunkis. ");
INSERT INTO plu_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ayteke nikwe igkis muhuke apititak ini waxri imuwadnene. Igkis muhukempi, ig Kiyapwiye Jesus awna ta gitkis. Giwn: ―Ka ba yi kinetihwa ta gitkis hiyeg aynesnima amin ku pariye yihiypan ku apim inin. Ka yi muwaka kinetihwa nimin he ku aysawnemenek nah ku pariye wageswe awayg amadgaya inin nah kannikew ariw numiremninek. Ariwnteke ini nikwe ik adahan yis kinetihwa nimin. ");
INSERT INTO plu_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Igkisme ayapri: ―Kiyapwiye, ku pis Cristo, ku pis Uhokri gikanyan adahan ukumaduketni, mmahki nerras kannuhekeputnepwi awna: “Amawka ku amekene Eliyas ig kit danuh atan giw Cristo?” ");
INSERT INTO plu_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Igme kaytwa giwnkis: ―Hennewa in. Pahapwi kene amekene Eliyasbe ig kit ayta adahan ahegbetepye madikte napithu. ");
INSERT INTO plu_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ihanabay inakni nuwnhu. Ayipa ig kuwis danuh atan. Henneme ig mahikohpika. Hiyeg ay arewha git ku samah gimawkanitnenes. Nah hawwata akiw, nah ku pariye wageswe awayg amadgaya inin, aysawnemenek nah hawwata hiyá mbeyne ay giwakukis. ");
INSERT INTO plu_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Igkis gikannuhnipwi timapni henne, metakwa igkis pukuha ku ig kinetihwene gimin amekene João Batista ku ignewa ku pariye ner pahapwi kene amekene Eliyasbe. ");
INSERT INTO plu_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ayteke ariwnteke ini igkis diyuhe ta gitkis nerras hiyeg kabubuknene. Igkis danuh atere, pahapwi awayg danukwa kennesa git Kiyapwiye Jesus. Ig paberetusaw gikimpuit. Ig awna git: ");
INSERT INTO plu_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Kiyapwiye, uyá amnih nukamkayh. Ig nuwiskewenpiye. Ig hiyá mbeyne kaayhsima mmanawa kibereput ig tuguh ta abetit tiket ig tuboh ta ahakwat un. ");
INSERT INTO plu_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Kuwis nah waxepri ta gitkis pikannuhnipwi henneme igkis ka hiyá gimakniwak. ");
INSERT INTO plu_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ig Kiyapwiye Jesus timapni henne, ig awna git: ―Aa, yis hiyeg taraksapye amadgayapu inin. Mmahki yis kane kamaxwa aynesnima gipitit Uhokri? Aysaw akebyi hawkri yimawkan nah msakwa ay yikak nah kiyaknihwa yikak juktah yis kamaxwa gipitit Uhokri? Kuri waxwa pikamkayh ayta numkanit. ");
INSERT INTO plu_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Igme ihe giwn. Ayteke nikwe ig Kiyapwiye Jesus himehe ner wapitye. Igme wapitye pese gipititak. Aynewa ig bakimni makniw. ");
INSERT INTO plu_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ayteke ariwnteke ini usuh gikannuhnipwi atere git Kiyapwiye Jesus usuhwo. Usuh ayapri: ―Ya usuh? Mmahki usuh ka hiyá apukwak ner wapitye? ");
INSERT INTO plu_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Igme kaytwa wownhu: ―Awaku yis ka kamaxwa gipitit Uhokri kiyesradima. Ihanabay inakni nuwnhu. Waké yis kamaxwa gipitit aynesnibe akiw, nikwekam madikte yayapni humaw yitkam. Hiyawa yikamaxwan nopsesniyene ayesri ke pahow amutribe ayakbe ke “mostad” ayakbe, hiyawa in aynessanen henneme yayapni humaw yitkamnek. Yis ikkam adahan yis awna ta arit inin waxri imuwadnene: “Waxri, pis higihwa ayteke. Su tahhan atere.” Pase yis awna inakni, in higihwakam ayteke. Yuma ariknawnama mahikokam yidahan. ");
INSERT INTO plu_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Henneme akebyi ner wapitye yis ka hiyá gipukwak hennentima kema inima. Amawka ku yis piriyepkaw kaayhsima. Amawka ku yis kiyé Uhokri akak yimaxhawni. ");
INSERT INTO plu_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ayteke ariwnteke ini usuh gikannuhnipwi pahadguhwa atere git ayhté Galiléyamnaw. Ayge ig Kiyapwiye Jesus awna ta wothu: ―Aysawnemenek nah ku pariye wageswe awayg amadgaya inin nah kamaykiswikanek ta gitkis hiyeg amadgayapu inin. ");
INSERT INTO plu_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Apim ini igkis nuwmepten. Henneme amamnam hawkri nah kannikaw akiw ariwntak numiremninek. Usuhme gikannuhnipwi timapni henne, usuh msekwe barukibet. ");
INSERT INTO plu_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ayteke ariwnteke ini usuh tipik gihapti Kiyapwiye Jesus, usuh danuh ta apitit paytwempu Kafarnawh. Ayge hiyeg patiptak kiyapwiye Pedru. Igkis ahiwkeputnepwi karukri adahan ini leglis kewye Uhokri Gipin. Igkis danuh ta git kiyapwiye Pedru, igkis ayapri: ―Mmah pikannuhten mmah ig ka katiwnih Uhokri Gipin? ");
INSERT INTO plu_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Igme kiyapwiye Pedru kaytwa giwnkis: ―Ihi. Ig katiwnih. Ayteke ig tipik kinetihwa gikak Kiyapwiye Jesus. Ig pareke atere paytrikut. Henneme apit ig awna, ig kit Kiyapwiye Jesus awna git. Giwn: ―Simawh, mmahki pipewkan? Kitki gupelma amadgaya inin ayá karukri adahan katiwnih ladwan? Ba ig ayá gitkis gihiyegapu? Ba kawk ba ig ayá gitkis nawenépwinen? ");
INSERT INTO plu_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Igme kiyapwiye Pedru kaytwa giwn: ―Ig ayá ta gitkis nawenépwinen. Igme Kiyapwiye Jesus awna: ―Nikwe Uhokri gikamkayupwi ka muwaka katiwnih adahan parak ta gipinekut Uhokri. Nahnewa Uhokri gikamkayh. Nah ka kis adahan nah katiwnihni. ");
INSERT INTO plu_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Henneme ka sam. Uyay ka kiyimwih nerras ahiwkeputnepwi karukri. Ku wis ka katiwnih Uhokri Gipin, gitkis wis ka kiyatin. Uyay ka kiyimwihgikis henne. Ataknaba ta ihapkat. Padaknaba pipuh ahakwat un. Pitatye pis ipuha im, pis woka gibiy. Ayge pis utinek pahamku kirehka. Akak no pis katiwnih ndahan, pidahan. ");
INSERT INTO plu_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Apiminewa ini usuh gikannuhnipwi pahadguhwa atere git Kiyapwiye Jesus, usuh ayapri: ―Pariye hiyeg pi kiyatte abet Uhokri gikumadukan? ");
INSERT INTO plu_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ig timapni henne, ig humeke pahapwi bakimni ayta gimkat. Ig tabirasig wowtriknewa. ");
INSERT INTO plu_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ayteke ig awna wothu: ―Ku yis ka wages yihiyakemni adahan yis ikaw kewa bakimnaybe, yis ka kawihti Uhokri gikumadukan. Ihanabay inakni nuwnhu. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Henneme ku pahapwi yaytak ikaw ke wotbe ig yumahbe gikiythanibe ke ner bakimnibe, ignewa ku pariye pi kiyattenene hiyeg abet Uhokri gikumadukan. ");
INSERT INTO plu_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Hawwata akiw ku pahapwi amnih pahapwi bakimni kene nerbe ndahan, amun ini nikwe in ke wotbe ig kuwis amnihun. ");
INSERT INTO plu_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Henneme ku pahapwi taraksase pahapwi bakimni nopsesniye ku pariye kamaxwene nupitit, iggi katiwnihninek. Ig utinek mbayka pi mbayte akiw giw pahapwi ku pariye wanekwika gibitamna akak pahow tip nopsadnano adahan ig padekwika gamihawnite parawhokwa ig aniksew. ");
INSERT INTO plu_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","―Akayih. Hiyeg amadgaya inin hiyá mbeyne kaayhsimanek awaku ba akebentenwa gitaraksaseptenkis ay amadgapu inin. Ka sam. Pugamawka hiyeg kataraksasepten. Henneme ku pahapwi hiyeg taraksase pahapwi, ig katiwnihninek, ig hiyá mbeyne kaayhsimanek. ");
INSERT INTO plu_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","―Battukawnaba adahan pis apuriw pihiyakemni adahan pis ka taraksa. Ku pis me taraksemet akak piwak akak pikugku, pi kabayte pis bukihpin padekwin mpinekata pis tarakse. Mmanawa aysawnemenek pis katiwnih pitaraksannek. Pi kabayte pis aymuhwa gimun Uhokri mawokuh yumanene pikugku mpinekata pis padekwika piwoknamte piwak pegbakte pikugku ta abetit eggu tiket dehetniki. ");
INSERT INTO plu_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ku pis me taraksemet awaku pis ipeg arimkat ku pariye arikna kane kabay, pi kabayte pis wareke piwtyak pis padekwin mpinekata pis tarakse. Mmanawa pi kabayte pis aymuhwa gimun Uhokri mowtih mpinekata pis padekwika pegbakte piwtyak ta arimkanit ini iwetrit ku kiney kaneayhsima kayahwaki abet tiket. ");
INSERT INTO plu_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","―Apuriwnabay ku samah yihiyakemni. Ka yi muwaka ikaw kabaytema giw pahapwinama bakimni. Ayhté inugik ahj gidahankis apanenekwa tabirbet ay gipetun Wigwiy inugikyene adahan igkis ekkenes git nerras ku pariye kane kiyatha gapuriwnikis bakimnay. Hennewatbaki igkis. ");
INSERT INTO plu_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Igkis bakimnay kagipigikissima nuthu kewa muttuh biyukapyebe. ");
INSERT INTO plu_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ku pahapwi kadahan kaayhsima gipig muttuh, madikawku madikwa (100) gikebyikis, ku pahapwiwa gipig kiduhe hampa arimkanit biyukwiki, pariye yipewkan ig awayg keh? Ig ikise gipig akebyupwi (99) ayge apit waxribdi, ig ta ipegepye gipig ku pariye kiduhe hampa arimkanit biyukwiki. ");
INSERT INTO plu_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ku ig utepri, ig pi batekte akak ku samah gipig biyukwiye ay gimun akiw mpiya ku samah ig batek akak nerras gipig akebyupwi (99) ku pariye ka kiduhati hampa arimkanit biyukwiki. Hennewatbaki ig batek. ");
INSERT INTO plu_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ig Wigwiy inugikyene hawwata ig ka hiyepkere pahapwinama bakimni biyuk. ");
INSERT INTO plu_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","―Ku pikebyi tarakse pikak, amawka pis ta akka gitaraksan git. Ka ba akkin ta gitkis nawenépwima hiyeg. Henneme pis akkin ta git ig pahapo. Ku ig ihe piwn ku ig awna: “Hennewa nah tarakse”, nikwe apim ini yis wadithebdih yihawkan. ");
INSERT INTO plu_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Henneme ku ig ka timepkere piwn, pis ataknaba kinetihwa gikak pahaynewata akiw. Pis iwá ba pahapwi ba piyana hiyeg adahan igkis ateknes pihapti adahan igkis payapetni ekkenes gitaraksan git adahan igkis pitemwera. Mmanawa Uhokri gannasan awna: “Ku piyana utemwera ku giwnkis tuguh hehpekwiye, nikwe ik adahan wis iha inakni giwnkis.” ");
INSERT INTO plu_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Henneme ku ig ner pahapwi kawnata timepkere giwnkis, nikwe pis akka gitaraksan ay gipetunkis madikte Uhokri gihiyegapu adahan igkisme ikenes gihiyakmni. Ku ig kawnata timepkere giwnkis, nikwe hiyawa pis keh gikak ku samah pis keh gikakkis hiyeg kane Uhokriyanpuma gikakkis hiyeg kane kibeynepwima. ");
INSERT INTO plu_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","―Ku pariye yis wanegbeta ahawkan ay amadga inin, ayta inugiktak hawwata wanegbetnata nihawkan. Hawwata akiw ku pariye yis wategbeta ahawkan ay amadga inin, ayta inugiktak hawwata wategbetnata nihawkan. Ihanabay inakni nuwnhu. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Hawwata akiw ku piyanmowa hiyeg tuguhkis gihiyakemnikis hehpekwiye adahan ku pariye gayapnikis git Uhokri, nikwe ig Wigwiy inugikyene keh ku samah gayapnikis git. ");
INSERT INTO plu_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Mmanawa ku kiney hiyeg pahadgupu nuwaprik, ba piyanmowa gikebyikis ba mpanmowa gikebyikis, amun ini nah ayge gikakkis. ");
INSERT INTO plu_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ayteke ig kiyapwiye Pedru danukwa atere git Kiyapwiye Jesus. Ig ayapri: ―Kiyapwiye, aysawput amawka nah bayahmina nukebyi ariw gitaraksan nukakhu? Ba ntewnehkerput? ");
INSERT INTO plu_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Igme Kiyapwiye Jesus kaytwa giwn: ―Kawa. Ka ntewnehkerputnama. Amawka pis bayahminig ariw gitaraksan pikak kibereput mpiya ku pariye pis hiyá apuka, ntewnehker madikwaput ntewnehkerput akiw. ");
INSERT INTO plu_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","―Nah akkite pit abektey amin ku samah Uhokri gikumadukan. Minikwak pahapwi ikiparat iwasepye gihiyegapu gimatiwnihnikis git. ");
INSERT INTO plu_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Pase ig kapusa, pahapwi awayg waxepka atere git ku pariye matiwnihpig kaayhsima karukri, madikawku mil (10.000) kirehka nopsadnano karukri wahano seyno. ");
INSERT INTO plu_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ig ner awayg yumahwa gikakura kiyesradima adahan ig katiwnihpiye ini gimatiwnihni git. Igme gikipara hiyapni henne, ig gipiyukiswitni adahan bukitka payak gukak gihayo gikakkis gikamkayupwi payak akak madikte gewkanbet adahan katiwnihkiswiye ini gimatiwnihni git. ");
INSERT INTO plu_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Igme ner awayg paberetusaw gikimpuit gikipara. Ig amnihswe git. Giwn: “Uyá amnih kiyaknihwa nukakhu. Nah katiwnih madikte numatiwnihni pitnek.” ");
INSERT INTO plu_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Igme gikipara hiyapni henne, ig amnihpig. Ig hiyak ku ig ka hiyá asamanak diyuhkis gikakura awenyan. Nikwe ig bayahminig ariw madikte gimatiwnihni git. Ig isahkiswig tipik. ");
INSERT INTO plu_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Igme ner gihiyega apigkune ahin, ig patiptak gikak pahapwi awayg igwata ihiyegat. Igme ner awayg matiwnihpig aynessa karukri, sah (100) kirehka nopsesniyo karukri wahano seyno. Igme hiyapni henne, ig kamaxwig ig pidikwig gibitamna. Ig awna git: “Katiwnih pimatiwnihni nuthu kuri.” ");
INSERT INTO plu_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Igme ner awayg hiyapni henne, ig paberetusaw ta gikimpuit. Ig amnihswe git. Giwn: “Uyá amnih kiyaknihwa nukakhu. Nah katiwnihpepnek.” ");
INSERT INTO plu_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Igme ka kiyaknihwa gikak aynesnima. Ig padakkiswig agikut parakseket he ku aysaw ig katiwnih gimatiwnihninek. ");
INSERT INTO plu_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nerrasme hiyeg igwata ihiyegat ignes hiyapni henne, igkis wakaymnibdi kaayhsima. Nikwe igkis tipik ta git gikiparakis. Igkis danuh atere, igkis kinetihwa madikte git. ");
INSERT INTO plu_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ig gikiparakis timapni henne, ig watiha ner gihiyega. Ku aysaw ig danuh atere, ig awna git. Giwn: “Pis mbeyepye hiyeg! Nah kuwis bayahminep ariw madikte pimatiwnihni nuthu. He pamnihkanen nah amnihpep awaku pis amnihswa nuthu. ");
INSERT INTO plu_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Mmahki pis ka amnih piyaki hiyeg hawwata ku samah nah amnihpep? Kiskama pis bayahminig.” ");
INSERT INTO plu_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ayteke ig gikipara kaayhsima dagawne git. Ig ikaksig ta agikut parakseket adahan ig hiyepne mbeyne juktah ku aysaw ig katiwnih gimatiwnihni git madikte. ");
INSERT INTO plu_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Hennewa Wigwiy inugikyene keh gikakkis madikte hiyeg. Ku yis ka bayahmina yiyaki hiyeg ariw gitaraksankis yikak apititakma yiyakni, ayge nikwe ig Uhokri keh yikak hawwata ke ner ikiparatbe. Hennewatbaki ig Kiyapwiye Jesus awna git. ");
INSERT INTO plu_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Pisenwa inakni gawnhan, ig Kiyapwiye Jesus tipik apititak Galiléyamnawtak. Usuh tipik gihapti. Usuh diyuh ta apitit Judeyamnaw pahambakaytak warik Jordawh. ");
INSERT INTO plu_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ig Kiyapwiye Jesus danuh atere, kaayhsima hiyeg makeke gihapu butte. Ayge ig piyihpigkis. ");
INSERT INTO plu_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ayteke gaytakkis farisewkis danuh atere git. Igkis ayaptig adahan gihikekten ba ig awna yuwit taraksebetnama. Igkis ayapri: ―Ba wadit adahan wis isaksa pahapwi mayta gihayo, ku aysaw ig maytwekerepye? ");
INSERT INTO plu_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Igme kaytwa giwnkis: ―Mmah yis kote ipegbohate Uhokri gannasan minikweknene? In awna: “Humawkariwka ig Uhokri keh hiyeg humaw awayg gukak tino.” ");
INSERT INTO plu_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ayteke nikwe ig Uhokri awna: “Ku aysaw pahapwi awayg maripkaw, ig tipik giw gig gukak ginag. Ig hamah gukak gihayo. Amun ini nikwe egkis piyamate humaw pahapwiwa gupitkis pawtak.” ");
INSERT INTO plu_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ayge nikwe ke wotbe egkis pahapwiwatbe. Amawka ku hiyeg amadgaya inin ka ibakhasa ku pariye Uhokri hamahkise pawtak. ");
INSERT INTO plu_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Igkisme ayapri: ―Mmahki nikwe ig amekene Moís awna: “Ku pahapwi maytepye gihayo, amawka ig ikí gut pahak kagta ku pariye awna: ‘Pis ka nuhayama akiw’. Ayteke nikwe hiyawa ig maytepru.” ");
INSERT INTO plu_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Igme Kiyapwiye Jesus kaytwa giwnkis: ―Ig amekene Moís isaksa yis mayte yihayo awaku yis yidahniskata ihpa Uhokri giwn. Henneme minikwak humawkariwka ka hennema. ");
INSERT INTO plu_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Kurime nikwe nahme awna yit, ku pahapwi mayta gihayo waditnepyenen eg ka powkemnihwa, ku ig maripkaw gukak pahapuwa tino akiw, amun ini nikwe giwtrik Uhokri ig kuwis powkemnihwe gukak. ");
INSERT INTO plu_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Usuh gikannuhnipwi timapni inakni giwn henne, usuh awna git: ―Ku wixwiy awaykemni ku ka hiyá wixwiyma mayta uhayoyi henne, nikwe pi kabayte wixwiy ka maripkaw. ");
INSERT INTO plu_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Igme kaytwa wownhu: ―Hennewa. Henneme ka madiktema awayg amapa inakni yiwn. Igneswa ku pariye ikaka ta gipititkis adahan igkis msakwa mahayo, igkis amapin. ");
INSERT INTO plu_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ay arakembet ku pariye mpitha pahapwi adahan ig ka daxtasaw gut tino. Gaytakkis hiyeg aytniyewa gitkis henne. Gaytakkisme hiwhka gapitkis hiyeg adahan igkis ka hamah gukak tino. Gaytakkisme giwntekneswa msakwa mahayo adahan igkis ekkene Uhokri gikumadukan. Ku pahapwi amapin, hiyawa ig amapin. ");
INSERT INTO plu_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ayteke hiyeg danuh atere git Kiyapwiye Jesus. Igkis waxe gikamkayhkis ta git adahan igme sarayh giwak ta gipititkis adahan ig kiyene Uhokri gidahankis. Usuhme gikannuhnipwi hiyapni henne, usuh awna gitkis adahan igkis ka ayta sigimwihgi. ");
INSERT INTO plu_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ig Kiyapwiye Jesus hiyapni henne, ig awna wothu: ―Isaksanabay bakimnay ites aytnite numkanit. Ka yi muwaka mpitha bakimnay. Mmanawa ku pariye hiyeg gihiyakemnikis kene bakimnibe ignesnewa ku pariye kawih Uhokri gikumadukan. ");
INSERT INTO plu_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ayteke nikwe ig sarayh giwak ta gipititkis. Ig kiyé Uhokri gidahankis. Pisenwa ig tipik. ");
INSERT INTO plu_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Apim ini pahapwi awayg takwaye danuh atere git Kiyapwiye Jesus. Ig ayapri: ―Kiyapwiye, uyá akki nuthu. Pariye kabayka nah keh kuri adahan nah utí dehetniki gimun Uhokri adahan apanenekwa? ");
INSERT INTO plu_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Igme Kiyapwiye Jesus kaytwa giwn: ―Mmahki pis ayapun amin kabayka? Ay pahapwinen ku pariye keh kabayka. Ignewa Uhokri. Ku pis muwaka utí dehetniki gimun Uhokri, ihpanaba Uhokri gikumadukan. ");
INSERT INTO plu_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Igme awayg ayapri: ―Pariyeki ini gikumadukan? Igme Kiyapwiye Jesus kaytwa giwn: ―Ka muwaka umah hiyeg. Ka muwaka powkemnihwa. Ka muwaka amepwi. Ka muwaka wasaymhaw. ");
INSERT INTO plu_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Kiyatha pig. Kiyatha pinag. Batek gikakkis piyakipwi hiyeg hawwata ku samah pis batek akak pipit. ");
INSERT INTO plu_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Igme takwaye awna git: ―Nah kuwis ihpa madikte. Pariye muwaka nuthu akiw adahan nah keh? ");
INSERT INTO plu_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Igme Kiyapwiye Jesus kaytwa giwn: ―Ku pis muwaka keh apigkutaprik ku samah Uhokri gimawkan, su tipik piyuk pewkanbet madikte. Ayteke nikwe pis ikí akakurapig ta gitkis madiptapye. Ayge nikwe pis utí kaayhsima igiska ayhté inugiknek. Ayteke pisenwa papiykan pewkanbet pis ayta wew nukakhu. ");
INSERT INTO plu_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Igme takwaye timapni henne, ig wakaymni ig barukiswe kaayhsima mmanawa ig kaayhsima gewkanbet ay gimun. Ig apise ku nawenétke ig biyuk akak ini gewkanbet. Aydyé ig tipik. ");
INSERT INTO plu_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ig Kiyapwiye Jesus hiyapni henne, ig awna wothu gikannuhnipwi. Giwn: ―Kaayhsima mahiko adahan hiyeg igisapye kawih Uhokri gikumadukan. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nah awna inakni pahaynewata akiw. Ku yis hiyá ku mahiko adahan pahapwi puwikne “kamelu” parak mapiya apuriku pahat kakus amiyokni, in pi mahikote akiw adahan pahapwi igisye parak ku kiney Uhokri gikumadukan. ");
INSERT INTO plu_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Usuh timapni henne, usuh wakaymnibdi mpiynepepye. Usuh awna: ―Ta wothu ku pahapwi igisye, in arakak ku ig kibeyne giwtrik Uhokri mmanawa ig kabunuga gikak Uhokri. Ku mahiko henne adahan igisapye danuh git Uhokri, nikwe yuma hiyeg amadga wayk danuhne git Uhokri. ");
INSERT INTO plu_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Igme Kiyapwiye Jesus sarayh gipegyi ta womkanit. Ig awna ta wothu: ―Madikte hiyeg ka hiyá ignesma danuh git Uhokri ku ka igma Uhokri amnihgikis. Henneme madikte arikna ka mahikonama gidahan Uhokri. ");
INSERT INTO plu_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Igme kiyapwiye Pedru awna git: ―Usuh kuwis ikise madikte wewkanbet adahan usuh wewne pikak. Pariye usuh utí nikwe? ");
INSERT INTO plu_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Igme Kiyapwiye Jesus awna wothu: ―Aysawnemenek abet nukune hawkri nah ku pariye wageswe awayg amadgaya inin nah bat akak madikte nukiythani amadga nepwi kiyatyo ku kiney adahan nah hiyekne gikakkis hiyeg. Apim ini yis ku pariye wewnepwi nukakhu yis hawwata batebdeweknene amadga yepwi kiyatyo madikawku akebyi akak pisaya arawna (12) adahan yis hiyekne gikakkis nerras hiyegipiyenepwi israelyenepwi madikawkunene gikebyikis gikakkis piyana gawnakis (12). Ihanabay nuwnhu. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Madikte hiyeg ku pariye ikiswiye gipinkis, gikakkis gikebyupwi, gigkis, ginagkis, gikamkayhkis, giwasrakis, ku igkis ikiswiye madikte adahan igkis ayta nuharit, igkis utí nikwe pi kibite akiw, madikawku madikwa gukebyikis (100) akiw. Hawwata igkis aymuhwanek gimun Uhokri adahan apanenekwa. ");
INSERT INTO plu_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Henneme ka yi muwaka ikaw kiyatte mpiy pahapwi awaku ini. Mmanawa aysawnemenek kaayhsima hiyeg ku pariye ikaka pi kiyatte mpiy pahapwi, aysawnemenek ignes ka mpiya pahapwinama hiyeg. Hawwata akiw kaayhsima hiyeg ku pariye ikaka yumanene gikiythanikis ay amadga inin, aysawnemenek yuma hiyeg pi kiyatte mpiyigkis. ");
INSERT INTO plu_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","―Nah akkite yit nawenéwa abektey amin ku samah Uhokri gikumadukan. Minikwak pahapwi was akipara tipik hawkanawa adahan ipegpene hiyeg adahan igkis kannipwiyes amadga giwasra. ");
INSERT INTO plu_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ig uté hiyeg, ig awna gitkis: “Uyay kannipwi ndahan mataytak. Nah katiwnihpey ku samah hiyeg gibetratunkis katiwnih. Nah ikí yit pahamku karukri seyno yitiwni. Ba kabay yit?” Igkisme kaytwa giwn: “Ihi, in kabayhtiwa wothu.” Ayteke nikwe ig awahkiswigkis ta wasamdakat. ");
INSERT INTO plu_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ariwnteke ini inute kamuw, ig tipik danuhpene ta higiwkat. Ayge ig utí hiyeg he tabirenen. ");
INSERT INTO plu_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ig hiyapni henne, ig awna ta gitkis: “Yis hawwata ik adahan kannipwi amadga nuwasra. Su yi atak atere. Nah ikí yitiwni ku samah in kabay nuthu.” Igkisme tipik wasemdekete. ");
INSERT INTO plu_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ariwnteke ini puwipka abet, ig ner was akipara keh hawwata akiw. Ariwnteke ini daraka kamuw, ig keh hanapawata akiw. ");
INSERT INTO plu_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ayteke ariwnteke ini arimkat aygetwiki, ig tipik ta higiwkat akiw. Ayge ig uté nawenépwi hiyeg akiw, igkis he tabirnene ayge. Ig hiyapni henne, ig ayaprikis: “Mmahki yis he tabirenen ay amadga higiw mataytak?” ");
INSERT INTO plu_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Igkisme kaytwa giwn: “Awaku yuma hiyeg ikí wannipwi.” Igme hiyapni henne, ig awna gitkis: “Yis hawwata ik adahan kannipwi amadga nuwasra. Su yi atak atere.” ");
INSERT INTO plu_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ayteke ariwnteke ini aygete kuwis, ig was akipara awna ta git akapriwten karukri. Giwn: “Watihanaba madikte nuhiyegapu. Katiwnihnigkis. Katiwnihnaba igkis kit nerras ku pariye parak buttit abet annipwit he pis danuhe ta gitkis nerras pitatyepwi parak.” ");
INSERT INTO plu_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Igme akapriwten karukri timapni henne, ig ihe giwn. Ig watihe gihiyegapu. Igkisme danuh atere, igme gikatiwnihpitnikis. Nerras ku pariye parak arimkat aygetwiki igkis daxnekwiye pahamku karukri seyno. Henne ig katiwnihape madikte gikipara gihiyegapu. ");
INSERT INTO plu_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ayteke metakwa nerras ku pariye kit parak abet annipwit igkis danuh atere adahan daxwiyes gikakurakis. Gipewkankiskam igkis dax pi kiyeste gitiwnikiskam. Henneme igkis dax hawwata pahamku karukri seyno. ");
INSERT INTO plu_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Igkis hiyapni henne, igkis awnebdi ta git ner gikiparakis. ");
INSERT INTO plu_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Giwnkis: “Kiyapwiye, pis ka keh wadit ukakhu. Nerras buttitwiyepwi igkis kannipwiye pahaywowa ler. Usuhme kannipwiye mataytak abet kamuw awahni. Henneme pis katiwnihpigkis hawwata ku samah pis katiwnih usuh.” ");
INSERT INTO plu_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Igme kaytwa pahapwi giwn: “Nukagmada, nah ka kinispi. Wis kuwis ahegbete unetni adahan nah katiwnihpi pahamku karukri seyno. ");
INSERT INTO plu_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Amerepnaba pitiwni adahan pis diyuh ta pipinwat. Nahwa muwaka katiwnih nerras buttitwiyepwi hawwata ku samah nah katiwnihpi. ");
INSERT INTO plu_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nukakura ndahanwa adahan nah keh nikak ku samah numawkan. Ka muwaka dagawnaw adahan ini ku nah kehne kabayka gidahankis.” ");
INSERT INTO plu_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ayteke pisenwa gawnhan inakni yuwit, ig Kiyapwiye Jesus awna: ―Inaknibaki arakak adahan ku samah aysawnemenek kaayhsima hiyeg ku pariye ikaka yumanene gikiythanikis ay amadga inin, aysawnemenek yuma hiyeg pi kiyatte mpiyigkis. Hawwata akiw kaayhsima hiyeg ku pariye ikaka pi kiyatte mpiy pahapwi, aysawmenemek ignes ka mpiya pahapwinama hiyeg. ");
INSERT INTO plu_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ayteke ig Kiyapwiye Jesus ay apigku ahin tipikwiye arimkat paytwempu Jerusalém, ig pahadguhe usuh giwatnipwi (12) ta git usuhwo. ");
INSERT INTO plu_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Ayge ig awna ta wothu: ―Kuri wixwiy wagehe ta arimkanit Jerusalém. Nah ku pariye wageswe awayg amadgaya inin nah kamaykiswikanek ayge ta gitkis muwpeg kiyatyepwi ta gitkis nerras kannuhekeputnepwi amin amekene Moís gikumadukan. Ayge nikwe igkis ikaksepun adahanikwa miyaka. ");
INSERT INTO plu_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Apim ini igkis ikepun ta giwakuitkis hiyeg kane judeyenepwima. Igkisme mahipwihpennek igkis biptepun akak tigay. Pisenwa nikwe igkis deddehpen aminat ahnek. Henneme amamnam hawkrinek nah kannikaw akiw. ");
INSERT INTO plu_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ayteke ig amekene Zebedew gihayo eg danukwa atere git Kiyapwiye Jesus. Eg ayta payak gikakkis gukamkayupwi ig amekene Tiyagumni gikak kiyapwiye João. Eg paberetusaw gikimpuit Kiyapwiye Jesus, eg awna git: ―Kiyapwiye, uyá amnihun keh ku samah numawkan pit. ");
INSERT INTO plu_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Igme Kiyapwiye Jesus kaytwa guwn: ―Pariyeki pimawkan nuthu? Egme kaytwa giwn: ―Aysawnemenek apim ini ku aysaw pis kumadukenenek, uyá amnih isaksa nerras nukamkayupwi piyana gikebyikis adahan igkis bat ayge pihumwa ay amun ini iwetrit ku pariye pi kiyattenene. Numawkan pahapwi bat kihehaptak, pahapwime bat patuwanaptak. ");
INSERT INTO plu_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Igme Kiyapwiye Jesus awna gitkis gukamkayupwi: ―Yis ka hiyak ku pariye yayapni. Aysawnemenek nah hiyá mbeyene kaayhsimanek. In ke nuthube nah higá higapka kaneatipinisima agikutak pahow goblé. Ba yis ik adahan yis higá agikutak no goblé hawwata ke nahbe? Igkisme kaytwa giwn: ―Ihi. Usuh ik adahan amapin hawwata ke pisbe. ");
INSERT INTO plu_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Igme Kiyapwiye Jesus awna gitkis: ―Aysawnemenek yis higá ini nuhigpannek agikutak nugobla. Yis hiyá mbeyne kaayhsimanek. Henneme ka nawhma batahkis hiyeg ayge nuhumwa iné kihehaptak iné patuwanaptak. Ini iwetrit kanenikiythanisima ini gidahankis nerras ku kadahan Wigwiy kuwis ahegbetin. ");
INSERT INTO plu_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Usuh Jesus giwatnipwi asemne madikawkunene ukebyi, usuh timapni henne, usuh hahhayruke gikakkis nerras piyananene gikebyikis amekene Tiyagumni gikak kiyapwiye João. ");
INSERT INTO plu_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Igme Kiyapwiye Jesus hiyapni henne, ig pahadguhe usuh madikte git. Ig awna wothu: ―Ka yi muwaka ikaw gapitminama pahapwi. Yis kuwis hiyak nerras ikiparat amadgayapu inin gihiyakemnikis, ku samah igkis ikaw gapitminkis gihiyegapukis, igkis kabukhewpi gitkis. ");
INSERT INTO plu_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Yisme ka hennema. Yidahan nawenéwa. Ku pahapwi yaytak humewkere yapitmin madikte, amawka ig ka kabukhaw yit. Amawka ku ig ikaw ke wotbe ignewa yibukbe. ");
INSERT INTO plu_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ku pahapwi yaytak humewkere kiyatye hiyeg giwtrik Uhokri, amawka ku ig ikaw ke wotbe ig yumahbe gikiythanibe ay amadga inin. ");
INSERT INTO plu_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Amawka ku yis ikaw hawwata ke nahbe. Nah ku pariye wageswe awayg amadgaya inin nah ka ayta adahanma hiyeg keh kabayka ndahan henneme nah ayta adahanikwa nah kehne kabayka gidahankis hiyeg. Hawwata akiw nah ayta adahan nah umahkiswa gidukwenaprikkis hiyeg kahadbe ignes isamtaw. ");
INSERT INTO plu_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ku samah usuh peswiye apititak paytwempu Jerikó, kaayhsima hiyeg makeke gihapu Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Apiminewa ini piyana gikebyikis motapye bat ayge ahinmu. Igkis kinetni Kiyapwiye Jesus gak ku ig mpiyepye. Igkis timapni henne, igkis kabiman git: ―Kiyapwiye, pis ukipara hawwata ke amekene Davibe. Uyá amnih usuh. ");
INSERT INTO plu_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nerras hiyeg ku pariye pahabunene ayge igkis timapni henne, igkis himehpigkis. Igkis awna ta gitkis: ―Ka yi muwaka kabiman henne. Igkisme pi kabimenpipa akiw. Igkis awna: ―Kiyapwiye, pis ukipara hawwata ke amekene Davibe. Uyá amnih usuh. ");
INSERT INTO plu_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ig Kiyapwiye Jesus timapni inakni gabimankis henne, ig msekwe. Ig watihpigkis ayta git. Igkisme danuh atere, ig ayaprikis: ―Pariye yimawkan nuthu? ");
INSERT INTO plu_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Igkisme kaytwa giwn: ―Kiyapwiye, usuh muwaka usuh hiyap akiw. ");
INSERT INTO plu_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Igme Kiyapwiye Jesus amnihpigkis. Ig dax giwtyakkis, aynewa igkis hiyap. Ayteke igkis makekwepi gihapu butte. ");
INSERT INTO plu_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ayteke usuh tipikwiye akiw. Usuh kennesmin udawnhan arimkanit paytwempu Jerusalém, usuh danuh ta apitit pahá paytwempu nopsanyunen kewye Betfajé ayge apit ini waxri imuhgipitnene kewye Olipegpit. Ayge ig Kiyapwiye Jesus awahkiswiye piyana giwatnipwi adahan igkis ta sunepnes gidahan kaway. ");
INSERT INTO plu_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ig awna gitkis: ―Ataknabay apitit ini paytwempu nopsanyu pahambakaytak. Parakantenwa yis hiyá pahapu kaway “jumenta”. Ayge eg wanak payak akak gukamkayh. Wataknigkis waxwanigkis atan nuthu. ");
INSERT INTO plu_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ku hiyeg ayge awna yit: “Mmeneki yis dax?” yisme kaytwa giwnkis: “Kiyapwiye muwakaprukis. Ig ka ayipwihwa, ig diyuhkiswigkis atanewa akiwnek.” ");
INSERT INTO plu_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ini danuh henne kahadbe in kahayak ku samah Uhokri gawnepe awna minikwak. Ig awna: ");
INSERT INTO plu_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Awnanabay ta gitkis hiyeg siyawhyenepwi: ‘Sarayhnay yipegyi. Yikipara nemnik. Ig ayta yimkat. Ig ikewpi ke wotbe ig yumahbe gikiythanibe. Mmanawa ig ka kaniy kaway barewyema adahan giwewkisten henneme ig bat giduhyamadga pahapwi ku pariye pi mbaytenene ariw madikte ig nopsesnene kawayyan ig kaway ibukti gukamkayh.’ ” ");
INSERT INTO plu_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ayteke nikwe igkis giwatnipwi tipik. Igkis ihe Kiyapwiye Jesus giwn. ");
INSERT INTO plu_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Pisenwa igkis diyuhe waxe no kaway payak akak gukamkayh ta gimkanit Kiyapwiye Jesus. Igkis danuh atere, igkis amboha gidagmanpitkis ta giduhyamadgatkis. Pisenwa ig Kiyapwiye Jesus sarayhwe giduhyamadgat ner kawayyan. ");
INSERT INTO plu_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Kaayhsima hiyeg hiyapni henne, igkis awna: ―Uyay amapig kabayhtiwa. Uyay barewha ahin gapit pitati. Igkis awasaprike ahin akak gidagmanpitkis. Gaytakkisme ihuk ahamna ke kariktimnabe. Igkis awasaprike ahin nikak. ");
INSERT INTO plu_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nerras hiyeg kabubuknene gapitkig gikakkis nerras buttitwiyepwi igkis kabiman: ―Kibeyne gidahan Kiyapwiye Jesus, ig ukiparawiy hawwata ke amekene Davibe. Uhokri gabay gikaknek ner ku pariye ayta giwaprik Uhokri. Kibeyne gidahan Uhokri! ");
INSERT INTO plu_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ayteke ig Kiyapwiye Jesus parak apurit paytwempu Jerusalém. Madikte paytwempuyenepwi ayge igkis hiyapni henne, igkis wakaymnibdi. Igkis ayá: ―Pariyenekig ner hiyeg? ");
INSERT INTO plu_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Nerras hiyeg ku pariye kabubuknene ganwa igkis kaytwa giwnkis: ―Ner Uhokri gawnepe Kiyapwiye Jesus. Ig ariwntak paytwempu Nazaré ayhté Galiléyamnaw. ");
INSERT INTO plu_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ayteke ariwnteke ini ig Kiyapwiye Jesus pareke ta agikut ini leglis kewye Uhokri Gipin. Ayge ig ipukwape madikte nerras ku pariye piyuknepwi kakanhawka puwikne kuhipra gikakkis nerras ku pariye isimnepwi ayge. Ig tukuhape gaxtenkis nerras ku pariye uniyekeputnepwi karukri. Ig tukuhape gepwikis nerras ku pariye piyuknepwi tukwa. ");
INSERT INTO plu_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Pisenwa ig awna ta gitkis: ―Uhokri gannasan minikweknene awna: “Inin nupinhu in piriyepkewket.” Yisme kehne Gipin humaw amepwiyeket. ");
INSERT INTO plu_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ayteke ariwnteke ini hiyeg motapye danuh atere git ayge agiku ini leglis. Hawwata akiw hiyeg miyapupye danuh atere git. Ig hiyapni henne, ig piyihpigkis. ");
INSERT INTO plu_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Igkisme nerras muwpeg kiyatyepwi gikakkis nerras kannuhekeputnepwi amin amekene Moís gikumadukan igkis hiyapni henne, igkis ka batek. Igkis hiyá ig keh kibeyne annut. Igkis hiyá madikte bakimnay ayge ignes kabimenenes. Giwnkis: ―Kibeyne gidahan Kiyapwiye Jesus. Ig ukiparawiy hawwata ke amekene Davibe. Igkisme timapni inakni henne, igkis dagawnhewbet. ");
INSERT INTO plu_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ayge nikwe igkis awna ta git Kiyapwiye Jesus: ―Ka ba pis timá inakni giwnkis? Igme Kiyapwiye Jesus kaytwa giwnkis: ―Ihi, nah timá. Mmah yis ka ipegbohati Uhokri gannasan minikweknene ku kiney in awna: “Pis keh juktah bakimnay nopsanyopwinene bakimnay nukupisniye ignes kabayhap kabayhtiwa.” ");
INSERT INTO plu_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ayteke nikwe ig Kiyapwiye Jesus ikiswigkis. Ig pes apuritak paytwempu Jerusalém. Ig danuh ta apitit paytwempu Betâniya. Ayge ig mpiyase mtipka. ");
INSERT INTO plu_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Hewke akiw ig Kiyapwiye Jesus diyuhpiye ta arimkat paytwempu Jerusalém akiw. Ig matipwe. ");
INSERT INTO plu_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ig hiyá pahakti ah akat ayge akigbimna ahin. No ah akat kewyo “figeyra”. Ig hiyapni henne, ig atere iwasene guw. Henneme ig danuh atere yuma guwisima. Ig utí he gapannenwa. Nikwe ig awna ta gut no ah akat. Giwn: ―Pis ka takunima kew akiw. Aynewa eg huruhrup. ");
INSERT INTO plu_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Usuh gikannuhnipwi hiyapni henne, usuh wakaymnibdi kaayhsima. Usuh awna: ―Mmahki no ah akat huruhrup henne pahaye adahan? ");
INSERT INTO plu_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Igme Kiyapwiye Jesus awna wothu: ―Ku yis ayá git Uhokri akak madikte yikamaxwan, ku yis hiyak ku inyerwa in yayapni git ku in humaw, nikwe madikte yayapni git humaw yitnek. Ik adahan yis keh mpiy ku pariye nah keh gukak no ah akat. Ik adahan yis awna ta arit inin waxri imuwadnene: “Waxri, pis tipik ayteke. Su padakwa ta ahakwat parawhokwate.” Pase yis awna inakni in higihwanek ayteke. Ihanabay inakni nuwnhu. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ku yis kamaxwa ta gipitit Uhokri, madikte yayapni git humaw yitnek. ");
INSERT INTO plu_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ayteke ig Kiyapwiye Jesus tipik pareke Uhokri Gipinekut. Ku samah ig kannuhekne ayge, nerras muwpeg kiyatyepwi gikakkis judeyenepwi giwewkistenkis igkis patiptakig atere. Igkis ayapri: ―Mmahki pis keh ini ku pariye pikehni ay? Kariwntak pis utí pikumadukan adahan pis keh henne? ");
INSERT INTO plu_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Igme kaytwa giwnkis: ―Nah hawwata ayapyi pahat ayapka. Ku yis akkamnihni nuthu, nikwe nah hawwata akkamnih yit ku kariwntak nah utí nukumadukan adahan nah keh henne. ");
INSERT INTO plu_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Uyay akki nuthu. Kariwntak amekene João Batistamni utí gikumadukan adahan ig kaywa hiyeg? Ba giwntakwatma Uhokri? Ba kawk, ba he giwntakkisnenwatma hiyeg amadgayapu inin? Igkis timapni henne, igkis kinetihwa pawtak adahan ahegbetepyes ginetnikis. Ayge igkis awna: ―Ku wixwiy kaytwa giwn ku ig amekene João Batistamni utí gikumadukan giwntakwa Uhokri, nikwe ig awne wotwiy: “Mmahki nikwe yis ka iha giwn?” ");
INSERT INTO plu_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Henneme ku wixwiy kaytwa giwn ku ig utí gikumadukan he giwntakkisnen hiyeg amadgayapu inin, nikwe madikte nerras hiyeg ay hahhayruke ukakwiy. Mmanawa gitkis nerras hiyeg ig amekene João Batistamni ignewa Uhokri gawnepe. ");
INSERT INTO plu_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ayteke nikwe igkis kaytwa giwn Kiyapwiye Jesus: ―Usuh ka hiyak ku kariwntak ig utí gikumadukan. Ayge nikwe igme Kiyapwiye Jesus awna gitkis: ―Ku samah yis ka akki nuthu, nikwe nah kawnata akki ta yit ku kariwntak nah utí nukumadukan adahan nah kehne ini ku pariye nukehni ay. ");
INSERT INTO plu_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ayteke ig Kiyapwiye Jesus awna gitkis akiw. Giwn: ―Kuri numawkan yis wategbeta nuwnhu. Minikwak pahapwi awayg ig kakamkayh piyana gikebyikis. Pahay hawkri ig danuh ta git gikamkayh eggutye, ig awna git: “Nukamkayh, ku apim inin su atak kannipwi amadga uwasra.” ");
INSERT INTO plu_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Igme gikamkayh kaytwa giwn: “Nah ka atekkere.” Henneme ayteke ig ipegminene gihiyakemni, ig awna: “Ka sam. Nah atakte.” Ig tipik ta giwasraketis. ");
INSERT INTO plu_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Igme gig atak ta git gikamkayh buttitye. Ig danuh atere, ig awna git inwata yuwit. Igme gikamkayh kaytwa giwn: “Ihi, Pa. Nah atak.” Bawa ig ka atak. ");
INSERT INTO plu_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Kuri nah ayapyi. Pariyepa gaytakkis igkis piyananene gikebyikis kehe gig gibetki? Igkis judeyenepwi giwewkistenkis kaytwa giwn: ―Ner gikamkayh eggutye. Ayteke nikwe ig Kiyapwiye Jesus wategbeta inakni yuwit patuwesbuhka gidahankis. Ig awna: ―Kaayhsima hiyeg ku pariye yis ikiy kane kibeynepwima kaayhsima tinogben powkemnapyo egkis kit kawih Uhokri gikumadukan yiw. Ihanabay inakni nuwnhu. ");
INSERT INTO plu_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Mmanawa kuwis ig amekene João Batistamni danuh ta yit. Ig akki yit kibeyne ahin adahan yis danuh ta git Uhokri henneme yis ka iha giwn. Nerrasme hiyeg ku pariye yis ikiy kane kibeynepwima gukakkis norras tinogben powkemnapyo egkis ihe giwn. Hiyawa yis kuwis hiyá ku samah egkis wages guhiyakemnikis henneme yis kupiknene ka wageskere yidahan yihiyakemni adahan yis iha giwn. Yis awna: “Usuh iha giwn.” Bawa yis ka ihpin. ");
INSERT INTO plu_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ayteke ig Kiyapwiye Jesus awna pahat yuwit patuwesbuhka akiw. Ig awna: ―Ataybiswanabay. Timapnabay nawenéwa yuwit patuwesbuhka akiw. Minikwak pahapwi awayg mutuhe giwasra. Giwasra “uvapunen”. Ayteke ig kiyaraniwhe ini giwasra. Ayteke ig atikeku pahow tip nopsadminano adahan kumuktet adahan wiwhne “uva” araku. Pisenwa nikwe ig keh apuriwket imuwad. Ayteke ig ibekhe giwasra pabakak gikakkis nerras ku pariye giwasra akapriwten. Pisenwa ig tipik ta apitit nawenéwa waxri akiw. ");
INSERT INTO plu_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ku aysaw danuh apatyaprik amutri, ig awahkise gihiyegapu ta giminkis nerras akapriwten was adahan igkis iwepye gamutra guw adahan ewkwiye ta git. ");
INSERT INTO plu_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Igkisme akapriwten was igkis kamaxe gihiyegapu. Igkis bipte pahapwi. Pahapwime igkis umehe. Pahapwime akiw igkis padakte akak tip. ");
INSERT INTO plu_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ig was akipara hiyapni henne, ig awahkis gihiyegapu nawenépwi akiw atere pi kibite giwkis nerras pitatyepwi. Igkisme akapriwten keh hawwata gikakkis akiw. ");
INSERT INTO plu_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ayteke nikwe ig was akipara awahkise igwa gikamkayh ta giminkis. Ig awna: “Nawenétke ner nukamkayh igkis kiyatha.” ");
INSERT INTO plu_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Henneme nerras akapriwten was pase igkis hiyé gikamkayh ig nemnik, igkis amiyhepri. Igkis kinetihwa pawtak, igkis awna: “Nernewa was akipara gikamkayh. Uyay umehpig mpinekata kuwewanek ini was msekwe madikte gidahan. Pi kabayte wixwiy umehpig adahan was msekwe udahanwiy.” ");
INSERT INTO plu_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ayteke nikwe igkis kamaxwig igkis tukuhptepri ayteke amadgatak giwasra, igkis umehpig. ");
INSERT INTO plu_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Pisenwa gawnhan inakni yuwit patuwesbuka, ig Kiyapwiye Jesus awna gitkis: ―Kuri uyay akki nuthu. Ku aysaw ig was akipara danuh atere, pariye yipewkan ig keh gikakkis nerras akapriwten was? ");
INSERT INTO plu_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Igkisme kaytwa giwn: ―Ig umahkise nerras akapriwten giwasra awaku igkis mbeyepye gihiyakemnikis. Pisenwa nikwe ig ibakha giwasra pabakak gikakkis nawenépwiwa akapriwten akiw. Ig ikepni giwakuitkis hiyeg ku pariye iké gamutra guw ta git ku aysaw danuh apatyaprik gamutra. ");
INSERT INTO plu_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Igme Kiyapwiye Jesus awna ta gitkis: ―Mmah yis ka ipegbohati Uhokri gannasan minikweknene ku samah in kinetihwa amin inakniwata hiyakemniki? In awna: “Hiyeg kehne pahá payt tiptiye, igkis tukuhe pahow tip. Gipewkankiskam ku eggu tip ka kawihkam. Bawa eg tip eggu pi awaygtenano ariw madikte. Eg humaw adahan payt akoksa. Igwa Uhokri ikaksig henne. In kabayhtiwa wotwiy ig keh henne.” Hennewatbaki ig Uhokri gannasan awna. ");
INSERT INTO plu_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Inneki keh nah awna yit ku Uhokri gikumadukan iwepka yiwnek yis hiyeg judeyenepwi, in ikepka ta gitkis nawenépwi hiyegipiyenepwi akiw ku pariye ikewnepwi Uhokriyanbetnewa. ");
INSERT INTO plu_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Mmanawa ig Uhokri gannasan awna: “Ku pariye hiyeg teswiye ta gupitit no tip igkis tuguhe dunibdiwarumpikisnek. Egme no tip ku eg tuguhe ta gipititkis hiyeg, batewbetwarumpi igkis.” ");
INSERT INTO plu_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nerras muwpeg kiyatyepwi gikakkis nerras farisewkis igkis timapni inakni yuwit patuwesbuhka henne, igkis pukuhe ku ig awna inakni yuwit giminkis ku samah igkis tukuhptepri. ");
INSERT INTO plu_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ayge nikwe igkis mpiksaw giharit adahan gikamaxwitni. Henneme igkis apisemun gibohrikis nerras hiyeg kabubuknene ayge awaku ignes hiyeg ikiy Kiyapwiye Jesus ku ig Uhokri gawnepe. ");
INSERT INTO plu_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ayteke ig Kiyapwiye Jesus awna nawenéwa yuwit patuwesbuhka ta gitkis akiw. Ig awna: ");
INSERT INTO plu_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Nah akkite yit ku samah Uhokri gikumadukan. Ig Uhokri kewa pahapwi ikiparatbe ku pariye kehne fet adahan maripkawka gidahan gikamkayh. ");
INSERT INTO plu_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ig awahkis gibukpig tahhan watiha gawnasanpu. Igkisme gawnasanpu ka ayta fetya gikak. ");
INSERT INTO plu_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Igme ikiparat hiyapni henne, ig awahkis nawenéwa gibukpig giminkis akiw. Ig awna gitkis: “Su yi atak akkanay ta gitkis nawnasanpu ku nah kuwis ahegbete madikte axka. Nah kuwis umahkise nupighu pak. Nah kuwis umahkise pak akamkayupwi ku pariye aynengarudi. Madikte kuwis ahegbet. Wani igkis ayta ax nukakhu.” ");
INSERT INTO plu_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Igkisme gibukpig atere uteprikis. Igkis akki gitkis inakni gikiparakis giwn. Igkisme gawnasanpu ka aminama giwkis. Igkis tipik kannipwiyekwiye. Pahapwi tipik ta giwasrakat, pahapwime tipik kannipwiye piyukket. ");
INSERT INTO plu_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Igkisme gasemnekis kamaxe gibukpig. Igkis arewhe gitkis. Igkis umehpigkis. ");
INSERT INTO plu_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ayteke ig ner ikiparat hiyapni henne, ig dagawne. Nikwe ig awahkise gisuwtatapu giminkis nerras umehekeputnepwi. Ignesme umahapeprikis, igkis bukahape gipinkis. ");
INSERT INTO plu_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ayteke nikwe ig ikiparat awna ta gitkis gibukpig: “Fet kuwis ahegbet henneme nawnasanpu ka kis adahan igkis ax nukakhu. ");
INSERT INTO plu_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Su yi atak wew ta apigkut madikte ahin nopsad. Ayge yis awnase madikte hiyeg ku pariye yiwitwan ayge adahan ignes fetya nukakhu.” ");
INSERT INTO plu_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Igkisme gibukpig ihe giwn. Igkis tipik atere apigkute ahin. Igkis pahadguhape madikte hiyeg ku pariye giwitwankis ayge, hiyeg ku pariye ikaka kane kibeynepwima payebitak gikakkis kiyeg ku pariye ikakka kibeynepwi. Ayge nikwe fet apin kipun akak hiyeg. ");
INSERT INTO plu_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","―Ayteke nikwe gipin kipun kuwis, ig ner ikiparat pareke atere adahan iwasepye gawnasanpu. Ayge ig hiyá pahapwi awayg ku pariye ka amapa ini simis barewbetye adahan ig kawihni abet maripkawka. ");
INSERT INTO plu_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ig hiyapni henne, ig ayapri: “Nukagmada, pis yuma pisimsa barewbetye adahan pis fetya adahan maripkawka. Mmah piperekepni atan?” Igme ner awayg ig ka ik adahan ig kaytwa pahatnama yuwit. ");
INSERT INTO plu_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Nikwe ner ikiparat awna ta gitkis gibukpig. Ig awna: “Asá wanakminanay giwan payak akak gibagwan. Ayteke yis padekwig ta kabaywakat ta abetit amisnapyad. Ayge hiyeg tihebdi ignes kagah gaybukis.” ");
INSERT INTO plu_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Mmanawa ig Uhokri awnasa kaayhsima hiyeg adahan ignes danuh ta git henneme ig kaniy ka kiyesradima adahan ignes msakwa ay gimun. Hennewatbaki ig Kiyapwiye Jesus awna. ");
INSERT INTO plu_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ayteke ariwnteke ini igkis farisewkis tipik ahegbete ginetnikis adahan igkis hiyá ba igkis keh Kiyapwiye Jesus awna yuwit taraksebetnama adahan igkis gimetkepten. ");
INSERT INTO plu_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ayteke nikwe igkis awahkise gikannuhnipwi payak gikakkis amekene Erodis gihiyegapu gimin Kiyapwiye Jesus. Igkisme danuh atere, igkis awna git: ―Kiyapwiye, usuh hiyak ku pis waditye hiyeg. Pis ka awna mpusema yuwit gidahankis hiyeg. Pis awna pahatwowa yuwit gitkis madikte hiyeg. Hiyawa hiyeg gihiyakemnikis nawenéwa ariw pidahan, henneme in ka sam ta pit. Pis awna pahatwowa yuwit. Pis akki Uhokriyerwa gihiyakemni gitkis. ");
INSERT INTO plu_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ayge nikwe usuh muwaka hiyak pahat hiyakemniki. Uyá akki wothu. Ig kiyapwiye Sésar nerras romayenepwi gikiparakis ig mpiksaptih wixwiy judeyenepwi adahan wixwiy katiwnihgi. Ba wadit adahan wixwiy katiwnihgi? Ba ka wadit? ");
INSERT INTO plu_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Igme Kiyapwiye Jesus hiyak ku gihiyakemnikis mbeyepye igkis awna inakni adahan gikinsepten. Ig hiyapni henne, ig kaytwa giwnkis: ―Yis ikawnamah ke wotbe yis kibeynepwibe hiyegbe bawa yis pi mbayte giwkis nawenépwi hiyeg! Mmahki yis ayta nuhikekten henne? ");
INSERT INTO plu_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Akkanay nuthu pahamku karukri ku pariye wis kawih adahan katiwnih kiyapwiye Sésar. Igkisme timapni henne, igkis iwé pahamku karukri igkis ewkwig ta git. ");
INSERT INTO plu_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ayteke nikwe ig ayaprikis: ―Pariyepa kahehpakye gumadga no kirehka? Pariyepa kewye ay gumadga? ");
INSERT INTO plu_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Igkisme kaytwa giwn: ―Inin kiyapwiye Sésar giw. Inin ahehpakti kiyapwiye Sésar gahehpak. Igme kaytwa giwnkis: ―Nikwe no karukri kawih gidahan kiyapwiye Sésar. Hiyawa wixwiy ikepru git. Henneme amawka ku wixwiy ikí ta git Uhokri madikte ku pariye kawih gidahan Uhokri. ");
INSERT INTO plu_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Igkis timapni inakni giwn henne, igkis wakaymnibdi kaayhsima. Ayteke nikwe igkis maytepri. Igkis tipik. ");
INSERT INTO plu_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Apiminewa ini nawenépwi hiyeg danuh atere git Kiyapwiye Jesus akiw. Igkis sadusewkis. Gitkis sadusewkis hiyeg miyá ignes pisenwe gihawkankis igkis ka kannikaw akiw. ");
INSERT INTO plu_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Igkis danuh atere, igkis awna git: ―Kiyapwiye, amekene Moís awna: “Ku pahapwi hiyeg miyá guw gihayo, ku ig yuma gikamkayh gukak eggu gihayo, amawka gikebyi maripkaw gukak eggu giwgun marihwa eg kakamkayh hawwata ke wotbe ignebe gikebyibe kakamkayh gukakbe.” Hennewatbaki ig amekene Moís gikumadukan awna. ");
INSERT INTO plu_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Boh. Minikwak ntewnehker gikebyikis ay ukakhu. Ig eggutye maripkew gukak pahapu tino. Ayteke ig miyap kawke ig kakamkayh gukak. Ig ikise gihayo ay giwaku gisamwi. ");
INSERT INTO plu_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ayteke nikwe ig gisamwi gipun maripkew gukak eggu giwgun. Ig hawwata ig miyap guw. Ig kawnata kakamkayh gukak. Ayteke nikwe ig gisamwikis gimamnamkis ig hawwata ig maripkew gukakwata akiw. Henne madikte nerras ntewnehkernene gikebyikis miyarapwata. ");
INSERT INTO plu_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Pisenwa egme hawwata eg miyop. ");
INSERT INTO plu_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kuri, Kiyapwiye, usuh ayapi. Aysawnemenek apim ini ku aysaw hiyeg kannikaw ariw gimiremnikis, pariyepahki gibetitakkis nerras ntewnehkernene gikebyikis darihgu? Mmanawa igkis madikte maripkewnekwiye gukak. ");
INSERT INTO plu_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Igme Kiyapwiye Jesus kaytwa giwnkis: ―Yis tarakse mmanawa yis ka pukuhpa Uhokri gannasan minikweknene iné yis kawnata hiyak ku samah Uhokri gidatni. ");
INSERT INTO plu_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Aysawnemenek apim ini ku aysaw hiyeg kannikawbet ariw gimiremnikis, ayge ignes ka maripkaw akiw. Igkis msakwa hennep ke ahjbe. ");
INSERT INTO plu_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Kuri uyay kinetihwa amin wixwiy hiyá ba hiyeg kannikaw ariw gimiremnikis. Mmah yis kote ipegbohate ku pariye Uhokri awna ta yit? ");
INSERT INTO plu_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ig awna: “Nahnewa kuri Abrawh giwohkiga, nahnewa kuri Izaki giwohkiga, nahnewa kuri Jakó giwohkiga.” Inakni yuwit akki wot ku igkis gidukweneswa igkis ipeg. Ig Uhokri kawki miyarapyema giwohkigakisma. Ig hiyeg ipegnene giwohkigakis. ");
INSERT INTO plu_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nerras hiyeg kabubuknene ayge igkis timapni inakni yuwit henne, igkis wakaymnibdi kaayhsima. ");
INSERT INTO plu_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ayteke nerras farisewkis timé Kiyapwiye Jesus gak ku ig mateke nerras sadusewkis akak giwn. Igkis timapni henne, igkis pahadguhwe atere git. ");
INSERT INTO plu_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ayge pahapwi gaytakkis, ig kannuhekeputne amin amekene Moís gikumadukan, ig ayapri pahat ayapka adahan gihikekten. ");
INSERT INTO plu_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Ig awna: ―Kiyapwiye, pariyepa Uhokri gikumadukan pi kabayte ariw madikte kumadukaki? ");
INSERT INTO plu_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Igme Kiyapwiye Jesus kaytwa giwn: ―Nah akkite yit ku pariye gikumadukan pi kabaytenene. “Batek gikak Kiyapwiye Uhokri akak madikte piyakni. Batek gikak akak madikte pibetki. Batek gikak abet madikte pihiyakemni.” ");
INSERT INTO plu_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Inakni gikumadukan pi kiyatte pi kabayte ariw madikte kumadukaki. ");
INSERT INTO plu_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ayteke ariwnteknewa inakni yuwit ay pahat gikumadukan akiw ku pariye pi kabayte ariw madikte kumadukaki. “Batek gikakkis piyakipwi hiyeg hawwata ku samah pis batek akak pipit.” ");
INSERT INTO plu_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mmanawa inakni pitenemnene gikumadukan huwase amekene Moís gikumadukan akak Uhokri gawnepepu giwnkis madikte. ");
INSERT INTO plu_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ku samah igkis farisewkis pahadgupu ayge, ig Kiyapwiye Jesus ayaprikis: ");
INSERT INTO plu_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","―Mmahki yipewkan gimin Cristo, ig Uhokri gikanyan adahan ukumaduketniwiy? Pariyeki gihawkri? Igkisme kaytwa giwn: ―Ig Cristo ig kahawkriye amekene Davi. ");
INSERT INTO plu_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Igme Kiyapwiye Jesus ayaprikis: ―Henneme igwa amekene Davi kanumri “nukipara”. Inakni yuwit ikepka git gapit Uhokri Gitip minikwak. Apim ini ig awna: ");
INSERT INTO plu_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Ukiparawiy Uhokri awna ta git nukipara Cristo. Giwn: ‘Batnaba ay nuhumwa kihehaptak amun inin iwetrit kiyatye ku samah nah sibuhkisnete pipetunyapu pit.’ ” ");
INSERT INTO plu_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ka ba yis hiyá igwa amekene Davi ka kanum Cristo “nuhiwhi”? Ig kanumri “nukipara”. Ig Cristo ka he gihiwhinenwatma. Ig hawwata ig gikipara. ");
INSERT INTO plu_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nerras hiyeg timepnepwi ayge igkis ka hiyá adiyasak ginetni aynesnima. Ariwntak ini igkis ka kibowka ayapri akiw. ");
INSERT INTO plu_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ayteke ig Kiyapwiye Jesus kinetihwa akiw gitkis nerras hiyeg pahabunene gikakkis gikannuhnipwi. Ig awna gitkis: ");
INSERT INTO plu_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Nerras kannuhekeputnepwi amin amekene Moís gikumadukan gikakkis nerras farisewkis igkis kadahan gikumadukankis adahan akkamnih yit amekene Moís gikumadukan. ");
INSERT INTO plu_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ayge nikwe amawka yis ihpa giwnkis. Amawka yis keh ku samah igkis awna yit adahan ku pariye amawka yis keh. Henneme ka ba yi ahehpa gikehnikis. Mmanawa igkis ekkenes amekene Moís gikumadukan henneme igkis ka keh ku samah in awna. ");
INSERT INTO plu_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Igkis mpiksaptih hiyeg adahan ignes iha kumadukaki ku pariye mahikonene adahan ignes iha, igkisme ka ihpin aynesnima. Igkis ikaw ke pahapwibe ku pariye mpiksaptih gikebyi adahan ig hiyuh awiyka giduhyamadga henneme igwa ka hiyuhkere ini awiyka, iné ig ka daxkere akak pahatnama giwak. ");
INSERT INTO plu_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Madikte kabayka ku pariye igkis keh igkis kehpin adahan igkis hiyapka gapitkis hiyeg adahan igkis ikaka ku igkis kibeynepwi hiyeg. Igkis tamak kaayhsima yuwit ariwntak Uhokri giwn amadga kagta igkis wanakni ay giwanminkis ay gidepakis adahan arekhetni ku igkis ka miyeh Uhokri gihiyakemni. Bawa waditnepyenen. Igkis kawihni he arekhetninen ku igkis kibeyne hiyeg. Hawwata akiw igkis ba gibetkatunkis wewnamahkis agiku gibereswetnikis. ");
INSERT INTO plu_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Hawwata igkis batek bat amadga epti kiyatyo abet fet. Hawwata igkis batek bat amadga epti ku pariye pi kiyattenene agiku leglis. ");
INSERT INTO plu_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Hawwata igkis batek hiyeg aytnihgikis higiwmadga akak kiyathaki. Gitkis ka kis adahan hiyeg kanumrikis giwaprikkis. Igkis pi batekte hiyeg kanumrikis “kiyapwiye nukannuhten”. ");
INSERT INTO plu_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Yisme amawka yis ka kanumkiswa ku yis hiyeg gikannuhtenkis ke wotbe yis gapitminkisbe. Mmanawa wixwiy madikte hehpekwiye ukiythaniwiy ke wotbe wixwiyweke pakebyeknebe. Wixwiy kadahan pahapwiwa ukannuhtenwiy. Ig ayhté inugik. ");
INSERT INTO plu_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Iné ka yi muwaka kighaw git pahapwinama hiyeg amadgaya inin adahan yis kanumri “nighu” mmanawa wixwiy madikte pahapwiwa Wigwiy inugikyene. ");
INSERT INTO plu_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Iné ka yi muwaka kanumkiswa ku yis hiyeg giwewkistenkis. Mmanawa wixwiy madikte pahapwiwa uwewkistenwiy. Ignewa Cristo ku pariye Uhokri gikanyan adahan ukumaduketniwiy. ");
INSERT INTO plu_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ku pariye yaytak yapitmin madikte amawka ku ig ka kabukhaw yit. Amawka ku ig ikaw ke wotbe ig yibukbe. ");
INSERT INTO plu_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ku pahapwi ikewkere pi kiyatte mpiye pahapwi, iggi Uhokri wiwhe gikiythani gipititaknek. Henneme ku pahapwi ikewpiye ke wotbe ig yumahbe gikiythanibe, iggi Uhokri ikí gikiythani ta gipititnek. ");
INSERT INTO plu_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","―Akayih. Aysawnemenek yis kannuhekeputnepwi amin amekene Moís gikumadukan yis farisewkis, yis hiyá mbeyne kaayhsimanek. Yis ikewne ke wotbe yis kibeynepwibe hiyeg bawa yis pi mbayte giwkis nawenépwi hiyeg. Yis kannuhwa gimin Uhokri giwn, yis ik adahan yis wokase Uhokri gikumadukan ta gitkis hiyeg henneme yis sabukwin giwkis. Yis ka ihpin iné yis ka isaksa nawenépwima hiyeg adahan ignes ihpin. ");
INSERT INTO plu_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","―Akayih. Yis kannuhekeputnepwi amin amekene Moís gikumadukan yis farisewkis, aysawnemenek yis hiyá mbeyne kaayhsimanek. Yis ikewnepwi ke wotbe yis kibeynepwibe hiyeg bawa yis pi mbayte giwkis nawenépwi hiyeg. Yis wiwh madankunopwi gupinkis guwkis payak akak gewkanbetkis henneme yis piriyepkaw kiyabawkad marihwa hiyeg ikiyyi ku yis kibeynepwi hiyeg. Aysawnemenek Uhokri hiyapkis mbeyne kaayhsima yitnek apatra ini yihiyakemni. Apim ini yis pi hiyapte mbeyne ariw nawenépwi hiyeg taraksapye. ");
INSERT INTO plu_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","―Akayih. Yis kannuhekeputnepwi amin amekene Moís gikumadukan yis farisewkis, aysawnemenek yis hiyá mbeyne kaayhsimanek. Yis ikewne ke wotbe yis kibeynepwibe hiyeg bawa yis pi mbayte giwkis nawenépwi hiyeg. Yis keh yiwewpan muwwapu ahakwew parawhokwa amadga wayk adahan yis yipewkan wages hiyeg gidahan Uhokri. Henneme ku aysaw yis utí pahapwi yis wages gihiyakemni pi mbayte ariw yidahan yihiyakemni juktah ig humaw ke wapityeyanbe mapiy yis pimaput akiw. ");
INSERT INTO plu_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","―Akayih. Yis hiyapkiska mbeyne yit kaayhsimanek apatra ku samah yis ikewne hiyeg gihuwtentenkis bawa yis motapye abet yihiyakemni awaku yis he aharitnenen gikakurakis. Nah akkite yit ku samah. Yis awna: “Ku pahapwi kanum Uhokri Gipin gitemwera ku giwn ka kiniskama, wis ka hiyá ba inyerwatma git.” Henneme ku pahapwi kakanhaw karukri wahano adahan Uhokri Gipin, ku ig kanum no karukri wahano gitemwera, nikwe ini arekhetni ku hennewa ig ka kinis.” ");
INSERT INTO plu_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Yis madikte motapye abet yihiyakemni. Yis ka hiyak hawkri aynesnima. Ka ba yis hiyá ku Uhokri Gipin pi kiyatte ariw no karukri wahano agikunano Gipin? Innewa Gipin ikene akiythani arit no karukri wahano. ");
INSERT INTO plu_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Hawwata yis awna: “Ku pahapwi kanum ini kakanhawket gidahan Uhokri in gitemwera ku giwn ka kiniskama, wis ka hiyak ba inyerwatma git. Henneme ku pahapwi kakanhaw puwikne ta git Uhokri amadga ini kakanhewket ku ig kanum ini gikan gitemwera, nikwe ini arekhetni ku hennewa ig ka kinis.” ");
INSERT INTO plu_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Yis madikte motapye abet yihiyakemni. Mmahkay yis pi kiyathate hiyeg gikankis mapiy ini kakanhawket gidahan Uhokri ku pariye ikene akiythani arit gikankis? ");
INSERT INTO plu_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ku pahapwi kanum ini kakanhawket gitemwera nikwe pugamawka hennewa ig ka kinis. Mmanawa amun ini, in kakanhawket humaw gitemwera payak akak madikte ku pariye ay nimadga. ");
INSERT INTO plu_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Hawwata akiw, ku pahapwi kanum Uhokri Gipin gitemwera nikwe pugamawka hennewa ig ka kinis. Mmanawa amun ini, ig Uhokri Gipin humaw gitemwera payak gikak Uhokri ku pariye kapinene ayge. ");
INSERT INTO plu_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Hawwata akiw, ku pahapwi kanum inugik gitemwera nikwe pugamawka hennewa ig ka kinis. Mmanawa amun ini, in Uhokri giwetri humaw gitemwera payak gikak Uhokri ku pariye aygnene. ");
INSERT INTO plu_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","―Akayih. Yis kannuhekeputnepwi amin amekene Moís gikumadukan, yis farisewkis, aysawnemenek yis hiyá mbeyne kaayhsimanek. Yis ikewne ke wotbe yis kibeynepwibe hiyeg bawa yis pi mbayte giwkis nawenépwi hiyeg. Yis keh ofan gidahan Uhokri ariwntak madikte yamutra juktah madikte nopsanyupwinene yamutrebdi. Yis wiwh pahakti ariwntak mpuse gaytakkis madikawku adahan yis kakanhaw git Uhokri. In kabay, henneme yis ka iha nawenéwatma Uhokri gikumadukan ku pariye pi kabaytenene. Yis ka keh wadit gikakkis yiyakipwi hiyeg. Yis yumahwa amnihka ay apit yiyakni. Yis yumahwa yikamaxwan gipitit Uhokri. In kabay yis keh ofan gidahan Uhokri henneme kiskama yis wew akak inakni gihiyakemni madikte. ");
INSERT INTO plu_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Yis ikewne hiyeg gihuwtentenkis bawa yis motapye abet yihiyakemni. Yis kewa pahapwi awaygbe ku pariye hiyá pahapwi yu nopsehsa ay ahakwa gihigpan ig wiwhpin akak madikte gasana. Henneme ig ka aminama ariw pahapwi puwiknad “kamelu” aygwata ahakwa gihigpan. Ig dakerepri pahapwite. Hennewatbaki yis. Mmanawa yis ka aminama ariw yitaraksan ku pariye pi mbaytenene. ");
INSERT INTO plu_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","―Akayih. Yis kannuhekeputnepwi amin amekene Moís gikumadukan yis farisewkis, aysawnemenek yis hiyá mbeyne kaayhsimanek. Yis ikewne ke wotbe yis kibeynepwibe hiyeg bawa yis pi mbayte giwkis nawenépwi hiyeg. Yis barewagikape yigobla akak yimewkan adahan in barewagikape giwtrik Uhokri. Ayteke yis kipunsin akak ariknebdi ku pariye yamepwi ku pariye yimirihwan. ");
INSERT INTO plu_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Yis farisewkis yis motapye abet yihiyakemni. Amawka pitatye yis wiwh ini patahwaki arikutak yigobla amadgatak yimewkan. Ku yis wiwhpin madikte ayteke, ayge nikwe in barewagikape giwtrik Uhokri. ");
INSERT INTO plu_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","―Akayih. Yis kannuhekeputnepwi amin amekene Moís gikumadukan yis farisewkis, aysawnemenek yis hiyá mbeyne kaayhsimanek. Yis ikewne ke wotbe yis kibeynepwibe hiyeg bawa yis pi mbayte giwkis nawenépwi hiyeg. Yis kewa imewtibe ku pariye tamakka seyne. In barewye awkinenwa nipitiw henneme miykahriki ayge agiku. ");
INSERT INTO plu_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Yis ikewne ke wotbe yis kibeynepwibe ta gitkis hiyeg bawa ay apit yiyakni yis kipun akak kiniska akak patahwaki. ");
INSERT INTO plu_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","―Akayih. Yis kannuhekeputnepwi amin amekene Moís gikumadukan yis farisewkis, aysawnemenek yis hiyá mbeyne kaayhsimanek. Yis ikewne ke wotbe yis kibeynepwibe hiyeg bawa yis pi mbayte giwkis nawenépwi hiyeg. Yis keh barewye payt adahan gimewkis Uhokri gawnepepu pitatyepwi, yis barewha gimewkis hiyeg kibeynepwi. ");
INSERT INTO plu_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Yis awna: “Waké usuh aybe minikwak ku samah wahawkripwi aynete amadga hawkri, usuh ka kehkam ku samah gikehnikis, usuh ka umahkam Uhokri gawnepepu.” ");
INSERT INTO plu_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Bawa nuthu ku samah yis awna inakni, yis ekkewne ku yis gihiwhipwikis nerras ku pariye umahape Uhokri gawnepepu. Yis humaw hawwata giwetniswata. ");
INSERT INTO plu_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kuri hiyawa yisme senwape ini mbayka ku pariye yahawkripwi gikehnikis. ");
INSERT INTO plu_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Yis kaybunyune hiyeg pahaywitniyepwi hawwata ke yahawkripwibe! Yis ikaksaka adahanikwa ini iwetrit ku kiney kaneayhsima kayahwaki. Yuma ariknawnama hiyá yimaptanka ariw ini mbeyne. ");
INSERT INTO plu_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Aysawnemenek nah awahkis yimin nawenépwi nawnepepu nah awahkis yimin hiyeg hiyakemniyepwi nah awahkis yimin kannuhekeputnepwi amin Uhokri gihiyakemni. Gaytakkis yis umehpigkisnek. Gaytakkisme yis deddehpigkisnek aminat ah. Gaytakkisme akiw yis bipteprikisnek akak tigay ay agiku yileglisa, yis haraksapeprikis apititak pahá paytwempu ta apitit nawenéwa paytwempu akiw. ");
INSERT INTO plu_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Nikwe ig Uhokri diyuhkis gimigkis ta yipititnek. Ig diyuhkis gimigkis madikte hiyeg kibeynepwi ku pariye umehpika amadga inin. Ig diyuhkis ta yipititnek gimigkis madikte gawnepepu giwenketeke amekene Abew gimig he danuhe git amekene Zakaríyas gimig. Ig amekene Zakaríyas iggi ner amekene Barakíyas gikamkayh ku pariye umehpika ayegbi Uhokri Gipin akak kakanhawket. ");
INSERT INTO plu_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Hennewa ig diyuhkis gimigkis ta yipititwa yis ku pariye amedgenepwi hawkri ku akak inin. Ihanabay nuwnhu. Hennewatbaki ku samah nah awna yit. ");
INSERT INTO plu_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ayteke ig Kiyapwiye Jesus awna akiw. Giwn: ―Aa, yis jerusalémyenepwi, yis jerusalémyenepwi, yis umahape Uhokri gawnepepu. Yis padakte madikte hiyeg ku pariye Uhokri gawahkisni yimin. Bawa kaayhsima hawkri nah muwaka kapigsay ke pahapu takarakbe awahpusano gukamkayh anapi guhanpi, hiyaksa yisme ka muwaka henne. ");
INSERT INTO plu_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Aysawnemenek yiwetri msekwe inworenek. Uhokri ka apuriwni akiw. ");
INSERT INTO plu_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Yis ka takunima hiyapun akiw juktah ku aysawnemenek metakwa yis ahegbet adahan amapan, yis awna nuthu: “Kibeyne pis danuh. Pis ayta giwntakwa Uhokri.” Ihanabay inakni nuwnhu. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Pisenwa inakni gawnhan, ig Kiyapwiye Jesus tipikwiye adahan gipeswen ayteke agikutak Uhokri Gipin. Ig pesante, usuh gikannuhnipwi pahadguhwe ta gihumwat. Usuh kapusa kinetihwa pawtak amin ini leglis Uhokri Gipin ku samah in barewyewa paytwempu. ");
INSERT INTO plu_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Igme Kiyapwiye Jesus timapni henne, ig awna wothu: ―Mmah yis hiyá ini paytwempu? Aysawnemenek yis hiyapni madikte mehpikanek. In hirohe madikte waygboitenek. Iné pahow tip ka msakwanek papitmintak akak guyaki tip akiw. Ihanabay inakni nuwnhu. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ayteke ig tipik ig danuh atere apitit ini waxri imuhgipitnene Olipegpit. Ayge ig batahkiswe asebha. Ayteke usuh gikannuhnipwi danuh atere git usuhwo. Usuh awna git: ―Kiyapwiye, uyá akki wothu ku pariye nemnikumpiye amadga inin. Kabetpahki inere Uhokri Gipin mehpikanek? Pariye danuh adahan arekhetni ku aysaw ahawkanaprik danuh adahan pidawnhan adahan ukumaduketni? Pariye danuh adahan arekhetni amaksemni hawkri? ");
INSERT INTO plu_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Igme Kiyapwiye Jesus kaytwa wownhu akak kiyabawkad yuwit. Ig awna ta wothu: ―Ka yi muwaka kinikiswa ta gitkis hiyeg. ");
INSERT INTO plu_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Mmanawa aysawnemenek kaayhsima hiyeg kahayaknek nuwaprik ke wotbe igkis ayta nuwntakbe. Igkis awnanek: “Nahnewa Cristo, nah Uhokri gikanyan adahan yikumaduketni.” Apim ini igkis kinisnes hiyeg kaayhsimanek. ");
INSERT INTO plu_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ayge apim ini yis timá kutimniki kennesa. Hawwata yis timá arak kutimniki piyawakad. Henneme ka yi muwaka wadisasaw. Amawka ku ini kutimniki danuh henneme kote danuhte amaksemni hawkri. ");
INSERT INTO plu_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Mmanawa aysawnemenek pahabunene hiyegipiyenepwi kerbetpikisnek gikakkis nawenéwa hiyegipiyenepwi akiw. Gupelma kerbetpikis igkisweke gupelma. Apim inin hawkri kaayhsima mihetniki danuh muwwapunek. Hawwata kaayhsima sagkaki muwwapu waxribdiw. ");
INSERT INTO plu_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Henneme ininewa akapuska mbeyne. In ke pahapu tinobe ku aysaw eg kapusa kayah gukamkayh adahan eg pamakutekwiyo. In he akapuskanen. ");
INSERT INTO plu_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","―Apim ini yis kamaxwikanek yis iwepkanek adahan yis hiyapkiska mbeyne yitnek. Hawwata yis umehpikanek. Ayge madikte hiyegipiyenepwi amiyhepyi awaku ku samah yis nuhiyegapu. ");
INSERT INTO plu_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Apim ini kaayhsima hiyeg isahkiswe giw Uhokrinek. Igkis kamaykisak pawtak. Igkis amiyhak pawtak. ");
INSERT INTO plu_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ayge nikwe kaayhsima hiyeg kahayaknek ku pariye ikawnamahkis Uhokri gawnepepu. Bawa igkis ka giwntakwatma Uhokri. Henneme igkis kinis kaayhsima hiyegnek. ");
INSERT INTO plu_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Apim ini mbeyepye mbayka wagehnene arimkat pi mbaytenene akiw. In keh kabá madikte hiyeg ka amnihak akiw. ");
INSERT INTO plu_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ka sam. Ku yis ka isahkiswa nuwhu juktah amaksemni hawkri, yis isamtawnek. ");
INSERT INTO plu_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Aysawnemenek ini kibeyne inetit amin Uhokri gikumadukan in ekkepka gipuriwkis madikte hiyeg amadgayapu inin, kahadbe madikte hiyegipiyenepwi timapni. Ayteke ariwnteke ini amaksemni hawkri danuhnek. ");
INSERT INTO plu_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","―Aysawnemenek hiyeg amedgenepwi inin igkis hiyá ini ku pariye Uhokri gawnepe amekene Daniel kinetihwa nimin. Igkis hiyanek pahapwi aseneweknepye umehekeputne, ig tabirnene ay agiku Uhokri giwetri. Yis ku pariye ipegbohepye inakni yuwit, ku aysaw in kahayaknek metakwa yis pukuhpinnek. ");
INSERT INTO plu_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Pase hiyeg hiyá in danuh amawka igkis tipik kibentenwa. Amawka ku pariye msekwenepwi ay Judeyamnaw amawka igkis bisike ta ahaprikute apuheku ini waxribdi. ");
INSERT INTO plu_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ku pahapwi ay gipin higiwmadga, ig ka muwaka diyuh ta gipinekut adahan iwepye gewkanbet adahan ig bisikwiye. ");
INSERT INTO plu_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ku pahapwi ayhté amadga giwasra, ig kawnata muwaka diyuh ta gipinwat adahan iwepye gikawihni adahan bisikwiye. ");
INSERT INTO plu_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Akayih. Kaayhsima mahikoriki apim ini hawkri gudahankis tinogben ku pariye biyuhkisnopwi gudahankis tinogben ku pariye sukkisanyopwi. Kaayhsima mahiko adahan egkis bisik. ");
INSERT INTO plu_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Piriyepkawnay adahan in ka danuh yit abetma kamukrima iné abetma samdi. ");
INSERT INTO plu_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Mmanawa apim ini hawkri yis hiyá mbeyne kaayhsimanek. Ku samah akapuska hawkri yumahte mbeyne kema inima. Ariwntak ini akiw, yuma mbeyne akiw kema inima. ");
INSERT INTO plu_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Waké Uhokri ka matkuh ini hawkri, yumakam pahapwinama bisikne ariw miyaka. Henneme kibeyne, ig matkuh ini hawkri gidahankis gihiyegapu gikanyanpu. ");
INSERT INTO plu_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","―Apim ini gaytakkis hiyeg awnanek: “Kuwis Cristo ay kuwis.” Gaytakkisme awnanek: “Ig ayhtéhan nawenéwa paytwempu.” Ku pahapwi awna yit inakni henne, ka yi muwaka iha giwn. ");
INSERT INTO plu_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Mmanawa apim ini kinisekeputnepwi kahayaknek. Gaytakkis awnanek: “Nahnewa Cristo.” Bawa waditnepyenen. Gaytakkisme ikawnamah Uhokri gawnepepu bawa ignes ka giwntakma Uhokri. Igkis keh kaayhsima annut ku pariye keh hiyeg wakaymni ke wotbe in arekhetnibe Uhokri gidatni. Akak ini annut igkis hiyá ba igkis hiyá gikinsakkis Uhokri gikanyanpu. ");
INSERT INTO plu_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","―Kuri nah kuwis akkamnih yit madikte ku pariye nemnikumpiye. ");
INSERT INTO plu_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ayge nikwe ku hiyeg awna ta yit: “Ig ayhté amadga amatap,” ka ba yi iha inakni giwnkis. Ka ba yi ipegpan atere. Ku hiyeg awna ta yit: “Ig ay agiku xam,” kawnata ba yi iha giwnkis. ");
INSERT INTO plu_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ku aysaw nah ku pariye wageswe awayg amadgaya inin ku aysaw nah ayta, in naytni kahayak yit kabayhtiwanek. In kahayak kabayhtiwa ke ugugunebe ku pariye hamahwa muwwapu wahamarapriktak juktah in danuh upitkiyapriktak. ");
INSERT INTO plu_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ku kiney wis hiyá isuw ugewwé, wis hiyakni kuwis ku arikna miyapwiye ayge. Hawwata naytninek yis hiyapni huwewehe. Apim ini metakwa yis hiyakninek. ");
INSERT INTO plu_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","―Aynewa ariwnteke ini mbeye hawkri, kamuw msanpinek, kayg ka kabutni akiwnek, warukma akak warapyu tuguhenek inugiktak. Madikte agikunene hawkri, apim ini in ayguhwebdinek ariw niwetri. ");
INSERT INTO plu_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ayteke nikwe pahat arakak ndahan, nah ku pariye wageswe awayg amadgaya inin, in kahayaknek ayhté inugik. Madikte hiyegipiyenepwi amadga inin ignes hiyapni henne, igkis kayah gitaraksankis igkis tihenesnek. Ayteke igkis hiyapunnek, nah ku pariye wageswe awayg amadgaya inin. Nah ayta abetimpi ukuhne inugikyene akak madikte ndatni akak madikte nukiythani kabutennene. ");
INSERT INTO plu_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ayteke nah agighase tohompet. Akak ini nah awahkisnek nuhiyegapu ahj ayta pahadguhpiye Uhokri gikanyanpu muwwapu amadgatak hawkri. Igkis pahadguhpigkisnek ariwntak wahamatak, ariwntak tiwgiktak, ariwntak imekaptak, ariwntak upitkiyapriktak, juktah danuhe amaksemni waxri. ");
INSERT INTO plu_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","―Ipegnay ta gumkat no ah akat “figeyra”. Kannuhwanay gut. Ku aysaw gutawna imihwa akiw, ku aysaw eg kapanhaw akiw, wis hiyakni ku guhawkanaprik kennesa danuh nikwe adahan eg kew. ");
INSERT INTO plu_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Hawwata aysawnemenek ku aysaw yis hiyá madikte ini mbeyne danuh, metakwa yis hiyakni kuri ku nuhawkanaprik kennesa danuh kuwis. Nah kennesawa ndawnhan ke wotbe nah kuwis anumeku parekketbe. ");
INSERT INTO plu_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Hiyeg ku pariye amedgenepwi inin apim ini hawkri, apit ignes madikte miyarap ayipa inakni madikte danuh gitkisnek ku samah nuwnhu. Ihanabay inakni nuwnhu. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","En biyuke, waxri biyuke henneme nuwnhu ka biyuk. ");
INSERT INTO plu_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","―Henneme nah danuh pahaye adahan. Yuma hiyeg ahiyekten ku kapim nah diyuh. Iné ahj inugikyenepwi ka hiyak. Iné nahwa Uhokri gikamkayh nah kawnata hiyak. Ignewa Wigwiy hiyak. ");
INSERT INTO plu_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nah ku pariye wageswe awayg amadgaya inin, ku aysaw nah danuh atan akiw, hiyeg gihiyakemnikis hawwata ke hiyeg gihiyakemnikisbe minikwakbe ku kapim amekene Noé amadga inin. ");
INSERT INTO plu_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Mmanawa apim ini hawkri apit un digisase waxri ignes ka aminama giw Uhokri. Igkis axnes, higepnes, maripkewnes, ku samah inpawa gikehnikis juktah ku aysaw ini hawkri danuh adahan ig amekene Noé katapta ta amadgat ginawya. ");
INSERT INTO plu_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Igkis ka pukuhpawnama aynesnima apit ku pariye me danuhmet juktah un digisase waxri in aniksaseprikis madikte. Ndawnhan henne, nah ku pariye wageswe awayg amadgaya inin. ");
INSERT INTO plu_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Apim ini hawkri ndawnhan piyana gikebyikis awaykemni ay amadga giwasrakis. Pahapwi iwepka, pahapwime ikiswika. ");
INSERT INTO plu_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Hawwata akiw piyana gukebyikis tinogben kukwanos payak. Pahapu iwepka, pahapume ikiswika. ");
INSERT INTO plu_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Pukuhpawnabay nikwe. Mmanawa yis ka hiyaknima ku kabet nah yikipara danuh. ");
INSERT INTO plu_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Msakwanabay ahegbet takunipti. Waké pahapwi payt akipara hiyaknibe ku kabet amepye danuhbe gipinekut, ig pukuhpawnakam adahan ig mpithig marihwa ig ka parak amepye atere. ");
INSERT INTO plu_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Yisme kawnata hiyaknima ku kabet nah danuh, nah ku pariye wageswe awayg amadgaya inin. Nah danuh pahaye adahan. Amawka ku yis ahegbet takunipti. ");
INSERT INTO plu_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","―Ikawnabay ke kibeynebe ibuktibe. Ku pahapwi ibukti hiyakemniye, ku ig kis adahan gikipara ipeg ta gipitit, nikwe ku gikipara tipikwiye, apit gitepkemni igme apuriwkis gibukpig nawenépwi ta git. Pisenwa nikwe ig tipik. Igme gibuk msekwe. Ig ikene gimanakis mpuse hawkri. ");
INSERT INTO plu_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ku aysaw ner gikipara diyuh atere akiw, ku ig utí ig gibuk apuriwnene gibukpig kabayhtiwa, nikwe ig ikí git kaayhsima kabayka. ");
INSERT INTO plu_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Juktah ig apuriwkis madikte gewkanbet ta giwakuit ner gibuk. Ihanabay nuwnhu. Hennewatbaki ig keh. Nah hawwata nah keh yikak. ");
INSERT INTO plu_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Henneme ku ner gibuk mbeyepye gihiyakemni, ku ig ka apuriw gibukpig kabayhtiwatma, ig ner ka utí kabayka. Kawa. Nawenétke ig ipegminene gihiyakemni, ig awna: “Nukipara ka ayta kibentenwatma. Ig ayipwihwe kaayhsima akiw.” ");
INSERT INTO plu_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ayge nikwe ig kapusa biyuh giyakipwi ibukti, ig kayhsaw amin axka higapka, ig urukihwene gikakkis hiyeg urukihwatrupye. ");
INSERT INTO plu_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ayteke ku aysaw ig ka wahapnigma pahaye adahan ig gikipara danuhnek. Ig danuh ku aysaw gibuk ka iknima adahan ig danuh. ");
INSERT INTO plu_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ayge nikwe ig katiwnise gitaraksan ta git gibuknek. Ig sarayhkiswig ta arimkanit ini iwetrit gidahankis nerras ku pariye ikawnamahkis ke wotbe ignes kibeynepwibe hiyeg bawa igkis pi mbayte giwkis nawenépwi hiyeg. Ayge hiyeg tihebdi. Ignes kagah gaybukis. ");
INSERT INTO plu_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","―Nah akkite yit nawenéwa abektey akiw amin ku samah Uhokri gikumadukan. Minikwak madikawku gukebyikis himanopwiyo. Egkis iwé gulalampakis, egkis tipik adahan patiptekene pahapwi awayg ku pariye maripkewpiye gukak pahapu gukagmadakis. ");
INSERT INTO plu_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Pohowku gukebyikis ka hiyak hawkri. Pohowkume gukebyikis hiyak hawkri. ");
INSERT INTO plu_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Norras ku pariye kane hiyak hawkri egkis iwé gulalampakis henneme egkis ka iw ayak adahan egkis kipunsin. ");
INSERT INTO plu_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Norrasme ku pariye hiyaknopwi hawkri egkis iwé ayak adahan kipunsene gulalampakis. ");
INSERT INTO plu_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Igme ner awayg ku pariye guwhpankis ig ayipwihwe. Nikwe norras himanopwiyo egkis isepwe he egkis himeke. ");
INSERT INTO plu_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Pawka mtipka egkis timá kabimankaman. Pahapwi hiyeg awna gutkis: “Kuwis ig danuh. Kannikawnay. Su yi atak patiptakig.” ");
INSERT INTO plu_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Egkis timapni henne, egkis kannikewbet. Egkis ahegbetepyo gulalampakis amexa. ");
INSERT INTO plu_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ayge nikwe norras himanopwiyo ku pariye kane hiyak hawkri egkis awna ta gutkis norras ku pariye hiyaknopwi hawkri. Guwnkis: “Iká wothu ulalampa ayak. Ulalampa me makere araku.” ");
INSERT INTO plu_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Egkisme kaytwa guwnkis: “Kawa. Udahan ka ik udahanwiy wixwiy madiktema. Su yi atak ta gitkis piyuknepwi adahan yis isim yidahan.” ");
INSERT INTO plu_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Egkisme timapni henne, egkis tipik isim gudahankis. Ewka guwenkis ner awayg danuh atere. Norras himanopwiyo ku pariye ahegbet gidahan gidawnhan egkis tipik gihapti ta abetit fet adahan maripkawka. Egkis pareke atere. Ayteke pisenwa fet akipara sabukkise lappot awaku kuwis mpiya ahawkanaprik adahan hiyeg parak atere. ");
INSERT INTO plu_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ayteke ariwnteke ini norras isimnopwi gulalampakis ayak egkis danuh atere, lappot kuwis sabuke. Egkis hiyapni henne, egkis awna ta git ner awayg ku pariye maripkewpiye. Egkis awna: “Kiyapwiye, uyá woka lappot udahan.” ");
INSERT INTO plu_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Igme kaytwa guwnkis: “Nah ka hiyakyi ku pariyene yis. Hennewatbaki ka ba nah hiyakyiwa.” ");
INSERT INTO plu_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Aysawnemenek nah hawwata nah ayta ke ner awayg maripkewpiyebe. Msakwanabay ahegbet takunipti adahan yis tipikwiye nukakhu mmanawa yis ka hiyaknima ku kabet nah danuh atan. Yis kawnata hiyaknima ku kiney kamuw nah danuh. ");
INSERT INTO plu_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","―Nah akkite yit ku samah yis msakwa ahegbet adahan ndawnhan. In ke wotbe pahapwi awaygbe kehne giwewpan ta apitit pahá waxri piyawakad. Apit gitepkemni ig pahadguh gibukpig, ig apuriwkise gewkanbet gitkis. ");
INSERT INTO plu_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ig ikí mpuse giwakuitkis pakeku akak ku samah gannukis. Ig iké pohowkumku mil (5.000) karukri ta giwakuit pahapwi. Giwakuitme pahapwi ig iké mmukna mil (2.000) karukri. Giwakuitme pahapwi akiw ig iké pahamku mil (1.000) karukri. Ayteke ig tipik. ");
INSERT INTO plu_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ner gibuk ku pariye ikepka giwakuit pohowkumkunano mil (5.000) karukri, ig tipik kibentenwa ig kannipwiye gukak no karukri adahan eg kiyesihwa. Metakwa ig dax pohowkumku mil (5.000) karukri akiw. ");
INSERT INTO plu_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Igme ner ku pariye darih mmuknanano mil (2.000) karukri ig hawwata kawihe no karukri ku pariye ikepka giwakuit ig dax mmukna mil (2.000) karukri akiw. ");
INSERT INTO plu_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Igme ner gibuk ku pariye ikepka giwakuit pahamkunano mil (1.000) karukri ig tipik ig atik pahayku miyokwiye abet wayk, ig ayeme gikipara gikakura. ");
INSERT INTO plu_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Ayteke ariwnteke ini kibite hawkri akiw ig gikiparakis diyuhe atere. Ayge ig iwasa ku samah igkis kannipwiyes gukak no karukri ba kuwisma eg kiyestenma. ");
INSERT INTO plu_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Igme gibuk ku pariye ikepka giwakuit pohowkumkunano mil (5.000) karukri ig danuh atere git. Ig iké git pohowkumku mil (5.000) akiw. Ig awna: “Kiyapwiye, pis ikise nuwakuit pohowkumku mil (5.000) karukri. Ahah, nah kuwis utí pohowkumku mil (5.000) akiw pidahan.” ");
INSERT INTO plu_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Igme gikipara timapni henne, ig awna git: “Kibeyne. Pis kibeyne awayg. Pis ik adahan nah ipeg ta pipitit. Pis kuwis kannuh kawih aynessa arikna kabayhtiwa ndahan. Kuri nikwe nah ikí piwakuit pi kibite arikna akiw. Hiyawa pis batek payak nukakhu.” ");
INSERT INTO plu_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ayteke igme gibuk ku pariye ikepka giwakuit mmuknanano mil (2.000) karukri ig danuh atere git. Ig awna git: “Kiyapwiye, pis ikise nuwakuit mmukna mil (2.000) karukri. Ahah, nah kuwis uté mmukna mil (2.000) akiw pidahan.” ");
INSERT INTO plu_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Igme gikipara timapni hene, ig awna git: “Kibeyne. Pis kibeyne awayg. Pis hawwata ik adahan nah ipeg ta pipitit. Pis kuwis kannuh kawih aynessa arikna kabayhtiwa ndahan. Kuri nikwe nah ikí piwakuit pi kibite arikna akiw. Hiyawa pis batek payak nukakhu.” ");
INSERT INTO plu_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ayteke nikwe igme ner gibuk ku pariye ikepka giwakuit pahamkunano mil (1.000) karukri ig danuh atere git. Ig awna git: “Kiyapwiye, nah he msekwepi akak no karukri awaku nah hiyakni ku pis pi kannuhte nuwhu. Pis kapannusima. Ku kiney pis ka mutuh ariknawnama, hiyawa kuwewanek pis atere iwé kaayhsima amutri ariw ayteke. Ku kiney pis ka sassah aynesnima amutri ayak, hiyawa kuwewanek pis atere iwé kaayhsima amutri ariw ayteke. ");
INSERT INTO plu_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nah marenpi pibohri. Nikwe nah tipik nah ayeme pikakura abet wayk. Ahah pikakura.” ");
INSERT INTO plu_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Igme gikipara timapni henne, ig awna git: “Pis mbeyepye pihiyakemni! Pis mabipwipye hiyeg. Pis kuwis hiyakni ku kiney nah ka mutuh ariknawnama, hiyawa kuwewanek nah atere iwé kaayhsima amutri ariw ayteke. Pis kuwis hiyakni ku kiney nah ka sassah amutri ayak, hiyawa kuwewanek nah atere iwé kaayhsima amutri ariw ayteke. ");
INSERT INTO plu_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Nikwe kiskama pis kawihpinkam ndahan ini ku pariye nah ikise ay piwaku. Kiskama pis ikí nukakura agikut payt abeyheki karukri adahan ignes hiyeg ayge sunapkis eggu nukakura ta gitkis nawenépwi hiyeg kahadbe ku aysaw nah danuh atere, igkis diyuhkis nukakurakam apitminakama nuthu.” ");
INSERT INTO plu_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ayteke ig awna ta gitkis nerras hiyeg ayge gihumwa: “Iwepnay giw no karukri pahamkunano mil (1.000) adahan yis ikí ta git ner ku pariye kuwisnene kadahan madikawkumku mil (10.000). ");
INSERT INTO plu_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Mmanawa ku pariye darih kiyeste, iggi ikakka git pi kiyeste akiw. Henneme ku pariye ka darih kiyestema, nikwe iwepka giw ini ku pariye ig kuwis kadahan. ");
INSERT INTO plu_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ipukenabay ner awayg mabipwipye ta kabaywakat ta abetit amisnapyad. Ayge hiyeg tihebdi ignes kagah gaybukis.” ");
INSERT INTO plu_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","―Aysawnemenek nah ku pariye wageswe awayg amadgaya inin nah danuh atan akak madikte nukiythani akak madikte ahj. Pisenwa nah bat amadga nepwi kiyatyo adahan nah hiyekne gikakkis hiyeg. ");
INSERT INTO plu_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Apim ini madikte hiyeg amadgayapu hawkri pahadguhwa ta nupetunatnek. Ayge nah ibekheprikis pahabu han, pahabu han. Nah ibakhigkis hawwata ku samah pahapwi muttuhputne ibekhe gipigpu muttuh giwkis gipigpu kabrit. ");
INSERT INTO plu_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Nerras hiyeg ku pariye kene muttuhbe, ku pariye kibeynepwi hiyeg, nah ikigikis aytak kihehapriktak. Nerrasme ku pariye kene kabritbe, ku pariye kane kibeynepwima, nah ikigikis aytak patuwenapriktak. ");
INSERT INTO plu_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ayteke nah yikipara nah awna ta gitkis nerras ku pariye aytak kihehapriktak. Nah awna gitkis: “Aytninay numkat. Ig Wigwiy kabayhay. Ku apim inin yis darih ini Uhokri gikumadukan ku pariye kuwis ahegbet yidahan ku samah akapuska hawkri. ");
INSERT INTO plu_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ig Uhokri kabayhay mmanawa nah minikwak nah matipwepye, yisme ikapun. Nah arabyupye un, yisme ikapun. Nah ka yihiyaknima, yisme amapan ta yipinekut. ");
INSERT INTO plu_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nah yuma nukawihni, yisme ikí nukawihni. Nah kakahriye, yisme hiyak nukakhu. Nah agiku parakseket, yisme iwasapun atere.” ");
INSERT INTO plu_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Apim ini nerras hiyeg kibeynepwi timapni henne, igkis kaytwa nuwnhunek: “Kiyapwiye, kineyki usuh hiyapi pis matipwepye, usuh ikapi? Kineyki usuh hiyapi arabyupye un, usuh ikapi? ");
INSERT INTO plu_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kineyki usuh hiyapi pis ka uhiyaknima, usuh amapap ta upinekut? Kineyki usuh hiyapi yuma pikawihni, usuh ikí pikawihni? ");
INSERT INTO plu_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kineyki usuh hiyapi kakahriye, agiku parakseket usuh iwasap atere?” ");
INSERT INTO plu_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Nahme yikipara kaytwa giwnkis: “Minikwak ku aysaw yis amnih pahapwi nukebyi ku pariye yumanene gikiythanisima, amun ini nikwe yis kuwis amnihpen.” ");
INSERT INTO plu_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ayteke pisenwa nnetni gikakkis nah awnanek ta gitkis nerras aytak patuwenapriktak. Nah awna: “Higihwanabay aytekihan. Yis ikaksaka adahanikwa biyukwiki. Su yi tipik ta abetit no tiket dehetniki ku pariye ahegbetaki gidahankis wapityempu payak gikak gikiparadkis. Su yi tipik atere. ");
INSERT INTO plu_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Yis ikaksaka adahanikwa biyukwiki mmanawa nah minikak nah matipwepye yisme ka ikapun, nah arabyupye un yisme kawnata ikapun, ");
INSERT INTO plu_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","nah ka yihiyaknima yisme ka amapan ta yipinekut, nah yuma nukawihni yisme ka ikí nukawihni, nah kakahriye, agiku parakseket yisme ka iwasapun.” ");
INSERT INTO plu_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Apim ini nerras hiyeg kane kibeynepwima igkis timapni henne, igkis kaytwa nuwnhu: “Kiyapwiye, kineyki usuh hiyapi matipwepye, pis arabyupye un, pis ka uhiyaknima, pis yuma pikawihni, pis kakahriye, pis agiku parakseket usuhme ka amnihpi?” ");
INSERT INTO plu_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ayge nikwe nah yikipara kaytwa giwnkisnek: “Ku samah yis ka amnih pahapwinama nukebyi ku pariye yumanene gikiythani, amun ini nikwe yis kawnata amnihun.” ");
INSERT INTO plu_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ayteke nikwe igkis ipukepka hampa arimkanit biyukwiki adahan apanenekwa. Nerrasme kibeynepwi igkis aymuhwa adahan apanenekwa ay gimun Uhokri. ");
INSERT INTO plu_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Pisenwa gawnhan inakni, ig Kiyapwiye Jesus awna ta wothu gikannuhnipwi akiw. Giwn: ");
INSERT INTO plu_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Yis hiyakni ku pineme hawkri msekwe adahan upetrawiy adahan wixwiy hiyeg judeyenepwi axne muttuhyan arih. Wixwiy axni adahan kiyene ku samah minikwak Uhokri umahkise muttuhyan gidukwenaprikkis amekenegben adahan ig giwiwhkiswitnikis giwakutakkis gipetunyapukis. Ayge abet ini fet nah ku pariye wageswe awayg amadgaya inin nah kamaxwikanek adahan nah deddehpika aminat ah. ");
INSERT INTO plu_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Apimwata ini ku samah ig Kiyapwiye Jesus awnempiye inakni yuwit, nerras muwpeg kiyatyepwi gikakkis nerras judeyenepwi giwewkistenkis igkis pahadguhwa gipinekut ner muwpegpiyene gikiparakis kewye Kayfás. ");
INSERT INTO plu_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ayge igkis ahegbetepye ginetnikis igkiswonas. Igkis awna: ―Amawka ku wixwiy umahkise Jesus. Uyay kamaykiswig ku aysaw ig ka wahapnima. ");
INSERT INTO plu_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Henneme igkis awna: ―Ka ik adahan wixwiy kamaykiswig abet fet. Nawenétke hiyeg fetyapu hahhayruke ukakwiynek gipatra. ");
INSERT INTO plu_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Igme Kiyapwiye Jesus msekwe ay nipit paytwempu Betâniya ayge gipineku kiyapwiye Simawh. Igme kiyapwiye Simawh minikwak ig axpusakare apit busukne. ");
INSERT INTO plu_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ayteke nikwe pahapu tino danuh atere git. Eg ayta akak imihgi agiku pahá atiy kehka tip seyno. Ini imihgi kanitiwnisima. Eg tino danukwa kennesa git Kiyapwiye Jesus ku samah ig aynete axne. Ayteke eg dimuke ini imihgi gitewhait. ");
INSERT INTO plu_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Usuhme gikannuhnipwi hiyapni henne, usuh dagawne. Usuh awna: ―Mmahki ini imihgi he sarayhkanen waditnepyenen henne? ");
INSERT INTO plu_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Waké in ka sarayhkama henne, ikkam adahan in piyukwika adahan kaayhsima karukri. Ikkam adahan akakurapig ibekhepka gipuriwkis madiptapye. ");
INSERT INTO plu_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Igme Kiyapwiye Jesus hiyapni henne, ig awna wothu: ―Mmah yis mbayha no tino gutew henne? Ka ba yis hiyá eg kehno kaayhsima kabayka nukakhu? ");
INSERT INTO plu_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Hiyawa apanenekwa yis keh kabayka gidahankis madiptapye. Henneme nahme ka msakwa yibet apanenekwatma adahan yis kehne kabayka nukakhu. ");
INSERT INTO plu_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Eg imihepun adahan nahegbetepten adahan nah apuhpiki. ");
INSERT INTO plu_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Aysawnemenek hiyeg ekkene kibeyne inetit numinhu muwwapu amadga inin. Amun ini ginetnikis ignes kinetihwanek amin inin kabayka ku pariye eg keh nukakhu. In gukehni msakwa akiwka akiwkanek. Ihanabay inakni nuwnhu. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Igme pahapwi waytakhu usuh giwatnipwi, ig Judas Iskariyotismin, ig timapni henne, ig awna ginaktin: ―Kuri nah kamaykiswigte. Ig tipik ta gimkanitkis nerras muwpeg kiyatyepwi. ");
INSERT INTO plu_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ig danuh atere, ig awna gitkis: ―Aysamuk yis katiwnihun adahan nah ikepri ta yiwakuit? Igkis timapni henne, igkis katiwnihpig mpanamku madikwa (30) karukri wahano seyno. ");
INSERT INTO plu_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ayteke ariwnteke ini ig gihapu Kiyapwiye Jesus adahan ig hiyá ku aysaw gihawkan danuh kabayhtiwa adahan ig kamaykiswig. ");
INSERT INTO plu_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ayteke ariwnteke ini pitatye hawkri danuh adahan ini fet adahan hiyeg axne muttuhyan arih akak bugut miyegbiye adahan kiyene ku samah minikwak Uhokri umahkis muttuhyan gidukwenaprikkis gihiyegapu. Ayge nikwe gaytakkis Kiyapwiye Jesus gikannuhnipwi danuh ta git. Igkis ayapri: ―Kiyapwiye, kineypa pimawkan adahan usuh ahegbeta pahapwi muttuhyan adahan waxniwiy abet upetrawiy? ");
INSERT INTO plu_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Igme kaytwa giwnkis: ―Ataknay ta paytwempuit Jerusalém. Ayge yis patiptak gikak pahapwi awaygnek. Awnanay ta git ku yikannuhten awna: “Nuhawkanaprik me danuhmet. Nupewkan nah axne muttuhyan arih ay pipinneku payak gikakkis nukannuhnipwi.” ");
INSERT INTO plu_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Igkisme gikannuhnipwi timapni henne, igkis ihe giwn. Ayge nikwe igkis tipik ahegbete madikte adahan usuh fetya axne muttuhyan arih. Pisenwa igkis diyuhe ta git Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Aygete usuh atere fetya. Usuh danuh atere, ig Kiyapwiye Jesus bat aranwa axtet ukakhu usuh giwatnipwi madikawkunene ukebyi gikakkis piyana wawna (12). ");
INSERT INTO plu_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ku samah usuh aynete axne, ig Kiyapwiye Jesus awna wothu: ―Pahapwi yaytak ay iggi kamaykiswennek ta gitkis nupetunyapu. Ihanabay inakni nuwnhu. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Usuhme giwatnipwi timapni henne, usuh wakaymnibdi kaayhsima. Usuh awnebdi pahapwimpi: ―Kiyapwiye, ku ka nawhnama kamaykiswep? ");
INSERT INTO plu_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Igme Kiyapwiye Jesus kaytwa wownhu: ―Ner ku pariye mehbetene bugut nukakhu amadga paheknene miruk ignewatbaki nukamay kiswitni. ");
INSERT INTO plu_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Nah ku pariye wageswe awayg amadgaya inin nah umahkiswenek ku samah Uhokri gannasan minikweknene kinetihwa numinhu. Amawka ku nah miyá henneme ner ku pariye nuwmasepten nah ku pariye wareswe awayg amadgaya inin iggi hiyá mbeyne kaayhsimanek nupatra. Ka kiskama ner awayg humaw amadga wayk. ");
INSERT INTO plu_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ayteke ig Judas Iskariyotismin ner kamaykistinene Kiyapwiye Jesus ig awna ta git: ―Kiyapwiye, ku ka nawhnama kamaykiswep? Igme Kiyapwiye Jesus kaytwa giwn: ―Hennewa ku samah pis awna. ");
INSERT INTO plu_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ku samah usuh axnenete ayge, ig Kiyapwiye Jesus iwé pahak bugut. Ig kabayha Uhokri. Ig sigkebdih ini bugut, ig ibekhepni upuriw usuh giwatnipwi. Ig awna wothu: ―Ahah. Inin bugut inin nihhu yidahan. Amapanay inin bugut, axnay niwntak. ");
INSERT INTO plu_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Pisenwa gibakhan ini bugut, ig iwé pohow goblé. Ig kabayha Uhokri. Ig ikepni upuriw. Ig awna wothu: ―Higapnay niwntak, yis madikte. ");
INSERT INTO plu_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Mmanawa inin win in numighu yidahan. Ig Uhokri ahegbete ginetni nukunewa akiw gikakkis hiyeg adahan ku samah ignes humaw gihiyegapu. Nahme pahapwiwa nah sukase numighunek gidahankis kaayhsima hiyeg kahadbe ini gahegbetawni in humaw kahadbe Uhokri bayahminigkis ariw gitaraksankis. ");
INSERT INTO plu_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Kuri nah ka takunima higá win ay amadga inin akiw. Awetupye nah higá win juktah ayhté gimun Wigwiy gikumadukan nah higá nukunewa win yikak akiw. Ihanabay inakni nuwnhu. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ayteke pisenwa uhigpan usuh pak apat. Ayteke usuh peswiye ta apitit ini waxri imuhgipitnene kewye Olipegpit. ");
INSERT INTO plu_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ayge ig Kiyapwiye Jesus awna ta wothu: ―Ku apim inin tiyegim yis madikte ikiswennek awaku ini mbayka ku pariye me danuhmet nuthu. Mmanawa Uhokri gannasan minikweknene kinetihwa henne. In awna: “Nah umahkis ner muttuhputne. Ayge nikwe gipigpu muttuh madikte ibekhewbet.” ");
INSERT INTO plu_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Apim ini nah umehpikanek henneme nah kannikaw akiwnek. Ayteke ariwnteke nukankawni nah tipik pitati yapit ta apitit Galiléyamnaw. ");
INSERT INTO plu_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Igme kiyapwiye Pedru timapni henne, ig awna git: ―Hiyawa madikte hiyeg ikiswep awaku ini mbayka ku pariye me danuhmet pit, nawhme ka ikispiti. ");
INSERT INTO plu_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Igme Kiyapwiye Jesus kaytwa giwn: ―Ku apim inin mtipka pis wihwe nuwhunek. Apit tarakak awna pahaywowa gawnhan pisme ayipa wihwe nuwhunek mpamaput. Ihanaba inakni nuwnhu. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Igme kiyapwiye Pedru kaytwa giwn: ―Hiyawa nah umahkiswe payak pikak henneme nah ka wihwa piw. Usuhme gikannuhnipwi usuh madikte awnenekwiye hennep. ");
INSERT INTO plu_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ayteke ig Kiyapwiye Jesus tipik ta apitit pahá iwetrit kewye Jetsêmani. Usuh gikannuhnipwi tipike gihapti. Usuh danuh atere, ig awna wothu: ―Batnay ay in. Nahme tahhan piriyepkewne. ");
INSERT INTO plu_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ig iwé kiyapwiye Pedru gikakkis kiyapwiye Zebedew gikamkayupwi piyananene gikebyikis igkis atak gihapti. Igkisme wewkiswe ataresa, ayge igme kapusa wakaymni. Ig kayah apititak giyakni. Ig ka daykiswekere arit ini patahwaki ku pariye me danuhmet git. ");
INSERT INTO plu_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ig awna gitkis: ―Nah wakaymni mpiynepepye apit nuyakni. Ini nupewkan umehpen pahayewpi. Nah tahhan piriyepkawte. Yisme msakwa aynewa. Msakwanay apuriw adahan yis piriyepkaw payak nukakhu. ");
INSERT INTO plu_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ayteke ig wewkiswe ataresa aynessa. Ig mabukwa ta waygboit. Ig piriyepkaw ta git Uhokri. Ig awna: ―Nighu, ba hiyá pisma mpitha ini mbeyne danuh nuthu? Ku pis mpithekere, uyá amnihun mpithin ndahan. Henneme ku in pimawkanwa in danuh nuthu, ka sam in danuh nuthu. Nah ka kehkere ndahan nubetki. Henneme nah kehkere pidahanwa pibetki. ");
INSERT INTO plu_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ayteke pisenwa gipigyepkawni ig diyuhe ta gitkis gikannuhnipwi. Ig uteprikis himekweke. Ig hiyapni henne, ig awna ta git kiyapwiye Pedru: ―Mmah yis ka hiyá yisma msakwa apuriw nukakhu aynesnima? ");
INSERT INTO plu_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Apuriwnabay piriyepkawnabay marihwa yis ka isaksaw arit mbayka. Yitip ka isaksawkere arit mbayka henneme yipit amadgaya inin ik adahan isaksaw arit mbayka mmanawa yis yuma yawaygyisima nitiput. ");
INSERT INTO plu_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Pisenwa gawnhan inakni, ig diyuhe aterewata akiw. Ig piriyepkaw ta git Uhokri akiw. Ig awna: ―Nighu, ku pis ka mpitha ini mbeyne ndahan, ku in pimawkanwa in danuh nuthu, ka sam. Hiyawa pis keh ku samah pibetki nukakhu. ");
INSERT INTO plu_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Pisenwa ig diyuhe akiw. Ig uté gikannuhnipwi himekweke mmanawa igkis isepwe kaayhsima. ");
INSERT INTO plu_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ayteke ig diyuhe aterewata akiw. Ig piriyepkaw amamnaput akiw. Ig piriyepkaw inwata piriyepkawka. ");
INSERT INTO plu_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Pisenwa ig diyuhe akiw ta gitkis gikannuhnipwi. Ig awna gitkis: ―Mmahkay yis he himeknenenwa? Mmahkay yis he mayeknenenwa? Sarayhnay yipegyi atere. Kuwis danuh nuhawkanaprik. Kuri nah ku pariye wageswe awayg amadgaya inin nah me ikepkamet giwakuitkis hiyeg taraksapye. ");
INSERT INTO plu_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Kannikawnay. Uyay patiptakigkis. Ipegnay atere. Ig nukamaykiswitni nemnik. ");
INSERT INTO plu_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ku samah ig awnempiye inakni yuwit, igme Judas Iskariyotismin danuh atere. Ig pahapwi waytak usuh giwatnipwi. Ig danuh atere akak pahabunad hiyeg. Igkisme danuh atere akak giponyagakis akak gasugakis. Igkis iwatit gidahankis nerras muwpeg kiyatyepwi gikakkis nerras judeyenepwi giwewkistenkis. ");
INSERT INTO plu_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ig Judas Iskariyotismin ku pariye kamaykistinene Kiyapwiye Jesus, ig ayipa ahegbet ginetni gikakkis adahan ku samah ig ekkepye Kiyapwiye Jesus ta gitkis. Ig awna gitkis: ―Ku yis hiyá nah aympoka pahapwi, ignewatbaki Jesus. Kamaxnig. ");
INSERT INTO plu_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ayteke nikwe ig Judas Iskariyotismin tipik wadé gimkat Kiyapwiye Jesus. Ig danuh atere, ig awna git: ―Uhokri gabay pikaknek, Kiyapwiye. Akak ini ig aympokig. ");
INSERT INTO plu_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Igme Kiyapwiye Jesus kaytwa giwn: ―Nukagmada, hiyawa pis keh ku pariye pis kehkere nukakhu. Nerras pahabunene hiyeg igkis hiyapni henne, igkis sigise gimin, igkis kamaxwig, igkis sumuhpig. ");
INSERT INTO plu_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Aynewa pahapwi waytak usuh ku pariye aygnenepwi gikak Kiyapwiye Jesus ig kehe giponyaga. Ig huwipwihe pahapwi ibukti gidahan ner muwpegpiyene gikiparakis. Ig ihuke gitaybi. ");
INSERT INTO plu_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ig Kiyapwiye Jesus hiyapni henne, ig awna git: ―Paris piponyaga ta pibutikminat. Mmanawa madikte hiyeg ku pariye umeheke akak ponya, akakwata ponya ignes umehpika. ");
INSERT INTO plu_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ka ba pis hiyaknima ku ik adahan nah ayá ahj git Nighu adahan numaptenten igme awahkis numkanit kibentenwa kaayhsima ahj? ");
INSERT INTO plu_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Henneme waké nah keh hennebe, nikwekam madikte ka kahayak apigkutaprikma ku samah Uhokri gannasan minikweknene kinetihwa numinhu. ");
INSERT INTO plu_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ayteke ig Kiyapwiye Jesus awna ta gitkis nerras pahabunene hiyeg. Ig awna: ―Mmahkay yis ayta akak madikte yiponyaga akak madikte yasuga? Mmahkay yis ayta nukamaxwitni ayamaw ke wotbe nah amepyebe? Takunipti nah bat ayge yikak yikannuhten agiku Uhokri Gipin. Henneme yis ka kibowka kamaxun ayge. ");
INSERT INTO plu_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ka sam. Madikte ini danuh henne kahadbe in kahayak apigkutaprik ku samah Uhokri gawnepepu pitatyepwi kinetihwa amadga Uhokri gannasan. Usuh gikannuhnipwi timapni henne, usuh madikte tipikbet giw. Usuh ikiswig pahapo. ");
INSERT INTO plu_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ayteke nikwe nerras ku pariye gikamaxwitnipwi Kiyapwiye Jesus igkis waxwig ta gipinekut amekene Kayfás ku pariye muwpegpiyene gikiparakis. Ayge nerras kannuhekeputnepwi amin amekene Moís gikumadukan gikakkis nerras judeyenepwi giwewkistenkis ignes kuwis pahadgupu ayge. ");
INSERT INTO plu_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ig kiyapwiye Pedru hiyapni henne ku samah ig iwepka atere, ig makeke gihapu butte henneme ig piyawakte giw aynessa. Ig danuh ta arimkanit muwpegpiyene gikiparakis gipinbukut. Ig pareke atere, ig batahkiswe payak gikakkis nerras apuriwnepwi Uhokri Gipin. Ig hiyepkerepye ku pariye danuh ta git Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Apimwata ini nerras muwpeg kiyatyepwi igkis pahadgupu gikakkis madikte judeyenepwi gikiparakis ku samah igkis kehnes gipandukawnikis. Igkis aharitnes ba igkis utí Kiyapwiye Jesus gikehni mbaynama ku pariye ik adahan igkis giwmasepten. Inneki keh igkis aharitnes ba igkis utí hiyeg ku pariye gikamyehpitnipwi he wasaymkanen. Amawka igkis utí gikamyehpitnipwi ku pariye giwnkis tuguh hehpekwiye. ");
INSERT INTO plu_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Henneme igkis ka utí. Hiyawa kaayhsima hiyeg kamiyhepri akak gikehbetankisnen henneme giwnkis ka tuguh hehpekwiyema. Ayteke piyana gikebyikis kannikaw adahan kamiyepri akiw. ");
INSERT INTO plu_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Igkis awna: ―Ner awayg awna: “Ik adahan nah mehbete ini leglis Uhokri Gipin. Ayteke amamnam hawkri nah kannikasin akiw.” ");
INSERT INTO plu_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Igme muwpegpiyene gikiparakis ig timapni henne, ig kannikaw. Ig awna git Kiyapwiye Jesus: ―Mmahki pis ka kaytwa giwnkis? Mmah hennewatma ku samah igkis awna pimin? ");
INSERT INTO plu_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Igme Kiyapwiye Jesus tinwo. Igme muwpegpiyene gikiparakis ig awna git akiw. Giwn: ―Giwaprik Uhokri dehetniye nah ayá pit. Ku pis Cristo, ku pis Uhokri gikanyan adahan ukumaduketni, ku pis Uhokri gikamkayh, asá akkaw wothu. ");
INSERT INTO plu_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Igme kaytwa giwn: ―Nahnewa ku samah pis awna. Kuri yis betnene ayge adahan yis hiyekne nukakhu. Henneme aysawnemenek yis hiyapunnek, nah ku pariye wageswe awayg amadgaya inin, yis hiyapun nah bat ayge gihumwa Uhokri detye ay amun ini iwetrit ku pariye kanenikiythanisima kihehaptak. Yis hiyapunnek nah muhuk abetimpi ukuhne inugiktak. Apim ini nahme hiyekne yikak nikwe. Hennewatbaki nah. ");
INSERT INTO plu_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ig muwpegpiyene gikiparakis timapni henne, ig sigke gisimsa adahan arekhetni gidagonyi apatra ku samah Kiyapwiye Jesus awna gitkis inakni yuwit. Ig awna: ―Ig ikewne ke wotbe ig Uhokri gikamkayhbe. Ig makuksene Uhokri. Pariyeki umawkanwiy akiw? Wixwiy ka muwaka hiyeg akki wotwiy ariknawnama Jesus gitaraksan akiw. Kuwis ig makukse Uhokri ay wotrikwiy. Yis kuwis timapni akakwa yitaybi. ");
INSERT INTO plu_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Uyay katiwnise ini gitaraksan git. Mmani yit? Igkisme kaytwa giwn: ―Pugamawka ig umehpika. ");
INSERT INTO plu_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ayge nikwe igkis tupestepri. Igkis biptepri. Gaytakkisme biyuhpokepri. Igkis awna git: ");
INSERT INTO plu_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","―Aa, pis Uhokri gikanyanad adahan ukumaduketni, ku pis Uhokri gawnepe, asá akki wot ku pariye pibiyuhatepten. ");
INSERT INTO plu_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Apimwata ini ig kiyapwiye Pedru bat ayge paytbuhku. Ayteke pahapu tino bukitwiyo danuh atere git. Eg awna git: ―Pis hawwata wew gikak Jesus galiléyene. ");
INSERT INTO plu_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Igme wihwe giw giwtrikneswa madikte hiyeg. Ig awna gut: ―Nah ka hiyakwa inakni yuwit ku kamin pis awna. ");
INSERT INTO plu_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ayteke ig pes ta anumekut pesket. Ayge pahapuwa tino bukitwiyo hiyapri akiw. Eg hiyapni henne, eg awna ta gitkis hiyeg ku pariye ay kennesa guhumwa. Eg awna: ―Nernewa wew gikak Jesus nazaréyene. ");
INSERT INTO plu_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Igme wihwe giw akiw. Ig awna: ―Uhokri timá nuwnhu. Nah kawa hiyakriwa ner awayg. ");
INSERT INTO plu_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ayteke ariwnteke ini ayiptenesa akiw, nerras hiyeg ku pariye ayge kennesa guhumwa igkis danukwa atere gimkat kiyapwiye Pedru. Igkis awna git: ―Hennewa. Pisnewa pahapwi gaytakkis Jesus gikannuhnipwi mmanawa pis awna ke nerras galiléyenepwibe. Pikupimna akki wothu. ");
INSERT INTO plu_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Igme timapni henne, ig awna akak gihawna. Giwn: ―Ku nah ka awna inyerwatma yuwit, hiyawa Uhokri hiyapkis mbeyne nuthu. Nah ka hiyakriwa ner awayg. Nikwenéwa pahapwi takarak awna. ");
INSERT INTO plu_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Igme kiyapwiye Pedru timapni henne, ig kiyé inakni ku pariye Kiyapwiye Jesus giwn kuhwekwa ta git amin “Apit takarak awna pahaywowa gawnhan, pisme ayipa wihwe nuwhunek mpamaput.” Ig kiyé inakni giwn nikwe, ig pese. Ig kiyemna gitaraksan mpiynepepye. Ig biyuk gikan. Ig tihene ayge. ");
INSERT INTO plu_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Hewke nikwe hawkanawa nerras muwpeg kiyatyepwi gikakkis nerras judeyenepwi giwewkistenkis igkis ahegbete ginetnikis adahan giwmasepten Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ayteke nikwe igkis wanakminasepri. Igkis waxepri ta gimkanit ner hiyaptigi romayene ig amekene Pilatus. Igkis danuh atere, igkis ikepri ta giwakuit. ");
INSERT INTO plu_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Igme Judas Iskariyotismin ig ner kamaykistinene Kiyapwiye Jesus, ig hiyapni henne ku samah igkis kuwis ahegbete ginetnikis adahan giwmasepten Kiyapwiye Jesus, ig kayah gitaraksan. Ayge nikwe ig atere gitkis nerras muwpeg kiyatyepwi gikakkis nerras judeyenepwi giwewkistenkis. Ig diyuhkise gitkis no mpanamkunano madikwa (30) karukri wahano seyno. ");
INSERT INTO plu_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ig awna gitkis: ―Nah tarakse. Nah kamaykise yit pahapwi waditye ku pariye kane keh mbayka. Igkisme kaytwa giwn: ―Ka sam. Piswa hiyak nikak. ");
INSERT INTO plu_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Igme Judas Iskariyotismin timapni henne, ig padeke gikakura ta waygboit ayge agiku Uhokri Gipin. Ayteke ig tipik. Ig awna: ―Nah umehwepte. Ayteke nikwe ig iwé kawawta, ig waneke gibita, ig watiswe inutak, ig umehwe kuwigihwe. ");
INSERT INTO plu_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Igkisme muwpeg kiyatyepwi hiyapni henne, igkis ahiwe no karukri wahano seyno. Igkis awna: ―Amekene Moís gikumadukan ka isaksa wixwiy kawih no karukri gidahan Uhokri Gipin awaku no karukri kuwis katiwnih adahan giwmasepten pahapwi. ");
INSERT INTO plu_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Nikwe igkis ahegbete ginetnikis adahan isimpiye pahá waxri git pahapwi batekereputne adahan apuheket gidahankis hiyeg nawwotunyepwi. ");
INSERT INTO plu_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Inneki keh ku akak inin hiyeg kaywa ini waxri, “Waxri Migatapta”. ");
INSERT INTO plu_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Metakwa in kahayak ku samah Uhokri gawnepe amekene Jeremíyas giwn minikwak. Ig awna: “Igkis israelyenepwi ahegbete ginetnikis adahan igkis katiwnih mpanamku madikwa (30) karukri wahano seyno gidahan. Ayteke igkis iwé no karukri, ");
INSERT INTO plu_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","igkis kawihpig adahan isimpiye pahapwi batekereputne giwaxri. In tuguh apigkutapriknawa ku samah Uhokri gakkan nuthu.” ");
INSERT INTO plu_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Igme Kiyapwiye Jesus ikepka ta giwakuit ner hiyaptigi romayene ig amekene Pilatus. Igme ayapri: ―Mmah pis judeyenepwi gikiparakis? Igme Kiyapwiye Jesus kaytwa giwn: ―Hennewa ku samah pis awna. ");
INSERT INTO plu_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Henneme ku aysaw nerras muwpeg kiyatyepwi gikakkis nerras judeyenepwi giwewkistenkis kamiyepri atere, ig ka kaytwa giwnkis pahatnama yuwit. ");
INSERT INTO plu_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ig amekene Pilatus hiyapni henne, ig ayapri: ―Ka ba pis timá ku samah igkis kamiyep ku pis keh mbayka kaayhsima? ");
INSERT INTO plu_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Kameki ig Kiyapwiye Jesus kaytwame giwnkis. Ig ka diyuhkis ginetnikis akak pahatnama yuwit. Igme hiyaptigi hiyapni henne, ig wakaymni kaayhsima. ");
INSERT INTO plu_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Apim ini ahawkanaprik adahan hiyeg judeyenepwi gipetrakis. Abet ini gipetrakis ig hiyaptigi gibetki isahkis pahapwi awayg ku pariye paraksepkare ayge. Mpuse kamukri ig isahkiswiye apim ini pahapwi ku pariye hiyeg fetyapu isahkiskere. ");
INSERT INTO plu_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Apim ini hawkri ayge pahapwi awayg agiku parakseket ku pariye hiyakan muwwapu. Giw Bahabás. ");
INSERT INTO plu_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ayge nikwe igkis hiyeg fetyapu pahadgupu atere, ig amekene Pilatus ayaprikis: ―Pariye yimawkan nah isahkis yidahan? Ba Bahabás? Ba kawk? Ba Jesus ku pariye ikawparinene Cristo, Uhokri gikanyan adahan yikumaduketni? ");
INSERT INTO plu_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ig awna inakni mmanawa ig hiyak kabayhtiwa ku nerras muwpegpu iké Kiyapwiye Jesus ta giwakuit he apatranen ku samah igkis atihapnig. ");
INSERT INTO plu_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Hawwata akiw amun ini ku samah ig amekene Pilatus betnene amadga gepwi adahan ku kiney ig hiyekne gikakkis hiyeg, atere gihayo wasapanaw gimin. Guwn: ―Ka ba keh ariknawnama gikak ner awayg waditye awaku nah kuwis hiyá mbeyne kaayhsima gipatra abet narisun. ");
INSERT INTO plu_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Igkisme nerras muwpeg kiyatyepwi gikakkis nerras judeyenepwi giwewkistenkis igkis wagese nerras fetyapu gihiyakemnikis kahadbe ignes isahkisase Bahabás, igme Kiyapwiye Jesus igkis giwmasepten. ");
INSERT INTO plu_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Igme hiyaptigi awna ta gitkis nerras fetyapu akiw. Giwn: ―Pariyepahki gaytakkis nerras piyananene gikebyikis, pariyepahki yimawkan nah isahkisase yidahan? Igkisme kaytwa giwn: ―Isahkis Bahabás. ");
INSERT INTO plu_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Igme amekene Pilatus timapni henne, ig ayaprikis: ―Mmah nah keh nikwe gikak Jesus ku pariye yis kanum Cristo, Uhokri gikanyan adahan yikumaduketni? Igkisme madikte kaytwa giwn: ―Uyá daddahkiswig! ");
INSERT INTO plu_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Igme timapni henne, ig ayaprikis: ―Mmahki? Pariye mbayka gikehni? Igkisme kabiman pi kihhawnate akiw. Igkis awna: ―Daddahkisnig! ");
INSERT INTO plu_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Igme amekene Pilatus hiyapni henne ku ig ka ik adahan ig wages nerras hiyeg gihiyakemnikis, ig hiyapni ku igkis me dakuhwemet ig matiwniswe. Ayge nikwe ig iwé un, ig sukokew giwtrikneswa adahan wihwene ariw Kiyapwiye Jesus gimiremni. Ig awna gitkis: ―Ner awayg gimiremni ka nuhawkanaprikma. Ka nahma umahkiswig. Yiswa hiyak nikak. ");
INSERT INTO plu_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Igkisme madikte hiyeg kaytwa giwn: ―Ka sam. Usuhwa umahkiswig. Ku usuh tarakse hiyawa usuhwa katiwnihpin payak gikakkis ukamkayupwi. ");
INSERT INTO plu_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ayteke nikwe ig amekene Pilatus isahkisase Bahabás gidahankis. Henneme ig biyuhkise Kiyapwiye Jesus akak tigay. Ayteke ig ikepri ta giwakuwitkis gisuwtatapu adahan igkisme gideddehpitni. ");
INSERT INTO plu_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ayge nikwe igkis gisuwtatapu waxe Kiyapwiye Jesus ta gipinbukut hiyaptigi. Ayge igkis pahadguhe madikte suwtatpiyene ta ganwat adahan gimahipwihpitni. Igkis awna gitkis: ");
INSERT INTO plu_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","―Uyay arehwa gikak. Uyay kawihkis gikawihni ta gipitit kewa ukiparawiybe ku samah ig kawih dagam duruweh akak gisuwpren karukri wahano. Ayteke nikwe igkis wiwhe gisimsa, igkis kadagmanepri akak pahak dagam duruweh. ");
INSERT INTO plu_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ayteke igkis imepe puduku, igkis keh gisuwpren nikak. Igkis kawihkisni ta gitewharit. Ayteke igkis ikí pahat yakkot akat ta giwakuit kihehaptak ke wotbe in ikiparat gasugabe. Pisenwa igkis paberetusaw gitiput. Igkis mahipwihpig. Igkis awna git: ―Aa, kiyapwiyad, kibeyne pis ay kuri. Pis judeyenepwi gikiparadkis. ");
INSERT INTO plu_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ayteke igkis tupestepri. Igkis xuwehe ini yakkot akat ayta giwakutak. Igkis biyuhpig gitewha nikak. ");
INSERT INTO plu_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Pisenwa gimiytankis igkis wiwhe ini dagam gipititak, igkis kawihkise git gisimsa ku pariye gikawhan. Ayteke nikwe igkis tipikepri apititak ini paytwempu adahan gideddehpitni. ");
INSERT INTO plu_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Apigku ahin igkis patipteke gikak pahapwi awayg sireneyene kewye Simawh. Igkis hiyapni henne, igkis mpiksaptihpig adahan ig gayapetni Kiyapwiye Jesus hiyuhne giyakni. Igme ihe giwnkis. ");
INSERT INTO plu_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ayteke igkis danuh ta apitit pahá waxri imuhgipitnene kewye Gówgota. Inakni wownaprikwiy “Waxri Hiyeg Gaptiwpitwiye”. ");
INSERT INTO plu_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ayge igkis suwtat akaka git Kiyapwiye Jesus win adahan gihigpan. In wageska akak ipeyti tagetreni gih kewye “few”. Henneme pase ig ewhin ig ka higapni. Ayteke igkis deddehpig ta aminat giyakni. ");
INSERT INTO plu_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Pisenwa gidaddahnikis, igkis arehwa akak tip adahan hiyá ku pariye kabunuganen ig darihpiye Kiyapwiye Jesus gikawihni. Henne igkis ibekhepyes gikawihni pawtak. ");
INSERT INTO plu_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ariwnteke ini igkis batahkiswe ayge, igkis apuriwgi. ");
INSERT INTO plu_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ayge amin giyakni apitmin gitew pahak kagta daddahka atere adahan arekhetni ku pariye gikehnitnene ta gitkis hiyeg. Amadga ini kagta awna, “Ig Jesus Ig Judeyenepwi Gikiparakis”. ");
INSERT INTO plu_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Hawwata akiw igkis deddehe piyana amepwapye ta aminat giyaknikiswa payak gikak Kiyapwiye Jesus. Pahapwi daddahka kihehaptak pahapwime patuwanaptak. ");
INSERT INTO plu_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Kaayhsima hiyeg mapiya awpre. Ayge igkis mahipwihpig. Igkis sassah gitewkis adahan arekhetni ku samah igkis ka batek gikak. Igkis awna git: ");
INSERT INTO plu_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","―Kineyka kuri ku samah pis awna: “Nah mehbete Uhokri Gipin. Ayteke amamnam hawkri nah kannikasin akiw.” Asá amnih pipit kuri. Ku pis igyerwa Uhokri gikamkayh, nikwe muhuk ayteke kuri aminatak piyakni. ");
INSERT INTO plu_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Nerras muwpeg kiyatyepwi gikakkis nerras kannuhekeputnepwi amin amekene Moís gikumadukan gikakkis nerras judeyenepwi giwewkistenkis igkis hawwata igkis mahipwihpig. Igkis kinetihwa pawtak. Igkis awna: ");
INSERT INTO plu_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Kuwis ig amnihe nawenépwi hiyeg, kuri gipitme ig ka hiyá aramnihka. Ku igyerwa hiyeg israelyenepwi gikiparakis, hiyawa ig muhuk ayteke aminatak giyakni. Ku wixwiy hiyá ig muhuk ayteke, nikwe wixwiy iha giwn. ");
INSERT INTO plu_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ig awna ku ig kamaxwa ta gipitit Uhokri. Ig ikawpari Uhokri gikamkayh. Ku hennewatma Uhokri kapigsanig, wixwiy hiyá ba Uhokri amnihgi. Hennewatbaki igkis awna. ");
INSERT INTO plu_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nerras amepwapye ku pariye daddahka ayge gihumwa Kiyapwiye Jesus igkis hawwata mahipwihpig akak inwata yuwit. ");
INSERT INTO plu_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ayteke puwipka danuh. Pahaye adahan kamuw abutni ka kabutni akiw. Hawkri msanpi juktah daraka kamuw in kapusa kabutni akiw. ");
INSERT INTO plu_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Apim ini daraka kamuw, ig Kiyapwiye Jesus kabiman akak gihawna giwnaprik. Ig awna: ―“Eli, Eli, lemá sabaktâni?” Inakni wownaprikwiy: “Nuwohkiga, nuwohkiga, mmah pis ikiswen?” ");
INSERT INTO plu_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Gaytakkis hiyeg ku pariye tabirbetnene ayge igkis timapni henne, igkis timá tarakise. Igkis awna: ―Ner awayg ig humekne amekene Eliyas. ");
INSERT INTO plu_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Pahapwime gaytakkis ig timapni gabiman henne, ig muwaka adahan gamnihten. Ig sigise kibentenwa ig iwé pahá arikna ku pariye mtibetnene. Ig subukwin ahakwat win suwiyweye adahan anugasene. Ig iké akisurik pahat yakkot akat. Ig tarekwin ta gimkat Kiyapwiye Jesus kahadbe gipewkan ig susni. ");
INSERT INTO plu_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Henneme nawenépwi hiyeg ayge igkis hiyapni henne, igkis awna git: ―Miniw giw. Uyay hiyá ba ig amekene Eliyas danuhwatma adahan gamnihten. ");
INSERT INTO plu_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Igme Kiyapwiye Jesus kabiman akak gihawna akiw. Giyakek madike. Ig miyap. ");
INSERT INTO plu_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Nikwenéwa apim ini, ini kamis amaptenten Uhokri giwskeki ku pariye ayge agikunene Uhokri Gipin, in sigke pabakak. Nikwenéwa ku aysaw ig miyap amun ini in sigka aytá inutak danuhte ta warikwit. In woka ahin ta agikut Uhokri giwskeki. Ayge apim ini wayk segke. Tip bekhewbet. ");
INSERT INTO plu_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","53","Amun ini kaayhsima imewti woke. Ayteke ariwntak Kiyapwiye Jesus gikankawni, kaayhsima Uhokriyanpu miyarapye igkis kannikew, igkis pese apititak ini gimewkis. Igkis tipik ta apitit Jerusalém ini paytwempu gidahan Uhokri. Ayge kaayhsima hiyeg hiyaprikis. ");
INSERT INTO plu_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ig Kiyapwiye Jesus miyapi, pahapwi romayene suwtat gikiparakis gikakkis nerras gisuwtatapu ku pariye gikapriwten, igkis hiyapni ini sagkaki akak madikte akiw ku pariye danuh apim ini, igkis wakaymnibdi mpiynepepye. Igkis awna: ―Inyerwa ner awayg Uhokri gikamkayh. ");
INSERT INTO plu_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Aygwata kaayhsima kiyapunogben egkis hawwata ipegbet atere. Egkis norras ku pariye danuhpanopwi payak gikak Kiyapwiye Jesus apititak Galiléyamnaw. Egkis ku pariye hiyaknopwi gikak. ");
INSERT INTO plu_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Eg kiyapuno Mahi Madalena eg pahapu gaytakkis. Hawwata pahapuwa Mahi akiw eg pahapu gaytakkis. Eg ginagkis kiyapwiye Tiyagu gikak kiyapwiye José. Hawwata kiyapuno Salomé ku pariye kiyapwiye Zebedew gikamkayupwi ginagkis eg pahapu gaytakkis. ");
INSERT INTO plu_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Aygete pahapwi awayg igisye danuh atere. Ig ariwntak paytwempu Arimatéya. Giw José. Ig hawwata Kiyapwiye Jesus gikannuhni. ");
INSERT INTO plu_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ig hiyapni henne ku samah ayipa gimiremni, ig tipik ta gimkat amekene Pilatus, ig awna git: ―Kiyapwiye, uyá amnihun isaksan adahan nah atere iwepye amekenemni Jesusmin gipit. Igme amekene Pilatus timapni henne, ig awna ta gitkis gisuwtatapu: ―Wani ikepka git kiyapwiye José. ");
INSERT INTO plu_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Igme kiyapwiye José hiyapni henne, ig tipik. Ig danuh atere, ig wiwhe gipit aminatak giyakni. Ayteke ig awasminepri akak pahak dagam seyne barewbetye. ");
INSERT INTO plu_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Pisenwa ig sarayhe gipit ta agikut pahayku imewti nukune ku pariye ayipa ig atikkis gidahanwa agiku tip amiyokni. Ayteke ig wagesmine pahow tipad adahan gisabwatip. Pisenwa ig tipik. ");
INSERT INTO plu_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Apim ini kiyapuno Mahi Madalena gukak no pahapuwa Mahi akiw, egkis batnano ayge apitkig gimew. ");
INSERT INTO plu_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ayteke amapya ini hawkri ku kabet judeyenepwi ahegbetaw adahan kiyathene samdi, nerras muwpeg kiyatyepwi gikakkis nerras farisewkis igkis tipik ta git amekene Pilatus. Hiyawa apim inin samdi, henneme igkisnewa atak atere. ");
INSERT INTO plu_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Igkis danuh atere, igkis awna git: ―Kiyapwiye, usuh kiyé ku pariye ner kinisekeputne awna ku samah ig aytehte ay ukakhu. Ig awna: “Amamnam hawkri ariwntak numiremni, nah kannikaw akiwnek.” ");
INSERT INTO plu_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nikwe uyá awahkis suwtat atere adahan ignes apuriwnes gimew he ku aysaw mpiya mpana hawkri. Ayge nikwe ik adahan igkis mpitha gikannuhnipwi adahan igkis ka ayta kidis gap adahan igkis ka awna ta gitkis hiyeg: “Ig kuwis kannikaw ariw gimiremni.” Ku igkis awna inakni, ik adahan igkis kinis kaayhsima hiyeg. Ayge nikwe igkis pi kiniste hiyeg mpiya ku samah Jesus kiniswigkis pitatye. ");
INSERT INTO plu_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Igme amekene Pilatus timapni henne, ig awna ta gitkis: ―Iwapnay nusuwtatapu. Hiyawa yis atere apuriwkis gimew ta gitkis. Apuriwkisni kabayhtiwa ku samah yimawkan. ");
INSERT INTO plu_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Igkisme timapni henne, igkis tipik. Igkis mpiyase pahat kuwawta apitmin gimew asabwat kahadbe in ka woka. Hawwata igkis ikise apuriwnepwi ayge adahan nimaptenten. ");
INSERT INTO plu_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ariwnteke ini, samdi kuwis mpiye kuwis, paka abet kabeyweke, eg kiyapuno Mahi Madalena gukak no pahapuwa Mahi akiw egkis tipikwiyos adahan iwasano gimew. ");
INSERT INTO plu_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Pahaye adahan wayk segke kihhaw mmanawa pahapwi ahj Uhokri giwatni muhuke inugiktak. Ig danuh atere arit gimew. Ig woke asabwat. Ayteke ig batahkiswe atere guhamadgat asabwatip. ");
INSERT INTO plu_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Gihipak urupari ke ugugunebe. Ig kasimsapu akak simis seyne. Nisisina ke laglasbe. ");
INSERT INTO plu_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Nerras apuriwnepwi gimew igkis hiyapni henne, igkis apisasew. Igkis segke. Igkis miyarasaw. ");
INSERT INTO plu_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ayteke norras tinogben danuh atere. Igme ner ahj awna ta gutkis: ―Ka yi muwaka apis. Nah hiyakni ku yis ipegepye Kiyapwiye Jesus ku pariye kuwis deddehpika. ");
INSERT INTO plu_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ig yuma ay. Ig kuwis kannikew ku samah gikaksan yit. Ba yi ayta atan iwasa gidukwen. Egkis timapni henne, egkis pareke atere agikut gimew. Egkis iwasa gidukwen. ");
INSERT INTO plu_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ayteke ig ahj awna gutkis: ―Kuri tipiknay kibentenwa. Ataknabay ta gitkis gikannuhnipwi. Akkanay gitkis ku ig kuwis kannikew ariw gimiremni. Awnanay gitkis: “Kuri ig tipik pitati yapit ta apitit Galiléyamnaw. Ayge yis hiyaprinek.” Hennewatbaki in ku samah nah awna yit. ");
INSERT INTO plu_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Egkis hiyapni henne, egkis pese kibentenwa agikutak gimew. Egkis apise henneme egkis hawwata batek gunaktinkis. Egkis sigise ta gimkatkis Kiyapwiye Jesus gikannuhnipwi adahan akkano inakni ahj ginetni ta gitkis. ");
INSERT INTO plu_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Egkis apigku ahin, pahaye adahan igwa Kiyapwiye Jesus patiptakigkis. Ig awna gutkis: ―Uhokri gabay yikaknek. Egkisme danukwa atere git. Egkis paberetusaw gikimpuwit. Egkis sumuh gikugku. Egkis kabayhig. ");
INSERT INTO plu_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Igme Kiyapwiye Jesus awna ta gutkis: ―Ka yi muwaka apis. Su yi atak kinetihwa ta gitkis nukebyupwi adahan igkis atak ta apitit Galiléyamnaw. Ayge igkis hiyapunnek. Egkis timapni henne, egkis tipik. ");
INSERT INTO plu_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Apimwata ini gaytakkis nerras suwtat ku pariye apuriwnepwi gimew igkis danuh ta apitit paytwempu Jerusalém. Igkis atak ta gitkis nerras muwpeg kiyatyepwi. Igkis danuh atere, igkis akki gitkis madikte ku pariye danuh. ");
INSERT INTO plu_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Igkis muwpeg kiyatyepwi timapni henne, igkis pahadguhwa gikakkis nerras judeyenepwi giwewkistenkis. Ayge igkis ahegbete ginetnikis. Pisenwa gahegbetankis ginetnikis, igkis iwé kaayhsima karukri, igkis ikepni ta gitkis nerras suwtat. ");
INSERT INTO plu_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Igkis awna gitkis: ―Uyá kinetihwa gitkis hiyeg ku gikannuhnipwi danuh tiyegim igkis kidise gap apim ini ku samah yis himegbetnene. ");
INSERT INTO plu_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ku ner hiyaptigi timé yak, ku yis ka apuriw kabayhtiwatma, ka sam. Usuh atere git, usuh awnamnihyi. Usuh wadithebdih yihawkan gikak adahan ig ka hiyapkis mbeyne yit apatra yis himeke. ");
INSERT INTO plu_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Igkisme hiyapni henne, igkis amere gikakurakis. Igkis ihe inakni giwnkis. Inneki keh juktah kupiknene akak inin kaayhsima judeyenepwi kinetihwenene inakni inetit. ");
INSERT INTO plu_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Usuhme giwatnipwi madikawkunene ukebyi gikak pahapwi wawna (11) usuh tipik ta apitit Galiléyamnaw. Usuh wagehe apitit pahá waxri imuwadnene ku kiney Kiyapwiye Jesus wasapanaw uminhu adahan usuh patiptakig. ");
INSERT INTO plu_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Usuh danuh atere, usuh utepri ayge. Usuh hiyapni henne, usuh kabayhig. Henneme waytakhu pukuhpaw gibohri. ");
INSERT INTO plu_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Igme Kiyapwiye Jesus danukwa kennesa wothu, ig awna wothu: ―Madikte kumadukaki ikaka nuthu adahan nah kumadukene madikte inugikyenepwi madikte amedgenepwi inin. ");
INSERT INTO plu_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ataknabay ta gitkis madikte hiyegipiyenepwi. Kinetihwanabay gitkis adahan igkis humaw nukannuhnipwi. Kaywepnigkis ahakwat un giwaprik Wigwiy giwaprik gikamkayh giwaprik Gitip adahan arekhetni ku igkis ikewnepwi wothu. ");
INSERT INTO plu_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Kannuhnigkis adahan igkis ihpa madikte nuwnhu ku pariye nah kuwis awna yit. Ayge amun ini nah ayge yikak apanenekwa juktah amaksemni hawkri.");
INSERT INTO plu_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Inineki kibeyne inetit gidahan Kiyapwiye Jesus Cristo ku pariye Uhokri gikamkayh. ");
INSERT INTO plu_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Minikwak Uhokri gawnepe amekene Isaías ig tamak amadga gikagtan ku pariye Uhokri awna ta git gikamkayh. Giwn: “Nah awahkiste pahapwi nuwatni papitkiya adahan ig ahegbetene madikte papit. ");
INSERT INTO plu_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ig ner pahapwi kinetihwanek ta gitkis hiyeg amadga amatap. Ig awnanek: ‘Ahegbetawnabay gapit Ukiparawiy gaytni. Ig nemnik ig. Wadithanabay yihiyakemni gidahan marihwakam yis kawih gidahan Uhokri gikumadukan. Yihiyakemni kewa pahatra ahinbe mbeyepyebe. Ka ik adahan Ukiparawiy sibuhaprik atere. Wadithaprikanabay ini ku kiney kiduwapriknene.’ ” Hennewatbaki ig Uhokri gawnepe awna minikwak. ");
INSERT INTO plu_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ayteke ariwnteke ini kibite kamukri akiw, ig amekene João Batista danuh atere amadgat amatap. Ig awna ta gitkis hiyeg: ―Wagesnabay yihiyakemni. Kewpinabay ta ahakwat un adahan ekkene ku yis amepene ini ku Uhokri bayahminay ariw yitaraksan. Hennewatbaki ig amekene João Batista awna. ");
INSERT INTO plu_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Kaayhsima hiyeg danuh atere gimkanit amekene João Batista adahan igkis ihpene inakni giwn. Igkis danuh apititak madikte waxri Judeyamnaw. Igkis danuh apititak paytwempu Jerusalém. Igkis danuh atere, igkis ekkepye gitaraksankis ta git amekene João Batista. Igme kayweprikis apigku eggu warik Jordawh adahan igkis amepene ini ku Uhokri bayahminigkis ariw gitaraksankis. ");
INSERT INTO plu_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ig amekene João Batista madiptipye. Ig kasimsapu akak “kamelu” asipri. Ig kakabutikpu akak pak amar. Gimaname tanan akak ahayak anunu. ");
INSERT INTO plu_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ig awna ta gitkis hiyeg. Giwn: ―Pahapwi nemnikumpiye nuhapuh butte ku pariye kaayhsima pi kiyatte mpiyhan. Nah yuma nukiythanisima gitiput adahan nah paberetusaw gitiput adahan nah ayapig wiwh gikasotni gikugkuptak. ");
INSERT INTO plu_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ku aysaw nah kaywepyi nah kawihkis un ta yipitit. Igme kaywepyinek gikak igyerwa Uhokri Gitip adahan ig kawihkis gidahanwa gihiyakemni akak gannu ta yipitit. ");
INSERT INTO plu_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Abetnewa ini hawkri ig Kiyapwiye Jesus pes apititak paytwempu Nazaré ayhté apit Galiléyamnaw. Ig danuh atere git amekene João Batista. Igme amekene João Batista kaywepri apigku eggu warik Jordawh. ");
INSERT INTO plu_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Igme Kiyapwiye Jesus iyak ahakwatak un, aynewa ig hiyá en woke. Ig hiyá Uhokri Gitip muhuke ta gipitit, gihipak ke pahapu tukwabe. ");
INSERT INTO plu_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ayteke pahá ikupimnat awna aytontak inugiktak. In awna: ―Pisnewa nukamkayh nubetki. Nah batek pikak kaayhsima. ");
INSERT INTO plu_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Aynewa ig Uhokri Gitip awahkise Kiyapwiye Jesus ta amadgat amatap. ");
INSERT INTO plu_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ayge ig msakwa pahapo adahan paxnika madikwa (40) hawkri. He puwiknenen ayge. Ig awahkiska atere adahan wapitye gikiparadkis Satanás gihikekten adahan hiyá ba hiyá igma taraksasepri. Ayteke ahj danuh atere, igkis ikenes Kiyapwiye Jesus gawaygyi. Pisenwa ig tipik ta gipinwat. ");
INSERT INTO plu_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ayteke ariwnteke ini ku samah amekene João Batista paraksepka gapit amekene Erodis, ig Kiyapwiye Jesus tipik ta apitit Galiléyamnaw. Ig danuh atere, ig kapusa akki Uhokri ginetni amin gikumadukan. ");
INSERT INTO plu_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ig kinetihwa ta gitkis madikte hiyeg. Giwn: ―Ahawkanaprik Uhokri gikumadukan kuwis danuh. Wagesnabay yihiyakemni ariw yipathawni. Ihpanabay inakni kibeyne inetit. ");
INSERT INTO plu_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ig waywe akigbimna mahakwa Galiléya. Ayge ig hiyá kiyapwiye Simawh Pedru gikak gisamwi kiyapwiye André. Igkisme ipuhtyakeputnepwi. Igkis ayge ipuhtyanenes akak tagamayh. ");
INSERT INTO plu_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ig Kiyapwiye Jesus hiyapni henne, ig awna ta gitkis: ―Ba yi ayta wew nukakhu. Nah keh yis humaw ipuhtyakeputne hiyeg. Ku samah yis utí im, nah keh yis utí hiyeg ndahan. ");
INSERT INTO plu_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Igkis timapni henne, aynewa igkis ikise gitagmayakis. Igkis tipik gikak adahan igkis humewnes gikannuhnipwi. ");
INSERT INTO plu_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ayteke ig wew aynessa akiw, ig hiyá amekene Tiyagumni gikak gisamwi kiyapwiye João, ku pariye amekene Zebedew gikamkayupwi. Igkis ayge amadga gihmunkis. Igkis kehepenes gitagmayakis ayge. ");
INSERT INTO plu_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ig Kiyapwiye Jesus hiyapni henne, ig humekwigkis ta gimkanit. Igkisme ikise gigkis amadga gihmunkis gikakkis gihiyegapu. Igkis tipik gikak Kiyapwiye Jesus adahan igkis hawwata humewnes gikannuhnipwi. ");
INSERT INTO plu_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ayteke ariwnteke ini igkis danuh atere paytwempu Kafarnawh. Samdi abet ig Kiyapwiye Jesus lammisya agiku judeyenepwi gileglisakis adahan ig kannuhekne ayge. ");
INSERT INTO plu_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ignes hiyeg aygnenepwi wakaymnibdi gidahan ku samah gikannuhakni. Mmanawa ig ka kannuhak kema nerras kannuhekeputnepwima amin amekene Moís gikumadukan. Henneme ig kannuhekne ayge akak madikte gikiythani. ");
INSERT INTO plu_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ayge agiku ini gileglisakis pahapwi awayg wapityewnipye mbeyepye. ");
INSERT INTO plu_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Ig kabiman git: ―Jesus nazaréyene, ka ba kiyimwih usuh. Pariye pikehni ukakhu? Mmah pis ayta pisenwepye uhawkan ku apim inin? Nah hiyaknap ku pis Uhokri gikanyan barewpitye. ");
INSERT INTO plu_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ig Kiyapwiye Jesus timapni henne, ig himehe ner wapitye. Ig awna git: ―Tinwohaw. Asá pes ayteke gipititak ner awayg. ");
INSERT INTO plu_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Aynewa ig wapitye nuwiswig. Ig kabiman kihhaw. Ayteke ig pese gipititak. ");
INSERT INTO plu_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Madikte hiyeg hiyapni henne, igkis wakaymnibdi. Igkis kinetihwenes pawtak. Igkis awna: ―Mmah awitwak git inakni hiyakemniki nukune? Ig pekkis wapityempu akak madikte gikiythani. Juktah igkis wapityempu iha giwn. ");
INSERT INTO plu_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ayteke nikwe inakni inetit gidahan Kiyapwiye Jesus ibekhewpi muwwapu apit ini waxri Galiléyamnaw. ");
INSERT INTO plu_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ayteke ig Kiyapwiye Jesus pese agikutak ini leglis payak gikak amekene Tiyagumni gikak kiyapwiye João. Igkis tipik. Igkis danuh ta gipinekutkis kiyapwiye Simawh Pedru gikak kiyapwiye André. ");
INSERT INTO plu_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ayge igkis uté kiyapwiye Simawh Pedru gimatru egme harit akak nawwaki. Nerras hiyeg ayge amnihswe git Kiyapwiye Jesus gudahan. ");
INSERT INTO plu_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ig Kiyapwiye Jesus hiyapni henne, ig atere gut. Ig sumuh guwak. Ig kannikasepru. Aynewa gunawan mpiye guw. Ayteke nikwe eg kuwegwano gidahankis. ");
INSERT INTO plu_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ayteke msanpi, wahanbuku kamuw, kaayhsima hiyeg danuh atere git Kiyapwiye Jesus. Igkis waxe git kaayhsima hiyeg kakahribdapye gikakkis hiyeg wapityewnapye. ");
INSERT INTO plu_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kaayhsima hiyeg ayta iwasapri apititak ini paytwempu. Igkis pahadgupu anumeku payt alappota. ");
INSERT INTO plu_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Igme makniwe kaayhsima hiyeg ku pariye kakahribdapye akak arakembetnene karayt. Hawwata ig pekkise kaayhsima wapitye gipititakkis hiyeg. Ig ka isaksa ignes wapitye adahan igkis awna awaku igkis hiyaknig ku pariye ig. ");
INSERT INTO plu_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Hewke kabeyweke ig Kiyapwiye Jesus kannikaw, ig tipik aparayewa ku kiney yumanene hiyeg. Ayge ig piriyepkewne. ");
INSERT INTO plu_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Igme kiyapwiye Simawh Pedru gikakkis nerras hiyeg ku pariye ayge gikak igkis ipegepri. ");
INSERT INTO plu_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ayteke igkis utepri. Igkis awna ta git: ―Kaayhsima hiyeg piperepten. ");
INSERT INTO plu_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Igme Kiyapwiye Jesus kaytwa giwnkis: ―Uyay tipik tahhan apitit nawenépwi paytwempu akiw adahan nah ekkene Uhokri giwn aygwata. Adahanikwa ini nah awahkiska atan. ");
INSERT INTO plu_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ayteke nikwe ig wew muwwapu Galiléyamnaw. Ayge ig ekkene Uhokri giwn agiku judeyenepwi gileglisakis. Hawwata ig pekkis wapitye gipititakkis hiyeg. ");
INSERT INTO plu_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Apim ini pahapwi awayg danuh atere git. Ig axpusakare apit busukne. Ig paberetusaw ta gitiput. Ig amnihswene git. Ig awna: ―Kiyapwiye, uyá amnihun. Ku pis muwaka piyihun pis hiyá numakniwka. ");
INSERT INTO plu_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ig Kiyapwiye Jesus hiyapni henne, ig kayah gidahan. Ig sarayh giwak ta gipitit. Ig daxwig atere. Ig awna git: ―Ihi. Nah muwaka. Pis makniw. ");
INSERT INTO plu_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Aynewa gibuskana miypi. Ig barewpit msekwe. ");
INSERT INTO plu_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ayteke ig Kiyapwiye Jesus awna git: ");
INSERT INTO plu_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Ataybiswanaba nuthu. Ka ba kinetihwa ta arit hiyeg apigkuya ahin amin ku samah pis makniw. Su atak wadé gimkanit muwpeg. Akkanaba pipit ta git kahadbe ig iwasap ig hiyá ku pis makniw. Ayteke pis keh ofan gidahan Uhokri adahan ig wiwhpiye pipathawni ku samah amekene Moís ayá wot minikwak, adahan arekhetni ta gitkis hiyeg ku pis inyerwa makniw. Pisenwa ig awahkiswig tipik. ");
INSERT INTO plu_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Igme timapni henne, ig tipik. Ig ekkewpiye muwwapu ku samah ig makniw kuwis. Inakni ginetni ibekhewpi, nikwe ka ik adahan Kiyapwiye Jesus danuh ta apitit pahanama paytwempu. Henneme ig msakwa aparayewa ariw paytwempu ku kiney yumanene hiyeg. Ayge kaayhsima hiyeg danuh atere git. Igkis pes apititak madikte waxri. ");
INSERT INTO plu_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ayteke ariwnteke aynessa hawkri akiw, ig Kiyapwiye Jesus diyuhe ta apitit paytwempu Kafarnawh. Ayge nikwe hiyeg kinetni gak ku ig ay gipineku. ");
INSERT INTO plu_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ayteke nikwe kaayhsima hiyeg pahadguhwa atere. Igkis ba gikebentenkis yuma iwetrit gidahankis iné agiku payt iné anumeku alappota. Igme Kiyapwiye Jesus ayge ekkene Uhokri giwn ta gitkis. ");
INSERT INTO plu_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Apim ini paxnika gikebyikis hiyeg danuh atere, igkis ayta waxwenes pahapwi awayg miyapupye ta gimkat Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Igkis ka hiyá igkisma danuh ta gipetunat Kiyapwiye Jesus awaku ba akebentenwa hiyeg ayge. Igkis hiyapni henne, igkis hiyak ku pariye igkis keh. Igkis wagehe ta inut ta amadgat payt ahigwi. Ayge igkis wiwhe apettak payt. Igkis keh pahayku miyokwiye gipitmin Kiyapwiye Jesus. Pisenwa igkis wiwhkise ner miyapupye agiku miyokwiye peyeke akak gisipamna. ");
INSERT INTO plu_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ig Kiyapwiye Jesus hiyapni henne ku samah gikamaxwankis ta gipitit, ig awna ta git awayg miyapupye. Giwn: ―Nukebyi, nah bayahminap ariw pitaraksan gikak Uhokri. ");
INSERT INTO plu_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Apiminewa ini kaayhsima kannuhekeputnepwi amin amekene Moís gikumadukan igkis batebdebdihpi ayge. Gaytakkis timapni inakni Kiyapwiye Jesus giwn, igkis awna gimin apit giyaknikis. Giwnkis: ");
INSERT INTO plu_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","―Mmahki ner awayg awna inakni henne? Yuma pahapwinama hiyeg hiyá ubayamnihkawiy ariw utaraksanwiy gikak Uhokri. He ignenwa Uhokri hiyá ubayamnihkawiy. Ig miyathene Uhokri ku samah ig awna inakni henne. ");
INSERT INTO plu_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Igme Kiyapwiye Jesus kateksan apit giyakni ku igkis pukuhpaw gibohri. Ig hiyapni henne, ig awna ta gitkis: ―Mmahkay yis pukuhpaw nubohri henne? ");
INSERT INTO plu_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Mmah yipewkan ku in mahiko ndahan nah bayahmina ig awayg miyapupye ariw gitaraksan? Ku yis hiyá nah hiyá gikankasak nah keh ig kidis gisipamna ig wew akiw, ininkata akiw nah ka dat adahan nah bayahminig ariw gitaraksan? ");
INSERT INTO plu_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nah hiyapkiste yit ku nah ku pariye wageswe awayg amadgaya inin nahnewa detye amadga inin adahan nah bayahminene hiyeg ariw gitaraksankis gikak Uhokri. Ayteke ig awna ta git ner awayg miyapupye. Giwn: ");
INSERT INTO plu_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Kannikaw. Kidis pisipamna. Hiyawa pis diyuhe pipinwate. ");
INSERT INTO plu_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Aynewa ig awayg kannikaw, ig iwé gisipamna. Ig tipik wew giwtrikneswa hiyeg. Igkisme hiyapni henne, igkis wakaymnibdi. Igkis kabayha Uhokri. Igkis awna: ―Usuh ka hiyapti akebyi ini. Kabahte usuh ka ihpin. ");
INSERT INTO plu_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ayteke ig Kiyapwiye Jesus pese paytrikutak. Ig tipik ta mahakwa akigbite. Kaayhsima hiyeg pahadguhwa atere ganwat. Ig hiyapni henne, ig gikannuhtenkis ayge. ");
INSERT INTO plu_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ayteke ariwnteke ini ig tipik waywe apigku ahin. Ayge ig hiyá kiyapwiye Levi, ku pariye amekene Alfew gikamkayh. Igme betnene agiku payt ahiwket karukri. Ig ladwan, ig ahiwne karukri gidahan gupelma. Igme awna git: ―Ba ayta wew nukakhu adahan pis humewne nukannuhni. Igme timapni henne, ig kannikew, ig tipik gikak. ");
INSERT INTO plu_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ayteke ig Kiyapwiye Jesus danuh ta gipinekut kiyapwiye Levi. Ayge ig axne gikak. Kaayhsima ladwan danuh atere payak gikakkis hiyeg akiw ku pariye ikaka kane kibeynepwima hiyeg. Igkis hawwata ax gikak Kiyapwiye Jesus gikakkis gikannuhnipwi. Igkis kaayhsima hiyeg. Igkis gibetkikis wew gikak. ");
INSERT INTO plu_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Nerras kannuhekeputnepwi amin amekene Moís gikumadukan ku pariye farisewkis igkis hiyapni henne ku ig axne gikakkis ladwan gikakkis hiyeg ku pariye ikaka kane kibeynepwima hiyeg, igkis hiyapni henne, igkis awna ta gitkis gikannuhnipwi. Giwnkis: ―Mmahka ig axne darihwekne gikakkis ladwan gikakkis hiyeg kane kibeynepwima hiyeg? Waké ig kibeyne hiyegbe, ig ka axkam gikakkis gikebyikis nerras hiyeg. ");
INSERT INTO plu_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ig Kiyapwiye Jesus timapni henne, ig kaytwa giwnkis. Ig awna ta gitkis: ―Hiyeg kane kibeynepwima ignes kewa hiyeg kakahribdapyebe. Igkis muwaka pahapwi ayta amnihgikis. Ignesme hiyeg makniwyepwi igkis ka muwaka mekseh. Ignesme hiyeg kakahribdapye igkis muwaka mekseh. Nah ka ayta adahan nah humeknema ku pariye hiyeg kibeynepwi kuwis adahan ignes wageswiyes gihiyakemnikis. Henneme nah ayta adahanikwa nah humekwiye nerras ku pariye taraksapye adahan ignes wageswiyes gihiyakemnikis. ");
INSERT INTO plu_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Apim ini amekene João Batista gikannuhnipwi igkis maxhewnes adahan igkis kiyenes Uhokri adahan igkis piriyepkewnes. Nerras farisewkis hawwata igkis maxhewnes. Ayteke nikwe hiyeg danuh ta git Kiyapwiye Jesus. Igkis awna git: ―Kiyapwiye João Batista gikannuhnipwi igkis maxhaw adahan igkis kiyenes Uhokri. Kibereput igkis maxhaw adahan igkis piriyepkewnes. Igkisme farisewkis gikannuhnipwi igkis hawwata akiw igkis maxhaw. Pisme pikannuhnipwi ka maxhaw. Mmahki igkis ka kiyatha Uhokri kema nerrasma? Mmah igkis ka kibeynewatma hiyeg kema nerrasma? ");
INSERT INTO plu_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Igme Kiyapwiye Jesus kaytwa giwnkis: ―Igkis ka maxhaw adahan nukiyetni mmanawa nah kupiknene ay gikakkis. Nah kehte abektey akak pahapwi awayg maripkewpiye. Ku aysaw ig maripkewpiye nikwe gikagmadapu ayta iwasa gimaripkawni. Ku samah ig ayge gikakkis abet ini fet ba igkis maxhaw? Kawa. Apim ini ku samah igkis kadahan ner awayg maripkewpiye ayge gikakkis igkis ka maxhaw. ");
INSERT INTO plu_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Henneme aysawnemenek ku aysaw nah iwepka giwkisnek nukannuhnipwi, apim ini nikwe igkis maxhawnek. ");
INSERT INTO plu_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ayteke ig Kiyapwiye Jesus keh nawenéwa abektey akiw. Ig awna: ―Ka kis adahan wis kahapa simis mugumugupiye akak nukune kamis mmanawa kamis nukune ku pariye kote sukuhte in ik adahan tariswa mmanawa in kote dahwate kema mugumugupiyema. Ku pahapwi kahapa gisimsa mugumugupiye akak nukune kamis, in tariswa. Gisimsa sigka pi kiyeste akiw. ");
INSERT INTO plu_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Kawnata kis adahan wis katiyha win nukune agikut pakir amar ayipwipye ipatmakupye. Mmanawa ku aysaw ini win tukurwa in kiyesihwa akiw, in pakir amar ka ahwa payak nikak. In bekwe awaku. Ayge nikwe ini win biyuke payak akak atiy. Amawka wis katiyha win nukune ta agikut pakir amar ku pariye mtibetnene. Nuhiyakemni kis gikakkis hiyeg ku pariye kote dahhate gihiyakemnikis. ");
INSERT INTO plu_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ayteke samdi abet ig Kiyapwiye Jesus tipik mpiye amadgew pahak was. Igkis gikannuhnipwi tipik gihapti. Igkis waywe ayge, igkis matise fahhin ariw, igkis axwig. ");
INSERT INTO plu_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nerrasme farisewkis hiyapni henne, igkis awna ta git Kiyapwiye Jesus: ―Ipeg nerras pikannuhnipwi. Mmahki igkis ka iha amekene Moís gikumadukan? Mmahki igkis kannipwiye abet samdi? ");
INSERT INTO plu_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Igme Kiyapwiye Jesus kaytwa giwnkis: ―Mmah yis kote ipegbohate Uhokri gannasan minikweknene ku kiney in kinetihwa amin ku pariye amekene Davi gikehni? Minikwak ig matipwe payak gikakkis gihaptiyepwi. Igkis yuma ariknawnama gimunkis. ");
INSERT INTO plu_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Nikwe ig pareke ta agikut Uhokri Gipin apim ini ku aysaw amekene Abiyatar muwpegpiyene gikiparakis. Ayge ig ax ini bugut ku pariye ekkepka ta gipetunat Uhokri. Hawwata ig ikepni ta gitkis gihaptiyepwi. Amekene Moís gikumadukan awna ku muwpegnenwa kis adahan ignes axnes ini bugut. Igkisme axni henneme igkis ka taraksa mmanawa ig muwpeg amnihpigkis. ");
INSERT INTO plu_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ayteke ig Kiyapwiye Jesus awna ta gitkis akiw. Giwn: ―Samdi humaw gidahankis hiyeg. Hiyeg ka humaw adahanma samdi. ");
INSERT INTO plu_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nah ku pariye wageswe awayg amadgaya inin nahnewa samdi akipara. ");
INSERT INTO plu_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ayteke ig Kiyapwiye Jesus tipik lammisya agiku judeyenepwi gileglisakis. Ayge pahapwi awayg kidubetwiye giwak. ");
INSERT INTO plu_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Igkisme nerras hiyeg ayge apuriw Kiyapwiye Jesus kabayhtiwa adahan igkis hiyá ba ig piyihgi abet samdi. Mmanawa igkis muwaka utí gitaraksan gikak amekene Moís gikumadukan adahan igkis gikamyehpitni. ");
INSERT INTO plu_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Igme Kiyapwiye Jesus awna ta git ner awayg kidubetwiye giwak. Giwn: ―Ba ayta atan. ");
INSERT INTO plu_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ayteke nikwe ig awna ta gitkis hiyeg. Giwn: ―Pariye amekene Moís gikumadukan ayá wotwiy adahan ku pariye wixwiy keh abet samdi? Ba adahan wixwiy kehne kabayka, ba kawk, ba adahan wixwiy kehne mbayka? Ba adahan wixwiy amnihne hiyeg, ba kawk, ba adahan wixwiy umahkisne hiyeg? Igkisme timapni henne, igkis tinwopu. ");
INSERT INTO plu_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Igme ipegpusa madikte hiyeg ayge. Ig ka batek ku samah gihiyakemnikis. Ig wakaymni ku samah igkis ka amnihkere ner awayg. Ayteke nikwe ig awna ta git ner awayg kidubetwiye giwak. Giwn: ―Taraknaba piwak. Igme tareke giwak. Aynewa giwak makniw. ");
INSERT INTO plu_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Igkisme nerras farisewkis hiyapni henne, ku Kiyapwiye Jesus piyihpig abet samdi, igkis awna: ―Aa. Ig ka kiyatha samdi. Ik adahan ig taraksase kaayhsima hiyeg. Pugamawka ig umehpika. Nikwe igkis pes ayteke, igkis ahegbete ginetnikis gikakkis amekene Erodis gihiyegapu adahan igkis giwmasepten Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Igme Kiyapwiye Jesus hiyapni henne, ig tipik akigbite mahakwa. Gikannuhnipwi tipik gihapti. Hawwata akiw pahabunene hiyeg aytontak Galiléyamnawtak igkis kuruwkehe gihapu butte payak gikakkis hiyeg aytontak Judeyamnawtak, ");
INSERT INTO plu_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","aytontak Jerusalémtak, aytontak Idumeyamnawtak, aytontak warik Jordawh, aytontak paytwemputak Tiru akak Sidoh. Igkis kaayhsima hiyeg. Igkis kuwis timé gak ku samah ig keh kaayhsima annut. Nikwe igkis tipik iwasapri. ");
INSERT INTO plu_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Igme Kiyapwiye Jesus awna ta gitkis gikannuhnipwi. Giwn: ―Kaayhsima hiyeg ay. Ik adahan igkis dehekwen. Ahegbetnabay ndahan umuh. ");
INSERT INTO plu_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Mmanawa ig makniwenene kaayhsima hiyeg. Ayge nikwe madikte hiyeg ku pariye kakahrapye igkis mpiksewnekwiyes adahan gidaxten. ");
INSERT INTO plu_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Nerrasme ku pariye wapityewnapye, pase igkis hiyapri igkis tuguhkiswa mabuw gitiput. Igkis kabiman git: ―Pisnewa Uhokri gikamkayh. ");
INSERT INTO plu_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Igme timapni henne, ig awna ta gitkis: ―Ka ba yi akkan ku pariye nah. ");
INSERT INTO plu_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ayteke ariwnteke ini ig Kiyapwiye Jesus wagehe ta apitit pahá waxri imuwadnene. Ayge ig pahadguhe ku pariye hiyeg ig muwaka. ");
INSERT INTO plu_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Igkisme danuh atere git. Ayge nikwe ig kaniybete gaytakkis madikawku gikebyikis gikakkis piyana gawnakis (12) adahan igkis wewnes gikak. Hawwata adahan igkis awahkiska adahan igkis ekkenes ginetni muwwapu. ");
INSERT INTO plu_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Apim ini ig iké kumadukaki gitkis adahan igkisme pekkiswiyes wapitye gipititakkis hiyeg. ");
INSERT INTO plu_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Nah akkite yit giwkis nerras madikawkunene gikebyikis gikakkis piyana gawnakis (12): kiyapwiye Simawh ku pariye ig kuwis sarayh giw Pedru, ");
INSERT INTO plu_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","amekene Tiyagumni, gisamwi kiyapwiye João. Igkis amekene Zebedew gikamkayupwi. Igme Kiyapwiye Jesus sarayh giwkis “Boanerjes”. Inakni wownaprikwiy “Diridriyan”, ");
INSERT INTO plu_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","kiyapwiye André, kiyapwiye Filip, kiyapwiye Bartolomew, kiyapwiye Matews, kiyapwiye Tomé, kiyapwiye Tiyagu ku pariye amekene Alfew gikamkayh, kiyapwiye Tadew, kiyapwiye Simawh Zeloti, ");
INSERT INTO plu_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Iskariyotismin ner kamaykistinene Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ayteke ig Kiyapwiye Jesus tipik ta gipinwate. Ayge nikwe nerras hiyeg pahadguhwa atere git akiw. Apim ini ig Kiyapwiye Jesus gikakkis gikannuhnipwi igkis ka kahawkan adahan igkis ax awaku ba gikebentenkis hiyeg. ");
INSERT INTO plu_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ku aysaw gikebyupwi timé gak henne, igkis tipik iwepri mmanawa hiyeg kinetihwene gimin ku ig kuwis biyukse gihiyakemni. ");
INSERT INTO plu_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Apim ini nerras kannuhekeputnepwi amin amekene Moís gikumadukan igkis ayta apititak Jerusalém, igkis danuh atere ku kiney Kiyapwiye Jesus piyihne hiyeg. Igkis awna ta gitkis hiyeg: ―Ig pekkis wapitye gipititakkis hiyeg akak wapitye gikiparadkis gannu ay gipit. Igwa Belzebu ay gipit. ");
INSERT INTO plu_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ig Kiyapwiye Jesus hiyapni henne, ig pahadguhe nerras hiyeg ta gimkanit. Ig kinetihwa ta gitkis akak yuwit patuwesbuhka. Ig awna: ―Ig Satanás ka hiyá igma pekkis gidahanwa gihiyegapu wapitye gipititakkis hiyeg. ");
INSERT INTO plu_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ku hiyeg apitya pahanene waxri ku igkisweke kerbetpikis, igkis ka ayipwi akiw. ");
INSERT INTO plu_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Pakebyekne hawwata, ku igkisweke kerbetpikis, igkis kawnata ayipwi akiw. ");
INSERT INTO plu_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Wapitye hawwata. Waké ig Satanás siguh gidahanwa gihiyegapu wapityebe, ig ka ayipwikam. Ig pisenwakam akak gikumadukan. ");
INSERT INTO plu_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Nah kehte abektey akak pahapwi ku pariye parekkere ta gipinekut pahapwi hiyeg detye adahan ig kidisne gewkanbet atere. Apit ig parak atere amawka ku ig wanakminanete ner hiyeg detye. Pisenwa nikwe ik adahan ig parak atere kidis ku pariye ay gimun. Hennewa nah keh gikak wapitye gikiparadkis. ");
INSERT INTO plu_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","―Ik adahan Uhokri bayahmina hiyeg ariw madikte gitaraksankis ariw madikte miyathaki. ");
INSERT INTO plu_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Henneme ku ignes ka kiyatha Uhokri Gitip, nikwe ka hiyá igma bayahminigkis ariw ini gitaraksankis. Mmanawa ku pahapwi ka kiyatha Uhokri Gitip, nikwe ka ik adahan ig Gitip dax apit giyakni adahan ig wages gihiyakemni. Nikwe ig ner msakwa akak ini gitaraksan adahan apanenekwa. Ihanabay inakni nuwnhu. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ig Kiyapwiye Jesus awna inakni mmanawa igkis kinetihwa gimin ku wapitye ay gipit. ");
INSERT INTO plu_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ayteke ig Kiyapwiye Jesus ginag gikakkis gisamwipwi egkis danuh atere. Egkis msekwe kabaywak. Aytontak kabaywaktak egkis wasapanaw gimin Kiyapwiye Jesus adahan ig ayta gumkatkis. ");
INSERT INTO plu_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ayge kaayhsima hiyeg batebdebdihpikis ganwa. Igkis hiyapni henne, igkis awna git: ―Kiyapwiye, pinag ay kabaywak gikakkis pisamwipwi. Egkis watihap. ");
INSERT INTO plu_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Igme Kiyapwiye Jesus kaytwa giwnkis: ―Pariyeki nnaghu? Pariyeki nusamwipwi? Nah akkite yit. ");
INSERT INTO plu_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ayteke ig ipegpusa nerras hiyeg batebdebdihpi ayge ganwa. Pisenwa ig awna: ―Ipegnay ayta. Norrasnewa ku pariye nnaghu. Nerrasnewa ku pariye nukebyupwi. ");
INSERT INTO plu_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Mmanawa ku pariye hiyeg kehnenepwi Uhokri gibetki, ignes nah ikiygikis ke nukebyupwibe, egnesme tinogben nah ikiygukis ke nnaghube. ");
INSERT INTO plu_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ayteke ariwnteke ini ig Kiyapwiye Jesus tipik mahakwakigbit. Ig danuh atere, ig gikannuhtenkis hiyeg akiw. Kaayhsima hiyeg kiyaran ganwa. Ig hiyapni henne ig sarayhwa muhumdakat adahan igkis ka dehegbetig. Ayge ig batahkiswe. Ig gikannuhtenkis hiyeg ayteke gumadgatak umuh. Igkisme hiyeg msekwe tabirbet waxrihbak. ");
INSERT INTO plu_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ayteke ig kinetihwa ta gitkis akak kaayhsima yuwit patuwesbuhka. Ig gikannuhtenkis, ig awna gitkis: ");
INSERT INTO plu_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Ataybiswanabay nuthu. Minikwak pahapwi awayg tipik giwasra amedgete adahan ig sessehne gamutra ayak. ");
INSERT INTO plu_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ig sessehne gamutra ayak, gaytakkis tuguhe apigku ahin ku kiney wayk adani. Ayteke nikwe kuhipra ayta axahpeprukis. ");
INSERT INTO plu_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Gaytakkisme gamutra ayak tuguhe abetit tipebdi ku kiney ka kiyesradima wayk. Egnes gamutra ayak hiyenpiwatkama kibentenwa mmanawa egkis ka mutuhwa mihadima awaku wayk ka kahogbi. ");
INSERT INTO plu_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Kamuw inutpi, awehe gamutra. Aynewa egnes huruhrup mmanawa gahampabet he inuwew. ");
INSERT INTO plu_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Gaytakkisme gamutra ayak tuguhe apuwit pudukupwi. Egnes pudukupwi hiyenpi payebitak akak gamutra. Egkis tuwathe gamutra juktah egkis miyorap. Nikwe egkis gamutra ka sarayh guwkis aynesnima. ");
INSERT INTO plu_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Gaytakkisme gamutra ayak tuguhe abetit kibeyne wayk. Ayge egkis hiyan. Egkis gamutra aymuhwa juktah egkis kew. Egkis sarayh kaayhsima guwkis. Gaytakkis kew mpana madikwa gukebyikis (30). Gaytakkisme kew puguhkuna madikwa gukebyikis (60). Gaytakkisme kew sah gukebyikis (100). ");
INSERT INTO plu_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Pisenwa inakni gawnhan, ig Kiyapwiye Jesus awna akiw. Giwn: ―Yis ku pariye katayebnene, ataybiswanabay numkanit. ");
INSERT INTO plu_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ayteke ariwnteke ini ig Kiyapwiye Jesus igwo gikakkis giwatnipwi gikakkis aynessa hiyeg ayge ganwa akiw. Apim ini igkis hiyeg ayapri: ―Kaminki pis awna inakni yuwit patuwesbuhka? ");
INSERT INTO plu_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Igme kaytwa giwnkis: ―Hiyeg amadgayapu inin ignes kote hiyakte ku samah Uhokri gikumadukan. Yisme Uhokri akkamnihni ta yitnek. Igkisme ka akkaka ta gitkis. Ta gitkis nah awna patuwesbuhkanen yuwit. ");
INSERT INTO plu_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Hiyawa igkis ikí gitewkis nimkanit kabayhtiwa henneme ka paduk ta gitiwgikutkis. Hiyawa igkis ataybiswa nit kabayhtiwa henneme igkis ka pukuhpin. Ayge nikwe igkis ka wages gihiyakemnikis adahan igkis bayahminaka ariw gitaraksankis. ");
INSERT INTO plu_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ayteke ig awna gitkis: ―Mmah yis ka pukuh inakni nuwnhu patuwesbuhka ku pariye kane mahikonene? Mmah nikwe apukapka yit madikte nuwnhu ku pariye pi mahikotenene? Ka sam. Nah akkamnihte yit inakni nuwnhu. ");
INSERT INTO plu_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ner awayg ku pariye sessehne gamutra ignebaki arakak gidahan pahapwi ku pariye ekkene Uhokri giwn ta gitkis hiyeg. ");
INSERT INTO plu_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Gaytakkis hiyeg ku pariye timap inakni giwn ignes ke innebe ahinbe. Pase igkis timap Uhokri giwn aynewa ig Satanás danuh atere gitkis. Ig wiwhpiye inakni giwn abetitak gihiyakemnikis. ");
INSERT INTO plu_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Egnesme no amutri ayak ku pariye tuguhe ta abetit tipebdi innebaki arakak gidahankis hiyeg ku pariye timá nuwnhu igkis amapin kibentenwa akak madikte gibetkikis. ");
INSERT INTO plu_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Henneme igkis ka kamax inakni nuwnhu kabayhtiwatma abet gihiyakemnikis. In humaw kewa pahakti amutribe ku pariye yumanano guhampabet eg ka dep miyó. Igkis batek akak nuwnhu adahan aynessa hawkri. Ayteke pase igkis hiyá mbeyne nipatra, aynewa igkis miniwpi niw. Ku aysaw hiyeg mahipwihpigkis nipatra, igkis diyuhkiswe butte. ");
INSERT INTO plu_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Egnesme no amutri ayak ku pariye tuguhe ta abetit pudukupwi, innebaki arakak gidahankis hiyeg ku pariye timá Uhokri giwn igkis amapin. ");
INSERT INTO plu_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Henneme igkis pi ikatuswete adahan arikna amadgaya inin. Igkis kinikiswe arit igiska amadgaya inin. Igkis miyarhaw aharit arakembet arikna mapiy giw Uhokri. Ayge nikwe Uhokri giwn mpithaka abet gihiyakemnikis. Igkis ka kannuhwa keh Uhokri gibetki. Amun ini nikwe igkis hiyeg humaw waditnepyenen ke pahakti amutribe ku pariye kane kew. ");
INSERT INTO plu_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Egnesme no amutri ayak ku pariye tuguhe ta abetit waxri kibeyne waxri, innebaki arakak gidahankis hiyeg ku pariye timá nuwnhu, igkis amapin. Igkis keh Uhokri gibetki nikwe. Gaytakkis hiyeg keh Uhokri gibetki kabayhtiwa. Ignes humaw kewa amutribe ku pariye kew mpana madikwa gukebyikis (30). Gaytakkisme hiyeg humaw kewa amutribe ku pariye kew puguhkuna madikwa gukebyikis (60). Gaytakkisme hiyeg humaw kewa amutribe ku pariye kew sah gukebyikis (100). ");
INSERT INTO plu_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ayteke ig Kiyapwiye Jesus awna gitkis akak nawenéwa yuwit patuwesbuhka akiw. Giwn: ―Nuwnhu kewa pahow lalampbe adahan in uguhne hiyeg gihiyakemnikis. Wis ka hakis lalamp adahan wis asabkeptenma anapi suwyeg. Iné wis ka hakisru adahan wis ayempitnima ta anapit payt abukapayni. Kawa. Wis ikigu ta inut akekrit. ");
INSERT INTO plu_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Aysawnemenek madikte ku pariye ayempiki in kahayaknek. Inakni nuwnhu patuwesbuhka aysawnemenek in kahayak kabayhtiwanek. ");
INSERT INTO plu_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Yis ku pariye katayebnene, ataybiswanabay numkanit. ");
INSERT INTO plu_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ayteke ig awna ta gitkis: ―Ikinay yitew ta nuthu kabayhtiwa. Ku yis pi ikte yitew ta nuthu, yis pi darihte nuhiyakemni akiw. Yis darihni mpiynepepye akiw. ");
INSERT INTO plu_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Mmanawa ku pahapwi darih nuhiyakemni kabayhtiwa, nikwe ig Uhokri akki git pi kiyeste akiw. Henneme ku pahapwi ka darih nuhiyakemni kiyesradima, nikwe ini nuhiyakemni wiwhpikanek abetitak gihiyakemni. ");
INSERT INTO plu_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ayteke ig Kiyapwiye Jesus awna nawenéwa yuwit patuwesbuhka akiw. Giwn: ―Nah akkite yit pahat abektey amin ku samah Uhokri gikumadukan. Minikwak pahapwi awayg mutuhe gamutra ayak amadga giwasra. ");
INSERT INTO plu_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ayteke egnes gamutra hiyan, egkis aymuhwa takunipti, ig ka hiyak ku samah. Ku samah ig himeknete egkis aymuhwa. Ku samah ig ipegnete egkis aymuhwa hawwata. ");
INSERT INTO plu_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Egkis aymuhwa guwntekneswa abetitak wayk. Pitatye gapankis tarakwa, ayteke egkis kapuwri, pisenwa egkis sarayh guwkis. ");
INSERT INTO plu_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ayteke ku aysaw gupatyaprikkis danuh, aynewa ig awayg ig iwé gikaswaga, ig hiwhpigkis. ");
INSERT INTO plu_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ayteke ig Kiyapwiye Jesus awna ta gitkis hiyeg akiw. Giwn: ―Mmah nuwnhu kuri adahan nah akki yit ku samah Uhokri gikumadukan? Pariye yuwit patuwesbuhka ik adahan nah kawih? ");
INSERT INTO plu_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Uhokri gikumadukan aymuhwa amadga inin ke amutri “mostadbe”. Ku aysaw “mostad” ayak mutuhka abetit wayk eg nopsesniyo. ");
INSERT INTO plu_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Eg pi isite ayak ariw madikte amadga inin. Henneme ku aysaw eg hiyan, eg pi wadiswete ariw madikte ipeybet. Gutawna humaw nopsad. Juktah ik adahan kuhipra kibhaw ta gupewit abet gupan gumisnapyi. ");
INSERT INTO plu_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ayteke ig Kiyapwiye Jesus akki Uhokri giwn ta gitkis nerras hiyeg akak kaayhsima yuwit patuwesbuhka akiw. Ig akkin gitkis madikte ku pariye igkis ik adahan amapin. ");
INSERT INTO plu_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ig ka awnati ariknawnama ta gitkis huwewe. Ig he kinetihwa akak yuwit patuwesbuhkanen. Henneme ku aysaw igwo gikakkis gikannuhnipwi ig akkamnihni madikte gitkis. ");
INSERT INTO plu_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Abetnewa ini hawkri aygete kuwis, ig Kiyapwiye Jesus awna ta gitkis gikannuhnipwi. Giwn: ―Uyay manuke ta pahambakaytak mahakwa. Igkisme kaytwa giwn: ―Uyay. ");
INSERT INTO plu_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Igkis ekkewpiyes gitkis madikte hiyeg aygnenepwi. Ayteke igkis iwepri payak gikakkis amadga umuh mmanawa igme kuwis ayge gumadga. Hawwata akiw nawenépwi hiyeg gihmunkis ayge gikak. ");
INSERT INTO plu_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Igkis ku ayhté pakwa amadga mahakwa, pahaye adahan mayg kannikaw gimkanitkis, kaayhsima paraw katapte amadgat gihmunkis. Gihmunkis me buwisemet. ");
INSERT INTO plu_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Henneme ig Kiyapwiye Jesus abugik umuh, ig himeke ayge abet itiwwepwit. Igkis gikannuhnipwi hiyapni henne, igkis atere wadiswig. Igkis awna git: ―Kiyapwiye, uyá amnih usuh. Mmah pis ka aminama usuh? Wixwiy me biyukapmet. ");
INSERT INTO plu_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Igme wadise, ig himehe mayg, ig awna ta arit paraw. Giwn: ―Asá msakwa. Tinwohaw. Aynewa mayg tinwohew. Paraw mapawanew. ");
INSERT INTO plu_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Nikwe ig kaytwa giwnkis: ―Awaykemni apisatrupye! Mmahki yis ba yapisa tugun? Mmahki yis ka kamaxwa ta gipitit Uhokri? ");
INSERT INTO plu_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Igkis gikannuhnipwi hiyapni henne, igkis wakaymnibdi gidahan. Igkis kinetihwa pawtak. Igkis awna: ―Pariyeneki ner hiyeg? Juktah mayg akak paraw iha giwn. ");
INSERT INTO plu_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ayteke pisenwa igkis hamah pahambakat igkis minahwa atere apitit giwaxrikis hiyeg gadarayenepwi. ");
INSERT INTO plu_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Igme Kiyapwiye Jesus sarayhwe waxrit. Ayge pahapwi awayg wapityewnipye atere patiptakig. Ig pes abetitak imewti. ");
INSERT INTO plu_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ig awayg msakwa ayge apuheket. Hiyeg ka hiyá giwankaminka juktah akak xen. ");
INSERT INTO plu_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Mmanawa takunipti igkis wanakminape gibagwan akak giwan akak sipari akak xen henneme ig matisbetepni madikte. Yuma pahapwinama hiyeg hiyá gisamanak. ");
INSERT INTO plu_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Mataytak, hewke tiyegim ig wewpari muwwapu apuheketiw, muwwapu waxribdiw. Apanenekwa ig kabiman, ig huwipwihtewpi akak tip. ");
INSERT INTO plu_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Pase ig hiyé Kiyapwiye Jesus piyawakad, ig sigise atere gimin, ig paberetusaw ta gitiput. ");
INSERT INTO plu_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ig kabiman git akak gihawna. Giwn: ―Aa, Kiyapwiye Jesus. Pis Uhokri gikamkayh inugikyene. Pariye pimawkan ta nuthu ku apim inin? Uyá amnihun gidahan Uhokri. Ka ba hiyapkis mbeyne nuthu. ");
INSERT INTO plu_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ig awna inakni yuwit henne mmanawa ig Kiyapwiye Jesus kuwis pekkiswiye ner wapitye mbeyepye ayta gipititak. ");
INSERT INTO plu_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ayteke nikwe ig Kiyapwiye Jesus ayapri: ―Mmah piw? Igme kaytwa giwn: ―Nuwhu “Pibohram”. Mmanawa usuh wapityempu kaayhsima ay gipit. ");
INSERT INTO plu_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ayteke ig amnihswa ta git Kiyapwiye Jesus akiw. Ig awna ta git: ―Ka ba arewepma wothu awahkiswima usuh piyawakad ariwntak inin iwetrit. ");
INSERT INTO plu_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ayge pahabunene pakirempu axwenekis apit pahá waxri imuwadnene. ");
INSERT INTO plu_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Igkis wapityempu hiyapni henne, igkis ayá git Kiyapwiye Jesus: ―Uyá awahkis usuh tahhan gipititkis pakirempu. Isaksanaba usuh parak ta gipititkis. ");
INSERT INTO plu_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Igme Kiyapwiye Jesus isakseprikis. Ayteke nikwe nerras wapityempu mbeyepye igkis pesbetwikis gipititak ner awayg. Igkis pareke ta gipititkis ignes pakirempu. Nerras pibohramnene pakir igkis piyana mil (2.000) gikebyikis. Igkisme wapityempu parekwigkis, igkisme pakirempu sigisbetwikis ta asebrikute. Igkis tubohbetwikis ta ahakwate mahakwa. Ayge igkis aniksewbet ahakwa mahakwa. ");
INSERT INTO plu_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Pakirempu gikapriwtenkis igkis hiyapni henne, igkis sigisbet kibentenwa ta paytwempuit. Igkis danuh atere, igkis kinetihwa nimin muwwapu paytwempuriw muwwapu iwetrit aranwa paytwempu. Nerras hiyeg paytwempuyenepwi timapni henne, igkis tipik atere adahan igkis hiyepnes ku pariye danuh. ");
INSERT INTO plu_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Igkis danuh atere git Kiyapwiye Jesus, igkis uté ner awayg ku pariye kuwisnene makniw ariw wapityempu. Igme bat ayge. Ig kasimsapu kuri. Gihiyakemni diyuh adukwenewa akiw. ");
INSERT INTO plu_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Igkis hiyapni henne, igkis apisasew. Nerras ku pariye hiyepnepwi madikte ku pariye kehka gikak ner awayg igkis kinetihwa ta gitkis nerras hiyeg amin madikte ku pariye danuh ta git ner awayg gikakkis nerras pakirempu. ");
INSERT INTO plu_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Igkis timapni henne, igkis awna git Kiyapwiye Jesus: ―Su tipik aytekihan apititak uwaxri. ");
INSERT INTO plu_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Igme katapte amadgat gihmun. Igme ner awayg ku pariye kuwisnene makniw ariw wapityempu, ig awna ta git: ―Nah ataka pihapti. ");
INSERT INTO plu_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Igme Kiyapwiye Jesus awna git: ―Pi kabayte pis msakwa ay. Su ataknate ta pipinwat ta gitkis pikebyupwi. Kinetihwanaba gitkis amin madikte ku samah Uhokri keh pikak ku samah ig amnihpep. ");
INSERT INTO plu_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Igme awayg timapni henne, ig tipik ta apitit paytwempu Dekápolis. Ig danuh atere ig kapusa kinetihwa ta gitkis madikte hiyeg aygnenepwi amin ku samah Kiyapwiye Jesus keh gikak. Igkisme wakaymnibdi kaayhsima. ");
INSERT INTO plu_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Igme Kiyapwiye Jesus manuke pahambakat mahakwa akiw amadga umuh. Ig danuh atere, ig utí kaayhsima hiyeg pahadgupu adahan igkis patiptakig ayge akigbimna mahakwa. ");
INSERT INTO plu_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ayteke pahapwi awayg danuh atere git Kiyapwiye Jesus. Giw Jayru. Ig leglis akipara, judeyenepwi gileglisalis. Ig hiyapri, ig paberetusaw ta gikimpuit. ");
INSERT INTO plu_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ig awna git: ―Kiyapwiye, uyá amnihun. Nukamkayh mihenapyo pahayempi guyekwin. Ba ayta sarayh piwak ta gupitit kahadbe eg makniw eg ka miyó. ");
INSERT INTO plu_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ig Kiyapwiye Jesus timapni henne, ig tipik gihapti. Kaayhsima hiyeg tipik gihapti. Ig waywe dahebdi gikakkis. ");
INSERT INTO plu_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ayge nikwe pahapu tino danuh gihapu butte. Eg kuwis hiyá mbeyne akak guminewkan adahan kaayhsima kamukri, madikawkubu akebyi akak pikana arawna (12). ");
INSERT INTO plu_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Eg hiyá mbeyne ay giwakukis kaayhsima mekseh kuwis. Eg sarayhe gukakura madikte adahan gikatiwnihpitnikis. Henneme eg kote makniwte. Guwskawni pi mbayte ariw pitatye. ");
INSERT INTO plu_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Eg kinetni Kiyapwiye Jesus gak. Nikwe eg danuh atere giharaptak gibetimpikis nerras hiyeg, adahan eg dax gisimsa. ");
INSERT INTO plu_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Mmanawa eg awna gunaktin: ―Ku nah he daxpi gisimsa, ikeypi, nah makniw. ");
INSERT INTO plu_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Eg danuh atere, eg daxwin. Aynewa guminewkan matiswe. Eg kayah ku eg kuwis makniw ariw gukahri. ");
INSERT INTO plu_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Igme Kiyapwiye Jesus kayah ku gidatni pes aynessa ku samah ig makniwepru. Ig hiyapni henne, ig wagestaw ayge gibetkis hiyeg. Ig awna: ―Pariye dax nukawihni? ");
INSERT INTO plu_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Igkisme gikannuhnipwi awna git: ―Kiyapwiye, ka ba pis hiyá kaayhsima hiyeg daykegbetpi pikak? Mmahki pis awna: “Pariye daxwen”? ");
INSERT INTO plu_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Igme ipegpari gupegepten gidaxten gikawihni. ");
INSERT INTO plu_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Eg tino hiyapni henne ku eg makniw kuwis, eg danukwa atere git. Eg apisasew. Eg serke. Eg paberetusaw ta gitiput. Eg akki git makisute. ");
INSERT INTO plu_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Igme awna gut: ―Nukebyi, pis makniw mmanawa pis kamaxwa ta nupitit. Hiyawa pis diyuhe pipinwate akak kabayka. Pis makniw ariw pikahri. ");
INSERT INTO plu_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ku samah ig Kiyapwiye Jesus awnempiye inakni yuwit henne, aynessa hiyeg danuh atere. Igkis ayta gipinwatak ner leglis akipara. Igkis atere ewk inetit git. Igkis awna git: ―Pikamkayh ayipa miyop. Ka muwaka wewkis ukannuhtenwiy waditnepyenen. ");
INSERT INTO plu_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Igme Kiyapwiye Jesus ka aminama ariw inakni giwnkis. Ig awna ta git leglis akipara. Giwn: ―Ka muwaka apis. Kamaxwanaba ta nupitit. ");
INSERT INTO plu_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ig ka isaksa pahapwinama hiyeg tipik gihapti. Ignesnenwa kiyapwiye Pedru gikak amekene Tiyagumni gikak kiyapwiye João ku pariye amekene Tiyagumni gisamwi igkiswonas tipik gihapti. ");
INSERT INTO plu_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ayteke ig Kiyapwiye Jesus danuh atere gipinekut ner awayg leglis akipara. Ayge ig hiyá kaayhsima hiyeg kadukman. Igkis tihenekwiyes, igkis kadniyes guharit no bakimni kaayhsima. ");
INSERT INTO plu_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ig hiyapni henne, ig parak atere, ig awna gitkis nerras hiyeg: ―Mmahki yis kadukman? Mmahki yis tih? No bakimni ka miyó. Himak eg. ");
INSERT INTO plu_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Igkisme hiyaraptihpig. Igme pekkiswigkis madikte. Ayteke ig iwé no bakimni gig gukak gunag payak gikak nerras gihaptiyepwi igkis parak ta agikut xam ku kiney eg haritminano. ");
INSERT INTO plu_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ayge ig sumuh no bakimni guwaku. Ig awna ta gut: ―“Talita, kumi.” Inakni wownaprikwiy “Mim, kannikaw”. ");
INSERT INTO plu_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Aynewa eg kannikew eg wew. Mmanawa gaw madikawkubu kamukri akak pikana arawna (12). Igkis madikte wakaymnibdikis kaayhsima. ");
INSERT INTO plu_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Igme Kiyapwiye Jesus awna gitkis: ―Ka muwaka akkin ta gitkis hiyeg. Ikanay gut aynessa gumana. ");
INSERT INTO plu_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Pisenwa gawnhan inakni yuwit patuwesbuhka, ig Kiyapwiye Jesus tipik ayteke. Ig diyuhe ta apitit giwaxri Galiléyamnaw. Gikannuhnipwi igkis tipik gihapti. ");
INSERT INTO plu_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Igkis danuh atere. Ayteke abet samdi ig kapusa kannuhak agiku judeyenepwi gileglisakis. Nerras timepnepwi giwn ayge igkis wakaymnibdi gimin. Igkis awna: ―Kariwntak ner awayg utí inakni giwn? Kariwntak ig utí ini hiyakemniki? Kariwntak ig utí ini gannu? ");
INSERT INTO plu_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ka ba pis hiyá ku ner he aheputnenen gikamkayh? Ka ba nernema kinagniyo kiyapuno Mahi? Ka ba Tiyagu gikak José, Judas, Simawh, ka ba igkisnema gisamwipwi? Ba gisamrupwi ka ba egkisnema msakwa ay ubetwiy? Ayge nikwe igkis kiyimwih gikak Kiyapwiye Jesus, igkis tukuhwepwa giw. ");
INSERT INTO plu_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Igme hiyapni henne, ig awna ta gitkis: ―Madikte hiyeg kiyathenekwiye pahapwi ku pariye Uhokri gawnepe. Ignesnewa gikebyupwi gikakkis gimunyapu gikakkis hiyegipiyene ku pariye apitya giwaxriwa ignes ka kiyatig. ");
INSERT INTO plu_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ayge nikwe ig ka keh kibitema annut ayge awaku yumahwa gikamaxwankis ta gipitit. Ig he sarayh giwak ta gipititkis aynessa hiyeg kakahribdapye ayge igkis makniw. ");
INSERT INTO plu_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ig wakaymni kaayhsima adahan ku samah igkis ka kamaxwa ta gipitit. Ayteke ariwnteke ini ig Kiyapwiye Jesus mpiye muwwapu apuriw madikte paytwempu. Ig kannuhne hiyeg ayge. ");
INSERT INTO plu_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ayteke pisenwa ig pahadguhe giwatnipwi madikawkunene gikebyikis gikakkis piyana gawnakis (12) ta gimkanit. Ayge ig gawahkiswitnikis muwwapu. Nikwe ig gibekheptenkis piyenmempi adahan igkis atak apitit mpuse paytwempu. Ayteke ig iké kumadukaki gitkis adahan igkisme pekkiswiyes wapitye gipititakkis hiyeg. ");
INSERT INTO plu_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ig awna gitkis: ―Ataknay hennen yiwakyékata. Ataknay inenewa akak yasuranenwa. Ka yi muwaka atak akak yimana, iné akak yisakola adahan yiwewni, iné akak karukri agiku yipusra. ");
INSERT INTO plu_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ik adahan yis kawih yikasotni henneme ka yi muwaka atak akak pikanama yisimsa. ");
INSERT INTO plu_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ayteke ig awna ta gitkis akiw: ―Ku aysaw yis danuh ta apitit pahá paytwempu, msakwanabay pahaygiknene ku kiney yis amapaka he ku aysaw yis pes ayteke paytwemputak. ");
INSERT INTO plu_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Henneme ku ignes hiyeg aygnenepwi ku igkis ka amapay, ku igkis ka timepkere yiwn, nikwe pase yis pes ayteke, yis sassah yikugku ariw apathawni. Ini arekhetni ku samah gitaraksankis. ");
INSERT INTO plu_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Pisenwa inakni gawnhan, igkisme tipikbet muwwapu. Igkis kinetihwenes ta gitkis hiyeg adahan igkisme wages gihiyakemnikis ariw gitaraksankis. ");
INSERT INTO plu_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Apim ini igkis pekkis wapityempu kaayhsima gipititakkis hiyeg. Hawwata igkis huk ah ariw ariy ta gitewharitkis hiyeg kakahribdapye adahan makniweprikis. ");
INSERT INTO plu_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Apim ini hawkri ner hiyaptigi amekene Erodis ig timé gak Kiyapwiye Jesus, mmanawa giw Kiyapwiye Jesus hiyakkan muwwapu. Ig timap gaytakkis hiyeg awna: ―Ke wothube ignewa amekene João Batistamni. Ig kannikaw akiw ariw gimiremni. Inneki keh ig kagannusima keh annut. ");
INSERT INTO plu_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Gaytakkisme hiyeg awna: ―Ke wothube ignewa amekene Eliyas. Gaytakkisme awna: ―Ke wothube ignewa pahapwi gawnepe Uhokri. Mmanawa ig kewa Uhokri gawnepepu pitatyepwibe. ");
INSERT INTO plu_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Igme amekene Erodis ku samah ig timé Kiyapwiye Jesus gak, ig awna: ―Ke nuthube ignewa amekene João Batistamni. Nah bukihkise gibita baki ig kannikawatma akiw. ");
INSERT INTO plu_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ig awna inakni henne mmanawa ignewa kamaykistinene amekene João Batista. Ig wanakkisri, ig sarayhkisri agikut parakseket. Ig keh henne gupatra amakano Erodiyas, ku pariye gegni Filip gihayo mmanawa ig powkemnihwa gukak. ");
INSERT INTO plu_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Apim ini ig amekene João Batista himahgi. Ig awna git: ―Pis ka keh wadit ku samah pis powkemnihwe gukak piwgun. Ka hennema Uhokri ayá wotwiy. ");
INSERT INTO plu_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ayteke nikwe egme amakano Erodiyas kanaktin gikak amekene João Batista. Eg aharitno giwmasepten. Henneme eg ka hiyá gisamanak. ");
INSERT INTO plu_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Mmanawa ig amekene Erodis apisemun gibohri amekene João Batista awaku ig hiyakni ku ig waditye hiyeg, ig hiyakni ku ig Uhokri gihiyega. Ayge nikwe ig apuriwkisri agiku parakseket. Ku aysaw ig timá amekene João Batista kinetihwa git, ig mategbet gihiyakemni henneme ig batek timap giwn. ");
INSERT INTO plu_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Egme amakano Erodiyas guhawkanaprik danuh adahan eg giwmasepten. In danuh ku aysaw ig amekene Erodis keh gipetra adahan ku samah ig amadga wayk. Apim ini ig awnase kaayhsima hiyeg kiyatyepwi atere. Ig awnasa gihiyegapu ku pariye apuriw gupelma gidahan. Ig awnasa gisuwtatapu gikiparakis. Hawwata akiw ig awnasa madikte nerras galiléyenepwi ku pariye pi kiyattenene ayge. ");
INSERT INTO plu_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Igkis madikte danuh atere, igkis fetya ayge. Abet ini fet eg amakano Erodiyas gukamkayh himano eg kayno eg pahapo gidahankis gawnasanpu. Eg keh ig amekene Erodis batek ginaktin mpiynepepye payak gikakkis gawnasanpu. Pisenwa nikwe ig awna ta gut: ―Hiyawa pis ayá nuthu madikte ku pariye pimawkan nuthu. Nah ikaksa pit madikte. ");
INSERT INTO plu_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Uhokri timá nuwnhu ku nah awna pit. Nah ikaksa pit madikte ku pariye payapni nuthu. Juktah abusku nukumadukan. ");
INSERT INTO plu_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Egme himano timapni henne, eg pes ta gut gunag. Eg danuh atere, eg ayapru: ―Pagiye nayapni kuri? Egme gunag kaytwa guwn: ―Ayá João Batista gitew. ");
INSERT INTO plu_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Egme himano diyuhe kibentenwa ta git amekene Erodis. Eg awna git: ―Nah muwaka pis ikí nuthu João Batista gitew. Uyá ikepni nuthu pisenwate amadga pahak miguk. ");
INSERT INTO plu_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Igme amekene Erodis timapni henne, ig wakaymni mpiynepepye mmanawa ig ka ihpekere inakni guwn. Henneme kuwis ig ikaksin gut giwtrikneswa gawnasanpu. Nikwe ig ka muwaka kaytwin “Kawk”. ");
INSERT INTO plu_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ayteke nikwe ig awahkis pahapwi gisuwtata. Ig awna git: ―Su atak bukih João Batista gibita. Ayta ewk gitew atan. Igme suwtat tipik ig bukihe amekene João Batista gibita ayge agiku parakseket. ");
INSERT INTO plu_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ayteke nikwe ig aytwe ewk gitew atere amadga pahak miruk. Ig ikepni ta gut no himano. Egme ewkwin ta gut gunag. ");
INSERT INTO plu_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ayteke ku aysaw ig amekene João Batista gikannuhnipwi timé gak, igkis danuh atere, igkis iwé gipit, igkis apuhpig agiku gimew. ");
INSERT INTO plu_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ig Kiyapwiye Jesus giwatnipwi igkis pisenwa gannipwikis, igkis diyuhe ta gimkanit. Igkis akki git madikte ku pariye gikehnitnenkis madikte ku pariye gakkankis gitkis hiyeg. ");
INSERT INTO plu_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ayteke ariwnteke ini igme Kiyapwiye Jesus awna ta gitkis: ―Uyay higihwa aynessa ta apitit pahá iwetrit ku kiney yumanene hiyeg. Ayge wixwiy mayak aynessa. Ig awna inakni henne, awaku gaxnikiswa igkis ka hiyá igkisma mmanawa kaayhsima hiyeg danuhpene git pawenyaneke. ");
INSERT INTO plu_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ayteke nikwe igkis tipik igkiswonas. Igkis tipik muhumdakew ta apitit pahá iwetrit ku kiney yumanene hiyeg. ");
INSERT INTO plu_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Henneme kaayhsima hiyeg ayge gihiypetnikis ku samah gitepkemnikis atere. Igkis hiyapni henne, igkis sigis atere waxriw. Igkis pesbetwikis apititak madikte paytwempu ayge. Igkis kit danuh atere giw Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Igme Kiyapwiye Jesus sarayhwe atere waxrihbakat. Ayge ig hiyá madikte nerras hiyeg kabubuknekis. Ig hiyapni henne, ig kayah gidahankis. Ig amnihpigkis awaku igkis ayge kewa muttuhpiyenebe ku pariye yumanene gikiparakis gikapriwtenkis. Ayge nikwe ig kinetihwa gitkis amin kaayhsima hiyakemniki. ");
INSERT INTO plu_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ayteke ariwnteke ini, tepti kamuw, igkis gikannuhnipwi danukwa atere git. Igkis awna: ―Kiyapwiye, kuwis aygete kuwis. Inin iwetrit yuma hiyeg msekwene ay. ");
INSERT INTO plu_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Wani nerras hiyeg tipik adahan igkis isim gimanakis. Ik adahan gaytakkis atak ta gitkis was akipara. Gaytakkisme atak tahhan paytwempuit adahan igkis isim gimanakis atere. ");
INSERT INTO plu_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Igme Kiyapwiye Jesus kaytwa giwnkis: ―Kawa. Yisnewa ikí axka ta gitkis apim inin. Igkisme awna ta git: ―Mmah pimawkan usuh atak isim bugut adahan gaxnikis? Amawka usuh sarayh kaayhsima karukri mmukna sah (200) karukri. Usuh yuma ukakura akebyi ini. ");
INSERT INTO plu_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Igme Kiyapwiye Jesus ayaprikis: ―Aysaw akebyi bugut yis kadahan? Su yi iwasa. Igkisme tipik iwasa. Ayteke igkis diyuh akiw, igkis kaytwa giwn: ―Usuh kadahan pohowkubu akebyi bugut akak piyana akebyi im masaraku. ");
INSERT INTO plu_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Igme Kiyapwiye Jesus awna ta gitkis madikte hiyeg: ―Batnabay kabubuk ay abet ini pamatka mtibetnene. ");
INSERT INTO plu_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Igkisme batahkiswebdi atere. Igkis ahegwa adahan pohowkutra madikwa (50) gikebyikis, adahan madikawkut madikwa (100) gikebyikis. ");
INSERT INTO plu_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ku aysaw igkis kuwis batebdebdihpikis, ig iwé ini pohowkubunene bugut akak piyananene im. Ig sarayh gipegyi ta inut, ig kabayha Uhokri adahan ini. Ayteke ig sigkebdihe ini bugut. Ig ikepni ta gitkis gikannuhnipwi kahadbe igkisme ibekhepni ta gipuriwkis nerras hiyeg. Hawwata ig ibakhase ini piyananene im ta gipuriwkis madikte hiyeg. ");
INSERT INTO plu_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Igkis madikte ax kabihribdape. ");
INSERT INTO plu_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ka semeweknama gimanakis. Kaayhsima asemne msekwe. Pisenwa nikwe, igkis gikannuhnipwi ahiwapemni, igkis kipunse kaayhsima panye akak asemne gimanakis, madikawku akebyi panye akak pisaya arawna (12). ");
INSERT INTO plu_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Igkis nerras hiyeg kaayhsima gikebyikis. Awaykemninen pukuhka kabá danuh pohowku mil (5.000) gikebyikis. ");
INSERT INTO plu_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ayteke ariwnteke ini ig Kiyapwiye Jesus awna ta gitkis gikannuhnipwi. Giwn: ―Kataptanabay amadgat wahmunwiy. Manukwinay pitati tahhan pahambakat ta apitit paytwempu Betsayda. Kuwewanek nah aterenek. Igkis timapni henne, igkis tipik. ");
INSERT INTO plu_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Igme msekwe ayge adahan ig ekkewpiye ta gitkis nerras hiyeg. Pisenwa gekkewpen, ig wagehe apitit pahá waxri imuwadnene adahan ig piriyepkewne atere. ");
INSERT INTO plu_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Msanpi gaw, no gihmunkis ayhté pakwa mahakwa. Igme adukwenewa ig ayge pahapo. ");
INSERT INTO plu_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ig hiyá ku igkis mpiksewnes puwehnes mmanawa mayg aytnipa gitiputkis. Ayteke nikwe kabeyweke ig Kiyapwiye Jesus aytweni ta gimkanitkis, ig waywe ahakwew un. Ig gimapiyeptenkis. ");
INSERT INTO plu_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Igkisme hiyapni henne ku samah ig waywe ahakwew un, igkis ikiygi ku ig anmapti. Ayge igkis kabimenbet akak gapisnikis. ");
INSERT INTO plu_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Igkis madikte hiyapri. Igkis apisasew kaayhsima. Igme awna ta gitkis. Giwn: ―Kibowkahwanabay. Nahnewa ay. Ka yi muwaka apis. ");
INSERT INTO plu_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ayteke ig katapte amadgat gihmunkis. Ig msakwa ayge gikakkis. Aynewa mayg msekwe. Igkisme amadgaya umuh igkis hiyapni henne, igkis wakaymnibdi gidahan mpiynepepye. ");
INSERT INTO plu_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Mmanawa igkis ka pukuha ini gannu akak ini bugut. Igkis pet gihiyakemnikis. ");
INSERT INTO plu_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Igkis manuke mahakwa, igkis danuh ta apitit Jenesarémnaw. Ayge igkis minahwa ihapkat. ");
INSERT INTO plu_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Pase igkis katapte muhumdakat, nerras hiyeg ayge murotpi git Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Igkis wasapanaw giminkis hiyeg muwwapu giwaxrikis. Ayteke nikwe igkis waxwape madikte hiyeg kakahribdapye ta gimkat amadga gisipamnakis. Igkis waxwigkis muwwapu ku kit igkis timé gak ku ig ayge. ");
INSERT INTO plu_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ku kitwiye ig danuh, atere igkis amnihswe ta git adahan ig isiy nerras kakahribdapye adahan igkis dax he gikanwaptanen akigbimna. Igme isakseprikis. Madikte hiyeg ku pariye daxni igkis makniw. ");
INSERT INTO plu_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ayteke gaytakkis nerras farisewkis gikakkis gaytakkis kannuhekeputnepwi amin amekene Moís gikumadukan igkis danuh atere aytontak apititak Jerusalém. Igkis pahadguhwa ta git Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Igkis ayge gikak, igkis hiyá ku Kiyapwiye Jesus gikannuhnipwi ka sukokaw apit igkis ax kema amekenegbenma adahan igkis humaw barewpit giwtrik Uhokri. Igkis hiyapni henne, gitkis gikannuhnipwi ax akak giwakukis patehwepye giwtrik Uhokri. ");
INSERT INTO plu_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Mmanawa nerras fareswkis akak madikte judeyenepwi giwewkistenkis akiw, igkis kiyatha amekenegben gihiyakemnikis, igkis sukokaw kabayhtiwa apit igkis ax. Ku igkis ka sukokaw henne, igkis ka ax. Ta gitkis ini keh igkis humaw barewpit giwtrik Uhokri. ");
INSERT INTO plu_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Hawwata akiw ku aysaw igkis diyuh ariwntak im gapikekri igkis sakta gimanakis akak un adahan in barewbet giwtrik Uhokri. Ku igkis ka saktin henne, igkis ka axni. Igkis hawwata kiyatha kaayhsima amekenegben gihiyakemnikis akiw kewa inibe. Juktah igkis sukuheku gigoblakis akak gisuwyegakis akak gikarapakis kehka kuriwra adahan in barewegkape giwtrik Uhokri. Igkis sukuhekuni kabayhtiwa ku samah amekenegben gihiyakemnikis. ");
INSERT INTO plu_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ayteke nikwe nerras farisewkis gikakkis nerras kannuhekeputnepwi amin amekene Moís gikumadukan igkis ayá Kiyapwiye Jesus: ―Mmahki pikannuhnipwi ka iha amekenegben gihiyakemnikis? Apit igkis ax igkis ka sukokaw kabayhtiwatma kema igkisma. Igkis ax akak giwakukis patehwepye giwtrik Uhokri. ");
INSERT INTO plu_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Igme Kiyapwiye Jesus kaytwa giwnkis: ―Yis farisewkis ikewne ke wotbe yis kibeynepwibe hiyeg bawa yis pi mbayte giwkis nawenépwi hiyeg. Minikwak amekene Isaías kuwis kinetihwa yimin. Ig ekkene Uhokri giwn, ig awna: “Nerras hiyeg kiyathan ay ginumbukisnen bawa gihiyakemnikisme piyawakad nuwhu. ");
INSERT INTO plu_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Igkis kiyathan waditnepyenen. Igkis kannuheknes amin hiyegnen gihiyakemnikis amadgaya inin ke wotbe in nuhiyakemnibe.” ");
INSERT INTO plu_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Inakni yuwit kinetihwa yimin. Mmanawa yis kuwis miyehe Uhokri gikumadukan henneme yis kiyene kabayhtiwa hiyeg gihiyakemnikis amadgaya inin. ");
INSERT INTO plu_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ayteke ig Kiyapwiye Jesus awna gitkis akiw. Ig awna: ―Yis kayannusima mayte Uhokri gikumadukan adahan yis pi ihpate giwnkis amekenegben awenyan igwa Uhokri gikumadukan. ");
INSERT INTO plu_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Nah akkite yit ku samah. Ig amekene Moís awna: “Kiyatha pig, kiyatha pinag.” Hawwata akiw ig awna: “Ku pahapwi miyatha gig, miyatha ginag, pugamawka ig umehpika.” Hennewatbaki ig Uhokri awna. ");
INSERT INTO plu_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Yisme awna: “Ku pahapwi ik adahan ig amnih gig gukak ginag henneme ku ig awna ta gutkis: ‘Nah ka hiyá nahma amnihyi akak ini newkanbet mmanawa in “Korbah”. Inakni yuwit akki ku nah kuwis ikakse ku nah kawih madikte newkanbet gidahannen Uhokri.’ ");
INSERT INTO plu_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ku pahapwi awna inakni henne, nikwe yis ka isaksig adahan ig ayapa gig gukak ginag. ");
INSERT INTO plu_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ku aysaw yis iha inakni giwnkis amekenegben ku kamin yis kannuhne hiyeg, amun ini nikwe yis kuwis ikene amekenegben gihiyakemnikis pi kabayte mpiy Uhokri gikumadukan. Mmanawa yis mpitha hiyeg adahan ignes ka kiyatha gigkis. Yis keh arakembet akebyi ini. ");
INSERT INTO plu_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ayteke ig Kiyapwiye Jesus pahadguhe madikte hiyeg ayge ta gimkanit akiw. Ig awna ta gitkis: ―Ataybiswanabay numkanit. Pukuhpanabay nuwnhu. ");
INSERT INTO plu_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ku pariye arikna wis ikí ubiygikut ka innema keh wis patehwepye giwtrik Uhokri. Henneme ku pariye mbayka pes ubiyaptak inneki keh wis patehwepye giwtrik Uhokri. ");
INSERT INTO plu_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ku yis katayebnene, ataybiswanabay nuthu. ");
INSERT INTO plu_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ayteke ig Kiyapwiye Jesus pes gibetitakkis nerras hiyeg. Ig pareke paytrikut. Igkis gikannuhnipwi hiyapni henne, igkis danuh atere git. Igkis ayapri: ―Uyá akkamnih wothu inakni yuwit patuwesbuhka amin ku pariye keh hiyeg patehwepye giwtrik Uhokri. ");
INSERT INTO plu_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Igme Kiyapwiye Jesus kaytwa giwn: ―Mmah yis kawnata pukuha nuwnhu? Ka ba yis hiyá ku pariye arikna wis ikí ubiygikut ka innema keh wis patehwepye giwtrik Uhokri ");
INSERT INTO plu_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","awaku in ka parak abetit uhiyakemni in he mpiya ta wayhgikut, kuwewa akiw wis ahinaprikuhpin? Akak inakni yuwit ig akki ku madikte axkaritnenepwi kabay giwtrik Uhokri. ");
INSERT INTO plu_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ayteke ig awna: ―Henneme ku pariye mbayka pes ubiyaptak, in ayta abetitak uhiyakemni. Innebaki ik adahan keh wis patehwepye giwtrik Uhokri. ");
INSERT INTO plu_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Mmanawa abetitak uhiyakemni ayteke pes mbeyepye hiyakemniki, mehka imunti, amepwiki, umahaka, powkemniki, ");
INSERT INTO plu_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","miyarhawka, mbayka, kinisaka, meksaki, atihpaki, miyathaka, kawantiki, puwpuki. ");
INSERT INTO plu_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Madikte ini mbayka pes abetitak hiyeg gihiyakemnikis. Innebaki ku pariye keh wis patehwepye. ");
INSERT INTO plu_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ayteke pisenwa ig Kiyapwiye Jesus kannikaw ig tipik ta apitit ini waxri ku kiney paytwempu Tiru akak paytwempu Sidoh msakwa. Ig danuh atere, ig pareke paytrikut. Ig ka muwaka hiyeg hiyakni ku ig ayge henneme ig ka hiyá igma ayamwa giwkis. ");
INSERT INTO plu_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ayteke pahapu tino kane judeyanoma eg timé gak ku ig msakwa ayge. Gukamkayesa wapityewnipyo. Eg hiyapni henne, eg tipik danuh atere git, eg paberetusaw ta gikimpuit. ");
INSERT INTO plu_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Eg tino eg grésiyano. Eg amadga wayk ayhté Siru‐fenísiyamnaw. Eg danuh atere, eg amnihswe ta git. Eg awna: ―Kiyapwiye, uyá amnihun. Pekkisnaba ner wapitye ayteke gupititak nukamkayh. ");
INSERT INTO plu_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Igme Kiyapwiye Jesus kaytwa guwn: ―Kote ikte. Amawka ku nah amnih nukamkayupwi judeyenepwi pitatye. Ka kis adahan nah hiyak pikak kuri pis kane judeyanoma. Ku nah hiyak pikak kuri in ke wotbe nah iwepyebe nukamkayupwi gimanakis nah padekwin ta gitkis pewru. ");
INSERT INTO plu_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Egme kaytwa giwn: ―Hennewa, Kiyapwiye. Henneme juktah pewruyan ku pariye msakwa anapi gikiparakis gaxten ignes ax arebdibdi tuguhapye giwntakkis gikamkayupwi. ");
INSERT INTO plu_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ig Kiyapwiye Jesus timapni henne, ig awna gut: ―Kiyapuno, inakni pikaytwan kabayhtiwa. Kuri nikwe hiyawa pis diyuhe pipinwat akak kabayka. Ner wapitye ayipa pese gupititak pikamkayh. ");
INSERT INTO plu_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Eg timapni henne, eg tipik ta gupinekut. Eg danuh atere, eg uté gukamkayh mayakno amadga gulita. Ayipa ner wapitye kuwis pese gupititak. ");
INSERT INTO plu_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Pisenwa ig Kiyapwiye Jesus tipik apititak ini waxri ayge ahumwa paytwempu Tiru. Ig tipik apuriw paytwempu Sidoh, apuriw ini waxri ku kiney paytwempu Dekápolis. Ayteke ig danuh ta akigbimnat mahakwa Galiléya. ");
INSERT INTO plu_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nikwe kaayhsima hiyeg danuh atere gimkat. Igkis waxe ta git pahapwi awayg mataybipye, monpiye. Igkis awna git: ―Kiyapwiye, uyá amnihgi sarayh piwak ta gipitit kahadbe ig makniw. ");
INSERT INTO plu_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Igme Kiyapwiye Jesus iwepri aparayewa giwkis nerras hiyeg, igwo. Ayge ig idis pahat giwak ta gitaybikut ner awayg. Ayteke ig tupes, ig dax ta ginenboit ner awayg akak gaybi. ");
INSERT INTO plu_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Pisenwa ig sarayh gipegyi ta inugikut, ig kahhekanaw. Ig awna git: ―“Éfata”. Inakni wownaprikwiy “turuh”. ");
INSERT INTO plu_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Aynewa ner awayg gitaybi turuhe. Ginen isehe. Ig awna kabayhtiwa. ");
INSERT INTO plu_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ayteke nikwe ig Kiyapwiye Jesus awna ta gitkis nerras hiyeg. Giwn: ―Ka yi muwaka kinetihwa ta gitkis hiyeg amin ku pariye nukehni gikak ner awayg. Henneme ku samah ig pi awnepa inakni henne ta gitkis hiyeg, igkis pi awnepa akiw. ");
INSERT INTO plu_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Igkis wakaymnibdi gidahan mpiynepepye. Igkis awna: ―Ig keh madikte kabayhtiwa. Juktah ig keh mataybipye timap, monpiye awna. ");
INSERT INTO plu_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ayteke abetnewa ini hawkri kaayhsima hiyeg pahadguhwe atere git Kiyapwiye Jesus akiw. Ku samah igkis ayge timepne giwn, apim ini gimanakis madike. Ig Kiyapwiye Jesus hiyapni henne, ig pahadguh gikannuhnipwi ta gimkanit. Ig awna gitkis: ");
INSERT INTO plu_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Nerras hiyeg kuwis msekwe ay ukakwiy mpana hawkri. Gimanakis madike kuwis. Nah wakaymni gidahankis. ");
INSERT INTO plu_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nah ka muwaka awahkisrikis ta gipinwatkis akakma matipwa. Nawenétke igkis tuguhenek pakwa ahin awaku mabimnaki. Mmanawa gaytakkis ayta aytontak piyawakad. ");
INSERT INTO plu_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Igkisme gikannuhnipwi ayapri: ―Mmah awitwak wotwiy bugut gidahankis ay amadga inin amatap? ");
INSERT INTO plu_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Igme Kiyapwiye Jesus ayaprikis: ―Aysaw akebyi bugut yis kadahan? Igkisme kaytwa giwn: ―Usuh kadahan ntewnehkerbu akebyi. ");
INSERT INTO plu_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ayteke nikwe ig Kiyapwiye Jesus keh nerras hiyeg batahkiswa waygboit. Ku aysaw kuwis igkis batebdebdihpikis, ig iwé ini ntewnehkerbunene bugut, ig kabayha Uhokri adahan ini. Ayteke ig sigkabdihapepni, ig ikepni ta gitkis gikannuhnipwi. Igkisme ibekhepni ta gipuriwkis nerras hiyeg. ");
INSERT INTO plu_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Igkis kadahan aynessa im nopsanyopwi masaraku hawwata. Igme Kiyapwiye Jesus kabayha Uhokri adahan ini. Ayteke ig ibakhasin ta gitkis gikannuhnipwi. ");
INSERT INTO plu_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ignesme nerras hiyeg ax kabihribdape. Ka semeweknama gimanakis. Kaayhsima asemne msekwe. Pisenwa nikwe igkisme Jesus gikannuhnipwi ahiwapepni. Igkis kipunse ntewnenker akebyi panye akak asemne gimanakis. ");
INSERT INTO plu_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Igkis nerras hiyeg kaayhsima gikebyikis. Kabá danuh paxnika mil (4.000) gikebyikis. Pisenwa nikwe ig awahkiswigkis diyuh tahhan gipinwatkis. ");
INSERT INTO plu_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ayteke ig katapte muhumdakat gikakkis gikannuhnipwi, ig tipik ta apitit Dalmanutamnaw. ");
INSERT INTO plu_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ig danuh atere, gaytakkis nerras farisewkis danuh atere git Kiyapwiye Jesus adahan gihikekten. Igkis kehkis git annut inugiktekne adahan arekhetni gidatni gitkis kahadbe igkis hiyakri ba ig ayta giwntakwatma Uhokri. ");
INSERT INTO plu_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Igme Kiyapwiye Jesus hiyapni henne, ig kahhekanaw apititak giyakni, ig awna gitkis: ―Aa, yis hiyeg amadgayapu hawkri. Mmahkay yis kehkis annut nuthu adahan arekhetni ndatni yit? Nah ka keh pahatnama annut yidahan. Ihanabay inakni nuwnhu. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ig awna inakni, ig tipik ikiswigkis. Ig katapta muhumdakat akiw, ig tipik pahambakat mahakwa. ");
INSERT INTO plu_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Igkisme Kiyapwiye Jesus gikannuhnipwi tipik gihapti. Henneme igkis miyehe ewk bugut ayta gihaptikis. Pahatwowa bugut ayge amadga gihmunkis. ");
INSERT INTO plu_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ayge ig Kiyapwiye Jesus kapusa ikí gihiyakemnikis. Ig awna ta gitkis: ―Apuriwnabay, pukuhpawnabay abohri ini bugut abusan gidahankis nerras farisewkis. Pukuhpawnabay hawwata abohri ini bugut abusan gidahan ner ikiparat Erodis. ");
INSERT INTO plu_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Igkisme timapni henne, igkis kinetihwa pawtak amin inakni giwn. Igkis awna: ―Ig awna inakni awaku wixwiy ka ewk bugut ayta uhaptiwiy. ");
INSERT INTO plu_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Igme Kiyapwiye Jesus timapni henne, ig awna gitkis: ―Mmahpaki yis yipewkan ku nah awna inakni awaku yis yuma yibuguta? Mmah yis kote pukuhpate ku nah ka kiyimwihwa aharit naxni? Mmah yihiyakemni pet? ");
INSERT INTO plu_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Yis kowtyak henneme yis ka hiyap ku pariye inyerwatnene. Yis kataybi henneme yis ka timap ku pariye hiyakemniki inyerwatnene. Mmah yis kuwis miyehe ");
INSERT INTO plu_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ku samah nah kuwis ibakhase pohowkunene bugut gipuriwkis pohowku mil (5,000) gikebyikis hiyeg? Aysaw akebyi panye yis kipunse akak ini bugut asemne apim ini? Igkisme kaytwa giwn: ―Usuh kipunse madikawku akebyi panye akak pisaya arawna (12). ");
INSERT INTO plu_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Igme awna: ―Hawwata akiw ini ntewnekerbunene bugut ku pariye nah ibakhase gipuriwkis paxnika mil (4,000) gikebyikis hiyeg. Aysaw akebyi panye yis kipunse akak ini bugut asemne apim ini? Igkisme kaytwa giwn: ―Usuh kipunse ntewnehker akebyi panye. ");
INSERT INTO plu_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Igme awna gitkis: ―Mmah yis kote pukuhate inakni nuwnhu? Ig awna inakni awaku farisewkis gihiyakemnikis ik adahan wagesbeta uhiyakemni monye hawwata ku samah bugut abusan tukurusa bugut. ");
INSERT INTO plu_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ayteke pisenwa igkis danuh ta apitit paytwempu Betsayda. Ayge hiyeg waxe pahapwi motpiye ta git Kiyapwiye Jesus. Igkis ayá git: ―Kiyapwiye, uyá amnihgi sarayh piwak ta gipitit kahadbe ig makniw. ");
INSERT INTO plu_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Igme Kiyapwiye Jesus sumuh ner motpiye giwaku, ig itukepri aparayewa ariw paytwempu. Igkis danuh atere, ig tupes ig manotig akak gaybi. Ayteke ig sarayh giwak ta gipitit. Pisenwa ig ayapri: ―Mmani? Ba pis hiyap? ");
INSERT INTO plu_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Igme kannikase gitew, ig ipeg. Ig awna: ―Nah hiyá hiyeg henneme nah hiyaprikis hennenwa ke ahapwibe akat waywempi. ");
INSERT INTO plu_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ig Kiyapwiye Jesus timapni henne, ig daxe giwtyak akiw. Ayteke ig awayg padukise gipegyi kabayhtiwa. Ig makniw. Ig hiyap madikte huwewe. ");
INSERT INTO plu_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Igme Kiyapwiye Jesus awahkiswig diyuh wadé gipinwat. Ig awna git: ―Ka ba mpiya apuriw paytwempu. Igme tipik. ");
INSERT INTO plu_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ayteke ariwnteke ini ig Kiyapwiye Jesus tipik gikakkis gikannuhnipwi. Igkis danuh ta apitit waxri kennesa amun paytwempu kewye “Sesaréya gidahan Kiyapwiye Filip”. Ayge apigku ahin ig ayá gikannuhnipwi. Giwn: ―Pariyeki gipewkankis nerras hiyeg ikanhu nah kuri? ");
INSERT INTO plu_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Igkisme kaytwa giwn: ―Gaytakkis hiyeg ikapi ku pis amekene João Batistamni kannikaw akiw. Gaytakkisme ikapi ku pis amekene Eliyas. Igkisme gaytakkis hiyeg ikapi ku pis pahapwi gaytakkis Uhokri gawnepepu pitatyepwi. ");
INSERT INTO plu_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Igme Kiyapwiye Jesus timapni henne, ig awna gitkis: ―Ya yis. Mmahpa yis ikanhu kuri? Igme kiyapwiye Simawh Pedru kaytwa giwn: ―Pis Cristo pis Uhokri gikanyan adahan ukumaduketni. ");
INSERT INTO plu_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Igme Kiyapwiye Jesus awna ta gitkis: ―Hennewa. Henneme ka yi muwaka akka inakni ta gitkis hiyeg kuri. ");
INSERT INTO plu_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ayteke ariwnteke ini, ig Kiyapwiye Jesus kapusa akkamnih gitkis gikannuhnipwi huwewe amin ku pariye nemnikumpiye git. Ig awna gitkis: ―Nah ku pariye wageswe hiyeg amadgaya inin amawka ku nah hiyá mbeyne kaayhsimanek ay amadga inin. Aysawnemenek nerras uwewkistenwiy gikakkis muwpeg kiyatyepwi gikakkis nerras kannuhekeputnepwi, igkis madikte tukuhptepunnek. Ayteke nah umehpikanek. Henneme abet amamnam hawkri ariwntak numiremni nah kannikaw akiwnek. ");
INSERT INTO plu_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ig akkamnih inakni gitkis huwewe. Igme kiyapwiye Pedru timapni henne, ig wewkiswa gikak atakesa aynessa adahan ig awnene gikak. Ig awna: ―Kiyapwiye, ka muwaka awna inakni henne. ");
INSERT INTO plu_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ig awna inakni henne, igme Kiyapwiye Jesus wagese giduhya gimkat, gihepka hampa gimkatkis gikannuhnipwi. Ig himehe kiyapwiye Pedru. Ig awna git: ―Pes ayteke, Satanás. Pedru, pis ka awna inakni akakma Uhokri gihiyakemni. Pis awna akak gihiyakemnikis hiyeg amadgayapu inin. ");
INSERT INTO plu_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ayteke ig Kiyapwiye Jesus pahadguhe kaayhsima hiyeg gikakkis gikannuhnipwi. Ig awna ta gitkis: ―Ku pahapwi humewkerepye nuhiyega, amawka ku ig ikise gidahan gibetki. Amawka ku ig umahkise gihiyakemni amadgaya inin ke wotbe ig daddahkiswinbe ta aminat ah. Amawka ku ig ikaw hawwata ke nahbe. ");
INSERT INTO plu_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Mmanawa pahapwi ku pariye kiyé gipitnen, iggi biyuknek giw Uhokri adahan apanenekwa. Pahapwime ku pariye miyehe gipitwa ndahan adahan ig ekkene nnetni gitkis hiyeg, iggi aymuhwanek gimun Uhokri adahan apanenekwa. ");
INSERT INTO plu_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ku pahapwi darih madikte igiska amadgaya inin henneme ku ig biyuke giw Uhokri, amun ini nikwe ini igiska waditnepyenen gidahan. ");
INSERT INTO plu_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Yuma ariknawnama igiska ik adahan kawenyana pahapwi gaymuhwan gimun Uhokri akiw. ");
INSERT INTO plu_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mmanawa aysawnemenek nah ku pariye wageswe awayg amadgaya inin nah aytanek gikak Wigwiy gikiythani gikakkis ahj barewpityepwi. Apim ini nah marekepwe gikakkis hiyeg ku pariye marekepwepye nukakhu gikakkis hiyeg ku pariye marekepwepye akki nuwnhu ta gitkis hiyeg. Hiyeg amedgenepwi inin igkis kuwis isahkiswe giw Uhokri. Igkis mbeyepye gihiyakemnikis. Ka yi muwaka mará gibohrikis. ");
INSERT INTO plu_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ayteke ig awna ta gitkis akiw. Giwn: ―Kennesa gidawnhan Uhokri gikumadukan akak madikte nikiythani. Yaytak ku pariye ay ku akak inin, apit yis miyá yis hiyapninek. Ihanabay inakni nuwnhu. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ayteke ariwnteke ini puguhkuna hawkri, ig Kiyapwiye Jesus iwé kiyapwiye Pedru gikak amekene Tiyagumni, gikak kiyapwiye João adahan igkis tipik gihapti. Igkis wagehe ta apitit pahá waxri imuwadnene. Igkiswonakis ayge. Ayge gimunkis ig uniyehwe gihipak nawenéwa akiw. Gihepka amuwe ke kamuwbe. ");
INSERT INTO plu_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Gisimsa wageswe barewbet tigigihwe. Yuma usukeperma amadga inin hiyá asukak seyne kema inima. ");
INSERT INTO plu_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ayteke pahaye adahan amekene Eliyas gikak amekene Moís igkis hiyapkiswe atere gitkis. Igkis ayge kinetihwenes gikak Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Igme kiyapwiye Pedru hiyapni henne, ig awna ta git Kiyapwiye Jesus. Giwn: ―Kiyapwiye, kibeynekata wixwiy ay kabubuk apim inin. Uyay msakwa ay. Usuh kehbetate mpana paytbetyanyupwi ay. Pahá pidahan, paháme gidahan kiyapwiye Moís, paháme gidahan kiyapwiye Eliyas. ");
INSERT INTO plu_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ig he awnepyenen mmanawa ig ka hiyak ku samahpa ig awna. Mmanawa igkis kagiwakemnikissima. ");
INSERT INTO plu_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Pahaye adahan pahá ukuhne biyuhe ta gipititkis. Ayteke pahá ikupimnat awna gitkis aytontak abetitak ini ukuhne. In awna: ―Ner nukamkayh nubetki. Ataybiswanabay git. ");
INSERT INTO plu_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Igkisme sarayh gipegyikis atere, igkis iwasa. Yumehe nerras piyananene gikebyikis. Igwo Kiyapwiye Jesus msekwe ayge gimunkis. ");
INSERT INTO plu_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ayteke nikwe igkis muhuke apititak ini waxri imuwadnene. Igkis muhukempi, ig Kiyapwiye Jesus awna ta gitkis. Giwn: ―Ka ba yi kinetihwa ta gitkis hiyeg aynesnima amin ku pariye yihiypan ku apim inin. Ka yi muwaka kinetihwa nimin he ku aysawnemenek nah ku pariye wageswe awayg amadgaya inin nah kannikaw ariw numiremninek. Ariwnteke ini nikwe ik adahan yis kinetihwa nimin. ");
INSERT INTO plu_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Igkisme timapni henne, igkis iha giwn igkis ka kinetihwa nimin ta gitkis hiyeg. Henneme igkisweke ayá pawtak: ―Mmahki ig awna inakni yuwit henne ku ig kannikaw ariw gimiremninek? ");
INSERT INTO plu_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ayteke igkis ayá Kiyapwiye Jesus: ―Kiyapwiye, ku pis Cristo, ku pis Uhokri gikanyan adahan ukumaduketni, mmahki nerras kannuhekeputnepwi awna: “Amawka ku amekene Eliyas ig kit danuh atan giw Cristo?” ");
INSERT INTO plu_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Igme kaytwa giwnkis: ―Hennewa in. Pahapwi kene amekene Eliyasbe ig kit ayta adahan ahegbetepye madikte napithu. Hawwata inakni Uhokri gannasan minikwekenene kinetihwa numinhu nah ku pariye wageswe awayg amadgaya inin. In awna ku amawka nah hiyá kaayhsima mbeyne, ku amawka nah mahipwihpika. ");
INSERT INTO plu_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ku samah in kinetihwa numinhu hennewa in danuh nuthunek hawwata ku samah in kuwis danuh ta git ner ku pariye kene amekene Eliyasbe. Mmanawa ig ner kuwis danuh atan amadgat inin. Ignesme hiyeg ay arewha git ku samah gimawkanitnenes. Ku samah Uhokri gannasan minikweknene kinetihwa gidahan, hennewatmeki in danuhpuwa git. ");
INSERT INTO plu_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ayteke ariwnteke ini igkis danuh atere gitkis gikannuhnipwi asemne. Igkis hiyá kaayhsima hiyeg kabubuknene ganwakis. Igkis hiyá kannuhekeputnepwi amin amekene Moís gikumadukan igkis piledukewnes gikakkis ayge. ");
INSERT INTO plu_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ignes hiyeg pase igkis hiyé Kiyapwiye Jesus igkis batek ginaktinkis, igkis sigisbetkis ta gimkanit. Igkis aytnihgi atere. ");
INSERT INTO plu_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Igme ayaprikis: ―Pariye yinetni gikakkis nerras kannuhekeputnepwi ayge? ");
INSERT INTO plu_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Pahapwi gaytakkis nerras hiyeg kaytwa giwn: ―Kiyapwiye, uyá amnihun. Nah waxe nukamkayh ta pit. Ig wapityewnipye. Pahapwi wapitye keh ig monpi. ");
INSERT INTO plu_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ku samah ig wapitye parekwig ig padekwig ta waygboit. Igme bakimni kahawyo gibiy. Ig kagah gaybu. Ig datpup. Nah kuwis ayá gitkis pikannuhnipwi adahan igkis pekkis ner wapitye gipititak henneme igkis ka hiyá gisamanak. ");
INSERT INTO plu_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ig Kiyapwiye Jesus timapni henne, ig awna git: ―Aa, hiyeg taraksapye amadgayapu inin. Mmahki yis kane kamaxwa aynesnima gipitit Uhokri? Aysaw akebyi hawkri yimawkan nah msakwa ay yikak nah kiyaknihwa yikak juktah yis kamaxwa gipitit Uhokri? Kuri waxwa pikamkayh ayta numkanit. ");
INSERT INTO plu_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ayteke nikwe igkis hiyeg waxepri ta gimkat. Pase ig wapitye hiyé Kiyapwiye Jesus, aynewa ig nuwise bakimni kaahawnasima akiw. Igme bakimni tuguhe waygboit, ig wagesminew, ihawyot pese gibiyaptak. ");
INSERT INTO plu_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ig Kiyapwiye Jesus hiyapni henne, ig ayá gig: ―Aysaw akebyi hawkri ariwntak ku samah ig utí ini? Giwn: ―Ku samah ig bakimnite ig utí ini. Akaknewa ig aymuhwe. ");
INSERT INTO plu_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ig wapitye kuwis tuguhkiswig kibereput ta abetit tiket, ig tubohkiswig ahakwat un adahan giwmasepten. Kiyapwiye, ku pis hiyá wayapak uyá amnih usuh, ayapa usuh. ");
INSERT INTO plu_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Igme Kiyapwiye Jesus kaytwa giwn: ―Mmahki pis awna inakni yuwit, “ku nah hiyá yayapak”? Nah hiyá gayapakkis madikte hiyeg ku pariye kamaxwa ta nupitit. Madikte arikna ka mahikonama ndahan. ");
INSERT INTO plu_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Igme bakimni gig timapni henne, ig awna: ―Nah kamaxwa ta pipitit. Uyá ayapan keh nah pi kamaxwate pipitit akiw. ");
INSERT INTO plu_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nikwenéwa kaayhsima hiyeg kapusa pahadguhwa atere gitkis. Ig Kiyapwiye Jesus hiyapni henne, ig himehe ner wapitye kibentenwa. Ig awna git: ―Pis monpiki akipara, pis mataybiki akipara, nahnewa awna pit, asá pes ayteke gipititak bakimni. Ka ba parak gipitit akiw. ");
INSERT INTO plu_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Igme wapitye kabiman. Ig nuwise ner bakimni kaayhsima akiw. Pisenwa ig pese gipititak. Igme bakimni msekwe harit kewa miyapiyebe. Nerras hiyeg hiyapni henne, kabá madikte awna: ―Ig kuwis miyap. ");
INSERT INTO plu_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Henneme ig Kiyapwiye Jesus sumuhe giwaku, ig kannikasig. Igme bakimni kannikaw ig tabira ayge. ");
INSERT INTO plu_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Pisenwa ig Kiyapwiye Jesus tipik pareke paytrikute. Gikannuhnipwi atak gihapti igkiswonas. Igkis ayapri: ―Ya usuh? Mmahki usuh ka hiyá apukwak ner wapitye? ");
INSERT INTO plu_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Igme kaytya gitkis: ―Akebyi ner wapitye yis ka hiyá gipukwak hennentima kema inima. Amawka ku yis piriyepkaw kaayhsima. ");
INSERT INTO plu_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ayteke ariwnteke ini igkis tipik ayteke, igkis waywe awmte apuriw Galiléyamnaw. Ig Kiyapwiye Jesus ka muwaka hiyeg hiyakni ku ig ayge. ");
INSERT INTO plu_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Mmanawa ig kannuhne igkiswonas gikannuhnipwi. Ayge ig Kiyapwiye Jesus awna ta gitkis: ―Aysawnemenek nah ku pariye wageswe awayg amadgaya inin nah kamaykiswikanek ta gitkis hiyeg amadgayapu inin. Apim ini igkisme nuwmepten. Henneme amamnam hawkri ariwntak numiremni nah kannikaw akiwnek. ");
INSERT INTO plu_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Igkisme gikannuhnipwi timá inakni henne, igkis ka pukuha inakni giwn. Henneme igkis marenpi gibohri adahan igkis ayapri amin ku samah inakni giwn. ");
INSERT INTO plu_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ayteke igkis danuh ta apitit paytwempu Kafarnawh. Ayge nikwe igkis pareke ta paytrikute. Ayge ig Kiyapwiye Jesus ayaprikis: ―Mmah yinetni kaksa apigku ahin? ");
INSERT INTO plu_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Igkisme ka kaytwa giwn. Mmanawa apigku ahin igkis mapihpak amin ku pariye gaytakkis pi kiyattenene giwkis. ");
INSERT INTO plu_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Igme Kiyapwiye Jesus hiyakni henne, ig batahkiswa atere, ig pahadguh giwatnipwi (12) ta gipetunat. Ig awna gitkis: ―Ku pahapwi ikewkerepye kiyatye hiyeg giwtrik Uhokri, amawka ku ig ka ikaw henne. Amawka ku ig ikaw ke wotbe ig yumahbe gikiythanibe. Amawka ig ikaw kewa ibuktibe gidahankis madikte hiyeg. ");
INSERT INTO plu_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ig awna inakni henne, ig muwaka akki gitkis adahan ku samahpa igkis ikaw kewa ibuktibe gidahankis hiyeg. Nikwe ig iwé pahapwi bakimni. Ig tabirasig giwtrikneswa. Ig ugiswig ayge, ig awna ta gitkis: ");
INSERT INTO plu_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Ku pahapwi amnih pahapwi bakimni kene nerbe ndahan, amun ini nikwe in ke wotbe ig kuwis amnihun. Ku pahapwi hiyeg amnihun, amun ini nikwe in ke wotbe ig kuwis amnih ku pariye nawahkisten atan amadgat inin. ");
INSERT INTO plu_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ayteke ig kiyapwiye João awna git: ―Kiyapwiye, usuh hiyá pahapwi awayg ig pekkis wapitye piwaprik. Usuh hiyapni henne, usuh awna git: “Ka ba pekkis wapitye giwaprik Kiyapwiye Jesus.” Usuh mpithepri henne awaku ig ka wew ukakwiy. ");
INSERT INTO plu_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Igme Kiyapwiye Jesus kaytwa giwn: ―Ka yi muwaka awna git henne, mmanawa pahapwi ku pariye kehne annut nuwaprik iggi ka hiyá igma aynewatma awna mbayka numinhu. ");
INSERT INTO plu_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Mmanawa pahapwi ku pariye ka siguhwi, iggi udahan. ");
INSERT INTO plu_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ku pahapwi amnihyi awaku yis Cristo gihiyegapu, ku ig he ikí aynessa un kisepye ta yit, ayge nikwe ig utí gitiwninek. Ihanabay nuwnhu. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","―Hawwata akiw ku pahapwi taraksase pahapwi bakimni nopsesniye ku pariye kamaxwene nupitit, iggi katiwnihninek. Ig utinek mbayka pi mbayte akiw giw pahapwi ku pariye wanekwika gibitamna akak pahow tip nopsadminnano adahan ig padekwika parawhokwate. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","―Battukawnaba adahan pis apuriw pihiyakemni ba in kabayhtiwatma adahan pis ka taraksa. Ku pis hiyá pis me taraksemet akak piwak, pi kabayte pis bukihpin mpinekata pis tarakse. Mmanawa aysawnemenek pis katiwnipwenek apatra pitaraksan. Pi kabayte pis aymuhwa gimun Uhokri mawokuh mpinekata pis padekwika piwoknamte piwak ta arimkanit ini iwetrit ku kiney kaneayhsima kayahwaki, ta ariwtrikut eggu tiket ku pariye kane awakti. ");
INSERT INTO plu_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ayge miykehriki apanenekwa. Ayge akatwa kewa tiketbe ahaksan apanenekwa. ");
INSERT INTO plu_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Nikwe battukawnaba adahan pis apuriw pihiyakemni adahan pis ka taraksa. Ku pis hiyá pis me taraksemet akak pikugku, pi kabayte pis bukihpin mpinekata pis tarakse. Mmanawa aysawnemenek pis katiwnipwenek apatra pitaraksan. Pi kabayte pis aymuhwa gimun Uhokri yuma pikugku mpinekata pis padekwika pekbakte pikugku ta arimkanit ini iwetrit ku kiney kaneayhsima kayahwaki. ");
INSERT INTO plu_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ayge miykehriki apanenekwa. Ayge akatwa kewa tiketbe ahaksan apanenekwa. ");
INSERT INTO plu_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ku pis hiyá pis me taraksemet awaku pis ipeg arimkat ku pariye arikna kane kabay, pi kabayte pis wareke piwtyak mpinekata pis tarakse. Mmanawa pi kabayte pis aymuhwa gimun Uhokri gikumadukan mowtih mpinekata pis padekwika pegbakte piwtyak ta arimkanit ini iwetrit ku kiney kaneayhsima kayahwaki. ");
INSERT INTO plu_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ayge miykehriki apanenekwa. Ayge akatwa kewa tiketbe ahaksan apanenekwa. ");
INSERT INTO plu_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ka muwaka apis adahan ku pis hiyá mbeyne ay amadga inin. Ku wis hiyá mbeyne in katiw ke wotbe tiketbe hakiswew, henneme in ik adahan in kabayha uhiyakemni. In kabayha uhiyakemni ku samah pam kabayha im. Madikte hiyeg pemehepkanek akak ini tiket. ");
INSERT INTO plu_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Nikwe battukawnay adahan yis apuriw yihiyakemni ba in kabayhtiwatma adahan yis ka taraksa adahan yis ka humaw kema pamma biyuksa niketri. Pam kabay, henneme ku in biyukse niketri, wis ka hiyá wisma kabayhin akiw. ");
INSERT INTO plu_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Pisenwa ig Kiyapwiye Jesus kannikaw ig pes aytontak ta apitit Judeyamnaw pahambakatak warik Jordawh. Ig danuh atere, kaayhsima hiyeg pahadguhwa ta gimkanit akiw. Ayge ig kannuhpigkis ku samah inpawa ig keh. ");
INSERT INTO plu_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ayteke gaytakkis farisewkis danuh atere git. Igkis ayaptig adahan gihikekten ba ig awna yuwit taraksebetnama. Igkis ayapri: ―Ba wadit adahan wis isaksa pahapwi adahan ig mayta gihayo? ");
INSERT INTO plu_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Igme kaytwa giwnkis: ―Mmahpa amekene Moís gikumadukan akki ta yit? ");
INSERT INTO plu_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Igkisme kaytwa giwn: ―Amekene Moís isaksa pahapwi adahan ig mayta gihayo. Ig awna: “Ku pahapwi maytepye gihayo, amawka ig ikí gut pahak kagta ku pariye awna: ‘Pis ka nuhayama akiw’. Ayteke nikwe hiyawa ig maytepru.” ");
INSERT INTO plu_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Igme Kiyapwiye Jesus awna ta gitkis: ―Ig amekene Moís tameke inakni gikumadukan yidahan awaku yis yidahniskata ihpa Uhokri giwn. ");
INSERT INTO plu_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Henneme minikwak humawkariwka ka hennema. “Humawkariwka ig Uhokri keh hiyeg humaw awayg gukak tino. ");
INSERT INTO plu_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ku aysaw pahapwi awayg maripkaw, ig tipik giw gig gukak ginag. Ig hamah gukak gihayo. ");
INSERT INTO plu_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Amun ini nikwe egkis piyamate humaw ke wotbe egkis pahapwiwatbe gupitkis pawtak.” Ayge nikwe ke wotbe egkis pahapwiwatbe. ");
INSERT INTO plu_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Amawka ku hiyeg amadgaya inin ka ibakhasa ku pariye Uhokri hamahkise pawtak. ");
INSERT INTO plu_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Pisenwa inakni gawnhan, ig Kiyapwiye Jesus tipik ta paytrikute. Ayge agiku payt igkisme gikannuhnipwi ayapri akiw adahan maytwawka. ");
INSERT INTO plu_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Igme awna ta gitkis: ―Ku pahapwi mayta gihayo, ku ig maripkaw gukak pahapuwa tino akiw, ay amun ini nikwe giwtrik Uhokri ig kuwis powkemnihwe gukak. ");
INSERT INTO plu_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Hawwata akiw ku eg tino mayta gugihgi, ku eg maripkaw gikak pahapwiwa awayg akiw, ay amun ini nikwe giwtrik Uhokri eg kuwis powkemnihwe gikak. ");
INSERT INTO plu_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ayteke hiyeg danuh atere git Kiyapwiye Jesus. Igkis waxe gikamkaykis ta git adahan ig sarayh giwak ta gipititkis adahan ig kiyene Uhokri gidahankis. Igkisme gikannuhnipwi hiyapni henne, igkis awna gitkis adahan igkis ka ayta sigimwihgi. ");
INSERT INTO plu_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Igme Kiyapwiye Jesus hiyapni henne, ig ka batek. Ig himehe gikannuhnipwi ayge. Ig awna gitkis: ―Isaksanabay bakimnay ites aytnite numkanit. Ka yi muwaka mpitha bakimnay. Mmanawa ku pariye hiyeg gihiyakemnikis kene bakimnibe ignesnewa ku pariye kawih Uhokri gikumadukan. ");
INSERT INTO plu_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ku pahapwi ka iha Uhokri gikumadukan kema bakimnima, iggi ka kawih Uhokri gikumadukan. Ihanabay inakni nuwnhu. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ayteke nikwe ig ahiwape bakimnay, ig ugiswigkis. Ig sarayh giwak ta gipititkis. Ig kiyé Uhokri gidahankis. ");
INSERT INTO plu_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ayteke ig Kiyapwiye Jesus tipikwiye. Ku aysaw ig apigku ahin, pahapwi awayg sigis ta gitiput, ig paberetusaw ta gikimpuit. Ig ayapri: ―Kiyapwiye, pis kibeynewa hiyeg. Uyá akki nuthu. Pariye nah keh kuri adahan nah aymuhwa gimun Uhokri adahan apanenekwa? ");
INSERT INTO plu_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Igme Kiyapwiye Jesus kaytwa giwn: ―Mmah pis kanumun ku nah kibeyne hiyeg? Yuma pahapwinama hiyeg amadgaya inin kibeyne. Uhokri ignewa ku pariye kibeyne hiyeg. ");
INSERT INTO plu_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Pis kuwis hiyak ku pariye amawka pis keh adahan pis aymuhwa gimun Uhokri, mmanawa pis hiyak amekene Moís gikumadukan kuwis. Inakni gikumadukan awna: “Ka muwaka umah hiyeg. Ka muwaka powkemnihwa. Ka muwaka amepwi. Ka muwaka wasaymhaw. Ka muwaka kinis. Kiyatha pig. Kiyatha pinag.” ");
INSERT INTO plu_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Igme awayg awna git: ―Kiyapwiye, ku samah nah takwa nah iha madikte. ");
INSERT INTO plu_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Igme Kiyapwiye Jesus timapni henne, ig sarayh gipegyi gimkat kagibetkisima. Ig kaytwa giwn: ―Pehete muwak pit ku pariye pis kote ihapte. Amawka pis batek gikak Uhokri mpiya madikte pewkanbet. Ataknaba piyuk pewkanbet madikte. Ayteke nikwe pis ikí akakurapig ta gitkis madiptapye. Ayge nikwe pis utí kaayhsima igiska ayhté inugiknek. Ayteke pisenwa papiykan pewkanbet pis ayta wew nukakhu. ");
INSERT INTO plu_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Igme awayg timapni henne, ig wakaymni adahan ku samah inakni giwn. Ig barukiswe kaayhsima mmanawa ig kaayhsima gewkanbet ay gimun. Ig apise ku nawenétke ig biyuk akak ini gewkanbet. Aydyé ig tipik. ");
INSERT INTO plu_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ig Kiyapwiye Jesus hiyapni henne, ig ipegpusa nerras hiyeg ayge. Ayteke ig awna ta gitkis gikannuhnipwi. Giwn: ―Kaayhsima mahiko adahan hiyeg igisapye kawih Uhokri gikumadukan. ");
INSERT INTO plu_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Igkisme gikannuhnipwi wakaymni adahan inakni giwn. Igme Kiyapwiye Jesus awna gitkis akiw. Giwn: ―Nukebyupwi, kaayhsima mahiko kawih Uhokri gikumadukan gidahan pahapwi ku pariye ipegnene ta apitit igiska. ");
INSERT INTO plu_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ku yis hiyá ku mahiko adahan pahapwi puwikne “kamelu” parak mapiya apuriku pahat kakus amiyokni, in pi mahikote akiw adahan pahapwi igisye parak ku kiney Uhokri gikumadukan. ");
INSERT INTO plu_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Igkis timapni henne, igkis wakaymnibdi mpiynepepye. Igkis awna ta git: ―Ta wothu ku pahapwi igisye, in arakak ku ig kibeyne giwtrik Uhokri mmanawa ig kabunuga gikak Uhokri. Ku mahiko henne adahan igisapye danuh git Uhokri, nikwe yuma hiyeg amadga wayk danuhne git Uhokri. ");
INSERT INTO plu_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Igme Kiyapwiye Jesus sarayh gipegyi ta gimkanitkis. Ig awna ta gitkis: ―Madikte hiyeg ka hiyá ignesma danuh git Uhokri ku ka igma Uhokri amnihgikis. Henneme madikte arikna ka mahikonama gidahan Uhokri. ");
INSERT INTO plu_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Igme kiyapwiye Pedru awna git: ―Usuh kuwis ikise madikte wewkanbet adahan usuh wewne pikak. ");
INSERT INTO plu_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Igme Kiyapwiye Jesus kaytwa giwn: ―Ku pahapwi ikiswiye gipin, gikak gikebyupwi, ginag, gig, gikamkayupwi, giwasra, ku ig ikiswiye madikte adahan ig ayta nuharit, adahan ig tahhan ekkene nnetni, ");
INSERT INTO plu_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ig ner utí nikwe pi kibite akiw, madikawku madikwa gukebyikis (100) akiw kuri amadga inin hawkri. Ig utí madikawku madikwa (100) gipin, madikawku madikwa (100) gikebyupwi, madikawku madikwa (100) ginag, madikawku madikwa (100) gikamkayupwi, madikawku madikwa (100) giwasra, henneme ig hawwata ig hiyá mbeyne kaayhsima ndahan. Hawwata akiw aysawnemenek ayhté inugik ig aymuhwa gimun Uhokri adahan apanenekwa. Ihanabay inakni nuwhu. Hennewatbaki ig utinek. ");
INSERT INTO plu_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Henneme ka yi muwaka ikaw kiyatte mpiy pahapwi awaku ini. Mmanawa aysawnemenek kaayhsima hiyeg ku pariye ikaka pi kiyatte mpiy pahapwi, aysawnemenek ignes ka mpiya pahapwinama hiyeg Hawwata akiw kaayhsima hiyeg ku pariye ikaka yumanene gikiythanikis ay amadga inin, aysawnemenek yuma hiyeg pi kiyatte mpiyigkis. ");
INSERT INTO plu_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ayteke igkis ay apigku ahin tipikwiyes arimkat paytwempu Jerusalém, ig Kiyapwiye Jesus wew pitati gapitkigkis gikannuhnipwi. Igkisme wakaymnibdi ku samah ig atere kuri. Igkisme gihaptiyepwikis igkis apisasew gikak. Ayteke ig pahadguh giwatnipwi (12) ta git akiw, ig akkamnih gitkis amin ku pariye nemnikumpiye git. ");
INSERT INTO plu_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ig awna gitkis: ―Kuri wixwiy wagehe ta arimkanit Jerusalém. Nah ku pariye wageswe awayg amadgaya inin nah kamaykiswikanek ayge ta gitkis muwpeg kiyatyepwi ta gitkis nerras kannuhekeputnepwi amin amekene Moís gikumadukan. Ayge apim ini igkis ikaksepun adahanikwa miyaka. Igkis ikepun ta giwakuitkis hiyeg ku pariye kane judeyenepwima. ");
INSERT INTO plu_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Igkisme mahipwihpennek, igkis tupestepun, igkis biptepun akak tigay. Pisenwa nikwe igkis umehpen. Henneme amamnam hawkri ariwntak numiremni nah kannikaw akiwnek. ");
INSERT INTO plu_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ayteke ig amekene Tiyagumni gikak kiyapwiye João, ku pariye amekene Zebedew gukamkayupwi, igkis danukwa atere git Kiyapwiye Jesus. Igkis ayá git: ―Kiyapwiye, usuh muwaka pis ikí wot ku pariye wayapni pit. ");
INSERT INTO plu_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Igme Kiyapwiye Jesus ayaprikis: ―Pariyeki pimawkan nuthu? ");
INSERT INTO plu_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Igkis kaytwa giwn: ―Aysawnemenek apim ini ku aysaw pis kumadukenenek akak madikte pikiythani, uyá amnih isiy usuh adahan usuh bat ayge pihumwa ay amun ini iwetrit ku pariye kanenikithanisima. Umawkan pahapwi bat kihehaptak, pahapwime bat patuwanaptak. ");
INSERT INTO plu_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Igme Kiyapwiye Jesus kaytwa giwnkis: ―Yis ka hiyak ku pariye yayapni nuthu. Aysawnemenek nah hiyá mbeyne kaayhsimanek. In ke nuthube nah higá higapka kaneatipinisima agikutak pahow goblé. Ba yis ik adahan yis higá agikutak no goblé hawwata ke nahbe? Ba yis ik adahan yis amapa inwata mbeyne ku pariye kawihkiska ta nupitit? ");
INSERT INTO plu_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Igkisme kaytwa giwn: ―Ihi. Usuh ik adahan amapin hawwata ke pisbe. Igme Kiyapwiye Jesus awna gitkis: ―Aysawnemenek yis higá ini nuhigpannek agikutak nugobla. Yis amapa inwata mbeyne ku pariye kawihkiska ta nupitit. ");
INSERT INTO plu_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Henneme ka nawhma batahkis hiyeg ayge nuhumwa iné kihehaptak iné patuwanaptak. Ini iwetrit kanenikiythanisima ini gidahankis hiyeg ku kadahan Wigwiy kuwis ahegbetin. ");
INSERT INTO plu_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Igkisme Jesus giwatnipwi asemne madikawkunene gikebyikis, igkis timapni henne, igkis hahhayruke gikakkis amekene Tiyagumni gikak kiyapwiye João. ");
INSERT INTO plu_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Igme Kiyapwiye Jesus hiyapni henne, ig pahadguhpigkis git. Ig awna gitkis: ―Ka yi muwaka ikaw gapitminnama pahapwi. Yis kuwis hiyak nerras ku pariye ikewnenepwi ikiparat amadgaya inin gihiyakemnikis, yis hiyak ku samah igkis ikaw gapitminkis gihiyegapukis, igkis kabukhewpi gitkis. ");
INSERT INTO plu_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Yisme ka hennema. Yidahan nawenéwa. Ku pahapwi yaytak humewkere yapitmin madikte giwtrik Uhokri, amawka ig ka kabukhaw yit. Amawka ku ig ikaw ke wotbe igwa yibukbe. ");
INSERT INTO plu_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ku pahapwi yaytak humewkere kiyatye hiyeg giwtrik Uhokri, amawka ku ig ikaw ke wotbe ig yumahbe gikiythanibe ay amadga inin. ");
INSERT INTO plu_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Amawka ku yis ikaw hawwata ke nahbe. Nah ku pariye wageswe awayg amadgaya inin nah ka ayta adahanma hiyeg kehne kabayka nukakhu henneme nah ayta adahanikwa nah kehne kabayka gikakkis. Hawwata akiw nah ayta adahan nah umahkiswa gidukwenaprikkis hiyeg kahadbe ignes isamtaw. ");
INSERT INTO plu_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ayteke ig Kiyapwiye Jesus gikakkis gikannuhnipwi igkis danuh ta apitit paytwempu Jerikó. Igkis mpiye niyegbiw. Ku samah igkis peswiyes apititak ini paytwempu, kaayhsima hiyeg makeke gihapukis butte. Apiminewa ini pahapwi motpiye bat ayge ahinmu. Giw Bartimew. Ig amekene Timew gikamkayh. Ig makehpene karukri gitkis hiyeg. ");
INSERT INTO plu_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ig kinetni gak Kiyapwiye Jesus nazaréyene ku ig mpiyepye. Ig timapni henne, ig kapusa kabiman git: ―Kiyapwiye, pis ukipara hawwata ke amekene Davibe. Uyá amnihun. ");
INSERT INTO plu_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Kaayhsima gaytakkis nerras hiyeg igkis timapni henne, igkis himehpig. Igkis awna ta git: ―Ka muwaka kabiman henne. Igme pi kabimenpipa akiw. Ig awna: ―Kiyapwiye, pis ukipara hawwata ke amekene Davibe, uyá amnihun. ");
INSERT INTO plu_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ig Kiyapwiye Jesus timapni inakni gabiman henne, ig msekwe. Ig awna: ―Wani ig ayta nuthu. Igkisme humak ner motipye. Igkis awna git: ―Ka ba barukinama. Asá kannikaw. Ig humakpi. ");
INSERT INTO plu_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Igme timapni henne, ig padeke gidagmanpit. Ig kannikaw kibentenwa. Ig danuh atere git Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ig danuh atere git, igme Kiyapwiye Jesus awna git: ―Pariye pimawkan nuthu? Igme ner motipye kaytwa giwn: ―Kiyapwiye, nah muwaka nah hiyap akiw. ");
INSERT INTO plu_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Igme Kiyapwiye Jesus awna git: ―Nukebyi, pikamaxwan nupitit keh pis makniw. Hiyawa pis diyuhe pipinwate. Aynewa ig hiyap. Ayteke ig makekwepi gihapu apigku ahin. ");
INSERT INTO plu_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ayteke igkis tipikwiye akiw. Igkis kennesmin gidawnhankis arimkanit paytwempu Jerusalém, igkis danuh ta apitit pisaya paytwempu ku pariye nopsanyupwinen kewye Betfajé akak Betâniya ayge apit ini waxri imuhgipitnene kewye Olipegpit. Ayge ig Kiyapwiye Jesus awahkiswiye piyana gikebyikis giwatnipwi adahan igkis ta sunepnes gidahan kaway. ");
INSERT INTO plu_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ig awna gitkis: ―Ataknabay apitit ini paytwempu nopsanyu pahambakaytak. Parakantenwa yis hiyá pahapwi kawayyan “jumentinyu”. Ayge ig wanak. Hiyeg kote batte giduhyamadgat. Wataknig waxwanig atan nuthu. ");
INSERT INTO plu_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ku hiyeg ayge awna yit: “Mmeneki yis dax?”, yisme kaytwa giwnkis: “Kiyapwiye muwakapri. Ig ka ayipwihwa, ig diyuhkiswig atanewa akiwnek.” ");
INSERT INTO plu_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ayteke nikwe igkis giwatnipwi tipik danuh ta apitit paytwempu. Ayge igkis uté pahapwi kawayyan apigku ahin. Ig wanakka anumeku pahá lappot. Igkis atere watekwig. ");
INSERT INTO plu_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ignes hiyeg aygnenepwi hiyapni henne, igkis ayaprikis: ―Mmeneki yis dax yis watak ner kawayyan? ");
INSERT INTO plu_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Igkisme akkamnih gitkis inakni yuwit ku samah Kiyapwiye Jesus awna. Nikwe igkis isaksigkis adahan igkis tipik. ");
INSERT INTO plu_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ayteke igkis diyuhe waxe ner kawayyan ta gimkanit Kiyapwiye Jesus. Igkis danuh atere, igkis amboha gidagmanpitkis ta giduhyamadgat. Pisenwa ig Kiyapwiye Jesus sarayhwe giduhyamadgat ner kawayyan. ");
INSERT INTO plu_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Kaayhsima hiyeg ayge igkis hiyapni henne, igkis barewha ahin gapit pitati. Igkis awasaprike ahin akak gidagmanpitkis. Gaytakkisme ihuk ahamna ke kariktimnabe amadgatak giwasrakis. Igkis awasaprike ahin nikak. ");
INSERT INTO plu_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ayteke ku pariye hiyeg kabubuknene gapitkig gikakkis nerras buttitwiyepwi igkis kabiman: ―Kibeyne gidahan Uhokri! Uhokri gabay gikaknek ner ku pariye ayta giwaprik Uhokri. ");
INSERT INTO plu_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Uhokri gabay gikaknek. Ig ayta kumadukawiy atan hawwata ku samah amekene Davi gikumadukan. Kibeyne gidahan Uhokri! ");
INSERT INTO plu_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ayteke ig Kiyapwiye Jesus parak apurit paytwempu Jerusalém. Ayteke ig parak ta agikut ini leglis kewye Uhokri Gipin. Ig ipegpusa madikte. Ayteke ig pes, ig tipik ta apitit paytwempu Betâniya gikakkis giwatnipwi mmanawa kuwis aygete. ");
INSERT INTO plu_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Hewke akiw ig Kiyapwiye Jesus pes apititak paytwempu Betâniya gikakkis gikannuhnipwi. Ig matipwe. ");
INSERT INTO plu_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ig hiyá pahakti ah akat piyawakte aynessa. No ah akat kewyo “figeyra”. Nikwe ig atere iwasene guw. Ig danuh atere, ig ka utí pahownama guw. Ig utí he gapannenwa ayge mmanawa guhawkanaprik kote danuhte adahan eg kew. ");
INSERT INTO plu_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ig hiyapni henne, ig awna ta gut no ah akat. Giwn: ―Kuri hiyeg ka takunima ax piw akiw. Igkisme gikannuhnipwi timá inakni giwn ayge. ");
INSERT INTO plu_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ayteke ariwnteke ini igkis danuh ta apitit paytwempu Jerusalém. Ig Kiyapwiye Jesus pareke ta agikut ini leglis kewye Uhokri Gipin. Ayge ig uté hiyeg ku pariye piyuknepwi puwikne adahan hiyeg kakanhewnes ta git Uhokri. Ig hiyapni henne, ig ipukwapeprikis. Hawwata ig ipukwape hiyeg ku pariye isimnepwi ayge. Ig tukuhape gaxtenkis hiyeg ku pariye uniyekeputnepwi karukri. Ig tukuhape gepwikis hiyeg ku pariye piyuknepwi tukwa. ");
INSERT INTO plu_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ig mpithe hiyeg mpiya agiku Uhokri Gipin hiyuwe akak arikna. ");
INSERT INTO plu_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ayteke ig kannuhhekne ayge. Ig awna ta gitkis hiyeg: ―Uhokri gannasan minikweknene awna: “Inin nupinhu in piriyepkewket adahan madikte hiyegipiyenepwi amadga wayk.” Yisme kehne Gipin humaw amepwiyeket. ");
INSERT INTO plu_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Igkisme nerras muwpeg kiyatyepwi gikakkis nerras kannuhekeputnepwi amin amekene Moís gikumadukan igkis timapni henne, igkis ipegminene gihiyakemnikis, igkis awna: ―Mmenepri wixwiy hiyá giwmepka kuri? Igkis apisemun gibohri awaku madikte hiyeg ayge wakaymnibdi adahan gikannuhhakni. ");
INSERT INTO plu_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Aygete kuwis ig Kiyapwiye Jesus tipik apititak paytwemputak gikakkis gikannuhnipwi. ");
INSERT INTO plu_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Hewke akiw ig Kiyapwiye Jesus diyuhpiye ta arimkat paytwempu Jerusalém akiw gikakkis gikannuhnipwi. Ku aysaw igkis apigku ahin, igkis hiyá no ah akat kewyo “figeyra”, eg kuwis huruhrup madikte payak akak guhampabet. ");
INSERT INTO plu_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Igme kiyapwiye Pedru hiyapni henne, ig kiyé inakni ku pariye Kiyapwiye Jesus awna ta gut no ah akat. Nikwe ig awna ta git: ―Kiyapwiye, ipeg gumkat no ah akat ku pariye pis awna gukak. Eg kuwis huruhrup. ");
INSERT INTO plu_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Igme Kiyapwiye Jesus kaytwa giwn: ―Kamaxwanabay ta gipitit Uhokri. ");
INSERT INTO plu_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ku yis awna ta arit inin waxri imuwadnene: “Waxri, pis higihwa ayteke. Su tipik ta ahakwat parawhokwate.” Ku yis ayá git Uhokri akak madikte yikamaxwan, ku yis hiyak ku inyerwa in yayapni git ku in humaw, nikwe madikte yayapni git humaw yitnek. Ihanabay inakni nuwnhu. Hennewatbaki in humaw. ");
INSERT INTO plu_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Inneki keh nah awna yit: “Ihpanay ku yis kuwis darihe ku pariye yayapni git Uhokri. Nikwe in humaw yitnek. ");
INSERT INTO plu_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ku aysaw yis piriyepkewne, bayahminabay ku pariye hiyeg tarakse yikak. Ku yis bayahminigkis ariw gitaraksankis yikak, nikwe Wigwiy inugikyene ig hawwata bayahminay ariw yitaraksan gikak. ");
INSERT INTO plu_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Henneme ku yis ka bayahminigkis ariw gitaraksankis, nikwe Wigwiy inugikyene kawnata bayahminay ariw yitaraksan. ");
INSERT INTO plu_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Pisenwa inakni gawnhan igkis danuh ta apitit paytwempu Jerusalém. Igme Kiyapwiye Jesus tipik parekwiye agikut ini leglis kewye Uhokri Gipin. Ku samah ig waywe ayge, nerras muwpeg kiyatyepwi gikakkis judeyenepwi giwewkistenkis igkis patiptakig atere. ");
INSERT INTO plu_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Igkis ayapri: ―Mmahki pis keh ini ku pariye pikehni ay? Kariwntak pis utí pikumadukan adahan pis keh henne? ");
INSERT INTO plu_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Igme Kiyapwiye Jesus kaytwa giwnkis: ―Nah hawwata ayapyi pahat ayapka. Ku yis akkamnihni nuthu, nikwe nah hawwata akkamnih yit ku kariwntak nah utí nukumadukan adahan nah keh henne. ");
INSERT INTO plu_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Uyay akki nuthu. Kariwntak amekene João Batistamni utí gikumadukan adahan ig kaywa hiyeg? Ba giwntakwatma Uhokri? Ba kawk, ba he giwntakkisnenwatma hiyeg amadgayapu inin? ");
INSERT INTO plu_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Igkis timapni henne, igkis kinetihwa pawtak adahan ahegbetepyes ginetnikis. Ayge igkis awna: ");
INSERT INTO plu_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","―Ku wixwiy kaytwa giwn ku ig amekene João Batistamni utí gikumadukan giwntakwa Uhokri, nikwe ig awne wotwiy: “Mmahki nikwe yis ka iha giwn?” Henneme ku wixwiy kaytwa giwn ku ig utí gikumadukan he giwntakkisnen hiyeg amadgayapu inin, nikwe madikte nerras hiyeg ay hahhayruke ukakwiynek. Igkis pukuhpaw gibohrikis nerras hiyeg kabubuknene ayge mmanawa gitkis nerras hiyeg ig amekene João Batista ignewa Uhokri gawnepe. ");
INSERT INTO plu_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ayteke nikwe igkis kaytwa giwn Kiyapwiye Jesus: ―Usuh ka hiyak ku kariwntak ig utí gikumadukan. Ayge nikwe igme Kiyapwiye Jesus awna gitkis: ―Ku samah yis ka akki nuthu, nikwe nah kawnata akki ta yit ku kariwntak nah utí nukumadukan adahan nah kehne ini ku pariye nukehni ay. ");
INSERT INTO plu_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ayteke ig Kiyapwiye Jesus awna pahat yuwit patuwesbuhka ta gitkis. Ig awna: ―Minikwak pahapwi awayg mutuhe giwasra. Giwasra “uvapunen”. Ayteke ig kiyaraniwhe ini giwasra. Ayteke ig atikeku pahow tip nopsadminano adahan kumuktet adahan wiwhne “uva” araku. Ayteke ig keh apuriwket imuwad. Pisenwa nikwe ig ibekhe giwasra pabakak gikakkis hiyeg ku pariye giwasra akapriwten. Pisenwa ig tipik ta apitit nawenéwa waxri akiw. ");
INSERT INTO plu_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ku aysaw danuh apatyaprik amutri, ig awahkise pahapwi gihiyega ta giminkis nerras akapriwten was adahan igme iwepye abusku gamutra guw amadgatak giwasra adahan ewkwiye ta git. ");
INSERT INTO plu_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Igkisme akapriwten was igkis kamaxe gihiyega. Igkis biptepri. Ayteke igkis awahkiswig hennen. Igme tipik danuh ta git gikipara yuma ariknawnama giwaku. ");
INSERT INTO plu_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ig was akipara hiyapni henne, ig awahkis pahapwiwa gihiyega atere akiw. Igme danuh atere, igkisme akapriwten was huwipwihe gitew. Igkis mahipwihpig. Pisenwa igkis awahkiswig tipik. ");
INSERT INTO plu_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ayteke igme gikipara awahkis pahapwiwa gihiyega akiw atere giminkis. Igme danuh atere, igkisme umehpig. Kaayhsima nawenépwi gihiyegapu awahkiska giminkis. Igkis akapriwten was bipte gaytakkis, gaytakkisme igkis umehe. ");
INSERT INTO plu_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Pahapwi msekwe adahan ig was akipara awahkiswiye atere giminkis, iggi gikamkayh gibetki. Ig hiyapni henne, ig awna: “Nawenétke ner nukamkayh igkis kiyatha.” Nikwe ig awahkiswig atere giminkis. ");
INSERT INTO plu_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Henneme ig gikamkayh danuh atere, nerras akapriwten was amiyhepri. Igkis kinetihwa pawtak, igkis awna: “Nernewa was akipara gikamkayh. Uyay umehpig mpinekata kuwewanek ini was msekwe madikte gidahan. Pi kabayte wixwiy umehpig adahan ini was msekwe udahanwiy.” ");
INSERT INTO plu_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ayteke nikwe igkis kamaxwig igkis umehpig igkis padekwig ayteke amadgatak giwasra. ");
INSERT INTO plu_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Pisenwa gawnhan inakni yuwit patuwesbuhka, ig Kiyapwiye Jesus awna gitkis: ―Kuri uyay akki nuthu. Pariye yipewkan ig was akipara keh gikakkis nerras akapriwten giwasra? Nah akkite yit. Ig ayta pisenwa gikakkisnek. Pisenwa ig ibakha giwasra pabakak gikakkis nawenépwiwa hiyeg akiw. ");
INSERT INTO plu_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Mmah yis kote ipegbohate Uhokri gannasan minikweknene ku samah in kinetihwa amin inakniwata hiyakemniki? In awna: “Hiyeg kehne payt tiptiye, igkis tukuhe pahow tip. Gipewkankiskam ku eggu tip ka kawihkam. Bawa eggu tip pi awaygtenano ariw madikte. Eg humaw adahan payt akoksa. ");
INSERT INTO plu_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Igwa Uhokri ikaksig henne. In kabayhtiwa wotwiy eg humaw henne.” Hennewatbaki ig Uhokri gannasan awna. ");
INSERT INTO plu_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Nerras judeyenepwi giwewkistenkis timapni inakni yuwit patuwesbuhka henne, igkis pukuhe ku ig awna inakni yuwit giminkis ku samah igkis tukuhptepri. Ayge nikwe igkis mpiksaw giharit adahan gikamaxwitni. Henneme igkis apisemun gibohrikis nerras hiyeg kabubuknene ayge awaku ignes hiyeg kiyathe Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ayteke ariwnteke ini igkis farisewkis kiyatyepwi awahkise gaytakkis farisewkis payak gikakkis amekene Erodis gihiyegapu adahan igkis hiyá ba igkis keh Kiyapwiye Jesus awna yuwit taraksebetnama adahan igkis gimetkepten. ");
INSERT INTO plu_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Igkisme danuh atere, igkis awna git: ―Kiyapwiye, usuh hiyakpi ku pis waditye hiyeg. Pis ka awna mpusema yuwit gidahankis hiyeg. Pis awna pahatwowa yuwit ta gitkis madikte hiyeg. Hiyawa hiyeg gihiyakemnikis nawenéwa ariw pidahan, henneme in ka sam ta pit. Pis awna pahatwowa yuwit. Pis akki Uhokriyerwa gihiyakemni gitkis. Kiyapwiye, usuh muwaka hiyak pahat hiyakemniki. Ig kiyapwiye Sésar nerras romayenepwi gikiparakis ig mpiksaptih wixwiy judeyenepwi adahan wixwiy katiwnihgi. ");
INSERT INTO plu_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ba wadit adahan wixwiy katiwnihgi? Ba ka wadit? Ba amawka ku wixwiy katiwnihgi? Ba kawk, ba wixwiy ka muwaka? Igme Kiyapwiye Jesus kuwis hiyakni ku gihiyakemnikis piputnambet igkis awna inakni adahan gikinsepten. Ig hiyapni henne, ig kaytwa giwnkis: ―Mmahki yis ayta nuhikekten henne? Ewknay nuthu pahamku karukri adahan nah guhiypetni. ");
INSERT INTO plu_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Igkisme timapni henne, igkis iwé pahamku karukri igkis ewkwig ta git. Ayteke nikwe ig ayaprikis: ―Pariyepa kahehpakye gumadga no karukri? Pariyepa kewye ay gumadga? Igkisme kaytwa giwn: ―Inin kiyapwiye Sésar giw. Inin ahehpakti kiyapwiye Sésar gahehpak. ");
INSERT INTO plu_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Igme kaytwa giwnkis: ―Nikwe no karukri kawih gidahan kiyapwiye Sésar. Hiyawa wixwiy ikepru git. Henneme amawka ku wixwiy ikí ta git Uhokri madikte ku pariye kawih gidahan Uhokri. Igkis timapni inakni giwn henne, igkis wakaymnibdi kaayhsima. ");
INSERT INTO plu_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ayteke ariwnteke ini nawenépwi hiyeg danuh atere git Kiyapwiye Jesus akiw. Igkis sadusewkis. Gitkis sadusewkis hiyeg miyá ignes pisenwe gihawkankis ignes ka kannikaw akiw. Igkis sadusewkis danuh atere, igkis awna git: ");
INSERT INTO plu_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Kiyapwiye, amekene Moís tamakkis gikumadukan amadga kagta udahanwiy. Inakni gikumadukan awna: “Ku pahapwi hiyeg miyá guw gihayo, ku ig yuma gikamkayh gukak eggu gihayo, amawka gikebyi maripkaw gukak eggu giwgun marihwa eg kakamkayh hawwata ke wotbe ignebe gikebyibe kakamkayh gukakbe.” Hennewatbaki ig amekene Moís gikumadukan awna. ");
INSERT INTO plu_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Boh. Minikwak ntewnehker gikebyikis. Ig eggutye maripkew gukak pahapu tino. Ayteke ig miyap kawke ig kakamkayh gukak. ");
INSERT INTO plu_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ayteke nikwe ig gisamwi gipun maripkew gukak eggu giwgun. Ig hawwata ig miyap guw. Ig kawnata kakamkayh gukak. Ayteke nikwe ig gisamwikis gimamnamkis ig hawwata ig maripkew gukakwata akiw. ");
INSERT INTO plu_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Henne madikte nerras ntewnehkernene gikebyikis miyarapwata. Igkis yuma pahapwinama kakamkayh gukak. Pisenwa egme hawwata eg miyop. ");
INSERT INTO plu_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kuri, Kiyapwiye, usuh ayapi. Aysawnemenek apim ini ku aysaw hiyeg kannikaw ariw gimiremnikis, pariyepahki gibetitakkis nerras ntewnehkernene gikebyikis darihgu? Mmanawa igkis ntewnehkernene gikebyikis maripkewnekwiye gukak. ");
INSERT INTO plu_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Igme Kiyapwiye Jesus kaytwa giwnkis: ―Mmahkay yis tarakse? Yis tarakse mmanawa yis ka pukuhpa Uhokri gannasan minikweknene iné yis kawnata hiyak ku samah Uhokri gidatni. ");
INSERT INTO plu_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Aysawnemenek apim ini ku aysaw hiyeg kannikawbet ariw gimiremnikis, ayge ignes ka maripkaw akiw. Igkis msakwa hennep ke ahjbe. ");
INSERT INTO plu_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Kuri uyay kinetihwa amin wixwiy hiyá ba hiyeg kannikaw ariw gimiremnikis. Mmah yis kote ipegbohate amadgatak amekene Moís gikagtan, ay abet inakni yuwit adahan tiket apuwpi ewwakti ku samah Uhokri awna ta git? Ig awna: “Nahnewa kuri Abrawh giwohkiga, nahnewa kuri Izaki giwohkiga, nahnewa kuri Jakó giwohkiga.” ");
INSERT INTO plu_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Inakni yuwit akki wot huwewe ku igkis gidukweneswa igkis ipeg. Ig Uhokri kawki miyarapyema giwohkigakisma. Ig hiyeg ipegnene giwohkigakis. Yis tarakse kaayhsima ku samah yis awna ku hiyeg miyá ignes pisenwa gihawkankis. ");
INSERT INTO plu_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ayteke ariwnteke ini pahapwi kannuhekeputne amin amekene Moís gikumadukan danuh atere, ig timepne ginetnikis ayge. Ig timapni henne ku samah Kiyapwiye Jesus kaytwa giwnkis kabayhtiwa, ig ayapri: ―Kiyapwiye, pariyepa Uhokri gikumadukan pi kabayte ariw madikte kumadukaki? ");
INSERT INTO plu_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Igme Kiyapwiye Jesus kaytwa giwn: ―Nah akkite pit ku pariye gikumadukan pi kabaytenene ariw madikte kumadukaki. “Ataybiswanabay numkanit, yis Israelyenepwi. Ukiparawiy Uhokri ig pahapwiwa ukiparawiy. ");
INSERT INTO plu_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Uyay batek gikak Kiyapwiye Uhokri akak madikte yiyakni. Bateknay gikak akak madikte yibetki. Bateknay gikak abet madikte yihiyakemni. Bateknay gikak akak madikte yidatni.” ");
INSERT INTO plu_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ayteke ariwnteknewa inakni yuwit ay pahat gikumadukan akiw ku pariye pi kiyatte pi kabayte ariw madikte kumadukaki. “Batek gikakkis piyakipwi hiyeg hawwata ku samah pis batek akak pipit.” Yuma nawenéwa gikumadukan pi kiyatte pi kabayte ariw inakni pitenemnene gikumadukan. ");
INSERT INTO plu_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ner kannuhekeputne timapni henne, ig awna git: ―Hennewa, Kiyapwiye. Pis awna wadit ku ig Uhokri ig pahapwiwa ukiparawiy. Ignewa Uhokri. Yuma pahapwinama kema igma. ");
INSERT INTO plu_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Amawka wixwiy batek gikak akak madikte uyakniwiy. Amawka wixwiy batek gikak abet madikte uhiyakemniwiy. Amawka wixwiy batek gikak akak madikte udatniwiy. Hawwata amawka wixwiy batek gikakkis uyakipwiy hiyeg hawwata ku samah wixwiy batek akak upitwiy. Pi kabayte wixwiy ihpa inakni gikumadukan ariw wixwiy kakanhaw akak puwikne ta git Uhokri. Ku wis ihpin, in pi kabayte git ariw madikte kakanhawka. ");
INSERT INTO plu_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ig Kiyapwiye Jesus hiyapni henne ku samah ig kaytwa giwn akak gihiyakemni, ig awna git: ―Pis kennesa git Uhokri gikumadukan. Ariwnteke ini yuma pahapwinama kibowkaye ayapri akiw. ");
INSERT INTO plu_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ayteke ku samah ig Kiyapwiye Jesus kannuhekne ayge agiku Uhokri Gipin, ig ayá hiyeg ayge: ―Mmahki nerras kannuhekeputnepwi amin amekene Moís gikumadukan kanumri Uhokri gikanyan adahan ukumaduketni, Cristo, mmahki igkis kanumri “amekene Davi gihiwhi”? Mmahki igkis ka kanumri “amekene Davi gikipara”? ");
INSERT INTO plu_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Igwa amekene Davi kanumri “nukipara”. Inakni yuwit ikepka git gapit Uhokri Gitip minikwak. Giwn: “Ukiparawiy Uhokri awna ta git nukipara Cristo. Giwn: ‘Batnaba ay nuhumwa kihehaptak amun inin iwetrit kiyatye ku samah nah sibuhkisnete pipetunyapu pit.’ ” ");
INSERT INTO plu_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ka ba yis hiyá igwa amekene Davi ka kanum Cristo “nuhiwhi”? Kawa. Ig kanumri “nukipara”. Ig Cristo ig ka he gihiwhinenwatma. Ig hawwata ig gikipara. Nerras hiyeg kabubuknene ayge igkis timapni henne, igkis bateke inakni giwn. ");
INSERT INTO plu_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ayteke ariwnteke ini ku aysaw ig Kiyapwiye Jesus kannuhekne, ig awna gitkis: ―Pukuhpawnabay adahan yis ka iwí gihiyakemnikis nerras kannuhekeputnepwi amin amekene Moís gikumadukan. Igkis ba gibetkatunkis wewnamahkis agiku gibereswetnikis. Igkis batek hiyeg aytnihgikis higiwmadga akak kiyathaki. ");
INSERT INTO plu_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Igkis batek bat amadga epti ku pariye pi kiyattenene agiku leglis. Hawwata igkis batek bat amadga epti kiyatyo abet fet. ");
INSERT INTO plu_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Bawa igkis wiwhpiyes madankunopwi gupinkis guwkis payak akak gewkanbetkis akak kiniska, henneme igkis piriyepkaw kiyabawkad marihwa hiyeg ikiygikis ku igkis kibeynepwi hiyeg. Aysawnemenek igkis katiwnipwenek apatra ini gihiyakemnikis. Apim ini igkis pi hiyapte mbeyne ariw nawenépwi hiyeg taraksapye. ");
INSERT INTO plu_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ayteke ig Kiyapwiye Jesus bat kennesa arit karukri atiy ayge agiku ini leglis kewye Uhokri Gipin. Ayge ig apuriwne hiyeg kehnepwi ofan gidahan Uhokri. Kaayhsima hiyeg igisapye mpiye awpre, igkis ikenes kaayhsima karukri ta agikut atiy. ");
INSERT INTO plu_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Egme pahapu madankuno madiptipyo danuh atere, eg ikano mmukna kirehka ta agikut no karukri atiy, aynessawa karukri. ");
INSERT INTO plu_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ig Kiyapwiye Jesus hiyapni henne, ig pahadguh gikannuhnipwi ta gimkat. Ig awna ta gitkis: ―No eg madankuno madiptipyo gukan pi kahayakte ta gipetunat Uhokri ariw gikankis madikte nerras hiyeg. Ihanabay inakni nuwnhu. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Mmanawa igkis kakanhaw akak gikakurakis asemne. Egme kakanhaw akak madikte gudahan gukakura. Yuma ariknawnama eg darih adahan isimno ku pariye gumawkanitnene. ");
INSERT INTO plu_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Pisenwa inakni gawnhan, ig Kiyapwiye Jesus tipikwiye adahan gipeswen ayteke agikutak Uhokri Gipin. Ig pesante, pahapwi gikannuhni awna git: ―Kiyapwiye, ipegnamu in Uhokri Gipin barewyewa paytwempu. Ipegnamu ini paytwempu ayaranwa kehka akak nopsadmin tip, barewyopwinen tip. ");
INSERT INTO plu_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Igme awna git: ―Mmah yis hiyá ini paytwempu? Aysawnemenek yis hiyapni madikte mehpikanek. In hirohe madikte waygboitenek. Iné pahow tip ka msakwanek papitmintak akak guyaki tip akiw. ");
INSERT INTO plu_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ayteke ig tipik, ig danuh atere apitit waxri imuhgipitnene kewye Olipegpit. Ayge ig batahkiswe asebha, ig pitatki ariw Uhokri Gipin. Igme kiyapwiye Pedru gikakkis amekene Tiyagumni, kiyapwiye João, kiyapwiye Andre, igkis danuh atere git igkiswonakis. Igkis ayapri: ");
INSERT INTO plu_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Kiyapwiye, kabetpahki inakni piwn kahayaknek? Pariye danuh adahan arekhetni ku madikte inakni pinetni kennesa adawnhannek? ");
INSERT INTO plu_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Igme Kiyapwiye Jesus kaytwa giwnkis akak kiyabawkad yuwit. Ig awna: ―Ka yi muwaka kinikiswa ta gitkis hiyeg. ");
INSERT INTO plu_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Mmanawa aysawnemenek kaayhsima hiyeg kahayaknek nuwaprik ke wotbe ignes ayta nuwntakbe. Igkis awnanek: “Nahnewa Cristo, nah Uhokri gikanyan adahan yikumaduketni.” Apim ini igkis kinisnes hiyeg kaayhsimanek. ");
INSERT INTO plu_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ayge apim ini yis timá kutimniki kennesa. Hawwata yis timá arak kutimniki piyawakad, henneme ka yi muwaka apis. Amawka ku ini kutimniki danuh henneme kote danuhte amaksemni hawkri. ");
INSERT INTO plu_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Mmanawa aysawnemenek pahabunene hiyegipiyenepwi kerbetpikisnek gikakkis nawenéwa hiyegipiyenepwi akiw. Gupelma kerbetpikis igkisweke gupelma. Apim ini hawkri kaayhsima sagkaki muwwapu waxribdiw. Hawwata kaayhsima mihetniki danuh muwwapunek. Henneme ininewa akapuska mbeyne. In ke pahapu tinobe ku aysaw eg kapusa kayah gukamkayh adahan eg pamakutekwiyo. In he akapuskanen. ");
INSERT INTO plu_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","―Msakwanabay ahegbet apit ku pariye danuh ta yitnek apim ini hawkri. Mmanawa apim ini yis kamaxwikanek yis waxepka ta gipetunatkis hiyeg giwewkistenkisnek. Hawwata yis biptepkanek agiku leglis. Apim ini yis kamiyepkanek ta gitkis hiyaptigi ta gitkis ikiparat. Yis waxepka ta gipetunatkis apatra ku samah yis nuhiyegapu. Ka sam. Ini humaw yihawkanaprik adahan yis kehne temwe ndahan giwtrikkis. ");
INSERT INTO plu_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Amawka ini kibeyne inetit gimin Uhokri gikumadukan amawka in ekkepka gipuriwkis madikte hiyegipiyenepwi ay amadga inin. ");
INSERT INTO plu_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","―Apim ini ku aysaw yis kamaxwika, ku aysaw yis kamiyepka ta gitkis hiyaptigi, ka yi muwaka ipegmina yihiyakemni adahan ku pariye yis awna gitkis apim ini hawkri. Henneme awnanay ku pariye yuwit ikakka yit apim ini. Ayge nikwe ka yisnama awnene henneme Uhokri Gitip ignewa awnene ay yipititak. ");
INSERT INTO plu_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","―Apim ini hawkri ignesweke pakebyekne kamaykisegbet adahan miyaka. Ignesme igti kamaykis gikamkayhkis. Ignesme ikamkayit hawwata kapetunsa gigkis gukakkis ginagkis. Igkis kamaykiswigkis adahan miyaka. ");
INSERT INTO plu_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ayge madikte hiyeg amiyhepyinek awaku ku samah yis nuhiyegapu. Ka sam. Ku yis ka isahkiswa nuwhu juktah amaksemni hawkri, yis isamtawnek. ");
INSERT INTO plu_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","―Aysawnemenek hiyeg amedgenepwi inin igkis hiyanek pahapwi aseneweknepye umehekeputne, ig tabirnene ay ku kiney kane kis adahan ig msakwa. Yis ku pariye ipegbohepye inakni yuwit, ku aysaw in kahayaknek metakwa yis pukuhpinnek. Pase hiyeg hiyá in danuh amawka ignes tipik kibentenwa. Amawka ku pariye msekwenepwi ay Judéyamnaw amawka igkis bisike ta ahaprikute apuheku ini waxribdi. ");
INSERT INTO plu_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ku pahapwi ay gipin higiwmadga, ig ka muwaka diyuh ta gipinekut adahan iwepye gewkanbet adahan ig bisikwiye. ");
INSERT INTO plu_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ku pahapwi ayhté amadga giwasra, ig kawnata muwaka diyuh ta gipinwat adahan iwepye gikawihni adahan ig bisikwiye. ");
INSERT INTO plu_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Akayih. Kaayhsima mahikoriki apim ini hawkri gudahankis tinogben ku pariye biyuhkisnopwi gudahankis tinogben ku pariye sukkisanyopwi. Kaayhsima mahiko adahan egkis bisik. ");
INSERT INTO plu_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Piriyepkawnay adahan in ka danuh yit abetma kamukrima iné abetma samdi. ");
INSERT INTO plu_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Mmanawa apim ini hawkri yis hiyá mbeyne kaayhsimanek. Ku samah akapuska hawkri yumahte mbeyne kema inima. Ariwntak ini akiw, yuma mbeyne akiw kema inima. ");
INSERT INTO plu_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Waké Uhokri ka matkuh ini hawkribe, yumakam pahapwinama bisikne ariw miyaka. Henneme kibeyne, ig matkuh ini hawkri gidahankis gihiyegapu gikanyanpu. ");
INSERT INTO plu_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","―Apim ini gaytakkis hiyeg awnanek: “Kuwis Cristo ay kuwis.” Gaytakkisme awnanek: “Ig ayhtéhan nawenéwa paytwempu.” Ku pahapwi awna yit inakni henne, ka yi muwaka iha inakni giwn. ");
INSERT INTO plu_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Mmanawa apim ini kinisekeputnepwi kahayaknek. Gaytakkis awna: “Nahnewa Cristo.” Bawa waditnepyenen. Gaytakkisme ikawnamah ke wotbe ignes Uhokri gawnepepube bawa igkis ka giwntakma Uhokri. Igkis keh kaayhsima annut ku pariye keh hiyeg wakaymni ke wotbe in arekhetnibe Uhokri gidatni. Akak ini annut igkis hiyá ba igkis hiyá gikinsakkis Uhokri gikanyanpu. ");
INSERT INTO plu_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kuri nah kuwis akkamnih yit madikte ku pariye nemnikumpiye. Ka ba yi kinikiswa ta gitkis hiyeg. ");
INSERT INTO plu_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","―Apim ini hawkri ariwnteke ini mbeye hawkri, kamuw msanpinek, kayg ka kabutni akiwnek, ");
INSERT INTO plu_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","warukma akak warapyu tuguhenek inugiktak. Madikte agikune hawkri, apim ini in ayguhwebdinek ariw niwetri. ");
INSERT INTO plu_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ayteke nikwe hiyeg hiyapun nah ku pariye wageswe awayg amadgaya inin. Nah ayta abetimpi ukuhne akak madikte ndatni akak madikte nukiythani kabutennene. ");
INSERT INTO plu_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Nah awahkisnek nuhiyegapu ahj ayta pahadguhpiye Uhokri gikanyanpu muwwapu amadgatak hawkri. Igkis pahadguhpigkisnek ariwntak wahamatak, ariwntak tiwgiktak, ariwntak imekaptak, ariwntak upitkiyapriktak, juktah danuhe amaksemni waxri. ");
INSERT INTO plu_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","―Ipegnay ta gumkat no ah akat “figeyra”. Kannuhwanay gut. Ku aysaw gutawna imihwa akiw, ku aysaw eg kapanhaw akiw, wis hiyakni ku guhawkanaprik kennesa danuh nikwe adahan eg kew. ");
INSERT INTO plu_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Hawwata aysawnemenek ku aysaw yis hiyá ini mbeyne danuh, metakwa yis hiyakni kuri ku nuhawkanaprik kennesa danuh kuwis. Nah kennesawa ndawnhan ke wotbe nah kuwis anumeku parekketbe. ");
INSERT INTO plu_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Hiyeg ku pariye amedgenepwi inin apim ini hawkri, apit ignes madikte miyarap, ayipa inakni madikte danuh gitkisnek ku samah nuwnhu. Ihanabay inakni nuwnhu. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","En biyuke, waxri biyuke, henneme nuwnhu ka biyuk. ");
INSERT INTO plu_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","―Henneme nah danuh pahaye adahan. Yuma hiyeg ahiyekten ku kapim nah danuh. Iné ahj inugikyenepwi ka hiyak. Iné nahwa Uhokri gikamkayh nah kawnata hiyak. Ignewa Wigwiy hiyak. ");
INSERT INTO plu_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Msakwanabay ahegbet napithu takunipti. Pukuhpawnabay. Mmanawa yis ka hiyaknima ku kabet nuhawkanaprik danuh. ");
INSERT INTO plu_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ndawnhan kewa pahapwi awayg gidawnhanbe. Ig awayg tipik danuhpene aparayewa ariw giwaxrí. Apit gitepkemni ig apuriwkise gipin gitkis gihiyegapu. Ig iké gannipwikis ta giwakuitkis. Ig awna ta git ner pahapwi ku pariye apuriwne lappot. Giwn: “Msakwanaba ahegbet takunipti.” ");
INSERT INTO plu_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Msakwanabay ahegbet takunipti nikwe. Mmanawa yis ka hiyaknima ku kabet nah yikipara danuh. Yis ka hiyak ba aygetema, yis ka hiyak ba pabuskak mtipkama, yis ka hiyak ba kabeywekema. ");
INSERT INTO plu_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Pukuhpawnabay nawenétke nah danuh atan akiw nah utepyi ke wotbe yis himeknebe yis ka ahegbetnama. ");
INSERT INTO plu_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ku pariye nah awna yit, nah awna ta gitkis madikte hiyeg. Nah awna: “Msakwanabay ahegbet apanenekwa.” Hennewatbaki ig Kiyapwiye Jesus awna. ");
INSERT INTO plu_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Pineme hawkri msekwe adahan judeyenepwi gipetrakis adahan igkis axnes muttuhyan arih akak bugut miyegbiye. Igkis axni adahan kiyene ku samah minikwak Uhokri umahkise muttuhyan gidukwenaprikkis gihiyegapu. Ayge nerras muwpeg kiyatyepwi gikakkis nerras kannuhekeputnepwi amin amekene Móis gikumadukan igkis awna: ―Amawka ku wixwiy umahkis Jesus. Uyay kamaykiswig. Henneme ka ariwtrikma hiyeg. ");
INSERT INTO plu_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ka ik adahan wixwiy kamaykiswig abet fet. Nawenétke hiyeg fetyapu hahhayruke ukakwiynek gipatra. ");
INSERT INTO plu_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Igme Kiyapwiye Jesus msekwe ay nipit paytwempu Betâniya ayge gipineku kiyapwiye Simawh. Igme kiyapwiye Simawh minikwak ig axpusakarete apit busukne. Ku samah ig Kiyapwiye Jesus bat ayge aranwa axtet, pahapu tino danuh atere git. Eg ayta akak imihgi agiku pahá atiy kehka tip seyno. Ini imihgi kehka akak “nardu” inyekata. In kanitiwnisima. Eg tino danukwa kennesa git, eg dunih abita ini imihgi atiy, eg dimukwin ta gitewharit Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Henneme gaytakkis hiyeg axnenepwi hiyapni henne, igkis dagawne. Igkis awna: ―Mmahka ini imihgi he sarayhkanen waditnepyenen henne? ");
INSERT INTO plu_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Waké in ka sarayhkama henne, ikkam adahan in piyukwika adahan kaayhsima karukri, mpiya mpanamku sah (300) karukri. Ikkam adahan akakurapig ibekhepka gipuriwkis madiptapye. Igkis awnebdi gumin ayge. ");
INSERT INTO plu_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Igme Kiyapwiye Jesus hiyapni henne, ig awna gitkis: ―Maytwangu. Mmah yis mbayha no tino gutew henne? Ka ba yis hiyá eg kehno kaayhsima kabayka nukakhu? ");
INSERT INTO plu_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Hiyawa apanenekwa yis keh kabayka gidahankis madiptapye ku samah yimawkan awaku igkis ay yibet apanenekwa. Henneme nahme ka msakwa yibet apanenekwatma adahan yis kehne kabayka nukakhu. ");
INSERT INTO plu_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Eg keh ku pariye eg hiyá asamanak. Eg imihepun adahan nahegbetepten adahan nah apuhpiki. ");
INSERT INTO plu_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Aysawnemenek hiyeg ekkenes kibeyne inetit numinhu muwwapu amadga inin. Amun ini ginetnikis ignes kinetihwanek amin inin kabayka ku pariye eg keh nukakhu. In gukehni msakwa akiwka akiwkanek. Ihanabay inakni nuwnhu. Hennewatbaki in msakwa. ");
INSERT INTO plu_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Igme pahapwi gaytakkis giwatnipwi, ig Judas Iskariyotismin, ig timapni henne, ig awna ginaktin: ―Kuri nah kamaykiswigte. Ig tipik ta gimkanitkis nerras muwpeg kiyatyepwi. Ig danuh atere, ig kinetihwa gikakkis adahan ig kamaykiswepye Kiyapwiye Jesus ta gitkis. ");
INSERT INTO plu_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Igkisme timapni henne, igkis batek ginaktinkis kaayhsima. Igkis awna git: ―Ku pis kamaykis Jesus ta wothu, usuh katiwnihpi. Ayteke nikwe ig gihapu Kiyapwiye Jesus adahan ig hiyá ku aysaw gihawkan danuh kabayhtiwa adahan ig kamaykiswig. ");
INSERT INTO plu_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ayteke ariwnteke ini danuh ahawkanaprik adahan ini fet adahan hiyeg axne bugut miyegbiye. Abet pitatye hawkri abet ini fet ignes judeyenepwi umah muttuhyan adahan kiyene ku samah minikwak Uhokri umahkis muttuhyan gidukwenaprikkis amekenegben adahan ig giwiwhkiswitnikis giwakutakkis hiyeg ejituyenepwi. Ayge nikwe gaytakkis Kiyapwiye Jesus gikannuhnipwi ayapri: ―Kiyapwiye, kineypa pimawkan adahan usuh ahegbeta pahapwi muttuhyan adahan waxniwiy abet upetrawiy? ");
INSERT INTO plu_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Igme kaytwa giwnkis: ―Yis piyana yikebyi, ataknabay ta paytwempuit Jerusalém. Ayge pahapwi awayg patiptak yikaknek. Ig hiyuwe akak kaggap un atiy. ");
INSERT INTO plu_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Makekwepnay gihapu. Ku kiney ig parak agikut payt, yis parak aterewata. Awnanay ta git payt akipara ku yikannuhten awna: “Kineypa xam adahan nah fetya axne muttuhyan arih gikakkis nukannuhnipwi?” ");
INSERT INTO plu_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ayge nikwe ig akki ta yitnek pahayku xam nopsadnene ayhté payt apahnap inuteknene. Arikna ayge madikte ahegbet kuwis. Ahegbetanabay umanawiy ayge adahan wixwiy fetya. ");
INSERT INTO plu_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ignes piyananene timapni henne, igkis tipik ta paytwempuit. Igkis danuh atere, igkis utí madikte ku samah ig Kiyapwiye Jesus akkamnih gitkis. Ayge nikwe igkis ahegbete madikte adahan igkis fetya. Pisenwa igkis diyuhe ta git Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Aygete ig Kiyapwiye Jesus atere fetya gikakkis giwatnipwi madikawkunene gikebyikis gikakkis piyana gawnakis (12). ");
INSERT INTO plu_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ku samah igkis ayge axne aranwa axtet, ig Kiyapwiye Jesus awna gitkis: ―Pahapwi yaytak ku pariye axne ay nukakhu iggi kamaykiswennek ta gitkis nupetunyapu. Ihanabay inakni nuwnhu. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Igkisme giwatnipwi timapni henne, igkis wakaymnibdi. Igkis awnebdi pahapwimpi: ―Kiyapwiye, ku ka nawhnama kamaykiswep? ");
INSERT INTO plu_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Igme Kiyapwiye Jesus kaytwa giwnkis: ―Pahapwi yaytak yis nuwatnipwi ku pariye mehbetene bugut nukakhu amadga paheknene miruk, ignewatbaki nukamaykiswitni. ");
INSERT INTO plu_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Nah ku pariye wageswe awayg amadgaya inin nah umahkiswenek ku samah Uhokri gannasan minikweknene awna numinhu. Amawka ku nah miyá henneme ner ku pariye nuwmasepten nah ku pariye wareswe awayg amadgaya inin ig hiyá mbeyne kaayhsimanek nupatra. Ka kiskama ner awayg humaw amadga wayk. ");
INSERT INTO plu_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ku samah igkis axnes ayge, ig Kiyapwiye Jesus iwé pahak bugut. Ig kabayha Uhokri. Ayteke ig sigkebdih ini bugut, ig ibekhepni gipuriwkis giwatnipwi. Ig awna gitkis: ―Ahah. Inin bugut in nihhu yidahan. Amapanay inin bugut, axnay niwntak. ");
INSERT INTO plu_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Pisenwa gibakhan ini bugut, ig iwé pohow goblé. Ig kabayha Uhokri. Ig ikepru gipuriwkis giwatnipwi. Igkisme higá agikutak no goblé. ");
INSERT INTO plu_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Igme awna ta gitkis: ―Inin win in numighu yidahan. Ig Uhokri ahegbete ginetni nukunewa akiw gikakkis hiyeg adahan ku samah ignes humaw gihiyegapu. Nahme pahapwiwa nah sukase numighunek gidahankis kaayhsima hiyeg kahadbe ini gahegbetawni in humaw. ");
INSERT INTO plu_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Kuri nah ka takunima higá win ay amadga inin akiw. Awetupye nah higá win juktah ayhté gimun Uhokri gikumadukan nah higá nukunewa win yikak akiw. Ihanabay inakni nuwnhu. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ayteke pisenwa gihigpankis igkis pak apat. Ayteke igkis peswiyes ta apitit ini waxri imuhgipitnene kewye Olipegpit. ");
INSERT INTO plu_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ayge ig Kiyapwiye Jesus awna ta gitkis: ―Ku apim inin yis madikte ikiswennek. Mmanawa Uhokri gannasan minikweknene kinetihwa henne. In awna: “Nah umahkis ner muttuhputne. Ayge nikwe gipigpu muttuh madikte ibekhewbet. ");
INSERT INTO plu_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Apim ini nah umehpikanek henneme nah kannikaw akiwnek. Ayteke ariwnteke nukankawni nah tipik pitati yapit ta apitit Galiléyamnaw. ");
INSERT INTO plu_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Igme kiyapwiye Pedru timapni henne, ig awna git: ―Hiyawa madikte hiyeg ikiswep awaku ini mbayka ku pariye me danuhmet pit, nawhme ka ikispiti. ");
INSERT INTO plu_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Igme Kiyapwiye Jesus kaytwa giwn: ―Ku apim inin mtipka pis wihwe nuwhunek. Apit tarakak awna pimaput gawnhan pisme ayipa wihwe nuwhunek mpamaput. Ihanaba inakni nuwnhu. Hennewatbaki pis wihwe nuwhunek. ");
INSERT INTO plu_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Igme kiyapwiye Pedru kaytwa giwn: ―Hiyawa nah umahkiswe payak pikak henneme nah ka wihwa piw. Igkisme gikannuhnipwi igkis madikte awnenekwiye hennep. ");
INSERT INTO plu_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ayteke ig Kiyapwiye Jesus gikakkis gikannuhnipwi igkis tipik ta apitit pahá iwetrit kewye Jetsêmani. Ig awna gitkis: ―Batnay ay in. Nahme tahhan piriyepkewne. ");
INSERT INTO plu_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ig iwé kiyapwiye Pedru gikak amekene Tiyagumni gikak kiyapwiye João. Igkisme wewkiswe ataresa, ayge igme kapusa wakaymni. Ig kayah apititak giyakni. Ig ka daykiswekere arit ini patahwaki ku pariye me danuhmet git. ");
INSERT INTO plu_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ig awna gitkis: ―Nah wakaymni mpiynepepye apit nuyakni. Ini nupewkan umehpen pahayewpi. Nah tahhan piriyepkawte. Yisme msakwa aynewa. Msakwanay apuriw adahan yis piriyepkaw payak nukakhu. ");
INSERT INTO plu_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ayteke ig wewkiswe ataresa aynessa. Ig tuguhkiswa mabuw ta waygboit. Ig piriyepkaw ta git Uhokri. Ig hiyá ba hiyá amaptanka ini mbeyne. ");
INSERT INTO plu_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ig awna: ―Pa, Nighu, madikte arikna ka mahikonama pidahan. Ik adahan pis mpitha ini mbeyne danuh nuthu. Ku pis mpithekere, uyá amnihun mpithin ndahan. Henneme ku in pimawkanwa in danuh nuthu, ka sam in danuh nuthu. Nah ka kehkere ndahan nubetki. Henneme nah kehkere pidahanwa pibetki. ");
INSERT INTO plu_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Pisenwa gipigyepkawni ig diyuhe ta gitkis gikannuhnipwi. Ig uteprikis himekweke. Ig hiyapni henne, ig awna ta git kiyapwiye Pedru: ―Simawh, mmahki pis himeke? Mmah yis ka hiyá yisma msakwa apuriw nukakhu aynesnima? ");
INSERT INTO plu_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Apuriwnabay piriyepkawnay marihwa yis ka isaksaw arit mbayka. Yitip ka isaksawkere arit mbayka henneme yipit amadgaya inin ik adahan isaksaw arit mbayka mmanawa yis yuma yawaygisima nitiput. ");
INSERT INTO plu_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Pisenwa gawnhan inakni, ig diyuhe aterewata akiw. Ig piriyepkaw inwata piriyepkawka ta git Uhokri. ");
INSERT INTO plu_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Pisenwa ig diyuhe akiw. Ig uté gikannuhnipwi himekweke mmanawa igkis isepwe kaayhsima. Igkisme hiyapni henne, igkis marekepwe. Igkis ka hiyak ku samah igkis diyuhkis giwn. ");
INSERT INTO plu_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ayteke ig diyuhe ig piriyepkaw ta git Uhokri akiw. Ayteke pisenwa gipigyepkawni ig diyuhe amamnamput ta gitkis nerras mpemnenene gikebyikis. Ig awna ta gitkis: ―Mmahpaki yipewkan yis he himeknenenwa? Mmahpaki yipewkan yis he mayeknenenwa? Ikeypi. Kuwis danuh nuhawkanaprik. Kuri nah ku pariye wageswe awayg amadgaya inin nah me ikepkamet giwakuitkis hiyeg taraksapye. ");
INSERT INTO plu_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Kannikawnay. Uyay patiptakigkis. Ipegnay atere. Ig nukamaykiswitni nemnik. ");
INSERT INTO plu_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ku samah ig awnempiye inakni yuwit, igme Judas Iskariyotismin danuh atere. Ig pahapwi gaytakkis giwatnipwi. Ig danuh atere akak pahabunad hiyeg. Igkisme danuh atere akak giponyagakis akak gasugakis. Igkis iwatit gidahankis nerras muwpeg kiyatyepwi gikakkis nerras kannuhekeputnepwi amin amekene Moís gikumadukan gikakkis nerras judeyenepwi giwewkistenkis. ");
INSERT INTO plu_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ig Judas Iskariyotismin, ku pariye kamaykistinene Kiyapwiye Jesus, ig ayipa ahegbet ginetni gikakkis adahan ku samah ig ekkepye Kiyapwiye Jesus ta gitkis. Ig awna gitkis: ―Ku yis hiyá nah aympoka pahapwi, ignewatbaki Jesus. Kamaxnigbay, iwepnigbay. Apuriwnigbay kabayhtiwa. ");
INSERT INTO plu_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ayteke nikwe ig Judas Iskariyotismin tipik wadé gimkat Kiyapwiye Jesus. Ig danuh atere, ig awna git: ―Aa, Kiyapwiye. Akak ini ig aympokig. ");
INSERT INTO plu_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Nerras pahabunene hiyeg igkis hiyapni henne, igkis sigise gimin, igkis kamaxwig, igkis sumuhpig. ");
INSERT INTO plu_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Aynewa pahapwi gaytakkis nerras ku pariye aygnenepwi gikak Kiyapwiye Jesus ig kehe giponyaga. Ig huwipwihe pahapwi ibukti gidahan ner muwpegpiyene gikiparakis. Ig ihuke gitaybi. ");
INSERT INTO plu_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ig Kiyapwiye Jesus hiyapni henne, ig awna gitkis nerras hiyeg. Giwn: ―Mmahkay yis ayta akak madikte yiponyaga akak madikte yasuga? Mmahkay yis ayta nukamaxwitni ayamaw ke wotbe nah amepyebe? ");
INSERT INTO plu_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Takunipti nah ayge yikak yikannuhten agiku Uhokri Gipin. Henneme yis ka kibowka kamaxun ayge. Ka sam. Amawka ku ini danuh nuthu ku samah Uhokri gannasan minikweknene kinetihwa numinhu. ");
INSERT INTO plu_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Igkis gikannuhnipwi timapni henne, igkis madikte tipikbet giw. Igkis ikiswig pahapo. Ayteke nikwe ig Kiyapwiye Jesus tipik gikakkis ignes hiyeg. ");
INSERT INTO plu_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Pahapwi awayg takwaye makekwepi gihapu Kiyapwiye Jesus. Ig he kanuktewpi akak gidagmanpit. Ku samah ig waywempiye gihapu atere, ignes hiyeg wageswe gipitit adahan gikamaxwitni. ");
INSERT INTO plu_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ig hiyapni henne, ig he pitukminew ariw gidagmanpit. Ig bisike makawihan. ");
INSERT INTO plu_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ayteke ariwnteke ini ignes hiyeg waxe Kiyapwiye Jesus ta gipinekut ner muwpegpiyene gikiparakis. Ayge madikte muwpeg kiyatyepwi gikakkis nerras kannuhekeputnepwi amin amekene Moís gikumadukan gikakkis nerras judeyenepwi giwewkistenkis igkis kuwis pahadgupu ayge. ");
INSERT INTO plu_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ig kiyapwiye Pedru hiyapni henne, ig makeke gihapu butte henneme ig piyawakte giw aynessa. Ig wadite ta arimkanit muwpegpiyene gikiparakis gipinbukut. Ig pareke atere, ig batahkiswe payak gikakkis nerras apuriwnepwi Uhokri Gipin. Ig awahpusewne ayge ahumwa tiket. ");
INSERT INTO plu_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Apimwata ini nerras muwpeg kiyatyepwi igkis pahadgupu gikakkis madikte judeyenepwi gikiparakis ku samah igkis kehnes gipandukawnikis. Igkis aharitnes ba igkis utí Kiyapwiye Jesus gikehni mbaynama ku pariye ik adahan igkis giwmasepten. Inneki keh igkis aharitnes ba igkis utí hiyeg ku pariye gikamyehpitnipwi. Amawka igkis utí gikamyehpitnipwi ku pariye giwnkis tuguh hehpekwiye. Henneme igkis ka utí. ");
INSERT INTO plu_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Hiyawa kaayhsima hiyeg kamiyepri akak gikehbetankisnen henneme giwnkis ka tuguh hehpekwiyema. ");
INSERT INTO plu_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ayteke gaytakkis nerras hiyeg kannikaw akiw adahan igkis kamiyepri atere akak gikehbetankisnen. Igkis awna: ");
INSERT INTO plu_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Usuh timá ner awayg awna: “Nah mehbetenek ini leglis Uhokri Gipin ku pariye hiyeg amadgaya inin gikehnikis. Ayteke adahan mpana hawkri nah kannikase nawenéwa akiw ku pariye ka hiyeg amadgaya inin gikehnikisma.” ");
INSERT INTO plu_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Juktah inakni ginetnikis ka tuguh hehpekwiyema. ");
INSERT INTO plu_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Igme muwpegpiyene gikiparakis ig timapni henne, ig kannikaw ayge gibetkis madikte hiyeg. Ig awna git Kiyapwiye Jesus: ―Mmahki pis ka kaytwa giwnkis? Mmah hennewatma ku samah igkis awna pimin? ");
INSERT INTO plu_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Igme Kiyapwiye Jesus tinwo, ig ka kaytwa giwn. Igme muwpegpiyene gikiparakis ig ayapri: ―Mmah pisnewa Cristo? Mmah pisnewa Uhokri gikanyan adahan ukumaduketni? Mmah pisnewa Uhokri gikamkayh? ");
INSERT INTO plu_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Igme kaytwa giwn: ―Nahnewa. Kuri yis betnene ayge adahan yis hiyekne nukakhu. Henneme aysawnemenek yis hiyapunnek, nah ku pariye wageswe awayg amadgaya inin, yis hiyapun nah bat ayge gihumwa Uhokri detye ay amun ini iwetrit ku pariye kanenikiythanisima kihehaptak. Yis hiyapunnek nah muhuk abetimpi ukuhne inugiktak. Apim ini nah hiyekne yikak nikwe. ");
INSERT INTO plu_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ig muwpegpiyene gikiparakis timapni henne, ig sigke gisimsa adahan arekhetni gidagonyi apatra ku samah ig Kiyapwiye Jesus awna gitkis inakni yuwit. Ig awna: ―Pariyeki umawkanwiy akiw? Wixwiy ka muwaka hiyeg akki wotwiy ariknawnama Jesus gitaraksan akiw. ");
INSERT INTO plu_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Kuwis ig makukse Uhokri ay wowtrikwiy. Yis kuwis timapni akakwa yitaybi. Uyay katiwnise ini gitaraksan git. Mmani yit? Igkisme kaytwa giwn: ―Pugamawka ig umehpika. ");
INSERT INTO plu_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ayge nikwe gaytakkis nerras hiyeg tupestepri. Gaytakkisme wanakotepri igkis biyuhpokepri. Igkis awna git: ―Ku pis Uhokri gawnepe, asá akki wot ku pariye pibiyuhatepten. Ayteke nerras apuriwnepwi Uhokri Gipin igkis iwepri igkis biptepri. ");
INSERT INTO plu_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Apimwata ini ig kiyapwiye Pedru bat ayge paytbuhku. Ayteke pahapu tino ku pariye ibukti gidahan ner muwpegpiyene gikiparakis eg danuh atere git. ");
INSERT INTO plu_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Eg hiyá kiyapwiye Pedru ayge ig awahpusewne aranwa tiket. Eg sarayh gupegyi ta gimkat, eg murotpi git. Ayteke eg awna git: ―Pis hawwata wew gikak Jesus nazaréyne. ");
INSERT INTO plu_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Igme wihwe giw. Ig awna gut: ―Nah ka hiyakwa inakni yuwit ku kamin pis awna. Nah ka pukuhpawa inakni piwn. Ayteke ig pes ta anumekut pesket. Nikwenéwa pahapwi takarak awna. ");
INSERT INTO plu_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ayge eg tino bukitwiyo hiyapri akiw. Eg hiyapni henne, eg awna ta gitkis hiyeg ku pariye ay kennesa guhumwa. Guwn: ―Nernewa awayg pahapwi gaytakkis Jesus gikannuhnipwi. ");
INSERT INTO plu_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Henneme igme wihwe giw akiw. Ayteke ariwnteke ini ayiptenesa akiw nerras hiyeg ku pariye ayge kennesa gihumwa awna ta git. Giwnkis: ―Hennewa. Pisnewa pahapwi gaytakkis Jesus gikannuhnipwi mmanawa pis hiyeg galiléyene hawwata ke igkisbe. ");
INSERT INTO plu_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ig timapni henne, ig awna akak madikte gawaygyi. Giwn: ―Ku nah ka awna inyerwatma yuwit, hiyawa Uhokri hiyapkis mbeyne nuthu. Nah kawa hiyakriwa ner awayg ku kamin yis awna. ");
INSERT INTO plu_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Nikwenéwa pahapwi takarak awna apeynepye akiw. Igme kiyapwiye Pedru timapni henne, ig kiyé inakni ku pariye Kiyapwiye Jesus giwn kuhwekwa ta git amin “Apit takarak awna pimaput gawnhan, pisme ayipa wihwe nuwhunek mpamaput.” Ig kiyé inakni giwn nikwe, ig biyuk gikan. Ig tihene ayge mpiynepepye. ");
INSERT INTO plu_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Hewke nikwe hawkanawa nerras muwpeg kiyatyepwi gikakkis nerras judeyenepwi giwewkistenkis gikakkis nerras kannuhekeputnepwi amin amekene Moís gikumadukan igkis keh gipandukawnikis. Ayge igkis ahegbete ginetnikis kabayhtiwa. Ayteke nikwe igkis wanakminase Kiyapwiye Jesus. Igkis waxepri ta gimkanit ner hiyaptigi romayene ig amekene Pilatus. Igkis danuh atere, igkis ikepri ta giwakuit. ");
INSERT INTO plu_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ayge nikwe ig amekene Pilatus ayapri: ―Mmah pis hiyeg judeyenepwi gikiparakis? Igme Kiyapwiye Jesus kaytwa giwn: ―Hennewa ku samah pis awna. ");
INSERT INTO plu_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ayteke nerras muwpeg kiyatyepwi igkis kamiyepri ku ig keh mbayka kaayhsima. ");
INSERT INTO plu_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ig amekene Pilatus hiyapni henne, ig ayapri: ―Ka ba pis timap ku samah igkis kamiyep ku pis keh mbayka kaayhsima? Mmah pis yumawatma pikaytwanwatma? ");
INSERT INTO plu_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Kameki ig Kiyapwiye Jesus kaytwame giwnkis. Igme amekene Pilatus hiyapni henne, ig wakaymni kaayhsima. ");
INSERT INTO plu_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Apim ini ahawkanaprik danuh adahan hiyeg judeyenepwi gipetrakis. Abet ini gipetrakis ig hiyaptigi gibetki isahkis pahapwi awayg ku pariye paraksepkare ayge. Mpuse kamukri ig isahkiswiye apim ini pahapwi ku pariye hiyeg fetyapu isahkiskere. ");
INSERT INTO plu_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ayge pahapwi awayg agiku parakseket payak gikakkis nawenépwi ku pariye hahhayruke gikak gupelma. Ig umehe pahapwi. Giw Bahabás. ");
INSERT INTO plu_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ayge nikwe kaayhsima hiyeg fetyapu pahadguhwa atere git amekene Pilatus. Igkis ayá git: ―Uyá isahkis udahan pahapwi paraksepkatinene ku samah inpawa pis keh apim inin. ");
INSERT INTO plu_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Igme amekene Pilatus kaytwa giwnkis: ―Ba yis muwaka nah isahkis yidahan ner ikawparinene yikipara judeyenepwi? ");
INSERT INTO plu_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ig awna inakni mmanawa ig hiyakni kabayhtiwa ku nerras muwpegpu iké Kiyapwiye Jesus ta giwakuit he apatranen ku samah igkis atihapnig. Gipewkankam ku igkisme hiyeg fetyapu muwaka adahan gamnihten. ");
INSERT INTO plu_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Henneme nerras muwpeg kiyatyepwi wagese nerras fetyapu gihiyakemnikis kahadbe igkis isahkisase Bahabás mpinekata igkis isahkisase Kiyapwiye Jesus. Nikwe igkis hiyeg awna ta git amekene Pilatus: ―Isahkis udahan Bahabás. ");
INSERT INTO plu_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Igme amekene Pilatus ayaprikis akiw: ―Mmah nah keh nikwe gikak ner awayg ku pariye yis kanum judeyenepwi gikiparakis? ");
INSERT INTO plu_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Igkisme madikte kabimanape. Igkis awna: ―Uyá daddahkiswig udahan! ");
INSERT INTO plu_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Igme timapni henne, ig ayaprikis: ―Mmahki? Pariye mbayka gikehni? Igkisme kabiman pi kihhawnate akiw. ―Daddahkisnig! ");
INSERT INTO plu_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Igme amekene Pilatus hiyapni henne, ig kehpiye nerras hiyeg gibetkikis. Ayteke nikwe ig isahkisase Bahabás gidahankis. Igme Kiyapwiye Jesus ig biyuhkisepri akak tigay. Ayteke ig ikepri ta giwakuwitkis gisuwtatapu adahan igkisme gideddehpitni. ");
INSERT INTO plu_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ayge nikwe igkis gisuwtatapu waxe Kiyapwiye Jesus ta gipinbukut hiyaptigi. Ini iwetrit giwnaprikkis romayenepwi kewye “Pretóriyu”. Ayge igkis pahadguhe madikte suwtat ta ganwat adahan gimahipwihpitni. Igkis awna gitkis: ―Uyay arehwa gikak. Uyay kawihkis gikawihni ta gipitit kewa pahapwi ikiparatbe ku samah ig kawih dagam duruweh akak gisuwpren karukri wahano. ");
INSERT INTO plu_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ayteke nikwe igkis kadagmanepri akak pahak dagam duruweh. Ayteke igkis imepe puduku, igkis keh gisuwpren nikak. Igkis kawihkisni ta gitewharit. ");
INSERT INTO plu_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ayteke igkis mahipwihpig. Igkis awna git: ―Aa, Kiyapwiyad, kibeyne pis ay kuri. Pis judeyenepwi gikiparadkis. ");
INSERT INTO plu_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ayteke igkis biyuhpig gitewha akak pahat yakkot akat, igkis tupestepri. Igkis paberetusaw gitiput ke wotbe igkis kiyatigbe. ");
INSERT INTO plu_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Pisenwa gimiytankis igkis wiwhe ini dagam gipititak, igkis kawihkise git gisimsa ku pariye gikawhan. Ayteke nikwe igkis tipikepri apititak paytwempu adahan gideddehpitni. ");
INSERT INTO plu_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ku aysaw igkis apigku ahin igkis patipteke gikak pahapwi awayg sireneyene kewye Simawh. Ignewa gigkis kiyapwiye Alixandre gikak kiyapwiye Rufu. Ig gaytni powkete. Igkisme nerras suwtat mpiksaptihpig adahan ig gayapetni Kiyapwiye Jesus hiyuhne giyakni. Igme ihe giwnkis. ");
INSERT INTO plu_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ayteke igkis waxe Kiyapwiye Jesus ta apitit pahá waxri imuhgipitnene kewye Gówgota. Inakni wownaprikwiy “Waxri Hiyeg Gaptiwpitwiye”. ");
INSERT INTO plu_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ayge igkis suwtat akaka win git Kiyapwiye Jesus. In wageska akak ipeyti tagetreni gih kewye “miha”. Igme hiyapni henne, ig ka higapni. ");
INSERT INTO plu_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ayteke igkis deddehpig ta aminat giyakni. Pisenwa gidaddahnikis, igkis arehwa akak tip adahan hiyá ku pariye kabunuganen adahan ig darihpiye Kiyapwiye Jesus gikawihni. Henne igkis ibekhepyes gikawihni pawtak. ");
INSERT INTO plu_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Igkis daddahgi kamuw kabá puwip. ");
INSERT INTO plu_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ayge amin giyakni apitmin gitew pahak kagta daddahka atere adahan arekhetni ku pariye gikehnitnene ta gitkis hiyeg. Amadga ini kagta awna: “Judeyenepwi Gikiparakis”. ");
INSERT INTO plu_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Hawwata akiw igkis deddehe piyana gikebyikis amepwapye ta aminat giyaknikiswa payak gikak Kiyapwiye Jesus. Pahapwi daddahka kihehaptak pahapwime patuwanaptak. ");
INSERT INTO plu_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Hennewa in danuh ku samah Uhokri gannasan minikweknene awna. In awna: “Ig ikakanek ke wotbe ig kakehniyebe.” ");
INSERT INTO plu_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Kaayhsima hiyeg mapiya awpre. Ayge igkis mahipwihpig. Igkis sassah gitewkis adahan arekhetni ku samah igkis ka batek gikak. Igkis awna git: ―Kineyka kuri ku samah pis awna: “Nah mehbete Uhokri Gipin. Amamnam hawkri nah kannikasin akiw.” ");
INSERT INTO plu_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Asá amnih pipit kuri. Ku pis igyerwa Uhokri gikamkayh, nikwe muhuk ayteke kuri aminatak piyakni. ");
INSERT INTO plu_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Nerras muwpeg kiyatyepwi gikakkis nerras kannuhekeputnepwi amin amekene Moís gikumadukan hawwata igkis mahipwihpig. Igkis kinetihwa pawtak. Igkis awna: ―Kuwis ig amnihe nawenépwi hiyeg, kuri gipitme ig ka hiyá aramnihka. ");
INSERT INTO plu_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ku ig Cristo, ku ig Uhokri gikanyan adahan ukumaduketniwiy, ku igyerwa hiyeg israelyenepwi gikiparakis, hiyawa ig muhuk ayteke aminatak giyakni. Ku wixwiy hiyá ig muhuk ayteke, nikwe wixwiy iha giwn. Hawwata akiw nerras amepwapye ku pariye daddahka ayge gihumwa Kiyapwiye Jesus igkis hawwata mahipwihpig. ");
INSERT INTO plu_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ayteke puwipka danuh. Pahaye adahan kamuw abutni ka kabutni akiw. Hawkri msanpi muwwapu juktah daraka kamuw in kapusa kabutni akiw. ");
INSERT INTO plu_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Apim ini daraka kamuw, ig Kiyapwiye Jesus kabiman akak gihawna giwnaprik. Ig awna: ―“Eloí, Eloí, lemá sabaktâni?” Inakni wownaprikwiy: “Nuwohkiga, nuwohkiga mmah pis ikiswen?” ");
INSERT INTO plu_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Gaytakkis hiyeg ku pariye tabirbetnene ayge igkis timapni henne, igkis timá tarakise. Igkis awna: ―Atabiswanabay. Ner awayg ig humekne amekene Eliyas. ");
INSERT INTO plu_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Pahapwime gaytakkis ig timapni gabiman henne, ig muwaka adahan gamnihten. Ig sigise kibentenwa ig iwé pahá arikna ku pariye mtibetnene. Ig subukwin ahakwat win suwiyweye adahan anugasene. Ig iké akisurik pahat yakkot akat. Ig tarekwin ta gimkat Kiyapwiye Jesus kahadbe gipewkan ig susni. Henneme nawenépwi hiyeg ayge igkis hiyapni henne, igkis awna git: ―Miniw giw. Uyay hiyá ba ig amekene Eliyas danuhwatma adahan giwiwhpitni aytekihan. ");
INSERT INTO plu_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Igme Kiyapwiye Jesus kabiman akak gihawna akiw. Giyakek madike. Ig miyap. ");
INSERT INTO plu_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Nikwenéwa apim ini, ini kamis amaptenten Uhokri giwskeki barewpitye ku pariye agikunene Uhokri Gipin, in sigke pabakak. Nikwenéwa ku aysaw ig miyá, amun ini in sigka aytá inutak danuhte ta warikwit. In woka ahin ta agikut Uhokri giwskeki. ");
INSERT INTO plu_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ig Kiyapwiye Jesus miyapi, pahapwi romayene suwtat gikiparakis ig tabir ayge gipetunat. Ig hiyapni henne ku samah gimiremni, ig awna: ―Inyerwa ner awayg Uhokri gikamkayh. ");
INSERT INTO plu_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Aygwata kiyapunogben egkis hawwata ipegbet atere. Ayge eg kiyapuno Mahi Madalena eg pahapu gaytakkis, hawwata pahapuwa Mahi akiw eg pahapu gaytakkis. Eg ginagkis kiyapwiye Tiyagu gikak kiyapwiye José. Hawwata kiyapuno Salomé pahapu gaytakkis. ");
INSERT INTO plu_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Egkis norras ku pariye danuhpanopwi payak gikak Kiyapwiye Jesus apititak Galiléyamnaw. Egkis ku pariye hiyaknopwi gikak. Hawwata akiw kaayhsima nawenépwi kiyapunogben ayge ku pariye danuhpanopwi payak gikak arimkanit paytwempu Jerusalém. ");
INSERT INTO plu_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Aygete pahapwi awayg kewye José arimatéyene danuh atere. Ig pahapwi gaytakkis nerras judeyenepwi giwewkistenkis. Ig kiyatye hiyeg. Ig wahepnenekwa Uhokri gikumadukan ku aysaw in danuh. Ig hiyapni henne ku samah takuwa samdi, kuwis ahawkanaprik danuh adahan ahegbetaw adahan mayekne abet samdi, ig kibowkahwa ig tipik ta gimkat amekene Pilatus. Ig danuh atere git, ig awna ta git: ―Kiyapwiye, uyá amnihun isaksan adahan nah iwepye amekene Jesusmin gipit. ");
INSERT INTO plu_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ig amekene Pilatus timapni henne, ig wakaymni adahan ku samah ig Kiyapwiye Jesus ayipa gimiremni. Ig watihe ner suwtat gikiparakis, ig ayapri: ―Mmah ayipte Jesus gimiremni? ");
INSERT INTO plu_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Igme suwtat gikiparakis kaytwa giwn: ―Ihi. Ayipa gimiremni. Igme amekene Pilatus timapni henne, ig awna ta git: ―Wani ikepka ta git kiyapwiye José. ");
INSERT INTO plu_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Igme kiyapwiye José timapni henne, ig tipik. Ig isime pahak dagam seyne barewbetye. Ayteke ig tipik wiwhe Kiyapwiye Jesus gipit aminatak giyakni. Ayteke ig awasminepri akak ini dagam. Pisenwa ig sarayhe gipit ta agikut pahayku imewti ku pariye atikka agiku tip amiyokni. Ayteke ig wagesmine pahow tipad adahan gisabwatip. ");
INSERT INTO plu_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Egme Mahi Madalena gukak no Mahi ku pariye Kiyapwiye José ginag, egkis hiyá ku kiney gipit sarayhpika. ");
INSERT INTO plu_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ariwnteke ini, samdi kuwis mpiye kuwis, eg kiyapuno Mahi Madalena gukakkis eg kiyapuno Mahi kiyapwiye Tiyagu ginag, egwata kiyapuno Salomé egkis isime imihgi adahan gimihetni Kiyapwiye Jesus gipit adahan ig apuhpiki. ");
INSERT INTO plu_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Paka abet kabeyweke, pesantene kamuw, egkis tipikwiyos ta arimkanit gimew. ");
INSERT INTO plu_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ayge apigku ahin egkis kinetihwa pawtak, egkis awna: ―Pariyepa hiyeg adahan wiwhne udahan no tip ku pariye asabwat gimew? ");
INSERT INTO plu_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ayteke egkis sarayh gupegyikis atere egkis hiyá ku no asabwatip ayipa wiwhpika. No tip kanopsimahad. ");
INSERT INTO plu_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Egkis hiyapni henne, egkis parak aterenewa agikut gimew. Ayge egkis hiyá pahapwi takwaye inugikyene bat ayge kihehaprik. Igme kasimsapu simis seyne. Egkis hiyapni henne, egkis wadisasew egkis apisasew. ");
INSERT INTO plu_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Igme awna ta gutkis: ―Ka yi muwaka apis. Yis ipegepye Kiyapwiye Jesus nazaréyene ku pariye kuwis deddehpika. Ig yuma ay. Ig kuwis kannikew. Hiyawa yis iwasa gidukwen ay ku kiney igkis sarayhpig. Egkis iwasa gidukwen. ");
INSERT INTO plu_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ayteke ig ahj awna gutkis: ―Kuri ataknabay ta gitkis gikannuhnipwi, hawwata ta git kiyapwiye Pedru. Awnanay gitkis: “Ig Kiyapwiye Jesus tipik pitati yapit ta apitit Galiléyamnaw. Ayge yis hiyaprinek ku samah ig kuwis akki yit.” ");
INSERT INTO plu_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Egkis hiyapni henne, egkis pese kibentenwa agikutak gimew. Egkis wakaymni kaayhsima juktah egkis segke awaku ku samah egkis wadisasew. Egkis ka awna git pahapwinama hiyeg apigkuya ahin awaku gapisnikis. ");
INSERT INTO plu_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ig Kiyapwiye Jesus kannikaw hawkanawa paka abet. Ig hiyapkiswa pitatye ta gut kiyapuno Mahi Madalena. Eg no ku kapititak minikwak ig ipuk kaayhsima wapitye gupititak, ntewnehker gikebyikis. Ayge ig hiyapkiswa gut. ");
INSERT INTO plu_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Eg hiyapni henne, eg tipik ta gitkis nerras ku pariye wewnenepwi gikak. Eg danuh atere gitkis, eg uteprikis kabubuk kadniyekis ayge. Igkis tihenekis. Eg awna gitkis: ");
INSERT INTO plu_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","―Kiyapwiye Jesus ipeg akiw. Ig hiyapkiswe nuthu. Igkisme timapni gunetni henne, igkis ka iha inakni guwn. ");
INSERT INTO plu_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ariwnteke ini ig Kiyapwiye Jesus hiyapkiswe nawenéwa gihipak ta gitkis piyana gikebyikis gikannuhnipwi, apim ini ku aysaw igkis waywepnene ta amatmadgetwiye. ");
INSERT INTO plu_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Igkis hiyapni henne, igkis diyuhe ta apitit paytwempu Jerusalém. Igkis danuh atere, igkis akkin ta gitkis gikannuhnipwi asemne. Henneme igkis kawnata iha inakni giwnkis. ");
INSERT INTO plu_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ariwnteke ini ig hiyapkiswa ta gitkis giwatnipwi madikawkunene gikebyikis gikak pahapwi gawnakis (11). Igkis axnes, ig hiyapkiswe atere. Ig himehpigkis atere. Ig awna gitkis: ―Yidaniskata yis ihpa giwnkis nerras ku pariye nuhiypetnipwi ku nah kuwis kannikaw. ");
INSERT INTO plu_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ayteke ig awna gitkis: ―Ataknabay muwwapu amadgat hawkri. Akkanabay ini kibeyne inetit numinhu ta gitkis madikte hiyeg. ");
INSERT INTO plu_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ku pariye hiyeg iha inakni yinetni, ig kewpiye, iggi isamtawnek. Igme ku pariye ka iha yinetni, iggi biyuknek giw Uhokri. ");
INSERT INTO plu_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Igkisme ku pariye ihpenepwi nuwnhu, Uhokri ikí gannu ta gipitkisnek adahan igkis kehnes annut. Apim ini igkis pekkis wapitye gipititakkis hiyeg nuwaprik. Igkis awna agiku nawenéwa yuwit. ");
INSERT INTO plu_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ku igkis sumuhe kaybunepa, ig ka kehgikis ariknawnama. Ku igkis higá ipeyti pahaywitniyepa in kawnata kehrikis ariknawnama. Ku aysaw igkis sarayh giwakkis ta gipititkis hiyeg kakahribdapye, ignes makniwnek. ");
INSERT INTO plu_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Pisenwa inakni gawnhan, ig Kiyapwiye Jesus iwepka ta inugikut. Ayge ig batahkiswe adahan ig kumadukene gihumwa Uhokri ay amun ini iwetrit ku pariye kanenikiythanisima kihehaptak. ");
INSERT INTO plu_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Igkisme giwatnipwi tipik ekkene inakni kibeyne inetit muwwapu. Igme Uhokri ikí ini gannukis adahan igkis kehnes annut kahadbe hiyeg iha inakni giwnkis.");
INSERT INTO plu_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kiyapwiye Teófilu, kuwis kaayhsima hiyeg mpiksaw adahan igkis tameknes amadga kagta adahan igkis ekkenes inakni inetit ku pariye danuh ta wotwiy apim inin hawkri. ");
INSERT INTO plu_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Inakni inetit ekkepka wotwiy gapitkis hiyeg ku pariye hiyapni akakwa giwtyakkis ku samah akapuska, ayteke igkis ekkepni muwwapu. ");
INSERT INTO plu_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nah kuwis kinetihwa kabayhtiwa gikakkis nerras ku pariye atiwkeknepwi inakni inetit. Inneki keh nah nupewkan kabay adahan nah tamak inakni inetit pehetempi amadga kagta pidahan, kiyapwiye. ");
INSERT INTO plu_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Nah tamak inakni inetit kahadbe pis hiyakni kabayhtiwa ku inakni inetit ku pariye pikannuhwan kuwis ku in inyerwatnene. ");
INSERT INTO plu_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Minikwak ku samah amekene Erodis kumadukenete ay Judeyamnaw, pahapwi awayg ig judeyenepwi gimuwpegakis giw Zakaríyas. Ig pahapwi gaytakkis amekene Abiyas gihiyegapu ku pariye kannipwiyes agiku ini leglis kewye Uhokri Gipin. Gihayo eg amekene Agawh gihiwhi. Guw Isabel. ");
INSERT INTO plu_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Egkis piyamate wadityekwiyokis giwtrik Uhokri. Egkis ka taraksa Uhokri gikumadukan aynesnima. ");
INSERT INTO plu_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Egkis yuma gukamkayhkis mmanawa amakano Isabel eg ka keh bakimni. Egkis kuwis kiyaparapyo kuwis. ");
INSERT INTO plu_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Apim ini hawkri ig amekene Zakaríyas gihawkanaprik danuh adahan ig kehne gannipwi agiku Uhokri Gipin awaku ku samah ig muwpeg. ");
INSERT INTO plu_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ayteke nikwe nerras muwpegpiyene ibekhe gannipwikis ku samah igkis inpawa igkis keh. Apim ini ig amekene Zakaríyas kaniyka adahan ig parak agikut Uhokri giwskekri adahan ig bukehne iyayrti imihnepye gipetunat Uhokri. Nikwe ig pareke atere. ");
INSERT INTO plu_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Madikte hiyeg msekwe kabubuk ayhté kabaywak. Ayge igkis piriyepkewnekwiyes ku samah ig aynete agiku payt bukehne ini iyayrti imihnepye. ");
INSERT INTO plu_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Pahaye adahan pahapwi ahj Uhokri giwatni hiyapkiswe ta git amekene Zakaríyas. Ig tabir kihehaptak ini piriyepkewket adahan bukehne iyayrti imihnepye. ");
INSERT INTO plu_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ig amekene Zakaríyas hiyapni henne, pahaye adahan ig kawadsan ig apisasew kaayhsima. ");
INSERT INTO plu_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Igme ahj awna git: ―Kiyapwiye Zakaríyas, ka muwaka apis. Uhokri kuwis timá pipigyepkawni. Kuwewanek pihayo kiyapuno Isabel kakamkayhnek. Pis sarayh giw João. ");
INSERT INTO plu_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ayge pis kaayhsima batek pinaktinnek. Hawwata kaayhsima hiyeg batek ginaktinkisnek ku samah ig amadga wayk. ");
INSERT INTO plu_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ig humaw kiyatye hiyegnek giwtrik Uhokri. Ig ka higapti win. Ig kawnata higapti higapka ku pariye katiwye. Ig gitiphaw Uhokrinek ku samah ig ay gutunrik ginag. ");
INSERT INTO plu_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Aysawnemenek ig keh kaayhsima israelyenepwi wages gihiyakemnikis gidahan Kiyapwiye Uwohkigawiy. ");
INSERT INTO plu_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ig ayta gapitkiya Ukiparawiynek. Apim ini ig gitiphewne Uhokri ke amekene Eliyasbe. Gannu hawwata ke gidahanbe. Apim ini ig keh igti kabeywotpi gikakkis gikamkayupwi akiw. Ig keh hiyeg kane ihpenepwima wages gihiyakemnikis adahan kibeyne hiyakemniki. Ayge nikwe ig keh igkis waditha gihiyakemnikis marihwa igkis ahegbet gidahan Ukiparawiy gaytni. ");
INSERT INTO plu_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ig amekene Zakaríyas timapni henne, ig awna git ahj: ―Mmah ahiyaka nuthu ku inakni piwn inyerwa kahayak? Nah ka iha inakni kabayhtiwatma mmanawa nah kuwis kiyaparepye kuwis. Nuhaya hawwata kiyaparupyo. ");
INSERT INTO plu_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Igme ahj awna git: ―Nah Gabriyew, nah apanenekwa nah msakwa gimun Uhokri. Nah awahkiska atan pimin adahan nah kinetihwa pikak adahan nah ekkene inakni inetit ta pit. ");
INSERT INTO plu_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Pisme ka iha inakni nnetni. Apatra ini pis mataybinek pis monpinek. Pis ka awna pahatnama yuwitnek nekwanek inakni nuwnhu kahayak ta pitnek. Mmanawa inyerwa in kahayak apim ini ku aysaw ahawkanaprik danuh. ");
INSERT INTO plu_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Igkis kinetihwenes ayge, nerras hiyeg ayhté kabaywak igkis wahepnes amekene Zakaríyas adahan ig pes. Igkis wakaymnibdi awaku ku samah ig ayipwihwe mpiynepepye ayhté agiku Uhokri giwskekri. ");
INSERT INTO plu_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ayteke metakwa ig pes agikutak ini payt. Ig mpiksaw adahan ig awna gitkis nerras hiyeg henneme ka ik adahan ig awna. Igkis hiyapni henne, igkis awna: ―Ba ig kamapti ayge agiku Uhokri giwskekri? Igme msekwe ahehwapwi akak giwaknenwa. Ig ka ik adahan ig awna. ");
INSERT INTO plu_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ariwnteke ini gannipwi pisenwa. Nikwe ig tipik danuh ta gipinekut. ");
INSERT INTO plu_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Awenketeke ini gihayo amakano Isabel biyuhkise. Eg hiyapni henne, eg kapigse gukamkayh, eg ka pes paytrikutak adahan pohowku kayg. Eg awna: ");
INSERT INTO plu_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","―Kiyapwiye Uhokri kagabayisima nukakhu. Kibeyne, ig amnihpen. Ig keh nah ka maraka nupithu akiw giwtrikkis hiyeg. ");
INSERT INTO plu_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Eg amakano Isabel biyuhkis adahan puguhkuna kayg gaw, nikwe ner ahj Gabriyew awahkiska gapit Uhokri ta apitit pahá paytwempu kewye Nazaré ku pariye aynene apit waxri Galiléyamnaw. ");
INSERT INTO plu_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ig awahkiska gumin pahapu himano guw Mahi ku pariye kuwis ahegbet gunetni gikak pahapwi awayg. Ig awayg giw José. Ig amekene Davi gihiwhi. ");
INSERT INTO plu_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ig ahj danuh atere ta gupinekut kiyapuno Mahi. Ig awna gut: ―Ba pi ay? Uhokri kabayhap. Ig ay pikak. ");
INSERT INTO plu_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Eg timapni henne, eg wakaymni. Eg awna: ―Mmahki ner awna nuthu inakni henne? ");
INSERT INTO plu_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Igme ahj awna gut: ―Ka muwaka apis, kiyapuno Mahi. Pis kabunuga gikak Uhokri. ");
INSERT INTO plu_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Pis biyuhkisnek. Pis sarayhnek pikamkayh awayg. Pis sarayh giw Jesus. ");
INSERT INTO plu_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ig humaw kiyatye hiyegnek. Ig kanumka Uhokri inugikyene gikamkayh. Kiyapwiye Uhokri keh ig kumaduka hiyeg hawwata ke gahawkribe amekene Davibe. ");
INSERT INTO plu_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ig kumadukanek amekene Jakó gihiwhipwi akiwka akiwkanek. Gikumadukan yuma amaksemninek. ");
INSERT INTO plu_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Eg kiyapuno Mahi timapni henne, eg kaytwa giwn: ―Mmahki ini danuh nuthu? Nah kote wewte gikak pahapwinama awayg. ");
INSERT INTO plu_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Igme ahj kaytwa guwn: ―Ig Uhokri Gitip ig muhuksa ta pipititnek. Ig gidatni parakpinek. Ayge nikwe pis sarayh pikamkayh, ig barewpityenek. Ig Uhokriwa gikamkayh. ");
INSERT INTO plu_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ku pis hiyap pikebyi kiyapuno Isabel kuwis biyuhkisno, pis hawwatanek. Eg kiyaparupyo, eg kanumka manpigpiyo henneme gubiyuhkisni puguhkuna kayg gaw kuwis. ");
INSERT INTO plu_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ig Uhokri detye adahan ig keh madikte. Madikte arikna ka mahikonama gidahan. ");
INSERT INTO plu_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Eg kiyapuno Mahi timapni henne, eg awna git: ―Nop nah ay. Nah Uhokri gibuk. Hiyawa ig keh ku samah piwn ta nupitit. Ig ahj timapni henne, ig tipik. ");
INSERT INTO plu_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ariwnteke ini eg kiyapuno Mahi ahegbetewpi, eg tipik kibentenwa ta apitit pahá paytwempu ku pariye aynene apit waxribdi ay Judeyamnaw. ");
INSERT INTO plu_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Eg danuh atere, eg pareke gipinekut amekene Zakaríyas. Ayge eg uté amakano Isabel. Eg awna gut: ―Ba pi ay? ");
INSERT INTO plu_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Pase eg amakano Isabel timé inakni guwn henne, gukamkayh mukuse ay gunaktin. Ayge amun ini eg kawihpika gapit Uhokri Gitip. ");
INSERT INTO plu_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Nikwe eg awna gut kiyapuno Mahi akak madikte guwakemni. Guwn: ―Pis pi kabunugate gikak Uhokri ariw madikte tinogben. Pikamkayh hawwata kagibunugasima. ");
INSERT INTO plu_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Pis kiyathan ku samah pis ayta danuhpano nuthu mmanawa pis Ukiparawiy ginag. ");
INSERT INTO plu_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Pase nah timé piwn, nukamkayh mukuse ay nnaktin akak batekka. ");
INSERT INTO plu_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Pis utí kabaykanek kaayhsima awaku ku samah pis ihe Kiyapwiye Uhokri giwn pit. Mmanawa ig keh madikte ku pariye ig wasapanaw pimin. ");
INSERT INTO plu_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Egme kiyapuno Mahi awna: ―Nah kabayha Uhokri apititakwa nuyakni. ");
INSERT INTO plu_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Nah kaayhsima batek ku samah ig amnihpen. ");
INSERT INTO plu_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Mmanawa ig kiyenhu nah gibuk yumanano nukiythani. Akiwka akiwkanek madikte hiyeg kinetihwa numinhunek ku samah nah kabunuga gikak Uhokri. ");
INSERT INTO plu_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ig detyewa. Ig keh kibeyne annut ndahan. Ig barewpitye. ");
INSERT INTO plu_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Akiwka akiwkanek ig kagamnihrasima gikakkis madikte hiyeg ku pariye apisnepwi gibohri. ");
INSERT INTO plu_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ig kagannusima. Akak giwannen ig pasuhape ku pariye hiyeg kane kumadukasewkere ta git. ");
INSERT INTO plu_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ig wiwhe gikiythanikis gipititakkis hiyeg ku pariye detyepwi. Ignesme ku pariye yumanene gikiythanikis ig ikí gikiythanikis ta gipititkis. ");
INSERT INTO plu_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ig ikí kaayhsima kabayka ta gitkis hiyeg ku pariye kayehnenepwi ku pariye gimawkanitnenes giwntak Uhokri. Henneme ig ka ikí ariknawnama ta gitkis hiyeg ku pariye ikewnenepwi ku yuma arikna muwekne gitkis. ");
INSERT INTO plu_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Kibeyne. Ig parak abet uhawkanwiy wixwiy gihiyegapu israelyenepwi. Ig ka miyeh giwn ku samah ig awna minikwak: “Nah amnihgikisnek.” ");
INSERT INTO plu_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ku samah ig awna inakni ta git amekene Abrawh gikakkis gihiwhipwi, ku pariye wahawkripwiy, hennewa ig amnihwiy adahan apanenekwa. Hennewatbaki eg kiyapuno Mahi awna. ");
INSERT INTO plu_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Pisenwa nikwe ariwnteke ini eg kiyapuno Mahi msekwe gumun amakano Isabel. Eg mpiyase mpana kayg ayge. Ayteke eg diyuhe ta gupinwat. ");
INSERT INTO plu_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ariwnteke ini eg amakano Isabel guhawkanaprik danuh. Eg pamakuteke. Eg sarayh gukamkayh ig awayg. ");
INSERT INTO plu_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Guhumwayepwi gukakkis gukebyupwi egkis timé gak inakni ku samah Uhokri amnihpig egkis iwasapru atere. Egkis batekyokis payak gukak. ");
INSERT INTO plu_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ariwnteke ini pahay paka akiw nikwe hiyeg danuh atere adahan hiwhpiye gukamkayh gipit ku samah judeyenepwi gihiyakemnikis. Igkis sarayhpiye ig bakimni giw giwaprik gig amekene Zakaríyas. ");
INSERT INTO plu_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Egme ginag awna: ―Kawa. Amawka wis sarayh giw João. ");
INSERT INTO plu_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Igkisme kaytwa guwn: ―Mmahki? Yuma pahapwinama pikebyi giw henne. ");
INSERT INTO plu_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ayteke igkis ipeg ta gimkat gig igkis barasepri adahan igme akki ku samah gimawkan giw. ");
INSERT INTO plu_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Igme ayá kagta gitkis. Ayge amadga ini kagta ig tamak: “Giw João.” Nerras hiyeg hiyapni henne, igkis wakaymnibdi kaayhsima. ");
INSERT INTO plu_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Aynewa ig amekene Zakaríyas gibiy ik adahan ig awna akiw. Ig awna, ig kibeyhene Uhokri. ");
INSERT INTO plu_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Madikte msekwenepwi ayge igkis timé inakni gak henne, igkis wakaymnibdi gidahan kaayhsima. Inakni inetit gimin ibekhewpi muwwapu apitiw ini waxribdi ayge Judeyamnaw. ");
INSERT INTO plu_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Madikte hiyeg ku pariye timé gak igkis ipegminenekwa gihiyakemnikis gimin. Igkis awna: ―Pariye ner bakimni ig humawnek? Mmanawa in kahayak huwewe wotwiy ku Uhokri ay gikak. ");
INSERT INTO plu_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Igme bakimni gig amekene Zakaríyas, Uhokri Gitip kawihpig, ig awna yuwit ku pariye pes giwntak Uhokri. Giwn: ");
INSERT INTO plu_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","―Kibeyne gidahan Uhokri, ku pariye uwohkigawiy wixwiy israelyenepwi. Ig kuwis parak abet uhawkanwiy wixwiy gihiyegapu. Kuri ig keh wixwiy isamtaw. ");
INSERT INTO plu_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ig kuwis awahkise uminwiy pahapwi wamnihtenwiy detye. Iggi gihiwhi amekene Davi ku pariye gibuk Uhokri. ");
INSERT INTO plu_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ig Uhokri keh gawnepepu pitatyepwi kinetihwa gidahan henne minikwak. ");
INSERT INTO plu_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ig awna ku ig keh wixwiy isamtaw giwkis upetunyapuwiy giwkis madikte ku pariye wamiyetnipwiy. ");
INSERT INTO plu_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ig awna gitkis wahawkripwiy amekenegben: “Nah amnihyinek. Nah ka miyeh ku samah nah ikaksin yit.” ");
INSERT INTO plu_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Mmanawa ig ikakse minikwak git wahawkriwiy amekene Abrawh ");
INSERT INTO plu_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ku ig wiwhpewiy giwakutakkis upetunyapuwiy kahadbe wixwiy ka apisnema kawohkigahaw ta git Uhokri ");
INSERT INTO plu_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","adahan wixwiy wew waditye barewpitye giwtrik Uhokri madikte ku samah wowskawniwiy amadga hawkri. ");
INSERT INTO plu_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Pis nukamkayh, pis kanumkanek Uhokri inugikyene gawnepe mmanawa pis danuh gapitkiya Ukiparawiynek adahan pis ahegbetepye madikte apit gaytni. ");
INSERT INTO plu_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Pis akkinek gitkis gihiyegapu ku igkis isamtaw awaku ku samah Uhokri bayahminigkis ariw gipathawnikis. ");
INSERT INTO plu_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Mmanawa ig Uhokri kagamnihrasima ukakwiy. Inneki keh ig paraksa abet uhawkanwiy pahapwi kabutennene inutak ");
INSERT INTO plu_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","adahan ig uguhne gihiyakemnikis hiyeg ku pariye abetnenepwi amisnapyi abetnenepwi apiskarad abohri miyaka. Iggi keh wixwiy msakwa abet pasamrakanek. Hennewatbaki ig amekene Zakaríyas awna. ");
INSERT INTO plu_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ayteke ariwnteke ini ig bakimni aymuhwa. Ig kawih Uhokri gihiyakemni kabayhtiwa. Ayteke barew gikipari kuwis ig tipik msekwe amadga amatap ku kiney yumanene hiyeg msakwa. Ayge ig msakwa juktah ku aysaw gihawkanaprik danuh adahan ig ekkene Uhokri gihiyakemni ta gitkis hiyeg israelyenepwi. ");
INSERT INTO plu_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Apim ini hawkri minikwak amekene Sésar Awgustu wasapanaw giminkis madikte hiyeg adahan igkis tamakkiswiyes giwkis ku aysaw gikebyikis. ");
INSERT INTO plu_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","In pitatye akapuska ig tamakkis giwkis gitkis. Ig keh henne apim ini hawkri ku aysaw amekene Kirinu kumadukene hiyeg ayge Síriyamnaw. ");
INSERT INTO plu_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ayge nikwe madikte hiyeg atak ta apitit giwaxrikis ku kiney igkis waypuka adahan igkis tamakkiswiyes giwkis atere. ");
INSERT INTO plu_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ig amekene José tipikwata adahan ig tamakkiswiye giw. Ig tipik apititak paytwempu Nazaré ku pariye aynene Galiléyamnaw. Ig tipik ta apitit Judeyamnaw ta apitit pahá paytwempu kewye Belém ku kiney amekene Davi ig waypuka. Ig atak atere awaku ig amekene Davi gihiwhi. ");
INSERT INTO plu_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ig atak tamakkiswiye giw gukak kiyapuno Mahi ku kakak ig kuwis ahegbet ginetni. Egme biyuhkisno giwntak Uhokri Gitip. ");
INSERT INTO plu_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Egkis danuh atere, eg kiyapuno Mahi gukaygaprik danuh adahan eg pamakutekwiyo. ");
INSERT INTO plu_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Henneme yuma iwetrit ayge gudahan agiku payt danuhpenepwi gipinkis. Ayteke nikwe egkis uté pahá payt pak apin. Ayge eg sarayhe gukamkayh guhimnatine. Eg awasamkuhpig akak giybet. Eg haritasig ta amadgat pak amanaratiy. ");
INSERT INTO plu_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Aygenewa apit ini waxri pahabu muttuhputne ayge amatmadga. Igkis ayge apuriwnes gipigkis muttuh hewke tiyegim. ");
INSERT INTO plu_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Pahaye adahan pahapwi ahj Uhokri giwatni hiyapkiswe ta gitkis. Uhokri gibutni uguhpigkis. Igkis hiyapni henne, igkis apisasew kaayhsima. ");
INSERT INTO plu_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Igme ahj awna gitkis: ―Ka yi muwaka apis. Timapnabay nuwnhu. Nah ewk yit kibeyne inetit. Kaayhsima batekka ay gidahankis madikte hiyeg. ");
INSERT INTO plu_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Mmanawa ku apim inin yamnihten amadgat wayk kuwis. Ig waypuka apit ini paytwempu ku kiney amekene Davi waypuka. Iggi Ukiparawiy Cristo, ig Uhokri gikanyan adahan yikumaduketni. ");
INSERT INTO plu_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Nah akkite yit ku samah yis hiyakri. Yis utiprinek awasamuk akak giybet ig harit amadga pak amanaratiy. ");
INSERT INTO plu_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Pisenwa ner ahj giwn, pahaye adahan kaayhsima ahj inugikyenepwi hiyapkiswe ayge gihumwa. Igkis kibeyhenes Uhokri. Igkis awna: ");
INSERT INTO plu_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","―Kibeyne gidahan Uhokri ay inugik. Batekka ay gidahankis hiyeg ku pariye Uhokri gibetkipu ay amadga hawkri. ");
INSERT INTO plu_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Pisenwa gibetkikis igkis tipik ta inugikut akiw. Igkisme muttuhputnepwi hiyapni henne, igkis kinetihwa pawtak. Igkis awna: ―Uyay atak ta apitit paytwempu Belém. Uyay iwasa ini ku pariye danuh wotwiy, ku pariye Uhokri akki wotwiy ku apim inin. ");
INSERT INTO plu_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Igkis tipik kibentenwa. Igkis danuh atere, igkis ipegpig. Metakwa igkis uté kiyapuno Mahi gikak amekene José. Ayge igkis hiyá ner bakimni harit amadga pak amanaratiy. ");
INSERT INTO plu_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Igkis hiyapni henne, igkis akki ta gitkis madikte hiyeg ku pariye nerras ahj kinetihwa gitkis gimin ner bakimni. ");
INSERT INTO plu_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Igkis hiyeg timé nerras muttuhputnepwi awna inakni, igkis wakaymnibdi kaayhsima. ");
INSERT INTO plu_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Egme kiyapuno Mahi darihe inakni inetit ay gutiwgik. Eg takunipti ipegminano guhiyakemni nimin. ");
INSERT INTO plu_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Igkisme muttuhputnepwi igkis diyuhe akiw. Igkis kibeyhenes Uhokri. Igkis awna: ―Uhokri kagabayisima ukakwiy. Kibeyne adahan madikte ku pariye hiyapkiska wotwiy ku apim inin. In inyerwa ku samah ner ahj gakkan wotwiy. ");
INSERT INTO plu_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ariwnteke ini pahay paka akiw, ahawkanaprik danuh adahan hiwhpika bakimni gipit. Ayge gipit hiwhpika. Nikwe ig sarayhka giw Jesus ku samah ner ahj kinetihwa gimin apim ini apit ginag biyuhkisri. ");
INSERT INTO plu_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ariwnteke ini ahawkanaprik danuh adahan eg kiyapuno Mahi makniw ariw ku samah eg pamakutak. Egkis hiyapni henne, egkis wiwhkiswiyos gupathawnikis ku samah amekene Moís gikumadukan awna. Nikwe egkis tipik atere ta apitit paytwempu Jerusalém. Egkis waxe gukamkayhkis atere adahan egkis gekkepten ta git Uhokri. ");
INSERT INTO plu_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Mmanawa Uhokri gikumadukan awna: “Madikte tinogben guhimnatinekis awayg igkis gidahanwa Uhokri.” ");
INSERT INTO plu_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Egkis danuh atere, egkis keh ofan gidahan Uhokri adahan ig wiwhpiye gupathawnikis. Mmanawa Uhokri gikumadukan awna adahan hiyeg keh ofan gidahan Uhokri piyana akebyi ugus ku kawka piyana akebyi tukwayan. ");
INSERT INTO plu_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ayge apit ini paytwempu Jerusalém pahapwi awayg giw Simeyawh. Ig kibeyne awayg. Ig waditye. Ig wahepnenekwa ner pahapwi ku pariye nemnikumpiye adahan ikepye gawaygyikis gihiyegapu israelyenepwi. Ig Uhokri Gitip aynene gipit. ");
INSERT INTO plu_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ig Uhokri Gitip kuwis akki git ku nekwa ig miyá ku ig hiyapwa Cristo ay amadga inin. ");
INSERT INTO plu_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Apim ini hawkri ig Uhokri Gitip awahkiswig parak ta agikut ini leglis kewye Uhokri Gipin. Ig danuh atere. Ayteke Kiyapwiye Jesus ginag gikak amekene José egkis hawwata danuh atere. Egkis waxe Kiyapwiye Jesus atere adahan egkis gekkepten ta git Uhokri ku samah gikumadukan awna. ");
INSERT INTO plu_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ig amekene Simeyawh hiyapni henne, ig iwé bakimni ta giwanmakut. Ig kabayha Uhokri. Ig awna: ");
INSERT INTO plu_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","―Kuri Kiyapwiye, nah ahegbet adahan nah miyá akak madikte nubetki. Hiyawa pis iwepun nah pibuk amadgatak inin. Mmanawa kuwis in danuh ku samah pis awna nuthu minikwak. ");
INSERT INTO plu_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Kuwis nah hiyá wamnihtenhu akakwa nuwtyak. Nah hiyá ner ku pariye pis ");
INSERT INTO plu_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ahegbete adahan gamnihtenkis madikte hiyegipiyenepwi amadga inin hawkri. ");
INSERT INTO plu_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ig humawnek kewa pahá abukribe adahan ig uguhne gihiyakemnikis nerras hiyeg kane judeyenepwima. Ig humawnek pihiyegapu israelyenepwi gikiythanikisnek. ");
INSERT INTO plu_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Eg ginag gikak amekene José egkis timapni henne, egkis wakaymni adahan inakni yuwit ku pariye ig amekene Simeyawh awna gimin bakimni. ");
INSERT INTO plu_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ayteke ig amekene Simeyawh kiyé Uhokri gudahankis. Pisenwa ig awna ta gut Kiyapwiye Jesus ginag: ―Kibeyne. Uhokri ikiswanaw gidahan ner pikamkayh adahan ig humaw arekhetni Uhokri gihiyakemni ta gitkis hiyeg israelyenepwi. Aysawnemenek kaayhsima hiyeg tukuhwepwa giw pikamkayhnek. Amun ini nikwe igkis biyukapnek. Henneme kaayhsima hiyeg akiw kamaxwepyes ta gipititnek. Igkis danuh ta git Uhokrinek. ");
INSERT INTO plu_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Mmanawa ig hiyapkisnek ku pariye hiyakemniki ayemewnene ay apit hiyeg giyaknikis. Pisme kiyapun, pis kayahnek apit piyakni kaayhsima. ");
INSERT INTO plu_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ku samah ig awnempiye inakni yuwit, pahapu tino danuh atere. Guw Ana. Eg pahapu Uhokri gawnepe. Eg amekene Fanuwew gikamkayh, eg aseryano. Eg kiyaparupyo kuwis. Eg kigihgup adahan ntewnehkerbu kamukri. ");
INSERT INTO plu_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ayteke eg madankup adahan kaayhsima kamukri akiw, ntewnehkerbu akak pahak arawna madikwa akebyi akak paxkabu akiw (84). Eg msakwa ayge agiku ini leglis kewye Uhokri Gipin. Apanenekwa eg maxhawno adahan eg kiyeno Uhokri gihiyakemni. Apanenekwa eg piriyepkawno ta git Uhokri. Apanenekwa eg kibeyhepri. ");
INSERT INTO plu_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Eg danuh atere, eg uteprikis ayge. Eg hiyapni henne, eg kabayha Uhokri. Han pitatit eg kinetihwano gimin Kiyapwiye Jesus ta gitkis nerras jerusalémyenepwi ku pariye wahepnenepwi gamnihtenkis. ");
INSERT INTO plu_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Egme kiyapuno Mahi gikak amekene José egkis pisenwa akak madikte ku pariye Uhokri gimawkan ta gutkis, egkis tipik. Egkis diyuhe ta apitit guwaxrikis Galiléyamnaw ta apitit ini paytwempu Nazaré. ");
INSERT INTO plu_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ayteke ariwnteke ini ig bakimni ig aymuhwe. Ig kawih Uhokri gihiyakemni kabayhtiwa. Ig humaw hiyakemniye hiyeg. Ig Uhokri kagibetkisima gikak. ");
INSERT INTO plu_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Mpuse pahak kamukri hiyeg judeyenepwi fetya adahan ignes kiyenes ku samah minikwak Uhokri wiwhkiswiye amekenegben giwakutakkis hiyeg ejituyenepwi. Kiyapwiye Jesus ginag gikak amekene José egkis inpawa atak ta apitit paytwempu Jerusalém adahan egkis mpiyasa ini fet atere. ");
INSERT INTO plu_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ig Kiyapwiye Jesus barew gitakwayisa kuwis madikawkubu kamukri akak pikana arawna (12) gaw kuwis, egkis tipik gikak Kiyapwiye Jesus ta apitit Jerusalém ku samah inpawa egkis keh. ");
INSERT INTO plu_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Amapyah fet ig Kiyapwiye Jesus ginag gikak amekene José egkis diyuhpiyokis akiw. Igme Kiyapwiye Jesus msekwe ayge Jerusalém egkis ka hiyaknima. ");
INSERT INTO plu_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Egkis gupewkankiskam ku ig ayge gibetkis nerras ku pariye diyuhpiyepwi. Nikwe egkis wewnokis pahay hawkri. Ayteke egkis ipegepri gupuriwkis gukebyupwikis gupuriwkis guhiyaknipukis. ");
INSERT INTO plu_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Henneme egkis ka utipri. Ayteke nikwe egkis diyuhe ta apitit Jerusalém. Egkis danuh atere, egkis ipegepri muwwapu akiw. ");
INSERT INTO plu_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Amamnam hawkri egkis utepri ayhté agiku ini leglis kewye Uhokri Gipin. Ig betnene ayge giyegbikis pahabu kannuhekeputnepwi. Ig timepne giwnkis ig gayapminetnikis ayge. ");
INSERT INTO plu_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Madikte timepnepwi ayge igkis wakaymnibdi awaku ku samah ig kaytwa giwnkis akak kibeyne hiyakemniki. ");
INSERT INTO plu_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Eg ginag gikak amekene José egkis hiyapri ayge, egkis wakaymni. Eg ginag awna git: ―Bakimni, mmahka pis arehwa ukakhu henne? Nah gikak pig usuh kaayhsima kiyimwih unaktin pikak adahan pipegepten muwwapu. ");
INSERT INTO plu_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Igme kaytwa guwn: ―Mmahki yis ipegpan muwwapu? Mmah yis ka hiyaknima ku nah nubetki msakwa ay gipineku Nighu? ");
INSERT INTO plu_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Egkisme ka pukuha inakni giwn. ");
INSERT INTO plu_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ayteke ig tipik guhaptikis ta apitit paytwempu Nazaré. Ayge ig kumadukasewne ta gutkis. Egme kiyapuno Mahi darih inakni giwn ay gutiwgik. Eg takunipti ipegminano guhiyakemni nimin. ");
INSERT INTO plu_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Igme bakimni aymuhwe hiyakemniye. Mpuse hawka ig imuw. Uhokri batek gikak kaayhsima. Hawwata madikte hiyeg hawwata igkis batek gikak. ");
INSERT INTO plu_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ayteke ariwnteke ini kibite kamukri akiw, Uhokri wasapanaw gimin amekene João Batista, ig ku pariye amekene Zakaríyas gikamkayh. Apim ini hawkri amekene Tibériyu Sésar kumadukene madikte hiyeg romayenepwi. Ayipa ig kumadukigkis adahan kibite kamukri, madikawkubu akebyi akak pohowkubu arawna (15). Igme amekene Pônsiyu Pilatus kumadukene hiyeg ay apit Judeyamnaw. Igme amekene Erodis kumadukene hiyeg ay apit Galiléyamnaw. Igme gegni amekene Filip kumadukene hiyeg ay apit Ituréyamnaw akak Tirakoniteyamnaw. Igme amekene Lisâniyas ig kumadukene hiyeg ay apit Abileneyamnaw. ");
INSERT INTO plu_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Igme amekene Anás gikak amekene Kayfás igkis kumadukenes judeyenepwi gimuwpegapukis. Igme amekene João Batista, ku pariye amekene Zakaríyas gikamkayh, ig ayhté amadga amatap. Apim ini ig Uhokri wasapnaw gimin adahan ig tipik ekkene giwn. ");
INSERT INTO plu_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ig timapni henne, ig tipik. Ig ekkene giwsapan Uhokri muwwapu aranwa warik Jordawh. Ig awna ta gitkis hiyeg: ―Wagesnabay yihiyakemni ariw yitaraksan. Kewpinabay ta ahakwat un adahan yis amepene ini ku Uhokri bayahminay ariw yitaraksan. Hennewatbaki ig amekene João Batista awna. ");
INSERT INTO plu_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Minikwak Uhokri gawnepe amekene Isaías ig kinetihwa gimin ig amekene João Batista. Ig tamak inakni giwn amadga kagta. Ig awna: “Pahapwi kinetihwanek ta gitkis hiyeg amadga amatap. Ig awnanek: ‘Ahegbetawnabay gapit Ukiparawiy gaytni. Ig nemnik ig. Wadithanabay yihiyakemni gidahan kahadbekam yis kawih gidahan Uhokri gikumadukan. ");
INSERT INTO plu_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Yihiyakemni kewa pahatra ahinbe mbeyepyebe. Ka ik adahan ig Ukiparawiy sibuhaprik atere. Kipuhaprikanabay ini ku kiney duwihaprikapniye. Kiguknabay ku kiney ini imuhgipitapnipye. Waditaprikanabay ini ku kiney kiduwapriknene. Ahegapanabay ini ku kiney duwibdamnipye. ");
INSERT INTO plu_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ayge nikwe madikte hiyeg hiyaknek ku samah Uhokri amnih hiyeg.’ ” Hennewatbaki ig Uhokri gawnepe awna minikwak. ");
INSERT INTO plu_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Kaayhsima hiyeg ayta kaywasewpiye ta git amekene João Batista. Igme awna ta gitkis: ―Yis kaybunyune hiyeg pahaywitniyepwi. Uhokri ka batek akak yihiyakemni kane kibeynema. Mmah yitneki yikewpen keh ig hiyapyi ke wotbe yis kibeynepwibe hiyeg giwtrik? ");
INSERT INTO plu_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kawa. Ini yikewpen ka kinisri. Amawka ku yis inyerwa wages yihiyakemni ariw yitaraksan. Kapusanabay wew wadit. Ini yiwewni waditye ininewa arekhetni ku yis inyerwa wages yihiyakemni. Hawwata akiw, ka yi muwaka awna: “Wixwiy hiyeg judeyenepwi wixwiy amekene Abrawh gihiwhipwi. Amun ini wixwiy kuwis Uhokri gihiyegapu. Ayge nikwe ig Uhokri ka aminama ariw utaraksanwiy. Ig hiyapwiy kewa kibeynepwibe giwtrik.” Ka ik adahan yis awna inakni henne. In ka ariknawnama ku wixwiy amekene Abrawh gihiwhipwi. Ka innema keh wixwiy isamtaw. Ik adahan Uhokri keh no tip humaw amekene Abrawh gihiwhipwi. ");
INSERT INTO plu_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ahawkanaprik kabá danuh adahan Uhokri ipuke hiyeg patahwapye hampa arimkanit biyukwiki. Pahapwi ku pariye kane wew wadit amadga hawkri iggi kewa pahakti amutribe ku pariye sarayh guw kane kabaynopwima. Igme Uhokri ig kewa pahapwi awaygbe ku pariye kuwis ahegbet akak gimegwan adahan ahukepten eggu ah kane kabaynoma. Ku pariye gamutra ka sarayh guw kabayno guw, eggu ig ihukapepru ig padakapepru ariwtrikut tiket bukahapepru. ");
INSERT INTO plu_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Igkis hiyeg timapni henne, igkis awna git: ―Mmahpa usuh keh adahan usuh wew wadit? ");
INSERT INTO plu_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Igme kaytwa giwnkis: ―Amnihaknay pawtak. Ku pahapwi yaytak kasimsa pikana akebyi, amawka ku ig ikí pahak ta git pahapwi ku pariye yumanene gisimsa. Ku pahapwi yaytak kamana, amawka ku ig ikí git pahapwi ku pariye yumanene gimana. Hennewatbaki ig amekene João Batista awna. ");
INSERT INTO plu_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ayteke awaykemni ladwan danuh atere adahan igkis kaywasewpiyes ta git amekene João Batista. Igkis awna git: ―Kiyapwiye, mmah usuh keh? ");
INSERT INTO plu_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Igme kaytwa giwnkis: ―Ka ba yi kinis hiyeg akiw. Ka yi muwaka ayá karukri mpiyepepyema mpiya ku pariye gupelma ayá adahanma yis msekwe akak asemne. ");
INSERT INTO plu_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Hawwata akiw suwtat danuh atere git amekene João Batista. Igkis awna git: ―Ya usuh, mmah usuh keh? Igme kaytwa giwnkis: ―Ka ba yi mpiksaptih hiyeg ikí karukri yit. Hawwata akiw ka ba yi ayá yitiwni git pahapwi adahan yis ka kamiyig ta git yikipara. Yis kuwis katiwnihka gapit yikipara. Ikeypi. Ka yi muwaka aharit akiw. ");
INSERT INTO plu_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Madikte hiyeg ayge igkis wahepnenekwa gaytni Cristo ig Uhokri gikanyan adahan ukumaduketniwiy. Igkis kapusa pukuhepwe gibohri amekene João Batista ku nawenétke ignewa ku pariye Cristo. ");
INSERT INTO plu_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ig amekene João Batista hiyapni henne, ig awna gitkis: ―Ku aysaw nah kaywepyi, nah kawihkis un ta yipitit. Henneme pahapwi nemnikumpiye nuhapuh butte ku pariye kaywepyi akak igyerwa Uhokri Gitip adahan ig kawihkis gidahanwa gihiyakemni akak gannu ta yipitit Yaytakme ig kawihkis tiket ta yipititnek. Ig ner kaayhsima pi kiyatte mpiyhan. Nah yuma nukiythanisima gitiput adahan nah ayapig wiwh gikasotni gikugkuptak. ");
INSERT INTO plu_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Aysawnemenek ig ibekhe hiyegnek hawwata ku samah wis ibekhe amutri ayak akak amar. Ig ahegbet ibekhepye hiyeg kuwis ke pahapwibe awayg akak pahak huw ay giwaku ig ahegbet adahan ig mihikobetene amutri ayak ariw amar. Ig ibakhanek ku pariye kibeynepwi hiyeg akak ku pariye kane kibeynepwima hiyeg. Hawwata akiw, ku samah wis bayah amutri ayak agiku payt, amarme wis bukehpig, hawwata ner nemnikumpiye ig bayah hiyeg ku pariye kibeynepwi agiku gipin. Nerrasme ku pariye kane kibeynepwima, igkis bukehpikanek ariwtrik eggu tiket ku pariye kane awakti. ");
INSERT INTO plu_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Hennewatbaki ig amekene João Batista awna. Ig ikenenekwa hiyeg gihiyakemnikis akak inakni yuwit akak kaayhsima yuwit akiw ku samah ig ayge ekkene Uhokri ginetni gitkis. ");
INSERT INTO plu_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Hawwata akiw ig awna gimin amekene Erodis apatra ku samah igme powkemnihwe gukak giwgun amakano Erodíyas, ig keh kaayhsima mbayka akiw. ");
INSERT INTO plu_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ig amekene Erodis hiyapni henne, ig sarayhkis amekene João Batista ta agikut parakseket. Henne ig kiyesihe gitaraksan akiw. ");
INSERT INTO plu_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Apim ini hawkri ku samah ig amekene João Batista kote sarayhkahte agikut parakseket, ig ekkene Uhokri ginetni, ayge ig kaywe kaayhsima hiyeg. Ig Kiyapwiye Jesus ig hawwata kewpi aygwata. Pisenwa gikewpen ig piriyepkewne ayge. Pahaye adahan en woke. ");
INSERT INTO plu_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ayteke Uhokri Gitip muhuke ta gipitit, gihipak ke pahapu tukwabe. Ayteke pahá ikupimnat awna aytontak inugiktak. In awna: ―Pisnewa nukamkayh nubetki. Nah batek pikak kaayhsima. ");
INSERT INTO plu_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ariwnteke ini ig Kiyapwiye Jesus kapusa gannipwi gidahan Uhokri. Apim ini ig kadahan mpanabu madikwa kamukri (30) gaw. Gitkis hiyeg ig amekene José gikamkayh. Gahawkri giw amekene Elí. ");
INSERT INTO plu_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Igme amekene Elí gig amekene Matati. Ig amekene Matati gig amekene Levi. Igme amekene Levi gig amekene Mawki. Igme amekene Mawki gig amekene Janay. Igme amekene Janay gig amekene José. ");
INSERT INTO plu_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Igme amekene José gig amekene Matatiyas. Igme amekene Matatiyas gig amekene Amós. Igme amekene Amós gig amekene Nawh. Igme amekene Nawh gig amekene Eslí. Igme amekene Eslí gig amekene Nagay. ");
INSERT INTO plu_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Igme amekene Nagay gig amekene Máati. Igme amekene Máati gig amekene Matatiyas. Igme amekene Matatiyas gig amekene Semey. Igme amekene Semey gig amekene José. Igme amekene José gig amekene Joda. ");
INSERT INTO plu_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Igme amekene Joda gig amekene Joanah. Igme amekene Joanah gig amekene Resa. Igme amekene Resa gig amekene Zorobabew. Igme Zorobabew gig amekene Salatiyew. Igme amekene Salatiyew gig amekene Neri. ");
INSERT INTO plu_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Igme amekene Neri gig amekene Mewki. Igme amekene Mewki gig amekene Adi. Igme amekene Adi gig amekene Kosah. Igme amekene Kosah gig amekene Ewmadoh. Igme amekene Ewmadoh gig amekene Er. ");
INSERT INTO plu_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Igme amekene Er gig amekene Josuwé. Igme amekene Josuwé gig amekene Eliyézer. Igme amekene Eliyézer gig amekene Jorih. Igme amekene Jorih gig amekene Matati. Igme amekene Matati gig amekene Levi. ");
INSERT INTO plu_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Igme amekene Levi gig amekene Simeyawh. Igme amekene Simeyawh gig amekene Judá. Igme amekene Judá gig amekene José. Igme amekene José gig amekene Jonah. Igme amekene Jonah gig amekene Eliyakih. ");
INSERT INTO plu_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Igme amekene Eliyakih gig amekene Meleá. Igme amekene Meleá gig amekene Mena. Igme amekene Mena gig amekene Matata. Igme amekene Matata gig amekene Natah. Igme amekene Natah gig amekene Davi. ");
INSERT INTO plu_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Igme amekene Davi gig amekene Jessé. Igme amekene Jessé gig amekene Obedi. Igme amekene Obedi gig amekene Boaz. Igme amekene Boaz gig amekene Sala. Igme amekene Sala gig amekene Nassoh. ");
INSERT INTO plu_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Igme amekene Nassoh gig amekene Aminadabi. Igme amekene Aminadabi gig amekene Admih. Igme amekene Admih gig amekene Arni. Igme amekene Arni gig amekene Esroh. Igme amekene Esroh gig amekene Peres. Igme amekene Peres gig amekene Judá. ");
INSERT INTO plu_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Igme amekene Judá gig amekene Jakó. Igme amekene Jakó gig amekene Izaki. Igme amekene Izaki gig amekene Abrawh. Igme amekene Abrawh gig amekene Tera. Igme amekene Tera gig amekene Nakor. ");
INSERT INTO plu_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Igme amekene Nakor gig amekene Seruki. Igme amekene Seruki gig amekene Ragaú. Igme amekene Ragaú gig amekene Faleki. Igme amekene Faleki gig amekene Éber. Igme amekene Éber gig amekene Sala. ");
INSERT INTO plu_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Igme amekene Sala gig amekene Kaynah. Igme amekene Kaynah gig amekene Arfaxadi. Igme amekene Arfaxadi gig amekene Seh. Igme amekene Seh gig amekene Noé. Igme amekene Noé gig amekene Lameki. ");
INSERT INTO plu_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Igme amekene Lameki gig amekene Metusaléh. Igme amekene Metusaléh gig amekene Enoki. Igme amekene Enoki gig amekene Jareti. Igme amekene Jareti gig amekene Malelew. Igme amekene Malelew gig amekene Kaynah. ");
INSERT INTO plu_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Igme amekene Kaynah gig amekene Enos. Igme amekene Enos gig amekene Seti. Igme amekene Seti gig amekene Adawh. Igme amekene Adawh gig Uhokri. ");
INSERT INTO plu_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ig Kiyapwiye Jesus tipik ariwntak eggu warik Jordawh ig gitiphewne Uhokri. Ig danuh ta amadgat amatap. Ayge ig Uhokri Gitip gihuwtenten. ");
INSERT INTO plu_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Igme wapitye gikiparadkis gihikekten adahan hiyá ba hiyá igma taraksasepri. Ig Kiyapwiye Jesus msekwe ayge adahan paxnika madikwa (40) hawkri. Abet ini hawkri ig maxhewne. Ayteke nikwe ig matipwe. ");
INSERT INTO plu_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Igme wapitye gikiparadkis hiyapni henne, ig danuh atere. Ig awna git: ―Ku pis Uhokri gikamkayh, asá awna ta gut no tip adahan eg wageswa bugut pidahan. ");
INSERT INTO plu_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Igme Kiyapwiye Jesus kaytwa giwn: ―Kawk. Mmanawa Uhokri gannasan awna: “Hiyeg ka aymahwa akak bugutwonama. Ay pahat arikna pi muwakte ariw axka.” ");
INSERT INTO plu_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ayteke ig wapitye gikiparadkis ig waxe Kiyapwiye Jesus ta apitit pahá iwetrit imuwadnene. Ayge ig ekke git madikte gikumadukan amedgene inin. Ig akkin git pahatyamin. ");
INSERT INTO plu_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ig awna git: ―Nah ikí madikte ini nukumadukan ta piwakuit. Nah ikí pit igiska madikte. In kuwis ikaki nuwakuit. In ndahan nah ikí ku karit nah ikekere. ");
INSERT INTO plu_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ku pis paberetusaw ntiput adahan pis kiyathan, nah ikí madikte ini ta piwakuit. ");
INSERT INTO plu_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Igme Kiyapwiye Jesus kaytwa giwn: ―Kawk. Mmanawa Uhokri gannasan awna: “Kiyathanaba ignewa Kiyapwiye piwohkiga. Kehnaba ignewa gibetki.” ");
INSERT INTO plu_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ayteke ig wapitye gikiparadkis ig waxe Kiyapwiye Jesus ta apitit paytwempu Jerusalém. Ig waxwig ta inut apuhekut ini leglis kewye Uhokri Gipin. Ayge ig awna git: ―Ku pis Uhokri gikamkayh, asá watiswa ayteke inutak. ");
INSERT INTO plu_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Mmanawa Uhokri gannasan awna: “Uhokri apuriwkispi ta gitkis ahj ");
INSERT INTO plu_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","adahan igkis amapap amadga giwakkis marihwa pikugku ka tes apit tip.” ");
INSERT INTO plu_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Igme Kiyapwiye Jesus kaytwa giwn: ―Kawk. Mmanawa hawwata Uhokri gannasan awna: “Ka yi muwaka hikek Kiyapwiye yiwohkiga baki igyerwatma ay yikak.” ");
INSERT INTO plu_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ayteke ig wapitye gikiparadkis ig awna arakembet yuwit akiw adahan ig taraksase Kiyapwiye Jesus. Henneme ig ka hiyá gisamanak. Ayteke ig hiyapni henne, ig tipik giw. Henneme ig wahepnenekwa ku aysaw ig kawetri akiw adahan ig gihikekten akiw. ");
INSERT INTO plu_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Pisenwa ig Kiyapwiye Jesus tipik ig diyuhe ta apitit Galiléyamnaw akak Uhokri Gitip gannu ay gipit. Inetit gidahan ibekhewpi muwwapu ayge. ");
INSERT INTO plu_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ig kannuhekne agiku kaayhsima judeyenepwi gileglisakis. Apim ini madikte hiyeg kabayhig. ");
INSERT INTO plu_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ayteke ig danuh ta apitit paytwempu Nazaré ku kiney ig aymuhwa. Samdi abet ig lammisya agiku leglis ayge ku samah inpawa ig keh. Ayge ig kannikaw ig tabira gipetunkis hiyeg adahan ig ipegbohene Uhokri gannasan minikweknene ta gitkis. ");
INSERT INTO plu_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ikaki ta git pahak kagta Uhokri gannasan git gawnepe amekene Isaías. Ig wokapni ig uté ini iwetrit ku kiney in awna: ");
INSERT INTO plu_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Uhokri kuwis kawihkiswen gikak Gitip. Ig kaniypen adahan nah ekkene kabayka ta gitkis hiyeg ku pariye kane hiyak kabayka. Ig awahkisun adahan nah ikene gawaygyikis ta gitkis hiyeg ku pariye yumanene gawaygyikis. Ig awahkisun adahan nah watakminapepye hiyeg ku pariye wanamnamnepye. Ig awahkisun adahan nah keh motapye hiyá. Ig awahkisun adahan nah woka kabayka gidahankis hiyeg ku pariye hiyepne mbeyne. ");
INSERT INTO plu_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ig awahkisun adahan nah ekkene ku Uhokri gihawkanaprik kuwis danuh adahan ig amnihpiye hiyeg.” ");
INSERT INTO plu_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Pisenwa gipegbohan inakni yuwit, ig Kiyapwiye Jesus sabuk ini kagta ig diyuhkisni ta git kagta akapriwten. Ayteke ig bat ayge gipetunkis hiyeg adahan ig gikannuhtenkis. Igkisme madikte ipeg ta gimkat. ");
INSERT INTO plu_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ig awna ta gitkis hiyeg: ―Ku apim inin inakni yuwit Uhokri gannasan minikweknene metakwa in kahayak amun ini ku aysaw yis timapni. ");
INSERT INTO plu_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Igkis hiyeg timapni henne, igkis wakaymnibdi gimin. Igkis awna: ―Inakni kibeyne yuwit. Mmahki ig awna inakni yuwit henne? Ka ba yis hiyá ku ner amekene Josénen gikamkayh? ");
INSERT INTO plu_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ig hiyapni henne, ig awna gitkis: ―Ay pahat yuwit patuwesbuhka ku pariye wis inpawa awna ku aysaw wis pukuhpaw gibohri pahapwi. Wis awna: “Ku pis igyerwa piyihekeputne, asá piyih pipit kite.” Ku apim inin yis awnanek inakni yuwit nuthu. Yis awna: “Usuh timé pak ku pis keh kaayhsima annut ayhté Kafarnawh ku pariye hiyeg amadgaya inin ka hiyá nikehka. Ku inyerwa pis keh annut ayge, uyá akki wothu pannu ay apit inin piwaxri ku kiney pis aymuhwa.” ");
INSERT INTO plu_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ayteke ig Kiyapwiye Jesus awna akiw. Giwn: ―Yuma pahapwinama Uhokri gawnepe kiyathaka gapitkis hiyegipiyene ku pariye apitya giwaxriwa. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Hennewa in ku samah minikwak ku kapim Uhokri gawnepe amekene Eliyas ay amadga inin. Apim ini muwok ka wayk adahan mpanabu kamukri akak abusku. Nikwe mihetniki danuh atere. Kaayhsima madankunopwi judeyanopwi ayge apit Judeyamnaw. ");
INSERT INTO plu_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ig amekene Eliyas ig hiyeg judeyene henneme ig ka awahkiska guminkisma norras ku pariye apitya giwaxriwa adahan ig gamnihpitnikis. Kawa. Ig awahkiska gumin pahapu madankuno ku pariye apitya paytwempu Sarepta kennesa arimkat paytwempu Sidoh. ");
INSERT INTO plu_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Hawwata akiw ariwnteke ini, ku kapim Uhokri gawnepe amekene Elisew ay amadga inin, ayge Judeyamnaw kaayhsima hiyeg axpusakare apit busukne. Kameki ig makniwigkisme. Igme pahapwi kane judeyenema giw Naamah, ku pariye apitya Síramnaw, ignewa ku pariye makniwhka. ");
INSERT INTO plu_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Igkis hiyeg agikunepwi ini leglis igkis timapni inakni yuwit henne, igkis kaayhsima dagawne git Kiyapwiye Jesus ku samah ig kinetihwa amin ku samah Uhokri pi kapigsate hiyeg kane judeyenepwima giwkis hiyeg judeyenepwi. ");
INSERT INTO plu_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Igkis awna: ―Uyay umehpig! Ini paytwempu ay apit pahá waxri imuhgipitnene. Ayteke nikwe igkis ipukepri apititak paytwempu. Igkis waxepri ta arit kasebapawnene kahadbe igkis tukuhpig ayteke. ");
INSERT INTO plu_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Igme hiyapni henne, ig mpiye gipuriwkis. Ig tipik giwkis. ");
INSERT INTO plu_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ig danuh ta apitit paytwempu Kafarnawh ayhté Galiléyamnaw. Ayge ig kannuhne hiyeg abet samdi, abet ini hawkri ku pariye hiyeg judeyenepwi kiyatha. ");
INSERT INTO plu_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Nerras hiyeg aygnenepwi wakaymnibdi gidahan ku samah gikannuhakni. Mmanawa ig kinetihwene akak madikte gikiythani. ");
INSERT INTO plu_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ayge agiku ini leglis pahapwi awayg wapityewnipye mbeyepye. Ig kabiman kihhaw. Ig awna git: ");
INSERT INTO plu_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―Aa, Jesus nazaréyene, ka ba kiyimwih usuh. Pariye pikehni ukakhu? Mmah pis ayta pisenwepye uhawkan ku apim inin? Nah hiyaknap ku pis Uhokri gikanyan barewpitye. ");
INSERT INTO plu_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ig Kiyapwiye Jesus timapni henne, ig himehe ner wapitye. Ig awna git: ―Tinwohaw. Asá pes ayteke gipititak ner awayg. Aynewa ig wapitye nuwiswig. Ig keh ig tuguhe gibetkis hiyeg. Ayteke ig pese gipititak. Ig ka keh mbaynama gikak aynesnima. ");
INSERT INTO plu_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Madikte hiyeg hiyapni henne, igkis wakaymnibdi. Igkis kinetihwenes pawtak. Igkis awna: ―Mmah awitwak git inakni giwn? Ig pekkis wapityempu akak madikte gikiythani akak gidatni. Igkisme pes. ");
INSERT INTO plu_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ariwnteke ini, inetit gimin Kiyapwiye Jesus ibekhewpi muwwapu apitiw ini waxri. ");
INSERT INTO plu_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ayteke ig Kiyapwiye Jesus kannikaw pese agikutak ini leglis, ig tipik. Ig danuh ta gipinekut kiyapwiye Simawh Pedru. Ig uté kiyapwiye Simawh Pedru gimatru ayge. Eg nawepyo kaayhsima. Ayteke nerras hiyeg ayge amnihswe git Kiyapwiye Jesus gudahan. ");
INSERT INTO plu_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ig Kiyapwiye Jesus hiyapni henne, ig atere tabir guhumwa. Ig himehe gunawan. Kibentenwa mpiye guw. Aynewa eg kannikaw eg kuwegwano gidahankis. ");
INSERT INTO plu_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ayteke wahanbuku kamuw madikte hiyeg ku pariye kadahan hiyeg kakahriye ay gipinekukis igkis waxeprikis ta gimkat Kiyapwiye Jesus. Ignesme arakembete gikahrikis. Ig hiyapni henne, ig sarayh giwak ta gipititkis. Ig makniwapeprikis. ");
INSERT INTO plu_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Hawwata akiw wapitye pes gipititakkis kaayhsima hiyeg. Igkis kabiman. Igkis awna git: ―Pis Uhokri gikamkayh. Igme himahgikis. Ig ka isaksigkis adahan igkis awna awaku igkis hiyaknig ku ig Cristo. ");
INSERT INTO plu_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ayteke hewke ig Kiyapwiye Jesus tipik. Ig tipik aparayewa ku kiney yumanene hiyeg. Igkisme hiyeg ipegepri. Igkis danuh atere git. Igkis awna git: ―Uyá ka muwaka tipik wowhu. ");
INSERT INTO plu_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Igme kaytwa giwnkis: ―Kawk. Pugamawka nah akki Uhokri ginetni amin gikumadukan ayhté apit nawenépwi paytwempu akiw. Adahanikwa ini nah awahkiska atan. ");
INSERT INTO plu_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ayteke nikwe ig tipik ekkene Uhokri giwn agiku judeyenepwi gileglisakis muwwapu Judeyamnaw. ");
INSERT INTO plu_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Apim ini hawkri ig Kiyapwiye Jesus tabirnene akigbimna mahakwa kewye Jenesaré. Hiyeg kabubuknene kiyaran ganwa timepne Uhokri giwn. Kabá igkis dehegbetig. ");
INSERT INTO plu_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ayteke ig hiyá mmukna umuh ayge akigbimna mahakwa. Umuh akipara ayipa katapta ihapkat. Igkis ayge sukuhbetene gitagmayakis. ");
INSERT INTO plu_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ig Kiyapwiye Jesus hiyapni henne, ig sarayhwa ta amadgat pahamku umuh, kiyapwiye Simawh Pedru gihmun. Ig awna git kiyapwiye Simawh Pedru. Giwn: ―Uyá amnihun sarayhwa atan amadgat pihmun adahan pis tukuhwa ayteke aynessa. Igme kiyapwiye Simawh Pedru timapni henne, ig sarayhwe muhumdakat ig tukuhwe ayteke. Igme Kiyapwiye Jesus batahkiswe gumadga no umuh. Ig gikannuhtenkis hiyeg ayteke gumadgatak. ");
INSERT INTO plu_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Pisenwa gikannuhakni ig awna git kiyapwiye Simawh Pedru: ―Tarakwanabay ta pawkat. Subuknabay yitagmaya ayge adahan yis kamaxne im. ");
INSERT INTO plu_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Igme kiyapwiye Simawh Pedru kaytwa giwn: ―Kiyapwiye, usuh subukmina hewke tiyegim kuwis. Yuma ukamaxnihusima. Henneme ku pis muwaka, nah ta subukminate utagmaya akiw. ");
INSERT INTO plu_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Igkis subukmine gitagmayakis. Ayge nikwe igkis kamax kaayhsima im. Gitagmayakis kabá sigkebdi awaku im gawini. ");
INSERT INTO plu_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Igkis hiyapni henne, igkis barasa gipemkiyapukis ayta gimkatkis adahan ignesme gayapetnikis. Igkisme danuh atere, igkis kipunse mmuknamte umuh akak im. Egnes umuh kipunpepye akak im. Egkis kabá digise. ");
INSERT INTO plu_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ig kiyapwiye Simawh Pedru hiyapni henne, ig tuguhkiswa mabuw gipetunat Kiyapwiye Jesus. Ig awna git: ―Ayguhwanaba nuwntak, Kiyapwiye, mmanawa nah patehwepye hiyeg. Nah yuma nukiythanisima pitiput. ");
INSERT INTO plu_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ig kaayhsima wakaymni awaku ku samah igkis kamax kaayhsima im. Gihiyegapu hawwata wakaymnibdi. ");
INSERT INTO plu_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Gipemkiyapu amekene Tiyagumni gikak kiyapwiye João ku pariye amekene Zebedew gikamkayupwi, igkis hawwata wakaymni. Ig Kiyapwiye Jesus hiyapni henne, ig awna git kiyapwiye Simawh Pedru: ―Ka muwaka apis. Ku samah pis utí im, han pitatit nah keh pis utí hiyeg ndahan. ");
INSERT INTO plu_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Igkis hiyapni henne, pase igkis danuh ihapkat igkis ikise madikte gewkanbetkis. Igkis tipik wew gikak Kiyapwiye Jesus adahan igkis humewnes gikannuhnipwi. ");
INSERT INTO plu_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ariwnteke ini ku samah ig Kiyapwiye Jesus apitnenete pahá paytwempu, pahapwi awayg ayge ig axpusakare apit busukne pahapwite. Ig hiyá Kiyapwiye Jesus. Ig danuh atere git. Ig mabukwa ta gitiput adahan ig amnihswene git. Ig awna git: ―Kiyapwiye, uyá amnihun. Ku pis muwaka piyihun, pis hiyá numakniwka. ");
INSERT INTO plu_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ig Kiyapwiye Jesus timapni henne, ig sarayh giwak ta gipitit. Ig daxwig atere. Ig awna git: ―Ihi. Nah muwaka. Pis makniw. Aynewa gibuskana miypi. ");
INSERT INTO plu_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ayteke ig Kiyapwiye Jesus awna git: ―Ka ba kinetihwa ta arit hiyeg apigkuya ahin amin ku samah pis makniw. Su atak wadé gimkanit muwpeg. Akkanaba pipit ta git kahadbe ig iwasap ig hiyá ku pis makniw. Ayteke pis keh ofan gidahan Uhokri adahan ig wiwhpiye pipathawni ku samah amekene Moís awna minikwak adahan arekhetni ta gitkis hiyeg ku pis inyerwa makniw. Igme timapni inakni henne, ig tipik. ");
INSERT INTO plu_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Bawkata inakni inetit gimin Kiyapwiye Jesus ibekhewpi muwwapu. Kaayhsima hiyeg pahadguhwa atere git adahan igkis timepnes giwn, adahan ig makniwgikis ariw gikahrikis. ");
INSERT INTO plu_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Kibereput ig higihwa piyawakad ku kiney yumanene hiyeg adahan ig piriyepkewne git Uhokri. ");
INSERT INTO plu_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Apim ini hawkri ig Kiyapwiye Jesus kannuhne hiyeg. Kaayhsima farisewkis gikakkis kannuhekeputnepwi amin amekene Moís gikumadukan igkis batebdebdih ayge ganwa. Igkis pes apititak madikte paytwempu aytontak Galiléyamnawtak, aytontak Judeyamnawtak, aytontak Jerusalémtak. Ig Kiyapwiye Jesus kannuhekne ayge, Uhokri gidatni ay gipit adahan ig piyihekne. ");
INSERT INTO plu_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ayteke awaykemni danuh atere, igkis ayta waxwenes pahapwi awayg miyapupye ta gimkat Kiyapwiye Jesus. Igkis waxwig amadga gisipamna. Igkis ipegpa ahin adahan igkis waxepri atere marihwa igkis dikugisri ta gipetunat Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Henneme igkis ka hiyá igkisma utí ahin awaku ba akebentenwa hiyeg ayge. Igkis hiyapni henne, igkis wagehe ta inut ta amadgat payt ahigwi. Ayge igkis wiwhe apettak payt. Igkis keh pahayku miyokwiye ayge. Pisenwa igkis wiwhkise ner miyapupye agiku miyokwiye peyeke akak gisipamna. Igkis wiwhkiswig ta gibetitkis hiyeg wadé gipetunat Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ig Kiyapwiye Jesus hiyapni henne ku samah gikamaxwankis ta gipitit, ig awna ta git awayg miyapupye. Giwn: ―Nukebyi, nah bayahminap ariw pitaraksan gikak Uhokri. ");
INSERT INTO plu_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Nerras farisewkis gikakkis nerras kannuhekeputnepwi igkis timapni inakni giwn henne, igkis kinetihwa gimin pawtak. Giwnkis: ―Pariyenekig ner awayg? Yuma pahapwinama hiyeg hiyá ubayamnihkawiy ariw utaraksanwiy gikak Uhokri. He ignewa Uhokri hiyá ubayamnihkawiy. Ig ner miyathene Uhokri ku samah ig awna inakni henne. ");
INSERT INTO plu_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ig Kiyapwiye Jesus hiyapni henne ku samah gihiyakemnikis, ig awna ta gitkis: ―Mmahkay yis pukuhpaw nubohri henne? ");
INSERT INTO plu_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Mmah yipewkan ku in mahiko ndahan nah bayahminig ariw gitaraksan? Ku yis hiyá nah hiyá gikankasak nah keh ig wew akiw, ininkata akiw nah ka dat adahan nah bayahminig ariw gitaraksan? ");
INSERT INTO plu_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Nah hiyapkiste yit ku nah ku pariye wageswe awayg amadgaya inin, nahnewa detye amadga inin adahan nah bayahminene hiyeg ariw gitaraksankis gikak Uhokri. Ayteke ig awna ta git ner awayg miyapupye. Giwn: ―Kannikaw. Kidis pisipamna. Hiyawa pis diyuhe pipinwate. ");
INSERT INTO plu_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Aynewa ig awayg kannikaw giwtrikneswa hiyeg. Ig iwé gisipamna ig tipik gipinwate. Ig kibeyhene Uhokri. ");
INSERT INTO plu_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Madikte hiyeg hiyapni henne, igkis wakaymnibdi. Igkis kabayha Uhokri akak madikte gapisnikis. Igkis awna: ―Usuh ka hiyapti akebyi ini. Kabahte usuh ka ihpin. ");
INSERT INTO plu_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ayteke ig Kiyapwiye Jesus pese paytrikutak. Ig waywe apigku ahin, ig hiyá pahapwi ladwan giw Levi, igme betnene agiku payt ahiwket karukri. Ig ahiwne karukri gidahan gupelma. Igme awna git: ―Ba ayta wew nukakhu adahan pis humewne nukannuhni. ");
INSERT INTO plu_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Igme kiyapwiye Levi timapni henne, ig ikise madikte gewkanbet, ig kannikew ig tipik gikak. ");
INSERT INTO plu_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ayteke ariwnteke ini ig kiyapwiye Levi keh axka agiku gipin adahan ig kiyathene Kiyapwiye Jesus. Ayge kaayhsima ladwan gikakkis nawenépwi hiyeg akiw ku pariye ikaka kane kibeynepwima hiyeg igkis ahegiw payak gikakkis. ");
INSERT INTO plu_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Nerras farisewkis gikakkis nerras kannuhekeputnepwi amin amekene Moís gikumadukan igkis hiyapni henne, igkis himehe Kiyapwiye Jesus gikannuhnipwi. Igkis awna gitkis: ―Mmahkay yis axne yis darihwekne gikakkis ladwan gikakkis hiyeg akiw kane kibeynepwima hiyeg? Waké yis kibeynebe hiyeg, yis ka axkam gikakkis gikebyikis nerras hiyeg. ");
INSERT INTO plu_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ig Kiyapwiye Jesus hiyapni henne, ig kaytwa giwnkis. Ig awna ta gitkis: ―Hiyeg kane kibeynepwima ignes kewa hiyeg kakahribdapyebe. Igkis muwaka pahapwi ayta amnihgikis. Ignesme hiyeg makniwyepwi igkis ka muwaka mekseh. Ignesme hiyeg kakahribdapye igkis muwaka mekseh. ");
INSERT INTO plu_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nah ka ayta adahan nah humeknema ku pariye hiyeg kibeynepwi kuwis adahan igkis wageswiyes gihiyakemnikis. Nah ayta adahanikwa nah humekwiye nerras ku pariye taraksapye adahan ignesnewa wageswiyes gihiyakemnikis. ");
INSERT INTO plu_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ayteke hiyeg awna ta git Kiyapwiye Jesus: ―Kiyapwiye João Batista gikannuhnipwi maxhaw adahan igkis kiyenes Uhokri adahan igkis piriyepkewnes. Kibereput igkis maxhaw. Igkisme farisewkis gikannuhnipwi hawwata akiw igkis maxhaw henne. Pisme pikannuhnipwi ka maxhaw henne. Igkis ax takunipti. Mmahki igkis ka kiyatha Uhokri hawwata kema nerrasma? ");
INSERT INTO plu_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Igme Kiyapwiye Jesus kaytwa giwnkis: ―Igkis ka maxhaw adahan nukiyetni mmanawa nah kupiknene ay gikakkis. Nah kehte abektey akak pahapwi awayg maripkewpiye. Ku aysaw ig maripkewpiye, gikagmadapu ayta iwasa gimaripkawni. Ku samah ig ayge gikakkis abet ini fet ba igkis maxhaw? Kawa. ");
INSERT INTO plu_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Henneme aysawnemenek ku aysaw nah iwepka giwkis nukannuhnipwi, apim ini nikwe igkis maxhawnek. ");
INSERT INTO plu_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ayteke ig Kiyapwiye Jesus awna pahat yuwit patuwesbuhka gitkis akiw. Giwn: ―Ka kis adahan wis iw kamisbet ariwntak pahak simis nukune adahan wis kahapa simis mugumugupiye nikak. Ku pahapwi kahapa gisimsa mugumugupiye akak ahap ariwntak gisimsa nukune, nikwe gisimsa nukune mbeye kuwis sigke kuwis. Inme gisimsa mugumugupiye hawwata mbeye mmanawa ahap ariwntak gisimsa nukune ka kis akak gisimsa mugumugupiye. ");
INSERT INTO plu_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kawnata kis adahan wis katiyha win nukune agikut pakir amar ayipwipye ipatmakupye. Mmanawa ku aysaw ini win tukurwa in kiyesihwa akiw, nikwe in pakir amar ka ahwa payak nikak. In bekwe awaku. Ayge ini win dimuke, in pakir amar ka kabay akiw. ");
INSERT INTO plu_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Amawka wis katiyha win nukune ta agikut pakir amar nukune ku pariye mtibetnene. ");
INSERT INTO plu_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Henneme ku pahapwi kuwis higap win ayipwipye, ig ka batek akak win nukune akiw. Ig awna: “Ku pariye ayipwipye in pi kabayte.” Hawwata hiyeg ka batek akak hiyakemniki nukunema. Ignes batek akak hiyakemniki ayipwipye. ");
INSERT INTO plu_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ayteke samdi abet ig Kiyapwiye Jesus tipik mpiye amadgew pahak was gikakkis gikannuhnipwi. Igkisme gikannuhnipwi matise fahhin ariw ayge igkis mariste amar igkis axwig. ");
INSERT INTO plu_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Nerras farisewkis hiyapni henne, igkis awna ta gitkis: ―Mmahkay yis ka iha amekene Moís gikumadukan? Yis kannipwiye abet samdi. ");
INSERT INTO plu_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Igme Kiyapwiye Jesus kaytwa giwnkis: ―Mmah yis kote ipegbohate Uhokri gannasan minikweknene amin ku pariye amekene Davi gikehni? Minikwak ig matipwe payak gikakkis gihaptiyepwi. ");
INSERT INTO plu_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Nikwe ig pareke ta agikut Uhokri Gipin. Ayge ig iwé ini bugut ku pariye ekkepka ta gipetunat Uhokri, ig axwin. Hawwata ig ikepni ta gitkis gihaptiyepwi. Amekene Moís gikumadukan awna ku muwpegnenwa kis adahan igkis axnes ini bugut. Igkisme axni henneme igkis ka taraksa mmanawa ig muwpeg amnihpigkis. ");
INSERT INTO plu_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ayteke ig Kiyapwiye Jesus awna ta gitkis akiw. Giwn: ―Nah ku pariye wageswe awayg amadgaya inin nahnewa samdi akipara. ");
INSERT INTO plu_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ariwnteke ini abet nawenéwa samdi akiw ig Kiyapwiye Jesus lammisya agiku judeyenepwi gileglisakis. Ayge ig kannuhne hiyeg. Pahapwi awayg ayge kidubetwiye giwak kihehaptak. ");
INSERT INTO plu_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Igkisme nerras kannuhekeputnepwi amin amekene Moís gikumadukan gikakkis nerras farisewkis igkis apuriw Kiyapwiye Jesus kabayhtiwa adahan igkis hiyá ba ig piyihak abet samdi. Mmanawa igkis muwaka utí gitaraksan gikak amekene Moís gikumadukan adahan igkis gikamyehpitni. ");
INSERT INTO plu_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Igme Kiyapwiye Jesus hiyak ku pariye abet gihiyakemnikis. Ig hiyapni henne, ig awna ta git ner awayg kidubetwiye giwak. Giwn: ―Kannikaw. Ba ayta idiswa atan. Igme timapni henne, ig kannikew ig idiswe atere. ");
INSERT INTO plu_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ayteke nikwe igme Kiyapwiye Jesus awna ta gitkis hiyeg. Giwn: ―Pariye amekene Moís gikumadukan ayá wotwiy adahan ku pariye wixwiy keh abet samdi? Ba adahan wixwiy kehne kabayka ba kawk, ba adahan wixwiy kehne mbayka? Ba adahan wixwiy amnihne hiyeg ba kawk, ba adahan wixwiy umahkisne hiyeg? ");
INSERT INTO plu_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ig awna inakni, ig ipegpusa madikte hiyeg ayge. Ayteke ig awna ta git ner awayg kidubetwiye giwak. Giwn: ―Taraknaba piwak. Igme tareke giwak. Aynewa giwak makniw. ");
INSERT INTO plu_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Nerras hiyeg gipetunyapu hiyapni henne, igkis kaayhsima dagawne. Gitkis ig taraksepye hiyeg. Nikwe igkis ahegbete ginetnikis pawtak adahan ku samah igkis keh gikak Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ayteke ariwnteke ini ig Kiyapwiye Jesus tipik ta apitit pahá waxri imuwadnene adahan ig piriyepkewne. Hewke tiyegim ig piriyepkewne git Uhokri ayge. ");
INSERT INTO plu_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Hewke akiw ig pahadguhe gikannuhnipwi. Igkisme danuh atere git. Ayge nikwe ig kaniybete gaytakkis madikawku gikebyikis gikakkis piyana gawnakis (12). Ig awna gitkis: ―Kuri yisnewa nuwatnipwi. ");
INSERT INTO plu_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ig kaniy: kiyapwiye Simawh ku pariye ig kuwis sarayh giw Pedru, kiyapwiye Simawh gisamwi kiyapwiye André, amekene Tiyagumni, kiyapwiye João, kiyapwiye Filip, kiyapwiye Bartolomew, ");
INSERT INTO plu_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","kiyapwiye Matews, kiyapwiye Tomé, kiyapwiye Tiyagu, ku pariye amekene Alfew gikamkayh, kiyapwiye Simawh Zeloti, ");
INSERT INTO plu_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","kiyapwiye Judas ku pariye kiyapwiye Tiyagu gisamwi, Judas Iskariyotismin ner kamaykistinene Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Pisenwa igkis muhuke payak gikak Kiyapwiye Jesus. Ig Kiyapwiye Jesus msakwa amun asababan. Kaayhsima gikannuhnipwi ayge ganwa. Ayteke pahabunene hiyeg kabubuknene danuh atere git. Igkis ayta aytontak Judeyamnawtak, aytontak Jerusalémtak, aytontak akigbimnatak parawhokwa ku kiney paytwempu Tiru akak Sidoh. ");
INSERT INTO plu_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Igkis ayta timepne Kiyapwiye Jesus giwn. Igkis ayta adahan ig makniwgikis ariw gikahrikis. Nerras ku pariye kiyimwihpika gapit wapitye igkis hawwata danuh atere. Igme Kiyapwiye Jesus makniwapeprikis. ");
INSERT INTO plu_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Madikte hiyeg ayge mpiksewnekwiye adahan gidaxten mmanawa Uhokri gidatni pes gipititak in keh igkis makniw. ");
INSERT INTO plu_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ayteke ig Kiyapwiye Jesus sarayh gipegyi ta gimkatkis gikannuhnipwi. Ig awna gitkis: ―Kaayhsima kabayka ay yidahannek yis ku pariye ikewnenepwi yumanene yawaygyi yiwnteknewatma. Ayge nikwe yis kawih Uhokri gikumadukannek. ");
INSERT INTO plu_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","―Kaayhsima kabayka ay yidahannek yis ku pariye kayah ku pariye yimawkanitnene giwntak Uhokri kuri akak inin ku samah yis aynete amadga inin. Ayge nikwe ig ikí yitnek madikte ku pariye yis aharit. ―Kaayhsima kabayka ay yidahannek yis ku pariye sukanepwi yikantak gidahan Uhokri kuri akak inin ku samah yis aynete amadga inin. Ayge nikwe yis batekyenek. ");
INSERT INTO plu_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","―Kaayhsima kabayka ay yidahannek ku aysaw hiyeg yamiyhetni apatra ku samah yis nuhiyegapu nah ku pariye wageswe awayg amadgaya inin. Ku aysaw igkis tukuhwe yiw, ku aysaw igkis arewatay, ku aysaw igkis mbayha yiw nupatra, ka sam. Yis utí kaayhsima kabayka nikwe. ");
INSERT INTO plu_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Bateknabay yinaktin apim ini ku aysaw yis hiyepne mbeyne nupatra. Bateknay kaayhsima mmanawa yis utí yitiwni kibeynewanek ayhté inugik. Mmanawa hennewa ignes Uhokri gawnepepu pitatyepwi hiyapkiska mbeyne ta gitkis gapitkis amekenegben. ");
INSERT INTO plu_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","―Henneme, akayih, kaayhsima mbayka ay yidahannek yis ku pariye ikewnepwi yuma arikna muwekne yit ku samah yis aynete amadga inin. Yis ka utí ariknawnama akiw ariw ku pariye yis kuwisnene kadahan. ");
INSERT INTO plu_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","―Akayih. Kaayhsima mbayka ay yidahannek yis ku pariye ka kayah yimawkanitnene giwntak Uhokri kuri akak inin ku samah yis aynete amadga inin. Aysawnemenek yis kayahninek. ―Akayih. Kaayhsima mbayka ay yidahannek yis ku pariye batekyepwi kuri akak inin ku samah yis aynete amadga inin. Aysawnemenek yis ka batek akiw. Yis suka yikantaknek. ");
INSERT INTO plu_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","―Akayih. Kaayhsima mbayka ay yidahannek ku aysaw hiyeg madikte kabayha yiw. Mmanawa hiyeg amadga inin ka hiyak hawkri. Igkis kewa hiyeg amekenegbenbe. Mmanawa igkis amekenegben kabayha giwkis hiyeg ku pariye ikawnamahkis ke wotbe ignes Uhokri gawnepepube bawa ignes ka giwntakma Uhokri. ");
INSERT INTO plu_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","―Yisme ku pariye timepnepwi nuwnhu, amawka ku yihiyakemni nawénewa ariw nerras gihiyakemnikis. Ka ba yi amiyha yipetunyapu henneme bateknabay gikakkis yipetunyapu. Amnihnabay nerras yamiyhetnipwi. ");
INSERT INTO plu_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Kabayhanabay hiyeg ku pariye ibitehepyi. Piriyepkawnabay gidahankis hiyeg ku pariye mahipwihpey. ");
INSERT INTO plu_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ku pahapwi biyuhpokap, pi kabayte pis wages pahambakya adahan ig biyuhpokap pegbakte mpinekata pis dagawne git. Ku pahapwi xuwehe pidagmanpit, ka muwaka kapigsa pisimsa git. ");
INSERT INTO plu_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ku pahapwi makehe arikna pit, ikepniba git. Ku pahapwi xuwehe pewkanbet, ka muwaka puwimahgi adahan ig diyuhkisni pit. ");
INSERT INTO plu_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Amawka yis kabay gikakkis madikte hiyeg hawwata ku samah yis muwaka igkis kabay yikak. ");
INSERT INTO plu_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ku yis amnih nerrasnen ku pariye yamnihten nawenépwime yis ka amnihgikis, mmah yis yipewkan Uhokri kabayhay adahan ini? Kawa. Ig ka kabayhay adahan inima. Mmanawa madikte hiyeg kehni henne. Juktah hiyeg taraksapye amnih hiyeg ku pariye gamnihtenkis. ");
INSERT INTO plu_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Hawwata ku yis keh kabayka gikakkisnen hiyeg ku pariye keh kabayka yikak, nawenépwime yis ka keh kabayka gikakkis, mmah yis yipewkan Uhokri kabayhay adahan ini? Kawa. Ig ka kabayhay adahan inima. Mmanawa madikte hiyeg kuwis kehni henne. Juktah taraksapye keh. ");
INSERT INTO plu_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Hawwata ku yis sunapkis gitkisnen hiyeg ku pariye diyuhkis yiwak gitkisme nawenépwi yis ka sunapkis gitkis mmah yis yipewkan Uhokri kabayhay adahan ini? Kawa. Juktah taraksapye sunapkis ta gitkis hiyeg taraksapye ku pariye diyuhkis giwakkis. ");
INSERT INTO plu_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ka ba yi kehni henne. Bateknabay gikakkis yipetunyapu. Amnihnabay madikte hiyeg. Sunapkisnabay gitkis ka wahá awenyan. Ayge nikwe Uhokri katiwnihyi kabayhtiwanek. Yis humaw Uhokri inugikyene gikamkayupwi awaku yihiyakemni kewa gidahanbe mmanawa ig amnihne hiyeg kane kibeynepwima ku pariye kane kabayhig. ");
INSERT INTO plu_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Amnihnabay hiyeg hawwata ku samah ig Wigwiy amnihpigkis. ");
INSERT INTO plu_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","―Ka ba yi ikiy pahapwi ku ig ka kibeynema. Ayge nikwe Uhokri kawnata ikayi ku yis kawnata kibeynema. Ka ba yi awna gimin pahapwi ku ig ka wadityema. Ayge nikwe ig Uhokri kawnata awna yimin ku yis kawnata wadityema. Bayahminabay hiyeg ariw gitaraksankis yikak. Ayge nikwe ig Uhokri bayahminay ariw yitaraksan hawwata. ");
INSERT INTO plu_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ikinabay ta gitkis hiyeg. Ayge nikwe ig Uhokri ikí yit hawwata. Ig kipunsay akak kabayka mpiynepepye juktah yis ka ikwa adahan amapin akiw. Ig ke wotbe ig kurukwin ig sassahni juktah in hehbetwi. Ku yis ikí kaayhsima gitkis hiyeg, ayge nikwe ig Uhokri diyuhkis yit kaayhsima kabayka akiw. ");
INSERT INTO plu_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ayteke ig Kiyapwiye Jesus awna pahat yuwit patuwesbuhka ta gitkis. Giwn: ―Hiyeg amedgenepwi inin ka hiyak hawkri. Ka ba yi kannuhwa gitkis. Ignes kewa motapyebe abet gihiyakemnikis. Ka ik adahan pahapwi awayg motpiye huwitha giyaki motpiye. Ku ig huwitig, igkis piyamate tuguhenek. ");
INSERT INTO plu_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Kannuhwanay giwntak ignewa Uhokri. Yuma hiyeg pi kannuhte giw gikannuhten. Henneme ku aysaw ig kuwis kannuhwa git, ig matak gikannuhten gihiyakemni. ");
INSERT INTO plu_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Mmahki pis apuriw pikebyi gitaraksan? Pis ke wotbe kiyimwihwa akak pahá iget nopsehsabe ay giwtrik pikebyi. Pisme ka hiyaknima ba pahat ahadma nopsadminnene ay piwtrik. ");
INSERT INTO plu_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ku aysaw pis ka hiyaknima ba ini ahadma ay piwtrik, pis ka hiyá pisma awna ta git pikebyi: “Nukebyi, isaksanate nah wiwh ini iget piwtriktak.” Amun ini pis ikawpari ke wotbe pis kibeynebe hiyeg bawa pis mbayte giw pikebyi. Asá hiyak akak pidahan kit pihiyakemni taraksepye. Ayge nikwe ik adahan pis hiyak akak pikebyi gitaraksan. ");
INSERT INTO plu_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","―Ku uhiyakemni kibeyne, nikwe kabaykanen pes wowntak. Uhiyakemni ke ahbe akat. Ah akat ku pariye kabaynowa ka sarayh guw mbeyepyoma guw. Iné ah akat ku pariye kane kabaynoma ka sarayh guw kabaynopwima guw. ");
INSERT INTO plu_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ku wis hiyá pahakti amutri eg ka sarayh guw kabaynopwima, nikwe in huwewe wot ku eg amutri kane kabaynoma. Ke puduku akatbe ke ipeybe egkis ka sarayh guwkis kabaynopwima kema “figuma” kema “uvama”. ");
INSERT INTO plu_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ke wixwiy hiyegbe. Ku pariye kibeynewa hiyeg iggi ipegminene gihiyakemni adahan kabaykanenwa. Nikwe he kabaykanen pes giwntak. Pahapwime ku pariye mbeyepye hiyeg iggi ipegminene gihiyakemni adahan mbaykanenwa. Nikwe he mbaykanen pes giwntak. Mmanawa ku pariye ay apit uyakni, innewa wis awnin. ");
INSERT INTO plu_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Henneme ku yis awna ku nah yikipara, nikwe amawka ku yis ihpene nuwnhu. ");
INSERT INTO plu_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","―Ku pahapwi hiyeg ayta numkat, ku ig timá nuwnhu, ku ig ihpene nuwnhu, nah akkite yit ku samah ner gihiyakemni. ");
INSERT INTO plu_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ig kewa pahapwi awaygbe mutuhne gipinbe akigbimna warik amadga kayhap. Ig atik ta warikwit juktah ig danuh arit tip. Ayge abetit no tip ig tabirase gipin awaku. Ayteke ariwnteke ini warik digise in huwit ta apitit gipin. Henneme gipin ka hakuh mmanawa awaku mituw kabayhtiwa ta warikwit abet tip. ");
INSERT INTO plu_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Henneme ku pahapwi hiyeg timá nuwnhu, henneme ku ig ka ihpin, iggi kewa pahapwi awaygbe ku pariye ka mutuh gipin awaku mihadima ta warikwit. Ayteke warik digise in huwit ta apitit gipin. Pahaye adahan gipin hakuhe. In mehwe madikte. ");
INSERT INTO plu_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Pisenwa gawnhan ta gitkis ignes hiyeg, ig Kiyapwiye Jesus tipik. Ig danuh atere paytwempu Kafarnawh. ");
INSERT INTO plu_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Pahapwi romayene suwtat gikiparakis ayge ig kadahan pahapwi gibuk gibetki. Ner gibuk kakahrip ig me miyapimet. ");
INSERT INTO plu_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ig timá Kiyapwiye Jesus gak. Ayteke nikwe ig awahkis gaytakkis judeyenepwi giwewkistenkis atere gimin adahan igkisme amnihswa git marihwa ig makniwa gibuk. ");
INSERT INTO plu_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Igkis tipik danuh atere, igkis amnihswe ta git Kiyapwiye Jesus akak madikte giwakemnikis. Igkis awna git: ―Uyá amnih ner suwtat gikiparakis. Ig muwaka adahan pis amnihgi. Ig kibeyne hiyeg. ");
INSERT INTO plu_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ig batek ukakwiy wixwiy hiyeg judeyenepwi. Ig kuwis kehkis pahá payt leglis udahanwiy. ");
INSERT INTO plu_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Igme Kiyapwiye Jesus timapni henne, ig tipik gikakkis. Kennesmin gidawnhan arimkanit gipin, ner suwtat gikiparakis awahkise gikagmadapu atere gimin. Igkisme danuh atere, igkis awna git: ―Kiyapwiye, ner suwtat gikiparakis wasapanaw pimin. Giwn ku ig ka muwaka adahan ig mpithebdih pihawkan. Ig awna ku ig patehwepye hiyeg. Ig yuma gikiythanisima pitiput adahan pis parak gipinekut. ");
INSERT INTO plu_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Iné ig ka kis ayta kinetihwa pikak. Kiyapwiye, ig hiyakni ku pis karayt akipara. Ku pis he awnepi aytontak piyawakad, ikeypi. Gibuk makniwnek. ");
INSERT INTO plu_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ig hiyakni mmanawa ig hawwata ig kakipara. Ig kumaduka nawenépwi suwtat akiw hawwata. Ku ig awna ta git pahapwi: “Su tipik”, igme iha giwn ig tipik. Ku ig awna ta git pahapwiwa akiw: “Ba ayta”, igme iha giwn ig ayta. Ku ig kawatni gibuk, igme hawwata ig iha giwn. Hennewatbaki ig suwtat gikiparakis awna. ");
INSERT INTO plu_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ig Kiyapwiye Jesus timapni inakni giwnkis henne, ig wakaymni kaayhsima. Ig wagestaw, ig awna ta gitkis nerras ku pariye kaneayhsima gihapu butte. Giwn: ―Ner suwtat kane israelyenema ig pi kamaxwate ta nupitit mpiya madikte nukebyupwi israelyenepwi. Nah ka hiyapti pahapwinama israelyene gikamaxwan kema nerma. Ihanabay inakni nuwnhu. Hennewatbaki in. Ayteke ig awna ta gitkis ner suwtat gikiparakis giwatnipwi. Giwn: ―Hiyawa yis diyuhe git. ");
INSERT INTO plu_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ayteke nikwe igkis diyuhe git. Igkis danuh atere gipinekut, igkis uté gibuk makniw kuwis. ");
INSERT INTO plu_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Hewke nikwe ig Kiyapwiye Jesus tipik apitite pahá paytwempu kewye Nayh gikakkis gikannuhnipwi. Kaayhsima hiyeg akiw tipikwiye gihaptikis. ");
INSERT INTO plu_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Igkis danuh atere kennesa anumekut ini paytwempu alappota, ig sarayh gipegyi, ig hiyá pahabune hiyeg. Igkis apuhekwiyepwi. Igkis apuhpiye pahapwi awayg miyapiye. Ig pahapu madankuno gukamkayh, ig pahapwiwatnen. Kaayhsima hiyeg paytwempuyenepwi ayge gukak. Eg tihano kaayhsima. ");
INSERT INTO plu_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ig Kiyapwiye Jesus hiyapni henne, ig kaayhsima ig kayah gudahan. Ig awna gut: ―Ka muwaka tih. ");
INSERT INTO plu_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ayteke ig danukwa kennesa arimkat ner awayg gitiy, ig dax ini gitiy. Igkisme ku pariye gihiyetnipwi igkis msekwe. Ayteke ig Kiyapwiye Jesus awna: ―Awayg, nah awna pit. Kannikaw. ");
INSERT INTO plu_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Aynewa ig awayg kannikew, ig kapusa awna. Ayteke ig Kiyapwiye Jesus ekkepri ta gut ginag. ");
INSERT INTO plu_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Madikte hiyeg hiyapni henne, igkis apisasew. Igkis kibeyhenes Uhokri. Igkis awna: ―Kibeyne. Pahapwi Uhokri gawnepe kuwis kahayak ubetwiy. Kuri Uhokri parak abet uhawkanwiy wixwiy gihiyegapu. ");
INSERT INTO plu_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Aynewa inakni inetit gidahan Kiyapwiye Jesus ibekhewpi muwwapu apuriw Judeyamnaw muwwapu aranwew madikte waxri. ");
INSERT INTO plu_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Apim ini amekene João Batista gikannuhnipwi igkis akki git madikte ku pariye Kiyapwiye Jesus gikehni. Ig amekene João Batista timapni henne, ig humeke piyana gikebyikis gikannuhnipwi ta gimkat. ");
INSERT INTO plu_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Igkisme danuh atere, igme awna gitkis: ―Su iwasa Kiyapwiye Jesus baki ignewatma ner ku pariye nemnikumpiye nuhapuh butte. Ba kawk, ba wixwiy wahap pahapwi nawenéwa ku pariye nemnikumpiye nuhapuh butte akiw? ");
INSERT INTO plu_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Igkisme tipik nikwe, igkis danuh atere git Kiyapwiye Jesus. Igkis awna git: ―Kiyapwiye João Batista awahkise usuh atan pimin, Kiyapwiye. Ig hiyakni ku pahapwi nemnikumpiye gihapu butte. Kame pisnema aytniye? Ba kawk? Ba usuh wahap pahapwi nawenéwa ku pariye nemnikumpiye gihapu butte akiw? Hennewatbaki igkis awna git. ");
INSERT INTO plu_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Abetnewa ini hawkri ku samah igkis ayge ig Kiyapwiye Jesus piyihe kaayhsima hiyeg kakahribdapye, ig mpiyasa gikayhawnikis, ig pekkis wapitye gipititakkis hiyeg, ig keh kaayhsima motapye hiyap. ");
INSERT INTO plu_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Pisenwa ig kaytwa giwnkis: ―Hiyawa yis diyuhe akki git kiyapwiye João Batista ini annut ku pariye yis timap ku pariye yis hiyap ku apim inin. Yis hiyá motapye hiyap, miyapupye wew. Yis hiyá hiyeg axpusakare apit busukne ignes miypit. Yis hiyá mataybapye timap. Yis hiyá miyarapye kannikaw. Yis hiyá hiyeg ku pariye kane hiyak kabayka, ku apim inin ignes ekkepka kabayka gitkis. ");
INSERT INTO plu_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ku pariye hiyeg ka tukuhun ignes utí kabayka nuwntaknek. ");
INSERT INTO plu_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Igkis amekene João Batista giwatnipwi timapni henne, igkis diyuhe gimkat. Igkis tipikanten, ig Kiyapwiye Jesus awna ta gitkis nerras hiyeg kabubuknene ayge. Ig kinetihwa gimin amekene João Batista. Ig awna: ―Yis kuwis atak iwasa kiyapwiye João Batista ta amadgat amatap. Ku samah yis atere, mmahpa yipewkan yis utipri ayge? Mmah yipewkankama ku yis utipri yuma gidatni ke pahat sipapabe ku pariye mtibetnepye ayge? Kawa. Yis hiyakni ku ig ka wagekiswa gimun. ");
INSERT INTO plu_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Mmahpa yipewkan yis utipri ayge? Mmah yipewkankama ku yis utipri akak gisimsa kibeyne mtibete? Kawa. Hiyeg ku pariye kasimsapu mtibete ku pariye igisapye ignes ka msakwa amadga amatap. Igkis msakwa agiku ikiparat gipin barewyewatnene. ");
INSERT INTO plu_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ba yipewkan ku yis utipri Uhokri gawnepe ayge? Hennewa. Ignewa Uhokri gawnepe yis utí. Henneme ig mpiybeta Uhokri gawnepepu pitatyepwi mmanawa ig ekkene ku Uhokri gikumadukan kuwis ahawkanaprik. ");
INSERT INTO plu_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Mmanawa ig kiyapwiye João Batista ignewa ku kamin Uhokri gannasan minikweknene kinetihwa. Inakni gannasan akki wot ku pariye Uhokri awna ta git gikamkayh. Giwn: “Nah awahkiste pahapwi nuwatni papitkiya adahan ig ahegbetene madikte papit.” Hennewatbaki inakni yuwit awna gimin kiyapwiye João Batista. ");
INSERT INTO plu_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yuma pahapwinama awayg waypuka amadga inin kabaytema giw. Henneme pahapwi ku pariye kuwis kawih Uhokri gikumadukan iggi pi kabayte giw kiyapwiye João Batista. Hiyawa ig pahapwi yuma gikiythani giwtrikkis hiyeg amedgenepwi inin henneme ig pi kabayte giw mmanawa ginetni pi kabaytenene akiw. ");
INSERT INTO plu_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Igme kiyapwiye João Batista ginetni kabayhtiwa. Kibeyne, madikte hiyeg ataybiswa git kiyapwiye João Batista, juktah ladwan igkis ataybiswa git. Igkis amere inakni Uhokri gihiyakemni waditnene mmanawa igkis kaywasew ta git kiyapwiye João Batista. ");
INSERT INTO plu_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Igkisme nerras farisewkis gikakkis nerras kannuhekeputnepwi gimin amekene Moís gikumadukan igkis tukuhe ku pariye Uhokri ikiswanaw gidahankis mmanawa igkis ka kaywasaw ta git kiyapwiye João Batista. ");
INSERT INTO plu_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ayteke ig Kiyapwiye Jesus awna akiw. Giwn: ―Mmah nuwnhu kuri adahan nah akki yit ku samah hiyeg gihiyakemnikis amadgayapu inin? Mmahpa gihiyakemnikis? ");
INSERT INTO plu_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Gihiyakemnikis ke bakimnaybe nopsahyumni gihiyakemnikis. Nah akkite yit abektey akak ku bakimnay arehwene ay amadga higiw. Ig Uhokri humaw kewa bakimnaybe ku pariye wakaymni giminkis gidahewektenkis. Igkis bakimnay kabiman gitkis gidahewektenkis. Igkis awna gitkis: “Usuh agighene usuh kayepne yisme ka kaykere ukakhu, yis ka batekkere payak ukakhu. Ayteke nikwe usuh wages warehwan adahan apuhekwiye usuh tihene. Yisme kawnata tihkere payak ukakhu. Mmahki yis ka amepekere uhiyakemni?” Ihanabay inakni nuwnhu. Hennewatbaki ig Uhokri. Hiyeg amedgenepwi inin igkis ka amepekere pahapwinama Uhokri giwatni ku pariye gawahkisni giminkis. ");
INSERT INTO plu_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Mmanawa ig kiyapwiye João Batista danuh atan, ig maxhewne ig ka higap win. Ignesme hiyeg ka amapig. Igkis awna: “Ig wapitye gipit.” ");
INSERT INTO plu_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nahme nah ku pariye wageswe awayg amadgaya inin, nah danuh atan nah ka hennema. Nah ka maxhaw, nah higap win. Kawnata hiyeg amapan. Igkis awna: “Ka ba yis hiyá ner awayg kayhpiye kahigpekepye? Ig gibetki darihwak gikakkis ladwan gikakkis hiyeg kane kibeynepwima akiw. Ig kawnata kibeynema.” ");
INSERT INTO plu_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ka sam igkis awna numinhu henne. Ku pariye hiyeg hiyeknepwi hiyakemniki ignesnewa ka mahikoh Uhokri gihiyakemni ignes amapinnek. ");
INSERT INTO plu_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ayteke ariwnteke ini pahapwi farisew danuh atere. Ig awna git Kiyapwiye Jesus: ―Uyá atak ax nukakhu kuwewanek. Igme Kiyapwiye Jesus ihe giwn. Ig tipik atere gipinekut. Ig danuh atere, ig batahkiswa ahumwa axtet. ");
INSERT INTO plu_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ayge apit ini paytwempu pahapu tino powkemnipyo. Eg timé Kiyapwiye Jesus gak ku ig ayge axne gimun ner farisew. Eg hiyapni henne, eg iwé imihgi agiku pahá atiy kehka tip seyno, eg tipik. Eg danuh atere git Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Eg paberetusaw ta gikimpuit. Eg biyuk gukan, eg suke gukantak ayge. Ig Kiyapwiye Jesus gikugku sabapti awaku no tino gukantak. Ayge eg manpusano gikugku akak gusemnu, eg aympoka gikugku. Ayteke eg imihepni akak ini imihgi. ");
INSERT INTO plu_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ner farisew ku pariye gawnesetni Kiyapwiye Jesus atere ig hiyapni henne, ig awna abetpi gihiyakemni. Giwn: ―Mmahki ig isaksa no tino powkemnipyo daxtig? Waké igyerwa Uhokri gawnepebe, nikwekam ku samah ig hiyapru, ig hiyakkam ku samah guhiyakemni mbeyepye. ");
INSERT INTO plu_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Igme Kiyapwiye Jesus hiyapni henne, ig kaytwa giwn. Ig awna git: ―Kiyapwiye Simawh, nah muwaka akka pit arikna. Igme kaytwa giwn: ―Kiyapwiye, uyá akki nuthu. ");
INSERT INTO plu_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Igme Kiyapwiye Jesus awna git: ―Minikwak piyana awaykemni matiwnih karukri ta git pahapwi awayg. Pahapwi matiwnih pohowku sah (500) karukri git. Pahapwime matiwnih pohowku madikwa (50) karukri git. ");
INSERT INTO plu_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Igkis piyamate yuma ariknawnama adahan igkis diyuhkiswiyes gikakura awenyan. Ig awayg hiyapni henne, ig bayahminigkis ariw gimatiwnihnikis igkis piyamate. Kuri, uyá akki nuthu. Pariye pi batekte gikak ner awayg gaytakkis nerras piyananene gikebyikis? ");
INSERT INTO plu_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Igme kiyapwiye Simawh kaytwa giwn: ―Ke nuthube ner awayg ku pariye gimatiwnihni pi kiyestenene. Igme Kiyapwiye Jesus awna git: ―Hennewa. Piwnapriknawa. ");
INSERT INTO plu_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ayteke ig ipeg gumkat no tino. Ig awna git kiyapwiye Simawh: ―Ba pis hiyá no tino? Ku aysaw nah parak pipinekut pis ka ikí un aynesnima nuthu adahan nah sukuhkugewne. Egme no tino eg sukuhkugan akak gukantak, eg manpuse nukugku akak gusemnu. ");
INSERT INTO plu_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Pisme pis ka aytnihun akak aympokakima. Egme no tino ku samah nah parak atan eg ka matiswa aympoka nukugku. ");
INSERT INTO plu_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Pisme pis ka amapan pipinekut akak ariknawnama ntewharit iné akak iyti. Egme no tino ikí imihgi kaneatiwnisima ta nukugkuprikut. ");
INSERT INTO plu_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nah kuwis bayahminepru ariw kaneayhsima gutaraksan. Inneki keh eg batek nukakhu mpiynepepye. Henneme ku pariye hiyeg bayahminaka ariw aynessawa gitaraksan, iggi batek gikak gibayhamnihten aynessawa. ");
INSERT INTO plu_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ayteke ig awna ta gut no tino. Giwn: ―Nah bayahminap ariw madikte pitaraksan gikak Uhokri. ");
INSERT INTO plu_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Nerras hiyeg ganwayepwi igkis timapni henne, igkis awna gimin ginaktinpinas. Giwnkis: ―Pariyenekig ner hiyeg? Mmahkama juktah utaraksan gikak Uhokri ig bayahminaw ariw? ");
INSERT INTO plu_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Igme awna ta gut no tino: ―Pis isamtaw awaku ku samah pis kamaxwa ta nupitit. Hiyawa pis tipik akak kabayka. ");
INSERT INTO plu_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ayteke ariwnteke ini ig Kiyapwiye Jesus mpiye muwwapu apuriw paytwempu nopsadmin apuriw paytwempu nopsanyupnene akiw. Ayge ig kinetihwene gimin Uhokri gikumadukan. Igkisme giwatnipwi madikawkunene gikebyikis gikakkis piyana gawnakis (12) igkis atak gihapti. ");
INSERT INTO plu_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Tinogben danuhpanos payak gikak hawwata. Egkis hiyeg ku kapititak ig kuwis pekkis wapitye gukakkis hiyeg ku pariye ig makniwe ariw gukahrikis. Pahapu tino ayge gaytakkis ku kapititak minikwak ig pekkis kaayhsima wapityempu, ntewnehker gikebyikis wapitye. Guw Mahi Madalena. ");
INSERT INTO plu_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Hawwata pahapu tino guw Joana gaytakkis. Eg gugihgi kiyapwiye Kuza ku pariye apuriwne amekene Erodis gewkanbet. Hawwata kiyapuno Susana ayge gukakkis kaayhsima nawenópwi tinogben ayge akiw. Egkis ku pariye hiyak gikak Kiyapwiye Jesus gikakkis giwatnipwi, egkis ku pariye katiwnih gimawkanitnenes akak gudahankiswa gukakurakis. ");
INSERT INTO plu_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kaayhsima hiyeg pahadguhwa atere git Kiyapwiye Jesus. Igkis danuhpenes atere git apititak madikte paytwempu. Ig hiyapni henne, ig kinetihwa ta gitkis akak pahat yuwit patuwesbuhka. Giwn: ");
INSERT INTO plu_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Minikwak pahapwi awayg tipik giwasra amedgete adahan ig sessehne gamutra ayak. Ig sessehne gamutra ayak, gaytakkis tuguhe apigku ahin ku kiney wayk adani. Egnes sibuhapepka atere. Hawwata akiw kuhipra ayta axapeprukis. ");
INSERT INTO plu_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Gaytakkisme gamutra ayak tuguhe abetit tipebdi. Egnes hiyenpiwatkama kibentenwa henneme aynewa egkis huruhrup. Mmanawa wayk ka anugbetnama akak un. ");
INSERT INTO plu_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Gaytakkisme gamutra ayak tuguhe apuwit pudukupwi. Egnes pudukupwi hiyenpi payebitak akak gamutra. Egkis tuwathe gamutra juktah egkis miyorap. ");
INSERT INTO plu_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Gaytakkisme gamutra ayak tuguhe abetit kibeyne wayk. Ayge egkis hiyan. Egkis gamutra aymuhwa juktah egkis kew. Egkis sarayh kaayhsima guwkis, sah gukebyikis (100). Pisenwa inakni gawnhan, ig Kiyapwiye Jesus awna akiw. Giwn: ―Yis ku pariye katayebnene, ataybiswanabay numkanit. ");
INSERT INTO plu_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ayteke ariwnteke ini ig Kiyapwiye Jesus gikannuhnipwi igkis ayapri: ―Kaminki pis awna inakni yuwit patuwesbuhka? ");
INSERT INTO plu_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Igme kaytwa giwnkis: ―Hiyeg amedgenepwi inin kote hiyakte ku samah Uhokri gikumadukan. Yisme Uhokri akkamnihni ta yitnek. Igkisme ka akkaka ta gitkis. Ta gitkis nah awna patuwesbuhkanen yuwit. Hiyawa igkis ikí gitewkis nimkanit kabayhtiwa henneme ka paduk ta abetit gihiyakemnikis. Hiyawa igkis ataybiswa nit kabayhtiwa henneme igkis ka pukuhpin. ");
INSERT INTO plu_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","―Kuri nah akkamnihte yit inakni nuwnhu patuwesbuhka gimin ner amutriputne. No amutri ayak egnesbaki arakak gidahan Uhokri giwn. ");
INSERT INTO plu_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Gaytakkis hiyeg kewa inibe ahinbe. Ignes timá nuwnhu ayteke wapitye danuh atere gitkis. Ig wiwhpiye nuwnhu abetitak gihiyakemnikis marihwa igkis ka iha inakni nuwnhu kahadbe igkis ka isamtaw. ");
INSERT INTO plu_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Egnesme no amutri ayak ku pariye tuguhe ta abetit tipebdi egnesbaki arakak gidahankis hiyeg ku pariye timá nuwnhu ignes amapin akak madikte gibetkikis, henneme igkis ka kamax inakni nuwnhu kabayhtiwatma abet gihiyakemnikis. In humaw kewa pahakti amutribe ku pariye yumanano guhampabet eg ka dep miyó. Igkis batek akak nuwnhu adahan aynessa hawkri. Ayteke pase igkis hiyá mbeyne, aynewa igkis miniw ariw nuwnhu. ");
INSERT INTO plu_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Egnesme no amutri ayak ku pariye tuguhe ta abetit pudukupwi, egnesbaki arakak gidahankis hiyeg ku pariye timá Uhokri giwn ignes amapin. Henneme kibeye kibeye igkis pi ikatuswate adahan arikna amadgaya inin. Igkis kinikiswe arit igiska arit batekka amadgaya inin. Ayge nikwe igkis ka kannuhwa keh Uhokri gibetki. Amun ini nikwe igkis humaw waditnepyenen kewa pahakti amutribe ku pariye sarayh guw henneme eg kigise madikte. ");
INSERT INTO plu_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Egnesme no amutri ayak ku pariye tuguhe ta abetit waxri kibeyne waxri egnesbaki arakak gidahankis hiyeg ku pariye timá nuwnhu ignes kamaxni kabayhtiwa. Gihiyakemnikis inyerwa kibeynewa. Igkis ka isahkiswa nuwhu aynesnima. Ayge nikwe igkis keh Uhokri gibetki kabayhtiwa. Amun ini nikwe igkis humaw kewa pahakti amutribe ku pariye kew kabayhtiwa. ");
INSERT INTO plu_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ayteke ig awna gitkis akak pahat yuwit patuwesbuhka akiw. Giwn: ―Nuwnhu kewa pahow lalampbe adahan uguhne hiyeg gihiyakemnikis. Wis ka hakis lalamp adahan wis asabkeptenma anapi suwyeg. Iné wis kawnata hakisru adahan ayempitnima ta anapit payt abukapayni. Kawa. Wis ikigu ta inut akekrit adahan eg uguhno madikte hiyeg ku pariye parekwiye ta upinekut. ");
INSERT INTO plu_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Aysawnemenek madikte ku pariye ayempiki ini kahayaknek. Inakni nuwnhu patuwesbuhka in ke wotbe in awastepkabe henneme aysawnemenek in mawasaptihpikanek, in kahayak kabayhtiwanek. ");
INSERT INTO plu_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ikinay yitew ta nuthu kabayhtiwa. Ku pahapwi darih nuhiyakemni kabayhtiwa, nikwe ig Uhokri akki git pi kiyeste akiw. Henneme ku pahapwi ka darih nuhiyakemni kiyesradima, nikwe ini nuhiyakemni wiwhpikanek abetitak gihiyakemni. ");
INSERT INTO plu_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ayteke ariwnteke ini ig Kiyapwiye Jesus ginag gikakkis gisamwipwi egkis danuh atere. Henneme egkis ka ik adahan danuh kennesnima ta git Kiyapwiye Jesus awaku ba akebentenwa hiyeg ayge. ");
INSERT INTO plu_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Pahapwi hiyeg ayge hiyapni henne, ig awna ta git: ―Kiyapwiye, pinag ay kabaywak gikakkis pisamwipwi. Egkis ayta danuhpanokis pit. ");
INSERT INTO plu_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Igme Kiyapwiye Jesus kaytwa giwn, ig awna gitkis madikte hiyeg ayge. Giwn: ―Ku pariye timepnepwi Uhokri giwn, ku pariye ihpenepwi inakni giwn, egnes nah ikiygukis ke nnaghube, ignesme awaykemni nah ikiygikis ke nukebyupwibe. ");
INSERT INTO plu_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ayteke ariwnteke ini ig Kiyapwiye Jesus katapta ta muhumdakat payak gikakkis gikannuhnipwi. Ig awna gitkis: ―Uyay manuke ta pahambakaytak mahakwa. Igkisme kaytwa giwn: ―Uyay. Igkis tarekwe ayteke. ");
INSERT INTO plu_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Igkis tipikwiyes, ig Kiyapwiye Jesus himeke. Ku aysaw igkis ayhté pakwa amadga mahakwa, pahaye adahan mayg kannikew gimkanitkis. Gihmunkis me buwisemet. Igkis hiyepnes mbeyne kaayhsima. ");
INSERT INTO plu_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Igkis gikannuhnipwi hiyapni henne, igkis atere wadise Kiyapwiye Jesus. Igkis awna git: ―Kiyapwiye. Kiyapwiye. Wixwiy me biyukapmet! Ig timapni henne, ig kannikaw ig himehe mayg akak paraw. Aynewa madikte kariswehwe. Paraw mapawanew. ");
INSERT INTO plu_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Pisenwa ig awna gitkis gikannuhnipwi. Giwn: ―Mmahki yis ka kamaxwa ta gipitit Uhokri? Igkisme apisasew, igkis wakaymnibdi gidahan. Igkis kinetihwa pawtak. Igkis awna: ―Pariyeneki ner hiyeg? Ig kumaduka juktah mayg akak paraw. Juktah mayg akak paraw iha giwn. ");
INSERT INTO plu_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ayteke pisenwa igkis hamah ta pahambakat ariw Galiléyamnaw. Igkis minahwa atere apit hiyeg jerasayenepwi giwaxrikis. ");
INSERT INTO plu_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Igme Kiyapwiye Jesus sarayhwe waxrit. Ayge pahapwi awayg paytwempuyene atere patiptakig. Ig wapityewnipye. Kaayhsima hawkri ig wew makawihan. Ig yuma gipin. Ig msakwa abet imewtinen ayge apuheket. ");
INSERT INTO plu_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Pase ig hiyé Kiyapwiye Jesus, ig kabiman, ig padakwa ta gitiput. Ig awna git akak madikte gihawna. Giwn: ―Aa, Jesus! Pis Uhokri gikamkayh inugikyene. Pariye pimawkan ta nuthu ku apim inin? Uyá amnihun. Ka ba hiyapkis mbeyne nuthu. ");
INSERT INTO plu_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ig awna inakni yuwit henne mmanawa ig Kiyapwiye Jesus kuwis pekkiswiye ner wapitye mbeyepye ayta gipititak. Kaayhsima hawkri kuwis ig wapitye keh ig awayg nuwiskewempiye. Ig awayg wanakminepka inpawa kuwis. Gibagwan akak giwan wanakminepka akak xen akak sipari. Henneme ig matisbetepni madikte. Ayteke ner wapitye keh ig sigis ta abetit imewti. ");
INSERT INTO plu_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ig amnihswene atere git Kiyapwiye Jesus, igme ayapri: ―Mmah piw? Igme kaytwa giwn: ―Nuwhu “Pibohram”. Ig awna inakni yuwit awaku kaayhsima wapityempu ay gipit. ");
INSERT INTO plu_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ayteke nerras wapityempu amnihswa git Kiyapwiye Jesus akiw. Igkis awna git: ―Ka ba arewepma wothu awahkiswima usuh ta arimkat miyarapye giwetrikis. ");
INSERT INTO plu_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ayge pahabunene pakirempu axwenekis apit pahá waxri imuwadnene. Igkis wapityempu hiyapni henne, igkis ayá git Kiyapwiye Jesus: ―Uyá awahkis usuh tahhan gipuritkis pakirempu. Isaksanaba usuh parak atere gipititkis. Igme Kiyapwiye Jesus isakseprikis. ");
INSERT INTO plu_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ayteke nikwe igkis wapityempu pesbetwikis gipititak ner awayg. Igkis pareke ta gipititkis ignes pakirempu. Igkisme pakirempu sigisbetwikis ta asebrikute. Igkis tubohbetwikis ta ahakwate mahakwa. Ayge igkis aniksewbet. ");
INSERT INTO plu_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Pakirempu gikapriwtenkis igkis hiyapni henne, igkis sigisbet kibentenwa ta paytwempuit. Igkis danuh atere, igkis kinetihwa amin muwwapu paytwempuriw muwwapu iwetrit aranwa paytwempu. ");
INSERT INTO plu_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Nerras hiyeg paytwempuyenepwi igkis timapni henne, igkis tipik atere adahan igkis hiyepne ku pariye danuh. Igkis danuh atere git Kiyapwiye Jesus, igkis uté ner awayg ku kapititak wapityempu pesbetwikis. Igme bat ayge gikimpu Kiyapwiye Jesus. Ig kasimsapu kuri. Gihiyakemni diyuh adukwenewa akiw. Igkis hiyapni henne, igkis apisasew. ");
INSERT INTO plu_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Nerras ku pariye hiyepnepwi madikte ku pariye kehka gikak ner awayg igkis kinetihwa ta gitkis nerras hiyeg amin ku samah ig makniw ariw wapityempu. ");
INSERT INTO plu_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Nerras jerasayenepwi timapni henne, igkis madikte ayá git Kiyapwiye Jesus adahan ig tipik ayteke mmanawa igkis apisasew gibohri kaayhsima. Igme Kiyapwiye Jesus hiyapni henne, ig katapte amadgat gihmun adahan ig diyuhpiye ta pahambakat akiw. ");
INSERT INTO plu_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Igme ner awayg ku pariye kuwisnene makniw ariw wapityempu, ig awna git Kiyapwiye Jesus: ―Nah ataka pihapti. Igme Kiyapwiye Jesus awna git: ―Pi kabayte pis msakwa ay. ");
INSERT INTO plu_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Su ataknate ta pipinwat. Kinetihwanaba gitkis pikebyupwi amin madikte ku samah Uhokri keh pikak. Igme awayg timapni henne, ig tipik ta paytwempuit. Ig danuh atere, ig kinetihwa gitkis madikte hiyeg aygnenepwi amin ku samah Kiyapwiye Jesus keh gikak. ");
INSERT INTO plu_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Igme Kiyapwiye Jesus manuke pahambatak mahakwa akiw. Ig danuh atere, ig utí kaayhsima hiyeg pahadgupu adahan igkis patiptakig mmanawa igkis giwhpetni ayge. ");
INSERT INTO plu_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ayteke pahapwi awayg danuh atere. Giw Jayru. Ig pahapwi leglis akipara, judeyenepwi gileglisakis. Ig danuh atere, ig mabukwe ta gitiput Kiyapwiye Jesus, ig awna git: ―Kiyapwiye, uyá amnihun. Uyá atak ta nupinekut. ");
INSERT INTO plu_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Nukamkayh pahapuwa tino. Eg madikawkubu kamukri gaw akak pikana arawna (12). Kuri eg mihenapyo pahayempi guyekwin. Ig Kiyapwiye Jesus timapni henne, ig tipik gihapti. Ig waywe dehebdi akak hiyeg. ");
INSERT INTO plu_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ayge nikwe pahapu tino danuh gihapu butte. Eg kuwis hiyá mbeyne akak guminewkan adahan kaayhsima kamukri kuwis, madikawkubu akebyi akak pikana arawna (12). Yuma hiyeg hiyá gusamanak adahan gumakniwetni. ");
INSERT INTO plu_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Eg danuh atere giharaptak, eg dax gikanwapta akigbimna. Aynewa guminewkan matiswe. ");
INSERT INTO plu_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ayteke nikwe ig Kiyapwiye Jesus awna: ―Pariye daxwen? Madikte gikannuhnipwi wihwebdipkis niw. Ayteke kiyapwiye Pedru awna git: ―Kiyapwiye, ka ba pis hiyá kaayhsima hiyeg daykegbetpi pikak? ");
INSERT INTO plu_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Igme Kiyapwiye Jesus kaytwa giwn: ―Kawa. Pahapwi hiyeg daxwen. Nah kayah ndatni pes aynessa adahan nah makniwa pahapu. ");
INSERT INTO plu_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Eg tino hiyapni henne ku eg hiyekepka kuwis, eg segke, eg mabukwe ta gitiput, eg ekkew ta git. Ayge giwtrikkis ignes hiyeg eg kinetihwa amin ku kawaku eg daxri. Eg kinetihwa amin ku samah eg daxwig aynewa eg makniw. ");
INSERT INTO plu_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Igme Kiyapwiye Jesus awna gut: ―Nukebyi, pis makniw mmanawa pis kamaxwa ta nupitit. Hiyawa pis tipik akak kabayka. ");
INSERT INTO plu_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ku samah ig Kiyapwiye Jesus awnempiye inakni yuwit henne, pahapwi awayg danuh atere. Ig ayta gipinwatak ner leglis akipara. Ig atere ewk inetit git. Giwn: ―Pikamkayh ayipa miyop. Ka muwaka wewkis ukannuhtenwiy waditnepyenen. ");
INSERT INTO plu_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Igme Kiyapwiye Jesus timapni henne, ig awna ta git kiyapwiye Jayru. Giwn: ―Ka muwaka apis. Ku pis he kamaxwanen ta nupitit kuri, eg kannikaw akiwnek. ");
INSERT INTO plu_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ayteke igkis danuh atere gipinekut. Ig Kiyapwiye Jesus ka aympa pahapwinama hiyeg parak atere. Ignewa kiyapwiye Pedru gikakkis amekene Tiyagumni, kiyapwiye João ig aympigkis. Hawwata akiw ig aympa no bakimni gig gukak gunag. ");
INSERT INTO plu_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Madikte hiyeg ayge tihenekwiyes, igkis kadniyes guharit kaayhsima. Ig Kiyapwiye Jesus hiyapni henne, ig awna ta gitkis: ―Ka ba yi muwaka tih. No bakimni ka miyó. Himak eg. ");
INSERT INTO plu_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Igkisme hiyaraptihpig. Igkis hiyakni kabayhtiwa ku eg ayipa gumiromni. ");
INSERT INTO plu_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Igme atere sumuhe guwak. Ig awna gut akak madikte gawaygyi. Giwn: ―Mim, kannikaw. ");
INSERT INTO plu_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ig awna inakni, aynewa ner awnparinene diyuhe ta gupitit. Aynewa eg kannikew. Ayteke nikwe ig Kiyapwiye Jesus awna gutkis adahan egkis ikapkisru. ");
INSERT INTO plu_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Eg gunag gikak gig egkis kagubetkikisima. Henneme ig Kiyapwiye Jesus ayá gutkis adahan egkis ka kinetihwa amin ku pariye ig keh gudahankis. ");
INSERT INTO plu_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ayteke ariwnteke ini ig Kiyapwiye Jesus pahadguhe giwatnipwi madikawkunene gikebyikis gikakkis piyana gawnakis (12). Ayge ig iké gannukis ta gipititkis adahan igkisme makniwnes hiyeg ariw gikahrikis. Hawwata ig iké kumadukaki gitkis adahan igkis pekkiswiyes wapitye gipititakkis hiyeg. ");
INSERT INTO plu_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ig gawahkiswitnikis muwwapu adahan igkis kinetihwenes gimin Uhokri gikumadukan adahan igkis makniwenes hiyeg. ");
INSERT INTO plu_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ig awna ta gitkis: ―Ataknay hennen yiwakyékata. Ka yi muwaka atak akak yasuga, iné akak yisakola adahan yiwewni, iné akak yimana, iné akak yikakura. Yis kawnata muwaka atak akak pikanama yisimsa. ");
INSERT INTO plu_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ku aysaw yis danuh ta apitit pahá paytwempu, msakwanabay pahaygiknene ku kiney yis amapaka he ku aysaw yis pes ayteke paytwemputak. ");
INSERT INTO plu_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ku kit yis danuh, ku hiyeg aygnenepwi ka amapay, nikwe pase yis pes ayteke apititak ini paytwempu, yis sassah yikugku ariw apathawni. Ini arekhetni ku samah gitaraksankis. ");
INSERT INTO plu_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Pisenwa inakni gawnhan, igkisme tipik muwwapu paytwempuriw. Igkis ekkenes Kiyapwiye Jesus ginetni. Igkis makniwenes hiyeg muwwapu. ");
INSERT INTO plu_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Apim ini hawkri ner hiyaptigi amekene Erodis timé arak ini Kiyapwiye Jesus gannu. Ig kaayhsima kiyimwihwa awaku ig ka hiyakri iggi hiyeg. Ig kiyimwihwa awaku gaytakkis hiyeg ikiygi ku ig Kiyapwiye Jesus ig amekene João Batista kannikaw akiw ariw gimiremni. ");
INSERT INTO plu_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Gaytakkisme ikiygi ku ig amekene Eliyas kahayak atan amadga inin akiw. Gaytakkisme ikiygi ku ig pahapwi gaytakkis Uhokri gawnepepu pitatyepwi kannikaw akiw. ");
INSERT INTO plu_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Igme amekene Erodis awna: ―Nahnewa bukihkise amekene João Batistamni gibita. Hiyaksa kuri nah timé Kiyapwiye Jesus gak ku ig kagannusima keh annut. Mmah ka ignewatma amekene João Batistamni? Pariyenekig? Ayge nikwe ig kaayhsima patiptakere gikak Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ig Kiyapwiye Jesus giwatnipwi igkis pisenwa gannipwikis, igkis diyuhe ta gimkanit. Igkis danuh atere, igkis akki git madikte ku pariye gikehnikis. Ayteke ariwnteke ini ig iweprikis adahan igkis tipikwiyes gihapti igkiswonas hampa arimkanit pahá paytwempu kewye Betsayda. ");
INSERT INTO plu_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Henneme pase hiyeg timé gak ku ig kuwis tipik, igkis harakseprikis. Igkis danuh atere, ig amapigkis kabayhtiwa. Ig kinetihwa gitkis gimin Uhokri gikumadukan. Ig makniwe madikte hiyeg ku pariye amnihswenepwi git. ");
INSERT INTO plu_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ayteke ariwnteke ini wahanbuku kamuw, igkis giwatnipwi danukwa atere git. Igkis awna git: ―Kiyapwiye, inin iwetrit yuma hiyeg msekwene ay. Wani nerras hiyeg tipik adahan igkis ipegpa giwetrikis adahan igkis isimwi gimanakis atere. Ik adahan gaytakkis atak ta gitkis was akipara. Gaytakkisme atak tahhan paytwempuit. ");
INSERT INTO plu_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Igme Kiyapwiye Jesus kaytwa giwnkis: ―Kawa. Yisnewa ikí axka ta gitkis apim inin. Igkisme awna git: ―Usuh kadahan pohowkubuwa akebyi bugut akak piyanmowa im masaraku. Amawka usuh tahhan isim kaayhsima akiw adahan in ik gidahankis madikte hiyeg. ");
INSERT INTO plu_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Igkis awna inakni henne mmanawa kaayhsima hiyeg ayge. Awaykemninen pukuhka kabá danuh pohowku mil (5,000) gikebyikis. Igme Kiyapwiye Jesus awna ta gitkis gikannuhnipwi: ―Wani nerras bat adahan igkis ahegwa adahan pohowkutra madikwa (50) gikebyikis. ");
INSERT INTO plu_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Igkisme ihe giwn. Igkis keh madikte hiyeg bat. ");
INSERT INTO plu_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ku aysaw kuwis igkis batebdebdihpikis, ig Kiyapwiye Jesus iwé ini pohowkubunene bugut akak piyananene im. Ig sarayh gipegyi ta inut, ig kabayha Uhokri adahan ini. Ayteke ig sigkabdihapepni, ig ikepni ta gitkis gikannuhnipwi. Igkisme ibekhepni ta gipuriwkis nerras hiyeg. ");
INSERT INTO plu_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ignesme madikte ax kabihribdape. Ka semeweknama gimanakis. Kaayhsima asemne msekwe. Pisenwa nikwe, igkis gikannuhnipwi ahiwapemni, igkis kipunse kaayhsima panye akak asemne gimanakis, madikawku akebyi panye akak pisaya arawna (12). ");
INSERT INTO plu_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Apim inin hawkri ig Kiyapwiye Jesus piriyepkewne ig pahapo. Igkisnewa gikannuhnipi ayge gikak. Ayge ig ayaprikis: ―Pariyeki gipewkankis hiyeg ikanhu nah kuri? ");
INSERT INTO plu_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Igkisme kaytwa giwn: ―Gaytakkis ikapi ku pis amekene João Batistamni. Gaytakkisme ikapi ku pis amekene Eliyas. Igkisme gaytakkis hiyeg ikapi ku pis pahapwi gaytakkis Uhokri gawnepepu pitatyepwi kannikaw akiw. ");
INSERT INTO plu_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Igme Kiyapwiye Jesus timapni henne, ig awna gitkis: ―Ya yis. Mmahpa yis ikanhu kuri? Igme kiyapwiye Pedru kaytwa giwn: ―Pis Cristo, pis Uhokri gikanyan adahan ukumaduketni. ");
INSERT INTO plu_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Igme Kiyapwiye Jesus awna gitkis: ―Hennewa. Henneme ka yi muwaka akka inakni ta gitkis hiyeg. ");
INSERT INTO plu_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ayteke ig awna: ―Nah ku pariye wageswe awayg amadgaya inin amawka ku nah hiyá mbeyne kaayhsimanek ay amadga inin. Aysawnemenek nerras uwewkistenwiy gikakkis nerras muwpeg kiyatyepwi, nerras kannuhekeputnepwi, igkis madikte tukuhptepunnek. Ayteke nah umehpikanek. Henneme amamnam hawkri ariwntak numiremni nah kannikasaka akiwnek. ");
INSERT INTO plu_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ayteke ariwnteke ini ig awna ta gitkis madikte hiyeg. Giwn: ―Ku pahapwi humewkerepye nuhiyega, amawka ku ig ikise gidahan gibetki. Amawka ku ig umahkise gihiyakemni amadgaya inin takunipti ke wotbe ig daddahkiswinbe ta aminat ahbe. Amawka ku ig ikaw hawwata ke nahbe. ");
INSERT INTO plu_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Mmanawa pahapwi ku pariye kiyé gipitnen, iggi biyuknek giw Uhokri adahan apananekwa. Pahapwime ku pariye miyehe gipitwa ndahan, iggi aymuhwanek gimun Uhokri adahan apanenekwa. ");
INSERT INTO plu_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ku pahapwi darih madikte igiska amadgaya inin, henneme ku ig biyuke giw Uhokri, nikwe ini igiska waditnepyenen gidahan. Ku ig kayehwene ayhté abet tiket, ini igiska waditnepyenenwa gidahan. ");
INSERT INTO plu_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Mmanawa aysawnemenek nah ku pariye wageswe awayg amadgaya inin nah aytanek akak madikte nukiythani, gikak Wigwiy gikiythani, gikakkis ahj barewpityepwi gikiythanikis. Apim ini nah marekepwe gikakkis hiyeg ku pariye marekepwepye nukakhu ku pariye marekepwepye akki nuwnhu ta gitkis hiyeg. ");
INSERT INTO plu_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Kennesa gidawnhan Uhokri gikumadukan. Yaytak ku pariye ay ku akak inin, apit yis miyá yis hiyapninek. Ihanabay inakni nuwnhu. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ayteke ariwnteke ini pahay paka, ig Kiyapwiye Jesus iwé kiyapwiye Pedru gikak amekene Tiyagumni, gikak kiyapwiye João adahan igkis tipik gihapti. Ig awna gitkis: ―Uyay ta piriyepkaw. Igkis wagehe apitit pahá waxri imuwadnene. ");
INSERT INTO plu_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Igkis danuh atere, ig Kiyapwiye Jesus kapusa piriyepkaw. Ayge ig uniyehwe gihipak nawenéwa akiw. Gisimsa wageswe barewye tigigihwe. ");
INSERT INTO plu_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ayteke pahaye adahan piyana gikebyikis awaykemni hiyapkiswe atere git. Igkis kinetihwa ayge gikak. Igkis amekene Moís gikak amekene Eliyas. ");
INSERT INTO plu_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Igkis kabutenne. Igkis ayge kinetihwenes gikak Kiyapwiye Jesus amin ku samah gitepkemni amadgatak inin. Igkis kinetihwenes amin ku samah ig umahkiswanek ayhté Jerusalém kahadbe ig keh madikte ku samah Uhokri ikiswanaw gidahan. ");
INSERT INTO plu_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Igkisme Pedru himekbetwikis ayge. Pahaye adahan igkis wadis igkis hiyá Kiyapwiye Jesus gibutni ku samah ig kabutenne. Igkis hiyá nerras piyananene awaykemni tabiwak ayge gikak Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ayteke ignes awaykemni tipikbetwikis giw. Ig kiyapwiye Pedru hiyapni henne, ig awna ta git Kiyapwiye Jesus. Giwn: ―Kiyapwiye, kibeynekata wixwiy ay kabubuk apim inin. Uyay msakwa ay. Usuh kehbetate mpana paytbetanyupwi ay. Paháme pidahan, paháme gidahan kiyapwiye Moís, paháme gidahan kiyapwiye Eliyas. Ig he awnepinen mmanawa ig ka hiyak ku samahpa ig awna. ");
INSERT INTO plu_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ku samah ig awnempiye inakni yuwit henne, pahá ukuhne biyuhe ta gipititkis. Ku samah in awasteprikis, igkis apisasewbdi kaayhsima. ");
INSERT INTO plu_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ayteke pahá ikupimnat awna gitkis aytontak abetitak ini ukuhne. In awna: ―Ner nukamkayh nukanyan. Ataybiswanabay git. ");
INSERT INTO plu_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Pisenwa gitimpankis inakni yuwit, igkis iwasa. Yumehe nerras piyananene gikebyikis. Igwo Kiyapwiye Jesus msekwe ayge gimunkis. Ku samah in danuh gitkis, apim ini igkis ka kinetihwa ta gitkis hiyeg aynesnima nimin. ");
INSERT INTO plu_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Hewke nikwe igkis muhuke apititak ini waxri imuwadnene. Igkis danuh ta amadgat asababan. Igkis uté hiyeg kabubuk patiptakigkis atere. ");
INSERT INTO plu_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ayteke pahapwi hiyeg gaytakkis kabiman ta git Kiyapwiye Jesus. Ig awna git: ―Kiyapwiye, ba ayta amnihun iwasa ndahan nukamkayh ignewa nukamkayh pahapwiwa. ");
INSERT INTO plu_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ig wapityewnipye. Ku samah wapitye parekwig ig kabiman, ig nuwiswig juktah ig kahawyo gibiy. Ig ka kiberema ig isahkisri. Apit gipeswen ig nuwiswig kaahawnasima. ");
INSERT INTO plu_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nah kuwis amnihswe gitkis pikannuhnipwi ay adahan igkis pekkis ner wapitye gipititak henneme igkis ka hiyá asamanak. ");
INSERT INTO plu_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ig Kiyapwiye Jesus timapni henne, ig awna: ―Aa, hiyeg taraksapye amadgayapu inin. Mmahki yis kane kamaxwa aynesnima gipitit Uhokri? Aysaw akebyi hawkri yimawkan nah msakwa ay yikak nah kiyaknihwa yikak juktah yis kamaxwa gipitit Uhokri? Kuri waxwa pikamkayh ayta numkanit. ");
INSERT INTO plu_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ig bakimni kabá danuh atere, igme ner wapitye nuwiswig akiw. Igme bakimni tuguhe ta waygboit kaahawnasima. Ayteke nikwe ig Kiyapwiye Jesus hiyapni henne, ig himehe ner wapitye. Ig pekkiswig. Ig makniwe ner bakimni. Pisenwa ig ekkepri ta giwakuit gig. ");
INSERT INTO plu_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Madikte hiyeg hiyapni henne, igkis wakaymnibdi. Igkis awna: ―Uhokri kagannusima. Ig kagidatnisima. Henneme apiminewa ini hawkri ku samah madikte hiyeg wakaymnibdi gidahan Kiyapwiye Jesus, ig awna gitkis gikannuhnipwi: ");
INSERT INTO plu_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Ataybiswanabay nuthu kabayhtiwa. Aysawnemenek nah ku pariye wageswe awayg amadgaya inin nah kamaykiswikanek ta gitkis hiyeg amadgayapu inin. ");
INSERT INTO plu_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Gikannuhnipwi timá inakni giwn, henneme igkis ka pukuhpin. Gihiyakemnikis sab adahan igkis ka pukuhpin. Igkisme marenpi gibohri adahan igkis ayapri amin ku samah inakni giwn. ");
INSERT INTO plu_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ayteke igkis gikannuhnipwi kapusa mapihpak amin ku pariye gaytakkis pi kiyattenene giwkis. ");
INSERT INTO plu_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ig Kiyapwiye Jesus hiyak ku pariye abet gihiyakemnikis. Ig hiyapni henne, ig iwé pahapwi bakimni. Ig kahgi ig tabirasig ta gihumwat. ");
INSERT INTO plu_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ayteke ig awna gitkis gikannuhnipwi: ―Ku pahapwi amnih pahapwi bakimni kene nerbe ndahan, amun ini nikwe in ke wotbe ig kuwis amnihunbe. Ku pahapwi hiyeg amnihun, amun ini nikwe in ke wotbe ig kuwis amnih ku pariye nawahkisten atan amadgat inin. Mmanawa ku pahapwi yaytak ikaw ke wotbe ig yumahbe gikiythanibe, iggi kiyatye hiyeg giwtrik Uhokri. ");
INSERT INTO plu_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ayteke kiyapwiye João awna git: ―Kiyapwiye, usuh hiyá pahapwi awayg ig pekkis wapitye gipititakkis hiyeg piwaprik. Usuhme awna git: “Ka ba pekkis wapitye giwaprik Kiyapwiye Jesus.” Usuh mpithepri henne awaku ig ka wew pikak kema usuhma. ");
INSERT INTO plu_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Igme Kiyapwiye Jesus kaytwa giwn: ―Ka yi muwaka awna git henne. Mmanawa pahapwi ku pariye ka siguhwi, iggi udahan. ");
INSERT INTO plu_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ariwnteke ini ig Kiyapwiye Jesus gihawkanaprik danuhemet adahan ig iwepka ta inugikut. Ayge nikwe ig ikaw adahanikwa. Ig tipikwiye ta arimkanit paytwempu Jerusalém. ");
INSERT INTO plu_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ig awahkis hiyeg pitati gapitkis adahan ipegpene giwetrikis adahan igkis himekepyes. Igkisme tipik. Igkis danuh apitit pahá paytwempu gidahankis hiyeg samariyenepwi. Igkis ayapaptipwepye gitkis. ");
INSERT INTO plu_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Igkisme ka ikekere iwetrit gitkis awaku igkis hiyakni ku igkis tipikwiye apitit paytwempu Jerusalém. Igkisme hiyapni henne, igkis diyuhe ta git Kiyapwiye Jesus. Igkis danuh atere, igkis awna git: ―Nerras samariyenepwi ka ikekere iwetrit wotwiy. ");
INSERT INTO plu_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Igkisme gikannuhnipwi amekene Tiyagumni gikak kiyapwiye João, igkis timapni henne, igkis awna ta git Kiyapwiye Jesus: ―Kiyapwiye, uyay ayá tiket inugiktak adahan pisenwehe gihawkankis nerras hiyeg. ");
INSERT INTO plu_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Igme wagestaw ta gimkatkis ig awna gitkis: ―Ka yi muwaka awna inakni henne. Yis ka hiyak ku pariye kahiyakemniye yis awna inakni. ");
INSERT INTO plu_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Nah ku pariye wageswe awayg amadgaya inin nah ka ayta adahan pisenwepyema gikakkis hiyeg henneme adahan nah gamnihtenkis. Ayteke nikwe igkis tipik ta apitit nawenéwa paytwempu akiw. ");
INSERT INTO plu_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ayteke ariwnteke ini ku aysaw igkis apigku ahin, pahapwi awayg danuh atere git Kiyapwiye Jesus. Ig awna git: ―Kiyapwiye, nah wewkere pikak ku kitwiye pis. ");
INSERT INTO plu_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Igme Kiyapwiye Jesus kaytwa giwn: ―Ba pis ahegbetnama adahan pis hiyepne mbeyne payak nukakhu? Puwikne kadahan giwetrikis agiku miyokwiye. Kuhipra kadahan guwetrikis apew ah. Nahme ku pariye wageswe awayg amadgaya inin nah yuma nuwetri adahan nah mayekne. ");
INSERT INTO plu_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ayteke ig Kiyapwiye Jesus awna ta git pahapwiwa nawenéwa awayg ayge. Giwn: ―Ba ayta wew nukakhu. Igme awayg kaytwa giwn: ―Kiyapwiye, ik adahan nah atak pihapti henneme gita nighu miyapinate. Ku aysaw ig miyapi nah apuhpig nikwe nah tipik pihapti. ");
INSERT INTO plu_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Igme Kiyapwiye Jesus kaytwa giwn: ―Ka sam pis tipik nuhapti kurinewa. Hiyawa pis isaksa pahapwi ku pariye kuwis ke wotbe ig miyapyebe giw Uhokri, isaksig adahan iggi apuhe giyaki miyapiye. Pisme, pis tipik kinetihwene gimin Uhokri gikumadukan. ");
INSERT INTO plu_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ayteke pahapwiwa akiw awna git: ―Kiyapwiye, nah muwaka wew pikak henneme uyá isaksan adahan nah ekkewe ta gitkis nukebyupwi pitatye. ");
INSERT INTO plu_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Igme Kiyapwiye Jesus kaytwa giwn: ―Ku pahapwi isaksa arikna adahan in mpitebdih giwewni nukakhu, iggi ka kawih gidahan Uhokri gikumadukan. Ig kewa pahapwi awaygbe ku pariye wew han pitatit henneme ig ipegnene gihaprikut butte. ");
INSERT INTO plu_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ayteke ariwnteke ini ig Kiyapwiye Jesus kaniy nawenépwi hiyeg akiw adahan igkis humaw giwatnipwi. Igkis ntewnehker madikwa gikebyikis gikakkis piyana gawnakis (72). Ig gibekheptenkis piyenmempi adahan igkis atak apitit mpuse paytwempu pitati gapit. ");
INSERT INTO plu_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ig awna gitkis: ―Kaayhsima hiyeg kuwis ahegbet adahan igkis kamaxwepyes ta nupitit. Ta nuthu igkis kewa pahak wasbe ipatrik ahegbet adahan tariswiki. Henneme ka kiyesradima hiyeg ekkene nuhiyakemni gitkis ndahan. Piriyepkawnabay ta git Kiyapwiye was akipara adahan ig kawatni hiyeg adahan ignes kinetihwenes gitkis numinhu. ");
INSERT INTO plu_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ataknabay kuri. Nah awahkisyi ta gipuriwkis hiyeg ke wotbe nah awahkiswiyebe muttuh ta gibetitkis axtigibe. ");
INSERT INTO plu_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ka yi muwaka atak akak yikakura iné akak yisakola adahan yiwewni iné akak yikasotni. Tipiknabay waditwi ku kit nah awahkisyi. Ku yis patiptak akak hiyeg apigku ahin, ka yi muwaka kinetihwa gikakkis. ");
INSERT INTO plu_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ku aysaw yis danuhanten ta gipinekut pahapwi hiyegnek, pitatye yis awna gitkis hiyeg aygnenepwi: “Uhokri gabay yikaknek.” ");
INSERT INTO plu_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ku ignes hiyeg amapay kabayhtiwa, hennewa Uhokri gabay msakwa gikakkis. Henneme ku igkis ka amapay, nikwe Uhokri gabay ka msakwa gikakkis. ");
INSERT INTO plu_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ku kiney yis amapaka, ayge yis msakwa pahaygiknene. Axnay, higapnay payak gikakkis. Ka sam yis ax gihamadgakis mmanawa in kis adahan yis utí yimawkanitnene giwntakkis nerras ku pariye yis amnih. ");
INSERT INTO plu_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ku pariye paytwempu yis danuh arit, ku hiyeg aygnenepwi amapay kabayhtiwa, axnay ku pariye ikakka yit. ");
INSERT INTO plu_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Makniwanabay hiyeg ayge ku pariye kakahrapye. Akkanabay gitkis hiyeg ku ahawkanaprik Uhokri gikumadukan kuwis danuh. ");
INSERT INTO plu_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Henneme ku yis danuh arit pahá paytwempu ku kiney hiyeg aygnenepwi ka amapay, nikwe ku samah yis pesanten apigku gahinakis, awnanabay gitkis nerras hiyeg: ");
INSERT INTO plu_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Juktah inin wayk atabdabni ay usuh ka daykiswekere arit aynesnima. Usuh sassah ukugku ariw apathawni adahan arekhetni ku samah yitaraksan. Henneme usuh ikene yinetni ku Uhokri gikumadukan ahawkanaprik kuwis danuh.” Henne yis awna gitkis. ");
INSERT INTO plu_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Aysawnemenek apim ini ku aysaw hiyeg katiwnipwe ta git Uhokri apatra gitaraksankisnek, nerras hiyeg apitya ini paytwempu ignes pi hiyapte mbeyne mpiya nerras hiyeg mbayapye apitya paytwempu Sodoma akak Gomoha. Henneki igkis hiyá mbeynenek. ");
INSERT INTO plu_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ayteke ig Kiyapwiye Jesus kapusa wakaymni gidahankis hiyeg ku pariye ka wageskere gihiyakemnikis. Ig awna: ―Akayih. Kaayhsima mbayka ay yidahannek yis hiyeg paytwempuyenepwi Korazih. Hawwata kaayhsima mbayka ay yidahannek yis paytwempuyenepwi Betsayda. Mmahkay yis ka wageskere yihiyakemni? Waké nah kehbe inwata nannuh ayhté paytwempu Tiru akak Sidoh ku samah nah keh ayge yibet, nikwekam ignes paytwempuyenepwi mbayapye igkis ayipa igkis kayahkam gitaraksankis, ayipa igkis wages gihiyakemnikiskam. Igkis kawihminawkam akak sak kasiwboye igkis padakkam tiket ahewga gitewharitkis adahan arekhetni giwakemnikis. ");
INSERT INTO plu_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Nikwe aysawnemenek apim ini ku aysaw hiyeg katiwnipwe ta git Uhokri apatra gitaraksankisnek, yis pi hiyapte mbeyne giwkis nerras paytwempuyenepwi Tiru akak Sidoh. ");
INSERT INTO plu_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ya yis hiyeg apitya paytwempu Kafarnawh. Yis ikewnenepwi pi apitminte giwkis madikte hiyeg. Henneme yis tukuhpikanek ta warikwit arimkat ini iwetrit ku kiney kaneayhsima kayahwaki. ");
INSERT INTO plu_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Pisenwa inakni giwn, ig Kiyapwiye Jesus awna ta gitkis nerras giwatnipwi: ―Ku pariye hiyeg iha yiwn, amun ini nikwe ignes kuwis iha nuwnhu. Ignesme hiyeg ku pariye ka amapay, amun ini nikwe in ke wotbe igkis ka amapan. Ku pariye hiyeg kane amapan, amun ini ignes kawnata amapa ku pariye nawahkisten atan amadgat inin. Pisenwa inakni gawnhan, igkis giwatnipwi tipikbet. ");
INSERT INTO plu_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ayteke ariwnteke ini igkis giwatnipwi ntewnehkernene madikwa gikebyikis gikakkis piyana gawnakis (72) igkis diyuhe ta git Kiyapwiye Jesus akiw. Igkis batek ginaktinkis kaayhsima. Igkis awna git: ―Kiyapwiye, juktah wapityempu iha wownhu ku aysaw usuh pekkiswigkis piwaprik. ");
INSERT INTO plu_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Igme Kiyapwiye Jesus kaytwa giwnkis: ―Hennewa. Nah kuwis hiyá wapityempu gikiparadkis Satanás, ig tuguhe inugiktak. Ig tuguhe ke ugugunebe. ");
INSERT INTO plu_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Kuri yis hiyak ku samah nah ikí yit kaayhsima kumadukaki. Yis ik adahan yis sibuh kaybune akak akuw. Nah keh yis pi datte giw ner nupetunya Satanás. Ig ka hiyá yisamanak. ");
INSERT INTO plu_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Yis batek awaku ku samah wapitye iha yiwn. Henneme kiskama adahan yis pi batekte adahan ku samah yiw tamakka amadga Uhokri gikagtan ayhté inugik adahan ku samah yis kuwis inugikyenepwi. ");
INSERT INTO plu_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ayteke Uhokri Gitip keh Kiyapwiye Jesus batek ginaktin mpiynepepye. Ig awna nikwe: ―Kibeyne, Nighu. Pis en akipara. Pis waxri akipara. Nah kabayhap awaku ku samah pis ka akki pihiyakemni gitkis hiyeg hiyakemniyepwi. Gitkisme hiyeg ku pariye kene bakimnaybe, yumanene gihiyakemnikis giwntekneswa, pis akki pihiyakemni ta gitkis. Hennewa Nighu, mmanawa innewa pimawkan. ");
INSERT INTO plu_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ayteke ig awna ta gitkis hiyeg ayge. Giwn: ―Nighu kuwis ekke nuthu madikte gihiyakemni. Yuma hiyeg nuhiyekten nah Uhokri gikamkayh. Ignewa Wigwiy igwa pahapa nuhiyekten. Hawwata akiw yuma hiyeg gihiyekten Wigwiy. Nahnewa gikamkayh gihiyekten. Ku karit nah muwaka akkig, ignes hawwata hiyakri. ");
INSERT INTO plu_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ayteke ig wagestaw gimkatkis gikannuhnipwi. Ig awna gitkisyékata: ―Yis kayibunugasima yis hiyá nannuh ku apim inin. ");
INSERT INTO plu_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Minikwak kaayhsima hiyeg Uhokri gawnepepu, kaayhsima hiyeg kiyatyepwi igkis kaayhsima hiyepkere ini nannuh ku pariye yis hiyap ku apim inin. Igkis kaayhsima timepkere inakni nuwnhu ku pariye yis timap ku apim inin. Hennewatbaki igkis. Henneme igkis ka hiyapni, igkis ka timapni. ");
INSERT INTO plu_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ayteke pahapwi kannuhekeputne amin amekene Moís gikumadukan ig kannikaw atere adahan ig gihikekten Kiyapwiye Jesus. Ig awna git: ―Kiyapwiye, pariye nah keh kuri adahan nah aymuhwa gimun Uhokri adahan apanenekwa? ");
INSERT INTO plu_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Igme Kiyapwiye Jesus kaytwa giwn: ―Pariye yuwit tamak amadga amekene Moís gikumadukan adahan ini? Pariye pis hiyap ayge nimadga? ");
INSERT INTO plu_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Igme kaytwa giwn: ―Amekene Moís gikumadukan awna: “Bateknabay gikak Kiyapwiye Uhokri akak madikte yiyakni. Bateknay gikak akak madikte yibetki. Bateknay gikak akak madikte yidatni. Bateknay gikak abet madikte yihiyakemni. Hawwata akiw yis batek gikakkis yiyakipwi hiyeg hawwata ku samah yis batek akak yipit.” ");
INSERT INTO plu_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Igme Kiyapwiye Jesus timapni henne, ig kaytwa giwn: ―Piwnapriknawa. Ku pis keh henne, pis aymuhwa gimun Uhokri adahan apanenekwa. ");
INSERT INTO plu_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Igme ner awayg wihwepye ariw ini ku samah ig ka batek gikakkis madiktema hiyeg. Nikwe ig awna git Kiyapwiye Jesus: ―Pariyepahki nuyakipwi hiyeg adahan nah batek gikakkis? ");
INSERT INTO plu_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Igme Kiyapwiye Jesus kaytwa giwn akak yuwit patuwesbuhka. Giwn: ―Minikwak pahapwi awayg pes apititak paytwempu Jerusalém. Ig tipik muhukwiye ta apitit paytwempu Jerikó. Pahaye adahan amepwapye patiptakig ayge apigku ahin. Igkis wadisasepri igkis wiwhminepri. Igkis kaayhsima biptepri. Ayteke igkis ikiswig harite kabá miyá. ");
INSERT INTO plu_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Nikwenéwa pahapwi muwpeg waywe apigku inwata ahin. Ig danuh atere ku kiney ner awayg haritnene. Ig hiyapni henne, ig mpiye waywe awpre gihumwew. Ig ka amnihgi. ");
INSERT INTO plu_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ayteke ariwnteke ini pahapwi awayg ku pariye gayapetni muwpeg ig danuh atere. Ig hawwata hiyapri ayge. Ig mpiye hawwata waywe awpre gihumwew. Ig kawnata amnihgi. ");
INSERT INTO plu_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ayteke ariwnteke ini pahapwi samariyene tipikwiye hawwata apigku ini ahin. Ig danuh atere gipaknit iggi awayg, ig hiyapni henne ku samah ig biptepka, ig kayah gidahan, ig amnihpig. Hiyeg samariyenepwi amiyhaw pawtak gikakkis hiyeg judeyenepwi henneme ");
INSERT INTO plu_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ig atere git, ig iwepri, ig hapiywota gibuskana akak win akak tipigu. Ayteke ig wanakute gibuskana akak kamis. Pisenwa ig kidiswig ig batahkiswig ta aduhyamadgat gipig kaway. Ig waxwig ta agikut payt danuhpenepwi gipinkis. Ayge ig apuriwgi. ");
INSERT INTO plu_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Hewke akiw ig iw mmukna karukri ig iké ta git payt akipara. Ig awna git: “Uyá amnihun apuriw ndahan ner awayg. Ku pis sarayh mapiy no karukri, kuwewanek ndiyhepninek nah diyuhkis pikakura awenyan.” ");
INSERT INTO plu_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Pisenwa gawnhan inakni yuwit, ig Kiyapwiye Jesus awna ta git ner awayg: ―Kuri nah muwaka pis kaniy. Ku aysaw ner awayg patiptekwika gikakkan gapitkis amepwapye, pariyepahki gaytakkis igkis mpananene awaykemni, pariyepahki gaytakkis kayah gidahan giyaki hiyeg ke gipitbe? ");
INSERT INTO plu_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Igme kaytwa giwn: ―Nernewa ku pariye amnihpig, ignewa kayah gidahan ke gipitbe. Igme Kiyapwiye Jesus awna git: ―Amawka pis keh hawwata ke ignebe. Ku pis hiyá pahapwi piyaki hiyeg arikna muwak git, amawka pis amnihgi. ");
INSERT INTO plu_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ayteke ariwnteke ini igkis Kiyapwiye Jesus tipik ayteke. Igkis danuh ta apitit pahá paytwempu. Ayge pahapu tino kewyo Marta eg amapa Kiyapwiye Jesus adahan ig msakwa ta gupinekut. ");
INSERT INTO plu_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Eg kadahan gusamru pahapu tino kewyo Mahi. Egme Mahi bat gipetun Kiyapwiye Jesus adahan eg timapno giwn. ");
INSERT INTO plu_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Egme Marta eg wagewgeswano egwa pahapo. Eg hiyapni henne, eg sigise gimin Kiyapwiye Jesus eg awna git: ―Kiyapwiye, uyá amnihun awahkis nusamru adahan eg ayapan wagewgeswano ay. Eg ikiswen nah pahapo adahan nah keh madikte inin annipwit. ");
INSERT INTO plu_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Igme Kiyapwiye Jesus kaytwa guwn: ―Marta, Marta. Pis ikene pitew adahan arakembet annipwit. Pis kiyimwihwa nikak. ");
INSERT INTO plu_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Henneme pahat arikna ay pi kabayte adahan wis keh. Eg Mahi kuwis kaniy ini ku pariye pi kabaytenene adahan eg keh. Eg timapno nuwnhu. Nah ka miniwkisru niw. ");
INSERT INTO plu_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Apim ini hawkri ig Kiyapwiye Jesus piriyepkewne amun pahá iwetrit. Pisenwa gipigyepkawni, pahapwi gaytakkis gikannuhnipwi ayá git: ―Kiyapwiye, uyá kannuh usuh piriyepkaw ku samah amekene João Batistamni, ig kannuh gikannuhnipwi piriyepkaw. ");
INSERT INTO plu_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Igme kaytwa giwnkis: ―Ku aysaw yis piriyepkaw, awnanay han: “Wighu, usuh kabayhap. Pis kapikiythanisima. Usuh kaayhsima muwaka pikumadukan danuh atan amadgat inin. ");
INSERT INTO plu_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Iknaba wothu umana takunipti. ");
INSERT INTO plu_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Bayahminaba usuh ariw utaraksan mmanawa usuh hawwata bayahmina hiyeg ku pariye taraksapye ukakhu. Iknaba wothu wawaygyi adahan usuh ka isaksewpima arit mbayka.” Hennebaki yis piriyepkaw. ");
INSERT INTO plu_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","―Amawka ku yis ka miniw ariw yipigyepkawni. Nah akkite abektey yit akak ku pahapwi yaytak makehpene bugut ta git gikagmada. Ig atere git pakwak mtipka, ig ayá git: “Nukebyi, nah ayta sunepne mpana bugut pit ");
INSERT INTO plu_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","mmanawa pahapwi nukagmada danuhpene nuthu nah yuma ariknawnama ay numunhu adahan nukan git.” ");
INSERT INTO plu_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Igme ner gikagmada ig timapni henne, ig kaytwa giwn agikutak gipin. Ig awna git: “Kuri nupewkan ka ik. Mmanawa lappot kuwis sabuke. Kuwis nah mayeke payak akak madikte nukamkayupwi. Nah ka hiyá nahma kannikaw adahan nah ikene pit.” ");
INSERT INTO plu_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Igme, ig ipeg gipitit gikagmada. Ig ka miniw ariw gayapni git juktah igme gikagmada kannikaw adahan ig ikene git. Hennewatbaki in. Ka innema ku samah ig gikagmadama innema keh ig ikepni git, henneme ig ikepni git awaku ku samah ig ka miniw ariw gayapni git. Ig ikí git madikte ku pariye gayapni git. ");
INSERT INTO plu_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Apanenekwa ayepnenekwa kabayka ta git Uhokri. Igme ikí yit ku pariye yayapni git. Ku ig ka ikí yit nikwenéwatma apim ini, ka sam. Ikawnay kewa pahapwibe ku pariye ipegpene arikna juktah ig utipni. Ayge nikwe yis utinek ku pariye yimawkan. Ikawnay kewa pahapwibe ku pariye tetesnene anumeku pahapwi gilappota juktah igme woka ta git. Ayge nikwe ig Uhokri kaytwa yiwnnek. ");
INSERT INTO plu_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Mmanawa ku wis ayá kabayka git, ikaka wotnek. Ku wis ipegpene ku pariye umawkan git, wis utipninek. Ku wis awna git, ig kaytwa wownnek. ");
INSERT INTO plu_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ig ka kiniswi. Nah kehte abektey. Yis igti, ku pahapwi yikamkayh ayá im yit, yis ka ikí kaybunema git. Yuma pahapwinama awayg kinis gikamkayh henne. ");
INSERT INTO plu_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Hawwata akiw, ku yikamkayh ayá antyan yit, yis kawnata ikí akuwma git. ");
INSERT INTO plu_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ku hiyá yis taraksapye ikí kibeyne arikna gitkis yikamkayupwi, igkata akiw Wigwiy inugikyene? Ig ikí kibeynewa gikan wotwiy. Juktah ig ikí Gitip ta gipititkis ku pariye hiyeg ayá Gitip git. ");
INSERT INTO plu_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Apim ini hawkri ig Kiyapwiye Jesus pekkis pahapwi wapitye ku pariye keh pahapwi awayg monpi. Pase ig wapitye pes ayteke gipititak ner awayg, ig awayg kapusaw awna. Nerras hiyeg kabubuknene ayge igkis hiyapni henne, igkis wakaymnibdi kaayhsima. ");
INSERT INTO plu_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Gaytakkisme awna: ―Ig pekkis ner wapitye gipititak ner awayg akak wapitye gikiparadkis gannu ay gipit. Igwa Belzebu ay gipit. ");
INSERT INTO plu_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Gaytakkisme hiyeg gihikekten Kiyapwiye Jesus. Igkis kehkis git annut inugiktekne adahan arekhetni gidatni gitkis kahadbe igkis hiyakri ba ig ayta giwntakwatma Uhokri. ");
INSERT INTO plu_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Igme Kiyapwiye Jesus hiyak ku pariye abet gihiyakemnikis. Nikwe ig awna gitkis: ―Ku hiyeg apitya pahanene waxri ku igkisweke kerbetpikis, igkis madikekenek. Pakebyekne hawwata, ku igkisweke kerbetpikis, igkis hawwata madikekenek. ");
INSERT INTO plu_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Wapitye hawwata. Waké ig Satanás pekkis gihiyegapu wapitye gipititakkis hiyeg, amun ini nikwe gikakwakam ig kerye. Waké ig keh hennebe, ig pisenwakam akak gikumadukan. Mmah nikwe yis awna numinhu ku nah pekkis wapitye gikak Belzebu gannu ay nupithu? ");
INSERT INTO plu_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ya yis yikannuhnipwi? Igkis hawwata pekkis wapitye gipititakkis hiyeg. Pariye ikí gidahankis gannukis? Waké nah pekkis wapitye gikak Belzebu gannube, nikwekam ignes yikannuhnipwi hawwatakam. Igkisnewa arakak ku yis ka awna wadit. ");
INSERT INTO plu_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ka ba yis hiyaknima ku nah pekkis wapitye gipititakkis hiyeg akak Uhokri gannu ay nupithu? Inineki arakak ku Uhokri gikumadukan kuwis danuh. ");
INSERT INTO plu_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ig wapitye gikiparadkis ig kewa pahapwi awayg detyebe ku pariye apuriw gipin akak madikte giyakok. Ayge nikwe ka ik adahan wis atere kidis gewkanbet. ");
INSERT INTO plu_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Henneme ku pahapwi pi datte patipteke gikak atere, iggi wanegbete gihawkan, ig xuwehe giyakok giw ku kapitit ig ipeg. Ayteke ig kidise gewkanbet ku pariye ay gimun, ig tipik nikak, ig ibekhepni ta gipuriwkis gidahewektenpu. Hennewa nah wanegbete gihawkan ig wapitye gikiparadkis. Inneki keh nah detye adahan nah pekkis gihiyegapu gipititakkis hiyeg. ");
INSERT INTO plu_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","―Mmahpaki yipewkan yis ka amapan? Ku pahapwi ka amapan, amun ini nikwe ig kuwis kapetunsepun. Ku pahapwi ka darihwak nukakhu, amun ini nikwe ig kuwis siguhpen. Ka ik adahan yis msakwa hennenwatma. ");
INSERT INTO plu_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","―Yis kewa pahapwi awaygbe ku pariye wapitye pes gipititak. Ig wapitye pes, ig wewpari ku kiney yumanene un. Ig ipegpene pahayku mayekket henneme ig ka utí. Ig hiyapni henne, ig awna gitwa: “Nah diyuhpite ta nupinwat, ta gipitit ner awayg ku kitak nah pes.” ");
INSERT INTO plu_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ig tipik. Ig danuh atere, ig utí gipin miyakegik, barewagik, ahegbet adahan pahapwi parak atere. ");
INSERT INTO plu_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ig hiyapni henne, ig tipik, ig iwé ntewnehker gikebyikis wapityempu akiw ku pariye pi mbayte gihiyakemnikis giw. Ayteke nikwe igkis diyuh atere msakwa ayge gipit ner awayg. Nikwe ner awayg giwskawni pi mbayte ariw pitatye. ");
INSERT INTO plu_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ig Kiyapwiye Jesus awna inakni yuwit, pahapu tino ayge gibetkis nerras hiyeg kabubuknene ayge eg kabayhig akak madikte gawaygyi. Eg awna git: ―No ku pariye pisayrhetni amadgat wayk, eg pisukkisten, eggu kaayhsima gubunuga. ");
INSERT INTO plu_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Igme kaytwa guwn: ―Pi kabayte wis awna: “Ku pariye hiyeg timepnepwi Uhokri giwn, ihpenepwi Uhokri giwn ignesnewa kaayhsima gibunugakis.” ");
INSERT INTO plu_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ayteke kaayhsima hiyeg akiw danuh atere git Kiyapwiye Jesus. Igkis kabubuk ganwa. Ayteke nikwe ig awna gitkis: ―Aa, yis hiyeg amadgayapu hawkri. Yis mbeyepye yihiyakemni. Inneki keh yis kehkis annut nuthu adahan arekhetni ndatni yit. Pahatwowa annut akkaka yitnek, ini annut ke Uhokri gawnepebe amekene Jonas gannu. ");
INSERT INTO plu_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Minikwak ku samah ig amekene Jonas wiwhpika abetitak miyaka, in humaw arekhetni gitkis nerras hiyeg apitnenepwi paytwempu Nínive ku ig inyerwa ekkene Uhokri giwn. Nah ku pariye wageswe awayg amadgaya inin, nah hawwata. Ku aysaw nah wiwhpika abetitak miyaka in humaw arekhetninek gitkis hiyeg ku akak inin ku nah inyerwa ekkene Uhokri giwn. ");
INSERT INTO plu_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Aysawnemenek ku aysaw Uhokri gihiypetnikis hiyeg ba ignes wadityewatma, kaayhsima hiyeg ayge hiyekepyi ku yis mbeyepye yihiyakemni. Apim ini no tino ku pariye gikiparakis amekenegben tiwgikyenepwi eggu hiyekepyinek ay gipetun Uhokri ku yis mbeyepye yihiyakemni. Eg kane Uhokriyanma eg msakwa piyawakad, hiyaksa eg ayta atan adahan timapno amekene Salomawh giwn awaku ig kagihiyakemnisima. Yisme ka timapkere nuwnhu. Hiyawa nah pi hiyakemnite giw amekene Salomawh, henneme yis ka timepkere nuwnhu. ");
INSERT INTO plu_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Hawwata akiw nerras hiyeg apitya paytwempu Nínive igkis hawwata hiyekepyinek ayge gipetun Uhokri ku yis mbeyepye yihiyakemni. Mmanawa minikwak igkis ihe amekene Jonas giwn, igkis wagese gihiyakemnikis. Yisme ka iha nuwnhu. Hiyawa nah pi kiyatte giw amekene Jonas, henneme yis ka iha nuwnhu. ");
INSERT INTO plu_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","―Wis ka hakis abukri adahan ayempitnima. Wis ka hakisru adahan wis asabkeptenma anapi suwyeg. Kawa. Wis ikigu ta inut akekrit adahan eg uguhno madikte hiyeg ku pariye parekwiyes agikut payt. Uhiyakemni hawwata. ");
INSERT INTO plu_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Wowtyak kewa pahá abukribe adahan upit. Ku wowtyak makniw, nikwe in ke wotbe upit ay abet kabutnikibe. Uhiyakemni hawwata. Ku in makniw, ayge nikwe in ke wotbe uhiyakemni ay abet kabutnikibe. Hawwata akiw ku wowtyak ka makniwnama, nikwe in ke wotbe upit ay abet amisnapyibe. Uhiyakemni hawwata. Ku in patehwepye, ayge nikwe in ke wotbe in ay abet amisnapyibe. ");
INSERT INTO plu_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Apuriwnabay yihiyakemni nikwe adahan yis ka ipegminenema yihiyakemni amin ini msanpiki patehwepye amadgaya inin. ");
INSERT INTO plu_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ku kabutnikinen ay upit, ku yuma patahwaki aynesnima ay abet uhiyakemni, ayge nikwe madikte uhawkan kabutenne wis hiyak huwewe ku pariye inyerwatnene ke wotbe pahapwi uguhnebe akak abukri apigku ahin pitati wapit. ");
INSERT INTO plu_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ig Kiyapwiye Jesus kannuhekne ayge, pahapwi farisew danuh atere git. Ig awna git: ―Uyá atak ax nukakhu. Igme Kiyapwiye Jesus ihe giwn. Ig tipik gihapti ta gipinekut. Ig danuh atere, ig batahkiswa ahumwa axtet. ");
INSERT INTO plu_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ig farisew wakaymni gidahan ku samah apit ig ax ig ka sukokaw kabayhtiwatma ku samah amekenegben sukokaw adahan ignes barewpitye giwtrik Uhokri iné ig kawnata sukuheku gigobla iné ig kawnata sukohapa gimewkan adahan in barewagikape giwtrik Uhokri. ");
INSERT INTO plu_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ig Kiyapwiye Jesus hiyá ku samah ig wakaymni henne, ig awna git: ―Yis farisewkis yis barewagikape yigobla akak yimewkan. Ku pariye awkinenewa yipitiw ini yis barewha. Abetme yihiyakemni yis patahwapye. Yihiyakemni kipun akak amepwiki akak mbeyepye hiyakemniki. ");
INSERT INTO plu_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Yis yuma yihiyakemni. Ka ba yis hiyá ku Uhokri ku pariye keh upitwiy ig hawwata keh uhiyakemniwiy? ");
INSERT INTO plu_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Waké yis ikibe yihiyakemni ta git Uhokri, waké yis amnihbe hiyeg yis kakanhawbe gitkis amadgatak yimewkan, nikwekam madikte yewkanbet barewagikapnekam giwtrik Uhokri. ");
INSERT INTO plu_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","―Akayih. Aysawnemenek yis farisewkis yis hiyá mbeyne kaayhsimanek. Yis keh ofan gidahan Uhokri ariwntak madikte yamutra juktah madikte nopsanyupwinene yamutrebdi. Yis wiwh pahakti ariwntak mpuse gaytakkis madikawku adahan yis kakanhaw git Uhokri. Henneme yis ka keh wadit gikakkis yiyakipwi hiyeg. Yis yumahwa Uhokri gamnihra ay apit yiyakni. In kabay yis keh ofan gidahan Uhokri henneme kiskama yis wew akak inakni gihiyakemni madikte. ");
INSERT INTO plu_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","―Akayih. Aysawnemenek yis farisewkis yis hiyá mbeyne kaayhsimanek apatra ku samah yis batek bat amadga epti pi kiyattenene agiku leglis. Yis batek hiyeg aytnihyi higiwmadga akak kiyathaki. ");
INSERT INTO plu_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","―Akayih. Yis hiyá mbeyne kaayhsimanek apatra ku samah yis kewa imewtibe ku pariye kane hiyakka, hiyeg wew nipitiw ignes ka hiyak ba miykahriki ayge agiku. Ku aysaw hiyeg kinetihwa yikak, igkis patahwa akak yihiyakemni igkis ka hiyaknima ku samah. ");
INSERT INTO plu_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Pahapwi gaytakkis nerras kannuhekeputnepwi amin amekene Moís gikumadukan, ig timapni inakni yuwit henne, ig awna ta git Kiyapwiye Jesus: ―Kiyapwiye, ku aysaw pis awna giminkis farisewkis henne, amun ini pis mahipwihwata usuh kannuhekeputnepwi amin amekene Moís gikumadukan. ");
INSERT INTO plu_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Igme kaytwa giwn: ―Akayih. Yis kannuhekeputnepwi yis hawwata hiyá mbeyne kaayhsimanek apatra ku samah yis mpiksaptih hiyeg adahan ignes iha kumadukaki ku pariye mahikonene adahan ignes iha, yisme ka ihpin aynesnima. Yis ikaw ke pahapwibe ku pariye mpiksaptih gikebyi adahan ig hiyuh awiyka henneme igwa ka hiyuhkere ini awiyka, iné ig ka daxkerepni akak pahatnama giwak. ");
INSERT INTO plu_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","―Akayih. Aysawnemenek yis hiyá mbeyne kaayhsimanek. Yis keh barewye payt adahan gimewkis Uhokri gawnepepu pitatyepwi, nerras gawnepepu ku pariye igkisnewa yahawkripwi umehe. Yis ikaw ke wotbe yis kadniye giharitkisbe. ");
INSERT INTO plu_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Bawa nuthu ku samah yis barewha gimewkis ini arakak ku yis amapa ku samah yahawkripwi umehpigkis. Igkisme umehpigkis, yisme barewha gimewkis. Yihiyakemni hawwata ke igkisbe yahawkripwibe. ");
INSERT INTO plu_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Inneki keh ig Uhokri awna: “Nah awahkis nawenépwi nawnepepu akiw nah awahkis nawenépwi nuwatnipwi akiw atere giminkis nuhiyegapu. Gaytakkis umehpikanek. Gaytakkisme hiyapkiska mbeyne gitkis.” Ig awna inakni akak madikte gihiyakemni. ");
INSERT INTO plu_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Nikwe ig Uhokri diyuhkis gimigkisnek nerras gawnepepu madikte ku pariye umehpika ku samah akapuska hawkri. Ig diyuhkis gimigkis ta yipititnek yis ku pariye amedgenepwi hawkri ku akak inin. ");
INSERT INTO plu_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ig diyuhkis ta yipititnek gimigkis madikte gawnepepu giwenketeke amekene Abew gimig he danuhe git amekene Zakaríyas gimig, ner ku pariye umehpika ayegbi kakanhewket akak Uhokri Gipin. Hennewa ta yipititwa ig diyuhkis gimigkis. ");
INSERT INTO plu_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","―Akayih. Yis kannuhekeputnepwi, yis hiyá mbeyne kaayhsimanek. Yis hiyapkiska yitnek apatra ku samah yis kannuhwa gimin Uhokri giwn, yis ik adahan yis wokase Uhokri gihiyakemni ta gitkis hiyeg henneme yis sabukwin giwkis. Yis ka ihpin iné yis kawnata isaksa nawenépwima hiyeg adahan ignes ihpin. ");
INSERT INTO plu_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Pisenwa inakni giwn ig Kiyapwiye Jesus tipik. Ig pesanten ayteke, nerras kannuhekeputnepwi gikakkis nerras farisewkis igkis kaayhsima dagawne git. Han pitatit igkis gihikekten akak ayapka ");
INSERT INTO plu_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","adahan igkis hiyá ba igkis keh ig awna yuwit taraksebet adahan igkis gimetkepten. ");
INSERT INTO plu_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Apim ini hawkri kaayhsima hiyeg pahadguhwa atere git Kiyapwiye Jesus. Igkis hiyeg kabubuk ayge daykegbet. Apit ig kinetihwa gitkis, ig awna ta gitkis kit gikannuhnipwi. Giwn: ―Nerras farisewkis ikewnepwi ke wotbe ignes kibeynepwibe hiyeg bawa mbeye hiyakemniki ay gimunkis. Gihiyakemnikis amebyemni kewa bugut abusanbe. Pitatye in ka kahayak henneme kuwewanek in kahayak ku in ayge abet bugut. Pukuhpawnabay adahan yis ka ikaw kema igkisma. ");
INSERT INTO plu_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ka ik adahan wis ayam uhiyakemni amebyemni. Aysawnemenek in kahayaknek. Madikte ku pariye awastepka aysawnemenek in mawasaptihpikanek. ");
INSERT INTO plu_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Madikte yuwit ku pariye yis awna ayamaw ku pariye yis awna kabayanesa agiku mutkeg, aysawnemenek ini ekkepkanek gipuriwkis hiyeg akak madikte nihawna. ");
INSERT INTO plu_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","―Ka yi muwaka apis gibohrikis hiyeg ku pariye wowmeptenwiy henneme ariwntak ini igkis ka hiyá usamanakwiy akiw. Hennewatbaki in, nukagmadapu. ");
INSERT INTO plu_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nah akkite yit ku kabohri yis apis. Apisnay gibohri Uhokri ku pariye ka inenwatma hiyá wowmhakwiy henneme ariwntak ini ig ik adahan ig sarayhpewiy ta apit ini iwetrit ku kiney kaneayhsima kayahwaki. Apisnay gibohri iggi. ");
INSERT INTO plu_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ig hiyá wowmhakwiy, ig hawwata hiyá ukapriwkay. Ka ba yis hiyá ku samah ig apuriw madikte kuhipra? Egkis ka ariknawnama egkis piyukka pohowku gukebyikis adahan mmuknamawa kirehka. Henneme Uhokri ka miyeh adahan ig apuriwgukis. ");
INSERT INTO plu_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ku yis hiyá ig apuriw kuhipra, wixwiykata akiw ig ka hiyá ukapriwkay hawwata akiw? Yuma aynesnima ig ka hiyakma. Juktah usemnuwiy ig kuwis pukuh madikte. Ka yi muwaka apis. Wixwiy pi kapigte git Uhokri mpiy madikte kuhipra. Ig apuriwwiy hawwata. ");
INSERT INTO plu_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","―Ku pahapwi keh temwe ndahan ta gitkis hiyeg ay amadga inin, aysawnemenek nah ku pariye wageswe awayg amadgaya inin nah hawwata keh temwe gidahannek. Hennewatbaki nah keh temwe gidahan ayhté inugik ta gitkis Uhokri giwatnipwi ahj. ");
INSERT INTO plu_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Henneme ku pahapwi wihwe nuwhu ay gimunkis hiyeg amedgenepwi inin, nah hawwata aysawnemenek nah wihwe giwnek ayhté inugik gimunkis Uhokri giwatnipwi ahj. ");
INSERT INTO plu_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","―Ku pahapwi ka kiyathan nah ku pariye wageswe awayg amadgaya inin, ka sam. Nawenétke kuwewanek ig Uhokri Gitip dax apit giyakni adahan ig kiyathan. Ayge nikwe ik adahan Uhokri bayahminig ariw ini gitaraksan ku samah pitatye ig ka kiyathan. Henneme ku pahapwi ka kiyatha Uhokri Gitip, nikwe ka ik adahan ig Gitip dax apit giyakni adahan ig wages gihiyakemni. Ayge nikwe kawnata ik adahan ig Uhokri bayahminig ariw ini gitaraksan. ");
INSERT INTO plu_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","―Aysawnemenek yis kamiyepkanek abet pahadguhka agiku leglis. Hawwata akiw yis kamiyepkanek ta gitkis hiyaptigi ta gitkis yikiparapu. Yis waxepka ta gipetunatkis apatra ku samah yis nuhiyegapu. Ku aysaw yis kamiyepka henne, ka yi muwaka ipegmina yihiyakemni adahan ku pariye yis awna gitkis apim ini hawkri. ");
INSERT INTO plu_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Mmanawa apiminewa ini ig Uhokri Gitip ikí yit yuwit adahan yis awna gitkis apim ini. ");
INSERT INTO plu_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ayteke pahapwi awayg ayge ig awna git Kiyapwiye Jesus gibetitakkis nerras hiyeg kabubuknene ayge. Ig awna git: ―Kiyapwiye, nighu kuwis miyá. Negni darihe madikte gewkanbet. Uyá amnihun awna ta git adahan usuh ibekhegbet amin wighu gewkanbet. ");
INSERT INTO plu_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Igme Kiyapwiye Jesus kaytwa giwn: ―Awayg, nah ka ayta adahanma nah kehnema yis ibekhegbet amin yewkanbetma. Ka ininema nannipwi. ");
INSERT INTO plu_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ayteke ig awna ta gitkis nerras hiyeg: ―Hiyapnabay pukuhpawnabay abohri mpihpaka amin ewkaki mmanawa ku wis kadahan kaayhsima wewkanbet, ka innema keh wis utí dehetniki. ");
INSERT INTO plu_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ayteke ig awna pahat yuwit patuwesbuhka ta gitkis. Giwn: ―Minikwak pahapwi awayg igisye gamutrapwi kaayhsima kewpi. ");
INSERT INTO plu_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ig hiyapni henne, ig ipegminene gihiyakemni ig awna: “Mmahpa nah keh kuri? Nah yuma iwetrit adahan bayehne nahakapu ariw.” ");
INSERT INTO plu_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ig awna: “Nah hiyak ku samahpa nah keh. Nah hakuhkise abeyhekri nahakapu ariw. Nah kehkis pi kiyeste akiw. Atere nah bayahkis madikte nahakapu ariw, madikte newkanbet. ");
INSERT INTO plu_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Pisenwa nah awna nnaktin: ‘Awayg, pis kadahan igiska kaayhsima kuri. Ik adahan kaayhsima kamukri. Hiyawa pis mayaksa pipit, hiyawa pis axne, hiyawa pis higepne, hiyawa pis batekye adahan kibite kamukri kuri.’ ” ");
INSERT INTO plu_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Henneme Uhokri awna git: “Pis mahayakempiye awayg. Ka ba pis hiyá ku apim inin mtipka pis umehpikanek? Madikte ini pewkanbet ku pariye pis darihe pidahan in msekwe gidahankis nawenépwi hiyeg.” ");
INSERT INTO plu_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Henneki madikte hiyeg ku pariye kiyé gipitkisnen igkis aharitne igiska amadgaya inin henneme igkis ka igisyema gikak Uhokri gihiyakemni. Henneki igkis biyuk akak madikte igiska. ");
INSERT INTO plu_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Pisenwa gawnhan inakni yuwit, ig Kiyapwiye Jesus awna ta gitkis gikannuhnipwi. Giwn: ―Inneki keh nah awna yit, ka yi muwaka kiyimwihwa amin ariknawnama ku pariye muwekne yit amadgaya inin, iné amin yaxni adahan yih adehetni, iné amin yikawihni adahan yipit. ");
INSERT INTO plu_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ku yis hiyá ig Uhokri kuwis ikí udehetniwiy, umanawiykata akiw ig ka ikí wotwiy akiw? Ku yis hiyá ig kuwis keh upitwiy, ukawihniwiykata akiw ig ka ikí wotwiy? ");
INSERT INTO plu_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ipegnay gumkatkis norras yu. Egkis ka mutuh ariknawnama, egkis kawnata taris ariknawnama. Iné egkis kawnata bayah ariknawnama agiku kat iné agiku payt. Henneme Uhokri ikí gumanakis takunipti. Yis kaayhsima pi kapigte git Uhokri mpiy kuhipra. Ig ikí yit hawwata. ");
INSERT INTO plu_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ka ik adahan wis kiyabwih udehetni akak ku samah wis kiyimwihwa nikak. Wis kiyimwihwa nikak waditnepyenen. ");
INSERT INTO plu_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ku wis kiyimwihwa aharit arikna nopsesniyenen, ka innema keh wis utí arikna. Hawwata madikte arikna hawwata akiw. Wis kiyimwihwa nikak waditnepyenen. ");
INSERT INTO plu_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ipegnay ku samah ipuwiti gubereswankis. Egnes ipuwiti ka kannipwi adahan gupitkis. Egkis kawnata paduk gukawihnikis. Henneme egkis kagubewisima. Juktah amekene Salomawh gibereswan ka mataka gubereswankis. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Egkis ipuwiti he ewwaktinen. Egkis waditnepyenen. Ku apim inin egkis ay amadga inin. Takuwanekme egkis yuma akiw egkis bukehpika. Yis kaayhsima pi kapigte git Uhokri mpiy ipuwiti. Ku yis hiyá ig Uhokri ikí gubereswankis, yiskata akiw ig ka ikí yit yikawihni akiw? Mmahki yis ka kamaxwa ta gipitit Uhokri? ");
INSERT INTO plu_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ka yi muwaka wakaymni aharit ariknawnama ku pariye muwekne yit amadgaya inin, iné aharit yaxni, iné aharit yihigpan, iné aharit yikawihni. Ka yi muwaka kiyimwihwa nimin. ");
INSERT INTO plu_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ku yis kiyimwihwa nimin henne, nikwe yis humaw kewa hiyegbe ku pariye kane Uhokriyanpuma. Ignes apanenekwa wakaymni aharit ini. Yisme ka muwaka wakaymni henne. Wigwiy hiyak ku pariye yimawkanitnene. ");
INSERT INTO plu_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Pi kabayte yis wakaymni giharit Uhokri gikumadukan. Ku yis keh henne, nikwe ig ikí yit madikte ku pariye yimawkanitnene. ");
INSERT INTO plu_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","―Ka yi muwaka apis, nukamkayupwi. Wigwiy kawihkis gikumadukan ta yipititnek. Hennewa gimawkan. ");
INSERT INTO plu_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Hiyawa yis piyuk yewkanbet yis amnih hiyeg madiptapye akak akakurapig. Ayge nikwe yis utinek yewkanbet ku pariye kane madikti yiw. Yis kadahannek igiska ayhté inugik ku pariye dahwa adahan apanenekwa. Ayge yuma amepwapye danuh atere adahan ignes kidisnes yewkanbet. Iné masumsu ka kagehbeta kamis. ");
INSERT INTO plu_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ku pis apanenekwa ipegminenekwa pihiyakemni amin arikna amadgaya inin, amun ini pidahan igiska ay amadga inin. Henneme ku pis apanenekwa ipegminenekwa pihiyakemni amin arikna inugikyene, amun ini pis kadahan igiska ayhté inugik. ");
INSERT INTO plu_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","―Ahegbethawnabay, kasimsahawnay adahan yis ahegbet apit ndawnhan akak yilalampa kabutennene. ");
INSERT INTO plu_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ikawnay ke hiyegbe ku pariye wahepnene gikiparakis gidawnhan ariwntak fet maripkawka. Igkis wahepnenes marihwa pase ku aysaw ig tes lappot igkis ahegbet adahan igkis wokenes lappot gidahan. ");
INSERT INTO plu_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kaayhsima batekka ay gidahankisnek ibuktipiyene ku pariye gikiparakis utiprikis ipegnenes kane himaknama. Apim inin igwa hiyak gikakkisnek. Ig kasimsahaw akak ibukti gisimsa. Ig awna gitkis adahan igkis axnes, igwa ikaprikis. Hennewatbaki nah keh yikaknek. ");
INSERT INTO plu_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Nawenétke nah ayipwite. Nawenétke pabuskak mtipka nah danuhnek, nawenétke kabeyweke nah danuhnek. Ku aysaw nah danuh atere, ku nah utipyi ipegnewa, ayge nikwe yis utí kaayhsima batekkanek. ");
INSERT INTO plu_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Msakwanabay ahegbet takunipti. Waké pahapwi payt akipara hiyaknibe ku kabet amepye danuhbe gipinekut, ig pukuhpawnakam adahan ig mpithig marihwa ig ka parak amepwiye atere gipinekut. ");
INSERT INTO plu_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Yisme kawnata hiyaknima ku kabet nah danuh, nah ku pariye wageswe awayg amadgaya inin. Nah danuh pahaye adahan. Amawka ku yis ahegbet takunipti. ");
INSERT INTO plu_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Igme kiyapwiye Pedru ayapri: ―Kiyapwiye, mmah pis awna inakni yuwit udahannenwa ba kawk ba gidahankis madikte hiyeg? ");
INSERT INTO plu_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Igme Kiyapwiye Jesus kaytwa giwn: ―Nah awna gidahankis madikte hiyeg ku pariye ikewnepwi ke kibeynebe ibuktibe. Ku pahapwi ibukti hiyakemniye, ku ig kis adahan gikipara ipeg ta gipitit, nikwe ku gikipara tipikwiye, apit gitepkemni igme apuriwkis gibukpig nawenépwi ta git. Pisenwa nikwe ig tipik. Igme gibuk msekwe. Ig ikene gimanakis mpuse hawkri. ");
INSERT INTO plu_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ku aysaw ner gikipara diyuh atere akiw, ku ig utí ig gibuk apuriwnene gibukpig kabayhtiwa, nikwe ig ikí git kaayhsima kabayka. ");
INSERT INTO plu_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Juktah ig apuriwkis madikte gewkanbet ta giwakuit ner gibuk. Hennewatbaki ig keh. Nah hawwata nah keh yikaknek. ");
INSERT INTO plu_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Henneme ku ner gibuk ka apuriw gibukpig kabayhtiwatma, ig ner ka utí kabayka. Kawa. Nawenétke ig ipegminene gihiyakemni ig awna: “Nukipara ka ayta kibentenwatma. Ig ayipwihwe kaayhsima akiw.” Ayge nikwe ig kapusa biyuh gibukpig awaykemni akak gibukpig tinogben, ig kayhsaw amin axka higapka, ig urukihwene ayge. ");
INSERT INTO plu_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ayteke ku aysaw ig ka wahapnigma, pahaye adahan ig gikipara danuhnek. Ig danuh ku aysaw gibuk ka iknima adahan ig danuh. Ayge nikwe ig katiwnise gitaraksan ta git gibuknek. Ig sarayhkiswig ta arimkanit ini iwetrit gidahankis hiyeg ku pariye kane ihpenepwima giwn. ");
INSERT INTO plu_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ku pariye ibukti hiyak ku pariye gikipara gibetki, ku ig ka ahegbetaw apit gaytni, ku ig ka keh ku samah gikipara gimawkan, ayge nikwe kaayhsima mbeyne hiyapkiska gitnek. ");
INSERT INTO plu_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Henneme ku pariye hiyeg kane hiyak ku samah gikipara gibetki, ku ig tarakse ku pariye gimawkan, nikwe ka kiyesradima mbeyne hiyapkiska git. Mmanawa ku wis ikakka kaayhsima hiyakemniki ta wot, ayge nikwe wis muwakapka adahan wis wewne akak ini kaayhsima hiyakemniki. Hawwata ku wis ikakka kaayhsima annipwit ta uwakuit, ayge nikwe wis muwakapka adahan wis kehne ini kaayhsima annipwit. ");
INSERT INTO plu_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","―Nah ayta atan adahan nah ke wotbe nah hakisne tiket ay amadga inin adahan in bukehne ku pariye kane kabay ay abet hiyeg gihiyakemnikis. Waké nah kuwis hakisnibe, nah kaayhsima batekkam. ");
INSERT INTO plu_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Henneme amawka pitatye nah kaywepka akak mbeyne kaayhsima. Aa, nah kaayhsima kayah juktah in danuhe nuthu. ");
INSERT INTO plu_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Yis hawwata hiyá mbeynenek. Ka yi muwaka ikiy ku nah ku samah nah danuh atan nah keh madikte hiyeg amadga inin pasamrak pawtak ku apim inin. Kawa. Ku apim inin hiyeg kapetunsaynek nupatra. ");
INSERT INTO plu_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Han pitatit igkisweke pakebyekne gihiyakemnikis ibekhewbet. Mpana siguhnan piyaname batekye nukakhu. Ku kawk piyana siguhnan mpaname batekye nukakhu. ");
INSERT INTO plu_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Apim ini igti kapetunsa gikamkayhkisnek. Ikamkaytime kapetunsa gigkisnek. Inagti kapetunsa gukamkayhkisnek. Ikamkaytime kapetunsa gunagkisnek. Imatrut kapetunsa guhinyokisnek. Ihinyotme kapetunsa gumatrukisnek. ");
INSERT INTO plu_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Hawwata akiw ig Kiyapwiye Jesus awna ta gitkis nerras hiyeg kabubuknene ayge. Giwn: ―Ku aysaw yis hiyá ukuhne katamnap upitkitak yis awna: “Muwok nemnik.” Hennewa in danuh. ");
INSERT INTO plu_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Hawwata akiw ku aysaw mayg paharapyenenwa kannikaw yis awna: “Kuri awahawka kabayhtiwa.” Hennewa in danuh. ");
INSERT INTO plu_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Yis ikawnamah ke wotbe yis hiyakemniyebe hiyeg bawa yis yuma yihiyakemniwa. Yis pukuha en kabayhtiwa, yis pukuha waxri. Mmahki yis ka pukuhpa Uhokri ku pariye gikehni ku apim inin hawkri? ");
INSERT INTO plu_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","―Ik adahan yis pukuha ku pariye wadit adahan yis keh gikak Uhokri. Ik adahan yiwnteknewa yis pukuhpin. Ku samah yis keh gikakkis hiyeg amadgayapu inin, amawka hawwata yis keh gikak Uhokri. ");
INSERT INTO plu_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nah akkite yit ku samah. Amadga inin ku pahapwi taraksa gikak pahapwi, ig mpiksaw adahan wadithebdihpin kibentenwa. Ku iggi gipetunya waxepri ta git hiyaptigi adahan ig kamiyepri atere, ayge apigku ahin apit igkis danuh atere ig mpiksaw wadithebdih ini gitaraksan gikak. Ku ig ka wadithebdihni, iggi gipetunya kamiyeprinek ta git hiyaptigi, igme hiyaptigi awahkis giwatni giparaksepten ta agikut parakseket. ");
INSERT INTO plu_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ku ig paraksepka atere, ig ka pes ayteke juktah ku aysaw ig katiwnih madikte gimatiwnihni. Yis hawwata. Amawka ku yis wadithebdih yitaraksan gikak Uhokri pisenwate ku akak inin. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Nikwenéwa nawenépwi hiyeg danuh atere akiw. Igkis ewk inetit atere git Kiyapwiye Jesus. Igkis awna git: ―Kiyapwiye, ner hiyaptigi kiyapwiye Pilatus ig kuhwekwa ig umahkise gaytakkis galiléyenepwi. Igkis umehpika abetnewa ku aysaw igkis umehnes puwikne adahan igkis kakanhawnes ta git Uhokri. Gimigkis payebitak akak puwikne amig. In danuh gitkis awaku gitaraksankis. ");
INSERT INTO plu_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ig Kiyapwiye Jesus timapni henne, ig awna ta gitkis hiyeg: ―Ka yi muwaka ikiy ku ini danuh gitkis nerras galiléyenepwi, ku ini arekhetnima ku igkis pi mbayte giwkis giyakikis galiléyenepwi. ");
INSERT INTO plu_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Kawa. Yis hawwata taraksapye. Ku yis ka wages yihiyakemni, yis hawwata yis biyuknek. ");
INSERT INTO plu_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ya nerras hiyeg madikawkunene gikebyikis gikakkis ntewnehker gikak pahapwi gawnakis akiw (18) ayhté paytwempu Siloé? Payt imuwad tiptiye hirohe ta gipititkis, umahapeprikis madikte. Ka yi muwaka ikiy ku ini arekhetnima ku igkis pi mbayte giwkis giyakikis jerusalémyenepwi. ");
INSERT INTO plu_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Kawa. Yis ka kabaytema giwkis. Ku yis ka wages yihiyakemni, yis hawwata yis biyuknek. ");
INSERT INTO plu_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ayteke ig Kiyapwiye Jesus kinetihwa gitkis akak pahat yuwit patuwesbuhka. Ig awna: ―Uhokri kewa pahapwi awaygbe ig mutuhe pahakti ah akat amadga giwasra. Eg aymuhwe. Ahawkanaprik danuh adahan eg sarayh guw. Kibereput ig gukipara atere iwasene gamutra guw henneme ig ka utí. ");
INSERT INTO plu_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ig hiyapni henne, ig awna ta git giwasra akapriwten. Ig awna: “Mpanabu kamukri kuwis nah ayta iwasene namutra guw henneme yuma guwsima. Asá ihukepnig. Eg he mpithanano iwetrit adahan amutapta.” ");
INSERT INTO plu_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Igme giwasra akapriwten kaytwa giwn: “Kiyapwiye, uyá wahá pahakwa kamukri akiw. Nah madipwiste ganwew. Pisenwa nah ikí kuwibri ta gukimpuwit. ");
INSERT INTO plu_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Nawenétke eg sarayh guw apim ini kamukri aytwenempiye. Ku kawnata, nikwe pis ihukiswig.” ");
INSERT INTO plu_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ayteke ariwnteke ini ig Kiyapwiye Jesus kannuhne hiyeg agiku pahá leglis. ");
INSERT INTO plu_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Pahapu tino ayge ku pariye kakahriyo adahan kaayhsima kamukri, madikawkubu akebyi akak ntewnehkerbu akak pahak arawna akiw (18) awaku wapitye ay gupit. Ig keh eg buwibete msakwa. Eg ka hiyá egma wadithaptihwa kabayhtiwatma. ");
INSERT INTO plu_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ig Kiyapwiye Jesus hiyapni henne, ig humakru ta gimkanit. Egme danuh atere git, igme awna gut: ―Kiyapuno, pis isamtaw ariw ini pikahri. ");
INSERT INTO plu_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ayteke ig sarayh giwak ta gupitit. Nikwenéwa eg wadithaptihwe. Eg hiyapni henne, eg kabayha Uhokri kaayhsima. ");
INSERT INTO plu_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Leglis akipara ig hiyapni henne, ig kaayhsima dagawne awaku ig Kiyapwiye Jesus piyihak samdi abet. Ig awna ta gitkis hiyeg: ―Ay puguhkuna hawkri apim pahay paka adahan hiyeg kannipwiye. Abet inere hawkri hiyawa yis piyihkiswa. Abetme samdi ka yi muwaka piyihkiswa. ");
INSERT INTO plu_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Igme Kiyapwiye Jesus kaytwa giwn: ―Yis ikawnamah ke wotbe yis kibeynepwibe hiyeg bawa yihiyakemni pi mbayte giwkis nawenépwi hiyeg. Abetwa samdi yis wateknekwiye yipig pak, yipig kaway ariwntak gaxkegkis adahan yis waxwigkis arit un adahan igkis higepnes un ayge. ");
INSERT INTO plu_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","No tino kabayte ariw pak. Eg amekene Abrawh gihiwhi. Kuwis eg wanekwika gapit Satanás adahan kaayhsima kamukri, madikawkubu akebyi akak ntewnehkerbu akak pahak arawna (18) akiw. Mmah ka hiyá nahma watakru ariw ini mbayka samdi abet? ");
INSERT INTO plu_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ig awna inakni yuwit henne, madikte gipetunyapu marekepwe ku samah gihiyakemnikis ka wadit. Henneme madikte hiyeg ku pariye kabubuknene ayge igkis batek ginaktinkis awaku ku samah ig keh ini kibeyne annut. ");
INSERT INTO plu_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ayteke ig Kiyapwiye Jesus awna ta gitkis hiyeg akiw. Ig awna: ―Mmah nuwnhu kuri adahan nah akki yit ku samah Uhokri gikumadukan? ");
INSERT INTO plu_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Uhokri gikumadukan aymuhwa amadga inin ke amutri “mostadbe”. Ku aysaw pahapwi iwé pahow “mostad” ayak, ig mutuhgu amadga giwasra, eg nopsesniyo. Henneme eg hiyan eg aymuhwa kaaramusima ke ahbe akatbe. Juktah ik adahan kuhipra kibhaw gupewit. ");
INSERT INTO plu_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ayteke ig Kiyapwiye Jesus awna akiw. Giwn: ―Pariye yuwit patuwesbuhka akiw adahan nah akki yit ku samah Uhokri gikumadukan? ");
INSERT INTO plu_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","In keh hiyeg gihiyakemnikis aymuhwa hawwata ku samah bugut abusan tukurusa bugut. Ku pahapu tino iwé aynessawa bugut abusan, ku eg wagesbetepni ta abetit mpana bom fahhin, ayge nikwe madikte in tukurpi. ");
INSERT INTO plu_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ayteke ig Kiyapwiye Jesus tipiknene ta arimkanit paytwempu Jerusalém. Ig mpiye muwwapu awpre apuriw madikte paytwempu nopsadmin hawwata apuriw paytwempu nopsanyupnene akiw. Ku kiw ig mpiye ig kannuhne hiyeg. ");
INSERT INTO plu_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ayge pahapwi awna git: ―Kiyapwiye, mmah ka kiyesradima hiyeg isamtawnek? Igme kaytwa giwn, ig awna gitkis hiyeg: ");
INSERT INTO plu_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Parekket ta agikut ku kiney Uhokri gikumadukan in kewa pahatra ahin mahamwisniyebe. Mpiksawnabay parak atere. Aysawnemenek hiyeg kaayhsima parekkere aterenek henneme igkis ka hiyá igkisma parak. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Uhokri gikumadukan kewa pahá paytbe. Aysawnemenek ig payt akipara kannikawnek adahan ig sabukwiye alappota awaku kuwis mpiya ahawkanaprik adahan hiyeg parak atere. Apim ini yis humaw kewa hiyegbe ku pariye tabibetnene ay kabaywak. Yis tetesnenen anumeku gilappotanek. Yis kabiman git payt akiparanek: “Kiyapwiye, uyá woka lappot udahan.” Igme kaytwa yiwn: “Nah ka hiyakyi ku pariyene yis.” ");
INSERT INTO plu_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ayge nikwe yis kaytwa giwnnek: “Ka ba pis hiyak usuh, Kiyapwiye? Minikwak usuh axne pikak. Usuh higap payak pikak. Pis kannuhekne ay apit uwaxri.” ");
INSERT INTO plu_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Igme kaytwa yiwnnek: “Kawa. Nah ka hiyakyiwa ku pariye yis. Higihwanabay aytekihan, yis mbayapye.” ");
INSERT INTO plu_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ayge nikwe yis tihebdinek. Apim ini yis hiyá amekene Abrawh gikak amekene Izaki gikak amekene Jakó igkis ayge ku kiney Uhokri gikumadukan. Yis hiyá madikte Uhokri gawnepepu ayge. Yis hiyapni henne ku samah yis ayhté kabaywak, ayge nikwe yis tihebdinek. Yis kagah yaybunek. ");
INSERT INTO plu_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Aysawnemenek kaayhsima hiyeg wahamapriktak, upitkiyapriktak, imekapriktak, tiwgikapriktak, igkis madikte ax numunhu ayge ku kiney Uhokri gikumadukan. ");
INSERT INTO plu_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Kaayhsima hiyeg ku pariye ikaka yumanene gikiythanikis ay amadga inin, ayge apim ini igkis kiyatyepwinen hiyeg. Hawwata akiw kaayhsima hiyeg ku pariye ikaka kiyatyepwi ay amadga inin, ayge apim ini igkis yuma gikiythanikis. ");
INSERT INTO plu_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Apiminewa ini hawkri gaytakkis nerras farisewkis danuh atere git Kiyapwiye Jesus. Igkis awna git: ―Su tipik. Pes ayteke. Mmanawa kiyapwiye Erodis pihapu piwmepten. ");
INSERT INTO plu_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Igme kaytwa giwnkis: ―Su yi atak awna ta git ner amepye kinisekatya ku nah ndukwenewa pekkisnene wapitye gipititakkis hiyeg, nah piyiheknene ku apim inin takuwanek he nuhawkanaprik danuh adahan nah pisenwe ini nannipwi. ");
INSERT INTO plu_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ig ka hiyá igma pisenwa akak nannipwi. Henneme ahawkanaprik kabá danuh adahan in pisenwa. Nah tipiknene ku apim inin takuwanek hawkanek adahan nah danuh apitit paytwempu Jerusalém. Mmanawa ka kis adahan pahapwi Uhokri gawnepe miyá apit nawenéwa paytwempu ku ka Jerusalémma. ");
INSERT INTO plu_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Aa, yis jerusalémyenepwi, yis jerusalémyenepwi, yis umahape Uhokri gawnapepu. Yis padakte madikte hiyeg ku pariye Uhokri gawahkisni yimin. Bawa kaayhsima hawkri nah muwaka kapigsay ke pahapu takarakbe awahpusano gukamkayupwi anapi guhanpi. Hiyaksa yisme ka muwaka henne. ");
INSERT INTO plu_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Aysawnemenek yiwetri msekwe inworenek. Uhokri ka apuriwni akiw. Yis ka takunima hiyapun akiw juktah ku aysawnemenek metakwa yis ahegbet adahan amapan, yis awna nuthu: “Kibeyne pis danuh. Pis ayta giwntakwa Uhokri.” Ihanabay inakni nuwnhu. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ayteke ariwnteke ini ig Kiyapwiye Jesus tipik axne ta git pahapwi farisew. Igme pahapwi gaytakkis giwewkistenkis. Igme Kiyapwiye Jesus atak atere samdi abet. Ig danuh atere, hiyeg ayge apuriwgi kabayhtiwa ba ig piyihak abet samdi. ");
INSERT INTO plu_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ayteke pahapwi awayg wagawgaptipye danuh atere git. ");
INSERT INTO plu_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ig Kiyapwiye Jesus hiyapni henne, ig awna ta gitkis nerras farisewkis gikakkis nerras kannuhekeputnepwi amin amekene Moís gikumadukan. Giwn: ―Ba amekene Moís gikumadukan isaksaw adahan wis piyihak samdi abet? ");
INSERT INTO plu_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Igkisme ka kaytwa giwn. Igkis tinwopu. Ayteke nikwe ig Kiyapwiye Jesus iwé ner awayg, ig makniwepri, ig awahkiswig adahan ig tipik gipinekute. ");
INSERT INTO plu_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ayteke ig awna ta gitkis nerras hiyeg aygnenepwi: ―Ku yikamkayh wiwhe agikut pahayku unimna, ku yipig pak wiwhe agikut pahayku unimna, mmah ka yisma kahgi ayteke pisenwate? Hiyawa abet samdi henneme yis kahgi ayteke. Ku ka sam yis amnihpigkis henne abet samdi, kawnata sam adahan nah piyihekne abet samdi. ");
INSERT INTO plu_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Igkis timapni henne, igkis ka hiyá igkisma diyuhkis ginetni. ");
INSERT INTO plu_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ayteke ariwnteke ini ig Kiyapwiye Jesus hiyá ku samah ner farisew gawnasanpu kaniynekwiye iwetrit kiyatye adahan igkis bat atere. Ig hiyapni henne, ig awna ta gitkis: ");
INSERT INTO plu_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Ku aysaw pis awnasaka adahan fetya, ku aysaw pis danuh atere, ka muwaka bat amadga iwetrit ku pariye pi kiyattenene. Ku nawenétke pahapwi awayg pi kiyatte mpiyap awnasaka atere. ");
INSERT INTO plu_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Nawenétke ner pawnasetni awna pit: “Uyá higihwa ayteke. Ikinaba piwetri ta git ner.” Ayge nikwe pis marekepwe pis iwepye iwetrit ku pariye makiythanipye. ");
INSERT INTO plu_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ka ba kehni henne. Ku aysaw pis awnasaka adahan fetya, ku aysaw pis danuh atere, batnaba amadga iwetrit ku pariye makiythanipye. Ayge nikwe nawenétke fet akipara ayta awna pit: “Nukagmada, ba ayta bat amadga ini iwetrit ku pariye kiyatye.” Ayge nikwe pis utinek pikiythani ay gibetkis nerras hiyeg aygnenepwi. ");
INSERT INTO plu_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ku pahapwi ikewkere kiyatte mpiye pahapwi, iggi Uhokri wiwhe gikiythani gipititaknek. Henneme ku pahapwi ikewpiye ke wotbe ig yumahbe gikiythanibe, iggi Uhokri ikí gikiythani ta gipititnek. ");
INSERT INTO plu_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ayteke ig Kiyapwiye Jesus awna ta git ner fet akipara. Giwn: ―Ku aysaw pis keh axka puwipwak aygete, ka ba awnasa pikagmadapu iné pegnipwi iné pikebyupwi iné pihumwayepwi igisapye atere. Nawenétke igkis hawwata keh axka awnasap atere. Amun ini nikwe igkis kuwis diyuhkis piwak. ");
INSERT INTO plu_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ka ba kehni henne. Ku aysaw pis keh axka, pis awnasa hiyeg madiptapye, hiyeg wayak, hiyeg miyapuwapye, hiyeg motapye. ");
INSERT INTO plu_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ku pis awnasa akebyi nerras hiyeg, pis utí kabaykanek. Mmanawa igkis ka hiyá asamanak diyuhkis piwak. Ayge nikwe igwa Uhokri diyuhkis piwak giwenyankis aysawnemenek abet ini hawkri ku aysaw hiyeg kibeynepwi kannikasaka. ");
INSERT INTO plu_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Pahapwi awayg ayge ig timapni inakni yuwit henne, ig awna git Kiyapwiye Jesus: ―Kaayhsima batekka ay gidahan ner ku pariye ax gimun Uhokri ayhté ku kiney gikumadukan. ");
INSERT INTO plu_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Igme kaytwa giwn akak pahat yuwit patuwesbuhka. Ig awna: ―Uhokri kewa pahapwi awaygbe ku pariye kehne axka kiyesrad. Ig awnasa kaayhsima hiyeg adahan igkis ta axnes gikak. ");
INSERT INTO plu_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ayteke ku aysaw axka ahawkanaprik danuh, ig awahkis gibuk tahhan watihpigkis. Igme gibuk tipik uteprikis. Ig awna gitkis: “Barewbakay ayta ax. Madikte ahegbet kuwis.” ");
INSERT INTO plu_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Henneme igkis madikte wihwenekwiye ariw. Pahapwi awna git: “Nah kuhwekwa nah isime pahak was. Amawka nah tipik iwasapni. Nah ka kahawkan adahan nah ax gikak.” ");
INSERT INTO plu_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Pahapwime awna hawwata akiw: “Nah kuhwekwa nah isime madikawku gukebyikis pak. Nah atakte iwasaprukis. Nah ka kahawkan adahan nah ax gikak.” ");
INSERT INTO plu_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Pahapwime awna hawwata akiw: “Nah kuhwekwa nah kamaxe nuhaya. Nikwe nah ka hiyá nahma ax gikak.” ");
INSERT INTO plu_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ayteke ner gibuk timapni henne, ig tipik diyuhe ta git gikipara. Ig akki git ku samah inakni giwnkis git. Ig gikipara timapni henne, ig ka batek. Nikwe ig awna ta git gibuk: “Su atak wew ta apigkut madikte ahin nopsad hawwata madikte ahin nopsehsa. Pis ipegpa hiyeg madiptapye, hiyeg wayak, hiyeg motapye, hiyeg miyapupye. Pis waxwigkis ta numkanit.” ");
INSERT INTO plu_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ig gibuk timapni henne, ig tipik, ig ihe inakni giwn. Ayteke ig diyuh ta git gikipara akiw. Ig awna git: “Kiyapwiye, nah kuwis keh ku samah piwn nuthu. Henneme msekwe iwetrit adahan nawenépwi hiyeg akiw.” ");
INSERT INTO plu_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ig gikipara timapni henne, ig awna git: “Pesnaba apuritak paytwempu adahan pis atak ta apigkut ahin piyawakad. Kinistigkis nerras hiyeg ayge adahan igkis ayta numkat. Numawkan nupinhu kipun akak hiyeg. ");
INSERT INTO plu_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nerrasme pitatyepwi ku pariye nawnasanpu igkis biyuk. Igkis ka ax nukakhu.” ");
INSERT INTO plu_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ayteke ariwnteke ini ig Kiyapwiye Jesus tipik. Ig waywe, kaayhsima hiyeg kuruw gihapu butte. Ig hiyapni henne, ig wagestaw, ig awna gitkis: ");
INSERT INTO plu_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Ku pahapwi humewkerepye nuhiyega, amawka ku ig wiwhe giyakni gipititak gig, gupititak ginag, gupititak gihayo, gipititakkis gikamkayupwi, gipititakkis gikebyupwi. Hawwata akiw amawka ig miyeh gipitwa ig miyeh. Ku ka hennema, ig ka hiyá igma kannuhwa nuthu. ");
INSERT INTO plu_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Amawka ku pariye nukannuhni amawka ku ig wew umahkisnene gihiyakemni amadgaya inin ke wotbe ig daddahkisni ta aminat ahbe. Ku pahapwi ka umahkis gihiyakemni henne hawwata ke nahbe, iggi ka hiyá igma humaw nukannuhni. ");
INSERT INTO plu_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ipegminabay yihiyakemni adahan ba yis ahegbetnama adahan yis keh henne. Ku pahapwi yaytak kehne pahá payt nopsadmin, apit ig kapusa keh, ig bat ig ipegminene gihiyakemni ku aysamuk atiwni pes. Ig ipegminene gihiyakemni marihwa ig hiyak ba ig kadahanama karukri adahan ig pisenwa ini payt. ");
INSERT INTO plu_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ku nawenétke ig kapusa keh payt henneme ig ka pisenwahni, ignesme hiyeg hiyá ig ka pisenwahni, igkis hiyaraptihpig, ");
INSERT INTO plu_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","igkis awna: “Ner awayg kapusa payt ig ka hiyá igma pisenwahni.” ");
INSERT INTO plu_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Hawwata akiw ku pahapwi ikiparat kehne kerka gikak giyaki ikiparat, apit ig atak kerye gikak, ig batahkiswa adahan ig ipegminene gihiyakemni ba ig ik adahan ig patiptak gikak. Nawenétke ig kadahan madikawku mil (10.000) gikebyikis gisuwtatapu igme gipetunya ku pariye aytniye patiptak gikak ig kadahan pibohra gisuwtatapu pina madikwa mil (20.000) gikebyikis. ");
INSERT INTO plu_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ku ig ka ik adahan ig patiptak gikak gipetunya, ig wasapanaw gimin ku aysaw ig piyawakte giw. Ig ayá ta git adahan igkis keh pasamraki. ");
INSERT INTO plu_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Amawka yis hawwata ipegminenete yihiyakemni adahan ba yis ahegbetnama adahan humaw nukannuhni. Ku pahapwi humewkerepye nukannuhni kibentenwa, henneme ku ig ka wiwh giyakni apititak madikte gewkanbet, ayge nikwe ig ka hiyá igma humaw nukannuhni. ");
INSERT INTO plu_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ig humaw kewa pambe ku pariye biyukse aketribe. Pam kabay, henneme ku ini pam biyukse niketri, wis ka hiyá wisma kabayhin akiw. ");
INSERT INTO plu_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","In ka kawih adahan ariknawnama akiw. Juktah in ka ik adahan kabayha wayk iné adahan wages akak kuwibri. Nikwe in padekwiki. Yis hawwata ku yis biyuksa yabay, yis kawnata kawih adahan ariknawnama akiw. Yis ku pariye katayebnene, ataybiswanabay numkanit. ");
INSERT INTO plu_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Kaayhsima hiyeg ladwan gikakkis nawenépwi hiyeg ku pariye ikaka kane kibeynepwima hiyeg igkis danuh atere adahan igkis timepnes giwn. ");
INSERT INTO plu_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Nerras farisewkis gikakkis nerras kannuhekeputnepwi amin amekene Moís gikumadukan igkis hiyapni henne, igkis minimnihegbet gimin Kiyapwiye Jesus. Igkis awna: ―Ner hiyeg darihwak gikakkis hiyeg kane kibeynepwima. ");
INSERT INTO plu_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ig Kiyapwiye Jesus hiyapni henne, ig awna gitkis pahat yuwit patuwesbuhka. Giwn: ―Mmahkay yis asene nerras hiyeg? Igkis kaapigikissima nuthu. Igkis kewa muttuh biyukapyebe nuthu. ");
INSERT INTO plu_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Ku pahapwi yaytak kadahan kaayhsima gipig muttuh, sah (100) gikebyikis, ku pahapwi gaytakkis biyuke, nikwe ig ikise gipig akebyupwi (99) ayge amadga amatap, ig ta ipegepye gipig biyukwiye. Ig ipegpig ipegpig juktah ku aysaw ig utepri. ");
INSERT INTO plu_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ig utepri, ig hiyuhpig ta giteyaminat mmanawa kaayhsima ig batek. ");
INSERT INTO plu_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ig tipik, ig danuh ta gipinwat. Ayge ig pahadguh gikagmadapu gikakkis gihumwayepwi. Ig awna gitkis: “Uyay batek payak nukakhu. Mmanawa nah kuwis uté nupighu biyukwiye.” ");
INSERT INTO plu_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Hawwata akiw ayhté inugik kaayhsima batekka ayge ku aysaw pahapwi taraksepye wages gihiyakemni. Ayge igkis pi batekte akak ku samah pahapwi taraksepye wages gihiyakemni mpiya ku samah igkis batek gikakkis kabá sah (99) gikebyikis ikewnepwi waditye. ");
INSERT INTO plu_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ayteke ig Kiyapwiye Jesus awna pahat yuwit patuwesbuhka akiw adahan ekkene ku samah hiyeg kaapigikissima git. Ig awna: ―Ku pahapu tino yaytak kadahan madikawkumku karukri ku pahamku biyuke guw, eg hakis gulampra, eg sagahakuh gupin, eg ipegpig kabayhtiwa juktah ku aysaw eg utepru. ");
INSERT INTO plu_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ayteke ku aysaw eg utepru, eg humak gukagmadapu gikakkis guhumwayepwi. Eg awna gutkis: “Uyay batek payak nukakhu mmanawa kuwis nah uté nukakura biyukwiyo.” ");
INSERT INTO plu_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Hawwata akiw kaayhsima batekka gimunkis Uhokri gihiyegapu ahj ku aysaw pahapwi taraksepye wages gihiyakemni. ");
INSERT INTO plu_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ayteke ig Kiyapwiye Jesus awna pahat yuwit patuwesbuhka akiw adahan ekkene ku samah hiyeg kaapigikissima git. Ig awna: ―Minikwak pahapwi awayg kakamkayh piyana gikebyikis. ");
INSERT INTO plu_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Pahay hawkri gikamkayh butye awna ta git gig: “Pa, nah muwaka pis ikí nuthu abusku pewkanbet ku pariye pis ikepye nuthu. Nah muwaka pis ikepni nuthu pisenwate.” Ig gig timapni henne, ig ibekhe gewkanbet gitkis gikamkayupwi. ");
INSERT INTO plu_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Nikwenéwa gikamkayh butye piyuke gidahan gewkanbet madikte. Ig ahiw akakurapig madikte kuwis, ig awna: “Nah peste gipinekutak nighu.” Ig tipik ta apitit pahá waxri ku pariye piyawakad. Ig danuh atere ig mahayakemnihwenenwa sarayhnenenwa gikakura. ");
INSERT INTO plu_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ayteke gikakura madike kuwis, mihetniki biyuhe apitit ini waxri. Ig kamaxe matipwa kaayhsima nikwe. Ig yuma ariknawnama gimun. ");
INSERT INTO plu_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ig hiyapni henne, ig ayá gannipwi ta git pahapwi hiyeg aygnene apit ini waxri. Igme awahkiswig ta wasamdakat adahan igme apuriwne gipig pakirempu. ");
INSERT INTO plu_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ig danuh atere, ig matipwe mpiynepepye juktah ig axkere pakir gimanakis. Henneme ka ikaka git ariknawnama. ");
INSERT INTO plu_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Amun ini ig ipegminene gihiyakemni ig hawkamnihwa ariw. Ig awna: “Nighu gibukpig kaayhsima axka gidahankis. Yuma ariknawnama muwekne gitkis. Nahme ay nah me miyapwa awaku matipwa. ");
INSERT INTO plu_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nah ta hikekwate atak git nighu. Nah kinetihwate gikak, nah awna git: ‘Pa, nah tarakse gikak Uhokri. Nah tarakse pikak hawwata. ");
INSERT INTO plu_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nah ka kis adahan pis kanumun pikamkayh akiw. Uyá amnihun amapan adahan nah humaw he pibuknenwa.’ ” ");
INSERT INTO plu_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ig awna inakni, ig ahegbetewpi, ig tipikwiye ta gimkanit gig. Piyawak ig gig sarayh gipegyi, ig hiyá gikamkayh nemnik. Ig amnihpig kaayhsima. Ig kayah apit giyakni. Ig sigis piyawakad ta gitiput gikamkayh. Ig aytihpig akak madikte gibetki. Ig ugiswig. Ig ayhpokig. ");
INSERT INTO plu_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Igme gikamkayh awna git: “Pa, nah tarakse gikak Uhokri. Nah tarakse pikak hawwata. Nah ka kis adahan pis kanumun pikamkayh akiw.” ");
INSERT INTO plu_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Inme inakni gikamkayh giwn ka ariknawnama git gig. Nikwe ig awna ta gitkis gibukpig. Giwn: “Iwawhawnay. Ewknabay ndagmanpit ku pariye pi barewtenene. Kawihkisninay ta gipitit. Kawihkisnay akawakti ta giwakuit. Kawihkisnay kasapat ta gikugkuprikut. ");
INSERT INTO plu_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ataknabay kamax ner pak akamkayh ku pariye aynengarudi. Eggu yis umah adahan wixwiy fetya. Uyay batek. ");
INSERT INTO plu_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Mmanawa ner nukamkayh igte ke wotbe ig miyapyebe nuwhu kuwisbe. Kurime ig ay numunhu akiw. Ig ke wotbe biyukwiyebe nuwhube. Kurime ig utepka akiw.” Ayteke nikwe igkis kapusa fetya. ");
INSERT INTO plu_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Nikwenéwa apim ini gikamkayh eggutye ayhté wasamdak. Ig tipikwiye ta gipinwat. Ig hiyukamin ta arimkat gipin kuwis, ig timá arigman ayteke gipinwatak. Ig timá hiyeg kaynekis ayteke. ");
INSERT INTO plu_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ig timapni henne, ig humak pahapwi gig gibuk. Ig awna git: “Mmahkay ku apim inin?” ");
INSERT INTO plu_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Igme gibuk kaytwa giwn: “Awaku pisamwi diyuhe apim inin hawkri. Pig kaayhsima batek. Ig umahkis pak akamkayh aynengarudi awaku ku samah ig utí gikamkayh makniw akiw.” ");
INSERT INTO plu_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ig eggutye timapni henne, ig dagawne. Ig awna: “Ku henne nikwe nah ka parak upinekut akiw.” Ig tabirnene ayge kabaywak, igme gig pes atere ta gimkanit adahan ig kinistig atere. ");
INSERT INTO plu_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Igme kaytwa giwn: “Pa, pikehni ka wadit. Kaayhsima kamukri nah kannipwiye pidahan. Nah ka taraksa pahatnama pikumadukan. Hiyaksa pisme ka ikiwa nuthu pahapwinama kabritma adahan nah fetya gikakkis nukagmadapu. ");
INSERT INTO plu_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Igme pikamkayh ku pariye he sarayhpinen pikakura gukakkis tinogben powkemnapyo, pis umahkis pak akamkayh ku pariye aynengarudi gidahan. Mmahki inere?” ");
INSERT INTO plu_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Igme gig hiyapni henne ku samah ner gihiyakemni henne, ig kaytwa giwn: “Nukamkayh, pis ay numunhu apanenekwa. Madikte ku pariye ndahan in pidahanwata. ");
INSERT INTO plu_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Henneme in kabay adahan wixwiy fetya awaku ku samah pisamwi diyuhe wotwiy akiw. In kabay wixwiy batek gidahan mmanawa ner pisamwi igte ke wotbe ig miyapyebe wowiy kuwisbe. Kurime ig ay umunwiy akiw.” ");
INSERT INTO plu_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Pisenwa gawnhan inakni yuwit henne, ig Kiyapwiye Jesus awna ta gitkis gikannuhnipwi nawenéwa yuwit patuwesbuhka akiw. Ig awna: ―Minikwak pahapwi awayg igisye kadahan pahapwi gihiyega, gewkanbet akapriwten. Pahay hawkri hiyeg danuh atere git igkis awna git: “Ner pihiyega pewkanbet akapriwten ig he padekbetepi pewkanbet akak pikakura.” ");
INSERT INTO plu_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ig gikipara timapni henne, ig watiha ner gihiyega. Igme gihiyega danuh atere, igme gikipara awna git: “Mmahki nah timá mbeyepye pak henne? Asá tamak amadga kagta madikte ku pariye piwiwhni, madé aypekwiye amadga kagta. Ayteke pis tipik. Ka hiyá pisma apuriw newkanbet akiw.” ");
INSERT INTO plu_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Igme ner awayg timapni henne, ig awna: “Mmah nah keh kuri? Nukipara ka muwakapun akiw adahan nah kannipwiye gidahan. Kitak nah utí numana? Nah yuma ndatni adahan nah kannipwiye awiyka. Nah marenpi adahan nah makehpene numana. ");
INSERT INTO plu_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Aah, nah hiyak ku samah nah keh. Nah kawih nukipara gewkanbet ku pariye ay nuwakhu kahadbe ku aysaw nah ipukepka nah kakagmadapu ku pariye amapan gipinekutkis.” ");
INSERT INTO plu_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ayteke nikwe ig wasapanaw giminkis nerras ku pariye matiwnihnepwi gikipara adahan igkis ayta git. Igkisme danuh atere, igme awna ta git pahapwi ku pariye kit danuh. Giwn: “Aysamuk pis matiwnih git nukipara?” ");
INSERT INTO plu_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Igme kaytwa giwn: “Nah matiwnih sah (100) bom diluy.” Igme awna git: “Nobaki pikagtan adahan pimatiwnihni. Batnaba atan. Hiyawa pis tamak nawenéwa kagta akiw kibentenwa adahan pimatiwnihni inenewa abusku sah (50) bom.” ");
INSERT INTO plu_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ayteke ig awna ta git pahapwi akiw. Giwn: “Ya pis? Aysamuk pis matiwnih?” Igme kaytwa giwn: “Nah matiwnih mil (1.000) sak fahhin.” Igme awna git: “Nobaki pikagtan adahan pimatiwnihni. Hiyawa pis tamak nawenéwa kagta akiw adahan pimatiwnihni inenewa yuwit sah (800) sak.” ");
INSERT INTO plu_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ig ner awayg awna inakni henne, ig ka keh wadit. Henneme ig kannuh apuriw gipit adahan ku pariye nemnikumpiye gimkat. Hiyeg amadgayapu inin igkis pi kannuhte apuriw gipitkis adahan ku pariye nemnikumpiye gimkatkis mpiya nuhiyegapu ku pariye ay adahanikwa uguhne gihiyakemnikis. Igkis kannuh apuriw gipitkis adahan ku pariye nemnikumpiye gimkatkis amadga inin. Igkisme nuhiyegapu igkis ka kannuh kabayhtiwatma adahan ku samah igkis apuriw gipitkis adahan ku pariye nemnikumpiye gimkatkis ayhté inugik. ");
INSERT INTO plu_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nah ayá yit nukannuhnipwi, kawihnabay yewkanbet amadgaya inin gidahankis yikagmadapu inugikyenepwi kahadbe ku aysawnemenek in yewkanbet mpiye, igkis amapay ta gipinekutkis inugikut. ");
INSERT INTO plu_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ku pahapwi kannuh kawih aynessa arikna kabayhtiwa gidahan Uhokri, nikwe ig hawwata kannuh kawih kaayhsima arikna kabayhtiwa gidahan Uhokri. Ku pahapwi ka kawih aynessa arikna wadit gidahan, ig kawnata hiyak akawhak arikna kiyesradima. ");
INSERT INTO plu_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Yis hawwata. Ku yis ka kannuh kawih yewkanbet amadgaya inin wadit gidahan Uhokri, nikwe aysawnemenek yuma arikna inugikyene ikaka ta yiwakuit. ");
INSERT INTO plu_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Hennewatbaki in. Ku yis ka kannuh kawih Ukiparawiy gewkanbet wadit gidahan, nikwe aysawnemenek ig ka kawihkis yit ariknawnama yidahan. ");
INSERT INTO plu_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Pahapwi ibukti ka ik adahan kakiparahaw gitkis gikipara piyamatema nikwenéwatma. Waké ig piyana gikiparabe, ig pi batektekam gikak pahapwi mpiy pahapwi. Ig miniwkam giw pahapwi adahan ig kannipwiye gidahan pahapwiwa. Wixwiy hawwata akiw. Ka hiyá wixwiyma mpiksaw keh Uhokri gibetki nikwenéwatma ku samah wixwiy mpiksewne aharit igiska amadgaya inin udahanwiy. Amawka wixwiy kaniy pahapwiwa adahan wixwiy kakiparahaw git. ");
INSERT INTO plu_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Nerras farisewkis timapni madikte inakni giwn henne, igkis mahipwihpig. Mmanawa igkis batek akak gewkanbetkis igkis ka biyuksakere gikakurakis gidahan Uhokri. ");
INSERT INTO plu_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ig Kiyapwiye Jesus hiyapni henne, ig awna gitkis: ―Yis ikawnamah ke wotbe yis kibeynepwibe giwtrikkis hiyeg henneme Uhokri hiyak ku pariye ay apit yiyakni. Ay ku pariye hiyeg ikiy ku in kibeyne bawa in aseneweke ta git Uhokri. ");
INSERT INTO plu_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","―Ig amekene Moís gikumadukan in yikannuhten gimin Uhokri. Ignes Uhokri gawnepepu pitatyepwi igkis hawwata yikannuhten he danuhe git amekene João Batistamni. Kurime usuhnewa ekkene ini kibeyne inetit ku Uhokri gikumadukan ahawkanaprik kuwis danuh. Kuri hiyeg mpiksewne kawih ini gikumadukan. ");
INSERT INTO plu_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Henneme ig amekene Moís gikumadukan in ka mpiya. En akak waxri in mahiko adahan in mpiya. Henneme in pi mahikote adahan pahat yuwit atiksak ay amadga amekene Moís gikumadukan adahan in mpiya. ");
INSERT INTO plu_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","―Ku pahapwi awayg mayte gihayo, ku ig maripkaw gukak pahapuwa tino akiw, amun ini nikwe giwtrik Uhokri ig kuwis powkemnihwe gukak. Hawwata akiw ku pahapwi awayg kamaxe pahapu tino ku pariye maytepyo gugihgi, ay amun ini nikwe giwtrik Uhokri ig kuwis powkemnihwe gukak. ");
INSERT INTO plu_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ayteke ig Kiyapwiye Jesus kinetihwa gitkis akak pahat yuwit patuwesbuhka akiw. Ig awna: ―Minikwak pahapwi awayg igisye. Ig bareswapu akak gibereswan kaatiwnisima. Ig fetya ig kehne batekka takunipti. ");
INSERT INTO plu_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Hawwata akiw pahapwi awayg ayge madiptipye. Giw Lázaru. Ig busukpitwiye. Mpuse hawkri ig haritasepka apinumaprik ner igisye gilappota. ");
INSERT INTO plu_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ig aharit ner igisye gimana arebdi tuguhpiye adahan gaxni. Ig hiyá kaayhsima mbeyne ayge juktah pewru ayta ewwa gibuskana. ");
INSERT INTO plu_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ayteke ariwnteke ini ig madiptipye miyap. Ahj ayta iwepri waxepri ta giwanmakut kiyapwiye Abrawh. Ayteke ner igisye ig hawwata ig miyap ig apuhpika. ");
INSERT INTO plu_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ig igisye ayhté amun miyarapye giwetrikis, ig hiyepne kaayhsima kayahwaki ayge. Ig sarayh gipegyi, ig hiyá kiyapwiye Abrawh piyawakte, hawwata ig hiyá Lázaru ay giwanmaku. ");
INSERT INTO plu_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ig hiyapni henne, ig kabiman ta gimkanit. Ig awna: “Nighu Abrawh, uyá amnihun. Uyá awahkis Lázaru ayta nuthu. Wani ig idis giwak akisunen ta ahakwat un ig tikis ta nnenamadgat adahan nah kisepye nnen. Mmanawa nah kayah kaayhsima abet eggu tiket.” ");
INSERT INTO plu_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Igme kiyapwiye Abrawh kaytwa giwn: “Nukebyi, kiyemnahnaba ku samah pis amadgate hawkri pis hiyá kaayhsima kabayka. Igme Lázaru hiyá kaayhsima mbeyne ayge. Kurime ig aydhaka kaayhsima ay numunhu pisme ay hiyepne mbeyne abet kayahwaki apatra pitaraksan. ");
INSERT INTO plu_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Hawwata akiw uwetriwiy kuwis bekhepka udahanwiy kuwis. Yuma manukket adahan hiyeg danuhne atere pit iné adahan hiyeg ayge danuhne atan wothu.” ");
INSERT INTO plu_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ig igisye hiyapni henne, ig awna git: “Nighu, ku henne nikwe, nah ayá pit awahkisnig ta gipinekut nighu. ");
INSERT INTO plu_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Nah kadahan pohowku gikebyikis nukebyupwi ayge. Wani ig ik ndahan gihiyakemnikis kahadbekama igkis ka keh kema nahma marihwa igkis ka hiyá mbeyne ay abet inin kayahwaki hawwata kema nahma.” ");
INSERT INTO plu_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Igme kiyapwiye Abrawh kaytwa giwn: “Igkis kuwis ikaka gitkis gihiyakemnikis. Igkis kuwis kadahan Moís gikumadukan. Igkis kuwis kadahan Uhokri gawnepepu giwnkis. Hiyawa igkis timá inakni giwnkis.” ");
INSERT INTO plu_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Igme igisye awna: “Kawa, nighu Abrawh igkis ka timepkere inakni giwnkis. Henneme ku pahapwi miyapiye danuh atere gitkis, igkis iha giwnnek, igkis wages gihiyakemnikisnek.” ");
INSERT INTO plu_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Igme kiyapwiye Abrawh awna git: “Ku igkis ka timepkere Moís giwn iné Uhokri gawnepepu giwnkis, nikwe hiyawa pahapwi kannikaw ariw gimiremni henneme igkis kawnata iha giwn.” ");
INSERT INTO plu_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ayteke ig Kiyapwiye Jesus awna ta gitkis giwatnipwi: ―Apanenekwa arikna danuh wot adahan utaraksasepten ay amadga inin. Henneme ku pahapwi hiyeg taraksase pahapwi, ig katiwnihninek, ig hiyá mbeyne kaayhsimanek. ");
INSERT INTO plu_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ku ig taraksase pahapwi bakimni nopsesniye, ig utinek mbayka pi mbayte akiw giw pahapwi ku pariye wanekwika gibitamna akak pahow tip nopsadnano adahan ig padekwika parawhokwate. ");
INSERT INTO plu_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","―Apuriwnabay ku samah yihiyakemni. Ku pikebyi tarakse pikak, amawka pis akka gitaraksan git. Ku ig awna: “Hennewa nah tarakse,” ku ig wages gihiyakemni, uyá bayahminig ariw ini gitaraksan. ");
INSERT INTO plu_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ku ig taraksa pikak ntewnehkerput abet pahaynene hawkri, henneme ku ig ayá padoh pit ntewnehkerput ig awna: “Nah wageste nuhiyakemni,” ayge nikwe amawka ku pis bayahminig kibereput henne ariw gitaraksan. ");
INSERT INTO plu_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ayteke ariwnteke ini igkis giwatnipwi kinetihwenes gikak Kiyapwiye Jesus, igkis awna git: ―Kiyapwiye, uyá kiyesrih ukamaxwan ta gipitit Uhokri. ");
INSERT INTO plu_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Igme awna gitkis: ―Waké yis kamaxwa gipitit aynesnibe akiw, madikte yayapni humaw yitkam. Hiyawa yikamaxwan nopsesniyene ayesri ke pahow amutribe ayakbe ke “mostad” ayakbe, hiyawa in aynessanen henneme yayapni humaw yitkamnek. Yis ikkam adahan yis awna ta gut no ah akat nopsadminnano: “Ah, pis higihwa ayteke payak akak pihampabet. Su mutuhwa ta parawhokwate.” Pase yis awna inakni, eg higihwakam ayteke. ");
INSERT INTO plu_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","―Ku pahapwi ibukti kewne gikipara giwasra, ku kawk ku ig apuriwne gipig muttuh, ku aysaw ner ibukti diyuh ayta wasamdeteke ig gikipara ka awna git: “Barewba ax.” ");
INSERT INTO plu_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Kawa. Ig awna git: “Ba ayta sakahwa ndahan. Wihwa adahan pis ewk nuthu numana. Pis apuriwhun juktah ku aysaw nah pisenwa naxni nuhigpan. Ayteke butte pisme ax pisme higap.” ");
INSERT INTO plu_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ku ig gibuk iha inakni giwn, ig gikipara ka kabayha gibuk adahan ini gihpan mmanawa ig he kehnenenwa gannipwi. ");
INSERT INTO plu_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Yis hawwata ku aysaw yis keh madikte ku pariye Uhokri ayá yit, amawka yis awna: “Usuh ka ariknawnama. Usuh he ibuktinen. Usuh he kehnenenwa ku pariye muwaka adahan usuh keh.” ");
INSERT INTO plu_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ayteke ig Kiyapwiye Jesus tipik ta arimkat Jerusalém. Ig mpiya ayegbiw Samariyamnaw akak Galiléyamnaw. ");
INSERT INTO plu_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ig danuh ta apitit pahá paytwempu. Ayge ig patiptak gikakkis madikawku gikebyikis awaykemni ku pariye axpusakare apit busukne. Igkis tabirbet piyawakte aynessa. ");
INSERT INTO plu_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Igkis kabiman ta git: ―Kiyapwiye Jesus, uyá amnih usuh. ");
INSERT INTO plu_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ig timapni henne, ig kaytwa giwnkis: ―Nah amnihyi. Su akki yipit ta gitkis muwpeg kahadbe igkis iwasapyi, igkis hiyá ku yis kuwis makniw. Igkis timapni henne, igkis tipikwiye ta gitkis muwpeg. Ayge amun ini gitepkemnikis, pahaye adahan igkis makniwbet. ");
INSERT INTO plu_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Pahapwi gaytakkis ig hiyapni ku ig makniw, ig diyuhe gimkanit Kiyapwiye Jesus. Ig kabayha Uhokri akak madikte giwakemni. ");
INSERT INTO plu_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ig danuh atere git Kiyapwiye Jesus, ig tuguhkiswa mabuw gitiput, ig kabayhig atere. Ner awayg ig ka judeyenema ig hiyeg samariyene. ");
INSERT INTO plu_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ig Kiyapwiye Jesus hiyapni henne, ig wakaymni. Ig awna: ―Nah makniwe madikawku gikebyikis. Kineyki gikebyupwi? ");
INSERT INTO plu_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Mmah nah ka hiyaprikis igkis ayta diyuh kabayha Uhokri? Ignewa ner hiyeg kane judeyenema iggi kabayha Uhokri ay. ");
INSERT INTO plu_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ayteke nikwe ig awna git: ―Kannikaw. Hiyawa pis tipik. Pikamaxwan keh pis makniw. ");
INSERT INTO plu_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ayteke gaytakkis farisewkis danuh atere git Kiyapwiye Jesus. Igkis ayaypri: ―Kabet Uhokri gikumadukan danuh atan? Igme kaytwa giwnkis: ―Wis ka hiyá wisma hiyá Uhokri gikumadukan akak wowtyak. ");
INSERT INTO plu_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Wis ka hiyá wisma awna: “Ipeg ayta ku kiney Uhokri gikumadukan. Inin gikumadukan aytekihan.” Iné wis kawnata hiyá wisma awna: “Inatra gikumadukan ayhtéhan nawenéwa paytwempu.” Kawa. Mmanawa Uhokri gikumadukan in ay upit. ");
INSERT INTO plu_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ayteke ig awna ta gitkis gikannuhnipwi. Giwn: ―Aysawnemenek yis kaayhsima kadnibdi nuharit nah ku pariye wageswe awayg amadgaya inin. Apim ini yis hiyepkerepye nuhipak. Yis awnanek: “Waké ig danuh adahan pahaywowa hawkribe.” Henneme yis ka hiyapun ayge. ");
INSERT INTO plu_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Apim ini pahapwi awna ta yitnek: “Kuwis Cristo ay kuwis.” Pahapwime awnanek: “Ig ayhtéhan nawenéwa paytwempu.” Ka ba yi iha inakni giwnkis. Ka yi muwaka ipegpan atere. ");
INSERT INTO plu_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ku aysaw nuhawkanaprik danuh adahan naytni nah ku pariye wageswe awayg amadgaya inin ini naytni kahayak yit kabayhtiwanek. In kahayak ke ugugunebe in kahayak hamahwa ta pahambakat. ");
INSERT INTO plu_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Henneme apit in danuh amawka nah hiyá mbeyne kaayhsima. Amawka ku nah tukuhpika gapitkis hiyeg amedgenepwi inin. ");
INSERT INTO plu_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","―Nah ku pariye wageswe awayg amadgaya inin, ku aysaw nah danuh atan akiw, hiyeg gihiyakemnikis hawwata ke hiyeg gihiyakemnikisbe minikwakbe ku kapim amekene Noé amadga inin. ");
INSERT INTO plu_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Apim ini igkis ka aminama giw Uhokri. Igkis axnes, higepnes, maripkewnes, ku samah inpawa gikehnikis juktah ku aysaw ini hawkri danuh adahan ig amekene Noé katapta ta amadgat ginawya. Ayteke un digisase waxri in aniksase nerras hiyeg madikte. ");
INSERT INTO plu_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Hawwata akiw ku aysaw nah danuh atan akiw, hiyeg gihiyakemnikis kewa hiyeg gihiyakemnikisbe minikwakbe ku kapim amekene Ló amadga inin. Apim ini igkis kawnata aminama giw Uhokri. Igkis axnes, higepnes, igkis piyuknes, isimwiri, igkis mutuhnes giwasrakis, igkis paytya. ");
INSERT INTO plu_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Henneme ku kapim ig amekene Ló pese apititak paytwempu Sodoma, ayge nikwe tiket payebitak akak ini pusukempiye ku pariye bixiwanene arihri in tuguhe inugiktak. In tuguh kaayhsima ke muwokbe waykempiyebe. In umahape nerras hiyeg madikte. ");
INSERT INTO plu_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Aysawnemenek in hawwata danuh ke minikwakbe, ku aysaw nah ku pariye wageswe awayg amadgaya inin nah hiyapkiswa akiw. ");
INSERT INTO plu_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Apim ini yis ka muwaka wakaymni aharit yewkanbet amedgene inin. Ku pahapwi gipin higiwmadga, ig ka muwaka wakaymni aharit gewkanbet ku pariye agikunene gipin adahan ig diyuh iwepni. Ku pahapwi ayhté amadga giwasra ig kawnata muwaka diyuh ta gipinwat akiw. ");
INSERT INTO plu_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Kiyemnahnabay gumin amekene Ló gihayo. Eg ka wiwh guyakni apititak paytwempu Sodoma, eg biyuke. ");
INSERT INTO plu_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Pahapwi ku pariye ka wiwhkere giyakni apititak giwskawni amadgatak inin, iggi biyuk akak giwskawni giwntak Uhokri. Henneme pahapwi ku pariye miyeh gidahanwa giwskawni amadgatak inin, iggi darih giwskawni giwntak Uhokri. ");
INSERT INTO plu_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Hennewa nukebyupwi. Apim ini hawkri ndawnhan, piyana gikebyikis awaykemni himeknes amadga pahak iwetrit tiyegim. Pahapwi iwepkanek, pahapwime ikiswika. ");
INSERT INTO plu_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Hawwata akiw piyana gukebyikis tinogben kukwanos payak. Pahapu iwepkanek, pahapume ikiswika. ");
INSERT INTO plu_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Hawwata akiw piyana gikebyikis awaykemni ay amadga giwasrakis. Pahapwi iwepkanek, pahapwime ikiswika. ");
INSERT INTO plu_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Igkis gikannuhnipwi timapni henne, igkis awna git Kiyapwiye Jesus: ―Kineykin danuh, Kiyapwiye? Igme kaytwa giwnkis akak pahat yuwit patuwesbuhka. Ig awna: ―Ku kiney wis hiyá isuw ugewwé, wis hiyakni kuwis ku arikna miyapwiye ayge. Hawwata naytninek, yis hiyapni huwewehe. Apim ini metakwa yis hiyakninek. ");
INSERT INTO plu_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ayteke ig Kiyapwiye Jesus awna gitkis pahat yuwit patuwesbuhka adahan ig ikene gawaygyikis adahan igkis piriyepkaw takunipti, adahan igkis ka miniw ariw gipigyepkawnikis. Ig awna: ");
INSERT INTO plu_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","―Minikwak pahapwi hiyaptigi msakwa apit pahá paytwempu. Ig ka hiyepkere ariknawnama, iné hiyeg iné Uhokri. ");
INSERT INTO plu_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Hawwata pahapu madankuno ayge apit ini paytwempu. Takunipti eg atere git ner hiyaptigi eg awna git: “Uyá amnihun. Wadithebdih nuhawkan gikak nupetunya.” ");
INSERT INTO plu_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Pitatye ig ka amnihgu. Henneme amaksemni ig awna gitwa: “Nah ka hiyepkere ariknawnama, iné hiyeg iné Uhokri. ");
INSERT INTO plu_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Henneme no tino kaayhsima sigimwihun. Nikwe nah wadithebdih guhawkan marihwa eg ka ayta kiyimwihun takuniptima.” ");
INSERT INTO plu_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ayteke ig Kiyapwiye Jesus awna gitkis gikannuhnipwi: ―Timapnay ku samah ner hiyaptigi ku pariye kane kibeynema ig iha guwn no ku pariye amnihswano git takunipti. ");
INSERT INTO plu_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ku yis hiyá ig amnihgu, igkata Uhokri akiw ig ka amnih gihiyegapu ku pariye amnihswene git takunipti? Mmah ig ayipwihwa adahan ig amnihgikis? ");
INSERT INTO plu_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Kawa. Ig amnihpigkis kibentenwa. Henneme ku aysaw nah ku pariye wageswe awayg amadgaya inin, ku aysaw nah danuh atan akiw, ba nah utí hiyeg amadga inin ku pariye gidukweneswa kamewnene ta nupitit? ");
INSERT INTO plu_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Hawwata akiw ig Kiyapwiye Jesus awna pahat yuwit patuwesbuhka gidahankis hiyeg ku pariye ikawnamah wadityepwi ignes ikaw kabayte giw pahapwi. ");
INSERT INTO plu_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Ig awna: ―Piyana gikebyikis awaykemni wagehe pareke ta agikut ini leglis kewye Uhokri Gipin adahan igkis piriyepkewnes atere. Pahapwi farisew. Pahapwime ladwan kinisekeputne. ");
INSERT INTO plu_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ig farisew tabira ayge giwtrikkis hiyeg ig piriyepkaw gitwa. Ig awna: “Kibeyne Uhokri, nah ka keh mbayka kema nawenépwi hiyegma. Nah ka amepyema, nah ka taraksa, nah ka powkemnihwa. Kibeyne, nah ka kema nerma ladwanma. ");
INSERT INTO plu_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Kibeyne nah maxhaw pimaput abet mpuse paka adahan nah pikiyetni. Nah keh ofan pidahan. Nah wiwh pahá ariwntak mpuse araytak madikawku newkanbet adahan nah kakanhaw pit.” Hennewatbaki giwn ig awna. ");
INSERT INTO plu_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Igme ner ladwan ig marenpi tabira giwtrikkis hiyeg, ig tabira piyawakte giwkis. Ig ka kibowka ipeg giwtrikut Uhokri adahan ig awna git. Ig msekwe baruki. Ig awna: “Uhokri, uyá amnihun nah taraksepye.” ");
INSERT INTO plu_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ig ner awayg ignewa diyuhe gipinekut ig wadit giwtrik Uhokri. Nerme farisew ka hennema. Mmanawa ku pahapwi ikewkere kiyatte mpiye pahapwi, iggi Uhokri wiwhe gikiythani gipititaknek. Henneme ku pahapwi ikewpiye ke wotbe ig yumahbe gikiythanibe, iggi Uhokri ikí gikiythani ta gipititnek. ");
INSERT INTO plu_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ayteke hiyeg danuh atere git Kiyapwiye Jesus. Igkis waxe gikamkayhkis ta git adahan ig sarayh giwak gipititkis adahan ig kiyene Uhokri gidahankis. Juktah igkis ewk bakimnay nukupesniye git. Ignesme gikannuhnipwi hiyapni henne, igkis awna gitkis adahan igkis ka ayta sigimwihgi. ");
INSERT INTO plu_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Igme Kiyapwiye Jesus hiyapni henne, ig waysase nerras bakimnay ta gimkanit. Ig awna gitkis gikannuhnipwi: ―Isaksanabay bakimnay ites aytnite numkanit. Ka yi muwaka mpitha bakimnay. Mmanawa ku pariye hiyeg gihiyakemnikis kene bakimnibe ignesnewa ku pariye kawih Uhokri gikumadukan. ");
INSERT INTO plu_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Henneme ku pahapwi ka iha giwn Uhokri gikumadukan kema pahapwi bakimnima, iggi ka kawih Uhokri gikumadukan. Ihanabay inakni nuwnhu. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ayteke pahapwi awayg kiyatye danuh atere git Kiyapwiye Jesus. Ig awna git: ―Kiyapwiye, pis kibeynewa. Uyá akki nuthu. Pariye nah keh kuri adahan nah aymuhwa gimun Uhokri adahan apanenekwa? ");
INSERT INTO plu_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Igme Kiyapwiye Jesus kaytwa giwn: ―Mmah pis kanumun ku nah kibeyne? Yuma pahapwinama hiyeg amadgaya inin kibeyne. Uhokri ignewa ku pariye kibeyne hiyeg. ");
INSERT INTO plu_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Pis kuwis hiyak ku pariye amawka pis keh adahan pis aymuhwa gimun Uhokri adahan apanenekwa, mmanawa pis hiyak amekene Moís gikumadukan kuwis. Inakni gikumadukan awna: “Ka muwaka powkemnihwa. Ka muwaka umah hiyeg. Ka muwaka amepwi. Ka muwaka wasaymhaw. Kiyatha pig. Kiyatha pinag.” ");
INSERT INTO plu_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Igme awayg awna git: ―Kiyapwiye, ku samah nah takwa nah iha madikte inakni yuwit. ");
INSERT INTO plu_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Igme Kiyapwiye Jesus timapni henne, ig awna git: ―Pehete muwak pit ku pariye pis kote ihpate. Amawka pis batek gikak Uhokri mpiya madikte pewkanbet. Ataknaba piyuk pewkanbet madikte. Ayteke nikwe pis ikí akakurapig ta gitkis madiptapye. Ayge nikwe pis utí kaayhsima igiska ayhté inugiknek. Ayteke pisenwa papiykan pewkanbet pis ayta wew nukakhu. ");
INSERT INTO plu_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Igme awayg timapni henne, ig wakaymni ig barukiswe kaayhsima mmanawa kaayhsima igiska ay gimun. Ig apise ku nawenétke ig biyuk akak ini gewkanbet. ");
INSERT INTO plu_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ig Kiyapwiye Jesus hiyapni henne, ig ipeg ta gimkat ig awna ta gitkis hiyeg: ―Kaayhsima mahiko adahan hiyeg igisapye kawih Uhokri gikumadukan. ");
INSERT INTO plu_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ku yis hiyá ku mahiko adahan pahapwi puwikne “kamelu” parak mapiya apuriku pahat kakus amiyokni, in pi mahikote akiw adahan pahapwi igisye parak ku kiney Uhokri gikumadukan. ");
INSERT INTO plu_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Igkis hiyeg timapni henne, igkis awna: ―Ta wothu ku pahapwi igisye, in arakak ku ig kibeyne giwtrik Uhokri mmanawa ig kabunuga gikak Uhokri. Ku mahiko henne adahan igisapye danuh git Uhokri, nikwe yuma hiyeg amadgaya inin danuhne git Uhokri. ");
INSERT INTO plu_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Igme Kiyapwiye Jesus awna gitkis: ―Madikte hiyeg ka hiyá ignesma danuh git Uhokri ku ka igma Uhokri amnihgikis. Mmanawa ku pariye hiyeg amadgaya inin ka hiyá akehka igme Uhokri hiyá nikehka. ");
INSERT INTO plu_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Igme kiyapwiye Pedru awna git: ―Usuh kuwis ikise madikte wewkanbet adahan usuh wewne pikak. ");
INSERT INTO plu_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Igme Kiyapwiye Jesus kaytwa giwn: ―Ku pahapwi ikiswiye gipin gukak gihayo, gikebyupwi, ginag, gig, gikamkayupwi, ku ig ikiswiye madikte giharit Uhokri gikumadukan, ");
INSERT INTO plu_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ig utí nikwe kaayhsima akiw. Ig utí kuri amadga inin hawkri pi kibite gikebyupwi akiw. Hawwata akiw aysawnemenek ayhté inugik ig aymuhwanek gimun Uhokri adahan apanenekwa. Ihanabay inakni nuwnhu. Hennewatbaki ig utinek. ");
INSERT INTO plu_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ayteke ariwnteke ini ig Kiyapwiye Jesus pahadguh giwatnipwi (12) ta git, ig awna gitkis: ―Kuri wixwiy atak ta arimkanit Jerusalém. Ayge nah hiyá madikte mbayka danuh nuthu ku pariye Uhokri gawnepepu pitatyepwi kinetihwa numinhu nah ku pariye wageswe awayg amadgaya inin. ");
INSERT INTO plu_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nah kamaykiswikanek ta gitkis hiyeg kane judeyenepwima. Igkisme arewhe nuthunek. Apim ini igkis mahipwihpen, igkis tupestepun. ");
INSERT INTO plu_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Igkis biptepun akak tigay. Pisenwa nikwe igkis umehpen. Henneme amamnam hawkrinek nah kannikaw akiw. ");
INSERT INTO plu_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Igkis giwatnipwi timá inakni giwn henne, henneme igkis ka pukuhpin. Gihiyakemnikis sab adahan igkis ka pukuhpin. Igkis ka hiyak ku kamin ig kinetihwa. ");
INSERT INTO plu_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ayteke igkis danuh apaknit paytwempu Jerikó. Apiminewa ini pahapwi motpiye bat ayge ahinmu. Ig makehpene karukri ta gitkis hiyeg. ");
INSERT INTO plu_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Pahaye adahan ig timá hiyeg kabaru mpiya. Ig awna: ―Mmahki igkis hiyeg mpiye kabaruhpad? ");
INSERT INTO plu_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Igkisme kaytwa giwn: ―Kiyapwiye Jesus nazaréyene iggi mpiyepye. ");
INSERT INTO plu_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ig ner motpiye timapni henne, ig kabiman git Kiyapwiye Jesus: ―Kiyapwiye Jesus, pis ukipara hawwata ke amekene Davibe. Uyá amnihun. ");
INSERT INTO plu_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Nerras hiyeg ku pariye gapitkiya Kiyapwiye Jesus igkis timapni henne, igkis himehpig. Igkis awna ta git: ―Ka muwaka kabiman henne. Igme pi kabimenpipa akiw. Ig awna: ―Kiyapwiye, pis ukipara hawwata ke amekene Davibe. Uyá amnihun. ");
INSERT INTO plu_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ig Kiyapwiye Jesus timapni inakni gabiman henne, ig msekwe. Ig awna: ―Su iwapri. Waxwanig atan nuthu. Igkisme ihe giwn. Ig ner motpiye danuh atere git, igme awna git: ");
INSERT INTO plu_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―Pariye pimawkan nuthu? Igme kaytwa giwn: ―Kiyapwiye, nah muwaka nah hiyap akiw. ");
INSERT INTO plu_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Igme Kiyapwiye Jesus awna git: ―Kuri pis hiyap. Pikamaxwan nupitit keh pis makniw. ");
INSERT INTO plu_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Aynewa ig motpiye hiyap. Ayteke ig tipik makekwepi gihapu, ig kibeyhene Uhokri ayge. Madikte nerras hiyeg ayge igkis hiyapni henne, igkis kabayha Uhokri hawwata akiw. ");
INSERT INTO plu_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ayteke ariwnteke ini ig Kiyapwiye Jesus danuh ta apitit paytwempu Jerikó. Ig mpiyepye ayegbiw paytwempu. ");
INSERT INTO plu_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ayge pahapwi awayg giw Zakew. Ig ladwan gikiparakis. Ig kaayhsima igisye. ");
INSERT INTO plu_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ig hiyepkerepye Kiyapwiye Jesus ku pariyene ig, henneme ig ka hiyá igma hiyapri awaku ig wakatésa. Kaayhsima hiyeg ayge kabubuk ganwa mpithe gipegyi. ");
INSERT INTO plu_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ig hiyapni henne, ig sigise bukihne Kiyapwiye Jesus apigku ini ahin ku kitwiye ig. Ig uté pahat ah akat ig wagehe apewit adahan ig hiyapri ayteke. ");
INSERT INTO plu_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ayteke nikwe ig Kiyapwiye Jesus danuh atere. Ig sarayh gipegyi ta inut, ig hiyá kiyapwiye Zakew ayge apew ah, ig awna git atere: ―Kiyapwiye Zakew. Uyá muhuk kibentenwa. Nah danuhpene ta pipinekut ku apim inin. ");
INSERT INTO plu_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Igme kiyapwiye Zakew timapni henne, ig muhuke, ig amapig ta gipinekut akak madikte gibetki. ");
INSERT INTO plu_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nerras hiyeg hiyapni henne, igkis minimnihegbet gimin Kiyapwiye Jesus. Igkis awna: ―Ig darihwekne gikak pahapwi ku pariye kane kibeynema. ");
INSERT INTO plu_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Igme kiyapwiye Zakew tabir ayge giwtrikkis hiyeg, ig awna git Kiyapwiye Jesus: ―Kiyapwiye, nah kakanhawte ta gitkis madiptapye abusku newkanbet. Hawwata akiw ku nah katiwnihkis git pahapwi mpiynepepye, nah diyuhkis gikakura mapiy akiw paxkaput akiw. ");
INSERT INTO plu_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ig Kiyapwiye Jesus hiyapni henne, ig awna: ―Ku apim inin ig kiyapwiye Zakew isamtaw payebitak gikakkis gimunyapu. Ig hawwata amekene Abrawh gihiwhi hawwata ke yisbe henneme pitatye ig ke wotbe ig biyukwiyebe giw Uhokri. ");
INSERT INTO plu_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Nah ku pariye wageswe awayg amadgaya inin nah ayta adahanikwa nah ipegepye hiyeg biyukapye adahan nah gamnihtenkis. ");
INSERT INTO plu_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ayteke ig awna ta gitkis nerras timepnepwi pahat yuwit akiw patuwesbuhka yuwit. Ig awna inakni yuwit giminwa awaku ig kennesmin gidawnhan apitit Jerusalém nerras hiyeg gipewkankiskam ku pase ig danuh atere Uhokri gikumadukan kapusakam. ");
INSERT INTO plu_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ig awna: ―Minikwak pahapwi awayg kiyatye tipikwiye ta apitit pahá waxri akiw ku pariye piyawakad. Ig atere adahan ig wageswepye ikiparat gidahankis hiyeg ayge ku kiney ig msakwa ayteke ig diyuh akiw. ");
INSERT INTO plu_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Apit gitepkemni ig pahadguh gibukpig madikawku gikebyikis. Ig ikise mpuse giwakuitkis pahamku karukri nopsad karukri wahano seyno. Ig awna gitkis: “Kannipwinabay gukak no karukri juktah ku aysaw nah diyuh akiw.” Ayteke ig tipik. ");
INSERT INTO plu_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Henneme gaytakkis hiyeg ku pariye msekwenepwi ayge ku kiney ig msakwa ignes amiyhepri. Pase ig tipik igkis wasapanaw gimin gikipara. Igkis awna git gikipara: “Usuh ka muwaka ner awayg humaw ukipara.” ");
INSERT INTO plu_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Igme gikipara ka aminama ariw inakni giwnkis. Ig ner awayg danuh atere, ig gikipara iké madikte hiyeg ku pariye msekwenepwi ayge ta giwakuit adahan igme gikumaduketnikis ayge. Ig awayg hiyapni henne, ig diyuhe akiw. Ig danuh ta gipinwat, ig pahadguh nerras gibukpig ku kawakuit ig ikí karukri. Ig muwaka hiyak ku samah igkis kannipwiyes gukak no karukri ba kuwisma eg kiyestenma. ");
INSERT INTO plu_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Igme ner pitatye gibuk danuh atere git, ig awna git: “Kiyapwiye, akak no karukri ku pariye pis ikise nuwakuit nah kuwis utí madikawkumku akiw pidahan.” ");
INSERT INTO plu_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Igme gikipara timapni henne, ig awna git: “Kibeyne. Pis kibeyne awayg. Ku samah pis kuwis kannuh kawih aynessa arikna kabayhtiwa ndahan, kuri nikwe nah ikí ta piwakuit paytwempu madikawku akebyi.” ");
INSERT INTO plu_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ayteke ig ner apeynipye gibuk danuh atere. Ig awna git: “Kiyapwiye, akak no karukri ku pariye pis ikise nuwakuit nah kuwis utí pohowkumku akiw pidahan.” ");
INSERT INTO plu_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Igme gikipara timapni henne, ig awna git: “Pis hawwata nah ikí ta piwakuit paytwempu pohowku akebyi.” ");
INSERT INTO plu_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ayteke pahapwiwa gibuk akiw danuh atere. Ig awna git: “Kiyapwiye, ahah pikakura. Nah he msekwepi gukak. Nah wanakamkuhpig abet kamisbet. ");
INSERT INTO plu_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nah ka kannipwi gukak no karukri pidahan awaku nah marenpi pibohri nah hiyakni ku pis pi kannuhte nuwhu. Pis kapannusima. Ku kiney pis ka ikis ariknawnama, hiyawa kuwewanek pis atere iwé kaayhsima arikna ayteke. Ku kiney pis ka mutuh ariknawnama, hiyawa kuwewanek pis atere iwé kaayhsima amutri ariw ayteke.” ");
INSERT INTO plu_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Igme gikipara kaytwa giwn: “Pis mbeyepye pihiyakemni! Inakni piwn arekhetni ku samah pihiyakemni ka wadit. Ku pis kuwis hiyakni ku nah kanannusima, mmahki nikwe pis ka battukaw kannipwi ndahan? Pis kuwis hiyakni ku kiney nah ka ikis ariknawnama, hiyawa kuwewanek nah iwé kaayhsima arikna ayteke. Pis kuwis hiyakni ku kiney nah ka mutuh ariknawnama, hiyawa kuwewanek nah iwé kaayhsima amutri ariw ayteke. ");
INSERT INTO plu_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Kiskama pis kawihpinkam ndahan ini ku pariye nah ikise ay piwaku. Mmah nikwe pis ka ikí nukakura ta agikut payt abeyheki karukri adahan ignes hiyeg ayge sunapkis ini nukakura ta gitkis nawenépwi hiyeg kahadbe ku aysaw nah danuh atere, ignes diyuhkis nukakurakam apitminakama ta nuthu?” ");
INSERT INTO plu_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ayteke ig awna ta gitkis nerras hiyeg ayge gihumwa. Giwn: “Iwepnay giw no karukri pahamkunano adahan yis ikepni git ner ku pariye kuwisnene kadahan madikawkumku gikakura.” ");
INSERT INTO plu_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Igkisme awna git: “Kiyapwiye, ig kuwis kadahan madikawkumku gikakura kuwis. Ikeypi.” ");
INSERT INTO plu_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Igme gikiparakis kaytwa giwnkis, ig awna: “Ka sam. Ku pariye darih kaayhsima, iggi ikakka git pi kiyeste akiw. Henneme ku pariye ka darih kiyestema, nikwe in iwepka giw ini ku pariye ig kuwis kadahan. Hennewatbaki in iwepka.” ");
INSERT INTO plu_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ayteke ariwnteke ini ig gikiparakis awna gitkis: “Kuri, su yis atak kamax nerras nupetunyapu ku pariye kane muwaka nah humaw gikiparakis. Waxnigkis ayta nuthu adahan yis pisenwa gikakkis ay nuwtrik.” ");
INSERT INTO plu_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Pisenwa gawnhan inakni giwn, ig Kiyapwiye Jesus tipiknene akiw gapitkis pitati ta arimkanit Jerusalém. ");
INSERT INTO plu_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ig danuh atere apitit ini waxri imuhgipitnene kewye Olipegpit. Ig kennesmin arit paytwempu ku pariye nopsanyupwinen kewye Betfajé akak Betâniya. Ayge ig awahkis piyana giwatnipwi adahan igkis ta sunepnes gidahan pahapwi kaway. ");
INSERT INTO plu_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ig awna gitkis: ―Ataknabay ta apitit ini paytwempu nopsanyupnene pahambakaytak. Parakantenwa yis hiyá pahapwi kawayyan “jumentinyu”. Ayge ig wanak. Hiyeg kote batte giduhyamadgat. Wataknig waxwanig atan nuthu. ");
INSERT INTO plu_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ku hiyeg ayge awna yit: “Mmeneki yis dax?” yisme kaytwa giwnkis: “Kiyapwiye muwakapri.” ");
INSERT INTO plu_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Igkis giwatnipwi timapni henne, igkis tipik. Igkis danuh atere, igkis utí madikte ku samah ig Kiyapwiye Jesus akki gitkis. ");
INSERT INTO plu_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ayteke nikwe igkis watekwiyes ner kawayyan. Igkis watekempiye, ignes akipara danuh atere. Igkis awna gitkis: ―Mmeneki yis dax yis watak upig kawayyan? ");
INSERT INTO plu_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Igkisme kaytwa giwnkis: ―Kiyapwiye muwakapri. ");
INSERT INTO plu_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ayteke igkis diyuhe waxe ner kawayyan ta gimkat Kiyapwiye Jesus. Igkis danuh atere, igkis amboha gidagmanpitkis ta giduhyamadgat kawayyan. Ayteke igkis wagahkise Kiyapwiye Jesus ta giduhyamadgat. ");
INSERT INTO plu_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ayteke nikwe ig tipikwiye. Nerras hiyeg ayge igkis hiyapni henne, igkis barewha ahin gapit pitati. Igkis awasaprike ahin akak gidagmanpitkis. ");
INSERT INTO plu_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ig kennesmin gidawnhan ta apitit Jerusalém, igkis muhukwiyes aseb ini waxri imuhgipitnene Olipegpit. Apim ini madikte gikannuhnipwi kabubuknene ayge, igkis batek ginaktinkis. Igkis kapusa kabayha Uhokri akak madikte gibetkikis adahan madikte annut ku pariye igkis hiyá ig keh. ");
INSERT INTO plu_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Igkis awna: ―Uhokri gabay gikaknek ner Ukiparawiy ku pariye ayta giwaprik Uhokri. Batekka ayhté inugik. Kibeyne gidahan Uhokri! ");
INSERT INTO plu_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Nerras farisewkis ku pariye ayge gibetkis hiyeg igkis timapni henne, igkis awna ta git Kiyapwiye Jesus: ―Kiyapwiye, wani nerras pikannuhnipwi ka muwaka awna inakni henne. ");
INSERT INTO plu_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Igme kaytwa giwnkis: ―Amawka ku igkis awna inakni henne. Waké igkis ka awnabe henne, no tip kabimankama akak batekka giwenyankiskama. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ayteke ig Kiyapwiye Jesus danuh kennesa arimkat paytwempu Jerusalém. Ig sarayh gipegyi atere, ig kadni gidahankis madikte hiyeg ayge. Ig biyuk gikan ig tihene ayge. ");
INSERT INTO plu_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ig awna: ―Aa, yis hiyeg paytwempuyenepwi. Nah kaayhsima muwaka yis hawwata kadahan batekka ku apim inin. Henneme ku apim inin yis ka hiyá ahiyaka ");
INSERT INTO plu_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Inneki keh aysawnemenek yis hiyá mbeyne kaayhsimanek. Yipetunyapu danuh atannek igkis kiyarewnihpey akak wayk atikka. Igkis mpithepyi muwwapu adahan yis ka pes. ");
INSERT INTO plu_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Apim ini igkis umehpey. Igkis mehe yipinnek madikte. Igkis ka ikis pahownama tip papitmintak akak guyaki tip. Yis hiyá madikte ini mbeyne awaku yis mahikohpen apim ini ku aysaw nah danuh atan adahan yamnihten. ");
INSERT INTO plu_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Pisenwa gawnhan inakni yuwit ig tipik. Ig pareke ta agikut ini leglis kewye Uhokri Gipin. Ayge ig uté hiyeg ku pariye piyuknepwi puwikne akak kuhipra adahan hiyeg kakanhewne ta git Uhokri. Ig hiyapni henne, ig ipukwapeprikis. ");
INSERT INTO plu_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ig awna gitkis: ―Uhokri gannasan minikweknene awna: “Inin nipinhu ini piriyepkewket.” Yisme kehne gipin humaw amepwiyeket. ");
INSERT INTO plu_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ayteke ariwnteke ini ig Kiyapwiye Jesus kannuhekne takunipti ayge agiku ini Uhokri Gipin. Nerras muwpeg kiyatyepwi gikakkis nerras kannuhekeputnepwi amin amekene Moís gikumadukan gikakkis awaykemni kiyatyepwi ayge Jerusalém igkis ipegminene gihiyakemnikis, igkis awna: ―Mmenepri wixwiy hiyá giwmepka kuri? ");
INSERT INTO plu_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Henneme igkis ka hiyá gisamanak. Mmanawa madikte hiyeg kiyatha Kiyapwiye Jesus, igkis ataybiswa git kabayhtiwa. ");
INSERT INTO plu_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Apim ini hawkri ku samah Kiyapwiye Jesus kannuhekne ayge agiku leglis, ig ekkene Uhokri ginetni ayge, nerras muwpeg kiyatyepwi gikakkis nerras kannuhekeputnepwi amin amekene Moís gikumadukan gikakkis nerras judeyenepwi giwewkistenkis igkis patiptakig atere. ");
INSERT INTO plu_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Igkis ayapri: ―Mmahka pis keh ini ku pariye pikehni ay? Kariwntak pis utí pikumadukan adahan pis keh henne? ");
INSERT INTO plu_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Igme kaytwa giwnkis: ―Nah hawwata ayapyi pahat ayapka. Uyay akka nuthu. ");
INSERT INTO plu_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Kariwntak amekene João Batistamni utí gikumadukan adahan ig kaywa hiyeg? Ba giwntakwatma Uhokri? Ba kawk ba he giwntakkisnenwatma hiyeg amadgayapu inin? ");
INSERT INTO plu_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Igkis timapni henne, igkis kinetihwa pawtak adahan ahegbetepye ginetnikis. Ayge igkis awna: ―Ku wixwiy kaytwa giwn ku ig amekene João Batistamni utí gikumadukan giwntakwa Uhokri, nikwe ig awne wotwiy: “Mmahki nikwe yis ka iha giwn?” ");
INSERT INTO plu_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Henneme ku wixwiy kaytwa giwn ku ig utí gikumadukan he giwntakkisnen hiyeg amadgayapu inin, nikwe madikte nerras hiyeg ay padaktepwiynek. Mmanawa gitkis ig amekene João Batistamni ignewa Uhokri gawnepe. ");
INSERT INTO plu_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ayteke nikwe igkis kaytwa giwn Kiyapwiye Jesus: ―Usuh ka hiyak ku kariwntak ig utí gikumadukan. ");
INSERT INTO plu_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ayge nikwe igme Kiyapwiye Jesus awna gitkis: ―Ku samah yis ka akki nuthu, nikwe nah kawnata akki ta yit ku kariwntak nah utí nukumadukan adahan nah kehne ini ku pariye nukehni ay. ");
INSERT INTO plu_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ayteke nikwe ig Kiyapwiye Jesus kapusa awna pahat yuwit patuwesbuhka ta gitkis madikte hiyeg ayge. Ig awna: ―Minikwak pahapwi awayg mutuhe giwasra. Giwasra “uvapunen”. Ayteke ig ibekhe giwasra pabakak gikakkis hiyeg ku pariye nikapriwten. Pisenwa ig tipik ta apitit pahá waxri akiw. Ig atak adahan ayipwite. ");
INSERT INTO plu_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ku aysaw danuh apatyaprik amutri, ig awahkise pahapwi gihiyega ta giminkis nerras akapriwten was adahan igme iwepye abusku gamutra guw amadgatak giwasra adahan ewkwiye ta git. Igkisme akapriwten was igkis kamaxe ner gihiyega. Igkis biptepri. Ayteke igkis awahkiswig hennen. Igme tipik danuh ta git gikipara yuma ariknawnama giwaku. ");
INSERT INTO plu_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ig was akipara hiyapni henne, ig awahkise pahapwiwa gihiyega atere akiw. Igme danuh atere, igkis keh hawwata gikak akiw. Igkis biptepri, igkis mahipwihpig, igkis awahkiswig hennen yuma ariknawnama giwaku. ");
INSERT INTO plu_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ayteke nikwe ig was akipara awahkis pahapwiwa gihiyega akiw atere giminkis. Igme danuh atere, igkis huwipwihpig, igkis padekwig. ");
INSERT INTO plu_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ig ner was akipara hiyapni henne, ig awna: “Mmah nah keh kuri? Aah, nah kuwis hiyak ku pariye nah keh kuri. Nah awahkiste nukamkayh nubetki atere giminkis. Nawenétke ner nukamkayh igkis kiyatha.” Nikwe ig awahkiswig atere giminkis. ");
INSERT INTO plu_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Henneme nerras akapriwten was pase igkis hiyé gikamkayh ig nemnik, igkis amiyhepri. Igkis kinetihwa pawtak, igkis awna: “Nernewa was akipara gikamkayh. Uyay umehpig mpinekata kuwewanek ini was msekwe madikte gidahan. Pi kabayte wixwiy umehpig adahan ini was msekwe udahanwiy.” ");
INSERT INTO plu_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ayteke nikwe igkis tukuhpig ayteke amadgatak giwasra igkis umehpig. Pisenwa gawnhan inakni yuwit patuwesbuhka, ig Kiyapwiye Jesus awna gitkis: ―Uyay akka nuthu. Pariye yipewkan ig was akipara keh gikakkis nerras akapriwten giwasra nikwe? ");
INSERT INTO plu_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nah akkite yit. Ig ayta pisenwa gikakkisnek. Pisenwa nikwe ig ibakha giwasra pabakak gikakkis nawenépwi hiyeg akiw. Igkis timapni henne, igkis awna: ―Gikak Uhokrinek in ka danuh. ");
INSERT INTO plu_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Igme ipegkeke gikakkis, ig awna gitkis: ―Ka ba yis hiyá ku Uhokri gannasan minikweknene kinetihwa amin inakniwata hiyakemniki? In awna: “Hiyeg kehne pahá payt tiptiye, igkis tukuhe pahow tip. Gipewkankiskam ku eggu tip ka kawihkam. Bawa eg tip eggu pi awaygtenano ariw madikte. Eg humaw adahan payt akoksa. ");
INSERT INTO plu_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ku pariye hiyeg teswiye ta gupitit no tip igkis tuguhe dunibdiwaruhpikisnek. Egme no tip ku eg tuguhe ta gipititkis hiyeg, batewbetwaruhpi igkis.” Hennewatbaki ig Uhokri gannasan awna. ");
INSERT INTO plu_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Nerras muwpeg kiyatyepwi gikakkis nerras kannuhekeputnepwi amin amekene Moís gikumadukan igkis timapni henne, igkis pukuhe ku ig Kiyapwiye Jesus awna inakni yuwit giminkis ku samah igkis tukuhptepri. Ayge nikwe amun inakni igkis mpiksaw giharit adahan gikamaxwitni. Henneme igkis apisemun gibohrikis nerras hiyeg timepnepwi giwn ayge awaku ignes hiyeg kiyathe Kiyapwiye Jesus. Inneki keh igkis ikiswig. Igkis tipik. ");
INSERT INTO plu_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Henneme igkis apuriwgi kabayhtiwa. Igkis awahkis hiyeg yawayapu atere gimin adahan gayaminetni ke wotbe igkis awna apititakwatbe giyaknikis bawa kawa igkis he kinisnenri. Igkis aharitnes adahan ig awna arikna taraksebet adahan igkis gimetkepten adahan igkis kamaykiswig ta git hiyaptigi. ");
INSERT INTO plu_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ayteke nikwe igkis danuh atere git Kiyapwiye Jesus, igkis awna git: ―Kiyapwiye, usuh hiyakpi ku pis awna wadit pis kannuhak wadit. Pis ka awna mpusema yuwit gidahankis hiyeg. Pis awna pahatwowa yuwit ta gitkis madikte hiyeg. Hiyawa hiyeg gihiyakemnikis nawenéwa ariw pidahan henneme in ka sam ta pit. Pis awna pahatwowa yuwit. Pis akki Uhokriyerwa gihiyakemni gitkis. ");
INSERT INTO plu_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Kiyapwiye, usuh muwaka hiyak pahat hiyakemniki. Ig kiyapwiye Sésar nerras romayenepwi gikiparakis ig mpiksaptih wixwiy hiyeg judeyenepwi adahan wixwiy katiwnihgi. Ba wadit adahan wixwiy katiwnihgi? Ba ka wadit? ");
INSERT INTO plu_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Igme Kiyapwiye Jesus kuwis hiyakni ku igkis awna inakni adahan gikinsepten. Ig hiyapni henne, ig awna gitkis: ");
INSERT INTO plu_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","―Uyay akka nuthu pahamku karukri. Igkis timapni henne, igkis iwé pahamku karukri igkis ewkwig ta git. Ayteke nikwe ig ayaprikis: ―Pariyepa kahehpakye gumadga no kirehka? Pariyepa kewye ay gumadga? Igkisme kaytwa giwn: ―Inin kiyapwiye Sésar giw. Inin ahehpakti kiyapwiye Sésar gahehpak. ");
INSERT INTO plu_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Igme awna ta gitkis: ―Nikwe no karukri kawih gidahan kiyapwiye Sésar. Hiyawa wixwiy ikepru git. Henneme amawka ku wixwiy ikí ta git Uhokri madikte ku pariye kawih gidahan Uhokri. ");
INSERT INTO plu_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Nerras hiyeg ka hiyak gisamanak adahan igkis keh ig awna yuwit taraksebet adahan igkis matekepri ayge gibetkis hiyeg. Igkis timapni henne ku ig kaytwa giwnkis kabayhtiwa, igkis wakaymnibdi gidahan. Igkis he barukebdi msekwe. ");
INSERT INTO plu_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ayteke ariwnteke ini nawenépwi hiyeg danuh atere git Kiyapwiye Jesus akiw. Igkis hiyeg sadusewkis. Gitkis sadusewkis hiyeg miyá ignes pisenwe gihawkankis ignes ka kannikaw akiw. Igkis danuh atere, igkis awna git: ");
INSERT INTO plu_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Kiyapwiye, amekene Moís tamakkis gikumadukan amadga kagta udahanwiy. Inakni gikumadukan awna: “Ku pahapwi hiyeg miyá guw gihayo, ku ig yuma gikamkayh gukak eggu gihayo, nikwe amawka gikebyi maripkaw gukak eggu giwgun marihwa eg kakamkayh hawwata ke wotbe ignebe gikebyibe kakamkayh gukakbe.” Hennewatbaki ig amekene Moís gikumadukan awna. ");
INSERT INTO plu_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Boh. Minikwak ntewnehker gikebyikis. Ig eggutye maripkew gukak pahapu tino. Ayteke ig miyap kawke ig kakamkayh gukak. ");
INSERT INTO plu_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ayteke nikwe ig gisamwi gipun maripkew gukak eggu giwgun. Ig hawwata ig miyap guw. Ig kawnata kakamkayh gukak. ");
INSERT INTO plu_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ayteke nikwe ig gisamwikis gimamnamkis ig hawwata ig maripkew gukakwata akiw. Henne madikte nerras ntewnehkernene gikebiyikis miyarapwata yuma pahapwinama kakamkayh gukak. ");
INSERT INTO plu_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Pisenwa egme hawwata eg miyop. ");
INSERT INTO plu_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kuri Kiyapwiye, usuh ayapi. Aysawnemenek apim ini ku aysaw hiyeg kannikaw ariw gimiremnikis, pariyepa gibetitakkis darihgu? Mmanawa igkis ntewnehkernene gikebyikis igkis madikte maripkewnekwiyes gukak. ");
INSERT INTO plu_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Igme Kiyapwiye Jesus kaytwa giwnkis: ―Hiyeg amedgenepwi inin ignes maripkaw. ");
INSERT INTO plu_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Henneme ku pariye hiyeg ik adahan igkis kannikaw ariw gimiremnikis adahan igkis msakwa ayhté inugik, igkis ka maripkaw akiw ayge. ");
INSERT INTO plu_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Iné igkis kawnata miyá akiw. Igkis msakwa hennep ke ahjbe. Igkis Uhokri gikamkayupwi mmanawa igkis kannikaw ariw gimiremnikis. ");
INSERT INTO plu_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Kuri uyay kinetihwa amin wixwiy hiyá ba hiyeg kannikaw ariw gimiremnikis. Igwa amekene Moís akki wotwiy ku ignes kannikaw. Ig akki wotwiy huwewe abet inakni yuwit adahan tiket apuwpi ewwakti. Ayge abet inakni yuwit ig awna ku Kiyapwiye Uhokri ku ignewa kuri amekene Abrawh giwohkiga, ignewa kuri amekene Izaki giwohkiga, ignewa kuri amekene Jakó giwohkiga. ");
INSERT INTO plu_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Inakni yuwit akki wot ku igkis gidukweneswa igkis ipeg. Ig Uhokri kawki miyarapyema giwohkigakisma. Ig hiyeg ipegnene giwohkigakis. Wotwiy igkis miyarap. Gitme Uhokri gidukweneswa madikte hiyeg ipeg. ");
INSERT INTO plu_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Gaytakkis nerras kannuhekeputnepwi amin amekene Moís gikumadukan igkis timapni henne, igkis awna git: ―Kiyapwiye, pis awna inakni kibeyne yuwit. ");
INSERT INTO plu_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ariwnteke ini igkis ka kibowka ayapri akiw. ");
INSERT INTO plu_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ayteke igme Kiyapwiye Jesus ayaprikis: ―Mmahki hiyeg kanumri Uhokri gikanyan adahan ukumaduketniwiy, Cristo, mmahki igkis kanumri “amekene Davi gihiwhi”? Mmahki igkis ka kanumri “amekene Davi gikipara”? ");
INSERT INTO plu_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Igwa amekene Davi tamak inakni henne amadga gikagtan apatkekne Salmus. Ig awna: “Ukiparawiy Uhokri awna ta git nukipara Cristo. Giwn: ‘Batnaba ay nuhumwa kihehaptak amun inin iwetrit kiyatye ");
INSERT INTO plu_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ku samah nah sibuhkisnete pipetunyapu pit.’ ” ");
INSERT INTO plu_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ka ba yis hiyá ku igwa amekene Davi ka kanum Cristo “nuhiwhi.” Kawa. Ig kamumri “nukipara”. Nikwe ig Cristo ka he gihiwhinenwatma. Ig hawwata ig gikipara. ");
INSERT INTO plu_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ayteke ig Kiyapwiye Jesus kinetihwa gikakkis gikannuhnipwi ay gitaybikis madikte hiyeg. Ig awna gitkis: ");
INSERT INTO plu_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Pukuhpawnabay adahan yis ka iwí gihiyakemnikis nerras kannuhekeputnepwi amin amekene Moís gikumadukan. Igkis ba gibetkatunkis wewnamahkis agiku gibereswetnikis. Igkis batek hiyeg aytnihgikis higiwmadga akak kiyathaki. Igkis batek bat amadga epti ku pariye pi kiyattanano agiku leglis. Igkis batek bat amadga epti kiyatyo abet fet. ");
INSERT INTO plu_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Bawa igkis wiwhpiyes madankunopwi gupinkis guwkis payak akak gewkanbetkis akak kiniska. Henneme igkis piriyepkaw kiyabawkad marihwa hiyeg ikiygikis ku igkis kibeynepwi hiyeg. Aysawnemenek igkis katiwnipwe apatra ini gihiyakemnikis. Apim ini igkis pi hiyapte mbeyne ariw nawenépwi hiyeg taraksapye. ");
INSERT INTO plu_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ayteke ariwnteke ini ig Kiyapwiye Jesus ayge apuriwne hiyeg kehnepwi ofan gidahan Uhokri ayge agiku ini leglis kewye Uhokri Gipin. Ig hiyá kaayhsima igisapye mpiya awpre, igkis ikenes karukri ta agikut atiy. ");
INSERT INTO plu_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ayteke ig hiyá pahapu madankuno danuh atere. Eg madiptipyo. Eg ikano mmukna kirehka ta agikut atiy, aynessawa karukri. ");
INSERT INTO plu_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ig hiyapni henne, ig awna: ―No eg madankuno madiptipyo gukan pi kahayakte ta gipetunat Uhokri ariw gikankis madikte nerras hiyeg. Ihanabay inakni nuwnhu. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Mmanawa igkis kakanhaw akak gikakurakis asemne. Egme kakanhaw akak madikte gudahan gukakura. Yuma ariknawnama eg darih adahan isimno ku pariye gumawkanitnene. ");
INSERT INTO plu_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ayteke ariwnteke ini gaytakkis gikannuhnipwi kapusa kinetihwa pawtak amin ini leglis Uhokri Gipin ku samah in barewyewa paytwempu, in kehka akak barewyowinen tip, in bareswapu akak hiyeg gikankis. Igme Kiyapwiye Jesus timapni henne, ig awna gitkis: ");
INSERT INTO plu_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Mmah yis hiyá ini paytwempu? Aysawnemenek yis hiyapni madikte mehpikanek. In hirohe madikte waygboitenek. Iné pahow tip ka msakwanek papitmintak akak guyaki tip akiw. ");
INSERT INTO plu_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Igkis timapni henne, igkis ayapri: ―Kiyapwiye, kabetpahki inakni piwn kahayaknek? Pariye danuh adahan arekhetni ku in kennesa adawnhannek? ");
INSERT INTO plu_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Igme kaytwa giwnkis: ―Ka yi muwaka kinikiswa ta gitkis hiyeg. Mmanawa aysawnemenek kaayhsima hiyeg kahayaknek nuwaprik ke wotbe ignes ayta nuwntakbe. Igkis awnanek: “Nahnewa Cristo, nah Uhokri gikanyan adahan yikumaduketni.” Hawwata igkis awna: “Kuwis ahawkanaprik amaksemni hawkri.” Ka ba yi iha inakni giwnkis. ");
INSERT INTO plu_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ku aysaw yis timé arak kutimniki akak kerka ka yi muwaka wadisasaw. Amawka ku in kit danuh henneme kote danuhte amaksemni hawkri. ");
INSERT INTO plu_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ayteke ig awna gitkis: ―Aysawnemenek pahabunene hiyegipiyene kerbetpikisnek gikakkis nawenéwa hiyegipiyene akiw. Gupelma kerbetpikis igkisweke gupelma. ");
INSERT INTO plu_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Apim ini kaayhsima sagkaki kaahawnasima muwwapu waxribdiw. Hawwata mbeyepye karayt biyuh muwwapunek. Hawwata kaayhsima mihetniki danuh muwwapunek. Hawwata akiw mbeyepye arikna humawnek amadga en. In keh hiyeg apis mpiynepepye. ");
INSERT INTO plu_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","―Henneme apit ini mbayka danuh, yis nuhiyegapu kamaxwika gapitkis hiyegnek yis hiyapkiska mbeyne yitnek. Apim ini yis kamiyepkanek agiku gileglisakis. Ayteke nikwe yis paraksepka agikut parakseket. Hawwata akiw yis kamiyepkanek ta gitkis ikiparat ta gitkis hiyaptigi. Yis waxepka ta gipetunatkis apatra ku samah yis nuhiyegapu. ");
INSERT INTO plu_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","―Ka sam. Ini humaw yihawkanaprik adahan yis kehne temwe ndahan. ");
INSERT INTO plu_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ahegbetanabay yihiyakemni ku akak inin adahan yis ka ipegmina yihiyakemni adahan ku pariye yis awna gitkis apim ini hawkri. ");
INSERT INTO plu_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Nahwa ikí yuwit yit adahan yis awna gitkis apim ini. Nahwa ikí hiyakemniki yit. Ayge yipetunyapu ka hiyá asamanak adahan igkis diyuhkis yinetni. Igkis ka hiyá igkisma kaytwa yiwn apim ini hawkri. ");
INSERT INTO plu_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","―Apim ini hawkri yigwa kamaykiswey, yinagwa kamaykiswey, yikebyupwiwa kamaykiswey, yikagmadapuwa kamaykiswey. Juktah egkis umahkise yaytaknek. ");
INSERT INTO plu_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ayge madikte hiyeg amiyhepyi awaku ku samah yis nuhiyegapu. ");
INSERT INTO plu_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ka sam. Uhokri apuriwyi kabayhtiwa. Yisemnuwa ka matis. ");
INSERT INTO plu_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ku yis ka isahkiswa nuwhu, yis aymuhwa gimun Uhokri adahan apanenekwa. ");
INSERT INTO plu_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","―Ku aysaw yis hiyá Jerusalém kiyaraniw akak suwtat, ini arekhetni ku ahawkanaprik kuwis danuh adahan in mehpika. ");
INSERT INTO plu_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ku aysaw in danuh nikwe amawka hiyeg pese ayteke kibentenwa. Amawka ku pariye msekwenepwi ay Judeyamnaw amawka ku igkis bisike ahaprikute apuheku ini waxribdi. Igkisme ku pariye msekwenepwi ay apit Jerusalém amawka igkis pes ayteke nipititak. Igkisme ku pariye msekwenepwi aparayewa ariw ini paytwempu amawka igkis ka bisik atere nipitit. ");
INSERT INTO plu_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Mmanawa ahawkanaprik hiyeg jerusalémyenepwi katiwnipwe apatra gitaraksankis. Madikte in danuh ta gitkis ku samah Uhokri gannasan minikweknene awna. Metakwa in kahayak. ");
INSERT INTO plu_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Akayih. Kaayhsima mahikoriki apim ini hawkri gudahankis tinogben biyuhkisnopwi hawwata gudahankis tinogben ku pariye sukkisanyopwi. Kaayhsima mahiko adahan egnes bisik. Mmanawa kaayhsima mbayka danuhnek ta apitit inin waxri. Hiyeg hiyá mbeyne kaayhsima aynek apatra gitaraksankis. ");
INSERT INTO plu_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Kaayhsima hiyeg gaytakkis igkis umehpikanek akak ponya. Kaayhsima hiyeg gaytakkis igkis kamaxapepka igkis waxapepka ta apitit mpuse waxri. Apim ini ignes hiyeg kane judeyenepwima igkis xuwehe hiyeg jerusalémyenepwi giwaxrikis. Igkis msakwa ayge juktah ku aysaw gihawkanaprikis danuh adahan Uhokri pisenwa gikumadukankis ayge. ");
INSERT INTO plu_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","―Ayteke ariwnteke ini, mbeye arikna humawnek agiku hawkri akak kamuw akak kayg akak warukma akak warapyu. Ayme amadga wayk madikte hiyegipiyenepwi kiyimwih ginaktinkis awaku ku samah paraw bobo kiman mpiynepepye parawhokwa. ");
INSERT INTO plu_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Hiyeg nuwiknawrumpi awaku gapisnikis abohri ku pariye me danuh gitkismet. Mmanawa madikte ku pariye agikunene hawkri, apim ini in ayguhwebdinek ariw niwetri. ");
INSERT INTO plu_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ayge apim ini nikwe hiyeg hiyapunnek, nah ku pariye wageswe awayg amadgaya inin. Nah ayta abetimpi ukuhne akak madikte ndatni akak madikte nukiythani kabutennene. ");
INSERT INTO plu_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Yisme ku samah yis hiyá ini mbeyne danuh, ka yi muwaka apisasaw. Sarayhnay yipegyi ta inugikute adahan yis nuhiypetni. Apim ini yamnihka humaw kibentenwa. ");
INSERT INTO plu_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ayteke ig Kiyapwiye Jesus awna gitkis pahat yuwit patuwesbuhka. Ig awna: ―Ipegnay ta gumkat no ah akat “figeyra” akak arakembet ah akat akiw. ");
INSERT INTO plu_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ku aysaw wis hiyá egnes kapanhaw akiw in arekhetni huwewe wot ku guhawkanaprikkis kennesa danuh nikwe adahan egkis kew. ");
INSERT INTO plu_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Hawwata aysawnemenek ku aysaw yis hiyá ini mbeyne danuh, metakwa yis hiyakni kuri ku Uhokri gikumadukan ahawkanaprik kennesa danuh kuwis. ");
INSERT INTO plu_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Hiyeg ku pariye amedgenepwi inin apim ini hawkri, apit ignes madikte miyarap ayipa inakni madikte danuh gitkisnek ku samah nuwnhu. Ihanabay inakni nuwnhu. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","En biyuke, waxri biyuke, henneme nuwnhu ka biyuk. ");
INSERT INTO plu_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","―Msakwanabay ahegbet apanenekwa apit ini hawkri danuh. Ka yi muwaka ikatuswa arit amadgaya inin. Ka yi muwaka ikatuswa arit fet arit urukihwaki. Nawenétke pahaye adahan in hawkri danuh yis ka iknima. ");
INSERT INTO plu_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ke pahapwi hiyegbe pahaye adahan ig sibuhe agiku tey ig ka hiyaknima. Pahaye adahan in dehekwig. Mmanawa hennewa in danuh ta gitkis madikte hiyeg amedgenepwi inin. ");
INSERT INTO plu_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Amawka yis apuriwnenekwa apanenekwa, yis ayepne yawaygyi ta git Uhokri adahan yis ka matakasaw arit madikte ini mbayka ku pariye nemnikumpiye. Amawka yis ayepne yawaygyi adahan yis yidukwenewa tabirnene amadga hawkri juktah ku aysaw nuhawkanaprik danuh nah ku pariye wageswe awayg amadgaya inin. ");
INSERT INTO plu_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Mpuse hewke ig Kiyapwiye Jesus kannuhekne ayge ini leglis kewye Uhokri Gipin. Mpuse aygete ig pes apuritak paytwempu Jerusalém. Ig mpiyesa mpuse mtipka ta apitit ini waxri imuhgipitnene kewye Olipegpit. ");
INSERT INTO plu_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Hewkepye hiyeg danuhne atere agikut ini Uhokri Gipin adahan igkis timepnes Kiyapwiye Jesus giwn. ");
INSERT INTO plu_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Msekwe aynessa hawkri adahan judeyenepwi gipetrakis adahan igkis axnes muttuhyan arih akak bugut miyegbiye adahan kiyene ku samah minikwak Uhokri umahkise muttuhyan gidukwenaprikkis gihiyegapu. ");
INSERT INTO plu_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Nerras muwpeg kiyatyepwi gikakkis nerras kannuhekeputnepwi amin amekene Moís gikumadukan igkis ipegminenes gihiyakemnikis adahan igkis hiyak ku samahpa igkis umahkise Kiyapwiye Jesus. Igkis apise nawenétke hiyeg fetyapu ayge hahhayruke gikakkis gipatra. ");
INSERT INTO plu_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ayteke ner wapitye gikiparadkis Satanás ig kawihe pahapwi gaytakkis Kiyapwiye Jesus giwatnipwi kewye Judas Iskariyotis. ");
INSERT INTO plu_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ayteke nikwe ig Judas Iskariyotismin tipik ta gimkatkis nerras muwpeg kiyatyepwi gikakkis nerras apuriwnepwi Uhokri Gipin. Ig danuh atere, ig kinetihwa gikakkis adahan ig kamaykiswiye Kiyapwiye Jesus ta gitkis. ");
INSERT INTO plu_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Igkis timapni henne, igkis batek ginaktinkis kaayhsima. Igkis awna git: ―Ku pis kamaykis Jesus ta wothu, usuh katiwnihpi. ");
INSERT INTO plu_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Igme kaytwa giwnkis: ―Ihi. In kabay nuthu. Ayteke nikwe ig gihapu Kiyapwiye Jesus adahan ig hiyá ku aysaw gihawkan danuh kabayhtiwa adahan ig kamaykiswig aparayewa ariw hiyeg. ");
INSERT INTO plu_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ayteke ariwnteke ini, danuh ahawkanaprik adahan ini fet adahan hiyeg axnes bugut miyegbiye. Abet pitatye hawkri abet ini fet ignes judeyenepwi umah muttuhyan adahan kiyene ku samah minikwak Uhokri umahkise muttuhyan gidukwenaprikkis gihiyegapu. ");
INSERT INTO plu_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ayge nikwe ig Kiyapwiye Jesus awna ta gitkis kiyapwiye Pedru gikak kiyapwiye João. Giwn: ―Ataknabay ahegbeta pahapwi muttuhyan adahan waxniwiy abet upetrawiy. ");
INSERT INTO plu_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Igkisme ayapri: ―Kiyapwiye, kineypa pimawkan adahan usuh ahegbetin? ");
INSERT INTO plu_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Igme kaytwa giwnkis: ―Ku aysaw yis parakanten apitit paytwempu Jerusalém, ayge pahapwi awayg patiptak yikaknek. Ig hiyuwe akak kaggap un atiy. Makekwepnay gihapu. Ku kiney ig parak agikut payt, yis parak aterewata. ");
INSERT INTO plu_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Awnanabay ta git payt akipara ku yikannuhten awna: “Kineypa xam adahan nah fetya axne muttuh arih gikakkis nukannuhnipwi?” ");
INSERT INTO plu_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ayge nikwe ig akki ta yitnek pahayku xam nopsadnene ayhté payt apahnap inuteknene. Arikna ayge madikte ahegbet kuwis. Ahegbetanabay umanawiy ayge adahan wixwiy fetya. ");
INSERT INTO plu_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Igkis piyananene timapni henne, igkis tipik ta apitit paytwempu. Igkis danuh atere, igkis utí madikte ku samah Kiyapwiye Jesus akkamnih gitkis. Ayge nikwe igkis ahegbete madikte adahan igkis fetya axnes muttuhyan arih. Pisenwa igkis diyuhe ta git Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ayteke ariwnteke ini ku aysaw ahawkanaprik danuh, igkis atere fetya. Ig Kiyapwiye Jesus bat ahumwa axtet gikakkis giwatnipwi. ");
INSERT INTO plu_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ayge ig awna ta gitkis: ―Kennesa kuri adahan nah hiyapkiska mbeyne nuthu. Kibeyne, apit in danuh nuthu, nah kahawkan fetya ay yikak. Nah kaayhsima axkere inin muttuhyan arih yikak ku apim inin. ");
INSERT INTO plu_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ig muttuhyan arakak ndahan. Ku samah ig umehpika gidukwenaprikkis amekenegben marihwa igkis isamtaw, hawwata nah umehpikanek. Apim ini nah inyerwa keh hiyeg isamtaw. Awetupye nah ax yikak henne akiw juktah ku aysaw madikte ini arakak inyerwa danuh abetnewa Uhokri gikumadukan. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ayteke ig iwé pahow goblé. Ig kabayha Uhokri. Ig awna gitkis: ―Amapanay inin win. Mpuse pahapwimpi higá niwntak. ");
INSERT INTO plu_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Kuri nah ka takunima higá win ay amadga inin akiw. Awetupye nah higá win ay juktah ku aysaw Uhokri gikumadukan danuh. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ayteke ig iwé pahak bugut. Ig kabayha Uhokri. Ig sigkebdih ini bugut ig ibekhepni ta gipuriwkis giwatnipwi. Ig awna gitkis: ―Inin bugut in nihhu ku pariye nah sigkebdihkis yidahannek. Han pitatit yis axne bugut ke ininbe kikibereput adahan yis nukiyetninek. ");
INSERT INTO plu_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ayteke ariwnteke ini pisenwa gaxnikis madikte gimanakis, ig iwé pahow goblé. Ig keh nikak hawwata ku samah ig keh akak bugut. Ig awna gitkis: ―No goblé eg Uhokri gahegbetawni nukunewa yidahan. Mmanawa ig Uhokri ahegbete ginetni nukunewa akiw gikakkis hiyeg adahan ku samah ignes humaw gihiyegapu. Nahme sukase numighu yidahan kahadbe ini gahegbetawni in humaw. ");
INSERT INTO plu_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ayteke ig Kiyapwiye Jesus awna: ―Pahapwi yaytak ay, giwak payak akak ndahan ay aduhyamadga axtet, iggi kamaykiswennek ta gitkis nupetunyapu. ");
INSERT INTO plu_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Nah ku pariye wageswe awayg amadgaya inin nah umahkiswanek ku samah Uhokri ikiswanaw ndahan. Amawka ku nah miyá henneme ner ku pariye nuwmasepten iggi hiyá mbeyne kaayhsimanek nupatra. ");
INSERT INTO plu_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Igkis giwatnipwi timapni henne, igkis kinetihwa pawtak amin ku pariyepa kehpiye ini gikak Kiyapwiye Jesus henne. ");
INSERT INTO plu_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Hawwata akiw igkis kapusa mapihpak amin ku pariye gaytakkis pi kiyattenene giwkis. ");
INSERT INTO plu_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ig Kiyapwiye Jesus hiyapni henne, ig awna gitkis: ―Ka yi muwaka ikaw gapitminnama pahapwi. Ikiparat amadgayapu inin igkis ikaw gapitminkis gihiyegapukis. Igkis kabukhewpi gitkis. Henneme igkis kanumkiswa “Hiyeg gamnihtenkis”. ");
INSERT INTO plu_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Yisme ka hennema. Yidahan nawenéwa. Yisme yidahan ku pariye yaytak yapitmin madikte amawka ku ig ka kabukhaw yit. Amawka ku ig ikaw ke wotbe igwa yibukbe. Ku pariye kumadukene amawka ku ig ikaw ke wotbe igwa kumadukakibe. ");
INSERT INTO plu_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Uyay akki nuthu. Pariyepa pi kiyatte giwtrikkis hiyeg? Ba pahapwi ku pariye betnene ahumwa gaxten ig axne ayge? Ba ig pi kiyatte? Ba kawk ba ner gibuk ku pariye ewkne gimana git? Nah akkite yit ku pariye gaytakkis pi kiyatte. Ner ku pariye betnene ahumwa gaxten iggi pi kiyatte giwtrikkis hiyeg ay amadga inin. Nahme nah ka ikaw kema ner kiyatyema. Nah ikaw kewa pahapwi ibuktibe ay yibet. Amawka ku yis ikaw hawwata ke nahbe. ");
INSERT INTO plu_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Yis kibeynepwi nuhiyegapu yis arehun kabayhtiwa abet mbeyne. Nikwe aysawnemenek yis hiyá kaayhsima kabaykanek. ");
INSERT INTO plu_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ku samah Nighu ikí kumadukaki nuthu, nah hawwata nah ikí yitnek. ");
INSERT INTO plu_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Apim ini yis ax payak nukakhu yis higap payak nukakhu ayhté ku kiney nukumadukan. Hawwata yis batebdeweknene amadga yepwi kiyatyo adahan yis hiyekne gikakkis madikte israelyenepwi. ");
INSERT INTO plu_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ayteke ig Kiyapwiye Jesus awna ta git kiyapwiye Pedru. Giwn: ―Simawh, Simawh, ayipa ikepka kumadukaki git wapitye gikiparadkis Satanás adahan ig yihikekten. Ig kiyimwihyi kaayhsimanek adahan yipekiswitni nuwhu hawwata ke pahapwi awaygbe ku pariye sassah amutri guyak amadga huw adahan pekkiswiye gumar. ");
INSERT INTO plu_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Henneme nah kuwis piriyepkaw pidahan adahan pis ka tuguhkis pikamaxwan. Kuwewanek ku aysaw pis diyuh ta nuthu akiw ikinaba pikebyupwi gawaygyikis. ");
INSERT INTO plu_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Igme kiyapwiye Pedru kaytwa giwn: ―Kiyapwiye, nah ka isahkiswekere piw. Hiyawa pis kamaxwika henneme nah ahegbet adahan nah kamaykiswa payak pikak. Hiyawa pis umehpika henneme nah ahegbet adahan nah umahkiswa payak pikak. ");
INSERT INTO plu_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Igme awna git: ―Ped, ku apim inin mtipka pis wihwe nuwhunek. Apit takarak awna pahaywowa gawnhan pisme ayipa wihwe nuwhunek mpamaput. Apim ini pis awna ku pis ka hiyakun. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ayteke ig Kiyapwiye Jesus awna ta gitkis madikte giwatnipwi. Giwn: ―Ku samah nah awahkiswey kuhwekwa adahan yis ekkene nuwnhu ta gitkis hiyeg, nah awahkisyi makakura, masakola, makasutni. Apim ini ba ay arikna muweke yit? Igkisme kaytwa giwn: ―Kawa, Kiyapwiye. Yuma ariknawnama muwekne wothu. ");
INSERT INTO plu_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Igme awna gitkis: ―Kurime ka hennema akiw. Ku pariye kakakura kasakola amawka ig iwé gikakura ig iwé gisakola. Ku pariye yuma giponyaga amawka ig piyuk pahak gisimsa adahan ig isimne giponyaga akak eggu gisimsawen. ");
INSERT INTO plu_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Mmanawa kuwis ahawkanaprik danuh adahan nah ikaka ke wotbe nah kakehniyebe. Uhokri gannasan kinetihwa numinhu minikwak ku in danuh nuthu. Hennewatmeki in danuhnek. Mmanawa madikte ku pariye Uhokri gannasan ndahan in kabá makisu. ");
INSERT INTO plu_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Igkisme timapni henne, igkis awna: ―Kiyapwiye, mmukna gukebyikis ponya ay. Igme kaytwa giwnkis: ―Ikeypi. ");
INSERT INTO plu_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Pisenwa nikwe ig pes ayteke, ig tipik ta apitit ini waxri imuhgipitnene kewye Olipegpit ku samah inpawa ig keh. Igkisme gikannuhnipwi tipike gihapti. ");
INSERT INTO plu_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ig danuh atere, ig awna gitkis: ―Piriyepkawnabay marihwa yis ka isaksaw arit mbayka. ");
INSERT INTO plu_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ayteke ig wewkiswe ataresa barew apiyukan. Ig paberetusaw ig piriyepkaw ta git Uhokri. ");
INSERT INTO plu_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ig awna: ―Nighu, ku pis mpithekere ini mbeyne ndahan, uyá amnihun mpithapni ndahan. Henneme ku in pimawkanwa in danuh nuthu, ka sam in danuh nuthu. Nah ka kehkere ndahan nubetki. Henneme nah kehkere pidahanwa pibetki. ");
INSERT INTO plu_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Pahaye adahan pahapwi ahj hiyapkiswe ta git atere, ig ikene gawaygyi git. ");
INSERT INTO plu_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Igme Kiyapwiye Jesus wakaymni mpiynepepye. Ig hiyapni henne, ig piriyepkaw pi kihhawnate akiw. Ig piriyepkaw ba ahawnapepye he giwnrapwi suke ke migatbe suruhpiyebe ta waygboit. ");
INSERT INTO plu_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ayteke pisenwa gipigyepkawni ig kannikaw, ig diyuhe ta gitkis gikannuhnipwi. Ig uteprikis himekweke awaku igkis barukiswe. ");
INSERT INTO plu_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ig hiyapni henne, ig awna gitkis: ―Mmahpaki yipewkan yis himegbet? Kannikawnay. Piriyepkawnabay marihwa yis ka isaksaw arit mbayka. ");
INSERT INTO plu_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ku samah ig awnempiye inakni yuwit, pahabunad hiyegad danuh atere. Ner pahapwi gaytakkis giwatnipwi kewye Judas Iskariyotis ig wew pitatyempi gapitkis. Ig danuh atere, ig mpiye danukwa ta gihumwat Kiyapwiye Jesus adahan ig gaympoketni. ");
INSERT INTO plu_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ig Kiyapwiye Jesus hiyapni henne, ig wakaymni. Ig awna git: ―Judas, mmah pis kamaykisun akak aympokaki, nah ku pariye wageswe awayg amadgaya inin? ");
INSERT INTO plu_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Igkisme nerras ku pariye aynenepwi gikak Kiyapwiye Jesus igkis hiyapni henne, igkis hiyak ku pariye me danuhe git. Ayge nikwe igkis awna git: ―Kiyapwiye, ba pis muwaka usuh iw uponyaga adahan usuh kapetunsigkis? ");
INSERT INTO plu_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Aynewa pahapwi gaytakkis nuwipwihe pahapwi ibukti gidahan ner muwpegpiyene gikiparakis. Ig ihuke gitaybi kihehaptak. ");
INSERT INTO plu_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ig Kiyapwiye Jesus hiyapni henne, ig awna git: ―Ka ba kehni henne. Ayteke ig dax gitaybi adukwen, in humaw akiw. ");
INSERT INTO plu_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ayteke ig awna ta gitkis nerras muwpeg kiyatyepwi gikakkis nerras apuriwnepwi Uhokri Gipin, nerras judeyenepwi giwewkistenkis ku pariye gikamaxwitni atere. Giwn: ―Mmahkay yis ayta akak madikte yiponyaga akak madikte yasuga? Mmahkay yis ayta nukamaxwitni ayamaw ke wotbe nah amepyebe? ");
INSERT INTO plu_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Takunipti nah ayge yikak yikannuhten agiku Uhokri Gipin. Henneme yis ka kibowka kamaxun ayge. Ka sam. Kuwis yihawkanaprik danuh adahan yis keh nukakhu ku samah amisnapyi akiparad gimawkan. ");
INSERT INTO plu_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ayteke nikwe igkis kamaxe Kiyapwiye Jesus igkis waxepri ta gipinekut ner muwpegpiyene gikiparakis. Ig kiyapwiye Pedru hiyapni henne, ig makeke gihapu butte henneme ig piyawakte giw aynessa. ");
INSERT INTO plu_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Igkis danuh atere gipinekut ner muwpegpiyene gikparakis, nerras hiyeg hamehe tiket ayhté gipinbuk. Igkis bat atere ahumwa eggu tiket. Ig kiyapwiye Pedru hiyapni henne, ig bat aterewata payak gikakkis. ");
INSERT INTO plu_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ayteke pahapu tino bukitwiyo hiyapri ayge betnene abet tiket abutni. Eg ipegkak gikak, eg awna: ―Ner awayg hawwata wew gikak Jesus. ");
INSERT INTO plu_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Igme wihwe giw. Ig awna ta gut: ―Kiyapuno, nah kawa hiyakriwa ner awayg. ");
INSERT INTO plu_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ayteke ariwnteke ini pahapwi hiyeg akiw hiyapri atere. Ig awna git: ―Pisnewa gaytakkis Jesus gikannuhnipwi. Igme kaytwa giwn: ―Ka nawhnama. ");
INSERT INTO plu_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ayteke ariwnteke ini ayiptenesa akiw, pahapwiwa awayg awna akiw: ―Hennewa. Ner awayg Jesus gikannuhni. Mmanawa ig hiyeg galiléyene hawwata ke Jesusbe. ");
INSERT INTO plu_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Igme kiyapwiye Pedru timapni henne, ig awna git: ―Nah ka hiyakwa inakni yuwit ku kamin pis awna. Nikwenéwa ku samah ig awnempiye inakni yuwit, pahapwi takarak awna. ");
INSERT INTO plu_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Apiminewa ini hawkri ig Kiyapwiye Jesus ipeganaw ta gimkanit kiyapwiye Pedru. Igme kiyapwiye Pedru hiyapni henne, ig kiyé inakni ku pariye Kiyapwiye Jesus giwn kuhwekwa ta git amin: “Apit takarak awna pahaywowa gawnhan, pisme ayipa wihwe nuwhunek mpamaput.” ");
INSERT INTO plu_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ig kiyé inakni giwn nikwe, ig pes ayteke. Ig kiyemna gitaraksan mpiynepepye. Ig biyuk gikan. Ig tihene ayge. ");
INSERT INTO plu_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Apimwata ini nerras hiyeg ku pariye Kiyapwiye Jesus ay giwakukis, igkis biptepri igkis hiyaraptihpig. ");
INSERT INTO plu_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ayteke igkis wanakotepri igkis biyuhpokepri. Igkis awna git: ―Ku pis Uhokri gawnepe, asá akki wot ku pariye pibiyuhatepten. ");
INSERT INTO plu_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ayteke igkis awna arakembet yuwit akiw adahan gimiytetni. ");
INSERT INTO plu_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Hewke nikwe hawkanawa madikte judeyenepwi giwewkistenkis igkis keh gipandukawnikis. Igkis pahadguhwe payak gikakkis nerras muwpeg kiyatyepwi gikakkis nerras kannuhekeputnepwi amin amekene Moís gikumadukan. Ayteke igkis waxase Kiyapwiye Jesus ta gipetunatkis. Ig danuh atere, igkis awna ta git: ");
INSERT INTO plu_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Ku pis Cristo, ku pis Uhokri gikanyan adahan ukumaduketni, asá akkaw wothu. Igme kaytwa giwnkis: ―Ku nah akkaw yit, yis ka iha inakni nuwnhu. ");
INSERT INTO plu_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Waké nah ayapyibe amin inakniwata, yis ka kaytwakam. ");
INSERT INTO plu_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kuri yis betnene ayge adahan yis hiyekne nukakhu. Henneme kuri aytekihan nah ku pariye wageswe awayg amadgaya inin, nah bat ayge gihumwa Uhokri detye ay amun ini iwetrit ku pariye kanenikiythanisima kihehaptak. Apim ini nahme hiyekne yikak nikwe. ");
INSERT INTO plu_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Igkisme timapni henne, igkis awna payebitak: ―Mmah pis Uhokri gikamkayh nikwe? Igme kaytwa giwnkis: ―Nahnewa ku samah yis awna. ");
INSERT INTO plu_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Igkis timapni henne, igkis awna: ―Pariyeki umawkanwiy akiw? Wixwiy ka muwaka hiyeg akki wotwiy ariknawnama Jesus gitaraksan akiw. Kuwis ig taraksa ay wowtrikwiy. Ig makukse Uhokri ay wowtrikwiy. Uyay katiwnise ini gitaraksan git. ");
INSERT INTO plu_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ayteke nikwe igkis kannikawbet igkis waxe Kiyapwiye Jesus ta gipetunat ner hiyaptigi romayene ig amekene Pilatus. ");
INSERT INTO plu_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Igkis danuh atere, igkis kapusa kamiyepri ta git amekene Pilatus. Igkis awna ta git: ―Ig ner awayg mbeyhene uhiyegapu judeyenepwi gihiyakemnikis. Ig awna gitkis adahan igkis ka katiwnih gupelma. Ig ikawpari ke wotbe igwa ukiparabe, ke wotbe ig Cristo, ig Uhokri gikanyan adahan ukumaduketni. ");
INSERT INTO plu_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Igme amekene Pilatus timapni henne, ig ayá Kiyapwiye Jesus: ―Mmah pis judeyenepwi gikiparakis? Igme kaytwa giwn: ―Hennewa ku samah pis awna. ");
INSERT INTO plu_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ayteke pisenwa ginetni gikak Kiyapwiye Jesus, ig amekene Pilatus awna ta gitkis nerras muwpeg kiyatyepwi ayge gikakkis nerras hiyeg pahabunene. Giwn: ―Nah ka utí mbaynama gikehni. ");
INSERT INTO plu_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Igkisme kaytwa giwn akak dagawnka. Igkis awna: ―Ig Jesus mategbetene hiyeg gihiyakemnikis muwwapu Judeyamnaw muwwapu Galiléyamnaw he ig danuh atan apitit inin paytwempu. ");
INSERT INTO plu_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Igme amekene Pilatus timapni henne, ig ayaprikis: ―Mmah ner Jesus, mmah ig hiyeg galiléyene? ");
INSERT INTO plu_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Igkisme kaytwa giwn: ―Ihi. Ignewa. Ig amekene Pilatus timapni henne, ig awna: ―Ignewa kiyapwiye Erodis kumaduka hiyeg galiléyenepwi. Nah awahkiste Jesus atere gimin adahan igme hiyak gikak. Ayteke nikwe ig awahkiswig atere gimin amekene Erodis. Apim ini hawkri ig amekene Erodis ayge apit ini paytwempu Jerusalém. ");
INSERT INTO plu_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ayteke nikwe ig Kiyapwiye Jesus waxepka atere git. Ig amekene Erodis hiyapni henne, ig bateke gimin. Kibite hawkri kuwis ig hiyepkerepri mmanawa ig kinetni gak ig gipewkankam ig kehkis annut git adahan arekhetni gidatni. ");
INSERT INTO plu_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ayge nikwe ig ayaptig akak kibite ayapka. Igme Kiyapwiye Jesus ka kaytwa giwn. ");
INSERT INTO plu_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Amun ini nerras muwpeg kiyatyepwi gikakkis nerras kannuhekeputnepwi gimin amekene Moís gikumadukan igkis tabirbet ayge gimun amekene Erodis, igkis kamiye Kiyapwiye Jesus akak madikte gihawnakis. ");
INSERT INTO plu_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ayteke nikwe ig amekene Erodis gikakkis gisuwtatapu igkis miyatepri igkis hiyaptihpig. Pisenwa ig kadagmankisepri akak barewye dagam ke wotbe ig ikiparatbe ig awahkiswig diyuh ta gimin amekene Pilatus. ");
INSERT INTO plu_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Apim ini hawkri ig amekene Erodis kapuse pasamrak gikak amekene Pilatus. Apit ini igkis ka pasamrak, henneme apim ini igkis kapusa pasamrak. ");
INSERT INTO plu_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ayteke ariwnteke ini ig amekene Pilatus watihe gitkis nerras muwpeg kiyatyepwi adahan igkis ayta git payak gikakkis nerras judeyenepwi giwewkistenkis gikakkis madikte hiyeg. ");
INSERT INTO plu_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Igkis danuh atere, ig awna gitkis: ―Yis waxe ner awayg nuthu, yis awna nuthu ku ig mbeyhene hiyeg gihiyakemnikis adahan igkis siguh gupelma. Boh. Nah kuwis hikekri baki inyerwatma ig keh henne. Nuthu ig ka keh ariknawnama mbayka ku kamin yis kinetihwa nuthu. ");
INSERT INTO plu_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ig kiyapwiye Erodis kawnata utí mbaynama gikehni. Inneki keh ig diyuhkiswig ta nuthu. Ka ik adahan nah umahkisri. ");
INSERT INTO plu_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Nikwe nupewkan nah biyuhkiswig. Ayteke pisenwa nah isahkiswig. ");
INSERT INTO plu_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ig amekene Pilatus awna inakni mmanawa mpuse fet ig gibetki isahkis pahapwi awayg ku pariye paraksepkare ayge. ");
INSERT INTO plu_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Igkisme nerras hiyeg timapni henne, madikte igkis kabiman. Igkis awna: ―Kawa! Ka isahkisri! Isahkis Bahabás udahan! Hennebaki igkis kabiman. ");
INSERT INTO plu_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ig Bahabás ig pahapwi ku pariye padekwika agikut parakseket apatra ku samah ig hahhayruke gikak gupelma ayge apit ini paytwempu, ig umehe pahapwi. ");
INSERT INTO plu_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Igme amekene Pilatus isahkiskere Kiyapwiye Jesus. Ig kapusa kinetihwa gikakkis nerras hiyeg ");
INSERT INTO plu_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","henneme igkis kabiman, igkis awna: ―Daddahkisnig udahan! Daddahkisnig udahan! ");
INSERT INTO plu_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Igme awna gitkis amamnaput: ―Mmahki? Pariye mbayka gikehni? Ka kis adahan nah umahkisri. Ig yuma mbaynama gikehni. Nah biyuhkiswig. Ayteke pisenwa nah isahkiswig. ");
INSERT INTO plu_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Igkisme timapni henne, igkis kabiman kihhaw: ―Daddahkisnig! Ig timapni henne, ayge nikwe ig matiwniswe. ");
INSERT INTO plu_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ig awna: ―Hennewa nikwe ku samah gimawkankis. ");
INSERT INTO plu_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ayteke ig isahkisase ner gayaptenkis git, ner ku pariye paraksepkare apatra ig hahhayruke gikak gupelma ig umehe pahapwi. Henneme ig iké Kiyapwiye Jesus ta giwakuitkis gisuwtatapu adahan igkisme keh gikak ku samah nerras hiyeg gimawkankis. ");
INSERT INTO plu_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ayteke nikwe igkis gisuwtatapu tipikepri apititak ini paytwempu. Apigkune ahin igkis patipteke gikak pahapwi awayg sireneyene kewye Simawh. Ig gaytni powketeke. Igkis hiyapni henne, igkis mpiksaptihpig adahan ig wew gihapu Kiyapwiye Jesus adahan gayapetni hiyuhne giyakni. Igkis iké giyakni ta giteyapminat kiyapwiye Simawh. Ayteke pisenwa igkis tipikwiyes akiw. ");
INSERT INTO plu_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Kaayhsima hiyeg kabubukne kuruw gihapu. Kaayhsima tinogben ayge. Egkis tihenekwiyos, egkis kadniyos giharit kaayhsima. ");
INSERT INTO plu_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Igme Kiyapwiye Jesus hiyapni henne, ig ipeganaw gumkatkis ig awna gutkis: ―Yis tinogben jerusalémyano, ka ba yi muwaka tih nuharit. Hiyawa yis tih henneme tihnay yiharitwa, giharitkis yikamkayh hawwata. ");
INSERT INTO plu_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Mmanawa awah hawkri nemnik. Apim ini hawkri hiyeg awnanek: “Norras ku pariye ka kehti bakimni egnes kaayhsima gubunugakis. Norras ku pariye yumanano gusarayhkis gukamayhkis amadgat wayk, yumanano gusukkisnikis egnes kaayhsima gubunugakis. Mmanawa kaayhsima mbeyne ay.” ");
INSERT INTO plu_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Apim ini ignes hiyeg apisnek mpiynepepye he igkis awna ta arit waxri imuwadnene: “Uyá tuguh ta upitit. Ayam usuh.” ");
INSERT INTO plu_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Hennewa awah hawkri nemnik mmanawa ku yis hiyá hiyeg keh mbeye hawkri nukakhu henne, yiskata akiw? Ig Kiyapwiye Jesus awna inakni, ig tipikwiye akiw? Hawwata igkis keh yikaknek. ");
INSERT INTO plu_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ayge piyana gikebyikis awaykemni kakehniye igkis waxepka payak gikak Kiyapwiye Jesus adahan igkis umehpika payak gikak. ");
INSERT INTO plu_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ayteke igkis danuh ta apitit pahá waxri imuhgipitnene kewye “Waxri Hiyeg Gaptiwpitwiye”. Ayge igkis deddehe Kiyapwiye Jesus ta aminat giyakni. Ayteke igkis deddehe nerras piyananene kakehniyepwi aminat nawenépwi iyaknit akiw. Pisenwa igkis tabirase giyaknikis ayge gihumwa Kiyapwiye Jesus, pahapwi tabirasaka kihehaptak, pahapwime patuwanaptak. ");
INSERT INTO plu_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Apim ini ig Kiyapwiye Jesus piriyepkaw. Ig awna: ―Pa, uyá bayahminigkis nerras ariw inin gitaraksankis. Igkis ka hiyak ku pariye gikehnikis ku apim inin. Ayteke nerras suwtat pisenwa gidaddahnikis, igkis arehwa akak tip adahan hiyá ku pariye kabunuganen iggi darih Kiyapwiye Jesus gikawihni. Henne igkis ibekhepyes gikawihni pawtak. ");
INSERT INTO plu_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Madikte hiyeg tabirbet ayge igkis msekwe ipegbet ta gimkat. Nerras judeyenepwi giwewkistenkis igkis ayge gibetkis. Ayge igkis mahipwihpig. Igkis kinetihwa pawtak. Igkis awna: ―Kuwis ig amnihe nawenépwi hiyeg. Ku ig igyerwa Uhokri gikanyan adahan ukumaduketniwiy, hiyawa ig amnih gipit hawwata. ");
INSERT INTO plu_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Nerras suwtat ayge igkis hawwata mahipwihpig. Igkis danukwa kennesa git, igkis akaki win suwiyweye ta gimkanit. ");
INSERT INTO plu_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Igkis awna git: ―Ku pis igyerwa judeyenepwi gikiparakis, asá amnih pipit. ");
INSERT INTO plu_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ayge amin giyakni apitmin gitew pahak kagta daddahka atere. Amadga ini kagta awna: “Ig Judeyenepwi Gikiparakis.” ");
INSERT INTO plu_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Pahapwi gaytakkis nerras kakehniyepwi ku pariye daddahka ayge ig hawwata ig mahipwihpig. Ig awna git: ―Mmah pis ka Uhokri gikanyanma adahan ukumaduketni? Asá amnih pipit marihwa pis amnih usuh hawwata. ");
INSERT INTO plu_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Igme ner kakehniye pahapwiwa akiw ig timapni ner awayg giwn henne, ig himehpig. Ig awna git: ―Mmahki pis awna inakni henne? Mmah pis ka apis gibohri Uhokri? Wis ikaksaka adahan miyaka hawwata ke igbe. ");
INSERT INTO plu_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Wis kis adahan miyá adahan katiwnihpiye utaraksan. Igme ner yuma mbaynama gikehni. ");
INSERT INTO plu_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ayteke ig awna ta git Kiyapwiye Jesus. Giwn: ―Kiyapwiye Jesus, kiyenanuhba aysawnemenek ku aysaw pis ayta kumaduka. ");
INSERT INTO plu_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Igme kaytwa giwn: ―Ku apim inin pis msakwa numunhu abet kabayka ayhté giwetrikis hiyeg kibeynepwi miyarapye. Ihanaba inakni nuwnhu. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ayteke puwipka danuh. Pahaye adahan kamuw abutni ka kabutni akiw. Hawkri msanpi muwwapu juktah daraka kamuw in kapusa kabutni akiw. ");
INSERT INTO plu_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Nikwenéwa apim ini, ini kamis amaptenten Uhokri giwskekri barewpitye ku pariye agiku Uhokri Gipin in sigke pabakak. In woka ahin ta agikut ini Uhokri giwskekri. ");
INSERT INTO plu_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Nikwenéwa ig Kiyapwiye Jesus kabiman akak gihawna. Ig awna: ―Pa, nah ikí nanmaphu ta piwakuit kuri. Pisenwa gawnhan inakni, giyakek madike. Ig miyap. ");
INSERT INTO plu_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ayteke pahapwi romayene suwtat gikiparakis ig hiyapni madikte ku pariye danuh apim ini, ig kabayha Uhokri. Ig awna: ―Inyerwa ner awayg kibeyne hiyeg. ");
INSERT INTO plu_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Hawwata akiw madikte nerras hiyepnepwi ku pariye pahadgupu ayge igkis hiyapni madikte henne, igkis biyuhe gidukkis awaku giwakemnikis. Henne igkis tipik ta gipinwatkis. ");
INSERT INTO plu_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Igkisme nerras gidahewekten gukakkis norras kiyapunogben ku pariye danuhpanopwi payak gikak apititak Galiléyamnaw egkis tabirbet piyawakte aynessa. Egkis hiyap madikte. ");
INSERT INTO plu_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ayge pahapwi awayg giw José. Ig kibeyne hiyeg, waditye hiyeg. Ig pahapwi gaytakkis nerras judeyenepwi giwewkistenkis, ");
INSERT INTO plu_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","henneme gihiyakemni ka pakekuma akak ku samah igkis keh gikak Kiyapwiye Jesus ku samah igkis ahegbet ginetnikis adahan giwmasepten. Ig kiyapwiye José ig ariwntak paytwempu Arimatéya ayge apit Judeyamnaw. Ig wahepnenekwa Uhokri gikumadukan ku aysaw in danuh. ");
INSERT INTO plu_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ig kiyapwiye José hiyapni henne ku samah ayipa Kiyapwiye Jesus gimiremni, ig awna: ―Nah apuhpigte. Ig tipik ta gimkat amekene Pilatus. Ig danuh atere, ig awna ta git: ―Kiyapwiye, uyá amnihun isaksan adahan nah atere iwepye amekene Jesusmin gipit. Igme amekene Pilatus kaytwa giwn: ―Bariká. Iwepnika. ");
INSERT INTO plu_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ig kiyapwiye José timapni henne, ig tipik. Ig danuh atere, ig wiwhe Kiyapwiye Jesus gipit aminatak giyakni. Ayteke ig wanakminepri akak pahak dagam seyne barewbetye. Pisenwa ig sarayhe gipit agikut pahayku imewti agiku tip amiyokni ku pariye kote kawihkahte. ");
INSERT INTO plu_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ig keh henne abet ini hawkri ku kabet hiyeg ahegbetaw adahan mayekne abet samdi. ");
INSERT INTO plu_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Norras tinogben ku pariye danuhpanopwi payak gikak Kiyapwiye Jesus apititak Galiléyamnaw egkis hiyapni henne, egkis wew gihapu kiyapwiye José butte. Egkis hiyá Kiyapwiye Jesus gimew egkis hiyá ku samah gipit sarayhpika ta agikut ini gimew. ");
INSERT INTO plu_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ayteke ariwnteke ini egkis diyuhe gupinekutkis. Ayge egkis ahegbete imihgi akak pomad adahan gimihetni Kiyapwiye Jesus gipit adahan ig apuhpiki. Pisenwa egkis mayeke abet samdi ku samah amekene Moís gikumadukan awna. ");
INSERT INTO plu_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ayteke paka abet kabeyweke egkis tinogben tipikwiyos ta arimkanit Kiyapwiye Jesus gimew. Egkis iwé ini imihgi ku pariye gahegbetankis. Egkis tipik. ");
INSERT INTO plu_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Egkis danuh atere, egkis uté gimew asabwat ayipa wokepka. ");
INSERT INTO plu_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Egkis hiyapni henne, egkis pareke aterenewa agikut gimew. Henneme egkis ka utí Kiyapwiye Jesus gipit ayge. ");
INSERT INTO plu_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Egkis hiyapni henne, egkis wakaymnibdi kaayhsima. Egkis awna: ―Kineypahki gipit? Pahaye adahan egkis hiyá piyana awaykemni tabirwak ayge gumunkis. Igkis kasimsapu akak simis tigigihwe. ");
INSERT INTO plu_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Egkis hiyapni henne, egkis apisasew, egkis paberetusaw mabuw ta gikimpuitkis. Ayteke nikwe nerras awaykemni awna ta gutkis: ―Kiyapwiye Jesus ipeg. Mmahki yis gipegepten ay agiku miyapiye giwetri? ");
INSERT INTO plu_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ig yuma ay. Ig kuwis kannikew. Kiyemnahnay giwn ku samah ig awna yit kuhwekwa ku samah ig aynete apit Galiléyamnaw. ");
INSERT INTO plu_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Apim ini ig awna yit ku ig kamaykiswikanek ta gitkis hiyeg ku pariye mbeyepyenen gihiyakemnikis. Ig awna ku ig daddahkiswikanek henneme amamnam hawkri ariwntak gimiremni ig kannikaw akiw. ");
INSERT INTO plu_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Egkis timapni henne, egkis kiyé inakni giwn. ");
INSERT INTO plu_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ayteke nikwe egkis pese agikutak gimew egkis diyuhe ta gitkis Kiyapwiye Jesus giwatnipwi madikawkunene gikebyikis gikak pahapwi gawna (11). Egkis danuh atere, egkis ekke gitkis madikte ku pariye danuh gutkis. Henne egkis akki ta gitkis madikte gikannuhnipwi nawenépwi. ");
INSERT INTO plu_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Eg kiyapuno Mahi Madalena gaytakkis norras tinogben gukak kiyapuno Joana gukak kiyapuno Mahi ku pariye kiyapwiye Tiyagu ginag gukakkis nawenópwiwa tinogben akiw. Egkis akki madikte ta gitkis Kiyapwiye Jesus giwatnipwi. ");
INSERT INTO plu_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Igkisme timapni henne, igkis ka iha inakni gunetnikis. Gitkis he inetitapnen. ");
INSERT INTO plu_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Igme kiyapwiye Pedru kannikaw, ig sigise atere arimkanit Kiyapwiye Jesus gimew. Ig danuh atere, ig darakaw ig iwasa atere ta agikut. Ig hiyá he Kiyapwiye Jesus gidagmanpitnen in kihubete ayge agiku gimew. Yumahe gipit ayge. Ig hiyapni henne, ig tipik baruki. ");
INSERT INTO plu_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Nikwenéwa apim ini hawkri piyana gikebyikis gikannuhnipwi igkis tipikwiyes ta arimkanit pahá paytwempu kewye Emaús. In msakwa piyawakte ariw Jerusalém. Wis danuh atere adahan pisaya ler. ");
INSERT INTO plu_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Igkis waywapi apigku ahin, igkis kinetihwenes amin ku pariye danuh git Kiyapwiye Jesus amakohnokwa. ");
INSERT INTO plu_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Igkis kinetihwenes ayge akak madikte giwakemnikis. Pahaye adahan igwa Kiyapwiye Jesus humewpi gihapukis butte. Ig waywe pahamteke gikakkis. ");
INSERT INTO plu_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Igkis hiyapni henne, igkis mahikohpig. Gihiyakemnikis ka ik adahan igkis hiyakri. ");
INSERT INTO plu_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Igme Kiyapwiye Jesus ayaprikis: ―Pariye yinetni kuhwekwa ahinaprik? Igkisme msekwe barukibdi. ");
INSERT INTO plu_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Pahapwi gaytakkis kewye Kilewpas, ig awna: ―Mmah pis nawwotunye arit Jerusalém? Mmah pis ka hiyak ku pariye danuh ayge apim inin hawkri? ");
INSERT INTO plu_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Igme ayaprikis: ―Pariye danuh? Igkisme kaytwa giwn: ―Ku pariye danuh ta git amekene Jesusmin, ig nazaréyene. Ig Uhokri gawnepe. Ig keh kibeynenen annut. Ig awna kibeynenen yuwit. Uhokri ay gikak. Madikte hiyeg kiyatig. ");
INSERT INTO plu_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Henneme nerras muwpeg kiyatyepwi gikakkis uwewkistenwiy igkis kamaykiswig adahan ig ikaksaka adahanikwa miyaka. Ayteke igkis daddahkiswig. ");
INSERT INTO plu_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Usuhme upewkankama ku ignewa ayta uwiwhpitniwiy giwakutakkis upetunyapuwiy wixwiy israelyenepwi. Ku apim inin kuwis amamnam hawkri ariwntak ku samah ini mbeyne danuh git. ");
INSERT INTO plu_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Henneme ku apim inin aynessa waytakhu tinogben keh usuh wakaymni mpiynepepye. Kabeyweke egkis tipik arimkanit gimew. ");
INSERT INTO plu_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Egkis danuh atere, egkis ka utí gipit ayge. Ayteke nikwe egkis diyuh ta wothu. Egkis awna wothu ku egkis hiyá he ahjnenwa hiyapkiswa gutkis. Igkisme awna gutkis ku ig Kiyapwiye Jesus kuwis ipeg akiw. ");
INSERT INTO plu_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Waytakhu timapni henne, igkis tipik iwasenes gimew. Igkis danuh atere, igkis hiyá ku inyerwa ku samah norras tinogben awna. Henneme igkis ka hiyapri ayge. ");
INSERT INTO plu_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ig Kiyapwiye Jesus timapni henne, ig awna gitkis: ―Mmahkay yis ka pukuhasaki? Mmahkay yis ka iha madikte ku pariye Uhokri gawnepepu pitatyepwi awna? ");
INSERT INTO plu_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Amawka ku Cristo hiyá madikte ini mbeyne ayteke nikwe Uhokri ikí gikiythani ta gipitit akiw ayhté inugik. ");
INSERT INTO plu_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ayteke nikwe ig Kiyapwiye Jesus akkamnih madikte yuwit amadgatak Uhokri gannasan minikweknene ku pariye kinetihwa gimin. Ig kapusa ariwntak amekene Moís gikagtan, ig akkamnih madikte gannasankis Uhokri gawnepepu pitatyepwi ku samah in kinetihwa gimin. ");
INSERT INTO plu_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ayteke ariwnteke ini igkis kennesmin gidawnhankis arimkanit ini paytwempu ku kitwiye igkis. Ig Kiyapwiye Jesus keh ke wotbe ig mapiyepni, ig tipiknene. ");
INSERT INTO plu_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Igkisme kinistig adahan ig msakwa ayge gikakkis. Igkis awna git: ―Uyá msakwanate ay ukakhu, mmanawa kuwis aygete, kabá msanpi. Ig timapni henne, ig parak atere adahan ig msakwa gimunkis. ");
INSERT INTO plu_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ig batahkiswe atere adahan axne gikakkis. Ig kidis bugut. Ig kabayha Uhokri. Ayteke ig sigkebdih ini bugut ig ibekhepni gipuriwkis. ");
INSERT INTO plu_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Aynewa Uhokri woke gihiyakemnikis. Igkis hiyakri ku ig Kiyapwiye Jesus. Aynewa akiw ig menwepi giwkis. ");
INSERT INTO plu_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Igkis hiyapni henne, igkis kinetihwa pawtak. Igkis awna: ―Ignewa Kiyapwiye Jesus. Mmanawa ku samah ig kinetihwempiye ukak ig akkamnihpiye Uhokri gannasan wot, giwn dax ta apit uyakni. ");
INSERT INTO plu_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ayteke nikwe igkis kannikaw igkis diyuhe tipik ta apitit paytwempu Jerusalém akiw. Igkis danuh atere, igkis uté giwatnipwi madikawkunene gikebyikis gikak pahapwi gawna (11), ignes pahadgupunas gikakkis gikannuhnipwi nawenépwi. ");
INSERT INTO plu_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ku samah igkis danuhantenwa atere, ignes kit awna gitkis: ―Inyerwa Kiyapwiye Jesus kannikew. Ig kuwis hiyapkiswe ta git Simawh Pedru. ");
INSERT INTO plu_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Nerras piyananene gikebyikis timapni henne, igkis akki gitkis ku pariye kuhwekwa danuh gitkis ahinaprik. Igkis akki ku samah igkis hiyakri amun ku samah ig sigkebdihne bugut gidahankis. ");
INSERT INTO plu_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ku samah igkis awnempiye inakni yuwit, igwa Kiyapwiye Jesus hiyapkiswa tabir ayge gibetkis. Ig awna gitkis: ―Uhokri gabay yikaknek. ");
INSERT INTO plu_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Igkisme wakaymnibdi mpiynepepye igkis apisasew mpiynepepye. Gitkis igkis hiyá pahapwi anmapti. ");
INSERT INTO plu_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ig hiyapni henne, ig awna gitkis: ―Mmahki yis kiyimwihwa? Mmahki yis mategbeta yihiyakemni? ");
INSERT INTO plu_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ipegnay ta nuwakuit ta nukugkuprikut adahan yis hiyak ku nahnewa ay in. Daxtanuy. Ayge nikwe yis ihpin. Mmanawa anmapti yuma gih yuma gapita kema nahma. ");
INSERT INTO plu_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ig awna inakni, ig akki giwak gitkis akak gikugku adahan igkis hiyá pudubdu adukwen. ");
INSERT INTO plu_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Igkis hiyapni henne, igkis batek mpiynepepye. Kabahte igkis ka ikwa adahan ihpin. Igkis wakaymnibdi mpiynepepye. Ig Kiyapwiye Jesus hiyapni henne, ig awna gitkis: ―Ba yis kamananama adahan nah ax? ");
INSERT INTO plu_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Igkis timapni henne, igkis ikí git im tepka. ");
INSERT INTO plu_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Igme iwepni, ig axni ay giwtrikneswa. ");
INSERT INTO plu_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ayteke nikwe ig awna gitkis: ―Kuhwekwa ku samah nah aynete yikak, nah akki yit madikte ku pariye amekene Moís gikagtan kinetihwa numinhu, madikte ku pariye Uhokri gawnepepu pitatyepwi kinetihwa numinhu, madikte ku pariye kagta apatkekne Salmus kinetihwa numinhu. Nah awna yit ku inyerwa in danuh nuthunek. Kuri, kibeyne, metakwa in kuwis kahayak. ");
INSERT INTO plu_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ayteke nikwe ig woke gihiyakemnikis adahan metakwa igkis pukuha Uhokri gannasan gidahan. ");
INSERT INTO plu_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ig awna gitkis: ―Uhokri gannasan minikweknene awna ku amawka nah hiyá mbeyne kaayhsima, amawka nah umehpika, henneme amamnam hawkri ariwntak numiremni nah kannikaw akiw. ");
INSERT INTO plu_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Hawwata akiw in awna ku amawka inetitkekne atak muwwapu nuwntak adahan ekkene nuwnhu ta gitkis madikte hiyegipiyenepwi. Igkis inetitkekne kinetihwa gitkis adahan ignes wages gihiyakemnikis marihwa Uhokri bayahminigkis ariw gitaraksankis. ");
INSERT INTO plu_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Yisnewa ku pariye inetitkekne ndahan adahan ekkene inakni yuwit ta gitkis. Pitatye yis kapusa akkin ay Jerusalém. ");
INSERT INTO plu_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Hawkuwanek nah kawihkis ntipuh ta yipititnek ku pariye Wigwiy gikaksan ta yit. Msakwanabay ay apit ini paytwempu Jerusalém juktah ku aysaw Uhokri gannu kawihkiska ta yipititnek. ");
INSERT INTO plu_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ayteke pisenwa inakni gawnhan, igkis pese. Ig Kiyapwiye Jesus waxeprikis kennesa arimkanit paytwempu Betâniya. Ayge ig awokasaw ta gimkanitkis. Ig sarayh kabayka ta gipititkis. ");
INSERT INTO plu_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Hennewa ig tipik giwkis ig iwepka ta inugikut. ");
INSERT INTO plu_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Igkis hiyapni henne, igkis kabayhig. Ayteke igkis diyuhe ta apitit Jerusalém akak madikte gibetkikis. ");
INSERT INTO plu_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ariwnteke ini igkis takunipti agiku ini leglis kewye Uhokri Gipin. Ayge igkis kibeyhenes Uhokri takunipti.");
INSERT INTO plu_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Minikwak apit hawkri humaw, ner ku pariye “Uhokri giwn” ayipa ig ay kuwis. Ig kanumka “Uhokri giwn” mmanawa ignewa ekkene wotwiy Uhokri ku samah gihiyakemni. Ig ay gikak Uhokri. Ig igyerwa Uhokri. ");
INSERT INTO plu_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Hennewatbaki ig ayipa ay gikak Uhokri ay minikwak apit hawkri humaw. ");
INSERT INTO plu_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Madikte ariknebdi ay amadga hawkri in humaw giwntak Uhokri. Waké ka ignema, yuma ariknawnama humawkam ay amadga hawkrikam. ");
INSERT INTO plu_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Dehetniki pes giwntak. Ku samah kamuw abutni uguh hawkri in keh hiyeg hiyap, hawwata ig uguh hiyeg gihiyakemnikis, ig keh igkis hiyak ku pariye hiyakemniki inyerwatnene. ");
INSERT INTO plu_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Hiyeg amedgenepwi inin gihiyakemnikis ke wotbe abet amisnapyibe. Igme uguh gihiyakemnikis adahan igkis hiyak ku pariye hiyakemniki inyerwatnene. Kibeyne, ku samah amisnapyi ka hiyá asamanak adahan msanpih kabutniki, kawnata hiyeg gimebyemnikis hiyá asamanak adahan mpitig. ");
INSERT INTO plu_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Minikwak pahapwi awayg awahkiska uminwiy gapit Uhokri. Giw João Batista. ");
INSERT INTO plu_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ig awahkiska ayta ekkepye wotwiy Kiyapwiye Jesus, ku pariye uguhekeputne uhiyakemniwiy. Uhokri gimawkan madikte hiyeg kamaxwenekwiye ta gipitit Kiyapwiye Jesus awaku ku samah igkis timap giwn amekene João Batista. ");
INSERT INTO plu_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ka ignema amekene João Batista ka ignema uguhekeputne uhiyakemniwiy. Kawa. Ig he gekhetninen. ");
INSERT INTO plu_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Igme ner ku pariye igyerwa kabutniki ahawkri ig uguh madikte hiyeg gihiyakemnikis. Minikwak ig Kiyapwiye Jesus danuh atan amadgat inin hawkri. ");
INSERT INTO plu_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ig msakwa ay. Ignewa humawasa inin hawkri henneme hiyeg amedgenepwi inin hawkri igkis mahikohe ner ku pariye gihumtenkis. ");
INSERT INTO plu_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ig ayta atan amadgat inin hawkri ku pariye gidahan gikehapan henneme igkis ku pariye gidahan gikehapan igkis ka amapig. ");
INSERT INTO plu_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Gaytakkisme amapig. Nikwe ta gitkis nerras ku pariye gamerepten, atere ig iké gawaygyikis adahan igkis humaw Uhokri gikamkayupwi. Mmanawa ku samah igkis kamaxwa ta gipitit Kiyapwiye Jesus igkis humaw Uhokri gikamkayupwi. ");
INSERT INTO plu_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Apim ini igkis waypuka igyerwa Uhokriyanpu. Ini giwaypukakis ka ariwntakma tino. Iné kawnata ariwntakma hiyeg gihiyakemnikis amadgaya inin. Iné kawnata akakma hiyeg gimapuswankis akak gikehbetankisma. Henneme giwntak ignewa Uhokri igkis waypuka. ");
INSERT INTO plu_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Kibeyne. Ig ner ku pariye “Uhokri giwn” ig wageswe hiyeg amadgaya inin. Ig ihtikekne. Ig ayta msakwa atan ubetwiy wixwiy amadgayapu inin. Ig kagabayisima. Ig awna hiyakemniki ku pariye inyerwatnene. Akakwa wowtyak usuh hiyap gikiythani nernewa Uhokri gikamkayh gikiythani. ");
INSERT INTO plu_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Igme amekene João Batista akkig ta gitkis hiyeg. Ig awna: ―Ig Kiyapwiye Jesus igyerwa ner ku kamin nah kuwis kinetihwa yit. Nah kit danuh giw. Igme danuh nuhapuh butte. Henneme ig kaayhsima pi kiyatte mpiyhan mmanawa apit nah ay, ig ayipa ay kuwis. Hennewatbaki ig amekene João Batista akkig. ");
INSERT INTO plu_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ig Kiyapwiye Jesus kagabayisima. Wixwiyme utí wabaywiy giwntak Kiyapwiye Jesus. Kibeyne, ig wagahkisnene wabaywiy adahan takunipti. ");
INSERT INTO plu_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Minikwak amekene Moís ekkene Uhokri gikumadukan ta gitkis hiyeg. Kurinme ig Kiyapwiye Jesus Cristo ig ekkene Uhokri gabay ta gitkis hiyeg. Ig akki gitkis ku pariye hiyakemniki inyerwatnene. ");
INSERT INTO plu_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Yuma pahapwinama hiyeg amadgaya inin gihiypetni Uhokri. Henneme igwa gibetki gikamkayh ignewa ku pariye akkamnihgi wotwiy abet uhiyakemniwiy adahan wixwiy hiyakri. ");
INSERT INTO plu_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Judeyenepwi giwewkistenkis ayhté Jerusalém igkis awahkise gaytakkis nerras muwpegpiyene gikakkis gayapetnikis ta gimin amekene João Batista. Igkis awna gitkis: ―Ataknabay ta git Kiyapwiye João Batista. Ayapnay ku pariye ig. Igkis timapni henne, igkis tipik. Igkis danuh atere, igkis ayapri: ―Pariyekap? Ba pisnewa Cristo? Ba pisnewa Uhokri gikanyan adahan ukumaduketniwiy? ");
INSERT INTO plu_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Igme kaytwa giwnkis huwewe. Ig awna: ―Kawa. Nah ka Cristoma. ");
INSERT INTO plu_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Igkis timapni henne, igkis awna: ―Pariyekap nikwe? Ba pisnewa amekene Eliyas kannikaw akiw? Igme kaytwa giwnkis: ―Kawa. Nah kawnata amekene Eliyasma. Igkisme awna: ―Ba pisnewa ner Uhokri gawnepe ku kamin minikwak amekene Moís kinetihwa ku ig awahkiska atannek? Igme kaytwa giwnkis: ―Kawa. Nah kawnata ignema. ");
INSERT INTO plu_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Igkis timapni henne, igkis awna git: ―Pariyekap nikwe? Amawka usuh akkap ta gitkis wawahkisten. Uyá akki wothu ku pariye pis. ");
INSERT INTO plu_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Igme kaytwa giwnkis: ―Minikwak Uhokri gawnepe amekene Isaías kinetihwa gimin pahapwi ku pariye ayta gapitkiya Ukiparawiy adahan ahegbetepye madikte gapit. Ig awna ku ner pahapwi kinetihwanek ta gitkis hiyeg ay amadga amatap. Ayge ig awnenek: “Ahegbetawnabay gapit Ukiparawiy gaytni. Ig nemnik ig.” Nahnewa ner pahapwi ay kuri. Hennewatbaki ig amekene João Batista awna. ");
INSERT INTO plu_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Nerras awaykemni ku pariye kinetihwene gikak amekene João Batista, igkis awahkiska gapitkis farisewkis. ");
INSERT INTO plu_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ayge nikwe igkis ayapri: ―Ku pis ka Cristoma, ku pis ka amekene Eliyasma, ku pis ka Uhokri gawnepema, kariwntak pis utí pikumadukan adahan pis kaywa hiyeg? ");
INSERT INTO plu_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Igme kaytwa giwnkis: ―Nahwa kadahan ini nukumadukan adahan nah kaywene hiyeg ahakwat un. Henneme ay pahapwi ubetwiy ku pariye pi kiyatte mpiyhan. Yis ka hiyakri. ");
INSERT INTO plu_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ig nemnikumpiye nuhapuh butte henneme ig kaayhsima pi kiyatte mpiyhan. Nah yuma nukiythanisima gitiput adahan nah ayapig wiwh gikasotni gikugkuptak. ");
INSERT INTO plu_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Igkis kinetihwene inakni henne ayge paytwempu Betâniya. Ini paytwempu kennesa arimkat warik Jordawh. Ayge Jordawh ku kiney ig amekene João Batista kaywene hiyeg. ");
INSERT INTO plu_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Hewke akiw ig amekene João Batista hiyá Kiyapwiye Jesus mpiya gimuniw. Ig hiyapni henne, ig awna ta gitkis hiyeg: ―Ipegnay ner igyerwatnene muttuhyan giwntekne Uhokri. Wixwiy inpawa umah muttuhyan udukwenaprikwiy adahan igkis katiwnihpiye udahanwiy utaraksanwiy. Igkis muttuhyan he arakaknen gidahan ner awayg. Igme igyerwa katiwnih gidahankis madikte hiyeg gitaraksankisnek. ");
INSERT INTO plu_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ignewa ner ku pariye nah kinetihwa gimin ku ig nemnikumpiye nuhapuh butte henneme ig pi kiyatte mpiyhan mmanawa apit nah ay ig ayipa ay kuwis. ");
INSERT INTO plu_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Pitatye nah ka hiyakri ba ig giwntakwatnama Uhokri. Kurime nah hiyak. Nah awahkiska ayta adahan nah gekkepten ta yit yis hiyeg israelyenepwi. Adahanikwa ini nah ayta kaywene hiyeg ahakwat un. ");
INSERT INTO plu_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Apim ini ig amekene João Batista akkamnihne ku samah ig hiyá Uhokri Gitip ayta inugiktak, gihipak ke pahapu tukwabe, ig msakwa ta gipitit Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Giwn: ―Pitatye nah ka hiyakri ba ig giwntakwatma Uhokri. Henneme ig Uhokri ku pariye nawahkisten adahan nah kaywene hiyeg ahakwat un, ig akkig nuthu. Ig awna nuthu: “Ku pis hiyá ntiphu muhuk msakwa ta gipitit pahapwi, ignewatbaki ku pariye kaywa hiyeg gikak igyerwa ntiphu barewpitye adahan ig kawihkis ndahanwa nuhiyakemni ta gipititkis.” ");
INSERT INTO plu_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ayteke nah hiyá ig Uhokri Gitip msakwa ta gipitit ner awayg. Inneki keh nah awna ku igyerwa Uhokri gikamkayh. Hennewatbaki ig amekene João Batista awna. ");
INSERT INTO plu_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Hewke akiw ig amekene João Batista hiyá Kiyapwiye Jesus akiw. Apim ini ig tabirwak gikakkis gikannuhnipwi piyana gikebyikis. ");
INSERT INTO plu_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ayge ig hiyá Kiyapwiye Jesus mpiya. Ig ipegi atere gimkat. Ig awna: ―Ipegnay ner igyerwatnene muttuhyan giwntekne Uhokri. Ig umahkiswenek udukwenaprikwiy ke pahapwi muttuhyanbe adahan katiwnihpiye udahanwiy utaraksanwiy. ");
INSERT INTO plu_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Igkis piyananene gikebyikis timapni henne, igkis tipik makekwepi gihapu Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Igme Kiyapwiye Jesus wagestaw, ig hiyaprikis. Nikwe ig awna gitkis: ―Pariye yimawkan ayta nuhapuh butte? Igkisme kaytwa giwn: ―Kiyapwiye “Rabi”, kineyki pipin? Inakni yuwit “Rabi” wownaprikwiy “ukannuhten”. ");
INSERT INTO plu_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Igme kaytwa giwnkis: ―Ba yi ayta iwasa. Igkis timapni henne, igkis tipik gihapti. Daraka kamuw igkis danuh ta gipinwat. Ayge igkis hiyak ku kiney ig msakwa. Nikwe igkis parak atere. Igkis msakwa gikak he aygete. ");
INSERT INTO plu_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Pahapwi gaytakkis nerras piyananene gikebyikis ku pariye ihe inakni amekene João Batista giwn, ig kewye André. Ig kiyapwiye Simawh Pedru gisamwi. ");
INSERT INTO plu_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Pisenwa ig tipik wadite gimkat gegni kiyapwiye Simawh. Ig danuh atere, ig awna git: ―Yey. Usuh kuwis patiptak gikak “Messiyas”. Inakni “Messiyas” wownaprikwiy “Cristo”, inaknikok “Uhokri gikanyan adahan ukumaduketniwiy”. ");
INSERT INTO plu_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ayteke ig waxe kiyapwiye Simawh ta git Kiyapwiye Jesus. Igkis danuh atere, ig Kiyapwiye Jesus murotpi git kiyapwiye Simawh. Ig awna git: ―Pis Simawh, ku pariye kiyapwiye João gikamkayh. Inakni piw “tipisa”. Aysawnemenek pis nawenéwa piw akiw. Pis kanumkanek “Sefas”. “Sefas” wownaprikwiy “Pedru”. Inakni giw “tip nopsadnano”. ");
INSERT INTO plu_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Hewke akiw ig Kiyapwiye Jesus tipikwiye ta apitit Galiléyamnaw. Ig danuh atere, ig uté pahapwi awayg kewye Filip. Ig awna git: ―Ba ayta wew nukakhu adahan pis humewne nukannuhni. Igme kaytwa giwn: ―Uyá. ");
INSERT INTO plu_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ig kiyapwiye Filip ariwntak paytwempu Betsayda, ku kiney kiyapwiye André gikak kiyapwiye Simawh msakwa. ");
INSERT INTO plu_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ayteke ig kiyapwiye Filip tipik iwasa pahapwi gikagmada kewye Natanael. Ig danuh atere, ig awna git: ―Usuh kuwis patiptak gikak Uhokri gikanyan adahan ukumaduketniwiy, ner ku pariye amekene Moís kinetihwa gimin, ner ku pariye Uhokri gawnepepu pitatyepwi kinetihwa gimin. Iggi Kiyapwiye Jesus nazaréyene, ku pariye kiyapwiye José gikamkayh. ");
INSERT INTO plu_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Igme kiyapwiye Natanael timapni henne, ig awna git: ―Mmah henne? Nah kabahte ka iha inakni piwn. Yuma pahapwinama hiyeg nazaréyene kibeyne hiyeg. Igme kiyapwiye Filip kaytwa giwn: ―Ba ayta iwasa. Igkis tipik. Igkis danuh atere git Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ig Kiyapwiye Jesus hiyaprikis ayta gimkanit. Ig awna: ―Oo. Nemnik pahapwi ku pariye igyerwa Uhokri gihiyega israelyene. Ig ka batek kinis hiyeg kema amekene Jakóma. ");
INSERT INTO plu_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ig kiyapwiye Natanael timapni henne, ig awna git: ―Mmah ahiyaka pit inakni? Pis ka hiyakun. Igme kaytwa giwn: ―Apit Filip waxwep atan nah kuwis hiyak ku pariye ay abet pihiyakemni. Ku aysaw pis ayhté anapi no ah akat kewyo “figeyra”, nah kuwis hiyak ku pariye ay abet pihiyakemni. ");
INSERT INTO plu_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Igme kiyapwiye Natanael timapni henne, ig awna git: ―Kiyapwiye, nikwe pis Uhokri gikamkayh. Pis ukipara usuh hiyeg israelyenepwi. ");
INSERT INTO plu_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Igme Kiyapwiye Jesus awna git: ―Kibeyne pis kamaxwa nupitit awaku nah awna inakni pahat yuwit pit. Aysawnemenek pis hiyá annut pi kabayte ariw ini. ");
INSERT INTO plu_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Hennewatbaki pis hiyá. Aysawnemenek yis hiyanek en wokhaw hawwata ke amekene Jakóbe. Ayge yis hiyá Uhokri giwatnipwi ahj muhukempi wagehempi hawwata ke igbe. Igkis muhukempi numkanit nah ku pariye wageswe awayg amadgaya inin. Pisenwa inakni giwn igkis tipik. ");
INSERT INTO plu_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Igkis danuh atere Galiléyamnaw. Ariwnteke ini pina hawkri akiw pahapwi awayg ayge kehne fet adahan maripkawka apit pahá paytwempu kewye Kana. Ig Kiyapwiye Jesus ginag ayge iwasano ini maripkawka. ");
INSERT INTO plu_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ig Kiyapwiye Jesus ukakhu usuh gikannuhnipwi usuh hawwata awnasaka atere. Nikwe usuh tipik danuh atere, usuh fetya ayge. ");
INSERT INTO plu_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Pahaye adahan win makere. Ig Kiyapwiye Jesus ginag hiyapni henne, eg awna git gukamkayh. Guwn: ―Kuwis win makere. ");
INSERT INTO plu_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Igme Kiyapwiye Jesus kaytwa guwn: ―Kiyapuno, ka muwaka kiyimwihwa nikak. Uhiyakemni ka patiptak mmanawa nah ka kiyimwihwa akak akebyi inin. Ka muwaka hiyak nikak. Nahwa hiyak nikak. Henneme kote danuhte nuhawkanaprik adahan nah ekkewne ku pariyene nah. ");
INSERT INTO plu_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Eg ginag timapni henne, eg awna ta gitkis fet akipara gihiyegapu: ―Ku pariye ig awna yit, ihanabay inakni giwn. ");
INSERT INTO plu_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ayge puguhkuna akebyi daripwit tiptiye adahan sukokewket mmanawa hiyeg judeyenepwi sukokaw kibereput. Mpuse daripwit kawih adahan kabahkam sah (100) lit. ");
INSERT INTO plu_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ig Kiyapwiye Jesus hiyapni henne, ig awna gitkis nerras fet akipara gihiyegapu: ―Kipunsanabay no daripwit akak un. Igkis timapni henne, igkis kipunsapemni kipunmadape. ");
INSERT INTO plu_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Igme hiyapni henne, ig awna: ―Kapuknabay niwntak. Ewkninay ta git fet akipara. Igkisme iha giwn. Igkis ewkwin ta git ner fet akipara. ");
INSERT INTO plu_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Igkis danuh atere git, ayipa ini un kuwis wageswe win. Igme fet akipara ig higepni ig ka hiyaknima ba in win unma. Igkisme gihiyegapu hiyakni mmanawa igkis nikapketni. Pisenwa gihigpan ig humak ner awayg ku pariye maripkewpiye. ");
INSERT INTO plu_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ig awna git: ―Madikte hiyeg ku aysaw ignes keh fet, igkis kapusa akak win kibeynewa. Ayteke ku aysaw hiyeg kuwis ihuhpewne akak ini win ayipwipye, nikwe pes win ka kibeynema akiw kema pitatyema. Pisme ka keh henne. Pis darihe ini win ku pariye pi kabaytenene adahan kurinewa pis ikí wothu. Hennewatbaki ig fet akipara awna. ");
INSERT INTO plu_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Usuh gikannuhnipwi hiyapni henne ku samah ig Kiyapwiye Jesus keh ini kibeyne annut, usuh pi kamaxwate gipitit akiw mmanawa in hiyapkis wothu gikiythani. Ig keh ini annut apit paytwempu Kana ayge Galiléyamnaw. In pitatye annut ig keh ku pariye hiyeg amadgaya inin ka hiyá nikehka. ");
INSERT INTO plu_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Amapyaha ini fet ig Kiyapwiye Jesus tipik tahhan apitit paytwempu Kafarnawh. Ig tipik gukak ginag payak gikakkis gisamwipwi. Usuhme gikannuhnipwi hawwata tipik gihapti. Usuh mpiyasa aynessa hawkri ayge gikak. ");
INSERT INTO plu_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ayteke ahawkanaprik danuh adahan hiyeg judeyenepwi fetya adahan kiyene ku samah minikwak Uhokri wiwhkiswiye amekenegben giwakutakkis hiyeg ejituyenepwi. Ig Kiyapwiye Jesus hiyapni henne, ig tipik ta apitit paytwempu Jerusalém ku kiney gipetrakis. ");
INSERT INTO plu_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ig danuh atere, ig parak ta agikut ini leglis kewye Uhokri Gipin. Ayge ig hiyá hiyeg batebdebdihpikis igkis piyuknes pak, muttuh, tukwa adahan hiyeg kakanhewne ta git Uhokri. Hawwata ig hiyá hiyeg uniyehkeputnepwi karukri ayge. ");
INSERT INTO plu_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ig Kiyapwiye Jesus hiyapni henne, ig kehe pahat tiray akak kuwawta. Ig ipukeprikis madikte payak gikakkis muttuh gikakkis pak. Hawwata ig padakape nerras ku pariye uniyehkeputnepwi gikakurakis. Ig tukuhape gaxtenkis. ");
INSERT INTO plu_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ig awna ta gitkis nerras piyuknepwi tukwa. Giwn: ―Iwapapemni madikte aytekihan. Inin payt ini Nighu gipin. Ka yi muwaka keh in humaw pahayku piyukket. ");
INSERT INTO plu_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Usuh gikannuhnipwi hiyapni henne, usuh kiyé pahat yuwit amadgatak Uhokri gannasan minikweknene. Inakni yuwit awna: “Nah kiyatha Uhokri Gipin mpiynepepye. Nah ka hiyepkere ariknawnama patahwaki parak atere.” ");
INSERT INTO plu_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ayteke nerras judeyenepwi giwewkistenkis ayge, igkis awna git Kiyapwiye Jesus: ―Mmahki pis keh ini ku pariye pikehni ay? Kitak pis utí pikumadukan adahan pis keh henne? Asá keh annut wowtrik adahan arekhetni pidatni wothu kahadbe usuh hiyakpi ba pis ayta giwntakwatma Uhokri. ");
INSERT INTO plu_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Igme kaytwa giwnkis: ―Nah akkite yit pahatwowa annut. Hiyawa yis mehe inin Uhokri Gipin. Adahan mpana hawkri nah kannikasepni akiwnek. ");
INSERT INTO plu_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Igkisme kaytwa giwn: ―Usuh wagahkise inin payt abet kaayhsima kamukri, paxkabu madikwa akebyi akak puguhkunabu arawna (46). Mmah ik adahan pis kannikasin adahan mpana hawkri? Ka ik. ");
INSERT INTO plu_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Igkis ka pukuha inakni Kiyapwiye Jesus giwn patuwesbuhka. Bawa ig kinetihwa amin gipit ku pariye inyerwa Uhokri Gipin. ");
INSERT INTO plu_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ariwntak ini ku aysaw ig kuwis kannikaw ariw gimiremni, apim ini usuh gikannuhnipwi kiyé inakni giwn. Inneki keh usuh iha madikte Uhokri gannasan minikweknene amin gikankawni. Hawwata apim ini usuh iha madikte Kiyapwiye Jesus giwn amin gikankawni. ");
INSERT INTO plu_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ayge Jerusalém abet ini fet adahan kiyene ku samah minikwak Uhokri wiwhkiswiye amekenegben giwakutakkis hiyeg ejituyenepwi, ayge ig Kiyapwiye Jesus keh kaayhsima annut ku pariye hiyeg amadgayapu inin ka hiyá nikehka. Ini annut humaw arekhetni gidatni. Kaayhsima hiyeg hiyapni henne, igkis ihe ku ig Kiyapwiye Jesus igyerwa Uhokri gikanyan adahan ukumaduketniwiy. ");
INSERT INTO plu_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Henneme ig ka kamaxwa ta gipititkis nerras hiyeg awaku ig hiyakni ku hiyeg gihiyakemnikis atekegbetwiye. ");
INSERT INTO plu_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ig ka muwaka pahapwi adahan ekkene git ku samah hiyeg gihiyakemnikis amadgaya inin mmanawa ig kuwis hiyak kabayhtiwa ku samah gihiyakemnikis. ");
INSERT INTO plu_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Pahapwi awayg farisew ayge. Giw Nikodémus. Ig pahapwi gaytakkis hiyeg judeyenepwi giwewkistenkis. ");
INSERT INTO plu_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Pahay hawkri tiyegim ig tipik danuhpene ta git Kiyapwiye Jesus. Ig danuh atere, ig awna git: ―Kiyapwiye, usuh hiyakni ku Uhokri awahkispi adahan ukannuhten. Yuma pahapwinama awayg hiyá akehka akebyi ini annut ku pariye pis keh. Waké pis ka gikakma Uhokri, pis ka hiyakam nikehka. ");
INSERT INTO plu_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Igme Kiyapwiye Jesus kaytwa giwn: ―Ku pahapwi ka waypuka nukunewa akiw, ig ka hiyá igma kawih Uhokri gikumadukan. Ihanaba inakni nuwnhu. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Igme kiyapwiye Nikodémus kaytwa giwn: ―Mmahpaki ig pahapwi waypuka akiw, ig ku kiyapwip? Ig ka hiyá igma diyuh gutunrikut ginag akiw adahan eg sarayhgi amadgat wayk akiw. ");
INSERT INTO plu_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Igme Kiyapwiye Jesus awna: ―Pugamawka ku madikte hiyeg gitipkis waypuka giwntak Uhokri Gitip. Amawka ku gihiyakemnikis barewbethaki ke wotbe akak unbe. Ku ka hennema, igkis ka hiyá igkisma kawih Uhokri gikumadukan. Ihanaba inakni nuwnhu. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ku pariye waypuka ariwntak amadgaya inin in amadgayawa inin. Inme utip waypuka akiw giwntak Uhokri Gitip. ");
INSERT INTO plu_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ka muwaka wakaymni adahan ku samah nah awna pit adahan hiyeg gitipkis waypuka nukunewa akiw. ");
INSERT INTO plu_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Nah akkite pit abektey akak ke maygbe. Mayg he mapiyepyenen. Hiyeg timapni henneme igkis ka hiyak ku kitak in humaw. Iné igkis kawnata hiyak ku kitwiye in mpiye. Hawwata ig Uhokri Gitip keh hiyeg gitipkis waypuka igkis ka hiyak ku samah. ");
INSERT INTO plu_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ig kiyapwiye Nikodémus timapni henne, ig awna: ―Mmah adawnhan inakni? ");
INSERT INTO plu_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Igme Kiyapwiye Jesus kaytwa giwn: ―Pis hiyeg israelyenepwi gikannuhtenkis gimin Uhokri giwn. Mmah pis ka pukuha inakni nuwnhu? ");
INSERT INTO plu_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Usuh kinetihwa amin ku pariye usuh hiyak. Usuh ekkene ku pariye usuh hiyap. Ihanabay inakni nuwnhu. Hennewatbaki in. Yisme judeyenepwi giwewkistenkis yis ka amapa wownhu. ");
INSERT INTO plu_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nah kuwis kinetihwa yit amin ku pariye mpiya ay amadga inin henneme yis ka iha nuwnhu. Ku nah kinetihwa amin ku pariye mpiya ayhté inugik, yis kawnata iha nuwnhunek. ");
INSERT INTO plu_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Yumahte hiyeg wagehe ta inugikut adahan ig diyuh akkamnihni ta gitkis hiyeg amedgenepwi inin. Nahnewa akkamnihni gitkis hiyeg mmanawa nah ku pariye wageswe awayg amadgaya inin nah ayta inugiktak, nah inugikyene. ");
INSERT INTO plu_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","―Minikwak amekene Moís ayhté amadga amatap. Ayge ig keh pahapwi kaybune gahehpak akak kuwiwra. Ig ikepni ta inut amin pahat ah, adahan gihiyegapu ipeg atere kahadbe igkis makniw ariw ku samah igkis kagehpika gapit kaybune. Nah ku pariye wageswe awayg amadgaya inin amawka ku nah hawwata ikepka ayhté inut amin pahat ah. ");
INSERT INTO plu_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Kahadbe ku pariye hiyeg kamaxwepye ta nupitit igkis ka biyuk giw Uhokri, henneme igkis aymuhwa gimun Uhokri adahan apanenekwa. Hennewatbaki ig Kiyapwiye Jesus awna. ");
INSERT INTO plu_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Mmanawa Uhokri batek gikakkis madikte hiyeg mpiynepepye. Inneki keh ig iké nernewa gikamkayh adahan ku pariye hiyeg kamaxwepye ta gipitit, ig ka biyuk giw Uhokri, henneme ig aymuhwa gimun Uhokri adahan apanenekwa. ");
INSERT INTO plu_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ig Uhokri awahkis gikamkayh atan kawki adahan gisayraptenkisma hiyeg henneme adahan gamnihtenkis. ");
INSERT INTO plu_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Nikwe ku pariye hiyeg kamaxwenepwi ta gipitit gikamkayh, igkis ka sarayhkama hampa arimkanit biyukwiki. Igkisme ku pariye kane kamaxwa ta gipitit gikamkayh, igkis kuwis ikaksaka adahanikwa biyukwiki mmanawa igkis ka kamaxwa ta gipitit nernewa gikamkayh Uhokri. ");
INSERT INTO plu_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ig gikamkayh ayta uguhpiye hiyeg gihiyakemnikis adahan igkis hiyak gipathawnikis. Henneme hiyeg ka muwaka ig uguh gihiyakemnikis. Igkis ka muwaka gipathawnikis ekkepka gitkis. Igkis pi muwakate gihiyakemnikis msakwa ke wotbe abet amisnapyibe mmanawa gikehnikis kane kabay. Ayge nikwe igkis ipukepkanek hampa arimkanit biyukwiki ku kiney amisnapyad mtibetnene. ");
INSERT INTO plu_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Hiyeg taraksapye kawnata batek akak kabutniki amadgaya inin. Igkis ka peskere abetit kabutniki mmanawa igkis ka muwaka gitaraksankis hiyakan. ");
INSERT INTO plu_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Henneme ku pariye hiyeg kibeyne hiyeg ig ka marakwa gipit. Ig pes abetite kabutniki adahan gikehni hiyakan mmanawa ignewa Uhokri keh ig humaw kibeyne hiyeg. ");
INSERT INTO plu_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ariwnteke ini ig Kiyapwiye Jesus pes apititak Jerusalém. Usuh gikannuhnipwi peswata gihapti. Usuh danuh atere Judeyamnaw. Ayge usuh msakwa. Ig Kiyapwiye Jesus ig kaywaksene hiyeg ta wothu usuh gikannuhnipwi. ");
INSERT INTO plu_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ig amekene João Batista ig hawwata kaywene hiyeg ayhté paytwempu Enoh, kennesa arimkat paytwempu Salih, awaku kaayhsima un ayge. Ayge hiyeg danuha git adahan ig kayweprikis. ");
INSERT INTO plu_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ig kote paraksepkahte agikut parakseket. ");
INSERT INTO plu_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ig kaywene hiyeg ayge, igkis gikannuhnipwi kabá piledukaw gikak pahapwi judeyene apatra kewpiki. ");
INSERT INTO plu_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Pisenwa nikwe igkis danukwa kennesa git amekene João Batista. Igkis awna git: ―Kiyapwiye, ner ku pariye ay pikak ayhté pahambak warik Jordawh ig hawwata kaywene hiyeg. Ig ner ku kamin pis kinetihwa kibeyne inetit. Ipeg kuri ku samah ig kaywene hiyeg ahakwat un hawwata ke pisbe. Mmahki henne? Kuri madikte hiyeg ka ayta pimkat akiw. Igkis atak ta gimkat Kiyapwiye Jesus adahan igkis kaywasewpiyes ta git. ");
INSERT INTO plu_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Igme amekene João Batista kaytwa giwnkis: ―Ka sam. Ka hiyá wisma keh ariknawnama ku ka ignema Uhokri ikí wot ayta inugiktak. ");
INSERT INTO plu_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Yiswa hiyak ku samah nah kuwis kinetihwa gimin. Nah awna ku nah ka Cristoma. Nah ay he adahan ahegbetepyenen madikte gapit gaytni. ");
INSERT INTO plu_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Nah ay kewa pahapwi awaygbe ahegbetene inetit gidahan pahapwi ku pariye maripkewpiye gukak pahapu tino. No tino ka kamax iggi inetitkekne. Eg kamax iggi ku pariye maripkewkerepye gukak. Ner inetitkekne ig he tabir timepne giwn ner maripkewkerepye gukak no tino ku samah igme kinetihwene gut. Ig timapni henne, ig batek kaayhsima. Nah hawwata ku samah nah hiyá hiyeg timepne giwn Kiyapwiye Jesus nah batek kaayhsima. ");
INSERT INTO plu_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Amawka ku ig Kiyapwiye Jesus napitminan. Nahme amawka ku nah pi warikapte giw. ");
INSERT INTO plu_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ig ayta inugiktak. Inneki keh ig gapitminkis madikte hiyeg. Wixwiyme ariwntekne inin hawkri, wixwiy amadgayapu inin. Wixwiy he kinetihwa amin hiyakemniki amedgenen inin. Igme inugiktekne, ig gapitminkis madikte hiyeg. ");
INSERT INTO plu_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ig kinetihwa amin ku pariye ig hiyap ayhté inugik. Ig kinetihwa amin ku pariye ig timap ayge. Henneme ka kibitema hiyeg amepene giwn. ");
INSERT INTO plu_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ignesme ku pariye amerepye giwn igkis hiyeke Uhokri ku ig igyerwatnene. ");
INSERT INTO plu_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ig Kiyapwiye Jesus ig Uhokri gawahkisni uminwiy. Ig akki Uhokri giwn wotwiy akak madikte gikiythani giwntak Uhokri Gitip. Mmanawa ig Uhokri kipunsig akak Gitip adahan apanenekwa wagehnenekwa. ");
INSERT INTO plu_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ig batek gikak iggi gikamkayh. Ig ikí madikte kumadukaki ta git. ");
INSERT INTO plu_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ku pahapwi kamaxwepye ta gipitit gikamkayh, iggi aymuhwa gimun Uhokri adahan apanenekwa. Henneme ku pahapwi ka kamaxwa ta gipitit gikamkayh, iggi ka aymuhwati gimun Uhokri. Ig patehwepye giwtrik Uhokri. Ig ka ik adahan ig darihwak gikak. Hennewatbaki ig amekene João Batista awna. ");
INSERT INTO plu_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Apim ini nerras farisewkis kinetni Kiyapwiye Jesus gak ku ig kaywa hiyeg pi kibite giw amekene João Batista. Igkis kinetni gak ku pi kibite hiyeg wageswepye gikannuhnipwi Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Bawa ka ignema Kiyapwiye Jesus kaywene hiyeg henneme usuh gikannuhnipwi kayweprikis. ");
INSERT INTO plu_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ig Kiyapwiye Jesus timé gakkis nerras farisewkis ku igkis kinetni gak henne. Ayge nikwe ig pes apititak Judeyamnaw. Ig tipikwiye ta apitit Galiléyamnaw. Usuh gikannuhnipwi tipik gihapti. ");
INSERT INTO plu_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Apim ini amawka ku ig mpiya apuriw Samariyamnaw. ");
INSERT INTO plu_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Usuh ayge Samariyamnaw, ig danuh ta apitit pahá paytwempu kewye Sikar kennesa arimkat amekene Jakó giwaxri. Minikwak ig amekene Jakó kakanhawni ta git gikamkayh amekene José. ");
INSERT INTO plu_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Amekene Jakó giwnpína ayge. Ig Kiyapwiye Jesus mabe awaku giwewni piyawakad. Nikwe ig batahkiswe aranwa ini unipna. ");
INSERT INTO plu_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Usuhme gikannuhnipwi atak paytwempuit adahan isimwiye umana. Igme Kiyapwiye Jesus msekwe ayge. Puwipka abet pahapu tino samariyano danuh atere kapukno guwnra. Ig Kiyapwiye Jesus hiyapni henne, ig awna gut: ―Uyá amnihun ikapun akak un. ");
INSERT INTO plu_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Egme kaytwa giwn: ―Mmah pis kinetihwa nukakhu? Pis judeyene. Hiyeg judeyenepwi gikakkis hiyeg samariyenepwi igkis ka pasamrakti pawtak. ");
INSERT INTO plu_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Igme kaytwa guwn: ―Waké pis hiyakbe ku pariye Uhokri ik adahan ikí pit, waké pis hiyakbe ku pariyene nah, nikwekam pis makahpawkam un nuthu. Nahme ikkam pit un ku pariye keh pis aymuhwa adahan apanenekwa. ");
INSERT INTO plu_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Egme no tino awna git: ―Kiyapwiye, pis yuma ariknawnama adahan pis kapukne piwnra. Inin unipna mihad. Nikwe kitak pis utí ini un ku pariye keh wis aymuhwa adahan apanenekwa? ");
INSERT INTO plu_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Mmah pis ik adahan ikí nuthu un ku pariye pi kabayte ariw wahawkriwiy amekene Jakó gidahan? Mmah pis pi kiyatte giw? Mmanawa igwa amekene Jakó iké wothu inin unipna. Igwa higap niwntak payak gikakkis gikamkayupwi madé akak gipigpu. ");
INSERT INTO plu_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Igme Kiyapwiye Jesus kaytwa guwn: ―Ku pahapwi higá inin un, kuwewanek ig arabyu un akiwnek. ");
INSERT INTO plu_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Henneme ku pahapwi higá un nuwntak, iggi ka arabyuti akiw. Ini un nuwntak humaw ke un ariwtyakbe kane makarati in padeknenekwa dehetniki adahan apanenekwa. ");
INSERT INTO plu_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Egme no tino kaytwa giwn: ―Kiyapwiye, uyá ik nuthu ariwntak piwnra adahan nah ka arabyu un akiw, adahan nah ka diyudyuka adahan nah kapuknano akiw. ");
INSERT INTO plu_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Igme awna gut: ―Su ta iwá pigihgi ayta. ");
INSERT INTO plu_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Egme kaytwa giwn: ―Nah yuma nugihgi. Igme Kiyapwiye Jesus awna: ―Piwnapriknawa ku samah pis awna. Pis yuma pigihgi. ");
INSERT INTO plu_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Mmanawa ayipa kuwis pis pohowku gikebyikis pigihgiwenepwi. Igme ner pahapwinene ku kakak pis ay kuri, ig ka pigihgima. Hennewa piwnapriknawa. ");
INSERT INTO plu_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Egme kaytwa giwn: ―Kiyapwiye, kuri nah hiyakpi ku pis Uhokri gawnepe. ");
INSERT INTO plu_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Uyá akki nuthu nikwe adahan ku kiney wixwiy kiyé Uhokri. Madikte amekenegben samariyenepwi igkis kiyé Uhokri ay apit inin waxri. Yisme yis hiyeg judeyenepwi yis awna ku amawka hiyeg kiyé Uhokri ayhté apit paytwempu Jerusalém. Mmani pit? Pariye Uhokri akki pit adahan ku kiney wixwiy kiyegi? ");
INSERT INTO plu_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Igme kaytwa guwn: ―Kiyapuno, ihanaba nuwnhu kuri nah awna pit. Aysawnemenek yis ka kiyé Wigwiy ay apit inin waxri, iné ayhté apit Jerusalém. ");
INSERT INTO plu_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Yis hiyeg samariyenepwi yis kiyé Uhokri kuri henneme yis ka hiyakri ku pariyene ig. Usuhme hiyeg judeyenepwi usuh hiyaknig ku pariyene ig. Mmanawa ner ku pariye ayta gamnihtenkis madikte hiyeg ig ayta gibetitakkis hiyeg judeyenepwi. ");
INSERT INTO plu_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Henneme kurinewa aysawnemenek madikte hiyeg ku pariye inyerwa kiyé Wigwiy, ignes kiyegi ay abet gihiyakemnikis. Ayge iwetrit adahan ku kiney wis inyerwa kiyene Wigwiy. Henne Wigwiy gimawkan adahan wis kiyegi. ");
INSERT INTO plu_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Mmanawa ig Uhokri yuma gipit kema hiyegma amadgaya inin adahan ig msakwa apit pahawo iwetrit. Ku pariye hiyeg kiyenenepwi Uhokri amawka ignes kiyegi ay abet gihiyakemnikis. Amawka igkis kiyegi inyerwa. ");
INSERT INTO plu_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Egme tino kaytwa giwn: ―Nah hiyakni ku Uhokri gikanyan adahan ukumaduketniwiy, ig Cristo, ig danuh atannek. Ayge nikwe ig akkamnih madikte wotwiy. ");
INSERT INTO plu_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Igme Kiyapwiye Jesus kaytwa guwn: ―Nahnewa ku pariye kinetihwene pikak nahnewa Cristo. Hennewatbaki ig Kiyapwiye Jesus awna gut. ");
INSERT INTO plu_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Udiyhemni nikwe, usuh gikannuhnipwi danuh atere. Usuh wakaymnibdi ku samah ig kinetihwa gukak pahapu tino ku pariye samariyano. Henneme usuh marenpi gibohri adahan usuh ayapri ku pariye gimawkan ta gut. Nikwe usuh ka ayapri ku samah ig kinetihwa gukak. ");
INSERT INTO plu_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ayteke eg tino ikise gunratiy ayge, eg sigise ta paytwempuit. Eg danuh atere, eg awna ta gitkis hiyeg aygnenepwi: ");
INSERT INTO plu_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Ba yi ayta iwasa pahapwi awayg ay. Ig akkamnih nuthu madikte ku pariye nukehnitnene. Mmah kawki nernema Uhokri gikanyan adahan ukumaduketniwiy? ");
INSERT INTO plu_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Igkis timapni henne, igkis pes paytwemputak. Igkis tipikwiyes ta gimkanit Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Apimwata ini usuh gikannuhnipwi awna ta git Kiyapwiye Jesus: ―Kiyapwiye, ahah pimana. Uyá ax. ");
INSERT INTO plu_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Igme awna wothu: ―Nah kamana ku pariye yis kane hiyak. ");
INSERT INTO plu_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Usuh timapni henne, usuhweke kinetihwa pawtak: ―Mmah nawenéwatma hiyeg kuwis ewk gimana git? ");
INSERT INTO plu_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Igme awna wothu: ―Nah kehne nawahkisten gibetki, ini ikí nawaygyi ke numanabe. Nah kehne gannipwi, ini kewa numanabe nuthu. ");
INSERT INTO plu_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ayteke ig awna akiw. Giwn: ―Ta yit muwaka paxnika kayg adahan tariswiki was. Henneme nuthu ka hennema. Araytak ayipa ahegbet kuwis. Sarayhnay yipegyi ta gimkatkis nerras samariyenepwi aytniyepwi. Igkis kuwis ahegbet adahan kamaxwepye ta nupitit. Nuthu igkis kewa pahak wasbe ku pariye ipatrik ahegbet adahan tariswiki. Kuwis Uhokri giwn ke wotbe in mutuhkabe ay gibetkis. Kuri muwaka hiyeg kene tarisnepwibe. Ku pahapwi ekkene gitkis hiyeg adahan ku samah igkis kamaxwa ta nupitit ig ke wotbe tarisnebe hiyeg ndahan. ");
INSERT INTO plu_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ku pahapwi hiyeg wagesne hiyeg henne ndahan, iggi katiwnihkanek. Hawwata nerras hiyeg ku pariye kamaxwa ta nupitit igkis aymuhwanek gimun Uhokri adahan apanenekwa. Ayge nikwe ig ner pahapwi bateke ginaktinnek payak gikakkis madikte nerras ku pariye kit kinetihwa numinhu ta gitkis. ");
INSERT INTO plu_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Hiyeg gibetkikis awna: “Mpuse wannipwiy. Pahapwime gannipwi adahan mutuhne was, pahapwime gannipwi adahan tarisne was.” Inakni yuwit hawwata kawih yidahan. ");
INSERT INTO plu_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nah kuwis awahkisyi adahan yis wagesne hiyeg ndahan. Henneme ka yisnema ku pariye ahegbete gihiyakemnikis adahan igkis kamaxwa nupitit. Inere nawenépwi hiyeg gannipwikis. In Uhokri gawnepepu pitatyepwi gannipwikis. Minikwak igkis kinetihwa gitkis hiyeg numinhu. Kuri yisme akki gitkis adahan ku samah igkis kamaxwa ta nupitit. Yisme ke pahapwibe ku pariye taris pahak was ku pariye nawenéwa hiyeg gamuthan. Hennewatbaki ig Kiyapwiye Jesus awna. ");
INSERT INTO plu_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ayipa kuwis kaayhsima nerras samariyenepwi paytwempuyenepwi igkis ihe ku ig Kiyapwiye Jesus iggi Uhokri gikanyan adahan ukumaduketniwiy. Mmanawa igkis ihe guwn no tino ku pariye awna gitkis: “Ig akkamnih nuthu madikte ku pariye nukehnitnene.” ");
INSERT INTO plu_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ayteke nikwe igkis danuh atere git Kiyapwiye Jesus, igkis awna git: ―Kiyapwiye, uyá msakwa ay umun adahan aynessa hawkri. Igme kaytwa giwnkis: ―Ihkata nikwe. Ig tipik gihaptikis, ig msekwe ayge gimunkis adahan pina hawkri. ");
INSERT INTO plu_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ayge nikwe kaayhsima hiyeg akiw kamaxwe ta gipitit Kiyapwiye Jesus awaku ku samah igkis timap giwn. ");
INSERT INTO plu_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Apim ini igkis awna ta gut no tino: ―Kuri usuh kamaxwa ta gipitit Kiyapwiye Jesus. Ka inenwatma awaku ku samah pis kinetihwa gimin, henneme awaku ku samah usuhwa timap giwn ku samah ig awna. Kuri usuh hiyakni ku ig igyerwa wamnihtenwiy, ig keh madikte hiyeg isamtawnek. ");
INSERT INTO plu_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ariwnteke ini pina hawkri ig Kiyapwiye Jesus pes ayteke. Ig tahhan apitit Galiléyamnaw. Henneme ig ka atak ta apitit giwaxriwa Nazaré. ");
INSERT INTO plu_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Mmanawa ig Kiyapwiye Jesus gibetki awna: ―Yuma pahapwinama Uhokri gawnepe kiyathaka gapitkis hiyegipiyene ku pariye apitya giwaxriwa. Hennewa in danuh ku samah inakni giwn. ");
INSERT INTO plu_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ig danuh atere apitit Galiléyamnaw, igkis galiléyenepwi ayge amapig kabayhtiwa. Igkis amapig awaku ku samah igkis hiyá madikte gannu ku pariye ig keh abet fet ayhté paytwempu Jerusalém. Mmanawa igkis hawwata igkis fetya ayge. ");
INSERT INTO plu_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ayteke ariwnteke ini ig diyuhe ta apitit paytwempu Kana ku kiney kuhwekwa ig wages un win. Kennesa arimkat Kana pahá paytwempu akiw kewye Kafarnawh. Ayge pahapwi awayg ku pariye kannipwiye gimun pahapwi hiyaptigi. Ig ner awayg gikamkayh kaayhsima ig kakahrip. ");
INSERT INTO plu_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ig awayg kinetni Kiyapwiye Jesus gak ku ig danuh aytontak Judeyamnawtak ta apitit Galiléyamnaw. Ig timapni henne, ig tipik atere gimkat Kiyapwiye Jesus. Ig danuh atere, ig awna ta git: ―Kiyapwiye, uyá amnihun. Uyá atak nuhapti ta nupinwat adahan pis piyih nukamkayh. Ig me miyapimet. ");
INSERT INTO plu_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Igme Kiyapwiye Jesus awna: ―Mmah apit yis hiyeg iha nuwnhu, mmah amawka nah kehnawa annut? ");
INSERT INTO plu_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Igme awayg kaytwa giwn: ―Kiyapwiye, uyá atak ta nupinwat marihwa nukamkayh ka miyá. ");
INSERT INTO plu_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Igme Kiyapwiye Jesus kaytwa giwn: ―Ka sam. Nah kuwis piyihpig. Ig pikamkayh makniw ig. Hiyawa pis diyuhe ta pipinwat. Ig awayg timapni henne, ig kamaxwa apitit inakni giwn. Ig diyuhe gipinwat. ");
INSERT INTO plu_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Hewke akiw ig kabá danuh gipinwat, ig patiptak gikakkis gihiyegapu. Igkisme awna git: ―Kiyapwiye, pikamkayh makniw kuwis. ");
INSERT INTO plu_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Igme awna gitkis: ―Kiney kamuw ig makniw? Igkisme kaytwa giwn: ―Amaka, daraka kamuw ig unirpu. ");
INSERT INTO plu_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ig awayg timapni henne, ig awna: ―Nukamkayh kannikaw pakeku akak ku samah Kiyapwiye Jesus awna nuthu: “Pikamkayh makniw ig.” Ig hiyapni henne, ig kamaxwe ta gipitit Kiyapwiye Jesus. Gimunyapu hawwata kamaxwe ta gipitit. ");
INSERT INTO plu_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ini apeyni annut Kiyapwiye Jesus keh ayhté apit Galiléyamnaw ku samah gidawnhan apititak Judeyamnaw. ");
INSERT INTO plu_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ariwnteke ini ig Kiyapwiye Jesus diyuhe ta apitit paytwempu Jerusalém ku kiney hiyeg judeyenepwi kehne fet adahan kiyene Uhokri. ");
INSERT INTO plu_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ayge Jerusalém pahá awkepket kennesa ahumwa pahatra ahin ku kiw igkis paraksa muttuh ta apitit paytwempu. Ini awkepket kewye Betesda giwnaprikkis judeyenepwi. Ayge pohowku akebyi xam aranwa ini awkepket. ");
INSERT INTO plu_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ayge agiku ini xam kaayhsima hiyeg kakahribdapye dikugibdihpi. Gaytakkis motapye. Gaytakkisme dathupye. Gaytakkisme miyapupye. ");
INSERT INTO plu_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Igkis ayge wahepnes un kasawkahwa. Inparinekwa pahapwi ahj dax un atere. Apim ini pahapwi ku pariye kit awke atere, ig makniw ariw madikte gikahri. ");
INSERT INTO plu_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ayge pahapwi awayg kakahriye. Ig kakahrip adahan kaayhsima kamukri, mpanabu madikwa akebyi akak ntewnehkerbu akak pahak arawna (38). ");
INSERT INTO plu_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ig Kiyapwiye Jesus danuh atere. Ig hiyá ner awayg dikugi ayge. Ig hiyakni ku ig ayge kaayhsima kamukri gaw. Ig hiyapni henne, ig ayapri: ―Ba pis makniwkere? ");
INSERT INTO plu_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Igme awayg kaytwa giwn: ―Ihi, Kiyapwiye, nah muwaka makniw. Henneme yuma hiyeg nayapetni adahan ig subkun ahakwat un ku aysaw un kasawkahwa. Apit nah danuh atere, ayipa nawené kit hiyeg danuh nuwhu. ");
INSERT INTO plu_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Igme Kiyapwiye Jesus hiyapni henne, ig awna git: ―Kannikaw kuri. Kidis pisipamna. Hiyawa pis wew. ");
INSERT INTO plu_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Aynewa ig awayg makniw. Ig kidis gisipamna. Ig wew. Ig keh ini abet samdi. ");
INSERT INTO plu_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Gaytakkis judeyenepwi giwewkistenkis igkis hiyapni henne, igkis awna git ner awayg: ―Pis ka hiyá pisma hiyuh pisipamna. Ku apim inin samdi. Amekene Moís gikumadukan ka isaksa adahan wixwiy keh ariknawnama annipwit abet samdi. ");
INSERT INTO plu_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Igme awayg kaytwa giwnkis: ―Ner ku pariye makniwepun, iggi awna nuthu adahan nah kidis nusipamna adahan nah wew. ");
INSERT INTO plu_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Igkisme ayapri: ―Pariye hiyeg awna pit inakni? ");
INSERT INTO plu_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Henneme ner awayg ka hiyakri ku pariye ig. Mmanawa kuwis ig Kiyapwiye Jesus parekwehe hiyeg ku pariye kabubuknene ayge. ");
INSERT INTO plu_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ariwnteke ini ig Kiyapwiye Jesus patiptak gikak ner awayg akiw ay agiku ini leglis kewye Uhokri Gipin. Ig awna git: ―Kuwis pis makniw. Ka ba taraksa akiw. Ku pis taraksa, nawenétke pis utí mbeyne pi mbayte ariw inere akiw. ");
INSERT INTO plu_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ig ner awayg hiyapni henne, ig tipik gitkis nerras judeyenepwi giwewkistenkis. Ig danuh atere, ig awna gitkis: ―Ner ku pariye makniwepun, giw Jesus. ");
INSERT INTO plu_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Igkis judeyenepwi giwewkistenkis timapni henne ku Kiyapwiye Jesus piyih hiyeg abet samdi, igkis awna: ―Aa, ig kannipwiye abet samdi. Ayteke nikwe igkis kapusa sigimwihpig awaku gitkis ig ka kiyatha samdi. ");
INSERT INTO plu_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Igme Kiyapwiye Jesus kaytwa giwnkis: ―Nighu kannipwiye apanenekwa. Ig ka mayakti ariw gikehni kabayka. Nah hawwata nah keh ke igbe. ");
INSERT INTO plu_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Nerras judeyenepwi giwewkistenkis hiyapni henne, igkis pi aharitte giwmasepten akiw. Igkis giwmasepten ka inenwatma awaku gitkis ig ka kiyatha samdi henneme hawwata awaku gitkis ig kinisekeputne. Mmanawa ig kighaw ta git Uhokri. Amun ini nikwe ig ekkewne ku igwata Uhokri. Gitkis ka hennema. ");
INSERT INTO plu_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Igme Kiyapwiye Jesus awna ta gitkis: ―Nah ka keh ariknawnama nuwnteknewatma. Nah keh inenewa ku pariye nah hiyá Nighu keh. Ku pariye Nighu keh, nah gikamkayh nah keh hawwata akiw. Ihanabay inakni nuwnhu. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Iggi Nighu bateke nukakhu nah gikamkayh. Ig akki nuthu madikte kabayka ku pariye ig keh adahan nahme keh hawwata akiw. Aysawnemenek ig keh nah keh annut pi datte akiw adahan yis wakaymni ndahan akiw. ");
INSERT INTO plu_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Nighu kadahan gidatni adahan ig kannikasene miyarapye adahan ig ikene dehetniki ta gipititkis. Nah gikamkayh, nah kadahanata ndatni adahan nah ikene dehetniki ta gipititkis nerras ku pariye numawkan. ");
INSERT INTO plu_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Nighu ka humaw adahan hiyeg gihiypetnikisma ba ignes kibeynewatma. Ig ikí ta nuwakuit nah gikamkayh adahan nahwa gihiypetnikis ba igkis kibeynewatma. ");
INSERT INTO plu_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ig keh henne marihwa madikte hiyeg kiyathan nah gikamkayh hawwata ku samah igkis kiyatha Nighu. Ku pahapwi ka kiyathan, amun ini nikwe iggi kawnata kiyatha Nighu ku pariye nawahkisten atan. ");
INSERT INTO plu_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ku pahapwi timap nuwnhu, ku ig iha giwn nawahkisten, ignewa kuwis kadeheten adahan apanenekwa. Ig ka ipukepkati hampa arimkanit biyukwiki. Kawa. Ig kuwis pes abetitak miyaka ta abetit dehetniki adahan ig aymuhwa gimun Uhokri adahan apanenekwa. Ihanabay inakni nuwnhu. Hennewatbaki ig. ");
INSERT INTO plu_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Kurinewa aysawnemenek hiyeg ku pariye yuma dehetniki ay gipitkis igkis timap nuwnhunek, nah Uhokri gikamkayh. Gaytakkis iha inakni nuwnhunek, igkis kadeheten nikwe. Hennewatbaki igkis kadehetennek. ");
INSERT INTO plu_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Nighu ignewa dehetniki akipara. Ig hawwata iké nuthu, nah gikamkayh adahan nah humaw dehetnikiwata akipara. ");
INSERT INTO plu_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ig hawwata ikí nuthu nukiythani adahan nah aysawnemenek nah gihiypetnikis hiyeg ba ignes kibeynepwiwatma. Ig ikí nuthu mmanawa nah hawwata hiyeg amadgayawata inin ke igkisbe. ");
INSERT INTO plu_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ka yi muwaka wakaymni amin inakni nuwnhu. Mmanawa aysawnemenek madikte apuheketyenepwi timá nuwnhunek. ");
INSERT INTO plu_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Apim ini igkis pes ayteke apuhekettak. Gaytakkis ku pariye kibeynepwi igkis kannikaw adahan igkis aymuhwa gimun Uhokri adahan apanenekwa. Gaytakkisme ku pariye kane kibeynepwima igkis kannikaw adahan igkis ipukepka hampa arimkanit biyukwiki. ");
INSERT INTO plu_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Apim ini nahnewa kaniy ku pariye hiyeg ipukepka hampa arimkanit biyukwiki. Nah ka keh henne nuwnteknewatma. Nah keh ku samah Nighu gakkan nuthu adahan nah keh. Ayge nah gihiypetnikisnek hiyeg ba ignes kibeynewatma apigkutaprik ku samah Nighu gibetki. Nah gihiypetnikis wadit nah ka taraksa. Mmanawa nah ka keh he nubetkinen. Nah kehnenekwa ku pariye nawahkisten gibetki. ");
INSERT INTO plu_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","―Waké nah pahapobe awna henne numinhu, nikwekam ik adahan yis ikiy he waditnepyenenkam. ");
INSERT INTO plu_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Henneme Nighu hawwata akkan ku pariyene nah. Nah hiyakni ku inakni giwn inyerwa ku pariye ig awna numinhu. ");
INSERT INTO plu_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Yisme he aharitnen hiyeg giwnkis amadgayapu inin. Inneki keh yis awahkis hiyeg gimin Kiyapwiye João Batista adahan timepne ginetni. Hawwata ig awna inyerwa yuwit numinhu. ");
INSERT INTO plu_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Henneme ka sam nuthu ku pariye yuwit hiyeg amadgayapu inin awna numinhu. Hiyeg amadgayapu inin giwnkis in ka ariknawnama nuthu. Inenewa Uhokri giwn kibeyne nuthu. Henneme nah kinetihwa gimin Kiyapwiye João Batista giwn awaku in kibeyne ta yit. Nawenétke yis timapni, yis kamaxwa nipitit, yis isamtaw nikwe ariw yitaraksan. ");
INSERT INTO plu_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ig kiyapwiye João Batista ig kewa pahá abukribe adahan uguhne yihiyakemni. Yis ayta ganwat ke yube ganwat pahá abukribe. Henneme yis ka iha giwn madiktema. ");
INSERT INTO plu_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ig kiyapwiye João Batista akkan huwewe ku pariyene nah. Henneme ay arikna ku pariye akkan pi huwewete ku pariyene nah. Ini nannuh ku pariye Nighu ikí nuthu, in nannuh arekhetni ku Nighu iggi nawahkisten. ");
INSERT INTO plu_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Hawwata akiw ig Nighu nawahkisten igwa akkan ku pariyene nah. Henneme awetupye yis iha giwn. Nah kahayaksa yit igyerwa Uhokri henneme yis mahikohpig. ");
INSERT INTO plu_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Waké ig Uhokri giwn kuwis aybe apit yiyakni, nikwekam yis ihakam nuwnhu mmanawa nahnewa gawahkisni. Henneme yis ka ihpa nuwnhu. ");
INSERT INTO plu_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ig Uhokri gannasan minikweknene hawwata akkan ku pariyene nah. Yis yibetki ipegboha inakni Uhokri gannasan mmanawa yipewkan ku yis ipegbohin kabayhtiwa, nikwe yis aymuhwanek gimun Uhokri adahan apanenekwa. Ka ba yis hiyá ku nahnewa ku pariye Uhokri gannasan kinetihwa numinhu? ");
INSERT INTO plu_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Yisme ka kamaxwekere nupitit kahadbe nah keh yis aymuhwa gimun Uhokri. ");
INSERT INTO plu_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Hiyawa hiyeg amadgayapu inin ka batek nukakhu henneme in ka sam nuthu. Numawkan ignewa Uhokri batek nukakhu. ");
INSERT INTO plu_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Henneme nah hiyak ku yis ka batek gikak Uhokri apititakma yiyakni. ");
INSERT INTO plu_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nah ayta yit giwntak Nighu. Hiyaksa yis ka amapan. Henneme waké pahapwi ay yibet amadgaya inin waké ig ayta yit giwnteknewatbe, nikwekam yis amapigkam kabayhtiwatkam. ");
INSERT INTO plu_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Yis timepkere hiyeg amadgayapu inin ignes kinetihwa yimin ku yis kibeynepwi hiyeg. Yis ka timepkere igwa Uhokri awna ku yis kibeynepwi hiyeg. Nikwe ka hiyá yisma kamaxwa ta nupitit. ");
INSERT INTO plu_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Mmah yipewkan nah kamiyepyi kuri ta git Uhokri? Kawa. Ka nawhma. Igwa amekene Moís kamiyepyinek, ig ner ku pariye yis kamaxwene ta apitit gikumadukan. ");
INSERT INTO plu_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Yis yipewkan yis ihpatrune amekene Moís gannasan bawa kawa. Waké yis ihpatrune giwnbe, yis hawwata ihpakam nuwnhu. Mmanawa ig kinetihwa numinhu. ");
INSERT INTO plu_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ku samah yis ka iha inakni giwn amekene Moís yis kawnata iha ndahan nuwnhu. ");
INSERT INTO plu_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ariwnteke ini ig Kiyapwiye Jesus tipik manuke mahakwa Galiléya. In hawwata kewye mahakwa Tiberíyadis. ");
INSERT INTO plu_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ig manuk mahakwa, pahabu hiyeg mpiye akigbimnewa mahakwa adahan igkis haraksepri. Igkis atekkere gihapti awaku igkis hiyá madikte gannu ku samah ig makniwe hiyeg. ");
INSERT INTO plu_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Igme ig kit danuh giwkis. Ig wagah apitit pahá waxri imuwadnene. Ayge ig batahkiswa. Usuhme gikannuhnipwi usuh batabdawak ayge gikak. ");
INSERT INTO plu_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Kabá danuh ahawkanaprik adahan hiyeg judeyenepwi gipetrakis adahan igkis axne muttuhyan arih. Igkis axni adahan kiyene ku samah minikwak Uhokri umahkis muttuhyan gidukwenaprikkis amekenegben adahan ig giwiwhkiswitnikis giwakutakkis hiyeg ejituyenepwi. ");
INSERT INTO plu_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ig Kiyapwiye Jesus betnene ayge, ig sarayh gipegyi ta warikwit. Ig hiyá nerras pahabunene hiyeg kuruw nemnik gimkat. Ig hiyapni henne, ig awna ta git kiyapwiye Filip: ―Kit wixwiy isim im adahan gaxnikis? ");
INSERT INTO plu_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ig awna inakni henne git adahan gihikekten. Ig kuwis hiyak ku pariye ig keh. ");
INSERT INTO plu_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Igme kiyapwiye Filip kaytwa giwn: ―Amawka wixwiy sarayh kaayhsima karukri mpiya mmukna sah (200) karukri. Metakwa nikwe igkis muwwapwite ax aritnahyumni ariwntak. ");
INSERT INTO plu_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Igme pahapwi waytakhu usuh gikannuhnipwi kewye André, ku pariye kiyapwiye Simawh Pedru gisamwi, ig timapni henne, ig awna git Kiyapwiye Jesus: ");
INSERT INTO plu_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Ay pahapwi bakimni ay in. Ig kadahan pohowku akebyi bugut kehka akak fahhin kewye “sevada”. Hawwata ig kadahan piyana akebyi im nopsanyopwi masaraku. Henneme in ka ariknawnama awaku ba gikebentenkis hiyeg. ");
INSERT INTO plu_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Igme Kiyapwiye Jesus awna gitkis: ―Wani nerras hiyeg batahkiswa. Ayge kaayhsima pamatka adahan igkis batene atere. Igkis hiyeg hiyapni henne, igkis batahkiswebdi atere. Igkis kaayhsima hiyeg. Awaykemninen pukuhka kabá danuh pohowku mil gikebyikis (5.000). ");
INSERT INTO plu_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ayteke nikwe ig Kiyapwiye Jesus iwé ig bakimni gibuguta. Ig kabayha Uhokri adahan ini bugut. Ayteke ig ibekhepni ta upuriw usuh gikannuhnipwi. Usuhme ibekhepni ta gipuriwkis nerras batebdebdihpiye. Hawwata ku samah ig keh akak bugut ig keh akakwata im. Ig ibakhasepni. Igkisme hiyeg kidis ku pariye gimawkankis niwntak. ");
INSERT INTO plu_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Igkis ax kabihribdape. Ka semeweknama gimanakis. Ig Kiyapwiye Jesus hiyapni henne, ig awna wothu: ―Ahiwnabay gimanakis asemne adahan yuma aynesnima biyukne. ");
INSERT INTO plu_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Usuhme ahiwapepni. Usuh kipunse kaayhsima panye, madikawku akebyi akak pisaya arawna (12) akak ini pohowkunene bugut asemne. ");
INSERT INTO plu_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Nerras hiyeg hiyapni henne ku Kiyapwiye Jesus keh ini annut giwtrikkis, igkis awna: ―Igyerwa Uhokri gawnepe ku kamin amekene Moís kinetihwa minikwak ku ig aytanek amadgat inin. ");
INSERT INTO plu_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Igkis gipewkankis igkis mpiksaptihpig adahan ig humaw gikiparakis. Igme Kiyapwiye Jesus hiyapni henne, ig tipik. Ig manuke ta apitit pahá waxri imuwadnene akiw, ig pahapo. ");
INSERT INTO plu_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Aygete kuwis, usuh gikannuhnipwi usuh muhuke ta akigbimnat mahakwa. ");
INSERT INTO plu_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Usuh awna: ―Kuwis aygete. Uyay diyuh ta pahambakat ta apitit paytwempu Kafarnawh. ―Uyay. Ayge usuh katapte amadgat wahmun. Msanpi wawhu, ig Kiyapwiye Jesus kote danuhte wothu. Usuh hiyapni henne, usuh tipik. ");
INSERT INTO plu_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Pahaye adahan mayg kamayghaw. In kannikase paraw. ");
INSERT INTO plu_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Usuh puwehnene atiput bobo piyawakad adahan pimaput sah (200) iwanti apiyukan. Pahaye adahan usuh hiyá Kiyapwiye Jesus waywe ahakwew un. Usuh ka hiyakri ku pariyene ig. Ig aytweni kennesa arimkat wahmun. Usuh hiyapni henne, usuh apisasew gibohri. ");
INSERT INTO plu_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Igme awna ta wothu: ―Nahnewa ay. Ka yi muwaka apis. ");
INSERT INTO plu_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Usuh timapni inakni giwn henne, usuh batek kaayhsima. Usuh amapig amadgat wahmun. Aynewa wahmun danuh atere ku kit umawkan. ");
INSERT INTO plu_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Hewke akiw kaayhsima hiyeg msekwepye ayhté pahambak. Igkis hiyakni ku amaka pahamkunano umuh ayge. Igkis hiyá usuh gikannuhnipwi tipikwiye gumadga no umuh, igme Kiyapwiye Jesus ka atak uhapti. Nikwe gipewkankiskam ku Kiyapwiye Jesus msekwe ayge gimunkis. Bawa kawa. Ig ay ukakhu. ");
INSERT INTO plu_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ayteke nawenépwi hiyeg danuh atere pahambakat amadga gihmunkis. Igkis ariwntak paytwempu Tiberíyades. Igkis danuh atere ku kiney amaka Kiyapwiye Jesus keh annut ig kabayha Uhokri adahan gimanakis, madikte hiyeg axnekwiye niwntak. ");
INSERT INTO plu_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Nerras hiyeg aygnenepwi hiyapni henne ku Kiyapwiye Jesus yuma ayge akiw, iné usuh gikannuhnipwi yumanawata ayge, igkis awna: ―Kibeyne. Ay nawenéwa umuh akiw. Uyay ipegpa Kiyapwiye Jesus ta pahambakat paytwempu Kafarnawh. ―Uyay. Igkis katapte amadgat gihmunkis nerras hiyeg danuhpenepwi. ");
INSERT INTO plu_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Igkis manuke mahakwa. Igkis danuh atere Kafarnawh. Ayge igkis uté Kiyapwiye Jesus. Igkis awna git: ―Kiyapwiye, aysaw pis danuh atan? Usuh pipegepten muwwapu. ");
INSERT INTO plu_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Igme awna gitkis: ―Yis ka ipegpan awakuma nannuh keh yis hiyak ku pariyene nah. Kawa. Yis ipegpan inenewa awaku ku samah yis axe yimana kabiha. Ini yis aharit akiw. ");
INSERT INTO plu_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ayteke ig awna gitkis akiw: ―Ka yi muwaka mpiksaw aharit yimana ku pariye kane dehwepyema yimun. Mpiksawnabay aharit ini yimana ku pariye dehwepye adahan apanenekwa, ku pariye keh yis aymuhwa adahan apanenekwa. Nah ku pariye wageswe awayg amadgaya inin nahnewa ikí yit akebyi ini yimana. Kuwis Wigwiy Uhokri ekke ku ig awahkisun adahanikwa ini. ");
INSERT INTO plu_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Igkis hiyeg timapni henne, igkis awna git: ―Mmahpa usuh keh nikwe adahan usuh kehne Uhokri gibetki? ");
INSERT INTO plu_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Igme Kiyapwiye Jesus kaytwa giwnkis: ―Nah akkite yit ku pariye Uhokri gibetki. Gibetki ini adahan yis kamaxwa ta nupitit nah gawahkisni. ");
INSERT INTO plu_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Igkisme awna git: ―Akkanaba pannu wothu akiw adahan arekhetni pidatni wothu adahan usuh kamaxwa ta pipitit. Ba pis ik adahan pis keh pahat annut ke amekene Moísbe? ");
INSERT INTO plu_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Minikwak amekenegben ax gimanakis kewyo “mana” ayhté amadga amatap. Uhokri gannasan minikweknene awna: “Ig ikí gitkis gimanakis ayta inutak.” Ba ik adahan pis hawwata ikí wothu umana ayta inutak? ");
INSERT INTO plu_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Igme Kiyapwiye Jesus kaytwa giwnkis: ―Ka ignema amekene Moís ikí ini gimanakis inutak. Ig Nighu ignewa ikepni gitkis. Kurime ig akaka yit yimana ku pariye inyerwa inugiktak. Hennewatbaki ig ikí. ");
INSERT INTO plu_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ini yimana giwntekne Uhokri in ayta inugiktak adahan hiyeg amedgenepwi inin aymuhwa adahan apanenekwa. ");
INSERT INTO plu_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Igkisme kaytwa giwn: ―Kiyapwiye, iknaba wothu akebyi ini umana takunipti. ");
INSERT INTO plu_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Igme Kiyapwiye Jesus kaytwa giwnkis: ―Nahnewa yimana ku pariye keh yis aymuhwa adahan apanenekwa. Ku pahapwi amapan, iggi bateknek ke pahapwibe ku pariye ax kabiha. Ig ka matipwati abet gihiyakemni akiw. Ku pahapwi kamaxwa ta nupitit, ig ka arabyuti abet gihiyakemni akiw. ");
INSERT INTO plu_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Hennewa in ku samah nah awna: “Yis kuwis hiyapun henneme yidukwenewa yis kote kamaxwate ta nupitit.” ");
INSERT INTO plu_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ignesme ku pariye Uhokri gikan nuthu igkis kamaxwa ta nupititnek. Igkis ku pariye kamaxwa nupitit nah ka tukuhgikis aynesnima. ");
INSERT INTO plu_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nah ayta atan inugiktak ka adahanma kehnema nubetki henneme adahan nah kehne nawahkisten gibetki. ");
INSERT INTO plu_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nah akkite yit ku pariye nawahkisten gibetki. Iní gibetki adahan nah ka biyuksa pahapwinama ku pariye gikan nuthu henneme adahan nah kannikaseprikis madikte amaksemni hawkri. ");
INSERT INTO plu_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Iní gibetki adahan ku pariye hiyeg ipeg numkat ignes kamaxwepye nupitit nah gikamkayh, igkis aymuhwa gimun Uhokri adahan apanenekwa. Iní gibetki adahan nah kannikaseprikis amaksemni hawkri. ");
INSERT INTO plu_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Igkis judeyenepwi giwewkistenkis timapni henne, igkis minimnihegbet pawtak gimin Kiyapwiye Jesus mmanawa ig ikewne ku ignewa umana inugiktekne. ");
INSERT INTO plu_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Igkis awna: ―Mmahki ig awna inakni yuwit henne? Ig ikawpari ku ig inugikyene. Ka ba pis hiyá ku ner he amekene Josénen gikamkayh? Usuh hiyak gig gukak ginag. Ig ka inugikyenema. ");
INSERT INTO plu_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ig Kiyapwiye Jesus hiyapni henne, ig awna gitkis: ―Ka ba yi minimni pawtak henne numinhu. ");
INSERT INTO plu_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ka ik adahan pahapwinama hiyeg kamaxwa nupitit ku ka ignema Nighu nawahkisten kinistig ndahan. Ku pahapwi timá giwn, ku ig kamaxwa ta nupitit, nikwe nah kannikasepri amaksemni hawkri. ");
INSERT INTO plu_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","In hawwata ku samah Uhokri gawnepepu pitatyepwi giwnkis. Igkis awna: “Igwa Uhokri humaw gikannuhtenkis madikte hiyeg.” Madikte hiyeg ku pariye timap Nighu giwn ku pariye iha inakni giwn, igkisnewa ku pariye kamaxwenepwi ta nupitit. ");
INSERT INTO plu_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Hiyeg amadgayapu inin ka hiyapti Nighu. Nahnewa gihiypetni mmanawa nah ayta giwntak. ");
INSERT INTO plu_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ku pahapwi kamaxwa nupitit, nikwe ig aymuhwa gimun Uhokri adahan apanenekwa. ");
INSERT INTO plu_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nahnewa yimana ku pariye inyerwa keh yis aymuhwa. Ihanabay inakni nuwnhu. Hennewatbaki nah. ");
INSERT INTO plu_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Minikwak yahawkripwi amekenegben ax no gimanakis kewyo “mana” ayhté amadga amatap. Henneme igkis ka aymuhwa adahan apanenekwatma. Aysawnemenek ariwnteke ini igkis miyarap. ");
INSERT INTO plu_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Nahme kinetihwa amin nawenéwa yimana ariw ignes gimanakis. Ini yimana inugiktekne. Ku pahapwi ax ariwntak ini gimana, ig ka miyá adahan apanenekwatma. ");
INSERT INTO plu_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nahnewa ini yimana inugiktekne ku pariye inyerwa keh hiyeg aymuhwa. Ku pahapwi ax nuwntak, ig aymuhwa gimun Uhokri adahan apanenekwa. Ini yimana ku pariye nah akki yit, innebaki nihhu ku pariye nah sigkebdihkis gidahankis madikte hiyeg amedgenepwi inin kahadbe ignes aymuhwa gimun Uhokri adahan apanenekwa. Hennewatbaki ig Kiyapwiye Jesus awna. ");
INSERT INTO plu_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Igkis judeyenepwi giwewkistenkis timapni henne, igkis piledukewnes pawtak akak gihawnakis. Igkis awna: ―Mmahki akaka wotwiy gih adahan wixwiy ax? ");
INSERT INTO plu_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ig Kiyapwiye Jesus hiyapni henne, ig awna gitkis: ―Ku yis ka ax nihhu, nah ku pariye wageswe awayg amadgaya inin, ku yis kawnata higap numighu, nikwe yis ka aymuhwa gimun Uhokri. Ihanabay inakni nuwnhu. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Henneme ku pahapwi ax nihhu, ku ig higap numighu, iggi aymuhwanek gimun Uhokri adahan apanenekwa. Nah kannikasepri amaksemni hawkri. ");
INSERT INTO plu_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Nihhu inyerwa keh hiyeg aymuhwa. Numighu hawwata akiw keh hiyeg aymuhwa akiw. ");
INSERT INTO plu_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ku pahapwi ax nihhu, ku ig higap numighu, amun ini nikwe iggi humaw pahapwiwa nukakhu. Ig ay nupithu. Nahme ay gipit. ");
INSERT INTO plu_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Nighu ku pariye nawahkisten ig dehetniki akipara adahan apanenekwa. Nah utí ndehetni giwntak. Hawwata ku pahapwi ax nuwntak, ig utí gidehetni nuwntak. ");
INSERT INTO plu_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nah igyerwa yimana inugiktekne. Nah ka kema nerras amekenegben gimanakis ku pariye igkis ax henneme igkis miyarap. Ku pahapwi ax nuwntak, ig aymuhwa adahan apanenekwa. ");
INSERT INTO plu_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Inakni yuwit ig Kiyapwiye Jesus awna agiku judeyenepwi gileglisakis ayge Kafarnawh. ");
INSERT INTO plu_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Kaayhsima gaytakkis nerras timepnepwi Kiyapwiye Jesus giwn igkis timapni inakni giwn henne, igkis awna: ―Inakni giwn mahiko. Mmahpaki wis pukuhpin? ");
INSERT INTO plu_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ig Kiyapwiye Jesus kateksan apit giyakni ku samah igkis minimnihegbet henne. Ig hiyapni henne, ig awna gitkis: ―Mmah inakni nuwnhu mmah mahiko yit? ");
INSERT INTO plu_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Henneme aysawnemenek in ka mahiko yit akiwnek. Ku aysaw yis hiyapun nah ku pariye wageswe awayg amadgaya inin nah diyuhe ta inugikut akiw, apim ini in ka mahiko yit. ");
INSERT INTO plu_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ku wis ax ihti, ka innema keh wis aymuhwa adahan apanenekwa. Ignewa Uhokri Gitip ay upit, ignewa ku pariye keh wis aymuhwa gimun Uhokri adahan apanenekwa. Kaksa nah awna yit patuwesbuhka yuwit giwntak Uhokri Gitip. Ku yis iha inakni nuwnhu, in keh yis aymuhwa adahan apanenekwa. ");
INSERT INTO plu_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Yaytakme ka iha nuwnhu. Ig Kiyapwiye Jesus ayipa ig hiyakni kuwis ku pariye hiyeg ka iha giwn. Ig hawwata hiyak ku pariye gikamaykiswitni ta gitkis gipetunyapu. ");
INSERT INTO plu_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Nikwe ig awna: ―Ignewa Uhokri Gitip ku pariye keh wis aymuhwa gimun Uhokri adahan apanenekwa. Inneki keh nah awna yit kaksa: “Ka ik adahan pahapwinama hiyeg kamaxwa nupitit ku ka ignema Nighu kinistig ndahan.” ");
INSERT INTO plu_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Apim ini kaayhsima gikannuhnipwi awna: ―Inakni giwn amin axne gih, inakni mahiko. Ayge nikwe igkis tipik giw. Igkis ka wew gikak akiw. ");
INSERT INTO plu_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ayteke ig Kiyapwiye Jesus hiyapni henne, ig awna ta wothu usuh gikannuhnipwi madikawkunene ukebyi akak piyana wawna (12). Giwn: ―Mmah yis hawwata tipikkere nuwhu? ");
INSERT INTO plu_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Igme kiyapwiye Simawh Pedru kaytwa giwn: ―Kiyapwiye, karimkanitpa usuh tipik? Pisnewa awna yuwit ku pariye akki wothu adahan ku samah usuh aymuhwa gimun Uhokri adahan apanenekwa. ");
INSERT INTO plu_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Usuh kamaxwa ta pipitit. Usuh hiyakni ku pis Uhokri giwatni barewpitye. ");
INSERT INTO plu_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Igme Kiyapwiye Jesus awna wothu: ―Nah kaniye yis madikawkunene yikebyi akak piyana yawna (12) adahan yis wewne nukakhu. Henneme ay pahapwi yaytak ig wapitye ay gipit. ");
INSERT INTO plu_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ig awna inakni gimin Judas Iskariyotismin, ku pariye amekene Simawh gikamkayh. Mmanawa ig Judas Iskariyotismin waytakhu usuh madikawkunene ukebyi akak piyananene wawna (12) henneme ig kamaykistinene Kiyapwiye Jesus ta gitkis gipetunyapu. ");
INSERT INTO plu_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ariwnteke ini ig Kiyapwiye Jesus muwwaptise Galiléyamnaw. Ig ka atekere apitit Judeyamnaw mmanawa nerras judeyenepwi giwewkistenkis ipegpenene adahan giwmasepten. Awaku ini ig msakwa ayge Galiléyamnaw. ");
INSERT INTO plu_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Kabá danuh ahawkanaprik adahan hiyeg judeyenepwi gipetrakis adahan pahadguhwene adahan msakwa agiku paytbet. ");
INSERT INTO plu_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ayge nikwe Kiyapwiye Jesus gisamwipwi awna git: ―Uyay atak tahhan apitit Judeyamnaw ku kiney hiyeg pahadgupu. Ayge kibeyne iwetrit adahan pis keh annut kahadbe ku pariye timepnepwi piwn, igkis hiyá pannu. ");
INSERT INTO plu_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ku pis muwaka madikte hiyeg hiyakpi, amawka pis akkaw gitkis. Amawka pis ka msakwa ayamawnama ay. Ku pis inyerwa keh annut akak Uhokri gidatni, amawka pis akkaw gitkis madikte hiyeg. ");
INSERT INTO plu_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Hennewatbaki igkis awna mmanawa igkispeke gisamwipwihwa ka iha giwn apim ini. ");
INSERT INTO plu_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Igme Kiyapwiye Jesus kaytwa giwnkis: ―Kote danuhte nuhawkanaprik adahan nah akkaw ta gitkis madikte hiyeg. Henneme ku aysaw yis atekkere, hiyawa yis atak. ");
INSERT INTO plu_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Hiyeg amedgenepwi inin ka amiyhay. Nahme ignes amiyihnan. Igkis amiyihnan awaku ku samah nah ekkene gitkis gikehnikis mbeyepye. ");
INSERT INTO plu_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Su yi atak fetya. Nahme kote atakte. Kote danuhte nuhawkanaprik adahan nah akkaw. ");
INSERT INTO plu_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ig Kiyapwiye Jesus awna inakni, gisamwipwi tipik fetya. Igme msekwe ayge Galiléyamnaw adahan aynessa hawkri akiw. ");
INSERT INTO plu_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ayteke ariwntak gisamwipwi gitepkemnikis ig hawwata ig tipik atere. Henneme ig ka tipik giwtrikkisma hiyeg. Ig tipik monye. ");
INSERT INTO plu_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Apimwata ini ayge abet fet nerras judeyenepwi giwewkistenkis ayá Kiyapwiye Jesus gak. Igkis awna: ―Kineykig? ");
INSERT INTO plu_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ayge kaayhsima hiyeg minimnihegbet pawtak gimin Kiyapwiye Jesus. Gaytakkis awna: ―Ig kibeyne awayg. Gaytakkisme awna: ―Kawa. Ig kinisne hiyeg. ");
INSERT INTO plu_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Henneme igkis minimni giharaprikkis nerras giwewkistenkis. Mmanawa igkis apis gibohrikis mmanawa ignes ka batek gikak Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Pabuskak fet ig Kiyapwiye Jesus danuh atere. Ig pareke ta agikut ini leglis kewye Uhokri Gipin. Ayge ig kannuhekne. ");
INSERT INTO plu_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Nerras judeyenepwi giwewkistenkis hiyapni henne, igkis wakaymnibdi adahan gikannuhakni. Igkis awna: ―Kitak ner kanuhwa? Ig ka lekkolya gimin Uhokri giwn kema wixwiyma. ");
INSERT INTO plu_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ig Kiyapwiye Jesus timapni henne, ig awna gitkis: ―Nukannuhwan kawki nuwnteknewatma. In giwntak nawahkisten. ");
INSERT INTO plu_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ku pahapwi inyerwa kehkere Uhokri gibetki, iggi hiyaknek ku kitak nah utí nukannuhwan. Ig hiyak ba nah awna nuwnteknewatma ba kawk ba nah awna giwntak Uhokrima. ");
INSERT INTO plu_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Pahapwi ku pariye awna he giwnteknewatnen, iggi aharitne hiyeg kiyathig. Nahme awna adahan hiyeg kiyatha nawahkisten. Nikwe nah awna yuwit ku pariye inyerwatnene, nah awna wadit. ");
INSERT INTO plu_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Amekene Moís ikí wotwiy Uhokri gikumadukan henneme yuma pahapwinama yaytak ihpene inakni gikumadukan. Yis aharit nuwmepten. Mmahki? ");
INSERT INTO plu_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Igkisme kaytwa giwn: ―Pis puwpup. Pariyekama piharit piwmepten? ");
INSERT INTO plu_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Igme kaytwa giwnkis: ―Yis madikte wakaymnibdi awaku nah makniwe pahapwi awayg abet samdi. Yit nah taraksepye awaku nah keh ini annut. Yit nah ka kiyatha samdi. ");
INSERT INTO plu_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Henneme yis hawwata, yis kannipwiye abet samdi. Amekene Moís ikí wotwiy gikumadukan ku pariye ikaka git gapitkis gihawkripwi. Ini gikumadukan awna adahan wixwiy hiwh bakimnay awayg gipitkis adahan arakak ku igkis Uhokri gihiyegapu. Nikwe adahan pahay paka akiw ariwntak giwaypukakis yis hiwh gipitkis. Ku pahapwi amadga wayk abet samdi yis hiwh gipit abet samdi aytwenempiye. ");
INSERT INTO plu_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Hiyawa samdi abet, henneme yisnewa hiwh gipit kahadbe yis ihpene giwn amekene Moís gikumadukan. Mmah nikwe yis dagawne nuthu apatra ku samah nah makniwe pahapwi awayg pahapwite abet samdi? ");
INSERT INTO plu_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mmahki yis ikanhu ku nah taraksepye? Ka yi muwaka ikiy pahapwi ku ig taraksepye kibentenwatma. Hiyapnigte ba ig wadityewatma. Hennewatbaki ig Kiyapwiye Jesus awna. ");
INSERT INTO plu_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Gaytakkis jerusalémyenepwi ayge igkis timapni henne, igkis kinetihwa pawtak. Igkis awna: ―Mmah ka ba nernema ku pariye uwewkistenwiy aharit giwmasepten? ");
INSERT INTO plu_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ipegnay ku samah ig wewpari ay ubetwiy. Igkisme ka aritnama giw adahan kamaxwig. Nawenétke igkis pukuhpaw. Nawenétke igkis ikiy ku igyerwa Cristo, ig Uhokri gikanyan adahan ukumaduketniwiy. ");
INSERT INTO plu_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Gaytakkisme kaytwa giwnkis: ―Kawa. Ka ignema. Mmanawa wixwiy hiyakri ku pariyene ig. Igme Cristo, yuma hiyeg gihiyekten ku pariyene ig. ");
INSERT INTO plu_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Igme Kiyapwiye Jesus kannuhekne ayge agiku leglis. Ig timapni inakni yuwit henne, ig awna gitkis hiyeg: ―Yis yipewkankam ku yis hiyakun ku pariyene nah. Yipewkankam yis hiyak ku kitekne nah. Henneme nah ka ayta nuwnteknewatma. Yis ka hiyak ku pariye igyerwa nawahkisten atan. ");
INSERT INTO plu_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nahme hiyaknig. Mmanawa nah ayta giwntak. Ignewa ku pariye nawahkisten atan. ");
INSERT INTO plu_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Igkis timapni henne, igkis atere gikamaxwitni. Henneme igkis ka hiyak ku samahpa gikamaxka gitkis mmanawa kote danuhte gihawkanaprik adahan ig kamaxka. ");
INSERT INTO plu_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Apim ini kaayhsima gaytakkis nerras hiyeg iha ku ig Kiyapwiye Jesus ignewa Uhokri gikanyan adahan ukumaduketniwiy. Igkis awna: ―Wixwiy hiyakni ku aysaw Uhokri gikanyan adahan ukumaduketniwiy danuh atan, ig keh kaayhsima annut. Hiyá kuri ig ner awayg kehne kaayhsima annut. Ka ik adahan pahapwinama hiyeg keh pi kabayte akiw. ");
INSERT INTO plu_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Nerras farisewkis timé gakkis ku igkis hiyeg kinetihwa henne gimin Kiyapwiye Jesus. Nikwe igkis gikakkis nerras muwpeg kiyatyepwi igkis awahkis gisandagmakis atere git adahan gikamaxwitni. ");
INSERT INTO plu_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Igkisme gisandagmakis tipik danuh atere git Kiyapwiye Jesus. Igkis timap ig kinetihwa gitkis hiyeg. Giwn: ―Nah ay yikak adahan aynessawa hawkri. Ayteke aysawnemenek nah diyuhe gimkat nawahkisten. ");
INSERT INTO plu_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Apim ini yis ipegpan henneme yis ka utipun. Ka ik adahan yis danuh atere ku kiney nah. ");
INSERT INTO plu_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Gaytakkis judeyenepwi giwewkistenkis ayge. Igkis timapni inakni giwn henne, igkis kinetihwa pawtak. Giwnkis: ―Kit ig atak adahan wixwiy ka utipri? Mmah ig atak ta gitkis nerras judeyenepwi ku pariye msakwa ayhté gibetkis grésiyenepwi adahan gikannuhtenkis atere? ");
INSERT INTO plu_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Mmahki ig awna inakni ku wixwiy ipegpig aysawnemenek henneme wixwiy ka utipri? Mmahki ig awna inakni ku ka ik adahan wixwiy danuh atere ku kiney ig? Henne igkis wakaymnibdi ayge. ");
INSERT INTO plu_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Amaksemni fet abet ini hawkri ku pariye apitmin madikte hawkri adahan gipetrakis, ig Kiyapwiye Jesus tabir ayge agiku leglis. Ig awna ta gitkis hiyeg akak madikte gawaygyi. Giwn: ―Aytninabay numkanit. Yis ku pariye giharitwiye Uhokri kiyesrad ke pahapwi hiyeg arabyupyebe unbe, aytninabay numkanit. Nah kewa un dehetniki ahawkribe yidahan. Higapnabay nuwntak takunipti. Kamaxwanabay nupitit takunipti. ");
INSERT INTO plu_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Yis ku pariye kamaxwenepwi nupitit, yis hawwata humawnek kewa un dehetniki ahawkribe gidahankis hiyeg. In ke wotbe kaayhsima un dehetniki pes yiwntaknek adahan ikene gidehetnikis kaayhsima hiyeg akiw. Hennewatbaki Uhokri gannasan minikweknene awna. ");
INSERT INTO plu_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ig Kiyapwiye Jesus awna inakni adahan arakak ku samah kamaxwenepwi gipitit ignes gitiphaw Uhokrinek. Henneme Gitip kote awahkiskahte mmanawa ig Kiyapwiye Jesus kote wagahte ku kiney gikiythani. ");
INSERT INTO plu_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Kaayhsima gaytakkis nerras fetyapu igkis timapni inakni yuwit henne, igkis awna: ―Ig Uhokri gawnepe. ");
INSERT INTO plu_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Gaytakkisme awna: ―Ignewa Cristo, ig Uhokri gikanyan adahan ukumaduketniwiy. Igkisme gaytakkis awna: ―Henneme ig galiléyene. Waké ig igyerwatbe Uhokri gikanyan adahan ukumaduketniwiy, nikwekam ig ka ariwntakma Galiléyamnawkam. ");
INSERT INTO plu_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Uhokri gannasan minikweknene awna ku Uhokri gikanyan adahan ukumaduketniwiy ig amadga wayknek ayhté paytwempu Belém ayhté Judeyamnaw ku kiney amekene Davi amadga wayk. ");
INSERT INTO plu_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Henne igkis hiyeg ka tuguhkis gihiyakemnikis hehpekwiyema gimin Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Gaytakkis nerras hiyeg aharitnes gikamaxwitni henneme yuma hiyeg gikamaxten. ");
INSERT INTO plu_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ayteke nikwe nerras muwpeg gisandagmakis diyuhe ta gitkis nerras muwpeg kiyatyepwi gikakkis farisewkis akiw. Igkis danuh atere, igkisme gikiparakis awna gitkis: ―Mmahki yis ka waxwa Jesus atan? ");
INSERT INTO plu_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Igkisme kaytwa giwnkis: ―Usuh ka timapti pahapwinama awayg awna ke inaknibe. ");
INSERT INTO plu_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Igkis farisewkis timapni henne, igkis awna gitkis: ―Mmah yispeke hawwata kinikiswe git? ");
INSERT INTO plu_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ka ba yis hiyá usuh ka iha giwn? Iné ukiparawiy kawnata iha giwn. ");
INSERT INTO plu_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Nerras hiyegempu ku pariye ihepye giwn igkis ka hiyak hawkri. Igkis ka hiyak ku pariye Uhokri gikumadukan awna. Igkis ikaksaka adahanikwa biyukwiki. ");
INSERT INTO plu_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Igme pahapwi awayg ayge ig timapni henne, ig kapusa awna gitkis. Giw kiyapwiye Nikodémus. Ig giyakikis farisewkis. Ig ner ku pariye kuhwekwa kinetihwa gikak Kiyapwiye Jesus. Giwn: ");
INSERT INTO plu_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Wixwiywa ka ihpenema Uhokri gikumadukan. Ig Uhokri gikumadukan ka isaksaw adahan wixwiy ikiy pahapwi ku ig taraksepye kibentenwa henne. Amawka ku wis timapanigte. Amawka ku wis hiyapnigte. Wixwiy kote kehte henne gikak Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Igkis timapni henne, igkis awna git: ―Mmahki pis awna inakni henne? Mmah pis galiléyene hawwata ke Jesusbe? Su atak ipegboha Uhokri gannasan minikweknene. In ka awna ku ig awahkis uminwiy pahapwinama gawnepe apititak Galiléyamnaw. ");
INSERT INTO plu_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Igkis awna inakni, igkis tipik diyuhe mpuse gipinwatkis. ");
INSERT INTO plu_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ig Kiyapwiye Jesus pisenwa gikannuhakni agikutak leglis, ig wagehe ta apitit ini waxri imuhgipitnene kewye Olipegpit. Ig danuh atere, ig msekwe ayge. ");
INSERT INTO plu_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Hewke hawkanawa ig diyuhe atere agikut leglis akiw. Ayge ig bat, ig kannuhne hiyeg. ");
INSERT INTO plu_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ayteke nerras kannuhekeputnepwi amin amekene Moís gikumadukan ignes danuh atere payak gikakkis nerras farisewkis. Igkis waxe git pahapu tino ku pariye powkemnihwe. Igkis tabirasig ta gipetunat Kiyapwiye Jesus ayge giwtrikneswa hiyeg. ");
INSERT INTO plu_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ayteke igkis awna git: ―Kiyapwiye, no tino kamaxwika nikwenéwa ku samah eg powkemnihwe gikak pahapwi. ");
INSERT INTO plu_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Amekene Moís gikumadukan awna adahan wixwiy padaktepru akak tip adahan guwmepten apatra ini gupowkemni. Pisme, mmah piwn adahan ku samah wixwiy keh gukak? ");
INSERT INTO plu_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Igkis awna inakni adahan gihikekten Kiyapwiye Jesus, marihwa igkis hiyá ba ig taraksa amekene Moís gikumadukan. Igkis muwaka utí gitaraksan adahan igkis gikamyehpitni. Igme Kiyapwiye Jesus timapni henne, ig mabukwe. Ig kapusa anniri waygbow akak giwak. ");
INSERT INTO plu_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Igkisme kapusa ayaptepri akiw. Ayge nikwe ig kannikase gitew, ig awna gitkis: ―Ku pariye yaytak yumanene gitaraksan, hiyawa ig kit padakru. ");
INSERT INTO plu_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ayteke ig mabukwa akiw, ig kapusa anniri waygbow akiw. ");
INSERT INTO plu_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Igkis timapni inakni giwn henne, igkis kayah gitaraksankis. Ayge nikwe igkis tipik pahapwimpi. Nerras ku pariye pi kiyaptenene igkis kit tipik. Ayteke nawenépwime tipik butte. Juktah igkis ikise Kiyapwiye Jesus ig pahapo gukak eggu tino ayge gikakkis nerras timepnepwi giwn. ");
INSERT INTO plu_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ayteke ig kannikase gitew, ig hiyá eggu tino gudukwenewa ayge gipetun. Ig awna gut: ―Kiyapuno, kineyki nerras pikamyehpitnipwi? Mmah yuma pahapwinama pipedketni? ");
INSERT INTO plu_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Egme kaytwa giwn: ―Yuma, Kiyapwiye. Igme awna gut: ―Nah hawwata, nah kawnata padakpita. Hiyawa pis tipik diyuhe pipinwat. Henneme ka ba taraksa akiw. ");
INSERT INTO plu_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ayteke ig awna ta gitkis nerras hiyeg akiw. Giwn: ―Nah kewa pahá abukribe gidahankis madikte hiyeg amadgayapu inin. Ku pahapwi wew nukakhu, nah uguh gihiyakemni kahadbe in ka msakwa ke wotbe abet amisnapyibe akiw. Ayge nikwe ik adahan ig hiyak ku pariye hiyakemniki inyerwatnene. Nikwe ig aymuhwa gimun Uhokri adahan apanenekwa. ");
INSERT INTO plu_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Igkis farisewkis timapni henne ku samah ig awna inakni, igkis awna git: ―Pisnewa ekkewne pimin. Nikwe piwn he waditnepyenen. ");
INSERT INTO plu_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Igme kaytwa giwnkis: ―Nuwnhu ka he waditnepyenenma. Hiyawa nah ekkewne numinhu henneme nuwnhu ka waditnepyenenma. Mmanawa nah hiyak ku pariyene nah. Nah hiyak ku kitwiye nah. ");
INSERT INTO plu_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Yis yipewkan nuhiypetni ba nah kibeynewatma, bawa yiswa yikehbetan akak yidahanwa yihiyakemni amadgaya inin. Nahme ku apim inin nah ka hiyá hiyeg ba ignes kibeynepwiwatma. ");
INSERT INTO plu_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Henneme waké nah gihiypetnikisbe adahan ba ignes kibeynepwiwatma, nah hiyaprikiskam wadit. Mmanawa nah ka ikebdihenigkis akakma nuhiyakemninenwatma henneme nah payak gikak Nighu nawahkisten usuh gihiypetnikis baki ignes kibeynepwiwatma. ");
INSERT INTO plu_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Minikwak amekene Moís tamak amadga gikumadukan adahan ku piyana utemwera ku giwnkis tuguh hehpekwiye, nikwe ik adahan wixwiy iha inakni giwnkis. ");
INSERT INTO plu_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ay piyana gikebyikis ntemwera adahan ekkene ku pariyene nah, nah gikak Nighu nawahkisten, usuhnewa ay. ");
INSERT INTO plu_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Igkisme ayapri: ―Kineypa pig? Igme Kiyapwiye Jesus kaytwa giwnkis: ―Yis ka hiyakun ku pariyene nah. Yis kawnata hiyakri ku pariyene Nighu. Waké yis hiyakbe ku pariyene nah, yis hiyaknikam ku pariyene Nighu. ");
INSERT INTO plu_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Inakni ig Kiyapwiye Jesus awna ayhté agiku karukri akekri ku aysaw ig kannuhekne agiku leglis. Henneme yumahte hiyeg gikamaxten mmanawa gihawkanaprik kote danuhte. ");
INSERT INTO plu_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ayteke ig Kiyapwiye Jesus awna gitkis akiw. Giwn: ―Kennesa ntepkemnimet. Apim ini yis ipegpan henneme waditnepyenen. Apit yis utepun, yis miyarapnek akak madikte yitaraksan. Ku kitwiye nah, yis ka hiyá yisma danuh aterenek. ");
INSERT INTO plu_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Igkis judeyenepwi giwewkistenkis timapni henne, igkis awna: ―Mmahki ig awna inakni? Ba ig me umehwepyemet? ");
INSERT INTO plu_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Igme awna gitkis: ―Yis amedgenene inin. Nahme inugiktekne. Yisme yihiyakemni amadgaya inin. Nahme nuhiyakemni ka hennema. ");
INSERT INTO plu_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Inneki keh nah awna ku yis miyarapnek akak madikte yitaraksan. Mmanawa ku yis ka kamaxwa ta nupitit, yis miyarapnek akak madikte yitaraksan. ");
INSERT INTO plu_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Igkisme awna git: ―Pariyenekap? Igme kaytwa giwnkis: ―Mmah ka ba yis hiyakni ku samah nah akkaw yit pitatye? ");
INSERT INTO plu_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Aysawnemenek nah akkamnihne yit yitaraksannek. Nah kadahan kaayhsima yuwit adahan nah ekkene yit yitaraksan. Kurime nah ka awna nuwnteknewatma. Ku samah nah ay amadga inin, nah awna inenewa yuwit ku pariye nawahkisten giwn nuthu. Ignewa awna yuwit ku pariye inyerwatnene yuwit. ");
INSERT INTO plu_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Igkisme ka pukuha ku ig awna inakni gimin gig Uhokri. ");
INSERT INTO plu_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ig Kiyapwiye Jesus hiyapni henne, ig awna gitkis: ―Ku aysaw yis ikepun ayhté inut aminat ah ayge nikwe yis hiyak ku pariyene nah ku pariye wageswe awayg amadgaya inin. Apim ini yis hiyak ku nah ka keh ariknawnama nuwnteknema henneme nah kinetihwa yit ku kamin Nighu kannuhun. ");
INSERT INTO plu_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ig nawahkisten ig ay nukakhu. Ig Nighu ka ikisun nah pahaponama mmanawa nah apanenekwa kehnenekwa gibetki. ");
INSERT INTO plu_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ig Kiyapwiye Jesus awna inakni henne, kaayhsima hiyeg ihe giwn. ");
INSERT INTO plu_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ayteke ig awna ta gitkis nerras ihpenepwi giwn: ―Ku yis ihpenene nuwnhu, nikwe yis inyerwa nuhiyegapu. ");
INSERT INTO plu_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ayge nikwe yis hiyaknek ku pariye hiyakemniki inyerwatnene. Amun ini yis isamtawnek. ");
INSERT INTO plu_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Igkisme kaytwa giwn: ―Mmahki pis awna inakni ku usuh isamtawnek? Usuh ka ibuktima. Usuh amekene Abrawh gihiwhipwi. ");
INSERT INTO plu_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Igme kaytwa giwnkis: ―Ku pahapwi taraksepye, nikwe ig kewa ibuktibe. Ku pariye hiyeg ibukti ka hiyá igma pes ariw gannipwi gidahan gikipara. Ku pariye hiyeg taraksepye kawnata hiyá igma miniw ariw gikehni mbayka. Ihanabay inakni nuwnhu. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ku pariye hiyeg ibukti, ig ka msakwa agiku gikipara gipin adahan apanenekwatma. Ku aysaw ig kiyapwip, ig ipukepka. Henneme ku pahapwi ikamkayhti, iggi ik adahan ig msakwa gipineku gig adahan apanenekwa. ");
INSERT INTO plu_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nah Uhokri gikamkayh. Ku aysaw nah keh yis isamtaw ariw ini bukitka, ayge nikwe hiyawa yis miniw ariw madikte yikehni mbayka. Apim ini yis inyerwa isamtaw. Nikwe yis ik adahan yis humaw Uhokri gikamkayupwi adahan yis aymuhwa gimun adahan apanenekwa. ");
INSERT INTO plu_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","―Yiwnapriknawa yis awna ku yis amekene Abrawh gihiwhipwi henneme gihiyakemni yuma ay yipit. Yis aharitnene nuwmepten mmanawa nuwnhu ka kawetri ay apit yiyakni. ");
INSERT INTO plu_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nah ekkene yit ku pariye nah kuwis hiyá ayhté gimun Nighu. Yisme nawenéwa yig giw ndahan. Yis ihpene giwn ner yig. ");
INSERT INTO plu_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Igkisme kaytwa giwn: ―Ignewa amekene Abrawh ku pariye wighu. Igme kaytwa giwnkis: ―Waké yis inyerwa giwntakbe amekene Abrawh, nikwekam yis giwetniwatkam. ");
INSERT INTO plu_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Henneme gihiyakemni yuma ay yipit. Nah ekkene yit inyerwatnene yuwit, yuwit ku pariye igwa Uhokri gakkan nuthu. Henneme yis aharitnene nuwmepten. Igme amekene Abrawh ig ka kehkam akebyi ini. ");
INSERT INTO plu_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Yis giwetniwa yig nawenéwa. Igkisme kaytwa giwn: ―Usuh yuma nawenéwatma wighu. Usuh ka battagma. Ignewa Uhokri igyerwa wighu. ");
INSERT INTO plu_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Igme awna gitkis: ―Kawa. Ig ka ignema yig. Waké yig Uhokribe, yis batekkam nukakhu. Mmanawa nah pes giwntak Uhokri, nah humaw giwntak Uhokri. Ka nuwnteknewatma nah ayta atan. Ignewa Uhokri awahkisun atan. ");
INSERT INTO plu_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Mmahki yis ka pukuha inakni nuwnhu? Nah akkite yit ku samah. Awaku yis ka amapin. ");
INSERT INTO plu_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mmanawa yig ig wapitye gikiparadkis. Yis yibetki keh ner yig gibetki. Ku samah akapuska hawkri ig umehekeputne, ig kapetunsa hiyakemniki ku pariye inyerwatnene. Mmanawa yuma aynesnima yuwit inyerwatnene ay abet gihiyakemni. Ig awna wasaymkanen mmanawa inenewa wasaymka ay abet gihiyakemni. Ig kinisekeputne. Ig wasaymka ahawkri. ");
INSERT INTO plu_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Inneki keh yis ka ihpa nuwnhu mmanawa nah awna yit yuwit ku pariye inyerwatnene. ");
INSERT INTO plu_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Yuma pahapwinama yaytak hiyapun nah taraksa. Apanenekwa nah awna yit yuwit ku pariye inyerwatnene. Mmahki nikwe yis ka iha nuwnhu? ");
INSERT INTO plu_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ku pariye Uhokriyan iggi timap Uhokri giwn. Yisme ka Uhokriyanpuma. Inneki keh yis ka timepkere giwn. ");
INSERT INTO plu_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Igkisme judeyenepwi giwewkistenkis awna git: ―Pis taraksepye ke nerras hiyeg samariyenepwibe. Pis wapitye ay pipit. Hennebakap. ");
INSERT INTO plu_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Igme kaytwa giwnkis: ―Yuma wapitye ay nupithu. Nah kiyatha Nighu. Yisme miyathan. ");
INSERT INTO plu_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nah ka ayta adahanma kiyathasewne gitkis hiyeg amedgenepwi inin. Henneme pahapwi ay ku pariye muwaka nah kakiythani. Ig gisayreptenkisnek nerras ku pariye kane kiyathan. ");
INSERT INTO plu_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ku pahapwi ihepye nuwnhu, iggi ka miyá. Ig aymuhwa gimun Uhokri adahan apanenekwa. Ihanabay inakni nuwnhu. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Igkis timapni henne, igkis awna git: ―Wownapriknewa. Kuri usuh hiyakni kabayhtiwa ku wapitye ay pipit. Ig amekene Abrawh miyap. Madikte Uhokri gawnepepu miyarap. Pisme awna: “Ku pahapwi ihepye nuwnhu, iggi ka miyá.” Mmahkap pis awna inakni henne? ");
INSERT INTO plu_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Mmah pis gapitmin wighu amekene Abrawh ku pariye ayipa miyá? Mmah pis gapitminkis Uhokri gawnepepu ku pariye miyarapye? Pariyenekap? ");
INSERT INTO plu_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Igme kaytwa giwnkis: ―Waké nahwa kiyathasawbe he nuwnteknenwatbe, nikwekam nuwnhu he waditnepyenenkam. Henneme ignewa Nighu kiyathasan, ig ner ku pariye yis kanum yiwohkiga. ");
INSERT INTO plu_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Henneme yis ka hiyakri. Nahme nah hiyakri. Waké nah awnabe: “Nah ka hiyakri”, nikwekam nah wasaymhewpikam ke yisbe. Henneme nah inyerwa hiyakri. Nah iha giwn. ");
INSERT INTO plu_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ig wahawkriwiy amekene Abrawh ig minikwak ig hiyakni ku nah danuhnek amadgat hawkri. Inneki keh ig bateke. Ig hiyakni, ig bateke gimin. ");
INSERT INTO plu_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Igkis timapni henne, igkis awna git: ―Pis kote kiyapwite. Pis ka hiyapti amekene Abrawh. Mmah ahiyaka pit inakni? ");
INSERT INTO plu_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Igme kaytwa giwnkis: ―Apit ig amekene Abrawh humaw, nah ayipa ay kuwis. Ihanabay inakni nuwnhu. Hennewatbaki nah ay. ");
INSERT INTO plu_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Igkis timá inakni henne, igkis awna: ―Ig Jesus makukse amekene Abrawh. Uyay katiwnise ini gitaraksan git. Uyay umehpig. Igkis kidise tip adahan gipedkepten. Igme miniwkeheprikis. Ig pese agikutak Uhokri Gipin. ");
INSERT INTO plu_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ayteke ariwnteke ini samdi abet, ig Kiyapwiye Jesus apigku ahin, ig hiyá pahapwi awayg bat ahinmu ig amnihswene ta gitkis hiyeg. Ig awayg motpiye ku samah ig amadgate wayk. ");
INSERT INTO plu_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Usuh gikannuhnipwi hiyapni henne, usuh ayá Kiyapwiye Jesus: ―Kiyapwiye, pariye kapatra ner awayg ig amadga wayk motpiye? Ba awakutke ginag gutaraksan? Ba awakutke gig gitaraksan? Batke awakutke gidahanwa gitaraksan? ");
INSERT INTO plu_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Igme kaytwa wown: ―Yuma arikna kapatrene. Iné ka ginagma gutaraksan, iné kawnata gigma gitaraksan, iné kawnata gitaraksanma. Ig amadga wayk henne kahadbe hiyeg hiyá Uhokri gannu ta gipitit. ");
INSERT INTO plu_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ku samah nah ekkene ig Uhokri gannu, amun ini nah kehne ini gannipwi ku kadahan ig awahkisun atan. Amawka ku wis keh gannipwi kurinewa akak inin mmanawa kuri wis kahawkan akiw. Aysawnemenek wis ka kahawkan akiw. ");
INSERT INTO plu_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nikwe ku samah nah aynete amadga inin nah kehne ini gannipwi. Nah humaw kewa pahá abukribe adahan uguhne madikte hiyeg gihiyakemnikis amadga inin. ");
INSERT INTO plu_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Pisenwa inakni gawnhan, ig tupes waygboit. Ig kehne ibug akak gaybi. Ayge ig manotig ner motpiye akak ini ibug. ");
INSERT INTO plu_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Pisenwa ig awna git: ―Su ta sukuh piwtyak agikut ini un atiy kewye Siloé. Inakni wownaprikwiy “Un Awahkiska” kahinahaki atiy. Ig awayg timapni henne, ig tipik. Ig danuh atere. Ig sukuhe giwtyak. Aynewa ig hiyap. Ayteke nikwe ig tipik. ");
INSERT INTO plu_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ig tipikwiye, ayge gihumwayepwi gikakkis nerras ku pariye gihiypetnipwi ku ig motpiye igkis hiyapri atere. Igkis awna: ―Ka ba nernema betnene ahinmu ba gibetki amnihswa ta gitkis hiyeg? ");
INSERT INTO plu_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Gaytakkis awna: ―Ignewa. Gaytakkisme awna: ―Ka ignema. Hennewatmeki gihipak. Igme ner makniwtinene ariw gimotpen ig awna gitkis: ―Nahnewa. ");
INSERT INTO plu_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Igkis timapni henne, igkis awna git: ―Pariye keh pis hiyap? ");
INSERT INTO plu_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Igme kaytwa giwnkis: ―Pahapwi awayg giw Kiyapwiye Jesus, ig kehe ibug ig manotan nikak. Ig awna nuthu: “Su ta sukuh piwtyak agikut ini un atiy kewye Siloé.” Nah tipik danuh atere, nah sukuhataw, nah hiyap. ");
INSERT INTO plu_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Igkis timapni henne, igkis awna git: ―Kineykig? Igme kaytwa giwnkis: ―Nah ka hiyak ku kiney ig. ");
INSERT INTO plu_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Igkis hiyeg timapni henne, igkis waxepri ta gitkis farisewkis. ");
INSERT INTO plu_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Mmanawa ig Kiyapwiye Jesus keh ibug, ig piyih giwtyak abet samdi. ");
INSERT INTO plu_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Igkis danuh atere, igkisme farisewkis hawwata ayapri: ―Pariye keh pis hiyap? Igme kaytwa giwnkis: ―Pahapwi awayg manotan akak ibug. Ayteke nah sukuhataw, nah hiyap. ");
INSERT INTO plu_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Gaytakkis igkis farisewkis igkis timapni henne, igkis kinetihwa pawtak. Giwnkis: ―Ner ku pariye gipiyhetni ig ka giwnteknewatma Uhokri mmanawa ig ka kiyatha samdi, ig piyihak samdi abet. Gaytakkisme awna: ―Ku ig taraksepye, kitak ig utí gannu adahan ig keh annut ke inibe? Ayge nikwe nerras farisewkis gihiyakemnikis ka patiptak. ");
INSERT INTO plu_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Igkis kapusa ayapte ner makniwtinene ariw gimotpen. Igkis ayapri: ―Ya pis? Mmahki pit ner awayg ku pariye pipiyhetni? Igme kaytwa giwnkis: ―Nuthu ig Uhokri gawnepe. ");
INSERT INTO plu_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ariwnteke ini igkis ka iha giwn ku ig minikwak ig motpiye henneme kuri ig hiyap. Ayteke nikwe igkis watiha gig gukak ginag. ");
INSERT INTO plu_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Egkisme danuh atere, igkisme ayaprukis: ―Mmah ig ner pikamkayh ku kamin yis awna ku ig motpiye ku samah ig amadga wayk? Mmah nikwe ig hiyap kuri? ");
INSERT INTO plu_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Egme ginag gikak gig egkis kaytwa giwnkis: ―Usuh hiyakni ku ignewa ukamkayh. Usuh hiyakni ku ig motpiye ku samah ig amadga wayk. ");
INSERT INTO plu_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Henneme usuh ka hiyak ku samah gipegpen kuri. Usuh ka hiyak ku pariye keh ig hiyap. Ig kuwis kiyapwip kuwis. Ayapnig. Igwa akki yit. ");
INSERT INTO plu_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Egkis awna inakni henne awaku egkis apis gibohrikis nerras judeyenepwi giwewkistenkis. Mmanawa igkis giwewkistenkis kuwis ahegbete ginetnikis adahan gipukeptenkis hiyeg agikutak gileglisakis. Giwnkis: “Ku pahapwi kanum Jesus ku ig Uhokri gikanyan adahan ukumaduketniwiy, iggi ipukepkanek.” ");
INSERT INTO plu_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Inneki keh egkis ayaptasig gukamkayhkis ta gitkis. ");
INSERT INTO plu_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Igkis farisewkis hiyapni henne, igkis watihpig akiw. Ig danuh atere, igkis awna git: ―Ka ba muwaka kabayha Jesus. Usuh hiyakni ku ig taraksepye. Kabayha Uhokrinen. ");
INSERT INTO plu_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Igme kaytwa giwnkis: ―Nah ka hiyak ba ig taraksepyema henneme nah akkite yit pahat arikna ku pariye nah hiyak kabayhtiwa. Kuhwekwa nah motpiye henneme kurime kuwis nah hiyap. ");
INSERT INTO plu_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Igkisme awna git akiw: ―Mmahpa ig keh pikak? Mmah apiyhepka piwtyak git? ");
INSERT INTO plu_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Igme kaytwa giwnkis: ―Ayipa nah kuwis akki yit henneme yis ka timepkere nuwnhu. Mmahki yis muwaka nah akki yit akiw? Mmah yis wageswekerepye gihiyegapu? ");
INSERT INTO plu_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Igkis timapni henne, igkis mahipwihpig. Igkis awna git: ―Pisnewa gihiyega. Usuhme amekene Moís gihiyegapu. ");
INSERT INTO plu_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Usuh hiyakni ku Uhokri kinetihwa gikak amekene Moís. Nerme usuh ka hiyak ku pariyene ner hiyeg. ");
INSERT INTO plu_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Igme ner makniwtinene ariw gimotpen ig kaytwa giwnkis: ―Mmah henne? Ini keh nah wakaymni kaayhsima. Ig keh nah hiyap henneme yis ka hiyak ku pariyenekig. ");
INSERT INTO plu_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Wis hiyakni ku Uhokri ka timap pahapwinama taraksepye gipigyepkawni. Ig timap gipigyepkawni ignenwa pahapwi ku pariye kiyathig ku pariye keh gibetki. ");
INSERT INTO plu_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ku samah akapuska hawkri yuma pahapwinama awayg hiyá gipiyhak pahapwi awayg ku pariye motpiye ku samah ig amadga wayk. ");
INSERT INTO plu_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Waké ner awayg ka giwntakma Uhokribe, nikwekam ig ka hiyá apiyhakkam nuwtyak adahan keh nah hiyap. ");
INSERT INTO plu_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Igkisme awna git: ―Pis taraksepye ku samah pis amadga wayk. Pariyenekap pis? Ka pisnema hiyá ukannuhka. Su tipik ayteke. Ka ba diyuh atan Uhokri gipineku akiw. Ayge nikwe igkis ipukwig. ");
INSERT INTO plu_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ariwnteke ini ig Kiyapwiye Jesus kinetni ner awayg gak ku samah igkis ipukepri. Ig timapni henne, ig tipik iwasapri. Ig danuh atere git, ig awna git: ―Ba pis kamaxwa ta gipitit ner ku pariye wageswe awayg amadgaya inin? ");
INSERT INTO plu_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Igme kaytwa giwn: ―Kiyapwiye, uyá akki nuthu ku pariye ig kahadbe nah kamaxwa gipitit. ");
INSERT INTO plu_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Igme Kiyapwiye Jesus awna git: ―Ku apim inin pis hiyapri. Nah ku pariye kinetihwene pikak nahnewa ku pariye wageswe awayg amadgaya inin. ");
INSERT INTO plu_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Igme kaytwa giwn: ―Kiyapwiye, nah kamaxwa pipitit. Ayge ig paberetusaw gitiput, ig kiyatig. ");
INSERT INTO plu_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ayteke ariwnteke ini ig Kiyapwiye Jesus awna ta gitkis hiyeg. Giwn: ―Nah ayta atan amadgat inin adahan hiyapkisne ku pariye hiyeg kibeynepwi, akak ku pariye hiyeg kane kibeynepwima. Hiyeg amadgayapu inin igkis ka hiyak ku samah Uhokri gihiyakemni. Nah ayta adahan nah kehne igkis hiyakni. In ke wotbe nah kehne motapye hiyap. Gaytakkisme hiyeg ikaw ke wotbe igkis kuwis hiyakbe ku samah Uhokri gihiyakemni. Nah ayta adahan nah hiyekeprikis ku igkis ka hiyaknima igkis ke motapyebe abet gihiyakemnikis. ");
INSERT INTO plu_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Gaytakkis farisewkis timapni henne, igkis awna git: ―Mmah pit usuh ke motapyebe abet uhiyakemni hawwata? Kawa. Usuh hiyak Uhokri gihiyakemni kabayhtiwa. ");
INSERT INTO plu_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ig timapni henne, ig awna gitkis: ―Waké yis ikaw ke motapyebe abet yihiyakemni, waké yis mpiksewne giharit Uhokri gihiyakemni, nikwekam yuma yitaraksankam. Henneme yis ikewne ke wotbe yis hiyepnepwi kuwisbe. Yis ka mpiksaw giharit Uhokri gihiyakemni akiw. Nikwe yis yidukwenewa akak madikte yitaraksan. ");
INSERT INTO plu_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ayteke ig Kiyapwiye Jesus awna ta gitkis hiyeg akiw. Giwn: ―Nah akkite yit abektey. Ay pahá apuriwket gidahankis nuhiyegapu kewa muttuhbe gapuriwkegkisbe. Pahatraw ahin adahan parekket atere. Ku pahapwi parak arimkat gapuriwkegkis muttuh henneme ku wis hiyá ig ka parak ku kiw parekket, ku ig parak ayamaw aharaptak yar, ayge nikwe wis hiyaknig ku ig amepye. Wis hiyakni ku ig ayta kidisne arikna ku pariye kane gidahanma. Hennewatbakig. ");
INSERT INTO plu_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pahapwime ku pariye parekwiye ku kiw parekket, iggi muttuh akipara. ");
INSERT INTO plu_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Apuriwkeputne ku pariye ayge agiku muttuh gapuriwkegkis, ig woka alappota gidahannenwa igyerwa muttuh akipara. Lappot woka, nerras muttuh ayge igkis timap gikupimna gikiparakis. Igme humak gipigpu. Ig kanum mpuse giwkis. Ig pekkiswigkis ta kabaywakat. ");
INSERT INTO plu_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Pisenwa gipesnikis ig wew pitati giwkis, igkisme makeke gihapu butte. Igkis kuruw gihapu mmanawa igkis kuwis hiyeke gikiparakis gikupimna. ");
INSERT INTO plu_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Gihapume nawenéwa hiyeg igkis ka wew mmanawa igkis ka hiyak gikupimna. Pase igkis timé ner gikupimna, igkis sigisbet giw. Hennewatbaki ig Kiyapwiye Jesus awna. ");
INSERT INTO plu_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ig kehe abektey henneme igkis timepnepwi ka pukuha inakni giwn. ");
INSERT INTO plu_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ig hiyapni henne, ig awna gitkis akiw. Giwn: ―Nah akkite yit huwewe. Nah ke inibe ahinbe gidahankis muttuh. Hennewatbaki nah. Nahnewa parekket agikutpiye nuhiyegapu gapuriwkegkis. Nahwata pesket arimketwiye kabayka. ");
INSERT INTO plu_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Kaayhsima kinisekeputnepwi kuwis danuh napitkiya. Igkis ikawnamahkis ke wotbe igkis ekkenes Uhokri giwn. Bawa kawa. Nuthu igkis kewa amepwapyebe ku pariye aharitne giweptenkis nupigpu. Henneme ku samah nerras muttuh ka iha nawenéwa hiyeg giwn, igkis nuhiyegapu kawnata iha giwnkis nerras kinisekeputnepwi. ");
INSERT INTO plu_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nahnewa parekket agikutwiye nuhiyegapu gapuriwkegkis. Ku samah muttuh pareke ku kiw parekket adahan ayemwepye ariw mbayka, hawwata nerras ku pariye kamaxwenepwi nupitit ignes isamtaw ariw mbayka. Hawwata akiw, ku samah muttuh pes ku kiw parekket adahan ipegpene gimanakis, hawwata nerras ku pariye kamaxwenepwi nupitit igkis utí madikte ku pariye gimawkanitnenes. ");
INSERT INTO plu_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Amepwapye ayta giweptenkis muttuh, giwmeptenkis pisenwepye gihawkankis. Nahme nah ayta adahan nuhiyegapu kadeheten adahan igkis igisapye akak kabayka. ");
INSERT INTO plu_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","―Nah apuriw nuhiyegapu kabayhtiwa kewa pahapwi muttuh akiparabe kibeynebe. Ig muttuh akipara ku pariye kibeyne ig ahegbet adahan umahkiswa adahan gamnihtenkis gipigpu. ");
INSERT INTO plu_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","―Gaytakkis hiyeg apuriw muttuh henneme igkis ka gikiparakisma. Nerras muttuh ka gidahankisma, igkis he gikapriwtenkisnen adahan katiwnihka. Ayge nikwe ku pahapwi axtigi danuh atere, ig muttuh gikapriwtenkis hiyapni henne, ig diyuhe giwkis muttuh, ig sigise giwkis. Ayge nikwe ig axtigi kamaxe muttuh. Igkis madikte peke. ");
INSERT INTO plu_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Igme muttuh gikapriwtenkis ig sigis giwkis mmanawa ig ka adahanma batekyema gikakkis. Ig gikapuriwtenkis he adahannen ig dax gikakura. ");
INSERT INTO plu_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","―Nahme nah kewa muttuh akiparabe kibeynebe. Nah hiyakape madikte nupigpuh kabayhtiwa. Igkisme hiyekepun hawwata. ");
INSERT INTO plu_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Usuh hiyakak pawtak kabayhtiwa hawwata ku samah nah hiyakak gikak Nighu. Nah umahkiswenek adahan gamnihpitnikis. ");
INSERT INTO plu_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Gaytakkis nupigpuh yumahte agiku gapuriwkegkis. Amawka nah iwapapeprikis atere. Igkis timap nukupimnanek. Igkis kamaxwa nupititnek. Ayge nikwe igkis humaw pahayruknene gikakkis nupigpuh ay. Igkis madikte pahapwiwa gikiparakis. ");
INSERT INTO plu_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Nah umahkiswenek nuwnteknewa adahan nah kannikaw akiwnek. Inneki keh Nighu batek nukakhu. ");
INSERT INTO plu_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Waké nah ka umahkiswa nuwnteknewatma, yumakam hiyeg hiyá nuwmak. Henneme nahwa umahkiswa. Nah kadahan nannuh adahan nah umahkiswa. Nah kadahanwata nannuh adahan nah kannikaw akiw. Hennewatbaki Nighu awna nuthu. ");
INSERT INTO plu_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Nerras judeyenepwi giwewkistenkis timapni henne, gihiyakemnikis ibekhewbet akiw. ");
INSERT INTO plu_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Gaytakkis awna: ―Wapitye ay gipit. Ig puwpup. Mmeneki yis timá giwn? ");
INSERT INTO plu_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Gaytakkisme kaytwa giwnkis: ―Ig yuma wapitye ay gipit. Wapitye ka awna ke inaknibe. Ig kawnata hiyá apiyhak hiyeg motpiye. ");
INSERT INTO plu_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ariwnteke ini, hawkri danuh adahan judeyenepwi fetya ayge Jerusalém adahan kiyene ku samah amekenegben barewha ini leglis kewye Uhokri Gipin ariw nipathawni. ");
INSERT INTO plu_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Kuwis ahawkanaprik muwokweki. Ayge Uhokri Gipin ig Kiyapwiye Jesus wewpari ayaranwew payt amun ini iwetrit kewye amekene Salomawh giwetri. ");
INSERT INTO plu_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Nerras judeyenepwi giwewkistenkis danuh atere git Kiyapwiye Jesus. Igkis pahadguhwa ganwa. Igkis awna git: ―Ka muwaka ayamwa wowhu takuniptima akiw. Asá akkaw wothu kurinewa baki pis igyerwatma Cristo, Uhokri gikanyan adahan ukumaduketni. ");
INSERT INTO plu_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Igme kaytwa giwnkis: ―Kuwis nah akkaw yit henneme yis ka timepkere nuwnhu. Ini annut ku pariye nah keh giwntak Nighu ini akkan huwewe ku pariyene nah. ");
INSERT INTO plu_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Yisme ka iha nuwnhu mmanawa yis ka gaytakkisma nupigpuh ku kamin nah kinetihwa amakohnokwa. ");
INSERT INTO plu_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ku pariye hiyeg igyerwa ndahan ignes hiyak nukupimna. Nahme hiyakapeprikis. Igkisme batek wew nukakhu. ");
INSERT INTO plu_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nah keh igkis aymuhwa gimun Uhokri adahan apanenekwa. Igkis ka biyukti giw Uhokri. Yuma pahapwinama hiyeg hiyá giwiwhkakis ayteke nuwakutak. ");
INSERT INTO plu_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Nighu ku pariye gikeptenkis nuthu ig pi datte ariw madikte. Yuma pahapwinama hiyeg hiyá awiwhka ariknawnama giwakutak Nighu. ");
INSERT INTO plu_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nah gikak Nighu usuh pahapwiwa pawtak. ");
INSERT INTO plu_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Pase nerras judeyenepwi giwewkistenkis timé inakni yuwit igkis kidis tip akiw adahan gipedkepten. ");
INSERT INTO plu_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ig Kiyapwiye Jesus hiyapni henne, ig awna gitkis: ―Kuwis nah keh kaayhsima annut, kibeyne annut giwntak Nighu. Pariyepa annut kapatra yis nupedkepten? ");
INSERT INTO plu_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Igkisme kaytwa giwn: ―Usuh ka padakpi apatrama kibeyne annut. Usuh padakpi apatra ku samah pis makuksebdih Uhokri. Pis he awaygnen amadgaya inin henneme pis ikawpari ke wotbe pis Uhokribe. ");
INSERT INTO plu_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Igme awna gitkis: ―Yidahanwa yikumadukan awna: “Uhokri awna ku yis Uhokriyanpu.” ");
INSERT INTO plu_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ini Uhokri gannasan minikweknene in apanenekwa awna wadit. Amadgatak inakni gannasan ig awna ku nerras ku pariye gikanyanpu adahan ignes ekkenes giwn ig awna ku igkisnewa Uhokriyanpu. ");
INSERT INTO plu_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Nah kaniyka nah awahkiska atan gapit Nighu adahan nah yamnihten. Mmah nikwe yis ikiy ku nah makuksene Uhokri awaku ku samah nah awna ku nah Uhokri gikamkayh? ");
INSERT INTO plu_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ku yis ka hiyá nah keh annut giwntak Nighu, nikwe yis ka muwaka iha inakni nuwnhu. ");
INSERT INTO plu_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Henneme ku yis hiyá nah inyerwa keh annut giwntak Nighu, ihpanabay ku nah igyerwa gikamkayh. Hiyawa yis ka iha inakni nuwnhu ku nah gikamkayh henneme nannuh akkin yit huwewe. Ayge nikwe yis hiyakun ku nah gikak Nighu usuh pahapwiwa pawtak. ");
INSERT INTO plu_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Igkis timapni henne, pahaynewat akiw igkis gipewkankis gikamaxwitni henneme ig pese giwkis akiw. ");
INSERT INTO plu_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ariwnteke ini ig Kiyapwiye Jesus tipik manuke eggu warik Jordawh akiw. Ig danuh atere ku kiney amekene João Batista pitatye kaywene hiyeg. Ayge ig msekwe. ");
INSERT INTO plu_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Kaayhsima hiyeg atere git. Igkis awna: ―Amekenemni João Batistamni ka keh annut, henneme ig awna inyerwa inetit gimin ner awayg. ");
INSERT INTO plu_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ayge kaayhsima hiyeg ihepye giwn. ");
INSERT INTO plu_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ayhté paytwempu Betâniya ayge pahapwi awayg kakahriye. Giw Lázaru. Ig msakwa ayge gukakkis gisamrupwi kiyapuno Mahi gukak kiyapuno Marta. ");
INSERT INTO plu_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Eggu kiyapuno Mahi ku pariye imihatinano Kiyapwiye Jesus akak imihgi eg manpusa gikugku akak gusemnu. Ignewa gegni kiyapwiye Lázaru ku pariye kakahrip. ");
INSERT INTO plu_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Egkis gisamrupwi hiyapni henne, egkis wasapanaw gimin Kiyapwiye Jesus. Egkis awna: ―Kiyapwiye, ner pikagmada kakahrip. ");
INSERT INTO plu_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ig Kiyapwiye Jesus timapni henne, ig awna: ―Kawki ininema karayt gisayreptenmanek. In adahan arekhetni Uhokri gikiythani. In adahan arekhetni nukiythani nah Uhokri gikamkayh. ");
INSERT INTO plu_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ig Kiyapwiye Jesus kaayhsima batek gukakkis kiyapuno Marta gukak kiyapuno Mahi gikak kiyapwiye Lázaru. ");
INSERT INTO plu_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Henneme ig ka atak gutkis nikwenéwatma. Ig timá kiyapwiye Lázaru gak ku ig kakahrip, ig msakwa gidukwenewa ayge adahan pina hawkri akiw. ");
INSERT INTO plu_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ayteke ig awna ta wothu usuh gikannuhnipwi: ―Uyay atak ta gipinwat Lázaru ayhtéhan Judeyamnaw. ");
INSERT INTO plu_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Usuhme awna git: ―Kiyapwiye, mmahki pis atere akiw? Nerras uwewkistenwiy ayge kuhwekwa igkis aharit pipedkepten. ");
INSERT INTO plu_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Igme kaytwa wownhu: ―Ka sam. Igkis ka hiyá nusamanak. Kote danuhte ahawkanaprik adahan nah pisenwa nukehni Uhokri gannipwi. Nighu ikí nuthu hawkri adahan nah keh gibetki amadga inin hawwata ku samah ig ikí hawkri arit kamuw adahan igme uguhne hawkri mataytak adahan madikawku ler akak pina arawna (12). Ku aysaw ig pisenwa gannipwi metakwa ig pituk. Hawwata akiw ku samah ig kamuw uguh wahina hawwata Uhokri uguh nuhiyakemni adahan nah ka taraksa. Ku pariye hiyeg wew puwipwak, ig ka tuguh mmanawa kamuw abutni uguh gahina. ");
INSERT INTO plu_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Henneme ku pariye hiyeg wew tiyegim, ig tuguhe mmanawa yuma kabutniki adahan uguhne gahina. Nahme uguhka nuhiyakemni adahan nah kehnenekwa gibetki. ");
INSERT INTO plu_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Pisenwa inakni giwn ig awna wothu: ―Ukagmadawiy Lázaru kuwis himeke. Henneme nah atere iwasapri adahan nah giwadsetni. ");
INSERT INTO plu_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Usuh timapni henne, usuh awna git: ―Kiyapwiye, mmahki pis ta giwadsepten? Kabay ig himak adahan ig makniw. ");
INSERT INTO plu_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Henneme ig Kiyapwiye Jesus awna gimin kiyapwiye Lázaru gimiremni. Usuhme upewkan ig awna amin ku ig mayekne. ");
INSERT INTO plu_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ig hiyapni henne, ig awna wothu huwewe. Giwn: ―Lázarumni miyapi. ");
INSERT INTO plu_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Kibeynekata nah ka aygenama ku samah ig kakahrip. Aysawnemenek yis pi kamaxwate nupitit akiw awaku ini. Henneme uyay atere git kuri. ");
INSERT INTO plu_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Kiyapwiye Tomé timapni henne, ig awna ta wothu usuh giyakipwi Kiyapwiye Jesus gikannuhnipwi, ig ku pariye usuh kanumri Abes. Ig awna: ―Uyay atak gihapti adahan wixwiy umahkiswe peyeke gikak. ―Uyay. Usuh tipik atere. ");
INSERT INTO plu_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ig Kiyapwiye Jesus danuh atere ewka giwen kiyapwiye Lázaru. Ig ayipa apuhpika paxnika hawkri gaw. ");
INSERT INTO plu_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ini paytwempu Betâniya in kennesa arimkat Jerusalém. Mpana kilomet ta arimkanit. ");
INSERT INTO plu_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Inneki keh kaayhsima judeyenepwi giwewkistenkis jerusalémyenepwi atere gutkis kiyapuno Marta gukak kiyapuno Mahi. Igkis atere adahan gaydhetnikis adahan egkis ka kadni giharit gegnikis mpiynepepyema. ");
INSERT INTO plu_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Eg kiyapuno Marta kinetni Kiyapwiye Jesus gak ku ig nemnik. Eg timapni henne, eg pes gitiput eg patiptakig atere apigku ahin. Egme kiyapuno Mahi msekwe paytrik. ");
INSERT INTO plu_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Eg kiyapuno Marta patiptaka Kiyapwiye Jesus atere, eg awna git: ―Kiyapwiye, waké pis aybe amakohnokwabe, negni ka miyakam. ");
INSERT INTO plu_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Henneme nah ndukwenewa kamaxwa pipitit. Nah hiyakni ku Uhokri ikí pit madikte ku pariye payapni git. ");
INSERT INTO plu_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Igme awna gut: ―Pegni kannikaw akiwnek. ");
INSERT INTO plu_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Egme kaytwa giwn: ―Nah hiyak ku ig kannikaw akiwnek amaksemni hawkri ku aysaw madikte miyarapyenpu kannikaw. ");
INSERT INTO plu_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Igme awna gut: ―Nahnewa kannikasene hiyeg. Nahnewa keh igkis aymuhwa. Ku pahapwi kamaxwepye nupitit, hiyawa ig miyá henneme ig aymuhwanek gimun Uhokri adahan apanenekwa. ");
INSERT INTO plu_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ku pahapwi kadeheten, ku ig kamaxwepye nupitit, iggi ka miyati. Ba pis iha inakni nuwnhu? ");
INSERT INTO plu_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Egme kiyapuno Marta kaytwa giwn: ―Ihi, Kiyapwiye. Nah iha ku pis Cristo, pis Uhokri gikanyan adahan ukumaduketni. Pis Uhokri gikamkayh ku pariye danuhne atan amadgat inin. ");
INSERT INTO plu_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Pisenwa inakni gunetnikis eg kiyapuno Marta tipik diyuhe ta gut gusamru kiyapuno Mahi. Eg danuh atere, eg humakru monye. Eg awna gut: ―Mim. Ukannuhten kuwis danuh. Ig muwaka pis atak git. ");
INSERT INTO plu_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Eg kiyapuno Mahi timapni henne, eg kannikew kibentenwa. Eg tipikwiyo ta gimkat Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Igme Kiyapwiye Jesus kote apitma paytwempu. Ig gidukwenewa ku kiney kiyapuno Marta patiptakig. ");
INSERT INTO plu_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Nerras judeyenepwi giwewkistenkis ku pariye ayge paytrik adahan gaydhetnikis igkis hiyapni henne ku kiyapuno Mahi kannikaw kibentenwa eg tipik, igkis makeke guhapu butte. Gitkis eg ta arit kiyapwiye Lázaru gimew adahan eg tihano giharit. ");
INSERT INTO plu_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Egme kiyapuno Mahi danuh atere git Kiyapwiye Jesus. Eg hiyapri, eg paberetusaw gikimpuit. Eg awna git: ―Kiyapwiye, waké pis aybe amakonohkwabe, negni ka miyakam. ");
INSERT INTO plu_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Eg tihano. Nerras guhaptiyepwi judeyenepwi giwewkistenkis igkis hawwata tihenes. Ig Kiyapwiye Jesus hiyapni henne, ig katiw apit giyakni. Ig kahhekanaw. ");
INSERT INTO plu_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ig awna: ―Kineypa yis sarayhpig? Igkisme kaytwa giwn: ―Kiyapwiye, ba ayta iwasapri. Ayhté ig. ");
INSERT INTO plu_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ig Kiyapwiye Jesus hiyapni henne, ig suke gikantak. ");
INSERT INTO plu_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Nerras judeyenepwi giwewkistenkis hiyapni henne, igkis awna: ―Ipegnamwi ku samah ig batek gikak. ");
INSERT INTO plu_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Igkisme gaytakkis awna: ―Ignewa ku pariye keh pahapwi motpiye hiyap. Mmah nikwe ig ka mpitha amekenemni Lázarumni ariw miyaka? ");
INSERT INTO plu_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ayteke nikwe igkis danuh atere arit kiyapwiye Lázaru gimew. Ayge ig Kiyapwiye Jesus kahhekanaw akiw. Ig kiyapwiye Lázaru gimew agiku tip amiyokni. Asabwatip egwata tip. ");
INSERT INTO plu_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ayteke nikwe ig Kiyapwiye Jesus hiyapni henne, ig awna ta gitkis hiyeg: ―Wokanabay asabwat. Eg kiyapuno Marta ner miyapye gisamru eg timapni henne, eg awna git: ―Kiyapwiye, ka ba wokisni. Ig negni gipit kuwis busip. Mmanawa paxnika hawkri gaw kuwis ig ayge agiku gimew. ");
INSERT INTO plu_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Igme awna gut: ―Ka ba pis timá ku samah nah kuwis awna pit: “Ku pis kamaxwa nupitit, Uhokri hiyapkis gikiythani pit”? ");
INSERT INTO plu_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ayteke nikwe igkis woke gimew asabwat. Ig Kiyapwiye Jesus hiyapni henne, ig sarayh gipegyi ta inut. Ig awna: ―Nighu, kibeyne pis timap nupigyepkawni. ");
INSERT INTO plu_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nah hiyakni ku pis apanenekwa timap nupigyepkawni. Henneme nah awna inakni henne gidahankis nerras hiyeg tabirbetnene ay kahadbe igkis iha ku pisnewa ku pariye nawahkisten. ");
INSERT INTO plu_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Pisenwa gawnhan inakni yuwit, ig awna akak madikte gawaygyi: ―Lázaru, pesnaba agikutak pimew. ");
INSERT INTO plu_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Aynewa ig miyapiye kannikaw ig pese agikutak gimew. Ig wanamin akak kamis. Gihepka hawwata awasap. Igme Kiyapwiye Jesus awna gitkis hiyeg: ―Mawasaptihnig ariw kamis adahan ig wew. ");
INSERT INTO plu_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Kaayhsima nerras judeyenepwi giwewkistenkis guhaptiyepwi kiyapuno Mahi igkis hiyapni henne ku samah Kiyapwiye Jesus kannikasig, metakwa igkis kamaxwe ta gipitit. ");
INSERT INTO plu_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Henneme gaytakkis tipik ta gitkis nerras farisewkis. Igkis danuh atere, igkis akki gitkis ku ig Kiyapwiye Jesus kannikase kiyapwiye Lázaru. ");
INSERT INTO plu_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ayteke nikwe ariwnteke ini nerras muwpeg kiyatyepwi keh gipandukawnikis gikakkis nerras farisewkis adahan igkis ahegbetenes ginetnikis. Igkis awna: ―Mmah wixwiy keh? Ner awayg keh kaayhsima annut. ");
INSERT INTO plu_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ku wis ka mpithig, madikte hiyeg kamaxwa ta gipititnek. Igkis kehginek ig humaw gikiparakis. Ayge nikwe nerras ukiparawiy romayenepwi ikiynek ku ig uwiwhpitniwiy giwakutakkis. Nawenétke gisuwtatapukis ayta patiptakawiy. Nawenétke igkis xuwehe uwakutakwiy ini uwetriwiy ku kiney wixwiy kiyathene Uhokri. Nawenétke igkis xuwehe uhiyegapuwiy judeyenepwi uwakutakwiy. Hennewatbaki igkis kinetihwa. ");
INSERT INTO plu_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ayteke pahapwi awayg gaytakkis ig ikene gihiyakemnikis atere. Giw Kayfás. Ignewa muwpegpiyene gikiparakis adahan ini peheknene kamukri. Ig awna gitkis: ―Yis ka hiyak ariknawnama. ");
INSERT INTO plu_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Yis ka hiyak ku pariye kabayte adahan wixwiy keh. Nah akkite yit ku pariye wategbet uhawkanwiynek. Pugamawka ig Jesus umehpika. Pi kabayte pahapwiwa awayg miyá gidahankis madikte hiyeg mpinekata madikte hiyeg miyarap. Hennewatbaki ig amekene Kayfás awna. ");
INSERT INTO plu_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kawki gikehbetanma inakni yuwit. Igwa Uhokri ikí git inakni yuwit. Ku samah ig muwpegpiyene gikiparakis, ig humaw Uhokri gawnepe adahan ekkene ku samah Kiyapwiye Jesus umahkiswa gidahankis madikte hiyeg judeyenepwi. ");
INSERT INTO plu_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ka gidahanwonasma judeyenepwima. Ig umahkiswa adahan madikte Uhokri gikamkayupwi muwwapu adahan igkis humaw pahapwiwa pawtak. ");
INSERT INTO plu_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ariwntak ini hawkri nerras judeyenepwi giwewkistenkis igkis ahegbetepye ginetnikis adahan giwmasepten Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ig Kiyapwiye Jesus hiyapni henne, ig ka wew gibetimpikis hiyeg ayge Judeyamnaw akiw. Ig pes ta apitit pahá waxri kennesa arimkat amatap. Ayge ig msakwa apit paytwempu Efrayh payak ukakhu usuh gikannuhnipwi. ");
INSERT INTO plu_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ahawkanaprik kabá danuh adahan hiyeg judeyenepwi keh ini fet adahan axne muttuhyan arih. Igkis axni adahan kiyene ku samah minikwak Uhokri umahkis muttuhyan gidukwenaprikkis amekenegben adahan ig giwiwhkiswitnikis giwakutakkis hiyeg ejituyenepwi. Apit gipetrakis kapusa, kaayhsima hiyeg pes muwwapu ta apitit Jerusalém. Igkis atere adahan barewpithewnekis ariw gipathawnikis. ");
INSERT INTO plu_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","57","Apim ini nerras muwpeg kiyatyepwi gikakkis nerras farisewkis igkis awna ta gitkis hiyeg: ―Ku pahapwi yaytak hiyak ku kiney Jesus, akkanig wothu. Igkis awna inakni adahan igkis kamaykiswig. Igkis hiyeg fetyapu hiyapni henne, ku samah igkis tabirweknenete agiku Uhokri Gipin, igkis giwmpetni takunipti. Ayge igkis kinetihwa pawtak gimin. Igkis awna: ―Mmani yit? Mmah aytnikig? ");
INSERT INTO plu_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Puguhkuna hawkri apit ini fet danuh, ig Kiyapwiye Jesus danuh ta apitit paytwempu Betâniya. Ayge kiyapwiye Lázaru gipin ku pariye ig Kiyapwiye Jesus kannikase ariw gimiremni. ");
INSERT INTO plu_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ayge hiyeg keh axka adahan kiyathene Kiyapwiye Jesus. Eg kiyapuno Marta kuwegwano gidahankis madikte hiyeg ayge. Igme kiyapwiye Lázaru ayge gikakkis nerras ku pariye ahumwenepwi axtet gikak Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Egme kiyapuno Mahi hawwata ayge. Apim ini eg awna: ―Kiyapwiye Jesus kennesa gimiremni. Nah imiheprite. Eg iwé abusku lit imihgi kehka akak “nardu” inyekata. Ini imihgi kanitiwnisima. Ayteke eg dimukwin ta gikugkaprikut Kiyapwiye Jesus. Ayteke eg manpuse gikugku akak gusemnu. Ini imihgi amihyi kipunse payt. ");
INSERT INTO plu_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Pahapwi awayg ayge ig hiyapni henne, ig ka batek. Igwata Kiyapwiye Jesus gikannuhniwata ke usuhbe. Ig amekene Simawh gikamkayh Judas Iskariyotismin. Iggi ku pariye kamaykistinene Kiyapwiye Jesus ta gitkis gipetunyapu. Ig awna: ");
INSERT INTO plu_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―Ini imihgi kanitiwnisima. Ikkam adahan in piyukwika adahan kaayhsima karukri mpanamku sah (300) karukri. Mmahki eg sarayhpin waditnepyenen henne? Mmahki in ka piyukka adahan ibekhene akakurapig gipuriwkis madiptapye? ");
INSERT INTO plu_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ig awna inakni henne ke wotbe ig batek gikakkis madiptapyebe. Bawa kawa. Ig awna henne awaku ig amepye. Ig apuriwkeputne ukakura ku kariwntak ig amé. ");
INSERT INTO plu_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Igme Kiyapwiye Jesus hiyapni henne, ig awna git: ―Maytwangu. Eg darih ini imihgi adahan nahegbetepten adahan nah apuhpiki. ");
INSERT INTO plu_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Hiyawa apanenekwa yis apuriw madiptapye. Henneme nahme ka msakwa ay yibet apanenekwatma adahan yis napuriwten. ");
INSERT INTO plu_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ayteke ariwnteke ini kaayhsima hiyeg kinetni Kiyapwiye Jesus gak ku ig ayge apit Betâniya. Igkis kinetni henne nikwe igkis atere giyawaswetni. Igkis hawwata giyawaswetni kiyapwiye Lázaru ku pariye Kiyapwiye Jesus kannikasa ariw gimiremni. ");
INSERT INTO plu_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Mmanawa nerras muwpeg kiyatyepwi kuwis ahegbete ginetnikis adahan igkis giwmasepten kiyapwiye Lázaru hawwata. ");
INSERT INTO plu_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Mmanawa kaayhsima judeyenepwi giwewkistenkis miniw giwkis adahan kamaxwepye ta gipitit Kiyapwiye Jesus awaku ku samah ig kannikase kiyapwiye Lázaru ariw gimiremni. ");
INSERT INTO plu_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Hewke akiw kaayhsima hiyeg fetyapu ayge Jerusalém igkis timé Kiyapwiye Jesus gak ku ig nemnik atere. ");
INSERT INTO plu_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Igkis timapni henne, igkis awna: ―Uyay amapig kabayhtiwa. Uyay barewha ahin gapit pitati akak ahamna. Igkis iwé ahamna ke kariktimnabe, igkis pes patiptakig. Igkis kabiman akak gibetkikis. Igkis awna: ―Kibeyne gidahan Uhokri. Uhokri gabay gikaknek ner ukiparawiy ku pariye ayta giwaprik Uhokri. ");
INSERT INTO plu_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Igme Kiyapwiye Jesus uté pahapwi kawayyan “jumentu”. Ig sarayhwa giduhyamadgat. Mmanawa Uhokri gannasan minikweknene kinetihwa henne gimin. ");
INSERT INTO plu_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Inakni gannasan awna: “Yis hiyeg siyawhyenepwi, ka ba yi barukinama. Sarayhnay yipegyi. Yikipara nemnik. Ig bete giduhyamadga pahapwi kawayyan “jumentu”.” ");
INSERT INTO plu_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Apim ini hawkri usuh gikannuhnipwi ka pukuhpa ku samah Kiyapwiye Jesus keh henne. Henneme ku aysaw ig wagehe inugikut ku kiney ig kiyathaka, apim ini usuh kiyé inakni yuwit amadga Uhokri gannasan minikweknene. Ayge usuh pukuha ku usuh keh gikak Kiyapwiye Jesus apigkutaprik ku samah Uhokri gannasan. ");
INSERT INTO plu_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Nerras hiyeg ku pariye ayge ku kiney Kiyapwiye Jesus kannikasa kiyapwiye Lázaru ariw gimiremni ig humakri agikutak gimew, nerras hiyeg keh temwe gidahan Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Kaayhsima hiyeg timapni henne ku samah ig keh ini annut, igkis hawwata atere patiptakig. ");
INSERT INTO plu_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Nerras farisewkis hiyapni henne, igkis kinetihwa pawtak. Igkis awna: ―Ka ba yis hiyá ku samah igkis hiyeg ka iha wownhu? Madikte hiyeg atere gimkat adahan igkis kamaxwepyes ta gipitit. ");
INSERT INTO plu_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Gaytakkis nerras fetyapu ku pariye ayta kiyathenes Uhokri atere, gaytakkis apititak waxri Grésiyamnaw. Igkis ka judeyenepwima. ");
INSERT INTO plu_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Igkis danuh ta git kiyapwiye Filip ku pariye ariwntak paytwempu Betsayda apititak Galiléyamnaw. Igkis awna git: ―Kiyapwiye, usuh ayta kinetihwekerepye gikak Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ig kiyapwiye Filip timapni henne, ig tipik ewk ginetnikis ta git kiyapwiye André. Ayteke igkis piyamate tipik akkin ta git Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Igme Kiyapwiye Jesus hiyapni henne ku hiyeg kane judeyenepwima mpiksewne giharit, ig kaytwa giwnkis: ―Kuwis nuhawkanaprik danuh adahan nah ku pariye wageswe awayg amadgaya inin adahan nah kawih nukiythani. ");
INSERT INTO plu_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Amawka nah miyá nah kannikaw akiw kahadbe kaayhsima hiyegipiyene aymuhwa gimun Uhokri adahan apanenekwa. Ihanabay inakni nuwnhu. Hennewatbaki in. Nah kewa pahá amutribe ayakbe. Ku amutri ayak ka mutuhka, eg ka hiyá egma keb. Amawka ku eg mutuhka waykekut eg batekwe eg hiyan. Ayge nikwe eg tarakwa nukuno eg sarayh guw kaayhsima. Amawka nuhiyegapu wew akak akebyi ini nuhiyakemni. Amawka igkis umahkise gihiyakemnikis amadgaya inin adahan nukunewa tarakwa akiw. Ayge nikwe kaayhsima hiyeg aymuhwanek gimun Uhokri. ");
INSERT INTO plu_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ku pahapwi ka miyeh giwskawni amadgatak inin, iggi biyuk akak giwskawni giwntak Uhokri. Henneme ku pahapwi miyehe giwskawni amadgatak inin ndahan, iggi darih giwskawni giwntak Uhokri adahan apanenekwa. ");
INSERT INTO plu_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ku ig wew akak akebyi ini nuhiyakemni, ig msakwanek ku kiney nah msakwa. Mmanawa ku pahapwi keh nubetki, iggi Nighu kiyathasig. ");
INSERT INTO plu_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ayteke ig Kiyapwiye Jesus awna akiw. Giwn: ―Kuri nah kayah apititak nuyakni apatra ini mbeyne nemnikumpiye numkanit. Henneme nah ka ayá git Nighu adahan ig apuriw nupithu ariw ini mbeyne. Nah ayta atan adahanikwa nah hiyá ini mbeyne. ");
INSERT INTO plu_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Pa, Nighu, nah he muwaka pis kiyathasa piw. Ku samah ig awna inakni yuwit, nikwenéwa pahá ikupimnat awna git ayta inugiktak. In awna: ―Kuwis nah kiyathasa nuwhu. Aysawnemenek nah kiyathasin akiw. ");
INSERT INTO plu_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Nerras hiyeg tabirbetnenepwi ayge, igkis timapni ini ikupimnat henne, igkis awna: ―Diridriye. Igkisme gaytakkis awna: ―Pahapwi ahj awna git. ");
INSERT INTO plu_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Igme Kiyapwiye Jesus awna: ―Inakni ku pariye yis timá, inakni arekhetni yit ku Uhokri kuwis timap nupigyepkawni. Ig ka awna henne adahanma nah hiyakni henneme adahan yis hiyakni. ");
INSERT INTO plu_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Kabá ahawkanaprik danuh adahan nerras ku pariye kane Uhokriyanpuma gihiyakemnikis hiyekepka ku in ka waditnama. Kuri gikiparadkis gihawkan me wanegbetepkamet. ");
INSERT INTO plu_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ku samah nah ikepka ta inut aminat ah nah kah madikte hiyeg ayta numkat adahan igkis kamaxwepye nupitit. ");
INSERT INTO plu_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ig Kiyapwiye Jesus awna inakni henne, ig ekkene ku samah ig umahkiswa amin giyakninek. ");
INSERT INTO plu_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Nerras hiyeg timapni henne, igkis awna git: ―Mmah pimiremninek? Ekkepka wothu amadgatak Uhokri gannasan minikweknene ku Uhokri gikanyan adahan ukumaduketni ig msakwa adahan apanenekwa. Pis ikewne ku pis wageswe awayg amadgaya inin. Nikwe wothu pis ner Uhokri gikanyan. Mmah nikwe pis awna ku amawka ku pis ikepka ta inut aminat ah? Pariyekap pis ku pariyene wageswe awayg amadgaya inin? Ba pis ka Uhokri gikanyanwatma adahan ukumaduketni? ");
INSERT INTO plu_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Igme kaytwa giwnkis: ―Yis kote pukuhate inakni nuwnhu henneme aysawnemenek yis pukuhpinnek. Ku samah kamuw gibutni uguh hawkri puwipwak in keh hiyeg hiyap, nahme uguh yihiyakemni adahan yis hiyak ku pariye hiyakemniki inyerwatnene. Nah ka ayipwi ay yikak akiw. Ku samah nah aynete, amapanabay nuwnhu, wewnabay abet ini nubutni kahadbe amisnapyi ka msanpih yihiyakemni. Ku pahapwi wew abet amisnapyi, ig ka hiyak ku kit ig wew. ");
INSERT INTO plu_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ku samah nubutni aynete yibet, kamaxwanabay ta nipitit kahadbe yihiyakemni ke wotbe in kabutennebe. Pisenwa gawnhan inakni ig ayguhwe giwkis. ");
INSERT INTO plu_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Hiyawa ig Kiyapwiye Jesus keh annut kaayhsima giwtrikneswa hiyeg henneme ka madiktema hiyeg kamaxwa ta gipitit. ");
INSERT INTO plu_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Henne in danuh ku samah Uhokri gawnepe amekene Isaías giwn. Ig awna: “Kiyapwiye, yuma hiyeg iha unetni pimin. Igkis mahikohe pannu.” Hennewatbaki ig amekene Isaías awna. ");
INSERT INTO plu_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ayge nikwe ku samah igkis mahikohkere gannu igkis ka hiyá igkisma iha wownhu. Ig amekene Isaías hawwata kinetihwa amin ini. Giwn: ");
INSERT INTO plu_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Uhokri sabukkise giwtyakkis marihwa igkis ka hiyap ku pariye hiyakemniki inyerwatnene. Ig dahkise gihiyakemnikis marihwa igkis ka pukuhpin ku pariye hiyakemniki inyerwatnene. Waké ka hennema, igkis wageskam gihiyakemnikiskam igme makniwigkiskam.” ");
INSERT INTO plu_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ig amekene Isaías awna inakni henne awaku ig kuwis hiyá ku samah Kiyapwiye Jesus igyerwa kagikiythanisima. Inneki keh ig awna inakni henne gimin. ");
INSERT INTO plu_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Hiyawa inakni giwn inyerwa, henneme gaytakkis hiyeg iha Kiyapwiye Jesus giwn juktah gaytakkis uwewkisten. Henneme igkis ka ekkewkere ku igkis kamaxwa gipitit awaku igkis apisemun gibohrikis nerras farisewkis. Igkis apis ku nawenétke igkis ka isaksaka parak agikut leglis akiw. ");
INSERT INTO plu_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Nikwe igkis ka ekkewkere. Gitkis pi kabayte hiyeg amadgayapu inin kiyatigkis mpinekata igwa Uhokri kiyatigkis. ");
INSERT INTO plu_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ig Kiyapwiye Jesus awna ta gitkis hiyeg akiw. Giwn: ―Ku pahapwi kamaxwa ta nupitit, amun ini nikwe ig hawwata kamaxwa ta gipitit ku pariye nawahkisten atan amadgat inin. Usuh pahapwiwa pawtak. ");
INSERT INTO plu_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ku pahapwi hiyapun, amun ini ig kuwis hiyá nawahkisten hawwata. Uwewni pahatwowa. ");
INSERT INTO plu_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nah kewa pahá abukribe. Nah ayta amadgat inin uguhne hiyeg gihiyakemnikis kahadbe nerras ku pariye kamaxwepyes nupitit ignes ka msakwa ke wotbe abet amisnapyibe. ");
INSERT INTO plu_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Yaytak timá nuwnhu henneme yis ka iha inakni nuwnhu. Kawki nahnema katiwnise ini yitaraksan yit. Nah ka ayta atan adahanma katiwnisene hiyeg gitaraksankis gitkis. Nah ayta gamnihtenkis. ");
INSERT INTO plu_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ku pahapwi ntukepten, ku ig ka amapa nuwnhu, ay pahat arikna ku pariye katiwnise gitaraksan git. Inakni nuwnhu ku pariye kuwis nah ekke yit, ini katiwnise gitaraksan git aysawnemenek amaksemni hawkri. ");
INSERT INTO plu_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Mmanawa nuwnhu ka nuwnteknewatma. Nighu nawahkisten iggi akki nuthu yuwit ku pariye adahan nah awna. Ig akki nuthu ku kamin adahan nah kinetihwa. ");
INSERT INTO plu_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nah hiyakni ku pariye hiyeg iha giwn ignes aymuhwa gimun Uhokri adahan apanenekwa. Nikwe ku pariye nah kinetihwa yit, nah awna ku pariye ig Nighu gakkan nuthu. ");
INSERT INTO plu_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ayteke ariwnteke ini, kabá danuh ahawkanaprik adahan ini fet adahan axne muttuhyan arih. Hiyeg judeyenepwi axni adahan kiyene ku samah minikwak Uhokri umahkis muttuhyan gidukwenaprikkis amekenegben kahadbe ig giwiwhkiswitnikis giwakutakkis hiyeg ejituyenepwi. Ig Kiyapwiye Jesus hiyapni henne, ig hiyakni ku gihawkanaprik kabá danuh adahan ig tipikwiye amadgatak inin diyuhpiye ta git Gig. Hennewa gihawkan makisup, ig batekye gikakkis gihiyegapu amadga inin. Ayteke nikwe ig akki wothu huwewe ku ig batek ukak mpiynepepye. Nah akkite yit ku samah. ");
INSERT INTO plu_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Aygete usuh axne gikak Kiyapwiye Jesus. Ig Judas Iskariyotismin ku pariye amekene Simawh gikamkayh, ig ayge ukakhu. Kuwis wapitye gikiparadkis tuguhkis abet gihiyakemni adahan ig kamaykiswiye Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ig Kiyapwiye Jesus hiyakni ku ig giwnteknene Uhokri ig diyuhpiye ta git Uhokri. Ig hiyakni ku Uhokri ikí gikiythani gitnek adahan ig kumadukene madikte. ");
INSERT INTO plu_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ig hiyakni henne, ig awna: ―Nah akkite gitkis huwewehe ku samah nah batek gikakkis. Ig kannikaw ahumwatak axtet. Ig wiwh gidagmanpit. Ig wanak pahak sewyet gibutikmin. ");
INSERT INTO plu_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ig huk un ta amadgat pohow beysin. Ayteke nikwe ig sukuhkuge usuh gikannuhnipwi pahapwimpi. Ig manpuse ukugku akak gisepyeta ku pariye waneknene gibutikmin. ");
INSERT INTO plu_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Metakwa ig danuh ta git kiyapwiye Simawh Pedru. Igme kiyapwiye Simawh Pedru awna git: ―Kiyapwiye, pis ka ibuktima. Pis nukipara. Ka kis adahan pis sukuhkugan. ");
INSERT INTO plu_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Igme Kiyapwiye Jesus awna git: ―Pis ka pukuha ku pariye kuri nah keh. Henneme kuwewanek pis pukuhpinnek. ");
INSERT INTO plu_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Igme kiyapwiye Pedru awna git: ―Pis ka nubukhuma. Nah ka isaksap adahan pis sukuhkugan. Igme kaytwa giwn: ―Ku nah ka sukuhkugap, nikwe pis ka ndahewektenma akiw. ");
INSERT INTO plu_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Igme Pedru timapni henne, ig awna git: ―Ku henne nikwe, uyá sukuhptan pahapwite peyeke akak nukugku. ");
INSERT INTO plu_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Igme awna git: ―Ku pariye hiyeg kuwisnene awkep, ig kuwis barewpit. Ku ig wagah waxrit, ig ka pataha gipit akiw. Ig pataha gikugkunen. Kuri amawka ig sukuhe gikugkunen adahan ig msakwa barewpit akiw. Kuwis yis barewpityekwiye. Henneme pahapwiwa yaytak ka barewpityema. ");
INSERT INTO plu_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ig awna inakni henne mmanawa ig kuwis hiyak ku pariye gikamaykiswitni ta gitkis gipetunyapu. ");
INSERT INTO plu_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Pisenwa gisukan gikugkukis, ig kawih gidagmanpit akiw, ig batahkiswa akiw. Ayteke nikwe ig awna wothu: ―Ba yis pukuha ini ku pariye nukehni yikak kuri? Nah akkite yit. ");
INSERT INTO plu_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Yis kanumun yikipara yikannuhten. Yiwnapriknawa mmanawa nahnewa. ");
INSERT INTO plu_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ku samah nah yikipara yikannuhten ikaw kewa pahapwi ibuktibe yidahan nah sukuhne yikugku, amawka ku yis hawwata yis ikaw ke ibuktibe adahan kehne kabayka pawtak. ");
INSERT INTO plu_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nahnewa yikannuhten yiwtrik adahan yis ikaw tuwatapye ke nahbe. ");
INSERT INTO plu_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ku samah nahwa yikipara yawahkisten ikaw tuwatapye amawka yis hawwata. Ihanabay inakni nuwnhu. Hennewatbaki in. Pahapwi ibukti ka kiyattema mpiy gikipara. Iné pahapwi iwatnit kawnata kiyattema mpiy gawahkisten. ");
INSERT INTO plu_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Kuri yis hiyak kabayhtiwa ku samah ini nuhiyakemni. Ku yis wew akak ini tuwatka, yis utí kaayhsima kabaykanek. ");
INSERT INTO plu_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","―Henneme pahapwi ay yaytak ig ka utí kabaykanek. Nah hiyakni mmanawa nah kuwis hiyak ku pariye ay apit yiyakni yis nukanyanpu. Henneme nah kaniyi ku pariye nukanyanpu kahadbe in danuh ku samah Uhokri gannasan minikweknene awna numinhu. In awna: “Pahapwi ku pariye axne papetunak nukakhu iggi wageswepye nupetunyanek.” Ku apim inin inakni yuwit metakwa in kahayak. ");
INSERT INTO plu_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Henneme apit in kahayak nah akkamnihni yit kahadbe ku aysaw in kahayak yis hiyakni ku nah igyerwa Uhokri gikamkayh. ");
INSERT INTO plu_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ku pahapwi amapa nuwatni, amun ini nikwe in ke wotbe ig kuwis amapan hawwata. Ku pahapwi namerepten, amun ini nikwe in ke wotbe ig kuwis amapa ku pariye nawahkisten atan amadgat inin hawwata. Ihanabay inakni nuwnhu. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ayge amun ini ig Kiyapwiye Jesus katiw apit giyakni. Ig awna: ―Pahapwi yaytak ay iggi kamaykiswennek ta gitkis nupetunyapu. Ihanabay inakni nuwnhu. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Usuh gikannuhnipwi timapni henne, usuh msekwe he ipegbet. Usuh ka hiyak ku kamin ig awna. ");
INSERT INTO plu_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Nah ayge bat gihumwa Kiyapwiye Jesus mmanawa ig batek nukakhu. ");
INSERT INTO plu_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ayteke kiyapwiye Simawh Pedru hiyapni henne, ig tawanha akak gitew. Ig minimni ta nuthu: ―Ayapnig ku kamin ig awna. ");
INSERT INTO plu_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Nah timapni henne, nah ataybiswa ta git Kiyapwiye Jesus. Nah ayapri: ―Kiyapwiye, pariyekig? ");
INSERT INTO plu_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Igme kaytwa nuwnhu: ―Ku karimkat nah akaki bugut mehbetakinen, ignewatbaki. Ayteke nikwe ig mehbete bugut ahakwa im araku, ig akakin ta gimkat Judas Iskariyotismin ku pariye amekene Simawh gikamkayh. ");
INSERT INTO plu_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Igme ax ini bugut. Pisenwa gaxni, ner wapitye gikiparadkis Satanás kawihpig. Ig Kiyapwiye Jesus hiyapni henne, ig awna git: ―Iwawhawnaba. Hiyawa pis keh ku pariye pis kehkere. ");
INSERT INTO plu_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Usuh ayge aranwa axtet usuh ka hiyak ku samah ig awna inakni git. ");
INSERT INTO plu_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Waytak gipewkankis adahan ig isimne im adahan fet. Waytakme gipewkankis adahan ig ikene karukri ta gitkis madiptapye. Igkis kiyemna henne mmanawa ig Judas Iskariyotismin apuriwne ukakura. ");
INSERT INTO plu_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Igme Judas Iskariyotismin pisenwa gaxni ini bugut, ig tipik kibentenwa. Apim ini kuwis tiyegim. ");
INSERT INTO plu_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ig pesantenwa wowntak, igme Kiyapwiye Jesus awna wothu: ―Kuri nah ku pariye wageswe awayg amadgaya inin nah me kawih nukiythanimet. Ig Uhokri ig hawwata ig kiyathaka awaku ini kabayka ku pariye nukehni ku apim inin. ");
INSERT INTO plu_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Amun ini nahme kiyathaka awaku ini kabayka ku pariye Uhokri gikehni. Kennesa ahawkanaprik adahan ig ikene nukiythani. ");
INSERT INTO plu_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Nukamkayupwi kibeynewa, nah ka msakwa ayipwadima ay yikak akiw. Kuwewanek yis ipegpannek henneme waditnepyenen. Ku samah nah kuwis awna gitkis nerras judeyenepwi giwewkistenkis nah awna yit hawwata: “Ku kitwiye nah, yis ka hiyá yisma danuh atere.” ");
INSERT INTO plu_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","―Kuri nah ikene yit nukune yihiyakemni. Batekaknabay pawtak. Batekaknay hawwata ku samah nah batek yikak. ");
INSERT INTO plu_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ku yis batekak pawtak, ayge amun ini nikwe madikte hiyeg hiyakni ku yis nukannuhnipwi. ");
INSERT INTO plu_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ayteke kiyapwiye Simawh Pedru ayapri: ―Kiyapwiye, kitwiyekap? Igme kaytwa giwn: ―Ku kitwiye nah, pis ka hiyá pisma atak nuhapti kuri. Henneme aysawnemenek pis danuh aterenek. ");
INSERT INTO plu_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ig kiyapwiye Pedru timapni henne, ig awna git: ―Kiyapwiye, mmahki nah ka hiyá nahma atak pihapti? Hiyawa pis umehpika, henneme nah ahegbet adahan nah umahkiswa payak pikak. ");
INSERT INTO plu_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Igme kaytwa giwn: ―Mmah inyerwatki ku pis ahegbet adahan pis umahkiswa payak nukakhu? Ped, ku apim inin mtipka pis wihwe nuwhunek. Apit takarak awna pahaywowa gawnhan, pisme ayipa wihwe nuwhunek mpamaput. Ihanaba inakni nuwnhu. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ayteke ig awna ta wothu akiw: ―Ka yi muwaka barukiswama nuharit. Ka yi muwaka apis. Kamaxwanabay ta gipitit Uhokri. Kamaxwanabay nupitit hawwata. ");
INSERT INTO plu_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Kaayhsima iwetrit ayhté gimun Wigwiy. Waké yuma iwetrit aygebe, nikwekam nah ka awnakam inakni henne. Nah atak ahegbetepye yiwetri yapit. ");
INSERT INTO plu_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ku yis hiyá nah tipik ahegbetepye yiwetri yapit, atannewa nah diyuhe akiw adahan yiwepten aterenek kahadbe ku kiney nah msakwa aygwata yis msakwa. ");
INSERT INTO plu_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ayteke ig awna: ―Yis kuwis hiyak ahin adahan yis danuhne ku kitwiye nah. ");
INSERT INTO plu_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ig kiyapwiye Tomé timapni henne, ig awna git: ―Kiyapwiye, usuh ka hiyak ku kitwiye pis. Mmah ahiyaka ahin wothu? ");
INSERT INTO plu_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Igme Kiyapwiye Jesus kaytwa giwn: ―Nahnewa ahin. Nahnewa hiyakemniki inyerwatnene ahawkri. Nahnewa yidehetni. Waké ka nahma, yumahkam hiyeg danuhne ta git Wigwiy. Nahnewa ku pariye ahin atere git. Yuma nawenéwa ahin akiw. ");
INSERT INTO plu_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ku yis hiyakun, amun ini yis kuwis hiyak Wigwiy hawwata. Kuri aytekihan yis hiyakri, yis hawkamnihwanek yis kiyé ku yis kuwis hiyapri. ");
INSERT INTO plu_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ig kiyapwiye Filip timapni henne, ig awna git: ―Kiyapwiye, uyá akki Wigwiy wothu. Ignewa usuh hiyepkere. ");
INSERT INTO plu_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Igme kaytwa giwn: ―Filip, ka kuryenema nah ay yikak kuwis. Mmah yis kote hiyakunte? Ku pahapwi hiyapun, amun ini ig kuwis hiyap Wigwiy hawwata. Mmah nikwe pis awna: “Uyá akki Wigwiy wothu?” ");
INSERT INTO plu_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Nah gikak Wigwiy usuh pahapwiwa pawtak. Mmah pis ka iha inakni? Ku pariye nuwnhu yit kawki nuwnteknewatma nah awna yit. Nah awnhin giwntekne Wigwiy ku pariye ay nupithu. Ignewa ku pariye ikí nannuh adahan nah kehne annut. ");
INSERT INTO plu_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Nah gikak Wigwiy usuh pahapwiwa pawtak. Ihpanabay inakni nuwnhu. Ku yis ka iha inakni nuwnhu, kiyemnahnabay nannuh. Nawenétke nannuh keh yis iha ku nah pahapwiwa gikak Wigwiy. ");
INSERT INTO plu_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","―Ku pahapwi kamaxwepye nupitit, iggi keh annut hawwata ke nahbe. Ig pi kehte annut nuwhu awaku nah tipik ta git Wigwiy. ");
INSERT INTO plu_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Apim ini ku pariye yayapni nuthu nuwaprik nah ikí yit kahadbe ig Wigwiy kiyathaka awaku ini ku pariye nukanhu yit. ");
INSERT INTO plu_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Madikte ku pariye yayapni nuthu nuwaprik nah ikí yit. ");
INSERT INTO plu_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","―Ku yis batek nukakhu, ihpanabay nuwnhu. ");
INSERT INTO plu_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nahme ayá git Wigwiy adahan ig awahkis pahapwi nuwenyan adahan yawayghetni. Igme yawayghetni msakwa yikaknek adahan apanenekwa. ");
INSERT INTO plu_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Iggi Uhokri Gitip. Ig apanenekwa ekkene ku pariye hiyakemniki inyerwatnene. Hiyeg kane Uhokriyanpuma igkis ka hiyá igkisma amapig mmanawa igkis ka hiyapri, igkis ka hiyakri ku pariyene ig. Yisme hiyakri ku pariyene ig mmanawa ig msakwa ay yikak. Aysawnemenek ig msekwepye ay yipitnek. ");
INSERT INTO plu_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","―Nah kennesa nah yikiswitnimet henneme nah ka ikisyi yis pahaponama. Nah diyuh akiwnek nah msakwa yipititnek. ");
INSERT INTO plu_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Aynessa hawkri muwak adahan hiyeg kane Uhokriyanpuma igkis ka hiyapun akiw. Yismeti hiyapun akiwnek. Ayge nikwe yis aymuhwanek gimun Uhokri adahan apanenekwa awaku nahnewa aymuhwene gimun. ");
INSERT INTO plu_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Apim ini hawkri ku aysaw nah ayta msekwepye yipitit, apim ini yis hiyakninek ku nah pahapwiwa gikak Wigwiy, yisme pahapwiwa nukakhu. ");
INSERT INTO plu_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ku pahapwi timá nuwnhu, ku ig iha nuwnhu, ignewa ku pariye batekye nukakhu. Ku pahapwi batekye nukakhu, nikwe Wigwiy batekye gikak. Nah hawwata nah batek gikak, nah hiyakkiswa git. ");
INSERT INTO plu_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Kiyapwiye Judas timapni henne, ig awna git. Ig nawenéwa giw Judas Iskariyotismin. Giwn: ―Kiyapwiye, mmahpa pis hiyakkiswa wothunenwa? Mmah gitkisme nerras ku pariye kane pihiyegapuma pis ka hiyakkiswa gitkis? ");
INSERT INTO plu_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Igme kaytwa giwn: ―Nah akkite pit ku samah. Ku pahapwi batekye nukakhu, ignewa ku pariye ihpatrune nuwnhu. Ayge nikwe Wigwiy batek gikak. Usuh ayta msakwa ta gipitit. Ayge usuh msakwa gimun. ");
INSERT INTO plu_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Pahapwime ku pariye kane batek nukakhu iggi ka iha nuwnhu. Nikwe ka kis adahan nah hiyakkiswa git. Inakni nuwnhu in ka nuwnteknewatma nah awna yit. Nah awnhin giwntekne Wigwiy nawahkisten. ");
INSERT INTO plu_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","―Nah aynete yikak nah ekkene yit inakni. ");
INSERT INTO plu_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Henneme aysawnemenek Wigwiy awahkis Gitipnek nuwenyan adahan igme yikannuhten amin madikte hiyakemniki. Iggi yawayghetninek. Ig kiyekis yit madikte inakni ku pariye nuwnhu yit. Ig keh yis pukuhpin. ");
INSERT INTO plu_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","―Nah ikisyi akak ini nukanhu yit kariswaki. Nah kariswehse yiyakni kahadbe yis msakwa hawwata ke nahbe, yiyakni karisaw. Nah kariswehse yiyakni inyerwa, ka kema hiyeg amedgenema inin. Ka yi muwaka barukiswa. Ka yi isaksa apiska parak apitit yiyakni. ");
INSERT INTO plu_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mmahki yis wakaymnibdi amin inakni nuwnhu adahan ku samah ntepkemni adahan ndiyhemni akiw? Nah tipikwiye gimkanitwiye Wigwiy. In kabaykanen ndahan mmanawa ig Wigwiy pi kiyatte mpiyhan. Ku yis batek nukakhu, kiskama yis batek akak ini ntepkemni ta gimkanit. ");
INSERT INTO plu_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nah ikene yinetni amin ini ntepkemni. Apit in danuh nah ekkenepni yit kahadbe kuwewanek ku aysaw in danuh, ayge nikwe yis kamaxwa ta nupitit. ");
INSERT INTO plu_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Nah ka kahawkan kinetihwa yikak kiyesradima akiw. Mmanawa ner ku pariye kane Uhokriyanpuma gikiparadkis ig gidawnhan kennesa. Ig ka kawetri ay nupithu. Nikwe ig ka hiyá igma wanegbeta nuhawkan. ");
INSERT INTO plu_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Henneme nah isaksig adahan ig keh nukakhu ku samah Wigwiy awna nuthu. Kahadbe madikte hiyeg hiyakni ku nah batek gikak Wigwiy. Kuri, kannikawnabay. Uyay tipik. ―Uyay. Ayteke nikwe usuh pese ayteke paytrikutak. ");
INSERT INTO plu_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Usuh apigku ahin kuwis, ig Kiyapwiye Jesus awna wothu: ―Nah kewa pahakti amutribe akatbe. Madikte amutri akat amadgaya inin in he arakaknen ndahan. Nahme igyerwatnene. Igme Wigwiy ig kewa pahapwi amutriputnebe. ");
INSERT INTO plu_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ignes nuhiyegapu igkis pahapwiwa nukakhu hawwata ku samah amutri atawnibdi pahapwiwa akak akat. Henneme gaytakkis ka inyerwatma pahapwiwa nukakhu. Igkis kane kehkere nubetki. Igkis kewa atawnibdibe huruhrapyebe ku pariye kane kew. Ig Wigwiy hiyak gikakkisnek. Ku samah pahapwi amutriputne tigah atawnibdi huruhrapye, hawwata ig Wigwiy giwiwhpitnikis nerras ku pariye kane kehkere nubetki. Hawwata ig hiyak gikakkis nerras ku pariye kehnepwi nubetki. Igkis kewa atawnibdibe ku pariye kewtino. Ig amutriputne sagahpewa gamutra atawnibdi ku pariye kewyopwi kahadbe egkis wadiswa egkis kew pi kibite akiw. Hawwata ig Wigwiy sagahbeta gihiyakemnikis ariw gipathawnikis nerras ku pariye kehnepwi nubetki kahadbe igkis keh nubetki kaayhsima akiw. ");
INSERT INTO plu_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Kibeyne, kuwis ig Uhokri kapusa sagahbeta yihiyakemni akak inakni giwn ku pariye nah kuwis akki yit. Ku samah yis ihpin ig keh yihiyakemni barewbetnek. ");
INSERT INTO plu_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Msakwanabay pahapwiwa nukakhu. Nahme msakwa pahapwiwa yikak. Ku atawnibdi ka msakwa aminat akat, egnes ka kew. Hawwata yis. Ku yis ka msakwa pahapwiwa nukakhu, yis ka hiyá akehka nubetki. ");
INSERT INTO plu_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Nah kewa pahakti amutribe akatbe. Yisme kewa ntawnibdihbe. Ku pahapwi msekwepye pahapwiwa nukakhu, ku ig keh nubetki, ig humaw kewa pahat ah atawnibe ku pariye kew kaayhsima. Henneme ku pahapwi msakwa aparayewa nuwhu, ig ka hiyá akehka ariknawnama kibeyne. ");
INSERT INTO plu_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ku pahapwi ka pahapwinama nukakhu, aysawnemenek ig padekwikanek ke pahat ah atawnibe ku pariye huruhrupye. Atawnibdi huruhrapye in pahadguhpika, in padekwika ta ariwtrikut tiket. ");
INSERT INTO plu_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Yisme ku pariye kane hennema, ku yis msakwa pahapwiwa nukakhu, ku nuwnhu msakwa ay apit yiyakni adahan yis wewne nikak, nikwe hiyawa yis ayá nuthu ku pariye yimawkan. Ku pariye yayapni nuthu in humaw yitnek. ");
INSERT INTO plu_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ku yis kehne nubetki kaayhsima, innewa ku pariye keh Wigwiy kiyathaka. Hawwata akiw ininewa arakak ku yis inyerwa nukannuhnipwi. ");
INSERT INTO plu_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","―Nah batek yikak hawwata ku samah Wigwiy batek nukakhu. Wewnabay apigkutaprik ku samah nubetki kahadbe takunipti nah batek yikak. ");
INSERT INTO plu_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nah iha Wigwiy giwn. Takunipti nah keh ig batek nukakhu. Yis hawwata ku yis iha nuwnhu takunipti, yis keh nah batek yikak. ");
INSERT INTO plu_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nah awna inakni yuwit yit kahadbe yis msakwa batek yinaktin hawwata ke nahbe. Nah muwaka yis msakwa kipunenekwa akak batekka takunipti. ");
INSERT INTO plu_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","―Batekaknabay pawtak hawwata ku samah nah kuwis batek yikak. Inakni nukumadukan yit. ");
INSERT INTO plu_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ku pahapwi umahkiswa gidahankis gikagmadapu ini arekhetni ku ig batek gikakkis mpiynepepye. Yuma hiyeg batekak henne ke inibe akiw. ");
INSERT INTO plu_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","―Ku yis iha madikte nuwnhu, yis humaw nukagmadapu. ");
INSERT INTO plu_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nah ka ikayi ku yis nubukpig akiw mmanawa pahapwi ibukti ka hiyak ku pariye abet gikipara gihiyakemni. Henneme nah kuwis ikayi ku yis nukagmadapu mmanawa nah kuwis akki yit madikte ku pariye Wigwiy gakkan nuthu. ");
INSERT INTO plu_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Yis ka kaniyhun adahan nah humaw yikagmada. Henneme nah kaniypey adahan yis humaw nukagmadapu. Nah kaniyyi adahan yis wew muwwapu kehnenekwa nubetki, adahan yis humaw kewa atawnibdibe kaneariwtinisima. Nah kaniyyi adahan yannipwi ka waditnepyenenma. Nah kaniyyi adahan Wigwiy ikí yit madikte ku pariye yayapni git nuwaprik. ");
INSERT INTO plu_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Batekaknabay pawtak. Inakninewa nukumadukan nah ayá ta yit. ");
INSERT INTO plu_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","―Hiyeg kane Uhokriyanpuma igkis amiyepyinek. Henneme nah kit igkis amiyepun. Kiyemnahnay amin inakni. ");
INSERT INTO plu_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Waké yis kane Uhokriyanpumabe, nikwekam nerras kane Uhokriyanpuma batek yikakkam mmanawa yihiyakemni hawwatakam ke gihiyakemnikisbe. Henneme nah kaniypey adahan yis humaw Uhokriyanbetnewa. Nikwe yis ka kema igkisma akiw. Inneki keh igkis amiyepyi. ");
INSERT INTO plu_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Kiyemnahnabay amin inakni nuwnhu yit kaksa. Nah awna: “Pahapwi ibukti ka kiyattema giw gikipara.” Ku samah igkis hiyapkise mbeyne nuthu, hawwata igkis hiyapkis mbeyne yitnek. Henneme ku samah gaytakkis hiyeg iha nuwnhu hawwata gaytakkis iha yiwnnek. ");
INSERT INTO plu_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Igkis keh arakembet mbayka yikaknek apatra ku samah yis nuhiyegapu. Mmanawa igkis ka hiyakri ner ku pariye nawahkisten. ");
INSERT INTO plu_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Waké nah ka ayta akki Uhokri giwn ta gitkisbe, nikwe ikkam adahan igkis awna: “Nah yuma nupathawni.” Henneme kuri igkis ka hiyá igkisma awna inakni henne akiw. Gipathawnikis kuwis ekkepka gitkis. ");
INSERT INTO plu_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ku pariye namiyepten ig hawwata amiyihnata Wigwiy. ");
INSERT INTO plu_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Igkis hiyá nah keh annut ku pariye yuma hiyeg hiyá nikehka. Waké igkis ka hiyapnibe, nikwe ikkam adahan igkis awna: “Nah yuma nupathawni.” Henneme igkis kuwis hiyapni. Igkis hiyapni henneme igkis amiyepun peyeke gikak Wigwiy. ");
INSERT INTO plu_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ini danuh henne kahadbe in kahayak ku samah tamak minikwak amadga gikumadukankis. In awna: “Igkis amiyepun yuma arikna kapatrenesima.” Ku apim inin inakni yuwit kahayak. ");
INSERT INTO plu_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","―Ka sam. Kuwewanek nah awahkis yawayghetni yiminnek. Ig ayta giwntekne Wigwiy. Ig Wigwiy Gitip. Ig apanenekwa ekkenenekwa ku pariye hiyakemniki inyerwatnene. Ku aysaw ig danuh atannek ig akkan ku pariyene nah. ");
INSERT INTO plu_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ayge nikwe yis hawwata akkan ku pariyene nah. Mmanawa yis ay nukakhu ku samah akapuska nannipwi. ");
INSERT INTO plu_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","―Nah ikene inakni yinetni henne kahadbe aysawnemenek yis ka tuguhkis yihiyakemni. ");
INSERT INTO plu_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Aysawnemenek hiyeg ipukepyi agikutak gileglisakisnek. Apim ini igkis umehpey. Gitkis igkis kehne Uhokri gibetki. ");
INSERT INTO plu_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Igkis keh ini mbayka yikak awaku igkis ka hiyak Wigwiy igkis kawnata hiyakun. ");
INSERT INTO plu_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nah akki inakni yit kahadbe ku aysaw in kahayak yit yis kiyé ku nah kuwis akkamnihni yit. Nah ka akki yit minikwak mmanawa nah aynete yikak. ");
INSERT INTO plu_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","―Henneme kuri nah me tipikmet ta git nawahkisten. Yisme yuma pahapwinama yaytak nayaminetni amin ku kadahan nah atak atere. ");
INSERT INTO plu_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Yis msekwe barukibet awaku nah ikí yinetni amin ntepkemni. ");
INSERT INTO plu_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Henneme pugamawka nah tipik. In kabay yidahan. Hennewatbaki in. Ku nah ka tipik, nikwe ka hiyá igma yawayghetni danuh yit. Henneme ku nah tipik, nah awahkisri yimin. ");
INSERT INTO plu_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","―Ku aysaw ig yawayghetni danuh atan ig dax apit giyaknikis hiyeg kane Uhokriyanpuma. Ig akki huwewe gitkis ku igkis taraksapye. Ig akki huwewe ku nahnewa waditye. Ig akki huwewe ku nah detye adahan nah hiyak akak madikte gitaraksankis. ");
INSERT INTO plu_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","In huwewe ku igkis taraksapye mmanawa igkis ka kamaxwa ta nupitit. ");
INSERT INTO plu_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","In huwewe ku nahnewa waditye mmanawa nahnewa danuh atere git Wigwiy, igkis ka hiyapun ay amadga inin akiw. ");
INSERT INTO plu_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","In huwewe ku nah detye adahan nah hiyak akak gitaraksankis mmanawa nah kuwis hiyak gikak ner ku pariye gitaraksankis ahawkri. ");
INSERT INTO plu_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","―Muweke kaayhsima arikna akiw adahan nah akki yit henneme yis kote ikte adahan pukuhpin. ");
INSERT INTO plu_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ka sam. Aysawnemenek Uhokri Gitip danuh atannek. Ig akkamnih madikte yitnek. Ig apanenekwa ekkenenekwa ku pariye hiyakemniki inyerwatnene. Mmanawa ka giwnteknewatma ig awna. Ig awna ku pariye ekkepka git. Ig akki yitnek madikte ku pariye nemnikumpiye. ");
INSERT INTO plu_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Hawwata ig Uhokri Gitip kiyathasan ta yit. Mmanawa ig akki yit madikte nukiythani. ");
INSERT INTO plu_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Madikte ku pariye Uhokri kadahan in ndahanwata. Inneki keh nah awna yit ku ig Uhokri Gitip ig akki nukiythani yit. ");
INSERT INTO plu_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ayteke ig Kiyapwiye Jesus awna ta wothu: ―Ka kebadima hawkri akiw yis ka hiyapun akiw. Henneme ariwnteke ini akiw ka kebadima hawkri akiw yis hiyapun akiwnek. ");
INSERT INTO plu_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Usuh gikannuhnipwi timapni henne, usuh kinetihwene pawtak. Usuh awna: ―Mmahki ig awna inakni henne wothu? Mmahki ig awna: “Nah tipikwiye gimkanitwiye Wigwiy?” ");
INSERT INTO plu_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Mmahki ig awna: “Ka kebadima hawkri?” Wixwiy ka pukuha inakni giwn. Hennewatbaki usuh awna. ");
INSERT INTO plu_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Igme Kiyapwiye Jesus hiyakni ku usuh muwaka gayepten. Ig hiyapni henne, ig awna wothu: ―Mmah yis pukuhpakere ku kamin nah kinetihwa yit? Nah awna yit: “Ka kebadima hawkri akiw adahan yis ka hiyapun akiw. Henneme ariwnteke ini akiw ka kebadima hawkri akiw yis hiyapun akiw.” ");
INSERT INTO plu_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Hennewatbaki in. Kuwewanek yis tihebdi, yis kadnibdi. Igkisme hiyeg kane Uhokriyanpuma apim ini igkis batekyes ginaktinkis. Yisme kadnibdi henneme aysawnemenek ini yikadniy wageswa adahan batekkanek. ");
INSERT INTO plu_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","In kewa pahapu tinobe eg pamakutekwiyobe eg kayah mmanawa kuwis guhawkanaprik danuh. Henneme ku aysaw eg kuwis sarayh guwenyan kuwis, eg ka kiyé gukayhan akiw mmanawa eg batek gunaktin ku samah gukamkayh kuwis amadgat wayk. ");
INSERT INTO plu_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Yis hawwata kuri yis kayahnek apit yiyakni henneme ka sam. Kuwewanek nah patiptakay akiwnek. Ayge nikwe yiyakni bateke akiwnek. Ini batekka yuma pahapwinama hiyeg hiyá awiwhka yipititak. ");
INSERT INTO plu_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Apim ini hawkri ku samah ntipuh kuwis ay yipit yis ka ayapminan amin ariknawnama akiw mmanawa apim ini yis kuwis pukuhemni madikte. ―Ku pariye kabayka yis ayá git Wigwiy nuwaprik ke wotbe nahnebe aygebe ayepne git ig ikí ta yitnek. Ihanabay inakni nuwnhu. Hennewatbaki in. ");
INSERT INTO plu_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Yis kote ayapte git ariknawnama nuwaprik. Ayapnabay kabayka ta git Uhokri. Ayge nikwe in ikaka yitnek kahadbe yis kadahan kaayhsima batekka. ");
INSERT INTO plu_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Nah kinetihwa yit kuri akak yuwit patuwesbuhka henneme aysawnemenek nah kinetihwa yit akak yuwit ka patuwesbuhkama akiw. Apim ini nah kinetihwa gimin Wigwiy yit huwewe. ");
INSERT INTO plu_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Apim ini hawkri yis ayánek kabayka git Wigwiy nuwaprik. Yis ka ayapni nuthu adahan nahme ayá git Wigwiy yidahan. Yiswa ayapni git. ");
INSERT INTO plu_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Mmanawa Wigwiy igwa batek yikak awaku ku samah yis batek nukakhu, yis iha ku nah ayta giwntekne Uhokri. ");
INSERT INTO plu_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nah ayta atan amadgat inin hawkri, nah giwntak Wigwiy. Kuwewa akiwnek nah tipikwiye amadgatak inin. Nah diyuhe aterewata git Wigwiy. ");
INSERT INTO plu_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Usuh gikannuhnipwi timapni henne, usuh awna git: ―Kuri pis awna huwewe. Pis ka awna patuwesbuhkama yuwit. ");
INSERT INTO plu_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Kuri usuh hiyakni ku pis hiyak madikte arikna. Pis ka muwaka adahan hiyeg ayapi mmanawa pis kuwis hiyak ku pariye umawkan ta pit. Inneki keh usuh iha ku pis giwnteknewa Uhokri. ");
INSERT INTO plu_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Igme Kiyapwiye Jesus awna wothu: ―Mmah inyerwatki ku yis iha inakni? ");
INSERT INTO plu_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Timapnabay nuwnhu. Hawkri kabá danuh, in me danuhmet adahan yis madikte peke. Yis ibekhewbet adahan yidahanwa yipinwetwiye. Yis ikiswennek nahwo pahapo. Kameki nah pahaponame mmanawa Wigwiy ay nukakhu. ");
INSERT INTO plu_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nah ikene ini yinetni yit kahadbe yiyakni karisaw awaku ku samah yis kamaxwene ta nupitit. Ay amadga inin yis hiyapkiska mbeyne kaayhsima yitnek. Ka sam. Ka ba yi barukinama. Kuwis nah wanegbete yipetunyapu gihawkankis. ");
INSERT INTO plu_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Pisenwa gawnhan inakni yuwit ig Kiyapwiye Jesus sarayh gipegyi ta inut. Ig awna: ―Pa, kuwis nuhawkanaprik danuh. Kiyathasanaba pikamkayh marihwa pikamkayh kiyathasap hawwata. ");
INSERT INTO plu_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Kibeyne, pis iké nuthu ndatni adahan nah kumadukene madikte hiyeg amadgayapu inin. Ayge nikwe nah keh nuhiyegapu nerras ku pariye pikan nuthu igkis aymuhwa pimun adahan apanenekwa. ");
INSERT INTO plu_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Pisnewa igyerwatnene Uhokri. Yuma pahapwinama kema pisma. Nahme pawahkisni Jesus Cristo. Ini ku samah igkis hiyakpi ini ku samah igkis hiyakun, innewa ku pariye keh igkis aymuhwa pimun adahan apanenekwa. ");
INSERT INTO plu_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Pa, kuwis nah kiyathasap ay amadga inin. Nah kuwis pisenwa akak pannipwi madikte ku pariye pikehkisni nuthu. ");
INSERT INTO plu_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Kuri Pa, nah tipikwiye ta pimkanit. Uyá kiyathasan ayge pimun hawwata ku samah wis kiyathaka ayge minikwak apit hawkri humaw. ");
INSERT INTO plu_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","―Nah kuwis akkap ku samah pihiyakemni ta gitkis nukannuhnipwi ku pariye pikan nuthu amadgatak inin. Igkis pidahan pisme ikeprikis nuthu. Igkisme kuwis ihe piwn. ");
INSERT INTO plu_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Kuri igkis hiyakni ku madikte ku pariye nah keh, nah keh piwntak. ");
INSERT INTO plu_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Mmanawa nah kuwis akki gitkis madikte yuwit ku pariye pakkan nuthu. Igkisme ihpin. Igkis hiyakni ku nah inyerwa piwntekne. Igkis iha ku pisnewa nawahkisten. ");
INSERT INTO plu_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Nah piriyepkaw gidahankis. Nah piriyepkaw kuri ka gidahankisma hiyeg ku pariye kane Uhokriyanpuma. Nah piriyepkaw gidahankis nerras ku pariye pikan nuthu. Mmanawa igkis pidahan. ");
INSERT INTO plu_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Madikte ku pariye ndahan ignes pidahanwata. Madikte ku pariye pidahan ignes ndahanwata. Nah kiyathaka awaku ku samah igkis ndahan. ");
INSERT INTO plu_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Kuri nah ka msakwa ay amadga inin akiw. Nah atak ta pimkanit. Igkisme msekwe ay amadga inin. Pa barewpitye, uyá apuriwgikis ndahan akak madikte pannu ku pariye pis kuwis ikí ta nupitit. Igkisnewa pikan nuthu. Apuriwnigkis kahadbe igkis pahapwiwa pawtak hawwata ke wisbe. ");
INSERT INTO plu_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ku samah nah aynete gikakkis ay amadga inin, nahnewa apuriwgikis akak ini pannu. Nah apuriwgikis madikte nukannuhnipwi ku pariye pikan nuthu. Yuma pahapwinama biyukne piw. Ignewa Judas Iskariyotis ku pariye ikaksaka adahanikwa biyukwiki iggi biyukenek kahadbe in kahayak ku samah pannasan awna. ");
INSERT INTO plu_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Kuri nah atak ta pimkanit. Ku samah nah ay amadga inin nah kuwis ekke inakni pinetni ta gitkis nuhiyegapu kahadbe igkis msakwa batek ganaktinkis hawwata ke nahbe. ");
INSERT INTO plu_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nah kuwis akki piwn ta gitkis kahadbe igkis kannuh wew akak pihiyakemni. Ayge nikwe nerras kane Uhokriyanpuma amedgenepwi inin igkis ka batek gikakkis. Mmanawa gihiyakemnikis ka patiptak gikakkis hawwata ku samah uhiyakemni ka patiptak gikakkis. ");
INSERT INTO plu_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Pa, nah ka piriyepkaw adahan pis giweptenkisma amadgatak inin. Henneme nah piriyepkaw adahan pis gikapriwtenkis adahan igkis ka isaksaw arit mbayka. ");
INSERT INTO plu_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Gihiyakemnikis ka patiptak gikakkis hiyeg kane Uhokriyanpuma amedgenepwi inin hawwata ku samah uhiyakemni ka patiptak gikakkis. ");
INSERT INTO plu_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Uyá barewbetha gihiyakemnikis akak hiyakemniki ku pariye inyerwatnene. Ini piwn innewa hiyakemniki ku pariye inyerwatnene. ");
INSERT INTO plu_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ku samah pis awahkisun atan amadgat inin nahme kuri awahkiswigkis hawwata muwwapu amadga inin adahan igikis ekkenes pihiyakemni gitkis hiyeg. ");
INSERT INTO plu_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Nah ikaw ta pit gidahankis kahadbe igkisme hawwata ikaw ta pit inyerwa. ");
INSERT INTO plu_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","―Pa, nah ka piriyepkaw gidahanwonasma nerras nukannuhnipwi. Nah piriyepkaw hawwata gidahankis ku pariye hiyeg aysawnemenek timepnepwi giwnkis ignes kamaxwa nupit hawwata akiw. ");
INSERT INTO plu_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nah piriyepkaw adahan igkis madikte humaw pahapwiwa pawtak hawwata ku samah nah pikak pis, Pa, wis pahapwiwa pawtak. Nah piriyepkaw adahan igkis hawwata pahapwiwa ukak kahadbe hiyeg kane Uhokriyanpuma amedgenepwi inin kahadbe ignes iha ku pisnewa ku pariye nawahkisten. ");
INSERT INTO plu_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Pa, kuwis pis ikí nukiythani. Kuri nahme ikí ini nukiythani ta gipititkis nuhiyegapu kahadbe igkis pahapwiwa pawtak hawwata ke wisbe. ");
INSERT INTO plu_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nahme pahapwiwa gikakkis. Pisme pahapwiwa nukakhu. Nah ikí gikiythanikis kahadbe igkis humaw inyerwa pahapwiwa pawtak. Kahadbe hiyeg kane Uhokriyanpuma amedgenepwi inin igkis hiyapni henne, igkis hiyakni ku pisnewa nawahkisten, kahadbe igkis hiyakni ku pis batek gikakkis hawwata ku samah pis batek nukakhu. ");
INSERT INTO plu_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Pa, nah muwaka nuhiyegapu ku pariye pikan nuthu nah muwaka igkis msakwa umun ku kiney wis msakwa kahadbe igkis hiyap ayge ku samah pis kiyathasan. Mmanawa pis batek nukakhu ku samah yumahte hawkri. ");
INSERT INTO plu_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Pa waditye, nerras kane Uhokriyanpuma amedgenepwi inin igkis ka hiyakpi. Henneme nah hiyaknap. Nerrasme nuhiyegapu ku pariye pikan nuthu igkis hiyakni ku pisnewa nawahkisten. ");
INSERT INTO plu_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nah kuwis akkap ku samah pihiyakemni gitkis. Aysawnemenek nah akkap gitkis akiwnek kahadbe igkis batekak pawtak hawwata ku samah pis batek nukakhu. Kahadbe igkis iwenes nuhiyakemnitnen nuwntak. ");
INSERT INTO plu_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Pisenwa inakni gipigyepkawni ig Kiyapwiye Jesus awna wothu gikannuhnipwi: ―Uyay atak atere amutripwit. Usuhme kaytwa giwn: ―Uyay. Usuh tipik manuke pahatra parewni makerepye kewye Sedroh. Ayge amutripwi. Atere usuh pareke. ");
INSERT INTO plu_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ig Judas Iskariyotismin, ner kamaykistinene Kiyapwiye Jesus, ig hiyak ku kiney ini iwetrit mmanawa ig Kiyapwiye Jesus gibetki atere ukakhu usuh gikannuhnipwi. ");
INSERT INTO plu_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ayge nikwe ig Judas Iskariyotismin danuh atere. Ig waxene pahabunad hiyegad atere. Nerras hiyeg igkis suwtat gikakkis muwpegpiyene gisandagmakis. Igkis iwatit gidahankis nerras muwpeg kiyatyepwi gidahankis nerras farisewkis. Igkis atere akak abukri akak ah kadawempiye akak giwahrakis. ");
INSERT INTO plu_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ig Kiyapwiye Jesus hiyapni henne, ig atere patiptakigkis. Ig kuwis hiyak madikte ku pariye danuhne gitmet. Ig danuh atere, ig awna gitkis: ―Pariye yipegpan? ");
INSERT INTO plu_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Igkisme kaytwa giwn: ―Jesus nazaréyene. Igme awna gitkis: ―Nahnewa ay. Ig Judas Iskariyotismin ner kamaykistinene Kiyapwiye Jesus ig tabir ayge gikakkis nerras hiyeg. ");
INSERT INTO plu_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Igkis timapni henne inakni giwn, “Nahnewa ay”, igkis ayguhwe, igkis tuguhbet waykboit. ");
INSERT INTO plu_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Pase igkis kannikewbet akiw ig ayaprikis akiw: ―Pariye yipegpan? Igkisme kaytwa giwn: ―Jesus nazaréyene. ");
INSERT INTO plu_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Igme awna gitkis: ―Kuwis nah ku awna yit: “Nahnewa ay.” Ku nah yipegpan, isaksanabay nukannuhnipwi ites tipikte. ");
INSERT INTO plu_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ig awna inakni henne kahadbe in kahayak ku samah giwn kaksa ku samah ig awna git Uhokri: “Nah ka biyuksa pahapwinama hiyeg ku pariye pikan nuthu.” ");
INSERT INTO plu_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Pahaye adahan ig kiyapwiye Simawh Pedru wiwhe giponyaga ku kakak ig ayta. Ig huwipwihe pahapwi ibukti gidahan ner muwpegpiyene gikiparakis. Giw Mawku. ");
INSERT INTO plu_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ig Kiyapwiye Jesus hiyapni henne, ig awna git Pedru: ―Paris piponyaga ta pibutikminat. Ka muwaka xuwahun giwkis. Adahanikwa ini mbeyne Nighu awahkisun. Mmah pipewkan nah ka amapin? ");
INSERT INTO plu_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ayteke nerras suwtat gikak gikiparakis gikakkis muwpegpiyene gisandagmakis igkis kamaxe Kiyapwiye Jesus. Igkis wanakmine giwan. ");
INSERT INTO plu_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ayteke igkis waxwig ta gipetunat amekene Anás. Atere kit igkis waxwig. Ig amekene Anás ig amekene Kayfás gimawhkig. Igme amekene Kayfás ig muwpegpiyene gikiparakis adahan ini peheknene kamukri. ");
INSERT INTO plu_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ignewa ku pariye amakohnokwa awna ku pi kabayte pahapwiwa awayg miyá mpinekata madikte hiyeg miyarap. ");
INSERT INTO plu_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ku samah nerras hiyeg waxenete Kiyapwiye Jesus ta gipetunat amekene Anás, ig kiyapwiye Simawh Pedru makeknene gihapukis butte. Nah João nah hawwata makeknene gihapukis. Igkisme hiyeg danuh atere amekene Anás gipin. Igkis pareke atere gipinbukut. Nah hawwata pareke aterewata. Ig muwpegpiyene gikiparakis ig nuhiyekten. Nikwe gihiyega isakse nah parak. ");
INSERT INTO plu_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Igme kiyapwiye Pedru msekwe aytonte aranwatak yar alappota kabaywaktak. Nah hiyapni henne, nah awna gut ku pariye apuriwkeputno lappot: ―Uyá isaksa nukebyi parakte hawwata. Henne eg paraksig. ");
INSERT INTO plu_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ayteke no tino apuriwkeputno lappot eg awna git kiyapwiye Pedru: ―Mmah ka pisnama hawwata ner awayg gikannuhni? Igme kaytwa guwn: ―Ka nawhnama. ");
INSERT INTO plu_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ayteke ig atak tabir ahumwa tiket. Nerras muwpeg gibukpig gikakkis gihiyegapu igkis hamah eggu tiket ayge mmanawa ayge kaayhsima kisepikri. Igkis tabirbet ayge awehewnikis. Igme kiyapwiye Pedru hawwata tabir atere awahpusewnata. ");
INSERT INTO plu_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Apimwata ini nerras muwpeg gisandagmapukis waxe Kiyapwiye Jesus ta gipetunat amekene Anás. Igme amekene Anás ig muwpegpiyene gikiparakis. Ayge ig ayapte Kiyapwiye Jesus. Ig ayapri: ―Pariyeki pikannuhnipwi? Pariyeki pinetni gitkis? ");
INSERT INTO plu_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Igme kaytwa giwn: ―Nah ka ayamawnama adahan nah kannuhhekne. Nah kannuhekne giwtrikneswa madikte hiyeg. Nah kannuhekne ku kiney judeyenepwi pahadgupu. Nah kannuhekne ayhté agiku leglis, ayhté agiku Uhokri Gipin. ");
INSERT INTO plu_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Mmahki pis ayapun amin nnetni gitkis hiyeg? Pis ka kis ayapun. Kiskama yis ayá hiyeg ku pariye timepnepwi nuwnhu amin ku pariye nnetni gitkis. Igkisnewa hiyak ku kamin nah kinetihwa. ");
INSERT INTO plu_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Pahapwi muwpeg gisandagma ayge gihumwa Kiyapwiye Jesus ig timani inakni giwn henne, ig biyuhpig. Ig awna git: ―Mmahki pis kaytwa giwn muwpegpiyene gikiparakis henne? ");
INSERT INTO plu_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Igme Kiyapwiye Jesus kaytwa giwn: ―Ku inakni nuwnhu ka kibeynema yuwit, uyá akki wothu. Henneme ku nah awna kibeyne yuwit, mmahki pis biyuhun nikwe? ");
INSERT INTO plu_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Igme amekene Anás hiyapni henne, ig ka hiyá gisamanak. Ayteke nikwe ig awahkiswig gidukwenewa mawanmine ta gimkanit ner muwpegpiyene gikiparakis pahapwiwa akiw kewye Kayfás. ");
INSERT INTO plu_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Apimwata ini kiyapwiye Simawh Pedru gidukwenewa tabirnene ayge kabaywak awahpusewne. Ayteke nikwe nerras hiyeg ayge awna git: ―Mmah ka ba pisnama gaytakkis ner awayg gikannuhnipwi? Igme wihwe giw Kiyapwiye Jesus. Ig awna: ―Ka nawhnama. ");
INSERT INTO plu_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ayteke pahapwi muwpegpiyene gikiparakis gibuk awna git kiyapwiye Pedru. Ig gikebyi ner awayg ku pariye kiyapwiye Pedru ihuke gitaybi. Ig awna git: ―Nah hiyapi ayhté amutripwi gikak ner awayg. ");
INSERT INTO plu_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Igme kiyapwiye Pedru wihwe giw Kiyapwiye Jesus akiw. Nikwenéwa pahapwi takarak awna. ");
INSERT INTO plu_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ayteke ariwnteke ini kibeyweke nerras muwpegpiyene gisandagmapukis waxe Kiyapwiye Jesus agikutak amekene Kayfás gipin. Igkis waxwig ta gipinwat ner hiyaptigi romayene. Henneme igkis ka parak atere gipinekut. Mmanawa igkis ka hiyá igkisma pasamrak akak hiyeg romayene abet gipetrakis. Waké igkis pasamrekwiye gikakbe, gitkiskam igkis patehwepye. Nikwekam ka ikkam adahan igkis fetya. ");
INSERT INTO plu_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ayteke ig ner hiyaptigi romayene pes gipetunatkis. Giw Pilatus. Ig awna gitkis: ―Kapatraki yis kamiye ner awayg? ");
INSERT INTO plu_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Igkisme awna git: ―Waké ig ka kakehniyema, usuh ka waxrikam ta pipetunat. Amawka pis hiyak gikak. Amawka pis umahkiswig. ");
INSERT INTO plu_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Igme amekene Pilatus timapni henne, ig awna gitkis: ―Yiswa hiyak gikak. Iwapnig. Hiyaknabay gikak ku samah yis hiyeg judeyenepwi yihiyakemni. Igkisme kaytwa giwn: ―Kawa. Usuh muwaka ig umehpika. Minikwak usuh hiyeg judeyenepwi padakte kakehniye akak tip. Henneme kuri yis romayenepwi yikumadukan ka isaksa usuh judeyenepwi adahan usuh umahkis hiyeg kakehniye. Amawka piswa umahkiswig. Hennewatbaki igkis awna. ");
INSERT INTO plu_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Inneki keh in kahayak ku samah Kiyapwiye Jesus awna ku ig miyá amin giyakninek. ");
INSERT INTO plu_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ig amekene Pilatus timapni inakni giwnkis henne, ig pareke ta gipinekut akiw. Ig iwapkis Kiyapwiye Jesus ta gitiput. Igme danuh atere, igme awna git: ―Mmah pis hiyeg judeyenepwi gikiparakis? ");
INSERT INTO plu_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Igme Kiyapwiye Jesus awna git: ―Kitak pis utí inakni yuwit? Ba piwnteknewatma ba kawk ba giwntakkisma nawenépwi hiyeg? ");
INSERT INTO plu_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Igme amekene Pilatus kaytwa giwn: ―Mmahki nah ayapi nuwnteknewa? Nah ka judeyenema. Inakni giwntakkis piyakipwi judeyenepwi. Nerras muwpeg kiyatyepwi igkisnewa ikepi ta nuwakuit. Pariyeki pikehni gikakkis? ");
INSERT INTO plu_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Igme kaytwa giwn: ―Nahnewa gikiparakis henneme nah ka kema ikiparat amedgenema inin. Waké nah gikiparakis ke ikiparatbe amedgene inin, nikwekam nuhiyegapu keryekiskam adahan nah ka kamaxka gapitkis judeyenepwi gimuwpegakis. Henneme nukumadukan ka ariwntakma inin hawkri. ");
INSERT INTO plu_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ig amekene Pilatus timapni henne, ig awna: ―Mmah pis pahapwi ikiparat nikwe? Igme Kiyapwiye Jesus kaytwa giwn: ―Hennewa ku samah pis awna. Nah waypuka amadgat inin adahan nah humaw hiyeg gikiparakis. Nah ayta amadgat inin adahan nah ekkene hiyakemniki ku pariye inyerwatnene. Madikte hiyeg ku pariye batekye akak hiyakemniki ku pariye inyerwatnene, ignes timap nuwnhu. ");
INSERT INTO plu_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ig amekene Pilatus timapni henne, ig awna: ―Pariyepahki ini hiyakemniki inyerwatnene? Pisenwa gawnhan inakni yuwit, ig pes akiw ta gipetunatkis nerras judeyenepwi giwewkistenkis. Ig danuh atere, ig awna gitkis: ―Nah ka utí mbaynama gikehni. Ku apim inin yis fetya adahan kiyene ku samah minikwak Uhokri wiwhkiswiye yahawkripwi giwakutakkis hiyeg ejituyenepwi. ");
INSERT INTO plu_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Mpuse yipetra henne yis yibetki adahan nah isahkis apim ini pahapwi awayg ku pariye paraksepkare. Ba yis muwaka nah isahkis ner ikawparinene yikipara judeyenepwi? ");
INSERT INTO plu_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Igkisme timapni henne, igkis madikte kabiman git: ―Kawa. Ka ignama. Uyá isahkis udahan Bahabás. Hennewatbaki igkis kabiman. Ig Bahabás ig amepye. ");
INSERT INTO plu_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ayge nikwe ig amekene Pilatus iwapkise Kiyapwiye Jesus. Ig biyuhkiswig akak tigay ta gitkis gisuwtatapu. ");
INSERT INTO plu_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Apim ini gisuwtatapu awna: ―Uyay arehwa gikak. Uyay kawihkis gikawihni ta gipitit kewa ukiparawiybe ku samah ig kawih dagam duruweh akak gisuwpren karukri wahano. Ayteke nikwe igkis imepe puduku, igkis keh gisuwpren nikak. Igkis kawihkisni ta gitewharit. Igkis kadagmanepri akak pahak dagam duruweh. ");
INSERT INTO plu_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ayteke igkis mahipwihpig. Igkis awna git: ―Aa kiyapwiyad, kibeyne pis ay kuri. Pis judeyenepwi gikiparadkis. Akak ini igkis biyuhbokepri. ");
INSERT INTO plu_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pisenwa nikwe ig amekene Pilatus pes ta gipetunatkis nerras hiyeg akiw. Ig awna gitkis: ―Ipegnay ayta. Kuri nah waxwasepri ayta yipetunat adahan yis hiyakni ku nah ka utí ariknawnama gikehni mbay. Ka kis adahan nah umahkisri. ");
INSERT INTO plu_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ig Kiyapwiye Jesus pes atere. Gisuwpren puduku ay gitewha. Ig kadagmanpit akak gidagmanpit duruweh. Ayteke nikwe ig amekene Pilatus awna ta gitkis hiyeg: ―Ipegnay gimkat ner awayg. Akayih. Ikeypi kuri yis hiyapkis mbeyne git. ");
INSERT INTO plu_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Igkisme muwpeg kiyatyepwi gikakkis gisandagmapukis igkis hiyapni henne, igkis kaytwa giwn: ―Uyá daddahkiswig udahan! Uyá daddahkiswig! Igme amekene Pilatus kaytwa giwnkis: ―Yiswa iwapri. Yiswa daddahgi. Mmanawa nah ka utí ariknawnama gikehni mbay. ");
INSERT INTO plu_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Igkisme judeyenepwi giwewkistenkis kaytwa giwn: ―Usuh judeyenepwi kadahan ukumadukan. Inakni ukumadukan awna ku amawka ig umehpika apatra ku samah ig ikawparinene ku ignewa Uhokri gikamkayh. ");
INSERT INTO plu_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Igme amekene Pilatus timapni henne ku ig ikewne Uhokri gikamkayh, ig apisasew kaayhsima akiw. ");
INSERT INTO plu_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ayteke nikwe ig pareke ta gipinekut akiw. Ig iwapkis Kiyapwiye Jesus atere. Ayteke ig awna git: ―Pariyenekap? Igme Kiyapwiye Jesus ka kaytwa giwn. ");
INSERT INTO plu_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ig amekene Pilatus hiyapni henne, ig awna git: ―Mmahki pis ka kaytwa nuwnhu? Ka ba pis hiyaknima ku nah kadahan ndatni adahan pisahkiswitni, nah hawwata kadahan ndatni adahan pidaddahkiswitni? ");
INSERT INTO plu_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Igme Kiyapwiye Jesus awna git: ―Igwa Uhokri inugikyene ikí pit ini pidatni. Nikwe ner ku pariye ikepun ta piwakuit iggi gitaraksan pi kiyeste ariw pitaraksan mmanawa ig yuma gidatni giwntak Uhokri adahan ig nukepten piwakuit. ");
INSERT INTO plu_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ayteke ariwntak inakni giwn, ig amekene Pilatus ipegminene gihiyakemni adahan ig hiyak ku samahpa ig isahkiswig ariw ini. Henneme nerras judeyenepwi giwewkistenkis ka isaksig. Ku aysaw ig diyuh ta gipetunatkis igkis kabimanape git. Igkis awna: ―Ku pis isahkiswig, nikwe in arakak ku pis ka batek gikak pikipara kiyapwiye Sésar. Mmanawa ku pahapwi ikaw hiyeg gikiparakis, amun ini nikwe ig siguhne kiyapwiye Sésar. Ku pis isaksa Jesus ikaw hiyeg gikiparakis, nikwe kiyapwiye Sésar dagawne pitnek. ");
INSERT INTO plu_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ig amekene Pilatus timapni henne, ig pes ta amadgat ini iwetrit kewye “Tippahaki”. Inakni giwnaprikkis judeyenepwi kewye “Gábata”. Ig batahkiswa atere amadgat gepwi adahan ku kiney ig hiyekne gikakkis hiyeg. ");
INSERT INTO plu_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ayteke nikwe ig awna ta gitkis nerras muwpeg kiyatyepwi. Giwn: ―Ipegnay gimkat ner yikipara. Ig awna inakni kabá puwip kamuw abet ini hawkri ku kabet hiyeg judeyenepwi umah muttuhyan adahan igkis ahegbetewnes adahan gipetrakis adahan kiyene ku samah minikwak Uhokri umahkis muttuhyan gidukwenaprikkis amekenegben kahadbe ig giwiwhkiswitnikis giwakutakis hiyeg ejituyenepwi. ");
INSERT INTO plu_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Igkisme timapni henne, igkis kabiman git: ―Ka ba isahkisri! Daddahkisnig! Igme amekene Pilatus awna gitkis: ―Mmah yis muwaka nah daddahkis yikipara? Igkisme muwpeg kiyatyepwi kaytwa giwn: ―Ignewa kiyapwiye Sésar ukipara. ");
INSERT INTO plu_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Igme timapni henne, ayge nikwe ig matiwniswe. Ig ikepri ta giwakuitkis gisuwtatapu adahan igkisme gideddehpitni. Ayteke nikwe igkis iwepri igkis hiyuhkise giyakni git. ");
INSERT INTO plu_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ayteke ig Kiyapwiye Jesus hiyuhwe akak giyakni, ig tipikepka apititak ini paytwempu ta apitit pahá waxri imuhgipitnene kewye “Waxri Hiyeg Gaptiwpitwiye”. Inakni giwnaprikkis judeyenepwi kewye “Gówgota”. ");
INSERT INTO plu_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Igkis danuh atere, ayge igkis deddehpig ta aminat giyakni. Igkis tabirasepri ay giyegbikis piyana gikebyikis awaykemni. Igkisme amin giyaknikis ayge gihumwa, igme pakwa giyegbikis. ");
INSERT INTO plu_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ayteke ig amekene Pilatus tamakse pahak kagta adahan arekhetni ku pariye gikehnitnene ta gitkis hiyeg. Ig daddahkiswin ta aminat Kiyapwiye Jesus giyakni. Amadgatak ini kagta awna: “Ig Jesus Nazaréyene Ig Judeyenepwi Gikiparakis”. ");
INSERT INTO plu_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ini waxri imuhgipitnene ku kiney Kiyapwiye Jesus deddehpika in kennesa arimkat paytwempu Jerusalém. Ayge nikwe kaayhsima hiyeg danuh atere, ignes ipegboha ini kagta. In tamakka giwnaprikkis mpana gikebyikis hiyegpiyenepwi judeyenepwi giwnaprikkis, romayenepwi giwnaprikkis, grésiyenepwi giwnaprikkis. ");
INSERT INTO plu_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Nerras muwpeg kiyatyepwi hiyapni henne, igkis awna git amekene Pilatus: ―Ka muwaka tamakkis henne ku ig judeyenepwi gikiparakis. Ka ignama. Uyá tamak ku ig he ikawparinen ku ig judeyenepwi gikiparakis. ");
INSERT INTO plu_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Igme amekene Pilatus kaytwa giwnkis: ―Ku pariye nah tamakkise hennewa in msekwe kuri. ");
INSERT INTO plu_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Nerras suwtat pisenwa gidaddahnikis, igkis iwé Kiyapwiye Jesus gikawihni. Igkis ibekhepni pawtak mpuse gipuriwkis nerras paxniknene gikebyikis suwtat. Gisimsanen msekwe. In yuma nipodrak. In kehka he kamisnen. ");
INSERT INTO plu_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Igkis hiyapni henne, igkis kinetihwa pawtak. Igkis awna: ―Uyay ka sigkebdihni. Uyay arehwa akak tip adahan wixwiy hiyá ku pariye kabunuganen iggi adarihpitni. Ayge nikwe igkis arehwa akak tip. Igkis kehne henne, metakwa in kahayak ku samah Uhokri gannasan minikweknene awna. In awna: “Igkis ibekhe nukawihni pawtak. Igkis arehwa akak tip adahan hiyá ku pariye kabunuganen iggi darihpiye nsimsa.” Hennewatbaki ig Uhokri gannasan awna. ");
INSERT INTO plu_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ayge tinogben tabirbet kennesa gihumwa Kiyapwiye Jesus giyakni. Ginag tabir ayge payak gukak gusamru, gukak pahapuwa kiyapuno Mahi akiw ku pariye kiyapwiye Kilopas gihayo, gukak kiyapuno Mahi Madalena. ");
INSERT INTO plu_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ig Kiyapwiye Jesus hiyá ginag tabir ayge. Ig hiyapun nah João hawwata nah ayge kennesa guhumwa. Ayge nikwe ig apuriwkis usuh pawtak. Ig awna gut ginag: ―Kiyapuno, ig ner humaw nuwenyan hawwata ke pikamkayhbe. ");
INSERT INTO plu_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ayteke ig awna nuthu: ―João, no humaw pinag kuri. Ariwntak ini nah amapig adahan eg msakwa ay nupineku. ");
INSERT INTO plu_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Pisenwa inakni giwn, Kiyapwiye Jesus hiyakni ku gannipwi amadga inin kuwis pisenwa. Ayteke ig awna: ―Nah arabyu un. Ig awna inakni henne kahadbe in kahayak ku samah Uhokri gannasan minikweknene kinetihwa gimin. ");
INSERT INTO plu_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ayge pahá atiy kipun akak win suwiyweye. Igkis hiyeg ayge igkis hiyapni henne, igkis iwé pahá arikna ku pariye mtibetnene. Igkis subukwin ahakwat ini win adahan anugasene. Igkis iké akisugik pahat ahesa kewye “isoppu”. Pisenwa igkis tarekwin ta gibiygikut Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Igme amapin. Ayteke ig awna: ―Madikte ku pariye gimawkanitnene nawahkisten in kuwis pisenwa. Ayge ig kuwigihwe gitew. Giyakek madike. Ig miyap. ");
INSERT INTO plu_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ayge nikwe kennesa adawnhan samdi. Nerras judeyenepwi giwewkistenkis hiyapni henne, igkis atak ta git amekene Pilatus. Igkis danuh atere, igkis awna git: ―Dunihkispinaba gibagwankis nerras awaykemni aminene giyaknikis adahan iwawha gimiremnikis kahadbe igkis wiwhpika aminatak giyaknikis apit samdi danuh. Igkis awna inakni henne awaku igkis ka muwaka gipitkis msakwa ay amin giyaknikis abet samdi. Mmanawa ini samdi apitmin madikte hawkri adahan gipetrakis. Igme amekene Pilatus ihe giwnkis. ");
INSERT INTO plu_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ayteke nikwe gisuwtatapu piyana gikebyikis tipik danuh atere ku kiney igkis awaykemni daddahka. Igkis dunihe gibagwan ner pitatye awayg. Ayteke igkis dunihe gibagwan ner ku pariye daddahka payak gikak. ");
INSERT INTO plu_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Henneme ku aysaw igkis danuh ta git Kiyapwiye Jesus adahan giduhnepten, ayge igkis hiyapri ayipa gimiremni kuwis. Igkis hiyapni henne, igkis ka dunih gibagwan. ");
INSERT INTO plu_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Henneme pahapwi gaytakkis digiswig gimuhrik akak pahat “lans” kurumri. Migat akak un pes ayteke. ");
INSERT INTO plu_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nah João ekkene yit ku pariye nah hiyá akakwa nuwtyak. Nah ekkene yit inetit ku pariye inyerwatnene. Nah hiyakni ku in inyerwa. Nah akkin yit kahadbe yis kamaxwa ta gipitit Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ini ku samah gibagwan ka dunihka in kahayak hawwata ku samah Uhokri gannasan minikweknene kinetihwa gimin ig muttuhyan ku pariye umehpika gidukwenaprikkis hiyeg. In awna: “Yuma pahatnama gipit dunihkanek.” ");
INSERT INTO plu_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Inme ku samah ig digiswika akak lans in hawwata kahayak ku samah gannasan kinetihwa amadgatak nawenéwa iwetrit. In awna: “Igkis ipeg ta gimkanit ner ku pariye gidigsankis.” ");
INSERT INTO plu_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ariwnteke ini pahapwi awayg giw José arimatéyene danuh atere. Ig pahapwi gaytakkis Kiyapwiye Jesus gikannuhnipwi henneme ig ka akkaw awaku ig apis gibohrikis nerras judeyenepwi giwewkistenkis. Ig hiyapni henne ku samah ayipa gimiremni, ig tipik danuh atere git amekene Pilatus. Ig awna ta git: ―Kiyapwiye, uyá amnihun isaksan adahan nah atere iwepye amekenemni Jesusmin gipit. Igme amekene Pilatus kaytwa giwn: ―Bariká. Iwepnika. Ig kiyapwiye José timapni henne, ig tipik wiwhpiye Kiyapwiye Jesus gipit aminatak giyakni. ");
INSERT INTO plu_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Igme ner kiyapwiye Nikodémus ku pariye minikwak danuh git Kiyapwiye Jesus tiyegim, ig atere gihapti kiyapwiye José arimatéyene. Ig ewk pohowku madikwa (50) ahehtet ah amar kuwkwaki kewye “miha” akak ah adidkan kuwkwaki kewye “aloés”. ");
INSERT INTO plu_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Igkis danuh atere, igkis wiwhe Kiyapwiye Jesus gipit aminatak giyakni. Igkis wanakminepri akak kamis seyne barewbetye payak akak ini ah amar kuwkwaki adahan gimihetni ku samah hiyeg judeyenepwi gihiyakemnikis. ");
INSERT INTO plu_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Pahayku amutripwi ayge kennesa arimkat ku kiney Kiyapwiye Jesus deddehpika. Ayge amutripwi pahayku imewti nukune ku pariye kote kawihkahte. ");
INSERT INTO plu_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Igkis hiyapni henne, igkis awna: ―Ini imewti kennesa. Uyay iwawhaw sarayh gipit atere, mmanawa amawka ku wis barewpithaw apit samdi danuh. Atere igkis sarayhe Kiyapwiye Jesus gipit. ");
INSERT INTO plu_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ayteke paka abet kabeyweke msanpew kapwihte eg kiyapuno Mahi Madalena danuh atere arit Kiyapwiye Jesus gimew. Ayge eg hiyá gimew asabwat ayipa wokepka. ");
INSERT INTO plu_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Eg hiyapni henne, eg sigise eg danuh ta git kiyapwiye Simawh Pedru. Nah João ayge gikak. Eg awna ta wothu: ―Igkis wiwhe Ukiparawiy agikutak gimew. Usuh ka hiyak ku kite igkis sarayhpig. ");
INSERT INTO plu_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ig kiyapwiye Pedru timapni henne, ig tipik atere. Nah hawwata tipigwata. Usuh atere iwasene gimew. ");
INSERT INTO plu_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Usuh piyamate sigise atere. Nah pi sigiste giw kiyapwiye Pedru. Nah kit danuh giw. ");
INSERT INTO plu_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Nah darakaw nah iwasa atere, nah hiyá Kiyapwiye Jesus gidagmanpit kihubete agiku gimew. Henneme nah ka parak atere. ");
INSERT INTO plu_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Igme kiyapwiye Pedru danuh nuhapuh butte akak giparakan. Ayge ig hiyá gidagmanpit kihubete ");
INSERT INTO plu_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","payak akak giwanratiw. Henneme ini giwanratiw ka kennesnima arimkat gidagmanpit. In kahimuke aparayewa niw. ");
INSERT INTO plu_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Nah hawwata ku pariye kit danuh nah pareke atere butte. Nah iwasa yumahe gipit ayge. Ayge nah ihe ku ig Kiyapwiye Jesus kuwis kannikew. ");
INSERT INTO plu_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Mmanawa apit ini usuh kote pukuhpate ini Uhokri gannasan minikweknene ku samah in awna ku amawka ig kannikaw ariw gimiremni. ");
INSERT INTO plu_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ayteke pisenwa usuh tipik ta upinekut. ");
INSERT INTO plu_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Egme kiyapuno Mahi Madalena danuh atere ku kiney ig sarayhpika, eg tabir ayge ahumwa gimew. Eg tihano ayge. Eg tihano, eg darakaw. Eg iwasa ta agikut gimew. ");
INSERT INTO plu_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ayge eg hiyá piyana gikebyikis ahj kasimsapuwape seyne. Igkis batabdawak pahapwi gitiwhaptak pahapwime gikataptak ku kiney Kiyapwiye Jesus gidukwen. ");
INSERT INTO plu_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Igkis awna ta gut: ―Kiyapuno, mmahki pis tihapu ayge? Egme kaytwa giwnkis: ―Awaku igkis iwé nukipara. Nah ka hiyak ku kit igkis sarayhpig. ");
INSERT INTO plu_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Eg awna inakni eg wagestaw eg hiyá Kiyapwiye Jesus ayge henneme eg ka hiyakriwa ba Jesusma ig. ");
INSERT INTO plu_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ayge ig awna ta gut: ―Kiyapuno, mmahki pis tihapu ayge? Pariye pipegpan? Egme gupewkankam ku ig amutri akapriwtenkam. Eg awna git: ―Kiyapwiye, ku pis iwepri, uyá akki nuthu ku kit pis sarayhpig kahadbe nah tahhan iwepri. ");
INSERT INTO plu_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Igme Kiyapwiye Jesus kanum guw. ―Mahi. Eg timapni henne eg wagestaw. Eg murotpi git. Eg awna guwnaprik: ―“Rabôni”. Inakni wownaprikwiy “Kiyapwiye nukannuhten.” ");
INSERT INTO plu_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Igme awna ta gut: ―Ka ba mpithan mmanawa nah kote wagahte ta git Nighu. Su ta gitkis nukebyupwi. Uyá akki gitkis ku nah me wagehe ta git Nighu ta gitwata Yig, ta git nuwohkiga, ta gitwata yiwohkiga. ");
INSERT INTO plu_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Eg timapni henne eg tipik ayta wothu. Eg danuh ta wothu, eg awna: ―Nah kuwis hiyá Ukiparawiy. Ayge eg akki wothu inakni ku pariye Kiyapwiye giwn gut. ");
INSERT INTO plu_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Abetnewa ini hawkri paka aygete usuh gikannuhnipwi pahadgupu agiku pahaykunene xam. Alappota sabutip mmanawa usuh apise gibohrikis nerras judeyenepwi giwewkistenkis. Pahaye adahan Kiyapwiye Jesus hiyapkiswe tabir ayge ubethu. Ig awna ta wothu: ―Uhokri gabay yikaknek. ");
INSERT INTO plu_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ig awna henne, ig ekke wothu giwak akak gimuhri. Ayge usuh bateke unaktin kaayhsima ku samah usuh hiyá Ukipara akiw. ");
INSERT INTO plu_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Igme awna ta wothu akiw: ―Ka yi muwaka kiyimwihwa apit yiyakni. Ku samah Nighu kuwis awahkiswen, nah hawwata nah awahkisweynek. ");
INSERT INTO plu_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ig awna henne, ig puh ta upitit. Ig awna wothu: ―Amapanay Uhokri Gitip. ");
INSERT INTO plu_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Kuri hiyawa yis awna gitkis hiyeg nuwntakwa. Ku aysaw yis akki gitkis ku Uhokri bayahminigkis ariw gitaraksankis, ayge nikwe igkis bayahminapka. Ku aysaw yis akki gitkis hiyeg ku Uhokri ka bayahminigkis ariw gitaraksankis, ayge nikwe igkis ka bayahminaka. ");
INSERT INTO plu_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Henneki ig Kiyapwiye Jesus hiyapkiswa wothu. Henneme pahapwi waytakhu usuh giwatnipwi kewye Tomé Abes ig ka hiyapri mmanawa ig yuma ayge apim ini ku aysaw Kiyapwiye Jesus hiyapkiswa wothu. ");
INSERT INTO plu_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ayteke nikwe usuh atere akki git. Usuh danuh atere, usuh awna git: ―Usuh kuwis hiyá Ukiparawiy. Ig kuwis kannikew akiw. Igme kaytwa wown: ―Nah ka iha inakni. Ku ka nahwatma hiyá akakwa nuwtyak ini pudubdu adukwen giwaku, ku ka nahwatma idis nuwakhu ta agikut ini pudubdu adukwen, ku ka nahwatma idis nuwaku ta gimuhrikut, nikwe nah ka iha inakni yiwn aynesnima ku ig kannikew. ");
INSERT INTO plu_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ayteke ariwnteke ini adahan pahay paka akiw usuh pahadgupu agiku payt akiw. Ig kiyapwiye Tomé ayge ukakhu. Pahaye adahan, lappot sabutip, ig Kiyapwiye Jesus hiyapkiswe wothu akiw. Ig tabir ayge ubethu. Ig awna: ―Uhokri gabay yikaknek. ");
INSERT INTO plu_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ayge ig awna ta git kiyapwiye Tomé: ―Ipeg nuwakuit. Hiyawa pis uduk piwak atere kuri. Hiyawa pis uduk piwak atan numuhgikut hawwata akiw. Ka muwaka tuguhkis pikamaxwan. Kamaxwanaba ta nupitit. ");
INSERT INTO plu_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ig kiyapwiye Tomé hiyapni henne, ig awna git: ―Kiyapwiye, pisnewa nukipara. Pisnewa nuwohkiga. ");
INSERT INTO plu_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ayteke ig Kiyapwiye Jesus awna git: ―Tomé, pis kamaxwa nupitit awaku ku samah pis hiyapun. Henneme ignes ku pariye kane hiyapun igkis kamaxwa ta nupitit, ini gikamaxwankis pi kabayte mpiya pidahan. Aysawnemenek igkis utí kaayhsima kabaykanek. ");
INSERT INTO plu_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ig Kiyapwiye Jesus keh kaayhsima annut akiw ay wowtrik usuh gikannuhnipwi. Nah ka akkin madiktema amadgatak inin karta. ");
INSERT INTO plu_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Henneme nah anniri inakni yuwit ku pariye nanhan kahadbe yis iha ku ig Kiyapwiye Jesus ignewa Cristo, ig Uhokri gikanyan adahan ukumaduketniwiy. Kahadbe yis iha ku ignewa Uhokri gikamkayh. Ku yis kamaxwa ta gipitit, yis aymuhwanek gimun Uhokri adahan apanenekwa. ");
INSERT INTO plu_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ariwnteke ini ig Kiyapwiye Jesus hiyapkiswe wothu usuh gikannuhnipwi akiw ayge akigbimna mahakwa kewye Tiberíyades. Nah akkite yit ku samah ig hiyapkiswa wothu. ");
INSERT INTO plu_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Usuh pahadgupu ayge. Ig kiyapwiye Simawh Pedru ayge ukakhu. Ig kiyapwiye Tomé Abes aygwata ukakhu. Ig kiyapwiye Natanael kanayene galiléyene ig aygwata ukakhu. Hawwata usuh piyana ukebyi amekene Zebedew gikamkayupwi usuh aygwata gikakkis. Piyana gikebyikis nawenépwi gikannuhnipwi ayge hawwata. ");
INSERT INTO plu_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ayteke nikwe ig kiyapwiye Simawh Pedru awna ta wothu: ―Nah atakte subukminate. Usuhme kaytwa giwn: ―Usuh ataka pihapti. Usuh tipik gihapti. Usuh sarayhwa ta amadgat umuh. Usuh subukminene hewke tiyegim. Kameki usuh kakamaxnime im pahapwinama. ");
INSERT INTO plu_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Kabeyweke ig Kiyapwiye Jesus hiyapkiswe tabir akigbimna mahakwa. Henneme usuh ka hiyakriwa ba ignama Jesusma. ");
INSERT INTO plu_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ig kabiman wothu: ―Kamahad, ba yis kawin? ―Yuma. ");
INSERT INTO plu_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","―Subuknabay yitagmaya kihehaptak han pawkat. Ayge yis kawinnek. ―Ihkata nikwe. Usuh subukmine utagmaya atere. Ayge nikwe usuh kakamaxni kaayhsima im. Kabahte usuh ka hiyá akahminak utagmaya. ");
INSERT INTO plu_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Nah hiyapni henne, nah awna git kiyapwiye Pedru: ―Ig ner Ukiparawiy. Ig kiyapwiye Simawh Pedru timapni henne ku ig Ukiparawiy, aynewa ig kawih gidagmanpit, mmanawa ig masimsa. Ig kawih gidagmanpit akak gitubkan gimkanit. ");
INSERT INTO plu_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Usuhme atere amadga wahmun mmanawa usuh kennesa ihapkat. Muwaka adahan pohowku madikwa (50) iwanti adahan danuh atere. ");
INSERT INTO plu_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Usuh danuh atere, usuh sarayhwa waxrimpakat. Ayge nikwe usuh utí tiket amey akak im ayge nibet ariwtrik eggu tiket. Bugut hawwata aygwata ahumwa. ");
INSERT INTO plu_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ayteke ig Kiyapwiye Jesus awna wothu: ―Iwinay ariwntak yiwin. ");
INSERT INTO plu_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ig kiyapwiye Simawh Pedru timapni henne, ig sarayhwa amadgat umuh. Ig kehe utagmaya waxrimpakat kipun akak nopsadmin im. Madikawku madikwa gikebyikis akak pohowku madikwa akak mpana gawnakis (153). Im kaayhsima kameki utagmaya sigkame. ");
INSERT INTO plu_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Pisenwa nikwe ig Kiyapwiye Jesus awna wothu: ―Barubakay ax. ―Ahadye. Yuma pahapwinama waytak kibowkaye ayapri ku pariyene ig awaku usuh hiyaknig ku ig Ukipara. ");
INSERT INTO plu_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Igme Kiyapwiye Jesus atere ganwat tiket, ig iwé bugut ig ikepni wothu. Hawwata ig iké wothu im. Usuhme axni. ");
INSERT INTO plu_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ini amamnaput ig Kiyapwiye Jesus hiyapkiswa ta wothu ariwntak gikankawni ariw gimiremni. ");
INSERT INTO plu_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Pisenwa waxni ig Kiyapwiye Jesus kinetihwa gikak kiyapwiye Simawh Pedru. Ig ayapri: ―Simawh, pis ku pariye kiyapwiye João gikamkayh, ba pis batek nukakhu mpiya madikte amadga inin? Igme kiyapwiye Pedru kaytwa giwn: ―Ihi, Kiyapwiye. Pis hiyakni ku nah batek pikak. Igme awna git: ―Ikapnaba ndahan nupigyanpu muttuhpiyene. Akkanaba nuwnhu ta gitkis nuhiyegapu ku pariye kotenene pukuhpate nuhiyakemni kabayhtiwatma. ");
INSERT INTO plu_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ayteke nikwe ig awna git apeynipye akiw. Giwn: ―Simawh, pis ku pariye kiyapwiye João gikamkayh, ba pis batek nukakhu? Igme kaytwa giwn akiw: ―Ihi, Kiyapwiye. Pis hiyakni ku nah batek pikak. Igme awna git: ―Apuriwnaba ndahan nupigyanpuisa muttuhpiyene nerras ku pariye kamaxwenepwi ta nupitit. ");
INSERT INTO plu_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ayteke nikwe ig ayapri amamnaputne akiw: ―Simawh, pis ku pariye kiyapwiye João gikamkayh, ba pis batek nukakhu? Igme kiyapwiye Pedru kapusa barukiswe ayge awaku ku samah ig Kiyapwiye Jesus ayapri amamnaput akiw ba ig batekwatma gikak. Ig kaytwa giwn akiw: ―Kiyapwiye, pis hiyak madikte. Pis hiyakni ku nah batek pikak. Igme Kiyapwiye Jesus awna git: ―Ikapnaba ndahan nupigyanpuisa muttuhpiyene akak nuhiyakemni. ");
INSERT INTO plu_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ayteke ig awna git akiw. Giwn: ―Kuri nah ikí pinetni. Minikwak pis takwayete pis kawih pisimsa pis wew ku kit pimawkan. Henneme aysawnemenek pis kiyapwinek pis isaksanek nawenépwi hiyeg adahan igkis keh gimawkankis pikak. Pis taraknek piwak adahan igkis kawihkis pisimsa adahan igkis piwaxepten ku kit pis ka atekkere. ");
INSERT INTO plu_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ig awna inakni henne, ig ekkene git ku samah aysawnemenek igme umahkiswe giwnteknewa gidahan Uhokri gikiythani. Pisenwa gawnhan inakni yuwit ig awna git: ―Ikawnaba hawwata ke nahbe. ");
INSERT INTO plu_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ayteke ig kiyapwiye Pedru wagestaw, ig hiyá pahapwiwa Jesus gikannuhni ig waywe gihapu. Igme ner ku pariye Kiyapwiye Jesus batek gikak kaayhsima ku pariye kuhwekwa betnene gihumwa Kiyapwiye Jesus ayge aranwa axtet, ig ayapri amin ku pariye gikamaykiswitni. ");
INSERT INTO plu_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ig kiyapwiye Pedru hiyapri ayge, ig ayá Kiyapwiye Jesus: ―Kiyapwiye, ya ner? Pariyeki danuhne gitnek? ");
INSERT INTO plu_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Igme Kiyapwiye Jesus kaytwa giwn: ―Ka hiyá pisma hiyak nikak. Ku nahwa muwakapri ig msekwe ay nekwa ku aysaw nah diyuhnek akiw, ka hiyá pisma hiyak nikak. Pisnewa hiyak akak ku pis ikaw hawwata ke nahbe. ");
INSERT INTO plu_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ariwnteke ini, inetit ibekhewpi gipuriwkis ukebyupwiy gimin ner gikannuhni ku ig ka miyati. Kameki Kiyapwiye Jesus awname ku ig ka miyati. Ig he awna: “Ku nahwa muwakapri ig msekwe ay nekwa ku aysaw nah diyuhnek akiw, ka hiyá pisma hiyak nikak.” ");
INSERT INTO plu_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Nah João ku pariye ekkene inakni inetit yit, ku pariye anniri inakni yuwit, nahnewa ner gikannuhni. Yis hiyakni ku inakni nnetni inyerwa. ");
INSERT INTO plu_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ig Kiyapwiye Jesus keh kaayhsima annut akiw henneme nah ka anniri madiktema. Waké in annakekwiye amadga kagta, in humaw kaayhsima kagtakam. Nupewkan in ka kapitkam ay amadga inin hawkri pahakte.");
INSERT INTO plu_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Kiyapwiye Teófilu, nah Lúkas awahkis inin kagta pimin. Amakohnokwa nah awahkis pahakwa kagta pimin akiw. Amadga inere pitatye kagta nah kuwis akki pit madikte Kiyapwiye Jesus gikehnitnen madikte ginetni ku samah ig aynete amadga inin ");
INSERT INTO plu_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","juktah ku aysaw ig iwepka ta inugikut. Nah kuwis akki pit ku samah apit giwepni ig iké gannipwi ta giwakuitkis giwatnipwi gikanyanpu. Ig ayge ikene gihiyakemnikis akak Uhokri Gitip gannu ay gipit. Pisenwa ig iwepka inugikut. ");
INSERT INTO plu_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Kuwis nah akki pit inakni madikte. Minikwak ku aysaw ig Kiyapwiye Jesus ay amadga inin, ig miyap, ig kannikaw akiw. Ayteke ig hiyapkiswa ta gitkis giwatnipwi kibereput. Apim ini ig ekkene kaayhsima gannu gitkis kahadbe igkis hiyak kabayhtiwa ku ig inyerwa ipeg akiw. Ig hiyapkiswa ta gitkis adahan pahapwi kayg akak abusku. Akakwa giwtyakkis igkis hiyapri. Apim ini ig kinetihwene gitkis gimin Uhokri gikumadukan. ");
INSERT INTO plu_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Igkis pahadgupu ayge, ig Kiyapwiye Jesus awna ta gitkis: ―Ka yi pes aytekihan apititak paytwempu Jerusalém. Kuwis nah akki yit ku pariye Wigwiy gikaksan ta yit. Wahapnabay in kahayak yit. ");
INSERT INTO plu_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Minikwak ku aysaw amekene João Batista kaywa hiyeg, ig kawihkis un ta gipititkis. Henneme hawkuwanek igyerwa Uhokri Gitip kawihkiska ta yipititnek. Hennebaki ig kaywepyinek. ");
INSERT INTO plu_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ariwnteke ini ig Kiyapwiye Jesus pahadguhwa gikakkis gikannuhnipwi akiw. Ayge apim ini igkis ayapri: ―Kiyapwiye, kuri nerras hiyeg ku pariye romayenepwi igkis kumaduka uhiyegapuwiy awaku ku samah igkis matekepwiy. Mmah kurinewa pis keh wixwiywa wixwiy hiyeg judeyenepwi kumaduka uhiyegapuwiy ku apim inin akiw? ");
INSERT INTO plu_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Igme kaytwa giwnkis: ―Yis ka hiyá yisma hiyak akak ini. Wigwiy kuwis ahegbete madikte hawkri akak gidatni. Henneme yis ka hiyá yisma hiyak nikak. ");
INSERT INTO plu_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ka sam. Aysawnemenek yis darih Uhokri gannu ta yipititnek apim ini ku aysaw ig Uhokri Gitip kawihyi. Ayge nikwe yis humaw inetitkekne ndahan ta gitkis hiyeg muwwapu. Yis humaw inetitkekne ndahan ay apit inere paytwempu Jerusalém, ay apitiw inin waxri Judeyamnaw, ayhté apitiw ini waxri piyawekbetape Samaríyamnaw, pisenwa muwwapu amadga wayk he danuhe amaksemni paytwempu. ");
INSERT INTO plu_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ayteke pisenwa inakni gawnhan, ig Kiyapwiye Jesus iwepka ta inugikute giwtrikneswa gikannuhnipwi. Ayteke ig uguhe abet pahá ukuhne. ");
INSERT INTO plu_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Igkisme gikannuhnipwi ipegbet ta gimkat ku samah giwepni. Pahaye adahan piyana hiyeg ahj kahayak tabirwak giharaptakkis. Igkis kasimsapu akak simis seyne. ");
INSERT INTO plu_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Igkis awna ta gitkis gikannuhnipwi: ―Kiyapwiyegben, mmah yis msakwa ipegbet ta inut? Ig Kiyapwiye Jesus iwepka yibetitak ta inugikut henneme ig diyuh akiwnek. Ku samah yis hiyá gitepkemni hawwata yis hiyá gaytni akiwnek. Hennewatbaki igkis awna. ");
INSERT INTO plu_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Igkis gikannuhnipwi ayge apit ini waxri imuhgipitnene kewye Olipegpit. In Jerusalém awetpu. Ayabri ahin ik adahan pohowku sah (500) iwanti. Igkis hiyapni henne ku samah Kiyapwiye Jesus iwepka kuwis, igkis tipik diyuh ta apitit paytwempu Jerusalém. ");
INSERT INTO plu_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Igkis danuh atere, igkis wagehe ta agikut pahá payt apahnap inuteknen. Ini giwskekrikis kiyapwiye Pedru gikakkis kiyapwiye João, amekene Tiyagumni, kiyapwiye André, kiyapwiye Filip, kiyapwiye Tomé, kiyapwiye Bartolomew, kiyapwiye Matews, kiyapwiye Tiyagu ku pariye amekene Alfew gikamkayh, kiyapwiye Simawh Zeloti, kiyapwiye Judas ku pariye kiyapwiye Tiyagu gisamwi. ");
INSERT INTO plu_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ayge agiku ini xam igkis msakwa piriyepkewnen takunipti. Kiyapwiye Jesus ginag kiyapuno Mahi hawwata eg piriyepkawno ayge payak gikakkis gisamwipwi gukakkis gikannuhnipwi tinogben. Egkis madikte ayge pahatwowa guhiyakemnikis. ");
INSERT INTO plu_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Mpiyasa aynessa hawkri, egkis gikannuhnipwi pahadguhwe atere ku samah guhumpawnikis. Egkis pukuhka danuh adahan madikawku madikwa gukebyikis akak piyana madikwa gawnakis (120). Ayge nikwe ig kiyapwiye Pedru kannikaw gubetkis adahan ikene guhiyakemnikis. Ig awna: ");
INSERT INTO plu_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Nukebyupwi, minikwak Uhokri Gitip kawih amekene Davi adahan ig kinetihwa amin ku pariye nemnikumpiye. Inakni ginetni tamak ay amadga kagta. Ku pariye Uhokri gakkan amawka ku hennewa in humaw. Ig amekene Davi kinetihwa gimin Judas Iskariyotismin. Metakwa inakni ginetni kahayak mmanawa ig Judas Iskariyotismin waxe igkis hiyeg ku pariye kamaxwiyes Kiyapwiye Jesus. ");
INSERT INTO plu_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ig Judas Iskariyotismin ig waytak usuh giwatnipwi mmanawa ig kaniyka gapit Kiyapwiye Jesus adahan ig keh gannipwi payak ukakhu. ");
INSERT INTO plu_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ig isime pahá waxri akak gitiwnipye ku samah ig kamaykise Kiyapwiye Jesus. Ayteke ig umehwe ayge apit ini waxri. Apim ini ig tuguhe mabuwe. Bewpi gitun. Madikte gayh pese gipititak. ");
INSERT INTO plu_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ayteke madikte hiyeg jerusalémyenepwi timé gak ku samah ig keh henne. Inneki keh igkis kaywa ini waxri “Aseldama”, inakni wownaprikwiy “Waxri Migatapta”. ");
INSERT INTO plu_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Hennewa in danuh ku samah Uhokri ekke ta git amekene Davi minikwak. Mmanawa minikwak ig amekene Davi tameke inakni amadga ini kagta kewye “Salmus”. Inakni yuwit awna: “Amawka gipin msakwa barewagik. Amawka yuma hiyeg msakwa ayge.” Henneme in gikagtan hawwata awna: “Amawka ku pahapwiwa akiw kannikaw giwenyan adahan kannipwi gidukwantak.” ");
INSERT INTO plu_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Inneki keh nah ikene yihiyakemni ku apim inin adahan wixwiy kaniy pahapwiwa akiw gidukwantak Judas Iskariyotismin adahan ig keh Uhokri gannipwi payak ukakhu. Uyay kaniy pahapwi ku pariye kuwis wew ukakwiy apanenekwa ku samah Kiyapwiye Jesus aynete ukakwiy. ");
INSERT INTO plu_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Uyay kaniy pahapwi ku pariye ay ukakwiy awenketeke ku aysaw ig Kiyapwiye Jesus kaywepka gapit amekene João Batistamni, he ku aysaw ig iwepka ta inugikut. Uyay kaniypig adahan ig ekkene gimin Kiyapwiye Jesus gikankewni payak ukakwiy. ");
INSERT INTO plu_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ig Kiyapwiye Jesus gikannuhnipwi igkis timapni inakni kiyapwiye Pedru giwn henne, igkis ihe giwn. Igkis kaniye piyana gikebyikis awaykemni gibetitakkiswa. Pahapwi giw José Barsabás, ig giw hawwata Justu. Pahapwime giw Matiyas. ");
INSERT INTO plu_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ayteke pisenwa igkis piriyepkaw adahan ipegepye ku pariye Uhokri gikanyan adahan Judas Iskariyotismin giwenyan. Igkis awna: ―Kiyapwiye, piski hiyekne hiyeg giyaknikis. Uyá akki ta wothu ku pariye pis kaniy gaytakkis nerras piyananene gikebyikis. ");
INSERT INTO plu_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Uyá akki ta wothu ku pariye pis kaniy adahan ig kehne pannipwi. Uyá akki ta wothu ku pariye pis muwaka kannikaw giwenyan piwatni Judas Iskariyotismin. Mmanawa ig Judas Iskariyotismin kuwis pese ariw giwetri ku samah ig piwatni kahadbe ig tipik ta arimkat ku pariye iwetrit kawihnene gidahan. ");
INSERT INTO plu_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Pisenwa gipigyepkawnikis igkis arehwe nikwe akak tip adahan igkis hiyá ku pariye kabunuganen ig darihpiye Judas Iskariyotismin giwetri. Nikwe ig Matiyas kabunuga. Ig darihe ini iwetrit adahan ig keh Uhokri gannipwi payak gikakkis Kiyapwiye Jesus giwatnipwi. ");
INSERT INTO plu_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ayteke ariwnteke ini, ahawkanaprik danuh adahan hiyeg judeyenepwi keh ini fet arimketpiye ntewnehkerpye paka kewye “Pentekostis”. Ayge Kiyapwiye Jesus gikannuhnipwi igkis pahadguhwe arimkat pahayruknene iwetrit. ");
INSERT INTO plu_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Pahaye adahan kimankarad muhuk ayta inugiktak kewa maygbe akak madikte ahawna. In parak ta paytrikut ku kiney igkis batebdebdihpiye. ");
INSERT INTO plu_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ayge igkis hiyá akadwey kewa tiketbe. In bat mpuse gipuhekutkis. ");
INSERT INTO plu_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ayge amun ini ig Uhokri Gitip kawihapeprikis madikte. Igkis kapusa awna agiku kaayhsima nawenéwa yuwit ku samah ig Uhokri Gitip ikí giwnkis gitkis. ");
INSERT INTO plu_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Apim ini ayge Jerusalém kaayhsima hiyeg ku pariye judeyenepwi ku pariye kiyathanepwi Uhokri. Igkis danuhpenes atere ayta aytontihan apititak madikte nawenéwa paytwempu. ");
INSERT INTO plu_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Igkis timapni inakni kimanka henne, igkis atere pahadguhwa kabubuk ganwakis Kiyapwiye Jesus gikannuhnipwi. Igkis ka pukuhpin ku samah igkis madikte pahapwihwat timepnekwiye gikannuhnipwi awna mpuse giwnaprikkis. ");
INSERT INTO plu_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ayge nikwe igkis wakaymnibdi kaayhsima. Igkis barukiswa. Igkis awna: ―Mmahki? Nerras hiyeg ku pariye awnenes madikte igkis galiléyenepwi. Igkis ka kannuh awna wownaprikwiy. ");
INSERT INTO plu_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Mmah nikwe wixwiy pahapwihwat timepnekwiye igkis awna wownaprikwiy? ");
INSERT INTO plu_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Wixwiy ay aytontihan nawenépwi paytwempu. Waytakwiy Pártiyatekne, Médiyatekne, Elohtekne. Waytakwiyme hiyeg aytontak Mesopotâmiyamnaw, hiyeg aytontak Judeyamnaw, hiyeg aytontak Kapadósiyamnaw, hiyeg aytontak Pontomnaw, hiyeg aytontak Ásiyamnaw, ");
INSERT INTO plu_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","hiyeg aytontak Firíjiyamnaw, hiyeg aytontak Panfíliyamnaw, hiyeg aytontak Ejitumnaw, hiyeg aytontak Líbyamnaw kennesa Sirenemnaw. Hawwata hiyeg ku pariye romayenepwi ay ku pariye danuhpenepwi atan. ");
INSERT INTO plu_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Wixwiyme waytakwiy hiyeg ku pariye waypuka judeyenepwi akak hiyeg ku pariye wageswa judeyenepwi. Waytakwiyme hiyeg kireteyenepwi akak hiyeg arábyenepwi. Mmah nikwe wixwiy timepnekwiye nerras hiyeg awnenes mpuse wownaprikwiy igkis kibeyhenes Uhokri gannu? ");
INSERT INTO plu_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Igkis madikte wakaymnibdi. Igkis ka pukuhpin ku samah in. Igkis awnebdi pawtak. Giwnkis: ―Pariyeki inin? ");
INSERT INTO plu_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ignesme gaytakkis hiyeg ayge igkis hiyapni henne, igkis hiyaraptih Kiyapwiye Jesus gikannuhnipwi. Igkis awna: ―Igkis urukya akak win. ");
INSERT INTO plu_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ayteke ig kiyapwiye Pedru tabir gapitkigawkis payak gikakkis nerras Jesus giwatnipwi madikawkunene gikebyikis gikak pahapwi gawnakis (11). Ig kapusa awna ta gitkis madikte hiyeg ayge akak madikte gawaygyi. Giwn: ―Nukebyupwi judeyenepwi, yis jerusalémyenepwi. Atabiswanabay nuthu. Nah arakamnihten ta yit ku pariye danuh ku apim inin. ");
INSERT INTO plu_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Yaytak yis ikiy ku usuh urukya. Kawa. Usuh ka urukyawatma. Kote danuhte ahawkanaprik adahan wis higap win. Kamuw inutad. ");
INSERT INTO plu_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ku pariye danuh ku apim inin ig Uhokri gawnepe amekene Joel, ig kinetihwa nimin minikwak. Giwn: ");
INSERT INTO plu_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Kiyapwiye Uhokri awna: ‘Amaksemni hawkrinek nah kawihkis ntiphu ta yipititnek. Ig kawih hiyeg madikte. Apim ini yikamkayupwi awnanek yuwit ku pariye pes giwntak Uhokri. Yikamkayupwi awaykemni payebitak gukakkis yikamkayupwi tinogben. Ku pariye takwapye ignes hiyá giwtyakkispeynen. Ku pariye kiyapwiyegben ignes hawwata igkis karisun. ");
INSERT INTO plu_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Apim ini nah Uhokri kawihkis ntiphu ta gipititkis nuhiyegapu awaykemni payebitak gukakkis nuhiyegapu tinogben. Egkis madehkis awnanos yuwit ku pariye pes giwntak Uhokri. ");
INSERT INTO plu_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Apim ini nah akki ta yit annutnek ayhté inugik, ayhté amadga wayk, adahan arekhetni yit ku amaksemni hawkri kuwis danuh. Apim ini yis hiyanek migat. Yis hiyá tiket. Yis hiyá sariyan mtibnene. ");
INSERT INTO plu_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Apim ini kamuw tigehe. Kayg wageswe duruweh ke migatbe. Ayteke ini hawkri ku pariye apitmin madikte hawkri amadga inin in danuh. Abet ini hawkri Kiyapwiye ayta adahan pisenwapye akak inin hawkri. ");
INSERT INTO plu_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Apim ini amaksemni hawkri madikte hiyeg ku pariye amnihswene ta git Kiyapwiye Uhokri ignes amnihkanek.’ ” Inakni Uhokri giwn ku pariye gannasan ta git amekene Joel. ");
INSERT INTO plu_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Nukebyupwi judeyenepwi, ataybiswanabay numkat. Metakwa inakni giwn kapuse kahayak. Kuwis ig Uhokri keh kaayhsima annut ay yiwtrik gipitimpi Kiyapwiye Jesus nazaréyene. Ig keh kibeyne annut ku pariye hiyeg amadgaya inin ka hiyá nikehka. Ig keh annut ku pariye keh hiyeg wakaymni ku pariye arekhetni gidatni. Akak ini annut ig Uhokri akki wotwiy huwewe ku ig ay gikak Kiyapwiye Jesus. Yis hiyakni kabayhtiwa. ");
INSERT INTO plu_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Henneme yis ka aminama niw. Minikwak ig Uhokri ayipa hiyak ku pariye yis keh gikaknek. Ayge nikwe ig ikepri ta yiwakuit ku samah ayipa ig ikiswanaw gidahan. Yisme umahkiswig. Yis daddahkiswig ta gitkis hiyeg ku pariye kane hiyak Uhokri gikumadukan. ");
INSERT INTO plu_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Henneme kibeyne, ig Uhokri kannikasepri akiw ariw gimiremni. Mmanawa ig ka hiyá igma msakwa akak miyaka. ");
INSERT INTO plu_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Minikwak amekene Davi awna inakni henne gimin Kiyapwiye Jesus. Ig awna: “Kiyapwiye ay nukakhu apanenekwa. Ig kennesa ay numunhu niyewka. ");
INSERT INTO plu_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Inneki keh nuyakni bateke. Mataytak nah awna batekkanenwa. Ku nah miyá, ka sam. Nah ipeg ta gipitit Uhokri ku ig kannikasan akiw. Nah awna: ");
INSERT INTO plu_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","‘Pis ka ikis nanmapuh ayhté miyarapye giwetrikis. Pis ka isaksan nah pikamkayh barewpitye adahan nupithu madipwip. ");
INSERT INTO plu_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Mmanawa pis keh nah aymuhwa adahan apanenekwa. Kuwewanek pis keh nah batek nnaktin awaku ku samah nah ay pimun akiw.’ ” Hennewatbaki ig amekene Davi awna. ");
INSERT INTO plu_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Nukebyupwi, in kahayak huwewe wotwiy ku ig ukiparawiy amekene Davi ka awna inakni giminma. Ayipa ig miyap. Ig apuhpika. Gipit madipwip. Ku apim inin gimew adukwenewa ay umunwiy. ");
INSERT INTO plu_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Giminme gihiwhi Kiyapwiye Jesus ig awna inakni giwn mmanawa ig amekene Davi iggi Uhokri gawnepe adahan ekkene ku pariye nemnikumpiye. Minikwak ku samah ig aynete amadga inin ig Uhokri awna git: “Davi, pahapwi gaytakkis pihiwhipwi kannikawnek adahan ig kumadukene hiyeg piwenyan. Nah ikakse pit inakni ku apim inin. Nah ka uniyehti ini nuhiyakemni.” ");
INSERT INTO plu_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ner amekene Davi gihiwhi iggi Cristo ig Uhokri gikanyan adahan ukumaduketniwiy. Ig amekene Davi hiyapni henne ku pariye nemnikumpiye, ig awna inakni yuwit gimin Cristo gikankewni. Inneki keh ig awna ku Uhokri ka ikis Cristo ganmap ayhté miyarapye giwetrikis. Inneki keh ig awna ku gipit ka madipwip. ");
INSERT INTO plu_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Kibeyne, metakwa inakni giwn humaw wotwiy. Ig Uhokri kannikase Kiyapwiye Jesus ariw gimiremni. Akakwa wowtyak usuh hiyapri ig wewparihte ariwntak gikankawni. Kuri usuh ekkene ini gikankawni ta yit. ");
INSERT INTO plu_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Kuwis ig iwepka tahhan inugikut adahan ig msakwa ayge gihumwa Uhokri amun ini iwetrit ku pariye kanenikiythanisima kihehaptak. Ayge ig Wigwiy iké Gitip ta giwakuit Kiyapwiye Jesus ku samah gikaksan git minikwak. Igme kawihkise Gitip ta upitithu ku apim inin. Inineki ku pariye yihiypan. Inineki ku pariye yitimpan. ");
INSERT INTO plu_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ig amekene Davi gipit kote iwapkate inugikut henneme minikwak ig awna: “Ukiparawiy Uhokri awna ta git nukipara Cristo. Giwn: ‘Batnaba ay nuhumwa kihehaptak amun inin iwetrit ku pariye kiyatye ");
INSERT INTO plu_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ku samah nah sibuhkisnete pipetunyapu pit.’ ” ");
INSERT INTO plu_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Nukebyupwi judeyenepwi, ku apim inin nah ikene yinetni marihwa yis hiyakni kabayhtiwa ku ig Kiyapwiye Jesus, ner Kiyapwiye Jesus ku pariye yidaddahkisni, ignewa Ukiparawiy. Ignewa Uhokri gikanyan adahan ukumaduketniwiy. Hennewatbaki ig kiyapwiye Pedru awna. ");
INSERT INTO plu_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Igkis hiyeg timapni henne, igkis kayah gitaraksankis, igkis awna ta gitkis kiyapwiye Pedru. Giwnkis: ―Nukebyupwi, mmah usuh keh kuri? ");
INSERT INTO plu_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Igme kiyapwiye Pedru kaytwa giwnkis: ―Wagesnabay yihiyakemni ariw yitaraksan. Kewpinabay pahapwihwat ta ahakwat un giwaprik Kiyapwiye Jesus Cristo adahan yis amepene inin ku Uhokri bayahminay ariw yitaraksan. Ayge nikwe ig ikí Gitip ta yipititnek. ");
INSERT INTO plu_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Mmanawa kuwis ig ikakse Gitip ta wotwiy. Inakni gikaksan kawih yidahan. In kawih gidahankis yikamkayupwi. Juktah in kawih gidahankis hiyeg optirewnepwi. Mmanawa ig ikakse Gitip ta gitkis madikte ku pariye ihepye gihumketni ta gimkanit. ");
INSERT INTO plu_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ayteke ig Kiyapwiye Pedru awna kaayhsima yuwit akiw. Ig ikene nerras hiyeg gihiyakemnikis. Giwn: ―Ka ba yi msakwa kema gaytakkisma nerras ku pariye gitukepten Kiyapwiye Jesus. Wiwhwepnabay giwkis adahan yis isamtaw. ");
INSERT INTO plu_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Igkis timapni henne, kaayhsima gaytakkis ihe giwn. Ayteke nikwe igkis kewpi. Apim ini hawkri mpana mil (3.000) gikebyikis hiyeg wageswepyes Kiyapwiye Jesus gihiyegapu. ");
INSERT INTO plu_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ayteke mpuse hawkri igkis tipikn