﻿USE sofia;
DROP TABLE IF EXISTS sofia.plj_vpl;
CREATE TABLE plj_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES plj_vpl WRITE;
INSERT INTO plj_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Mǝnkǝn ni'e tǝlankur kǝ gǝs kǝ Yesu Almasihu gǝsgal kǝ Dauda, muntu kan gǝsgal kǝ Ibǝrahim ni gwa. ");
INSERT INTO plj_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ibǝrahim ni'e basi Ishaku, Ishaku ni'e basi Yakubu, Yakubu ni'e basi Yahuda na mir ezǝni. ");
INSERT INTO plj_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yahuda ni'e basi Peres na Zera. Nazin ni'e Tamar. Peres ni'e basi Hezron, Hezron ni'e basi Aram. ");
INSERT INTO plj_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram ni'e basi Aminadab, Aminadab ni'e basi Nashon, Nashon ni'e basi Salmon, ");
INSERT INTO plj_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon ni'e basi Bo'az. Nas ni'e Rahab. Bo'az ni'e basi Obed, muntu nas ni'e Rut gwa, kan Obed ni'e basi Yesse. ");
INSERT INTO plj_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yesse ni'e basi gun Dauda. Dauda ni'e basi Solomon, muntu kan nas ni'e Batsheba kan faro gǝr kǝ Uriya ni gwa. ");
INSERT INTO plj_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon ni'e basi Rehobowam, Rehobowam ni'e basi Abiya kan Abiya ni'e basi Asa. ");
INSERT INTO plj_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ni'e basi Yehoshapat. Yehoshapat ni'e basi Yoram, kan Yoram ni'e basi Uzziya. ");
INSERT INTO plj_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzziya ni'e basi Yotam. Yotam ni'e basi Ahas kan Ahas ni'e basi Hezikiya. ");
INSERT INTO plj_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezikiya ni'e basi Manasse, Manasse ni'e basi Amon, kan Amon ni'e basi Yosiya. ");
INSERT INTO plj_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosiya ni'e basi Yekoniya na mir mǝn gǝpi gǝs kan dǝm zher wokoci tu yem wur su Babila kagwa. ");
INSERT INTO plj_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Den kaar kǝ yemi gǝzǝn zher su Babila kawo, Yekoniya dǝm basi Sheyaltiyel, Sheyaltiyel ni'e basi Zerubabel. ");
INSERT INTO plj_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubabel ni'e basi Abihud, Abihud ni'e basi Eliyakim kan Eliyakim ni'e basi Azor. ");
INSERT INTO plj_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor ni'e basi Zadok, Zadok ngapo basi Akim ni kan Akim ni'e basi Eliyud. ");
INSERT INTO plj_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyud ni'e basi Eleyazar. Eleyazar ni'e basi Mattan kan Mattan eso basi Yakubu ni. ");
INSERT INTO plj_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Kano Yakubu ni'e basi Isubu ba kos kǝ Maryamu muntu kan gǝr Yesu kan ba la ti bi'e Almasihu gwa. ");
INSERT INTO plj_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Mǝngǝri ra den mǝngǝri kutl cet wupse argon tu pǝn den Ibǝrahim ar ri den gǝri kǝ Dauda gwa. Mǝngǝri ra den mǝngǝri kutl cet wupse es argon tu pǝn den Dauda ba ri wokoci tu yem mbarǝm kǝ Isra'ila wu dǝm zher gip atl kǝ Babila gwa. Eso, mǝngǝri ra den mǝngǝri kutl cet wupse argon tu pǝn den dǝmi zher su Babilaka ar ba ri den Almasihu gwa. ");
INSERT INTO plj_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Nankǝn ni gǝri kǝ Yesu Almasihu ra. Wokoci tu Maryamu ra na o gam dati kǝ gudlumi na Isubuwo, tǝ dǝm gǝr gǝs wu da'a, ar ni shin tǝ ra na tu gǝri muntu tǝ zam tǝp kar Ruhu kǝ Yam gwa. ");
INSERT INTO plj_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Isubu nye kos gǝsiwo, mǝn pitǝn dlat ni. Tǝ ndu ɗǝli shirǝmika kari da'a bǝse tǝ la ti gip sham kar mbarǝme. Ar ni tǝ pǝn tor gip mbatl gǝs'e tii za tǝka shok. ");
INSERT INTO plj_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ama nan tǝ den damtǝn denewo, ar ni nye mǝn kartǝn kǝ Babom Yam ɗǝl kar ti gip tlon tǝ wul ti'e, <<Isubu gǝsgal kǝ Dauda ba kǝ kum bǝrti kǝ pǝni Maryamu tǝ dǝm gǝr gi da'a. Pǝni tu gǝs tuwo tǝp kar Ruhu kǝ Yam ni. ");
INSERT INTO plj_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Tii gǝr nya, kan kǝ ne ti sun'e Yesu, domici tin tii ɗǝli mbarǝm gǝska gip warwat pitǝne.>> ");
INSERT INTO plj_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Muntu kup pini kǝ dǝ laa'i argon tu Babom Yam yari tǝp kar mǝn yari shirǝm kǝ Yam gwa'e, ");
INSERT INTO plj_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","<<Nye gǝr mǝn yap gam baa zam tu'e, tǝ gǝr nya moni, baa la ti bi'e Imanuel.>> Gǝs kǝ sunyi'e, <<Yam ra nan mi.>> ");
INSERT INTO plj_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Nan Isubu putuwo, ar ni tǝ pi kandatu nye mǝn kartǝn kǝ Yami yari ti gwa, tǝ pǝn Maryamu tǝ dǝm gǝr gǝsi. ");
INSERT INTO plj_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ama tǝ mom ti nya mǝtliyi da'a, har tǝ gǝr nya gǝsi. Kan Isubu ba ne ti sun'e Yesu. ");
INSERT INTO plj_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Den kaar kǝ gǝri Yesu gip bǝn Betelehem gip kǝti atl kǝ mǝn Yahuda, wokoci tu Hiridus ra den dandi gwawo, ar ni mǝn momi zǝnges jen tli tor gabǝs wu sur bǝn kǝ Urshalima. ");
INSERT INTO plj_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Wu ngen momi, wu wule, <<Ako ni pel gun kǝ mǝn Yahuda tu kan'i gǝr ti gwa ra? Domici mǝ shin zǝnges gǝs su gabǝska ar ni mǝ tor kǝ dǝ mǝ bote ti.>> ");
INSERT INTO plj_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nan gun Hiridus kum untuwo, ar ghun ti naari nan ti na mbarǝm kǝ Urshalima kup. ");
INSERT INTO plj_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kan tǝ dom kiri mǝn keri bar ju ɗiri Yam gwa kup, na mǝn kulci mbarǝm den kulci kǝ Musa, kan tǝ ngen momi las tu baa gǝr Almasihu gwa. ");
INSERT INTO plj_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ar ni wu nǝmi ti wu wule, <<gip Betelehem ni kan ra gip kǝti atl kǝ mǝn Yahuda gwa, domici untun mǝn yari shirǝm kǝ Yam rǝsh'e, ");
INSERT INTO plj_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","<Ki Betelehem kan ra gip kǝti atl kǝ mǝn Yahuda gwa, ba'e ki ni kǝ mani kaltǝn gip mir bǝn kǝ mǝn Yahuda da'a. Fawo gip ki ni baa gǝr bar mǝn kopi na mbarǝme, muntu baa le mbarǝm gǝn kǝ Isra'ila wule tǝm gwa.> >> ");
INSERT INTO plj_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ar ni Hiridus la bi mǝn momi zǝnges ju muri, tǝ ngen momi wokoci tu zǝngesi ɗǝl gwa. ");
INSERT INTO plj_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Kan tǝ kar wur tǝ wule, <<Te ni gip bǝn Betelehem, kǝ ngen ni gǝs kǝ nyayi hoyi. Kǝn ni kǝ zam tiwo, kǝ ter yarim ni, ami ma a te bote ti.>> ");
INSERT INTO plj_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Nan wu kum shirǝm kǝ gunyiwo, ar ni wu ndara. Ar ni zǝnges tu kan wu shin su gabǝs ka gwa ba nde wur cina ar ba ri dlǝr sur gam las tu kan nyayi ra gwa. ");
INSERT INTO plj_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Nan wu shin zǝngesiwo, ar ni wu pi ghol mbatl hoyi. ");
INSERT INTO plj_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Nan wu te gip bomiwo, kan wu shin nyayi na nas Maryamu, ar ni wu ngus cina da ti wu bote ti. Kano wu ɓul posh gǝzǝn wu bi ti bari; ga zǝnariya, na lubban, na mur, munjuwo mir mǝn tǝmi kasǝr ni kǝ keri, na kǝ bǝrketǝne. ");
INSERT INTO plj_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nan dǝli wur kǝm gip tlon den ba dǝ wu'i pal tǝp kar gun Hiridus dawo, ar ni wu kop zut tǝp gon wu pal rǝn atl gǝzǝnka. ");
INSERT INTO plj_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nan ga mǝn momi bari ndarawo, ar ni nye mǝn kartǝn kǝ Babom Yam gon ɗǝl kar Isubu gip tlone. Tǝ wul ti'e, <<Tlyam kǝ pǝn nyayi na nas kǝ kǝtǝr ni gin te atl kǝ Masarka, kǝ dǝm ni teka, se ami ni a yari in'e dǝ kǝ pal ter gwa, domici Hiridus den ngeni nyayi kǝ dǝ tǝ ri ti eka.>> ");
INSERT INTO plj_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ar ni Isubu tlyam kan tǝ pǝn nyayi na nas gip gasi, tǝ ndara Masar. ");
INSERT INTO plj_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Tǝ dǝm teka ba ri kaar kǝ mǝshtǝn kǝ Hiridus. Muntu pi ni kǝ dǝ laa'i argon tu Babom yari tǝp bi dǝ mǝn yari shirǝm kǝ Yam gwa'e, <<Ter Masar ni a la bi nya gǝni.>> ");
INSERT INTO plj_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Nan Hiridus shin mǝn momi zǝnges ju pali tǝka kǝdlǝmiwo, ar ni lo ci ti naar kan tǝ kar bar dǝ ri kup mimir moni munju ra gip bǝn Betelehem na kosack kǝ bǝni gwa eka, munju ri sheti ghon rop na munju ri untu wu dagwa. Tǝ pǝn ni kǝ pi untu den wokoci tu mǝn momi zǝnges ju yari ti shirǝm den nyayi gwa. ");
INSERT INTO plj_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Wokociyi ni shirǝm kǝ Irmiya, mǝn yari shirǝm kǝ Yam laa'i'e, ");
INSERT INTO plj_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","<<Kum yar gon gip bǝn kǝ Rama, yar kulu na dun mbatl mǝn nartǝni. Rahila ni den kulu den mimir gǝsi. Tǝ nge kumi dǝ iɗa'i ti mbatlka, domici wu'i da'a.>> ");
INSERT INTO plj_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Nan Hiridus mǝshkawo, ar ni mǝn kartǝn kǝ Babom Yam gon ɗǝl kar Isubu gip tlon te Masarka, ");
INSERT INTO plj_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","tǝ wul ti'e, <<Tlyami, kǝ pǝn nyayi na nas kǝ pal ni te gip kǝti atl kǝ Isra'ilaka, domici munju ba ngen ri nyeyi ekawo wu mǝsh kawi.>> ");
INSERT INTO plj_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ar ni tǝ tlyam kan tǝ pǝn nyayi na nas wu pal te atl kǝ Isra'ilaka. ");
INSERT INTO plj_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ama nan tǝ kum'e Arkilawus ni pal den dandi kǝ bas Hiridus mǝn lish kǝ Yahudiyawo, ar ni bǝrti ci ti kǝ tetǝn lasi. Ama nan dǝli tǝ kǝm gip tlono, ar ni tǝ rat gǝs gip kǝti atl kǝ Galili. ");
INSERT INTO plj_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Kan tǝ te dǝm gip bǝn gon kan ba wul ti'e Nazarat gwa, den bi yari kǝ ga mǝn yari shirǝm kǝ Yam'e, <<Baa la ti bi'e, Ba mǝn Nazarat.>> ");
INSERT INTO plj_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Gip muri ja ni Yohana mǝn pi batisma ɗiri, tǝ den wazu shirǝm kǝ Yam gip kǝti atl kǝ mǝn Yahuda, ");
INSERT INTO plj_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","tǝ den wultǝn'e, <<Ci ni atl gam kǝ pal ni kar Yami, domici mulki kǝ Yam mbira kosak wi.>> ");
INSERT INTO plj_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Muntu ni'e mbarǝm tu kan Ishaya mǝn yari shirǝm kǝ Yam shirǝm den ti gwa'e, <<Yar kǝ gon mǝn latǝn bi gip lǝp den wultǝn'e, <Kǝrkǝmi ni Babom guntǝp kǝ cwattǝn gǝsi, dǝ guntǝp gǝs dǝm na ta'i.> >> ");
INSERT INTO plj_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Tutul dli ka ta rakumi ni Yohana la'i, tǝ dlǝmat ti na late. Fingal gǝs ni'e zas na domi. ");
INSERT INTO plj_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Mbarǝm kǝ bǝn kǝ Urshalima na kǝ mǝn kǝti atl kǝ Yahudiya na mǝn atl kǝ bi ɓula Urdun pi ta ɗirtǝn kar ti. ");
INSERT INTO plj_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Wu ɗir gip dlom mbarǝm wu yari warwat pitǝn gǝzǝni, kan tǝ pi wur batisma gip ɓula kǝ Urdun. ");
INSERT INTO plj_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Nan tǝ shin mǝn Parise na mǝn Sadukiya na womti den ɗirtən kǝ dǝ pi wur batismawo. Ar ni tǝ wul wur'e, <<Kǝn ga badǝr kǝ wonzi! Woni dǝli in kǝm kǝ dǝ kǝ kǝtǝri ni lo kǝ Yam mǝn ɗirtǝn we? ");
INSERT INTO plj_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Pi ni mbap tu kan baa gode ci atl gam na paltǝn gin kar Yam gwa. ");
INSERT INTO plj_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ba kǝ ɓo ni ngetl den'e, <Ibǝrahim ni'e be gin da'a.> A yari ine, Yam baa mani pi Ibǝrahim mimir na tat ju. ");
INSERT INTO plj_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Tare ne bi ndal den gǝs kin wi. Kin tu kup kan gǝri ho mimir dawo, baa wotl tika dǝ la ti te utuka. ");
INSERT INTO plj_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Amiwo, a pi in ni batisma na mal kǝ dǝ gode'e kǝ ci atl gam kǝ pal kar Yam wi. Ama gon ra den ɗirtǝn kaar dami kan manǝm nartǝn gwa, muntu kan kaptǝlan gǝs ma a kǝm pǝni da'a. Tii pi in batisma na Ruhu kǝ Yam na utu. ");
INSERT INTO plj_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Gal bǝtke bar gǝs ra am dati, tii sar ba desi bar gǝska hoyi, tǝ dom gesi o tǝ wi ɓindika, kan kǝptiyi ngapo tǝ kerika gip utu tu kan baa mǝsh dagwa.>> ");
INSERT INTO plj_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Wokociyi ni Yesu ɗəl ɗir gip kǝti atl kǝ Galili, tǝ mbubar ɓula Urdun, kǝ dǝ Yohana pi ti batisma. ");
INSERT INTO plj_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yohana ndu tǝ nge gǝsi, tǝ wule, <<Ami kan a ndu'e kǝ pim batismawo, kǝ pa ɗir karim esa?>> ");
INSERT INTO plj_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ar ni Yesu nǝmi ti, tǝ wule, <<Naa ar dǝm untu kǝkǝni, domici untu ni ar ndari mǝ laa'i argon tu kup dlat ni ar ra kar Yam gwa.>> Na untu ni Yohana nǝmi ti. ");
INSERT INTO plj_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nan pi Yesu batisma tǝ ɗǝl tor gip maliwo, ar ni yam ɓuli, kan tǝ shin Ruhu kǝ Yam den surtǝn wule kuɓuri tǝ sur dlǝr den bibyala gǝsi. ");
INSERT INTO plj_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kan ba kum yar ɗǝl sur yam ba wule, <<Muntu ni'e Nya gǝni. A ndu ti, kan tǝ gholim mbatl naari.>> ");
INSERT INTO plj_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ar ni Ruhu kǝ Yam ri Yesu gip lǝpe, kǝ dǝ Shetan mǝn setǝn gode ti. ");
INSERT INTO plj_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Nan tǝ pi guzum mal muri hauya rop (40) pǝt na gasi, den kariwo, guzum ci ti. ");
INSERT INTO plj_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ar ni mǝn setǝni ɗir tǝ wul ti'e, <<O ki Nya Yamno, wul tat ju'e wu dǝm bǝredi.>> ");
INSERT INTO plj_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ama Yesu nǝmi ti, tǝ wul ti'e, <<Ar ra na rǝshi gip shirǝm kǝ Yam'e, <Na bǝredi ni katl mbarǝm ba mani dǝmi da'a, ama na ko gonge shirǝm kan ba ɗǝl kar Yam gwa ni.> >> ");
INSERT INTO plj_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ar ni mǝn setǝni si ti bǝn Urshalima, bǝn tu kan Yam zǝzari gam gǝs gwa, tǝ te ti to den gam bom kǝ Yamka kan to yam naar gwa. ");
INSERT INTO plj_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Tǝ wul ti'e, <<O ki Nya Yam no, ɓo tuma su atlka. Domici Shirǝm kǝ Yam wule, <Tii bi bi dǝ mǝn kartǝn kǝ Yam den wu gaa ki, bǝse kǝ ɓo asǝmka den tate.> >> ");
INSERT INTO plj_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ar ni Yesu wul ti'e, <<Ar ra na rǝshi es'e, <Kii gode Babom Yam gi da'a.> >> ");
INSERT INTO plj_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Den kaariwo, ar ni mǝn setǝni te Yesu den gam tlyari tlǝndǝre, tǝ ta'i ti am den mulki kǝ atl kup na nartǝn gǝzǝni. ");
INSERT INTO plj_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Tǝ wul ti'e, <<Aa bi'i mulki kǝ atl ju kup, ki ni kǝ nda atl cina da'ǝm kǝ botem gwa.>> ");
INSERT INTO plj_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ar ni Yesu wul ti'e, <<Tli karǝmka, Shetan! Domici ar ra na rǝshi'e, <Bote Babom Yam gi nan gǝsi. Ti ni katl kii bote ti.> >> ");
INSERT INTO plj_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ar ni mǝn setǝni za ti. Kan mir mǝn kartǝn kǝ Yam ba cwat kar ti, wu pi ti mbapi. ");
INSERT INTO plj_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Nan Yesu kum'e la Yohana ka gip bom kǝ moni wo, ar ni tǝ ndara kǝti atl kǝ Galili. ");
INSERT INTO plj_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Kan tǝ za bǝn Nazarat, tǝ te Kaparnahum na dǝmi, te bi bar ɓulaka, las tu kan kǝ Zebulun na Naftali ni gwa. ");
INSERT INTO plj_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Kǝ dǝ laa'i argon tu Ishaya mǝn yari shirǝm kǝ Yam yari gwa'e, ");
INSERT INTO plj_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","<<Ki las kǝ Zebulun na las kǝ Naftali kan ra gip kǝti atl kǝ Galili, kǝti atl kǝ munju kan mǝn Yahuda ni da gwa kǝti atl tu kan kop bi bar ɓula gwa na markǝm bar ɓula'i, ar ba su jikat ɓula Urdun gwa. ");
INSERT INTO plj_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Munju ba dǝm gip dǝmǝn shin bar cirtǝn wi. Mǝn dǝmi gip dǝmǝn atl kǝ mǝshtǝno, cirtǝn cwati wur wi.>> ");
INSERT INTO plj_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Tun wokoci ta ni Yesu pare la'i icin shirǝm kǝ Yam tǝ den wultǝn'e, <<Cini atl gam kǝ pal ni kar Yami, domici mulki kǝ Yam mbira kosak wi.>> ");
INSERT INTO plj_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Nan tǝ den kopi bi bar ɓula Galiliwo, ar ni tǝ shin mbarǝm rop, Simon kan ba la ti bi'e Bitǝrus gwa na erǝm gǝs Andǝrawus. Tǝ zam wur den la'i bar kǝ nǝmi kos gǝzǝn gip mal bar ɓula'i domici wi mǝn nǝmi kos ni. ");
INSERT INTO plj_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Tǝ wul wur'e, <<Kopǝn ni, aa pali in mǝn ɗiri mbarǝm karǝmi.>> ");
INSERT INTO plj_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Na zhotǝne, ar ni wu za bar kǝ nǝmi kos gǝzǝnka, kan wu kop ti. ");
INSERT INTO plj_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Nan tə te cinawo, ar ni tǝ pa shin mbarǝm rop, wu ma mǝn gǝpi na mǝn bari ni, Yakubu nya Zabadi na erǝm gǝs Yohana. Tǝ zam wur gip kungǝlǝn jikat mal na bazin Zabadi, wu den kǝrkǝm bar kǝ nǝmi kos gǝzǝni. Kan tǝ la wur bi. ");
INSERT INTO plj_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ar ni wu za kungǝlǝn jikat mali kup na bazini, kan wu kop ti. ");
INSERT INTO plj_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu kop kup gip kǝti atl kǝ Galili, tǝ den kulci gip bom domtǝn kǝ mǝn Yahuda. Tǝ den la'i icin kǝ zo shirǝm dǝmi kǝ Yam gunye, na pǝni kumi dli kǝ ko gonge ciwo kǝ mbarǝme. ");
INSERT INTO plj_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Na untu ni shirǝm den ti ri gip atl kǝ Siriya kup. Na untu ni pi ta ɗiri ti mǝn kumi dli kup, mǝn patǝn na ko gonge ciwo, na mǝn dun itǝri, na mǝn ndetǝn atli, na munju itǝr tle wur dlika gwa. Tǝ warke wur kup. ");
INSERT INTO plj_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ar ni mbarǝm na womti gip kǝti atl kǝ Galili, na kǝta atl kǝ Dikapolis (mir bǝn kutl ituwi), na bǝn Urshalima, na kǝti las kǝ mǝn Yahuda, na kǝti las kǝ te bi ɓula Urdun ka kop ti. ");
INSERT INTO plj_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Nan Yesu shin mbarǝm dom wur na womtiwo, ar ni tǝ to gǝs den gam tlǝndǝre. Nan tǝ dǝmo, ar ni mir mǝn kulci kar ti to kar ti. ");
INSERT INTO plj_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ar ni tǝ kulci wur tǝ wule. ");
INSERT INTO plj_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","<<Mǝn ghol mbatl ni'e munju kan mom na ɗattǝn gǝzǝn gip ruhu gwa. Mulki kǝ Yamo gwazin ni. ");
INSERT INTO plj_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Mǝn ghol mbatl ni'e munju ra na dun mbatl gwa. Yam baa iɗa'i wur mbatli. ");
INSERT INTO plj_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Mǝn ghol mbatl ni'e munju kan pali gam gǝzǝnka atli gwa. Atl kundǝrǝndlip baa dǝm gwazini. ");
INSERT INTO plj_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Mǝn ghol mbatl ni'e munju ba kum guzum na lam pi argon tu kan dlat ni ar ra gwa. Yam baa laa'i wur tu na argon tu wu ndu gwa. ");
INSERT INTO plj_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Mǝn ghol mbatl ni'e munju ra na guna ger gwa. Yam baa kum guna gǝzǝni. ");
INSERT INTO plj_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Mǝn ghol mbatl ni'e munju mbatl gǝzǝn ra ngǝlan gwa. Wi shin Yami. ");
INSERT INTO plj_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Mǝn ghol mbatl ni'e mǝn sitin gip dlom kǝ ɗiri dǝmi zhǝlili. Baa la wur bi mimir kǝ Yami. ");
INSERT INTO plj_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Mǝn ghol mbatl ni'e munju kan ba kumi wur dli den bi pitǝn dlat gwa. Mulki kǝ Yamo gwazin ni.>> ");
INSERT INTO plj_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","<<Kǝn mǝn ghol mbatl ni wokoci tu mbarǝm ba zage ine, wu kumi in dli, wu pa ne in ko gonge ɗasi tu te gamka den kǝn mǝn kopi gǝn ni gwa. ");
INSERT INTO plj_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Untu ni wu kumi dli ga mǝn yari shirǝm kǝ Yam munju kan ra kapǝn kǝn gwa. Gyatl ni kǝ pi ni ghol mbatl na naari, domici argon tu Yam baa bi in to yamkawo ar naari.>> ");
INSERT INTO plj_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","<<Kǝn nǝra wule mas gip atl kundǝrǝndlip. Mas ni njulkawo, na unun ba pali tǝmtǝn gǝs we? Ar i na mbap kǝ pi da'a, se dǝ shotika, dǝ mbarǝm desika.>> ");
INSERT INTO plj_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","<<Kǝn nǝra wule cirtǝn kar mbarǝm den kaar atli. Bǝn tu kan tu to den tudu kawo, ba mani ghundǝr gǝska da'a. ");
INSERT INTO plj_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ba mbǝsh utu gip pitila kan dǝ zup ka na bar gal da'a. Ama ba ne ti ni den ba dǝmi gǝsi, kan ar bi mbarǝm kǝ bomi kup cirtǝni. ");
INSERT INTO plj_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Untu ma, za ni dǝ cirtǝn gin cir cina dǝ mbarǝme, kǝ dǝ wu shin mbuni mbap gin ra, arni wi ɗǝɗa Ba gin kǝ to yamka.>> ");
INSERT INTO plj_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","<<Ba kǝ pǝn ni den a sur ni kǝ dǝ a pika na kulci kǝ Musa, ko rǝshi kǝ ga mǝn yari shirǝm kǝ Yam da'a. A sur ni kǝ dǝ a pa'ika nan wur da'a, ama kǝ dǝ a laa'i wur ni. ");
INSERT INTO plj_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ge shirǝm ni a yari in'e, yam na atl baa paka, ama ko nye njem ko ɗigo gon ra da'a gip Kulci kǝ Musa kan ba pika nari kapǝn dǝ ko unu pi kandatu Kulciyi wule ar baa pi gwa. ");
INSERT INTO plj_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ra'untuwo, kup muntu kan cen nǝm gip Kulci ju ka, kan tǝ pa kulci jen wu cen Kulciyi ka pa'o, baa wul ti'e kali gip mulki kǝ Yami. Ngapo, kup muntu kan kop Kulciyi, kan tǝ kulci jeno, baa wul ti'e mǝn nartǝn gip mulki kǝ Yami. ");
INSERT INTO plj_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","A yari in'e, pitǝn dlat gin ni man kǝ me gam kǝ Parise na mǝn kulci den Kulci kǝ Musa dawo, ki te gip mulki kǝ Yam da'a.>> ");
INSERT INTO plj_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","<<Kǝ kum yari ga kori gǝmi terka'e, <Ba kǝ rini gon eka da'a. Muntu ri gon ekawo, ba hukunte ti.> ");
INSERT INTO plj_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ama a yari ine, kup muntu ba pi lo na esi ma, baa hukunte ti. Muntu es wul esi'e wop mbarǝmo, baa ri ti cina dǝ mǝn tloyi shirǝmi. Eso, muntu wul esi'e kǝdlǝmo, tǝ ndar tetǝn gip utu.>> ");
INSERT INTO plj_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","<<Ra untuwo, kini den bi Yam bar den bagadi sadakawo, kan kǝ dam ki den gon ra nan ki su mbatlkawo, ");
INSERT INTO plj_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","za ari bi bagadiyi kakani, kǝ ri kǝrkǝm dlom gin na ya'iyi, kan kǝ'i bi Yam bar giyi.>> ");
INSERT INTO plj_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","<<Zho'i kǝ ci atl gam na muntu kan ra na shirǝm den ki gwa, kapǝn dǝ ri'i cina dǝ mǝn tloyi shirǝmi. Kini kǝ pi untu dawo, ti la ki am dǝ mǝn tloyi shirǝmi, kan dǝ mǝn tloyi shirǝm byal ki am dǝ dogari, kan dǝ la ki gip bom kǝ moni. ");
INSERT INTO plj_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ge shirǝm ni a yari'i, ki ɗǝl gip bom kǝ moniyi da'a, se kini kǝ ɓatl argon tu ba kop ki kup gwa.>> ");
INSERT INTO plj_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","<<Kǝ kum yari in'e, <Ba kǝ mur ni na mǝtli ko moni kaari da'a.> ");
INSERT INTO plj_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ama a yari ine, muntu kup shin gǝr mǝtli, shintǝn kǝ ndutǝn kǝ ci mbatlo, ya mur nan ti gip mbatl gǝs ituwi. ");
INSERT INTO plj_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ger gǝ kǝ shimli ni ba kem ki kǝ pi warwat pitǝno, ɗǝli kǝ laka. Ar ba mani'i dǝ kǝti kǝ dli gi gon liika, na dǝ la dli gi kup te gip utuka. ");
INSERT INTO plj_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Am gi kǝ shimli ni ba kem ki kǝ pi warwat pitǝno, tlo kǝ laka. Ar ba mani'i dǝ kǝti kǝ dli gi gon liika, na dǝ la dli gi kup te gip utuka.>> ");
INSERT INTO plj_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","<<Yari es'e, <Kup muntu baa kar gǝr gǝskawo, ar nǝm tǝ bi gǝri tǝlankur kǝ kartǝnka.> ");
INSERT INTO plj_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ama argon tu a yari ino arni'e, muntu kup kar gǝr gǝska, ba'e den tǝp kǝ muri na moni kari ni dawo, tǝ kem ti kǝ muri na moni kaari ituwi. Muntu kup gudlumi na gǝr tu kan karkawo, tǝ dǝm mǝn muri na mǝtli kaari ituwi.>> ");
INSERT INTO plj_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","<<Kǝ kum yari ga kori gǝmi terka'e, <Ba kǝ ɓo am atl na atl ko na yam den lar da'a, se de kǝ ɓatl argon tu kǝ pǝni gam gi ki bi Babom gwa.> ");
INSERT INTO plj_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ama a yari ine, ba kǝ ɓoni am atl na atli ko na yam dama, domici to yamka ni'e dandi kǝ Yami. ");
INSERT INTO plj_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ba kǝ ɓo am atli na atl da'a, domici atl ni'e ba ne asǝm gǝsi, ko na bǝn Urshalima domici arni'e bar bǝn kǝ Bar Gunye. ");
INSERT INTO plj_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ba kǝ ɓo ngetl na gam gi da'a, domici ki mani pali ta gam gi gon dunyi ko gholi da'a. ");
INSERT INTO plj_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kup argon tu ki yariwo, ar dlǝr den <Aan> ko <o'o.> Ar ni man untuwo kar Mǝn ɗasi tu ni ɗǝli.>> ");
INSERT INTO plj_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","<<Kǝ kum yari terka'e, <ger den am kǝ ger ni, shin ngapo den am kǝ shin ni.> ");
INSERT INTO plj_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ama a yari in'e bakǝ nge ni mbarǝm mǝn ɗasi tu da'a. Gon ni ɓe'i ankayama den gǝskǝm gi kǝ shimliwo, bali ti nǝmi pa'e. ");
INSERT INTO plj_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Gon ni ri'i cina dǝ mǝn bǝn kǝ dǝ tǝ nǝmi'i lulur gi kawo, za'i tǝ bar kǝ ghuntǝn gi esi. ");
INSERT INTO plj_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Gon ni kem ki kǝ ɓomi asǝm kǝ mil nemo, ri nan ti kǝ mil rop. ");
INSERT INTO plj_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Murgon ni lirki bargono, bi ti. Muntu ngen cigǝri karkiwo, ba kǝ nge ti bika da'a.>> ");
INSERT INTO plj_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","<<Kǝ kum yari'e kǝ ndu ya'i, kǝ nge mǝn nge gi. ");
INSERT INTO plj_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ama a yari ine, ndu ni mǝn nge gini. Shirǝm ni na Yam den mǝn kumi in dli. ");
INSERT INTO plj_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Kǝn ni kǝ pi untuwo arni ki dǝm mimir kǝ ba gin kǝ to yamka. Tǝ kem dǝ pǝt gǝs ɗǝl den ho mbarǝm na wani mbarǝme. Tǝ kem dǝ ghon nde mǝn pitǝn dlat na munju ba pi dlat dagwa. ");
INSERT INTO plj_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kǝn ni kǝ ndu mǝn ju ba ndu kǝn katlo, unun ki zam we? Mǝn nǝmi wurpi bom ma untuni wu pi diya? ");
INSERT INTO plj_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ya'i ni katl kǝ shirmi tiwo, unun kǝ pi kan man jen gwawe? Munju kan mom Yam dama untun wu pi. ");
INSERT INTO plj_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ra'untuwo, dǝm ni na laai kandatu Ba gin kǝ to yamka ra na laa'i gwa.>> ");
INSERT INTO plj_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","<<Ngup kǝnni, ba dǝ pitǝn dlat gin kǝ ɗǝɗa Yam dǝm kǝ shini kǝ ger da'a. Kǝn ni kǝ pi untuwo, ki zam ɓatltǝn kar Ba gin kǝ to yamka da'a. ");
INSERT INTO plj_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Kǝn ni kii bi bar munju am ri wur kar dawo, ba kǝ pini ta shirǝm dene kandatu mǝn se mbarǝm ba pi kǝba domtǝn gǝzǝn na den guntǝp kǝ dǝ mbarǝm ɗǝɗa wur ra. Na ho bi, a yari ine, wu zam ɓatltǝn gǝzǝn ituwi ");
INSERT INTO plj_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ama kǝn ni ki bi bar muntu am ri ti kaar dawo, ba kǝ za ni da murgon mom argon tu kan kǝ pi gwa da'a. ");
INSERT INTO plj_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Na untuni argon tu kǝ biwo ar ba dǝm na ghuuni. Ba gin kan ba shin argon tu ra na ghuuni gwani baa ɓatl kǝne. ");
INSERT INTO plj_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Kǝn ni ki shirǝm na Yamo, ba kǝ pi ni kandatu mǝn pi kǝ shini kǝ ger ba pi gwa da'a. Wu paye ndu'i wu shirǝm na Yam dlor kǝ ba domtǝn kǝ mǝn Yahuda na den tǝpe, kǝ dǝ mbarǝm shin wur ra. Na ho bi, wu tare wu nǝm ɓatltǝn gǝzǝn ituwi. ");
INSERT INTO plj_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ama kǝn ni ki shirǝm na Ba gin Yamo, te ni gin gip kushi, kǝ le ni bǝdlabǝnka, kǝ shirǝm ni na Ba gin kan ra ghuuni gwa. Ba gin kan ba shin argon tu kan ra na ghuuni gwa ba ɓatl kǝne. ");
INSERT INTO plj_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Kǝn ni den shirǝm na Yamo, ba kǝ pi ni ta tlyari shirǝm da'a, kandatu munju kan mom Yam da'a ba pi gwa. Gip shini gǝzǝno, baa kum wur den womti shirǝm gǝzǝni. ");
INSERT INTO plj_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ba kǝ dǝm ni wule wi da'a, domici Ba gin mom argon tu kǝ ndu gwa kapǝn kǝ lir ti. ");
INSERT INTO plj_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ra'untuwo, shirǝm ni na Yam nankǝni, <Ba gǝmi kǝ to yamka, dǝ shin nartǝn kǝ sun gi. ");
INSERT INTO plj_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Dǝ mulki gi suri. Dǝ argon tu kǝ ndu gwa pi den kaar atl kandatu ar ra to yamka gwa. ");
INSERT INTO plj_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Bi mi fingal gǝmi kǝ sekǝni. ");
INSERT INTO plj_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ba kǝ nǝm mi den warwat pitǝn gǝmi da'a, kandatu mǝn ma mǝ pi munju pi mi wani pitǝn gwa. ");
INSERT INTO plj_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ba kǝ za mi mǝ ndaka gip godetǝn da'a. Ama ɗǝli mi am dǝ Mǝn ɗasi tu tu.> ");
INSERT INTO plj_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Kǝn ni kǝ nǝm mbarǝm den wani pitǝn gǝzǝn dawo, Ba gin kǝ to yamka ba nǝm kǝn den warwat pitǝn gin da'a pa'e. ");
INSERT INTO plj_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ama kǝn ni kǝ nǝm mbarǝm den wani pitǝn tu wupi ino, Ba gin ma ti nǝm kǝn den warwat pitǝn gin pa'e. ");
INSERT INTO plj_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Kǝn ni kǝ pi guzum malo, ba kǝ ɓalni ba gerka kandatu mǝn pi shini kǝ ger ba pi gwa da'a. Wu pi ni untu kǝ dǝ mbarǝm mom'e wu den guzum male. Na ho bi ni a yari ine, wu zam ɓatltǝn gǝzǝn ituwi. ");
INSERT INTO plj_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ama ki ni den pi guzum malo, ho ba ger gika, kan kǝ bǝrke mir to gamka, ");
INSERT INTO plj_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","zam ba dǝ mbarǝm mom'e ki den pi guzum mal da'a. Ama Ba gi kan mom argon tu ba pi mol gwa baa ɓatl ki. ");
INSERT INTO plj_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ba kǝ domini gam gin bar kǝ am den kaar atl da'a, las tu kan ghughur ba liika ko ar ruska gwa, las tu kan mur ba mani ɓuli wu pi murika gwa. ");
INSERT INTO plj_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ama domi ni gam gin bar kǝ am gin to kar Yamka. To barta kawo arba ruska da'a, kan ga ghughur ba liika da'a. Mur ba mani ɓuli wu pi murika da'a. ");
INSERT INTO plj_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Las tu kup bar kǝ am gi rawo, lasi ni mbatl gi ba nǝra. ");
INSERT INTO plj_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ger ni'e cirtǝn kǝ dli. Ger gi nǝra lauwo, dli gi kup ba laa'i na cirtǝni. ");
INSERT INTO plj_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ger gi nǝra waniwo, kup dli gi ba laa'i na dǝmǝni. Dǝ wule cirtǝn tu kan ra nan ki dǝmǝnno, dǝmǝni baa nge ger kǝ shini! ");
INSERT INTO plj_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Murgon ra kan baa mani bote babom rop gwa da'a. Ar ba dǝm'e ko tǝ nge nǝmi, tǝ ndu nǝmi, ko tǝ nǝra na nǝmi gip mbatl gǝsi, ko tǝ mbur nǝmi. Ki mani kǝ den bote Yam kan kǝ den bote wurpi es da'a. ");
INSERT INTO plj_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ra'untuwo a yari ine, ba kǝ dam kǝn ni den dǝmi gin da'a? Argon tu ki ci ko ki tla, ko ki la den dli gin gwa. Dǝmi gin na ge mbatl man fingal da'aya, kan dliyi man tutul dli diya? ");
INSERT INTO plj_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Shin ni yatl kǝ to yamka. Wu ngani ko wu rǝsh da'a. Wu pa dom gip ɓindi da'a. Kup na untu, Ba gin kǝ to yamka ni ba ci nan wuri. Ase, kǝ man wur nartǝn diya? ");
INSERT INTO plj_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Woni gip kǝn den damtǝn gǝs baa mani mbǝli nye argon den muri gǝs rawu? ");
INSERT INTO plj_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","To, unun kem kǝ dam kǝn den tutul kǝ dli we? Shin ni buzǝn kin kǝ gip lǝpe, den kandatu wu nar gwa. Wu pi mbap ko wu dlǝm tutul dli gǝzǝn dak. ");
INSERT INTO plj_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Kup na untu a yari ine, ko Solomon na nartǝn gǝs taɓe la'i mbuni tutul dli man kǝ ko nǝm gǝzǝn da'a. ");
INSERT INTO plj_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Dǝ wule untu ni Yam ba pi buzǝn kin kǝ gip lǝp na mbuntǝni, muntu kan ra sekǝni, kan gǝniwo, dǝ la ti gip utuka, kǝn ma tǝ mom nan kǝn diya? Kǝn mǝn heli ngǝshtǝn den Yami! ");
INSERT INTO plj_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ba kǝ dam kǝn ni kǝ wule, <Unun mi ci wu?> Ko <Unun mi tla wu?> Ko <Unun mi la den dli gǝmi we?> ");
INSERT INTO plj_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ba gin kǝ to yamka mom'e kǝ ndu bar ju kup. Munju kan mom Yam da'a ni ba dam wur den bar ju. ");
INSERT INTO plj_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ama kǝno pare ni ngeni mulki kǝ Yam na pitǝn dlat gǝsi, nami bar ju kupo baa bi in esi. ");
INSERT INTO plj_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ra'untuwo, ba kǝ dam kǝn ni den gǝni da'a, domici gǝni baa ɗir na damtǝn gǝsi. Ko gonge pǝt ra na damtǝn gǝsi.>> ");
INSERT INTO plj_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","<<Ba kǝ shin ni bes kǝ murgon da'a, kǝn ma mbarǝm ba shin bes gin da'a. ");
INSERT INTO plj_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kandatu kǝ hukunte mbarǝmo, untu ni kǝn ma ba hukunte in pa'e. Na shandǝr nǝm tu kǝ cingǝriwo, na ri ni ba cingǝri in pa'e. ");
INSERT INTO plj_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Unun kem ki den shini nye jir kǝ te ger dǝ ya'ika, o fawo basi nyash tu te ger da'i kawu? ");
INSERT INTO plj_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Imnu ki mani wuli ya'i'e, <Naa ɗǝli'i nye jir kǝ te ger da'ika,> o fawo basi nyash ra te ger da'ikawe? ");
INSERT INTO plj_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ki mǝn pi shini kǝ gere, ɗǝli basi nyash kǝ te ger gika kakani, arni ki mani shini hoyi kan kǝ'i mani ɗǝli nye jir ya'i ter gerka. ");
INSERT INTO plj_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ba kǝ bini yer argon tu kan dlǝran ni anra gwa da'a. Ba kǝ la'i ni alade zo bar gin da'a. Kǝn ni kǝ pi untuwo, aladeyi baa desika, kan dǝ yeri pal wu tlyat kǝne. ");
INSERT INTO plj_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Pini ta liri ba bi ine, ngen ni ki zami, pini ta ɓe bǝdlabǝni, baa ɓuli ine. ");
INSERT INTO plj_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Muntu kup liriwo ba bi ti. Muntu ngen ngapo ti zami. Muntu ɓo bǝdlabǝno, ba ɓuli ti. ");
INSERT INTO plj_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Woni gip kǝn nya gǝs ni lir ti bǝrediwo, ti bi ti tatwe? ");
INSERT INTO plj_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ko tin tǝ lir ti koso, tǝ bi ti iciwu? ");
INSERT INTO plj_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kǝn mǝn ɗasi tu ma, kǝ mani bi mimir gin ho bari, bare dǝ wule Ba gin kǝ to yamka baa bi munju ba lir ti gwa ho bari. ");
INSERT INTO plj_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Argon tu kup kǝ ndu dǝ mbarǝm pi ino, pi wur ni untu pa'e. Muntu ni'e Kulci kǝ Musa na kulci kǝ ga mǝn yari shirǝm kǝ Yami. ");
INSERT INTO plj_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Te ni gipi tǝp kǝba bǝdlabǝn kan ra met gwa. Rawo bǝdlabǝn tu kan ba ri mbarǝm ewo na ngǝlanyi ni ar ra. Kopi guntǝpi ban da'a, kan mǝn kopi tǝpi ra na womti. ");
INSERT INTO plj_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ama tǝp tu kan mbarǝm ba kop dǝ zam ge mbatlo met ni ar ra. Kopi tǝpi ban naari, kan mǝn kopi tǝpi womti da'a. ");
INSERT INTO plj_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Neni ger ndin, domici mir mǝn yari shirǝm kǝ Yam kǝ lar kan ba ɗir kar kǝn gip tutul dli ka kur tǝm gwa, ama wi yer lǝp ni mǝn kumi guzum naari. ");
INSERT INTO plj_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ki mom wur ni tǝp kǝ ba mbap gǝzǝni. Ba mani kotli mimir inabi den kǝn ire, ko gǝri turum den kin goluma? ");
INSERT INTO plj_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Untuni es ko gonge mbuni kin ba gǝri ni mbuni mimiri, ama wani kin ba gǝri ni wani mimiri. ");
INSERT INTO plj_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Mbuni kin ba taɓe gǝri wani mimir da'a, untu es ar ba pi da'a dǝ wani kin gǝri ho mimiri. ");
INSERT INTO plj_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ko gonge kin kan gǝri ho mimir dawo, ba wotlka dǝ kerika. ");
INSERT INTO plj_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ra'untuwo, ki mani ni momi mǝn yari shirǝm kǝ Yam kǝ lar ju den mbap gǝzǝni. ");
INSERT INTO plj_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ba'e kup mǝn wuli gǝn'e, <Babomi, Babomi> ni baa zam dǝ Yam dǝm gun gǝs da'a. Ama muntu ba pi argon tu Ban kǝ to yamka ndu dǝ pi gwa ni baa zami. ");
INSERT INTO plj_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Na womti gin ba wulǝm'e den pǝta, <Babomi, Babomi, na sun gini mǝ pi wazu diya, kano na sun gini mǝ ɗǝli dun itǝr na pi bar kǝ dlǝkǝntǝn na womti diya?> ");
INSERT INTO plj_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Kan a wul wur'e, <A taɓe momi gin da'a. Tlin ni kǝba gerka kǝn munju nge kopi shirǝm kǝ Yam gwa.> ");
INSERT INTO plj_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ra'untuwo, kup muntu kum shirǝm gǝn tu, kan tǝ pi mbap nariwo, ti ni ra wule mbarǝm mǝn bopya tu kan tu bom gǝs den tat gwa. ");
INSERT INTO plj_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Kan bar ghon ni nda, bula ni la'i, kan itǝr ni hor ghon ni ɓe tor den biniwo, ar ba nda da'a, domici ɓa ni gǝs bini den tate. ");
INSERT INTO plj_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ama kup muntu kum shirǝm gǝni, kan tǝ la gip mbatl gǝs tǝ pi mbap na ri dawo, ti ni wule kǝdlǝm tu kano tu bom gǝs den singes gwa. ");
INSERT INTO plj_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ghon ni nda, kan ɓulani suri, itǝr hor be tor ar ɓo biniwo, kan dǝ bini ndaka, ndetǝni ba nge ger kǝ shini.>> ");
INSERT INTO plj_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Nan Yesu pa'i yari kup shirǝm juwo, ar ni domtǝn kǝ mbarǝmi nǝm bi na am den kulci gǝsi, ");
INSERT INTO plj_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","domici tǝ kulci wur wule muntu ra na iko gwa, ba'e wule kǝ mǝn kulci gǝzǝn den kulci kǝ Musa ni da'a. ");
INSERT INTO plj_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Nan Yesu ɗǝl sur den tlǝndǝro, ar ni mbarǝm na womti kop ti kaari. ");
INSERT INTO plj_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ar ni mbarǝm gon mǝn ndǝcci ɗir ngus cina da ti, kan tǝ wule ti'e, <<Babomi kini kǝ ndu'o, ki palim dlǝran lasi.>> ");
INSERT INTO plj_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu ta am gǝs ti taɓe mbarǝmi, kan tǝ wule, <<A ndu kǝ dǝm dlǝran.>> Ar ri kǝtigon da'a, arni ndǝcci gǝs pa'i. ");
INSERT INTO plj_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ar ni Yesu wul ti'e, <<Ɓashini, ba kǝ yari murgon argon tu kan pi gwa da'a, ama mbǝri, ri kar liɓa kǝ Yam ju wu shin ki, kan kǝ bi wur ɓatltǝn tu kulci kǝ Musa yari dǝ kǝ bi gwa, ar ni mbarǝm kup ba mom'e kǝ warke wi.>> ");
INSERT INTO plj_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Nan Yesu te gip bǝn kǝ Kaparnahumo, arni bar mǝn bi'utu kǝ Roma gon ɗir kar ti, tǝ lir ti kǝ dǝ tǝ ne ti am ra. ");
INSERT INTO plj_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Tǝ wule, <<Babomi, nye mǝn pim mbap gǝn ra rin bomka ɓom, itǝr tle ti dlika, tǝ den kumi dli.>> ");
INSERT INTO plj_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu wul ti'e <<Aa ri warke ti.>> ");
INSERT INTO plj_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ama bar mǝn bi'utuyi bali ti tǝ wule, <<Babomi, a kǝm'e kǝ ri bom da'ǝm da'a. Ama pi shirǝm katl, nye mǝn mbap gǝn ba pal lau. ");
INSERT INTO plj_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Domici ami ma gǝsi dǝ gon ni ami ra, na mǝn bi'utu jen gǝsi da'ǝmi. A wul gon'e, <Rǝka,> kan tǝ ri, gon eso a wul ti'e, <Ɗiri> kan tǝ ɗiri. A wul zher gǝn'e, <Pi nankǝni,> kano, tǝ pi.>> ");
INSERT INTO plj_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nan Yesu kum untuwo, arni tǝ nǝm bi na ame. Kan tǝ wul mǝn kopi kar gǝs'e, <<Na ho bi ni a yari ine, a taɓe zami murgon gip Isra'ila na ngǝshtǝn den Yam na ndǝrtǝn wule kǝ mbarǝm kǝn da'a. ");
INSERT INTO plj_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","A yari ine, jen na womti mǝn ngǝshtǝn den Yam wule muntu baa ɗǝl ɗǝr tor gabǝs na sur yemma wu dǝm kǝ ci nyel na ga kori gǝmi Ibǝrahim, Ishaku, na Yakubu gip dǝmi kǝ Yam gun gǝzǝni. ");
INSERT INTO plj_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ama mǝn Israila kan ndari wu zam dǝ Yam dǝm gun gǝzǝn kan nge gǝzǝno, baa la wur gip bar dǝmǝni, las tu kan wi kul na ngǝngash shine.>> ");
INSERT INTO plj_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ar ni Yesu wul bar mǝn bi'utu kǝ Romayi'e, <<Ndara, ba pi'i den kandatu kǝ ngǝsh ki den Yam gwa.>> Ar ni mǝn pi mbap gǝsi warke gip wokoci tu wu shirǝm gwa. ");
INSERT INTO plj_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Nan Yesu te gip bom kǝ Bitǝruso, ar ni tǝ shin nakon kǝ Bitǝrus ɓom, dli gǝs wi utuka. ");
INSERT INTO plj_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ar ni Yesu taɓe am kǝ nagǝr mǝri, kan wi utu kǝ dliyi ba za ti. Kano nagǝr mǝri ba tlyam tǝ pi ti mbapi. ");
INSERT INTO plj_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Nan sit piwo, ar ni ɗiri munju dun itǝr ba ghunwur gwa na womti kar Yesu. Na yari shirǝm ni katl tǝ ɗǝli wur dun itǝr gǝzǝnka. Kan tǝ warke munju den kumi dli gwa. ");
INSERT INTO plj_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Tǝ pini muntu kǝ dǝ laa'i shirǝm kǝ Ishaya mǝn yari shirǝm kǝ Yam'e, <<Na gam gǝs ni tǝ pǝni mi kumi dli gǝmika, kan tǝ ɗǝli bar ju ba ɗiri holi kumi tǝmi kǝ dlika.>> ");
INSERT INTO plj_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Gasi gon nan Yesu shin mbarǝm na womti gandǝl tiwo, arni tǝ wule dǝ pal te den kǝti bishidi kǝ bar ɓula'i ka. ");
INSERT INTO plj_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Kapǝn wu ndarawo, arni nǝm gip mǝn kulci mbarǝm den kulci kǝ Musa ɗir kar ti, tǝ wule, <<Ba mǝn kulci, aa kop ki las tu ki ri kup gwa.>> ");
INSERT INTO plj_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ama Yesu bali ti'e, <<Yer lǝp ra na shu gǝzǝni, kan ga yatl ra na bin gǝzǝni, ama ami Nya Mbarǝm ra na las tu tǝ mur gwa da'a.>> ");
INSERT INTO plj_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ar ni gon gip mir mǝn kulci kar ti wul ti'e, <<Babomi, za'ǝm kakani, kǝ dǝ a ri bom a kap ban.>> ");
INSERT INTO plj_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ama Yesu wul ti'e, <<Kopǝni, za mǝshi mbarǝm gip ruhu wu kap ezǝn mǝshi mbarǝme.>> ");
INSERT INTO plj_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Nan tǝ te gip kungulǝn jikat malo, arni mir mǝn kulci kar ti kop ti. ");
INSERT INTO plj_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Wule gip jipkǝr gere, nan wu ra den gam malo, arni bar dun yam tli gip bar ɓula'i, kan ba tatl tor gip kungǝlǝn jikat mali. Ama Yesu den nde umuri. ");
INSERT INTO plj_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ar ni mir mǝn kulci kar ti ri putu tika, wu wule, <<Babomi, ɗǝlimi! Mǝ ri kǝ mǝshtǝn wi!>> ");
INSERT INTO plj_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Tǝ nǝmi wur'e, <<Unun kem bǝrti nǝm kǝnka naar untuwu, kǝn mǝn heli ngǝshtǝn den Yami?>> Arni tǝ tlyam kan tǝ matl itǝr na zap mali kan lasi kup ba sa shot. ");
INSERT INTO plj_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ar ni mir mǝn kulci kar ti nǝm bi na ame, kan wu wule, <<Unu badǝr mbarǝm ni'e muntuwe? Ga itǝr na zap mal kup ba kop shirǝm gǝsi!>> ");
INSERT INTO plj_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Nan tǝ cwat gip kǝti bar ɓula'i gip atl kǝ mǝn Garasinawo, ar ni mǝn zhe'e jen rop ɗǝl ter gip gambici'e wu zam ti. Wu dǝmka bar kǝ bǝrtiwi har murgon ba'i mani kopi tǝp lasi da'a. ");
INSERT INTO plj_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ar ni wu la yar wu wule, <<Unun kǝ ndu nan miwu, Nya Yami? Kǝ ɗir ni kǝ dǝ kǝ kumi mi dli kapǝn dǝ wokoci piya?>> ");
INSERT INTO plj_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Te cinaka njem nan wuro, alade jen ra na womti kan den le gǝzǝn gwa. ");
INSERT INTO plj_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Arni dun itǝri lir Yesu, wu wule, <<Kini kǝ ɗǝli mikawo, za mi mǝ te gip alade mǝn womtitǝn ja.>> ");
INSERT INTO plj_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ar ni tǝ wul wur'e, <<Bǝrni!>> Kan wu ɗǝl gip mbarǝm mi wu te gip aladeyi, arni aladeyi yem sur bi tlǝndǝr na kǝtǝr wu su ro gip bar ɓula'i, wu mǝsh su gip malika. ");
INSERT INTO plj_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Mǝn le aladeyi kǝtǝr te gip bǝnika, wu yari bar ju kup kan pi na mbarǝm mǝn dun itǝri gwa. ");
INSERT INTO plj_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Mbarǝm kǝ bǝni kup ɗǝl ɗir kǝ dǝ wu mo na Yesu. Nan wu shin tiwo, arni wu lir ti dǝ tǝ za'i wur kǝti atl gǝzǝni. ");
INSERT INTO plj_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ar ni Yesu to gip kungǝlǝn jikat male, tǝ jikat bar ɓula'i tǝ te gip bǝn gǝs Kaparnahum. ");
INSERT INTO plj_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Mbarǝm jen ɗiri ti mbarǝm gon kan itǝr tle ti dli kagwa, ɓom den ba muri. Nan Yesu shin ngǝshtǝn den Yam gǝzǝno, arni tǝ wul muntu itǝr tle tikayi'e, <<Ba ar ghunki da'a, nya gǝni, pǝni'i warwat pitǝn gi kawi.>> ");
INSERT INTO plj_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Na kumi untuwo, ar ni jen gip mǝn kulci mbarǝm den kulci kǝ Musa dami gip mbatl gǝzǝn wu wule, <<Mbarǝm tu ba cingǝr gam gǝs na Yami.>> ");
INSERT INTO plj_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ama Yesu mom damtǝn gǝzǝni, ar ni tǝ wule, <<Unun kem kǝn kǝ wani damtǝn gip mbatl ginwe? ");
INSERT INTO plj_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ar mani na dǝ wule, <Pǝni'i warwat pitǝn gi kawi,> ko dǝ wule, <Tlyam kǝ desi?> ");
INSERT INTO plj_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ama nan a ndu kǝ mom'e Nya mbarǝm ra na iko kǝ pǝni warwat pitǝnka den kaar atlo>> ar ni tǝ wul muntu itǝr tle ti amika'e, <<Tlyami, pǝn bamuri gi, kǝ ndara bomi.>> ");
INSERT INTO plj_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Kan mbarǝmi ba tlyam tǝ ndara bomi. ");
INSERT INTO plj_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nan domtǝn kǝ mbarǝmi shin argon tu piwo, arni bǝrti nǝm wur naari, kan wu ɗǝɗa Yam muntu bi mbarǝm mani pi untuyi gwa. ");
INSERT INTO plj_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Nan Yesu ri cinawo, ar ni tǝ shin mbarǝm gon mǝn sun Matta, njon kǝba nǝmi wurpi bomi. Yesu wulti'e, <<Kopǝni.>> Kan Matta ba tlyam tǝ kop Yesu. ");
INSERT INTO plj_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Den kaar kǝ untuwo, Yesu den ci fingal rǝn bom da Matta kawo, ar ni mǝn nǝmi wurpi bom na mǝn warwat pitǝn na womti ɗir dǝm wu den ci fingal nan ti na mir mǝn kulci kar ti. ");
INSERT INTO plj_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nan mǝn me gam kǝ mǝn Parise shin untuwo, ar ni wu gen momi kar mir mǝn kulci kar ti'e, <<Unun kem mǝn kulci gin ba ci na mǝn nǝmi wurpi bom na mǝn warwat pitǝn we?>> ");
INSERT INTO plj_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Nan Yesu kum untuwo, ar ni tǝ wule, <<Ba'e munju kan ra lau ni ba ndu mǝn bi un da'a, ama mǝn kumi dli ni. ");
INSERT INTO plj_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ama ri kulci ni kǝ mom ni argon tu shirǝm kǝ Yam yari gwa, <Amo dǝmi na guna ger ni a ndu kar kǝne, ba'e mboshim dabba gip bota ni da'a.> A sur ni kǝ dǝ a la bi mǝn pitǝn dlat da'a, ama mǝn warwat pitǝne.>> ");
INSERT INTO plj_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Gasi gono mir mǝn kulci kar Yohana mǝn pi Batisma ri kar Yesu kǝ dǝ wu ngen momi kar ti, wu wule, <<Unun kem min na mǝn me gam kǝ mǝn Parise ba pi guzum male, ama mir mǝn kulci kar ki ba pi da'a?>> ");
INSERT INTO plj_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ar ni Yesu nǝmi wur tǝ wule, <<Berǝm kǝ mǝn pel gǝr baa pi ni dun mbatl wokoci tu wura kǝ ba gudlumiyi na mǝn pel gǝri ya? Wokoci den ɗirtǝne nan ba pǝni wur mǝn pel gǝri kagwa. Wokoci ta ni wi pi guzum male. ");
INSERT INTO plj_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Untu ni esi, woni ba jep pel tutul den gus tutul dliwe? Domici gus tutul dliyi ba tlyatka ar man kǝ far tlyattǝni. ");
INSERT INTO plj_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Untuni esi, murgon ba shoti pel mal kin inabi su gip kor zurum ka kuur da'a. Tini tǝ pi untuwo, pel mal kin inabi tu ba tatl kuur tuka kan ar shotka, kuuri eso ar lika ituwi. Untuni da'a, pel mal kin inabiwo, dǝ shot ti gip pel zurum ka kuri, na untu ni pel mal gǝri kin inabiyi kup na zurumi baa sa ra.>> ");
INSERT INTO plj_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Nan tǝ gip shirǝm nan wuro, ar ni bari kǝ bom domtǝn kǝ mǝn Yahuda gon ngus cina dati, tǝ wule, <<Kǝkǝn tuni nya gǝn nye mǝtli mǝshka. Ama ɗir kǝ ne am den ti, tǝ pal ra na ge mbatli.>> ");
INSERT INTO plj_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ar ni Yesu tlyam na mir mǝn kulci kar ti, kan wu ri na mbarǝmi. ");
INSERT INTO plj_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Gip untuwo arni nagǝr gon muntu kan bǝran ba shot gip ti kǝ sheti ghon kutl cet rop ɗir tǝp kaar dati, tǝ ne am den bi lulur gǝsi. ");
INSERT INTO plj_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Tǝ wul tor mbatl'e, <<Ami ni a ne am den tutul dli gǝs katlo, a warke.>> ");
INSERT INTO plj_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Nan Yesu bali ger tǝ shin tiwo, arni tǝ wul ti'e, <<Ba ar ghun ki da'a, nya gǝni, ngǝshtǝn den Yam gi warke iwi.>> Ar ri kǝtǝ gon da'a, ar ni nagǝri warke. ");
INSERT INTO plj_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Nan Yesu mbubar bom dǝ bari kǝ mǝn kopi na mbarǝmiwo, se tǝ shin mǝn hori mǝzhele na mbarǝm na womti den ta kulu. ");
INSERT INTO plj_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ama Yesu wul wur'e, <<Tli ni bar tu. Nye gǝri mǝsh nika da'a, umur ni ti dene.>> Arni wu gyatli ti gip mburtǝne. ");
INSERT INTO plj_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Nan kar mbarǝmi te kari kawo, ti te gipi tǝ nǝm am kǝ nye gǝri, kan nye gǝri ba tlyami. ");
INSERT INTO plj_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Shirǝm bar kǝ dlǝkǝntǝn tu ri gip kǝti atli kup. ");
INSERT INTO plj_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Nan Yesu ci cina na ritǝno, ar ni tabi moni jen rop kop ti, wu den wultǝn'e, <<Gǝsgal kǝ Dauda! Kum guna gǝmi.>> ");
INSERT INTO plj_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Nan tǝ te gip bom gono, ar ni tabiyi kop ti teka, kan tǝ wul wur'e, <<Kǝ nǝm gip mbatl gǝn'e aa mani warke gina?>> Arni wu nǝmi ti'e, <<Aan, Babomi.>> ");
INSERT INTO plj_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Kan tǝ ne am den ger gǝzǝn tǝ wule, <<Den bi ngǝshtǝn gin demǝn ni, ar ba dǝmi in untu.>> ");
INSERT INTO plj_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ar ni ger gǝzǝn ɓul kan wu mani shini bari. Kan Yesu ba dǝli wur kǝm hoyi, tǝ wule, <<Ba kǝ yari ni murgon argon tu kan pi gwa da'a.>> ");
INSERT INTO plj_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ama wu ndarawo arni wu pi ta yari argon tu tǝ pi wur gwa gip atli kup. ");
INSERT INTO plj_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Wu den bi za'i lasi ituwi, kan ba ɗǝri ti mbarǝm gon mǝn dun itǝr kan ba mani shirǝm dagwa. ");
INSERT INTO plj_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Nan Yesu ɗǝli ti dun itǝrikawo, ar ni mbarǝmi nǝm shirǝmi. Domtǝn kǝ mbarǝmi nǝm bi na am wu wule, <<Mǝ taɓe shini argon pi wule muntu gip Isra'ila da'a.>> ");
INSERT INTO plj_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ama mǝn me gam kǝ mǝn Parise wule, <<Na ndǝrtǝn kǝ gun dun itǝr ni tǝ ɗǝli dun itǝri.>> ");
INSERT INTO plj_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu kop gip ga bǝni kup na gip mir bǝn kǝ bi lǝpi, tǝ den pi wazu na kulci wur zo shirǝm kǝ mulki kǝ Yam gip ba domtǝn kǝ mǝn Yahuda. Tǝ den warke gǝzǝn den ko gonge kumi dli na ciwo kan ba ghun wur gwa. ");
INSERT INTO plj_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nan tǝ shin nartǝn kǝ domtǝn kǝ mbarǝmo, guna ci ti den wuri, domici wura den ta ndotǝne. Mǝn ne wur am ra da'a, wule tǝm ju kan ra na mǝn tle gǝzǝn dagwa. ");
INSERT INTO plj_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ar ni tǝ wul mir mǝn kulci kar ti'e, <<Kǝni naari, ama mǝn rǝshi kǝni ngapo njem ni wura. ");
INSERT INTO plj_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ra'untuwo, lir ni Babom mǝn rǝshi kǝni, tǝ kari in bar ra na mǝn mbap wu rǝshi ti kǝni.>> ");
INSERT INTO plj_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu la bi mir mǝn kartǝn gǝs kutl cet rop (12), tǝ bi wur iko wu ɗǝli dun itǝr na warke mǝn kumi dli, na ko gonge ciwo. ");
INSERT INTO plj_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Sun kǝ mir mǝn kartǝn gǝs kutl-cet ropi ni'e, kǝ nǝm Simon (muntu ba la ti bi'e, Bitǝrus gwa) na esi Andǝrawus. Yakubu nya Zabadi na esi Yohana. ");
INSERT INTO plj_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filibus, Bartolomi, Toma, na Matiyu mǝn nǝmi wurpi bomi. Yakubu nya Alpayus, na Tadawus. ");
INSERT INTO plj_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon mǝn ghuve kǝ bǝn gǝsi, Yahuda Iskariyoti, muntu kan bi Yesu kagwa. ");
INSERT INTO plj_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Wi kutl cet ropi ni Yesu kar wur na la'i wur tat cina'e, <<Ba kǝ rǝni cina dǝ munju kan mǝn Yahuda ni da gwa, ko kǝ teni gip bǝn kǝ mǝn Samariya. ");
INSERT INTO plj_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ama rǝni kar tǝm kǝ Isra'ila kan jilka gwa. ");
INSERT INTO plj_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Kǝn ni kǝ ri gwa lani icin kǝ wul ni'e, <Mulki kǝ Yam mbira wi kosak.> ");
INSERT INTO plj_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Warke ni kumi dli kǝ mbarǝm ka, tli ni munju kan mǝsh kǝ pali ni munju kan ra na ndǝcci gwa dlǝran, kǝ ɗǝli ni dun itǝrka. Bi in ni, kǝn ma bi ni pa'e. ");
INSERT INTO plj_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ba kǝ pǝn ni wurpi kǝ zǝnariya, ko azurpa, ko mundu gip posh gin da'a. ");
INSERT INTO plj_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ba kǝ pǝn ni posh gip ɓomi asǝm gin da'a, ko tutul dli goni, ko kaptǝlanye, ko dlo, domici muntu kan pi mbapo tǝ ndari dǝ bi ti argon tu tǝ ndu gwa. ");
INSERT INTO plj_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Bǝn tu kǝ te gipi kup, ko mir bǝn kǝ markǝmiwo, ngen ni ho mbarǝm kan gip bǝni gwa, kǝ dǝm ni gip bom gǝzǝn ar ri gas tu ki za lasi gwa. ");
INSERT INTO plj_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Kǝn ni kǝ te gip bomiwo, kǝ shirmi ni mǝn bomi. ");
INSERT INTO plj_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","In ho mbarǝm ni gip bomiwo, lir ni Yam kǝ dǝ tǝ bi wur dǝmi zhǝlili, ama in ho mbarǝm ni dawo, ba dǝ Yam bi wur dǝmi zhǝlili da'a. ");
INSERT INTO plj_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Gon gǝzǝn ni nge nǝmi gini, ko nge kumi shirǝm gin kawo, na kǝ za bomi ko bǝniwo bat ni kushka kǝ asǝm ginka lasi. ");
INSERT INTO plj_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ge shirǝm ni a yari in'e, ba kum guna den bǝn kǝ Sodom na Gomora gas tloyi shirǝm ar man kǝ bǝn tu. ");
INSERT INTO plj_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Aan, a kar kǝn ni wule tǝm gip dlom kǝ yer lǝpe. Se kǝ dǝm ni na wayo wule ici'e, na dǝmi bat na ɓarna wule kuburi. ");
INSERT INTO plj_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ama ngup kǝn ni na mbarǝm ju, domici wi ta kǝn am dǝ mǝn bǝni, kan dǝ ɓo in na rǝɓa gip bom domtǝn gǝzǝni. ");
INSERT INTO plj_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Baa ɗir kǝn cina dǝ kiri kǝ bǝni, na ga gunye, domici gǝni, kǝ dǝ kǝ la ni icin kǝ zo shirǝm demǝni cina da wuri, na munju kan mǝn Yahuda ni dagwa. ");
INSERT INTO plj_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ama wini wu nǝm kǝno, ba ar ghun kǝn ni den argon tu ki yari gwa da'a. Baa bi in argon tu ki yari gwa gip wokociyi. ");
INSERT INTO plj_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kǝn ni ki dǝm mǝn shirǝmi da'a. Ruhu kǝ Yam ni ba shirǝm tǝp kar kǝne. ");
INSERT INTO plj_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Erǝm ba bi erǝm gǝska kǝ dǝ ri ti eka, bǝba ba bi nya gǝska, untuni es mimir ba tli gam mǝn gǝri gǝzǝn wu kem dǝ ri wur eka. ");
INSERT INTO plj_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Mbarǝm kup ba nge ine domici gǝni. Ama muntu kup ɓa mbatl dlom gam bari patǝn kǝ baro, ti zam ɗǝltǝne. ");
INSERT INTO plj_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","In kumi in dli gip bǝn kǝno, ri ni gin gip bǝni kǝ cina. Ge shirǝm ni a yari ine, kapǝn kǝ pa'i kopi mir bǝn kǝ Isra'ilawo Nya Mbarǝm baa pal sur wi. ");
INSERT INTO plj_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Nye mǝn kulci baa man muntu ba kulci ti gwa da'a, ko dǝ wule dǝ zher man babom gǝsi. ");
INSERT INTO plj_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ar ndari dǝ nye mǝn kulci dǝm wule muntu ba kulci ti gwa, zhero tǝ dǝm wule babom gǝsi. Tun nan ami babomi la'ǝm bi Ba'alzabu gun dun itǝro, imnu ba la bi mir mǝn bomiwe? ");
INSERT INTO plj_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ama ba kǝ kum ni bǝrti gǝzǝn da'a. Argon ra kan ra na ghupi kan baa ɓulka den kari dagwa, argon ra na ghuuni kan ba hol momi da gwa. ");
INSERT INTO plj_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Argon tu a yari in gip dǝmǝno, yari ni kǝ ba cirtǝni. Argon tu a yari in su kǝm kawo, la ni icin deni dǝ ko gonge mbarǝm kumi. ");
INSERT INTO plj_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ba kǝ kum ni bǝrti kǝ mǝn ri mbarǝm eka da'a, domici wi mani ri ruhu kǝ mbarǝm eka da'a. Ama kum ni bǝrti kǝ Yami, muntu kan ba mani li dlika, na la'i mbatli gip utu gwa. ");
INSERT INTO plj_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ba wur ni mir yatl ropka den kabarshu nǝm diya? Yatl gon ra kan ba nda atl bat na momi kǝ Ba gin gwa da'a. ");
INSERT INTO plj_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ta gam gin ma na dlǝmi ni ar ra. ");
INSERT INTO plj_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ra'untuwo, ba dǝ bǝrti ci in ni da'a, nartǝn gin man kǝ yatl hoyi. ");
INSERT INTO plj_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Muntu kup sede ti gwan ni cina dǝ mbarǝmo, ami ma aa sede'e ti gwan ni cina dǝ Ban kǝ to yamka. ");
INSERT INTO plj_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Muntu kup nge sede ti gwan ni cina dǝ mbarǝmo, ami ma aa nge sede'e ti gwan ni cina dǝ Ban kǝ to yamka. ");
INSERT INTO plj_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ba kǝ pǝn ni'e, a siri in ni dǝmi zhǝlili den kaar atl da'a! A siri in ni dǝmi zhǝlili da'a, se dlanye. ");
INSERT INTO plj_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","<A sur ni kǝ dǝ a haɗe nya na base, nye mǝtli na nase, gǝr kushi na nakon gǝsi. ");
INSERT INTO plj_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Mbarǝm kǝ bom nǝm baa dǝm mǝn nge babomi.> ");
INSERT INTO plj_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Muntu ba ndu bas ko nas manǝmo, tǝ kǝm tǝ dǝm gwan da'a. Muntu kan es ba ndu nya gǝs moni ko nye mǝtli nar manǝmo, tǝ kǝm tǝ dǝm gwan da'a. ");
INSERT INTO plj_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Muntu kup pǝn kin kǝ ɓa'i gam gǝs dene tǝ kopǝn dawo, tǝ kǝm dǝmi gwan da'a. ");
INSERT INTO plj_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Muntu kup ndu ge mbatl gǝso, ti hol zami gǝsi. Ama muntu kup kan hol ge mbatl gǝs den bi gǝno, ti zam ge mbatli. ");
INSERT INTO plj_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Muntu kup nǝm kǝno, amin tǝ nǝmǝni. Muntu nǝmǝn ngapo, tǝ nǝm ni muntu karǝm sur gwa. ");
INSERT INTO plj_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Muntu kup nǝm mǝn yari shirǝm kǝ Yam den ti mǝn yari shirǝm kǝ Yamno, ti zam albarka kǝ mǝn yari shirǝm kǝ Yami. Muntu es nǝm mǝn pitǝn dlat, den ti mǝn pitǝn dlatno, ti zam albarka kǝ mǝn pitǝn dlat. ");
INSERT INTO plj_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Muntu kup bi wuro mal mǝn iɗatǝn nǝm gip mir heli mimir ju den ti mǝn kopi gǝnno, a yari ine, ti hol zami albarka gǝs da'a.>> ");
INSERT INTO plj_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Nan Yesu pa'i pi shirǝm ju mir mǝn kulci kar ti kutl cet ropiwo, ar ni tǝ za lasi tǝ ndara gip kǝti atl kǝ mǝn Galili tǝ ci cina na kulci na la'i icin kǝ shirǝm kǝ Yam gip mir bǝn gǝzǝni. ");
INSERT INTO plj_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Wokoci tawo le Yohana ka gip bom kǝ moni, kan tǝ kum bar ju Almasihu den pi, arni tǝ kar mir mǝn kartǝn gǝs wu ri tambe Yesu. ");
INSERT INTO plj_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Wu wul ti'e, <<Ki ni'e mbarǝm tu kan mǝn den ɓuti gwaya, ko mǝ ɓut gon esi?>> ");
INSERT INTO plj_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu nǝmi wur tǝ wule, <<Pal ni rǝn kar Yohanaka, kǝ yari tǝ ni argon tu kǝ shin kan kǝ kum gwa. ");
INSERT INTO plj_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Tabi den zami shini, kurki den desi, mǝn ndǝcci den zami dǝmi dlǝran, munju ba kum dama wu den kumi, den tli munju kan mǝsh kagwa, ba pi wazu munju kan am ri wur kar dagwa. ");
INSERT INTO plj_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Mǝn albarka ni'e, munju nge kopi gǝn den kandatu ami ra gwa da'a.>> ");
INSERT INTO plj_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Nan mir mǝn kartǝn kǝ Yohanayi ndarawo, ar ni Yesu pi mbarǝm ju ra lasi gwa shirǝm den Yohana tǝ wule, <<Unun kǝ shin rǝn bi lǝpka ya? Wosh kan itǝr ba kaɗe gwana? ");
INSERT INTO plj_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ko kǝ ɗǝl ni kǝ shini mbarǝm tu kan la mbuni tutul dli gwa? O'o, untu ni dawo, unun kǝ ri kǝ shini we? Gip shini gino, kii shin ni mbarǝm mǝn ho tutul dliya? Ai mǝn kemi ho tutul dliwo bom dǝ gun ni wu nǝra. ");
INSERT INTO plj_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","To, unun kǝ ɗǝl kǝ shiniwe? Mǝn yari shirǝm kǝ Yama? Aan, a yari ine, tǝ man mǝn yari shirǝm kǝ Yam nartǝni. ");
INSERT INTO plj_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ti ni'e mbarǝm tu rǝsh den ti gip shirǝm kǝ Yam gwa'e, <Aa kar nye mǝn kartǝn bar gǝn cina da'i, muntu kan baa kǝrkǝmi'i guntǝp gi gwa.> ");
INSERT INTO plj_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","A yari in ge shirǝmi, gip munju mǝtli ni gǝr wuro, gon ra kan nar man Yohana mǝn pi batisma gwa da'a. Ama muntu kan'e heli gip mulki kǝ Yamo, tǝ man ti. ");
INSERT INTO plj_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Tun wokoci kǝ Yohana mǝn pi batisma har kǝkǝni, den ta la'i icin kǝ shirǝm kǝ dǝmi kǝ Yam gun gip mbatl kǝ mbarǝme, ama kǝkǝno ko gonge mbarǝm den ta totǝn kǝ tetǝne. ");
INSERT INTO plj_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Domici kulci kǝ Musa na tǝlankur kǝ ga mǝn yari shirǝm kǝ Yam kup pini kǝ mulkiyi kapǝn cwattǝn kǝ Yohana. ");
INSERT INTO plj_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Kǝn ni kǝ nǝm argon tu wu yariwo, ti ni'e Iliya tu kan yari'e ti sur gwa. ");
INSERT INTO plj_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Muntu kup ra na kǝm kǝ kumiwo, naa tǝ kumi. ");
INSERT INTO plj_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","To, na unun aa ngash mbarǝm kǝ zhan kǝnwe? Wini wule mimir kan den cet gip deɓǝr gwa, wu den la'i bi berǝm cet gǝzǝn wu den wultǝn'e, ");
INSERT INTO plj_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","<Mǝ hori in mǝzhele ama kǝ dlar da'a, mǝ wuli in kon kulu keti, ama kǝ kul da'a.> ");
INSERT INTO plj_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Artu Yohana mǝn pi batisma ɗir tǝ pi ta ci na tle dawo, kǝ wule, <Ti mǝn itǝr ni.> ");
INSERT INTO plj_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ar tu Nya Mbarǝm ɗir ti den ci na tlewo, ar ni kǝ wule, <Mǝn totǝn den ci na tle ni, berǝm kǝ mǝn nǝmi wurpi bomi, na mǝn warwat pitǝne.> Kup na untu, mǝ mani ni shini bopya kǝ Yam tǝp kǝ ba argon tu tǝ pi gwa.>> ");
INSERT INTO plj_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ar ni Yesu matl mir bǝn ju kan tǝ pi mbap kǝ nǝmi bi na am gip wur gwa, ama wu ci atl gam da'a. ");
INSERT INTO plj_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","<<Bar kǝ guna ni'e kǝn mbarǝm kǝ bǝn kǝ Korazina! Bar kǝ guna ni'e kǝn mbarǝm kǝ bǝn kǝ Betsaida! Na dǝ wule bar kǝ nǝmi bi na am ju kan pi gip kǝn gwa ni pi gip Taya na Sidono, na wu ci atl gam na la'i lusguru, wu den hurwa na wi mudlǝr sur gam wi. ");
INSERT INTO plj_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ama a yari in'e gas tloyi shirǝmo, baa kum guna kǝ mbarǝm kǝ Korazina na Betsaida man kǝ Taya na Sidon. ");
INSERT INTO plj_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kǝn mbarǝm kǝ Kaparnahum ngapo, kǝ shin wule, baa ɗǝɗa kǝn ni ar to yama? O' o baa pali in ni atli, kǝ ba dǝmi kǝ mǝshtǝni. Dǝ wule bar kǝ nǝmi bi na am ju pi gip kǝn ni pi gip Sodomo, na tii nǝra har sekǝni. ");
INSERT INTO plj_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ama a yari inka, gas pǝt tloyi shirǝmo, ba kum guna kǝ mbarǝm kǝ Sodom ar man kəne.>> ");
INSERT INTO plj_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Gip wokoci tawo, arni Yesu wule, <<A goode'i, Bǝba na Babom kǝ yam na atli, domici kǝ ghundǝri bar jen mǝn bopya na mǝn momi bar kǝ atl kǝnka, kan kǝ ɓuli heli mimiri. ");
INSERT INTO plj_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Aan, untu ni Bǝba, domici untu ni ar mbuni'i. ");
INSERT INTO plj_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ko gonge baro Bǝba bim kawi. Murgon ra kan mom Nyayi gwa da'a, se Bǝbayi, eso murgon ra kan mon Bǝbayi gwa da'a, se Nyayi, na muntu kan Nyayi ndu kǝ tǝ ɓuli ti momi gwa. ");
INSERT INTO plj_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ar ni Yesu wule, ɗir ni karǝmi kup gin kan ar banyi in wi, kan es den patǝn na giɓǝr gosgam gwa, aa bi in shukutǝni. ");
INSERT INTO plj_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Pǝn ni shirǝm gǝn wule kandatu tla gi kǝn ba pǝn dlo ɓali witta gi kǝn den yar gwa, kan kǝ kulci ni karǝmi, domici ami mǝn ghalǝm mbatl ni, mǝn pali gamka atli, ki zami gam gin shukutǝni. ");
INSERT INTO plj_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Domici kulci gǝn ban da'a, kan gosgam gǝn ngapo hoptan ni ar ra.>> ");
INSERT INTO plj_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Den pǝt shukutǝn kǝ mǝn Yahuda gono, Yesu den kopi gip kǝn alkama. Mir mǝn kulci kar ti ngapo wu den kumi guzumi ar ni wu nǝm marti gam alkamayi wu den ci. ");
INSERT INTO plj_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ama nan jen gip mǝn Parise shin untuwo, ar ni wu wul ti'e, <<Shinca, mir mǝn kulci kar ki den pi argon tu kulci kǝ Musa wule ba dǝ pi da'a gas shukutǝn gwa.>> ");
INSERT INTO plj_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ar ni Yesu nǝmi wur tǝ wule, <<Kǝ taɓe ni zhiti argon tu Dauda pi wokoci tu tǝ kum guzum, nan ti na mbarǝm gǝs gwa da'a ya? ");
INSERT INTO plj_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Kandatu tǝ te gip bom kǝ Yami, kan wu ci bǝredi tu kan neka markǝme, kup na ar ndari'e wu ci da'a se mǝn keri bar ju ɗiri Yam gwa ni katl ba ci. ");
INSERT INTO plj_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Eso kǝ taɓe ni zhiti gip tǝlankur kulci kǝ Musa diya? Kandatu liɓa kǝ Yam ba cen doka kǝ pǝt shukutǝnka den ko gonge pǝt shukutǝni gip bom kǝ Yam, ama ar dǝm'e warwat pitǝn ni wu pi da'a. ");
INSERT INTO plj_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","A yari ine, muntu kan man bom kǝ Yam gwan kǝni. ");
INSERT INTO plj_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","O na kǝ mom ni argon tu rǝsh gwa'e, <Amiwo guna ger ni a ndu'e kǝ nǝra nari, ba'e mboshi bar dǝ ta'i Yam ni katl ghunǝm da'a.> Na kii shin wani pitǝn kǝ munju hol wani pitǝn gwa da'a. ");
INSERT INTO plj_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Domici Nya mbarǝm ni'e Babom kǝ pǝt shukutǝni.>> ");
INSERT INTO plj_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Nan Yesu za lasiwo, ar ni tǝ te kǝ ba domtǝn kǝ mǝn Yahuda. ");
INSERT INTO plj_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Mbarǝm gon ra lasi muntu kan itǝr tle ti am ka gwa. Ar ni wu gen momi kar Yesu wu wule, <<Tǝlankur kulci kǝ Musa yari den'e dǝ pǝni mǝn kumi dli kumi dli gǝska den pǝt shukutǝna?>> Wu yari ni untu kǝ dǝ wu ri ti cina ni. ");
INSERT INTO plj_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesu nǝmi wur tǝ wule, <<Woni gip kǝn kan tǝm gǝs nǝm ni nda shuka den pǝt shukutǝno, tii ɗǝli ti tor ka dawu? ");
INSERT INTO plj_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Mbarǝm man tǝm naari! Ra'untuwo, tǝlankur kulci kǝ Musa nge'e dǝ pi ho bar den pǝt shukutǝn da'a.>> ");
INSERT INTO plj_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ar ni Yesu wul mbarǝmi'e, <<Ta am gi.>> Ar ni tǝ ta ami, kan ba pal lau wule ami mǝn nǝm. ");
INSERT INTO plj_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ama mǝn Pariseyi ɗǝl gǝzǝn kan wu bali kandatu wii pi wu ri Yesu eka gwa. ");
INSERT INTO plj_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Nan tǝ mon argon tu wu den ndu'i pi kawo, ar ni tǝ za lasi. Mbarǝm na womti kop ti, kan tǝ pǝni mǝn kumi dli kup kumi dli gǝzǝnka. ");
INSERT INTO plj_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ama tǝ dǝli wur kǝm den'e ba wu yari murgon ko ti woni da'a. ");
INSERT INTO plj_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Untu pini kanda tu Yam yari bi dǝ mǝn yari shirǝm kǝ Yam Ishaya gwa'e, ");
INSERT INTO plj_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","<<Zher gǝn kǝni muntu kan a zǝzari, muntu a ndu gwa, nan ti ni a pi ghol mbatl hoyi. Aa laa'i ti na Ruhu gǝni, Tii pi la'i icin kǝ tloyi shirǝm kan ra dlat gwa den atl na womti. ");
INSERT INTO plj_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Tii tli yar yam ko tǝ shirǝm na mati yar ko dǝ kum yar gǝs den ko gonge tǝp da'a. ");
INSERT INTO plj_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Wosh tu kan tatl kawo, tii cenka da'a, utu pǝtǝla tu kan bari kǝ mǝshtǝnkawo, tii mǝshka da'a, se ti ni tǝ kem dǝ pitǝn dlat ci cina. ");
INSERT INTO plj_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Gip sun gǝs ni munju kan mǝn Yahuda ni da'a kup baa la mbatli.>> ");
INSERT INTO plj_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ar ni wu ɗiri ti mbarǝm gon kan ngubbi ni, tabi ni, kan ra es na dun itǝr gwa. Yesu warke ti, kan tǝ mani shirǝmi, na shini bari. ");
INSERT INTO plj_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ar ni mbarǝm kup nǝm bi na ame, kan wu wule, <<Muntu ni'e Nya Dauda tu diya?>> ");
INSERT INTO plj_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ama nan mǝn Parise kum untuwo, ar ni wu wul ezǝn'e, <<Na iko kǝ Ba'alzabu gun kǝ dun itǝr ni mbarǝmtu ba ɗǝli dun itǝr ju.>> ");
INSERT INTO plj_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Nan Yesu mon damtǝn gǝzǝnkawo, ar ni tǝ wule, <<Mulki tu kup kan tatlka bomi rop kan den shini bes kǝ esiwo, mulkiyi ba dlǝr da'a. Kup bǝn ko bom na mbarǝm ju kan tatlka bomi ropo, bǝni ko bomi ba dlǝr da'a. ");
INSERT INTO plj_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Shetan ni ba ɗǝli shetano, tǝ den dlan na gam gǝs ituwi. To imnu mulki gǝs ba dlǝr rawu? ");
INSERT INTO plj_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","O na iko kǝ Ba'alzabu ni a ɗǝli dun itǝro, to mbarǝm gin fa? Na iko kǝ woni wu ɗǝli dun itǝr we? Mbarǝm gin ni baa tloyi in shirǝm den muntu. ");
INSERT INTO plj_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ama na Ruhu kǝ Yamni a ɗǝli dun itǝro, dǝmi kǝ Yam gun gip mbatl kǝ mbarǝm ɗir kar kǝn ituwi. ");
INSERT INTO plj_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Kii mani tetǝn gip bom kǝ ndǝri mbarǝm kǝ yemi ti barka da'a, se ki ni kǝ ɓal ti kakani, kan kǝ'i mbu tetǝn gip bom gǝs kǝ yemi ti barka. ");
INSERT INTO plj_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Muntu kan ra namǝn dawo, mǝn gapa na mǝn ni, kan muntu kup nem amra gip domi dawo, mǝn gǝzanyika ni. ");
INSERT INTO plj_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ra'untuwo a yari ine, baa gaparte mbarǝm ko gonge warwat pitǝn gǝs na shirǝm mburtǝn gǝsi. Ama muntu yari mǝgǝn shirǝm den Ruhu kǝ Yamo, baa gaparte ti da'a. ");
INSERT INTO plj_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Muntu kup pi mǝgǝn shirǝm den Nya mbarǝmo, ba gaparte ti, ama muntu kan pi mǝgǝn shirǝm den Ruhu kǝ Yamo, ba gaparte ti da'a, ko kǝkǝni ko gas patǝn kǝ bar kup. ");
INSERT INTO plj_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ho kin ni ba gǝri ho mimiri, wani kin ni ba gǝri wani mimiri. Ba mani ni momi kin den mimir ju tǝ gǝri gwa. ");
INSERT INTO plj_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Kǝn badǝr kǝ wonzi! Imnu kii mani yari ho bari, nan kǝn mǝn ɗasi tu ni gwawu? Domici argon tu kan ra su gip mbatlka gwani bi ba yari. ");
INSERT INTO plj_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mbarǝm mǝn zo mbatlo, tor gip zo mbatl gǝs ni tǝ pi ho shirǝmi, mǝn ɗasi tu ngapo gip ɗastǝn kǝ tu gǝs ni tǝ ɗǝli wani bari. ");
INSERT INTO plj_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","A yari ine, kup mǝgǝn shirǝm tu kan mbarǝm yariwo, tii dlǝm na nǝm nǝm gas tloyi shirǝmi. ");
INSERT INTO plj_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Den shirǝm gi ni ba tloyi'i shirǝmi, ko ar kem kǝ dǝm mǝn ho pitǝne ko mǝn wani pitǝne.>> ");
INSERT INTO plj_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ar ni jen gip mǝn Parise na mǝn kulci mbarǝm den tǝlankur Kulci kǝ Musa wul ti'e, <<Ba mǝn kulci, mǝ ndu'e kǝ pi mi bar kǝ dlǝkǝntǝn kan ba gode'e sur kar Yamni kǝ ɗǝl gwa.>> ");
INSERT INTO plj_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ar ni Yesu nǝmi wur tǝ wule, <<Mbarǝm kǝ zhan kǝn mǝn ɗasi tu'e, mǝn nge pitǝn dlat den ngeni dǝ pi wur argon tu kan ba gode'e sur kar Yam ni a ɗǝl gwa. Ama baa pi wur bar kə dləkəntən gon da'a, se bar kǝ dlǝkǝntǝn wule muntu kan zam mǝn yari shirǝm kǝ Yam Yunana gwa. ");
INSERT INTO plj_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Wule kandatu Yunana pi muri myakan pǝt na gas gip tu dǝ bar koso, untu ni es Nya Mbarǝm ba pi muri myakan pǝt na gas gip gam bici'e. ");
INSERT INTO plj_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Gas tloyi shirǝmo, mbarǝm kǝ Nineba ba tlyam na mbarǝm kǝ zhan kǝni, mǝn Nineba ba gode mbarǝm kǝ zhan kǝn den wu pi dlat da'a. Domici mǝn Ninebawo, wu ci atl gam den wazu kǝ Yunana, ar tu muntu kan man Yunana gwan kǝni ama wu ci atl gam da'a. ");
INSERT INTO plj_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Gas tloyi shirǝmo, Gun kǝ Sheba gǝr mutli baa tlyam na mbarǝm kǝ zhan kǝni, tǝ gode wur'e wu pi dlat da'a. Domici tǝwo, ɗir kǝ ba dlyami las ni tǝ ɗǝli, kǝ dǝ tǝ kum shirǝm bopya kǝ gun Solomon, ar tu muntu kan man Solomon gwan kǝni ama kǝ kum ti da'a. ");
INSERT INTO plj_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Dun itǝr ni ɗǝl ka gip mbarǝmo, tǝ ɗǝl ni tǝ nǝm nǝtltǝn las tu kan mal ra da gwa den ngeni ba shukutǝni, ama ti ni tǝ zam ba shukutǝni dawo, ");
INSERT INTO plj_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","se tǝ wule, <Aa pal rǝn bom gǝnka las tu a ɗǝl gwa.> Ti ni tǝ pal lasi, tǝ zam bomi koni, kan tǝ shin sar bomika, kǝrkǝmi kawo, ");
INSERT INTO plj_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","se dǝ dun itǝri pal rǝnka tǝ ngen jen gudǝli nyingi munju kan man ti ɗasi tu gwa, wu ɗir dǝm gip bomi. Dǝmi kǝ mbarǝmi baa man kǝ far wantǝni. Untu ni ar baa dǝmi mbarǝm kǝ zhan kǝni.>> ");
INSERT INTO plj_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Nan Yesu den shirǝm na womti mbarǝmiwo, se nas na mir mǝn gǝpi gǝs ni jǝn dlor kaari den ɓuti kǝ dǝ wu shirǝm nan ti. ");
INSERT INTO plj_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ar ni gon wul Yesu'e, <<Nǝna gi na ga mir mǝn gǝpi gi ra te kaari ka, wu den ndu'i shirǝm nan ki.>> ");
INSERT INTO plj_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ar ni Yesu nǝmi ti, tǝ wule, <<Woni'e nǝna gǝni? Eso ga woni'e mir mǝn gǝpi gǝnwe?>> ");
INSERT INTO plj_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ar ni tǝ ta am den mir mǝn kulci karti tǝ wule, <<Nǝna na mir mǝn gǝpi gǝn ju! ");
INSERT INTO plj_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kup murgon tu ba pi argon tu Ban kǝ to yamka ba ndu dǝ piwo, ti ni'e mǝn gǝpi gǝn mǝtli na moni na nǝna gǝni.>> ");
INSERT INTO plj_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Gasi ni Yesu ɗǝl gip bomi, kan tǝ ri dǝm bi bar ɓula'i. ");
INSERT INTO plj_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ar ni mbarǝm na womti gandǝl tika, kan tǝ to gip kungǝlǝn jǝkat mal tǝ dǝm gipi, ar ni mbarǝm kup dlǝr bi ɓula'i. ");
INSERT INTO plj_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Yesu yari wur bar na womti, na misali tǝ wule. <<Mǝn kǝn gon ra ri gip kǝn gǝs kǝ ngani badǝre. ");
INSERT INTO plj_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tǝ gip ngani badǝri ituwi, ar ni badǝri jen ro den tǝpe kan yatl ba ɗir ɗamika. ");
INSERT INTO plj_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Badǝri jen ba ro den atl kan ra den sǝla, kan ba yatl bǝle-bǝle domici atl ra lasi hoyi da'a. ");
INSERT INTO plj_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ama nan pǝt mato, ar ni badǝri kerka kan ba konka, domici wi ra na tlǝrti hoyi da'a. ");
INSERT INTO plj_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Kan badǝri jen ba ro gip lundume, nan wu naro kan lundumi ba tla wurka. ");
INSERT INTO plj_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Eso, ar ni badǝri jen ro den ho bar atli, kan ba yetli ar ba bi ge, geyi jeno hauya nantam, jeno hauya myakan jen eso hauya nǝm na kutl. ");
INSERT INTO plj_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Muntu kan na kǝm kumiwo, naa tǝ kumi!>> ");
INSERT INTO plj_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ar ni mir mǝn kulci kar ti wul ti'e <<imnu kǝ shirǝm na mbarǝm na ngashi den bar jen we?>> ");
INSERT INTO plj_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesu nǝmi wur tǝ wule, <<Kǝno bi in momi sǝrri kǝ mulki kǝ to yamka, ama wiwo bi wur da'a. ");
INSERT INTO plj_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Muntu kan ra na baro baa mbǝli ti ra, ti zam ra naari. Muntu kan ra na bar da ngapo, ba nǝm nye jem tu kan tǝra narika gwa. ");
INSERT INTO plj_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Argon tu kem A shirǝm nan wur na ngashi den bar jen gwa ni'e, <Ko wu zhit ma, wii shin da'a, ko wu kar na kǝmma, wii kum ko wu mom argon tu ba yari gwa da'a.> ");
INSERT INTO plj_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Den wur ni shirǝm kǝ mǝn yari shirǝm kǝ Yam Ishaya laa'i e, <Wii pi ta kumi ama wii mom da'a, eso wii pi ta zhiti ama wii shin da'a ko njem. ");
INSERT INTO plj_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Domici mbatl kǝ mbarǝm ju raka na lati, wu kesh kǝm gǝzǝn kawi bǝse wu kumi, wu le ger gǝzǝn kawi bǝse wu shin na ger gǝzǝni wu pa kum na kǝm gǝzǝni. Ra'untuwo, ger gǝzǝn ba shin da'a, ko wu kum na kǝm gǝzǝni, kǝ dǝ mbatl gǝzǝn pǝn wu pal karǝm a warke wur ra.> ");
INSERT INTO plj_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ama kǝn mǝn albarka ni domici ger gin ba shini, eso kǝm gin ba kumi. ");
INSERT INTO plj_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Na ho bi ni a yari ine, mǝn yari shirǝm kǝ Yam na mǝn pitǝn dlat na womti ndu shini argon tu kǝn den shini gwa, ama wu shin da'a, wu pa ndu kumi argon tu kǝn den kumi gwa, ama wu kum da'a.>> ");
INSERT INTO plj_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","<<Kum ni argon tu misali kǝ mǝn ngani kǝn tu ba shirǝm deni gwa. ");
INSERT INTO plj_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Muntu kum shirǝm kǝ Yam kan tǝ mom kandayi dawo, Shetan mǝn ɗasi tu'i baa ɗir tǝ tus argon tu kan ngani gip mbatl gǝska gwa. Muntu ni'e badǝr tu kan nda den tǝp gwa. ");
INSERT INTO plj_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Badǝr tu kan nda den alt kan ra den sǝla wo, ti ni'e, muntu kan na kumi shirǝm kǝ Yamo, se tǝ nǝm na ghol mbatli. ");
INSERT INTO plj_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ama nan tǝ ra na tlǝrti dawo, tǝ daɗe da'a. Wokoci tu ghuntǝn ko kumi dli zam ti den shirǝm kǝ Yamo, se tǝ za tǝpka. ");
INSERT INTO plj_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Badǝr tu kan nda gip lundumo, ti ni'e mbarǝm tu kan kum shirǝm kǝ Yami, ama damtǝn kǝ atl na ndu'i bar kǝ am tlaa shirǝmika, kan shirǝmi i mani pi ti ho bar da'a. ");
INSERT INTO plj_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Baɗǝr tu kan nda den ho atl ngapo, ti ni'e mbarǝm tu kan kum shirǝm kǝ Yam na momi argon tu shirǝmi yari gwa. Tǝ pi mbap nari tǝ gǝr mimir gucipi hauya nantam (100), gono hauya myakan, (60) gon ngapo hauya nǝm na kutl (30).>> ");
INSERT INTO plj_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ar ni Yesu pa yari wur shirǝm es'e, <<Mulki kǝ Yam nǝra wule mbarǝm tu kan ngani ho badǝr gip kǝn gǝs gwa. ");
INSERT INTO plj_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Nan mbarǝm kup den umuro, ar ni mǝn nge gǝs ri ngani badǝr jir gip kǝn alkamayi, kan tǝ ndara won gǝsi. ");
INSERT INTO plj_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Nan alkamayi nar den ɗǝli gamo, ar ni jiri ma tli tori. ");
INSERT INTO plj_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ar ni ga zher kǝ Babomi ri wul ti'e <Babomi, ho badǝr ni mǝ ngani gip kǝn gi da'aya? Im ni jir pa yetl gipi we?> ");
INSERT INTO plj_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ar ni Babomi bali wur'e <Mǝn nge gǝn ni pi untu.> Ar ni ga zher gǝsi wul ti'e, <Kǝ ndu mǝ ri tus jiri kaya?> ");
INSERT INTO plj_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ama Babomi wul wur'e, <O'o,> den tusi jiri kawo, ki tuska na alkamayi. ");
INSERT INTO plj_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Za ni wu nar tare ar ri gas rǝshi. Wokoci tani a yari mǝn rǝshi kǝni'e wu pare tloyi jiri wu ɓalka ɗap-ɗap kǝ dǝ keri ka, kan alkamayi ngapo dǝ ri ɓindika.>> ");
INSERT INTO plj_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu pa shirǝm nan wur na misali tǝ wule, <<Mulki kǝ Yamo ar nǝra wule ge mastad, kan mbarǝm gon pǝn kan tǝ ngani gip kǝn gǝs gwa. ");
INSERT INTO plj_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kup na ar ni'e heli gip badǝr kup, ama ti ni tǝ naro, ar ba man nami mir kini, ar ba ɓo am har dǝ yatl zam ba tu'i bin gǝzǝn den ami.>> ");
INSERT INTO plj_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu pa yari wur shirǝm gon es tǝ wule, <<Mulki kǝ Yamo ar ni wule yisti, muntu kan nagǝr gon kushkǝli gip ɗapti shandǝr myakan kan ba nga ɗaptiyi kup gwa.>> ");
INSERT INTO plj_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Shirǝm ju kup Yesu yari domtǝn kǝ mbarǝmi wo, tǝ yari wur na misali den bar jeni. ");
INSERT INTO plj_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Bar ju pi ni kup kandatu mǝn yari shirǝm kǝ Yam Ishaya yari gwa'e, <<Aa shirǝm nan wur na misali den bar jeni, aa yari wur argon tu kan ra na ghuuni terka na ne gǝs kǝ pi atl kundǝrǝndlip gwa.>> ");
INSERT INTO plj_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ar ni Yesu za domtǝn kǝ mbarǝmi tǝ te gip bomi. Kan mir mǝn kulci karti ba ɗir kar ti wu wule, <<Yari mi kanda kǝ jir kǝ gip kǝn tu ngapi.>> ");
INSERT INTO plj_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Tǝ nǝmi wur tǝ wule, <<Muntu kan ngani ho badǝriwo, ti ni'e Nya Mbarǝme. ");
INSERT INTO plj_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Kǝni ngapo arni'e atl kundǝrǝndlip, ho badǝriwo wi ni'e mimir kǝ mulki kǝ yami. Jiri ngapo wi ni'e mimir kǝ mǝn ɗasi tu tu. ");
INSERT INTO plj_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Kano mǝn nge gǝn kan ngani jiri ni'e shetan. Wokoci rǝshi ni'e patǝn kǝ atl kundǝrǝndlip. Mǝn rǝshi kǝni ni'e mir mǝn kartǝn kǝ Yami. ");
INSERT INTO plj_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Wule kandatu ba dom jir dǝ keri kawo, untu patǝn kǝ atl kundǝrǝndlip baa nǝra. ");
INSERT INTO plj_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nya Mbarǝm baa kar mir mǝn kartǝn gǝsi wu dom bar ju kup ba kem mbarǝm kǝ pi warwat pitǝn gwa, na mǝn pi wani bari, dǝ ɗǝli wurka gip mulki kǝ yami. ");
INSERT INTO plj_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Dǝ la wur te gip bom kǝ utuka. Barta ni wi kul na ngasi kur bi. ");
INSERT INTO plj_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Mǝn pitǝn dlat ngapo wi cir wule pǝt gip mulki kǝ Bazini. Muntu kup na kǝm kumiwo, naa tǝ kumi.>> ");
INSERT INTO plj_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","<<Mulki kǝ Yamo wule bar kǝ am ni kan ghundǝrika gip kǝn gwa. Mbarǝm ni zamo, se tǝ ri ghundǝrika gip kǝni esi, na ghol mbatl gǝsi kan tǝ wur argon tu tǝra narika kup, kan tǝ wur kǝni.>> ");
INSERT INTO plj_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","<<Eso, mulki kǝ Yamo wule ba mǝn bar pǝtni ar ra, mǝn ngeni zo tat ju ba wurka gwa. ");
INSERT INTO plj_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Nan tǝ zam zo tat mǝn wurpi hoyiwo, se tǝ ri wur argon tu kup tǝra nari ka gwa kan tǝ wur tati.>> ");
INSERT INTO plj_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","<<Eso, mulki kǝ Yamo wule, zan shar nǝmi kos ni ar ra, kan la gip mal dǝ nǝm ko gonge badǝr kos gwa. ");
INSERT INTO plj_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nan wu dǝl shari tor bishidi la'i na koso, ar ni mǝn nǝmi kosi dǝm kan wu zǝzar ho kos wu wi gip shari, kan munju kos ni dawo wu wika. ");
INSERT INTO plj_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Untuni ar baa dǝm gas patǝn kǝ atl kundǝrǝndlip. Mir mǝn kartǝn kǝ Yam baa ɗǝli mǝn ɗasi tuka gip mǝn pitǝn dlat, ");
INSERT INTO plj_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","wu la mǝn ɗasi tu'i te gip bom utuka, lasi ni wi kul na ngasi kur bi.>> ");
INSERT INTO plj_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu ngen momi kar wur tǝ wule,<<Kǝ mani momi bar ju kup a kulci in gwa wa?>> Ar ni wu nǝmi ti wu wule, <<Aan.>> ");
INSERT INTO plj_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ar ni tǝ wul wur'e, <<Ra untuwo, kup mǝn kulci mbarǝm den kulci kǝ Musa nan zam kulci den mulki kǝ yamo, ti ni wule babom tu kan ɗǝli bar kǝ am gǝs peli na gusi gwa.>> ");
INSERT INTO plj_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Nan Yesu pa'i yari shirǝm den bar juwo, ar ni tǝ za lasi. ");
INSERT INTO plj_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Tǝ pal su Nazarat ka, bǝn gǝsi. Ar ni tǝ nǝmi kulci mbarǝm gip bom domtǝn gǝzǝni, kano ko gonge gǝzǝn ba nǝm bi na am wu wule, <<Ako ni tǝ zam bopya na bar kǝ dlǝkǝntǝn juwe?>> ");
INSERT INTO plj_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ti nya kapinta tu ni diya? Eso nas ni'e, Maryamu da'aya? Kan mir ezǝn ni'e ga Yakubu na Isubu na Saminu na Yahuda diya? ");
INSERT INTO plj_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Mir ezǝn mǝtli eso, mǝn ra nan wur diya? Akoni mbarǝn kǝn zam bopya na bar kǝ dlǝkǝntǝn ju kam? ");
INSERT INTO plj_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ar ni lo ci wur den ti. Ama Yesu wul wur'e, <<Ba ɗǝɗa mǝn yari shirǝm kǝ Yam ko ako ama bat na bǝn gǝs na gip bom gǝsi.>> ");
INSERT INTO plj_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Lasiwo, Yesu pi bar kǝ dlǝkǝntǝn womti da'a domici kǝ holi ngǝshtǝn gǝzǝn den Yami. ");
INSERT INTO plj_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Gip wokoci ta ni gun Hirudus kum kiri bar ju Yesu den pi gwa, ");
INSERT INTO plj_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ar ni tǝ wul mǝn pi ti mbap'e, <<Muntuwo, Yohana mǝn pi batisma ni tli gip mǝshi mbarǝme, ar ni kem tǝ pi bar kǝ nǝmi bi na am ju ra.>> ");
INSERT INTO plj_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Domici gip muri jawo, Hirudus kem nǝm Yohana, ba ɓal ti, kan ba la ti gip bom moni domici kǝ Hirudiya nagǝr kǝ esi Filibus. ");
INSERT INTO plj_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Den'e Yohana yari ti'e, <<Ar ndari kǝ gudlumi na Hirudiya da'a.>> ");
INSERT INTO plj_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Hirudus ndu'e, tǝ ri Yohana eka, ama bǝrti ci ti den mbarǝme, domici wu pǝn'e Yohanawo mǝn yari shirǝm kǝ Yam ni. ");
INSERT INTO plj_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ama nan gas nyel kǝ dami pǝt gǝri kǝ Hirudus ɗiro, ar ni nya Hirudiya nye mǝtli dlar cina dǝ mbarǝme, ar kon Hirudus naari. ");
INSERT INTO plj_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ar ni Hirudus ɓe nyayi am atl tǝ wul ti'e, tii bi ti kup argon tu tǝ liri gwa. ");
INSERT INTO plj_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Kan nasi nyayi ba yari ti argon tu tii liri gwa, ar ni tǝ wule, <<Dǝ bim gam kǝ Yohana mǝn pi batisma gip gal kin kǝkǝni.>> ");
INSERT INTO plj_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ar ni dun mbatl nǝm gun Hirudus hoyi. Ama tǝ tare tǝ ɓo am atl kawi, na wotli bi gǝs cina dǝ kiri kǝ ba ci, tǝ bi bi dǝ bi ti. ");
INSERT INTO plj_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Tǝ kem ba kotǝl gam kǝ Yohana kan ra gip bom moni gwa. ");
INSERT INTO plj_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ba ɗǝri gam kǝ Yohana mǝn pi batismayi gip gal kini, ba bi nye gǝri kan tǝ bi nase. ");
INSERT INTO plj_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ar ni mir mǝn kulci kar Yohanayi ɗir pǝn dli gǝs kan wu kapka. Kan wu ri yari Yesu argon tu pigwa. ");
INSERT INTO plj_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Nan Yesu kum untuwo, ar ni tǝ to gip kungǝlǝn jikat mal kan tǝ ndara las tu mbarǝm ra dagwa. Ama nan mbarǝm kum untuwo, ar ni wu ɗǝl ɗir gip mir bǝn gǝzǝni wu kop ti den asǝm rǝn las tu tǝ ra kagwa. ");
INSERT INTO plj_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Nan Yesu ɗǝl sur gip kungǝlǝn jikat mali kan tǝ shin domtǝn kǝ mbarǝm na womtiwo, ar ni guna ci ti den wuri, kan tǝ pǝni jen kumi dli gǝzǝnka. ");
INSERT INTO plj_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nan sit piwo, ar ni mir mǝn kulci kar ti ɗir kar ti, wu wul ti'e, <<Ɗewo gip lǝp ni, mbarǝm ra da'a, artu gas den ndetǝn wi. Ar baa mani kǝ za mbarǝm ju wu ndara wu ri gip mir bǝn jen wu wur fingal wu ci diya?>> ");
INSERT INTO plj_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ama Yesu nǝmi wur tǝ wule, <<Ba'e ar nǝm ni dǝ mbarǝmi ndara da'a. Bi wur ni fingal wu ci.>> ");
INSERT INTO plj_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ar ni mir mǝn kulci kar Yesuyi wul ti'e, <<Miwo, bǝredi nantam na kos rop ni katl mǝn ra nari.>> ");
INSERT INTO plj_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Tǝ wul wur'e <<Ɗirim ni ɗe.>> ");
INSERT INTO plj_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kan Yesu ba wul mbarǝmi'e, wu dǝm atl den jiri. Tǝ pǝn bǝredi nantam na kos ropi, tǝ tli gam tǝ goode Yam kan tǝ cecceni tǝ bi mir mǝn kulci kar ti wu bi domtǝn kǝ mbarǝmi. ");
INSERT INTO plj_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kup gǝzǝn ba ci wu laa'i tu gǝzǝni, kan wu dom mir roɓǝs burodiyi nan sagwa, ba laa'i shar kutl-cet rop. ");
INSERT INTO plj_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Womtitǝn kǝ mbarǝm ju kan ci fingali pi wule moni bar kǝ zangu nantam (5,000) bat na mǝtli na mimiri. ");
INSERT INTO plj_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ar ni Yesu wul mir mǝn kulci kar tiyi'e, wu to gip kungǝlǝn jikat male wu kur jikati te bi shidiyi bartaka. Kan tǝ za mbarǝmi wu ndara. ");
INSERT INTO plj_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nan tǝ za mbarǝmi wu ndarawo, ar ni tǝ to den tlǝndǝr kǝ dǝ tǝ shirǝm na Yami. Tǝra to den tlǝndǝrika nangǝsi ba ri bi siti. ");
INSERT INTO plj_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ama wokociyiwo kungǝlǝn jikat mali ra te dlom bar ɓula'ika zab mal den dǝli gǝs ɗe na barta, domici itǝr mǝn nartǝn den gapa na kungǝlǝn jikat mali. ");
INSERT INTO plj_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kǝ bǝtloni, bar kǝ gǝlla am myakano, ar ni Yesu bǝtl gam te kar kungǝlǝn jikat malika, tǝ den desi den gam mali. ");
INSERT INTO plj_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ama nan mir mǝn kulci kar ti shin ti den desi den gam malo, ar ni bǝrti ci wuri, wu la yar gip bǝrti wu wule, <<Tlon ni!.>> ");
INSERT INTO plj_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Na zhotǝne ar ni Yesu nǝmi wur tǝ wule, <<Ba ar ghun kǝn ni da'a, mi ni. Ba dǝ bǝrti ci in ni da'a.>> ");
INSERT INTO plj_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ar ni Bitǝrus nǝmi ti tǝ wule, <<Babomi, ki ni fawo, bim bi a desi te den gam malka, a te kar ki.>> ");
INSERT INTO plj_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesu wul ti'e, <<teri.>> Ar ni Bitǝrus ɗǝl sur gip kungǝlǝn jǝkat mali tǝ nǝm desi tǝ den tetǝn kar Yesu. ");
INSERT INTO plj_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ama nan Bitǝrus shin ndǝrtǝn kǝ itǝriwo, ar ni bǝrti ci ti, tǝ nǝm sitǝnka gǝs male. Kan tǝ la yar tǝ wule,<<Babomi ɗǝli mi!>> ");
INSERT INTO plj_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ar ni Yesu nǝm am kǝ Bitǝrus na zhotǝne tǝ dǝl ti tor tǝ wul ti'e, <<Ki mǝn kali ngǝshtǝn den Yami, unun zote'i la'i mbatl gi demǝn kawu?>> ");
INSERT INTO plj_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Nan wu to gip kungǝlǝn jikat maliwo, ar ni itǝri za wultǝne. ");
INSERT INTO plj_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ar ni munju kan ra gip kungǝlǝn jikat mali ba bote ti wu wule, <<Na ho bi, ki Nya Yam ni.>> ");
INSERT INTO plj_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Nan wu jikat bar ɓula'iwo, ar ni wu dlǝr gip bǝn Janisarata. ");
INSERT INTO plj_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Nan mbarǝm kǝ bǝni mom'e Yesuno, ar ni wu kar bar dǝ yari ko gonge mbarǝm kan ra gip mir bǝn kǝ lasi, kan wu ɗiri munju kup den kumi dli gwa kar ti. ");
INSERT INTO plj_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ar ni wu liri Yesu den dǝ mǝn kumi dliyi ne am den bi tutul dli gǝs katl. Kup mǝn kumi dliyi kan ne am den tutul dliyiwo, ar ni wu warke. ");
INSERT INTO plj_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Gip untuwo ar ni mǝn Parise na mǝn kulci doka kǝ Musa jen ɗǝl tor Urshalima wu ri kar Yesu wu ngen momi kar-ti, wu wule, ");
INSERT INTO plj_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","<<Unun kem mir mǝn kulci kar ki ba nge pi al'ada tu kiri gǝmi wule dǝ pi gwa wu? Wu ho am gǝzǝn, kan wu'i ci fingal da'a!>> ");
INSERT INTO plj_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ar ni Yesu nǝmi wur tǝ wule, <<Kǝno, unun kem kǝ cen doka kǝ Yamka den bi al'ada ginu? ");
INSERT INTO plj_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Domici Yam wule, <Kǝ bi nartǝn bǝba, na nǝna gi> kano, <Kup muntu zage bas ko naso, ar nǝm dǝ ri ti eka.> ");
INSERT INTO plj_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ama kǝ kulci mbarǝm'e, gon ni wul bas ko nas'e, <Argon tu ndari a bi ino, a tare a bi Yam kawi,> ");
INSERT INTO plj_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ar nǝm tǝ bi nartǝn mǝn gǝri gǝs da'a ituwi. Den bi kǝ al'ada gino, kǝ pali shirǝm kǝ Yamka wop ituwi. ");
INSERT INTO plj_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Kǝn mǝn setǝne! Kor ni ar ra nan mǝn yari shirǝm kǝ Yam Ishaya yari den kǝn gwa'e. ");
INSERT INTO plj_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","<Mbarǝm juwo na bi ni katl wu ɗǝɗa'ǝmi, ama mbatl gǝnzǝno ar dlyam ka na mǝni. ");
INSERT INTO plj_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Katl ni wu bote mi. Doka kǝ mbarǝm ni wu kulci jen den bi shirǝm kǝ Yami.> >> ");
INSERT INTO plj_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesu la bi domtǝn kǝ mbarǝmi ɗir kar ti, tǝ wul wur'e, <<Kum ni kǝ mom ni argon tu ar kǝ yari in gwa. ");
INSERT INTO plj_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ba'e argon tu mbarǝm ba ci gwa ni ba li ti da'a, ama argon tu ba ɗǝl ter bi da ti gwa ni ba li ti.>> ");
INSERT INTO plj_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ar ni mir mǝn kulci kar ti ɗir wu tambe ti wu wule, <<O kǝ mom'e lo ci jen gip mǝn Parise ju den argon tu kǝ yari gwaya?>> ");
INSERT INTO plj_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesu nǝmi wur tǝ wule, <<Badǝr tu kup kan yetl muntu kan Ban kǝ to yamka ni ngani dawo, baa tuska na gǝsi. ");
INSERT INTO plj_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Za wur ni, ga tabi ni'e mǝn nǝmi dlo ezǝn tabi. Ngapo tabi ni ba nǝmi esi tabi dlowo, kup gǝzǝn wi nda shuka.>> ");
INSERT INTO plj_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ar ni Bitǝrus wul ti'e, <<Yari mi kanda kǝ shirǝm tu.>> ");
INSERT INTO plj_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu wule wur'e <<Har kǝkǝn gam gin i'ni su tat kaya?>> ");
INSERT INTO plj_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","<<Kǝ mom ni den'e, argon tu kǝ ci te bikawo, tu ni ba su kan ar'i ɗǝl kaari da'aya? ");
INSERT INTO plj_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ama argon tu ba ɗǝl ter biwo, tor mbatl ni ba ɗǝli, eso ar ni ba li mbarǝm cina dǝ Yami. ");
INSERT INTO plj_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Domici tor gip mbatl ni damtǝn kǝ wani pitǝn ba ɗǝli, wule ga ri mbarǝm eka, muri na gǝr ko kos kǝ goni, muri na jen kan ndari da gwa, pi mure, seda kǝ lare na lii mbarǝm gami. ");
INSERT INTO plj_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Munju ni ba li mbarǝme, ba'e ho'i am kan dǝ'i nde ci fingal ni da'a.>> ");
INSERT INTO plj_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Kan Yesu ba za lasi, tǝ ndara kǝti atl kǝ Taya na Sidon. ");
INSERT INTO plj_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Lasi ni nagǝr gon mǝn Kan'ana tli yar yam tǝ wule, <<Babomi, Nya Dauda, shin guna gǝni! Dun itǝr ne den kumi nya gǝn nye mǝtli dli hoyi.>> ");
INSERT INTO plj_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ama Yesu wul ti'e argon da'a. Ar ni mir mǝn kulci kar ti ɗir kar ti wu lir ti wu wule, <<Kar nagǝr tu tǝ ndara ngapi, domici tǝ ghun mi na kulu wi.>> ");
INSERT INTO plj_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesu nǝm tǝ wule, <<Amo kar tǝm kǝ Isra'ila kan jilka gwa ni katl karǝmi.>> ");
INSERT INTO plj_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ama nagǝri ngus cina dǝ Yesu tǝ wule, <<Babomi, nem am ra.>> ");
INSERT INTO plj_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu bali ti tǝ wule, <<Ar ndari dǝ pǝn fingal kǝ mimir dǝ bi yer da'a.>> ");
INSERT INTO plj_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Nagǝri wule, <<Untu ni ar ra Babomi, ama yer ma wu ci roɓǝs fingal ju kan ba ro sur den tebǝl kǝ Babom gǝzǝn gwa.>> ");
INSERT INTO plj_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Kan Yesu ba wul nagǝri'e, <<Ngǝshtǝn gi den Yamo ar naari! Nǝmi'i lirtǝn gi wi.>> Ar ni nya gǝs warke gip wokociyi. ");
INSERT INTO plj_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ar ni Yesu za lasi, tǝ su kop bi bar ɓula kǝ Galili. Kan tǝ to den tlǝndǝr tǝ dǝm toka. ");
INSERT INTO plj_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kan mbarǝm na womti ba ɗir kar ti, wu ɗiri ti munju itǝr tle wur kagwa, na ga tabi, ga kurki, na ga ghup bi, na nami mǝn kumi dli na womti, wu ne wur cina da ti kan tǝ pǝni wur kumi dli gǝzǝnka. ");
INSERT INTO plj_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ar ni mbarǝm kan ra lasi gwa nǝm bi na ame nan wu shin munju kan ghup bi ni den shirǝmi, munju itǝr tle wurka pal lauwi, kurki den desi, na munju kan tabi ni den shiniwi. Ar ni wu ɗǝɗa Yam kǝ Isra'ila. ");
INSERT INTO plj_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ar ni Yesu la bi mir mǝn kulci kar ti tǝ wul wur'e, <<Guna ba cim den mbarǝm ju, domici muri myakan ikǝnwi wu ra namǝni, wura na fingal da'a. A ndu'e wu ndara na guzum da'a, bǝse wu ɗatka den tǝpe.>> ");
INSERT INTO plj_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ar ni mir mǝn kulci kar ti wul ti'e, <<Ako ni mii zam fingal tu kan baa kǝm mbarǝm na womti ju gip lǝp kǝnu?>> ");
INSERT INTO plj_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu ngen momi kar mir mǝn kulci kar ti tǝ wule, <<Bǝredi mǝne ni kǝn ra nari?>> Wu wul ti'e, <<Nyingi, na mir kos jeni.>> ");
INSERT INTO plj_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yesu wul domtǝn kǝ mbarǝmi'e, wu dǝm atli. ");
INSERT INTO plj_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kan tǝ pǝn bǝredi nyingi ju na kosi, nan tǝ goode Yamo, kan tǝ cecceni tǝ bi mir mǝn kulci kar ti, wu bi mbarǝmi. ");
INSERT INTO plj_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Domtǝn kǝ mbarǝmi kup ci wu la'i tu gǝzǝni. Den kariwo, mir mǝn kulci kar ti ba dom roɓǝs bǝredi na kosi nan sagwa ba laa'i shar nyingi. ");
INSERT INTO plj_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Womtitǝn kǝ mbarǝm ju ciwo ar pi moni zangu wupse (4,000), bat na mǝtli na mimiri. ");
INSERT INTO plj_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Nan Yesu wul mbarǝmi wu ndara bomo, ar ni tǝ to gip kungǝlǝn jikat male, kan tǝ ndara kǝti atl kǝ Magadan. ");
INSERT INTO plj_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Mǝn Parise na mǝn Sadukiya jen ɗir kar Yesu kǝ dǝ wu gode ti, ar ni wu lir ti, den tǝ pi wur bar kǝ nǝmi bi na am kan ba gode'e sur yam ni tǝ ɗǝl gwa. ");
INSERT INTO plj_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yesu nǝmi wur tǝ wule, <<Sit ni pi kan Yam ba zil kawo, kǝ wule, <bǝni baa mbuni.> ");
INSERT INTO plj_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Kǝ cigǝni kǝn ni, kǝ shin yam ni zilka, kan dun yam ni tli toro, kǝ wule, <Sekǝno ghon baa nda.> Kǝ mani momi kanda kǝ pitǝn kǝ to yamka, ama kǝ mani momi kanda kǝ pitǝn kǝ zhan kǝn da'a. ");
INSERT INTO plj_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kǝn zhan mǝn ɗasi tu'e na mǝn nge Yami, kǝn den ngeni dǝ pi in bar kǝ nǝmi bi na ame, ama ko nǝm baa pi in bar kǝ nǝmi bi na am da'a, se bar kǝ nǝmi bi na am kan zam Yunana gwa.>> Ar ni Yesu ndara. ");
INSERT INTO plj_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Nan mir mǝn kulci kar Yesu jǝkati te bi shidi bar ta kawo, ar ni wu mom'e wu mǝsǝn pǝni bǝredi ka. ");
INSERT INTO plj_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ar ni Yesu wul mir mǝn kartǝn gǝs'e, <<Ngup kǝn ni, kǝtǝri ni yisti kǝ mǝn Parise, na kǝ mǝn Sadukiya.>> ");
INSERT INTO plj_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ar ni wu shirǝm na ezǝn wu wule, <<Ko nan mǝ ɗir na bǝredi da'i gwa ni?>> ");
INSERT INTO plj_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ama nan Yesu mom'e wu den bali gip dlom gǝzǝno, ar ni tǝ wul wur'e, <<Kǝn mǝn kali ngǝshtǝn den Yami! Unun kem kǝn den damtǝn den fingalu? ");
INSERT INTO plj_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Kǝkǝn ma kǝ mom wi diya? Kǝ mǝsǝni ni ka na mbarǝm zangu nantam (5,000) ju kan a bi wur fingal kǝ bǝredi nantam gwaya? Roɓǝsi ju sawo, laa'i shar mǝnen kǝ dom we? ");
INSERT INTO plj_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ko mbarǝm zangu wupse (4,000) ju kan a bi wur fingal kǝ bǝredi nyingiwo, shar mǝne ni kǝ dom kǝ roɓǝsi kan sa gwa wu? ");
INSERT INTO plj_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Unu arin kem har kǝkǝn kǝ mom dawu? Kǝ shin wule den fǝngal ni a shirǝma?>> A yari in ra, <<Kǝtǝri ni yisti kǝ mǝn Parise na kǝ mǝn Sadukiya.>> ");
INSERT INTO plj_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ar ni mir mǝn kulci kar ti mom'e, den yisti kǝ bǝredi ni tǝ den shirǝm da'a, ama den wu kǝtǝri kulcitǝn kǝ lar kǝ mǝn Parise na kǝ mǝn Sadukiya ni tǝ den shirǝmi. ");
INSERT INTO plj_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Nan Yesu na mir mǝn kulci kar ti mbu bar kǝti atl kǝ Kaisariya kǝ Filibiwo, ar ni tǝ tambe mir mǝn kulci kar ti tǝ wule <<Woni mbarǝm ba wul Nya mbarǝm we?>> ");
INSERT INTO plj_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ar ni wu nǝmi ti wu wule, <<Jen ba wule, ki Yohana mǝn pi batǝsma ni, jen eso wu wule, ki Iliya ni, jen ngapo wu wule ki Irimiya ni, ko gon gip mǝn yari shirǝm kǝ Yami.>> ");
INSERT INTO plj_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ar ni Yesu wul wur'e, <<Kǝn ngapo, kǝ wul ni'e ami woni we?>> ");
INSERT INTO plj_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ar ni Simon Bitǝrus nǝmi ti, tǝ wule, <<Ki ni'e, Almasihu Nya Yam mǝn ge mbatli.>> ");
INSERT INTO plj_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesu nǝmi ti, tǝ wul ti'e, <<ki mǝn albarka ni, Simon nya Yunana, mbarǝm ni gode'i momi bar tu da'a, ama Ban kǝ to yam ka ni ɓuli'i. ");
INSERT INTO plj_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","A yari'i ka, ki ni'e Bitǝrus, ki ni'e tat tu kan aa tu domtǝn kǝ mǝn kopi dene, muntu kan mǝshtǝn baa nǝ ra na iko dene dagwa. ");
INSERT INTO plj_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Aa bi'i bar kǝ ɓuli mulki kǝ to yamka, argon tu kǝ dar bi dene sur atlo ar ba dǝm argon tu tare dar bi dene to yam kagwa, eso argon tu kǝ pǝtlka sur atlo, ar dǝm na pǝtli ni ar ra to yamka.>> ");
INSERT INTO plj_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ar ni Yesu dǝli mir mǝn kulci kar ti kǝm hoyi den ba wu yari murgon'e ti ni'e, Almasihuyi da'a. ");
INSERT INTO plj_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Gasi ni Yesu pare yari mir mǝn kulci kar ti den'e, ar nǝm ti te yarka tǝ te Urshalima, tǝ kum dli na ko gonge kumi dli am dǝ kiri kǝ mǝn bǝn na kiri firist na mǝn kulci mbarǝm doka kǝ Musa kan dǝ ri ti eka, den pǝt kǝ myakano dǝ tli ti na ge mbatl esi. ");
INSERT INTO plj_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ar ni Bitǝrus la tǝ bi markǝme, tǝ matl ti tǝ wule, <<Dǝ Yam saukake, babomi, untu ba pi nan ki da'a!>> ");
INSERT INTO plj_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ama Yesu bal ti den Bitǝrus tǝ wul ti'e, <<Tli karǝmka, Shetan! Ki tat pati asǝm ni karǝmi. Domici damtǝn kǝ bar kǝ Yam ra su mbatl da'i ka da'a se damtǝn kǝ bar kǝ mbarǝme.>> ");
INSERT INTO plj_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kan Yesu ba wul mir mǝn kulci kar ti'e, <<Kup muntu ba ndu kopi gǝno, ar nǝm ti te yarka, tǝ nge gam gǝs tǝ pǝn kin ɓatǝn gǝs kan tǝ kopǝni. ");
INSERT INTO plj_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Domici muntu kup ba ndu ga'i mbatl gǝso, tii holka. Ama muntu ba bi ge mbatl gǝs domici gǝno, tii zam ge mbatli. ");
INSERT INTO plj_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Unun baa ɓite'i kin kǝ zam atl kundǝrǝndlip kan kǝ hol ge mbatl giwu? Ko unun kii mani bi den bi ge mbatl giwe? ");
INSERT INTO plj_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Domici, Nya Mbarǝm baa sur na mir mǝn kartǝn kǝ Yam gip ɗǝɗatǝn kǝ Base, kan tǝ ɓatl ko gonge mbarǝm den bi argon tu tǝ pi gwa. ");
INSERT INTO plj_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ge shirǝm ni a yari ine, jen gip kin kan ra dlor ɗewo, wi mǝsh da'a, se wi ni wu shin surtǝn kǝ Nya Mbarǝm gip nartǝn gǝs kǝ gunye.>> ");
INSERT INTO plj_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Den kaar kǝ muri mukkawo, ar ni Yesu pǝn Bitǝrus, Yakubu na Yohana erǝm kǝ Yakubu, tǝ te wur den tlǝndǝr mǝn tlyartǝn wu nan gǝzǝni. ");
INSERT INTO plj_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ar ni dli kǝ Yesu palka gholi, kan ba ger gǝs ba cirka wule cirtǝn kǝ pǝte, den shini kǝ ger gǝzǝni, kan tutul dli gǝs ba gholka kulen wule cirtǝni. ");
INSERT INTO plj_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Wule gip njǝpkǝr gere ar ni Musa na Iliya ɗǝl kar wur wu den shirǝm na Yesu. ");
INSERT INTO plj_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ar ni Bitǝrus wul Yesu'e, <<Babomi ar mbun kan mǝn ra ɗe gwa. Ki ni kǝ ndu'o, aa pi mir kuptǝkup myakan, nǝm ge, nǝm kǝ Musa, nǝm eso kǝ Iliya.>> ");
INSERT INTO plj_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Tǝ gip shirǝmo, ar ni dun yam mǝn cirtǝn ghum wurka, kan wu kum yar gon gip dun yami ba wule, <<Muntu ni'e Nya gǝni a ndu ti hoyi, nan ti ni a pi ghol mbatl naari, kum tǝni.>> ");
INSERT INTO plj_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nan mir mǝn kulci kar ti kum untuwo, ar ni bǝrti ci wuri, kan wu nda atl na gip tu'e. ");
INSERT INTO plj_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ama Yesu ɗir kan tǝ ne am den wur tǝ wule, <<Tli ni yami, ba dǝ bǝrti ci in ni da'a.>> ");
INSERT INTO plj_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Nan wu tli gero, wu'i shin murgon da'a, se Yesu nan gǝsi. ");
INSERT INTO plj_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nan wu den ɗǝltǝn sur den tlǝndǝriwo, ar ni Yesu dǝli wur kǝm tǝ wule, <<Ba kǝ yari ni murgon argon tu kǝ shin gwa da'a, se tli Nya mbarǝm gip mǝshi mbarǝm kakani.>> ");
INSERT INTO plj_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ar ni mir mǝn kulci kar ti ba wul ti'e, <<Unun kem mǝn kulci mbarǝm den tǝlankur kulci kǝ Musa ba kulci'e, Iliya ni baa cwat kakani?>> ");
INSERT INTO plj_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu nǝmi wur tǝ wule, <<Untu ni, Iliya baa suri, tii sur ni tǝ kǝrkǝm ko unu. ");
INSERT INTO plj_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ama a yari inka, Iliya sur wi, ngapo wu mom'e ti ni da'a, ar ni wu pi ti argon tu wu ndu pi gwa. Untu ni es Nya mbarǝm baa kum dli am da wuri.>> ");
INSERT INTO plj_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ar ni mir mǝn kulci kar ti mom'e ti ni den pi wur shirǝm den Yohana mǝn pi batisma. ");
INSERT INTO plj_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nan wu mbu bar kar mbarǝm na womtiyiwo, ar ni mbarǝm gon ɗir kar Yesu tǝ ngus cina da ti, tǝ wul ti'e, ");
INSERT INTO plj_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","<<Babomi, kum guna kǝ nya gǝni, domici tǝ den patǝn na kumi dli hoyi kǝ ndetǝne, ar ba kur byal ti gip utu, ko gip male. ");
INSERT INTO plj_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","A ri ti kar mir mǝn kulci kar ki, ama wu mani pǝni ti kumi dliyika da'a.>> ");
INSERT INTO plj_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu nǝm tǝ wule, <<Kǝn zhan kan na ngǝshtǝn den Yam da'a mǝn jiltǝni! Har gigasi ni a nǝra nan kǝne, ar ri gigasin aa ci cina na te mbatl kaarka nan kǝnu? Ɗirim ni nyayi ɗe.>> ");
INSERT INTO plj_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ar ni Yesu matl dun itǝr kan ra gip nyayi gwa. Ar dlyam da'a, ar ni nyayi pal lau. ");
INSERT INTO plj_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kan mir mǝn kulci kar ti ba ri kar ti wokoci tu mbarǝm'i kar wur dagwa, wu ngen momi kar ti wu wule, <<Unun kem mǝ mani ɗǝli dun itǝrika dawu?>> ");
INSERT INTO plj_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu nǝmi wur, tǝ wule <<Kǝn ra na kali ngǝshtǝn den Yam ni kemi. Na ho bi ni a yari ine, dǝ wule kǝn nǝra na ngǝshtǝn den Yam wule ge dǝntǝwo, ki wul tlǝndǝr tu'e, <Tli bartu kǝ ri barta,> tii tli. Argon ra kan ki hol mani pi gwa da'a. ");
INSERT INTO plj_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ɗǝli dun itǝr wule munju ba pi da'a, se na shirǝm na Yami na guzum male.>> ");
INSERT INTO plj_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Nan mir mǝn kulci kar ti dom wur su Galili kawo, ar ni Yesu wul wur'e, <<Baa bi Nya mbarǝmka am dǝ mbarǝme. ");
INSERT INTO plj_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Wii ri ti eka, ama den pǝt kǝ myakano, baa tli tika gip mǝshi mbarǝme.>> Ar ni shirǝmi ghun mir mǝn kulci kar tiyi. ");
INSERT INTO plj_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Nan Yesu na mir mǝn kulci kar ti yi mbubar Kaparnahumo, ar ni mǝn nǝmi wurpi bom kǝ bom kǝ Yam zam Bitǝrus wu wul ti'e, <<Mǝn kulci gin ba ɓatl wurpi bom kǝ Yama?>> ");
INSERT INTO plj_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Bitǝrus nǝmi ti tǝ wule, <<Aan, tǝ ɓatli.>> Nan Bitǝrus te gip bomiwo, ar ni Yesu nǝmi ti pi shǝrǝm tǝ wule, <<Simon! Unun kǝ shin den momi tu tǝ ngen kar ki gwa we? Kar ga won ga gun kǝ atl ba nǝm wurpi bomi, kar mimir gǝzǝn na, ko kar jen ni?>> ");
INSERT INTO plj_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Nan Bitǝrus nǝmi ti tǝ wule, <<Kar jen ni wu nǝmo>> Ar ni Yesu wule, <<O, mimir gǝzǝno ar ra gam da wur da'a ituwi! ");
INSERT INTO plj_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Kup na untu, bǝse mǝ ci wur lo'o, su bar ɓula'i, kǝ la coli. Kos tu kǝ pare nǝmi gǝso, ɓul bi gǝsi, kii zam kabarshu nǝm. Pǝn kabarshuyi kǝ ɓatl wurpi bom kǝ bom kǝ Yami nari, gwan na ge ituwi.>> ");
INSERT INTO plj_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Gip wokoci tawo, mir mǝn kulci kar Yesu ɗir kǝ ngeni momi kar ti, wu wule, <<Woni baa ni'e bari gip mulki kǝ to yam kawe?>> ");
INSERT INTO plj_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ar ni Yesu la bi nye heli nya goni, tǝ ne ti dlor gip dlom gǝzǝni. ");
INSERT INTO plj_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Kan tǝ wul wur'e, <<Na ho bi ni a yari ine, kǝn ni kǝ pali gam gin wule heli mimir dawo, kii te gip mulki kǝ to yam ka da'a. ");
INSERT INTO plj_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ra'untuwo, kup muntu kan pali gam gǝs wule heli nya tuwo, ti ni'e bari gip mulki kǝ to yam ka. ");
INSERT INTO plj_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Muntu kup nǝm heli nya wule muntu gip sun gǝno, ami ni tǝ nǝmǝni. ");
INSERT INTO plj_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ama muntu kup kem nǝm gip mimir ju kan ngǝsh wur demǝn kǝ pi warwat pitǝno, ar baa mani mbarǝm tu dǝ ɓali ti ghun lu'i bar ɗir yar dǝ la ti su gip dlami bar ɓulaka. ");
INSERT INTO plj_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kashto kǝ mbarǝm den atl kundǝrǝndlip, domici bar ju ba kem mbarǝm kǝ ndetǝno ar womti. Ar nǝm dǝ tǝp kǝ ndetǝn ɗiri, ama kashto kǝ mbarǝm tu kan baa pi tǝp kǝ ndetǝni gwa. ");
INSERT INTO plj_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ra'untuwo, am ko asǝm gi ni ba kem ki kǝ pi warwat pitǝno, tlo kǝ laka. Ar ba mani'i kǝ zam ge mbatl kan ba pa da gwa na am ko asǝm nǝm ko kurkiyi, na dǝ wule la ki te utuka na am gi, ko na asǝm gi kup pa ropi. ");
INSERT INTO plj_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ger gi ni ba kem ki kǝ pi warwat pitǝno, ɗǝli kǝ la ka. Ar ba mani'i kǝ zam ge mbatl kan ba pa da gwa na ger nǝm, na dǝ la ki te bom utuka na ger gi kup pa ropi. ");
INSERT INTO plj_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ngup kǝn ni, ba kǝ mbur ni ko nǝm gip mimir ju da'a. Domici a yari in'e, mǝn kartǝn kǝ Yam mǝn ne ger den wur ra cina dǝ Ban to yamka ko gigasi. ");
INSERT INTO plj_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Nya mbarǝm sur ni kǝdǝ tǝ ɗǝli munju kan jilka gwa. ");
INSERT INTO plj_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Gip shini gino, barǝm gon nǝra na tǝm gǝs hauya nantam (100), kan nǝm ba jilka gip wuro, unun mǝn tǝmi baa piwe? Tii za tǝm hauya wupse na kutl-cet ghwanum juka (99), tǝ ri kǝ ngeni nǝm tu kan jilka gwa bi tlǝdǝr diya? ");
INSERT INTO plj_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ti ni tǝ zam tǝm gǝsi ngapo, ge shirǝm ni a yari ine, ti pi ghol mbatl na nǝmi, ar man hauya wupse na kutl-cet ghwanum ju kan jilka da gwa. ");
INSERT INTO plj_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Untu ni pa'e, ndu'i kǝ Ba gin kǝ to yamka ni dǝ nǝm gip heli mimir ju jilka da'a. ");
INSERT INTO plj_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ya'i ni pi'i wani pitǝno, ri kar ti mol kǝn rop gini kǝ yari ti wani pitǝn gǝsi. Ti ni tǝ kum ki kan tǝ ci atl gamo, kǝ pali ti den tǝp ituwi. ");
INSERT INTO plj_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ama ti ni tǝ kumi'i dawo, se kǝ ri na erǝm gon nǝm, ko rop nan ki, kǝ ri ni kar ti esi, domici ko unun yari bi dǝ mbarǝm rop, ko myakano ar dǝmwi. ");
INSERT INTO plj_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ti ni tǝ nge kumi gǝzǝn kawo, ri shirǝmi cina dǝ domtǝn kǝ mǝn kopi. Ti ni ngap tǝ nge kumi domtǝn kǝ mǝn kopiyi kawo, pali tǝ ni wule muntu mom yam da gwa, ko mǝn nǝmi wurpi bomi. ");
INSERT INTO plj_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ge shirǝm ni a yari ine, argon tu kǝ dar bi dene dan kaar atlo, tare dar bi dene wi to yamka, eso argon tu kǝ dar bi dene da'a den kaar atlo, to yam ka ma dar bi dene da'a. ");
INSERT INTO plj_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","A yari in muntu esi. Mbarǝm rop gip kǝn den kar atl kǝn ni dar bi den bar kan wu liriwo, Ban kǝ to yamka baa pi wuri. ");
INSERT INTO plj_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kup las tu mbarǝm rop, ko myakan dom wur den wi gwanno, ami ra nan wuri.>> ");
INSERT INTO plj_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Den untuwo, ar ni Bitǝrus ri ngen momi kar Yesu tǝ wul ti'e, <<Babomi, biyi mǝneni a gaparte muntu pim warwat pitǝn kagwawe? Bisi ngingiya?>> ");
INSERT INTO plj_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu nǝmi ti tǝ wule, <<O'o! Bisi nyingi ni katl da'a, ama nyingi bisi hauya myakan na kutl (70). ");
INSERT INTO plj_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ra untuwo, mulki kǝ Yam nǝra wule gun gon kan ba ndu momi tu kǝ bar kǝ am gǝs kan ra kar zher gǝs gwa. ");
INSERT INTO plj_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Gip dlǝmiwo, ar ni tǝ zam gon ra kan tǝ kop ti wurpi mǝn nartǝn kan ti mbu ɓatli da'a har tǝ mish gwa. ");
INSERT INTO plj_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nan mbarǝmi mbu ɓatli dawo, ar ni gunyi wule dǝ wur tika, na gǝr gǝsi, na mimir gǝsi, na argon tu kup tǝ ra nari gwa, kǝdǝ ɓatl asǝm yami. ");
INSERT INTO plj_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ama mbarǝmi ngus cina dǝ gunyi tǝ lir ti tǝ wule, <babomi, te mbatl karka ngapi, aa ɓatl ki kup argon tu kǝ kopǝn gwa.> ");
INSERT INTO plj_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ar ni gunyi kum guna kǝ mbarǝmi, kan tǝ yape tika, tǝ wule, dǝ za ti tǝ ndara. ");
INSERT INTO plj_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ama nan mbarǝm tu kan gunyi ba kop ti wurpi za lasiwo, ar ni tǝ ri mo na zher berǝm gǝs kan tǝ kop ti wurpi njen hauya nantam gwa. Tǝ nǝm berǝm gǝsi te yarka tǝ wul ti'e, <Ɓatlǝm wurpi tu a kop ki gwa.> ");
INSERT INTO plj_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ar ni zher berǝm mbap gǝsi ngus cina da ti tǝ lir ti tǝ wule, <Te mbatl kaarka ngapi, aa ɓatl ki.> ");
INSERT INTO plj_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ama berǝm gǝs kan ba kop ti wurpiyi kum lirtǝn gǝs da'a. Tǝ kem ba ɓal tika gip bom kǝ moni, se ti ni tǝ ɓatl ti argon tu tǝ kop ti kup kakani. ");
INSERT INTO plj_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nan nami zheri kum argon tu piwo, wu kum tǝmi da'a. Ar ni wu ri kar babom gǝzǝn kan wu yari ti kup argon tu pigwa. ");
INSERT INTO plj_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ar ni gunyi laa bi zheri tǝ wul ti'e, <Ki zher mǝn ɗasi tu'e! Nan kǝ lirǝmo a yape'i wurpi ju kup kan a kop ki gwa. ");
INSERT INTO plj_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Kiwo, ar ndari kǝ shin guna kǝ berǝm mbap gi kandatu a shin guna gi gwa diya?> ");
INSERT INTO plj_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Gip lo'o ar ni gunyi kem ba la ti am dǝ mǝn ne ger den bom kǝ moni, dǝ kumi ti dli se ti ni tǝ ɓatl wurpi tu ba kop ti kup kakani. ");
INSERT INTO plj_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Untu ni Ban kǝ to yamka baa pi na muntu kup gip kǝn kan nge gaparte esika na mbatl nǝm gwa.>> ");
INSERT INTO plj_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Nan Yesu pa'i yari bar juwo, ar ni tǝ za atl kǝ Galili kan tǝ te gip kǝti atl kǝ Yahuda muntu kan ra te bi ɓula Urdun ka gwa. ");
INSERT INTO plj_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Mbarǝm na womti kop ti kaari, kan tǝ pǝni wur kumi dli gǝzǝnka lasi. ");
INSERT INTO plj_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ar ni mǝn Parise jen ri kar ti kǝ dǝ wu kum kǝ bi gǝsi. Ar ni wu wule, <<Tǝlankur kulci kǝ Musa kulci ni'e mbarǝm baa mani kari gǝr gǝs ka den bi argona?>> ");
INSERT INTO plj_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu nǝmi wur, tǝ wule, <<Kǝ zhit ni gip tǝlankur diya? Untun ar ra terka. Yam kan pi wuro tǝ pi wur ni moni na gǝr mǝtli. ");
INSERT INTO plj_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Kan Yam ba wule, <Ra untuwo, mbarǝm baa za bas na naska, tǝ nǝm gǝr gǝsi dlatkǝt, kup gǝzǝn ropiwo wu dǝm dli nǝm ituwi.> ");
INSERT INTO plj_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kǝkǝno wu rop ni da'a, ama wu dǝm ka dli nǝm wi. Ra untuwo, argon tu Yam gudlumiwo, ba dǝ gon pǝtlka da'a.>> ");
INSERT INTO plj_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ar ni wu ngen momi wu wule,<<Kano unun kem Musa yari'e, mbarǝm baa mani rǝshi tǝlankur kǝ kari gǝr gǝs kawu?>> ");
INSERT INTO plj_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ar ni Yesu wul wur'e, <<Musa za kǝn ni kǝ kar gǝr gin ka den bi lati gam gi ni. Ama terkawo untun ar ra da'a. ");
INSERT INTO plj_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","A yari inka, muntu kup kar gǝr gǝska, ba'e den warwat pitǝn kǝ muri na moni kaari ni da'a, kan tǝ gudlumi na gono, muri na mǝtli kaari ni tǝ den pi.>> ");
INSERT INTO plj_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ar ni mir mǝn kulci kar ti wul ti'e, <<O untun fa dlom kǝ gǝr na kos rawo, ar ba mani ba dǝ mbarǝm gudlumi da'a!>> ");
INSERT INTO plj_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu wul wur'e, <<Ba'e Ko gonge mbarǝm ni baa mani pǝni shirǝm tu da'a, ama se mbarǝm ju kan Yam bi wur mani pi untuyi gwa. ");
INSERT INTO plj_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Domici moni jen ra kan gǝr wur moniyi dagwa, jen ngapo, mbarǝm ni pali wur unju. Jen ngapo gip ndu'i gǝzǝn ni den'e wii gudlumi da'a den bi kǝ mulki kǝ to yam ka. Kup mǝn mani pǝni shirǝm tuwo, tǝ pǝni.>> ");
INSERT INTO plj_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ar ni mbarǝm jen ɗiri mimir jen kar Yesu kǝdǝ tǝ ne am den wuri, tǝ shirǝm na Yam den wuri. Ama mir mǝn kulci kar Yesuyi matl wuri. ");
INSERT INTO plj_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ama Yesu wul wur'e, <<Zani dǝ heli mimir ju ɗir karǝmi, ba kǝ hane wur nika da'a! Domici mulki kǝ Yamo gwazin ni.>> ");
INSERT INTO plj_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ar ni tǝ ne wur am gam tǝ la'i wur albarka, kan tǝ ndara. ");
INSERT INTO plj_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ar ni mbarǝm gon ɗir kar Yesu tǝ ngen momi kar ti, tǝ wule, <<Ba mǝn kulci, unu ho bar ni aa pi kǝdǝ a zam ge mbatli kan baa pa dagwa wu?>> ");
INSERT INTO plj_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ar ni Yesu nǝmi ti tǝ wule,<<Unun kem kǝ ngen momi den ar gontu kan ra hoyi gwawe? Yam nan gǝs ni'e hoyi. Kin kǝ ndu ge mbatl kan baa pa dawo, kop dokayi.>> ");
INSERT INTO plj_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Kan mbarǝmi ba wule, <<Dokayi gonge?>> Ar ni Yesu nǝmi ti, tǝ wule, Ba kǝ ri gon eka da'a. Ba kǝ mur na mǝtli kaari da'a. Ba kǝ pi mur da'a. Ba kǝ bi seda kǝ lar da'a. ");
INSERT INTO plj_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Bi nartǝn ga bǝba gi na nǝna gi, ndu berǝm dǝmi gi wule gam gi. ");
INSERT INTO plj_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ɗal moniyi bali ti tǝ wule. <<A kop doka ju wi kup, Unun es sem wi?>> ");
INSERT INTO plj_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ar ni Yesu wul ti'e, <<Kin kǝ ndu kǝ nǝra dlato, ri wur bar kǝ am gika kǝ bi wurpiyi munju kan am ri wur kar dagwa, kii zam bar kǝ am to yamka. Kan kǝ ɗir kopǝni.>> ");
INSERT INTO plj_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ama nan ɗal moniyi kum untuwo, ar ni tǝ ndara bom na dun mbatli domici tǝ mǝn bar kǝ am ni hoyi. ");
INSERT INTO plj_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ar ni Yesu wul mir mǝn kulci kar tiyi'e, <<Ge shirǝm ni a yari ine, ar ba ban naar dǝ mǝn bar kǝ am te gip mulki kǝ to yam ka. ");
INSERT INTO plj_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","A yari in es'e, ar ba mani dǝ rakumi te tǝp gip ger alura na dǝ mǝn bar kǝ am te gip mulki kǝ Yami.>> ");
INSERT INTO plj_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nan mir mǝn kulci kar ti kum untuwo ar ni wu nǝm bi na ame, wu wule, <<O untu ni fawo, woni baa zam ɗǝltǝn ituwi?>> ");
INSERT INTO plj_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ar ni Yesu zhit wur hoyi kan tǝ wule, <<Gip shini kǝ mbarǝm kamo, ar baa pi da'a. Ama kar Yamo, ko unuwo mǝn pitǝn ni.>> ");
INSERT INTO plj_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ar ni Bitǝrus wul ti'e, <<Ar tu mǝ za bar gǝmi ka kup mǝ kop ki wi. Unun mii zam gip kopi giwe?>> ");
INSERT INTO plj_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ar ni Yesu wul wur'e, ge shirǝmi ni a yari ine, Gip zhan mǝn ɗirtǝno, Nya Mbarǝm ni dǝm den dandi mǝn cirtǝn gip mulki gǝso, kǝn mǝn kopi gǝn baa dǝm den dandi kutl-cet rop, kǝ tloyi gǝs gal kutl-cet rop kǝ Isra'ila shirǝmi. ");
INSERT INTO plj_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kano muntu kup za bom gǝsi, ko mǝn gǝpi gǝs moni, ko mǝtli, ko base, ko nase, ko mimir gǝsi, ko kǝn gǝsi, den bi sun gǝno, tii zam argon tu kan man munju gwa gucǝpi hauya nantam (100), kan tǝ pa zam ge mbatli tu baa pa dagwa. ");
INSERT INTO plj_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ama mbarǝm na womti kan ra cina kǝkǝno, wii dǝm kǝ kaari, kǝ kaar ngapo wii dǝm kǝ cina. ");
INSERT INTO plj_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","<<Mulki kǝ to yam kawo, wule ba mǝn bom gon ni ar ra, kan ɗǝl kǝ bi cigǝni kǝ ngeni munju kan baa pi ti mbap gip kǝn inabi gǝs gwa. ");
INSERT INTO plj_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Wu dlǝr den tii ɓatl wur den wurpi tu ba ɓatl mǝn mbap kǝ nde pǝt gwa, kan tǝ kar wur rǝn gip kǝn gǝsika. ");
INSERT INTO plj_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Bar kǝ gǝlla am ghwanǝm kǝ cigǝni nan tǝ ɗǝlo, ar ni tǝ shin jen dlor katl bi bar pǝte, wu den pi argon da'a. ");
INSERT INTO plj_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ar ni tǝ wul wur'e, <Kǝn ma ri ni gip kǝn gǝn kǝ pini mbapi, aa ɓatl kǝn argon tu kup ndari gwa.> ");
INSERT INTO plj_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ar ni wu ndara gip kǝni. Nan tǝ ɗǝl bar kǝ awa muhka na awa ghwanǝm eso, ar ni tǝ pa pi untu. ");
INSERT INTO plj_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kǝ sit bar kǝ gǝlla am nantamo, ar ni tǝ pa ɗǝl kan tǝ zam jen dlor-dlor, tǝ wul wur'e, <Unun kem kǝn ra den dǝmi ɗe katl nde pǝt kup we?> ");
INSERT INTO plj_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Wu wul ti'e, <Murgon ra kan bi mi mbap kǝ pi gwa da'a.> Ar ni ba mǝn kǝni wul wur'e, <Kǝn ma ri pini mbap gip kǝn gǝni.> ");
INSERT INTO plj_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Kǝ sit shukuto, ar ni ba mǝn kǝni la bi muntu kan ba ne ti ger den kǝni gwa tǝ wul ti'e, <laa bi mǝn mbap ju kǝ ɓatl wuri, pare den muntu ɗir kǝ kaar ar ri den muntu pare ɗirtǝn gwa.> ");
INSERT INTO plj_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Nan munju yem wur mbap kǝ sit bar kǝ gǝlla am nantami ɗiro, ar ni ko gonge gǝzǝn zam ɓatltǝn gǝs wurpi tu ba ɓatl mǝn mbap kǝ nde pǝt gwa. ");
INSERT INTO plj_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Munju kan ri kǝ pariyi pǝn den'e baa ɓatl wur ar man kǝ nami. Ama ar ni ɓatl wur wurpi tu ba ɓatl mǝn mbap kǝ nde pǝt gwa tangǝn na munju ri kǝ siti gwa. ");
INSERT INTO plj_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Nan wu nǝmo, ar ni wu nǝm ngwartǝn den babomi. ");
INSERT INTO plj_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Wu wul ba mǝn kǝni'e, <Munju kǝ yem wur kǝ kaar dami kupo, mbap kǝ awa nǝm ni katl wu pi ama kǝ ɓatl wur tangǝn nam mi, mǝn kan mǝ ndo mi na tle mattǝn kǝ pǝt gwa.> ");
INSERT INTO plj_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ama ba mǝn kǝni nǝmi gon gip wur tǝ wule, <Berǝm, a ne'i asǝm gam ka da'a! Mǝ dar ni bi nan kǝn den aa ɓatl ki wurpi tu ba ɓatl mǝn mbap kǝ nde pǝt gwa da'aya? ");
INSERT INTO plj_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nǝm ɓatltǝn gi kǝ ndara. Untun a pǝn tor gip mbatl gǝn den aa ɓatl wur tangǝn nan ki. ");
INSERT INTO plj_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","A mani ni pi argon tu a ndu pi na wurpi gǝn gwa diya? Lo ci'i ni den bi am tu a pi gwaya?> ");
INSERT INTO plj_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ra untuwo, kǝ cina baa dǝm kǝ kaari, kǝ kaar ngapo wii dǝm kǝ cina.>> ");
INSERT INTO plj_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Nan Yesu den totǝn Urshalimawo, ar ni tǝ laa bi mir mǝn kulci kar ti kutl cet ropi markǝme, kan tǝ wul wur'e, ");
INSERT INTO plj_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","<<Ar tu mǝ to ni Urshalima, baa bi Nya mbarǝm am dǝ kiri liɓa kǝ Yam na mǝn kulci mbarǝm den tǝlankur kulci kǝ Musa. Wii tloyi ti shirǝm den dǝ ri ti eka. ");
INSERT INTO plj_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Wii ta ti am dǝ munju kan mǝn Yahuda ni dagwa. Wii pi ti shirǝm mburtǝne, kan wu ɓo ti, kan wu ɓa tika den kin esi. Ama den pǝt kǝ myakano, baa tli ti na ge mbatli.>> ");
INSERT INTO plj_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ar ni nasi ga Yakubu na Yohana, mimir kǝ Zabadi, ɗir nan wur kar Yesu, kan tǝ ngus cina da ti tǝ lir ti argoni. ");
INSERT INTO plj_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu wul ti'e, <<Unun kǝ ndu a pi'iwe?>> Ar ni tǝ wule. <<Gip mimir gǝn rop juwo, a liri dǝ nǝm dǝm den am shimli gon ngapo den am yali gi gip mulki gi.>> ");
INSERT INTO plj_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ar ni Yesu wul mimiri'e, <<Kǝ mom ar gon tu kǝ liri gwa da'a! Kii mani kumi dli tu kan a ri kǝ kumi gwaya?>> Wu nǝmi ti wu wule. <<An! Mi mani.>> ");
INSERT INTO plj_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesu wul wur'e, <<Kii mani kumi dli tu kan aa kum gwa, ama dǝmi den am shimli ko am yali gǝno, gwan ni da'a, ban kǝ to yam ka ni kǝrkǝmi munju kan tǝ zǝzari gwa.>> ");
INSERT INTO plj_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nan nami mir mǝn kulci kar ti kutli kum untuwo, ar ni lo ci wur den yas mbarǝm rop ju. ");
INSERT INTO plj_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ama Yesu la wur bi kup gǝzǝn, tǝ wul wur'e, <<Kǝ mom'e gun kǝ munju kan mǝn Yahuda ni da'a ba gode iko den mbarǝm gǝzǝni, eso kiri gǝzǝn ba gode wur iko pa'e. ");
INSERT INTO plj_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ama gip kǝno untu ni da'a. Muntu ba ndu dǝmi bariwo, ar nǝm ti te yarka tǝ dǝm mǝn pi'in mbapi. ");
INSERT INTO plj_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Eso, muntu kup ba ndu dǝmi kǝ cinawo, ar nǝm ti te yarka tǝ dǝm zher gini. ");
INSERT INTO plj_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ba'e, Nya mbarǝm sur ni kǝ dǝ mbarǝm pi ti mbap da'a, ama kǝ dǝ tǝ pi mbarǝm ni, kan tǝ bi ge mbatl gǝs es kǝ ɗǝli mbarǝm na womti.>> ");
INSERT INTO plj_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Nan Yesu na mir mǝn kulci kar ti ba za Yerikowo, ar ni mbarǝm na womti kop ti kaari. ");
INSERT INTO plj_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Tabi jen ra rop den dǝmi bi tǝpe. Nan wu kum Yesu den ɗirtǝn den tǝpiwo, ar ni wu tli yar yam wu wule, <<Babomi, Nya Dauda, kum guna gǝmi.>> ");
INSERT INTO plj_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ar ni womti mbarǝmi matl wur kǝ dǝ wu yon shot, ama wu tli yar na nari wu wule, <<Babomi, Nya Dauda kum guna gǝmi!>> ");
INSERT INTO plj_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ar ni Yesu dlǝr tǝ wul wur'e <<Unun kǝ ndu'e a pi inu?>> ");
INSERT INTO plj_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Wu wul ti'e, <<Babomi, miwo mǝ ndu ni'e mǝ mani shini bari!>> ");
INSERT INTO plj_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ar ni Yesu kum guna gǝzǝn kan tǝ tabe ger gǝzǝni. Wule gip njipkǝr gere, ar ni wu nǝm shini bari, kan wu kop ti. ");
INSERT INTO plj_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Nan Yesu na mir mǝn kulci kar ti mbubar nye bǝn gon'e Betafaji kan ra den tlǝndǝr kin zaitun kosak na Urshalimawo, ar ni Yesu kar mir mǝn kulci gǝs rop. ");
INSERT INTO plj_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Tǝ wul wur'e, <<Te ni gip nye bǝn tu kan ra cina da in gwa, na tetǝn gini, ki zam bar kǝm gon ra na ɓali na nya gǝs kar ti. Pǝtl wur ni kǝ terim ni. ");
INSERT INTO plj_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Muntu kup pi in shirǝmo, wul ti ni'e, <Babom ni ba ndu'i.> Ti kar bar nan wur na zhotǝne.>> ");
INSERT INTO plj_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Muntu pi ni dlat na ar gon tu mǝn yari shirǝm kǝ Yam yari gwa'e. ");
INSERT INTO plj_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","<<Yari ni mbarǝm kǝ sihiyona'e, <Shin ni, gun gin tu den ɗirtǝne. Tǝ mǝn giɓǝr gam ni da'a, tǝ ra den bar kǝme, tǝ den desi den nye bar kǝme.> >> ");
INSERT INTO plj_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ar ni mir mǝn kulci kar ti ri kan wu pi kandatu Yesu yari wur gwa. ");
INSERT INTO plj_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Wu ɗiri nas jakiyi na nya gǝsi, kan wu la ga tutul dli gǝzǝn den nya bar kǝmi, kan tǝ to dǝm dene. ");
INSERT INTO plj_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Mbarǝm na womti ni wi tutul dli gǝzǝn den tǝpe, jen ngapo am kin dabinoni wu wotl kan wu la den tǝpi. ");
INSERT INTO plj_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ar ni womti mbarǝm ju kan den ritǝn cina dati, na munju kan ra kar dati, tli yar wu den wultǝn'e, <<Hosana dǝ nya Dauda! Albarka ra den muntu kan ɗir gip sun kǝ Babom gwa.>> <<Hosana to yam ka.>> ");
INSERT INTO plj_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Nan Yesu to gip bǝn Urushalima wo, arni bǝni guzǝlka, wu den wultǝn'e. Woni'e muntuwe? ");
INSERT INTO plj_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ar ni womti mbarǝmi nǝmi wur wu wule, <<Yesu ni'e muntu, mǝn yari shirǝm kǝ Yam ni kan ɗǝl ter Nazarat kan gip atl kǝ Galili gwa.>> ");
INSERT INTO plj_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ar ni Yesu te gip bom kǝ Yam, kan tǝ kaar mǝn wuri na wurika. Tǝ gyas tebǝr kǝ mǝn sanje wurpi na ba dǝmi kǝ munju ba wur kuɓǝr ka gwa. ");
INSERT INTO plj_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Tǝ wul wur'e, <<Na rǝshi ni ar ra, <Bom gǝn ba dǝm las tu ba shirǝm na Yam gwa,> ama kǝ pali kawi wule ba dǝmi kǝ mǝn tare guntǝpe!>> ");
INSERT INTO plj_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ar ni ga tabi na ga kurki ɗir kar ti gip bom kǝ Yami, kan tǝ warke wuri. ");
INSERT INTO plj_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ama nan kiri mǝn keri bar ju ɗiri Yam na mǝn kulci mbarǝm den tǝlankur kulci kǝ Musa, shin bar kǝ dlǝkǝntǝn ju, na kumi mimir gip Bom kǝ Yam den tli yar wu den wultǝn'e, <<Hosana dǝ nya Dauda>> Ar ni lo ci wuri. ");
INSERT INTO plj_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Wu wul ti'e, kǝ kumni bar ju mimir ba yari gwa diya? <<Aan,>> Yesu nǝmi wur untu. <<Kǝ zhit ni gip tǝlan kuri diya? Las tu kan yari'e, ki ni kǝ kulci mimir na mǝn tle nyin den wu ɗǝɗa ki gwa diya?>> ");
INSERT INTO plj_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ar ni Yesu za wur tǝ ɗǝl gǝs gip bǝni tǝ ndara Betanya, tǝ mur teka. ");
INSERT INTO plj_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kǝ bi cigǝni nan Yesu ba pal su bǝn kǝ Urushalima kawo, ar ni tǝ kum guzumi. ");
INSERT INTO plj_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Kan tǝ shin kin turum den bi tǝpe. Nan tǝ te kariwo tǝ zam gǝri nyeni dene da'a, wol ni katl. Ar ni tǝ wul kini'e, <<Ba kǝ'i gǝr da'a!>> Na yari untuwo, ar ni kin turumi konka. ");
INSERT INTO plj_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nan mir mǝn kulci kar ti shin untuwo, ar ni wu nǝm bi na ame wu wule, <<Unun kem kin turum kǝn konka bǝle-bǝle untu?>> ");
INSERT INTO plj_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ar ni Yesu nǝmi wur tǝ wule, <<A yari in ge shirǝmi, kǝn nǝra na ngǝshtǝn den Yam kan kǝ pi shakka dawo, ba'e argon tu pi kin turum tu katl ni ki pi da'a. Ama ki mani wuli tlǝndǝr tu'e, <Tli bar tu kǝ nda su gip bar ɓulaka,> Ar baa dǝmi in untu. ");
INSERT INTO plj_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kǝn ni kǝ nǝm tor gip mbatl gino, kii zam argon tu kup kǝ liri gwa.>> ");
INSERT INTO plj_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Nan Yesu te gip Bom kǝ Yami tǝ den kulci mbarǝmo, ar ni kiri mǝn keri bar ju ɗiri yam na kiri kǝ bǝn ɗir kar ti, wu ngen momi wu wule, <<Bar ju kan kǝ den piwo na ikoyi gongen kǝ pi? Woni bi'i, biyiwe?>> ");
INSERT INTO plj_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ar ni Yesu nǝmi wur tǝ wule, <<Ami ma aa ngen momi kar kǝne. Kǝn ni kǝ manim bali argon tu a ngen momi kar kǝno,>> A yari in na ko unu ikoyi ni a pi bar ju. ");
INSERT INTO plj_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","O Yohanawo, na unu ikoyin tǝ pi batisma, na iko kǝ Yam na ko kǝ mbarǝm ni? Ar ni wu bali gip dlom gǝzǝn wu wule, <<Mǝn ni mǝ wule sur yam ni ar ɗǝlo, ti wule, unun kem mǝ nǝm ti tor gip mbatl gǝmi dawu? ");
INSERT INTO plj_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ama mǝn ni mǝ wule kǝ mbarǝm no, mǝ kum bǝrti kǝ mbarǝme. Domici mbarǝm mom'e Yohanawo mǝn yari shirǝm kǝ Yam ni.>> ");
INSERT INTO plj_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ar ni wu nǝmi ti wu wule, <<Mǝ mom da'a.>> Ar ni Yesu nǝm tǝ wul wur'e untu no, <<Ami ma, A yari in na unu ikon a pi bar ju da'a.>> ");
INSERT INTO plj_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","<<Unun kǝ dami we? Mbarǝm gon ra mǝn mimir moni rop. Tǝ ri kar kǝ pariyi tǝ wule, <Nya gǝni sekǝno ri pi mbap gip kǝn inabi.> ");
INSERT INTO plj_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ama nyayi nǝmi ti tǝ wule, <O'o, aa zam ritǝn da'a.> Ama den kaari nan tǝ dam tiwo ar ni tǝ ri. ");
INSERT INTO plj_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Kan bǝbayi ba ri kar nye gǝpi tǝ yari ti untu pa'e, nyayi ba nǝmi ti tǝ wule, <Aan ari bǝba.> Ama tǝ ri da'a. ");
INSERT INTO plj_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Gip mimir rop juwo, gonge ni kop shirǝm kǝ bazin we?>> Ar ni wu wul ti'e, <<Nye kǝ pariyi ni,>> Ar ni Yesu wul wur'e, A yari in ge shirǝmi, mǝn nǝmi wurpi bomi na mǝn bi gǝs kaari ba ɓotl ka den kǝn kǝ ba tetǝn gip mulki kǝ Yami. ");
INSERT INTO plj_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Domici Yohana ɗir gode in guntǝp kǝ pitǝn dlat, ama kǝ nǝm tor gip mbatl gin da'a, ama mǝn nǝmi wurpi bom na mǝn bi gǝs kaariwo wu nǝmi. Ama kup na kǝ shin bar juwo, kǝ ci atl gam kǝ ngǝsh den ti da'a. ");
INSERT INTO plj_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Kum ni shirǝm gon esi, <<Ba mǝn kǝn gon ra kan ngani kǝn gǝs gwa. Ar ni tǝ gandǝlika na panye, kan tǝ bor ba zho'i mal kin inabi, tǝ pa tu kupshi kǝ mǝn ɓuti kǝni. Ar ni tǝ bi mǝn kori bar jen kǝni kǝdǝ wu ɓom dene, kan tǝ ndara gip bǝn goni. ");
INSERT INTO plj_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Nan wokoci rǝshi kǝni ɗiro, ar ni ba mǝn kǝni kar zher gǝs wu ri kar mǝn kori kǝni, den'e wu bi ti argon tu ndari dǝ bi ti gip gǝri kin inabiyi gwa. ");
INSERT INTO plj_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ama ar ni munju kan nǝm kǝni kǝ dǝ wu ɓom dene nǝm zher gǝsi, wu ɓo nǝm, wu ri gon eka, kan wu pi ta la'i gon na tate. ");
INSERT INTO plj_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kan tǝ kar zheri jen es kan womti man kǝ pari gwa, ar ni mǝn ɓomi den kǝni pi wur untu pa'e. ");
INSERT INTO plj_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Den kariwo, ar ni tǝ kar nya gǝsi, tǝ wule, <Wi shin nartǝn kǝ nya gǝni.> ");
INSERT INTO plj_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ama nan mǝn kori kǝni shin nyayiwo, ar ni wu wul ezǝn'e, <Nya tu kan kǝni ba dǝm gwas gwan tu den ɗirtǝne. Ɗir ni mǝ ritǝni eka dǝ kǝni dǝmi mi ra!> ");
INSERT INTO plj_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ar ni wu nǝm ti, kan wu byal ti kaar kǝni, wu ri ti eka. ");
INSERT INTO plj_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ra untuwo, mǝn bas kǝnin palo, unun ti pii mǝn ɓomi den kǝniwe?>> ");
INSERT INTO plj_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Kan wu wul ti'e, <<Ti la mǝn ɗasi tu ju gip dun mǝshtǝni, kan tǝ nǝm kǝni ka tǝ bi munju kan baa bi ti argon tu ndari, wini wu rǝsh gwa.>> ");
INSERT INTO plj_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ar ni Yesu wul wur'e, <<Kǝ tabe ni zhǝti gip tǝlankur kǝ Yam diya? <Tat tu kan mǝn tu'i bom ngewo, ar ni dǝm tat tu kan man ko gonge tat tu'i bomi gwa. Muntuwo, pi kǝ Babom ni, eso bar kǝ nǝmi bi na am ni kar mi.> ");
INSERT INTO plj_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ra untuwo, a yari ine, mulki kǝ Yamo, baa zote ka kar kǝne, dǝ bi mbarǝm jeni kan ba pi ho bar gwa. ");
INSERT INTO plj_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Muntu kan kup nda den tat tu, ti cen ka kucil-kucil, ama muntu tati nda den tiwo ar ba lu tika.>> ");
INSERT INTO plj_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nan kiri mǝn keri bar ju ɗiri Yam na mǝn Parise, kum argon tu Yesu yariwo, ar ni wu momka'e, den wurni tǝ den shirǝmi. ");
INSERT INTO plj_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ar ni wu ngen tǝp kǝ nǝmi gǝsi, ama bǝrti ci wurka den womti mbarǝmi, domici wu mom'e Yesuwo mǝn yari shirǝm kǝ Yam ni. ");
INSERT INTO plj_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu pa shirǝm nan wur na misali tǝ wule. ");
INSERT INTO plj_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","<<Mulki kǝ to yam ka nǝra wule gun gon kan ne nyel gudlumi kǝ nya gǝs gwa. ");
INSERT INTO plj_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Tǝ kar zher gǝs dǝ la bi munju tǝ ngen wur kǝ dǝ wu ɗir kǝba nyeli gwa. Ama wu nge ɗirtǝnka. ");
INSERT INTO plj_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Tǝ pa kar zher gǝs jen tǝ wule, <Yari ni munju a ngen wur kǝ dǝ wu ɗir kǝba nyeli gwa'e, a pi fingal wi, kan a mbosh tla gi kǝn na tla ju kan ket wur gwa wi, ko unu ra mak wi. Ɗir ni kǝba nyeli!> ");
INSERT INTO plj_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ama mǝn dǝkiyi nge kumika, kan wu ndara won gǝzǝni, gon ba ndara gip kǝn gǝsi gon ngapo kǝba bar pǝt gǝsi. ");
INSERT INTO plj_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Jen ngapo wu nǝm mir zher gǝsi, wu ɓo wuri, kan wu ri wur eka. ");
INSERT INTO plj_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ar ni lo ci gunyi hoyi, kan tǝ kar mǝn bi'utu gǝs wu ri wur eka, kan wu keri bǝn gǝzǝnka. ");
INSERT INTO plj_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Kan tǝ wul ga zher gǝsi'e <Pa'i ko unu kǝ nyeli wi, ama mǝn dǝki ju kan a ngen wur kǝ ba nyeliwo, wu ndari da'a. ");
INSERT INTO plj_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ra'untuwo, kop ni guntǝp-guntǝpe kǝ la ni bi muntu kup kǝ shin ti gwa tǝ ɗir kǝ ba nyeli.> ");
INSERT INTO plj_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ar ni zher gǝsi kop bi guntǝp-guntǝpi, wu la bi mbarǝm ju wu zam wur gwa, hoyi na bes mbarǝme, kan ba nyeli ba laa'i na mǝn dǝki. ");
INSERT INTO plj_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Nan gunyi ɗir kǝ shini ba nyeliwo, ar ni tǝ shin mbarǝm gon kan la tutul dli kǝ nyeli da gwa. ");
INSERT INTO plj_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ar ni tǝ wul mbarǝmi'e <Berǝm, imnu pi kan kǝ ɗir ɗe bat na tutul dli kǝ nyeli we?> Ama mbarǝmi mom argon tu ti bali ti gwa da'a. ");
INSERT INTO plj_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ar ni gunyi wul mǝn mbap gǝsi'e <ɓal ni mbarǝmika am na asǝme, kǝ la ti ni te gip dun las tuka, las tu ba kul na ngasi kur bi gwa. ");
INSERT INTO plj_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Munju la wur biwo na womti ni wura, ama munju zǝzariwo njem ni.> >> ");
INSERT INTO plj_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ar ni mǝn Parise ri mo gam wu dam wur den kandatu wi nǝm Yesu den shirǝm gǝs gwa. ");
INSERT INTO plj_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ar ni wu kar mir mǝn kulci kar wur na mbarǝm kǝ Hiridus jen wu wule, <<Ba mǝn kulci, mǝ mom'e ki mǝn pitǝn dlat ni. Kǝ kulci mbarǝm guntǝp kǝ Yami. Kano kǝ pǝn mbarǝm kup nǝm ni kar ki. Eso kǝ pǝn den mbarǝm gon ra kan man gon gwa da'a. ");
INSERT INTO plj_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kǝkǝno yari mi, ar mbun'e dǝ ɓatl wurpi bom dǝ Kaisar gomna kǝ Romaya, ko ar ndari da'a?>> ");
INSERT INTO plj_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ama nan Yesu mom damtǝn kǝ ɗasi tu gǝzǝn kawo, ar ni tǝ wul wur'e <<Kǝn mǝn se mbarǝme! Unun kem kǝ ndu kǝ godem we? ");
INSERT INTO plj_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Godem ni wurpi tu kan ba ɓatl wurpi bomi na ri gwa.>> Ar ni wu ɗiri ti dinari, ");
INSERT INTO plj_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","tǝ wul wur'e, <<Shishidǝr na sun kǝ woni den dinariyi?>> ");
INSERT INTO plj_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Wu wul ti'e, <<kǝ Kaisar ni.>> Ar ni tǝ wul wur'e, <<Bi ni Kaisar argon tu kan kǝ Kaisar ni gwa, kan kǝ pa bi ni Yam argon tu kan kǝ Yam ni gwa.>> ");
INSERT INTO plj_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Nan wu kum utuwo, ar ni wu nǝm bi na am wu za ti kan wu ndara. ");
INSERT INTO plj_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Gasiwo, ar ni mǝn Sadukiya jen munju ba wule tlitǝn kǝ mǝshi mbarǝm ra da'a, ɗir kar Yesu, wu ngen momi kar ti, ");
INSERT INTO plj_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","wu wule <<Ba mǝn kulci! Musa wule, <Mbarǝm ni zam gǝri na gǝr gǝs da'a kan tǝ mǝsh kawo, esi baa mani gudlumi na gǝri kǝ dǝ tǝ zami mǝn bari gǝs mimiri.> ");
INSERT INTO plj_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Yas mbarǝm jen ra nyingi gip mi mǝn gǝpi na mǝn bari, bari gǝzǝn gudlumi na gǝre, tǝ mǝshka tǝ zam nya da'a tǝ za'i muntu ba kop ti gwa gǝri. ");
INSERT INTO plj_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Untu ni pi na kǝ rop na kǝ myakan bari nǝm kǝ nyingiyi. ");
INSERT INTO plj_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Den kaariwo ar ni gǝri mǝshka. ");
INSERT INTO plj_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Yari mi. Gǝri baa dǝm kǝ woni gas tu mǝshi mbarǝm baa tli gwa we? Domici tǝ gudlumi na kup nyingiyi!>> ");
INSERT INTO plj_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ar ni Yesu nǝmi wur tǝ wule, <<kǝ jilka wi, domici kǝ mom shirǝm kǝ Yam da'a, eso kǝ mom iko kǝ Yam da'a. ");
INSERT INTO plj_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Gas tlitǝn kǝ mǝshi mbarǝmo, gudlumi ra da'a. Mbarǝm ba nǝra wule mir mǝn kartǝn kǝ Yam to yamka. ");
INSERT INTO plj_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Eso, den tlitǝn kǝ mǝshi mbarǝm gip gam bǝci'o, kǝ zhit ni argon tu Yam yari'in gwa diya? Ar ra na rǝshi'e, ");
INSERT INTO plj_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","<Ami ni'e muntu kan Ibǝrahim na Ishaku na Yakubu ba bote ti gwa.> Tiwo mǝshi mbarǝm ni ba bote ti da'a ama mǝn ge mbatl ni.>> ");
INSERT INTO plj_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nan mbarǝm kum untuwo, ar ni wu nǝm bi na am den kulci gǝsi. ");
INSERT INTO plj_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ama nan mǝn Parise kum Yesu ngub bi kǝ mǝn Sadukiyawo, ar ni wu dom wuri. ");
INSERT INTO plj_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Gon gip wur mǝn kulci mbarǝm tǝlankur kulci kǝ Musa, gode Yesu na ngeni momi. ");
INSERT INTO plj_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Tǝ wul Yesu'e <<Mǝn kulci, dokayi gonge ni mani nartǝn kup gip tǝlankur kulci kǝ Musa we?>> ");
INSERT INTO plj_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ar ni Yesu nǝmi ti tǝ wule, << <Ndu Babom Yam gi na mbatl gi kup na ge mbatl gi kup na damtǝn gi kup.> ");
INSERT INTO plj_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Muntu ni'e doka kǝ pari eso, tin tǝ nar mani. ");
INSERT INTO plj_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Kǝ ropiwo, ar ni ra wule mǝntayi, kǝ ndu berǝm dǝmi gi wule gam gi. ");
INSERT INTO plj_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Tǝlankur kulci kǝ Musa na kǝ mǝn yari shirǝm kǝ Yam kup den doka rop ju ni ar ra.>> ");
INSERT INTO plj_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Nan mǝn Parise dom wur kǝ ba lasi nǝmo, ar ni Yesu ngen momi kar wur tǝ wule, ");
INSERT INTO plj_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","<<Ununu'e, damtǝn gin den Almasihu we? Tǝ gǝs gal kǝ woni?>> Ar ni wu wul ti'e, <<Tǝ gǝs gal kǝ Dauda ni.>> ");
INSERT INTO plj_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesu wul wur'e, <<Kan imnu, Dauda tǝp kǝba iko kǝ Ruhu ba la ti bi'e, Babom gǝnu? Domici Dauda wule, ");
INSERT INTO plj_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","<Babom wul Babom gǝn'e Dǝm den am shimli gǝni se, amin, a pali mǝn gapa nan ki atli dǝ asǝm gǝ.> ");
INSERT INTO plj_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Tun kan Dauda la ti bi'e Babomo, Imnu Almasihu ba dǝm gǝs gal gǝs we?>> ");
INSERT INTO plj_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ko nǝm gon ra gip wur kan mani ti bali gwa da'a. Gasi ar ri cinawo murgon ra kan'i ngen momi kar ti gwa da'a. ");
INSERT INTO plj_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nan mbarǝm dom wur na womti na mir mǝn kulci kar tiwo, ar ni Yesu wul wur'e, ");
INSERT INTO plj_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","<<Mǝn kulci mbarǝm tǝlankur kulci kǝ Musa na mǝn Parise ni bi wur mani bali tǝlankur kulci kǝ Musa. ");
INSERT INTO plj_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ra'untuwo, pi ni argon tu kup wu kulci in gwa kǝ kop ni esi. Ama ba kǝ kop ni argon tu wu pi gwa da'a. Domici wu pi argon tu wu kulci gwa da'a. ");
INSERT INTO plj_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Wu ɓali mbarǝm gosgam mǝn giɓǝrtǝn hoyi wu ne wur den bibyala, wu ngapo wu ne wur am ra gip pǝni da'a ko nya yasa nǝm. ");
INSERT INTO plj_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Kup argon tu wu piwo kǝ dǝ mbarǝm shin ni katl. Wu gucip mir tǝlankur kan rǝsh shirǝm kǝ Yam gipi gwa wu ɓal den goshi gǝzǝni, na la'i tlyari zare den bi lulur gǝzǝni. ");
INSERT INTO plj_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Eso wu ndu'e dǝ bi wur ba dǝmi kǝ kiri kǝba nyele, na ba dǝmi tu kan mbun mani gwa gip bom domtǝn kǝ mǝn Yahuda. ");
INSERT INTO plj_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Wu ndu dǝ shirmi wur kǝ ba domtǝn kǝ mbarǝm ko gigasi, dǝ wul wur'e <mǝn Kulci.> ");
INSERT INTO plj_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ama kǝno ba dǝ la kǝn ni bi, <Mǝn kulci da'a.> Domici mǝn kulci gino nǝm ni, kan kup gin eso kǝn yas ni. ");
INSERT INTO plj_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ba kǝ la ni bi murgon'e, <Bǝba> Den kar atl da'a, domici bǝba nǝm ni ne ine muntu kan ra to yamka gwa. ");
INSERT INTO plj_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ba kǝ zani dǝ gon lakǝn bi'e, <Mǝn cina da'a> domici mǝn cinayo nǝm ni, ti ni'e Almasihu. ");
INSERT INTO plj_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Bari gip kǝno ti ni tii dǝm mǝn pi'in mbapi. ");
INSERT INTO plj_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Muntu kup ɗǝɗa gam gǝso baa pali ti atli, kano muntu pali gam gǝs atli ngapo baa ɗǝɗa ti. ");
INSERT INTO plj_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ama kashto gi ni kǝn mǝn kulci mbarǝm tǝlankur kulci kǝ Musa na mǝn Parise. Mǝn pi tǝn wule ho mbarǝme! Kǝ le bǝdlabǝn tetǝn gip mulki kǝ to yamka, kǝn na gam gin ngapo kǝ te gipi da'a, eso mǝn ndu'i tetǝn ngapo kǝ hane wur ka. ");
INSERT INTO plj_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Kashto gi ni kǝn mǝn kulci mbarǝm tǝlankur kulci kǝ Musa na mǝn Parise Mǝn pi tǝn wule ho mbarǝme! Kǝ zup ka den bar kǝ am kǝ mǝtli jukan moni gǝzǝn mǝshka gwa, eso kǝ pi tlyari shǝrǝm na Yam kǝ dǝ shin kǝn ra, ra untuwo, baa hukunte in hoyi. ");
INSERT INTO plj_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Kashto gi ni kǝn mǝn kulci mbarǝm tǝlankur kulci kǝ Musa na mǝn Parise. Mǝn pitǝn wule ho mbarǝme! Domici kǝ jikat bar ɓula kǝ ri atl tu kan ra na dlyami kǝ ngeni mǝn ci atl gam nǝm. Kǝn ni kǝ zam ngapo, kǝ pali ti nye mǝn bom utu gucipi rop ar man kandatu kǝn ra gwa. ");
INSERT INTO plj_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Kashto gi ni kǝn tabi mbarǝm mǝn kopi na mbarǝme! Kǝ wule <Argon ni da'a, dǝ ɓo am atl na bom kǝ Yami, ama murgon tu ɓo am atl na zǝnariya kan te gip bom kǝ Yam kawo, Kǝ wule ar nǝm ti te yarka tǝ pi argon tu tǝ ɓo am atli deni gwa.> ");
INSERT INTO plj_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Kǝn kǝdlǝm tabi! Gongen naar mani, zinariya na, ko bom kǝ Yam kan pash zinariyayi gwa ni? ");
INSERT INTO plj_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kǝ wul es'e, <kup muntu ɓo am atl na bagadiwo, argon ni da'a. Ama muntu kan ɓo am atl na wurpi kan bi den bagadiwo, ar nǝm ti te yarka tǝ pi argon tu tǝ ɓo am atli dene gwa.> ");
INSERT INTO plj_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Kǝn ga tabi! Gonge ni'e bari, bar ju bi den bagadiyi gwa na, ko bagadi tu kan ba pash bar ju bi den bagadiyi gwa ni? ");
INSERT INTO plj_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ra untuwo muntu kup ɓo am atl na bagadiwo, tǝ ɓoni am atl nari na kup argon tu kan ra dene gwa ituwi. ");
INSERT INTO plj_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Eso muntu kup ɓo am atl na bom kǝ yamo, tǝ ɓo ni am atl nari na Yam muntu ba dǝm gip bomi gwa. ");
INSERT INTO plj_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Muntu kup ɓo am atl na to yam ka wo, tǝ ɓo ni am atl na dandi kǝ Yami na Yam kan ba dǝm den dandiyi gwa. ");
INSERT INTO plj_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Kashto gi ni kǝn mǝn kulci mbarǝm tǝlankur kulci den kulci kǝ Musa na mǝn Parise. Mǝn pitǝn wule ho mbarǝme! Kǝ bi zakka kǝ ɗapti borkono na kǝ woli, ama kǝ za kiri zo bar ju tǝlankur kulci kǝ Musa yari dǝ pi kagwa, wi ni'e, pi ge shirǝmi, shini guna'i, na aminci. Munju ni ndari dǝ pi, bat na za'i nami ka. ");
INSERT INTO plj_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Kǝn tabi mǝn kopi na mbarǝme, kǝ cica ga salǝm ka gip mal tle gi ni, ama kǝ zhinge Rakumi. ");
INSERT INTO plj_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Kashto gi ni, kǝn mǝn kulci mbarǝm tǝlankur kulci kǝ Musa na mǝn Parise. Mǝn pitǝn wule ho mbarǝme! Kǝ mani ho'i kaar galka na gal kini, ama gipiwo laa'i ni ar ra na wani pitǝn kǝ cucetǝne na ndu'i gami. ");
INSERT INTO plj_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ki tabi mǝn Parise! Ho gip wuromal na gip galkini kakani kan dǝ kaar gǝzǝn mbuni. ");
INSERT INTO plj_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Kashto gi ni kǝn mǝn kulci mbarǝm tǝlankur kulci kǝ Musa na mǝn Parise. Mǝn pi tǝn wule ho mbarǝme! Kǝn nǝra wule gambici tu kan zapi kaari na ghol atl kan ba shin mbutǝn gǝs gwa, ama gipiwo, gul kǝ mǝshi mbarǝm ni, na ko unu ndotti. ");
INSERT INTO plj_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Untu ni kǝn ra, Kariwo ba shin kǝn wule kǝn mǝn pitǝn dlat ni ama gipiwo, kǝn ra laa'i na setǝne na nge kopi doka. ");
INSERT INTO plj_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Kashto gi ni kǝn mǝn kulci mbarǝm tǝlankur kulci kǝ Musa na mǝn Parise. Mǝn pi tǝn wule ho mbarǝme! Kǝ tu gam bǝci kǝ mǝn yari shirǝm kǝ Yami, kǝ kem dǝ gambici kǝ mǝn pitǝn dlat mbuni. ");
INSERT INTO plj_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Kǝ wule, mǝn nǝra far na ga kori gǝmiwo, na mii ngash gam nan wur gip ri mǝn yari shirǝm kǝ Yam eka da'a. ");
INSERT INTO plj_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Untuni gode'e kǝn gǝsgal kǝ munju kan ri mǝn yari shirǝm kǝ Yam eka gwa ni. ");
INSERT INTO plj_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ra untuwo ci ni cina kǝ pa'i ni warwat pitǝn ju, ga kori gin la gǝsi gwa. ");
INSERT INTO plj_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Kǝn ga ici'e, ga badǝr kǝ wonzi! Imnu kii ɗǝli gam ginka gip hukuntetǝn kǝ bom utuwe? ");
INSERT INTO plj_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ra'untuni, a kari in bar na mǝn yari shirǝm kǝ Yami, na mǝn bopya, na mǝn kulci mbarǝm tǝlankur kulci kǝ doka kǝ Musa. Kii ri jen eka na ɓa'i gǝzǝn den kini, jen eso kii ɓo wur na rǝɓa'e kǝba domtǝn gi ni na kopi jen bǝn-bǝni, kǝn den kumi wur dli. ");
INSERT INTO plj_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Aa kar wur ni ɗir kǝ dǝ bǝran kǝ mǝn pitǝn dlat ju kan ri wur eka gwa ni den gam gini, wule ga Habila mǝn pitǝn dlat na Zakariya nya Barakiya muntu kǝ ri ti eka gip dlom bom kǝ Yam na ba keri bar ju ɗiri Yam gwa. ");
INSERT INTO plj_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","A yari in ge shirǝmi, bar ju kup baa zam ni mbarǝm kǝ zhan kǝni. ");
INSERT INTO plj_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Kǝn mǝn Urushalima, mǝn Urushalima! Kǝn mǝn ri mǝn yari shirǝm kǝ Yam eka, na la'i munju kan kar wur kar kǝn na tat gwa! Biyi mǝne ni a ndu domi mimir gin wule, kandatu nas kor ba dom mimir gǝs kan tǝ ghum wur ka na bibako gǝsi gwa, ama kǝ ndu untu da'a. ");
INSERT INTO plj_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ar tu bom gin i na mur gon da'a. Ar dǝm kawi koni. ");
INSERT INTO plj_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","A yari'in ka, ki'i shimǝn da'a, se kǝn ni kǝ wule, <Mǝn albarka ni muntu ba ɗir gip sun kǝ Babom gwa!> >> ");
INSERT INTO plj_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Nan Yesu za Bom kǝ Yamiwo, ar ni mir mǝn kulci kar ti gode ti kanda kǝ bom ju kan ra gip Bom kǝ Yami. ");
INSERT INTO plj_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ama tǝ wul wur'e, <<Kǝ shin Bom tu kan tu gwaya? A yari ine tat gon ra kan baa sa den gon gwa da'a. Baa yasi ka kup.>> ");
INSERT INTO plj_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Nan Yesu ra njon den tlǝndǝr mǝn kin Zaituno, ar ni mir mǝn kulci kar ti ɗir kar ti mol, wu wul ti'e, <<Yari mi, gigasi ni bar ju ba pi, kano ununu'e, halama kǝ paltǝn gi sur na kǝ patǝn kǝ zhan kup we?>> ");
INSERT INTO plj_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ar ni Yesu wul wur'e, <<dǝm ni gǝɗǝn, ba dǝ murgon jǝli in nika da'a. ");
INSERT INTO plj_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Domici mbarǝm na womti baa ɗir gip sun gǝni, wu wul kǝn'e, <Ami ni'e Almasihuyi.> Na untun wi jǝli mbarǝm ka na womti. ");
INSERT INTO plj_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Kii kum tlitǝn kǝ dlan na Shirǝm tlitǝn kǝ dlan na womti, ama badǝ bǝrti ci in ni da'a. Aan, ar nǝm dǝ bar ju pi, ama patǝn kǝ zhan kupi ɗirwi da'a. ");
INSERT INTO plj_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Atl ba tli atli gon gami, kan dǝ mbarǝm kǝ gun gon tli mbarǝm kǝ gunyi gon gami. Ba pi guzum na jirkǝttǝn kǝ atl kǝ ba las na womti. ");
INSERT INTO plj_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Munju kupo, pare kumi dli kǝ mǝn gǝri nya ni. ");
INSERT INTO plj_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Baa bi in ka am dǝ mbarǝm dǝ kumi in dli, wu ri in eka. Baa nge in gip atl kup den bi sun gǝni. ");
INSERT INTO plj_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Wokociyi ni, ngǝshtǝn den Yam kǝ mbarǝm na womti ba iɗaka, kan wu bi ezǝn ka, wu nge ezǝn esi. ");
INSERT INTO plj_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Eso mǝn lar yari shirǝm kǝ Yam baa cwati, kan wu jǝli mbarǝmka na womti. ");
INSERT INTO plj_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Domici kǝ nartǝn kǝ ɗasi tu'o, ndutǝn kǝ mbarǝm na womti baa iɗaka. ");
INSERT INTO plj_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ama muntu kan ɓa mbatl dlom gam ar ri patǝn kǝ bar kupo, baa ɗǝli ti. ");
INSERT INTO plj_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Baa pi wazu kǝ zo shirǝm kǝ mulki kǝ to yamka gip atl kundǝrǝndlip den bi seda dǝ mbarǝm kǝ atl kup, kan dǝ patǝn kǝ bar kupi i ɗiri. ");
INSERT INTO plj_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Kǝn ni kǝ shin bar kǝ dǝɗan kan ba kem mǝshtǝn, muntu kan mǝn yari shirǝm kǝ Yam Daniel yari gwa ra kǝba las mǝn Tsarkiwo, naa dǝ mǝn zhǝti tǝlan kuri momi! ");
INSERT INTO plj_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Munju kan ra gip kǝti atl kǝ Yahudawo, wu kǝtǝr wu to gǝzǝn gip tlǝndǝre. ");
INSERT INTO plj_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Muntu kan ra to kush kǝ yami kawo, ba tǝ ɗǝl sur tǝ ngen tetǝn kǝ pǝni ar gon gip bomi da'a. ");
INSERT INTO plj_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Muntu kan ra rǝn gip kǝn kawo, ba tǝ pal rǝn bom ka kǝ pǝni tutul ghumtǝn gǝs da'a. ");
INSERT INTO plj_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kashto kǝ mǝtli mǝn tu'e, na munju kan den bii mimir nyin gip wokoci ta gwa! ");
INSERT INTO plj_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Shirǝm ni na Yam badǝ kǝtǝr tu ɗiri in ni gip watlǝn, ko den pǝt shukutǝn kǝ mǝn Yahuda da'a. ");
INSERT INTO plj_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Domici wokociyiwo, baa kum dli hoyi muntu kan tabe pi da'a na ne gǝs kǝ pi atl ar ɗir sekǝni. Eso, baa i pi badǝr kumi dli tu da'a. ");
INSERT INTO plj_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","E dǝ wule cani muri juka dawo, na nya mbarǝm gon ra kan baa zam ɗǝltǝn gwa da'a. Ama domici kǝ munju kan Yam zǝzari wo, ba ca muri kǝ kumi dliyi ka. ");
INSERT INTO plj_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Wokociyiwo, gon ni wul kǝn'e, <Shin ni, Almasihun kǝni!> Ko, <Tin ta!> Ba kǝ nǝm ni da'a. ");
INSERT INTO plj_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Domici ga Almasihu kǝ lar na ga mǝn lar yari shirǝm kǝ Yam baa cwati, kan wu pi bar kǝ nǝmi bi na am na bar kǝ dlǝkǝntǝne. Kǝdǝ ar ni baa piwo, wu jǝli munju kan ma zǝzari ni gwa. ");
INSERT INTO plj_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Kum ni, A yari in wi bǝle-bǝle. ");
INSERT INTO plj_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ra'untuwo, murgon ni wul kǝn'e, <Tin ta, gip lǝpe,> ba kǝ ɗǝlni rǝnka da'a. Ko tǝ wule, <Almasihu yin ta na ghuuni te kushi ka,> ba kǝ nǝm ni da'a. ");
INSERT INTO plj_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kandatu cirtǝn kǝ cibi kǝ Yam ba ɗǝl gabǝs ar to yamma wo, untu ni paltǝn kǝ Nya mbarǝm baa nǝra. ");
INSERT INTO plj_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Las tu mǝshi bar rawo, lasini zhipki ba dom wuri. ");
INSERT INTO plj_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Na patǝn kǝ muri kǝ kumi dli juwo, Pǝt baa palka dǝmǝni, kan dǝ kyar nge cirtǝnka, Ga zǝnges ba ro sur yamka, kan dǝ jǝrkǝt bar mǝn iko kǝ to yam ka. ");
INSERT INTO plj_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Wokociyi ni baa shin halama kǝ Nya mbarǝm ɗǝl to dlom yam ka, kan dǝ mbarǝm kǝ atl kup pi kulu keti. Wi shin surtǝn kǝ Nya mbarǝm gip dun yami, na iko, na ɗǝɗatǝn mǝn nartǝni. ");
INSERT INTO plj_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Tii kar mir mǝn kartǝn kǝ yam na hori nyo mǝn larǝmtǝn hoyi, kan wu dom munju kan zǝzar wur gwa, gip kǝti wupse kǝ atl kundǝrǝndlip. ");
INSERT INTO plj_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Kulci ni den kin turume. Kǝn ni kǝ shin am kini sanje ka kan ba pare gilitǝno, kǝ mom'e watlǝn mbira kosak ituwi. ");
INSERT INTO plj_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Untu ni es, kǝn ni kǝ shin bar ju den pitǝno, mom ni'e wokociyi mbira wi kosak, ar mbi bǝdlabǝn wi. ");
INSERT INTO plj_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ge shirǝm ni a yari in'e, mbarǝm kǝ zhan kǝn baa mǝshka da'a, se bar ju ni kup piwi gwa. ");
INSERT INTO plj_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Yam na atl baa paka, ama shirǝm gǝn baa paka da'a. ");
INSERT INTO plj_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Murgon ra kan mom pǝti ko awayi gwa da'a, ko mir mǝn kartǝn kǝ Yam to yamka, ko Nyayi, ama Bǝbayi ni katl momi. ");
INSERT INTO plj_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Wule kandatu ar pi gip wokaci kǝ Nuhu gwa, untun baa pi wokoci tu Nya mbarǝm ba sur gwa. ");
INSERT INTO plj_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Wule gip muri ja, kapǝn bar ghon kan sar ko-unuka den kaar atlo, mbarǝm ra den ci na tle, moni den gudlumi, kan den ri mir mǝtlika gip kushi, ar ba ri gas tu kan Nuhu to gip Kungǝlǝn jikat mali gwa. ");
INSERT INTO plj_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Mbarǝmi mom argon tu bari kǝ pitǝn gwa da'a, ar ni mal kos den wur kan ba sar wurka kup. Untun paltǝn kǝ Nya mbarǝm baa nǝra. ");
INSERT INTO plj_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Wokoci tawo mbarǝm rop baa nǝra den mbap gip kǝne, baa pǝn nǝmka, dǝ za nǝmi. ");
INSERT INTO plj_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Mǝtli rop baa nǝra den lu'i bari den ghuni, baa pǝn nǝmka dǝ za nǝmi. ");
INSERT INTO plj_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ra'untuwo, dǝm ni gǝɗǝn, domici kǝ mom pǝt tu kan Babom gin baa sur gwa da'a. ");
INSERT INTO plj_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ama mom ni muntu, dǝ wule babom baa mom wokoci tu mur baa te ti gip bom gip gaso, na tii dǝm gǝɗǝn, tǝ hane muri tetǝn gip bom gǝsika. ");
INSERT INTO plj_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ra'untuwo, kǝn ma dlǝr ni gǝɗǝn, domici Nya mbarǝm baa sur ni wokoci tu kǝ mom da gwa. ");
INSERT INTO plj_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Wo ni'e zher mǝn aminci na bopya, muntu kan babom gǝs ne ti gam bom gǝsi, kǝ dǝ tǝ bi nami zheri fingal den wokoci tu ar ndari gwawe? ");
INSERT INTO plj_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ar ba mbuni zhertu kan Babom gǝs pal kan tǝ zam ti tǝ den pi mbap gǝs gwa. ");
INSERT INTO plj_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ge shirǝm ni a yari ine, babomi baa ne ti den gam kǝ bar ju kup tǝra nari gwa. ");
INSERT INTO plj_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ama zheri ni dǝm mǝn wani pitǝno, kan tǝ wul gam gǝs'e, <Babom gǝn baa pal bǝle da'a,> ");
INSERT INTO plj_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","kan tǝ nda gip ezǝn zheri na ɓe, tǝ den ci na tle na mǝn tle ɗu'e. ");
INSERT INTO plj_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Babom kǝ zher tu ba pal bat na momi kǝ zheri, den pǝt na awa tu kan tǝ mom da gwa. ");
INSERT INTO plj_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Babomi ba ɓo zheri hoyi, kan tǝ hukunte ti na mǝn setǝne. Lasi ni baa kul na ngasi kur bi.>> ");
INSERT INTO plj_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","<<Wokoci tawo, mulki kǝ to yamka baa nǝra wule mir mǝtli kutl kan yem pǝtǝla gǝzǝn ba ri kǝ mbori ba mǝn gudlumi gwa. ");
INSERT INTO plj_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Nantam gip wuro, kǝdlǝm ni, nantam ngapo mǝn bopya ni. ");
INSERT INTO plj_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Nantami kan kǝdlǝmno wu pǝn pǝtǝla gǝzǝni, ama wu pǝn mir es kǝ mbǝli ra den kǝ gip pǝtǝla gǝzǝni da'a. ");
INSERT INTO plj_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ama nantam mǝn bopya juwo, kan wu pǝn pǝtǝla gǝzǝni na mir es kǝ mbǝli ra gip mbun leti. ");
INSERT INTO plj_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ama nan ba mǝn gudlumiyi cwat bǝle dawo, ar ni kup gǝzǝn umur ghun wur kan wu nde umurka. ");
INSERT INTO plj_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Gip dlom gaso, ar ni wu kum latǝn bi den'e, <Ba mǝn gudlumiyi mbirawi! Ɗir mbor tǝni!> ");
INSERT INTO plj_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ar ni kup mir mǝtli kutli tlyam wu nǝm kǝrkǝm pǝtǝla gǝzǝni. ");
INSERT INTO plj_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Kan kǝdlǝmi ba wul mir mǝn bopyayi'e, <Mbǝli mi ni mir gin ngapi, domici pǝtǝla gǝmi den mǝshtǝnkawi.> ");
INSERT INTO plj_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ar ni mir mǝn bopyayi nǝmi wur wu wule, <O'o, ar baa kǝm mi nan kǝn da'a. Rǝni gip bǝn las tu ba wur mir kagwa, kǝ wur ni.> ");
INSERT INTO plj_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ama nan wu ra den tǝp ritǝn kǝ wuri miriwo, ar ni ba mǝn gudlumiyi cwati. Mir mǝtli ju kan ra gǝɗǝnwo, ar ni wu te kǝ ba nyel gudlumiyi nan ti, kan ba le bǝdlabǝn ka. ");
INSERT INTO plj_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Den kariwo, ar ni nami mir mǝtliyi pal ɗir wu wule, <Babomi! Babomi! Ɓuli mi bǝdlabǝni!> ");
INSERT INTO plj_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ama tǝ nǝmi wur tǝ wule, <Na ho bi ni a yari in'e, a mom kǝn da'a.> ");
INSERT INTO plj_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ra'untuwo, dǝm ni gǝɗǝn, domici kǝ mom pǝti ko wokociyi da'a. ");
INSERT INTO plj_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Eso mulki kǝ to yamka baa nǝra wule mbarǝm tu kan bari kǝ ɓomi asǝm gwa, kan tǝ la bi ga zher gǝs tǝ ne wur den gam bar gǝsi. ");
INSERT INTO plj_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Tǝ bi nǝm talanti nantam, gon ngapo talanti rop, kan nǝmiwo, talanti nǝm. Tǝ bi ni ko gonge den bi argon tu ti mani pi gwa. Kan tǝ nǝm tǝp tǝ ndara. ");
INSERT INTO plj_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Muntu kan bi ti talanti nantamiwo, ar ni tǝ ri ci bar pǝte kan tǝ zam talanti nantam ra deni. ");
INSERT INTO plj_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Untu es muntu nǝm talanti ropi, tǝ ri ci bar pǝte, kan tǝ zam talanti rop ra deni. ");
INSERT INTO plj_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ama muntu kan nǝm talanti nǝmiwo, ar ni tǝ ri bor shu gip atli kan tǝ ghundǝr wurpi kǝ babom gǝsika. ");
INSERT INTO plj_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Den kaar kǝ tlyari wokociwo, ar ni babom kǝ zherju pal kǝ dǝ tǝ mom argon tu wu pi na wurpiyi gwa. ");
INSERT INTO plj_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Mbarǝm tu kan nǝm talanti nantamo, ar ni tǝ ter na talanti jen nantam esi, tǝ wule, <Babomi, kǝ bim talanti nantam, ar tu a zam nantam rawi es deni.> ");
INSERT INTO plj_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ar ni babom gǝs wul ti'e, <Kǝ pi hoyi, zher mǝn ho pitǝne, mǝn aminci! Kǝ pi aminci den heli bar kan bi'i gwa. Aa ne'i den gam mbap na womti. Ɗir kǝ pi ghol mbatl na babom gi.> ");
INSERT INTO plj_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Mbarǝm tu bi ti talanti ropiyi ɗir pa'e, tǝ wule, <Babomi, kǝ bim talanti rop, ar tu a zam talanti gucupi rop rawi deni.> ");
INSERT INTO plj_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ar ni babomi nǝmi ti, tǝ wule, <Kǝ pi hoyi, zher mǝn ho pitǝne, mǝn aminci! Kǝ pi aminci den wurpi njem kan bi'i gwa. Aa ne'i den gam mbap na womti. Ɗir kǝ pi ghol mbatl na babom gi.> ");
INSERT INTO plj_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ama nan mbarǝm tu kan nǝm talanti nǝmi ɗiro, ar ni tǝ wule, <Babomi, a mom kǝ ban naari, kǝ rǝsh las tu kǝ ngani da gwa, ki mǝn ndu'i ci nguɓuk ni. ");
INSERT INTO plj_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ar ni kem bǝrti ci mi, kan a ri bor shu gip atl a ghundǝr talanti gika. Shini nǝm bar gi!> ");
INSERT INTO plj_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Babomi nǝmi ti tǝ wule, <Ki zher mǝn ɗasi tu'e, mǝn la'are! Kǝ mom'e, a rǝsh ni las tu kan a ngani da'a, ami mǝn ndu'i ci nguɓuk ni. ");
INSERT INTO plj_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Unun kem kǝ ri nem wurpi gǝn gip bom ba ne wurpi, ami ni a palo, a zam wurpiyi na mbǝli ra dene dawu? ");
INSERT INTO plj_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ra untuwo, nǝm ni talanti nǝm tuka kar ti, kǝ bi ni muntu kan ra na talanti kutl ju gwa. ");
INSERT INTO plj_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Domici muntu kan ra na baro, baa mbǝli ti ra kan tǝ zam ar nari. Muntu kan ra nari da ngapo, nye njem tu kan tǝra nari ma baa nǝmka. ");
INSERT INTO plj_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","La ni wop zher tu te gip dun laska. Lasi ni baa kul na ngasi kur bi.> ");
INSERT INTO plj_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Wokoci tu Nya mbarǝm baa sur gip nartǝn gǝsi, na mir mǝn kartǝn kǝ Yam kupo, ti dǝm den dandi gǝs kǝ gun mǝn ɗǝɗatǝni. ");
INSERT INTO plj_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Mbarǝm kǝ atl kup baa dom wur kar ti. Kan tǝ zǝzar mbarǝm na nǝm-nǝm gip ezǝni kandatu mǝn le dabba ba ɗǝli tǝmka gip mar gwa. ");
INSERT INTO plj_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Kan tǝ pali tǝmi den am shimli gǝsi, mari ngapo den am yali gǝsi. ");
INSERT INTO plj_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Wokociyi ni gunyi baa wul munju kan den am shimli gǝsi'e, <Ɗir ni, kǝn kan Ban la'i in albarka gwa, kǝ nǝm ni gaado kǝ mulki tu Yam ne in terka na ne gǝs kǝ pi atl kundǝrǝndlip gwa. ");
INSERT INTO plj_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Domici nan Ami ra den kumi guzumo, kǝ bim fingali. Nan ami ra den kumi guzum malo, kǝ bin mal tle. Nan ami ra mǝn dǝkiwo kǝ rim bom da ine. ");
INSERT INTO plj_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nan ami ra na tutul dli dawo, kǝ bim tutul dli. Nan ami ra den kumi dliwo, kǝ ga'ǝmi. Nan ami ra gip bom kǝ moniwo, kǝ ɗir kǝ shini gǝni.> ");
INSERT INTO plj_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Wokociyi ni mǝn pitǝn dlat ju ba nǝmi ti wu wule, <Babomi akoni mǝ shin ki den kumi guzum kan mǝ bi'i fingal we, ko ki den kumi guzum male kan mǝ bi'i mal tlewu? ");
INSERT INTO plj_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Gigasi ni mǝ shin ki mǝn dǝkiyi, kan mǝ ri'i bom dami, ko kǝ den ndu'i tutul dli kan mǝ bi'i tutul dli kǝ la'iwu? ");
INSERT INTO plj_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Eso gigasi ni mǝ shin ki den kumi dli ko gip bom kǝ moni kan mǝ ri kǝ shini giwe?> ");
INSERT INTO plj_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Gunyi baa nǝmi wur tǝ wule, <Ge shirǝm ni a yari ine, argon tu kup kǝ pi nǝm gip mir heli gip mir ɓyaro, ami ni kǝ pi mi.> ");
INSERT INTO plj_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Kan tǝ wul munju den am yali gǝs gwa'e, <Pǝtl kǝn ni ka namǝni, kǝn wop mbarǝme, teni gip utu tu kan baa mǝsh ka da'a, kan kǝrkǝmi Shetan na mir mǝn kartǝn gǝs gwa. ");
INSERT INTO plj_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Domici nan ami ra den kumi guzumo, kǝ bim fingali da'a. Nan ami ra den kumi guzum malo, kǝ bim mal tle da'a. ");
INSERT INTO plj_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nan ami ra mǝn dǝkiwo, kǝ rǝm bom da in da'a. Nan a hol tutul dliwo, kǝ bim tutul dli kǝ la'i da'a. Nan ami den kumi dli, kan ra gip bom kǝ moniwo, kǝ ɗir kǝ shini gǝn da'a.> ");
INSERT INTO plj_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Wii nǝmi ti wu wule, <Babomi, gigasi ni mǝ shin ki den kumi guzumi, ko kǝ den kumi guzum male, ko kira mǝn dǝki, ko kira na tutul dli da'a, ko kǝ den kumi dli, ko kira bom moni kan mǝ ne'i amra dawu?> ");
INSERT INTO plj_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Gunyi baa nǝmi wur tǝ wule, <Ge shirǝm ni a yari ine, argon tu kup kǝ nge pi nye heli gip mir ɓyaro, ami ni kǝ ngem pi.> ");
INSERT INTO plj_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Munju ni baa te gip hukuntetǝn tu kan baa pa da gwa, ama mǝn pitǝn dlat ju ngapo gip ge mbatli kan baa pa da gwa.>> ");
INSERT INTO plj_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Nan Yesu pa'i yari shirǝm ju kupo, ar ni tǝ wul mir mǝn kulci kar ti'e, ");
INSERT INTO plj_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","<<Kǝ mom'e muri rop ni sa wi dǝ pi nyel jikat bǝdlabǝni, baa bi Nya Mbarǝm kǝdǝ ɓa tika den kini.>> ");
INSERT INTO plj_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ar ni kiri ga Liɓakǝ Yam, na kiri kǝ bǝn dom wur bom dǝ bari kǝ ga Liɓa kǝ Yami, mǝn sun'e Kayafa. ");
INSERT INTO plj_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Kan wu bali gip dlom gǝzǝn kǝdǝ wu nǝm Yesu mol wu ri ti eka. ");
INSERT INTO plj_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Wu wule, <<Ama ba'e wokoci kǝ nyel jikat bǝdlabǝn da'a, bǝse dǝ zam tli mbatl kar mbarǝme.>> ");
INSERT INTO plj_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Nan Yesu ra Betanya gip bom kǝ Simon muntu kan faro ba mǝn ndǝcci ni gwawo, ");
INSERT INTO plj_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ar ni nagǝr gon ɗir kar Yesu na mbun leti, laa'i na mir mǝn tǝmi kasǝri kan na wurpi nar gwa, kan tǝ shoti ti sur gam nan tǝra den ci fingal gwa. ");
INSERT INTO plj_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ama nan mir mǝn kulci kar Yesu shin untuwo, ar ni lo ci wuri, kan wu ngwar wu wule, <<Unun kem ti den li mir mǝn bar wurpika untuwe?>> ");
INSERT INTO plj_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","<<Ar baa mani dǝ wur mirika na wurpi mǝn nartǝni, dǝ bi munju am ri wur kaar da gwa.>> ");
INSERT INTO plj_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Nan Yesu mom damtǝn gǝzǝn kawo, ar ni tǝ wul wur'e, <<Unun kem kǝ ghun nagǝr tuwe? Mbuni bar ni tǝ pi mi. ");
INSERT INTO plj_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Kii nǝra na munju kan am ri wur kaar da gwa ko gigasi, ama amiwo, kii nǝra namǝn ko gigasi da'a. ");
INSERT INTO plj_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Tǝ shotim ni mir tu kǝ dǝ tǝ kǝrkǝm dli gǝn den bi kaptǝne. ");
INSERT INTO plj_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ge shirǝm ni a yari ine, las tu kup baa pi wazu kǝ zo shirǝm kǝ ci atl gam gip atl kundǝrǝndlipo, baa yari nagǝr tu den bi dami nan ti.>> ");
INSERT INTO plj_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ar ni nǝm gip kutl-cet ropi, muntu ba wul ti'e Yahuda Iskaryoti ri kar kiri mǝn keri bar ju ɗiri Yam gwa. ");
INSERT INTO plj_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Tǝ wul wur'e, <<Unun kii bi mi, ami ni a bi in ti gwawe?>> Ar ni wu dlǝm wurpi zǝnariya hauya nǝm na kutl wu bi ti. ");
INSERT INTO plj_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Den gas ta ni Yahuda Iskaryoti nǝm ngeni tǝp tu kan tii bi Yesu kagwa am dawuri. ");
INSERT INTO plj_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Den pǝt kǝ pari kǝ nyel burodi tu kan na yisti dagwawo, ar ni mir mǝn kulci kar Yesuyi ɗir kar ti wu wule, <<Ako ni kǝ ndu'e mǝ kǝrkǝmi'i Fingal Jikat bǝdlabǝni?>> ");
INSERT INTO plj_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Tǝ wul wur'e, <<Rǝni gip bǝni, ki zam mbarǝm goni, wul tǝ ni'e, <Ba mǝn kulci wule, wokoci gǝn mbira wi kosak a ndu a ci nyel Jikat bǝdlabǝn na mir mǝn kulci karǝm gip bom gi.> >> ");
INSERT INTO plj_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ar ni mir mǝn kulci kartiyi pi kandatu tǝ yari wur gwa, kan wu kǝrkǝm fingal jikat bǝdlabǝni. ");
INSERT INTO plj_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nan sit piwo, ar ni Yesu dǝm kǝ dǝ tǝ ci fingali na mir mǝn kulci kar ti kutl-cet ropi. ");
INSERT INTO plj_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Nan wu den ci fingali wo, ar ni Yesu wule, <<Ge shirǝm ni a yari ine, gon gip kǝn baa bimka am dǝ mǝn nge gǝni.>> ");
INSERT INTO plj_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ar ni ar ghun wur kan wu nǝm wuli gǝs na nǝm-nǝm, wu wule, <<Na ho bi ami ni da'a. Ko im Babomi?>> ");
INSERT INTO plj_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ar ni tǝ nǝmi wur tǝ wule, <<Muntu kan den si am gip gal nǝm namǝn gwa ni ba ri kǝ bi gǝn ka. ");
INSERT INTO plj_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Nya mbarǝm ba mǝshka kandatu shirǝm kǝ Yam yari den ti tun terka gwa. Ama kashto kǝ muntu kan ba bi Nya mbarǝm ka gwa! Ar baa mani dǝ wule gǝr ti ni dama.>> ");
INSERT INTO plj_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ar ni Yahuda kan bari kǝ bi Yesuyi ka wule,<<Ami na, Ba mǝn kulci?>>Yesu nǝmi ti tǝ wule,<<Kǝ yariwi na gam gi.>> ");
INSERT INTO plj_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nan wu den ci fingalo, ar ni Yesu pǝn bǝredi kan tǝ goode Yami, tǝ cecceni, tǝ bi mir mǝn kulci kar ti tǝ wule, <<Nǝm ni kǝ ci ni, muntuwo, dli gǝn ni.>> ");
INSERT INTO plj_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kan tǝ pǝn mal kin inabi gip wuro mal tǝ goode Yami, kan tǝ bi wur mal kin inabiyi tǝ wule, <<Tla ni, kup gǝni. ");
INSERT INTO plj_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Domici muntuwo bǝran gǝn ni, kǝ gudlum shirǝm kǝ Yam na mbarǝme, muntu kan ba ri kǝ shoti den bi ho'i warwat pitǝn kǝ mbarǝmka na womti gwa. ");
INSERT INTO plj_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","A yari ine, aa i tla mal gǝri kin inabi tu da'a, se gas tu kan aa tla peli nan kǝn gip mulki kǝ Ban gwa.>> ");
INSERT INTO plj_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nan wu wuli kono, ar ni wu to gǝzǝn den tlǝndǝr mǝn kin zaitun. ");
INSERT INTO plj_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ar ni Yesu wul wur'e,<<Gip gas kǝno kup gin kii kǝtǝr gin kǝ za'ǝmi, den bi kǝ argon tu bari kǝ zami gǝn gwa. Domici ar ra na rǝshi'e, <Aa ɓo mǝn le tǝmi kan dǝ tǝmi tatlka.> ");
INSERT INTO plj_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ama den kaar kǝ tli gǝn gip mǝshi mbarǝmo, aa mbubar Galili cina da ine.>> ");
INSERT INTO plj_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ar ni Bitǝrus wule, <<Ko dǝ wule nami kup baa kǝtǝr gǝzǝn den bi kǝ argon tu bari kǝ zami giwo, amo aa pi untu da'a.>> ");
INSERT INTO plj_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu nǝmi ti tǝ wule, <<Ge shirǝm ni a yari'i, gip gas kǝni kapǝn dǝ tus kor la yaro, ki wule kǝ momǝn da'a bisi myakan.>> ");
INSERT INTO plj_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ama Bitǝrus wule, <<Ko aa mǝsh ni nan ki, aa nge momi gika da'a.>> Ar ni nami mir mǝn kulci kar ti yari untu pa'e. ");
INSERT INTO plj_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ar ni Yesu na mir mǝn kulci kar ti ri las tu ba la bi'e, Getsemani gwa, kan tǝ wul wur'e, <<Dǝm ni bartu, naa to barta a shirǝm na Yami.>> ");
INSERT INTO plj_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Kan tǝ pǝn Bitǝrus na mimir kǝ Zabadi rop, ga Yakubu na Yohana, ar ni tǝ nǝm pi dun mbatl na ghuntǝn hoyi. ");
INSERT INTO plj_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ar ni tǝ wul wur'e, <<Dun mbatl tu kan ra gipǝno ar ba mani ri gǝn eka. Dlǝr ni bar tu kǝ dǝm ni gǝɗǝn namǝni.>> ");
INSERT INTO plj_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Nan tǝ te cina njemo, ar ni tǝ ngus atl den gamghurǝm tǝ shirǝm na Yami, tǝ wule, <<Bǝba, ar ni ba piwo, pǝnim kumi dli tuka ngapi. Ama ba'e argon tu a ndu gwa ni kii pi da'a, se de argon tu kǝ ndu gwa.>> ");
INSERT INTO plj_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Kan tǝ pal ɗir kar mir mǝn kulci kar ti, tǝ zam wur den nde umuri. Ar ni tǝ wul Bitǝrus'e, <<O kii mani dǝmi gǝɗǝn kǝ awa nǝm na mǝn da'aya? ");
INSERT INTO plj_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Dǝm ni gǝɗǝn kǝ shirǝm ni na Yami, bǝse kǝ nda ni ka gip godetǝne. Ruhu nǝm wi ama dli hol ndǝrtǝnka.>> ");
INSERT INTO plj_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ar ni tǝ pa pal rǝnka kǝ ropi, tǝ shirǝm na Yam tǝ wule, <<Bǝba, ar ni baa pi dǝ pǝnǝm kumi dli tuka da'a se amin a tlawo, naa dǝ ndu'i gi pi.>> ");
INSERT INTO plj_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nan tǝ pal ɗiro, ar ni tǝ pa zam wur wu den nde umuri, domici umur nǝm wur naar kawi. ");
INSERT INTO plj_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ar ni tǝ za wuri, kan tǝ pa ndara kǝ shirǝm na Yam kǝ bisi myakan, tǝ den yari nǝm shirǝm tu kan tǝ yari far gwa. ");
INSERT INTO plj_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Kan tǝ pal ɗir kar mir mǝn kulci kar ti, tǝ wul wur'e, <<Kǝ'i den umur na shukutǝna? Shin ni, wokoci pi wi nan baa bi Nya mbarǝmka am dǝ mǝn warwat pitǝn gwa. ");
INSERT INTO plj_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Tli ni yam, mǝ ndara ni! Mǝn bi gǝn kan ta rawi!>> ");
INSERT INTO plj_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ti gip shirǝm ituwi, ar ni Yahuda, nǝm gip mir mǝn kulci kar ti kutl cet ropi, cwat na mbarǝm na womti, wu ra na ga tlyari sǝɓǝri, na ga dlo am da wuri. Kiri mǝn keri bar ju ɗiri Yam, na kiri kǝ bǝn ni kar wur ɗiri. ");
INSERT INTO plj_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Tunka ni mǝn bi gǝs kayi yari wur'e, <<Muntu a pi ti sumbawo, ti ni, nǝm tǝni.>> ");
INSERT INTO plj_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Na ɗirtǝn kǝ Yahuda kar Yesuwo, ar ni tǝ wul Yesuyi'e, <<Dǝ shirmi'i ka, Mǝn kulci!>> Kan tǝ pi ti sumba. ");
INSERT INTO plj_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ar ni Yesu wul ti'e, <<Berǝm, da'i pi argon tu ɗir ki gwa.>> Kan mbarǝmi ba te cina, wu nǝm Yesu. ");
INSERT INTO plj_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Na shini untuwo, ar ni nǝm gip munju kan ra na Yesuyi dli bar sǝɓǝr gǝs kan tǝ pati zher kǝ bari kǝ mǝn keri bar ju ɗiri Yam gwa kǝmka. ");
INSERT INTO plj_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ar ni Yesu wul ti'e, <<Pali bar sǝɓǝr gika gip kumti gǝsi. Domici kup muntu dlii bar sǝɓǝro, bar sǝɓǝr ni baa ri ti e. ");
INSERT INTO plj_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Kǝ shin wule aa mani ni la'i bi Ban kan tǝ karim bar na mir mǝn kartǝn gǝs munju kan womtitǝn gǝzǝn man kǝ domtǝn kǝ mǝn bi'utu zangu kutl cet rop (72,000) kǝkǝn tu da'aya? ");
INSERT INTO plj_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ama ami ni a pi untuwo, imnu shirǝm kǝ Yam ba laa'i den'e untu ni ba pi na mǝn gwawu?>> ");
INSERT INTO plj_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Wokociyi ni Yesu wul womti mbarǝmi'e,<<Ami mǝn tli mbarǝm mbatl gip bǝn na dlǝri den tǝp na, kan kǝ ɗir na ga tlyari sǝɓǝr na ga dlo kǝ dǝ kǝ nǝmǝn gwawe? A kur dǝm a kulci mbarǝm te gip Bom kǝ Yamka, ngapo kǝ nǝmǝn da'a. ");
INSERT INTO plj_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ama kup muntu pini kǝ dǝ argon tu ga mǝn yari shirǝm kǝ Yam rǝsh gip Shirǝm kǝ Yamo, ar laa'i.>> Na kumi untuwo, ar ni mir mǝn kulci kar Yesuyi kup za ti kan wu kǝtǝr gǝzǝni. ");
INSERT INTO plj_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ar ni munju kan nǝm Yesuyi ri ti cina dǝ Kayafa, bari kǝ mǝn keri bar ju ɗiri Yam gwa. Lasi ni mǝn kulci mbarǝm den tǝlankur kulci kǝ Musa na kiri kǝ mǝn bǝn dom wuri kǝ tloyi shirǝmi. ");
INSERT INTO plj_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ama Bitǝrus kop ti kaar nye pǝrsi-nye pǝrsiyi, wu mbubar dǝ bom dǝ kiri kǝ liɓa kǝ Yami. Tǝ te gipi tǝ dǝm atl na mǝn ɓuti bomi kǝ dǝ tǝ shin kandatu baa ndo gwa. ");
INSERT INTO plj_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Kiri mǝn keri bar ju ɗiri Yam na domtǝn kǝ mǝn tloyi shirǝm kǝ mǝn Yahudayi kup, den ngeni seda kǝ lar den Yesu kǝdǝ wu zam tǝp kǝ ri gǝs eka. ");
INSERT INTO plj_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ama wu zam da'a, kup na mbarǝm na womti yari shirǝm kǝ lar den ti. Den kariwo, ar ni mbarǝm jen rop ɗiri, ");
INSERT INTO plj_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","kan wu wule, <<Mbarǝm tu wule, <Aa tatl bom kǝ Yam tuka, kan gip muri myakano a tu lasi.> >> ");
INSERT INTO plj_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ar ni bari kǝ mǝn keri bar ju ɗiri Yam tlyami, kan tǝ wul Yesu'e, <<Ki shirǝm diya? Unun kii yari den argon tu mbarǝm ju ba yari den ki gwawe?>> ");
INSERT INTO plj_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ama Yesu yon gǝsi. Ar ni bari kǝ mǝn keri bar ju ɗiri Yami wul ti'e, <<A ngash ki na Yam mǝn ge mbatli, yari mi, ki ni'e Almasihu Nya yama?>> ");
INSERT INTO plj_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu nǝmi ti, tǝ wul wur'e, <<Aan, kandatu kǝ yari gwa ni, ama a yari in ka, cina ɗewo, kii shin Nya mbarǝm njon den am shimli kǝ mǝn iko, tǝ den surtǝn gip dun yami.>> ");
INSERT INTO plj_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ar ni lo ci bari kǝ Liɓa kǝ Yam ju kan tǝ tlyati lulur gǝska, tǝ wule, <<Tǝ pi Yam mǝgǝn shirǝmwi! Seda unun mǝ'i ngeni? Kǝ kum mǝgǝn shirǝm tu kan tǝ pi gwa. ");
INSERT INTO plj_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Unun kǝ shinu?>> Ar ni wu nǝmi ti wu wule, <<Tǝ ndar mǝshtǝni.>> ");
INSERT INTO plj_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ar ni wu bǝse ti mo'ǝm den ba gere, kan wu ɓo ti. Jen ngapo wu la'i ti am kayama ");
INSERT INTO plj_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","kan wu wul ti'e, <<Ki ni'e Almasihu fawo, pi mi anabci. Woni ɓo'iwe?>> ");
INSERT INTO plj_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Wokociyiwo, Bitǝrus ra njon te gip dǝbomika, ar ni nye gǝr zher gon ɗir kar ti, tǝ wul ti'e, <<Ki ma na Yesu ba mǝn Galili tu ni kira!>> ");
INSERT INTO plj_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ama Bitǝrus nge gǝs cina da wur kup, tǝ wule, <<A mom argon tu kǝ den shirǝm dene gwa da'a.>> ");
INSERT INTO plj_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Nan Biturus ɗǝl ter tǝ te gip dlabǝno, ar ni nye gǝr gon mǝn pi mbap gip bomi shin ti, kan tǝ wul mbarǝm kan ra lasi gwa'e, <<Mbarǝm tu ma na Yesu kǝ Nazarat ni tǝ ra.>> ");
INSERT INTO plj_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ar ni Bitǝrus nge gǝs es na ɓe am atl tǝ wule, <<A mom mbarǝm tu da'a!>> ");
INSERT INTO plj_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Den kaarika njemo, ar ni munju kan ra dlor lasi wul Bitǝrus'e, <<Untu ni, ki ma nǝm gip wur ni. Gǝs lǝka gi ni ɓul kika.>> ");
INSERT INTO plj_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ar ni tǝ nǝmi pi gam gǝs bi na ɓe am atl tǝ wule, <<A mom mbarǝm tu da'a!>> Na yari untuwo, ar ni tus kor la yare. ");
INSERT INTO plj_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ar ni Bitǝrus dami argon tu Yesu yari ti gwa'e, <<Kapǝn dǝ tus kor la yaro, ki wule kǝ momǝn da'a bisi myakan.>> Ar ni tǝ ɗǝl te karika kan tǝ kul hoyi. ");
INSERT INTO plj_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Nan bar tlo kǝ bi cigǝniwo, ar ni kiri ga Liɓa kǝ Yam na kiri kǝ bǝn kup mo bi kǝ dǝ wu ri Yesu eka. ");
INSERT INTO plj_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ar ni wu ɓal tika, kan wu ri ta ti am dǝ Bilatus, gobna kǝ Roma. ");
INSERT INTO plj_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Nan Yahuda, muntu kan bi Yesu ka shin'e wu tloyi Yesu shirǝm kǝdǝ ri ti ekawo, ar ni tǝ pi dun mbatli, kan tǝ pal rǝnka kar kiri mǝn keri bar ju ɗiri Yam na kiri kǝ bǝni. Tǝ pali wur azurpa hauya nǝm na kutl gǝzǝni. ");
INSERT INTO plj_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Tǝ wule, <<A pi warwat pitǝnwi, nan a bi muntu pi wani pitǝn da'a dǝ ri ti eka gwa.>> Ar ni wu wul ti'e, <<Unun ghun mi? Muntuwo, damtǝn gi ni.>> ");
INSERT INTO plj_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ar ni Yahuda wi wurpiyika te gip Bom kǝ Yamka, kan tǝ ɗǝl tǝ ri rat gam gǝska. ");
INSERT INTO plj_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ar ni kiri ga Liɓa kǝ Yam yem wurpiyi wu wule, <<Ar ndari dǝ ne wurpiyi kǝba ne wurpi kǝ Bom kǝ Yam da'a, nan wurpi bǝran ni gwa.>> ");
INSERT INTO plj_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ar ni wu mo bi kan wu wur las gon na wurpiyi. Ba la bi lasi'e las kǝ mǝn tu'i tati, kǝdǝ lasi dǝm ba kapi mǝn dǝki. ");
INSERT INTO plj_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ar ni kem ba la bi lasi'e, Las kǝ Bǝran har sekǝni. ");
INSERT INTO plj_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Tǝp untuni laa'i argon tu mǝn yari shirǝm kǝ Yam Irmiya yari gwa'e, <<Wu pǝn azurpa hauya nǝm na kutli, wurpi tu kan mbarǝm kǝ Isra'ila mo bi den dǝ ɓatl den ti gwa itu. ");
INSERT INTO plj_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Kan wu wur las kǝ mǝn tu'i tat nari, kandatu Babom wulǝm ra gwa.>> ");
INSERT INTO plj_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu ra dlor cina dǝ gobna kǝ Romayi ituwi, ar ni gunyi ngen momi kar ti tǝ wule, <<Ki ni'e gun kǝ mǝn Yahudaya?>> Yesu nǝmi ti tǝ wule, <<Aan, kandatu kǝ yari gwani.>> ");
INSERT INTO plj_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ama nan kiri ga liɓa kǝ Yam na kiri kǝ bǝn ne ti lar gamo, tǝ shirǝm da'a. ");
INSERT INTO plj_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ar ni Bilatus wul ti'e, <<Kǝ kum ni shirǝm ju wu yari den ki gwa diya?>> ");
INSERT INTO plj_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ama Yesu bali ti shirǝm ko nǝm da'a, kan ar ba dlǝkǝn gobnayi hoyi. ");
INSERT INTO plj_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Wokoci nyel jǝkat bǝdlabǝno, gobnayi ba kur pǝtli wur mbarǝm nǝm gip munju kan ra na ɓali gip bom moni, muntu wu ndu gwa. ");
INSERT INTO plj_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Wokociyiwo, bar mǝn tli bǝn mbatl gon kan mbarǝm mom ti hoyi gwa ra gip bom moni mǝn sun'e Barabas. ");
INSERT INTO plj_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nan womti mbarǝmi dom wuro, ar ni Bilatus ngen momi kar wur tǝ wule, <<Woni kǝ ndu'e a pǝtli in we, Barabas na, ko Yesu muntu ba la ti bi'e Almasihu gwa?>> ");
INSERT INTO plj_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Domici Bilatus mom'e ghuve ni kem wur kǝ bi Yesu ka. ");
INSERT INTO plj_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Nan Bilatus dǝm den dandi tloyi shirǝm gǝso, ar ni nagǝr gǝs kar bar na shirǝm tu dǝ wul ti'e, <<Ɗǝl ka gip tǝp kǝ mbarǝm tu kan ra na wani pitǝn da gwa, domici a kum dli naar gip tlon den ti gip gasi.>> ");
INSERT INTO plj_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ama kiri mǝn keri bar ju ɗiri Yam na kiri kǝ bǝn co mbarǝm kǝ dǝ wu wule, dǝ pǝtli wur Barabas, kan Yesuwo, dǝ ri ti eka. ");
INSERT INTO plj_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Gobna kǝ Romayi ngen momi kar wur tǝ wule, <<Gonge ni gip rop ju kǝ ndu'e a pǝtli inwe?>> Ar ni wu nǝmi ti wu wule, <<Barabas!>> ");
INSERT INTO plj_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Kan Bilatus ba ngen momi kar wur es tǝ wule, <<Unun aa pi na Yesu muntu ba la ti bi'e, Almasihu gwawe?>> Ar ni wu tli yar kup gǝzǝn wu wule, <<Dǝ ɓa tika den kini!>> ");
INSERT INTO plj_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Bilatus pa ngen momi kar wur tǝ wule, <<Unun kemi? Unu wani pitǝn ni tǝ piwe?>> Ama womti mbarǝmi wom bar ra wu wule, <<Dǝ ɓa tika den kini!>> ");
INSERT INTO plj_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Nan Bilatus shin ti'i mani pi argon da'a, mbarǝm es den ndu'i tli mbatl naar kawo, ar ni tǝ nge mal kan tǝ ho am gǝska cina da wur tǝ wule, <<Pun ni am gǝn ra gip shoti bǝran kǝ mbarǝm tu. Muntuwo ge gin ni!>> ");
INSERT INTO plj_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ar ni mbarǝmi kup nǝm wu wul ti'e, <<Naa dǝ bǝran gǝs dǝm den gam gǝmi na mimir gǝmi.>> ");
INSERT INTO plj_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Kan tǝ pǝtli wur Barabas. Tǝ bi bi dǝ ɓo Yesu, kan dǝ ɓa tika den kini. ");
INSERT INTO plj_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ar ni mǝn bi'utu kǝ gobna te na Yesu gip bom kǝ gobna kǝ Romayi, kan wu la bi domtǝn kǝ mǝn bi'utu kup wu gandǝl tika. ");
INSERT INTO plj_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Wu tusi ti tutul dli gǝs ka, kan wu la'i ti zili tlyari luluri. ");
INSERT INTO plj_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ar ni wu pi ti lish kǝ gun ka ire, wu kemi ti sur gami. Kan wu kem tǝ nǝm dlo na am gǝs kǝ shimli, wu ngus cina da ti, wu wuli ti den kaar bi'e, <<Dǝ shirmi'ika ra, gun kǝ mǝn Yahuda!>> ");
INSERT INTO plj_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Wu bǝse ti mo'ǝmi kan wu nǝm dloyi wu pi ta ɓe gǝs den gami. ");
INSERT INTO plj_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Nan wu pa'i lo'i gǝso, ar ni wu tusi ti zili tlyari luluri ka, kan wu la'i ti gwasi. Ar ni wu ndara nan ti kǝ dǝ wu ɓa tika den kini. ");
INSERT INTO plj_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Nan wu den ritǝno, ar ni wu mo na mbarǝm kǝ Sairin gon mǝn sun Siman, wu kem ti tǝ pǝn kin kǝ ɓa'i Yesuyi. ");
INSERT INTO plj_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Wu ri las tu ba la bi'e, Golgota gwa (Ba kula gam ituwi). ");
INSERT INTO plj_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Kan wu bi ti mal gǝri kin inabi nan kurtli na ɗasi bar gon gwa, kǝ dǝ tǝ tla. Ama nan tǝ la lǝka denewo, ar ni tǝ nge tleka. ");
INSERT INTO plj_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nan wu ɓa ti den kiniwo, ar ni wu rabe lulur gǝs tǝp kǝ ba la'i guri'a. ");
INSERT INTO plj_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Den kaar kǝ untuwo, ar ni wu dǝm lasi wu den ne ger den ti. ");
INSERT INTO plj_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","To gami da ti kawo, ar ni wu rǝsh shirǝm den ar gontu tǝpi wani gwa, MUNTU NI'E YESU, GUN KƏ MƏN YAHUDA. ");
INSERT INTO plj_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Mur mǝn tare tǝp jen ra rop kan ɓa wur den kin nan ti gwa, gon den am shimli, gon ngapo den am yali gǝsi. ");
INSERT INTO plj_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Mbarǝm ju ba wushe ma wu nǝmi ti pi mǝgǝn shirǝmi, wu den kungǝt gami. ");
INSERT INTO plj_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Wu den wultǝn'e, <<Ki kan kǝ wule, ki yasi bom kǝ Yamka, kan kǝ tu gip muri myakan. O ki Nya Yam ni fawo, ɗǝli gam gi, kǝ ɗǝl ka sur den kin tu kan ɓa ki gwa!>> ");
INSERT INTO plj_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Untuni es kiri mǝn keri bar ju ɗiri Yami, na mǝn kulci mbarǝm den tǝlankur Kulci kǝ Musa na kiri kǝ bǝn lo ti. ");
INSERT INTO plj_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Wu wule, <<Tǝ ɗǝli jeni, ama tǝ mbu ɗǝli gam gǝs da'a! Ti ni'e gun kǝ mǝn Isra'ila! Naa tǝ ɗǝl sur den kin tu kan ɓa ti gwa kan mǝ ngǝsh mi den ti. ");
INSERT INTO plj_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Tǝ ne mbatl den Yami. Naa dǝ Yami ɗǝli ti kǝkǝni, tin tǝ ndu ti gwa, domici tǝ wule, <Ami Nya Yam ni.> >> ");
INSERT INTO plj_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Untuni es mur mǝn tare guntǝp ju kan ɓa wur den kin nan ti gwa pi ti mǝgǝn shirǝmi. ");
INSERT INTO plj_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ar ni dǝmǝn nga las ka kup, gip dlom pǝte, ar ba ri gǝlla am myakan kǝ siti. ");
INSERT INTO plj_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Bar kǝ gǝlla am myakan kǝ sitiwo, ar ni Yesu tli yar yam tǝ wule, <<Eloi, Eloi, lama sabaktani?>> Mun tu ni'e, <<Yam gǝni, Yam gǝni, unun kem kǝ balim karwe?>> ");
INSERT INTO plj_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nan jen kan ra dlor lasi kum untuwo, ar ni wu wule, <<Tǝ den la'i bi Iliya wi.>> ");
INSERT INTO plj_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ar ni nǝm gip wur na zhotǝn kǝtǝr tǝ pǝn soso tǝ gi na mati mal inabi, tǝ ɓal den dlo tǝ ta'i Yesu kǝ dǝ tǝ tla. ");
INSERT INTO plj_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Kan nami mbarǝmi ba wule, <<Kǝkǝno za ti ni, naa mǝ shin ko Iliyayi baa sur ɗǝli ti.>> ");
INSERT INTO plj_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Nan Yesu tli yar yam eso, ar ni tǝ kotl mbatlka. ");
INSERT INTO plj_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Gip wokociyi ni labǝle kǝ gip Bom kǝ Yam tlyatka gip dlom sur gami ar su atli. Kan atl ba jirkǝt ti, ga sǝla ba tatlka. ");
INSERT INTO plj_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Kan ga gambǝci ba ɓulka, dli kǝ mbarǝm kǝ Yam na womti kan mǝsh ka baa tli na rai. ");
INSERT INTO plj_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Wu ɗǝl ka gip gambǝci gǝzǝni, den kaar kǝ tlitǝn kǝ Yesu gip mǝshi mbarǝmo, kan wu te gip Bǝn kan ra dlǝran gwa, wu ɗǝl kar mbarǝm na womti. ");
INSERT INTO plj_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nan bari kǝ mǝn bi'utu na munju kan den ɓuti Yesuyi shin jirkǝttǝn kǝ atli na bar ju kan pi kupo, ar ni bǝrti nǝm wur kan wu wule, <<Na ho bi, mbarǝm tuwo, Nya Yam ni!>> ");
INSERT INTO plj_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Mǝtli jen ra na womti njeen kan den shini bar ju den pitǝn gwa. Wu kop ni Yesu ter Galili kǝ dǝ wu ne ti am ra. ");
INSERT INTO plj_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Gip mǝtliyiwo, ga Maryamu kǝ Magadala, na Maryamu nasi ga Yakubu na Isubu, na nasi mimir kǝ Zabadi ra. ");
INSERT INTO plj_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Nan sit piwo, ar ni ba mǝn wurpi gon kǝ Arimatiya mǝn sun'e Isubu ɗiri, ti ma nye mǝn kulci kar Yesu ni. ");
INSERT INTO plj_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Tǝ te kar Bilatus tǝ liri dli kǝ Yesu, ar ni Bilatus bi bi den'e dǝ bi ti. ");
INSERT INTO plj_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ar ni Isubu pǝn dliyi kan tǝ ghumka na pel ghol tutul ghumi mǝshi mbarǝme, ");
INSERT INTO plj_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","kan tǝ la dliyi gip pel gambǝci gǝs kan tǝ mbun den tu sǝla gwa. Tǝ kutǝl bar tat kan tǝ le bi gambǝci'ika na ri kan tǝ ndara. ");
INSERT INTO plj_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maryamu kǝ Magadala na Maryamuyi mǝn nǝm ra njon cina dǝ bi gambǝci'i. ");
INSERT INTO plj_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Nan bar tlo den pǝt shukutǝn kǝ mǝn Yahudawo, ar ni kiri mǝn keri bar ju ɗiri Yam na mǝn me gam kǝ Parise ri kar Bilatus. ");
INSERT INTO plj_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Wu wul ti'e <<Dǝ Yam za ki ra, mǝ dami wi'e wokoci tu mǝn ceni lar tu ra na ge mbatlo, tǝ wule, <Den kaar kǝ muri myakano, Aa tli na ge mbatl esi.> ");
INSERT INTO plj_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ra'untuwo, bi bi kǝ dǝ ri ɓut gambǝci'i ar ri muri myakan. Dǝ pi untu bise dǝ mir mǝn kulci kar ti pi mur kǝ dli gǝska kan wu yari mbarǝm'e, tǝ tli ni ka gip mǝshi mbarǝme, kan dǝ setǝn kǝ kǝkǝn man kǝ pariyi.>> ");
INSERT INTO plj_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Bilatus wul wur'e, <<Yem ni mǝn bi utu kǝ ri ne ni ger den gambǝci'i kandatu kii mani gwa.>> ");
INSERT INTO plj_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ar ni wu ri ɓut gambǝci'i tǝp kǝ ba ɓe am kǝ gunyi den tat tu le gambǝci'i ka nari gwa, kan wu pa wi mǝn bi utu kǝ dǝ wu ɓuti. ");
INSERT INTO plj_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Bar tlo kǝ bǝtloni den kaar kǝ pǝt shukutǝn kǝ mǝn Yahuda, den pǝt kǝ nǝm kǝ sati, ar ni Maryamu kǝ Magadala na Maryamu mǝn nǝmi, ri kǝ shini gambǝci'i. ");
INSERT INTO plj_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Wule gip njipkǝr gere ar ni atl jirkǝt ti, kan mǝn kartǝn kǝ Yam gon ba ɗǝl sur yam tǝ kutǝl tat kan le bi gambǝci'ika nari gwa, tǝ dǝm gǝs deni. ");
INSERT INTO plj_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Tǝ den cirtǝn wule ci bi kǝ Yami, tutul dli gǝs es ra gholi puun wule auduga. ");
INSERT INTO plj_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ar ni bǝrti ci mǝn ɓuti gam biciˈi den mǝn kartǝn kǝ Yami, wu zhizhim wur kan wu nda atlka wule mǝshi mbarǝme. ");
INSERT INTO plj_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ama mǝn kartǝn kǝ Yami wul mǝtliyi'e, <<Ba dǝ bǝrti ci in ni ka da'a, a mom'e kǝn ni den ngeni Yesu kan ɓa tika den kin gwa. ");
INSERT INTO plj_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Tǝ ra ɗe da'a, tǝ tli gǝs gip mǝshi mbarǝmka wi kandatu tǝ yari gwa. Ɗir shin ni las tu kap ti gwa. ");
INSERT INTO plj_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Rǝ ni ka na zhotǝne, kǝ yari ni mir mǝn kulci kar ti'e, <Tǝ tli gip mǝshi mbarǝmka wi. Tii mbubar atl kǝ Galili cina da ine. Barta ni ki shin ti.> Ar gon tu a ɗir kǝ dǝ a yari in gwa itu.>> ");
INSERT INTO plj_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ar ni mǝtliyi za gambǝci'i na zhotǝn gip bǝrti, ama laa'i na ghol mbatli wu kǝtǝr kǝ dǝ wu ri yari mir mǝn kulci kar ti. ");
INSERT INTO plj_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Wule gip njipkǝr gere ar ni Yesu mo nan wur kan tǝ wul wur'e, <<A shirmi in ka.>> Ar ni wu ngus kan wu nǝm asǝm gǝs wu bote ti. ");
INSERT INTO plj_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ar ni Yesu wul wur'e, <<Ba dǝ bǝrti ci inni ka da'a. Ri yari ni mir ɓyar wu te gip atl kǝ Galili, bar ta ni wu shimǝni.>> ");
INSERT INTO plj_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nan mǝtliyi den tǝp ndaratǝno, ar ni jen gip mǝn bi'utu mǝn ɓuti gambǝci'i te gip bǝn kǝ dǝ wu yari kiri mǝn keri bar ju ɗiri Yam bar ju kup pi gwa. ");
INSERT INTO plj_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ar ni kiri Liɓa kǝ Yam na kiri kǝ bǝni mo gam wu dar bi, kan wu bi mǝn bi'utuyi wurpi mǝn nartǝni, ");
INSERT INTO plj_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","wu wul ga mǝn bi'utuyi'e, <<Wul ni'e, mir mǝn kulci kar ti ni ɗir kǝ gas kan wu pi mur kǝ dli gǝska nan mǝn den nde umur gwa. ");
INSERT INTO plj_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Shirǝm tu ni ri kǝm dǝ gobna kǝ Romawo, mi mom ar gon tu mi yari ti kan baa kem tii hukunte'in dagwa.>> ");
INSERT INTO plj_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ar ni mǝn bi'utuyi nǝm wurpiyi wu pi kandatu wul wur'e dǝ wu pi gwa. Shirǝm tuwo har sekǝn mbarǝm kǝ Yahuda ba pi shirǝm deni. ");
INSERT INTO plj_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ar ni mir mǝn kulci kar ti kutl-cet nǝmi te gip Galili, wu to den tlǝndǝr tu kan Yesu yari wur'e wii mo gwa. ");
INSERT INTO plj_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Nan wu shin ti wo, ar ni wu ngusi ti, ama jen gǝzǝn cen mbatl ka. ");
INSERT INTO plj_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ar ni Yesu ɗir kar wur tǝ wule, <<Iko kǝ to yamka na kǝ den atlo kup bim kawi. ");
INSERT INTO plj_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ra'untuwo, rii pi ni mbarǝm kǝ atl kup wazu, kǝ pi wur ni batisma gip sun kǝ Bǝba, na kǝ Nya, na kǝ Ruhu kǝ Yami, ");
INSERT INTO plj_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","kǝ pa kulci wur ni wu kop kup argon tu a yari in kǝ pi gwa. Na ho bi, ami ra nan kǝn ko gigasi, ar ri patǝn kǝ zhan kup.>>");
INSERT INTO plj_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ne gǝs kǝ yari zo shirǝm kǝ Yesu Almasihu, Nya Yami. ");
INSERT INTO plj_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Kandatu ar ra na rǝshi gip tulankur kǝ mǝn yari shirǝm kǝ Yam Ishaya gwa'e, <<Aa kar nye mǝn kartǝn bar gǝn cina da'i, muntu kan baa kǝrkǝmi'i guntǝp gi gwa.>> ");
INSERT INTO plj_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Yar kǝ gon mǝn latǝn bi gip lǝp den wultǝn'e, <<kǝrkǝmi ni Babom guntǝp kǝ cwattǝn gǝsi, dǝ guntǝp gǝs dǝm na ta'i.>> ");
INSERT INTO plj_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ar ni Yohana ɗir tǝ den pi mbarǝm batisma gip lǝp na pi wazu kǝ ci atl gam kar Yam kǝ pǝni warwat pitǝnka. ");
INSERT INTO plj_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Kan mbarǝm kǝ bi atl kǝ Yahuda kup na mbarǝm kǝ Urshalima ba ri kar ti. Wu den yari warwat pitǝn gǝzǝni, kan tǝ pi wur batisma gip ɓula kǝ Urdun. ");
INSERT INTO plj_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohana ra dlor na tutul dli ka ta rakumi, tǝ dlǝmat ti na late, kan zas na dom ni'e fingal gǝsi. ");
INSERT INTO plj_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yohana yari tǝ wule, <<Den kaar gǝno gon baa ɗiri muntu kan manǝm nartǝn gwa, zap kaptǝlan gǝs ma a kǝm a ngus a pǝtli tika da'a. ");
INSERT INTO plj_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","A pi in batisma na male, ama tiwo tii pi in batisma na Ruhu kǝ Yami.>> ");
INSERT INTO plj_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Wokoci tawo ar ni Yesu za bǝn kǝ Nazarat gip atl kǝ Galili kan Yohana ba pi ti batisma gip ɓula Urdun. ");
INSERT INTO plj_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nan Yesu den ɗǝltǝn tor gip maliwo, ar ni tǝ shin dlom yam ɓuli, kan Ruhu ba sur dlǝr den ti na dli wule kǝ kuɓǝri. ");
INSERT INTO plj_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Kan yar gon ba ɗǝl sur yam ba wule, <<Ki ni'e Nya gǝni, muntu a ndu gwa, mbatl gǝn ba ghol nan ki naari.>> ");
INSERT INTO plj_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ar ri kǝtigon da'a ar ni Ruhu ri ti gip lǝpe, ");
INSERT INTO plj_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","kan tǝ dǝm rǝnka kǝ muri hauya rop, Shetan den ta gode gǝsi. Tǝ ra na ga dabba kǝ gip lǝpe, na mir mǝn kartǝn kǝ Yam den pi ti mbapi. ");
INSERT INTO plj_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Den kaar kǝ la'i Yohana gip bom kǝ moniwo, ar ni Yesu ndara gip atl kǝ Galili, tǝ den pi wazu zo shirǝm kǝ Yami. ");
INSERT INTO plj_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Tǝ wule, <<Wokoci ɗir wi, mulki kǝ Yam mbira kosak wi. Ci ni atl gam kǝ ngǝsh kǝn ni den zo shirǝmi.>> ");
INSERT INTO plj_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Nan Yesu den kopi bi ɓula kǝ Galiliwo, tǝ shin Siman na erǝm gǝs Andǝrawus den la'i bar kǝ nǝmi kos gǝzǝn gip male, domici wu mǝn nǝmi kos ni. ");
INSERT INTO plj_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu wul wur'e, <<Kopǝn ni, aa pali in mǝn dǝli mbarǝm ɗir karǝmi.>> ");
INSERT INTO plj_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ar ri kǝtigon da'a ar ni wu za bar kǝ nǝmi kos gǝzǝnka kan wu kop Yesu. ");
INSERT INTO plj_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Nan tǝ te cina njemo ar ni tǝ shin Yakubu nya Zabadi na erǝm gǝs Yohana gip kungǝlǝn jikat male, wu den kǝrkǝm bar kǝ nǝmi kos gǝzǝni. ");
INSERT INTO plj_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Na shini gǝzǝno ar ni tǝ la wur bi, kan wu za bazin Zabadi gip kungǝlǝn jikat mali na mir mǝn mbap jeni kan wu kop Yesu. ");
INSERT INTO plj_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ar ni wu ndara Kaparnahum, nan pǝt Shukutǝn ɗiro ar ni Yesu te gip bom domtǝn kǝ mǝn Yahuda kan tǝ nǝm kulci mbarǝme. ");
INSERT INTO plj_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Mbarǝm nǝm bi na am den kulci gǝsi, domici tǝ kulci wur wule muntu kan na iko gwa, ba'e wule kandatu mǝn kulci mbarǝm den kulci kǝ Musa ba pi gwa da'a. ");
INSERT INTO plj_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Gip untuwo, ar ni mbarǝm gon kǝn mǝn dun itǝr gip bom domtǝn kǝ mǝn Yahudayi la yar tǝ wule, ");
INSERT INTO plj_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","<<Unun kǝ ndu nan mi, Yesu kǝ Nazarat! Kǝ ɗir ni kǝ pa'ika nan miya? A mom wo ni'e ki, Dlǝran Mbarǝm kǝ Yami!>> ");
INSERT INTO plj_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Kan Yesu ba matl ti tǝ wule, <<Ɗǝl ter gip ti!>> ");
INSERT INTO plj_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Dun itǝri ɓo mbarǝmi atl kan tǝ ɗǝl ter gip ti na la'i yare. ");
INSERT INTO plj_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ar dlǝkǝn mbarǝm kup kan wu ngen momi kar ezǝn wu wule, <<Unu ari ituwi? Pel kulci gon mǝn ndǝrtǝni! Tǝ yari argon tu dun itǝr baa pi gwa kan wu kopi ti.>> ");
INSERT INTO plj_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Shirǝm den ti gǝzan bǝle-bǝle gip atl kǝ Galili. ");
INSERT INTO plj_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nan wu za bom domtǝn kǝ mǝn Yahudayiwo, ar ni ga Yakubu na Yohana ri bom dǝ Siman na Andǝrawus. ");
INSERT INTO plj_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Nakon kǝ Siman ra ɓom den kumi dli, dli gǝs wi utuka, kan wu shirǝm na Yesu den ti. ");
INSERT INTO plj_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Kan tǝ ri kar nagǝr mǝri, tǝ nǝm am gǝs tǝ tli ti yami. Ar ni kumi dliyi za ti, kan tǝ turi wur fingal tǝ bi wuri. ");
INSERT INTO plj_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Gasi kǝ bi sit nan pǝt nda binwo, ar ni mbarǝm ɗiri Yesu kup mǝn kumi dli na mǝn dun itǝri. ");
INSERT INTO plj_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ar ni mbarǝm kǝ bǝni kup dom wur bǝdlabǝn bomi, ");
INSERT INTO plj_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","kan Yesu ba pǝni ko gonge mbarǝm den ko gonge unu kumi dli gǝzǝnka. Tǝ pa ɗǝli dun itǝrka na womti gip mbarǝme, ama tǝ za dun itǝri wu shirǝm da'a, domici wu mom ko ti wo ni. ");
INSERT INTO plj_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kǝ bi bǝtloni, nan las'i pǝlǝu-pǝlǝwo, ar ni Yesu tlyami, kan tǝ za bom tǝ ndara las gon kan mbarǝm ra dagwa, lasi ni tǝ shirǝm na Yami. ");
INSERT INTO plj_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Siman na munju kan ra nan ti gwa ri kǝ ngeni gǝsi. ");
INSERT INTO plj_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Nan wu zam tiwo ar ni wu wul ti'e, <<Mbarǝm kup den ta ngeni gi!>> ");
INSERT INTO plj_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesu bali wur tǝ wule, <<Mǝ ndara ni gip mir bǝn ju kan ra kosak gwa, kǝ dǝ a pi wazu barta esi. Argon tu sirǝm gwa itu>> ");
INSERT INTO plj_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ar ni wu kop gip atl kǝ Galili kup, wu den wazu gip bom domtǝn kǝ mǝn Yahuda gǝzǝn na ɗǝli dun itǝrka gip mbarǝme. ");
INSERT INTO plj_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ba mǝn ndǝcci gon ɗir kar ti kan tǝ ngus den gam ghurǝm gǝs tǝ lir ti tǝ wule, <<Ar ni pǝni'i mbatlo, kii mani pali gǝn dlǝran.>> ");
INSERT INTO plj_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Laa'i na guna gere, ar ni Yesu ne am den mbarǝmi kan tǝ wule, <<Ar pǝnim mbatli, pal dlǝran!>> ");
INSERT INTO plj_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ar ri kǝtigon da'a, ar ni ndǝcci gǝs za ti kan tǝ pal dlǝran. ");
INSERT INTO plj_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yesu dǝli ti kǝm hoyi, kan tǝ za ti tǝ ndara. ");
INSERT INTO plj_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Tǝ wul ti'e, <<Ba kǝ yari murgon bar tu da'a. Ama mbǝri, ri gam gi kar lǝɓa kǝ Yami kan kǝ bi bar ju Musa wule dǝ bi den bi paltǝn dlǝran gwa, kǝ dǝ ar dǝm seda kar wuri.>> ");
INSERT INTO plj_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ama mbarǝmi pi untu da'a kan tǝ ndara tǝ nǝm yari mbarǝm argon tu kan pi gwa. Muntu kem Yesu ba'i te gip bǝn den ger kǝ mbarǝm da'a ama tǝ dǝm kaari las ju mbarǝm ra da gwa. Kup na untu mbarǝm ko tǝp ako pi ta ɗirtǝn kar ti. ");
INSERT INTO plj_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Murka njem den kaariwo, ar ni Yesu pa te gip bǝn Kaparnahum, kan mbarǝm ba kumka den'e tǝra bomi. ");
INSERT INTO plj_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ar ni mbarǝm na womti dom wur har kushi ba ɗatka, ko te bǝdlabǝn karika ma, kan tǝ pi wur wazu shirǝm kǝ Yami. ");
INSERT INTO plj_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ar ni mbarǝm wupse jen ter na mbarǝm gon kan ra den kumi dli gwa, itǝr ni tle ti dlika. ");
INSERT INTO plj_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nan wu mani zami tǝp kǝ te gǝs kar Yesu da'a na womtitǝn kǝ mbarǝmo ar ni wu tul las gon den rupi kushiyi sur gam dǝ Yesu, den kaar kǝ tuli shuyiwo, kan wu shu muntu itǝr tle ti dli kayi sur cina dǝ Yesu ɓom den bamuri gǝsi. ");
INSERT INTO plj_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Nan Yesu shin ngǝshtǝn den Yam gǝzǝno, ar ni tǝ wul muntu itǝr tle tikayi'e, <<Nya gǝni, ho'i'i warwat pitǝn gi kawi.>> ");
INSERT INTO plj_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Lasiwo mǝn kulci mbarǝm den kulci kǝ Musa ra njon, ar ni wu dami gip mbatl gǝzǝn wu wule, ");
INSERT INTO plj_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","<<Unun kem mbarǝm kǝn ba shirǝm untu we? Mǝgǝn shirǝm ni tǝ pi Yami! Wo ni baa mani ho'i warwat pitǝnka in ba Yam ni katl nan gǝs dagwa?>> ");
INSERT INTO plj_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ar ri kǝtigon da'a ar ni Yesu momka gip ruhu gǝs'e argon tu wu den dami gip mbatl gǝzǝn gwa itu, kan tǝ wul wur'e, <<Unun kem kǝn den damtǝn den munju we? ");
INSERT INTO plj_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Gonge ni ban mani, dǝ wul muntu itǝr tle ti dli kayi'e <Ho'i i warwat pitǝn gi kaya,> ko <Tlyami, pǝn bamuri gi kǝ ndara?> ");
INSERT INTO plj_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ama kǝ dǝ kǝ mom'e Nya Mbarǝm ra na iko den atl kǝ ho'i warwat pitǝnkawo,>> ar ni tǝ wul muntu itǝr tle ti dli kayi'e, ");
INSERT INTO plj_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","<<A wul ki'e, dlyami, pǝn bamuri gi kǝ ndara bomi.>> ");
INSERT INTO plj_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ar ni tǝ tlyami, tǝ pǝn bamuri gǝs kan tǝ nǝm tǝp den ger kǝ kum gǝzǝni. Muntu dlǝkǝn mbarǝm kup kan wu ɗǝɗa Yam na wultǝn'e, <<Mǝ taɓe shini argon untu da'a!>> ");
INSERT INTO plj_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu pa su bi ɓula'i. Ar ni mbarǝm na womti ri kar ti, kan tǝ nǝm kulci wuri. ");
INSERT INTO plj_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Nan Yesu den ɓomi asǝmo ar ni tǝ shin Lawi nya Halfa njon kǝ ba nǝmi wurpi bomi. Yesu wul ti'e, <<Kopǝni.>> Kan Lawi ba tlyam tǝ kop ti. ");
INSERT INTO plj_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Nan Yesu den ci fingal kǝ gas gip bom dǝ Lawiwo, mǝn nǝmi wurpi bom na mǝn warwat pitǝn na womti, na mir mǝn kulci karti ra den ci fingal nan ti, domici mbarǝm na womti ni gip wur kop ti kaari. ");
INSERT INTO plj_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Nan mǝn kulci mbarǝm den kulci kǝ Musa kan mǝn Parise ni, shin ti den ci na mǝn warwat pitǝn na mǝn nǝmi wurpi bomo, ar ni wu ngen momi kar mir mǝn kopi gǝs wu wule, <<Imni tǝ ci na mǝn nǝmi wurpi bom na mǝn warwat pitǝne?>> ");
INSERT INTO plj_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Na kumi muntuwo ar ni Yesu wul wur'e, <<Munju kan ra gingǝlin gwa ni ba shin mǝn bi un da'a, ama mǝn kumi dli ni. A sur ni kǝ la'i bi mǝn pitǝn dlat da'a ama mǝn warwat pitǝne.>> ");
INSERT INTO plj_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Gasi gono mir mǝn kulci kar Yohana na kǝ mǝn Parise den guzum male. Mbarǝm jen ɗir kan wu ngen momi wu wule, <<Ra imnu mir mǝn kulci kar Yohana na mir mǝn kulci kar mǝn Parise ba pi guzum male, ama mir mǝn kulci kar kiwo wu pi dawu?>> ");
INSERT INTO plj_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu nǝmi wur tǝ wule, <<Im ni fa mǝn dǝki kǝ mǝn pel gǝr baa pi guzum mal nan tǝra nan wur gwawe? Wii pi da'a, ti nǝ ra nan wur gwa. ");
INSERT INTO plj_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ama wokoci den ɗirtǝn nan baa pǝni wur mǝn pel gǝri kagwa, gas ta ni wii pi guzum male. ");
INSERT INTO plj_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Murgon baa bop gus tutul dli den pel tutul dli da'a. Ti ni tǝ pi untuwo, pel tutul dliyi baa tlyat koriyika, har dǝ dlyattǝni man kǝ fari. ");
INSERT INTO plj_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Murgon baa shoti pel mal kin inabi gip kor tat ne mal inabi da'a. Ti ni tǝ pi untuwo, mal inabiyi baa tar tati kan ar mbutlka. O'o, tii shoti ni pel mal kin inabi gip pel tat inabi.>> ");
INSERT INTO plj_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Den pǝt Shukutǝn gon nan Yesu den kopi gip kǝn alkamawo, mir mǝn kulci kar ti ra nan ti, ar ni wu nǝm wumi alkama wu den ci. ");
INSERT INTO plj_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Mǝn Pariseyi wul ti'e, <<Ɓa shini, unun kem wu pi argon tu den kulci kǝ Musawo ar ndari dǝ pi den pǝt Shukutǝn da gwawu?>> ");
INSERT INTO plj_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ar ni Yesu nǝmi wur tǝ wule, <<Kǝ taɓe ni zhiti gip tulankur den argon tu Dauda pi, ti na ga berǝm ɓomi asǝm gǝs nan guzum ci wur gwa diya? ");
INSERT INTO plj_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Kandatu gip muri kǝ Abiyata bar lǝɓa kǝ Yami, Dauda te gip bom kǝ Yam kan tǝ ci bǝredi tu kan ne nika markǝme, muntu kan ga lǝɓa kǝ Yam ni katl baa ci gwa. Kan tǝ pa bi ga berǝm ɓomi asǝm gǝs wu ma wu ci.>> ");
INSERT INTO plj_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Kan tǝ wul wur'e, <<Pǝt Shukutǝno pi tǝni domici kǝ mbarǝme, ba'e mbarǝm ni pi ti domici kǝ pǝt Shukutǝn da'a. ");
INSERT INTO plj_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ra untuwo Nya Mbarǝm ni'e Babom kǝ pǝt Shukutǝn ma.>> ");
INSERT INTO plj_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Wokoci gono Yesu te gip bom domtǝn kǝ mǝn Yahuda, mbarǝm gon ra lasi kan itǝr tle ti amka gwa. ");
INSERT INTO plj_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Jen ni den ngeni tǝp tu wii zam Yesu na argon kǝ nǝmi gǝsi. Ra untuwo ar ni wu pi ta ne ger den ti kǝ wu shin ko tii warke ti den pǝt Shukutǝni. ");
INSERT INTO plj_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ar ni Yesu wul mbarǝmi kan itǝr tle ti amika gwa'e, <<Tlyam dlor cina dǝ mbarǝme.>> ");
INSERT INTO plj_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ar ni Yesu ngen momi kar wur tǝ wule, <<Den bi kulci kǝ Musawo unun ndari dǝ pi den pǝt Shukutǝni, dǝ pi ho pitǝna ko wani? Dǝ ɗǝli rai ya ko dǝ ri eka?>> Ama ar ni wu yon gǝzǝni. ");
INSERT INTO plj_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesu wi wur ger gip lo na dun mbatl den lati mbatl gǝzǝni, kan tǝ wul mbarǝmi'e, <<Ta am gi.>> Tǝ ta am gǝsi, kan am gǝs ba pal lau. ");
INSERT INTO plj_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ar ni mǝn Pariseyi ndara kan wu nǝm ngeni tǝp nan wur na mbarǝm kǝ Hiridus den kandatu wii ri Yesu eka gwa. ");
INSERT INTO plj_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu na mir mǝn kulci kar ti tlyam wu ndara bi ɓula'i, kan bar womti mbarǝm kan tli tor gip atl kǝ Galili ba kop ti. ");
INSERT INTO plj_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Nan wu kum argon tu kup tǝ den piwo, mbarǝm na womti kan tli tor gip atl kǝ Yahuda, gip bǝn kǝ Urshalima, gip Idume, na bi atl ju kan ra te jikat ɓula Urdunka, na gip atl kǝ Sidon na Taya, ba ɗir kar ti. ");
INSERT INTO plj_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Den womtitǝn kǝ mbarǝmiwo ar ni tǝ wul mir mǝn kulci kar ti'e wu zami ti nye heli kungǝlǝn jikat mal nǝm, ba dǝ mbarǝm tla ti naarka da'a. ");
INSERT INTO plj_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Tǝ pi ni untu domici tǝ warke mbarǝm na womti wi, ar ni munju kan ra na bar jen kan ba ghun wur gip dli gǝzǝn ba pi ta ɗirtǝn zam wu ne am den ti ra. ");
INSERT INTO plj_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Wokoci tu kup dun itǝr shin tiwo, se wu nda atl cina da ti wu den la'i yare, wu den wultǝn'e, <<Ki Nya Yam ni.>> ");
INSERT INTO plj_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ama Yesu dǝli wur kǝm hoyi den ba wu yari den ti wo ni da'a. ");
INSERT INTO plj_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Gip untuwo, ar ni Yesu ndara den tlǝndǝre, tǝ la bi munju kan tǝ ndu gwa, kan wu ɗir kar ti. ");
INSERT INTO plj_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Tǝ zǝzar mbarǝm kutl cet rop, munju tǝ bi wur sun'e mir mǝn kartǝne, wu dǝm nan ti kǝ dǝ tǝ kar wur wu ri pi wazu. ");
INSERT INTO plj_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Tǝ pa bi wur iko kǝ ɗǝli dun itǝrka gip mbarǝme. ");
INSERT INTO plj_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Kutl cet ropi kan tǝ zǝzari gwa ni'e, Siman (muntu tǝ bi ti sun'e Kepas gwa), ");
INSERT INTO plj_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakubu nya Zabadi na erǝm gǝs Yohana (munju tǝ bi wur sun Bonaji, mimir kǝ Sawa ituwi) ");
INSERT INTO plj_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andǝrawus, Filibus, Batalamawus. Matiyu, Toma, Yakubu nya Halfa, Tadawus, na Siman Ziloti ");
INSERT INTO plj_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","kan na Yahuda Iskariyoti, muntu bi Yesu kagwa. ");
INSERT INTO plj_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ar ni Yesu te gip bom goni, kan mbarǝm na womti ba pa kop ti kaari, untu kem ti na mir mǝn kopi gǝs ma wu zam dǝmi kǝ ci barkǝci da'a. ");
INSERT INTO plj_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Nan mir mǝn shu bom kǝ Yesu kum untuwo, ar ni wu ri kǝ dǝ wu pali ti ɗir bomi, domici wu wule gam ni duri tika. ");
INSERT INTO plj_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ar ni mǝn kulci mbarǝm den kulci kǝ Musa kan tli tor Urshalima ba wule, <<Ba'alzabub ni gip ti! Tǝp kar iko kǝ bar gun dun itǝr ni tǝ ɗǝli dun itǝrka gip mbarǝme.>> ");
INSERT INTO plj_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ra untuwo ar ni Yesu la wur bi kan tǝ shirǝm nan wur na misali tǝ wule, <<Imni Setan baa mani ɗǝli Setan we? ");
INSERT INTO plj_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Mulki ni tatka bomi ropo, mulki tu baa dlǝr da'a. ");
INSERT INTO plj_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Bom ni tatlka bomi rop gip shini bes kǝ ezǝno, bom tu baa dlǝr da'a. ");
INSERT INTO plj_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kan Setan ni tli gip nge gam gǝsi, kan tǝ tatlka bomi ropo, tii mani dǝmi da'a, patǝn gǝs ɗir ituwi. ");
INSERT INTO plj_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Na ho bi, murgon baa mani tetǝn gip bom kǝ ndǝri mbarǝm kan tǝ yem bar ju kan tǝra nari kagwa, se ti ni tǝ pare nǝmi ndǝri mbarǝmi tǝ ɓal tika, kano tǝ'i mbu yemi ti bar kǝ bom gǝska. ");
INSERT INTO plj_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ge shirǝm ni a yari ine, kup warwat pitǝn na mǝgǝn shirǝm kǝ mbarǝm den Yamo, baa ho'i wurka. ");
INSERT INTO plj_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ama muntu kup kan pi mǝgǝn shirǝm den Ruhu kǝ Yamo baa taɓe ho'i tika da'a, tǝ pi warwat pitǝn kan baa pa da gwawi.>> ");
INSERT INTO plj_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Tǝ yari ni muntu domici wu den wultǝn'e, <<Tǝ ra na dun itǝri.>> ");
INSERT INTO plj_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ar ni nasi Yesu na mir ezǝn cwati, wu dlǝr ter kaari kan wu kar gon kǝ tǝ la'i wur bi Yesu. ");
INSERT INTO plj_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Mbarǝm ra na womti njon kar ti, kan wu wul ti'e, <<Nana gi na mir ya'ǝn ra te karika den ngeni gi.>> ");
INSERT INTO plj_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesu ngen momi kar wur tǝ wule, <<Ga wo ni'e nana na mir ɓyar we?>> ");
INSERT INTO plj_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ar ni tǝ bali ger kar munju ra njon kan ngandǝl ti gwa tǝ wule, <<Ga nana na mir ɓyar ni'e mǝnjǝni.>> ");
INSERT INTO plj_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Murgon tu kup kan ba pi argon tu Yam ba ndu gwa ni'e erǝm gǝn mǝtli na moni na nana gǝni. ");
INSERT INTO plj_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu pa nǝm kulci wur ra bi ɓula'i. Mbarǝm na womti kan dom wur kar ti naar gho ar ni kem tǝ to gǝs gip kungǝlǝn jikat male kan tǝ dǝm gipi nan mbarǝm kup ra den bishidi kǝ ɓula'i gwa. ");
INSERT INTO plj_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Tǝ kulci wur bar na womti tǝp kǝ ba kolɗa bi, ar ni gip kulci gǝso tǝ wule, ");
INSERT INTO plj_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","<<Kum ni! Mǝn kori bar ri kǝ ngani badǝr gip kǝn gǝsi. ");
INSERT INTO plj_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Nan ti gip ngani badǝriwo, ar ni badǝr jen ro den tǝpe, kan yatl ba ɗir ɗami wu cika. ");
INSERT INTO plj_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Badǝri jen nda den tate, las tu atl ra hoyi da gwa. Kan ar ba yetl bǝle-bǝle, domici atli naar da'a. ");
INSERT INTO plj_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ama nan pǝt tli torwo, ar ni mattǝn kǝ pǝt kem ar landǝrka nan ar ra na tlǝrti dagwa. ");
INSERT INTO plj_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Badǝri jen nda gip ire, kan ba naari, ama iri dlat wurka, har ba kem ar ɗǝli ge da'a. ");
INSERT INTO plj_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Jen gip badǝri nda den ho atli. Ar tli tor kan ba gǝri, gucǝpi bisi hauya nǝm na kutl, jeno hauya myakan, jen ngapo hauya nantam.>> ");
INSERT INTO plj_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ar ni Yesu wule, <<Muntu kan ra na kǝm kǝ kumiwo, naa tǝ kumi.>> ");
INSERT INTO plj_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Nan tǝra nan gǝso, ar ni mir mǝn kartǝn gǝs kutl cet ropi na nami kan ra kar ti gwa ngen momi kar ti den argon tu tǝ kulci wur deneyi ba pi nupi gwa. ");
INSERT INTO plj_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Tǝ wul wur'e, <<Momi ghuuni bar kǝ mulki kǝ Yamo tare bi in wi. Ama dǝ munju kan ra gip kǝn dawo ko unuwo ba yari wur ni gip kolɗa bi. ");
INSERT INTO plj_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Kǝ dǝ, <wu pi ta zhuwi ama wii mani shini da'a wu pi ta kumi ama wii mani momi da'a, Kǝ dǝ wu pal karǝm dǝ ho'i wur warwat pitǝn gǝzǝnka ra!> >> ");
INSERT INTO plj_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ar ni Yesu wul wur'e, <<Kǝ mani momi kolɗa bi tu diya? Ra imnu kii mani momi nami kolɗa biyi? ");
INSERT INTO plj_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ba mǝn kǝni ngani ni shirǝmi. ");
INSERT INTO plj_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Mbarǝmi jeno wi ni wule badǝr kan nda den tǝp gwa, las tu ngani shirǝmi gwa. Na kumi gǝzǝni ar ni Shetan ɗir pǝn shirǝmika kan ngani gip wur gwa. ");
INSERT INTO plj_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Jeno wi ni wule badǝr tu kan nda den tat gwa, munju na kumi shirǝmiwo wu nǝm na ghol mbatli. ");
INSERT INTO plj_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ama nan wu ra na tlǝrti dawo, wu dǝm ni kǝ wokoci njem katl. Nan tlatǝn ko kumi dli den bi kǝ shirǝmi ɗiro, wu ndaka koshilan. ");
INSERT INTO plj_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Jen ngapo wi ni wule badǝr tu kan ngani gip ir gwa, wu kum shirǝmi, ");
INSERT INTO plj_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ama damtǝn kǝ dǝmi kǝ se na gǝni, na ndu'i bar kǝ am kan na ndu'i bar jen ɗir kan ba tla shirǝmika har ar ba hol gǝritǝni. ");
INSERT INTO plj_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ama badǝr tu kan ngani den ho atlo, nan wu kum shirǝmiwo ar ni wu nǝmi, kan wu gǝri ngucipi hauya nǝm na kutl, jen hauya myakan kan jen ma hauya nantam kǝ argon tu ngani gwa.>> ");
INSERT INTO plj_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Tǝ wul wur'e, <<Kǝ ne ni pitila te gip kushika kǝ zupka na gal ko te gǝs dandi kaya? Untu ni da'a, kǝ neni den badǝmi gǝs da'aya? ");
INSERT INTO plj_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Argon tu kup kan ra na ghuuniwo, ne ni kǝ dǝ ɓulka, kan kup argon tu kan lekawo, ne tǝni kǝ dǝ ɗǝlika kaari. ");
INSERT INTO plj_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Murgon tu kup kan ra na kǝm kǝ kumiwo, naa tǝ kumi.>> ");
INSERT INTO plj_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yesu ci cina na shirǝm tǝ wule, <<Neni kǝm hoyi den argon tu kǝ kum gwa. Na shanndǝr tu kǝ cingǝr bar nariwo nari ni baa cingǝri in pa'e, har ma na mbǝli ra. ");
INSERT INTO plj_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Murgon tu kup kan ra na baro, baa bi ti ra, murgon tu kan ra nari dawo, ko nye argon tu tǝra nari ma, baa nǝmi tika.>> ");
INSERT INTO plj_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Tǝ pa wule, <<Kandatu mulki kǝ Yam ra gwa ikǝni. Mbarǝm gon ri kǝ ngani badǝr gip kǝne, ");
INSERT INTO plj_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","se na gǝni, har dǝ argon tu kan tǝ ngani gwa naari, tǝ mom imnu ar pi gwa da'a. ");
INSERT INTO plj_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Atl ba bi bar kǝ gip kǝn na gam gǝsi. Kǝ nǝm ar ba yetli, kan ar ɗǝli gami, den kaariwo kan ar ɗǝli ge. ");
INSERT INTO plj_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Na ar ba nyowo ar ni mǝn kǝni baa ri na bar kǝ rǝshi kǝn gǝs den ar mbi den bi rǝshi kǝn wi.>> ");
INSERT INTO plj_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Tǝ pa wul wur'e, <<Ununu mii wule mulki kǝ Yam ra we? Ko ununu ba kolɗa bi dene dǝ yari kandatu ar ra gwawu? ");
INSERT INTO plj_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ar ni ra wule ge dǝnti, muntu kan mani heltǝn gip badǝr ju kan ba ngani gwa. ");
INSERT INTO plj_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Na untu kup in nganiwo ar ba naar ar man nami mir kin kup. Ar ba pi am ju kan yatl kǝ to yamka ba mani tu'i bin den mir ami gwa.>> ");
INSERT INTO plj_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Na kolɗa bi na bar jen wule muntu na womti ar ni Yesu yari wur shirǝm kǝ Yami, kandatu wii mani momi gwa. ");
INSERT INTO plj_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Tǝ yari wur bar gon bat na kolɗa bi da'a. Ama ti ni nan gǝs na mir mǝn kulci kartiwo tǝ yari wur ko unu kandatu wii mani momi gwa. ");
INSERT INTO plj_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Gasi kǝ sito Yesu wul mir mǝn kulci kar ti'e, <<Mǝ te ni den bishidiyi mǝnta.>> ");
INSERT INTO plj_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ar ni wu za womti mbarǝmi kaari, kan wu ndara nan ti gip kungǝlǝn jikat male. Kungǝlǝn jikat mali jen ra es nan ti. ");
INSERT INTO plj_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kan dun yam ba tli tor gǝsi, mal ba nǝm ghuni kungǝlǝn jikat mali, kan mal ba pare laa'i kungǝlǝnyika. ");
INSERT INTO plj_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu ra tǝp kaar kungǝlǝn jikat mali na gam gǝs den bar kǝ tli gami, tǝ den nde umuri. Mir mǝn kulci kartiyi putu ti kan wu wul ti'e, <<Ba mǝn kulci, ar ghun ki diya, mǝ ri kǝ mǝshtǝn wu gwa?>> ");
INSERT INTO plj_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Tǝ tlyami, kan tǝ matl itǝr kan tǝ wul zap mali'e, <<Sa shot! Dlǝr lasi nǝm!>>Ar ni itǝri za'i, kan las ba sa shot hoyi. ");
INSERT INTO plj_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yesu wul mir mǝn kulci kartiyi'e, <<Unun kem bǝrti nǝm kǝnwe? Kǝ'i ni ra na holi ngǝshtǝn den Yama?>> ");
INSERT INTO plj_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Bǝrti nǝm mir mǝn kulci kar tiyi naari kan wu wul ezǝn'e, <<Wo ni'e muntuwe? Itǝr na zap mal ma wu kop shirǝm gǝsi!>> ");
INSERT INTO plj_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu na mir mǝn kulci kar ti jikat ɓula wu te den kǝti ɓula kǝ Galili, gip atl kǝ mǝn Gerasa. ");
INSERT INTO plj_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Na ɗǝltǝn kǝ Yesu sur gip kungǝlǝn jikat maliwo, ar ni mbarǝm gon mǝn dun itǝr tli ɗir kǝ ba gambǝci tǝ mbor ti. ");
INSERT INTO plj_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Gambǝci ni'e ba dǝmi kǝ mbarǝmi. Murgon ra kan ba mbu nǝmi gǝs tǝ ɓal tika na sarsari da'a. ");
INSERT INTO plj_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Tla ɓali gǝska am na asǝm na sarsari, ama wokoci tu kup ɓaltikawo tǝ kur ngot sarsariyika tǝ ceccen sarsari kǝ asǝm da tika. Murgon ra kan baa mani nǝmi gǝs kǝ ɓali na ndǝrtǝn kǝ bigul da'a. ");
INSERT INTO plj_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ba dǝmi gǝs ni'e ba gambǝci na gip tlǝndǝre, ti den la'i yar na tloyi dli gǝs na tate. ");
INSERT INTO plj_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nan ti shin Yesu terkawo, ar ni tǝ tli na kǝtǝr tǝ te nda ngurup cina da ti. ");
INSERT INTO plj_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Tǝ la yar hoyi tǝ wule, <<Unun ghun ki namǝni, Yesu, Nya Bar Gun kǝ to yamka? A lir ki gip sun kǝ Yami, ba kǝ kumim dli da'a!>> ");
INSERT INTO plj_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Tǝ yari ni untu nan Yesu wule, <<Dun itǝri, ɗǝl ter gip mbarǝm tuka!>> ");
INSERT INTO plj_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ar ni Yesu wul ti'e, <<Ununu ni'e sun gi?>> Mbarǝmi nǝmi ti tǝ wule, <<Sun gǝn ni'e womti, nan mǝn ra na womti gwa.>> ");
INSERT INTO plj_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Kan tǝ pi ta liri Yesu den ba dǝ tǝ ɗǝli ga dun itǝrika gip las tu kan wu dǝm gwa da'a. ");
INSERT INTO plj_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ar dǝm'e kosak na lasiwo womti alade ra den ci bar gǝs tlǝndǝre. ");
INSERT INTO plj_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ar ni ga dun itǝri lir Yesu wu wule, <<Kar mi te gip alade juka, za mi mǝ te gip wuri.>> ");
INSERT INTO plj_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Tǝ nǝmi wuri, kan ga dun itǝri ba ɗǝl ter gip mbarǝmi wu te gip aladeyi. Womtitǝn kǝ aladeyi ri zangu rop (2,000), kan wu yem sur atl na kǝtǝr wu su ro gip mal wu mǝshka. ");
INSERT INTO plj_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Nan mǝn le aladeyi shin untuwo ar ni wu tli na kǝtǝre wu te gip bǝni na mir bǝn kǝ markǝmi, wu yari argon tu kan pi gwa. Mbarǝm ɗǝl ɗir kǝ shini argon tu kan ratl gwa. ");
INSERT INTO plj_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Nan wu ɗir kar Yesuwo ar ni wu shin mbarǝmi kan ra har na womti dun itǝri gwa. Nan wu shin ti njon lasi gip tutul dli kan gam gǝs pal semwo, ar ni bǝrti ci wuri. ");
INSERT INTO plj_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Munju kan shin argon tu kan piwo, ar ni wu yari mbarǝm argon tu ndo na mbarǝm mǝn dun itǝri na aladeyi esi. ");
INSERT INTO plj_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ar ni mbarǝm kǝ bǝni nǝm liri Yesu den tǝ za atl gǝzǝni. ");
INSERT INTO plj_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Nan Yesu den totǝn gip kungǝlǝn jikat malo, ar ni mbarǝm tu kan ra har na dun itǝri lir ti tǝ wule, <<Za'ǝm a kop ki ngapi.>> ");
INSERT INTO plj_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ama Yesu nǝmi ti da'a, ama kan tǝ wul ti'e, <<Ndara bom kar ya'ǝn kǝ yari wur kiri bar na womti ju kan Babom pi'i na kandatu tǝ shin guna gi gwa.>> ");
INSERT INTO plj_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ar ni mbarǝmi ndara tǝ kop mir bǝn gudǝli kutl kǝ gip atli, tǝ nǝm yari mbarǝm kiri bar na womti ju kan Yesu pi ti gwa. Ar dlǝkǝn mbarǝm ju kup kan kum argon tu tǝ yari gwa. ");
INSERT INTO plj_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Nan Yesu to gip kungǝlǝn jikat mal tǝ pa jikati tǝ te den kǝtǝyi gon kǝ ɓula'iwo, ar ni mbarǝm na womti dom wur kar ti nan ti'i ra bi ɓula'i gwa. ");
INSERT INTO plj_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ar ni mbarǝm gon gip kǝ cina kǝ bom domtǝn kǝ mǝn Yahuda, mǝn sun Yayirus, ɗir lasi. Nan tǝ shin Yesuwo ar ni tǝ nda atl cina da ti. ");
INSERT INTO plj_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Tǝ pi ta liri Yesu, tǝ wule, <<Nye mǝtli gǝn ra bi dǝ mǝshtǝni. Kustu, ɗir ne am den ti kǝ pǝni ti kumi dliyika, tǝ pal lau ra.>> ");
INSERT INTO plj_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ar ni Yesu ri nan ti. Mbarǝm na womti kop ti kaari, wu den tla'i gǝska. ");
INSERT INTO plj_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Nagǝr gon ra lasi muntu kan pi sheti ghon kutl cet rop bǝran den tatltǝn gip ti gwa. ");
INSERT INTO plj_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Tǝ kum dli naarwi am dǝ mǝn bi un na jili bar ju kup tǝra nari gwa. Kup na untu, kumi dli gǝso ci cina na naartǝn ni ar dene. ");
INSERT INTO plj_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nan tǝ kum shirǝm den Yesuwo, ar ni tǝ ri tǝp kaar da ti gip womti mbarǝm ju, kan tǝ ne am den bi tutul dli gǝsi. ");
INSERT INTO plj_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Tǝ pi ni untu domici tǝ dam ti tor gip mbatl gǝs tǝ wule, <<Ami ni a zam a ne am den tutul dli gǝs katl ma, kumi dli gǝn baa pa'i.>> ");
INSERT INTO plj_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ar ri kǝtigon da'a ar ni tatltǝn kǝ bǝran gǝs dlǝri, tǝ pa kum gip dli gǝs den tǝ warkewi. ");
INSERT INTO plj_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Bar tu ar ni Yesu kum iko kǝ pi bar ɗǝl gip ti, ar ni tǝ bal ti rǝn den womti mbarǝmika tǝ wule, <<Wo ni ne am den tutul dli gǝn we?>> ");
INSERT INTO plj_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ar ni mir mǝn kulci kar ti nǝmi ti wu wule, <<Ɓa shin womti mbarǝm ju kan den tla'i gi gwa, kan kǝ wule, <Wo ni ne am demǝna?> >> ");
INSERT INTO plj_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ama Yesu pi ta kari ger kǝ dǝ tǝ shin muntu pi untuyi gwa. ");
INSERT INTO plj_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nagǝr mǝri na momi argon tu kan zam tiwo, ar ni tǝ ɗir ngus cina dǝ Yesu, tǝ den dǝdartǝn gip bǝrti, kan tǝ yari Yesu ge shirǝm kǝ kup argon tu kan pi gwa. ");
INSERT INTO plj_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ar ni tǝ wul nagǝr mǝriyi'e, <<Nya gǝni, ngǝshtǝn gi den Yam warke i'wi. Ndara bom na ghol mbatli, kǝ zam paltǝn lau den kumi dli giwi.>> ");
INSERT INTO plj_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Nan Yesu i'den shirǝmo, ar ni jen gip mir mǝn bom kǝ Yayirus kan'e bari kǝ bom domtǝn kǝ mǝn Yahuda gwa, wu ɗir wule, <<Nye mǝtli gi mǝsh kawi, unun kem kǝ pa ghun ba mǝn kulci rawe?>> ");
INSERT INTO plj_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ama Yesu kar kǝm den argon tu kan wu yari gwa da'a, kan tǝ wul ti'e, <<Ba kǝ kum bǝrti da'a, ki de ngǝsh ki den Yami.>> ");
INSERT INTO plj_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ar ni tǝ za murgon kop ti kaar da'a se ga Bitǝrus, na Yakubu, na Yohana erǝm kǝ Yakubu. ");
INSERT INTO plj_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Nan wu mbubar bom dǝ Yayiruso, ar ni Yesu shin kandatu las pika ghiru-ghiru kan mbarǝm den ta kulu na la'i yar hoyi gwa. ");
INSERT INTO plj_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ar ni tǝ te gipi kan tǝ wul wur'e, <<Unun kem kǝn den kulu na la'i yar untuwe? Nyayi mǝsh nika da'a, umur ni tǝ dene.>> ");
INSERT INTO plj_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ar ni wu gyatli ti. Nan tǝ kaar wurka kup te kaari kawo, kan tǝ pǝn basi nyayi na nase na mir mǝn kulci kar ti ju kan ra nan ti gwa, kan tǝ te gip kupshiyi las tu nye gǝri ra gwa. ");
INSERT INTO plj_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Tǝ nǝm am kǝ nyayi, kan tǝ wul ti'e, <<Talita kum!>> (Muntu ba pi nupi gwa'e, <<Nye gǝre, a wul ki'e, tlyami!>>) ");
INSERT INTO plj_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ar ri kǝtigon da'a ar ni nye gǝri tlyam dlor kan tǝ nǝm desi. Bar kǝ sheti ghon kutl cet rop ni nye gǝri ra na gǝri. Muntu kem mbarǝm ju kan ra lasi gwa kǝ nǝmi bi na am na naari. ");
INSERT INTO plj_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ama Yesu dǝli wur kǝm hoyi den ba dǝ wu yari murgon shirǝm tu da'a. Ar ni tǝ wul wur'e wu bi nye gǝri fingal tǝ ci. ");
INSERT INTO plj_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu za barta kan tǝ ndara bǝn gǝzǝni, mir mǝn kulci kar ti kop ti kaari. ");
INSERT INTO plj_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Nan pǝt shukutǝn ɗiro, tǝ nǝm kulci mbarǝm gip bom domtǝn kǝ mǝn Yahuda, ar ni munju kup kum ti gwa nǝm bi na am wu wule <<Ako ni mbarǝm kǝn zam bar ju untu wu? Unu bopya ni bi ti untu we? Imnu har tǝ mani pi kiri bar kǝ nǝmi bi na am unjuwe? ");
INSERT INTO plj_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Muntu ni'e kapǝnta tu diya? Ti ni'e nya Maryamu kan erǝm kǝ ga Yakubu, na Yusufu, na Yahuda, na Siman da'aya? Kan ga erǝm gǝs mir mǝtli ni ɗe nan mi diya?>> Ar ni wu kum lo gǝsi. ");
INSERT INTO plj_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ar ni Yesu wul wur'e, <<Ba hol shini nartǝn kǝ mǝn yari shirǝm kǝ Yam da'a se gip bǝn gǝsi, gip dǝngi gǝsi, na gip mbarǝm kǝ bom gǝsi.>> ");
INSERT INTO plj_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Tǝ mani pi bar kǝ nǝmi bi na am na womti lasi da'a, se mbarǝm njem ni katl tǝ ne am gǝs den wur tǝ pǝni wur kumi dli gǝzǝnka. ");
INSERT INTO plj_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Holi ngǝshtǝn den Yam gǝzǝn ghun Yesu naari. Kan Yesu ba pi ta kopi mir bǝn tǝ den kulci mbarǝme. ");
INSERT INTO plj_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yesu la bi mir mǝn kulci kar ti kutl cet ropi, ar ni tǝ kar wur rop-rop kan tǝ bi wur iko den gam ga dun itǝri. ");
INSERT INTO plj_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Tǝ wul wur'e, <<Ba kǝ pǝn ni argon gip ɓomi asǝm gin da'a, ko bǝredi, ko poshe, ko wurpi den dli gini, se de dlo katl. ");
INSERT INTO plj_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Kem ni kaptǝlanye ama ba kǝ yem ni tutul tli rop da'a.>> ");
INSERT INTO plj_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Tǝ wul wur'e, <<Wokoci tu kǝ te gip bom gono, dǝm ni lasi ar ri gas tu kii za bǝni gwa. ");
INSERT INTO plj_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Las tu kup nge pi ɗem nan kǝn ko wu kum kǝn dawo, za ni lasi kan kǝ bat ni kushka kǝ den asǝm ginka den bi seda den wuri.>> ");
INSERT INTO plj_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ar ni wu ndara kan wu pi wazu den dǝ mbarǝm ci atl gam wu pal kar Yami. ");
INSERT INTO plj_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Wu ɗǝli dun itǝrka gip mbarǝme kan wu bǝrke mir mbarǝm na womti kan den kumi dli gwa wu warke wuri. ");
INSERT INTO plj_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ar dǝm'e gun Hiridus kum shirǝm tu, domici kum sun kǝ Yesuwi ko ako. Jen den wultǝn'e, <<Yohana mǝn pi batisma ni tli gip mǝshi mbarǝme, kan untu ni kem bar kǝ dlǝkǝntǝn ju ba pi ra tǝp kar ti.>> ");
INSERT INTO plj_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ama jen wule, <<Iliya ni.>> Jen ngapo wu wule, <<Ti mǝn yari shirǝm kǝ Yam gon ni, wule nǝm gip ga mǝn yari shirǝm kǝ Yam gon kǝ terka.>> ");
INSERT INTO plj_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ama nan Hiridus kum muntuwo, tǝ wule, <<Yohana, muntu a kotǝli ti gamka gwa ni tli ti gip mǝshi mbarǝme!>> ");
INSERT INTO plj_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Domici Hiridus na gam gǝs ni kem ba ri nǝm Yohana ɗir kan ba ɓal tika gip bom moni. Tǝ pi ni untu domici kǝ Herodiya, nagǝr kǝ erǝm gǝs Filibus, muntu kan tǝ gudlumi nan ti gwa. ");
INSERT INTO plj_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Domici Yohana pi ta yari Hiridus'e, <<Ar ndari da'a kǝ gudlumi na gǝr kǝ erǝm gi.>> ");
INSERT INTO plj_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ar dǝm'e Herodiya nǝm muntu su mbatl da tika, kan tǝ ndu tǝ ri Yohana eka. Ama tǝ mani zami guntǝp kǝ pi untu da'a, ");
INSERT INTO plj_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","domici Hiridus ba kum bǝrti kǝ Yohana, tǝ mom'e Yohanawo mbarǝm mǝn pitǝn dlat kan dlǝran gip dǝmi gǝs gwa ni, ar ni kem Hiridus nǝm Yohana hoyi. Wokoci tu Hiridus kum shirǝm kǝ Yohanawo ar ba ghun ti naari, kup na untu, tǝ ndu kumi shirǝm gǝsi. ");
INSERT INTO plj_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Kǝ pa'i bisiwo kan tǝp ba ɗiri. Den pǝt gǝri kǝ Hiriduso ar ni tǝ pi nyel kiri kǝ ga mǝn tloyi shirǝmi na ga komanda kǝ mǝn bi-utu, na kiri mbarǝm kǝ gip atl kǝ Galili. ");
INSERT INTO plj_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Nan nya Herodiya nye mǝtli ter gipi kan tǝ dlar cina dǝ Hiridus na mǝn dǝki gǝso, ar kon wur naari. Ar ni gunyi wul nye gǝri'e, <<Liri argon tu kup kan kǝ ndu gwa, aa bi'i.>> ");
INSERT INTO plj_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Tǝ yari untu har na ɓe am atl tǝ wule, <<Argon tu kup kǝ liriwo, ko da baa tatl ni las tu ami gun gǝzǝn gwa gip dlom dǝ bi'i nǝmo, aa bi ika.>> ");
INSERT INTO plj_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ar ni nye gǝri te kaari kan tǝ wul nas'e, <<Ununu aa liri we?>> Kan nas ba wule, <<Liri'e dǝ bi'i gam kǝ Yohana mǝn pi batisma.>> ");
INSERT INTO plj_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nye gǝri zho ti te gipika kar gunyi tǝ wule, <<A ndu kǝkǝntu dǝ bim gam kǝ Yohana mǝn pi batisma gip gal kini.>> ");
INSERT INTO plj_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Na kumi untuwo, ar li gunyi mbatl naari, ama nan tǝ yari wi na ɓe am atl kan cina dǝn mǝn dǝki gǝso, tǝ ndu tǝ nge ti da'a. ");
INSERT INTO plj_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ar ni tǝ kar dogari gǝs na zhotǝn den tǝ ri bom moni tǝ ɗir na gam kǝ Yohana. Mbarǝmi ndara tǝ ri kotǝl gam kǝ Yohana gip bom kǝ moniyi. ");
INSERT INTO plj_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Kan tǝ ɗir nari gip gal gin tǝ bi nye gǝri, kan nye gǝri ba bi nase. ");
INSERT INTO plj_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Nan mir mǝn kulci kar Yohana kum argon tu piwo, ar ni wu ɗir pǝn tli gǝs wu kapka. ");
INSERT INTO plj_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Mir mǝn kulci kar Yesuyi dom wur kar ti kan wu yari ti bar ju kup wu pi na bar ju wu kulci mbarǝm gwa. ");
INSERT INTO plj_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ar dǝm'e mbarǝm na womti den ta ɗirtǝn na ndaratǝno, wu zam gǝs kǝ dǝmi kǝ ci fingal da ma, ar ni tǝ wul wur'e, <<Ɗir ni mǝ ndara ni kǝ ba las kan ra zhikai gwa, kǝ zam kǝ shuku ni ra.>> ");
INSERT INTO plj_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ar ni wu to gip kungǝlǝn jikat mal wu ndara las tu mbarǝm ra dagwa, wi ni nan gǝzǝn katl. ");
INSERT INTO plj_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ama nan wu za lasiwo, ar ni na womti gip mbarǝmi shin wurka, kan wu momka'e wi ni. Ar ni mbarǝm tli ɗir gip mir bǝni kup, wu kop bishidi na kǝtǝr wu pare mbu'i barka cina da wuri. ");
INSERT INTO plj_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Na ɗǝltǝn kǝ Yesu sur gip kungǝlǝn jikat maliwo, ar ni tǝ shin mbarǝm na womti. Tǝ kum guna gǝzǝn nan wi nǝra wule tǝm ju kan ra na mǝn le gǝzǝn da'a gwa. Ar ni tǝ nǝm kulci wur bar na womti. ");
INSERT INTO plj_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Nan pǝt ba ri kǝ ndetǝn binwo, ar ni mir mǝn kulci kar tiyi ɗir kar ti wu wul ti'e, <<Las kǝno murgon ra da'a, ar tu pǝt ba ri kǝ ndetǝn bin wi. ");
INSERT INTO plj_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Za mbarǝm ju wu ndara kǝ dǝ wu te gip mir bǝn kan ra kosak gwa wu wuri gam gǝzǝn fingal kan wii ci gwa.>> ");
INSERT INTO plj_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ama Yesu nǝmi wur tǝ wule, <<Kǝno bi wur ni argon wu ci.>> Ar ni wu wul ti'e, <<Mǝri wur barkǝci na wurpi tu kan ba ɓatl nye mǝn mbap kǝ nde pǝt hauya kutl (200), mǝ ci nan wura?>> ");
INSERT INTO plj_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Tǝ wul wur'e, <<Bǝredi mǝneni kǝn ra nari we? Rii shin ni ɗiri.>> Nan wu kopo ar ni wu zam wu wul ti'e, <<Bǝredi nantam ni na kos rop.>> ");
INSERT INTO plj_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ar ni Yesu wul mir mǝn kulci kar tiyi'e wu wul mbarǝm'e wu dǝm gǝzǝn atl den yari jir bomi bomi. ");
INSERT INTO plj_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Kan wu dǝm atl bomi bomi jeno mbarǝm hauya nantam nantam kan jen eso hauya rop na kutl kutl. ");
INSERT INTO plj_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Nan tǝ nǝm bǝredi nantam na kos ropiwo kan tǝ la gam yami, tǝ goode Yami, kan tǝ ceccen bǝrediyi. Nan tǝ pi untuwo kan tǝ bi mir mǝn kulci kar ti kǝ dǝ wu kop mbarǝm rinka wu bi wuri. Untu es tǝ pa njetǝl kos ropi kan tǝ bi mbarǝmi kup. ");
INSERT INTO plj_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ar ni kup gǝzǝn ci kan ar ba kǝm wuri. ");
INSERT INTO plj_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ar ni mir mǝn kulci kar tiyi yem roɓǝs bǝrediyi na kosi kan wu laa'i shar kutl cet rop nari. ");
INSERT INTO plj_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Womtitǝn kǝ moni kan ci fingali gwa ni'e Zangu nantam. ");
INSERT INTO plj_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ar ri kǝtigon da'a den kaar kǝ untuwo, ar ni Yesu wul mir mǝn kulci kar ti'e wu to gip kungǝlǝn jikat mal wu nda cina wu te bǝn kǝ Betsaida. Ti ngapo kan tǝ pali bi womti mbarǝmi kǝ dǝ wu ndara. ");
INSERT INTO plj_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Den kaar kǝ pali bi womti mbarǝmiwo ar ni Yesu to gǝs den tlǝndǝr kǝ shirǝm na Yami. ");
INSERT INTO plj_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nan sit piwo, kungǝlǝn jikat mali ra te dlom malika, ama Yesu ra ter den bishidi nan gǝsi. ");
INSERT INTO plj_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Yesu shin wu den ndotǝn na dǝli kungǝlǝnyi nan itǝr den ghuni gǝzǝn gwa. Bar kǝ gǝlla am myakan kǝ gaso, ar ni wu shin ti den tertǝn kar wur tǝ den desi den gam mal bar ɓula'i. Tǝ pi wule tii bi wur ni kaari, ");
INSERT INTO plj_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ama nan wu shin ti den desi den gam malo, ar ni wu pǝn'e tlon ni, kan wu la yare, ");
INSERT INTO plj_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","domici nan kup gǝzǝn shin tiwo, ar ni mbatl tari wurka. Ar ni tǝ shirǝm nan wur na zhotǝn tǝ wule, <<Dlǝri ni mbatl gini! Ami ni. Ba kǝ kum ni bǝrti da'a.>> ");
INSERT INTO plj_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ar ni tǝ to gip kungǝlǝn jikat mali kar wuri kan itǝri ba za zhe'e pitǝne. Argon tu tǝ pi gwa dlǝkǝn wur naari, ");
INSERT INTO plj_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","domici wu mom argon tu ci na mbarǝm zangu nantam tu ba pi nupi gwa da'a, nan mbatl gǝzǝn mani momi bar mani pi bar tu kan tǝra nari dagwa. ");
INSERT INTO plj_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Nan Yesu na mir mǝn kulci kar ti mbubar den kǝtǝ nǝm kǝ ɓula'iwo, ar ni wu dǝm gip atl kǝ Jenisarat kan ba ɓal kungǝlǝn jikat mali bi ɓula'i. ");
INSERT INTO plj_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Na ɗǝltǝn gǝzǝn sur gip kungǝlǝn jikat maliwo ar ni mbarǝm ban kǝ momika den'e Yesu ni da'a. ");
INSERT INTO plj_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Kan wu kǝtǝr ɗir kar ti tǝp ko ako gip atli kup, wu ɗiri mǝn kumi dli ɓom den bamuri gǝzǝn kup las tu wu kum Yesu ra gwa. ");
INSERT INTO plj_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Las tu kup tǝ riwo, gip bar bǝn na ko nye bǝn ko bi lǝpe, wu ɗiri mǝn kumi dli bi bar pǝte. Wu lir ti den tǝ nǝmi wur kǝ dǝ mǝn kumi dli gǝzǝn ne am den bi lulur gǝsi. Munju kup kan ne am den tiwo kan ba pǝni wur kumi dli gǝzǝnka. ");
INSERT INTO plj_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Mǝn Parise na mǝn kulci mbarǝm den kulci kǝ Musa jen kan tli tor Urshalima dom wur kar Yesu. ");
INSERT INTO plj_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ar ni wu shin mir mǝn kulci kar ti den ci fingal na am kan ra dlǝran da gwa, wu ho am da'a ituwi. ");
INSERT INTO plj_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Munju kan gip mǝn Parise na kup mǝn Yahuda ba ci fingal da'a se wi ni wu ho am gǝzǝnka den kopi argon tu kǝ cina gǝzǝn wule wu kop gwa. ");
INSERT INTO plj_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Wi ni wu za kǝ ba bar pǝt wu pal rǝn bom kawo, wu ci fingal da'a se wi ni wu ho wur kakani. Bar jen ra na womti kan wu zam untun ba pi kan wu kop gwa, wule ga ho'i gal tle male, tat nge male, na ba shoti male. ");
INSERT INTO plj_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ar ni mǝn Pariseyi na mǝn kulci mbarǝm den kulci kǝ Musa ngen momi kar ti wu wule, <<Unun kem mir mǝn kulci kar ki ba dǝm na kopi bar ju kǝ cina gǝmi wule mǝ kop gwa da'a nan wu ci fingal na am ju kan dlǝran ni ar ra da gwa?>> ");
INSERT INTO plj_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu nǝmi wur tǝ wule, <<Kǝn mǝn se mbarǝme! Dlat ni Ishaya yari shirǝm kan ɗǝl sur kar Yam den kǝn kandatu ar ra na rǝshi gwa'e, <Mbarǝm juwo wu ɗǝɗa'ǝm ni na bi gǝzǝni, ama mbatl gǝzǝn dlyamka namǝni. ");
INSERT INTO plj_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Wu botem ni katl, nan kulci gǝzǝno bar ju nya Mbarǝm wule dǝ pi gwa ni.> ");
INSERT INTO plj_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Kǝ za pi argon tu Yam wule dǝ pi gwawi, kǝn den kopi bar ju kan nya mbarǝm ni wule dǝ pi gwa.>> ");
INSERT INTO plj_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ar ni tǝ pa wul wur'e, <<Na ho bi, kǝ mani za'i kopi argon tu kan Yam ni wule dǝ pi gwa den bi kopi bar ju kori gin wule kǝ kop gwa! ");
INSERT INTO plj_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Domici Musa wule, <Bi nartǝn be na nǝna gi,> kan <Muntu kup kan zage bas ko naso, dǝ ri ti eka.> ");
INSERT INTO plj_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ama kǝ wule mbarǝm baa wul bas ko nas wokoci tu wu ndu bar kar ti gwa'e, <Argon tu kan aa ne in am ra nariwo a tare a bi Yam kawi.> ");
INSERT INTO plj_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Tǝp untuwo, kǝ kem tii'i ne am ga bas na nas da'a ituwi. ");
INSERT INTO plj_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ra untuwo, kǝ pali shirǝm kǝ Yam dǝmka wop den bi kopi al'ada ju kǝ kulci mimir gin gwa. Untu ni es kǝ pi den bar na womti.>> ");
INSERT INTO plj_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Kano Yesu ba pa la bi womti mbarǝmi kar ti tǝ wul wur'e, <<Kumǝn ni, ko gonge gini, kan kǝ mom ni muntu. ");
INSERT INTO plj_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Argon tu kan ba te gip mbarǝm tǝp bi ni ba li tika da'a, ama argon tu kan ba ɗǝl ter gip mbarǝm gwa ni ba li mbarǝmka cina dǝ Yami. ");
INSERT INTO plj_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","(Muntu kup kan ra na kǝm kǝ kumiwo na tǝ kumi.)>> ");
INSERT INTO plj_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Nan tǝ za womti mbarǝmiwo ar ni tǝ te gip bomi, mir mǝn kulci kar ti ngen momi gǝs kǝ kolɗa bi tu. ");
INSERT INTO plj_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ar ni tǝ nǝmi wur tǝ wule, <<Kǝn ma kǝ hol ni momi ya? Kǝ mom ni'e argon tu kup ba te gip mbarǝm tǝp kaariwo ar baa mani li mbarǝmka da'i da'aya, ");
INSERT INTO plj_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","domici gip mbatl gǝs ni ar ba su da'a ama gip tu gǝs ni, kan ar pa ɗǝlka gip dli gǝsi.>>(Gip shirǝm tuwo Yesu yari ni'e kup bar kǝ ciwo dlǝran ni ar ra.) ");
INSERT INTO plj_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Tǝ ci cina na shirǝm tǝ wule, <<Argon tu kan ba ɗǝl tor gip mbarǝm gwa ni ba li mbarǝm ka. ");
INSERT INTO plj_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Domici tor gip mbatl kǝ mbarǝm ni wani damtǝn ba ɗǝli, wani damtǝn wule ga holi nǝmi gami, mure, ri mbarǝm eka, muri na mǝtli ko na moni kaari, ");
INSERT INTO plj_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","te ger den bar kǝ mbarǝme, ngarci, setǝne, ndu'i kumi tǝmi kan ra na sham gipi da'a, ghuve, li gami, giɓǝr gami, na kǝdlǝm pitǝne. ");
INSERT INTO plj_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Munju wani bar ju kupo tor gip mbatl kǝ mbarǝm ni ba ɗǝli, wi ni ngap wu li mbarǝmka.>> ");
INSERT INTO plj_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Nan Yesu za lasiwo, ar ni tǝ ndara atl kǝ Taya na Sidon. Tǝ te gip bom goni ama tǝ ndu ba dǝ murgon mom da'a. Ama kup na untu tǝ ghun kar mbarǝm da'a. ");
INSERT INTO plj_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Nagǝr gon kan nya gǝs nye mǝtli den ta ndotǝn na dun itǝro, na kumi shirǝm den Yesuwo, ar ni tǝ ɗir nda cina da ti. ");
INSERT INTO plj_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Nagǝr mǝriwo mǝn Hellas ni, gǝri kǝ gip atl kǝ Finiks gip Siriya. Ar ni tǝ lir Yesu den tǝ ɗǝli dun itǝrika gip nya gǝs nye mǝtli. ");
INSERT INTO plj_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yesu wul ti'e, <<Naa dǝ mimir ci ar kǝm wur kakani. Ar ndari dǝ pǝn fingal kǝ mimir dǝ bi yer da'a.>> ");
INSERT INTO plj_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ama nagǝri nǝmi ti tǝ wule, <<Babomi, untu ni ar ra, ama yer ma wu zam wu ci mir roɓǝs fingal ju ba nda sur den tebǝr kǝ mimir gwa.>> ");
INSERT INTO plj_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ar ni Yesu wul ti'e, <<Den argon tu kǝ yari tuwo, pal gi rǝn bomka, dun itǝri za nya giwi.>> ");
INSERT INTO plj_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Nagǝr mbarǝmi ndara bomo ar ni tǝ zam nya gǝs ɓom den bamuri, dun itǝri ɗǝlka gip tiwi. ");
INSERT INTO plj_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ar ni Yesu za kǝti atl kǝ Tayaka kan tǝ kop gip Sidon, tǝ su bi ɓula kǝ Galili na gip kǝti atl kǝ Dikapolis. ");
INSERT INTO plj_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Barta ni mbarǝm jen ɗiri ti gon kan bebeni tǝ mani shirǝm da'a gwa, kan wu lir Yesu kǝ dǝ tǝ ne am den ti. ");
INSERT INTO plj_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ar ni Yesu dǝl kurmayi markǝm las tu mbarǝm ra da gwa, kan tǝ kem mir yasa gǝs su kǝm dǝ mbarǝmika. Ar ni tǝ bǝse mo'ǝm kan tǝ taɓe lǝka kǝ mbarǝmi. ");
INSERT INTO plj_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Tǝ la gam yami kan tǝ dǝl bar shukutǝni kan tǝ wul mbarǝmi'e, <<Etpata!>> Muntu gip bi kǝ Aramekwo ar ba pi nupi'e <<Ɓuli!>> ");
INSERT INTO plj_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Na yari untuwo ar ni kǝm kǝ mbarǝmi ɓuli, kan lǝka gǝs ba pǝtli, kan tǝ nǝm shirǝm hoyi. ");
INSERT INTO plj_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ar ni Yesu dǝli wur kǝm den ba wu yari murgon shirǝm tu da'a, ama na dǝli wur kǝmo, ar ni wu ci cina na yari shirǝmi. ");
INSERT INTO plj_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Mbarǝm ba pi ta nǝmi bi na ame, wu wule,<<Tǝ pi ko onu kor! Ar tu ma tǝ kem munju ba mani kumi shirǝm da'a na ngup bi kǝ shirǝmi.>> ");
INSERT INTO plj_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Gip muri ja ni mbarǝm na womti pa dom wuri. Eso wu ra na fingal da'a, ar ni Yesu la bi mir mǝn kulci kar ti tǝ wul wur'e, ");
INSERT INTO plj_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","<<A kum guna kǝ mbarǝm ju, muri myakan ituwi wura ɗe namǝni, ngapo, fingal ne wur ra kan wii ci gwa da'a. ");
INSERT INTO plj_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Wii ɗatka den tǝpe ami ni a wule wu ndara na guzum gwa, domici jen gip wur ɗǝl ni ɗir na dlyami.>> ");
INSERT INTO plj_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Kan mir mǝn kulci kar tiyi ba bali ti wu wule, <<Gip lǝp kǝno ako ni baa zam fingal kan baa kǝm mbarǝm ju gwawu?>> ");
INSERT INTO plj_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesu ngen momi kar wur tǝ wule, <<Bǝredi mǝneni kǝn ra na riwe?>> Ar ni wu nǝmi ti wu wule, <<Nyingi ni.>> ");
INSERT INTO plj_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ar ni tǝ wul domtǝn kǝ mbarǝmi'e wu dǝm atli. Nan tǝ pǝn bǝredi nyingiyiwo, ar ni tǝ goode Yami, kan tǝ cecceni, kan tǝ bi mir mǝn kulci kar ti kǝ dǝ wu bi mbarǝmi, kan wu pi untuyi. ");
INSERT INTO plj_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Wu ra es na mir kos jeni. Ar ni tǝ pa goode Yam dene kan tǝ wul wur'e wu bi mbarǝm esi. ");
INSERT INTO plj_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Mbarǝm ba ci ar ba kǝm wuri. Den kaariwo kan mir mǝn kartǝni ba yem roɓǝsi kan sa gwa ar ba laa'i shar nyingi. ");
INSERT INTO plj_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Womtitǝn kǝ moni kan ra lasi gwa ri zangu wupse. Den kaar kǝ pali wur bi wu ndarawo, ");
INSERT INTO plj_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ar ni tǝ zho ti tǝ to gip kungǝlǝn jikat mal na mir mǝn kulci kar ti tǝ ndara gip kǝti atl kǝ Dalmanuta. ");
INSERT INTO plj_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ar ni mǝn Parise ɗir nǝm bali shirǝm na Yesu kǝ dǝ wu gode ti ra. Ar ni wu lir ti kǝ tǝ gode wur halama bar kǝ dlǝkǝntǝn sur yami. ");
INSERT INTO plj_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Kan tǝ dǝl bar shukutǝn tǝ wule, <<Unun kem kǝn mbarǝm kǝ zhan kǝn kǝ ngen shini halama bar kǝ dlǝkǝntǝn rawe? Na ho bi ni a yari in ne, baa gode mbarǝm kǝ zhan kǝn halama gon da'a.>> ");
INSERT INTO plj_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Kan tǝ za wur lasi, tǝ pal gǝs to gip kungǝlǝn jikat mal tǝ te den kǝtiyi mǝn nǝm. ");
INSERT INTO plj_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ar ni mir mǝn kulciyi mǝsǝn ritǝn na bǝredika, se gudǝli nǝm kan wu ra nari gip kungǝlǝn jikat mali gwa. ");
INSERT INTO plj_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ar ni Yesu dǝli wur kǝm tǝ wule, <<Ngup kǝn ni na yesti kǝ mǝn Parise na kǝ Hiridus.>> ");
INSERT INTO plj_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ar ni mir mǝn kulci kar ti bali gip dlom gǝzǝn wu wule, ko nan mǝ ɗir na bǝredi da gwa ni? ");
INSERT INTO plj_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Nan Yesu momka na argon tu wu den bali gip dlom gǝzǝno, ar ni tǝ wul wur'e, <<Unun kem kǝn den shirǝm den holi ɗirtǝnka na bǝredi we? Kǝkǝn ma kǝ'i ni gip dǝmǝn gama? Kǝ pa mom wi da'aya? Mbatl gin i'nika na lati ya?>> ");
INSERT INTO plj_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Kǝn ra na gere ama kǝ ɗatka gip shini ya? Kǝn ra na kǝme ama kǝ ɗatka gip kumi ya? Kǝ'i dami da'a ya? ");
INSERT INTO plj_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Wokoci tu nan a cen bǝredi nantam ju mbarǝm zangu nantamo, shar mǝne ni kǝ yem laa'i na roɓǝsi kan sa gwa? Ar ni wu wul ti'e <<Kutl cet rop.>> ");
INSERT INTO plj_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","<<Eso, bǝredi nyingi ju a ceni mbarǝm zangu wupse gwa. Shar mǝne ni kǝ yem kǝ roɓǝsiyi?,>> Ar ni wu wul ti'e <<Nyingi.>> ");
INSERT INTO plj_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Kan Yesu ba wul wur'e, <<Kǝkǝn ma kǝ mani momi shirǝm gǝn wi diya?>> ");
INSERT INTO plj_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Nan wu ɗir Betsaidawo, ar ni mbarǝm jen ɗir na tabi goni, kan wu lir Yesu kǝ dǝ tǝ ne am den ti. ");
INSERT INTO plj_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu nǝm am kǝ tabiyi, tǝ ri ti kaar bǝni. Nan tǝ bǝse batayi mo'ǝm den ger tǝ ne am den tiwo, ar ni Yesu ngen momi kar ti, tǝ wul ti'e, <<Kǝ shin bara?>> ");
INSERT INTO plj_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ar ni tǝ tli gam yam kan tǝ wule, <<A shin mbarǝm kam, ama wule kin ni den ndǝtltǝni.>> ");
INSERT INTO plj_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ar ni Yesu pa ne am den ger kǝ mbarǝmi, kan ger gǝs ba ɓul tǝ nǝm shini bari hoyi. ");
INSERT INTO plj_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Kan Yesu ba za ti tǝ ndara bom tǝ wul ti'e, <<Ba kǝ'i te gip nye bǝniyi da'a.>> ");
INSERT INTO plj_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu na mir mǝn kulci kar ti ri gip mir bǝn kǝ Kaisariya Filibi. Den guntǝpo, ar ni tǝ ngen momi kar wur tǝ wule, <<O fa kǝ kum mbarǝm ba kur wule ami wo niwe?>> ");
INSERT INTO plj_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ar ni wu nǝmi ti wu wule, <<Jen ba wule ki Yohana mǝn pi batisma ni, jen ngapo Iliya, jen eso gon gip mǝn yari shirǝm kǝ Yam ni.>> ");
INSERT INTO plj_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ar ni tǝ wul wur'e, <<Kǝn fa? Ami wo ni kar kǝne?>> Kan Bitǝrus ba nǝmi ti tǝ wule, <<Ki ni'e Almasihu.>> ");
INSERT INTO plj_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ar ni tǝ dǝli wur kǝm tǝ wule ba wu yari murgon shirǝm tu da'a. ");
INSERT INTO plj_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Gip wokociyi ni Yesu nǝm kulci wur kandatu Nya Mbarǝm baa kum dli hoyi. Tǝ wul wur'e kiri kǝ bǝn na ga kiri lǝɓa kǝ Yam na ga mǝn kulci mbarǝm den kulci kǝ Musa baa nge ti. Baa ri ti eka ama den kaar kǝ muri myakano tii tli ra na ge mbatli. ");
INSERT INTO plj_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesu shirǝm den bar ju tetla tetla, ar ni Bitǝrus la ti bi markǝm tǝ nǝm matli gǝsi. ");
INSERT INTO plj_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ama Yesu bal ti ɗir tǝ shin mir mǝn kulci kar ti, kan tǝ matl Bitǝrus tǝ wule, <<Tli karǝmka, ki Shetan! Damtǝn giwo den bar kǝ Yam ni da'a, ama kǝ mbarǝm ni.>> ");
INSERT INTO plj_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ar ni tǝ la bi domtǝn kǝ mbarǝmi na mir mǝn kulci kar ti tǝ wul wur'e, <<Muntu kup ba ndu kopi gǝno, se tǝ nge gam gǝska, tǝ pǝn kin rati gam gǝsi, tǝ kopǝni. ");
INSERT INTO plj_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Domici muntu kup ba ndu ge mbatl gǝso, tii holka, ama muntu kup hol ge mbatl gǝska domici gǝn na kǝ zo shirǝmo, tii ne nǝka. ");
INSERT INTO plj_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Unu ho bar ni mbarǝm baa zami ti ni tǝ zam atl kundǝrǝndlip den bi ge mbatl gǝs gwawu? ");
INSERT INTO plj_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Unun es mbarǝm baa mani bi den bi ge mbatl gǝswe? ");
INSERT INTO plj_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Muntu kup ba kum sham gǝn na kǝ shirǝm gǝn gip zhan kǝn mǝn nge kopi Yam na pi warwat pitǝno, Nya mbarǝm baa kum sham gǝs gas tu nan tǝ sur na mir mǝn kartǝn kǝ Yam mǝn tsarki gip ɗǝɗatǝn kǝ Bas gwa.>> ");
INSERT INTO plj_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ar ni tǝ pa wul wur'e, << Na ho bi ni a yari ine, jen ra dlor ɗe, wii mǝsh da'a se wi ni wu shin mulki kǝ Yam cwat na ndǝrtǝn kakani.>> ");
INSERT INTO plj_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Den kaar kǝ muri mukkawo ar ni Yesu pǝn Bitǝrus, na Yakubu, na Yohana, tǝ te wur den bar tlyari tlǝndǝr gon wu nan gǝzǝni. Wu ra lasiwo ar ni tǝ cirka cina da wuri. ");
INSERT INTO plj_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Kan tutul dli gǝs ba palka gholi tar, ar ba pǝn ba gere kandatu kan mǝn ho'i tutul gon ra gip atl kundǝrǝndlip kan baa mani pi untu gwa da'a. ");
INSERT INTO plj_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ar ni ga Iliya na Musa cwat kar wuri, wu den shirǝm na Yesu. ");
INSERT INTO plj_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Kan Bitǝrus ba shirǝm na Yesu tǝ wule, <<Ba mǝn kulci, ar ndari nan mǝn ra ɗe gwa. Naa mǝ tu mir ba shukutǝn myakan, nǝmo ge, nǝm kǝ Musa, nǝm ngapo kǝ Iliya.>> ");
INSERT INTO plj_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Tǝ mom argon tu nan tǝ yari gwa da'a, domici ti na nami mir mǝn kulci kar Yesuyi kum bǝrti naari.) ");
INSERT INTO plj_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ar ni dun yam gon sur le wurka, kan yar ba ɗǝl sur gip dun yam ba wule, <<Muntuwo ti ni'e nya gǝni, muntu a ndu ti gwa. Kum tǝni!>> ");
INSERT INTO plj_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Gip untu nan wu kar gero, wu'i shin murgon da'a se Yesu ni nan wur katl. ");
INSERT INTO plj_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nan wu den ɗǝltǝn sur den tlǝndǝriwo, ar ni Yesu dǝli wur kǝm den ba wu yari murgon bar tu wu shin gwa da'a, se Nya Mbarǝm ni tlika gip mǝshi mbarǝm kakani. ");
INSERT INTO plj_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ar ni wu za shirǝmi gip dlom gǝzǝni, kan wu nǝm ngeni momi kar ezǝn den'e unun <<tlitǝnka gip mǝshi mbarǝm>> ba pi nupi. ");
INSERT INTO plj_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ar ni wu ngen momi kar ti wu wule, <<Unun kem mǝn kulci mbarǝm den kulci kǝ Musa ba wule mǝn yari shirǝm kǝ Yam Iliya ni baa cwat kakanu?>> ");
INSERT INTO plj_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ar ni Yesu nǝmi wur tǝ wule, <<Na ho bi ni, mǝn yari shirǝm kǝ Yam Iliya ni baa cwat kakani, tǝ kǝrkǝm bar kup. Ama ar ra na rǝshi gip shirǝm kǝ Yam es'e Nya Mbarǝm baa kum dli hoyi, kan dǝ nge ti diya? ");
INSERT INTO plj_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ar tu Iliya tare ɗir wi kan mbarǝm ba pi ti ndu'i kǝ mbatl gǝzǝni, kandatu ar ra na rǝshi den ti gwa.>> ");
INSERT INTO plj_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Nan Yesu na nami mir mǝn kulci kar ti ju myakani pal ɗir kar nami mir mǝn kulciyiwo, ar ni wu zam bar domtǝn kǝ womti mbarǝm na mǝn kulci mbarǝm den kulci kǝ Musa den tli yar yam nan wuri. ");
INSERT INTO plj_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nan domtǝn kǝ mbarǝmi shin Yesuwo, ar ni wu nǝm bi na am na ghol mbatl kan wu yem na kǝtǝr te kar Yesuka wu shirmi ti. ");
INSERT INTO plj_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesu ngen momi kar wur tǝ wule, <<Tli yar yam kǝ unun kǝ pi nan wur we?>> ");
INSERT INTO plj_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ar ni gon gip womti mbarǝm ju nǝmi ti tǝ wule, <<Ba mǝn kulci, ar tu a ɗiri'i nya gǝn wi mǝn dun itǝr nan ba pali tika ngupbi gwa. Dun itǝri ba za ti tǝ shirǝm da'a. ");
INSERT INTO plj_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Wokoci tu kup ar tli tiwo, ar ba byal ti atl kan dǝ hukǝtkǝt ɗǝli ti ter bi. Dli gǝs ba ndǝrka hoyi kan tǝ ngǝngash shine. A shirǝm na mir mǝn kulci kar ki wu ɗǝli ti dun itǝrika, ama wu mbu da'a.>> ");
INSERT INTO plj_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ar ni Yesu nǝmi wur tǝ wule, <<Kǝn mbarǝm kǝ zhan kǝn mǝn nge la'i mbatli, muri mǝneni a dǝm nan kǝnu? Har gigasi ni a mbu nan kǝnwe? Ɓa ɗirim ni nyayi ɗe.>> ");
INSERT INTO plj_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ar ni wu ɗiri ti nyayi. Nan dun itǝri shin Yesuwo, na zhotǝne kan dun itǝri ba ɓo nyayi atli, dli gǝs den dǝdartǝni, tǝ den kurngǝltǝne, bi gǝs den ɗǝli hukǝtkǝte. ");
INSERT INTO plj_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Kan Yesu ba ngen momi kar basi nyayi tǝ wule, <<Gigasi ni bar tu nǝm tiwu?>> Ar ni basi nyayi nǝmi ti tǝ wule, <<Tun tǝ'i ra nyayi gwani. ");
INSERT INTO plj_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ar ba kur byal ti gip utu na male, kǝ dǝ ar ri ti eka. Ama ki ni kii mani pi argono, kum guna gǝmi kǝ nemi am ra.>> ");
INSERT INTO plj_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ar ni Yesu nǝmi ti tǝ wul ti'e, <<Imnu kǝ wule ko aa mani pi argon gwa? Bar kupo mǝn pitǝn ni kar muntu ngǝsh ti den Yam gwa.>> ");
INSERT INTO plj_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Na zhotǝne ar ni basi nya yi tli yar yam tǝ wule, <<A ngǝshim wi, nem am a ngǝshim ra den Yami!>> ");
INSERT INTO plj_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nan Yesu shin womti mbarǝm den ɗirtǝn kar ti na kǝtǝro, ar ni tǝ matl dun itǝri tǝ wul ti'e, <<Ki ruhu kǝ holi kumi na ngup bi, a wul ki'e ɗǝl ter gip tika, bat na paltǝn teka.>> ");
INSERT INTO plj_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ar ni dun itǝri la yare, tǝ luti nyayi hoyi, kan tǝ ɗǝli. Ar ni nyayi nda atl wule mǝshi, mbarǝm na womti ma wu wule <<Tǝ mǝsh kawi.>> ");
INSERT INTO plj_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ama Yesu nǝm am gǝs tǝ tli ti yami, kan tǝ dlǝr dlor. ");
INSERT INTO plj_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Nan Yesu te gip bomo, mir mǝn kopi gǝs ngen momi kar ti mol, wu wule, <<Unun kem miwo mǝ mani ɗǝli dun itǝri dawu?>> ");
INSERT INTO plj_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ar ni Yesu nǝmi wur tǝ wule, <<Badǝr dun itǝr tuwo tii ɗǝl nika katl tǝp kǝ ba shirǝm na Yami.>> ");
INSERT INTO plj_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Kan Yesu na mir mǝn kulci kar ti ba za lasi, wu kop gip atl kǝ Galili. Yesu ba ndu dǝ murgon mom las tu wura gwa da'a, ");
INSERT INTO plj_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Domici ti den kulci mir mǝn kulci kar ti den'e, <<Baa bi Nya Mbarǝmka am dǝ mbarǝme, wii ri ti eka. Gip muri myakan ngapo tii tli lasi.>> ");
INSERT INTO plj_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ama wu raka gip dǝmǝn gam den argon tu tǝ yari gwa, eso wu kum bǝrti kǝ wu ngen momi kar ti. ");
INSERT INTO plj_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Wu ɗir Kaparnahum. Nan wura gip bomo, ar ni Yesu ngen momi kar wur tǝ wule, <<Ɗir den tǝpo, den ununu kǝ tli yar yam rawu?>> ");
INSERT INTO plj_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ar ni wu yon gǝzǝni, domici den tǝpo wu tli yar yam den wo ni'e bari gip wuri. ");
INSERT INTO plj_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Nan tǝ dǝm atlo, ar ni tǝ la bi kutl cet ropi, tǝ wul wur'e, <<Muntu kup ba ndu'e tǝ nǝra kǝ cinawo, tii palka kǝ kaari, kan tǝ dǝm zher kǝ ezǝni.>> ");
INSERT INTO plj_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ar ni tǝ pǝn heli nya goni tǝ dlǝri ti gip dlom gǝzǝni. Kan tǝ pǝn nyayi am da ti tǝ wul wur'e, ");
INSERT INTO plj_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","<<Muntu kup pi ɗem na heli nya wule muntu gip sungǝno, ami ni tǝ pi ɗem namǝni. Muntu pi ɗem namǝn ngapo, ami ni tǝ pim da'a ama muntu karǝm sur gwa ni.>> ");
INSERT INTO plj_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Gip untuwo, ar ni Yohana wul ti'e, <<Ba mǝn kulci, mǝ shin gon den ɗǝli dun itǝrka gip sun gi, kan mǝ wul ti'e tǝ za'i, domici gip mi ni tǝra da'a.>> ");
INSERT INTO plj_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ar ni Yesu wule, <<Ba kǝ wul ti ni'e tǝ zaka da'a. Murgon ra kan baa pi bar kǝ dlǝkǝntǝn gip sun gǝn kan tǝ pa yari mǝgǝn shirǝm demǝn na zhotǝn da'a. ");
INSERT INTO plj_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Muntu kup ba shin bes gǝmi dawo, gwagǝmi ni. ");
INSERT INTO plj_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Na ho bi ni a yari ine, muntu kup kan bi in mal tle wuro mal nǝm, domici kǝn kǝ Almasihuno, ko njem tii hol ɓatltǝn gǝska da'a.>> ");
INSERT INTO plj_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","<<Ar baa dǝm bar kǝ guna dǝ muntu kup kan kem nǝm gip heli mimir ju mǝn ngǝshtǝn demǝn kǝ pi warwat pitǝn gwa. Ar baa mani ti dǝ ɓali ti bar ghuun ɗir yare, dǝ la ti su gip mal bar ɓulaka. ");
INSERT INTO plj_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Am gi ni ba kem ki warwat pitǝno, tlo ka. Ar ba mbuni'i mani dǝ kǝ te gip ge mbatl tu baa pa da gwa na am nǝm, na kǝ te gip bom utu na am gi kup pa ropi. Utu tu kan baa mǝshka dagwa. ");
INSERT INTO plj_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","(Lasiwo zhimbǝr mǝn ci gǝzǝn baa mǝshka da'a, utuyi ngapo baa mani mǝshi ka da'a.) ");
INSERT INTO plj_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Asǝm gi ni ba kem ki kǝ pi warwat pitǝno, tlo ka. Ar baa mbuni'i mani kǝ te gip ge mbatl tu kan baa pa dagwa kurkiyi na kǝ te gip bom utu na asǝm gi kup pa ropi. ");
INSERT INTO plj_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Lasiwo zhǝmbǝr mǝn ci gǝzǝno, wu mǝsh da'a, utuyi ngapo baa mani mǝshi ka da'a. ");
INSERT INTO plj_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ger gi ni ngap ba kem ki kǝ pi warwat pitǝno, ɗǝlika. Ar ba mbuni'i mani kǝ te gip mulki kǝ Yam na ger nǝm na dǝ la ki gip bom utu na ger gi kup pa ropi. ");
INSERT INTO plj_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Lasiwo, <Zhimbǝr mǝn ci gǝzǝn baa mǝshka da'a, utuyi ngapo baa mani mǝshi ka da'a.> ");
INSERT INTO plj_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Baa njer kogonge mbarǝm na utu kandatu ba njer bar tu ba ta'i Yam na mas gwa. ");
INSERT INTO plj_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Maso ho bar ni, ama tǝmtǝn gǝs ni ɗil kawo, imni kii pali rawe? Dǝm ni na mas gip kǝne, kǝ dǝm ni zhǝlili na ya'ǝni.>> ");
INSERT INTO plj_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ar ni Yesu za lasika, tǝ ndara kǝti atl kǝ Yahuda, na jikat bi ɓula Jodan. Mbarǝm na womti pa mo gam kar ti, kan tǝ pa kulci wur kandatu tǝ kur pi gwa. ");
INSERT INTO plj_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ar ni mǝn Parise jen ɗir kar Yesu kǝ dǝ wu gode ti, wu ngen momi kar ti wu wule, <<Den bi kulci gǝmiwo, ar ndari dǝ mbarǝm kar gǝr gǝs kaya?>> ");
INSERT INTO plj_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ar ni Yesu nǝmi wur tǝ wule, <<Unun Musa wul kǝn'e kǝ piwe?>> ");
INSERT INTO plj_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Kan wu nǝmi ti wu wule, <<Musa bi mi bi den'e, dǝ mbarǝm rǝsh tǝlankur ngoti gudlumi, kan tǝ kar tika.>> ");
INSERT INTO plj_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ama Yesu wul wur'e, <<Den bi lati gam gin ni Musa rǝsh kan tǝ bi in bi kǝ pi untu. ");
INSERT INTO plj_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ama terka na ne gǝs kǝ pi baro, <Yam pi wur ni gǝr mǝtli na moni.> ");
INSERT INTO plj_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ra untuwo, mbarǝm baa za bas na naska, tǝ ni dlakǝt na nagǝr gǝsi, ");
INSERT INTO plj_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","wu ropiwo wu dǝm nǝm ituwi. Cina ɗewo rop ni wu'i da'a, ama wu dǝm dli nǝmwi. ");
INSERT INTO plj_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ra untuwo argon tu Yam gutlumiwo ba dǝ murgon pǝtlka da'a.>> ");
INSERT INTO plj_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Nan wu ra te gip bomi ka eso, ar ni mir mǝn kulci kar Yesu ngen momi gǝs kǝ shirǝm tu. ");
INSERT INTO plj_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ar ni tǝ nǝmi wur tǝ wule, <<Muntu kup kar gǝr gǝs ka kan tǝ gudlumi na gono, tǝ pi zǝna na ci amana kǝ nagǝr gǝs ituwi. ");
INSERT INTO plj_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Untu ni esi, gǝr mǝtli ni za bakos gǝska kan tǝ gudlumi na gono, tǝ pi zǝna na ci amana kǝ kosi ituwi.>> ");
INSERT INTO plj_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Nan mbarǝm den ɗiri heli mimir kǝ dǝ Yesu ne am den wuro, ar ni mir mǝn kulci kar ti matl wuri. ");
INSERT INTO plj_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Nan Yesu shin untuwo, lo ci ti, kan tǝ wul mir mǝn kulci kar tiyi'e, <<Za ni heli mimir wu ɗir karǝmi, kar wur nika da'a. Mulki kǝ Yamo kǝ badǝr mbarǝm ju ni. ");
INSERT INTO plj_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Na ho bi ni a yari ine, murgon tu kup nǝm mulki kǝ Yam tor gip mbatl gǝs wule heli mimir ju dawo, tii taɓe tetǝn gipi da'a.>> ");
INSERT INTO plj_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Kan Yesu ba pǝn mimiri tǝ ne am den wuri, tǝ la'i wur albarka. ");
INSERT INTO plj_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Nan Yesu ba za lasiwo, ar ni mbarǝm gon ɗir na kǝtǝre, tǝ ngus cina da ti, tǝ ngen momi kar ti, tǝ wule, <<Zo mǝn kulci, unun aa pi kan a zam ge mbatl tu nan baa pa da gwawu?>> ");
INSERT INTO plj_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu wul ti'e, <<Unun kem kǝ wulǝm'e zo'i rawe? Zo'i gon ra da'a se Yam nan gǝsi. ");
INSERT INTO plj_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Kǝ mom bar ju ne kǝ dǝ pi gwa, <Ba kǝ ri gon e da'a. Ba kǝ mur na mǝtli kaari da'a. Ba kǝ pi mur da'a. Ba kǝ bi seda kǝ lar da'a. Ba kǝ cuce murgon da'a. Bi nartǝn bǝba gi na nǝna gi.> >> ");
INSERT INTO plj_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ar ni mbarǝmi wul ti'e, <<Ba mǝn kulci, munju kupo ami ra den kopi tun a'i ra nyayi gwa.>> ");
INSERT INTO plj_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu shin ti shintǝn kǝ ndutǝne, kan tǝ wul ti'e, <<Bar nǝm ni kǝ hol katl. Rǝka kǝ ri wur bar ju kan kira nari gwa kup, kǝ bi munju am ri wur kaar da gwa, kii zam bar na naari to yamka. Kan kǝ ɗir kopǝni.>> ");
INSERT INTO plj_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Na kumi shirǝm tuwo, ar ni mbarǝmi li bager ka. Tǝ ndara tǝ den pi dun mbatli, domici tǝ mǝn bar kǝ am ni hoyi. ");
INSERT INTO plj_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ar ni Yesu kar ger den mir mǝn kulci kar ti, tǝ wul wur'e, <<Ar ba ban naari dǝ mǝn bar kǝ am te gip mulki kǝ Yami.>> ");
INSERT INTO plj_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Mir mǝn kulciyi nǝm bi na am den shirǝm tu. Ar ni Yesu pa wul wur'e, <<Mimir gǝni, ar baa ban naar dǝ mbarǝm te gip mulki kǝ Yami! ");
INSERT INTO plj_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ar baa mani dǝ rakumi kop tǝp gip shu alura na dǝ mǝn bar kǝ am te gip mulki kǝ Yami.>> ");
INSERT INTO plj_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Na kumi untuwo ar ni mir mǝn kulci kar Yesu pa nǝm bi na am wu wul ezǝn'e, <<O untuno, kan wo ni baa zam ɗiltǝn ituwi?>> ");
INSERT INTO plj_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ar ni Yesu shin wur kan tǝ wule, <<Kar mbarǝmo ar baa pi da'a, ama ba'e kar Yam da'a. Rawo, ko unu baro mǝn pitǝn ni kar Yami.>> ");
INSERT INTO plj_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Kan Bitǝrus ba wul ti'e, <<Ar tu miwo mǝ za bar kup mǝ kop ki wi.>> ");
INSERT INTO plj_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu wule, <<Ge shirǝm ni a yari ine, muntu kup za bom gǝska, ko erǝm gǝs mǝtli na moni, ko nase, ko base, ko mimir gǝsi, ko kǝn gǝs domici gǝn na kǝ zo shirǝmi, ");
INSERT INTO plj_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","kan baa hol zami gucupi hauya nantam kǝ zhan kǝn kǝ ga bomi, erǝm mǝtli na moni, mǝn gǝri, mimiri, na kǝne, ama na kumi dli esi, kan gip zhan mǝn ɗirtǝno tǝ zam ge mbatl tu kan baa pa dagwa. ");
INSERT INTO plj_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ama na womti gip munju kan te cina kawo, wii pal kǝ kaari, kan kǝ kaaro wii pal kǝ cina.>> ");
INSERT INTO plj_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Wu den totǝn Urushalima ituwi, kan Yesu ra cina, mir mǝn kopi gǝs ngapo wu den kopi gǝsi na nǝmi bi na ame. Munju den kopi gǝs kaar ngapo bǝrti den ci gǝzǝni. Ar ni Yesu dǝl kutl cet ropi markǝme, tǝ pa yari wur argon tu baa zam ti gwa. Tǝ wule, ");
INSERT INTO plj_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","<<Ar tu mǝ to ni Urushalima. Baa bi Nya Mbarǝmka am dǝ ga kiri lǝɓa kǝ Yam na mǝn kulci mbarǝm den kulci kǝ Musa. Wii tloyi ti shirǝm dǝ ri ti eka kan dǝ ta ti am dǝ munju kan mǝn Yahuda ni da gwa. ");
INSERT INTO plj_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Wii yari ti mǝgǝn shirǝmi, wu bǝse ti mo'ǝmi, wu ɓo ti, kan wu ri ti eka. Den kaar kǝ muri myakan ngapo, tii tli ra na ge mbatl lasi.>> ");
INSERT INTO plj_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Gip untuwo ar ni mimir kǝ Zabadi, Yakubu na Yohana, ɗir kar Yesu, wu wul ti'e, <<Ba mǝn kulci, mǝ ndu'e kǝ pi mi argon tu mǝ liri gwa.>> ");
INSERT INTO plj_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ar ni tǝ wul wur'e, <<Ununu kǝ ndu'e a pi inu?>> ");
INSERT INTO plj_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Kan wu nǝmi ti wu wule, <<Mǝ lir ki'e gas tu kii to gip nartǝn kǝ mulki giwo, dǝ nǝm gǝmi dǝm den am shimli gi, nǝm ngapo den am yali gi.>> ");
INSERT INTO plj_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ama Yesu nǝmi wur tǝ wule, <<Kǝ mom argon tu kǝ liri gwa da'a. Kii mani tle gip gal kumi dli tu kan a ri kǝ tle gwaya? Untu ni dama, kii mani dǝ pi in batisma tu kan baa pim gwaya?>> ");
INSERT INTO plj_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ar ni wu nǝmi ti wu wule, <<Aan, mii mani.>> Yesu wul wur'e, <<Aan, kii mani tle gip gal tu kan aa tla gwa, dǝ pi in batisma na batisma tu nan baa pim gwa. ");
INSERT INTO plj_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ama dǝmi den am shimli ko yali gǝno, ami ni na iko kǝ bi da'a. Badǝmi juwo, kǝrkǝmi ni munju ne wur ra gwa.>> ");
INSERT INTO plj_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Nan nami mir mǝn kulci kutl ju kum shirǝm tuwo, ar ni wu nǝm kumi lo kǝ ga Yakubu na Yohana. ");
INSERT INTO plj_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ar ni Yesu la wur bi tǝ wul wur'e, <<Kǝ mom'e, gip munju kan mǝn Yahuda ni da'a, munju mom wur na mulkiwo, wu gode mbarǝm gǝzǝn iko, kiri gǝzǝn ma untuni wu gode mbarǝm gǝzǝn iko. ");
INSERT INTO plj_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ama kǝno untun ar ba dǝm gip dlom gin da'a. Ra untuwo, muntu kup ba ndu tǝ dǝm bari gip kǝno, ar nǝm ti te yarka dǝ tǝ dǝm wule zher gi ni. ");
INSERT INTO plj_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Eso, muntu kup ba ndu tǝ dǝm kǝ cina gip kǝno, ar nǝm ti te yarka tǝ dǝm zher kǝ kup. ");
INSERT INTO plj_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Domici Nya Mbarǝm ma tǝ sur ni dǝ bote ti da'a, ama tǝ pi bota ni, tǝ pa bi ge mbatl gǝs domici ɗǝli mbarǝm na womti.>> ");
INSERT INTO plj_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ar ni wu mbubar Yeriko. Yesu ba ɗǝl gip Yeriko ituwi, nan ti na mir mǝn kulci kar ti, na mbarǝm na womti, se mbarǝm gon tu tabi tǝra njon den bi tǝpe tǝ den liri bari. Sun gǝs'e, Bartimawus nya Timawus. ");
INSERT INTO plj_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nan tǝ kum'e Yesu kǝ Nazarat ni den wucetǝno, ar ni tǝ tli yar yami, tǝ den wultǝn'e, Yesu nya Dauda, kum guna gǝni! ");
INSERT INTO plj_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ar ni mbarǝm na womti mbatl ti wul ti'e tǝ yon shot. Ama tǝ tli yar yam ra hoyi tǝ wule, <<Nya Dauda, kum guna gǝni?>> ");
INSERT INTO plj_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ar ni Yesu dlǝri, kan tǝ wule, <<La'im tǝ ni bi ɗiri.>> Kan wu la bi batabiyi ɗiri, wu wul ti'e, <<Pi ghol mbatli! Tlyami, tǝ den la'i bi gi.>> ");
INSERT INTO plj_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ar ni tǝ la bar kǝ ghumtǝn gǝska, kan tǝ kenja tǝ tlyam tǝ ri kar Yesu. ");
INSERT INTO plj_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu ngen momi kar ti tǝ wule <<Unun kǝ ndu a pi iwe?>> Ar ni batabiyi nǝmi ti tǝ wule, <<Babomi a ndu'e a shin bari.>> ");
INSERT INTO plj_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Kan Yesu ba wul ti'e, <<Ndara, ngǝshtǝn gi den Yam warke iwi.>> Wule gip njǝpkǝr gere ar ni tǝ shin bari, tǝ kop Yesu, kan wu ndara. ");
INSERT INTO plj_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Nan wu mbi kosak na Urshalima, Betapaji na Betanya ituwi, kǝ ba Tlǝndǝr mǝn kin Zaitun, ar ni Yesu kar mir mǝn kulci kar ti rop, ");
INSERT INTO plj_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","tǝ wul wur'e, <<Rǝnǝka gip nye bǝn ta kan cina da in gwa. Na tetǝn gin gipiwo, kii zam nye bar kǝm na ɓali, muntu taɓe totǝn dene wi da gwa. Pǝtl tǝni kǝ ɗiri ni. ");
INSERT INTO plj_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Murgon ni ngen momi kar kǝn den unun kǝ pi untuwo, wul ti ni'e, <Babom ni ba ndu'i, eso, tii pali ɗir kǝkǝn tu.> >> ");
INSERT INTO plj_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ar ni wu ndara, kan wu zam nye bar kǝm den tǝp na ɓali bi bǝdlabǝni. Wu gip pǝtli ituwi, ");
INSERT INTO plj_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","mbarǝm jen ra lasi dlor kan wu wul wur'e, <<Unun kem kǝn den pǝtli nye bar kǝm tuwe?>> ");
INSERT INTO plj_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ar ni wu bali wur kandatu Yesu yari wur gwa, kan mbarǝmi ba za wur wu ndara. ");
INSERT INTO plj_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Nan wu ɗiri Yesu bar kǝmiwo, kan wu la lulur gǝzǝn den nye bar kǝmi, tǝ to dene tǝ dǝmi. ");
INSERT INTO plj_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ar ni mbarǝm na womti la lulur gǝzǝn den tǝpi, jen ngapo wu wotl am kin ɗir gip kǝne. ");
INSERT INTO plj_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Munju kan ra cina na kǝ kaar dati tli yar yam wu wule, <<Hosana! Mǝn albarka ni'e muntu den surtǝn gip sun kǝ Babom gwa.>> ");
INSERT INTO plj_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","<<Albarka ra den mulki mǝn surtǝn kǝ ba gǝmi Dauda! Hosana mǝn nartǝn to yamka!>> ");
INSERT INTO plj_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Nan Yesu te gip Urshalimawo, ar ni tǝ te gip bom kǝ Yam tǝ tli ger tǝ shin ko ako. Ama nan pǝt tare nda bǝno, ar ni tǝ ɗǝl kan tǝ ndara Betani nan ti na mir mǝn kulci kar ti kutl cet rop. ");
INSERT INTO plj_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Bar dlo nan wu za Betaniwo, ar ni Yesu kum guzumi. ");
INSERT INTO plj_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Nan tǝ shin kin turum gon mǝn wol na dlyamiwo, ar ni tǝ ri tǝ shin ko tii zam gǝri dene. Ama nan tǝ mbubaro tǝ shin argon da'a se wol katl, domici wokoci kǝ gǝritǝn kǝ turum ni da'a. ");
INSERT INTO plj_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ar ni tǝ wul kin turumi'e,<<Ba dǝ murgon i'zam nyen kǝ ci den ki da'a.>> Mir mǝn kulci kar ti kum shirǝm tu tǝ yari gwa. ");
INSERT INTO plj_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Nan wu mbubar Urshalimawo, ar ni Yesu te gip bom kǝ Yam tǝ nǝm kari mǝn wuri na wuri barka lasi. Tǝ pa bat tebǝr kǝ mǝn sanje wurpika na badǝmi kǝ mǝn wuri kuɓǝrka ");
INSERT INTO plj_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Tǝ pa hane dǝ murgon kop te gip dǝbom bom kǝ Yami ka. ");
INSERT INTO plj_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ar ni tǝ kulci mbarǝm tǝ wul wur'e, <<Na rǝshi ni ar ra gip shirǝm kǝ Yami den'e, <Baa la bi bom gǝn'e bom shirǝm na Yam kǝ mbarǝm kup.> Ar tu kǝ palika ba <ghuntǝn kǝ ga mur dlǝri den tǝp wi.> >> ");
INSERT INTO plj_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Nan ga kiri lǝɓa kǝ Yami na mǝn kulci mbarǝm den kulci kǝ Musa kum shirǝm tuwo, ar ni wu nǝm ngeni tǝp tu kan wii ri ti eka gwa, domici wu kum bǝrti gǝsi, nan domtǝni kup den nǝmi bi na am den kulci gǝs gwa. ");
INSERT INTO plj_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kǝ sito, ar ni Yesu na mir mǝn kulci kar ti ɗǝlka gip bǝni. ");
INSERT INTO plj_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kǝ cigǝni nan wi den wucetǝno, ar ni wu shin kin turumi kon kawi tor na tlǝrti gǝsi. ");
INSERT INTO plj_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ar ni Bitǝrus dami, kan tǝ wule, <<Ba mǝn kulci, ɓa shini! Turum tu kan kǝ pi ti biwo, ar konka wi!>> ");
INSERT INTO plj_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ar ni Yesu nǝmi ti tǝ wule, <<Ngǝsh kǝn ni den Yami! ");
INSERT INTO plj_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Na ho bi ni a yari ine, mbarǝm ni ngǝsh ti den Yamo, tii mani wuli tlǝndǝr tu'e, <Tus kǝ su nda su gip bar ɓulaka.> Ti ni tǝ cen mbatlka den argon tu tǝ yari dawo, baa pi ti. ");
INSERT INTO plj_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ra untuwo a yari in'e, argon tu kup kǝ liri gip shirǝm gin na Yamo, ngǝsh kǝn ni den Yam den kǝ nǝm wi kan ar baa dǝm gegini. ");
INSERT INTO plj_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Eso, wokoci tu kup kǝ dlǝr kǝ shirǝm na Yamo, gon nǝra kǝ kum lo gǝso, yape tika, kǝ dǝ Ba gin kǝ to yamka ma tǝ yape in warwat pitǝn ginka. ");
INSERT INTO plj_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","(Ama kǝn ni kǝ yape mbarǝm ka dawo, Ba gin kǝ to yamka ba yape in warwat pitǝn gin ka da'a.>>) ");
INSERT INTO plj_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ar ni wu pa pal su Urushalima ka. Yesu den ndǝtltǝn gip bom kǝ Yam ituwi, ar ni ga kiri lǝɓa kǝ Yami, na mǝn kulci mbarǝm den kulci kǝ Musa na kiri mǝn bǝn ɗir kar ti. ");
INSERT INTO plj_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Kan wu wul ti'e, <<Na ikoyi gonge ni kǝ pi bar juwe? Kan wo ni bi i bi kǝ pi bar ju kup we?>> ");
INSERT INTO plj_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ar ni Yesu nǝmi wur tǝ wule, <<Aa ngen momi bar nǝm kar kine, kan kǝ balim ni. Ami eso kan a yari in na bii bi kǝ muntu nan ami den pi bar ju gwa. ");
INSERT INTO plj_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yarim ni, iko pi batisma kǝ Yahanawo sur kar Yam ni ar ɗǝla ko kar mbarǝm ni?>> ");
INSERT INTO plj_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ar ni wu bali gip dlom gǝzǝn kan wu wule, <<Mǝn ni mǝ wule, <Sur yam ni ar ɗǝlo,> tii wul mi'e, <Unun kem kǝ ngǝsh kǝn den ti dawu?> ");
INSERT INTO plj_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ama mǝn ni mǝ wule, <Kar mbarǝm no,> >> (wu kum ni bǝrti kǝ argon tu mbarǝm baa pi wur gwa, domici mbarǝm kup pǝn den Yohanawo mǝn yari shirǝm kǝ Yam ni.) ");
INSERT INTO plj_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ar ni wu bali Yesu, wu wule, <<Mǝ mom da'a.>> Kan Yesu ba wul wur'e, <<Ami ma aa yari in wo ni bim bi kǝ pi untu da'a.>> ");
INSERT INTO plj_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ar ni Yesu pare yari wur shirǝm gip kolɗa bi tǝ wule, <<Mbarǝm gon pi kǝn inabi, tǝ gandǝli ka na panye, tǝ bor shu ba zho'i mal inabiyi, tǝ pa tu bom kǝ mǝn ne ger den kǝni. Kan tǝ bi mǝn kori bar jen haya kǝ kǝni, kan tǝ ndara atli goni. ");
INSERT INTO plj_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Nan wokoci rǝshi kǝn inabiyi piwo, ar ni tǝ kar zher gǝs gon rǝnka kar munju kan nǝm haya kǝ kǝni gwa, kǝ dǝ tǝ nǝmi ti gǝri kin inabi jen kǝ kǝni. ");
INSERT INTO plj_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ama munju nǝm haya kǝni nǝm ti kan wu ɓo ti, wu kar tika am koni. ");
INSERT INTO plj_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ar ni tǝ pa kar zheri gon rǝnka. Kan wu pa ɓo zher tu den gami, wu bi ti shame. ");
INSERT INTO plj_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Tǝ pa kar gon rǝnka esi, muntuwo ar ni mǝn kori bari ri ti eka. Kan tǝ pa kar jen rǝnka na womti. Ama mǝn kori bari ɓo jeni, wu ri jen eka. ");
INSERT INTO plj_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Tǝ'i ra na mbarǝm nǝm, nya tu tǝ ndu gwa. Den kaariwo, ar ni tǝ kar nyayi rǝnka kar wuri, tǝ wule, <Rawo, wii shin nartǝn kǝ nya gǝni.> ");
INSERT INTO plj_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ama mǝn nǝmi haya kǝ kǝni wul ezǝn'e, <Nye mǝn ci gado kǝ kǝnin ta. Ɗir ni mǝ ri tǝni eka, kǝ dǝ gadoyi dǝm gwagǝmi ra.> ");
INSERT INTO plj_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ar ni wu nǝm ti, wu ri ti eka, wu byal tika kaar kǝni.>> ");
INSERT INTO plj_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ar ni Yesu wul wur'e, <<Ununu ba mǝn kǝn tu baa pi we? Tii ɗir tǝ ri mǝn haya ju eka, tǝ bi jen kǝnika. ");
INSERT INTO plj_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","O fawo, kǝ zhit ni shirǝm kǝn gip Shirǝm kǝ Yam diya? Domici ar ra na rǝshi'e, <Tat tu kan mǝn tu'i bin ngewo, ar pal bar ho tat gip tatiwi kup. ");
INSERT INTO plj_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Muntuwo pi kǝ Babom ni, bar kǝ dlǝkǝntǝn ni den ger gǝmi.> >> ");
INSERT INTO plj_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ar ni ga kiri lǝɓa kǝ Yami, na ga mǝn kulci mbarǝm den kulci kǝ Musa, na kiri kǝ mǝn Yahuda ngen tǝp kǝ nǝmi gǝsi, domici wu mom ka'e den wur ni tǝ bi kolɗa bi tu. Ama wu kum bǝrti kǝ womti mbarǝme. Ar ni wu za ti kan wu ndara. ");
INSERT INTO plj_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Gip untuwo, ar ni kar jen gip mǝn Parise na mbarǝm kǝ Hiridus kar Yesu kǝ dǝ wu zam wu nǝm ti ra gip shirǝm gǝsi. ");
INSERT INTO plj_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Nan wu ɗiro, ar ni wu wul ti'e, <<Ba mǝn kulci, mǝ mom'e ki mǝn yari shirǝm kor ni. Kǝ pǝn mbarǝm kup nǝm ni kar ki, kǝ pǝn'e gon ra kan man gon gwa da'a. Eso, kǝ kulci mbarǝm ge shirǝm kǝ Yami. Gip shini giwo ar ndari mǝ ɓatl wurpi bom dǝ gun Kaisara, ko ar ndari da'a? ");
INSERT INTO plj_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Mǝ ɓatla ko ba mǝ ɓatl da'a?>> Ama Yesu mom ɗasi tu gǝzǝnka, ar ni tǝ wul wur'e, <<Unun kem kǝ ndu'e kǝ borim shuwe? Ɗirim ni kabarshu a shini.>> ");
INSERT INTO plj_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ar ni wu ɗiri ti, kan tǝ wul wur'e, <<Shishidǝr na sun kǝ wo ni dene we?>> Kan wu wul ti'e <<Kǝ Kaisar ni.>> ");
INSERT INTO plj_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ar ni Yesu wul wur'e, <<Ra untuwo, bi ni Kaisar bar tu kan kǝ Kaisar ni gwa. Kan kǝ pa bi ni Yam bar tu kan kǝ Yam ni gwa.>> Ar ni shirǝm gǝs dlǝkǝn wur hoyi. ");
INSERT INTO plj_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Mǝn Sadukiya jen kan ba wule tlitǝnka gip mǝshi mbarǝm ra da'a ɗir kǝ ngeni momi kar Yesu, wu wule, ");
INSERT INTO plj_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","<<Ba mǝn kulci, Musa rǝshi mi den erǝm kǝ mbarǝm ni mǝshka tǝ za gǝr kaar na mimir dawo, ar nǝm erim gǝs te yarka tǝ gudlumi na gǝri, tǝ zami erim gǝs mimiri. ");
INSERT INTO plj_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ar tu erim mbarǝm jen ra wu moni nyingi. Kǝ nǝmi gudlumi, tǝ mǝshka tǝ za nya da'a. ");
INSERT INTO plj_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Kǝ ropi ba pa gudlumi na guriyi, ti ma tǝ mǝshka tǝ za nya da'a. Kǝ myakani ma untu. ");
INSERT INTO plj_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Untu ni kup gǝzǝn nyingi ju, gon ra kan zam gǝri nan ti gwa da'a. Den kaariwo kan nagǝri ba mǝshka. ");
INSERT INTO plj_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","To, gas tlitǝn kǝ mǝshi mbarǝmo, gip wuro gǝr kǝ wo ni tii dǝm we nan kup gǝzǝn nyingiyi gudlumi nan ti gwa?>> ");
INSERT INTO plj_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ar ni Yesu nǝmi wur tǝ wule, <<Damtǝn gino kor ni ar ra da'a, domici kǝ mom rǝshi shirǝm kǝ Yam na ndǝrtǝn kǝ Yam da'a. ");
INSERT INTO plj_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Wokoci tlitǝn kǝ mǝshi mbarǝmo, moni ba gudlumi da'a, baa ri mǝtli gip kupshi da'a, ama wii dǝm ni wule mir mǝn kartǝn kǝ Yam kan to yam ka gwa. ");
INSERT INTO plj_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Den shirǝm kǝ tlitǝn kǝ mǝshi mbarǝmo, kǝ taɓe ni zhiti gip tǝlankur kǝ Musa diya, den shirǝm kǝ utu mǝn ci gip lǝpe, kandatu Yam wul ti'e <Ami ni'e Yam kǝ Ibǝrahim, na kǝ Ishaku, na kǝ Yakubu?> ");
INSERT INTO plj_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Tiwo Yam kǝ mǝshi mbarǝm ni da'a, ama kǝ mǝn ge mbatl ni. Kǝ jilka naar wi.>> ");
INSERT INTO plj_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Nǝm gip mǝn kulci mbarǝm den kulci kǝ Musa ɗir tǝ kum wur den bali gip dlom gǝzǝni. Nan tǝ kum Yesu bali wur koro, ar ni tǝ ngen momi kar Yesu tǝ wule, <<Dokayi gonge ni mani naartǝn we?>> ");
INSERT INTO plj_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu bali ti tǝ wule, <<Muntu mani nartǝn gwa ni'e, <Ɓa kum ni mbarǝm kǝ Isra'ila. Babom Yam gǝmiwo, Babom nǝm ni. ");
INSERT INTO plj_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Se kǝ ndu Banbom Yam gi na mbatl gi kup, na ge mbatl gi kup, na damtǝn gi kup, na ndǝrtǝn kǝ bigul gi kup.> ");
INSERT INTO plj_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Kǝ ropiwo ar ni'e, <Kǝ ndu berǝm dǝmi gi wule gam gi.> Doka gon ra kan man munju naartǝn gwa da'a.>> ");
INSERT INTO plj_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ar ni mbarǝmi wul Yesu'e, <<Ba mǝn kulci kǝ yari dlat, Yamo nǝm ni, gon ra'i da'a se ti. ");
INSERT INTO plj_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Dǝ ndu ti na mbatl kup, na damtǝn kup na ndǝrtǝn kǝ bigul kup, kan kǝ pa ndu berǝm dǝmi gi wule gam gi. Rawo, muntu ni man kup keri bar na mboshi Yam dabba gip bota.>> ");
INSERT INTO plj_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nan Yesu kum mbarǝmi bali ti na bobyawo, ar ni tǝ wul ti'e, <<Kǝ dlamka na mulki kǝ Yam da'a.>> Den kaar kǝ muntuwo gon ra kan i'zam bigul kǝ ngeni momi kaar ti den bar gon gwa da'a. ");
INSERT INTO plj_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Nan Yesu den kulci mbarǝm te gip dǝbom bom kǝ Yam kawo ar ni tǝ ngen momi tǝ wule, <<Imnu mǝn kulci mbarǝm den kulci kǝ Musa ba wule, Almasihuwo nya Dauda niwe? ");
INSERT INTO plj_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dauda na gam gǝs, tǝp kǝ ba ndǝrtǝn kǝ Ruhu kǝ Yam wule, <Babom wul Babom gǝn'e, <<Dǝm den am shimli gǝni, se amin a pali mǝn nge gi atli na ba ne asǝm gi.>> > ");
INSERT INTO plj_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dauda na gam gǝs la bi Almasihu'e, <Babomi.> Kan imnu fa ti pa dǝm nya Dauda we?>> Womti mbarǝmi kum tǝmi kǝ shirǝm gǝsi. ");
INSERT INTO plj_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Gip kulci gǝso, ar ni Yesu wule, <<Neni ger den mǝn kulci mbarǝm den kulci kǝ Musa, wu ndu la'i kiri luluri wu den ndǝtltǝni, wu ndu dǝ shirmi wur kǝ ba bar pǝte. ");
INSERT INTO plj_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Wu paye ndu'i dǝ bi wur ho badǝmi gip bom domtǝn kǝ mǝn Yahuda, na ho badǝmi kǝ ba nyele. ");
INSERT INTO plj_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Wi ni'e mǝn ci bar kǝ mǝtli ju kan kos gǝzǝn mǝshka gwa. Kan wu tlyari shirǝm gǝzǝn na Yam, kǝ dǝ shin wur ra. Wii ni ngap baa hukunte wur hoyi.>> ");
INSERT INTO plj_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu ra njon gip bom kǝ Yam las tu ba dom wurpi tu ɗiri Yami, tǝ den shini kandatu kan mbarǝm ba la wurpi su gip ba la'i wurpiyi ka gwa. Munju am ri wur kar gwa den la'i wurpi mǝn nartǝni. ");
INSERT INTO plj_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ar ni guri gon muntu kan am ri ti kaar da gwa wi mir kabarshu rop su kǝ ba wurpiyika. ");
INSERT INTO plj_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ar ni Yesu la bi mir mǝn kulci kar ti, tǝ wul wur'e, <<Na ho bi ni a yari ine, argon tu nagǝr guri kǝn kan am ri ti kaar da'a biwo, ar man kǝ nami mbarǝm kup. ");
INSERT INTO plj_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Domici kup gǝzǝn bi ni gip womti bar ju wu ra nari gwa, ama tǝ ngapo gip holi bar kǝ am gǝs ni tǝ bi bar kup kan ne tǝra gwa.>> ");
INSERT INTO plj_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu ba ɗǝl ter gip bom kǝ Yami ituwi, ar ni nǝm gip mǝn kulci kar ti wul ti'e, <<Ba mǝn kulci, ɓa shin kiri tat ju! Ɓa shin bar kǝ nǝmi bi na am den tu'i bin ju!>> ");
INSERT INTO plj_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ar ni Yesu wul ti'e, <<Kǝ shin kiri tu'i bin ju ya? Baa yasika kup. Tat gon ra nǝm kan baa za den gon gwa da'a.>> ");
INSERT INTO plj_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Nan Yesu ra njon den tlǝndǝr mǝn kin Zaitun kan ba shin bom kǝ Yam suka gwa, ar ni Bitǝrus, na Yakubu, na Yohana, na Andǝrawus ngen momi kar ti mol, wu wule, ");
INSERT INTO plj_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","<<Yari mi, gigasi ni bar ju baa pi we? Kan unu halama ni baa gode'e bar ju baa pi rawu?>> ");
INSERT INTO plj_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ar ni Yesu wul wur'e, neni gere, ba dǝ murgon jili in nika da'a. ");
INSERT INTO plj_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Mbarǝm na womti baa ɗir gip sun gǝni, wu wule wi ni'e ami, kan wu jili mbarǝm ka na womti. ");
INSERT INTO plj_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Kǝn ni kǝ kum den dlan na shirǝm kǝ dlanwo, ba ar tli in ni mbatl da'a. Ar nǝm dǝ bar ju pi, ama patǝn kǝ bar kup mbirawi da'a. ");
INSERT INTO plj_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Atl baa tli atl gami, kan dǝ mulki tli mulki gami. Atl baa jirkǝt ti kǝ ba lasi na womti, baa pi guzum esi. Ama munju kup ni'e kumi dliyi da'a. Pare kumi dli ni katl. ");
INSERT INTO plj_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ngup kǝn ni, domici wii ri in bom tloyi shirǝmi, dǝ ɓo in gip bom domtǝn kǝ mǝn Yahuda. Baa ri in cina dǝ kiri kǝ bǝni na ga gunye domici kǝ sun gǝni, kǝ dǝ kǝ yari ni zo shirǝmi cina da wuri. ");
INSERT INTO plj_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ama ar nǝm dǝ yari zo shirǝmi gip atl kundǝrǝndlip kan dǝ patǝn kǝ bar kup ɗiri. ");
INSERT INTO plj_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Wokoci tu kup wu nǝm kǝn kan wu ri in bom tloyi shirǝmo, ba kǝ dam kǝn ni den argon tu nan kii yari gwa da'a. Yari ni argon tu kup ɗiri in gip mbatl gip wokociyi gwa, domici kǝn ni kǝ shirǝm da'a, Ruhu kǝ Yam ni. ");
INSERT INTO plj_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Erim baa la'i gǝs yam erim gǝs kǝ dǝ ri ti eka, bǝba baa bi nya gǝska. Mimir baa tli ga mǝn gǝri gǝzǝn gami kǝ dǝ ri wur eka. ");
INSERT INTO plj_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Mbarǝm kup baa nge in domici kǝ sun gǝni. Ama muntu kup ɓa mbatl dlom gam ar ri patǝn kǝ baro, tii zam ɗǝltǝne. ");
INSERT INTO plj_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Kǝn ni kǝ shin bar kǝ tli mbatl mǝn ɗiri mǝshtǝn dlor kǝ ba las tu ar ndari dǝ shin ti dawo, na dǝ mǝn zhiti tulankuri momi. Ra untuwo, munju kan ra gip Yahudawo, wu kǝtǝr wu to gǝzǝn gip tlǝndǝre. ");
INSERT INTO plj_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ba dǝ muntu nan to den gam kushi ka ɗǝl sur tǝ te gip bom kǝ pǝni argon da'a. ");
INSERT INTO plj_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Muntu ri gip kǝnka ngapo, ba tǝ pal ɗir kǝ pǝni bar kǝ ghumtǝn da'a. ");
INSERT INTO plj_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kashto kǝ mǝtli mǝn tu'e na mǝn bi mimir nyin gip wokoci tu! ");
INSERT INTO plj_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Shirǝm ni na Yami, ba dǝ kǝtǝr gin ɗir gip watlǝn da'a. ");
INSERT INTO plj_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Domici wokoci tawo baa kum dli kan taɓe kumi dagwa tun ne gǝs kǝ pi atl kundǝrǝndlip kan Yam pi gwa ar ri kǝkǝni. Baa'i pi wule muntu da'a. ");
INSERT INTO plj_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Dǝ wule Yam ca ni muri juka dawo, na nya mbarǝm gon ra kan baa zam ɗǝltǝn gwa da'a. Ama domici kǝ kumi guna kǝ munju tǝ zǝzariwo, ar ni tǝ ca muriyika. ");
INSERT INTO plj_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Gip wokoci tawo, muntu kup wul kǝn'e <<Shin ni, Almasihun kǝni!>> Ko <<Shin ni, tin ta!>> Ba kǝ nǝm ni da'a. ");
INSERT INTO plj_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ga Almasihu kǝ lar na mǝn lar yari shirǝm kǝ Yam baa cwati. Wii gode halama na pi bar kǝ dlǝkǝntǝn kǝ dǝ wu jili mbarǝmka, ar ni baa piwo, har na munju zǝzar wur gwa. ");
INSERT INTO plj_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ra untuwo, dǝm ni gǝɗǝn! A yari in bar kup wi kapǝn ar pi. ");
INSERT INTO plj_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ama den kaar kǝ kumi dli gip muri jawo, <<Pǝt baa palka dǝmǝni. Kyar es ba'i cir da'a. ");
INSERT INTO plj_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ga zǝnges baa pi ta ndetǝn sur yami. Baa jirkǝt bar ju kan ra to yamka gwa.>> ");
INSERT INTO plj_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Wokoci ta ni baa shin Nya Mbarǝm den surtǝn gip dun yami, na bar ndǝrtǝni na ɗǝɗatǝne. ");
INSERT INTO plj_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ar ni tii kar mir mǝn kartǝn kǝ Yam suri, wu dom munju tǝ zǝzari gwa gip atl kundǝrǝndlip. ");
INSERT INTO plj_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Kulci ni den kin turume. Wokoci tu kǝ shin am kini ba pika shendǝle ar pare bǝdlitǝno, kǝ mom ni'e watlǝn mbira kosak ituwi. ");
INSERT INTO plj_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Untu ni esi, kǝn ni kǝ shin bar ju den pitǝno, ar mbira kosak bi bǝdlabǝn wi. ");
INSERT INTO plj_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Na ho bi ni a yari ine mbarǝm kǝ zhan kǝn baa mǝsh da'a, se bar ju ni kup pi wi gwa. ");
INSERT INTO plj_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Dlom yam na atl baa paka, ama shirǝm gǝn baa pa da'a ko njem. ");
INSERT INTO plj_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ama murgon ra mom pǝti ko awa tu kan ar ba pi gwa da'a, ko mir mǝn kartǝn kǝ Yam kan to yamka gwa, ko Nyayi, se bǝbayi nan gǝsi. ");
INSERT INTO plj_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Dǝm ni gǝɗǝn, kǝ neni gere, domici kǝ mom wokoci tu ar baa ɗir gwa da'a. ");
INSERT INTO plj_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ar ni wule mbarǝm kan ba ri kǝ ɓomi asǝm gwa. Ti ni tǝ ndarawo, tii za bomi am dǝ ga zher gǝsi, ko gonge gǝzǝn na mbap tu kan tii pi gwa. Kan tǝ wul mǝn ɓuti bǝdlabǝni'e tǝ dǝm gǝɗǝn. ");
INSERT INTO plj_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","<<Ra untuwo, dǝm ni gǝɗǝn, domici kǝ mom wokoci tu babomi baa pal gwa da'a. Tii mani paltǝn kǝ siti, ko gip dlom gasi, ko wokoci la'i yar kǝ tus kori, ko kǝ bi cigǝni. ");
INSERT INTO plj_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ba dǝ tǝ cwat curut bat na momi kan tǝ zam kǝn den umur da'a. ");
INSERT INTO plj_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Argon tu a yari ino, ar ni a yari mbarǝm kup'e, dǝm ni gǝɗǝn!>> ");
INSERT INTO plj_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Nan ar sa muri rop kǝ dǝ pi nyel jikat bǝdlabǝn na nyel kǝ burodi tu kan na yisti da gwawo, ar ni ga kiri lǝɓa kǝ Yam na mǝn kulci mbarǝm den kulci kǝ Musa ngen tǝp tu wii nǝm Yesu mol wu ri ti eka gwa. ");
INSERT INTO plj_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ama wu wule, <<Ba'e wokoci kǝ nyel da'a bǝse dǝ mbarǝm tli bǝn gami.>> ");
INSERT INTO plj_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Nan Yesu ra bǝn kǝ Betani, bom dǝ mbarǝm gon kan ba wul ti'e Simon ba mǝn ndǝcci, tǝ den ci fingal ituwi, ar ni gǝr mǝtli gon ɗir na mbunlet kǝ tulare tu nan pi na tat onis gwa, laa'i na tulare mǝn bar wurpi mǝn tǝmi kasǝri. Kan tǝ ɓul mbumleti ka tǝ shoti Yesu mir sur gami. ");
INSERT INTO plj_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ama munju ra lasi gwa kum lo'e kan wu wul ezin'e, <<Imnu li mir tuka untuwe? ");
INSERT INTO plj_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ar baa mani dǝ wurka, dǝ zam wurpi mǝn nartǝn kan baa mbu ɓatli mǝn pi mbap kǝ nde pǝt hauya kutl cet nantam (300) gwa dǝ bi munju nan am ri wur kaar da gwa,>> ar ni wu matl ti hoyi. ");
INSERT INTO plj_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ama Yesu wul wur'e, <<Za tǝni, kǝ ghuntǝni kǝ unu? Ho bar ni tǝ nem den pi. ");
INSERT INTO plj_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ko gigasi kii nǝra na munju am ri wur kaar da gwa. Kii ne wur am ra kup wokoci tu kǝ ndu gwa, ama aa nǝra nan kǝn ko gigasi da'a. ");
INSERT INTO plj_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Tǝ pini argon tu tii mani pi gwa. Tǝ bǝrke ni dli gǝnka na mir den bi kapi gǝni. ");
INSERT INTO plj_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Na ho bi ni a yari ine, las tu kup baa pi la'i icin kǝ zo shirǝm tu gip atl kundǝrǝndlipo, baa pi ta yari argon tu nagǝr tu pi gwa kǝ dǝ dam ti.>> ");
INSERT INTO plj_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Gip untuwo ar ni Yahuda Iskariyoti, nǝm gip kutl cet ropi, ri kar ga kiri lǝɓa kǝ Yam kǝ dǝ tǝ bi Yesuka am da wuri. ");
INSERT INTO plj_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Nan wu kum untuwo, wu pi ghol mbatl naari. Kan wu wule wii bi ti wurpi. Ar ni Yahuda pi ta ngeni tǝp tu kan tii bi Yesu kagwa. ");
INSERT INTO plj_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Den pǝt kǝ nǝm kǝ nyel kǝ bǝredi kan na yisti dagwa, den pǝt tu kan ba nbosh nye bagala kǝ nyel jikat bǝdlabǝn gwa. Ar ni mir mǝn kulci kar Yesu ngen momi kar ti wu wule, <<Ako ni kǝ ndu'e mǝ kǝrkǝmi i fingal jikat bǝdlabǝni?>> ");
INSERT INTO plj_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ar ni tǝ kar mir mǝn kulci kar ti rop, tǝ wul wur'e, <<Te ni gip bǝni, kii zam mbarǝm gon na tat mal gami, kop tǝ ni. ");
INSERT INTO plj_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Bom tu kup tǝ te gipiwo, wul ni babomi'e, <Ba mǝn kulci ba ndu tǝ mom kupshi tu nan tii ci nyel jikat bǝdlabǝn na mir mǝn kulci kar ti gwa.> ");
INSERT INTO plj_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Tii ta'i in am den ɓiti bar kupshi gon kǝ to yami ka mun tu nan kǝrkǝmi kǝ ci nyeli gwa. Lasi ni kii kǝrkǝmi mi fingali.>> ");
INSERT INTO plj_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ar ni mir mǝn kulci kar tiyi tlyam, wu te gip bǝni, wu zam kandatu kan Yesu yari wur gwa. Kan wu kǝrkǝm fingal nyel jikat bǝdlabǝni. ");
INSERT INTO plj_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nan sit piwo, ar ni Yesu na mir mǝn kulci kar ti kutl cet ropi ɗir bomi. ");
INSERT INTO plj_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Wi gip ci fingali ituwi, ar ni Yesu wule, <<Na ho bi ni a yari ine, nǝm gip kǝn ba ri kǝ bi gǝnka, ti ni'e muntu den ci fingal namǝn gwa.>> ");
INSERT INTO plj_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ar ni dun mbatl nǝm mir mǝn kulci kar tiyi, kan wu nǝm wuli gǝs nǝm na nǝm'e, <<Ami ni da'a ko?>> ");
INSERT INTO plj_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu nǝmi wur tǝ wule, <<Nǝm gip kutl cet rop ju ni, muntu den si am gip gal nǝm namǝn gwa. ");
INSERT INTO plj_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Nya mbarǝm baa mǝshi kandatu kan ar ra na rǝshi den ti gwa. Ama kashto kǝ muntu nan ba bi Nya mbarǝm kagwa! Ar baa mani mbarǝmi na gǝr tǝni dama.>> ");
INSERT INTO plj_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Wu gip ci fingali ituwi, ar ni Yesu pǝn bǝredi, tǝ gode Yami, tǝ njetǝli, tǝ bi mir mǝn kulci kar ti, tǝ wule, <<Ar tu, nǝm ni. Muntuwo dli gǝn ni.>> ");
INSERT INTO plj_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ar ni tǝ pǝn wuro mal inabiyi tǝ goode Yami, tǝ bi wuri. Kan kup gǝzǝn ba tla gipi. ");
INSERT INTO plj_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Kan tǝ wul wur'e, <<Muntuwo bǝran gǝn ni. Bǝran kǝ laa'i gudlum shǝrimi. Baa shoti ka den bi mbarǝm na womti. ");
INSERT INTO plj_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Na ho bi ni a yari ine, aa'i tla mal gǝri kin inabi kǝn da'a, se gas tu aa tla peli gip mulki kǝ Yam gwa.>> ");
INSERT INTO plj_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nan wu wuli kono, ar ni wu ɗǝli kan wu to gǝzǝn den tlǝndǝr mǝn kin Zaitun. ");
INSERT INTO plj_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu wul mir mǝn kulci kar ti'e, <<Kii kǝtǝr gin kup kǝ za'ǝmi, kandatu nan ar ra na rǝshi gwa'e, <Aa ɓo mǝn le tǝmi,> <Tǝmi ngapo wii gǝzanka.> ");
INSERT INTO plj_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ama den kaar kǝ tlitǝn gǝn gip mǝshtǝno, aa mbubar cina da in su Galili ka.>> ");
INSERT INTO plj_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ar ni Bitǝrus wul ti'e, <<Dǝ wule kup gǝzǝn baa kǝtǝr wu za ki kawo, amo a za ki ka da'a.>> ");
INSERT INTO plj_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu nǝmi ti tǝ wule, <<Na ho bi ni a yari i, sekǝn gip gas kǝni, kapǝn dǝ tuskor la yar kǝ bisi ropo kii wule kǝ momǝn da'a biyi myakan.>> ");
INSERT INTO plj_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ama Bitǝrus pi ta yari na bar yar tǝ den wultǝn'e, <<Dǝ wule baa rim ni eka nan kiwo, aa nge momi gi ka da'a.>> Kan nami mir mǝn kulci kar tiyi ma wu yari untu. ");
INSERT INTO plj_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Wu ri las gon kan ba la ti bi'e Getsemani gwa, ar ni Yesu wul mir mǝn kulci kar tiyi'e, <<Dǝm ni ɗe a ri shirǝm na Yami.>> ");
INSERT INTO plj_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ar ni tǝ pǝn ga Bitǝrus, na Yakubu na Yohana nan ti. Ar ni tǝ nǝm pi dun mbatl na damtǝn na naari. ");
INSERT INTO plj_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Tǝ wul wur'e, <<Dun mbatl tu kan ra gipǝno ar ba mani ri gǝn eka. Dǝm ni ɗe, kǝ neni gere.>> ");
INSERT INTO plj_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Nan tǝ te cina njemo, ar ni tǝ nda atli, tǝ shirǝm na Yam tǝ wule, ar ni baa piwo, dǝ pǝni ti wokoci kǝ kumi dli tu ka. ");
INSERT INTO plj_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Tǝ wule, <<Abba Bǝba, bar kup mǝn pitǝn ni kar ki. Pǝnim wuro mal kumi dli kǝn ka ngapi. Kup na untu, pi argon tu kǝ ndu gwa, ba'e argon tu nan a ndu gwa da'a.>> ");
INSERT INTO plj_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Den kaar kǝ untuwo, ar ni tǝ pal ɗir kar mir mǝn kulci kar tiyi myakan kan tǝ zam wur den nde umuri. Ar ni tǝ wul Bitǝrus'e, <<Siman, umur ni kǝ den nde ya? Ase kii mani ne ger ko kǝ awa nǝm da'a ya? ");
INSERT INTO plj_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ne ni gere kǝ shirǝm ni na Yami, bǝse kǝ nda nika gip godetǝne. Ar tu ruhu nǝm wi ama dliwo ndǝri ni da'a.>> ");
INSERT INTO plj_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ar ni tǝ pa pal rǝnka, tǝ shirǝm na Yam wule kǝ hari. ");
INSERT INTO plj_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Nan tǝ pal ɗiro, ar ni tǝ pa zam wur den nde umuri, domici ger gǝzǝn raka laa'i na umuri. Wu hol ar gon tu nan wii yari ti gwa. ");
INSERT INTO plj_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ar ni tǝ pa pal ɗir kǝ bisi myakani tǝ wul wur'e, <<Kǝkǝn ma umur ni kǝn den nde na shukutǝna? Ar pi wi! Wokoci pi wi nan baa bi Nya mbarǝmka am dǝ mǝn warwat pitǝne. ");
INSERT INTO plj_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Tli ni yam mǝ ndanira! Mǝn bi gǝn tu mbira wi!>> ");
INSERT INTO plj_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu den shirǝm ituwi, ar ni Yahuda cwati, nǝm gip mir mǝn kulci kar ti kutl cet rop ju. Tǝ ɗir na mbarǝm na womti kan ra na kiri sǝɓǝri na dlo am da wuri. Ga kiri lǝɓa kǝ Yami, na mǝn kulci mbarǝm den kulci kǝ Musa, na kiri kǝ bǝn ni kar wur ɗiri. ");
INSERT INTO plj_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yahuda tare bi wur halama wi'e, <<Muntu a pi ti sumbawo, ti ni'e mbarǝmi. Nǝm tǝni kǝ ndanira nan ti. Kan kǝ ne ni ger den ti hoyi.>> ");
INSERT INTO plj_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Na ɗirtǝn gǝs kar Yesuwo, ar ni Yahuda wul ti'e,<<Ba mǝn kulci!>> Kan tǝ pi ti sumba. ");
INSERT INTO plj_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ar ni mbarǝmi dǝl Yesu teri, kan wu nǝm ti. ");
INSERT INTO plj_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Kano nǝm gip mir mǝn kulci kar Yesu kan ra dlor kosak nan ti ba tus bar sǝɓǝr gǝs tǝ wotl kǝm kǝ zher kǝ bar lǝɓa kǝ Yam nari. ");
INSERT INTO plj_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesu wul wur'e, <<Kǝ ɗǝl ɗir na sǝɓǝr na dlo kǝ nǝmi gǝn wule mǝn tli bǝn mbatl gona? ");
INSERT INTO plj_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ko gigasi ami ra nan kǝn gip bom kǝ Yam ami den kulci mbarǝme ama kǝ nǝmǝn da'a. Ar pini untu kǝ dǝ laa'i rǝshi shirǝm kǝ Yami.>> ");
INSERT INTO plj_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Bar tuwo ar ni mir mǝn kulci kar tiyi kup kǝtǝr gǝzǝn wu za ti. ");
INSERT INTO plj_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Nye moni gon ra kop Yesu kaar nye pǝrsi nye pǝrsiyi, tǝra na lulur da'a, se bar kǝ ghumtǝn gǝs katl. Nan wu ndu'e wu nǝm tiwo, ");
INSERT INTO plj_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ar ni tǝ za bar kǝ ghumtǝni am da wuri tǝ kǝtǝr tǝ ndara gǝs koni. ");
INSERT INTO plj_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ar ni wu ndara na Yesu kar bar mǝn keri bar ju ɗiri Yami, na ga kiri lǝɓa kǝ Yami, na kiri kǝ bǝni, na mǝn kulci mbarǝm den kulci kǝ Musa ba dom wur kup lasi. ");
INSERT INTO plj_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Bitǝrus kop Yesu nye pǝrsi nye pǝrsiyi. Tǝ kop ti tǝ te gip dǝbom bom kǝ bar mǝn keri bar ju ɗiri Yam gwa. Lasi ni tǝ dǝm na mǝn ne ger den bomi, tǝ den kumi utu. ");
INSERT INTO plj_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ga kiri lǝɓa kǝ Yam na nami mǝn domtǝn kǝ mǝn ne ger den shirǝm pi ta ngeni argon tu wii yari den ti'e tǝ nda kawi kǝ dǝ wu ri ti e ra gwa, ama wu zam da'a. ");
INSERT INTO plj_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Mbarǝm na womti bi seda kǝ lar den ti, ama bǝ gǝzǝn nda nǝm da'a. ");
INSERT INTO plj_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Den kaariwo ar ni jen tlyam dlor, wu bi seda kǝ lar kǝn den Yesu, wu wule, ");
INSERT INTO plj_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","<<Mǝ kum tǝ wule tii yas bom kǝ Yam kǝn kan mbarǝm tu gwa, tǝ tu gon gip muri myakan, muntu kan mbarǝm ni tu da gwa.>> ");
INSERT INTO plj_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Kup na untu seda kǝ bi gǝzǝn nda nǝm da'a. ");
INSERT INTO plj_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ar ni bar lǝɓa kǝ Yam tli yam tǝ dlǝr gip dlom gǝzǝn, tǝ ngen momi kar Yesu, tǝ wule, <<Ki ra na shirǝm tu nan ki bali gwa diya? Im ni na seda tu nan wi den bi den ki gwa?>> ");
INSERT INTO plj_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ama Yesu sa gǝs shot, tǝ bali ti na argon da'a, Bar lǝɓa kǝ Yami pa ngen momi kar ti tǝ wule, <<Ko ki ni'e Almasihu Nya Mǝn Albarka tu?>> ");
INSERT INTO plj_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ar ni Yesu bali ti tǝ wule, <<Ami ni. Eso kii shin Nya Mbarǝm njon den am shimli kǝ Mǝn Nartǝni, ti den surtǝn gip dun yami.>> ");
INSERT INTO plj_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ar ni bar lǝɓayi kǝ Yami tlyat lulur gǝska, tǝ wule, <<Unu seda ni mǝ pa ngen esi? ");
INSERT INTO plj_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ar tu kǝ kum mǝgǝn shirǝm tu tǝ yari den Yam gwa wi! Unun kǝ shini?>> Ar ni mbarǝmi kup wule ar ndari dǝ ri ti eka. ");
INSERT INTO plj_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ar ni jen bǝse ti mo'ǝmi, kan wu ɓali ti ba ger ka, wu pa la'i ti ankayama, wu wul ti'e, <<Yari mi, wo ni ɓo iwe!>> Mǝn ne ger den bomi ma ar ni wu pi ta ɓe gǝsi. ");
INSERT INTO plj_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Nan Bitǝrus ra sur gǝsi gip dǝbom bomiwo, ar ni nye gǝr gon gip mir mǝn pii mbap bar lǝɓa kǝ Yami ɗir lasi. ");
INSERT INTO plj_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Nan tǝ ti shin Bitǝrus den kumi utuwo, ar ni tǝ shin ti ndin, kan tǝ wul ti'e, <<Ki ma na Yesu kǝ Nazarat tu ni ki ra!>> ");
INSERT INTO plj_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ama Bitǝrus nge gǝs tǝ wule, <<A mom argon tu kǝ shirǝm dene gwa da'a. Amo a mom da'a!>> Nan tǝ yari untuwo, ar ni tǝ tlyam tǝ te gǝs gip dlabǝn bomi. ");
INSERT INTO plj_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Nan nye gǝri pa shinti lasiwo, ar ni tǝ yari munju ra dlor lasi gwa'e, <<Muntu ma gip wur ni tǝra.>> ");
INSERT INTO plj_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ar ni Bitǝrus pa nge gǝsi. Ar ri kǝtigon da'a, ar ni munju kan ra dlor kar Bitǝrus gwa ba wul ti'e, <<Na ho bi ni, ki ma gip wur ni kira, domici ki mbarǝm kǝ Galili ni.>> ");
INSERT INTO plj_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ar ni Bitǝrus pa nǝm wotli bes shirǝmi tǝ den pi bi gam gǝsi, na ɓe am atl cina da wuri tǝ den wultǝn'e, <<A mom mbarǝm tu kan kǝ shirǝm den ti gwa da'a.>> ");
INSERT INTO plj_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Na yari untuwo, ar ni tus kor la yar kǝ bisi ropi. Ar ni Bitǝrus dami shirǝm tu kan Yesu yari ti gwa'e, <<Kapǝn dǝ tus kor la yar kǝ bisi ropo, kii wule kǝ momǝn da'a biyi myakan.>> Nan tǝ dam ti den shirǝm tuwo, ar ni tǝ mbutl na kulu. ");
INSERT INTO plj_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kǝ bi cigǝni, ar ni ga kiri lǝɓa kǝ Yami na kiri kǝ bǝni, na mǝn kulci mbarǝm den kulci kǝ Musa, na kup nami mǝn domtǝn kǝ mǝn ne ger den shirǝm dar bi dene. Kan wu ɓal Yesuka, wu ndara nan ti cina dǝ Bilatus. ");
INSERT INTO plj_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Bilatus ngen momi kar ti tǝ wule, <<Ki ni'e gun kǝ mǝn Yahuda ya?>> Ar ni Yesu bali ti, tǝ wule, <<Untu ni kǝ yari.>> ");
INSERT INTO plj_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Kan ga kiri lǝɓa kǝ Yam ba ne ti bes shirǝm gami den bar na womti. ");
INSERT INTO plj_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ar ni Bilatus pa ngen momi kar ti, tǝ wul ti'e, <<Ar tu wu ne'i den ne bes shirǝm gam den bar na womti, kii bali diya?>> ");
INSERT INTO plj_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ama har kǝkǝn ma Yesu sa gǝs shot, ar ni ar ghun Bilatus. ");
INSERT INTO plj_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ar dǝm'e den kandatu tǝ kur pi gwa, gunyi ba kur pǝtli mǝn Yahudayi nǝm gip munju ra na ɓali gip bom moni kan wu liri gwa. ");
INSERT INTO plj_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Rawo, mbarǝm gon ra kan ba la ti bi'e Barabas gwa ra na ɓali gip bom moni na mir mǝn tli mǝn bǝn mbatl yami kan wu ri gon eka wokoci gon kǝ tli mǝn bǝn mbatl yami. ");
INSERT INTO plj_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ar ni womti mbarǝmi ɗir wu nǝm liri Bilatus kǝ dǝ tǝ pi wur argon tu tǝ kur pi gwa. ");
INSERT INTO plj_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Bilatus bali wur tǝ wule, <<Kǝ ndu'e a pǝtli in gun kǝ mǝn Yahuda ya?>> ");
INSERT INTO plj_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Domici tǝ mom'e ghuve ni kem ga kiri lǝɓa kǝ Yam kǝ bi Yesuka am da ti. ");
INSERT INTO plj_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ar ni ga kiri lǝɓa kǝ Yam ba co mbarǝm kǝ dǝ wu wule dǝ pǝtli wur Barabas den ami kǝ Yesu. ");
INSERT INTO plj_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ar ni Bilatus ngen momi kar wur tǝ wule, <<Kan unun aa pi na muntu kǝ wul ti'e gun kǝ mǝn Yahuda gwawu?>> ");
INSERT INTO plj_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ar ni wu wom bar wu wule, <<Dǝ ɓa tika den kini!>> ");
INSERT INTO plj_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Bilatus wul wur'e, <<Den unu? Unu wani bar ni tǝ piwe?>> Ar ni wu pa wom bar hoyi wu den wultǝn'e, <<Dǝ ɓa tika den kini!>> ");
INSERT INTO plj_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Nan tǝ ndu'e tǝ gholi womti mbarǝmi mbatlo, ar ni tǝ pǝtli wur Barabas. Nan tǝ kem ɓo Yesu na rǝɓawo ar ni tǝ taa ti am da wur kǝ dǝ ɓa tika den kini. ");
INSERT INTO plj_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Kan ga mǝn bi utuyi ba ndara na Yesu gip dlabǝn bom kǝ ga mǝn bi utuyi, bom dǝ gobnayi las tu ba la ti bi'e,<<Pǝritoriyom>> gwa. Ar ni wu dom nami mǝn bi utuyi kup. ");
INSERT INTO plj_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ar ni wu la'i ti tlyari lulur gon wule zili yape, wu pa pi posh gam ka ire. Wu kemi ti sur gami. ");
INSERT INTO plj_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ar ni wu nǝm shirmi gǝsi wu den wultǝn'e, <<Dǝ Yam za ki ra, gun kǝ mǝn Yahuda!>> ");
INSERT INTO plj_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Eso, wu pi ta ɓe gǝs sur gami na dlo, wu pi ta bǝse ti mo'ǝmi. Kan wu ngus gip lo'i gǝs den wu ne ti den bi nartǝni. ");
INSERT INTO plj_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Nan wu pa'i lo'i gǝso, ar ni wu tus tlyari zili luluri ka, kan wu la'i ti lulur gǝsi. Kan wu ɗǝli ti te kaarika kǝ dǝ ɓa tika den kini. ");
INSERT INTO plj_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Wu den ndaratǝno, ar ni wu mo na mbarǝm gon den ɓomi asǝme, mǝn sun Simon, mbarǝm kǝ Sayirin, basi ga Alekzanda na Rufus, tǝ ɗǝl ter gip nye bǝni, ar ni wu kem ti kǝ pǝni kin ɓa'i kǝ Yesu. ");
INSERT INTO plj_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Wu ri Yesu las gon kan ba wul ti'e Golgota gwa, las kǝ kula gam ituwi. ");
INSERT INTO plj_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Lasi ni wu taˈi ti mal inabi kurtli na mur, kan tǝ nge tleka. ");
INSERT INTO plj_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ar ni wu ɓa tika den kini. Wu pa rabe tutul gǝs gip dlom gǝzǝni, wu la guri'a dene wu shin argon tu ko gonge gǝzǝn baa zam gwa. ");
INSERT INTO plj_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Bar kǝ gǝlla am ghanum ni kǝ cigǝni ni wu ɓa ti den kini. ");
INSERT INTO plj_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Den kin tu ɓa tikawo, ar ni wu rǝsh bar tu wu shin bes gǝs dene gwa'e, <<GUN KƏ MƏN YAHUDA.>> ");
INSERT INTO plj_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Wu pa ɓa mur mǝn dlǝri den tǝp jen rop nan ti, nǝm den am shimli gǝsi, nǝmi ngapo den am yali gǝsi. ");
INSERT INTO plj_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(Muntuwo den bi laa'itǝn kǝ rǝshi shirǝm kǝ Yam ni'e, <<Dlǝm ti gip mǝn wani pitǝne.>>) ");
INSERT INTO plj_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Mbarǝm kan ba kop tǝp lasi gwa pi ta yari shirǝm mburtǝne, wu den kungǝt gami, wu den wultǝn'e, <<Hahaha! Ki kan kii yas bom kǝ Yamka, kǝ pa tu gip muri myakano, ");
INSERT INTO plj_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","se kǝ ɗǝl sur den kini, kǝ ɗǝli gam gi!>> ");
INSERT INTO plj_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Untu ni es ga kiri lǝɓa kǝ Yam gwa, na mǝn kulci mbarǝm den kulci kǝ Musa pi ta pi ti mǝgǝn shirǝm gip dlom gǝzǝni, wu den wultǝn'e, <<Tǝ ɗǝli jeni, ama tii mani ɗǝli gam gǝs da'a! ");
INSERT INTO plj_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Naa dǝ Almasihu tu, e gun kǝ Israˈila ɗǝl sur den kin ɓatǝni kǝkǝn mǝ shini, kǝ dǝ mǝn ma mǝ ngǝsh mi den ti ra!>> Mur mǝn dlǝri den tǝp ju nan ɓa wur nan ti ma pi ti mǝgǝn shirǝmi. ");
INSERT INTO plj_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Gip dlom pǝte, ar ni dǝmǝn nga gip atli ka kup, ar ba ri gǝlla am myakan kǝ pǝte. ");
INSERT INTO plj_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ra untuwo, nan ar ri gǝlla am myakan kǝ pǝto, ar ni Yesu tli yar yam tǝ wule, <<Eloi, Eloi lamasabaktani?>> Muntu ba pi nupi'e <<Yam gǝni, Yam gǝni, unun kem kǝ balǝm kaar we?>> ");
INSERT INTO plj_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nan jen kan ra dlor lasi kum untuwo ar ni wu wule, <<Ɓa kum ni, tǝ den laˈi bi mǝn yari shirǝm kǝ Yam Iliya wi.>> ");
INSERT INTO plj_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ar ni nǝm gip wur tli na kǝtǝre, tǝ gii sonso na mati mal gǝri kiin inabi, tǝ ɓal den dlo tǝ taˈi Yesu kǝ dǝ tǝ tla, tǝ wule, <<Naa mi shini in Iliya mǝn yari shirǝm kǝ Yam baa ɗir tǝ ɗǝli ti sur ka gwa.>> ");
INSERT INTO plj_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ar ni Yesu tli yar hoyi tǝ dǝl bar shukutǝni, kan tǝ kotl mbatlka. ");
INSERT INTO plj_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ar ni labǝle kǝ te gip bom kǝ Yamka ba tarka sur gip dlomi, argon tu nǝm sur yami har su atlka. ");
INSERT INTO plj_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nan bar mǝn bi utu kan dlor lasi shin kandatu Yesu mǝsho, ar ni tǝ wule, <<Na ho bi, mbarǝm tuwo, Nya Yam ni!>> ");
INSERT INTO plj_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Mǝtli jen dlǝr teka jen wu den shini. Gip wuro Maryamu kǝ Magadala ra, na Maryamu nasi Yakubu heli na Isubu, na Salomi esi. ");
INSERT INTO plj_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ter Galili ni mǝtli ju kop ti wu den pi ti mbapi. Mǝtli jen na womti kan kop ti kaar tor Urshalima ma ra lasi. ");
INSERT INTO plj_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Kǝ sitiwo pǝt kǝrkǝm bar ni domici gǝniwo pǝt shukutǝn ni. ");
INSERT INTO plj_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ar ni mbarǝm gon mǝn sun Isubu, mbarǝm kǝ Arǝmatiya ɗiri. Ti ma nǝm ni gip domtǝn kǝ mǝn tloyi shirǝm kǝ mǝn Yahuda, mǝn pitǝn dlat ni esi, ti ni den ɓuti cwattǝn kǝ mulki kǝ Yami. Tǝ ɓa bi gul tǝ ri kar Bilatus, tǝ liri dǝ bi ti dli kǝ Yesu. ");
INSERT INTO plj_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Bilatus nǝm bi na ame nan tǝ kum'e Yesu mǝsh kawi gwa. Ar ni tǝ la bi bar mǝn bi utuyi tǝ ngen momi kar ti, ko na ho bi ni Yesu mǝsh kawi. ");
INSERT INTO plj_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Nan tǝ kum bi dǝ bar mǝn bi utuyiwo, ar ni tǝ bi Isubu dli kǝ Yesuyi. ");
INSERT INTO plj_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ar ni Isubu wur tutul ghumi mǝshi mbarǝm ɗiri, tǝ shu dli kǝ Yesu suri, kan tǝ ghumka na tutul ghumi mǝshi mbarǝmi, tǝ mur ti gip gambǝci tu kan tǝ bor gip shu tat gwa. Kan tǝ kutǝl bar tat ɗiri tǝ le bisika na ri. ");
INSERT INTO plj_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maryamu kǝ Magadala na Maryamu nas kǝ Isubu shin las tu muri dli kǝ Yesu gwa. ");
INSERT INTO plj_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Nan pǝt Asabar pǝt shukutǝn bi karwo, ar ni Maryamu kǝ Magadala, na Maryamu nasi Yakubu na Salomi, wur bar mǝn tǝmi kasǝr ɗiri kǝ dǝ wu ri bǝrke dli kǝ Yesu. ");
INSERT INTO plj_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Den pǝt kǝ nǝm kǝ sati, kǝ cigǝni wokoci ɗǝltǝn kǝ pǝt tori, ar ni wu ri kǝ ba gambǝci'i. ");
INSERT INTO plj_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Nan wu ra den ritǝno, wu wul ezǝn'e <<Wo ni baa kutǝli mi tat tu kan le gambǝci'i na ri kawe?>> ");
INSERT INTO plj_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Nan wu tli ger wu shin gambǝci'iwo, ar ni wu shin kutǝl bar tati kawi. ");
INSERT INTO plj_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Nan wu su gip gambǝci'iwo, ar ni wu shin nye mbarǝm gon njon den am shimli, na ghol lulur gi dli gǝsi, kan wu kum bǝrti. ");
INSERT INTO plj_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ar ni nye mbarǝmi wul wur'e, <<Ba ar dǝmi in bar kǝ dlǝkǝntǝn da'a. Kǝn ni den ngeni Yesu kǝ Nazarat muntu ɓa tika den kin gwa ya? Ar tu ngap ti'i da'a, tǝ tli gǝs wi. Las tu mur ti gwan kǝni! ");
INSERT INTO plj_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kǝkǝno ri yari ni mir mǝn kulci kar ti, na Bitǝrus'e tii mbubar Galili cina da wuri. Barta ni wii shin ti kandatu nan tǝ yari in gwa.>> ");
INSERT INTO plj_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ar ni mǝtliyi ɗǝl na kǝtǝre, dǝmǝn gam nǝm wur wi, dli gǝzǝn den dǝdartǝni. Wu wul murgon'e argon da'a, domici bǝrti den ci gǝzǝni. ");
INSERT INTO plj_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Nan Yesu tli gip mǝshi mbarǝmo, kǝ bi cǝgǝni den pǝt kǝ nǝm kǝ sati, ar ni tǝ pare ɗǝltǝn kar Maryamu kǝ Magadala, nagǝr tu kan Yesu ɗǝli ti dun itǝr nyingi gip tli gǝska gwa. ");
INSERT INTO plj_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Nagǝr mbarǝmi eso, ar ni tǝ ri yari mbarǝm ju nan ra na Yesu tun har gwa, munju kan ra den dun mbatl na kulu gwa. ");
INSERT INTO plj_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ama nan wu kum'e Yesu ra na ge mbatl gǝsi, har Maryamu ma tǝ shin tiwo, wu ngǝsh wur dene da'a. ");
INSERT INTO plj_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Den kaar kǝ muntuwo, ar ni Yesu sanje kama gǝska, kan tǝ ɗǝl kar mbarǝm jen rop gip mir mǝn kulci kar ti wokoci tu nan wu den ritǝn gip nye bǝn gon gwa. ");
INSERT INTO plj_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ar ni wu rop ju pal rǝnka wu ri yari nami, ama wu la shirǝmi gip mbatl da'a. ");
INSERT INTO plj_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Den kaariwo Yesu ɗǝl kar kutl cet nǝm ju wokoci tu nan wu den ci fingal gwa. Ar ni tǝ matl wur den nge ngǝshtǝn den Yam na lati gam gǝzǝni, domici wu nǝm argon tu munju shin ti den kaar kǝ tlitǝn gǝs yari gwa da'a. ");
INSERT INTO plj_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Tǝ wul wur'e, <<Ri nǝka ko ako gip atl kundǝrǝndlip, kǝ yari ni mbarǝm kup zo shirǝm tu. ");
INSERT INTO plj_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Muntu kup ngǝsh ti den shirǝmiwo, baa pi ti batismawo, tii zam ɗǝltǝne. Ama muntu kup nǝsh den shirǝmi dawo, baa hukunte ti. ");
INSERT INTO plj_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Bar ju kan munju ngǝsh wur demǝn baa pi kǝ bi seda gwa ni'e, gip sun gǝno, wii dǝli dun itǝrka gip mbarǝme, wii pa shirǝm gip pel bi jeni. ");
INSERT INTO plj_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Wii pǝn ici na am gǝzǝni. Eso wi ni wu tla uun mǝn ri mbarǝm ekawo, ar ba pi wur argon da'a. Wii pa ne am gǝzǝn den mǝn kumi dli, kan wu warke.>> ");
INSERT INTO plj_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Den kaar kǝ shirǝm kǝ Babom Yesu nan wuro, ar ni pǝn tika to yamka, tǝ dǝm den am shimli kǝ Yami. ");
INSERT INTO plj_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Mir mǝn kulci kar tiyi ngapo, kan wu ɗǝl wu pi ta pi wazu ko ako. Babom es kop nan wuri, tǝ den kopi kaar kǝ shirǝm gǝzǝn tǝp kǝ ba pi halamu bar kǝ dlǝkǝntǝn ju kan tǝ kem wu pi gwa.");
INSERT INTO plj_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Mbarǝm na womti rǝsh den bar ju kan pi gip dlom gǝmi gwa. ");
INSERT INTO plj_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Wu rǝsh bar ju mǝ kum gwa, bi dǝ munju shin bar ju na ger gǝzǝn terka kan den ritǝn gip dlom gǝmi kan wu yari jen shirǝm kǝ Yam gwa, wi ni wu bi mi. ");
INSERT INTO plj_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Den untuwo, ar ni na gam gǝni a zhit bar kup na ne gǝs kǝ pitǝn gǝzǝn, ar ni a shin ar ndari'e a rǝshi'i bar kup ndekes, mǝn nartǝn Tiyopilus, ");
INSERT INTO plj_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","kǝ dǝ kǝ mom ge shirǝm kǝ bar ju kan kulci'i kup gwa. ");
INSERT INTO plj_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Gip muri ju kan Hiridus ra den dandi kǝ Yahudiyawo, mǝn keri bar ju ɗiri Yam gon ra muntu na sun'e Zakariya gwa, ti ni gip mǝn keri bar ju ɗiri Yam kan gǝs dǝ Abaya gwa, nagǝr gǝs Alisabatu pawo gǝs gal kǝ Haruna ni. ");
INSERT INTO plj_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Kup gǝzǝn mǝn bǝrti Yam kan pi mbuni dǝmi cina dǝ Yam gwani, wu kop doka kǝ Yam kup asǝm na gǝse. ");
INSERT INTO plj_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ama wira na mimir da'a domici Alisabatuwo njikǝn ni, win ju ngap wu korsi wi. ");
INSERT INTO plj_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Gasi gon, nan Zakariya ra den pi mbap gǝs kǝ mǝn keri bar ju ɗiri Yam den am kǝ mbarǝm cina dǝ Yami, nan an ɗir den kungiya gǝzǝn gwa, ");
INSERT INTO plj_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","den bi al'ada kandatu ne kǝ dǝ mǝn keri bar ju ɗiri Yam den am kǝ mbarǝm wu kop gwa, ba zǝzar ti kǝ tǝ te gip Bom kǝ Yam dǝ tǝ la kunu mǝn tǝmi kasǝri. ");
INSERT INTO plj_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Mbarǝm na womti eso wu ra kari, wu den shirǝm na Yam, nan den la'i kunu mǝn tǝmi kasǝri gwa. ");
INSERT INTO plj_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Kan mǝn kartǝn kǝ Yam ba ɗǝl kar Zakariya, dlor den am shimli kǝ ba la'i kunu mǝn tǝmi kasǝri. ");
INSERT INTO plj_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nan Zakariya shin tǝwo, ar ni mbatl tari ti kan bǝrti ba nǝm ti. ");
INSERT INTO plj_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ama mǝn kartǝn kǝ Yami wul ti'e, <<Ba kǝ kum bǝrti da'a, Zakariya, Yam kum lirtǝn gi wi. Nagǝr gi Alisabatu ba gǝri'i nya, ki ne ti sun'e Yohana. ");
INSERT INTO plj_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ti dǝmi'i bar kǝ ghol mbatl na kumi tǝmi, mbarǝm na womti ba pi ghol mbatl na gǝri gǝsi, ");
INSERT INTO plj_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ti dǝm mǝn nartǝn cina dǝ Babom Yami. Ti tla ɗu da'a na bar mǝn hutǝn kup, bar mǝn kemi gheri gami. Yam ba la'i ti na Ruhu gǝsi tun te tu dǝ naska. ");
INSERT INTO plj_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ti pali mbarǝm kǝ Isra'ila na womti ɗir kar Babom Yam gǝzǝni. ");
INSERT INTO plj_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ti ri cina dǝ Babom gip Ruhu na iko kǝ mǝn yari shirǝm kǝ Yam Iliya, ti pali mbatl kǝ mǝn gǝri kar mimir gǝzǝni, kan mǝn nge kopi shirǝm es den ho tǝp kǝ mǝn bǝrti Yami, ti kǝrkǝm mbarǝm kǝ dǝ wu dǝm mǝn bǝrti Babomi.>> ");
INSERT INTO plj_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakariya wul mǝn kartǝn kǝ Yami'e, <<Imni a mani momi argon tu kǝ yari ba pi rawu? Ami korsi ni nagǝr gǝn ngapo sheti ghon gǝs womti wi.>> ");
INSERT INTO plj_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Mǝn kartǝn kǝ Yami nǝmi ti, tǝ wule, <<Ami ni'e Jibra'ilu, a dlǝr cina dǝ Yami, arni kan ba karǝm dǝ a shirǝm nan ki, a yari'i zo shirǝm kǝni. ");
INSERT INTO plj_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Kǝkǝno ki sa shot, ki'i mani shirǝm da'a, se gas tu kan bar tu ni piwi gwa, den kǝ la shirǝm gǝn mbatl da'a, muntu ba dǝm hoyi den kanda tu a yari gwa.>> ");
INSERT INTO plj_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Mbarǝm ba dlǝr wu den ɓuti dǝ Zakariya ɗǝl teri, wu den damtǝn den ununu kem tǝ ɗǝl ter gip Bom kǝ Yam bǝle da'a. ");
INSERT INTO plj_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Nan tǝ ɗǝl tero, tǝ'i mani shirǝm nan wur da'a. Wu mom'e tǝ shin ni ruya gip Bom kǝ Yami kan tǝ nǝm shirǝm nan wur na ame, ama tǝ'i mani shirǝm da'a. ");
INSERT INTO plj_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Nan pǝt mbap gǝs pawo, ar ni tǝ pal rǝn bomka. ");
INSERT INTO plj_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Den kar kǝ untuwo, kan nagǝr gǝs Alisabatu ba zam tu'e, ar ni tǝ ghundǝr gam gǝska kǝ kyar nantam gip bomi. ");
INSERT INTO plj_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Alisabatu wule,<<Yam ni pim untu, Gip muri jino Babom Yam shin guna gǝni, tǝ ɗǝlim shamka gip mbarǝme.>> ");
INSERT INTO plj_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Gip kyar kǝ mukka na zami tu kǝ Alisabatuwo, Yam kar mǝn kartǝn gǝs Jibra'ilu su gip bǝn Nazarat kan ra gip atl kǝ Galili gwa, ");
INSERT INTO plj_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","kar nye gǝr kan mom moni wi da'a, muntu Isubu gǝs gal kǝ Dauda ri o da ti gwa, tǝ pǝn gip mbatl gǝs tǝ gudlǝmi nan ti gwa, sun kǝ nye gǝri'e Maryamu. ");
INSERT INTO plj_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Mǝn kartǝn kǝ Yami ri kar ti tǝ wul ti'e, <<Dǝ shirmi ika! Babom Yam ba kum tǝmi gi, Babom Yam ra nan ki.>> ");
INSERT INTO plj_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Nan Maryamu kum shirmitǝn tuwo ar dlǝkǝn ti hoyi, tǝ den damtǝn den'e unu shirmitǝn utu untu. ");
INSERT INTO plj_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ama mǝn kartǝn kǝ Yami wul ti'e, <<Ba dǝ bǝrti ci'i da'a Maryamu, kǝ zam cirtǝn cina dǝ Yam wi. ");
INSERT INTO plj_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ki zam tu'e, ki gǝr nya, ki ne ti sun'e Yesu. ");
INSERT INTO plj_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ti dǝm bar mbarǝme, ba wul ti’e nya bar gun kǝ to yamka, Babom Yam ba bi ti dandi kǝ bas Dauda. ");
INSERT INTO plj_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ti pi mulki gam bom kǝ Yakubu bat na patǝni, mulki gǝs ba pa da'a!>> ");
INSERT INTO plj_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maryamu wul mǝn kartǝn kǝ Yami'e, <<Imnu untu ba pi rawu, ami kan a mom momi wi da gwawu?>> ");
INSERT INTO plj_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Mǝn kartǝn kǝ Yami nǝmi ti, tǝ wule, <<Ruhu kǝ Yam ba sur den ki, iko kǝ Bar Gun kǝ to Yamka baa ghum kika. Ra untuwo, nya tu ki gǝriwo ti nǝra na wani pitǝn da'a, ba wul ti'e Nya Yami. ");
INSERT INTO plj_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ar tu erǝm gi Alisabatu nan ba wule ti njikǝn ni ma na korsitǝn gǝsi, kǝkǝn untu tǝra na tu kyar mukka. ");
INSERT INTO plj_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Argon ra da'a kan Yam ba mbu pi da gwa.>> ");
INSERT INTO plj_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maryamu nǝmi ti tǝ wule, <<Ami zher kǝ Yam ni, naa ar dǝmim untu den yari gi.>> Ar ni mǝn kartǝn kǝ Yami ndara. ");
INSERT INTO plj_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Murka njemo, ar ni Maryamu tli na zhotǝne tǝ ri gip bǝn gon gip atl tlǝndǝr kǝ mǝn Yahuda, ");
INSERT INTO plj_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","las tu Zakariya ra gwa, tǝ te gip bomi, tǝ shirmi Alisabatu. ");
INSERT INTO plj_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Nan Alisabatu kum shirmitǝn kǝ Maryamuwo, ar ni nya kǝ te tu gǝska jiti ti, kan ba la'i Alisabatu na Ruhu kǝ Yami. ");
INSERT INTO plj_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Tǝ shirǝm na bar yar tǝ wule, <<Ki mǝn albarka ni gip mǝtli, nya tu ki gǝriwo mǝn albarkani! ");
INSERT INTO plj_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Unun kem zo bar kǝn zamǝn untu, nan nasi Babom gǝn ba ɗir ra karǝm gwa wu? ");
INSERT INTO plj_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nan shirmitǝn gi su kǝm damo, arni nya kǝ te tu gǝnka jiti ti na ghol mbatli. ");
INSERT INTO plj_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Mǝn albarka ni'e muntu nǝm'e shirǝm tu Yam yari tiwo, ar ba pi untu gwa.>> ");
INSERT INTO plj_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Arni Maryamu wule, <<Mbatl gǝn ba ɗǝɗa Babom Yami. ");
INSERT INTO plj_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ruhu gǝn ba pi pighol mbatl gip Yam mǝn ɗǝli gǝni. ");
INSERT INTO plj_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Don tǝ mom namǝni, ami zher gǝs gǝr mǝtli ni kan ami argon ni da gwa. Cina ɗewo mbarǝm kup ba wulǝm'e, <ki mǝn albarkani,> ");
INSERT INTO plj_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","den bar ju kan Yam mǝn nartǝn pim gwa, sun gǝso dlǝran ni ar ra. ");
INSERT INTO plj_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Guna gǝs ba ri den mǝn ju ba bi ti nartǝn gwa, zhan ar kop zhan. ");
INSERT INTO plj_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ya pi kiri mbap na am gǝs mǝn ndǝrtǝn, tǝ gǝzan mǝn dlari gamka na kup arjen ju ba se wur gip mbatl gǝzǝn gwa. ");
INSERT INTO plj_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ya shu gunka den dandi gǝzǝni, kan tǝ ɗǝɗa mun ju kan mom nan wur dagwa. ");
INSERT INTO plj_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Tǝ la'i tu kǝ mǝn kumi guzum na mbuni bari, kan ti za mǝn bar kǝ am am koni. ");
INSERT INTO plj_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Tǝ ne am zher gǝs Isra'ila ra, tǝ tune na gudlǝm shirǝm gǝs kǝ kumi guna'i ");
INSERT INTO plj_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","den tǝ pi ga gigi gǝmi Ibǝrahim na mimir gǝs kǝ kumi guna gǝzǝn an ri patǝn bari.>> ");
INSERT INTO plj_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maryamu dǝm na Alisabatu wule kǝ kyar myakan kan tǝ pal rǝn bomka. ");
INSERT INTO plj_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Nan pǝt mbi rawi kan Alisabatu ba gǝr nya gǝso, ar ni tǝ gǝr nye moni ");
INSERT INTO plj_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Berǝm dǝmi na mǝn gǝs nan wu kum zo bar tu Yam pi tǝwo, ar ni wu pi ghol mbatl nan ti. ");
INSERT INTO plj_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nan muri wuzupse la'i wo, ar ni wu ɗir kǝ dǝ wu sǝr nyayi. Wu ndu far'e wu ne ti sun kǝ bas Zakariya, ");
INSERT INTO plj_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ama nas nge gǝs tǝ wule, <<O'o, dǝ la ti bi'e Yohana.>> ");
INSERT INTO plj_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Wu wul ti'e, <<Murgon ra gip mǝn gi na sun tu daa.>> ");
INSERT INTO plj_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ar ni wu pi bas ame, kǝ dǝ wu mom unu sun ni tǝ ndu'e dǝ ne nyayi. ");
INSERT INTO plj_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Tǝ liri ba rǝshi, ar ni tǝ rǝshi, <<Sun gǝs'e Yohana.>> Bar tu dlǝkǝn mbarǝm ju ra lasi gwa. ");
INSERT INTO plj_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Bartu, ar ni bi kǝ Zakariya ɓuli, tǝ shirǝme, kan tǝ nǝm ɗǝɗa Yami. ");
INSERT INTO plj_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Kan bǝrti ba nǝm berǝm dǝmi gǝzǝn kup, mbarǝm ba nǝm yari shirǝm den bar tu nan pi untu gwa, kup gip atl mǝn tlǝndǝr kǝ mǝn Yahuda. ");
INSERT INTO plj_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Kup muntu kum shirǝm tuwo, tǝ wul tor gip mbatl gǝs'e, <<Imni nya tu bari kǝ dǝmiwe?>> Den wu momi am kǝ Yam ra nan ti. ");
INSERT INTO plj_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Bas Zakariya laa na Ruhu kǝ Yami, ar ni tǝ yari shirǝm kǝ Yam tǝ wule, ");
INSERT INTO plj_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","<<Mǝ ɗǝɗani Babom Yam kǝ Isra'ila den tǝ ɗir kar mbarǝm gǝs tǝ ɗǝli wuri. ");
INSERT INTO plj_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Tǝ bi mi mǝn ɗǝli gǝmi mǝn iko gip bom kǝ zher gǝs Dauda. ");
INSERT INTO plj_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Kanda tu tǝ yari terka bi dǝ mǝn yari shirǝm kǝ Yam mǝn tsarki. ");
INSERT INTO plj_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Den mii zam ɗǝltǝn wi am dǝ mǝn nge gǝmi, na mǝn ju ba ndu mi da gwa. ");
INSERT INTO plj_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Yam gode kori gǝmi guna gere, kan tǝ tune na gudlum shirǝm gǝs kǝ far mǝn tsarki nan tǝ pi wur gwa. ");
INSERT INTO plj_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Gudlum shirǝm tu nan tǝ yari kori gǝmi kǝ far Ibǝrahim. ");
INSERT INTO plj_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Tǝ ɗǝli mi am dǝ mǝn nge gǝmi, kǝ dǝ mǝ bote ti bat na bǝrti. ");
INSERT INTO plj_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Mǝ dǝm ni dlǝran na pitǝn dlat cina dǝ Yam gip muri gǝmi kup. ");
INSERT INTO plj_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ki nya gǝn eso, ba la kibi'e mǝn yari shirǝm kǝ bar Gun kǝ to yamka. Ki ri cina dǝ Babomi, kǝ kǝrkǝmi ti guntǝpe. ");
INSERT INTO plj_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ki yari mbarǝm gǝs kandatu wi zam tǝp ɗǝltǝn gip dun mbatl tǝp kǝ ba ho’i warwat pitǝn gǝzǝnka gwa. ");
INSERT INTO plj_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Gip womti shini guna kǝ Yam gǝmi, cirtǝn kǝ pǝt kan ba ɗǝl tor gǝsi ba ɗǝl sur yam an cir den mi, ");
INSERT INTO plj_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ar ba cir den mǝn dǝmi gip dǝmǝni, na gip gos kǝ mǝshtǝni, ar baa kop nan mi den tǝp kǝ dǝmi zhilili.>> ");
INSERT INTO plj_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Yohana nyayi nari, tǝ dǝm na ndǝrtǝn gip ruhu, tǝ dǝm gǝs rǝn gip lǝpka se gastu kan tǝ ɗǝl ɗir gip mbarǝm kǝ pi mbarǝm kǝ Isra'ila wazu gwa. ");
INSERT INTO plj_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Gip muri jawo, la'i icǝn ɗǝl bi dǝ Kaisar Augustus, Gun kǝ Roma, dǝ dlǝm mbarǝm kǝ atl kup. ");
INSERT INTO plj_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Muntu ni'e la'i gǝs dlǝmi mbarǝm kǝ atl kup, gip muri ju kan Kiriniyus den dandi kǝ Siriya gwa. ");
INSERT INTO plj_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Arni mbarǝm kup pal rǝn bǝn dawurka dǝ rǝsh sun gǝzǝni. ");
INSERT INTO plj_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Isubu za bǝn Nazarat gip atl kǝ Galili ti pal to gip bǝn Baitalami gip atl kǝ Yahudiya, bǝn tu kan gǝr gun Dauda tunka gwa. Yusufu pal to bar taka ra'e ti mǝn bom kǝ Dauda ni. ");
INSERT INTO plj_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ya pal toka na nye gǝr gǝs Maryamu, muntu kan tǝ ri o da ti kan ra na tu gwa, kǝ dǝ rǝsh sun gǝzǝn toka. ");
INSERT INTO plj_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Wira to Baitalami kawo, ar ni pǝt gǝri gǝs ɗiri. ");
INSERT INTO plj_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Tǝ gǝr nya gǝs kǝ pari, tǝ ghum tika gip tutul gǝs tǝ mur ti gip kungǝlǝn, tun kan wira na las muri gip ba shu'i mǝn dikiyi da gwa. ");
INSERT INTO plj_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Rǝn bi lǝp kawo, mǝn le tǝm ra den muri kari, wu den ne ger den tǝm gǝzǝn kǝ gasi. ");
INSERT INTO plj_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Karap ar ni mǝn kartǝn kǝ Yam gon cwat kar wuri, gos kǝ Yam cir den wuro kan bǝrti ba nǝm wur na nari. ");
INSERT INTO plj_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ti ngapo kan tǝ wul wur'e, <<Ba dǝ bǝrti nǝm kǝnni da'a! Amo a ɗiri in na tǝmi shirǝmi, muntu ba kem mbarǝm kup wu pi ghol mbatl gwa. ");
INSERT INTO plj_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Sekǝno gǝri in mǝn ɗǝli mbarǝm gip dun mbatli gip bar bǝn kǝ Dauda, Babom Almasihu. ");
INSERT INTO plj_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Kandatu ki mom tiwo, ar ni'e, ki ri zam nya na ghumi gip tutul gǝs ɓom gip kungǝlǝn.>> ");
INSERT INTO plj_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Wi ra untuwo sai gimǝtl na womti mǝn kartǝn kǝ Yam na muntu ra far gwa gip wuri, wu den ɗǝɗa Yam, wu den wultǝn'e, ");
INSERT INTO plj_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","<<Yam'e bari to yamka! sur atlo dǝ ghol mbatl kop mǝn ju kan Yam ba kum tǝmi gǝzǝn gwa.>> ");
INSERT INTO plj_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nan mǝn kartǝn kǝ Yam ju pal gǝzǝn to yamkawo, arni mǝn le tǝm ju wul ezǝn'e, <<Mǝ rini Baitalami mǝ shinni argon kǝn kan den pitǝn, kan Yam yari mi gwa.>> ");
INSERT INTO plj_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Wu zho wur wu te gip bǝni wu zam Yusufu na Maryamu, wu shin nyayi su gip kungǝlǝnka ɓom. ");
INSERT INTO plj_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nan mǝn le tǝmi shin tǝwo kan wu bali wur argon tu kan mǝn kartǝn kǝ Yam tu yari wur den nyayi gwa. ");
INSERT INTO plj_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kup munju kum shirǝm tu yariwo, ar dlǝkǝn wuri, kan wu nǝm bi na am den argon tu mǝn le tǝm ju yari gwa. ");
INSERT INTO plj_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maryamu ngapo tǝ ne bar ju kup su mbatl ka, tǝ den damtǝn dene. ");
INSERT INTO plj_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Mǝn le tǝm ju pal rǝn bi lǝp ka, wu den ɗǝɗa Yam hoyi den argon tu wu kum kan wu shin gwa, bar ju kup mǝn kartǝn kǝ Yam yari wuro ar ni wu shini. ");
INSERT INTO plj_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Nan nyayi mur wuzupsewo, ar ni wu sǝr ti kan wu ne ti sun'e Yesu, sun tu kano mǝn kartǝn kǝ Yam bi wur nan zam tu gǝs wi da gwa. ");
INSERT INTO plj_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Nan muri la kǝ dǝ pi argon tu kulci kǝ Musa yari kǝ hotǝn dǝ pal hoyi cina dǝ Yam kan ba pii ɗiro, kan wu pǝn ti wu te ti Urushalima kǝ dǝ ta ti am dǝ Yami. ");
INSERT INTO plj_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Untun kulci kǝ Yam yari, den kup gǝri kǝ pari inkan nye moni no dǝ bi Yamka. ");
INSERT INTO plj_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Wu ɗir pash Maryamu den yari kǝ shirǝm kǝ Yam den'e mir kuɓur rop ko mir tattabara ropni ba mboshi. ");
INSERT INTO plj_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Gip muri jawo, mbarǝm gon ra nan ba wul ti'e Saminu gwa, tini su Urushalimaka na dǝmi. Ti bar mǝn bǝrti Yam ni mǝn la'i Yam mbatl ni. Tin den ɓuti gas tu kan Yam ba ɗǝli Isra'ila gwa. Ruhu kǝ Yam ra nan ti. ");
INSERT INTO plj_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ruhu kǝ Yam yari ti den ti mǝsh da'a se tin tǝ shin Almasihu tu kan Ba-Gun Yam wule ti kar ti sur kani. ");
INSERT INTO plj_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ruhu kǝ Yam kem ti tetǝn gip dǝbom Bom kǝ Yam gas tu kan mǝn gǝri kǝ nyayi ɗir ti wu pi ti argon tu shirǝm kǝ Yam yari dǝ pi nye moni kǝ pari gwa. ");
INSERT INTO plj_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Kan Saminu ba nǝm ti am dati tǝ goode Yami tǝ wule, ");
INSERT INTO plj_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","<< Kǝkǝno Babomi, na dǝ zher gi mǝsh na ghol mbatli den yari gi. ");
INSERT INTO plj_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Nan ger gǝn shin mǝn ɗǝli kǝ Isra'ila wi gwa, ");
INSERT INTO plj_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Muntu kǝ pi ti den ger kǝ bǝn kup gwa. ");
INSERT INTO plj_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Cirtǝn tuni es ɓul guntǝp kǝ momi Yam dǝ mǝn ju kan mǝn Yahuda ni da gwa, tin ti kem mbarǝm kǝ Isra'ila wu pi sun ra.>> ");
INSERT INTO plj_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Na kumi untuwo, kan bas na nas ba nǝm bi na am, den bar ju kan Saminu yari den ti gwa. ");
INSERT INTO plj_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Kan Saminu ba lir Yam dǝ tǝ ne am Yusufu na Maryamu ra, ti wul Maryamu nas'e, <<Yam zǝzar nya tu, ti kem mbarǝm na womti kǝ jiltǝni, ti dǝm guntǝp kopi Yam kǝ mbarǝm na womti gip Isra'ila. Tin ti dǝm alama tu ɗǝl kar Yam kan mbarǝm na womti ba nge gwa. ");
INSERT INTO plj_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Na untun arjen ju wu ghundǝri su mbatl da wurka ma ba ɗǝl kari, bar tu ba ci'i mbatl wule tuli ini tu na sǝɓǝri>>. ");
INSERT INTO plj_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Korsi mǝn shirǝm na Yam tu kan ba wul ti'e Hannatu, nya Fanuwel, nya Ashiru. Tǝ dǝm bom kos kǝ sheti ghon nyingi katl, ");
INSERT INTO plj_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","kan kos gǝs ba mǝsh ka. Kǝkǝno sheti ghon gǝs hauya wupse na wupseni. Tǝ za Bom kǝ Yam da'a pǝt na gasi, tǝ ne Yam den ngustin kǝ liri gǝs na guzum male. ");
INSERT INTO plj_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Saminu pa’i shirǝm gǝs ituwi arni Hannatu ter gipi, ti den goode Yam tǝ shirǝm den nya tu. Tǝ yari kup munju kan den ɓuti dǝ Yam ɗǝli wur gip dun mbatl gǝzǝn gwa. ");
INSERT INTO plj_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nan ga Isubu na Maryamu pa'i kup argon tu shirǝm kǝ Yam yari dǝ piwo, kan wu pal su bǝn gǝzǝn Nazarat gip atl kǝ Galili ka. ");
INSERT INTO plj_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Nyayi ba nar na ndǝrtǝn gǝsi. Yam bi ti momi bar na nari, ndutǝn kǝ Yam kop ti kari. ");
INSERT INTO plj_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Sheti ghon kupo, mǝn gǝri kǝ Yesu ba kur su Urushalima kǝ nyel jikat bǝdlabǝni. ");
INSERT INTO plj_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Nan Yesu ri sheti ghon kutl cet rob na gǝriwo, kan wu su kǝ nyel jikat bǝdlabǝn kan wu kur pi gwa. ");
INSERT INTO plj_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Nan wu pa’i nyel jikat bǝdlabǝniwo ar ni wu nǝm tǝp paltǝn gǝzǝn su bǝn da wur Nazaratka, Yesu nya tu ngapo tǝ sa gǝs su Urushalima ka, mǝn gǝri gǝs ngap wu mom da'a. ");
INSERT INTO plj_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Wi ngapo wu wule ti nǝra gip mǝn ju wu den ritǝn nan wur gwa, wu nda pǝt den ɓomi asǝm nan gǝzǝni. Nan wu shin ti dawo kan wu nǝm ngeni gǝs gip ezǝn na berǝm gǝzǝni. ");
INSERT INTO plj_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Nan wu zam ti dawo, ar ni wu pal su Urushalimaka kǝ ngeni gǝsi. ");
INSERT INTO plj_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Muri gǝzǝn myakan, kan wu nde zami gǝs gip dlom kǝ mǝn kulci shirǝm kǝ Yam te gip dǝbom Bom kǝ Yamka, ti den kumi gǝzǝn kan tǝ pa ngen momi kar wuri. ");
INSERT INTO plj_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","munju kan kum bar ju kup tǝ bali nan wuro ar ni momi shirǝm gǝs na bali shirǝm gǝs dlǝkǝn wuri. ");
INSERT INTO plj_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ar dlǝkǝn mǝn gǝri gǝs na shini gǝs lasi, kan nas ba wul ti'e, <<Nya gǝni, unun kǝ pi mi untuwu? Ami na be den ngeni gi na zoti ger gwa!>> ");
INSERT INTO plj_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Tǝ ngen momi kar wur tǝ wule, <<Kǝ ngenǝm ni kǝ unu? Kǝ mom ni'e ar ndari a nǝra te bom dǝ Banka da'a ya?>> ");
INSERT INTO plj_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Wi ngapo wu mom gǝs kǝ shirǝm tu ti bali wur gwa da'a. ");
INSERT INTO plj_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Kan tǝ tlyam tǝ kop wur wu pal gǝzǝn su Nazaratka tǝ pi ta kumi bi kǝ mǝn gǝri gǝsi, kup bar juwo nas ne su mbatl da tika. ");
INSERT INTO plj_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Kan Yesu ba pi ta nartǝn na ɓatli mbatl na tlyartǝni, tǝ zam cirtǝn kar Yam na mbarǝme. ");
INSERT INTO plj_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Bar gun Kaisar Tibariya gip sheti ghon kutl cet nantam den dandi kǝ atl kǝ Roma, Buntu Bilatus ngapo ti ni den dandi kǝ atl kǝ Yahuda, Hirudus ni'e gun kǝ Galili, Filibus esi ni'e gun kǝ Ituriya na Tarakunitas, Lisaniyas ni'e gun kǝ Abiliya. ");
INSERT INTO plj_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ga Hanana na Kayafawo, wi ni'e kiri mǝn keri bar ju ɗiri Yam gwa. Yam shirǝm na Yohana nya Zakariya gip lǝpe. ");
INSERT INTO plj_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Tǝ kop atl kǝ bi ɓula Urdun kup, tǝ pii wazu mbarǝm dǝ wu za warwat pitǝn gǝzǝnka, wu kop Yam dǝ pi wur batisma dǝ Yam pǝni wur warwat pitǝn gǝzǝnka. ");
INSERT INTO plj_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Untun ar ra na rǝshi gip tǝlankur kǝ mǝn yari shirǝm kǝ Yam Ishaya nan tǝ wule, << Yar kǝ gon den latǝn bi gip lǝpe, <Kǝrkǝmi ni Babom guntǝp tu kan tii kop gwa, ta'i tǝni ngoyi guntǝp gǝs ka. ");
INSERT INTO plj_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Laa'ini dindika kup, tatlni kiri tlǝndǝrka kan kǝ ngash ni heli tlǝnɗǝrka kup. Dǝ ta guntǝp tu kan ra na ngoyi gwa, kan dǝ kǝrkǝm gurgǝzǝk guntǝpka ar mbuni. ");
INSERT INTO plj_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Mbarǝm kup baa shin kandatu kan Yam pǝni wur warwat pitǝn gǝzǝnka gwa.>>> ");
INSERT INTO plj_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Yohana shin mbarǝm na womti den ɗirtǝn kar ti, kǝ dǝ tǝ pi wur batismawo ar ni tǝ wul wur'e, <<Kǝn badǝr kǝ wonzi! Won matl kǝn den kǝ kǝtǝrini lo kǝ Yam mǝn ɗirtǝnu? ");
INSERT INTO plj_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Pini argon tu ba shin dǝ wule kǝ ci atl gam wu gwa. Ba kǝ wulni tor gip mbatl gin'e, Ibǝrahimo baa gǝmi ni da'a. domici a yari ine, Yam ra na iko tǝ tlii Ibǝrahim mimir gip tat ju. ");
INSERT INTO plj_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Tare ne bi ndal den gǝs kin wi. Kup kin tu kan gǝr ho mimir dawo, ba wotlka dǝ laka gip utu.>> ");
INSERT INTO plj_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Kan womti mbarǝm ju ba wul ti'e, <<Unun mi pi ituwi?>> ");
INSERT INTO plj_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Tǝ bali wur tǝ wule, <<Muntu kup kan ra na lulur ropo, naa tǝ bi muntu kan ra nari da gwa nǝm, muntu na fingal ma naa tǝ pi untu.>> ");
INSERT INTO plj_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Mǝn nǝmi wurpi bom ɗir pa dǝ Yohana pi wur batisma, wu wul ti'e, << Ba mǝn Kulci, unun mi piwe?>> ");
INSERT INTO plj_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Tǝ wul wur'e, <<nǝm ni argon tu kan mǝn bǝn wule dǝ nǝm gwa katl.>> ");
INSERT INTO plj_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Mǝn bi utu ma wu ɗir wu wule, <<mǝn ngapo unun mi piwe?>> Ar ni tǝ wul wur'e, <<Ba kǝ getl ni mbarǝm den wu bi'in wurpi da'a, wi ni wu bi'in da ngapo ba kǝ ne wur ni lar te gam ka da'a. Nǝm ni ɓatltǝn gin na mbatl nǝm.>> ");
INSERT INTO plj_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nan mbarǝm den ɓuti na zoti ger kan wu den pǝni tor gip mbatl gǝzǝn den'e, <<Ko Yohana ni'e Almasihu yi?>> ");
INSERT INTO plj_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Kan Yohana ba wul kup gǝzǝn'e, <<Amo a ne in den pi batisma na male, gon ra kan nar manǝm gwa den ɗirtǝne, muntu kan zap kaptǝlan gǝs ma a kǝm pǝtli da'a. Ti pi in batisma na Ruhu kǝ Yam na utu esi. ");
INSERT INTO plj_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Tǝ ra na matanƙadi gǝs am da ti, ti ɗǝli gam oka, tǝ shot gesi su ɓindi da tika, kǝptiyi ngapo ti kerika na utu tu kan ba mǝsh da gwa.>> ");
INSERT INTO plj_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Na dǝli kǝm jen na womti, Yohana pi mbarǝm wazu kǝ zo shirǝmi. ");
INSERT INTO plj_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ama Yohana matl Hirudus gun kǝ bǝni, na pǝni Hirudiya gǝr kǝ mǝn bari gǝs Filibus, na wani bar jen na womti kan tǝ pi gwa. ");
INSERT INTO plj_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Den kariwo kan Hirudus ba li ari ka, kan tǝ wule dǝ nǝm Yohana dǝ ɓal ti. ");
INSERT INTO plj_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Nan pi mbarǝm kup batismawo, kan ba pi Yesu pa'e, nan ti den shirǝm na Yamo, ar ni yam ɓuli. ");
INSERT INTO plj_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ruhu kǝ Yam ba sur dlǝr den ti na dli wule kǝ kuɓuri. Kan yar gon ba ɗǝl sur yam ba wule, <<Ki ni'e nya gǝni, muntu kan A ndu ti gwa, mbatl gǝn ba ghol naar nan ki.>> ");
INSERT INTO plj_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu nǝm mbap gǝs kǝ kulci na pi wazuwo, ba shin wule tǝ ri sheti ghon hauya nǝm na kutl na gǝri wi. Mbarǝm pali tǝka wule nya Isubu ni, nya Heli. ");
INSERT INTO plj_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli nya Matat, Matat nya Lawi, Lawi nya Malki, Malki nya Yanna, Yanna nya Isubu, ");
INSERT INTO plj_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Isubu nya Matatiya, Matatiya nya Amos, Amos nya Nahum, Nahum nya Azaliya, Azaliya nya Najaya, ");
INSERT INTO plj_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Najaya nya Ma'ata, Ma'ata nya Matatiya, Matatiya nya Shimeya, Shimeya nya Josek, Josek nya Yahuda. ");
INSERT INTO plj_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yahuda nya Yowanan, Yowanan nya Refaya, Refaya nya Zarubabel, Zarubabel nya Sheyeltiyel, Sheyeltiyel nya Niri. ");
INSERT INTO plj_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Niri nya Malki, Malki nya Addi, Addi nya Kosama, Kosama nya Almadama, Almadama nya Er, ");
INSERT INTO plj_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er nya Joshuwa, Joshuwa nya Eliyazar, Eliyazar nya Yorim, Yorim nya Matat, Matat nya Lawi, ");
INSERT INTO plj_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lawi nya Simiyon, Simiyon nya Yahuda, Yahuda nya Isubu, Isubu nya Yonam, Yonam nya Eliyakim. ");
INSERT INTO plj_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakim nya Malaya, Malaya nya Mainana, Mainana nya Matata, Matata nya Natan, Natan nya Dauda, ");
INSERT INTO plj_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dauda nya Jesse, Jesse nya Obida, Obida nya Bo'aza, Bo’aza nya Salmon, Salmon nya Nashon. ");
INSERT INTO plj_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nashon nya Amminadab, Amminadab nya Aram, Aram nya Hasruna, Hasruna nya Parisa, Parisa nya Yahuda, ");
INSERT INTO plj_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yahuda nya Yakub, Yakub nya Ishaku, Ishaku nya Ibǝrahim, Ibǝrahim nya Tera, Tera nya Nahor ");
INSERT INTO plj_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor nya Serug, Serug nya Reyu, Reyu nya Peleg, Peleg nya Eber, Eber nya Shela ");
INSERT INTO plj_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shela nya Kenan, Kenan nya Arfakshad, Arfakshad nya Shem, Shem nya Nuhu, Nuhu nya Lamek ");
INSERT INTO plj_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek nya Metusela, Metusela nya Enok, Enok nya Yared, Yared nya Mahalalel, Mahalalel nya Kenan, ");
INSERT INTO plj_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan nya Enosh, Enosh nya Shitu, Shitu nya Adamu, Adamu nya Yami. ");
INSERT INTO plj_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu pal sur ɓula Jodan laa'i na Ruhu kǝ Yami, ar ni Ruhu kop nan ti rǝn gip lǝpka, ");
INSERT INTO plj_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","lastu tǝ pi muri hauya rop tǝ ci argon da'a, nan wu pawo kan guzum ba ci ti. Ar ni Shetan, gun dun itǝr, ɗir kar ti kǝ dǝ tǝ kem ti ndetǝne. ");
INSERT INTO plj_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Tǝ wul Yesu'e, <<In ki nya Yam no, wul tat ju'e wu dǝm bǝredi?>> ");
INSERT INTO plj_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ar ni Yesu nǝmi ti tǝ wule, <<Ar ra na rǝshi gip shirǝm kǝ Yam'e, <Mbarǝm ba mani dǝmi na ci burodi katl da'a.>>> ");
INSERT INTO plj_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Bartuwo, kan Shetan ba te ti den tlyari las goni, kan tǝ gode ti bǝn kǝ duniya kup wule gip njipkǝr gere. ");
INSERT INTO plj_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Kan tǝ wul ti'e, <<Aa bi'i mulki na kirtǝn gǝzǝnka kup gwanni, wu bin kawi. A mani bi kup muntu kano a adu'i ti bi gwa. ");
INSERT INTO plj_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ki ni kǝ ngus cina dam kǝ bim nartǝno, ar ba dǝm ge.>> ");
INSERT INTO plj_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu wul ti'e, <<Ar ra na rǝshi, ɗǝɗa Babom Yam gi, ti ni nangǝs ki bi ti nartǝni>> ");
INSERT INTO plj_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Kano Shetan ba si ti gip bǝn Urushalima, kan tǝ kem ti tǝ dlǝr to den gam Bom kǝ Yam kan to den Yam nar gwa, tǝ wul ti'e, <<In ki nya Yam no, ɓo tuma su atl ka. ");
INSERT INTO plj_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ar ra na rǝshi'e, <Yam ba wul mǝn kartǝn gǝs'e wu ga ki hoyi, ");
INSERT INTO plj_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","eso, wi nǝm ki gip am gǝzǝni, ki nda kǝ ɓo asǝm gika den tat da'a.>>> ");
INSERT INTO plj_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ar ni Yesu nǝmi ti tǝ wule, <<Shirǝm kǝ Yam wule, < dǝ kǝ gode Babom Yam gi da'a.>>> ");
INSERT INTO plj_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nan Shetan pa'i godetǝn gǝs kupo, ar ni tǝ ndara tǝ za Yesu, kǝ dǝ tǝ ɓut zo pǝt goni. ");
INSERT INTO plj_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesu pal gip atl kǝ Galili, iko kǝ Ruhu kǝ Yam ra nan ti. Ar ni shirǝm den ti ri gip bǝni kǝ bi atli kup, ");
INSERT INTO plj_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","kano tǝ nǝm kulci mbarǝm gip bom kumi shirǝm kǝ Yam gǝzǝni, ar ni mbarǝm pita yari zo shirǝm den ti. ");
INSERT INTO plj_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","<<Ruhu kǝ Babom Yam ra na demǝni, tǝ zǝzarǝm kǝ dǝ a yar zo shirǝm kǝ Yam dǝ munju kano am ri wur kar da gwa. Tǝ karǝm kǝ dǝ a yar shirǝm kǝ ɗǝli munju kan ra na ɓali gwa, kano a ɓuli ger munju kano tabini gwa. Dǝ za munju kano jen pi wur hoyi da gwa. ");
INSERT INTO plj_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Kǝ dǝ a yari gin kǝ guna ger kǝ Babom Yami.>> ");
INSERT INTO plj_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ar ni tǝ kucum tǝlankuri ka, kan tǝ bi mǝn mbap kǝ bom kumi shirǝm kǝ Yami, kano tǝ dǝm gǝs atli. Ger kǝ mbarǝm kup ngapo ar ra den ti, wu nǝm shini gǝsi. ");
INSERT INTO plj_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ar ni tǝ wul wur'e, <<Se kǝno, argon tu shirǝm kǝ Yam yariwo ar laa'i wi den ger gi ni.>> ");
INSERT INTO plj_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Munju kup kan ra lasiwo, wu yar ho shirǝm den ti, kan wu nǝm bi na am na shirǝm mǝn tǝmtǝn kano tǝ yari gwa, wu wule, <<Muntuwo nya Isubu ni diya?>> ");
INSERT INTO plj_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ar ni Yesu wul wur'e, <<A momi ki yarim shirǝm kolɗa bitu ba yari gwa'e, <Mǝn bi uni, warke gam gi>, ki wulǝm es'e, <Pi mi argon tu kan kǝ pi su gip Kaparnahumka gwa.>>> ");
INSERT INTO plj_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ar ni Yesu wul wur ra'e, <<A yari in ge shirǝmi, tǝ ci cina na shirǝm tǝ wule, <<ba nǝm shirǝm kǝ mǝn yari shirǝm kǝ Yam gib bǝn gǝs da'a.>> ");
INSERT INTO plj_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","<Na ho bi ni a yari ine>, <<gin tu kano mǝn yari shirǝm kǝ Yam Iliya rawo, munju kano kos gǝzǝn mǝshka gip Israilawo, wu womti, gini ni pi watlǝn myakan na kyar mukka ghon nda da'a, kano ba pi guzum na nari gip atli. ");
INSERT INTO plj_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ama Yam kar Iliya kar ko nǝm gǝzǝn da'a, ar ni Yam kar ti kar guri gon gip bǝn Zarifat kan ra gip atl kǝ Sidon gwa. ");
INSERT INTO plj_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Eso, mǝn ndǝcci jen ra na womti gip Israila, wokoci kǝ mǝn yari shirǝm kǝ Yam Elisha. Kup na untuwo, nǝm gǝzǝn gon ra kan Yam warke ti ndǝcci gǝska gwa da'a, se mbarǝm nǝm. ti ni'e Na'aman ba mǝn Suriya, muntu kan Yam warke ti ndǝcci gǝska gwa.>> ");
INSERT INTO plj_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Kup mbarǝm ju kan ra gip bom kumi shirǝm kǝ Yamiwo, lo ci wur nan wu kum shirǝm kǝ Yesu gwa. ");
INSERT INTO plj_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ar ni wu tlyam dlor, kano wu ɗǝli Yesuka kar bǝni, kan wu te ti den bi zhiki tu kan tu bǝn gǝzǝn dene gwa. Wu ndu'e wu byal ti tǝ nda su atl ka. ");
INSERT INTO plj_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ama Yesu kop gip wuri kan tǝ ndara won gǝsi. ");
INSERT INTO plj_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Kano Yesu ba ndara Kaparnahum bǝn gon gip kǝ Galili, kan tǝ kulci mbarǝm den pǝt shukutǝni. ");
INSERT INTO plj_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ar ni kulci gǝsi dlǝkǝn mbarǝme, den shirǝm gǝs ra wule kǝ gunye. ");
INSERT INTO plj_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Gip bom kumi shirǝm kǝ Yamo, mbarǝm gon ra mǝn dun itǝri, ar ni tǝ la yar hoyi tǝ wule, ");
INSERT INTO plj_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","<<Wayi! Ununu ghun ki nam mi, Yesu kǝ Nazarat? Kǝ ɗir ni kǝ dǝ kǝ pa'ika nam mi ya? A mom ki woni, ki ni'e muntu ɗǝl sur kar Yam gwa!>> ");
INSERT INTO plj_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Kano Yesu ba matl dun itǝri, tǝ wul ti'e, <<Yoni ɗǝl ter gip mbarǝm tuka!>> Kan dun itǝri ba byal ti atl cina dǝ mbarǝm ju kan ra lasi gwa, kan dun itǝri ba ɗǝlka gip mbarǝmi tǝ pi ti argon da'a. ");
INSERT INTO plj_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Kano mbarǝm kǝ lasi kup ba nǝm bi na ame, wu wul ezǝn'e, <<Unu ndǝri shirǝmi utu untu? Tǝ wul dun itǝr'e wu ɗǝl gip mbarǝmka, kano wu ɗǝli.>> ");
INSERT INTO plj_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Argon tu kan Yesu piwo, ar ni kem mbarǝm nǝm yari shirǝm den ti gip atli kup. ");
INSERT INTO plj_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu ɗǝl gip bom kumi shirǝm kǝ Yami kan tǝ ndara bom dǝ Siman. Nakon kǝ Siman ra hoyi da'a, tǝ den kumi dli hoyi. Kan wu lir Yesu, dǝ tǝ warke ti. ");
INSERT INTO plj_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ar ni tǝ ri dlǝr su gam da tika, kan tǝ matl kumi dliyi den tǝ za ti. Ar ni ar za ti, kan tǝ tlyam na zhotǝne, tǝ turi wur fingal tǝ bi wuri. ");
INSERT INTO plj_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nan pǝt nda bino, kup munju kan ra na berǝm na mǝn kan ra hoyi dawo, ar ni wu ɗir wur kar Yesu. Kan Yesu ba ne am gǝs den wur na nǝm nǝm den badǝr kumi dli ju ba ghun wur gwa, kan wu warke. ");
INSERT INTO plj_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Untu ni'es dun itǝr ɗǝlka gip mbarǝm na womti, wu den la'i yare, wu den wultǝn'e, <<Ki nya Yam ni!>> Ar ni Yesu matl wur tǝ wule, ba wu shirǝm da'a, den wu momi ti ni'e Almasihu. ");
INSERT INTO plj_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Nan bar tlowo, kan Yesu ba za lasi, tǝ ri gǝs las tu kan mbarǝm ra hoyi da gwa. Kano mbarǝm ba ngen ti ba ngen ti. Nan wu zam tiwo, ar ni wu ndu'e tǝ i ri las gon'es da'a. ");
INSERT INTO plj_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Kan tǝ wul wur'e, <<Ar nǝmǝn te yarka a ri yari mbarǝm zo shirǝm kǝ zo dǝmi cina dǝ Yam gip bǝni jeni, den untuni karǝm suri.>> ");
INSERT INTO plj_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Kan Yesu ba nǝm pi wazu gip bom kumi shirǝm kǝ Yam kǝ mǝn Yahuda. ");
INSERT INTO plj_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Gasi gon kan, Yesu ra bi ɓula Jenesaratawo, mbarǝm na womti ra kar ti, wu den kumi shirǝm kǝ Yami. ");
INSERT INTO plj_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ar ni Yesu shin kungǝlǝn jikat mal rop bi ɓula'i, mǝn nǝmi kos ni za lasi, wu den ho'i bar kǝ nǝmi kos gǝzǝnka. ");
INSERT INTO plj_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Kano Yesu ba to gip kungǝlǝn jikat mal kǝ Siman, nǝm gip mǝn nǝmi kos ju, kan tǝ wul ti'e tǝ dǝl ti te gip malika njem. Ar ni tǝ dǝm gipi. Kan tǝ kulci mbarǝme. ");
INSERT INTO plj_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nan tǝ pa'i shirǝmo, ar ni tǝ wul Siman'e, <<Te kungǝlǝn jikat mali kǝ ba dlyami male, kan kǝ la bar kǝ nǝmi kos gi kǝ dǝ kǝ nǝm kose.>> ");
INSERT INTO plj_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ar ni Siman wul ti'e, <<Babomi, mǝ pa mi kǝ gas kup ɗewi, ko nǝm mǝ nǝm argon da'a, kup na untu, tun kan kǝ yari untuwo, naa la bar kǝ nǝmi kosi suka.>> ");
INSERT INTO plj_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Nan wu la bar kǝ nǝmi kosi sukawo, kan wu nǝm kos na womti, ar kem bar kǝ nǝmi kos gǝzǝn ba nǝm tlyattǝnka. ");
INSERT INTO plj_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Nan wu shin untuwo, kan wu yiɓǝti ezǝn am kan ra gip kungǝlǝn jikat mali gon gwa, dǝ wu ɗir ne wur amra, nan wu ɗiro, ar ni wu la'i kungǝlǝn jikat mali kup pa rop, bar tuwo kungǝlǝn jikat mal gǝzǝn ba nǝm sitǝnka gǝs male na giɓǝrtǝn kǝ womti kose. ");
INSERT INTO plj_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Nan Siman Bitrus shin untuwo, ar ni tǝ ngus cina dǝ Yesu, tǝ wul ti'e, <<Za ǝm kǝ ndara, Babomi, ami mǝn warwat pitǝn ni!>> ");
INSERT INTO plj_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Siman na berǝm nǝmi kos gǝs kupo, ar dlikǝn wur den womtitǝn kǝ kos ju kan wu nǝm unju gwa. ");
INSERT INTO plj_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Untun ga Yakubu na Yohana, mimir kǝ Zabadi, berǝm mbap kǝ Siman ar dlǝkǝn wur pa'e. Kano Yesu ba wul ti'e, <<Ba kǝ kum bǝrti da'a, cina ɗewo mbarǝm ni ki nǝmi.>> ");
INSERT INTO plj_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ar ni wu dǝl kungǝlǝn jikat mal gǝzǝn tor den bishidi, wu za kup bar ju wi ra nari gwa, kan wu kop ti. ");
INSERT INTO plj_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Nan Yesu ra gip bǝn gono, mbarǝm gon ra kan ndǝcci ci ti narka gwa. Nan tǝ shin Yesuwo, ar ni tǝ nda cina da ti na ba ger gǝs su atlka tǝ lir ti tǝ wule, <<Babomi, in kin kǝ ndu'o ki mani warke gǝni.>> ");
INSERT INTO plj_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Kano Yesu ba ta am gǝs tǝ ne den ti, tǝ wul ti'e, <<A ndu'i, da'i warke!>> Ar ri kǝti gon da'a arni ndicciyi za ti. ");
INSERT INTO plj_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Pi untuwo, ar ni Yesu wul ti'e, <<Ba kǝ yari murgon da'a! Ama ri kar ga Lǝɓa kǝ Yam wu shin ki, kan kǝ bi bar ju kan Musa wule dǝ bi kǝ bi ho'i ndǝccika gwa, untu ni mbarǝm ba shin ki kǝ'i na ndǝcci da'a.>> ");
INSERT INTO plj_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Kup na untuwo, ar ni shirǝm den ti kǝrkǝm ritǝn gip barǝm ra, kan mbarǝm na womti ba nǝm ɗirtǝn kar ti kǝ dǝ wu kum ti, kan tǝ warke munju kan ra hoyi da gwa. ");
INSERT INTO plj_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Yesu ngapo tǝ kur ri gǝs las ju kan mbarǝm ra hoyi da gwa kǝ dǝ tǝ shirǝm na Yami. ");
INSERT INTO plj_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Gasi gon kan Yesu ra den kulci mbarǝmo, ar ni mǝn Parise na mǝn kulci mbarǝm doka kǝ Musa, munju kan ɗǝl ɗir gip mir bǝn kǝ Galili kup na kǝ Yahudiya na gip bǝn Urushalima ra njon njon lasi. Iko kǝ Babom ra nan ti kǝ dǝ tǝ warke mbarǝme. ");
INSERT INTO plj_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Kan mbarǝm jen ba ɗir na gon kan itǝr tle tika gwa ra ɓom den ba muri gǝsi, wu ndu te gǝs gip bom las tu kan Yesu ra gwa. ");
INSERT INTO plj_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Wu zam tǝp da'a, nan mbarǝm womtika gwa, ar ni wu to den rupi kǝ bomi kan wu tul shu wu ne mbarǝmi suka gip dlom kǝ mbarǝm ju den bamuri gǝs cina dǝ Yesu. ");
INSERT INTO plj_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Nan Yesu shin ngǝshtǝn gǝzǝn den yam untuwo, ar ni tǝ wule, <<Berǝm, ho'i i warwat pitǝn gi kawi.>> ");
INSERT INTO plj_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Untu piwo, ar ni mǝn Parise na mǝn kulci mbarǝm doka kǝ Musa nǝm wultǝn gip mbalt gǝzǝni wu wule, <<Unu mbarǝmi ikǝn mǝn mburi Yam we? O fawo, Yam ni nan gǝs ba ho warwat pitǝnka da'a ya?>> ");
INSERT INTO plj_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Nan Yesu mom unun wu den damtǝn denewo, ar ni tǝ wul wur'e, <<Unun kem kǝ damkǝn untu rawu? ");
INSERT INTO plj_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Gongeni ban mani, dǝ wule, <Ho warwat pitǝn gi kawa,> ko dǝ wule <Tlyam kǝ ndarawe?> ");
INSERT INTO plj_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ama kǝdǝ kǝ mom'e, Nya Mbarǝm ra na iko kǝ dǝ tǝ ho warwat pitǝnka gip duniya ni.>> Ar ni tǝ wul mbarǝm tu kan itǝr tle ti kayi gwa, <<Tlyam kǝ pǝn ba muri gi kǝ ndara bomi!>> ");
INSERT INTO plj_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Bar tuwo, arni tǝ tlyam dlor cina dawuri, tǝ pǝn ba muri gǝs cina da wuri kan tǝ ndara bomi tǝ den ɗǝɗa Yami. ");
INSERT INTO plj_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ar dlǝkǝn ko gonge mbarǝme kan wu ɗǝɗa Yami. Gip bǝrti na dlǝkǝntǝn wu nǝm wultǝn'e, <<Mǝ shin bar kǝ dlǝkǝntǝnwi se kǝni.>> ");
INSERT INTO plj_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Den kar kǝ untuwo, ar ni Yesu ɗǝli kan tǝ shin mbarǝm gon mǝn nǝmi wurpi bom kan ba wul ti'e Lawi gwa, tǝra njon kǝ ba nǝmi wurpi bomi. Ar ni Yesu wul ti'e, <<Kopǝni!>> ");
INSERT INTO plj_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Kan Lawi ba tlyam tǝ za bar ju kup tǝ ra nari gwa kan tǝ kop ti. ");
INSERT INTO plj_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Kano Lawi ba pii Yesu bar nyel bom da ti. Lasiwo mǝn nǝmi wurpi bom na womti, na mbarǝm jen ra lasi den ci bar kǝ ci nan wuri. ");
INSERT INTO plj_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ama mǝn Parisa na mǝn kulci mbarǝm doka Musa nǝm zhe'e shirǝmi, wu wul mir mǝn kulci kar ti'e, <<Ununu kem kǝn den ci na tle na mǝn nǝmi wurpi bom na mǝn warwat pitǝn rawu?>> ");
INSERT INTO plj_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ar ni Yesu nǝmi wur tǝ wule, <<Munju kan ra hoyi ni ba ngen mǝn bi un da'a. Ama munju kan ra hoyi da gwani ba ngen mǝn bi uni. ");
INSERT INTO plj_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","A sur gip duniya kǝn kǝ dǝ a labi mǝn ho pitǝn da'a, ama mǝn warwat pitǝne dǝ wu za warwat pitǝn gǝzǝnka. >> ");
INSERT INTO plj_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Kano jen ba wul Yesu'e, <<Mir mǝn kulci kar Yohana ba pi guzum mal na shirǝm na Yam ko gǝgasi, untuni es mir mǝn kulci kar mǝn Parise ba pi, ama gewo wu den ci na tle.>> ");
INSERT INTO plj_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Kano Yesu ba nǝmi wur tǝ wule, <<Kǝ shin wule ki hane berǝm kǝ mǝn pel gudlumi ci bar kǝ cika wi nǝra na mǝn pel gudlumi gwa ya? ");
INSERT INTO plj_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ama pǝt baa ɗir kan ba pǝn mǝn pel gudlumi tuka kar wuri. Gip muri ja ni wi pi guzum male.>> ");
INSERT INTO plj_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Kan tǝ pa yari wur misali goni, tǝ wule, <<Murgon ra kan ba tlyati nye yadi den pel lulur kan tǝ bop den gusi da'a. Ti ni tǝ pi untuwo, ti tlyati pel lulur gǝs ka, peli tu kan tǝ bop den gusi lulur tuwo ar ba mbun da'a. ");
INSERT INTO plj_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Untu ni esi, murgon ba shoti pel mal kin inabi su gip kor ranka da'a. Ti ni tǝ pi untuwo, pel mal kin inabi tu ba tatl ran juka kan ar shotka, rani eso ar lika ituwi. ");
INSERT INTO plj_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Untuni da'a, pel mal kin inabiwo dǝ shot ti gip pel rani. ");
INSERT INTO plj_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Murgon ra kan ba ndu'e tin tǝ tla gus mal kin inabiwo, kan tǝ pal tǝ tla peli ra da'a, ti wule < gusiyi njet nari.>>> ");
INSERT INTO plj_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Gasi gon den pǝt Asabar pǝt shukutǝni, tǝ den kopi gip kǝn gerowo, ar ni mir mǝn kopi gǝs nǝm ceni gam gero wu den wumi wu den ci gesi. ");
INSERT INTO plj_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Kan mǝn Parisa jen ba wul ti'e, <<Unun kem kǝ pi argon tu kan Doka gǝmi ba ndu dǝ pi da gwa den pǝt Asabar?>> ");
INSERT INTO plj_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ar ni Yesu nǝmi wur tǝ wule, <<A, kǝ shin ni gip tǝlankur da'aya? Argon tu gun Dauda pi nan guzum nǝm ti tǝ na berǝm ritǝn gǝs gwa. ");
INSERT INTO plj_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Nan tǝ te gip bom kǝ Yami, tǝ pǝn zo bǝredi kǝ Yam tu kan ba pǝn da gwa tǝ ci, kan tǝ bi berǝm ritǝn gǝs, muntu kan ar hoyi tǝ ci da'a, bar Lǝɓa kǝ yam ni ba ci katl gwa>> ");
INSERT INTO plj_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ar ni tǝ wul wur'e, <<Nya Mbarǝm ni'e Babom kǝ Asabar.>> ");
INSERT INTO plj_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Gasi gono den Asabar, tǝ te gip bom kumi shirǝm kǝ Yami tǝ den kulci. Mbarǝm gon ra teka muntu kan itǝr tle ti am shimlika gwa. ");
INSERT INTO plj_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ar ni mǝn momi na kulci mbarǝm shirǝm kǝ Yam na mǝn parise wi ti gere, wu shin imnu ti warke ti gas Asabar zan wu ri ti cina den'e tǝ jikat doka kǝ Musa kawi. ");
INSERT INTO plj_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yesu ngapo, tǝ mom damtǝn gǝzǝnka. Arni tǝ wul muntu itǝr tle tǝ amika gwa, <<Tlyam kǝ ɗir dlǝr cina ɗe!>> Ar ni tǝ tlyam tǝ ri dlǝr lasi. ");
INSERT INTO plj_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yesu wul wur'e, <<A ɓa tambe ine, unu dlat pitǝn ni ba pi gas shukutǝni, ho pitǝn na ko wani? Dǝ ɗǝli mbarǝm ma ko dǝ retl tika?>> ");
INSERT INTO plj_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Kan tǝ wi kup gǝzǝn gere, tǝ wul mǝri'e,<< ta am gi>>. Tǝ ta ami, ar ni am gǝs pal hoyi. ");
INSERT INTO plj_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ama lo ci wur hoyi, kan wu nǝm damtǝn den argon tu wi pi Yesu gwa. ");
INSERT INTO plj_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Gasi gon gip muri juwo, Yesu to den tlǝndǝr kǝ shirǝm na Yami, tǝ ci gas tǝ den shirǝm na Yami. ");
INSERT INTO plj_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Bar tlowo, tǝ labi mir mǝn kopi gǝsi, tǝ ɗǝli kutl cet rop gip wuri, tǝ pali wur wu dǝm mǝn kulci kar ti. ");
INSERT INTO plj_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Wi ni'e, Siman, muntu tǝ ne ti sun'e Bitrus gwa, na esi Andarawus, na Yakubu, na Yahaya, na Filibus, na Bartalamawus, ");
INSERT INTO plj_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","na Matiyu, na Toma, na Yakubu nya Halfa, na Siman, muntu ba wul ti'e Zaloti gwa, ");
INSERT INTO plj_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","na Yahuda nya Yakub, kan na Yahuda Iskaryoti muntu ɗir la'i Yesu gǝs Yam gwa. ");
INSERT INTO plj_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ar ni tǝ ɗǝl sur nan wur kǝ ba ngǝlan lasi. Mbarǝm na womti nǝm kopi gǝsi. Eso mbarǝm na womti ɗǝl ɗir gip atl kǝ Yahudiya, na Urushalima, na ba atl kǝ Taya na Sidon, munju kan bi bar ɓula gwa. ");
INSERT INTO plj_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Wu ɗir kǝ kumi gǝsi wu ndu tǝ warke wur gip arjen ju ba ci wur gwa, munju dun itǝr ba ghun wuro tǝ ɗǝlii wurka. ");
INSERT INTO plj_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Mbarǝm kup den ndu'i ne am den ti, nan iko kǝ Yam den ɗǝltǝn ter gip ti gwa, tǝ warke wur kup. ");
INSERT INTO plj_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu bal ti den mǝn kopi gǝs tǝ wule, <<Kǝn mǝn albarka ni, kǝn kan na argon da gwa, Yamo gun gin ni. ");
INSERT INTO plj_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Kǝn mǝn albarkani kǝn mǝn kumi guzum kǝkǝni cina ɗewo tu gin ba la'i, kǝn mǝn albarkani kan den kulu kǝkǝn gwa, ki gyatli. ");
INSERT INTO plj_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Kǝn mǝn albarkani mbarǝm ni ba nge in gwa wu ɗǝli inka, wu zage ine, wu wule kǝn mǝn ɗasi tuni den kǝn mǝn kopi Nya Mbarǝm ni. ");
INSERT INTO plj_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Pini ghol mbatli, in untu ni zam kǝn gwa, dlar ni kǝ pini ghol mbatli, zo ɓatltǝn gin ra to kar Yamka, untun kori gǝzǝn pi mǝn yari shirǝm kǝ Yam kan sur cina da in gwa. ");
INSERT INTO plj_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ar ba dǝm bar kǝ guna den kǝne, kǝn kan na bar kǝ am kǝkǝn gwa, kǝ kum tǝmi gin ituwi. ");
INSERT INTO plj_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ar ba dǝm bar kǝ guna den kǝne, kǝn kan tu gin la kǝkǝn gwa, cina ɗewo guzum ba ci ine. Ar ba dǝm bar kǝ guna den kǝne, kǝm kan den gyatl kǝkǝn gwa, ki pi dun mbatl kǝ kuli! ");
INSERT INTO plj_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ar ba dǝm bar kǝ guna den kǝne, kǝn kan kǝ cir kar mbarǝm gwa, untun kori gǝzǝn pi munju cen lar'e wi mǝn yari shirǝm kǝ Yam ni gwa. ");
INSERT INTO plj_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","<<A yari ine, kǝn mǝn kumi gǝni, nduni mǝn nge gini, pini munju ba ndu kǝn da gwa ho bari. ");
INSERT INTO plj_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","La'ini mǝn yari bes shirǝm den kǝn albarka, liri ni mǝn ghuni gin Yami. ");
INSERT INTO plj_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Murgon ni la'i in ankayama den gǝskǝmo bali ti gǝskǝmi gon esi, muntu nǝmi'i bar lulur kawo, tus kǝ gipi kǝ bi tǝka. ");
INSERT INTO plj_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Muntu liri i baro bi ti, muntu zote i bar kawo ba kǝ ngen tǝ pali'i da'a. ");
INSERT INTO plj_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Pi ni mbarǝm bar ju kan kǝ ndu'e wu pi in gwa. ");
INSERT INTO plj_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","In kǝ ndu mǝn ju ba ndu kǝn katlo, akon ki zam albarka? Mǝn warwat pitǝn ba ndu mǝn ndu'i gǝzǝn pa'e. ");
INSERT INTO plj_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kǝn ni kǝ pi ho bar munju ba pi'in katlo, im ni ki zam albarka? Untun mǝn warwat pitǝn ba pi pa'e. ");
INSERT INTO plj_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Munju ba mani ɓatli gin ni kǝ bi wur asǝm yam katlo im ni ki zam albarka rawu? Mǝn warwat pitǝn ma wu bi asǝm yam mbarǝme kǝ dǝ pali wur untu. ");
INSERT INTO plj_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Kǝno ndu ni mǝn nge gi ni, pi wur ni alheri, bi ni asǝm yam ba kǝ la ni mbatl'e ba pali in da'a. Untun ki zam zo ɓatltǝn na nari, kǝn ngapo ki dǝm mimir kǝ Babom Yami. Tiwo mǝn alheri ni kar mbarǝm ju ba goode Yam da gwa, na mǝn ɗasi tu'e. ");
INSERT INTO plj_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Dǝm ni mǝn kumi guna'i wule Ba gin mǝn kumi guna'i. ");
INSERT INTO plj_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ba kǝ shin ni murgon na dun ger da'a, kǝn ma ba shin kǝn nari da'a. Ba kǝ hukunte ni murgon da'a, kǝn ma ba hukunte in da'a. Ho'ini ya'ǝn warwat pitǝn gǝzǝn ka, kǝn ma ba ho'i in gegi ni. ");
INSERT INTO plj_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Bi ni, kǝn ma ba bi ine. Shar na la'i dǝ tǝtǝ'i har ar ba shotka, baa shoti in gip am luluri. Shar tu kǝ bi gipi, gipi ni ba bi ine. ");
INSERT INTO plj_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesu pa yari wur misali gon tǝ wule, <<Tabi ba dǝli esi tabi dlo ya? In tǝ pi untuwo kup gǝzǝn wi nda gip shuka. ");
INSERT INTO plj_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nye mǝn kulci ba man muntu ba kulci ti gwa ya? Ama kup nye mǝn kulci tun pa'iwo, ti dǝm wule muntu ba kulci ti gwa. ");
INSERT INTO plj_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Unun kem kǝ shin nye jir tukan te ger dǝ gon ka kan basi nyash tu te ger da ika kǝ mom nari da'awe? ");
INSERT INTO plj_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Imni ki mani wuli ya'i'e, <Na ɗǝli'i nye jir tukan te ger da'ika gwa,> kan kiwo kǝ nge shini basi nyash tu te ger da'i ka? Ki bes mbarǝme! Ɗǝli basi nyash kǝ ger da'i ka kani, kan kǝ'i shin bar hoyi, kǝ dǝ kǝ mani ɗǝli nye jir tukan te ger dǝ ya'i kagwa.>> ");
INSERT INTO plj_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ho kin ba gǝri wani mimir da’a, untuni es wani kin ba gǝri ho mimir da'a. ");
INSERT INTO plj_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ba mom kin den gǝritǝn gǝsi. Ba kotl nyen den kin ir da'a, ko imbǝr den kin patl gami. ");
INSERT INTO plj_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ho mbarǝmo tǝ pini ho bari, don ho bar ni su gip mbatl da ti ka, ama mǝn ɗasi tu'o, tǝ pini warwat pitǝne don wani barni gip mbatl gǝsi, argon tu su gip mbatl kawo arni bi ba yari. ");
INSERT INTO plj_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Unun kem kǝ wulǝn'e, <Babomi, Babomi> kan kǝ nge pi argon tu a wule kǝ pi gwawu? ");
INSERT INTO plj_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Kup muntu ɗir karǝm tǝ kum argon tu a yari, tin tǝ pi argon tu a wul ti’e tǝ piwo, a yari in unu mbarǝm ni'e ti. ");
INSERT INTO plj_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ti ni wule mbarǝm kan tli kǝ tu'i bomo, ar ni tǝ bor shu na dlyami, tǝ ɓa gǝs kushiyi den tate. Nan ɓula la'iwo, mal ɓula'i sur ɓo bomi, ar jiti ti da’a, don ɓa gǝsi den tate. ");
INSERT INTO plj_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Muntu kup kum shirǝm gǝn kan tǝ pi argon tu a wule tǝ pi da'a, tin wule mbarǝm kan la gǝs bom gǝs hoyi da gwa. Nan ɓula la'i mal sur ɓo bomiwo, ar ni ar yaska kup, ndetǝniwo ar tǝm shini da'a.>> ");
INSERT INTO plj_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Kan Yesu pa'i yari kup argon tu kan tǝ ndu tǝ yari mbarǝmo, ar ni tǝ ndara Kaparnahum. ");
INSERT INTO plj_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Zher kǝ bar mǝn bi utu kǝ Roma den kumi dli, tǝra bi dǝ mǝshtǝni. Bar mǝn bi utu kǝ Romayi ba ndu zher gǝsi nari. ");
INSERT INTO plj_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nan tǝ kum'e Yesu rawo, ar ni tǝ kar kiri kǝ mǝn Yahuda, wu lir ti tǝ ɗir warke zher gǝsi. ");
INSERT INTO plj_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Kiri yi lir Yesu hoyi, wu wule, <<In murgon ra kan ba ndu ne am rawo, mbarǝm tu ni. ");
INSERT INTO plj_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Tǝ ndu mbarǝm gǝmi nari, tini ma tǝ tu'i mi bom kumi shirǝm kǝ Yami.>> ");
INSERT INTO plj_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Kan Yesu ba kop wuri, tǝ dlyam na bom tu kan wuriwi da gwa, ar ni bar mǝn bi utu tu kar berǝm gǝs jen rǝnka, tǝ wul ti'e, <<Babomi, ba kǝ ghun gam gi kǝ ɗirtǝn da'a, amo a kǝm kǝ ɗir lastu kan a dǝm gwa da'a. ");
INSERT INTO plj_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Amo a pali gam gǝn argonni da'a nan a ri kar ki gwa. Untuwo, shirǝme, zher gǝn ba warke. ");
INSERT INTO plj_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ami ma am dǝ jenni ami ra, na mǝn bi utu karǝmi, a wul muntu'e, <Rǝka,> Kan tǝ ri, gon ngapo, <Ɗiri>, Kan tǝ ɗiri, a pa wul zher gǝni'e, <Pi bar kǝni>, Kan tǝ pi.>> ");
INSERT INTO plj_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Nan Yesu kum untuwo, ar ni tǝ nǝm bi na ame, kan tǝ bal ti rǝn den womti mbarǝm ju kan den kopi gǝs gwa, tǝ wule, <<A yari ine, ko gip Isra'ila a zam mǝn la'i Yam mbatl wule muntu wi da'a!>> ");
INSERT INTO plj_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Nan munju kar wuri pal rǝn bomkawo, arni wu zam zheri warke wi. ");
INSERT INTO plj_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ar ri dlyam wi da’a, ar ni Yesu ndara gip bǝn goni, muntu ba wul ti'e Nayin gwa, mǝn kopi gǝs na mbarǝm na womti ndara nan ti. ");
INSERT INTO plj_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Tǝ mbi kosak na bǝdlabǝn tetǝn gip bǝni ituwi, arni tǝ zam mbarǝm pǝn mǝshi mbarǝm ɗirwi, tini nǝm den nase, bakos gǝs mǝsh kawi pa'e. Mbarǝm na womti la ti tǝpe. ");
INSERT INTO plj_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nan Yesu shin tiwo, guna ci ti den ti, arni tǝ wul ti'e, <<Za kulu.>> ");
INSERT INTO plj_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Arni tǝ isha ti teka, tǝ taɓe bar kǝ pǝni mǝshi mbarǝmi, munju den pǝni ngapo kan wu dlǝr kǝ ba lasi. Kan Yesu ba wule, <<Nye moni, a wul ki'e kǝ tlyami!>> ");
INSERT INTO plj_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ar ni mǝshi mbarǝmi tlyami tǝ dǝm njon, kan tǝ nǝm shirǝmi! Yesu ta ti am dǝ mǝn gǝri gǝsi. ");
INSERT INTO plj_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ar ni bǝrti nǝm wur kup gǝzǝn na nari, arni wu nǝm ɗǝɗa Yami, kan wu wule, <<Bar mǝn shirǝm na Yam mbira kar mi wi, sekǝno Yam mom na mbarǝm gǝs wi.>> ");
INSERT INTO plj_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Shirǝm den argon tu Yesu pi gastuwo ar ri kup atl kǝ Yahudiya na atl ju kano ra markǝmi gwa. ");
INSERT INTO plj_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Mir mǝn kulci kar Yohana mǝn Batisma yari ti kup bar ju kan pi gwa. ");
INSERT INTO plj_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ar ni Yohana labi mir mǝn kulci kar ti mbarǝm rop, tǝ kar wur ri kar Babomi ka, tǝ den ndu'i'e tǝ momi ti ni'e mǝn surtǝn tu ya, ko dǝ wu ɓut zuti. ");
INSERT INTO plj_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Nan mbarǝm ju mbu bar kar tiwo, wu wul Yesu'e, <<Yohana mǝn Batismani kar mi kar ki, tǝ ndu'e tǝ momi, <Ki ni'e mǝn surtǝn tuya, ko mǝ ɓut zuti?>>> ");
INSERT INTO plj_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Gip wokoci yi, ar ni Yesu warke mbarǝm na womti munju kan den kumi dli, na arjen ju den ghuni gǝzǝn gwa, na mǝn dun itǝri. Kan tǝ bi ger tabi na womti. ");
INSERT INTO plj_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Arni tǝ wul wur'e, <<Ri yarini Yohana argon tu kǝ kum kan kǝ shin gwa. Tabi den shini bari, munju kan na asǝm da'a wu den desi, mǝn ndǝcci den zami warketǝne, munju kan ba kum da'a wu den kumi, mǝshi mbarǝm den tlyamtǝn lasi, munju am ri wur kar da'a den kumi wazu zo shirǝm kǝ Yami. ");
INSERT INTO plj_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Albarka ra den muntu kan pat asǝmka na sun gǝn da gwa.>> ");
INSERT INTO plj_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Kan mǝn kartǝn kǝ Yohana ndarawo, ar ni Yesu shirǝm na womti mbarǝmi den Yohana, tǝ wule, <<Kǝri gip lǝp kǝ shini unu? Jir jukan itǝr ba jiti gwaya? ");
INSERT INTO plj_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Dawo, unun ri ine? Mbarǝm mǝn la'i bar lulura? Shinni! Munju ba la bar lulur, na dǝmi kǝ kumi tǝmiwo, gip bom kǝ gunni wura. ");
INSERT INTO plj_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Untu da'a, kǝ ri ni kǝ shini unu? Mǝn yari shirǝm kǝ Yam na? Untuni, a yari i'ne, tǝ man mǝn yari shirǝm kǝ Yami. ");
INSERT INTO plj_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ti ni'e muntu rǝsh den ti gwa'e, <Aa kar nye mǝn kartǝn bar gǝn cina da'i, muntu kan baa kǝrkǝmi'i guntǝp gi gwa.> ");
INSERT INTO plj_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","A yari ine, gip munju kan mǝtli gǝriwo, gon ra kan man Yohana nartǝn gwa da'a. Kup na untu, muntu kan'e heli gip mulki kǝ Yamo, tǝ man ti nartǝni.>> ");
INSERT INTO plj_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Nan mbarǝm kup na mǝn nǝmi wurpi bom kum untuwo, ar ni wu nǝm'e Yamo mǝn pitǝn korni, domici Yohana pi wur batisma wi. ");
INSERT INTO plj_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ama Parisawa na mǝn kulci mbarǝm shirǝm tu kan Yam bi Musa gwa, nge argon tu Yam ba ndu nan wur gwa, domici wu nge dǝ Yohana pi wur batisma. ");
INSERT INTO plj_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","<<Na unun a ngash mbarǝm kǝ zhan kǝni, imni wura? ");
INSERT INTO plj_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Wule mimirni wura, munju ba dǝm kǝ ba bar pǝt gwa, wu labi ezǝn, wu wule, <Mǝ hori in mǝzhele, kǝ dlar da'a, mǝ la utu bomi, kǝ kul da'a.> ");
INSERT INTO plj_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ar tu Yohana mǝn batisma ɗiri, tǝ ci burodi da'a, tǝ tla mati shambǝr da'a, kǝ pal kǝ wule, <Tǝ mǝn itǝr ni.> ");
INSERT INTO plj_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nya Mbarǝm ɗir tǝ ci tǝ tla, kǝ pal kǝ wule, <Bar mǝn ci, bar mǝn tle, berǝm kǝ mǝn nǝmi wurpi bom na mǝn warwat pitǝne.> ");
INSERT INTO plj_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Kup na untu, munju kan nǝm hikima kǝ Yam tor gip mbatl gǝzǝno, pitǝn gǝzǝn ba gode'e hikimayi'e ge shirǝmi.>> ");
INSERT INTO plj_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ba Parise gon la tibi kǝ ci bar kǝ ci. Ar ni tǝ ri bom da ti, tǝ dǝm kǝ ba ci fingali. ");
INSERT INTO plj_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Kan nagǝr gon muntu ba pi ho pitǝn da gwa, kum' e Yesu den ci bar kǝ ci rǝn bom dǝ Ba Parise ka, kan tǝ ɗir na zo mbun let mir mǝn tǝmi kasǝri. ");
INSERT INTO plj_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Tǝ dlǝr kar da ti, kǝ ba kar asǝm gǝsi tǝ den kulu. Ar ni lun gǝs shot den kar asǝm gǝsi, tǝ sarka na ta gam gǝsi, tǝ nǝm ɓopi, kan tǝ bǝrkeka na mir mǝn tǝmi kasǝri. ");
INSERT INTO plj_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Gip untuwo, nan Ba Parise tu kan la ti bi shin untuwo, ar ni tǝ dam ti gip mbatl gǝsi, tǝ wule, <<Mbarǝm kǝno mǝn shirǝm na Yamni haro, ti mom unu nagǝr ni'e muntu kan ba ne am den ti gwa, ar tu ti mǝn ho pitǝn ni da'a.>> ");
INSERT INTO plj_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesu nǝmi ti, tǝ wule, <<Saminu, a ndu shirǝm nan ki.>> Ar ni tǝ wul ti'e, <<Malam, yari.>> ");
INSERT INTO plj_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesu wul ti'e, <<Mbarǝm gon ba kop mbarǝm rop wurpi, nǝmo wurpi zangu nantam kǝ zinariya, nǝm ngapo hauya rop na kutl. ");
INSERT INTO plj_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Nan wu mani ɓatli dawo, ar ni tǝ za'i wurka kup gǝzǝn ropi. Gip wuro woni ba ndu ti mani?>> ");
INSERT INTO plj_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saminu nǝmi ti tǝ wule, <<Gip shini gǝno, muntu tǝ za'i ti narika gwa.>> Yesu wul ti'e, <<Kǝ yari dlat.>> ");
INSERT INTO plj_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Nan tǝ bali ger kar nagǝriwo, tǝ wul Saminu'e, <<Kǝ shǝn nagǝr tuya, a ter gip bom gi kǝ bin mal ho'i kar asǝm da'a, tǝwo tǝ shot lun gǝs den kar asǝm gǝni, tǝ sarka na ta gam gǝsi. ");
INSERT INTO plj_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Kiwo kǝ ɓopǝn da'a, tiwo, tun nan a tero, tǝ za ɓopi kar asǝm gǝn da'a. ");
INSERT INTO plj_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Kǝ shotim mir den gam da'a, tiwo, tǝ shotin mir mǝn tǝmi kasǝr den kar asǝm gǝni. ");
INSERT INTO plj_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ra untuwo, a yari'i, wani bar ju tǝ piwo kup pǝni ti kawi, ar ni kem tiwo tǝ pi ndutǝn nari. Ama muntu pǝni ti nye heli wani pitǝnkawo, ndutǝn njem ni tǝ pi.>> ");
INSERT INTO plj_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ar ni tǝ wul nagǝr mǝri'e, <<Pǝni'i wani pitǝn gi kawi.>> ");
INSERT INTO plj_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Munju den ci nan tiwo, wu wul ezǝn'e, <<Muntuwo woni'e ti, mǝn pǝni wani pitǝnkawe?>> ");
INSERT INTO plj_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ar ni Yesu wul gǝri'e, <<La'i Yam mbatl gi ɗǝli iwi, ndara na ghol mbatli.>> ");
INSERT INTO plj_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Den kar kǝ untuwo, Yesu kop gip bǝn jen na bi lǝpe tǝ den pi wazu kǝ zo shirǝm kǝ mulki kǝ Yami. Mir mǝn kartǝn gǝs kutl cet rop ra nan ti, ");
INSERT INTO plj_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","eso mǝtli jen ra nan ɗǝli wur dun itǝr na kumi dli gǝzǝn gwa, Maryamu (nan ba wul ti'e Magadaliya) muntu nan dun itǝr nyingi ɗǝl gip ti gwa, ");
INSERT INTO plj_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yuwana gǝr kǝ Kuza mǝn dlǝri bom kǝ Hiridus gami, Suzana, na mǝtliyi jen'es na womti nan ba ne ga Yesu am ra na bar gǝzǝn gwa. ");
INSERT INTO plj_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Nan mbarǝm na womti den domtǝn, wu den ɗǝltǝn ɗir gip bǝn jen na womti, wu ɗir kar Yesu ar ni tǝ bi wur misali tu, tǝ wule, ");
INSERT INTO plj_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","<<Mǝn kori bar gon ri kǝ ngani badǝr gǝsi. Tǝ gip wi badǝr gǝso ar ni jen ro den tǝpe kan ba desika, kan yatl ba ɗami wu zhingeka. ");
INSERT INTO plj_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Badǝri jen ba ro den goca, nan ar yetlo, kan woli ba landǝrka nan lasi na yari da gwa. ");
INSERT INTO plj_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Badǝri jen ba ro gip ire, kan wu nar tor na badǝri kan iri ba tla badǝrika. ");
INSERT INTO plj_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Jen eso kan wu nda den ho atli, ar ba yetli kan an ba wi ho ge hauya nantam man badǝr tu ngani gwa.>> Nan tǝ yari untuwo, ar ni tǝ tli yar yam tǝ wule, <<Murgon tu na kǝm kǝ kumiwo, tǝ kumi!>> ");
INSERT INTO plj_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Mǝn kopi gǝs tambe ti wu wule, <<Unun shirǝm tu ba yari?>> ");
INSERT INTO plj_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Tǝ wule, <<Momi sǝrri kǝ mulki kǝ Yamo bi'in wi, ama jeno na misalin A shirǝm nan wuri, kǝ dǝ wu zhuwi, wi shin da'a, wu kumi, wi mom da'a. ");
INSERT INTO plj_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","<<Argon tu misali tu ba yari gwa utu, Badǝriwo shirǝm kǝ Yamni. ");
INSERT INTO plj_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Munju den tǝpo wi ni'e munju kan kumi, ar ni Shetan ɗir pǝn shirǝmi gip mbatl gǝzǝnka, kǝ bǝse wu nǝmi wu zam ceto ra. ");
INSERT INTO plj_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Munju ro den gocawo, wi ni'e munju kan nǝm shirǝm kǝ Yam na ghol mbatli nan wu kum gwa, ama wi na tlǝrti da'a, wu nǝm kǝ mir muri njem. Nan godetǝn ɗiro, ar ni wu pal gǝzǝn na kari. ");
INSERT INTO plj_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Badǝr ju ro gip iro, wi ni’e munju kumi, wi gip untuwo ar ni ne mbatl den bar kǝ duniya, ngeni nartǝn na kumi tǝmi tla wurka wu pi hoyi da'a. ");
INSERT INTO plj_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ama badǝr ju ro den ho atlo, wini'e mbarǝm mǝn zo mbatl na ho pitǝn kan kum shirǝm kǝ Yami, wu nǝm na mbatl nǝm wu ɓal mbatl dlom gami, kan wu pi ho bari. ");
INSERT INTO plj_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Murgon ba mbǝsh pitila kan tǝ zupka na bar gal ko tǝ neka gǝs dandi muri da'a, ama ti ne to den ba dǝmi gǝska munju kup ter gipiwo, wu shin cirtǝni. ");
INSERT INTO plj_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Bar gon ra na ghundǝri kan ba ɓulka da gwa, argon ra nan leka kan ba ɓulka ko dǝ ɗǝlika den kari da gwa. ");
INSERT INTO plj_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ngup kǝn ni na kandatu kǝ kumi, don murgon ni ra na baro ba mbǝli ti ra, ama muntu kan na argon dawo, ba nǝmi ti nye argon tu tǝ kum tǝ ra nari gwa.>> ");
INSERT INTO plj_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Arni nasi Yesu na mir ezǝn ɗir kar ti, wu ndu shini gǝsi, ama wu mbu tetǝn kar ti da'a, nan mbarǝm womtika gwa. ");
INSERT INTO plj_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Kan murgon ba wul Yesu'e, <<Nǝna gi na mir ya'ǝn ra dlor te karika wu ndu shini gi.>> ");
INSERT INTO plj_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Tǝ nǝmi, tǝ wule, <<Nǝna gǝn na mir ɓyaro, wini'e munju ba kum shirǝm kǝ Yam kan wu dlǝr dene gwa.>> ");
INSERT INTO plj_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Gasi gono Yesu shirǝm na mir mǝn kopi gǝs tǝ wul wur'e, <<Mǝ teni te bishidiyi mǝnta.>> Arni wu to gip kungǝlǝn jikat mal wu nǝm tetǝne. ");
INSERT INTO plj_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Wu den tetǝn den malo anni Yesu nde umurka. Arni bar itǝr tli ɗir den bar ɓula'i, ar kem mal ba su gip kungǝlǝn jikat mal gǝzǝni wi ra gip hasari. ");
INSERT INTO plj_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Mir mǝn kopi gǝs ba ri putu ti wu wule, <<Babomi! Babomi! Mal bari kǝ tle mi gam kawi!>> Tǝ tlyam tǝ matl itǝri na mal ju den tlitǝn gwa, kan itǝri ba za'i, ko unu ba sa shot. ");
INSERT INTO plj_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Tǝ tambe mir mǝn kopi gǝs tǝ wule, <<Akon ne mbatl gin ra?>> Gip bǝrti na dlǝkǝntǝn hoyi wu tambe ezǝni, <<Woni'e muntu? Tǝ matl itǝr na mal ma kan wu kop shirǝm gǝsi!>> ");
INSERT INTO plj_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Wu nǝm tetǝn gip mali wu mbu bar gip ba las kǝ Garasinawa, muntu kan te bi bar ɓulaka daga Galili gwa. ");
INSERT INTO plj_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Nan Yesu te ɗǝl bi ɓula'iwo, anni tǝ mo na mǝn dun itǝr gon daga gip bǝni, tǝ zam muri na womti wi tǝ la lulur da'a ko tǝ dǝm gip bomi, ama tǝ dǝmni gip shu gam bǝci'e. ");
INSERT INTO plj_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Nan tǝ shin Yesuwo, tǝ la yare kan tǝ nda cina dǝ Yesu tǝ den la'i yar, tǝ den wultǝm'e, <<Ununu kǝ ndu kǝ pi namǝni, Yesu, nya Bar Gun Yami? A lir ki, ba kǝ bin wuya da'a!>> ");
INSERT INTO plj_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Tǝ yari ni untu nan Yesu tare matl dun itǝriwi kǝ dǝ tǝ ɗǝl gip mbarǝmika gwa. Biyi na womti dun itǝr kǝ gip ti ba kem in Mbarǝm ni ɓal ti na zap gǝlla am na asǝm dǝ pal dǝ le tika ma, tǝ kur ngot zap gǝllayika. Dun itǝri ba kur kem ti ritǝn gǝs gip lǝpe. ");
INSERT INTO plj_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu tambe ti tǝ wule, <<Unu'e sun gi?>> <<Womti>> tǝ wul untu, don dun itǝr na womti ra kan te gip ti gwa. ");
INSERT INTO plj_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Wu pi ta liri gǝsi, ba tǝ kar wur wu su gip shu ne dun itǝr da'a. ");
INSERT INTO plj_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Lasiwo alade ra na womti nan den ci bar kǝ ci gǝs tlǝndǝre gwa. Dun itǝri lir Yesu dǝ tǝ za wur wu te gip wuri, anni Yesu nǝmi wuri. ");
INSERT INTO plj_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Nan dun itǝri ɗǝl gip mbarǝmiwo, wu te gip alade yi, kan womti alade ju ba tli na kǝtǝre, wu su ro gip ɓula wu tla mal wu mǝshka. ");
INSERT INTO plj_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Nan mǝn le alade yi shin argon tu piwo, wu ri gip bǝn na bi lǝp na kǝtǝre, wu yari bar tu pi gwa. ");
INSERT INTO plj_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Arni mbarǝm ɗǝl wu ri zhit argon tu pi gwa, nan wu ɗir kar Yesuwo, wu zam mbarǝmi nan dun itǝr ɗǝlka gip ti gwa, tǝra njon cina dǝ Yesu, tǝra na lulur den dli na mbatl nǝm, ar ni bǝrti nǝm wuri. ");
INSERT INTO plj_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Mǝn ju nan shino anni wu yari mbarǝm kanda tu mǝn dun itǝri zam warketǝn gwa. ");
INSERT INTO plj_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Arni kup mbarǝm kǝ atl kǝ Garasinawa wi wul Yesu'e tǝ ndara tǝ za wuri, don bǝrti nǝm wur na nari. Arni tǝ to gip kungǝlǝn jikat mal tǝ ndara. ");
INSERT INTO plj_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mbarǝm tu dun itǝri ɗǝl gip tiwo, tǝ lir Yesu'e ti kop ti, ama Yesu wul ti'e tǝ ndara, tǝ wule, ");
INSERT INTO plj_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","<<Pal rǝn bomka kǝ yari argon tu Yam pi'i gwa.>> Arni mbarǝmi ndara, kan tǝ yari mbarǝm kǝ bǝni kup argon tu Yesu pi ti gwa. ");
INSERT INTO plj_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nan Yesu palo, mbarǝm na womti pi ɗem nan ti, tunkawo wi ni den ɓuti gǝsi. ");
INSERT INTO plj_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Arni mbarǝm gon nan ba wul ti'e Yayirus, gun kǝ bom kumi shirǝm kǝ Yami, tǝ ɗir tǝ ngus cina dǝ Yesu tǝ den liri gǝsi dǝ tǝ ri bom da ti. ");
INSERT INTO plj_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Don nya gǝs nye gǝr nan ne ti nǝm, nye mǝn sheti ghon kutl cet rop, ra bi dǝ mǝshtǝni. Nan Yesu ra den tǝpo, womti mbarǝm tlaa ti nari. ");
INSERT INTO plj_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nagǝr gon gip wur nan bǝran den tatltǝn den ti kǝ sheti ghon kutl cet rop, ama tǝ zam muntu nan ba dlǝrika da gwa. ");
INSERT INTO plj_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Tǝ ɗir tǝp kaar dǝ Yesu kan tǝ taɓe bi lulur gǝsi, bar tu arni shottǝn kǝ bǝran gǝsi dlǝri. ");
INSERT INTO plj_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","<<Woni taɓem we?>> Yesu tambe. Nan kup mbarǝm ju wule wini dawo, arni Bitǝrus wule, <<Babomi, mbarǝm ra na womti nan tlaa ki gwa.>> ");
INSERT INTO plj_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ama Yesu wule, <<Murgon ra taɓe mi, A kum iko ɗǝl gipǝni.>> ");
INSERT INTO plj_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nan nagǝr mǝri shin baa mom ti kawo, arni tǝ ɗir nda cina dǝ Yesu gip dǝdartǝn na bǝrti den ger kǝ mbarǝm ju kup ra lasi gwa, tǝ yar argon tu kem tǝ taɓe Yesu ra gwa, na kanda tu gip lasiwo tǝ warke gwa. ");
INSERT INTO plj_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesu wul ti'e, <<Nya gǝni, la'i mbatl gi warke iwi, ndara na ghol mbatli.>> ");
INSERT INTO plj_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Nan Yesu ra den shirǝmo, arni nye mǝn kartǝn gon ɗǝl ɗir bom dǝ Yayirus, gun kǝ bom kumi shirǝm kǝ Yami tǝ wul Yayirus'e, <<Ba kǝ'i ghun ba mǝn kulciyi da'a, nyayi mǝsh kawi.>> ");
INSERT INTO plj_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Na kumi untuwo, arni Yesu wul Yayirus'e, <<Ba kǝ kum bǝrti da'a, la mbatli ti warke.>> ");
INSERT INTO plj_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Nan tǝ mbu bar bom dǝ Yayiruso, tǝ za murgon kop ti kar te gip bomika da'a, sai ga Bitǝrus, Yohana na Yakub na basi nyayi na nase. ");
INSERT INTO plj_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ngapo, mbarǝm kup ra den la'i yar na kulu mǝshtǝn kǝ nyayi. Yesu wul wur'e, <<Zani kulu, tǝ mǝsh nǝka da'a, umurni tǝ dene.>> ");
INSERT INTO plj_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Arni wu gyatli ti, shini gǝzǝno tǝ mǝsh kawi. ");
INSERT INTO plj_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Kan Yesu ba nǝm am gǝs, tǝ wul ti'e, <<Nya gǝni, tlyami.>> ");
INSERT INTO plj_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ar ni rai gǝs pal gip ti, na zhotǝne kan tǝ tlyam dlor. Arni Yesu wul wur’e wu bi ti fingal tǝ ci. ");
INSERT INTO plj_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ar dlǝkǝn mǝn gǝri gǝsi, ama Yesu dǝli wur kǝm den ba wu yari murgon argon tu pi gwa da'a. ");
INSERT INTO plj_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Arni Yesu labi mir mǝn kartǝn gǝs kutl cet rop wu dom wur kar ti, tǝ bi wur iko kǝ mani pi bar den am gǝsi, wu ɗǝli dun itǝri na warke kumi dlika kup. ");
INSERT INTO plj_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Tǝ kar wur wu pi wazu den Yam ba ndu mi na dǝmi cina da ti, wu pali mǝn kumi dli dlat. ");
INSERT INTO plj_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Tǝ pa wul wur'e, <<Ba kǝ pǝn ni argon kǝ ndaratǝn da'a, ko dlo, ko poshe, ko fingal, ko wurpi. Ba kǝ rǝ ni na lulur rop da'a. ");
INSERT INTO plj_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Kup bom tu nǝm kǝno dǝm ni lasi an ri gastu ki za bǝni gwa. ");
INSERT INTO plj_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Kup bǝn tu nǝm kǝn dawo, kǝn ni kǝ za bǝni wo, bad ni kushka kǝ asǝm ginka zan kǝ honi gam ginka kar wuri.>> ");
INSERT INTO plj_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Arni wu tlyami, kan wu kop bǝn na womti wu den pi wazu zo shirǝm kǝ Yami, wu den warke mbarǝm kup las ju wu ri gwa. ");
INSERT INTO plj_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Nan Gun Hiridus kum bar ju den pitǝno ar ghun ti hoyi, den'e jen den wultǝn'e Yohana kan mǝshka gwani tlyam esi. ");
INSERT INTO plj_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Jen wule Iliyani mbirawi, jen ngapo wu wule nǝm gip mǝn yari shirǝm kǝ Yam kǝ terkani tlyam esi. ");
INSERT INTO plj_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Hiridus wule, <<A kotli gam Yohana mǝn Batisma kawi, kan woni a kum shirǝm ju den ti esi?>> Tǝ ndu'e tǝ shin ti. ");
INSERT INTO plj_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Nan mir mǝn kartǝn bar kǝ Yesu pal ɗiro, wu yari Yesu argon tu kan wu pi gwa. Ar ni ti yem wur tǝ ndara nan wur njil gǝzǝn bǝn tu ba wul ti'e Betsaida gwa. ");
INSERT INTO plj_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Nan womti mbarǝm mom las tu tǝrawo, ar ni wu kop ti, kan tǝ nǝm wuri. Tǝ pi wur shirǝm den zo dǝmi cina dǝ Yami. Tǝ pa warke munju den kumi dli gwa. ");
INSERT INTO plj_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Nan pǝt ba su bino kan mir mǝn kartǝn gǝs kutl cet ropi ba ɗir kar ti wu wul ti'e, <<Za mbarǝmi wu ri gip mir bǝn na bi lǝp ju kan wi zam bar kǝ ci gwa, na las tu wi mur gwa, ɗewo argon ra da'a.>> ");
INSERT INTO plj_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ar ni Yesu wul wur'e, <<Kǝno bi wur ni fingal wu ci.>> Arni wu bali ti wu wule, <<Burodi nantam na kos rop ni katl mǝn ra nari in untu no, mi ri wuri wur kup wu ci.>> ");
INSERT INTO plj_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Mbarǝm ju lasiwo wu pi wule moni zangu kutl kǝ ba lasi nantam 500. Ar ni Yesu wul mir mǝn kartǝn gǝs'e, <<Wul ni mbarǝmi'e wu dǝm atli, wu dom wur hauya rop na kutl-kutl.>> ");
INSERT INTO plj_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Arni mir mǝn kartǝn gǝsi pi den yari gǝsi, wu kem mbarǝm kup wu dǝm atli. ");
INSERT INTO plj_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Kan Yesu ba pǝn burodi nantam na kos rop, kan tǝ la gam yam tǝ goode Ba gun Yami, kan tǝ cetǝli tǝ bi mir mǝn kartǝn gǝs wu bi mbarǝm kup. ");
INSERT INTO plj_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Arni kup gǝzǝn ci den bi tu gǝzǝni! Kan mir mǝn kartǝn gǝs ba yem shar kutl cet rop kǝ munju mbarǝm za gwa. ");
INSERT INTO plj_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Gasi gon Yesu den shirǝm na Yam tǝ nan gǝsi, arni mir mǝn kartǝn gǝs ra kar ti, kan tǝ wul wur'e, <<Mbarǝm ba wule ami woni?>> ");
INSERT INTO plj_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Wu wul ti'e, <<Jen wule Yohana mǝn batisma, jen wule Iliyani, jen ngapo wu wule nǝm gip mǝn shirǝm na Yam jen kǝ terkani pal lasi.>> ");
INSERT INTO plj_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ar ni Yesu wul wur'e, <<Kǝno woni kǝ wulǝm ra?>> Bitrus bali ti tǝ wule, <<Ki ni'e Almasihu kan Yam wule ti kar sur gwa.>> ");
INSERT INTO plj_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Arni Yesu dǝli wur kǝm hoyi den'e ba wu yari murgon shirǝm tu da'a. ");
INSERT INTO plj_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Tǝ pa wul wur'e, <<Ar nǝm ami Nya Mbarǝm te yarka a kum dli hoyi den bar na womti. Kiri mbarǝm na kiri mǝn keri bar ju domi Yam gwa, na mǝn bar momi shirǝm kǝ Yam wi nge mi, kan wu rin e, gip muri myakan ngapo ba tlim lasi.>> ");
INSERT INTO plj_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Arni tǝ wul kup gǝzǝn'e, <<Muntu kan ba ndu kopi gǝno, ti nge gam gǝs kakani, ti nǝm e tǝ kum dli ko tǝ mǝshi den tǝ mǝn kopi gǝn ni se na gǝni, kan tǝ kopǝni. ");
INSERT INTO plj_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kup muntu ba ndu gam gǝso ti i zam da'a. Ngapo muntu nge gam gǝs demǝno ti zam Yam bomi, ");
INSERT INTO plj_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","unu ho bar ni mbarǝm ba zami tin tǝ zam duniya kup kan tǝ zam Yam bom da gwa. ");
INSERT INTO plj_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Muntu kup ba kum sham gǝn na shirǝm gǝno, ami Nya Mbarǝm a kum sham gǝsi gastu a pal sur na nartǝn gǝn, na nartǝn kǝ Ban na mǝn kartǝn kǝ Yam mǝn tsarki kan ɗǝl sur kar Yam gwa. ");
INSERT INTO plj_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Na ho bini A yari ine, jen ra gip kǝn dlor ɗe kan ba mǝsh da gwa se win wu shin zo dǝmi cina dǝ Yami.>> ");
INSERT INTO plj_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Kar dǝ muri wuzupse na yari shirǝm tuwo, kan Yesu ba pǝn Bitrus, na Yohana, kan na Yakubu, ar ni wu to den tlǝndǝr kǝ shirǝm na Yami. ");
INSERT INTO plj_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ti gip shirǝm na Yamo, ar ni bager gǝs canze ka, lulur gǝs ngapo ar cirka gholi tar. ");
INSERT INTO plj_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Arni mbarǝm rop cwat kan wu nda shirǝm nan ti. Mbarǝm ropiwo, wi ni'e mǝn shirǝm na Yam Musa na Iliya. ");
INSERT INTO plj_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Cirtǝn gǝzǝn nge ger kǝ shini nan wu cwat gwa, kan wu nǝm bali iri mǝshtǝn tu ti pi gwa, argon tu Bas ndu gwani'e tǝ mǝsh su Urushalima ka. ");
INSERT INTO plj_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Bitrus na berǝm ritǝn gǝso wu nde umurka. Nan wu putu wu shin cirtǝn kǝ Yesu na mbarǝm rop ju kan dlor kar ti. ");
INSERT INTO plj_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Nan mbarǝm ju ba za lasiwo, katl arni Bitrus nda shirǝm na momi arjen ju tǝ yari da gwa, tǝ wule, <<Babomi, ar hoyi nan mǝn ra ɗe gwa ar ndari dǝ tu mir ba shukutǝn myakan, nǝm ge, nǝm ngapo kǝ Musa kan nǝm kǝ Iliya.>> ");
INSERT INTO plj_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Tǝ le bi gǝs kawi da'a arni dun yam le wurka, nan ar le wur kawo arni bǝrti nǝm wuri. ");
INSERT INTO plj_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Arni yar ɗǝl sur gip dun yam tǝ wule, <<Muntuwo nya gǝn ni, muntu a zǝzari gwa. Kum ti ni!>> ");
INSERT INTO plj_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Nan shirǝmi pawo, arni wu shin Yesu ni dlor nan gǝsi. Mir mǝn kopi Yesu ngapo wu yon gǝzǝn top, wu yari murgon bar ju wu shin gip muri ju gwa da'a. ");
INSERT INTO plj_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kan bar tlowo, Yesu na mǝn kopi gǝs wi myakan ju ɗǝl sur den tlǝnɗǝro, anni mbarǝm na womti zam Yesu. ");
INSERT INTO plj_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Anni mbarǝm gon gip womti mbarǝm ju labi Yesu, tǝ wule, <<A lir ki ba mǝn kulci, kum guna kǝ nya gǝn tu, ti ni katl tǝ nem ra. ");
INSERT INTO plj_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Dun itǝr ba te gip ti, tǝ kem ti la'i yar katl untu. Dun itǝri ngapo tǝ kur ɓo ti dli gǝs den dǝdartǝni, kan dǝ bi gǝs ɗǝli hukǝtkǝte. Tǝ nǝra nan ti, gasjen gasjen ni tǝ za ti, tǝ kumi tǝ dli hoyi. ");
INSERT INTO plj_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","A lir mǝn kopi gi dǝ wu ɗǝli ti, ama wu mani da'a.>> ");
INSERT INTO plj_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Arni Yesu nǝmi ti tǝ wule, <<Kǝn mbarǝm kǝ zhan kǝni munju ba la mbatl da gwa, mǝn utu tu'e gigasini a dǝm nan kǝne, kan a mani na pitǝn gin juwe? Ɗiri nyayi ɗe.>> ");
INSERT INTO plj_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nyayi den ɗirtǝn ituwi kan dun itǝri ba byal ti atli, kan dli gǝs ba nǝm dǝdartǝni. Ama Yesu mbatl itǝri, tǝ ɗǝl gip ti, kan tǝ pali bǝbayi nya gǝsi. ");
INSERT INTO plj_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Kup mbarǝm ju kan ra lasi nǝm bi na ame, wu den shini nartǝn kǝ Yami. Mbarǝm ju kup gip nǝmi bi na am ijuwi den argon tu kup tǝ pi gwa, ar ni tǝ wul mǝn kopi gǝs'e, ");
INSERT INTO plj_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","<<Ba kǝ mǝsǝni nǝka na argon tu kan a yari gwa da'a, baa balin kar ami Nya Mbarǝme dǝ la'ǝm am dǝ mbarǝme.>> ");
INSERT INTO plj_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Wi ngapo wu mom gǝs kǝ shirǝmi da'a. Ghundǝri wur nǝka bǝse wu momi. Wi ngapo bǝrti ci wur kǝ dǝ wu tambe gǝs kǝ shirǝmi. ");
INSERT INTO plj_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Arni shirǝm tli gip mǝn kopi gǝs den'e woni baa dǝm bari gip wuri. ");
INSERT INTO plj_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu mom damtǝn gǝzǝni, arni tǝ pǝn heli nya goni, tǝ neti markǝm dati. ");
INSERT INTO plj_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Tǝ wul wur'e, <<Kup muntu nǝm heli nya tu gip sun gǝno, amin tǝ nǝmǝni, kup muntu nǝmǝn ngapo, tǝ nǝm ni muntu karǝm sur gwa. Muntu kan tini’e heli gip kǝn kup ti ni’e bari.>> ");
INSERT INTO plj_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yohana nǝmi ti tǝ wule, <<Babomi, mǝ shin murgon den ɗǝli itǝr gip sun gi, mǝn ngapo mǝ wul ti'e tǝ za'i, tiyo gip min ti ra da'a.>> ");
INSERT INTO plj_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Arni Yesu wul wur'e, <<Za tǝni, muntu ba shin kǝn na dun ger dawo gegin ni.>> ");
INSERT INTO plj_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Gip untuwo, muri mbirawi kǝ paltǝn gǝs to yam kawo, tǝ kurgǝs hoyi dǝ ti su Urushalima. ");
INSERT INTO plj_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Tǝ kar mbarǝm jen dǝ wu kur ri gip nye bǝn gon gip Samariya kǝ dǝ wu kǝrkǝmi ti lasi. ");
INSERT INTO plj_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ama wu nge ti nan wu shin tǝ bǝtl gam Urushalima gwa. ");
INSERT INTO plj_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Nan mir mǝn kartǝn gǝs ga Yakubu na Yohana shin untuwo, arni wu wule, <<Babomi, kǝ ndu'e mǝ labi utu sur yam ar ker wur kaya?>> ");
INSERT INTO plj_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Kan tǝ bal ti den wur tǝ mbatl wuri. ");
INSERT INTO plj_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Kan wuri gip nye bǝni goni. ");
INSERT INTO plj_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Wu den ritǝno, arni mbarǝm gon wule, <<Aa kop ki kup lastu kǝ ri gwa.>> ");
INSERT INTO plj_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu wul ti'e, <<Kusum na shu gǝzǝni, yatl kǝ to yamka na bin gǝzǝni, ama Ami Nya Mbarǝmo ami ra na ba muri da'a.>> ");
INSERT INTO plj_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Tǝ wul gon'e, <<Kopǝni.>> Arni mbarǝmi wule, <<Babomi, za'ǝm a ri kap bǝba gǝn kani.>> ");
INSERT INTO plj_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Kan tǝ wul ti'e, <<Za mǝshi mbarǝm wuri kap mǝshi mbarǝm gǝzǝni, kiwo ri la icǝn kǝ zo dǝmi cina dǝ Yami.>> ");
INSERT INTO plj_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Gon ngapo tǝ wul ti'e, << Aa kop ki Babomi, in ki za'ǝm a pali bi mǝn bom gǝn kakan gwa.>> ");
INSERT INTO plj_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Arni Yesu wul ti'e, <<Kup mbarǝm tu bǝtl am gǝs den yitta tlawo, ti tǝ bali ger karo tǝ ndar tetǝn gip bom kǝ Yam da'a.>> ");
INSERT INTO plj_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Gip untuwo Babom Yesu ɗǝli mbarǝm jen hauya myakan na kutl cet rop. Tǝ kar wur rop-rop dǝ wu kur ri gip bǝn ju na kup lastu tǝ ri gwa. ");
INSERT INTO plj_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Tǝ wul wur'e, <<Rishi kǝni nari, mǝn rǝshi ngapo njem ni wura, untuwo shirǝm ni na Yam ba mǝn kǝni, ti kar mǝn rǝshi jen ra ɗiri wu rǝshi ti kǝni. ");
INSERT INTO plj_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Nɗarani, ar tu a kar kǝn wule mir tǝm gip dlom mamale. ");
INSERT INTO plj_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ba kǝ pǝn ni posh wurpi, ko posh wi bar da'a, ko kaptǝlaye. Shirǝmini murgon den tǝp da'a. ");
INSERT INTO plj_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Bom tu kup kǝ te gipiwo pareni wul tǝn'e, <Dǝ muri mbatl kǝ Yam te gip bom kǝni.> ");
INSERT INTO plj_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","In mǝn muri mbatl ra gipiwo, muri mbatl gin ba kop ti. In ar ra dawo, ar ba pal kar kǝne. ");
INSERT INTO plj_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Dǝm ni gip bomi cini kǝ tlani argon tu kup wu bi in gwa, mǝn mbap ndar ɓatltǝne, ba kǝ kop ni bom-bom da'a. ");
INSERT INTO plj_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Kup bǝn tu kǝ te gipi wu nǝm kǝno, cini argon tu wu ne cina da in gwa. ");
INSERT INTO plj_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Warkeni munju den kumi dli gip lasi gwa, wul wur ni'e wokoci kǝ dǝ Yam dǝm Gun gin mbirawi. ");
INSERT INTO plj_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Bǝn tu kup kǝ te gipi wu nǝm kǝn dawo, kopni guntǝp kǝ gip bǝni, wul ni'e, ");
INSERT INTO plj_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","<Ar pa den kǝni, kushka kǝ bǝn gin kan nǝmi mi asǝmka ma mǝ bati in bargin wi, kup na untu, mom ni'e wokoci kǝ dǝ Yam dǝm Gun gin mbira wi.> ");
INSERT INTO plj_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","A yari ine, gas metǝn na Yamo guna baa ci Ba-Gun Yam den Sodom man bǝn kǝni.>> ");
INSERT INTO plj_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","<<Kashto gi Korasinu! Kashto gi Betsaida! Dǝ wule gip Taya na Sidon ni pi bar kǝ dlǝkǝntǝn kanda tu pi gip kǝn gwa, na wu ci atl gam terka wi, wu la lusguru wu den wi mudlǝr sur gami. ");
INSERT INTO plj_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Den pǝt kǝ gǝniwo Yam ba shin guna kǝ Taya na Sida man kǝne. ");
INSERT INTO plj_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ki Kaparnahum ngapo ɗǝɗa gi to yamkan baa pi ya? Ko nǝm, kaar ni ba pali'i dǝ ri'i kǝka, las tu mǝshi mbarǝm ba kum dli gwa.>> ");
INSERT INTO plj_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Tǝ wul mǝn kopi gǝs'e, <<Muntu kum argon tu kǝ yariwo tǝ kumǝn wi, untuni muntu nge ino, tǝ ngem ni, ama muntu ngemo tǝ nge ni muntu karǝm sur gwa.>> ");
INSERT INTO plj_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Wi hauya myakan na kutl cet ropi pal ɗir na ghol mbatli wu wule, <<Babomi, dun itǝr ma wu kumi mi bi gip sun gi!>> ");
INSERT INTO plj_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Tǝ wul wur'e, <<A shin Shetan, Gun dun itǝr den ndetǝn sur wule ci bi kǝ Yami. ");
INSERT INTO plj_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Kum ni, a bi in iko nan ki des ici na indǝri. Eso, a bi in kup iko kǝ tle gam kǝ Gun dun itǝri, warwat bar gon ba zamkǝn da'a. ");
INSERT INTO plj_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Kup na untuwo ba kǝ pini ghol mbatl dene'e dun itǝr ra atli da in da'a, ama pini ghol mbatli, sun gin ra na rǝshi to yamka.>> ");
INSERT INTO plj_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Gip untuwo, Yesu la'i na ghol mbatl hoyi gip Ruhu kǝ Yami, tǝ wule, <<A gode i Bǝba, ba mǝn yam na atli, nan kǝ ghundǝr bar juka dǝ mǝn ceti gam na momi bar, Kan kǝ ɓuli munju kan pali gam gǝzǝn wule mimir ni gwa. Untu ni a gode i Bǝba ar mbuni i ger kǝ pi untu. ");
INSERT INTO plj_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","<<Kup bar juwo Bǝba bin iko den wur wi, murgon ra nan mom ko woni'e nyayi da'a, Bǝbani mom ti nan gǝsi, untu ni esi, murgon mom Bǝbayi da’a nyayini mom ti nan gǝsi na muntu nyayi ndu tǝ ɓuli ti gwa.>> ");
INSERT INTO plj_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Nan wi ra nan gǝzǝno arni ti bal ti kar mǝn kopi gǝsi, tǝ wul wur'e, <<Albarka ra den ger tu shin bar ju kǝ shin gwa. ");
INSERT INTO plj_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","A yari ine, mǝn yari shirǝm kǝ Yam na gun na womti ndu’e wu shin argon tu kǝ shini gwa, wu zam shini da'a, wu pa kum bar ju kǝn den kumi gwa, wu zam kumi da'a.>> ");
INSERT INTO plj_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Gasi gono, bar mǝn kulci mbarǝm shirǝm tu kan Yam bi Musa gwa, tǝ tlyam dlor tǝ kum kǝ bi kǝ Yesu tǝ wul ti'e, <<BaMǝn kulci, ununu aa pi kan a zam rai kan ba pa da gwawe?>> ");
INSERT INTO plj_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ar ni Yesu wul ti'e, <<Unun shirǝm kǝ Yam yari, im nu kǝ momi?>> ");
INSERT INTO plj_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Mbarǝmi wul ti'e, <<Kǝ ndu Babom Yam gi na mbatl gi kup, na damtǝn gi, na ndǝrtǝn gi kan kǝ ndu berǝm dǝmi gi kanda tu kǝ ndu gam gi gwa.>> ");
INSERT INTO plj_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Arni Yesu wul ti'e, <<To ar hoyi, kima pi untu ki mǝsh da'a.>> ");
INSERT INTO plj_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Kan tǝ ndu'e tǝ ho gam gǝso, kan tǝ pa tambe Yesu tǝ wul ti'e, <<Kano woni'e berǝm dǝmi gǝni?>> ");
INSERT INTO plj_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ar'ni Yesu wul ti'e, <<Pi bakos goni tǝ ɗǝl sur Urushalima tǝ su Yeriko, kan tǝ mo na mur mǝn dlǝri den tǝpe, kan wu ɓo ti wu nǝm bar gǝska kup kan wu lati atl wu za ti bi dǝ mǝshtǝni. ");
INSERT INTO plj_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Gip untuwo kan mǝn keri bar ju kan ɗiri Yam gwa tǝ kop ɗir den tǝpi, tǝ ɗir shin ti ɓom atli, tǝ kop markǝmi tǝ ndara. ");
INSERT INTO plj_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Untu ni'es, mǝn mbap gip Bom kǝ Yam ɗiri tǝ shin ti ɓom atlo, arni tǝ kop markǝmi, tǝ ndara. ");
INSERT INTO plj_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Den kariwo arni ba mǝn Samariya gon ɗir lastu mbarǝmi ra gwa, tǝ shin tiwo ar ni guna ci ti den ti. ");
INSERT INTO plj_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Kan tǝ ri kar ti tǝ shoti mal inabi na mir den usu gǝsi, tǝ ɓali tika, tǝ pǝn ti tǝ ne ti den bar kǝm gǝsi, kan tǝ ri ti bom shukutǝn goni tǝ ne ger den ti. ");
INSERT INTO plj_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Bar tlowo kan tǝ yem wurpi dinari rop, kan ti bi bakos mǝn lasi tǝ wul ti'e, <Da'i nem ger den mbarǝm tu, amin a pal ɗiro, argon tu kǝ jili den kar kǝ muntuwo a ɓatl ki.>>> ");
INSERT INTO plj_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Kan Yesu ba tambe ba mǝn momi shirǝm kǝ Yami, tǝ wul ti'e, <<Kǝkǝno gip mbarǝm myakan juwo, kǝ kum wule woni'e berǝm dǝmi kǝ muntu tu kan mur mǝn dlǝri den tǝp ju ɓo ti gwa wu?>> ");
INSERT INTO plj_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Arni kan ba mǝn momi shirǝm kǝ Yami ba wul ti'e, <<Muntu kan shin guna gǝs gwa.>> Arni Yesu wul ti'e, <<Kima ri pi untu.>> ");
INSERT INTO plj_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Nan Yesu na mǝn kopi gǝs ra den tǝp gǝzǝn kǝ sitǝn Urushalimawo, ar ni wu ri gip nye bǝn gon lastu nagǝr gon mǝn tu ba wul ti'e Marta ba nǝm ti bom da ti. ");
INSERT INTO plj_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Tǝ na mǝn gipi gǝs ba wul ti'e Maryamu, muntu dǝm cina dǝ Babom Yesu tǝ den kumi shirǝm gǝsi gwa. ");
INSERT INTO plj_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ama Martawo, pi fingal pǝni ti mbatl kawi, arni tǝ ri kar ti, tǝ wul ti'e, <<Babomi, kǝ shin ni diya mǝn gǝpi gǝn za'ǝm nangǝn ami den pi fingal gwa? Wul ti'e tǝ ri nem am ra.>> ");
INSERT INTO plj_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ar ni Yesu nǝmi ti, tǝ wul ti'e, <<Marta, Marta! Mbatl gi tlikawi, kǝ den damtǝn den bar na womti. ");
INSERT INTO plj_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Bar nǝm ni mbarǝm ba ndu'i. Maryamu pǝn ho bari, baa nǝmi tǝka da'a.>> ");
INSERT INTO plj_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Gasi gon Yesu den shirǝm na Yam rǝn kǝti gonka, nan tǝ pa'iwo, gon gip mǝn kopi kǝ Yesu ba wul ti'e, <<Babomi, kulci mi shirǝm na Yam, kanda tukan Yohana kulci mǝn ju kan ba kop ti gwa.>> ");
INSERT INTO plj_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesu wul wur'e, <<Kǝn ni ki shirǝm na Yamo wul ni'e, <Bǝba, dǝ shin nartǝn kǝ zo sun gi, dǝ mulki gi suri. ");
INSERT INTO plj_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Bi mi fingal gǝmi kǝ se na gǝni ");
INSERT INTO plj_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ho'i mi warwat pitǝn gǝmi ju kan mǝ pi gwa, don mima munju kan pi mi dlat dawo mǝ ho'i wuri. Te mi gip argon tu ba kem mi wani pitǝn gwa da'a.>>> ");
INSERT INTO plj_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yesu wul mǝn kopi gǝs'e ba wule, gon gin na berǝm, ti ri kar ti kǝ dlom gasi ti wul ti'e, <<Berǝm, bim. rance burodi gudǝli myakan ngapi. ");
INSERT INTO plj_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Berǝm gǝn gon ɗǝl kǝ ba ɓomi asǝm kan tǝ kop bom dam kǝkǝn tu ami ngap fingal nem ra nan a bi ti gwa da'a.>> ");
INSERT INTO plj_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Muntu te gipika ngapo ti nǝm ter gip kushi ti wule, ba kǝ ghunǝm da'a! Amiwo, a le bǝdlabǝn kawi, ami na mimir gǝn kup mǝ mur gǝmi atl wi, a mani tlitǝn yam a bi'i argon da'a. ");
INSERT INTO plj_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Na yari ine, da ma ti tlyam tǝ bi ti argon den ti berǝm gǝs ni dawo, ti tlyam tǝ bi ti ko mǝnen tǝ ndu'i sabo nan sham ci berǝm gǝsi nan pi ta liri gǝs da gwa. ");
INSERT INTO plj_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","<<A yari ine, pini ta liri ba bi ine. Ngen ni ki zami, pini ta ɓe bǝdlabǝni, baa ɓuli ine. ");
INSERT INTO plj_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Muntu kup liri, baa bi ti. Muntu kup ngeno ti zami, untu ni muntu kup ɓo bǝdlabǝno ba ɓuli ti. ");
INSERT INTO plj_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Gon ra gip kǝn in nya gǝs ba liri ti kos kan tǝ bi ti ici gwa ya?>> ");
INSERT INTO plj_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ko dǝ nya gǝs liri mbutl kan tǝ bi ti indǝri we? ");
INSERT INTO plj_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kǝn mǝn ɗasi tu ma kǝ mom mbuni bar ju ki bi mimir gino, balle Ba gin kǝ to yamka, ti bi Ruhu kǝ Yami mǝn ju kan lir ti gwa. ");
INSERT INTO plj_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yesu den ɗǝli dun itǝr mǝn bǝtli lǝka gip mbarǝm goni, nan dun itǝri ɗǝlo ar ni mbarǝmi shirǝme, kan mbarǝm na womti ba pi mamaki, ");
INSERT INTO plj_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","jen eso, wu wule, Yesu ɗǝli ni dun itǝr tu na iko kǝ Ba'alzabu gun dun itǝri. ");
INSERT INTO plj_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Jen ngapo, wu ndu'e wu gode Yesu, arni wu wul ti'e, tǝ pi bar kǝ dlǝkǝntǝn kan mbarǝm baa shin'e Yam ra nan ti gwa. ");
INSERT INTO plj_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yesu mom mbatl gǝzǝni, arni tǝ wul wur'e, <<Kup mulki tu tatl rop kan den shini bes kǝ ezǝno, ar ba dlǝr da'a. Untuni bom ni tatl bomi rop wu den shini bes kǝ ezǝno ar ba yas ka. ");
INSERT INTO plj_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Shetan ni tatl rop kan tǝ den shini bes kǝ gam gǝso, imni mulki gǝs ba ndǝr rawu? Kǝ wule na iko kǝ gun dun itǝr ni a ɗǝli wani itǝri. ");
INSERT INTO plj_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ami ni a ɗǝli wani itǝr na Ba'alzabulo, kano mǝn kopi gino na iko kǝ woni wu ɗǝli itǝri? Untuwo, mir mǝn kopi gin ni ba nǝm kǝn na shirǝm den bar ju kǝ yari gwa. ");
INSERT INTO plj_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ami ni ngap a ɗǝli wani itǝr na iko kǝ Yamo, mulki kǝ Yam suri in ituwi. ");
INSERT INTO plj_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ndǝri mbarǝm ni dlǝri bom gǝs gam kan tǝ ɓut hoyiwo, argon ba zam bar kǝ bom gǝs da’a. ");
INSERT INTO plj_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Murgon ni ndǝr man ti kan tǝ ɗir ndati na dlan ngapo, ti man ti tǝ nǝmi ti bar kǝ dlan gǝska kup kan tǝ la mbatl dene gwa, kan tǝ bi jenka. ");
INSERT INTO plj_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Muntu ne dli demǝn dawo tǝ ngen ni, muntu kan nem am gip domi dawo ti ni den gǝzanyika.>> ");
INSERT INTO plj_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","<<Dun itǝrni ɗǝlka gip mbarǝmo, ti pi ta nǝtltǝn kǝ ba las tu mal ra da gwa, kǝ dǝ tǝ ngen ba shukutǝni, tin tǝ zam dawo ti wule a pal rǝn gip mbarǝm tu kan a ɗǝl ɗir gwa, ");
INSERT INTO plj_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","tin tǝ pal ɗir kan tǝ zam sar lasi kawi pal kǝrkǝmi kawo, ");
INSERT INTO plj_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ti pa ri yem dun itǝr jen wi nyingi munju kan manti ɗasi tu gwa kan wu ɗir wu dǝm kǝ ba lasi den kar kǝ untuwo pa’i dǝmi kǝ mbarǝm tu ba man kǝ lai gǝsi wantǝni.>> ");
INSERT INTO plj_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Nan Yesu yari untuwo, arni nagǝr gon gip womti mbarǝmi lati bi, tǝ wul ti'e, <<mǝn albarka ni'e nǝna tukan gǝr ki tǝ luki kan kǝ nar gwa!>> ");
INSERT INTO plj_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yesu nǝmi ti tǝ wul ti'e, <<Albarka mani nartǝn den munju ba kum shirǝm kǝ Yam kan wu kop gwa!>> ");
INSERT INTO plj_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Nan mbarǝm dom wur es na womtiwo, arni Yesu wule, <<Mbarǝm kǝ zhan kǝno mǝn ɗasi tuni, wu den ndu'i shini alama, ngapo wi zam shini alama gon da'a in kǝ Yunana mǝn shirǝm na Yam ni da gwa. ");
INSERT INTO plj_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ar nǝra wule Yunana kan dǝmi mǝn Neneba alama gwa, untu ni Nya Mbarǝm ba dǝmi zhan kǝni. ");
INSERT INTO plj_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Gas metǝn na Ba-Gun Yamo, gun kǝ Sheba gǝr mǝtli, ti tlyam na mǝn zhan kǝni, argon tu tǝ piwo ti byal wur atl den argon tu wu pi gwa. Don tǝ ɗilni ɗir bango kǝ duniya kǝ dǝ tǝ shin momi bar kǝ Solomon. Shin ni, muntu man Solomon nartǝn gwan kǝni. ");
INSERT INTO plj_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Gas metǝn na Ban-Gun Yamo, mbarǝm kǝ Neneba ba tlyam na mbarǝm kǝ zhan kǝni wi byal wur atl den wu ci atl gam na wazu kǝ Yunana. Shin ni, muntu kan man Yunana nartǝn gwan kǝn ɗe. ");
INSERT INTO plj_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Murgon ba la utu den pitila kan tǝ ghundǝrika su shu ka, ko tǝ ghupka na bar gal da'a. Ama ti ne to den ba dǝmi gǝska munju te gip kushiyiwo wu shin bari. ");
INSERT INTO plj_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ger'e pitila kǝ dli, in ger gi hoyi no, ki shin bar hoyi. In ger gi ngap hoyini dawo, kup dli gi ba la'i na dǝmǝni, ki shin bar hoyi da'a. ");
INSERT INTO plj_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ɓa shini, cirtǝn tukan den kiwo dǝmǝn ni da'a, ");
INSERT INTO plj_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","dli gi ni kup la'i na cirtǝn es dǝmǝn ra kǝti gon dawo, ar ba bi cirtǝn las kup kandatu kan pitila ba bi'i cirtǝn gwa.>> ");
INSERT INTO plj_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Nan Yesu pa'i shirǝmo, ar ni ba Parise gon la tǝ bi kǝ dǝ wu ci fingali, kan Yesu te gipi, tǝ dǝm kǝ ci fingali. ");
INSERT INTO plj_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ar dlǝkǝn ba Pariseyi nan tǝ shin Yesu dǝm kǝ ci fingali tǝ ho amka da gwa. ");
INSERT INTO plj_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Babom Yesu ngapo ar ni tǝ wul ti'e, <<Kǝn Parisawawo, kǝ ho kar gal ka, na wuro male, gipi ngapo, kǝn ra laa'i na te ger den bar kǝ mbarǝme na ɗasi tu'e. ");
INSERT INTO plj_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Kǝn kǝdlǝme, o fawo muntu pi kariwo, ti'es ni tǝ pi gipi diya? ");
INSERT INTO plj_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Kǝn ngapo, bar ju kan kǝn ra nari kupo, bi ni munju kan am ri wur kar da gwa, arni ki cir cina dǝ Yami. ");
INSERT INTO plj_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","<<Kashto gi ni, kǝn Parisawa, ar tu kǝ ɗǝli zakka kǝ ga bucumbu na mbǝlci na wol oro kup, ngapo kǝ pi ho bar na ndu'i Yam da'a. Munju ni mbun'e kǝ pi bat na wi mǝnja ka. ");
INSERT INTO plj_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","<<Kashto gi ni, kǝn Parisawa, kǝ ndu dǝ bi in zo ba dǝmi te cina gip ba kumi shirǝm kǝ Yamka, eso, kǝ ndu dǝ shirǝmi in gip bar pǝte. ");
INSERT INTO plj_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Kashto gini, don kǝn nǝra wule gam-bǝci kan ne ti tat da'a, munju mbarǝm ba desi na momi gǝzǝn da gwa.>> ");
INSERT INTO plj_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Arni gon gip mǝn kulci mbarǝm shirǝm tu Yam bi Musa gwa nǝmi ti tǝ wule, <<Mǝn kulci, ki ni kǝ yari untuwo besini kǝ yari mi.>> ");
INSERT INTO plj_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Arni Yesu nǝmi ti tǝ wule, <<Kashto gin pa'e kǝn mǝn kulci mbarǝm shirǝm tu kan Yam bi Musa gwa, kǝn ni kǝ bi mbarǝm gos gam ju kan man yar gǝzǝn gwa, kǝn na gam gin ngapo kǝ ne wur am ra da'a! ");
INSERT INTO plj_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","<<Kashto gini, don kǝn ni kǝ tu gam-bǝci kapi mǝn yari shirǝm kǝ Yami, munju kano ga gigi gin ni ri wur eka gwa. ");
INSERT INTO plj_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kǝn ra na momi'e, na ndu'i gin ni arjen ju ga gigi gin pi gwa wini wu ri wur’e kan kǝn den tu'i gam-bǝci gǝzǝni. ");
INSERT INTO plj_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ar ni kem Yam gip momi bar gǝs wule, <A kari wur bar suka na mǝn yari shirǝm kǝ Yami na mir mǝn kartǝn kǝ Yesu, wi ri jen eka, wu pal wu tlat jeni.> ");
INSERT INTO plj_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Untuwo bǝran kǝ mǝn yari shirǝm kǝ Yam kup ju kan shoti tun ne gǝs kǝ duniya, ar kop mbarǝm kǝ zhan kǝno ba pali in yare. ");
INSERT INTO plj_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Tun den bǝran kǝ Habila ar ɗir den kǝ Zakariya muntu kan ri ti eka dlom ba keri bar ju kan ɗiri Yam na las mǝn tsarki. Hoyi ni a yari ine, kup ar ba kop rǝnka den mbarǝm kǝ zhan kǝni. ");
INSERT INTO plj_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","<<Kashto gini, kǝn mǝn kulci mbarǝm shirǝm tu Yam bi Musa gwa, den kǝ pǝn bar kǝ ɓuli ilimika kǝn na gam gin ngapo kǝ te gipi da'a mǝn ndu'i tetǝn ngapo kǝ za wur wu te da'a. >> ");
INSERT INTO plj_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Nan Yesu za lasiwo, kan mǝn kulci mbarǝm shirǝm kǝ Yam na Parisawa wu nǝm tlati gǝs hoyi wu den lo'i gǝs kǝ dǝ tǝ yar bar na womti, ");
INSERT INTO plj_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","wu den ndu'i'e wu kemi ti gam gǝs male. ");
INSERT INTO plj_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Gip untu nan mbarǝm na womti dom wur na nari har wu den desi ezǝno, arni Yesu pii shirǝm mir mǝn kopi gǝs kakani tǝ wul wur'e, <<Pini kula na yisti kǝ mǝn Parisa mǝn se mbarǝme. ");
INSERT INTO plj_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Argon ra na zupi kan ba ɓulka da gwaya, eso argon ra na ghundǝri kan ba mom da gwaya? ");
INSERT INTO plj_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Untuwo kup argon tu kǝ yari muriwo ba ɗǝl kari. Argon tu kǝ yari mol ko gip kushi tukan kǝ le bǝdlabǝn gamkawo ba yari den gam kushi. ");
INSERT INTO plj_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","<<Kǝn ga berǝm gǝni, a yari ine, ba kǝ kumni bǝrti kǝ munju baa ri dli eka gwa da'a, den kar kǝ untuwo wi’i mbu pi argon dene da gwa. ");
INSERT INTO plj_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Aa yari in muntu ki kum bǝrti gǝs gwa. Kumni bǝrti kǝ Yami muntu kan tin tǝ ri dli ekawo tǝ ra na iko tǝ laa kǝn te utuka gwa. Ge shirǝm ni a yari ine, ti ni ki kum bǝrti gǝsi. ");
INSERT INTO plj_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","<<Ba wur mir yatl nantamka den kabarshu rop diya? Kup na untu, Yam mǝsǝnika na ko nǝm gǝzǝn da'a. ");
INSERT INTO plj_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Untuni kup ta gam gino na dlǝmi ni ar ra. Untuwo, kumni bǝrti da'a, kǝ man mir yatl na womti daraja. ");
INSERT INTO plj_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","<<A yari in esi, kup murgon tu shedem cina dǝ womti mbarǝmo, ami Nya Mbarǝm ma aa shede ti cina dǝ mǝn kartǝn kǝ Yami. ");
INSERT INTO plj_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Muntu ngap kan nge momi gǝn cina dǝ mbarǝmo, ami ma a nge momi gǝs cina dǝ mǝn kartǝn kǝ Yami. ");
INSERT INTO plj_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Kup muntu pi shirǝm mburtǝn den ami Nya Mbarǝmo, ba ho'i ti wani pitǝn gǝska, ama kup muntu ngap pi mǝgǝn shirǝm den Ruhu kǝ Yamo, ba ho'i ti wani pitǝn gǝska da'a. ");
INSERT INTO plj_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Wi ni wu ɗir kǝn gip bom kumi shirǝm kǝ Yami ko cina dǝ mǝn hukuntetǝne ko cina dǝ mǝn bǝno, ba dǝ tǝp ɗǝli gam gin ko unun ki yari ghun kǝn ni da'a. ");
INSERT INTO plj_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ruhu kǝ Yam ba kulci in argon tu ki yari wokociyi gwa.>> ");
INSERT INTO plj_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Arni murgon gip womti mbarǝm wul Yesu'e, <<Ba mǝn kulci, wul erǝm gǝn'e tǝ bim bar gado gǝn kan bǝba gǝmi mǝsh za'i mi gwa.>> ");
INSERT INTO plj_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesu nǝmi ti tǝ wule, <<Mbarǝme, woni nem mǝn tloyi shirǝm ko mǝn rabe in bar ju kan Bǝba gin mǝsh za'i in gwawe?>> ");
INSERT INTO plj_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Tǝ ci cina na shirǝmi tǝ wul wur'e, <<Lurani, dlyam ni na ndu'i barka na nari. Ho dǝmiwo ar dǝm den domi bar na nari da'a.>> ");
INSERT INTO plj_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Arni tǝ bi wur misali goni, tǝ wule, <<Pi mbarǝm gon mǝn bar kǝ ame, tǝ zam bar nar den kǝn gǝsi, ");
INSERT INTO plj_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","tǝ wul gip mbatl gǝs'e, <Ununu a pi we? Ami ra na las tu kan a ne bar kǝ kǝn gǝnka gwa da'a.> ");
INSERT INTO plj_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Tǝ wule, <Argon tu a piwo, a tatl ɓindi gǝnka, kano a tu jen kiri, gipini a ne bar kǝ kǝn gǝnka na bar ju kup kan a zam gwa. ");
INSERT INTO plj_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Kan a wul gam gǝn'e, Kira na bar na womti kan ki neka ar ri'i sheti ghon na womti gwa. Shukuyi gam gi, kǝ pi ta ci kǝ pi ta tle, ki den kumi tǝmi.> ");
INSERT INTO plj_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ama Yam wul ti'e, <Ki kǝdlǝme! Gip gas kǝn ni kii mǝshi, bar ju kǝ domo kǝ woni ar ba dǝm we?>>> ");
INSERT INTO plj_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Untuni ar ba dǝmi muntu kan domi gam gǝs bar kǝ am gwa, tǝra na argon es cina dǝ Yam da'a.>> ");
INSERT INTO plj_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ar ni Yesu wul mǝn kopi gǝs’e, <<Untu fawo a yari ine, ghun ni gam gin den dǝmi gin da'a, fingal gini, ko bar kǝ la'i kǝ dli gini. ");
INSERT INTO plj_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Rai man fingali, dli ngap ar man tutul dli. ");
INSERT INTO plj_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Shin ni ghanrati, wu ngani da'a, wu rǝsh da'a, wu ra na ba ne barka ko ɓindi da'a, kup na untuwo Yam ba bi wur fingali, daraja gin ngap ar man kǝ yatl na womti! ");
INSERT INTO plj_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Woni gip kǝn gip ghuntǝn gǝso, ti mani ɓiti awa nǝm ra den muri gǝswe? ");
INSERT INTO plj_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Kǝnni kǝ mbu pi nye heli bar untu dawo, unun kem nami bar jen ba ghun kǝne? ");
INSERT INTO plj_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Shin ni buzǝn kin kǝ gip lǝpe kanda tu wu nar gwa, wu pi mbap da'a ko wu dlǝmi gam gǝzǝn luluri, kup na untuwo, a yari ine, ko Solomon kan gun ni na nartǝn gǝs ma tǝ taɓe la'i mbuni tutul dli wule kǝ nǝm gip wur da'a. ");
INSERT INTO plj_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","In untuni Yam pi jir kǝ gip lǝpe na mbuntǝni munju ra sekǝni gǝniwo kan dǝ ker wur ka, bare kǝne, kǝn mǝn heli ngǝshtǝn den Yami. ");
INSERT INTO plj_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ba kǝ lani mbatl den bar ju ki ci ko ki tla gwa da'a, ba ar ghun kǝn ni da'a. ");
INSERT INTO plj_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Munju mom Yam dama wu ngen bar ju. Kǝn ngapo, Ba gin kǝ to Yamka mom bar ju ndari kǝ zam gwa. ");
INSERT INTO plj_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ama ngen ni pi bar ju Yam ba ndu kakani, arni ti bi in bar ju kup ndari kǝ zam es gwa. ");
INSERT INTO plj_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","<<Kumni bǝrti da'a, kǝn heli garke gǝni, Ba gin kum tǝmi kǝ bi in zo dǝmi cina dǝ Yami. ");
INSERT INTO plj_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Bar ju kǝn nariwo wurni ka, kǝ bi ni munju am ri wur kaar da gwa wurpiyi. Neni gam gin bar ju ba guska na zo bar ju ba lika da gwa to yamka, las tu mur ba pǝnka da'a, ghughur ma wi lika da gwa. ");
INSERT INTO plj_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Lastu zo bar kǝ mbarǝm rawo, lasini mbatl gǝs ba nǝra. ");
INSERT INTO plj_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","<<Dǝmni gǝɗǝn, dǝ pitǝla gin nǝra den cirtǝni. ");
INSERT INTO plj_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Dǝmni wule zher ju kan den ɓuti dǝ babom gǝzǝn pal kǝ ba domtǝn kǝ gudlumi gwa. Tin tǝ pal ɗir tǝ ɓo bǝdlabǝno, wi ɓuli ti na zhotǝne. ");
INSERT INTO plj_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ar ba dǝmi zher ju bar kǝ ghol mbatli kano babomi ni pal tǝ zam wur wu nde umur kawi da gwa. Na ho bi ni a yari ine, ti tus bar lulur gǝska tǝ wul wur'e wu dǝm atli kan tǝ kop wur na nǝm-nǝm tǝ bi wur fingali. ");
INSERT INTO plj_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ar ba mbuni zher ju, tin tǝ pal kǝ dlom gas ko kǝ bǝtloni, tǝ zam wur den ɓuti gwa. ");
INSERT INTO plj_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","<<Momni na untu, babom ni mom pǝt tu mur ba ɗiri ti gamo, ti za dǝ muri te ti gip bom tǝ yemi ti barka da'a. ");
INSERT INTO plj_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kǝn ma dǝmni gǝɗǝn don Nya Mbarǝm ba sur den pǝt tu kǝ la mbatl da gwa.>> ");
INSERT INTO plj_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Bitrus wule, <<Babomi, mǝnni kǝ yari mi misali tuya ko mbarǝm kup ni?>> ");
INSERT INTO plj_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Arni Babom Yesu nǝmi ti tǝ wule, <<Woni'e zher mǝn aminci na momi pi bari? Ti ni'e muntu babom gǝs ne ti bari tǝ ɓuti ti bom gǝsi, kan tǝ bi nami zheri fingal gǝzǝn hoyi gwa. ");
INSERT INTO plj_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ar ba mbuni zher tu kan babom gǝs ni pal tǝ zam ti tǝ den pi mbap gǝs gwa. ");
INSERT INTO plj_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ge shirǝm ni a yari ine, ti ne ti gam bar ju tǝra nari kup gwa. ");
INSERT INTO plj_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","<<Ama zher tuni wul gip mbatl gǝs'e, <Babom gǝn pal bǝle da'a,> kano tǝ nda gip ɓe nami zher mǝn mbapi mǝtli na moni, kan tǝ nda gip ci na tle ar kem dǝ ɗu tlo ti. ");
INSERT INTO plj_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Babom kǝ zher tu ba pal den pǝt tu kan tǝ la mbatl paltǝn gǝs da gwa, ti tlyat ti tǝ cetǝl ti kan tǝ pi ti hukunci na munju ba pi hoyi da gwa. ");
INSERT INTO plj_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Zher tukan mom argon tu babom gǝs ba ndu'e tǝ pi kan tǝ pi shiri da'a, ko tǝ nge pi argon tu babom gǝs ndu'e tǝ piwo, ba pi ti ɓotǝn kǝ tle masi. ");
INSERT INTO plj_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Muntu na dǝmǝn gam den argon tu babom gǝs ba ndu'e dǝ pi, kan tǝ pi wani pitǝno, ba ɓo ti njem. Kup muntu bi ti nari baro ba ngen nari bar kar ti. Muntu kup bi ti bar na womti ba ngen bar na womti es kar ti. ");
INSERT INTO plj_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","<<Untuni a ɗir kǝ la'i utu gip duniya. Ndu’i gǝnno na ar nǝm wi. ");
INSERT INTO plj_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ami ra na batisma kǝ kumi dli tukan ba pim gwa, fawo ar den ghuni gǝni in pim wi da gwa. ");
INSERT INTO plj_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Kǝ kum wule a ɗiri ni ghol mbatl gip duniya ya? Ako! A yari ine, rabe gamni a ɗiri. ");
INSERT INTO plj_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ɗe cina, gip bom nǝmo, mbarǝm nantam ba tatl bomi rop, myakan den shini bes kǝ rop, rop den shini bes kǝ myakan. ");
INSERT INTO plj_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Wi tatli, bǝba ba shin bes kǝ nya, nya ba shin bes kǝ base. Nǝna ba shin bes kǝ nya gǝsi, nyayi ba shin bes kǝ nas pa'e. Nakon ba shin bes kǝ nye kon gǝsi, nye kon ba shin bes kǝ nakon gǝs pa'e.>> ");
INSERT INTO plj_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu wul domtǝn kǝ mbarǝmi es’e, <<Kǝn ni kǝ shin dun yam ni tli tor tǝp yemmawo, kǝ kur wule, <Ghon ba nda,> kan ar ndayi. ");
INSERT INTO plj_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Kǝnni es kǝ kum itǝr den tlitǝn tor kuduwo, kǝ wule, <Pǝt ba mati,> kan ar mati. ");
INSERT INTO plj_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Kǝn mǝn se mbarǝme, kǝ mani momi pitǝn kǝ dun yam na wultǝn kǝ itǝr den atli, ngapo, momi zhan kǝno kǝ mbu da’a. ");
INSERT INTO plj_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","<<Ununu kem kǝ nge mani momi bar ju mbun kǝ pi gwawu? ");
INSERT INTO plj_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Gonni ri shirǝm gi bom tloyi shirǝmo, zho i kǝ kǝrkǝmika nan ti den tǝpe, kin kǝ nge giwo, ti ri’i cina dǝ mǝn tloyi shirǝmi, ti ngapo ti taki am dǝ mǝn ɓaltǝn kǝ dlomi, mǝn ɓaltǝn kǝ dlom ngapo ti laki gip bom kǝ moni. ");
INSERT INTO plj_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","A yari i, ki ɗǝl da'a, se kin kǝ ɓatl argon tukan tloyi i kup gwa.>> ");
INSERT INTO plj_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Gip wokociyi munju ra lasiwo, kan wu yari Yesu argon tu kan zam mǝn Galili jen kan Bilatus kem dǝ ri wur eka nan wi den mboshi bar ju kan wi bi Yam gǝzǝn su Urushalimaka gwa. ");
INSERT INTO plj_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu nǝmi wur tǝ wule, <<Kǝ wule munju ri wur'e na kumi dli untuwo wu man ni kup nami mbarǝm kǝ Galili warwat pitǝna? ");
INSERT INTO plj_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Untuni da'a! Na yari inni, kǝnni kǝ za warwat pitǝn ginka dawo untun kup gin ki mǝsh wule gwazini. ");
INSERT INTO plj_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Untu eso mbarǝm kutl cet wuzupse ju nan pike nda den wur ka, kan wu mǝshka su Siluwam kawo, kǝ wule wini wu man mǝn Isra'ila kup warwat pitǝna? ");
INSERT INTO plj_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Untuni da'a! Na yari in ra, kǝnni kǝ za warwat pitǝn gin ju kǝ pal kar Yam dawo, kǝn ma untun ki mǝshi.>> ");
INSERT INTO plj_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Kan Yesu ba pi wur misali tǝ wule, <<Bakos gon ra na kin turum gip kǝn gǝsi. Ya ri kǝ kotli nyeni, arni tǝ zam ko nǝm dene da'a. ");
INSERT INTO plj_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Kan tǝ wul muntu ba ne ti ger den kǝni'e, <Ɓa shini! Sheti ghon kǝ myakan ikǝn wi ami den ɗirtǝn kǝ kotli nyen turum kǝni, gastu kup a ɗiro a zam argon dene da'a. Wotl ti ka! Imni ba za ti tǝ tla laska katlu?> ");
INSERT INTO plj_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Kan mǝn ne ger den kǝni ba nǝmi ti tǝ wule, <Babomi, za ti kǝ sheti ghon nǝm ra, a domi ti atl gǝse a wi ti ghop. ");
INSERT INTO plj_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Doro tin tǝ gǝr gwa ar mbuni, tin tǝ gǝr da ngapo se dǝ wotl tǝka.> >> ");
INSERT INTO plj_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Gasi gon den pǝt shukutǝni, Yesu den kulci mbarǝm te gip bom kumi shirǝm kǝ Yam gonka, ");
INSERT INTO plj_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","nagǝr gon ra lasi muntu kan dun itǝr tle tǝka gwa, kup tǝ ngonka wi, sheti ghon gǝs kutl cet wuzupse tǝ mani tlitǝn yam da'a, ");
INSERT INTO plj_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu na shini gǝso, arni tǝ la tǝ bi tǝ wule, <<Nagǝr mbarǝme, A pǝni i kumi dli gi kawi!>> ");
INSERT INTO plj_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Kan Yesu ba ne am den ti, arni nagǝr mǝri workǝca tlyam dlor kan tǝ ɗǝɗa Yami. ");
INSERT INTO plj_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Argon tu ci lo bari kǝ bom kumi shirǝm kǝ Yam nar den'e Yesu warke nagǝr tu den pǝt shukutǝni. Arni tǝ wul nami mbarǝm'e, <<Muri mukka ra nan ar dlat dǝ pi mbap gwa, ɗir ni gip wur dǝ warke ine, bat na pǝt shukutǝni.>> ");
INSERT INTO plj_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Arni Babom nǝmi ti tǝ wule, <<Kǝn mǝn se mbarǝme! Woni gip kǝn ba pǝtl tla gǝs ko bar kǝm gǝs kǝ ba ɓali gǝs tǝ ri bi ti mal den pǝt shukutǝn dawu? ");
INSERT INTO plj_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Nagǝr kǝno, gǝs gal kǝ Ibǝrahim ni, muntu kan Shetan ne ti kǝba lasi sheti ghon kutl cet wuzupse gwa, ar ndari dǝ pǝtl ti am dǝ argon tu kan ɓal tika den pǝt shukutǝn da'a ya?>> ");
INSERT INTO plj_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Nan tǝ yari untuwo, munju kan ba ndu shini gǝs dawo arni sham nǝm wuri. Nami mbarǝm ngapo, kup wu pita ghol mbatl na bar mǝn dlǝkǝntǝn ju kan tǝ den pi gwa. ");
INSERT INTO plj_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Kan Yesu ba wule, <<Wule unun mulki kǝ Yam rawu? Na unun es a ngash tǝ we? ");
INSERT INTO plj_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Mulki kǝ Yamo wule ge dǝnti ni ar ra, muntu kan man badǝr kup kaltǝn gwa, nan murgon ngani gip kǝn gǝs ar ba nari tǝ pi bar kini, kan yatl ba tu bin gǝzǝn den am kini gwa.>> ");
INSERT INTO plj_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesu wul es'e, <<Na unun a ngash mulki kǝ Yamu? ");
INSERT INTO plj_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ar nǝra wule yisti kan nagǝr gon kurtli gip ɗapti alkama kwano myakan gwa, kan yistiyi ba nga ɗaptiyi kup.>> ");
INSERT INTO plj_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Nan Yesu den tǝp gǝs kǝ sitǝn Urushalimawo, tǝ rat gip mir bǝn jen tǝ pi ta kulci mǝn bǝni shirǝm kǝ Yam. ");
INSERT INTO plj_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Mbarǝm gon tambe ti tǝ wule, <<Babomi, mbarǝm njemni ba zam tetǝn gip mulki kǝ Yama?>> Tǝ wul wur'e, ");
INSERT INTO plj_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","<<Metini kǝ teni gipi tǝp kǝba heli bǝdlabǝni, domici mbarǝm ra na womti munju ba ndu tetǝn gipi kan ba mani da gwa. ");
INSERT INTO plj_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ba mǝn bomni tlyam tǝ le bǝdlabǝn bomika, kǝn ngapo ki dlǝr kari kǝ pita ɓe bǝdlabǝni, ki liri kǝ wule, <Babomi, ɓuli mi bǝdlabǝn ngapi!> Ama ti nǝmi in tǝ wule, <A mom kǝn da'a, ko las tu kǝ ɗǝl ɗir gwa!> ");
INSERT INTO plj_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Kǝn ngapo kan kǝ wule, <Mǝn kan mǝ ngas fingal mǝ pal mǝ tla gip gal nǝm nan ki fa gwaya, ki ngapo kǝ kulci rǝn gip bǝn gǝmi ka.> ");
INSERT INTO plj_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ti ngapo ti wule, <A yari ine, a mom kǝn da’a, ko lastu kǝ ɗǝl gwa. Tlinni kǝ ba ger ka, kǝn mǝn warwat pitǝne.> ");
INSERT INTO plj_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ki kul na ngasi shine, gastu kan kǝnni kǝ shin Ibǝrahim, na Ishaku, na Yakubu, na kup munju kan Yam kar wur den am gǝs mbiwi gip Mulki kǝ Yami, ama kǝno dǝ kar kǝn kagwa. ");
INSERT INTO plj_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Mbarǝm ba ɗir daga gip atl kundǝrǝndlip, wi dǝm kǝ ci nyel gip mulki kǝ Yami. ");
INSERT INTO plj_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Bartuni munju kan kaar haro wi pal kǝ cina, kǝ cina ngapo wi pal kǝ kaari.” ");
INSERT INTO plj_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Wi ra gip untuwo, kan mǝn Parisa jen ba ɗir wu wul Yesu'e, <<Tli gi ɗe ca, Hirudus den ndu'i tǝ ri i eka.>> ");
INSERT INTO plj_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Kan tǝ wul wur'e, <<Ri nǝka kǝ wulni ba mǝn ceni lar tu'e, <Ami den ɗǝli dun itǝr sekǝni na ɗǝli kumi dli kǝ mbarǝmka, gǝni ma untu, mburni a pa'i mbap gǝni.> ");
INSERT INTO plj_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ar nǝmǝn dǝ a pi ta nǝtltǝn gǝn sekǝni, gǝni na mburi. Ar ba tǝm kumi da'a dǝ mǝn shirǝm na Yam mǝsh rǝn kǝti gonka, ba'e gip Urushalimani ri ti eka da gwa! ");
INSERT INTO plj_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Kashto, Urushalima, Urushalima, kǝn mǝn ri mǝn yari shirǝm kǝ Yam eka, mǝn la'i munju kan Yam kar wur sur kar kǝn gwa na tate, bisi mǝnen a ndu domi gin wule nas kor kan ba ghum mimir gǝs gip bibako gǝs gwa, arni kǝ nge gini. ");
INSERT INTO plj_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ar tu Yam za'i in bom gin koni wi, ki i shimǝn da'a, se gas tu kan kǝ wule, <Mǝn albarkani, muntu kan ba sur gip sun kǝ Babom Yam gwa.> >> ");
INSERT INTO plj_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Den pǝt shukutǝn gon kan Yesu ri bom dǝ bari gon kǝ mǝn Parisa kǝ dǝ tǝ ci fingalo, arni mbarǝm ne ti gere. ");
INSERT INTO plj_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Cina da ti eso mbarǝm gon ra mǝn kǝmi asǝm na ame. ");
INSERT INTO plj_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Kan Yesu ba tambe mǝn kulci doka na mǝn Parisa tǝ wul wur'e, <<Doka gǝmi wule dǝ warke mbarǝm gas shukutǝna, ko ar wulra da'a?>> ");
INSERT INTO plj_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Wu wule argon da'a. Yesu ngapo kan tǝ ne am den ba mǝri, tǝ ɗǝli ti kumi dli gǝs ka, tǝ wul ti'e, <<Ndara ndaratin gi.>> ");
INSERT INTO plj_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Kan tǝ wul wur'e, <<Woni gip kǝn na nya ko tla kan ba nda shuka den pǝt shukutǝni, kan ba ɗǝli ti torka bǝle-bǝle da gwawu?>> ");
INSERT INTO plj_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Wi ngapo wu zam argon kǝ yari da'a. ");
INSERT INTO plj_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Nan Yesu shin munju kan yari wur ɗirtǝn kǝ ci fingali den zhotǝn kǝ nǝmi kiri ba dǝmiwo, arni tǝ yari wur shirǝm tǝ wule, ");
INSERT INTO plj_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","<<Murgon ni lakǝn bi kǝ gudlumiwo, ba kǝ nǝmi ni gam gin ba dǝmi kǝ kiri da'a, kǝ mom da'a ko mǝn gudlumiyi yari muntu kan nar man ki gwa. ");
INSERT INTO plj_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Kǝ shino, ba mǝn gudlumi ba wul ki'e, <Tlǝka dǝ mǝnkǝn dǝm kǝba dǝmi gi tu.> Na shamni ki tli kǝ pal kǝ ba heli ba dǝmi. ");
INSERT INTO plj_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ra untuwo, dǝmni kǝba heli badǝmi, muntu kan dom kǝnni shin kiwo, ti wul ki'e, <Berǝm, ɗir ɗe,> ti bi'i ho ba dǝmi. Ar ba kem kǝ cir cina dǝ munju kan tǝ laa kǝn bi nan wur gwa. ");
INSERT INTO plj_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Muntu kup ɗǝɗa gam gǝso, ba pali tǝ den ti argonni da'a, kup muntu pali gam gǝs tǝ argonni dawo, ba ɗǝɗa ti.>> ");
INSERT INTO plj_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yesu wul babom tu kan la tǝ bi gwa'e, <<Kini ki la bi murgon kǝ ci fingal, kan kǝ la bi jen kǝ biki gwa, ba kǝ la bi berǝm, ko ya'ǝn, ko mǝn gi, ko berǝm dǝmi gi mǝn bar kǝ am katl da'a. Munjuwo, gas jeno wi la ki bi pa. Bar tuwo wi ɓatl ki argon tu kǝ pi wur gwa ituwi. ");
INSERT INTO plj_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Kin ki la bi mǝn ci fingal gwa, yari munju am ri wur kar da gwa, na kurki, na muju itǝr tle wur am ko asǝmka gwa na tabi. ");
INSERT INTO plj_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Na untun ki zam Albarka, kǝ mom'e munjuwo wi mbu ɓatli gi da'a. Yamni ba ɓatl ki gas tu kan mǝn zo mbatl kan mǝshka ba tlyam gwa.>> ");
INSERT INTO plj_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Nan wu kum untuwo, gon gip mǝn ju kan den ci fingal na Yesu ba wule, <<Mǝn albarkani'e muntu zam tǝ ci fingal gip mulki kǝ Yam gwa.>> ");
INSERT INTO plj_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesu nǝmi ti tǝ wule, <<Mbarǝm gon ra kan ne pǝt bar biki gǝsi, arni tǝ yari mbarǝm na womti. ");
INSERT INTO plj_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Nan an mbi kǝ ci bikiyiwo, tǝ kar zher gǝs gon tǝ ri la bi munju tǝ yari wur gwa den'e ko unu piwi, ar mbi'e wu ɗir wi. ");
INSERT INTO plj_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ama kup na bi nǝm wu nǝm la'i asǝm gipi ka, nǝm wule, <A wur pel kǝn kan nǝmǝn te yarka a ri kǝ zhuwi gwa, pi hakkuri ka.> ");
INSERT INTO plj_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Gon ba wule, <A'i wur tla gi kǝn gudǝli kutl, a ri kǝ ɓomi gǝzǝn den kǝn ituwi, pi hakkuri ka.> ");
INSERT INTO plj_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Untu esi gon ba wule, <I gudlumin ni, a zam ritǝn da'a.> ");
INSERT INTO plj_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Zheri pal ɗir tǝ bali babom gǝs bar ju wu yari kup gwa. Kan lo ba ci babomi, kan tǝ wul zher gǝsi es'e, <Zho'i kǝ kop guntǝp kǝ gip bǝn kup, kǝ ɗirim munju kan ra na bar kǝ am da gwa, na kurki, na tabi, na munju itǝr tle wur amka ko asǝmka gwa.> ");
INSERT INTO plj_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Zheri pal ɗir tǝ wul babom gǝsi'e, <Argon tu kǝ yarimo a piwi, artu nami las i.> ");
INSERT INTO plj_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Babomi ba wul zher tu es'e, <Pal rǝn den guntǝp kǝ gip bǝn na kǝ bi lǝpka kǝ la bi mbarǝm ɗiri, dǝ ba dǝmi ju la'i.> ");
INSERT INTO plj_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Na yari ine, mbarǝm nǝm ra gip munju kan yari wur biki kǝn kan ba la lǝka den fingal gǝn gwa da'a.> >> ");
INSERT INTO plj_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Bar womti mbarǝm den ritǝn na Yesu, kan tǝ bal ti den wur tǝ wule, ");
INSERT INTO plj_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","<< Murgon tu ba kopǝn kup, tin tǝ ndu'ǝm nar man bas ko nas ko gǝr gǝs, na mimir gǝsi, na mǝn gǝs mǝtli na moni, har ma tǝ nge gam gǝs dawo, ti mani dǝmi mǝn kopi gǝn da'a. ");
INSERT INTO plj_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Muntu kup pǝn gicciye gǝs tǝ kopǝn dawo, ti mani dǝmi mǝn kopi gǝn da'a. ");
INSERT INTO plj_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Dǝ wule gon gip kǝnni ba ndu tu'i tlyari bino, ti dǝm tǝ shin mǝnen ti jili den tu'i bini kakani, ti shin ko tǝra na wurpi tu ba tu'i ti gwa diya. ");
INSERT INTO plj_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Tin tǝ la gǝs tu'i kan tǝ mani pa'i tu'i dawo, mbarǝm ba gyatli ti. ");
INSERT INTO plj_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Wi wule, <Mbarǝm kǝn la gǝs tu'i bine, artu tǝ mbu pa'i da'a.> ");
INSERT INTO plj_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","<<Ko dǝ wule, gun ni ba ɗǝl kǝ dlan na esi gunye, ai ti dǝm ti shin kakani mǝn bi utu gǝs dubu kutl ba mani dlan na kǝ esi gun kan ra na dubu hauya nǝma? ");
INSERT INTO plj_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Tin tǝ shin ti mani dawo, ti kar mir mǝn kartǝn gǝs wu ri ngen dǝmi zhilǝlǝ tun mǝnja ira na dliyami. ");
INSERT INTO plj_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Untuwo, muntu kup za argon tu tǝra narika tǝ kopǝn dawo, ti mani dǝmi mǝn kopi gǝn da'a. ");
INSERT INTO plj_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Maso ho barni, ama tǝmtǝn gǝsni ɗǝlkawo, ba'i mani pali gǝs masa? ");
INSERT INTO plj_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ar ba'i pi argon gip kǝn da'a, ba'i dǝm ghop da'a, sai dǝ shotika katl. Muntu na kǝm kumi gwa naa tǝ kumi.>> ");
INSERT INTO plj_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Mǝn nǝmi wurpi bom na nami mǝn warwat pitǝn na womti den ɗirtǝn kar ti kǝ kumi kulci gǝsi. ");
INSERT INTO plj_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Arni Parisiyawa na mǝn kulci mbarǝm doka kǝ Musa ngwar wu wule, <<Mbarǝm kǝn ba nǝm mǝn warwat pitǝn tǝ ci tor gip gal nǝm nan wuri.>> ");
INSERT INTO plj_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Tǝ yari wur shirǝm tǝ wule, ");
INSERT INTO plj_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","<<Dǝ wule gon ra na tǝm hauya nantam kan nǝm gip wur ba jilka. Ti za hauya wupse na kutl cet ghwanǝm ju rǝn bi lǝpka tǝ nǝm ngeni muntu kan jilka se tin tǝ zam ti kan diya? ");
INSERT INTO plj_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Tin tǝ zam ti ngapo, ti pǝn ti den bibyala na ghol mbatli. ");
INSERT INTO plj_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Na ɗirtǝn gǝs bomo ti la bi ga berǝm, na berǝm dǝmi gǝs tǝ wul wur'e, <Tayem ni ghol mbatli, tǝm gǝn kan jil kawo a zam tǝ wi.> ");
INSERT INTO plj_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ne ɓa yari ine, untuni es ba pi ghol mbatl na nari to yamka, den mǝn warwat pitǝn nǝm kan ci atl gam tǝ pal kar Yam gwa, ar man kǝ mbarǝm hauya wupse na kutl cet ghwanǝm mǝn ho pitǝn ju kan ra na argon kǝ ci atl gam dǝ pal kar Yam da gwa. ");
INSERT INTO plj_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","<<Dǝ wule nagǝr gon ra na wurpi gǝs bar gǝlla kutl, kan dǝ nǝm jilka. Ti mbǝsh utu, tǝ sar kushi gǝska tǝ ngen wurpiyi hoyi se tin tǝ zam wurpi gǝs tu kan jilka gwa diya? ");
INSERT INTO plj_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Tin tǝ zam ngapo, ti dom ga berǝm na berǝm dǝmi gǝs tǝ wul wur'e, <Tayem ni ghol mbatli, a zam wurpi gǝn wi nan jilka gwa.> ");
INSERT INTO plj_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nǝm barni, a yari ine, untuni ghol mbatl ba nǝra cina dǝ mǝn kartǝn kǝ Yami den mǝn warwat pitǝn nǝm kan ci atl gam tǝ pal kar Yam den wani pitǝn gǝs gwa.>> ");
INSERT INTO plj_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Tǝ pa wul ra'e, <<Pi bakos gon mǝn mir moni rop. ");
INSERT INTO plj_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Nye mǝn gǝpiyi wul bas'e, <Bǝba, bim argon tu ndari dǝ bin gip bar kǝ am gi nan ba bim kini kǝ mǝshka gwa.> Ti ngapo tǝ tatli wur kup argon tu tǝ ra nari gwa. ");
INSERT INTO plj_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ar murka gho da'a, kan nye mǝn gǝpiyi ba dom kup bar ju tǝ zam gwa, tǝ ndara atl gon na dlyami tǝ jili bar gǝska kup den kumi dǝɗǝm katl. ");
INSERT INTO plj_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Nan tǝ jili bar kǝ am gǝska kupo, kan guzum ba nda gip atli na nari, tin tu tǝ sa wi am koni. ");
INSERT INTO plj_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Kan tǝ pal nye mǝn tle oro kǝ mbarǝm gon gip atli, muntu kan ne ti mǝn le alade gǝs gwa. ");
INSERT INTO plj_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Tǝ ndu ma dǝ bi ti fingal kǝ alade ju ti ma tǝ ci, ko nǝm murgon ra kan bi ti argon gwa da'a. ");
INSERT INTO plj_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","<<Kan tǝ tla bǝram kǝ dli gǝs tǝ wule, <Mir mǝn tle oro kǝ ban mǝneni na fingal har wu ne gemi, amin kǝn ɗe ari kǝ mǝshtǝn wi na guzum wop! ");
INSERT INTO plj_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Naa nǝm tǝp a pal rǝn bom dǝ ban ka a wul ti'e, <Bǝba, a pi wani pitǝn cina dǝ Yam na cina da'i wi. ");
INSERT INTO plj_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Kǝkǝno a'i ndari dǝ wulǝm'e nya gi da'a, se de dǝ palin nǝm na mir mǝn tle oro da'i.> ");
INSERT INTO plj_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Se tǝ tlyam tǝ nǝm tǝp dǝ base. Ama tun tǝ'i na dlyami, arni basi shin ti kan guna ba citi den ti, tǝ kǝtǝr tǝ mbor ti, tǝ la'i ti am ɗir yar tǝ pi ti sumba. ");
INSERT INTO plj_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Nyayi ba wul ti'e, <Bǝba, a pi warwat pitǝn wi cina dǝ Yam na cina da'i . Kǝkǝno a'i ndari dǝ wulǝm'e nya gi da'a.’ ");
INSERT INTO plj_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ama basi wul zher gǝs'e, <Pǝnni zo lulur na zhotǝne, kǝ la'ini nya gǝni. Kemi tǝni zobi te amka, kǝ kemi tǝni kaptǝlan te asǝmka. ");
INSERT INTO plj_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Nǝm ni basi tla kǝ mboshni. Na mǝ pini biki mǝ ci mǝ tla ni. ");
INSERT INTO plj_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Nya gǝn kǝno ya mǝshnǝka hari artu ya pal wi, ya jilka artu zamti wi.> Kan wu nǝm ci na tle. ");
INSERT INTO plj_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","<<Bar ju kup piwo, mǝn bari kǝ nya tu rǝn gip kǝnka. Nan tǝ mbira ɗir kar bomo, se tǝ kum gangan na dlarni ba tli. ");
INSERT INTO plj_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Kan tǝ la bi zher kǝ bas gon tǝ tambe ti tǝ wule, <Unun ba ratlu?> ");
INSERT INTO plj_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Tǝ wul ti'e, <Mǝn gǝpi gi ni pali, arni be mbosh basi tla den'e nya gǝs pal bom lau.> ");
INSERT INTO plj_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Argon tu ci lo nye mǝn bariyi, arni tǝ nge tetǝn gip bomka. Kan bas ba ɗǝl ter kari tǝ pi ti shirǝm, tǝ lir ti. ");
INSERT INTO plj_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ama tǝ nǝmi basi tǝ wule, <Ɓa shini! Sheti ghon na womti a ne'i den pi mbapi, a taɓe nge shirǝm gi da'a. Kup na untu kǝ taɓen bi nye mar nan mi ci mǝ tla na mir berǝm gǝn gwa da'a. ");
INSERT INTO plj_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ama nya gi kǝn kan yem bar kǝ am gi ri lika den mǝtli mǝn dǝmi kǝ gam gǝzǝn pal bomo, arni kǝ mboshi ti basi tla!> ");
INSERT INTO plj_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Bas ba wule, <Nya gǝni, kiwo ki nǝra dlakǝt namǝni, kup bar ju ami ra nariwo geni. ");
INSERT INTO plj_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ama ar ndari mǝ pi biki mǝ pi ghol mbatli, den'e mǝn gipi gi mǝshka kan tǝ pal lasi, ya jilka kan ba zam ti.>> > ");
INSERT INTO plj_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu wul mir mǝn kopi gǝs'e, <<Pi mǝn bar kǝ am gon kan bi wakili gǝs gos gam tǝ ne ger dene gwa. Den kariwo ceti tǝ gamka den kandatu wakili gǝs den cetka na gos gam gǝsi gwa. ");
INSERT INTO plj_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Arni babomi la tǝbi, tǝ wul ti'e, <Unun a kum mbarǝm ba yari den ki untu? Dlǝmin bar ju am da'i gwa, ki'i dǝm wakili gǝn da'a.> ");
INSERT INTO plj_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Arni wakiliyi wul tor mbatl da ti'e, <Kǝkǝn kan, Babom gǝn ba karǝmka den mbap kǝno unun a pi? Artu a mbu kori bar da'a, esi a kum sham kǝ liri bari. ");
INSERT INTO plj_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","A mom bar kǝ pi wi in karǝmka den mbap kǝn kan mbarǝm baa nǝmǝn bom da wur gwa.> ");
INSERT INTO plj_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Arni tǝ labi kup mbarǝm ju babom gǝs ba kop wur asǝm yam gwa na nǝm-nǝm. Kan tǝ tambe nǝm tǝ wul ti'e, <Mǝnen babom gǝn ba kop kiwe?> ");
INSERT INTO plj_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Tǝ wule, tǝ nǝmi ti tǝ wule, <Mbunlet mir zangu wuzupse.> Arni wakiliyi wul ti'e, <Nǝm tǝlankuri zho’i kǝ rǝsh zangu wupse.> ");
INSERT INTO plj_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Tǝ pa wul gon'e, <Kiwo mǝnen tǝ kop ki?> Tǝ nǝmi ti tǝ wule, <Shar o kǝ alkama hauya nantam.> Wakiliyi wul ti'e, <Tǝlankur tu rǝsh hauya wupse.> ");
INSERT INTO plj_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Arni babomi yar zo shirǝm den wayo kǝ wakili mǝn utu tu tu. Mbarǝm kǝ zhan kǝn mani kopi na ezǝn man mbarǝm kǝ cirtǝni.>> ");
INSERT INTO plj_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yesu pa wule, <<A yari ine, maninǝ kopi na bar kǝ am gin kǝ zamni berǝmi. Untuni in bar kǝ am gin pa kawo ba nǝm kǝn gip bom kǝ dǝmi kan ba pa da gwa. ");
INSERT INTO plj_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Muntu kup la ne mbatl den ti den heli baro ba la mbatl den ti den nari. Muntu na gaskiya den heli bar dawo, ti mani dǝmi mǝn gaskiya den bari da'a. ");
INSERT INTO plj_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","In ne mbatl den kǝn den bar kǝ duniya kǝn dawo, woni ba ne mbatl den kǝn den ho bar we? ");
INSERT INTO plj_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Eso in kǝ mani nǝmi bar kǝ mbarǝm hoyi dawo, woni ba bi in bar jen ra kan gegin nigwa. ");
INSERT INTO plj_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Zher gon ra kan ba mani bote babom rop gwa da'a, ko tǝ nge nǝmi, tǝ ndu nǝmi, ko tǝ pi nǝmi ho pitǝne, tǝ mbur nǝmi. Arba pi da'a kǝ bote Yam na wurpi.>> ");
INSERT INTO plj_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Kan Parisawa mǝn ndu'i wurpino, na kumi argon tu Yesu yariwo, arni wu desi ti njipe. ");
INSERT INTO plj_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Arni Yesu wul wur'e, <<Kǝn ni'e mǝn ndu'i dǝ mbarǝm mom'e kǝn mǝn pitǝn dlat ni, Yamo ti ni tǝ mom mbatl gini. Bar ju mbarǝm ba bi wur nartǝno, arni Yam ba nge shini. ");
INSERT INTO plj_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Doka kǝ Musa na tǝlankur kǝ mǝn shirǝm na Yamni mbarǝm pi ta kopi ndekes ar ri ɗirtǝn kǝ Yohana mǝn pi batisma. Tun lokociyi den pi wazu kǝ zo shirǝm kǝ Yam kǝ dǝmi cina da ti ko gonge den ndotǝn tǝ zam totǝne. ");
INSERT INTO plj_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Kup na untu, ar ba mani pitǝn dǝ yam na atl paka, na dǝ wule la ko njemka gip doka kǝ Musa. ");
INSERT INTO plj_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","<<Kup muntu kar gǝr gǝska kan ɓal na gono tǝ pi zǝna ituwi, eso, kup muntu gudlumi na gǝr tu bakos gǝs kar ti kawo, zǝnan tǝ den pi nan ti pa'e.>> ");
INSERT INTO plj_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yesu wule, <<Pi mǝn bar kǝ am gon muntu ba la lulur mǝn wurpi gwa, tǝ ci ho fingal se na gǝni. ");
INSERT INTO plj_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Bǝdlabǝn da ti ngapo ba kur ne mǝn liri bar goni, sun gǝs’e Li'azaru, muntu dli gǝs kup usuni gwa. ");
INSERT INTO plj_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Tǝ ndu'e tǝ kur ci mir roɓǝs fingal ju ba ro sur am dǝ mǝn bar kǝ ami gwa. Yer ma wu kur ɗir lǝpti usu gǝsi. ");
INSERT INTO plj_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","<<Gip untuwo, arni mǝn liri bari mǝshka, kan mǝn kartǝn kǝ Yam ba te ti kar Ibǝrahim. Mǝn bar kǝ ami ngapo, nan ti mǝsho kan ba kap ti ka. ");
INSERT INTO plj_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ti te gip utu kawo, tǝ den ngasi kur bi, kan ti la ger yamo arni tǝ shin Ibǝrahim na dlyami na Li'azaru kar ti. ");
INSERT INTO plj_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Kan tǝ laa bi tǝ wule, <Bǝba Ibǝrahim, kum guna gǝn kǝ kar Li’azaru tǝ kem nye gam yasa gǝs gip mal tǝ la'in den lǝka gǝn a kum iɗatǝni. Gip utu kǝno ami den kumi dli.> ");
INSERT INTO plj_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ama Ibǝrahim wul ti'e, <Nya gǝni, tune, nan kira gip duniyawo, ki na ho bar na womti, Li’azaru ngapo tǝra na argon da'a. Kǝkǝn eso, tǝ den kumi tǝmi ɗe, ki ngapo kǝ den kumi dli. ");
INSERT INTO plj_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Untu dama, Yam la bar shu gip dlom dami, den'e munju ba ndu tertǝn kar kǝno, wi mani da'a. Kǝn ma ki mani jikati ter da'a.> ");
INSERT INTO plj_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Arni mǝn bar kǝ am tu wule, <A lir ki Bǝba, kar ti su bom dǝ mǝn gǝri gǝn ka. ");
INSERT INTO plj_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ami ra na mir byar nantam, tǝ dǝli wur kǝm ba wu ɗir kǝ ba las dun mbatl kǝn da'a.> ");
INSERT INTO plj_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Arni Ibǝrahim wul ti'e, <Wi ra na Musa na mǝn yar shirǝm kǝ Yami, wu kum shirǝm gǝzǝni.> ");
INSERT INTO plj_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Mǝn bar kǝ ami wule, <O'o, Bǝba Ibǝrahim, in mǝshi mbarǝm ni tli tǝ ri yari wuro, wi ci atl gam wu pal kar Yami.> ");
INSERT INTO plj_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Kano Ibǝrahim ba wul ti'e, <In wu kum yari kǝ Musa na mǝn shirǝm na Yam dawo, ko gon tlyam gip gam-bǝci ma wi kum ti da'a.>> > ");
INSERT INTO plj_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu wul mir mǝn kopi gǝs'e, <<Bar ju ba kem mbarǝm kǝ wani pitǝno ar ba ɗiri, untuwo, ar ba dǝm bar kǝ guna den muntu pi tǝp kǝ ɗirtǝn kǝ wani pitǝni gwa! ");
INSERT INTO plj_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Na dǝ gon kem mimir ju wani pitǝno, ar ba mani mǝri dǝ ɓali ti ghun ɗir yare, kan dǝ la ti su gip bar ɓulaka! ");
INSERT INTO plj_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Pini lura na gam gini, ya'ini pi'i hoyi dawo, matl ti, tin tǝ ci atl gamo, nǝmi ti. ");
INSERT INTO plj_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Tin tǝ pi'i laifi bisi nyingi den pǝt nǝm, kan tǝ ci atl gamo, nǝmi ti.>> ");
INSERT INTO plj_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Arni mir mǝn kartǝn kǝ Yesu wule, <<Mbǝli mi la'i mbatli.>> ");
INSERT INTO plj_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Arni tǝ wul wur'e, <<In kǝn ra na la'i mbatl wule ge dǝntiwo, ki wul bar kin dlǝngari tu'e, <Tus na gǝs gi kǝ su ɓa su gip ɓula ka,> ti kum yari gini. ");
INSERT INTO plj_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Gon ra gip kǝn kan na zher kan ba kori ti bari, ko ba le ti tǝme nan tin tǝ pal ɗir gip kǝno, ti wul ti'e, <Zho'i, kǝ dǝm kǝ ci bar gwaya?> ");
INSERT INTO plj_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ti wul untu da'a, ti wul ti'e, <Pǝnin fingal gǝn, dlǝr den asǝm gi kǝ win cina kakani, a ci a tla, kan kǝ'i ci ge diya?> ");
INSERT INTO plj_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ti gode zher tu den mbap tu tǝ wul ti'e tǝ pi gwaya? Ba pi untu da'a! ");
INSERT INTO plj_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Untuni, kǝnni kǝ kop bar ju kup wul kǝn'e kǝ pi, ki wule, <Miyo zherni katl. Miyo mǝnni den pi argon tu wul mi'e mǝ pi gwa.>> > ");
INSERT INTO plj_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Den tǝp ritǝn Urushalimawo, tǝ kop den iyaka gip dlom kǝ Samariya na Galili. ");
INSERT INTO plj_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Tǝ te gip nye bǝn gono, arni tǝ mo na mǝn ndǝci kutl, wu dlǝr teka jen. ");
INSERT INTO plj_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Arni wu la bi na bar yare wu wule, <<Babom Yesu! Kum guna gǝmi.>> ");
INSERT INTO plj_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Nan tǝ shǝn wuro, tǝ wul wur e, <<Rǝnǝka kar mǝn keri bar ju ɗiri Yam gwa, wu shǝn kǝne.>> Nan wu den tǝp ritǝno, arni wu warke. ");
INSERT INTO plj_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Nan nǝm gip wur shin tǝ warkewo, kan tǝ pal ɗir tǝ den ɗǝɗa Yam na bar yare. ");
INSERT INTO plj_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Tǝ ɗir nda cina dǝ Yesu, tǝ gode ti, ba mǝn Samariya ni'e ti. ");
INSERT INTO plj_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesu wule, <<Mbarǝm kutlni a warke wur diya? Akon ghwanǝmi ra? ");
INSERT INTO plj_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Unun kem mǝn diki tun pal ɗir katl tǝ gode Yami?>> ");
INSERT INTO plj_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yesu wul ti'e, <<Tlyam kǝ ndara wongi, ngǝshtǝn gi den Yam warke iwi.>> ");
INSERT INTO plj_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Nan Parisawa ndu wu mom gigasi ni zo dǝmi cina dǝ Yam ba cwatu, tǝ wul wur'e, <<Dǝmi cina dǝ Yamo ba shin ti na ger da'a. ");
INSERT INTO plj_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Murgon ba wule, <Ar kǝni!> ko <Arta!> da'a, gip dlom ginni ar ra.>> ");
INSERT INTO plj_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yesu pa wul mir mǝn kopi gǝs'e, <<wokoci den ɗirtǝne kan ki ndu shini pǝt nǝm gip pǝt kǝ Nya Mbarǝme, ama ki shin da'a. ");
INSERT INTO plj_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Mbarǝm na womti ba wul kǝn'e, <Shinni barta>, ko <Shinni ɗe,> ama kop wurni da'a. ");
INSERT INTO plj_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Gastu kan Nya Mbarǝm ba pal suro, ti sur wule ci bi kǝ Yami, kan ba cir tor gǝsi, kan ar nda bin gwa. ");
INSERT INTO plj_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ama ti kum dli hoyi kakani kan dǝ mbarǝm kǝ zhan kǝn nge ti. ");
INSERT INTO plj_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","<<Wule argon tu pi kǝ zhan kǝ Nuhu gwa, untuni ba pi den gastu kan Nya Mbarǝm ba pal sur gwa. ");
INSERT INTO plj_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Mbarǝm den ci na tle, moni den gudlumi, den bi mǝtli kǝ gudlumi ar ri gastu Nuhu te gip bar kungǝlǝn jikat mal gǝs gwa, kan bar mal ba sur pǝn wurka kup. ");
INSERT INTO plj_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Untuni gip muri kǝ Lutu, mbarǝm den ci na tle, wu den wuri na wurika, wu den ngani na tu'i bine. ");
INSERT INTO plj_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ama den pǝt tukan Lutu za Sodomo, arni shot bǝlǝm utu na gǝzhǝn utu sur yami, kan ba ri wur eka kup. ");
INSERT INTO plj_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Untuni ba pi den pǝt tu Nya Mbarǝm pal gwa. ");
INSERT INTO plj_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","<<Gasiwo, muntu den gam kushiwo, ba tǝ ɗǝl sur kǝ yemi gos gam gǝs gip bom da'a. Untuni, kup muntu kan ri bi lǝp kawo, bat na paltǝn bomi. ");
INSERT INTO plj_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Tuneni nagǝr kǝ Lutu! ");
INSERT INTO plj_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Muntu kup ba ghundǝr mbatl gǝskawo, ar ba jilka, ama muntu la mbatl gǝskawo, ti zami. ");
INSERT INTO plj_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","A yari ine, gastawo mbarǝm rop ba nde umur den dandi nǝm, ba pǝn nǝmka dǝ za nǝmi. ");
INSERT INTO plj_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Mǝtli rop bani den lu'i bari, ba pǝn nǝmka dǝ za nǝmi. ");
INSERT INTO plj_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Mbarǝm rop bani gip kǝne ba pǝn nǝmka dǝ za nǝmi.>> ");
INSERT INTO plj_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Mir mǝn kopi gǝs tambe ti, wu wule, <<A koni, Babomi?>> Ti wul wur'e, <<Lastu mǝshi bar rawo, lasini zhipki ba dom wuri.>> ");
INSERT INTO plj_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesu pa shirǝm na mir mǝn kopi gǝsi, tǝ bi wur misali gon tǝ wule, <<Pini ta shirǝm na Yam ba kǝ cenni mbatlka da'a.>> ");
INSERT INTO plj_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Tǝ wule, <<Rǝn gip bǝn gon ka alkali gon ra, muntu kan laa Yam mbatl da'a, tǝ ra na guna ger den murgon da'a. ");
INSERT INTO plj_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nagǝr gon ra guri gip bǝni, muntu kan meti ritǝn kar ti tǝ kuli ti, <Nem am ra dǝ bin argon tu ndarǝm gwa am dǝ mǝn nge gǝni.> ");
INSERT INTO plj_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Gip muri njemo ya nge, ama den kariwo, tǝ wul tor mbatl da ti'e, <A mom'e a bǝrti Yam da'a, eso, a shin guna kǝ murgon da'a, ");
INSERT INTO plj_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","kup na untuwo, guri kǝn ghunǝm narwi, a ɓal mbatl dlom gam a ne ti shim ame, a zam a shuku ra na ɗirtǝn gǝs se na gǝni kǝ ghuni gǝni.>> > ");
INSERT INTO plj_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Kan Yesu ba wule, <<Ɓa kumni argon tu alkali tu kan ba bǝrti Yam da'a yari gwa. ");
INSERT INTO plj_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Yam ba pi dlat munju tǝ la wur bi wu dǝm mbarǝm gǝs, munju ba kuli ti pǝt na gas gwa diya? Ti zhoti tǝ pi wur argon tu ndar wur gwa diya? ");
INSERT INTO plj_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","A yari ine, ti pi wur dlat, na zhotǝne. Ama, gas tu Nya Mbarǝm ni suro, ti zam la'i mbatl den atl kama?>> ");
INSERT INTO plj_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesu ba pa yari wur misali, mǝn ju kan ba pali gam gǝzǝn mǝn la'i Yam mbatlni, har wu mbur jenka gwa, ");
INSERT INTO plj_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","<<Mbarǝm jen rop te gip Bom kǝ Yam zam wu shirǝm na Yami, mǝn nǝm ba Parise, gon ngapo mǝn nǝmi wurpi bom ni. ");
INSERT INTO plj_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ba Parise tu tlyam kan tǝ shirǝm na Yam den gam gǝsi, tǝ wule, <Yami, a goode'i nan ami wule nami mbarǝm da'a, wule mǝn nǝmi bar mbarǝmka, mǝn wani pitǝne, ko mǝn kopi mǝtli, ko wule mǝn nǝmi wurpi bom tu. ");
INSERT INTO plj_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","A pi guzum mal bisi rop gip muri nyingi kup, kan a bi nǝm gip kutl kǝ argon tu kup a zam gwa.> ");
INSERT INTO plj_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ama mǝn nǝmi wurpi bom tu dlǝr teka jen. Tǝ mbu la'i gam to yamka dama, ama tǝ ɓo am den ngetl tǝ wule, <Yami, ami mǝn wani pitǝnni, shin guna gǝn ngapi.> ");
INSERT INTO plj_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","A yari in den'e, mbarǝm tu ri bomo Yam pǝni ti warwat pitǝn gǝs ka, ar man mǝn nǝm tu nan zam da gwa. Muntu kup ɗǝɗa gam gǝso ba pali ti argoni da'a, muntu ngap pali gam gǝs argonni dawo ba ɗǝɗa ti.>> ");
INSERT INTO plj_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Mbarǝm ne den ɗiri Yesu mimir tǝ ne am den wuri. Nan mǝn kopi gǝs shin untuwo, arni wu matl wuri. ");
INSERT INTO plj_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ama Yesu la wur bi tǝ wule, <<Zani mimir wu ɗir karǝmi, hane wur nǝka da'a, zami zo dǝmi cina dǝ Yamo kǝ iri gǝzǝn ni. ");
INSERT INTO plj_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Na ho bini a yari ine, kup muntu nǝm zo dǝmi cina dǝ Yam tor mbatl wule heli nya dawo, ti te gipi da'a.>> ");
INSERT INTO plj_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Bar mbarǝm gon tambe Yesu, tǝ wule, <<Zo mǝn kulci, unun a pi nan a zam rai kan ba pa da gwawe?>> ");
INSERT INTO plj_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu wul ti'e, <<Imni kǝ wulǝm'e zo'iwe? Zo'i ra da'a se Yam nan gǝsi. ");
INSERT INTO plj_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Kǝ mom doka tu Yam bi Musa, <Ba kǝ kop mǝtli da'a, ba kǝ ri mbarǝm eka da'a, ba kǝ pi mur da'a, ba kǝ kop kar kǝ lar da'a, ngusi gam bǝba gi na nǝna gi.>> > ");
INSERT INTO plj_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","<<A kop mǝn ju wi kup nan a'i heli gwa har sekǝni, tǝ wul untu.>> ");
INSERT INTO plj_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nan Yesu kum untuwo, tǝ wul ti'e, <<Har kǝkǝn ma kǝ'i hol bar nǝm. Wur kup bar ju ki nari ka, kan kǝ bi munju nan am ri wur kar da gwa, ki zam zo bar to Yamka. Kan kǝ ɗir, kǝ kopǝni.>> ");
INSERT INTO plj_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nan tǝ kumo, arni dun mbatl nǝm ti na nari, don ti mǝn bar kǝ am ni naari. ");
INSERT INTO plj_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu wi ti ger kan tǝ wule, <<An ban nar wule unu dǝ mǝn bar kǝ am zam zo dǝmi cina dǝ Ba Gun Yami. ");
INSERT INTO plj_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Zami zo dǝmi cina dǝ Ba Gun Yam kǝ mǝn bar kǝ am ban man dǝ rakumi ɗǝl gip shu alura.>> ");
INSERT INTO plj_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Munju kumo, kan wu tambe, <<Kan woni ba zam ɗǝltǝn ituwe?>> ");
INSERT INTO plj_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu wule, <<Argon tu mbarǝm ba mani pi dawo, Yam ba mani pi.>> ");
INSERT INTO plj_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Bitrus ba wul ti'e, <<Mǝ za kup bar ju mǝn narika mǝ kop ki wi!>> ");
INSERT INTO plj_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","<<A yari in na ho bi,>> Yesu wul wur ra'e, <Gon ra gip kǝn kan za bomka, ko nagǝr gǝsi, ko mǝn bari na mǝn gǝpi, ko mǝn gǝri gǝsi, ko mimiri den bi zo dǝmi cina dǝ Ba Gun Yam, ");
INSERT INTO plj_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","kan ba hol nǝmi gucipi na womti den duniya, to yamka ngapo mbatl tu ba mǝsh da gwa.> ");
INSERT INTO plj_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu ɗǝli kutl cet rop ju kǝti nǝm tǝ wul wur'e, <<Mǝ toni Urushalima, toka ni bar ju kup mǝn shirǝm na Yam rǝsh den Nya Mbarǝmo ba la'i. ");
INSERT INTO plj_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Wi bi ti am dǝ mǝn ju kan mǝn Yahudani da gwa. Wi lo ti, wi zage ti, wi bǝse ti mo'ǝmi, wi ɓo ti kan dǝ ri ti eka. ");
INSERT INTO plj_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Den pǝt kǝ myakano ti tlyam lasi.>> ");
INSERT INTO plj_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Mir mǝn kopi gǝs mom argon tu tǝ shirǝm dene gwa da'a. Ghundǝri wur nǝka, arni kem wu mom argon tu tǝ shirǝm dene gwa da'a. ");
INSERT INTO plj_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Nan Yesu pi kusa na Jerikowo, ba tabi gon ra ba dǝm bi guntǝp kǝ liri bari. ");
INSERT INTO plj_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Nan tǝ kum womti mbarǝm den kopi kartiwo, tǝ tambe ko unun ba ratlu. ");
INSERT INTO plj_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Wu wul ti'e, <<Yesu ba mǝn Nazaratni den shigetǝni.>> ");
INSERT INTO plj_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Tǝ la bi tǝ wule,<<Yesu nya Dauda, shin guna gǝni!>> ");
INSERT INTO plj_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Munju ra cina gip mbarǝmiwo wu matl ti, wu wule, <<Yon shot!>> Ama tǝ la yar ra na naari, <<Nya Dauda, shin guna gǝni!>> ");
INSERT INTO plj_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesu dlǝri, kan tǝ bi bi'e dǝ ɗiri ba tabiyi kar ti, nan tǝ mbira kosakwo, Yesu tambe ti, ");
INSERT INTO plj_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","<<Unun kǝ ndu'e a pi'i we?>> Tǝ wule, <<Babomi, a ndu'e a shin bari!>> ");
INSERT INTO plj_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Kan Yesu ba wul ti'e, <<Shin bari! Ngǝshtǝn den Yam gi warke iwi.>> ");
INSERT INTO plj_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Kǝ lasi tǝ zam shini bari, kan tǝ kop Yesu, tǝ den ɗǝɗa Yami. Kup munju shino, wu ɗǝɗa Yami. ");
INSERT INTO plj_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu te gip Yeriko, tǝ den shigetǝn gip bǝni. ");
INSERT INTO plj_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Mbarǝm gon ra nan ba wul ti'e Zakka gwa, bari kǝ mǝn nǝmi wurpi bom ni mǝn bar kǝ ame. ");
INSERT INTO plj_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Tǝ ndu'e tǝ shin woni'e Yesu, ama tǝ mani da'a nan mbarǝm womtika lasi gwa, kan tǝ tlyar da'a. ");
INSERT INTO plj_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ra'untuwo, tǝ nda cina na kǝtǝre tǝ to den bar kin dlǝngari goni bi tǝp tu Yesu den kopi gwa kǝ tǝ shin ti. ");
INSERT INTO plj_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Nan Yesu ɗir lasiwo, tǝ tli ger yam tǝ wule, <<Zakka, zho'i kǝ ɗǝl suri, sekǝno an nǝmǝn te yarka a dǝm bom da'i.>> ");
INSERT INTO plj_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zakka zhoti tǝ ɗǝl suri, tǝ nǝm Yesu bom da ti na ghol mbatli. ");
INSERT INTO plj_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Na shini untuwo, ar ni mbarǝmi kup ngwar wu wule, <<Tǝ ri kǝ dǝmi mǝn diki bom dǝ mǝn warwat pitǝne.>> ");
INSERT INTO plj_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ar ni Zakka tlyam tǝ wul Babom'e, <<Shini Babomi, a bi tatli kǝ argon tu ami nari gwa, dǝ munju kan am ri wur kar da gwa. In a cuce murgon ngap, a pali ti gucipi wupse.>> ");
INSERT INTO plj_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesu wul ti'e, <<Sekǝno ceto ɗir gip bom kǝn wi, tunkan mbarǝm tu ma nya Ibǝrahim ni gwa. ");
INSERT INTO plj_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ami Nya Mbarǝm surni kǝ ngeni kan a ɗǝli munju jilka wule Zakka gwa.>> ");
INSERT INTO plj_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nan wu den kumi bar ju tǝ yari wuro, kan tǝ yari wur shirǝmi, domici tǝ mbi kosak na tetǝn Urushalima wi, kan mbarǝm ngapo wu neka den mulki kǝ Yam ba cwat ituwi bǝle-bǝle. ");
INSERT INTO plj_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Tǝ wule, <<Bar mbarǝm gon ri gip dlyami bǝn gon kǝ dǝ bi ti gun kan tǝ pal ɗir lasi. ");
INSERT INTO plj_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Bitu ti ndarawo, tǝ labi zher gǝs wi kutl tǝ bi wur wurpi bali na nari, tǝ wul wur'e, <Balini wurpi tu an ri paltǝn gǝni.> ");
INSERT INTO plj_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ama kan mbarǝm kǝ bǝn gǝs ba nge ti, wu kar jen rǝnka wu wule, <Miwo mǝ ndu mbarǝm tu kǝ gun gǝmi da'a.> ");
INSERT INTO plj_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Kup na untu, wu bi ti gunyi, tǝ pal ɗir bomi. Kan tǝ kar bar dǝ domi ti zher gǝs kutl ju kan tǝ bi wur wurpi gwa, tǝ mom tu kǝ bar ju wu zam den wurpiyi gwa. ");
INSERT INTO plj_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Kǝ nǝm ter tǝ wule, <Babomi, a zam gucupi kutl den muntu kan kǝ bin gwa.> ");
INSERT INTO plj_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Arni Babomi wul ti'e, <Ar mbuni zo zhere, tun kan kǝ pi dlat den heli baro a bi'i gun kǝ bǝn kutl.> ");
INSERT INTO plj_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Zher kǝ ropi ter tǝ wule, <Babomi, a zam gucupi nantam den muntu kan kǝ bin gwa.> ");
INSERT INTO plj_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Babomi wul muntu'e, <Ki dǝm gun kǝ bǝn nantam.> ");
INSERT INTO plj_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ama zher gon ɗir esi tǝ wule, <Babomi, wurpi gin kǝni, a ghundǝrika gip tutule. ");
INSERT INTO plj_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Amo a kum bǝrti gi, ki mbarǝm gon ni mǝn bantǝni. Mǝn ndu'i ci nguɓuk ni, kǝ rǝsh kǝn tu kin kǝ ngani da gwa.> ");
INSERT INTO plj_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Arni tǝ wul ti'e, <Ki warwat zhere! Aa si'i gam gǝs mal den argon tu kǝ yari gwa. Kǝ mom den ami mbarǝm mǝn bantǝn ni, a pǝn argon tu kan a ne da gwa, a rǝsh argon tu a ngani dawo? ");
INSERT INTO plj_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Unun kem kǝ nem wurpi gǝnka gip bom ne wurpi da'a, in a pal ɗiro a zam mal dene ra gwa?> ");
INSERT INTO plj_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Tǝ wul munju ɗir markǝm da ti'e, <Nǝm ni wurpi kǝ am da tika, kǝ bi ni muntu kan na gucipi kutl gwa.> ");
INSERT INTO plj_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Arni wu nǝmi ti wu wule, <Babomi, tǝ ra na wurpi na nariwi ca!> ");
INSERT INTO plj_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Tǝ wul wur'e, <A yari ine, muntu nariwo ba bi ti ra, ama muntu nari dawo nye argon tu am dati ma ba nǝmka. ");
INSERT INTO plj_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ama mǝn nge gǝn ju nan ba ndu'e a dǝm gun gǝzǝn dawo, ɗir wurni ɗe dǝ ri wur eka cina dami.> >> ");
INSERT INTO plj_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Nan Yesu yari shirǝm juwo, arni tǝ nda cina tǝ ne gam Urushalima. ");
INSERT INTO plj_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nan tǝ ɗir kar mir bǝn jen nan ba wul wur'e Betfaji na Betanya nan markǝm tlǝndǝr kǝ Zaitunwo, tǝ kar mir mǝn kopi gǝsi wi rop, ");
INSERT INTO plj_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","tǝ wul wur'e, <<Teni gip nye bǝn kǝ cina tu, in kǝ mbu baro, ki zam nye bar kǝm gon na ɓali nan taɓe totǝn den tiwi da gwa. Pǝtl tǝni kǝ ɗir tǝni ɗe. ");
INSERT INTO plj_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","In murgon wul kǝn'e, <Unun kem kǝ pǝtl tiwo?> wul ti ni'e, <Babom ni ba ndu'i.> >> ");
INSERT INTO plj_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Munju nan kar wuro wu ri zam kanda tu tǝ yari wur gwa. ");
INSERT INTO plj_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Wu den pǝtli nye bar kǝmi ituwi, arni mǝn bar kǝmi wul wur'e, <<Unun kem kǝ pǝtl tiwu?>> ");
INSERT INTO plj_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Wu wule, <<Babom ni ba ndu'i.>> ");
INSERT INTO plj_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Wu ɗir ti kar Yesu, nan wu wi lulur gǝzǝn den tiwo kan wu pǝn Yesu wu ne ti dene. ");
INSERT INTO plj_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Tǝ den ritǝno, arni mbarǝm la lulur gǝzǝn den tǝpe. ");
INSERT INTO plj_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Nan tǝ ɗir dap na tǝp tu ɗǝl kar tlǝndǝr kǝ Zaitun, arni kup mǝn kopi gǝs nǝm ɗǝɗa Yam na bar yar na ghol mbatl, den kup bar mǝn dlǝkǝntǝn nan wu shin gwa. ");
INSERT INTO plj_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Wu den wul tǝn'e, <<Mǝn albarkani'e gun tu den surtǝn gip sun kǝ Babom Yam gwa! Salama ra to yamka, nartǝn ngapo kǝ Yam ni.>> ");
INSERT INTO plj_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Arni mǝn Parisa jen gip womti mbarǝmi wul ti'e, <<Ba mǝn kulci, matl mir mǝn kopi gi wu yoni!>> ");
INSERT INTO plj_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Tǝ nǝmi wur tǝ wule, <<A yari ine, in munju yon gǝzǝno, tat ju na gam gǝzǝn ba tli na la'i yare.>> ");
INSERT INTO plj_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Nan tǝ ɗir kosak tǝ shin bǝn Urushalimawo, arni tǝ kuli ti gami. ");
INSERT INTO plj_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Tǝ wule, <<Dǝ wule kǝ mom ni den pǝt kǝno argon tu ba ɗiri in dǝmi zhilǝlǝ ma, ama kǝkǝno ghundǝri in kawi. ");
INSERT INTO plj_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Pǝt jen ba ɗiri in gami kan mǝn nge gin ba tu panye, wu gandǝl kǝne, wu tla kǝn wu pi dlan nan kǝn cina na kari. ");
INSERT INTO plj_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Wi byal kǝn atli kǝn na mimir gin gip bǝni, kan wu ri in eka. Ba za tat gon den esi da'a, domici ba zam kǝn den kǝ nge la'i Yam mbatl den'e Yam sur kǝ ɗǝli gin gwa. ");
INSERT INTO plj_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Arni tǝ te gip dǝbom Bom kǝ Yami, tǝ nǝm ɗǝli mǝn ju den wuri barka gwa. ");
INSERT INTO plj_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Tǝ wul wur'e, <<Ar ra na rǝshi,>> <Bom gǝn ba dǝm ba shirǝm na Yami,> ama kǝ pali ba dǝmi kǝ mur wi.>> ");
INSERT INTO plj_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Se na gǝni tǝ pi ta kulci te gip Bom kǝ Yamka, ama kiri mǝn keri bar ju ɗiri Yam, na mǝn kulci mbarǝm doka kǝ Musa, na kiri kǝ bǝni ngen tǝp tu wi ri ti eka gwa. ");
INSERT INTO plj_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ama wu zam tǝp nǝmi gǝs da'a, domici mbarǝm kup den ndu'i kumi shirǝm gǝs nari. ");
INSERT INTO plj_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Gasi gon nan Yesu ra den kulci mbarǝm gip dǝbom Bom kǝ Yam, tǝ den pi wazu kǝ zo shirǝm kǝ Yami, kiri mǝn keri bar ju ɗiri Yam, na mǝn kulci mbarǝm shirǝm tu kan Yam bi Musa gwa, na kiri babomi wu ɗir kar ti. ");
INSERT INTO plj_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Wu wule, <<Yari mi, na unu ikoni kǝ den pi bar ju, woni bi’i bi?>> ");
INSERT INTO plj_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Tǝ nǝmi wur tǝ wule, <<Am ma a tambe ine, kǝkǝno yarin ni, ");
INSERT INTO plj_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","batisma kǝ Yohanawo kar Yam ni ɗǝl sura ko kar mbarǝm ni?>> ");
INSERT INTO plj_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Arni wu bali shirǝm tu gip dlom gǝzǝni, wu wule, <<Mǝn ni mǝ wule sur yam no, ti wule, unun kem kǝ nǝm shirǝm gǝs da'a? ");
INSERT INTO plj_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ama mǝn ni mǝ wule, kar mbarǝm no, mbarǝm kup ba la mi na tate domici wu nǝm'e Yohana mǝn shirǝm na Yamni.>> ");
INSERT INTO plj_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ar ni wu nǝm wu wule, <<Mǝ mom las tu ar ɗǝl sur gwa da'a.>> ");
INSERT INTO plj_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Kan Yesu ba wul wur'e, <<Ami ma a yari in na ikoyi gongeni a pi bar ju da'a.>> ");
INSERT INTO plj_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Arni tǝ nǝm yari mbarǝm shirǝmi, <<Pi mbarǝm gon kan pi kǝn inabi, kan tǝ bi jen dǝ wu zam ɓomi dene, kan tǝ ndara gip bǝn goni, tǝ dǝm rǝnka kǝ sheti ghon na womti. ");
INSERT INTO plj_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Nan pǝt kotli inabiyi ɗiro, kan tǝ kar zher gǝs gon rǝn kar mǝn mbap den kǝn gǝs tuka, dǝ wu bi ti inabiyi jeni. Ama arni mǝn mbap ja ɓo zher tu wu kar ti am koni. ");
INSERT INTO plj_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Tǝ pa kar zher goni, ti esi wu ɓo ti, wu bi ti shame, wu kar ti am koni. ");
INSERT INTO plj_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Esi, tǝ pa kar mbarǝm kǝ myakan, muntuwo arni wu kumi tǝ dli, wu la tǝka. ");
INSERT INTO plj_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Arni mǝn kǝn inabi tu wule, <Unun a piwu? Aa kar nya gǝn nan a ndu ti gwa, wolo wi shin nartǝn gǝsi.> ");
INSERT INTO plj_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ama nan mǝn mbap ja shin tiwo, arni wu wul ezǝn'e, <<Nya tu baa nǝm gǝs bar kǝ bas tu rawi, na mǝ ri ti eka, dǝ kǝni dǝm gwagǝmi ra.>> ");
INSERT INTO plj_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Arni wu byal ti kar kǝn inabiyi kan wu ri ti eka. Unu ari ni ba mǝn kǝn tu ba pi wurwe? ");
INSERT INTO plj_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Mǝn ɓomi zami den kǝn gǝs juwo ti ri wur eka, kan tǝ bi jen kǝn inabiyika.>> Nan mbarǝm kum untuwo, arni wu wule, <<Ar ba pi da'a.>> ");
INSERT INTO plj_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ama tǝ wi wur gere, tǝ wule, <<Unun shirǝm kǝ Yam yariwe? <Tat tu mǝn tu'i bom ngewo ar ni'e ho tat kan ne ti den bi tu'i bin gwa!’ ");
INSERT INTO plj_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Kup na untu, muntu kan nda den tat tuwo ti ceccenka, ama tati ni nda den murgono ar ba lu tika tǝ dǝm wule ɗapti.>> ");
INSERT INTO plj_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Mǝn kulci mbarǝm na kiri mǝn keri bar ju ɗiri Yam ndu'e wu nǝm Yesu bartu, ama wu kum bǝrti kǝ mbarǝme, shini gǝzǝno den wurni tǝ yari shirǝm tu. ");
INSERT INTO plj_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Arni wu wi ti gere, wu yem mbarǝm jen mǝn pǝni asǝm wu pi wule ho mbarǝm ni, kǝ dǝ wu kem Yesu tǝ yari wani shirǝmi, zan wu ri ti cina dǝ bar mǝn dandi kǝ bǝni. ");
INSERT INTO plj_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Wu tambe ti wu wule, <<Ba mǝn kulci, mǝ mom'e shirǝm gi na kulci giwo dlatni ar ra, eso kǝ pi bar kǝ ndu'i gam da'a, ama kǝ kulci mbarǝm ho shirǝm kǝ Yam ndekes. ");
INSERT INTO plj_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ar ndari mǝ bi Kaisar wurpi boma ko ar dlat da'a?>> ");
INSERT INTO plj_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ama tǝ mom pitǝn gǝzǝnka, kan tǝ wul wur'e, ");
INSERT INTO plj_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","<<Nunen ni kabarshu, shishidǝr na sun kǝ woni dene? Wu wule, <<Kǝ Kaisar ni.>> ");
INSERT INTO plj_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Tǝ wul wur'e, <<Bi ni Kaisar bar tu kan kǝ Kaisarni gwa, kan kǝ bi ni Yam bar ju kan kǝ Yam ni gwa.>> ");
INSERT INTO plj_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Bartuwo, wu'i mbu nǝmi gǝs na shirǝm den argon tu tǝ yari cina dǝ mbarǝm gwa da'a. Shirǝmi dlǝkǝn wuri, arni wu yon shot. ");
INSERT INTO plj_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Arni Sadukiyawa jen munju kan la mbatl den'e tli mǝshi mbarǝm ra da gwa, wu ɗir kar Yesu. ");
INSERT INTO plj_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Wu tambe ti wu wule, <<Ba mǝn kulci, Musa rǝshi mi'e, erǝm kǝ mbarǝm ni mǝshka kan tǝ ra na gǝr nan gǝr dawo, ar mbun'e dǝ mǝri pǝn gǝri kǝ dǝ tǝ zami erǝm gǝs tu nya. ");
INSERT INTO plj_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Mbarǝm jen ra wi nyingi, nan bi nyin nǝm gwa, bariyi gudlumi na gǝre tǝ mǝshka tǝ zam nya da'a. ");
INSERT INTO plj_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Kǝ rop ma untu, ");
INSERT INTO plj_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","kan kǝ myakani ba pǝn gǝri. Untuni kup gǝzǝn nyingiyi wu mǝshka wu zam gǝri nan ti da'a. ");
INSERT INTO plj_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Den kariwo, kan gǝr tu ba mǝshka. ");
INSERT INTO plj_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Gas tli mǝshi mbarǝmo gǝr kǝ woni ti dǝm gip wuri we? O fawo, kup gǝzǝno wu gudlumi nan tigwa!>> ");
INSERT INTO plj_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Arni Yesu wul wur'e, <<Mimir kǝ zhan kǝn baa gudlumi eso baa ri wur gip kushi. ");
INSERT INTO plj_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ama munju ndar tlitǝn bi dǝ mǝshtǝno wini wi dǝm gip zhan mǝn ɗirtǝne, wi gudlumi da'a ba ri wurka gip kushi da'a. ");
INSERT INTO plj_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Wi'i mǝsh da'a, wi ni nǝm na mǝn kartǝn kǝ Yami, wi mimir kǝ Yam ni domici wu tli bi dǝ mǝshtǝn wi. ");
INSERT INTO plj_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Eso, Musa nune tetla'e mǝn ju mǝsho wi tlyami, nan tǝ yar shirǝm kǝ lundum nan utu nǝm ama ar kerka da'a. Kan tǝ labi Babom Yam ti ni'e Yam kǝ Ibǝrahim, Yam kǝ Ishaku, Yam kǝ Yakubu. ");
INSERT INTO plj_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Tǝ Yam kǝ mǝshi mbarǝmni da'a, tǝ Yam kǝ munju ra na rai gwani, kar tiwo, kup munju wini rawo mǝn rai ni.>> ");
INSERT INTO plj_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Arni mǝn kulci doka kǝ Musa jen nǝmi wu wule, <<Ba mǝn kulci, kǝ pi ho shirǝmi.>> ");
INSERT INTO plj_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Bartuwo, mbatl dlǝri wur kǝ wu i tambe ti argon da'a. ");
INSERT INTO plj_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesu wul wur'e, <<Imni ba wule Almasihuwo nya Dauda niwe? ");
INSERT INTO plj_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Dauda ngap na gam gǝs tǝ yari gip Zabura'e, <<Babom wul Babom gǝn'e, <Dǝm den am shimli gǝni, ");
INSERT INTO plj_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","se amin a kem mǝn nge gi dǝm ba ne asǝm gi.> >> ");
INSERT INTO plj_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dauda la ti bi'e <Babomi,> imni es ti dǝm nya gǝs rawu?>> ");
INSERT INTO plj_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nan mbarǝm kup den kumi gǝso, arni tǝ wul mir mǝn kopi gǝs'e, ");
INSERT INTO plj_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","<<Pini hankali na mǝn kulci mbarǝm doka kǝ Musa, mǝn ndu'i ndǝtltǝn gip kiri luluri, mǝn ndu'i e dǝ shirmi wur gip bar pǝte, mǝn ndu'i dǝ bi wur zo ba dǝmi gip bom kumi shirǝm kǝ Yami na ho ba dǝmi kǝ ba biki. ");
INSERT INTO plj_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Wini'e mǝn ci bar kǝ mǝtli ju nan moni gǝzǝn mǝshka gwa, kan wu pi tlyari shirǝm na Yami kǝ dǝ shin wi ho mbarǝm ni. Wini ngap wi zam wani ɓatltǝn mǝn nartǝni.>> ");
INSERT INTO plj_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Nan Yesu ra gip Bom kǝ Yamo, tǝ shin mǝn bar kǝ am den wi baiko gǝzǝn gip pantimota ba domi wurpi. ");
INSERT INTO plj_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Arni tǝ shin nagǝr gon nan guri kan am ri ti kar da gwa, tǝ wi kabarshu rop. ");
INSERT INTO plj_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Arni tǝ wule, <<Na ho bini a yari ine, nagǝr tu kan am ri ti kar da'a, wi bar nan man kǝ mbarǝm kup gwa. ");
INSERT INTO plj_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Wiwo wu yemni gip womti bar kǝ am gǝzǝn kan wu bi, ama tiwo gip argon tu tǝra nari da gwan tǝ bi kup bar tu tǝ ra nari gwa.>> ");
INSERT INTO plj_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Mir mǝn kopi gǝs jen ra nǝm shirǝm den Bom kǝ Yami, na mbuni tat ju nan tu bomi nari na mbuni bar ju nan pi ti bar kǝ mbuntǝn nari gwa. Arni Yesu wule, ");
INSERT INTO plj_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","<<Bar ju kan kǝ shino, pǝt ba ɗiri nan ba za tat gon den esi gwa da'a, kup ba yasi ka.>> ");
INSERT INTO plj_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Arni wu tambe ti wu wule, <<Ba mǝn kulci, gǝgasi ni untu ba piwu, kan ununu ba dǝm alama bar juni ba pi gwa we?>> ");
INSERT INTO plj_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Arni tǝ wule, <<Neni gere, ba dǝ murgon jili in nǝka da'a, jen ra na womti nan ba ɗir na sun gǝni wu wule, <Ami ni'e Almasihu!> kan, <Pǝt ngap an mbirawi kosak!,> kop wurni da'a. ");
INSERT INTO plj_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kǝn ni kǝ kum shirǝm kǝ dlan na meti tli mbatlo, ba kǝ kumni bǝrti da'a. Dole bar ju ba pi kakani, ama pa'i bar kup mbira na zhotǝn wi da'a.>> ");
INSERT INTO plj_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Arni tǝ wul wur'e, <<Atl ba tli esi atl gami. Mulki ba tli esi mulki gami. ");
INSERT INTO plj_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Atl ba jirkǝt na nari, ba pi guzum na aloba kǝ ba las na womti. Ba shin bar kǝ bǝrti na womti na kiri alama den ɗǝltǝn sur yami. ");
INSERT INTO plj_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ama kapǝn dǝ bar ju kup piwo, baa nǝm kǝn dǝ kumi in dli, wi ri in gip bom kumi shirǝm kǝ Yami, na bom kǝ moni, ba ɗir kǝn cina dǝ mǝn bǝni na kiri kǝ atli den kǝn gwanni. ");
INSERT INTO plj_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Bartuni ki zam bi yari shirǝm demǝni. ");
INSERT INTO plj_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Dlǝrǝni mbatl gini, ba ar ghun kǝnni kafin dǝ ri in cina da wur kanda tu ki bali wur gwa da'a. ");
INSERT INTO plj_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Domici aa bi in shirǝm na bobya, nan mǝn nge gin gon ra kan ba mbu kemi in gam gǝs mal gwa da'a. ");
INSERT INTO plj_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Mǝn gǝri gin na ya'ǝn pa, mǝn gin na berǝm gin ba la'i in gǝs yami, wi kem dǝ ri jen eka. ");
INSERT INTO plj_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Mbarǝm kup ba nge ine den bi sun gǝni. ");
INSERT INTO plj_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ama ta gam gin nǝm ra nan ba jilka gwa da'a. ");
INSERT INTO plj_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kǝn ni kǝ ɓa mbatl dlom gamo, ki zam zo dǝmi cina dǝ Yami. ");
INSERT INTO plj_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ama kǝn ni kǝ shin mǝn bi utu gandǝl Urushalima kawo, mom ni'e bari kǝ yasika ituwi. ");
INSERT INTO plj_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Munju kan ra su Yahudiya kawo, wu kǝtǝr wu to gǝzǝn gip tlǝndǝre, kan munju ra gip bar bǝno wu ɗǝli, munju ra rǝn bi lǝpka ngapo ba wu su gip bar bǝn da'a. ");
INSERT INTO plj_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","wokoci tuwo wokoci hukuntetǝn ni, kǝ dǝ laa'i bar ju kup rǝsh gip shirǝm kǝ Yam gwa. ");
INSERT INTO plj_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kashto kǝ mǝtli mǝn tu'e na munju den bi mimir nyin gwa, gas tle wuya na nari gip atlo, lo kǝ Yam ba sur den mbarǝm ju. ");
INSERT INTO plj_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ba ri jen eka na bar sǝɓǝri dǝ nǝm jen dǝ pali wur zher gip atl kup, muntu kan mǝn Yahudani da gwa wi tsanante Urushalima ar ri patǝn kǝ muri mulki kǝ munju kan mǝn Yahudani da gwa. ");
INSERT INTO plj_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ba shin bar ju taɓe shini da gwa den pǝte na kyare na zingesi, gip duniya ngap mbarǝm kup ba dam wur na bǝrti den mǝn zhe’e mal na wultǝn kǝ bar ɓula'i. ");
INSERT INTO plj_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Mbarǝm ba sumaka na bǝrti, mbatl ba tari wur na shini bar ju den pitǝn gip duniya gwa, domici ba jirkǝt kiri bar ju nan to Yamka gwa. ");
INSERT INTO plj_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Bartuni wi shin Nya Mbarǝm den paltǝn sur gip dun yami, na iko na cirtǝn mǝn nartǝni. ");
INSERT INTO plj_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Bar juni nǝm pitǝno, tlini yam kǝ lani gam yami, pǝt ɗǝltǝn gin mbirawi kosak.>> ");
INSERT INTO plj_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Arni Yesu yari wur shirǝm gon tǝ wule, <<Shinni kin turume na kin kup. ");
INSERT INTO plj_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Wini wu pare gilitǝno, kǝn na gam gin, ki mom'e lurpi mbirawi. ");
INSERT INTO plj_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Untu esi, kǝnni kǝ shin bar ju den pitǝno, ki mom'e zo dǝmi cina dǝ Yam mbirawi kosak. ");
INSERT INTO plj_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Na ho bi ni a yari ine, mbarǝm kǝ zhan kǝn ba mǝsh da'a se bar juni kup pi kani. ");
INSERT INTO plj_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Yam na atl ba pa'i, ama ko njem shirǝm gǝn ba pa da'a. ");
INSERT INTO plj_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Dǝm ni gǝɗǝn, ba kǝ za ni la'i tu gin na huli bar na zhe'e pitǝne, na ghuntǝn kǝ dǝmi kǝ duniya ar tla gam ginka da'a. Ba dǝ pǝt tu ɗir bat na momi gin ar nǝm kǝn wule tarko da'a. ");
INSERT INTO plj_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Domici ar ba ɗir ni den mbarǝm kup nan ra den kar atl gwa. ");
INSERT INTO plj_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ama dǝmni gǝɗǝn ko gǝgasi, kǝn den shirǝm na Yami, kǝ dǝ kǝ zamni ndǝri mbatl nan ki ɗǝl gip bar ju kup kan ba pi gwa, kǝ dǝ kǝ zamni dlǝri cina dǝ Nya Mbarǝm ra.>> ");
INSERT INTO plj_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Den pǝt kup, tǝ den kulci mbarǝm gip dǝbom Bom kǝ Yami, kǝ gas ngapo, tǝ kur ɗǝl tǝ to mur dǝ bar tloyi ti den tlǝndǝr nan ba wul ti'e Tlǝndǝr Zaitun gwa. ");
INSERT INTO plj_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Kǝ cigǝni eso, mbarǝm kup ba ɗir kar ti gip dǝbom Bom kǝ Yam kǝ kumi kulci gǝsi. ");
INSERT INTO plj_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Nan biki kǝ burodi nan ba wi ti yisti da'a, muntu ba wul ti'e biki jikat bǝdlabǝn mbirawo. ");
INSERT INTO plj_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Nan kiri mǝn keri bar ju ɗiri Yam, na mǝn momi shirǝm tu Yam bi Musa den ngeni tǝp tu kan wi ri Yesu eka gwa, ama bǝrti ba ci wur den mbarǝmi. ");
INSERT INTO plj_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Kan Shetan ba te gip Yahuda kan ba wul ti'e Iskaryoti gwa, nǝm gip kutl cet rop ju. ");
INSERT INTO plj_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Kan Yahuda ba ri kar kiri mǝn keri bar ju nan ɗiri Yam na kiri gip mǝn ne ger den Bom kǝ Yami, kan tǝ bali nan wur den kanda tu kan ti bali kar Yesu gwa. ");
INSERT INTO plj_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ar gholi wur mbatli, kan bi ba nde wur nǝm den wi bi ti wurpi. ");
INSERT INTO plj_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Tǝ nǝmi wuri, kan tǝ pi ta ngeni guntǝp tu kan ti bi Yesu am dawur nan mbarǝm ba nǝra lasi na womti da gwa. ");
INSERT INTO plj_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Nan pǝt burodi nan na yisti da'a ɗiro, pǝt tu kan ba mbosh bagala pashi bǝdlabǝn dene gwa, ");
INSERT INTO plj_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesu kar Bitǝrus na Yohana, tǝ wul wur'e, <<Rǝnǝka kǝ pi mini bar kǝ jikat bǝdlabǝn mǝ cini.>> ");
INSERT INTO plj_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Wu wul ti'e, <<Akon kǝ ndu'e mǝ pi we?>> ");
INSERT INTO plj_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Tǝ wul wur'e, <<Kǝn ni kǝ te gip bǝno, mbarǝm gon ra na tat mal ba mo nan kǝne, kop tǝni kǝ rǝni bom tu tǝ te gipi gwa. ");
INSERT INTO plj_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Kan kǝ wulni ba mǝn bomi'e, <Ba mǝn kulci wul ki'e, <<Kushi shu'i mǝn diki nǝko, las tu ami na mir mǝn kartǝn gǝn ba ci fingal jikat bǝdlabǝn gwa we?>> > ");
INSERT INTO plj_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ti ta'i in am den bar kushi kǝ to yami ka, na bar ju kup kǝ ndu gwa gipi. Pi ni lasi.>> ");
INSERT INTO plj_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Wu ndara wu ri zam kup bar ju nan Yesu yari wur gwa. Kan wu pi bar kǝ jikat bǝdlabǝni. ");
INSERT INTO plj_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nan bar mbi denewo, Yesu na mir mǝn kartǝn gǝs ba dǝm bi gali. ");
INSERT INTO plj_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Kan tǝ wul wur'e, <<A ndu na ghol mbatl na nari A ci biki jikat bǝdlabǝn kǝn nan kǝn kan a nde kumi dli. ");
INSERT INTO plj_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","A yari ine, A'i ci biki jikat bǝdlabǝn da'a, se argon tu ba ci bikiyi den am gǝsni la'i gip mulki kǝ Yam wu gwa.>> ");
INSERT INTO plj_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Kan tǝ pǝn wuro mal inabi, tǝ goode Yam tǝ wule, <<Nǝm ni kǝ ghorti ni kup gini. ");
INSERT INTO plj_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","A yari ine, A'i tla mal gǝri kin inabi da'a se mulki kǝ Yam ni sur kani.>> ");
INSERT INTO plj_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Kan tǝ pǝn burodi, tǝ goode Yam, tǝ cettǝli, kan tǝ bi wuri, tǝ wule, <<Dli gǝn kan bi sabo nan kǝn gwa utu, pini ta pi untu kǝ tuneni namǝni.>> ");
INSERT INTO plj_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Untuni esi, kar dǝ fingal kǝ gaso, tǝ pǝn wuro mal inabi, tǝ wule, <<Wuro mal kǝno pel alkawari kǝ bǝran gǝn ni, muntu shoti sabo nan kǝn gwa, ");
INSERT INTO plj_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","ama mǝn den si am gip gal nǝm na muntu kan ba rin kǝ la'i gǝs yam gwa. ");
INSERT INTO plj_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Nya Mbarǝm ba mǝsh den argon tu Yam ne bi dene gwa, ama kashto kǝ mbarǝm tu kan la'i ti gǝs yam gwa!>> ");
INSERT INTO plj_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Kan wu nǝm tambe ezǝn den'e, woni gip wur ba dǝm'e tin ti pi argon tuwu. ");
INSERT INTO plj_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Kan musu ba tli gip dlom gǝzǝn den'e woni ba dǝm bari gip wuri. ");
INSERT INTO plj_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesu wul wur'e, <<Gun kǝ munju kan mom Yam da'a ma, wu gode mbarǝm gǝzǝn iko, kup na untuwo mǝn cina ja ba ne gam gǝzǝn mǝn pitǝn dlatni. ");
INSERT INTO plj_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ama kǝno untun ki pi da'a. Kǝno, bari gip kǝno tǝ pali gam gǝs wule ti'e heli, kǝ cina gin ngapo wu pali gam gǝzǝn wule zhere. ");
INSERT INTO plj_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ofawo woni'e bari, muntu kan na fingal cina da ti gwaya ko muntu bi fingali gwa? Muntu kan na fingal cina da ti gwani diya? Ama kup na ami'e bari gip kǝno, ami nǝra wule mǝn pi fingal gini. ");
INSERT INTO plj_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Kǝnni kǝ ndem kaari gip goji gǝni. ");
INSERT INTO plj_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","A bi in iko kǝ pini mulki wule gunye, kanda tu kan Ba-Gun Yam bim gwa, ");
INSERT INTO plj_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","don kǝ ci kǝ tlani den tebur gǝn gip mulki gǝni, kǝ dǝm den dandi kǝ sarauta kǝ pini sharia bom kutl cet rop kǝ Isra'ila. ");
INSERT INTO plj_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Siman, Siman, kumi, Shetan tambe'e dǝ za ti tǝ gode ine, tǝ bǝtke in wule alkama. ");
INSERT INTO plj_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ama a shirǝm na Yam den am gin wi, Siman, ba dǝ la'i mbatl gi ɗatka da’a. Kin kǝ ci atl gam kǝ bali wani pitǝn gi kar gwa, ɓa'i bigul ya'ǝni.>> ");
INSERT INTO plj_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Siman nǝmi ti tǝ wule, <<Babomi, a pǝni mbatl gǝn a tǝ nan ki gip bom kǝ moni, ko a mǝsh nan ki.>> ");
INSERT INTO plj_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu wul ti'e, <<A yari'i, Bitǝrus, kamin dǝ tus kor laa yar sekǝno, ki wule kǝ momǝn da'a bisi myakan.>> ");
INSERT INTO plj_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Arni Yesu wul mir mǝn kartǝn gǝs'e, <<Gas tu a kar kǝn am koni, kǝ pǝn posh wurpi, ko bar posh, ko kaptǝlan dawo unun kǝ holu?>> Wu wule, <<Ko nǝm.>> ");
INSERT INTO plj_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Tǝ wul wur'e, <<Ama kǝkǝno, kǝnni na bar posh na posh wurpiwo pǝnni, muntu na bar suɓur dawo, ya wur lulur gǝska tǝ wur nǝm. ");
INSERT INTO plj_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ar ra na rǝshi gip shirǝm kǝ Yami, <Dlǝm ti gip mǝn warwat pitǝne,> A yari inra, shirǝm tu ba pa demǝni. Untuni es kup bar ju rǝsh demǝno, demǝnni ba la'i.>> ");
INSERT INTO plj_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Mir mǝn kopi gǝs ba wule, <<Ɓa shini, Babomi, bar suɓur rop ni jini.>> Tǝ wul wur'e, <<Ar kǝmwi.>> ");
INSERT INTO plj_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu ɗǝl tǝ to gǝs den tlǝndǝr kǝn zaitun kanda tu tǝ kur pi gwa, kan mir mǝn kopi gǝs ba kop ti. ");
INSERT INTO plj_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Na mbu'i bar lasiwo, ar ni tǝ wul wur'e, <<Shirǝmni na Yam bǝse kǝ ndani gip godetǝne.>> ");
INSERT INTO plj_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Tǝ isha tǝka kar wuri den bi dlyamtǝn kǝ la'i tate, tǝ ngus atl tǝ shirǝm na Yami. ");
INSERT INTO plj_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","<<Bǝba, arni pǝni'i mbatlo, pǝnim kumi dli kǝnka, kup na untuwo, dǝ kop pǝni kǝ mbatl gi ba'e gwan da'a.>> ");
INSERT INTO plj_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Kan mǝn kartǝn kǝ Yam ba cwat sur yam tǝ ɓa'i ti bigule. ");
INSERT INTO plj_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Tǝ mbi gip dun mbatl na nari wi, ar ni tǝ meti shirǝm na Yam hoyi, kan bangani ba nǝm ɗǝltǝn den ti wule gudǝl bǝran ba ro atli. ");
INSERT INTO plj_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nan tǝ shirǝm na Yam tǝ tlyam tǝ pal ɗir kar mir mǝn kopi gǝso, Yesu zam wur den nde umuri, nan dun mbatl nari wurka gwa. ");
INSERT INTO plj_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Tǝ tambe wur, tǝ wule, <<Imni kǝ nde umurka wu? Tlini yam kǝ shirǝmni na Yami bǝse kǝ ndanika gip godetǝne.>> ");
INSERT INTO plj_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu'i gip shirǝmo ar ni mbarǝm na womti ɗiri, kan mbarǝm tu ba wul ti'e Yahuda, nǝm gip kutl cet ropi, tin tǝ nde wur cina. Tǝ te kar Yesu tǝ shirǝmi ti na sumba den shirmitǝn kǝ mǝn Yahuda. ");
INSERT INTO plj_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ama Yesu tambe ti tǝ wule, <<Yahuda, ki bali kar Nya Mbarǝm na sumba ya?>> ");
INSERT INTO plj_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Nan mǝn kopi Yesu shin argon tu kan ba ri kǝ pitǝno, ar ni wu wule, <<Babomi, an mbi’e mǝ wotl na bar suɓur gǝmiwa?>> ");
INSERT INTO plj_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Kan gon gip wur ba wotl zher kǝ bar mǝn keri bar ju kan ɗiri Yam gwa, tǝ pǝni ti kǝm kǝ shimli den gamka. ");
INSERT INTO plj_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ama Yesu nǝmi wur tǝ wule, <<Zani untu!>> Kan Yesu ba ne am den kǝm kǝ mǝri tǝ warke ti. ");
INSERT INTO plj_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Kan Yesu ba wul kiri mǝn keri bar ju ɗiri Yam gwa, na kiri mǝn ne ger den Bom kǝ Yam, na kiri kǝ bǝni, mǝn ju ɗir kǝ nǝmi gǝs gwa, <<Kǝ ɗir na bar suɓur na dlo kǝ nǝmi gǝno ami mur mǝn dlǝri den tǝp na? ");
INSERT INTO plj_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ko gonge pǝte ami ra nan kǝn gip bom kǝ Yami, kǝ nǝmǝn da'a. Ama kǝkǝn ni'e wokoci gini na iko kǝ dǝmǝni.>> ");
INSERT INTO plj_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Wu nǝm Yesu, wu ndara nan ti wu te ti gip bom dǝ bar mǝn keri bar ju ɗiri Yam gwa. Bitǝrus kop wur nye pǝrsi nye pǝrsiyi. ");
INSERT INTO plj_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ama wokoci tu wu hor utu dlom dǝbom bomiwo kan wu dǝm atl kup gǝzǝni, Bitǝrus dǝm atl nan wuri. ");
INSERT INTO plj_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nye mǝn bom gon nye gǝr shin Bitǝrus njon atl lasi gip cirtǝn kǝ utu. Tǝ shin ti zhetzhet tǝ wule, <<Mbarǝm tu ma tǝ ra nan ti.>> ");
INSERT INTO plj_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ama tǝ nge, tǝ wule, <<Nye gǝre, a mom ti da'a.>> ");
INSERT INTO plj_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ɓom dǝmika njemo, bakos gon ba pa shin ti kan tǝ wule, <<Ki ma kin gip wuri.>> Ama Bitǝrus nǝmi ti tǝ wule, <<Bakos mbarǝme, ami ra gip wur da'a.>> ");
INSERT INTO plj_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Bar kǝ awa nǝm den kariwo, bakos gon ba dlǝr den yari'e, <<Na ho bi ni mbarǝm tu ra nan ti, domici tǝ ma ba mǝn Galili ni.>> ");
INSERT INTO plj_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Bitǝrus bali ti tǝ wule, <<Bakos mbarǝme, a mom argon tu nan kǝ shirǝm dene da gwa!>> Gip lasi tǝ gip shirǝm ituwi, ar ni tus kor laa yare. ");
INSERT INTO plj_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Kan Babom ba bal ti tǝ wi ger ndǝr te den Bitǝrus ka. Kan Bitǝrus ba dami shirǝm tu Babom yari ti gwa den'e, <<Kapǝn dǝ tus kor laa yar sekǝno, ki wule kǝ momǝn da'a bisi myakan.>> ");
INSERT INTO plj_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ar ni tǝ ɗǝl gǝs te karika kan tǝ kul na nari. ");
INSERT INTO plj_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Mbarǝm ju kan den ne ger den Yesu ba nǝmi ti yari zhe'e shirǝm kan wu den ɓe gǝsi. ");
INSERT INTO plj_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Wu ɓali ti bagerka kan wu wul ti'e <<Pi mi anapci, woni ɓo iwe?>> ");
INSERT INTO plj_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Wu yari ti wani shirǝm jen'es na womti. ");
INSERT INTO plj_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nan bartlowo, ar ni domtǝn kǝ kiri kǝ bǝn kǝ mǝn Yahuda na kiri mǝn keri bar ju nan ɗiri Yam gwa, kup na mǝn momi shirǝm tu nan Yam bi Musa gwa, wu dom wuri, kan ba ri Yesu cina da wuri. ");
INSERT INTO plj_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Wu wul ti'e, <<Yari mi, ko ki ni'e Almasihu?>> Yesu nǝmi wur tǝ wule, <<Amin a yari in ma ar ba nǝmi in mbatl da'a, ");
INSERT INTO plj_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","amin a tambe in eso ki mani kǝ balin da'a. ");
INSERT INTO plj_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ama kǝkǝn na cina ɗewo, Nya Mbarǝm ba dǝm den am shimli kǝ Yam mǝn iko.>> ");
INSERT INTO plj_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Kan wu tambe kup gǝzǝn wu wule, <<Ki nya Yam na?>> Tǝ nǝmi wur tǝ wule, <<Untun kǝ yari'e amini.>> ");
INSERT INTO plj_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ar ni wu wule, <<Kǝ unun mǝ'i ngen seda jen ra wu? Ar tu mǝ kum bi da ti wi gwa.>> ");
INSERT INTO plj_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Kan kiri kǝ bǝn kup ba la Yesu cina wu ri ti cina dǝ Bilatus gun kǝ Roma. ");
INSERT INTO plj_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Kan wu nǝm gadlǝr gǝsi, wu wule, <<Mǝ zam mbarǝm kǝn ne mi den guzǝl mbarǝm kǝ atl gǝmi ka. Tǝ wul wur'e, <Ba wu ɓatl wurpi bom dǝ Kaisar da'a,> Eso tǝ wule, ti ni'e Almasihu gunye.> >> ");
INSERT INTO plj_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Kan Bilatus ba tambe Yesu, tǝ wule, <<Ki ni'e gun kǝ mǝn Yahuda ya?>> Yesu nǝmi ti, tǝ wule, <<Yari gi utu.>> ");
INSERT INTO plj_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Kan Bilatus ba yari kiri mǝn keri bar ju ɗiri Yam gwa, na mbarǝm ju nan ra lasi gwa, <<Amiwo a zam mbarǝm kǝn na jiltǝn gon da'a.>> ");
INSERT INTO plj_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Arni wu hori ti utu ra, wu wule, <<Na kulci gǝs ni tǝ tli mbatl mbarǝm kǝ atl kǝ Yahuda kup. Ya nǝm ni tor Galili, tǝ kop las har tor ɗe.>> ");
INSERT INTO plj_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Na kumi untuwo, arni kan Bilatus ba tambe ko ti ba mǝn Galili ni. ");
INSERT INTO plj_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Nan ya kum'e ti ni gip atl kǝ Hiriduso, arni tǝ wule dǝ ri ti cina dǝ Hiridus, muntu kan ra su Urushalimaka gip muri ju gwa. ");
INSERT INTO plj_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Nan Hiridus shin Yesuwo, ar gholi ti mbatl nari, domicin tunkani ya den ndu'i shini kǝ Yesu, don tǝ ɓom muri na kumi shirǝm den tǝwi, ndu'i gǝso dǝ Yesu pi bar kǝ dlǝkǝntǝn jen tǝ shini. ");
INSERT INTO plj_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Kan Hirudus ba tambe ti bar na womti, ama Yesu yon gǝs top. ");
INSERT INTO plj_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Kiri mǝn keri bar ju kan ɗiri Yam na mǝn kulci doka tu Yam bi Musa gwa ra dlor-dlor, kan wu pi ta ɗiri shirǝm li gam mǝn ndǝrtǝn den Yesu na womti. ");
INSERT INTO plj_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Kan Hirudus na mǝn bi'utu gǝs ba nǝmi ti yari usun shirǝm na shini shu, kan wu la'i ti bar lulur kǝ gunye, wu pali ti rǝn kar Bilatus ka. ");
INSERT INTO plj_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ter kawo Hirudus na Bilatus ba kum gos kǝ ezǝn da'a, ama daga gastuwo arni wu dǝm berǝmi. ");
INSERT INTO plj_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Bilatus la bi kiri mǝn keri bar ju ɗiri Yam gwa, na kiri kǝ bǝni na nami mbarǝme, ");
INSERT INTO plj_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","kan tǝ wul wur'e, <<Kǝ ɗirim mbarǝm kǝn den tǝ tli mbatl mbarǝme. A ngen momi bar ju kǝ yari den ti cina da'ine, ar tu a zam ti na am gip bar ju kǝ yari den ti gwa da'a. ");
INSERT INTO plj_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Hiridus ma untu ni, ar tu ya pali ti ɗir am dami wi, ar tu kǝ shin ya pi argon nan ndari dǝ ri ti e gwa da'a. ");
INSERT INTO plj_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ra untuwo, a ɓo ti a za ti tǝ ndara. ");
INSERT INTO plj_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Arni kup gǝzǝn wu la yar na bi nǝm, wu wule, <<Pika na mbarǝm tu, kan kǝ pǝtli mi Barabas!>> ");
INSERT INTO plj_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barabas kan ɓal ti bom-moni den tǝ kem dǝ tli mbatl mbarǝm kǝ bǝn kan ba ri gon eka gwa). ");
INSERT INTO plj_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Bilatus ndu'e tǝ pǝtl Yesu ka, arni tǝ shirǝm nan wur ra esi. ");
INSERT INTO plj_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ama wu tli na womi bari, wu wule, <<Dǝ giciye ti ka! Dǝ giciye tǝ ka!>> ");
INSERT INTO plj_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Kǝ myakani, Bilatus ba wul wur'e, <<Den unu? Unun mbarǝm kǝn pi wani wu? A zam argon den ti nan ndari dǝ ri ti eka gwa da'a. Ra untuwo, a kem dǝ ɓo ti kan a pǝtl tǝ ka.>> ");
INSERT INTO plj_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ama la'i yar gǝzǝn na nari den liri dǝ ri ti ekawo, ar kem tǝ kopi wuri. ");
INSERT INTO plj_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Arni Bilatus gudlumi tor mbatl den ti pi wur argon tu wu ndu gwa. ");
INSERT INTO plj_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Kan tǝ pǝtli wur mbarǝm tu kan la ti bom-moni den tǝ tli mbatl bǝn yam kan ba ri gon eka gwa, muntu wu wul ra gwa, tǝ bi wur Yesu wu pi ti argon tu wu ndu gwa. ");
INSERT INTO plj_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Nan wu den ritǝn na Yesuwo, arni wu nǝm Siman ba mǝn Sayirin, muntu ɗǝl ɗir bi lǝp tǝ te gip bǝn utuwi gwa. Wu ne ti giciye kǝ Yesu yar wu wul ti'e, tǝ kop Yesu kari. ");
INSERT INTO plj_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Mbarǝm na womti ba kop tǝ kari, na mǝtli gip wur munju den kulu na ɓe ngetl guna den ti gwa. ");
INSERT INTO plj_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesu bali ger kaar tǝ wul wur'e, <<Mǝtli kǝ Urushalima, kulim ni gam da'a, ama kuli ni gam gin na mimir gini. ");
INSERT INTO plj_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Don pǝt jen ba ɗir lokoci tu ki wule, <njikǝn na mǝtli ju kan zam gǝri da'a, na nyin ju kan tle wur da ma wu mani ghol mbatli.> ");
INSERT INTO plj_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Untuwo, mbarǝm ba wul tlǝndǝr'e, <Nde mi ni gamka!> wu wul zhiki'e, <Kup mi nika!> ");
INSERT INTO plj_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Mbarǝm ni pii yari kin untuwo, imnu ba ndo na koni we?>> ");
INSERT INTO plj_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Mbarǝm jen rop, kup gǝzǝn mǝn wani pitǝne, ba laa wur cina dǝ ri ri wur eka nan ti. ");
INSERT INTO plj_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Nan wu ɗir las tu ba wul ti'e Kula-gamo, kan wu ɓa ti den giciye bartu, nan ti na mǝn warwat pitǝn ju, nǝm den am shimli, nǝm am yali gǝsi. ");
INSERT INTO plj_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesu wule, <<Bǝba, gafarte wuri, domici wu mom argon tu wu den pi gwa da'a.>> Kan wu pi caca den lulur gǝs wu rabe. ");
INSERT INTO plj_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Mbarǝm dlǝr wu den shini, kiri kǝ bǝn ma wu yari ti zhe'e shirǝmi, wu wule, <<Tǝ ɗǝli jen wi tǝ ɗǝli gam gǝs la, in zǝzar ti den ti'e Almasihu kǝ Yam gwa.> >> ");
INSERT INTO plj_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Mǝn bi utuyi ma wu ɗir yari ti zhe'e shirǝmi, wu ta'i ti mati male. ");
INSERT INTO plj_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Wu wul es'e, <<Ɗǝli gam gi, in ki ni'e gun kǝ mǝn Yahuda gwa.>> ");
INSERT INTO plj_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","To gami da ti kawo arni wu rǝsh'e, MƏNKƏN NI'E GUN KƏ MƏN YAHUDA ");
INSERT INTO plj_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Mǝn nǝm gip mǝn warwat pitǝn ju kan giciye wur lasi, ba yari tǝ mǝgǝn shirǝm tǝ wule, <<Ki ni'e Kǝristi diya? Ɗǝli gam gi nam mi mana!>> ");
INSERT INTO plj_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ama esi tu ba matl ti, tǝ wul ti'e, <<Kǝ bǝrti Yam diya, ar tu kǝ ri e nan ti nan pi in shari'a nǝm nan ti gwa ya? ");
INSERT INTO plj_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Miwo hukunte mi dlat. Mǝn den nǝmi argon tu ndar pitǝn gǝmi gwa. Ama mbarǝm tuwo tǝ pi warwat bar gon da'a.>> ");
INSERT INTO plj_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Kan tǝ wule, <<Yesu, daa mom namǝn kin kǝ mbi gip mulki giwi gwa.>> ");
INSERT INTO plj_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu ba nǝmi ti tǝ wule, <<Na hobini a yari i, sekǝn tu ma ki nǝra namǝn to yamka.>> ");
INSERT INTO plj_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Bar ju ba piwo pǝt to dlom yamwi, arni dǝmǝn nda gip atl kup ar ba ri gǝlla am myakan kǝ siti. ");
INSERT INTO plj_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Don pǝt za cirtǝnka, kan labǝle kǝ Bom kǝ Yam ba tarka gip dlomi. ");
INSERT INTO plj_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesu ba la yar na nari, tǝ laa bi tǝ wule, <<Bǝba, gip am da'ini a bi rai gǝni!>> Nan tǝ yari untuwo, kan tǝ dli shukutǝn tǝ kotl mbatlka. ");
INSERT INTO plj_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nan bar mǝn bi utu tu shin argon tu kan piwo, arni tǝ ɗǝɗa Yam tǝ wule, <<Na ho bi mbarǝm tuwo mǝn warwat pitǝnni da'a.>> ");
INSERT INTO plj_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nan kup mbarǝm ju dom wur kǝ shini bar ju shin argon tu piwo, wu ɓo am den ngetl wu ndara. ");
INSERT INTO plj_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ama kup munju mom ti, mǝtli ju kop ti kar tor Galili, wu dlǝr na dlyami wu den shini bar ju den pitǝn gwa. ");
INSERT INTO plj_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ho mbarǝm mǝn zo pitǝn gon ra nan ba wul ti'e Yusufu gwa, ti ni gip kiri kǝ bǝni. ");
INSERT INTO plj_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Tǝ la am gip arjen ju wu gudlumi kan wu pi gwa da'a. Tǝ mǝn atl kǝ Yahudiya gip bǝn Arimatiyani. Tini den ɓuti mulki kǝ Yami. ");
INSERT INTO plj_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Tǝ ri kar Bilatus, tǝ lir dli kǝ Yesu. ");
INSERT INTO plj_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Kan tǝ shu suri, tǝ ghumka gip tutul ghumi mǝshi mbarǝme, tǝ ne gip gam-bǝci kan bor gip tat nan ne murgon gipi wi da gwa. ");
INSERT INTO plj_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Gas kǝrkǝm barni, ar sawi njem dǝ te gip pǝt shukutǝn kǝ mǝn Yahuda. (Asabar) ");
INSERT INTO plj_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Mǝtli ju kan kop Yesu tor daga Galili ba kop Yusufu wu shin gam-bǝci'i, na kanda tu muri dli gǝs su gipika gwa. ");
INSERT INTO plj_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Kan wu ndara wu ri gǝzǝn bom wu kǝrkǝm mir mǝn tǝmi kasǝr na mir bǝrketǝne. Ama wu kop doka kǝ Musa, kan wu shuku den pǝt shukutǝn kǝ mǝn Yahuda. ");
INSERT INTO plj_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Gasi kǝ cigǝni den pǝt lahadi, mǝtli ju ri kǝ ba gam-bǝci'i na mir mǝn tǝmi kasǝri kan wu pi gwa. ");
INSERT INTO plj_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Arni wu zam tat tu kan bi gam-bǝci'iwo kutǝli kawi. ");
INSERT INTO plj_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Nan wu te gipiwo, wu shin dli kǝ Babom Yesu da'a. ");
INSERT INTO plj_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Nan wi gip damtǝn gip mbatl gǝzǝn den bar tuwo, arni parat wu shin mbarǝm rop cwat kar wur dlor, na ghol lulur kǝ dli da wur mǝn cirtǝni. ");
INSERT INTO plj_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Wi gip bǝrtiwo, arni wu ɓa gam atli. Kan mbarǝmi ba wul wur'e, <<Unun kem kǝ ngen mbarǝm mǝn rai gip mǝshi we? ");
INSERT INTO plj_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Tǝ'i da'a, tǝ tli wi! Dam kǝn ni den argon tu tǝ yari in nan tǝ'i nan kǝn su Galilika gwa. ");
INSERT INTO plj_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Den'e baa bi Nya Mbarǝm am dǝ mǝn warwat pitǝne, wi ɓa ti den kini, den pǝt kǝ myakan ngapo ti tli lasi.>> ");
INSERT INTO plj_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Arni wu dam shirǝm gǝsi. ");
INSERT INTO plj_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Nan wu pal ɗiro, arni wu yari kutl cet nǝmi na mbarǝm jen kan ra lasi gwa. ");
INSERT INTO plj_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Mǝtli ju kan yari mir mǝn kartǝn gǝs kutl cet nǝmiwo, wi ni'e, Maryamu Magadala, na Yowanna, na Maryamu nasi Yakubu, na mǝtli jen kan ra nan wur gwa. ");
INSERT INTO plj_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ama mir mǝn kartǝn gǝsi pali shirǝm kǝ mǝtliyika zhe'e shirǝmi, wu la mbatl da'a. ");
INSERT INTO plj_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ama Bitǝrus tlyam kenja, tǝ ri kǝ ba gam-bǝci'i na kǝtǝre tǝ te gipi, tǝ shin tutul ghumi mǝshi mbarǝm tu ghum ti gipi gwa markǝme, arni tǝ pal ɗir bom tǝ den damtǝn den argon tu pi gwa. ");
INSERT INTO plj_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Den pǝt nǝmi eso, rop gip mir mǝn kopi Yesu ra den tǝp gǝzǝn kǝ ritǝn nye bǝn gon kan ba wul ti'e Imawus, muntu dlyamtǝn gǝs na Urushalimawo bar kǝ mil nyingi ni gwa. ");
INSERT INTO plj_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Wi den shirǝm na ezǝn den argon tu pi gwa. ");
INSERT INTO plj_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Wi den shirǝm na bali da wuri, ar ni Yesu na gam gǝs ri kar wuri tǝ nǝm ritǝn nan wuri. ");
INSERT INTO plj_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ama wi ra gip dǝmǝn gami wu mom'e ti ni da'a. ");
INSERT INTO plj_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Tǝ wul wur'e, <<Unun kǝ bali na ya'ǝn untuwu?>> Arni wu dlǝr kǝ ba lasi na dun mbatli. ");
INSERT INTO plj_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Nǝm gip wur muntu ba wul ti'e Kiliyobas nǝmi ti tǝ wule, <<Ki ni'e mǝn diki nangi gip Urushalima kan mom bar ju pi gip mir muri jin gwaya?>> ");
INSERT INTO plj_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Tǝ wul wur'e, <<Unu ari uju we?>> Wu nǝmi ti wu wule, <<Bar ju pi den Yesu kǝ Nazare gwa. Mǝn shirǝm na Yamni hari, mǝn ndǝrtǝn gip pitǝn na shirǝm cina dǝ Yam na mbarǝme. ");
INSERT INTO plj_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Muntu kan kiri mǝn keri bar ju ɗiri Yam na kiri mbarǝm gǝmi la'i ti gǝs yam wu hukumte ti kǝ dǝ tǝ mǝshi, wu pa giciye tǝ ka. ");
INSERT INTO plj_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Mǝ la mbatl den tin ti ɗǝli Isra'ila, ar tu sekǝno muri myakan ikǝnwi na pitǝn kǝ bar tu. ");
INSERT INTO plj_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Eso, mǝtli jen gip mi dlǝkǝn mi, wu ri kǝ ba gam bǝci'i kǝ cigǝni, ");
INSERT INTO plj_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ama wu zam dli gǝs da’a. Nan wu pal ɗiro, wu wule wu shin mir mǝn kartǝn kan ɗǝl sur kar Yam nan wul wur'e Yesu ra na rai gwa! ");
INSERT INTO plj_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Jen gip mi kǝtǝr rǝnka kǝ dǝ wu shini ger gǝzǝni, arni wu zam kanda tu mǝtli ju yari gwa, ama tiwo wu shin ti da'a.>> ");
INSERT INTO plj_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Arni Yesu wul wur'e, <<Kǝn kǝdlǝme! Mǝn iɗa mbatl kǝ nǝmi bar ju kup mǝn shirǝm na Yam yari gwa. ");
INSERT INTO plj_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kǝ mom'e ar nǝm Almasihu te yarka dǝ tǝ kum dli den bar ju kup kan tǝ to gǝs gip nartǝn gǝs da'aya?>> ");
INSERT INTO plj_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Pare den rǝshi kǝ Musa na mǝn shirǝm na Yam kup, tǝ ɓuli wur argon tu rǝsh gip Shirǝm kǝ Yam kup den ti gwa. ");
INSERT INTO plj_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Nan wu ɗir kar nye bǝn tu wu riwo, Yesu pi wule ti ɓeni cina, ");
INSERT INTO plj_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ama wu lir ti wu wule, <<Dǝm nan mi, sit pi wi, pǝt ba ri kǝ ndetǝn bin wi.>> Kan tǝ ri bom nan wuri. ");
INSERT INTO plj_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nan wu dǝm kǝ ci fingalo, arni tǝ pǝn burodi, tǝ lir Yam, tǝ cetǝli kan tǝ nǝmi wur bi. ");
INSERT INTO plj_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Kan ger gǝzǝn ba ɓuli, nan wu mom tiwo, ar ni tǝ jili wur gerka. ");
INSERT INTO plj_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Wu wul ezǝn'e <<Mbatl gǝmi ker gip mi bitu tǝ shirǝm nan mi den tǝp nan tǝ ɓuli mi Shirǝm kǝ Yam gwa diya? ");
INSERT INTO plj_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Workǝca, arni wu pal su Urushalima ka, kan wu zam kutl cet nǝm ju kan dom wur kǝba las nǝm gwa, na nami mbarǝmi. ");
INSERT INTO plj_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Wu den wultǝn'e, <<Na ho bini Babom tli wi, tǝ ɗǝl kar Biturus!>> ");
INSERT INTO plj_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Wi ropi ngapo wu yar argon tu pi den tǝp gwa, na kanda tu wu mom ti nan tǝ cetǝli wur burodi gwa. ");
INSERT INTO plj_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Wu'i gip shirǝm dene ituwi, arni Yesu dlǝr dlor gip dlom da wur tǝ wule, <<Dǝ ghol mbatl dǝm nankǝne.>> ");
INSERT INTO plj_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Bǝrti nǝm wuri dli gǝzǝn den dǝdartǝni, wu wule tlonni wu shini. ");
INSERT INTO plj_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Arni tǝ wul wur'e, <<Unun kem bǝrti nǝm kǝne, kǝ kum wule untuni pi dawu? ");
INSERT INTO plj_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Shin ni am gǝn na kar asǝm gǝni, ami ni na gam gǝni, neni am demǝni kǝ shin ni na gam gi ni, ai tlon ra na tlu dli na gul da’a, amo kǝ shin ami ra nari.>> ");
INSERT INTO plj_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Nan tǝ wul untuwo, tǝ gode wur am na kar asǝm gǝsi. ");
INSERT INTO plj_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Kan wu den ghol mbatl hoyi na nǝmi bi na amo, ama wu den shinni, wule untuni pi dawo, arni tǝ wul wur'e, <<Kǝn ra na bar kǝ ci ɗeya?>> ");
INSERT INTO plj_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Wu bi ti bo'i kose, ");
INSERT INTO plj_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","arni tǝ nǝm kan tǝ ci cina da wuri. ");
INSERT INTO plj_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Tǝ wul wur'e, <<Bar ju kan a yari in gwa uju, nan a'i nan kǝn gwa, den'e, doleni dǝ laa'i kup bar ju nan rǝsh demǝn gip Doka kǝ Musa na tǝlankur kǝ mǝn shirǝm na Yam na Zabura gwa.>> ");
INSERT INTO plj_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Arni tǝ ceti wur gamka dǝ wu mom rǝshi Shirǝm kǝ Yami. ");
INSERT INTO plj_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Tǝ pa wul wur'e, <<Ar ra na rǝshi terka'e, Almasihu ba kum dli den kar muri kǝ myakano tǝ tli lasi. ");
INSERT INTO plj_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Eso, gip sun gǝs ni ba pii atl kundǝrǝndlip wazu kǝ paltǝn kar Yami, na ho'i wani pitǝnka, pare gip Urushalima. ");
INSERT INTO plj_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Kǝn ni kǝ shin bar ju pi gwa. ");
INSERT INTO plj_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ar tu aa kari in bar sur na bar ju Ba gǝn wule ti bi gwa. Ama dǝmni gip bǝn dǝ bi'in iko sur yam kani. ");
INSERT INTO plj_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ar ni Yesu ɗǝli wur kar bǝn Baitanya, lasini tǝ tli am yami, tǝ la'i wur albarka. ");
INSERT INTO plj_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Tǝ den la'i wur albarka ituwi, arni tǝ za wur kan ba pǝn tika to yamka. ");
INSERT INTO plj_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Wi eso, arni wu ngus, wu ɗǝɗa ti, kan wu pal su Urushalima ka, laa'i na ghol mbatl na nari. ");
INSERT INTO plj_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Se na gǝni wi ra te gip Bom kǝ Yamka, wu den ɗǝɗa Yami.");
INSERT INTO plj_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Na la'i gǝs kǝ pi ko unu na unuwo Kalma ra, Kalmayi ra na Yami, kan Kalmayiwo Yam ni. ");
INSERT INTO plj_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ti nǝra na Yam terka kapǝn dǝ pi bar kup. ");
INSERT INTO plj_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Tǝp kar ti ni pi bar kup, argon ra kan Yam pi gip bar ju tǝ pi bat nan ti gwa da'a. ");
INSERT INTO plj_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ti ni'e mǝn bi ge mbatli, ge mbatl tu ngapo ar ni'e cirtǝn kǝ mbarǝmi. ");
INSERT INTO plj_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Cirtǝni ba cir ni gip dǝmǝni, ama dǝmǝni mani tle gam kǝ cirtǝni da'a. ");
INSERT INTO plj_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Mbarǝm gon ra kan Yam kar ti ɗir gwa, mǝn sun'e Yohana. ");
INSERT INTO plj_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Tǝ ɗir ni kǝ dǝ tǝ yari mbarǝm ge shirǝm den cirtǝni, kǝ dǝ mbarǝm kup ngǝsh wur den cirtǝn tu. ");
INSERT INTO plj_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yohana na gam gǝs ni'e cirtǝn tu da'a, tǝ ɗir ni kǝ dǝ tǝ yari mbarǝm ge shirǝm den cirtǝni. ");
INSERT INTO plj_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ho cirtǝn tu kan ba bi cirtǝn ko gonge mbarǝm ra den ɗirtǝn gip atl kundǝrǝndlip. ");
INSERT INTO plj_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Tǝ ra far den kaar atli, kup na tǝp kar ti ni pi atl kundǝrǝndlip, ama mbarǝm den kaar atl mani momi gǝs da'a. ");
INSERT INTO plj_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Tǝ ɗir ni kar mbarǝm gǝsi, ama mbarǝm gǝsi nǝm ti da'a. ");
INSERT INTO plj_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ama munju kup kan nǝm ti, munju kan ngǝsh wur den sun gǝso, tǝ bi wur bi kǝ dǝmi mimir kǝ Yam wi. ");
INSERT INTO plj_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ba'e mimir ju kan gǝri gǝzǝn nǝra kandatu mbarǝm ba gǝri, ko kǝ ba metǝn kǝ gǝr na kosi, ko kǝ ndu'i kǝ mbarǝm gwa da'a, ama gǝri kǝ Yam ni. ");
INSERT INTO plj_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Kalmayi palka mbarǝme kan tǝ dǝm gip dlom gǝmi. Mǝ shin ɗǝɗatǝn gǝsi, ɗǝɗatǝn kǝ nya nǝm tonngǝlan kǝ Yam kan bom, muntu ɗǝl sur kar Bǝbayi gwa, laa'i na zo mbatl kǝ Yam na ge shirǝmi. ");
INSERT INTO plj_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","(Yohana shirǝm den ti. Tǝ tli yar yam tǝ wule, <<Muntu ni'e mbarǝm tu kan a wule, <Mǝn ɗirtǝn den kaar da'ǝmi manǝmi, domici tǝra kapǝn dǝ gǝri mi. ");
INSERT INTO plj_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Tǝp kar laa'i zo mbatl gǝs ni mǝ zam zo mbatl gon ra den goni. ");
INSERT INTO plj_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Domici kulciwo tǝp kar Musa ni bi, ama zo mbatl kǝ Yam na ge shirǝm ɗir ni tǝp kar Yesu Almasihu. ");
INSERT INTO plj_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Murgon ra kan bot shini Yam gwa da'a, ama nya gǝs nǝmi kan bom, muntu kan ti ni'e Yam kan ra na Bǝbayi gwa, ti ni tǝ gode mi Yami.> >> ");
INSERT INTO plj_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Seda kǝ Yohana ikǝn nan mǝn Yahuda kǝ Urshalima kar mǝn keri bar ju ɗiri Yam na mǝn gǝsgal kǝ Lawi kǝ wu ngen momi den ko ti woni gwa. ");
INSERT INTO plj_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Tǝ nge yari da'a, ama tǝ ɓul bi tǝ wule, <<Ami ni'e Almasihu da'a.>> ");
INSERT INTO plj_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Wu ngen momi kar ti wu wule, <<To ki ni'e wowe? Ki ni'e Iliya ya?>> Tǝ wul wur'e, <<Ami ni da'a.>> Wu wul ti'e,<<Ki ni'e mǝn yari shirǝm kǝ Yam tu ya?>> Ar ni tǝ nǝmi wur tǝ wule, <<O'o.>> ");
INSERT INTO plj_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Kan wu pa'i na wultǝn'e, <<Ki ni'e wowe? Yari mi argon tu kan mii bali munju kan kar mi ɗir gwa. Unun kǝ wul gam gi rawe?>> ");
INSERT INTO plj_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yohana bali wur gip shirǝm kǝ mǝn yari shirǝm kǝ Yam Ishaya tǝ wule, <<Ami ni'e yar mǝn latǝn bi gip lǝpe, <Kǝrkǝmi ni guntǝp Babom ar dǝm sat.> >> ");
INSERT INTO plj_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ar ni mǝn Parise jen kan kar wur gwa ");
INSERT INTO plj_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ngen momi kar Yohana wu wule, <<Kan unun kem kǝ pi mbarǝm batisma nan ki ni'e Almasihu ko Iliya, ko mǝn yari shirǝm kǝ Yam tu da gwa?>> ");
INSERT INTO plj_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yohana nǝmi wur tǝ wule, <<A pini mbarǝm batisma na male, ama gip kǝno gon ra kan kǝ mom ti da gwa. ");
INSERT INTO plj_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ti ni'e muntu kan ba ɗir kaar da'ǝmi, muntu zap kaptǝlan gǝs ma a kǝm pǝtli da gwa.>> ");
INSERT INTO plj_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Muntu kup pini gip nye bǝn kǝ Betanya den kǝti bi ɓula kǝ Urdun, las tu kan Yohana den pi mbarǝm batisma gwa. ");
INSERT INTO plj_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Bar tlowo ar ni Yohana shin Yesu den tertǝn kar ti, kan tǝ wule, <<Shin ni nye tǝm kǝ Yami, muntu kan ra na warwat pitǝn kǝ mbarǝm kǝ atl kundǝrǝndlip gam da ti gwa! ");
INSERT INTO plj_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ti ni'e muntu kan a shirǝm den ti gwa nan a wule, <Mǝn ɗirtǝn den kaar da'ǝmi manǝmi, domici tǝra kapǝn dǝ gǝri mi.> ");
INSERT INTO plj_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Kup na ami na gam gǝn ma a mom ti da'a, ama argon tu kem a ɗir ami den pi mbarǝm batisma na mal gwa ni'e kǝ dǝ mom ti ra gip Isra'ila.>> ");
INSERT INTO plj_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Kan Yohana ba bi seda'e, <<A shin ruhu kǝ Yam den surtǝn na dli wule kǝ kuɓuri kan ba dlǝr den ti. ");
INSERT INTO plj_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Faro, a mom ti da'a, ama muntu kan karǝm kǝ pi batisma na mali yarim'e, <Mbarǝm tu kan kǝ shin Ruhu sur kan ba dǝm den ti ni'e muntu kan baa pi mbarǝm batisma na Ruhu kǝ Yam gwa.> ");
INSERT INTO plj_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","A shin wi kan a yari den'e muntuwo Nya Yam ni.>> ");
INSERT INTO plj_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Bar tlo eso Yohana ra dlor na rop gip mir mǝn kulci kar ti. ");
INSERT INTO plj_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Nan tǝ shin Yesu den wucetǝno, ar ni tǝ wule, <<Shin ni! Nye Tǝm kǝ Yam ta!>> ");
INSERT INTO plj_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Nan mir mǝn kulci kar ti ropi kum tǝ yari untuwo, ar ni wu kop Yesu kaari. ");
INSERT INTO plj_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu bali ger kaaro ar ni tǝ shin wur den kopi gǝsi, kan tǝ ngen momi kar wur tǝ wule, <<Unun kǝ ndu we?>> Ar ni wu wule, <<Rabbi, (Ba mǝn kulci ituwi), a ko ni kǝ dǝm we?>> ");
INSERT INTO plj_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yesu nǝmi wur tǝ wule, <<Ɗir shin ni.>> Ar ni wu ri nan ti kan wu shin las tu tǝ dǝm gwa, wokociyiwo bar kǝ gǝlla am wupse ni kǝ siti, kan wu pa'i nde pǝt nan ti. ");
INSERT INTO plj_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andǝrawus, erǝm kǝ Siman Bitǝrus ni'e nǝm gip ropi kan kum argon tu Yohana yari kan wu kop Yesu gwa. ");
INSERT INTO plj_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Argon tu Andǝrawus pare piwo ar ni'e, tǝ zam erǝm gǝs Siman kan tǝ wul ti'e, <<Mǝ zam Almasihu wi>> (Zǝzari kǝ Yam ituwi). ");
INSERT INTO plj_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Kan tǝ ɗir nan ti kar Yesu. Ar ni Yesu shin ti, kan tǝ wule, <<Ki ni'e Siman nya Yohana. Baa la ki bi'e Kepas>> (na bi gono Bitǝrus, tat ituwi). ");
INSERT INTO plj_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Bar tlowo, ar ni Yesu pǝn gip mbatl gǝs den'e tii ndara Galili. Ar ni tǝ zam Filibus, kan tǝ wul ti'e, <<Kopǝni.>> ");
INSERT INTO plj_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filibus nye mǝn Betsaida ni, bǝn kǝ ga Andǝrawus na Bitǝrus. ");
INSERT INTO plj_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filibus zam Nataniyel kan tǝ wul ti'e, <<Mǝ zam mbarǝm tu kan Musa mǝn yari shirǝm kǝ Yam rǝsh den ti gip tǝlankur kulci gǝs gwawi, muntu kan ga mǝn yari shirǝm kǝ Yam ma rǝsh den ti gwa'e, Yesu kǝ Nazarat, nya Isubu.>> ");
INSERT INTO plj_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nataniyel ngen momi tǝ wule, <<Baa mani zami ho bar gon gip Nazarata?>> Filibus wul ti'e, <<Ɗir kǝ shini.>> ");
INSERT INTO plj_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nan Yesu shin Nataniyel den tertǝno, ar ni tǝ shirǝm den ti tǝ wule, <<Ho nye mǝn Isra'ilan kǝni, muntu kan setǝn ra gip pitǝn gǝs da gwa.>> ");
INSERT INTO plj_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniyel ngen momi kar ti tǝ wule, <<Im ni kǝ momǝn rawu?>> Yesu nǝmi ti'e, <<A shin ki nan ki ra gǝs kin turum kapǝn dǝ Filibus la ki bi gwa.>> ");
INSERT INTO plj_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Kan Nataniyel ba wul Yesu'e, <<Ba mǝn kulci, ki ni'e Nya Yami! Ki ni'e Gun kǝ Isra'ila.>> ");
INSERT INTO plj_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu wul Nataniyel'e, <<Kǝ ngǝsh ki ni demǝn nan a yari'i den a shin ki gǝs kin turum gwa ya? Kii shin kiri bar ju kan man muntu gwa.>> ");
INSERT INTO plj_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ar ni tǝ pa wul wur'e, <<Na ho bi ni a yari ine, kii shin dlom yam ɓuli, na mir mǝn kartǝn kǝ Yam den totǝn na surtǝn den Nya Mbarǝme.>> ");
INSERT INTO plj_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Den pǝt kǝ myakano nyel gudlumi ra gip bǝn kǝ Kana gip kǝti atl kǝ Galili. Nasi Yesu ra lasi, ");
INSERT INTO plj_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesu na mir mǝn kulci kar ti ma la wur bi kǝ ba gudlumiyi. ");
INSERT INTO plj_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Nan mal kin inabi gǝzǝn pakawo, ar ni nasi Yesu wul ti'e, <<Wu'i na mal kin inabi da'a.>> ");
INSERT INTO plj_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesu bali ti tǝ wul ti'e, <<Nǝna, unun kem kǝ ɗir karǝm rawe? Wokoci gǝn piwi da'a.>> ");
INSERT INTO plj_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ar ni nas wul mǝn pi mbapi'e, <<Pi ni argon tu kup tǝ yari in gwa.>> ");
INSERT INTO plj_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Kosak na lasiwo kiri ran kǝ tat jen ra guduli mukka, nari ni mǝn Yahuda ba pi mbap ju kan Yam ba nǝm gwa tǝp kǝ ba hotǝne, ko gonge gip tati ba mani shoti ti mal bar kǝ tat mal mukka. ");
INSERT INTO plj_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ar ni Yesu wul ga mǝn pi mbapi'e, <<Laa'i ni ran ju na male.>> Kan wu la'i har bisi. ");
INSERT INTO plj_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Kan Yesu ba wul wur'e, <<Kǝkǝno nge ni kǝ ri ni mbarǝm tu kan ne ti gam nyeli gwa.>> Ar ni wu pi untuyi, ");
INSERT INTO plj_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","kan mbarǝm tu ne gam nyeli ba ɓom mali kan palika mal inabi gwa. Tǝ mom las tu ar ɗǝl gwa da'a, mǝn mbap ju kan nge mali gwa ni momi. Kan tǝ la bi ba mǝn gudlumiyi markǝme ");
INSERT INTO plj_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","tǝ wule, <<Ko gonge mbarǝm ba ɗǝli ni mal inabi kan mani tǝmtǝn gwa kakani, den kaariwo kan dǝ ɗǝli muntu kan ri mǝntayi da'a wokoci tu mǝndǝkiyi tla ar kǝm wur wi gwa, ama kiwo kǝ ne muntu mani tǝmtǝn gwa se kǝkǝni.>> ");
INSERT INTO plj_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Muntu ni'e halama bar kǝ dlǝkǝntǝn kǝ Yesu kǝ nǝm, tǝ pini muntu gip bǝn kǝ Kana gip kǝti atl kǝ Galili. Na untu ni tǝ gode ɗǝɗatǝn gǝsi, kan mir mǝn kulci kar ti ba ngǝsh wur den ti. ");
INSERT INTO plj_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Den kaar kǝ untuwo, ar ni Yesu ndara Kaparnahum nan ti na nase na mir mǝn gǝpi gǝs na mir mǝn kulci kar ti. Wu dǝm suka kǝ mir muri jeni. ");
INSERT INTO plj_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Nan wokoci Nyel Jikat Bǝdlabǝn kǝ mǝn Yahuda piwo, ar ni Yesu to gǝs Urshalima. ");
INSERT INTO plj_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Te gip dǝbom bom kǝ Yam kawo, ar ni tǝ zam mbarǝm den ta wuri ga tla, tǝm na kuɓǝrka, kan na jen njon den tebǝr wu den bali wurpi. ");
INSERT INTO plj_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ar ni tǝ miri zap tǝ pi rǝɓa nari, kan tǝ kar wurka gip bom kǝ Yami, kup na tǝm na tlayi, kan tǝ jirkǝt ga tebǝr gǝzǝnka tǝ wi ge wurpi kǝ mǝn bali wurpiyika. ");
INSERT INTO plj_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ar ni tǝ wul munju kan ba wur ga kuɓǝrika gwa'e, <<Ɗǝli ni bar ju ɗeka! Ba kǝ pali ni bom kǝ Ban ka ba bar pǝt da'a!>> ");
INSERT INTO plj_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ar ni mir mǝn kulci kar ti dami den ar ra na rǝshi gip shirǝm kǝ Yam'e, <<Ghuve kǝ ndu'i bom gi baa cim mbatl naari.>> ");
INSERT INTO plj_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ar ni kiri kǝ mǝn Yahuda ngen momi wu wule, <<Unu bar kǝ dlǝkǝntǝn ni kii pi kan baa gode iko gi kǝ pi bar tu gwawu?>> ");
INSERT INTO plj_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu nǝmi wur tǝ wule, <<Yas ni bom kǝ Yam kǝnka, ami ngapo aa tu lasi gip muri myakan.>> ");
INSERT INTO plj_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Mǝn Yahudayi bali ti wu wule, <<Ar pǝn sheti ghon hauya rop na mukka kan ba'i pa'i tu'i bom kǝ Yam kǝni, ama kǝ ri kǝ tu'i gǝs ra lasi gip muri myakana?>> ");
INSERT INTO plj_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ama bom kǝ Yam tu Yesu ba shirǝm denewo dli gǝs ni. ");
INSERT INTO plj_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Den kaar kǝ tli gǝska gip mǝshi mbarǝm ni mir mǝn kulci kar ti dami argon tu tǝ yari gwa. Kano wu ngǝsh wur den shirǝm kǝ Yam kan ra na rǝshi na shirǝm ju Yesu yari gwa. ");
INSERT INTO plj_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Nan Yesu ra gip bǝn Urshalima wokoci kǝ Nyel Jikat Bǝdlabǝno, ar ni mbarǝm na womti shin bar kǝ dlǝkǝntǝn ju tǝ den pi gwa kan wu ngǝsh wur den ti. ");
INSERT INTO plj_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ama Yesu ne dli den wur da'a, domici tǝ mom mbarǝm kup. ");
INSERT INTO plj_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Tǝ pa ndu dǝ mbarǝm yari ti argon den nya mbarǝm da'a, domici tǝ mom argon tu gip mbatl kǝ ko gonge mbarǝm gwa. ");
INSERT INTO plj_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Mbarǝm gon ra gip mǝn Parise, mǝn sun'e Nikodimu, tǝra nǝm gip mǝn domtǝn kǝ kiri kǝ mǝn Yahuda. ");
INSERT INTO plj_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ar ni mbarǝmi ɗir kar Yesu gip gasi kan tǝ wule, <<Ba mǝn kulci, mǝ mom ki mǝn kulci mbarǝm kan ɗǝl sur kar Yam gwa ni. Domici murgon ra kan baa mani pi halama bar kǝ nǝmi bi na am ju kan kǝ pi gwa da'a Yam ni ra nan ti da gwa.>> ");
INSERT INTO plj_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu nǝmi ti tǝ wule, <<Ge shirǝm ni a yari'i, o gǝr ki ni es dawo, kii shin mulki kǝ Yam da'a.>> ");
INSERT INTO plj_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodimu ngen momi kar ti tǝ wule, <<Imnu baa pa mani gǝri mbarǝm kan korsika gwawu? Rawo, tii mani paltǝn te gip tu dǝ naska dǝ gǝr ti ra dak!>> ");
INSERT INTO plj_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu nǝmi ti tǝ wule, <<Ge shirǝm ni a yari'i, ko nǝm murgon ra kan baa te gip mulki kǝ Yam da'a, e gǝr tǝni tǝp kǝ ba mal na ruhu da gwa. ");
INSERT INTO plj_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Mbarǝmo, mbarǝm ni tǝ gǝri, Ruhu ngapo Ruhu ni tǝ gǝri. ");
INSERT INTO plj_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ba dǝ argon tu a yari'i'e, <Ar nǝm mbarǝm te yarka dǝ gǝr ti esi> dǝmi'i bar kǝ nǝmi bi na am da'a. ");
INSERT INTO plj_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Itǝr ba bǝtl ni gam las tu ar ndu kopi gwa. Kǝ kum wultǝn gǝsi, ama kii mani yari las tu ar ɗǝl ɗir na las tu ar ba ri gwa dak. Untu ni ar ra na ko gonge mbarǝm tu kan Ruhu ni gǝr ti gwa.>> ");
INSERT INTO plj_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ar ni Nikodimu pa ngen momi kar Yesu tǝ wule, <<Imni untu baa pi rawu?>> ");
INSERT INTO plj_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Kan Yesu ba nǝmi ti tǝ wule, <<Bar mǝn kulci mbarǝm kǝ Isra'ila ni'e ki, ama kǝ mani momi bar ju da'a ya?>> ");
INSERT INTO plj_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ge shirǝm ni a yari'i'e mǝ yari ni argon tu mǝ mom gwa, kan mǝ shirǝm ni den argon tu mǝ shin gwa, ama kup na untu kǝ nge nǝmi argon tu mǝ yari in kagwa. ");
INSERT INTO plj_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","A shirǝm ni nan kǝn den bar ju kan kǝ atl ni gwa ama kǝ nǝm da'a, imni kii nǝm ami ni a yari in bar ju kan kǝ to yamka ni gwawu? ");
INSERT INTO plj_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Murgon ra kan taɓe totǝn yam gwa da'a se de Nya Mbarǝm kan ɗǝl sur yam gwa. ");
INSERT INTO plj_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Kandatu Musa tli ici ka zili gǝlla den dlo gip lǝpo, untu ni ar nǝm dǝ tli Nya Mbarǝm yami, ");
INSERT INTO plj_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","kǝ dǝ muntu kup ngǝsh ti den tiwo, tǝ zam ge mbatl tu kan baa pa dagwa. ");
INSERT INTO plj_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","<<Domici Yam ndu atl kundǝrǝndlip naaro, ar ni tǝ bi nya gǝs nǝm kan ra bom gwa, den'e muntu kup ngǝsh den tiwo, ba dǝ tǝ liika katl da'a ama tǝ zam ge mbatl tu kan baa pa dagwa. ");
INSERT INTO plj_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Domici Yam kar ni nya gǝs sur atl kǝ dǝ tǝ hukunte atl kundǝrǝndlip da'a, ama kǝ dǝ mbarǝm den kaar atl kundǝrǝndlip zam ɗǝltǝn ra tǝp kar ti. ");
INSERT INTO plj_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Murgon tu kup ngǝsh den Nya Yamo baa tloyi ti shirǝm da'a, ama muntu kup ngǝsh den ti dawo, tare tloyi ti shirǝm wi domici tǝ ngǝsh ti den sun kǝ Nya Yam kan ne ti nǝm kan ra bom gwa da'a. ");
INSERT INTO plj_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Tloyi shirǝmi ni'e cirtǝn ɗir gip atl kundǝrǝndlip wi, ama mbarǝm ndu dǝmǝnka man cirtǝni, domici pitǝn gǝzǝno kǝ ɗasi tu ni. ");
INSERT INTO plj_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Murgon tu kup ba pi bar kǝ ɗasi tu'o tǝ nge ni cirtǝni, kan tii ndu ɗirtǝn kar cirtǝn da'a, bǝse dǝ pitǝn gǝs ɗǝlka den kaari. ");
INSERT INTO plj_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ama kup mǝn pitǝn koro, tǝ ɗir ni kar cirtǝni, kǝ dǝ shin ra hoyi den'e argon tu tǝ piwo, tǝ pi ni gip kopi shirǝm kǝ Yami.>> ");
INSERT INTO plj_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Den kaar kǝ untuwo, ar ni Yesu na mir mǝn kulci kar ti ndara kǝti atl kǝ Yahuda, las tu kan tǝ ɓom dǝmi nan wur gwa, tǝ den pi mbarǝm batisma. ");
INSERT INTO plj_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Wokociyiwo Yohana ra den pi mbarǝm batisma gip Ainon kan ra kosak na Salim, nan mal ra na naari lasi gwa, kan mbarǝm ba pi ta ɗirtǝn ba pi wur batisma. ");
INSERT INTO plj_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Muntu pi ni kapǝn dǝ la Yohana gip bom moni. ");
INSERT INTO plj_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Kan shirǝm ba gadlǝrka gip dlom kǝ mir mǝn kulci kar Yohana na mǝn Yahuda goni den shirǝm kǝ al'ada hotǝn ju kan mǝn Yahuda ba pi kǝ dǝmi dlǝran den bi doka gǝzǝn gwa. ");
INSERT INTO plj_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ar ni wu ɗir kar Yohana kan wu wul ti'e, <<Ba mǝn kulci, mbarǝm tu kan ra nan ki den kǝti ɓula Jodan, muntu kan kǝ bi seda den ti gwa, tin tu den pi batisma pa'e, mbarǝm ngap den ta ritǝn kar ti.>> ");
INSERT INTO plj_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Den muntuwo ar ni Yohana bali wur tǝ wule, <<Mbarǝm baa mani ni zami argon tu kan bi ti sur yam gwa katl. ");
INSERT INTO plj_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kǝn na gam gin kii mani yari den'e a wule, <Ami ni'e Almasihu da'a, ama karǝm ni cina da ti.> ");
INSERT INTO plj_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Pel gǝro kǝ Ba mǝn pel gudlumi ni. Bar berǝm kǝ mǝn pel gudlumiyi ba ɓut ni kǝ dǝ tǝ kum yar kǝ Ba mǝn pel gudlumiyi. Ti ni tǝ kum yar kǝ Ba mǝn pel gudlumiyiwo, tǝ laa'i na ghol mbatl naari. Tǝp untu ni a pi ghol mbatl hoyi. ");
INSERT INTO plj_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ar nǝm dǝ mbarǝm tu pi ta naartǝni, ami ngapo a pi ta catǝnka.>> ");
INSERT INTO plj_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","<<Ti muntu kan ɗǝl sur yamo, tǝ naar man kup ka. Muntu kup kan atl ni tǝ ɗǝlo kǝ atl ni tǝra, kan tǝ shirǝm ni den bar ju kan kǝ atl ni gwa. Ti muntu kan ɗǝl sur yamo tǝ naar man kup ka. ");
INSERT INTO plj_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Tǝ shirǝm ni den argon tu tǝ kum kan tǝ pal tǝ shin gwa, ama kup na untu murgon kan ra nǝm argon tu tǝ yari gwa da'a. ");
INSERT INTO plj_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ama muntu kup nǝm shirǝmiwo, tǝ tabbate wi den'e Yam mǝn dlǝri den shirǝm gǝs ni. ");
INSERT INTO plj_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Domici muntu kan Yam kar suro, shirǝm kǝ Yam ni tǝ yari, nan Yam bi ti ni Ruhu gǝs baa patǝn gwa. ");
INSERT INTO plj_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Bǝbayi ba ndu Nyayi, ar ni tǝ bi bar kup gip am gǝsi. ");
INSERT INTO plj_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Muntu kup ci cina gip ngǝshtǝn den Nyayiwo tǝra na ge mbatl tu kan baa pa da gwa. Ama muntu kup nge Nyayiwo, tii zam ge mbatl tu kan baa pa da'i da'a, se lo kǝ Yam kan ra den gam gǝs gwa.>> ");
INSERT INTO plj_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Mǝn Parise kum den'e Yesu den pi mbarǝm batisma na zami mir mǝn kulci kar ti man Yohana, ");
INSERT INTO plj_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","kup na Yesu na gam gǝs ni ba pi batismayi da'a, ama mir mǝn kulci kar ti ni den pi. ");
INSERT INTO plj_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Nan Babom Yesu kum muntuwo, tǝ za atl kǝ Yahudaka kan tǝ pal na kaar tǝ te gip atl kǝ Galili. ");
INSERT INTO plj_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ra untuwo ar nǝm tǝ kop gip kǝti atl kǝ Samariya. ");
INSERT INTO plj_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ar ni tǝ mbubar gip bǝn kǝ mǝn Samariya gon kan ba la ti bi'e Sika, kosak na atl tu kan Yakubu bi nya gǝs Isubu gwa. ");
INSERT INTO plj_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Shu mal kǝ Yakubu ra lasi. Nan ar banyi Yesu na ɓomi asǝmo, ar ni tǝ dǝm atl den bi shu mali. Wokociyiwo pǝt to dlom yam wi. ");
INSERT INTO plj_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ar ni nagǝr mǝn Samariya gon ɗir kǝ nge male, ar ni Yesu wul ti'e, <<Bim mal ngap a tla.>> ");
INSERT INTO plj_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Mir mǝn kopi gǝs te gip bǝn kǝ wuri fingali.) ");
INSERT INTO plj_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nagǝr mǝn Samariyayi wul Yesu'e, <<Ki mǝn Yahuda ni, kan amo nagǝr mǝn Samariya ni. Imnu kǝ lirim mal rawu?>> (Domici mǝn Yahuda ba mo gam kǝ ba lasi nǝm na mǝn Samariya da'a.) ");
INSERT INTO plj_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesu nǝmi ti tǝ wule, <<O na kǝ mom ni bi bar kǝ Yami na muntu kan ba lir ki maliwo, na kǝ lir ti tǝ bi'i mal mǝn bi ge mbatl wi.>> ");
INSERT INTO plj_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Nagǝr mbarǝmi wule, <<Mǝn nartǝni, ki ra na bar kǝ dǝli mali da'a kan shu mali dlyam ngap. Ako ni kii zam mal mǝn bi ge mbatl tuwe? ");
INSERT INTO plj_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Rawo kǝ man ni kori gǝmi Yakubu, muntu kan za'i mi shu mali kan tǝ tla mali na gam gǝs, mimir gǝs ma wu tla kup na ga dabba gǝsa?>> ");
INSERT INTO plj_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu nǝmi ti tǝ wule, <<Murgon tu kup tla mal kǝno, tii pa kum guzum mal ra, ");
INSERT INTO plj_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ama murgon tu kup tla mal tu a biwo, ti'i kum guzum mal ra da'a. Mal tu kan aa bi ti baa dǝm ger mal gip ti kan baa pi ta ɗǝltǝn ar ri zami ge mbatl tu kan baa pa da gwa.>> ");
INSERT INTO plj_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Nagǝr mǝri wul ti'e, <<Babomi, bim mal tu ngapi, kan guzum mal baa pi ta kemi gǝn kǝ ɗirtǝn ɗe kǝ nge mal da gwa.>> ");
INSERT INTO plj_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesu wul ti'e, <<Ri la bi bakos gi kǝ ɗir ni nan ti.>> ");
INSERT INTO plj_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ar ni nagǝr mǝri bali ti tǝ wule, <<Ami na kos da'a.>> Yesu wul ti'e, <<Kǝ yari dlat nan kǝ wule ki na kos da gwa. ");
INSERT INTO plj_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ge shirǝm ni kǝ yari. Kǝ pi moni nantam, kan mbarǝm tu ki ra nan ti kǝkǝn ma kos gi ni da'a.>> ");
INSERT INTO plj_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Nagǝr mǝri wule <<Mǝn nartǝni, a shino ki mǝn yari shirǝm kǝ Yam ni. ");
INSERT INTO plj_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ga kori gǝmi bote Yam den tlǝndǝr tu. Ama kǝn mǝn Yahuda wule gip bǝn Urshalima ni ndari dǝ mbarǝm bote Yami.>> ");
INSERT INTO plj_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu wul ti'e, <<Nagǝr mbarǝme, ngǝsh ki demǝni, wokoci ra den ɗirtǝn nan kii bote Bǝba ba'e den tlǝndǝr tu ko su Urshalimaka da'a. ");
INSERT INTO plj_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kǝn mǝn Samariya ba bote ni argon tu kǝ mom dagwa. Ama min mǝn Yahudawo, mǝ bote ni argon tu mǝ mom gwa, domici zami ɗǝltǝno tǝp kar mǝn Yahuda ni ar ɗiri. ");
INSERT INTO plj_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ama wokoci ra den ɗirtǝne, kǝkǝn ma ar ɗir wi nan mǝn pi bota hoyi ba bote Bǝba gip Ruhu na ho mbatl gwa, domici badǝr mbarǝm ju ni Bǝba ba ngen wu bote ti. ");
INSERT INTO plj_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Yamo Ruhu ni, rawo ar nǝm dǝ munju ba bote tiwo, wu bote ti gip ruhu na ho mbatli.>> ");
INSERT INTO plj_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ar ni nagǝr mǝri wule, <<A mom'e Almasihu (kan ba la ti bi'e Kǝristi) den ɗirtǝne. Wokoci tu tǝ mbǝrawo, tii ceti mi gamka den bar kup.>> ");
INSERT INTO plj_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ar ni Yesu yari ti'e, <<Ami mǝn shirǝm nan ki kǝn ni'e ti.>> ");
INSERT INTO plj_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Wi gip shirǝmo se mir mǝn kulci kar ti ba pali, ar ni ar dǝmi wur bar kǝ nǝmi bi na am nan wu zam ti den shirǝm na gǝr mǝtli gwa. Ama ko nǝm gon ngen momi kar nagǝr mǝri da'a tǝ wule, <<Unun kǝ ndu'i?>> Ko dǝ gon wul Yesu'e, <<Unun kem kǝ shirǝm nan tiwu?>> ");
INSERT INTO plj_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ar ni nagǝr mǝri za tat mal gǝs lasi, tǝ pal te gip bǝnka tǝ wul mbarǝm'e, ");
INSERT INTO plj_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","<<Ɗir shin ni mbarǝm tu kan yarim bar ju kup a pi gwa. Ko ti ni'e Almasihuyi?>> ");
INSERT INTO plj_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ar ni mbarǝm ɗǝl ter gip bǝni wu ne gam kar Yesu. ");
INSERT INTO plj_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Gip untuwo ar ni mir mǝn kulci kar ti lir ti wu wule, <<Ba mǝn kulci, ci fingali.>> ");
INSERT INTO plj_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ama Yesu wul wur'e, <<Ami ra na fingal tu kan kǝ mom argon dene da gwa.>> ");
INSERT INTO plj_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ar ni mir mǝn kulci kar tiyi wul ezǝn'e, <<Rawo murgon ɗiri tǝni fingala?>> ");
INSERT INTO plj_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ama Yesu wule, <<Fingal gǝn ni'e a pi argon tu muntu kan karǝm sur ba ndu a pi gwa, kan a pa pa'i mbap gǝsi. ");
INSERT INTO plj_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Kǝ kur wule, <Ar sawi kyar wupse dǝ rǝsh kǝn diya?> A yari in den kǝ ɓul ni ger gin kǝ shin ni bar kǝ gip kǝne! Wu nyo wi den bi rǝshi. ");
INSERT INTO plj_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Kǝkǝn tu ma nye mǝn pi mbap den zami ɓatltǝn gǝs wi, ti den rǝshi bar kǝ kǝn tǝ den ri gip ge mbatl tu kan baa pa da gwa, kǝ dǝ mǝn ngani na mǝn rǝshi kup pi ghol mbatli. ");
INSERT INTO plj_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ra untuwo, shirǝm tu'e, <Gon ngani kan gon ba rǝsho> untu ni ar ra. ");
INSERT INTO plj_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","A kar kǝn kǝ rǝsh argon tu kǝn ni kǝ pi mbapi da gwa. Jen ni pi mbap hoyi, kan kǝno kǝ zam ra gip mbap gǝzǝni.>> ");
INSERT INTO plj_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Na womti kǝ mǝn Samariya kan gip bǝn ta ngǝsh wur den Yesu den argon tu kan nagǝr mǝri yari gwa'e, <<Tǝ yarim bar ju kup a pi gwa.>> ");
INSERT INTO plj_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Nan mǝn Samariyayi ɗir kar tiwo, ar ni wu lir ti den tǝ dǝm nan wur ngapi, kan tǝ dǝm kǝ muri rop. ");
INSERT INTO plj_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Mbarǝm na womti ngǝsh wur den Yesu den shirǝm gǝsi. ");
INSERT INTO plj_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ar ni wu wul nagǝr mǝri'e, <<Ba'e mǝ nǝm ni den argon tu kǝ yari katl gwa da'a ama kǝkǝno mǝ kum wi na gam gǝmi, kan mǝ mom wi den mbarǝm tu ni'e Mǝn ɗǝli mbarǝm kǝ atl kundǝrǝndlip.>> ");
INSERT INTO plj_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Den kaar kǝ muri ropiwo ar ni tǝ za kǝti atl kǝ Samariya tǝ ndara Galili. ");
INSERT INTO plj_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Yesu tare yari wur wi den'e ba shin nartǝn kǝ mǝn yari shirǝm kǝ Yam gip bǝn gǝs da'a.) ");
INSERT INTO plj_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Nan tǝ mbubar gip Galiliwo, mǝn Galiliyi pi ti ɗem na ɗirtǝne. Wu shin bar ju kup tǝ pi gwa gip Urshalima wokoci kǝ Nyel Jikat Bǝdlabǝni, domici wu ma wu ra lasi. ");
INSERT INTO plj_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Kan tǝ pa te gip bǝn kǝ Kana kan ra gip atl kǝ Galili, las tu kan tǝ pali koni mal ka mal inabi gwa. Lasiwo nya bar mbarǝm gon ra den kumi dli gip Kaparnahum. ");
INSERT INTO plj_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Nan mbarǝm tu kum'e Yesu za atl kǝ Yahuda tǝ cwat gip Galiliwo, ar ni tǝ ri lir ti den dǝ tǝ ri warke nya gǝs nye moni, muntu kan ra bi dǝ mǝshtǝn gwa. ");
INSERT INTO plj_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu wul ti'e, <<Kǝn ni kǝ shin bar kǝ halama na bar kǝ dlǝkǝntǝn dawo, kii ngǝsh kǝn den Yam da'a.>> ");
INSERT INTO plj_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Bar mbarǝmi lir Yesu tǝ wule, <<Mǝn nartǝni, sur kapǝn dǝ nya gǝn mǝshka.>> ");
INSERT INTO plj_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesu bali ti tǝ wule, <<Ndara, nya gi baa sa ra na ge mbatli.>> Mbarǝmi nǝm shirǝm kǝ Yesu kan tǝ ndara. ");
INSERT INTO plj_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nan tǝ'i den tǝpo ar ni zher gǝs jen mbor ti na shirǝm den'e nya gǝs pal gingǝlǝn wi. ");
INSERT INTO plj_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Nan tǝ ngen momi wokoci tu kumi dli kǝ nyayi pa'o, ar ni zher gǝsi wul ti'e, <<Ghur bar kǝ gǝlla nǝm kǝ pǝt ni kumi dliyi za ti.>> ");
INSERT INTO plj_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ar ni bas mom'e wokociyi ni Yesu wul ti'e, <<Nya gi ba sa ra na ge mbatli.>> Ar ni mbarǝmi na mbarǝm kǝ shu bom gǝs kup ngǝsh wur den Yesu. ");
INSERT INTO plj_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Muntu ni'e halama bar kǝ nǝmi bi na am kǝ rop kan Yesu pi nan tǝ za gip atl kǝ Yahuda tǝ mbubar gip atl kǝ Galili gwa. ");
INSERT INTO plj_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Den kaariwo, ar ni Yesu to Urshalima kǝ nyel gon kǝ mǝn Yahuda. ");
INSERT INTO plj_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Kosak na Bǝdlabǝn Tǝm kan gip Urshalimawo shu gurku mal gon ra, muntu kan na bi kǝ mǝn Aram ba la ti bi'e Betesda gwa, lasi ra na gandǝli na kop gudǝli nantam. ");
INSERT INTO plj_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Lasi ni ba ne mbarǝm na womti kan kǝti dli gǝzǝn ra hoyi da'a, ga tabi, na kurki, na munju kǝtǝ dli gǝzǝn itǝr tlaka gwa. ");
INSERT INTO plj_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Wu ɓut ni kǝ dǝ gudǝr mali. Domici mǝn kartǝn kǝ Yam ba kur sur gip mali, tǝ gudǝri. Ar ba dǝm'e muntu kup kan zho ti kǝ la'i asǝm gip mali kan gudǝri gwa ba zam warketǝn den argon tu kan ba ghun ti gwa. ");
INSERT INTO plj_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Gon ra lasi kan den kumi dli kǝ sheti ghon hauya nǝm na kutl cet wuzupse gwa. ");
INSERT INTO plj_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Nan Yesu shin ti ɓomo, tǝ mom'e untu ni tǝra den kumi dli kǝ tlyari wokoci, ar ni Yesu ngen momi kar ti tǝ wule, <<Kǝ ndu kǝ pal lauwa?>> ");
INSERT INTO plj_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Mbarǝmi kan ba kum tǝmi kǝ dli gǝs da'ayi nǝmi ti tǝ wule, <<Babomi, ami ra na murgon kan baa nem am a su gip mali gwa da'a wokoci tu gudǝr mali gwa. Ami ni den kǝrce kǝ sitǝn gipiwo, se dǝ gon ɓotlka demǝni.>> ");
INSERT INTO plj_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ar ni Yesu wul ti'e, <<Tlyami! Pǝn bamuri gi kǝ ndara.>> ");
INSERT INTO plj_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ar ri kǝtigon da'a, ar ni mbarǝmi warke, kan tǝ pǝn bamuri gǝs tǝ ndara. Den pǝt Asabar pǝt shukǝtǝn kǝ mǝn Yahuda ni muntu pi. ");
INSERT INTO plj_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ar ni mǝn Yahudayi wul mbarǝmi kan Yesu warke tiyi gwa'e,<<Sekǝno pǝt shukǝtǝn ni, den Kulci kǝ Musawo ar ndari kǝ pǝn bamuri gi da'a.>> ");
INSERT INTO plj_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ama tǝ bali wur tǝ wule, <<Mbarǝm tu kan palim lau gwa ni wulǝm'e, <Pǝn bamuri gi kǝ ndara.> >> ");
INSERT INTO plj_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ar ni wu ngen momi kar ti wu wule, <<Wo ni'e mbarǝm tu kan wul ki'e kǝ pǝn bamuri gi kǝ ndara gwayi?>> ");
INSERT INTO plj_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Mbarǝmi kan warke ti gwa mom wo ni warke tiyi da'a, nan Yesu jilka gip womti mbarǝm kan ra lasi gwa. ");
INSERT INTO plj_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Den kaariwo ar ni Yesu zam ti te gip bom kǝ Yamka kan tǝ wul ti'e, <<Shin ca, kǝ pal lau wi. Za pi warwat pitǝne, bǝse dǝ wani bar gon kan man muntu gwa zam ki.>> ");
INSERT INTO plj_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ar ni mbarǝmi ndara kan tǝ yari kiri kǝ mǝn Yahudayi'e Yesu ni pali ti lau. ");
INSERT INTO plj_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ar dǝm'e, nan Yesu ba pi ni bar ju den pǝt shukutǝno, ar ni mǝn Yahudayi pare sanante ti. ");
INSERT INTO plj_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesu wul wur'e, <<Ban den ta pi mbap ko gigasi har sekǝni, untuni ami den pi pa'e.>> ");
INSERT INTO plj_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Den shirǝm tuwo ar ni mǝn Yahudayi meti ra gip ngeni ri gǝs eka, wu wule ba'e den warke mbarǝm den pǝt shukutǝn ni katl da'a ama den'e tǝ den la'i bi Yam'e bas ni, tǝ pali gam gǝs nǝm na Yam ituwi. ");
INSERT INTO plj_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ar ni Yesu nǝmi wur tǝ wule, <<Ge shirǝm ni a yari in'e Nyayi ba pi argon kǝ gam gǝs da'a, se de argon tu tǝ shin bas den pi gwa, domici kup argon tu Bǝbayi ba piwo ar ni Nyayi ba pi pa'e.>> ");
INSERT INTO plj_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Rawo Bǝbayi ba ndu Nyayi kan tǝ gode ti ni bar ju kup tǝ pi gwa. Aan, kǝ dǝ kǝ nǝm bi na amo, tii gode ti bar ju ma kan naar man munju gwa. ");
INSERT INTO plj_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Domici kandatu Bǝbayi ba tli mǝshi mbarǝm gip gambǝci tǝ bi wur ge mbatl gwa, untu ni Nyayi ba bi ge mbatl muntu kup tǝ ndu'i ti bi gwa. ");
INSERT INTO plj_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Bǝbayi ba tloyi shirǝm murgon da'a, ama tǝ la kup iko kǝ tloyi shirǝm mbarǝm gip am dǝ Nyayi wi, ");
INSERT INTO plj_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","kǝ dǝ mbarǝm kup ɗǝɗa Nyayi kandatu ba ɗǝɗa Bǝbayi gwa. Muntu kup ba ɗǝɗa Nyayi dawo, tǝ ɗǝɗa Bǝbayi kan kar ti sur gwa ituwi. ");
INSERT INTO plj_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","<<Ge shirǝm ni a yari in den'e murgon tu kup ba kum shirǝm gǝn kan tǝ ngǝsh ti den muntu kan karǝm gwa ra na ge mbatl tu kan baa pa da gwa. Eso, baa hukunte ti da'a, domici tǝ jikat mǝshtǝn tǝ te gip ge mbatl wi. ");
INSERT INTO plj_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ge shirǝm ni a yari ine, wokoci gon den ɗirtǝne, kǝkǝn ma ar ɗir wi, nan mǝshi mbarǝm baa kum yar kǝ Nya Yam gwa, munju kum ngap baa zam dǝmi ra na ge mbatli. ");
INSERT INTO plj_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Domici kandatu Bǝbayi na gam gǝs mǝn bi ge mbatl no, untu ni pa tǝ kem dǝ Nyayi dǝm mǝn bi ge mbatli. ");
INSERT INTO plj_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Tǝ pa bi ti bi kǝ tloyi mbarǝm shirǝm domici tǝ Nya Mbarǝm ni. ");
INSERT INTO plj_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","<<Ba dǝ muntu dlǝkǝn kǝn ni da'a, rawo wokoci gon ra den ɗirtǝn nan kup muntu kan ra mǝshi gip gambǝci baa kum yar gǝs ");
INSERT INTO plj_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","kan wu ɗǝl tori, munju kan pi mbuni baro, wii tlyam wu zam ge mbatli, kan munju kan pi wani baro, wii tli dǝ hukunte wuri. ");
INSERT INTO plj_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Aa mani pi argon ami nan gǝn da'a, a tlo ni shirǝm den kandatu Yam wule a pi gwa. Ra untuwo tloyi shirǝm gǝno dlat ni ar ra, nan argon tu a ndu'i gam gǝn ni a pi dagwa, ama kǝ muntu kan karǝm sur gwa ni. ");
INSERT INTO plj_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","<<Ami ni a shirǝm den gam gǝno, argon tu a yari demǝno baa nǝm da'a. ");
INSERT INTO plj_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Gon ra kan ba shirǝm demǝn gwa, kan a mom'e argon tu tǝ yari demǝno untun ar ra. ");
INSERT INTO plj_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","<<Kǝ kar bar den Yohana kano tǝ bi seda den ge shirǝmi. ");
INSERT INTO plj_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ba'e den a nǝm ni argon tu kan mbarǝm ba sede gwa ni da'a. Ama a yari ni den kǝ zam ni ɗǝltǝn ra. ");
INSERT INTO plj_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohana ni'e pitila tu kan pi ta ci kan ba bi cirtǝn gwa, ama kǝ pǝn kǝ kum tǝmi kǝ cirtǝn gǝs kǝ nye wokoci njem katl. ");
INSERT INTO plj_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","<<Ami ra na seda kan man muntu Yohana pi demǝn gwa. Domici mbap ju kan a piwo, Bǝbayi ni bim kǝ dǝ a pi, kan bar ju ami den pi gwa ni ba bi seda den'e Bǝba ni karǝmi. ");
INSERT INTO plj_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Kan Bǝbayi kan karǝm na gam gǝs ni'e seda gǝni. Kǝ taɓe kumi yar gǝs ko kǝ shin kandatu tǝra gwa dak, ");
INSERT INTO plj_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","eso shirǝm gǝs ra gip mbatl gin da'a, domici kǝ ngǝsh kǝn den muntu kan Bǝbayi kar sur gwa da'a. ");
INSERT INTO plj_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Kǝn den ta ngeni gip shirǝm kǝ Yam domici kǝ shin wule gip wuro kii zam ge mbatl tu kan baa pa da gwa. Ama shirǝm kǝ Yam ju ni ba bi seda demǝni. ");
INSERT INTO plj_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ama kup na untu kǝ nge ɗirtǝn karǝm kǝ dǝ kǝ zam ge mbatl ra. ");
INSERT INTO plj_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","<<A nǝm ɗǝɗatǝn kǝ mbarǝm da'a. ");
INSERT INTO plj_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ama a mom kǝne. A mom'e kǝn ra na ndu'i Yam gip mbatl gin da'a. ");
INSERT INTO plj_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","A sur ni gip iko kǝ Ban, ama kǝ nǝmǝn da'a, ama murgon ni ɗir kǝ gam gǝso, kii nǝm ti. ");
INSERT INTO plj_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Imni fa kii ngǝsh kǝn den Yam kǝn ni kǝ ngen ɗǝɗatǝn gip dlom gini, ama kǝ ngen zami ɗǝɗatǝn tu kan ba ɗǝl sur kar Yam muntu kan ti ni nǝm nan gǝs da gwawu? ");
INSERT INTO plj_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","<<Ama ba kǝ pǝn ni'e aa ri in cina dǝ Bǝba da'a. Mǝn ri gin cina ni'e Musa, muntu kan kǝ la mbatl den tii ne in am ra gwa. ");
INSERT INTO plj_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Na kǝ ngǝsh kǝn ni den Musawo, kii ngǝsh kǝn demǝn pa'e, domici tǝ rǝsh demǝn gip tǝlankur gǝsi. ");
INSERT INTO plj_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ama kǝn ni kǝ ngǝsh kǝn den argon tu kan tǝ rǝsh gwa dawo, imni fa kii ngǝsh kǝn den shirǝm gǝn we?>> ");
INSERT INTO plj_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Den kaariwo, ar ni Yesu jikat bar ɓula kǝ Galili, bar ɓula kǝ Tiberiya ituwi, ");
INSERT INTO plj_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","kan mbarǝm na womti ba kop ti kaari, domici wu shin halama kǝ bar kǝ nǝmi bi na am ju kan tǝ pi den mǝn kumi dli gwa. ");
INSERT INTO plj_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Wokociyiwo ar ni Yesu to gǝs won gǝs den tlǝndǝr kan tǝ dǝm atl na mir mǝn kulci kar ti. ");
INSERT INTO plj_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Wokociyiwo ar sawi njem dǝ pi Nyel Jikat Bǝdlabǝn kǝ mǝn Yahuda. ");
INSERT INTO plj_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Nan Yesu tli ger tǝ shin mbarǝm na womti ba te kar tiwo, ar ni tǝ wul Filibus'e, <<Ako ni mii wur bǝredi kan mbarǝm ju baa ci gwawe?>> ");
INSERT INTO plj_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Tǝ ngen ni kumi kǝ bi gǝsi, domici tor mbatl gǝso tǝ mom argon tu kan tǝ ri kǝ pi gwa. ");
INSERT INTO plj_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filibus nǝmi ti tǝ wule, <<Wurpi pi mbap kǝ muri hauya kutl ba ri kǝ kǝmi dǝ wur bǝredi tu kan ko gonge gǝzǝn baa zam njem gwa da'a!>> ");
INSERT INTO plj_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Nǝm gip mir mǝn kulci kar ti mǝn sun'e Andǝrawus, erǝm kǝ Bitǝrus, shirǝm tǝ wul Yesu'e, ");
INSERT INTO plj_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","<<Nya gon kǝn ra na mir bǝredi nantam kan pi na ɗapti bale gwa na mir kos rop, ama unun ar ba pi mbarǝm na womti untuwe?>> ");
INSERT INTO plj_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesu wul mir mǝn kulci kar tiyi'e, <<Wul ni mbarǝm'e wu dǝm atli.>> Lasiwo jir ra hoyi, kan mbarǝm ba dǝm atli, ama moni kan dǝm atl ri mbarǝm zangu nantam. ");
INSERT INTO plj_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ar ni Yesu pǝn bǝrediyi, tǝ goode Yami, kan tǝ kem ba rabe munju kan dǝm atli gwa kan ar ba kǝm wuri. Untu ni es tǝ pi na kosi. ");
INSERT INTO plj_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Nan kup gǝzǝn ci ar kǝm wuro, ar ni tǝ wul mir mǝn kulci kar ti'e, <<Dom ni roɓǝsi ju kan sa gwa. Ba dǝ za argon ar liika da'a.>> ");
INSERT INTO plj_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ar ni mir mǝn kulci kar ti dom roɓǝsi ba laa'i shar kutl cet rop kǝ bǝredi ju kan pi na ɗapti bale nantam ju kan mbarǝm ci wu za gwa. ");
INSERT INTO plj_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Nan mbarǝm shin halama kǝ bar kǝ nǝmi bi na am tu kan Yesu piwo, ar ni wu nǝm wultǝn'e, <<Na ho bi ni, muntu ni'e mǝn yari shirǝm kǝ Yam tu kan baa cwat den atl gwa.>> ");
INSERT INTO plj_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu momka den wu ndu ni'e na ndǝrtǝn kǝ bi gul wu ɗir pali ti gunye, ar ni ti na gam gǝs tǝ dǝlka na kaar tǝ pa to gǝs den tlǝndǝre. ");
INSERT INTO plj_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Nan sit piwo, ar ni mir mǝn kulci kar ti su bi bar ɓula'i, ");
INSERT INTO plj_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","las tu wu to gip kungǝlǝn jikat mal kan wu jikat bar ɓula'i wu ndara Kaparnahum gwa. Wokociyiwo dǝmǝn ndawi, ngapo Yesu mbira kar wur wi da'a. ");
INSERT INTO plj_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ar ni bar itǝr gon ɓe tori kan mal bar ɓula'i ba pare zhe'e pitǝne. ");
INSERT INTO plj_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Nan wu te den gam mal bar kǝ mil myakan ko wupsewo, ar ni wu shin Yesu den tertǝn kar kungǝlǝnyi, tǝ den desi den gam male, kan mbatl ba tari wurka. ");
INSERT INTO plj_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ama tǝ wul wur'e, <<Ami ni, kum ni bǝrti da'a.>> ");
INSERT INTO plj_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Kan ar ba gholi wur mbatl kǝ wu pǝn ti gip kungǝlǝn jikat mali. Ar ri kǝtigon da'a kan wu mbubar den bishidi tu kan wu te gwa. ");
INSERT INTO plj_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Bar tlowo ar ni womti mbarǝmi kan ra den kǝti bishidi bar ɓula'i zamka na momi den'e kungǝlǝn jikat mal nǝm ni katl sa lasi, kan Yesu to gipi na mir mǝn kulci kar ti da'a, ama mir mǝn kulci kar ti ni ndara nan gǝzǝni. ");
INSERT INTO plj_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ar ni kungǝlǝn jikat mal jen kǝ bǝn kǝ Tiberiya ba cwat wu dlǝr kosak na las tu kan mbarǝm ci bǝredi nan Babom Yesu goode Yam gwa. ");
INSERT INTO plj_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Nan womti mbarǝmi momka'e Yesu ko mir mǝn kulci kar ti ra lasi dawo, ar ni wu to gip kungǝlǝn jikat mal wu ndara Kaparnahum kǝ ngeni Yesu. ");
INSERT INTO plj_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Nan wu zam ti den nǝm kǝti bar ɓula'iwo, ar ni wu ngen momi kar ti wu wule, <<Ba mǝn kulci, gigasi ni kǝ mbubar ɗewu?>> ");
INSERT INTO plj_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu nǝmi wur tǝ wule, <<Ge shirǝm ni a yari ine, kǝn ni den ngeni gǝn, ba'e nan kǝ shin halama kǝ bar kǝ nǝmi bi na am ju a pi gwa ni da'a, ama domici kǝ ci kǝ laa'i tu gin na bǝredi gwa ni. ");
INSERT INTO plj_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ba kǝ pini ta ndotǝn kǝ ngeni fingal kan ba liika gwa da'a, ama den fingal mǝn bi ge mbatl tu kan baa pa dagwa, muntu Nya Mbarǝm baa bi in gwa. Den ti ni Bǝba la am kǝ gode'e tǝ yerda nan ti.>> ");
INSERT INTO plj_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Kano wu ngen momi kar ti wu wule, <<Unun ar nǝm mi kǝ pi kǝ dǝ mǝ pi mbap tu kan Yam ba ndu gwawe?>> ");
INSERT INTO plj_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu nǝmi wur tǝ wule, <<Argon tu Yam ba ndu'e kǝ piwo ar ni'e kǝ ngǝsh kǝn ni den muntu kan tǝ kar ti sur gwa.>> ");
INSERT INTO plj_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ar ni wu ngen momi kar ti wu wule, <<Unu halama kǝ bar kǝ nǝmi bi na am ni kii pi mi kǝ dǝ mǝ shin kan mǝ ngǝsh mi den ki rawu? Unu arin kii piwe? ");
INSERT INTO plj_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ga kori gǝmi ci manna gip lǝpe, kandatu ar ra na rǝshi gip shirǝm kǝ Yam gwa'e, <Tǝ bi wur bǝredi kan ɗǝl sur yam gwa.> >> ");
INSERT INTO plj_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesu wul wur'e, <<Na ho bi ni a yari ine, Musa ni'e muntu kan bi in bǝrediyi kan ɗǝl sur yam gwa da'a, ama Ban ni'e muntu kan bi in ho bǝredi kan ɗǝl sur yam gwa. ");
INSERT INTO plj_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Domici bǝredi kǝ Yamo ti ni'e muntu kan ɗǝl sur yam kan ba bi atl kundǝrǝndlip ge mbatl gwa.>> ");
INSERT INTO plj_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ar ni wu wule, <<Mǝn nartǝni, pi mi ta bi bǝredi tu.>> ");
INSERT INTO plj_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ar ni Yesu nǝmi wur tǝ wule, <<Ami ni'e bǝredi mǝn bi ge mbatli. Muntu kup kan ɗir karǝmo, ti'i kum guzum da'a, kan muntu ngǝsh ti demǝno ti'i kum guzum mal da'a. ");
INSERT INTO plj_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ama kandatu a yari in gwa ni, kǝ shimǝn wi ama kup na untu kǝ nge ngǝshtǝn demǝnka. ");
INSERT INTO plj_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Munju kup Bǝba bimo wii ɗir karǝmi, kan muntu kup ɗir karǝmo aa kar tika da'a. ");
INSERT INTO plj_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Domici sur yam ni a ɗǝli, ba'e kǝ dǝ a pi argon tu a ndu gwa ni da'a, ama kǝ dǝ a pi argon tu muntu karǝm ba ndu gwa ni. ");
INSERT INTO plj_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Kan argon tu muntu karǝm ba ndu gwa ni'e den ba a hol ko nǝm gip munju kan tǝ bim gwa da'a, ama kǝ dǝ a tli wur ra na ge mbatl tu kan baa pa da gwa den pǝt kǝ pa'i bar kup. ");
INSERT INTO plj_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Domici argon tu Ban ba ndu gwa itu, den dǝ kup muntu shin Nyayi kan tǝ pi ta ngǝshtǝn den tiwo tǝ zam ge mbatl tu kan baa pa dagwa, ami ngapo aa tli ti den pǝt kǝ pa'i bar kup.>> ");
INSERT INTO plj_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Den untuwo ar ni mǝn Yahudayi nǝm ngwartǝn den ti nan tǝ wule, <<Ami ni'e bǝredi kan ɗǝl sur yam gwa.>> ");
INSERT INTO plj_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Wu wule, <<Yesu ni'e muntu diya, nya Isubu, muntu mǝ mom bas na nas gwa? Imnu kǝkǝno tǝ wul'e, <A dǝl ni sur yam we>?>> ");
INSERT INTO plj_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesu nǝmi wur tǝ wule, <<Za ni ngwartǝn gip dlom gini. ");
INSERT INTO plj_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Murgon baa mani ɗirtǝn karǝm da'a se in Bǝba kan karǝm gwa ni dǝl ti ɗir karǝm gwa, kano aa tli ti ra den pǝt kǝ pa'i bar kup. ");
INSERT INTO plj_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ar ra na rǝshi gip tǝlankur kǝ ga mǝn yari shirǝm kǝ Yam'e, <Yam ni baa kulci kup gǝzǝni.> Murgon tu kup ne kǝm den shirǝm kǝ Bǝba kan tǝ kulci kar ti baa ɗir karǝmi. ");
INSERT INTO plj_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ko nǝm murgon ra kan taɓe shini Bǝbayi gwa da'a, muntu kan ɗǝl sur kar Yam gwa ni katl, ti ni nan gǝs tǝ shin Bǝbayi. ");
INSERT INTO plj_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ge shirǝm ni a yari ine, muntu kup kan ngǝsh ti den Yamo, tǝra na ge mbatl tu kan baa pa da gwa. ");
INSERT INTO plj_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ami ni'e bǝredi mǝn bi ge mbatli. ");
INSERT INTO plj_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ga kori gin ci manna gip lǝpe, ama kup na untu wu mǝshka. ");
INSERT INTO plj_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ama bǝredi tu kan ɗǝl sur yam gwan kǝni, mbarǝm tu kup ciwo tii mǝshka da'a. ");
INSERT INTO plj_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ami ni'e bǝredi mǝn bi ge mbatl kan ɗǝl sur yam gwa. Muntu kup kan ci bǝredi tuwo, tii zam ge mbatl kan baa pa da gwa. Bǝredi tuwo, tlu dli gǝn ni, muntu kan ari kǝ bi kǝ dǝ atl kundǝrǝndlip zam ge mbatl ra gwa.>> ");
INSERT INTO plj_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ar ni mǝn Yahudayi nǝm bali shirǝm gip nge kumi ezǝn gip dlom gǝzǝn na wultǝn'e, <<Imni mbarǝm kǝn baa bi mi dli gǝs mǝ ci wu?>> ");
INSERT INTO plj_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yesu wul wur'e, <<Ge shirǝm ni a yari ine, kǝn ni kǝ ci tlu dli kǝ Nya Mbarǝm kan kǝ pa tla bǝran gǝs dawo, kǝn ra na ge mbatl gip kǝn da'a. ");
INSERT INTO plj_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Muntu kup kan ba ci tlu dli gǝn kan tǝ tla bǝran gǝno, tǝra na ge mbatl tu kan baa pa da gwa, eso aa tli ti den pǝt kǝ pa'i bar kup. ");
INSERT INTO plj_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Domici dli gǝno ho tlu ni kan bǝran gǝno ho bar kǝ tle ni. ");
INSERT INTO plj_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Muntu kup kan ba ci dli gǝn tǝ pa tla bǝran gǝno tǝra gipǝni, eso ami ra gip ti. ");
INSERT INTO plj_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Kandatu Bǝba mǝn ge mbatl karǝm sur kan a pa dǝm ni na ge mbatl domici gǝso, untu ni es muntu kan palim fingal gǝs baa dǝm ra na ge mbatl domici gǝni. ");
INSERT INTO plj_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ami ni'e bǝredi tu kan ɗǝl sur yam gwa. Ga kori gin ci manna kan wu mǝsh ka, ama muntu kan ci bǝredi kǝno tii dǝm ra na ge mbatl kan baa pa da gwa.>> ");
INSERT INTO plj_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Tǝ yari ni muntu nan ti den kulci mbarǝm gip bom domtǝn kǝ mǝn Yahuda kan ra gip bǝn kǝ Kaparnahum gwa. ");
INSERT INTO plj_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Na kumi untuwo, ar ni na womti gip mir mǝn kopi gǝs wule, <<Banyi kulci ni'e muntu, wo ni baa mani nǝmi we?>> ");
INSERT INTO plj_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Nan Yesu mom'e mǝn kopi gǝs den ngwartǝn den kulci tu tǝ piwo, ar ni tǝ wul wur'e, <<Kulci tu dǝmi in nika bar kǝ tli mbatla? ");
INSERT INTO plj_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Im ni baa dǝmi ine kǝn ni kǝ shin Nya Mbarǝm den totǝn las tu tǝ ɗǝl sur gwawu? ");
INSERT INTO plj_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ruhu ni ba bi ge mbatl kan baa pa da gwa, dli baa mani pi argon da'a. Shirǝm ju a yari ino Ruhu ni na ge mbatli. ");
INSERT INTO plj_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Kup na untuwo, jen gip kǝn ngǝsh wur den Yam da'a.>> Domici na pare baro Yesu mom munju kan ngǝsh wur den ti da'a na muntu kan ba ri kǝ bali ti kaar gwa. ");
INSERT INTO plj_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Tǝ ci cina na wultǝn'e, <<Ar ni kem a yari in'e murgon ra kan baa ɗir karǝm gwa da'a se Bǝba ni bii ti mani pi untuyi gwa.>> ");
INSERT INTO plj_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Den kaar kǝ yari shirǝm tuwo ar ni na womti gip mir mǝn kopi gǝs dǝlka na kaari, wu za kopi gǝsi. ");
INSERT INTO plj_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ar ni Yesu ngen momi kar kutl cet ropi, tǝ wule, <<Kǝn ma kǝ ndu ni'e kǝ ndara ya?>> ");
INSERT INTO plj_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Siman Bitǝrus nǝmi ti tǝ wule, <<Babomi, kar wo ni mi riwe? Ki ni'e mǝn shirǝm bi ge mbatl tu kan baa pa da gwa. ");
INSERT INTO plj_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Mǝ ngǝsh mi den ki wi, mǝ pa mom wi'e ki ni'e Dlǝranyi kǝ Yami.>> ");
INSERT INTO plj_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Kan Yesu ba bali wur tǝ wule, <<Ami ni a zǝzar kǝn kutl cet ropi diya? Kup na untu nǝm gip kǝno shetan ni!>> ");
INSERT INTO plj_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(Yahuda nya Siman Iskariyoti ni tǝ shirǝm den ti, muntu ba ri kǝ bi gǝska gwa, kup na tǝra nǝm gip Kutl cet ropi.) ");
INSERT INTO plj_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Den kaar kǝ muntuwo, ar ni Yesu kop gip las kǝ Galili, ama tǝ ndu tǝ kop gip las kǝ mǝn Yahuda da'a, domici mǝn Yahuda kǝ lasi den ngeni wu ri ti eka. ");
INSERT INTO plj_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Nan Nyel kǝ dǝmi gip mir bukka kǝ mǝn Yahuda mbi kosakwo, ");
INSERT INTO plj_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ar ni mir erǝm kǝ Yesu wul ti'e, <<Ar mbun kǝ za ɗe kǝ te gip atl kǝ Yahuda, kǝ dǝ mir mǝn kulci kar ki shin bar kǝ nǝmi bi na am ju kǝ pi gwa. ");
INSERT INTO plj_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Murgon tu kup ba ndu dǝ mbarǝm mom ti tǝra hoyiwo, tǝ pi bar muri da'a. Tun nan kǝ pi bar juwo, ar mbun kǝ gode mbarǝm bar ju kǝ pi gwa dǝ mom ki ra.>> ");
INSERT INTO plj_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Rawo, ko mir mǝn gǝpi gǝs ma wu ngǝsh wur den ti wi da'a. ");
INSERT INTO plj_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ar ni Yesu wul wur'e,<<Wokoci gǝn kǝ pi untu pi wi da'a, ama kar kǝno ko gonge wokoci ndari in kǝ pi untu. ");
INSERT INTO plj_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Kǝno, mbarǝm kǝ atl baa nge in da'a, ama ami ni wu nge domici a yari wur den wani bar ni wu pi. ");
INSERT INTO plj_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kǝno rǝni kǝ ba Nyeli. Amo, aa ri wi da'a, domici wokoci gǝn piwi da'a.>> ");
INSERT INTO plj_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Nan tǝ pa'i yari shirǝm tuwo ar ni tǝ sa gǝs gip las kǝ Galili. ");
INSERT INTO plj_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Rawo, den kaar kǝ ndaratǝn kǝ mir mǝn gǝpi gǝs kǝ ba Nyeliwo, ar ni ti ma tǝ ndara, ama muri ni tǝ ndara, ba'e den ger kǝ mbarǝm da'a. ");
INSERT INTO plj_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Kǝ ba Nyeliwo kiri kǝ mǝn Yahuda den ne ger gǝs na ngeni momi kar mbarǝm na wultǝn'e, <<Ako ni mbarǝm tu ra?>> ");
INSERT INTO plj_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Gip womti mbarǝmiwo ar ni shirǝm den ti pi ta tlitǝn gip dlom gǝzǝn muri. Jen ba wule, <<Ti ho mbarǝm ni.>> Jen ngapo wu wule, <<O'o, tǝ jili ni mbarǝm ka.>> ");
INSERT INTO plj_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ama murgon ra kan mani shirǝm den ti kandatu womti mbarǝmi baa kum gwa da'a den bi bǝrti kǝ kiri kǝ mǝn Yahudayi. ");
INSERT INTO plj_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Nan te dlom gip muri kǝ pi Nyeliwo, ar ni Yesu te gip dǝbom bom kǝ Yam tǝ nǝm kulci mbarǝme. ");
INSERT INTO plj_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ar dlǝkǝn mǝn Yahudayi kan wu ngen momi wu wule, <<Imni mbarǝm kǝn mom bar naar untuwu? Ar tu ngap tǝ ri kǝ ba kulci da'a.>> ");
INSERT INTO plj_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesu nǝmi wur tǝ wule, <<Kulci gǝno kǝ gam gǝn ni da'a. Ar ɗǝl ni kar muntu kan karǝm sur gwa. ");
INSERT INTO plj_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Murgon tu kup pǝn tii pi argon tu Yam ba ndu'o, tii mani momi'e kulci gǝn ɗǝl ni sur kar Yami, ba'e kǝ gam gǝn ni da'a. ");
INSERT INTO plj_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Muntu kan ba kulci ni mbarǝm bar kǝ gam gǝso, tǝ pi ni kǝ dǝ tǝ zami gam gǝs nartǝn kar mbarǝme, ama muntu kan ba ndu ni tǝ ɗǝɗa muntu kan kar tiwo, tǝ mbarǝm mǝn dlǝri den shirǝm gǝs ni, kan lar ra gip ti da'a. ");
INSERT INTO plj_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Musa ni bi in kulciyi diya? Kup na untu ko nǝm gin gon ra kan ba kop kulciyi gwa da'a. Unun kem kǝ ndu ri gǝn eka rawu?>> ");
INSERT INTO plj_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ar ni womti mbarǝmi wul ti'e, <<Ki mǝn itǝr ni, woni den ndu'i ri gi ekayi?>> ");
INSERT INTO plj_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu wul wur'e, <<Bar kǝ nǝmi bi na am nǝm ni katl a pi, kan ar ba dǝmi inka bar kǝ dlǝkǝntǝne. ");
INSERT INTO plj_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ama domici Musa yari in'e kǝ pini sǝrtǝne, kup na ti ni tǝ la gǝsi da'a, ga kori gin ni, kup na untu kǝ sǝr nya den pǝt shukutǝni. ");
INSERT INTO plj_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ar dǝm'e kǝ mani sǝri nya den pǝt shukutǝn den bi kopi kulci kǝ Musa. To, ununu ba kem kǝn kǝ pi lo namǝn den warke dli kǝ mbarǝm kup den pǝt shukutǝn we? ");
INSERT INTO plj_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Za ni tloyi shirǝm den kandatu kǝ shin bar ra gwa, zam kǝ tlo ni shirǝm den argon tu kan kor ni ar ra gwa.>> ");
INSERT INTO plj_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ar ni mbarǝm kǝ Urshalima jen nǝm ngeni momi wu wule, <<Mbarǝm tu ni wu ndu ri gǝs eka diya? ");
INSERT INTO plj_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Tin kǝn den shirǝm gip mbarǝme, kan ko nǝm wu wul ti'e argon da'a. Ko mǝn bǝni nǝm ni wi den ti ni'e Almasihuyi? ");
INSERT INTO plj_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ama mǝ mom las tu kan mbarǝm tu ɗǝl ɗir gwa, ama wokoci tu ho Almasihu baa ɗiro murgon ra kan baa mani momi las tu kan tii ɗǝl ɗir gwa da'a.>> ");
INSERT INTO plj_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Nan Yesu gip kulci mbarǝm gip dǝbom bom kǝ Yamo, ar ni tǝ tli yar yam tǝ wule, <<Aan, kǝ momǝni, kǝ pal kǝ mom las tu a ɗǝl ɗir gwa. Ba'e na iko kǝ gam gǝn ni a sur da'a, ama muntu kan karǝmo mǝn dlǝri den shirǝm gǝs ni, ama kǝno kǝ mom ti da'a ");
INSERT INTO plj_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ama amo a mom ti domici kar ti ni a ɗǝl suri, kan ti ni tǝ karǝmi.>> ");
INSERT INTO plj_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Den muntuwo ar ni wu ndu wu nǝm ti, ama murgon ra kan mani ne am den ti gwa da'a, nan wokoci gǝs piwi dagwa. ");
INSERT INTO plj_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Kup na untu, na womti gip womti mbarǝmi ngǝsh wur den Yesu. Wu wule, <<Almasihu ni cwato ti pini halama bar kǝ nǝmi bi na am ar man kǝ mbarǝm kǝna?>> ");
INSERT INTO plj_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Mǝn Pariseyi kum mbarǝm den shirǝm shep shep den Yesu gip dlom gǝzǝno, ar ni kiri mǝn keri bar ju ɗiri Yam na mǝn Pariseyi kar mǝn ɓuti bom kǝ Yam den wu ri nǝm ti ɗiri. ");
INSERT INTO plj_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesu wul wur'e, <<Wokoci kǝ dǝmi gǝn nan kǝn sawi njem, kan a nde ndaratǝn kar muntu kan karǝm gwa. ");
INSERT INTO plj_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Kii ngenǝm, ama kii zamǝn da'a, kan las tu aa riyiwo, kii mani ritǝn da'a.>> ");
INSERT INTO plj_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ar ni mǝn Yahudayi wul ezǝn'e, <<A ko ni mbarǝm kǝn ba ndu ritǝn kan mii mani zami gǝs da gwawu? Tii ndara ni kar mbarǝm gǝmi kan gǝzǝnka gip mǝn Hellas tǝ kulci wur na? ");
INSERT INTO plj_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ununu mbarǝm tu ba pi nupi nan tǝ wule, <Kii ngenǝmi, ama kii mani zami gǝn da'a?> Kan unun tǝ pa yari na wultǝn'e, <Las tu aa riyiwo, kii mani ritǝn da'ayi?> >> ");
INSERT INTO plj_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Den pǝt kǝ pa'i Nyeliwo, muntu kan ar ni'e bar pǝt kǝ domtǝni gwa, ar ni Yesu tlyam dlor kan tǝ tli yar yam tǝ wule, <<Murgon tu kup ba kum guzum malo, naa tǝ ɗir karǝm tǝ tla. ");
INSERT INTO plj_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Murgon tu kup ngǝsh ti demǝno, mir ɓula mal mǝn bi ge mbatl baa ɗǝl tor gip mbatl gǝzǝni, kandatu Shirǝm kǝ Yam yari gwa.>> ");
INSERT INTO plj_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ama Ruhu kǝ Yam ni tǝ den shirǝm dene, muntu kan munju ngǝsh wur den ti ba ri kǝ nǝmi gwa, domici wokociwo tare pi Ruhu kǝ Yam wi da'a nan Yesu to gip ɗǝɗatǝn gǝs wi da gwa. ");
INSERT INTO plj_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Na kumi muntuwo ar ni jen gip mbarǝmi wule, <<Na ho bi, mbarǝm tuwo mǝn yari shirǝm kǝ Yam tu kan ba ɗir gwa ni.>> ");
INSERT INTO plj_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Jen wule, <<Ti ni'e Almasihu.>> Ar ni jen ngapo wu nge wu wule, <<Imnu Almasihu baa cwat tor Galili we? ");
INSERT INTO plj_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Shirǝm kǝ Yam yari ni'e Almasihu baa ɗǝl ni gip gǝsgal kǝ Dauda diya? Kan gip Baitalami bǝn tu kan gǝr Dauda gwa ni tii ɗir diya?>> ");
INSERT INTO plj_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Rawo, ar ni gam kǝ mbarǝm tatlka den Yesu, jen gip womti mbarǝmi kop kaar kǝ shirǝm kǝ Yesu, jen ngapo wu pi mǝgǝn shirǝm den ti. ");
INSERT INTO plj_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Jen ndu wu nǝm ti, ama murgon ra kan mani ne am den ti gwa da'a. ");
INSERT INTO plj_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Kǝ pa'i bisiwo, nan ga mǝn ɓuti bom kǝ Yam pal rin kawo, ar ni ga kiri mǝn keri bar ju ɗiri Yam na mǝn Pariseyi wul wur'e, <<Unun kem kǝ ɗir nan ti dawu?>> ");
INSERT INTO plj_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ar ni ga mǝn ɓuti bom kǝ Yami bali wur wu wule, <<Murgon ra kan taɓe shirǝm kandatu mbarǝm tu shirǝm gwa da'a.>> ");
INSERT INTO plj_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ar ni men Pariseyi wule, <<Anyi! Kǝn ma tǝ jili in kawa? ");
INSERT INTO plj_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Kǝ shin ni ko nǝm gip kǝ cina ko gip mǝn Parise kan ngǝsh den ti gwaya? ");
INSERT INTO plj_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ama me gam kǝ mǝn tli mbarǝm mbatl tu kan mom argon den kulci kǝ Musa da'awo, mbarǝm ni kan bi nǝm wur wi gwa.>> ");
INSERT INTO plj_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ama Nikodimu, muntu kan far ri kar Yesu gwa ra nǝm gip wuri, ar ni tǝ wul wur'e, ");
INSERT INTO plj_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","<<Kulci gǝmi wul ni'e dǝ hukunte murgon bat na kumi kǝ bi kǝ mbarǝmi kakani zam dǝ mbarǝm mom argon tu tǝ pi gwa da'aya?>> ");
INSERT INTO plj_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ar ni wu bali ti wu wule, <<Ki ma mǝn Galili na? Zhit gip shirǝm kǝ Yam kǝ shini, kii zam'e mǝn yari shirǝm kǝ Yam gon baa tli gip Galili da'a.>> ");
INSERT INTO plj_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Kano ko gonge gǝzǝn ba ndara bomi. ");
INSERT INTO plj_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ar ni Yesu to gǝs den Tlǝndǝr mǝn kin Zaitun. ");
INSERT INTO plj_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Bar tlo kǝ bi cigǝniwo, kan tǝ pa te gip dǝbom bom kǝ Yami, ar ni mbarǝm kup dom wur kar ti, kan tǝ dǝm atl tǝ kulci wuri. ");
INSERT INTO plj_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ar ni mǝn kulci mbarǝm den kulci kǝ Musa na mǝn Parise ɗiri ti nagǝr gon kan nǝm ti den muri na moni kaari gwa. Wu kem tǝ dlǝr cina dǝ mbarǝme ");
INSERT INTO plj_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","kan wu wul Yesu'e, <<Ba mǝn kulci, nagǝr kǝno nǝm tǝni den muri na moni kaari. ");
INSERT INTO plj_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Gip kulci kǝ Musawo tǝ bi mi bi den mǝ ri badǝr mbarǝm ju eka tǝp kǝ ba la'i gǝzǝn na tate. Kiwo unun kǝ wul rawu?>> ");
INSERT INTO plj_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Wu ngen ni kumi kǝ bi gǝs kǝ dǝ wu zam wu nǝm ti gip shirǝm wu ri ti cina ra. Ama Yesu ngus atl kan tǝ pi ta rǝshi argon den atl na yasa gǝsi. ");
INSERT INTO plj_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Nan wu ci cina na ngeni momi kar tiwo, ar ni tǝ tlyam dlor kan tǝ wul wur'e, <<Naa dǝ muntu kan taɓe pi warwat pitǝn da'a gip kǝn pare la'i gǝs na tate.>> ");
INSERT INTO plj_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Kan Yesu ba pa ngus atl es tǝ ci cina na rǝshi argon den atli. ");
INSERT INTO plj_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Nan wu kum untuwo ar ni wu nǝm ndaratǝni, argon tu pǝn den bari gǝzǝn ba ri den heli gip wuri, ba za Yesu nan gǝs na nagǝr mǝri dlor cina da ti. ");
INSERT INTO plj_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ar ni Yesu tlyam dlor kan tǝ wul nagǝr mǝri'e, <<Nagǝr mbarǝme, ako ni mǝn ɗiri gi cinayi rawe? Murgon ra kan hukunte'i gwa diya?>> ");
INSERT INTO plj_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Kan nagǝr mbarǝmi ba nǝmi tǝ wule, <<Mǝn nartǝni, ko nǝm.>> Ar ni Yesu wul ti'e, <<Ami ma aa hukunte'i da'a, kǝkǝno ndara ama ba kǝ pa pi warwat pitǝn da'a.>> ");
INSERT INTO plj_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Nan Yesu pa shirǝm na mbarǝmo, ar ni tǝ wule, <<Ami ni'e cirtǝn kǝ mbarǝm gip atl kundǝrǝndlip. Murgon tu kup kopǝno tii dǝm gip dǝmǝn da'a ama tii zam cirtǝn kǝ ge mbatli.>> ");
INSERT INTO plj_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Mǝn Pariseyi ba wul ti'e, <<Ki den bi seda den gam gi, seda giwo untun ar ra da'a.>> ");
INSERT INTO plj_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu nǝmi wur tǝ wule, <<Ko ami ni a bi seda den gam gǝno, seda gǝno kor ni ar ra, domici a mom las tu kan a ɗǝl sur na las tu kan a ri gwa. Ama kǝno, kǝ mom las tu kan a ɗǝl ɗiri ko las tu kan a ri gwa da'a. ");
INSERT INTO plj_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Kǝ tlo ni shirǝm den argon tu mbarǝm ba shin gwa, ama amo aa tloyi murgon shirǝm da'a. ");
INSERT INTO plj_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ama ami ni aa tlo shirǝm den baro, tloyi shirǝm gǝno kor ni ar ra, domici ami nangǝn ni da'a. Ban kan karǝm sur gwa ra namǝni. ");
INSERT INTO plj_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ar ra na rǝshi gip kulci gin'e, mbarǝm rop ni bi seda den bar nǝmo, seda gǝzǝno ar ndǝr kǝ dǝ nǝmi. ");
INSERT INTO plj_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ar tu a bi seda den gam gǝn wi, Ban muntu kan karǝm sur gwa ni'e mǝn bi seda gǝn kǝ ropi.>> ");
INSERT INTO plj_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ar ni wu ngen momi kar ti wu wule, <<Ako ni beyi ra?>> Kan Yesu ba bali wur tǝ wule, <<Kǝ momǝn ko Ban da'a. O kǝ momǝn faro, kii mom Ban pa'e.>> ");
INSERT INTO plj_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Tǝ yari ni shirǝm ju nan tǝ den kulci mbarǝm gip dǝbom bom kǝ Yam kosak na las tu ba ne wurpi kan ba bi gwa. Ama murgon mani nǝmi gǝs da'a nan wokoci gǝs piwu dagwa. ");
INSERT INTO plj_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu pa wul wur ra'e, <<A ri kǝ ndaratǝni, kii ngenǝmi, kii mǝsh gip warwat pitǝn gi ni. Las tu a riwo, kii mani ritǝn da'a.>> ");
INSERT INTO plj_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Muntu kem mǝn Yahudayi ngen momi wu wule, <<Tǝ rǝni kǝ ri gam gǝs ekaya? Nan tǝ wule, <Las tu a riwo, kii mani ritǝn da'a gwa>?>> ");
INSERT INTO plj_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ama Yesu ci cina na shirǝm tǝ wule, <<Kǝno, kǝ atl ni, ami ngapo a ɗǝl ni sur yami. Kǝno kǝ den kaar atl kǝn ni, ami ngapo kǝ den kaar atl kǝn ni da'a. ");
INSERT INTO plj_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ar ni kem a yari in den kii mǝsh gip warwat pitǝn gi ni, kǝn ni kǝ ngǝsh kǝn den ami'e muntu kan a yari in'e Amiyi ni'e ti dawo, na ho bi, kii mǝsh gip warwat pitǝn gi ni.>> ");
INSERT INTO plj_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ar ni mǝn Yahudayi ngen momi kar ti wu wule, <<Ki ni'e wowe?>> Yesu bali wur tǝ wule, <<Amiyi ni'e muntu kan a pare yari in gwa. ");
INSERT INTO plj_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ami ra na bar na womti kǝ yari kǝ hukunte gini. Ama ti muntu kan karǝmo ge shirǝm ni tǝ yari, ami ngapo argon tu a kum kar ti gwa ni a yari mbarǝme.>> ");
INSERT INTO plj_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Wu mani momi'e den Bas ni tǝ shirǝm da'a. ");
INSERT INTO plj_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ar ni Yesu wule, <<Wokoci tu kǝ tli Nya Mbarǝm yamo, ar ni kii mom den Ami ni'e ti, kan kii pa mom es'e a pi argon kǝ gam gǝn da'a, ama a yari ni argon tu Ban kulcim gwa katl. ");
INSERT INTO plj_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Muntu kan karǝm gwa ra namǝni. Tǝ za'ǝm nangǝn da'a, domici ko gigasi a pi ni argon tu kan tǝ ndu gwa.>> ");
INSERT INTO plj_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Nan tǝ den yari shirǝm juwo ar ni mbarǝm na womti ngǝsh wur den ti. ");
INSERT INTO plj_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesu wul mǝn Yahuda ju kan ngǝsh wur den ti gwa'e, <<Kǝn ni kǝ dǝm dlakǝt na kulci gǝno, na ho bi, kǝn ni'e ho mǝn kopi gǝni. ");
INSERT INTO plj_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ar ni kii mom ge shirǝmi, ge shirǝmi ngap baa ɗiri in zami gam gi ni.>> ");
INSERT INTO plj_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Wu nǝmi ti wu wule, <<Mǝn gǝsgal kǝ Ibǝrahim ni kan mǝ taɓe dǝmi zher kǝ murgon da'a. Imni ki wule mii zam gam gǝmi rawu?>> ");
INSERT INTO plj_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu bali wur tǝ wule, <<Na ho bi ni a yari ine, murgon tu kup ba pi warwat pitǝno, zher kǝ warwat pitǝn ni. ");
INSERT INTO plj_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Zher baa pi ta dǝmi gip bom ko gigasi da'a, ama nyawo, kǝ bomi ni ko gigasi. ");
INSERT INTO plj_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ra untuwo, Nyayi ni bi in zami gam gino, na ho bi, ar dǝm'e kǝ zam gam gin ituwi. ");
INSERT INTO plj_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","A mom'e kǝn gǝsgal kǝ Ibǝrahim ni. Kup na untu kǝn den ndu'i kǝ rim eka, domici kǝ nge nǝmi kulci gǝn ka. ");
INSERT INTO plj_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","A yari in ni argon tu a shin kar Ban gwa, kǝn ma argon tu kǝ kum kar ba gin gwa ni kǝ pi.>> ");
INSERT INTO plj_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Wu nǝmi ti wu wule, <<Ba gǝmi ni'e Ibǝrahim.>> Yesu nǝmi wur tǝ wule, <<Kǝn mimir kǝ Ibǝrahim ni fawo, na kii pi bar ju Ibǝrahim pi gwa. ");
INSERT INTO plj_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ami mbarǝm ni kan yari in ge shirǝm tu a kum kar Yam gwa, ama kǝn den ndu'i'e kǝ rim eka. Ibǝrahim pi bar unju da'a. ");
INSERT INTO plj_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ra untuwo kǝn ni den pi bar ju kan ba gin ba pi gwa.>> Ar ni wu bali ti wu wule, <<Mǝn gǝri kǝ kaari ni da'a, Ba gǝmi nǝm ni, ti ni'e Yam na gam gǝsi.>> ");
INSERT INTO plj_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Kan Yesu ba wul wur'e, <<Dǝ wule Yam ni'e Ba gino, na kǝ ndu'ǝm wi, domici kar Yam ni a ɗǝl suri, kan kǝkǝno amin kǝn ɗe. Ami ni ra ɗe kǝ gam gǝn da'a, ama Yam ni karǝmi. ");
INSERT INTO plj_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Unun kem kǝ mom argon tu a yari gwa da'awe? Domici kǝ nge kumi kulci gǝn ka ni. ");
INSERT INTO plj_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Kǝn kǝ ba gin Shetan gun dun itǝr ni, kan kǝn den ndu'i kǝ pi argon tu ba gin ba ndu gwa. Tǝ mǝn ri mbarǝm eka ni na ne gǝs kǝ pi bari. Tǝ mani nǝmi ge shirǝm da'a, domici ge shirǝm ra gip ti da'a. Wokoci tu kup tǝ cen laro, gǝs lǝka gǝs ni tǝ yari, domici ti mǝn ceni lar ni, basi lar esi. ");
INSERT INTO plj_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ama nan ge shirǝm ni a yariwo, ar ni kǝ nge ngǝshtǝn demǝnka. ");
INSERT INTO plj_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Gon ra gip kǝn kan baa bi seda den'e a taɓe pi warwat pitǝna? Ge shirǝm ni pa a yariwo, unun kem kǝ nge ngǝshtǝn demǝn kawu? ");
INSERT INTO plj_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Muntu kup kan kǝ Yamno tǝ kum argon tu kan Yam ba yari gwa. Ama kǝno, kǝ kum argon tu Yam ba yari gwa da'a nan kǝn kǝ Yam ni da gwa.>> ");
INSERT INTO plj_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Mǝn Yahudayi nǝmi ti wu wule, <<Dlat ni mǝ yari da'aya den ki ba mǝn Samariya ni, kan ki ra na itǝr gwa.>> ");
INSERT INTO plj_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu wul wur'e, <<Ami ra na itǝr gipǝn da'a, ama a bi ni nartǝn Ban, kǝn ngapo, kǝ bim nartǝn da'a. ");
INSERT INTO plj_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","A ngeni ni gam gǝn ɗǝɗatǝn da'a, ama gon ra kan ba ngenim gwa, kan tǝ ni'e mǝn tloyi mbarǝm shirǝmi. ");
INSERT INTO plj_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Na ho bi ni a yari in den'e kup muntu kan ba kop shirǝm gǝno, ko njem tii mǝshka da'a.>> ");
INSERT INTO plj_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Den muntuwo ar ni mǝn Yahudayi wule, <<Kǝkǝno mǝ mom wi den ki mǝn itǝr ni! Ibǝrahim mǝshka, untu ni es ga mǝn yari shirǝm kǝ Yami, ama kǝ wule muntu kop kulci giwo, ko njem tii mǝshka da'a. ");
INSERT INTO plj_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Gip shini giwo kǝ man ni ba gǝmi Ibǝrahima? Tǝ mǝshka, untu ni ma ga mǝn yari shirǝm kǝ Yami. Kǝ kum wule ki woni we?>> ");
INSERT INTO plj_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu bali wur tǝ wule, <<Ami ni a ɗǝɗa gam gǝno, ɗǝɗa gam gǝniwo argon ni da'a. Ban ni, muntu kan kǝ wule Yam gin ni gwa, ti ni'e mǝn ɗǝɗa gǝni. ");
INSERT INTO plj_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Kup na kǝ mom ti da'a, ama amo, a mom ti. Ami ni a wule a mom ti dawo, a dǝm mǝn ceni lar wi wule kǝne, ama a mom ti, kan ti ni a kop shirǝm gǝsi. ");
INSERT INTO plj_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ba gin Ibǝrahim pi ghol mbatl kǝ tǝ zam shini zhan gǝni, tǝ shini kan tǝ pi ghol mbatli.>> ");
INSERT INTO plj_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Mǝn Yahudayi wul ti'e, <<Kǝ ri sheti ghon hauya rop na kutl na gǝriwi da'a, ama kǝ wule kǝ shin Ibǝrahima?>> ");
INSERT INTO plj_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu nǝmi wur tǝ wule, <<Na ho bi ni a yari ine, kapǝn dǝ gǝr Ibǝrahimo Ami ra.>> ");
INSERT INTO plj_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Den muntuwo ar ni wu yem tat kǝ la'i gǝsi. Ama Yesu ghun gǝsi, kan tǝ ɗǝl tǝ za gip bom kǝ Yamika. ");
INSERT INTO plj_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Nan Yesu ci cinawo, ar ni tǝ shin mbarǝm gon tabi tun gǝri gǝsi. ");
INSERT INTO plj_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Mir mǝn kulci kar ti ngen momi kar ti wu wule, <<Ba mǝn kulci, warwat pitǝn kǝ wo ni kem kan ba gǝr mbarǝm tu tabiyi, gwas na, ko kǝ ga mǝn gǝri gǝs ni?>> ");
INSERT INTO plj_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ar ni Yesu wule, <<Mbarǝm tu ko mǝn gǝri gǝs ni pi warwat pitǝn da'a, ama muntu pini kǝ dǝ mbarǝm shin mbap ju kan Yam ni nangǝs ba pi gwa den ti. ");
INSERT INTO plj_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ar nǝm mi te yarka mǝ ci cina na pi mbap kǝ muntu kan karǝm gwa kǝ pǝte. Gas den ɗirtǝne, nan mbarǝm baa mani pi mbap da gwa. ");
INSERT INTO plj_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ami ni ra den kaar atlo, ami ni'e cirtǝn kǝ atl kundǝrǝndlip.>> ");
INSERT INTO plj_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Nan ti yari untuwo, ar ni tǝ bǝse mo'ǝm den atli, tǝ liiti, kan tǝ zaapi den ger kǝ mbarǝmi. ");
INSERT INTO plj_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ar ni tǝ wul ti'e, <<Mbǝri, ri ho gerka gip mal kǝ Silowam>> (Kartǝn ituwi). Ar ni mbarǝmi ndara kan tǝ ho gerka, kan tǝ pal na mani shini bar gǝsi. ");
INSERT INTO plj_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ga berǝm dǝmi gǝs na munju ba kur shin ti den liri bar ngen momi wu wule, <<Muntu ni'e mbarǝm tu kan ba kur dǝm kǝ liri bar gwa diya?>> ");
INSERT INTO plj_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Jen wule <<Ti ni.>> Nami ngapo wu wule, <<O'o, tǝ pini kama nan ti.>> Ama mbarǝmi na gam gǝs wule, <<Ami ni'e mbarǝmi.>> ");
INSERT INTO plj_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Wu ngen momi na wultǝn'e, <<Imni pi kan ger gi ba ɓul rawu?>> ");
INSERT INTO plj_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ar ni tǝ bali wur tǝ wule, <<Mbarǝm tu ba la ti bi Yesu gwa ni liiti gurku na mo'ǝm gǝs kan tǝ zaapi den ger gǝni. Tǝ wulǝm'e a su Silowam a ho gerka. Ar ni a ndara kan a ho gerka, kan a nǝm shini bari.>> ");
INSERT INTO plj_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Wu ngen momi kar ti wu wule, <<Ako ni mbarǝmi ra?>> Ar ni tǝ wul wur'e, <<A mom da'a.>> ");
INSERT INTO plj_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ar ni ga mbarǝmi ndara na mbarǝmi kan far tabi ni gwa kar mǝn Parise. ");
INSERT INTO plj_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Den pǝt Asabar, pǝt shukutǝn ni Yesu liiti gurku kan tǝ ɓul ger kǝ mbarǝmi. ");
INSERT INTO plj_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ar ni mǝn Pariseyi pa ngen momi kar ti den kandatu pi kan mani shini bar gǝs ba pal gwa. Ar ni tǝ bali wur'e, <<Tǝ zaapi ni gurku den ger gǝni, kan a ho gerka, ar tu kǝkǝno a shin bar wi.>> ");
INSERT INTO plj_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Jen gip mǝn Pariseyi wule, <<Mbarǝm tu kan pi muntuwo kar Yam ni tǝ ɗǝl da'a, domici tǝ nge kop doka kǝ ba dǝ pi mbap den pǝt shukutǝn da'a.>> Ama nami wule, <<Imni mǝn warwat pitǝn baa mani pi halama bar kǝ nǝmi bi na am untuwu?>> Ar ni wu zam tatli gam den shirǝmiyi. ");
INSERT INTO plj_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ar ni wu pa bal wur kar muntu far tabiyi gwa wu ngen momi kar ti wu wule, <<Unun kii yari den mbarǝmi? Ki ni tǝ ɓul ger gi.>> Mbarǝmi bali wur tǝ wule, <<Ti mǝn yari shirǝm kǝ Yam ni.>> ");
INSERT INTO plj_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Kup na untu mǝn Yahudayi nǝm den'e gǝr tǝni tabiyi kan kǝkǝno tǝ zam shini bar da'a, ar ni wu kar bar den ga mǝn gǝri kǝ mbarǝmi. ");
INSERT INTO plj_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Kan wu ngen momi kar wur wu wule, <<Muntuwo nya gin na? Kǝ wule gǝr tǝni tabiyi? Imni pi kǝkǝno tǝ mani shini bar rawu?>> ");
INSERT INTO plj_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ar ni ga mǝn gǝri gǝs nǝmi wur wu wule, <<Mǝ mom'e nya gǝmi ni, kan mǝ mom'e mǝ gǝr tǝni tabiyi. ");
INSERT INTO plj_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ama imni pi kǝkǝno tǝ shin bari ko muntu ɓul ger gǝso, mǝ mom da'a. Ngen ni momi kar ti. Tǝ kǝm las kǝ mbarǝm wi, tii yari in na gam gǝsi.>> ");
INSERT INTO plj_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ga mǝn gǝri gǝs yari ni untu den kumi bǝrti kǝ mǝn Yahuda, domici mǝn Yahudayi tare ne bi dene wi den'e kup murgon tu kan wule tǝ ngǝsh ti den Yesu ni'e Almasihuwo baa ɗǝli tǝka gip bom domtǝn kǝ mǝn Yahuda. ");
INSERT INTO plj_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ar ni kem ga mǝn gǝri gǝs wule, <<Tǝ kǝm las kǝ mbarǝm wi, ngen ni momi kar ti.>> ");
INSERT INTO plj_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ar ni mǝn Pariseyi pa la bi mbarǝmi kan far tabi gwa, wu ngen momi kar ti wu wule, <<Yari mi argon tu kan pi gwa kǝ bi Yam nartǝni. Mǝ mom'e mbarǝm tu kan warke'i tuwo mǝn warwat pitǝn ni.>> ");
INSERT INTO plj_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ar ni tǝ bali wur tǝ wule, <<Ko mǝn warwat pitǝn ni ma, amo a mom da'a. Bar nǝm ni a momi. Faro gǝrǝm ni tabiyi ama kǝkǝno a shin bar wi.>> ");
INSERT INTO plj_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Kan wu pa ngen momi kar ti wu wule, <<Unun tǝ pi'iwe? Tǝp imnu tǝ ɓul ger giwu?>> ");
INSERT INTO plj_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Tǝ nǝmi wur tǝ wule, <<A yari in wi ama kǝ nge kumi gǝnka. Unun kem kǝ ndu kǝ kum ra esi? Kǝn ma kǝ ndu ni'e kǝ pal mir mǝn kulci kar ti pa'a?>> ");
INSERT INTO plj_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ar ni wu yari ti mǝgǝn shirǝm wu wule, <<Ki ni'e nye mǝn kulci kar ti, miwo, mǝn mir mǝn kopi kulci kǝ Musa ni. ");
INSERT INTO plj_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Mǝ mom'e Yam shirǝm na Musa, ama mbarǝm tuwo, mǝ mom ako ni tǝ ɗǝl ɗir da'a.>> ");
INSERT INTO plj_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Kan mbarǝmi ba nǝmi wur tǝ wule, <<Unu fa utu untu! Kǝ mom las tu kan tǝ ɗǝl ɗir gwa da'a, ama ar tu tǝ ɓul ger gǝn wi! ");
INSERT INTO plj_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Mǝ mom'e Yam ba kum mǝn warwat pitǝn da'a. Tǝ kum ni mbarǝm tu kan ba bote ti na pi argon tu tǝ ndu gwa. ");
INSERT INTO plj_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ar tu na la'i gǝs kǝ pi atlo mǝ taɓe kumi den'e ɓul ger kǝ mbarǝm gon kan gǝr ti tabi gwa da'a. ");
INSERT INTO plj_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","O na mbarǝm tuwo kar Yam ni tǝ ɗǝl dawo, tii mani pi argon da'a.>> ");
INSERT INTO plj_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Den muntuwo ar ni wu bali ti wu wule, <<Ki kan gǝr ki gip warwat pitǝn gwa ni kǝkǝno kǝ ri kǝ kulci miya?>> Ar ni wu kar tika. ");
INSERT INTO plj_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu zam na kumi den'e wu kar mbarǝmika. Ar ni nan tǝ zam tiwo, kan tǝ ngen momi kar ti tǝ wule, <<Kǝ ngǝsh ki den Nya Mbarǝma?>> ");
INSERT INTO plj_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ar ni mbarǝmi ngen momi kar ti tǝ wule, <<Mǝn nartǝni, wo ni'e Nya Mbarǝmiyi? Yarim kǝ dǝ a ngǝshim den ti ra.>> ");
INSERT INTO plj_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Kan Yesu ba nǝmi ti tǝ wule, <<Kǝ shin ti wi, ti ni den shirǝm nan ki.>> ");
INSERT INTO plj_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ar ni mbarǝmi wule, <<Babomi, a ngǝshim den ti wi,>> kan tǝ ngus cina dǝ Yesu tǝ bote ti. ");
INSERT INTO plj_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesu wule, <<A sur ni atl kǝ tloyi shirǝmi, kǝ dǝ munju tabino wu zam shini bari, kan munju kan ba shin baro wu palka tabiyi.>> ");
INSERT INTO plj_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Nan mǝn Pariseyi jen kan ra kosak nan ti gwa kum untuwo, ar ni wu ngen momi kar ti wu wule, <<Mǝn ma tabi ijuwa?>> ");
INSERT INTO plj_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Kan Yesu ba bali wur tǝ wule, <<Dǝ wule kǝn tabino, na kii nǝra na warwat pitǝn da'a. Ama kǝkǝn kan kǝ kum den kǝ shin baro, warwat pitǝn gin ra dlakǝt nan kǝne.>> ");
INSERT INTO plj_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","<<Ge shirǝm ni a yari in kǝn mǝn Parise, mbarǝm tu kan kop tǝp bǝdlabǝn bin tǝm kan tǝ te gipi da'a, ama tǝ kop tǝp gon tǝ te gipiwo, mur ni na mur mǝn dlǝri den tǝpe. ");
INSERT INTO plj_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Muntu kan te gipi tǝp bǝdlabǝn bin tǝmiwo, ti ni'e mǝn le tǝmi. ");
INSERT INTO plj_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Mǝn ɓuti bomi baa ɓuli ti bǝdlabǝni. Tǝmi baa kum yar kǝ mǝn le gǝzǝni. Tǝ la bi tǝm gǝs na sun gǝzǝni kan tǝ nde wur cina wu ɗǝl kaari. ");
INSERT INTO plj_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ti ni tǝ ɗǝli wur kup kaariwo, tǝ nde wur ni cina, tǝmi den kopi gǝsi domici wu mom yar gǝsi. ");
INSERT INTO plj_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Wii kop mǝn dǝki da'a, se de wu kǝtǝri ti domici wu mom yar kǝ mǝn dǝki da'a.>> ");
INSERT INTO plj_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu yari wur untu, ama wu mani momi argon tu tǝ yari wur gwa da'a. ");
INSERT INTO plj_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ra untuwo, ar ni Yesu pa yari wur ra'e, <<Na ho bi ni a yari ine, ami ni'e bǝdlabǝn bin tǝmi. ");
INSERT INTO plj_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Munju kup kan nda ɗir cina da'ǝmo mur ni na mur mǝn dlǝri den tǝpe, ama tǝmi nge kumi gǝzǝnka. ");
INSERT INTO plj_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ami ni'e bǝdlabǝni, kup muntu kop tǝp karǝmo, tii zam ɗǝltǝne. Tii ɗir te gipi tǝ pal tǝ ɗǝli, tǝ zam yari jir kǝ ci. ");
INSERT INTO plj_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mur ba ɗir ni katl kǝ dǝ tǝ pi mure, tǝ ri eka, tǝ pa liika. Ama a ɗir ni kǝ dǝ wu zam ge mbatl tu kan baa pa da gwa, kan wu zam ti na laa'i. ");
INSERT INTO plj_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","<<Ami ni'e ho mǝn le tǝme. Ho mǝn le tǝm ba bi ge mbatl gǝs den bi tǝmi. ");
INSERT INTO plj_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Mǝn le tǝm kǝ wurpiwo, tǝmiwo gwas ni da'a. Ra untuwo, ti ni tǝ shin yer lǝp den ɗirtǝno, tii za tǝmika tǝ kǝtǝr gǝs kan dǝ yer lǝpi tli den tǝmi tǝ gǝzan wurka. ");
INSERT INTO plj_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Mbarǝmi kǝtǝr ni gǝs domici tǝ mǝn le tǝm kǝ dǝ ɓatl ti ni katl, ko njem argon ghun ti na tǝmi da'a. ");
INSERT INTO plj_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","<<Ami ni'e ho mǝn le tǝme, a mom tǝm gǝni, kan tǝm gǝn momǝni. ");
INSERT INTO plj_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Kandatu Ban momǝn kan a mom Ban gwa itu, kan ami den bi ge mbatl gǝn den bi tǝmi. ");
INSERT INTO plj_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ami ra na nami tǝmi kan ra gip garke tǝmi mǝnkǝn da gwa. Ar nǝmǝn te yarka wu ma a ɗir wuri. Wu ma wii kum yar gǝni, kan wu dǝm garke nǝm, mǝn le gǝzǝn ma nǝm. ");
INSERT INTO plj_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Argon tu kem Ban ba ndu'ǝm gwa ni'e a bi ge mbatl gǝn kǝ dǝ a pa pǝn ar gǝn esi. ");
INSERT INTO plj_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Murgon baa mani pǝnim nge mbatl gǝnka da'a, domici ami ni a bi ge mbatl gǝn na gam gǝni. Ami na iko kǝ a bi ge mbatl gǝni, untu ni es ami ra na iko kǝ pali gǝs ra. Argon tu Ban yarǝm kǝ dǝ a pi gwa itu.>> ");
INSERT INTO plj_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Den shirǝm tuwo ar ni bi i'nde mǝn Yahudayi nǝm da'a. ");
INSERT INTO plj_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Na womti gǝzǝn wule, <<Ti mǝn itǝr ni, ar ni tǝ pi zhe'e pitǝn ra. Unun kem kǝ kum ti rawu?>> ");
INSERT INTO plj_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ama nami wule, <<Shirǝm kǝ mbarǝm mǝn itǝr itu da'a. Mǝn itǝr ba mani ɓuli ger kǝ tabi ya?>> ");
INSERT INTO plj_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Gip wokoci sanyi, kan den pi Nyel kǝ ta'i Yam Bom kǝ Yam su Urshalimaka. ");
INSERT INTO plj_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesu ngap ra gip bom kǝ Yam den ɓomi asǝm gip las tu ba la ti bi'e Dlabǝn Shukutǝn kǝ Solomon gwa. ");
INSERT INTO plj_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ar ni mǝn Yahuda dom wur wu gandǝl ti, kan wu wul ti'e, <<Har gigasi ni kii za mi gip dǝmǝn gami? Ki ni'e Almasihu fawo, yari mi tetla tetla.>> ");
INSERT INTO plj_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Kan Yesu ba nǝmi wur tǝ wule, <<A tare a yari in wi, ama kǝ nge ngǝshtǝnka dene. Mbap ju kan a pi gip sun kǝ Ban gwa ni ba bi seda demǝni. ");
INSERT INTO plj_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ama kǝ ngǝsh kǝn den untu ni da'a, nan kǝn tǝm gǝn ni da gwa. ");
INSERT INTO plj_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Tǝm gǝn ba pi ni argon tu a yari gwa. A mom wuri, kan wu kopǝni. ");
INSERT INTO plj_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","A bi wur bi wur ge mbatl tu kan baa pa da gwa wi, kan ko njem wii mǝshka da'a. Murgon ra kan baa mani ɗǝli gǝzǝnka gip am gǝn gwa da'a. ");
INSERT INTO plj_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ban tu kan bim wuro, tǝ naar man kup, murgon ra kan baa mani ɗǝli gǝzǝnka gip am gǝs gwa da'a. ");
INSERT INTO plj_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ami na Banwo, nǝm ni.>> ");
INSERT INTO plj_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ar ni mǝn Yahudayi pa yem tat kǝ la'i gǝsi. ");
INSERT INTO plj_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Kan Yesu ba wul wur'e,<<A pi mbuni bar na womti tǝp kar Ban. Kǝkǝno den gonge ni gip wur kǝ ri kǝ la'i gin na tatwe?>> ");
INSERT INTO plj_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ar ni mǝn Yahudayi bali ti wu wule, <<Mǝ ri kǝ la'i gi na tat den ko nǝm gip mbuni mbap ju kan kǝ pi gwa da'a, ama den mburi Yami, domici ki mbarǝm ni katl, ama kǝ pali gam gika Yami.>> ");
INSERT INTO plj_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu nǝmi wur tǝ wule, <<Ar ra na rǝshi gip Kulci gin'e, <A wule kǝn mir yam ni.> ");
INSERT INTO plj_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Mǝ mom'e rǝshi Shirǝm kǝ Yam baa cen lar da'a. Babom ni wul munju kan kum shirǝm gǝs gwa <mir yami> ");
INSERT INTO plj_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","im nu na ami kan Bǝba ne den ami gwas ni kan tǝ karǝm sur atl gwawu? Unun ɗiri shirǝm den'e a mbur Yam nan a wule, <Ami Nya Yam ni gwa?> ");
INSERT INTO plj_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ba kǝ ngǝsh kǝn ni demǝn da'a, mbap ju Ban den pi gwa ni fa a pi da gwa. ");
INSERT INTO plj_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ama ar ni a pi fawo, kup na kǝ ngǝsh kǝn demǝn dawo, ngǝsh kǝn ni den mbap ju, kǝ dǝ kǝ mom ni, kan kǝ ngǝsh kǝn den'e Bǝba ra gipi ni, kan ami ra gip Bǝbayi.>> ");
INSERT INTO plj_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ar ni wu pa ndu wu nǝm ti, ama tǝ ɗǝli wur amka. ");
INSERT INTO plj_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Kan Yesu ba pa jikat ɓula kǝ Urdun tǝ mbubar las tu kan Yohana den pi batisma na pare bar gwa, tǝ dǝm gǝs barta. ");
INSERT INTO plj_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ar ni mbarǝm na womti ɗir kar ti. Wu wule, <<Rawo Yohana pi halama bar kǝ nǝmi bi na am gon da'a, ama argon tu kup tǝ yari den mbarǝm tuwo, untu ni ar ra.>> ");
INSERT INTO plj_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Kan mbarǝm na womti kan ra lasi gwa ba ngǝsh wur den Yesu. ");
INSERT INTO plj_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Mbarǝm gon mǝn sun Li'azaru ra den kumi dli. Ti mbarǝm kǝ Betanya ni, nye bǝn kǝ ga Maryamu na erǝm gǝs Marta. ");
INSERT INTO plj_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maryamu tu, muntu erǝm gǝs Li'azaru ra ɓom atl den kumi dliwo, nǝm ti ni'e muntu kan shoti mir den kaar asǝm kǝ Babom kan tǝ sarka na ta gam gǝs gwa. ");
INSERT INTO plj_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ar ni ga erǝm gǝs mir mǝtliyi kar bar den Yesu wu wul ti'e, <<Babomi, muntu kan kǝ ndu gwa ra den kumi dli.>> ");
INSERT INTO plj_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Nan tǝ kum untuwo, ar ni Yesu wule, <<Kumi dli gǝs tu baa ri ga mǝshtǝn da'a. O'o, den bi ɗǝɗa Yam ni, kǝ dǝ Nya Yam zam ɗǝɗatǝn tǝp kar untuyi.>> ");
INSERT INTO plj_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu ba ndu Marta na ga erǝm gǝs Maryamu na Li'azaru. ");
INSERT INTO plj_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Kup na untu, nan tǝ kum'e Li'azaru ra den kumi dliwo, ar ni tǝ dǝm gǝs las tu tǝra gwa kǝ muri rop ra. ");
INSERT INTO plj_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Kan tǝ wul mir mǝn kulci kar ti'e, <<Mǝ pa pal ni gip atl kǝ Yahuda.>> ");
INSERT INTO plj_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Wu wul ti'e, <<Ba mǝn kulci, ar dlyam wi da'a kan mǝn Yahuda ndu wu la ki na tat gwa, kup na untuwo kǝ ndu kǝ pa pal bartaya?>> ");
INSERT INTO plj_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu nǝmi wur tǝ wule, <<Awa kutl cet rop ni gip nde pǝt nǝm diya? Mbarǝm tu kup ba ɓom asǝm gip pǝto, tii pat asǝmka da'a, domici tǝ shin bar na cirtǝn kǝ den atl kǝni. ");
INSERT INTO plj_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ama muntu kup ba ɓom asǝm gip gas gwa ni ba pat asǝme, nan cirtǝn ra kar ti dagwa.>> ");
INSERT INTO plj_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Nan tǝ yari muntuwo, ar ni tǝ ci cina tǝ yari wur'e, <<Berǝm gǝmi Li'azaru nde umur kawi, ama aa ri putu tika.>> ");
INSERT INTO plj_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Mir mǝn kulci kar ti bali ti'e, <<Babomi, umur ni fa tǝ ndewo, tii kum tǝmi kǝ dli gǝsi.>> ");
INSERT INTO plj_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesu ni den shirǝm den'e Li'azaru mǝsh kawi, ama mir mǝn kulci kar ti pǝn'e nde umur kǝ shukutǝn ni ti dene. ");
INSERT INTO plj_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ar ni tǝ yari wur ghon tǝ wule, <<Li'azaru mǝsh kawi. ");
INSERT INTO plj_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ar gholim mbatl domici gin nan ami ra lasi da gwa, kǝ dǝ kǝ ngǝsh kǝn den Yam ra. Ama mǝ rǝni kar ti.>> ");
INSERT INTO plj_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ar ni Toma (kan ba la ti bi'e nye Ngumci gwa) wul nami mir mǝn kulci kar Yesuyi'e <<Mǝn ma mǝ su nǝka, kǝ dǝ mǝ mǝsh ni nan ti pa'e.>> ");
INSERT INTO plj_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Nan Yesu mbubaro, ar ni tǝ zam na momi den Li'azaru pi muri wupse na kapi wi. ");
INSERT INTO plj_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betanyawo kosak na Urshalima ni ar ra, bar kǝ mil rop, ");
INSERT INTO plj_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Mǝn Yahuda na womti ɗir wi kǝ kulu keti na ga Marta na Maryamu den mǝshtǝn kǝ erǝm gǝzǝni. ");
INSERT INTO plj_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Nan Marta kum'e Yesu den ɗirtǝno, ar ni tǝ ɗǝl tǝ ri kǝ mbori gǝsi, ama Maryamu dǝm gǝs bomi. ");
INSERT INTO plj_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta wul Yesu'e, <<Babomi, kira far ɗewo, erǝm gǝn ba ri kǝ mǝshtǝn da'a. ");
INSERT INTO plj_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ama a mom'e kǝkǝn ma Yam baa bi'i argon tu kup kǝ liri gwa.>> ");
INSERT INTO plj_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu wul ti'e, <<Erǝm gi baa tli ra esi.>> ");
INSERT INTO plj_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta nǝmi ti'e, <<A mom'e ti tli ra es gas pa'i bar kup kan mǝshi mbarǝm baa tli ra na ge mbatl gwa.>> ");
INSERT INTO plj_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesu wul ti'e, <<Ami ni'e tlitǝn kǝ mǝshi mbarǝm kan ami ni'e ge mbatli. Muntu kan ngǝsh ti demǝno, tii dǝm na ra na ge mbatli, ko ma tǝ mǝsh nika. ");
INSERT INTO plj_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Muntu kan ra na ge mbatli kan ngǝsh ti demǝno, tii mǝsh da'a. Kǝ ngǝsh ki den muntu ya?>> ");
INSERT INTO plj_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta wul ti'e, <<Aan, Babomi, a nǝm wi den ki ni'e Almasihu, Nya Yami, muntu kan ba sur gip atl gwa.>> ");
INSERT INTO plj_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Nan tǝ pa'i yari muntuwo ar ni tǝ pal rin bomka kan tǝ la bi erǝm gǝs Maryamu markǝm tǝ wul ti'e, <<Ba mǝn kulci mbirawi, tǝ den ngeni gi.>> ");
INSERT INTO plj_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Nan Maryamu kum muntuwo, ar ni tǝ tlyam na zhotǝn tǝ ri kar ti. ");
INSERT INTO plj_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ar dǝm'e Yesu mbubar gip bǝni wi da'a, ama tǝ'i las tu Marta mo nan ti gwa. ");
INSERT INTO plj_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Nan mǝn Yahuda kan ra na Maryamu gip bom den damtǝn nan ti shin tǝ tlyam na zhotǝn kan tǝ ɗǝlo ar ni wu pǝn den'e tǝ rǝni kǝ ba gambǝci'i kǝ kulu lasi. ");
INSERT INTO plj_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Nan Maryamu mbubar las tu Yesu ra, nan tǝ shin tiwo, ar ni tǝ nda atl cina da ti tǝ wul ti'e, <<Babomi, na dǝ wule ki ra far ɗewo, erǝm gǝn baa mǝshka da'a.>> ");
INSERT INTO plj_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Nan Yesu shin ti den kulu, na mǝn Yahuda ju kan ɗir nan ti ma den kuluwo, ar ghun ti gip ruhu kan tǝ dam ti hoyi gip mbatl gǝsi. ");
INSERT INTO plj_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ar ni tǝ wule, <<Ako ni kǝ kap tiwe?>> Kan wu bali ti'e, <<Babomi, ɗir shini.>> ");
INSERT INTO plj_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ar ni Yesu kuli. ");
INSERT INTO plj_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ar ni mǝn Yahudayi wule, <<Shin kandatu tǝ ndu ti gwa!>> ");
INSERT INTO plj_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ama jen gip wur wule, <<Muntu kan ɓul ger kǝ batabi tu baa mani hane mbarǝm tu mǝshtǝn diya?>> ");
INSERT INTO plj_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Nan Yesu ra gip damtǝn den mǝshtǝniwo, ar ni tǝ ri kar gambǝci'i. Gambǝci'iwo shu ni kan bor gip tat gwa kan ba le bisika na tat goni. ");
INSERT INTO plj_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesu wul wur'e, <<Jirkǝt ni tatika markǝme.>> Ama Marta, erǝm kǝ mǝshiyi wule, <<Ama Babomi, kǝkǝno usuntǝn ni katl bani, domici muri gǝs wupse ituwi na mǝshtǝni.>> ");
INSERT INTO plj_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ar ni Yesu wule, <<A yari'i ni da'aya? E den ki ni kǝ la Yam mbatlo, kii shin ɗǝɗatǝn kǝ Yami?>> ");
INSERT INTO plj_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ar ni wu kutǝl tatika markǝme. Yesu tli ger yami, kan tǝ wule, <<Bǝba, a goode'i den kǝ kumǝni. ");
INSERT INTO plj_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","A mom'e kǝ kumǝn ko gigasi, ama a yari ni untu den bi kǝ munju kan dlor ɗegwa, kǝ dǝ wu nǝm den'e ki ni kǝ karǝmi.>> ");
INSERT INTO plj_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Nan tǝ yari muntuwo, ar ni Yesu tli yar yam tǝ wule, <<Li'azaru, ɗǝl tori!>> ");
INSERT INTO plj_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ar ni mǝshi mbarǝmi ɗǝl tor, am gǝs na asǝm gǝs na ɓali na tutul ghumi mǝshi mbarǝme, na ba ger gǝs ɓali na tutule. Yesu wul wur'e,<<Pǝtl ni tutul ghumi mǝshi mbarǝm tuka kǝ za tǝni tǝ ndara.>> ");
INSERT INTO plj_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ra untuwo, ar ni na womti kǝ mǝn Yahuda kan ɗir kǝ shirmi Maryamu shin argon tu Yesu pi gwa, kan wu ngǝsh wur den ti. ");
INSERT INTO plj_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ama jen gǝzǝn ri kar mǝn Parise kan wu yari wur argon tu Yesu pi gwa. ");
INSERT INTO plj_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ar ni kiri mǝn keri bar ju ɗiri Yam na mǝn Pariseyi la bi domtǝn kǝ mǝn tloyi shirǝm kǝ mǝn Isra'ila. Wu ngen momi wu wule, <<Ununu mii pi den muntu we? Ar tu mbarǝm tu den ta pi halama bar kǝ nǝmi bi na am na womti. ");
INSERT INTO plj_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Mǝn ni mǝ za ti tǝ ci cina na untuwo, mbarǝm kup ba ngǝsh wur den ti, kan dǝ mǝn Roma ɗir nǝm atl gǝmika na Bom kǝ Yam gǝmi.>> ");
INSERT INTO plj_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ar ni nǝm gip wur mǝn sun Kayafas, bar mǝn keri bar ju ɗiri Yam kǝ sheti ghoni, shirǝm tǝ wule, <<Ko nǝm kǝ mom argon da'a! ");
INSERT INTO plj_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Kǝ mom ni'e ar mani dǝ mbarǝm nǝm mǝshka na dǝ mbarǝm kǝ atl kup liika gwa da'a ya?>> ");
INSERT INTO plj_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Tǝ yari ni untu gip bopya kǝ gam gǝs da'a, ama nan ti ni'e bar mǝn keri bar ju ɗiri Yam kǝ sheti ghon tawo, tǝ yari ni ge shirǝm kan ɗǝl sur kar Yam gwa den Yesu baa mǝsh den am kǝ atl kǝ mǝn Yahuda kup, ");
INSERT INTO plj_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ba'e den am kǝ atl kǝ mǝn Yahuda ni katl da'a ama kǝ dǝ tǝ dom mimir kǝ Yam kan gǝzan ko ako gwa wu dǝm nǝm. ");
INSERT INTO plj_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Argon tu kan pǝn den gas tawo ar ni wu pi ta ngeni tǝp kǝ ri Yesu eka. ");
INSERT INTO plj_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ra untuwo ar ni Yesu i'ci cina na ɗǝltǝn gip mbarǝm kǝ mǝn Yahuda gip pili da'a, ar ni tǝ za lasika tǝ ndara atl kan kosak na bi lǝpe, gip bǝn tu kan ba la ti bi'e Ifraimu gwa, lasi ni tǝ dǝm na mir mǝn kulci kar ti. ");
INSERT INTO plj_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Nan ar mbi kosak na Nyel Jikat Bǝdlabǝn kǝ mǝn Yahudawo, ar ni mbarǝm na womti za mir heli bǝn wu to Urshalima kǝ pi bar ju ba pi kǝ pali mbarǝm dlǝran cina dǝ Yam gwa kapǝn Nyeli. ");
INSERT INTO plj_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Wu pi ta ngeni Yesu, wu ra dlor gip bom kǝ Yam wu den ngeni momi kar ezǝn'e, <<Unun kǝ shinwe? Tii ɗir ni kǝ ba Nyeli diya?>> ");
INSERT INTO plj_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Rawo kiri mǝn keri bar ju ɗiri Yam na mǝn Pariseyi bi biwi den murgon tu kup zam na momi las tu Yesu rawo, tǝ ɗir yari kǝ dǝ wu nǝm ti. ");
INSERT INTO plj_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Muri mukka kapǝn Nyel Jikat Bǝdlabǝniwo, ar ni Yesu mbubar gip Betanya, las tu Li'azaru, muntu Yesu tli ti gip mǝshi mbarǝmi ba dǝm gwa. ");
INSERT INTO plj_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Kan ba pi Yesu bar kǝ ci kǝ gas lasi. Marta bi wur fingali, Li'azaru ngapo tǝra gip munju dǝm kǝ ci fingal na Yesu gwa. ");
INSERT INTO plj_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ar ni Maryamu pǝn tulare kǝ nardi, mǝn wurpi na naari, tǝ shoti den kaar asǝm kǝ Yesu kan tǝ sari ti asǝmka na ta gam gǝsi. Ar ni bomi kup nga lasi na tǝmi kasǝri. ");
INSERT INTO plj_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ama Yahuda Iskariyoti, nǝm gip mir mǝn kulci kar ti, muntu kan ba ri kǝ bi Yesu kagwa nge na wultǝn'e, ");
INSERT INTO plj_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","<<Unun kem baa wur mir tuka den wurpi nan baa kǝm ɓatli mǝn mbap kǝ sheti ghon nǝm gwa dǝ bi wurpiyi munju am ri wur kaar da gwawu?>> ");
INSERT INTO plj_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Tǝ yari ni untu ba'e den argon tu ba ndo na munju am ri wur kaar da'a ba ghun tǝni da'a, ama domici ti mur ni, ti ni'e mǝn ne posh wurpi gǝzǝni, kan tǝ kur yem gip wurpiyi tǝ pi bar kǝ gam gǝs nari. ");
INSERT INTO plj_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yesu bali wur'e, <<Za tǝni, tǝ ne ni mir tuka ra den bi pǝt kapi gǝni. ");
INSERT INTO plj_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Kii nǝra na munju am ri wur kaar dagwa nan kǝn ko gigasi, ama kii nǝra namǝn ko gigasi da'a.>> ");
INSERT INTO plj_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Nan womti mbarǝm kǝ mǝn Yahuda mom ka'e Yesu ra bartawo kan wu ri, ba'e kǝ dǝ wu shin ti ni katl da'a ama wu pa shin Li'azaru, muntu Yesu tli ti gip mǝshi mbarǝm gwa. ");
INSERT INTO plj_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ar ni kiri mǝn keri bar ju ɗiri Yam gwa gudlumi kǝ dǝ wu ri Li'azaru eka esi, ");
INSERT INTO plj_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","den'e domici gǝso mǝn Yahuda na womti den za'i gǝzǝnka wu den ritǝn gǝzǝn kar Yesu wu den ngǝshtǝn den ti. ");
INSERT INTO plj_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Bar tlowo, ar ni womti mbarǝmi kan ɗir kǝ Nyel Jikat Bǝdlabǝni ba kum'e Yesu ra den tǝp gǝs kǝ tetǝn gip bǝn Urshalima. ");
INSERT INTO plj_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ar ni wu yem am kin dabino kan wu ɗǝl kǝ metǝn nan ti wu den tli yar na wultǝn'e, <<Hosana! Mǝn albarka ni'e muntu kan ba ɗir gip sun kǝ Babom gwa! Mǝn albarka ni'e gun kǝ Isra'ila!>> ");
INSERT INTO plj_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Nan Yesu zam nye bar kǝm gono, kan tǝ to den ti, kandatu ar ra na rǝshi gwa'e, ");
INSERT INTO plj_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","<<Kum ni bǝrti da'a, mbarǝm kǝ Urshalima. Shini, gun gin kǝn den ɗirtǝne, njon den nye bar kǝme.>> ");
INSERT INTO plj_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Wokoci tu bar ju ba piwo mir mǝn kulci kar ti mom unun munju ba pi nupi da'a. Ama den kaar kǝ ɗǝɗa Yesu na tli gǝs gip mǝshi mbarǝmo, ar ni wu mom den'e bar ju kan pi tiwo untun ar ra na rǝshi terka den ti. ");
INSERT INTO plj_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Womti mbarǝmi kan kar ti nan tǝ la bi Li'azaru gip gambǝci kan tǝ tli tika gip mǝshi mbarǝm ci cina na yari mbarǝm argon tu Yesu pi gwa. ");
INSERT INTO plj_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Mbarǝm na womti ɗǝl ni kǝ metǝn na Yesu domici wu kum den halama bar kǝ nǝmi bi na am tu kan tǝ pi gwa. ");
INSERT INTO plj_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ar ni mǝn Parise wul ezǝn'e, <<Kǝ shin capo mii mani pi argon da'a. Shin ni kandatu mbarǝm kup ba kop ti gwa!>> ");
INSERT INTO plj_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Rawo, mǝn Hellas jen ra gip munju kan te Urshalima kǝ bote Yam wokoci nyel jikat bǝdlabǝni gwa. ");
INSERT INTO plj_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ar ni wu ri kar Filibus, mbarǝm kǝ Betsaida gip atl kǝ Galili, wu wul ti'e, <<Mǝn nartǝni, mǝ ndu mǝ shin Yesu.>> ");
INSERT INTO plj_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filibus ri yari Andǝrawus, kan Andǝrawus na Filibus ba ri yari Yesu. ");
INSERT INTO plj_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesu bali wur tǝ wule, <<Wokoci ɗir wi kǝ dǝ ɗǝɗa Nya Mbarǝme. ");
INSERT INTO plj_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ge shirǝm ni a yari ine, ge o ni nda atl kan ar mǝsh dawo, ar ba pi ta dǝmi ge o nǝm katl. Ama ar ni mǝsho, ar ba bi mimir na womti. ");
INSERT INTO plj_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Murgon tu kup kan gam gǝs ni tǝ ndu'o, tii hol ge mbatl gǝsi. Ama muntu kan nge ge mbatl gǝs den kaar bar atl kǝn baa zam ge mbatl tu kan baa pa da gwa. ");
INSERT INTO plj_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Murgon tu kup ba ndu a dǝm Babom gǝso, tii kopǝn kǝ dǝ las tu ami rawo, dǝ mǝn pim mbapi nǝra lasi. Ban ngap baa ɗǝɗa muntu kup kan ba pim mbap gwa. ");
INSERT INTO plj_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","<<Kǝkǝno mbatl gǝn tlika wi kan unun aa wul ra? Bǝba, ba kǝ za dǝ argon tu ba pi gip wokoci kǝn zamǝn da'aya? O'o, kǝ dǝ untu pi namǝn ni a sur ra. ");
INSERT INTO plj_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Bǝba, ɗǝɗa sun gi!>> Kan yar gon ba ɗǝl sur yam ba wule, <<A ɗǝɗa'i wi, kan a ri kǝ ɗǝɗa'i ra.>> ");
INSERT INTO plj_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Nan womti mbarǝmi kan ra lasi gwa kum untuwo ar ni wu wule Yam ɓo gam wi, nami ngapo ar ni wu wule nye mǝn kartǝn kǝ Yam gon ni shirǝm nan ti. ");
INSERT INTO plj_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yesu wul wur'e, <<Yar tuwo den bi gin ni, ba'e gwan da'a. ");
INSERT INTO plj_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Kǝkǝn ni'e wokoci kǝ hukunte atli, kǝkǝn ni ba ri kǝ byali muntu kan den dandi kǝ atl kǝn gwa atli. ");
INSERT INTO plj_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ama amo, wokoci tu tlimka den kaar atlo, aa dǝl mbarǝmka kup karǝmi.>> ");
INSERT INTO plj_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Tǝ yari ni muntu kǝ dǝ tǝ gode kandatu tǝ ri kǝ mǝshtǝn gwa. ");
INSERT INTO plj_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Womti mbarǝmi shirǝm wu wule, <<Gip kulci gǝmiwo mǝ kum'e Almasihu baa dǝm baa patǝni, ra imnu kǝ wule, <Ar nǝm dǝ tli Nya Mbarǝm yamwe? Wo ni'e Nya Mbarǝm tuwe>?>> ");
INSERT INTO plj_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ar ni Yesu wul wur'e, <<Cirtǝn baa nǝra nan kǝn cina njem ɗe. Ɓom ni asǝm kǝkǝn nan kǝn ra na cirtǝni gwa, kapǝn dǝ dǝmǝn tla gam ginka. Mbarǝm tu kan den ɓomi asǝm gip dǝmǝn ba mom las tu kan tǝ ri gwa da'a. ");
INSERT INTO plj_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ngǝsh kǝn ni den cirtǝni nan kǝn ra nan ti gwa, kǝ dǝ kǝ dǝm mimir kǝ cirtǝn ra.>> Nan Yesu pa'i shirǝmo, ar ni tǝ ndara kan tǝ ghuuni wurka. ");
INSERT INTO plj_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Kup na halama bar kǝ nǝmi bi na am ju kan Yesu pi den ger gǝzǝni, ama ar ni wu nge ngǝshtǝn den tika. ");
INSERT INTO plj_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Muntu pi ni kǝ dǝ ar laa'i shirǝm tu kan mǝn yari shirǝm kǝ Yam Ishaya yari gwa'e, <<Babomi, wo ni nǝm argon tu kan mǝ yari gwawe, dǝ wo ni Yam ɓuli ti bar ju kan Babom pi gwawu?>> ");
INSERT INTO plj_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Muntu ni kem wu ngǝsh wur den Yam da'a, kandatu Ishaya yari las gon gwa'e, ");
INSERT INTO plj_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","<<Yam pali wurka tabiyi wi kan tǝ lati mbatl gǝzǝnka den ba wu'i mani shini bar na ger gǝzǝni, ko dǝ mbatl gǝzǝn mani nǝmi bari, kǝ dǝ wu pal karǝm zam a warke wur ra.>> ");
INSERT INTO plj_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ishaya yari ni untu domici tǝ shin ɗǝɗatǝn kǝ Yesu, kan tǝ shirǝm den ti. ");
INSERT INTO plj_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Kup na untu jen gip kiri kǝ cina gǝzǝn ngǝsh wur den ti. Ama gip bǝrti kǝ mǝn Parisewo wu mani shirǝm den ngǝshtǝn den Yam gǝzǝn da'a gip bǝrti den ba dǝ ɗǝli wurka gip bom domtǝn kǝ mǝn Yahuda da'a. ");
INSERT INTO plj_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Rawo, wu paye ndu'i argon tu wii pi dǝ mbarǝm ɗǝɗa wur ra man argon tu wii pi dǝ Yam ɗǝɗa wur gwa. ");
INSERT INTO plj_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ar ni Yesu tli yar yam tǝ wule, <<Mbarǝm ni ngǝsh ti demǝno, demǝn ni katl tǝ ngǝsh ti da'a, ama na muntu kan karǝm gwa pa'e. ");
INSERT INTO plj_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Muntu kup shimǝno, tǝ shin ni muntu kan karǝm gwa. ");
INSERT INTO plj_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","A sur ni atl kǝ dǝ a ɗiri atl kundǝrǝndlip cirtǝni, den ba dǝ ko nǝm gip munju kan ngǝsh wur demǝn dǝm gip dǝmǝn da'a.>> ");
INSERT INTO plj_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Muntu kan kum shirǝm gǝn ama tǝ pi argon tu a yari gwa dawo, aa hukunte ti da'a. Domici a sur ni atl kǝ hukunte mbarǝm da'a, ama kǝ dǝ a ɗǝli mbarǝme. ");
INSERT INTO plj_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Mǝn tloyi shirǝm muntu ngem kan ba nǝm shirǝm gǝn da'a ra. Shirǝm tu kan a yari gwa ni baa hukunte ti gas pa'i bar kup. ");
INSERT INTO plj_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Bar ju a kulci mbarǝmo karǝm ni ar ɗǝl da'a. Ama Ban kan karǝm gwa ni yarim argon tu aa yari na kandatu aa yari gwa. ");
INSERT INTO plj_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","A mom'e argon tu tǝ wule dǝ pi baa kem dǝ zam ge mbatl tu kan baa pa da gwa. Ra untuwo argon tu kup a yariwo ar ni'e argon tu Bǝba yarim kǝ dǝ a yari gwa. ");
INSERT INTO plj_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Gip untu kapǝn dǝ pi Nyel Jikat Bǝdlabǝno, Yesu mom den wokoci piwi kan tii za kaar bar atl kǝn tǝ ndara kar Base. Nan tǝ ndu gwas kan ra den kaar atlo, ar ni tǝ gode wur den tǝ ndu wur ar ri patǝn kǝ bari. ");
INSERT INTO plj_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Wokoci tu ni Yesu na mir mǝn kulci kar ti den ci fingal kǝ gasi, kan Shetan tare la wi gip mbatl kǝ Yahuda Iskariyoti, nya Siman, kǝ dǝ tǝ bi Yesu ka. ");
INSERT INTO plj_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu mom den Bǝbayi la bar kup gip am da ti wi, kan tǝ ɗǝl ni sur kar Yami, kan kar Yam ni tii palo, ");
INSERT INTO plj_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ar ni tǝ tli gǝs bi fingali, tǝ tus lulur gǝs kǝ den kaarika, kan tǝ ɓal tutul hotǝn ter gǝs da ti. ");
INSERT INTO plj_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ar ni tǝ shoti mal gip bar gali, kan tǝ nǝm ho'i asǝm kǝ mir mǝn kulci kar tiyi, tǝ den sarika na tutul hotǝni nan tǝ ɓal ter gǝs gwa. ");
INSERT INTO plj_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Nan tǝ ɗir den Siman Bitǝruso ar ni Bitǝrus wul ti'e, <<Babomi, ki ni kǝ ri kǝ ho'im asǝma?>> ");
INSERT INTO plj_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu bali ti tǝ wule, <<Kǝ mom argon tu kan ami den pi kǝkǝn gwa da'a, ama den kariwo kii momi.>> ");
INSERT INTO plj_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Bitǝrus wul ti'e, <<O'o, Babomi, ko njem, kii ho'im asǝm da'a.>> Yesu nǝmi ti tǝ wule, <<Ami ni a ho ki dawo, ki gwan ni da'a.>> ");
INSERT INTO plj_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Bitǝrus bali ti tǝ wule, <<Babomi, ba'e asǝm gǝn ni katl kii ho da'a ama na am gǝn na gam gǝn ma.>> ");
INSERT INTO plj_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu nǝmi ti tǝ wule, <<Muntu kan ho ti kawo, asǝm gǝs ni katl baa ndu ho'i, rawo dli gǝs kupo dlǝran ni ar ra. Dlǝran ni kǝn ra, ama ba'e kup gin ni da'a.>> ");
INSERT INTO plj_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Domici tǝ mom muntu kan ba ri kǝ bi gǝs ka gwa, ar ni kem tǝ wule ba'e kup gin ni ra dlǝran da'a. ");
INSERT INTO plj_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Nan tǝ pa'i ho'i wur asǝmo, ar ni tǝ la tutul dli gǝs kan tǝ pal kǝ ba dǝmi gǝs tǝ ngen momi kar wur tǝ wule, <<Kǝ mani momi argon tu kan a pi in gwaya?>> ");
INSERT INTO plj_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Kǝ la'ǝm bi <<Ba mǝn kulci>> na <<Babomi>> kan untu ni ar ra, domici argon tu ami ra gwa itu. ");
INSERT INTO plj_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Kǝkǝno ami, Babom na Mǝn kulci ine, ho asǝm ginka, kǝn ma ar ndari kǝ ho'i ni ya'ǝn asǝmka. ");
INSERT INTO plj_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","A gode in ni den kǝ pi ni kandatu a pi in gwa. ");
INSERT INTO plj_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ge shirǝm ni a yari ine, zher ba man babom gǝs da'a, ko dǝ nye mǝn kartǝn man muntu kan kar tiyi gwa. ");
INSERT INTO plj_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Kǝkǝn kan kǝ mom bar juwo, kii dǝm mǝn albarka kǝn ni kǝ pi gwa. ");
INSERT INTO plj_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","<<Ba'e a shirǝm ni den kup gin da'a, a mom munju kan a zǝzari gwa. Ama muntuwo kǝ dǝ laa'i argon tu shirǝm kǝ Yam yari gwa ni den'e, <Muntu kan den ci fingal namǝn balim kaarwi.> ");
INSERT INTO plj_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","<<A yari in ni kǝkǝn kapǝn ar pi, den wokoci tu ar ni piwo kǝ ngǝsh kǝn ni den ami ni'e ti. ");
INSERT INTO plj_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ge shirǝm ni a yari ine, murgon tu kup kan nǝm muntu a karo, ami ni tǝ nǝmi. Murgon tu kup nǝmǝno tǝ nǝm ni muntu kan karǝm gwa.>> ");
INSERT INTO plj_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Den kaar kǝ yari muntuwo, Yesu dam ti gip ruhu kan tǝ wule, <<Ge shirǝm ni a yari ine, nǝm gip kǝn ba ri kǝ balim kaari.>> ");
INSERT INTO plj_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Mir mǝn kulci kar ti shin ezǝn gip damtǝn den murgon tu tǝ shirǝm den ti gwa. ");
INSERT INTO plj_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Nǝm gip mir mǝn kulci kar ti, muntu Yesu ba ndu gwa ra njon kosak na Yesu. ");
INSERT INTO plj_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Siman Bitǝrus pi am nye mǝn kulciyi tǝ wul ti'e, <<Ngen momi kar ti den muntu tǝ shirǝm gwa.>> ");
INSERT INTO plj_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ar ni nye mǝn kulci kar ti kan dǝm kosak na Yesu gwa ngen momi kar ti tǝ wule, <<Babomi, wo ni ba ri kǝ pi ituwe?>> ");
INSERT INTO plj_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesu nǝmi ti tǝ wule, <<Ti ni'e muntu kan a cen nye bǝredi a si gip gal a ri ti kǝ bi gwa.>> Ar ni nan tǝ si nye bǝrediyi gip galiwo kan tǝ bi Yahuda Iskariyoti, nya Siman. ");
INSERT INTO plj_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Na zhotǝne nan Yahuda ci bǝredi tuwo, ar ni Shetan te gip ti. Ar ni Yesu wul ti'e, <<Yahuda, argon tu kǝ ri kǝ piwo, pi na zhotǝne.>> ");
INSERT INTO plj_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ama murgon ra gip munju kan Yesu bi wur fingali mom argon tu kem Yesu yari ti untu gwa da'a. ");
INSERT INTO plj_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Jen pǝn'e nan Yahuda ni na posh wurpi gǝzǝno, Yesu ba yari ti ni den tǝ ri wur argon tu ba ndu kǝ pi Nyeli, ko den tǝ bi argon munju am ri wur kaar da gwa ni. ");
INSERT INTO plj_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Na zhotǝne nan Yahuda ci bǝredi tuwo, ar ni tǝ ɗǝl te kaarika. Ar tu ngap gas ni. ");
INSERT INTO plj_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Nan Yahuda ndarawo, ar ni Yesu wule, <<Kǝkǝn ni Nya Mbarǝm zam ɗǝɗatǝn kan Yam ba zam ɗǝɗatǝn tǝp kar ti ra gwa. ");
INSERT INTO plj_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Yam ni zam ɗǝɗatǝn tǝp kar tiwo, Yam baa ɗǝɗa Nyayi gip gam gǝsi, ar ba dlyam da'a tii zam ɗǝɗatǝni. ");
INSERT INTO plj_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","<<Mimir gǝni, aa dǝm nan kǝn cina ɗe njem. Kii ngenǝmi, ama kandatu a yari mǝn Yahuda gwa'e, <Las tu a riwo, kii mani ritǝn da'a,> untu ni a yari in kǝkǝn pa. ");
INSERT INTO plj_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","<<Pel kulci ni a bi ine. Ndu ni ya'ǝni. Kandatu a ndu kǝn gwa, untun kǝn ma ar nǝm kǝ ndu ni ya'ǝni. ");
INSERT INTO plj_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Na untun mbarǝm kup baa mom'e kǝn mir mǝn kulci karǝm ni, kǝn ni kǝ ndu ya'ǝn gwa.>> ");
INSERT INTO plj_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Siman Bitǝrus ngen momi kar ti tǝ wule, <<Babomi, ako ni kǝ riwe?>> Yesu bali ti tǝ wule, <<Las tu a riwo, kǝkǝno kii mani kopi gǝn da'a, ama den kariwo kii mani kopi gǝni.>> ");
INSERT INTO plj_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Bitǝrus ngen momi kar ti tǝ wule, <<Babomi, ununu kem aa mani kopi gi kǝkǝn da'awu? Aa bi gam gǝn a mǝsh den bi gi.>> ");
INSERT INTO plj_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ar ni Yesu nǝmi ti tǝ wule, <<Kii bi gam gi kǝ mǝsh den bi gǝna? Ge shirǝm ni a yari'i, kapǝn dǝ tus kor la yar kǝ bǝtloniwo, kii wule kǝ momǝn da'a bisi myakan! ");
INSERT INTO plj_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","<<Ba kǝ za ni dǝ argon ghun kǝn da'a. Ngǝsh kǝn ni den Yami, kǝ pa ngǝsh kǝn ni demǝni. ");
INSERT INTO plj_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Gip bom dǝ Banwo kushi ra na womti. Untu ni fa dawo, na a yari in wi. A ndara ni barta kǝ kǝrkǝmi in lasi. ");
INSERT INTO plj_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ami ni a ndara a kǝrkǝmi in laso, aa pal sur kǝ pǝni gin karǝmi, kǝn ma kǝ dǝm ni las tu ami ra gwa. ");
INSERT INTO plj_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Kǝ mom tǝp ritǝn las tu a ri gwa.>> ");
INSERT INTO plj_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ar ni Toma wul ti'e, <<Babomi, mǝ mom las tu kǝ ri gwa da'a, imni mii mom tǝpi rawe?>> ");
INSERT INTO plj_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu nǝmi ti tǝ wule, <<Ami ni'e guntǝpe, ge shirǝmi, na ge mbatli. Tǝp karǝm nangǝn ni mbarǝm baa kop wu ri kar Bǝba. ");
INSERT INTO plj_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","O Kǝ momǝn fawo, kii mom Ban pa'e. Kǝkǝn na cina ɗewo, kǝ mom ti kǝ pal kǝ shin tiwi.>> ");
INSERT INTO plj_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filibus wul ti'e, <<Babomi, gode mi Bǝbayi, argon ra kan baa mani mi untu gwa da'a.>> ");
INSERT INTO plj_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu nǝmi ti tǝ wule, <<Filibus, kup na a dǝm nan kǝn kǝ tlyari wokoci untu ama har kǝkǝn kǝ momǝn diya? Kup murgon tu shimǝno, tǝ shin Bǝba wi. Imni kii wule, <Gode mi Bǝbayi>? ");
INSERT INTO plj_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Kǝ ngǝsh ki den'e ami ra gip Bǝbayi, kan Bǝbayi ra gipǝn da'aya? Shirǝm ju a yariwo gwan kǝ gam gǝn ni da'a, ama Bǝbayi kan ba dǝm gipǝn ni'e muntu ba pi mbap gǝs gwa. ");
INSERT INTO plj_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ngǝsh ki demǝn nan a wule ami ra gip Bǝba kan Bǝbayi ra gipǝn gwa. Untu ni dawo ngǝsh kǝn ni den bar kǝ nǝmi bi na am ju kan a pi gwa. ");
INSERT INTO plj_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ge shirǝm ni a yari ine, murgon tu kup kan ngǝsh ti demǝno tii pi argon tu kan ami den pi gwa. Tii pi bar ju kan man munju ma gwa, domici a ndara kar Bǝba wi. ");
INSERT INTO plj_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Kano aa pi argon tu kup kǝ liri gip sun gǝn gwa, kǝ dǝ Nyayi ɗiri Bǝbayi ɗǝɗatǝn kar mbarǝme. ");
INSERT INTO plj_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ko unun kǝ liri gip sun gǝno, aa pi ine. ");
INSERT INTO plj_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","<<Kǝn ni kǝ ndu'ǝmo, kii pi argon tu a wule kǝ pi gwa. ");
INSERT INTO plj_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Aa liri Bǝba, ti ngapo tii bi in gon Mǝn Ne Am ra tǝ dǝm nan kǝn baa patǝni. ");
INSERT INTO plj_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ti ni'e Ruhu mǝn ɓuli dǝ mom ge shirǝm den Yami. Mbarǝm kǝ atl baa mani nǝmi gǝs da'a, domici wu bot shini gǝs ko momi gǝs da'a. Ama kǝno kǝ mom ti, domici tǝra den dǝmi nan kǝne, kan tǝ pa dǝm gip mbatl gini. ");
INSERT INTO plj_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Aa za kǝn wule mir maraya da'a, ama aa ɗir kar kǝne. ");
INSERT INTO plj_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Cina ɗe njemo, mbarǝm kan den kaar bar atl kǝn ba'i shimǝn da'a, ama kǝno kii shimǝni. Domici ami kan ra na ge mbatlo, kǝn ma kii nǝra na ge mbatli. ");
INSERT INTO plj_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Gas ta ni kii mom'e ami ra gip Ban, kǝn ngap ra gipǝni, kan ami ra gip kǝne. ");
INSERT INTO plj_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Murgon tu kup kan kum kulci gǝn kan tǝ piwo, ti ni'e muntu kan ba ndu'ǝm gwa. Muntu ba ndu'ǝmo Ban baa ndu ti pa'e, kan ami ma aa ndu ti kan a ɓuli ti momi ko ami wo ni.>> ");
INSERT INTO plj_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ar ni Yahuda (ba'e Yahuda Iskariyoti da'a) wule, <<Ama Babomi, ununu kem kii gode mi ko ki wo ni ama kii gode nami mbarǝm kan den kaar bar atl dawu?>> ");
INSERT INTO plj_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu bali ti tǝ wule, <<Murgon tu kup ba ndu'ǝmo, tii kop argon tu a kulci gwa. Ban baa ndu ti, kan mǝ ɗir kar ti mǝ pi dǝmi gǝmi nan ti. ");
INSERT INTO plj_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Muntu kan ba ndu'ǝm dawo, tii kop kulci gǝn da'a. Shirǝm ju kǝ kumo gwan kǝ gam gǝn ni da'a, kǝ Bǝbayi kan karǝm gwa ni. ");
INSERT INTO plj_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","<<A yari in ni kup muntu nan a'i ra nan kǝn gwa. ");
INSERT INTO plj_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ama Mǝn Ne Am mbarǝmi, Ruhu kǝ Yami, muntu kan Bǝba baa kar sur gip sun gǝno, tii kulci in bar kup, tǝ pa ne in gip mbatl kup argon tu a yari in gwa. ");
INSERT INTO plj_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Dǝmi zhǝlili ni a za nan kǝne, dǝmi zhǝlili gǝn ni a bi ine. A bi in ni ba'e kandatu mbarǝm kǝ atl ba bi gwa da'a. Ba dǝ argon ghun kǝn ni da'a, eso ba kǝ kum ni bǝrti da'a. ");
INSERT INTO plj_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","<<Kǝ kum a wule, <Aa ndara kan a pa pal ɗir kar kǝne.> Kǝn ni kǝ ndu'ǝmo, kii pi ghol mbatl nan a ndara kar Bǝba gwa, domici Bǝbayi manǝmi. ");
INSERT INTO plj_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","A yari in wi kǝkǝni kapǝn ar ɗir pi untuyi, wokoci tu ar ni piwo kǝ ngǝsh kǝn ni den Yami. ");
INSERT INTO plj_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Aa'i shirǝm naar nan kǝn da'a, domici muntu kan den dandi atl kǝn den ɗirtǝne. Tǝ ra na argon kan tii mani pim gwa da'a. ");
INSERT INTO plj_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ama tǝ ɗir ni kǝ dǝ mbarǝm kan den kaar bar atl mom'e a ndu Bǝba kan a pi argon tu kan Ban ba ndu a pi gwa. Tli ni yam mǝ za ni ɗe.>> ");
INSERT INTO plj_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","<<Ami ni'e ho kin inabi, kan Ban ni'e mǝn pi mbap dene. ");
INSERT INTO plj_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ko gonge am kin tu gipǝn kan ba gǝri mimir dawo tii wotlka, kan tǝ kǝrkǝm am kin tu kan ba gǝri gwa, kǝ dǝ ar gǝr ra hoyi. ");
INSERT INTO plj_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Kǝkǝn ma ngǝlan ni kǝn ra domici kǝ shirǝm tu kan a yari in gwa. ");
INSERT INTO plj_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Sa ni gipǝni, kandatu ami ma a sa gip kǝn gwa. Am kin gon ra kan baa mani gǝri mimir nan gǝs gwa da'a, se ti ni tǝ sa den nas kin inabiyi. Untu ni kǝn ma kii mani gǝri mimir da'a se kǝn ni kǝ sa gipǝn gwa. ");
INSERT INTO plj_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","<<Ami ni'e kin inabiyi, kǝn ni'e ga am kini. Mbarǝm ni sa gipǝn kan ami gip tiwo, tii gǝri mimir na womti, domici bat namǝno kii mani pi argon da'a. ");
INSERT INTO plj_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Murgon tu kup kan ba sa gipǝn dawo, ti ni wule am kin tu kan wotl laka kan ba konka gwa, mbarǝm baa dom am kin ju, dǝ wika gip utu, dǝ keri ka. ");
INSERT INTO plj_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Kǝn ni kǝ sa gipǝn kan shirǝm gǝn ba sa gip kǝno, argon tu kup kǝ liriwo baa bi ine. ");
INSERT INTO plj_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ban baa zam ɗǝɗatǝni, kǝn ni kǝ pi dǝmi tu kan ba gode'e kǝn mir mǝn kulci karǝm ni, wule kin kan ba gǝri mbuni mimir gwa. ");
INSERT INTO plj_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","<<Kandatu Bǝba ba ndu'ǝmo, untu ni a ndu kǝn pa'e. Ra untuwo sa ni gip ndutǝn kan a gode in gwa. ");
INSERT INTO plj_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","A kop bar ju Ban yari gwa, kan a sa gip ndutǝn gǝsi. Untu ni esi, kǝn ni kǝ kop bar ju a yari ino, kii sa gip ndutǝn gǝni. ");
INSERT INTO plj_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","A yari in ni muntu kǝ dǝ ghol mbatl gǝn dǝm gip kǝne, kan kǝn ma dǝ ghol mbatl gin laa'i ra. ");
INSERT INTO plj_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Argon tu a wule kǝ pi gwa ni'e kǝ ndu ni ya'ǝni kandatu a ndu kǝn gwa. ");
INSERT INTO plj_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ndutǝn gon ra kan naar man dǝ mbarǝm bi ge mbatl gǝs den bi kǝ ga berǝm gǝs gwa da'a. ");
INSERT INTO plj_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Kǝn ga berǝm gǝn ni kǝn ni kǝ pi argon tu a wul kǝn'e kǝ pi gwa. ");
INSERT INTO plj_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Aa'i la kǝn bi'e mir mǝn pi mbap da'a, domici nye mǝn pi mbap mom argon tu babom gǝs ba pi gwa da'a. Ama a la kin bi'e ga berǝm gǝni, nan a yari in ko unu na unu kan a kulci kar Ban gwa. ");
INSERT INTO plj_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Kǝn ni kǝ zǝzarǝm da'a, ama ami ni a zǝzar kǝn kan a bi in mbap'e kǝ ri gǝri ni mimiri, wule kin kan ba gǝri mimiri, mimir ju kan baa pa dagwa. Ra untu ni Bǝba baa bi in argon tu kup kǝ liri gip sun gǝn gwa. ");
INSERT INTO plj_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Argon tu a wule kǝ pi gwa ni'e kǝ ndu ni ya'ǝni.>> ");
INSERT INTO plj_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","<<Mbarǝm kǝ atl ni nge ino, mom ni'e ami ni wu pare nge. ");
INSERT INTO plj_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kǝn kǝ atl ni faro, atl baa ndu mimir gǝsi. Ama nan kǝn kǝ atl ni da'a, a zǝzar kǝn ni gip mbarǝm kan den atl gwa. Muntu ni kem mbarǝm kǝ atl ba nge ine. ");
INSERT INTO plj_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Dami ni shirǝm tu a yari in gwa'e, <Zher ba man babom gǝs da'a.> Wi ni wu kumim dliwo, wii kumi in dli pa'e. Na wu kop ni kulci gǝno, wii kop kulci gin pa'e. ");
INSERT INTO plj_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Wii pi in ni untu den bi sun gǝni, domici wu mom muntu kan karǝm sur gwa da'a. ");
INSERT INTO plj_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Dǝ wule a sur shirǝm ni nan wur dawo, wii nǝra na warwat pitǝn da'a. Ama kǝkǝno, wu ra na argon tu wii yari den pi warwat pitǝn gǝzǝn gwa da'a. ");
INSERT INTO plj_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Murgon tu ngemo, tǝ nge ni Ban pa'e. ");
INSERT INTO plj_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","A pi mbap gip dlom gǝzǝn kan murgon taɓe pi da gwa. Dǝ wule a pi ni mbap ju far dawo, wii nǝra na warwat pitǝn da'a. Ama kǝkǝno wu shin bar kǝ nǝmi bi na am ju a pi gwa, kup na untu wu nge mi, wu nge Ban pa'e. ");
INSERT INTO plj_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ama ar pini untu kǝ dǝ laa'i argon tu kan ra na rǝshi gip Kulci gǝzǝn gwa'e, <Wu nge mi, ama gǝs kǝ nge gǝni ra da'a.> ");
INSERT INTO plj_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","<<Aa kari in bar sur na Mǝn Ne Mbarǝm Am kan ɗǝl sur kar Bǝba gwa. Ti ni'e Ruhu kǝ ge shirǝm kan ɗǝl sur kar Bǝba gwa, ti ni tii bi seda demǝni. ");
INSERT INTO plj_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Kǝn ma mǝn bi seda ni demǝni, rawo kǝn ra namǝn na pare pi bari.>> ");
INSERT INTO plj_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","<<A yari in ni bar ju den ba dǝ jili in nika da'a. ");
INSERT INTO plj_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Wii ɗǝli inka gip bom domtǝn kǝ mǝn Yahuda. Na ho bi, wokoci den ɗirtǝn nan murgon tu kup ri in ekawo, tii pǝn'e mbap kǝ Yam ni tǝ den pi. ");
INSERT INTO plj_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Wii pini untu domici wu tare wu mom Bǝba ko ami wi da'a. ");
INSERT INTO plj_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","A yari in ni muntu den'e wokociyi ni ɗiro kǝ dami ni'e faro a yari ine.>> A yari in ni bar ju na pare pi bar da'a domici a'i ra nan kǝne. ");
INSERT INTO plj_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","<<Ama kǝkǝno a ndara ni kar muntu kan karǝm sur gwa. Kup na untu gon gin ngen momi da'a tǝ wule, <Ako ni kǝ riwe?> ");
INSERT INTO plj_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Kǝ laa'i na dun mbatl wi nan a yari in bar ju gwa. ");
INSERT INTO plj_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ama ge shirǝm ni a yari in den ar mani in mbuntǝn dǝ a ndara. Ami ni a ndara dawo, Mǝn Ne Mbarǝmi Am baa sur kar kǝn da'a. Ama ami ni a ndarawo, aa kari in bar sur nan ti. ");
INSERT INTO plj_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ti ni tǝ mbirawo, tii kem dǝ mbarǝm kǝ atl kup mom den tǝp gǝzǝn ra kor da'a den pi warwat pitǝne, na den pitǝn dlat, na kandatu Yam baa hukunte mbarǝm gwa. ");
INSERT INTO plj_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Den shirǝm kǝ warwat pitǝno, domici mbarǝm ngǝsh wur demǝn da'a. ");
INSERT INTO plj_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Den shirǝm kǝ pitǝn dlato, domici a ndara kar Ban wi, las tu ki'i shimǝn da gwa. ");
INSERT INTO plj_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Kan den shirǝm kǝ hukuntetǝn ngapo, domici hukunte muntu kan den dandi kǝ atl kǝn gwa wi. ");
INSERT INTO plj_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","<<Ami ra na bar na womti kǝ yari ine, ama kii mani pǝni kǝkǝn da'a. ");
INSERT INTO plj_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ama wokoci tu ti Ruhu kǝ ge shirǝmi mbirawo, tii kop nan kǝn gip bar ju kup kǝ ge shirǝm ni gwa. Tii shirǝm kǝ gam gǝs da'a, ama argon tu tǝ kum gwa ni katl tii yari, kan tǝ yari in bar ju kan baa pi gwa. ");
INSERT INTO plj_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Tii ɗirǝm ɗǝɗatǝne, nan argon tu kan a yari in ni tii yari in gwa. ");
INSERT INTO plj_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Bar ju kup kan Bǝba nariwo gwan ni. Ar ni kem a wule Ruhuyi baa pǝn argon tu kan a yari gwa tǝ yari ine.>> ");
INSERT INTO plj_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","<<Gip nye wokoci njemo ki'i shimǝn da'a, kan den kaari njemo kǝ pa shimǝni.>> ");
INSERT INTO plj_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ar ni jen gip mir mǝn kulci kar tiyi wul ezǝn'e, <<Ununu tǝ pi nupi na wultǝn'e, <Gip nye wokoci njemo ki'i shimǝn da'a, kan den kaar kǝ wokoci njemo kii pa shimǝni> na es <Domici aa ndara kar Bǝba wu?> >> ");
INSERT INTO plj_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Wu ci cina na ngeni momi wu wule, <<Unun tǝ pi nupi na gip nye wokoci njem we? Mǝ mom unun tǝ yari da'a.>> ");
INSERT INTO plj_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu mom'e mir mǝn kulci kar ti den ndu'i wu ngen momi kar ti den muntu, ar ni tǝ wul wur'e, <<Kǝ ngen ni momi kar ya'ǝn den argon tu a pi nupi nan a wule, <Gip nye wokoci njemo ki'i shimǝn da'a, kan den kaar kǝ nye wokoci njemo kii pa shimǝna?> ");
INSERT INTO plj_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ge shirǝm ni a yari ine, kii kul kǝ pi dun mbatli, ama mbarǝm kǝ atlo ghol mbatl ni wii pi. Kii pi dun mbatli, ama dun mbatl gin baa palka ghol mbatli. ");
INSERT INTO plj_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Gǝr mǝtli ni den gǝriwo, tǝ kum dli hoyi domici wokoci gǝs piwi, ama ti ni tǝ ɗǝl amo tǝ mǝsǝnika na kumi dli tu tǝ kum gwa domici tǝra laa'i na ghol mbatl nan tǝ ɗiri pel mbarǝm den kaar atl wi gwa. ");
INSERT INTO plj_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Untu ni ar ra nan kǝne, kǝkǝn ni'e wokoci kǝ dun mbatl gi ni, ama aa shin kǝn ra kan kǝ pi ni ghol mbatli. Murgon baa mani kemi dǝ ghol mbatl gin paka da'a. ");
INSERT INTO plj_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Gas tawo ki'i liri argon karǝm da'a. Ge shirǝm ni a yari ine, Ban baa bi in argon tu kup kǝ liri gip sun gǝn gwa. ");
INSERT INTO plj_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Har kǝkǝn ma kǝ liri argon gip sun gǝn wi da'a. Liri ni, kii zami, kǝ dǝ ghol mbatl gin laa'i ra. ");
INSERT INTO plj_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","<<A shirǝm ni nan kǝn na kolɗa bi. Ama wokoci ra den ɗirtǝn kan aa'i shirǝm nan kǝn na kolɗa bi gwa da'a, ama aa yari in tetla tetla den Ban gwa. ");
INSERT INTO plj_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","<<Gas ta ni ɗiro, kii liri bar gip sun gǝni. A wul ni'e kii liri Bǝba na gam gini, ba'e ami ni aa liri den am gin da'a. ");
INSERT INTO plj_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Bǝbayi na gam gǝs ba ndu kǝne domici kǝ ndu'ǝmi kan kǝ nǝm wi den a ɗǝl ni sur kar Yami. ");
INSERT INTO plj_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","A ɗǝl ni sur kar Bǝbayi kan a sur atli. Kǝkǝno ari kǝ za'i atl kǝn wi, kan a pal gǝn to kar Bǝbayi ka.>> ");
INSERT INTO plj_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ar ni mir mǝn kulci kar tiyi wule, <<Kǝkǝno ki den shirǝm kandatu mii mom gwawi, ba'e gip kolɗa bi da'a. ");
INSERT INTO plj_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Kǝkǝno mǝ mom wi den'e kǝ mom bar kup. Kǝ mani bali mbarǝm kapǝn tǝ ngen momi kar ki. Muntu kem mǝ ngǝsh mi den kiwi den'e kar Yam ni kǝ ɗǝl suri.>> ");
INSERT INTO plj_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu nǝmi wur tǝ wule,<<Kǝkǝno kǝ ngǝsh kǝn den Yam wi? ");
INSERT INTO plj_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ama Wokoci den ɗirtǝne, ar mbirawi ma, nan kii gǝzanka, dǝ ko gonge gip kǝn ndara bom gǝs kǝ za'ǝm nan gǝn gwa. Kup na untu ami nangǝn ni da'a, domici Bǝba ra namǝni. ");
INSERT INTO plj_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","<<A yari in ni bar ju den gipǝno kǝ zam ni dǝmi zhǝlili ra. Den kaar bar atl kǝno, kii zam bar ju baa ghun kǝn gwa. Ama dǝm ni na ndǝri mbatli, a tare a tla gam kǝ warwat pitǝn kǝ den kaar atl wi.>> ");
INSERT INTO plj_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Den kaar kǝ yari muntuwo, ar ni Yesu tli gam yam kan tǝ shirǝm na Yam tǝ wule, <<Bǝba, wokoci piwi. Ɗǝɗa Nya gi, kǝ dǝ Nyayi ma tǝ ɗǝɗa ki ra. ");
INSERT INTO plj_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Domici ki ni kǝ bi ti iko den mbarǝm kup kǝ dǝ tǝ bi ge mbatl tu kan baa pa da'a kup munju kǝ bi ti gwa. ");
INSERT INTO plj_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ge mbatl kan baa pa da gwawo ar ni'e dǝ mbarǝm mom ki, ki kan ki ni'e Yam nan gi gwa, kǝ wu pa mom Yesu Almasihu muntu kan kǝ kar gwa. ");
INSERT INTO plj_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","A ɗiri'i ɗǝɗatǝn den kaar atl wi tǝp kǝ ba pa'i pi mbap tu kan kǝ bim a pi gwa. ");
INSERT INTO plj_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Kǝkǝno, Bǝba, ɗǝɗa'ǝm na ɗǝɗatǝn tu ami nari cina da'i kapǝn dǝ pi atl kundǝrǝndlip gwa.>> ");
INSERT INTO plj_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","<<A gode munju kan kǝ bim gip mbarǝm den kaar atl kǝ wu mom ki gwa wi. Terkawo ge ni, ama ki ni kǝ bim wuri, ar tu wu kop shirǝm giwi. ");
INSERT INTO plj_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Kǝkǝno wu mom wi den kup argon tu kǝ bimo kar kin ar ɗǝli. ");
INSERT INTO plj_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Rawo a bi wur ni shirǝm tu kan kǝ bim gwa kan wu nǝm wi. Wu mom wi den'e na ho bi kar ki ni a ɗǝl suri, kan wu ngǝsh wur den Yam wi den'e ki ni kǝ karǝmi. ");
INSERT INTO plj_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Wi ni a shirǝm nan ki den am gǝzǝni. A shirǝm ni nan ki den am kǝ nami mbarǝm kan den kaar atl gwa da'a, ama den bi kǝ munju kan kǝ bim gwa ni, domici ge ni. ");
INSERT INTO plj_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Argon tu kup ami ra nariwo ge ni, kan argon tu kup kan kira nariwo gwan ni. A zam ɗǝɗatǝn wi tǝp kar wuri. ");
INSERT INTO plj_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","A'i ri kǝ dǝmi den kaar atl da'a, ama wiwo wu'i ra den kaar atli, kan ami den totǝn kar ki. Bǝba, ki kan dlǝran ni kira gwa, gandǝl wurka na iko kǝ sun gi, sun tu kan kǝ bim gwa ituwi, kǝ dǝ wu dǝm nǝm kandatu mǝn ra nan ki nǝm gwa. ");
INSERT INTO plj_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nan ami ra nan wuro, a gandǝl wur kan a ne wurka bat na dǝ argon zam wuri tǝp kǝ ba sun tu kǝ bim gwa. Ko nǝm gǝzǝn jilka da'a bat na nǝm tu kan mǝshtǝn ni'e patǝn gǝs gwa kǝ dǝ rǝshi Shirǝm kǝ Yam laa'i ra.>> ");
INSERT INTO plj_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","<<Kǝkǝno kar ki ni a to, ama a yari ni bar ju nan a'i ra den kaar atl gwa, kǝ dǝ wu nǝra laa'i na ghol mbatl gǝn gip mbatl gǝzǝni. ");
INSERT INTO plj_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","A yari wur shirǝm giwi kan munju kan kǝ atl ni gwa ba nge wuri, domici wiwo kǝ atl ni wu'i da'a, kandatu ami ma kǝ atl ni da gwa. ");
INSERT INTO plj_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Shirǝm gǝn nan kiwo ba'e kǝ dǝ kǝ pǝn wur ka den kaar atl ni da'a, ama a lir ki ni kǝ dǝ kǝ gandǝl wurka ba dǝ mǝn ɗasi tu tu zam wur da'a. ");
INSERT INTO plj_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Wi kǝ atl ni da'a, kandatu ami ma kǝ atl ni da gwa. ");
INSERT INTO plj_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Pali wur dlat tǝp kǝ ba ge shirǝm gi, argon tu kǝ yari gwa ni'e ge shirǝmi. ");
INSERT INTO plj_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Kandatu kǝ karǝm sur gip atlo, untu ni a kar wur rin gip atl ka pa'e. ");
INSERT INTO plj_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Domici gǝzǝn ni a ne gam gǝn markǝme den bi gi, kǝ dǝ wu ma dǝ ne wurka markǝm gip ge shirǝm gi.>> ");
INSERT INTO plj_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","<<Munju ni katl a shirǝm nan ki den am gǝzǝn da'a. Ama a pa shirǝm ni nan ki den am kǝ munju kan ba ri kǝ ngǝshtǝn den ki tǝp kǝ ba kulci gǝzǝn gwa. ");
INSERT INTO plj_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Bǝba, a liri kǝ dǝ kup gǝzǝn dǝm nǝm. Kandatu ki ra gipǝn kan ami ra gip ki gwa ar ni a liri kǝ dǝ wu ma wu dǝm gip mi den dǝ mbarǝm kup ngǝsh wur den Yam den'e ki ni kǝ karǝmi. ");
INSERT INTO plj_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","A tare a bi wur ɗǝɗatǝn tu kan kǝ bim gwa wi, kǝ dǝ wu dǝm nǝm kandatu min ra nǝm nan ki gwa. ");
INSERT INTO plj_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Aa dǝm gip wuri ki ngapo kǝ dǝm gipǝni, kǝ dǝ wu dǝm ra nǝm hoyi, kǝ dǝ mbarǝm kup kan den kaar atl mom'e ki ni kǝ karǝmi, kan'e kǝ ndu wur kandatu kǝ ndu'ǝm gwa.>> ");
INSERT INTO plj_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","<<Bǝba, a ndu'e mbarǝm ju kan kǝ bimo wu nǝra las tu ami ra gwa. A ndu'e wu shin ɗǝɗatǝn gǝni, ɗǝɗatǝn tu kan kǝ bim gwa domici kǝ ndu'ǝm kapǝn ne gǝs kǝ pi atl kundǝrǝndlip.>> ");
INSERT INTO plj_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","<<Bǝba mǝn pitǝn dlat, kup na mbarǝm kǝ den kaar atl mom ki da'a, ama amo a mom ki, kan wu mom'e ki ni kǝ karǝm suri. ");
INSERT INTO plj_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","A kem wur wu mom kiwi aa ci cina na kemi gǝzǝn wu mom ki ra, kǝ dǝ ndutǝn tu kan kǝ pimo ar dǝm gip wuri, kan ami ma a dǝm gip wuri.>> ");
INSERT INTO plj_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Nan Yesu pa'i shirǝm na Yamo, ar ni Yesu na mir mǝn kulci kar ti ndara kan wu jikat dǝndi kǝ Kidǝron. Den kǝti kǝ ɓula'iwo dlyar kǝn zaitun gon ra, ar ni ti na mir mǝn kulci kar ti te gipi. ");
INSERT INTO plj_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yahuda, muntu kan bi tikayi mom lasi, domici Yesu na mir mǝn kulci kar ti ba kur mo barta. ");
INSERT INTO plj_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ar ni Yahuda nde womti mǝn bi utuyi cina, ga mǝn ɓuti bom kǝ Yami, kiri mǝn keri bar ju ɗiri Yami na mǝn Parise ba te gip dlyari. Wu ɗir na ga toci, pitǝla, dlo na bar kǝ dlanye. ");
INSERT INTO plj_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu na momi argon tu baa ndo nan tiwo, ar ni tǝ tli ter kar wur tǝ ngen momi tǝ wule, <<Wo ni kǝ ngeni?>> ");
INSERT INTO plj_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Wu nǝmi ti wu wule, <<Yesu kǝ Nazarat ni.>> Yesu wul wur'e, <<Ami ni.>> (Yahuda mǝn bi gǝsika ra tlor nan wuri.) ");
INSERT INTO plj_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Nan Yesu wul wur'e, <<Ami ni'e ti,>> ar ni wu dǝlka na kaar kan wu nda atlka. ");
INSERT INTO plj_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ar ni tǝ pa ngen momi kar wur tǝ wule, <<Wo ni kǝ ngeni?>> Kan wu wul ti'e, <<Yesu kǝ Nazarat ni.>> ");
INSERT INTO plj_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesu nǝmi wur tǝ wule, <<A yari in'e ami ni'e ti. Ami ni fa kǝn den ngeniwo, to za ni mbarǝm ju wu ndara.>> ");
INSERT INTO plj_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Muntu pi ni untu kǝ dǝ shirǝm tu kan Yesu yari gwa laa'i, den'e, <<A hol ko nǝm gip munju kan kǝ bim gwa da'a.>> ");
INSERT INTO plj_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ar ni Siman Bitǝrus, muntu kan ra na bar sǝɓǝr gwa, dli bar sǝɓǝr gǝs kan tǝ wotl kǝm kǝ zher kǝ bar mǝn keri bar ju ɗiri Yam gwa, tǝ pǝni ti kǝm kǝ shimli den gamka. (Sun kǝ zheri ni'e Malkus). ");
INSERT INTO plj_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesu wul Bitǝrus'e, <<Pali bar sǝɓǝr gika gip kumti gǝsi! Kǝ kum wule ar nǝm a tla gip gal tu kan Bǝba bim kǝ a tla gwa diya?>> ");
INSERT INTO plj_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ar ni domtǝn kǝ mǝn bi utu kǝ Roma na komanda gǝzǝn na ga mǝn ɓuti bom kǝ Yam ba nǝm Yesu. Wu ɓal tika. ");
INSERT INTO plj_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Kan wu pare ri gǝs cina dǝ Hanana, muntu kan bakon kǝ Kayafa, bar mǝn keri bar ju ɗiri Yam kǝ sheti ghoni ni gwa. ");
INSERT INTO plj_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayafa ni'e muntu wokoci gon pi shirǝm kiri kǝ mǝn Yahuda den ar mani mbuntǝn dǝ gon mǝsh den am kǝ mbarǝm kup gwa. ");
INSERT INTO plj_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Siman Bitǝrus na nye mǝn kulci kar Yesu gon den kopi Yesu kaari. Domici nye mǝn kulci kar Yesu tuwo bar mǝn keri bar ju ɗiri Yam gwa mom ti, ar ni tǝ kop Yesu tǝ te gip dǝbom bom kǝ bar mǝn keri bar ju ɗiri Yami gwa. ");
INSERT INTO plj_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ama Bitǝrus dlǝr te bǝdlabǝn kaarika. Nye mǝn kulci kar Yesu goniyi, muntu kan bar mǝn keri bar ju ɗiri Yami mom ti gwa, pal ter na kaari, tǝ shirǝm na nye gǝr tu kan den mbap ɓuti bǝdlabǝn bomi gwa, kan ba ter na Bitǝrus gipi. ");
INSERT INTO plj_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Nye gǝr tu kan den ɓuti bǝdlabǝni ngen momi kar Bitǝrus tǝ wule, <<Ki ma nǝm gip mir mǝn kulci kar mbarǝm tu ni diya?>> Bitǝrus bali ti tǝ wule, <<Ami ra gip wur da'a.>> ");
INSERT INTO plj_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","<<Wokoci iɗatǝn kǝ las ni, ar ni ga zher kǝ bar mǝn keri bar ju ɗiri Yami na ga mǝn ɓuti bom kǝ Yam dlǝr kǝ kumi gǝzhin mǝn utu kan wu hor gwa. Bitǝrus ma tǝra dlor nan wuri, tǝ den kumi utuyi.>> ");
INSERT INTO plj_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ar ni bar mǝn keri bar ju ɗiri Yam ngen momi kar Yesu den mir mǝn kulci kar ti na den kulci gǝsi. ");
INSERT INTO plj_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesu bali ti tǝ wule, <<A shirǝm na mbarǝm na ghundǝr argonka da'a, a pi ta kulci mbarǝm gip bom domtǝn kǝ mǝn Yahuda na gip bom kǝ Yami, las tu mǝn Yahuda kup ba kur dom wur gwa. A yari argon muri da'a. ");
INSERT INTO plj_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Unun kem kǝ ngen momi karǝm rawe? Ngen momi kar munju kan kumǝn gwa, ai wu mom argon tu a yari gwa.>> ");
INSERT INTO plj_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Nan Yesu yari muntuwo, ar ni gon gip kǝ cina gǝzǝn kan kosak na Yesu gwa ɓe ti amkayama. Tǝ wul Yesu'e, <<Untu ni kii bali shirǝm bar mǝn keri bar ju ɗiri Yama?>> ");
INSERT INTO plj_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu bali ti tǝ wule, <<O argon ra a yarika mǝgǝniwo, yari. Ama e ge shirǝm ni a yari fawo, unun kem kǝ ɓom we? ");
INSERT INTO plj_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ar ni Hanana kar bar na Yesu na ɓali dǝ Kayafa, bar mǝn keri bar ju ɗiri Yam gwa.>> ");
INSERT INTO plj_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Bitǝrus ra dlor den kumi utu, ar ni jen ngen momi wu wul ti'e, <<Ki ma nǝm gip mir mǝn kulci kar mbarǝm tu ni diya?>> Ar ni Bitǝrus nge, tǝ wule, <<Ami ra gip wur da'a.>> ");
INSERT INTO plj_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Nǝm gip zher kǝ bar mǝn keri bar ju ɗiri Yam, mǝn kǝ mbarǝm tu kan Bitǝrus wotli ti kǝmika shirǝm tǝ wule, <<A shin ki na Yesu gip dlyar kǝn zaituni diya?>> ");
INSERT INTO plj_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ar ni Bitǝrus pa wule untu ni da'a, gip untuwo ar ni tus kor la yare. ");
INSERT INTO plj_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kǝ bi cigǝni ar ni kiri kǝ mǝn Yahudayi ɗǝl na Yesu wu za bom kǝ Kayafa wu ndara nan ti bom kǝ gobna kǝ Roma. Ama ar ni wu nge tetǝn gip bomika bǝse wu li gam gǝzǝnka cina dǝ Yam kan ar hane wur ci fingal Jikat Bǝdlabǝni. ");
INSERT INTO plj_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ar ni Bilatus ɗǝl ter kaari tǝ ngen momi kar wur tǝ wule, <<Unu shirǝm ni kǝ ɗiri mbarǝm kǝn cina dene we?>> ");
INSERT INTO plj_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Wu bali ti'e, <<Dǝ wule mbarǝm kǝn pi wani bar gon dawo, o na mǝ ɗir ti cina da'i da'a.>> ");
INSERT INTO plj_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Bilatus wule, <<Pǝn tǝni na gam gin kǝ tloyi tǝni shirǝm den bi kulci gi ni.>> Ar ni mǝn Yahudayi wul ti'e, <<Mǝn ra na iko kǝ hukunte mbarǝm dǝ ri ti eka da'a.>> ");
INSERT INTO plj_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Muntu pi ni kǝ dǝ argon tu kan Yesu yari den kandatu tǝ ri kǝ mǝshtǝn gwa laa'i. ");
INSERT INTO plj_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Bilatus pal te gip bomka, kan tǝ la bi Yesu tǝ ngen momi kar ti tǝ wule, <<Ki ni'e gun kǝ mǝn Yahuda ya?>> ");
INSERT INTO plj_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu ngen momi kar ti tǝ wule, <<Muntuwo yari kǝ gam gi na ko jen ni yari'i untu demǝni?>> ");
INSERT INTO plj_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Bilatus bali ti tǝ wule, <<Ami mǝn Yahuda na? Mbarǝm gin na ga kiri mǝn keri bar ju ɗiri Yam ni ɗir ki cina da'ǝmi. Ununu kǝ piwe?>> ");
INSERT INTO plj_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesu wule, <<Dǝmi gǝn gunwo kǝ den kaar atl kǝn ni da'a. Na untuno, ga zher gǝn baa dlan wur wu hane kiri kǝ mǝn Yahudayi nǝmi gǝni. Ama dǝmi gun gǝno kǝ ɗe ni da'a.>> ");
INSERT INTO plj_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Bilatus wule, <<Rawo ki gun na?>> Yesu nǝmi ti tǝ wule, <<Kǝ yari dlat na wultǝn'e ami gun ni. Na ho bi, den untu ni gǝri mi, kan den untu ni a sur gip atl, kǝ dǝ a yari shirǝm den ge shirǝmi. Murgon tu kup kan den kopi kaar kǝ ge shirǝmi baa kumǝni.>> ");
INSERT INTO plj_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Bilatus ngen momi tǝ wule, <<Ununu ni'e ge shirǝmi?>> Ra untuwo ar ni tǝ ɗǝl te kaarika es kar mǝn Yahudayi tǝ wul wur'e, <<A zam argon tu kan baa nǝm mbarǝm kǝn dene gwa da'a. ");
INSERT INTO plj_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ama kandatu kǝ kur pi gwa ni kǝ dǝ pǝtli in nye mǝn bom moni nǝm wokoci kǝ Nyel Jikat Bǝdlabǝni. Kǝ ndu a pǝtli in Gun kǝ mǝn Yahuda ya?>> ");
INSERT INTO plj_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ar ni wu tli na la'i yar es wu wule, <<O'o, ba'e ti da'a! Bi mi Barabas!>> Barabaso mǝn tli bǝn mbatl ni. ");
INSERT INTO plj_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ar ni Bilatus pǝn Yesu kan tǝ kem ba ɓo ti. ");
INSERT INTO plj_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Mǝn bi utuyi pi lish kǝ gun ka ire kan wu kemi ti sur gami. Wu kemi ti tlyari lulur mǝn mal galura. ");
INSERT INTO plj_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Kan wu pi ta ritǝn kar ti wu den wultǝn'e, <<Dǝ shirmi ika, gun kǝ mǝn Yahuda!>> Kan wu ɓeɓɓe ti ankiyama. ");
INSERT INTO plj_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Bilatus pa ɗǝl ter kaari tǝ wul wur'e, <<Shin ni, a ɗǝli ti ni ter kar kǝn kǝ dǝ kǝ mom'e a zam ti na argon kǝ hukuntetǝn da'a.>> ");
INSERT INTO plj_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Nan Yesu ɗǝl ter kaari na lish kǝ gun ka ir gam dati na tlyari lulur mǝn mal galurawo, ar ni Bilatus wul wur'e, <<Mbarǝmin kǝni!>> ");
INSERT INTO plj_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Nan kiri mǝn keri bar ju ɗiri Yam na ga mǝn ɓuti bom kǝ Yam shin Yesuwo, ar ni wu tli yar yam wu wule, <<Ɓa tika den kini! Ɓa tika den kini!>> Ama Bilatus nǝmi wur tǝ wule, <<Kǝno pǝn tǝni na gam gin kǝ ɓa tinǝka den kini. Amiwo a zam argon kan tǝ pi kan ndari dǝ hukunte ti gwa da'a.>> ");
INSERT INTO plj_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ar ni mǝn Yahudayi nǝmi ti wu wule, <<Mǝn ra na kulci, kan den kulci gǝmiwo tǝ ndar mǝshtǝni, domici tǝ la bi gam gǝs'e Nya Yami.>> ");
INSERT INTO plj_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Nan Bilatus kum untuwo ar ni tǝ kum bǝrti ka ra naari, ");
INSERT INTO plj_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","kan tǝ pal te gip bomka tǝ ngen momi kar Yesu tǝ wule, <<Ako ni kǝ ɗǝl ɗiru?>> Ama Yesu nǝmi ti da'a. ");
INSERT INTO plj_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Bilatus wul ti'e, <<Kǝ nge shirǝm namǝn kaya, kǝ mom'e ami ra na iko a za ki kǝ ndara ko a ɓa kika den kin da'a ya?>> ");
INSERT INTO plj_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ar ni Yesu nǝmi ti tǝ wule, <<Rawo, iko tu kan ki ra na ri demǝno muntu kan Yam bi'i gwa ni katl. Warwat pitǝn kǝ muntu kan la'ǝm gip am da'i naar man ge.>> ");
INSERT INTO plj_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Den shirǝm tuwo, ar ni Bilatus ndu tǝ za Yesu tǝ ndara, ama mǝn Yahudayi pi ta la'i yar wu wule, <<Ki ni kǝ za mbarǝm tu tǝ ndarawo, ki berǝm kǝ Kaisar ni da'a. Murgon tu kup kan ba pǝn gam gǝs ti gunno, gapa ni tǝ pi na Kaisar.>> ");
INSERT INTO plj_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Nan Bilatus kum muntuwo, ar ni tǝ ɗǝli Yesu ter kaari kan tǝ dǝm den dandi tloyi shirǝm gǝs kan ba la ti bi'e Deɓe kǝ Tate (na bi kǝ Arameik ngapo Gabbata). ");
INSERT INTO plj_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Den pǝt kǝrkǝm bar kǝ nyel Jikat Bǝdlabǝn ni, pǝt to dlom gam wi. Bilatus wul mǝn Yahudayi'e, <<Gun gin tu.>> ");
INSERT INTO plj_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ama mǝn Yahudayi la yar wu wule, <<Ndara nan ti! Ndara nan ti! Ɓa tika den kini!>> Bilatus ngen momi kar wur tǝ wule, <<A ɓa gun ginka den kina?>> Ar ni kiri mǝn keri bar ju ɗiri Yami nǝmi ti wu wule, <<Mǝn ra na gun gon bom na Kaisar da'a.>> ");
INSERT INTO plj_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ar ni Bilatus bi wur Yesu kǝ wu ɓa tika den kini. ");
INSERT INTO plj_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ar ni mǝn bi utuyi ndara na Yesu. Tǝ pǝn kin kan baa ɓa tika dene gwa tǝ ɗǝl gip bǝni, tǝ ndara las kǝ Kula Gami (na bi kǝ Arameik ar ni'e Golgota). ");
INSERT INTO plj_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Lasi ni wu ɓa tika den kini, kan na jen rop, nǝm den am shimli gon ngapo den am yali kan Yesu te dlom da wurka. ");
INSERT INTO plj_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Bilatus rǝsh argon kan tǝ ɓa to gami da tika. Argon tu rǝsh gwa ni'e, YESU KƏ NAZARAT, GUN KƏ MƏN YAHUDA. ");
INSERT INTO plj_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Mǝn Yahuda na womti zhit argon tu rǝsh gwa, domici las tu ɓa Yesuka den kino kosak na gip bǝn ni ar ra, kan argon tu rǝshiwo, rǝsh ni gip bi kǝ Arameik, Latin na Hellas. ");
INSERT INTO plj_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Kan kiri mǝn keri bar ju ɗiri Yam ba wul Bilatus'e, <<Ba kǝ rǝsh'e <Gun kǝ mǝn Yahuda> da'a, ama rǝsh'e <Mbarǝm kǝn wule ti gun kǝ mǝn Yahuda ni.> >> ");
INSERT INTO plj_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Bilatus nǝmi wur tǝ wule, <<Argon tu a rǝsho, a rǝsh wi.>> ");
INSERT INTO plj_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Nan mǝn bi utuyi ɓa Yesuka den kino, ar ni wu yem tutul dli gǝs kan wu tatl bomi wupse, ko gonge gǝzǝn na nǝm, kan wu za nye lulur kǝ gipi untu. Nye luluriwo dlǝmi ni dlǝm da'a, zǝluw ni ar ra argon tu nǝm den yari har ba su atl gwa. ");
INSERT INTO plj_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Wu wul ezǝn'e, <<Ba mǝ tlyati nika da'a. Mǝ la ni guri'a dene mǝ shin ni wo ni baa zami.>> Muntu pini kǝ dǝ laa'i argon tu kan ra na rǝshi gip shirǝm kǝ Yam gwa'e, <<Kan wu tlyati lulur gǝn gip dlom gǝzǝni, kan wu la guri'a den lulur gǝn kǝ gipi.>> Argon tu mǝn bi utuyi pi gwa utu. ");
INSERT INTO plj_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Gip munju dlor kosak na kin tu ɓa Yesuka denewo nas ra, na nye mǝn gǝpi kǝ nase, na Maryamu nagǝr kǝ Kǝlopas, kan na Maryamu kǝ Magdala. ");
INSERT INTO plj_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Nan Yesu shin nas lasi, kan na nye mǝn kulci kar ti kan tǝ ndu gwa dlor kosako, ar ni tǝ wul nas'e, <<Nana, nya gin tu!>> ");
INSERT INTO plj_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Kan tǝ wul nye mǝn kulci kar tiyi'e, <<Nana gin tu.>> Argon tu kan pǝn den gas tuwo ar ni nye mǝn kopi gǝsi pǝn nana kǝ Yesu gip bom gǝs tǝ dǝm nan ti. ");
INSERT INTO plj_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Den kaar kǝ untuwo, nan Yesu mom'e bar kup piwi, kǝ dǝ argon tu kan ra na rǝshi gip shirǝm kǝ Yam laa'iwo, ar ni tǝ wule, <<A kum guzum male.>> ");
INSERT INTO plj_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Zurum gon ra lasi laa'i na mati mal kin inabi. Ar ni wu gi soso gip mati mal kin inabiyi, wu kem sosoyi den dlo kan wu ta'i Yesu toka wu ne ti den bi. ");
INSERT INTO plj_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Nan Yesu ɓom mati mal kin inabiyiwo, ar ni tǝ wule, <<Ar pa wi.>> Na yari untuwo ar ni tǝ la gam atl kan tǝ kotl mbatlka. ");
INSERT INTO plj_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Den pǝt Kǝrkǝm bar ni, kan bar ni tlo gwa'e pǝt Shukutǝni. Domici wu mǝn Yahudayi ba ndu wu za dli den kin den pǝt Shukutǝn da'a, kan wu liri Bilatus den dǝ cen asǝm gǝzǝnka, kan dǝ shu dli gǝzǝnka sur den rati kini. ");
INSERT INTO plj_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ar ni ga mǝn bi utuyi ba ɗir kar mbarǝm ju kan ɓa wurka den kin na Yesu gwa, kan wu cen asǝm kǝ mbarǝm kǝ nǝmika na kǝ mǝn nǝmi. ");
INSERT INTO plj_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ama nan wu ɗir den Yesu kan wu zam tǝ tare tǝ mǝshkawo, ar ni wu'i cen asǝm gǝska da'a. ");
INSERT INTO plj_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Nan wu pi untuwo, ar ni nǝm gip mǝn bi utuyi tul markǝm ngetl kǝ Yesu na geshe, se car bǝran na mal ba nǝm shottǝni. ");
INSERT INTO plj_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Mbarǝm tu kan shin argon tu kan pi gwa ni yari muntu, kan argon tu tǝ yariwo untu ni ar ra. Tǝ mom'e ge shirǝm ni tǝ yari, kan tǝ yari ni kǝ dǝ kǝn ma kǝ ngǝsh kǝn ni den Yesu. ");
INSERT INTO plj_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Bar ju pi ni untu kǝ dǝ shirǝm kǝ Yam laa'i, muntu kan wule, <<Baa cen ko nǝm gip gul gǝs da'a.>> ");
INSERT INTO plj_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Shirǝm kǝ Yam pa yari las gon'e, <<Wii shin muntu kan wu tul ti gwa.>> ");
INSERT INTO plj_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Den kaariwo, Isubu kǝ Arimatiya ngen den dǝ Bilatus bi ti dli kǝ Yesu. Isubu kǝ Arimatiyayiwo, nye mǝn kopi Yesu ni, ama muri ni tǝ pi domici tǝ bǝrti mǝn Yahuda. Bilatus bi ti bi kǝ pi untu, kan tǝ ɗir pǝn dli kǝ Yesu tǝ ndara nari. ");
INSERT INTO plj_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodimu, mbarǝm tu kan far ri kar Yesu gip gas gwa ri na Isubu. Nikodimu ɗir na mir mur na alos kan kurtli gwa, bar kǝ kilo hauya nǝm na kutl. ");
INSERT INTO plj_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Mbarǝm rop ju ba pǝn dli kǝ Yesu, wu bǝrke ti mir mǝn tǝmi kasǝri, kan wu ghumka na tutul ghumi mǝshi mbarǝme. Muntuwo den kandatu mǝn Yahuda ba kap mǝshi mbarǝm gwa ni. ");
INSERT INTO plj_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Las tu kan ɓa Yesu den kino dlyar gon ra lasi, gip dlyari ngapo pel bori gambǝci gon ra, muntu kan kap murgon gipi wi dagwa. ");
INSERT INTO plj_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Domici pǝt Kǝrkǝm bar kǝ mǝn Yahuda ni kan gambǝci'i ra kosak nan wuro, ar ni wu kap dli kǝ Yesuka lasi. ");
INSERT INTO plj_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Den pǝt Lahadi kǝ cigǝni, tun bar'i pǝlǝu, ar ni Maryamu nye mǝn bǝn kǝ Magdala ri kar gambǝci kǝ Yesu kan tǝ shin kutǝl tat tu kan le bi gambǝci'ika nari gwawi. ");
INSERT INTO plj_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ar ni tǝ ɗir na kǝtǝr kar Siman Bitǝrus na nye mǝn kulci kar Yesu nǝmi, muntu kan Yesu ba ndu gwa, tǝ wul wur'e, <<Wu pǝn Babomka gip gambǝci'i wi, ngapo mǝ mom las tu wu ne ti gwa da'a!>> ");
INSERT INTO plj_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ar ni Bitǝrus na nye mǝn kulci kar Yesuyi mǝn nǝmi ri na kǝtǝre kǝ ba gambǝci'i. ");
INSERT INTO plj_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Kup gǝzǝn ropi den kǝtǝre, ama nye mǝn kulci kar Yesu nǝmi wuce Bitǝrus, kan tǝ pare mbu'i bar gambǝci'i. ");
INSERT INTO plj_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Tǝ ngus tǝ la ger su gipika kan tǝ shin tutul ghumi mǝshi mbarǝmi lasi markǝme, ama tǝ su gipi da'a. ");
INSERT INTO plj_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Den kaariwo kan Bitǝrus ba mbubari, tǝ su gip gambǝci'i. Tǝ shin tutul ghumi mǝshi mbarǝmi lasi markǝme. ");
INSERT INTO plj_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Tǝ pa shin tutul tu kan ɓali Yesu ɗir gam gwa na kucimi las nǝm, markǝmi na ghol mayaniyi. ");
INSERT INTO plj_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Den kaariwo ar ni nye mǝn kulci kar Yesu mǝn nǝmi, muntu kan pare mbu'i bar bi gambǝci'i gwa, tǝ ma tǝ su gipi. Tǝ shin kan tǝ ngǝsh ti den Yesu. ");
INSERT INTO plj_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Ama kup na untu wu mani momi argon tu shirǝm kǝ Yam yari den ar nǝm dǝ Yesu tli gip mǝshi mbarǝm da'a.) ");
INSERT INTO plj_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ar ni mir mǝn kulci kar Yesuyi pal gǝzǝn rǝn bomka. ");
INSERT INTO plj_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ama Maryamu dlǝr bi gambǝci'i tǝ den kulu. Ti gip kuluwo ar ni tǝ ngus kan tǝ la ger su gip gambǝci'ika ");
INSERT INTO plj_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ar ni tǝ shin mir mǝn kartǝn kǝ Yam rop na ghol tutul dli, njon las tu far dli kǝ Yesu ra gwa, nǝm kǝ ba gami kan nǝm tǝp kar asǝme. ");
INSERT INTO plj_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ar ni mir mǝn kartǝn kǝ Yami ngen momi kar ti wu wule, <<Nagǝre, unun kem ki den kulu we?>> Ar ni tǝ wul wur'e, <<Wu pǝn Babom gǝn kawi, kan a mom las tu wu ne ti gwa da'a.>> ");
INSERT INTO plj_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Tǝ pa'i yari muntuwo ar ni tǝ bal ti, se tǝ shin Yesu dlor, ama tǝ mani momi'e Yesu ni da'a. ");
INSERT INTO plj_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ar ni Yesu ngen momi tǝ wul ti'e, <<Nagǝre, unun kem kǝ den kulu we? Wo ni kǝ den ngeni we?>> Maryamu pǝn'e ti ni'e mǝn kǝni, ar ni tǝ wul ti'e, <<Bar mbarǝme, ki ni fa kǝ pǝn tikawo, yarim las tu kǝ ne ti gwa, aa ri pǝn ti.>> ");
INSERT INTO plj_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu la ti bi tǝ wul ti'e, <<Maryamu!>> Ar ni tǝ bal ti rǝn den tika kan tǝ shirǝm gip bi kǝ mǝn Yahuda tǝ wule, <<Rabboni!>> (Ba mǝn kulci ituwi). ");
INSERT INTO plj_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu wul ti'e, <<Ba kǝ nǝm dli gǝn da'a, domici a pal to kar Banka wu da'a. Ama ri yari mir ɓyar'e, a ri kǝ paltǝn kar Ban kan Be gini, kar Yam gǝni kan Yam gini.>> ");
INSERT INTO plj_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ar ni Maryamu nye mǝn bǝn kǝ Magdalayi ri kar mir mǝn kulci kar Yesuyi na zo shirǝm kǝn'e, <<A shin Babom wi!>> Kan tǝ yari wur argon tu Yesu yari gwa. ");
INSERT INTO plj_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Gas Lahadi kǝ sit nan mir mǝn kulci kar Yesu ra kǝba lasi nǝm, na bǝdlabǝn kushi gǝzǝn kup na le den bǝrti kǝ mǝn Yahudawo, ar ni Yesu ɗir kan tǝ dlǝr gip dlom gǝzǝn tǝ wule, <<Dǝ dǝmi zhǝlili kop kǝne!>> ");
INSERT INTO plj_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Den kaar kǝ yari muntuwo ar ni tǝ gode wur am gǝs na markǝm tu gǝsi. Mir mǝn kopi gǝsi pi ghol mbatl naar na shini Babomi. ");
INSERT INTO plj_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesu pa wul wur'e, <<Nǝm ni dǝmi zhǝlili! Kandatu Bǝba karǝm gwa untu ni a kar kǝn pa'e.>> ");
INSERT INTO plj_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Nan tǝ yari untuwo ar ni tǝ hori wur kuskǝnu gǝsi kan tǝ wul wur'e, <<Nǝm ni Ruhu kǝ Yami. ");
INSERT INTO plj_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Murgon tu kup kǝ gaparte ti warwat pitǝn gǝs kawo, gaparte ti ituwi, kan murgon tu kup kǝ gaparte tika dawo, gaparte ti da'a ituwi.>> ");
INSERT INTO plj_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Rawo, Toma, nǝm gip mir mǝn kulci kutl cet ropi (kan ba la ti bi'e Nye Ngumci) ra gip wur da'a nan Yesu ri kar wur gwa. ");
INSERT INTO plj_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ar ni nami mir mǝn kulciyi yari ti'e, <<Mǝ shin Babom wi.>> Ama tǝ wul wur'e, <<Ami ni a shin shu kusa ju den am gǝsi, a kem yasa gǝn gip shu kusayi, kan a ne am gǝn den markǝm tu gǝs dawo, aa nǝm da'a!>> ");
INSERT INTO plj_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Muri wusupse den kaar kǝ muntuwo, mir mǝn kulci kar Yesuyi ra gip bom esi, kan Toma ra nan wuri. Kup na bǝdlabǝn kushiyi kup ra na le, ama Yesu ɗir kan tǝ dlǝr gip dlom gǝzǝn tǝ wule, <<Nǝm ni dǝmi zhǝlili!>> ");
INSERT INTO plj_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ar ni tǝ wul Toma'e, <<Kem yasa gi ɗe, shin am gǝni. Ta am gi kǝ kem gip markǝm tu gǝni. Za damtǝn kǝ ngǝsh ki demǝni.>> ");
INSERT INTO plj_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Toma nǝmi Yesu tǝ wule, <<Babom gǝni, na Yam gǝni!>> ");
INSERT INTO plj_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Kan Yesu ba wul ti'e, <<Nan kǝ shimǝno, kǝ ngǝsh ki demǝn wi. Mǝn albarka ni'e munju kan shimǝn da'a ama kup na untu wu ngǝsh wur demǝn gwa.>> ");
INSERT INTO plj_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu pi halama bar kǝ nǝmi bi na am jen na womti den ger kǝ mir mǝn kulci kar ti, munju kan rǝsh gip tǝlankur kǝn da gwa. ");
INSERT INTO plj_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ama rǝsh ni mǝnjǝn kǝ dǝ kǝ ngǝsh kǝn ni den Yesu ni'e Almasihu, Nya Yami. Kan tǝp kǝ ba ngǝshtǝn den tiwo kǝ zam ni ge mbatl gip sun gǝsi. ");
INSERT INTO plj_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Den kaar kǝ untuwo, ar ni Yesu pa ɗǝl kar mir mǝn kulci kar ti bi bar ɓula kǝ Tiberiya. Kandatu ar pi gwa ikǝni. ");
INSERT INTO plj_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Siman Bitǝrus, Toma (kan ba la ti bi'e Nye ngumci gwa), Natanayilu mbarǝm kǝ Kana gip atl kǝ Galili, mimir kǝ Zabadi, na mir mǝn kulci kar Yesu jen rop ra lasi nan wuri. ");
INSERT INTO plj_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Siman Bitǝrus wul wur'e, <<A ri kǝ nǝmi kose.>> Ar ni nami mir mǝn kulci kar Yesuyi wule, <<Mǝn ma mii ri nan ki.>> Ar ni wu ndara kan wu to gip kungǝlǝn jikat male, ama gip gastawo wu nǝm argon da'a. ");
INSERT INTO plj_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Kǝ bi cigǝniwo ar ni Yesu dlǝr den bishidi bar ɓula'i, ama mir mǝn kulci kar tiyi mani momi'e Yesu ni da'a. ");
INSERT INTO plj_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ar ni tǝ la wur bi tǝ wule, <<Mir moni, kǝn ra na kosa?>> Kan wu nǝmi ti wu wule, <<O'o.>> ");
INSERT INTO plj_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yesu wul wur'e, <<La ni bar kǝ nǝmi kos gin den am shimli kǝ kungǝlǝn jikat mali, kii nǝm jeni.>> Nan wu piwo, kan wu nǝm kos na womti har wu'i mbu dǝli bar kǝ nǝmi kosi tor gip kungǝlǝn jikat mali da'a. ");
INSERT INTO plj_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ar ni nye mǝn kulci tu Yesu ba ndu gwa wul Bitǝrus'e, <<Babom ni ca!>> Nan Siman Bitǝrus kum'e Babomno ar ni tǝ pǝn tutul dli gǝs tǝ la'i, (domici tǝ tuska wi den bi mbapi) kan tǝ nda su gip malika. ");
INSERT INTO plj_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Nami mir mǝn kulci kar ti gip kungǝlǝnyi ɗiri, kan wu dǝl bar kǝ nǝmi kosi tor laa'i na kose. Rawo, wu dlyam na gam bishidi bar ɓula'i da'a, bar kǝ desi asǝm hauya kutl cet nantam (300) ni. ");
INSERT INTO plj_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Nan wu ɗǝl tor gip maliwo, ar ni wu shin gǝzhin mǝn utu gon lasi, na kos dene, kan na bǝredi jeni. ");
INSERT INTO plj_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesu wul wur'e, <<Ɗiri ni jen gip kos ju kan kǝ'i nǝm gwa.>> ");
INSERT INTO plj_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ar ni Siman Bitǝrus to gip kungǝlǝn jikat mali kan tǝ dǝl bar kǝ nǝmi kosi tor den bishidi. Laa'i na kiri kos gudǝli hauya nyingi na kutl cet myakan (153), ama kup na womtitǝn gǝzǝn juwo bar kǝ nǝmi kosi tlyatka da'a. ");
INSERT INTO plj_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu wul wur'e, <<Ɗir karye ni.>> Gon ra da'a gip mir mǝn kulci kar Yesuyi kan kǝrce kǝ wuli gǝs'e, <<Ki wo ni we?>> Nan wu mom'e Babom ni gwa. ");
INSERT INTO plj_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ar ni Yesu ɗir kan tǝ pǝn bǝredi tǝ bi wuri, kan tǝ pa pǝn kosi tǝ bi wuri. ");
INSERT INTO plj_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Muntu ni'e ɗǝltǝn kǝ Yesu kǝ myakan kar mir mǝn kulci kar ti den kaar kǝ tlitǝn gǝs gip mǝshi mbarǝme. ");
INSERT INTO plj_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Nan wu pa'i ci baro, ar ni Yesu wul Siman Bitǝrus'e, <<Siman nya Yohana, na ho bi kǝ ndu'ǝm man munju ya?>> Siman nǝmi ti tǝ wule, <<Aan, Babomi, kǝ mom'e a ndu ki.>> Yesu wul ti'e, <<Bi tǝm gǝn fingali.>> ");
INSERT INTO plj_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yesu pa ngen momi kar ti kǝ ropi tǝ wule, <<Siman nya Yohana, na ho bi kǝ ndu'ǝma?>> Siman nǝmi ti tǝ wule, <<Aan, Babomi, kǝ mom'e a ndu ki.>> Yesu wul ti'e, <<Ne ger den tǝm gǝni.>> ");
INSERT INTO plj_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yesu pa ngen momi kar ti kǝ bisi myakani, tǝ wule, <<Siman nya Yohana, kǝ ndu'ǝma?>> Ar ni ar ghun Bitǝrus domici bisi myakan ituwi tǝ ngen momi kar ti na wultǝn'e, <<Kǝ ndu'ǝma?>> Ar ni tǝ wul ti'e, <<Babomi, kǝ mom ko unu, kǝ mom'e a ndu ki.>> Yesu wul ti'e, <<Bi tǝm gǝn fingali. ");
INSERT INTO plj_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ge shirǝm ni a yari'i, nan kǝ'i ɗaliwo kǝ kem tutul dli gi kǝ ndara las tu kǝ ndu gwa, ama wokoci tu kǝ korsiwo kii ta am gi, kan dǝ murgon kemi'i tutul dli kan tǝ ri'i las tu kan kǝ ndu ritǝn da gwa.>> ");
INSERT INTO plj_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesu yari ni untu kǝ dǝ tǝ gode wur kandatu Bitǝrus ba ri kǝ mǝshtǝn kan baa ɗǝɗa Yam gwa. Ar ni Yesu wul ti'e, <<Kopǝni!>> ");
INSERT INTO plj_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Nan Bitǝrus bal tiwo, ar ni tǝ shin nye mǝn kulci tu kan Yesu ba ndu ti gwa ra den kopi gǝzǝni. (Ti ni'e muntu kan dǝm kosak na Yesu wokoci ci fingal kǝ Nyel Jikat Bǝdlabǝn gwa. Ti ni'e muntu kan ngen momi kar Yesu gwa tǝ wule, <<Babomi, wo ni ba ri kǝ bi gi kayi?>>) ");
INSERT INTO plj_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Nan Bitǝrus shin tiwo, ar ni tǝ ngen momi kar Yesu tǝ wule, <<Babomi, im nu baa ndo na mbarǝm tuwe?>> ");
INSERT INTO plj_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu nǝmi ti tǝ wule, <<Ami ni a ndu tǝ dǝm ra ar ri paltǝn gǝn suro, unun ghun kiwe? Ki de kopǝni!>> ");
INSERT INTO plj_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Yari untu kem shirǝm tu nga las gip mir mǝn kopi den'e nye mǝn kulci kar Yesu tu baa mǝsh da'a. Ama rawo ba'e Yesu wul ni'e tii mǝsh da'i da'a, ama tǝ wul ni'e, <<Ami ni a ndu tǝ dǝm ra ar ri paltǝn gǝn suro, unun ghun kiwe.>> ");
INSERT INTO plj_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ti ni'e nye mǝn kulci kar Yesu tu kan bi seda den bar ju, kan tǝ pa rǝsh gwa. Mǝ mom'e seda gǝs den Yesuwo untun ar ra. ");
INSERT INTO plj_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Bar ra na womti kan Yesu pi gwa. Dǝ wule baa rǝsh ni kupo, a shin atl kundǝrǝndlip baa zam ba ne tǝlankur ju kan baa rǝsh gwa da'a.");
INSERT INTO plj_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Mǝn nartǝn Tiyopilus, gip tǝlankur gǝn kǝ pari kan a rǝsho, a rǝsh ni den kup bar ju Yesu pare pi na kulci mbarǝm gwa, ");
INSERT INTO plj_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ar ba ri den pǝt tu kan pǝn tǝka to yamka gwa. Kapǝn tǝ ndarawo, tǝ yari mir mǝn kartǝn gǝs kan tǝ zǝzari bar ju wi pi nan Ruhu kǝ Yam ba ne wur amra wu pi gwa. ");
INSERT INTO plj_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Den kaar kǝ kumi dli na mǝshtǝn gǝso, tǝ ɗǝl kar mir mǝn kartǝn gǝs ju den tǝp na womti nan ba mom'e tǝ ra na rai gwa. Tǝ ɗǝl kar wur gip muri hauya rop kan tǝ shirǝm nan wur den dǝmi kǝ Yam gun gip mbatl kǝ mbarǝme. ");
INSERT INTO plj_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Den pǝti gon nan tǝ ɗǝl kar wur tǝ den ci fingal nan wuro, tǝ wul wur'e, <<Ba kǝ za ni Urushalimawu da'a, ama ɓutni dǝ Bǝba la'i in na Ruhu kǝ Yam kan tǝ wule ti bi ine, muntu kǝ kum a shirǝm dene gwa. ");
INSERT INTO plj_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yohana pini mbarǝm batisma na male, ama gip muri njem cina ɗewo, baa pi in batisma na Ruhu kǝ Yami.>> ");
INSERT INTO plj_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Nan wu mo gam kǝ ba lasi nǝmo, arni wu ngen momi kar ti'e, <<Babomi, kǝkǝn ni kǝ ri kǝ pali Isra'ila dǝmi na gun kǝ gam gǝsa?>> ");
INSERT INTO plj_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yesu wul wur'e, <<Momi pǝt na wokociwo gegin ni da'a, domici Bǝba ni gip mani pi bar gǝs ne gam gǝs momi muntu. ");
INSERT INTO plj_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ama ki zam mani pi bari, Ruhu kǝ Yam ni sur den kǝn wu gwa. Ki dǝm mǝn yari bar ju kǝ shin demǝn gip bǝn Urushalima, na atl kǝ mǝn Yahuda kup na Samariya, an ri gip atl kundǝrǝndlip.>> ");
INSERT INTO plj_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Nan tǝ pa'i yari muntuwo, kan Yam ba pǝn tika to gip dun yamka den ger gǝzǝni wu den shini ar bari wu'i mani shini gǝs da'a. ");
INSERT INTO plj_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Wu gip zhiti ndekeke to yamka nan Yesu den totǝno, arni curut mbarǝm rop jen ni jǝn dlor markǝm dawur na ghol tutul dli. ");
INSERT INTO plj_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Wu wule, <<Mǝn Galili, unun kem kǝ dǝm den wi ger to yamkawu? Yesu tu kan pǝn tǝka kar kǝn ba te ti yamkawo, baa pal den nǝm tǝp tu kǝ shin pǝn tǝka to yamka gwa.>> ");
INSERT INTO plj_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Kano mir mǝn kartǝni ba za Tlǝndǝr mǝn kin Zaitun wu pal su Urushalimaka, ɓomi asǝm bar kǝ tatli dlom kǝ mil nǝm. ");
INSERT INTO plj_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Nan wu mbubar gip bǝn kǝ Urushalimawo, arni wu to gǝzǝn gip ɓiti kushi kǝ to yamika las tu kan wu dǝm gwa. Munju ra lasi gwani'e Bitǝrus, Yohana, Yakubu, Andǝrawus, Filibus na Toma, Bartilamawus na Matta. Yakubu nya Halfa, Simon mǝn ghuve den bǝn gǝsi, na Yahuda nya Yakubu. ");
INSERT INTO plj_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Kup gǝzǝn ci cina na me gam na shirǝm na Yam na mbatl nǝm, na mǝtliyi, na Maryamu mǝn gǝri kǝ Yesu na mir mǝn gǝpi gǝsi. ");
INSERT INTO plj_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Gip muri jawo, Bitǝrus tlyam dlor gip mir ɓyar mǝn kopi Yesu (womtitǝn gǝzǝn ri hauya mukka) ");
INSERT INTO plj_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","kan tǝ wule, <<Mir ɓyari, ar nǝm dǝ Tǝlankur laa'i den shirǝm tu Ruhu kǝ Yam yari terka bi dǝ gun Dauda den Yahuda, muntu kan pii tǝp munju nǝm Yesu gwa. ");
INSERT INTO plj_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Tǝ Yahuda ma nǝm gip mi ni, kan ra na am gip mbap gǝmi kǝn gwa.>> ");
INSERT INTO plj_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Mbarǝm tu Yahuda wur ni las na wurpi tu tǝ zam den ɗasi tu gǝs gwa, las tu tǝ nda sur atl na dlom gam, tu gǝs ba mbutlka, kan wot gǝs kup ba ɗǝlka kari. ");
INSERT INTO plj_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Mbarǝm kǝ Urushalima kup kum bar tu, kan wu labi lasi na bi gǝzǝn'e Akeldama, <<Las tu kan shot bǝran gwa ituwi.>>) ");
INSERT INTO plj_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Bitǝrus ci cina tǝ wule, <<Untuni anra na rǝshi gip tǝlankur Zabura'e, <Naa dǝ bom gǝs sa koni, ba dǝ zam murgon kan ba dǝm gipi gwa da'a.> Eso, <Naa dǝ gon nǝm mbap gǝsi.> ");
INSERT INTO plj_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","<<Untuno, ar nǝm dǝ zǝzar nǝm gip mbarǝm ju nan ra nan mi kup wokoci tu mǝn den ritǝn na Babom gǝmi Yesu, ");
INSERT INTO plj_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","pare den batisma gǝs kan Yohana pi ti, an ri gas tu pǝn tǝka kar mi gwa. Nǝm gip munju zǝzariwo, ti dǝm nan mi gip yari mbarǝm kandatu mǝ shin Yesu tli gip mǝshi mbarǝm gwa.>> ");
INSERT INTO plj_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Arni wu bi sun kǝ mbarǝm rop: Isubu mǝn sun Barsabas (kan mom ti na Yustus gwa) na Matiyas. ");
INSERT INTO plj_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Kano wu shirǝm na Yam wu wule, <<Babomi, kini kǝ mom mbatl kǝ mbarǝm kup. Nune mi gonge ni kǝ zǝzari gip rop ju ");
INSERT INTO plj_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","kan baa pǝn las mbap kǝ mir mǝn kartǝn gi kǝn, muntu Yahuda zaka tǝ ndara las gǝs gwa.>> ");
INSERT INTO plj_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Kan wu zǝzar ti tǝp kǝ ba la'i guri'a, arni ar nda den Matiyas. Arni wu la ti gip wur tǝ dǝm nye mǝn kartǝn nǝm na kutl cet nǝmi. ");
INSERT INTO plj_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Nan gas nyel kan ba wul ti'e Pentikos ɗiro, arni kup mǝn kopi mo gam kǝba lasi nǝm. ");
INSERT INTO plj_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Karap, se ba kum ghughughu sur yam wule hortǝn kǝ bar itǝri, kan arba laa'i kup bomi ka las tu wu dǝm gwa. ");
INSERT INTO plj_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Arni wu shin argon wule bǝlǝm utu ɗǝl ba gǝzan den gam kǝ kogonge gip wuri. ");
INSERT INTO plj_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Kan ba laa'i kup gǝzǝn na Ruhu kǝ Yam kan wu nǝm shirǝm na bi jeni, kandatu Ruhu bi wur mani pi gwa. ");
INSERT INTO plj_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Gip muri jawo mǝn Yahuda mǝn kopi kulci kǝ Musa asǝm na gǝs nan ɗǝl ɗir gip atl kundǝrǝndlip ra su Urushalimaka. ");
INSERT INTO plj_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Nan wu kum bar larǝmtǝn tuwo, wu dom wur kǝba lasi nǝm ghiru-ghiru, domici kogonge gǝzǝn kum wur den shirǝm gip bi gǝsi. ");
INSERT INTO plj_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Na bar dlǝkǝntǝne arni wu wule, <<Kup mbarǝm mǝn shirǝm juwo mǝn Galili ni diya? ");
INSERT INTO plj_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ra imni fa kogonge gǝmi ba kum wur den shirǝm na bi gǝmiwu? ");
INSERT INTO plj_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Mǝn ni jin mǝn Partiya, na mǝn Midiya, mǝn Elama, mǝn dǝmi gip Mesopotamiya, mǝn Yahuda, mbarǝm kǝ Kapadokiya, na Pontus, na Asiya, ");
INSERT INTO plj_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","mǝn Pirijiya, mǝn Pamfiliya, mbarǝm kǝ Masar, na kǝti jen gip Libǝya kosak na Sairin, mǝn dǝki kan ɗǝl tor Roma gwa. ");
INSERT INTO plj_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Gip miwo mǝn Yahuda ra na datemi gip kopi Yam kǝ mǝn Yahuda, mǝn Karita ra, na mbarǝm kǝ Arab. Kup gǝmi den kumi gǝzǝn den yari kiri bar ju Yam pi gwa gip bi gǝmi.>> ");
INSERT INTO plj_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Kan wu dlǝr gip nǝmi bi na am na damtǝne, wu wul ezǝn'e, <<Ununu ba pi untuwe?>> ");
INSERT INTO plj_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ama jen gip womti mbarǝmi mbur wurka kan wu wule, <<Wu laa'i tu na zili mal wi.>> ");
INSERT INTO plj_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Kan Bitǝrus ba tlyam dlor na nami mir mǝn kartǝn kutl-cet nǝmi, tǝ tli yar tǝ shirǝm na womti mbarǝmi tǝ wul wur'e, <<Mir ɓyar mǝn Yahuda na kup gin kan ba dǝm gip Urushalima gwa, na dǝ ceti in gamka. Neni kǝm gin ɗe kǝ kumni shirǝm gǝni. ");
INSERT INTO plj_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Mbarǝm juwo wu tla ni zili mal kandatu kǝ pǝn gwa da'a. Gǝlla am ghanum ni'i kǝ cigǝni katl. ");
INSERT INTO plj_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","O'o, muntu ni'e argon tu mǝn yari shirǝm kǝ Yam Yowel yari gwa'e, ");
INSERT INTO plj_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Yam wule, <Gip muri kǝ pa'i baro, Aa shoti Ruhu gǝn den mbarǝm gǝn kup. Mimir gin moni na mǝtli ba shin ge shirǝm kan ɗǝl sur kar Yam gwa, Ɗal mir moni gin ba shin ruya, Mir korsi gin ba tloni tlone. ");
INSERT INTO plj_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Kup na zher gin moni na mǝtli ma, Aa shoti wur Ruhu gǝn gip muri ja, kan wu yari shirǝm gǝni. ");
INSERT INTO plj_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Aa pi bar kǝ dlǝkǝntǝn to gip dlom yamka, Na bar kǝ nǝmi bi na am sur den atli, Bǝran na utu na dun kunu. ");
INSERT INTO plj_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Pǝt ba palka dǝmǝni kan dǝ kyar palka bǝrani kapǝn dǝ bar pǝt kǝ Babom Yam ɗiri. ");
INSERT INTO plj_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Kup murgon tu ba la bi sun kǝ Babom kǝ zami ɗǝltǝno, ti zam ɗǝltǝne.> ");
INSERT INTO plj_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","<<Mir ɓyar mǝn Isra'ila, kum ni shirǝm tu. Yesu kǝ Nazarato mbarǝm ni kan Yam pi kiri bar kǝ nǝmi bi na am na dlǝkǝntǝn gip dlom gin tǝp kar ti, kandatu kǝn na gam gin mom gwa. ");
INSERT INTO plj_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Bi mbarǝm tuka gip am gin kandatu Yam ne terka den untun ba pi gwa, kan kǝn na ne amra kǝ mbarǝm mǝn ɗasi tu ba kem tǝ mǝsh tǝp kǝ ba ɓa'i gǝs den kini. ");
INSERT INTO plj_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ama Yam tli tika gip mǝshi mbarǝme, ba ɗǝli tǝka gip dun mbatl kǝ mǝshtǝni, domici mǝshtǝn baa mani nǝmi gǝs da'a. ");
INSERT INTO plj_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Gun Dauda yari den ti'e, <A shin Babom Yam ra cina da'ǝm ko gǝgasi. Domici tǝ ra namǝni, a jǝrkǝtka da'a. ");
INSERT INTO plj_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ra'untuwo, mbatl gǝn gholi kan bi gǝn ba pi shirǝm ɗǝɗa gǝsi. Aa pa dǝm na la'i mbatli, ");
INSERT INTO plj_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Domici ki za'ǝmka gip gambǝci'e, ko kǝ za Zo'i gi kan kǝ ne markǝm gwa tǝ moka da'a. ");
INSERT INTO plj_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Kǝ kem a mom tǝp kopi dǝ zam rai wi, ki la im na ghol mbatl cina da'i.> ");
INSERT INTO plj_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","<<Mir ɓyari, ami na bigul kǝ shirǝm nan kǝn den'e kori gǝmi Dauda mǝshka kan ba kap tǝka, gambǝci gǝs ra ɗe har sekǝni. ");
INSERT INTO plj_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ama tǝ mǝn yari shirǝm kǝ Yam ni kan mom den Yam yari na ɓe am atl den'e ti ne nǝm gip gǝsgal gǝs tǝ dǝm den dandi gǝsi. ");
INSERT INTO plj_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Gip shini bar tu kan baa pi cina ɗewo, Dauda shirǝm den tlitǝn gip mǝshi mbarǝm kǝ Almasihu, den Yam za Almasihu gip gambǝci'e, ko tǝ za dli gǝs ar moka da'a. ");
INSERT INTO plj_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yam tli Yesu tu gip mǝshi mbarǝme, mǝn ngapo mǝ shin muntu na ger gǝmi ar ni mǝ yari ine. ");
INSERT INTO plj_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Yam ɗǝɗa ti na ne gǝs den am shimli gǝsi, nan tǝ nǝm Ruhu kan Yam wule ti bi gwa, arni tǝ shoti den mi, muntu kǝ shin kan kǝ pa kum kǝkǝn gwa. ");
INSERT INTO plj_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Yam pǝnni Dauda to yamka kandatu tǝ pi Yesu gwa da'a, ngapo tǝ wule, <Babom wul Babom gǝn'e, Dǝm den am shimli gǝni, ");
INSERT INTO plj_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Se amin a kem mǝn nge gi dǝm ba ne asǝm gi.> ");
INSERT INTO plj_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","<<Den untuwo, naa dǝ mǝn Isra'ila kup mom'e, Yam ni pali Yesu tu, muntu kan kǝ ɓa den kin gwa, tǝ dǝm ti ni'e Babomi na Almasihu!>> ");
INSERT INTO plj_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nan womti mbarǝmi kum shirǝm tuwo, ar nǝm mbatl gǝzǝni kan wu wul Bitǝrus na nami mir mǝn kartǝni'e, <<Mir ɓyari, ununu mi piwu?>> ");
INSERT INTO plj_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Bitǝrus nǝmi wur'e, <<Cini atl gam kar Yam kan dǝ pi kogonge gin batisma gip sun kǝ Yesu Almasihu kǝ dǝ pǝn warwat pitǝn gin ka. Untuni Yam ba bi in Ruhu gǝsi. ");
INSERT INTO plj_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Domici argon tu Yam wule ti pi in kǝn na mimir gini, na kup munju kan bǝn gǝzǝn dlyam nar na kup munju Babom Yam gǝmi ba la wur bi gwani.>> ");
INSERT INTO plj_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Na shirǝm jen na womti arni Bitǝrus dǝli wur kǝme, kan tǝ lir wur tǝ wule, <<Ɗǝli ni gam ginka gip wani pitǝn kǝ zhan kǝni.>> ");
INSERT INTO plj_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Munju kan nǝm shirǝm tu Bitǝrus yariwo, arni pi wur batisma, bar kǝ mbarǝm zangu myakan ni mbǝl wur ra den womtitǝn kǝ mǝn kopi gas ta. ");
INSERT INTO plj_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Wu bi gam gǝzǝn gip zami kulci kar mir mǝn kartǝni, na me gami, na gip ci fingal gip bom kǝ ezǝn na shirǝm na Yami. ");
INSERT INTO plj_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Bǝrti nǝm nami mbarǝmi naari, kan mir mǝn kartǝni ba pi bar kǝ nǝmi bi na am gip dlǝkǝntǝn na womti. ");
INSERT INTO plj_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Kup mǝn ngǝshtǝn den Yesu ra kǝ ba lasi nǝm na bi bar ezǝn kandatu bi kogonge gwa. ");
INSERT INTO plj_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Arni jen wur bar gǝzǝnka kan wu bi wurpiyi dǝ rabe gip dlom gǝzǝn den bi argon tu kogonge gip wur ba ndu gwa. ");
INSERT INTO plj_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Den pǝt kupo wu ci cina na me gam gip dǝbom bom kǝ Yami. Wu ci fingal kǝ Babom gip bom kǝ ezǝn na ghol mbatli, na mbatl nǝm, ");
INSERT INTO plj_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","wu den ɗǝɗa Yami na zami cirtǝn kar mbarǝm kup. Den kogonge pǝto Babom Yesu pi ta mbǝli ra den womtitǝn gǝzǝn na munju kan zam ɗǝltǝn gwa. ");
INSERT INTO plj_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Gasi gono, Bitǝrus na Yohana ra bǝdlabǝn Bom kǝ Yam wokoci kǝ shirǝm na Yam bar kǝ gǝlla am myakan kǝ pǝte. ");
INSERT INTO plj_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Kurki mbarǝm gon ra kan gǝr ti untu muntu ba ne ti bǝdlabǝn Bom kǝ Yam kan ba wul ti'e Mbuni Bǝdlabǝni. Ba kur ne tǝ ni lasi den kogonge pǝt kǝ liri bar kar munju kan ba te gip Bom kǝ Yami gwa. ");
INSERT INTO plj_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Nan tǝ shin Bitǝrus na Yohana den tetǝn gipiwo, arni tǝ lir wur wurpi. ");
INSERT INTO plj_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Arni wu wi ti ger ndekeke, kan Bitǝrus ba wule, <<Shin mi!>> ");
INSERT INTO plj_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Kan kurkuyi ba wi wur ger tǝ shin wule tǝ ri kǝ zami argon kar wur ituwi. ");
INSERT INTO plj_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Bitǝrus wul ti'e, <<Wurpiyo ami nari da'a, ama argon tu aa mani pi'iwo ar ni'e, gip sun kǝ Yesu Almasihu kǝ Nazarat, tlyam kǝ desi!>> ");
INSERT INTO plj_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Kano Bitǝrus ba nǝm ti na am shimli, ba tli ti yami, lasi, arni yar asǝm gǝs na gamghurǝm kǝ mbarǝmi ndǝri. ");
INSERT INTO plj_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Kan tǝ ɓo tuma, tǝ nǝm desi. Kan tǝ te gip bǝdlabǝn bom kǝ Yam nan wur tǝ den desi na tumatǝn tǝ den ɗǝɗa Yami. ");
INSERT INTO plj_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Nan mbarǝm kup shin ti den desi atl na ɗǝɗa Yamo, ");
INSERT INTO plj_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","kan wu mom den ti ni'e muntu kan ba kur dǝm kǝ liri bar bi bǝdlabǝn Bom kǝ Yam kan ba la ti bi Mbuni Bǝdlabǝn gwa. Arni mbarǝm nǝm bi na am gip dlǝkǝntǝn den argon tu zam mbarǝmi gwa. ");
INSERT INTO plj_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Nan mǝn liri bari ra dlakǝt na ga Bitǝrus na Yohanawo, arni kup mbarǝmi kan gip nǝmi bi na am ba kǝtǝr su las tu kan ba la ti bi'e ba shukutǝn kǝ Solomon gwa. ");
INSERT INTO plj_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Nan Bitǝrus shin untuwo, arni tǝ wul wur'e, <<Mbarǝm kǝ Isra'ila, unu ni'e bar ki nǝmi bi na am den muntu wu? Kan unun kem kǝ wi mi ger untu wule na ndǝrtǝn ko ho pitǝn gǝmi ni mbarǝm kǝn mani desi esi? ");
INSERT INTO plj_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Yam kǝ ga Ibǝrahim, Ishaku, na Yakubu, Yam kǝ ga kori gǝmi, tin tǝ ɗǝɗa zher gǝs Yesu. Kǝn ni kǝ kem dǝ ri ti eka na nge gǝs den'e mǝn wani pitǝn ni cina dǝ Bilatus, kup na Bilatus pǝn tor gip mbatl gǝs den ti za ti tǝ ndara gwa. ");
INSERT INTO plj_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Kǝ nge Yesu muntu bi Yam gam gǝs kan ba pi dlat gwa. Kǝ ngen dǝ pǝtli in mǝn ri mbarǝm eka. ");
INSERT INTO plj_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Kǝ ri muntu ba kop na mbarǝm wu zam rai kan ba pa dagwa eka, ama Yam tli tǝka gip mǝshi. Miwo mǝ yarini bar ju mǝ shin na ger gǝmi gwa. ");
INSERT INTO plj_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ngǝshtǝn den Yam den argon tu sun kǝ Yesu ba pi gwani kem mbarǝm kǝn kan kǝ shin kǝ pa mom gwa kǝ ndǝrtǝni. Na ho bi, ngǝshtǝn den Yam gip sun kǝ Yesu ni bi mbarǝm kǝn paltǝn lau, kandatu kǝ shin gwa. ");
INSERT INTO plj_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","<<Kǝkǝno, mir ɓyari, a mom'e kǝn na kiri kǝ bǝn gin pini untu gip dǝmǝn gam momi'e Yesu ni'e Almasihu. ");
INSERT INTO plj_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ama na untuni Yam laa'i argon tu tǝ yari terka tǝp bi dǝ kup mǝn yari shirǝm kǝ Yami, den'e Almasihu gǝs ba kum dli. ");
INSERT INTO plj_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Cini atl gam kǝkǝni, kǝ palni kar Yami, kǝ dǝ tǝ pash kǝnka den warwat pitǝn gini. Na untuni wokoci ba ɗir kan ti ndǝri in bigul hoyi, ");
INSERT INTO plj_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","kan dǝ Yam kari in bar na Almasihu, muntu kan tǝ zǝzari in terka den tǝ dǝm gun gip mbatl gin gwa. ");
INSERT INTO plj_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ar nǝm tǝ dǝm to yamka an ri wokoci tu Yam ba pali bar kup peli kandatu tǝ yari terka bi dǝ mǝn yari shirǝm kǝ Yam ju tǝ zǝzari kǝ dǝ wu yari mbarǝm mbatl gǝs gwa. ");
INSERT INTO plj_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Kum ni argon tu Musa yari gwa, <Babom Yam gin ba tli in mǝn yari shirǝm kǝ Yam gon wule ami gip ya'ǝni. Ar nǝm kǝn kǝ kop ni kup argon tu tǝ yari in gwa. ");
INSERT INTO plj_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Kup murgon tu nge kopi gǝso ba ɗǝli tika gip mbarǝm kǝ Yami.> ");
INSERT INTO plj_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","<<Untuni, kup nami mǝn yari shirǝm kǝ Yam pare den Sama'ila shirǝm den argon tu den pitǝn gip muri jin gwa. ");
INSERT INTO plj_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Kǝn nan mi ni'e munju kan Yam kari wur bar na Almasihu kandatu mǝn shirǝm na Yam wule ti pi, gip gudlum shirǝm tu kan Yam pi ga kori gǝmi kan nan mi ma. Yam yari Ibǝrahim den Almasihu'e, <Aa ɗǝɗa mbarǝm kǝ atl kundǝrǝndlip den argon tu gǝsgal gi ba pi gwa.> ");
INSERT INTO plj_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nan Yam tli zher gǝso, kan tǝ pare kari gǝs kar kǝn kǝ dǝ tǝ ne am kogonge gip kǝn kan za pitǝn kǝ ɗasi tu den bi pi argon tu baa gholi Yam mbatl gwa.>> ");
INSERT INTO plj_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Mǝn keri bar ju ɗiri Yam na bari kǝ mǝn ɓuti Bom kǝ Yam na mǝn me gam kǝ mǝn Sadukiya ɗir nan Bitǝrus na Yohana ra gip shirǝm na mbarǝm gwa. ");
INSERT INTO plj_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Lo ci wur nar den ga Bitǝrus na Yohana den kulci mbarǝm na wazu den'e Yesu tli gip mǝshi mbarǝme. Untu ni ba gode'e mǝshi mbarǝm ba tli na rai esi. ");
INSERT INTO plj_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Kan wu nǝm ga Bitǝrus na Yohana, ama domici sit piwo, kan wu la wur gip bom kǝ moni wu mur lasi. ");
INSERT INTO plj_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ama na womti gip mbarǝmi kan kum wazu gǝzǝn ngǝsh wur den Yesu, kan womtitǝn gǝzǝn ba ri mbarǝm zangu nantam (5,000). ");
INSERT INTO plj_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Bar tlowo arni kiri kǝ bǝni, mir korsi na mǝn kulci mbarǝm den kulci kǝ Musa mo gam su Urushalima ka. ");
INSERT INTO plj_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Hanana bar mǝn keri bar ju ɗiri Yam gwa ra lasi, na Kayafa, na Yohana, na Alekzanda na kup mbarǝm kǝ bom kǝ bar mǝn keri bar ju ɗiri Yam gwa. ");
INSERT INTO plj_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Kan wu ɗǝli Bitǝrus na Yohana ter dlom da wur kan wu wul wur'e, <<Imni kǝ mani pi muntuwu? Na sun kǝ woni kǝ pi bar tuwe?>> ");
INSERT INTO plj_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Bitǝrus laa'i na Ruhu kǝ Yami, arni tǝ wul wur'e, <<Mǝn bǝn na kiri kǝ bǝni! ");
INSERT INTO plj_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Sekǝno, kin den ngeni momi kar mi den ho bar tu pi kurki tu kan tǝ pal lau gwa. ");
INSERT INTO plj_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Mǝ ndu kǝn na nami mǝn Isra'ila kup mom'e sun kǝ Yesu Almasihu kǝ Nazarat ni pǝni ti kumi dli gǝska kan tǝ mani dlǝri cina da'ine. Kǝn ni kǝ kem dǝ ri ti eka tǝp kǝ ba ɓa'i gǝs den kini, ama Yam tli ti na rai lasi. ");
INSERT INTO plj_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesu ni shirǝm den ti gip Tǝlankur'e, <Tat tu kan kǝn mǝn tu'i bin nge, muntu kan pal bar ho tat gip tati kup gwa.> ");
INSERT INTO plj_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Zami ɗǝltǝno tǝp kar Yesu ni nan gǝsi. Sun gon ra es den kaar bar atl kǝn kundǝrǝndlip kan bi mbarǝm kǝ zami ɗǝltǝn gwa da'a.>> ");
INSERT INTO plj_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Nan mǝn domtǝn kǝ tloyi shirǝmi shin ɓa'i mbatl dlom gam kǝ Bitǝrus na Yohana kǝ shirǝm bat na bǝrtiwo ar kem wur kǝ nǝmi bi na ame. Wu mom'e wu pi kushi rǝshi gip Shirǝm kǝ Yam da'a, mbarǝm ni kan pǝn wur den argon ni dawo, arni wu mom'e wu zamni dǝmi na Yesu. ");
INSERT INTO plj_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ama nan wu shin mbarǝm tu kan pǝni ti kumi dliyika dlor nan wuro, wu'i mbu yari argon mǝgǝni da'a. ");
INSERT INTO plj_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Arni wu ɗǝli wurka kǝ ba domtǝni, kan wu bali gip dlom gǝzǝni. ");
INSERT INTO plj_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Wu wule, <<Imni mi pi na mbarǝm juwe? Artu kup muntu kan ba dǝm gip Urushalima mom'e mbarǝm ju pi bar kǝ nǝmi bi na am kan mi mani nge mǝ wule larni gwa da'a. ");
INSERT INTO plj_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ama kǝ dǝ kem ba dǝ mbarǝm kup kum shirǝm tu dawo, mi dǝli wur kǝme ba wu'i shirǝm na murgon gip sun tu da'a.>> ");
INSERT INTO plj_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Kan wu la wur bi ter gipi es kan wu wul wur'e ba wu'i shirǝm ko kulci mbarǝm gip sun kǝ Yesu da'a. ");
INSERT INTO plj_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ama Bitǝrus na Yohana nǝmi wur'e, <<Tloni shirǝm tu kǝn na gam gini, in dlat ni anra cina dǝ Yam mǝ kop shirǝm gin man kǝ Yam gwa. ");
INSERT INTO plj_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Mǝn ngapo mi za shirǝm den argon tu mǝn na gam gǝmi shin kan mǝ pa kum gwa da'a.>> ");
INSERT INTO plj_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Nan wu dǝli wur kǝm rawo, arni mǝn tloyi shirǝmi za wur wu ndara domici mbarǝm kup den ta ɗǝɗa Yam den argon tu kan pi gwa. ");
INSERT INTO plj_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Mbarǝm tu kan bar kǝ nǝmi bi na am tu pi den ti kǝ pali gǝs lauwo, sheti ghon gǝs man hauya rop na gǝri wi. ");
INSERT INTO plj_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Nan za ga Bitǝrus na Yohana wu ndarawo, kan wu pal rǝn kar mbarǝm gǝzǝnka. Arni wu yari wur kup argon tu kiri mǝn keri bar ju ɗiri Yam na kiri kǝ bǝn yari wur gwa. ");
INSERT INTO plj_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Nan wu kum argon tu piwo, arni wu tli yar yam na bi nǝm gip shirǝm na Yam wu wule, <<Bar Gun Babomi, ki ni kǝ pi yam na atli, na bar ɓula na kup bar ju ra gipi gwa. ");
INSERT INTO plj_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Kǝ shirǝm gip Ruhu kǝ Yam tǝp bi dǝ zher gi, ba gǝmi Dauda, kan tǝ wule, <Unun kem munju kan mǝn Yahuda ni da'a ba kum lo na Yamwu? Unun kem mbarǝm gip kǝdlǝm pitǝn ba dlǝr kǝ dlan na Yamwu? ");
INSERT INTO plj_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Gun kǝ atl kup ne bi den bar nǝm wi, kan mǝn bǝn mo gam wi den gapa na Babom Yam na Almasihu gǝsi.> >> ");
INSERT INTO plj_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","<<Na ho bi ni ga Buntus Bilatus na munju kan mǝn Yahuda ni da'a, na Hiridus na mbarǝm kǝ Isra'ila dom wur gip bǝn kǝn kan wu ɓal bika gip gapa na Yesu, zher gi mǝn tsarki, muntu kan kǝ zǝzari Almasihu gwa. ");
INSERT INTO plj_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ama kup bar ju wu piwo kǝ tare kǝ ne wi gip pi bar na ndu'i gi den untuni ba pi. ");
INSERT INTO plj_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Kǝkǝno, Babomi, kum argon tu wu pi mi gwa, kǝ ɓa'i mi bigul mǝn ga zher gi kǝ dǝ mǝ mani yari Shirǝm gi bat na bǝrti. ");
INSERT INTO plj_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ta am gi gip mani pi bar gi kǝ pǝni mbarǝm kumi dlika na pi bar kǝ nǝmi bi na am na dlǝkǝntǝn gip sun kǝ Yesu Zher gi kan ba pi argon tu kǝ ndu gwa.>> ");
INSERT INTO plj_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Nan wu pa'i shirǝm na Yamo, arni las tu wu dom wur gwa jiti ti. Kan ba laa'i wur kup na Ruhu kǝ Yami, arni wu nǝm yari shirǝm kǝ Yam bat na bǝrti. ");
INSERT INTO plj_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Kup mǝn kopi kan ngǝsh wur den Yesu dǝm nǝm gip mbatl na ruhu. Ko nǝm gon ba le gerka den bar ju tǝra nari gwa da'a, ama wu tatl ni ko unu kan wu ra nari gwa gip dlom gǝzǝni. ");
INSERT INTO plj_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Mir mǝn kartǝni pi wazu tlitǝn gip mǝshi mbarǝm kǝ Babom Yesu na ndǝrtǝn tu Yam bi wur gwa. Mbarǝm mom'e Yam den ta ɗǝɗa gǝzǝni. ");
INSERT INTO plj_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Murgon ra gip wur kan hol argon gwa da'a. Munju kan na kǝn ko bomo wu kur wurka, wu ɗiri wurpi kǝ bar ju wu wurka gwa. ");
INSERT INTO plj_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Kan wu ne cina dǝ mir mǝn kartǝni. Mir mǝn kartǝni ba bi ni mbarǝm den bi argon tu kogonge gip wur ba ndu gwa. ");
INSERT INTO plj_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Mbarǝm wule ga Isubu. Tǝ mǝn bom kǝ Lawi kan gip atl kǝ Saipǝros ni. Muntu mir mǝn kartǝniyi ba la ti bi'e Barnaba (muntu gǝs kǝ sunyi'e, Nye mǝn ɓa'i bigule). ");
INSERT INTO plj_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Tǝ wur kǝn gǝska, kan tǝ ɗir na wurpiyi tǝ ne kar asǝm kǝ mir mǝn kartǝn kǝ Yesuyi. ");
INSERT INTO plj_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Mbarǝm gon ra mǝn sun Hananiya, tǝ na nagǝr gǝs Sapiratu wur nye pili atl gǝzǝnka. ");
INSERT INTO plj_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Na momi kǝ nagǝr gǝsi, arni tǝ ne nami wurpiyika markǝme ama tǝ ɗiri nami tǝ ne cina dǝ mir mǝn kartǝni. ");
INSERT INTO plj_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Kan Bitǝrus ba wule, <<Hananiya, imni Shetan laa'i mbatl gika kan kǝ ceni lar Ruhu kǝ Yam na ne gamgi nami wurpi tu kǝ zam den wuri atl gi kagwa? ");
INSERT INTO plj_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Kapǝn kǝ wurkawo, ge ni diya? Nan kan kǝ wurka eso, wurpiyi ra gip am gi diya? Unun kem kǝ la muntu tor gip mbatl gi kǝ pi untuwu? Mbarǝm ni kǝ ceni wur lar da a, ama Yam ni.>> ");
INSERT INTO plj_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Nan Hananiya kum shirǝm tuwo, arni tǝ nda atl tǝ mǝshka. Bǝrti nǝm kup munju kum argon tu pigwa na naari. ");
INSERT INTO plj_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Kan mir moni ba ter gipi, wu ghumtǝka, wu ɗǝli ti te karika kan wu kap tǝka. ");
INSERT INTO plj_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Bar kǝ awa myakan den kaar kǝ untuwo, kan nagǝr gǝs Sapiratu ba ter gipi, ama tǝ mom argon tu kan ndo na bakos gǝs gwa da'a. ");
INSERT INTO plj_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Bitǝrus ngen momi kar ti na wuli gǝs'e, <<Yari mi, untuni wurpi tu nan ki na Hananiya wur pili atl ginka raya?>> Arni tǝ nǝmi ti'e, <<Aan wurpiyi ituwi.>> ");
INSERT INTO plj_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Kan Bitǝrus ba wul ti'e, <<Unun kem kǝ pǝn tor gip mbatl gin kǝ ceni lar Ruhu kǝ Yam den argon ba zam kǝn da'a? Ɓashini! Kum desi asǝm kǝ mir moni ju kan kap bakos gi gwa bǝdlabǝni, wi pǝn ki te karika pa'e.>> ");
INSERT INTO plj_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Bartu cina da wur arni tǝ nda atl tǝ mǝshka. Kan mir moniyi ter gipi wu zam ti ɓom mǝshiwo, kan wu te ti kari wu kap ti markǝm dǝ bakos gǝsi. ");
INSERT INTO plj_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Bǝrti nǝm domtǝn kǝ mǝn kopiyi na naari na kup munju kan kum bar ju pi gwa. ");
INSERT INTO plj_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Mir mǝn kartǝn bar kǝ Yesuyi pi bar kǝ nǝmi bi na am na dlǝkǝntǝn na womti gip mbarǝme. Kup mǝn kopi Yesu ba kur mo gam gip las tu ba la ti bi'e ba shukutǝn kǝ Solomon gwa. ");
INSERT INTO plj_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ko nǝm murgon ra gip nami mbarǝm kan ngǝsh wur den Yesuwu da'a kan zam ɓa'i bigul kǝ me gam nan wur gwa. Kup na untu, mbarǝm kup ba shin nartǝn gǝzǝni. ");
INSERT INTO plj_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Kup na untuwo, mǝtli na moni na womti ngǝsh wur den Babom Yesu kan me gam kǝ mǝn kopiyi ba nar ra. ");
INSERT INTO plj_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Den bar kǝ nǝmi bi na am na dlǝkǝntǝn ju kan mir mǝn kartǝni ba piwo, mbarǝm pi ta ɗiri mǝn kumi dli bi guntǝpe, ɓom den bamuri gǝzǝni. Wu pini untu kǝ dǝ pǝni jen kumi dli gǝzǝnka in shishidǝr kǝ Bitǝrus kop den wur tin tǝ kop lasi gwa. ");
INSERT INTO plj_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Kan mbarǝm na womti ba pi ta ɗǝltǝn ɗir gip mir bǝn kan kosak na Urushalima gwa, wu ɗiri mǝn kumi dli na munju dun itǝr ba ghun wur gwa, kan kup ba pǝni wur kumi dli gǝzǝnka. ");
INSERT INTO plj_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Arni bar mǝn keri bar ju ɗiri Yam na kup ga berǝm mbap gǝs kan gip me gam kǝ mǝn Sadukiya nǝm na ghuve. ");
INSERT INTO plj_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Arni wu nǝm mir mǝn kartǝni kan wu la wur gip bom kǝ moni kǝ gip bǝni. ");
INSERT INTO plj_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ama gip dlom gaso nye mǝn kartǝn kǝ Yam gon ɓul bǝdlabǝn bom kǝ moniyika kup kan tǝ ɗǝli wur ter kari. ");
INSERT INTO plj_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Tǝ wul wur'e, <<Mbǝrni kǝ ri dlǝrni gip Bom kǝ Yam kǝ yari ni mbarǝm kup shirǝm kǝ pel rai kǝni.>> ");
INSERT INTO plj_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Bar tlowo arni wu te gip Bom kǝ Yam kandatu yari wur gwa, wu nǝm kulci mbarǝme. Nan bar mǝn keri bar ju ɗiri Yam na ezǝn mbirawo, wu la bi domtǝn kǝ Mǝn tloyi shirǝm kǝ mǝn Yahuda muntu kan haɗe na kup kiri kǝ atl kǝ Isra'ila gwa. Arni wu kar bar rǝn bom kǝ moniyika den dǝ ter na mir mǝn kartǝni. ");
INSERT INTO plj_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ama nan mǝn ne ger den bom kǝ Yami mbubar bom kǝ moniyiwo, wu zam wur te gipika da'a. Arni wu pal rin kar domtǝn kǝ mǝn tloyi shirǝmika wu yari wur'e, ");
INSERT INTO plj_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","<<Mǝ ri zam bom kǝ moniyi dlep na le, na mir mǝn ɓuti bomi dlor ter kari bi kup bǝdlabǝni, ama nan mǝ ɓulo, mǝ zam murgon gipi da'a.>> ");
INSERT INTO plj_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Nan wu kum argon tu yari wuro, arni bari kǝ mǝn ɓuti Bom kǝ Yami, na kiri mǝn keri bar ju ɗiri Yam dam wur den argon tu muntu baa gǝri wur gwa. ");
INSERT INTO plj_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Gon kan kum kulci kǝ mir mǝn kartǝni ter gipi tǝ wule, <<Shinni! Mbarǝm ju kan kǝ la wur gip bom kǝ moni gwan ja dlor te gip Bom kǝ Yamka wu den kulci mbarǝme.>> ");
INSERT INTO plj_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Den muntuwo, arni bari kǝ mǝn ɓuti Bom kǝ Yam na ezǝn ri nǝm mir mǝn kartǝni ɗiri. Wu getl mir mǝn kartǝni da'a, domici wu kum bǝrti den mbarǝm baa la wur na tate. ");
INSERT INTO plj_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Nan ɗir na mir mǝn kartǝniwo, anni dlǝri wur cina dǝ domtǝn kǝ mǝn tloyi shirǝm kǝ mǝn Yahudayi kǝ dǝ bar mǝn keri bar ju ɗiri Yam tambe wuri. ");
INSERT INTO plj_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Kan tǝ wule, <<Mǝ dǝli in kǝm hoyi den ba kǝ'i kulci ni mbarǝm gip sun kǝ mbarǝm tu da'a. Kup na untu, kǝ nga Urushalima kup wi na kulci gini, kan kǝn den ndu'i mǝ dǝm na am gip shoti bǝran kǝ mbarǝm tu.>> ");
INSERT INTO plj_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ama Bitǝrus nǝmi wur den am kǝ nami mir mǝn kartǝni tǝ wule, <<Ar nǝm mi te yarka mǝ kop shirǝm kǝ Yam na mǝ kop shirǝm kǝ mbarǝm gwa! ");
INSERT INTO plj_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Yam kǝ ga bǝba gǝmi tli Yesu gip mǝshi mbarǝme, muntu kan kǝ ri ti eka tǝp kǝ ba ɓa'i gǝs den kini. ");
INSERT INTO plj_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Yam ɗǝɗa Yesu nar na ne gǝs den am shimli gǝsi. Tǝ ne tǝni tǝ dǝm ti ni'e mǝn ɗǝli gǝmi na gun gip dǝmi gǝmi. Yam pini muntu kǝ dǝ mǝn mbarǝm kǝ Isra'ilawo tǝ ɓuli mi guntǝp kan mi bali kaar warwat dǝmi gǝmi kǝ dǝ tǝ pǝni mi warwat pitǝn gǝmika. ");
INSERT INTO plj_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Mǝn ni'e munju shin bar ju kan pi gwa na ger gǝmi, untuni es Ruhu kǝ Yami, muntu kan Yam bi kup munju kan ba kop shirǝm gǝs gwa.>> ");
INSERT INTO plj_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Nan wu kum shirǝm tuwo, arni lo ci wur nar kan wu ndu wu ri wur eka. ");
INSERT INTO plj_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ama Ba mǝn Parise gon mǝn sun Gamaliyel, mǝn kulci mbarǝm den kulci kǝ Musa kan mbarǝm kup ba shin nartǝn gǝs gwa tlyam tlor cina dǝ domtǝn kǝ mǝn tloyi shirǝmi. Tǝ wule dǝ kur ɗǝli mir mǝn kartǝniyi kari kakani. ");
INSERT INTO plj_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Kan tǝ wul wur'e, <<Mǝn Isra'ila, ne ni ger ndin kǝ zhit ni argon tu kǝ ndu pi mbarǝm ju gwa. ");
INSERT INTO plj_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Wokoci gon ter kawo, mbarǝm gon mǝn sun Tudas cwati, tǝ pǝn gam gǝs ti murgon ni bari har tǝ zam mǝn kopi gǝs bar kǝ mbarǝm hauya kǝba lasi hauya nǝm (400). Ama ri ti eka, ndoltǝn kǝ muntu ituwi. ");
INSERT INTO plj_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Den kaar gǝso, Yahuda mǝn Galili cwat gip muri kǝ dlǝmi mbarǝme kan tǝ dǝl mbarǝm na womti kaar dati gip bǝtli asǝmka gip bari. Tiyi ma ri ti eka, kan kup mir mǝn kopi gǝs ba gǝzanka. ");
INSERT INTO plj_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ra'untuwo, den mǝnkǝn tuwo na yari ine, za ni mbarǝm ju! Za wur ni wu ndara! In argon tu wu ndu piwo kǝ gam gǝzǝn ni katlo, arba ri kǝtǝgon da'a. ");
INSERT INTO plj_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ama in kar Yam ni ar ɗǝlo, ki mani kemi mbarǝm ju kǝ za'i da'a, arba dǝm'e ki zam gam gin den dlan na Yam ituwi.>> ");
INSERT INTO plj_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Nami kop kaar kǝ shirǝm gǝsi. Kan wu la bi mir mǝn kartǝni ter gipi, wu kem ba ɓo wuri. Kan wu dǝli wur kǝm den ba wu'i shirǝm gip sun kǝ Yesu da'a, kan wu za wur wu ndara. ");
INSERT INTO plj_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Mir mǝn kartǝniyi za Domtǝn kǝ mǝn tloyi shirǝm kǝ mǝn Yahudayi wu den ghol mbatl den'e la wur gip munju kan tla sham den bi kǝ sun kǝ Yesu wi. ");
INSERT INTO plj_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Den pǝt kupo wu te gip Bom kǝ Yamka, na kopi bom kǝ ezǝni, wu za kulci mbarǝm na yari Zo Shirǝm den Yesu ni'e Almasihu da'a. ");
INSERT INTO plj_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Gip muri jawo mǝn kopi Yesu pi ta womtitǝni. Arni mǝn Yahuda kan ba shirǝm na bi kǝ mǝn Hellas kan gip wur ba ngwar den mǝn Yahuda kan ba shirǝm na bi kǝ mǝn Yahuda gwa. Mǝn Yahuda kan ba shirǝm na bi kǝ mǝn Hellasi ngwar den'e ba bi mǝtli gǝzǝn kan guri gwa fingal kan ba bi den pǝt kup nǝm na ezǝn gwa da'a. ");
INSERT INTO plj_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Arni mir mǝn kartǝn kǝ Yesu kutl cet ropi la bi domi gam kǝ kup mǝn kopi, kan wu wule, <<Ar ba ndari mǝ za mbap yari shirǝm kǝ Yamka mǝ dǝm den shirǝm kǝ fingal na bi bar mbarǝm da'a. ");
INSERT INTO plj_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Mir ɓyari, untuno zǝzarni mbarǝm nyingi gip kǝne, munju kan mom wura laa'i na Ruhu kǝ Yam na bopya gwa. Mi ne wur gam mbapi muntu ");
INSERT INTO plj_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","kan mǝ bi gam gǝmi gip shirǝm na Yam na mbap kǝ kulci na yari mbarǝm zo shirǝm den Yesu.>> ");
INSERT INTO plj_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Argon tu mir mǝn kartǝn kǝ Yesuyi yari tǝmi bi kup nami mǝn kopi. Arni wu zǝzar Istipanus. Ti mbarǝm mǝn ndǝri ngǝshtǝn den Yesu kan Ruhu kǝ Yam ba kop nan ti gwa ni. Wu pa zǝzar Filibus, Pǝrokoras, Nikano, Timon, Paminas, na Nikolas, mbarǝm kǝ Antakiya. Nikolas faro datemi gip ngǝshtǝn den Yam kǝ mǝn Yahuda ni kan pal mǝn kopi Yesu gwa. ");
INSERT INTO plj_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Arni wu ri na mbarǝm nyingi ju cina dǝ mir mǝn kartǝni. Kan wu shirǝm na Yam den wur na ne am gǝzǝn den gam kǝ kogonge gip wur kǝ dǝ wu pi mbap tu. ");
INSERT INTO plj_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Mir mǝn kopiyi pita yari mbarǝm na womti Shirǝm kǝ Yami. Womtitǝn kǝ mǝn kopi gip Urushalima nar bǝle-bǝle. Mǝn keri bar ju ɗiri Yam na womti ma ngǝsh wur den Yesu. ");
INSERT INTO plj_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Yam bi Istipanus mani pi bar na womti tǝp kǝ ba mani pi bar kǝ Yami. Tǝ pi kiri bar kǝ nǝmi bi na am na dlǝkǝntǝn na womti gip mbarǝme. ");
INSERT INTO plj_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ama ngetǝn ɗir nan mbarǝm jen kǝ domi gam kǝ zher ju kan zam gam gǝzǝn (kandatu ba la wur bi gwa) mǝn Yahuda kǝ Sairin na kǝ Alekzandǝriya, na kǝ gip atl kǝ Kilikiya na Asiya. Mbarǝm ju pare tli yar yam na Istipanus, ");
INSERT INTO plj_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","ama wu mani wu tabbate ti'e argon tu tǝ yariwo untuni anra da'i da'a, nan Ruhu kǝ Yam bi ti mani shirǝm na bopya gwa. ");
INSERT INTO plj_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Arni wu kop jen shep shep, wu co wur kǝ dǝ wu cen lar wu wule, <<Mǝ kum Istipanus den pi mǝgǝn shirǝm den Musa na Yami.>> ");
INSERT INTO plj_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Arni wu tli mbarǝm mbatl na kiri kǝ bǝn, na mǝn kulci mbarǝm den kulci kǝ Musa. Kan wu nǝm Istipanus wu ri nan ti cina dǝ domtǝn kǝ mǝn tloyi shirǝm kǝ mǝn Yahuda. ");
INSERT INTO plj_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Wu ɗiri mǝn ceni lari, munju kan wule, <<Erǝm kǝn za yari mǝgǝn shirǝm den bom kǝ Yam kǝn na kulci kǝ Musa da'a. ");
INSERT INTO plj_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Mǝ kum ti den wultǝn'e, Yesu kǝ Nazarat tu baa yas las kǝn ka kan tǝ zhimbǝl bar ju kan Musa bi mi mǝ kop gwa.>> ");
INSERT INTO plj_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Kup munju kan njon gip ba domtǝn kǝ mǝn tloyi shirǝmi wii ger Istipanus ndǝr, kan wu shin bager gǝs ba cirka wule bager kǝ mǝn kartǝn kǝ Yam goni. ");
INSERT INTO plj_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Arni bar mǝn keri bar ju ɗiri Yam ngen momi kar Istipanus'e, <<Bar ju wu yari den kiwo unjun anra ya?>> ");
INSERT INTO plj_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Den muntuwo arni Istipanus bali wur tǝ wule, <<Mir ɓyar na ga ba gǝmi, kumǝn ni! Yam mǝn nartǝn ɗǝl kar ba gǝmi Ibǝrahim nan tǝ'i gip Mesopotamiya gwa, kapǝn tǝ dǝm gip Haran. ");
INSERT INTO plj_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Yam wul ti'e, <Za atl gǝri gi na mbarǝm ginka, kǝ ri gip atl tu a ta'i'i am dene gwa.> ");
INSERT INTO plj_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Arni tǝ za atl kǝ mǝn Kaldiya ka, kan tǝ dǝm gip Haran. Den kaar mǝshtǝn kǝ baso, arni Yam kar ti ɗe gip atl kǝn kan kǝ dǝm sekǝn gwa. ");
INSERT INTO plj_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","<<Yam bi ti atl ko ma ba ne asǝm gip atli da'a. Ama Yam yari ti den'e ti bi ti atli, nan ti na gǝsgal gǝs kaar dati ar dǝm gwazini, kup na Ibǝrahim ra na nyawi da'a. ");
INSERT INTO plj_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Yam yari ti'e, <Gǝsgal gi baa dǝm mǝndǝki gip atl tu kan gwazin ni dagwa, las tu baa pali wurka zheri, wu pi bota kǝ sheti ghon hauya kǝba lasi hauya nǝm (400) gwa.> ");
INSERT INTO plj_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Yam wule, <Ama aa hukunte atl tu kan wu pi ti botayi gwa. Den kaar kǝ untuwo, wi ɗǝl ter gip atl ta wu botem gip las kǝni.> >> ");
INSERT INTO plj_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Kano Yam ba yari Ibǝrahim'e tǝ sǝr kogonge moni kan gip bom gǝs gwa. Muntu ba gode'e wi kop gudlum shirǝm tu kan Yam pi nan wur gwa ituwi. Nan Ibǝrahim dǝm basi Ishakuwo arni tǝ sǝr tika den pǝt kǝ wuzupse na gǝri. Denkariwo Ishaku sǝr nya gǝs Yakubu, kan Yakubu ba sǝr mimir gǝs ga kori gǝmi kutl-cet ropi. ");
INSERT INTO plj_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Nan ga kori gǝmi na ghuve den erǝm gǝzǝn Isubuwo, arni wu wur tika tǝ dǝm zher gip Masar. Ama Yam ra nan ti ");
INSERT INTO plj_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","kan tǝ ɗǝli ti gip kup damtǝn gǝsi. Tǝ bi Isubu bopya na ghol bǝran kar Fir'auna gun kǝ Masar. Kan Fir'auna ba ne ti den gam atl kǝ Masar na bom gǝs kup. ");
INSERT INTO plj_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Kano guzǝm ba nda gip atl kǝ Masar na atl kǝ Kan'ana kan ba ɗiri bar kumi dli, arni ga ba gǝmi hol fingali. ");
INSERT INTO plj_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Nan Yakubu kum'e o ra Masaro, tǝ kar ga ba gǝmi barta, tetǝn kǝ nǝm. ");
INSERT INTO plj_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Den tetǝn gǝzǝn kǝ ropo, arni Isubu yari mir ezǝn ko ti woni, kan Fir'auna ba mom mbarǝm kǝ shu bom kǝ ga Isubu. ");
INSERT INTO plj_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Den kaar kǝ untuwo, Isubu kari bar bas Yakubu na kup mbarǝm kǝ shu bom gǝsi, wu mbarǝm hauya myakan na kutl cet nantam. ");
INSERT INTO plj_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Kan Yakubu ba su Masar, las tu ti na ga ba gǝmi mǝshka gwa. ");
INSERT INTO plj_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Kan ba pal na gul gǝzǝn Shekem ba kap gip gambǝci tu kan Ibǝrahim wur den bi wurpi jen kar mimir kǝ Hamor gip Shekem gwa. ");
INSERT INTO plj_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Ama nan wokoci ɗir kosak kan Yam ba pi argon tu tǝ wule ti pi Ibǝrahimo, arni mbarǝm gǝmi gip Masar womti na naari. ");
INSERT INTO plj_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Kano gun gon muntu kan mom argon den Isubu da'a ba dǝm gun kǝ Masar. ");
INSERT INTO plj_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Tǝ pali mbarǝm gǝmi ka zhere. Tǝ kem ga kori gǝmi kǝ pi banyi mbapi tǝp kǝ ba kemi gǝzǝn wu byal pel gǝri mimir gǝzǝnka kǝ dǝ wu mǝshi. ");
INSERT INTO plj_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Wokoci ta ni gǝr Musa, mbuni nya ni den ger kǝ Yami. Ket ti kǝ kyar myakan gip bom dǝ base. ");
INSERT INTO plj_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Nan byal ti kawo, nya Fir'auna, nye gǝr pǝn ti tǝ ket ti tǝ dǝm nya gǝsi. ");
INSERT INTO plj_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Untuni kulci Musa bopya momi bar kǝ mǝn Masar kup, kan tǝ dǝm bar mbarǝm gip shirǝm na argon tu tǝ pi gwa. ");
INSERT INTO plj_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Nan Musa ri sheti ghon hauya rop na gǝriwo, tǝ pǝn tor gip mbatl gǝs tǝ ri shin mir ezǝni, mbarǝm kǝ Isra'ila. ");
INSERT INTO plj_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Kan tǝ shin mǝn Masar gon den ɓe mǝn Isra'ila goni, arni Musa ri ne ti am tǝ rame mbarǝmi, kan tǝ ɓo mǝn Masari tǝ ri tǝ eka. ");
INSERT INTO plj_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Musa ba wule mbarǝm gǝzǝn baa mom'e Yam ni den kopi nan ti kǝ dǝ tǝ ɗǝli wuri, ama wu mom da'a. ");
INSERT INTO plj_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Bar tlowo Musa pa ri kar wuri, arni tǝ zam mǝn Isra'ila mbarǝm rop den dlanye. Tǝ ndu wu za ka, kan tǝ wul wur'e, <<Mir mbarǝme, kǝn ɓyar ni ca, unun kem kǝ dlan kǝn na ya'ǝn we?>> ");
INSERT INTO plj_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ama muntu kan den ɓe esǝyi ture Musa ka markǝme, kan tǝ wule, <<Woni ne'i gami da mi na mǝn tloyi shirǝm gip dlom gǝmiwe? ");
INSERT INTO plj_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Kǝ ndu ni'e kǝ rim eka kandatu kǝ ri ba mǝn Masar tu eka ghur gwaya?>> ");
INSERT INTO plj_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Nan Musa kum muntuwo, arni tǝ kǝtǝr gǝs atl kǝ Midiyan, las tu tǝ dǝm mǝndǝki gwa. Bartani tǝ gudlumi kan tǝ gǝr mir moni rop. ");
INSERT INTO plj_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Den kaar kǝ sheti ghon hauya ropo Yam ɗǝl kar Musa wule mǝn kartǝn kǝ Yam goni. Yam shirǝm nan ti tǝp kar mǝn kartǝn kǝ Yami. Tǝ ɗǝli tini gip bǝlǝm utu gip lǝp kan kosak na tlǝndǝr kǝ Sinai gwa. ");
INSERT INTO plj_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Nan tǝ shin untuwo, ar ni tǝ nǝm bi na ame. Nan tǝ te kosak kǝ zhitiwo, arni tǝ kum yar kǝ Babom Yam ba wul ti'e, ");
INSERT INTO plj_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","<<Ami ni'e Yam kǝ ga ba gi, Yam kǝ ga Ibǝrahim, Ishaku na Yakubu.>> Arni Musa nǝm dǝdartǝn gip bǝrti, tǝ'i zam ɓa'i bigul kǝ shini da'a. ");
INSERT INTO plj_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Kan Babom ba wul ti'e, <<Tus kaptǝlan gi ka domici las tu kira dloro gwan ni. ");
INSERT INTO plj_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Na hobi, a shin kandatu mbarǝm gǝn ba kum dli gip Masar wu gwa. A kum ngwartǝn gǝzǝn wi, arni a sur kǝ ɗǝli gǝzǝni. Kǝkǝno ɗiri, aa kar ki su Masar ka.>> ");
INSERT INTO plj_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Muntu ni'e nǝm Musa tu wu nge ti na wultǝn'e, <<Woni ne'i gami da mi na mǝn tloyi shirǝm gip dlom gǝmiwe?>> Ti ni Yam kar ti tǝ dǝmi wur mǝn cina na mǝn ɗǝli gǝzǝn, tǝp kar mǝn kartǝn kǝ Yam tu kan ɗǝl kar ti gip lǝp gwa. ");
INSERT INTO plj_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Tǝ ɗǝli wur gip Masar na pi bar kǝ dlǝkǝntǝn na nǝmi bi na am gip Masar. Nan wu mbubar bar Zili Ɓula'i, na gip lǝp kǝ sheti ghon hauya rop gwa. ");
INSERT INTO plj_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Musa tu ni yari mbarǝm kǝ Isra'ila'e, <<Yam baa kari in bar na mǝn yari shirǝm kǝ Yam gon wule ami gip mbarǝm gini.>> ");
INSERT INTO plj_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Musa ni'e mbarǝm tu kan dom mbarǝm kǝ Isra'ila gip lǝp gwa. Tǝ ra na ga ba gǝmi na mǝn kartǝn kǝ Yam tu kan shirǝm nan ti den Tlǝndǝr Sinai gwa. Tini es tǝ nǝm shirǝm kar Yam muntu kan yari kandatu mi dǝm baa patǝn tu tǝ bi mi gwa. ");
INSERT INTO plj_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ama ga ba gǝmi nge kopi shirǝm kǝ Musa ka. Nan wu pi untuwo, arni wu nge ti kan mbatl gǝzǝn ba pal su Masarka. ");
INSERT INTO plj_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Arni wu wul Haruna'e, <<Pi mi mir yam jen kan ba nde mi cina gwa. Musa tu kan ɗǝli mi ter Masaro, mǝ mom unun zam ti da'a!>> ");
INSERT INTO plj_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Wokoci ta ni wu pi argon tu wi bote ti gwa wule nye tla. Wu ɗiri dabba wu mboshi ti na ghol mbatl gip bota den argon tu kan wu pi na am gǝzǝn gwa. ");
INSERT INTO plj_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ama Yam bali wur kaari, kan tǝ za wur wu bote ga zǝnges kǝ to yamka. Muntu ɗir nǝm na argon tu ra na rǝshi gip tǝlankur kǝ ga mǝn yari shirǝm kǝ Yam gwa'e, <<Kǝn mǝn Isra'ila, nan kǝ mbosh ga dabba gin kan kǝ ta'im gip bota kǝ sheti ghon hauya rop ju kan kǝn gip lǝpo, kǝ mom'e ami ni da'a kǝ ta'ima? ");
INSERT INTO plj_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Kǝn mbarǝm kǝ Isra'ila, ami ni kǝ botem da'a. Ama Molek ni kǝ bote ti, na zǝnges kǝ yam gin Refan, na bar ju kǝ pǝn kǝ dǝ kǝ bote wur gwa. Ra'untuwo, aa kem dǝ ndara nan kǝn kǝ ba bota na dlyami, cina na Babila.>> ");
INSERT INTO plj_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Nan ga ba gǝmi ra gip lǝpo, wu bote ni Yam gip tenti kan ba gode'e Yam ra nan wur gwa. Pi tǝni kandatu Yam wul Musa'e tǝ pi gwa, kandatu tǝ shin anra gwani tǝ pi. ");
INSERT INTO plj_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Sheti ghon na womti den kariwo, nami ga ba gǝmi pǝn tentiyi nan wur nan Joshuwa den kopi nan wur gwa. Wu ter gip atl kǝn nari nan wu dǝm mǝn atl ju kan Yam kar wur ka cina da wur gwa. Ar dǝm gip atli ba ri wokoci kǝ Dauda. ");
INSERT INTO plj_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Tǝ pi bar ju kem kan Yam pi ti mbuni gwa. Arni tǝ liri kǝ dǝ tǝ tu'i Yam bom dǝmi. Gip bom tu ni mbarǝm kǝ Isra'ila baa bote ti. ");
INSERT INTO plj_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ama Solomon nya Dauda ni Yam pi tǝ tu'i ti bomi. ");
INSERT INTO plj_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Rawo, mǝ mom'e Yam nar man ko-unu, kano tǝ dǝm gip bom ju kan mbarǝm pi gwa da'a. Kandatu mǝn yari shirǝm kǝ Yam yari'e Babom Yam wule, ");
INSERT INTO plj_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","<<To yamka ni'e las tu a dǝm kǝ pi mulki gwa. Atl ni'e ba ne asǝm gǝni. Imni bom tu ki tu im gwa ba ni rawu? Ako ni ba mani kǝmi gǝn ar dǝm'e bom gǝn we? ");
INSERT INTO plj_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Kǝ shina, ami ni'e muntu kan pi bar ju kup gwa.>> ");
INSERT INTO plj_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","<<Kǝn mbarǝm mǝn lati gami, mǝn mbatl kǝ tat na kǝm mǝn nge kumi shirǝm kǝ Yami! Kǝn ni wule ga ba gini. Kǝn den ta nge Ruhu kǝ Yami! ");
INSERT INTO plj_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Mǝn yari shirǝm kǝ Yam gon ni ra kan ga ba gin kumi ti dli dagwaya? Wu ri mǝn yari shirǝm kǝ Yam kan yari shirǝm den surtǝn kǝ mǝn pi argon tu Yam ba ndu gwa eka. Antu kǝ bali ti kaar kan kǝ ri ti eka! ");
INSERT INTO plj_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Kǝ nǝm kulciyi. Yam ni bi ga ba gǝmi kulci tu tǝp kar mǝn kartǝn bar gǝsi. Ama kǝ nge kopi ka.>> ");
INSERT INTO plj_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Nan wu kum muntuwo, arni lo ci wur den ti, kan wu ngas kur bi kǝ gǝsi wu tli den ti. ");
INSERT INTO plj_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ama Istipanus laa'i na Ruhu kǝ Yam wi ger to yamka kan tǝ shin cirtǝn kǝ Yami, na Yesu dlor den am shimli kǝ Yami. ");
INSERT INTO plj_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Arni tǝ wule, <<Shinni, a shin yam ɓuli na Nya Mbarǝm dlor den am shimli kǝ Yami!>> ");
INSERT INTO plj_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Den muntuwo arni wu kesh kǝm gǝzǝnka kan wu wom bar na la'i yare, wu tli den ti, ");
INSERT INTO plj_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","wu dǝl ti su kaar bǝnika, kan wu nǝm la'i gǝs na tate. Mǝn ri gǝs cinayi tus tutul dli gǝzǝnka wu ne kar asǝm kǝ nye mbarǝm gon mǝn sun Shawulu. ");
INSERT INTO plj_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Nan wu den la'i gǝs na tato arni Istipanus shirǝm na Yam tǝ wule, <<Babom Yesu nǝm ruhu gǝni!>> ");
INSERT INTO plj_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Kano tǝ ngus den gam ghurǝm gǝsi, tǝ la yar tǝ wule, <<Babom Yesu, ba kǝ hukunte wur den warwat pitǝn tu da'a.>> Tǝ yari untuwo, kan tǝ mǝshka. ");
INSERT INTO plj_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Shawulu ra lasi gip kopi kaar kǝ ri Istipanus eka. Gas ta ni tli domtǝn kǝ mǝn kopi kǝ gip Urushalima gami, arni kup mǝn kopi Babom Yesu gǝzanka ko-ako gip atl kǝ mǝn Yahuda na Samariya, mir mǝn kartǝni ni katl za wur gip Urushalima. ");
INSERT INTO plj_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Mǝn bǝrti Yam kap Istipanuska na pi dun mbatl na naari den mǝshtǝn gǝsi. ");
INSERT INTO plj_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ama Shawulu pi ta kumi dli domtǝn kǝ mǝn kopi. Tǝ kop bom-bom kǝ dǝli mǝtli na moni tǝ den la'i gǝzǝn gip bom kǝ moni. ");
INSERT INTO plj_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Munju kan gǝzan wurka pi wazu zo shirǝm kǝ Yesu kup las ju wu rigwa. ");
INSERT INTO plj_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filibus te gip bar bǝn kǝ Samariya kan tǝ pi shirǝm den Almasihu lasi. ");
INSERT INTO plj_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Nan womti mbarǝmi kum shirǝm kǝ Filibus na shini bar kǝ nǝmi bi na am ju tǝ piwo, arni kup gǝzǝn ne kǝm hoyi den argon tu tǝ yari gwa. ");
INSERT INTO plj_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Na la'i yare arni dun itǝr ɗǝlka gip mbarǝm na womti, na munju itǝr tle wur dlika na kurki na womti ra kan pǝni wur kumi dli kagwa. ");
INSERT INTO plj_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Bar tu ɗiri ghol mbatl na naari gip bǝni. ");
INSERT INTO plj_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Mbarǝm gon ra gip bǝni mǝn sun Simon, mǝn war ni kan ɓom muri den dlǝkǝn mǝn Samariya gwa. Tǝ ɓo ngetl den tǝ murgon ni bari. ");
INSERT INTO plj_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Mbarǝm kup, bari na heli, ba kum shirǝm gǝs na wultǝn'e, <<Mbarǝm kǝn Simon ba pini kiri bar domici Yam ni kem tǝ dǝm Mǝn Nartǝni.>> ");
INSERT INTO plj_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Wu kop ti domici tǝ ɓom muri nar wi den pi bar kǝ dlǝkǝntǝn tǝp kǝ ba war gǝsi. ");
INSERT INTO plj_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Mbarǝm kǝ bǝni ngǝsh wur den Yesu na pi wazu kǝ Filibus den dǝmi kǝ Yam Gun gip mbatl kǝ mbarǝm na den'e Yesu ni'e Almasihu. Arni tǝ pi wur batisma, mǝtli na moni kup. ");
INSERT INTO plj_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon na gam gǝs ma tǝ ngǝsh ti den Yesu kan ba pi ti batisma. Arni tǝ kop Filibus kup las tu tǝ ri gwa. Nan tǝ shin bar kǝ dlǝkǝntǝn ju den piwo arni tǝ nǝm bi na ame. ");
INSERT INTO plj_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Nan mir mǝn kartǝni kan su Urushalimaka kum'e mǝn Samariya nǝm shirǝm kǝ Yamwo, arni wu kari wur bar na Bitǝrus na Yohana. ");
INSERT INTO plj_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Nan wu mbubaro, wu shirǝm na Yam den am gǝzǝn den dǝ pel mǝn ngǝshtǝn den Yesu ju nǝm Ruhu kǝ Yami. ");
INSERT INTO plj_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Wokoci tawo Ruhu kǝ Yam sur den ko nǝm gǝzǝnwi da'a, batisma ni katl pi wur gip sun kǝ Babom Yesu. ");
INSERT INTO plj_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Arni Bitǝrus na Yohana ne am den wuri, kan wu nǝm Ruhu kǝ Yami. ");
INSERT INTO plj_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Nan Simon shin'e bini Ruhu na ne am kǝ mir mǝn kartǝni den mbarǝmo, arni tǝ bi wur wurpi. ");
INSERT INTO plj_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Tǝ wule, <<Ami ma bim ni mani pi bar tu, kǝ dǝ kup muntu a ne am den tiwo tǝ nǝm Ruhu kǝ Yami.>> ");
INSERT INTO plj_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Arni Bitǝrus nǝmi ti tǝ wule, <<Naa dǝ wurpi gi nan ki liika, domici kǝ pǝn tor gip mbatl gi den ki mani wuri bar tu Yam ba bi gwa na wurpi! ");
INSERT INTO plj_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ki na argon kǝ pi gip mbap kǝn da'a, domici mbatl gi ra dlat cina dǝ Yam da'a. ");
INSERT INTO plj_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ci atl gam kar Babom Yam den ɗasi tu gi tu kan kǝ shirǝm na Babomi. Ti mani'i pǝni warwat pitǝn gika den argon tu kan kǝ ɓal tor gip mbatl gi gwa. ");
INSERT INTO plj_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","A ne ger den ki ndinwo a shin ki ra laa'i na ɗasi tu'e, kano warwat pitǝn ɓal ki kawi.>> ");
INSERT INTO plj_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Kan Simon ba nǝmi ti tǝ wule, <<Shirǝm na Babom Yam den am gǝni den ba dǝ ko nǝm gip argon tu kǝ yari zamǝn da'a.>> ");
INSERT INTO plj_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Nan wu pi wazu shirǝm kǝ Babomo, arni Bitǝrus na Yohana pal su Urushalimaka. Wu kop gip mir bǝn kǝ Samariya na womti na pi wazu kǝ Zo Shirǝmi. ");
INSERT INTO plj_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Mǝn kartǝn kǝ Babom Yam gon wul Filibus'e, <<Su tǝp kudu, tǝp gip lǝpe, kan tli sur Urushalima ba su Gaza gwa.>> ");
INSERT INTO plj_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Arni tǝ tlyam tǝ ndara. Nan tǝ den tǝpo arni tǝ mo na bar mbarǝm gon mǝn ne wurpi kǝ Kandakatu, gǝr mǝtli gun kǝ mǝn Habasha. Mbarǝm tu su ni Urushalima kǝ bote Yami. ");
INSERT INTO plj_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ti den tǝp gǝs kǝ paltǝn bom, njon den karusa gǝs tǝ den zhiti tǝlankur kǝ mǝn yari shirǝm kǝ Yam Ishaya. ");
INSERT INTO plj_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Arni Ruhu kǝ Yam wul Filibus'e, <<Ri kar karusa tu kǝ dlǝr kosak nari.>> ");
INSERT INTO plj_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Arni Filibus kǝtǝr tǝ ri kar karusayi kan tǝ kum mbarǝmi den zhiti gip tǝlankur kǝ mǝn yari shirǝm kǝ Yam Ishaya. Filibus ngen momi kar ti'e, <<Kǝ mani momi argon tu kǝ den zhiti gwaya?>> ");
INSERT INTO plj_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Mbarǝmi nǝmi ti tǝ wule, <<Imni fa a mani momi murgon nǝra kan baa cetim gamka dagwawu?>> Arni tǝ lir Filibus den tǝ to dǝm kar ti den karusayi. ");
INSERT INTO plj_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Las tu mbarǝmi den zhiti gip Shirǝm kǝ Yam gwa ikǝni, <<La ti cina koɗak wule tǝm kan ba ri kǝ mboshi gwa, Wule tǝm tu pili ti taka ra shot Cina dǝ mǝn njetǝl gǝsi, ama tǝ ɓul bi da'a. ");
INSERT INTO plj_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Gip mburi gǝso tloyi ti shirǝm kan kor den tǝp gwa da'a. Woni ba mani shirǝm den gǝsgal gǝswe? Domici dǝmi gǝs den kaar bar atl pawi.>> ");
INSERT INTO plj_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Arni mbarǝmi ngen momi kar Filibus'e, <<Kustu, yari mi, woni mǝn yari shirǝm kǝ Yam tu ba shirǝm den tiwe, den gam gǝs na ko den murgon ni?>> ");
INSERT INTO plj_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Arni Filibus pǝni ti yari shirǝm kǝ Yam den muntu na jen es na womti, kan tǝ yari ti Zo Shirǝm kǝ Yesu. ");
INSERT INTO plj_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Nan wu den ritǝno wu ri zam male, arni tǝ wule, <<Ɓa shini, mal kǝn ɗe! Unun ba hane dǝ pim batismawu?>> ");
INSERT INTO plj_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","(Arni Filibus wul ti'e, <<Kini kǝ ngǝsh ki den Yam gip Yesu na kup mbatl giwo ba pi'i.>> Kan tǝ bali ti tǝ wule, <<A ngǝshǝm den Yam wi den Yesu Nya Yam ni.>>) ");
INSERT INTO plj_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Kan mbarǝmi ba kem dǝ dlǝri karusayi. Arni kup gǝzǝn ropi su gip mali, kan Filibus ba pi ti batisma. ");
INSERT INTO plj_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Nan wu ɗǝl tor gip maliwo, bartu, arni Ruhu kǝ Babom pǝn Filibuska. Mbarǝmi'i shin ti da'a, ama tǝ laa'i na ghol mbatl nan ti den tǝp gǝsgwa. ");
INSERT INTO plj_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filibus ngapo, arni tǝ ɗǝl gip bǝn kǝ Azotus tǝ den kopi las na pi wazu kǝ Zo Shirǝmi gip bǝn ju kup kan den tǝp gǝs gwa har tǝ mbubar gip bǝn Kaisariya. ");
INSERT INTO plj_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ama Shawulu den ta kumi dli mǝn kopi Babom Yesu. Arni tǝ ri kar bar mǝn keri bar ju ɗiri Yam gwa. ");
INSERT INTO plj_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Tǝ ngen den tǝ bi ti rǝshi tǝlankur kan ti si kiri kǝ bom domtǝn kǝ mǝn Yahuda kan gip Dimashka gwa. Tin tǝ zam kup mǝtli na moni mǝn kopi tǝp kǝ Yesuwo tǝ nǝm wur tǝ si wur Urushalima na ɓali. ");
INSERT INTO plj_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Nan tǝ mbi kosak na Dimashka den ɓomi asǝm gǝso, arni pǝlǝt cirtǝn gon ɗǝl sur yam ba cir kar ti. ");
INSERT INTO plj_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Arni tǝ nda atlka kan tǝ kum yar gon ba wul ti'e, <<Shawulu, Shawulu, unun kem kǝ kumim dli rawu?>> ");
INSERT INTO plj_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Kan tǝ wule, <<Ki ni'e wowe, Babomi?>> Arni yari nǝmi ti'e, <<Ami ni'e Yesu. Ami ni kǝ kumim dli nan kǝ kumi dli mǝn kopi gǝn gwa. ");
INSERT INTO plj_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Kǝkǝno, tlyam kǝ te gip bǝni, lasini ba yari'i argon tu nǝm ki te yarka kǝ pi gwa.>> ");
INSERT INTO plj_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Mbarǝm ju nan den ɓomi asǝm nan ti kum bǝrti, arni wu dlǝr lasi shot wu mani shirǝm da'a. Wu den kumi yari ama wu shin murgon da'a. ");
INSERT INTO plj_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Kan Shawulu ba tli tor atli, ama nan tǝ ɓul gero tǝ mani shini argon da'a. Arni munju kan ra nan ti nǝmi ti am wu te ti gip bǝn Dimashka. ");
INSERT INTO plj_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Tǝ mani shini argon da'a kǝ muri myakan, eso tǝ ci ko tǝ tla argon da'a. ");
INSERT INTO plj_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Gip Dimashkawo, mǝn kopi gon ra mǝn sun'e Hananiya. Babom la ti bi gip ruya tǝ wule, <<Hananiya!>> Kan tǝ nǝmi ti'e, <<Amin kǝni, Babomi.>> ");
INSERT INTO plj_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Arni Babom wul ti'e, <<Tlyam kǝ kop rǝn bom dǝ Yahudaka den tǝp tu kan ba wul ti'e Sat Tǝp gwa. Kini kǝ mbu baro, ngen momi gǝs kǝ mbarǝm kǝ Tarsus gon mǝn sun Shawulu. Tǝ ra den shirǝm na Yami. ");
INSERT INTO plj_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Gip ruyawo tǝ shin mbarǝm gon mǝn sun Hananiya ter kar ti kan tǝ ne am den ti kǝ dǝ tǝ pali ti mani shini bar gǝsi.>> ");
INSERT INTO plj_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Arni Hananiya bali shirǝm'e, <<Babomi, a kum ni shirǝm na womti den mbarǝm tu wi den kandatu tǝ kumi dli mbarǝm gi kan su Urushalima kagwa. ");
INSERT INTO plj_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Kǝkǝno tǝ terni ɗe na bi kǝ kiri mǝn keri bar ju ɗiri Yam gwa, kǝ nǝmi kup mǝn la'i bi sun gi.>> ");
INSERT INTO plj_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ama Babom Yesu wul Hananiyayi'e, <<Mbǝri! Shawulu dǝm zǝzar bar kǝ mbap gǝn kǝ pi wazu shirǝm gǝn dǝ munju kan mǝn Yahuda ni da'a na ga gun gǝzǝni, na cina dǝ mbarǝm kǝ Isra'ila wi. ");
INSERT INTO plj_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Aa gode ti kandatu ti kum dli naar den bi sun gǝn gwa.>> ");
INSERT INTO plj_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Kan Hananiya ba ri bomi tǝ te gipi. Tǝ ne am gǝs den Shawulu, tǝ wule, <<Erǝm Shawulu, Babom Yesu, muntu kan ɗǝl kar ki den tǝp nan kǝ ter ɗe gwani karǝm kar ki kǝ dǝ kǝ zam mani shini bar gi esi na dǝ kǝ pa laa na Ruhu kǝ Yami.>> ");
INSERT INTO plj_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","An ri kǝtǝgon da'a, arni argon wule kǝr kos ɗǝl ter ger dǝ Shawulu, kan tǝ mani shini bar esi. Tǝ tlyami kan ba pi ti batisma. ");
INSERT INTO plj_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Nan tǝ ci fingalo, arni bigul pali ti. Shawulu ɓom muri na mǝn kopi kǝ gip Dimashka. ");
INSERT INTO plj_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Arni tǝ nǝm pi wazu gip bom domtǝn kǝ mǝn Yahuda den'e Yesu nya Yam ni. ");
INSERT INTO plj_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Kup munju kum ti nǝm bi na ame, kan wu wule, <<Ti ni'e mbarǝm tu kan kem kumi dli mǝn la'i bi den sun kǝ Yesu kan gip Urushalima gwa diya? Annya tǝ ter ni ɗe kǝ nǝmi gǝmi tǝ pali mi mir mǝn bom kǝ moni kǝ kiri mǝn keri bar ju ɗiri Yam gwa diya?>> ");
INSERT INTO plj_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ra'untuwo, ci cina na ndǝrtǝn kǝ Shawulu gip shirǝm den'e Yesu ni'e Almasihu kem mǝn Yahuda ju kan gip Dimashka gwa mani zami argon tu wi bali ti gwa da'a. ");
INSERT INTO plj_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Den kaar kǝ muri na womtiwo, arni mǝn Yahuda jen gudlumi den wu ri ti eka, ");
INSERT INTO plj_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ama Shawulu zam kumi argon tu wu gudlumi kagwa. Arni wu ne ger gǝs pǝt na gas su bǝdlabǝn kǝ bǝni ka, kǝ dǝ wu ri ti eka. ");
INSERT INTO plj_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ama mir mǝn kopi gǝs ne ti gip bar shar gip gasi kan wu shu ti sur atl tǝp kǝ ba tuli shu gon den panye. ");
INSERT INTO plj_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Nan Shawulu mbubar Urushalimawo, tǝ ndu me gam na mǝn kopi, ama kup wu kum bǝrti gǝsi. Wu nǝm den'e tǝ dǝm ho mǝn kopi wi da'a. ");
INSERT INTO plj_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ama Barnaba ɗir nan ti kar mir mǝn kartǝni, kan tǝ yari wur kandatu Shawulu shin Babom Yesu den tǝp gǝs kǝ tetǝn Dimashka na kandatu Babom shirǝm nan ti gwa. Tǝ pa yari wur kandatu Shawulu pi wazu gip Dimashka gip sun kǝ Yesu bat na bǝrti gwa. ");
INSERT INTO plj_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Shawulu dǝm na mir mǝn kartǝni tǝ den kopi gǝzǝn gip bǝn Urushalima na pi wazu gip sun kǝ Babom Yesu bat na bǝrti. ");
INSERT INTO plj_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Shirǝm gadlǝri wurka, ti na mǝn Yahuda jen mǝn shirǝm na bi kǝ mǝn Hellas, arni wu ndu ri gǝs eka. ");
INSERT INTO plj_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Nan mir ɓyar zam na momi kawo, arni wu su nan ti Kaisariya kan wu la ti tǝp tǝ ndara bǝn gǝs Tarsus. ");
INSERT INTO plj_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Arni domtǝn kǝ mǝn kopi Yesu ko ako gip atl kǝ mǝn Yahuda, na Galili na Samariya zam dǝmi zhǝlili. Wu zam ndǝrtǝni, na ɓa'i bigul kǝ Ruhu kǝ Yami. Mǝn kopi Yesu pi ta womtitǝn na dǝmi gip bǝrti kǝ Babomi. ");
INSERT INTO plj_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ar dǝm'e nan Bitǝrus den ɓomi asǝm na kopi laso, kan tǝ ri kar mǝn kopi kan gip bǝn kǝ Lidda gwa. ");
INSERT INTO plj_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Barta ni tǝ zam mbarǝm gon mǝn sun'e Iniyasu, muntu kan pi sheti ghon wuzupse tǝ mani tlitǝn yam da'a. ");
INSERT INTO plj_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Bitǝrus wul ti'e, <<Iniyasu, Yesu Almasihu pǝni'i kumi dli gika kǝkǝnwi. Tlyam kǝ kucǝm bamuri gika.>> Kenja arni Iniyasu tlyam dlor. ");
INSERT INTO plj_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Kup mbarǝm ju kan ba dǝm gip Lidda na Sarona nan wu shin Iniyasuwo kan wu dǝm mǝn kopi Babom Yesu. ");
INSERT INTO plj_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Gip Yapawo nagǝr mǝn kopi gon ra mǝn sun'e Tabita (muntu kan na bi kǝ mǝn Hellaso ar ni'e Dokas gwa). Tǝ pi ta pi mbarǝm ho bar na ne am munju am ri wur kaar dagwa. ");
INSERT INTO plj_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Wokoci ta ni tǝ mur atl tǝ kum tǝmi kǝ dli gǝs da'a kan tǝ mǝshka. Mir mǝn kopi Yesu ho dli gǝska, ba ne to gip ɓiti kushi kǝ to yamika. ");
INSERT INTO plj_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lidda dlyam na Yapa da'a, arni nan mǝn kopi kum'e Bitǝrus ra gip Liddawo, wu kar mbarǝm rop kǝ dǝ wu lir ti'e, <<Kustu, ɗir nan mi ba kǝ dǝm gi da'a!>> ");
INSERT INTO plj_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Arni Bitǝrus ri nan wuri. Nan tǝ mbubaro arni wu te ti kushi kǝ to yami ka. Kup mǝtli kan guri gwa la ti dlomi, wu den kulu na ta'i am den tlyari lulur na tutul dli jen kan Dokas pi nan tǝ'i ra nan wur gwa. ");
INSERT INTO plj_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ama Bitǝrus wul wur'e wu za kushiyi. Tǝ ngus den gam ghurǝm tǝ shirǝm na Yami. Tǝ bal ti rin kar dli kǝ Tabitaka, kan tǝ wule, <<Tabita, tlyami!>> Arni tǝ ɓul gere, nan tǝ shin Bitǝruso, kan tǝ dǝm njon atli. ");
INSERT INTO plj_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Bitǝrus ta'i ti am gǝs kan tǝ tli ti yami. Kan tǝ la bi mǝn kopiyi na guri ju kan tǝ bi wur Tabita na rai. ");
INSERT INTO plj_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Kum shirǝm tu ko ako gip bǝn Yapa, kan mbarǝm na womti ba ngǝsh wur den Babom Yesu. ");
INSERT INTO plj_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Arni Bitǝrus dǝm gip Yapa kǝ muri jen gip bom kǝ mǝn luti kur gon mǝn sun Simon. ");
INSERT INTO plj_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Gip Kaisariyawo mbarǝm gon ra mǝn sun'e Karniliyus. Ti ni'e mǝn kopi na mǝn bi-utu zangu kutl kǝ Italiya. ");
INSERT INTO plj_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ti na kup mbarǝm kǝ bom gǝso mǝn bota na bǝrti Yam ni. Tǝ bi bar kǝ am gǝs munju am ri wur kaar da'a, kan ti mǝn meti shirǝm na Yam ni ko gigasi. ");
INSERT INTO plj_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Gasi gon bar kǝ gǝlla am myakan kǝ pǝto, tǝ shin ruya. Tǝ shin mǝn kartǝn kǝ Yam ɗir kar ti kan tǝ wul ti'e, <<Karniliyus.>> ");
INSERT INTO plj_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Arni gip bǝrti Karniliyus wi ti gere. Kan tǝ ngen momi tǝ wule, <<Ununu Babomi?>> Mǝn kartǝn kǝ Yami nǝmi ti'e, <<Shirǝm na Yam gi ju na bi bar kǝ am gi dǝ munju am ri wur kaar da'a ju dǝm bar kǝ tune cina dǝ Yam wi. ");
INSERT INTO plj_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Kǝkǝno kar mbarǝm te Yapaka wu ter na mbarǝm gon mǝn sun Simon muntu ba la ti bi'e Bitǝrus gwa. ");
INSERT INTO plj_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Tǝ ra bom dǝ Simon mǝn luti kuri, muntu kan bom gǝs ra bi ɓula gwa.>> ");
INSERT INTO plj_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Nan mǝn kartǝn kǝ Yami kan shirǝm nan ti ndarawo, arni Karniliyus la bi rop gip zher gǝsi, na mǝn bi-utu gon mǝn bote Yami, nǝm gip munju ba pi ti mbap gwa. ");
INSERT INTO plj_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Arni tǝ yari wur kup argon tu pigwa, kan tǝ kar wur te Yapa ka. ");
INSERT INTO plj_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Bar tlo kǝ dlom pǝte, nan ɓomi asǝm gǝzǝn mbi kosak na gip bǝn Yapawo, Bitǝrus to gǝs den rupi gam bom kǝ shirǝm na Yami. ");
INSERT INTO plj_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Kan guzǝm ba nǝm ti, tǝ den ndu'i tǝ zam argon tǝ ci. Ama nan tǝ den ɓuti dǝ pa'i pi fingalo arni tǝ shin ruya. ");
INSERT INTO plj_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Tǝ shin dlom yam ɓuli na argon wule bar bamuri kan la sur atl mǝn bi wupse gwa. ");
INSERT INTO plj_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Den bamuriyiwo kup ga dabba ni kǝ mǝn asǝm wupse na badǝr ici na ga lǝgandi na yatl kǝ to yamka. ");
INSERT INTO plj_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Kan yar gon ba wul ti'e, <<Bitǝrus, tlyam kǝ mbosh kǝ ci.>> ");
INSERT INTO plj_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ama Bitǝrus nǝm'e, <<O'o Babomi, a taɓe ci argon tu kan den kulci gǝmi kǝ mǝn Yahudawo ar dlǝran da'a ko wani ni gwa da'a.>> ");
INSERT INTO plj_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Yari pa wul ti'e, <<Ba kǝ la bi argon'e dlǝran ni anra da'i da'a muntu kan Yam paliwi hoyi kǝ ci gwa.>> ");
INSERT INTO plj_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Muntu pi kǝ bisi myakan, kan wule gip njibkǝr gere ba pǝn bamuriyi to yam ka ra lasi. ");
INSERT INTO plj_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Nan Bitǝrus gip damtǝn den ununu ruya tu ba pi nupiwo, arni mbarǝm ju kan Karniliyus kar wur ba mbubar bom dǝ Simon wu dlǝr bǝdlabǝni. ");
INSERT INTO plj_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Wu ngen momi ko Simon muntu kan mom ti na Bitǝrus ra lasi. ");
INSERT INTO plj_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Nan Bitǝrus ra gip damtǝn den ruya tuwo, arni Ruhu kǝ Yam yari ti'e, <<Simon, mbarǝm myakan cwat den ngeni gi. ");
INSERT INTO plj_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Tlyam kǝ ɗǝl suka. Ba kǝ ndu kǝ nge ritǝn nan wur da'a, domici ami ni a kar wuri.>> ");
INSERT INTO plj_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Kan Bitǝrus ba ɗǝl sur tǝ wul wur'e, <<Ami ni'e mbarǝm tu kan kǝn den ngeni gwa. Ununu ɗir kǝn we?>> ");
INSERT INTO plj_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Arni wu nǝmi ti'e, <<Karniliyus, bar mǝn bi-utu gon ni kar mi. Mbarǝm mǝn pitǝn dlat na bǝrti Yam ni. Kup mǝn Yahuda ba shin nartǝn gǝsi. Mǝn kartǝn kǝ Yam gon ni yari ti'e tǝ la ki bi rǝn bom da tika, kǝ dǝ tǝ kum argon tu ki yari gwa.>> ");
INSERT INTO plj_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Arni tǝ ter na mǝn dǝkiyi gip bom gǝs wu mur lasi. Bar tlowo, kan Bitǝrus ba ri nan wuri, na ezǝn mǝn kopi jen kan ɗǝl ter Yapa gwa. ");
INSERT INTO plj_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Zut bar tlowo kan tǝ mbubar gip Kaisariya. Nan Karniliyus den ɓuti cwattǝn gǝzǝno arni tǝ dom mǝn gǝs na ga berǝm gǝs kan kosak nan ti gwa. ");
INSERT INTO plj_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Nan tǝ te gip bomiwo, arni Karniliyus mbor ti tǝ nda atl cina da ti gip bi tǝ nartǝni. ");
INSERT INTO plj_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ama Bitǝrus tli ti yamka kan tǝ wul ti'e, <<Tlyami, ami ma mbarǝm ni katl.>> ");
INSERT INTO plj_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Bitǝrus shirǝm nan ti kan tǝ te gip bomi kan tǝ zam mbarǝm na womti dom wur wi. ");
INSERT INTO plj_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Tǝ wul ti'e, <<Kǝ mom'e den kulci gǝmiwo mǝn Yahuda ba ngash gam ko tǝ ri bom kǝ muntu kan mǝn Yahuda ni da'i da'a. Ama Yam ɓul ger gǝn a shin wi den ba a la bi murgon'e Yam baa nǝm ti da'a ko tǝ wan nar kǝ dǝ mǝn Yahuda me gam nan ti gwa. ");
INSERT INTO plj_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Arni kem nan karim baro, ko njem a dǝl shirǝm den ɗirtǝni da'a. Yari mi, unun kem kǝ karim bar rawu?>> ");
INSERT INTO plj_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Karniliyus nǝmi ti tǝ wule, <<Muri wupse karo, ami gip bom gǝn den shirǝm na Yam bar nan kǝni, bar kǝ gǝlla am myakan kǝ pǝte. An ri kǝtǝgon da'a se mbarǝm gon kǝn gip tutul dli mǝn cirtǝn dlor cina da'ǝmi. ");
INSERT INTO plj_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Tǝ wule, <Karniliyus, Yam kum shirǝm na Yam gi, tǝ pa shin bi bar kǝ am gi dǝ munju am ri wur kaar dagwa wi. ");
INSERT INTO plj_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Kar bar Yapa den Simon muntu ba la ti bi'e Bitǝrus gwa. Mǝn dǝki kǝ Simon mǝn luti kur ni, muntu bom gǝs ra bi bar ɓula gwa.> ");
INSERT INTO plj_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Arni a dǝm da'a kan a kar bar den ki, ar mbun kan kǝ ter gwa. Kǝkǝno mǝn ni jin kup ɗe cina dǝ Yam kǝ dǝ mǝ kum kup argon tu Babom wul ki'e kǝ yari mi gwa.>> ");
INSERT INTO plj_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Kan Bitǝrus ba nǝm shirǝm na wultǝn'e, <<Kǝkǝno a momwi den'e na ho bi Yam ba ndu murgon man gon da'a ");
INSERT INTO plj_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ama tǝ nǝm kup munju kan ba bǝrti ti na pi argon tu kan dlat gwa na kup atl ju wu ra gwa. ");
INSERT INTO plj_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Kǝ mom shirǝm tu Yam kari bar mǝn Isra'ila kǝ pi wazu Zo Shirǝm kǝ zami dǝmi zhǝlili na Yam tǝp kar Yesu Almasihu. Mbarǝm tu Yesuwo Babom kǝ mǝn Israˈila ni katl da'a ama Babom kǝ mbarǝm kup ni. ");
INSERT INTO plj_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Kǝ mom na argon tu kan pi gip atl kǝ Yahuda kup, argon tu nǝm gip Galili nan kop kaar kǝ wazu pi batisma kǝ Yohana gwa. ");
INSERT INTO plj_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Kǝ mom kandatu Yam bi Ruhu gǝs Yesu kǝ Nazarat gwa. Tǝ pa bi ti mani pi bar kǝ nǝmi bi na ame. Kǝ mom kandatu tǝ kop las ko ako tǝ den pi mbarǝm ho bar na pǝni kumi dli kup munju kan gǝs dǝ Shetan gun dun itǝr gwa. Ti pini muntu kup domici Yam ra nan ti. ");
INSERT INTO plj_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","<<Mǝn ngapo mǝ shin kup bar ju tǝ pi gip atl kǝ mǝn Yahuda na gip bǝn Urushalima ma. Kup na untu, kiri mǝn bǝn kǝ Urushalima ri tǝ eka tǝp kǝ ba ɓa'i gǝs den kini. ");
INSERT INTO plj_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ama Yam tli tǝka gip mǝshi mbarǝm den pǝt kǝ myakan, kan tǝ kem ba shin ti. ");
INSERT INTO plj_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ba'e kup mbarǝm ni shin ti da'a, ama Yam zǝzar mi mǝ shin ti, arni kǝkǝno mǝ yari jen shirǝm den ti. Mǝn kan mǝ ci mǝ pal mǝ tla nan ti den kaar kǝ tlitǝn gǝs gip mǝshi mbarǝm gwa. ");
INSERT INTO plj_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Kan tǝ bi mi bi kǝ dǝ mǝ pi wazu mbarǝm kan mǝ dǝli wur kǝm kǝ dǝ wu mom'e Yesu ni'e muntu kan Yam zǝzari tǝ dǝm mǝn tloyi shirǝm kǝ mbarǝm munju ra den kaar atl gwa na mǝshi kup. ");
INSERT INTO plj_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Mǝn yari shirǝm kǝ Yam kup shirǝm den ti den'e kup muntu kan ngǝsh den Yesu ba zam dǝ pǝni ti warwat pitǝn gǝska gip sun gǝsi.>> ");
INSERT INTO plj_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Nan Bitǝrus ra gip shirǝmo, arni Ruhu kǝ Yam sur den kup munju kan kum shirǝm gǝs gwa. ");
INSERT INTO plj_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Mǝn Yahuda ju kan ngǝsh wur den Yesu kan kop Bitǝrus kaaro wu nǝm bi na ame den bi Ruhu kǝ Yam munju ma kan mǝn Yahuda ni dagwa. ");
INSERT INTO plj_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Kumi gǝzǝn den shirǝm gip bi jen na ɗǝɗa Yam ni kem wu mom muntu. Arni Bitǝrus wule, ");
INSERT INTO plj_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","<<Woni ba hane dǝ pi mbarǝm ju batisma na male? Wu nǝm Ruhu kǝ Yamwi kandatu mǝn ma mǝ nǝm gwa.>> ");
INSERT INTO plj_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Kan wu bi wur bi den dǝ pi wur batisma gip sun kǝ Yesu Almasihu. Arni wu lir Bitǝrus kǝ dǝ tǝ ɓom muri nan wuri. ");
INSERT INTO plj_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Mir mǝn kartǝn kǝ Yesu na nami mǝn kopi kan gip atl kǝ Yahuda kum den'e munju kan mǝn Yahuda ni da ma wu nǝm shirǝm kǝ Yam den Yesu wi. ");
INSERT INTO plj_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Nan Bitǝrus mbubar Urushalimawo, arni mǝn Yahuda kan ngǝsh wur den Yesu gwa ngwar den ti. ");
INSERT INTO plj_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Wu wule, <<Kǝ ri bom kǝ munju kan mǝn Yahuda ni da'a, kǝ pal kǝ ci fingal nan wuri.>> ");
INSERT INTO plj_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Arni Bitǝrus yari wur kup argon tu pigwa ter den gǝsi, tǝ wule, ");
INSERT INTO plj_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","<<Ami ra gip bǝn kǝ Yapa den shirǝm na Yami, arni a shin ruya. A shin argon wule bar bamuri kan la sur yam na bi wupse, kan ba sur atl las tu ami ra gwa. ");
INSERT INTO plj_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nan a zhit gipiwo, arni a shin ga dabba kǝ gip lǝp, mǝn asǝm wupse, badǝr kǝ ga ici na ga lǝgandi, na yatl kǝ to yamka. ");
INSERT INTO plj_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Kan a kum yar ba wulǝm'e, <Bitǝrus, tlyami. Mbosh kǝ ci.> ");
INSERT INTO plj_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","<<Ama a nǝmi ti'e, <O'o Babomi, a taɓe ci argon tu kan den kulci gǝmi kǝ mǝn Yahudawo ar dlǝran da'a ko wani ni gwa da'a.> ");
INSERT INTO plj_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","<<Yari pa wul sur yam'e, <Ba kǝ la bi argon'e dlǝran ni anra da'i da'a muntu kan Yam paliwi hoyi kǝ ci gwa.> ");
INSERT INTO plj_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Muntu pi bisi myakan, kan ba dǝlka to yamka esi. ");
INSERT INTO plj_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","<<Lasi, se mbarǝm myakan kan kar wur karǝm ter Kaisariya gwa ni jin bom tu kan a dǝm gwa. ");
INSERT INTO plj_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Arni Ruhu kǝ Yam yarim den a ri nan wur bat na dǝli shirǝm den ritǝni. Mir ɓyar mukka ju ma wu kopǝn kan mǝ te gip bom kǝ Karniliyus nan wuri. ");
INSERT INTO plj_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Tǝ yari mi kandatu tǝ shin mǝn kartǝn kǝ Yam gon dlor gip bom gǝsi, kan wul ti'e, <Kar bar Yapa dǝ Simon muntu ba la ti bi'e Bitǝrus gwa. ");
INSERT INTO plj_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ti yari'i na kup munju kan gip bom gi kandatu Yam ba ɗǝli ine kan ti hukunte in den warwat pitǝn gin dagwa.> ");
INSERT INTO plj_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","<<Nan a pare shirǝmo arni Ruhu kǝ Yam sur den wur kandatu ar sur den mi na ne gǝs kǝ pi bar gwa. ");
INSERT INTO plj_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Kan a dam argon tu Babom yari gwa'e, <Yohana pini mbarǝm batisma na male, ama gip muri njem cina ɗewo, baa pi in batisma na Ruhu kǝ Yami.> ");
INSERT INTO plj_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ra'untuwo, nan wu ngǝsh wur den Yesu Almasihuwo kan Yam ba bi wur nǝm bar tu tǝ bi mi kan ngǝsh den Yesu Almasihu gwa, wo ni'e ami kan a pi gapa na Yam gwa?>> ");
INSERT INTO plj_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Nan wu kum untuwo, arni wu za ngwartǝn gǝzǝn den Bitǝrus kan wu ɗǝɗa Yam wu den wultǝn'e, <<Rawo, Yam ni bi munju kan mǝn Yahuda ni da'a tǝp kan wu ci atl gam wu zam rai kan ba pa da gwa.>> ");
INSERT INTO plj_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Munju kan gǝzanka den bi kumi dli pare den ri Istipanus eka ɓom asǝm na dlyami ba ri atl kǝ Finiks, na Saipǝros, na Antakiya gip Siriya. Wu pi wazu shirǝm kǝ Yam dǝ mǝn Yahuda katl. ");
INSERT INTO plj_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Jen gip wuro mǝn Saipǝros na Sairin ni. Wu te gip bǝn kǝ Antakiya wu den pi wazu dǝ mǝn Yahuda na munju mǝn Yahuda ni dagwa, wu den yari wur Zo Shirǝm kǝ Babom Yesu. ");
INSERT INTO plj_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Am kǝ Babom Yam ra den wuri, kan mbarǝm na womti ba nǝm shirǝm gǝzǝn wu ngǝsh wur den Babom Yesu. ");
INSERT INTO plj_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Shirǝm kǝ bar tu kan piwo ar nda kǝm dǝ domtǝn kǝ mǝn kopi kǝ gip Urushalima, arni wu kar Barnaba bǝn kǝ Antakiya. ");
INSERT INTO plj_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Nan tǝ mbubar tǝ shin argon tu Yam pi mbarǝm juwo, ar gholi ti mbatli kan tǝ ɓa'i wur bi-gul kǝ dǝ kup gǝzǝn dǝm mǝn kopi shirǝm kǝ Babom na mbatl gǝzǝn kup. ");
INSERT INTO plj_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabawo ho mbarǝm ni kan ra laa'i na Ruhu kǝ Yam na ngǝshtǝn den Yesu gwa. Den argon tu tǝ pi gwawo arni mbarǝm na womti pal mǝn kopi Babom Yesu. ");
INSERT INTO plj_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Kan Barnaba ba ne gam Tarsus kǝ ngeni Shawulu. ");
INSERT INTO plj_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Nan tǝ zam tiwo, tǝ te nan ti Antakiya. Arni Barnaba na Shawulu dǝm nan wur kǝ sheti ghon nǝm den metǝn na domtǝn kǝ mǝn kopi na kulci mbarǝm na womti. Gip Antakiya ni pare la'i bi mǝn kopi Yesu'e Kǝrista. ");
INSERT INTO plj_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Gip wokoci ta ni mǝn mani yari bar ju baa pi cina ɗegwa jen za Urushalima kan wu ndara Antakiya. ");
INSERT INTO plj_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Nǝm gip wur mǝn sun Agabus tlyam dlor, gip Ruhu kǝ Yami arni tǝ shirǝm den bar guzǝm kan ba nda ɗir den atl kundǝrǝndlip gwa. (Muntu ɗir pini wokoci tu Kǝlaudiya ra bar Gun kǝ Roma gwa). ");
INSERT INTO plj_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Arni mǝn kopi kan gip Antakiya gwa pǝn tor gip mbatl gǝzǝn den kogonge gip wuri, den bi argon tu tǝ mani pi gwa, baa ne am ɓyari kan ba dǝm gip atl kǝ mǝn Yahuda gwa. ");
INSERT INTO plj_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Wu pi muntu, kan wu kar bar na bar ju wu dom gwa dǝ si kiri kǝ mǝn kopiyi tǝp am dǝ Barnaba na Shawulu. ");
INSERT INTO plj_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Wokoci ta ni Gun Hiridus Agǝripa nǝm jen gip mir mǝn kopi, tǝ den ndu'i tǝ kumi wur dli. ");
INSERT INTO plj_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Tǝ ri Yakubu, yas kǝ Yohana eka na bar sǝɓǝri. ");
INSERT INTO plj_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Nan tǝ shin'e mǝn Yahuda kum tǝmi kǝ bar tu tǝ piwo, arni tǝ pa nǝm Bitǝrus. Muntu pini wokoci kǝ Nyel Jikat Bǝdlabǝni. ");
INSERT INTO plj_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Den kaar kǝ nǝmi gǝso, arni tǝ la ti gip bom kǝ moni, ba la ti am dǝ me gam kǝ mǝn bi-utu gudǝli wupse. Hiridus pǝn tor gip mbatl gǝs den tǝ ɗǝli Bitǝrus kǝ tloyi ti shirǝm cina dǝ mbarǝm den kaar kǝ Nyel Jikat Bǝdlabǝni. ");
INSERT INTO plj_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Nan Bitǝrus ra na le gip bom kǝ moniyiwo, arni mǝn kopi kur gǝs gip shirǝm na Yam domici gǝsi. ");
INSERT INTO plj_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Kǝ gasi, ba wule gǝni Hiridus ba ɗǝli ti dǝ tloyi ti shirǝmo, Bitǝrus den nde umur gip dlom kǝ mǝn bi-utu rop. Ɓal tǝka na sarsari rop, kan na mǝn ne ger den ti dlor bǝdlabǝn bom kǝ moniyi. ");
INSERT INTO plj_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Bat na momi, arni mǝn kartǝn kǝ Yam gon ɗǝl kar Bitǝrus, kan gip bom kǝ moniyi ba cirka. Mǝn kartǝn kǝ Yami ɓo Bitǝrus den bǝbyala tǝ putu tǝka. Kan tǝ wule, <<Zho'i kǝ tlyami!>> Arni sarsariyi pǝtl ter am dǝ Bitǝrus ka. ");
INSERT INTO plj_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Mǝn kartǝn kǝ Yami wul ti'e, <<Kem tutul dli na kaptǝlan gi.>> Nan Bitǝrus pi untuwo, arni mǝn kartǝn kǝ Yami wul ti'e, <<Dlǝmat bar lulur gika kǝ kopǝni.>> ");
INSERT INTO plj_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Kan Bitǝrus ba kop ti wu ɗǝl ter kari, ama tǝ mom dyatlǝm argon tu mǝn kartǝn kǝ Yami ba pi gwa da'a, tǝ wule ko ruya ni tǝ shini. ");
INSERT INTO plj_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Kan wu bi kaar mǝn ɓuti bǝdlabǝn kǝ nǝm na kǝ ropi, wu mbubar kar bǝdlabǝn kǝ gǝlla kan ba kop dǝ su gip bǝn gwa. Arni bǝdlabǝni ɓuli wur na gam gǝsi, kan wu ɗǝl kaari. Nan wu kop tlyartǝn kǝ tǝpewo, wule gip njibkǝr gere, arni mǝn kartǝn kǝ Yami za ti. ");
INSERT INTO plj_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Nan gam ceti Bitǝruso arni tǝ wule, <<Kǝkǝno a mom wi'e Babom Yam ni kar mǝn kartǝn bar gǝs kan tǝ ɗǝlim am dǝ Hiridus na kup argon tu mǝn Yahuda ba ndu pim gwa.>> ");
INSERT INTO plj_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Nan Bitǝrus mom untuwo, arni tǝ ri bom dǝ Maryamu nasi Yohana, muntu ba la ti bi'e Markus gwa, las tu mbarǝm dom wur wu den shirǝm na Yam gwa. ");
INSERT INTO plj_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Bitǝrus ɓo bǝdlabǝn tetǝn gip bomi, kan zher nye gǝr gon mǝn sun'e Roda ba ɗǝl ter kǝ ɓuli bǝdlabǝni. ");
INSERT INTO plj_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Nan tǝ kum yar kǝ Bitǝrusno, tǝ laa na ghol mbatl naari, arni ma tǝ'i ɓul bǝdlabǝni da'a kan tǝ pal na kǝtǝr te gipi ka, tǝ wule, <<Bitǝrus ni dlor te kaari ka!>> ");
INSERT INTO plj_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Arni wu wul ti'e, <<Gam pǝtli ika wi!>> Ama nan tǝ kǝrceka den untuno, arni wu wule, <<Ar ba ni'e mǝn kartǝn kǝ Yam kan ra nan ti gwa ni!>> ");
INSERT INTO plj_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ama Bitǝrus pi ta ɓe bǝdlabǝni. Nan wu ɓul bǝdlabǝn wu shin tǝwo, arni wu nǝm bi na ame. ");
INSERT INTO plj_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Bitǝrus pi wur am kǝ dǝ wu yoni, arni tǝ yari wur kandatu Babom ɗǝli ti gip bom kǝ moniyi gwa. Kan tǝ wul wur'e, <<Yarini Yakubu na nami mir ɓyar argon tu pi gwa.>> Kan tǝ za lasi tǝ ndara kǝtǝgoni. ");
INSERT INTO plj_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Kǝ cigǝniwo, bǝrti na ghuntǝn nda gip dlom kǝ mǝn bi-utuyi naari, den argon tu nan ndo na Bitǝrus gwa. ");
INSERT INTO plj_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Hiridus Agǝripa kem ba kop las kup kǝ ngeni Bitǝrus ama wu zam ti da'a, arni tǝ ngen momi kar mǝn ɓutiyi kan tǝ tloyi wur shirǝm den dǝ ri wur eka. Arni Hiridus za atl kǝ Yahudaka tǝ ndara Kaisariya, tǝ nye dǝm lasi. ");
INSERT INTO plj_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Hiridus na mbarǝm kǝ Taya na mǝn Sidon den ta tli yar yami, arni wu mo gam kan wu ngen dǝmi nan ti. Nan wu zam Bǝlastus, bar zher kǝ gunyi nde wur kaaro, arni wu ngen dǝmi zhǝlili, domici atl kǝ Hiridus ni ba zami atl gǝzǝn fingali. ");
INSERT INTO plj_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Den pǝt tu kan newo, arni Hiridus la bar lulur gǝs kǝ Gunye, tǝ dǝm den badǝmi gǝsi kan tǝ shirǝm na mbarǝme. ");
INSERT INTO plj_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Arni wu la yar wu wule, <<Yar kǝ yam gon utu, kǝ mbarǝm ni da'a.>> ");
INSERT INTO plj_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","An ri kǝtǝgon da'a, nan Hiridus bi nartǝn Yam dawo, arni mǝn kartǝn kǝ Babom Yam gon ɓo ti atli, zhimbǝr ba ci dli gǝska kan tǝ mǝshka. ");
INSERT INTO plj_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ama mir mǝn kopi Yesu ci cina na yari shirǝm kǝ Yam ko-ako kan mbarǝm na womti ba ngǝsh wur den Yesu. ");
INSERT INTO plj_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Gip wokoci tu nan Barnaba na Shawulu pa'i argon tu si wur Urushalimawo arni wu pal gǝzǝn to Antakiyaka, kan wu pǝn Yohana nan wuri, muntu kan ba pa la ti bi'e Markus gwa. ");
INSERT INTO plj_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Gip domtǝn kǝ mǝn kopi kǝ Antakiyawo mǝn yari Zo Shirǝm kǝ Yam na mir mǝn kulci mbarǝm ra. Wi ni'e ga Barnaba, na Simon kan ba la ti bi'e Dun Mbarǝm gwa. Na ga Lukiyas mbarǝm kǝ Sairin, Manayan (muntu kan nar na Hiridus Antipas gwa) na Shawulu. ");
INSERT INTO plj_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Nan wu den bote Babom na guzum malo, arni Ruhu kǝ Yam wule, <<Nem ni Barnaba na Shawulu markǝme kǝ pi mbap tu kan a la wur bi ragwa.>> ");
INSERT INTO plj_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Nan wu pa'i guzum maliwo, kan wu shirǝm na Yami, arni wu ne wur am den gami kan wu za wur wu ndara. ");
INSERT INTO plj_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Wi rop juwo Ruhu kǝ Yam ni kar wuri, kan wu su Salukiya wu to gip kungǝlǝn jikat mal wu te den atl kǝ Saipǝros. ");
INSERT INTO plj_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Nan wu mbubar gip bǝn Salamiso, arni wu pi wazu shirǝm kǝ Yam te gip bom domtǝn kǝ mǝn Yahudaka. Yohana Markus mǝn ne wur am ra nan wuri. ");
INSERT INTO plj_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Kan wu kop gip bǝni kan te dlom bar ɓula kagwa wu mbubar bǝn kǝ Pafos. Barta ni wu mo na mbarǝm kǝ Yahuda mǝn war goni, mǝn yari shirǝm kǝ Yam kǝ lar gon mǝn sun'e Bar-Yeshu'a. ");
INSERT INTO plj_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Tǝ ngash gam gǝs na gobna Sarjiyas Bulus. Gobnayi mom bar naari, arni tǝ kar bar den ga Barnaba na Shawulu domici tǝ ndu tǝ kum shirǝm kǝ Yami. ");
INSERT INTO plj_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ama Elimas mǝn wari (domici untun sun gǝs ra na bi kǝ mǝn Hellas) nge wuri. Tǝ pi ta ngeni tǝp den ba dǝ gobnayi ngǝsh ti den Yesu den argon tu Barnaba na Shawulu kulci mbarǝm gwa da'a. ");
INSERT INTO plj_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Arni Shawulu muntu ba pa la ti bi'e Bulus gwa, laa'i na Ruhu kǝ Yam wi ger mǝn wari kan tǝ wule, ");
INSERT INTO plj_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","<<Kiwo wule Shetan ni kira, mǝn gapa na kup argon tu kan dlat gwa! Kǝ laa'i wi na kup tǝp kǝ ɗasi tu na setǝne. Ki za ndu'i zhimbǝl bar kǝ Yam kan untun anra na yari argon den Yam kan untun anra gwa da'aya? ");
INSERT INTO plj_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Kǝkǝno am kǝ Babom Yam kǝ hukuntetǝn baa sur den ki. Ki te tabi ka. Ki hol mani shini pǝt kǝ wokoci goni.>> An ri kǝtǝgon da'a, arni argon wule ɓondi na dǝmǝn nǝmi tǝ gerka. Tǝ nǝm kari ame, tǝ den ngeni muntu ba nǝmi ti am gwa. ");
INSERT INTO plj_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Nan gobnayi shin argon tu kan piwo, arni tǝ ngǝsh ti den Yesu, domici kulci den Yesuyi dlǝkǝn ti. ");
INSERT INTO plj_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Nan Bulus na ga berǝm ɓomi asǝm gǝs za Pafosa gip kungǝlǝn jikat malo, arni wu ndara bǝn kǝ Paga kan gip atl kǝ Pamfiliya gwa. Lasi ni Yohana Markus za wur kan tǝ pal gǝs su Urushalimaka. ");
INSERT INTO plj_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Nan wu za bǝn kǝ Pagawo, arni wu ndara bǝn kǝ Antakiya gip atl kǝ Pisidiya. Den pǝt Asabaro wu te gip bom domtǝn kǝ mǝn Yahuda wu dǝmi. ");
INSERT INTO plj_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Den kaar zhiti gip Kulci kǝ Musa na gip rǝshi tǝlankur kǝ mǝn yari shirǝm kǝ Yamo, arni kiri kǝ bom domtǝn kǝ mǝn Yahudayi kar gon tǝ wul wur'e, <<Mir ɓyari, kǝn nǝra na shirǝm kǝ ɓa'i mbarǝm bigulo, mǝ lir kǝn kǝ yarini.>> ");
INSERT INTO plj_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Arni Bulus tlyami, tǝ pi am kǝ dǝ wu yoni, kan tǝ wule, <<Mir ɓyar mbarǝm kǝ Isra'ila nan kǝn kan mǝn Yahuda ni da'a kan ba bote Yam gwa, kumǝn ni! ");
INSERT INTO plj_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Yam kǝ mbarǝm gǝmi mǝn Isra'ila zǝzar ga ba gǝmi. Tǝ kem wur kǝ womtitǝn wokoci dǝmi gǝzǝn gip Masar, kan na bar ndǝrtǝn kǝ yar am tǝ ɗǝli wur ter gip atl ta. ");
INSERT INTO plj_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Kup na wu pi ta nge kopi shirǝm gǝska, tǝ pi ta ne ger den wur gip lǝp tu kan murgon ba dǝm da'a bar kǝ sheti ghon hauya-rop. ");
INSERT INTO plj_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Den kaar kǝ untuwo, tǝ piika na atl nyingi kǝ gip Kan'ana. Tǝ bi atl gǝzǝn mbarǝm gǝs kǝ dǝ ar dǝm gwazini. ");
INSERT INTO plj_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Kup munju pi ni gip sheti ghon hauya kǝba lasi hauya nǝm na rop na kutl (450). <<Den kaar kǝ untuwo, Yam bi wur mǝn tloyi shirǝm kan baa nde wur cina gwa ar ba ri wokoci kǝ mǝn yari shirǝm kǝ Yam Sama'ila. ");
INSERT INTO plj_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Kan wu liri den dǝ bi wur gunye, arni Yam bi wur Saul nya Kish. Tǝ kǝ gip gǝsgal kǝ Bilyaminu ni, kan tǝ dǝm gun gǝzǝn kǝ sheti ghon hauya rop. ");
INSERT INTO plj_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Den kar kǝ shu'i Saul den dǝmi gun kawo, tǝ pali Dauda tǝ dǝm gun gǝzǝni. Yam yari den ti'e, <A zam Dauda nya Jesse wi. Ti badǝr mbarǝm mǝn mbatl tu a ndu gwani. Ti pi kup argon tu a ndu tǝ pi gwa.> >> ");
INSERT INTO plj_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","<<Tǝp kar gǝsgal kǝ mbarǝm tu ni Yam ɗiri Isra'ila Yesu Mǝn Ɗǝli Mbarǝme, kandatu tǝ wule ti pi gwa. ");
INSERT INTO plj_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Kapǝn ɗirtǝn kǝ Yesuwo, Yohana pi kup mbarǝm kǝ Isra'ila wazu kǝ ci atl gam kar Yam wi kan tǝ pi wur batisma. ");
INSERT INTO plj_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Nan Yohana mbi kosak na pa'i mbap gǝso, tǝ wule, <Kǝ wulem'e ami woni? Ami ni'e Almasihu da'a. O'o, ama tǝ den ɗirtǝn den kaar gǝn njem. A kǝm pǝtli zap kaptǝlan gǝs ter asǝm da tika da'a.> ");
INSERT INTO plj_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","<<Mir ɓyar gǝsgal kǝ Ibǝrahim, na kup gin kan mǝn Yahuda ni da'a kan ba bǝrti Yam gwa, mǝn ni kari mi bar na shirǝm kǝ zami ɗǝltǝne. ");
INSERT INTO plj_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Kup na wu kur zhit argon tu mǝn yari shirǝm kǝ Yam rǝsh kup wokoci tu wu dom wur kǝ ba bota gwa ama wu mani momi argon tu mǝn yari shirǝm kǝ Yam ju yari gwa da'a. Arni kiri kǝ mǝn Yahuda ju wule dǝ ri ti eka. Na untuni wu kem argon tu ga mǝn yari shirǝm kǝ Yami yari'e ba pi gwa laa'i. ");
INSERT INTO plj_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Kup na wu mani zami argon tu baa kem dǝ ri ti eka gwa da'a, ama wu lir Bilatus den wu ndu dǝ ri ti eka. ");
INSERT INTO plj_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","<<Nan wu pa'i pi kup bar ju shirǝm kǝ Yam yari den tiwo, wu shu ti sur den rati kini kan ɓa ti dene gwa, kan wu la ti gip gambǝci'e. ");
INSERT INTO plj_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ama Yam tli tika gip mǝshi mbarǝme. ");
INSERT INTO plj_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Kǝ muri na womti munju ɓom asǝm nan ti, argon tu pǝn gip atl kǝ Galili ba su Urushalima gwa shin ti. Kǝkǝno wi ni'e mǝn yari mbarǝm gǝmi bar ju wu shin na ger gǝzǝn gwa. ");
INSERT INTO plj_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","<<Mǝ yari in ni Zo Shirǝmi. Argon tu Yam wule ti pii ga ba gǝmi wo ");
INSERT INTO plj_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","tǝ pi mi wi, mǝn mimir gǝzǝni, tǝp kǝ ba tli Yesu gip mǝshi mbarǝme. Kandatu anra na rǝshi gip Zabura kǝ rop'e, <Ki nya gǝn ni, Sekǝn ni a dǝmi'i Bǝba.> ");
INSERT INTO plj_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Yam tli Almasihu gip mǝshi mbarǝme, ti'i mǝsh da'a. Den kǝn ni ar ba shirǝm'e, <Na ho bi, aa ne in am ra kandatu a wul Dauda'e aa pi ti gwa.> ");
INSERT INTO plj_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Tǝ pa yari den Almasihu gip Zabura gon'e, <Ki za Zo'i gi kan kǝ ne markǝm gwa tǝ moka gip gambǝci da'a.> ");
INSERT INTO plj_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","<<Nan Dauda pi argon tu Yam ndu tǝ pi gip zhan gǝso, kan tǝ mǝshka. Tǝ es wule ga base, kap tǝka kan dli gǝs ba moka. ");
INSERT INTO plj_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ama muntu kan Yam tli ti gip mǝshiyiwo tǝ moka da'a. ");
INSERT INTO plj_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","<<Ra'untuwo, mir ɓyari, kum ni! Gip mbarǝm tu Yesu ni pǝni warwat pitǝn ginka ra. ");
INSERT INTO plj_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Kup muntu kan ngǝsh den tiwo wi zam ɗǝltǝn gip kup bar ju Kulci kǝ Musa hol ɗǝli gin gipi gwawi. ");
INSERT INTO plj_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ngup kǝnni, ba dǝ argon tu ga mǝn yari shirǝm kǝ Yam yari laa'i den kǝn da'a. Domici wu wule, ");
INSERT INTO plj_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","<Kum ni, kǝn kan kǝ mburǝmka gwa, nǝm ni bi na am gip dlǝkǝntǝne kǝ mǝsh nika! Ari kǝ pi argon gip muri gini. Ki nǝm den aa pi da'a ko murgon ni yari in gwa.> ");
INSERT INTO plj_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","<<Nan Bulus na Barnaba den za'i bom domtǝn kǝ mǝn Yahudayiwo, arni mbarǝm lir wur den wu ɗir den zut Asabar wu shirǝm ra den bar ju. ");
INSERT INTO plj_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Nan mbarǝm ju dom wur gwa ba za lasiwo, arni na womti kǝ mǝn Yahuda na munju ba bote Yam kan mǝn Yahuda ni da'a kop Bulus na Barnaba. Arni wu shirǝm nan wur kan wu ɓa'i wur bigul den wu ci cina na ngǝshtǝn den zo mbatl kǝ Yam kup na wu ndari dǝ Yam pi wur untu dagwa. ");
INSERT INTO plj_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","<<Den zut pǝt Asabaro, njem ni dǝ wule kup bǝni dom wur kǝ kumi shirǝm den Babom Yesu. ");
INSERT INTO plj_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Nan mǝn Yahuda shin womtitǝn kǝ mbarǝmo, arni ghuve nǝm wuri kan wu pi zhe'e shirǝm den argon tu Bulus ba yari gwa. ");
INSERT INTO plj_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","<<Kano Bulus na Barnaba ba nǝmi wur bat na bǝrti wu wule, <Ar nǝm den kǝn ni mi pare yari in shirǝm kǝ Yami. Ama kǝn den nge shirǝm kǝ Yami. Na pi untuwo kǝ gode'e kǝ ndari zami rai kan ba pa da'i da gwa. Mǝ za kǝn mǝ pal kar munju kan mǝn Yahuda ni dagwawi. ");
INSERT INTO plj_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Domici argon tu Babom wule mǝ pi gwa ni'e, <<Aa pali in kǝ dǝm cirtǝn kar munju kan mǝn Yahuda ni dagwa, kǝ dǝ atl kundǝrǝndlip zam ɗǝltǝne.>> ");
INSERT INTO plj_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Nan kup munju kan mǝn Yahuda ni da'a kum shirǝm tuwo, wu pi ghol mbatli. Wu ɗǝɗa shirǝm kǝ Babom Yesu, na kup munju kan mǝn Yahuda ni da'a kan Yam ne wur kǝ zami rai kan ba pa dagwa ngǝsh wur den Yesu. ");
INSERT INTO plj_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Shirǝm kǝ Babom ri ko ako gip kǝti atliyi. ");
INSERT INTO plj_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ama mǝn Yahudayi tli mbatl mǝtli mǝn bǝrti Yam kan ba kum nan wur gwa na kiri kǝ bǝni. Wu tli ga Bulus na Barnaba gami, kan wu ɗǝli wur gip atl gǝzǝnka. ");
INSERT INTO plj_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Arni wu bat kushka kǝ den asǝm gǝzǝnka gip seda den nge wur wi, kan wu ndara Ikoniya. ");
INSERT INTO plj_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Kup mǝn kopi Yesu laa'i na ghol mbatl na Ruhu kǝ Yami. ");
INSERT INTO plj_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Bulus na Barnaba ra gip Ikoniyawo arni wu te gip bom domtǝn kǝ mǝn Yahuda kandatu wu kur pi gwa. Kan wu pi wazu hoyi kan kem mǝn Yahuda na munju kan mǝn Yahuda ni da'a na womti pal mǝn ngǝshtǝn den Yesu gwa. ");
INSERT INTO plj_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ama mǝn Yahuda ju kan nge ngǝshtǝn den Yesu tli mbatl yam munju kan mǝn Yahuda ni dagwa, zam wu shin mir ɓyari na dun gere. ");
INSERT INTO plj_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ra'untuwo arni Bulus na Barnaba dǝm lasi kǝ muri na womti, wu den shirǝm bat na bǝrti den Babom Yesu muntu kop kar kǝ wazu kǝ zo mbatl gǝs tǝp kǝ ba bi wur mani pi bar kǝ nǝmi bi na am na dlǝkǝntǝn gwa. ");
INSERT INTO plj_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Arni mbarǝm kǝ bǝni tatlka bomi rop, jen den kopi kaar kǝ argon tu mǝn Yahudayi yari gwa, jen ngapo wu den kopi kar kǝ argon tu mir mǝn kartǝni yari gwa. ");
INSERT INTO plj_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Arni jen gip mǝn Yahuda na jen munju kan mǝn Yahuda ni da'a, na kǝ cina gǝzǝn ba gudlumi kǝ dǝ wu pi zhe'e mbap mir mǝn kartǝni kan wu la wur na tate. ");
INSERT INTO plj_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ama mir mǝn kartǝni zam na momika kan wu kǝtǝr gǝzǝn gip bǝn kǝ Listǝra na kǝ Darba gip Likoniya na bi lǝp gǝzǝni. ");
INSERT INTO plj_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Lasi ni wu ci cina na pi wazu kǝ Zo Shirǝm kǝ Babom Yesu. ");
INSERT INTO plj_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Gip Listǝrawo, kurki gon ra ba kur dǝm muntu ra untu na gǝri gǝs gwa tǝ mani desi atl da'a. ");
INSERT INTO plj_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Tǝ kum Bulus nan ti den shirǝm gwa. Arni Bulus wi ti gere kan tǝ shin mbarǝmi na ngǝshtǝn den Yesu kan baa mani pǝni ti kumi dli gǝska gwa. ");
INSERT INTO plj_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Kan Bulus ba tli yar tǝ wule, <<Tlyam kǝ dlǝr den asǝm gi!>> Warkǝca arni mbarǝmi tlyam tǝ nǝm desi atli. ");
INSERT INTO plj_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Nan womti mbarǝmi shin argon tu Bulus piwo, arni wu tli yar yam gip bi gǝzǝn kǝ mǝn Likoniya wu wule, <<Ga yam sur kar miwi na dli kǝ mbarǝme!>> ");
INSERT INTO plj_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Kan wu la bi Barnaba Zeyus, Bulus ngapo wu la ti bi Hames, domici ti ni'e gun shirǝmi. ");
INSERT INTO plj_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Arni lǝɓa kǝ yam Zeyus, muntu kan bom kǝ bote ti ra kaar bǝni, ba ɗiri ga tla na ga buzǝn kin bǝdlabǝn bǝni, domici ti na kup womti mbarǝmi ni den ndu'i wi mbosh dabba gip bote mir mǝn kartǝni. ");
INSERT INTO plj_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ama nan Barnaba na Bulus mir mǝn kartǝni kum untuwo, arni wu tlyati tutul dli gǝzǝnka. Wu kop gip dlom womti mbarǝmi na kǝtǝre wu den la'i yar na wultǝn'e, ");
INSERT INTO plj_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","<<Unun kem kǝ pi untuwu? Mǝn ma mbarǝm ni katl, mǝn dli wule kǝne. Mǝ ɗiri in ni Zo Shirǝmi, mǝ yari in den kǝ bali ni kar bar ju kan argon ni da'a kǝ pal ni kar Yam mǝn rai. Ti ni'e muntu kan pi yam na atl na bar ɓula, na kup bar ju gip wurgwa. ");
INSERT INTO plj_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Terkawo, tǝ za mbarǝm kan den kar bar atl kup wu kop tǝp tu kan wu shin mbuni wur gwa. ");
INSERT INTO plj_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ama kup na untu tǝ za gam gǝs bat na seda tu kan baa mom'e tǝra gwa da'a. Tǝ gode mbarǝm zo mbatl gǝs tǝp kǝ ba bi in ghon sur yami na bar kǝ gip kǝn den wokoci gǝzǝni. Ti ni tǝ bi in fingal ar kǝm kǝn kan tǝ laa'i in na ghol mbatli.>> ");
INSERT INTO plj_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Kup na shirǝm juwo, njem ni arsa dǝ womti mbarǝmi mboshi wur dabba gip bote wuri. ");
INSERT INTO plj_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Kan mǝn Yahuda jen ba tli tor Antakiya na Ikoniya gip atl kǝ Pisidiya kan wu zam gam kǝ womti mbarǝmi. Wu la Bulus na tat wu dǝl ti kaar bǝni, wu pǝn'e tǝ mǝsh kawi. ");
INSERT INTO plj_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ama nan mǝn kopi dom wur wu la ti dlomo, arni tǝ tlyam tǝ pal te gip bǝnika. Bar tlowo arni wu ndara Darba nan ti na Barnaba. ");
INSERT INTO plj_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Wu pi wazu Zo Shirǝm kǝ Yesu gip Darba kan wu zam mir mǝn kulci kar wur na womti. Arni wu pal gip bǝn Listǝra na Ikoniya na Antakiyaka gip atl kǝ Pisidiya. ");
INSERT INTO plj_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Wu pi ta ndǝri na ɓa'i wur bigul gip ngǝshtǝn den Yam gǝzǝni. Wu wule, <<Ar nǝm mi mǝ kop gip kumi dli na womti kan mǝ mani zami tetǝn gip las tu Yam baa dǝm gun gǝmi baa patǝn gwa.>> ");
INSERT INTO plj_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Bulus na Barnaba ne wur kiri mǝn kopi nan wur gip kogonge ba domtǝn kǝ mǝn kopi. Na shirǝm na Yam na guzum male, arni wu la wur am dǝ ne ger kǝ Babom Yesu, muntu wu ngǝsh wur den ti gwa. ");
INSERT INTO plj_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Den kar kǝ kopi gip atl kǝ Pisidiyawo, arni wu mbubar Pamfiliya. ");
INSERT INTO plj_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Nan wu pi wazu shirǝmi gip bǝn Pagawo, kan wu ndara Ataliya. ");
INSERT INTO plj_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Nan wu za Pagawo kan wu pal na kar su Antakiyaka gip kungǝlǝn jikat male, las tu wu la wur gip zo mbatl kǝ Yam den mbap tu kan wu'i pa'i gwa. ");
INSERT INTO plj_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Nan wu mbubar gip bǝn Antakiyawo, arni wu dom mǝn kopi kǝ ba lasi nǝm. Wu yari wur kup bar ju Yam pi tǝp kar wur gwa, na kandatu Yam ɓuli bǝdlabǝn ngǝshtǝn den Yam munju kan mǝn Yahuda ni dagwa. ");
INSERT INTO plj_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Kan wu dǝm lasi na mǝn kopi Yesu kǝ muri na womti. ");
INSERT INTO plj_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Wokoci tu Bulus na Barnaba ra gip bǝn kǝ Antakiya gip atl kǝ Siriyawo, arni mǝn Yahuda jen kan ba kop Yesu ba tli tor Yahuda wu su Antakiya kan wu nǝmi kulci mir ɓyar'e, <<In sǝr kini den kandatu Kulci kǝ Musa yari gwa dawo, ki zam ɗǝltǝn gip warwat pitǝn kar Yam da'a.>> ");
INSERT INTO plj_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Muntu ɗiri Bulus na Barnaba musu nar na bali shirǝm nan wuri. Arni mir mǝn kopi ne bi den dǝ Bulus na Barnaba, na mǝn kopi jen gip Antakiya su Urushalima wu shin mir mǝn kartǝni na kiri mǝn cina kǝ mǝn kopi den shirǝm tu. ");
INSERT INTO plj_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Domtǝn kǝ mǝn kopi la wur tǝpe, arni den tǝp gǝzǝno wu kop gip bǝn Finiks na Samariya, kan wu yari wur kandatu munju kan mǝn Yahuda ni da'a pal kar Yamwu gwa. Shirǝm tu gholi mbatl mir ɓyar kup kǝ mir bǝn ju. ");
INSERT INTO plj_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Nan wu mbubar gip Urushalimawo, arni mir mǝn kopi na mir mǝn kartǝni na kiri mǝn cina kǝ domtǝn kǝ mǝn kopi pi ɗem nan wuri. Wu yari wur bar ju kup Yam pi tǝp kar wur gip munju kan mǝn Yahuda ni dagwa. ");
INSERT INTO plj_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ama jen gip mǝn kopi Yesu kan gip me gam kǝ mǝn Parise tlyam dlor kan wu wule, <<Munju mǝn Yahuda ni da'a kan ngǝsh wur den Yesuwo, ar nǝm wur te yarka dǝ sǝr wuri kan wu kop Kulci kǝ Musa.>> ");
INSERT INTO plj_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Arni mir mǝn kartǝni na kiri mǝn cina kǝ mǝn kopi mo gam den bi zhiti shirǝm tu. ");
INSERT INTO plj_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Den kar kǝ tlyari bali shirǝmo, kan Bitǝrus ba tlyam tǝ shirǝm nan wur nan kǝni, <<Mir ɓyari, kǝ mom'e wokoci gon terkawo Yam zǝzarǝm gip kǝn kǝ dǝ a pi wazu kǝ Zo Shirǝm kǝ Yesu dǝ munju kan mǝn Yahuda ni dagwa, kǝ dǝ wu ngǝsh wur den tira. ");
INSERT INTO plj_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Yam kan mom mbatl kǝ mbarǝm gwa gode'e tǝ nǝm munju kan mǝn Yahuda ni da'a tǝp kǝ ba bi wur Ruhu gǝsi, kandatu tǝ bi mi gwa. ");
INSERT INTO plj_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Tǝ pali mbatl gǝzǝn dlǝran tǝp kǝ ba ngǝshtǝn den Yesu wi. Na untun tǝ gode'e bom ni mǝn ra nan wur da'a. ");
INSERT INTO plj_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Kǝkǝno, unun kem kǝ ndu kǝ kem Yam kǝ pi lo'e, tǝp kǝ ba ne mǝn kopiyi gosgam muntu kan min na ga ba gǝmi mani pǝni dagwawu? ");
INSERT INTO plj_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","O'o! Mǝ mom'e Yam ɗǝli ni kup gǝmi tǝp kar zo mbatl kǝ Babom gǝmi Yesu. Nǝm untuni Yam ɗǝli munju kan mǝn Yahuda ni dagwa.>> ");
INSERT INTO plj_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Kup munju ra lasi sa shot wu den damtǝn den argon tu Bitǝrus yari gwa. Den kariwo kan Barnaba na Bulus ba yari bar kǝ nǝmi bi na am na dlǝkǝntǝn ju kup kan Yam pi tǝp am da wur dǝ munju kan mǝn Yahuda ni dagwa. ");
INSERT INTO plj_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Nan wu pa'i shirǝmo, arni Yakubu shirǝm tǝ wule, <<Mir ɓyari, kumǝn ni! ");
INSERT INTO plj_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon Bitǝrus yari mi kandatu Yam gode'e tǝ ra na munju kan mǝn Yahuda ni da'a su mbatlka tǝp kǝ ba yemi gip wur den wu dǝm mbarǝm gǝsi. ");
INSERT INTO plj_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Shirǝm kǝ ga mǝn yari shirǝm kǝ Yam kop kaar kǝ mǝnkǝni, kandatu anra na rǝshi gwa'e, ");
INSERT INTO plj_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","<Den kaar kǝ muntuwo aa pali, kan a tli bom kǝ Dauda kan ndaka gwa, Aa pa tu nami dli bini, Aa tli ti peli esi, ");
INSERT INTO plj_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Kǝ dǝ nami mbarǝm kan sa gwa ngen Babomi, na kup munju kan mǝn Yahuda ni da'a kan ba la wur bi na sun gǝn gwa, Babom ni yari, ");
INSERT INTO plj_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Muntu kan kem ba mom bar ju terka gwa.> ");
INSERT INTO plj_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","<<Gi shini gǝno, ba mǝ kem ar dǝm banyi bar kar munju kan mǝn Yahuda ni da'a kan den paltǝn kar Yam gwa. ");
INSERT INTO plj_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Mǝn de mǝ rǝshi wur ni tǝlankuri. Gip tǝlankuriwo mǝ yari wur den ba wu ci fingal tu kan ta'i tat war gwa da'a. Ba wu la gam gǝzǝn gip muri na mǝtli ko moni kari da'a. Ba wu ci tlu kǝ dabba tu kan ceni ti yarka gwa da'a, na ci tlu na bǝrani. ");
INSERT INTO plj_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","A yari ni untu domici den pi wazu kǝ kulci kǝ Musa gip kogonge bǝn terka kan ba zhit gip bom domtǝn kǝ mǝn Yahuda den pǝt Asabar kup gwa.>> ");
INSERT INTO plj_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Kano mir mǝn kartǝn kǝ Yesu na kiri mǝn cina kǝ domtǝn kǝ mǝn kopi na kup mir mǝn kopi ba kop kar kǝ argon tu Yakubu yari gwa. Kan wu pǝn gip mbatl gǝzǝn den wu zǝzar mbarǝm rop kan wu kar wur gip bǝn Antakiya gip atl kǝ Siriya na ga Bulus na Barnaba. Munju wu zǝzari gwa ni'e Yahuda (kan ba la ti bi'e Barsaba gwa) na Sila, rop gip kiri mǝn cina kǝ domtǝn kǝ mǝn kopiyi. ");
INSERT INTO plj_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Kan wu kar wur na tǝlankur kǝni. Mir mǝn kartǝn kǝ Yesu na kiri mǝn cina kǝ domtǝn kǝ mǝn kopi, mir ya'ǝni, Dǝ si munju kan mǝn Yahuda ni da'a kan ngǝsh wur den Yesu kan gip Antakiya, Siriya na Kilikiya gwa. Mǝ shirmi inka. ");
INSERT INTO plj_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Mǝ kum den'e jen ra kan ɗǝl gip mi ba'e na bi gǝmi ni da'a kan wu ghun kǝne. Wu tli in mbatl na argon tu wu yari gwa. ");
INSERT INTO plj_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Arni kem mǝ me bi den mǝ zǝzar mbarǝm jen kan mǝ kar wur kar kǝne na ga berǝm gǝmi Barnaba na Bulus, ");
INSERT INTO plj_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","mbarǝm ju kan wur mbatl gǝzǝnka den bi kǝ Babom gǝmi Yesu Almasihu gwa. ");
INSERT INTO plj_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ra'untuwo, arni mǝ kari in bar na Yahuda na Sila kǝ dǝ wu kop kari na yari in argon tu mǝ rǝsh gwa. ");
INSERT INTO plj_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ruhu kǝ Yam kop nan mi den ba dǝ mǝ ne in argon gam bom na mǝnjin kan ba ndu kar kǝn gwa da'a. ");
INSERT INTO plj_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Dǝm ni bat na ci fingal tu kan ta'i tat war gwa, na ci tlu na mbǝrani. Ba kǝ cini tlu kǝ dabba tu kan ceni ti yarka gwa da'a. Ba kǝ la ni gam gin gip muri na mǝtli na moni ko moni na mǝtli kari da'a. Arba mbuni ine kǝn ni kǝ pi munju gwa. Dǝ ar mbuni ine. ");
INSERT INTO plj_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Kan ba la munju kan kar wuri gwa tǝpe wu ndara Antakiya, las tu mir mǝn kopiyi dom wur gwa kan wu bi wur rǝshi tǝlankuri. ");
INSERT INTO plj_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Wu zhit gipiwo ar gholi wur mbatl na shirǝm ɓa'i bigul tu kan ra gipi gwa. ");
INSERT INTO plj_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Arni Yahuda na Sila, munju kan mǝn yari shirǝm kǝ Yam ni, pi tlyari shirǝmi, den bi ɓa'i wur bigul na ndǝrtǝn kǝ mir ɓyar gip ngǝshtǝn gǝzǝn den Yesu. ");
INSERT INTO plj_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Nan wu ɓom dǝmi nan wur lasiwo, arni mir ɓyari la wur tǝp na ghol mbatl kǝ dǝmi zhǝlili kan wu pal rin kar munju kan kar wur gwa. ");
INSERT INTO plj_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","(Ama Sila shin ar mbun tǝ dǝm lasi) ");
INSERT INTO plj_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ama Bulus na Barnaba dǝm gip bǝn Antakiya, las tu wi na jen na womti kulci mbarǝm na pi wazu shirǝm kǝ Babom gwa. ");
INSERT INTO plj_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Den kaar kǝ wokoci gono Bulus wul Barnaba'e, <<Naa mǝ kop kaar kǝ mir ɓyar gip bǝn ju kup mǝ pi wazu shirǝm kǝ Babom gwa, mǝ shin ci cina kǝ ngǝshtǝn den Yesu gǝzǝni.>> ");
INSERT INTO plj_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnaba ndu wu pǝn Yohana, kan ba pa la ti bi'e Markus gwa, nan wuri. ");
INSERT INTO plj_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ama Bulus shino ar mbun dǝ ri nan ti da'a, domici tǝ ndara tǝ za wur ka gip Pamfiliya, tǝ mani ci cina gip mbap nan wur da'a. ");
INSERT INTO plj_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Wu tli yar yam naar den shirǝm tu, kan kogonge ba pǝn tǝp gǝsi. Barnaba pǝn Markus kan wu to gip kungǝlǝn jikat mal wu ndara Saipǝros. ");
INSERT INTO plj_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Bulus ngapo tǝ pǝn Sila kan wu ndara, nan mir ɓyar la wur gip am na ne ger kǝ zo mbatl kǝ Babom gwa. ");
INSERT INTO plj_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Tǝ kop gip atl kǝ Siriya na Kilikiya tǝ den ndǝri dlǝri kǝ domtǝn kǝ mǝn kopi. ");
INSERT INTO plj_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Bulus mbubar Darba kan tǝ ndara Listǝra, las tu mǝn kopi gon ra mǝn sun'e Timoti. Naso mǝn Yahuda ni, mǝn ngǝshtǝn den Yesu, ama baso mǝn Hellas ni. ");
INSERT INTO plj_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Mir ɓyar kan gip bǝn Listǝra na Ikoniya pi shirǝm kǝ ho bar den ti. ");
INSERT INTO plj_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Bulus ndu tǝ ri na Timoti gip ɓomi asǝm gǝsi, arni tǝ sǝr tǝka den bi kǝ mǝn Yahuda kan ba dǝm lasi gwa, domici kup gǝzǝn mom den'e baso mǝn Hellas ni. ");
INSERT INTO plj_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Nan wu den kopi bǝn bǝno, arni wu yari mbarǝm argon tu mir mǝn kartǝni na kiri mǝn cina kǝ domtǝn kǝ mǝn kopi kǝ Urushalima mo bi dene kan wi kop gwa. ");
INSERT INTO plj_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Muntu ɗiri domtǝn kǝ mǝn kopi ndǝrtǝn gip ngǝshtǝn gǝzǝn den Yesu na womtitǝn den pǝt kup. ");
INSERT INTO plj_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Bulus na ga berǝm ɓomi asǝm gǝs kop gip atl kǝ Pirijiya na atl kǝ Galatiya, nan Ruhu kǝ Yam za wur wu pi wazu gip atl kǝ Asiya dagwa. ");
INSERT INTO plj_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Nan wu mbubar den bi atl kǝ Misiyawo, wu ndu wu bǝtl gam Arewa gip atl kǝ Bitiniya, ama Ruhu kǝ Yesu za wur da'a. ");
INSERT INTO plj_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Arni wu kop gip Misiya kan wu ndara Tǝrowasa. ");
INSERT INTO plj_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Gip dlom gaso arni Bulus shin ruya kǝ Ba mǝn Makidoniya gon dlor den liri gǝs ba wule, <<Ter ɗe Makidoniya kǝ ne mi am ra.>> ");
INSERT INTO plj_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Nan Bulus shin ruya tuwo, tǝ pǝn'e Yam ni ba la mi bi kǝ pi wazu Zo Shirǝm kǝ Yesu gip Makidoniya, arni mǝ dǝm daˈa kan mǝ ndara. ");
INSERT INTO plj_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Mǝ za Tǝrowasa gip kungǝlǝn jikat mal kan kor mǝ ndara Samotǝras. Bar tlowo kan mǝ mbubar Niyapolis. ");
INSERT INTO plj_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Mǝ za barta kan mǝ mbubar Filibbi, bar bǝn gip atl kǝ Makidoniya. Mǝn Roma ni ba dǝm lasi. Kan mǝ mur na womti gip bǝni. ");
INSERT INTO plj_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Den pǝt Asabaro mǝ ɗǝl gip bǝni mǝ ri bi ɓula'i, las tu mǝ pǝn'e mi zam ba shirǝm na Yam gwa. Mǝ dǝm atl kan mǝ shirǝm na mǝtli jen kan dom wur lasi gwa. ");
INSERT INTO plj_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Nǝm gip mǝtliyi kan kum miwo sun gǝs ni'e Lidiya. Mǝn Tiyatira ni kan ba wur tutul dli mǝn bar wurpi kagwa, mǝn bote Yami. Babom ɓul mbatl gǝs kǝ nǝmi shirǝm tu Bulus yari gwa kan tǝ ngǝsh ti den Yesu. ");
INSERT INTO plj_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Nan pi ti batisma na mbarǝm kǝ bom gǝso, arni tǝ la mi bi rin bom da tika na wultǝn'e, <<Kǝ mom a ngǝshim den Babom Yesuwi, a lir kǝn kǝ ɗir dǝm ni gip bom gǝni.>> Kan tǝ meti mi se nan mǝ nǝmi ti. ");
INSERT INTO plj_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Gasi gon nan mǝn den ritǝn kǝ ba shirǝm na Yamo, mǝ mo na zher nye gǝr gon kan na dun itǝr kan ba kem tǝ mani yari argon tu ba pi cina ɗegwa. Tǝ zami babom gǝs wurpi nar tǝp kǝ ba yari bar ju ba pi cina ɗegwa. ");
INSERT INTO plj_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Nye gǝr tu kop Bulus na nami gǝmi tǝ den la'i yar na wultǝn'e, <<Mbarǝm jǝno zher kǝ Yam tu kan nar man kup nami yam gwani. Wu yari in ni tǝp kǝ zami ɗǝltǝn gip warwat pitǝne.>> ");
INSERT INTO plj_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Tǝ pi ta pi untu kǝ muri na womti. Ar pi untu har ba ghun Bulus kan tǝ bal ti rǝn den tika, tǝ wul dun itǝri kan gip ti'e, <<Gip sun kǝ Yesu Almasihu ni a wul ki'e kǝ ɗǝl ter gip ti!>> Lasi, arni dun itǝri za ti. ");
INSERT INTO plj_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ama nan mǝn nye gǝr zheriyi shin'e tǝp zami wurpi gǝzǝn i'dawo, arni wu nǝm Bulus na Sila kan wu dǝl wur rin bi bar pǝtka, cina dǝ mǝn bǝni. ");
INSERT INTO plj_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Wu ri wur cina dǝ mǝn tloyi shirǝm kan wu wule, <<Mbarǝm jǝn pali bǝn gǝmi ka ghiruwi. ");
INSERT INTO plj_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Wi mǝn Yahuda ni kan ba kulci den mǝ pi bar ju kan ndari da'a den kulci gǝmi kǝ mǝn Roma kan mǝ nǝm ko mǝ pi gwa.>> ");
INSERT INTO plj_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Arni womti mbarǝmi tli den Bulus na Sila wu nǝm ɓe gǝzǝni. Mǝn tloyi shirǝmi kem dǝ tus tutul dli gǝzǝnka dǝ ɓo wuri. ");
INSERT INTO plj_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Den kaar kǝ ɓe gǝzǝn hoyiwo, kan ba la wur gip bom kǝ moni, na yari mǝn ne ger den bom kǝ moniyi den tǝ ne ger den wur hoyi, ba wu mani ɗǝltǝn da'a. ");
INSERT INTO plj_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Nan yari untuwo, arni mǝn ne ger den bom kǝ moniyi la wur gip kushi kan te gipi kagwa, kan tǝ tlat asǝm gǝzǝnka gip dlom giɓǝr basi nyash rop. ");
INSERT INTO plj_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Gip dlom gaso, Bulus na Sila den shirǝm na Yam na tli yar wuli kon ɗǝɗa Yami, nami mir mǝn bom kǝ moniyi den kumi gǝzǝni. ");
INSERT INTO plj_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Bat na momi, arni atl jirkǝt ti hoyi, kan ba kem gatl bin bom kǝ moniyi ba jiti ti. Biyi nǝm arni kup bǝdlabǝn bom kǝ moniyi ɓulka, kano sarsari ju ɓal kogonge nari ba pǝtlka. ");
INSERT INTO plj_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Nan mǝn ne ger den bom kǝ moniyi putu tǝ shin kup bǝdlabǝn bom kǝ moniyi na ɓuliwo, arni tǝ dlii bar sǝɓǝr gǝs tǝ ri kǝ ri gam gǝs eka. Tǝ ndu ni pi untu domici tǝ pǝn'e mir mǝn bom kǝ moniyi kǝtǝr gǝzǝn wi. ");
INSERT INTO plj_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ama Bulus tli yar tǝ wule, <<Ba kǝ kumi dli gi da'a! Mǝn ra kup ɗe!>> ");
INSERT INTO plj_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Kan mǝn ne ger den bom kǝ moniyi ba wule dǝ teri ti utu, tǝ kǝtǝr te gipika kan tǝ nda atl cina dǝ Bulus na Sila tǝ den dǝdartǝni. ");
INSERT INTO plj_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Kan tǝ ɗǝli wur ter kari tǝ wule, <<Kiri mbarǝme, unun a pi kan a zam ɗǝltǝn bi dǝ mǝshtǝn gwawe?>> ");
INSERT INTO plj_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Wu nǝmi tǝ'e, <<Ngǝsh ki den Babom Yesu, ki zam ɗǝltǝne, ki na kup munju gip bom da'i gwa.>> ");
INSERT INTO plj_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Kan wu pi ti wazu zo shirǝm kǝ Babom Yesu na kup mbarǝm ju kan gip bom gǝs gwa. ");
INSERT INTO plj_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Gip gasi arni mǝn ne ger den bom kǝ moniyi yem wur tǝ ho'i wur usu gǝzǝnka. Bartu anni pi ti batisma na mbarǝm kǝ bom gǝs kup. ");
INSERT INTO plj_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Tǝ laa'i na ghol mbatli domici tǝ ngǝsh ti den Yesu wi, ti na mǝn bom gǝs kup. Kan tǝ yem ga Bulus na Sila tǝ te wur gip bom gǝs tǝ bi wur fingal wu ci. ");
INSERT INTO plj_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Nan bar tlowo, arni mǝn bom tloyi shirǝmi kar mǝn ɓaltǝn kǝ dlom gǝzǝn kar mǝn ne ger den bom kǝ moniyi na shirǝm'e, <<Za mbarǝm ju wu ndara!>> ");
INSERT INTO plj_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Mǝn ne ger den bom kǝ moniyi wul Bulus'e, <<Mǝn bom tloyi shirǝmi wule nan ki na Silawo dǝ za kǝn kǝ ndara. Kǝkǝno ki mani ndaratǝni. Mbǝrni zhǝlili.>> ");
INSERT INTO plj_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ama Bulus bali mǝn ɓaltǝn kǝ dlomi'e, <<Wu ɓo mi gip dlom mbarǝme kup na wu kum kǝ bi gǝmi da'a, kup na mǝn mir mǝn atl kǝ Roma ni, kan wu la mi gip bom kǝ moni. Kǝkǝno wu ndu wu za mi mǝ ndara muri ituwa? Ba pi untu da'a! Se wini wu ɗir na gamgǝzǝni, wu la mi tǝp mǝ ndara.>> ");
INSERT INTO plj_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Kan mir mǝn ɓaltǝn kǝ dlomi ba ri mǝn bom tloyi shirǝmi na shirǝm tu. Nan wu kum'e Bulus na Sila mǝn atl kǝ Romano, bǝrti nǝm wur naari. ");
INSERT INTO plj_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Arni wu ri bi wur bi, wu ɗǝli wur ter gip bom kǝ moniyi kan wu lir wur den wu za bǝni. ");
INSERT INTO plj_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Den kar kǝ ɗǝltǝn kǝ Bulus na Sila gip bom kǝ moniyiwo, arni wu pal rin bom dǝ Lidiyaka las tu wu zam mir ɓyari, wu ɓa'i wur bigule. Kan wu nde ndaratǝni. ");
INSERT INTO plj_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Nan Bulus na Sila kop gip bǝn kǝ Amfibolis na Apoloniyawo, arni wu mbubar Tasalonika, las tu bom domtǝn kǝ mǝn Yahuda gon ra gwa. ");
INSERT INTO plj_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Kandatu Bulus ba kur pigwa, tǝ te gip bom domtǝn kǝ mǝn Yahuda, den pǝt Asabar myakan tǝ den bali shirǝm nan wur gip shirǝm kǝ Yami. ");
INSERT INTO plj_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Tǝ ceti wur gamka na yari wur tetla-tetla den ar nǝm Almasihu te yarka tǝ kum dli tǝ mǝshi, kan tǝ tli gip mǝshi mbarǝme. Bulus wul wur'e, <<Yesu tu kan a pi in shirǝm den ti tu ni'e Almasihu.>> ");
INSERT INTO plj_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Jen gip mǝn Yahudayiwo shirǝmi nǝm wuri kan wu nde Bulus na Sila kari. Untu ni es jen na womti kan mǝn Yahuda ni da'a kan ba bǝrti Yam gwa, na mǝtli jen kan mom wur nar gip bǝni gwa. ");
INSERT INTO plj_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ama mǝn Yahudayi nǝm na ghuve, kan wu dom bes mbarǝm kǝ ba bar pǝte, wu dǝm mǝn me gam kǝ gǝzan bar na tli bǝn mbatli. Kan wu nde bom kǝ Yason gami wu den ngeni dǝ ɗǝli Bulus na Sila ter kari kar mbarǝme. ");
INSERT INTO plj_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ama nan wu zam wur dawo, arni wu dǝl Yason na mir ɓyar jen wu ri wur cina dǝ mǝn tloyi mbarǝm shirǝm kǝ bǝni. Wu tli yar wu wule, <<Mbarǝm jin kan tli mbatl mbarǝm ko-ako gip atl kundǝrǝndlip ni jin kǝkǝn mbubar ɗewi, ");
INSERT INTO plj_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","kan Yason ba shu wur gip bom gǝsi. Wi ni den nge kopi kulci kǝ Bar Gun kǝ Roma, wu den wultǝn'e gun gon ra esi, muntu ba la ti bi'e Yesu gwa.>> ");
INSERT INTO plj_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Nan wu kum muntuwo, arni womti mbarǝmi na kiri kǝ bǝni palka ghiru-ghiru. ");
INSERT INTO plj_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Kan wu kem Yason na nami kǝ ɓatli wurpi gon kǝ dǝ za wur wu ndara ra, kan wu za wur wu ndara. ");
INSERT INTO plj_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Nan gas ndawo, arni mir ɓyari kar Bulus na Sila su Biriyaka. Nan wu mbubaro, arni wu te gip bom domtǝn kǝ mǝn Yahuda. ");
INSERT INTO plj_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Mbarǝm kǝ Biriya ra na ɓuli mbatl man mbarǝm kǝ Tasalonika, domici wu nǝm shirǝm tu Bulus yari den Yesu gwa na ghol mbatl naari. Arni wu zhit gip Shirǝm kǝ Yam den kogonge pǝte, kǝ dǝ wu shin ko argon tu Bulus yari wuro untuni anra. ");
INSERT INTO plj_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Mǝn Yahuda na womti ngǝsh wur den Yesu na kiri mǝtli jen kan mǝn Yahuda ni da'a kan mom wur nar gwa na moni jen kan mǝn Yahuda ni da'a na womti. ");
INSERT INTO plj_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Nan mǝn Yahuda kan gip Tasalonika kum'e Bulus den pi wazu kǝ shirǝm kǝ Yesu gip Biriyawo, arni wu ma wu ndara barta. Wu co womti mbarǝmi kan wu tli bǝn mbatli. ");
INSERT INTO plj_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Arni mir ɓyar tli dene bǝle-bǝle, kan wu la Bulus tǝp wu si ti bi bar ɓula'i, ama Sila na Timoti sa kaar gip Biriya. ");
INSERT INTO plj_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Mbarǝm ju kan la Bulus tǝp te nan ti gip Atina kan wu nde paltǝn Biriya. Wu pal na shirǝm tu kan Bulus kari bar Sila na Timoti gwa den'e wu zho wur wu zam ti. ");
INSERT INTO plj_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Nan Bulus ra gip bǝn Atina den ɓuti cwattǝn kǝ Sila na Timotiwo, ar ghun ti nar nan tǝ shin tat war ju mǝn Atina ba bote wur ko tǝp ako gip bǝni gwa. ");
INSERT INTO plj_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Kan tǝ bali shirǝm gip bom domtǝn kǝ mǝn Yahuda na mǝn Yahuda na mǝn bǝrti Yam kan mǝn Yahuda ni dagwa. Tǝ pa bali shirǝm na mbarǝm gip bar pǝt se na gǝni na munju kan ra lasi gwa. ");
INSERT INTO plj_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Me gam kǝ mǝn kulci kǝ Ipikuriya na mǝn kulci kǝ Sǝtokiya jen pare bali shirǝm nan ti. Jen gip wur ngen momi na wultǝn'e, <<Unun mbarǝm mǝn ndu'i shirǝm den argon tu tǝ mom da'a tu den ndu'i yariwe?>> Jen ngapo wu wule, <<Mǝ kum wule ti ni den shirǝm den mǝn dǝki yam jeni.>> Wu yari ni untu domici Bulus ni den pi wazu zo shirǝm kǝ Yesu na tlitǝn kǝ mǝshi mbarǝme. ");
INSERT INTO plj_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Kan wu pǝn Bulus wu su nan ti kǝ ba me gam kǝ Aropagus, las tu wu wul ti'e, <<Mi mani momi unun kulci tu kǝ ɗiri mi ba yari gwaya? ");
INSERT INTO plj_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Pel bar ni kǝ ɗiri mi, mǝ ndu mǝ mom unun ar ba kulci.>> ");
INSERT INTO plj_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Kup mbarǝm kǝ Atina na mǝn dǝki kan ba dǝm barta ba pa'ini wokoci gǝzǝn den pi argon da'a bom na yari ko kumi shirǝm den pel bari. ");
INSERT INTO plj_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Bulus dlǝr cina dǝ me gam kǝ Aropagus tǝ wule, <<Mǝn Atina! A shin ko tǝp ako'e kǝn mbarǝm ni mǝn pǝni adini hoyi. ");
INSERT INTO plj_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Nan a kop gip bǝn gino a zhit tat war ju kǝ bote wur gwa. Den nǝm gip las juwo a zam rǝsh'e, KƏ YAM TU KAN MOM TI DAGWA. Kǝkǝno argon tu kǝ bote ti bat na momi gǝs gwa ni a shirǝm den ti. ");
INSERT INTO plj_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","<<Yam muntu kan pi atl kundǝrǝndlip na kup bar ju gipi gwa ni'e Babom kǝ yam na atli. Eso tǝ dǝm gip bom kǝ yam ju kan mbarǝm tu na am gǝzǝn gwa dak. ");
INSERT INTO plj_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Tǝ pa ngen argon kan mi mani pi na am gǝmi, mǝ pi ti argon tu tǝ hol gwa dak, domici ti na gam gǝs ni ba bi mbarǝm kup rai na dli'i shukutǝni na ko unu esi. ");
INSERT INTO plj_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Tǝp kar mbarǝm nǝm kan tǝ pi gwa ni tǝ pi mbarǝm kǝ atl kundǝrǝndlip. Tǝ tlowi kan tǝ'i nde pi gǝzǝn den ko gigasi ni na ko ako ni wi dǝmi. ");
INSERT INTO plj_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Yam pi ni untu kǝ dǝ mbarǝm ngen ti den ko wi zam ti wi ni wu kar am gwa, kup na tǝ dlyam na kogonge gip mi da'a. ");
INSERT INTO plj_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","<Domici gip mani pi bar gǝs ni mǝ dǝmi, mǝ mani pi bari, kan mǝ zam gǝs kǝ dǝmi ra.> Kandatu mǝn kon gin jen wule, <Mǝn mimir gǝs ni.> ");
INSERT INTO plj_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","<<Tun nan mǝn mimir kǝ Yamno, ba mǝ pǝn ni'e ti nǝra wule argon tu pi na zǝnariya ko azurpa ko tate, kan mbarǝm gip mani pi bar gǝs pi gwa da'a. ");
INSERT INTO plj_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Terkawo, Yam bali gerka den holi momi bar ju, ama kǝkǝno tǝ kem dǝ mbarǝm kup ko-ako ci atl gam kar ti den warwat pitǝn gǝzǝn wu pal kar ti. ");
INSERT INTO plj_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","A yari in ni muntu domici tǝ ne pǝt gon kan ti tloyi atl kundǝrǝndlip shirǝm kan ra dlat tǝp kar mbarǝm tu tǝ zǝzari gwa. Tǝ kem dǝ mbarǝm kup mom muntu tǝp kǝ ba tli mbarǝmi gip mǝshi mbarǝme.>> ");
INSERT INTO plj_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Nan wu kum shirǝm den tlitǝn kǝ mǝshi mbarǝmo, arni jen pali ka bar kǝ gyatl gip nge, ama jen wule, <<Mi ndu mǝ kum ki ra den bar ju gas jen esi.>> ");
INSERT INTO plj_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Na yari untuwo, arni Bulus za ba me gami. ");
INSERT INTO plj_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Mbarǝm jen pal mir mǝn kopi Bulus kan wu ngǝsh wur den Yesu. Gip wuro Diyonisiyus ra, nǝm gip ba me gam kǝ Aropagus, na nagǝr gon es mǝn sun Damaris, na mbarǝm jen esi. ");
INSERT INTO plj_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Den kar kǝ muntuwo, arni Bulus za Atina tǝ ndara Korinti. ");
INSERT INTO plj_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Barta ni tǝ mo na mǝn Yahuda gon mǝn sun Akila, mǝn Pontus goni, muntu kan iza ni Italiya na nagǝr gǝs Bǝriskila gwa. Wu za ni Italiyaka nan Kaisar Kǝlaudiya kem den dǝ mbarǝm kǝ Yahuda kup za atl kǝ Roma gwa. Bulus ri kǝ shini gǝzǝni, ");
INSERT INTO plj_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","domici tǝ mǝn pi tenti ni wule wi, arni tǝ dǝm tǝ pi mbap nan wuri. ");
INSERT INTO plj_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Den kup pǝt Asabaro, Bulus ba bali shirǝm na mǝn Yahuda na munju kan mǝn Yahuda ni da'a gip bom domtǝn kǝ mǝn Yahuda, kǝ dǝ wu nǝm den'e Yesu ni'e Almasihu. ");
INSERT INTO plj_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Nan Sila na Timoti tli sur Makidoniyawo, arni Bulus bi wokoci gǝs kup den pi wazu, tǝ den yari mǝn Yahuda den Yesu ni'e Almasihu. ");
INSERT INTO plj_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ama nan mǝn Yahudayi nge shirǝm kǝ Bulus na yari ti mǝgǝn shirǝmo, arni tǝ bat kushka kǝ den tutul dli gǝska kan tǝ wul wur'e, <<Na dǝ bǝran gin sa den gam gini! Amo a ho gam gǝn wi. Pare'e kǝkǝni, aa pi ni wazu munju kan mǝn Yahuda ni dagwa.>> ");
INSERT INTO plj_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Kan Bulus ba za bom domtǝn kǝ mǝn Yahudayi tǝ ndara bom kǝ Titiyus Yustus, muntu mǝn Yahuda ni da'a kan ba bote Yam gwa. Bom gǝs ni kosak na bom domtǝn kǝ mǝn Yahudayi. ");
INSERT INTO plj_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kǝrisbus, bari kǝ bom domtǝn kǝ mǝn Yahudayi, na kup munju kan gip bom gǝs ngǝsh wur den Babom Yesu. Mǝn Korinti na womti kan kum Buluso wu ngǝsh wur den Yesu, kan ba pi wur batisma. ");
INSERT INTO plj_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Den pǝt gon gip gaso, Babom shirǝm na Bulus gip ruya, tǝ wul ti'e, <<Ba kǝ kum bǝrti da'a, ci cina na shirǝmi, ba kǝ yon gi da'a. ");
INSERT INTO plj_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Ami ra nan ki. Ko nǝm murgon ba mani ɗirtǝn tǝ pi dlan nan ki tǝ kumi'i dli da'a. Mbarǝm ra na womti gip bǝn kǝn kan baa pal mbarǝm gǝn gwa.>> ");
INSERT INTO plj_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Arni Bulus dǝm lasi kǝ sheti ghon nǝm na kyar mukka, tǝ den kulci wur shirǝm kǝ Yam den Yesu. ");
INSERT INTO plj_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Ama nan Galiyo dǝm gobna kǝ Akayawo, arni mǝn Yahuda mo gam wu nǝm Bulus kan wu ri ti bom tloyi shirǝmi. ");
INSERT INTO plj_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Arni wu wule, <<Mbarǝm kǝn den ndu'i tǝ kem mbarǝm gǝmi wu bote Yam bom na den tǝp tu kulci gǝmi yari gwa.>> ");
INSERT INTO plj_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Ama nan Bulus ba ri kǝ shirǝmo arni Galiyo wul mǝn Yahudayi'e, <<Kǝn mǝn Yahuda, dǝ wule shirǝm gin tuwo den wani bar gon ni tǝ pi ko ceni doka kawo, da aa zam bar kǝ nǝmi gip shirǝm gin tu, a kum kǝne. ");
INSERT INTO plj_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ama nan shirǝm ni den ga kalma na sunye na den kulci gino, pa'ini shirǝm tu kǝn na gam gini. Aa dǝm mǝn tloyi shirǝm den bar ju da'a.>> ");
INSERT INTO plj_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Arni tǝ kar wurka ter gip bom tloyi shirǝmi. ");
INSERT INTO plj_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Arni kup wu bal wur den Sostanisu, bari kǝ bom domtǝn kǝ mǝn Yahudayi kan wu ɓo ti te bǝdlabǝn bom tloyi shirǝmika. Ama Galiyo pi wule tǝ shin ni da'a. ");
INSERT INTO plj_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Bulus dǝm gip Korinti kǝ wokoci goni. Kan tǝ za mir ɓyari tǝ to gip kungǝlǝn jikat mal tǝ ndara gip atl kǝ Siriya, nan ti na Bǝriskila na Akila. Kapǝn tǝ ndarawo, tǝ fili gamka gip bǝn kǝ Kankǝriya, den kandatu mǝn Yahuda ba pigwa, kǝ nune pa'i pi argon tu tǝ wule ti pi gwa ituwi. ");
INSERT INTO plj_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Wu mbubar gip bǝn kǝ Afisa, las tu Bulus za ga Bǝriskila na Akila gwa. Tǝ te gip bom domtǝn kǝ mǝn Yahuda kǝ bali shirǝm na mǝn Yahudayi. ");
INSERT INTO plj_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Nan wu lir ti kǝ dǝ tǝ dǝm ra nan wuro arni tǝ nge gǝsi. ");
INSERT INTO plj_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ama tǝ ndarawo tǝ wul wur'e, <<Aa pal ra ɗir gas jen esi, Yam ni ndu gwa.>> Kan tǝ to gip kungǝlǝn jikat mal tǝ za bǝn kǝ Afisa. ");
INSERT INTO plj_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Nan tǝ mbubar Kaisariyawo, arni tǝ su Urushalima tǝ shirmi domtǝn kǝ mǝn kopi kan tǝ su gip bǝn Antakiya. ");
INSERT INTO plj_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Nan tǝ ɓom dǝmi gip bǝn Antakiyawo, arni Bulus ndara kan tǝ pi ta kopi las gip atl kǝ Galatiya na kǝ Pirijiya, tǝ den ndǝri la'i mbatl kǝ mir mǝn kopi. ");
INSERT INTO plj_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Wokoci tawo mǝn Yahuda gon ra mǝn sun Apolos, mǝn Alekzandǝriya, tǝ ɗir Afisa. Mbarǝm ni kan kulci bar nar gwa, na momi shirǝm kǝ Yam hoyi. ");
INSERT INTO plj_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Tǝ zam kulci den tǝp kǝ Babom Yesu, kan tǝ kulci mbarǝm hoyi den Yesu kandatu muntu kan mom'e argon tu tǝ yariwo hoyi ni gwa. Ama batisma kǝ Yohana ni katl tǝ momi. ");
INSERT INTO plj_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Tǝ pare shirǝm bat na bǝrti gip bom domtǝn kǝ mǝn Yahuda. Ama nan Bǝriskila na Akila kum tiwo, wu la ti bi rin bom da wurka kan wu yari tǝ ra hoyi den tǝp kǝ Yami. ");
INSERT INTO plj_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Nan Apolos pǝn ti te gip atl kǝ Akayawo, arni mir ɓyar gip Afisa ɓa'i ti bigul den tǝ ndara, kan wu rǝshi mir mǝn kopi kan gip Akaya gwa tǝlankuri, na liri gǝzǝn den wu nǝm ti na am rop-rop. Nan tǝ mbubaro, tǝ pi bar ju baa gode wur'e ti bar mǝn ne am ra ni kar munju kan ngǝsh wur den Yesu gwa tǝp kǝ ba zo mbatl kǝ Yami. ");
INSERT INTO plj_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Tǝ bali shirǝm nar na mǝn Yahuda cina dǝ mbarǝme, na yari wur dyatlǝm gip shirǝm kǝ Yam den Yesu ni'e Almasihu. ");
INSERT INTO plj_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Nan Apolos ra gip Korintiwo, arni Bulus kop gip dlom atli tǝ mbubar Afisa. Barta ni tǝ zam mǝn kopi jeni, ");
INSERT INTO plj_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","kan tǝ ngen momi kar wur tǝ wule, <<Kǝ nǝm Ruhu kǝ Yam wokoci tu kǝ ngǝsh kǝn den Yesu gwaya?>> Arni wu nǝmi ti'e, <<O'o, mǝ taɓe kumi den'e Ruhu kǝ Yam gon ra da'a.>> ");
INSERT INTO plj_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Kan Bulus ba ngen momi tǝ wule, <<Untuno, unu batisma ni pi ine?>> Kan wu bali ti'e, <<Batisma kǝ Yohana ni.>> ");
INSERT INTO plj_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Bulus wule, <<Batisma kǝ Yohanawo kǝ munju kan bali kar warwat pitǝn gǝzǝn gwani. Tǝ yari mbarǝm kǝ Isra'ila den wu ngǝsh wur den Yesu kan ba ɗir den kar gǝs gwa.>> ");
INSERT INTO plj_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Nan wu kum muntuwo, arni pi wur batisma gip sun kǝ Babom Yesu. ");
INSERT INTO plj_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Bulus ne am den wuro, arni Ruhu kǝ Yam sur den wuri, kan wu shirǝm na dǝki bi jeni, wu den yari shirǝm tu kan Yam bi wur kǝ dǝ wu yari gwa. ");
INSERT INTO plj_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Bar kǝ mbarǝm kutl-cet rop ni kup gǝzǝni. ");
INSERT INTO plj_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Kano Bulus ba te gip bom domtǝn kǝ mǝn Yahuda tǝ pi wazu bat na bǝrti kǝ kyar myakan. Tǝ bali shirǝm nan wur den dǝmi kǝ Yam gun gip mbatl kǝ mbarǝme na ndu'i tǝ dǝl wuri. ");
INSERT INTO plj_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ama jen gip wur na lati gami kan wu nge ngǝshtǝn den Yesu ka. Cina dǝ mbarǝm kup arni wu yari mǝgǝn shirǝm den tǝp kǝ Yesu. Arni Bulus za wuri. Tǝ ndara na mǝn kopiyi kan tǝ pi ta bali shirǝm nan wur den kogonge pǝt gip bar kushi kan Tiranus ba kulci mbarǝm gwa. ");
INSERT INTO plj_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Untuni tǝ ci cina nari kǝ sheti ghon rop, ar ba kem kup mǝn Yahuda na munju kan mǝn Yahuda ni da'a kan ba dǝm gip atl kǝ Asiya gwa ba kum shirǝm kǝ Babom Yesu. ");
INSERT INTO plj_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Yam pi bar kǝ nǝmi bi na am bom na munju kan ba kur shin gwa tǝp kar Bulus. ");
INSERT INTO plj_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Ba kur yem tutul sari bangani na ga lulur la'i kǝ pi mbap gǝs dǝ ri mǝn kumi dli, kan dǝ kumi dli gǝzǝn pa'i. Dun itǝr ma wu ɗǝl gip mbarǝm ka. ");
INSERT INTO plj_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Wokoci tawo mǝn Yahuda jen ra kan ba kop las na ɗǝli dun itǝr ter gip mbarǝm ka ra. Wu ndu wu pi ta nǝmi sun kǝ Yesu kǝ ɗǝli dun itǝrka gip mbarǝme, arni wu wule, <<Gip sun kǝ Babom Yesu, muntu Bulus ba pi wazu gǝs gwa, a wul ki'e kǝ ɗǝl teri.>> ");
INSERT INTO plj_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Gip wuro mir moni jen nyingi kǝ Siva, bari kǝ mǝn keri bar ju ɗiri Yam gwa kǝ mǝn Yahuda, den pi untu. ");
INSERT INTO plj_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Gasi gono wu ndu wu pi untu, arni dun itǝri nǝmi wur tǝ wule, <<A mom Yesu, kan a pal a mom Bulus, ama kǝn ga woni?>> ");
INSERT INTO plj_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Arni mbarǝm mǝn dun itǝri zop wur, tǝ tli nan wuri. Tǝ bi wur ish na ɓe kan wu yem na asǝm wu za gip bomi gǝs koni na bǝran bǝtǝ-bǝtǝ. ");
INSERT INTO plj_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Nan mǝn Yahuda na munju kan mǝn Yahuda ni da'a kan ba dǝm gip Afisa kum shirǝm tuwo, bǝrti nǝm wur naari. Kan sun kǝ Babom Yesu ba zam ɗǝɗatǝn hoyi. ");
INSERT INTO plj_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Na womti gip munju kan ngǝsh wur den Yesu ɗir gip dlom mbarǝme, kan wu yari warwat pitǝn gǝzǝni. ");
INSERT INTO plj_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Na womti kǝ munju kan pi bar kǝ dlǝkǝntǝn far ɗiri tǝlankur gǝzǝn kǝ ba lasi nǝm kan wu kerika den ger kǝ mbarǝm kup. Nan wu dom wurpi kǝ kup tǝlankuriwo, an ri zangu hauya rop na tatli (50,000) kǝ azurpa. ");
INSERT INTO plj_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Tǝp untuni shirǝm kǝ Babom Yesu ri na dlyami kan ba nar gip ndǝrtǝn gǝsi. ");
INSERT INTO plj_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Den kaar kǝ pitǝn tuwo, Bulus pǝn tor gip mbatl gǝs den tǝ su Urushalima, tǝ kop gip Makidoniya na Akaya. Kan tǝ wule, <<Den kaar kǝ sutǝn bartawo aa pa te Roma.>> ");
INSERT INTO plj_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Kan tǝ kar mir mǝn ne ti am ra mbarǝm rop, Timoti na Erastus Makidoniya, ama ti ngapo kan tǝ mur na womti gip atl kǝ Asiya. ");
INSERT INTO plj_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Wokoci tani bar tli mbatl ra gip Afisa gip nge Tǝp kǝ Yesu. ");
INSERT INTO plj_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Mǝn desi gǝlla azurpa gon mǝn sun Dimitǝris des mir bom kǝ mutli-yam Artimis na azurpa kandatu bariyi ra gip bom gǝs gwa. Muntu ba ɗiri ti na nami mǝn pi mbapi wurpi na naari. ");
INSERT INTO plj_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Tǝ dom wur kǝ ba las nǝm, na jen es munju ba pi mbap kan wule gwazin gwa. Tǝ wul wur'e, <<Mir moni, kǝ mom'e mǝ zam wurpi nar den mbap kǝni. ");
INSERT INTO plj_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Kǝn den shini na kumi kandatu mbarǝm tu Bulus tla gam kan tǝ jili mbarǝm na womti ɗe gip Afisa na ko-ako gip atl kǝ Asiya gwa. Tǝ wule yam ju kan mbarǝm pi na amo yam ni da'a ko njem. ");
INSERT INTO plj_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Bar kǝ tli mbatliwo ar ni'e ba'e tǝp kǝ zami wurpi gǝmi ni katl baa zam wani sun da'a, ama bom kǝ naari mutli-yam Artimis ma baa dǝm den bi argon ni da'a. Mutli-yami na gam gǝsi, muntu kan kup mbarǝm kǝ Asiya ba bote ti na atl kundǝrǝndlip, ba hol zami nartǝn den ger kǝ mbarǝme.>> ");
INSERT INTO plj_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Nan wu kum shirǝm tuwo, lo ci wuri kan wu nǝm la'i yar na wultǝn'e, <<Naari ni Artimis kǝ Afisa ra!>> ");
INSERT INTO plj_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","An ri kǝtǝgon da'a, arni bǝni palka ghiru-ghiru. Mbarǝm kǝ bǝni nǝm Gayus na Aristarkus, berǝm ɓomi asǝm kǝ Bulus kan tli tor Makidoniya gwa, kan wu zho wur biyi nǝm wu ne gam las tu mbarǝm kǝ bǝni ba dom wur gwa. ");
INSERT INTO plj_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Bulus ndu tǝ ri cina dǝ womti mbarǝmi, ama mǝn kopi za ti da'a. ");
INSERT INTO plj_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Jen gip mǝn bǝni ma, mir berǝm kǝ Bulus, kari ti bar na shirǝm wu den liri gǝs den ba dǝ tǝ te las tu mbarǝm dom wuri gwa da'a. ");
INSERT INTO plj_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Domtǝni pika ghiru-ghiru, jen den la'i yar na yari mǝnkǝni, kan jen ngapo mǝnta. Na womti gǝzǝn ma wu mom utun dom wur lasi da'a. ");
INSERT INTO plj_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Mǝn Yahudayi dǝl Alekzanda te cinaka, kan jen gip womti mbarǝmi ba la yar den argon tu tǝ pi gwa. Tǝ pi am den dǝ yoni, kan tǝ pare shirǝm ho'i gam gǝs cina dǝ mbarǝme. ");
INSERT INTO plj_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ama nan wu momka'e ti mǝn Yahudano, arni wu wom bar biyi nǝm kǝ bar kǝ awa rop wu den wultǝn'e, <<Naari ni Artimis kǝ Afisa ra!>> ");
INSERT INTO plj_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Mǝn yari argon tu kan baa pi gip bǝni tla gam kǝ womti mbarǝmi kan wu yoni. Arni tǝ wule, <<Mbarǝm kǝ Afisa, mbarǝm kǝ atl kundǝrǝndlip mom'e bǝn kǝ Afisa ni'e mǝn ne ger den bom kǝ Artimis mǝn nartǝni, na tat mǝn nartǝn gǝsi, muntu kan nda sur yam gwa. ");
INSERT INTO plj_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Ra'untuwo, tun nan murgon baa mani nge munju dawo, te ni mbatl kaarka, ba kǝ pǝni bar na zhotǝn da'a. ");
INSERT INTO plj_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Kǝ ɗiri mbarǝm jǝn ɗe, kup na wu pini mur kǝ bar mǝn tsarki jen gip bom kǝ yam ko yari mǝgǝn shirǝm den mutli-yam gǝmi da'a. ");
INSERT INTO plj_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","<<Dimitǝris na mǝn pi mbap kan nǝm na gwas ni ra na shirǝm den murgono, bom tloyi shirǝm ju na mǝn tloyi shirǝm lasi. Wi mani ri shirǝm gǝzǝn barta. ");
INSERT INTO plj_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Argon ni ra es kan kǝ ndu ɗiriwo, baa mani pa'i shirǝmi gip me gam kǝ mir mǝn atl kan yerda na doka gwa. ");
INSERT INTO plj_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Kandatu ar rawo, mǝn ra gip tli mbatl kǝ dǝ nǝm mi den mǝ tli mbatl bǝn den argon tu pi sekǝn gwa. Den muntuwo mi mani yari argon tu kan pi gwa da'a, tun nan gǝs kǝ pitǝn gǝs ra dagwa.>> ");
INSERT INTO plj_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Nan tǝ pa'i yari muntuwo, arni tǝ wul mbarǝm kan dom wur gwa'e wu ndara. ");
INSERT INTO plj_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Nan mbatl murwo, kan Bulus ba kar bar den mǝn kopi, den kaar kǝ pi wur shirǝm ɓa'i bigule. Arni tǝ pali wur bi tǝ ndara Makidoniya. ");
INSERT INTO plj_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Tǝ kop gip atli tǝ den ta yari shirǝm ɓa'i bigul mǝn kopi, har tǝ mbubar Akaya gip atl kǝ Hellas, ");
INSERT INTO plj_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","las tu tǝ dǝm kǝ kyar myakan gwa. Mǝn Yahuda gudlumi wu pi ti mǝgǝn pitǝn nan tǝ den bi totǝn gip kungǝlǝn jikat mal tǝ ndara Siriya gwa, arni tǝ pǝn gip mbatl gǝs tǝ kop tǝp gip Makidoniya. ");
INSERT INTO plj_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Munju kan den ɓomi asǝm nan ti gwa ni'e ga Supataras nya Pirus mǝn Biriya, na Aristarkus, na Sikundus mǝn Tasalonika, Gayus mǝn Darba, na Timoti, na Tikikus na Tǝrofimus mǝn atl kǝ Asiya. ");
INSERT INTO plj_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Mbarǝm ju ci cina kan wu ɓut mi gip Tǝrowasa. ");
INSERT INTO plj_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ama mǝ za Filibbi mǝ jikat mal den kar kǝ Nyel Jikat Bǝdlabǝni, arni muri nantam den kariwo kan mǝ zam wur gip Tǝrowasa, las tu mǝ dǝm kǝ muri nyingi gwa. ");
INSERT INTO plj_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Den pǝt Asabar kǝ sito mǝ dom mi las nǝm kǝ dǝ mǝ ci fingal na fingal kǝ Babomi. Bulus shirǝm na mbarǝme, domici tǝ ndu ndaratǝn bar ni tlo gwa, tǝ pi ta shirǝm ar bari dlom gasi. ");
INSERT INTO plj_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Utu pitila ra na womti den ci gip kushi kǝ to yami ka, las tu mǝ dom mi gwa. ");
INSERT INTO plj_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Njon den tagawo nye mbarǝm gon ra mǝn sun Yutikus, ger umur nǝm ti kan umur ba pǝn tika nan Bulus den ta shirǝm gwa. Nan tǝ den umur to den ɓiti kushi kǝ myakan to yami kawo, arni tǝ nda sur atl kan ba pǝn ti mǝshi. ");
INSERT INTO plj_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Bulus ɗǝl sur atl tǝ ngus kar nyayi, tǝ la am den ti, kan tǝ wule, <<Ba dǝ ar ghun kǝn ni da'a. Tǝ ra na rai.>> ");
INSERT INTO plj_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Kan tǝ pal to kushi kǝ yamiyi ka tǝ njetǝl bǝrǝdi tǝ bi mbarǝm wu ci. Den kar kǝ tlyari shirǝm kǝ Bulus bari tlotǝn kǝ baro, arni tǝ ndara. ");
INSERT INTO plj_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Mbarǝm kan lasi gwa pǝn nye mbarǝmi wu ri ti bom na rai, kan kup wu shem dene hoyi. ");
INSERT INTO plj_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Mǝ nda cina mǝ to gip kungǝlǝn jikat male kan mǝ ndara bǝn kǝ Asos, las tu mǝ ri kǝ pǝni Bulus gwa. Untu ni tǝ wule mǝ pi domici ti ndara ni den asǝme. ");
INSERT INTO plj_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Nan tǝ zam mi gip Asoswo, arni mǝ pǝn ti gip kungǝlǝn jikat mali mǝ ndara gip bǝn kǝ Mitilini. ");
INSERT INTO plj_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Bar tlowo arni mǝ to gip kungǝlǝn jikat mal kan mǝ ne gam den bishidi bǝn kǝ Kiyos. Zut bar tlowo, arni mǝ ndara kan mǝ te den bishidi bǝn kǝ Samos. Den zut pǝto kan mǝ mbubar gip bǝn kǝ Militus. ");
INSERT INTO plj_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Bulus pǝn tor gip mbatl gǝs kǝ dǝ tǝ to gip kungǝlǝn jikat mal tǝ bi kaar bǝn kǝ Afisa den tǝ ndu tǝ dǝm gip atl kǝ Asiya da'a. Ti ni den zhotǝn tǝ mbubar Urushalima, arni ba piwo, tǝ mbubar wokoci kǝ nyel Pentikos. ");
INSERT INTO plj_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Nan Bulus ra gip Milituso, arni tǝ kar bar den dǝ kiri mǝn cina kǝ domtǝn kǝ mǝn kopi kǝ gip bǝn Afisa zam ti. ");
INSERT INTO plj_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Nan wu mbubar kar tiwo, tǝ wul wur'e, <<Kǝ mom kandatu a pi dǝmi gǝn nan ami ra nan kǝne, pare den gas tu kan a cwat ɗe gip atl kǝ Asiya gwa. ");
INSERT INTO plj_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","A bote Babom na pali gam gǝn ami argon ni da'a na lune, kup na a tla godetǝn nar den bar ju mǝn Yahuda gudlumi den wi pim gwa. ");
INSERT INTO plj_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Kǝ mom'e a za argon kaar gip wazu gǝn kan baa ne in am ra gwa da'a ama a kulci in gip dlom mbarǝme na kopi bom bomi. ");
INSERT INTO plj_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","A yari kup mǝn Yahuda na munju kan mǝn Yahuda ni da'a den ar nǝm wur te yarka wu pal kar Yam gip ci atl gami, dǝ wu ngǝsh wur den Babom gǝmi Yesu. ");
INSERT INTO plj_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","<<Artu kǝkǝno, na kopi kǝ Ruhu kǝ Yami, a su ni Urushalima. A mom unun ba zamǝn suka da'a. ");
INSERT INTO plj_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Argon tu a momwo ar ni'e, gip kogonge bǝno Ruhu kǝ Yam dǝlim kǝm den ɓaltǝn gip bom kǝ moni na kumi dli den ɓuti gǝni. ");
INSERT INTO plj_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Kup na untu, amo a pǝn dǝmi gǝn na rai den bi argon ni karǝm da'a, kan ri kǝ dǝ a pa'i totǝn kǝ zami bar kǝ dǝ a pa'i mbap tu kan Babom Yesu bim gwa. Mbap yari Zo Shirǝm den zo mbatl kǝ Yami. ");
INSERT INTO plj_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","<<Kǝkǝno a mom'e ko nǝm ra gip kǝn kan a kop na pi wazu den dǝmi kǝ Yam gun gip mbatl kǝ mbarǝm kan baa'i shin ger gǝn es gwa. ");
INSERT INTO plj_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Ra'untuwo, a yari in sekǝn den a ɗǝlka gip bǝran kǝ mbarǝm kup wi. ");
INSERT INTO plj_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Na ho bi, a hol yari in kup bar ju kan Yam ba ndu kǝ mom gwa da'a. ");
INSERT INTO plj_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ra untuwo, neni ger den pitǝn gini na mbarǝm ju kan Ruhu kǝ Yam bi in kǝ ne ger den wur gwa. Dǝm ni mǝn ne ger den domtǝn kǝ mǝn kopi Yami, muntu kan tǝ pali gwas tǝp kar bǝran kǝ nya gǝs gwa. ");
INSERT INTO plj_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","A mom'e ami ni a ndarawo, mǝn kulci kǝ lar wule mamal ba ɗir gip dlom gini, kano wi za mǝn kopiyi da'a. ");
INSERT INTO plj_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Jen gip kǝn ma ba tlyam na ceni lar kǝ zhimbǝl argon tu kan untun anra gwa kǝ dǝ wu dom mir mǝn kulci kar wuri. ");
INSERT INTO plj_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Untuwo, dǝm ni gǝɗin! Mom ni'e a za dǝli kǝm kogonge gip kǝn da'a kǝ sheti ghon myakan, na kumi dli nar gip pi in wazu. ");
INSERT INTO plj_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","<<Kǝkǝno a taa kǝn am dǝ Yami na shirǝm kǝ zo mbatl gǝsi. Shirǝm tu kan baa kem kǝn kǝ nartǝn kan tǝ bi in ho bar tu kan gegin ni, kan Yam ba bi mbarǝm gǝs kup gwa. ");
INSERT INTO plj_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","A ndu dǝ azurpa ko zǝnariya ko tutul dli kǝ ko nǝm gin ar dǝm gwan da'a. ");
INSERT INTO plj_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Kǝn na gam gin mom den a pi mbap na am gǝn kǝn kǝ zami kup bar ju ami na ga berǝm ɓomi asǝm gǝn ba ndu gwa. ");
INSERT INTO plj_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Gip kup argon tu a piwo, a nune in wi den na pi mbap hoyiwo ar nǝm mi te yarka mi ne am munju kan ndǝr dagwa. Mǝ tune ni shirǝm tu Babom Yesu na gam gǝs yari gwa'e, <Mbarǝm ba zam nartǝn wokoci tu tǝ bi bar mbarǝm gwa ar man wokoci tu tǝ nǝm kar murgon gwa.> >> ");
INSERT INTO plj_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Nan tǝ pa'i yari muntuwo arni tǝ ngus den gam ghurǝm na kup gǝzǝni kan tǝ shirǝm na Yami. ");
INSERT INTO plj_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Kup gǝzǝn kul nan wu den nǝmi gǝs ɗir gip dlom kǝ pali ti bi gwa. ");
INSERT INTO plj_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Argon tu ɗiri wur dun mbatl naaro ar ni'e shirǝm tu tǝ yari gwa den'e wi'i shin ti da'a. Kan wu la ti tǝp su kar kungǝlǝn jikat mali ka. ");
INSERT INTO plj_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Nan mǝ pali wur biwo, arni mǝ to gip kungǝlǝn jikat mal mǝ bǝtl gam atl kǝ Kos kan te dlom malka gwa. Bar tlowo kan mǝ ndara bǝn kǝ Rodusa kan mǝ za barta mǝ ne gam bǝn kǝ Patara. ");
INSERT INTO plj_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Mǝ zam kungǝlǝn jikat mal kan ba ri kǝ jikat mal nari dǝ te atl kǝ Finiks gwa, arni mǝ to gipi mǝ ndara. ");
INSERT INTO plj_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Nan mǝ mbubar las gon kan mǝ mani shini Saipǝroso, kan mǝ ne gam kudu na bǝni mǝ ndara Siriya. Mǝ te den bishidi kǝ Taya mǝ dlǝri, las tu ba ri kǝ shu'i gosgam kǝ gip kungǝlǝn jikat mal gǝmi gwa. ");
INSERT INTO plj_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Mǝ zam mǝn kopi kǝ lasi kan mǝ dǝm nan wur kǝ muri nyingi. Tǝp kar Ruhu kǝ Yamo arni wu lir Bulus den ba dǝ tǝ su Urushalima da'a. ");
INSERT INTO plj_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ama nan muri ju mǝ yem den mi pi lasi pawo, arni mǝ za wur kan mǝ ci cina na ɓomi asǝm gǝmi. Kup mir mǝn kopiyi, mǝtli gǝzǝn na mimir gǝzǝn la mi tǝp wu ɗǝli mi gip bǝn wu si mi bi ɓula'i. Arni mǝ ngus den gam ghurǝm gǝmi mǝ shirǝm na Yam kan mǝ pali bi ɓyari. ");
INSERT INTO plj_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Den kar kǝ pali bi na ɓyaro, arni mǝ to gip kungǝlǝn jikat male, wu ngapo kan wu pal gǝzǝn bomi. ");
INSERT INTO plj_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Mǝ ci cina na ɓomi asǝm gǝmi, mǝ za Taya mǝ mbubar Tolimayis, las tu mǝ shirmi mir ɓyar kan mǝ dǝm nan wur kǝ nde pǝt nǝm. ");
INSERT INTO plj_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Bar tlowo arni mǝ ndara, mǝ mbubar Kaisariya kan mǝ dǝm gip bom kǝ Filibus mǝn pi wazu kǝ Zo Shirǝmi, nǝm ni gip mbarǝm nyingi ja. ");
INSERT INTO plj_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Tǝ ra na mimir mir mǝtli wupse kan gudlumi wu dagwa. Kogonge gip wur ba mani yari argon tu Ruhu kǝ Yam ɓuli wur ger wu shin gwa. ");
INSERT INTO plj_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Nan mǝn ra barta kǝ muri na womtiwo, mǝn yari shirǝm kǝ Yam gon mǝn sun Agabus tli sur Yahuda. ");
INSERT INTO plj_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Tǝ sur kar miwo, arni tǝ pǝtl zap ɓali tutul tli kǝ Bulus kan tǝ ɓal asǝm na am gǝs nari. Kan tǝ wule, <<Ruhu kǝ Yam wule, <Untuni mǝn Yahuda kǝ gip Urushalima ba ɓal mǝn zap ɓali tutul tli kǝni kan wu la ti am dǝ munju kan mǝn Yahuda ni dagwa.> >> ");
INSERT INTO plj_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Nan mǝ kum muntuwo, arni min na mbarǝm kan lasi gwa lir Bulus den ba dǝ tǝ to Urushalima da'a. ");
INSERT INTO plj_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Kan Bulus ba nǝmi mi'e, <<Unun kem kǝ kuli, kǝ dǝ kǝ cenim mbatl kaya? A ɓa mbatl dlom gamwi ba'e dǝ ɓalǝm katl da'a, ama kǝ dǝ a mǝsh gip Urushalima den bi sun kǝ Babom Yesu.>> ");
INSERT INTO plj_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Nan mǝ mani tle gam gǝs dawo, arni mǝ za ti kan mǝ wule, <<Na dǝ ndu'i kǝ Babom ndol untuyi.>> ");
INSERT INTO plj_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Den kar kǝ muntuwo, arni mǝ dlǝri mbatl kǝ ndaratǝn Urushalima. ");
INSERT INTO plj_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Jen gip mǝn kopi kan tli ter Kaisariya kop mi kari, kan ba ri mi bom kǝ mbarǝm gon mǝn sun'e Mǝnason, las tu mǝ dǝm gwa. Tǝ mbarǝm kǝ Saipǝros kan nǝm gip mǝn kopi kǝ parko gwani. ");
INSERT INTO plj_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Nan mǝ mbubar gip Urushalimawo, mir ɓyar nǝm mi na am rop-rop. ");
INSERT INTO plj_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Bar tlowo arni Bulus na nami gǝmi ri kǝ shini Yakubu, kup kiri mǝn cina kǝ mǝn kopi ra lasi. ");
INSERT INTO plj_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Bulus shirmi wur kan tǝ yari wur ndekes bar ju kan Yam pi munju kan mǝn Yahuda ni da'a gip mbap gǝs gwa. ");
INSERT INTO plj_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Nan wu pa'i kumi gǝso, arni wu ɗǝɗa Yami. Kan wu wul Bulus'e, <<Erǝmi, ɓa shin kandatu mǝn Yahuda na womti ngǝsh wur den Yesu gwa, kup gǝzǝn ngapo mǝn bi gam gip kopi kulci kǝ Musa ni. ");
INSERT INTO plj_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Yari wur wi den'e kǝ kulci kup mǝn Yahuda kan ba dǝm gip munju kan mǝn Yahuda ni da'a den wu za kopi kulci kǝ Musa ka, na yari wur den ba dǝ wu sǝr mimir gǝzǝn ko wu kop bar ju mǝn kan mǝn Yahuda ni ba kop gwa da'a. ");
INSERT INTO plj_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Unun mi piwe? Wi kum den'e kǝ mbǝra wi. ");
INSERT INTO plj_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Ra untuwo pi argon tu mi yari'i gwa. Mbarǝm wupse ra ɗe nan mi kan pǝni gam gǝzǝn den argon tu wi pi Yam gwa. ");
INSERT INTO plj_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Ri na mbarǝm ju. Mo gam nan wur gip pi bar ju kan ba pi kǝ pali mbarǝm dlǝran cina dǝ Yam gwa. Ɓatl kup argon tu ar nǝm gwa kǝ dǝ fili wur gamka. Na untuni mbarǝm kup ba mom'e bar ju ba yari den kiwo larni, ama den ki na gamgi den dǝmi na kopi kulci kǝ Musa. ");
INSERT INTO plj_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Den bi kǝ munju kan mǝn Yahuda ni da'a kan ngǝsh wur den Yamo, mǝ rǝshi wur tǝlankur wi den argon tu mǝ ne bi dene gwa'e ba wu ci argon tu ta'i tat ware, ko tlu na mbǝrani gipi, ko tlu kǝ dabba tu kan ceni tini yarka gwa, na dǝ ba wu la gam gǝzǝn gip muri na mǝtli na moni kari da'a.>> ");
INSERT INTO plj_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Bar tlowo arni Bulus yem mbarǝm ju kan ba pi wur bar ju kan ba pi kǝ pali mbarǝm dlǝran cina dǝ Yam gwa kup nan ti. Kano tǝ te gip bom kǝ Yami kǝ dǝ yari gip mbarǝm den muri ju ba pǝn kǝ pali mbarǝm dlǝran cina dǝ Yami na mboshi Yam dabba den am kǝ kogonge gip wur gwa. ");
INSERT INTO plj_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Nan muri nyingiyi ba ri kǝ patǝno, arni mǝn Yahuda jen kan tli tor gip atl kǝ Asiya gwa ba shin Bulus gip Bom kǝ Yami. Wu tli mbatl kǝ womti mbarǝmi kan wu nǝm ti ");
INSERT INTO plj_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","wu den la'i yar na wultǝn'e, <<Mbarǝm kǝ Isra'ila, ne mǝni amra! Mbarǝm kǝn ni ba kulci mbarǝm ko-ako na mǝgǝn shirǝm den mbarǝm gǝmi, na kulci kǝ Musa, na Bom kǝ Yam kǝni. Untu dama, tǝ ɗir na mbarǝm jen kan mǝn Yahuda ni da'a gip Bom kǝ Yami kan ba li las kǝnka kan dlǝran gwa.>> ");
INSERT INTO plj_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Wu yari ni muntu domici wu shin Tǝrofimus mǝn Afisa na Bulus gip bǝni, arni wu pǝn'e Bulus te ni nan ti gip Bom kǝ Yami. ");
INSERT INTO plj_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Arni kup gip bǝni pika ghiru-ghiru, kan mbarǝm ko tǝp ako ba ɗǝl ɗir na kǝtǝre. Wu nǝm Bulus, wu dǝl ti ter kaar Bom kǝ Yami, kan wu zho wur wu le bǝdlabǝni ka kup. ");
INSERT INTO plj_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Nan wu den ndu'i ri gǝs ekawo, arni komanda kǝ mǝn bi-utu kǝ Roma zam na kumi shirǝmika den'e bǝn Urushalima kup ra gip tli mbatli. ");
INSERT INTO plj_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Tǝ dǝm da'a arni komandiyi yem mir kiri kǝ mǝn bi-utu na mǝn bi-utu jen kan wu zho wur su kar womti mbarǝmika. Nan mǝn tli bǝn mbatli shin komandayi na mǝn bi-utu gǝso, arni wu za ɓe Bulus. ");
INSERT INTO plj_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Komandayi ri kar Bulus tǝ nǝm ti, kan tǝ bi bi'e dǝ ɓal tǝka na sarsari rop. Kan tǝ ngen momi ko ti woni kan ununu tǝ pi. ");
INSERT INTO plj_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Jen gip womti mbarǝmi den yari mǝnkǝni, jen ngapo argon esi. Muntu kem komandayi mani momi gam kǝ shirǝmi da'a nan mbatl tli kawi gwa. Arni tǝ wule dǝ te na Bulus las tu mǝn bi-utuyi ba dǝm gwa. ");
INSERT INTO plj_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Nan Bulus ne asǝm den ba ne asǝm kǝ totǝn gip kushiyiwo, arni mǝn tli bǝn mbatli tli den Bulus na naari kan mǝn bi-utuyi ba pǝn tǝka. ");
INSERT INTO plj_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Womti mbarǝm kan nde wur kar den la'i yar na wultǝn'e, <<Pi nǝka nan ti!>> ");
INSERT INTO plj_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Nan mǝn bi-utuyi ba ri kǝ tetǝn las tu mǝn bi-utuyi ba dǝm na Buluso, arni ti ngen momi kar komandayi'e, <<Aa mani shirǝm nan ki ya?>> Komandayi nǝmi ti'e, <<Kǝ mani ni bi kǝ mǝn Hellasa? ");
INSERT INTO plj_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ki ni'e mǝn Masar tu kan wokoci gon terka tli gobnati gam na dlan kan kǝ yem mbarǝm zangu wupse (4,000) mǝn dlan na gobnati kan ba ndara gip lǝp gwa diya?>> ");
INSERT INTO plj_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Bulus nǝmi ti'e, <<O'o, amo mǝn Yahuda ni, gǝri kǝ Tarsus gip Kilikiya, nye mǝn atl kǝ bar ho bǝn ni. Kustu, za'ǝm a shirǝm na mbarǝm ju.>> ");
INSERT INTO plj_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Nan komandayi bi ti biwo, arni Bulus dlǝr to den ba ne asǝm kǝ totǝn gip kushi kǝ yamika kan tǝ pi am womti mbarǝmi den wu yoni. Nan wu sa shotwo, arni tǝ shirǝm na mbarǝm na bi kǝ mǝn Yahuda. ");
INSERT INTO plj_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","<<Mir ɓyar mǝn Yahuda na ga ba gǝmi, kum ni shirǝm ho'i gam gǝni.>> ");
INSERT INTO plj_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Nan wu kum ti den shirǝm na bi gǝzǝn kǝ mǝn Yahudawo, arni wu sa shot ra. Kano Bulus ba wule, ");
INSERT INTO plj_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","<<Ami mǝn Yahuda ni, gǝrǝm ni gip Tarsus kǝ gip atl kǝ Kilikiya ama a nar ni gip bǝn kǝni. Cina dǝ Gamaliyel ni a zam kulci den kopi kulci kǝ ga ba gǝmi asǝm na gǝs gip bi Yam gam gǝn wule kandatu kup gin kan ra ɗe sekǝn gwa. ");
INSERT INTO plj_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","A kumi dli mǝn kopi Tǝp kǝ Yesu kǝn na nǝmi mǝtli na moni kup a kem dǝ la wur gip bom kǝ moni na ɓali. Jen gip wur mǝshka. ");
INSERT INTO plj_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Bar mǝn keri bar ju ɗiri Yami na kup munju kan gip domtǝn kǝ mǝn tloyi shirǝm kǝ mǝn Yahuda mom muntu. Kar wur ni a nǝm tǝlankur kan rǝshi mir ɓyar mǝn Yahuda kan gip Dimashka gwa. A te barta kǝ dǝ a nǝm mbarǝm ju a ter nan wur Urushalima na ɓali kǝ dǝ hukunte wuri. ");
INSERT INTO plj_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","<<Kǝ dlom pǝte, nan a mbi kosak na Dimashkawo, arni pǝlǝt bar cirtǝn gon ɗǝl sur yam kan ba cir karǝmi. ");
INSERT INTO plj_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Arni a nda atlka kan a kum yar gon ba wulǝm'e, <Shawulu, Shawulu! Unun kem kǝ kumim dli rawu?> ");
INSERT INTO plj_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","<<Arni a ngen momi kar ti a wule, <Ki ni'e wowe, Babomi?> Kan tǝ balim'e, <Ami ni'e Yesu kǝ Nazarat, muntu kan kǝ kumi ti dli gwa.> >> ");
INSERT INTO plj_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Mbarǝm ju kan den ɓomi asǝm namǝn shin cirtǝni, ama wu mani momi yar kǝ mǝn shirǝm na mǝni da'a. ");
INSERT INTO plj_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","<<Kan a ngen momi kar ti a wule, <Ununu a piwe, Babomi?> Arni Babom Yesu wulǝm'e, <Tlyam kǝ te gip bǝn Dimashka. Barta ni ba yari'i bar ju kup kan nǝm ki te yerka kǝ pi gwa.> ");
INSERT INTO plj_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Mir mǝn ɓomi asǝm na mǝn nǝmim am wu tem gip Dimashka, domici bar cirtǝni kem a'i mani shini bar da'a. ");
INSERT INTO plj_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","<<Mbarǝm gon mǝn sun'e Hananiya ɗir kǝ shini gǝni. Mbarǝm mǝn bi gam gip kopi kulci kǝ Musa ni kan kup mǝn Yahuda kan gip Dimashka ba shin nartǝn gǝs gwa. ");
INSERT INTO plj_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Tǝ dlǝr markǝm da'ǝm kan tǝ wule, <Erǝm Shawulu, zam mani shini bar gi!> Nǝm wokoci ta ni mani shini bar gǝn pali kan a shin ti. ");
INSERT INTO plj_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","<<Kan tǝ wule, <Yam kǝ ga ba gǝmi ni zǝzar ki kǝ dǝ kǝ mom argon tu tǝ ndu gwa, kan kǝ shin mǝn pi argon tu Yam ba ndu gwa, kǝ pa kum shirǝm kǝ bi gǝsi. ");
INSERT INTO plj_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ki dǝm mǝn yari mbarǝm kup shirǝm den ti kǝ argon tu kǝ shin kǝ pa kum gwa. ");
INSERT INTO plj_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Kǝkǝno, unun kǝ ɓutwu? Tlyami, dǝ pi'i batisma kǝ zam dǝ pǝni'i warwat pitǝn gika, tǝp kǝ ba la'i bi den sun gǝsi.> ");
INSERT INTO plj_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","<<Nan a pal su Urushalimaka den shirǝm na Yam gip Bom kǝ Yamo, a shin ruya. ");
INSERT INTO plj_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","A shin Babom den shirǝm na wuli gǝn'e, <Za Urushalima na zhotǝne, domici wi nǝm argon tu kǝ yari demǝn gwa da'a.> ");
INSERT INTO plj_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","<<Arni a nǝmi ti'e, <Babomi, mbarǝm ju mom'e a kop bom domtǝn kǝ mǝn Yahuda na nǝm-nǝm na la'i gǝzǝn gip bom kǝ moni na ɓe munju kan ngǝsh wur den ki gwa. ");
INSERT INTO plj_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Wokoci tu kan ri mǝn yari shirǝm gi Istipanus ekawo, ami ra lasi gip kopi kaari na ne ger den tutul dli kǝ munju kan den ri gǝs eka gwa.> ");
INSERT INTO plj_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","<<Kano tǝ wulǝm'e, <Mbǝri, aa kar ki na dlyami kar munju kan mǝn Yahuda ni dagwa.> >> ");
INSERT INTO plj_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Womti mbarǝmi ne kǝm den shirǝm kǝ Bulus har tǝ yari muntu. Kan wu tli na la'i yar wu wule, <<Dǝ pika nan ti! Tǝ ndar ci cina na dǝmi da'a!>> ");
INSERT INTO plj_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Nan wu den la'i yaro, arni wu tus lulur gǝzǝn wu byali ka kan wu wi atl to yamka. ");
INSERT INTO plj_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Komanda kǝ Romayi kem dǝ ter na Bulus gip las tu mǝn bi-utuyi ba dǝm gwa. Tǝ kem wu ɓo Bulus kǝ dǝ tǝ mom unun kem mbarǝm ba la'i ti yar gam untu. ");
INSERT INTO plj_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Nan wu ɓal Bulus ba ri kǝ ɓe gǝso, arni tǝ wul bar mǝn bi-utu kan dlor lasi gwa'e, <<Doka bi'i bi den kǝ ɓo nye mǝn atl kǝ Roma tu kan zam ti na wani pitǝn gon gwa da'aya?>> ");
INSERT INTO plj_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Nan bar mǝn bi-utuyi kum untuwo, arni tǝ ri kar komandayi tǝ yari ti, kan tǝ ngen momi kar ti'e, <<Unun kǝ ri kǝ piwu? Mbarǝm tu capo nye mǝn atl kǝ Roma ni!>> ");
INSERT INTO plj_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Kan komandayi ba ri kar Bulus tǝ ngen momi kar ti'e, <<Yari mi, ki nye mǝn atl kǝ Roma na?>> Bulus bali ti'e, <<Aan, untuni.>> ");
INSERT INTO plj_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Kan komandayi ba wule, <<Na ɓatli wurpi na naari ni kan a dǝm nye mǝn atli.>> Bulus bali ti'e, <<Ama amo tǝp kǝ ba gǝri ni a dǝm nye mǝn atli.>> ");
INSERT INTO plj_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Munju kan far ba ri kǝ gadlǝr Bulus gip shirǝm na kumi untuwo arni wu dǝlka na kari. Komandayi na gam gǝs ma ar ghun ti domici tǝ ɓal Bulus, nye mǝn atl kǝ Roma na sarsari. ");
INSERT INTO plj_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Komandayi den ndu'i tǝ mom ununu Bulus pi kan mǝn Yahudayi ba ɗir ti cina dǝ mǝn bǝni. Bar tlowo arni tǝ bi bi den dǝ kiri mǝn keri bar ju ɗiri Yam na kup kan gip domtǝn kǝ mǝn tloyi shirǝm kǝ mǝn Yahudayi dom wur cina da ti. Kan tǝ pǝtl Bulus tǝ kem tǝ dlǝr cina da wuri. ");
INSERT INTO plj_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Bulus wi ger domtǝn kǝ mǝn tloyi shirǝm kǝ mǝn Yahudayi, kan tǝ wule, <<Mir ɓyari, mbatl gǝn kemǝn kǝ ngeni momi kandatu a dǝm cina dǝ Yam gip kup dǝmi gǝn da'a.>> ");
INSERT INTO plj_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Den yari muntu ni Hananiya, bar mǝn keri bar ju ɗiri Yam kem munju kan dlor kosak na Bulus gwa wu ɓo bi gǝsi. ");
INSERT INTO plj_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Arni Bulus wul ti'e, <<Yam ba ɓo'i, ki mǝn se mbarǝme! Kǝ dǝm ɗe kǝ tloyi shirǝm mbarǝm den tǝp kǝ doka, ama kǝ cen doka ka na kemi dǝ ɓo mi!>> ");
INSERT INTO plj_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Arni munju kan ra kosak na Bulus wul ti'e, <<Kǝ pi mǝgǝn shirǝm bar mǝn keri bar ju ɗiri Yama?>> ");
INSERT INTO plj_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Bulus nǝmi wur tǝ wule, <<Mir ɓyari, a mom den ti ni'e bar mǝn keri bar ju ɗiri Yam gwada'a, domici shirǝm kǝ Yam wule, <Ba kǝ yari wani shirǝm den bari kǝ bǝn gin da'a.> >> ");
INSERT INTO plj_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Nan Bulus momka'e jen gip domtǝn kǝ mǝn tloyi shirǝm kǝ mǝn Yahudayiwo wini gip me gam kǝ mǝn Sadukiya, kan jen ngapo wini gip me gam kǝ mǝn Parisewo, arni tǝ tli yar tǝ wule, <<Mir ɓyari, ami ma Ba mǝn Parise ni, nya Ba mǝn Parise. Ɗirǝm cina kǝ dǝ kumǝn den bi la'i mbatl gǝn den Yam baa tli mǝshi mbarǝm na rai esi.>> ");
INSERT INTO plj_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Nan wu kum untuwo, arni mǝn me gam kǝ mǝn Pariseyi na mǝn me gam kǝ mǝn Sadukiya nǝm pali shirǝm musu gip dlom dawuri. Arni wu tatlka bomi rop. ");
INSERT INTO plj_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(Me gam kǝ mǝn Sadukiya ba nge den mǝshi mbarǝm ba tli na rai esi, kan mir mǝn kartǝn kǝ Yami ko ga dun itǝr ra da'a, ama mǝn me gam kǝ mǝn Pariseyi la mbatl den kup myakan ju.) ");
INSERT INTO plj_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","La'i yari naarka, kan jen gip mǝn kulci mbarǝm den kulci kǝ Musa kan gip me gam kǝ mǝn Parise ba tlyam wu zili gerka den shirǝm tu wu wule, <<Mǝ shin wani bar gon na mbarǝm tu da'a! Woni mom ko ruhu gon ni ko mǝn kartǝn kǝ Yam gon ni shirǝm nan ti gwa?>> ");
INSERT INTO plj_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Arni bali shirǝmi gip dlom da wur palka wule dlanye har komandayi kum bǝrti den ba wu tlyat Bulus gip dlom da'a. Kan tǝ kem mǝn bi-utu gǝs wu ri ɗǝli tika am da wur na ndǝrtǝn kǝ bigul wu pali ti gip las tu ga mǝn bi-utuyi ba dǝm gwa. ");
INSERT INTO plj_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Zut gaso Babom Yesu dlǝr kosak na Bulus kan tǝ wule, <<Zam ɓa'i bigule! Kandatu kǝ yar shirǝm demǝn gip Urushalimawo, ki pa yari shirǝm demǝn gip Roma esi.>> ");
INSERT INTO plj_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Bar tlowo, mǝn Yahuda ɓal bika na ɓali gam gǝzǝn gip shirǝm den wi ci ko tla argon da'a se wini wu ri Bulus eka. ");
INSERT INTO plj_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Mbarǝm kan mo bi den gudlum shirǝm tuwo wu man hauya rop. ");
INSERT INTO plj_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Arni wu ri kar kiri mǝn keri bar ju ɗiri Yam gwa na kiri kǝ bǝn wu wule, <<Mǝ ɓal gam gǝmi gip shirǝm wi den mi ci ko mǝ tla argon da'a se mǝnni mǝ ri Bulus eka. ");
INSERT INTO plj_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Kǝkǝno, mǝ ndu kǝn na domtǝn kǝ mǝn tloyi shirǝm kǝ mǝn Yahuda kǝ kar ni bar na shirǝm den komanda den dǝ ɗiri Bulus kar kǝne wule kǝ ndu ni kǝ zam ndǝri shirǝm jen ra gip shirǝm gǝsi. Mi ri ti eka den tǝpe kapǝn tǝ mbubar ɗe.>> ");
INSERT INTO plj_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ama nye kawu kǝ Bulus kum argon tu wu gudlumi gwa, kan tǝ te gip las tu mǝn bi-utuyi ba dǝm gwa tǝ yari Bulus ka. ");
INSERT INTO plj_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Arni Bulus la bi nǝm gip mir kiri kǝ mǝn bi-utuyi kan tǝ wul ti'e, <<Ri na nye mbarǝm tu kar komanda. Tǝ na ar gon kan tǝ ri kǝ yari ti gwa.>> ");
INSERT INTO plj_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Kan tǝ ri na nyayi kar komandayi. Nye bari kǝ mǝn bi-utuyi wule, <<Bulus, ɓali gip bom kǝ moni tu ni karim bar kan tǝ wulǝm'e a ɗiri nya mbarǝm kǝn kar ki domici tǝ na argon kan ti yari'i gwa.>> ");
INSERT INTO plj_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Arni komandayi nǝm am kǝ nye mbarǝmi, tǝ dǝl ti markǝm kan tǝ ngen momi kar ti'e, <<Unun kǝ ndu kǝ yarim we?>> ");
INSERT INTO plj_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Nye kawu kǝ Bulusiyi wule, <<Mǝn Yahuda ne bi den'e gǝniwo wi ndu kǝ za dǝ si wur na Bulus cina dǝ domtǝn kǝ mǝn tloyi shirǝm kǝ mǝn Yahuda, wule wu ndu ni wu zam ndǝri shirǝm jen ra den ti. ");
INSERT INTO plj_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Ama ba kǝ nǝmi wur da'a, domici mbarǝm ra kan man hauya rop kan ghun gǝzǝn wu den ɓuti gǝs gwa. Wu pǝni gam gǝzǝn wi den wi ci barkǝci ko wu tla mal da'a se wi ni wu ri Bulus eka. Kǝkǝno wu ra gǝɗǝn, wu den ɓuti kǝ kopi wur kar kǝ argon tu wu ndu gwa.>> ");
INSERT INTO plj_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Arni komandayi wul nye mbarǝm'e tǝ ndara na dǝli ti kǝm'e, <<Ba kǝ yari murgon'e kǝ yarim shirǝm tu da'a.>> ");
INSERT INTO plj_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Arni komandayi la bi rop gip mǝn bi-utu kan atli nan ti gwa, kan tǝ bi wur bi tǝ wule, <<Yemni mǝn bi-utu hauya kutl, mǝn totǝn den pǝrsi mbarǝm hauya myakan na kutl, na mǝn bi-utu mǝn dlan na gesh hauya kutl den bi tetǝn Kaisariya bar kǝ gǝlla am ghanum kǝ gas kǝni. ");
INSERT INTO plj_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Zami Bulus pǝrsi kan ti to dene gwa, kǝ mbubar nan ti kar Gobna Feliks ba dǝ argon zam ti da'a.>> ");
INSERT INTO plj_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Kan komandayi ba rǝsh tǝlankur na shirǝm nan kǝni. ");
INSERT INTO plj_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Ar ɗǝl kar Kǝlaudiya Lisiyas. Dǝ si Mǝn Nartǝni, Gobna Feliks: A shirmi ika. ");
INSERT INTO plj_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Mǝn Yahuda ni nǝm mbarǝm kǝn wu ndu ri gǝs eka ama a ri na mǝn bi-utu a ɗǝli ti, domici a zam na momi'e tǝ nye mǝn atl kǝ Roma ni. ");
INSERT INTO plj_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","A ndu a mom den ununu wu ri ti cina ra, kan a su nan ti kar domtǝn kǝ mǝn tloyi shirǝm gǝzǝn kǝ mǝn Yahuda. ");
INSERT INTO plj_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Arni a zam bar ju wu ri ti cina denewo shirǝm ni den kulci gǝzǝni, ama tǝ pi argon muntu kan ndari dǝ ri ti eka ko dǝ ɓal ti gip bom kǝ moni gwa da'a. ");
INSERT INTO plj_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Nan yarimka den jen gudlum wani bar gon kan wu ndu wu pi tiwo, a dǝm kǝ argon da'a ama a ture'i ti teka. A yari mǝn ri gǝs cina den wu ri'i bar ju kan wu ri ti cina dene gwa. ");
INSERT INTO plj_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Arni mǝn bi-utuyi pi argon tu wul wur ragwa, kan wu pǝn Bulus gip gasi wu ndara na dlyami har Antipatǝris. ");
INSERT INTO plj_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Bar tlowo, mǝn bi-utu kan su den asǝm pal gǝzǝn kǝ ba dǝmi gǝzǝn gip Urushalima kan wu za mǝn totǝn den pǝrsi wu su na Bulus Kaisariya. ");
INSERT INTO plj_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Nan wu mbubar Kaisariyawo, arni wu bi gobna Feliks tǝlankuri kan wu bi Bulus am da ti. ");
INSERT INTO plj_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Gobnayi zhit tǝlankuriyi kan tǝ ngen momi kar Bulus den kǝti kǝ atli kan tǝra gwa. Nan tǝ kum'e Bulus mǝn Kilikiyano, ");
INSERT INTO plj_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","arni tǝ wule, <<Aa kum shirǝm gi wokoci tu mǝn ri gi cinayi mbira gwa.>> Kan tǝ wule dǝ ne ger den Bulus gip bom kǝ gun Hiridus. ");
INSERT INTO plj_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Muri nantam den kariwo, arni Hananiya bar mǝn Keri bar ju ɗiri Yam su Kaisariya, nan ti na kiri kǝ bǝn jen na mǝn momi doka kǝ mǝn Roma gon mǝn sun Tatulus. Kan wu ri shirǝm gǝzǝn den Bulus cina dǝ Gobna Feliks. ");
INSERT INTO plj_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Nan la bi Bulus ter gipiwo, arni Tatulus yari argon tu kan wu ri Bulus cina dene gwa nan kǝni, <<Mǝn Nartǝni! Mani kopi na mbarǝm gi na bopya ɗiri mi dǝmi zhǝlili kǝ tlyari wokoci, na sanje bar na womti kan ɗiri atl gǝmi mbuni bar gwa. ");
INSERT INTO plj_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Mǝn Nartǝn Feliks, gip kogonge las na tǝp ko ako mǝ goode'i naari. ");
INSERT INTO plj_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Ama kǝ dǝ ba a li'i wokoci nar dawo, a lir ki den kǝ kum nye argon tu mǝ ri kǝ yari gwa. ");
INSERT INTO plj_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","<<Mǝ zam mbarǝm kǝno mǝn tli bǝn mbatl yam ni, tǝ den tli mbatl mǝn Yahuda gip atl kundǝrǝndlip. Ti ni'e mǝn kopi na me gam kǝ munju kan Naziri ni gwa. ");
INSERT INTO plj_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Ra eso, tǝ ndu tǝ li bom kǝ Yamka, arni mǝ nǝm ti. ");
INSERT INTO plj_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Mǝ ndu mǝ tloyi ti shirǝm den tǝp tu kan kulci gǝmi yari gwa, ama komanda Lisiyas ter na ndǝrtǝn kǝ bigule tǝ pǝn tika kar mi. ");
INSERT INTO plj_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Kini kǝ ngen momi kar ti na gam giwo, ki zam ge shirǝm den kup bar ju mǝ ri ti cina ra dene gwa.>> ");
INSERT INTO plj_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Kan nami mǝn Yahudayi ba nda gipi na ɗiri shirǝm gǝzǝn, den'e kup bar ju Tatulus yariwo untuni anra. ");
INSERT INTO plj_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Nan gobnayi pi am Bulus kǝ dǝ tǝ shirǝmo, arni tǝ wule, <<A mom kǝ pi ta tloyi shirǝm mǝn atl kǝn kǝ sheti ghon na womti wi. A kum tǝmi kǝ yari shirǝm ho'i gam gǝn cina da'i. ");
INSERT INTO plj_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Ki mani momi na gamgi den gip mir muri kan man kutl-cet rop da'a ter karo, a su Urushalima kǝ bote Yami. ");
INSERT INTO plj_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Mǝn ɗiri gǝn cinayi zamǝn den bali shirǝm na murgon gip bom kǝ Yami, ko tli mbatl kǝ womti mbarǝm kan gip bom domtǝn kǝ mǝn Yahuda ko nǝm gip las gon gip bǝni da'a. ");
INSERT INTO plj_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ko nǝm wi mani tabbate'i bar ju wu ɗirim cina dene gwa dak. ");
INSERT INTO plj_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ama a yari'i den a bote Yam kǝ ga ba gǝmi kandatu mǝn kopi Tǝp kǝ Yesu kan ba la wur bi'e me gam kǝ mǝn lar gon gwa. A nǝm kup argon tu Kulci kǝ ga ba gǝmi na kup bar ju rǝsh gip tǝlankur kǝ ga mǝn yari shirǝm kǝ Yam gwa. ");
INSERT INTO plj_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Ami ra na la'i mbatl den Yam kandatu munju nari, den tlitǝn kǝ mǝshi mbarǝm kǝ kup mǝn pitǝn dlat na mǝn ɗasi tu gwa. ");
INSERT INTO plj_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Den untuni mbatl gǝn kemǝn kǝ ngeni momi kandatu a dǝm cina dǝ Yam gip dǝmi gǝn na cina dǝ mbarǝm kup da'a. ");
INSERT INTO plj_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","<<Den kar kǝ sheti ghon na womti kan ami ra dawo, a pal su Urushalimaka na bar kǝ ne am mbarǝm gǝn kan am ri wur kaar dagwa, na kǝ mboshi dabba kan ba bi Yam gip bota gwa. ");
INSERT INTO plj_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Nan wu zamǝn gip Bom kǝ Yamo, a pa'i pi bar ju ba pi kǝ pali mbarǝm dlat cina dǝ Yam gwa wi. Womti mbarǝm ra na mǝn dak, kan za mǝn gip guzǝl-guzǝl pitǝn gon dak. ");
INSERT INTO plj_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Ama mǝn Yahuda jen kan tli tor gip atl kǝ Asiya ra lasi, wu ma ar mbun wu nǝra ɗe cina da'i wu ɗiri shirǝm gǝzǝni wi nǝra na shirǝm gon demǝn gwa. ");
INSERT INTO plj_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ko mbarǝm jǝn kan ɗe ba mani yari wani bar tu wu zamǝn nari nan a dlǝr cina dǝ domtǝn kǝ mǝn tloyi shirǝm kǝ mǝn Yahuda gwa, ");
INSERT INTO plj_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","nan man yar kan a tli nan ami cina da wur kan a wule, <Den shirǝm kǝ tlitǝn kǝ mǝshi mbarǝm na rai kan a la mbatl dene gwani ami cina da in sekǝni.> >> ");
INSERT INTO plj_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Arni Feliks, kan yari ti shirǝm nar den Tǝp kǝ Yesu wi, ne zut dǝmi kǝ kumi shirǝmi na wultǝn'e, <<Wokoci tu Lisiyas komanda mbirawo aa mom argon tu a pi den shirǝm gi tu gwa.>> ");
INSERT INTO plj_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Kan tǝ wul mǝn bi-utu kan Bulus gip am dati gwa den dǝ ne ger den ti, ama dǝ za ti tǝ mani ɗǝltǝn na tetǝn gip bom kǝ moniyi, kan dǝ pa za ga berǝm gǝs wu shin ti wu bi ti argon tu tǝ ndu gwa. ");
INSERT INTO plj_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Den kar kǝ muri na womtiwo, Feliks ter na nagǝr gǝs Dǝrusila muntu kan mǝn Yahuda ni gwa. Tǝ kar bar den Bulus kan tǝ kum shirǝm gǝs den ngǝshtǝn gǝs den Almasihu Yesu. ");
INSERT INTO plj_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Ama nan Bulus ci cina na shirǝm den pitǝn dlat, nǝmi gami, na pǝt tu kan Yam baa tloyi mbarǝm shirǝmo, arni Feliks kum bǝrti kan tǝ wule, <<Ar kǝm untuwi! Ki mani ndaratǝni. Ami ni a zam mbul gono, aa la ki bi esi.>> ");
INSERT INTO plj_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Ti ni den la'i mbatl den dǝ Bulus bi ti ci icine. Ra untuwo, arni tǝ meti la'i bi Bulus kǝ shirǝm nan ti. ");
INSERT INTO plj_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Den kar kǝ sheti-ghon rop den untuwo, kan Porkiyas Festus ba pal gobna den am kǝ Feliks. Nan Feliks den ndu'i dǝ mǝn Yahuda ndu tǝwo, arni tǝ za Bulus gip bom kǝ moni. ");
INSERT INTO plj_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Nan Festus mbubar gip atl kǝ Kaisariya kǝ nǝmi pi mbap gǝs kǝ gobna na muri myakano, arni tǝ ndara Urushalima. ");
INSERT INTO plj_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Kiri mǝn keri bar ju ɗiri Yam na kiri mǝn bǝn kǝ Yahuda mo nan ti lasi kan wu ɗiri ti shirǝm den Bulus. ");
INSERT INTO plj_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Wu lir Festus den tǝ nǝmi wur kǝ dǝ pali wur na Bulus su Urushalimaka, domici wu gudlumi ni kǝ ri gǝs eka den tǝpe. ");
INSERT INTO plj_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Festus nǝmi wur'e, <<Buluso le tǝnika nye mǝn bom kǝ moni gip Kaisariya, ami na gam gǝn ma ar baa dlyam da'a aa te barta. ");
INSERT INTO plj_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Naa dǝ kiri mǝn bǝn gin te Kaisariya na mǝni kan wu ɗiri shirǝm gǝs in tǝ pi wani bar gon gwa.>> ");
INSERT INTO plj_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festus dǝm kǝ muri wuzupse ko kutl nan wuri, kan tǝ nde ndaratǝn Kaisariya. Bar tlowo, kan tǝ dǝm den dandi tloyi shirǝm gǝs tǝ wule dǝ teri ti Bulus. ");
INSERT INTO plj_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Nan Bulus ter gipiwo, mǝn Yahuda ju kan tli tor Urushalima la ti te dlom ka. Wu nǝm ɗiri ndǝri shirǝm gǝzǝn na womti den ti. Shirǝm ju kan wi mani tabbate dagwa. ");
INSERT INTO plj_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Kano Bulus ba pi shirǝm ho'i gam gǝs nan kǝni, <<A pi argon mǝgǝni na kulci kǝ mǝn Yahuda ko Bom kǝ Yami ko bar gun kǝ Roma da'a.>> ");
INSERT INTO plj_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Ama nan Festus den ndu'i tǝ gholi mbatl mǝn Yahudawo, kan tǝ ngen momi kar Bulus tǝ wule, <<Kǝ ndu kǝ to Urushalima dǝ kum shirǝm gi den bar ju ɗiri den ki barta cina da'ǝma?>> ");
INSERT INTO plj_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Ama Bulus nǝmi ti'e, <<Ami ni dlor cina dǝ bom tloyi shirǝm kǝ Bar Gun kǝ Roma, las tu ar ndari dǝ tloyim shirǝm gwa. A pi wani bar gon mǝn Yahuda da'a, kandatu ki na gam gi mom gwa. ");
INSERT INTO plj_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Amin a cen doka gonka kan ndari dǝ rin ewo, a nge a mǝsh da'a. Ama bar ju mǝn Yahuda ju ba yari demǝn in untun anra dawo, murgon ra kan baa mani bi gǝn am dǝ mbarǝm ju gwa da'a. A liri dǝ si shirǝm gǝn cina dǝ Bar Gun kǝ Roma!>> ");
INSERT INTO plj_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Arni Festus den kaar kǝ bali na mǝn bali gǝso, kan tǝ wul ti'e, <<Kǝ liri den dǝ si shirǝm gi cina dǝ Bar gun kǝ Roma, kar Bar Gun kǝ Romayi ni ngap baa si'i!>> ");
INSERT INTO plj_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Mir muri jem den kariwo Gun Agǝripa na nye mǝn gǝpi gǝs gǝr mǝtli mǝn sun'e Banis te Kaisariya kar Festus kǝ pi ti ɗem na cwattǝni. ");
INSERT INTO plj_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Nan wu mur barta na womtiwo, Festus yari gunyi argon tu Bulus ra gipi gwa. Tǝ wule, <<Mbarǝm gon ra kan Feliks za im tǝ ɗe gip bom kǝ moni gwa. ");
INSERT INTO plj_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Nan a su Urushalimawo, arni kiri mǝn keri bar ju ɗiri Yam na kiri mǝn bǝn kǝ Yahuda ɗiri shirǝm den ti kan wu lirǝm den a tloyi ti shirǝm'e dǝ hukunte ti. ");
INSERT INTO plj_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","<<A yari wur'e doka kǝ Roma wule dǝ tloyi mbarǝm shirǝm hukuntetǝn bat na me ger na mǝn ri gǝs cinayi da'a. Ar pa wule dǝ za ti tǝ ho gam gǝs den bar ju ne ti te gamka gwa. ");
INSERT INTO plj_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Nan wu ter ɗe na mǝno, a dǝl den shirǝmi da'a, arni bar tlowo a dǝm den dandi tloyi shirǝm gǝn kan a wule dǝ ter na mbarǝmi gipi. ");
INSERT INTO plj_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Nan mǝn ri gǝs cinayi dlǝr kǝ shirǝmo, ko nǝm wani bar gon ra kan tǝ pi wule kandatu a pǝn gwa da'a. ");
INSERT INTO plj_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Kup bar ju wu yariwo dǝli shirǝm ni den adini gǝzǝn na den mbarǝm gon mǝn sun'e Yesu, muntu kan mǝshka, ama Bulus wule tǝra na rai gwa. ");
INSERT INTO plj_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","A mom argon tu aa pi gwa da'a nan gam gudluminka den kandatu aa kop kar kǝ shirǝm ju gwa. Ra untuwo, arni a ngen momi kar Bulus in ti ndu tǝ su Urushalima dǝ kum shirǝm gǝs barta den bar ju gwa. ");
INSERT INTO plj_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Ama Bulus liri den Mǝn Nartǝni, Bar Gun kǝ Roma ni ba tloyi ti shirǝmi. Arni a kem dǝ ne ger den ti kǝ dǝ a pi tǝp tu kan ba si ti kar Bar Gun kǝ Romayi gwa.>> ");
INSERT INTO plj_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Arni Agǝripa wul Festus'e, <<Aa ndu a kum mbarǝm tu na gam gǝni.>> Festus nǝmi ti'e, <<Gǝniwo ki kum ti.>> ");
INSERT INTO plj_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Bar tlowo arni mbarǝm na womti dom wur kǝ pi Agǝripa na Banis bar na womti gip shini nartǝn gǝzǝni. Wu te gip bar kushi gon kan mbarǝm ba dom wur lasi gwa na ga kiri mǝn bi-utu na mbarǝm kan mom wur nar gip bǝni gwa. Kan Festus ba bi bi'e dǝ ɗǝli Bulus teri. ");
INSERT INTO plj_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Festus wule, <<Gun Agǝripa, na kup munju kan ra nan mi ɗegwa, shin ni mbarǝm kǝni! Kup mbarǝm kǝ Yahuda ɗirim shirǝm den ti na gip Urushalima na ɗe gip Kaisariya, wu den la'i yar den ba dǝ za ti den kaar bar atl da'a. ");
INSERT INTO plj_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ama a mani zami argon kan tǝ pi nan ndari dǝ ri ti eka gwa da'a. Ama nan tǝ wule dǝ si shirǝm gǝs kar Mǝn Nartǝn Bar Gun kǝ Romawo, arni a pǝn tor gip mbatl gin den dǝ si ti Romayi. ");
INSERT INTO plj_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Ama ami na ko argon nǝm kan a rǝshi Bar Gun kǝ Roma tǝlankur den ti gwa da'a. Ra untuwo arni a ɗir ti ɗe cina da in kup, na cina da'i, Gun Agǝripa, den min ni mǝ ngen momi bar jen kar tiwo, a zam argon tu kan a rǝsh gwa. ");
INSERT INTO plj_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","A shino ar den tǝp da'a dǝ kar bar na nye mǝn bom kǝ moni dǝ Bar Gun kǝ Roma bat na yari argon tu ba ri mǝri cina dene gwa.>> ");
INSERT INTO plj_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Kan Agǝripa ba wul Bulus'e, <<Ki mani yari shirǝm ho'i gam gi.>> Arni Bulus tlyam tǝ pi am kǝ bi nartǝn kiri kan tǝ nǝm shirǝm ho'i gam gǝs nan kǝni. ");
INSERT INTO plj_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","Tǝ wule, <<Gun Agǝripa, ar tǝmim bi nan sekǝno ari kǝ pi shirǝm ho'i gam gǝn den bar ju kup mǝn Yahuda ba wule a pi gwa. ");
INSERT INTO plj_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","A yari ni untu bi tu nan kiwo kǝ mom hoyi kandatu mǝn Yahuda ba dǝm na tǝp ju wura bom na ezǝn gwa. Kǝkǝno, kustu, a lir ki den kǝ kumǝn na te mbatl karka. ");
INSERT INTO plj_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","<<Mǝn Yahuda kup mom kandatu a dǝm tun a'i nyayi, den dǝmi gǝn gip atl gǝni, na gip Urushalima es gwa. ");
INSERT INTO plj_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Wu momǝn terka, kan wi pa mani yari, arni pǝni mbatl gǝzǝn gwa, den a dǝm ni den tǝp kǝ banyi me gam kǝ kopi Yam gǝmi, a pi ni dǝmi kǝ Ba mǝn Parise. ");
INSERT INTO plj_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Kǝkǝno, domici la'i mbatl tu ami nari den argon tu Yam wule ti pi ga ba gǝmi gwani ami ɗe sekǝn kǝ dǝ tloyim shirǝmi. ");
INSERT INTO plj_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Muntu ni'e argon tu Yam wule ti pi gǝsgal gǝmi kutl cet rop kan ba la mbatl kǝ shini latǝn gǝs nan wu bote Yam na mbatl nǝm pǝt na gas gwa. Mǝn Nartǝni, den la'i mbatl tuni mǝn Yahuda ɗirǝm cina dǝ mǝn bǝn ra. ");
INSERT INTO plj_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Unun kem gon gip kǝn ba shin'e bar mǝn pitǝn ni da'a den'e Yam ba tli mǝshi mbarǝme? ");
INSERT INTO plj_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","<<Ami ma faro a pǝn den a mani pi kup argon tu a mani kǝ nge sun kǝ Yesu kǝ Nazarat tu. ");
INSERT INTO plj_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Argon tu a pi gip Urushalima gwa utu. Nan a zam bi kǝ ga kiri mǝn keri bar ju ɗiri Yam gwa, a kem ɓal mǝn ngǝshtǝn den Yesu na womti gip bom kǝ moni. Nan ba ri wur ekawo, ami ra gip mǝn kopi kaar kǝ dǝ pi wur untuyi. ");
INSERT INTO plj_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Biyi na womti a kop bom domtǝn kǝ mǝn Yahuda na nǝm nǝm den hukunte gǝzǝni, kǝ dǝ a kem wur kǝ paltǝn na kaar gip ngǝshtǝn gǝzǝn den Yesu. Gip kumi lo gǝn den wuro a kop gip kiri bǝn kǝ kari ma kǝ kumi wur dli. ");
INSERT INTO plj_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","<<Bulus ci cina tǝ wule, <Mǝn Nartǝni, gasi gon gip ɓomi asǝm juni a su Dimashka na rǝshi tǝlankur kan yari'e a mani pi na bii bi kǝ kiri mǝn keri bar ju ɗiri Yam gwa. ");
INSERT INTO plj_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Gunye, ami den tǝp gǝn nan pǝt to dlom yamo, arni pǝlǝt a shin bar cirtǝn sur yami. Cirtǝn tu kan man kǝ pǝt gwa, kan ba cir karǝm na ga berǝm ɓomi asǝm gǝni. ");
INSERT INTO plj_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Arni kup gǝmi mǝ nda atlka, kan a kum yar gon ba wulǝm gip bi kǝ mǝn Yahuda'e, <<Shawulu, Shawulu, unun kem kǝ kumim dli rawu? Kǝdlǝm pitǝn ni kǝ dlan ki namǝni.>> ");
INSERT INTO plj_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","<<Arni a ngen momi a wule, <Wo ni'e ki, Babomi?> Kan Babom ba nǝmim'e, <Ami ni'e Yesu, muntu kǝ kumi ti dli gwa. ");
INSERT INTO plj_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Kǝkǝno tlyami kǝ dlǝr den asǝm gi. A ɗǝl ni kar ki kǝ dǝ a pali'i zher mǝn yari argon tu kǝ shin demǝn kan aa pal a gode'i cina ɗe gwa. ");
INSERT INTO plj_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Aa ɗǝli'i gip am dǝ mbarǝm gin mǝn Isra'ila na munju kan mǝn Yahuda ni da gwa. Aa kar ki ni kar wur ");
INSERT INTO plj_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","kǝ dǝ kǝ ɓul ger gǝzǝn wu mani shini bari. Wu bali kaar shini bar gip dǝmǝn wu mani shini gip cirtǝni. Wu ɗǝlka gip am dǝ Shetan wu pal kar Yami tǝ dǝm gun gip mbatl gǝzǝni. Untu ni wi zam dǝ pǝni wur warwat pitǝn gǝzǝnka kan dǝ Yam bi wur las gip munju kan pali wur dlat tǝp kǝ ba ngǝshtǝn demǝni.>> ");
INSERT INTO plj_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","<<Bulus ci cina na shirǝm tǝ wule, <Gun Agǝripa, arni kem a nge kopi ruya tu a shin sur yam gwa da'a. ");
INSERT INTO plj_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","A pi munju kan gip Dimashka wazu gǝn kǝ nǝm, kano munju kan gip bǝn Urushalima gwa na gip atl kǝ Yahuda kup, na munju kan mǝn Yahuda ni da ma. A pi wur wazu den wu ci atl gam wu pal kar Yami, kan wu pi bar ju baa gode'e wu ci atl gam wi tǝp kǝ ba mbap gǝzǝni. ");
INSERT INTO plj_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Muntu ni kem mǝn Yahuda nǝmǝn nan ami gip Bom kǝ Yam gwa, wu ndu rigǝn eka. ");
INSERT INTO plj_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ama Yam ni pi ta nem am ra ar ba ɗir sekǝn kan a dlǝr ɗe kǝ yari kogonge mbarǝm ko-ako gwa. Argon ni a yari bom na muntu kan ga mǝn yari shirǝm kǝ Yam na Musa yari den baa pi gwa da'a. ");
INSERT INTO plj_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Ar nǝm den dǝ Almasihu kum dli, kan tǝ dǝm kǝ nǝm gip tlitǝn gip mǝshi mbarǝme. Tǝ yari shirǝm den cirtǝn kǝ zami ɗǝltǝn kǝ mbarǝm gǝs mǝn Isra'ila na munju kan mǝn Yahuda ni dagwa.> >> ");
INSERT INTO plj_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Nan ar ɗir den muntuwo, arni Festus la yar tǝ wule, <<Bulus gam ɓuli'i kawi! Kulci gi na naari kem kǝ te mǝn zhe'e kawi.>> ");
INSERT INTO plj_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Ama Bulus nǝmi ti'e, <<Mǝn Nartǝn Festus, ami mǝn zhe'e ni da'a! Ge shirǝm ni a yari. ");
INSERT INTO plj_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Bar ju pini na ghuuni da'a. A mom'e Gun Agǝripa mom bar ju. Ar ni kem a shirǝm nan ti bat na bǝrti. ");
INSERT INTO plj_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Gun Agǝripa, kǝ ngǝsh ki den shirǝm kǝ ga mǝn yari shirǝn kǝ Yama? A mom kǝ pi.>> ");
INSERT INTO plj_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Arni Agǝripa wul Bulus'e, <<Kǝ shin wule gip nye wokoci kǝno ki palim Kǝristaya?>> ");
INSERT INTO plj_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Bulus nǝmi ti'e, <<Ko kǝ heli ko tlyari wokoci ni ma, shirǝm na Yam gǝn den ki na nami gin kup kan den kumi gǝn sekǝn gwa ni'e kǝ pal ni kandatu ami ra gwa, bat na sarsari jǝni!>> ");
INSERT INTO plj_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Arni gunyi, na gobna, na Banis na kup munju njon nan wur tlyami. ");
INSERT INTO plj_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Arni wu za kushiyi, nan wu den shirǝm na ezǝno, arni wu wule, <<Mbarǝm kǝn den pi argon tu baa kem dǝ ri ti eka ko dǝ la ti gip bom kǝ moni gwa da'a.>> ");
INSERT INTO plj_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Kan Agǝripa ba wul Festus'e, <<Tǝ wule dǝ pǝn shirǝmi tǝ si Bar Gun Kǝ Roma gwani dawo, da za mbarǝm kǝn tǝ ndara wi.>> ");
INSERT INTO plj_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Nan wu ne den mi to gip kungǝlǝn jikat mal mǝ ndara Italiyawo, arni wu la Bulus na mir mǝn bom kǝ moni jen am dǝ bar mǝn bi-utu kǝ Roma gon mǝn sun'e Yuliyas, muntu kan ra gip Me gam kǝ Mǝn Bi-utu Kǝ Bar Gun kǝ Roma gwa. ");
INSERT INTO plj_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Kan mǝ to gip kungǝlǝn jikat mal gon kǝ Adǝramitiyum, muntu kan ne den ti dlǝr kǝ ba shu'i na yemi gosgam bi-ɓula na womti gip atl kǝ Asiya gwa, kan mǝ ɓe cina. Aristarkus, mbarǝm kǝ gip bǝn kǝ Tasalonika kan gip atl kǝ Makidoniya ra nan mi. ");
INSERT INTO plj_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Bar tlowo arni mǝ mbubar gip Sidon. Yuliyas pi Bulus mbuni bar na za'i gǝs tǝ ri shin ga berǝm gǝs kǝ dǝ wu bi ti bar ju tǝ ndu gwa. ");
INSERT INTO plj_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Mǝ za barta kan mǝ kop den gam mal esi. Mǝ mbubar kosak na atl kǝ Saipǝros nan itǝr za mi mǝ ri las tu mǝ ndu ritǝn gwa da'a. ");
INSERT INTO plj_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Nan mǝ jikat bar dlyami ɓula kan kosak na Kilikiya na Pamfiliyawo, kan mǝ ter gip bǝn kǝ Mira gip atl kǝ Likiya. ");
INSERT INTO plj_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Barta ni bar mǝn bi-utuyi zam kungǝlǝn jikat mal kǝ Alekzandǝriya kan ne gam Italiya gwa, arni tǝ la mi gipi. ");
INSERT INTO plj_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Mǝ kop na kungǝlǝn jikat mali ɗem-ɗem kǝ muri na womti, den ta ndotǝn na itǝri kan mǝ mbubar kosak na bǝn kǝ Kǝnidus. Nan itǝr baa za mi mǝ mani ci cina dawo, arni mǝ kop tǝp markǝm atl kǝ Kǝrita kan te dlom bar ɓulaka kosak na bǝn kǝ Salmoni. ");
INSERT INTO plj_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Mǝ kop bi mal kǝ Kǝritayi na banyi mǝ mbubar las gon kan ba la ti bi'e Mbuni Badǝmi, kosak na bǝn kǝ Lasiya. ");
INSERT INTO plj_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Ɓomi asǝm gǝmi dǝl naari, nan ar dǝm'e den kaar Pǝt Guzum Mal nikan ci cina gǝmi den gam mali dǝm bar kǝ bǝrti gwa. Arni Bulus wul wur'e, ");
INSERT INTO plj_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","<<Mir ɓyari, a shin'e ci cina na ɓomi asǝm gǝmi ra gip tli mbatli. Ar ba dǝmi ho bar kungǝlǝnyi da'a na holi zami gosgam kǝ gipi, kan na holi zami dǝmi gǝmi na rai.>> ");
INSERT INTO plj_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Ama bar mǝn bi utuyi ne kǝm den argon tu Bulus yari gwa da'a, kan tǝ kop shirǝm kǝ mǝn dǝli kungǝlǝn jikat mali na ba-mǝn kungǝlǝnyi. ");
INSERT INTO plj_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Nan bane kungǝlǝn jikat mal kan argon baa zam da'ayi mbun hoyi kǝ ci watlǝn gipi dawo, arni na womti gip mǝn mbap kǝ kungǝlǝnyi pǝn gip mbatl gǝzǝn den mǝ ci cina na tetǝn den gam male. La'i mbatli ni'e kǝ dǝ mǝ mbubar Finiks dǝ ci watlǝn barta. Finikswo ho ba ne kungǝlǝn jikat mal kan argon baa zam da'a gwa ni gip atl kǝ Kǝrita, kan ɓuli bar ɓula tǝp kudu kan ba shin Yemma na Arewa kan ba shin Yemma katl gwa. ");
INSERT INTO plj_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Nan nye itǝr nǝm ɓe tor tǝp kuduwo, arni mǝn dǝli kungǝlǝn jikat mali pǝn'e wi ci cina na argon tu wu ndu pi gwawi. Arni wu dǝl bar gǝlla tu kan ba kem dǝ kungǝlǝn jikat mali dlǝr kǝ ba lasi nǝm gwa kan wu kop na kungǝlǝnyi markǝm bi ɓula kosak na atl kǝ Kǝrita. ");
INSERT INTO plj_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Ko njem arri kǝtǝgon da'a anni bar itǝr gon kan ba la ti bi Arewa kan ba shin Gabas ba ɓe ter den gam mali. ");
INSERT INTO plj_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Kan itǝri ba ɓo kungǝlǝn jikat mali ar ba dǝm'e mǝn dǝliyi i'mbu tari tǝp gip itǝri da'a, arni wu za ti katl tǝ nde itǝri kari. ");
INSERT INTO plj_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Nan mǝ kop den bishidi gon kan ba la bi lasi'e Kaudawo, mǝ mani zami ɗǝli nye heli kungǝlǝn jikat mali kan ɓal den kaar kǝ bar kungǝlǝn jikat mali bǝse ar cenka gwa, ama na banyi. ");
INSERT INTO plj_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Nan wu tli tikawo arni wu ne to den bar kungǝlǝn jikat mali ka. Bǝse dǝ kungǝlǝn jikat mali likawo arni wu ngen zap ra kan wu ɓalka. Wu kum bǝrti kǝ dǝ itǝri byal wur den sǝnges kǝ Sirtis kosak na atl kǝ Libǝya, arni wu dǝl gǝlla kan ba la gip mal ar kem kungǝlǝn jikat mali kǝ tetǝn ɗem-ɗem den gam mal gwa, kan wu za kungǝlǝn jikat mali itǝr den dǝli gǝsi. ");
INSERT INTO plj_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Bar tlowo, nan bar itǝri ci cina ar ba dǝm'e ar den pi ta bali kungǝlǝn jikat mali ɗe na bartawo, arni wu nǝm byali gosgam kan gipi gwa gip male. ");
INSERT INTO plj_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Den pǝt kǝ myakano, arni mir mǝn mbap den kungǝlǝn jikat mali yem jen gip bar kǝ mbap kǝ kungǝlǝn jikat mali wu wika. ");
INSERT INTO plj_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Mǝ mani shini pǝt na ga zǝnges da'a kǝ muri na womti, kan itǝr den ta zhe'e pitǝno, arni kup mǝ ɗǝli mbatlka den zami ɗǝltǝne. ");
INSERT INTO plj_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Gip muri ju kupo murgon ra kan la argon bi gwa da'a. Bulus dlǝr cina da wur tǝ wul wur'e, <<Mir moni, dǝ wule kǝ kumǝn far den ba mǝ zani Kǝrita dawo, litǝn kǝ bar na holi bar ju ba ri kǝ zami gǝmi da'a. ");
INSERT INTO plj_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Ama kǝkǝno a lir kǝn den kǝ ɓa ni mbatl dlom gami. Murgon ra gip mi kan baa hol rai gǝs gwa da'a. Kungǝlǝn jikat mali ni katl mi holi. ");
INSERT INTO plj_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Ghur kǝ gaso mǝn kartǝn kǝ Yam gon ɗǝl karǝmi, muntu ami gwas ni, tin es a bote ti. ");
INSERT INTO plj_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Tǝ wulǝm'e, <Bulus, ba dǝ kǝ kum bǝrti da'a, domici ki dlǝr cina dǝ Bar Gun kǝ Roma. Yam gip pi'i mbuni bar gǝs bi'i kup munju kan gip kungǝlǝn jikat mal kǝn kan nan ki gwawi.> ");
INSERT INTO plj_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Ra untuwo, dlǝri ni mbatl gini, domici a ngǝshǝm den Yam'e untuni ar ba pi kandatu tǝ yarim gwa. ");
INSERT INTO plj_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Ama itǝr baa byal mi den bar atl kǝ te dlom mal gonka.>> ");
INSERT INTO plj_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Gip dlom gas kǝ muri kutl-cet wupse kǝ zhe'e pitǝn kǝ itǝr kan den ta dǝli gǝmi gip bar ɓula Baharo, mir mǝn dǝli gǝmi gip kungǝlǝn jikat mali kum den mǝ mbi kosak na atlwi. ");
INSERT INTO plj_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Arni wu gode dlyamtǝn kǝ mali kan wu zam an ri desi asǝm hauya mukka. Cina njemo wu pa gode kan wu zam dlyamtǝn kǝ mali ri desi asǝm hauya wupse na kutl. ");
INSERT INTO plj_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Wu kum bǝrti kǝ dǝ itǝr kar kungǝlǝn jikat mali ar byal mi den tat bi ɓula'i. Ra untuwo arni wu shu giɓǝr bar jen wupse tǝp kaar kungǝlǝn jikat mali kan ba dǝl ti kaar gwa kǝ dǝ ar ci cina na kǝtǝr den gam male. Kan wu ndu nar den dǝ bar tlo bǝle. ");
INSERT INTO plj_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Gip ndu'i wu za kungǝlǝn jikat mali wu kǝtǝr gǝzǝno, arni jen gip mǝn dǝliyi si nye heli kungǝlǝn jikat mali gǝs male. Den ba dǝ mbarǝm mom unun wu ndu pi dawo arni wu pi wule wuri ni kǝ la'i bar gǝlla kan ba kem kungǝlǝn jikat mali kǝ dlǝri gwa cina dǝ kungǝlǝn jikat mali. ");
INSERT INTO plj_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Arni Bulus wul komanda kǝ mǝn bi-utu na mǝn bi-utuyi'e, <<Ga mǝn dǝli kungǝlǝn jikat mali ni dǝm gipi dawo, ki mani zami ɗǝltǝn na rai da'a.>> ");
INSERT INTO plj_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Arni mǝn bi-utuyi tlo zap ju kan ɓal den nye heli kungǝlǝn jikat mali kan wu za ti ar kop male. ");
INSERT INTO plj_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Kapǝn dǝ bartlowo, Bulus lir kup gǝzǝn den wu ci fingali, tǝ wule, <<Kǝn den ta damtǝn gip muri kutl-cet wupse ju kǝ ci argon da'a. ");
INSERT INTO plj_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","A lir kǝn den kǝ cini fingali. Ki ndu untu, kǝ sa nǝra. Ko nǝm ta gam kǝ gon baa jilka da'a.>> ");
INSERT INTO plj_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Nan tǝ pa'i yari muntuwo, arni tǝ pǝn bǝredi, kan ti goode Yam cina da wuri, tǝ cen kan tǝ nǝm ci. ");
INSERT INTO plj_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Kano kup gǝzǝn ba zam ɓa'i bigule, kan wu ci fingali. ");
INSERT INTO plj_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Mbarǝm zangu rop na hauya kutl cet myakan na kutl cet mukka (276) ni'e womtitǝn gǝmi kan gip kungǝlǝn jikat mali gwa. ");
INSERT INTO plj_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Nan kup ci fingal ar kǝm wuro, kan ba ca giɓǝrtǝn kǝ gip kungǝlǝn jikat mali na wi gosgam kǝ alkama kan gipi gwa su malka. ");
INSERT INTO plj_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Nan bar tlowo, wu mani momi atli da'a, ama wu shin nye tlorkoko gon na bishidi mǝn singesi, arni wu pǝn wule wi mani kǝtǝr na kungǝlǝn jikat mali den atl wu mbubar den singes bi-ɓula'i. ");
INSERT INTO plj_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Arni wu tlo zap ɓali bar gǝlla ju kan ba dǝl kungǝlǝn jikat mali kaar gwa, wu za wur su malka. Kan wu pa pǝtl las tu ba ɓal bar tu kan ba bali kungǝlǝn jikat mali gwa, kan wu tli bibako kǝ kungǝlǝn jikat mali kǝ cina dede den tǝp itǝri kan wu ne gam den bishidi. ");
INSERT INTO plj_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Ama nan kungǝlǝn jikat mali den tetǝno, arni an ɓo tu bar atl kǝ ba motǝn kǝ ɓula rop kan ba dlǝr gǝsi. Gam kungǝlǝn jikat mali ba te njuka den bishidi, ba'i jiti ti da'a. Ndǝrtǝn kǝ zap mal bar ɓula'i kem tǝp kaar kungǝlǝn jikat mali ba nǝm roɓǝstǝnka. ");
INSERT INTO plj_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Mǝn bi-utuyi gudlumi kǝ ri mir mǝn bom kǝ moniyi kup eka, den ba dǝ wu mani jeti mal kan wi ni wu mbubar bishidiwo wu kǝtǝr gǝzǝn da'a. ");
INSERT INTO plj_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Ama komanda kǝ mǝn bi-utuyi ba ndu tǝ za Bulus na rai. Arni tǝ za wur wu pi argon tu kan wu gudlumi gwa da'a. Arni ma tǝ bi bi den'e kup munju mani jeti malo, wu nda gip mal wu te den bishidi. ");
INSERT INTO plj_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Nami ba kop kaari na nǝmi katako ko ceni bar jen kǝ dli kungǝlǝn jikat mali. Na untuni kup gǝmi mbubar bishidi argon zam mi da'a. ");
INSERT INTO plj_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Nan mǝ zam mǝ mbubar den bishidi argon zam mi dawo, kan mǝ zam na momi den ba la ni bi atl kǝ te dlom bar ɓula'i ka'e Malta. ");
INSERT INTO plj_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Mǝn atli nǝm mi na am rop-rop. Nan wokociyi ghon den ndetǝne kan las ra na iɗatǝno, arni wu pi mi ɗem nan kǝn na hori mi utu. ");
INSERT INTO plj_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Bulus dom gam nyash ɗiri. Nan tǝ den wi gam nyashi te gip utu kawo, arni utu ghughup karndi gon kan tǝ ɗǝl ter tǝ ngas Bulus den ame. ");
INSERT INTO plj_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Nan mbarǝm kǝ bǝni shin ici'i den am kǝ Buluso, arni wu wul ezǝn'e, <<Mbarǝm tu ba ni mǝn ri mbarǝm eka ni, domici kup na zhe'e pitǝn kǝ bar ɓula ri ti eka da'a, Fate, yam mǝn tloyi mbarǝm shirǝm kor den argon tu wu pi gwa, baa za ti na rai da'a.>> ");
INSERT INTO plj_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Ama Bulus byal ici'i te gip utuka, ko njem argon zam ti da'a. ");
INSERT INTO plj_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Mbarǝm kǝ bǝni den ne ger wu shin ko ti nda atl mǝshi ama nan wu shin ar dǝm narwi ama argon zam ti dawo, arni wu sanje mbatl gǝzǝnka kan wu wule, tǝ nye yam gon ni. ");
INSERT INTO plj_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Kosak na lasiwo atl kǝ bari kǝ atl kǝ te dlom malika gon ni mǝn sun Pobǝliyas. Tǝ pi mi ɗem na ɗirtǝn rǝn bom da tika, kan tǝ pi mi ho bar kǝ muri myakan. ");
INSERT INTO plj_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Basi Pobǝliyas ra ɓom atl den kumi dli zazzaɓi na kǝtǝr lǝpe. Bulus te kǝ shini gǝsi, kan tǝ shirǝm na Yam tǝ ne am den ti, kan tǝ pǝni ti kumi dliyika. ");
INSERT INTO plj_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Nan muntu piwo, arni nami mǝn kumi dli kǝ atli kan te dlom malika ɗir kan ba pǝni wur kumi dli gǝzǝn ka. ");
INSERT INTO plj_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Wu bi mi nartǝn den tǝp na womti. Nan mǝ ri kǝ totǝn gip kungǝlǝn jikat mal mǝ ndarawo, arni wu bi mi bar ju kup kan mǝ ndu gwa. ");
INSERT INTO plj_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Den kaar kǝ kyar myakan na litǝn kǝ kungǝlǝn jikat maliwo, arni mǝ jikat mali gip kungǝlǝn jikat mali gon kǝ atl kǝ Alekzandǝriya kan ci watlǝn lasi gwa. Ba la ni bi kungǝlǝn jikat mali'e, Mir Ngumci yam Kasto na Poluks. ");
INSERT INTO plj_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Mǝ mbubar bǝn kǝ Sirakusa kan mǝ dǝm lasi kǝ muri myakan. ");
INSERT INTO plj_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Mǝ za barta kan mǝ ci cina na ɓomi asǝm den gam mal mǝ mbubar gip bǝn kǝ Rigiyom. Bar tlowo, arni itǝr ɓe tor tǝp kudu, kan mǝ mbubar Putiyoli den pǝt kǝ rop. ");
INSERT INTO plj_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Lasi ni mǝ zam mir ɓyar jen kan lir mi den mǝ dǝm nan wur kǝ muri nyingi gwa. Na untu ni mǝ mbubar Roma. ");
INSERT INTO plj_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Nan mir ɓyar kǝ gip Roma kum den mǝn den tǝpo, arni wu ɓom asǝm har wu mbubar Bar Pǝt kǝ Abiyus, jen eso wu mbubar las tu kan ba la ti bi'e Ba Ci Fingal Myakan gwa gip mbori gǝmi. Nan Bulus shin wuro ar ɓa'i ti bigule kan tǝ goode Yami. ");
INSERT INTO plj_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Nan mǝ te gip Romawo, kan ba za Bulus tǝ dǝm gip kushi kǝ gam gǝsi, na mǝn bi-utu gon mǝn ne ger den ti. ");
INSERT INTO plj_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Nan mǝ mbubar na muri myakano, arni Bulus la bi domtǝn kǝ kiri kǝ mǝn Yahuda. Nan wu dom wuro, tǝ wul wur'e, <<Mir ɓyari, a pi mbarǝm gǝmi wani bar gon da'a ko argon mǝgǝni na bar ju mǝ zam kar ga kori gǝmi gwa. Ama wu nǝmǝn gip Urushalima kan ba la'ǝm am dǝ mǝn Roma. ");
INSERT INTO plj_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Den kaar kǝ ngeni momi karǝm den unun a piwo, mǝn Romayi ndu wu za'ǝm a ndara, domici wu zam den a pi argon kan ndari dǝ rim eka da'a. ");
INSERT INTO plj_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Ama nan mǝn Yahudayi ngewo, muntuni kem a pǝn shirǝm gǝnka a ri cina dǝ Bar Gun kǝ Roma. Ba'e den ami na shirǝm kan aa ri mbarǝm gǝn cina dene gwa ni da'a. ");
INSERT INTO plj_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Muntu ni kem a liri kǝ dǝ a shin kǝn kan a pa shirǝm nan kǝne. Amin kǝn ɓali na sarsari domici a momwi den'e muntu kan mbarǝm kǝ Isra'ila ba la mbatl den ti mbirawi.>> ");
INSERT INTO plj_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Kan wu nǝmi ti'e, <<Mǝ zam rǝshi tǝlankur gon tor Yahuda den ki da'a. Gon ra es gip mir ɓyar kan tor na pel shirǝm kǝ wani bar gon ko yari argon den ki da'a. ");
INSERT INTO plj_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Mǝ mom den'e ko-ako mbarǝm den shirǝm nge me gam gin tu, ama mi ndu mǝ kum argon tu kǝ shin den tǝp gin tu gwa.>> ");
INSERT INTO plj_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Arni wu ne pǝt gon kǝ metǝn na Bulus, kan mbarǝm na womti ba dom wur las tu Bulus ba dǝm gwa. Tun kǝ cigǝni ar ba ri gasi tǝ ceti wur gamka na yari wur den dǝmi kǝ Yam gun gip mbatl kǝ mbarǝme. Ndu'i gǝs ni'e tǝ dǝl mbatl gǝzǝn den Yesu na yari wur gip Kulci kǝ Musa na rǝshi tǝlankur kǝ ga mǝn yari shirǝm kǝ Yami. ");
INSERT INTO plj_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Jen gip wur nǝm argon tu tǝ yari gwa, ama jeno wu nge nǝmika. ");
INSERT INTO plj_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Wu nge gǝzǝn kan wu nǝm ndaratǝn nan Bulus pa'i yari shirǝm kǝn gwa, <<Ruhu kǝ Yam yari dlat nan tǝ wul ga kori gin tǝp bi dǝ mǝn yari shirǝm kǝ Yam Ishaya gwa'e, ");
INSERT INTO plj_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","<Rǝ kar mbarǝm ju kǝ yari wur'e, Ki pi ta kumi ama ki mom da'a. Ki pi ta zhuwi ama ki mani gane dak. ");
INSERT INTO plj_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Domici mbatl kǝ mbarǝm ju ba'i pǝn bar da'a, Wi mani kumi bar na kǝm gǝzǝn da'a, Wu mbǝsh ger gǝzǝn kawi. Untuni dawo, wi mani shini bar na ger gǝzǝni, Wu kum bar na kǝm gǝzǝni, dǝ mbatl gǝzǝn mani momi bari, Kan wu pal karǝm, kǝ dǝ a pǝni wur kumi dli gǝzǝnka.> ");
INSERT INTO plj_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","<<Ra untuwo, a ndu kǝ mom'e, shirǝm kǝ Yam kǝ zami ɗǝltǝn gip warwat pitǝn tuwo an ri kar munju kan mǝn Yahuda ni da gwawi, eso wi kumi!>> ");
INSERT INTO plj_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","(Nan tǝ yar muntuwo, arni mǝn Yahudayi tlyam wu pi ta nge shirǝm kǝ ezǝni.) ");
INSERT INTO plj_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Bulus dǝm kǝ sheti ghon rop gip bom tu kan tǝ ɓatl kǝ nye dǝmi gǝsi gwa. Tǝ pi ta nǝmi kup munju ɗir kǝ shini gǝs gwa. ");
INSERT INTO plj_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Tǝ shirǝm na mbarǝm den dǝmi kǝ Yam Gun gip mbatl kǝ mbarǝme. Tǝ kulci wur den Babom Yesu Almasihu. Tǝ shirǝm bat na bǝrti kan ko nǝm murgon ngen tǝ wul ti'e tǝ za da'a.");
INSERT INTO plj_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Tǝlankur kǝn ɗǝl ni am dǝ Bulus kan Yam gip ndu'i gǝs la ti bi tǝ dǝm nye mǝn kartǝn kǝ Babom Yesu na erǝm gǝmi Sastanisu, ");
INSERT INTO plj_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","dǝ rii domtǝn kǝ mǝn kopi Yam nan gip Koranti, munju kan Yam ne wur markǝm gip Almasihu Yesu nan la wur bi kǝ dǝmi dlǝran, na kup munju kan ko ako den shirǝm na Yam gip sun kǝ Babom gǝmi Yesu Almasihu, Babom gǝzǝn na gwagǝmi kup gwa. ");
INSERT INTO plj_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Naa dǝ zo mbatl na dǝmi zhǝlili kǝ Ba gǝmi Yam na kǝ Babom Yesu Almasihu dǝm nan kǝne. ");
INSERT INTO plj_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","A kur goode Yam gǝn ko gigasi den kǝne, den zo mbatl kǝ Yam tu kan bi in gip Almasihu Yesu gwa. ");
INSERT INTO plj_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","Gip ko unuwo, Yam bi in bar nar na womti tǝp ko ako gip shirǝm na momi bar kup wi. ");
INSERT INTO plj_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","Bar ju kǝn ra nari gode'e shirǝm tu mǝ yari in den Yesuwo untun ar ra. ");
INSERT INTO plj_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","Den untuwo, kǝ hol zo bi bar kǝ Yam gon da'a, nan kǝn den wi ger gip ɓuti surtǝn kǝ Babom Yesu gwa. ");
INSERT INTO plj_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","Ti ni tii ɓa'i in bigul ar ri patǝn kǝ bari, kǝ dǝ kǝ dǝm munju baa nǝm kǝn den mǝgǝn pitǝn gin da'a den pǝt kǝ babom gǝmi Yesu Almasihu gwa. ");
INSERT INTO plj_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Yam mǝn dlǝri den shirǝm gǝs ni, ti ni'es tǝ lakǝn bi kǝ dǝ kǝ mo ni gam na nya gǝsi, Babom gǝmi Yesu Almasihu. ");
INSERT INTO plj_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","A lir kǝn mir ɓyar gip sun kǝ Babom gǝmi Yesu Almasihu kǝ dǝ bi gin dǝm nǝm, ba dǝ tatli gam gon te gip dlom gin da'a se de kǝ ngash ni gami, kǝn na mbatl nǝm, damtǝn gin nǝm. ");
INSERT INTO plj_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Mir ɓyari, jen gip bom kǝ Kuluwi yarim den'e tli yar yam ra gip dlom gini. ");
INSERT INTO plj_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Argon tu a yariwo ar ni'e, gon gip kǝn ba wule, <<Ami kǝ Bulus ni, gono ami kǝ Apolos ni, gono ami kǝ Kepas ni, gon eso ami kǝ Almasihu ni.>> ");
INSERT INTO plj_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Almasihu tatl nǝka bomi-bomi ya? Ɓani Bulus den kin den ami gina? Pi in ni batisma gip sun kǝ Bulusa? ");
INSERT INTO plj_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","A pi ghol mbatl na Yam kan a pii ko nǝm gip kǝn batisma da'a se Kǝrispus na Gayus gwa. ");
INSERT INTO plj_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","Ra untuwo, murgon ra kan ba wule pi ti Batisma na sun gǝn gwa da'a. ");
INSERT INTO plj_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","(An, a pi batisma mǝn bom kǝ Istipanus, den kaar kǝ untuwo a'i ne kǝm ko a pi murgon es batisma da'a.) ");
INSERT INTO plj_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Ba'e Almasihu karǝm ni kǝ dǝ a pi batisma da'a, ama kǝ dǝ a pi wazu kǝ zo shirǝm kǝ Yesu, ba'e na mani bi kǝ mbarǝm ni da'a bǝse dǝ mǝshtǝn kǝ Almasihu den kin hol ndǝrtǝn gǝsi. ");
INSERT INTO plj_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Shirǝm kǝ ɓatǝn den kino kǝdlǝm shirǝm ni kar munju den kopi tǝp mǝshtǝn gwa, ama kar mi kan den ɗǝli gǝmi bi dǝ mǝshtǝno, ndǝrtǝn kǝ Yam ni. ");
INSERT INTO plj_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","Nan ar ra na rǝshi gwa'e, <<Aa pali bobya kǝ mǝn bobya argon ni da'a. Eso, aa sar ceti gam kǝ mǝn ceti gam ka.>> ");
INSERT INTO plj_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","To akon mǝn bobya ra? Akon es mǝn momi bar ra? Akon mǝn kulci mbarǝm kulci kǝ Musa ra? Akon munju ba kum wule wu mom bar kup gwa ra? Ase Yam pali bobya kǝ atl kǝn den kǝdlǝm pitǝn ni da'aya? ");
INSERT INTO plj_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Nan gip bobya kǝ Yam mbarǝm den kaar atl mani momi Yam tǝp kar bobya gǝzǝn dawo, ar gholi mbatl Yam den tǝ ɗǝli munju ngǝsh wur den Yam tǝp kǝ ba wazu kan pǝn'e kǝdlǝm shirǝm ni gwa. ");
INSERT INTO plj_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Mǝn Yahuda ni den ngeni shini bar kǝ nǝmi bi na ame, munju kan mǝn Yahuda ni da ngapo wini den ngeni bobya. ");
INSERT INTO plj_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","Miwo mǝ pi ni wazu kǝ Almasihu kan ɓa ti den kin gwa, bar kǝ pati asǝm dǝ mǝn Yahuda kan kǝdlǝm shirǝm kar munju kan mǝn Yahuda ni da gwa. ");
INSERT INTO plj_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","Ama dǝ munju Yam la wur bi, mǝn Yahuda na munju mǝn Yahuda ni da'a, Almasihuwo ndǝrtǝn na bobya kǝ Yam ni. ");
INSERT INTO plj_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Domici argon tu kan Yam pi kan mbarǝm ba shin wule kǝdlǝm pitǝnno, ar nar man bobya kǝ mbarǝme, eso argon tu Yam pi kan ba shin wule holi ndǝrtǝnno ar man ndǝrtǝn kǝ bigul kǝ mbarǝme. ");
INSERT INTO plj_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Mir ɓyari, dam kǝn ni den kandatu kǝn ra nan lakǝn bi gwa. Kup gin ni na bobya gip dli nan lakǝn bi gwa da'a. Kup gin ni'e kiri mbarǝm da'a, kan kup gin ni'e mimir kǝ kiri mbarǝm da'a. ");
INSERT INTO plj_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","Ama Yam zǝzar ni bar ju kan kǝdlǝmi ni den ger kǝ mbarǝm gwa kǝ dǝ tǝ bi mǝn bobya shame. Yam zǝzar ni bar ju kan ndǝr da'a den ger kǝ mbarǝm kǝ dǝ tǝ bi ndǝri mbarǝm shame. ");
INSERT INTO plj_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","Yam zǝzar ni bar ju ba ɓite argon da'a na bar ju ba mbur ka na bar ju kan argon ni da'a kǝ dǝ tǝ sar bar ju kan mbarǝm ba shin'e hoyi ni gwa. ");
INSERT INTO plj_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","Tǝ pi ni untu bǝse dǝ murgon ɓo ngetl cina dǝ Yami. ");
INSERT INTO plj_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","Yam ni pi kǝ dǝm gwas gip Almasihu Yesu. Ti ni tǝ kem Almasihu dǝmi mi bobya, pitǝn dlat, ne markǝm den bi kǝ Yam na zami ɗǝltǝn gǝmi. ");
INSERT INTO plj_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","Ra untuwo, ar dǝm wi kandatu kan rǝsh gwa'e, <<Muntu baa ɓo ngetlo, tǝ ɓo ngetl gip Babomi.>> ");
INSERT INTO plj_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Mir ɓyari, nan a ɗir kar kǝn kǝ dǝ a yari in bar ju kan na ghuuni kan Yam godemo, ba'e a yari in ni shirǝmi na mani bi ko na bobya gǝn da'a. ");
INSERT INTO plj_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","Nan ami ra nan kǝno a ɓalni tor gip mbatl gǝn'e a mom argon gip kǝn da'a, se de Yesu Almasihu, ti tu kan ɓaa den kin gwa. ");
INSERT INTO plj_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","A ɗir ni kar kǝn gip holi ndǝrtǝn, na bǝrti na dǝdartǝn na nari. ");
INSERT INTO plj_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","Shirǝm gǝn ngap na wazu gǝno ba'e na bobya kǝ dǝli mbatl kǝ mbarǝm na mani shirǝm ni da'a, ama a dǝl ni mbatl kǝ mbarǝm tǝp kar ndǝrtǝn kǝ Ruhu. ");
INSERT INTO plj_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","Ba kǝ ngǝsh kǝn ni den bobya kǝ mbarǝm da'a ama gip ndǝrtǝn kǝ Yami. ");
INSERT INTO plj_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","Kup na untu, mǝ shirǝm na bobya dǝ munju kan kǝm mbarǝm wugwa, ama ba'e bobya kǝ zhan kǝn ni da'a, ko dǝ mǝn cina kǝ atl munju baa palka argon ni da gwa. ");
INSERT INTO plj_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","Ama mǝn ni den shirǝm den bobya kǝ Yam kan ra na ghuuni gwa. Bobya kǝ Yam tuwo tǝ neni terka den bi ɗǝɗatǝn gǝmi. ");
INSERT INTO plj_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","Ko nǝm gip mǝn cina kǝ atl kundǝrǝndlip mom da'a, o wu mom ni fawo, na wu ɓa Babom mǝn nartǝn den kin da'a. ");
INSERT INTO plj_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","Ama ar ra na rǝshi'e, <<Bar tu ger shin da'a, kǝm kum da'a, ar si mbarǝm mbatl da'a, Argon tu kan Yam ne munju ba ndu ti baa zam gwa.>> ");
INSERT INTO plj_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","Yam ɓuli miwi tǝp kar Ruhu. Ruhu kǝ Yam ba ngen tǝ ɓul bar kup, kup na dlyami bar kǝ Yami. ");
INSERT INTO plj_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","Gip mbarǝmo, woni mom damtǝn kǝ mbarǝme, se ruhu kǝ mbarǝmi nan ra gip ti gwani da'aya? Untuni es damtǝn kǝ Yamo murgon baa mani momi da'a se de Ruhu kǝ Yami. ");
INSERT INTO plj_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","Miwo ruhu kǝ den kaar atl ni mǝ nǝm da'a, ama Ruhu tu kan ɗǝl kar Yam gwa ni, kǝ dǝ mǝ mani momi bar ju kan Yam bi mi lǝngǝt gwa. ");
INSERT INTO plj_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","Bar ju ni ca mǝ shirǝm dene ba'e na bobya tu kan mbarǝm ba kulci gwa ni da'a, ama tǝp kar bobya muntu kan Ruhu ba kulci gwa. Tǝp untu ni mǝ yari bar ju kan kǝ Ruhu ni tetla-tetla dǝ munju kan kǝ Ruhu ni gwa. ");
INSERT INTO plj_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Muntu kan na Ruhuyi dawo tǝ nǝm bar ju kǝ Ruhu kǝ Yam ni gwa da'a den kǝdlǝm bar ni kar ti. Tii mani momi gǝzǝn dak nan tǝp kar Ruhu ni ba mani momi gwa. ");
INSERT INTO plj_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","Muntu kan mǝn Ruhuno tǝ tlo shirǝm den bar kup, ti na gam gǝs ngapo murgon baa tloyi ti shirǝm da'a. ");
INSERT INTO plj_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","<<O fawo woni mom damtǝn kǝ Babom nan ti kulci ti gwawe?>> Ama damtǝn gǝmiwo kǝ Almasihu ni. ");
INSERT INTO plj_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","Mir ɓyari, a mani in pi shirǝm wule munju Ruhu ba kop nan wur gwa da'a, se de wule kǝ dli, pel gǝri gip Almasihu. ");
INSERT INTO plj_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","Mal nyin ni a bi in den bi fingal gini, ba'e fingal mǝn latitǝn da'a, den kǝ ndǝr wi da'a. Aan, kǝkǝn ma kǝ ndǝr kǝ ciwi da'a. ");
INSERT INTO plj_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","Pitǝn kǝ mbarǝm kǝ dli'i gip kǝne, ghuve na tli yar yam ra gip dlom gini. Ra untuwo, kǝn ni wule mbarǝm kǝ atli, kǝn ni den pitǝn wule mbarǝm kǝ dli diya? ");
INSERT INTO plj_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","O fa, nan gon den wultǝn'e, <<Ami kǝ Bulus ni,>> gon es, <<Ami kǝ Apolos ni,>> kǝn ni den pitǝn wule mbarǝm ni katl da'aya? ");
INSERT INTO plj_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","Woni fa'e Apolos? Woni es'e Bulus? Mǝn mbap ni katl munju kan kǝ ngǝsh kǝn den Yam tǝp kar wur kandatu Babom bi ko gonge mbarǝm mbap gǝs gwa. ");
INSERT INTO plj_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","Ami ni a dlǝri, Apolos ni bi male, ama Yam ni kem kan ar ba nari. ");
INSERT INTO plj_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","Ra untuwo, muntu kan dlǝriyi na muntu bi maliwo den bi argon ni wura da'a, ama Yam muntu kan kem ar nar gwa. ");
INSERT INTO plj_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","Muntu dlǝri na muntu bi malo nǝm ni wura, kano ko gonge gǝzǝn baa zam ɓatltǝn den bi mbap gǝsi. ");
INSERT INTO plj_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","Domici mǝn berǝm ni gip mbap kǝ Yami, kǝn ngapo kǝn ni kǝ Yami, tu'i bin kǝ Yami. ");
INSERT INTO plj_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","Den bi zo mbatl kǝ Yam nan bi miwo, wule mǝn mani tu'i bine, a la gǝsi, gon ngap den tu'i dene. Ama dǝ ko gonge mbarǝm ngup ti na iri bin tu tǝ tu dene gwa. ");
INSERT INTO plj_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","Den murgon ra es kan baa ɓa gǝs bin gon bom na muntu kan ɓa wi gwa da'a, Yesu Almasihu ituwi. ");
INSERT INTO plj_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","Ama murgon ni tu bin den gǝs bin tu na zinariya ko na ghol gǝlla ko na zo tate ko nyashi, ko jiri ko mommowo, ");
INSERT INTO plj_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","mbap kǝ ko gonge mbarǝm baa ɓuli. Gasiwo baa ɗǝli kari, nan gip utun ba gode ti gwa, utu ngap na gam gǝs baa gode mbap tu ko gonge mbarǝm pi gwa. ");
INSERT INTO plj_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","Argon tu mbarǝm tu'iyi ni dlǝro, ti nǝm ɓatltǝn gǝsi. ");
INSERT INTO plj_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","Ar ni ngap ker kawo, mǝn tu'iyi ba zam ndetǝne, kup na ti na gam gǝso, ti zam ɗǝltǝne ama wule muntu kan ɗǝl gip bǝlǝm utu gwa. ");
INSERT INTO plj_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","Kǝ mom ni'e kǝn bom kǝ Yam ni, kan Ruhu kǝ Yam ba dǝm gip kǝn da'aya? ");
INSERT INTO plj_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","Muntu kup li bom kǝ Yam kawo, Yam baa li tǝka. Bom kǝ Yamo dlǝran ni ar ra, kǝn ni ngap'e bom kǝ Yam tu. ");
INSERT INTO plj_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","Ba kǝ seni gam gin da'a. Gon gip kǝn ni ba shin wule ti mǝn bobya ni gip zhan kǝno, naa tǝ pali gam gǝs kǝdlǝmi, kǝ dǝ tǝ dǝm mǝn bobya ra. ");
INSERT INTO plj_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","Bobya tu kan kǝ den kaar bar atl ni katlo, kǝdlǝm pitǝn ni kar Yami. Ar ra na rǝshi'e, <<Tii nǝm mǝn bobya kǝ atl kǝn tǝp kǝ ba bobya gǝzǝni.>> ");
INSERT INTO plj_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","Eso, <<Babom Yam mom'e damtǝn kǝ mǝn bobya kǝ pi mǝgǝn baro argon ni da'a.>> ");
INSERT INTO plj_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","Ra untuwo, ba dǝ murgon ɓo ngetl na mbarǝm da'a. Bar kupo gegin ni. ");
INSERT INTO plj_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","Ko Bulus ni ko Apolos, ko Kepas ko atl kundǝrǝndlip, ko zami dǝmi den kaar atli ko mǝshtǝni, ko bar kǝ kǝkǝni, ko bar ju baa pi cina ɗe, bar kupo gegin ni. ");
INSERT INTO plj_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","Kǝn ngapo kǝ Almasihu ni, Almasihu ngapo kǝ Yam ni. ");
INSERT INTO plj_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","Untun ar ndari kǝ pǝn mi den mir mǝn pi mbap kǝ Almasihu ni, munju Yam bi wur ge shirǝm gǝs kan ra na ghuuni gwa. ");
INSERT INTO plj_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","Den untuwo, ba ndu'e munju ne wur gam baro wu dǝm mǝn pitǝn dlat. ");
INSERT INTO plj_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","Karǝmo, banyi bar ni da'a dǝ wule kǝn ni ki tloyim shirǝmi, untu dama, ko bom ba tloyi shirǝmi. Ami ma a tloyi gam gǝn shirǝm da'a. ");
INSERT INTO plj_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","Amo sor ni ami ra, ama untu ba gode ni'e a hol mǝgǝn pitǝn gon da'a. Babom ni ba tloyim shirǝmi. ");
INSERT INTO plj_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","Ra untuwo ba kǝ zho in ni kǝ tloyi shirǝm den argon kapǝn dǝ pǝti ɗir da'a. Ɓut ni cwattǝn kǝ Babomi. Gas ta ni ti ɓul bar ju kup kan ra na ghuuni gip dǝmǝn gwa. Ti ɗǝli bar ju kan gip mbatl kǝ mbarǝm gwa dǝ momi. Ar ni ko gonge mbarǝm ba zam dǝ Yam ɗǝɗa ti den mbap gǝsi. ");
INSERT INTO plj_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","Kǝkǝno, mir ɓyari, a cingǝr ni bar ju den gam gǝn na erim Apolos den bi zami gin kǝ dǝ kǝ kulci ni kar mi den argon tu shirǝm kǝn ba yari gwa'e, <<Ba kǝ dlyam ni ka na bar ju kan ra na rǝshi gip shirǝm kǝ Yam gwa da'a.>> Ra untuwo ba dǝ gon gip kǝn pi tlora den mǝn kulci gǝs man kǝ gon da'a. ");
INSERT INTO plj_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","Woni pali'i bom na jen we? Unun ki nari, muntu kan bi ni bi'i da gwawu? In bi i'no unun kem kǝ ɓo ngetl wule bini bi'i dagwa? ");
INSERT INTO plj_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","Kǝn ra na kup bar ju kǝ ndu gwawi! Kǝ dǝm mǝn bar kǝ am wi! Kǝn den dǝmi wule ga gun wi, mǝn ngapo den bi argon ni mǝn ra da'a! Dǝ ma wule kǝn ga gunyi ni mǝn ma se mǝ dǝm gun nan kene. ");
INSERT INTO plj_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","Gip shini gǝno Yam gode'e mǝn mir mǝn kartǝn gǝs ni'e kǝ kaar gip ko unu, wule mun ju tloyi wur shirǝm kǝ dǝ ri wur eka. Atl kundǝrǝndlip nemi ger wi na mir mǝn kartǝn kǝ Yam na mbarǝme. ");
INSERT INTO plj_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","Mǝn kǝdlǝm ni den bi kǝ Almasihu, ama kǝno mǝn bobya ni gip Almasihu, mǝ hol bigul wi ama kǝno mǝn ndǝrtǝn ni! Ɗǝɗa kǝnwi mǝn ngapo mbur mika! ");
INSERT INTO plj_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","Kǝkǝn untu ma mǝn den kumi guzǝm, na guzǝm male, mǝn ra gip lusguru, den ci cina na ɓe gǝmi mǝn ra na ba dǝmi da'a. ");
INSERT INTO plj_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","Mǝ pi mbap hoyi na am gǝmi. In pi mi biwo, mǝ la'i mbarǝm albarka. In kumi mi dliwo, mǝ ɓa mbatl dlom gǝmi. ");
INSERT INTO plj_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","In yari mi mǝgǝn shirǝmo mǝ nǝmi wur na iɗa mbatli. Kup na untu mǝ dǝm bar kǝ nge wi den kaar atli. Mǝ dǝm bǝci bar kǝ dǝɗan wi kar mbarǝme, kǝkǝn ma untun ar ra. ");
INSERT INTO plj_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","Ba'e a rǝshi in ni kǝ dǝ a la kǝn gip sham da'a, ama kǝ dǝ a dǝli in kǝme den kǝn mimir gǝn kǝ ndu'i ni. ");
INSERT INTO plj_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","Kǝn nǝra na mǝn kulci na womti gip Almasihu, ama kǝn ra na bǝba na womti da'a, na ho bi gip Almasihu Yesu ni a dǝmi in bǝba tǝp kǝba ri in zo shirǝm kǝ Yesu. ");
INSERT INTO plj_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","Ra untuwo a lir kǝn dǝ kǝ kop ni pitǝn gǝni. ");
INSERT INTO plj_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","Ra untuwo, a kari in bar na Timoti nya gǝn muntu a ndu gwa, mǝn pitǝn dlat gip Babomi. Ti yari in ra den kanda kǝ dǝmi gǝn gip Almasihu Yesu muntu kan dǝm nǝm na argon tu a kulci ko ako kǝ ba domtǝn kǝ mǝn kopi gwa. ");
INSERT INTO plj_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","Jeno wu den hori icin, wu shin wule aa'i ɗir kar kǝn da'a. ");
INSERT INTO plj_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","Ama aa ɗir kar kǝn bǝle-bǝle, na ndu'i kǝ Babomi, kan a ngen momi ba'e katl kandatu mǝn hori icin ju ba shirǝm gwa da'a, ama ndǝrtǝn tu wura nari gwa. ");
INSERT INTO plj_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","Dǝmi kǝ Yam gun gip mbatl kǝ mbarǝmo den shirǝm kǝ bini katl da'a, ama kǝ ndǝrtǝn ni. ");
INSERT INTO plj_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","Na unun kǝ ndu a ɗir kar kǝnu? A ɗir na rǝɓa kǝ dǝli in kǝma ko a ɗir gip ruhu kǝ ndutǝn na iɗa mbatli? ");
INSERT INTO plj_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","A kum'e muri na mǝtli na moni kari narka gip dlom gini, munju ba zam da'a ko gip mbarǝm ju kan mom Yam da'a gwa. Dǝ wule mbarǝm ba mur na gǝr kǝ base. ");
INSERT INTO plj_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","Na untun kǝn den ɓe ngetle! Ki pi dun mbatli, kǝ ɗǝli ni mbarǝm mǝn pi untu gip domtǝn gin diya? ");
INSERT INTO plj_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","Kup na ami ra nan kǝn gip dli da'a ama ami ra nan kǝn gip ruhu. A tare a tlo shirǝm wi den badǝr mbarǝm tu gip sun kǝ Babom Yesu wule ami nǝra lasi. ");
INSERT INTO plj_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","Ra untuwo, kup wokoci tu kǝ dom kǝn kan ami ra nan kǝn gip ruhu, kan ndǝrtǝn kǝ Babom Yesu ra lasi, ");
INSERT INTO plj_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","ta'i ni Shetan mǝn warwat pitǝn tu dǝ ri dli gǝs e, kǝ dǝ ruhu gǝs zam ɗǝltǝn ra den pǝt kǝ Babom. ");
INSERT INTO plj_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","Ɓe ngetl gino ar hoyi da'a. Kǝ mom ni'e nye yisti njem ni ba kem dǝ bǝredi tli diya? ");
INSERT INTO plj_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","Ɗǝli ni kor yisti tu ka, kǝ dǝ kǝ dǝm pel bǝredi, kandatu kǝn ra bǝredi bat na yisti gwa itu. Almasihu wule nye bagala jikat bǝdlabǝn gǝmiwo tare mbosh wi. ");
INSERT INTO plj_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","Ra untuwo mǝ pini nyel gǝmi bat na kor bǝredi mǝn yisti, bǝredi kǝ ngarci na ɗastǝni, ama kǝ pi bar dlat na ge shirǝm. ");
INSERT INTO plj_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","A rǝshi in gip tǝlankur gǝn'e ba kǝ ngash ni gam na mǝn muri na mǝtli kari da'a. ");
INSERT INTO plj_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","Ba'e mǝn muri na mǝtli kǝ den kaar atl ni a yari da'a ko mǝn ndu'i bar kǝ mbarǝme, na mure, ko mǝn ware. In untuno ki za dǝmi den kaar bar atl ituwi. ");
INSERT INTO plj_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","Kǝkǝno a rǝshi in ni den ba kǝ meni gam na kup muntu ba la bi gam gǝs'e mǝn kopi ni, ama mǝn muri na mǝtli kari na mǝn ndu'i bar kǝ mbarǝme na mǝn ware, na mǝn usǝn shirǝmi ko mǝn tle ɗu'e ko mure. Ba kǝ cini fingal na badǝr mbarǝm ju da'a. ");
INSERT INTO plj_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","Unun mo'ǝm na munju kan kari kan a tloyi wur shirǝm gwawu? Munju gip mǝn kopi gwani ki tloyi wur shirǝm diya? ");
INSERT INTO plj_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","Yam ni baa tloyi shirǝm munju nan gwagǝmi ni da'a gwa. Ɗǝli ni mǝn ɗasi tu tuka gip kǝne. ");
INSERT INTO plj_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","Gon gin nǝra na shirǝm den esiwo kǝ kur ri cina dǝ mǝn bǝn kan mom Yam da'a dǝ tloyi in shirǝm ba'e cina dǝ ya'ǝn mǝn kopi da'aya? ");
INSERT INTO plj_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","O fawo kǝ mom ni'e mbarǝm kǝ Babom ni baa tloyi mbarǝm den kaar atl shirǝm diya? Tun kan kǝn ni ki tloyi mbarǝm shirǝm den kaar atlo, ki mani tloyi shirǝm den mir shirǝm ju kan gip dlom gin gwa diya? ");
INSERT INTO plj_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","Kǝ mom ni'e mi tloyi shirǝm mir mǝn kartǝn bar kǝ Yam diya? Bare mir bar ju kan kǝ den kaar atl kǝn gwa? ");
INSERT INTO plj_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","Kǝn ni na bar ju ki ri cinawo, unun kem kǝ ri kar mbarǝm ju kan argon ni dǝ mbarǝm kǝ Yam da'a we? ");
INSERT INTO plj_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","A yari ni untu ra kǝ dǝ a bi in shame. Kǝ shin wule gip kǝno mǝn bobya gon ra kan ba mani tle gam kǝ bar ju gwa diya? ");
INSERT INTO plj_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","Ama dǝ wule mǝn kopi bari erim gǝs cina dǝ mǝn bǝn kǝ tloyi shirǝm, cina dǝ munju kan mǝn kopi ni da'a! ");
INSERT INTO plj_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","Pi shirǝm den bar ju nan baa ri in cina dǝ mǝn bǝn ma ndetǝn ni kar kǝne. Unun kem kii mani te mbatl karka in pi in wani bar da'a we? Unun kem kii mani za'i dǝ zote in bar gin ka dawu? ");
INSERT INTO plj_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","Ar tu kǝn ma na gam gin kǝ pi mbarǝm wani bari. Kǝ pa nǝmi mbarǝmka bar ju kan gwazin ni gwa. Untu ni kǝ pi ya'ǝn pa'e. ");
INSERT INTO plj_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","Kǝ mom ni'e munju ba pi dlat dawo wii zam dǝ Yam dǝm gun gip mbatl gǝzǝn da'aya? Ba dǝ jili in nǝka da'a, mǝn muri na mǝtli ko moni kari gon ra, ko mǝn ware, ko muntu kan mur na muntu gudlumi wi, ko mǝn muri na moni ko mǝtli den tǝp tu kan ra kor dagwa, ");
INSERT INTO plj_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","ko mure, ko mǝn ndu'i bar kǝ mbarǝme, ko mǝn tle ɗu'e, ko mǝn bes shirǝmi, ko mǝn ngarci gon kan ba zam totǝn gip bom las tu Yam'e gun gwa da'a. ");
INSERT INTO plj_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","Jen gip kǝn faro unjun wura. Ama kǝkǝno ho kǝn kawi, Yam ne in markǝm kǝ dǝm gwas wi, kǝ'i na warwat pitǝn da'a cina dǝ Yam gip sun kǝ Babom Yesu Almasihu na tǝp kǝ ba Ruhu kǝ Yam gǝmi. ");
INSERT INTO plj_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","Kǝ wule, <<Aa mani pi bar kup,>> ama bar kup ni baa nem am ra gip dǝmi gǝn da'a. <<Aa mani pi bar kup,>> ama aa dǝm zher kǝ argon da'a. ");
INSERT INTO plj_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","Kǝ wule, <<Fingalo, pi ni den bi kǝ tu'e, tu'i ngapo den bi kǝ fingali, kan Yam baa li kup ropi ka.>> Dliwo pi ti ni kǝ pi muri na moni ko mǝtli kaari da'a ama pi ti ni kǝ Babomi, Babom ngapo kǝ dli. ");
INSERT INTO plj_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","Yam, tli Babom gip mǝshi mbarǝm tǝp kǝ ba ndǝrtǝn gǝsi, untuni tii tli mi pa'e. ");
INSERT INTO plj_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","Kǝ mom ni'e dli gino kǝtǝ dli kǝ Almasihu ni diya? Imni a pǝn kǝtǝ dli kǝ Almasihu kan a ngash na kǝ gǝr mǝn bi gǝs kari we? Ba pi da'a! ");
INSERT INTO plj_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","Kǝ mom ni'e muntu ngash dli gǝs na gǝr mǝn bi gǝs kariwo wu dǝm dli nǝm nan ti ituwi diya? Ar ra na rǝshi gip shirǝm kǝ Yam'e, <<Ropiwo wu wi dǝm dli nǝm ituwi.>> ");
INSERT INTO plj_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","Ama kup muntu nan me gam na Babomo, wu dǝm nǝm nan ti gip ruhu ituwi. ");
INSERT INTO plj_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","Kǝtǝri ni muri na mǝtli ko moni kari! Kup nami warwat pitǝn ju mbarǝm ba piwo kǝ den kar dli ni, ama kup muntu mur na mǝtli ko moni kariwo, warwat pitǝn ni tǝ pi dli gǝsi. ");
INSERT INTO plj_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","Kǝ mom ni'e dli gino ba dǝmi kǝ Ruhu kǝ Yam ni kan gip kǝn gwa, muntu nan kǝ zam kar Yam gwa diya? Dǝmi kǝ gam gin ni kǝn dene da'a. ");
INSERT INTO plj_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","Yam wur kǝn ni na zo bari. Ra untuwo ɗǝɗa ni Yam na dli gini. ");
INSERT INTO plj_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","Den bar ju kǝ rǝshimo, ar mbun'e dǝ mbarǝm dǝm tǝ ra na gudlumi da'a. ");
INSERT INTO plj_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","Ama kǝ dǝ kǝtǝri muri na mǝtli kari kan den ta piwo, dǝ ko gonge mbarǝm nǝra na gǝr kǝ gam gǝsi, kan ko gonge gǝrmǝtli tǝ nǝra na bakos gǝsi. ");
INSERT INTO plj_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","Dǝ kos pi bar ju kan nǝm ti den tǝ pii gǝr gǝs gwa. Untuni es gǝri ma tǝ pi bakos untu. ");
INSERT INTO plj_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","Gǝri ra na shirǝm kǝ yari den dli gǝs da'a ama tǝ bi bakos gǝsi. Untu ni es bakos ma tǝ ra na shirǝm kǝ yari den dli gǝs da'a ama tǝ bi gǝri. ");
INSERT INTO plj_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","Ba dǝ gon gin saari esi dli gǝska da'a, se de na bali gip dlom gǝzǝn kǝ mir muri njem kǝ dǝ kǝ zam kǝ kurni gǝs gip shirǝm na Yami. Den kar kǝ untuwo kan kǝ pali ni muri na ya'ǝni bǝse dǝ Shetan gode in den holi mani nǝmi gam gini. ");
INSERT INTO plj_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","A yari ni untu gip shini argon tu baa mbuuni in gwa, ba'e Yam ni wulǝm'e a yari in untu da'a. ");
INSERT INTO plj_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","Ndu'i gǝno dǝ wule kup gino wule ami ni kǝn ra. Ama ko gonge mbarǝm na bar tu Yam bi ti gwa. Gono bi ti mǝnkǝni, gon ngapo mǝnta. ");
INSERT INTO plj_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","Dǝ munju kan gudlumi wi da'a na guriwo, a wule, ar mbun wu dǝm untu kandatu ami ra na gudlumi da'a gwa. ");
INSERT INTO plj_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","Ama wini wi mani nǝmi gam gǝzǝn dawo, wu gudlumi, ar mani dǝ gudlumi na dǝ warwat ndutǝn ci mbatli. ");
INSERT INTO plj_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","Munju na gudlumi ngapo a yari in shirǝm tu, ba'e ami ni da'a, ama Babom ni, den'e ba dǝ gǝr za ba bakos gǝs ka da'a, ");
INSERT INTO plj_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","Tin tǝ za bakos gǝs ka ngapo, ti'i gudlumi na gon da'a, ar mani tǝ pal kar bakos gǝs. Kosi ngapo ba tǝ kar gǝr gǝs ka da'a. ");
INSERT INTO plj_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","Namiwo, ami ni a yari, ba'e Babom ni da'a. Gon gin nǝra na gǝr gǝs nan mǝn kopi ni da'a, ama gǝri ni pǝn ti dǝm nan tiwo, to, ba tǝ kar ti ka da'a. ");
INSERT INTO plj_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","Gǝr tu kan bakos gǝs mǝn kopi ni dawo, kosi ni pǝn ti dǝm nan ti ngapo, ba dǝ gǝri za tǝka da'a. ");
INSERT INTO plj_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","Kos tu kan mǝn kopi ni dawo dlǝran ni tǝra tǝp kar gǝr gǝs kan mǝn kopi ni gwa, kan gǝr tu kan mǝn kopi ni dawo, tǝ dǝm dlǝran wi tǝp kar kos gǝs kan mǝn kopi ni gwa. Untuni dawo, mimir gin ba hol dǝmi dlǝran, ama wini wu pi untuwo mimir gǝzǝno dlǝran ni wura. ");
INSERT INTO plj_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","Ama muntu kan mǝn kopi da'ayi ni ndara tǝ za mǝn kopiyiwo, ti mani ndaratǝni. Ar ni dǝm untuwo erǝm mǝtli ko moniyi'i ɓali na zap gudlumi da'a. Yam la mi ni bi kǝ dǝmi zhǝlili. ");
INSERT INTO plj_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","Ki gǝri mǝn kopiwo, kǝ moma ko kin ki ɗǝli bakos gi gwa? Ko ki kosi mǝn kopiwo, kǝ moma ko ki ni ki ɗǝli nagǝr gi gwa? ");
INSERT INTO plj_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","Ra untuwo, ar mbun dǝ ko gonge mǝn kopi tǝ pi dǝmi gǝs kandatu Yam ne ti nan la ti bi gwa. Muntu ni'e argon tu a yari den dǝ kop gwa gip kup ba domtǝn kǝ mǝn kopi Yesu. ");
INSERT INTO plj_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","Mbarǝm nǝra na sǝri wokoci tu Yam la ti bi gwaya? Ba dǝ tǝ ngen tǝ dǝm nduɓuli da'a. Mbarǝm nǝra nduɓuli wokoci tu Yam la ti bi gwaya? Ba tǝ ngen dǝ sǝr ti da'a. ");
INSERT INTO plj_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","Sǝrtǝn ko dǝmi nduɓuli ɓite argon da'a. Pi argon tu Yam wule dǝ pi gwani ni'e argon tu kan mani gwa. ");
INSERT INTO plj_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","Ra untuwo, na dǝ ko gonge mbarǝm dǝm las tu kan Yam ne tǝra nan la ti bi gwa. ");
INSERT INTO plj_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","Kǝn zher ni nan Yam lakǝn bi gwaya? Ba dǝ ar ghun kǝn ni da'a, ama in ki mani zami dǝmi kǝ gam giwo, da'i ngeni. ");
INSERT INTO plj_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","Zher tu kan Yam la ti bi kǝ ngǝshtǝn den Babomo, gip Babomo mǝn dǝmi kǝ zami gam gǝs ni. Untuni esi, muntu kan den dǝmi kǝ zami gam nan Yam la ti biwo, zher kǝ Almasihu ni. ");
INSERT INTO plj_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","Na wurpi na nari ni wur kǝne, ba kǝ dǝm ni zher kǝ mbarǝm da'a. ");
INSERT INTO plj_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","Mir ɓyari, na dǝ ko gonge mbarǝm kan kǝ Yam ni gwa, na tǝ dǝm kandatu kan Yam la kǝn bi gwa. ");
INSERT INTO plj_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","Den shirǝm kǝ munju kan na gudlumi dawo, Babom pim shirǝm den argon tu wi pi gwa da'a, ama a yar ni shini gǝn den ami mbarǝm ni kan ba kum shirǝm gǝn gwa den Yam wim mal atl wi gip zo mbatl gǝsi. ");
INSERT INTO plj_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","Den bar kǝ tli mbatl kǝ zhan kǝn kan den ɗirtǝno, a shin ar ndari dǝ mbarǝm dǝm untuyi. ");
INSERT INTO plj_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","Ki ni na gudlumi ya? Ba kǝ kar gǝrika da'a. Kǝ gudlumi wi da'aya? Ba kǝ ngen gudlumi na gǝr da'a. ");
INSERT INTO plj_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","Ama ki ni kǝ gudlumi wo kǝ pi warwat pitǝn da'a. Nye gǝr ni gudlumi ngapo, tǝ pi warwat pitǝn da'a. Ama munju kan gudlumiwo wi kum dli den bar na womti kan baa ghun wur gip dǝmi gǝzǝn den kaar atl kǝni. Muntu ni'e argon tu a shini in gwa den ba kum ni dli da'a. ");
INSERT INTO plj_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","Mir ɓyari, argon tu a ndu yariwo ar ni'e wokoci nar da'a. Cina ɗewo munju kan na mǝtliwo, wu dǝm wule wi ni na mǝtli da'a. ");
INSERT INTO plj_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","Munju den pi dun mbatlo wu dǝm wule wu pini dun mbatl da'a. Munju den ghol mbatl ba pal wule wu pini ghol mbatl da'a. Munju wur bar ngapo wule wi ni na argon gwazin da'a. ");
INSERT INTO plj_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","Munju kan den baltǝn na bar kǝ den kaar atlo, ba dǝ wu ne mbatl gǝzǝn dene da'a. Kandatu atl kundǝrǝndlip rawo ar ba paka. ");
INSERT INTO plj_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","A ndu'e ba dǝ argon ghun kǝn ni da'a. Muntu na gudlumi dawo, bar kǝ Babom ni'e ghuntǝn gǝsi, kandatu ti gholi mbatl Babom gwa. ");
INSERT INTO plj_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","Ama muntu kan gudlumiwo bar ju ba ghun tiwo kǝ atl ni, kandatu ti gholi gǝr gǝs mbatl gwa. ");
INSERT INTO plj_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","Damtǝn gǝs rapdlan ka ituwi, gǝr tu kan gudlumiwi da'a ko nye gǝro, wu dam wur ni den Babom hoyi kandatu wi dǝm dlǝran gip dli na ruhu gwa. Ama munju na moniwo bar kǝ atl ni ba ghun wuri, domici wu ndu'e wu gholi moni gǝzǝn mbatli. ");
INSERT INTO plj_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","A yari ni muntu den ar mbuni in ra ni, ba'e dǝ a tlat kǝn deni ni da'a, kǝ dǝ a kǝrkǝmi in dǝmi gin ni, dǝ kǝ kur ni gǝs gip bote Babom, ba'e na rapdlan mbatl da'a. ");
INSERT INTO plj_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","Murgon ni shin wu ne na nye gǝr den'e wi gudlumi, kan tǝ shin'e tǝ den pi argon tu kan ndari da'a, ama tǝ ndu ti hoyiwo, se tǝ gudlumi nan ti. Ti ni tǝ pi untuwo, tǝ pi warwat pitǝn da'a. ");
INSERT INTO plj_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","Ama mbarǝm tu ni pǝni mbatl gǝs den'e ti'i gudlumi nan ti da'a, kan ti mbu nǝmi gam gǝsi, ar nǝm ti te yarka tǝ gudlumi nan ti da'a, muntuwo dlat ni tǝ pi. ");
INSERT INTO plj_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","Ra untuwo, muntu kan gudlumi na nye gǝr tu kan wu ne den wi gudlumi nan tiwo, tǝ pi dlat. Ama muntu kan gudlumi nan tiyi dawo, tǝ pi argon tu kan mani mbuntǝn gwa. ");
INSERT INTO plj_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","Gǝr mǝtli ba za bakos gǝs da'a kosi ni ra na ge mbatl gwa, ama bakos gǝsi ni mǝsh kawo, ti mani gudlumi na muntu tǝ ndu gwa, ama dǝ mǝri nǝ ra gip mǝn kopi Babomi. ");
INSERT INTO plj_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","Ama gip shini gǝno, dǝmi gǝs untu baa gholi ti mbatl mani. Gip shini gǝno ami na Ruhu kǝ Yami. ");
INSERT INTO plj_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","Kǝkǝno den fingal tu kan ba ta'i bar ju ba bote wuro, mǝ mom'e kup gǝmiwo mǝn ra na momi bari. Momi bar ngapo ar ba kem tlora, ndutǝn ngapo ar ba kem ne am mbarǝm kup. ");
INSERT INTO plj_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","Munju kan ba kum'e wu mom argono, wu mom kanda tu ar ndari wu mom gwawi da'a. ");
INSERT INTO plj_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","Ama Yam mom kup muntu ba ndu ti gwa. ");
INSERT INTO plj_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","Untuwo, den bi ci fingal tu kan ta'i bar ju kan ba bote wuro, mǝ mom'e, bar ju kan ba bote wuro argon ni da'a ko njem gip atl kup, eso mǝ mom'e, <<Yamo nǝm ni gon'i da'a.>> ");
INSERT INTO plj_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","Kup na bar jen ra nan ba wul wur'e yam gwa to yamka ko sur atli, untuni, ga yam na babom ra na womti, ");
INSERT INTO plj_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","kup na untu, kar miwo Yam nǝm ni. Ti ni'e Bǝba, muntu tǝp kar ti ni bar kup zam dǝmi, muntu kan gip ti ni mǝ zam dǝmi gwa, Babomo nǝm ni Yesu Almasihu, tǝp kar tini bar kup zam gǝs dǝmi, kan gip tini mǝ zam dǝmi. ");
INSERT INTO plj_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","Ama kup mbarǝm ni mom untu da'a. Jen kan ba bote bar ju ba bote wur dǝmi dliwo, wini wu ci fingal wariwo, wu kum wule fingal tu wu ciwo fingal kǝ argon tu ba bote ti gwa ni. Damtǝn gǝzǝn ndǝr da'a, wu shin wule wu dǝm bar kǝ dǝɗan wi, se ar ghun wuri. ");
INSERT INTO plj_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","Fingal ba ɗir mi kosak na Yam da'a, mǝn ni mǝ ci da ma mǝ ca ka da'a, mǝnni mǝ ci ma ar mbǝli mi argon da'a. ");
INSERT INTO plj_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","Ama Ngup kǝnni ba dǝ zami gam gin tu kem kǝ dǝm tat pati asǝm dǝ munju damtǝn gǝzǝn ndǝr da gwa. ");
INSERT INTO plj_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","Ama gon nǝra, kan damtǝn gǝs ndǝr da'ani shin ki, ki kan kǝ mom bar gwa, den ci te bin war kawo, muntu baa ndǝri ti bigul kǝ ci fingal tu ta'i bar tu ba bote ti gwa diya? ");
INSERT INTO plj_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","Untuwo, momi bar gi tu baa kem ndetǝn kǝ muntu kan Almasihu mǝsh den bi gǝs gwa. ");
INSERT INTO plj_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","Kǝnni kǝ pii munju damtǝn gǝzǝn ndǝr dawo, Almasihu ni kǝ pi ti warwat pitǝne. ");
INSERT INTO plj_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","Untuwo, argon tu a ci ni baa kem erǝm kǝ ndetǝn gip warwat pitǝno, ko njem a'i ci tlu da'a, bǝse a kem erǝm gǝn ndetǝne. ");
INSERT INTO plj_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","Ami ni na enci diya? Ami nye mǝn kartǝn kǝ Yesu ni diya? A shinni Yesu Babom gǝmi diya? Kǝn ni'e argon tu kan mbap gǝn gip Babom gǝri gwa diya? ");
INSERT INTO plj_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","In ami nye mǝn kartǝn kǝ Yesu ni kar jen dawo, na ho bi ami nye mǝn kartǝn kǝ Yesu ni kar kǝne! Domici kǝn ni'e seda kǝ dǝmi gǝn nye mǝn kartǝn gip Babomi. ");
INSERT INTO plj_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","Na muntun a ho gam gǝn cina dǝ munju kan ndu tloyi shirǝm demǝn gwa. ");
INSERT INTO plj_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","Mǝ ndari ni dǝ bimi ci na tle diya? ");
INSERT INTO plj_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","Mi mani ni pǝni gǝr kushi kan ngǝsh ti den Yesuwi nan mi kandatu nami mir mǝn kartǝn kǝ Yesu na erǝm kǝ Babom na Kepas ba pi gwa diya? ");
INSERT INTO plj_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","Ko ami na Barnaba ni katl ar nǝm mǝ pi mbap kǝ dǝ mǝ ci na gam gǝmi wu? ");
INSERT INTO plj_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","Woni den pi mbap kǝ mǝn bi'utu, kan dǝ wule tini tǝ ci na gam gǝsu? Woni baa ngani kǝn inabi kan dǝ wule ti ci gǝri kini dawu? Woni baa le tla kan dǝ wule ti tla mal nyini dawu? ");
INSERT INTO plj_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","A yari ni untu den kopi kǝ mbatl kǝ mbarǝm na? Untu ni ma kulci kǝ Musa yari diya? ");
INSERT INTO plj_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","Anra na rǝshi gip kulci kǝ Musa'e, <<Ba kǝ la'i mbutum tla kan den co'i o gwa da'a.>> Tla ni katl Yam ba mom nan wura? ");
INSERT INTO plj_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","Den mini tǝ shirǝm da'aya? Na ho bi den mini rǝsh muntu. Ar mbuni dǝ mǝn kori bar na mǝn co'i o la mbatl zami argon tu ndar wur gwa gip bar kǝ kǝni. ");
INSERT INTO plj_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","In mǝ ngani ni badǝr kǝ ruhu su mbatl gin kawo, bar argon ni mǝn ni mǝ zam bar kǝ atl kar kǝn gwaya? ");
INSERT INTO plj_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","Jenni baa mani zami ne am rawo, mǝwo mǝ man wur diya? Kup na untu mǝ pi ampani na zami dǝ pi mi untu da'a ama mǝ ɓa mbatl dlom gam gip bar kup na dǝ zam argon tu kan ba la asǝm gip pi mbap zo shirǝm kǝ Almasihu gwa. ");
INSERT INTO plj_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","Kǝ mom ni'e mǝn pi mbap gip bom kǝ Yamo lasi ni wu zam fingal gǝzǝn da'aya? Mǝn mbap kǝ ba las tu ba ta'i Yam baro, wu zam ni gwazin gip bar ju mbosh gwa diya? ");
INSERT INTO plj_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","Untuni Babom yari den'e mǝn wazu zo shirǝmo, wi zam bar kǝ fingal gǝzǝn tǝp kǝ mbap tu. ");
INSERT INTO plj_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","Ama a pi ampani na ko nǝm gip bar ju kan ar ndari dǝ pim gwa da'a, ba'e a rǝshi in ni muntu kǝ dǝ kǝ pim untu da'a. Ar manim a mǝshka, na a hol ɓe ngetl na muntu. ");
INSERT INTO plj_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","Kup na ami den wazu zo shirǝm mǝn tǝmtǝni, ar dǝmim bar kǝ ɓe ngetl da'a, nan ar nǝmǝn te yarka kǝ pi gwa. Kashto gǝni, ami ni a pi wazu zo shirǝmi da gwa. ");
INSERT INTO plj_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","Dǝ wule kǝ ndu'i kǝ mbatl gǝn ni a piwo, aa zam ɓatltǝne, ama nan kǝ ndu'i kǝ mbatl gǝn ni dawo, ar dǝm wi'e mbap gǝn ni'e a ne ger dene. ");
INSERT INTO plj_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","To, ununu'e ɓatltǝn gǝnwe? Ɓatltǝn gǝn ni'e a pi wazu zo shirǝm kǝ Yesu ngǝlǝk. A pi ampani na kup bar ju ar ndari dǝ pim gip mbap yari zo shirǝmi da'a. ");
INSERT INTO plj_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","Kup na ami zher kǝ murgon ni da'a ama a pali gam gǝnka zher kǝ mbarǝm kup, kǝ dǝ a dǝl mbarǝm na womti. ");
INSERT INTO plj_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","Kar mǝn Yahudawo a dǝm wule Ba mǝn Yahuda kǝ dǝ a dǝl mǝn Yahudayi. Kar munju kan ba kop kulci kǝ Musawo, a pali gam gǝn wule mǝn kopi kulci kǝ Musa (kup na ami ni den kopi kulci kǝ Musa da'a), kǝ dǝ a dǝl munju kan den kopi kulci kǝ Musa gwa. ");
INSERT INTO plj_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","Kar munju kan ba kop kulci kǝ Musa dawo, a dǝm wule muntu ba kop kulciyi da gwa (ba'e Kulci kǝ Yam to gam gǝn da'i da'a ni ama ami ni gǝs dǝ kulci kǝ Almasihu), kǝ dǝ a tla gam kǝ munju kan ba kop kulci kǝ Musa dagwa. ");
INSERT INTO plj_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","Kar mǝn ro'i bigulo gip ngǝshtǝn gǝzǝn den Yesuwo, a dǝm wule mǝn ro'i bigule, kǝ dǝ a dǝl wur ra. A dǝm bar kup wi kar ko gonge badǝr mbarǝm wi, kǝ dǝ ko tǝp imni a zam ɗǝli jeni. ");
INSERT INTO plj_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","A pini untu kup den bi zo shirǝmi kǝ dǝ a zam albarka kǝ zo shirǝmi. ");
INSERT INTO plj_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","Kǝ mom'e kǝ ba pǝni sanwo kup mbarǝm ni ba kǝtǝre ama nǝm ni ba ci gam ɓaali diya? Ra untuwo, kǝtǝrni kǝ dǝ kǝ zamni ci gam ɓaali. ");
INSERT INTO plj_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","Mir mǝn cet ba lutini dli gǝzǝn hoyi gip ko-unu. Wu pini kǝ dǝ wu zam ci gam ɓaal tu kan baa nulǝm ka gwa, ama miwo kǝ ci gam ɓaal tu kan baa nulǝmka da gwa ni. ");
INSERT INTO plj_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","Den untuwo, a kǝtǝr ni katl da'a. Dluptǝn gǝno itǝr ni a dlup da'a. ");
INSERT INTO plj_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","O'o, a lutǝni dli gǝni, kǝ dǝ a pali ti zher gǝni, bǝse den kaar kǝ pii jen wazuwo, ami na gam gǝn ngapo dǝ byalǝmka a hol zami ci gam ɓaali. ");
INSERT INTO plj_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","Mir ɓyari, a ndu kǝ hol momi da'a kori gǝmi terkawo wu kop gǝs dun yami, kan kup gǝzǝn wu kop gip bar ɓula'i. ");
INSERT INTO plj_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","Pi batisma kup gǝzǝn gip kopi Musa gǝs dun yam na gip bar ɓula'i. ");
INSERT INTO plj_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","Kup gǝzǝn wu ci nǝm fingal kǝ Ruhu tu, ");
INSERT INTO plj_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","kan kup wu tla nǝm mal kǝ Ruhu tu. Mali kan wu tlawo, kar tlǝndǝr kǝ ruhu ni kan den ritǝn nan wurgwa, kan tlǝndǝriwo Almasihu ni. ");
INSERT INTO plj_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","Kup na untuwo Yam pi ghol mbatl na womti gǝzǝn da'a, kan ba ri wur eka gip lǝpe. ");
INSERT INTO plj_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","Kup bar ju zam wuro dǝli kǝm ni ne mi den ba mǝ pini laam wani bar ju wu pi gwa da'a. ");
INSERT INTO plj_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","Ba kǝ dǝmni mǝn bote bar ju ba bote wur gwa da'a, kandatu jen gǝzǝn pi gwa. Kandatu ar ra na rǝshi gwa'e <<Mbarǝm dǝm gǝzǝn kǝ ci na tle na dlar na muri na mutli kari.>> ");
INSERT INTO plj_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","Ba mǝ pini warwat pitǝn kǝ muri na mǝtli kandatu jen gǝzǝn pi gwa da'a, kan mbarǝm zangu hauya nǝm na myakan ba mǝshka (23,000) pǝti nǝm. ");
INSERT INTO plj_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","Ba mǝ gode ni Almasihu kandatu jen gǝzǝn pi gwa da'a, kan ici ba ri wur eka. ");
INSERT INTO plj_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","Ba mǝ ngwar ni kandatu jen pi gwa da'a kan mǝn ri mbarǝm e ba ri wur eka gwa. ");
INSERT INTO plj_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","Bar ju kup zam wurni kǝ dǝ shini kan ba rǝsh kǝ dǝ dǝli mi kǝme, mǝn munju kan patǝn kǝ zhan ɗir den mi kosak wu gwa. ");
INSERT INTO plj_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","Ra untuwo, kup muntu kan ba kum wule tǝra dloro, tǝ zhit ndǝr, ba tǝ ndaka da'a! ");
INSERT INTO plj_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","Godetǝn gon ra da'a nan zam kǝn wu kan taɓe zami nya mbarǝm wu gwa da'a. Yamo mǝn pitǝn dlat ni, ti za kǝn dǝ gode in ar man dǝrtǝn kǝ bigul gin da'a. Ama wokoci tu den gode gino, ti pi in guntǝp ɗǝltǝne kandatu ki mani kuri gǝs gipi gwa. ");
INSERT INTO plj_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","Ra untuwo, kǝn berǝm gǝn kǝ ndu'i, kǝtǝrini bar ju ba bote wur kan Yam ni dagwa. ");
INSERT INTO plj_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","A shirǝm ni nan kǝn den kǝn munju kan mom kǝ pi gwa ni, zhit ni gam gin kǝ shin ni argon tu kan a yari in gwa. ");
INSERT INTO plj_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","Gal godiya muntu kan mǝ gode Yam nariwo, arni kem mi dǝmi nǝm gip bǝran kǝ Almasihu diya? Kan bǝredi kan mǝ ceno, arni ba kem mǝ dǝm nǝm gip dli kǝ Almasihu diya? ");
INSERT INTO plj_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","Nan bǝrediwo nǝmno, eso mǝn kan ra na womti ma dli nǝm ni, domici kup gǝmi bǝredi nǝm tu ni mǝ ci. ");
INSERT INTO plj_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","Kulci ni den pitǝn kǝ mǝn Isra'ila, munju ba ci fingal ju ba ta'i Yamo ngashi gam ni wu pi na ba keri bar ju ɗiri Yam gwa diya? ");
INSERT INTO plj_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","Argon tu a yariwo ar ni'e bar tu mboshi bar tu ba bote tiyi ni'e argona, ko bar tu ba bote tiyi ni'e argoni? ");
INSERT INTO plj_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","O'o, ama argon tu munju kan mom Yam da'a ba mbosho, dun itǝr ni wu mboshi wuri, ba'e Yam ni wu mboshi ti da'a. A ndu'e kǝ ngash gam na dun itǝr da'a. ");
INSERT INTO plj_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","Ar ba pi da'a, kǝ tla gip gal kǝ Babom kǝ pal kǝ tla gip gal kǝ dun itǝri. Arba pi da'a, kǝ ci fingal den tebǝr kǝ Babomi kan kǝ pa ci den tebǝr kǝ dun itǝr da'a. ");
INSERT INTO plj_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","Kǝ wo ni Yam kǝ pi ghuve ya? Mǝ man tǝni ndǝrtǝna? ");
INSERT INTO plj_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","<<Aa mani pi kup argon tu a ndu gwa,>> ama bar kup ni ba ɓitem argon da'a. <<Aa mani pi kup argon tu a ndu gwa,>> ama bar kup ni ba ne'i am ra da'a. ");
INSERT INTO plj_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","Ba dǝ mbarǝm pi ho bar gam gǝs katl da'a, ama tǝ pi argon tu ba mbuni nami gwa. ");
INSERT INTO plj_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","Cini tlu tu kan ba wurka kǝ ba bar pǝt gwa, ba kǝ ngenni momi dene da'a, den bi damtǝn kǝ mbatl gini. ");
INSERT INTO plj_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","Anra na rǝshi'e <<Atl kundǝrǝndlipo kǝ Babom ni, na kup bar ju gipi gwa.>> ");
INSERT INTO plj_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","Muntu kan ngǝsh ti den Yesu da'a gon ni lakǝn bi kǝ ci fingalo, kǝn ni kǝ riwo, cini fingal tu ne cina da in gwa, bat na momi ngeni dene den bi damtǝn gini. ");
INSERT INTO plj_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","Ama murgon ni wul kǝn'e, <<Tlu kǝno kǝ bar ju ba bote wur gwa ni,>> ba kǝ cini da'a, den bi damtǝn kǝ muntu kan yari'i gwa bǝse dǝ damtǝn gin byal kǝne. ");
INSERT INTO plj_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","Damtǝn kǝ mbarǝmi ni a yari, ba'e ge da'a. Gon gin baa mani wultǝn'e, <<im nifa damtǝn kǝ gon ba kem dǝ enci gǝn pakawe?>> ");
INSERT INTO plj_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","Ami ni a goode den fingal gǝno, unun kem baa shimǝn na dun ger den ci argon tu a goode Yam gwawu? ");
INSERT INTO plj_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","Kup argon tu kǝ pi ko ci ko tlewo, pini kup den bi ɗǝɗa Yami. ");
INSERT INTO plj_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","Ba kǝ dǝmini jen bar kǝ pati asǝm da'a ko mǝn Yahuda ni, ko dǝ munju kan mǝn Yahuda ni dagwa, ko dǝ mǝn kopi Yami. ");
INSERT INTO plj_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","Pini kandatu a pi gwa. A pini argon tu mbarǝm baa kum tǝmi gip kup argon tu a pi gwa. Gam gǝn ni katl a ngeni ti ho bar da'a ama dǝ mbarǝm na womti zam ɗǝltǝn ra. ");
INSERT INTO plj_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","Kulci ni argon tu a pi gwa kandatu kan a kulci argon tu Almasihu pi gwa. ");
INSERT INTO plj_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","A ɗǝɗa kǝne, domici kǝ tune namǝn gip bar kup, kǝn ra dlakǝt na bar ju a kulci in kandatu a wul kǝn'e kǝ pi gwa. ");
INSERT INTO plj_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","Ama a ndu kǝ mom'e, gam kǝ ko gonge moniwo Almasihu ni, gam kǝ gǝr mǝtli ngapo moni ni, kan gam kǝ Almasihu ngapo Yam ni. ");
INSERT INTO plj_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","Kup moni tu shirǝm na Yam ko tǝ yari shirǝm kǝ Yam na gam gǝs na ghumiwo, tǝ mbur ni kǝ cina da ti. ");
INSERT INTO plj_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","Ama gǝr mǝtli tu kup ba shirǝm na Yam ko tǝ pi yari shirǝm na gam gǝs na ɓuliwo, tǝ mbur ni bakos gǝsi. Nǝm ni ar ra na dǝ fili ti gam ka. ");
INSERT INTO plj_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","Gǝr mǝtli ni baa ghum gam gǝska dawo, se dǝ fili gamka. Ama ti ni tǝ shin'e bar kǝ sham ni dǝ fili ko dǝ mboshi ti ta gamkawo, se tǝ ghum gam gǝska. ");
INSERT INTO plj_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","Ar ndari dǝ moni ghum gam gǝska da'a, nan ti kama na naartǝn kǝ Yam ni gwa, ama gǝr mǝtliwo den bi naartǝn kǝ moni ni. ");
INSERT INTO plj_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","Moniwo ɗǝli ti ni gip gǝr mǝtli da'a, ama gǝr mǝtliwo ɗǝli tǝ ni gip moni. ");
INSERT INTO plj_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","Domici pi ni moni den bi kǝ gǝr mǝtli da'a, ama gǝr mǝtliwo pi tǝ ni den bi kǝ moni. ");
INSERT INTO plj_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","Ra untuwo, ar ndari dǝ gǝr mǝtli ghum gam gǝska. Pi untu baa gode'e ti nǝ ra atli na moni, den bi kǝ mir mǝn kartǝn kǝ Yami. ");
INSERT INTO plj_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","Kup na gip Babomo, gǝr mǝtliwo bom ni tǝra na moni da'a, untu ni es moniwo bom ni tǝra na gǝr mǝtli da'a. ");
INSERT INTO plj_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","Kandatu gǝr mǝtli ɗǝl ni gip moniwo, untu ni es moniwo gǝr mǝtli ni gǝr ti, ama bar kupo kar Yam ni ar ɗǝli. ");
INSERT INTO plj_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","Se kǝ tlo ni shirǝmi na gam gini, ar ndari dǝ gǝr mǝtli shirǝm na Yam gam gǝs ra na ɓuli ya? ");
INSERT INTO plj_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","Kandatu Yam pi ma ar gode'e moni nǝra na tlyari ta gamo bar kǝ sham ni kar ti. ");
INSERT INTO plj_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","Ama gǝr mǝtli ni na tlyari ta gamo, bar kǝ tlora ni kar ti diya? Bi ti ni tlyari ta gam kǝ dǝ ar dǝmi ti bar kǝ ghumi gam gǝsi. ");
INSERT INTO plj_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","Murgon ni ba ndu dǝli shirǝm den muntuwo, mǝn ra na tǝp gon kan mǝ kop gwa da'a, ko gip domtǝn kǝ mǝn kopi kup. ");
INSERT INTO plj_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","Den shirǝm tu ari kǝ yari kǝkǝno a ɗǝɗa kǝn da'a, den domtǝn gino kǝ kǝrkǝm bar ni da'a ama kǝ liika ni. ");
INSERT INTO plj_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","Na parewo, a kum'e, gip domtǝn gin kǝ mǝn kopiwo, gam gin ba dǝm nǝm da'a. Har a pare nǝmi shirǝmi wi. ");
INSERT INTO plj_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","Ar nǝm dǝ zam tatli gam gip kǝne, kǝ dǝ mani momi munju ba kop Yam hoyi gip kǝn gwa. ");
INSERT INTO plj_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","Ase kǝn ni kǝ dom kǝn kǝ ba lasi nǝmo fingal kǝ Babom ni kǝ ci da'a! ");
INSERT INTO plj_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","Domici kǝ ba ci fingalo, ko gonge ba neni ger den gal gǝsi, gono guzum ni tǝ kumi, gon ngapo tǝ tla ar tlo tiwi. ");
INSERT INTO plj_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","A! Kǝn ni ra na bom kan kii ci kǝ tla gwa diya? Ko kǝn ni den mburi domtǝn kǝ mǝn kopi Yam ka, tǝp kǝba bi sham munju am ri wur kaar da gwa? Unun aa wul kǝn rawu? A ɗǝɗa kǝna? O'o, aa ɗǝɗa kǝn da'a. ");
INSERT INTO plj_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","Argon tu kan a nǝm kar babom gwa ni a yari ine, Babom Yesu gas tu kan bi tǝkawo, tǝ pǝn bǝredi, ");
INSERT INTO plj_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","nan tǝ goode Yamo, ar ni tǝ ngetǝli, kan tǝ wule, <<Mun tuwo dli gǝn ni, muntu ra den bi gin gwa, cini cina na pi untu den bi tune namǝni.>> ");
INSERT INTO plj_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","Den kaar fingaliwo, ar ni tǝ pǝn gali, kan tǝ wule, <<Gal kǝno pel gudlum shirǝm ni muntu tabbate in na bǝran gǝn gwa. Pi ni untu kup wokoci tu kan kǝn den tle gwa, den bi tune namǝni.>> ");
INSERT INTO plj_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","Gas tu kup kǝn den ci fingal tu, kǝn ni es den tle gip gal tuwo, kǝn den yari mǝshtǝn kǝ Babom ituwi ar ri gas tu tii pal sur gwa. ");
INSERT INTO plj_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","Den untuwo, muntu kup ci fingal tu, ko tǝ tla gip gal kǝ Babomi, den tǝp tu kan ndari da'awo, tǝ pi ni warwat pitǝn kǝ mburi dli na bǝran kǝ Babom Yesu. ");
INSERT INTO plj_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","Ar mbun dǝ mbarǝm zhit gam gǝs kakani, kan tǝ nde ci bǝredi kan tǝ tla gip gali. ");
INSERT INTO plj_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","Muntu kup ci tǝ tla na ɗǝɗa dli kǝ Babom dawo, hukunci ni tǝ ci na tle gam gǝsi. ");
INSERT INTO plj_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","Argon tu kem na womti gin ndǝr da'a na kumi dli gwa itu. Na womti gin ngapo wu nde umur kawi, wu mǝsh ka ituwi. ");
INSERT INTO plj_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","Ama mǝn ni mǝ zhit gam gǝmi na gam gǝmi hoyiwo, mii nda gip hukunci da'a. ");
INSERT INTO plj_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","Babom ni tloyi mi shirǝmo, mǝn den zami horo ituwi, den ba dǝ hukunte mi na nami mbarǝm kǝ den kaar atl da'a. ");
INSERT INTO plj_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","Ra untuwo, mir ɓyari, kǝn ni kǝ mo gam kǝ ci filgalo, ɓut ni ya'ǝni. ");
INSERT INTO plj_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","Murgon tu ra na guzumo, tǝ ci rǝn bomka, kǝ dǝ kǝn ni kǝ dom kǝno, ba ar dǝli in hukunci da'a. Den nami shirǝm ngapo, ami ni a cwato, aa yari in bari jen kan kii kop gwa. ");
INSERT INTO plj_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","Mir ɓyari, kǝkǝno den shirǝm kǝ bar ju Ruhu ba biwo, a ndu'e kǝ hol momi da'a. ");
INSERT INTO plj_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","Kǝ mom'e nan kǝ dǝm mǝn kopiwi dawo, jili inka den kopi bar ju ba bote wur kan na bi da gwa. ");
INSERT INTO plj_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","Ra untuwo, a ndu kǝ mom'e murgon ra da'a kan ba shirǝm tǝp kar Ruhu kǝ Yam kan baa wule, <<Yesu ra na bi gip ti!>> Untu ni es murgon ra kan baa mani wultǝn'e, <<Yesu Babom ni,>> se tǝp gip ndǝrtǝn kǝ Ruhu kǝ Yami. ");
INSERT INTO plj_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","Bi bar ra na womti, ama Ruhuwo nǝm ni. ");
INSERT INTO plj_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","Mbap kǝ pi ra na womti, ama Babom nǝm ni ba pi ti. ");
INSERT INTO plj_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","Mbap ra na womti, ama kup gǝzǝno Yam nǝm ni ba bii ko gonge mbarǝm tǝ pi. ");
INSERT INTO plj_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","Yam bi ko gonge mbarǝm bi bar kǝ Ruhu den dǝ ne am mbarǝm kup ra. ");
INSERT INTO plj_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","Gono bi ti ni bi bar kǝ Ruhu kǝ shirǝm na bopya. Gon ngapo bi ti ni bi bar kǝ shirǝm kǝ momi bari, tǝp kar nǝm Ruhu tu. ");
INSERT INTO plj_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","Gono bi ti ni mani ngǝshtǝn den Yam tǝp kar Ruhu tu. Gon ngapo kǝ mani pǝni mbarǝm kumi dlika tǝp kar Ruhu tu. ");
INSERT INTO plj_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","Gono pi bar kǝ dlǝkǝntǝne. Gono bi bar kǝ yari shirǝm kǝ Yami. Gon ngap momi Ruhu na dun itǝri. Gono mani pi shirǝm gip bi na womti, gon eso pasare bi na womti. ");
INSERT INTO plj_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","Bar ju kupo Ruhu nǝm ni ba kem wur kǝ pitǝne. Tǝ bii ni ko gonge gǝzǝn kandatu tǝ ndu gwa. ");
INSERT INTO plj_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","Kandatu kan dli ra nǝm, tǝra es na kǝti na womti. Wi kǝtiyi ngap, kup na wi ra na womtiyo, dli nǝm ni. To, untu ni Almasihu ra. ");
INSERT INTO plj_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","Kup gǝmiwo pi mi ni batisma gip Ruhu nǝm mǝ dǝm dli nǝmwi, mǝn Yahuda ko munju mǝn Yahuda ni da'a, ko zhere ko mimiri, kup gǝmiwo mǝ tla ni gip Ruhu nǝm. ");
INSERT INTO plj_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","Dliwo kǝti nǝm ni da'a, kǝti ni na womti. ");
INSERT INTO plj_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","Asǝm ni wule, <<Tun kan ami am ni dawo, ami kǝti kǝ dli ni da'a.>> Yari untu ni baa kem dǝ ɗǝli tika gip kǝti kǝ dli da'a. ");
INSERT INTO plj_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","O kǝm baa wule, <<Tun kan ami ger ni dawo, ami kǝti kǝ dli ni da'a.>> Yari untu ni ba ɗǝli tika gip kǝti kǝ dli da'a. ");
INSERT INTO plj_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","Dǝ wule dli kup gerno, na unun baa kumi? Dǝ wule dli kup kǝmno, na unun ba usun bari? ");
INSERT INTO plj_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","Ar tu Yam kǝrkǝm kǝti kǝ dli kup, ko gonge kǝti kǝ dliyi kandatu tǝ ndu gwa. ");
INSERT INTO plj_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","Dǝ wule kup dli kǝti nǝmno ako ni nami dli ba nǝra we? ");
INSERT INTO plj_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","Ama ar tu kǝti ra na womti, dli ngap nǝm. ");
INSERT INTO plj_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","Ger baa mani wuli am e, <<Argon mom nan ki da'i da'a.>> Ko dǝ gam wul asǝm'e, <<Argon mom nan kǝn da'a.>> ");
INSERT INTO plj_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","Untu ni ar ra da'a, kǝti kǝ dli ju ba shin wule wu ndǝr da ma, wi ni'e mǝn pi mbap hoyi. ");
INSERT INTO plj_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","Kǝti kǝ dli ju kan ba shin wu ri jen naartǝn dawo, wi ni mǝ mani bi wur naartǝni. Den untu ni kǝti kǝ dli gǝmi kan tǝm shini da'a, ba mbǝl ra den mbuntǝn gǝzǝni. ");
INSERT INTO plj_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","Kǝti kǝ dli gǝmi ju kan tǝm shini ngapo, ba se pi wur argon ra da'a. Ama Yam ni mo dli, tǝ pali kǝti tu kan naar da'a, ar dǝm mǝn pi mbap hoyi. ");
INSERT INTO plj_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","Ba dǝ tatli gam zam gip dli da'a, se de dǝ kǝti kǝ dli ne am ezǝn ra biyi nǝm. ");
INSERT INTO plj_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","Den untu ni kup kǝti tu ba kum dliwo, se wu kum dli biyi nǝm. In ɗǝɗa gono, se kup gǝzǝn wu pi ghol mbatli. ");
INSERT INTO plj_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","Kǝkǝno kǝn dli kǝ Almasihu ni, ko gonge gin kǝti kǝ dli gǝs ni. ");
INSERT INTO plj_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","Gip domtǝn kǝ mǝn kopiwo, Yam kem dǝ jen dǝm kǝ nǝm, mir mǝn kartǝne, kǝ rop, mǝn yari shirǝm kǝ Yami, kǝ myakan, mǝn kulci mbarǝme, se mǝn pi bar kǝ dlǝkǝntǝne. Se mǝn mani pǝni kumi dli kǝ mbarǝm ka, na mǝn ne mbarǝm am ra, na mǝn kopi na domtǝn kǝ mǝn kopi, na mǝn shirǝm na bi kǝ jen na womti. ");
INSERT INTO plj_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","Kupo, mǝn kartǝn na? Ko kup kani'e mǝn yari shirǝm kǝ Yami? Ko kup mǝn kulci mbarǝm ni? Kup ka ni'e mǝn pi bar kǝ dlǝkǝntǝna? ");
INSERT INTO plj_vpl VALUES ("C112_30","076_12_30","1CO","12","30","30","Kup kan ba mani pǝni kumi dli mbarǝm ka ya? Kup kani na mani shirǝm na bi kǝ jena? Ko kup ka ni ba pasare? ");
INSERT INTO plj_vpl VALUES ("C112_31","076_12_31","1CO","12"