﻿USE sofia;
DROP TABLE IF EXISTS sofia.pjt_vpl;
CREATE TABLE pjt_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES pjt_vpl WRITE;
INSERT INTO pjt_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Kuwaripatjara mulapa Godalu ilkaṟi munu manta palyaṉu uwankara wiyangka. ");
INSERT INTO pjt_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Palu manta uwankara uḻṯu ngaṟangi, ka uṟu kutju tjiwariwari ngaringi puḻka mulapa, ka mungawaḻuṟungku tjutuningi. Ka Godaku kurunpa para-ngaṟangi uṟungka katuwanu. ");
INSERT INTO pjt_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Palulanguṟu Godalu wangkangu, “Kaḻaḻari!” Ka kaḻaḻaringu. ");
INSERT INTO pjt_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ka kaḻaḻarinyangka nyakula Godanya pukuḻaringu wiṟu mulapa ngaṟanyangka. Munu paluṟu mungawaḻuṟu munu kaḻaḻa tiṯutiṯuṉu, ");
INSERT INTO pjt_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","munu ininu “Munga”, munu “Kaḻaḻa”. Ka kaḻaḻa ngaṟala mungartjirira mungaringkula piṟuku ngalya-tjiṉṯuringu. ");
INSERT INTO pjt_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","7","Ka Godalu piṟuku wangkangu, “Uṟu pala tjarariwa munu katu tjaṟu ngarima ka nguṟurpa aḻa puḻka ngaṟama.” Ka paluṟu wangkanyangka mulapaṯu tjararingu, panya Godalu wangkangku uṟu tjaraṉu munu katu tjaṟu ngarinytjaku wangkangu munu nguṟurpa aḻa puḻka ngaṟanytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Munu tjaraṟa wiyaringkula paluṟu aḻa panya nguṟurpa ngaṟanytja ininu “Ilkaṟi.” Ka tjiṉṯu nyanga kutjaritja mungartjirira mungaringkula ngalya-tjiṉṯuringu. ");
INSERT INTO pjt_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Ka Godalu wangkangu, “Uṟu pala puḻka tjaṟu ngarinytja ma-kitikitiriwa ka manta utiriwa.” Ka mulapaṯu alatjiringu Godalu wangkanyangka. ");
INSERT INTO pjt_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Ka manta utiringkunyangka Godalu ininu “Manta”, munu paluṟu uṟu kitikitiringkula ngarinyangka ininu “Uṟu Puḻkanya”. Munu paluṟu pukuḻaringu wiṟu mulapa ngaṟanyangka. ");
INSERT INTO pjt_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","12","Munu palulanguṟu wangkangu, “Mantangka ukiṟi tjuṯariwa munu puṉu kutjupa kutjupa tjuṯa kuḻu pakala, puṉu uṉinypatjara munu puṉu maitjara tjuṯa kuḻu uṉinypa walytjatjara walytjatjara.” Ka mulapaṯu pakaṉu ukiṟi puṉu kutjupa kutjupa tjuṯa mulapa uṉinypa walytjatjara uwankara. Ka Godanya nyakula pukuḻaringu wiṟu mulapa ngaṟanyangka. ");
INSERT INTO pjt_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ka tjiṉṯu nyanga maṉkuritja mungartjirira mungaringkula ngalya-tjiṉṯuringu. ");
INSERT INTO pjt_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","16","Ka Godalu wangkangu, “Ilkaṟingka pala tili tjuṯa utiriwa nyinara manta irnyantjikitja kutju kaḻaḻaku, kutjupa tjuṯa mungaku.” Munu Godalu tili puḻka kutjara tjunu, kutju puḻka mulapa ini tjiṉṯu kaḻaḻa irnyantjaku, munu kutjupa tjuku nguwanpa ini piṟa mungangka irnyantjaku. Munu paluṟu kililpi tjuṯa mulapa ilkaṟingka tjunu mungangka irnyantjaku. Munu Godalu wangkangu, “Tili nyanga palula tjanalanguṟuya aṉangu tjuṯangku nyakula kulilku tjiṉṯuringkunyangka munu mungaringkunyangka munuya piṟa ma-ngarinyangka nyakula kulilku piṟa kutju ngaṟala wiyaringkunytja, munuya palulanguṟu kuḻi, nyiṉnga, piriyakutu kuḻu ngurkantankuku.” Ka mulapaṯu uwankara alatjiringu Godalu wangkanyangka. ");
INSERT INTO pjt_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","18","Panya paluṟu tili tjuṯa ilkaṟingka tjunu manta irnyaṟa utintjaku, tjiṉṯungku pakaṟa irnyaṟa kaḻaḻankunytjaku, piṟa kililpi tjuṯa mungangka irnyantjaku. Alatji paluṟu tili tjuṯa tjunu munga kaḻaḻa tiṯutiṯu rawa ngaṟanytjaku. Munu paluṟu nyakula pukuḻaringu wiṟu mulapa ngaṟanyangka. ");
INSERT INTO pjt_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ka tjiṉṯu nyanga kutjara kutjaritja mungartjirira mungaringkula ngalya-tjiṉṯuringu. ");
INSERT INTO pjt_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Ka Godalu wangkangu, “Pala uṟungka unngu kuka tjuṯa utiringkula tjuṯariwa antipina kutjupa kutjupa tjuṯa mungilyi mulapa, waṉampi tjuṯa, uṟu unngutja kutjupa kutjupa uwankara. Munu ilkaṟingka tjuḻpu kutjupa kutjupa tjuṯa parpakaṟa para-ngaṟama mungilyi mulapa.” ");
INSERT INTO pjt_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Alatji Godalu wangkangku palyaṉu waṉampi kutjupa kutjupa puḻka tjuṯa munu antipina kutjupa kutjupa tjuṯa, uṟu unngutja uwankara paluṟu tjunu uṟungka unngu para-ngaṟanytjaku. Munu paluṟu ilkaṟingka para-ngaṟanytjaku tjuḻpu kutjupa kutjupa uwankaraṯu tjunu. Munu paluṟu nyakula pukuḻaringu wiṟu mulapa ngaṟanyangka. ");
INSERT INTO pjt_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Munu paluṟu tjananya uwankara pukuḻmanu wangkara, “Kuḻunytjararingkulayanku tjuṯaringama. Uṟu unngutja tjuṯa uṟungka mungilyirira lipiringama, kayanku tjuḻpu tjuṯa kuḻu mantangka tjuṯaringama.” ");
INSERT INTO pjt_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ka tjiṉṯu nyanga maṉkur-kutjaritja mungartjirira mungaringkula ngalya-tjiṉṯuringu. ");
INSERT INTO pjt_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Ka Godalu wangkangu, “Mantangka utiringkula ngaṟama para-ngaṟapai kutjupa kutjupa tjuṯa, panya kuka tjuṯa, munu kuka wiya tjuṯa kuḻu, ngultju tjuṯa munu inuṟa tjuṯa, puḻka tjuṯa munu tjukutjuku tjuṯa kuḻu, tjuninguṟu ankupai tjuṯa kuḻu utiringkula para-ngaṟama.” Ka mulapaṯu alatjiringu. ");
INSERT INTO pjt_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Godalu mantangka para-ngaṟapai kutjupa kutjupa uwankara palyaṉu, inuṟa kutjupa kutjupa tjuṯa, ngultju kutjupa kutjupa tjuṯa, munu tjukutjuku tjuṯa kuḻu, tjuninguṟu ankupai tjuṯa uwankara mulapa. Munu paluṟu uwankara nyakula pukuḻaringu wiṟu mulapa ngaṟanyangka. ");
INSERT INTO pjt_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Palulanguṟu Godalu wangkangu, “Wanyula nganaṉanku puṟunypa aṉangu palyala nganaṉa puṟunypa nyinanytjaku. Kaya aṉangu paluṟu tjana kuka uwankaraku mayatja ngaṟaku antipina tjuṯaku, tjuḻpu tjuṯaku, mantangka para-ngaṟapai uwankaraku, puḻka tjuṯa munu tjukutjuku tjuṯaku kuḻu.” ");
INSERT INTO pjt_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Munu mulapaṯu Godalu aṉangu paluṉu paluṟunku puṟunypa. Ka paluṟu pula wati munu kungka. ");
INSERT INTO pjt_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Munu Godalu pulanya pukuḻmanu alatji wangkara, “Nyupali tjitji tjuṯatjararingama, kaya nyupalilanguṟu walytja tjuṯaringama munuya manta winkingka ma-mungilyirira nyinama maḻatja maḻatja, munuya ngura tjuṯa mulapa palyanma tjiwariwari pukuḻpa palya nyinanytjikitjangku. Munuya kutjupa kutjupa uwankara mayatjangku kanyinma, antipina tjuṯa, tjuḻpu tjuṯa, kuka tjuṯa, mantangka para-ngaṟapai uwankara kuḻu tjunguṟa.” ");
INSERT INTO pjt_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","“Munu nyawa! Ngayulu ukiṟi uṉinypatjara kutjupa kutjupa uwankara, puṉu maitjara kutjupa kutjupa uwankara, mai mantatja uwankara kuḻu mantangka tjunu nyura ngalkula paḻtjaringkunytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Munu ngayulu mai ukiṟi, mai parka puḻka mulapa mantangka tjunu kukangku, tjuḻpungku, mantangka para-ngaṟapai uwankarangku ngalkuntjaku.” Ka mulapa alatjiringu Godalu wangkanyangka. ");
INSERT INTO pjt_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ka Godalu uwankara palyantjatjanungku nyakula pukuḻaringu uwankara wiṟu mulapa ngaṟanyangka. Ka tjiṉṯu nyanga maṉkur-maṉkuritja mungartjirira mungaringkula ngalya-tjiṉṯuringu. ");
INSERT INTO pjt_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Uwa, alatji panya Godalu manta ilkaṟi kutjupa kutjupa uwankara wangkangku palyaṉu, mantatja uṟutja ilkaṟitja uwankara kuḻu. ");
INSERT INTO pjt_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Paluṟu panya tjiṉṯu maṉkur-maṉkurpa palyaṟa wiyaṉu munu palulanguṟu tjiṉṯuringkula nyinara pakuwiyaringu piṟuku palyantja wiya tjiṉṯu panya 7-ta. ");
INSERT INTO pjt_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Munu paluṟu tjiṉṯu pala palunya miḻmiḻmanu palumpa tjiṉṯu wiṟu ngaṟanytjaku, panya tjiṉṯu pala palula paluṟu pakuwiyaringu uwankara palyaṟa wiyantjatjanu. ");
INSERT INTO pjt_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","5","Nyangatja tjukurpa ngaṉmanyitjatjara panya Mayatja Godalu manta ilkaṟi uwankara palyantjatjara. Ka panya ngaṉmanypa manta ilkaṟi palyannyangka ukiṟi munu puṉu tjuṯa mantangka wiya ngaṟangi, panya Godalu mina ngangkaḻitja mantangka puyintjaku iyantja wiya kuwaripaṯu. Ka manta tjawaṟa runyuṟa kaana palyantjaku aṉangu ngaṟanytja wiyaṯu kuwaripa. ");
INSERT INTO pjt_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Palu manta unngunguṟu aṟuma puṟunytju pakaṟa pupara manta tulykuningi. ");
INSERT INTO pjt_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Palulanguṟu Mayatja Godalu manta mantjinu munu wati palyaṉu mantanguṟu. Munu paluṟu wati mulya puuṟa kurunpa tjarpatjunu, ka wati paluṟu puntu winki wankaringu. ");
INSERT INTO pjt_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Ka Godalu kaana palyaṉu kakaraṟa ngura ini Edennga, munu nyara palula wati panya palunya tjunu. ");
INSERT INTO pjt_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Munu paluṟu mantanguṟu pakaltjingaṉu puṉu kutjupa kutjupa tjuṯa wiṟu mulapa mai wiṟutjara paluṟu ngalkula paḻtjaringkunytjaku. Munu puṉu kutjara kutjupa kaanangka nguṟurpa tjunu. Panya puṉu kutjunguṟu aṉangungku mai ngalkula tiṯutjara wanka nyinaku, palu puṉu nyara kutjupanguṟu mai ngalkula paluṟu nintiringkuku nyaa palya munu nyaa kura. ");
INSERT INTO pjt_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ka ngura nyara Edenta uṟu puḻka ukalingangi karungka, ka ukiṟi puṉu tjuṯa ngaṟangi uṟungka itingka. Ka karu paluṟu kaananguṟu ukalingkula tjararingkula karu kutjara kutjararingu ini nyanganpa – Pitjannga, Kiyannga, Taikiṟitjanya, munu Yupuṟaitinya. ");
INSERT INTO pjt_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","12","Ka karu Pitjannga ngura ini Apilala nguṟurwanu ma-ngarira ukalingangi. (Ngura nyara Apilala gold wiṟu mulapa ngaringi, munu paṉṯipai wiṟu mulapa, munu apu kutjupa wiṟu mulapa upula puṟunypa kuḻu ngaringi.) ");
INSERT INTO pjt_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ka karu panya Kiyannga ngura ini Kuutjula nguṟurwanu ma-ngarira ukalingangi. ");
INSERT INTO pjt_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Ka karu panya Taikiṟitjanya ngura ini Atjiṟiyala kakaraṟawanu kaṯakutjara wati-ngarira ukalingangi. Ka karu kutjupa panya Yupuṟaitinya. ");
INSERT INTO pjt_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Ka panya Mayatja Godalu wati panya palunya tjunu ngura nyara Edenta kaana aṯunymaṟa kanyintjaku munu manta tjawaṟa runyuṟa mai pakaltjingantjaku. ");
INSERT INTO pjt_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Munu Godalu wangkangu palula, “Kaanangka puṉu maitjara tjuṯa ngaṟanyi, ka nyuntu palya puṉu uwankaranguṟu mai mantjiṟa ngalkunma. ");
INSERT INTO pjt_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Palu puṉu kutjunguṟu ngalkuwiyangku wantima, puṉu panya palya munu kura nintilpailanguṟu. Mai pala palunya wantima, panya puṉu pala palulanguṟu mantjiṟa ngalkulampa nyuntu mulapa iluku.” ");
INSERT INTO pjt_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Palulanguṟu Mayatja Godalu kuliningi, “Wati nyangatja kutju nyinanyi ngaḻṯutjara, maḻpa wiya. Wanyu kaṉa palumpa maḻpa palyala palula tjungu nyinara alpamilantjaku, ka pula pukuḻpa nyinama maḻpaṟara.” ");
INSERT INTO pjt_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","20","Ka panya Godalu mantanguṟu palyaṉu mantangka para-ngaṟapai uwankara kuka kutjupa kutjupa tjuṯa munu tjuḻpu tjuṯa kuḻu. Munu paluṟu nyanganpa uwankara wati panya palulakutu ngalya-katingu kutju kutju nyakula ini tjunkunytjaku. Ka wati paluṟu nyakula ini tjuṯa wangkara waṉaningi, ka paluṟu tjana uwankara initjararingu tjuḻpu tjuṯa munu mantangka para-ngaṟapai tjuṯa, ngultju tjuṯa munu inuṟa tjuṯa kuḻu. Palu nyanga tjanala uwankaranguṟu kutju wiya ngaṟangi watiku maḻpa. ");
INSERT INTO pjt_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Ka palulanguṟu Mayatja Godalu wati palunya puḻkaṟa kunkuntjunu munu kunkunpa puḻka ngarinyangka kantilypa kutju mantjinu munu mantjiṟa iltjanpangka piṟuku maḻakungku tjutuṉu. ");
INSERT INTO pjt_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Munu paluṟu kantilypa pala palulanguṟu kungka palyaṉu munu palyaṟa wati panya palulakutu ngalya-katingu. ");
INSERT INTO pjt_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ka wati paluṟu nyakula puḻkaṟa pukuḻaringu munu Godala wangkangu alatji, “Ai! Nyangatja ngayulu puṟunypa, panya nyuntu palunya ngayulanguṟu palyaṉu, ngayuku tarkanguṟu, ngayuku iltjanpanguṟu. Kaṉa palunya inilku, ‘kungka.’” ");
INSERT INTO pjt_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Ka pala palulanguṟu panya, watingku mama ngunytju wantikatipai munu kungka aḻṯira palula tjunguringkupai munu pula kuriṟara kutjuringkupai iltjanpa kutjuṯu. ");
INSERT INTO pjt_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ka wati panya paluṟu pula nikiti nyinangi kuṉṯa wiya alatjiṯu. ");
INSERT INTO pjt_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Palu kutju liru Godalu palyantja ayinayini mulapa nyinangi kutjupa uwankarangka waintarinytja. Ka tjiṉṯu kutjupangka liru paluṟu pitjala kungka panya palula tjapinu ngunti kurantjikitjangku, “Yaaltjin kulini? Panya kaana nyangangka puṉu maitjara tjuṯa ngaṟanyi. Ka wanyu mulapa Mayatja Godalu nyupalinya painu puṉu nyanga uwankaranguṟu mai ngalkuwiyangku wantinytjaku?” ");
INSERT INTO pjt_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Ka kungkangku wangkangu palula, “Wiya, Godalu palyanmanu ngali puṉu tjuṯanguṟu mai mantjiṟa ngalkuntjaku. ");
INSERT INTO pjt_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Palu mulapa puṉu kutjunguṟulinya painu ngalkuwiyangku wantinytjaku, puṉu nyara kaanangka nguṟurpa ngaṟanyi, nyara palulanguṟu. Alatji paluṟu ngalinya painu, ‘Mai palunya pampulwiyangku wantima ilunytjaku-tawara.’” ");
INSERT INTO pjt_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Ka lirungku wangkangu, “Wiya, palatja ngunti wangkanytja. Nyuntu ngalkula ilunytja wiya. ");
INSERT INTO pjt_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Godalu alatji wangkara painu panya paluṟu nintingku kulini nyuntu mai palunya ngalkula nintiringkuku munu Godalu puṟunytju nintingku kulilku palya munu kura. Pala palu puṟunyarinytjaku-tawara Godalu nyuntunya painu.” Alatji lirungku wangkangu ngunti kurantjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Ka lirungku wangkanyangka kungka panya paluṟu puṉu panya nyakula kuliningi, “Ai! Mulapa nyangatja wiṟu mulapa ngaṟanyi. Ka nyanga wiṟuṯu ngaṟanyi ngalkuntjaku.” Munu paluṟu mukuringkula kuliningi, “Ngayulu kuwari mai nyanga palunya ngalkula Godanya puṟunypa ninti mularariku.” Munu alatji kulintjatjanungku paluṟu mai panya mantjiṟa ngalkuṉu. Munu palumpa kuri ungu, ka pula tjungungku mai palunya ngalkuṉu. ");
INSERT INTO pjt_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Munu pula ngalkula mapalku kulinu kura palyantjatjanungku munu pulanku nikiti ngaṟanytjatjanungku nyakula kuṉṯaringu. Palulanguṟu pula nyaḻpi puḻka tjuṯa puṉu iḻinguṟu mantjinu munu wakaṟa tjunguṟa mantara puṟunypa kutjara palyaṉu munu pulanku kaṟilpa karpiṟa angatjunu. ");
INSERT INTO pjt_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Munu pula mungartjirinyangka kulinu Mayatja Godanya kaanangka unngu para-ngaṟanyangka, munu pula nguḻu kumpinu puṉu tjaṯangka. ");
INSERT INTO pjt_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Palu Mayatjalu wati panya palunya tjapiṟa nguriningi, “Yaaltjingkan nyinanyi?” ");
INSERT INTO pjt_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ka wangkangu, “Wiya, nyuntu kaanangka para-ngaṟanyangkaṉa kuliningi, munuṉa nguḻuringkula kumpinu panya ngayulu nikiti ngaṟanyi.” ");
INSERT INTO pjt_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ka Godalu wangkangu, “Nganalunta wangkangu nyuntu nikiti ngaṟanytja? Nyuntu wanyu puṉu panya palulanguṟu mai panya mantjiṟa ngalkuṉu? Panya ngayulu painu ngalkuwiyangku wantinytjaku.” ");
INSERT INTO pjt_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ka wangkangu, “Wiya, kungka nyanga nyuntu ngayunya ungkunytjaluṉi ungu, kaṉa ngalkuṉu.” ");
INSERT INTO pjt_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Ka Godalu kungka panya palunya wangkangu, “Nyaakun nyuntu alatjingaṉu?” Ka wangkangu, “Wiya, lirungkuṉi ngunti kuraṉu ngalkuntjaku, kaṉa ngalkuṉu.” ");
INSERT INTO pjt_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Ka palulanguṟu Godalu lirungka wangkangu alatji, “Nyuntu kungka nyangatja ngunti kurannyangkaṉa nyuntunya ngapartji kuraṉi. Pala mantangka para-ngaṟapai kutjupa kutjupa tjuṯa nyinanyi, palu ngayulu nyuntunya kutju kuralku kutjupa tjuṯa wiya, kankuya aṉangu tjuṯangku nyuntumpa mukuringkunytja wiyangku alatjiṯu wantiku. Ka nyanganguṟu nyuntu tiṯutjara tjuninguṟu kutju para-pitjalinkuku kata ulpuru-ulpuru manta tjuningka pampuṟa. ");
INSERT INTO pjt_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Kaṉa nyanganguṟu liru kungkaṟarangku nyupalinku rawa kuraringkula pikaringkunytjaku palyalku, ka nyuranku liru tjuṯangku munu aṉangu tjuṯangku rawangku pikangku pungkuku. Panya aṉangungku nyuntunya kata kantuṟa puṟuntankuku, ka nyuntu palunya paalpa patjalku.” Alatji Godalu liru panya wangkara kuranmanu. ");
INSERT INTO pjt_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Munu paluṟu kungkawaṟangka ngapartji wangkangu alatji, “Nyuntun ngayula tungunpungkula mai ngalkuṉu, ka pala palulanguṟu ngayulu nyuntunya iṯitjararingkunyangka paku puḻka palyalku, ka nyuntu iṯi kanyiṟa pika puḻkaringkuku. Palu nyuntu wati kuriku puḻkaṟa mukuringkuku, ka paluṟu nyuntunya mayatjangku kanyilku.” Alatji Godalu kungkangka wangkangu. ");
INSERT INTO pjt_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Munu paluṟu watingka ngapartji wangkangu alatji, “Ngayulu panya nyuntunya wangkangu puṉu panya palulanguṟu mai ngalkuwiyangku wantinytjaku. Palu nyuntu ngayula tungunpungkula kuringka kulinu munu mantjiṟa ngalkuṉu. Pala palulanguṟu kuwari manta uwankara kuraringanyi, ka ukiṟi, puṉu tjuṯa wiṟuṟa pakantja wiyaringkuku. Ka nyuntu mai ngurintjikitja puḻkaṟa mulapa waṟkariku tiṯutjara alatjiṯu ilunytjakutu-wangkara. Kuwari mantangku nyuntunya puḻkaṟa pakuṉi mai ngalkuntjikitja waṟkarinyangka. ");
INSERT INTO pjt_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Ka mantangka pakalku ukiṟi kurakura tjuṯa tjilkatjara tjuṯa, ka nyuntu mai ilytjitja kutju ngalkuku. ");
INSERT INTO pjt_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Munu nyuntu mantangka mai pakaltjingantjikitja puḻkaṟa mulapa waṟkariku akuṟi-akuṟi puḻka. Palu nyuntu puḻkaṟa waṟkarinytja wiyangku wantira mai tjukutjuku mantjilku munun puṯu nguwanpa paḻtjaringkuku. Nyuntu tiṯutjara alatjiṯu waṟkariku ilunytjakutu-wangkara, munun ilura manta pala palula tjunguringkula piṟuku mantaringkuku. Panya ngayulu nyuntunya mantanguṟu palyaṉu, ka nyuntu ilura piṟuku mantaringkuku.” Alatji Godalu watingka wangkangu. ");
INSERT INTO pjt_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Ka Adamalu palumpa kuri ininu Eve-anya, panya minyma nyanga palulanguṟu aṉangu uwankara utiringkula wanka nyinaku maḻatja maḻatja. ");
INSERT INTO pjt_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Ka Mayatja Godalu kuka miṟinguṟu mantara palyaṉu Adamaku pulampa Eve-aku, ka pula tjarpangu. ");
INSERT INTO pjt_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Palulanguṟu Mayatja Godalunku kuliningi, “Kuwari aṉangu paluṟu pula mai panya ngalkuntjatjanungku nganaṉa puṟunytju nintingku kulini palya munu kura. Kala nyara palulanguṟu nganaṉa kuwari palunya pulanya kaananguṟu paini maḻakungku pitjala puṉu panya kutjupanguṟu mai ngalkula tiṯutjara wanka nyinanytjaku-tawara.” ");
INSERT INTO pjt_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Munu Godalu pulanya kaana panya ini Edentanguṟu paiṟa iyaṉu ankula ngura kutjupangka manta tjawaṟa runyuṟa waṟkarinytjaku. Panya Godalu wati mantanguṟu palyaṉu, munu pulanya kuraringkunyangka paiṟa iyaṉu manta panya palulaṯu maikitja waṟkarinytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Munu pulanya paintjatjanungku kaanangka kakaraṟa-pitinypa angelpa nyaḻpitjara tjuṯa ngaṟatjunu munu tjuḻa waṟa puḻka kuḻu tjunu, kaya anga-ngaṟangi aṉangungku puṉu panya palulanguṟu maḻakungku pitjala mai ngalkula wanka tiṯutjara nyinanytjaku-tawara. Ka tjuḻa puḻka panya paluṟu ayinayini tili winkitjara uri-uripai aṉangungku nyakula nguḻuringkunytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Ka Adamanya pula Eve-anya tjungu nyinara katjatjararingu. Ka Eve-alu wangkangu, “Tjitji nyangatjaṉi Godalu ungu. Palulanguṟuṉa palunya inini Kainnga.” ");
INSERT INTO pjt_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Munu pula ngula piṟuku katjatjararingu munu palunya ininu Abelnga. Ka Kaintu puḻkaringkula manta tjawaṟa runyuṟa kaana pakaltjinganingi, palu Abeltu puḻkaringkula tjiipi tjuṯa kanyiningi. ");
INSERT INTO pjt_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","4","Munu pula ngula Godanya ungkunytjikitjangku kutjupa kutjupa tjuṯa katingu pulampanguṟu, Kaintu katingu mai tjuṯa kaananguṟu. Ka Abeltu katingu tjiipi kuḻunypa katja ngaṉmanyitja. Munu paluṟu pungkula kuka kaṉpitjara wiṟu mulapa Godanya ungu palumpa pukuḻarira. Ka Godanya Abelku pukuḻaringu paluṟu kuka katira ungkunyangka. ");
INSERT INTO pjt_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Palu paluṟu Kainku pukuḻarinytja wiyangku wantingu. Ka Kainnga puḻkaṟa mirpaṉaringu munu paluṟu mulyararingu. ");
INSERT INTO pjt_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Ka Mayatja Godalu palula wangkangu, “Nyaanguṟu nyuntu mirpaṉarinyi? Nyaanguṟu nyuntu mulyara-mulyara nyinanyi? ");
INSERT INTO pjt_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Nyuntu tjinguṟu tjukaṟurungku palyantjatjanumpa pukuḻpa nyinama. Palu nyuntu panya tjukaṟurungku palyalwiyangku wantingu, kanta kurangku nyuntunya unngu waṟuṉu nyakula mulyara-mulyararinytjaku. Palu uti nyuntu kura palunya kulilwiyangku wantima nyuntunya kura mularmankunytjaku-tawara.” Alatji Godalu Kainta wangkangu. ");
INSERT INTO pjt_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ka kuliṟa wantingu munu ankula palumpa maḻanypa Abelnga wangkangu, “Arali puṯikutu.” Munu pula anu puṯikutu, ka katira kuṯangku pungkula iluntanu maḻanypa panya, munu pungkula wantikatira maḻaku anu ngurakutu. ");
INSERT INTO pjt_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Ka ngula Mayatja Godalu Kainta tjapinu, “Nyuntumpa panya maḻanypa yaaltji?” Ka wangkangu, “Wampa! Ngayuluṉa ngurpa! Iṯi wiya paluṟu, wati alatjiṯu, ngayulu aṯunymaṟa kanyintjaku wiya.” ");
INSERT INTO pjt_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Ka palulanguṟu Godalu palunya wangkangu, “Wiya, nyaanguṟu nyuntu maḻanypa pungkula iluntanu? Utin wantima! Palu kuwari nyuntumpa maḻanypaku milkaḻingku mantanguṟu ngayunya wangkanyi nyuntunya ngapartji pungkunytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Nyanga palulanguṟu kuwari nyuntumpa tjituṟu-tjituṟu puḻka ngaṟaku. Nyanganguṟu nyuntu manta tjawaṟa kaana puṯu palyalku. Panya mantangka nyuntumpa maḻanypaku milkaḻi tjutingu nyuntu palunya pungkula iluntankunyangka. ");
INSERT INTO pjt_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Ka nyuntu tjinguṟu manta tjawaṟa runyulku ukiṟi uṉinypa tjunkunytjikitjangku, palu ukiṟi panya mantanguṟu pakantja wiya alatjiṯu ngaṟaku. Kan wantira ankula ngura tjuṯangka waara tiṯutjara para-pitjalinkuku munun ngura panya kutjungka puṯu nyinaku.” Alatji Mayatja Godalu Kainta wangkangu. ");
INSERT INTO pjt_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Ka wati panya paluṟu wangkangu, “Wiya, nyangatja wituwitu mulapa. Nyuntu alatjingannyangkaṉa ngayulu puṯu wanka nyinaku. ");
INSERT INTO pjt_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Panya nyuntu kuwari ngayunya ngayuku mantanguṟu paiṟa iyaṉi, kaṉa manta piṟuku tjawaṟa puṯu waṟkarinyi. Nyuntuṉin ngayunya mauṉṯananyi nyuntula miṟangka nyinanytja wiyaku, kaṉa kumpilpa tiṯutjara nyinaku. Palulanguṟuṉa ngura wiya waara para-pitjaliṟa nyinaku ngura kutjupangka kutjupangka, kaṉiya aṉangu kutjupa tjuṯangku tjinguṟu nyakula pungkuku.” ");
INSERT INTO pjt_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Palu Godalu Kainta wangkangu, “Wiya kulila! Aṉangu kutjupangku nyuntunya pungkunyangkampaṉa ngayulu tjananya ngapartji pungkuku walytja palumpa 7 kuḻu.” Munu alatji wangkanytjatjanungku paluṟu Kainta aṉangungka walka tjunu kutjupangku palunya nyakula ngurkantaṟa pungkuwiyangku wantinytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Palulanguṟu Kainnga pula kuriṟara Mayatja Godanya wantikatira anu ngura Edenta kakaraṟa, munu pula ngura ini “Para-pitjalinkunytjala” ngura tjunkula nyinangi. ");
INSERT INTO pjt_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Ka ngula Kainnga pula palumpa kuri tjungu nyinara katjatjararingu munu pula palunya ininu Iinakanya. Ka nyara palula aṟa Kaintu ngura tawunu palyaningi waḻi tjuṯatjara munu ngura palunya ininu Iinakanya palumpa katjanguṟu. ");
INSERT INTO pjt_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Ka ngula Iinakalu katja utinu ini Iṟatanya, ka palulanguṟu Iṟatalu katja utinu ini Maiyutjailnga ka Maiyutjailtu utinu katja ini Mitjutjailnga, ka paluṟu katja ini Lamikanya utinu. ");
INSERT INTO pjt_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Ka Lamikalu kuri kutjara aḻṯingu ini Atanya pulanya Tjilanya. ");
INSERT INTO pjt_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ka Atalu katja kutjara kanyinu ini Tjapalnga pulanya Tjupalnga. Ka Tjapaltu ngula puḻkaringkula kuka ngultju tjuṯa kanyiningi munu tiintatjara para-nyinaṟinangi. Ka Tjapalkunu tjuṯangku maḻatja maḻatjangku panya palu puṟunytjuṯu kuka tjuṯa kanyilpai munu tiinta wiltjaṟa nyinapai, tjamu panya Tjapalnga puṟunypa. ");
INSERT INTO pjt_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Ka palumpa maḻanypangku Tjupaltu ngula puḻkaringkula inma mayu wiṟu wangkatjingaṟa kuliningi puṉu aḻatjara puuṟa munu puṉu kita puṟunypa wangkatjingaṟa. Ka Tjupalkunu tjuṯangku maḻatja maḻatjangkuṯu palu puṟunytjuṯu puṉu aḻatjara puuṟa, puṉu kita puṟunypa wangkatjingaṟa inma mayu kulilpai, tjamu puṟunytju. ");
INSERT INTO pjt_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Ka Lamikaku kuri kutjupangku Tjilalu katja kanyinu ini Tupal-Kainnga munu uṉṯalpa kuḻu kanyinu ini Naimanya. Ka kuṯangku ngula puḻkaringkula ayananguṟu palyaningi aḻkaṟa, tjuḻa, tjitjula, munu kutjupa kutjupa tjuṯa kuḻu. ");
INSERT INTO pjt_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Ka tjiṉṯu kutjupangka wati panya Lamikalu palumpa kuri kutjarangka wangkangu, “Ata munu Tjila, kulilaṉi pula! Ngayulu wati yangupala pungkula iluntanu ngayunya pungkunyangka. ");
INSERT INTO pjt_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Ka panya Godalu wangkangu Kainku ngalkilarira aṉangu 7 iluntankunytjikitjangku. Munu palu puṟunypaṯu kutjupangku ngayunya pungkunyangkampa paluṟu aṉangu tjuṯa mulapalta nampa 77 iluntankuku ngayuku ngalkilarira.” Alatji Lamikalu wangkangu kuri kutjarangka. ");
INSERT INTO pjt_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Ka Adamanya pula piṟuku katjatjararingu. Ka Eve-alu wangkangu, “Nyangatjaṉi Godalu katja kutjupa ungu Abelku aṟangka nyinanytjaku, panya Kaintu Abelnga pungkula iluntanu. Palulanguṟuṉa katja nyangatja inini Tjiitjinya.” ");
INSERT INTO pjt_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Ka Tjiitjinya puḻkaringu munu ngula kuri aḻṯira pula katjatjararingu munu palunya ininu Inatjanya. Kaya nyanga palula aṟangka aṉangu tjuṯangku Mayatja Godanya wangkara waḻkuningi. ");
INSERT INTO pjt_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","2","Ka nyangatja Adamaku walytjapiti ma-tjuṯaringkunytja maḻatja maḻatja. (Panya Godalu aṉangu palyaṉu paluṟunku puṟunypa alatjiṯu. Ka paluṟu pula nyiṯayira kungka. Ka pulanya palyantjatjanungku pukuḻmanu munu pulanya ininu “aṉangu”.) ");
INSERT INTO pjt_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","4","Ka Adamanya yiya tjuṯa 130 nyinanytjatjanu piṟuku katjatjararingu, ka katja nyanga paluṟu mama puṟunypa alatjiṯu, ka palunya ininu Tjiitjinya. Munu nyara palula maḻangka Adamanya piṟuku yiya tjuṯa mulapa nyinangi nampa 800 munu tjitji kutjupa tjuṯatjararingangi. ");
INSERT INTO pjt_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Munu paluṟu tjiḻpi mulararira kutju ilungu yiya 930 nyinanytjatjanu rawa mulapa. ");
INSERT INTO pjt_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","8","Ka Tjiitjinya puḻkaringkula yiya tjuṯaṯu nyinangi, munu 105 nyinanytjatjanu katjatjararingu munu katja palunya ininu Inatjanya. Munu palula maḻangka paluṟu piṟuku yiya tjuṯa mulapa nyinangi nampa 807 munu tjitji kutjupa tjuṯatjararingangi. Munu ngula mulapalta ilungu yiya 912 nyinanytjatjanu rawa mulapa. ");
INSERT INTO pjt_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","11","Ka wati panya Inatjanya yiya 90 nyinanytjatjanu katjatjararingu munu palunya ininu Kinannga. Munu paluṟu piṟuku yiya tjuṯa mulapa nyinangi nampa 815 munu tjitji kutjupa tjuṯatjararingangi. Munu paluṟu ngula mulapalta ilungu yiya 905 nyinanytjatjanu rawa mulapa. ");
INSERT INTO pjt_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","14","Ka wati panya Kinannga yiya 70 nyinanytjatjanu katjatjararingu munu palunya ininu Maalalilnga. Munu nyara palula maḻangka paluṟu yiya tjuṯa mulapaṯu nyinangi nampa 840 munu tjitji kutjupa tjuṯatjararingangi. Munu paluṟu ngula mulapalta ilungu yiya 910 nyinanytjatjanu rawa mulapa. ");
INSERT INTO pjt_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","17","Ka wati Maalalilnga yiya nampa 65 nyinanytjatjanu katjatjararingu munu palunya ininu Tjaṟitanya. Munu palula maḻangka piṟuku yiya tjuṯa mulapa nyinangi nampa 830 munu tjitji kutjupa tjuṯatjararingangi. Munu paluṟu ngula mulapalta ilungu yiya 895 nyinanytjatjanu rawa mulapa. ");
INSERT INTO pjt_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","20","Ka Tjaṟitanya yiya tjuṯaṯu nyinangi munu 162 nyinanytjatjanu katjatjararingu munu palunya ininu Inakanya. Munu palula maḻangka paluṟu piṟuku yiya tjuṯa mulapa nyinangi nampa 800 munu tjitji kutjupa tjuṯatjararingangi. Munu palulanguṟu tjiḻpi mulararira ilungu yiya tjuṯa mulapa nyinanytjatjanu nampa 962. ");
INSERT INTO pjt_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","22","Ka wati panya Inakanya yiya 65 nyinanytjatjanu katjatjararingu munu palunya ininu Mitjutjilanya. Munu palula maḻangka Inakanya pula Godanya maḻpaṟara nyinangi yiya tjuṯa mulapa nampa 300, munu paluṟu tjitji kutjupa tjuṯatjararingangi. ");
INSERT INTO pjt_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","24","Paluṟu panya Godaku maḻpa tiṯutjara nyinangi palula tjungu, munu yiya nampa 365 nyinanytjatjanu paluṟu ilunytja wiya arkayiringu, panya Godalu palunya kultukaṯangku wanka mantjinu ngarira ilunytja wiyaṯu. ");
INSERT INTO pjt_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","27","Ka wati panya Mitjutjilanya yiya nampa 187 nyinanytjatjanu katjatjararingu munu katja palunya ininu Lamikanya. Munu palula maḻangka piṟuku yiya tjuṯa mulapa nyinangi nampa 782, munu tjitji kutjupa tjuṯatjararingangi. Munu paluṟu rawa mulapa nyinara ngula mulapa ilungu yiya nampa 969 nyinanytjatjanu. ");
INSERT INTO pjt_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","29","Ka wati panya Lamikanya yiya nampa 182 nyinanytjatjanu katjatjararingu munu palunya ininu Noah-nya munu wangkangu, “Mayatja Godalu panya manta kuraṉu, kala palulanguṟu maikitja puḻkaṟa mulapa waṟkarira pakuringkupai. Palu tjitji nyanga Noah-lu puḻkaringkula ngalinya pakuringkunyangka paku wiyalku pukuḻpa nyinanytjaku.” Alatji paluṟu wangkara ininu Noah-nya. ");
INSERT INTO pjt_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","31","Munu tjitji palunya mantjintjatjanu maḻangka Lamikanya piṟuku yiya tjuṯa mulapa nyinangi munu tjitji kutjupa tjuṯatjararingangi. Munu paluṟu ngula mulapalta ilungu yiya tjuṯa mulapa nyinanytjatjanu nampa 777. ");
INSERT INTO pjt_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Ka wati Noah-nya yiya tjuṯa mulapalta nyinangi nampa 500 munu palulanguṟu katjatjararingu munu palunya ininu Tjimanya. Munu palulanguṟu katja kutjupa kanyinu ini Aamanya munu piṟuku kutjupa kanyinu ini Tjaipitjanya. ");
INSERT INTO pjt_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","2","Kaya tjitji tjuṯatjararingkula aṉangu winki mulararingu munuya manta winkingka ma-nyinara waṉaningi. Kaya nyara palula aṟangka ilkaṟitja tjuṯangku aṉangu tjuṯaku uṉṯalpa tjuṯa nyangangi, munuya yunpa wiṟuku nyakula puḻkaṟa mukuringangi palunya tjananya aḻṯinytjikitja, munuya kuṉṯa wiyangku aḻṯingi tjana mukuringkula. ");
INSERT INTO pjt_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Ka Mayatja Godalu nyangatja nyakula tjituṟu-tjituṟuringu munu alatji wangkangu, “Nyanga palulanguṟuya aṉangu tjuṯa kuwari ngayuku kuruntjara tiṯutjara nyinanytja wiyaringkuku, panya paluṟu tjana iltjanpatjara kutju mantangka nyinapai unytju. Palulanguṟuya aṉangu tjuṯa kuwari iṯinguṟu puḻkaringkula yiya 120 kutju nyinanytjatjanu wiyaringkuku, ngaṉmanyitja tjuṯa puṟunypa rawa mulapa nyinanytja wiya.” ");
INSERT INTO pjt_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Ka nyara palula aṟangka munu maḻangka kuḻu aṉangu puḻka tjuṯa nyinangi ini Nipilima, panya ilkaṟitja tjuṯaya aṉanguku uṉṯalpa tjuṯangka tjunguringangi, kaya tjanampa tjitji tjuṯa kanyiningi ini Nipilima tjuṯa. Kaya aṉangu tjuṯangku kuwari wati Nipilima tjuṯa kulilpai iriti nyinanytja, munuya tjananya mirawaṉipai wati mirpaṉtju puḻka tjuṯa, kutjupa uwankarangka waintarinytja. ");
INSERT INTO pjt_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","6","Ka Godalu aṉangu tjuṯa puḻkaṟa kuraringkunyangka nyangangi, panya paluṟu tjana tiṯutjarangku kura kutju kulilpai palyanyku nyinanytjikitjangku kulilwiyangku. Ka Godanya puḻkaṟa tjituṟu-tjituṟuringu puṯu palya nyakula munu kulinu, “Nyaakuṉa panyatja aṉangu nyanganpa palyaṟa tjunu mantangka?” ");
INSERT INTO pjt_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Munu palulanguṟu wangkangu, “Aṉangu nyanga ngayulu palyantja uwankaraṉa kuwari iluntaṟa wiyalku, kuka tjuṯa, mantangka para-ngaṟapai tjuṯa, tjuḻpu tjuṯa kuḻu uwankara mulapa. Panya ngayulu palyantjatjanu kuwari puḻkaṟa tjituṟu-tjituṟuringu. Utiṉa panyatja tjananya palyantja wiyangku wantima.” Alatji Mayatja Godalu tjituṟu-tjituṟurira wangkangu. ");
INSERT INTO pjt_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Palu wati kutjuku Mayatjanya nyakula pukuḻaringu tjukaṟuru nyinanyangka, wati panya ini Noah-ku. ");
INSERT INTO pjt_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Ka nyangatja tjukurpa panya Noah-nyatjara. Panya paluṟu kutju wati tjukaṟuru nyinapai, palya mulapa, ka aṉangu tjuṯangku palunya kura puṯu ngurkantanangi. Panya paluṟu Godala wangaṉarangku kulilpai palumpa maḻpa mulapa. ");
INSERT INTO pjt_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Munu paluṟu katja maṉkurtjararingu ini nyanganpa Tjimanya, Aamanya munu Tjaipitjanya. ");
INSERT INTO pjt_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Palu Godalu aṉangu kutjupa uwankara nyangangi kura mulapa nyinanyangka, kaya manta winkingka aṉangu tjuṯangku pikangku pungkula waṉingi mirpaṉṯu alatjiṯu ngaḻṯuringkunytja wiyangku. ");
INSERT INTO pjt_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Ka Godalu ngura uwankarangka nyangangi kura puḻka ngaṟanyangka, panya aṉangu uwankara kura mulararingu. ");
INSERT INTO pjt_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Palulanguṟu Godalu Noah-la wangkangu alatji, “Ngayulu aṉangu uwankara wiyantjikitjangku kulini, mantatja uwankara kuḻu, panya tjana kura puḻka mulararingu manta winkingka. Ka palulanguṟuṉa tjananya uwankara alatjiṯu wiyalku. ");
INSERT INTO pjt_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Ka nyuntu pauta puḻka palyala puṉu palyanguṟu, munu pauta uṟilitja munu unngutja kuḻu kiṯitjuṟa aḻa tjuṯa patila aḻawanu uṟu tjarpanytjaku-tawara. Munu pauta unngu ruuma tjuṯa palyala tjuṯa nyinanytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Pauta palunya palyala puḻka mulapa nyanga alatji, waṟa puḻka palyala nampa nyangatja 133 metre, munu kultunguṟu mitjuṟamilaṟa palyala nampa nyangatja 22 metre, munu mantanguṟu mitjuṟamilaṟa palyala katukutu nampa nyangatja 13 metre. ");
INSERT INTO pjt_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Munu minangka-tawara pauta katu kuḻu palyala, palu katu palyaṟa tjura tjukutjuku kantilytja katu panya katutjangka kantilytja nguṟurpa aḻa tjukutjuku para-ngaṟala waṉantjaku. Munu pauta unngu palyala ruuma katulkira katulkira maṉkurpa ngaṟanytjaku, munu pauta kultungka tuwa kutju palyala tjarpanytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Kaṉa ngayulu mina puḻka mulapa iyalku mantakutu uṟu puḻkaringkula katuringkula mulapa tjiwariwari ngarira aṉangu uwankara kuka kuḻu uṟungku tjutuṟa wiyantjaku. Kaya mantangka para-ngaṟapai uwankara iluku, kuka tjuṯa, kuka wiya tjuṯa, tjuḻpu tjuṯa, aṉangu tjuṯa, uwankara mulapaya wanka nyinanytjatjanu uṟu tjikiṟa ngakaṟa iluku. ");
INSERT INTO pjt_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Palu nyuranya ngayulu kalkuṉi wankaṟu kanyintjikitjangku. Ka nyupali kuriṟara munu nyupalimpa katja maṉkurpa munu tjanampa kuri maṉkurpa kuḻu, paluṟu nyura pautangka tjarpara wankaringkuku. ");
INSERT INTO pjt_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Munu nyuntu kuka tjuṯa, kuka wiya tjuṯa kuḻu ini kutjupa kutjupa uwankaranguṟu kutjara mantjiṟa pauta unngu tjarpatjura kuriṟara kuriṟara, munu tjuḻpu ini kutjupa kutjupa uwankaranguṟu, tjuninguṟu ankupai ini kutjupa kutjupa uwankaranguṟu kuḻu kutjara kuriṟara kuriṟara tjarpatjura pauta unngu tjana kuḻu wankaringkunytjaku. Panya paluṟu tjana uwankara nyuntulakutu kuriṟara kuriṟara pitjaku nyuntu tjarpatjuṟa wankaṟu kanyintjaku. ");
INSERT INTO pjt_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Munu mai puḻka mulapa tjiṉṯu tjuṯaku mantjiṟa pautangka tjarpatjura mai kutjupa kutjupa tjuṯa kuka tjuṯaku, kuka wiya tjuṯaku, tjuḻpu tjuṯaku munu nyurampa kuḻu.” ");
INSERT INTO pjt_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Ka Noah-lu wangaṉarangku kulinu munu Godalu wangkanytja uwankara palyaṉu. ");
INSERT INTO pjt_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Ka pauta panya palyaṟa wiyaringkunyangka Mayatja Godalu Noah-la wangkangu, “Pauta unnguya tjarpa nyupali kuriṟara munu nyupalimpa katja maṉkurpa munu tjanampa kuri maṉkurpa kuḻu. Panya ngayulu nyuntunya kutju nyangu tjukaṟuru palyanyku nyinanyangka, panya aṉangu kutjupa uwankaraya kura kutju palyalpai nyinanyi. ");
INSERT INTO pjt_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Ka panya kuka kutjupa kutjupa tjuṯa ngaṟanyi nyura pungkula waṟungka tiliwakaṟa Godanya ungkula waḻkuntjaku. Kuka panya palula tjanalanguṟu tjara mantjiṟa pautangka tjarpatjura 7 kutjupa, 7 kutjupa kuriṟara kuriṟara. Palu kuka kutjupa tjuṯanguṟu kutjara kutju kuriṟara mantjiṟa tjarpatjura kutjara kutjupa, kutjara kutjupa. ");
INSERT INTO pjt_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Munu tjuḻpu kutjupa kutjupa uwankaranguṟu kuḻu mantjiṟa tjarpatjura 7 kutjupa, 7 kutjupa. Alatji kuka, tjuḻpu, mantangka para-ngaṟapai uwankaranguṟu tjara mantjiṟa tjarpatjura paluṟu tjana wankaringkula uṟungka maḻangka pautanguṟu ukalingkula piṟuku mantangka nyinara ma-tjuṯaringkunytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Uwa, kuwari nyanga tjiṉṯu 7 ngaṟala wiyaringkunyangkaṉa ngayulu mina puḻka iyalku mantakutu, ka mina paluṟu kaḻaḻa mungangka rawangku puyilku piṟa kutjara nguwanpa, ka manta winkingka uṟu puḻkaringkuku munu ngayulu palyaṟa tjunkunytja uwankara wiyalku, aṉangu tjuṯa, kuka tjuṯa, tjuḻpu tjuṯa kuḻu, mantangka para-ngaṟapai uwankara.” Alatji Godalu wangkangu. ");
INSERT INTO pjt_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ka Noah-lu wangaṉarangku kulinu munu Godalu wangkanytja uwankara palyaṉu. ");
INSERT INTO pjt_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Ka uṟu puḻka mantangka wirkankunytja aṟangka Noah-nya wati irititja mulapa nyinangi yiya nampa 600. ");
INSERT INTO pjt_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Munu paluṟu pula kuriṟara pautangka tjarpangu uṟunguṟu wankaringkunytjikitja, ka pulampa katja maṉkurpa munu tjanampa kuri maṉkurpa kuḻu tjarpanguṯu. ");
INSERT INTO pjt_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Ka Godalu mantangka para-ngaṟapai uwankaranguṟu nyiṯayira kungka ngurkantanu munu Noah-lakutu ngalya-katingu, kuka tjuṯa, tjuḻpu tjuṯa, kutjupa kutjupa tjuṯa kuḻu. Ka Noah-lu tjananya uwankara pautangka tjarpatjunu Godalu wangkanytjitjangka. ");
INSERT INTO pjt_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Ka uwankara tjarpara wiyaringu, ka palulanguṟu tjiṉṯu 7 ngaṟala wiyaringkunyangka uṟu puḻka mulatu manta tjutuṉu. ");
INSERT INTO pjt_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","12","Uwa, Noah-nya yiya panya 600 nyinanyangka maḻangka piṟa kutju ngaṟala wiyaringkula piṟa kutjupalta piṟuku ma-pakaṉu kutjararinytjikitja, ka nyara palula-aṟangka mina puḻka mulatu manta winki apu murpu tjuṯa kuḻu tjutuṉu. Panya uṟungka unngu manta unngunguṟu mina kutjupa puḻka mulapa ngalya-pakaṉu, ka uṟungku panya ma-puḻkaringkula ma-lipiringkula mantalta tjutuṉu. Ka panya ilkaṟinguṟu mina puḻka mulapa punkaṟa tjunguringangi uṟu panya mantatjangka munu kaḻaḻa mungangka kuḻu rawangku puyiningi piṟa kutjara nguwanpa. ");
INSERT INTO pjt_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","16","Ka panya palula kuwaripangka Godalu wangkanyangka Noah-lu mantangka para-ngaṟapai kutjupa kutjupa uwankaranguṟu kuriṟara kuriṟara mantjiṟa pautangka tjarpatjunu, kuka kutjupa kutjupa tjuṯa munu kuka wiya tjuṯa kuḻu, ngultju tjuṯa munu inuṟa tjuṯa, tjuḻpu kutjupa kutjupa tjuṯa munu tjuninguṟu ankupai kutjupa kutjupa tjuṯa kuḻu Noah-lu tjarpatjunu. Munu palulanguṟu paluṟu pula kuḻu kuriṟara pauta unngu tjarpangu, ka pulampa katja maṉkurpa Tjimanya, Aamanya, Tjaipitjinya tjana kuḻu tjarpangu kuriṟara kuriṟara. Ka tjana uwankara tjarpara wiyaringkunyangka Godalu tuwa patinu. ");
INSERT INTO pjt_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","18","Ka panya minangku rawangku puyiningi kaḻaḻa mungangka piṟa kutjara nguwanpa, ka uṟu mantangka puḻkaringkula katuringangi, munu ngaṯi puḻka mulapalta ngaringi tjiwariwari. Ka pauta panya palunya uṟungku katuningi, ka uṟungka katu nyinangi. ");
INSERT INTO pjt_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Ka uṟungku panya piṟuku katuringkula tjaalyngaṟala puḻi murpu waṟa tjuṯa uwankara tjutuṟa patinu munu uṟu kutju ngaringi tjiwariwari manta winkingka. ");
INSERT INTO pjt_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Munu uṟu paluṟu piṟukuṯu katuringkula katu mulapa ngaringi puḻi murpungka waintaṟa nampa panya 7 metre. ");
INSERT INTO pjt_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Ka uwankara mulapa mantangka wanka para-ngaṟanytja tjuṯa ilungu uṟu tjikiṟa, tjuḻpu tjuṯa, kuka tjuṯa, kuka wiya tjuṯa, tjuninguṟu ankupai tjuṯa, uwankara mulapa wiyaringu aṉangu uwankara kuḻu. ");
INSERT INTO pjt_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","23","Uwankara panya mulyanguṟu tjaanguṟu ngaalymankupai ilungu uṟu unngu. Mantangka wanka para-ngaṟapai uwankara mulapa wiyaringu Godalu uṟungka wiyannyangka, aṉangu tjuṯa, kuka tjuṯa, kuka wiya tjuṯa, tjuninguṟu ankupai tjuṯa, tjuḻpu tjuṯa kuḻu uwankara paluṟu wiyaṉu. Ka Noah-nya tjana pauta panya unngu nyinanytja tjuṯa kutju wankaringu. ");
INSERT INTO pjt_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Ka uṟu panya puḻkangku manta tjutuṟa ngaringi rawa alatjiṯu tjiṉṯu nyanga alatjiṯu 150, panya piṟa panya maṉkur-kutjara. ");
INSERT INTO pjt_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Ka Godalu Noah-nya tjananya kuka tjuṯa, kuka wiya tjuṯa, tjuḻpu tjuṯa kuḻu watarkurinytja wiyangku kuliningi alatjiṯu pautangka panya nyinanyangka, munu waḻpa iyaṉu manta winkikutu uṟu panya rungkaṟa tjaṟuntjaku, ka mulapaṯu uṟu panya katu ngaṟanytjatjanu ma-tjaṟuringangi. ");
INSERT INTO pjt_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Ka uṟu unngu mulapa manta unngunguṟu panya mina puḻka piṟuku ngalya-pakantja wiyaringu Godalu angatjunkunyangka. Munu mina panya ilkaṟitja Godalu markuṉu, ka piṟuku puyintja wiyaringu. ");
INSERT INTO pjt_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Ka uṟu panya puḻka purkaṟa purkaṟa tjaṟuringangi rawa mulapa piṟa maṉkur-kutjara. ");
INSERT INTO pjt_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ka nyara palula aṟangka uṟu tjaṟuringkunyangka pauta panya nyinakatingu puḻi katu ngura ini Aṟaṟatala. ");
INSERT INTO pjt_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Ka uṟu panya piṟuku purkaṟa tjaṟuringangi piṟa maṉkurpa, ka nyara palulanguṟu puḻi murpu tjuṯalta utiringu. ");
INSERT INTO pjt_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","7","Ka nyara palula maḻangka tjiṉṯu 40 piṟuku ngaṟala wiyaringkunyangka Noah-lu pauta unngunguṟu winta tjukutjuku aḻaṉu munu tjuḻpu kaaṉka iyaṉu, ka paluṟu uṟungka katu rawa para-ngaṟangi uṟu panya ma-tjaṟuringkula wiyaringkunytjaku paṯaṟa paṯaṟa. ");
INSERT INTO pjt_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Munu Noah-lu piṟuku iyaṉu tjuḻpu kutjupa ini kuukuuku ankula nguriṟa nyakunytjaku manta utiringkunyangka. ");
INSERT INTO pjt_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Palu uṟu tjiwariwariṯu ngaringi kuwaripa, ka kuukuuku panya mantangka nyinakatinytjikitja puṯu nguriṟa maḻaku wirkanu Noah-lakutu. Ka Noah-lu maṟa katuringkula palunya mantjiṟa ngalya-tjarpatjunu maḻakungku pautangka. ");
INSERT INTO pjt_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Munu Noah-lu tjiṉṯu 7 ngaṟala wiyaringkunyangka paṯaṟa kuukuuku panya palunya piṟuku iyaṉu. ");
INSERT INTO pjt_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ka kuukuuku paluṟu ankula mungartji maḻaku pitjangu puṉu alipa nyaḻpi tjaangka kanyiṟa, puṉu wanka, panya tjuḻpu paluṟu kuwari kutju kaṯantaṟa ngalya-katingu. Ka Noah-lu nyaḻpi nyakula kulinu, “Munta-uwa! Uṟu panya tjinguṟu tjaṟuringu, ka manta utiringu.” ");
INSERT INTO pjt_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Munu paluṟu piṟuku tjiṉṯu 7 kutjupa ngaṟala wiyaringkunyangka paṯaṟa kuukuuku palunya piṟuku iyaṉu, ka paluṟu ankula ma-nyinangi maḻaku pitjawiya. ");
INSERT INTO pjt_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Uwa, Noah-nya tjana piṟa 10 nguwanpa pauta unngu nyinangi, ka tjiḻpi panya Noah-nya yiya nampa 601-aringu. Ka uṟu uwankara mantangka tjaṟuringkula wiyaringu. Ka Noah-lu pauta katutja araṉu munu para-nyakula nyangu manta ma-piḻṯiringkula waṉannyangka. ");
INSERT INTO pjt_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Munu paluṟu piṟuku pauta unngu nyinangi manta piḻṯi mulararinytjaku paṯaṟa. Ka nyara palulanguṟu piṟa kutjara ngaṟala wiyaringkunyangka manta uwankara piḻṯiringu alatjiṯu. ");
INSERT INTO pjt_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","16","Ka Godalu Noah-la wangkangu, “Pautanguṟu palaya ukaliwa nyupali kuriṟara munu nyupalimpa katja maṉkurpa munu tjanampa kuri kuḻu. ");
INSERT INTO pjt_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Munu kuka tjuṯa, kuka wiya tjuṯa, tjuḻpu tjuṯa kuḻu uwankara pautanguṟu walatjura tjana waṟarakatira mantangka nyinara tjuṯatjararingkunytjaku munu tjuṯaringkula ngura winkikutu lipiringkula nyinanytjaku manta winkingka.” ");
INSERT INTO pjt_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Ka Noah-nya kuliṟa pautanguṟu ukalingu palumpa kuri kuḻu munu katja maṉkurpa kuriṟara kuriṟara. ");
INSERT INTO pjt_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Ka kuka tjuṯa, kuka wiya tjuṯa, tjuḻpu tjuṯa kuḻu, mantangka para-ngaṟapai uwankara pautanguṟu ukalingu walytjaṟara walytjaṟara. ");
INSERT INTO pjt_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Ka Noah-lu pautanguṟu ukalingkula mantangka pitjilpa puḻka palyaṉu, munu paluṟu kuka palyanguṟu maṉkurpa mantjinu tjinatjara maṉkurpa munu tjuḻpu maṉkurpa kuḻu munu kuka palunya tjananya pungkula pitjilta katu waṟungka tiliwakaṉu Mayatja Godanya waḻkuṟa ungkunytjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Ka Godalu kuka tiliwakannyangka mayu wiṟu paṉṯinu munu pukuḻarira unngu kuliningi alatji, “Ngayulu panya aṉangu tjuṯanguṟu manta nyanga kuraṉu uṟu puḻka iyaṟa, palu kuwariṉa tjanalanguṟu manta piṟuku kurantja wiyangku wantiku alatjiṯu, panya tjaka aṉangu tjuṯangku tjitjinguṟu rawangku kura kutju kulilpai. Palu ngayulu aṉangu tjuṯa, kuka tjuṯa, ngaalymankupai uwankara piṟuku wiyantja wiyangku wantiku alatjiṯu, nyanga kuwaritja puṟunypa piṟuku palyantja wiya alatjiṯu. ");
INSERT INTO pjt_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Ka manta nyangatja ngaṟanyangkampa wari munu unytjunpa, kuḻi munu nyiṉnga, kaḻaḻa munu munga tiṯutjaraṯu ngaṟakatiku wiyaringkunytja wiya alatjiṯu. Ka piriyakutu kutjupa piriyakutu kutjupa manta tjawaṟa uṉinypa tjuṯa tjunkunytjaku tiṯutjara ngaṟaku, munu palulanguṟu kuḻi kutjupa kuḻi kutjupa mai pakaṟa kuṟuringkunyangka urantjaku tiṯutjara palu puṟunypaṯu ngaṟakatiku.” Alatji Godalu kalkuṟa wantingu tiṯutjara ngaṟanytjaku kutjuparinytja wiya paluṟuṯu. ");
INSERT INTO pjt_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Munu Godalu Noah-nya tjananya palumpa katja maṉkurpa pukuḻmanu wangkara, “Tjitji tjuṯatjarariwaya, kaya nyurampa tjitjinguṟu aṉangu tjuṯa piṟuku ma-tjuṯaringkuku maḻatja maḻatja, munuya ngura tjuṯangka ma-lipiringkula nyinaku manta winkingka. ");
INSERT INTO pjt_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Kaya mantangka para-ngaṟapai uwankara nyurampa nguḻuringkuku aṉangu tjuṯaku kuka tjuṯa, kuka wiya tjuṯa, tjuninguṟu ankupai tjuṯa, tjuḻpu tjuṯa, antipina tjuṯa kuḻu. Ngayuluṉa nyara palunya tjananya nyuranya unganyi nyura pungkunytjaku, munta tjinguṟu paintjaku, munta tjinguṟu kanyintjaku, munta tjinguṟu nintintjaku. Ka nyura tjanampa uwankaraku mayatja nyinaku. ");
INSERT INTO pjt_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Ngaṉmanytjuṉa aṉangu tjuṯa mai kutju ungangi ngalkuntjaku, palu nyanga palulanguṟuṉa nyuranya kuka kuḻu unganyi ngalkuntjaku maingka tjungu. Ka kuwari kuka nyanga paluṟu tjana uwankara ngaṟanyi nyura pungkula ngalkuntjaku. ");
INSERT INTO pjt_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Palu kulila! Kuka pungkula nyura milkaḻi winki ngalkuwiyangku wantima. Alatjiṉa milkaḻingka-tawara angapaini, panya milkaḻingku wankaṟu kanyilpai pulykungka ankula. Pala palulanguṟu milkaḻi miḻmiḻpa ngaṟanyi ngalkuntjaku wiya. ");
INSERT INTO pjt_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ka tjukurpa puḻka nyangatja ngaṟanyi, panya aṉangu tjuṯa uti aṉangu kutjupa tjuṯaku pukuḻarima tjananya mirpaṉṯu pungkula iluntankunytja wiya. Tjinguṟu aṉangu kutjungku aṉangu kutjupa miri pungkunyangkampaṉa ngayulu palunya ngapartji pungkuku. Munu palu puṟunytju kuka inuṟangku aṉangu patjaṟa iluntankunyangkampa ngayulu kuka palunya ngapartji pungkuku. ");
INSERT INTO pjt_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Panya ngayulu aṉangu palyaṉu ngayunya puṟunypa nyinanytjaku. Palulanguṟu nyura uti aṉangu kutjupa tjuṯaku pukuḻarima tjananya mirpaṉṯu pungkula iluntankunytja wiya. Palu tjinguṟu nyura aṉangu kutjupa mirpaṉṯu miri pungkunyangkampa, aṉangu kutjupangku nyuntunya ngapartji miri pungkukuṯu. ");
INSERT INTO pjt_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Ka nyura uti kuwari tjitji tjuṯatjararingama aṉangu tjuṯa piṟuku ma-tjuṯaringkunytjaku. Munu nyura tjuṯa mulararira mungilyirima munu ngura tjuṯakutu lipiringkula manta winkingka nyinama tjuṯa mulapa.” Alatji Godalu Noah-la tjanala wangkangu. ");
INSERT INTO pjt_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","10","Munu palulanguṟu piṟuku tjanala wangkangu nyanga alatji, “Kuwariṉa nyuranya kalkuṉi, nyurampa walytja tjuṯa kuḻu maḻatja maḻatja. Munu ngayulu mantangka para-ngaṟapai uwankara kuḻu kalkuṉi, kuka tjuṯa, kuka wiya tjuṯa, tjuḻpu tjuṯa uwankara panya nyurala tjungu pautanguṟu ukalingkunytja tjuṯa. ");
INSERT INTO pjt_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Nyanga alatjiṉa nyuranya munu tjananya kuḻu kalkuṉi panya uṟu puḻkangku manta winki piṟuku tjutuṟa kurantja wiyaringkuku. Manta nyanga winkingka ngaalymankupai uwankara uṟu puḻka nyanga puṟunytju piṟuku tjutuṟa iluntankuwiyangku wantiku. ");
INSERT INTO pjt_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Munu ngayulu kutjupa kutjupa katu tjunkuku nyura nyakula kulintjaku ngayulu kalkuntja, panya ngayulu nyuranya munu mantangka para-ngaṟapai uwankara kuḻu kalkuṉi, nyurampa walytja tjuṯa kuḻu maḻatja maḻatja. ");
INSERT INTO pjt_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Ngayulu ngangkaḻingka tjuṯiṟangu tjunkuku nyura nyakula kulintjaku ngayulu panya kalkuntja. ");
INSERT INTO pjt_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","15","Ka palulanguṟu kutjupa-aṟa ilkaṟi ngangkaḻingku tjutunnyangka tjuṯiṟangu nguṟurpa utiringkuku, kaṉa ngayulu kalkuntja panyatja kulilku, panya ngayulu mantangka para-ngaṟapai uwankara, aṉangu uwankara kuḻu uṟu puḻkangka piṟuku tjutuṟa wiyalwiyangku wantiku. ");
INSERT INTO pjt_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Ka tjuṯiṟangu ngangkaḻingka utiringkunyangka ngayulu nyakula kalkuntja panyatja kulilku. Panya kalkuntja paluṟu tiṯutjara ngaṟaku wiyaringkunytja wiya alatjiṯu.” ");
INSERT INTO pjt_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Alatji Godalu Noah-la tjanala wangkangu tjuṯiṟangu nyakula kalkuntja panyatja kulintjikitjangku, tjana kuḻu kulintjaku. ");
INSERT INTO pjt_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Uwa, Noah-ku katja maṉkurpaya pautanguṟu ukalingu panya ini nyanganpa Tjimanya, Aamanya munu kutjupa Tjaipitjinya. (Ka Aamanya panya Kainanku mama.) ");
INSERT INTO pjt_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ka wati nyanga maṉkurnguṟu aṉangu tjuṯaringu munuya ngura tjuṯangka ma-lipiringkula kuwari puḻka-aṉangu nyinanyi manta winkingka. Wati nyanga maṉkurpa aṉangu maḻatja maḻatjaku tjamu maṉkurpa, panya aṉangu uwankaraku tjamu maṉkurpa nyanga paluṟu tjana. ");
INSERT INTO pjt_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Ka Noah-nya panya mai pakaltjingalpai nintipuka, munu panya pautanguṟu ukalingkunytjatjanungku paluṟu mai kiṟipitji-waraṟa pakaltjingaṉu kaana puḻkangka. ");
INSERT INTO pjt_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Munu paluṟu kiṟipitjinguṟu waina palyaṉu munu tjikiṟa taṟangkaringu munu mantara aṉangitja araṟa nikiti ngaringi tiinta unngu. ");
INSERT INTO pjt_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ka katja kutjungku Aamalu (panya Kainanku mamangku) palumpa mama nyangu nikiti ngarinyangka, munu tiintanguṟu pakaṟa wangkangu palumpa kuṯa kutjarangka. ");
INSERT INTO pjt_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Ka Tjimalu, Tjaipitjilu pulanku mantara mantjiṟa katuṟa piningka piningka tjunkula nyakuwiyangku tjutukatira tiintangka tjarpara mantarangka tjutuṉu mama panya nikiti ngarinyangka. ");
INSERT INTO pjt_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Ka Noah-nya watarku ngaringi kunkunpa munu ngula kutju wankaringkula kulinu katja maḻatjangku palunya nikiti ngarinyangka nyakula kuranmankunytja. ");
INSERT INTO pjt_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Ka paluṟu tjituṟu-tjituṟurira alatji wangkangu, “Kuwariṉa Godala tjapini Kainanku tjituṟu-tjituṟu puḻka palyantjaku Aamaku panya katjaku! Ka Aamaku kuṯa kutjarangku palunya mayatjarira puḻkaṟa wituwitulku palumpa pulampa waṟkarinytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Wanyula Mayatja Godanya mirawaṉima, Tjimaku panya God! Ka kuwari Tjimalu Kainannga mayatjarira kanyilku munu palunya puḻkaṟa wituwitulku palumpa waṟkarinytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Ka Mayatja God, wanyu Tjaipitjiku tjitji tjuṯaringkunytjaku palyanma, kaya ma-tjuṯaringkula maḻatja maḻatja tjuṯa mulapa nyinama, munuya wati panya Tjimakunu tjuṯangka tjungu nyinaku tjanampa ngurangka. Munu Kainannga tjura Tjaipitjiku puḻkaṟa waṟkarinytjaku, ka palunya paluṟu mayatjarira kanyilku.” ");
INSERT INTO pjt_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Ka uṟu panya puḻka mulapa ngarira wiyaringkunyangka maḻangka Noah-nya piṟuku yiya tjuṯa mulapa nyinangi nampa nyangatja 350. ");
INSERT INTO pjt_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Munu paluṟu tjiḻpi mularariralta ilungu yiya nampa 950 nyinanytjatjanu, rawa mulapa. ");
INSERT INTO pjt_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Ka nyangatja uṟu puḻkangka maḻangka Noah-ku walytjapiti ma-tjuṯaringkunytja palumpa katja maṉkurnguṟu maḻatja maḻatja. Panya Tjimanya, Aamanya, Tjaipitjinya tjana katja tjuṯatjararingu, kaya palula tjanalanguṟu aṉangu ma-tjuṯaringu maḻatja maḻatja. ");
INSERT INTO pjt_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Ka wati panya Tjaipitjilu katja nyanga tjananya utinu Noah-ku pakaḻi tjuṯa ini nyanganpa – Kaumanya, Maikaakanya, Matainya, Tjapannga, Tupulnga, Mitjikanya, Tiṟatjanya tjananya. Ka nyanga palula tjanalanguṟu aṉangu ma-tjuṯaringu. ");
INSERT INTO pjt_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Ka Tjaipitjiku katjangku ini Kaumalu katja maṉkurpa utinu ini nyanganpa – Atji-kinatjanya, Ripatjanya, Taukamanya tjananya maṉkurpa. ");
INSERT INTO pjt_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Ka Tjaipitjiku katjangku ini Tjapantu katja nyanga tjananya utinu ini nyanganpa – Ilaitjanya, Tatjitjanya, Kitimanya, Rautanimanya tjananya. ");
INSERT INTO pjt_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Ka nyanga palula tjanalanguṟu aṉangu ma-tjuṯaringu, aṉangu panya Tjaipitjikunu tjuṯa. Munuya uṟungka itingka nyinara waṉaningi, munuya manta tjukutjukungka kuḻu nyinangi uṟungka nguṟurpa. Paluṟu tjana ngura kutjupa kutjupangka nyinangi mauṉṯalpa mauṉṯalpa munuya wangka walytja walytja wangkangi. ");
INSERT INTO pjt_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ka wati panya Aamalu katja nyanga tjananya utinu Noah-ku pakaḻi tjuṯa ini nyanganpa – Kuutjanya, Itjipanya, Lipiyanya, Kainannga tjananya. ");
INSERT INTO pjt_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Ka Aamaku katja kuranyitjangku Kuutjalu katja ini nyanga tjananya utinu Tjipanya, Apilanya, Tjapatanya, Raamanya, Tjapitikanya tjananya. Ka Raamalu katja kutjara utinu Tjiipanya pulanya Titannga. ");
INSERT INTO pjt_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Ka Kuutjaku pakaḻi kutjupa nyinangi wati ini Nimaṟatanya. Wati nyanga paluṟu kunyu nganyiri puḻka mulapa nyinangi kuwaripatjara. ");
INSERT INTO pjt_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Panya Mayatja Godalu palunya witulyanu kukaputju puḻka mulapa nyinanytjaku, kaya nyara palulanguṟu aṉangu tjuṯangku tjakangku wati kukaputju nyakula wangkapai nyanga alatji, “Nyuntu wati panya Nimaṟatanya puṟunypa kukaputju puḻkanya, panya Godalu nyuntunya Nimaṟatanya puṟunypa witulyananyi.” ");
INSERT INTO pjt_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Ka Nimaṟatanya panya ngaṉmanypa mayatja puḻka nyinangi ngura nyanga maṉkurku ini Papilanku, Iṟikaku, Akataku tjanampa. Ngura nyanga maṉkurpa manta nyara ini Papilaniyala ngaṟangi. ");
INSERT INTO pjt_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","12","Munu manta nyara palulanguṟu Nimaṟatalu manta kutjupakutu ankula tawunu puḻka tjuṯa palyaṉu manta ini Atjiṟiyala. Paluṟu tawunu panya puḻka tjuṯa ini nyanganpa palyaṉu Ninipanya, Rayupatja Iirnga, Kaalanya tjananya, munu tawunu kutjupa ini Ritjinnga kuḻu palyaṉu ngura Ninipala pulala Kaalala nguṟurpa. Ka ngura Kaalanya panya tawunu puḻka mulapa ngaṟangi. ");
INSERT INTO pjt_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","14","Ka wati panya Aamaku katja kutjupangku ini Itjipalu katja nyanga tjananya utinu Luutanya, Anamanya, Layapanya, Napatunya, Patjaṟutjanya, Katjulunya, Kapatunya tjananya. (Ka wati panya Kapatulanguṟu aṉangu ma-tjuṯaringangi ngura panya ini Pilitjiyala, kaya tjananya wangkangi ini nyanga alatji “Pilitjiyanya nguraṟa tjuṯa”.) ");
INSERT INTO pjt_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","19","Ka Aamaku katja Kainantu katja ngaṉmanyitja utinu ini Tjaitannga, munu palulanguṟu katja kutjupa tjuṯa utinu ini nyanganpa – Iitanya, Tjaipunya, Aimurnga, Kirkatjanya, Ipanya, Aakanya, Tjinnga, Apatnga, Tjimarnga, Amatjanya tjananya. Nyanga paluṟu tjana uwankara Kainankunu tjuṯa munuya paluṟu tjana ma-tjuṯaringangi maḻatja maḻatja, munuya walytjaṟara walytjaṟara ankula ngura tjuṯangka nyinangi. Ka manta tjanampa alatji ngaringi Kainankunu tjuṯaku, alinytjaranguṟu ngura ini Tjaitantanguṟu ngalya-ngaringu uḻpaṟirakutu ngura ini Kiṟartakutu ngura ini Kaatjala itingka, munu wiluṟaranguṟu uṟu panya puḻkanguṟu wati-ngaringu kakaraṟakutu ngura ini nyanga tjanalakutu Tjatamalakutu, Kumaralakutu, Atamalakutu, Tjipuwimalakutu palula tjanalakutu tjanampa manta wati-ngaringu manta kutjuṯu tjanampa. Ka ngura Tjipuwimanya panya ngura ini Latjala itingka. ");
INSERT INTO pjt_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Alatjiṯuya walytjaṟara walytjaṟara nyinangi Aamakunu tjuṯa, munuyanku ngura kutjupa kutjupangka nyinara wangka walytja walytja wangkangi. ");
INSERT INTO pjt_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","25","Ka Tjaipitjiku pulampa Aamaku kuṯa Tjimalu palu puṟunypaṯu katja tjuṯa utinu Noah-ku panya pakaḻi tjuṯa ini nyanganpa – Ilamanya, Atjurnga, Apakatanya, Luutanya, Aṟamanya tjana. Kaya nyanga palula tjanalanguṟu aṉangu ma-tjuṯaringangi munuya walytjaṟara walytjaṟara nyinangi. Ka Aṟamalu katja kutjara kutjara utinu Tjimaku pakaḻi tjuṯa ini nyanga tjananya Utjanya, Uulanya, Kitjunya, Mitjikanya tjananya. Kaya wati nyanga palula tjanalanguṟu aṉangu piṟuku ma-tjuṯaringangi munuya walytjaṟara walytjaṟara nyinangi ngura tjuṯangka. Ka Tjimaku katja kutjupangku ini Apakatalu katja nyangatja utinu ini Tjilanya, ka ngula Tjilalu katja utinu ini Iipunya. Ka Iipulu katja kutjara utinu kutju ini Pilikinya, kutjupa ini Tjakitannga. Ka ini panya “Piliki” wangkanyi “tjarantja” tjanampa wangkangku panya wati Pilikinya nyinanytja-aṟa Godalu aṉangu tjuṯa tjaraṉu munu wililytjingaṟa iyaṉu ngura tjuṯakutu manta winkikutu. Uwa, Noah-ku katja Tjimanya wati Iipukunu tjuṯaku kutju-tjamu, panya wati Iipulanguṟu aṉangu tjuṯaringu maḻatja maḻatja. ");
INSERT INTO pjt_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","29","Ka Iipuku katja kutjupangku wati panya Tjakitantu katja tjuṯa utinu ini nyanganpa – Alamu-tatanya, Tjilipanya, Atja-mapitjinya, Tjiṟanya, Atuṟamanya, Utjalnga, Tikilanya, Upalnga, Apimailnga, Tjipanya, Upirnga, Apilanya, Tjaupapanya tjana, tjuṯa mulapa. ");
INSERT INTO pjt_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Kaya nyanga paluṟu tjana ngura tjuṯangka nyinangi, panya ngura ini Mitjalanguṟuya ma-nyinara waṉaningi kakaraṟakutu ngura ini Tjipartakutu ngura puḻitjarangka. ");
INSERT INTO pjt_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Uwa, alatjiṯuya Tjimakunu tjuṯa walytjaṟara walytjaṟara nyinangi, munuyanku ngura kutjupa kutjupangka nyinara wangka walytja walytja wangkangi. ");
INSERT INTO pjt_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Aṉangu nyanga paluṟu tjanaya Noah-ku katja maṉkurnguṟu ma-tjuṯaringu uṟu panya puḻkangka maḻangka, munuya aṉangu winki mulararira manta winkikutu lipiringu maḻatja maḻatja, munuya lipiwanu alatjiṯu nyinangi ngura kutjupa kutjupa tjuṯangka manta winkingka. ");
INSERT INTO pjt_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Ngaṉmanypaya aṉangu uwankara wangka kutju wangkapai nyinangi. ");
INSERT INTO pjt_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Munuya palulanguṟu kakaraṟa para-nyinara para-nyinara ngulalta ngura uṟilpa ukiṟitjarangka wirkaṟa ngura tjunkula nyinangi ngura ini Papilanta. ");
INSERT INTO pjt_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","4","Munuya paluṟu tjana wangkangu, “Wanyula tawunu puḻka palyala nganaṉa tjungu nyinanytjikitjangku uṯuḻu kutju, aḻa lipikutu ankula wililyarantjaku-tawara. Munula wanyu nguṟurpa palyala waḻi waṟa mulapa ilkaṟikutu. Kaya ngula maḻatja tjuṯangku waḻi nyanganpa nyakula urulyaraṟa kulilku munulanya mirawaṉiku alatji wangkara, ‘Munta-uwa, Tjamulu tjanaya kunyu nyangatja iriti palyaṉu ninti puḻkangku.’” Alatjiya wangkangi waḻi puḻka palyantjikitjangku. Munuya wangkangi, “Wanyula tjuminta tjuṯa tjuḻpirnguṟu palyala munula waṟungka tjunkula wanti ka kampara wituwituringkuku, kala palulanguṟu wituwituringkunyangka mantjiṟa waḻi puḻkalta palyala.” Munuya mulapaṯu palyaṉu tjuminta tjuṯa tjuḻpirnguṟu, munuya kutjupa kutjupa kiṯi puṟunypa uraṉu tjuminta tjuṯa katulkira katulkira tjakatjunkunytjikitjangku. Munuya palulanguṟu waḻi tjuṯa tjumintanguṟu palyaningi apunguṟu wiya. ");
INSERT INTO pjt_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Ka Mayatja Godanya ilkaṟinguṟu ukalingu tawunu puḻka palyannyangka nyakunytjikitja, waḻi panya waṟa mulapa palyannyangka kuḻu nyakunytjikitja. ");
INSERT INTO pjt_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Munu paluṟu nyakula wangkangu, “Nyanga tjana panya walytjapiti kutjuṯu nyinanyi wangka kutjutjara. Pala palulanguṟuya tawunu puḻka palyaṉi waḻi waṟa kuḻu tjaṯu waṟkarira. Palu tjinguṟu puḻka nyanga palunya palyantjatjanungku tjana kuliṟa kaṉany-kaṉanyarira piṟuku kutjupa puḻka mulapalta palyalku. Munuya palulanguṟu tjanampa kutjupa kutjupa uwankara palyantjaku ngaṟaku tjana mukuringkula. ");
INSERT INTO pjt_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Wanyula ukalingkula tjananya tjaraṟa tjanampa wangka kutjupa kutjupara, kayanku wangka kutjuparinytjatjanungku wangkara puṯu kulilku.” ");
INSERT INTO pjt_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Munu tjananya Godalu tjaraṟa wangka tjanampa kutjupa kutjupanu, kaya waḻi puḻka panya wantikatingu piṟuku palyantja wiyangku munuya tjara tjara ankula wiyaringu ngura kutjupa kutjupa tjuṯakutu walytjaṟara walytjaṟara manta winkingka tiṯitiṯu nyinanytjikitja. ");
INSERT INTO pjt_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Ka tawunu nyara paluṟu panya ini Papilannga, waḻi panya waṟatjara. Panya ngura nyara palula Godalu aṉangu uwankara tjaraṟa tjananya wangka kutjupa kutjupanu, tjananku ngapartji-ngapartjingku wangkara puṯu kulintjaku. Palulanguṟuya uwankara tjara tjara ankula wiyaringu munuya ngura tjuṯangka lipiringkula manta winkingka nyinangi wangka kutjupa wangka kutjupa. ");
INSERT INTO pjt_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ka nyangatja Noah-ku walytjapiti maḻatja maḻatja ma-tjuṯaringkunytja palumpa katja Tjimalanguṟu. Panya uṟu puḻkangka maḻangka yiya kutjara ngaṟala wiyaringkunyangka Tjimalu katja ini Apakatanya utinu yiya nampa 100 nyinanytjatjanungku. ");
INSERT INTO pjt_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Munu palula maḻangka paluṟu piṟuku yiya tjuṯa mulapa nyinangi 500, munu tjitji kutjupa tjuṯatjararingangi. Munu palulanguṟulta ilungu rawa mulapa nyinanytjatjanu. ");
INSERT INTO pjt_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","13","Ka Apakatalu yiya nampa 35 nyinanytjatjanungku katja utinu ini Tjilanya. Munu palulanguṟu paluṟu piṟuku yiya tjuṯa mulapa nyinangi nampa 403, munu tjitji kutjupa tjuṯatjararingangi munu palulanguṟulta ilungu. ");
INSERT INTO pjt_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","15","Ka wati panya Tjilalu yiya nampa 30 nyinanytjatjanungku katja utinu ini Iipanya. Munu palula maḻangka paluṟu piṟuku yiya tjuṯa mulapa nyinangi nampa 403, munu tjitji kutjupa tjuṯatjararingangi munu palulanguṟulta ilungu. ");
INSERT INTO pjt_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","17","Ka Iipalu yiya nampa 34 nyinanytjatjanungku katja utinu ini Pilikinya. Munu palulanguṟu paluṟu piṟuku yiya tjuṯa mulapa nyinangi nampa 430, munu tjitji kutjupa tjuṯatjararingangi munu palulanguṟulta ilungu. ");
INSERT INTO pjt_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","19","Ka Pilikilu yiya nampa 30 nyinanytjatjanungku katja utinu ini Ruunya. Munu palulanguṟu paluṟu piṟuku yiya tjuṯa mulapa nyinangi nampa 209, munu tjitji kutjupa tjuṯatjararingangi munu palulanguṟulta ilungu. ");
INSERT INTO pjt_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","21","Ka Ruulu yiya nampa 32 nyinanytjatjanungku katja utinu ini Tjiṟakanya. Munu palulanguṟu paluṟu piṟuku yiya tjuṯa mulapa nyinangi nampa 207, munu tjitji kutjupa tjuṯatjararingangi munu palulanguṟulta ilungu. ");
INSERT INTO pjt_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","23","Ka Tjiṟakalu yiya nampa 30 nyinanytjatjanungku katja utinu ini Nayunya. Munu palulanguṟu paluṟu piṟuku yiya tjuṯa mulapa nyinangi nampa 200, munu tjitji kutjupa tjuṯatjararingangi munu palulanguṟulta ilungu. ");
INSERT INTO pjt_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","25","Ka Nayulu yiya nampa 29 nyinanytjatjanungku katja utinu ini Taiṟanya. Munu palulanguṟu paluṟu piṟuku yiya tjuṯa nyinangi nampa 119, munu tjitji kutjupa tjuṯatjararingangi munu palulanguṟulta ilungu. ");
INSERT INTO pjt_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Munu palulanguṟu Taiṟalu yiya nampa 70 nyinanytjatjanungku utinu katja ini Aipamanya. Munu palulanguṟu katja kutjupa utinu ini Nayunya, munu palula maḻangka utinu katja maḻatja ini Aṟannga. ");
INSERT INTO pjt_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","28","Ka nyangatja tjukurpa wati Taiṟanya tjananyatjara, panya Taiṟanya Aipamaku, Nayuku, Aṟanku mama. Ka Aṟantu katja ini Lotanya utinu, munu palulanguṟu wiyaringu mamangka miṟangka ngura tawunu ini Aaṟala manta panya Papilaniyala, panya nyara palula paluṟu iṯi ngaringu, Aṟannga panya. ");
INSERT INTO pjt_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","30","Ka Aipamalu kungkawaṟa ini Tjiiṟainya aḻṯingu, palu Tjiiṟainya puṯu tjitjitjararingangi. Ka Aipamaku maḻanypangku Nayulu kungkawaṟa ini Milkanya aḻṯingu palumpa panya maḻanypaku uṉṯalpa Aṟanku. Ka Nayuku maḻanypangku Aṟantu katja kutjupa utinu ini Itjakanya, Lotaku maḻanypa. ");
INSERT INTO pjt_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Ka palulanguṟu tjiḻpi Taiṟalu kulinu ngura ini Kainanku ankunytjikitjangku nyara palula ngura tjunkula nyinanytjikitjangku. Munu paluṟu walytja tjuṯa aḻṯingu palula tjungu ankunytjaku. Ka Aipamanya pula kuriṟara Tjiiṟainya palula tjunguringu munu palumpa pakaḻi Lotanya kuḻu Aṟanku panya katja. Munuya paluṟu tjana uwankara ngura panya Aaṟalanguṟu ma-pakaṉu munuya ankula ankula nguṟurpa wirkanu ngura ini Aaṟanta munuya nyara palulalta ngura tjunkula nyinangi ngura panya Kainannga wantira. ");
INSERT INTO pjt_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Ka ngura nyara palulalta Taiṟanya yiya nampa 205 nyinanytjatjanu ilungu. ");
INSERT INTO pjt_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Ka Mayatja Godalu Aipamanya wangkangu, “Nyuntumpa walytja tjuṯa wantikatira ara nyuntumpa ngura kuḻu munu manta kutjupangka ankula ngura tjura nyara palula nyinanytjikitjangku. Kaṉa ankunyangka nyuntunya nguṟurpa nintilku manta palunya. ");
INSERT INTO pjt_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Ka nyara palula ngayulu palyalku nyupalilanguṟu aṉangu tjuṯa mulararinytjaku maḻatja maḻatja nyuntumpa walytja tjuṯa, kaya manta nyara palula walytjapiti kutjuṯu nyinara waṉalku ngura tjuṯangka. Munu ngayulu nyuntumpa palyalku nyuntu pukuḻpa nyinanytjaku. Kaya aṉangu ngura winkitjangku nyuntunya kulilku munuya kuliṟa nyuntunya mirawaṉiku. Kaṉa nyuntulawanungku tjananya palyalku pukuḻpa nyinanytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Munuṉa aṉangu tjuṯangku nyuntunya pukuḻmankunyangkampa ngayulu ngapartji tjananya pukuḻmankuku. Palu tjana nyuntunya kurannyangkaṉa tjananya ngapartji kuralkuṯu. Uwa, ngayulu nyuntulanguṟu aṉangu uwankara manta winkitja palyaṟa pukuḻmankuku.” Alatji Godalu Aipamanya wangkangu munu wituṉu ankunytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","6","Ka nyara palula aṟa panya Aipamanya tjiḻpi yiya nampa 75 nyinangi. Ka Mayatja Godalu ankunytjaku wangkanyangka paluṟu wangaṉarangku kulinu munu ngura panya Aaṟantanguṟu ma-pakaṉu palumpa kuri Tjiiṟainya munu palumpa maḻanypaku katja Lotanya kuḻu. Munuya katingu mani puḻka, ulytja puḻka munu tjiipi tjuṯa, nanikuta tjuṯa, tangkiyi kamula kuḻu uwankara ngura Aaṟanta mantjiṟa tjunguṟa tjunguṟa kanyintjatjanungku. Munuya aṉangu waṟkaripai tjuṯa kuḻu katingu ngura pala palula ngaṉmanytju mantjiṟa kanyintjatjanungku. Nyanga uwankara alatjiṯuya Aaṟantanguṟu pakaltjingaṟa katingu ngura panya Kainanku. Munuya rawa ankula ankula ngula manta panya Kainanta wirkanu munuya piṟuku tjukutjuku ankula wirkanu puṉu miḻmiḻṯa ini Muuṟaila ngura ini Tjikimala itingka. (Palu ngura pala palula Kainannga nguraṟa tjuṯa nyinangi ngura walytjangka, nguratja tjuṯa.) ");
INSERT INTO pjt_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Ka Mayatja Godanya utiringu Aipamala munu wangkangu, “Nyanga paluṟu ngura panyatja, panya ngayulu ungkunytjikitjangku kalkuntja nyuntumpakunu tjuṯa nyinanytjaku.” Ka palulanguṟu Aipamalu pukuḻarira pitjilpa puḻka tjunu Godanya waḻkuntjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Palula maḻangkaya paluṟu tjana ma-pakaṉu uḻpaṟira ngura panya puḻi tjuṯatjarakutu. Munuya ma-wirkaṟa ngura tjunu tawunu ini Pitjulta kakaraṟa tawunu panya kutjupangka ini Aila tjangaṯi. Ka Aipamalu palu puṟunypaṯu pitjiltjunu munu Mayatja Godanya waḻkuningi. ");
INSERT INTO pjt_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Palulanguṟuya Aipamanya tjana piṟuku ma-pakaṉu uḻpaṟira munuya rawa ma-pitjalinangi manta panya Kainanta uḻpaṟira pilakutu. ");
INSERT INTO pjt_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Palu manta pala Kainanta ailuru puḻka ngaṟangi, ukiṟi wiya piḻṯi alatjiṯu. Ka palulanguṟu Aipamanya tjana manta pala palulanguṟu ma-pakaṉu wiluṟara manta panya ini Itjipalakutu nyara palula unytju nyinanytjikitja ngura ukiṟi puḻkatjarangka. ");
INSERT INTO pjt_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Munuya ankula ankula ma-ilaringu manta panya Itjipala. Ka Aipamalu palumpa kuringka wangkangu Tjiiṟaila nyanga alatji, “Nyuntu minyma wiṟu mulapa, ka tjinguṟu nyuntunya Itjipanya nguraṟa tjuṯangku nyakula kulilku, ‘Ai! Minyma wiṟu mulapa nyangatja.’ ");
INSERT INTO pjt_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Palu tjana ngayunya nyakula kulilku, ‘Nyangatja tjinguṟu palumpa kuri.’ Munuṉiya tjinguṟu ngayunya pungkuku nyuntunyakitjangku. ");
INSERT INTO pjt_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Ka palula-tawara nyuntu tjanala alatji wangka, ‘Nyangatja ngayuku kuṯa.’ Kaya palulanguṟu ngayunya pungkuwiyangku wantiku munuṉiya aṯunymankuku.” Alatji Aipamalu wangkangu palumpa kuringka Itjipanya nguraṟa tjuṯangka ngunti wangkanytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Palulanguṟuya Aipamanya tjana manta Itjipala ma-tjarpangu. Ka Itjipanya nguraṟa tjuṯangku palumpa kuri Tjiiṟainya mulapaṯu nyakula kuliningi, “Ai, minyma wiṟu mulapa nyangatja.” ");
INSERT INTO pjt_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Ka mayatja panya Piiṟaku waṟka maṉkurtu palunya nyangu, munuya tjanampa mayatjangka ankula tjakultjunu minyma wiṟu nyakunytjatjanungku. Ka Piiṟalu wangkangu palumpa waḻikutu ngalya-katinytjaku. Kaya mulapaṯu ngalya-katingu. ");
INSERT INTO pjt_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Ka Piiṟalu Aipamanya kutjupa kutjupa tjuṯa wiṟuṟa ungangi palumpa panya kurikitjangku maḻanypa-palku kuliṟa. Munu palunya ungu tjiipi tjuṯa, nanikuta tjuṯa, puluka, tangkiyi, kamula tjuṯa kuḻu, munu aṉangu waṟka tjuṯa kuḻu palunya ungu mani wiya palumpa waṟkarinytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Palu Godalu nyangu mayatja panya Piiṟalu Tjiiṟainya mantjinnyangka munu palulanguṟu palunya pikatjaraṉu, palumpa waḻingka waṟkaripai tjuṯa kuḻu. Kaya uwankara pika puḻkaringkula ngarira waṉingi. ");
INSERT INTO pjt_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","19","Ka Piiṟalu kulinu munu Aipamanya aḻṯira wangkangu, “Nyuntu ngayunya ngunti kuraṉu. Nyangatjaṉin ngunti ungu nyuntumpa maḻanypa-palku kaṉa aḻṯinytjikitjangku mantjinu. Palu nyanga paluṟu kunyu nyuntumpa kuri. Walangkunku mantjiṟa ma-kati!” ");
INSERT INTO pjt_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Munu paluṟu wangkangu palumpa waṟkaripai maṉkurta Aipamanya pulanya ma-katinytjaku. Kaya ma-katira ngura ilytjingka Itjipala itingka pulanya paiṟa ma-iyaṉu. Ka pula Itjipanya wantikatira anu kutjupa kutjupa tjuṯatjara, panya pula Itjipala mantjintja uwankaratjara. ");
INSERT INTO pjt_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","2","Uwa, wati panya Aipamanya kutjupa kutjupa tjuṯatjararingu, panya paluṟu kuka kutjupa kutjupa tjuṯa mulapa kanyiningi tjiipi tjuṯa, nanikuta tjuṯa, puluka, tangkiyi tjuṯa kuḻu munu apu tjiilpa, gold puḻka kuḻu kanyiningi. Munu paluṟu pula kuriṟarangku nyanganpa uwankara Itjipalanguṟu katingu munu pula tjina-aṟangka anu kakaraṟa munuya ma-itipirira ma-wirkanu manta panya palulaṯu panya pila Kainanta uḻpaṟira. Ka palumpa maḻanypaku katja kuḻu palula tjungu anangi wati panya Lotanya. ");
INSERT INTO pjt_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","4","Munuya nyara palula ngura tjunkula tjukutjuku nyinara piṟuku ma-pakaṉu alinytjara, munuya ngura kutjupangka piṟuku ma-tjunu munuya palulanguṟu ngurili-ngurili para-nyinangi pilangka panya Kainanta uḻpaṟira. Munuya ngulalta wirkanu ngura panya palulaṯu Pitjulta Aila nguṟurpa panya ngaṉmanytjuya alinytjaranguṟu wirkaṟa ngura tjunkula pitjiltjunu. Munu pitjilpa panya palulaṯu aṟangka wirkaṟa Aipamalu Godanya waḻkuṉu. ");
INSERT INTO pjt_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Ka wati panya Lotanya kuritjara Aipamala tjungu para-nyinaṟinangi munu paluṟu kuḻu kuka kutjupa kutjupa winki kanyiningi tjiipi, nanikuta, puluka tjuṯa munu aṉangu waṟka tjuṯa kuḻu. ");
INSERT INTO pjt_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","7","Ka nyara palula-aṟangka aṉangu Kainannga nguraṟa tjuṯa munu Piṟitjinya nguraṟa tjuṯa kuḻu nguratja alatjiṯu nyinangi ngura pala palula. Ka ukiṟi puḻka wiya nguwanpa itjanu tjukutjuku kuka tjuṯa mulatu ngalkula paḻtjaringkupai wiya. Palu Aipamaku Lotaku pulampa kuka tjuṯa mulapa, ka pula puṯu kuliningi ngura kutjungka tjunguṟa kutjuṯu kanyintjikitjangku. Ka Aipamaku waṟka tjuṯangku munu Lotaku waṟka tjuṯangku tjanampa mayatjaku kuka tjuṯa aṯunymaṟa kanyiningi, munuya kutjupa-aṟa ukiṟi-tjiratja ngaparku wangkara pikaringkupai. ");
INSERT INTO pjt_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Ka nyanga palulanguṟu Aipamalu Lotala wangkangu, “Wanyu kulila! Nyuntu panya ngali walytjaṟara, kayanku nyanganpa nyaaku rawa pikaringanyi? ");
INSERT INTO pjt_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Wanyuli kutju-kutjuriwa munuli mauṉṯalpa kanyinma. Nyuntu tjinguṟu nyarangka ankuku, ka ngayulu nyangangka nyinama. Munta tjinguṟu ngayulu nyarangka ankuku, ka nyuntu nyangangka nyinama. Ka-puṯa nyuntu-waraṟa ngurkantara, kaṉa ngayulu maḻa.” ");
INSERT INTO pjt_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Ka Lotalu para-nyakula nyangu karu nyara Jordannga wati-ngarira ukalingkunyangka wimaṟu lipi puḻkangka, munu kulinu, “Munta nyaratjampal ngura wiṟu mulapa karu uṟutjara ukiṟi puḻkatjara Mayatja Godaku kaana puṟunypa munu manta Itjipanya puṟunypa. Tjinguṟuṉa nyara palulakutu ankula nyinaku kuwari.” (Aṟa nyanga palula-aṟangka tawunu puḻka Tjatamanya pula Kumaranya ngaṟangi palya Godalu piḻuntankunytja wiya.) ");
INSERT INTO pjt_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Munu Lotalu karu wimaṟu Jordannga ngurkantaṟa anu ngura ma-tjunkunytjikitja kakaraṟa-pitinypa. Alatji Aipamanya Lotanya pula kutju-kutjuringkula mauṉṯalparingu. ");
INSERT INTO pjt_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Aipamalu panya manta Kainanta ngura tjunu, ka Lotalu panya ankula ngura ma-tjunu Jordanta wimaṟungka ngura panya tawunu Tjatamala itingka, ilytjingka wiya. ");
INSERT INTO pjt_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Ka ngura pala palula aṉangu panya Tjatamala nyinanytja tjuṯa kura mulapa nyinangi watarku alatjiṯu Godanya kulilpai wiya. ");
INSERT INTO pjt_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Nyanga palula maḻangka Lotanya ankunyangka Mayatja Godalu Aipamala wangkangu, “Pala nyuntu ngaṟanytjalanguṟu purkaṟangku para-miṟaṟa waṉaṟa manta winki nyawa. ");
INSERT INTO pjt_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Ngayuluṉanta manta nyanga uwankara nyuntunya ungkuku nyuntumpa walytja tjuṯa kuḻu maḻatja maḻatja, ka nyuramparira nyurampa alatjiṯu tiṯutjara ngaṟaku. ");
INSERT INTO pjt_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Panya ngayulu palyalku nyuntumpa walytjapiti winki mulararinytjaku maḻatja maḻatja, kaya minga puṟunypa mungilyi mulapa nyinaku puṯu kantamilantjaku. ");
INSERT INTO pjt_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Ka kuwari ara munu para-nyangama manta winki, panya ngayulu manta nyanga palunya uwankara nyuntunya unganyi.” ");
INSERT INTO pjt_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Ka palulanguṟu Aipamalu tjana ma-pakaṉu munu ankula tawunu ini Ipuṟanta itingka ngura tjunu puṉu miḻmiḻpa tjuṯangka ini Muuṟaila. Munu paluṟu pitjilpa puḻka palyaṉu Mayatja Godaku palunya waḻkuntjikitjangku. Munu ngura nyanga palulanguṟulta para-nyangangi. ");
INSERT INTO pjt_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","4","Ka wati ini Kitu-layamanya manta uwankaraku mayatja nyinangi Kainanku kuḻu. Paluṟu ngura ini Ilamala nyinangi Kainanta alinytjara kakaraṟa nguwanpa. Ka palula itingka tawunu maṉkurpa ngaṟangi, ka ngura nyara maṉkurpa mayatja maṉkurtu kanyiningi, wati panya Kitulayamaku maḻpa maṉkurtu. Ka ngura tawunu kutjupa ini Tjatamanya uṟu ini Ilunytjala itingka kampa uḻpaṟira ngaṟangi manta panya Kainanta. Ka Tjatamala itingka tawunu kutjara kutjara ngaṟangi, ka aṉangu ngura Tjatamala tjanala nyinanytja tjuṯa aṉangu Ilamanya nguraṟa tjuṯaku kuraringkupai, panya mayatja Kitulayamalu tjana yiya kutjupa yiya kutjupa aṉangu palunya tjananya Ilamalanguṟu pitjala pauntjingaṟa mantjilpai mani puḻka, mai puḻka, ulytja tjuṯa munu kutjupa kutjupa tjuṯa kuḻu. Kaya palulanguṟu aṉangu ngura Tjatamala tjanala nyinanytja tjuṯangku rawa 12 yiya nguḻu-nguḻu nyinanytjatjanungku raparingkula kuliningi tungunpungkula pikaringkunytjikitjangku ngapartji mayatja Kitulayamaku tjanampa. Munuya palulanguṟu ngura panya tjuṯanguṟu tjunguringu wimaṟu ini Tjitimala munuya warmaḻaringu Kitulayamaku tjanampa ngapartji. ");
INSERT INTO pjt_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","7","Ka mayatja panya Kitulayamalu kulinu tungunpungkunyangka munu paluṟu aḻṯingu ngura panya maṉkuritja warmaḻarinytjaku, munuya tjunguringkulalta ngalya-ukalingu tjananya pungkunytjikitja. Munuya ukalingkula kutjupa tjuṯa-waraṟa pungu tawunu nguṟuritja tjuṯa munuya ngura kutjutja pungkula piṟuku ukalingkula ngura kutjupitja ngapartji pungu munu pungkula wiyaringkula piṟuku ukalingu ngura kutjupitja ngapartji pungkunytjikitja ngura panya Tjatamala tjanala kakaraṟa-pitinypa. Munuya pungkula wiyaringkula kulinu Kitulayamalu tjana piṟuku ngura kutjupitja tjuṯa ngapartji pungkunytjikitjangku. Munuya ngalya-ukalingu, kaya ngura panya kutjupitja tjuṯangku nyakula nguḻu wirtjapakaṉu uḻpaṟira. Kaya Kitulayamalu tjana nguḻuṟa waṯaparaṉu, palu tjana wala puḻka nguḻu wirtjapakaṉu. Kaya puṯu waṯaparaṟa waṯaparaṟa pakuringkula wantingu. Ka tjana nguḻu kumpiṟa alatjiṯu anu. Kaya Kitu-layamanya tjana maḻaku aṟuringkula kampa wiluṟarawanu anu. Munuya tjana maḻaku pitjala piṟuku kutjupa tjuṯa pungkunytjikitjangku kuliningi munuya Ama-likakunu tjuṯa-waraṟa pungu munuya palulanguṟu Aimurkunu tjuṯa ngapartji pungu. Munuya nyanga palunya tjananya pungkula wiyaringkula kulinu ngura panya Tjatamanya pungkunytjikitjangku munu Tjatamala ititja tjuṯa kuḻu, ngura panya Kumaranya tjananya. ");
INSERT INTO pjt_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","12","Kaya Tjatamaku mayatjangku munu ngura ititja tjuṯaku mayatja tjuṯangku kuḻu tjanampa wati tjuṯa aḻṯingu wimaṟu ini Tjitimala warmaḻa tjunguringkunytjaku, kaya mulapaṯu uwankara tjunguringkula paṯaningi warmaḻa wati panya Tjitulayamaku tjanampa. Kaya wirkanu palumpa tjanampa pikalta. Palu puṯuya ngaparpungkula pungu panya tjanaya tungun-tungunpa puḻka kaya puṯuliṟa nguḻu wirtjapakaṉu. Palu mayatja kutjara, Tjatamaku Kumaraku pulampa mayatja, wirtjapakaṟa manta uwilatjarangka wiṟulyaraṟa punkaṟa piṯi ngaṯingka tjarpangu, kaya mayatja ngura maṉkuritja kutjulta wirtjapakaṟa kumpiṟa nyinangi puḻingka. Kaya Kitulayamalu tjana ngura panya Tjatamala Kumarala pulala tjarpangu munuya kutjupa kutjupa uwankara mantjiṟa katingu mai ulytja winki munu aṉangu kutjupa tjuṯa kuḻu. Munuya wati panya Aipamaku katja Lotanya kuḻu witiṟa ma-katingu palumpa walytja tjuṯa munu ulytja tjuṯa kuḻu, panya paluṟu tawunu Tjatamala nyinangi. Munuya Kitu-layamanya tjana ma-pakaṉu ngura walytjakutu kutjupa kutjupa tjuṯatjara. ");
INSERT INTO pjt_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","16","Palu wati kutju tjana witiṟa kanyintja tjirkaṟa nguḻu wirtjapakaṉu kumpiṟa, munu wati Iipuṟula wirkanu panya Aipamala munu palula tjakultjunu uwankara panya palumpa katja kuḻu witiṟa katinytja. Ka nyanga palula aṟangka Aipamanya wati ini Mamaṟaiku ngurangka itingka nyinangi puṉu waṟa tjuṯangka. Panya paluṟu pula ngaṉmanypa maḻparingu, ka palumpa maḻanypa kutjara kuḻu Aipamaku maḻpa nyinangi, ini Itjikalnga pula Ainanya. Ka Aipamalu palumpa katja Lotanya katinytja kuliṟa palumpa wati waṟka kuṉpu tjuṯa aḻṯira tjunguṉu warmaḻarinytjaku. Ka wati Mamaṟailu tjana palumpa maḻanypa kutjarangku kuḻu tjanampa wati waṟka tjuṯa kuḻu tjunguṉu Aipamala tjanala. Munuya tjunguringkula wati panya Kitu-layamanya tjananya pikangku waṯaparaṉu, panya palumpa katja katinytjitjangka. Palu Aipamalu warmaḻa maṉkurpa nguwanpa katingi nampa panya 318, munuya tjananya waṯaparaṟa waṯaparaṟa nyangu nyinanyangka munuya ngaṯalpaṯu ngaṟangu ngura ini Danta. Ka tjana watarku alatjiṯu nyinara waṉingi. Ka mungangka Aipamalu wati palumpa tjuṯa tjaraṟa tjunu kapuṯu kutjupa kapuṯu kutjupa para-arintaṟa ngura tjanampangka. Munuya watarku nyinanyangka paluṟu tjana urulyku wirkanu tjilira puḻkatjara. Ka panya tjana nyakula nguḻu-nguḻuringu munuya kulinu, “Tjinguṟu nyanga tjana winki mulapa pitjangu!” Ka Aipamalu tjana pungkula waintaṟa tjara kutjupa nguḻuṟa waṯaparaṉu. Kaya nguḻu wirtjapakaṉu maṟalpa alatjiṯu ngura tawunu walytjakutu. Kaya Aipamalu tjana waṯaparaṟa ngura ini Awupala ma-wirkanu panya ngura ini Tamatjakala alinytjara munuya ngaṯalnguṟu wantira pitjangu. Munuya maḻaku pitjala Kitulayamaku tjanampa nguranguṟu kutjupa kutjupa uwankara mantjinu panya tjana Tjatamala pulala Kumaralanguṟu kutitjuṟa katinytja uwankara. Munu palumpa katja Lotanya kuḻuya mantjiṟa katingu palumpa kutjupa kutjupa tjuṯa kuḻu panya tjana kutitjuṟa katinytja tjuṯa. Munu wati panya witiṟa katinytja tjuṯa kuḻu minyma tjuṯa kuḻu mantjiṟa maḻakungku katingu, panya tjana ngura Tjatamala pulala Kumaralanguṟu witiṟa katinytja tjuṯa. ");
INSERT INTO pjt_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","18","Ka ngura Tjatamaku mayatjangku kulinu Aipamalu tjana Kitu-layamanya tjananya pungkunytja, munu paluṟu kuliningi Aipamanya tjana ngalya-pitjanyangka ngaparikatinytjikitjangku. Munu mulapaṯu ankula ngapari-ngapari wirkanu ngura wimaṟu ini Tjapala panya tawunu ini Ipuṟanta alinytjara. (Kuwarila wimaṟu nyara palunya ini wangkapai, “Mayatjaku Wimaṟu”.) Ka wimaṟu nyara paluṟu ngura tawunu ini Salemala itingka kuḻu. Ngura pala paluṟu ini Salemanya iriti ngaṟangi munu maḻangka ini Jerusalemanyaringu. Ka wati ini Milkitja-tikanya nyinangi Salemanya nguraṟa tjuṯaku mayatja munu palumpa tjanampa wati inma kanyilpai kuḻu nyinangi, panya paluṟu kuka pitjilpa puḻkangka tjunkula tiliwakalpai Godanya waḻkuntjikitjangku Mayatja panya Katutja Puḻkanya. Munu paluṟu Aipamanya wati-pitjanyangka kuliṟa mai waina kuḻu palula tjanalakutu ngalya-katira ungu. ");
INSERT INTO pjt_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Munu paluṟu Aipamanya pukuḻmanu alatji wangkara, “Mayatja God, nyuntu katutja puḻka mulapa, munun ilkaṟi manta kuḻu palyaṉu. Wanyu, wati nyanga Aipamaku palyanma pukuḻpa mulapa nyinanytjaku! ");
INSERT INTO pjt_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Kalanku nyuntunya Mayatja Godanya puḻkaṟa mirawaṉima Katutja Puḻkanya, panya nyanga tjananya nyuntu witulyanu tjanampa mirpaṉtju tjuṯa pungkula waintarinytjaku.” Ka palulanguṟu Aipamalu kutjupa kutjupa tjuṯa wati Kitulayamala tjanalanguṟu mantjintjatjanungku tjaraṟa tjukutjuku ma-ungu Milkitja-tikanya mai, ulytja tjuṯa. ");
INSERT INTO pjt_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Ka Tjatamaku mayatjangku Aipamala wangkangu, “Nyuntu uwankara kanyinma panya Kitulayamalu tjana tawunu Tjatamalanguṟu mai, ulytja, kuka tjuṯa mantjiṟa ma-katinytja, palu ngayuku aṉangu tjuṯa kutjuṉi maḻakungku uwa.” ");
INSERT INTO pjt_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","23","Ka Aipamalu ngapartji wangkangu, “Kuwariṉanta nyuntunya tjukaṟurungku wangkanyi Mayatja Katutja Puḻkangka miṟangka. Ngayulu kuwari nyuntumpa uwankara nyuntunya maḻakungku unganyi mai, ulytja, kuka tjuṯa kuḻu. Tjinguṟuṉitju Godalu kuliṟa tarilaraṟa ngunti wangkanyangka pungkuku. Palu ngayulu mulamulangku wangkanyi nyuntunya uwankara alatjiṯu maḻakungku ungkunytjikitjangku. Ngayulu kutjupa kutjupa tjukutjuku kanyintja wiyangku uwankara nyuntunya ungkuku, panya ngayulu kanyinnyangkampa nyuntu tjinguṟu alatji ngayunya wangkaku, ‘Ngayuluṉanta nyuntunya ulytja puḻkakutuṉu, Godalunta ungkunytja wiya.’ Alatji wangkanytjaku-tawaraṉanta kutjupa kutjupa tjuṯa nyuntumpa kanyintja wiyangku uwankara maḻakungku unganyi. ");
INSERT INTO pjt_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Palu ngayuku wati tjuṯangku nyuntumpa mainguṟu tjukutjuku mantjiningi ngalkukatinytjikitjangku. Palya? Ka nyanga ngayuku maḻpa Mamaṟainya munu palumpa maḻanypa kutjara kuḻu ngayula tjungu anu, ka nyuntu tjinguṟu tjananya tjaraṟa ungama. Palya?” Alatji Aipamalu ngura Tjatamaku mayatjangka wangkangu. ");
INSERT INTO pjt_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Ka nyara palulanguṟu Aipamanya ankula ngurangka wirkaṟa nyinangi. Munu paluṟu munga kutjupa tiinta unngu nyinara ira-nyakula nyangu kutjupa kutjupa irnyannyangka munu paluṟu kulinu wangka Godanya alatji wangkanyangka, “Aipama! Nguḻuringkuwiya nyinama. Ngayulu nyuntumpa kuṯitji puṟunypa, panya kura kutjupa kutjupa tjuṯangka-tawaraṉa nyuntula anga-ngaṟanyi. Munuṉa ngayulu nyuntunya ungkuku kutjupa kutjupa puḻka nyuntu ngayunya wangaṉarangku kulinnyangka.” ");
INSERT INTO pjt_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Ka Aipamalu ngapartji wangkangu, “Mayatja Katutja Puḻka! Nyaakuṉin kutjupa kutjupa puḻka ungkuku? Panya ngali kuriṟara kutju maṟalpa nyinanyi. Nyuntu panyaṉin ngayunya tjitji ungkunytja wiya ngayuku ulytja kutjupa kutjupa tjuṯa ngayulu ilunyangka maḻangka mantjintjaku. Palu ngayuku wati waṟka kutju nyinanyi mantjintjikitja wati ini Iliyatjanya ngura panya Tamatjakanya nguraṟa. Paluṟunti ngayuku uwankara mantjilku ngayulu ilunyangka.” ");
INSERT INTO pjt_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Ka Mayatja Godalu piṟuku palula wangkangu, “Wiya, nyanga nyuntumpa waṟkangku Iliyatjalu mantjintja wiya nyuntumpa uwankara nyuntu ilunyangka maḻangka, nyuntumpa katja mulatu kutju mantjilku nyuntu panya utintjitjangku kutju.” ");
INSERT INTO pjt_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Munu Mayatjalu palunya uṟilkutu katira wangkangu, “Ira-nyawa ilkaṟi nyara munu kililpi tjuṯa kantamilala. Nampa pala palu puṟunypa aṉangu nyuntulanguṟu ma-tjuṯaringkuku nyuntumpakunu tjuṯa.” ");
INSERT INTO pjt_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ka Aipamanya mulamularingu Godaku. Ka nyara palulanguṟu Godalu palunya mulamularingkunyangka nyakula tjukaṟurunmankula walytjanmanu. ");
INSERT INTO pjt_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Munu paluṟu wangkangu Aipamala, “Ngayulu Mayatja Godanya, panya ngayulu nyuntunya ngalya-katingu ngura nyara Aaṟalanguṟu manta panya Papilaniyalanguṟu, munuṉa ngayulu manta nyanga winki nyuntunya ungu nyuntu walytjangku kanyintjaku.” ");
INSERT INTO pjt_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ka Aipamalu ngapartji tjapinu puṯu kuliṟa, “Mayatja Katutja! Ngura nyanga walytja tjuṯayanku nyinara waṉaṉi. Kaṉa puṯu nguwanpa mulamularinganyi. Wanyu-puṯa kutjupa kutjupa palyala ngayulu nyakula mulamularingkunytjaku panya nyuntu ngayunya ungkunytjitjaku.” ");
INSERT INTO pjt_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Ka wangkangu, “Uwa kuwariṉanta nintini. Ka nyuntu nyuntumpa kukanguṟu ankula mantjiṟa ngalya-kati puluka kutju, nanikuta kutju, rama kutju paluṟu tjana panya kuḻi maṉkurpa nyinanytjitja munu kuukuuku kutju araḻapaḻpaḻpa kutju kuḻu ngalya-kati.” ");
INSERT INTO pjt_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ka Aipamalu ankula mantjiṟa ngalya-katingu kuka maṉkurpa tjuḻpu kutjara Godanya ungkunytjikitjangku. Munu katira puluka-waraṟa pungkula kata tjilpirpungkula walytjarpungkula ukalingkula kutjaraṉu munu walytjarpa kutjara lipiṟa mantangka tjunu munu paluṟu kuka panya kutjupa kutjara palu puṟunypaṯu walytjarpungkula tjunkula waṉaṉu kampa kutjara, ka nguṟurpa aḻa ngaṟala waṉaningi. Munu paluṟu tjuḻpu kutjara pungkula walytjarpungkuwiyangku winkiṯu tjunu kuka puḻkangka tjunguṟa kampa kutjara. ");
INSERT INTO pjt_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Ka tjuḻpu panya kirkinpa tjuṯa pitjangu kuka ngalkuntjikitja. Ka Aipamalu tjananya pitjanyangka anga-ngaṟala painingi. ");
INSERT INTO pjt_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Munu paluṟu rawangku nyinara paṯaningi Godaku, munu mungartjirira tjiṉṯu tjarpanyangka ma-kunkunaringu munu puḻkaṟa kunkunarira ma-tjukur-tjukurariṟa puḻkaṟa nguḻuringangi munu tjititingangi. ");
INSERT INTO pjt_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Ka Mayatja Godalu palula tjukurpa wangkangu alatji, “Nyuntumpa walytjapiti ma-tjuṯaringkuku maḻatja maḻatja munuya ngula ngura malikitjangka ma-wirkaṟa malikitja tjuṯangka tjunguringkula nyinaku. Ka tjananya nyara palunya nguraṟa tjuṯangku waṟka puḻka ungkula puḻkaṟa alatjiṯu pakulku munuya pungkula kuḻu wituwitulku. Kaya nyuntumpa walytjapiti paku puḻka nyinaku ngura nyara palula rawa mulapa yiya nampa 400. ");
INSERT INTO pjt_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Palu ngayuluṉa malikitja nyara palunya tjananya ngapartji kuralkuṯu nyuntumpakunu tjuṯa kurannyangka. Kaya nyuntumpakunu tjuṯangku ngura nyara palunya nguraṟa tjuṯaku kutjupa kutjupa tjuṯa mantjilku ulytja tjuṯa, mani puḻka, kutjupa kutjupa wiṟu tjuṯa, munuya mantjiṟa ngura palunya wantikatira ankuku kutjupa kutjupa winkitjara. ");
INSERT INTO pjt_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Palu kuwari nyuntu rawa mulapa nyinaku munu tjiḻpiringkula ipilypa alatjiṯu nyinara iluku punkata-punkatarinytja wiya. ");
INSERT INTO pjt_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Kaya nyuntumpa walytja tjuṯa maḻatja maḻatja tjuṯaringkula ngura panya malikitjangka tiṯutjara nyinaku yiya nampa 400, munuya palulanguṟu tjuṯa mulararira maḻaku pitjaku ngura nyangakutu. Panya kuwariya nyangatja nguraṟa tjuṯa nyinanyi manta nyangangka aṉangu panya kura tjuṯa, palu ngayulu ngula kutju tjananya paiṟa iyalku tjana kura mulararinyangka kutju. Kaya nyara palulanguṟu nyuntumpakunu tjuṯa tjarpara nyinaku ngura walytjangka.” Alatji Godalu Aipamanya wangkara kalkuṉu. ");
INSERT INTO pjt_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Ka tjiṉṯu tjarpara mungaringkunyangka ayinayini kutjara urulyku wirkanu piti waṟutjara munu waṟu tjangi tili puḻkatjara kuka panya tjuṯangka. Ka waṟu panya pitingka puyu puḻka pakaningi. Munu pula kukangka nguṟurwanu wirkaṟa ma-pitjala ma-wiyaringu ayinayini panya kutjara. ");
INSERT INTO pjt_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","21","Ka pala palula-aṟangka Godalu Aipamanya kalkuṉu alatji wangkara, “Ngayulu nyuntumpakunu tjuṯa ngula manta nyangatja unganyi walytjaringkula nguraṟarinytjaku. Panya manta Itjipala itinguṟu alinytjara karu ini Yupuṟaitilakutu ma-ngaṟala waṉaṉi, manta pala puḻka palunyaṉa unganyi nyuntumpakunu tjuṯa. Palu ngura nyanga palulawanu panya aṉangu kutjupa kutjupa tjuṯa kuwari nyinara waṉaṉi panya Kinkunu tjuṯa, Kinitjikunu tjuṯa, Katamanikunu tjuṯa, Iitakunu tjuṯa, Piṟitjikunu tjuṯa, Ripaim tjuṯa, Amurkunu tjuṯa, Kainankunu tjuṯa, Kirkatjakunu tjuṯa munu Tjaipukunu tjuṯa, aṉangu tjuṯa mulapa.” Alatji Godalu Aipamanya wangkara kalkuṉu. Ka Aipamanya Godaku mulamularingu, panya paluṟu waṟu ayinayini kutjara urinyangka nyakula kulinu, “Mulapa Godalu ngayunya kalkuṉu.” ");
INSERT INTO pjt_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","3","Ka Aipamanya tjana rawa nyinangi ngura nyara Kainanta kuḻi nyiṉnga 10-pa. Ka Aipamaku kuringku Tjiiṟailu tjitji puṯu kanyiningi palumpa. Munu paluṟu kulinu palumpa kungka waṟkaripai ini Aikanya ngura panya Itjipanya nguraṟa Aipamanya kalkuṟa ungkunytjikitjangku tjitji palumpa utintjaku. Munu paluṟu wangkangu palumpa kuringka, “Mayatja Godaluṉi tjitji wiyaṉu. Ka nyuntu uti kungka nyanga ngayuku waṟkaripaingka ngarima. Ka tjinguṟu paluṟu tjitji ngalimpa kanyilku panya ngayulu puṯu kanyini.” Ka Aipamalu kuliṟa palya kulinu. Ka palulanguṟu Tjiiṟailu kungka panya Aikanya ungu Aipamanya palula tjunguringkunytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ka palulanguṟu kungka paluṟu iṯitjararingu. Munu paku nyinara paluṟu kaṉany-kaṉanyaringi munu Tjiiṟainya kuranmanangi alatji wangkara, “Nyuntu iṯiku ngurpa, ngaḻṯutjara. Kaṉatju ngayulu iṯitjararingu maḻatja munuṉa ngayulu Aipamaku kuriringu.” ");
INSERT INTO pjt_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Ka palulanguṟu Tjiiṟainya tjituṟu-tjituṟuringu munu Aipamanya wangkangu, “Nyangatja nyuntu kuliṟa tjukaṟuruntjaku Aipama, panya nyangangkuṉi ngayunya kuranmananyi. Ngayulu panyaṉa nyuntunya ungu kungka nyaratja, ka paluṟu paku nyinara kaṉany-kaṉanyarira ngayuku rawa kuraringanyi. Kalinyawi wanyu Mayatja Godalu nyuntunya ngalinya ngurkantara ngananya kura, tjinguṟu nyuntu, tjinguṟu ngayulu.” ");
INSERT INTO pjt_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Ka Aipamalu ngapartji wangkangu, “Uwa palya! Palu nyuntulta kulila panya paluṟu nyuntumpa waṟkaripai. Tjinguṟu nyupalinku pungkula wiyaringkuku, tjinguṟu nyuntu palunya paiṟa iyalku. Nyuntulta kulinma.” Ka palulanguṟu Tjiiṟailu Aikanya tjuni puḻka wiṟuṟa kanyilwiyangku kuraṟa pungangi puḻkaṟa mulatu. Ka palulanguṟumpa kungka panya Aikanya nguḻulta wirtjapakaṉu uḻpaṟira palumpa ngura walytjakutu. ");
INSERT INTO pjt_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","8","Munu paluṟu ngura ini Tjuuku iwarangka ankula ilytjingka nguṟurpa wirkanu mina waḻangka paku puḻka. Munu mina tjikiṟa nyinangi pakuwiyaringkunytjikitja, ka angelpa Mayatja Godaku palula utiringu munu wangkangu, “Aika! Nyuntu minyma panya Tjiiṟaiku waṟkaripai nyinangi. Yaaltjinguṟun pitjangu? Munun yaaltjikutu ananyi?” Ka wangkangu, “Ngayuluṉa ngayuku mayatjanguṟu wirtjapakaṉu.” ");
INSERT INTO pjt_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Ka angeltu wangkangu, “Wiya, maḻaku ara munu palula nyinara waṟkarima.” ");
INSERT INTO pjt_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","11","Munu paluṟu wangkangu, “Nyuntu kuwari katjatjararinganyi munun inilku Itjumailnga, panya Godalu nyuntunya kulinu ilytjinguṟu mirara ngatjinnyangka puṯu kuli-kuliṟa. Munu paluṟu palyalku nyuntumpa katjanguṟu aṉangu ma-tjuṯa mulararinytjaku maḻatja maḻatja, kaya mungilyi mulapa nyinaku puṯu kantamilantjaku. ");
INSERT INTO pjt_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Palu nyuntumpa katja tangkiyi inuṟa puṟunypa nyinaku wati pikaṯi mulapa, kaya aṉangu tjuṯa palumpa kuraringkuku munuya wantiku. Ka paluṟu palumpa walytja kutjupa tjuṯaku mirpaṉtju nyinaku kalypa wiya.” Alatji angeltu minyma panya Aikala wangkangu. ");
INSERT INTO pjt_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Ka Aikalu kulinu, “Mulapaṉatju Godanya nyakula ilunytja wiya wankaṯu nyinanyi? Wiya, mulapaṉi wangkangu.” Munu nyara palulanguṟu Mayatja Godanya ininu nyanga alatji, “God Panya Ngayunya Nyakupainya”. ");
INSERT INTO pjt_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Palulanguṟuya aṉangu tjuṯangku kuwari mina pala palunya wangkapai alatji, “Ngura nyanga palula panya palunya nyangu Tiṯutjara Nyinapailu”. Ka mina panya paluṟu kuwaripaṯu ngarinyi ngura panya Katitjala pulala Piṟitjila nguṟurpa. ");
INSERT INTO pjt_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Kaya Aikalu kuliṟa maḻaku anu Tjiiṟailakutu munu nyinara nyinara katja kanyinu Aipamaku. Ka Aipamalu tjitji palunya ininu “Itjumailnga”. ");
INSERT INTO pjt_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Palu tjitji wirkankunytja-aṟangka Aipamanya tjiḻpi mulapalta nyinangi yiya tjuṯa 86 nyinanytjatjanu. ");
INSERT INTO pjt_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ka ngula Aipamanya tjiḻpiringkula yiya tjuṯa 99 nyinanyangka maḻangka Godalu palula utiringkula wangkangu, “Ngayuluṉa God Witulya Puḻkanya. Kaṉi nyuntu ngayunya wangaṉarangku kulinma munu tjukaṟuru mulapa nyinama kutjupangku nyuntunya nyakula kuranmankunytjaku-tawara. ");
INSERT INTO pjt_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ngayulu panya nyuntunya kalkuntjaṉa palyalku munuṉa nyuntulanguṟu aṉangu maḻatja maḻatja ma-tjuṯa mulararinytjaku palyalku.” ");
INSERT INTO pjt_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","4","Ka Aipamalu kuliṟa tultjungaṟakatira ngalyangku manta pampuṉu Godanya waḻkuntjikitjangku, ka piṟuku palula wangkangu, “Kulilaṉi! Nyanga alatjiṉa nyuntunya kalkuṉi, panya ngayulu nyuntunya tjunkuku kutju-tjamu puḻka nyinanytjaku manta winkitjaku ngura kutjupitja kutjupitja tjuṯaku. ");
INSERT INTO pjt_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Palulanguṟuṉa kuwari nyuntunya ini kutjupananyi, ka nyuntu Aipamanya wiyaringkula ini kutjuparinyi nyanga alatji, ‘Aipuṟamanya’, panya ngayulu nyuntunya ngurkantanu aṉangu ngura winkitjaku kutju-tjamu nyinanytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ngayuluṉa nyuntulanguṟu palyalku aṉangu maḻatja maḻatja ma-tjuṯa mulararinytjaku, kaya ngura kutjupa kutjupa tjuṯangka nyinaku walytjaṟara walytjaṟara mungilyi mulapa. Kaya kutjupatjara mayatja puḻka nyinaku ngura tjuṯaku. ");
INSERT INTO pjt_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","“Munuṉa ngayulu kalkuntja panyatja rawangku kulilku, nyuntunya kutju kalkuntja wiya palu nyuntumpa katja, pakaḻi puḻiripiti maḻatja maḻatja kuḻuṉa uwankara kalkuṉi. Ka kalkuntja panya paluṟu tiṯutjara ngaṟaku wiyaringkunytja wiya alatjiṯu. Panya ngayulu nyuntumpa God nyinanyi, munuṉa nyuntumpa walytja tjuṯaku kuḻu God nyinaku maḻatja maḻatja uwankaraku. ");
INSERT INTO pjt_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ka panya nyuntu manta nyanga Kainanta pitjala nyinangi malikitja. Palu ngayuluṉanta nyuntunya manta nyangatja ungkuku, nyuntumpa walytja tjuṯa kuḻu maḻatja maḻatjangku walytjaringkula nguraṟarira kanyintjaku tiṯutjarangku. Munuṉa ngayulu palumpa tjanampa God nyinaku maḻatja maḻatja uwankaraku.” ");
INSERT INTO pjt_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Munu Godalu piṟuku wangkangu Aipuṟamala nyanga alatji, “Ngayulu panya nyuntunya kalkuṉu, ka nyuntu kuḻu ngayunya ngapartji kalkunma ngayunya rawangku wangaṉarangku kulintjikitjangku. Nyuntu kutju wiya, palu nyuntumpa walytja tjuṯangku kuḻu maḻatja maḻatjangku uti ngayunya kalkunma rawangku wangaṉarangku kulintjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","13","Uwa, ngayulu nyuntunya kalkuṉu, ka nyuntu ngapartji ngayunya wangaṉarangku kulinma, munu nyiṯayira tjuṯa watiringkunytjaku palyala nyuntu munu nyuntumpa katja munu nyuntula tjungu nyinapai uwankara kuḻu. Ka nyuntumpa katjapiti pakaḻipiti kulypalpiti nyiṯayira uwankara maḻatja maḻatja palu puṟunypaṯu watiku aṟangka tjarpama. Mamangku uti iṯi nyiṯayira wirkankunyangka tjiṉṯu 8-nguṟu palyanma. Munu panya nyurala waṟkaripai tjuṯaku iṯi nyiṯayira tjuṯa kuḻu palyanma. Munu nyura aṉangu ngura kutjupitja nyurala waṟkarinytjaku payamilaṟampa nyiṯayira tjuṯa palu puṟunymanama munu tjana iṯi nyiṯayira tjuṯa kanyinnyangkampa alatjinamaṯu. Ka watiringkunytja pala palulanguṟu nyura uwankarangku kulilku, ‘Mulapa Godalu nganaṉanya kalkuṉu, munu kalkuntjatjanungku paluṟu palyalku alatjiṯu wantinytja wiyangku.’ ");
INSERT INTO pjt_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ka tjinguṟu nyiṯayira kutjupa watiringkunytja wiya nyinarampa paluṟu ngayuku walytja wiya, munu nyurala tjungu wiya malikitja alatjiṯu. Panya ngayulu nyuranya kalkuntjatjanungku wangkangu nyiṯayira tjuṯa watiringkunytjaku, ka kutjupangku wantirampa kalkuntja panyatja wiyaṉi.” ");
INSERT INTO pjt_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Munu Godalu piṟuku Aipuṟamala wangkangu, “Palu nyuntumpa kuri panya ini ‘Tjiiṟainya.’ Ka nyuntu kuwari palunya piṟuku Tjiiṟainya wangkanytja wiyangku ini kutjupa wangkama nyanga alatji ‘Tjiiṟanya’, panya ngayulu palunya kuḻu ini kutjupananyi. ");
INSERT INTO pjt_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ngayulu palunya puḻkaṟa pukuḻmankuku, munuṉa palunya iṯitjararingkunytjaku palyalku nyuntumpa katja kanyintjaku. Ka katja pala palulanguṟu aṉangu ma-tjuṯa mularariku maḻatja maḻatja, ka minyma paluṟu tjanampa kutju-kami puḻka nyinaku. Paluṟu tjana ngura kutjupa kutjupa tjuṯangka nyinaku walytjaṟara walytjaṟara mungilyi mulapa. Kaya kutjupatjara mayatja puḻka nyinaku ngura tjuṯaku.” Alatji Godalu wangkangu Aipuṟamaku kuri pukuḻmankunytjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ka wati panya paluṟu kuliṟa waḻkuntjikitjangku tultjungaṟakatira ngalyangku manta pampuṉu. Palu paluṟu unngu kuliṟa ikaringangi panya paluṟu kuliningi, “Ngali panyalinku tjiḻpi pampa mulapa. Yaaltjingaṟali tjitjitjararingkuku? Ngayulu irititja mulapa yiya 100 nyinanytja, ka Tjiiṟanya palu puṟunypaṯu irititja mulapa yiya 90 nyinanytja iṯi kanyintjikitja wiya.” ");
INSERT INTO pjt_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Munu paluṟu Godala tjapinu, “Wanyu-puṯa Itjumailnga palyanmanama ngayula aṟangka nyinanytjaku?” ");
INSERT INTO pjt_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Ka Godalu wangkangu, “Wiya, nyuntumpa kuri mulatu Tjiiṟalu katja nyuntumpa ngula kanyilku, ka nyuntu palunya inilku Isaacanya. Munu ngayulu Isaacanya palu puṟunytjuṯu kalkulku munuṉa palumpa walytja tjuṯa maḻatja maḻatja kuḻu kalkulku, panya ngayulu nyuntunya kalkuṉu, palu puṟunypa. Kalkuntja nyangatja tiṯutjara ngaṟaku wiyaringkunytja wiya alatjiṯu. ");
INSERT INTO pjt_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Palu ngayulu kulini nyuntu Itjumailku tjapinnyangka, munuṉa palulanguṟu palunya kuḻu pukuḻmankuku palunya tjitji tjuṯa ungkula, ka palumpa walytja tjuṯa mulapa nyinaku maḻatja maḻatja. Paluṟu katja tjuṯa nampa 12 utilku, kaya katja paluṟu tjana mayatja tjuṯa nyinaku ngura tjuṯaku. Kaya palula tjanalanguṟu aṉangu ma-tjuṯa mularariku maḻatja maḻatja Itjumailku panya walytja tjuṯa. Ka Itjumailnga tjamu puḻka nyinaku aṉangu nyanga palumpa tjanampa. ");
INSERT INTO pjt_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Palu nyuntumpa kuringku Tjiiṟalu ngula iṯi katja kanyilku aṟa nyanga palu puṟunypa yiya kutjupa. Paluṟu panya ini Isaacanya nyinaku, kaṉa palu puṟunytjuṯu palunya kalkuṉi panya ngayulu nyuntunya kalkuntja puṟunypa.” ");
INSERT INTO pjt_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Munu Godalu Aipuṟamala wangkara wiyaringkula palunya wantikatira anu. ");
INSERT INTO pjt_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","27","Ka tjiṉṯu pala palula panya Godalu palunya wangkanytja aṟa Aipuṟamalu wangaṉarangku kuliṟa palumpa katja Itjumailnga watiringkunytjaku palyaṉu munu palu puṟunypaṯu palyaṉu nyiṯayira uwankara palumpa ngurangka nyinanytja tjuṯa, panya palula waṟkaripai tjuṯa, tjiḻpi tjuṯa, wati tjuṯa, tjitji tjuṯa, iṯi tjuṯa kuḻu uwankara alatjiṯu. (Kutjupa tjuṯa ngaṉmanypa iṯi ngaringu Aipuṟamaku ngurangka, ka kutjupa tjuṯa paluṟu ngura kutjupangka payamilaṟa ngalya-katingu palula waṟkarinytjaku.) Ka wati kutjupangku Aipuṟamanya palu puṟunytjuṯu watiringkunytjaku palyaṉu panya Godalu wangkanytjitjangka. Nyara palula aṟa panya Aipuṟamanya tjiḻpi mulapa nyinangi yiya tjuṯa 99 nyinanytjatjanu. Ka panya palumpa katja Itjumailnga kungkatja nyinangi yiya 13 nyinanytjatjanu. ");
INSERT INTO pjt_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Ka Aipuṟamanya ngura miḻmiḻṯa ini Mamaṟaila nyinangi puṉu panya waṟa tjuṯangka itingka. Munu tjiṉṯu kutjupa paluṟu wiltjangka nyinangi kuḻi puḻkangka tiinta tjaangka, ka Mayatja Godanya palula utiringu. ");
INSERT INTO pjt_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Panya Aipuṟamalu watarku nyinara nyinara ma-ira-nyakula nyangu wati maṉkurpa ngurangka itingka ngaṟanyangka. Munu nyakula paluṟu mapalku pakaṟa ngapari-ngapari wirtjapakaṉu munu tjanala kuranyu tultjungaṟakatira tjananya waḻkuṉu ngalyangku manta pampuṟa. ");
INSERT INTO pjt_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Munu tjananya paluṟu markuṉu wangkara, “Wati wiṟu tjuṯa! Waara ankuwiyangkuya wantima munuya ngayuku ngurangka wanyu pakuwiyariwa tjukutjuku. Panya ngayulu nyuranya pukuḻmankunytjikitja mukuringanyi. ");
INSERT INTO pjt_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","5","Wanyu kaṉa ngayuku waṟkaripai kapiku witula nyuranku tjina paltjintjaku. Kaya wanyu puṉu nyanga wiltjangka nyinara pakuwiyariwa, kaṉa mai kuka mantjila nyura ngalkula paḻtja ankunytjaku. Nyangatjaṉa puḻkaṟa pukuḻaringu nyura ngayuku ngurangka wirkankunyangka. Wanyu, kaṉa nyurampa palyala.” Kaya alatji kuliṟa wangkangu, “Wiya wiṟunya! Pukuḻarinyila nyangangka nyuntula tjukutjuku nyinanytjikitja.” ");
INSERT INTO pjt_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ka Aipuṟamanya mapalku anu palumpa kurikutu tiinta unngu nyinanyangka munu wangkangu palula, “Tjiiṟa! Walangku mai uḻu wiṟu mantjila munu rungkaṟa paula.” ");
INSERT INTO pjt_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Munu paluṟu wirtjapakaṉu palumpa kuka tjuṯakutu munu puluka yangupala kaṉpi puḻka ngurkantaṟa mantjinu kuka tjula wiṟu mulapa munu ungu wati palumpa waṟkaripai, ka pungkula palyaṟa pauṟa warpungu. ");
INSERT INTO pjt_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ka Aipuṟamalu kuka panya pauntja munu puluka ipi, kuṟimi kuḻu mantjiṟa katira tjananya ungu wati panya maṉkurpa, kaya puṉu wiltjangka nyinara ngalkuningi. Ka Aipuṟamanya tjanala itingkaṯu ngaṟangi wiltja kutjupangka. ");
INSERT INTO pjt_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Kaya palula tjapinu, “Yaaltji nyuntumpa kuri Tjiiṟanya?” Ka wangkangu, “Pala tiinta unngu nyinanyi.” ");
INSERT INTO pjt_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Ka kutjungku palula wangkangu, “Ngulaṉa yiya kutjupa maḻaku pitjaku, ka nyara palula aṟa nyuntumpa kuringku Tjiiṟalu iṯi katja kanyilku.” Ka Tjiiṟanya tiinta tjaangka nyinara tjana wangkanyangka kuliningi. ");
INSERT INTO pjt_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","12","Munu paluṟu iṯi kanyintja wangkanyangka kuliṟa ikaringu, panya paluṟu pula kuriṟara pampa tjiḻpi mulapa iṯi kanyintjikitja wiya. Munu paluṟu ikaringkula kuliningi, “Yaaltjingaṟali iṯitjararingkuku? Ngali pampa tjiḻpi irititja kutjara.” ");
INSERT INTO pjt_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Ka Mayatjalu ikaringkunyangka kuliṟa Aipuṟamala wangkangu, “Nyaanguṟu Tjiiṟanya ikaringanyi? Paluṟu tjinguṟu anaṟa ikaringu ngayulu wangkanyangka. ");
INSERT INTO pjt_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Kulilaṉi! Kutjupa kutjupa wanyu wituwitu ngaṟanyi ngayulu puṯu palyantjaku? Wiya ngayulu ayinayiningku palyalpai alatjiṯu. Ka panya ngayulu wangkanytja mulapa alatjiriku. Ka yiya kutju wiyaringkunyangka ngayulu maḻaku pitjaku, ka Tjiiṟalu iṯi katja kanyilku.” ");
INSERT INTO pjt_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Ka Tjiiṟanya puḻkaṟa nguḻuringu munu nguḻungku ngunti wangkangu, “Ikaringkunytja wiyaṉatju nyinangi.” Ka wangkangu, “Wiya, nyuntu ikaringu alatjiṯu.” ");
INSERT INTO pjt_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Palulanguṟuya pakaṟa anu wati panya maṉkurpa. Ka Aipuṟamanya kuḻu tjanala unytju anu wangkara iyantjikitja tjananya. Munuya tjukutjuku ankula ngura kutjupangka wirkaṟa walunyangangi ngura tawunu ini Tjatamanya. ");
INSERT INTO pjt_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Ka Mayatjalu kuliningi, “Utiṉatju tjukaṟurungku Aipuṟamanya tjakultjunama ngayulu nyanga kulintja. ");
INSERT INTO pjt_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Panya Aipuṟamaku walytja ma-tjuṯaringkuku maḻatja maḻatja munuya winki mulararira tjana alatjiṯu manta walytjangku kanyilku. Ka panyaṉa palula tjanalanguṟu aṉangu manta winkitja palyaṟa pukuḻmankuku. ");
INSERT INTO pjt_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Panya ngayulu palunya ngurkantanu palumpa tjitji, munu palumpa walytja tjuṯa maḻatja maḻatja kuḻu paluṟu nintintjaku, tjana ngayula wangaṉarangku kuliṟa tjukaṟuru nyinanytjaku. Panya tjana ngayula kuliṟa tjukaṟuru nyinanyangkaṉa mulapa palyalku ngayulu Aipuṟamanya panya kalkuntja.” Alatji Godalu unngu kuliningi. ");
INSERT INTO pjt_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Munu palulanguṟu wangkangu Aipuṟamala, “Ngura tawunu puḻka kutjara nyara ngaṟanyi ini Tjatamanya pula Kumaranya. Palu tjukurpa kura kunyu tawunu nyanga palumpa pulampa ngaṟanyi. Panya ngayulu kulinu aṉangu ngura nyara kutjarangka nyinanytja tjuṯa kunyu kura puḻka mulararingu. ");
INSERT INTO pjt_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Kaṉa kulintjatjanungku kuwari ukalingkula ngura nyanga palunya pulanya nyanganyi. Munuṉa nyakula kulilku tjukurpa kura panyatja tjinguṟu mulapa, tjinguṟu ngunti, tjinguṟuya aṉangu tjuṯa kura puḻka nyinanyi, tjinguṟuya palya nyinanyi?” ");
INSERT INTO pjt_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Ka palulanguṟu wati kutjara maḻakukutuṟa anu ngura Tjatamalakutu. Palu Mayatjanya ankunytja wiya ngaṟangi Aipuṟamala munu pula tjukurpa ngaṟala wangkangi. ");
INSERT INTO pjt_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ka Aipuṟamalu Mayatjala arkaṟa tjapiningi nyanga alatji, “Nyuntu wanyu mulapa aṉangu tjukaṟuru nyinapai tjuṯa kuḻu wiyalku aṉangu kura tjuṯangka tjunguṟa? Nyaakun aṉangu palya tjuṯa kuḻu iluntankuku? ");
INSERT INTO pjt_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Tjinguṟuya aṉangu palya tjuṯa nyinanyi nampa 50 ngura nyara Tjatamala, ka nyuntu wanyu aṉangu winki wiyalku aṉangu palya tjuṯa kuḻu? Wanyu tjananya wantima iluntankuwiyangku panya aṉangu palya tjuṯa nampa panya 50 ilunytjaku-tawara. ");
INSERT INTO pjt_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Nyuntu wanyu aṉangu palya tjuṯa kuḻu iluntankuku aṉangu kura tjuṯangka tjunguṟa? Alatji wiya, panya nyuntu manta winkingka tjukaṟurungku ngurkantankupai munu panya nyuntu aṉangu palya munu aṉangu kura tjunguṟa palu puṟunymankuwiyangku wantipai.” ");
INSERT INTO pjt_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Ka Mayatjalu wangkangu, “Uwa palya! Ngayulu aṉangu palya nampa panya 50 Tjatamala nguriṟa nyakula palulanguṟu wantiku tawunu palunya aṉangu kuḻu wiyantja wiyangku.” ");
INSERT INTO pjt_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ka Aipuṟamalu piṟuku wangkangu kuṉṯa-kuṉṯangku, “Nyuntu panyan Mayatjanya, kaṉatju kurangku nyuntula arkaṟa wangkanyi. Wati mantatja ngayulu, nyuntula wangkanytjaku wiya nguwanpa. ");
INSERT INTO pjt_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Palu tjinguṟuya aṉangu palya tjuṯa nampa 45 kutju nyinanyi 50 wiya. Ka nyuntu wanyu aṉangu winki wiyalku aṉangu palya nampa 5 wiya ngaṟanyangka nampa panya 50-ngka ngaṯalpa?” Ka Mayatjalu wangkangu, “Wiya, ngayulu tawunu aṉangu winki wiyantja wiyangku wantiku aṉangu palya nampa 45 nyinanyangka nyakulampa.” ");
INSERT INTO pjt_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ka piṟukuṯu Aipuṟamalu palula arkaṟa tjapinu, “Palu tjinguṟuya aṉangu palya nampa 40 kutju nyinanyi. Kan nyaalku?” Ka Mayatjalu wangkangu, “Wiya palya, aṉangu 40 palya nyinanyangka nyakulaṉa palya wantiku.” ");
INSERT INTO pjt_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ka Aipuṟamalu piṟukuṯu wangkangu, “Tjinguṟutjun ngayuku mirpaṉariku piṟuku ngayulu wangkanyangka, palu wanyu-puṯa wantima ngayulu wangkanytjaku. Tjinguṟuya aṉangu palya nampa 30 kutju nyinanyi ngura pala palula.” Ka wangkangu, “Uwa palya, aṉangu 30 palya nyinanyangka nyakulaṉa wantiku.” ");
INSERT INTO pjt_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ka Aipuṟamalu piṟuku wangkangu kuṉṯa-kuṉṯangku, “Piṟukuṉanta wanyu tjapinma? Kurangkuṉa rawangku tjapini, palu wanyuṉi wantima ngayunya pailwiyangku. Palu tjinguṟu nyuntu aṉangu palya nampa 20 kutju nguriṟa nyakuku tawunu nyara palula? Nampa nyangatja nyakulan wantikuṯu?” Ka wangkangu, “Uwa, ngayulu nampa panya 20 nguriṟa nyakula ngura palunya wantiku wiyantja wiyangku.” ");
INSERT INTO pjt_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ka piṟukuṯu wangkangu, “Wanyu ngayuku mirpaṉariwiyangku wantima, kaṉa kutju-aṟa piṟuku wangkaku munuṉa palulanguṟu wangka wiyaringkuku. Palu tjinguṟu nyuntu nampa 10 kutju nguriṟa nyakuku? Munun yaaltjiriku?” Ka wangkangu, “Wiya palya, ngayulu tawunu palunya wiyantja wiyangku wantiku aṉangu 10 palya nyinanyangka nyakulampa.” ");
INSERT INTO pjt_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Munu alatji Aipuṟamala wangkara wiyaringkula Mayatjalu wantikatira anu, ka Aipuṟamanya maḻaku anu ngurakutu. ");
INSERT INTO pjt_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Ka angelpa panya kutjara mungartjirinyangka ngura Tjatamala wirkanu. Ka wati panya Lotaku ngura tawunu pala palula ngaṟangi. Ka paluṟu unytju tawunungka itingka ankula nyinangi kaitangka, iwarangka itingka. Munu paluṟu angelpa kutjara pitjanyangka nyakula mapalku pakaṟa ngaparikatingu munu pupakatira ngalyangku manta pampuṉu pulanya waḻkuntjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Munu wangkangu pulala, “Mayatja wiṟu kutjara! Ngayulu nyupalinya kanyintjikitja mukuringanyi. Wanyu pula pitja ngayuku ngurakutu munu tjina paltjiṟa mai ngalkula munga kutju ngari. Munu pula mungawinkilta ara.” Ka pula wangkangu, “Wiya palyantili uṟilta ngariku, nyanga waḻi tjuṯangka nguṟurpa.” ");
INSERT INTO pjt_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Palu Lotalu pulanya puḻkaṟa aḻṯingu, ka pula waṉaṉu munu palumpa waḻingka tjarpangu. Ka Lotalu mai nyuma pulampa palyaṉu mai panya pilytja yiitja wiyatja, ka pula ngalkula paḻtjaringu munu ngarinytjikitjangku kuliningi. ");
INSERT INTO pjt_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Palu panya pula ngarinytja kuwaripangka wati Tjatamanya nguraṟa winki pitjangu tjiḻpi, yangupala kuḻu Lotaku ngurakutu munuya waḻingka para-tjaṯutjuṟa anga-ngaṟangi. ");
INSERT INTO pjt_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Munuya mirara wangkangi Lotanya nyanga alatji, “Wati panya kutjarampa yaaltji panya munga nyanga kuwari pula pitjala nyuntula ngaṟangi? Ngalya-kati pulanya, panya nganaṉa pulala ngarinytjikitja mukuringanyi.” ");
INSERT INTO pjt_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","7","Ka Lotanya uṟilkutu pakaṉu tjananya wangkara markuntjikitja munu pakaṟa tuwa patiṟa tjanala wangkangi, “Maḻpa tjuṯa! Alatjingaṟa kuralwiyangkuya-puṯa wantima pulanya. ");
INSERT INTO pjt_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Palu kulila! Ngayulu uṉṯalpa kutjara kanyini watiku ngurpa kutjara. Wanyu kaṉa palunya pulanya ngalya-kati, kaya-puṯa mukuringkula palula pulala tjunguringama. Palu wati nyanga kutjaraya kuralwiyangku wantima, panya paluṟu pula ngayuku ngurakutu unytju pitjangu ngayulu aḻṯinyangka. Kaṉa ngayulu pulanya wiṟuṟa kanyini ngayuku ngurangka nyinanyangka.” ");
INSERT INTO pjt_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Palu wati panya tjuṯa Lotaku puḻkaṟa mirpaṉaringu munuya palula wangkangu, “Kitikitiriwa!” Munuyanku wangkangi, “Ai! Wati nyanga Lotanya malikitja pitjangu nganampa ngurakutu munulanya nyaaku wangkara tjukaṟuruṉi? Utilanya wantima paintja wiyangku panya paluṟu malikitja.” Munuya palunya wangkangu, “Kuwarilanya uwa wati panya pulanya! Ka nyuntu tjinguṟu ungkuwiyangku wantinyangkampa nganaṉa palunya pulanya kurantjatjanungku nyuntunya puḻkaṟa mulapa kuralku pulala waintaṟa.” Munuya kapuṯu-kapuṯurira palunya puḻkaṟa uṉṯuningi munuya tuwa kaṯantankunytjikitjangku kuliningi. ");
INSERT INTO pjt_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Palu wati panya kutjarangku waḻi unngunguṟu tuwa aḻaṟa Lotanya witiṟa ngalya-ilaṟa tjarpatjuṟa tuwa patinu. ");
INSERT INTO pjt_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Munu tjananya wati panya uṟilitja tjuṯa kuṟu patinu tjiḻpi, yangupala uwankara, kaya para-para-panytjunmaṟa puṯu tuwa pampuningi aḻantjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","13","Munu wati panya kutjarangku Lotala tjapinu, “Nyuntumpa walytja kutjupa ngura nyangangka nyinanyi? Tjinguṟu katja, uṉṯalpa, munta waputju? Ka-puṯa tjananya mantjiṟa ma-kati ngura nyanganguṟu, panya kuwarili tawunu nyangatja wiyaṉi aṉangu winki. Panya nyangatja nguraṟa tjuṯa kura mulararingu, ka Mayatja Godalu kulinu aṉangu ngura kutjupitja tjuṯangku tjananya puntuṟa wangkara waṉinyangka. Munulinya iyaṉu ngura winki wiyantjaku.” ");
INSERT INTO pjt_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Ka Lotalu kuliṟa anu palumpa waputju kutjarakutu palumpa panya uṉṯalpa kutjaraku kalkuntjitjakutu, munu pulala alatji wangkangu, “Warpungkula pula ngalya-pakala munu ngura nyangatja wantikati. Panya Mayatja Godalu kuwari tawunu nyanga palunya wiyaṉi aṉangu winki.” Palu nyanga pula mulamularingkuwiyangku ngunti-palku kuliningi ngalypa-ngalypangku wangkanyangka-palku. ");
INSERT INTO pjt_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Ka mungawinki mulapa ngalya-tjiṉṯuringkunyangka angelpa panya kutjarangku Lotanya walawalaningi wangkara, “Walawala warpungkula pakala munu nyuntumpa kuri uṉṯalpa kutjara kuḻu ma-kati ngura nyanganguṟu ilunytjaku-tawara, panya kuwarili ngura winki wiyaṉi aṉangu tjuṯa kuḻu.” ");
INSERT INTO pjt_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Ka Lotalu warpungkunytja wiyangku purkaṟangku kuliningi. Palu Godanya wati panya palumpa ngaḻṯuringu palunya wankaṟunkunytjikitja, ka angelpa panya kutjarangku palunya miṉaṟa pakaltjingaṟa katingu uṟilkutu palumpa kuri munu uṉṯalpa kutjara kuḻu. ");
INSERT INTO pjt_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Munu palulanguṟu Tjatamala uṟilnguṟu angelpa kutjungku tjananya wankaṟunkunytjikitjangku ma-iyaṉu alatji wangkara, “Ma-wirtjapakalaya puḻi murpukutu wankakitja! Munuya nguṟurpa ngaṟanytja wiyangku wantima munu maḻakukutuṟa nyakuwiyangku kuḻu wantima ilunytjaku-tawara.” ");
INSERT INTO pjt_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","19","Ka Lotalu wangkangu palula, “Nyupali panya nganaṉanya wiṟuṟa kulinu munulanya wankaṟunu. Palu wanyulanya parari witulwiyangku ila nyinanytjaku wangka. Nyaakun puḻi pararitjaku wituṉi? Tjinguṟula ngaṯalpaṯu iluku nyupali tawunu nyangatja wiyannyangka. ");
INSERT INTO pjt_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Palu nyaratja nyawa, tawunu nyara tjukutjuku. Nyara paluṟu tjinguṟu ila nguwanpa ngaṟanyi, kantila nyara palula wirtjapakaṟa tjarpara wankaringkuku ngaṯalpa ilunytja wiya. Tawunu nyara paluṟu tjukutjuku paṯu nguwanpa wiyantjaku wiya. Nyara palulakutulanya wanyu witula wankaringkunytjaku pararitjaku witulwiyangku.” ");
INSERT INTO pjt_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Ka tjananya wangkara wituṉu, “Uwa palya, nyara palulakutu wirtjapakala, kaṉa ngura palunya wantiku piḻuntankunytja wiyangku. ");
INSERT INTO pjt_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Palu wala puḻkaya ma-wirtjapakala. Panya nyura kuwaripa ma-pitjanyangkaṉa wantinyi pungkuwiyangku kuwaripangku paṯaṟa, palu nyara palula ma-wirkankunyangka kutjuṉa tawunu nyangatja piḻuntaṟa wiyalku. Walawalaya ma-pitja!” Alatji angeltu tjananya wangkara wituṉu. (Ka ngura tjukutjuku panya paluṟu ini Tjuwanya panya ini “tjuwa” wangkanyi “tjukutjuku” palumpa tjanampa wangkangku.) ");
INSERT INTO pjt_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Ka Lotanya tjana munga waṟangka wala puḻka ankula ngura nyara Tjuwala wirkanu tjiṉṯu ngalya-pakannyangka. ");
INSERT INTO pjt_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Ka nyara palula aṟa Godalu ilkaṟinguṟu purku tili winki iyaṉu puḻka mulapa mantakutu tawunu panya Tjatamala Kumarala pulala punkantjaku. ");
INSERT INTO pjt_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Ka kampara alatjiṯu wiyaṉu tawunu nyara kutjarangka waḻi, aṉangu uwankara kuḻu munu tawunu pala kutjarangka uṟilta kuḻu pilangka ukiṟi, puṉu, puṯi uwankara kampara nyaṟuṉu, aṉangu winki kuḻu uṟilta pilangka nyinanytja tjuṯa kuḻu wiyaṉu. Ka ngura nyara paluṟu nyaṟuringu alatjiṯu. ");
INSERT INTO pjt_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Palu Lotaku kuri maḻaringangi nguwanpa munu maḻakukutuṟa Tjatamanya nyangu munu tjalturingkula mantangka tjakatjunu iwitiwiti waṟa puṟunypa. ");
INSERT INTO pjt_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Ka tjiṟirpingka Aipuṟamanya tjiṉṯukutu pakaṟa tatinu ngura panya Mayatja Godanya pula ngaṟanytjalakutu. ");
INSERT INTO pjt_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Munu wirkaṟa walunyangangi Tjatamanya Kumaranya pulanya ngaṉmanypa ngaṟanytjitja, munu nyangu puyungaṟala waṉannyangka manta winkingka puḻka mulapa waṟu wanangaṟangku rungkaṟa tilintja puṟunypa. ");
INSERT INTO pjt_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Palu panya Aipuṟamalu ngaṉmanytju Godala tjapinu aṉangu palya tjuṯa Tjatamalanguṟu wankaṟunkunytjaku. Ka panya Godalu kulinu Aipuṟamalu tjapintja munu panya palumpa katja Lotanya wankaṟunu palumpa kuri munu uṉṯalpa kutjara kuḻu. Munu maḻangka kutju Tjatamanya tjananya ngura panya tjuṯa waṟungka wiyaṉu aṉangu winki. ");
INSERT INTO pjt_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Ka Lotanya ngura panya Tjuwala nyinanytjaku nguḻuringangi munu paluṟu tjana uṉṯalkira uṉṯalkira anu puḻikutu munuya tatiṟa kuḻpingka ngura tjunkula nyinangi. ");
INSERT INTO pjt_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Ka kangkuṟungku palumpa maḻanypa wangkangu nyanga alatji, “Panya Mamanya ma-tjiḻpiringanyi kuwari, ka wati kutjupa tjuṯa wiya ngaṟanyi ngalila tjitji utintjaku. ");
INSERT INTO pjt_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Utili Mamanya waina ungama, ka tjikiṟa taṟangkarira ngalila ngarima, munulinya tjitjitjaralku palumpa walytjapiti piṟuku ma-tjuṯaringkunytjaku maḻatja maḻatja.” ");
INSERT INTO pjt_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Munu pula mungaringkunyangka mulapaṯu Lotanya waina puḻka ungu, ka tjikiṟa taṟangkaringu, ka kangkuṟu palula tjunguringkula ngaringu. Palu Lotalu kulintja wiya alatjiṯu uṉṯalpa palula tjunguringkunyangka, panya paluṟu puḻkaṟa taṟangkarira watarku ngaringi. ");
INSERT INTO pjt_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Ka tjiṉṯungka kangkuṟungku wangkangu palumpa maḻanypa, “Ngayulu panya Mamala mungangka ngaringu, kali uti piṟuku palunya waina puḻka ungama munga nyanga kuwari, ka nyuntulpi palula tjunguringkula ngarima kali kutjaraṯu tjitjitjarariwa.” ");
INSERT INTO pjt_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Munu pula mungaringkunyangka piṟuku waina puḻka ungu mama panya, ka taṟangkaringu. Ka kungkawaṟa panya maḻanypa ngapartji mamangka tjunguringkula ngaringu. Ka Lotalu kulintja wiya alatjiṯu palula tjunguringkunyangka, panya paluṟu palu puṟunypaṯu taṟangka puḻka watarku ngaringi. ");
INSERT INTO pjt_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Alatji Lotaku uṉṯalpa kutjara iṯitjararingu mama walytjangku taṟangkangku tjitji utinnyangka. ");
INSERT INTO pjt_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Ka kangkuṟungku iṯi katja kanyinu munu palunya ininu Mawapanya. Ka tjitji nyanga palulanguṟu aṉangu ma-tjuṯaringu munuya winki mulararingu maḻatja maḻatja aṉangu panya Mawapakunu tjuṯa. ");
INSERT INTO pjt_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Ka maḻanypangku kuḻu iṯi katja kanyinu munu palunya ininu Pinaminya. Ka tjitji nyanga palulanguṟu aṉangu ma-tjuṯaringuṯu munuya winki mulararingu maḻatja maḻatja aṉangu panya Aimankunu tjuṯa. ");
INSERT INTO pjt_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","2","Ka Aipuṟamanya ngura panya Mamaṟainya wantikatira anu uḻpaṟira munu ngura tjunkula nyinangi pilangka Kainanta uḻpaṟira ngura ini Katitjala pulala Tjuula nguṟurpa. Munu palulanguṟu piṟuku ankula ngura kutjupangka ini Kiṟarta ngura tjunkula nyinangi. Palu ngura Kiṟarku mayatja nyinangi wati ini Pimalikanya. Ka Aipuṟamalu ngura pala palula nyinara nguratja tjuṯangka wangkangi nyanga alatji, “Minyma nyanga Tjiiṟanya ngayuku maḻanypa.” Alatji paluṟu kuri palumpa maḻanypanmanangi. Ka mayatja panya Pimalikalu wati palula waṟkaripai wituṉu ankula Tjiiṟanya mantjiṟa ngalya-katinytjaku, panya mayatja paluṟu palunya aḻṯinytjikitja mukuringangi. Ka mulapaṯu ankula mantjiṟa ngalya-katingu, palu Pimalikalu minyma palunya aḻṯinytja wiyangku kanyiningi kuwaripangku. ");
INSERT INTO pjt_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ka munga kutjupa Godanya utiringu Pimalikala paluṟu ngarira tjukurmankunyangka munu wangkangu palula, “Nyuntu kuwari ilunyi minyma nyanga palunya aḻṯirampa, panya paluṟu ngaṉmanytju aḻṯinytja, kuritjara.” ");
INSERT INTO pjt_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Palu Pimalikalu Tjiiṟanya panya aḻṯinytja wiyaṯu nyinangi kuwaripa munu palulanguṟu Godala wangkangu alatji, “Mayatja, ngayuluṉa watarkungku wangkangi palunya ngalya-katinytjaku aḻṯinytjikitjangku, palu aḻṯinytja wiyaṯuṉa kuwaripa paṯaningi. Kaṉin nyaaku ngayunya iluntankuku ngayuku aṉangu tjuṯa kuḻu? Nganaṉala tjukaṟuru nyinanyi. ");
INSERT INTO pjt_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Palu Aipuṟamalu panya walytjangku Tjiiṟanya maḻanypanmanu, ka minyma panya paluṟu palu puṟunypaṯu Aipuṟamanya kuṯanmanangi. Kaṉa ngunti mulamularingu munuṉa kuri wiya-palku mantjinu ngurpangku, palu kuralwiyaṯuṉa.” ");
INSERT INTO pjt_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Ka Godalu palula piṟuku wangkangu, panya ngarira tjukurmankunyangka nyanga alatji, “Uwa, ngayulu ninti panya nyuntu tjukaṟurungku palunya mantjinu ngurpangku kurantjikitjangku wiya. Palulanguṟuṉa nyuntunya anga-kanyinu ngayula tungunpungkula kuraringkunytjaku-tawara, munuṉanta angatjunu nyuntu minyma palunya pampuntjaku-tawara. ");
INSERT INTO pjt_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Palu kuwari minyma nyanga palunya maḻakungku uwa wati palumpa kuri. Wati paluṟu panya ngayuku wangkatjara, munu paluṟu ngayula tjapilku nyuntumpa, kaṉanta wantiku iluntankunytja wiyangku. Palu nyuntu maḻakungku ungkuwiyangku wantirampa kulinma panya nyuntu munu nyuntumpa aṉangu tjuṯa uwankara iluku.” Alatji Godalu Pimalikala wangkangu paluṟu ngarira tjukurmankunyangka. ");
INSERT INTO pjt_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Ka mungawinki mulapa Pimalikalu palumpa mayatja tjukutjuku tjuṯa uwankara aḻṯira tjakultjunu panya Godalu palula mungangka wangkanytja, kaya kuliṟa puḻkaṟa nguḻuringu. ");
INSERT INTO pjt_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","10","Ka Pimalikalu Aipuṟamanya aḻṯira wangkangu, “Nyaakun nganaṉanya ngunti kuraṉu? Ngayulu wanyu kutjupa kutjupa nyuntumpa kuraṉu, kan ngapartji ngayunya kuraṉi? Nyaakun alatji palyaṉi?” ");
INSERT INTO pjt_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ka Aipuṟamalu wangkangu, “Wiya, nguntiṉa kulinu ngura nyanga Kiṟarnga nguraṟa tjuṯa Godaku ngurpa-palku. Munuṉa kuliningi, ‘Tjinguṟuṉiya minymakitjangku pungkula iluntankuku.’ ");
INSERT INTO pjt_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Palu mulapa minyma nyanga paluṟu ngayuku maḻanypa. Mama kutjutjali, palu ngunytju kutjupa kutjupalimpa. Kaṉa palunya aḻṯira kanyini ngayuku kuri. ");
INSERT INTO pjt_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Ka panya Godalu ngayunya mamaku nguranguṟu wantikatira ankunytjaku wituṉu, kaṉa ankula ngura kutjupangka wirkaṟa minyma palula wangkapai nyanga alatji, ‘Ngayuku mukuringkulampa aṉangu malikitja nyakula palula wangka panya ngayuluṉa nyuntumpa kuṯa. Alatji wangka ngayunya aṯunymankunytjikitjangku, palya.’ Alatjiṉa ngayulu Tjiiṟanya wangkapai.” ");
INSERT INTO pjt_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Ka palulanguṟu Pimalikalu Tjiiṟanya maḻakungku ungu Aipuṟamanya munu kuka kutjupa kutjupa tjuṯa kuḻu Aipuṟamanya ungu tjiipi tjuṯa, puluka tjuṯa, munu wati kungkawaṟa waṟkaripai tjuṯa kuḻu palunya ungu paluṟu tjana palumpa waṟka tjuṯa nyinanytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Munu wangkangu Aipuṟamala nyanga alatji, “Nyangatja uwankara ngayuku manta, ka nyuntu nguraku mukuringkula manta nyanga lipiwanungku para-nguriṟa nyawa munu manta wiṟu ngurkantara ngura tjunkunytjikitjangku.” ");
INSERT INTO pjt_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Munu paluṟu Tjiiṟanya wangkangu, “Ngayulu kuwari unganyi nyuntumpa kuṯa mani panya tjiilpa puḻka mulapa nampa 1,000. Alatjiṉa unganyi panya aṉangu nyuntula nyinanytjitja tjuṯangku nyuntunya palya ngurkantankunytjaku tjana ngunti pampuntja kulintjaku-tawara. Mani nyanga palulanguṟuya nyuntunya kulilku palya mulapa.” ");
INSERT INTO pjt_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Ka nyara palula-aṟangka Pimalikaku kuri munu palumpa minyma waṟkaripai tjuṯa kuḻu tjitji wiya alatjiṯu nyinangi. Panya Godalu tjananya tjitjiku wiyaṉu Tjiiṟanya tjanala tjunguringkula nyinanyangka. Ka maḻangka Tjiiṟanya maḻakungku ungkunyangka Aipuṟamalu Pimalikaku tjanampa Godala tjapiningi, ka Godalu tjananya piṟuku tjitjitjararingkunytjaku palyaṉu. ");
INSERT INTO pjt_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","2","Ka Mayatja Godalu ngaṉmanytju kalkuntjatjanungku Tjiiṟanya palyaṟa pukuḻmanu tjitjitjararingkunytjaku. Ka mulapaṯu iṯitjararingu munu tjiḻpi Aipuṟamaku katja kanyinu panya palula aṟa, panya Godalu ngaṉmanytju kalkuṉu. ");
INSERT INTO pjt_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ka Aipuṟamalu iṯi palunya ininu “Isaacanya”. ");
INSERT INTO pjt_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Munu tjiṉṯu 8 ngaṟala wiyaringkunyangka Aipuṟamalu iṯi palunya watiringkunytjaku palyaṉu, panya alatjingantjaku Godalu wangkangu. ");
INSERT INTO pjt_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Nyara palula aṟa Isaacanya iṯi wirkankunyangka palumpa panya mama Aipuṟamanya tjiḻpi mulapa nyinangi yiya 100 nyinanytjatjanu. ");
INSERT INTO pjt_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Ka Tjiiṟalu wangkangu, “Godaluṉi iṯi nyanga palunya ngayunya ungkula puḻkaṟa mulapa pukuḻmanu munuṉi ikaritjingaṉu. Kaya kuwari aṉangu kutjupa tjuṯa ngayulu iṯi kanyintja kuliṟa puḻkaṟa pukuḻarira ikaringkuku ngayula tjungu. ");
INSERT INTO pjt_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Aṉangu tjuṯangkuya kuliningi ngayulu minyma tjitjiku ngurpa, palu kuwariya kuliṟa urulyaralku panya ngayulu tjiḻpi Aipuṟamaku iṯi kanyinnyangka. Paluṟu panya wati irititja mulapa palu nyawalta, kuwari iṯi katjatjararingu.” Alatji Tjiiṟalu pukuḻarira wangkangi. ");
INSERT INTO pjt_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Ka iṯi panya paluṟu ngunytju ipi tjikiṟa puḻkaringu munu puḻkaringkula maiku ngapartjilta nintiringu. Ka nyara palula aṟa panya ngunytju ipi wantinyangka palumpa mamangku Aipuṟamalu mai puḻka mulapa palyaṉu aṉangu tjuṯangku pitjala ngalkuntjaku palumpa katjaku pukuḻarira. ");
INSERT INTO pjt_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ka minyma panya Aikanya Aipuṟamaku ngurangka kuwaripaṯu nyinangi palumpa panya waṟkaripai, minyma panya Itjipanya nguraṟa. Ka panya minyma nyanga palula Aipuṟamalu ngaṉmanytju utinu katja panya ini Itjumailnga. Ka kutjupa-aṟa Tjiiṟalu nyangangi palumpa katja tjukutjuku Isaacanya kuṯangku inkatjingannyangka. ");
INSERT INTO pjt_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Munu paluṟu nyakula unngu nyaṟaringkula wangkangu Aipuṟamanya, “Minyma pala waṟkaripai katjaṟara pulanya paiṟa iyala. Panya ngayulu mukuringkunytja wiya minyma pala palumpa katjangku nyuntu ngula ilunyangka nyuntumpa ulytja, kuka tjuṯanguṟu kuḻu mantjintjaku. Uti ngayuku katjangku kutju mantjinma nyuntumpa kutjupa kutjupa uwankara nyuntu ilunyangka.” ");
INSERT INTO pjt_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Ka Aipuṟamalu nyangatja kuliṟa puḻkaṟa tjituṟu-tjituṟuringu kuliṟa, “Nyaakuṉatju paiṟa iyalku ngayuku tjitjitjara?” ");
INSERT INTO pjt_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Palu Godalu tjituṟu-tjituṟurinyangka nyakula wangkangu Aipuṟamala, “Tjituṟu-tjituṟurinytja wiyangku wantima nyuntumpa katjanguṟu minyma pala nyuntumpa waṟkanguṟu kuḻu. Palu Tjiiṟalu nyuntula wangkanyangka wantiwiyangku palyala. Panya ngayulu nyuntunya kalkuṉu nyuntumpa kuri Tjiiṟalanguṟu nyuntumpa walytja ma-tjuṯaringkunytjaku maḻatja maḻatja mungilyi mulapa nyinanytjaku. Ka kalkuntja nyanga paluṟu ma-tjuṯaringkuku Tjiiṟaku katjanguṟu pala Isaacalanguṟu, Itjumailtanguṟu wiya. ");
INSERT INTO pjt_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Palu ngayulu minyma nyuntumpa waṟkaripaiku katja tjitji tjuṯaṯu ungkuku, panya tjitji paluṟu kuḻu nyuntumpa katja, Itjumailnga. Ka palumpa walytja kuḻu ma-tjuṯaringkuku maḻatja maḻatja munuya mungilyi mulapa nyinaku.” ");
INSERT INTO pjt_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ka mungawinki mulapa Aipuṟamalu pakaṟa mai mantjiṟa mina tjutiṉu yakutja puṟunytja kuka panya miṟinguṟu palyantjitjangka munu minyma panya Aikala piningka tjunkula palunya pulanya katjaṟara nguranguṟu wituṟa iyaṉu. Ka pula Aipuṟamanya wantikatira anu munu pula ilytjingka para-pitjalinangi ngura ini Piitjiipala itingka. ");
INSERT INTO pjt_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Munu mina wiyaringkunyangka minyma paluṟu katja wiltjangka tjunkula wantingu puṉu muṯumuṯungka. ");
INSERT INTO pjt_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Munu tjukutjuku ankula paṯupaṯu nyinakatingu kuliṟa, “Katjanyatju nguwanpa ilunyi, ngaḻṯutjara. Kaṉa wanyu paṯu nyinama ngayula miṟangka ilunytjaku-tawara.” Munu paluṟu nyinara puḻkaṟa ulangi. ");
INSERT INTO pjt_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Ka Godalu tjitji panya ulanyangka kulinu munu angelpa wituṉu palumpa ngunytjungka ilkaṟinguṟu wangkanytjaku. Ka palula wangkangu alatji, “Aika! Nyaaringkulan tjituṟu-tjituṟu nyinanyi? Nguḻuringkunytja wiya panya Godalu kulinu nyuntumpa katja wailu-wailu ngarira ulanyangka. ");
INSERT INTO pjt_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Pakaṟa ara palulakutu munu palunya maṟa witiṟa pakaltjinganma munu ampuṟa pukuḻmanama. Panya ngayulu ngula palyalku tjitji nyanga palulanguṟu walytjapiti winki mulararinytjaku maḻatja maḻatja.” ");
INSERT INTO pjt_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Munu palulanguṟu Godalu minyma palunya kuṟu aḻaṉu, ka paluṟu kuṟu aḻaringkula nyangu mina piṯi munu ankula yakutjangka tjutiṟa katira ungu palumpa panya katja, ka tjikiṟa palyaringu. ");
INSERT INTO pjt_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","21","Ka Godalu tjitji palunya puḻkaringkunyangka aṯunymaṟa kanyiningi. Ka paluṟu ngura ini Paṟanta nyinangi talingka munu punaṟaku ninti puḻkaringkula kukaputju alatjiṯu nyinangi. Ka palumpa ngunytjungku kungkawaṟa ngura Itjipanya nguraṟa mantjinu palumpa katjangku aḻṯinytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Ka kutjupa-aṟa ngura panya Kiṟarku mayatja puḻkangku Pimalikalu palumpa maḻpa ini Pikalnga aḻṯira katingu. (Pikalnga panya palumpa warmaḻa tjuṯaku mayatja.) Munu pula Aipuṟamalakutu ankula palula wangkangu, “Godanya mulapa nyuntula tiṯutjara ngaṟanyi nyuntu kutjupa kutjupa uwankara palyannyangka. Paluṟunta mulapa alpamilalpai. ");
INSERT INTO pjt_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Palu kuwariṉi nyuntu ngayunya Godala miṟangka kalkunma nyanga alatji. Ngayunya ngunti kuralwiyangku tjukaṟurungku wangkama ngayuku walytja uwankara kuḻu ngunti kurantja wiyangku wantima, munu ngayuku pakaḻi puḻiri tjuṯangka kuḻu maḻatja maḻatjangka tjukaṟurungku wangkama. Panya nyuntu ngura nyanga palula pitjala malikitja nyinanyangka ngayulu nyuntumpa maḻpa wiṟu nyinangi kalypa mulapa, ka wanyu palu puṟunypaṯu ngayuku maḻpa wiṟu nyinama munu ngura nyanga Kiṟarnga nguraṟa tjuṯaku kuḻu kalypa nyinama. Alatji wanyu nganaṉanya kalkunma kalypa wiṟu nganampa nyinanytjikitjangku.” ");
INSERT INTO pjt_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ka Aipuṟamalu wangkangu, “Uwa palya, ngayuluṉa nyuranya alatji kalkuṉi nyurampa kalypa wiṟu nyinanytjikitjangku.” ");
INSERT INTO pjt_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Munu Aipuṟamalu piṟuku kutjupa kutjupa wangkangu Pimalikala nyanga alatji, “Ngayuku wati tjuṯangku mina piṯi tjawaṉu, palu maḻangkaya nyuntumpa wati waṟkaripai tjuṯangku pitjala mina palunya angatjuṟa kanyini walytjangku-palku.” ");
INSERT INTO pjt_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Ka Pimalikalu wangkangu, “Wiya ngayulu ngurpa nganalu tjananya wituṉu mina nyara palunya angatjuṟa kanyintjaku? Nyuntu panyaṉin ngaṉmanytju wangkanytja wiyaṯu. Kaṉa kuwari kutju nyanga kulinu ngurpangku.” ");
INSERT INTO pjt_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Ka palulanguṟu Aipuṟamalu kuka tjuṯa Pimalikanya ungu, panya tjiipi tjuṯa munu puluka tjuṯa. Munu paluṟu pulanku ngaparku kalkuṉu. ");
INSERT INTO pjt_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ka Aipuṟamalu palumpa tjiipi tjuṯanguṟu lamalama kungka 7 tjaraṟa mauṉṯalpa tjunu. ");
INSERT INTO pjt_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Ka Pimalikalu nyakula palula tjapinu, “Nyaakun alatjinanyi?” ");
INSERT INTO pjt_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ka Aipuṟamalu wangkangu, “Wiya, nyuntu lamalama nyanga nampa 7 mantjila, panya alatji ngayulu nyuntunya ungkunyangka aṉangu tjuṯangku nyakula mulapa kulilku panya ngayulu mina piṯi panya palunya tjawantja.” Alatji Aipuṟamalu mulamularingkunytjaku ungkula palula wangkangu Pimalikala. ");
INSERT INTO pjt_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Kaya ngura palunya ininu Piitjiipanya panya nyara palula Aipuṟamalu pula Pimalikalu wangkara pulanku kalkuṉu ngapartji-ngapartjingku. ");
INSERT INTO pjt_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Ka pulanku alatji wangkara kalkunnyangka Pimalikanya pula maḻpaṟara ini panya Pikalnga maḻaku anu ngura Pilitjiyalakutu. ");
INSERT INTO pjt_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ka Aipuṟamalu ngura pala palula Piitjiipala manta tjawaṟa puṉu uṉinypa ini Tamaṟika tjunu puṉu puḻka pakantjaku. Munu paluṟu Mayatjanya waḻkuningi, God Tiṯutjara Nyinapainya. ");
INSERT INTO pjt_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Munu Aipuṟamanya manta nyara Pilitjiyala rawa mulapa nyinangi. ");
INSERT INTO pjt_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Ka ngula Godalu Aipuṟamanya arkantjikitjangku aḻṯingu, “Aipuṟama!” Ka wangkangu, “Uwa! Nyangatjaṉa nyinanyi!” ");
INSERT INTO pjt_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ka Godalu wangkangu, “Nyuntu panya katja kutjukuṟutjaku Isaacaku puḻkaṟa mukuringanyi. Palu kuwari palunya mantjiṟa kati ngura nyara ini Muṟiyalakutu. Kaṉanta nyara palula puḻi murpu panya nintilku nyupali katjaṟara tatintjaku. Ka nyuntu puḻi nyara palula katu palunya pitjilpangka katu ngaritjura munu palunya pungkula waṟungka tjura kampara mulururinytjaku ngayunya waḻkuṟa ungkunytjikitjangku.” ");
INSERT INTO pjt_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ka mungawinki mulapa Aipuṟamalu pakaṟa waṟu tjiwuru alkaṟangka atuṟa tangkiyingka tjunkula karpiṉu. Munu palumpa katja Isaacanya aḻṯingu wati palumpa waṟkaripai kutjara kuḻu, munuya tjunguringkula ma-pakaṉu ngura panya palulakutu panya Godalu wangkanytjalakutu. ");
INSERT INTO pjt_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Munu ankula ankula tjiṟirpi maṉkurarira Aipuṟamalu ngura palunya nyangu parari wati-ngarinyangka. ");
INSERT INTO pjt_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Munu paluṟu wati waṟka kutjara markuṟa wantikatingu, “Nyangangka pula nyinama tangkiyitjara paṯaṟa, kali katjanya ngali nyarangka ananyi Godanya waḻkuntjikitja, munuli waḻkuṟa wiyaringkula maḻaku piṟuku pitjanyi nyupalilakutu.” ");
INSERT INTO pjt_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","7","Munu Aipuṟamalu Isaacanya waṟu panya tjiwuru katinytjaku ungu munu paluṟunku tjuḻa, waṟu tjangi kuḻu katingi. Munu pula anangi, ka Isaacalu wangkangu Aipuṟamala, “Mama!” Ka wangkangu, “Uwa katja, nyaa?” Ka wangkangu, “Mama, ngayulu nyanganyi waṟu tjangi tjiwuru kuḻu ngali katira, palu kuka lamalama wanyu yaaltji pungkula waṟungka Godanya waḻkuṟa ungkunytjaku?” ");
INSERT INTO pjt_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ka Aipuṟamalu wangkangu, “Wiya katja! Godalulinya paluṟu alatjiṯu walytjangku lamalama unganyi, ka ngali palunya muluruṟalta unganyi.” Munu pula kuwaripaṯu anangi. ");
INSERT INTO pjt_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Munu pula ankula ankula wirkanu ngura panya palulalta, panya Godalu palunya ngaṉmanytju wangkanytjitjangka. Ka Aipuṟamalu wirkaṟa pitjilpa puḻka palyaṉu munu kurultjunu pitjilta katu. Munu tjitji panya witiṟa ruupangka karpiṉu munu mantjiṟa pitjilta ngaritjunu kurulta katu. ");
INSERT INTO pjt_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Munu palulanguṟu tjuḻa mantjiṟa nguwanpa muṟutjunu liringka iluntankunytjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Ka ilkaṟinguṟu Mayatjaku angeltu palula mirara wangkangu, “Aipuṟama! Aipuṟama!” Ka wangkangu, “Uwa, nyangatjaṉa ngaṟanyi!” ");
INSERT INTO pjt_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Ka tjitjiku ngalkiltu anga-wangkangu alatji, “Tjitji palatja wantima pungkuwiyangku. Panya kuwariṉa nintiringu mulapa nyuntu Godala wangaṉarangku kulilpai, munu palan wangaṉara mulatu katja pala kutjukuṟutja nyuntumpa Godanya ungkunytjikitjangku kuliningi wantiwiyangku.” ");
INSERT INTO pjt_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ka Aipuṟamalu maḻakukutuṟa nyangu kuka rama ila ngaṟanyangka puṉungku yuṟuwilya witiṟa kanyinnyangka. Munu ankula rama panya mantjiṟa katira palunya ngalkilpa pungkula pitjilta katu tjunu waṟungku kampara mulurunkunytjaku palumpa katjaku aṟangka. Alatji paluṟu palyaṉu Godanya waḻkuṟa ungkunytjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Munu Aipuṟamalu ngura nyara palunya ininu nyanga alatji “Mayatja Godalu Ungkunytjanya”. Ka palulanguṟu kuwari aṉangu tjuṯangku alatji wangkapai, “Mayatja Godalu palumpa puḻingka ungkupai.” ");
INSERT INTO pjt_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","16","Ka Mayatjaku angeltu ilkaṟinguṟu piṟuku Aipuṟamala wangkangi alatji, “Mayatja Godalu nyuntunya alatji wangkangu, ‘Ngayuluṉanta mulamulangku kalkuṉi ngayulu alatjiṯu nyuntunya puḻkaṟa pukuḻmankunytjikitjangku, panya nyuntu ngayunya wangaṉarangku kuliṟa nyuntumpa katja kutjukuṟutja ngayunya nguwanpa pungkula ungangi wantinytja wiyangku. ");
INSERT INTO pjt_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Kaṉa nyuntunya kalkuṉi nyuntumpa walytja ma-tjuṯaringkunytjaku maḻatja maḻatja, kaya mungilyi mulapa nyinaku kililpi tjuṯa puṟunypa munu paki puṟunypa, panya paki kuḻuny-kuḻunypa uṟu puḻkangka itingka nyinapai, palu puṟunypa nyuntumpa walytja ma-tjuṯaringkuku maḻatja maḻatja munuya tjuṯa mulararira nyinaku munuya malikitja tjuṯa warmaḻarira pitjanyangka pungkula wiyalku munuya ankula tjanampa ngura tjuṯaku mayatjariku. ");
INSERT INTO pjt_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Uwa, nyuntu ngayula wangaṉarangku kulinu, ka nyara palulanguṟuṉa ngayulu nyuntumpa walytjapitinguṟu aṉangu manta winkitja palyaṟa pukuḻmankuku.’ Nyanga alatjinta Mayatja Godalu wangkanyi mulamulangku.” Alatji angeltu ilkaṟinguṟu Godaku tjukurpa Aipuṟamala tjakultjunu. ");
INSERT INTO pjt_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Ka Aipuṟamanya pula katjaṟara maḻaku anu wati panya waṟkaripai kutjarakutu, munuya tjunguringkula maḻaku anu ngurakutu Piitjiipalakutu. Munuya ngura pala palula rawa nyinangi. ");
INSERT INTO pjt_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Ka ngula tjakulpa Aipuṟamala wirkanu munu wangkangu nyanga alatji, “Nyuntumpa panya maḻanypa Nayulu kungka ini Milkanya iriti aḻṯingu munu pula tjitji tjuṯatjararingu munu pula kuwari katja 8-tjara nyinanyi. ");
INSERT INTO pjt_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","22","Ngaṉmanytju pula katja ini Uutjanya kanyinu, ka Uutjalu pininu Puutjanya, ka Puutjalu pininu Kimuwilnga (panya Aṟamaku mama), ka Kimuwiltu pininu Kitjatanya, ka Kitjatalu pininu Aatjunya, ka Aatjulu pininu Piltatjanya, ka Piltatjalu pininu Tjitilapanya, ka Tjitilapalu pininu maḻatja ini Pitjuwilnga.” ");
INSERT INTO pjt_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Ka Pitjuwiltu panya ngula uṉṯalpa ini Ripikanya utinu. ");
INSERT INTO pjt_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Ka Nayulu kuri kutjupa kuḻu kanyiningi ini Raumanya Milkaku panya ngaṉati. Munu paluṟu Nayuku tjitji kutjara kutjara kanyinu ini nyanganpa – Tipanya, Kayamanya, Tayatjanya, munu Maakanya. ");
INSERT INTO pjt_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","2","Ka Aipuṟamaku kuri Tjiiṟanya pampa mulararira ilungu yiya panya nampa 127 nyinanytjatjanu. Paluṟu panya nyinara wiyaringu ngura nyara ini Ipuṟanta manta panya Kainanta nguṟurpa. Ka Aipuṟamanya kuri wiyaringkunyangka katuku nyinara ulangi puḻkaṟa tjituṟu-tjituṟurira. ");
INSERT INTO pjt_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Munu palulanguṟu pakaṟa ngura wantikatira anu aṉangu Iitakunu tjuṯaku ngurakutu tawunu panya ititjakutu munu tawunu kaitangka wirkaṟa tjanala mitingiku tjunguringu. Munu paluṟu tjanala tjunguringkula tjapiningi nyanga alatji, ");
INSERT INTO pjt_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Ngayuluṉa malikitja manta nyanga nyurampangka nyinanyi, panya ngayulu iṯi ngaringu ngura parari munuṉa puḻkaringkula kutju pitjangu ngura nyangaku. Wanyuṉiya nyurampa manta tjukutjuku ngayula tjalamilala, kaṉa pala palula ngayuku kuri tjuṉutjura.” ");
INSERT INTO pjt_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","6","Kaya wangkangu palula Iitakunu tjuṯangku, “Wiya, nyuntu wati puḻka nganaṉala nyinanyi wiṟu mulapa. Ka nganampa kuḻpi tjuṯa ngaṟanyi miri tjuṉutjunkunytjaku, ka palya nyuntu kutju wiṟu mulapa ngurkantara, munu pala palula nyuntumpa kuri tjuṉutjura. Palya? Panya nganaṉa uwankara mukuringanyi nyuntunya kuḻpi ungkunytjikitja.” ");
INSERT INTO pjt_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","9","Ka nyangatja kuliṟa Aipuṟamalu pukuḻarira pakaṟa tjanala kuranyu pupakatira manta ngalyangku pampuṉu, munu wangkangu, “Munta wiṟu tjuṯa nyura! Munuya wanyu piṟuku kulila! Wiṟungkuya-puṯa tjapila wati pala Ipuṟannga panya Tjauwaku katja paluṟu kuḻpi ini Makipilanya ngayula tjalamilantjaku, panya kuḻpi paluṟu palumpa mantangka ngaṟanyi kantilytja. Ka paluṟu mani nampa wangkanyangkaṉa tjukaṟurungku payamilalku nampa panya palunya alatjiṯu, ka kuḻpi panya paluṟu ngayuku alatjiṯu ngaṟaku ngayuku walytja tjuṯa tjuṉutjunkunytjaku.” ");
INSERT INTO pjt_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ka wati panya Ipuṟannga palula tjanala tjungu nyinangi tawunu pala palula kaitangka, munu paluṟu Aipuṟamalu tjapinnyangka kuliṟa wangkangu aṉangu tjuṯangka miṟangka nyanga alatji, ");
INSERT INTO pjt_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Uwa, wati wiṟu nyuntu! Kulila! Nyuntunyaṉa nyanga ngayuku walytja tjuṯangka miṟangka unganyi kuḻpi pala palunya nyuntu kuri tjuṉutjunkunytjaku, munuṉanta manta pala kuḻpingka ititja kuḻu unganyi.” ");
INSERT INTO pjt_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","13","Ka Aipuṟamalu pukuḻarira piṟuku tjanala kuranyu pupakatira manta ngalyangku pampuṉu, munu paluṟu wangkangu wati panya Ipuṟanta aṉangu tjuṯangka miṟangka, “Wiya wiṟunya, palu ngayulu nyuntula payamilantjikitja mukuringanyi mani nampa panya nyuntu wangkanytjitjangka. Wanyu-puṯa mani mantjila, kaṉa kuḻpi nyara palula ankula ngayuku kuri tjuṉutjura.” ");
INSERT INTO pjt_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","15","Ka Ipuṟantu wangkangu, “Wati wiṟu, ngayunya kulila! Manta nyara kuḻpitjaraṉa ngaṉmanytju payamilaṉu tjiilpa tjukutjukungka nampa nyanga alatjiṯu 400-ngka kutju. Ka palya nyuntu mani nampa nyanga tjukutjukungka payamilala, ka kuḻpi nyaratja nyuntumpariku alatjiṯu nyuntu kuri tjuṉutjunkunytjaku.” ");
INSERT INTO pjt_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ka Aipuṟamalu nampa kuliṟa mapalkungku palyanmanu tjaṟuntjaku wangkanytja wiyangku. Munu mani tjiilpa nampa 400 tjukaṟurungku kantamilaṟa ungu wati panya palunya aṉangu tjuṯangka miṟangka. ");
INSERT INTO pjt_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","18","Alatji manta panya paluṟu kuḻpi puṉu winki Aipuṟamakuringu. Manta paluṟu panya ngura ini Makipilanya ngura Mamaṟaila kakaraṟa, ka wati panya Ipuṟantu Aipuṟamala tjalamilaṉu aṉangu Iitakunu tjuṯangka miṟangka tjana tawunuku kaitangka itingka nyinanyangka. Kaya nyangu Aipuṟamalu tjukaṟurungku payamilannyangka. ");
INSERT INTO pjt_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Ka palulanguṟu Aipuṟamalu palumpa kuri Tjiiṟanya katira tjuṉutjunu kuḻpi panya palula, manta panya Kainanta nguṟurpa. ");
INSERT INTO pjt_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Ka kuḻpi panya paluṟu kurulpa ngaṟangi Aipuṟamaku tjanampa palumpa walytja tjuṯaku kuḻu. Panya ngaṉmanytjuya Iitakunu tjuṯangku kanyiningi manta nyara palunya, munuya Aipuṟamalalta tjalamilaṉu ka palumparingu. ");
INSERT INTO pjt_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ka Aipuṟamanya tjiḻpi mulararingu munu pukuḻpa mulapa nyinangi, panya Mayatja Godalu palunya rawangku pukuḻmaṟa kutjupa kutjupa tjuṯa mulapa ungangi. ");
INSERT INTO pjt_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","4","Ka Aipuṟamaku wati waṟkaripai kutju nyinangi mayatja palula maḻatja wati tjiḻpi, munu paluṟu wati waṟka kutjupa tjuṯa aṯunymankupai munu Aipuṟamalu kanyintja uwankara nyakula aṯunymankupai, munu wati waṟka tjuṯa kuḻu witulpai waṟkarinytjaku. Ka Aipuṟamalu tjiḻpi panya palunya aḻṯira wangkangu, “Ngayuku katja Isaacanya kuri wiya nyinanyi, kaṉa mukuringanyi nyuntu ankula palumpa kuri nguriṟa mantjintjaku. Palu ngura nyanga Kainannga nguraṟa kuri palumpa mantjintja wiyangku wantima. Nyuntu alinytjara ara maḻaku ngura nyara ngayulu iṯi ngarinytjitjakutu, munu ngayuku walytja tjuṯanguṟu kungkawaṟa ngurkantaṟa mantjila kuri palumpa. Wanyuṉi Mayatja Godala miṟangka mulamulangku kalkula ngura nyara palunya nguraṟa kutju mantjintjikitjangku. Paṉṯa nyangaṉi pampuṟa tjukaṟurungku wangka, kaṉa pampuṟa kalkunnyangka nyuntumpa mulamularingkuku.” ");
INSERT INTO pjt_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Ka wati tjiḻpi paluṟu wangkangu, “Uwa palya, ngayulu ankula nyuntumpa walytjanguṟu palumpa kuri ngurilku nyuntumpa katjaku. Palu tjinguṟu kungkawaṟa ngayulu ngurkantankunytja ngayula tjungu pitjawiyangku wantiku ngura nyanga palulakutu, kaṉa yaaltjiriku? Tjinguṟuṉa Isaacanya ngura nyara palulakutu ma-katiku nyuntumpa panya ngurakutu, mulapa?” Alatji paluṟu tjapiningi Aipuṟamala. ");
INSERT INTO pjt_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ka Aipuṟamalu wangkangu, “Wiya, wiya! Ngayuku katja nyara palulakutu katiwiyangku wantima. ");
INSERT INTO pjt_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Uwa, mulapa ngayulu ngura nyara palula iṯi ngaringu, ka panya ngayuku walytja tjuṯa nyara palulaṯu nyinanyi. Palu Mayatja ilkaṟitjangku ngayunya ngalya-katingu ngura nyara palulanguṟu. Munuṉi ngura nyangaku kalkuṉu manta nyanga Kainanku ngayuku walytja maḻatja maḻatja ungkunytjikitjangku palumpa tjanamparinytjaku. Pala palulanguṟuṉi kulila, panya nyara palulakutu ankunyangka Mayatja Godalu nyuntula kuranyu angelpa iyalku, ka nyuntunya nintilku ngayuku katjaku kuri tjukaṟurungku nguriṟa mantjintjaku. ");
INSERT INTO pjt_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Ka kungkawaṟa nyuntu ngurkantankunytjalu tjinguṟu wantiku nyuntula tjungu pitjawiyangku. Palulanguṟu kutjuṉin kuliṟa wantima ngayunya ngaṉmanytju kalkuntjatjanungku. Palu ngayuku katja katinytja wiyangku wantima ngura nyara palulakutu.” ");
INSERT INTO pjt_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Ka kuliṟa tjiḻpi panya waṟkaripaingku mayatja palumpa Aipuṟamanya paṉṯa pampuṉu, munu kalkuṉu panya Aipuṟamalu wangkanytja uwankara wangaṉarangku kuliṟa palyantjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Munu paluṟu kamula 10 mantjinu Aipuṟamaku kamula tjuṯanguṟu. Ka Aipuṟamalu kutjupa kutjupa tjuṯa palunya ungkul'iyaṉu ulytja wiṟu tjuṯa kungkawaṟatja, puḻinguṟu palyantja wiṟu tjuṯa munu kutjupa kutjupa tjuṯa kuḻu, ka paluṟu kamulangka tjunkula karpiṉu katira kungkawaṟa panya palunya ungkunytjikitjangku palumpa walytja tjuṯa kuḻu. Munu paluṟu ma-pakaṉu wati waṟkaripai tjuṯatjara manta ini Mitjupu-taimiyalakutu, panya manta nyara palula alinytjara wiluṟara tawunu kutjupa ngaṟangi Aipuṟamaku maḻanypaku ngura wati panya Nayuku. ");
INSERT INTO pjt_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Munu tjiḻpi panya paluṟu ankula ankula tawunu nyara palula wirkaṟa kamula tjuṯa pupatjunu mina piṯingka itingka tawunungka uṟilta. Ka panya mungartji-mungartji ngaṟangi, panya kungkawaṟa tjuṯa waringka minaku pitjapai. ");
INSERT INTO pjt_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Ka tjiḻpi panya paluṟu Godala tjapinu, “Mayatja wanyuṉi kulila! Panya nyuntu ngayuku mayatjaku Aipuṟamaku God. Wanyuṉi kuwari nintila Isaacaku kuri ngurintjaku, ngayuku mayatja Aipuṟamanya pukuḻarinytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Ngayulu nyanga minangka paṯaṟa ngaṟanyi, kaya kungkawaṟa tjuṯa kuwari waḻinguṟu mina tjutintjikitja pitjanyi. ");
INSERT INTO pjt_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Kaṉa kuwari kutjungka mina piningka katinyangka nyakula alatji wangkaku, ‘Wanyuṉi mina tjikintjaku ungama nyuntumpa pala pitinguṟu.’ Ka tjinguṟu paluṟu alatji wangkaku, ‘Uwa, tjikila! Kaṉa wanyu mina kutjupa kuḻu tjutilku nyuntumpa kamula tjuṯaku kuḻu.’ Ka paluṟu alatji wangkanyangkaṉa kulilku, ‘Munta-uwa, mulapa Godalu mayatja Aipuṟamanya kalkuntjatjanungku palyaṉu munu kungkawaṟa nyangatja palumpa katjaku ngurkantanu.’” Alatji tjiḻpi panya Aipuṟamaku waṟkangku Godala tjapiningi palunya kungkawaṟa tjukaṟurungku nintintjaku. ");
INSERT INTO pjt_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Ka paluṟu tjapinnyangka kungkawaṟa ini Ripikanya minaku ngalya-wirkanu piti waṟa piningka tjunkula. Ka kungkawaṟa nyanga palumpa mama panya wati ini Pitjuwilnga. Ka wati Pitjuwilku panya mama ngunytju pula ini Nayunya, Milkanya. Ka paluṟu panya Aipuṟamaku maḻanypa, Nayunya, Ripikaku panya tjamu. ");
INSERT INTO pjt_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Ka Ripikanya kungkawaṟa wiṟu mulapa munu watiku ngurpa nyinangi. Munu paluṟu mina panya piṯikutu ukalingkula piti panya waṟangka mina tjutiṟa tjaalyngaṟatjunu munu piningka tjaḻiṟa maḻaku pitjangi. ");
INSERT INTO pjt_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Ka wati panya tjiḻpi ngapari-ngapari wirtjapakaṉu palulakutu munu wangkangu, “Wanyuṉi mina tjukutjuku ungama nyuntumpa pala pitinguṟu.” ");
INSERT INTO pjt_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ka wangkangu, “Uwa, tjikila!” Munu paluṟu piti tjaṟuṟa witiṟa kanyinu paluṟu tjikintjaku. ");
INSERT INTO pjt_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Munu tjikiṟa wiyaringkunyangka paluṟu wangkangu, “Kuwariṉa mina puḻka tjutini nyuntumpa kamula tjuṯaku kuḻu, tjana kuḻu tjikiṟa palya ngaṟanytjaku.” ");
INSERT INTO pjt_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Munu paluṟu pitinguṟu mina winki pupatjunu piti kutjupangka panya kukangku tjikilpaingka, munu maḻaku wirtjapakaṉu mina piṯikutu piṟuku tjutintjikitja, munu paluṟu mina puḻka ilaṟa katira tjutiṟa ngaṟangi kamula tjuṯaku tjana tjikiṟa palya ngaṟanytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ka tjiḻpi panya paluṟu kungkawaṟa palunya wangkawiyangku ngaṟala miṟaningi kuliṟa, “Tjinguṟu nyanga palunya Godalu ngayunya nintini Isaacaku kuri katinytjaku.” ");
INSERT INTO pjt_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Kaya kamula tjuṯangku tjikiṟa wiyaringkunyangka tjiḻpi paluṟu palumpa ulytjanguṟu mantjinu ringi tjukutjuku mulyatja, munu munytjulpaku manguṟi-manguṟi kutjara. Munu palulanguṟu kungkawaṟa palula ringi mulya aḻangka tjarpatjunu, munu munytjulpa kutjarangka manguṟi-manguṟi kutjara tjunu. Ka ringi nyanga paluṟu, manguṟi-manguṟi kutjara kuḻu apu gold-nguṟu palyantja mani puḻkatja. ");
INSERT INTO pjt_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Munu tjiḻpi panya paluṟu kungkawaṟangka wangkangu, “Mama nyuntumpa ini ngananya? Tjinguṟu paluṟu ruuma kanyini nganaṉa palumpa ngurangka ngarinytjaku munga kuwari?” ");
INSERT INTO pjt_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ka wangkangu, “Ngayuku mama ini Pitjuwilnga panya Nayuku pulampa Milkaku katja. ");
INSERT INTO pjt_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ka nganampa ngurangka mai ukiṟi puḻka ngarinyi kamula tjuṯangku ngalkuntjaku munu tjanampa ngaripai kuḻu ngaṟanyi. Ka ruuma kutjupa ngaṟanyi nyura ngarinytjaku.” ");
INSERT INTO pjt_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Ka palulanguṟu tjiḻpi panya paluṟu pukuḻarira Mayatja Godanya waḻkuntjikitjangku tultjungaṟakatingu, ");
INSERT INTO pjt_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","munu alatji waḻkuṟa wangkangu, “Mayatja, nyuntu wiṟu mulapa, panya nyuntu ngayuku mayatja Aipuṟamaku God, munun palumpa mukuringkula wangaṉarangku kuliṟa palyaṉu panya nyuntu palunya kalkuntjatjanungku. Panya nyuntuṉin ankunyangka tjukaṟurungku nintinu ngayuku mayatjaku walytja tjuṯa, nyanga Nayukunu tjuṯa.” ");
INSERT INTO pjt_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Ka kungkawaṟa panya paluṟu ngurakutu wirtjapakaṟa uwankara tjakultjunu palumpa ngunytjungka munu walytja tjuṯangka kuḻu. ");
INSERT INTO pjt_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Ka palumpa kuṯa ini Laipannga kuḻu palula tjanala tjungu nyinangi. Munu paluṟu nyangu palumpa maḻanypangku mulyangka, munytjulpangka kuḻu kanyinnyangka munu tjiḻpi panya paluṟu wangkanytja uwankara tjakultjunkunyangka kuliningi. Munu nyakula kuliṟa mapalku pakaṟa anu tjiḻpi panya palulakutu mina panya piṯingka paṯaṟa ngaṟanyangka tawunungka uṟilta. Munu ankula ma-wirkaṟa nyangu tjiḻpi panya paluṟu kamula tjuṯatjara ngaṟanyangka. ");
INSERT INTO pjt_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Munu Laipantu palula pukuḻṯu wangkangu, “Palya, nganampa ngurakutu ngalya-pitja. Panya nyuntunya Mayatja Godalu wiṟuṟa wankaṟu ngalya-katingu. Nyanga palula wanyu ngaṟanytja wiya ngalya-pitja, panya ngayulu ngaṉmanytju nyuntumpa ngura palyaṉu ngayuku waḻingka, munuṉa nyuntumpa kamula tjuṯaku kuḻu ngura palyaṉu.” ");
INSERT INTO pjt_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Ka tjiḻpi panya paluṟu anu palumpa waḻikutu wati panya palumpa maḻpa tjuṯa kuḻu, munuya wirkaṟa tjarpangu waḻingka. Ka Laipantu kamula tjuṯanguṟu ulytja uwankara mantjiṟa tjunu munu kamula tjuṯa ungu mai ukiṟi ngalkula paḻtjaringkunytjaku munu ngura ngarinytjaku tjanampa palyaṉu ukiṟi piḻṯinguṟu. Munu palula maḻangka mina tjutiṉu tjiḻpi paluṟu tjina paltjintjaku, palumpa maḻpa tjuṯangku kuḻu. ");
INSERT INTO pjt_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Munu palulanguṟu tjanampa mailta pauṟa katingu tjana ngalkuntjaku. Palu tjiḻpi panya paluṟu alatji wangkangu, “Munta! Wanyuṉa ngayulu tjukurpa wangkama nyurala mai nyanga ngalkuntja kuwaripangka.” Ka Laipantu wangkangu, “Wiya palya wangkama, kala kulinma.” ");
INSERT INTO pjt_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ka paluṟu nyanga alatji wangkangu, “Ngayuluṉa Aipuṟamaku waṟkaripai. Paluṟu ngayuku mayatja. ");
INSERT INTO pjt_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Ka Mayatja Godalu palunya puḻkaṟa mulapa pukuḻmanu munu palunya kutjupa kutjupa tjuṯa mulapa ungu nyanga alatji, tjiipi tjuṯa, nanikuta tjuṯa, puluka tjuṯa, munu mani gold tjiilpa kuḻu puḻka mulapa ungu, munu wati minyma palumpa waṟkarinytjaku tjuṯaṯu ungu, kamula tjuṯa, tangkiyi tjuṯa kuḻu ungu palunya. Ka paluṟu puḻka mulartjara pukuḻ-pukuḻpa nyinanyi. ");
INSERT INTO pjt_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ka palumpa kuringku Tjiiṟalu pampa mulararira katja kanyinu palumpa, ka paluṟu katja palunya uwankara ungu, panya ulytja, kuka, kamula, tangkiyi, tjinatjara uwankara paluṟu kanyintja ma-ungu. ");
INSERT INTO pjt_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Munuṉi kalkuntjaku ngayunya wangkangu kuri palumpa katjaku ankula nguriṟa mantjintjaku. Alatji paluṟu kalkuntjaku wangkangu ngayunya, ‘Kuri ngayuku katjaku kungkawaṟa ngura nyanga Kainannga nguraṟa mantjintja wiyangku wantima. ");
INSERT INTO pjt_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Palu nyuntu alinytjara ara maḻaku ngura nyara ngayulu iṯi ngarinytjitjakutu, munu ngayuku walytja tjuṯanguṟu kungkawaṟa ngurkantaṟa mantjila kuri palumpa.’ Alatjiṉi wangkara wituṉu Aipuṟamalu. ");
INSERT INTO pjt_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Kaṉa palula tjapinu, ‘Palu tjinguṟu kungkawaṟa paluṟu ngayula tjungu pitjanytja wiyangku wantiku. Kaṉa yaaltjiriku?’ ");
INSERT INTO pjt_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Ka paluṟu panya wangkangu, ‘Wiya Mayatja Godalu nyuntunya nintilku. Panya ngayulu palula tiṯutjarangku wangaṉarangku kulilpai, ka paluṟu angelpa nyuntula kuranyu iyalku, ka nyuntunya nintilku ngayuku katjaku kuri tjukaṟurungku nguriṟa mantjintjaku nyara ngayuku mamaku walytja tjuṯanguṟu.’ Alatjiṉi wangkara rapaṉu Aipuṟamalu. ");
INSERT INTO pjt_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Munuṉi wangkangu, ‘Palu nyuntu nyara tjanalanguṟu kungkawaṟa kutju ngurkantankuku, kaya tjinguṟu palumpa walytja tjuṯangku wantiku palunya nyuntunya ungkul'iyalwiyangku ngalya-katinytjaku. Nyara palulanguṟu kutju nyuntu kalkuntja panyatja wantima kulilwiyangku, tjana ungkuwiyangku wantinyangka.’ Alatji Aipuṟamalu ngayunya wangkangu, ka nyangaṉa pitjangu. ");
INSERT INTO pjt_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Munuṉa panya kuwari mina piṯingka wirkaṟa tjapinu Mayatja Godala nyanga alatji, ‘Mayatja! Nyuntu panya ngayuku mayatjaku God, Aipuṟamaku. Wanyuṉi kuwari nintila Isaacaku kuri nguriṟa mantjintjaku. Nyanga alatjiṉa arkaṟa ngurkantankuku. ");
INSERT INTO pjt_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Kuwariṉa minangka itingka ngaṟanyi, munuṉa kungkawaṟa kutjupa minaku pitjanyangka nyakula palunya tjapilku, “Wanyuṉi mina tjikintjaku ungama nyuntumpa pala pitinguṟu.” ");
INSERT INTO pjt_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Ka tjinguṟu paluṟu alatji wangkaku, “Uwa, tjikila, kaṉa wanyu mina kutjupa kuḻu tjutilku nyuntumpa kamula tjuṯaku kuḻu.” Ka paluṟu alatji wangkanyangkaṉa kulilku, “Munta-uwa, Mayatja Godalu kungkawaṟa nyanga palunya ngurkantanu ngayuku mayatjaku katjaku.” ’ ");
INSERT INTO pjt_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Ka ngayulu panya Godala tjapinnyangka mulapaṯu mapalku ngalya-wirkanu kungkawaṟa panya Ripikanya piti waṟa piningka tjunkula, munu paluṟu minakutu ukalingkula mina ilaṟa pitingka tjutiṟa piningka tjunu ngurakutu katinytjikitjangku. Kaṉa palula tjapinu, ‘Wanyuṉi mina tjikintjaku ungama.’ ");
INSERT INTO pjt_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Ka paluṟu mapalku piti tjaṟuṉu wangkara, ‘Uwa, tjikila! Kaṉa nyuntumpa kamula tjuṯa kuḻu minatjanula.’ Kaṉa tjikinu, ka paluṟu kamula tjuṯa kuḻu minatjanuṉu. ");
INSERT INTO pjt_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Kaṉa palula tjapinu, ‘Nyuntumpa mama ini ngananya?’ Ka wangkangu, ‘Ngayuku mama ini Pitjuwilnga panya Nayuku pulampa Milkaku katja.’ Kaṉa palulanguṟu ringi tjarpatjunu palula mulya aḻangka, munu manguṟi-manguṟi kutjara munytjulpangka tjunu. ");
INSERT INTO pjt_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Munuṉa tultjungaṟakatira Aipuṟamaku God waḻkuṉu. Ngayulu palumpa pukuḻarira palunya mirawaṉingu ngayuku mayatjaku God, panya paluṟu ngayunya tjukaṟurungku ngalya-katingu nyanga palulakutu ngayuku mayatjaku walytja tjuṯakutu, munuṉi tjukaṟurungku nintinu kungkawaṟa nyanga ngayuku mayatjaku maḻanypaku puḻiri. Kaṉa nyakula kulinu, ‘Nyanga palunya Godalu ngurkantanu ngayuku mayatjaku katjaku.’ ");
INSERT INTO pjt_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","“Uwa alatjiṯuṉa wangkanyi, ka nyura yaaltji kulini? Nyura wanyu ngayuku mayatja Aipuṟamanya pukuḻarinytjaku tjukaṟurungku palumpa katjaku kuri iyalku? Uwanmaraya kaṉa kuliṟa pukuḻarima. Palu wantirampaṉiya utingku wangka, kaṉa kungkawaṟa kutjupa ngurila.” ");
INSERT INTO pjt_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Ka Laipantu pula Pitjuwiltu mamaṟarangku aṟa nyanga palunya kuliṟa tjiḻpi panya palula wangkangu nyanga alatji, “Wiya, wiṟun nyangatja wangkanyi nyuntunya Mayatja Godalu ngalya-katinytja, ka ngali wiyanmankunytjaku wiya alatjiṯu ngaṟanyi. Nyangatja paluṟu kutjungku palyantja Mayatja Godalu. ");
INSERT INTO pjt_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Nyangatja Ripikanya. Palunya mantjiṟa ma-kati, ka wirkankunyangka nyuntumpa mayatjaku katjangku palunya aḻṯiku, panya alatjingantjaku Mayatja Godalu wangkangu.” ");
INSERT INTO pjt_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ka nyangatja kuliṟa tjiḻpi panya paluṟu puḻkaṟa pukuḻaringu Mayatja Godaku munu pupakatira ngalyangku manta pampuṟa palunya waḻkuṉu. ");
INSERT INTO pjt_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Munu palulanguṟu paluṟu palumpa ulytjanguṟu mantjinu mantara tjuṯa, munu kutjupa kutjupa wiṟu tjuṯa apu gold-nguṟu, tjiilpanguṟu palyantja tjuṯa, munu Ripikanya ungu mantarangka tjarpanytjaku, munu wiṟu panya tjuṯa tanpantjaku. Munu paluṟu Ripikaku kuṯa, ngunytju kuḻu ma-ungkukatingu, kutjupa kutjupa wiṟu tjuṯa mani puḻkatja tjuṯa. ");
INSERT INTO pjt_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Palulanguṟuya tjiḻpi panya paluṟu munu palumpa maḻpa tjuṯangku ngalkula tjikiṟa paḻtjaringu, munuya ngura pala palulalta ngaringu munga kutju. Munuya ngarira tjiṉṯuringkula pakaṟa tjiḻpi panya paluṟu wangkangu, “Wanyuṉi maḻakungku iyala ngayuku mayatjakutu.” ");
INSERT INTO pjt_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Palu Ripikaku kuṯangku ngunytjungku kuḻu arkaṟa wangkangu, “Wiya kuwaripangku wantima, ka kungkawaṟa nyanga paluṟu tjukutjuku nganaṉala nyinama tjinguṟu tjiṉṯu 7 tjinguṟu tjiṉṯu 10, munu palulanguṟu nyuntula anama. Palya?” ");
INSERT INTO pjt_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ka tjiḻpi panya paluṟu wangkangu, “Wiya wantir'iyalalanya markuntja wiyangku. Panya Godalu ngayunya tjukaṟurungku ngalya-katingu kungkawaṟa nyanga palulakutu. Wanyulanya-puṯa wantir'iyala, kaṉa kungkawaṟa palunya mayatjakutu kati.” ");
INSERT INTO pjt_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ka pula katjaṟarangku wangkangu, “Wanyu paṯala, kali aḻṯi kungkawaṟa palunya, ka paluṟu kuliṟa wangka.” ");
INSERT INTO pjt_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Munuya Ripikanya aḻṯira tjapinu, “Yaaltjin kulini? Nyuntu ankuku wati nyanga tjiḻpi palula?” Ka wangkangu, “Uwa palya, ngayulu ananyi.” ");
INSERT INTO pjt_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Kaya palulanguṟu Ripikanya palula tjanala tjungu iyaṉu palumpa ngunytjungku, kuṯangku, walytja tjuṯangku kuḻu. Munuya minyma pampa panya Ripikanya iṯinguṟu kanyintja kuḻu palula tjungu iyaṉu. ");
INSERT INTO pjt_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Munuya Ripikanya pukuḻmanu alatji wangkara, “Nyuntulanguṟu aṉangu mungilyi mulapa ma-tjuṯaringkuku maḻatja maḻatja, kaya tjanampa mirpaṉtju tjuṯa pungkula wiyanma alatjiṯu nyuntumpa walytja tjuṯangku maḻatja maḻatjangku kuḻu.” ");
INSERT INTO pjt_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Ka Ripikanya palumpa kungkawaṟa waṟkaripai tjuṯa kuḻu pirtji-pirtjiṟa kamulangka tati-tatinu munuya tjiḻpi panya Aipuṟamaku waṟkangka tjunguringkula anu. Alatji wati panya tjiḻpi paluṟu Ripikanya nguriṟa mantjinu munu ma-pakaṟa anu maḻaku palumpa mayatjakutu. ");
INSERT INTO pjt_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Ka nyara palula-aṟangka wati panya Isaacanya pilangka nyinangi Kainanta uḻpaṟira, ka palumpa ngurangka itingka mina piṯi ngaringi, panya mina pala palunyaya wangkapai nyanga alatji, “Ngura nyanga palula panya palunya nyangu Tiṯutjara Nyinapailu”. ");
INSERT INTO pjt_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Munu nyara palula nyinara paluṟu mungartji kutjupa ilytjikutu anu unytju, tjinguṟu urukulintjikitja. Munu ilytjingka ma-pitjala kata ma-katuṟa aḻa miṟantjikitjangku nyangu kamula tjuṯa ngalya-pitjanyangka. ");
INSERT INTO pjt_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","65","Ka Ripikalu kamula katunguṟu waṟaringkula nyangu Isaacanya ngalya-pitjanyangka, munu paluṟu ukalingkula Aipuṟamaku waṟkangka wati panya tjiḻpingka tjapinu, “Wati ngananya nyaratja ngalya-pitjanyi?” Ka wangkangu tjiḻpi panya paluṟu, “Wiya, nyaratja ngayuku mayatja, Isaacanya.” Kanku Ripikalu nyangatja kuliṟa raikingka yunpa tjutuṉu. ");
INSERT INTO pjt_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Ka wati panya tjiḻpingku Isaacala wangkangu, “Nyangatjaṉa ngalya-katingu nyuntumpa kuri.” Munu paluṟu tjukurpa uwankara tjakultjunu panya paluṟu ankula kungkawaṟa mantjintja. ");
INSERT INTO pjt_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Ka Isaacalu Ripikanya mantjiṟa katingu palumpa ngunytjuku tiintakutu munu palunya kuri aḻṯingu. Munu paluṟu palumpa puḻkaṟa mukuringu, ka Ripikalu palunya pukuḻpa palyaṉu panya wati paluṟu ngunytjunguṟu tjituṟu-tjituṟu nyinangi. ");
INSERT INTO pjt_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ka Aipuṟamalu kuri kutjupa aḻṯingu minyma ini Kituṟanya. ");
INSERT INTO pjt_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ka paluṟu katja tjuṯa kanyiningi Aipuṟamaku ini nyanganpa – Tjimaṟannga, Tjakitjannga, Mitannga, Mitiyannga, Itjipakanya, Tjuwanya tjananya. ");
INSERT INTO pjt_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Ka Tjakitjannga wati Tjiipaku pulampa Titanku mama nyinangi. Ka wati panya Titantanguṟu aṉangu ma-tjuṯaringu maḻatja maḻatja, aṉangu panya ini nyanga tjana Atjurkunu tjuṯa, Litutjikunu tjuṯa, Liyumkunu tjuṯa. ");
INSERT INTO pjt_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Ka Aipuṟamaku katjangku ini Mitiyantu katja tjuṯa utinu ini nyanganpa – Ipanya, Ipunya, Aanakanya, Apitanya, Iltayanya tjananya. ");
INSERT INTO pjt_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","6","Ka Aipuṟamalu minyma Kituṟakunu tjuṯa kutjupa kutjupa wiṟu tjuṯa ungu palumpa panya katja tjuṯa, munu palu puṟunypaṯu minyma Aikakunu kuḻu ungu palumpa panya katja Itjumailnga. Munu palulanguṟu tjananya uwankara parari ma-iyaṉu kakaraṟa katja panya Isaacala itingka nyinanytjaku-tawara. Ka ngula Aipuṟamanya wiyaringkunyangka Isaacalu palumpa kutjupa kutjupa uwankara mantjinu. ");
INSERT INTO pjt_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Uwa, Aipuṟamanya yiya tjuṯa mulapa nyinangu nampa nyangatja 175 munu palulanguṟulta ilungu. ");
INSERT INTO pjt_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","10","Ka palumpa katja kutjarangku Isaacalu pula Itjumailtu palunya katira ngura panya Mamaṟaila kakaraṟa tjuṉutjunu kuḻpi ini Makapilala. Panya kuḻpi pala palunya Aipuṟamalu ngaṉmanytju payamilaṉu wati Iitakunungka ini Ipuṟanta munu panya palumpa kuri Tjiiṟanya pala palula ngaṉmanytju tjuṉutjunu. ");
INSERT INTO pjt_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Ka Isaacanya palumpa mama tjuṉutjunkunytjatjanu piṟuku ankula nyinangi ngura nyara mina piṯitjarangka, panya mina nyara palunyaya wangkapai nyanga alatji, “Ngura nyanga palula panya palunya nyangu Tiṯutjara Nyinapailu”. Ka Godalu Isaacanya pukuḻmanu kutjupa kutjupa tjuṯa palumpa palyaṟa. ");
INSERT INTO pjt_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ka nyangatja Aipuṟamaku katja Itjumailku walytjapiti palulanguṟu ma-tjuṯaringkunytja maḻatja maḻatja. Itjumailnga panya Aipuṟamalu minyma ini Aikala utinu Tjiiṟaku panya waṟkangka. ");
INSERT INTO pjt_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","15","Ka Itjumailtu katja tjuṯaṯu utinu. Ngaṉmanytju paluṟu utinu katja ini Nipayatjanya, ka Nipayatjalu pininu wati ini Kitarnga, ka Kitartu pininu Atapilnga, ka Atapiltu pininu Mipitjamanya, ka Mipitjamalu pininu Mitjimanya, ka Mitjimalu pininu Tumanya, ka Tumalu pininu Matjanya, ka Matjalu pininu Aatatanya, ka Aatatalu pininu Timanya, ka Timalu pininu Tjiturnga, ka Tjiturtu pininu Napitjinya, ka Napitjilu pininu Kitimanya. ");
INSERT INTO pjt_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Nyanga paluṟu tjana uwankara Itjumailku katja tjuṯa nampa panya 12. Ka katja nyanga 12-nguṟu puḻka-aṉangu ma-tjuṯaringkula maḻatja maḻatja ma-nyinangu palu puṟunypaṯu. Munuya paluṟu tjana walytjaṟara walytjaṟara nyinara waṉaningi ngura kutjupa kutjupangka. Kaya Itjumailku katja panya 12 walytjapiti kutjupa kutjupaku mayatja nyinangi ngura walytjangka walytjangka. Munuya tawunu tjananku walytjangku walytjangku ininu. ");
INSERT INTO pjt_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ka Itjumailnga tjiḻpi mulararira ilungu yiya tjuṯa mulapa nyinanytjatjanu nampa panya 137. ");
INSERT INTO pjt_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Kaya Itjumailku walytjapiti ma-tjuṯa mulararingu maḻatja maḻatja munuya manta lipiwanu nyinara waṉaningi nyanga alatji panya Itjipala kakaraṟa ngura ini Tjuulanguṟu ma-nyinara waṉaningi kakaraṟakutu ngura ini Apilalakutu. Munuya paluṟu tjana Aipuṟamaku walytja kutjupa tjuṯaku tiṯutjara mirpaṉtju nyinangi kalypa wiya. ");
INSERT INTO pjt_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Ka nyangatja Aipuṟamaku katja Isaacaku walytjapiti palulanguṟu ma-tjuṯaringkunytja maḻatja maḻatja. ");
INSERT INTO pjt_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Panya Isaacalu puḻkaringkula yiya nampa 40 nyinanytjatjanungku Laipanku maḻanypa Ripikanya aḻṯingu panya wati Pitjuwilku uṉṯalpa. (Pitjuwilnga ngura panya Aṟamanya nguraṟa, manta nyara Mitjupu-taimiyala nyinapai.) ");
INSERT INTO pjt_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Palu Ripikanya panya puṯu tjitjitjararingangi, ka Isaacalu Mayatja Godala tjapiningi palunya tjitji ungkunytjaku. Ka Mayatjalu paluṟu tjapinnyangka kulinu, ka palulanguṟu Ripikanya iṯitjararingu munu paku nyinangi. ");
INSERT INTO pjt_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Palu Ripikala tjuningka iṯi kutjara nyinangi, munu pulanku wirkankunytja kuwaripangka tjuni unngu pikaringkupai. Ka ngunytjungku wangkangu, “Nyaaku pula tjuni unngu pikaringanyi?” Munu paluṟu puṯu kuliṟa Mayatja Godala tjapinu palula wangkara utintjaku. ");
INSERT INTO pjt_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Ka Mayatjalu tjapinnyangka kuliṟa palula wangkangu nyanga alatji, “Tjitji pala pulalanguṟu puḻka-aṉangu uṯuḻu kutjara ma-tjuṯaringkuku maḻatja maḻatja, panya palumpakunu tjuṯaringkuku, ka nyara kutjupaku palu puṟunypaṯu tjuṯaringkuku. Munuya paluṟu tjana uṯuḻu kutjara tiṯutiṯu nyinaku. Ka uṯuḻu kutju witulya puḻka ngaṟaku, palu uṯuḻu kutjupa upa nguwanpa ngaṟaku. Ka kuṯa panya maḻanypaku waṟkariku.” Alatji Mayatjalu Ripikanya utiṟa wangkangu. ");
INSERT INTO pjt_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Ka palulanguṟu iṯi wirkankunytjaku ilaringu ka Ripikalu katja kutjara kanyinu. ");
INSERT INTO pjt_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Ka kuṯanya miṟi tjitin-tjitinpa nguwanpa inyu puḻka, ka palunya ininu Iitjunya. ");
INSERT INTO pjt_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Ka katja maḻatja mapalku wirkanu wanapari kuṯa paalpa maṟangku witiṟa, ka palunya ininu Jacobanya. Ka katja nyanga pula wirkankunytja-aṟa Isaacanya yiya nampa 60 nyinangi. ");
INSERT INTO pjt_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Ka tjitji paluṟu pula puḻkaringu, ka Iitjunya kukaputju mulapa nyinangi, munu paluṟu ilytjingka pukuḻpa para-ngaṟapai kukaku ankula. Palu Jacobanya wati piluntju munu ngurangka kutju nyinara waṟkaripai. ");
INSERT INTO pjt_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Ka Isaacanya Iitjuku puḻkaṟa mukuringkupai panya paluṟu pukuḻṯu ngalkupai Iitjulu kuka katinyangka. Palu Ripikanya Jacobaku puḻkaṟa mukuringkupai. ");
INSERT INTO pjt_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Ka tjiṟirpi kutjupa Jacobalu mai tjuu waṟungka kutjannyangka Iitjunya kukatjanu wirkanu paḻtjatjiratja puḻka. ");
INSERT INTO pjt_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Munu paluṟu Jacobanya wangkangu, “Ai! Ngayulu puḻkaṟa paḻtjatjiratjaringu. Ungamaṉi mai pala tjuu tjitin-tjitinpa.” (Kaya nyanga palulanguṟu palunya ini kutjupa wangkapai “Iitamanya” panya “Iitima” wangkanyi “Tjitin-tjitinpa” tjanampa wangkangku.) ");
INSERT INTO pjt_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Ka Jacobalu wangkangu, “Uwa palyantiṉanta ungkuku, palu wanyuṉi ngayunya kalkula, kaṉa nyara palulanguṟu kutju nyuntunya uwa. Panya nyuntu ngayuku kuṯa kuranyu iṯi wirkankunytja, munun palulanguṟu nyuntu kuṯa ngaṉmanyitja mamangka aṟangka ngaṟaku paluṟu wiyaringkunyangka. Munu nyuntu panya mayatja nyinaku nganampa walytja uwankaraku munun mamalu kanyintja uwankara mantjilku paluṟu ilunyangka. Ka nyuntunya Godalu pukuḻmankuku mununta kalkulku, panya paluṟu tjamu Aipuṟamanya mama Isaacanya kuḻu kalkuntja puṟunypa. Nyangatja uwankara nyuntu mantjilku kuṯa puḻkangku. Palu nyuntu nyanga ngayuku maiku mukuringkulampa ngayula-waraṟa wangkara palyanmara ngayulu nyuntumpa aṟangka ngaṟanytjaku kuṯa puṟunypa.” ");
INSERT INTO pjt_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ka Iitjulu wangkangu, “Wiya palya! Ngayulu panyaṉa kuwari paḻtjatjiratja puḻka nguwanpa ilunyi, munuṉa wanyu ilurampa mamangka aṟangka ngaṟaku? Wiya, ungamaṉi mai kaṉa palya nyuntumpa kuṯa nyinanytja wiyariwa mununku maḻanyari.” ");
INSERT INTO pjt_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Ka Jacobalu wangkangu, “Wiya mulamulangkuṉi kalkula ngayunya kuṯanmankunytjikitjangku, kaṉanta palulanguṟu ungkuku.” ");
INSERT INTO pjt_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Ka Iitjulu mulapaṯu kalkuṉu palunya kuṯanmankunytjikitjangku, ka Jacobalu palunya mai tjuu ungu nyuma kuḻu. Ka ngalkula tjikiṟa paḻtjaringkula pakaṟa anu. Uwa, Iitjunya kuṯa nyinangi, palu paluṟu ngunti maikitja maḻanyaringu. ");
INSERT INTO pjt_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Ngaṉmanypa panya Aipuṟamanya nyinanytja aṟa ailuru puḻka ngaṟangi manta nyara palula munu wiyaringu. Munu ngulalta piṟuku ailuru puḻkaringu. Ka Isaacanya Pilitjiyanya nguraṟa tjuṯaku mayatjakutu anu wati panya Pimalikalakutu ngura panya Kiṟarta nyinanyangka. ");
INSERT INTO pjt_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Panya Mayatja Godalu Isaacala utiringkula wangkangu, “Ngura nyara Itjipalakutu ankuwiyangku wantima, munu ngura nyangangka kutju nyinama panya ngayulu nyuntunya nyinanytjaku wangkanytjitjangka. ");
INSERT INTO pjt_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Nyuntu ngura nyangangka alatjiṯu nyinama kaṉa nyuntula tjungu nyinama munuṉanta pukuḻmanama. Panya ngayulu nyuntunya munu nyuntumpa walytja tjuṯa maḻatja maḻatja kuḻu ungkuku manta nyanga palunya uwankara, munu panyaṉa ngayulu nyuntumpa mama Aipuṟamanya kalkuntjatjanungku kuliṟa tjukaṟurungku palyalku wantinytja wiyangku. ");
INSERT INTO pjt_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ngayuluṉa palyalku nyuntulanguṟu aṉangu ma-tjuṯaringkunytjaku maḻatja maḻatja, kaya mungilyi mulapa nyinaku panya kililpi ilkaṟitja tjuṯa puṟunypa, munuṉa palunya tjananya manta nyanga winki ungkuku. Ngayulu tjananya pukuḻmaṟa palyalku, munuṉa palula tjanalanguṟu aṉangu manta winkitja palyaṟa pukuḻmankuku. ");
INSERT INTO pjt_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Uwa, Aipuṟamalu ngayunya wangaṉarangku kulinu, kaṉa nyara palulanguṟu nyuntunya munu tjananya kuḻu pukuḻmankuku. Paluṟu panya ngayulu wangkanytja uwankara, ngayuku tjukurpa uwankara kuḻu wangaṉarangku kuliningi wantinytja wiyangku, kaṉa pala palulanguṟu Aipuṟamalu kulintjitjanguṟu nyuntunya munu tjananya kuḻu pukuḻmankuku.” Alatji Mayatja Godalu Isaacala wangkangu. ");
INSERT INTO pjt_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Ka Isaacalu wangaṉarangku kulinu munu ngura nyara Kiṟarta nyinangi ngura kutjupakutu ankunytja wiya. ");
INSERT INTO pjt_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Kaya wati Kiṟarnga nguraṟa tjuṯangku palumpa kuriku tjapinnyangka Isaacalu alatji kulinu, “Tjinguṟuya wati nyanga tjana Ripikaku mukuringanyi, panya paluṟu minyma wiṟu mulapa, yunpa wiṟu. Kaṉa tjinguṟu kuri walytjanmankunyangkaya palunyakitjangku ngayunya pungkula iluntankuku. Palula-tawaraṉa palunya maḻanymankuku, kaṉi tjinguṟu wantiku pungkuwiyangku.” Munu paluṟu alatji kuliṟa tjanala nguḻungku wangkangu ngunti nyanga alatji, “Wiya, minyma nyangatja ngayuku maḻanypa.” ");
INSERT INTO pjt_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Ka ngula wati mayatja panya Pimalikalu palumpa waḻinguṟu walu-nyangu, “Ai! Nyaratja Isaacalu Ripikanya ampuṟa nyunytjuṉi kuringku-palku.” ");
INSERT INTO pjt_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Munu paluṟu alatji nyakula wati kutjupa wituṉu Isaacanya aḻṯira ngalya-katinytjaku palulakutu. Munu pitjanyangka wangkangu palula, “Minyma nyara paluṟu-manti nyuntumpa kurimpa! Kan panyatja nyuntu nyaaku ngunti palunya maḻanypanmanangi?” Ka Isaacalu wangkangu, “Wiya, ngayulu kuliningi tjinguṟuṉiya ngayunya pungkuku minyma nyanga palunyakitjangku. Kaṉa iluntankunytjaku-tawara nguḻuringkula palunya kurinmankunytja wiyangku maḻanypanmanangi.” ");
INSERT INTO pjt_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Ka Pimalikalu wangkangu, “Ai! Nyaakulanyan ngunti kuraningi? Wati kutjupa tjinguṟu ngunti ngarima nyuntumpa kuringka nyuntumpa maḻanytja-palku, ka Godanya nganampa mirpaṉarima munulanya pikantanama, kala kuṉṯaringama nyuntu panya ngunti wangkanytjitjangka.” ");
INSERT INTO pjt_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Munu Pimalikalu palumpa aṉangu uwankara nguḻutjunu nyanga alatji wangkara, “Wati nyangatja palumpa kuri. Pampuntja wiyangkuya wantima, panya aṉangungku palunya pulanya pampunnyangkaṉa wangkaku pungkula iluntankunytjaku palunya.” ");
INSERT INTO pjt_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Ka Isaacalu ngura pala palula manta tjawaṟa uṉinypa tjuṉutjunkula waṉaṉu ukiṟi maitjara pakaltjingantjikitjangku. Ka mulapaṯu ukiṟi pakaṟa mai puḻkatjararingu. Ka ngula kuṟuringkunyangka Isaacalu mai puḻka mulapa uraṉu, panya Mayatja Godalu palumpa puḻka mulapa palyaṟa palunya pukuḻmanu. ");
INSERT INTO pjt_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","14","Ka paluṟu kutjupa kutjupa tjuṯatjararingu. Paluṟu ulytja puḻka, kuka tjuṯa mulapa kuḻu kanyiningi, aṉangu panya palumpa waṟkaripai tjuṯa kuḻu. Kaya Pilitjiyanya nguraṟa tjuṯangku nyakula palunya nyaṟaringangi paluṟu puḻka mulapa kanyinnyangka. ");
INSERT INTO pjt_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Munuya palulanguṟu palunya nyaṟaringkula palumpa mina piṯi tjuṯa piḻuntaṟa tjutuṟa patinu, mina panya Aipuṟamaku wati waṟka tjuṯangku ngaṉmanytju tjawaṟa wantinytja Aipuṟamanya nyinanytja aṟangka. ");
INSERT INTO pjt_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Ka Pimalikalu Isaacala wangkangu, “Nganampa ngura wanyu wantikatira ara, panya nyuntu kuwari aṉangu tjuṯatjararingkula kuṉpu puḻkaringu, kala nganaṉa upa nguwanpa. Wantikatilanya!” ");
INSERT INTO pjt_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Ka palulanguṟu Isaacalu tjananya wantikatira anu ngura kutjupakutu munu wirkaṟa ngura tjunu Kiṟarku wimaṟungka, munu pala palula rawa nguwanpa nyinangi. ");
INSERT INTO pjt_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Munu piṯi panya palunya tjananya paluṟu piṟuku tjawaṟa mina utinu, munu paluṟu mina panya tjuṯa ininu, ini panya palu puṟunypa tjuṯa, panya palumpa mamangku Aipuṟamalu ngaṉmanytju ininingi. ");
INSERT INTO pjt_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Ka Isaacaku wati waṟka tjuṯangku piṯi kutjupa tjawaṉu minaku wimaṟu panya palula munu tjawaṟa mina utinu. ");
INSERT INTO pjt_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Palu Kiṟarnga nguraṟa kuka kanyilpai tjuṯa pikaringu Isaacaku waṟka tjuṯaku wangkara, “Mina nyangatja nganampa!” Ka palulanguṟu Isaacalu mina palunya ininu “Pikaringkunytjanya”. ");
INSERT INTO pjt_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ka Isaacaku waṟka tjuṯangku mina piṯi kutjupa tjawaṉu, kaya tjanampa palu puṟunypaṯu pikaringangi Kiṟarnga nguraṟa tjuṯa. Ka Isaacalu mina palunya ininu “Tjanampa Kuraringkunytjanya”. ");
INSERT INTO pjt_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Munu palulanguṟu Isaacanya tjana Kiṟarku wimaṟu wantikatira anu ngura kutjupakutu munu ngura tjunkula piṯi kutjupa tjawaṟa mina utinu. Kaya aṉangu kutjupa tjuṯa tjanampa pikaringkunytja wiya mina nyanga palulanguṟu. Ka palulanguṟu Isaacalu mina palunya ininu “Aḻa Lipinya”, munu wangkangu, “Kuwari Mayatja Godalu nganaṉanya aḻa lipikutuṉu, kalampa ulytja, kuka, kutjupa kutjupa uwankara tjuṯa mularariku manta nyanga palula nganaṉa nyinanyangka.” ");
INSERT INTO pjt_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Munu nyara palulanguṟu Isaacanya anu ngura Piitjiipalakutu. ");
INSERT INTO pjt_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Ka munga pala palula Mayatja Godanya utiringu palula munu alatji wangkangu palula, “Ngayuluṉa nyuntumpa mamaku God, Aipuṟamaku. Nguḻuringkuwiya nyinama panya ngayulu nyuntula tjungu nyinanyi. Ngayuluṉa nyuntunya pukuḻmankuku, ka nyuntulanguṟu aṉangu ma-tjuṯaringkuku maḻatja maḻatja, panya alatji tjuṯantjikitjangkuṉa kalkuṉu Aipuṟamanya, ngayula panya wangaṉarangku kulilpainya.” Alatji Godalu Isaacanya kalkuṉu wangkara. ");
INSERT INTO pjt_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Ka ngura pala palula Isaacalu pitjilpa puḻka palyaṉu Mayatjanya waḻkuntjikitjangku. Munu waḻkuṟa wiyaringkula paluṟu nguralta tjunkula nyinangi, kaya palumpa wati waṟka tjuṯangku piṯi kutjupa tjawaṟa mina utinu. ");
INSERT INTO pjt_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Ka wati panya Pimalikanya Kiṟartanguṟu palulakutu pitjangu Isaacanya nyakunytjikitja. Munu paluṟu palumpa mayatja palula maḻatja kutjara kuḻu katingu, kutju ini Awutjanya panya palumpa maḻpa mulapa, ka kutjupa ini Pikalnga panya palumpa tjaultji tjuṯaku mayatja. ");
INSERT INTO pjt_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Ka wirkankunyangka Isaacalu tjapinu tjanala, “Nyaaku nyura ngayulakutu pitjangu kuwari nyanga? Panya ngaṉmanypa nyuntu maḻpa kura nyinangi ngayuku, munuṉi nyuntumpa nguranguṟu paiṟa iyaṉu maḻpa wiyangku.” ");
INSERT INTO pjt_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Kaya wangkangu, “Wiya, nganaṉa nyangu Godalu tiṯutjarangku nyuntunya alpamilannyangka, munula kulinu, ‘Utila Isaacala tjunguringkula ngaparku wangkara kalkunma kalypa nyinanytjikitjangku.’ Kala wanyu nyuntu nganaṉanku kuwari kalkunma kalypa nyinanytjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Nyuntulanya kalkunma nganaṉanya pungkunytja wiyangku wantinytjikitjangku, panya nganaṉa ngaṉmanytju nyuntunya pungkuwiyangku wantingi munula nyuntunya mirpaṉṯu paiṟa iyantja wiyangku purkaṟangku wituṟa ma-iyaṉu. Ka nyuntu wanyu palu puṟunypa nganaṉanya pungkuwiyangku wantima. Alatjilanya kalkunma. Panya nganaṉa utingku nyanganyi Godalu nyuntunya alpamilaṟa pukuḻmankunyangka.” ");
INSERT INTO pjt_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Ka Isaacalu tjanampa mai puḻka palyaṉu munuya tjunguringkula puḻkaṟa ngalkula tjikiṟa paḻtjaringkula pukuḻaringu munuya ngura pala palula munga kutju ngaringu. ");
INSERT INTO pjt_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Munuya mungawinki mulapa pakaṉu munuya nyara palula aṟa ngaparku kalkuṉu kalypa nyinanytjikitjangku. Munuya kalkuntjatjanungku wangkangu tiṯutjarangku kulintjikitjangku wantinytja wiyangku. Ka palulanguṟu Isaacalu tjananya wati panya maṉkurpa wangkara iyaṉu tjanampa maḻparingkunytjatjanungku. ");
INSERT INTO pjt_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ka tjiṟirpi pala palula Isaacaku wati waṟka tjuṯangku pitjala tjakultjunu panya tjana piṯi tjawaṟa mina utintja. Panya tjana wirkaṟa wangkangu, “Awari! Nganaṉala tjawaṟa mina utinu.” ");
INSERT INTO pjt_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Ka palulanguṟu Isaacalu mina palunya ininu “Kalkuntjanya”. Palulanguṟu ngura nyara paluṟu ini nyangatja ngaṟanyi “Piitjiipanya”, panya ini nyanga palunya wangkanyi, “mina piṯi kalkuntjitja” tjanampa wangkangku. ");
INSERT INTO pjt_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Ka wati panya Iitjulu yiya nampa panya 40 nyinanytjatjanungku kungka Iitakunu kutjara aḻṯingu malikitja kutjara, kutju ini Tjutitjanya panya wati Piiṟiku uṉṯalpa, kutjupa ini Patjimatjanya panya wati Iilanku uṉṯalpa. ");
INSERT INTO pjt_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Palu kungkawaṟa nyanga paluṟu pula Isaacanya pulanya Ripikanya puḻkaṟa tjituṟu-tjituṟu palyaningi kura nyinara. ");
INSERT INTO pjt_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Ka Isaacanya tjiḻpi mulararingu munu kuṟu paulyarira puṯu nyangangi. Munu paluṟu katja ngaṉmanyitja Iitjunya aḻṯira wangkangu, “Katja, yaaltjin?” Ka wangkangu, “Uwa, nyangatjaṉa ngaṟanyi.” ");
INSERT INTO pjt_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Ka Isaacalu wangkangu, “Nyawaṉi katja! Ngayuluṉa tjiḻpi mulararingu munuṉa tjinguṟu kuwari nguwanpa iluku. ");
INSERT INTO pjt_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Ka-puṯa nyuntu punaṟa mantjiṟa ilytjikutu ara kukaku munutju kuka wakaṟa kati. ");
INSERT INTO pjt_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Munu ngalya-katira pauṟa palyala kuka wiṟu mulapa panya nyuntutjun kuka wiṟu palyalpai kaṉa pukuḻpa mulatu ngalkupai. Munuṉa palulanguṟu ngalkula paḻtjaringkula ngayulu nyuntunya wangkara pukuḻmankuku ilunytja kuwaripangka.” ");
INSERT INTO pjt_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","6","Ka Ripikalu kuliningi Isaacalu katjangka wangkanyangka. Munu Iitjunya kukaku ankunyangka minyma paluṟu katja panya maḻatja Jacobanya aḻṯira wangkangu, “Katja kulila! Ngayulu kulinu nyuntumpa mamangku Iitjula wangkanyangka. ");
INSERT INTO pjt_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Alatji paluṟu wangkangu, ‘Kukatju wakaṟa kati munuṉi pauṟa uwa kuka wiṟu mulapa, kaṉa ngalkula pukuḻarira nyuntunya wangkara pukuḻmankuku Mayatja Godala miṟangka ngayulu ilunytja kuwaripangka.’ Alatji paluṟu Iitjula wangkangu. ");
INSERT INTO pjt_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Palu katja kulilaṉi, munu ngayulu wangkanytja palyala wangaṉarangku. ");
INSERT INTO pjt_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Nganampa nanikuta tjuṯakutu ankula yangupala kutjara mantjiṟa ngalya-kati kaṉpi puḻka kutjara kuka wiṟu, kaṉa pauṟa palyalku kuka wiṟu mulapa panya nyuntumpa mamangku pukuḻṯu ngalkuntjaku. ");
INSERT INTO pjt_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Ka nyuntu katira palunya uwa ngalkuntjaku, ka paluṟu ngalkula pukuḻarira nyuntunya wangkara pukuḻmankuku ilunytja kuwaripangka.” Alatji ngunytjungku Jacobanya wangkangu. ");
INSERT INTO pjt_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Palu Jacobalu wangkangu, “Palu ngayuku kuṯa inyu puḻka kaṉa ngayulu miṟi wiṟuly-wiṟulypa inyu wiyatjara. ");
INSERT INTO pjt_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Ka tjinguṟu Mamalu ngayunya pampuṟa kulilku ngayulu Iitjunya puṟunypa wiya, munuṉi ngunti kurannyangka kuliṟa ngayunya pukuḻmankuwiyangku kuranmankuku.” Alatji Jacobalu wangkangu kuranmankunytjaku-tawara nguḻuringkula. ");
INSERT INTO pjt_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Ka ngunytjungku wangkangu, “Wiya wanti nguḻuringkunytja wiyangku, katja, panya mamangkunta nyuntunya kuranmankulampa ngayunya waintaṟa kulilku kura, nyuntunya wiyangku. Ka nyuntu ngayunya wangaṉarangku kuliṟa ankula nanikuta kutjara pungkula ngalya-kati.” ");
INSERT INTO pjt_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Ka palulanguṟu kuliṟa anu mantjintjikitja, munu pungkula ngalya-katingu ngunytjukutu. Ka paluṟu pauṟa palyaṉu kuka wiṟu mulapa Isaacalu pukuḻṯu ngalkuntjaku. ");
INSERT INTO pjt_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Munu palulanguṟu Iitjuku mantara wiṟu mantjinu munu Jacobanya tjarpatjunu. ");
INSERT INTO pjt_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Munu palula miṉangka nanikuta panya miṟi inyu winki tanpaṉu piningka kuḻu. ");
INSERT INTO pjt_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Munu kuka panya wiṟunyalta Jacobanya ungkul'iyaṉu mai nyuma kuḻu palyantjatjanungku palumpa mamakutu katinytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Ka Jacobanya mamakutu ankula mama waḻkuṟa wangkangu, “Mama!” Ka wangkangu, “Uwa katja! Ngananyan wanyu?” ");
INSERT INTO pjt_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Ka Jacobalu wangkara Iitjulu-palku wangkangu, “Ngayuluṉa katja panya ngaṉmanyitja Iitjunya. Panya ngayulu nyuntu wangkanytja palyaṉu. Wanyu pakaṟa nyina munu kuka nyanga ngayulu katinytja ngalkula, munuṉin palulanguṟu pukuḻmanamalta.” ");
INSERT INTO pjt_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Ka Isaacalu urulyaraṟa wangkangu, “Yaaltji-yaaltjingkun mapalkungku kuka wakaṟa katingu?” Ka Jacobalu wangkangu, “Wiya, Mayatja panya God nyuntumpangkuṉi alpamilaṉu tjukaṟurungku nguriṟa wakantjaku.” ");
INSERT INTO pjt_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Ka Isaacalu puṯu nguwanpa mulamularingkula wangkangu, “Ngalya-ilariwa, kaṉanta pampula. Nyuntu wanyu mulapa Iitjunya?” ");
INSERT INTO pjt_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Ka Jacobanya ngalya-ilaringkunyangka mamangku pampuṟa wangkangu, “Nyuntu Jacobanya puṟunypa wangkanyi, palu nyuntu miṉa Iitjunya puṟunypa.” ");
INSERT INTO pjt_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","24","Palu paluṟu kuṟu paulytju Iitjunya-palku kuliningi panya miṉa inyu puḻka Iitjunya puṟunypa pampuṟa. Munu paluṟu pukuḻmankunytjikitjangku kuliningi munu kuliṟa piṟuku tjapinu, “Nyuntun mulapa Iitjunya?” Ka paluṟu wangkara wangkangu, “Uwa, ngayulu Iitjunya.” ");
INSERT INTO pjt_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Ka Isaacalu wangkangu, “Uwa katja! Kuka pala ngalya-kati, kaṉa ngalkula wiyaringkula nyuntunya pukuḻmankuku.” Ka Jacobalu kuka panya katira ungu munu waina kuḻu ungu tjikintjaku, ka nyinara ngalkula tjikiningi. ");
INSERT INTO pjt_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Ka palumpa mamangku wangkangu, “Uwa katja! Ila pitja munuṉi mitamita kutjara nyunytjula.” ");
INSERT INTO pjt_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Munu paluṟu nyunytjuntjikitja ilaringkunyangka Isaacalu palumpa mantara paṉṯiṟa Iitjunya-palku kulinu, munu palulanguṟu palunya pukuḻpa palyaṉu alatji wangkara, “Awa! Ngayuku katja paṉṯinyi kaana wiṟu puṟunypa, panya Godalu wiṟu tjuṯa pakaltjingantja puṟunypa. ");
INSERT INTO pjt_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Ka Godalu ilkaṟinguṟu nyuntumpa mantakutu kulyarpa puḻka iyalku munu manta nyuntumpa wiṟu palyalku ukiṟi uṉinypatjara puḻka pakantjaku, kiṟipitji puḻka tjuṯa kuḻu pakannyangka waina kuḻu palyantjaku. ");
INSERT INTO pjt_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Kaya aṉangu ngura kutjupa kutjupa tjuṯanguṟu nyuntumpa waṟkaripai nyinaku, munuya nyuntunya waḻkuntjikitja nyuntula kuranyu tultjungaṟakatiku. Kan uwankaraku mayatjariku nyuntumpa walytjapitiku, kaya paluṟu tjana nyuntula kuranyu tultjungaṟakatiku nyuntunya waḻkuntjikitja, aṉangu panya nyuntumpa ngunytjunguṟu tjuṯaringkunytja tjuṯa kuḻu. Ka aṉangungku nyuntunya kuranmankunyangkampa Godalu palunya ngapartji kuranmankukuṯu, munu aṉangungku nyuntunya pukuḻmankunyangkampa Godalu palunya ngapartji pukuḻmankukuṯu.” Alatji Isaacalu wangkara pukuḻmanu palumpa katja Jacobanya ngunti kuliṟa Iitjunya-palku. ");
INSERT INTO pjt_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Ka palula maḻangka Jacobanya pakaṟa ankunyangka palumpa kuṯa Iitjunya pitjangu kukatjara. ");
INSERT INTO pjt_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Munu paluṟu kuka wiṟu pauṟa katingu palumpa mamakutu, munu wangkangu, “Mama, wanyu pakaṟa nyina munu kuka nyanga ngayulu katinytja ngalkula, munuṉin palulanguṟulta pukuḻmanama.” ");
INSERT INTO pjt_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Ka Isaacalu tjapinu, “Ngananyan wanyu nyuntu?” Ka wangkangu, “Nyuntumpa katja panya ngaṉmanyitjaṉa, Iitjunya.” ");
INSERT INTO pjt_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Ka Isaacalu nyanga palunya kuliṟa puḻkaṟa tjititingkula wangkangu, “Nganaluṉi panyatja wanyu kuka panya katira ungu? Kaṉa kuwari kutju ngalkula wiyaṉu nyanga nyuntu pitjanytja kuwaripangka. Alatjiṯuṉa palunya pukuḻmanu, ka palulanguṟu palumpa pukuḻpa tiṯutjara ngaṟaku.” ");
INSERT INTO pjt_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Ka Iitjulu nyanga palunya kuliṟa unngu kuraringkula mirara wangkangu, “Mama! Ngayunya ngapartjiṉi pukuḻmara.” ");
INSERT INTO pjt_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ka Isaacalu wangkara wangkangu, “Wiya, nyuntumpa maḻanypangku pitjala ngayunya ngunti kuraṉu. Panya ngayulu nyuntunya pukuḻmankunytjikitjangku kalkuṉu, ka paluṟu anga-pitjangu, kaṉa palunya pukuḻmanu nyuntunya-palku.” ");
INSERT INTO pjt_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ka Iitjulu wangkangu, “Palu mulapa nyaratja ini Jacobanya, panya nyangatjaṉi piṟukuṯu ngunti kuraṉu. Panya paluṟu mungaṯu ngayunya mai ungkula wangkangu maḻanypa nyinanytjaku paluṟu kuṯaringkula ngula nyuntumpa aṟangka nyinanytjikitjangku. Munu kuwari nyanga paluṟu nyuntulakutu anga-pitjangu, kan palunya pukuḻmanu ngayunya-palku. Mama! Kan ngayunya kuḻu pukuḻmankunytjaku ngaṟanyi?” ");
INSERT INTO pjt_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Ka Isaacalu wangkangu, “Wiya, ngayulu panya ngaṉmanytju palunya nyuntumpa mayatja tjunu. Munuṉa nyuntumpa walytjapiti uwankara tjunu palumpa waṟkarinytjaku. Munuṉa palunya ungu mai waina kuḻu. Ka katja, palulanguṟu nyuntumpa maḻa piṟuku palyantjaku wiya ngaṟanyi.” ");
INSERT INTO pjt_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ka Iitjulu piṟukuṯu puḻkaṟa tjapiningi palumpa mamangka alatji wangkara, “Mama! Nyuntu wanyu kutju-aṟa kutju pukuḻmankupai? Wanyuṉi ngayunya kuḻu pukuḻmanama.” Munu paluṟu puṯu tjapiṟa ulangu. ");
INSERT INTO pjt_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Ka Isaacalu palunya wangkangu, “Godalu ilkaṟinguṟu nyuntumpa mantakutu kulyarpa puḻka iyantja wiyangku wantiku, munu paluṟu manta nyuntumpa wiṟu palyantja wiyangku wantiku ka ukiṟi wiṟu pakantja wiyaṯu. ");
INSERT INTO pjt_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ka nyuntu tjuḻatjara rawa aṉangu tjuṯaku pikaringkuku, munu nyuntu palumpa waṟkaripai nyinaku Jacobaku panya paluṟu nyuntumpa kuṯaringu. Palu ngula nyuntu palula tungunpungkula pikaringkuku Jacobaku ka paluṟu nyuntumpa mayatja wiyaringkuku.” Alatji Isaacalu Iitjunya wangkangi kurangka nyinanytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ka Iitjunya puḻkaṟa mirpaṉaringu Jacobaku panya palumpa mamangku palunya pukuḻmankunyangka. Munu paluṟu iluntankunytjikitjangku kuliningi Jacobanya. Munu kulinu, “Mamanya ilunytjaku ilaringanyi, kaṉa ilunyangka ulara wiyaringkula palulanguṟulta Jacobanya iluntankuku.” ");
INSERT INTO pjt_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","45","Palu Ripikalu kulinu Iitjulu alatji wangkanyangka munu tjituṟu-tjituṟurira wangkangu, “Kuwari ngayuku katja kutjarangku pulanku pungkula ilunyi, kaṉa tjiṉṯu kutjungka palunya pulanya kawalinkuku.” Munu palulanguṟu wati kutjupa wituṉu Jacobanya aḻṯira ngalya-katinytjaku munu pitjanyangka wangkangu, “Katja kulila! Nyuntumpa kuṯa Iitjunya pukuḻarinyi nyuntunya iluntankunytjikitja wangkara. Ka katja wanyu ngayulu wangkanytja wangaṉarangku kulinma munu mapalku ankula nyinama ngayuku kuṯa Laipanta ngura nyara Aaṟanta. Munu nyara palula nyinama nyuntumpa kuṯa mirpaṉpa wiyaringkunytjaku paṯaṟa. Panya ngula paluṟu watarkuriku nyuntu panya palunya ngunti kurantjitjaku. Kaṉa palulanguṟu wati kutjupa iyalku nyuntunya maḻakungku aḻṯira ngalya-katinytjaku. Palya?” ");
INSERT INTO pjt_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Ka palulanguṟu Ripikalu ankula Isaacala wangkangu, “Ngayulu kaar-kaararingu Iitjuku kuri kutjarangka tjungu nyinara nyinara, panya paluṟu pula ngura nyanga Kainannga nguraṟa, kura kutjara. Ka tjinguṟu Jacobalu palu puṟunytjuṯu kungkawaṟa ngura Kainannga nguraṟa aḻṯiku, kaṉa palulanguṟu kaar-kaararira paku puḻkaringkuku.” Alatji Ripikalu Isaacala wangkangu panya paluṟu kuliningi Isaacalu Jacobanya iyantjaku. ");
INSERT INTO pjt_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Ka Isaacalu Jacobanya aḻṯira pukuḻmaṟa wangkangu, “Katja! Kungka nyanga Kainannga nguraṟa aḻṯinytja wiyangku wantima. ");
INSERT INTO pjt_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Palu ngura nyara Mitjupu-taimiyalakutu ara nyuntumpa tjamu Pitjuwilku ngurakutu munu kungka ngura nyara palunya nguraṟa aḻṯi nyuntumpa kulypalku Laipanku uṉṯalpa. ");
INSERT INTO pjt_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Kaṉa God Witulya Puḻkangka nyuntumpa tjapini nyupalinya pukuḻmaṟa tjitji tjuṯa ungkunytjaku, kaya palula tjanalanguṟu nyuntumpa walytja ma-tjuṯa mularariku maḻatja maḻatja munuya ngura kutjupa kutjupa tjuṯangka nyinara waṉalku. ");
INSERT INTO pjt_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Ka Godalu nyuntunya munu nyuntumpa walytja tjuṯa kuḻu pukuḻmankuku. Panya paluṟu ngaṉmanytju Aipuṟamanya pukuḻmanu, palu puṟunypa paluṟu nyuranya pukuḻmankuku munu manta nyanga malikitja nyuntu kuwari nyinanytja nyuranya ungkuku, ka nyura aṉangu kutjupa tjuṯanguṟu tjulyaṟa walytjangku kanyilku. Panya Godalu Aipuṟamanya ngaṉmanytju kalkuṉu manta nyangatja ungkunytjikitjangku palumpa walytjapiti maḻatja maḻatja kuḻu.” Alatji Isaacalu Jacobanya pukuḻmaṟa wangkangu. ");
INSERT INTO pjt_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Munu palulanguṟu Jacobanya iyaṉu ngura nyara Mitjupu-taimiyalakutu, palumpa kulypalpa Laipantakutu. Panya Laipanku mama wati panya Pitjuwilnga ngura Aṟamanya nguraṟa. Ka Laipanku maḻanypa Ripikanya panya Jacobaku pulampa Iitjuku ngunytju. ");
INSERT INTO pjt_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","7","Ka maḻangka Iitjulu kulinu palumpa mamangku Jacobanya pukuḻmaṟa kuriku iyantja ngura panya Mitjupu-taimiyalakutu. Munu paluṟu Jacobanya mamangku wangkanytjitja kuḻu kulinu panya kungka Kainannga nguraṟa aḻṯinytja wiyangku wantinytjaku. Palu Jacobanya wangaṉara ankunyangka kutju paluṟu kulinu. ");
INSERT INTO pjt_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Pala palulanguṟulta Iitjulu kulinu, “Munta-uwa panya! Ngayuku mamangku kungka Kainannga nguraṟa wantipai alatjiṯu mukuringkunytja wiyangku.” ");
INSERT INTO pjt_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Munu alatji kuliṟa Iitjulu ankula Aipuṟamaku katjangka Itjumailta kungkaku tjapinu, ka palumpa uṉṯalpa ini Maalatjanya palunya ungu wati panya Nipayatjaku nyarumpa, ka Iitjulu aḻṯira kanyiningi kuri kutjupa kutjarangka tjungu. ");
INSERT INTO pjt_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Ka Jacobanya ngura panya Piitjiipanya wantikatira ma-pakaṉu ngura panya Aaṟanku. ");
INSERT INTO pjt_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Munu paluṟu ankula ankula ngura kutjupangka nguṟurpa wirkanu munu mungartjirinyangka nyakula ngura tjunu. Munu paluṟu katamala wiyangka apu mantjinu munu kata tjunkula ngarikatingu. ");
INSERT INTO pjt_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Munu paluṟu kunkunpa ngarira tjukurmanangi tjukalpa mantanguṟu ilkaṟikutu ma-ngaṟanyangka, kaya Godaku angelpa tjuṯa ngalya-ukalingkula ma-tatiningi tjukalta panya. ");
INSERT INTO pjt_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Munu paluṟu Godanya nyangu palula itingka ngaṟanyangka, ka wangkangu palula nyanga alatji, “Ngayuluṉa Mayatja Godanya, panya nyuntumpa tjamungku Aipuṟamalu ngayunya waḻkuṉu, nyuntumpa mamangku Isaacalu kuḻu. Kaṉa ngayulu manta pala nyuntu ngarinytjanya nyuntunya unganyi nyuntumpa walytja tjuṯa kuḻu maḻatja maḻatja. ");
INSERT INTO pjt_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Kaya paluṟu tjana ma-tjuṯaringkula winki mularariku maḻatja maḻatja, munuya minga puṟunyarira mungilyi mulapa nyinaku. Munuya aḻa lipiwanu nyinaku alinytjara kakaraṟa uḻpaṟira wiluṟara. Kaṉa nyuntulanguṟu munu nyuntumpa walytjapiti maḻatja maḻatjanguṟu kuḻu ngayulu aṉangu manta winkitja palyaṟa pukuḻmankuku. ");
INSERT INTO pjt_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Palu kulinma! Ngayuluṉa nyuntula tjungu pitjalinkuku munuṉanta aṯunytju kanyilku. Munuṉanta maḻakungku katiku ngura nyangaku. Panya ngayulu kalkuntjatjanungku uwankara palyalku wantinytja wiyangku.” Alatji Godalu Jacobala wangkangu paluṟu tjukurmankunyangka. ");
INSERT INTO pjt_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Ka Jacobalu wankaringkula wangkangu, “Ai! Mulapa Mayatja Godanya ngura nyangangka ngaṟanyi, kaṉa ngurpaṯu pitjala ngaringi.” ");
INSERT INTO pjt_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Munu paluṟu nguḻu-nguḻuringkula wangkangu, “Ngura miḻmiḻpa nyangatja Godaku ngura! Nyanga aḻa ngaṟanyi ngura ilkaṟitjakutu.” Munu alatji wangkara piṟuku kunkunaringu. ");
INSERT INTO pjt_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Munu mungawinki mulapa pakaṟa puḻi panya katangka tjunkula ngarinytja mantjiṟa muṟutjunu ngula nyakunytjikitjangku munu paluṟu uwilangka kurpiṟa miḻmiḻmanu apu panya palunya Godanya kulintjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ka ngura pala palula itingka tawunu ini Latjanya ngaṟangi, palu Jacobalu ini kutjupa tjunu “Pitjulnga” panya ini nyanga palunya wangkanyi “Godaku ngura” tjanampa wangkangku. ");
INSERT INTO pjt_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","21","Ka palulanguṟu Jacobalu Mayatja Godanya wangkara kalkuṉu nyanga alatji, “Nyuntu ngayula tjungu pitjalinkunyangka, munu aṯunytju katiṟinkunyangkampa, munu mantara mai kuḻu ungkunyangka, munu maḻakungku ngayuku mamaku ngurakutu katinyangkampa ngayulu nyuntunya mayatjanmaṟa waḻkulku ngayuku God. ");
INSERT INTO pjt_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Nyangatjaṉa apu muṟutjunu panya tjana nyuntunya kuliṟa waḻkuntjaku ngura nyanga miḻmiḻṯa Godaku ngurangka. Munuṉanta ngayunya ungkunytjanguṟu tjaraṟa tjukutjuku maḻakungku ungkuku. Tjinguṟuṉin puluka 10-pa ungkuku, kaṉanta puluka kutju maḻakungku ungkuku. Munta tjinguṟuṉin tjiipi 20 ungkuku, kaṉanta tjiipi kutjara maḻakungku ungkuku. Alatjiṉa nyuntu ngayunya ungkunytja uwankaranguṟu tjaraṟa maḻakungku ungkuku tiṯutjarangku kuḻi kutjupa kuḻi kutjupa.” ");
INSERT INTO pjt_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Munu palulanguṟu Jacobanya piṟuku anangi ngura panya Aaṟantakutu munu kakaraṟa ankula ankula wirkanu. ");
INSERT INTO pjt_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Munu nyara palula nyangu mina piṯi ngaṟanyangka. Ka piṯingka itingka tjiipi tjuṯa ngarira waṉingi uṯuḻu maṉkurpa, panya tjana piṯi pala palulanguṟu mina tjutiṟa ungkunytjaku paṯaningi. Ka piṯi tjaangka apu puḻka anga-ngaringi. ");
INSERT INTO pjt_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Kaya wati tjiipi kanyilpai tjuṯangku tjiipi panya tjuṯa uṯuḻu kutju kutju minakutu ngalya-katira apu taaṉpa piṯi tjaanguṟu uṉṯuṟa waṉaṟa mina utilpai, munuya palulanguṟu tjiipi tjuṯa mina tjutiṟa ungkupai. Munuya tjikiṟa wiyaringkunyangka apu panya maḻakungku uṉṯuṟa waṉaṟa angatjunkupai aṟangkaṯu. ");
INSERT INTO pjt_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Ka Jacobalu wirkaṟa wangkangu tjiipi kanyilpai tjuṯangka, “Wati wiṟu tjuṯa! Nyura ngura ngananya nguraṟa?” Kaya wangkangu, “Nganaṉa Aaṟannga nguraṟa tjuṯa.” ");
INSERT INTO pjt_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Ka Jacobalu tjapinu tjanala, “Palu nyura wanyu ninti wati Laipanku panya Nayuku katjaku?” Kaya wangkangu, “Uwa, nganaṉa ninti palumpa.” ");
INSERT INTO pjt_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Ka piṟuku tjapinu, “Ka paluṟu palya nyinanyi?” Kaya wangkangu, “Uwa, paluṟu palya nyinanyi. Palu nyawa nyara palumpa uṉṯalpa ini Raitjilnga tjiipi tjuṯatjara pitjanyi.” ");
INSERT INTO pjt_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Ka Jacobalu tjanala wangkangu, “Palu nyaaku nyura nyangangka nyinara paṯaṉi? Panya nyangatja mungartjirinytja wiya kuwaripa kaḻaḻaṯu ngaṟanyi. Uti nyura tjiipi tjuṯa minatjanuṟa maḻakungku katiku ukiṟikutu, panya tjananya yaatangka tjarpatjunkunytjaku ngaṟanytja wiya kuwaripaṯu, nyangatja kaḻaḻa.” ");
INSERT INTO pjt_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Kaya wangkangu, “Wiya nganaṉa mina ungkunytja wiyangku paṯaṉi tjiipi uṯuḻu kutjupa kutjupa uwankara pitjanytjaku. Palulanguṟu kutjula apu panya uṉṯuṟa waṉaṟa mina utilku munu tjiipi tjuṯa mina tjutiṟa ungkuku.” ");
INSERT INTO pjt_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","10","Ka Jacobanya kuwaripa ngaṟala wangkanyangka Raitjilnga ngalya-wirkanu palumpa mamaku tjiipi tjuṯatjara. (Raitjilku mama panya wati ini Laipannga, Jacobaku panya kulypalpa.) Ka Jacobalu wirkankunyangka nyakula mina piṯikutu ankula puḻi panya uṉṯuṟa waṉaṟa Laipanku tjiipi tjuṯa tjutiṟa ungu. ");
INSERT INTO pjt_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Munu palulanguṟu Raitjilnga mitamita kutjara nyunytjuṟa pukuḻarira ulangi. ");
INSERT INTO pjt_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Munu palula wangkangu, “Ngayulu panya nyuntumpa kuṉṯiliku katja Ripikaku, panya paluṟu munu nyuntumpa mama ngunytju kutjutja.” Ka nyangatja kuliṟa Raitjilnga ngurakutu wirtjapakaṟa mamangka tjakultjunu. ");
INSERT INTO pjt_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Ka Laipantu kuliṟa mapalku wirtjapakaṉu palumpa ukaṟikutu ngapari-ngapari munu ampuṟa mitamita kutjara nyunytjuṉu munu aḻṯira katingu palumpa ngurakutu. Ka Jacobalu kulypalta uwankara tjakultjunu ngura nyara palula tjana nyinanytjatjanungku Isaacanya, Ripikanya Iitjunya tjananya kuḻu. ");
INSERT INTO pjt_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Ka Laipantu kuliṟa palula wangkangu, “Nyuntu ngayuku ukaṟi walytja mulapa.” Ka Jacobanya nyara palula nyinangi piṟa kutju munu palumpa kulypalta waṟkaringi. ");
INSERT INTO pjt_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Ka Laipantu Jacobala wangkangu, “Nyuntu panya ngayuku ukaṟi munun nyaaku unytju ngayuku waṟkarima. Utiṉanta kutjupa kutjupa ungama. Palu nyaa ungkunytjakun mukuringanyi?” ");
INSERT INTO pjt_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Ka panya Laipanku uṉṯalpa kutjara nyinangi, kangkuṟu ini Liyanya, munu palumpa maḻanypa Raitjilnga. ");
INSERT INTO pjt_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","18","Ka Jacobalu pulanya nyakula Raitjilku kutju puḻkaṟa mukuringangi, panya Liyanya wiya nguwanpa kuṟu lanma-lanma, palu palumpa maḻanypa kuṟu mantjil-mantjilpa kungkawaṟa wiṟu mulapa. Ka wati panya paluṟu wangkangu Laipanta, “Uwa palya, ngayulu Raitjilngakitja nyuntumpa piṟuku waṟkariku yiya tjuṯa nampa 7-kutu, kaṉi palula maḻangka ngayunya uwa aḻṯinytjaku. Palya?” ");
INSERT INTO pjt_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Ka Laipantu wangkangu, “Wiya palya. Ngayulu tjinguṟu wati kutjupa ungkulampa pukuḻarinytja wiya nguwanpa, palu ngayulu puḻkaṟa pukuḻarinyi nyuntunya ungkunytjikitja palunya aḻṯinytjaku. Palya nyuntu ngayula nyinara waṟkarima.” ");
INSERT INTO pjt_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Ka palulanguṟu Jacobanya yiya tjuṯa waṟkaringi nampa panya 7 Raitjilnga aḻṯinytjikitja. Palu panya Jacobanya Raitjilku puḻkaṟa mukuringkunyangka yiya panya 7 paluṟu tjana mapalku nguwanpa ngaṟala wiyaringu tjiṉṯu maṉkurpa puṟunypa. ");
INSERT INTO pjt_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Munu palulanguṟu yiya panya 7 ngaṟala wiyaringkunyangka Jacobalu Laipanta wangkangu, “Uwa, yiya tjuṯa waṯalpi wiyaringu! Walangkuṉi uwa nyuntumpa uṉṯalpa.” ");
INSERT INTO pjt_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Ka Laipantu mai kuka puḻka mulapa palyaṟa aṉangu nguratja tjuṯa aḻṯingu pitjala ngalkula pukuḻarinytjaku Jacobaku pulampa Raitjilku. ");
INSERT INTO pjt_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Palu mungaringkunyangka Laipantu uṉṯalpa ngaṉmanyitja Liyanya katira ungu Jacobanya, ka Jacobanya palula tjunguringu Raitjilta-palku. ");
INSERT INTO pjt_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Munu Laipantu kungkawaṟa waṟkaripai ini Tjilpanya palumpa uṉṯalpa ungu palumpa waṟkarinytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Palu Jacobalu ngarira tjiṉṯuringkula kutju nyangu, “Ai! Liyanyampal nyangatja, Raitjilnga wiyampa.” Munu paluṟu ankula Laipanta wangkangu, “Nyaakuṉin Liyanya ungu? Ngayulu panya yiya tjuṯa nyuntumpa waṟkaringi Raitjilngakitja, panyatja! Kaṉin nyaaku ngunti kuraṉu?” ");
INSERT INTO pjt_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Ka Laipantu wangkangu, “Wiya nganaṉa tjakangku uṉṯalpa ngaṉmanyitja-waraṟa aḻṯinytjaku ungkupai, munula palula maḻangkalta maḻanypa ungkupai. ");
INSERT INTO pjt_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Palu kulila! Nyanga kuwarila mai kuka puḻka ngalkuṉi tjiṉṯu 7-kutu nyupalimpa pukuḻarira, kaṉa palula maḻangka Raitjilnga nyuntunya ungkuku, nyuntu yiya tjuṯa kutjupa nampa 7 piṟuku ngayuku waṟkarinyangka. Palya? Kan kuwari Liyala tjunguringama tjiṉṯu panya 7-kutu.” ");
INSERT INTO pjt_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Ka Jacobalu uwanmanu, munu paluṟu Liyala tjunguringangi munga kutjupa munga kutjupa tjiṉṯu panya 7-kutu. Ka palulanguṟu Laipantu uṉṯalpa maḻatja palunya ungu Raitjilnga, ka aḻṯira kuri kutjaratjara nyinangi. ");
INSERT INTO pjt_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Ka Laipantu kungkawaṟa waṟkaripai kutjupa ini Pilanya ungu Raitjilnga palumpa waṟkarinytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Ka Jacobanya Raitjilta kuḻu tjunguringu munu palumpa puḻkaṟa pukuḻaringi panya paluṟu Liyaku tjuku nguwanpa mukuringangi munu panya Raitjilku puḻkaṟa mulapa mukuringangi. Munu paluṟu Laipanku piṟuku waṟkaringi yiya kutjupa tjuṯa nampa panya 7. ");
INSERT INTO pjt_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Ka Mayatja Godalu nyangu Jacobanya Raitjilku puḻkaṟa nguwanpa mukuringkunyangka Liyanya wantira. Munu palulanguṟu Raitjilnga iṯi kanyintjaku wiyaṉu, munu Liyanya kutju iṯitjararingkunytjaku palyaṉu. ");
INSERT INTO pjt_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Ka palulanguṟu Liyanya iṯitjararingkula paku nyinangi munu iṯi katja kanyinu munu ininu Rupinnga panya paluṟu alatji kuliningi, “Godalu nyangu Jacobalu ngayunya wantira tjituṟu-tjituṟurinyangka, munuṉi palulanguṟu pukuḻmanu katja nyanga ungkula. Ka tjinguṟu palulanguṟu mukuringkuku ngayuku.” Alatji Liyalu kuliningi. ");
INSERT INTO pjt_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Munu palulanguṟulta piṟukuṯu iṯitjararingu, munu katja kutjupa kanyinu, munu wangkangu, “Godalu ngayunya katja kutjupa ungu Jacobalu ngayunya mukuringkuwiyangku wantinyangka nyakula.” Munu palulanguṟu palunya ininu Tjimiyannga. ");
INSERT INTO pjt_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Munu paluṟu ngula piṟuku iṯitjararingu munu iṯi katja kutjupa kanyinu. Munu paluṟu wangkangu, “Ala! Tjinguṟu kuwari ngayuku kuri ngayuku puḻkaṟa mukuringkula ngayula tjungu alatjiṯu nyinaku, panya ngayulu katja maṉkurpa palumpa kanyinu.” Munu paluṟu katja palunya ininu Levinya. ");
INSERT INTO pjt_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Munu palulanguṟu piṟukuṯu iṯitjararingu minyma panya paluṟu munu katja kutjupa kanyinu. Munu paluṟu wangkangu, “Kaṉa kuwari nyanga ngayulu Mayatja Godanya kutjulta mirawaṉinyi.” Munu katja palunya ininu Judah-nya. ");
INSERT INTO pjt_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Palu Raitjiltu Jacobaku tjitji kanyintja wiya alatjiṯu, munu paluṟu palumpa kangkuṟuku nyaṟaringkula wangkangu Jacobala, “Nyaakun ngayula tjitji utilwiyangku wantinyi? Ngayulu tjitji kanyintjikitja mukuringanyi. Palu ngayulu tjinguṟu iluku iṯi wiyaṯu.” ");
INSERT INTO pjt_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Ka Jacobanya palumpa mirpaṉaringu munu wangkangu, “Ngayulu Godanya wiya. Paluṟu nyuntunya palyaṉu tjitji wiya nyinanytjaku.” ");
INSERT INTO pjt_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ka Raitjiltu wangkangu, “Nyangatja kungkawaṟa ngayuku waṟkaripai ini Pilanya. Utin nyanga palula tjunguringama, ka paluṟu iṯitjararingkula kanyilku tjitji ngayuku. Kaṉa tjitji pala palumpa ngunytju puṟunyariku nyuntu kungkawaṟa palula utinnyangka.” ");
INSERT INTO pjt_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Munu palulanguṟu Raitjiltu Pilanya ungu Jacobanya kuri kanyintjaku, ka Jacobalu palula tjunguringu. ");
INSERT INTO pjt_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Ka palulanguṟu paluṟu iṯitjararingu Pilanya munu katja kanyinu Jacobaku. ");
INSERT INTO pjt_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Ka palulanguṟu Raitjiltu wangkangu, “Ngayulu Godala puḻkaṟa ngatjiningi tjitjiku, kaṉi pukuḻṯu kuliṟa ngayunya katja ungu.” Munu paluṟu ininu Dannga katja panya palunya. ");
INSERT INTO pjt_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Ka palulanguṟu Pilanya piṟuku iṯitjararingu munu Jacobaku katja kutjupa kanyinu. ");
INSERT INTO pjt_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Ka Raitjiltu wangkangu, “Ngalinku puḻkaṟa wangkangi kangkuṟulu ngali tjitjinguṟu, kaṉa palunya wangkara kanmarmanu kuwari tjitji nyanga kutjara wirkankunytjanguṟu.” Munu tjitji palunya ininu Napatalinya. ");
INSERT INTO pjt_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Ka Liyalu tjitji kanyintja wiyaringu, munu palulanguṟu kungkawaṟa palumpa waṟkaripai ini Tjilpanya Jacobanya ungu kuri kanyintjaku. ");
INSERT INTO pjt_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Ka palulanguṟu Tjilpalu Jacobaku katja kanyinu. ");
INSERT INTO pjt_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Ka Liyalu wangkangu, “Ngangari! Alatjiṯuṉatju ngayulu katjatjararingu.” Munu tjitji palunya ininu Kaatanya. ");
INSERT INTO pjt_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","13","Ka Tjilpalu piṟukuṯu katja kutjupa kanyinu Jacobaku, ka Liyalu wangkangu, “Ngangarku! Puḻkaṟaṉa pukuḻaringu.” Munu palulanguṟu wangkangu, “Kuwariṉiya minyma tjuṯangku ngayunya pukuḻarinytjanmananyi.” Munu palulanguṟu katja panya palunya ininu Atjanya. ");
INSERT INTO pjt_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ka ngula ukiṟi wiita ma-piḻṯiringkunyangka Liyaku katja ngaṉmanyitja ini Rupinnga anu wiita nyara palulakutu munu nyangu puṉu kutjupa kutjupa ngalkula iṯitjararingkupai yunpa mingkuḻpa puṟunypa ini “mantuṟaiki”. Munu mantjiṟa katingu palumpa ngunytju Liyalakutu. Ka Raitjiltu ungkunyangka nyakula Liyala ngatjinu, “Ungamaṉi puṉu pala palunya.” ");
INSERT INTO pjt_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Ka Liyalu wangkangu, “Wiya, nyuntu panya ngayuku wati ngaṉmanytju angatjunu, munun nyaaku piṟuku ngayuku nyanga katjaku puṉuku ngatjini?” Ka palulanguṟu Raitjiltu palula wangkangu, “Palu nyuntu puṉu pala palunya ngayunya ungkulampa palya Jacobala ngariku munga nyanga kuwari. Palya?” ");
INSERT INTO pjt_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Ka Jacobanya nyara mai wiitanguṟu mungartji pitjanyangka minyma panya Liyalu ngaparikatira nyakula wangkangu, “Nyuntu ngalili munga nyanga kuwari ngarinyi, panya ngayuku katjaku puṉu panya ‘iṯi ungkupai’ ngayulu ungu Raitjilnga nyuntula ngarinytjikitjangku.” Ka palulanguṟu munga pala palula pula tjunguringkula ngaringi. ");
INSERT INTO pjt_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Ka Godalu kulinu panya Liyalu tjitjiku tjapinnyangka munu palunya palyaṉu, ka palulanguṟu paluṟu iṯitjararingu munu Jacobaku katja kutjupa kanyinu, ka maṉkurpa kutjararingu palumpa minyma panya Liyaku. ");
INSERT INTO pjt_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Munu paluṟu wangkangu, “Godaluṉi ungu katja nyangatja, panya ngayulu kungka ngayuku waṟkaripai Jacobanya ungkunytjitjanguṟu.” Munu palulanguṟu ininu tjitji nyara palunya Itjakanya. ");
INSERT INTO pjt_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Ka Liyanya piṟukuṯu iṯitjararingu munu katja kutjupa kanyinu, ka palulanguṟu katja maṉkur-maṉkuraringu Liyaku. ");
INSERT INTO pjt_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Munu Liyalu wangkangu, “Godalu ngayunya wiṟu mulapa ungu katja nyangatja, katju maṉkur-maṉkuraringu. Ka ngayuku kuri Jacobanya tjinguṟu puḻkaṟa pukuḻariku katja nyanga palumpa tjuṯa kanyinnyangka.” Munu palulanguṟu ininu Tjipulannga tjitji panya palunya. ");
INSERT INTO pjt_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Munu ngulalta Liyalu uṉṯalpa kanyinu piṟuku munu ininu Tiinanya kungka kutju. ");
INSERT INTO pjt_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Ka palulanguṟu Raitjiltu tjitjiku ngatjinnyangka Godalu kulinu munu palunya tjitji kanyintjaku palyaṉu, panya paluṟu tjitjiku ngurpa nyinangi rawa. ");
INSERT INTO pjt_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","24","Ka minyma panya paluṟu iṯitjararingu munu katja kanyinu Jacobaku. Munu wangkangu, “Godalu ngayuku tjaka wiyaṉu, kaṉa iṯi katja kanyiṟa pukuḻaringu. Kaṉa Mayatja Godala piṟukuṯu tjapini katja kutjupa ngayunya ungkunytjaku.” Munu palulanguṟu ininu katja panya palunya Josephanya. ");
INSERT INTO pjt_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Ka palula maḻangka Josephanya iṯi ngarinyangka Jacobalu palumpa kulypalta wangkangu Laipanta, “Wanyuṉi wantir'iyala ngura walytjakutu ankunytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Munuṉi uwa kuri munu tjitji tjuṯa, panya ngayulu nyuntula waṟkaringi nyanga tjananyakitja. Nyuntun ninti ngayulu nyuntula rawa puḻkaṟa waṟkarinytjitjaku. Utiṉin wantir'iyanma.” ");
INSERT INTO pjt_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Ka Laipantu palula wangkangu, “Wiya, kulila! Ngayulu ninti panya Mayatja Godalu nyuntulanguṟu ngayunya puḻkaṟa pukuḻmanu, munuṉi kutjupa kutjupa tjuṯa mulapa ungu. Ka nyuntu ngayuku pukuḻarirampa uti wantira nyinama. ");
INSERT INTO pjt_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Palu nyuntu wanyu yaaltjiṯu ungkunytjaku mukuringanyi? Wangkaṉi, kaṉanta nyuntu wangkanytjanyaṯu payamilalku.” ");
INSERT INTO pjt_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Ka Jacobalu alatji wangkangu, “Uwa, nyuntu ninti panya ngayulu nyuntula rawa wiṟuṟa waṟkaringi, ka nyuntumpa tjiipi nanikuta tjuṯa winkiringu ngayulu kanyinnyangka. ");
INSERT INTO pjt_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Panya ngaṉmanytjun nyuntu maṉkurpa kanyiningi ngayulu pitjanytja kuwaripangka, ka kuwari tjuṯa mulararingulta. Kanku Godalu ngayulu nyuntula waṟkarinyangka nyuntumpa uwankara puḻkaṉu. Palu ngayulu nyanganguṟu walytjangku ngayuku palyantjikitja mukuringanyi.” ");
INSERT INTO pjt_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","32","Ka Laipantu tjapinu, “Nyaaṉanta ungkuku?” Ka Jacobalu wangkangu, “Wiya, palya wanti, kaṉa nyinara nyuntumpa tjiipi, nanikuta tjuṯa rawangkuṯu aṯunymanama. Palu kutjukuṉa mukuringanyi. Wanyuṉi wangkara palyanmara, kaṉa ankula nyuntumpa kuka tjuṯanguṟu tjiipi maṟu tjuṯa munu nanikuta nyintaṉ-nyintaṉpa tjuṯa kuḻu ngurkantaṟa mauṉṯalpa tjungunma ngayukurinytjaku. Nyuntu alatjingantjaku kutjuṉa mukuringanyi, kaṉa palulanguṟu nyuntumpa tjiipi nanikuta tjuṯa rawangkulta kanyinma. Palya? ");
INSERT INTO pjt_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ka ngula nyuntu ngayuku tjiipi nanikuta tjuṯa pitjala nyawa, munun tjiipi piṟanpa, nanikuta maṟu tjuṯa nyakulampa ngayunya ngukaṟa kulila, ‘Ai! Nyangangku ngayuku tjiipi nanikuta tjuṯanguṟu kutitjuṟa katingu.’ Palu nyuntu tjiipi maṟu, nanikuta nyintaṉ-nyintaṉpa tjuṯa kutju nyakulampa ngayunya alatji kulinma, ‘Munta, nyanganpa palumpa kuka tjuṯa ngayuku wiya.’” ");
INSERT INTO pjt_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Ka Laipantu kuliṟa wangkangu, “Uwa palya, nyanga alatjiṉa palyalku nyuntu wangkanyangka.” ");
INSERT INTO pjt_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","36","Munu tjiṟirpi pala palula Laipantu ankula palumpa kuka tjuṯanguṟu ngurkantaṟa tjaraṟa mauṉṯalpa tjunangi. Paluṟu nanikuta nyiṯayira tjuṯanguṟu ngurkantaṟa tjunangi nyintaṉ-nyintaṉpa tjuṯa munu walka manguṟi-manguṟitjara tjuṯa kuḻu. Munu paluṟu nanikuta kungka tjuṯanguṟu kuḻu ngurkantaṟa tjunangi walka manguṟi-manguṟitjara tjuṯa piṟantjara tjuṯa kuḻu. Munu tjiipi tjuṯanguṟu kuḻu ngurkantaṟa tjunangi tjiipi maṟu tjuṯa. Munu uwankara tjaraṟa mauṉṯalpa tjunkula paluṟu katja tjuṯa wangkangu tjiipi nanikuta palunya tjananya tjiṉṯu maṉkurpa ma-katira mauṉṯalpa kanyintjaku. Ka Jacobanya ankunytja wiya nyinangi munu Laipanku kuka tjuṯa kanyiningi. ");
INSERT INTO pjt_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Munu palulanguṟu Jacobalu puṉu miṉa kaṯantaṟa miṟi kutju kutju mantjiningi ka kutjupa nguṟurpa miṟi winki ngaṟangi. Ka miṟi wiya piṟanpa ngaṟangi, ka palu puṟunypaṯu miṟitjara maṟu ngaṟangi. Ka puṉu paluṟu walka piṟanpa maṟu, piṟanpa maṟulta ngaṟangi. Munu paluṟu puṉu miṉa tjuṯa kaṯantaṟa palu puṟunypa uwankara palyaningi. ");
INSERT INTO pjt_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Munu katira mantangka muṟutjuṟa waṉaṉu kapingka itingka panya kuka tjuṯangku pitjala tjikilpaingka itingka. Alatji paluṟu tjunu tjikintjikitjangku pitjala nyakunytjaku kuka tjuṯangku. Panya tjakangka tjiipi nanikuta tjuṯa pitjala minangka itingka tjunguringkula kutjara kutjara inkapai tjitjikitja. ");
INSERT INTO pjt_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","40","Ka palulanguṟu puṉu panya walka piṟanpa maṟutjara nyakula tjitji nyara palu puṟunypaṯu walkatjara walkatjara tjunangi kuka ngunytju tjuṯangku. Ka Jacobalu kuka nyangannguṟu lamalama nyintaṉ-nyintaṉpa walka waṟatjara tjuṯa tjaraṟa mauṉṯalpa tjunangi palumparinytjaku. Palu panya kuka kutjupatjara paluṟu nyara kuka kutjupa tjuṯakutu ma-nyakunytjaku ngunti ma-ngaṟatjuṟa wantingu, panya Laipanku nanikuta walka waṟatjarakutu tjiipi maṟutjarakutu. Kaya kuka paluṟu tjana nguntingku ma-ngaṟala inkara tjitji nanikuta walka waṟatjara nyintaṉ-nyintaṉpa kuḻu tjunangi, munu tjitji tjiipi maṟu tjunangiṯu. Nyanga alatji Jacobalu paluṟunku kuka tjuṯa palyaṟa puḻkaningi, munu tjaraṟa mauṉṯalpa kanyiningi palumparinytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Palu kuka panya kaṉpi puḻka tjuṯa tjunguringkula inkanyangka kutju Jacobalu puṉu panya walka piṟanpa maṟutjara tjuṯa tjanala miṟangka muṟutjunangi minangka itingka, kaya nanikuta tjuṯangku kitikiti walka waṟatjara nyintaṉ-nyintaṉpa tjuṯa tjunangi, kaya tjiipi tjuṯangku lamalama maṟu tjuṯa tjunangi, uwankara Jacobakuringkunytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Palu kuka panya nyurka-nyurka tjuṯa tjunguringkula inkanyangka paluṟu puṉu panya tjuṯa muṟutjunkunytja wiyangku wantingi, kaya lamalama kitikiti walka wiyatjara tjuṯa tjunangi Laipanku. Alatji Jacobalu palyaningi palumpa kuka kaṉpi puḻka tjuṯa kutju, ka Laipanku nyurka-nyurka tjuṯa kutju. ");
INSERT INTO pjt_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Ka panya Jacobaku tjiipi nanikuta winki mulararingu, ka paluṟu panya aṉangu waṟkaripai tjuṯa kuḻu mantjinu munu kamula tjuṯa, tangkiyi tjuṯa kuḻu paluṟu mantjiṟa kanyiningi winki mulapa. ");
INSERT INTO pjt_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Kaya palulanguṟu Laipanku katja tjuṯangku Jacobanya kampangkaṯu wangkangi alatji, “Ai! Jacobanya kuka tjuṯatjararingu nganampa mamanguṟu. Paluṟu uwankara katingu nganampa mamaku kuka tjuṯa.” Ka Jacobalu kulinu tjana kampangkaṯu wangkanyangka. ");
INSERT INTO pjt_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Ka Laipannga kuḻu Jacobaku kuraringangi nguwanpa. Ka Jacobalu kuliningi, “Ai! Nyangatja ngayuku maḻpa panya ma-wiyaringanyi. Ngali panya ngaṉmanypa mukulya nyinangi Kulypalnga ngali.” ");
INSERT INTO pjt_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Ka Mayatja Godalu wangkangu Jacobala, “Maḻaku ara nyuntumpa mamaku ngurakutu nyuntumpa walytja tjuṯakutu kuḻu, kaṉanta ngayulu nyuntunya katiṟinkuku.” ");
INSERT INTO pjt_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Ka Jacobalu wati kutjupa iyaṉu Raitjilnga pulanya Liyanya aḻṯira ngalya-katira nguṟurpa lurtjuringkunytjaku ngura nyara paluṟu kuka kanyintjala. ");
INSERT INTO pjt_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Munu pulala pitjanyangka wangkangu, “Ai! Nyuntumpa mama ngayuku maḻpa wiyaringu panya ngaṉmanypali mukulya nyinangi. Palu Godanya ngayula tjungu tiṯutjara nyinangi, god panya Mamalu Tjamulu tjana waḻkuntjanya. ");
INSERT INTO pjt_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ka nyupali kutjaraṯu ninti panya ngayulu nyuntumpa mamaku puḻkaṟa mulapa waṟkaringi rawa mulapa. ");
INSERT INTO pjt_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Palu paluṟu ngayunya ngunti kuraningi munutju paluṟuṯu kalkuntjatjanungku rawangku kampa kutjupanangi. Palu Godalu ngayunya anga-kanyiningi kurantjaku-tawara. ");
INSERT INTO pjt_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Panya wati panya paluṟu ngayunya kalkuṉu kuka walka nyintaṉ-nyintaṉtjara tjunkunyangka ungkunytjikitjangku, ka palulanguṟu kuka tjuṯangku tjunangi walka nyanga palu puṟunypa kutju. Kaṉi piṟuku kampa kutjupaṟa wangkangu walka waṟatjara tjuṯa kutju ungkunytjikitjangku. Ka palulanguṟu kuka tjuṯangku tjunangi walka waṟatjara tjuṯa kutju nyintaṉ-nyintaṉtjara wiyangku. ");
INSERT INTO pjt_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Ka nyanga alatji Godalu nyuntumpa mamaku kuka tjuṯanguṟu mantjiṟa ungangi ngayunya. Ka ngayuku tjuṯaringu, ka nyuntumpa mamaku ma-maṉkuraringu. ");
INSERT INTO pjt_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Panya mungaṯuṉa tjukurtjunangi nanikuta kuḻunypa tjuṯa tjunkunytja aṟangka, munuṉa tjukurpa nyangu nanikuta nyiṯayira nyintaṉ-nyintaṉpa munu walka waṟatjara paluṟu tjana kutju inkara tjitji walka palu puṟunypa tjuṯa utinnyangka. ");
INSERT INTO pjt_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Ka ngayulu tjukurmankunyangka angeltu Godalanguṟu ngayunya ini wangkara wangkangu, ‘Jacob!’ “Kaṉa wangkangu, ‘Uwa nyangatjaṉa.’ ");
INSERT INTO pjt_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","“Ka wangkangu, ‘Nyawa! Nyanga nanikuta nyiṯayira nyintaṉ-nyintaṉpa walka waṟatjara tjuṯangku kutju inkara tjitji walka palu puṟunypa tjuṯa utini. Palu ngayuluṉa nyanga alatjirinytjaku palyaṉi nyuntunya ngunti kalkunnyangka Laipantu. ");
INSERT INTO pjt_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ngayulu panya God nyuntumpa, ngura panya Pitjulta utiringkunytjanya. Panya nyara palulan nyuntu puḻi muṟutjunkula uwilangka kurpiṟa miḻmiḻmanu, munu panyaṉin kalkuṉu. Ka kuwari nyanga nyuntu ngura nyangatja wantikati munu maḻaku ara ngura panya nyuntu iṯi ngarinytjitjakutu.’ Nyanga alatjiṉi tjukurmankunyangka angeltu tjakultjunangi.” ");
INSERT INTO pjt_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Ka Raitjiltu pula Liyalu nyanga palunya kuliṟa wangkangu Jacobala, “Nyangatja ngalimpa wiyaringu mama ilunyangka ngula ngali mantjintjaku. ");
INSERT INTO pjt_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Mamangku ngalinya wiṟuṟa kanyintja wiya kutjupitja puṟunypa wantinyi. Munu nyangalinya nyuntunya ungu panya nyuntu palumpa waṟkarinytjaku. Kan palulanguṟu waṟkarira palumpa puḻkaningi mamaku, ka panya nyuntu waṟkarira palumpa puḻkantja paluṟu ma-ungkula wiyaṉu. ");
INSERT INTO pjt_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Ka panya uwankara Godalu mamanguṟu mantjiṟa nyuntunya ungkunytja nyaratja ngalimpa, munu ngalimpa tjitji tjuṯaku kuḻu. Ka nyuntu nyanganguṟu Godalu wangkanyangka wangaṉarangku kulinma ankunytjikitjangku ngura walytjakutu.” ");
INSERT INTO pjt_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Ka palulanguṟu Jacobanya pirtji-pirtjingu palumpa mama Isaacalakutu maḻaku ankunytjikitja ngura nyara Kainantakutu ngura walytjakutu. Munu kamulangka palumpa kuri tjuṯa, tjitji tjuṯa kuḻu tjunkula ma-pakaṉu munu kuka nanikuta, tjiipi tjuṯa ma-pakaltjingaṟa ma-uṉṯu-uṉṯuṟa waṉaningi. Munu paluṟu uwankara katingu paluṟu ngura pala Mitjupu-taimiyala nyinara mantjintjatjanungku ulytja tjuṯa, kuka tjuṯa, tangkiyi, kamula tjuṯa, aṉangu waṟkaripai tjuṯa kuḻu. ");
INSERT INTO pjt_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","20","Palu paluṟu palumpa waputju Laipannga wangkanytja wiya anu, panya Laipannga ngaṉmanypa anu palumpa tjiipi tjuṯa tjiiṟamilantjikitja ngura kutjupakutu. Ka Raitjiltu palumpa mama ankunyangka maḻantaṟa ngurangka tjarpara palumpa mamaku god puṉunguṟu palyantja tjuṯa kutitjuṟa katingu. Palu Jacobanya watarkitja nyakuwiya paluṟu mantjinnyangka. ");
INSERT INTO pjt_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Munuya paluṟu tjana uwankara ulytja tjuṯa mantji-mantjiṟa warpungkula ma-pakaṉu munuya karu uṟutjara ini Yupuṟaitila ma-itipirira ma-pitjangi puḻi murpu tjuṯatjarakutu ngura ini Kiliyatalakutu. ");
INSERT INTO pjt_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Ka tjiṉṯu maṉkurpa wiyaringkunyangka aṉangu kutjupangku Laipanta wirkaṟa wangkangu Jacobanya nguḻu-nguḻu ankunytja. ");
INSERT INTO pjt_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Ka Laipantu nyangatja kuliṟa wati palumpa walytja tjuṯa aḻṯira kutju-kutjungkaṟa tjunguringkula ma-waṉaṉu. Munuya waṉaṟa waṉaṟa tjiṉṯu 7-arira wirkaṟa nyangu tjananya ngura puḻi murpu tjuṯatjarangka ini Kiliyatala nyinanyangka. ");
INSERT INTO pjt_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","25","Panya Jacobalu tjana puḻi murpu katu ngura tjunkula nyinangi. Ka Laipantu palumpa walytja tjuṯatjarangku palu puṟunypaṯu puḻi murpu kutjupangka ngura tjunu. Ka munga pala palula Laipantu ngarira tjukurmanu Godalu palula wangkanyangka alatji, “Jacobala nyuntu wangkanytja wiyangku wantima. Palunya pauntjingaṟa kuranmankuwiyangku wantima, munu kalypa-kalypantja wiyangku kuḻu wantima.” Alatji Godalu palula wangkangi ngarira tjukurmankunyangka. ");
INSERT INTO pjt_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Ka mungawinkilta Laipantu ankula Jacobanya wangkangu, “Ai, nyaaringun? Nyaakuṉin panyatja ngunti kuraṉu, munutjun ngayuku uṉṯalpa kutjara warmaḻa puṟunytju katingu? ");
INSERT INTO pjt_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Nyaakuṉin wangkanytja wiyangku wantikatira kampangkaṯu kumpiṟa anu? Utiṉin tjakultjunama nyuntu ankunytjikitjangku, kaṉa nyuntunya pukuḻmaṟa inma inkara iyanma. ");
INSERT INTO pjt_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Palu nyuntun warpungkula anu, ka ngayulu kami tjamu tjuṯa uṉṯalpa kutjara kuḻu nyunytjuṟa wangkara iyantja wiyaṯu. Alatji kura nguwanpa, utin nyuntu alatjingantja wiyangku wantima. ");
INSERT INTO pjt_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Palu tjinguṟuṉanta ngayulu pungama nyuntunya wati tjuṯatjarangku, palu mungangkaṉi nyuntumpa mamaku Godalu anga-wangkangu nyuntunya wangkanytja wiyangku wantinytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Uwa, ngayulu kuliningi nyuntu watjilarira ankunyangka nyuntumpa mamaku ngurakutu, palu nyaakun ngayuku panya god tjuṯa kutitjuṟa katingu?” ");
INSERT INTO pjt_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Ka Jacobalu wangkangu, “Wiya, ngayuluṉa nguḻuringkula kulinu nyuntu ngayulanguṟu nyuntumpa uṉṯalpa kutjara mantjintjaku-tawara. Palulanguṟuṉa kampangkaṯu anu wangkanytja wiya. ");
INSERT INTO pjt_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Palu nguriṟanku nyawa nyanga ngayuku aṉangu tjuṯangka. Tjinguṟu kutjupangku mantjinu nyuntumpa god puṉunguṟu palyantja tjuṯa. Ka nyuntu nguriṟa mantjinnyangkampa ngayulu aṉangu nyara kutitjuṟa katinytjanya nyakuku munuṉa palunya pungkula iluntankuku. Nganaṉa nyanganyi, nyuntumpa wati tjuṯangku kuḻu nyanganyi. Ka nyanga nganaṉala miṟangka nyuntu para-nguriṟa nyawa munu nyuntunku nyakulampa mantjiṟa kati.” Alatji Jacobalu rapangku alatjiṯu wangkangu, panya paluṟu nyakunytja wiya Raitjiltu palumpa mamaku god tjuṯa kutitjunkunyangka. ");
INSERT INTO pjt_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Ka Laipantu Jacobaku tiintangka-waraṟa tjarpara puṯu nyangu, munu palulanguṟu Liyaku tiintangka tjarpara piṟuku puṯu nyangu, munu palulanguṟu Liyaku pulampa Raitjilku minyma waṟkaripai kutjaraku tiintangka tjarpara puṯuṯu nyangu. Munu palulanguṟu Raitjilku tiintangkalta tjarpangu. ");
INSERT INTO pjt_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Palu Raitjiltu panya god nyara palunya tjananya kutitjuṟa kamulaku tjatalangka unngu yakutjangka tjunu ngaṉmanytjulpi. Munu paluṟu kuwari nyanga tjatala palula katu tatiṟa puuntaṟa nyinangi tiinta unngu. Ka palumpa mamangku tiinta unngu puṯu para-nyangu. ");
INSERT INTO pjt_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Ka alatji Raitjiltu wangkangu palula tjaalymaṟa, “Mama! Nyuntu ngayuku mirpaṉ-mirpaṉarira wangkanytja wiyangku wantima, panya minymaku tjaka ngaṟanyi, kaṉa palunyatjara pakantja wiya nyinanyi. Palya?” Ka panya puṯu mulapa ngurinu wati panya Laipantu. ");
INSERT INTO pjt_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Ka palulanguṟu Jacobanya puḻkaṟa mirpaṉaringu Laipanku munu palula wangkangu, “Nyaaṉanku katingu? Kura yaaltji-yaaltjiṉa nyuntumpa palyaṉu kaṉin mirpaṉarira waṯaparaṉu ngayunya? ");
INSERT INTO pjt_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Nyuntu wanyu tiinta ngayukungka tjarpara kutjupa kutjupa nyuntumpa nyangu? Wiya alatjiṯu. Nyuntu puṯu mantjiṟa uṟilta tjunanyi nyuntu nganaṉa uwankarangku uti nyakunytjaku, panya wiya alatjiṯu ngaṟanyi. Ala! Nyuntu nganaṉanya kura puṯu alatjiṯu ngurkantananyi. ");
INSERT INTO pjt_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Palu ngayulu rawa mulapa nyuntula nyinara waṟkaringi 20 yiya. Ka tjiipi, nanikuta nyuntumpa tjuṯangku rawangku tjunangi kuḻunypa tjuṯa, kaṉa kuka rama nyuntumpa kuka tjuṯanguṟu pungkula ngalkuwiyangku wantingi. ");
INSERT INTO pjt_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ka panya kuka inuṟangku tjiipi patjannyangka ngayulu nyuntulakutu katira miṟi nintilwiyangku wantingu nyuntu nyakula papangku patjantja kulintjaku ngayunya ngunti ngukantjaku-tawara. Palu ngayulu ankula tjiipi kutjupa mantjiningi ngayuku maningka munuṉa katira tjunangi tjiipi panya palula aṟangka. Panya ngayunyaṉin wangkangu mungangka kaḻaḻa kuḻu tjiipi nanikuta kutitjunkunyangka ngayulu payamilaṟa tjunkunytjaku panya palumpa aṟangka, tjiipiṯu munu nanikuta kuḻu. ");
INSERT INTO pjt_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Panya tjuṯa-aṟaṉa ngayulu nyuntumpa waṟkaringi kuḻi puḻkangka munu munga wari puḻkangka kuḻu munuṉa puṯu kunkunaripai. ");
INSERT INTO pjt_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","“Panya alatji rawa ngayulu nyuntumpa waṟkaringi kuḻingka waringka yiya panya 20. Ngayulu nyuntumpa uṉṯalpa kutjarakitja waṟkaringi yiya panya 14, yiya 7 Liyanyakitja, yiya 7 Raitjilngakitja. Munuṉa palulanguṟu piṟuku yiya nampa 6 waṟkaringi nyuntumpa tjiipi nanikuta tjuṯanguṟu ngayulu mantjintjikitja. Ka panyan nyuntuṯu kalkuntjatjanungku rawangku kampa kutjupanangi. ");
INSERT INTO pjt_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Palu Godanya ngayula tjungu ngaṟangi God panya ngayuku tjamuku munu mamaku, Aipuṟamaku pulampa Isaacaku. Tjinguṟu Godanya ngayula ngaṟanytja wiyangkampaṉin ngura iriti maṟalpa iyanma. Palu Godaluṉi nyangangi ngayulu puḻkaṟa nyuntula waṟkarinyangka pakuringkunytja wiya, munu palulanguṟu nyuntunya mungangka painu ngayunya wangkanytja wiyangku wantinytjaku.” Alatji Jacobalu palumpa kulypalta wangkangu wati panya Laipanta. ");
INSERT INTO pjt_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Ka Laipantu Jacobala wangkangu, “Minyma nyanga kutjara ngayuku uṉṯalpa, ka palumpa pulampa tjitji tjuṯa ngayuku pakaḻi tjuṯa. Ka nyanga tjiipi nanikuta tjuṯa nyuntu katinytja kuḻu ngayuku. Ala! Nyanga uwankara nyuntu para-nyakula nyanganyi ngayuku uwankara. Kaṉa ngayuku uṉṯalpa kutjara kanyintjikitja mukuringanyi, ngayuku pakaḻipiti kuḻu, palu Godalu panya ngayunya painu nyuranya markuntja wiyangku wantinytjaku. Kaṉa yaaltjiriku? Puṯuṉa kulini. ");
INSERT INTO pjt_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Palu wanyuli nyinakatira piṟuku wangkara kalkula, munuli ngura nyanga palula pitjilpa palyala kalkuṟa rawangku kulintjikitjangku.” ");
INSERT INTO pjt_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Ka Jacobalu palya kulinu ngaparku kalkuntjikitjangku munu apu kutju mantjiṟa muṟutjunu kalkuntja rawangku kulintjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Munu palumpa walytja tjuṯangka wangkangu apu kutjupa tjuṯa mantjiṟa pitjilpa tjunkunytjaku. Ka pitjilpa tjunkula wiyannyangka Jacobalu pula Laipantu pala palula itingka nyinakatira mai kuka ngalkula wangkara kalkuningi. ");
INSERT INTO pjt_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Ka pitjilpa panya palunya Laipantu wangka palumpangku ininu nyanga alatji, “Tjika Tjaatutjanya”. Palu Jacobalu ini tjunu palumpa wangkangku nyanga alatji, “Kalitanya”. ");
INSERT INTO pjt_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Ka Laipantu Jacobala wangkangu, “Pitjilpa nyanga paluṟu ngaṟanyi ngali nyakula watarkurinytjaku-tawara ngalinku panya kalkuntja.” Ka pala palulanguṟu Jacobalu ngura palunya ininu “Kalitanya”. ");
INSERT INTO pjt_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Munu Laipantu wangkangu, “Kaṉa Mayatja Godala tjapini ngalinya aṯunymaṟa kanyintjaku ngura nyanganguṟu tjararingkula paṯupaṯu nyinanyangka.” Kaya palulanguṟulta ini kutjupa tjunu “Mitjapanya”. ");
INSERT INTO pjt_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Munu Laipantu Jacobala wangkangu nyanga alatji, “Tjinguṟu nyuntu ngayuku uṉṯalpa pungkuku, munta tjinguṟun minyma kutjupa aḻṯiku, kaṉa paṯu nyinara kulintja wiya nyinaku. Palu kulinma panya Godalulinya nyanganyi. Palulanguṟu alatjiriwiyangku wantima munu ngayuku uṉṯalpa kutjara wiṟuṟa kanyinma. ");
INSERT INTO pjt_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Nyanganpa nyawa, nyanga pitjilpa tjunkunytja munu apu panya muṟutjunkunytja. ");
INSERT INTO pjt_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Nyanga paluṟu pula ngaṟanyi ngalinku nyakula kulintjaku. Ka nyanga palulanguṟu nyuntu apu nyanga kutjarangka ngalya-waintarira ngayunya pikangku waṯaparantja wiyangku wantima, ka ngayulu palu puṟunypaṯu ma-waintarira nyuntunya pikangku waṯaparantja wiyangkuṯu wantiku. Palya? ");
INSERT INTO pjt_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ka Godalu ngalinya kalkunnyangka nyanganyi, God panya ngalimpa tjamu Aipuṟamaku munu ngayuku mama Nayuku kuḻu, munu paluṟu kalkuntja panya palunya wiyantjaku-tawara ngalinya nyanganyiṯu kalkuntjatjanungku wangaṉarangku kuliṟa palyantjaku.” Alatji Laipantu Jacobala wangkara kalkuṉu. Ka Jacobalu palu puṟunypaṯu wangkara Laipannga ngapartji kalkuṉu mulamulangku Mayatja Godala miṟangka, panya palumpa mama Isaacalu God panya palunya waḻkulpai Mayatja witulya puḻkanya. ");
INSERT INTO pjt_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Munu palulanguṟu Jacobalu kuka mantjiṟa pungu munu puḻi murpu pala palula waṟungka tiliwakaṟa Godanya ungu palunya waḻkuntjikitjangku, munu palulanguṟu palumpa walytja tjuṯa aḻṯingu palula tjunguringkula ngalkuntjaku mai kuka. Munuya ngalkula wiyaringkula munga kutju ngaringu puḻi pala palula katu. ");
INSERT INTO pjt_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Ka mungawinki mulapa Laipantu pakaṟa palumpa puḻiri, pakaḻi tjuṯa, uṉṯalpa kutjara kuḻu nyunytjuṟa wangkara wantikatira ma-pakaṉu maḻaku palumpa ngurakutu. ");
INSERT INTO pjt_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Ka Jacobanya kuḻu ma-pakaṉu munu ankula ankula ma-paṯuringu, ka angelpa maṉkurpa Godalanguṟu palula utiringu. ");
INSERT INTO pjt_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Ka nyakula wangkangu, “Nyangatja Godaku ngura!” Munu paluṟu ininu “Maanaimanya” ngura pala palunya. ");
INSERT INTO pjt_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Ka Jacobalu wati maṉkurpa iyaṉu tjakulpa ngura Tjiirtakutu palumpa kuṯangka wangkanytjaku Iitjula. (Ngura nyara paluṟu panya ini kutjupa Iitamanya) ");
INSERT INTO pjt_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Alatji paluṟu tjanala wangkangu palumpa kuṯangka ankula tjakultjunkunytjaku, “Ngayulu Jacobanya panya nyuntumpa maḻanypa munuṉa nyuntula kuṯa wiṟungka ma-tjakultjunanyi panya ngayuluṉa ngura parari ngalimpa kulypalta Laipanta rawa nyinangi munuṉa kuwari kutju nyanga aṟuringu ngurakutu. ");
INSERT INTO pjt_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Munuṉatju kuka puluka, tjiipi, nanikuta tjuṯa, tangkiyi tjuṯa kuḻu katinyi, ka aṉangu ngayuku waṟkaripai tjuṯa kuḻu ngayula tjungu pitjanyi. Kaṉi kuṯa wanyu kulila! Ngayuluṉa nyanga tjananya nyuntulakutu tjakulpa ma-iyaṉi nyuntu kuliṟa ngayuku kalyparingkula pukuḻpa paṯantjaku.” Alatji Jacobalu wangkara iyaṉu Iitjulakutu wati panya waṟka maṉkurpa, kaya mulapaṯu ankula tjakultjunu Iitjula. ");
INSERT INTO pjt_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Munuya maḻaku aṟuringkula Jacobala wirkaṟa wangkangu nyanga alatji, “Nganaṉa ankula tjakultjunu nyuntumpa kuṯangka, ka paluṟu kuwari wati tjuṯatjara pitjanyi, 400-tjara.” ");
INSERT INTO pjt_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Ka Jacobanya nyangatja kuliṟa puḻkaṟa nguḻuringu. Munu paluṟu palumpa aṉangu tjuṯa tjaraṟa uṯuḻu kutjara palyaṉu munu kuka tjiipi, nanikuta, puluka, tangkiyi, kamula tjuṯa kuḻu palu puṟunypaṯu tjaraṟa uṯuḻu kutjara palyaṉu. ");
INSERT INTO pjt_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Panya paluṟu alatji kuliningi, “Tjinguṟu Iitjulu tjana pitjala uṯuḻu nyanga kutju pikangku pungkuku, ka uṯuḻu nyanga kutjupa tjuṯa kumpiṟa wirtjapakalku.” Alatji Jacobalu kulinu munu tjaraṟa uṯuḻu kutjaraṉu. ");
INSERT INTO pjt_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Munu palulanguṟu Jacobalu Godala tjapinu, “God, ngayuku tjamu Aipuṟamalu nyuntunya waḻkulpai ngayuku mama Isaacalu kuḻu, kaṉi wanyu kulinma! Nyuntu panya ngayunya wituṟa iyaṉu ngura walytjakutu maḻaku ankunytjaku ngayuku walytja tjuṯakutu, munu panyaṉin ngayunya wangkangu aṯunymankunytjikitjangku ngayulu palya pukuḻpa mulapa nyinanytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Palu nyaakuṉin rawangku munytjangku unganyi munuṉin wiṟuṟa katiṟinanyi, panya ngayulu kurakura mantatja alatjiṯu. Panya ngayulu iriti puṉu tjukaratjara kutju karu uṟu Jordanta itipiringu Aaṟantakutu ankunytjikitja maṟalpa alatjiṯu, munuṉa kuwari nyanga tjuṯa mulartjara maḻaku pitjangu nyanga uṯuḻu kutjaratjara. ");
INSERT INTO pjt_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Wanyuṉi aṯunymaṟa kanyinma ngayuku kuṯa Iitjula-tawara. Panya ngayulu nguḻuringanyi Iitjululanya pitjala pungkula wililytjingantjaku-tawara tjitji minyma kuḻu. ");
INSERT INTO pjt_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Panyatja kulinma, panya iriti nyuntu kalkuṉu ngayunya aṯunymaṟa tjukaṟurungku kanyintjikitjangku, munu panyaṉin kalkuṉu ngayuku walytja ma-tjuṯaringkunytjaku maḻatja maḻatja, kaya mungilyi mulapa nyinaku panya paki kuḻuny-kuḻunypa uṟu kantilytja ngarira waṉinytja puṟunypa, puṯu kantamilantjaku.” Alatji Jacobalu Godala tjapinu palunya tjananya aṯunymankunytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Munu nyara palula ngarira tjiṉṯuringkula Jacobalu kuliningi palumpa kuka tjuṯanguṟu tjaraṟa Iitjunya ungkunytjikitjangku paluṟu mantjiṟa pukuḻarinytjaku. Munu paluṟu ngurkantaṟa tjaraṟa mauṉṯalpa tjunu alatji, ");
INSERT INTO pjt_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","nanikuta ngunytju 200, nanikuta mama 20, munu palu puṟunypa tjiipi ngunytju 200, tjiipi mama 20. ");
INSERT INTO pjt_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Munu kamula ipitjara 30 palumpa tjanampa kuḻunypa tjuṯa kuḻu. Munu puluka ngunytju 40, munu puula 10. Munu tangkiyi ngunytju 20, tangkiyi mama 10. ");
INSERT INTO pjt_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Munu paluṟu kuka nyanga tjananya piṟuku tjaraṟa uṯuḻu tjuṯa palyaṉu, munu palulanguṟu wati waṟkaripai tjuṯa kutju kutju tjunu uṯuḻu kutju kutjungka katiṟinkunytjaku munu tjananya wangkangu, “Ngayula kuranyuya anama wanapari wanapari, palu kapuṯu kutjuṯu ankunytja wiya nguṟurpa aḻa kutjupa aḻa kutjupa wantima.” ");
INSERT INTO pjt_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Munu wangkangu Jacobalu wati kuranyu ankunytjala nyanga alatji, “Ngayuku kuṯa Iitjulu nyuntunya nyakula tjapilku alatji, ‘Ngananyanku mayatja? Yaaltjikutun ananyi? Nganaku kuka tjuṯa nyangatja nyanga nyuntula kuranyu ananyi?’ Alatji paluṟu nyuntula tjapilku. ");
INSERT INTO pjt_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Ka nyuntu tjapinnyangka palula alatji wangka, ‘Wiya, nyanganpa nyuntumpa maḻanypangku Jacobalu iyaṉu nyuntunya ungkunytjaku. Panya paluṟu maḻawanu pitjanyi.’ Alatji palunya nyakula wangka. Palya?” ");
INSERT INTO pjt_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Munu paluṟu wangka palu puṟunypaṯu wati nguṟuritja nguṟuritjangka wangkangi tjana kuka uṯuḻu kutju kutju katira Iitjunya nyakula wangkanytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Munu paluṟu tjanala wangkangu, “Munuya watarkurinytja wiyangku palula wangka panya ngayulu maḻawanu pitjanytja. Palya?” Alatji paluṟu tjananya wangkara iyaṉu, panya paluṟu kuliningi, “Kuwari ngayuku kuṯangku kuka nyanga tjuṯa ungkunyangka tjinguṟu ngayuku kalyparingkuku, munuṉi kuwari nyakula ngayuku pukuḻariku.” ");
INSERT INTO pjt_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Munu kuka panya palunya tjananya Iitjunya ungkunytjaku kuranyu iyaṟa paluṟu nyinangi ngurangka munga pala palula. ");
INSERT INTO pjt_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Munu Jacobalu munga pala palula pakaṟa kuri kutjara tjitji 11 palumpa mantjiṟa kuri palumpa kutjupa kutjara kuḻu mantjiṟa katingu karu uṟu ini Tjapakalakutu, munu tjananya ma-itipirinytjaku wangkara iyaṉu. ");
INSERT INTO pjt_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Munu tjananya ma-iyaṟa piṟuku palumpa kutjupa kutjupa uwankara kuḻu ma-iyaṉu palumpa waṟkaripai tjuṯangka. ");
INSERT INTO pjt_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Munu paluṟu wantira kutju nyinangi maḻaringkula. Ka wati kutju pitjala pulanku lirintaṟa aṉṯa-waṉira para-waṉira para-waṉira munga waṟangka. ");
INSERT INTO pjt_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Ka wati panya kutjutjangku Jacobanya punkatjingantjikitjangku puṯulinangi, munu palulanguṟu palunya angkaḻpa pampuṉu Jacobanya, ka tjunta kutju angkaḻnguṟu tjukutjuku ngalya-pakaṉu. ");
INSERT INTO pjt_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Ka wati panya kutjutjangku wangkangu, “Wantir'iyalaṉi! Nyangatja waṯalpi tjiṉṯuringu.” Ka Jacobalu wangkangu, “Wiya, nyuntu ngayunya pukuḻmankunyangka kutjuṉa nyuntunya wantir'iyalku.” ");
INSERT INTO pjt_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ka palula tjapinu, “Ini ngananyan nyuntu?” Kanku ini wangkangu, “Jacobanyaṉa.” ");
INSERT INTO pjt_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ka wati panya kutjutjangku wangkangu, “Nyuntu kuwari ini ‘Jacobanya’ ngaṟanytja wiyaringkuku, munu nyanganguṟu nyuntu ini ‘Israelnga’ ngaṟaku, panya nyuntu Godala tungunpungkula lirintaṟa aṉṯa-waṉira aṉṯa-waṉira waintaringu, ngayula kutju wiya wati tjuṯangka kuḻu.” ");
INSERT INTO pjt_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Ka Jacobalu tjapinu palula ngapartji, “Palu nyuntu ini ngananya?” Ka palula wangkangu, “Nyaakuṉin iniku tjapiṟa ngurini?” Munu palulanguṟu Jacobanya pukuḻmanu. ");
INSERT INTO pjt_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Ka Jacobalu wangkangu, “Ngayulu mulapa Godanya yunpa ilangku nyangu. Munuṉa ilangku nyakunytjatjanu nyangatja kuwari wankaṯu ngaṟanyi.” Munu palulanguṟu ngura palunya ininu Piniyalnga. ");
INSERT INTO pjt_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Ka tjiṉṯu ngalya-pakannyangka Jacobalu ngura pala Piniyalnga wantikatira ma-pakaṉu, munu paluṟu lurpaṟinangi panya angkaḻpa pikatjara. ");
INSERT INTO pjt_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Kaya nyanga palulanguṟu Israelkunu tjuṯangku kuwari kuka ngalkula pulyku angkaḻitja ngalkuwiyangku wantipai, panya Godalu Jacobanya tjunta pampuntjitjangka. ");
INSERT INTO pjt_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Ka Jacobalu nyangu Iitjunya wati tjuṯatjara pitjanyangka 400-tjara, munu palulanguṟu palumpa kuri tjuṯa tjaraṟa kutju kutju ngaṟatjunu munu palumpa tjitji tjuṯa ngunytjungka ngunytjungka tjunu. ");
INSERT INTO pjt_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Munu palulanguṟu tjunu kuri maḻa aḻṯinytja kutjara palumpa pulampa tjitji kuḻu kuranyu ankunytjaku, munu palulanguṟu Liyanya palumpa tjitji tjuṯa kuḻu nguṟurpa tjunu, munu palulanguṟu maḻa tjunu Raitjilnga palumpa tjitji Josephanya kuḻu. ");
INSERT INTO pjt_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Munu Jacobanya palula tjanala kuranyu anu munu palumpa kuṯangka ilaringkula 7-aṟangku pupakatira manta ngalyangku pampuṉu. Panya alatjingaṟaya waḻkulpai. ");
INSERT INTO pjt_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Palu Iitjulu palulakutu wirtjapakaṟa ampuṟa mitamita kutjara nyunytjuṉu munu pula kutjaraṯu puḻkaṟa ulangi. ");
INSERT INTO pjt_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Ka palulanguṟu Iitjulu para-nyakula nyangu minyma tjuṯa munu tjitji tjuṯa kuḻu, munu palula tjapinu, “Aṉangu ngananya tjana nyanganpa?” Ka Jacobalu wangkangu, “Wiya kuṯa, tjitji nyanga palunya tjananyaṉi Godalu ngayunya wiṟungku ungu.” ");
INSERT INTO pjt_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Ka minyma panya maḻa aḻṯinytja kutjara palumpa pulampa tjitji tjuṯa kuḻu pitjala Iitjula kuranyu pupakatingu. ");
INSERT INTO pjt_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Ka palulanguṟu Liyanya munu palumpa tjitji tjuṯa kuḻu pitjala pupakatingu, ka palula maḻangka Raitjilnga pula Josephanya katjaṟara pitjala pupakatinguṯu. ");
INSERT INTO pjt_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ka Iitjulu Jacobala wangkangu, “Ka kuka panya uṯuḻu kutjupa uṯuḻu kutjupa pitjanytja yaalitja tjuṯa, panya tjananya ngayulu kuwari nyangu?” Ka Jacobalu wangkangu, “Wiya, nyuntu ngayuku kalyparingkunytjakuṉa iyaṉu.” ");
INSERT INTO pjt_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ka Iitjulu wangkangu, “Wiya maḻany, kuka tjuṯaṉa kanyini. Palya, kanyinmanku!” ");
INSERT INTO pjt_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Ka Jacobalu wangkangu, “Wiya, nyuntu ngayuku pukuḻarirampa wanyu mantjila nyanga ngayulu ungkunytja. Panya nyuntu kuwari ngayunya kalypangku ampunnyangkaṉa nyuntunya yunpa nyakula puḻkaṟa pukuḻaringu Godanya yunpa nyakunytja puṟunypa. ");
INSERT INTO pjt_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Ka wiṟungku-puṯa mantjila kuka nyanga ngayulu ungkunytja tjuṯa. Panya Godalu ngayunya pukuḻtjungku ungangi tjuṯa mulapa ngayulu mukuringkunytja uwankara.” Munu Jacobalu rawangku mantjintjaku wangkara wituwituningi, ka palulanguṟu Iitjulu kuka panya tjuṯa mantjinu. ");
INSERT INTO pjt_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Munu palulanguṟu Iitjulu wangkangu, “Ala, walawala pakala, kali nyuntu ngali tjungu ara!” ");
INSERT INTO pjt_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Palu Jacobalu wangkangu, “Wiya, kuṯa kulila! Nyuntu ninti panya tjitji tjuṯa mapalku pakuringkupai, kaṉa tjiipi nanikuta ngunytju, puluka ngunytju tjuṯa kuḻu atatjuṟa katinytjikitjangku kulini nyanga kuḻunypa tjuṯatjara. Tjinguṟula nganaṉa tjananya warpungkula kaḻaḻa waṟangka katira katira iluntankuku uwankara. ");
INSERT INTO pjt_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Palu wanyu nyuntu kuranyu anama, kaṉa maḻawanu ngayulu purkaṟa pitjama tjitji nyanga tjuṯatjara munu tjiipi nanikuta tjuṯatjara kuḻu, munuṉanta ngula ngura nyara Iitamala waṉaṟa tjunguringkuku. Palya?” ");
INSERT INTO pjt_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Ka Iitjulu wangkangu, “Uwa palya, kaṉa wanyu wati ngayuku waṟkaripai tjara kutjupa nyuntula wantikatiku?” Ka Jacobalu wangkangu, “Wiya palya ara! Ngayulu pukuḻaringu nyuntu kalyparingkunyangka munuṉanta watiku ngatjintja wiya.” ");
INSERT INTO pjt_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Ka tjiṉṯu nyara palula Iitjunya ma-pakaṉu palumpa ngurakutu Iitamalakutu. ");
INSERT INTO pjt_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Palu Jacobanya anu ngura ini Tjukatjalakutu munu nyara palula yiwaḻa paluṟunku palyaṉu munu tjulypinypa tjuṯa kuḻu palyaṉu kuka tjuṯaku. Kaya nyara palulanguṟu ngura nyara palunya ininu Tjukatjanya panya ini nyanga palunya wangkanyi “wiltja” wangka Iipuṟungku. ");
INSERT INTO pjt_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Uwa, Jacobanya panya wankaṯu aṟuringu ngura Mitjupu-taimiyalanguṟu munu wirkanu tawunu ini Tjikimala manta pala Kainanta. Mununku paluṟu ngura tjunu uṟilta tawunu Tjikimala itingka. ");
INSERT INTO pjt_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Munu paluṟu manta pala palunya payamilaṉu wati Aimurkunu tjuṯangka mani panya tjiilpa puḻka ungkula, nampa 100. Ka Aimurnga panya wati Tjikimaku mama. (Kaya tawunu Tjikimanya ininu wati nyanga palulanguṟu Aimurku katjanguṟu.) ");
INSERT INTO pjt_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Ka Jacobalu manta nyara palula pitjilpa puḻka palyaṉu Godanya waḻkuntjikitjangku, munu ininu “Godanya panya Israelku God”. ");
INSERT INTO pjt_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Ka Jacobaku pulampa Liyaku uṉṯalpa kutju nyinangi ini panya Tiinanya. Munu tjiṉṯu kutjupa kungkawaṟa nyara paluṟu anu waḻikutu minyma Kainannga nguraṟa tjuṯa nyakunytjikitja. ");
INSERT INTO pjt_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","3","Ka ngura pala palumpa wati ini Aimurnga mayatja nyinangi ngura ititja tjuṯaku kuḻu. Ka Aimurku katjangku Tjikimalu nyangu Tiinanya wirkankunyangka, munu palunya witiṟa mauṉṯalpa katira palula kampangkaṯu ngunti ngaringu. Munu palulanguṟu kungkawaṟa palumpa puḻkaṟa kurunpa winki mukuringu munu nyinara purkaṟangku wangkara ngultjuningi palumpa mukuringkula. ");
INSERT INTO pjt_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Munu palulanguṟu palumpa mamangka Aimurta wangkangu, “Mama! Ngayuluṉa kungkawaṟa nyangaku puḻkaṟa mukuringanyi. Wanyu palumpa mamangka tjapila, kaṉa aḻṯira kanyinma.” ");
INSERT INTO pjt_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Ka Jacobalu kulinu palumpa uṉṯalpa kampangkaṯu kurangku pampunnyangka. Palu palumpa katja tjuṯangkuya kuka tjuṯa paṯu kanyiningi, ka palulanguṟu Jacobanya kanmarpa nyinangi palumpa katja tjuṯa pitjanytjaku paṯaṟa. ");
INSERT INTO pjt_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Ka Tjikimaku mama anu Jacobala wangkanytjikitja. ");
INSERT INTO pjt_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Kaya Jacobaku katja tjuṯangku palumpa tjanampa maḻanypa pampuntja kuliṟa mapalku pitjangu kuka panya tjuṯa ma-wantikatira. Panya paluṟu tjana puḻkaṟa tjituṟu-tjituṟurira mirpaṉpa mulararingu, panya Tjikimalu mulapa kura palyaṉu Jacobaku uṉṯalpa. Uti paluṟu pampulwiyangku wantima. ");
INSERT INTO pjt_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Ka Aimurtu wirkaṟa wangkangu Jacobala tjanala, “Ngayuku katja Tjikimanya puḻkaṟa kurunpa winki mukuringanyi nyuntumpa uṉṯalpaku. Wanyu palunya uwa pula kuriṟara nyinanytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Uti nyuranku uṉṯalpa tjuṯa ngayuku katja tjuṯa ngalya-ungkuku kuri aḻṯinytjaku, kala nganaṉa ngapartji nyuranya ma-ungkuku kuri ngapartji aḻṯinytjaku nganampa uṉṯalpiti. ");
INSERT INTO pjt_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Panya nganaṉa mukuringanyi nyura nganaṉala tjunguringkula nyinanytjaku nganampa nyanga mantangka. Ka nyura ngura kutjupaku kutjupaku mukuringkula palya payamilala, munu ngura aḻa lipiwanu para-nyinama ngura kutjupangka kutjupangka. Munu nyura mukuringkula kutjupa kutjupa tjuṯa kuḻu payamilanma munu ngula piṟuku tjalamilanma mukuringkula.” Alatji Aimurtu Jacobala tjanala wangkangi. ");
INSERT INTO pjt_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Ka palulanguṟu palumpa katjangku Tjikimalu ngapartji Jacobala tjanala wangkangu, “Wanyuṉiya wiṟungku ungama kuri aḻṯinytjaku, kaṉa nyuranya ungkuku kutjupa kutjupa uwankara nyura ngayula ngatjinnyangka. ");
INSERT INTO pjt_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Wangkaṉiya, nyaaku nyura mukuringanyi? Nyaaṉa nyuranya ungkuku? Mukuringkulaya puḻka mulapa ungkunytjaku wangka, kaṉa nyuranya puḻkaṯu ungkuku nyura wangkanytjitja. Panya ngayulu kungka pala palunya mulamulangku aḻṯinytjikitjangku wangkanyi.” ");
INSERT INTO pjt_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Palu Jacobaku katja tjuṯa palumpa tjanampa maḻanypa pampuṟa kurantjitjanguṟu Tjikimanya pulanya mamaṟara ngapartji pungkunytjikitja mukuringangi. ");
INSERT INTO pjt_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Munuya alatji pulala wangkangu, “Wiya, nganaṉa puṯu nguwanpa nganampa maḻanypa unganyi tjitjingku aḻṯinytjaku. Nyara palulanguṟu nganaṉa kuṉṯaringkupai tjitjingku aḻṯinyangka. ");
INSERT INTO pjt_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Palu nyuntu nganaṉa puṟunypa watiringkunyangka kutju nganaṉa nyuntunya aḻṯinytjaku ungkuku, nyuntumpa walytjapiti kuḻu nganaṉanya puṟunyarinyangka. ");
INSERT INTO pjt_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Nyara palulanguṟu kutju nganaṉa nyuranya aḻṯinytjaku ungkuku nganampa uṉṯalpiti, munula ngapartji nyurampa uṉṯalpiti mantjilku nganampa katja tjuṯangku kuḻu aḻṯinytjaku. Munula palulanguṟu uriwiyaringkulalta nyurala nyinaku, munula nyuntu nganaṉa aṉangu kutjuringkulalta nyinaku. ");
INSERT INTO pjt_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Palu nyura watiringkunytja wiyangku wantinyangka nganaṉa nganampa maḻanypa mantjiṟa katiku, munula ngura kutjupakutu ankuku.” Alatjiya Tiinaku kuṯa tjuṯangku wangkangi Aimurta pulala Tjikimala. ");
INSERT INTO pjt_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Ka Aimurtu pula nyanga palunya kuliṟa palyanmanu. ");
INSERT INTO pjt_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Munu palulanguṟu wati nyanga Tjikimanya warpungkula tawunukutu anu Jacobakunu tjuṯa puṟunyarinytjikitja panya paluṟu puḻkaṟa mukuringangi Jacobaku uṉṯalpaku. Paluṟu panya kuṯa puḻka nyinangi wati Aimurku katja kuranyitja, kaya tawunu nyara palunya nguraṟa tjuṯangku palunya mayatjanmankupai. ");
INSERT INTO pjt_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Ka Aimurnga pula anu tawunuku kaitangka mitingiku tjunguringkunytjikitja. Kaya wati panya palunya nguraṟa tjuṯa kuḻu pitjala kaitangka tjunguringu mitingi kulintjikitja. ");
INSERT INTO pjt_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Ka Tjikimalu pula wangkangu tjanala, “Nyara Jacobanya tjana wati palya tjuṯa nganampa maḻpa tjuṯa. Wanti tjananya ngura manta nyangangka palya nyinanytjaku munu tjana payamilaṟa tjalamilantjaku kuḻu palya wantima. Panya ngura nyangatja manta parariwanu ngaṟanyi. Ka nganaṉa tjanampa uṉṯalpa aḻṯinyi, ka tjana ngapartji nganampa uṉṯalpa tjuṯa aḻṯinyiṯu. ");
INSERT INTO pjt_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Palu wati nyanga paluṟu tjanaya alatji nganaṉala wangkangu, ‘Nyura nganaṉa puṟunypa watiringkunyangka kutjula nyurala nyinaku aṉangu kutjuringkula.’ ");
INSERT INTO pjt_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ala! Palyanmarala tjananya munula tjananya puṟunyarima. Panya tjana nganaṉala tjungu nyinanyangka palumpa tjanampa kuka nganampariku, munu kutjupa kutjupa tjanampa uwankara nganamparikuṯu.” Alatji Aimurtu pula tjanala wangkangu palumpa pulampa walytjapitingka. ");
INSERT INTO pjt_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Kaya wati ngura pala palunya nguraṟa tjuṯangku nyangatja kuliṟa palyanmanu munuya uwankara Jacobanya tjananya puṟunyaringu panya tjana ngaṉmanypa tjitji tjuṯa nyinangi munuya watiringu. ");
INSERT INTO pjt_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Kaya wati panya Aimurnga Tjikimanya tjana ngura walytjangka walytjangka rawa nguwanpa nyinara pakuwiyaringangi. Ka palulanguṟu tjiṉṯu maṉkurpa ngaṟala wiyaringkunyangka kungkawaṟa panya Tiinaku kuṯa kutjara Tjimiyannga pula Levinya pikakitja pitjangu, tjuḻa waṟa puḻkatjara. Munu pula tawunu panya palula tjarpara wati uwankara pungkula wiyaṉu panya tjana waḻi unngu watarku nyinara pakuwiyaringkunyangka. ");
INSERT INTO pjt_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Munu pula Aimurnga pulanya Tjikimanya kuḻu pungkula iluntanu, munu pula pulampa maḻanypa Tiinanya Tjikimaku waḻinguṟu mantjiṟa katingu ngurakutu tawunu pala palunya wantikatira. ");
INSERT INTO pjt_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Ka panya paluṟu pula pungkula wiyannyangka Jacobaku katja kutjupa tjuṯangku pitjala nyangu wati miri tjuṯa ngarira waṉinyangka, munuya ngura pala palulanguṟu kutjupa kutjupa uwankara mantjiṟa katingu, panya Tjikimalu tjanampa maḻanypa Tiinanya kurantjitjanguṟu mirpaṉarira. ");
INSERT INTO pjt_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","29","Munuya nanikuta, tjiipi, puluka, tangkiyi, kuka uwankara yaata tjanampanguṟu pakaltjingaṟa katingu, munuya tawunu nyara palula waḻi tjuṯangka para-tjarpara kutjupa kutjupa wiṟu tjuṯa uwankara mulapa mantjiningi. Munuya minyma tjuṯa, tjitji tjuṯa kuḻu ngura nyara palunya nguraṟa uwankara mantjiṟa katingu, Jacobaku panya katja tjuṯangku. ");
INSERT INTO pjt_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Ka Jacobalu Tjimiyanta pulala Levila wangkangu, “Nyupali ngayunya kurakutuṉu alatjiṯu. Panya nyanga palulanguṟu Kainankunu tjuṯa munu Piṟitjikunu tjuṯaya kuwari nganampa mirpaṉarinyi, munuya aṉangu kutjupa manta nyanganta nyinanytja tjuṯa kuḻu nganampa kuraringkuku. Munulanyaya tjinguṟu tjaṯuringkula pitjala pungkuku. Kaṉa yaaltjiriku? Panya ngayulu wati tjuṯa kanyintja wiya tjananya pitjanyangka pungkula waintarinytjaku. Kaya palulanguṟu nganaṉanya uwankara pungkula wiyalku.” ");
INSERT INTO pjt_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Kaya wangkangu palumpa katja tjuṯangku, “Wiya, wati nyarangku nganampa maḻanypa kurangku pampuṉu, kala palya pungu, panya puṯula wantingi.” ");
INSERT INTO pjt_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Ka Godalu Jacobanya wangkangu, “Pakaṟa ara ngura nyara Pitjultakutu, munu nyara palula nguraṟarira nyinama. Munu pitjilpa puḻka palyala ngayunya waḻkuntjikitjangku, panya nyara palula ngayulu nyuntula utiringu nyuntu Iitjuku nguḻu kumpiṟa wirtjapakannyangka.” ");
INSERT INTO pjt_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Ka palulanguṟu Jacobalu palumpa walytja uwankarangka wangkangu munu aṉangu palumpa waṟkaripai tjuṯangka kuḻu nyanga alatji, “Waṉiraya wiyala pala god ngalypa-ngalypa tjuṯa nyura panya tjanampa nguranguṟu mantjintjatjanungku. Munuyanku puntu uwankara paltjiṟa mantara kuwaritjangka tjarpa nyura kampa kutjuparira kura panya tjanalanguṟu mantjintjatjanu palyaringkunytjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Palulanguṟulanku ngura nyangatja wantikati munula ara Pitjultakutu. Kaṉa ngura nyara palula Godanya waḻkuntjikitjangku pitjilpa puḻka palyalku, panya God nyara paluṟuṉi ngalkinu ngayula kura wirkankunyangka, munu paluṟu ngayula tjungu tiṯutjara ngaṟangi ngayulu para-pitjalinkunyangka.” ");
INSERT INTO pjt_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Kaya palulanguṟu god panya ngalypa-ngalypa uwankara Jacobanya ungu tjana kanyintjatjanungku, munuya pinangka manguṟi-manguṟi tjuṯa kanyintjatjanungku kuḻu ungangi Jacobanya. Ka paluṟu uwankara tjuṉutjunu puṉu waṯa puḻkangka itingka tawunu pala Tjikimala itingka. ");
INSERT INTO pjt_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Munuya palulanguṟu Jacobanya tjana palumpa aṉangu tjuṯa kuḻu ma-pakaṉu. Kaya tawunu ititja ititjangka aṉangu nyinanytja tjuṯangku tjananya ankunyangka nyakula puḻkaṟa mulapa nguḻuringangi, munuya tjananya pikangku waṉalwiyangku wantingu. Alatjiya nguḻuringkula wantingi panya Godalu tjananya miṟal-miṟalpa puḻkangku katinyangka. ");
INSERT INTO pjt_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Kaya Jacobanya tjana ankula ankula wirkanu ngura panya palula ini Latjala panya ini kutjupa Pitjulnga manta nyara Kainanta. ");
INSERT INTO pjt_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Ka nyara palula Jacobalu pitjilpa puḻka palyaṉu munu ngura nyara palunya ininu “God panya Pitjulku”, panya ngura nyara palula Godanya palula utiringu paluṟu Iitjulanguṟu wirtjapakannyangka. ");
INSERT INTO pjt_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Ka nyara palula minyma panya Ripikanya puḻkantjanya ilungu ini panya Tipuṟanya. Kaya palunya katira tjuṉutjunu ngura nyara Pitjulta uḻpaṟira puṉu waṯa puḻkangka itingka. Munuya palulanguṟu puṉu palunya ininu “Puṉungka Ulanytjanya”. ");
INSERT INTO pjt_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Ka Jacobanya ngura Kainanta maḻaku wirkankunyangka Godanya piṟuku palula utiringu munu palunya pukuḻmanu. ");
INSERT INTO pjt_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Alatji paluṟu pukuḻmaṟa wangkangu, “Nyuntu panya ini Jacobanya nyinangi, palu kuwariṉanta ini ‘Israelnga’ wangkanyi.” Alatji palunya Godalu kampa kutjupaṟa ini tjunu. ");
INSERT INTO pjt_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Munu panya palunya wangkangu, “Ngayuluṉa God panya Witulya Puḻkanya, uwankarangka waintarinytja. Ka nyuntu tjitji tjuṯa mulapa kanyilku, kaya palula tjanalanguṟu nyuntumpa walytja ma-tjuṯa mularariku maḻatja maḻatja munuya ngura kutjupa kutjupa tjuṯangka nyinara waṉalku. Munuya kutjupatjara maḻatja maḻatja mayatja puḻkaringkula nyinaku. ");
INSERT INTO pjt_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Kaṉa manta panya Aipuṟamanya pulanya Isaacanya ungkunytjitja nyuntunya ngapartji piṟuku ungkuku nyuntumpa walytja tjuṯa kuḻu maḻatja maḻatja.” ");
INSERT INTO pjt_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Munu alatji wangkara wiyaringkula Godalu palunya wantikatingu. ");
INSERT INTO pjt_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Ka palulanguṟu Jacobalu apu puḻka mantjiṟa ngura pala palula ngaṟatjunu Godalu palula wangkanytjitja rawangku kulintjikitjangku. Munu paluṟu wainangka uwilangka kuḻu apu palunya kurpiṟa miḻmiḻmanu aṉangu tjuṯangku nyakula Godanya kulintjaku. ");
INSERT INTO pjt_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Munu ngura palunya ininu “Pitjulnga” panya. ");
INSERT INTO pjt_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Kaya palulanguṟu Jacobanya tjana ngura Pitjultanguṟu ma-pakaṉu, munuya anangi ngura ini Ipuṟatjalakutu. Ka Jacobaku kuri Raitjilnga muṯi paku anangi munu palulanguṟu iṯi wirkankunytjaku ilaringkunyangka paluṟu nyinakatingu tjitji kanyintjikitja. Nyangatja Ipuṟatjala wirkankunytja wiya kuwaripaṯuya nguṟurpa nyinangi. Ka minyma nyara paluṟu paku puḻkangku puṯu nguwantu iṯi kanyiningi. ");
INSERT INTO pjt_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Munu paluṟu ma-walykuringu nguwanpa pakuringkula. Ka minyma palula tjungu nyinanytjalu wangkangu Raitjilta, “Nguḻuringkunytja wiya, nyangatja tjitji nyiṯayira wirkanu.” ");
INSERT INTO pjt_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Palu Raitjilnga panya waṯalpi ilunytjikitja ngaringi, munu kutju-aṟa ngaalymaṟa palumpa katja ininu Pinuninya. Ka maḻangka mamangku ini kutjupa tjunu Pintjimannga. ");
INSERT INTO pjt_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Ka palulanguṟu wiyaringu iṯiku panya ngunytju, kaya palunya tjuṉutjunu nguṟurpa ngura ini Ipuṟatjaku iwarangka itingka. (Ngura nyara paluṟu panya ngaṉmanypa ini “Ipuṟatjanya” ngaṟangi, palu maḻangkaya ininu “Bethlehemanya”.) ");
INSERT INTO pjt_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Ka Jacobalu apu mantjiṟa ngaṟatjunu ngura pala palula Raitjilnga kulintjikitjangku, ka puḻi pala paluṟu kuwari ngaṟanyi alatjiṯu aṉangu tjuṯangku nyakula minyma panya palunya kulintjaku. ");
INSERT INTO pjt_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Munu Jacobanya tjana ma-pakaṉu munuya ankula ngura ini Mikitala Iitala waintaṟa ngura tjunkula nyinangi. ");
INSERT INTO pjt_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Ka ngura nyara palula nyinaralpi Jacobaku katjangku Rupintu palumpa mamaku kuringka Pilala tjunguringkula ngaringu panya maḻa aḻṯinytjala. Ka Jacobalu kuliṟa puḻkaṟa mirpaṉaringu. Uwa, Jacobanya ini kutjupa Israelnga munu paluṟu katja panya 12 utinu palumpa kuri kutjara kutjarangka. ");
INSERT INTO pjt_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Panya Liyalu kanyinu Rupinnga (panya katja ngaṉmanyitja), Tjimiyannga, Levinya, Judah-nya, Itjakanya, Tjipulunnga tjananya. ");
INSERT INTO pjt_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Ka Raitjiltu kanyinu Josephanya pulanya Pintjimannga. ");
INSERT INTO pjt_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Ka Raitjilku minyma waṟkaripaingku Pilalu kanyinu Dannga pulanya Napatalinya. ");
INSERT INTO pjt_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Ka Liyaku minyma waṟkaripaingku Tjilpalu kanyinu Kaatanya, Atjanya pulanya. Panya katja nyanga palunya tjananya Jacobalu utinu ngura nyara Mitjupu-taimiyala. ");
INSERT INTO pjt_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Ka palulanguṟu Jacobanya anu palumpa mama Isaacalakutu ngura panya Mamaṟailakutu Ipuṟanta itingka, panya ngura nyara paluṟu Aipuṟamanya pula Isaacanya nyinanytjitja. ");
INSERT INTO pjt_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Ka Isaacanya rawa mulapa nyinangi yiya nampa panya 180, munu palulanguṟulta wiyaringu. Ka palumpa katja kutjarangku katira tjuṉutjunu Iitjulu pula Jacobalu. ");
INSERT INTO pjt_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Ka nyangatja Iitjuku walytjapiti palulanguṟu ma-tjuṯaringkunytja maḻatja maḻatja. (Ka Iitjunya panya ini kutjupa Iitamanya.) ");
INSERT INTO pjt_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","3","Panya Iitjulu aḻṯingu minyma ngura Kainannga nguraṟa maṉkurpa ini nyanganpa – Atanya, Awu-lipamanya, munu kutjupa Patjimanya. Ka minyma panya Atanya wati Iitakunuku uṉṯalpa ini Ilanku. Ka minyma Awu-lipamanya wati ini Anaku uṉṯalpa, panya Ananya wati Ipalakunuku katja ini Tjiipiyanku. Ka minyma panya Patjimanya wati panya Itjumailku uṉṯalpa, munu wati ini Nipaiyatjiku maḻanypa. ");
INSERT INTO pjt_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","5","Ka ngura nyara Kainanta nyinaralpi Iitjunya tjitji tjuṯatjararingu. Panya minyma Atalu katja ini Ilipatjanya kanyinu, ka Patjimalu katja ini Ruwilnga kanyinu, ka Awu-lipamalu kanyinu katja maṉkurpa ini nyanganpa – Tjitjunya, Tjalamanya, Kuṟanya tjananya. ");
INSERT INTO pjt_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Ka palulanguṟu Iitjulu palumpa kuri maṉkurpa, katja uṉṯalpa tjuṯa, kuka tjuṯa kuḻu katingu ngura kutjupakutu parari palumpa maḻanypa Jacobanya wantikatira. Panya palumpa kutjupa kutjupa uwankara Kainanta mantjintjatjanungku paluṟu katingu, wati minyma waṟkaripai tjuṯa kuḻu. ");
INSERT INTO pjt_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Panya Jacobanya pula manta nyara palula kuka tjuṯatjara tjungu nyinanytjaku manta lipi nguwanpa ngaṟanytja wiya. Palulanguṟu Iitjunya anu ngura kutjupakutu. ");
INSERT INTO pjt_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Munu ankula ngura puḻitjarangka ngura tjunkula nyinangi ini Tjiirta munu nyara palula rawa nyinangi. ");
INSERT INTO pjt_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ka Iitjuku katja tjuṯanguṟu palumpa walytja ma-tjuṯaringu maḻatja maḻatja. Kaya palunya tjananya ini wangkapai “Iitamakunu tjuṯa”, panya Iitjunya ini kutjupa Iitamanya. ");
INSERT INTO pjt_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","13","Palumpa panya kuri ngaṉmanyitjangku Atalu kanyinu katja kutju ini panya Ilipatjanya, ka paluṟu katja maṉkur-kutjara utinu ini nyanganpa – Timannga, Uumanya, Tjipunya, Katamanya, Kinatjanya tjananya. Munu Ilipatjalu piṟuku utinu kuri kutjupangka ini Timinala katja kutjupa ini Ama-likanya. Ka Iitjuku kuri maḻatjangku Patjimatjalu katja kutju kanyinu ini panya Ruwilnga. Ka wati nyanga paluṟu utinu katja kutjara kutjara ini nyanganpa – Naatjanya, Tjiṟanya, Tjaamanya, Mitjanya tjananya. ");
INSERT INTO pjt_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Ka Iitjuku kuri kutjupangku panya nguṟuritjangku ini Awu-lipamalu katja maṉkurpa kanyinu ini panya Tjitjunya, Tjalamanya, Kuṟanya tjananya. ");
INSERT INTO pjt_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","16","Kaya nyanga palula tjanalanguṟu Iitjuku walytja tjuṯa mulararingu maḻatja maḻatja. Panya Iitjuku katja ngaṉmanyitjanguṟu Ilipatjalanguṟu palumpa walytja ma-tjuṯaringu, panya katja tjuṯanguṟu ini nyanga tjanalanguṟu Timanta, Uumala, Tjipula, Kinatjala, Katamala, Ama-likala tjanalanguṟu. Nyanga paluṟu tjanaya panya Iitjuku pulampa Ataku pakaḻi tjuṯa. ");
INSERT INTO pjt_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Ka Iitjuku katja Ruwiltanguṟu palumpa walytja ma-tjuṯaringu maḻatja maḻatja palumpa, panya katja tjuṯanguṟu panya ini nyanga tjanalanguṟu Naatjala, Tjiṟala, Tjaamala, Mitjala tjanalanguṟu. Nyanga paluṟu tjanaya panya Iitjuku pulampa minyma Patjimatjaku pakaḻi tjuṯa. ");
INSERT INTO pjt_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Ka Iitjuku kuri Awu-lipamalanguṟu palumpa walytja ma-tjuṯaringu, panya palumpa katja tjuṯanguṟu ini nyanga tjanalanguṟu Tjitjula, Tjalamala, Kuṟala tjanalanguṟu. ");
INSERT INTO pjt_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Uwa, nyanga paluṟu tjana uwankara Iitjuku walytja tjuṯa maḻatja maḻatja panya Iitamakunu tjuṯa, panya Iitjunya ini kutjupa Iitamanya. ");
INSERT INTO pjt_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Ka ngura nyara Iitamala aṉangu kutjupa tjuṯa ngaṉmanypa nyinangi ngura walytjangka Iitjunya tjana pitjanytja kuwaripangka. Paluṟu tjanaya wati ini Aṟiku katjaku walytja tjuṯa ini Tjiirku. Panya Tjiirtu katja nyanga tjananya utinu Latannga, Tjupalnga, Tjipiyannga, Ananya, Titjunnga, Itjanya, Titjannga tjananya, kaya nyanga palula tjanalanguṟu Tjiirku walytja ma-tjuṯaringu maḻatja maḻatja. ");
INSERT INTO pjt_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Ka Tjiirku katjangku Latantu utinu katja kutjara ini Aṟinya pulanya Iimannga. Ka nyanga palula pulalanguṟu palumpa walytja ma-tjuṯaringu maḻatja maḻatja. (Ka Latantu pininu kungka ini Timinanya.) ");
INSERT INTO pjt_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Ka katja panya Tjupaltu utinu katja ini nyanga tjananya Alapannga, Manatjanya, Ipalnga, Tjipawunya, Awunamanya tjananya. Ka nyanga palula tjanalanguṟu palumpa walytja ma-tjuṯaringu maḻatja maḻatja. ");
INSERT INTO pjt_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Ka katja panya Tjiipiyantu katja kutjara utinu ini Aiyanya pulanya Ananya. (Wati nyanga paluṟu Analu kunyu ilytjingka kanyiningi palumpa mamaku tangkiyi tjuṯa munu kunyu nyara palula mina wala nyangu mina waṟutjara.) ");
INSERT INTO pjt_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ka palulanguṟu wati nyanga Analu tjitji kutjara utinu katja ini Titjunnga munu uṉṯalpa ini Awu-lipamanya. ");
INSERT INTO pjt_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Ka wati panya Titjuntu katja kutjara kutjara utinu ini Imatannga, Itjapannga, Iitjaṟannga, Tjiṟannga tjananya. Ka nyanga palula tjanalanguṟu palumpa walytja ma-tjuṯaringu maḻatja maḻatja. ");
INSERT INTO pjt_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ka Tjiiṟaku katjangku Itjalu katja maṉkurpa utinu ini Pilannga, Tjaapannga, Akannga tjananya. Ka nyanga palula tjanalanguṟu palumpa walytja ma-tjuṯaringu maḻatja maḻatja. ");
INSERT INTO pjt_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Ka Tjiirku katja kutjupangku Titjantu katja kutjara utinu ini Utjunya pulanya Aṟannga. Ka nyanga palula pulalanguṟu palumpa walytja ma-tjuṯaringu maḻatja maḻatja. ");
INSERT INTO pjt_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Ka nyanga paluṟu tjana uwankara wati panya Aṟiku walytja tjuṯa nyinangi maḻatja maḻatja, panya paluṟu tjana tjuṯaringu palumpa pakaḻi tjuṯanguṟu ini nyangannguṟu panya Latanta, Tjupalta, Tjiipiyanta, Anala, Titjanta, Itjala, Titjanta tjanalanguṟu. Munuya paluṟu tjana uwankara nyinangi ngura nyara Iitamala. ");
INSERT INTO pjt_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Ka ngura panya Israelta mayatja puḻka nyinanytja kuwaripangka ngura Iitamala mayatja tjuṯa nyinangi wanapari wanapari, munuya palunya nguraṟa tjuṯa mayatjarira kanyiningi. ");
INSERT INTO pjt_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Ngaṉmanypa wati ini Pilanya mayatja puḻka nyinangi. Paluṟu panya wati ini Piyaku katja wati ngura Tinapanya nguraṟa. ");
INSERT INTO pjt_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Ka wati nyanga Pilanya ilunyangka maḻangka mayatja kutjupa nyinangi palumpa aṟangka wati ini Tjupapanya panya wati Tjiṟaku katja. (Tjiṟanya panya wati ngura Patjuṟanya nguraṟa.) ");
INSERT INTO pjt_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Ka palulanguṟu Tjupapanya ilunyangka mayatja kutjupa maḻangka nyinangi palumpa aṟangka wati ini Uutjamanya ngura Timannga nguraṟa. ");
INSERT INTO pjt_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Ka Uutjamanya ilunyangka wati Pitataku katja ini Aatatanya mayatja nyinangi Uutjamaku aṟangka. Wati nyanga Aatatalu warmaḻa tjuṯatjarangku wati ini Mitiyannga tjananya pungkula wiyaṉu ngura manta ini Mawapala. (Aatatanya panya ngura tawunu ini Apitjinya nguraṟa.) ");
INSERT INTO pjt_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Ka Aatatanya ilunyangka palumpa aṟangka wati ngura Matjiṟikanya nguraṟa mayatja nyinangi ini Tjamalanya. ");
INSERT INTO pjt_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Ka palulanguṟu Tjamalanya ilunyangka wati ngura Rayupatjanya nguraṟa palu puṟunypaṯu mayatja nyinangi ini Tjaulnga. ");
INSERT INTO pjt_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Ka Tjaulnga ilunyangka palumpa aṟangka wati Aka-puwaku katja mayatja nyinangi ini Paalanannga. ");
INSERT INTO pjt_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Ka mayatja nyanga paluṟu ilunyangka wati kutjupa ini Aatatanya palumpa aṟangka palu puṟunypaṯu mayatja nyinangi. Paluṟu ngura tawunu ini Paulanya nguraṟa, ka palumpa kuri wati ini Mataṟitaku uṉṯalpa ini Miitapilanya, panya wati ini Mitjapaku puḻiri. ");
INSERT INTO pjt_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Uwa, ngura Iitamaku mayatja tjuṯa nyinangi wati panya Iitjuku walytja tjuṯa maḻatja maḻatja. Mayatja paluṟu tjana ngura walytjangka walytjangka nyinangi manta Iitamala lipiwanu, kaya palula tjanalanguṟu tjanampa walytja ma-tjuṯaringu walytjaṟara walytjaṟara, munuya nyinangi ngura walytjangka walytjangka. Wati mayatja paluṟu tjana ini nyanganpa – Timinanya, Alapanya, Tjitjitjanya, Awu-lipamanya, Ilanya, Pinannga, Kinatjanya, Timannga, Mipatjarnga, Makatilnga, Iṟamanya, tjana. Wati nyanga paluṟu tjana panya manta nyara Iitamala mayatja tjuṯa nyinangi ngura walytjangka walytjangka, kaya palula tjanalanguṟu Iitjuku walytja ma-tjuṯaringkula nyinangi maḻatja maḻatja. ");
INSERT INTO pjt_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Ka wati panya Jacobanya ngura Kainanta rawa nyinangi katja tjuṯatjara. ");
INSERT INTO pjt_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ka tjukurpa nyangangku tjakultjunanyi Jacobanya tjana nyinanytja. Ka Jacobaku katja ini Josephanya wati yangupala nyinangi. Munu paluṟu panya wati kuṯa tjuṯangka tjunguringkula tjanampa mamaku tjiipi nanikuta tjuṯa aṯunymankupai. Ka wati panya kuṯa paluṟu tjana ini nyanganpa – Dannga, Napatalinya, Kaatanya, Atjanya. Palu wati nyanga paluṟu tjana kunyu kura nguwanpa nyinapai. Ka Josephalu kura nyinanyangka nyakula pitjala mamangka tjakultjunkupai. ");
INSERT INTO pjt_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Ka Jacobanya katja puḻka tjuṯaku mukuringangi, palu Josephaku puḻkaṟa mulapa mukuringangi, panya paluṟunku tjiḻpingku kutju maḻatja mulapa wiyakutu utinu. Munu pukuḻarira palumpa Josephaku upukuta wiṟu palyaṉu. ");
INSERT INTO pjt_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Kaya kuṯa tjuṯangku nyakula kuliningi, “Ai! Mamanya tjinguṟu nganampa kuraringanyi munu palumpa kutjuku mukuringanyi.” Munuya paluṟu tjana nyaṟaringangi Josephaku munuya palumpa puṯu kalypa nyinapai. ");
INSERT INTO pjt_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Ka munga kutjupangka Josephalu tjukurmanu munu mungawinki ankula palumpa kuṯa tjuṯangka tjakultjunu, ");
INSERT INTO pjt_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","“Awai! Wangkakuṉa? Ngayulu mungangka tjukurmanu munuṉa alatji nyangu. ");
INSERT INTO pjt_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Panya nganaṉa tjungu waṟkaringi ukiṟi mai wiitangka. Munula kaṯaṟa wiyaringkula uṯuḻuṟa karpiṟa ngaṟatjunangi. Ka palulanguṟu wiita panya ngayulu karpiṟa tjunkunytja uringu munu katuringkula tjukaṟuru ngaṟangi. Ka nyura panya karpiṟa tjunkunytja tjuṯa ankala tjaṟuringu munuya manguṟi-manguṟi para-ngaṟala waṉaṟa pupakatira waḻkuningi wiita panya ngayulu karpiṟa tjunkunytja. Nyanga alatjiṉa tjukurmanu.” ");
INSERT INTO pjt_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Kaya kuṯa panya tjuṯangku tjukurpa nyangatja kuliṟa puḻkaṟa kuraringu palumpa. Munuya wangkangu palula mirpaṉ-mirpaṉṯu, “Palu nyuntun wanyu nganampa mayatja puḻka? Wiya nyuntun nganampa mayatja wiya. Nyuntun kutjutjangku ngunti wangkanyi.” Munuya paluṟu tjana puḻkaṟa kuraringkula palumpa kalyparingkunytja wiyangku wantingi panya paluṟu tjukurmaṟa wangkanytjanguṟu. ");
INSERT INTO pjt_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Ka ngula Josephalu munga kutjupa piṟuku tjukurmanu munu piṟuku tjakultjunu kuṯa tjuṯangka, “Kulilaya! Piṟukuṉa tjukurmanu munuṉa alatji nyangu, tjiṟirpi, piṟa, kililpi tjuṯa 11-tu tultjungaṟakatira ngayunya waḻkunnyangka.” ");
INSERT INTO pjt_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Munu paluṟu ankula palumpa mamangka kuḻu tjakultjunu. Ka paluṟu kuḻu kuliṟa mirpaṉaringu munu palula wangkangu, “Tjinguṟunkun nyuntu kulini ngunytjulu ngali munu kuṯalu tjana nyuntunya mayatja puḻka pupakatira waḻkuntjaku. Palu wiya. Nyuntu tjukaṟurungku tjukurmankunytja wiya. Nyuntu ngunti wangkanyi.” ");
INSERT INTO pjt_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Munu palulanguṟu Josephaku mamangku rawangku kuliningi panya palumpa katjangku tjukurmankunytja. Palu kuṯa tjuṯaya kuliṟa rawa kuraringangi palumpa munuya puṯu kalyparingangi Josephaku. ");
INSERT INTO pjt_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Ka Josephanya ngurangka nyinangi palumpa mamangka ngura ini Ipuṟanta. Ka palumpa kuṯa tjuṯa anu ngura ini Tjikimalakutu tjanampa mamaku tjiipi kanyintjikitja ukiṟi puḻkangka. ");
INSERT INTO pjt_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","15","Palu tjiṟirpi kutjupa Jacobalu wituṉu katja panya Josephanya, “Ankula tjananya nyawa nyuntumpa kuṯa tjuṯa, palyayawi nyinama, munuyawi tjiipi tjuṯa kuḻu palyanyku kanyinma. Munu nyakula pitjala ngayulalta tjakultjura.” Ka Josephalu wangaṉarangku kuliṟa anu ngura panya Tjikimalakutu. Munu paluṟu ankula ngura nyara palula wirkaṟa tjananya puṯu para-nguriningi, “Yaaltjingkaya nyinanyi?” Munu puṯu para-nyakula, ka wati kutjupangku Josephanya nyangu para-ngurinnyangka munu pitjala wangkangu, “Awai! Ngananyan ngurini?” ");
INSERT INTO pjt_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Ka wangkangu, “Ngayuku kuṯa tjuṯaṉa ngurini panya tjiipiya ngalya-katingu ngura nyanga palulakutu ukiṟi puḻkangka kanyintjikitjangku. Tjinguṟu nyuntu ninti. Tjakultjuraṉi, yaaltjingkaya nyinanyi?” ");
INSERT INTO pjt_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ka wati panya kutjupangku wangkangu, “Uwa, ngaṉmanytjuṉa nyangu tjananya nyangangka nyinanyangka. Kaya ankunytjikitjangku wangkangi ngura ini Tuutjantakutu, mununtiya anu.” Ka Josephalu kuliṟa waṉaṉu tjananya ngura nyara palulakutu munu ma-wirkaṟa nyangu, “Munta nyangatjampayal kanyini.” ");
INSERT INTO pjt_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","20","Kaya kuṯa tjuṯangku nyangu parari pitjanyangka kuwaripa. Munuya ngurkantaṟa wangkangu, “Ai! Nyaratjaya nyawa, panya paluṟu tjukurmankupainya wirkanu.” Munuya palulanguṟu nyakunytjatjanungku wangkara kuliningi palunya pungkunytjikitjangku alatji wangkara, “Utila pungkula iluntaṟa palunya wellangka waṉima mina nyanga wiyatjarangka. Munula palulanguṟu mamala ngunti wangkanyi papa inuṟangku patjaṟa iluntankunytja-palku. Ngunti-puṯa palangku tjukurmankunytjatjanu wangkama wanka nyinara, ka ilu ngunti wangkawiya.” ");
INSERT INTO pjt_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","22","Ka kuṯa panya puḻkangku ini Rupintu kulinu tjana wangkanyangka munu paiṟa wangkangu, “Wantiya iluntankuwiyangku munula wanka tjarpatjura wellangka mina nyanga wiyatjarangka munula wantikati.” Rupintu alatji kutjungkul unngu kuliningi, “Kaṉa ngula maḻakungku pitjala mantjila ngayuku maḻanypa tjanala maḻangka munuṉa iyala Mamalakutu.” ");
INSERT INTO pjt_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Munuya Josephanya ilaringkunyangka wituṉu munuya palumpa upukuta panya wiṟunya mantjiṟa tjilpirpungu. ");
INSERT INTO pjt_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Munuya palunya katira piṯi panya ngaṯingka tjarpatjunu mina wiyangka parari puṯu tatintjaku. Munuya anulta ngurakutu mai ngalkuntjikitja. ");
INSERT INTO pjt_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Munuya nyinara ngalkula ngalkula nyangu wati malikitja tjuṯa kamula tjuṯatjara kaṯakutjara wati-pitjanyangka. Paluṟu tjana panya Itjumailku pakaḻi tjuṯa ngura Kiliyatalanguṟu anangi Itjipaku kutjupa kutjupa tjuṯatjara aṉangu Itjipanya nguraṟa tjuṯangka tjalamilantjikitja. ");
INSERT INTO pjt_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Ka Josephaku kuṯa kutjungku ini Judah-lu kulinu wati-pitjanyangka nyakula, munu wangkangu tjanala, “Nyaakula nganampa maḻanypa panya wantinyi piṯingka nyinara ilunytjaku? ");
INSERT INTO pjt_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Utila nyanga tjanala tjalamilanma, nyanga ananyiya kaṯakutjara. Nyangatja nganampa maḻanypa walytja mulapa, kala nyaaku iluntankuku? Tjalamilalala.” ");
INSERT INTO pjt_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Ka kuṯa maḻanypa tjuṯangku kuliṟa wangkangu, “Munta-uwa, tjinguṟula nyanga alatji palyalku.” Munuya ankula Josephanya wellanguṟu mantjiṟa katira tjalamilaṉu Itjumailku pakaḻi maṉkurta. Ka tjananya ngapartji mani ungu tjiilpa tjuṯa mulapa. Munuya palulanguṟu katingulta Josephanya manta kutjupakutu ngura panya Itjipalakutu. ");
INSERT INTO pjt_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Palu tjana Josephanya ungkul'iyaṉu kuṯa panya puḻka Rupinnga unytju ankunyangka. Ka paluṟu maḻa kutju pitjangu Josephanya mantjintjikitja wellanguṟu. Munu wirkaṟa puṯu nyakula puḻkaṟa tjituṟu-tjituṟuringu, mununku mantara aṉangitja tjilpirpungu palumpa maḻanypa-tjiratjangku. ");
INSERT INTO pjt_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Munu paluṟu ngapariringu palumpa maḻanypa tjuṯakutu munu wangkangu tjanala, “Josephanya wiya ngaṟanyi! Kaṉa nyaa wangkaku Mamala?” ");
INSERT INTO pjt_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Kaya maḻanypa tjuṯangku nintingku kuliṟa wangkangu, “Wiya, nanikutala-puṯa puwa munula upukuta palumpa milkaḻingka nyiṯiṟa katira Mamala nintila. Ka nyakula kulilku inuṟangku patjantja-palku.” Munuya mulapaṯu nanikuta pungkula upukuta panya mantjiṟa nyiṯinu milkaḻingka. ");
INSERT INTO pjt_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Munuya katira nintinu mamangka watarkitjangku-palku. Munu tjana ngunti wangkangu, “Nganaṉa ngalya-pitjala nguṟurpa nyangu upukuta nyangatja mantangka ngarinyangka munula mantjinu. Tjinguṟu nyuntumpa katjaku nyangatja, mulapa?” ");
INSERT INTO pjt_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Ka Jacobalu nyakula ngurkantanu munu wangkangu, “Uwa, mulapa upukuta paluṟuṯu.” Munu puḻkaṟa urulyaraṟa wangkangu, “Tjinguṟu mulapa inuṟa pikaṯingku patjaṉu ngayuku katja. Ngaḻṯutjara, ngalkulanti wiyaṉu.” ");
INSERT INTO pjt_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Munu alatji kuliṟa puḻkaṟa ulara ulara palumpa ulytja aṉangitja tjilpirpungkula waṉingu munu ulytja walyku-walykungka tjarpangu, munu rawa mulapa katja-tjiratja tjituṟu-tjituṟu puḻka nyinangi. ");
INSERT INTO pjt_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ka palumpa katja tjuṯangku uṉṯaltu kuḻu pitjala palunya puṯu kanmarmanangi pampuṟa, palu kanmararinytja wiyangku alatjiṯu wantingi. Munu wangkangu, “Ngayulu kuwari wiyaringkunytja wiya. Ngayulu ilura kutju watarkuriku.” Munu palulanguṟu paluṟu rawa alatjiṯu tjituṟu-tjituṟu nyinangi, tjiḻpi panya Jacobanya. ");
INSERT INTO pjt_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Kaya wati panya Mitiyannga nguraṟa tjuṯangku Josephanya ngura Itjipalakutu katira tjalamilaṉu wati ini Putipala. Ka wati nyanga Putipanya Itjipaku mayatja puḻkangka ini Piiṟala ititja mayatja tjukutjuku munu paluṟu kanyiningi Piiṟaku wati tjaultji tjuṯa, munuya paluṟu tjana mayatja Piiṟanya aṯunymankupai. ");
INSERT INTO pjt_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Ka nyara palula aṟangka Jacobaku katja Judah-lu kuṯa maḻanypa tjuṯa kuḻu wantikatira anu kutju wati ini Iiṟalakutu tawunu ini Atulamalakutu. ");
INSERT INTO pjt_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Munu nyara palula nyangu kungkawaṟa Kainannga nguraṟa wati ini Tjuwaku uṉṯalpa, munu kungkawaṟa nyara palunya aḻṯingu wati panya Judah-lu. ");
INSERT INTO pjt_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Ka kungkawaṟa nyara paluṟu iṯitjararingu munu katja kanyinu Judah-ku, ka Judah-lu ininu Uurnga. ");
INSERT INTO pjt_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Ka palulanguṟu piṟuku iṯitjararingu munu katja kutjupa kanyinu munu ininu Anannga. ");
INSERT INTO pjt_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ka palulanguṟu Judah-nya pula anu ngura ini Kitjipalakutu munu ngura tjunkula nyinangi, ka ngura nyara palula pula piṟuku katjatjararingu, ka ngunytjungku ininu Tjilanya. ");
INSERT INTO pjt_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Ka ngula katja panya ngaṉmanyitja Uurnga puḻkaringkunyangka palumpa mama Judah-lu kungkawaṟa ini Taimanya palumpa ngurkantanu aḻṯinytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Palu wati nyanga Uunya kura puḻka nyinangi, ka Godalu palunya nyakula puḻkaṟa mirpaṉaringu palumpa munu palunya iluntanu. ");
INSERT INTO pjt_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Ka palulanguṟu Judah-lu Uuku maḻanytja wangkangu wati panya Ananta, “Kungka nyanga wanakaḻangka ngarima nyuntumpa inkaṉingka munu palula tjitji utinma. Panya nyangatja nganampa tjaka kuṯa tjitji wiya ilunyangka maḻanypangku minyma wanakaḻangka utilpai, ka tjitji paluṟu kuṯaku tjitji nyinapai.” ");
INSERT INTO pjt_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Ka Anantu tjitji utintjikitjangku kuliningi palu piṟuku paluṟu kuliningi, “Tjinguṟuṉa tjitji utiṟa, ka tjitji nyara paluṟu ngayuku wiya palumpaṟa ngaṟaku ngayuku kuṯaku.” Munu palulanguṟu palumpa inkaṉingka tjunguringkula ngaringi wanakaḻa panya Taimala, palu paluṟu mulamula tjunguringkunytja wiyangku wantingi tjitji utintjaku-tawara, ka Taimanya iṯitjararingkunytja wiya ngaṟangi. ");
INSERT INTO pjt_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ka nyara palulanguṟu mulamula tjunguringkuwiyangku wantinyangka Godanya wati palumpa mirpaṉaringu munu palunya iluntanu. ");
INSERT INTO pjt_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Ka palulanguṟu Judah-lu palumpa mingkayi Taimala wangkara iyaṉu, “Ankula nyuntumpa mamangka ma-nyinama ngayuku katja Tjilanya puḻkaringkunytjaku paṯaṟa.” Nyanga alatji paluṟu nguḻuringkula wangkangu panya paluṟu kuliningi, “Kuwari tjinguṟu Tjilanya ngapartji ilunyi palumpa kuṯa kutjara puṟunypa.” Ka palulanguṟu Taimanya ankula palumpa mamangka rawa ma-nyinangi kutju kuḻi tjuṯa wati panya Tjilaku paṯaṟa. ");
INSERT INTO pjt_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Ka ngula mulapa Judah-ku kurilta ilungu wati panya Tjuwaku uṉṯalpa. Ka palulanguṟu ulara ulara wiyaringkula palumpa maḻpa wati ini Iiṟanya pula anu ngura ini Timinalakutu palumpa tjiipi tjuṯa tjiiṟamilannyangka nyakunytjikitja. ");
INSERT INTO pjt_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Ka kutjupangku tjakultjunu kungkawaṟa panya Taimala palumpa mingkayi ngura panya Timinalakutu ankunytja. ");
INSERT INTO pjt_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Ka kungkawaṟa paluṟu kuliṟa mantara panya kuri-tjiratjangku kanyintjanya araltjanu munu mantara kutjupangka tjarpangu munu yunpangka raiki angatjunu ngurkantankunytjaku-tawara. Munu ankula nyinakatingu ngura tawunu ini Inaimala kaitangka itingka iwara panya Timinaku iwarangka Judah-ku paṯaṟa. Panya paluṟu nyangangi Judah-ku katja Tjilanya ma-puḻkaringkunyangka munu kuliningi, “Nyaakuṉi aḻṯinytjaku ungkuwiyangku wantinyi Judah-lu.” ");
INSERT INTO pjt_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Ka Judah-lu iwarangka pitjala palunya nyangu munu kulinu kungkawaṟa kuḻantju-palku nyinara nyaḻiringkunyangka, panya paluṟu yunpa raikingka angatjuṟa nyinangi. ");
INSERT INTO pjt_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Palu Judah-lu palunya ngurkantankunytja wiya panya palumpa mingkayi munu palulakutu ma-pitjala wangkangu iwarangka itingka nyinanyangka nyakula, “Uwa wala pitja, kali ngarima!” Ka palula tjapinu, “Uwa, kaṉin nyaa ungkuku ngayula tjunguringkula?” ");
INSERT INTO pjt_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Ka wangkangu Judah-lu, “Ngulaṉanku iyaṉi ngayuku kuka tjuṯanguṟu nanikuta yangupala.” Ka kungkawaṟa paluṟu wangkangu, “Uwa palya. Palu wanyuṉi kutjupa kutjupa kuwariṯu unytjungku uwa nyanga ngayulu nyuntumpa kalkuntjitjaku mulamularingkunytjaku, kaṉi kalkuntja ungkunyangkaṉanta maḻakungku ungkuku.” ");
INSERT INTO pjt_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Ka Judah-lu tjapinu, “Nyaaṉanta ungkuku nyuntu mulamularingkunytjaku?” Ka wangkangu kungkawaṟa panya paluṟu, “Uwaṉi pala liritja nyuntunya initjara munu puṉu pala tjukara kuḻu.” Ka mulapaṯu Judah-lu puṉu panya tjukara munu liritja kuḻu ungu palunya. Munu palulanguṟu kungkawaṟa panya palula tjunguringkula ngaringu, ka paluṟu tjunitjararingu. ");
INSERT INTO pjt_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Munu palulanguṟu ngurakutu ankula mantara araltjanu raiki panya yunpangka angatjunkunytja kuḻu, munu mantara kutjupangka tjarpangu, mantara panya kuri-tjiratjangku tjarpara kanyintjala. ");
INSERT INTO pjt_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Ka Judah-lu palumpa maḻpa wati Iiṟanya ungkul'iyaṉu kungkawaṟa panya palumpa nanikuta, munu wangkangu kungkawaṟa panya palulanguṟu mantjiṟa katinytjaku palumpa panya puṉu tjukara munu liritja kuḻu. Palu Iiṟalu ankula kungkawaṟa palunya puṯu nguriningi. ");
INSERT INTO pjt_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Munu wati panya ngura Inaimanya nguraṟa tjuṯangka tjapinu, “Yaaltji kungkawaṟa panya kuḻantju panya iwarangka itingka nyinangi?” Kaya wati panya palula wangkangu, “Wampa! Nyangangka kungkawaṟa kuḻantju nyinanytja wiyaṯu.” ");
INSERT INTO pjt_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Ka palulanguṟu maḻaku ankula Judah-la wangkangu, “Puṯuṉa nguriningi kungkawaṟa panya palunya. Wiya ngaṟangi. Wati nyara palunya nguraṟa tjuṯangkuṉiya wiyanmanu wangkara, ‘Nyangangka minyma kuḻantju nyinanytja wiyaṯu.’” ");
INSERT INTO pjt_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Ka Judah-lu nyangatja kuliṟa wangkangu, “Wiya palya, wanti rawangku ngurilwiyangku, ka kanyinma. Tjinguṟuya aṉangu tjuṯa ngalimpa nyakula ikaringama rawangku ngaṟala ngurinnyangka. Ngayulu palunya nanikuta ungkunytjikitjangku kuliningi munu panyaṉanta ungkul'iyaṉu palunya katira ungkunytjaku, palu puṯultaṉa nguriningi. Palya ma-wanti.” ");
INSERT INTO pjt_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Palu piṟa maṉkurnguṟu aṉangu kutjupangku Judah-la pitjala wangkangu, “Nyuntumpa mingkayi Taimanya kuḻantjuringu munu paluṟu kuwari mukala nyinanyi.” Ka Judah-lu nyangatja kuliṟa wangkangu, “Katiya munuya tiliṟa urkuwaṉi waṟungka.” ");
INSERT INTO pjt_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Kaya kungkawaṟa panya palunya mantjiṟa katingu. Ka kungkawaṟa paluṟu wangkara iyaṉu palumpa mingkayikutu alatji wangkara, “Ngayunyaṉi iṯitjaraṉu puṉu nyangaku walytjangku. Kaya nyawa munuya nyakula ngurkantara nganaku nyangatja puṉu nyanga tjukara munu liritja kuḻu.” ");
INSERT INTO pjt_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Ka palulanguṟu Judah-lu nyakula ngurkantanu puṉu munu liritja kuḻu panya, munu kuṉṯaringkula wangkangu, “Wiya, paluṟu tjukaṟuru, ka ngayulu kura. Utiṉa panyatja palunya ungama ngayuku katja Tjilanya palunya aḻṯinytjaku.” Munu palulanguṟu Judah-lu palunya walatjunkunytjaku wangkangu munu palunya piṟuku pampuntja wiyangku wantingu. ");
INSERT INTO pjt_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Ka palulanguṟu ngula kungkawaṟa panya Taimanya tjuni iniringkunyangkaya nyangu, “Ai! Kuwari iṯi kutjara kanyini minyma nyangangku.” ");
INSERT INTO pjt_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Ka palulanguṟu iṯi miṉa kutju-waraṟa wirkanu, ka minyma panya palunya kanyilpaingku puṯuru rituwana tjukutjukungka miṉa mapalku karpinu munu wangkangu, “Nyanga paluṟu-waraṟa ngaṉmanypa wirkanu.” ");
INSERT INTO pjt_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Palu iṯi paluṟu wirkankunytja wiyangku miṉa panya maḻakungku ilaṉu puṯuru winki, ka iṯi panya kutjupangku waintarira ngaṉmanypa paluṟu-waraṟa wirkanu. Ka minyma panya kanyilpaingku iṯi panya kuranyu wirkankunytjanya wangkangu, “Munta, nyanga alatjingaṟan kuranyu uṉṯuṟa wirkanu!” Kaya iṯi palunya ininu Piṟitjinya. ");
INSERT INTO pjt_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Ka palula maḻangka iṯi panya miṉa karpintjanya wirkanu, kaya palunya ininu Tjiṟanya. ");
INSERT INTO pjt_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Ka panya Itjumailku pakaḻipitingku Josephanya katira manta ngura kutjupangka Itjipala ma-ungu wati kutjupa manikitjangku wati ini Putipanya. Ka wati panya paluṟu mayatja tjukutjuku nyinangi tjaultji tjuṯaku. Tjaultji nyara paluṟu tjana panya mayatja Piiṟaku ngura aṯunymaṟa anga-kanyilpai. ");
INSERT INTO pjt_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Ka Josephanya wati panya Putipaku ngurangka nyinangi munu ngura pala palula wiṟuṟa palumpa waṟkaringi, panya Mayatja Godalu palunya puḻkaṟa alpamilannyangka. ");
INSERT INTO pjt_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Ka Putipalu nyakula kulinu, “Munta, mulapa Godalu palunya alpamilaṉi ngayuku tjukaṟuru wiṟuṟa waṟkarinytjaku.” ");
INSERT INTO pjt_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Munu paluṟu palumpa puḻkaṟa pukuḻarira wangkangu waḻi ulytja uwankara palumpa aṯunymaṟa kanyintjaku. ");
INSERT INTO pjt_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Ka palulanguṟu Godalu Putipaku wiṟuṟa palyaningi Josephalawanungku. Ka palumpa ngura waḻi uwankara palya alatjiṯu ngaṟangi, ka palumpa kaanangka mai puḻka pakaningi. ");
INSERT INTO pjt_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Ka Putipalu nyakula puḻkaṟa mulapa Josephaku pukuḻaringu munu palunya tjunu palumpa kutjupa kutjupa uwankara kanyintjaku. Munu paluṟu aṯunymaṟa uwankara palumpa kulintja wiyangku mai kutju kuliningi palumpa ngurangka pitjala ngalkuntjikitjangku. Palu Josephanya wati yangupala wiṟunya munu yunpa wiṟunya mulapa aṉangu lipula. ");
INSERT INTO pjt_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Ka palulanguṟu Putipaku kuringku nyangangi munu nyakula nyaḻiringangi palumpa. Munu kutjupa-aṟa nyakula Josephala wangkangu, “Wai, nyuntu ngali ngariku?” ");
INSERT INTO pjt_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","9","Ka Josephalu wiyanmaṟa wangkangu, “Wiya, kulila! Ngayuku mayatja Putipaluṉi waḻi nyangaku tjunu palumpa kutjupa kutjupa uwankara aṯunymaṟa kanyintjaku. Munu palulanguṟu kulintja wiyangku wantinyi ngayulu uwankara tjukaṟurungku kanyinnyangka munu panya pukuḻpa alatjiṯu nyinanyi. Palu nyuntunya kanyintjakuṉi tjunkunytja wiya alatjiṯu. Panya nyuntu palumpa kuri ngayuku mayatjaku kutju. Ka ngayulu tjinguṟu nyuntula ngarirampa kura puḻka mulapa palyalku Godala miṟangka.” Munu palunya wantingi alatjiṯu. ");
INSERT INTO pjt_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Palu minyma paluṟu rawangku tjapiningi tjiṟirpi kutjupa tjiṟirpi kutjupa Josephanya palula tjunguringkunytjaku. Palu paluṟu kuliṟa alatjiṯu wantingi rawangku. ");
INSERT INTO pjt_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Munu palulanguṟu Josephanya tjiṟirpi kutjupa uṟilta waṟkarinytjatjanu waḻi unngu ngapartji waṟkarinytjikitja tjarpangu. Ka aṉangu panya waḻi unngu waṟkaripai tjuṯa wiya ngaṟangi. ");
INSERT INTO pjt_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Palu minyma panya Putipaku kuri kutju unngu nyinangi munu paluṟu Josephanya nyakula pakaṟa ma-waṯaparaṟa upukuta witiṟa wangkangu, “Josepha! Wiṟun mulapa! Yaaltjin kulini? Ngarimali.” Palu Josephanya tjirkaṉu paluṟu witinnyangka, ka minymangku panya upukuta palumpa puḻkaṟa witiṉu ka paluṟu araṟa wantikatingu witiṟa kanyinnyangka, munu ma-wirtjapakaṉu uṟilkutu. ");
INSERT INTO pjt_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ka minyma panya paluṟu upukuta kutju mantjiṟa kanyiṟa puḻkaṟa mirpaṉaringu. ");
INSERT INTO pjt_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","15","Munu paluṟu ngunti kampa kutjupaṟa wangkanytjikitjangku kuliningi munu waṟkaripai tjuṯa aḻṯira wangkangu, “Kuuta nyangatjaya nyawa. Wati panya Iipuṟungku nyangatja wantikatira nguḻu wirtjapakaṉu, panya paluṟu ngayulakutu pitjangu munuṉi witiṉu ngarilyinkunytjikitjangku. Kaṉa puḻkaṟa mirangu. Ka paluṟu upukuta wantikatira nguḻu wirtjapakaṉu. Ngunti palunya ngayuku miitangku palya-palku mantjinu, kaṉi ngayunya kuraṉu.” ");
INSERT INTO pjt_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Munu paluṟu upukuta panya kanyiningi Putipaku paṯaṟa. ");
INSERT INTO pjt_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Munu Putipanya ngurangka wirkankunyangka nyakula piṟuku wangkangu ngunti, “Wati panya Iipuṟungkuṉi kuraṉu nyuntumpa panya waṟkangku. Paluṟuṉi pitjala witiṉu watarku nyinanyangka ngarilyinkunytjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Palu ngayuluṉatju puḻkaṟa mirangu, ka paluṟu upukuta nyangatja wantikatira wirtjapakaṉu.” ");
INSERT INTO pjt_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Ka Putipanya kuliṟa puḻkaṟa mirpaṉaringu Josephaku. ");
INSERT INTO pjt_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Munu wati tjaultji tjuṯangka wangkangu witiṟa katira tjailangka tjarpatjunkunytjaku. Tjaila nyara palula panya mayatja Piiṟalu wati kuralpai tjuṯa tjarpatjunkupai. Kaya pala palula Josephanya tjarpatjunu. ");
INSERT INTO pjt_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Palu Mayatja Godalu palunya tjaila unngu nyinanyangka wiṟuṟa aṯunymanangi. Kanku paluṟu pukuḻpa alatjiṯu nyinangi palya mulapa. Ka tjailaku mayatjangku palunya nyangangi pukuḻpa nyinanyangka munu palumpa pukuḻaringu. ");
INSERT INTO pjt_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Munu palulanguṟu palunya tjunu wati nyara tjailangka nyinanytja tjuṯa aṯunymankunytjaku. Ka tjananya uwankara para-nyakupai, wati panya Josephalu. ");
INSERT INTO pjt_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Ka tjailaku panya mayatja puḻkangku wantingu Josephalu uwankara kanyintjaku panya Mayatja Godanya Josephala tjungu nyinangi. Munu palunya nintiningi tjukaṟuru wiṟuṟa waṟkarinytjaku, ka uwankara palya alatjiṯu ngaṟangi Josephalu kanyinnyangka. ");
INSERT INTO pjt_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Ka ngula Mayatja Piiṟaku waṟka kutjarangku palunya kuraṉu Piiṟanya. Wati panya kutjungku waina Piiṟanya palyaṟa ungkupai, ka panya kutjupangku mai nyuma paulpai Piiṟaku. ");
INSERT INTO pjt_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","3","Palu paluṟu pula kurannyangka Piiṟalu pulanya mirpaṉarira tjailangka tjarpatjunu panya kuralpai tjuṯangka tjungu nyinanytjaku. Ka nyara palula panya Josephanya kuḻu nyinangi. ");
INSERT INTO pjt_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","5","Ka tjailaku mayatjangku Josephala wangkangu pulanya aṯunymaṟa wiṟuṟa kanyintjaku. Ka pula tjailangka rawa mulapa nyinangi, munu palulanguṟu pula munga kutjupa kunkunpa ngarira tjukurmanu. Paluṟu waina panya ungkupaingku tjukurpa kutjupa tjukurmanu, ka paluṟu mai panya paulpaingku kutjupaṯu tjukurmanu. ");
INSERT INTO pjt_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","7","Munu pula mungawinki pakaṟa rawangku kuliningi munu pula puṯu kuliṟa tjituṟu-tjituṟu nyinangi. Ka Josephalu wirkaṟa tjituṟu-tjituṟu nyakula wangkangu, “Nyaanguṟu nyupali tjituṟu-tjituṟu nyinanyi?” ");
INSERT INTO pjt_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ka pula wangkangu, “Mungangka ngali tjukurmanu munuli puṯu kuliningi. Ka aṉangu kutjupangku pitjala ngalila kuliṟa utiṟa wangkanytjaku wiya ngaṟanyi.” Ka Josephalu wangkangu, “Godanya ninti, panya nyupali tjukurmankunytja paluṟu kutjungku utilpai. Walangku pula wanyu wangka panya nyupali tjukurmankunytja, kaṉa kuliṟa Godala tjapilku ka paluṟu utilku.” ");
INSERT INTO pjt_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","11","Ka wati panya waina ungkupaingku-waraṟa wangkangu nyanga alatji, “Ngayuluṉa ngarira tjukurpa nyanga alatji nyangu mai panya kiṟipitji puṉu ngaṟanyangka ngayula itingka miṉa maṉkurtjara. Ka puṉu nyara palula nyaḻpi tjuṯa mapalku pakaningi inuntji kuḻu. Ka inuntjinguṟu mai kiṟipitji pakaṟa kuṟuringu. Ka ngayulu kanyiningi mayatjaku panya walpayaṯa, munuṉa kiṟipitji mantjiṟa walpayaṯangka maṟangku tjulkuṉu tjuratja uṟu tjutiṟa wamaringkunytjaku. Munuṉa palulanguṟu tjaalyngaṟatjuṟa ungu mayatja Piiṟanya.” ");
INSERT INTO pjt_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","13","Ka Josephalu kuliṟa wangkangu wati panya palula, “Kulilaṉi kaṉa utilku! Panya puṉu kiṟipitji miṉa maṉkurtjaran nyangu. Pala palulanguṟu kulinma panya tjiṟirpi maṉkurpa ngaṟaku, kanta palulanguṟu Mayatja Piiṟalu nyuntunya tjailanguṟu pakaltjingalku panya palu puṟunypaṯu palumpa waṟkarinytjaku. Ka nyuntu panya piṟuku walpayaṯangka waina tjutiṟa ungkuku mayatja panya palunya. ");
INSERT INTO pjt_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","15","“Palu nyuntu nyanganguṟu pakaṟa piṟuku wiṟuṟa waṟkarirampa-puṯa kulinma ngayunya munu wangka mayatja panya Piiṟala ngayuku ngaḻṯuringkunytjaku munu ngura nyanganguṟu pakaltjingantjaku. Panya ngayunyaya witiṟa katingu ngura nyara Iipuṟu tjuṯaku mantanguṟu ngura nyanga Itjipalakutu. Kaṉiya ngura nyangatja nguraṟangku ngapartji piṟuku witiṟa tjailangka tjarpatjunu wiyanguṟu alatjiṯu.” ");
INSERT INTO pjt_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","17","Palu wati kutjupangku mai nyuma paulpaingku kuliningi Josephalu tjukurmankunytja panya wiṟuṟa utiṟa wangkanyangka. Munu palulanguṟu raparingkula wangkangu, “Wangkakuṉa? Ngayulu kuḻu tjukurmanu alatji, panya ngayuluṉa piti maṉkurpa tjaḻiṟa katangka katulkira katulkira katingi. Palu kutjara uḻṯu, ka kutju katutja mai waṟuly-waṟulyitjara mayatja Piiṟanya ungkunytjaku. Ka mai panya palunya tjuḻpu tjuṯangku pitjala ngalkuningi.” ");
INSERT INTO pjt_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","19","Ka Josephalu wangkangu, “Uwa, kulilaṉi kaṉa utilku. Panya piti maṉkurpan tjukurmanu. Nyara palulanguṟu kulinma tjiṉṯu maṉkurpa ngaṟanyangka mayatja Piiṟalu wangkaku nyuntunya tjailanguṟu pakaltjingantjaku. Palu pala palula maḻangka nyuntunya kata kaṯantjaku wangkaku mununta kata kaṯaṟa puntu kutju puṉungka utitjunkunytjaku wangkaku. Kantaya tjuḻpu tjuṯangku pitjala ngalkuku.” Alatji Josephalu utiṟa wangkangu wati panya mai paulpaingka. ");
INSERT INTO pjt_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","21","Ka panya palulanguṟu tjiṟirpi maṉkurpa wiyaringkunyangka Piiṟaku tjiṟirpi panya wirkanu, paluṟu panya iṯi ngarinytjitja. Kaya tjiṟirpi pala palulalta waṟka tjarangku mai puḻka palyaṉu kuka kuḻu Piiṟaku maḻpa tjuṯangku tjunguringkula ngalkuntjaku palumpa pukuḻarira. Ka palulanguṟu Piiṟalu wangkangu wati panya kutjara waina ungkupai munu mai paulpainya pulanya tjailanguṟu pakaltjingaṟa katinytjaku palulakutu. Munu wati panya waina ungkupai maḻakungku tjunu piṟuku palumpa waṟkarinytjaku, palunya waina palyaṟa ungkunytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Munu wangkangu wati panya kutjupa iluntankunytjaku wati panya mai paulpainya. Panya Josephalu wangkanytjitja alatjiṯu utiringu. ");
INSERT INTO pjt_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Palu wati panya waina ungkupai Josephaku tjukurku watarkuringu, munu panya Mayatja Piiṟala tjapintja wiyangku wantingu Josephanya tjailanguṟu walatjunkunytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Ka Josephanya rawa nyinangi tjailangka. Ka ngula kuḻi kutjara ngaṟala wiyaringkunyangka Itjipaku mayatja Piiṟalu munga kutjupangka ngarira tjukurmanu, munu nyanga alatji paluṟunku walytjangku nyangu karu puḻka uṟu ini Nayilta kantilytja ngaṟanytja. ");
INSERT INTO pjt_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Munu paluṟu nyangu puluka 7 uṟunguṟu ngalya-pakannyangka uṟungka unngu ngaṟanytjatjanu. Paluṟu tjana kuka palya kaṉpi puḻka. Munu paluṟu tjana uṟunguṟu pakantjatjanungku karu kantilytja ngaṟala ukiṟi ngalkuningi. ");
INSERT INTO pjt_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","4","Ka palula maḻangka palu puṟunypa puluka 7 kutjupa uṟu panya palulanguṟuṯu ngalya-pakaṉu. Palu paluṟu tjana palya wiya nyurka-nyurka tjuṯa. Munuya pakaṟa puluka panya palya tjuṯangka itingka ngaṟangi karungka kantilytja. Munuya palulanguṟu nyurka panya tjuṯangku puluka panya kaṉpi puḻka tjuṯa ngalkula uwankara wiyaṉu. Ka alatji tjukurmankunytjatjanu mayatja panya Piiṟanya wankaringu. ");
INSERT INTO pjt_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Munu palulanguṟu maḻaku kunkunarira piṟuku tjukurmanu nyanga alatji, panya ukiṟi mai wiita ngaṟangi miṉa 7-tjara mai uṉinypa puḻkatjara. Ka mai uṉinypa panya paluṟu tjana piḻṯiringkula wiṟu ngaṟangi urantjaku. ");
INSERT INTO pjt_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Ka palula maḻangka ukiṟi kultu panya palulaṯu piṟuku pakaṉu miṉa 7 kutjupa mai uṉinypa kurakuratjara kutju-kutjutjara panya waḻpa waṟungku kampara kurantja. ");
INSERT INTO pjt_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ka mai nyanga kuḻingku kampara kurantjitjangku mai panya ngaṉmanypa puḻka pakantja ngalkula wiyaṉu. Munu nyanga alatji tjukurmankunytjatjanu mayatja panya Piiṟanya piṟuku wankaringu munu ngarira kuliningi, “Munta, tjukurmanangi-mantiṉa.” ");
INSERT INTO pjt_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Munu paluṟu mungawinki pakaṟa nyinara puṯulta kuliningi, “Yaaltji-yaaltjiṉa panyatja tjukurmanu?” Munu palulanguṟu aḻṯingu palumpa panya wati nintipuka tjuṯa munu ayinayini palyalpai tjuṯa munu ngangkaṟi tjuṯa kuḻu. Kaya pitjangu Piiṟalakutu. Ka paluṟu tjanala tjakultjunu tjukurmankunytjatjanungku tjana kuliṟa palula utiṟa wangkanytjaku. Palu tjana puṯu kuliningi utiṟa wangkanytjikitjangku, “Nyaala wangkaku? Puṯula kulini?” ");
INSERT INTO pjt_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","11","Ka palulanguṟu wati panya waina ungkupaingkulta kulinu, “Munta-uwal panyatja! Wati panya Josephanya ninti.” Munu paluṟu Piiṟala wangkangu, “Kurangkuṉanta wantingi. Utiṉanta panyatja ngaṉmanytjulpi tjakultjunama panya nyuntu ngalimpa mirpaṉaringu munu panyan ngalinya tjailangka tjarpatjunu tjaultji tjuṯaku mayatjaku waḻingka. Kali nyara palula nyinara nyinara ngulalta munga kutjupa ngarira tjukurmanu, paluṟu kutjupa, ka ngayulu kutjupaṯu. ");
INSERT INTO pjt_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ka wati Iipuṟu nyara palula ngalila tjungu nyinangi. Paluṟu panya yangupala tjaultji tjuṯaku mayatjaku waṟkaripai. Kali tjukurmankunytjatjanungku palula tjakultjunu. Ka ngalila utiṟa wangkangu tjukaṟurungku. ");
INSERT INTO pjt_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ka paluṟu panya wangkanytja mulapaṯu maḻangka utiringu. Panya nyuntu ngayunya pakaltjingaṟa maḻakungku tjunu nyuntumpa waṟkarinytjaku, munun wati panya kutjupa mai paulpainya iluntanu.” ");
INSERT INTO pjt_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","15","Ka Piiṟalu nyangatja kuliṟa wati waṟka kutju tjailakutu wituṟa iyaṉu Josephanya aḻṯira ngalya-katinytjaku. Ka Josephalu tjailanguṟu pakaṟa ngaṉkurpa kaṯaṉu munu mantara palyangka tjarpara anu Piiṟalakutu. Ka Piiṟalu palula tjakultjunu alatji, “Mungangkaṉa tjukurmanu munuṉa mungawinki pakaṟa nyanga tjanala tjakultjunu. Kaya puṯu kuliningi ngayula utiṟa wangkanytjikitjangku. Palu kutjupangkuṉi wangkangu nyuntu kunyun tjukurmaṟa wangkanyangka utiṟa tjakultjunkupai.” ");
INSERT INTO pjt_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Palu Josephalu mayatja panya palula wangkangu, “Uwa palya, kulilaltaṉi! Ngayulu kutjungku tjukurmankunytja uwankara puṯu walytjangku utiṟa wangkapai. Palu Godalu ngayula nintinnyangka kutjuṉa utiṟa tjakultjunkupai. Kuwariṉi Godalu ngayula nintini tjukurpa nyanga nyuntumpa utiṟa wangkanytjaku nyuntula, kan nyara palulanguṟulta kuliṟa pukuḻariku.” ");
INSERT INTO pjt_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Ka Piiṟalu tjakultjunu Josephala, “Nyanga alatjiṉa tjukurmanu. Ngayulu karu panya puḻka uṟu ini Nayilta kantilytja ngaṟangi. ");
INSERT INTO pjt_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Munuṉa nyangu kuka puluka kaṉpi puḻka tjuṯa tjapanpa uṟu unngu ngaṟanytjatjanu ngalya-pakannyangka. Kaya puluka paluṟu tjana pakaṟa karu kantilytja ngaṟala ukiṟi ngalkuningi. ");
INSERT INTO pjt_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Kaṉa piṟuku nyangu uṟu palulanguṟuṯu puluka 7 kutjupa ngalya-pakannyangka nyurka-nyurka tjuṯa. Kaṉa nyara palulanguṟu nyakula urulyaraningi, panya ngura nyanga Itjipala ngayulu ngaṉmanytju nyakunytja wiyaṯu puluka kantilypa uti nyanga palu puṟunypa. ");
INSERT INTO pjt_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Kaya nyurka-nyurka tjuṯangku pakaṟa ngalkula wiyaṉu puluka panya palya tjuṯa. ");
INSERT INTO pjt_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Kaṉa ngayulu nyangangi paluṟu tjana ngalkuntjatjanu tjuni paḻtjaringkunytja wiya nyurkaṯu ngaṟangi. Munuṉa nyara palunya nyakunytjatjanu wankaringu. ");
INSERT INTO pjt_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","23","“Munuṉa maḻaku kunkunarira kutjupa ngapartji piṟuku tjukurmanu nyanga alatji, panya ukiṟi mai wiita ngaṟangi miṉa 7-tjara mai uṉinypa puḻkatjara. Ka mai uṉinypa panya paluṟu tjana piḻṯiringkula wiṟu ngaṟangi urantjaku. Ka palula maḻangka ukiṟi panya palulaṯu miṉa 7 kutjupa piṟuku pakaṉu mai uṉinypa kurakuratjara kutju-kutjutjara panya waḻpa waṟungku kampara kurantja. ");
INSERT INTO pjt_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ka mai panya kuḻingku kampara kurantjitjangku mai panya ngaṉmanypa puḻka pakantja ngalkula wiyaṉu. Alatjiṉa nyangu, munuṉa tjukurmankunytjatjanungku ngayuku wati nintipuka tjuṯa aḻṯira tjakultjunu. Kaya puṯu kuliningi ngayula utiṟa wangkanytjikitjangku.” ");
INSERT INTO pjt_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","27","Ka Josephalu kulintjatjanungku Piiṟala wangkangu, “Uwa, nyuntun kutjara-aṟangku tjukurmanu. Munu aṟa pala palula pulalanguṟu kulinma tjukurpa kutju nyanga alatji, Godalu nyuntula nintini ngula nyaaringkunytjaku. Panya nyuntu puluka 7 nyangu kaṉpi puḻka tjuṯa. Munun palu puṟunypaṯu nyangu ukiṟi mai 7-tjara mai panya puḻkatjara. Nyanga aṟa kutjaranguṟu kulinma kuḻi nyiṉnga 7 ngaṟakatiku mina puḻka mai puḻka itjanu puḻka mulapa. Palu kutjupa nyuntu nyangu puluka nyurka-nyurka 7. Munun palu puṟunypaṯu nyangu ukiṟi mai 7-tjara mai uṉinypa kurakuratjara kuḻingku kampara kurantja. Nyara aṟa kutjaranguṟu kulinma kuḻi nyiṉnga 7 kura ngaṟaku ailuru puḻka, nyara yiya panya palya tjuṯa ngaṟakatinytjala maḻangka. ");
INSERT INTO pjt_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Nyangatjaṉa mulapa wangkanyi, Piiṟa, panya Godalu nyuntula nintini ngula nyanga alatjirinytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","“Palu panya kuwari nyanga nganaṉa manta nyanga Itjipala winkingka pukuḻpa nyinaku mai puḻkatjara yiya 7. ");
INSERT INTO pjt_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","31","Nyara palula maḻangka yiya palya tjuṯa ngaṟala wiyaringkunyangka yiya panya 7 kutjupa ngaṟaku ailuru puḻkalta. Ka manta piḻṯiringkunyangka mai wiya ngaṟaku. Kala ailuru puḻkangku manta winki kurannyangka paḻtjatjiratja nyinaku tjituṟu-tjituṟu mulapa. Munula mai panya puḻkangka ngaṉmanypa nyinanytjitjaku watarkuriku alatjiṯu. ");
INSERT INTO pjt_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","“Ka nyuntu panya kutjara-aṟa tjukurmanu panya kutju pulukatjara munu kutjupa mai wiitatjara. Pala palula pulalanguṟu tjukurpa kutjuringu, panya kuwariṉanta utiṟa wangkangu yiya palya tjuṯa ngaṉmanypa ngaṟaku munu palula maḻangka yiya kura tjuṯa ngaṟaku. Ka nyuntu tjukurpa kutjara tjukurmankunytjatjanungku alatji kulinma, ‘Munta mulapa nyangatja Godalu palyalku kuwari nguwanpa.’ Paluṟunta mulamulangku nintini tjukaṟurungku.” Alatji Josephalu utiṟa wangkangu mayatja Piiṟala. ");
INSERT INTO pjt_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","35","Munu palulanguṟu piṟuku wangkangu Piiṟala, “Mai wiyaringkunytjaku-tawara-puṯa ngaṉmanytju wati kutjupa ngurkantara nintipuka puḻkanya, uwankaraku ninti. Munu palunya tjura mayatja nyuntula itingka nyinanytjaku ngura nyanga Itjipaku mayatjarira mai purkaṟangku aṯunymankunytjaku. Munu wati mayatja tjunkula wati waṟka kutjupa tjuṯa kuḻu tjura wati nyara paluṟu tjananya wituwituntjaku. Munu tjanala wangka alatji, ‘Kuḻi palya tjuṯa ngaṟanyangkalpi wati paamatjara tjuṯakutu ara munuya mai uṉinypa urannyangka nyakula tjara tjukutjuku mantjiṟa kati wati mayatjaku tjuwa puḻkangka mai ngaripaingka tjunkunytjikitjangku ailuru panya puḻkaku paṯaṟa. Nyanga alatji paama uwankaranguṟu mai tjaraṟa mantjila kuḻi kutjupa kuḻi kutjupa yiya panya 7-kutu-wangkara. Munu mai tjunkula aṯunymaṟa anga-kanyinma kutjupangku kutitjunkunytjaku-tawara.’ Alatji tjanala wangka. ");
INSERT INTO pjt_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Ka mai paluṟu tjana paṯaṟa ngariku ngulaku ailuru puḻkaringkunyangka ngalkuntjaku. Alatji nyuntu palyannyangkampa aṉangu tjuṯa paḻtjatjiratjariwiya nyinaku, wanka tiṯutjara.” Alatji Josephalu tjakultjunu mayatja panya Piiṟala paluṟu kulintjaku. ");
INSERT INTO pjt_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","38","Ka mayatja Piiṟalu tjana wati kuranyitja tjuṯangku kuḻu kuliṟa pukuḻaringu Josephalu tjanala alatji tjakultjunkunyangka munuya palyanmanu. Munu Piiṟalu tjanala wangkangu, “Palu Josephanyampa wati wiṟu mulapa. Nyanga paluṟu alatjiṯu Godaku kuruntjara wati palya. Utila nyanga palunya tjunkuku, panya wati nyanga palu puṟunypala kutjupa puṯu ngurkantankuku, palu Josephanya kutju wiṟu mulapa.” ");
INSERT INTO pjt_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","40","Palulanguṟu Piiṟalu Josephala wangkangu, “Nyangatja mulapa panya Godalu nyuntula nintinu uwankara. Palulanguṟula uti kulini nyuntu panya ninti puḻka mulapa kutjupa uwankarangka waintarira nyinanyi. Kaṉa kuwari nyuntunya mayatja puḻka tjunanyi ngayula maḻangka, ka nyuntu mayatjarira ngayuku ngura kanyilku. Kaya aṉangu Itjipanya nguraṟa uwankarangku nyuntula wangaṉarangku kulilku, ka ngayulu kutju nyuntumpa mayatja nyinaku. ");
INSERT INTO pjt_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Uwa, kuwari nyuntu ngura nyanga Itjipaku mayatja puḻka nyinanyi aṉangu winkiku.” ");
INSERT INTO pjt_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Munu palulanguṟu Piiṟalu Josephanya mayatja tjunkula maṟanguṟu ringi araṟa Josephala maṟangka tanpaṉu. Ringi nyanga paluṟu panya mayatja puḻkangku kutju kanyilpai. Munu palunya ungu tjarpanytjaku mantara wiṟu mulapa. Munu liringka kuḻu tjunu nikilitja gold-nguṟu palyantja wiṟu mulapa aṉangu tjuṯangku panya liritja kanyinnyangka nyakula mayatja ngurkantankunytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Palulanguṟu Piiṟalu Josephanya ungu tjinka wiila kutjaratjara panya mayatja tatiṟa para-ngaṟapai. Munu paluṟu kuranyuringu tjinka palumpangka, ka Josephalu palumpa tjinkangka tatiṟa maḻawanungku waṉaningi. Ka Piiṟaku wati tjaultji tjuṯangku kuranyu ankula aṉangu tjuṯangka mirara wangkangi, “Wati-kitikitiriwaya aḻangka pula ankunytjaku.” Alatji pula anangi aṉangu tjuṯangku mirara Josephanya mayatja kulintjaku, “Ngangarku! Nyawaya mayatja kuwaritjaṟara pala pula Piiṟanya para-ngaṟanyi.” Alatjiya nyakula kuliningi Piiṟalu panya Josephanya ngura Itjipaku manta winkiku mayatja tjunkunyangka. ");
INSERT INTO pjt_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Ka Piiṟalu palula wangkangu Josephala, “Ngayuluṉa mayatja puḻka mulapa, palu nyuntu mayatja ngayula ititja munun aṯunymaṟa kanyilku uwankara ngura Itjipala. Kaya aṉangu tjuṯangku nyuntula kulilku wangaṉarangku.” ");
INSERT INTO pjt_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Munu Piiṟalu ini kutjupa tjunu Josephanya ini Itjipanya nguraṟa panya “Tjapina Paniyanya”. Munu palunya kungkawaṟa kuri ungu ini Atjinatjanya. Paluṟu panya wati tjukurtjaraku uṉṯalpa wati panya ini Patipaṟaku ngura panya Anannga nguraṟaku. ");
INSERT INTO pjt_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Nyanga palula-aṟangka panya Josephanya yangupala yiya nampa 30 iṯinguṟu nyinanytjatjanu. Munu paluṟu mayatjarira Piiṟaku ngura wantikatira anu ngura kutjupa kutjupa tjuṯa para-nyakunytjikitja manta pala Itjipala. ");
INSERT INTO pjt_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Ka kuḻi panya palya tjuṯa ngaṟakatinyangka mai puḻka mulapa pakaningi paama tjuṯangka Itjipala yiya kutjupa yiya kutjupa. ");
INSERT INTO pjt_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Ka Josephalu wati waṟkaripai tjuṯa wangkangu mai uṉinypa paama tjuṯanguṟu mantjintjaku, kaya mantjiṟa katira tjunangi waḻi panya puḻka tjuṯangka ngura tjuṯatja. ");
INSERT INTO pjt_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Paluṟu tjana mai panya puḻka mulapa mantjiṟa piti tjuṯangka katira tjunangi paama kutjupa kutjupa tjuṯanguṟu. Ka Josephalu panya piti maitjara tjuṯa katira tjunkunyangka ngaṉmanytju kantamilaningi. Palu tjana ngura tjuṯanguṟu winki mulapa ngalya-katingi, ka pakuringkula wantingu puṯu kuliṟa. ");
INSERT INTO pjt_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Ka ailururingkunytja kuwaripangka Josephaku kuringku Atjinalu katja kutjara kanyinu. ");
INSERT INTO pjt_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Ka Josephalu katja inintjikitjangku wangkangu, “Ngayulu panya ngura nyangaku pitjangu walytja tjuṯanguṟu kawankatira, ka panyaṉiya tjailangka tjarpatjunu wiyanguṟu alatjiṯu. Palu palya, panya Godaluṉi tjailanguṟu pakaltjingaṉu munuṉi pukuḻmanu, kaṉa watarkuringu ngayulu panya kurangka ngaṉmanypa nyinanytjitjaku, munuṉa walytja tjuṯaku kuḻu watjilarinytja wiyaringu. Palulanguṟuṉa kuwari katja nyanga ngaṉmanyitja inilku ‘Manatjanya.’” ");
INSERT INTO pjt_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Munu piṟuku katja maḻatja inintjikitjangku alatji wangkangu, “Ngura nyanga palula panya ngayunya tjailangka tjarpatjunu watjilpa nyinanytjaku. Palu palya, panya Godaluṉi ngayunya katja kutjara ungu. Palulanguṟuṉa katja nyanga maḻatja inini Ipuṟaimanya.” ");
INSERT INTO pjt_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Palulanguṟu yiya panya palya tjuṯa mai puḻkatjara ngaṟala wiyaringu. ");
INSERT INTO pjt_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Ka ailururingulta. Munu ailuru puḻka mulapalta ngaṟangi rawa yiya 7. Panya Josephalu ngaṉmanytju wangkanytjitja mulapaṯu utiringu. Ka ailuru panya paluṟu manta Itjipala kutju wiya ngura aḻa lipingka ngaṟangi. Palu Itjipalaya mai puḻkatjara nyinangi ngaṉmanytju uṯuḻuṟa tjunkunytjatjanu panya waḻi puḻka tjuṯangka. ");
INSERT INTO pjt_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","56","Ka ailuru panya paluṟu puḻka mulararingu, ka paama winkingka mai wiyaringu ngura Itjipala munu ngura kutjupa uwankarangka kuḻu. Kaya Itjipanya nguraṟa tjuṯangku paḻtjatjiratjarira pitjala puḻkaṟa ngatjiningi Piiṟala maiku. Ka paluṟu wangkangu, “Ankulaya Josephala tjapila munuya paluṟu wangkanyangka kulinmaṯu.” Kaya ankula tjapiningi Josephala. Ka Josephalu aḻaṉu waḻi panya puḻka tjuṯa maitjara panya, munu tjananya ungangi manikitjangku Itjipanya nguraṟa tjuṯa. ");
INSERT INTO pjt_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Kaya aṉangu kutjupa tjuṯa kuḻu rawa pitjangi ngura panya kutjupa tjuṯanguṟu Itjipalakutu mai Josephala payamilantjikitja, panya ailuru manta winkingka ngaṟanyangka. ");
INSERT INTO pjt_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Palu Josephaku mama, tjiḻpi panya Jacobanya ngura panya Kainanta nyinangi katja panya tjuṯatjara. Ka ngura nyara palula kuḻu ailuru puḻka mulapa ngaṟangi. ");
INSERT INTO pjt_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Ka Jacobalu kulinu ngura panya Itjipala mai puḻka ngarinytja munu katja tjuṯangka wangkangu, “Awai! Nyaakula nyangatja kawaṟurira nyinara puṯu kulini? Wanyuya ara ngura Itjipalakutu. Nyara palula kunyu mai puḻka ngarinyi. Ankulaya payamilala. Palu kuwarila ngura nyangaku mukuringkula nyinara mai wiyangka uwankara ilunyi.” ");
INSERT INTO pjt_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","4","Kaya palulanguṟu mamangku wangkanyangka kulinu Josephaku panya kuṯa tjuṯangku, munuya anu Itjipalakutu wati panya 10-pa. Palu Josephaku maḻanypa Pintjimannga Jacobalu markuṉu, panya paluṟu ngurangka kanyintjikitja mukuringangi katja panya maḻatja kutjupangku pungkunytjaku-tawara. ");
INSERT INTO pjt_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Kaya kuṯa tjuṯa aṉangu kutjupa tjuṯangka tjunguringkula anu Itjipalakutu maikitja, munuya rawa ankula ngula wirkanu ngura panya palula. ");
INSERT INTO pjt_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","8","Ka Josephanya panya Itjipaku mayatja nyinangi, kaya aṉangu tjuṯangku maiku mukuringkula palulawanungku kutju payamilalpai. Kaya Josephaku kuṯa tjuṯangku palula wirkaṟa pupakatira ngalyangku manta pampuṟa mayatjanmanangi. Palu tjana palunya ngurkantankunytja wiya alatjiṯu kuliṟa wati Itjipanya nguraṟa-palku. Ka Josephalu kutju palumpa kuṯa tjuṯa mapalku ngurkantanu, munu paluṟu tjanala wangkanytja wiya ngaṟangi wati malikitja puṟunypa. Munu paluṟu tjananya mirpaṉ-mirpaṉṯu tjapinu, “Ai, nyura ngura nganalanguṟu pitjangu?” Kaya wangkangu, “Ngura Kainantanguṟula pitjangu mai payamilantjikitja.” ");
INSERT INTO pjt_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Palu Josephanya tjanampa ninti munu pupakatinyangka nyakula kuliningi, “Panya ngayuluṉa iritilpi mai wiita tjukurmaṟa tjakultjunangi nyanga alatjirinytjaku.” Munu alatji kuliṟa wangkangu, “Nyura tjinguṟu nguntinytjurira pitjangu maikitja-palku ngura nyangatja para-nyakula maḻaku ankula nyurampa mayatjangka wangkara warmaḻarira nganaṉanya pitjala pungkunytjikitjampa.” ");
INSERT INTO pjt_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Kaya kuṯa panya tjuṯangku nguḻu-nguḻungku wangkangu, “Wiya, nganaṉa pitjangu nyuntula mai payamilantjikitja kutju. ");
INSERT INTO pjt_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Nganaṉa uwankara kuṯaṟara kuṯaṟara mama kutjutja, munula kura nyanga puṟunypa kulilpai wiya palyanyku nyinapai.” ");
INSERT INTO pjt_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Ka Josephalu piṟukuṯu wangkangu, “Wiya, nyura pitjangu ngura nyanga nganampa para-nyakula ankula ngula warmaḻarira maḻaku pitjala nganaṉanya pungkunytjikitja.” ");
INSERT INTO pjt_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Kaya paluṟu tjana piṟuku wangkangu, “Wiya! Nganaṉa nyanga alatji-alatjiṯu nyinanyi kuṯaṟara kuṯaṟara mama kutjutja ngura panya Kainanta. Panya ngaṉmanypala nyinangi 12, ka nganampa maḻanypa kutjupa ngaṉmanypa wiyaringu, kalampa maḻanypa maḻatja kutju ngurangka nyinanyi mamangka.” ");
INSERT INTO pjt_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Ka piṟuku Josephalu wangkangu, “Wiya, panya ngaṉmanytjuṉa wangkangu nyurala nguntinytjurira pitjanytja. Nyura tjinguṟu pitjangu nganampa manta nyakunytjatjanungku ankula ma-wangkara maḻaku pitjala nganaṉanya pungkunytjikitja. ");
INSERT INTO pjt_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Tjinguṟu nyura tjukaṟurungku wangkanyi, munta tjinguṟu nyura ngunti wangkanyi, palu arkaṉiṉa nyuranya kuwari. Panya nyura wangkangi nyurampa maḻanypa ngurangka nyinanytja. Ka paluṟu ngura nyangaku pitjanyangka kutjuṉa nyakula mulamularingkuku. Palulanguṟu kutjuṉa nyuranya wantir'iyalku ankunytjaku nyurampa ngurakutu. Mulamulangkuṉa nyurala wangkanyi, panya mayatja Piiṟaluṉi tjunu mayatja ngura nyangaku. Ka nyura nyinara paṯanma ngura nyangangka nyurampa maḻanypa pitjanytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Kaṉa kutju nyuralanguṟu wangkara iyalku palunya ankula mantjiṟa ngalya-katinytjaku. Palu nyura kutjupa tjuṯa nyinaku tjailangka unngu paṯaṟa, munu nyurampa maḻanypa wirkankunyangka kutju pakalku. Ka paluṟu pitjanyangka kutjuṉa nyuranya kulilku tjukaṟurungku wangkanytja. Palu paluṟu pitjanytja wiyangkampaṉa nyuranya ngukalku nguntinytjurira ngura nyangaku pitjanytja. Alatjiṉa mulapa kulilku paluṟu pitjanytja wiyangka.” ");
INSERT INTO pjt_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","19","Munu palulanguṟu Josephalu tjananya tjailangka tjunu. Kaya nyara palula tjiṉṯu maṉkurpa nyinangi. Ka Josephalu tjiṉṯu maṉkuritjangku pitjala tjanala wangkangu, “Ngayuluṉa panya Godanya kuliṟa waḻkulpai munuṉa nyurampa ngaḻṯuringanyi. Palu nyurampa maḻanypa ngayulakutu ngalya-katinyangkampaṉa nyuranya pungkuwiyangku wantiku.” Munu paluṟu piṟuku kampa kutjupaṟa wangkangu wati kuṯa kutju nguṟuritja tjailangka kanyintjikitjangku. Munu tjananya kutjupa tjuṯa wangkangu, “Palyaya ma-kati mai panya nyura payamilantja walytja tjuṯakutu paḻtjatjiratja nyinanyangka paḻtjantjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Munuya palula maḻangka nyura wati panya nyurampa maḻanypa ngalya-kati ngayulakutu. Kaṉa palunya nyakula mulapa kulilku nyura panya wangkanytja, munuṉa palulanguṟu nyuranya pungkuwiyangku wantiku, munuṉa wati panya tjailangka nyinanytjanya pakaltjingalku.” Kaya paluṟu tjana kuliṟa uwanmanu. ");
INSERT INTO pjt_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Munuya Josephaku wangka kuliṟa tjananku wangkangi wangka tjanampangku nyanga alatji, “Munta-uwa panya nganaṉa iritilpi nganampa maḻanypa wati kutjupa tjuṯangka tjalamilaṉu, ka tjinguṟu palulanguṟu Godalu nganaṉanya wantir'iyaṉi alatjirinytjaku. Panya iriti Josephalu nganaṉanya alpamilantjaku puṯu wangkangi, kala kuliṟa wantingi munula ngaḻṯuringkunytja wiyangku ungu. Ka palula maḻangka wiyaringu, ngaḻṯutjara. Kalanya aṟa panya palulanguṟu tjinguṟu Godalu kuwari wantir'iyaṉi.” ");
INSERT INTO pjt_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ka kuṯa puḻkangku Rupintu wangkangu, “Panya puṯuṉa nyurala wangkangu pungkuwiyangku wantinytjaku, ka nyura ngayunya kulilwiyangku alatjiṯu wantingu. Kala nyangatja nganampa ngapartjilta utiringanyi nganaṉa ngapartji ilunytjaku.” ");
INSERT INTO pjt_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Nyanga alatjiyanku wangkangi Josephala miṟangka wangka ngurpangka-palku. Panya Josephalu wati kutjupawanungku tjanala wangkangi wangka Itjipanya nguraṟangku, ka wati paluṟu ngapartji tjanala tjakultjunangi wangka tjanampangku. Palu Josephalu tjananya kulinu uwankara tjana irititja kuliṟa wangkanyangka, kayanku watarkungku ngaṟala alatjiṯu wangkangi Josephala wangka ngurpangka-palku. ");
INSERT INTO pjt_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Ka paluṟu kuliṟa nyakunytjaku-tawara tjukutjuku ma-paṯuringkula ulangi. Munu palula maḻangka ulara wiyaringkula maḻaku pitjala wati tjaultjingka wangkangu palumpa kuṯa ini Tjimiyannga witiṟa ruupangka karpintjaku. Ka Rupinta tjanala miṟangka paluṟu Tjimiyannga karpiṟa tjailangka katira tjarpatjunu, panya kuṯa kutjupa tjuṯa ankunyangka maḻaringkula nyinanytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Palula maḻangka Josephalu palumpa waṟka tjuṯangka wangkangu palumpa kuṯa tjuṯaku yakutja tjuṯa mantjiṟa mai panya uṉinypa yakutjangka tjaalyngaṟatjunkunytjaku. Munu piṟuku wangkangu mani panya kuṯa tjuṯangku maiku ungkunytja kampangkaṯu maḻakungku yakutjangka tjarpatjunkunytjaku maingka tjungu. Munu mai kutjupa antjakiku kuḻu tjunkunytjaku wangkangu tjanampa. Kaya mulapa waṟka tjuṯangku alatjiṉu. ");
INSERT INTO pjt_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Kaya kuṯa tjuṯangku yakutja panya maitjara tjuṯa tangkiyingka utitjuṟa karpi-karpiṟa ma-pakaṉu. ");
INSERT INTO pjt_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Munuya ankula mungartjirira ngura tjunu. Ka kuṯa kutjungku yakutja kutju araltjanu tangkiyi mai ungkunytjikitjangku. Munu aḻaṟa nyangu mani panya paluṟu mai payamilantja maingka katu ngarinyangka. ");
INSERT INTO pjt_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Munu nyakula urulyaraṟa wangkangu, “Pitjalaya nyawa. Mani panya ngayulu mai payamilantja nyangatja ngarinyi yakutjangka.” Munuya kuṯa panya tjuṯa kuliṟa kurunpa tjituṟu-tjituṟuringu munuya wati panya Itjipaku mayatjaku puḻkaṟa nguḻu-nguḻuringkula wangkangi, “Nganaṉa panya mai nyangatja payamilaṉu mani nyangangka, ka nyaaku mani nyangatja maḻakungku ungu?” Munuyanku wangkara puṯu kuliṟa tjapiningi, “Nyaaku Godalu nganaṉanya rawangku wantir'iyaṉi?” ");
INSERT INTO pjt_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Munuya ngarira tjiṉṯuringkula ma-pakaṉu ngura Kainantakutu. Munuya ankula ankula ngurangka wirkanu palumpa tjanampa mamangka. Munuya palula tjakultjunu uwankara nyanga alatji, ");
INSERT INTO pjt_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Nganaṉa panya ankula ma-wirkanu wati Itjipaku mayatjangka. Kalanya mirpaṉ-mirpaṉṯu puntuṟa wangkangi, ‘Nyura tjinguṟu nguntinytjurira pitjangu ngura nyangaku.’ ");
INSERT INTO pjt_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Kala wangkangu, ‘Wiya, nganaṉa nguntinytjurira pitjanytja wiya. Nganaṉa wati palya tjuṯa, tjukaṟuru nyinapai. ");
INSERT INTO pjt_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Nganaṉa nyanga alatji nyinanyi kuṯaṟara kuṯaṟara mama kutjutja ngura panya Kainanta. Panya ngaṉmanypala nyinangi 12, ka nganampa maḻanypa kutjupa ngaṉmanypa wiyaringu, kalampa maḻanypa maḻatja kutju mamangka nyinanyi ngurangka.’ Alatjila wangkangi wati panya mayatja palula. ");
INSERT INTO pjt_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Ka nganaṉa wangkanyangka paluṟu kuliṟa puṯu mulamularingangi munu alatji wangkangu, ‘Kuwariṉa nyuranya arkaṉi. Tjinguṟu nyura ngunti wangkanyi, tjinguṟu nyura mulamulangku wangkanyi. Palu kutju uti nyuralanguṟu ngayula nyinama, kaya mai mantjiṟa ma-kati nyurampa walytja tjuṯakutu panya tjana tjinguṟu paḻtjatjiratja nyinanyi. ");
INSERT INTO pjt_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Palulanguṟu nyurampa maḻanypa panya maḻatja mulapa ngayulakutu ngalya-kati. Ka nyura katinyangka kutju ngayulu nyuranya wati tjukaṟuru kulilku, munuṉa palulanguṟu wantir'iyalku nyurampa panya kuṯa tjailangka nyinanytja nyurala tjungu ankunytjaku. Ka nyura palya ngura Itjipala nyinara mai payamilalku ngurakutu katinytjikitjangku.’ Nyanga alatji nganaṉala wangkangi wati panya Itjipaku mayatjangku.” ");
INSERT INTO pjt_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Palulanguṟuya yakutja panya maitjara tjuṯa mantjinu piṯi puḻka mai ngaripaingka aḻaṟa tjutintjikitjangku. Munuya kutju kutjungku aḻaṟa nyangu mani panya paluṟu tjana mai payamilantja maingka katu ngarinyangka. Munuya nyakula puṯu kuliṟa mama kuḻu puḻkaṟa nguḻuringangi. ");
INSERT INTO pjt_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ka mamangku kuliṟa tjanala wangkangu, “Nyaaku nyura mukuringanyi ngayuku tjitji tjuṯa kawalinkuntjikitja? Panya ngaṉmanypa Josephanya ankula wiyaringu, ka Tjimiyannga kuwari wiyaringu, ka nyura kuwari mukuringanyi Pintjimannga ma-katinytjikitja. Kaṉa ngayulu ngaḻṯutjara puḻkaṟa tjituṟu-tjituṟurinyi.” Alatji Jacobalu wangkangi. ");
INSERT INTO pjt_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ka kuṯa panya puḻkangku Rupintu wangkangu mamangka, “Ngayunyaṉi Pintjimannga ungkul'iyala, kaṉa puḻkaṟa aṯunymanama munuṉa ngula maḻakungku ngalya-kati nyuntulakutu. Palu ngayulu maḻakungku katinytja wiyangkampan ngayuku katja kutjara palya iluntananyi.” ");
INSERT INTO pjt_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ka Jacobalu wangkangu, “Wiya, ngayulu ngayuku katja nyuntula puṯu iyaṉi, panya palumpa kuṯa ngunytju kutjutja ngaṉmanypa wiyaringu, ka nyangatja paluṟu kuwari kutju nyinanyi. Kaṉa palulanguṟu puṯu ma-iyaṉi ankunytjaku kutjupangku pungkunytjaku-tawara. Panya ngayuluṉa tjiḻpi mulapa munu nyanga paluṟu ankula ilunyangkaṉa puḻkaṟa tjituṟu-tjituṟurira iluku.” ");
INSERT INTO pjt_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Palu ngura pala palula ailuru puḻka rawa ngaṟangi. ");
INSERT INTO pjt_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Kaya mai panya Itjipalanguṟu katinytjitja ngalkula wiyaṉu, ka ailuru panya ngaṟangi alatjiṯu. Ka mai wiyaringkunyangka Jacobalu katja panya tjuṯangka wangkangu, “Araya piṟuku ngura nyara Itjipalakutu mai payamilantjikitja munuya mantjiṟa ngalya-kati.” ");
INSERT INTO pjt_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Ka katja kutjungku Judah-lu wangkangu, “Uti nganaṉa nganampa maḻanypa maḻatja Pintjimannga ma-katima. Panya Itjipaku mayatjangkulanya wangkangu alatji, ‘Nyurampa maḻanypa panya maḻatja katiwiyangku wantinyangkaṉa nyuranya piṟuku mai ungkunytja wiyangku wantiku.’ ");
INSERT INTO pjt_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ka nyuntu nganampa maḻanypa nganaṉala iyannyangka kutjula palya ankula mai nyuntumpa payamilalku. ");
INSERT INTO pjt_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Palu nyuntu iyalwiyangku wantinyangkala wantira nyinanyi, panya wati mayatjangku wangkangu nganaṉala, ‘Nyura nyurampa maḻanypa ngalya-katiwiyangku wantira ngayula puṯu ngatjini maiku.’” ");
INSERT INTO pjt_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Ka Jacobalu wangkangu, “Nyaaku nyura wanyu tjakultjunangi nyurampa maḻanypa wati nyara mayatja palula? Uti nyura wantima wangkawiyangku. Nyura tjakultjunkunytjanguṟu nyarangku aḻṯingu nyangatja nyura ma-katinytjaku. Kaṉa puḻkaṟa kuliṟa tjituṟu-tjituṟurinyi.” ");
INSERT INTO pjt_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Kaya wangkangu, “Wiya, paluṟu nganaṉala rawangku tjapiningi wangkanyangka kuliṟa nintiringkunytjikitjangku. Nyanga alatji tjapiningi, ‘Nyurampa mama nyinanyi? Ka nyurampa maḻanypa kutjupa nyinanyiṯu?’ Kala palula watarkungkuṯu tjakultjunu. Panya nganaṉa ngaṉmanytju kulintja wiyaṯu paluṟulanya maḻanypa katinytjaku wangkanytja. Palu nganaṉa tjakultjunkunyangka kutju wangkangu maḻanypa katinytjaku.” ");
INSERT INTO pjt_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","9","Ka Judah-lu wangkangu mamangka, “Wiya, Pintjimannga ngayunya ungkul'iyala, kaṉa ngayulu aṯunytju kanyinma munuṉa wankaṟu maḻakungku ngalya-katiku. Palu wiyangkampa ngayuku tiṯutjara mirpaṉpa nyinama. Ala, kuwariṯulanya wanyu ungkul'iyala, kala mapalku ara maiku nyuntu nganaṉa uwankara mai wiyangka ilunytjaku-tawara. ");
INSERT INTO pjt_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Panya nganaṉa rawa paṯaṟa nyinangi maiku ankunytja wiyaṯu. Tjinguṟula ngaṉmanytju ungkul'iyannyangkampa ngura iriti ankula mai mantjiṟa ngalya-katima, munula piṟukuṯu ankula mantjiṟa ngalya-katima.” ");
INSERT INTO pjt_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ka palulanguṟu Jacobalu kuliṟa wangkangu, “Uwa, tjinguṟu palya Pintjimannga kati. Palu ngura nyanganguṟu kutjupa kutjupa tjuṯa kati kiṯi munu tjuratja munu tjau munu mai taṯu, kutjupa kutjupa tjuṯa kuḻu. Munu katira mayatja panya palunya pukuḻmankunytjikitjangku ma-uwa. ");
INSERT INTO pjt_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Munu mani panya yakutjitja kuḻu maḻakungku katira ma-uwa. Tjinguṟu nyarangku ngunti tjunu mani panyatja. Munu piṟuku mani nyanga kutjupa kati mai kutjupa payamilantjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Palyaya warpungkula ara, munuya Pintjimannga kuḻu ma-kati mayatja panya palulakutu. ");
INSERT INTO pjt_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Ka ngayulu kuwari Godala tjapini mayatja nyara palumpa nyurampa ngaḻṯuringkunytjaku. Ka palulanguṟu tjinguṟu ngaḻṯuringkula Pintjimannga pulanya Tjimiyannga ngayulakutu maḻakungku iyalku nyurala tjungu. Palu tjinguṟu pula nyurala tjungu pitjanytja wiyangkampa ngayulu ngaḻṯutjara katja-tjiratja puḻkaṟa tjituṟu-tjituṟuriku.” ");
INSERT INTO pjt_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Kaya palulanguṟu katja tjuṯangku kutjupa kutjupa panya Kainannga nguraṟa tjuṯa mantjiṟalta ma-pakaṉu ngura panya Itjipaku mani puḻkatjara, munuya Pintjimannga kuḻu katingu. Munuya rawa ankula wirkanu ngura nyara palula munuya Josephala pupakatira mayatjanmanu kuliṟa wati Itjipanya nguraṟa-palku. ");
INSERT INTO pjt_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Ka Josephalu Pintjimannga tjanala tjungu ngaṟanyangka nyakula wangkangu wati waṟka panya palumpa waḻi kanyilpaingka, “Wati nyanga tjananya kati ngayuku waḻikutu. Munu kuka pungkula paula, panya kaḻaḻa nyanga kuwari ngayulu ma-pitjala tjanala tjunguringanyi mai kuka ngalkuntjikitja.” ");
INSERT INTO pjt_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ka palulanguṟu wati waṟka paluṟu tjananya katingu Josephaku waḻikutu. ");
INSERT INTO pjt_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Palu tjana katinyangka nguḻuringu panya alatjiya kulinu puḻkaṟa, “Nyaakulanya palumpa waḻikutu nyangatja iyaṉu? Mani panyanguṟu-mantilanya. Paluṟu tjinguṟu alatji kulinu nganaṉa kutitjuṟa katinytja-palku panya yakutja tjuṯatja. Palulanguṟulanya kuwari pitjala mirpaṉarira wangkaku munu tangkiyi tjuṯa nganampa mantjiṟa ma-katiku. Munulanya tjunkuku palumpa rawa waṟkarinytjaku mani wiyakitja unytju kutju.” ");
INSERT INTO pjt_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","20","Munuya alatji kuliṟa waḻi panya palula wirkaṟa uṟilta ngaṟakatira wangkangu wati panya Josephaku waṟkangka, “Wati wiṟu, wanyu ngaṟala kulila. Panya mungaṯula ngura nyangaku pitjangu mai payamilantjikitja, munula mani ungkula mai mantjiṟa maḻaku anu. ");
INSERT INTO pjt_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Munula ankula nguṟurpa ngarira yakutja maitjara tjuṯa aḻaṟa nyangu mani panya nganaṉa maiku ungkunytjanya ngarinyangka. Munula kuwari nyanga mani palunya maḻakungku ngalya-katingu nyuntunya ungkunytjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Palu mani kutjupala katingiṯu mai piṟuku payamilantjikitjangku. Palu nganaṉa maingka katu mani ngarinyangka nyakula puṯu kuliningi, ‘Nganalu nyangatja wanyu tjarpatjunu?’” ");
INSERT INTO pjt_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ka wati panya Josephaku waṟkangku wangkangu tjanala, “Wiya palya, nguḻuringkunytja wiyaya! Panya nyurampa mamaku godangku mani panyatja yakutjangka tjunu nyurampa. Ngayulu panyaṉa mantjinu mani panya nyura ngayunya ungkunytja.” Munu palulanguṟu wati panya waṟkangku ankula Tjimiyannga mantjiṟa ngalya-katingu tjailanguṟu, ka paluṟu kuṯangka, maḻanypa tjuṯangka kuḻu tjunguringu. ");
INSERT INTO pjt_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Ka wati paluṟu tjananya tjarpatjunu waḻi unngu munu wangkangu, “Kaḻaḻa kuwari ngayuku mayatjangku pitjala nyurala tjungungku ngalkuṉi.” Munu paluṟu pitingka mina tjutiṉu tjananku tjina paltjintjaku. Munu paluṟu pakaṉu uṟilkutu palumpa tjanampa tangkiyi tjuṯa mai ungkunytjikitja. ");
INSERT INTO pjt_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Kaya paltjiṟa wiyaringkula ngaṉmanytju uraṟa tjunangi kiṯi, tjuratja, tjau, mai taṯu kutjupa kutjupa uwankara Kainantanguṟu katinytjatjanungku Josephanya ungkula pukuḻmankunytjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Munuya pitjanyangka nyakula palulakutu katingu munuya ungkula tultjungaṟakatira ngalyangku manta pampuṟa palunya waḻkuṉu. ");
INSERT INTO pjt_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ka Josephalu tjananya tjapinu, “Palya nyura? Ka nyurampa mama palyaṯu nyinanyi? Panya nyura mungaṯu palunya ngayula tjakultjunangi. Ka paluṟu wanyu wankaṯu nyinanyi?” Alatji paluṟu tjanala ngunti tjapiningi mamaku ngurpangku-palku. ");
INSERT INTO pjt_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Kaya wangkangu palula, “Uwa, nganampa mama wankaṯu nyinanyi pukuḻpa.” Munuya piṟuku tultjungaṟakatira tjaṟu mulapa ngampaḻngaṟala palunya waḻkuṉu. ");
INSERT INTO pjt_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Ka Josephalu nyangu palumpa maḻanypa Pintjimannga panya pula ngunytju kutjutja, munu wangkangu watarkitjangku-palku, “Munta-uwa, nyangatja nyurampa maḻanypa maḻatja panya mungaṯu nyura ngayula wangkangi.” Munu paluṟu Pintjimanta wangkangu, “Godalu nyuntunya pukuḻtjungku kanyinma.” ");
INSERT INTO pjt_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Munu alatji wangkara Josephanya mapalku pakaṟa anu tjananya wantikatira ruuma kutjupakutu palumpa maḻanypaku ulanytjikitja kuṯa tjuṯangku nyakunytjaku-tawara. Panya paluṟu maḻanypaku puḻkaṟa mukuringkupai munu nyakula puḻkaṟa pukuḻarira kuṯa tjuṯangka miṟangka nguwanpa ulangi. ");
INSERT INTO pjt_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Munu ulara wiyaringkula yunpa minangka paltjiṉu tjana ulanytja iḻanypa nyakunytjaku-tawara. Munu wiyaringkula maḻaku pitjala wati panya waṟkangka wangkangu mai kuka kuḻu ngalya-katira taipulangka tjunkunytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Munu Josephalu taipula kutjungka nyinara ngalkuningi kutjungku. Kaya palumpa kuṯa tjuṯangku munu maḻanypa kutjungku kuḻu taipula kutjupangka nyinara ngalkuningi. Kaya Itjipanya nguraṟa tjuṯangku taipula kutjupangka nyinara ngalkuningi, panya tjaka paluṟu tjana aṉangu Iipuṟu tjuṯaku kuraringkupai nguwanpa munuya tjanala mai tjungungku ngalkupai wiya. ");
INSERT INTO pjt_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Palu Josephaku panya waṟkangku tjananya kuṯaṟara kuṯaṟara taipula kutjungka nyinatjuṟa waṉaṉu wanapari wanapari kuṯanguṟu maḻanypakutu. Kaya wanapari wanapari tjunkunyangka nyakula urulyaraṉu puḻkaṟa, “Ai, tjukaṟurungkulanya tjunu kuṯanguṟu maḻanypakutu.” ");
INSERT INTO pjt_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Ka Josephalu palumpa taipulanguṟu mai kuka waina mantjiṟa ungkul'iyaṉu tjanalakutu ngalkula tjikintjaku. Palu paluṟu mai kuka puḻka mulapalta Pintjimanku ungkul'iyaṉu. Alatjiya paluṟu tjana kuṯaṟara kuṯaṟarangku Josephala tjunguringkula ngalkula tjikiṟa paḻtjaringu, munuya puḻkaṟa pukuḻaringu. ");
INSERT INTO pjt_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Ka palulanguṟu Josephalu wati panya waṟka palumpangka wangkangu, “Nyanga tjanampa yakutja tjuṯangka mai uṉinypa panya uraṟa tjaalyngaṟatjura munu mani panya tjana nyuntunya maiku ungkunytjitja maḻakungku tjura yakutjangka unngu maingka katu. ");
INSERT INTO pjt_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Palu ngayuku walpayaṯa wiṟu mantjiṟa maḻanypa maḻatjaku yakutjangka unngu tjura maningka tjungu.” Ka Josephalu alatji wangkanyangka wati panya waṟka paluṟu palyaṉu. ");
INSERT INTO pjt_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Ka mungawinki munga-mungangka Josephalu tjananya tangkiyi tjuṯatjara ma-wantir'iyaṉu ngura panya Kainantakutu maḻaku ankunytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","5","Palu palulanguṟu Josephalu palumpa panya wati waṟka wangkangu, “Warpungkula tjananya waṉaṟa nyawa! Tjinguṟuya nguṟurpa ma-pitjanyi, munu tjanala wangka alatji, ‘Ngayuku mayatja nyurampa mirpaṉarinyi panya nyura palumpa walpayaṯa wiṟu mulapa kutitjuṟa katingu. Panya paluṟu nyurampa wiṟuṟa mulapa tjukaṟurungku palyaṉu, ka nyura nyaaku palunya kuraṉu? Panya walpayaṯa palangka paluṟu kutju tjikilpai. Nyaanguṟu nyura katingu? Walpayaṯa palatja miḻmiḻpa panya kutjupa-aṟa paluṟu walpayaṯa unngu mina nyakula tjukaṟurungku ngurkantankupai ngula kutjupa kutjuparinytjaku, panya paluṟu wati ayinayini. Nyura panya palunya kura puḻka mulapa palyaṉu walpayaṯa palatja katira.’” Alatji Josephalu wituṉu palumpa waṟka ankula tjanala wangkanytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ka wati panya palumpa waṟkangku kuliṟa tjananya waṉaṉu. Munu tjanala waṉaṟa tjunguringkula tjananya tjukaṟurungku wangkangu panya Josephalu wangkanytja uwankara. ");
INSERT INTO pjt_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Kaya kuliṟa rapangku alatjiṯu wangkangu palula, “Wati wiṟu! Nyaanguṟulanyan alatji puntuṟa waṟu-waṟungku wangkanyi? Nganaṉa walpayaṯa palunya kanyintja wiyaṯu. Panya nganaṉa tjukaṟuru nyinapai kura palyalpai wiya. ");
INSERT INTO pjt_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Nyuntu ninti panya nganaṉa mani panya yakutjangka ngarinytjitja Kainantanguṟu maḻakungku katira ungu nyuntunya. Munula nyuntumpa mayatjaku waḻinguṟu gold munu tjiilpa kutitjunkunytja wiya alatjiṯu.” ");
INSERT INTO pjt_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Munuya piṟuku rapangku wangkangu walpayaṯa panyatja kanyintja wiyangku-palku, “Palu tjinguṟu kutjungku walpayaṯa palunya kanyinnyangkampa palya nyuntu palunya pungkula iluntara munu nganaṉanya nyuntumpa rawa waṟkarinytjaku kati.” ");
INSERT INTO pjt_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ka Josephaku waṟkangku wangkangu, “Wiya, kuwariṉa walpayaṯa panyatja nyurampa yakutja tjuṯangka ngurilku. Ka wati panya paluṟu walpayaṯa kanyintjanya kutju ngayuku waṟka nyinaku, ka nyura kutjupa tjuṯa palya ngurakutu ananyi.” ");
INSERT INTO pjt_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Ka palulanguṟuya Jacobaku katja tjuṯangku mapalku tangkiyi tjuṯanguṟu yakutja tjanampa mantjiṟa mantangka tjunkula waṉaṟa araltjanu. ");
INSERT INTO pjt_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Ka wati panya waṟkangku yakutja tjuṯangka nguriningi walpayaṯa panya palunya. Ngaṉmanytju kuṯa puḻkaku yakutjangka puṯu nyangu, munu palumpa maḻanypaku yakutjangka ngapartji puṯu nyangu. Munu puṯu nguriṟa piṟuku palumpa maḻanypaku yakutjangka ngapartji puṯuṯu nyangu. Munu alatji nguriṟa nguriṟa puṯu nyangu maḻanypa tjuṯaku yakutjangka. Munu palulanguṟu maḻanypa panya maḻatja mularku Pintjimanku yakutjangkalta nguriṟa nyakula mantjinu walpayaṯa panya palunya. ");
INSERT INTO pjt_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Kaya kuṯa panya tjuṯa nyakula kawaṟu-kawaṟuringu munuya puḻkaṟa tjituṟu-tjituṟurira mantara tjanampa aṉangitja tjilpirpungu, panya tjakangkuya tjituṟu-tjituṟurira ulytja kaṯantankupai. Munuya puṯu kuliṟa yakutja tjuṯa tangkiyi tjuṯangka maḻakungku utitjuṟa nguṟurnguṟu maḻaku anu waḻi panya palulakutu wati panya Josephaku waṟkangka tjungu. ");
INSERT INTO pjt_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Ka Josephanya ngurangka nyinangi palumpa kuṯa tjuṯa Judah-nya tjana maḻaku wirkankunytjaku paṯaṟa. Kaya mulapaṯu wirkaṟa palunya nyakula kuranyu tultjungaṟakatingu nyakula ngaḻṯuringkunytjaku tjanampa. ");
INSERT INTO pjt_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Ka Josephalu tjananya puntuṟa waṟu-waṟungku wangkangu, “Nyaaku nyura walpayaṯa ngayuku kutitjuṟa katingu. Ngayuluṉa wati ayinayini munuṉa kutjupangku kutitjunkunyangka palunya nintingku puṟunypa ngurkantankupai.” ");
INSERT INTO pjt_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Ka Judah-lu wangkangu, “Wiya, nganaṉa puṯu kulini nyuntula wangkanytjikitjangku. Yaaltjingaṟala wangkaku panya nyuntu nganampa mulamularingkunytjaku? Wiya puṯula wangkanyi. Tjinguṟu Godalu nganaṉanya kura irititjanguṟu pikakutuṉi. Kala uwankara kuwari nyinaku nyuntula rawa waṟkarinytjikitja, paluṟu kutju walpayaṯa kanyintjanya kutju wiya, nganaṉa kuḻu.” ");
INSERT INTO pjt_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Ka Josephalu tjananya wangkangu, “Wiya, uti wati panya walpayaṯa kanyintjanya kutju nyinama munu ngayuku rawa waṟkarima unytju mani wiyakitja. Ka nyura palya ara maḻaku nyurampa mamakutu.” ");
INSERT INTO pjt_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Ka Judah-lu ngalya-ilaringkula tjapiningi Josephanya wati Itjipanya nguraṟa-palku kuliṟa. Alatji paluṟu kuṉṯa-kuṉṯangku tjapiningi, “Mayatja, wiṟun mulapa. Panya nyuntu mayatja Piiṟanya puṟunypa nyinanyi puḻka mulapa. Wanyuṉi kulila mirpaṉarinytja wiyangku kaṉanta tjakultjura. ");
INSERT INTO pjt_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Nyuntu panya mungaṯu nganaṉala tjapinu alatjingaṟa, ‘Nyurampa mama nyinanyi? Maḻanypa kutjupa kuḻu?’ ");
INSERT INTO pjt_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ka nganaṉa wangkangu, ‘Uwa, mama nganampa nyinanyi wati tjiḻpi munu paluṟu ma-kanyini nganampa maḻanypa maḻatja panya tjiḻpiringkula wiyakutu utintja. Ka kuṯa palumpa ngunytju kutjutja iriti wiyaringu, ka palulanguṟu kutju nyinanyi ngunytju kutjutja. Ka Mamanya palumpa puḻkaṟa mukuringanyi.’ ");
INSERT INTO pjt_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Ka palulanguṟu panya alatji tjakultjunkunyangka nyuntu wangkangu nganaṉanya palunya ngalya-katira nyuntula nintintjaku. ");
INSERT INTO pjt_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Kala wangkangu panya, ‘Wiya, tjinguṟu paluṟu palumpa mama puṯu wantikatira pitjaku. Tjinguṟu paluṟu mama wantikatinyangkampa maḻangka Mamanya iluku.’ ");
INSERT INTO pjt_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ka nyuntu panya wangkangu, ‘Wiya, ngalya-kati alatjiṯu. Nyura palunya ngalya-katinytja wiyangka ngayulu nyuranya piṟuku mai ungkunytja wiya. Palu palunya nyakula kutjuṉa nyuranya mai ungkuku.’ ");
INSERT INTO pjt_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Kala kuliṟa panya maḻaku anu Mamalakutu munula palula tjakultjunu. ");
INSERT INTO pjt_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Ka ngula Mamalulanya wituṉu Itjipalakutu ankula mai piṟuku payamilantjaku. ");
INSERT INTO pjt_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Kala wangkangu palula, ‘Wiya, puṯula ananyi Pintjimannga wiyangka panya mayatjangku nganaṉanya mai ungkunytja wiya palunya katinytja wiyangka. Palu nyuntu Pintjimannga nganaṉala tjungu wantir'iyannyangkala palya ankuku.’ ");
INSERT INTO pjt_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Kalanya mamalu tjituṟu-tjituṟurira wangkangu, ‘Nyura ninti panya ngayuku kuringku Raitjiltu katja kutjara kutju kanyinu ngayuku. ");
INSERT INTO pjt_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Ka kutju panya ankula wiyaringu. Tjinguṟu kuka inuṟa pikaṯingku palunya patjaṟa wilypanpungkula ngalkula wiyaṉu panya ngayulu palunya piṟuku nyakunytja wiya. ");
INSERT INTO pjt_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Kaṉa yaaltjiriku maḻatja nyanga paluṟu nyurala piṟuku ankula kawalirira wiyaringkunyangka. Ngayulu tjinguṟu puḻkaṟa tjituṟu-tjituṟurira iluku, panya ngayulu tjiḻpi mulapa.’ Alatji nganampa mamangku wangkangu nganaṉala. ");
INSERT INTO pjt_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","“Kaṉa kuwari tjinguṟu Pintjimannga wiya ma-pitjala wirkankuku, ka Mamalu puṯu nyakula puḻkaṟa tjituṟu-tjituṟurira iluku, panya katja nyanga palumpa paluṟu puḻkaṟa mukuringkupai. Munu paluṟu panya tjiḻpi mulapa katja-tjiratja iluku. ");
INSERT INTO pjt_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ngayulu panya wangkangu Mamala, ‘Ngayulu nyuntumpa katja maḻakungku katinytja wiyangkampa ngayuku tiṯutjara mirpaṉpa nyinama.’ ");
INSERT INTO pjt_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Palulanguṟuṉa kuwari ngayulu nyuntumpa rawa mani wiyakitja waṟkarima unytju ngayuku maḻanypaku aṟangka. Ka palunya wantir'iyala kuṯa tjuṯangka tjungu mamakutu ankunytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Palu puṯuṉa ananyi mamakutu palunya wiya. Ngayuku mama puṯu nyakula tjinguṟu iluku. Kaṉa alatjiku mukuringkunytja wiya.” Alatji Judah-lu wangkangu Josephala wati Itjipanya nguraṟangka-palku. ");
INSERT INTO pjt_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","3","Ka Josephalu kuliṟa walytja tjuṯaku ngaḻṯuringkula nguwanpa ulangu, munu wangkangu palumpa waṟka tjuṯa pakantjaku uṟilkutu tjana kutju kuṯaṟara kuṯaṟara nyinara wangkanytjikitjangku. Munu palulanguṟu aṉangu malikitja panya waṟka tjuṯa ma-pakannyangka puḻkaṟa ulangi. Kaya uṟilta ngaṟanytja tjuṯangku kulinu puḻkaṟa ulanyangka munuya ankula tjakultjunu mayatja puḻkangka panya Piiṟala. Ka Josephalu palumpa kuṯa tjuṯangka munu palumpa maḻanypangka kuḻu wangkangu, “Ngayulu nyurampa maḻanypa panya Josephanya. Ka ngayuku mama wanyu palya wankaṯu nyinanyi?” Ka tjana kuliṟa kawaṟu-kawaṟurira nguḻuringu munuya wangkawiyaringkula ngaṟangi. ");
INSERT INTO pjt_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Ka Josephalu wangkangu, “Ngalya-ilariwaya.” Munu ilaringkunyangka piṟuku wangkangu, “Ngayulu panyaṉa nyurampa panya maḻanypa panya Josephanya panya nyura ngayunya iriti manikitjangku ungkul'iyaṉu ngura nyanga Itjipalakutu. ");
INSERT INTO pjt_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Palu uti nyura nguḻu wiya ngaṟama ngayunya iyantjatjanu ngura nyangakutu. Panya nyura kutju ngayunya iyantja wiya, panya Godalu kuḻuṉi ngayunya iyaṉu aṉangu tjuṯa wankaṟunkunytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Kuwari nyanga panya yiya kutjara ngaṟala wiyaringu ailuru puḻka, palu piṟuku nyanganguṟu ma-ngaṟanyi yiya kutjara maṉkurpa ailuru puḻka panya paluṟuṯu mai puṯu pakaltjingantjaku. ");
INSERT INTO pjt_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Ka pala palulanguṟuṉi Godalu iyaṉu nyurala kuranyu ngura nyangaku, munuṉi tjunu mayatja puḻka nyurampa nyinanytjaku mai wiyaringkunyangka nyuranya maingka wanka kanyintjaku nyurampa tjitji tjuṯa kuḻu. ");
INSERT INTO pjt_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Ala palatja! Nyura ngayunya iyantja wiyaṯu, palu Godaluṉi ngalya-katingu ngura nyangakutu. Paluṟuṉi tjunu Piiṟaku maḻpa ngali tjungu nyinanytjaku munu ngura nyanga Itjipaku winkiku mayatja nyinanytjaku.” ");
INSERT INTO pjt_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Munu palulanguṟu wangkangu tjanala, “Mapalkuya ara maḻaku Mamalakutu munu palula wangka ngayulu kuwari nyurala wangkanytja alatji, ‘Godaluṉi tjunu Itjipaku mayatja. Palu Itjipanya manta puḻka ngura tjukutjuku tjuṯatjara, ka nyuntu mapalku pitja Itjipalakutu ngayula nyinanytjikitja ngura ini Katjinta. ");
INSERT INTO pjt_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Palu nyuntu kutju wiya. Uwankara ngalya-kati nyuntumpa katja, uṉṯalpa, pakaḻi, puḻiri tjuṯa kuḻu munu tjiipi nanikuta, puluka tjuṯa kuḻu uwankara ngalya-kati nyuntumpa ulytja winki kuḻu. Kaṉanta wiṟuṟa aṯunymankuku ngayula itingka nyinanyangka ngura Katjinta. Panya ailuru puḻka rawaṯu ngaṟanyi munu yiya kutjara maṉkurpa ngaṟala wiyaringkunyangka kutju wiyaringanyi. ");
INSERT INTO pjt_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Kaṉa nyuntunya munu nyuntumpa walytja tjuṯa kuḻu maingka wanka kanyintjikitja mukuringanyi nyuntumpa kuka tjuṯa kuḻu mai wiyangka ilunytjaku-tawara.’ Alatjiya ankula tjakultjura Mamala. ");
INSERT INTO pjt_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“Uwa, mulapa nyura ngayunya nyakula ngurkantananyi maḻanypa nyurampa. Ka Pintjiman, nyuntu kuḻu ngayunya nyakula kuṯa ngurkantananyi. ");
INSERT INTO pjt_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Ankulaya ngayuku mamangka tjakultjura panya ngayulu Itjipaku mayatja nyinanytja munu uwankara nyanganpa nyakunytjatjanungku kuḻu tjakultjura. Palulanguṟuya mapalku ngalya-kati.” ");
INSERT INTO pjt_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Munu palulanguṟu wangkara wiyaringkula puḻkaṟa ampuningi Pintjimannga munu pulanku ampuṟa puḻkaṟa ulangi. ");
INSERT INTO pjt_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ka Josephanya rawa ulara kuṯa tjuṯa kuḻu ampuṟa mitamita kutjara nyunytjuningi. Kaya palulanguṟu kuṯa tjuṯangku pukuḻarira aṟa tjuṯa wangkangi palula. ");
INSERT INTO pjt_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Ka wati kutjungku ankula mayatja Piiṟala tjakultjunu Josephaku kuṯa tjuṯa pitjanytja, ka paluṟu kuliṟa pukuḻaringu palumpa maḻpa tjuṯa kuḻu. ");
INSERT INTO pjt_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Munu paluṟu wangkangu Josephala, “Nyuntumpa kuṯa tjuṯa wangka mai puḻka tangkiyi tjuṯangka luutaṟa ma-katinytjaku ngura nyara Kainantakutu. ");
INSERT INTO pjt_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Munu wangka tjananya mama walytja tjuṯa kuḻu mantjiṟa maḻaku ngalya-pitjanytjaku. Ka ngayulu tjananya ngura wiṟunya unganyi manta nyanga Itjipala, kaya pukuḻpa mulapa nyinaku mai puḻkangka. ");
INSERT INTO pjt_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Munu tjananya wakina tjuṯa uwa kaya ma-katira kuri tjuṯa munu tjitji tjuṯa munu mama kuḻu mantjiṟa ngalya-kati pakungka-tawara. ");
INSERT INTO pjt_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Palu wangka tjanala ulytja kutjupa kutjupa uwankara tjana kanyintjatjanungku wantikatinytjaku, panya ngayuluṉa tjananya wirkankunyangka ulytja wiṟu, kutjupa kutjupa wiṟu tjuṯa kuḻu nyanganguṟu ungkuku tjana pukuḻpa nyinanytjaku.” Alatji Piiṟalu Josephala wangkangu. ");
INSERT INTO pjt_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Ka Josephalu nyangatja kuliṟa tjakultjunu tjanala. Munu tjananya ungu wakina tjuṯa, munu mai kuḻu ungkul'iyaṉu tjana ankula nguṟurpa mungaringkula ngalkukatinytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Munu tjananya mantara kutju kutju ungu tjarpanytjaku. Palu Pintjimannga paluṟu ungu mantara kutjara maṉkurpa munu palunya ungu mani puḻka mulapa, panya Pintjimannga palumpa maḻanypa pula ngunytju kutjutja. ");
INSERT INTO pjt_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Munu tangkiyi 10 luuta puḻkatjara palumpa mamakutu ungkul'iyaṉu kutjupa kutjupa wiṟu tjuṯatjara Itjipalanguṟu. Munu paluṟu tangkiyi 10 kutjupa ngunytju tjuṯa kuḻu ungkul'iyaṉu mai uṉinypatjara munu mai kutjupa kutjupa tjuṯatjara nyumatjara kuḻu panya nguṟurpa mungaringkula ngalkuntjaku. ");
INSERT INTO pjt_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Munu tjananya wangkangu, “Ankulampaya pikaringkuwiya pitjalinama.” ");
INSERT INTO pjt_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Kaya Itjipalanguṟu ma-pakaṉu munuya ankula ankula ngula wirkanu palumpa tjanampa mamaku ngurangka Kainanta. ");
INSERT INTO pjt_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Munuya wirkaṟa mamangka wangkangu, “Mama, nyuntumpa panya katja Josephanya wanka nyinanyi. Paluṟu manta nyara Itjipala mayatja puḻka nyinanyi ngura uwankaraku.” Ka mama Jacobalu puḻkaṟa urulyaraṟa wangkangu, “Ma-wanti! Nguntiṉatju kulinu ilunyangka-palku.” Munu paluṟu puṯu mulamularingangi. ");
INSERT INTO pjt_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Kaya tjakultjunu Josephalu wangkanytja uwankara. Ka paluṟu kuliṟa wakina tjuṯa kuḻu nyakula mulamularingu munu palumpa katjaku pukuḻarira wangkangu, “Mulapa ngayuku katja wanka nyinanyi. ");
INSERT INTO pjt_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Wanyu kaṉatju ngaṉmanytju ankula nyawa ilunytja kuwaripangka.” ");
INSERT INTO pjt_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","7","Munu palulanguṟu paluṟu pirtji-pirtjingulta ankunytjikitja palumpa katja tjuṯa kuḻu. Munuya ulytja uwankara uṯuḻuṟa utitjunu tangkiyingka wakinangka panya Itjipaku mayatjangku tjanampa iyantjitjangka. Munuya kuka tjuṯa kuḻu tjunguṉu katinytjikitjangku puluka, tjiipi, nanikuta. Palulanguṟuya katja tjuṯangku mama panya tatitjunu munu tjanampa kuri tjuṯa, tjitji kuḻunypa tjuṯa kuḻu wakina tjuṯangka. Munuya ma-pakaṉulta Itjipalakutu uwankara katja uṉṯalpiti, mingkayi tjuṯa, pakaḻi puḻiripiti kuḻu. Munuya ankula nguṟurpa ngaṟatjunu ngura Piitjiipala. Ka Jacobanya ukalingu ngura pala palula, munu pitjilta katu kuka pungkula tiliwakaṟa Godanya ungu paluṟu pukuḻarinytjaku. Panya palumpa mamangku Isaacalu palu puṟunypaṯu ungkula waḻkulpai God panya palunyaṯu. Palulanguṟu mungangka tjukurmankunyangka Godalu Jacobala wangkangu mirara, “Jacob! Kuliniṉin?” Ka Jacobalu wangkangu, “Uwa kuliniṉanta.” Ka Godalu palula wangkangu, “Ngayuluṉa Godanya nyuntula wangkanyi, panya nyuntumpa mamangku ngayunya waḻkulpai. Ka nyuntu palya Itjipala ankula nyinama nguḻuringkunytja wiya panya ngayuluṉa nyurala tjungu nyinaku. Munuṉa nyuranya nyara palula nyinanyangka palyalku nyurampa walytjapiti ma-tjuṯaringkunytjaku maḻatja maḻatja. Panya nyuntumpa pakaḻi puḻiripitingku tjitji tjuṯa mulapa kanyilku, nyuntumpa kulypalpitingku ngunytjupitingku kuḻu. Alatjingaṟa nyuntulanguṟu walytja tjuṯa mularariku maḻatja maḻatja. Ka ngula mulapa nyuntumpa walytjapiti maḻatja tjuṯa mulararinyangka ngayulu piṟuku tjananya ngalya-katiku maḻakungku ngura nyanga Kainantakutu. Mulapaṉa nyanga alatjingalku. Ka nyuntu ngula katja Josephala miṟangka ilunyi.” Alatji Godalu wangkangu Jacobala paluṟu pukuḻarinytjaku katjangka miṟangka ilunytjaku. Munuya Piitjiipala ngarira tjiṉṯuringkula ma-pakaṉu Itjipalakutu. ");
INSERT INTO pjt_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","25","Tjana panya tjuṯa mulapa anu Itjipalakutu Jacobaku walytjapiti. Panya Jacobaku kuri ngaṉmanyitjangku Liyalu kanyinu katja maṉkur-maṉkurpa munu uṉṯalpa kutju ini Tiinanya. Paluṟu panya Rupinnga-waraṟa kanyinu, ka paluṟu pininu Tjimiyannga, ka paluṟu pininu Levinya, ka paluṟu pininu Judah-nya, ka paluṟu pininu Itjakanya, ka paluṟu pininu Tjipulunnga, ka Tjipuluntu pininu kungka Tiinanya. Ka katja nyanga tjana katja tjuṯa ngapartji utinu Jacobaku pakaḻipiti. Rupintu katja kutjara kutjara utinu ini nyanganpa – Anakanya, Palunya, Itjuṟannga, Kaaminya tjananya. Ka Tjimiyantu katja maṉkur-maṉkurpa utinu ini nyanganpa – Tjimuwilnga, Tjaminnga, Awutanya, Tjakinnga, Tjuuwanya, Tjuulanya tjananya. Ka Levilu utinu katja maṉkurpa ini nyanganpa – Kiitjannga, Kawatjanya, Miṟaṟainya tjananya. Ka Judah-lu utinu katja maṉkur-kutjara ini nyanganpa – Tjilanya, Piṟitjinya, Tjiṟanya tjananya. (Palu palumpa katja kutjara ngaṉmanypa wiyaringu ngura panya Kainanta ini nyanganpa – Uurnga pula Anannga.) Ka Itjakalu katja kutjara kutjara utinu ini nyanganpa – Tulanya, Puwanya, Tjatjupanya, Tjimuṟannga tjananya. Ka Tjipuluntu katja maṉkurpa utinu ini nyanganpa – Tjiṟitanya, Iilannga, Tjaalilnga tjananya. Aṉangu nyanga paluṟu tjana uwankara Liyalanguṟu utiringu Tiinanya kuḻu aṉangu 33. Ka palulanguṟu Jacobaku kuri maḻatjangku Raitjiltu tjitji wiya nyinara kungkawaṟa panya palumpa waṟkaripai Jacobanya ungangi ini panya Pilanya palula tjunguringkunyangka tjitji utintjaku. Ka Jacobalu Pilala katja kutjara utinu Dannga pulanya Napatalinya. Ka nyanga paluṟu pula ngapartji utinu katja tjuṯa, Danku kutju ini Uutjimanya, Napataliku kutjara kutjara ini nyanganpa – Tjatjiilanya, Kuninya, Tjitjanya, Tjilimanya tjananya. Nyanga paluṟu tjana panya Raitjilku ngaṉatinguṟu Pilalanguṟu utiringu aṉangu 7. Ka palulanguṟu Liyalu kungkawaṟa panya palumpa waṟkaripai Jacobanya ungangi ini panya Tjilpanya palula tjunguringkunyangka tjitji utintjaku. Ka paluṟu kanyinu katja kutjara Kaatanya munu Atjanya. Ka Kaatalu utinu katja maṉkur-kutjara kutjara ini nyanganpa – Tjipannga, Aakinya, Tjuninya, Itjipannga, Iṟinya, Aṟatanya, Aṟilinya tjananya. Ka Atjalu utinu katja kutjara kutjara ini nyanganpa – Iminanya, Itjipanya, Itjipanya, Piṟiyanya tjananya munu uṉṯalpa kutju ini Tjiṟanya. Ka Atjaku katja kutjungku Piṟiyalu katja kutjara ngapartji utinu Atjaku pakaḻi kutjara ini nyanganpa – Iipanya pulanya Malkiyilnga. Nyanga paluṟu tjana panya Liyaku ngaṉatinguṟu Tjilpalanguṟu utiringu aṉangu 16. Ka palulanguṟu Jacobalu katja kutjara utinu Raitjilta panya Josephanya pulanya Pintjimannga. Ka Josephalu ngura panya Itjipala katja kutjara utinu palumpa kuringka ini Atjinatjala. Katja paluṟu pula panya ini nyanganpa – Manatjanya munu Ipuṟaimanya. Ka Pintjimantu utinu katja tjuṯa mulapa 10-pa ngura nyara Kainanta nyinaralpi ini nyanganpa – Pilanya, Pikanya, Atjapilanya, Kiranya, Naimannga, Iiyinya, Ratjunya, Mupiminya, Uupiminya, Aatanya tjananya. Nyanga paluṟu tjana Raitjiltanguṟu utiringu aṉangu 14. ");
INSERT INTO pjt_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","27","Ka Jacobaku katja uṉṯalpa tjuṯa, pakaḻi puḻiripiti, kulypalpiti paluṟu tjana tjunguringkula 66 anangi ngura panya Itjipalakutu. Ka Jacobanya tjana Itjipala wirkaṟa Josephala palumpa katja kutjarangka tjunguringkula aṉangu 70-ringulta. Kaya Jacobaku mingkayi tjuṯa kuḻu anu. ");
INSERT INTO pjt_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Ka Jacobanya tjana panya ankula ankula manta panya Itjipala tjarpangu. Ka mamangku wangkangu katja kutjungka Judah-la alatji, “Nyuntu wanyu ma-kuranyurira wangka Josephala ngalya-ngaparikatinytjaku ngura pala Katjintakutu.” Ka paluṟu mulapaṯu wangkanyangka kuranyurira Josephala wangkangu. ");
INSERT INTO pjt_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Ka tjana Katjinta wirkankunyangka Josephanya palumpa tjinkangka tatiṟa ngaparikatingu palumpa mama nyakunytjikitja. Munu palula wirkaṟa nyangu palumpa mama munu pulanku puḻkaṟa ampuṟa ulangi pukuḻarira, rawa nyakuwiya nyinanytjatjanungku. ");
INSERT INTO pjt_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Ka Jacobalu wangkangu katjangka, “Kuwariṉa kurunpa pukuḻpa mulararingu, munuṉa palyalta ilunyi nyuntunya nyakunytjatjanu.” ");
INSERT INTO pjt_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Palulanguṟu Josephalu wangkangu tjanala, “Wanyu kaṉa ankula wangka Itjipaku mayatjangka Piiṟala nyura panya pitjanytja nyara Kainantanguṟu. ");
INSERT INTO pjt_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Ngayulu wangkaku palula panya nyura puluka, tjiipi, nanikuta tjuṯa Kainanta kanyintjatjanungku uwankara ngalya-katingu nyurampa ulytja tjuṯa kuḻu kutjupa kutjupa uwankara. ");
INSERT INTO pjt_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Ka mayatja Piiṟalu nyuranya aḻṯira tjapilku alatji, ‘Waṟka nyaangka waṟkaripai nyura?’ ");
INSERT INTO pjt_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Ka alatji tjapinnyangka nyura palula wangka, ‘Nganaṉala puluka, tjiipi, nanikuta tjuṯa kanyilpai nganampa mamangka tjamungka aṟangka.’ Ka nyura alatji wangkanyangka paluṟu wangkaku nyura nyinanytjaku ngura nyanga Katjinta. Panya Itjipanya nguraṟa tjuṯangkuya aṉangu kuka kanyilpai tjuṯa wantipai tjungu nyinawiyangku. Pala palulanguṟu Piiṟalu nyurala wangkaku mauṉṯalpa nyinanytjaku ngura nyanga Katjinta.” Alatji Josephalu wangkangu palumpa walytja tjuṯangka. ");
INSERT INTO pjt_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Munu palulanguṟu Josephalu kuṯa maṉkur-kutjara ngurkantaṟa katingu mayatja panya Piiṟalakutu. Munuya wirkaṟa Josephanya kutjulta ngaṉmanypa tjarpangu munu wangkangu Piiṟala, “Ngayuku mama munu kuṯa tjuṯa pitjangu Kainantanguṟu puluka, tjiipi, nanikuta winkitjara ulytja winkitjara kuḻu. Munuya wirkaṟa nyinara paṯaṉi ngura nyara Katjinta. ");
INSERT INTO pjt_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","4","Ka nyangaṉa katingu ngayuku kuṯa maṉkur-kutjara nyuntu nyakunytjaku.” Ka Piiṟalu nyakula wangkangu tjanala, “Waṟka nyaangka nyura waṟkaripai?” Kaya palula wangkangu, “Nganaṉa puluka, tjiipi, nanikuta kanyilpai nganampa mamangka tjamungka aṟangka. Munula pitjangu ngura nyangangka nyinanytjikitja panya Kainannga ukiṟi wiya kuka tjuṯangku ngalkuntjaku. Kala wanyu palya nyinaku ngura nyarangka, Katjinta?” ");
INSERT INTO pjt_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","6","Ka Piiṟalu wangkangu Josephala, “Palyaya pitjangu nyuntumpa mama munu nyuntumpa walytjapiti. Ka Itjipanya nyanga manta puḻka, ka paluṟu tjana palya ngura nyara Katjinta nguraṟarira nyinaku, panya ngura nyaratja palya mulapa. Ka-puṯa tjinguṟu nyuntumpa walytja kutjupa tjuṯa kuka palyanyku kanyilpai nyinanyi. Palunya tjananya-puṯa wangka, kaya pitjala kuka nyanga ngayuku tjuṯa kuḻu kanyinma.” ");
INSERT INTO pjt_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","8","Palula maḻangka Josephalu palumpa mama Jacobanya ngalya-katingu Piiṟalu nyakunytjaku. Ka Jacobalu wirkaṟa Piiṟanya wangkara pukuḻmanu. Ka Piiṟalu palula tjapinu, “Nyuntu yaalaṟa iṯi ngaringu?” ");
INSERT INTO pjt_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","10","Ka paluṟu wangkangu, “Iriti mulapaṉa ngaringu, panya yiya nampa nyangatja 130 nyinangi. Munuṉa ngura nyaranta rawa para-ngaṟangi. Palu ngayuku mama munu tjamu pula rawa mulapa nyinangi ngayula waintaṟa. Ka ngayuluṉa pulala ngaṯalpa nguwanpa nyinangi munuṉa kutjupa kutjupa tjuṯanguṟu rawa tjituṟu-tjituṟu para-ngaṟangi.” Munu alatji wangkara wiyaringkula Jacobalu Godala tjapinu Piiṟanya pukuḻmankunytjaku. Munu palulanguṟu anulta ngurakutu. ");
INSERT INTO pjt_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","12","Ka Josephalu kulinu Piiṟalu wangkanytja munu palumpa mama, kuṯa tjuṯa, walytja uwankara katira tjananya ngura panya Katjinnga ungu alatjiṯu tjananku kukatjara nyinanytjaku manta panya Itjipala. Ka ngura nyara palula itingka ngura tawunu puḻka ngaṟangi ini Ramatjinya. Ka Josephalu tjananya uwankara mai rawangku ungkukatingi pukuḻpa nyinanytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","14","Ka ailuru panya rawa ngaṟanyangka ngura uwankarangka Itjipala Kainanta kuḻu mai pakantja wiya alatjiṯu ngaṟangi. Kaya aṉangu tjuṯa paḻtjatjiratjarira wailu-wailuringu munuya Josephalakutu rawa pitjangi maningka mai payamilantjikitja. Ka mani panyatja paluṟu katipai Piiṟalakutu. Palu tjana maningka mai payamilaṟa mani wiyaningi. ");
INSERT INTO pjt_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Palulanguṟuya mani uwankara wiyaringkunyangka Itjipanya nguraṟa tjuṯangku Josephalakutu pitjala ngatjiningi mai ungkunytjaku alatji wangkara, “Nganampa mani wiyaringu. Mailanya uwa paḻtjaku ilunytjaku-tawara. Nyuntun mai puḻkatjara.” ");
INSERT INTO pjt_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","17","Ka Josephalu wangkangu, “Mani wiyangkampaya kuka puluka tjiipi kutjupa kutjupa uwankara ngalya-katira uwa, kaṉa nyuranya mai ungkuku.” Kaya palulanguṟu puluka, tjiipi, nanikuta, tangkiyi, nyanytju uwankara maikitjangku katira ungangi. Munuya mai mantjiṟa ngalkula wanka nyinangi nyara palulanguṟu. ");
INSERT INTO pjt_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","19","Palu kuḻi kutjupangka palula maḻangkaya piṟuku pitjangu palulakutu maiku ngatjintjikitja. Munuya pitjala wangkangu, “Mayatjan wiṟu. Nyuntu panyan mani kuka puluka, tjiipi kutjupa kutjupa uwankara kanyini nganaṉa ungkunytja. Kala mantangka kutjulta nyinanyi. Ungamalanya ilunytjaku-tawara mai. Palu nyuntu mai ungkuwiyangku wantinyangkampa nganaṉa ilura wiyaringkula ka manta kutjuringkuku. Palu wanyu paama nyanga nganampa mantjila mayatja Piiṟaku nganaṉanya mai ungkula. Munu nganaṉanya kuḻu mantjila palumparinytjaku, kala nganaṉa palumpalta waṟkarima palumpa paama tjuṯangka. Alatji palyala munulanya uwa mai uṉinypa nyuma palyaṟa ngalkuntjaku munu uṉinypa kutjupa kuḻu mantangka tjunkula mai kutjupa pakaltjingantjaku.” ");
INSERT INTO pjt_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","21","Ka Josephalu tjananya mai ungkula tjanampa paama tjuṯa Itjipala winkingka mantjiningi mayatja Piiṟakurinytjaku. Panya ailuru puḻka rawa ngaṟangi, kaya paama kanyilpai uwankarangku tjanampa paama Piiṟanya ungangi maikitjangku. Munuya aṉangu Itjipanya nguraṟa uwankara Piiṟaku waṟkaringi manikitja wiya maikitja kutju. ");
INSERT INTO pjt_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Palu Josephalu wati tjukurtjara tjuṯaku paama tjuṯa payamilantja wiyaṯu, panya Piiṟalu tjananya inma kanyinnyangka mani ungkupai, kaya mani pala palula mai tjananku payamilaningi. ");
INSERT INTO pjt_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Munu Josephalu aṉangu uwankarangka Itjipala nyinanytja tjuṯangka wangkangu, “Panya ngayuluṉa mantjinu uwankara nyuralanguṟu Piiṟaku munuṉa nyuranya kuḻu mantjinu nyura Piiṟaku waṟkarinytjaku. Munuṉa kuwari nyuranya unganyi uṉinypa tjuṯa mai panya nyara mirka ngarinytjitjanguṟu nyura mantangka tjunkula mai kutjupa pakaltjingantjaku. ");
INSERT INTO pjt_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Ka ngula mai pakannyangka kaṯaṟa uṯuḻuṟampa kaṉiṟa nyura kutjungku kutjungku mai uṉinypa tjara-tjaraṟa uṯuḻu 5 palyala munu palulanguṟu uṯuḻu kutju mayatja Piiṟanya uwa, munu uṯuḻu 4 palya kanyinma nyuranku mai palyaṟa ngalkuntjikitjangku munu uṉinypa kuḻu mantangka tjunkula pakaltjingantjikitjangku.” ");
INSERT INTO pjt_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Kaya palula wangkangu, “Nyuntu mayatja palya. Nyuntu nganaṉanya wankaṟunu ilunytjaku-tawara, kala nganaṉa palya waṟkariku mayatja panya Piiṟaku.” ");
INSERT INTO pjt_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Nyanga alatjiya nyinangi Josephalu wangkanytjitjangka kuliṟa munuya yiya kutjupa yiya kutjupa rawangku mai uraṟa tjaraṟa tjara tjukutjuku tjukutjuku Piiṟanya katira ungangi. Palu wati panya tjukurtjara tjuṯaku paama tjuṯa Piiṟalu mantjintja wiyangku wantingi, kaya kanyiṟa mai walytjangku pakaltjinganingi munuya Piiṟanya tjaraṟa tjara ungkunytja wiya. ");
INSERT INTO pjt_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Ka Jacobanya, panya ini kutjupa Israelnga, munu palumpa walytjapiti pukuḻpa nyinangi manta Itjipala ngura nyara Katjinta. Munuya tjana tjitji tjuṯa kanyinu. Ka uwankara tjanampa puḻkaringu ulytja, mani, mai, puluka, tjiipi, nanikuta uwankara. ");
INSERT INTO pjt_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Ka Jacobanya nyara palula nyinangi kuḻi nyiṉnga 17 aṟa munu palulaṯu tjiḻpi mulararingu yiya tjuṯa mulapa 147 nyinanytjatjanu. ");
INSERT INTO pjt_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","31","Palulanguṟu paluṟu uparingkula kulinu, “Ngayulu ilunytjaku tjinguṟu ilaringu.” Munu paluṟu wituṉu aṉangu kutjupa ankula palumpa katja Josephanya aḻṯira ngalya-katinytjaku. Ka Josephanya pitjanyangka paluṟu ngaripaingka nyinara wangkangu, “Ngayulu wiyaringkunyangkaṉi katira ngayuku mamangka panya itingka tjuṉutjura ngura nyara Kainanta. Wanyuṉi nyuntu kalkula ngura nyanga Itjipala tjuṉutjunkunytja wiyangku katira Mamala itingka tjuṉutjunkunytjikitjangku.” Ka Josephalu wangkangu, “Uwa, palyaṉanta nyuntumpa mamangka itingka tjuṉutjunanyi.” Ka mamangku wangkangu, “Palu ngayulu mulamularingkunytjaku ngayunya kalkula alatji. Paṉṯaṉi pampula, panya nyuntu ngayunya paṉṯa pampuṟa kalkuntjatjanungku maḻa puṯu wantinyi.” Palulanguṟu Josephalu paṉṯa pampuṉu munu kalkuṟa wangkangu, “Ngayulu nyuntunya ilunyangka katira tjuṉutjunanyi ngura panya Kainanta tjamula itingka.” Ka kalkunnyangka Jacobanya pukuḻaringu munu ngaripaingka waṯungaṟakatira Godanya waḻkuṉu, palumpa pukuḻarira. ");
INSERT INTO pjt_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Ka Josephanya ngurakutu maḻaku ankula nyinangi. Munu ngula kulinu palumpa mama pikatjararingkunyangka. Munu palumpa katja kutjara Manatjanya Ipuṟaimanya pulanya katingu tjamu nyakunytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Ka wirkankunyangka aṉangu kutjupangku tjarpara wangkangu Jacobala, “Nyuntumpa katja Josephanya pitjangu.” Ka Jacobalu kuliṟa tiwilpa ngarinytjatjanu purkaṟa pakaṟa nyinangi ngaripaingka. Ka Josephanya ma-tjarpangu katja kutjara kuḻu. ");
INSERT INTO pjt_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","4","Ka Jacobalu nyakula wangkangu, “Iritiṉi ngayula God witulyanya utiringu ngura nyara Latjala manta Kainanta munuṉi pukuḻmanu wangkara, ‘Ngayulu nyuntunya ungkuku tjitji tjuṯa. Kaya nyuntumpa katjapitingku tjitji tjuṯa mulapa utilku ka maḻatjangku maḻatjangku tjitji tjuṯa mulararinytjaku palyalku nyuntumpa walytjapiti tjuṯa mulapa. Ka ngayulu manta nyanga Kainannga tjananya ungkuku tjana walytjaringkula tiṯutjara nyinanytjaku.’ Alatjiṉi Godalu wangkara pukuḻmanu. ");
INSERT INTO pjt_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Ka nyuntumpa nyanga katja kutjara panya iṯi ngaringu ngura nyanga Itjipala ngayulu pitjanytja kuwaripangka. Palu ngayuluṉa palunya pulanya kuwari katjanmananyi paluṟu pula mama tjuṯa puṟunypa nyinanytjaku panya Rupinnga pula Tjimiyannga puṟunypa. ");
INSERT INTO pjt_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Palu ngula nyuntu katja kutjupa tjuṯa utinnyangkampa palunya tjananya ngayulu katjanmankunytja wiya, ka paluṟu tjana ngula Kainantakutu ankula ngura walytjatja mantjintja wiya kuṯa kutjaraku ngurangka kutju nyinaku Ipuṟaimaku pulampa Manatjaku. ");
INSERT INTO pjt_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Uwa, ngayulu palunya pulanya katjanmananyi pulampa panya kaminguṟu, ngayuku panya kuri Raitjiltanguṟu, panya ngayulu palumpa puḻkaṟa mukuringangi. Palu panya paluṟu ngaṉmanypa wiyaringu ngura nyara Kainanta iṯi panya Pintjimannga kanyiṟa, nganaṉa ngura panya Mitjupu-taimiyalanguṟu pitjala. Kaṉa kurunpa puḻkaṟa iluṟu-iluṟuringu, munuṉa palunya tjuṉutjunu iwarangka itingka ngura tawunu Ipuṟatjala itingka.” Alatji Jacobalu katjangka wangkangu Josephala. (Kuwariya ngura panya “Ipuṟatjanya” ini kutjupa wangkapai “Bethlehemanya”.) ");
INSERT INTO pjt_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","10","Munu Josephala wangkara wiyaringkula waintaṟa nyangu palumpa pakaḻi kutjara ngaṟanyangka. Paluṟu pulanya ngaṉmanytju nyakunytja wiya ngaṟanyangka, panya paluṟu kuṟu paulpa. Munu paluṟu nyakula wangkangu, “Yaalitja kutjara palatja?” Ka Josephalu wangkangu, “Nyanga paluṟu pula panya nyuntumpa pakaḻi kutjara, panya Godaluṉi ungu ngura nyanga Itjipala.” Ka Jacobalu wangkangu, “Ngalya-kati pulanya ngayulakutu kaṉa Godala tjapilku pulanya palyaṟa pukuḻmankunytjaku.” Munu pulanya ngalya-katinyangka ampuṟa mitamita kutjara nyunytjuṉu. ");
INSERT INTO pjt_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Munu wangkangu Josephala, “Nguntiṉa kulinu nyuntu ngaṉmanypa ilunyangka-palku, munuṉa nyuntunya-tjiratja rawa tjituṟu-tjituṟu nyinangi nyuntunya piṟuku nyakunytjikitjangku kulintja wiya alatjiṯu. Palu Godalu ngayunya ngalya-katingu Itjipalakutu nyuntunya nyakunytjaku nyuntumpa katja kutjara kuḻu.” ");
INSERT INTO pjt_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Ka palulanguṟu Josephalu pulala wangkangu, “Alatjiṯulta wanti pula tjamunya ampuntja wiyangku, palya.” Munu Josephanya mamangka tultjungaṟakatira ngalyangku manta pampuṉu palunya waḻkuntjikitja. ");
INSERT INTO pjt_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","14","Munu pakaṟa wangkangu palumpa katja kutjara tjamungka itingka tultjungaṟakatinytjaku kata witiṟa pulampa Godala tjapintjaku. Munu paluṟu kuṯa tjamu wakungka tjunu munu maḻanypa tjampungka, panya tjakangku kuṯa pampulpai maṟa wakungku panya paluṟu ngaṉmanyitja. Palu Jacobanya mukuringu katja maḻatja maṟa wakungku pampuntjikitja paluṟu kuranyu ngaṟanytjaku. Munu paluṟu maṟa waku tjunu maḻanypangka Ipuṟaimala munu maṟa tjampu tjunu kuṯangka Manatjala. ");
INSERT INTO pjt_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","16","Munu Josephanya pukuḻmankunytjikitjangku Godala tjapinu pakaḻi kutjaraku alatji wangkara, “Mayatja God, nyuntunya ngayuku tjamu Aipuṟamalu kuliṟa waḻkuningi ngayuku mama Isaacalu kuḻu. Kaṉi nyuntu panya rawangku ngayunya katiṟinangi munuṉin wankaṟu kanyiningi. Kaṉa nyanga kuwari nyuntula tjapini aṯunytju kanyintjaku nyanga pulanya. Ngayulu nyanga pulanya katjanmananyi, ka nyuntu wanyu pulanya palyanma. Kaya aṉangu tjuṯangku pulanya nyakula kulilku, ‘Munta, Godalu nyanga pulanya palyaṟa kanyini panya paluṟu Jacobanya Isaacanya Aipuṟamanya tjananya palyaṟa kanyiningi, palu puṟunytjuṯu pulanya kanyini.’ Alatjiya palunya pulanya ngurkantankunytjaku palyanma. Munu Mayatja God, nyuntu pula kuritjararingkula tjitji tjuṯa utintjaku palyanma palula pulalanguṟu walytja tjuṯa mulararinytjaku maḻatja maḻatja.” ");
INSERT INTO pjt_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","18","Ka Josephalu mamangku maṟa tjunkunyangka nyakula tjituṟu-tjituṟuringu kuṯa katangka maṟa waku tjunkunytja-tjiratja. Munu mama maṟa witiṉu Ipuṟaimala katanguṟu katuṟa kuṯa katangka tjunkunytjikitjangku munu wangkangu, “Mama, nyuntu ngunti maṟa tjunanyi. Kuṯa ngaṉmanyitja nyangatja. Tjura maṟa waku palula katangka.” ");
INSERT INTO pjt_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","20","Ka mamangku wiyanmankula wangkangu, “Wiya, palya ngayulu kulini. Kuṯa Manatjalanguṟu walytja tjuṯaringkuku palu maḻatjakulta tjuṯa mularariku kuṯaku tjitjingka waintaṟa.” Alatji Jacobalu maḻanypa katangka maṟa waku tjunkula wangkangu paluṟu waintankunytjaku puḻka nguwanpa, munu kuṯa katangka maṟa tjampu tjunkula wangkangu ngaṯalpa ngaṟanytjaku. Munu piṟuku pakaḻi kutjarangka wangkangu pukuḻarinytjaku alatji, “Israelnga nguraṟa tjuṯangku nyupalinya rawangku kulilku watarkurinytja wiyangku palya mulapa nyinakatinyangka nyakula. Munuya kulintjatjanungku tjanayanku ngapartjilta Mayatja Godala tjapilku nyanga alatji, ‘Mayatja God, nyuntu wanyu nyanganpa ngapartji palyanma Ipuṟaimanya Manatjanya pula puṟunypa tjukaṟuru nyinanytjaku.’” ");
INSERT INTO pjt_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Munu pulala wangkara wiyaringkula palumpa katja Josephala ngapartji wangkangu, “Nyanga kuwariṉa uparingkulalta ilunyi. Palu Godalu nyuranya rawangku kanyilku munu ngula nyuranya maḻakungku katiku Kainantakutu manta panya nganampakutu. Panya manta nyara paluṟu Godalu Aipuṟamanya Isaacanya ngayunya ungkunytja. ");
INSERT INTO pjt_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ka panya manta nyara palula nguṟurpa ngura ini Tjikimanya ngaṟanyi ngura wiṟu mulapa mina puḻkatjara. Panya ngura pala palula aṉangu Amurkunu tjuṯa ngaṉmanypa nyinangi, kaṉa panya tjanampa pikaringkula tjananya paiṟa iyaṉu. Kaṉa kuwari ngura nyara wiṟu palunya nyuntunya kutju unganyi nyuntumpa kuṯa tjuṯa ungkunytja wiyangku.” Alatji Jacobalu palumpa katja Josephanya wangkara pukuḻmanu. ");
INSERT INTO pjt_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","2","Palula maḻangka Jacobalu palumpa katja uwankara aḻṯingu palula tjanala wangkanytjikitjangku. Kaya palulakutu ngalya-pitjangu. Ka tjanala wangkangu, “Katja tjuṯa ngalya-ilariwaya, kaṉa nyurala ngaṉmanytju tjukurpa wangka ngula nyanga alatjirinytjaku. Kaya kulinma ngayulu kuwari wangkanyangka panya ngayuluṉa nyurampa mama Israelnga.” Munu paluṟu wangkangi katja kutju kutjungka tjukurpa kutjupa kutjupa tjuṯa katja ngaṉmanyitjanguṟu maḻatjakutu. Palu paluṟu tjukurpa katja tjuṯaku kutju wangkawiyangku uwankaraku kutjuṯu wangkangi pakaḻipitiku puḻiripitiku ngunytjupitiku kulypalpitiku maḻanypitiku uwankaraku maḻatja maḻatjaku. ");
INSERT INTO pjt_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","4","Munu paluṟu Rupinta-waraṟa wangkangu nyanga alatji, “Rupin, nyuntu ngayuku katja ngaṉmanyitja, panya ngayulu kuṉpu puḻkangku nyuntunya utinu, ka nyuntu wati kuṉpu puḻka nyinangi kutjupa tjuṯangka waintaṟa. Palu nyuntu wati inuṟa nguwanpa panya nyuntu ngayuku kuringka ngunti tjunguringu kura mulapa. Munun palulanguṟu kuranyu puḻka nyinanytjatjanu nyuntumpa maḻanypa tjuṯangka maḻaringkula tjukutjuku nyinaku, nyuntumpa walytjapiti maḻatja maḻatja kuḻu.” ");
INSERT INTO pjt_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","7","Munu palulanguṟu Jacobalu Tjimiyanta pulala Levila wangkangu nyanga alatji, “Nyupali panya pikaṯi kutjarangku ngunti aṉangu tjuṯa waṟu-waṟuringkula tjuḻa waṟangka wakaṟa wiyaṉu, munu palu puṟunypaṯu nyupali puluka tjuṯa marpanypa unytjungku kaṯaṉu kaya puṯu anangi, ngaḻṯutjara. Uwa, nyupali panya kampangkaṯu tjaalymaṟa wangkara kulilpai aṉangu kutjupa tjuṯa pikangku pungkunytjikitjangku, kaṉa nyupalila tjunguringkunytja wiyangku wantinyi alatjiṯu. Pala palulanguṟuṉa Godala tjapintja wiya nyupalinya pukuḻmankunytjaku, munu nyupalimpa walytjapitiku kuḻu tjapintja wiyaṯu. Panya nyupali pikaṯi puḻka kutjara, kaṉa palulanguṟu nyupalinya manta ungkunytja wiyangku wantinyi ngura nyara Kainanta, kaya nyupalimpa walytja tjuṯa maḻatja maḻatja ngura walytjangka nyinanytja wiyaringkula ngura tjanampangka kutju nyinaku ngayuku katja kutjupa tjuṯaku ngurangka.” ");
INSERT INTO pjt_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","9","Palulanguṟu Jacobalu Judah-la ngapartji wangkangu nyanga alatji, “Nyuntumpa walytjapitingku mirpaṉtju tjuṯa pikakitja pitjanyangka pungkula wililytjingalku, ka nyara palulanguṟu nyuntumpa kuṯa maḻanypa tjuṯaku walytjapitingku tultjungaṟakatira tjananya mirawaṉiku nyuntumpa walytjapiti. Panya paluṟu tjana witulya puḻka mulapa lion puṟunypa, kaya kutjupa tjuṯangku tjananya nyakula puḻkaṟa nguḻuringkuku munuya wantiku alatjiṯu tjanampa pikaringkunytja wiyangku. ");
INSERT INTO pjt_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Panya nyuntumpa walytja tjuṯa mayatja puḻka nyinaku maḻatja maḻatja kuḻu mayatjaṯu wanapari wanapari nyinaku tiṯutjara, ka aṉangu ngura kutjupitja kutjupitja tjuṯangku tjanampa nguranguṟu wiṟu tjuṯa katira tjananya ungkuku mayatja puḻka nyinanyangka. ");
INSERT INTO pjt_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","12","Ka nyara nyuntumpa walytjapitiku ngurangka puṉu kiṟipitji tjuṯa mulapa pakalku manta lipiwanu, kaya waina puḻka mulapa tjulkuṟa palyalku. Munuya kuṟu tjitin-tjitinpa nyinaku waina puḻka tjikintjatjanu. Ka puluka nanikuta winki kuḻu ngura nyara palula para-ngaṟaku ukiṟi puḻkangka, ka nyuntumpa walytjapitiku kaṯiṯi piṟanpa mulapa ngaṟaku puluka, nanikuta ipi rawangku tjikintjatjanu.” ");
INSERT INTO pjt_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Palulanguṟu Jacobalu Tjipulanta ngapartji wangkangu nyanga alatji, “Katja, nyuntumpa ngura ma-ngaṟaku ngura ini Tjaitantakutu, ka nyuntumpa walytjapiti uṟu puḻkangka itingka nyinaku. Ka nyara palulakutu pauta puḻka tjuṯa waḻpa puḻkangka-tawara pitjala nyinaku.” ");
INSERT INTO pjt_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","15","Munu palulanguṟu Itjakala ngapartji wangkangu alatji, “Katja, nyuntumpa walytjapiti tangkiyi kuṉpu mantangka pakuringkula ngarinytja puṟunypa luuta puḻkatjara. Panya tjana para-nyakula kulilku, ‘Munta-uwa, ngura wiṟu nyangatja.’ Munuya ngura pala palula puḻkaṟa waṟkariku ulytja puḻkatjararingkunytjikitja, munuya puḻkaṟa waṟkarira puṯu wantiku kutjupangku tjananya pauntjingaṟa waṟkamilantja puṟunypa.” ");
INSERT INTO pjt_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","17","Munu palulanguṟu Danta ngapartji wangkangu alatji, “Katja, nyuntumpa panya ngunytju Pilanya, ngayuku kuri Raitjilku panya waṟkaripai. Palu nyuntu katja mulapa ngayuku nyuntumpa kuṯa tjuṯa puṟunypa, panya nyuntumpa walytjapiti ma-tjuṯaringkuku maḻatja maḻatja ngayuku walytjapiti alatjiṯu nyuntumpa kuṯa tjuṯaku walytjapiti puṟunypa. Kaya paluṟu tjana kutjupa kutjupa uwankara tjukaṟurulku Israelkunu uwankaraku. Munu paluṟu tjana tjaultji nganyiri puḻka nyinaku liru mulya-purkutitji puṟunypa, panya liru paluṟu iwarangka itingka paṯaṟa ngarira nyanytju wati-pitjanyangka nyakula taṟi patjalpai, ka nyanytju waṟarakatira wati panya palula tatintjanya punkatjingalpai, palu puṟunypa tjana warmaḻa tjuṯa pitjanyangka paṯaṟa urulyku pungkuku.” ");
INSERT INTO pjt_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Munu katja panya 7 wangkara wiyaringkula Jacobalu Godala tjukutjuku wangkangu alatji, “Mayatja, ngayulu nyuntumpa paṯaṉi nganaṉanya ngalkiṟa wankaṟunkunytjaku.” ");
INSERT INTO pjt_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Munu palulanguṟu Jacobalu katja kutjupa tjuṯangka kuḻu wangkangi Kaatala-waraṟa nyanga alatji, “Katja, wati mirpaṉtju tjuṯa warmaḻarira pitjaku nyuntumpa walytjapiti pungkunytjikitja, palu paluṟu tjana witulya puḻkangku tjananya pungkula nguḻuṟa wililytjingalku.” ");
INSERT INTO pjt_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Munu palulanguṟu katja kutjupangka Atjala ngapartji wangkangu nyanga alatji, “Katja, nyuntumpa walytjapiti mai wiṟu mulapa pakaltjingalku, kaya mayatja puḻka tjuṯangku tjanala payamilalku.” ");
INSERT INTO pjt_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Munu palulanguṟu Napatalila ngapartji wangkangu nyanga alatji, “Katja, nyuntumpa walytjapiti maḻu inuṟa puṟunypa pukuḻpa para-ngaṟaku munuya tjitji wiṟu tjuṯa kanyilku.” ");
INSERT INTO pjt_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Munu Josephala ngapartji wangkangu nyanga alatji, “Katja, nyuntumpa walytjapiti nyaa puṟunypa, panya puṉu kiṟipitji karu uṟutjarangka itingka pakaṟa puḻkaringkula mai puḻkatjararingkupai, palu puṟunypa nyuntumpa walytjapiti ma-tjuṯaringkuku maḻatja maḻatja. ");
INSERT INTO pjt_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","24","Ka panya wati nganyiri tjuṯa punaṟatjara pitjaku tjananya wakaṟa iluntankunytjikitja, palu tjana nguḻuringkunytja wiyangku rapangku ngaṟala tjananya wakaṟa wililytjingalku, panya Mayatja Godalu tjananya witulyankunyangka. Panya paluṟu ngayuku God witulya puḻka mulapa uwankarangka waintaṟa munu palumpa walytja tjuṯa rawangku aṯunymaṟa kanyilpai, panya wati tjiipi kanyilpaingku tjiipi tjuṯa wiṟuṟa aṯunymankupai, palu puṟunypa. Panya aṉangu tjuṯa nguḻuringkula apu murpukutu wirtjapakalpai wankaringkunytjikitja, palu puṟunypa Godanya nyinanyi Israelkunu tjuṯa wankaṟu kanyintjikitja. ");
INSERT INTO pjt_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","God nyara paluṟu nyuntumpa walytjapitingka tiṯutjara tjungu nyinara tjananya aṯunytju kanyilku, panya paluṟu witulya puḻka mulapa uwankarangka waintarinytja. Paluṟu rawangku palyalku tjananya minangku puyintjaku, munu paluṟu mina waḻa tjuṯa kuḻu manta unngunguṟu pakantjaku palyalku uṟu kuḻu karu tjuṯangka tiṯutjara ukalingkunytjaku. Ka ngura nyara palula nyuntumpa walytjapiti ma-tjuṯaringkuku maḻatja maḻatja pakaḻipiti puḻiripiti kulypalpiti ngunytjupiti kuṯapiti tjuṯa mulararinytjaku. ");
INSERT INTO pjt_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Uwa, tjukurpa nyanga ngayulu nyuntula wangkanytja wiṟu mulapa ngaṟanyi kutjupa tjuṯangka waintarinytja puḻka mulapa, kaṉa Mayatja Godala tjapini tjukurpa nyanga paluṟu nyuntula utiringkunytjaku nyuntumpa walytjapitingka kuḻu. Ka paluṟu nyuranya wiṟu tjuṯa ungkula pukuḻmankuku, panya nyuntu katja wiṟu mulapa, nyuntumpa kuṯa tjuṯa puṟunypa wiya.” ");
INSERT INTO pjt_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Munu palulanguṟu katja maḻatjangkalta ngapartji wangkangu Pintjimanta nyanga alatji, “Katja, nyuntumpa walytjapiti panya papa inuṟa pikaṯi tjuṯa puṟunypa nyinaku munuya rawangku aṉangu tjuṯa pungkukatira tjanampa mantara munu kutjupa kutjupa tjuṯa tjanampa mantjiṟa katiku.” ");
INSERT INTO pjt_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Alatji Jacobalu wangkangi katja tjuṯangka wati panya 12-ngka. Kaya kuliningi kutju kutjungku, “Munta-uwa nyanga alatjiriku ngayukukunu tjuṯa.” ");
INSERT INTO pjt_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","32","Palulanguṟu katja tjuṯangka wangkara wiyaringkula wangkangu, “Ala, kuwariṉa wiyaringanyi munuṉa pukuḻpa tjunguringanyi miri ngayuku walytja tjuṯangka. Kaṉiya kati Kainantakutu munuṉi tjuṉutjura tjamula mamala pulala itingka kuḻpi panya ngura Makipila, panya ngaṉmanytju payamilaṉu ngayuku tjamungku Aipuṟamalu paluṟu ilunyangka tjuṉutjunkunytjaku. Paluṟu panya payamilaṉu wati ini Ipuṟanta, wati Itjakunungka. Nyara palula panyaya tjuṉutjunu ngayuku tjamu kami Aipuṟamanya Tjiiṟanya pulanya munu maḻangka ngayuku mama ngunytju Isaacanya Ripikanya pulanya kuḻu tjuṉutjunu. Kaṉa ngayulu nyara palula tjuṉutjunu ngayuku panya kuri Liyanya. Ka nyura ngayunya nyara palulaṯu tjuṉutjura kuḻpi panya palula.” ");
INSERT INTO pjt_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Munu Jacobanya katja tjuṯangka wangkara wiyaringkula palulanguṟu kankara ngarikatira wiyaringu. ");
INSERT INTO pjt_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Ka palulanguṟu Josephanya mapalku mamangka punkaṟa ngarikatingu munu palunya ampuṟa mitamita kutjara nyunytjuṉu puḻkaṟa ulara. ");
INSERT INTO pjt_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Munu paluṟu wangkangu palumpa wati waṟka ngangkaṟi tjuṯa palumpa mama mantjiṟa puntu palyantjaku ngula tjuṉutjunkunytjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Kaya mantjiṟa waṟkaringi miri panya palula rawa mulapa tjiṟirpi 40 aṟa. Panya tjakaya Itjipanya nguraṟa tjuṯangku miri ngaṉmanytju palyalpai. Paluṟu tjana nyiṯilpai uwilangka kutjupa kutjupa tjuṯangka kuḻu, munuya karpilpai raikingka rawa palya ngarinytjaku uṉaringkunytjaku-tawara. Kaya alatji Josephaku mama miri palyaṟunguningi. Kaya aṉangu Itjipanya nguraṟa tjuṯa kuḻu Josephala tjanala tjunguringkula tjituṟu-tjituṟurira ulangi tjanampa mamaku rawa mulapa tjiṟirpi 70 aṟa, piṟa kutjara. ");
INSERT INTO pjt_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","5","Palula maḻangka tjana ulara wiyaringkunyangka Josephalu wangkangu Piiṟaku waṟka kutjupa tjuṯangka, “Wiṟu ngana, ankula Piiṟala wangka nyanga alatji, ‘Mamaluṉi ilunytjikitjangku ngaṉmanytju wangkangu palunya ngura nyara Kainanta katira tjuṉutjunkunytjaku. Kaṉa kuliṟa kalkuṉu palumpa katinytjikitjangku, panya ngura nyara palula panya paluṟu ngaṉmanytju ngura palyaṉu kuḻpingka tjuṉutjunkunytjaku. Kaṉi wanyu wiṟungku wantir'iyanma palunya katira tjuṉutjunkunytjaku. Kaṉa palunya tjuṉutjuṟa maḻaku pitjanyi.’ Alatjiya tjapila Piiṟala.” Kaya anu Piiṟalakutu munuya tjapinu Josephaku. ");
INSERT INTO pjt_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Ka Piiṟalu palyanmanu palula ankula wangkanytjaku alatji, “Uwa palya, ma-katiraya tjuṉutjura ngura nyara palula panya nyuntu kalkuntjitjangka.” ");
INSERT INTO pjt_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","8","Ka Josephalu nyangatja kuliṟa mama panya miri mantjiṟa ma-pakaṉu ngura nyara Kainanku palumpa maḻanypa munu kuṯa tjuṯa munu walytja uwankara kuḻu. Palu tjana ngunytju tjuṯa tjitji tjukutjuku tjuṯatjara wantikatingu ngura panya Katjinta, puluka, tjiipi, nanikuta tjuṯa kuḻu. Kaya Piiṟaku maḻpa tjuṯa mayatja panya tjukutjuku tjuṯa kuḻu Josephala tjanala tjunguringkula anu munu wati kuranyitja tjuṯa ngura Itjipala winkinguṟu kuḻu. ");
INSERT INTO pjt_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Ka wati tjaultji tjuṯa kuḻuya anu nyanytjungka tjinkangka tjananya aṯunymankunytjikitja. Alatjiya tjunguringkula anu winki mulapa. ");
INSERT INTO pjt_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Munuya ankula ankula ngula karu panya ini Jordanta kakaraṟa wirkanu manta nyara Kainanta itingka. Munuya ngura tjunkula nyinangi tjiṟirpi 7 ngura panya mai uṉinypa mantjiṟa araṟangkupaingka itingka ini Atatala. Munuya nyinara ngura pala palula puḻkaṟa ulangi Jacobanya-tjiratja. Ka Josephalu mama-tjiratjangku tjituṟu-tjituṟurira inma palyaningi tjiṟirpi kutjupa tjiṟirpi kutjupa 7 aṟangku. ");
INSERT INTO pjt_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Kaya Kainannga nguraṟa tjuṯangku itipikutuṟa nyangangi puḻkaṟa ulara waṉinyangka. Munuya wangkangu, “Ngaḻṯutjara tjuṯaya nyaratja Itjipalanguṟu pitjangu munuya puḻkaṟa ulanyi.” Palulanguṟuya ngura pala palunya ininu Apila Mitjuṟaimanya. Alatjiya ininu tjanampa wangkangka. ");
INSERT INTO pjt_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","13","Kaya ulara wiyaringkula Jacobaku katja tjuṯangku palunya miri ma-katingu ngura panya Makipilakutu munuya nyara palula kuḻpingka tjuṉutjunu kuḻpi panya paluṟu ngaṉmanytju wangkanytjitjangka. (Panya kuḻpi nyara palunya Aipuṟamalu ngaṉmanytju payamilaṉu wati Iitakunungka ini Ipuṟanta palumpa kuri tjuṉutjunkunytjikitjangku.) ");
INSERT INTO pjt_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Palula maḻangkaya Josephanya tjana uwankara maḻaku anu Itjipalakutu. ");
INSERT INTO pjt_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Palu Josephaku kuṯa tjuṯangkuya ngunti kuliningi Josephanya palumpa tjanampa kuraringkunyangka-palku aṟa panyanguṟu, panya palunyaya ngaṉmanytju kuraningi. Munuya mama wiyaringkunyangka kuliningi, “Kuwari-mantilampa maḻanyngampa mirpaṉarikulta nyanga mantangka kutjumpa.” ");
INSERT INTO pjt_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","17","Munu palula tjanalanguṟu wati kutju anu Josephalakutu tjapiṟa kulintjikitja. Munu wirkaṟa alatji wangkangu, “Mamalu panya ngaṉmanytju wangkangu nganaṉala alatji, ‘Nyura kura tjuṯangku iriti Josephaku kuraringkula palunya iyaṉu ngura kutjupakutu. Palu nyura uti Josephala tjapila nyuranya kalypangku wantinytjaku ngapartji pungkuwiyangku.’ Alatji Mamalu nganaṉanya wangkangu. Kala kuwari nyuntula tjapini nganaṉa kura palyantjitjanguṟu kalypangku pungkuwiyangku wantinytjaku. Wanyu nganampa kalyparingama munu ngapartji kulilwiyangku wantima, panya nyuntu nganaṉa Mayatja Godanya waḻkulpai nganampa panya mamangku puṟunytju.” Ka Josephalu kulinu, “Nyaakuṉiya nyangantu tiṯutjarangku nyanga alatji kuliṟa wangkanyi? Ngura iritiṉa kalypangku wantira watarkuringu.” Munu nyanga palunya kuliṟa ulangi. ");
INSERT INTO pjt_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Palulanguṟuya kuṯa panya tjuṯa nguḻu-nguḻu pitjangu Josephalakutu munuya palula kuranyu tultjungaṟakatingu waḻkuntjikitja. Munuya wangkangu, “Nganaṉala pitjangu mani wiyakitja nyuntula waṟkarinytjikitja.” ");
INSERT INTO pjt_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Palu Josephalu wangkangu tjanala, “Wiya, nguḻu wiyaya nyinama. Ngayulu ngapartji nyuranya pungkuwiyangku wantinyi, panya ngayuluṉa Godanya wiya. ");
INSERT INTO pjt_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Nyara Kainanta panya nyuranku ngaṉmanytju walytjangku kulinu ngayunya kuraṟa pungkunytjikitjangku. Palu Godalu aṟa kutjupa kuliṟa palyaṉu nyura ngayunya kuranytjitjanguṟu, munuṉi Itjipalakutu iyaṟa mayatja puḻka tjunu ailuru puḻkangka aṉangu uwankara maingka wankaṟu kanyintjaku. Kaya palulanguṟu kuwari aṉangu uwankara wanka nyinanyi ilunytja wiya. ");
INSERT INTO pjt_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Ala, ngayukuya nguḻuringkunytja wiya nyinama. Ngayulu nyuranya palyanyku kanyilku nyurampa tjitji tjuṯa kuḻu.” Alatji kalypangku wangkara Josephalu tjananya kurunpa rapaṉu, kaya kuliṟa puḻkaṟa pukuḻaringu. ");
INSERT INTO pjt_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","24","Munu nyara palulanguṟu Josephanya rawa nyinangi Itjipala palumpa walytja tjuṯangka tjungu. Ka palumpa katja Ipuṟaimanya tjitji tjuṯatjararingu, ka paluṟu tjana puḻkaringkula tjana ngapartji tjitji tjuṯatjararinguṯu. Ka Josephaku katja kutjupangku Manatjalu katja utinu ini Makirnga, ka paluṟu puḻkaringkula palu puṟunypaṯu tjitji tjuṯatjararingu. Ka Josephalu rawaṯu nyinara nyangangi tjitji nyanga palunya tjananya iṯi ngarinyangka palumpa pakaḻipiti munu kulypalpiti, munu tjananya paluṟu pukuḻṯu ampuṟa kanyiningi. Palulanguṟu yiya tjuṯa nampa 110 nyinanytjatjanungku paluṟu kuṯa tjuṯangka maḻanypangka kuḻu aḻṯira wangkangu, “Alatjiṯultaṉa wiyaringanyilta. Ka nyuranya Godalu rawangkuṯu kanyini munu nyuranya ngula Itjipalanguṟu ma-katinyi ngura panya ngaṉmanytju Aipuṟamanya Isaacanya Jacobanya ungkunytjitjakutu.” ");
INSERT INTO pjt_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Munu Josephalu palumpa walytja tjuṯangka tjapinu tjukaṟurungku kalkuntjaku alatji wangkara, “Ngula Godalu nyuranya ngura panya palulakutu ma-katinyangka miri ngayunya kuḻu ma-katima, munuṉi nyara palula tjuṉutjura. Palya?” Kaya mulapaṯu kalkuṉu katinytjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Ka palulanguṟu paluṟu wiyaringu tjiḻpi mulararira yiya nampa panya 110 nyinanytjatjanu. Ka palumpa walytja tjuṯangku miri palunya nyiṯiṟa palyaṟunguṟa karpiṉu munu pakutjangka tjarpatjunu paṯaṟa ngarinytjaku. ");
INSERT INTO pjt_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","4","Jacobanya, panya ini kutjupa Israelnga, ngura nyara Itjipalakutu ngaṉmanypa anu munu paluṟu palumpa katja tjuṯa kuriṟara kuriṟara katingu ini nyanga palunya tjananya Rupinnga, Tjimiyannga, Levinya, Judah-nya, Itjakanya, Tjipulunnga, Pintjimannga, Dannga, Napatalinya, Kaatanya, Atjanya tjananya. ");
INSERT INTO pjt_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Munuya ankula Josephala tjunguringkula ma-nyinangi ngura panya palula, panya Josephanya ngaṉmanypa ankula nyinanytjitjangka. Munuya tjunguringkula tjuṯa mulapalta nyinangi nampa 70 aṉangu wati panya Jacobalanguṟu kanyintja tjuṯa. ");
INSERT INTO pjt_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Munuya rawa mulapa nyinangi ngura nyara Itjipala. Ka Josephanya munu palumpa kuṯa tjuṯa kuḻu ngula tjiḻpiringkula ilungu ngura nyara palula. ");
INSERT INTO pjt_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Palu nyanga palula tjanalanguṟuya pakaḻipitiku puḻiripitiku katjapiti uṉṯalpiti kuḻu ma-tjuṯaringangi maḻatja maḻatja. Munuya rawa nyinara nyinara tjuṯa mulararingu, munuya manta panya Itjipala lipiwanu alatjiṯu nyinangi aṉangu Israelkunu winki mulapa. ");
INSERT INTO pjt_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Palu ngula mulapalta Itjipanya nguraṟa tjuṯaku mayatja puḻka kutjupa nyinangi ini Piiṟanya panya mayatja ini ngaṉmanyitja puṟunypa. Palu paluṟu ninti wiya Josephaku. ");
INSERT INTO pjt_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","10","Munu mayatja nyanga paluṟu palumpa aṉangu tjuṯangka wangkangu, “Nyawaya aṉangu nyanga Israelkunu tjuṯa! Tjanaya kuwari tjuṯa mulararingu, munuya nganampa ngura angaṉu. Tjinguṟu aṉangu ngura kutjupitja tjuṯa warmaḻa pitjaku nganaṉanya pikangku pungkunytjikitja, ka tjinguṟu nyanga tjana tjanala tjunguringkula tjaṯuringkuku nganampa munuya nganaṉanya pungkuku munuya palulanguṟu tjinguṟu nganaṉanya pungkula wiyaṟa tjana ngura nyanganguṟu ma-pakalku. Wanyula wangkara kulila munula tjukurpa palya wangkara kuliṟa kalkuṟa wanti ngaṉmanytju aṉangu nyanga paluṟu tjana piṟuku ma-tjuṯaringkunytjaku-tawara.” Munuya Piiṟalu tjana wangkara kuliningi, munuya kulinu Israelkunu tjuṯa waṟka puḻka ungkunytjikitjangku tjana unytju wiyakitja rawa waṟkarinytjaku mayatja Piiṟaku. ");
INSERT INTO pjt_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Ka Piiṟalu palumpa wati tjuṯa aḻṯingu munu wangkangu, “Ankulaya wati nyara Israelkunu tjuṯaku nyura mayatjari munu tjananya pauntjingaṟa wituwitunma puḻkaṟa waṟkarinytjaku.” Kaya ankula palunya tjananya mantjiṟa katira puḻkaṟa waṟkarinytjaku wituwituningi waḻi tjuṯangka. Kaya waḻi tawunu puḻka kutjara palyaningi ini panya Pitjamanya munu Ramatjinya wati mayatja Piiṟaku waḻi tjuwa puṟunypa paluṟu ngula mai puḻka uṯuḻuṟa tjunkukatinytjaku. ");
INSERT INTO pjt_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Ka wati panya Itjipanya nguraṟa tjuṯangku tjananya puḻkaṟa alatjiṯu pauntjingaṟa alkaningi aṉangu panya Israelkunu tjuṯa, kaya puḻkaṟa mulapa nguḻu waṟkaringi. Palu tjana rawa alatjiṯu tjitji tjuṯatjararingangi munuya tjuṯa mulararira aḻa lipiwanu alatjiṯu nyinangi ngura panya Itjipala. Kaya Itjipanya nguraṟa tjuṯa tjanampa nguḻu-nguḻuringu, ");
INSERT INTO pjt_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","14","munuya piṟuku tjananya waṟka puḻka mulapalta ungu Israelkunu panya tjuṯa ngaḻṯuringkunytja wiyangku alatjiṯu, kaya puḻkaṟa alatjiṯu waṟkaringi mungawinkinguṟu mungaku-wangkara. Panya paluṟu tjanaya tjuminta palyaningi waḻi tjuṯaku, ka tjara kutjupa uṟilta paama tjuṯangka waṟkaringi, panya ngaḻṯuringkunytja wiyangkuya tjananya pakuningi waṟka puḻkangka. ");
INSERT INTO pjt_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","16","Ka ngula wati panya mayatja Piiṟalu wangkangu minyma panya kutjarangka Tjipuṟala pulala Puwala nyanga alatji, “Ngula nyupali minyma panya Iipuṟu tjuṯa alpamilaṟampa palumpa tjanampa iṯi nyiṯayira wirkankunyangka nyakulampa iṯi nyara palunya mapalkungku iluntara, palu iṯi kungka wirkankunyangkampa palya wantima iluntankunytja wiyangku.” Alatji Piiṟalu pulanya wangkara wituṉu. ");
INSERT INTO pjt_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Palu minyma nyanga paluṟu pula Godala wangaṉarangku kulilpai munu pula mayatja panya Piiṟalu wangkanytja palyantja wiyangku wantingi. Munu pula iṯi nyiṯayira tjuṯa nyinanytjaku wantingi iluntankunytja wiyangku. ");
INSERT INTO pjt_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Ka ngula mayatja Piiṟalu wati kutju iyaṉu ankula minyma panya kutjara aḻṯira ngalya-katinytjaku. Munu wirkankunyangka paluṟu pulala tjapinu, “Nyaanguṟu nyupali nyanga alatji palyaningi? Munu nyupali nyaaku iṯi nyiṯayira tjuṯa wanka nyinanytjaku wantingi?” ");
INSERT INTO pjt_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Ka minyma panya kutjarangku ngapartji Piiṟala wangkangu, “Wiya, minyma nyanga Iipuṟu tjuṯaya minyma Itjipanya nguraṟa tjuṯa puṟunypa wiya, panya tjanaya tjitji iṯi mapalku kanyilpai ngali wirkankunytja kuwaripangka. Kali maḻa wirkankupai iṯi ngaṉmanypa ngarinyangka.” ");
INSERT INTO pjt_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Ka palulanguṟu Godanya palumpa pulampa puḻkaṟa pukuḻaringu, munu pulampa palu puṟunypaṯu palyaṉu tjitji kanyintjakuṯu panya pula Godanya kutju kuliningi munu iṯi Iipuṟu tjuṯa pungkuwiyangku wantingi. Ka panya Iipuṟu tjuṯa ilaṯu-ilaṯu tjuṯa mulararingi. ");
INSERT INTO pjt_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Ka palulanguṟulta Piiṟalu Itjipanya nguraṟa tjuṯangka wangkara puḻkaṟa wituwituṉu, “Nyanganguṟuya iṯi nyiṯayira Iipuṟu tjuṯa wirkankunyangka nyakulampa mantjila munuya ma-katira karu ini Nayilta waṉi uṟu puḻkangka ilunytjaku, munuya kungka tjuṯa kutju wanti wanka nyinanytjaku.” ");
INSERT INTO pjt_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Ka ngura nyara palula wati kutjupa nyinangi wati panya Levilanguṟu. Munu paluṟu kungkawaṟa Leviku walytja maḻatja mulapa aḻṯingu. ");
INSERT INTO pjt_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Ka ngula minyma nyangangku iṯi nyiṯayira kanyinu munu nyakula mukuringu munu kulinu, “Tjitji nyangatja wiṟu mulapa. Ngayulu kuwari kutitjunanyi palunya. Tjinguṟuya nyakula mantjiṟa katira iluntankuku.” Munu piṟa maṉkurpa tjitji panya palunya kutitjuṟa kanyiningi waḻingka unngu kumpilpa. ");
INSERT INTO pjt_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Palu minyma paluṟu puṯu iṯi panya palunya rawangku kutitjuṟa kanyiningi, panya paluṟu tjitji puḻkaringangi. Ka paluṟu piti tjuṉa-tjuṉanguṟu palyantja mantjinu munu kiṯi puṟunypa mantjiṟa aḻa tjuṯangka angatjunu uṟu tjarpanytjaku-tawara. Munu tjitji panya iṯi palunya pitingka ngaritjunu, munu piti panya palunya katira karu panya Nayilta uṟungka tjunu tjuṉa-tjuṉa tjaṯangka unngu kumpilpa. ");
INSERT INTO pjt_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Ka iṯi nyanga palumpa kangkuṟungku kumpiṟa ngaṟala nyangangi paṯunguṟu nyaaringkuku kuwari. ");
INSERT INTO pjt_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Ka ngula mayatja panya Piiṟaku uṉṯalpa uṟukutu pitjangu paltjintjikitja. Ka kungkawaṟa palumpa waṟkaripai maṉkurpa kuḻu pitjangu, munuya paluṟu tjarpanyangka uṟungka itingka para-ngaṟangi. Palu Piiṟaku uṉṯaltu uṟungka tjarpara tjarpara nyangu piti panya tjitjitjara ukiṟi unngu ngaṟanyangka, munu kungka palumpa waṟkaripai kutju wituṟa iyaṉu ankula mantjiṟa ngalya-katinytjaku. Ka ankula uṟunguṟu mantjinu munu katira ungu. ");
INSERT INTO pjt_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Ka paluṟu aḻaṟa nyangu iṯi panya kuḻunypa ngarira ulanyangka. Munu paluṟu ngaḻṯuringu palumpa munu kuliṟa wangkangu, “Nyangatja tjitji Iipuṟu.” ");
INSERT INTO pjt_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Ka iṯi panya palumpa kangkuṟungku kumpiṟa ngaṟanytjatjanungku ngalya-utiringkula wangkangu Piiṟaku panya uṉṯalta, “Nyuntu mukuringanyi ngayulu ankula minyma Iipuṟu kutju aḻṯinytjaku iṯi nyanga palunya kanyiṟa puḻkantjaku nyuntumpa?” ");
INSERT INTO pjt_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Ka wangkangu, “Uwa, ankula aḻṯi!” Ka kuliṟa mapalku anu munu iṯiku panya ngunytju mantjinu, munu aḻṯira ngalya-katingu Piiṟaku panya uṉṯalpakutu. ");
INSERT INTO pjt_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Ka paluṟu wangkangu iṯiku panya ngunytjungka, “Iṯi nyangatja kati ngurakutu munutju ipi ungkula puḻkala, kaṉanta payamilalku nyuntu ngayuku kanyiṟa puḻkannyangka.” Ka mulapaṯu katingu iṯi panya palunya ngurakutu munu kanyiṟa puḻkaṉu palumpa. ");
INSERT INTO pjt_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Ka ngula tjitji panya puḻkaringkunyangka ngunytjungku panya katingu Piiṟaku uṉṯalpakutu. Ka tjitji panya paluṟu palumpa katjaringu. Ka paluṟu wangkangu, “Tjitji nyanga palunyaṉa uṟunguṟu panya mantjinu. Palulanguṟuṉa palunya inini Mosenya.” ");
INSERT INTO pjt_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Ka ngula Mosenya puḻkaringkula watiringu, munu kuliningi palumpa walytja tjuṯa ankula nyakunytjikitjangku, munu paluṟu anu Iipuṟu tjuṯakutu munu tjananya puḻkaṟa waṟkarinyangka nyangangi. Munu paluṟu nyangu wati Itjipanya nguraṟa kutjungku wati Iipuṟu puḻkaṟa pungkunyangka. ");
INSERT INTO pjt_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Munu Moselu para-anganyakula nyangu, “Munta, wiyampal nyangatja ngaṟanyi. Kaṉa kuwari ngayulu ngapartji pungkula iluntara.” Munu mulapa paluṟu wati panya Itjipanya nguraṟa pungkula iluntaṟa tjawaṟa mantangka tjuṉutjunu munu palulanguṟu ngurakutu anu. ");
INSERT INTO pjt_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Munu tjiṉṯungka paluṟu piṟuku anu palumpa walytja tjuṯakutu munu nyangu wati Iipuṟu kutjarangku pulanku pikangku pungkunyangka. Munu kutjungka tjapinu, “Ai! Nyaakun punganyi walytja nyuntumpa?” ");
INSERT INTO pjt_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Ka paluṟu ngapartji wangkangu, “Nyaakulinyan wangkanyi? Nyuntun wanyu nganampa mayatja? Tjinguṟu nyuntu kulini piṟuku ngayunya ngapartji pungkula iluntankunytjikitjangku panya mungartjitja puṟunypa.” Ka Moselu alatji wangkanyangka kuliṟa nguḻuringu munu kulinu, “Munta-uwa! Tjinguṟuya uwankara ninti panya ngayulu palyantjitjaku.” ");
INSERT INTO pjt_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","16","Ka mayatja panya Piiṟalu kulinu Moselu pungkunytja munu palumpa tjaultji tjuṯa wituṉu Mosenya nguriṟa iluntankunytjaku. Palu Moselu nyangatja kulinu munu mayatja panya palulanguṟu kumpiṟa wirtjapakaṉu ngura pararikutu ngura ini Mitiyantakutu, munu ngura nyara palula wirkaṟa paluṟu mina piṯingka itingka nyinakatira pakuwiyaringangi. Ka ngura nyara palula itingka wati kutjupa nyinangi ini Tjitjaṟunya. Paluṟu panya uṉṯalpa 7-tjara, munu paluṟu aṉangu ngura Mitiyannga nguraṟa tjuṯaku tjukurtjara nyinangi. Kaya palumpa uṉṯalpa tjuṯangku mamaku tjiipi, nanikuta tjuṯa mina piṯi palulakutu ngalya-katingi mina ilaṟa piti tjuṯangka tjutintjikitjangku kuka tjuṯaku. ");
INSERT INTO pjt_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Palu aṉangu tjiipi kanyilpai kutjupa tjuṯaya maḻawanu wirkanu munuya tjananya paiṟa iyaṉu. Palu Mosenya painnyangka nyakula pakaṉu munu anga-ngaṟala markuṟa wangkangu, “Nguḻuringkuwiyaya ngaṟama ka ngayulu nyurampa kuka tjuṯa mina ungkuku.” Munu paluṟu mina tjutinu kuka tjuṯangku tjikintjaku. Kaya palulanguṟu ngurakutu maḻaku anu kungkawaṟa panya tjuṯa. ");
INSERT INTO pjt_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Ka ngurangka wirkankunyangka palumpa tjanampa mamangku tjananya tjapinu, “Nyaaku nyura mapalku pitjangu? Panya nyura mungartji nguwanpa pitjapai, palu kuwari nyanga nyura mapalku pitjangu. Nyaaringkula?” ");
INSERT INTO pjt_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Kaya wangkangu, “Wiya, wati panya tjiipi kanyilpai tjuṯaya piṟuku pitjangu munulanya painingi. Palu wati Itjipanya nguraṟangkulanya alpamilaṉu wiṟungku, munulampa kuka tjuṯa mina ungu mina piṯinguṟu ilaṟa.” ");
INSERT INTO pjt_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Ka paluṟu tjapinu tjanala, “Yaaltji wati paluṟu? Nyaanguṟu nyura wantikatingu? Ankulaya aḻṯira ngalya-kati, ka nganaṉala tjunguringkula mai ngalkula.” Kaya ankula Mosenya aḻṯingu, ka pitjala tjanala tjunguringkula mai ngalkuṉu. ");
INSERT INTO pjt_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Ka nyanga palula maḻangka Tjitjaṟulu Mosenya markuṉu palumpa ngurangka nyinanytjaku. Ka Moselu palya kulinu munu palula nyinangi. Ka Tjitjaṟulu palumpa uṉṯalpa kutju ungu Mosenya ini Tjipuṟanya paluṟu aḻṯinytjaku. ");
INSERT INTO pjt_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Ka paluṟu pula ngula tjitji katja kanyinu. Ka Moselu palunya ininu Kaatjamanya, panya paluṟu kuliningi, “Ngayulu kuwari malikitja nyinanyi ngura tjanampangka. Palulanguṟuṉa iṯi palunya ini tjunkuku Kaatjamanya.” ");
INSERT INTO pjt_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Ka ngula mulapalta ngura panya Itjipala tjanampa panya mayatja puḻka ilungu ini panya Piiṟanya. Palu panya Itjipanya nguraṟa tjuṯangku tjananya rawangku puḻkaṟa alatjiṯu waṟkamilaningi Israelkunu panya tjuṯa. Kaya rawa alatjiṯu puḻkaṟa waṟkarira waṟkarira paku puḻkaringkula kurunpa uḻiringu, munuya puṯu kuliṟa Godala ulara ngatjiningi tjanampa ngaḻṯuringkula tjananya wankaṟunkunytjaku. ");
INSERT INTO pjt_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Ka Godalu kulinu tjana ulara ngatjinnyangka munu panyatja kulinu panya paluṟu iriti Aipuṟamanya Isaacanya Jacobanya tjananya kalkuṉu aṯunymankunytjikitjangku, munu aṉangu tjanalanguṟu tjuṯaringkunytja maḻatja maḻatja tjuṯa kuḻu kalkuṉu. ");
INSERT INTO pjt_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Uwa, Godalu nyangu tjananya Israelkunu tjuṯa puḻkaṟa waṟkarinyangka, munu paluṟu kurunpa puḻkaṟa ngaḻṯuringu tjanampa ngura panya Itjipala nyinara ulanyangka. ");
INSERT INTO pjt_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Ka Moselu wati panya palumpa waputjuku Tjitjaṟuku tjiipi nanikuta tjuṯa aṯunymankupai. Wati Tjitjaṟunya panya tjukurtjara nyinangi aṉangu panya Mitiyannga nguraṟa tjuṯaku. Ka tjiṟirpi kutjupa Moselu kuka panya palunya tjananya ilytjingka katiṟinangi munu paluṟu tjananya parari katingu pilangka munkarakutu. Munu wirkanu puḻi waṟa ini Tjaniyala. Puḻi nyanga paluṟu panya miḻmiḻpa Godaku. ");
INSERT INTO pjt_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Ka nyara palula Mayatja Godaku angelpa utiringu Mosela, ka paluṟu nyangu puṉu puḻkuṉpa tilingaṟanyangka. Ka waṟu tili puḻka pakaningi puṉunguṟu, palu puṉu nyara palunya kampara wiyantja wiya wankaṯu ngaṟangi. ");
INSERT INTO pjt_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Ka Moselu nyakula kuliningi, “Ai! Yaaltji-yaaltji puṉu kutju alatjiṯu rawa tilingaṟanyi kampara wiyaringkunytja wiya? Wanyu kaṉa ila ara puṉu nyanga ayinayini nyakunytjikitja.” ");
INSERT INTO pjt_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Ka Mayatja Godalu nyangu Mosenya puṉu nyakunytjikitja ngalya-ilaringkunyangka munu parka panya tilitjaranguṟu palula wangkangu, “Mose! Mose!” Ka paluṟu wangkangu, “Uwa, kuliniṉanta.” ");
INSERT INTO pjt_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Ka Godalu wangkangu, “Piṟuku ngalya-paḻtjuntja wiya. Manta miḻmiḻpa nyangatja nyanga nyuntu ngaṟanytjanya, kanku tjinatja pala araltjara. ");
INSERT INTO pjt_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Panya ngayuluṉa God nyuntumpa mamaku, munu Aipuṟamaku, Isaacaku, Jacobaku kuḻu.” Ka Mosenya kuliṟa puḻkaṟa nguḻuringu mununku kuṟungka maṟa angatjunu Godanya nyakunytjaku-tawara. ");
INSERT INTO pjt_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Ka palulanguṟu Godalu wangkangu palula, “Ngayulu nyangu tjananya ngayuku panya aṉangu tjuṯa, panya tjana pika puḻkatjara pungkunytja pungkunytja. Panya Itjipanya nguraṟa tjuṯangku tjananya rawangku pungkula waṟkamilaṟa pakuṉi. Kaṉa tjananya kulinu puḻkaṟa kaar-kaararira ulara ngatjinnyangka ngayulu tjananya wankaṟunkunytjaku, munuṉa kuliṟa tjanampa ngaḻṯuringu. ");
INSERT INTO pjt_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Palulanguṟuṉa kuwari ilkaṟinguṟu pitjangu tjananya pakaltjingaṟa katinytjikitja ngura nyara palulanguṟu. Munuṉa tjananya kuranyurira katiṟinkuku ngura wiṟukutu aḻa lipikutu mai puḻkatjarangka nyinanytjaku. Palu ngura nyara palulawanu panya aṉangu kutjupa kutjupa tjuṯa kuwari nyinara waṉaṉi, aṉangu nyanganpa – Kainankunu tjuṯa, Iitakunu tjuṯa, Amurkunu tjuṯa, Piṟitjikunu tjuṯa, Ipakunu tjuṯa, munu Tjaipukunu tjuṯa kuḻu. ");
INSERT INTO pjt_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Uwa, ngayulu kulinu Israelkunu tjuṯangku ngayula ulara ngatjinnyangka, munuṉa mulapa nyangangi Itjipanya nguraṟa tjuṯangku tjananya puḻkaṟa waṟkamilaṟa pakunnyangka. ");
INSERT INTO pjt_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Palulanguṟuṉa kuwari nyuntunya wituṉi mayatja panya Piiṟalakutu ankunytjaku. Ka nyuntu ara munu ngayuku aṉangu tjuṯa Itjipalanguṟu pakaltjingaṟa ngalya-kati.” Alatji Mayatja Godalu Mosela wangkangu. ");
INSERT INTO pjt_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Ka paluṟu ngapartji wangkangu, “Nyaakuṉin ngayunya wituṉi? Panya ngayulu wati tjukutjuku mayatja wiya. Yaaltjingaṟaṉa mayatja puḻkangka ankula wangkaku? Munuṉa yaaltjingaṟa nyanga Israelkunu tjuṯa Itjipalanguṟu pakaltjingalku?” ");
INSERT INTO pjt_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Palu Godalu palula wangkangu, “Ngayuluṉa nyuntula tjungu ankuku. Ka mulapa nyuntu aṉangu tjuṯa Itjipalanguṟu pakaltjingaṟa ngura nyangakutu ngalya-katiku, munu nyura ngayunya puḻi nyanga palula tjungungku waḻkulku. Kan nyanga palulakutu maḻaku wirkaṟa kulilku, ‘Munta-uwa, mulapa panya ngayunya Godalu wangkangu puḻi nyanga palula wirkaṟa palunya waḻkuntjaku.’” ");
INSERT INTO pjt_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Ka Moselu tjapinu Godala, “Tjinguṟu ngayulu ankuku Israelkunu tjuṯakutu munuṉa tjanala wangkaku, ‘Nyurampa mama tjuṯangku panya Godanya waḻkuningi, kaṉi God panya paluṟu ngayunya wangkara wituṉu nyuralakutu nyuranya ngura nyanga palulanguṟu katinytjaku.’ Kaya nyangatja kuliṟa tjinguṟu tjana ngayunya tjapilku, ‘Ini ngananya wanyu God paluṟu?’ Kaṉa yaaltji wanyu wangkaku tjanala?” ");
INSERT INTO pjt_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Ka Godalu wangkangu Mosela, “Ngayuluṉa panya paluṟu ngayulu alatjiṯu Tiṯutjara Nyinapainya. Ka nyuntu aṉangu Israelkunu tjuṯakutu ankulampa nyanga alatji tjakultjura tjanala, ‘Mayatja panya Tiṯutjara Nyinapailuṉi wituṟa iyaṉu nyuralakutu.’ ");
INSERT INTO pjt_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","16","Munu piṟuku tjanala alatji wangka, ‘Paluṟu panya Mayatja Godanya nyurampa tjamu kami ngaṉmanyitja tjuṯaku munu panya Aipuṟamaku, Isaacaku, Jacobaku God kuḻu. God panya paluṟuṉi wituṉu nyuralakutu, ini panya paluṟu panya Mayatja Godalu. Ka nyura ngayunya alatji waḻkunma Mayatjanya.’ Alatji tjanala tjakultjura. “Uwa, ankula wati Israelkunu puḻka tjuṯa aḻṯira uṯuḻura, munu tjanala tjakultjura ngayulu nyuntula utiringkunytja munu tjanala wangka panya ngayulu nyuntula wangkanytja. Munu piṟuku tjanala wangka alatji, ‘Mayatja Godalu panya nyuranya nyangangi Itjipanya nguraṟa tjuṯangku rawangku puḻkaṟa waṟkamilaṟa pakunnyangka munu pungkunyangka kuḻu. ");
INSERT INTO pjt_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Palulanguṟuṉa nyuranya rawangku kurantjaku-tawara ngura nyara Itjipalanguṟu pakaltjingalku, munuṉa nyuranya ngura panya wiṟu mularkutu katiku mai puḻkangka pukuḻpa nyinanytjaku. Palu ngura nyara palulawanu panya aṉangu kutjupa kutjupa tjuṯa kuwari nyinara waṉaṉi, aṉangu nyanganpa – Kainankunu tjuṯa, Iitakunu tjuṯa, Amurkunu tjuṯa, Piṟitjikunu tjuṯa, Ipakunu tjuṯa, munu Tjaipukunu tjuṯa kuḻu.’ ");
INSERT INTO pjt_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Alatji tjanala tjakultjura wati puḻka tjuṯangka, kaya nyuntula kulilku nyuntu wangkanyangka. Ka palulanguṟu nyuntu palula tjanala tjunguringkula Itjipaku mayatjakutu ara Piiṟalakutu, munuya palula wangka nyanga alatji, ‘Mayatja Godanya nganaṉala utiringu panya Iipuṟu tjuṯaku God, munu panya paluṟu mukuringanyi nganaṉa uwankara ilytjikutu ankunytjaku tjiṉṯu maṉkurpa, kala ngura palula kuka pungkula tiliwakaṟa palunya ungkuku nganampa Godanya paluṟu nganampa pukuḻarinytjaku. Palyala ankuku?’ Alatji nyura palula wangka Itjipaku mayatjangka. ");
INSERT INTO pjt_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Palu ngayulu nintingku kulini panya mayatja nyara paluṟu nyuranya wantir'iyantja wiyangku wantiku. Palu ngayuku witulya puḻkangku kutju palunya kampa kutjupankuku nyuranya wantir'iyantjaku. ");
INSERT INTO pjt_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Panya ngayulu kampa kutjupa palyalku Itjipanya nguraṟa tjuṯaku munuṉa kutjupa kutjupa tjuṯa witulya puḻkangku palyalku ngura nyara palula tjana nyakula ngayuku nguḻuringkunytjaku, ka nyanga alatji palyannyangka nyakula mayatja panya Piiṟalu nyuranya wantir'iyalku. ");
INSERT INTO pjt_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Munuṉa tjananya Itjipanya nguraṟa tjuṯa kurunpa kampa kutjupankuku tjana wangaṉararingkula nyuranya kutjupa kutjupa tjuṯa ungkunytjaku wiṟu tjuṯa nyura maṟalpa ankunytjaku-tawara. ");
INSERT INTO pjt_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Ka minyma Iipuṟu kutju-kutjungku minyma Itjipanya nguraṟa tjuṯangka ngatjilku. Kaya ungkuku mantara tjuṯa munu liringka miṉangka tjunkupai tjuṯa kuḻu panya gold-nguṟu tjiilpanguṟu palyantja wiṟu mulapa, munuya kutjupa kutjupa wiṟu tjuṯa kuḻu nyuranya ungkuku. Ka nyanganpa uwankara nyura katjangka uṉṯalta tanpalku munu nyura mantara panya wiṟu tjuṯangka tjarpara ankuku. Alatji nyura ma-katiku Itjipalanguṟu tjanampa panya wiṟu kutjupa kutjupa uwankara.” Alatji Godalu Mosela wangkangi. ");
INSERT INTO pjt_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Ka Moselu ngapartji wangkangu, “Palu tjinguṟuya wati Israelkunu tjuṯa ngayuku puṯu mulamularingama. Munuya tjinguṟu paluṟu tjana ngayunya kuliṟa wantima munuya wangkaku, ‘Mayatja Godanya nyuntula utiringkunytja wiyaṯu.’ Kaṉa yaaltjiriku tjana ngayunya kuliṟa wantinyangkampa?” ");
INSERT INTO pjt_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Ka Godalu tjapinu Mosela, “Nyaan maṟangku pala kanyini?” Ka wangkangu, “Nyangatja ngayuku tjukara.” ");
INSERT INTO pjt_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Ka Godalu wangkangu, “Mantangka waṉi.” Ka Moselu waṉingu mantangka. Ka panya paluṟu liruringu. Ka Mosenya liru panya nyakula nguḻu ma-wirtjapakaṉu. ");
INSERT INTO pjt_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Ka Godalu wangkangu Mosela, “Wipu witiṟa katula.” Ka Moselu pitjala wipu witiṟa katuṉu, ka liru panya wipu witiṟa kanyinnyangka maḻaku puṉuringu. ");
INSERT INTO pjt_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Ka Godalu palula wangkangu, “Nyuntu nyanga alatji palyannyangka nyakula tjana mulapa kulilku panya ngayuluṉa Mayatja Godalu nyuntula wangkangu, panya Aipuṟamaku, Isaacaku, Jacobaku tjanampa Godalu.” ");
INSERT INTO pjt_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Munu piṟuku Godalu Mosela wangkangu, “Maṟanku tjarpatjura mantara unngu.” Ka Moselu maṟa tjunu mantara unngu munu ilaṟa nyangu maṟa latjaringkunytja pika panya piṟanpa tjuṉpa puṟunypa. ");
INSERT INTO pjt_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Ka Godalu piṟuku wangkangu, “Maṟanku maḻakungku tjarpatjura mantara unngu.” Ka Moselu piṟuku maṟa tjarpatjunu munu ilaṟa nyangu maṟa palyaringkunytja pika wiya. ");
INSERT INTO pjt_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Ka Godalu wangkangu, “Tjinguṟu tjana puṯu mulamularingkuku liru panya nyakunytjatjanu, ka nyangatja piṟuku nintila tjanala, kaya nyakula nyanga palulanguṟu mulamularingkuku ngayulu nyuntula wangkanytjitjaku. ");
INSERT INTO pjt_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","“Ka nyanga kutjaranguṟu tjinguṟu tjana rawaṯu mulamularingkunytja wiyangku wantinyangkampa piṟuku kutjupa tjanala nintila. Kapi pitingka tairakala karu ini Nayiltanguṟu munu mantangka pupatjura, ka kapi paluṟu milkaḻiriku mantangka pupatjunkunyangka.” ");
INSERT INTO pjt_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Palu Moselu ngapartji Godala wangkangu, “Wiya Mayatja, ngayunya iyantja wiyangku wantima. Ngayulu puḻkaṟa wangkapai wiya tjaa paṟir-paṟirpa puṯu nguwanpa wangkapai, munuṉa kuwari nyanga nyuntula miṟangka ngaṟala ngaṟala puḻkaṟa wangkapairingkunytja wiyaṯu. Ngayulu purkaṟangku kuliṟa wangkapai, palya wiya nguwanpa.” ");
INSERT INTO pjt_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Ka Godalu wangkangu palula, “Nganalu wanyu watiku tjaa palyaṉu? Munu nganalu wanyu aṉangu pina patilpai kulintjaku wiya, munu tjaa patilpai wangkanytjaku wiya. Nganalu wanyu kuṟu aḻalpai nyakunytjaku, munu kuṟu patilpai nyakunytjaku wiya? Panya ngayulu kutjungkuṉa palyalpai. ");
INSERT INTO pjt_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Ka nyuntu ara munu tjanala wangka! Kaṉa ngayulu nyuntunya alpamilalku munuṉanta nintilku tjanala tjukaṟurungku wangkanytjaku.” ");
INSERT INTO pjt_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Ka Moselu tungunpungkula piṟuku wangkangu Godala, “Wiya ngayulu wantinyi. Wanyu wati kutjupa iyala.” ");
INSERT INTO pjt_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Ka nyanganguṟu Godanya puṯu wangkara Moseku mirpaṉaringu munu palula wangkangu, “Palu nyuntumpa kuṯampa Aaronnga. Nyara paluṟu panya wati Levikunu munu paluṟu wiṟuṟa puḻkaṟa wangkapai. Kuwari nyanga paluṟu nyuntulakutu pitjanyi, munu nyuntunya nyakula puḻkaṟa pukuḻariku. ");
INSERT INTO pjt_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","16","Ka ngayulu nyupalila tjungu nyinaku munuṉa nyupalila nintilku tjukurpa ngayuku aṉangu tjuṯangka wangkanytjaku. Panya ngayulu nyuntula-waraṟa wangkaku, ka nyuntu ngapartji palula wangka, ka paluṟu nyuntula kuliṟa aṉangu tjuṯangka ngapartji tjakultjunkuku nyuntumpa panya wangka. Ngayulu alatjiṯu nyupalinya uwankara nintilku tjukaṟurungku palyantjaku. ");
INSERT INTO pjt_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Palu tjukara nyanganku katima, panya nyuntu puṉu nyanga palula witulyangku palyalku kutjupa kutjupa tjuṯa.” Alatji Mayatja Godalu Mosenya wangkara wituṉu. ");
INSERT INTO pjt_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Ka Mosenya maḻaku anu Tjitjaṟulakutu palumpa panya waputjukutu. Munu tjapinu palula alatji wangkara, “Palyaṉa ankuku Itjipalakutu maḻaku ngayuku walytja tjuṯakutu. Mukuringanyiṉa tjananya nyakunytjikitja, tjinguṟuya wankaṯu nyinanyi.” Ka Tjitjaṟulu wangkangu, “Wiya palya, ara! Kaṉa Godala tjapilku nyuntunya aṯunymankunytjaku.” ");
INSERT INTO pjt_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Ka panya Mosenya ankunytjikitja kulinnyangka Godalu wangkangu palula, “Maḻaku ara Itjipalakutu panya nyuntunya iluntankunytjikitja mukuringkunytja tjuṯaya ilura uwankara wiyaringu.” ");
INSERT INTO pjt_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Ka Moselu palumpa kuri katja kutjara tangkiyingka tatitjunu munuya ma-pakaṉu wiluṟara Itjipaku. Ka Mosenya tjina anangi tjukaratjara panya Godalu wangkangu katinytjaku tjukara panya palunya. ");
INSERT INTO pjt_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Munu piṟuku Godalu wangkangu Mosela, “Nyuntu Itjipala maḻaku wirkaṟa maṉkurpa panyatja watarkuriwiyangku kulinma mayatja puḻka Piiṟala miṟangka witulya puḻkatjarangku palyantjikitjangku. Palu ngayulu mayatja panya Piiṟanya unngu wituwitulku Israelkunu tjuṯa wantir'iyantja wiyangku tungun-tunguntu kanyintjaku. ");
INSERT INTO pjt_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Ka nyuntu palulanguṟu Piiṟala tjakultjura tjukurpa nyanga ngayulu kuwari nyuntula wangkanytja alatji, ‘Nyuntu panya nyuntumpa katja ngaṉmanyitjaku puḻkaṟa mukuringkupai, palu puṟunypa ngayulu aṉangu Israelkunu tjuṯaku puḻkaṟa mukuringanyi. ");
INSERT INTO pjt_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Ka panya ngayulu nyuntula wangkangu tjananya wantir'iyantjaku paluṟu tjana ankula ngayunya waḻkuntjaku, palu nyuntu wantingu tjananya iyantja wiyangku. Palulanguṟuṉa kuwari ngapartji nyuntumpa katja ngaṉmanyitja iluntananyi.’ Uwa, tjukurpa nyanga palunya ngula Piiṟala tjakultjura!” ");
INSERT INTO pjt_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Ka Mosenya pula kuriṟara tjitjitjara anangi ngura nyara Itjipalakutu. Munu pula nguṟurpa ngura kutjupangka ngura tjunu mungaringkunyangka ngarinytjikitjangku. Ka Mayatja Godanya Mosela tjunguringu munu palunya arkaṟa pikantanangi iluntankunytjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","26","Ka palulanguṟu Moseku miitangku Tjipuṟalu palumpa katja nyiiṉkarinyangka nyakula palunya ngunytjungkuṯu watiṉu munu watintjatjanungku mantjiṟa Mosenya tjina pampuṉu wangkara, “Nyuntun ngayuku kuri milkaḻitja.” Alatji paluṟu wangkangu panya katja palumpa watintjatjanungku. Ka pala palulanguṟu Mayatja Godalu Mosenya wantingu iluntankuwiyangku. ");
INSERT INTO pjt_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Ka nyara palula aṟa Mayatja Godalu Moseku kuṯangka Aaronta Itjipala nyinanyangka wangkangu alatji, “Pakaṟa ara kakaraṟa ilytjikutu munu nyuntumpa maḻanypaku ngaparikati.” Ka palulanguṟu wati panya Aaronnga pakaṟa anu munu pula maḻanykira ngaparku tjunguringu puḻi panya puḻkangka Tjaniyala Godaku panya puḻingka. Munu pulanku pukuḻarira ampuṟa mitamita kutjara nyunytjuṉu. ");
INSERT INTO pjt_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Ka Moselu kuṯangka tjakultjunangi uwankara Godalu palula wangkanytja puḻi nyara palula, panya palunya wituntja ngura panya Itjipalakutu. Munu paluṟu tjakultjunangi panya maṉkurpa Godalu palunya nintinu witulya puḻkangku palyantjaku. ");
INSERT INTO pjt_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Munu pula tjunguringkula anu ngura panya Itjipalakutu. Munu pula wirkaṟa wati panya Israelkunu puḻka tjuṯa aḻṯira tjunguṉu. ");
INSERT INTO pjt_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Ka tjana tjunguringkunyangka Aarontu tjanala tjakultjunangi Godalu Mosela uwankara wangkanytja. Ka Moselu tjanala miṟangka maṉkurpa panya witulyangku palyaṉu tjana nyakula urulyarantjaku, puṉu panya tjukara liruringkunytja munu maṟa latjaringkunytja munu mina uṟu milkaḻirinytja. ");
INSERT INTO pjt_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Kaya wati panya puḻka tjuṯangku nyakula mulamularingu nyanga alatji palyannyangka. Munuya Moselu pula wangkanyangka kuliningi, “Munta-uwa, mulapa Godanya nganampa ninti nyinanyi, munu paluṟu nyanganyi Itjipanya nguraṟa tjuṯangku nganaṉanya kurannyangka.” Munuya palulanguṟu kuliṟa pukuḻṯu Mayatja Godanya pupakatira waḻkuningi. ");
INSERT INTO pjt_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Ka maḻangka aṉangu tjuṯangka wangkara wiyaringkula Mosenya pula Aaronnga Itjipaku mayatja puḻkakutu anu Piiṟalakutu palula wangkanytjikitja munu pula wirkaṟa wangkangu nyanga alatji, “Israelkunu tjuṯaku Mayatja Godalu ngalinya wituṉu alatji puḻkaṟa wangkanytjaku nyuntula, ‘Ngayuku aṉangu tjuṯa wantir'iyanma tjana ilytjikutu ankula ngayunya waḻkuntjikitjangku inma puḻka palyantjaku.’” ");
INSERT INTO pjt_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Palu mayatja panya Piiṟalu kuliṟa wiyanmanu wangkara, “Palu ngananya wanyu mayatja paluṟu? Ngayulu palumpa ngurpa. Nyaakuṉa palula kulilku munuṉa wantir'iyalku Israelkunu tjuṯa? Ngayulu palula kulilwiyangku wantinyi, munuṉa palunya tjananya wantir'iyantja wiyangku wantinyi.” ");
INSERT INTO pjt_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Ka pula palula wangkangu, “Wiya, Mayatja Godalu, panya aṉangu Iipuṟu tjuṯaku Godalu, ngalila mulapa utiringkula wangkangu. Palulanguṟu nganaṉanya kanyintja wiyangku wantir'iyanma tjiṟirpi maṉkurpa ankunytjaku ilytjikutu, kala nganaṉa kuka pungkula tiliwakaṟa Mayatja nganampa Godanya ungkuku paluṟu nganampa pukuḻarinytjaku. Palu nganaṉa tjinguṟu ankuwiyangku wantinyangkampa paluṟu nganaṉanya iluntankuku pika kutjupa kutjupa tjuṯa iyaṟa, munta tjinguṟulampa warmaḻa tjuṯa iyalku, kalanya iluntankuku.” ");
INSERT INTO pjt_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","5","Palu wati panya Piiṟalu pulala wangkangu, “Wiya, nyaaku nyupali Iipuṟu tjuṯa wangkanyi waṟka wantikatira ilytjikutu ankunytjaku? Panya kuwariya tjuṯa mulararingu munuya nganampa waṟka puḻka palyaṉi, kaṉa tjananya wantir'iyantja wiyangku wantinyi. Maḻaku pula ara munu tjananya piṟuku puḻkaṟa waṟkarinytjaku wangka.” Ka pula puṯu tjapiṟa anu. ");
INSERT INTO pjt_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","7","Ka pula ankunyangka maḻangka Piiṟalu aḻṯingu wati panya paluṟu mayatja tjunkunytja tjuṯa munu tjanala wangkangu alatji, “Nyura panya Israelkunu tjuṯa pauntjingaṟa wituwitulpai nganampa puḻkaṟa waṟkarinytjaku. Munu panya nyura ilintji piḻṯi tjuṯa ungkupai tjana tjuḻpirta tjunguṟa tjuminta wituwitu palyantjaku. Palu kuwariya tjananya wantima ungkuwiyangku, kaya walytjangku nguriṟa mantjinma. ");
INSERT INTO pjt_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Palu tjana uti tjuminta tjuṯa rawangku palyanma nampa panya palunyaṯu, panya ngaṉmanytjuya palyaningi, palu puṟunypa. Ka nyura maṉkurpa palyannyangka pukuḻarinytja wiyangku wantima, panya nyura alatjingannyangkaya aṉangu pala waṟka tjuṯa ma-nyaṯaringu munuya palulanguṟu tjana waṟka wantira ngayula rawangku ngatjini tjananya ilytjikutu wantir'iyantjaku tjana kuka pungkula tjanampa God ungkunytjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Ka palula-tawara nyura tjananya puḻkaṟa alatjiṯu waṟkamilanma tjana ngurangka waṟka wiya nyinara tjukurpa ngunti kulintjaku-tawara Moselu wangkanyangka.” Alatji Piiṟalu tjananya wituwituṉu wati panya mayatja tjuṯa. ");
INSERT INTO pjt_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","11","Kaya paluṟu tjana kuliṟa ankula Israelkunu tjuṯangka wangkangu, “Mayatja Piiṟalu wangkangu nganaṉa piṟuku nyuranya ukiṟi ilintji piḻṯi tjuṯa ungkuwiyangku wantinytjaku munu nyuranya wangkangu walytjangku ankula para-nguriṟa mantjintjaku. Palu nyura kunyu tjiṟirpi kutjungka tjuminta nampa panya palu puṟunypaṯu palyanma, panya nyura ngaṉmanytju tjiṟirpi kutjungka tjuṯa mulapa palyaningi, palu puṟunypa.” ");
INSERT INTO pjt_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Kaya nyangatja kuliṟa Israelkunu tjuṯa anu ngura panya Itjipala uwankarangka munuya para-nguriningi ukiṟi panya ilintji piḻṯiku. ");
INSERT INTO pjt_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Kaya wati panya mayatja tjuṯangku tjananya puḻkaṟa alatjiṯu wituwituningi waṟka puḻka palyantjaku. Munuya wangkangu, “Nyura uti tjuminta tjuṯa palyaṟampa panya ngaṉmanyitja puṟunypa palyanma tjuṯa mulapa, panya ngaṉmanytjula nyuranya ukiṟi ilintji piḻṯi tjuṯa ungangi, ka panya nyura tjuṯa mulapa palyaningi, palu puṟunypaya tjuṯa palyanma.” ");
INSERT INTO pjt_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Palu puṯuya palyaningi, kaya Piiṟalu panya mayatja tjunkunytjitja tjuṯangku tjananya pungangi wati panya Israelkunuku mayatja tjuṯa, panya wati palunya tjananyaya aṉangu Israelkunu tjuṯanguṟu ngaṉmanytju ngurkantaṟa tjunu tjanampa walytja tjuṯa mayatjarira waṟkamilantjaku. Kaya Piiṟalu mayatja tjunkunytjitja tjuṯangku palula tjanala wangkangu nyanga alatji, “Ai! Nyurampa walytja tjuṯangku palyantja wiya tjuminta tjuṯa mulapa, nampa panya ngaṉmanytju tjana palyantjitja puṟunypa. Nyaanguṟu? Utiya panya palu puṟunypaṯu tjuṯa palyanma, maṉkurpa wiyangku.” ");
INSERT INTO pjt_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","16","Kaya wati panya Israelkunuku mayatja tjuṯa anu Piiṟalakutu munuya wirkaṟa wangkangu, “Mayatja wiṟu, ngaḻṯuringamalampa. Palu nyaakulanyan alatjingaṉi? Nganaṉa panya nyuntumpa waṟkarinyi, kalanya nyaanguṟu nyuntu panya mayatja tjunkunytjitja tjuṯangku nganaṉanya punganyi? Paluṟu tjana nganaṉanya ungkunytja wiya ilintji panya tjuminta palyantjaku, kala nganaṉa puṯu palyaṉi tjuminta tjuṯa ilintji wiyangka. Kalanya paluṟu tjana mirpaṉarira alkaṉi tjuṯa palyantja-tjiratjangku. Palu nyuntu uti tjanampa mirpaṉarima panya tjana nganaṉanya ilintji tjuṯa ungkunytja wiyangku wantinyangka.” ");
INSERT INTO pjt_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","18","Ka Piiṟalu tjanala wangkangu, “Wiya, nyura waṟkaku ngurpa! Nyura tjukutjuku waṟkarira mapalku pakuringkupai. Pala palulanguṟu nyura ngayunya tiṯutjarangku ngatjini nyuranya wantir'iyantjaku ankula kuka pungkula nyurampa God ungkunytjikitjangku. Maḻakuya ara waṟkaku. Kala nganaṉa nyuranya piṟuku ungkuwiyangku wantinyi ilintji panya piḻṯi tjuṯa, palu piṟukuya palyala tjuminta panya tjuṯa mulapa nyura panya ngaṉmanytju palyantja puṟunypa.” ");
INSERT INTO pjt_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Kaya aṉangu Israelkunuku mayatja tjuṯangku nyangatja kuliṟa puḻkaṟa nguḻuringu munuya kuliningi, “Yaaltjirikula? Panya Piiṟanya mukuringanyi nganaṉa tjuminta tjuṯa mulapa palyantjaku, panya nganaṉa ngaṉmanytju palyantja puṟunypa. Palu tjana ilintji piḻṯi tjuṯa nganaṉanya ungkuwiyangku wantinyangkampa nganaṉa nampa panya palu puṟunypaṯu puṯu nguwanpa palyalku, kalanya uwankara pungkuku Piiṟaku panya wati tjuṯangku.” Munuya palulanguṟu Piiṟanya wantikatira anu. ");
INSERT INTO pjt_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Munuya Piiṟaku nguranguṟu ma-pakaṟa nyangu Mosenya pulanya Aaronnga tjanampa paṯannyangka. ");
INSERT INTO pjt_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Munuya puḻkaṟa mirpaṉarira wangkangu pulanya nyanga alatji, “Mayatja Piiṟanya palumpa wati mayatja tjuṯa kuḻu nganampa puḻkaṟa mirpaṉarinyi nyupalilanguṟu, munulampa kuraringanyi. Ka uti Mayatja Godalu nyupalinya pungama, panya nyupali Piiṟala wangkangu nganaṉanya ilytjikutu wantir'iyantjaku, kaya nyara palulanguṟu paluṟu nganaṉanya iluntankunytjikitjangku kulini.” ");
INSERT INTO pjt_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","23","Ka palulanguṟu Moselu Godala piṟuku tjapinu alatji wangkara, “Mayatja God! Nyaakulanya nyuntu wantingu nyanga tjana kurantjaku, panya nganaṉa nyuntumpa walytja tjuṯa. Nyaakuṉin panyatja wanyu nyangakutu iyaṉu? Kaṉa mulapaṯu pitjala Piiṟala tjapinu nyanga ngayuku walytja tjuṯaku. Ka panya ngayulu wangkanyangka Piiṟalu kuliṟa tjanampa puḻkaṟa mirpaṉarira waṟka puḻka mulapa tjunu tjana piṟuku waṟkarinytjaku. Ka nyuntu tjanampa anga-wangkanytja wiyangku alatjiṯu wantingu. Nyaanguṟu?” ");
INSERT INTO pjt_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Ka Mayatja Godalu wangkangu Mosela, “Nyuntu paṯala kuwaripa munun nyakuku ngayulu palyannyangka wati nyanga Piiṟala. Ngayuluṉa palunya nguḻutjingalku paluṟu wangaṉararingkula ngayuku aṉangu tjuṯa paiṟa iyantjaku tjana mapalku pakaṟa ankunytjaku ngura nyanganguṟu.” ");
INSERT INTO pjt_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Munu Godalu wangkangu Mosela nyanga alatji, “Ngayuluṉa Mayatja Godanya. ");
INSERT INTO pjt_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Panya ngaṉmanypaṉa utiringangi Aipuṟamala, Isaacala, Jacobala tjanala God Witulya Puḻkanya. Palu ngayulu palula tjanala tjakultjunkunytja wiyaṯu ini nyanga miḻmiḻpa panya Mayatjanya. ");
INSERT INTO pjt_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Ngayulu panya tjananya kalkuṟa wantingu manta panya Kainannga ungkunytjikitjangku tjana ngura walytjangka nyinanytjaku, panya tjana nyara palula ngaṉmanypa nyinangi ngura walytjatjarangka. ");
INSERT INTO pjt_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Kaṉa kulinu aṉangu Israelkunu tjuṯa ulanyangka, panya Itjipanya nguraṟa tjuṯangku tjananya pauntjingaṟa waṟka puḻkangka pakuningi. Kaṉa nyara palulanguṟu kulinu ngayulu panya tjananya kalkuṉu ngura panya Kainannga ungkunytjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Ka nyuntu ngayuku tjukurpa tjanala wangka aṉangu Israelkunu tjuṯangka nyanga alatji, ‘Ngayuluṉa Mayatja Godanya. Ngayulu nyuranya walatjunkuku aṉangu Itjipanya nguraṟa tjuṯaku rawa waṟkarinytjaku-tawara. Mulapa ngayulu witulya puḻkangku tjananya pikantankuku munuṉa nyuranya wankaṟunkuku. ");
INSERT INTO pjt_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Munuṉa ngayulu nyuranya aḻṯiku ngayuku walytja mulararinytjaku munuṉa ngayulu nyurampa God alatjiṯu ngaṟaku. Munu ngayulu alatjiṯu nyuranya Itjipalanguṟu pakaltjingalku tjanampa rawa waṟkarinytjaku-tawara, ka nyara palulanguṟu nyura nintiringkuku panya ngayulu alatjiṯu nyurampa Mayatja Godanya. ");
INSERT INTO pjt_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Panya ngayulu walytjangku nyuranya ma-katiku ngura panya ngaṉmanytju ngayulu Aipuṟamanya, Isaacanya, Jacobanya tjananya kalkuntjitjakutu. Munuṉa nyuranya manta nyara palunya ungkuku, ka nyurampariku alatjiṯu. Panya ngayuluṉa Mayatja Godanya.’ Uwa, nyuntu tjukurpa nyanga palunya tjanala wangka Israelkunu tjuṯangka.” ");
INSERT INTO pjt_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Ka mulapaṯu Moselu tjanala tjakultjunu uwankara Godalu wangkanytja. Palu kulintja wiyangkuya wantingi, panya kurunpaya uḻiringu waṟka puḻka tjuṯa rawangku palyantjatjanu. Palulanguṟuya Moselu wangkanyangka mulamularingkunytja wiyangku wantingi. ");
INSERT INTO pjt_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","11","Ka Mayatja Godalu wangkangu Mosela, “Ankula wangka wati panya Piiṟala Itjipaku panya mayatjangka paluṟu Israelkunu tjuṯa wantir'iyantjaku, tjana ngura nyangatja wantikatira ankunytjaku.” ");
INSERT INTO pjt_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Palu Moselu ngapartji wangkangu alatji, “Wiya, panya Israelkunu tjuṯangkuya ngayula kulilwiyangku wantingi, ka tjinguṟu Piiṟalu kuḻu ngayula kulilwiyangkuṯu wantiku, panya ngayulu puṯu nguwanpa puḻkaṟa wangkapai.” ");
INSERT INTO pjt_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Palu Godalu Mosenya pulanya Aaronnga wituṉu ankula wati panya Piiṟala tjakultjunkunytjaku. Munu paluṟu pulanya puḻkaṟa wituwituṉu aṉangu Israelkunu tjuṯa pakaltjingaṟa katinytjaku ngura panya Itjipalanguṟu. ");
INSERT INTO pjt_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Ka wati panya Israelku katja ngaṉmanyitja ini Rupinnga. Paluṟu katja kutjara kutjara kanyiningi ini nyanganpa – Anukunya, Paalunya, Itjuṟannga, Kaaminya. Kaya wati nyanga palula tjanalanguṟu aṉangu winkiringu tjanampa walytjapiti. ");
INSERT INTO pjt_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Ka Rupintu pininu wati ini Tjimiyannga. Ka panya Tjimiyanku katja tjuṯa ini nyanganpa – Tjimuwilnga, Tjaminnga, Uwaatnga, Tjakinnga, Tjawanya, Tjaulnga. Palu Tjaulnga panya minyma Kainannga nguraṟaku. Kaya nyanga palula tjanalanguṟu aṉangu winkiringu tjanampa walytjapiti. ");
INSERT INTO pjt_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Ka Tjimiyantu pininu wati ini Levinya. Ka panya Leviku katja maṉkurpa ini nyanganpa – Kuutjannga, Kawatjanya, Miraṟainya. Ka nyanga palula tjanalanguṟu aṉangu ma-tjuṯaringangiṯu tjanampa walytjapiti. Ka wati panya Levinya tjiḻpiringkula yiya nampa 137 nyinanytjatjanu ilungu. ");
INSERT INTO pjt_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Ka panya Leviku katja kuranyitjangku Kuutjantu katja kutjara kanyinu ini Lipininya pulanya Tjimainya. Ka nyanga kutjaranguṟu aṉangu ma-tjuṯaringu Leviku panya walytjapiti. ");
INSERT INTO pjt_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Ka wati panya Kawatjaku katja tjuṯa ini nyanganpa – Ama-ṟamanya, Iitjanya, Ipaṟamanya, Utjiyalnga. Ka nyanga palula tjanalanguṟu aṉangu ma-tjuṯaringangiṯu tjanampa walytjapiti. Ka Kawatjanya panya tjiḻpiringkula yiya nampa 133 nyinanytjatjanu ilungu. ");
INSERT INTO pjt_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Ka Miraṟailu katja kutjara kanyinu ini nyanga pulanya – Maalinya munu Mutjinya. Ka nyanga palula pulalanguṟu aṉangu ma-tjuṯaringangiṯu pulampa walytjapiti. Uwa, nyanga paluṟu tjana uwankara wati panya Leviku walytjapiti. ");
INSERT INTO pjt_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Ka panya Leviku pakaḻingku Ama-ṟamalu aḻṯingu palumpa mamaku kangkuṟu ini Tjakapitinya. Munu pula katja kutjara kanyinu ini Aaronnga pulanya Mosenya. Ka wati panya Ama-ṟamanya panya tjiḻpiringkula yiya nampa 137 nyinanytjatjanu ilungu. ");
INSERT INTO pjt_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Ka Ama-ṟamaku maḻanypangku Iitjalu katja maṉkurpa kanyinu ini nyanganpa – Kuṟanya, Nipikanya, Tjikiṟinya tjananya. ");
INSERT INTO pjt_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Ka Iitjaku maḻanypangku Utjiltu katja maṉkurpa kutjupaṯu kanyinu ini nyanganpa – Mitjailnga, Iltjapanya, Tjitjuṟinya tjananya. ");
INSERT INTO pjt_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Ka Aarontu aḻṯingu kungka ini Ilitjipanya panya wati ini Amina-tapaku uṉṯalpa munu wati ini Naatjanku kangkuṟu. Ka Ilitjipalu Aaronku katja tjuṯa kanyinu ini nyanganpa – Natapanya, Apiwunya, Iliyatjanya, Itjamanya tjananya. ");
INSERT INTO pjt_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Ka wati panya Kuṟalu katja maṉkurpa kanyinu ini nyanganpa – Itjiṟanya, Ilkananya, Api-yatjapanya tjananya. Ka wati nyanga palula tjanalanguṟu aṉangu ma-tjuṯaringu ini panya Kuṟakunu tjuṯa. ");
INSERT INTO pjt_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Ka panya Aaronku katjangku Iliyatjalu aḻṯingu wati Putiyalku uṉṯalpa. Ka paluṟu kanyinu katja ini Piniyatjanya. Uwa, ini nyanga paluṟu tjana panya wati ngaṉmanyitja tjuṯa Levikunu tjuṯaku, kaya palula tjanalanguṟu aṉangu winkiringu Leviku walytjapiti tjuṯa. ");
INSERT INTO pjt_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Ka panya Aaronta pulala Mosela Mayatja Godalu wangkangu nyanga alatji, “Nyupali aṉangu Israelkunu tjuṯa ngura nyanga Itjipalanguṟu pakaltjingala munu tjananya uwankara ma-kati walytjapiti kutjupa walytjapiti kutjupa.” ");
INSERT INTO pjt_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Ka wati nyanga paluṟu pula panya Itjipaku mayatjangka Piiṟala wangkangu aṉangu Israelkunu tjuṯa wantir'iyantjaku. ");
INSERT INTO pjt_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","29","Munu ngura pala Itjipala nyinanyangka Mayatja Godalu Mosela wangkangu nyanga alatji, “Ngayuluṉa Mayatja Godanya. Ka nyuntu ankula Itjipaku mayatjangka wangka Piiṟala uwankara ngayulu panya nyuntula wangkanytja.” ");
INSERT INTO pjt_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Palu Moselu ngapartji wangkangu, “Wiya, ngayulu palyanyku wangkapai wiya, ka tjinguṟu Piiṟalu ngayunya kulintja wiyangku wantiku.” ");
INSERT INTO pjt_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","2","Ka Mayatja Godalu wangkangu Mosela, “Ngayulu panya nyuntunya palyaṉu Godanya puṟunypa mayatja panya Piiṟala wangkanytjaku. Munuṉa nyuntumpa kuṯa Aaronnga tjunu nyuntumpa wangkatjara, paluṟu nyuntumpa tjukurpa Piiṟala wangkanytjaku. Ka nyuntu uwankara ngayulu wangkanytja Aaronta wangka, ka paluṟu ngapartji mayatja panya Piiṟala tjakultjunkuku munu palunya wangkaku aṉangu Israelkunu tjuṯa wantir'iyantjaku palumpa nguranguṟu. ");
INSERT INTO pjt_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Palu ngayuluṉa Piiṟanya tungunpungkunytjaku palyalku, ka paluṟu nyupalila kulintja wiyangku wantiku. Ngayuluṉa witulya puḻkangku palyalku kutjupa kutjupa tjuṯa ngura pala Itjipala Piiṟalu nyakunytjaku. ");
INSERT INTO pjt_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Palu paluṟu nyupalila kulilwiyangku wantiku. Kaṉa palulanguṟu ngura pala Itjipanya puḻkaṟa kuralku. Munuṉa ngayulu ngura pala palulanguṟu pakaltjingaṟa katiku ngayuku walytja tjuṯa aṉangu pala Israelkunu tjuṯa. ");
INSERT INTO pjt_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Uwa, ngayuluṉa witulya puḻkangku kuralku ngura pala Itjipanya munuṉa ngura pala palulanguṟu Israelkunu tjuṯa pakaltjingalku, kaya Itjipanya nguraṟa tjuṯangku nintiringkula kulilku panya mulapa ngayuluṉa Mayatja Godanya.” Nyanga alatji Godalu wangkangu Mosela. ");
INSERT INTO pjt_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Ka Moselu pula Aarontu mulapaṯu palyaṉu Mayatja Godalu panya wangkanytjitja. ");
INSERT INTO pjt_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Ka paluṟu pula Piiṟala wangkanytja aṟangka Mosenya panya wati tjiḻpi nguwanpa nyinangi yiya nampa 80 nyinanytjatjanu. Ka palumpa kuṯa Aaronnga tjiḻpiṯu nyinangi yiya panya nampa 83 nyinanytjatjanu. ");
INSERT INTO pjt_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","9","Ka piṟuku Mayatja Godalu wangkangu Mosela pulala Aaronta, “Nyupali panya Piiṟala wirkankunyangka paluṟu tjinguṟu nyupalila tjapilku kutjupa kutjupa witulyangku palyantjaku paluṟu nyakula mulamularingkunytjikitjangku. Ka Mose, nyuntu alatji tjapinnyangkampa Aaronnga wangka puṉu panya tjukara mantjiṟa mantangka waṉinytjaku Piiṟala kuranyu, ka puṉu panya tjukara paluṟu liruringkuku.” ");
INSERT INTO pjt_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Ka palulanguṟu Mosenya pula Aaronnga anu Piiṟalakutu munu pula Godalu panya wangkanytja palyaṉu. Ka Aarontu waṉingu tjukara mantangka Piiṟala kuranyu munu palumpa wati mayatja tjuṯangka miṟangka kuḻu, ka mulapaṯu waṉinyangka liruringu. ");
INSERT INTO pjt_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Ka Piiṟalu tjukaranguṟu liruringkunyangka nyakula wati kutju iyaṉu palumpa ngangkaṟi tjuṯa aḻṯira ngalya-katinytjaku, kaya pitjala tjana ngapartji palu puṟunypaṯu palyaningi tjanampa witulyatjarangku. ");
INSERT INTO pjt_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Munuya waṉingu tjanampa tjukara tjuṯa, ka palu puṟunypaṯu liruringu tjukara panya tjuṯa. Palu Aaronku panya tjukarangku liruringkunytjatjanungku liru panya kutjupa tjuṯa uwankara kuuḻtjanu. ");
INSERT INTO pjt_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Ka Piiṟalu nyakula wantira tungun-tungunpa alatjiṯu nyinangi, panya nyanga alatjirinytjaku Godalu ngaṉmanytju wangkangu. Munu paluṟu kulintja wiyangku wantingu Aaronnga pulanya Mosenya. ");
INSERT INTO pjt_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Ka piṟuku Godalu wangkangu Mosela, “Mayatja panya Piiṟanya puḻkaṟa tungunpunganyi munu aṉangu Israelkunu tjuṯa wantir'iyantja wiyangku alatjiṯu wantinyi. ");
INSERT INTO pjt_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Ka nyuntu mungawinki tjukara panya palunyatjara ankula paṯanma karu panya Nayilta uṟu kantilytja mayatja panya paluṟu uṟukutu ngalya-pitjanytjaku. ");
INSERT INTO pjt_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Munu palunya nyakulampa tjakultjura tjukurpa ngayulu kuwari nyuntula wangkanytja.” Ka Moselu tjukurpa wangkanyangka kulinu munu ankula mayatja panya Piiṟala tjukaṟurungku tjakultjunu alatji, “Mayatja Godalu, panya aṉangu Iipuṟu tjuṯaku Mayatjangku, ngayunya iyaṉu nyuntulakutu palumpa tjukurpa nyuntula tjakultjunkunytjaku. Alatji paluṟu nyuntunya wangkanyi, ‘Ngayuku aṉangu tjuṯa wantir'iyanma paluṟu tjana ilytjikutu ankula ngayunya waḻkuntjaku. Nyanga alatji panyaṉa nyuntula ngaṉmanytju wangkangu, ka nyuntu ngayula kulilwiyangku wantingi. ");
INSERT INTO pjt_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Palu kuwariṉa nyuntula miṟangka witulya puḻkangku palyaṉi nyuntu nyakula ngayuku nintiringkunytjaku panya ngayulu Mayatja Godanya.’” Alatji Moselu mayatja panya Piiṟala tjakultjunu Godalu wangkanytja uwankara. Munu palulanguṟu piṟuku palula wangkangu alatji, “Kuwariṉa uṟu nyanga Nayilnga pungkuku puṉu nyanga tjukarangka, ka uṟu paluṟu kutjuparira milkaḻiriku. ");
INSERT INTO pjt_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Ka antipina uṟu nyanga Nayilta ngarinytja uwankara iluku. Ka uṟu panya paluṟu kuraringkula paṉṯiku. Ka nyura Itjipanya nguraṟa tjuṯangku puṯu mina tjikilku karu nyanga Nayiltanguṟu.” ");
INSERT INTO pjt_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Ka Mayatja Godalu Mosela wangkangu, “Aaronnga wangka, ka paluṟu nyuntumpa panya tjukarangka katuṟa kanyila uṟungka katu, mina uṟu pala Itjipala ngarinytja uwankara milkaḻirinytjaku, ka karu tjuṯa, tjintjiṟa tjuṯa, tjukuḻa tjuṯa, mina piṯi tjuṯa kuḻu uwankara alatjiṯu milkaḻiriku. Ka ngurangka pitingka tjutiṟa tjunkunytja tjuṯa kuḻu milkaḻiriku.” ");
INSERT INTO pjt_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","21","Ka Moselu pula Aarontu mulapaṯu palyaṉu Godalu panya wangkanytjitja. Ka Aarontu tjukara panya palunya uṟungka katu wakuṟa pungu uṟu panya Nayilnga Piiṟala miṟangka palumpa wati mayatja tjuṯangka miṟangka kuḻu, ka uṟu uwankara milkaḻiringu. Ka antipina uwankara karu panya Nayilta ilungu. Ka uṟu uwankarangka kura paṉṯingi, kaya karu panya palulanguṟu puṯu mina tjikiningi aṉangu Itjipanya nguraṟa tjuṯangku, panya uwankara milkaḻi tjiwariwari ngaringi ngura panya Itjipala. ");
INSERT INTO pjt_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Kaya Piiṟaku ngangkaṟi tjuṯangku palu puṟunypaṯu palyaṉu uṟu milkaḻirinytjaku. Ka Piiṟalu nyangu palumpa ngangkaṟi tjuṯangku alatji palyannyangka munu piṟuku Mosela pulala Aaronta tungunpungu munu pulala kulintja wiyangku wantingi, panya nyanga alatjirinytjaku Godalu ngaṉmanytju Mosela pulala wangkangu. ");
INSERT INTO pjt_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Ka nyanga palulanguṟu Piiṟalu wantikatira anu ngurakutu panya paluṟu puṯu alatjiṯu mulamularingangi Moselu pula Aarontu palyannyangka. ");
INSERT INTO pjt_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Ka aṉangu Itjipanya nguraṟa uwankarangku puṯu mina tjikiningi karu panya Nayiltanguṟu. Munuya palulanguṟu karungka itingka kitikiti piṯi kutju kutju tjawaningi mina palya ngurintjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Ka Mayatja Godalu karungka uṟu panya milkaḻirinytjaku palyannyangka maḻangka tjiṉṯu 7 ngaṟala wiyaringu. ");
INSERT INTO pjt_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Ka Mayatja Godalu piṟuku wangkangu Mosela, “Ara mayatja panya Piiṟalakutu munu palula tjakultjura tjukurpa nyanga ngayulu kuwari nyuntula wangkanytja.” Ka Moselu tjukurpa wangkanyangka kulinu munu ankula mayatja panya Piiṟala tjukaṟurungku tjakultjunu nyanga alatji, “Mayatja Godalu ngayunya iyaṉu nyuntulakutu palumpa tjukurpa nyuntula tjakultjunkunytjaku. Alatji paluṟu nyuntunya wangkanyi, ‘Ngayuku aṉangu tjuṯa wantir'iyanma paluṟu tjana ankula ngayunya waḻkuntjaku. ");
INSERT INTO pjt_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Palu nyuntu ngayula tungunpungkunyangkaṉa nyuntunya puḻkaṟa tjituṟu-tjituṟunkuku ngaṉngi tjuṯa mulapa iyaṟa nyuntumpa ngurakutu. ");
INSERT INTO pjt_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Ka karu uṟu Nayilta ngaṉngi tjuṯa winkiringkuku munuya uṟu wantikatira angalku manta uwankarangka munuya waḻi nyuntumpangka tjarpaku munuya tjarpaku nyuntumpa piitangka kuḻu. Munuya waḻi winkingka nyuntumpa wati mayatja tjuṯaku waḻingka kuḻu tjarpaku, munu Itjipanya nguraṟa tjuṯaku waḻi uwankarangka. Munuya mai paulpaingka unngu kuḻu tjarpaku munu piti mai kutjalpaingka kuḻu. ");
INSERT INTO pjt_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Tjanaya mungilyiriku mulapa, munuya para-para-waṟarakatiku nyuntula itiwanu itiwanu munu nyuntumpa wati mayatja tjuṯangka kuḻu, munu aṉangu Itjipanya nguraṟa kutjupa uwankarangka kuḻu.’” Alatji Moselu mayatja panya Piiṟala ankula tjakultjunu Godalu panya wangkanytja uwankara. ");
INSERT INTO pjt_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Ka palulanguṟu Godalu piṟuku wangkangu Mosela, “Aaronnga wangka tjukara panya katuṟa kanyintjaku uṟungka katu. Ka ngaṉngi mungilyi mulapa ngalya-pakalku karu uwankaranguṟu ngura pala Itjipala manta winkikutu.” Ka Moselu wangkangu Aaronta. ");
INSERT INTO pjt_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Ka Aarontu mulapaṯu tjukara katuṟa kanyinu uṟungka katu. Kaya ngaṉngi mungilyi mulapa uṟu uwankaranguṟu ngalya-pakaṉu munuya ngura panya Itjipala winkingka angaṟa nyinara waṉaningi. ");
INSERT INTO pjt_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Kaya Piiṟaku ngangkaṟi tjuṯangku palu puṟunypaṯu witulyangku palyaṉu uṟunguṟu ngaṉngi tjuṯa pakaṟa uṟilta nyinara waṉinytjaku ngura pala Itjipala. ");
INSERT INTO pjt_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Ka Piiṟalu wati kutju iyaṉu Mosenya pulanya Aaronnga aḻṯira ngalya-katinytjaku munu pulala wangkangu, “Wanyu pula Mayatja Godala tjapila ngaṉngi nyanganpa wiyantjaku ngayulanguṟu munu ngayuku aṉangu tjuṯanguṟu kuḻu, kaṉa nyuntumpa aṉangu tjuṯa wantir'iyalku ankula kuka pungkula tiliwakaṟa Godanya ungkunytjaku.” ");
INSERT INTO pjt_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Ka Moselu wangkangu Piiṟala, “Palya, ngayuluṉa Godala tjapilku ngaṉngi tjuṯa wiyantjaku. Palu wanyuṉi tjakultjura nyuntu aṟa kuliṟampa, kaṉa ngayulu nyara palula aṟangka tjapilku nyuntumpa munu nyuntumpa wati mayatja tjuṯaku munu pala Itjipanya nguraṟa uwankaraku kuḻu, ka Godalu palyalku ngaṉngi tjuṯangku nyuranya munu nyurampa waḻi tjuṯa kuḻu wantikatinytjaku, kaya karu panya Nayilta uṟungka kutju nyinaku.” ");
INSERT INTO pjt_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","11","Ka Piiṟalu palula wangkangu, “Godala ngayuku tjapila mungawinki.” Ka Moselu wangkangu, “Palya, mungawinkiṉa palula tjapilku, kaya mulapaṯu ngaṉngi tjuṯangku nyuranya uwankara wantikatiku nyurampa waḻi tjuṯa kuḻu, munuya Nayilta uṟungka kutju nyinaku. Ka nyara palulanguṟu nyuntu nintiringkula kulilku panya nganampa Mayatja Godanya witulya puḻka mulapa nyinanyi, ka kutjupa palu puṟunypa nyinanytja wiya alatjiṯu.” Nyanga alatji Moselu Piiṟala wangkangu. ");
INSERT INTO pjt_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Ka nyanga palulanguṟu Aarontu pula Piiṟanya wantikatira anu. Ka mungawinki Moselu Mayatja Godala tjapinu ngaṉngi panya tjuṯaku panya paluṟu iyaṉu wati panya Piiṟala tjanalakutu. ");
INSERT INTO pjt_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Ka Godalu kulinu Mosenya munu iluntanu ngaṉngi panya tjuṯa. Kaya uwankara ilura wiyaringu waḻingka, yaatangka, uṟilta munu ngura uwankarangka kuḻu. ");
INSERT INTO pjt_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Kaya Itjipanya nguraṟa tjuṯangku ngaṉngi tjuṯa uraṟa uṯuḻuṟa tjunu puḻka mulapa. Ka mapalku uṉaringu ngura uwankarangka munu kura paṉṯingi. ");
INSERT INTO pjt_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Ka mayatja panya Piiṟalu nyangu ngaṉngi tjuṯa ilunyangka munu palulanguṟu paluṟu piṟuku Godala tungunpungu munu Mosela pulala Aaronta kulilwiyangku wantingi, panya alatjirinytjaku Godalu ngaṉmanytju Mosela pulala wangkangu. ");
INSERT INTO pjt_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Ka piṟuku Godalu Mosela wangkangu, “Wangka Aaronta manta pungkunytjaku tjukara panya palula ulpuru pakantjaku, ka ngura uwankarangka Itjipala winkingka ulpuru puḻka pakaṟa kampa kutjuparira kiwinyiriku.” Ka Moselu wangkangu palumpa kuṯangka. ");
INSERT INTO pjt_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Ka mulapaṯu Aarontu tjukarangka panya manta pungu, ka ngura winkingka ulpuru puḻka pakaṟa kampa kutjuparira kiwinyiringu munu aṉangu, kuka tjuṯa kuḻu tjutuṟa patinu Itjipala aḻa lipiwanungku. ");
INSERT INTO pjt_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Ka Piiṟaku ngangkaṟi tjuṯangku witulyatjarangku arkaṟa puṯu palyaningi kiwinyi tjuṯaringkunytjaku. Palu panya Godalu palyantja kutju ngura lipiwanu angaṟa ngaṟangi. ");
INSERT INTO pjt_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Kaya wati panya ngangkaṟi tjuṯangku wangkangu Piiṟala, “Godalu witulya puḻkangku nyangatja palyaṉu.” Palu piṟuku Piiṟanya Godala tungunpungu munu Mosela pulala Aaronta kulintja wiyangku wantingi, panya Godalu ngaṉmanytju wangkanytjitja alatjiringu. ");
INSERT INTO pjt_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Ka piṟuku Mayatja Godalu wangkangu Mosela, “Mungawinki mulapa pakala munu ankula mayatja panya Piiṟanya karu Nayiltakutu ankunyangka wirkaṟa nyawa, munu palula tjakultjura tjukurpa nyanga ngayulu kuwari nyuntula wangkanytja.” Ka Moselu tjukurpa wangkanyangka kulinu munu ankula mayatja panya Piiṟala tjukaṟurungku tjakultjunu nyanga alatji, “Mayatja Godalu ngayunya iyaṉu nyuntulakutu palumpa tjukurpa nyuntula tjakultjunkunytjaku. Alatji paluṟu nyuntunya wangkanyi, ‘Ngayuku aṉangu tjuṯa wantir'iyanma paluṟu tjana ankula ngayunya waḻkuntjaku. ");
INSERT INTO pjt_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Palu nyuntu wantir'iyantja wiyangku wantinyangkampa ngayulu punpunpa tjuṯa mulapa iyalku nyurampa waḻikutu, kaya paluṟu tjana tjuṯa mulapa nyuntula nyinakatiku munu nyuntumpa wati mayatja tjuṯangka munu aṉangu Itjipanya nguraṟa uwankarangka kuḻu, ka Itjipala waḻi tjuṯangka punpunpa tjuṯa tjaalyngaṟaku munu manta kuḻu tjutuṟa patilku punpunpa winki mulatu. ");
INSERT INTO pjt_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","23","Palu ngayuluṉa ngura panya Katjintakutu punpunpa iyantja wiyangku wantiku, panya ngura nyara palula ngayuku walytja tjuṯa nyinanyi aṉangu panya Israelkunu tjuṯa. Ka tjananya punpunpa tjuṯangku wirkaṟa kaarakantja wiyangku wantiku, munuya nyuntumpa ngurangka kutju wirkankuku nyuntumpa aṉangu tjuṯangka. Mungawinkiṉa nyangatja palyalku, ka nyuntu nyakuku punpunpa mungilyi mulapa nyurampa ngurangka wirkankunyangka manta Itjipala, palu ngura nyara ngayuku aṉangu tjuṯa nyinanytjala punpunpa wirkankunytja wiya ngaṟaku. Ka nyanganguṟu nyuntu nintiringkula kulilku panya mulapa ngayulu Mayatja Godanya munu panyaṉa nyuntumpa ngurangka ngaṟanyi.’” Alatji Moselu Piiṟala tjakultjunu Godalu panya wangkanytja uwankara. ");
INSERT INTO pjt_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Ka mulapaṯu palulanguṟu Mayatja Godalu punpunpa mungilyi mulapa iyaṉu wangkanytjatjanungku. Kaya kapuṯu winki mulapa Piiṟaku waḻingka tjarpangu, palumpa wati mayatja tjuṯaku waḻingka kuḻu munuya ngura Itjipala lipiwanu waḻi uwankarangka kuḻuya tjarpangu. ");
INSERT INTO pjt_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Ka Piiṟalu wati kutju iyaṉu Mosenya pulanya Aaronnga piṟuku aḻṯira ngalya-katinytjaku munu wangkangu pulala, “Palyaya ankula kuka pungkula uwa nyurampa God paluṟu nyurampa pukuḻarinytjaku. Palu ngura nyangangkaya palyanma paṯu ankuwiyangku.” ");
INSERT INTO pjt_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Palu Moselu wangkangu, “Wiya, tjinguṟu palya wiya nganaṉa alatjingantjaku ngura nyangangka. Panya aṉangu Itjipanya nguraṟa tjuṯaya alatji palyannyangka nyakula tjinguṟu nganampa miiḻaralku kuka puluka tjuṯa pungkunyangka. Munuya tjinguṟu nganaṉala wangkaku, ‘Nyaaku nyura puluka tjuṯa punganyi? Wanti, panya kuka paluṟu tjana miḻmiḻpa nganaṉa waḻkuntjaku.’ Nyanga alatjiya nyakula wangkara miiḻaralku munuya tjinguṟu nganaṉanya mirpaṉarira apungka atuṟa iluntankuku. ");
INSERT INTO pjt_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Palu wanyula ankuku tjiṉṯu maṉkurpa ilytjikutu, munula nyara palula kutju kuka pungkula tiliwakaṟa Mayatja Godanya ungkuku paluṟu nganampa pukuḻarinytjaku, panya nyanga alatjilanya Godalu wangkangu nganaṉa palyantjaku.” ");
INSERT INTO pjt_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Ka mayatja Piiṟalu ngapartji palula wangkangu, “Palya ngayulu nyuranya wantir'iyaṉi ankunytjaku, kaya palya ma-pitja munuya kuka pungkula tiliwakaṟa nyurampa Mayatja Godanya ungama ngura nyara ilytjingka. Palu paṯu ankuwiyaya ila nguwanpa ankula nyinama. Palu wanyu kuwari nyanga ngayuku Godala tjapila paluṟu punpunpa tjuṯa wiyantjaku.” ");
INSERT INTO pjt_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Ka Moselu wangkangu, “Uwa palya, ngayulu kuwari nyuntunya wantikatira ankula Mayatja Godala tjapini, ka paluṟu mungawinki wiyalku punpunpa tjuṯa. Kaya nyuranya uwankara wantikatiku nyuntumpa wati mayatja tjuṯa, aṉangu Itjipanya nguraṟa uwankara kuḻu. Ka-puṯa nyuntu palulanguṟu kampa kutjuparira nganaṉanya markulwiyangku wangaṉarangku wantir'iyanma, panya ngaṉmanyitja puṟunymankunytja wiyangku, kala palya ilytjikutu ankula kuka pungkula Mayatja Godanya ungama.” ");
INSERT INTO pjt_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Munu wangkara wiyaringkula Moselu Piiṟanya wantikatira anu munu tjapinu Mayatja Godala punpunpa wiyantjaku. ");
INSERT INTO pjt_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Ka Godalu kulinu Moselu tjapinnyangka munu wiyaṉu punpunpa panya tjuṯa. Ka punpunpa panya tjuṯangku Piiṟanya palumpa wati mayatja tjuṯa kuḻu wantikatingu aṉangu Itjipanya nguraṟa uwankara kuḻu. Ka punpunpa kutju nyinanytja wiya alatjiṯu uwankara ilura wiyaringu. ");
INSERT INTO pjt_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Ka punpunpa tjuṯa ilura wiyaringkunyangka Piiṟanya piṟuku panya palu puṟunypaṯu Godala tungunpungkula aṉangu panya palunya tjananya wantir'iyalwiyangku markuṟa kanyiningi. ");
INSERT INTO pjt_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Ka palulanguṟu piṟuku Mayatja Godalu wangkangu Mosela, “Kuwariṉa piṟuku nyuntula wangkanyi tjukurpa kutjupa nyuntu kuliṟa Piiṟala ankula ma-tjakultjunkunytjaku!” Ka Moselu tjukurpa wangkanyangka kulinu munu ankula mayatja panya Piiṟala tjukaṟurungku tjakultjunu nyanga alatji, “Mayatja Godalu, panya aṉangu Iipuṟu tjuṯaku Mayatjangku, ngayunya iyaṉu nyuntulakutu palumpa tjukurpa nyuntula tjakultjunkunytjaku. Alatji paluṟu nyuntunya wangkanyi, ‘Ngayuku aṉangu tjuṯa wantir'iyanma paluṟu tjana ankula ngayunya waḻkuntjaku. ");
INSERT INTO pjt_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","3","Palu tjinguṟu nyuntu wantir'iyantja wiyangku tjananya rawangku kanyinnyangkampa ngayulu pika kura mulapa iyalku nyurampa nyanytju tjuṯaku, munu nyurampa tangkiyiku, kamulaku, pulukaku, tjiipiku munu nanikuta tjuṯaku kuḻu paluṟu tjana uwankara pikatjararingkula ilunytjaku. ");
INSERT INTO pjt_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","5","Palu ngayulu Israelkunu tjuṯaku kuka tjuṯa wankaṟunkuku pikatjararingkuwiya ngaṟanytjaku, ka tjanampa kuka uwankara ilunytja wiya wanka nyinaku. Uwa, mungawinki ngayulu nyanga alatjingaṉi ngura nyanga Itjipala winkingka.’” Alatji Moselu mayatja panya Piiṟala tjakultjunu Godalu wangkanytja uwankara. ");
INSERT INTO pjt_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Ka mulapaṯu mungawinki Mayatja Godalu palyaṉu panya paluṟu wangkanytjatjanungku. Ka kuka tjuṯa aṉangu Itjipanya nguraṟa tjuṯaku pikatjararingkula uwankara ilungu. Palu Israelkunu tjuṯaku kuka tjuṯa pika wiya ilunytja wiya uwankara wankaṟu ngaṟangi. ");
INSERT INTO pjt_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Ka Piiṟalu wati maṉkurpa wituṟa iyaṉu Israelkunu tjuṯaku ngurakutu. Ka paluṟu tjana ankula nyangu Israelkunu tjuṯaku kuka tjuṯa ilunytja wiya alatjiṯu wanka ngaṟala waṉinyangka. Munuya pitjala Piiṟala tjakultjunu. Palu Piiṟalu piṟuku panya palu puṟunypaṯu Godala tungunpungkula tjananya Israelkunu tjuṯa wantir'iyantja wiyangku kanyiningi. ");
INSERT INTO pjt_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Ka Godalu piṟuku Mosela pulala Aaronta wangkangu, “Maṟangku pula tjuṉpa mantjila kuḻkunguṟu. Ka Mose, nyuntu mayatja Piiṟala miṟangka katu waṉi ilkaṟingka. ");
INSERT INTO pjt_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Ka tjuṉpa panya paluṟu lipiringkula ulpuru puḻkaringkuku munu manta Itjipala winkingka angalku. Ka ulpuru panya tjuṉpa palulanguṟu pika kunmaṉu tjuṯa nyinakatiku aṉangu Itjipanya nguraṟa tjuṯaku miṟingka kuka tjuṯangka kuḻu. Munu kunmaṉu panya paluṟu tjana raa-raaringkula aḻa-aḻaringkula pika puḻkaringkuku.” Alatji Godalu wangkangu Moselu pula Aarontu palyantjaku. ");
INSERT INTO pjt_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Ka paluṟu pula tjuṉpa waṟunguṟu mantjiṟa katingu munu pula ankula Piiṟala miṟangka ngaṟangu munu palulanguṟu Moselu tjuṉpa panya palunya ilkaṟikutu waṉingu, ka tjuṉpa palulanguṟu aṉangu tjuṯa kunmaṉutjararingu kuka tjuṯa kuḻu. Ka palulanguṟu pika panya kunmaṉu tjuṯa kuraringkula aḻa-aḻaringu. ");
INSERT INTO pjt_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Ka Piiṟaku ngangkaṟi tjuṯa puṯu nguwanpa pitjangi Moselakutu panya paluṟu tjana kuḻu kunmaṉu tjuṯatjararingu. Ka aṉangu Itjipanya nguraṟa uwankara kuḻu palu puṟunyaringu. ");
INSERT INTO pjt_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Palu Godalu Piiṟanya tungun-tungunpa palyaṉu kulilwiyangku wantinytjaku, ka paluṟu mulapaṯu kulilwiyangku wantingi Moselu pula Aarontu wangkanyangka, panya alatjirinytjaku Godalu ngaṉmanytju Mosela wangkangu. ");
INSERT INTO pjt_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Ka piṟuku Godalu Mosela wangkangu, “Mungawinki mulapa pakala munu ankula Piiṟala tjakultjura tjukurpa nyanga ngayulu kuwari nyuntula wangkanytja.” Ka Moselu tjukurpa wangkanyangka kulinu munu ankula mayatja panya Piiṟala tjukaṟurungku tjakultjunu nyanga alatji, “Mayatja Godalu, panya aṉangu Iipuṟu tjuṯaku Mayatjangku, ngayunya iyaṉu nyuntulakutu palumpa tjukurpa nyuntula tjakultjunkunytjaku. Alatji paluṟu nyuntunya wangkanyi, ‘Ngayuku aṉangu tjuṯa wantir'iyanma paluṟu tjana ankula ngayunya waḻkuntjaku. ");
INSERT INTO pjt_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Ka tjinguṟu nyuntu alatji palyalwiyangku wantinyangkampa ngayulu witulya puḻkangku nyuntunya puḻkaṟa alatjiṯu pikantankuku munu nyuntumpa wati mayatja tjuṯa munu nyuntumpa aṉangu tjuṯa kuḻu, nyanga Itjipanya nguraṟa uwankara. Kan palulanguṟu nintiringkula kulilku panya ngayulu witulya puḻka mulapa nyinanyi uwankarangka waintarinytja, ka kutjupa ngayulu puṟunypa nyinanytja wiya alatjiṯu. ");
INSERT INTO pjt_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Tjinguṟu ngayulu ngaṉmanytju nyuntunya pika kura mulapa ungama nyuntumpa aṉangu tjuṯa kuḻu, ka nyura pika puḻkaringkula iluma uwankara alatjiṯu. ");
INSERT INTO pjt_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Palu ngayulu nyuranya wantingu iluntankunytja wiyangku, nyura witulya puḻkangku palyannyangka nyakula ngayuku nintiringkunytjaku, munu aṉangu manta winkitjangku kuḻu kuliṟa ngayunya ini kulintjaku witulya puḻkanya. ");
INSERT INTO pjt_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Palu nyuntu kaṉany-kaṉanypa alatjiṯu nyinanyi, munu panyan ngayula tungunpungkula ngayuku aṉangu tjuṯa wangaṉarangku wantir'iyalwiyangku kanyini rawangku. ");
INSERT INTO pjt_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Ka palulanguṟu ngayulu mungawinki kunaṯa puḻkanya iyaṉi apu puṟunypa punkantjaku ngura Itjipalawanu, panya ngura pala palula ngaṉmanypa kunaṯa nyanga puṟunypa punkantja wiyaṯu. ");
INSERT INTO pjt_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Ala, kuwari wangka nyuntumpa waṟkatjara tjuṯa nyanytju, puluka, tjiipi, kuka uwankara waḻingka unngu tjarpatjunkunytjaku kunaṯangku tjananya atuṟa iluntankunytjaku-tawara. Panya mungawinki kunaṯa puḻkangku punkaṟa uwankara uṟilta ngaṟanyangka atuṟa iluntankuku aṉangu tjuṯa kuḻu, kaya uti uwankara wankaringkunytjikitja waḻi unngu tjarpama.’” Alatji Moselu mayatja Piiṟala tjakultjunu Godalu panya wangkanytja uwankara. ");
INSERT INTO pjt_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Ka Piiṟaku wati mayatja kutjupa tjarangku kulinu Mayatja Godaku tjukurpa Moselu tjakultjunkunyangka, munuya kunaṯangku atuntjaku-tawara wala puḻka anu tjanampa kuka munu aṉangu waṟkaripai tjuṯa kuḻu mantjiṟa waḻi unngu tjarpatjunkunytjikitja. ");
INSERT INTO pjt_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Palu kutjupa tjarangku Godaku tjukurpa kuliṟa wantingu munuya tjanampa kuka tjuṯa, aṉangu waṟkaripai tjuṯa kuḻu tjarpatjunkuwiyangku wantingi, kaya uṟilta ngaṟangi. ");
INSERT INTO pjt_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Ka palulanguṟu Godalu wangkangu Mosela, “Tjukaranku katula munu wiḻitjura ilkaṟikutu, ka palulanguṟu kunaṯangku punkaṟa Itjipala lipiwanungku atulku aṉangu, kuka, puṉu, ukiṟi kuḻu ngura Itjipala uwankarangka.” ");
INSERT INTO pjt_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","24","Ka Moselu puṉu panya tjukara katuṉu munu wiḻitjunu ilkaṟikutu, ka palulanguṟu Mayatja Godalu mulapaṯu kunaṯa ngangkaḻingka iyaṉu. Ka puḻkaṟa tuuningi, ka wanangaṟa pinpara mantakutu wirkanangi. Ka kunaṯa puḻkanya alatjiṯu Itjipala lipiwanungka punkaningi, panya nyanga palu puṟunypa ngaṉmanypa alatjirinytja wiyaṯu ngura pala Itjipala. ");
INSERT INTO pjt_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Ka aḻa lipiwanungku kunaṯangku atuningi Itjipala uwankarangka uṟilta ngaṟanyangka aṉangu, kuka kuḻu munu ukiṟi, puṉu tjuṯa kuḻu atuṟa uwankara wiyaṉu. ");
INSERT INTO pjt_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","32","Ka Itjipaku paama tjuṯangka ukiṟi panya ini flax munu mai ini paali kuḻu kunaṯangku atuṟa wiyaṉu. Panya mai paali paluṟu tjana ngaṉmanypa kuṟuringu munu urantjaku ngaṟangi. Ka ukiṟi panya flax inuntjitjaraṯu ngaṟangi, ka kunaṯangku palu puṟunypaṯu atuṟa wiyaṉu. Palu mai wiita palya ngaṟangi atuṟa kurantja wiyaṯu, panya paluṟu maḻa kuṟuringkupai munu panya uṉinypatjararingkunytja wiyaṯu ngaṟangi kuwaripa. Palu ngura panya Katjinala kunaṯa wiya alatjiṯu ngaṟangi, panya Israelkunu tjuṯa nyinangi ngura nyara palula. Ka Piiṟalu wati kutju iyaṉu Mosenya pulanya Aaronnga aḻṯira ngalya-katinytjaku. Munu pitjanyangka paluṟu pulala wangkangu alatji, “Mulapa ngayulu kuwari kura palyaṉu, panya ngayulu munu ngayuku aṉangu tjuṯangku nyuranya rawangku kuraningi, ka panya Mayatja Godanya kutju tjukaṟuru mulapa nyinanyi, ngayulu puṟunypa wiya. Palu wanyulampa palula tjapinma piṟuku kunaṯa iyantja wiyangku wantinytjaku, panya nganaṉa tjituṟu-tjituṟu puḻkaringu rawangku tuuṟa puyinnyangka. Kaṉa palya nyuranya mukuringkunyangka wantir'iyaṉi ngura nyanga Itjipalanguṟu.” Ka Moselu wangkangu Piiṟala, “Uwa palya, ngayulu kuwari ngura nyanga palunya wantikatinytjatjanungku maṟa katuṟa Mayatja Godala tjapilku, ka kunaṯa munu mina tuutjarangku puyintja wiyaringkuku. Ka nyara palulanguṟu nyuntu nintiringkula kulilku, panya manta nyanga uwankara Mayatja Godaku alatjiṯu ilkaṟi kuḻu. Palu ngayulu ninti nyuntumpa munu nyuntumpa wati mayatja tjuṯaku, panya nyura Godaku mulamula nguḻuringkunytja wiyaṯu.” ");
INSERT INTO pjt_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Munu wangkara wiyaringkula Moselu Piiṟanya wantikatingu munu waḻinguṟu ma-pakaṟa uṟilkutu anu tawunu wantikatira, munu palulanguṟu maṟa katuringkula Mayatja Godala tjapiningi, ka kunaṯa mulapaṯu wiyaringu mina tuutjara kuḻu. ");
INSERT INTO pjt_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","35","Ka mayatja panya Piiṟalu nyangu uwankara wiyaringkunyangka munu piṟuku paluṟu tungunpungu Godala palumpa wati mayatja tjuṯa kuḻu. Munu paluṟu Israelkunu tjuṯa wantir'iyantja wiyangkuṯu tungun-tunguntu kanyiningi, panya nyanga alatjirinytjaku Godalu ngaṉmanytju Mosela wangkangu. ");
INSERT INTO pjt_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Ka piṟuku Mayatja Godalu wangkangu Mosela, “Ara maḻaku mayatja panya Piiṟalakutu. Panya ngayulu palunya munu palumpa wati mayatja tjuṯa kuḻu kurunpa wituwitu palyaṉu ngayulu tjanala miṟangka kutjupa kutjupa nyanga tjuṯa witulya puḻkangku palyantjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Alatjiṉa palyaṉu nyura nyakunytjatjanungku ngula nyurampa tjitji tjuṯangka tjakultjunkunytjaku, pakaḻi puḻiri tjuṯangka kuḻu, panya ngayulu kutjupa kutjupa tjuṯa nyanga Itjipanya nguraṟa tjuṯangka witulya puḻkangku palyaningi tjana tjituṟu-tjituṟurinytjaku, alatji nyura tjanala tjakultjunkuku ngula. Munu nyara palulanguṟu nyura uwankarangku nyakunytjatjanungku nintiringkula kulilku panya mulapa ngayulu Mayatja Godanya.” Alatji Godalu Mosela wangkangu. ");
INSERT INTO pjt_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Ka palulanguṟu Aaronnga pula maḻaku anu Piiṟalakutu munu pula palula wangkangu, “Mayatja Godalu, panya aṉangu Iipuṟu tjuṯaku Mayatjangku ngalinya iyaṉu nyuntulakutu palumpa tjukurpa nyuntula tjakultjunkunytjaku. Alatji paluṟu nyuntunya wangkanyi, ‘Nyuntu panya ngayula rawa alatjiṯu tungunpunganyi. Yaalaṟa nyuntu piiwiyaringkula ngayula wangaṉarangku kulilku? Wanyu ngayuku aṉangu tjuṯa wantir'iyala tjana ngayunya ankula waḻkuntjaku ilytjingka. ");
INSERT INTO pjt_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Palu nyuntu kulilwiyangku wantira tungunpungkunyangkampa ngayulu mungawinki tjiṉṯilyka tjuṯa nyuntumpa ngurakutu iyalku Itjipalakutu. ");
INSERT INTO pjt_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Ka paluṟu tjana wirkaṟa manta winki tjutuṟa patilku mungilyi mulatu, ka nyura manta nyakunytjikitjangku puṯu nyakuku. Ka paluṟu tjana uwankara alatjiṯu ngalkula wiyalku ukiṟi panya kunaṯangku atuṟa tjara wantinytjitja, munuya puṉunguṟu kuḻu nyaḻpi uwankara ngalkula wiyalku. ");
INSERT INTO pjt_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Munuya paluṟu tjana ankula nyuntumpa ngurangka tjarpara tjaalyngaṟaku, nyuntumpa wati mayatja tjuṯaku waḻingka kuḻu, munuya panya Itjipanya nguraṟa uwankaraku waḻingka kuḻu tjarpara tjaalyngaṟaku. Uwa, mungilyi mulapa nyurala wirkankuku, panya ngura pala Itjipala ngaṉmanypa palu puṟunypa wirkankunytja wiyaṯu ngaṟangi.’” Nyanga alatji Moselu Piiṟala tjakultjunu Godaku panya wangka. Munu palulanguṟu pula pakaṟa anu mayatja panya Piiṟanya wantikatira. ");
INSERT INTO pjt_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Ka pula ankunyangka Piiṟaku wati mayatja tjuṯangku palula tjapiningi wangkara, “Yaaltjiṯu aṟangku wati nyangantu nganampa kura palyalku? Wantir'iyala aṉangu Israelkunu tjuṯa tjana ankula tjanampa Mayatja Godanya waḻkuntjaku. Panyatja kulinma, panya nganampa ngura nyanga Itjipanya kura mulararingu.” ");
INSERT INTO pjt_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Ka wati waṟkatjarangku ankula Mosenya pulanya Aaronnga aḻṯira maḻakungku ngalya-katingu Piiṟalakutu. Ka pulala wangkangu, “Uwa, palyaya ara munuya nyurampa Godanya waḻkunma. Palu tjakultjuraṉi, ngananya tjana kuḻuya ananyi?” ");
INSERT INTO pjt_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Ka Moselu wangkangu, “Nganaṉa ananyi uwankara tjitji kuḻu, tjiḻpi, pampa, katja, uṉṯalpa kuḻu. Munula kuka nganampa kuḻu katinyi tjiipi nanikuta tjuṯa, puluka tjuṯa kuḻu. Panya nganaṉa ankula nyarangka inkara pukuḻarira Mayatja Godanya waḻkulku.” ");
INSERT INTO pjt_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Ka Piiṟalu palula anaṟa wangkangu, “Wiya, nyuntu tjinguṟu ngunti wangkanyi. Nyura tjinguṟu uwankara wirtjapakantjikitjangku kulini ngura nyanganguṟu. Ka Mayatja Godalumpa wanyu nyuranya mulapa aṯunymaṟa kanyilku? Wiya, ngayulu minyma tjitji kuḻu wantir'iyantja wiyangku kanyini nyura ngura nyangatja wantikatira wirtjapakantjaku-tawara. ");
INSERT INTO pjt_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Ka nyura wati kutju ara munuya Mayatja Godanya nyarangka waḻkunma, panya palunyakitjangku nyura ngayula rawangku tjapiningi.” Ka palulanguṟu wangkara wiyaringkunyangka Piiṟaku wati mayatja tjuṯangku Mosenya pulanya paiṟa iyaṉu. ");
INSERT INTO pjt_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Ka palulanguṟu Mayatja Godalu wangkangu Mosela, “Maṟanku katula ngura Itjipala katuwanungku, kaya tjiṉṯilyka tjuṯa mulapa ngalya-wirkankuku, munuya pitjala ukiṟi, puṉu uwankara paamangka pakaltjingantja ngalkula wiyalku, uwankara panya kunaṯangku tjara atuṟa wantinytja tjuṯa.” ");
INSERT INTO pjt_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Ka mulapaṯu Moselu palumpa tjukara katuṉu ngura panya Itjipala katuwanungku, ka Mayatja Godalu iyaṉu waḻpa puḻka kakaraṟanguṟu ka puḻkaṟa wangkangi kaḻaḻa waṟa munu munga waṟa. Munu mungawinki mulapa waḻpa panya paluṟu tjiṉṯilyka mungilyi ngalya-katingu. ");
INSERT INTO pjt_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Ka winki mulatu tjaalyngaṟangu manta Itjipala lipiwanungku, panya tjiṉṯilyka mungilyi mulapa palu puṟunypa iriti ngaṟanytja wiya munu panya maḻangka kuḻu nyanga puṟunypa piṟuku ngaṟanytja wiya alatjiṯu. ");
INSERT INTO pjt_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Ka tjiṉṯilyka paluṟu tjana warpungkula alatjiṯu tjutuṟa patinu ngura winki, ka uwankara maṟuringu. Munuya ukiṟi mai uwankara ngalkuningi panya kunaṯangku tjara atuṟa wantinytja tjuṯa. Munuya kaana tjuṯangka mai munu nyaḻpi puṉutja uwankara kuḻu ngalkuṉu. Ka ngura pala Itjipala uwankarangka nyaḻpi munu ukiṟi ngaṟanytja wiyaringu. ");
INSERT INTO pjt_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Ka Piiṟalu mapalku wati waṟkatjara iyaṉu Mosenya pulanya aḻṯira ngalya-katinytjaku. Munu wangkangu pulala, “Ngayulu kura mayatja nyurampa Godala tungunpungangi, munuṉa nyupalila kuḻu kulintja wiyangku wantingi kurangku. ");
INSERT INTO pjt_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Katju pula ngayuku ngaḻṯuringama munuṉi pula kalypangku kurantja wiyangku wantima ngayuku kuranguṟu. Wanyu pula Mayatja Godala tjapila, ka nyanga tjiṉṯilyka tjuṯa wiyala nganaṉa ilunytjaku-tawara.” ");
INSERT INTO pjt_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Ka Moselu Piiṟanya wantikatira ankula Mayatja Godala tjapinu. ");
INSERT INTO pjt_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Ka mulapaṯu paluṟu waḻpa panya palunya kampa kutjupaṟa iyaṉu wiluṟaranguṟu puḻka mulapa, ka puḻkaṟa wangkara tjiṉṯilyka winki uṟu puḻkakutu uṉṯuṟa wiyaṉu. Ka palulanguṟu tjiṉṯilyka kutjupa nyinanytja wiya alatjiṯu ngaṟangi ngura panya Itjipala. ");
INSERT INTO pjt_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Palu piṟuku Mayatja Godalu Piiṟanya tungun-tungunpa palyaṉu kulilwiyangku wantinytjaku, ka paluṟu Israelkunu tjuṯa wantir'iyantja wiyangku kanyiningi. ");
INSERT INTO pjt_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Ka nyanganguṟu Mayatja Godalu wangkangu Mosela, “Maṟanku katula munu wiḻitjura ilkaṟikutu, ka munga maṟu mularariku ngura pala Itjipala winkingka. Kaya aṉangu Itjipanya nguraṟa tjuṯa kuṟutjara puṟunypa para-ngaṟaku, munuya puṯu alatjiṯu nyakuku.” ");
INSERT INTO pjt_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Ka Moselu mulapaṯu maṟa katuṟa wiḻitjunu ilkaṟikutu, ka puḻkaṟa mulapa maṟuringu Itjipala winkingka. Munu rawa alatjiṯu ngaṟangi tjiṉṯu maṉkurpa. ");
INSERT INTO pjt_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Kayanku Itjipanya nguraṟa tjuṯangku puṯu ngaparku nyangangi. Munuya uwankara waḻi unngu kutju nyinangi uṟilkutu pakantja wiya tjiṉṯu panya maṉkurpa maṟu ngaṟanyangka. Kaya Israelkunu tjuṯa kutju pukuḻpa nyinangi, panya palumpa tjanampa mauṉṯaṟa kaḻaḻa ngaṟangi ngura panya tjana nyinanytjanya. ");
INSERT INTO pjt_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Ka piṟuku Piiṟalu wati kutju iyaṉu Mosenya aḻṯira ngalya-katinytjaku, munu pitjanyangka palula wangkangu, “Palya nyura uwankarangku ankula waḻkunma nyurampa Mayatja Godanya, minymangku, tjitjingku kuḻu. Palu nyurampa tjiipi, nanikuta, puluka tjuṯaya katinytja wiyangku wantikati nyangangka.” ");
INSERT INTO pjt_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Ka Moselu wangkangu, “Wiya, utila kuka tjuṯa kuḻu katima, panya nganampa kuka tjuṯanguṟu nganaṉa ngurkantaṟa tjara punganyi munu tiliwakaṟa Mayatja Godanya unganyi paluṟu nganampa pukuḻarinytjaku. ");
INSERT INTO pjt_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Palulanguṟula nganampa kuka uwankara katinyi tjara kutjupa wantikatinytja wiyangku, panya nganaṉa ma-wirkaṟa walytjangku ngurkantankuku kuka kutjupatjara pungkula Mayatja Godanya ungkula waḻkuntjikitjangku. Palu nganaṉa ankunytja kuwaripangka puṯu ngaṉmanytju ngurkantananyi.” ");
INSERT INTO pjt_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Palu Mayatja Godalu piṟuku Piiṟanya palyaṉu tungunpungkunytjaku, ka paluṟu tjananya wantir'iyantja wiyangku alatjiṯu kanyiningi. ");
INSERT INTO pjt_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Munu paluṟu wangkangu Mosela palumpa mirpaṉarira, “Pakaṟa ara munu nyanganguṟu piṟuku maḻaku pitjanytja wiyariwa. Tjinguṟu nyuntu piṟuku ngayulakutu pitjanyangkampa ngayulu wangkaku nyuntunya iluntankunytjaku.” ");
INSERT INTO pjt_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Ka palulanguṟu Moselu wangkangu Piiṟala, “Palya, nyuntu wangkanyangkaṉa kulinu, munuṉa kuwari ankula piṟuku nyuntulakutu pitjanytja wiya alatjiṯu.” ");
INSERT INTO pjt_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Ka Mayatja Godalu Mosela wangkangu alatji, “Ngayulu kuwari nyanganguṟu kura puḻka mulapa pika puḻka palyalku mayatja panya Piiṟaku munu Itjipanya nguraṟa tjuṯaku kuḻu. Ka pala palulanguṟu mayatja paluṟu nintiringkula wantir'iyantjikitjangku kulilku nyuranya, munu nyuranya uwankara paiṟa iyalku mapalku pakaṟa ankunytjaku. ");
INSERT INTO pjt_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Palu kuwari Israelkunu tjuṯangka wangka tjana uwankarangku Itjipanya nguraṟa tjuṯangka ankula ngatjintjaku panya nyurala itingka nyinanytja tjuṯangka, kaya wiṟu tjuṯa nyuranya ungkuku apu tjiilpatjara gold-tjara kuḻu.” Nyanga alatji Godalu wangkangu Israelkunu tjuṯangka tjana palula tjanala ngatjintjaku. ");
INSERT INTO pjt_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Panya Godalu tjananya Itjipanya nguraṟa tjuṯa kurunpa kampa kutjupanu wangaṉararingkula ungkunytjaku Israelkunu tjuṯa. Kaya Mosenya puḻkanmanangi Piiṟaku wati mayatja tjuṯangku, aṉangu panya Itjipanya nguraṟa uwankarangku kuḻu, wati palya mulapa kuliṟa. ");
INSERT INTO pjt_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Ka piṟuku Moselu mayatja panya Piiṟala wangkangu, “Mayatja Godalu nyuntula alatji wangkanyi, ‘Kuwariṉa munga kultungka ngayulu para-ngaṟaku ngura uwankarangka nyanga Itjipala lipiwanu. ");
INSERT INTO pjt_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Ka nyurampa katja kuranyitja tjuṯa iluku, nyurampa uwankaraku katja ngaṉmanypa ngarinytja tjuṯa Itjipanya nguraṟa nyiṯayira uwankara alatjiṯu. Munu panya nyurampa kukaku katja ngaṉmanypa ngarinytja tjuṯa kuḻu uwankara wiyaringkuku. ");
INSERT INTO pjt_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Ka pala palulanguṟu nyura ngura uwankarangka katja-tjiratja puḻkaṟa ulara tjituṟu-tjituṟu mulapa nyinaku, panya ngura pala Itjipala tjituṟu-tjituṟu nyanga puṟunypa ngaṉmanypa ngaṟanytja wiyaṯu munu panya palula maḻangka palu puṟunypa piṟuku nguṟurpa ngaṟanytja wiya ngaṟaku. ");
INSERT INTO pjt_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Palu Israelkunu tjuṯa pukuḻpa mulapa nyinaku katja tjuṯa wankaṟu kanyiṟa, kuka tjuṯa kuḻu, panya palunya tjananya kutjupa kutjupangku pampuntja wiya alatjiṯu. Ka nyura nintiringkula kulilku panya ngayulu Israelkunu tjuṯaku mukuringkula tjananya wankaṟu kanyilpai, munuṉa nyuranya Itjipanya ngura tjuṯa wantipai.’” Alatji Moselu tjakultjunangi Piiṟala Godalu wangkanytja uwankara. ");
INSERT INTO pjt_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Munu piṟuku Moselu palula wangkangu, “Kaya nyuntumpa wati mayatja tjuṯa pitjala ngayula kuranyu pupakatiku, munuṉi ngayula wangkaku alatji, ‘Ara ngura nyanganguṟu, munu nyuntumpa aṉangu tjuṯa kuḻu kati, panya nyuntula wangaṉarangku kulilpai tjuṯa!’ Alatjiṉiya wangkaku, kaṉa nyara palulanguṟu ngayulu nyuntunya wantikatiku.” Nyanga alatji Moselu mirpaṉṯu wangkangu mayatja panya Piiṟala puḻkaṟa mirpaṉarira. Munu wangkara wiyaringkula wantikatira mirpaṉpa alatjiṯu anu. ");
INSERT INTO pjt_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Palu panya alatjirinytjaku Mayatja Godalu ngaṉmanytju Mosela wangkangu alatji, “Mayatja panya Piiṟalu tungun-tunguntu nyuntunya kulintja wiyangku wantiku. Palu palya, panya paluṟu rawa nguwanpa tungun-tungunpa ngaṟanyangkampa ngayulu kutjupa kutjupa tjuṯa witulya puḻkangku palyalku ngura nyanga Itjipala.” ");
INSERT INTO pjt_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Ka panya Piiṟalu nyangangi Moselu pula Aarontu kutjupa kutjupa tjuṯa witulya puḻkatjarangku palyannyangka. Palu panya Mayatja Godalu Piiṟanya tungun-tungunpa palyaningi kulilwiyangku wantinytjaku, ka paluṟu Israelkunu tjuṯa palumpa nguranguṟu wantir'iyantja wiyangku kanyiningi. ");
INSERT INTO pjt_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","3","Ka manta pala Itjipala Mayatja Godalu wangkangi Mosela pulala Aaronta pula ngapartji tjanala tjakultjunkunytjaku aṉangu Israelkunu uwankarangka. Alatji paluṟu wangkangi, “Nyura uti piṟa nyanga kuwari ma-ngarinytjanya kulinma piṟa ngaṉmanyitja. Ka tjiṉṯu 10 ngaṟala wiyaringkula nyura uti wati uwankarangku kutjungku kutjungku ankula nyurampa kuka tjuṯanguṟu nyurampa walytja tjuṯaku ngurkantaṟa mantjinma kutju tjinguṟu lamalama munta tjinguṟu nanikuta. ");
INSERT INTO pjt_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","5","Palu nyura uti kuka kurakura nyakula wantima munuya kuka nyiṯayira palya mulapa kutju ngurkantaṟa mantjinma tjinguṟu lamalama munta tjinguṟu nanikuta yiya kutju nyinanytja. Ka tjinguṟu wati kutjupa walytjapiti maṉkurtjara nguwanpa nyinanyi munu paluṟu tjana kuka panya palunya puṯu nguwanpa ngalkula wiyalku, ka uti paluṟu wati panya kutjupa palula ititja ungama kuka palulanguṟu paluṟu tjana tjungungku ngalkula mapalku wiyantjikitjangku munga kutjungka. ");
INSERT INTO pjt_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Munu nyura kuka panya palunya tjananya mantjiṟa ngalya-katira ila kanyinma tjiṉṯu kutjara kutjara piṟa panya tjuni puḻkaringkunytjaku paṯaṟa, munu nyara palulanguṟu mungartjirinyangka nyura uti Israelkunu uwankarangku kuka panya palunya tjananya kutjungku kutjungku pungkula iluntanama. ");
INSERT INTO pjt_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Munuya kukaku panya milkaḻi pitingka tjutiṟa nyuranku kutjungku kutjungku nyurampa yiwaḻa tjaangka katutja milkaḻingka nyiṯila munu kampa kutjara kuḻu maḻangka yiwaḻa pala palula unngu kuka ngalkuntjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","9","Munuya munga pala palula kuka nyuranku walytjangku walytjangku waṟungka paula kata winki munu tjuni winki kuḻu, munuya tangkaringkunyangkampa ukiṟi mayu kurakurangka tjunguṟa ngalkula mai pilytja kuḻu. Palu nyura kuka palunya minangka pauntja wiyangku wantima munuya wanka ngalkuntja wiyangku tangka mulapa kutju ngalkunma. ");
INSERT INTO pjt_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Munuya kuka tjara mungawinkiku tjunkunytja wiyangku wantima. Munu tjinguṟu tjara kutjupa maḻaringkula ngarinyangkampa mungawinki uraṟa waṟu tilingka tjarpatjura kampara wiyantjaku. ");
INSERT INTO pjt_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Palu ngalkuntja kuwaripangka nyura uti mantarangka tjarpama tjinatjangka kuḻu, munu tjukara kuḻu mantjiṟa aḻa-aḻa nyinama mapalku pakaṟa ankunytjikitja. Munuya kuka mai warpungkula ngalkula iṉi-iṉingku. Panya kuka mai nyangatja ini ‘Katuwanu Ankunytjanya’, nyura ngalkula ngayunya kuliṟa waḻkuntjaku Mayatja Godanya. ");
INSERT INTO pjt_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Panya munga pala palula ngayulu manta Itjipalawanu para-pitjaliṟa Itjipanya nguraṟa tjuṯaku katja ngaṉmanypa ngarinytja uwankara pungkula wiyalku tjanampa kuka tjuṯaku katja ngaṉmanypa ngarinytja tjuṯa kuḻu. Panya ngayuluṉa Mayatja Godanya, munuṉa ngayulu Itjipaku god uwankara wiyalku. ");
INSERT INTO pjt_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Ka milkaḻi panya yiwaḻa tjaangka ngaṟanytjitja tjuṯangku nintilku ngayulu nyakula ngurkantankunytjaku, ‘Munta, nyangatja Israelkunu tjuṯaku yiwaḻa.’ Munuṉa milkaḻi panya nyakula tjarpawiyangku wantira katuwanu kutju ankuku, munuṉa Itjipanya nguraṟa tjuṯa kutju pungkula wiyalku. ");
INSERT INTO pjt_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Ka nyura Israelkunu tjuṯangku tjiṉṯu nyanga palunya rawangku kulinma watarkurinytja wiyangku munuya yiya kutjupa yiya kutjupa tjiṉṯu nyanga paluṟu wirkankunyangka kuka mai palu puṟunypaṯu ngalkunma ngayunya Mayatja Godanya kuliṟa waḻkuntjikitjangku. Kaya nyurampa walytjapitingku maḻatja maḻatjangku kuḻu uti palu puṟunypaṯu aṟa nyanga palunya tiṯutjarangku kuliṟa palyanma watarkurinytja wiyangku. ");
INSERT INTO pjt_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","“Uwa, nyura uti tjiṉṯu kuranyitjangka yiitja panya mai taḻṯulpainya waḻingka kanyintjatjanungku uwankara mantjiṟa waṉima. Munuya palulanguṟu tjiṉṯu 7 mai pilytja kutju pauṟa ngalkunma mai yiitjatjara wantira. Tjinguṟu kutjupangku tjiṉṯu nyara palula tjanala mai yiitjatjara ngalkulampa paluṟu nyurala tjungu ngayuku walytja nyinanytja wiyaringkuku. ");
INSERT INTO pjt_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Munu tjiṉṯu panya ngaṉmanyitjangka nyura uti inmangka tjunguringkula ngayunya waḻkunma. Munuya palulanguṟu tjiṉṯu 6 ngaṟala wiyaringkunyangka mungawinki tjiṉṯu 7-itja piṟuku palu puṟunypaṯu inmangka tjunguringama. Munu tjiṉṯu nyanga palula pulala nyura uti waṟka wiya nyinama kutjupa kutjupa palyantja wiya alatjiṯu, palu palyaya mai munu kuka ngalkuntjaku kutju palyanma. ");
INSERT INTO pjt_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Munuya aṟa nyanga mai pilytja kutju ngalkuntja rawangku kulinma watarkurinytja wiyangku munuya yiya kutjupa yiya kutjupa tjiṉṯu nyanga paluṟu wirkankunyangka palu puṟunypaṯu palyanma nyanga nyura kuwari palyantja puṟunypa. Munuya ruuru kulinma panya ngayulu tjiṉṯu nyanga palula nyuranya uwankara Itjipalanguṟu pakaltjingaṟa katingu. Kaya nyurampa walytjapitingku maḻatja maḻatjangku kuḻu uti palu puṟunypaṯu aṟa nyanga palunya tiṯutjarangku kuliṟa palyanma watarkurinytja wiyangku. ");
INSERT INTO pjt_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Uwa, yiya kutjupa yiya kutjupa piṟa panya ngaṉmanyitja wirkankunyangkaya paṯaṟa nyinama tjiṉṯu 14 ngaṟala wiyaringkunytjaku, munuya palulanguṟu tjiṉṯu tjarpanyangka mai panya pilytja kutju pauṟa ngalkunma yiitjatjara wiya, munuya tjiṉṯu 7 mai palu puṟunypa kutju ngalkunma. ");
INSERT INTO pjt_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","20","Munuya tjiṉṯu panya palula tjanala yiitja nyurampa ngurangka kanyintja wiyangku wantima. Tjinguṟu kutjupangku aṉangu Israelkunungku munta tjinguṟu malikitjangku nyurala tjungu nyinapaingku tjiṉṯu nyara palula tjanala mai yiitjatjara ngalkulampa paluṟu nyurala tjungu ngayuku walytja nyinanytja wiyaringkuku.” Alatji Godalu Mosela pulala Aaronta wangkangu Israelkunu tjuṯangka tjakultjunkunytjaku. ");
INSERT INTO pjt_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Ka Moselu Israelkunu wati puḻka tjuṯa aḻṯira wangkangu, “Ankulaya nyurampa kuka tjuṯanguṟu lamalama ngurkantaṟa mantjila munuya iluntara nyurampa walytjapitingku aṟa nyanga Katuwanu Ankunytjanya ngalkula kulintjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Munuya lamalama panya palunya iluntankula milkaḻi pitingka tjutila munuya puṉu tjukutjuku tjuṯa nyaḻpi winki kaṯantaṟa karpiṟa nyaḻpi milkaḻingka tjaḻatjura, munuya yiwaḻa tjaangka katutja nyiṯila kampa kutjara kuḻu. Munuya nyara palulanguṟu munga pala palula yiwaḻa unngu kutju rawa nyinama pakantja wiya mungawinki kutju uṟilkutu pakantjikitja. ");
INSERT INTO pjt_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Ka Mayatja Godanya Itjipala ngura winkiwanu para-ngaṟaku tjananya pungkunytjikitja Itjipanya nguraṟa tjuṯa. Munu paluṟu waḻi tjaangka katu, kantilytja kuḻu milkaḻi ngaṟanyangka nyakula katuwanu ankuku nyura unngu nyinanyangka nyuranya pungkunytja wiya. Paluṟu palumpa angelpa waḻi pala palula tjanalakutu nyuranya tjarpara pungkunytjaku iyantja wiyangku wantiku. ");
INSERT INTO pjt_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Kaya aṟa nyanga palunya tiṯutjarangku kulinma watarkuriwiyangku munu wangaṉarangku kuliṟa palyanma yiya kutjupa yiya kutjupa. Ka nyurampa katja tjuṯangku kuḻu uti palu puṟunypaṯu aṟa nyanga palunya tiṯutjarangku palyanma watarkurinytja wiyangku nyurampa walytjapiti maḻatja maḻatjangku kuḻu. ");
INSERT INTO pjt_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Ka ngula panya Mayatja Godalu manta panyatja kalkuntjatjanungku nyuranya ungkuku. Ka nyura ngura nyara palula wirkaṟa nyinara aṟa nyanga palunya palu puṟunypaṯu rawangku palyalkatima yiya kutjupa yiya kutjupa, watarkurinytja wiyangku. ");
INSERT INTO pjt_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Ka nyurampa tjitjingku tjinguṟu tjapilku, ‘Nyaakula nyangatja kuka pungkula ngalkuni? Nyaanguṟu?’ ");
INSERT INTO pjt_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Kaya tjanala wangka alatji, ‘Nyangatjala kuka lamalama pungkula ngalkuṉi Katuwanu Ankunytjanya ruuru kuliṟa Godanya waḻkuntjikitjangku. Panya paluṟu ngura Itjipala Israelkunu tjuṯaku yiwaḻa tjuṯangka katuwanu anu tjarpara tjananya pungkunytja wiya, munu panya tjananya kutju pungu Itjipanya nguraṟa tjuṯa munu nganaṉanya wankaṟunu.’ Alatji tjanala tjakultjuṟa tjitji panya tjuṯangka.” Ka Moselu tjukurpa nyanga palunya tjanala wangkanyangkaya Israelkunu tjuṯangku kuliṟa tultjungaṟakatingu munuya Godanya waḻkuningi. ");
INSERT INTO pjt_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Munuya palulanguṟu wangaṉarangku kuliṟa palyaṉu uwankara Godalu Mosela pulala Aaronta wangkanytjitja tjuṯa. ");
INSERT INTO pjt_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Ka munga kultungka Godalu ngura panya Itjipala manta winkingka iluntaṟa wiyaṉu Itjipanya nguraṟa tjuṯaku katja ngaṉmanypa ngarinytja uwankara. Munu paluṟu Piiṟaku katja ngaṉmanyitja iluntanu munu palumpa wati mayatja tjuṯaku katja ngaṉmanyitja tjuṯa kuḻu uwankara wiyaṉu. Munu piṟuku tjailangka nyinanytja tjuṯaku katja ngaṉmanyitja tjuṯa kuḻu uwankara wiyaṉu. Munu piṟuku Itjipanya nguraṟa tjuṯaku kuka ngultju tjuṯaku katja ngaṉmanyitja uwankara kuḻu wiyaṉu. ");
INSERT INTO pjt_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Kaya munga kultungka Piiṟanya tjana wankaringkula pakaṉu palumpa wati mayatja tjuṯa kuḻu munu Itjipanya nguraṟa uwankara kuḻu, munuya nyakula puḻkaṟa mirara ulangi Itjipala winkingka tjituṟu-tjituṟu puḻka utiringkunyangka, panya yiwaḻa uwankarangka katja ngaṉmanypa ngarinytja tjuṯa uwankara ilungu. ");
INSERT INTO pjt_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Ka munga pala palula Piiṟalu wituṉu Mosenya pulanya Aaronnga aḻṯinytjaku munu pitjanyangka pulala wangkangu, “Pakaṟaya ara Israelkunu uwankara! Ngura nganampaya wantikati! Palyaya ankula Mayatja Godanya waḻkunma panya nyura ngaṉmanytju ngayula rawangku tjapiningi. ");
INSERT INTO pjt_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Munuyanku tjiipi tjuṯa, nanikuta tjuṯa, puluka tjuṯa kuḻu uwankara ma-kati. Munutjuya Godala tjapinma paluṟu ngayunya pukuḻmankunytjaku.” ");
INSERT INTO pjt_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Ka Itjipanya nguraṟa tjuṯangku tjananya walawalaningi Israelkunu tjuṯa alatji wangkara, “Wala puḻkaya pakaṟa ara munuya nganampa ngura wantikati. Tjinguṟu nyura nganaṉanya wantikatinytja wiyangkampa nganaṉa uwankara iluku.” ");
INSERT INTO pjt_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Kaya mulapaṯu warpungkula mai panya ngaṉmanytju uṟuṟa kapuṯu-kapuṯuṟa palyantja wanka tjunu yiitja wiyatja piti paulpai tjuṯangka munuya mantarangka karpiṟa piningka tjunkula katingi. ");
INSERT INTO pjt_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Munuya Moselu wangkanyangka Itjipanya nguraṟa tjuṯangka ngatjinu kutjupa kutjupa wiṟu tjuṯaku, tjiilpa, gold munu mantara kuḻu tjananya ungkunytjaku. ");
INSERT INTO pjt_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Ka Godalu tjananya Itjipanya nguraṟa tjuṯa wangaṉararingkula ungkunytjaku palyaṉu. Kaya mulapaṯu uwankarangku tjananya mapalkungku ungangi Israelkunu panya tjuṯa kutjupa kutjupa wiṟu tjuṯaku tjana ngatjinnyangka. Alatjiya Israelkunu tjuṯangku tjanampa kutjupa kutjupa wiṟu tjuṯa tjanalanguṟu mantjiṟa katingu. ");
INSERT INTO pjt_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Munuya paluṟu tjana uwankara ma-pakaṉu ngura panya Ramatjinya wantikatira munuya tjina anangi kakaraṟa ngura ini Tjukatjaku. Paluṟu tjana panya aṉangu mungilyi mulapa anangi, panya wati nampa nyangatja 600,000 munu puḻka-minyma puḻka-tjitji kuḻu. ");
INSERT INTO pjt_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Kaya aṉangu kutjupa tjuṯa mulapa kuḻu tjanala tjunguringkula anangi Israelkunu tjuṯaku walytja wiya tjuṯa. Kaya Israelkunu tjuṯaku tjiipi nanikuta tjuṯa mulapa tjanala tjungu anangi puluka tjuṯa mulapa kuḻu. ");
INSERT INTO pjt_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Munuya nguṟurpa ngura tjunkula nyuma panya wanka yiitja wiyatja Itjipalanguṟu panya katinytjitja pauningi. Panya tjananya Itjipalanguṟu paiṟa iyannyangkaya warpungkula anu mai yiitjatjara taḻṯuringkunytjaku puṯu paṯaṟa. Palulanguṟuya mai pilytja kutju pauṟa ngalkuningi. ");
INSERT INTO pjt_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Uwa, Israelkunu tjuṯaya rawa mulapa nyinangi ngura panya Itjipala yiya tjuṯa mulapa 430. ");
INSERT INTO pjt_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Munu panyaya yiya 430 wiyaringkunyangka nyara palula aṟa alatjiṯu Itjipanya wantikatira anu Mayatja Godaku panya walytja uwankara. ");
INSERT INTO pjt_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Ka panya munga pala palula Godalu tjananya aṯunymaṟa katiṟinangi Itjipalanguṟu ankunyangka. Kaya pala palulanguṟu Israelkunu tjuṯangku tiṯutjarangku yiya kutjupa yiya kutjupa munga panya paluṟu wirkankunyangka aṟa panya palunya kulilpai panya Mayatja Godalu tjananya aṯunymaṟa katiṟinkunytjitja, munuya kunkunpa wiyangku nyinara kulilpai Godaku pukuḻarira. ");
INSERT INTO pjt_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Ka Mayatja Godalu Mosela pulala Aaronta wangkangu, “Kuwariṉa nyupalila tjakultjunanyi aṟa panya Katuwanu Ankunytjanya tjukaṟurungku kanyintjaku. Uti aṉangu malikitjangku kuka mai Katuwanu Ankunytjitja ngalkuwiyangku wantima. ");
INSERT INTO pjt_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Palu tjinguṟu wati malikitja nyuntula waṟkaripai ngalkuntjikitja mukuringkuku. Ka alatji mukuringkunyangka nyuntu palunya nyuranya puṟunypa watila, ka pala palulanguṟu watiringkula kutju palya ngalkuku. ");
INSERT INTO pjt_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Ka palu puṟunypaṯu nyura aṉangu malikitja unytju akatjari nyinanyangka ungkuwiyangku wantima ngalkuntjaku, munu aṉangu maliki kutjupa nyurampa ngurangka manikitja waṟkarinyangka kuḻu ungkuwiyangku wantima. ");
INSERT INTO pjt_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Munuya kuka panya waḻi unngu pauntjatjanungku waḻi pala palula kutju ngalkunma uṟilkutu pakaltjingantja wiyangku. Munuya kuka iltjanpa palyaṟa tarka kaṯantankunytja wiyangku wantima. ");
INSERT INTO pjt_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Palu uti nyura Israelkunu uwankarangkuṯu aṟa nyangatja kanyinma munuya tjungungku pukuḻṯu palyanma. ");
INSERT INTO pjt_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Ka tjinguṟu wati malikitja nyurala tjungu nyinanyi, munu paluṟu tjinguṟu mukuringanyi nyurala tjungungku ngalkuntjikitja. Ka alatji mukuringkunyangka nyura palunya munu palumpa walytja nyiṯayira tjuṯa kuḻu nyuranya puṟunypa watila. Ka pala palulanguṟu tjana palyalta ngalkuku nyurala tjungungku paluṟu tjana wati Israelkunu puṟunyarira. Palu wati, tjitji nyiṯayira kuḻu nyuranya puṟunyarinytja wiyatja kuka Katuwanu Ankunytjitja ngalkuntjaku ungkuwiyangku wantima. ");
INSERT INTO pjt_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Nyanga alatjiya palyala wati, tjitji nyiṯayira uwankaraku, Israelkunu tjuṯaku, malikitja tjuṯaku kuḻu palu puṟunyarinytjaku, panya wati tjuṯangku, tjitji nyiṯayira tjuṯangku kuḻu watiringkula kutju ngalkuntjaku mai kuka panya Katuwanu Ankunytjitja.” Alatji Godalu Mosela pulala Aaronta wangkangu. ");
INSERT INTO pjt_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Ka Israelkunu uwankarangku wangaṉarangku kuliṟa palyaṉu Godalu Mosela pulala Aaronta wangkanytja. ");
INSERT INTO pjt_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Ka tjiṉṯu pala palula Mayatja Godalu Israelkunu uwankara uṯuḻu kutju pakaltjingaṟa katingu ngura panya Itjipalanguṟu. ");
INSERT INTO pjt_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Ka Mayatja Godalu Mosela wangkangu, ");
INSERT INTO pjt_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Kungkawaṟa Israelkunu tjuṯangku iṯi nyiṯayira ngaṉmanypa ngarinytja tjuṯa kanyinnyangka iṯi palunya tjananya miḻmiḻmaṟa kanyinma ngayuku. Panya Israelkunu tjuṯaku katja ngaṉmanyitja tjuṯa uwankara ngayuku, munu panya nyurampa kukaku katja ngaṉmanyitja uwankara kuḻu nyura ngayunya ungama panya paluṟu tjana ngayuku uwankara.” ");
INSERT INTO pjt_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Ka Moselu aṉangu tjuṯangka tjakultjunangi Godalu wangkanytja nyanga alatji, “Kulinmaya tjiṟirpi nyanga palunya munuya rawangku ruuru kulinma watarkurinytja wiyangku panya tjiṟirpi nyanga palula nyura Itjipanya wantikatingu. Panya ngura nyanga palula Itjipanya nguraṟa tjuṯangku nyuranya pauntjingaṟa puḻkaṟa alatjiṯu waṟkamilaningi. Ka tjiṟirpi nyanga palula panya Godalu nyuranya witulya puḻkangku pakaltjingaṟa katingu. Ka tjiṉṯu nyanga palulaṯu nyura ngula yiya kutjupa mai pilytja kutju pauṟa ngalkunma mai yiitjatjara wantira. ");
INSERT INTO pjt_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Panya tjiṟirpi nyanga palula nyura kuwari piṟa panya ini Apipala ngura nyanga Itjipanya wantikatira ma-pakaṉi. ");
INSERT INTO pjt_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Ka nyangatja panya Mayatja Godalu iriti kalkuṉu nyurampa walytja ngaṉmanyitja tjuṯa Aipuṟamanya tjananya manta panya Kainannga nyuranya ungkunytjikitjangku. Palu manta nyara palula panya aṉangu kutjupa tjuṯa kuwari nyinara waṉaṉi ngura tjuṯangka, aṉangu nyanganpa – Kainankunu tjuṯa, Iitakunu tjuṯa, Amurkunu tjuṯa, Piṟitjikunu tjuṯa, Ipakunu tjuṯa, munu Tjaipukunu tjuṯa kuḻu. Ka manta nyara paluṟu wiṟu mulapa, ka nyara palula mai puḻka pakalpai ngura manta palyangka. Ka Godalu nyuranya nyara palulakutu katinyangka nyura uti aṟa nyanga mai pilytja ngalkuntjanya rawangku palyanma watarkurinytja wiyangku munuya yiya kutjupa yiya kutjupa piṟa panya Apipala tjiṉṯu nyanga paluṟu wirkankunyangka palu puṟunypaṯu palyanma munuya mai pilytja kutju ngalkunma aṟa nyanga palunya ruuru kulintjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Munuya mai pilytja panya tjiṉṯu 7 ngalkukatima. Munuya tjiṉṯu panya 6 ngaṟala wiyaringkunyangka mungawinki tjiṉṯu 7-ta inma puḻka palyanma Mayatja Godanya waḻkuntjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Uwa, tjiṉṯu nyanga palula tjanalaya mai pilytja kutju ngalkunma, munuya mai taḻṯu kanyintja wiyangku waṉima, yiitja kuḻuya nyurampa nguranguṟu mantjiṟa waṉi, munuya ngura kutjupangka kutjupangka kanyintja wiyangku wantima. ");
INSERT INTO pjt_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Munu nyura uti aṟa nyanga palunya palyantjikitjangku ngaṉmanytju nyurampa katja ngaṉmanypa ngarinytja tjuṯangka wangkara utinma alatji wangkara, ‘Nganaṉa nyangatja palyaṉi Godanya waḻkuntjikitjangku, panya paluṟu tjiṉṯu nyanga palula nganaṉanya Itjipalanguṟu pakaltjingaṟa wankaṟunu.’ Alatjiya katja tjuṯangka wangkama. ");
INSERT INTO pjt_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","10","Uwa, yiya kutjupa yiya kutjupa tjiṉṯu nyanga paluṟu wirkankunyangkaya aṟa nyanga mai pilytja ngalkuntjanya palu puṟunypaṯu palyanma watarkurinytja wiyangku ngalkula ruuru kulintjikitjangku. Munu palulanguṟu nyura kuliṟa Godalu wituntjitja tjuṯa kuḻu wangkara tjakultjunkuku maḻatja tjuṯangka paluṟu tjana kuḻu nintiringkula wangaṉarangku kulintjaku, panya Mayatja Godalu nganaṉanya witulya puḻkangku Itjipalanguṟu pakaltjingaṉu. Uwa, aṟa nyanga paluṟu walka puṟunypa ngaṟaku nyurampa manyirkangka nyura watarkurinytjaku-tawara.” Alatji Moselu Israelkunu tjuṯangka tjakultjunangi. ");
INSERT INTO pjt_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","12","Munu piṟuku tjanala tjakultjunangi panya Godalu wangkanytja aṟa panya katja ngaṉmanypa ngarinytja tjuṯa. Alatji paluṟu wangkangu, “Mayatja Godalu nyuranya ma-katiku ngura panya Kainantakutu. Panya paluṟu nyuranya ngaṉmanytju kalkuningi ungkunytjikitjangku nyurampa walytja miri tjuṯa kuḻu. Ka nyuranya ungkunyangka nyura uti nyurampa katja ngaṉmanyitja uwankara palunya ngapartji ungama, kuka panya katja ngaṉmanyitja tjuṯa kuḻu. Panya katja ngaṉmanypa ngarinytja uwankara palumpa Godaku, kaya palunya ungama. ");
INSERT INTO pjt_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Palu nyura tangkiyi nyiṯayira ngaṉmanyitja tjuṯa ungkunytjatjanungkumpa maḻakungku mantjila Godalanguṟu palunya lamalama ma-ungkula ngapartji palu puṟunypaṯu. Palu tjinguṟu nyuntu tangkiyi palunya wantiku lamalama ungkula maḻakungku mantjintja wiyangku. Palulanguṟu nyuntu uti tangkiyi palunya iluntanama ngunti kaṯantankula. Uwa, munuya nyurampa tjitji katja ngaṉmanypa ngarinytja tjuṯa Godanya ungkunytjatjanungku maḻakungku mantjinma mani ma-ungkula. ");
INSERT INTO pjt_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“Ka ngula nyura kuka pungkula ungkunyangka nyurampa katja tjuṯangku tjinguṟu tjapilku, ‘Nyaa nyanga alatji?’ Kaya palula tjanala alatji wangka, ‘Panya iriti Itjipanya nguraṟa tjuṯangku tjanampa ngurangka nganaṉanya pauntjingaṟa puḻkaṟa waṟkamilaningi. Ka panya Mayatja Godalu nganaṉanya witulya puḻkangku ngura nyara palulanguṟu pakaltjingaṟa ngalya-katingu. ");
INSERT INTO pjt_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Panya Itjipaku mayatjangku Piiṟalu tungun-tunguntu nganaṉanya kanyiningi wantir'iyantja wiyangku, ka Godalu tjanampa katja ngaṉmanypa ngarinytja uwankara iluntanu Itjipanya nguraṟa tjuṯaku, tjanampa kukaku katja ngaṉmanyitja uwankara kuḻu. Kala nyara palulanguṟu nganaṉanku kuka tjuṯaku katja ngaṉmanyitja uwankara Godanya ungkupai pungkula, munu nganampa katja ngaṉmanyitja uwankara Godanya ungkunytjatjanungku maḻakungku payamilalpai. Alatjila palyalpai aṟa nyanga palunya kulintjikitjangku panya Godalu Itjipanya nguraṟa tjuṯaku katja ngaṉmanypa ngarinytja tjuṯa iluntankunytja.’ Alatjiya katja tjuṯangku tjapinnyangka wangkama. ");
INSERT INTO pjt_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Uwa, yiya kutjupa yiya kutjupa aṟa nyanga palunya palyaṟa nyura ruuru kulilku watarkurinytja wiyangku, panya Mayatja Godalu nganaṉanya witulya puḻkangku Itjipalanguṟu pakaltjingantja. Ka aṟa nyanga paluṟu walka puṟunypa ngaṟaku nganampa manyirkangka nganaṉa watarkurinytjaku-tawara.” Alatji Moselu Israelkunu tjuṯangka wangkangi. ");
INSERT INTO pjt_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Ka Piiṟalu aṉangu panya Israelkunu tjuṯa wantir'iyannyangka Godalu tjananya ngura panya Kainantakutu tjukaṟurungku katinytja wiyaṯu Pilitjiyaku iwarangka panya iwara nyara paluṟu muṯumuṯu. Palu Godalu tjananya katingu iwara kutjupawanungku aḻa-waṟangka. Panya paluṟu kulinu nyanga alatji, “Wati Pilitjiyanya nguraṟa tjuṯangku tjinguṟu nyanga tjananya pikangku pungkuku tjanampa ngurawanu ankunyangka. Kaya tjinguṟu nguḻuringkula maḻaku ankuku Itjipaku. Kaṉa pala palula-tawara tjananya iwara kutjupawanungku katiku ngura ilytjiwanungku.” ");
INSERT INTO pjt_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Nyanga alatji Godalu kulinu munu Israelkunu tjuṯa purkaṟangku katiṟinangi parariwanu para-pitjanytjaku kakaraṟa uṟu ini Tjitin-tjitintakutu. Kaya paluṟu tjana kuḻaṯatjara, tjuḻa waṟatjara kuḻu anangi pikakitja. ");
INSERT INTO pjt_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Ka Moselu tjana miri panya Josephanya katiṟinangi, panya iriti ilunytja kuwaripangka Josephalu aṉangu Israelkunu tjuṯangku wangkangu nyanga alatjingantjaku. Alatji paluṟu wangkangu tjanala, “Ngula Godalu nyuranya Itjipalanguṟu walatjunkunyangkampaya ngayunya kulinma ngayuku puntu ma-katinytjikitjangku ngura nyanga Itjipalanguṟu.” Kaya mulapaṯu palunya puntu ma-katingu. ");
INSERT INTO pjt_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Kaya Israelkunu tjuṯa Itjipanya wantikatira ankula ngaringu ngura ini Tjukatjala. Munuya palulanguṟu Tjukatjanya wantikatira anu ngura ini Itjamalakutu munuya nyara palula ngura ma-tjunu panya pila mulyangka. ");
INSERT INTO pjt_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Ka Mayatja Godalu tjananya kuranyurira katiṟinangi. Kaḻaḻa paluṟu ngangkaḻi waṟangka kuranyu anangi tjana nyakula waṉantjaku. Munu mungangka paluṟu waṟu tili puḻkangka anangi tjana mungangka irnyannyangka nyakula waṉantjaku. Alatjiya anangi kaḻaḻa mungangka kuḻu Godalu katiṟinkunyangka. ");
INSERT INTO pjt_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Ka ngangkaḻi waṟa tiṯutjara tjanala kuranyuringi kaḻaḻa kutjupa kaḻaḻa kutjupa. Ka waṟu tili puḻka panya palu puṟunypaṯu tjanala kuranyuringi munga kutjupa munga kutjupa. ");
INSERT INTO pjt_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Ka palulanguṟu piṟuku Mayatja Godalu Mosela wangkangu, ");
INSERT INTO pjt_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Wangka Israelkunu tjuṯa maḻaku ankula ngarinytjaku ngura ini Pii-ayiṟatjala itingka panya ngura Miikatala pulala uṟu ini Tjitin-tjitinta nguṟurpa, panya nyanga paluṟu ngura ini Paal Tjipanta itingka ");
INSERT INTO pjt_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Ka palulanguṟu Piiṟalu kulilku Israelkunu tjuṯaya kawaliringu munuya nguṟurpaṯu para-pitjalinanyi pilangka ma-tjarpanytja wiyaṯu. ");
INSERT INTO pjt_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Ka ngayulu Piiṟanya piṟuku palyalku tungun-tungunarinytjaku ngayula. Ka paluṟu kampa kutjuparira warmaḻarira nyuranya nguḻuṟa waṉalku. Ka ngayulu nyurampa ngalkiltu wiyalku alatjiṯu palumpa warmaḻa uwankara. Kaya Itjipanya nguraṟa tjuṯangku nintiringkula kulilku panya mulapa ngayuluṉa Mayatja Godanya.” Nyanga alatji Godalu Mosela wangkangu, ka paluṟu Israelkunu tjuṯangka tjakultjunu, kaya mulapaṯu maḻaku anu, munuya nguṟurpa ngaringi. ");
INSERT INTO pjt_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Ka ngura nyara Itjipala wati kutjupangku pitjala Piiṟala wangkangu, “Israelkunu tjuṯaya anu.” Ka Piiṟalu tjana palumpa wati mayatja tjuṯangku kuliṟa mapalku kampa kutjuparingu munuya wangkangu, “Nyaaṉula panyatja? Nyaakula panyatja wantir'iyaṉu Israelkunu panya tjuṯa. Kuwari nganalu tjana nganampa waṟka palyalku? Panya wantir'iyaṉula nganampa waṟkatjara tjuṯa.” ");
INSERT INTO pjt_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","7","Ka Piiṟalu wangkangu palumpa wati mayatja tjuṯangka, “Warpungkulaya nyanytju mantjiṟa tanpala ngayuku tjingkangka. Munuya wati tjaultji tjuṯa wangka tjana kuḻu nyanytju tjuṯa mantjiṟa tjingka wiṟu tjuṯangka 600-ngka tanpantjaku. Munuya tjaultji kutjupa tjuṯa kuḻu wangka kuḻaṯa kuṯitji kuḻu mantjiṟa tjanampa tjingkangka tatiṟa riti ngaṟanytjaku.” Kaya uwankara ritiringkula tjingka kutju kutjungka tatiṟa mayatja panya Piiṟala tjunguringu munuya warmaḻarira ma-pakaṉu tjaultji tjuṯa mulapa. Kaya Piiṟaku wati mayatja tjuṯangku tjananya wituwituṟa katiṟinangi. ");
INSERT INTO pjt_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Uwa, Godalu Piiṟanya tungun-tungunarinytjaku piṟuku palyaṉu. Ka paluṟu warmaḻa tjuṯatjarangku Israelkunu tjuṯa waṯaparaṉu. Palu Israelkunu tjuṯaya ngura Itjipanya wantikatinytjatjanu raparingkula pukuḻpa alatjiṯu anangi. ");
INSERT INTO pjt_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Kaya Itjipanya nguraṟa tjuṯangku tjingka tjuṯangka nyanytju tjuṯangka kuḻu tatiṟa tjananya maḻawanungku waṯaparaningi munuya waṉaṟa nyangu uṟu panya ini Tjitin-tjitinta itingka ngurangka nyinanyangka, ngura panya tawunu ini Pii-ayiṟatjala pulala Paal Tjipanta itingka. ");
INSERT INTO pjt_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Kaya Israelkunu tjuṯangku maḻakukutuṟa nyangu Piiṟanya tjana warmaḻa ngalya-ilaringkunyangka munuya puḻkaṟa alatjiṯu nguḻuringkula Godanya puḻkaṟa ulara tjapiningi tjananya wankaṟunkunytjaku. ");
INSERT INTO pjt_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Munuya Moseku mirpaṉarira palula wangkangu, “Nyaakulanyan nyanga ilytjikutu ngalya-katingu? Nyaa, ilunytjakulanyan katingu? Utila Itjipala ma-nyinara iluma. ");
INSERT INTO pjt_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Panya ngura nyara palulalpi nganaṉa nyuntunya wangkangu nganaṉanya wantinytjaku. Tjinguṟula palya alatjiṯu Itjipala tiṯutjara nyinara tjanampa waṟkarima. Palu nyuntulanyan ngalya-katingu nyanga pilangka ilunytjaku.” ");
INSERT INTO pjt_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Ka Moselu tjanala wangkangu, “Nyaaku nyura nguḻuringanyi? Nguḻu wiyangkuya paṯaṟa nyawa. Kuwari Mayatja Godalu nyuranya wankaṟunanyi, ka nyura wankaringkula nyanga Itjipanya nguraṟa warmaḻa tjuṯa piṟuku nyakunytja wiyaringkuku. ");
INSERT INTO pjt_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Panya Mayatja Godalu tjananya ngalkiltu wiyalku. Ka nyura ngaṟala kutju nyakuku pikangku pungkunytja wiyangku.” ");
INSERT INTO pjt_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Ka Godalu Mosela wangkangu, “Nyaakun ngayunya ulara tjapini? Wangka tjananya Israelkunu tjuṯa pakaṟa ma-pitjanytjaku uṟukutu. ");
INSERT INTO pjt_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Ka nyuntu tjukarangka uṟungka katuwanungku wiḻitjuṟa kanyinma. Ka uṟu pala tjararingkula iwara puṟunyariku Israelkunu tjuṯa ma-itipirinytjaku uṟungka nguṟurpa manta piḻṯingka. ");
INSERT INTO pjt_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Kaṉa tjananya Itjipanya nguraṟa tjuṯa unngu wituwitulku nyuranya tungun-tunguntu waṯaparantjaku, kaya tjana uṟuwanungku waṉalku. Kaṉa tjananya uwankara uṟungka iluntankula wiyalku Itjipanya nguraṟa warmaḻa panya tjuṯa Piiṟanya kuḻu, munuṉa nyanytju tjuṯa tjingka tjuṯa kuḻu wiyalku. Palulanguṟu uwankara pungkula wiyannyangka nyakulaya aṉangu Israelkunu tjuṯangku ngayunyalta mirawaṉiku. ");
INSERT INTO pjt_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Kaya Itjipanya nguraṟa tjuṯangku nintiringkula kulilku panya mulapa ngayuluṉa Mayatja Godanya.” Nyanga alatji Godalu tjakultjunu Mosela. ");
INSERT INTO pjt_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","20","Ka panya angelpa Godaku Israelkunu tjuṯangka kuranyu anangi ngangkaḻi panya waṟangka. Palu Itjipanya nguraṟa warmaḻa tjuṯa ilaringkunyangka angelpa paluṟu Israelkunu tjuṯangka maḻaringkula anga-ngaṟangi warmaḻa tjuṯangka tjangaṯi, ka ngangkaḻi panya waṟa puḻka kuḻu tjanala kuranyunguṟu maḻaringkula anga-ngaṟangi munga waṟangka. Ka ngangkaḻingka muṉkara maṟu mulapa ngaṟangi, kaya Itjipanya nguraṟa tjuṯangku puṯu nyangangi. Palu ngangkaḻingka tjangaṯi pitalytjingku puḻkaṟa irnyaningi Israelkunu tjuṯangku uti nyakunytjaku. Kaya munga waṟangka Itjipanya nguraṟa tjuṯa tjanala puṯu ilaringangi, panya puṯuya nyangangi. ");
INSERT INTO pjt_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Ka Moselu puṉu panya tjukara katuṟa wiḻitjunu uṟu panya tjitin-tjitinta katuwanungku, ka Godalu uṟu panya palunya mauṉṯalpaṉu waḻpa puḻka kakaraṟanguṟu iyaṟa. Ka waḻpa paluṟu mungangka tiṯutjara wangkangi munu uṟu wiyaṟa manta utinu, ka uṟu paluṟu kitikitiringkula tjararingu. ");
INSERT INTO pjt_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Kaya Israelkunu tjuṯa uṟungka nguṟurwanu itipiringu manta piḻṯingka. Ka waḻpangku panya uṟu tjaraṟa mauṉṯalpaṟa kampa kutjaranguṟu ma-nyuṯi-nyuṯiṟa kanyiningi tjana nguṟurpa iwara piḻṯingka ankunytjaku. ");
INSERT INTO pjt_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Ka tjananya Itjipanya nguraṟa tjuṯangku tjingkangka munu nyanytju tjuṯangka kuḻu tatiṟa maḻawanungku ngalya-waṯaparaningi. Munuya iwara panya palulaṯu anangi uṟungka nguṟurpa. ");
INSERT INTO pjt_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Ka palulanguṟu tjiṉṯu pakantja kuwaripangka Godalu ngangkaḻi waṟu tilitjaranguṟu walunyakula nguḻutjingaṉu Itjipanya nguraṟa warmaḻa tjuṯa, tjanampa nyanytju tjuṯa kuḻu. Kaya urulyaraṟa kawaṟu-kawaṟurira puṯu kuli-kulinu. ");
INSERT INTO pjt_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Ka Godalu tjingka tjuṯaku wiila tjuḻpirta tjakatjunkunytjaku palyaṉu tjana walawala ankunytjaku-tawara. Kaya palulanguṟu Itjipanya nguraṟa tjuṯangku nguḻungku wangkangu, “Walawalalanku wirtjapakala Israelkunu nyanga tjuṯanguṟu. Panya Mayatja Godanya tjanampa ngalkilpa kuwari nganampa pikaringanyi.” ");
INSERT INTO pjt_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Ka palulanguṟu Godalu Mosela wangkangu, “Katuṟa wiḻitjura uṟu katuwanungku nyuntumpa pala puṉungka, ka uṟungku piṟuku ngalya-tjunguringkula tjutulku tjananya munu patilku Itjipanya nguraṟa warmaḻa pala uwankara tjanampa tjingka tjuṯa, nyanytju tjuṯa kuḻu.” ");
INSERT INTO pjt_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Ka Moselu wiḻitjunu uṟu katuwanungku, ka mungawinki mulapa ngalya-tjiṉṯuringkunyangka uṟu panya kampa kutjaranguṟu ngaparku tjunguringkula iwara panya tjutuṉu. Kaya Itjipanya nguraṟa tjuṯa arkaṟa wirtjapakaningi uṟunguṟu pakantjikitja, palu Godalu tjananya uṟu unngu tjunyinu. ");
INSERT INTO pjt_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Ka uṟu panya paluṟu maḻaku tjunguringkula Piiṟanya tjananya uwankara tjutuṉu tjingka tjuṯa munu nyanytju tjuṯa kuḻu. Paluṟu tjana iwara panya palulaṯu Israelkunu tjuṯa ngalya-waṯaparaningi uṟungka nguṟurpa. Palu wiya, uwankara mulapaya uṟu tjikiṟa ngakaṟa ilungu. ");
INSERT INTO pjt_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Kaya Israelkunu tjuṯa palya alatjiṯu ma-itipiringu manta piḻṯingka ankula, ka uṟu panya puḻka kampa kutjara nyuṯi-nyuṯiringkula ngaṟangi tjananya tjutuntja wiya alatjiṯu. ");
INSERT INTO pjt_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Palu tjiṉṯu pala palula Mayatja Godalu tjanampa ngalkilarira tjananya wankaṟunu Itjipanya nguraṟa tjuṯanguṟu, kaya nyangu Itjipanya nguraṟa miri tjuṯa uṟu kantilytja ngarira waṉinyangka. ");
INSERT INTO pjt_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Panya Godalu witulya puḻkangku tjananya uwankara wiyaṉu Itjipanya nguraṟa tjuṯa. Kaya Israelkunu tjuṯangku uwankara iluntankunyangka nyakula puḻkaṟa nguḻuringu Godanya witulya puḻka kuliṟa. Munuya puḻkaṟa Godaku mulamularingangi, munu palunya wituntjitjaku Moseku kuḻu. ");
INSERT INTO pjt_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Ka Moselu tjana Israelkunu tjuṯangku kuḻu pukuḻpa mulatu inma inkara Godanya waḻkuningi, nyanga alatji, “Ngayulu Mayatja Godanya inkara mirawaṉinyi, panya wiṟuṟalanya wankaṟunu Itjipanya nguraṟa tjuṯa wiyaṟa. Paluṟu nyanytju tjuṯa uṟungka unngu tjunyinu, wati nyanytjungka tatilpai tjuṯa kuḻu. ");
INSERT INTO pjt_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Panya Mayatja Godalu kutjungku ngayunya witulyankupai. Nyara paluṟu kutjungkuṉi wankaṟunu. Nyara paluṟu ngayuku God, kaṉa ngayulu palunya mirawaṉinyi. Nyara paluṟu ngayuku mamaku God, kaṉa inma inkara palunya puḻkaṟa waḻkulku, witulya puḻka mulapa. ");
INSERT INTO pjt_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Panya paluṟu warmaḻa puḻka mulapa para-ngaṟapai, ini Mayatja Godanya. ");
INSERT INTO pjt_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Paluṟu wiyaṉu warmaḻa Itjipanya nguraṟa tjuṯa uṟungka unngu tjunyiṟa tjingka tjuṯa kuḻu. Kaya warmaḻa tjuṯaku mayatja tjuṯa ngakaṟa ilungu uṟu panya ini Tjitin-tjitinta. ");
INSERT INTO pjt_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Ka panya uṟu puḻkangku tjananya tjutuṟa patinu uwankara, kaya apu puṟunypa mantakutu ukalingu uṟu unngu ngaṯi puḻkakutu. ");
INSERT INTO pjt_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Mayatja God, nyuntu witulya puḻkangku palyalpai maṟa wakungku, munu nyuntu aṉangu mirpaṉtju tjuṯa kaṯantaṟa muṯun-muṯunmaṟa wiyalpai. ");
INSERT INTO pjt_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Nyuntu Mayatja witulya puḻka mulapa, munu nyuntumpa mirpaṉtju tjuṯa nyuntu wiyalpai alatjiṯu. Nyuntu panya tjanampa puḻkaṟa mirpaṉarira tjananya uwankara alatjiṯu wiyaṉu. Nyuntu panya waṟu puṟunypa, panya waṟungku ukaṟi kampara wiyalpai, pala palu puṟunytju nyuntu tjananya wiyaṉu. ");
INSERT INTO pjt_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Nyuntu panya uṟu puuṟa tjaraṟa iwaranu, ka panya uṟu puḻkanya tali puṟunypa wati-ngaringi. Ka ngaṯi panya tartjaringu munu iwara puṟunypalta ngaṟangi. ");
INSERT INTO pjt_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Kaya Itjipanya nguraṟa tjuṯangku wangkangu, ‘Wanyula Israelkunu tjuṯa waṯaparaṟa witila, munula tjana kanyintja uwankara mantjiṟa tjaraṟa kutjungku kutjungku ngurakutu kati. Walawalangkula tjuḻa waṟa mantjiṟa tjananya waṯaparaṟa pungama, munula mantjiṟa kati tjana kanyintja uwankara.’ Alatjiya warmaḻa tjuṯangku kaṉany-kaṉanytju wangkangi. ");
INSERT INTO pjt_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Palu Mayatja God, nyuntu uṟu panya puuṟa palunya tjananya tjutuṟa patinu Itjipanya nguraṟa tjuṯa, kaya apu tjuṯa puṟunypa uṟu unngu mantakutu ukalingkula ilungu. ");
INSERT INTO pjt_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Mayatja God, nyuntunya puṟunypa god kutjupa nyinanytja wiyaṯu. Nyuntu kutjun Mayatja Puḻkanya munu miḻmiḻpa alatjiṯu wiṟu mulapa. Nyuntu kutjupa kutjupa wiṟu tjuṯa witulya puḻkangku palyalpai aṉangu tjuṯa nyakula urulyaraṟa nguḻuringkunytjaku nyuntumpa. ");
INSERT INTO pjt_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Nyuntu maṟa waku katuṉu, ka tjananya mantangku kuuḻtjanu nganampa mirpaṉtju tjuṯa. ");
INSERT INTO pjt_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Nyuntu panya mukulya puḻkangku kalkuṉu Israelkunu tjuṯa wankaṟunkunytjikitjangku, munu panyan mulapa wankaṟu tjananya katiṟinanyi. Nyuntu witulya puḻkangku tjananya katiṟinkuku nyuntumpa ngurakutu, ngura panya miḻmiḻpakutu. ");
INSERT INTO pjt_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Kaya aṉangu ngura kutjupitja tjuṯangku kulilku. Munuya kuliṟa puḻkaṟa nguḻuringkula tjititingkuku. Ka aṉangu Pilitjiyanya nguraṟa tjuṯa puḻkaṟa alatjiṯu nguḻuringkuku. ");
INSERT INTO pjt_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Munu panya Iitamakunu tjuṯaku mayatja tjuṯangku puṯu kuli-kuliṟa puḻkaṟa nguḻuringkuku. Munu Mawapaku wati puḻka tjuṯa kuḻu puḻkaṟa nguḻuringkula tjititingkuku. Munu panya Kainannga nguraṟa tjuṯa kuḻu nguḻuringkula uparingkuku. ");
INSERT INTO pjt_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Uwa, mulapa paluṟu tjana uwankara puḻkaṟa nguḻuringkuku nyuntu witulya puḻkangku palyannyangka nyakula. Tjana tjititingkula nguḻungku pakaṟa ngaṟala nyakuku nyuntumpa aṉangu tjuṯa wati-pitjanyangka. Panya aṉangu nyanga tjananya nyuntunku mantjiṟa katingu Itjipala puḻkaṟa waṟkarinyangka. ");
INSERT INTO pjt_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Munun tjananya ngalya-katiku ngura panya puḻi nyuntumpangka, panya ngura pala palunyan nyuntu ngaṉmanytju kuliṟa ngurkantanu nyuntumpa ngura tjunkunytjikitjangku, ngura pala miḻmiḻpa nyuntu tjunkunytjitja. ");
INSERT INTO pjt_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Mayatja God, nyuntu tiṯutjarangku alatjiṯu uwankara aṯunymaṟa kanyilku mayatja puḻkangku, wiyaringkunytja wiyangku alatjiṯu.” Alatji Moselu tjana Israelkunu tjuṯangku kuḻu pukuḻpa mulatu inma inkara Godanya waḻkuningi. ");
INSERT INTO pjt_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Uwa, Israelkunu tjuṯa panya manta piḻṯingka itipiringu. Ka panya Itjipanya nguraṟa warmaḻa tjuṯa uṟungka nguṟurpa tjingkangka tatiṟa ankunyangka Mayatja Godalu uṟu maḻakungku tjunguṉu, ka tjananya tjutuṉu. ");
INSERT INTO pjt_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Ka palulanguṟu Aaronku pulampa Moseku kangkuṟungku Miriamalu tampuṟinpa mantjinu inma inkanytjikitjangku, panya maṟangku pungkula wangkatjingalpai inma inkara. Ka minyma uwankarangku palu puṟunypa tampuṟinpa tjuṯa mantjinu munuya minyma panya palunya uṟilkutu waṉaṟa inkara inmaku nyaṉpingi tampuṟinpa panya tjuṯa pungku-pungkula. ");
INSERT INTO pjt_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Ka Miriamalu tjanampa inma inkangi nyanga alatji wangkara, “Inma inkama Mayatja Godanya mirawaṉinytjikitjangku, panya paluṟu witulya puḻkangku tjananya pungkula wiyaṉu, Itjipanya nguraṟa tjuṯa. Paluṟu panya nyanytju tjuṯa uṟu unngu tjarpatjunu, wati nyanytjungka tatilpai tjuṯa kuḻu.” ");
INSERT INTO pjt_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Ka palulanguṟu Moselu tjananya ma-katingu Israelkunu tjuṯa, munuya uṟu panya Tjitin-tjitintanguṟu ma-paṯuringkula ma-ilytjingkaringu ngura pilangka ini Tjuula. Munuya tjiṉṯu maṉkurpa pilangka pitjaliṟa mina puṯu nguriningi. ");
INSERT INTO pjt_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Munuya ngura ini Maaṟala wirkaṟa mina nyangu. Palu mina paluṟu palya wiya kaṟur-kaṟurpa. (Ini “Maaṟanya” panya wangkanyi “kaṟur-kaṟurpa” tjanampa wangkangku.) ");
INSERT INTO pjt_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Kaya aṉangu tjuṯangku puṯu tjikiṟa Moseku mirpaṉarira wangkangu, “Mina nyaala tjikilku?” ");
INSERT INTO pjt_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Ka Moselu kuliṟa Mayatja Godala puḻkaṟa tjapiningi, “Yaaltjirikula?” Ka Mayatjalu Mosela nintinu puṉu mantangka ngarinyangka. Ka Moselu puṉu palunya mantjiṟa waṉingu minangka, ka mina panya mapalku palyaringu. Kaya tjikiningi. Ka ngura nyara palula Godalu tjukurpa kutjupa tjanala wangkangu Israelkunu tjuṯangka. Munu paluṟu arkaṟa nyangangi tjananya wangaṉarangku kulintjaku tjukurpa paluṟu wangkanytjitja. ");
INSERT INTO pjt_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Alatji paluṟu tjanala wangkangu, “Ngayuluṉa Mayatja Puḻkanya nyurampa Godanya, munuṉa nyuranya pikatjararingkunyangka palyaṟungulpai. Ka nyura uti tjukurpa ngayuku wangaṉarangku kuliṟa palyanma munuya ngayuku iwara tiṯutjarangku waṉanma. Kaṉa nyara palulanguṟu nyuranya tjukaṟurungku kuliṟa waṉannyangka pika ungkunytja wiyangku wantiku, panya ngayulu Itjipanya nguraṟa tjuṯa pikatjaraningi, palu puṟunypaṉa nyuranya ngayula wangaṉarangku kulinnyangka alatjinkunytja wiyangku wantiku.” Alatji Godalu tjanala wangkangu palula wangaṉarangku kulintjaku. ");
INSERT INTO pjt_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Kaya ngura nyara palulanguṟu ankula ma-wirkanu ngura kutjupangka ini Ilimala. Ka ngura pala Ilimala mina tjukuḻa ngaṯi 12-ngka ngaringi. Munu puṉu waṟa tjuṯa kuḻu ngaṟangi nampa 70. Kaya Israelkunu tjuṯangku pala palula ngura tjunu minangka itingka. ");
INSERT INTO pjt_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Munuya ngura pala Ilimala tjukutjuku nyinara piṟuku ma-pakaṉu. Munuya paluṟu tjana ankula ankula ma-wirkanu ngura pilangka ini Tjiinta. Panya ngura nyanga paluṟu ngaṟangi Ilimala pulala Tjaniyala nguṟurpa. Uwa, paluṟu tjana ngura panya Itjipanya wantikatinytjatjanu rawa anangi piṟa kutjara nguwanpa, munuya ngura nyanga Tjiinta wirkanu wiki 6-nguṟu. ");
INSERT INTO pjt_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","3","Palu pilangka panya mai wiya ngaṟangi. Kaya Israelkunu tjuṯa paḻtjatjiratjaringu, munuya uwankara mirpaṉaringu Moseku pulampa Aaronku. Munuya palula pulala ngalytjurmaṟa wangkangi, “Godalulanya uti wantima Itjipalanguṟu pakaltjingantja wiyangku munulanya ngura nyara palula iluntara wiyanma. Panya Itjipala nganaṉa paḻtja alatjiṯu nyinangi munula ngalkuningi kuka mai puḻka. Palu nyupali nganaṉanya ngalya-katingu nyanga ilytjikutu mai wiyangka ilunytjaku.” ");
INSERT INTO pjt_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Ka Mayatja Godalu Mosela alatji wangkangu, “Ngayulu kuwari mai ilkaṟinguṟu iyaṉi nyurampa, ka mina puṟunypa punkalku tjiṉṯukutu. Ka nyuntu aṉangu tjuṯangka wangka, kaya tjiṉṯu kutjupa tjiṉṯu kutjupa mai panya mantangka punkantja uranma. Palu tjiṉṯu kutjuku kutju mantjinma mungawinkiku mantjintja wiyangku. Kaṉa nyanganyi tjananya tjukaṟurungku urantjaku ngayulu panya wangkanytjitja tjana wangaṉarangku kuliṟa palyantjaku. Kaya tjinguṟu wangaṉarangku kulilku, tjinguṟuya wantiku ngayunya kulintja wiyangku. ");
INSERT INTO pjt_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Palu tjiṉṯu 5 ngaṟala wiyaringkula tjiṉṯu panya Friday-ngka paluṟu tjana uti mai puḻka nguwanpa uranma tjiṉṯu kutjaraku kuwariku munu Saturday-ku kuḻu, panya tjiṉṯu Saturday-ngka ngayulu mai iyantja wiyangku wantiku.” ");
INSERT INTO pjt_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Ka Moselu pula Aarontu nyangatja kulintjatjanungku Israelkunu tjuṯangka tjakultjunu alatji, “Mungartji kuwari nyanga nyura nintiringkula kulilku, ‘Munta-uwa! Mulapa Mayatja Godalu panya nganaṉanya Itjipalanguṟu ngalya-katingu.’ ");
INSERT INTO pjt_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","8","Panya paluṟu kulinu nyura rawangku ngalytjurmaṟa wangkanyangka. Ka palulanguṟu nyura mungawinki nyakuku Godalu kutjupa kutjupa witulya puḻkangku palyannyangka. Panya nyura ngalinya mirpaṉṯu wangkara waintaṟa palumpa kuḻu mirpaṉaringi, panya paluṟu wangkanyangka kutjuli ngali nyuranya ngalya-katingu. Ka palulanguṟu Mayatja Godalu nyuranya tjiṉṯu kutjupa tjiṉṯu kutjupa mungartjikutu kuka ungkuku munu paluṟu mungawinki nyuranya mai puḻka ungkuku nyura ngalkula paḻtjaringkunytjaku. Ka nyura nyakula nintiringkuku panya mulapa Mayatja Godalu nyuranya ngalya-katingu.” ");
INSERT INTO pjt_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Ka Moselu wangkangu Aaronta, “Ma-wangka aṉangu tjuṯa pitjala tjunguringkula kapuṯu kutjuringkunytjaku Mayatja Godala miṟangka, panya paluṟu tjananya kulinu mulyararira ngalytjurmaṟa wangkanyangka.” ");
INSERT INTO pjt_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Ka tjananya wangkangi Aarontu, kaya wangkanyangka maḻakukutuṟa ilytjikutu ma-nyangu Mayatja Godanya pitalytji puḻka irnyannyangka ngangkaḻi unngu. ");
INSERT INTO pjt_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","12","Ka Godalu wangkangu Mosela, “Ngayulu kulinu aṉangu nyanga Israelkunu tjuṯangku ngalytjurmaṟa wangkanyangka. Ka nyuntu wangka tjanala nyanga alatji, ‘Kuwari mungartji-mungartji nyura kuka ngalkuku munu piṟuku nyura mungawinki mai puḻka ngalkula paḻtjaringkuku. Munu nyara palulanguṟu nyura nintiringkula kulilku panya mulapa ngayulu Mayatjanya nyurampa God.’ Alatji tjanala wangka!” ");
INSERT INTO pjt_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Ka palulanguṟu mungartjikutu wiltjawaṟangka tjuḻpu puṉṯaṟu tjuṯa mulapa wirkaṟa ngurangka manta angaṟa nyinangi. Ka mungawinki mulapa kulyarpa ngaringi ngura winkingka. ");
INSERT INTO pjt_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Ka tjiṉṯungku pakaṟa kampara wiyaṉu, ka palula maḻangka ngapaṟi puṟunypa mantangka ngaringi. ");
INSERT INTO pjt_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Kaya Israelkunu tjuṯangku nyakula papulaṟa para-tjapiningi tjananku, “Nyaa nyangatja?” Panya paluṟu tjanaya ngurpangku tjapiningi. Ka Moselu wangkangu, “Nyanga paluṟu mai panya Mayatja Godalu iyantja nyura ngalkuntjaku. ");
INSERT INTO pjt_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Munu paluṟu nyuranya wangkangu nyanga alatji, ‘Nyura uti tjuku nguwanpa uranma tjiṉṯu kutjuku ngalkula paḻtjaringkunytjikitjangku, tjara maḻaringkula ngarinytjaku-tawara. Munuya mungawinkiku mantjintja wiyangku kuwariku kutju mantjinma.’ Alatji urantjaku Godalu nyuranya wangkangu.” ");
INSERT INTO pjt_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Kaya Israelkunu tjuṯangku mulapaṯu wangaṉarangku kulinu paluṟu wangkanyangka munuya uraningi. Kutjupa tjuṯangkuya puḻka nguwanpa uraningi walytja tjuṯatjarangku, kaya kutjupa tjuṯangku tjukutjuku nguwanpa uraningi walytja maṉkurtjarangku. ");
INSERT INTO pjt_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Munuya uraṟa mitjuṟumilaningi mai panya palunya. Ka aṉangu panya puḻka nguwanpa urantjitjangku alatjiṯu uraṉu walytja palumpa uwankara paḻtjaringkunytjaku, ka panya tjara kutjupa maḻaringkula ngarinytja wiya. Ka panya kutjupangku tjukutjuku nguwanpa urantjitjangku palu puṟunypaṯu alatjiṯu uraṉu walytja panya maṉkurtu ngalkula paḻtjaringkunytjaku. ");
INSERT INTO pjt_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Ka Moselu wangkangu tjananya, “Nyura uwankarangku tjara kutjupa mungawinkiku kanyintja wiyangku wantima.” ");
INSERT INTO pjt_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Palu kutjupa tjuṯangku Mosenya kulintja wiyangku wantira mai tjara mungawinkiku tjunkula wantingu. Munuya tjiṉṯungka mai panya palunya nyangu katilykatjara ngaṟanyangka ka uṉa paṉṯingi. Ka Mosenya tjanampa puḻkaṟa mirpaṉaringu. ");
INSERT INTO pjt_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Palu mungawinki kutjupa mungawinki kutjupaya aṉangu tjuṯangku panya mai uralpai tjiṉṯu kutjuku kutju ngalkula paḻtjaringkunytjikitjangku. Ka tjiṉṯungku panya pakaṟa katuringkula kampanyangka mai panya mantangka maḻaringkula ngarinytja uṟuringkula wiyaringkupai. ");
INSERT INTO pjt_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Kaya tjiṉṯu 5 ngaṟala wiyaringkula Friday-ngka mai puḻka nguwanpa mantjiningi tjiṉṯu kutjaraku Friday-ku munu Saturday-ku kuḻu. Kaya wati Israelkunu puḻka tjuṯangku pitjala tjakultjunu Mosela aṉangu tjuṯangku puḻka nguwanpa urannyangka nyakula. ");
INSERT INTO pjt_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Ka Moselu wangkangu tjanala, “Wiya palya, Godalu alatji urantjaku wangkangu, panya mungawinki tjiṉṯu miḻmiḻpa ngaṟanyi Godaku aṉangu uwankara nyinara pakuwiyaringkunytjaku. Kaya mai panya kuwari urantja uwankara paula, tjinguṟu nyuma rungkaṟa paula munta tjinguṟu minangka tjunguṟa arngu kutjala. Munuya pauṟa ngalkula paḻtjariwa munu kutjupa maḻaringkula ngarinytja kanyinma mungawinkiku.” ");
INSERT INTO pjt_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Kaya Moselu wangkanyangka kuliṟa tjara kanyinu mai panya maḻaringkula ngarinytja mungawinkiku. Ka mai paluṟu uṉaringkunytja wiya, munu katilykatjararingkunytja wiyaṯu. ");
INSERT INTO pjt_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Ka Moselu wangkangu, “Mai panya palunyaya kuwariṯu ngalkula, panya tjiṉṯu nyangatja kuwari Saturday Mayatja Godaku tjiṉṯu nganaṉa pakuwiyaringkula nyinara palunya waḻkuntjaku. Ka palulanguṟu nyura mai panya Godalu iyantja uṟilta ngarinyangka puṯu nyakuku. ");
INSERT INTO pjt_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Palu palya nyura tjiṟirpi panya tjuṯangka mai mantjilkatima tjiṉṯu 6-kutu. Palu panya tjiṟirpi 7-ta pakuwiyaringkunytjaku ngaṟanyi tjiṉṯu panya miḻmiḻṯa, ka nyura mungawinki pakaṟa mai panya uṟilta ngarinytja puṯu nyakuku.” ");
INSERT INTO pjt_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Palu kutjupa tjuṯaya tungunpungkula maiku anu uṟilkutu tjiṉṯu panya pakuwiyaringkupaingka. Palu mai panya palunyaya puṯu nyangu, ka mulapaṯu wiya ngaṟangi. ");
INSERT INTO pjt_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Ka Mayatja Godalu wangkangu Mosela, “Nyaakuya ngayula tungunpunganyi? Yaalaṟaya kuliṟa mulamularingkuku ngayulu wangkanytjitja uwankaraku? ");
INSERT INTO pjt_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Kulilaya! Panya ngayulu Mayatja Godalu nyurampa tjiṟirpi pakuwiyaringkunytjaku tjunu Saturday. Kaṉa palulanguṟu ngayulu mai tjiṟirpi nyara palumpa kuḻu iyaṉi ngaṉmanytju tjiṟirpi panya Friday-ngka, Friday-ku munu Saturday-ku kuḻu. Ka tjiṟirpi panya Saturday-ku wangkara nyura uwankara ngurangka nyinama pakantja wiya.” ");
INSERT INTO pjt_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Kaya palulanguṟu mulapaṯu tjiṟirpi panya Saturday-ngka ngurangka nyinangi pakaṟa waṟkarinytja wiya. ");
INSERT INTO pjt_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Munuya aṉangu tjuṯangku mai panya palunya ininu “manna” tjanampa wangkangku. Palu mai paluṟu panya ngapaṟi puṟunypa munu mayu tjuratja puṟunypa. ");
INSERT INTO pjt_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Ka Moselu wangkangu, “Mayatja Godalu wangkangu nganaṉanya mai nyanga manna palunya tjukutjuku nguwanpa mantjiṟa tjunkula kanyintjaku nganampa walytjapitingku ngula nyakunytjaku munu maḻatja maḻatjangku kuḻu. Panya Mayatjanya mukuringanyi maḻatja tjuṯangku mai nyanga manna nyakula alatji kulintjaku, ‘Nyangatja iriti nganampa tjamu tjuṯangku ilytjingka ngalkuningi panya Godalu tjananya Itjipalanguṟu pakaltjingaṟa katingu munu tjananya mai nyanga palunya nguṟurpa ungangi.’” ");
INSERT INTO pjt_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Munu Moselu Aaronta wangkangu, “Piti tjaa waṟa mantjila munu mai panya manna uraṟa tjaalyngaṟatjura munu katira Mayatja Godanya waḻkulpaingka tjunkula wanti nganampa walytjapiti maḻatja tjuṯangku ngula nyakula ruuru kulintjaku.” ");
INSERT INTO pjt_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Kaya Aarontu wangkanyangka mulapaṯu mai panya manna uraṟa tjunu pitingka munu piti panya palunya tjunu pakutja panya kalkuntjitjangka kuranyu rawa mulapa ngarinytjaku. ");
INSERT INTO pjt_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","36","Kaya Israelkunu tjuṯangku yiya 40 nyinara mai panya manna palunya rawa mulatu ngalkuningi. Munuya ngura panya Kainanta wirkaṟa kutju mai kutjupa ngalkuningi, panya nyara palula wirkankunyangka Godalu mai panya manna piṟuku iyantja wiyaringu. ");
INSERT INTO pjt_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Kaya Israelkunu tjuṯa uwankara uṯuḻu winki anangi pilangka ngura ini Tjiinnga wantikatira, munuya rawa para-pitjaliṟa ngura kutjupa kutjupangka ngura tjunkula nyinangi Mayatja Godalu nintinnyangka. Munuya kutjupa-aṟa ngura ini Rapitimala wirkaṟa ngura tjunu. Palu ngura nyara paluṟu mina wiya. ");
INSERT INTO pjt_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Kaya aṉangu tjuṯa mulyararira Moseku mirpaṉaringu, munuya wangkangu, “Minalanya uwa tjikintjaku.” Ka Moselu wangkangu, “Nyaaku nyura ngayuku mirpaṉarinyi? Tjinguṟu nyura Mayatja Godaku mulamularingkuwiyangku wantinyi munu kulini paluṟu nganaṉanya wantikatinytja-palku aṯunymankunytja wiyangku. Palu nyura alatji ngunti kulinnyangka paluṟu nyurampa mirpaṉariku.” ");
INSERT INTO pjt_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Palu aṉangu panya tjuṯangku mina ilungku Mosenya puḻkaṟa ngalytjurmaṟa wangkangi, “Nyaakulanyan ngalya-katingu Itjipalanguṟu? Nyangangka mina wiya. Ilunytjakulanyan katingu nganampa tjitji, kuka tjuṯa kuḻu.” ");
INSERT INTO pjt_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Ka Moselu Mayatja Godala puḻkaṟa tjapiningi, “Nyaalkuṉa aṉangu nyanga tjuṯa? Nyanga kuwariya kulini ngayunya apungka atuṟa iluntankunytjikitjangku.” ");
INSERT INTO pjt_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Ka wangkangu Mosela, “Wati Israelkunu puḻka maṉkurpa aḻṯira ma-kati kuranyu munuya wantikati aṉangu pala tjuṯa. Munu nyuntumpa pala tjukara kuḻu kati, panya nyuntu karu Nayilnga pungu, panya palunya. ");
INSERT INTO pjt_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Ka ngayulu nyuntula kuranyu apu taaṉpangka ngaṟaku puḻi nyara Tjaniyala. Ka nyuntu puḻi nyara taaṉpa palunya tjukarangka puwa, ka apu palulanguṟu mina puḻka tjutiku aṉangu tjuṯangku tjikintjaku.” Alatji palyantjaku Godalu Mosela wangkangu, ka paluṟu kuliṟa ankula apu panya pungu wati panya puḻka tjuṯangka miṟangka, ka aḻaringkula mina tjutingu apunguṟu. ");
INSERT INTO pjt_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Ka Moselu ngura panya palunya ini kutjara tjunu Matjanya munu Miṟipanya. Alatji paluṟu ininu panya ngura pala palulaya Israelkunu tjuṯangku Godanya ngalytjurmaṟa wangkangi munuya palunya arkaṟa wangkangi, “Mayatja Godanyampa wanyu mulapa nganaṉala tjungu ngaṟanyi? Munta wiya-manti?” ");
INSERT INTO pjt_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Ka Israelkunu tjuṯa ngura panya Rapitimala nyinanyangka aṉangu Ama-likakunu tjuṯa pika pitjangu tjananya pungkunytjikitja. ");
INSERT INTO pjt_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Ka Moselu nyakula wati ini Tjatjuwala wangkangu, “Wati Israelkunu tjuṯa ngurkantara munuya mungawinki ankula tjananya pikangku pungama Ama-likakunu nyara tjuṯa. Ka nyura tjanampa pikaringkunyangka ngayulu puḻi katu tatiṟa ngaṟala nyakuku tjukara panya palunyatjara, panya Godaluṉi kanyintjaku wangkangu.” ");
INSERT INTO pjt_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Ka Tjatjuwalu wangaṉarangku kulinu Mosenya munu wati Israelkunu tjuṯa ngurkantanu pikakitja ankunytjaku. Munuya mungawinki ankula Ama-likakunu warmaḻa tjuṯa pikangku pungangi. Ka Mosenya pula Aaronnga wati kutjupa ini Uunya tjana tjungu tatinu puḻi katu. ");
INSERT INTO pjt_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Ka Moselu maṟa katuṟa kanyinnyangkaya wati Israelkunu tjuṯangku tjananya puḻkaṟa alatjiṯu pungkula waintaringi Ama-likakunu panya tjuṯa. Palu Moselu maṟa tjaṟunnyangkaya Ama-likakunu tjuṯangku ngapartji tjananya pungkula waintaringi Israelkunu panya tjuṯa. ");
INSERT INTO pjt_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Palu Mosenya pakuringu maṟa panya rawangku katuṟa kanyiṟa kanyiṟa. Ka palulanguṟu Aarontu pula Uulu puḻi puḻka mantjiṟa tjunu Mosela itingka puḻi palula nyinakatinytjaku. Munu paluṟu pula Moseku maṟa kampa kutjaranguṟu katuṟa kanyiningi rawangku tjiṉṯu tjarpanyangka kutju wantinytjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Ka pala palulanguṟu Tjatjuwalu tjana wati Ama-likakunu tjuṯa puḻkaṟa alatjiṯu pungkula wiyaṉu. ");
INSERT INTO pjt_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Ka palula maḻangka Mayatja Godalu Mosela wangkangu, “Aṟa nyanga palunya watarkurinytjaku-tawara nyiringka walkatjura maḻatja tjuṯangku kuḻu nyakula kulintjaku, panya nyura Ama-likakunu tjuṯa pungkula wiyantja. Munu walkatjunkunytjatjanungku wati panya Tjatjuwala wangka, panya ngayulu aṉangu Ama-likakunu uwankara pungkula wiyalku alatjiṯu tjananya ngura winkitjangku kulintja wiyaringkunytjaku.” ");
INSERT INTO pjt_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Ka ngura pala palula Moselu pitjilpa puḻka palyaṉu Godanya waḻkuntjikitjangku munu paluṟu pitjilpa palunya ininu, “Mayatja Godanya nganaṉanya anga-kanyilpainya”. ");
INSERT INTO pjt_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Munu paluṟu wangkangu, “Panya ngayulu maṟa ilkaṟikutu katuṟa kanyiningi Mayatja Godalu nganaṉanya anga-kanyintjaku. Ka panya Mayatja Godalu tjananya tiṯutjarangku pikangku pungkuku aṉangu panya Ama-likakunu tjuṯa tjanampa pakaḻipiti kulypalpiti munu maḻatja maḻatja tjuṯa kuḻu.” ");
INSERT INTO pjt_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Ka Moseku panya waputju wati panya Tjitjaṟunya tjukurtjara nyinangi ngura panya Mitiyanta. Munu paluṟu kulinu uwankara panya Godalu palyantja Moseku tjanampa Israelkunu tjuṯaku panya paluṟu tjananya Itjipalanguṟu pakaltjingaṟa katingu. ");
INSERT INTO pjt_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","3","Ka panya Moselu ngaṉmanytju palumpa kuri Tjipuṟanya wituṟa iyaṉu katja kutjara kuḻu palumpa waputjungka paṯaṟa nyinanytjaku ngura nyara Mitiyanta. Ka Tjitjaṟunya pukuḻaringu palumpa uṉṯalpa katja kutjaratjara wirkankunyangka munu tjananya pukuḻṯu kanyiningi. Ka katja panya kuranyitja ini Kaatjamanya. Alatji Moselu iṯi ngarinyangka ininu panya nyara palula aṟangka paluṟu wangkangu, “Ngayulu malikitja nyinanyi ngura walytjatjarangka.” ");
INSERT INTO pjt_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Ka katja panya kutjupa ini Iliyatjanya. Alatji Moselu iṯi ngarinyangka ininu panya nyara palula aṟangka paluṟu wangkangu, “Ngayuku mamangku Godanya waḻkulpai, ka God nyara paluṟu ngayunya wankaṟunu Itjipaku mayatjangku iluntankunytjaku-tawara.” ");
INSERT INTO pjt_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Ka Mosenya ilytjingka nyinangi Godaku puḻingka itingka ini panya Tjaniyala, ka wati panya Tjitjaṟulu Moseku panya waputjungku Moseku kuri munu katja kutjara kuḻu palulakutu ngalya-katingu. ");
INSERT INTO pjt_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Palu Moselu kulinu kutjupangku ngaṉmanytju ankula tjakultjunkunyangka, “Nyuntumpa waputju Tjitjaṟunya kuwari ngalya-pitjanyi nyuntulakutu palumpa uṉṯalpa munu pakaḻi kutjara kuḻu.” ");
INSERT INTO pjt_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Ka Mosenya kuliṟa ngaparikatingu palumpa waputju nyakunytjikitja munu wirkaṟa palula kuranyu tultjungaṟakatira palunya manyirka nyunytjuṉu. Munu pula pukuḻṯu wangkara wiyaringkula tiintangka tjarpara nyinakatingu. ");
INSERT INTO pjt_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Ka Moselu Tjitjaṟula tjukurpa tjuṯa tjakultjunangi uwankara Mayatja Godalu palyantja. Panya paluṟu Israelkunu tjuṯaku ngalkiltu mayatja panya Piiṟaku kutjupa kutjupa tjuṯa palyantja Itjipanya nguraṟa tjuṯaku kuḻu. Munu piṟuku nguṟurpa kuḻu panya paluṟu tjana Itjipalanguṟu pakannyangka kura tjuṯa tjanala wirkanu, palu panya Mayatja Godalu tjananya wankaṟunu alatjiṯu. ");
INSERT INTO pjt_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Ka Tjitjaṟulu tjukurpa nyanganpa kuliṟa puḻkaṟa pukuḻaringu, ");
INSERT INTO pjt_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","munu wangkangu, “Kuwariṉa Mayatja Godanya puḻkaṟa mirawaṉinyi, panya paluṟu nyuranya uwankara wankaṟunu Piiṟalanguṟu munu aṉangu Itjipanya nguraṟa tjuṯanguṟu kuḻu. ");
INSERT INTO pjt_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Kaṉa kuwari nintiringu Mayatja Godaku panya paluṟu puḻka mulapa god kutjupa tjuṯangka waintaṟa alatjiṯu. Paluṟu panya witulya puḻkangku tjananya wankaṟunu Itjipanya nguraṟa tjuṯangku pauntjingaṟa kanyinnyangka.” Alatji Moseku waputjungku wangkangi Godanya waḻkuṟa. ");
INSERT INTO pjt_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Munu palulanguṟu Tjitjaṟulu kuka wiṟu mulapa mantjiṟa katingu Godaku munu pungkula pitjilpa katu tjunu tilingku kampanytjaku Godanya ungkula waḻkuntjikitjangku. Munu paluṟu kuka kutjupa tjuṯa kuḻu katingu Godaku pungkula pitjilta pauntjikitjangku. Ka Moseku kuṯa Aaronnga munu wati Israelkunu puḻka tjuṯa kuḻu ankula tjunguringu Mosela pulala Tjitjaṟula kuka ngalkuntjikitja Mayatja Godala miṟangka palunya waḻkuntjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Ka mungawinki kutjupa Mosenya aṉangu tjuṯangka nyinara waṟkaringi. Panya tjana pitjala palula tjakultjunangi tjananku pikaringkula wangkanytjatjanungku, ka paluṟu kuliṟa ngurkantankula tjukaṟuruningi Godalu palula utinnyangka. Palu paluṟu mungawinkinguṟu mungaku-wangkara alatjiṯu nyinara ngurkantanangi, munu puḻkaṟa pakuringu. ");
INSERT INTO pjt_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Ka Tjitjaṟulu nyangangi Mosenya aṉangu tjuṯangka puḻkaṟa waṟkarinyangka munu paluṟu wangkangu, “Nyaa nyangatja nyuntu nyinara palyaṉi aṉangu tjuṯaku? Nyaaku nyuntu kutjungku alatjiṯun nyinara ngurkantaṟa tjukaṟuruṉi, ka nyanga aṉangu tjuṯa rawa mulapa paṯaṟa ngaṟanyi tjana ngapartji nyuntula wangkanytjikitja?” ");
INSERT INTO pjt_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Ka Moselu wangkangu, “Wiya, ngayulu alatji waṟkarinyi panya aṉangu tjuṯangku ngayula pitjala tjapilpai Godalu wangkanytja kulintjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Tjinguṟu aṉangu kutjarangku pulanku wangkara pikaringanyi munu pula puṯu kulini nganalu panyatja tjukaṟurungku wangkangu. Palulanguṟu pula puṯu kuliṟa ngayulakutu pitjapai, kaṉa ngayulu kuliṟa ngurkantaṟa tjukaṟurulpai, munuṉa pulala tjakultjunkupai Godaku tjukurpa paluṟu panya wangkanytjitja.” ");
INSERT INTO pjt_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Ka Tjitjaṟulu wangkangu palula, “Wiya, nyuntu ngunti palyaṉi. ");
INSERT INTO pjt_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Nyuntu kuwari puḻkaṟa pakuringanyi, ka nyanga aṉangu tjuṯa kuḻu paku puḻkaringanyi. Waṟka nyangatja puḻka mulapa kutjungku palyantjaku wiya nguwanpa. ");
INSERT INTO pjt_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Wanyu kulila, kaṉanta tjakultjura tjukaṟurungku palyantjaku. Ka nyuntu alatji palyannyangka Godanya pukuḻarira nyuntula rawaṯu nyinaku. Palya nyuntu Godala wangkama aṉangu tjuṯaku munu panya tjananku pikaringkunytjitjaku Godala tjapinma paluṟu kuliṟa nyuntula utiṟa wangkanytjaku. ");
INSERT INTO pjt_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Palya nyuntu tjanala wangkara nintinma Godalu wituntja uwankara munu tjanala utiṟa wangkama yaaltjingaṟa tjukaṟuru palyanyku nyinanytjaku. ");
INSERT INTO pjt_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","“Palu nyuntu uti ngurkantaṟa tjunama kuranyu ngaṟanytjaku wati panya nintipuka palyanyku nyinapai tjuṯa. Munu nguḻu-nguḻu Godala miṟangka waṟkarinytjaku palunya tjananya tjura aṉangu 10 kanyintjaku, kutjupatjara tjura aṉangu 50 kanyintjaku, munu tjara kutjupa tjura aṉangu 100 kanyintjaku, munu tjara kutjupa tjura aṉangu 1,000-ku mayatjarinytjaku. Palu wati palya tjuṯa kutju tjura tjukaṟuru wangkapai, munu wati ngunti palyalpai tjunkunytja wiyangku wantima. ");
INSERT INTO pjt_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Kaya uti wati nyanga mayatja tjunkunytja tjuṯangku rawangku tjiṟirpi kutjupa tjiṟirpi kutjupa aṉangu tjuṯa pikaringkunyangka ngurkantaṟa tjukaṟurunma. Palu tjinguṟu pika kutjupa kutjupa puḻka nguwanpa ngaṟanyangkampa uti tjana nyuntula pitjala tjakultjunama, ka nyuntu kuliṟa ngurkantanama. Palu utiya pika panya tjukutjuku tjuṯa walytjangku kuliṟa ngurkantanama nyuntula tjapintja wiyangku. Ka pala palulanguṟu nyuntumpa waṟka tjuku nguwanpa ngaṟaku, tjana kuḻu waṟkarinyangka. ");
INSERT INTO pjt_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Ka nyuntu alatji palyaṟampa Godalu kuḻu wangkanyangka nyuntu pakuringkunytja wiya waṟkariku, kaya wati panya mayatja tjunkunytja tjuṯangku kuḻu aṉangu tjuṯa ngurkantankula tjukaṟurulku, kaya ngurakutu mapalku ankuku pukuḻpa alatjiṯu.” Alatji Tjitjaṟulu wangkangu Moselu palyantjaku. ");
INSERT INTO pjt_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Ka Moselu kuliṟa mulamularingu munu Tjitjaṟulu wangkanyangka palyaṉu. ");
INSERT INTO pjt_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Munu wati nintipuka tjuṯa ngurkantanu Israelkunu tjuṯanguṟu munu tjananya tjunu aṉangu tjuṯaku mayatjarinytjaku, kutjupa tjuṯa aṉangu 1,000-ku, kutjupa tjuṯa aṉangu 100-ku, kutjupa tjuṯa 50-ku, kutjupa tjuṯa 10-ku. ");
INSERT INTO pjt_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Munuya paluṟu tjana ngurkantankupai tjuṯa nyinangi aṉangu tjuṯa pikaringkunyangka, munuya tjiṟirpi kutjupa tjiṟirpi kutjupa tjananya kuliṟa ngurkantankula tjukaṟuruningi. Munuya kutjupa-aṟa pika puḻka ngaṟanyangka kutju ankula Mosela tjakultjunkupai, ka paluṟu ngurkantankula tjukaṟurulpai. Palu pika tjukutjuku ngaṟanyangka tjana walytjangku ngurkantankupai. ");
INSERT INTO pjt_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Ka palulanguṟu Moselu palumpa waputju Tjitjaṟunya wangkara iyaṉu, ka anu maḻaku ngura Mitiyantakutu. ");
INSERT INTO pjt_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Kaya Israelkunu tjuṯa ngura panya Rapitimala tjukutjuku nyinara piṟuku ma-pakaṉu, munuya ilytjingka ankula ankula pilangka wirkanu apu panya ini Tjaniyala itingka. Munuya pala palulalta ngura tjunu apu panya murpu puḻkangka itingka. Panya tjana piṟa kutjara nguwanpa anangi Itjipanya wantikatinytjatjanu. ");
INSERT INTO pjt_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Ka Mosenya kutju tatinu apu panya murpukutu Godala tjunguringkunytjikitja. Ka Mayatja Godalu palunya aḻṯingu apu murpunguṟu munu tjukurpa wangkangi Israelkunu tjuṯangka wangkanytjaku, aṉangu panya Jacobakunu tjuṯangka. ");
INSERT INTO pjt_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Alatji paluṟu wangkangi, “Nyura panya nyangu ngayulu tjananya pungkula wiyannyangka panya Itjipanya nguraṟa tjuṯa munu panya nyura nyangu ngayulu nyuranya aṯunymaṟa ngalya-katinyangka waḻawuru puṟunytju, panya waḻawurungku kuḻunypa tjuṯa nyaḻpingka tjunkula katipai, palu puṟunytjuṉa nyuranya wiṟuṟa ngalya-katingu. ");
INSERT INTO pjt_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","6","Ka nyura ngayulu wangkanyangka wangaṉarangku kuliṟampa munu ngayulu panya kalkuntja kuḻu kanyiṟampa nyura ngayuku walytja mulapa nyinaku. Panya aṉangu manta winkitjaya ngayukuṯu nyinanyi, palu nyuranyaṉa ngayulu ngurkantananyi ngayuku walytja mulapa nyinanytjaku, kutjupa tjuṯa puṟunypa wiya. Ka nyura mauṉṯalpa nyinaku palya mulapa, munuṉi nyura uwankarangku tjukurtjara tjuṯa puṟunytju ngayunya kutju kuliṟa waḻkulku.” Alatji Godalu Mosela wangkangu Israelkunu tjuṯangka wangkanytjaku. ");
INSERT INTO pjt_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Ka Mosenya Godalu wangkanyangka kuliṟa ngalya-ukalingu apu panya murpunguṟu munu wati puḻka tjuṯangka aḻṯira tjakultjunu uwankara Mayatja Godalu wangkanytja. ");
INSERT INTO pjt_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Kaya aṉangu tjuṯangku uṯuḻu kutjuringkula kuliṟa wangkangu, “Nganaṉa Godalu wangkanytja uwankara palyalku wangaṉarangku.” Ka Moselu tjukurpa tjana wangkanyangka kuliṟa maḻaku ankula Mayatja Godala tjakultjunu. ");
INSERT INTO pjt_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Ka Godalu wangkangu Mosela, “Ngayulu nyuntulakutu kumpilpa ma-pitjaku ngangkaḻi puḻkangka, munuṉanta wangkaku ngangkaḻinguṟu. Kaya aṉangu tjuṯangku kulilku ngayulu nyuntula wangkanyangka munuya palulanguṟu nyuntumpa rawa mulamularingkuku.” ");
INSERT INTO pjt_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","11","Munu piṟuku Godalu wangkangu Mosela, “Ukalingkula tjanala wangka aṉangu nyara tjuṯangka, kaya tjiṉṯu nyanga kuwari munu mungawinki kuḻu ulytja tjananku paltjiṟa kilinara munu uwankara ngaṉmanytju palyala ngayunya waḻkuntjikitjangku tjiṉṯu nyara munkaritjangka. Panya tjiṟirpi pala palula ngayulu puḻi panya Tjaniyala murpungka ukalingkula nyinakatiku aṉangu tjuṯangka miṟangka tjana nyakunytjaku. ");
INSERT INTO pjt_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Ka puḻi paṉṯangka kutjupa kutjupa para-arintaṟa tjunkula waṉaṟa angatjura aṉangu tjuṯa tjarpanytja wiya muṉkara ngaṟanytjaku. Munu tjanala wangka puḻingka ilaringkula tatilwiyangku wantinytjaku. Ka tjinguṟu kutjupangku puḻi panya palunya pampunnyangkampa nyura palunya iluntanama alatjiṯu. ");
INSERT INTO pjt_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Palu aṉangu palunya iluntankunytjikitjangku maṟangku pungkunytja wiyangku apungka kutju atula, munta tjinguṟu punaṟangka wakala. Munu kukangku kuḻu puḻi pampunnyangkampa palu puṟunytjuṯu iluntanama. Palu maḻangkaya palya tuṟampata puḻkaṟa miratjingannyangka kutju aṉangu tjuṯa palya puḻingka tatini.” ");
INSERT INTO pjt_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","15","Ka palulanguṟu Moselu kuliṟa maḻaku ukalingu puḻinguṟu munu aṉangu tjuṯangka wangkangu, “Tjiṟirpi kutjaranguṟu kunyu Mayatja Godanya ukalingkula nyinakatinyi puḻi nyanga murpungka, ka nyura uwankara ngaṉmanypa ritiringama Godanya waḻkuntjikitjangku, munuyanku ulytja paltjila. Warpungkulaya palyala tjiṉṯu nyanga kutjarangka, munuya wati tjuṯa tjiṉṯu nyanga kutjarangka kuringka tjunguringkula ngarinytja wiyangku wantima.” Kaya kuliṟa mulapaṯu mantara tjananku tjiṉṯu kutjarangku paltjiṟa kilinanu. ");
INSERT INTO pjt_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Ka tjiṉṯu kutjara ngaṟala wiyaringkula mungawinki kutjupa, mina puṟunypa tuuṟa pinpangi, ka ngangkaḻi puḻka ukalingu ilkaṟinguṟu munu nyinakatingu apu panya murpungka. Kaya aṉangu tjuṯangku kulinu tuṟampata puḻkaṟa miranyangka, munuya puḻkaṟa alatjiṯu nguḻuringkula tjititingangi. ");
INSERT INTO pjt_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Ka Moselu tjananya nguranguṟu ma-katingu aṉangu uwankara Godala tjunguringkunytjaku, kaya ankula puḻi paṉṯangka tjunguringkula ngaṟangi. ");
INSERT INTO pjt_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Ka puḻi panya Tjaniyanya tjutuṟa alatjiṯu patinu puyu puḻkangku, panya Godanya pala palula ukalingkula nyinakatingu waṟu tili puḻkangka. Ka puyu panya tiwilpa alatjiṯu pakaningi waṟu puḻka kampanytja puṟunypa. Ka puḻi winki puḻkaṟa alatjiṯu uri-uringi. ");
INSERT INTO pjt_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Ka tuṟampata panya miratjingantjanya ngalya-ilaringkula puḻkaringu mulapa. Ka Moselu Godala wangkanyangka paluṟu ngapartji aluṉu. ");
INSERT INTO pjt_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Ka Mayatja Godanya ukalingkula nyinakatingu puḻi panya Tjaniyala murpungka munu paluṟu Mosenya aḻṯingu murpukutu ngalya-tatintjaku. Ka Moselu kuliṟa ma-tatinu puḻi katu. ");
INSERT INTO pjt_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Ka Mayatjalu wangkangu Mosela, “Ukalingkula tjananya wangka aṉangu nyara tjuṯangka, kaya angatjunkunytja panyatja kaṯantaṟa tjarpawiyangku wantima ngayunya nyakunytjikitjangku, panya paluṟu tjana tjarparampa iluku alatjiṯu. ");
INSERT INTO pjt_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Munu tjukurtjara tjuṯa panya ngayula ilaringkupai tjuṯangka kuḻu wangka tjananku paltjiṟa kilinankula paṯaṟa nyinanytjaku, panya tjana alatjingantja wiyangkaṉa tjananya pikantankuku.” ");
INSERT INTO pjt_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Ka Moselu kuliṟa Mayatja Godala wangkangu, “Aṉangu tjuṯa panya puṯu tatini puḻi nyanga Tjaniyalakutu, panya nyuntu wangkangu nganaṉala paṉṯangka para-angatjunkunytjaku, ka panyala palyaṉu miḻmiḻpa ngaṟanytjaku aṉangu tjuṯa ngalya-tatintjaku-tawara.” ");
INSERT INTO pjt_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Ka Mayatja Godalu kuliṟa wangkangu palula, “Ukalingkula nyuntumpa kuṯa Aaronnga aḻṯira maḻaku ngalya-pitja. Palu utiya tjukurtjara tjuṯa munu aṉangu tjuṯa kuḻu muṉkara ngaṟama ngalya-tjarpanytja wiya ngayulakutu. Panya tjana paintjitjangka tungunpungkula tjarpanyangkaṉa tjananya puḻkaṟa pikantankuku.” ");
INSERT INTO pjt_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Ka Mosenya kuliṟa puḻi panya murpunguṟu ukalingkula mantangka wirkanu munu tjanala tjakultjunu uwankara Mayatja Godalu wangkanytja. ");
INSERT INTO pjt_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Ka murpu panya katu Godalu tjukurpa puḻka tjuṯa wangkangu nyanga alatji, ");
INSERT INTO pjt_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Kulila! Ngayuluṉa Mayatja Godanya, panya nyuranyaṉa Itjipalanguṟu ngalya-katingu, panya ngura nyara palulaya nyuranya pauntjingaṟa puḻkaṟa waṟkamilaningi Itjipanya nguraṟa tjuṯangku. ");
INSERT INTO pjt_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Nyura uti kutjupa kutjupa tjuṯa waḻkuntja wiyangku wantima munu ngayunya kutju God mulapa waḻkunma. ");
INSERT INTO pjt_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Nyura uti puṉu kutjupa kutjupa godanyanmaṟa waḻkuntjikitjangku palyantja wiyangku wantima. Ilkaṟitja puṟunypa, mantatja puṟunypa kuḻu ngaṟatjunkula waḻkuntjikitjangku palyantja wiyangku wantima. Munu panya uṟutja puṟunypa kuḻu palyantja wiyangku wantima godanyanmaṟa waḻkuntjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Puṉu pala palu puṟunytjaya kuranyu tultjungaṟakatira waḻkuntja wiyangku wantima alatjiṯu. Ngayunya kutjuya waḻkunma, panya ngayulu kutju mayatja puḻka nyurampa God, munuṉa nyura kutjupa waḻkunnyangka ngayulu puḻkaṟa mirpaṉaripai ngayunya kutju waḻkuntja-tjiratja. Munuṉa aṉangu ngayuku kuraringkupai tjuṯa pikatjaralku, munuṉa palulanguṟu nyara palumpa tjanampa kuranguṟu pikatjaralku tjanampa tjitji tjuṯa, munu tjanampa pakaḻi puḻiri tjuṯa, munu tjanampa pakaḻitja puḻiritja tjuṯa kuḻu. Alatjiṉa pikatjaralku panya ngaṉmanyitja tjuṯaku kuranguṟu. ");
INSERT INTO pjt_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Palu aṉangungku ngayuku mukuringkula, munu ngayulu wangkanytjitja wangaṉarangku kulinnyangkampa ngayulu palunya mukulya puḻkangku aṯunymaṟa kanyilku, munuṉa rawangku palumpa walytja maḻatja maḻatja mungilyi mulapa mukulyangku aṯunymaṟaṯu kanyilku. ");
INSERT INTO pjt_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Ngayuluṉa Mayatja Puḻkanya nyurampa God, ka nyura uti ngayunya ini ngalypa-ngalyparingkula unytjungku wangkanytja wiyangku wantima alatjiṯu. Panya kutjupangku ngayunya ini ngunti ngalypa-ngalyparingkula wangkanyangkaṉa palunya pungkuku alatjiṯu. ");
INSERT INTO pjt_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Nyura uti tjiṟirpi panya pakuwiyaringkupainya kulinma miḻmiḻpa mulapa kanyintjikitjangku watarkurinytja wiyangku. ");
INSERT INTO pjt_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Panya tjiṟirpi 6 ngaṟanyi nyura waṟkarinytjaku. ");
INSERT INTO pjt_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Palu tjiṟirpi 6 ngaṟala wiyaringkunyangka maḻangka tjiṟirpi panya 7 ngaṟanyi Tjiṉṯu Miḻmiḻpa nyura waṟka wiya nyinara pakuwiyaringkula ngayunya kulintjaku. Ka nyura uti tjiṟirpi pala palula waṟkarinytja wiya nyinama nyurampa tjitji tjuṯa, munu panya aṉangu nyurala waṟkaripai tjuṯa kuḻu, nyurampa kuka tjuṯa kuḻu. Munu panya malikitja tjuṯa ngura kutjupanguṟu pitjala nyurala nguraṟarinytja tjuṯa kuḻu uti waṟkarinytja wiya nyinama tjiṟirpi panya miḻmiḻpa palula. ");
INSERT INTO pjt_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Panya ngayulu Mayatja Puḻkangku tjiṟirpi 6 uwankara palyaṉu manta, ilkaṟi, uṟu munu panya mantatja, ilkaṟitja, uṟutja uwankara kuḻu tjiṉṯu 6, munu panyaṉa nyara palulanguṟu uwankara palyaṟa wiyaringkula nyinara pakuwiyaringu tjiṉṯu panya 7-ta. Palulanguṟuṉa tjiṟirpi pala palunya miḻmiḻmaṟa palyanmanu ngayuku tjiṉṯu ngaṟanytjaku. ");
INSERT INTO pjt_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Nyura uti mamangka ngunytjungka wangaṉarangku kulinma mukulyangku. Pala palulanguṟu nyura rawa nguwanpa wanka nyinaku manta nyara ngayulu nyuranya ungkunytjitjangka. ");
INSERT INTO pjt_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Nyura uti aṉangu kutjupa iluntankunytja wiyangku wantima. ");
INSERT INTO pjt_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Nyura uti aṉangu kutjupaku kuringka ngarinytja wiyangku wantima kuri walytjangka kutju ngarima. ");
INSERT INTO pjt_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Nyura uti kutjupa kutjupa walytjatjara kutitjuṟa katinytja wiyangku wantima. ");
INSERT INTO pjt_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Nyura uti aṉangu kutjupa ngunti ngukaṟa wangkawiyangku wantima. ");
INSERT INTO pjt_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Nyura uti kutjupa kutjupa walytjatjara nyakula mantjintjikitja ngunti mukuringkunytja wiyangku wantima. Wati kutjupaku kuriku ngunti mukuringkuwiyangku wantima. Wati kutjupaku waḻiku ngunti mukuringkuwiyangku wantima. Munu palumpa aṉangu waṟkaripai tjuṯaku, munu palumpa pulukaku, palumpa tangkiyiku, palumpa kutjupa kutjupa uwankaraku ngunti mukuringkuwiyangku wantima alatjiṯu.” Alatji Godalu tjukurpa puḻka tjuṯa wangkangu. ");
INSERT INTO pjt_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Ka Godanya Mosela wangkanyangka Israelkunu tjuṯa puḻkaṟa nguḻuringangi. Panya kulinuya tjana tuunnyangka munu tuṟampata puuṟa wangkatjingannyangka. Munuya nyangu wanangaṟa pinpanyangka munu puyungku tjutunnyangka puḻi panya palunya. Munuya puḻkaṟa nguḻuringkula paṯu ngaṟala tjititingangi. ");
INSERT INTO pjt_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Ka Mosenya Aaronnga pula ngalya-ukalingu puḻinguṟu. Kaya wangkangu Mosela, “Nyuntu kutjungkulanya wangkama, kala nganaṉa nyuntula kulinma. Palu Godalu nganaṉala wangkanyangka nganaṉa tjinguṟu iluku palunya kuliṟampa.” ");
INSERT INTO pjt_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Ka Moselu wangkangu tjanala, “Nguḻuringkuwiyaya rapa ngaṟama. Panya Godanya nganaṉalakutu ngalya-ukalingu nganaṉa palula wangaṉarangku kulinnyangka nyakunytjikitja. Panya paluṟu mukuringanyi nyura kura wantira palula kutju tiṯutjarangku wangaṉarangku kulintjaku tungunpungkunytja wiyangku.” Alatji Moselu tjanala wangkangu. ");
INSERT INTO pjt_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Munu paluṟu kutju puḻingka tatiṟa ma-ilaringu Godala panya ngangkaḻi maṟungka ngaṟanyangka, kaya aṉangu tjuṯa tjaṟu ngaṟangi puḻinguṟu ma-paṯuringkula. ");
INSERT INTO pjt_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Ka Mayatja Godalu tjukurpa tjuṯa mulapa wangkangi Mosela apu panya palula paluṟu ngapartji Israelkunu tjuṯangka wangkanytjaku. Nyanga alatji paluṟu wangkangu, “Nyura uwankarangku nyangu ngayulu ilkaṟinguṟu wangkanyangka. ");
INSERT INTO pjt_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Ka palulanguṟu nyura waḻkuntjikitjangku god ngalypa-ngalypa apu gold-nguṟu tjiilpanguṟu kuḻu palyantja wiyangku wantima munuya ngayunya apungka ini tjunguṟa waḻkulwiyangku wantima. ");
INSERT INTO pjt_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Nyura ngayuku pitjilpa puḻka palyala mantanguṟu munu pitjilpa pala palula ngayunya ungama kuka tjiipi, nanikuta, puluka, pungkula tiliwakaṟa. Ngayulu nyuranya wangkaku ngura kutjupangka kutjupangka ngayunya waḻkuntjaku. Munuṉa ngura nyara palula tjanala nyura wirkankunyangka ngayulu nyurampa pukuḻpa puḻka mulapa palyalku. ");
INSERT INTO pjt_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Tjinguṟu nyura pitjilpa ngayuku palyalku apunguṟu, palu apu tjuṯa wiṟuly-wiṟulymankuwiyangku wantima, panya nyura alatji lipulaṟa tjunkunyangka pitjilpa miḻmiḻpa wiyaringkuku kuka tiliwakaṟa ngayunya ungkula waḻkuntjaku. ");
INSERT INTO pjt_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Munu pitjilpa katu mulapa palyantja wiyangku wantima paḻtjuṟa tatilpaitjara. Panya katu tatinnyangkampa aṉangu tjuṯangku tjinguṟu ulytja unngutja nyakuku watiku puntu, ka kuṉṯaringkuku. Pala palula-tawara mantangka palyala.” ");
INSERT INTO pjt_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Munu piṟuku Godalu Mosela tjukurpa kutjupa tjuṯa wangkangu Israelkunu tjuṯangka tjakultjunkunytjaku paluṟu tjana wangaṉarangku kuliṟa palyantjaku. Alatji paluṟu wangkangu tjanala wangkanytjaku, ");
INSERT INTO pjt_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“Tjinguṟu nyuntu wati Iipuṟu kutju maningka payamilaṟa mantjini nyuntumpa waṟkarinytjaku, munu nyuntu uti wati palunya yiya 6 kutju kanyiṟa waṟkamilanma munu palula maḻangka yiya 6 ngaṟala wiyaringkunyangka wati panya palunya wantir'iyanma rawa waṟkarinytjaku kanyintja wiyangku. Palu wantir'iyantjikitjangku palula mani ngatjintja wiyangku wantima nyuntunya ungkunytjaku, panya paluṟu nyuntumpa puḻkaṟa rawa waṟkaringi. ");
INSERT INTO pjt_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Tjinguṟu nyuntu yangupala waṟkaku mantjini, ka ngula nyuntu palunya wantir'iyannyangkampa uti paluṟu kutju alatjiṯu anama ngura walytjakutu kungka katinytja wiya. Palu tjinguṟu nyuntu wati kuritjara mantjiṟampa uti pulanyaṯu ngula wantir'iyanma yiya panya 6 wiyaringkunyangka. ");
INSERT INTO pjt_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Palu tjinguṟu nyuntu wati kuri wiya mantjilku nyuntumpa waṟkarinytjaku, munu palulanguṟu nyuntu tjinguṟu kungka ngurkantaṟa palunya ungkuku aḻṯinytjaku, ka paluṟu pula aḻṯira tjitji tjuṯatjararingkuku. Ka nyuntu ngula wantir'iyantjikitjangku uti wati kutju iyanma munu minyma panya tjitji tjuṯatjara kanyinma palula tjungu wantir'iyantja wiyangku. ");
INSERT INTO pjt_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“Palu tjinguṟu wati panya waṟkangku wangkaku, ‘Wiya mayatja, ngayuluṉa nyuntumpa mukuringanyi ngayuku kuriku, tjitji tjuṯaku kuḻu, munuṉa nyuntula rawa nyinanytjikitja mukuringanyi, minyma tjitji kuḻu wantikatinytja wiya.’ ");
INSERT INTO pjt_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","Ka alatji wangkanyangka nyuntu uti palyanmanama munun palunya katima waḻi panya Godanya waḻkulpailakutu, munu waḻi pala palula ngalya-katira palunya ngaṟatjunama tuwangka itingka, munu pina witiṟa tuwa kantilytja tinatjuṟa kanyiṟa puṉu iṟingka wakaṟa aḻanma. Ka palulanguṟu wati paluṟu nyuntumpariku alatjiṯu munu paluṟu nyuntula tiṯutjara nyinara waṟkariku ankunytja wiya. ");
INSERT INTO pjt_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Ka tjukurpa kutjupa alatji. Tjinguṟu watingku palumpa uṉṯalpa tjalamilalku aṉangu kutjupangka palumpa waṟkarinytjaku. Ka uti aṉangu panya paluṟu kungka palunya yiya 6 waṟkarira wiyaringkunyangka wati panya palumpa waṟka walatjunkunytja puṟunypa wantir'iyantja wiyangku wantima. ");
INSERT INTO pjt_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Tjinguṟu wati panya mayatjangku kungka panya palunya aḻṯinytjikitjangku payamilaṉu palumpa mamangka. Munu palulanguṟu tjinguṟu nyakula kungka palumpa pukuḻarinytja wiya munu wantiku aḻṯiwiyangku. Pala palulanguṟu aḻṯiwiyangku wantirampa wati paluṟu uti mamangka maḻakungku tjalamilanma wati malikitjangka tjalamilantja wiyangku. Panya paluṟu ngunti payamilaṉu kuri paluṟunku aḻṯinytjikitjangku-palku munu wantingu kurangku. ");
INSERT INTO pjt_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Palu tjinguṟu wati paluṟu kungka palunya ngurkantanu palumpa katjaku pula aḻṯira tjungu nyinanytjaku, munu uti wati panya paluṟu kungkawaṟa palunya mama puṟunytju wiṟuṟa alatjiṯu kanyinma uṉṯalpa puṟunypa. ");
INSERT INTO pjt_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","“Ka tjinguṟu wati kuritjarangku kuri kutjupa aḻṯiku munu uti paluṟu kuri panya ngaṉmanyitja tiṯutjarangku ungama kuka, mai, mantara kuḻu. Munu uti paluṟu kuri maḻatjangka kutju ngariwiya kutjarangkaṯu ngarima paluṟu pulaṯu pukuḻarinytjaku. ");
INSERT INTO pjt_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Palu wati panya paluṟu tjinguṟu kuri panya ngaṉmanyitjaku kuraringkuku kuka, mai, mantara kuḻu ungkunytja wiya munu panya palula ngarinytja wiyaṯu. Alatji kurangku palyaṟampa wati paluṟu uti minyma panya palunya mukuringkunyangka wantir'iyanma alatjiṯu palula mani ngatjiṟa mantjilwiyangku.” ");
INSERT INTO pjt_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Tjinguṟu watingku aṉangu kutjupa pungkula iluntankuku, ka palunya ngapartji iluntankunytjaku ngaṟanyi. ");
INSERT INTO pjt_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Ka tjinguṟu watingku aṉangu kutjupa watarkungku pungkuku ka iluku Godalu palunya ngalkintja wiyangku wantinyangka. Ka wati paluṟu uti ngapartji pungkula iluntankunytjaku-tawara kumpiṟa wirtjapakanma ngura kutjupakutu ngura panya ngayulu ngurkantankunytjalakutu munu nyara palula paluṟu wankaṟu nyinaku. ");
INSERT INTO pjt_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Palu watingku tjinguṟu aṉangu kutjupaku puḻkaṟa mirpaṉarira palunya iluntankunytjikitjangku pungkuku, ka paluṟu iluku. Ka wati panya paluṟu tjinguṟu wirtjapakalku ngayuku pitjilpakutu ngayulu palunya ngaḻṯuringkula aṯunymankunytjaku. Palu wiya, palunya iluntankunytjaku ngaṟanyi alatjiṯu. ");
INSERT INTO pjt_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Ka aṉangungku palumpa mama munta tjinguṟu ngunytju pungkunyangkampa palunya ngapartji pungkula iluntankunytjaku ngaṟanyi. ");
INSERT INTO pjt_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Ka aṉangu kutjupangku tjinguṟu wati kutjupa witiṟa kutitjuṟa katiku paluṟu wantinyangka kulintja wiyangku, munu tjinguṟu palunya aṉangu kutjupangka tjalamilalku munta tjinguṟu kanyiṟa palunya pauntjingaṟa waṟkamilanma. Ka wati nyara kura palunya kutitjuṟa panya katipainya iluntankunytjaku ngaṟanyi. ");
INSERT INTO pjt_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Ka aṉangungku tjinguṟu palumpa mama munta tjinguṟu ngunytju warkinyangkampa aṉangu panya warkipai palunya pungkula iluntankunytjaku ngaṟanyi. ");
INSERT INTO pjt_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","19","“Ka tjinguṟu wati kutjarangku pulanku pikaringkula punganyi, ka wati kutjungku wati kutjupa maṟangku punganyi munta tjinguṟu apungka atuṉi, ka panya paluṟu punkaṟa pika puḻka ngarinyi ilunytja wiya. Ka palulanguṟu kutjupangku palunya katinyi ngurakutu ngarira palyaringkunytjaku. Ka tjinguṟu ngula palyaringkula pakaṟa purkaṟa tjukaratjara uṟilta para-ngaṟaku, ka pala palulanguṟu wati panya pungkupainya ngapartji pungkunytjaku ngaṟanytja wiya. Palu wati panya paluṟu uti palunya mani ungama panya pungkunytjatjanungku, panya paluṟu pikatjara ngarira puṯu waṟkarinyi manikitja. Ka uti wati panya pungkupailu pikatjara panya palunya wiṟuṟa aṯunymanama mapalku palyaringkunytjaku. ");
INSERT INTO pjt_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Ka tjinguṟu watingku aṉangu waṟkaripai payamilalku tjinguṟu wati, tjinguṟu minyma wati nyara palumpa waṟkarinytjaku. Munu tjinguṟu ngula paluṟu waṟkaripai panya palunya puṉungka puḻkaṟa pungkuku, ka paluṟu mapalku iluku. Ka wati panya pungkupainya ngapartji pungkula pikatjarantjaku ngaṟanyi. ");
INSERT INTO pjt_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Palu tjinguṟu waṟkaripai panya paluṟu mapalku ilunytja wiya, tjiṟirpi kutjunguṟu munta tjinguṟu tjiṟirpi kutjaranguṟu pikatjara ngarira ilunyi. Ka nyara palulanguṟu wati panya pungkupainya pungkula pikatjarantjaku ngaṟanytja wiya. Panya palumpa waṟkaripai wiyaringkunyangka paluṟu tjituṟu-tjituṟurinyi. ");
INSERT INTO pjt_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Ka tjinguṟu wati kutjarangku pulanku pika punganyi, ka tjinguṟu kutjungku minyma iṯitjara paku pungkuku angatjunkunyangka, ka iṯi tjuni unngu iluku munu mapalku wirkankuku. Ka wati panya pungkunytjatjanungku uti palunya mani ungama nampa panya palumpa kuringku ungkunytjaku wangkanytja. Palu tjinguṟu paluṟu mani puḻka nguwanpa ungkunytjaku wangkanyangka wati panya pungkunytjalu tjinguṟu puṯu payamilalku. Munu uti paluṟu ankula mayatja panya ngurkantankupaingka arkaṟa wangkama, ka tjinguṟu wati panya minymaku kuringka wangkaku mani nampa panya tjaṟuntjaku. ");
INSERT INTO pjt_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Palu tjinguṟu minyma panya iṯitjara pungkunytjanya pikatjararingkuku. Ka wati panya pungkunytjanya palu puṟunypaṯu pikatjarantjaku ngaṟanyi. Munu tjinguṟu ilunyangkampa palu puṟunypaṯu wati palunya iluntankunytjaku ngaṟanyi. ");
INSERT INTO pjt_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Tjinguṟu kuṟu wakaṟa tjaḻantankuku, ka palu puṟunypaṯu palunya kuṟu wakaṟa tjaḻantankunytjaku ngaṟanyi. Tjinguṟu tjaa pungkula kaṯiṯi kaṯantankuku, ka palu puṟunypaṯu palunya kaṯiṯi pungkula kaṯantanama. Tjinguṟu maṟa tjina pungkula kaṯantankuku, ka palu puṟunypaṯu palunya maṟa tjina pungkula kaṯantankunytjaku ngaṟanyi. ");
INSERT INTO pjt_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Tjinguṟu waṟungka paulku, ka palu puṟunypaṯu palunya waṟungkaṯu pauntjaku ngaṟanyi. Tjinguṟu pungkula miṟi kaṯantankuku, ka palunya miṟiṯu pungkula kaṯantankunytjaku ngaṟanyi. Tjinguṟu pungkula miṟi raa-raalku, ka ngapartji pungkula miṟi raa-raantjaku ngaṟanyi. ");
INSERT INTO pjt_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Ka tjinguṟu wati kutjupangku aṉangu palumpa waṟkaripai kuṟu pungkula tjaḻantankuku, ka kuṟu patiringkuku. Ka uti wati panya mayatjangku waṟka panya palunya wantir'iyanma waṟkangka kanyilwiyangku kuṟu panya tjaḻantankunytjatjanungku. ");
INSERT INTO pjt_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Munu tjinguṟu waṟka palunya tjaa pungkula kaṯiṯi punkatjingaṟampa uti palu puṟunytjuṯu wantir'iyanma waṟkangka kanyilwiyangku, kaṯiṯi panya kaṯantankunytjatjanungku.” ");
INSERT INTO pjt_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Ka tjinguṟu pulukangku aṉangu mirpaṉarira uṉṯuṟa punkatjingaṟa yuṟuwilyangku wakaṟa iluntankuku. Ka puluka panya palunya apu puḻkangka atuṟa iluntankunytjaku ngaṟanyi, palu panya kuka ngalkuntja wiyangku wantima. Palu wati panya pulukaku walytjaya mirpaṉarira pungkula pikatjarantja wiyangku wantima. ");
INSERT INTO pjt_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","“Palu tjinguṟu puluka panya paluṟu iritilpi mirpaṉtju ngaṟangi, kaya aṉangu tjuṯangku wangkangi wati nyanga palula puluka panya yaatangka tjarpatjuṟa wantinytjaku aṉangu tjuṯa pungkunytjaku-tawara. Ka tjana wangkanyangka paluṟu tjinguṟu kulintja wiyangku wantinyi munu puluka panya uṟilta para-ngaṟanytjaku wantinyi yaatangka tjarpatjunkunytja wiyangku. Ka palulanguṟu ngula tjinguṟu aṉangu kutjupa pungkula iluntankunyangkampa puluka panya palunya atuṟa iluntankunytjaku ngaṟanyi wati panya pulukaku walytja kuḻu. ");
INSERT INTO pjt_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Palu tjinguṟu aṉangu panya miriku walytjangku wangkaku wati panya pulukaku walytja, ‘Palyantiya nyuntunya iluntankuwiyangku wantima nyuntu nganaṉanya mani ungkunyangkampa. Uti nyuntu nganaṉanya mani puḻka ungama nyampa nyangatja.’ Ka tjana alatji wangkanyangka kuliṟa uti paluṟu tjananya mani ungama alatjiṯu nampa panya tjana wangkanytja. ");
INSERT INTO pjt_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Ka tjinguṟu pulukangku tjitji pungkula iluntankuku tjinguṟu nyiṯayira munta tjinguṟu kungka, ka tjukurpa panya paluṟuṯu ngaṟanyi. ");
INSERT INTO pjt_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Tjinguṟu pulukangku iluntankuku wati waṟkaripai munta tjinguṟu minyma waṟkaripai, ka puluka panya palunya apungka atuṟa iluntankunytjaku ngaṟanyi. Ka wati panya pulukaku walytjangku uti mani puḻka ungama aṉangu panya waṟkaripaiku mayatja. ");
INSERT INTO pjt_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","34","“Ka palu puṟunypaṯu tjinguṟu wati kutjupangku piṯi ngaṯi puḻka tjawalku munu paluṟu tjinguṟu piṯingka angatjunkuwiyangku wantiku. Ka tjinguṟu puluka, tjinguṟu tangkiyi watarku pitjala kaṟalukatira iluku piṯi ngaṯingka. Ka wati panya piṯi tjawantjalu uti mani ungama panya piṯingka tjarpanytjitjaku walytja, mununku paluṟunku kuka panya piṯingka punkantjanya kanyinma. ");
INSERT INTO pjt_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Ka tjinguṟu wati kutjuku pulukangku pungkula iluntankuku wati kutjupaku puluka. Ka wati panya kutjarangku uti puluka panya wanka tjalamilanma munu mani mantjiṟa pulanku tjaraṟa ungama. Munu pula uti puluka panya ilunytja miṟiṟa iltjanpa tjuṯa kaṯaṟa tjaranma munu pulanku palu puṟunypaṯu ungama kuka palunya. ");
INSERT INTO pjt_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","“Palu tjinguṟu puluka panya paluṟu tjakangku puluka kutjupa tjuṯa pungkupai ngaṟanyi pikaṯi alatjiṯu, kaya aṉangu tjuṯangku tjinguṟu rawangku nyakupai palunya. Ka wati panya pulukaku walytjangku tjinguṟu kuliṟa wantipai munu puluka palunya yaatangka tjarpatjuṟa anga-kanyilwiyangku wantipai. Ka nyara palulanguṟu uṟilta ngaṟala tjinguṟu wati kutjupaku puluka pungkula iluntankuku. Ka alatjirinyangka uti wati panya puluka pikaṯiku walytjangku wati panya puluka miriku walytja ungama puluka wanka kutjupa mantjiṟa paluṟunku kanyintjaku, mununku uti paluṟunku kanyinma puluka panya miri ilunytja.” ");
INSERT INTO pjt_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Ka tjinguṟu nyuntu puluka kutju munta tjinguṟu tjiipi kutju kutitjuṟa katiku pungkula ngalkuntjikitjangku, munta tjinguṟu tjalamilaṟa mani mantjintjikitjangku. Munu uti nyuntu kutitjunkunytjatjanungku maḻakungku payamilanma kukaku panya walytja. Tjinguṟu puluka kutju kutitjunkunytjatjanungku nyuntu uti maḻakungku puluka maṉkur-kutjara ungama. Tjinguṟu tjiipi kutju kutitjunkunytjatjanungku nyuntu uti maḻakungku tjiipi kutjara kutjara ungama. ");
INSERT INTO pjt_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","4","Uwa, nyuntu uti kuka kutjupa kutjupa kutitjunkunytjatjanungku maḻakungku payamilanma. Palu tjinguṟu nyuntu mani wiyangku, kutjupa kutjupa kanyintja wiyangku maṟaltu kutitjunkunyangka kukaku walytjangku uti nyuntunya wati kutjupangka waṟkarinytjaku tjalamilanma mani mantjiṟa kuka kutjupa payamilantjikitjangku. Ka tjinguṟu kutjupangku nyuntunya kutitjuṟa katinyangka nyakuku, munu uti paluṟu nyakula nyuntunya markuṟa wangkama kuka palunya maḻakungku ungkunytjaku munu kuka kutjupa kuḻu. Nyuntu tjinguṟu puluka kutju, tjinguṟu tangkiyi kutju, tjinguṟu tjiipi kutju kutitjunkuku, ka kutjupangku katinyangka nyakula wangkanyangka uti nyuntu maḻakungku katira ungama munu piṟuku kuka palu puṟunypa kutjupa kuḻu mantjiṟa ungama kutjaraṟangku. “Ka tjinguṟu wati mungangka nyuntumpa waḻingka kumpiṟa tjarpaku, ka nyuntu nyakula palunya pungkuku, ka tjinguṟu iluku. Ka nyuntunya ngapartji pungkunytjaku ngaṟanytja wiya, panya nyuntu mungangka puṯu nyakula pungu ngura anga-kanyintjikitjangku. Palu tjinguṟu wati kutitjunkupai kaḻaḻa nyuntumpa waḻingka tjarpaku, ka nyuntu palunya nyakula pungkula iluntankuku. Nyara palulanguṟu nyuntu kaḻaḻa pungkunytjatjanu mulapa miriputjuringu, ka nyuntunya ngapartji pungkula iluntankunytjaku ngaṟanyi. ");
INSERT INTO pjt_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Ka tjinguṟu nyuntumpa kuka ngultju tjuṯangku nyuntumpa paamangka ukiṟi para-ngalkuṉi munta tjinguṟu nyuntumpa kiṟipitjingka unnguwanu unnguwanungku tjarpara ngalkuṉi, ka tjinguṟu nyuntu aṯunymankunytja wiyangkampa paluṟu tjana tjinguṟu wati panya kutjupaku ukiṟi maitjarakutu ma-tjarpaku munu mai walytjatjara ngalkula wiyalku. Ka alatjirinyangka nyuntu uti wati panya palunya kukangku mai panya ngalkuntjitjangka tjaraṟa ungama nyuntumpa mainguṟu mai palu puṟunypaṯu. ");
INSERT INTO pjt_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Ka tjinguṟu nyuntu waṟu tjukutjuku tililku nyuntumpa yaata puḻkangka, ka tjinguṟu tjilka tjuṯawanu lipiringkula wati kutjupaku yaatakutu waṟaṟa ma-kampara waṉalku munu palumpa mai kutjupa kutjupa paluṟu pakaltjingantja tjuṯa kampara wiyalku. Ka alatjirinyangka nyuntu uti nyuntumpa panya mainguṟu tjaraṟa palunya ungama mai puḻka palu puṟunypaṯu. ");
INSERT INTO pjt_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Ka tjinguṟu wati kutjupangku nyuntunya ungkuku kutjupa kutjupa palumpa unytjungku aṯunymaṟa kanyintjaku tjinguṟu mani. Ka tjinguṟu wati kutitjunkupaingku nyuntumpa waḻingka tjarpara kutitjuṟa katiku kutjupa kutjupa panya tjuṯa. Kaya tjinguṟu wati panya palunya nyakula witilku, ka uti paluṟu maḻakungku ungama kutjupa kutjupa panya tjuṯa paluṟu mantjintjatjanungku munu piṟukuṯu ungama kutjupa tjuṯa kuḻu tjunguṟa. ");
INSERT INTO pjt_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Palu tjinguṟuya wati panya kutitjunkupainya puṯu ngurilku, ka kutjupa kutjupa panya tjuṯa katiku alatjiṯu. Ka tjinguṟu wati panya kutjupa kutjupa tjuṯaku walytjangku nyuntunya ngukaṟa kulilku, ‘Tjinguṟu nyangangku kutitjunu, ngayulu panya ungkunytjitjalu.’ Ka alatji nyuntunya ngukannyangka nyuntu uti ngura panya Godanya waḻkulpailakutu anama, kaya ngurkantankupai tjuṯangku nyuntunya kuliṟa tjukaṟurungku ngurkantankuku. ");
INSERT INTO pjt_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“Tjinguṟu wati kutjarangku pulanku pikangku wangkaku kutjupa kutjupanguṟu tjinguṟu pulukanguṟu, munta tjinguṟu tangkiyinguṟu, tjinguṟu tjiipinguṟu, tjinguṟu nanikutanguṟu, munta tjinguṟu mantaranguṟu. Tjinguṟu kutjungku wangkaku, ‘Uwaṉi! Ngayukun palatja kutitjunu.’ Ka alatji pula pikaringkunyangkaya uti katima yiwaḻa panya Godanya waḻkulpailakutu, ka nyara palula pulanya Godalu ngurkantankuku wati yaaltjingku tjukaṟurungku wangkanyi. Ka wati panya ngunti wangkanytjalu uti maḻakungku ungama munu kutjupa kuḻu tjunguṟa ungama kutjara-aṟangku. ");
INSERT INTO pjt_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Ka tjinguṟu wati kutjupangku nyuntunya wangkaku palumpa kutjupa kutjupa unytjungku aṯunymaṟa kanyintjaku, tjinguṟu tangkiyi, munta tjinguṟu puluka, tjinguṟu tjiipi, tjinguṟu kuka kutjupa. Ka nyuntu kanyinnyangka kuka panya paluṟu tjinguṟu iluku, munta tjinguṟu pikatjararingkuku, munta tjinguṟu kutjupangku kutitjuṟa katiku kampangkaṯu. Ka alatjirinyangka aṉangu kutjupangku tjinguṟu nyakunytja wiya, ka wati panya kukaku walytjangku tjinguṟu ngunti kulilku nyuntu kutitjunkunytja-palku. ");
INSERT INTO pjt_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Ka palulanguṟu alatji ngunti ngukannyangka uti nyuntu anama yiwaḻa panya Godanya waḻkulpailakutu munu nyara palula Godala miṟangka mulamulangku wiyanmanama. Ka alatji wangkanyangka uti wati panya kukaku walytjangku kuliṟa nyuntumpa mulamularingama munu kuka wiyaringkunytjitjanguṟu maḻakungku payamilantjaku nyuntula ngatjintja wiyangku wantima. ");
INSERT INTO pjt_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Palu tjinguṟu nyuntu kanyinnyangka wati kutitjunkupaingku kampangkaṯu pitjala kutitjuṟa katiku, ka nyara kutitjunkunytjanguṟu kutju nyuntu uti maḻakungku payamilanma wati panya kukaku walytja. ");
INSERT INTO pjt_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Palu tjinguṟu inuṟa tjuṯangku kuka panya palunya patjaṟa iluntankuku, ka uti nyuntu kuka panya patjantjitja mantjiṟa katira nintinma wati panya kukaku walytjangka ilunytjitja nyakula mulamularingkunytjaku. Ka nyara palulanguṟu nyuntu palunya maḻakungku payamilantjaku wangkanytja wiyangku kulilku panya inuṟangku patjantja. ");
INSERT INTO pjt_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","15","“Ka tjinguṟu nyuntu wati kutjupangka tjapilku pulukaku, munta tjinguṟu tangkiyiku unytjungku kanyintjikitjangku. Ka tjinguṟu paluṟu nyuntunya wangkaku kuka unytjungku kanyiṟa payamilalkatinytjaku, munta tjinguṟu paluṟu maniku ngatjintja wiyangku nyuntunya ungkuku unytjungku kanyintjaku. Ka nyuntu katira kanyinnyangka tjinguṟu pikatjararingkuku munta tjinguṟu kampangkaṯu iluku kuka panya paluṟu. Ka palulanguṟu nyuntu uti maḻakungku payamilanma kukaku panya walytja. Palu tjinguṟu wati kukaku walytjangku kuka panya pikatjararingkunyangka, munta tjinguṟu ilunyangka ngaṟala nyanganyi ilangku. Munu palulanguṟu paluṟu ilangku nyakunytjatjanungku nyuntunya maḻakungku payamilantjaku wangkanytja wiya, panya kuka paluṟu walytjangka miṟangka ilungu. Tjinguṟu nyuntu palunya mani ungkukatingi kuka panya palunya unytjungku kanyintjikitjangku, ka mani nyara palulanguṟu paluṟu kuka kutjupa payamilalku. ");
INSERT INTO pjt_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Ka tjinguṟu watingku kungkawaṟaku nyakula mukuringkuku munu palunya arkaṟa ngunti aḻṯiku munu palulanguṟu palunya aḻṯira katira kampangkaṯu unytju palula tjunguringkuku. Ka nyanga alatji palyantjatjanungku uti wati panya paluṟu kungkawaṟaku panya mama mani ungama palumpa uṉṯalpa aḻṯinytjikitjangku munu palunya mulamulangkulta aḻṯira kanyinma. ");
INSERT INTO pjt_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Palu tjinguṟu kungkawaṟaku panya mamangku ungkunytja wiyangku wantiku wati panya paluṟu aḻṯinytjaku. Ka palulanguṟu uti wati panya paluṟu kungkawaṟaku panya mama mani ungama alatjiṯu, ngaṉmanypa panya palumpa uṉṯalpangka ngarinytjatjanungku, munu wantima kungkawaṟa panya palunya aḻṯinytja wiyangku mamangku painnyangka. ");
INSERT INTO pjt_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Tjinguṟu minyma kutjupangku iraṯingka initjunkupai, ka palunya pungkula iluntankunytjaku ngaṟanyi alatjiṯu. ");
INSERT INTO pjt_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Ka tjinguṟu watingkumpa tjiipi kungka, munta nanikuta kungka, munta kuka kutjupa kungka pampuṟa kurannyangkampa wati palunya apungka atuṟa iluntankunytjaku ngaṟanyi alatjiṯu. ");
INSERT INTO pjt_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Ka kutjupangku tjinguṟu ngayunya wantira god kutjupa kuka katira ungkula waḻkunnyangkampa palunya apungka atuṟa iluntankunytjaku ngaṟanyi alatjiṯu. ");
INSERT INTO pjt_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Ka nyura uti aṉangu malikitja kuralwiyangku mukulyangku kanyinma, panya nyura kuḻu ngaṉmanypa malikitja nyinangi ngura panya Itjipala. ");
INSERT INTO pjt_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“Munu nyura uti minyma wanakaḻa tjuṯa munu tjitji tjiṯula tjuṯa kuḻu ngaḻṯunytjungku kanyinma kuralwiyangku. ");
INSERT INTO pjt_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","24","Palu tjinguṟu nyura tjananya kuralku, ka tjana ngayunya ulara tjapilku alpamilantjaku. Kaṉa ngayulu Mayatja puḻkangku tjana tjapinnyangka kulilku, munuṉa puḻkaṟa mirpaṉarira nyuranya iluntankunytjaku iyalku warmaḻa tjuṯa. Ka nyara palulanguṟu nyurampa minyma tjuṯa wanakaḻariku munu tjitji tjuṯa kuḻu tjiṯulariku nyura ilunyangka. ");
INSERT INTO pjt_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Ka tjukurpa kutjupa nyangatja panya mani unytjungku ungkunytjatjara. Tjinguṟu nyuntu mani puḻkatjarangku aṉangu ngaḻṯutjara mani tjukutjukutjara unytjungku mani ungkuku paluṟu ngula maḻakungku ungkunytjaku. Palu nyuntu uti mani nampa panya palunyaṯu kutju maḻakungku mantjinma munkararinytja wiyangku. Panya wati mani unytjungku ungkupai tjuṯangku mani puḻka nguwanpa maḻakungku mantjilpai nampa panya ungkunytjitjangka waintaṟa. Palu nyura nyara tjananya arkantja wiyangku wantima munuya mani nampa palunyaṯu mantjinma mani puḻka waintaṟa mantjilwiyangku ngaḻṯutjara panya tjuṯanguṟu. ");
INSERT INTO pjt_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","27","Tjinguṟu aṉangu kutjupangku nyuntula maniku ngatjilku unytjungku mukuringkula. Ka paluṟu tjinguṟu nyuntunya maḻakungku ungkunytjikitjangku kalkuṟa palumpa upukuta nyuntunya ungkuku nyuntu ngapartji unytjungku kanyintjaku. Palu uti nyuntu upukuta palunya mungartjirinyangka maḻakungku mapalku ungama waringka-tawara. Panya paluṟu ngaḻṯutjarangku upukuta palunya kutju kanyini unytjunarinytjikitjangku, munu mantara yaaltjingka paluṟu tjarpara ngariku nyuntu palumpa upukuta rawangku kanyinnyangka? Ka upukuta wiyangku ngayula ulara tjapinnyangkaṉa ngayulu kulilku munuṉa palumpa ngaḻṯuringkuku. ");
INSERT INTO pjt_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Kulilaya! Ngayunyaṉiya Mayatja Godanya kuranmankuwiyangku wantima alatjiṯu munu palu puṟunypaṯu nyurampa mayatja tjuṯa kuranmankuwiyangkuṯu wantima. ");
INSERT INTO pjt_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","30","“Munuṉiya ngayunya wangaṉarangku ungama mai panya kutjupa kutjupa tjuṯa pakaltjingantjatjanungku. Panya nyura ngayunya tjara ungkunytjaku ngaṟanyi nyurampa mai wiitanguṟu, munu kiṟipitji wangaṟanguṟu, munu alipa wangaṟanguṟu kuḻu. “Munuṉiya nyurampa katja panya ngaṉmanypa ngarinytja tjuṯa kuḻu uwa, munu nyurampa puluka tjiipinguṟu kuḻu katja ngaṉmanypa ngarinytja tjuṯa. Palu iṯi kuwaritjaya ngunytjungka kanyintjaku wantima tjiṉṯu 7 munu palulanguṟulta tjiṉṯu 7 wiyaringkunyangka tjiṉṯu 8-ngka kutju mantjiṟa katira ngayunya ungama. ");
INSERT INTO pjt_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Nyura panya ngayuku walytja tjuṯa nyinanyi, ka pala palulanguṟu nyura kuka panya inuṟangku patjaṟa iluntankunytjitja nyakula mantjiṟa ngalkuwiyangku wantima. Palu nyurampa papa tjuṯa kutjuya ungama ngalkuntjaku.” ");
INSERT INTO pjt_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Kulilaya! Nyura uti tjukurpa ngunti-ngunti para-tjakultjunkunytja wiyangku wantima. Tjinguṟu watingku mulapa kura palyaṉu, kaya palunya alpamilaṟa ngunti wangkanytjikitjangku kulintja wiyangku wantima. ");
INSERT INTO pjt_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“Munuya aṉangu tjuṯangku kura palyannyangka nyakulampa tjanala tjunguringkunytja wiyangku wantira palyanyku nyinama. Tjinguṟuya aṉangu tjuṯangku kuutpangka ngaṟala wati ngurkantankupaingka ngunti tjakultjunanyi, ka tjana nyuntunya palu puṟunypaṯu ngunti wangkanytjaku wituwitunnyangka kuliṟa wantima munu nyuntu walytjangku kulintja kutju tjukaṟurungku tjakultjunama. ");
INSERT INTO pjt_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Tjinguṟuya wati mani wiyatjara ngaḻṯutjara kura palyannyangka witiṟa kuutpakutu katiku mayatjangku ngurkantankunytjaku. Ka wati panya mayatja ngurkantankupailu uti palunya ngunti mani wiyatjaraku ngaḻṯuringkula wantiwiyangku tjukaṟurungku ngurkantanama kura palyantjitjanguṟu. ");
INSERT INTO pjt_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Tjinguṟu aṉangu kutjupa nyuntumpa rawa kuraringkupai nyinanyi. Ka nyuntu tjinguṟu palumpa puluka munta tjinguṟu tangkiyi ankunyangka nyakulampa wantir'iyalwiyangku maḻakungku mantjiṟa katira palunya ungama. ");
INSERT INTO pjt_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Munu tjinguṟu nyuntu nyanganyi wati panya palumpa tangkiyi ulytja puḻkatjara punkannyangka, munu nyuntu uti nyakulampa palunya wantiwiyangku alpamilanma tangkiyi panya maḻakungku pakaltjingantjaku. ");
INSERT INTO pjt_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Ka tjinguṟu wati ngaḻṯutjara mani wiyatjara kuutpangka ngaṟanyi mayatjangku ngurkantankunytjaku. Ka uti mayatja panya paluṟu wati panya ngaḻṯutjara purkaṟangku kulinma munu tjukaṟurungku ngurkantanama ngunti kurantja wiyangku. ");
INSERT INTO pjt_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Ka nyura kuutpangka ngaṟala mayatjangka miṟangka ngunti aṉangu kutjupa kuralwiyangku wantira tjukaṟurungku kutju wangkama mulamulangku. Munuya aṉangu kutjupa palyanyku nyinanyangka unytjungku kukanymaṟa iluntankuwiyangku wantima. Panya ngayulu aṉangungku kura palyannyangka nyakula wantiwiyangku palunya ngurkantankupai ngapartji pikatjarantjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“Tjinguṟu wati kurangku nyuntunya mani ungkuku kuutpangka ngaṟala mayatja panya ngurkantankupailu ngunti kurantjaku tjukaṟurungku-palku wangkara. Palu alatji mani ngunti ungkunyangka wantima alatjiṯu tjukaṟurungku kutju wangkanytjikitjangku. Panya mani nyanga paluṟu nyuntumpa kulintja kuralku, ka nyuntu manikitjangku tjukaṟurungku-palku wangkaku munu aṉangu panya palyanyku nyinapainya kuranmankuku mayatja ngurkantankupailu ngunti mulapa-palku ngurkantankunytjaku. ");
INSERT INTO pjt_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Nyura uti aṉangu malikitja tjuṯa kuralwiyangku palyanyku kanyinma. Panya nyura ninti, panya ngaṉmanypa nyura kuḻu ngura Itjipala malikitja nyinangi.” ");
INSERT INTO pjt_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Ka nyura uti yiya 6 ngaṟanyangka manta nyurampa ngaṯiṟa runyuṟa uṉinypa tjuṯa tjarpatjura waṉanma mai puḻka pakaltjingantjikitjangku. Munuya mai pakaṟa kuṟuringkunyangka uranma. ");
INSERT INTO pjt_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Munuya palulanguṟu yiya panya 6 ngaṟala wiyaringkunyangka maḻangka yiya panya 7-ta uṉinypa mai piṟuku pakaltjingalwiyangku wantima manta panya yiya kutju uḻṯu ngarira pakuwiyaringkunytjaku. Ka nyura uti mai kutjupa kutjupa tjuṯa walytja pakannyangka nyakula uralwiyangku wantima aṉangu ngaḻṯutjara tjuṯangku pitjala uraṟa ngalkuntjaku, inuṟa tjuṯangku kuḻu. Munuya palu puṟunypaṯu mantjintjaku wantima mai kiṟipitji, munu mai alipa kuḻu. ");
INSERT INTO pjt_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Munu nyura uti tjiṟirpi 6 kutju waṟkarima munu palula maḻangka tjiṟirpi 7-ta waṟkariwiyangku wantira pakuwiyaringama, ka nyurampa aṉangu waṟkaripai tjuṯa kuḻu uti waṟka wiya nyinara pakuwiyaringama, munu nyurampa puluka, tangkiyi tjuṯa kuḻu. Ka aṉangu malikitja tjuṯa kuḻu uti nyurala tjungu nyinara pakuwiyaringama tjiṟirpi panya 7-ta. ");
INSERT INTO pjt_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Uwa, wangaṉarangkuya kulinma uwankara ngayulu Mayatja Godalu nyurala wangkanytja. Munuya wantima god kutjupangka tjapilwiyangku, munuya ini palunya tjananya wangkawiyangku alatjiṯu wantima.” ");
INSERT INTO pjt_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Ka nyura uti yiya kutjupa yiya kutjupa inma puḻka maṉkurpa palyanma tiṯutjarangku ngayunya waḻkuntjikitjangku.” ");
INSERT INTO pjt_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","“Piṟa panya ini Apipala nyura uti inma panya ini ‘Mai Piltjanya’ palyanma panya piṟa nyanga palula nyura Itjipanya wantikatingu, ka panyaṉa inma nyanga palunya palyantjaku nyurala ngaṉmanytju wangkangu. Kaya panya puṟunypaṯu palyanma munuya mai pilytja kutju ngalkunma yiitjatjara wantira inma nyanga paluṟu ngaṟanyangka tjiṉṯu panya 7 ngaṟala wiyaringkunytjaku. Munuya ngayunya waḻkuntjikitja maṟalpa pitjawiyangku kuka katima ngayunya ungkunytjikitjangku.” ");
INSERT INTO pjt_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Munu nyura uti inma puḻka kutjupa palyanma kuḻingka nyurampa mai wiita kuṟuringkunyangka urantjikitjangku inma ini ‘Mai Urantjanya.’ Munuya mai uraṟa ngaṉmanytju urantjitja-waraṟa ngayunya ungama, panya ngayuluṉa nyurampa mai uwankara pakaltjingaṉu.” “Munu palulanguṟu kuḻingka maḻangka nyura uti piṟuku inma puḻka kutjupa ini ‘Wiltjanya’ palyanma, panya nyura mai kiṟipitji kuṟu, munu mai panya kutjupa tjuṯa puṉungka kuṟuringkula ngaṟanytja kuḻu urantjatjanungku. ");
INSERT INTO pjt_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“Uwa, yiya kutjupa yiya kutjupa wati uwankarangku uti maṉkuraṟa tjunguringama inma nyanga maṉkurpa palyaṟa ngayunya Mayatja Godanya waḻkuntjikitja. ");
INSERT INTO pjt_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Munu nyura uti kuka pungkulampa mai yiitjatjarangka tjunguṟa ngayunya ungkuwiyangku wantima munu mai pilytjangka kutju tjunguṟa ungama. Munuya kuka pungkulampa kaṉpi uwankara kukanguṟu kaṯala munu tjiṉṯu nyara palulaṯu waṟungku tiliwakala uwankara wiyaringkunytjaku. ");
INSERT INTO pjt_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Ka panya nyura kuḻi kutjupa kuḻi kutjupa mai wiita nyurampa kuṟuringkunyangka uralpai. Palu uti nyura mai ngaṉmanytju urantja tjuṯa katima Mayatja Godaku waḻikutu, munu palulanguṟu maḻa urantja tjuṯa kutju nyurampa ngurakutu katima. “Munuya nanikuta kuḻunypa ngunytjunguṟu ipi uṟu mantjiṟa kuka panya kuḻunypa palunya ipi uṟungka kutjantja wiyangku wantima alatjiṯu.” ");
INSERT INTO pjt_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Kulilaya! Ngayulu angelpa iyalku nyura ankunyangka kuranyurira nyuranya aṯunymaṟa katiṟinkunytjaku ngura panya ngayulu ngaṉmanytju nyurampa palyantjitjakutu. ");
INSERT INTO pjt_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Ka nyura uti angelpa nyanga palula wangaṉarangku kulinma tungunpungkuwiyangku panya ngayuluṉa palunya wituṟa iyaṉu tjakulpa nyuralakutu. Kaya paluṟu wangkanyangka kuliṟa wantinytja wiyangku wangaṉarangku kulinma, panya nyura palula tungunpungkula wantinyangkampa angelpa paluṟu nyurampa puḻkaṟa mirpaṉariku munu nyura wantinytjanguṟu watarkuriwiyangku rawangku kulilku. ");
INSERT INTO pjt_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Paluṟu nyurala tjakultjunkuku uwankara ngayulu palula wangkanytja, ka nyura wangaṉarangku kuliṟa tjukaṟurungku palyannyangka ngayulu ngalkilarira nyurampa mirpaṉtju tjuṯa pikangku pungkuku. ");
INSERT INTO pjt_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Ka ngayuku angeltu nyurala kuranyurira nyuranya katiṟinkuku manta panya palulakutu, panya manta nyara palulawanu aṉangu kutjupa kutjupa kuwari ma-nyinara waṉaṉi ngura tjuṯangka, aṉangu panya Amurkunu tjuṯa, Iitakunu tjuṯa, Piṟitjikunu tjuṯa, Kainankunu tjuṯa, Ipakunu tjuṯa, munu Tjaipukunu tjuṯa kuḻu. Kaṉa nyara palunya tjananya ngayulu pungkula wiyalku. ");
INSERT INTO pjt_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Ka nyura uti tjanampa god tjuṯa pupakatira waḻkulwiyangku wantima munuya tjanampa inmaku nintiringkuwiyangku kuḻu wantima munu tjananya arkantja wiyangku wantima alatjiṯu. Munuya tjanampa god panya puṉunguṟu palyantja tjuṯa kaṯantaṟa minya-minyanma, munu palu puṟunypaṯu tjanampa apu panya waṟa miḻmiḻpa tjuṯa kuḻu punkatjingaṟa kaṯantaṟa wiyanma. ");
INSERT INTO pjt_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","“Munuya ngayunya kutju waḻkunma nyurampa Mayatja Godanya, kaṉa ngayulu nyuranya pukuḻmaṟa ungkuku mai puḻka mina puḻka kuḻu, munuṉa aṉangu kutjupa pikatjara ngarinyangka palyaṟungulku alatjiṯu, ka pika uwankara wiyaringkuku. ");
INSERT INTO pjt_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Ka nyura ngura nyara palula nyinara minyma uwankarangku tjitji iṯi wiṟu kanyilku, ka iṯi uwankara tjuningka unngu ilunytja wiya wanka alatjiṯu wirkankuku. Ka minyma kutjupa iṯi wiya nyinanytja wiya uwankarangku alatjiṯuya iṯi kanyilku, ka tjitji uwankara puḻkaringkula rawa mulapa nyinaku munuya tjiḻpiringkula pamparingkula kutju iluku. ");
INSERT INTO pjt_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Kaṉa ngayulu aṉangu panya manta nyara palula ngaṉmanypa nyinanytja tjuṯa nyurampa nguḻu-nguḻu nyinanytjaku palyalku. Ka nyura palula tjanalakutu ma-wirkankunyangka nyakula paluṟu tjana puṯu kuli-kulilku munuya puḻkaṟa nguḻuringkula wirtjapakalku nyuralanguṟu. ");
INSERT INTO pjt_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Ngayuluṉa iḻiḻpa puṟunypa tjuṯa nyurala kuranyu iyalku aṉangu panya Ipakunu tjuṯakutu munu Kainankunu tjuṯakutu munu Iitakunu tjuṯakutu kuḻu, kaya paluṟu tjana nyakula nguḻu wirtjapakalku munuya ngura nyara palunya wantikatiku. ");
INSERT INTO pjt_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Palu ngayuluṉa tjananya mapalkungku yiya kutjungka nguḻutjingaṟa pakaltjingantja wiyangku wantinyi. Tjinguṟu ngayulu tjananya mapalkungku pakaltjingannyangkampa ngura paluṟu uḻṯu ngaṟaku aṉangu wiyangka, ka kuka inuṟa tjuṯa mularariku munuya manta angaṟa nyinaku pikaṯi tjuṯa, ka nyura puṯu nguwanpa tjananya nguḻutjingalku. ");
INSERT INTO pjt_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Palu ngayulu tjananya purkaṟangku pakaltjingalku nyura aṉangu ma-tjuṯa mulararinytjaku paṯaṟa. Ka palulanguṟu nyura tjuṯa mulararira manta pala palula lipiwanu nyinaku ngura winkingka. ");
INSERT INTO pjt_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“Ngayulu kuwari manta puḻka nyuranya unganyi, panya uḻpaṟira uṟu ini Tjitin-tjitinnga ngaṟanyi, ka nyurampa manta ngaṟaku nyara palulanguṟu alinytjara karu uṟu ini Yupuṟaitilakutu. Ka panya kakaraṟa uṟu puḻka ini Mititu-ṟaniyanya ngaṟanyi, ka nyurampa manta ngaṟaku uṟu nyara palulanguṟu wiluṟarakutu pilakutu. Nyanga alatjiṉa nyuranya unganyi manta puḻka munuṉa nyuranya puḻkaṟa witulyankuku aṉangu panya palula nyinapai tjuṯa pikangku pungkula ma-pakaltjingantjaku. ");
INSERT INTO pjt_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Ka nyura uti tjanala munu tjanampa god tjuṯangka kuḻu kalypantaṟa wangkanytja wiyangku wantima. ");
INSERT INTO pjt_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Munuya nyurampa ngurangka nyinanytjaku-tawara tjananya paiṟa iyanma. Panya tjana tjinguṟu nyurampa ngurangka nyinarampa nyuranya mukumukulku tjanampa god tjuṯa waḻkuntjaku, ka nyura ngayunya kulintja wiyaringkuku munu watarkuriku.” Alatji Godalu tjukurpa tjuṯa Mosela tjakultjunu aṉangu Israelkunu tjuṯangka ngapartji wangkanytjaku. ");
INSERT INTO pjt_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Munu Mayatja Godalu Mosela piṟuku wangkangu, “Puḻi katukutu pula piṟuku ngalya-tatila ngayulakutu Aaronnga nyupali munu pula wati Natapanya pulanya Apiyunya kuḻu kati munu wati Israelkunu puḻka tjuṯa wati 70 tjananya kuḻu ngalya-kati. Palu nyura ngalya-ilaringkunytja wiyangku paṯunguṟu ngayunya pupakatira waḻkunma. ");
INSERT INTO pjt_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Palu Mose, nyuntu kutju ngayulakutu ilaringama, kaya wati panya puḻka tjuṯa uti paṯupaṯu ngaṟama. Kaya aṉangu tjuṯa uti tjaṟu mantangka ngaṟama puḻikutu ngalya-tatintja wiya.” ");
INSERT INTO pjt_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Ka Moselu mulapaṯu Godaku tjukurpa uwankara kuliṟa ankula aṉangu tjuṯangka tjakultjunu uwankara panya Godalu wangkanytjitja tjukurpa panya tjuṯa mulapa. Kaya aṉangu uwankarangku kuliṟa tjungungku wangkangu, “Nganaṉa mulapa Godaku tjukurpa uwankara wangaṉarangku kuliṟa palyalku.” ");
INSERT INTO pjt_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Ka Moselu Godaku tjukurpa uwankara walkatjunu. Munu mungawinki mulapa pakaṟa pitjilpa puḻka palyaṉu puḻi panya palula paṉṯangka, munu paluṟu puḻi tjiwa tjuṯa 12 muṟutjuṟa waṉaṉu. Paluṟu puḻi kutju kutju 12 muṟutjunu wati panya Israelku katja tjuṯaku, panya katja nyanga palula tjanalanguṟu aṉangu Israelkunu tjuṯa utiringkula nyinangi walytjaṟara walytjaṟara. ");
INSERT INTO pjt_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Munu palulanguṟu Moselu Israelkunu wati yangupala tjuṯa wituṟa iyaṉu, kaya ankula kuka pungkula tiliwakaṟa Godanya waḻkuntjikitjangku ungangi, munuya piṟuku kuka puluka nyiṯayira kuḻunypa tjuṯa pungkula kuka tjara tiliwakaṟa Godanya ungu munu tjara kutjupa pauṟa aṉangu tjuṯa ungu ngalkuntjaku. ");
INSERT INTO pjt_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Ka Moselu kuka tjuṯanguṟu milkaḻi tjara mantjiṟa piti tjuṯangka tjutiṉu, munu tjara kutjupangka pitjilpa panya kurpinu. ");
INSERT INTO pjt_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Munu palulanguṟu paluṟu Godaku nyiri tjukurtjara mantjiṟa aṉangu tjuṯangka nyakula wangkangi, kaya kuliningi. Munuya wangkara wiyaringkunyangka tjana kalkuṉu wangkara, “Nganaṉa Mayatja Godala wangaṉarangku kulilku, munula paluṟu wangkanytja uwankara tjukaṟurungku palyalku.” ");
INSERT INTO pjt_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Ka palulanguṟu Moselu piti panya milkaḻitjara tjuṯa mantjinu munu aṉangu tjuṯa milkaḻingka kurpinu. Munu wangkangu, “Nyawaya milkaḻi nyangatja, panya kuwari Godalu nyuranya kalkuṉu aṯunymaṟa kanyintjikitjangku munu panya nyurala tjukurpa wiṟu tjuṯa wangkangu nyura kuliṟa palyantjaku, ka panya nyura ngapartji kalkuṉu paluṟu wangkanytja uwankara wangaṉarangku kulintjikitjangku. Ka milkaḻi nyangangku nintini Godalu nyuranya kalkuntja munu nyura palunya kalkuntja.” ");
INSERT INTO pjt_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Ka palulanguṟu Mosenya tjana Aaronnga, Natapanya, Apiyunya munu wati Israelkunu puḻka tjuṯa kuḻu puḻingka tatinu. ");
INSERT INTO pjt_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Munuya tatiṟa nyangu Israelku God. Munuya paluṟu paḻtjuṟa ngaṟanytjitjangka apu panya kaṟaly-kaṟalypa mulapa ngarinyangka nyangu walka puyula-puyula ilkaṟi puṟunypa. ");
INSERT INTO pjt_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Ka Godalu nyanga tjananya wati Israelkunu puḻka tjuṯa pungkula wiyantja wiyangku wantingu. Paluṟu tjana panya Godanya nyangu, munuya palunya nyakunytjatjanungku nyinakatira tjungungku mai ngalkula tjikiningi. ");
INSERT INTO pjt_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Munu palulanguṟu Godalu Mosenya wangkangu, “Ngayulakutu nyuntu kutju ngalya-tatila puḻi katu munu paṯala palangka. Kaṉanta ungkuku tjiwa kutjara panya ngayulu palula pulala tjukurpa puḻka mulapa walkatjunu aṉangu tjuṯangku kuliṟa nintiringkunytjaku.” ");
INSERT INTO pjt_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","15","Ka Mosenya pula palumpa wati alpamilalpai ini Tjatjuwanya tatintjikitja ritiringu. Palu Moselu ankunytjikitjangku wati panya puḻka tjuṯangka wangkangu ngurangka nyinanyangka, “Nyangangkaya paṯaṟa nyinama ngalimpa, kali ngula maḻaku pitjaku. Nyanga Aaronnga pula Uunya nyinanyi nyuranya aṯunymankunytjikitja, ka tjinguṟu aṉangu kutjara pikaringkunyangkampa palula pulalakutu katima pulanya kalypantjaku.” Munu palulanguṟu Mosenya Tjaniyala ma-tatinu Godaku panya puḻi miḻmiḻṯa. Ka utuwaṟi puḻkangku puḻi panya angatjunu. ");
INSERT INTO pjt_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","17","Ka Mayatja Godanya ukalingu puḻi pala palula munu irnyaṟa ngaṟangi tili puḻka mulatu. Kaya Israelkunu tjuṯangku tjaṟunguṟu ira-nyangangi katukutuṟa waṟu puḻkangku kampanyangka-palku puḻi panya katu. Ka utuwaṟingku puḻi panya tjutuṟa ngaṟangi tjiṟirpi 6, ka palulanguṟu tjiṟirpi 6 ngaṟala wiyaringkunyangka tjiṟirpi 7-ta Mayatja Godalu Mosenya utuwaṟinguṟu aḻṯingu. Kuwari nyura chapter 24 nyakunytjatjanungku chapter 25 puṯu nyanganyi munu nyura chapter 26-nguṟu 28-kutu kuḻu puṯu nyanganyi panya chapter nyanga palunya tjananya nganaṉa Pitjantjatjara walkatjunkunytja wiyaṯu kuwaripa. Palu chapter 25-nguṟu 28-kutu tjukurpa nyaa ngaṟanyi, panya Godalu Mosenya puḻi ini Tjaniyala katu tjukurpa kutjupa kutjupa wangkanytja. Paluṟu panya Mosenya wangkangu Tiinta Miḻmiḻpa palyantjaku pala palula unngu paluṟu tjana Godala tjunguringkula kulintjaku, tjukurtjara tjuṯangku kuḻu. Munu Godalu tjukurpa kutjupa tjuṯa kuḻu wangkangi palunya tjakultjuṟa utintjikitjangku panya Tiinta Miḻmiḻpa yaaltjingaṟa tjukaṟurungku palyantjaku, tiinta unngu nyinanytja kutjupa kutjupa tjuṯa kuḻu palyantjaku, munu mantara wiṟu tjukurtjara tjuṯaku kuḻu tjukaṟurungku palyantjaku. Tjukurpa nyanga Godalu Mosela utiṟa tjakultjunkunytja ngaṟanyi chapter nampa nyanga palula tjanala 25-ngka, 26-ngka, 27-ngka, munu 28-ngka, munu piṟuku ngaṟanyi chapter 30-ngka munu chapter 32-ngka. Kala kuwari tjukurpa nyanga palunya tjananya muṯumuṯuṟa aṟangka tjunanyi tjukutjuku tjukutjuku nyura nyakula kulintjaku tjukurpa nyaa puṟunypa ngaṟanyi chapter nyanga palula tjanala. ");
INSERT INTO pjt_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","9","Chapter 25-ngka verse 1-nguṟu 9-kutu tjukurpa nyangatja ngaṟanyi, panya Godalu Mosela wangkangu Israelkunu tjuṯangka tjakultjunkunytjaku tjana kutjupa kutjupa wiṟu tjuṯa kanyintjatjanungku katira palunya ungkunytjaku palula tjanalanguṟu tiinta panya miḻmiḻpa palyantjaku munu unngu nyinanytja tjuṯa kuḻu palyantjaku, mantara tjukurtjara tjuṯaku kuḻu palyantjaku. Munu paluṟu Mosenya wangkangu Israelkunu kutjupa tjuṯangka wangkanytjaku tiinta panya miḻmiḻpa Godaku tjukaṟurungku palyantjaku, munu paluṟu wangkangu, “Ngayulu wangkanyangka uwankara alatjiṯu palyala.” Ka nyura maḻangka nyawa chapter 35-ngka verse 4-nguṟu 9-kutu Moselu aṟa nyangatja ngapartji tjakultjunkunytja Israelkunu tjuṯangka. Munuya piṟuku nyawa chapter 35-ngka verse 20-nguṟu 29-kutu aṟa panya Israelkunu tjuṯangku wangaṉarangku kutjupa kutjupa tjuṯa kanyintjatjanungku katira Godanya ungkunytja palumpa Tiinta Miḻmiḻku. ");
INSERT INTO pjt_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","22","Ka chapter 25-ngka verse 10-nguṟu 22-kutu tjukurpa nyangatja ngaṟanyi, panya Godalu Mosenya wangkangu Pakutja Kalkuntjitja palyantjaku, panya pakutja nyanga palula tjiwa panya kutjara tjukurpa puḻka 10-tjara tjarpatjunkunytjaku. Godalu utiṟa tjakultjunu Mosenya yaaltjingaṟa pakutja palunya palyantjaku munu piṟuku wangkangu pakutja liitangka katu angelpa nyaḻpitjara kutjara kampa kutjara palyantjaku. Paluṟu wangkangu, “Nyaḻpi pala lipi kutjara liitangka katu anga-ngaṟanytjaku palyala, panya nyara palula liitangka katu angelpa kutjarangka nguṟurpa ngayulu nyuntula tjunguringkuku munuṉanta wangkaku nyuntu Israelkunu tjuṯangka ngapartji tjakultjunkunytjaku tjana kuliṟa ngayula wangaṉarangku kulintjaku.” Ka aṟa nyanga paluṟu ngaṟanyi chapter 37-ta verse 1-nguṟu 9-kutu, panya Pakutja Kalkuntjitja palyantja. Pakutja palunya wati ini Pitjaliltu tjana palyaṉu tjukaṟurungku Moselu tjanala tjakultjunkunyangka Godalu wangkanytja. ");
INSERT INTO pjt_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","30","Ka chapter 25-ngka verse 23-nguṟu 30-kutu tjukurpa nyangatja ngaṟanyi, panya Godalu Mosenya wangkangu taipula palyantjaku mai panya Godanya ungkunytjitja palula katu tjunkunytjaku. Munu Godalu wangkangu taipula pala palula mai miḻmiḻpa palumpa tiṯutjarangku tjunkukatinytjaku mungawinki kutjupa mungawinki kutjupa. Ka aṟa nyanga paluṟu ngaṟanyi chapter 37-ta verse 10-nguṟu 16-kutu panya taipula palunya palyantja. Taipula palunya panya wati Pitjaliltu tjana palyaṉu tjukaṟurungku Moselu tjanala wangkanyangka Godalu wangkanytja. ");
INSERT INTO pjt_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","40","Ka chapter 25-ngka verse 31-nguṟu 40-kutu tjukurpa nyangatja ngaṟanyi, panya Godalu Mosela wangkangu lampa uwilitja apu gold-nguṟu palyantjaku Tiinta Miḻmiḻpa unngu irnyaṟa ngaṟanytjaku. Godalu purkaṟangku utiṟa tjakultjunu Mosela kuliṟa tjukaṟurungku palyantjaku. Ka aṟa nyanga paluṟu ngaṟanyi chapter 37-ta verse 17-nguṟu 24-kutu, panya lampa palunya tjukaṟurungku palyantja wati Pitjaliltu tjana. ");
INSERT INTO pjt_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","37","Ka chapter 26-ngka verse 1-nguṟu 37-kutu tjukurpa nyangatja ngaṟanyi, panya Godalu Mosela wangkangu Tiinta Miḻmiḻpa panyatja palyantjaku panya tjarpara Godala tjunguringkula palunya kulintjaku. Godalu purkaṟangku utiṟa tjakultjunangi Mosela munu wangkangu mantara waṟa tjuṯa palyantjaku tiinta unngu waṟaly-waṟalyngaṟanytjaku, munu tiinta katuwanungku ngampaḻtjunkupai kutjara kuḻu palyantjaku kutju unngutja, kutju katutja. Munu paluṟu utiṟa tjakultjunu yaaltjingaṟa tiintaku puṉu puḻka tjuṯa kuḻu palyantjaku. Munu paluṟu wangkangu tiinta unngu mantara waṟa nguṟurpa waṟaly-waṟalytjunkunytjaku ruuma kutjara ngaṟanytjaku. Munu Godalu wangkangu, “Ruuma pala tjaatja miḻmiḻpa ngaṟanyi aṉangu tjukurtjara tjuṯaku, palu ruuma nyara munkaritja miḻmiḻpa alatjiṯu Pakutja Kalkuntjitjaku ngura.” Ka aṟa nyanga paluṟu ngaṟanyi chapter 36-ngka verse 8-nguṟu 38-kutu, panya Pitjaliltu tjana nintipuka tjuṯangku Tiinta nyanga Miḻmiḻpa palyantja. ");
INSERT INTO pjt_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","8","Ka chapter 27-ngka verse 1-nguṟu 8-kutu tjukurpa nyangatja ngaṟanyi, panya Godalu Mosela wangkangu pitjilpa puḻka taipula puṟunypa palyantjaku pala palula katu kuka pungkula tiliwakaṟa Godanya ungkunytjikitjangku. Ka aṟa nyanga paluṟu ngaṟanyi chapter 38-ngka verse 1-nguṟu 7-kutu, wati panya Pitjaliltu tjana pitjilpa nyanga palunya tjukaṟurungku palyantja Godalu wangkanytjitja alatjiṯu. ");
INSERT INTO pjt_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","19","Ka chapter 27-ngka verse 9-nguṟu 19-kutu tjukurpa nyangatja ngaṟanyi, panya Godalu Mosela wangkangu piintji palyantjaku Tiinta Miḻmiḻṯa para-ngaṟala waṉantjaku. Paluṟu wangkangu yaaltjingaṟa puṉu tjuṯa palyantjaku munu ayana waṟa tjuṯa tjiilpanguṟu palyantjaku panya puṉu katu para-ngarira waṉantjaku munu piṟuku wangkangu mantara waṟa tjuṯa palyantjaku panya piintjingka waṟaly-waṟalyngaṟala waṉantjaku. Ka aṟa nyanga paluṟu ngaṟanyi chapter 38-ngka verse 9-nguṟu 20-kutu, panya wati Pitjaliltu tjana piintji nyanga palunya palyantja tiinta panya miḻmiḻṯa para-ngaṟala waṉantjaku. ");
INSERT INTO pjt_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","21","Ka chapter 27-ngka verse 20-nguṟu 21-kutu tjukurpa muṯumuṯu ngaṟanyi, panya Godalu Mosela wangkangu yaaltjingaṟa lampa panya gold-nguṟu palyantja munga waṟa tili winki kanyintjaku tiṯutjara munga kutjupa munga kutjupa. ");
INSERT INTO pjt_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","43","Ka chapter 28-ngka tjukurpa nyangatja ngaṟanyi, panya Godalu Mosela wangkangu mantara wiṟu mulapa palyantjaku Aarontu tjana palumpa katja tjuṯangku tjukurtjararingkula tjarpara kanyintjaku. Alatji palyantjaku Godalu Mosela wangkangu, mantara piṟanpa tiṟitja miṉatjara tjaḻpawanungku kanyilpai, munu kutjupa tiṟitja puluwana miṉa wiya muṉnguwanungku kanyilpai muṯumuṯu nguwanpa, munu kutjupa muṯumuṯu tjuntawanungku kanyilpai palyala, munu piḻpiritja palyala apu tjukutjuku 12-tjara walka wiṟutjara munu apu kutju kutjungka ini kutju kutju walkatjura Jacobaku katja tjuṯa ini 12 panya. Munu piḻpiritja nyanga palunya piḻpirta tanpaṟa waṟaly-waṟalytjura. Munu palu puṟunypaṯu mukaṯa katatja piṟanpa palyala munu ayana ringki-ringki gold-nguṟu palyantja mukaṯangka tjura ngalyangka kanyilpai. Munu ayana ringki pala palula walkatjura nyanga alatji, Miḻmiḻmankunytja Mayatja Godaku Palyantjaku. Munu pilta walka wiṟutjara kuḻu palyala kultu karpilpai. Munu mantara unngu kanyilpai kuḻu palyala paṉṯatja angatjunkunytjaku. Nyanganpa uwankara Godalu Mosela wangkanytja alatji palyantjaku Aarontu tjana tjukurtjararingkula tjarpara kanyintjaku, tiinta panya miḻmiḻṯa tjarpara Godaku palyantjikitjangku. Ka aṟa nyanga paluṟu ngaṟanyi chapter 39-ngka verse 1-nguṟu 31-kutu, panya wati Pitjaliltu tjana mantara nyanga palunya tjananya uwankara palyantja Aaronku tjanampa palumpa katja tjuṯaku kuḻu. Paluṟu tjana tjukaṟurungku palyaṉu Godalu wangkanytjitja alatjiṯu. Ka nyanga palulanguṟu nyura nyakuku chapter 29 panya ngaṟanyi nyiri nyangangka. Ka tjukurpa nyaa ngaṟanyi chapter nyangangka, panya Godalu Mosela wangkangu yaaltjingaṟa Aaronnga tjananya palumpa katja tjuṯa tjukurtjara tjunkunytjaku. Ka nyura chapter pala 29 nyakula waṉaṟa wiyaringkula palulanguṟu chapter maḻatja kutjara nampa 30 munu 31 kuḻu puṯu nyakuku panya nganaṉa Pitjanytjatjara walkatjunkunytja wiya kuwaripa. Palu nganaṉa tjukurpa nyanga palunya pulanya muṯumuṯuṟa aṟangka tjunu tjukutjuku tjukutjuku nyura nyakula kulintjaku tjukurpa nyaa puṟunypa ngaṟanyi chapter nyanga palula pulala 30-ngka munu 31-nta. ");
INSERT INTO pjt_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Godalu Mosela alatji wangkangu, “Nyanga alatji nyuntu Aaronnga munu palumpa katja tjuṯa miḻmiḻmara tjana tjukurtjara nyinara ngayuku palyantjaku. Ngaṉmanytju puluka nyiṯayira kuḻunypa munu tjiipi nyiṯayira kutjara kuḻu ngurkantaṟa mantjila pikatjara wiya, purtjutja wiya, wiṟuly-wiṟulypa wiṟu mulapa. ");
INSERT INTO pjt_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Munu mai wiita mantjiṟa rungkaṟa uḻu wiṟu mulapa palyala munu uḻu nyanga palulanguṟu mai nyuma wiṟu tjuṯa paula pilytja tjuṯa yiitjatjara wiya, munu kutjupa uwilangka tjunguṟa paula kaika tjuṯa, munu piṟuku kutjupa paula mai nyuma upa-upa tjuṯa munu mai upa palunya tjananya uwilangka nyiṯila. ");
INSERT INTO pjt_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Munu palulanguṟu mai nyanga palunya tjananya piti ukiṟinguṟu palyantjitjangka tjunkula kuka panya pulukangka munu tjiipi nyiṯayira kutjarangka kuḻu tjunguṟa ngalya-kati Tiinta Miḻmiḻpakutu. ");
INSERT INTO pjt_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","“Munu Aaronnga palumpa katja tjuṯa kuḻu ngalya-kati Tiinta Miḻmiḻpa tjaakutu, munu tjananya minangka paltjila. ");
INSERT INTO pjt_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Munu mantara panya wiṟu tjuṯa mantjiṟa Aaronnga tjarpatjura. Mantara panya piṟanpa tiṟitja waṟa puṟunytja miṉatjara-waraṟangka tjarpatjura, munu palulanguṟu tiṟitja kutjupa miṉa wiyangka muṉnguwanungku kanyilpaingka katu tjarpatjura. Munu palulanguṟu kaṟilitjangka katu tjarpatjura panya muṯumuṯu tjuntawanungku kanyilpaingka, munu piḻpiritja apu 12-tjara walka wiṟutjara piḻpirta waṟaly-waṟalytjura. Munu pilta walka wiṟutjarangka kultu karpila. ");
INSERT INTO pjt_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Munu mukaṯa piṟanpa katangka tanpaṟa ayana ringki-ringki gold-nguṟu palyantja mukaṯangka tjura. Ayana ringki pala palula panya walka nyanga alatji ngaṟanyi, Miḻmiḻmankunytja Mayatja Godaku Palyantjaku ");
INSERT INTO pjt_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Munu palulanguṟu uwila panya miḻmiḻmankupai palula katangka tjutila palunya miḻmiḻmankunytjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","“Munu palumpa katja tjuṯa katira tjata wiṟu tjuṯangka tjarpatjura. ");
INSERT INTO pjt_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Munu palula tjanala kuḻu puṯuru puṟunypa katangka tanpala. Munu palulanguṟu tjananya kultu kutju kutju piltangka karpila. Nyanga alatjingaṟa nyuntu Aaronnga tjananya palyala tjana tjukurtjararingkula ngayuku waṟka palyantjaku. Kaya Aarontu tjana palumpa katja tjuṯangku munu palumpa tjanampakunu maḻatja maḻatja tjuṯangku kuḻu tjukurtjara nyinara ngayuku palyalkatiku rawangku alatjiṯu. ");
INSERT INTO pjt_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Munu palulanguṟu puluka panya nyiṯayira kuḻunypa ngalya-kati Tiinta Miḻmiḻpakutu munu tiintangka kuranyu ngaṟatjura, ka uti Aarontu munu palumpa katja tjuṯangku kuḻu maṟa tjunama puluka panya palula katangka. ");
INSERT INTO pjt_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Ka palulanguṟu maṟa tjunkunyangka puluka panya palunya iluntanama ngayula miṟangka tiinta pala miḻmiḻṯa kuranyu. ");
INSERT INTO pjt_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Munu puluka palulanguṟu milkaḻi pitingka mantjiṟa kati pitjilpa panya kuka tiliwakalpailakutu munu maṟangku tairakaṟa tjura pitjilpa mulyangka, panya mulya kutjara kutjarangka yuṟuwilya puṟunypa ngaṟanyi, ka milkaḻingka yuṟuwilya palunya tjananya nyiṯila. Munu palulanguṟu pitjilpa palula tjaṟu milkaḻi pupatjuṟa uwankara wiyala. ");
INSERT INTO pjt_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Munu palulanguṟu kuka panya puluka tjuni aḻaṟa tjuninguṟu muturka mantjila munu alu, kapulitja kutjara kuḻu mantjila munu pitjilpa panya palula tjunkula tiliwakala kampara mulururinytjaku. ");
INSERT INTO pjt_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Palu puluka aṉangu winki miṟi tjuni kuḻu katira ngurangka paṯu uṟilta tilila kampara mulururinytjaku. Nyanga alatjingala ngayulu nyakula tjananya kura tjuṯa palyantjitjanguṟu kalypangku pungkuwiyangku wantinytjaku. ");
INSERT INTO pjt_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Munu palulanguṟu kuka tjiipi nyiṯayira kutju ngalya-kati, kaya uti Aarontu munu palumpa katja tjuṯangku kuḻu maṟa tjunama tjiipi panya palula katangka. ");
INSERT INTO pjt_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Ka palulanguṟu tjana maṟa tjunkunyangka tjiipi panya palunya iluntanama munu milkaḻi mantjiṟa pitjilpa panya kuka tiliwakalpainya kantilypa kampa kutjara kurpila munu piṟuku kampa kutjupa kutjara palu puṟunypaṯu kurpila. ");
INSERT INTO pjt_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Munu palulanguṟu tjiipi palunya kaṯaṟa muṯun-muṯunmara munu unngutja uwankara mantjiṟa paltjila munu tjunta kutjara kuḻu paltjiṟa muṯun-muṯunpa kutjupa tjuṯangka katuku tjura katangka tjungu. ");
INSERT INTO pjt_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Munu palulanguṟu uwankara tiliwakala pitjilpa panyangka. Nyanga alatjingaṟaṉi uwa ngayunya kulintjikitjangku, ka waṟungka kutjantjitjangku paṉṯi wiṟungku ngayunya pukuḻmananyi. ");
INSERT INTO pjt_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Munu palulanguṟu tjiipi panya nyiṯayira kutjupa ngalya-kati, kaya uti Aarontu munu palumpa katja tjuṯangku kuḻu palu puṟunytjuṯu maṟa tjunama tjiipi panya palula katangka. ");
INSERT INTO pjt_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Ka tjana maṟa kuka panya palula tjunkunyangka tjiipi palunya iluntanama munu milkaḻi mantjiṟa tjaraṟa Aaronta tjanala pina wakungka tjura, maṟa wakunguṟu maṟa mamangka tjura, munu tjina wakunguṟu tjina mamangka kuḻu tjura. Munu milkaḻi panya tjara kutjupa pitjilpa kuka tiliwakalpainya kantilypa kampa kutjara kurpila munu piṟuku kampa kutjupa kutjara palu puṟunypaṯu kurpila. ");
INSERT INTO pjt_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Munu palulanguṟu milkaḻi panya pitjilpangka ngarinytjitja tjara mantjila munu uwila miḻmiḻmankupai kuḻu mantjiṟa milkaḻi palula tjunguṟa Aaronnga kurpila palumpa mantara aṉangitja kuḻu, munu palu puṟunypaṯu kurpila palumpa katja tjuṯa munu palumpa tjanampa mantara kuḻu. Kaya nyara palulanguṟu Aaronnga tjana miḻmiḻariku palumpa tjanampa mantara kuḻu. ");
INSERT INTO pjt_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Munu palulanguṟu tjiipi kaṉpi kaṯaṟa tjura, kaṉpi wiputja kuḻu, munu muturka tjunitja, alu, kapulitja kutjara kuḻu mantjiṟa tjura munu tjunta angkaḻitja wakunguṟu kuḻu palyaṟa tjura. ");
INSERT INTO pjt_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Munu piti ukiṟinguṟu palyantjitjanguṟu mai panya nyuma maṉkurpa mantjila kutju yiitja wiyatja, kutjupa kaika uwilangka tjunguṟa pauntjitja, munu kutjupa nyuma upa-upa. Mai nyanganpa panya Godanya ungkunytja Tiinta Miḻmiḻṯa unngu taipulangka ngarinytjaku. ");
INSERT INTO pjt_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Munu mai nyanga maṉkurpa mantjiṟa kukangka panya tjungula. Munu palulanguṟu mai kuka kuḻu Aaronta munu palumpa katja tjuṯangka maṟangka tjura, kaya uti ngayula miṟangka maṟa uritjinganma ngayunya kulintjikitjangku, kaṉa nyakula pukuḻariku. ");
INSERT INTO pjt_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Ka palula maḻangka tjanalanguṟu mai mantjiṟa katira tjura pitjilpa panya palula kuka tjara kutjupangka tjungu kampara mulururinytjaku, kaṉa kampanyangka paṉṯiṟa pukuḻariku. Uwa, nyanga alatjiṉiya waṟungka palyaṟa ungama ngayunya kulintjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Munu kuka tjiipi palunya iltjanpa piḻpiritja maṟangku mantjiṟa ngayula miṟangka uritjingala ngayunya kulintjikitjangku. Ka palulanguṟu kuka nyanga piḻpiritja nyuntumpariku ngalkuntjaku.” Alatji Godalu Mosela wangkangu. Munu palulanguṟu piṟuku wangkangu, ");
INSERT INTO pjt_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Wati tjukurtjara miḻmiḻmankunytja aṟangka kuka tjiipi nyiṯayiranguṟu tjunta wakutja, piḻpiritja kuḻu mantjiṟa miḻmiḻmaṟa mauṉṯalpa tjura tjukurtjara tjuṯaku tjana ngalkuntjaku. ");
INSERT INTO pjt_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Munu Israelkunu tjuṯangka wangka nyanga alatjingaṟa kuka ngayulakutu katinytjatjanungku tjukurtjara tjuṯa ungkunytjaku kuka iltjanpa piḻpiritja, tjunta wakunguṟu kuḻu. Panya tjana alatjingaṟa ungkula ngayunya kuḻu waintaṟa unganyi, kaṉa pukuḻarinyi. ");
INSERT INTO pjt_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","30","“Ka ngula Aaronnga ilunyangka palumpa katja kutju palumpa mamaku aṟangka nyinaku munu mantara panya wiṟu tjuṯa Aarontu kanyintja paluṟu ngapartji tjukurtjara puḻkaringkula tjarpaku. Ka katja nyanga paluṟu Aaronku aṟangka nyinara uti mantara nyanga palunya tjananya tjiṟirpi 7 tjarpara kanyinma. Panya paluṟu tjukurtjara puḻka nyinara Tiinta Miḻmiḻṯa tjarpara ngayuku waṟka palyalku, ngayula miṟangka. Ka ngula Aaronku katja ilunyangka palu puṟunypaṯu katja palumpa tjukurtjara puḻkaringkuku mamaku aṟangka, ka piṟuku palu puṟunypa ngaṟakatiku maḻatja maḻatjaku. ");
INSERT INTO pjt_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Ka kuka panya tjiipi nyiṯayira palunya Aaronnga panya miḻmiḻmankunytjikitjangku mantjintja katira ngura miḻmiḻṯa mina waṟungka kutjala ngalkuntjaku. ");
INSERT INTO pjt_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Munu kuka nyanga palunya kutjaṟa Aaronnga tjananya uwa mai panya nyuma kuḻu kaikangka tjungu, tiinta miḻmiḻṯa tjaangka ngalkuntjaku. ");
INSERT INTO pjt_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Utiya Aarontu tjana kutju kuka nyanga palunya ngalkunma maingka panya tjungu, panya kuka nyanga paluṟu ilunytjitjanguṟu ngayulu tjananya kalypangku pungkuwiyangku wantingu tjana kura tjuṯa palyantjitjanguṟu, kaya miḻmiḻarira tjukurtjararingu ngayuku waṟka palyantjikitja. Pala palulanguṟuya uti tjukurtjara tjuṯangku kutju ngalkunma kuka nyanga miḻmiḻpa palunya mai panyangka tjungu. ");
INSERT INTO pjt_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Palu tjinguṟu kuka munu mai panya nyuma tjara ngalkuntja wiyangku wantinyangka mungawinkiringkula ngarinyangka nyakula tilinma kampara mulururinytjaku ngalkuntjaku wiya, panya kuka munu mai nyanga palunya tjananya ngaṉmanytju miḻmiḻmaṉu. ");
INSERT INTO pjt_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Uwa, Aaronnga palumpa katja tjuṯa kuḻu miḻmiḻmankunytjikitjangku alatjinganma panya uwankara ngayulu nyuntunya wangkanytjitjangka, munu tjiṉṯu 7 palyalkatima. ");
INSERT INTO pjt_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Munu tjiṉṯu kutjupa tjiṉṯu kutjupa puluka nyiṯayira kuḻunypa pungkula palyanma ngayulu nyakula tjananya kura tjuṯa palyantjitjanguṟu kalypangku pungkuwiyangku wantinytjaku. Alatji palyaṟan nyuntu pitjilpa panya kuka tiliwakalpainya kura wiya ngaṟanytjaku palyaṉi. Munu palulanguṟu uwilangka kurpila pitjilpa panya palunya miḻmiḻmankunytjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Munu nyanga palunya rawangku palyalkatima tjiṟirpi 7 pitjilpa nyara paluṟu miḻmiḻpa alatjiṯu ngaṟanytjaku. Ka tjinguṟu aṉangu kutjupangku pitjilpa palunya pampuṟampa nyara palulanguṟu paluṟu kuḻu miḻmiḻariku. ");
INSERT INTO pjt_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","39","“Tjiṉṯu kutjupa tjiṉṯu kutjupa tiṯutjarangku tjiipi kuḻunypa kutjara pitjilpakutu kati pungkula tjunkunytjikitjangku, tjiipi kutju mungawinkiku, munu kutjupa mungartjiku. ");
INSERT INTO pjt_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Tjiipi kuranyitjangka tjungula wiitanguṟu rungkaṟa uḻu wiṟu palyantja munu uwilangka waliwaliṟa pitjilpangka tjunkula tiliwakala. Munu waina kuḻu walpayaṯanguṟu pupatjura ngayunya ungkunytjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Munu mungartji tjiipi maḻatjangka palu puṟunypaṯu tjunguṟa pitjilpangka tjunkula tiliwakala. Kaṉa kampanyangka paṉṯi wiṟu paṉṯiṟa pukuḻariku. ");
INSERT INTO pjt_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","43","Uwa, nyura uti tjiṉṯu kutjupa tjiṉṯu kutjupa ngayula miṟangka tiṯutjarangku nyanga alatji palyalkatima Tiinta Miḻmiḻṯa kuranyu nyurampa walytjapiti maḻatja maḻatjangku kuḻu. Kaṉa nyara palula ngayulu nyurala Israelkunu tjuṯangka tjunguringkula wangkaku, munuṉa ngayulu pitalytji puḻkangku ngura nyara palunya irnyaṟa miḻmiḻmankuku. ");
INSERT INTO pjt_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Alatjiṉa ngayulu tiinta palunya munu pitjilpa kuḻu miḻmiḻmankuku, munuṉa Aaronnga palumpa katja tjuṯa kuḻu miḻmiḻmaṟa tjunkuku tjukurtjararingkula ngayuku waṟka palyantjaku. ");
INSERT INTO pjt_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Munuṉa ngayulu aṉangu Israelkunu tjuṯangka tjungu nyinaku tjanampa God. ");
INSERT INTO pjt_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Kaya tjana kulilku panya ngayuluṉa Mayatja God tjanampa panya ngayulu alatjiṯuṉa tjananya Itjipalanguṟu pakaltjingaṟa katingu palula tjanala tjungu nyinanytjikitjangku. Alatjiya tjana ngayunya kulilku, panya ngayuluṉa Mayatja God tjanampa.” Kuwari nyuntu chapter 29 nyakunytjatjanungku chapter 30 munu 31 puṯu nyanganyi panya chapter nyanga palunya pulanya nganaṉa Pitjantjatjara walkatjunkunytja wiyaṯu kuwaripa. Palu chapter 30-ngka munu 31-ta tjukurpa nyaa ngaṟanyi, panya Godalu Mosela puḻi ini Tjaniyala katu tjukurpa kutjupa kutjupa tjuṯa wangkanytja. Paluṟu panya Mosela wangkangi yaaltjingaṟa tjukaṟurungku tiinta panya miḻmiḻpa palyantjaku, tiinta unngu nyinanytja kutjupa kutjupa tjuṯa kuḻu palyantjaku. Palu nganaṉa tjukurpa nyanga palunya pulanya, chapter 30 munu 31, muṯumuṯuṟa panya palula aṟangka tjunu tjukutjuku tjukutjuku nyuntu nyakula kulintjaku tjukurpa nyaa puṟunypa ngaṟanyi chapter nyanga palula pulala. ");
INSERT INTO pjt_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","10","Chapter 30-ngka verse 1-nguṟu 10-kutu tjukurpa nyangatja ngaṟanyi, panya Godalu Mosela wangkangu taipula tjukutjuku wiṟu paṉṯipaiku palyantjaku, pala palula katu kutjupa kutjupa paṉṯi wiṟutjara kampanytjaku. Munu paluṟu wangkangu, “Uti Aarontu yiya kutjupa yiya kutjupa tiṯutjarangku taipula nyanga tjukutjuku milkaḻingka miḻmiḻmanama, panya taipula nyanga paluṟu ngayuku, miḻmiḻpa mulapa.” Ka aṟa nyanga paluṟu ngaṟanyi chapter 37 verse 25-nguṟu 28-kutu, panya taipula tjukutjuku nyanga palunya wati Pitjaliltu tjana palyantja. Tjana tjukaṟurungku palyaṉu Godalu wangkanyangka. ");
INSERT INTO pjt_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","16","Ka chapter 30-ngka verse 11-nguṟu 16-kutu tjukurpa nyangatja ngaṟanyi, panya Godalu Mosela alatji wangkangu, “Nyuntu aṉangu Israelkunu tjuṯa kantamilannyangka uti wati tjuṯangku ngayunya kulintjikitjangku mani tjukutjuku nyuntunya ungama. Panya tjana alatji tjukaṟurungku ungkunyangkaṉa tjananya aṯunytju kanyilku kurangka-tawara nyuntu tjananya kantamilannyangka. Ka mani pala palula tjukurtjara tjuṯangku Tiinta Miḻmiḻpa ngayuku wiṟuṟa kanyilku.” Alatji Godalu Mosela tjakultjunu tjanala ngapartji wangkanytjaku Israelkunu tjuṯangka. ");
INSERT INTO pjt_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","21","Ka chapter 30-ngka verse 17-nguṟu 21-kutu tjukurpa nyangatja ngaṟanyi, panya Godalu Mosela wangkangu piti paltjilpai puḻka palyantjaku ayana ini puṟantjinguṟu. Munu Godalu wangkangu piti maṉa kuḻu palyantjaku pala palula katu piti puḻka nyinatjunkunytjaku. Munu paluṟu wangkangu, “Utiya tjukurtjara tjuṯangku ilunytjaku-tawara piti pala palula manyirka tjina kuḻu minangka paltjinma Tiinta Miḻmiḻṯa tjarpara waṟkarinytjikitjangku munu pitjilpangka kuḻu waṟkarinytjikitjangku.” Ka aṟa nyanga paluṟu ngaṟanyi chapter 38-ngka verse 8-ngka, panya wati Pitjaliltu tjana piti nyanga puḻka maṉa kuḻu ayananguṟu palyantja. ");
INSERT INTO pjt_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","33","Ka chapter 30-ngka verse 22-nguṟu 33-kutu tjukurpa nyangatja ngaṟanyi, panya Godalu Mosela wangkangu yaaltjingaṟa uwila miḻmiḻpa palyantjaku paṉṯi wiṟutjarangka tjunguṟa. Munu paluṟu Mosela utiṟa wangkangu yaaltjingaṟa uwila pala palula kurpiṟa miḻmiḻmankunytjaku Tiinta Miḻmiḻpa, munu tiinta unngu nyinanytja tjuṯa kuḻu, munu Aaronnga palumpa katja tjuṯa kuḻu kurpiṟa miḻmiḻmankunytjaku Godalu Mosela wangkangu. Munu paluṟu wangkangu, “Uwila pala paluṟu miḻmiḻpa alatjiṯu ngayulu wangkanyangka kutju kurpintjaku.” ");
INSERT INTO pjt_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","38","Ka chapter 30-ngka verse 34-nguṟu 38-kutu tjukurpa nyangatja ngaṟanyi, panya Godalu Mosela wangkangu yaaltjingaṟa wiṟu paṉṯipai palyantjaku Tiinta Miḻmiḻṯa ngarira paṉṯinytjaku munu kampara kuḻu paṉṯinytjaku. Paluṟu wangkangu, “Wiṟu pala paṉṯipai miḻmiḻpa mulapa ngayulu wangkanyangka kutju palyantjaku.” Ka aṟa nyanga paluṟu ngaṟanyi chapter 37-ta verse 29-ngka, panya wati Pitjaliltu tjana uwila panya miḻmiḻpa munu wiṟu paṉṯipai miḻmiḻpa kuḻu tjukaṟurungku palyantja, Godalu wangkanyangka. ");
INSERT INTO pjt_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","11","Ka chapter 31-ta verse 1-nguṟu 11-kutu tjukurpa nyangatja ngaṟanyi, panya Godalu Mosela wangkangu, “Ngayuluṉa ngurkantanu wati ini Uṟiku katja ini Pitjalilnga. Munuṉa palula tjarpatjunu ngayuku kurunpa ka palunya nintinu waṟka uwankara nintipukangku tjukaṟurungku alatjiṯu palyantjaku ngayulu wangkanytjitja uwankara. Munuṉa palu puṟunypaṯu kutjupa ngurkantanu wati ini Iitjamakaku katja ini Awu-liyapanya nyanga paluṟu pula tjungu waṟkarinytjaku. Munuṉa wati palyalpai kutjupa tjuṯa kuḻu ngurkantanu palunya pulanya alpamilantjaku, munuṉa palula tjanala nintinu Tiinta Miḻmiḻpa tjukaṟurungku palyantjaku tiinta unngu nyinanytja tjuṯa kuḻu, munu mantara wiṟu tjuṯa kuḻu palyantjaku wati tjukurtjara tjuṯaku. Ngayulu palunya tjananya uwankara puḻkaṟa nintipukaṉu witulyangku palyantjaku uwankara ngayulu wangkanytja.” Ka aṟa nyanga paluṟu ngaṟanyi chapter 35-ngka verse 30-nguṟu munu chapter 36-kutu. Ka nyuntu tjukurpa nyanga palunya nguriṟa nyawa chapter 35-ngka verse 30-nguṟu wati panya nintipuka tjuṯa kulintjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","18","Ka chapter 31-ta verse 12-nguṟu 18-kutu tjukurpa nyangatja ngaṟanyi, panya Godalu Mosela wangkangu Tjiṟirpi panya Miḻmiḻṯa yaaltji-yaaltjingku kulilkatira tjukaṟuru nyinanytjaku. Ka aṟa nyanga paluṟu ngaṟanyi chapter 35-ngka verse 1-nguṟu 4-kutu, Moselu tjanala ngapartji tjakultjunkunytja Israelkunu tjuṯangka. Ka nyuntu nguriṟa nyawa chapter 35-ngka verse 1-nguṟu, panya Moselu Israelkunu tjuṯangka ngapartji tjakultjunkunytja. Tjukurpa nyanga palunya tjananya uwankara Godalu Mosela wangkara tjakultjunu puḻi panya murpu Tjaniyala. Munu wangkara wiyaringkula Godalu puḻi tjiwa kutjarangka walkatjunu tjukurpa puḻka 10 munu Mosenya ungu. ");
INSERT INTO pjt_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Kaya aṉangu Israelkunu tjuṯangku Mosenya puḻinguṟu ukalingkunytjaku puṯu nyakula nyakula tjunguringkula Aaronta wangkangu, “Ai! Pakaṟa god nganampa palyala nganaṉanya katiṟinkunytjaku. Panya nganaṉa puṯu kulini, yaaltjiringu Mosenya? Nyara paluṟu panyalanya Itjipalanguṟu pakaltjingaṟa katingu, munu kuwari yaaltjiringu?” ");
INSERT INTO pjt_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Ka palulanguṟu Aarontu tjanala wangkangu, “Nyurampa kuringku katjangku uṉṯaltu ringi apu gold-nguṟu palyantja tjuṯa pinangka kanyinnyangka araltjaṟa ngayulakutu ngalya-kati!” ");
INSERT INTO pjt_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Kaya aṉangu uwankarangku paluṟu tjana pinangka kanyintja uwankara araltjaṟa mulapaṯu palulakutu katingu. ");
INSERT INTO pjt_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Ka Aarontu mantjiṟa gold panya palunya tjananya pitingka tjunu munu palulanguṟu waṟungka kutjaṉu kampara uṟuringkunytjaku. Ka uṟuringkunyangka mantjiṟa piti kutjupangka tjutiṟa puluka nyiṯayira kuḻunypa puṟunypa palyaṉu, gold-nguṟu panya. Kaya aṉangu tjuṯangku nyakula tjananku Israelngamaṟa wangkangu, “Nyangatja nganampa god, panya nganaṉanya nyanga paluṟu Itjipalanguṟu pakaltjingaṟa ngalya-katingu.” ");
INSERT INTO pjt_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Ka palulanguṟu Aarontu pitjilpa palyaṉu puluka panya palula kuranyu munu tjanala wangkangu, “Mungawinki inma puḻka ngaṟanyi nganaṉa Mayatja Godanya waḻkuntjaku.” ");
INSERT INTO pjt_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Kaya mungawinki mulapa kuka tjananku katingu pungkula pitjilta katu tiliwakaṟa Godanya ungkunytjikitjangku munuya kuka kutjupatjara tjunguringkula ngalkuntjikitjangku katingiṯu. Munuya palulanguṟu pungkula pauṟa wiyaringkula nyinakatira mai kuka puḻka ngalkula tjikiningi, munuya tjikiṟa ngalypa-ngalyparingkula minyma kutjupa kutjupa pampuningi tjana pukuḻarinytjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Ka palulanguṟu Godalu Mosela puḻi katu nyinanyangka wangkangu, “Wala puḻka ukaliwa! Nyuntumpa panya aṉangu tjuṯaya nyuntu panya Itjipalanguṟu katinytja tjuṯa kuraringu munuya ngayuku watarkuringu. ");
INSERT INTO pjt_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Paluṟu tjana mapalku kampa kutjuparingu munuya ngayulu wangkanytja uwankara wantingu. Munuya puluka ngalypa-ngalypa gold-nguṟu palyaṟa tultjungaṟakatira waḻkuṟa mirawaṉinyi puluka palunya. Munuya kuka katira pitjilta katu pungkula tiliwakaṉi puluka palunya ungkula waḻkuntjikitjangku. Munuya alatji wangkanyi, ‘Nyangatja nganampa God! Nyanga paluṟu panyalanya Itjipalanguṟu pakaltjingaṟa ngalya-katingu.’ ");
INSERT INTO pjt_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Ka ngayulu nyanga palumpa tjanampa ninti, panya tjana rawa ngayula tungunpungkupai. ");
INSERT INTO pjt_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Kaṉi markulwiyangku wantir'iyala kaṉa puḻkaṟa mirpaṉarira tjananya uwankara iluntara wiyalku. Munuṉa nyuntulanguṟu kutju aṉangu tjuṯa mulararinytjaku palyalku.” Alatji Godalu Mosela wangkangu. ");
INSERT INTO pjt_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Palu Moselu Mayatja Godanya puḻkaṟa wangkara markuningi, “Mayatja! Nyaanguṟun tjanampa puḻkaṟa mirpaṉarinyi panya nyuntu palunya tjananya Itjipalanguṟu pakaltjingaṟa ngalya-katingu witulya puḻkangku? ");
INSERT INTO pjt_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Ka nyuntu tjananya pungkula wiyannyangka tjinguṟu Itjipanya nguraṟa tjuṯangkuya alatji nyuntunya wangkaku, ‘Ai! God panya tjanampangku kunyu tjananya iluntankunytjikitjangku ngura nyanganguṟu pakaltjingaṟa ma-katingu. Paluṟu tjananya ngura puḻitjarakutu pungkunytjikitjangku katingu tjananya uwankara wiyantjikitjangku.’ Alatjiya tjinguṟu nyuntunya anaṟa wangkaku. Ka nyara palula-tawara nyuntu uti Israelkunu tjuṯa iluntankuwiyangku wantima, munu tjanampa mirpaṉariwiya kalyparingama. ");
INSERT INTO pjt_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Panyatja kulila, panya nyuntunya waṉalpai maṉkurpa, Aipuṟamanya, Isaacanya, Jacobanya tjananya. Panya nyuntu tjananyan kalkuṉu palula tjanalanguṟu aṉangu tjuṯaringkula mungilyi mulararinytjaku, kililpi tjuṯa puṟunypa. Munu panyan kalkuṉu tjananya manta panya Kainannga tjanampa walytjapiti ungkunytjikitjangku tjanampa tiṯutjara ngaṟanytjaku.” Alatji Moselu Godala purkaṟangku wangkara palunya kalypaningi Israelkunu tjuṯa iluntankuwiyangku wantinytjaku. ");
INSERT INTO pjt_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Ka Mayatja Godalu nyangatja kuliṟa kampa kutjuparingu munu palumpa aṉangu tjuṯa uwankara wiyantjikitjangku kulintjatjanungku wantingu. ");
INSERT INTO pjt_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","16","Ka Mosenya maḻaku ukalingu puḻi Tjaniyalanguṟu puḻi panya tjiwa kutjaritjatjara, panya tjiwa pala palula pulala kampa kutjarangka Godalu walytjangku tjukurpa puḻka walkatjuṟa wantingu. ");
INSERT INTO pjt_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Ka Moseku maḻpangku Tjatjuwalu aṉangu tjuṯa mirara waṉinyangka kuliṟa palumpa mayatjangka Mosela wangkangu, “Ngurangka nyara pikaringanyi puṟunypa.” ");
INSERT INTO pjt_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Ka Moselu wangkangu, “Wiya mira nyaratja pikaringkunytja wiya. Inma puṟunypaya inkanyi.” ");
INSERT INTO pjt_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Munu Moselu ngalya-ukalingkula ilaringkula nyangu puluka panya ngalypa-ngalypa munu aṉangu tjuṯa kuḻu pukuḻarira waṟarakatinyangka, munu paluṟu puḻkaṟa mulapa mirpaṉaringu. Munu tjiwa panya paluṟu katinytja kutjara aṉṯa-waṉira kaṯantanu puḻi paṉṯangka. ");
INSERT INTO pjt_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Munu paluṟu puluka panya ngalypa-ngalypa tjana palyantja mantjiṟa waṟungka tjarpatjuṟa uṟuṉu, munu palulanguṟu wariringkula apuringkunyangka tjiwangka rungkaṟa uḻupungu, munu palulanguṟu kapingka tjunguṟa Israelkunu tjuṯa wituwituṉu tjikintjaku mina panya palunya. ");
INSERT INTO pjt_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Munu palulanguṟu Moselu Aaronta wangkangu, “Aṉangu nyanga tjuṯangkuntaya kuliṟa nyuntunya nyaa wangkangu, kan tjanampa kuliṟa mulamularingu munun tjananya kura nyanga puḻka palyannyangka paintja wiyangku wantingu?” ");
INSERT INTO pjt_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Ka Aarontu wangkangu, “Wanyu ngayuku mirpaṉarinytja wiyangku wantima. Nyuntun ninti aṉangu nyanga palumpa tjanampa, panya tjana kura tjuṯa palyantjikitja rawa mukuringkupai. ");
INSERT INTO pjt_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Tjana alatji ngayula wangkangu, ‘Ai! Pakaṟa god nganampa palyanma nganaṉanya katiṟinkunytjaku. Panya nganaṉa puṯu kulini, yaaltjiringu Mosenya? Nyara paluṟu panyalanya Itjipalanguṟu pakaltjingaṟa katingu, munu paluṟu kuwari yaaltjiringu?’ Alatjiṉiya wangkangi. ");
INSERT INTO pjt_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Kaṉa tjananya wangkangu ringi tjuṯa pinangka kanyintja kutjupa kutjupa tjuṯa kuḻu gold-nguṟu palyantja uwankara ngalya-katinytjaku. Kaya paluṟu tjana kanyintjatjanungku mulapaṯu ngayunya araltjaṟa ungu, kaṉa gold palunya tjananya tjunguṟa waṟungka waṉingu, ka puluka puṟunyaringu.” ");
INSERT INTO pjt_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Ka Moselu kulinu Aarontu Israelkunu tjuṯa puṯu markunnyangka, panya Aarontu tjananya puṯu paiṟa wantingu, kaya tjana puḻkaṟa ma-kuraringu aṉangu ngura kutjupitja tjuṯangku nyakula ikaringkunytjaku tjanampa. ");
INSERT INTO pjt_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Munu paluṟu ankula ngurangka itinguṟu puḻkaṟa mirara wangkangu, “Aṉangu Godaku mukuringkula ngayulakutu ngalya-pitja.” Kaya Levikunu tjuṯa pitjala kapuṯuringu palula. ");
INSERT INTO pjt_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Ka tjanala Moselu wangkangu, “God panya Israelkunu tjuṯaku Mayatjangku nyuranya Levikunu tjuṯa wangkanyi tjuḻa waṟa mantjiṟa ngurangka para-iluntankunytjaku nyurampa kuṯa maḻanypa tjuṯa, maḻpa tjuṯa munu nyurala itingka nyinanytja tjuṯa kuḻu.” ");
INSERT INTO pjt_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Kaya mulapaṯu Levikunu tjuṯangku wangka kutju kuliṟa ankula para-iluntanangi, kaya tjiṉṯu pala palula aṉangu tjuṯa mulapa ilungu 3,000. ");
INSERT INTO pjt_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Ka Moselu Levikunu tjuṯangka wangkangu, “Kuwari nyanga nyura Mayatja Godala wangaṉarangku kulinu munu nyanga nyura nyurampa katja, kuṯa, maḻanypa tjuṯa, walytjatja tjuṯa iluntanu. Ka nyanga palulanguṟu Godalu nyuranya pukuḻmanu palula wangaṉarangku kulinnyangka nyura palumpa waṟka miḻmiḻpa palyantjaku.” ");
INSERT INTO pjt_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Ka tjiṉṯungka Moselu Israelkunu tjuṯangka wangkangu, “Panya nyura kura puḻka mulapa palyaṉu puluka ngalypa-ngalypa palyaṟa waḻkuṟa. Palu kuwari nyangaṉa piṟuku puḻi katu tatiṟa Mayatja Godala tjapilku nyurampa kalyparingkunytjaku nyura kura nyanga palunya palyantjitjanguṟu.” ");
INSERT INTO pjt_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Ka palulanguṟu Moselu Mayatja Godalakutu maḻaku ankula wangkangu, “Aṉangu nyangantuya kura puḻka mulapa palyaṉu. Panya tjanaya gold-nguṟu god ngalypa-ngalypa palyaṟa palunya waḻkuningi. ");
INSERT INTO pjt_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Wanyu tjanampa ngaḻṯuringama kura panya palyantjitjanguṟu munu tjananya kalypangku wantima pungkuwiyangku. Palu wiyangka ngayuku ini nyiringuṟu panya kurala, nyiri panya nyuntu aṉangu nyuntumpa tjuṯa ini walkatjunkunytjatjanungku.” ");
INSERT INTO pjt_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Ka Mayatja Godalu wangkangu, “Wiya, panya tjana ngayula tungunpungkunytja tjuṯa kutjuṉa nyiri ngayukunguṟu ini kuralku. ");
INSERT INTO pjt_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Ala! Ara munu tjananya aṉangu tjuṯa ma-kati ngura panya ngayulu nyuntula ngaṉmanytju wangkanytjitjakutu. Palu kulinma panya ngayuku angeltunta nyuntunya katiṟinkuku. Palu ngulaṉa tjananya kura palyantjitjanguṟu pikantankuku tjiṟirpi ngayulu kalkuntjitjangka.” ");
INSERT INTO pjt_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Munu palulanguṟu Mayatja Godalu pika puḻka tjananya ungu, panya tjanaya Aaronnga wituwituṉu tjanampa puluka gold-nguṟu palyantjaku. ");
INSERT INTO pjt_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Ka Mayatja Godalu Mosela wangkangu, “Nyuntu panya Israelkunu tjuṯa Itjipalanguṟu pakaltjingaṟa ngalya-katingu. Ka kuwari nyuntu ngura nyangatja wantikatira tjananya ma-kati manta panya ngayulu kalkuntjalakutu. Panya ngayulu Aipuṟamanya, Isaacanya, Jacobanya tjananya manta panya palunya ungkunytjikitjangku kalkuṉu tjanampa walytjapiti maḻatja maḻatja kuḻu. ");
INSERT INTO pjt_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Ngayulu angelpa iyalku nyuranya katiṟinkunytjaku. Munuṉa manta nyara palulanguṟu aṉangu nguratja tjuṯa pakaltjingaṟa ma-paiṟa waṉaṟa iyalku, panya wati Kainankunu tjuṯa, Amurkunu tjuṯa, Iitakunu tjuṯa, Piṟitjikunu tjuṯa, Ipakunu tjuṯa, Tjaipukunu tjuṯa kuḻuṉa uwankara paiṟa iyalku. ");
INSERT INTO pjt_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Ka manta nyara palula nyura mai puḻka pakaltjingalku munu nyura kuka kutjupa kutjupa tjuṯa mulapa kanyilku, panya manta nyara paluṟu wiṟu mulapa. Palu ngayulu nyurala tjungu ankunytja wiya panya nyura rawa ngayula tungunpungkupai. Tjinguṟuṉa nyurala tjungu ankula nyuranya nguṟurpa uwankara iluntaṟa wiyalku.” ");
INSERT INTO pjt_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Kaya nyanga palulanguṟu Godalu wangkanyangka kuliṟa aṉangu uwankara puḻkaṟa tjituṟu-tjituṟuringu munuya ulara waṉingi. Munuya palumpa tjanampa liritja, manyirkangka kanyintja munu kutjupa kutjupa uwankara araltjaṟa tjunangi tjituṟu-tjituṟu nyinara. ");
INSERT INTO pjt_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Panya Godalu Mosela ngaṉmanytju wangkangu nyanga alatji, “Aṉangu nyanga paluṟu tjana ngayula rawa tungunpungkupai. Kaṉa tjinguṟu tjanala tjungu tjukutjuku ankula tjananya uwankara mapalkungku alatjiṯu iluntara wiyalku ngayula tungunpungkunyangka. Ka nyuntu tjananya wangka liritja, manyirkitja, pinatja, kutjupa kutjupa tjuṯa tjana kanyintjatjanungku araltjankunytjaku. Kaṉa palulanguṟulta kulilku, ‘Yaaltjingalkuṉa aṉangu nyanganpa?’” ");
INSERT INTO pjt_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Kaya ngura nyara Tjaniyala Israelkunu tjuṯangku mulapaṯu uwankara araltjaṟa tjunu, munuya piṟuku tanpantja wiyangku wantingu. ");
INSERT INTO pjt_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Ka Israelkunu tjuṯangku ngura kutjupangka wirkaṟa ngura tjunkunyangka Moselu tiinta katira wiltjalpai palumpa tjanampa ngurangka paṯu nguwanpa. Munu paluṟu tiinta nyara palunya ininu “Godala Tjunguringkula Kulilpai”. Ka kutjupa Godala tjapintjikitja mukuringkula tiinta nyara palulakutu ankupai Godalu wangkanyangka kulintjikitja. ");
INSERT INTO pjt_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Ka Mosenya tiinta nyara palulakutu ankunyangka aṉangu tjuṯa tiinta tjanampangka tjaangka paṯaṟa ngaṟala nyakupai Mosenya tiinta nyara palula ankula tjarpanyangka. ");
INSERT INTO pjt_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Ka Mosenya tiintangka tjarpanyangka maḻangka ngangkaḻi panya waṟa tiintakutu ukalingkula tiinta tjaangka ngaṟapai, ka Mayatja Godalu Mosela wangkapai ngangkaḻinguṟu. ");
INSERT INTO pjt_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Kaya Israelkunu tjuṯangku ngangkaḻi waṟa tiinta tjaangka ngaṟanyangka nyakula Godanya waḻkulpai palumpa tjanampa tiintanguṟu ngaṟala. ");
INSERT INTO pjt_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Ka Mayatja Godalu Mosenya ilangku wangkapai panya wati maḻpaṟara wangkapai, palu puṟunypa. Ka palulanguṟu Mosenya maḻaku ankupai ngurakutu. Palu wati panya Tjatjuwanya Moseku panya maḻpa kutju maḻaringkula nyinapai tiinta nyara palula. Wati paluṟu panya yangupala wati ini Nanku katja. ");
INSERT INTO pjt_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Ka Moselu Mayatja Godala wangkangu, “Mulapa nyuntu ngayunya wangkangu Israelkunu tjuṯa manta nyara palulakutu katinytjaku. Palu wangkanytja wiyaṯuṉin ngananya ngayula tjungu iyantjikitjangku. Nyuntu panyaṉin wangkangu nyuntu ngayuku ninti mulapa, munutjun ngayuku pukuḻarinyi. ");
INSERT INTO pjt_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Palu ngayuku pukuḻarirampaṉi nintinma nyuntumpa kulintja tjuṯa, kaṉa nyuntumpa nintiriwa munuṉantawi rawangku nyuntunya waṉanma nyuntu ngayuku pukuḻarinytjaku. Panyatja kulinma, panya aṉangu nyanga Israelkunu tjuṯan nyuntu ngurkantanu nyuntumparinytjaku.” Alatji Moselu wangkangi. ");
INSERT INTO pjt_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Ka Mayatja Godalu wangkangu, “Wiya, palya ngayulu nyurala tjungu ankula nyuranya rapalku.” ");
INSERT INTO pjt_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Ka Moselu wangkangu, “Nyuntu nganaṉala ankuwiyangku wantirampa nganaṉanya nyanganguṟu iyalwiyangku wantima. ");
INSERT INTO pjt_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Palu nyuntu nganaṉala tjungu ankunyangkampa aṉangu ngura kutjupitjangku nyakula kulilku, ‘Mulapa Mayatja Godanya Moseku tjanampa pukuḻarinyi.’ Kala nyuntumpa aṉangu tjuṯa mauṉṯalpa nyinaku kutjupa nguwanpa aṉangu kutjupa tjuṯa puṟunypa wiya.” ");
INSERT INTO pjt_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Ka Mayatja Godalu Mosela wangkangu, “Uwa palya, ngayulu nyuntu wangkanytjitja palyalku, panya ngayulu nyuntumpa ninti mulapa munuṉa nyuntumpa pukuḻarinyi.” ");
INSERT INTO pjt_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Ka palulanguṟu Moselu tjapinu, “Wanyuṉi nyuntumpa pitalytji puḻka nintinma.” ");
INSERT INTO pjt_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Ka Mayatjalu wangkangu, “Uwa palya! Ngayuluṉa Mayatja Godanya, munuṉa ngayulu mukuringkula aṉangu kutjupa ngaḻṯunytjungku ngurkantankupai palunya mukulyangku kanyintjikitjangku. Kuwariṉa ngayulu pitalytji puḻka mulapa nyuntula itiwanu ankuku, munuṉatju nyuntu kulintjaku ini miḻmiḻpa wangkaku. ");
INSERT INTO pjt_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Palu ngayulu yunpa nyuntula utiringkunytja wiya, panya aṉangungku ngayuku yunpa nyakulampa iluku. ");
INSERT INTO pjt_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Palu nyangatja ngura ngayula itingka ngaṟanyi nyuntu waḻungka tatiṟa ngaṟanytjaku. ");
INSERT INTO pjt_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Ka ngayulu pitalytji puḻkatjara nyuntula itiwanu ankula nyuntunya waḻu tjilpirpangka tjarpatjunkuku munuṉa maṟangku nyuntunya angatjunkuku. ");
INSERT INTO pjt_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Munuṉa nyuntula itiwanu ankula maṟangku angatjunkunytjatjanungku aḻalku, kaṉin palulanguṟulta tjaṉa kutju miṟalku, palu puṯun nyakuku ngayuku yunpa.” ");
INSERT INTO pjt_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Ka Mayatja Godalu Mosela wangkangu, “Puḻi kutjara mantjila piṟuku munu tjitjulangka palyala tjiwa kutjara panya ngaṉmanyitja puṟunypa, kaṉa tjiwa pala palula pulala walkatjunkuku tjukurpa puḻka panya ngaṉmanytjuṉa tjiwa kutjupa kutjarangka walkatjunu kan kaṯantanu. ");
INSERT INTO pjt_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Ka mungawinki pakaṟampa pitjala piṟuku tatila puḻi pala Tjaniyala, munu nyara palula katu ngayula tjunguriwa. ");
INSERT INTO pjt_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Ka wati kutjupa uti nyuntula tjungu pitjanytja wiya. Palu nyuntu kutju uti ngayula wirkanama. Munu aṉangu uwankara paila puḻi nyangawanu para-ngaṟanytjaku-tawara. Munu tjananya wangka tjiipi, nanikuta, puluka kuḻu puḻi nyanga paṉṯawanungku ukiṟiku para-katiṟiṟa kanyilwiyangku wantinytjaku.” ");
INSERT INTO pjt_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Ka palulanguṟu Moselu palyaṉu tjiwa kutjara panya ngaṉmanyitja puṟunypa, munu mungawinki mulapa piṟuku tatinu puḻi panya palulaṯu tjiwa panya kutjaratjara Godalu wangkanytjitjangka. ");
INSERT INTO pjt_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Ka Mayatja Godanya ngangkaḻingka unngu ngalya-ukalingkula palula tjunguringkula ngaṟangu puḻi panya katu, mununku ini wangkangu, “Ngayulu panyaṉa, Mayatjanya panya.” ");
INSERT INTO pjt_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Munu Mayatjanya palula kuranyu itiwanu anu munu wangka katungku mirara wangkangu nyanga alatji, “Ngayuluṉa Mayatja Godanya panya ngaḻṯunytju puḻkanya, munuṉa mapalku mirpaṉaripai wiya, palu ngayulu mukulya tiṯutjara pukuḻtju alatjiṯu nyinapai, munuṉa kalkuntjatjanungku tjukaṟurungku palyalpai. ");
INSERT INTO pjt_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Munuṉa kalkuntjatjanungku watarkuriwiyangku rawa mulatu mukulyangku kulilpai aṉangu tjuṯa mulapa. Munuṉa aṉangu ngayula tungunpungkula kura pampunnyangka tjanampa kuraringkunytja wiya kalypangku pungkunytja wiyangku wantipai. Palu aṉangu kutjupangku ngayunya wantira kura rawangku palyannyangkaṉa palulanguṟu palunya pikatjaralku, munuṉa mamaku kuranguṟu pikatjaralku palumpa tjitji tjuṯa, munu palumpa pakaḻi puḻiri tjuṯa, munu palumpa pakaḻitja puḻiritja tjuṯa kuḻu, aṉangu panya ngaṉmanyitjaku kuranguṟu.” Alatji Godalu Mosela wangkangu. ");
INSERT INTO pjt_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","9","Ka Moselu mapalku tultjungaṟakatira ngalyangku manta pampuṟa palunya waḻkuṉu wangkara, “Mayatja, nyuntu ngayuku pukuḻarirampa wanyu nganaṉanya katiṟinama. Aṉangu nyanganpa panyaya rawa nyuntula tungunpungkupai, palu wanyulampa ngaḻṯuringama munulanya kalypangku pungkuwiyangku wantima nganaṉa kura palyantjitjanguṟu, munulanya nyuntumparinytjaku mulapa palyala.” ");
INSERT INTO pjt_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Ka Mayatja Godalu Mosela wangkangu, “Kuwariṉa aṉangu Israelkunu tjuṯa wangkara kalkuṉi. Ngayulu tjanala miṟangka kutjupa kutjupa puḻka mulapa palyalku tjana ngaṉmanytju nyakunytja wiyatja ngurpatja mulapa kutjupangku palyantjitja puṟunypa wiya. Ka aṉangu ititja tjuṯangku ngayulu nyurala kutjupa kutjupa puḻka mulapa palyannyangka nyakula urulyaraṟa puḻkaṟa nguḻu-nguḻuringkuku. ");
INSERT INTO pjt_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Palu ngayulu nyurala kuwari wangkanyangkampaya wangaṉarangku kulinma. Ka nyura manta nyara palulakutu ankunyangkaṉa aṉangu nguratja tjuṯa-waraṟa pakaltjingaṟa ma-paiṟa waṉaṟa iyalku, panya wati Amurkunu tjuṯa, Kainankunu tjuṯa, Iitakunu tjuṯa, Piṟitjikunu tjuṯa, Ipakunu tjuṯa, munu Tjaipukunu tjuṯa. ");
INSERT INTO pjt_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Palu kulilaṉiya! Nyura manta nyara palula wirkaṟa aṉangu nguratja tjuṯangka wangkara kalypantaṟa purkaṟangku kalkuntja wiyangku wantima alatjiṯu nyuranya kurakutu katinytjaku-tawara. ");
INSERT INTO pjt_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Palu tjanampa pitjilpa tjuṯaya piḻuntaṟa wiyala, munu puḻi tjana muṟutjunkula miḻmiḻmankunytja tjuṯa kuḻu kaṯantaṟa wiyala, munuya tjanampa god ngalypa-ngalypa ini Atjuṟaku puṉu miḻmiḻpa tjuṯa kuḻu kaṯantaṟa uwankara minya-minyala. ");
INSERT INTO pjt_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","“Munuya god kutjupa tjuṯa waḻkulwiyangku wantima, panya ngayulu god kutjupa waḻkunnyangka puḻkaṟa mirpaṉaripai ngayunya kutju waḻkuntja-tjiratja. ");
INSERT INTO pjt_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Munuya aṉangu manta nyara palunya nguraṟa tjuṯangka kalypantaṟa wangkara purkaṟangku kalkuntja wiyangku wantima! Tjana tjinguṟu nyuranya aḻṯiku palula tjanala tjunguringkula tjanampa god tjuṯa waḻkuntjaku, munuya nyuranya wangkaku kuka pungkula tjanampa god tjuṯa ungkunytjaku. Munuya tjinguṟu nyuranya aḻṯiku tjunguringkula kuka panya god tjanampa ungkunytjanya ngalkuntjaku. Kaya pala palula-tawara tjananya kalypantaṟa wangkara kalkuntja wiyangku wantima. ");
INSERT INTO pjt_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Tjinguṟu nyura tjanampa kalyparingkula nyinanyangka nyurampa katja tjuṯangku aṉangu nyara palumpa tjanampa uṉṯalpa tjuṯa aḻṯiku, ka tjinguṟu minyma paluṟu tjana nyurampa katja tjuṯa iwara kurangka katiku tjana ngayunya wantira tjanampa god ngalypa-ngalypa tjuṯa waḻkuntjaku. ");
INSERT INTO pjt_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Munu nyura uti ayananguṟu god ngalypa-ngalypa waḻkuntjikitjangku palyantja wiyangku wantima. ");
INSERT INTO pjt_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Munuya aṟa panya mai pilytja ngalkuntjanya rawangku kulinma yiya kutjupa yiya kutjupa inma kanyintjikitjangku. Panya ngayulu nyurala wangkara wantingu mai pilytja ngalkukatinytjaku tjiṉṯu 7 piṟa panya ini Apipala, panya nyara palula aṟangka nyura Itjipanya wantikatira ngalya-pakaṉu. ");
INSERT INTO pjt_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Ka panya nyurampa katja ngaṉmanypa ngarinytja uwankara ngayuku, munu tjiipingku nanikutangku pulukangku ngaṉmanytju kanyintja uwankara kuḻu ngayuku. ");
INSERT INTO pjt_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Palu nyura tangkiyi nyiṯayira ngaṉmanypa ngarinytja maḻakungku mantjinma lamalama ngayunya ungkula palu puṟunypaṯu. Palu tjinguṟu nyuntu tangkiyi palunya maḻakungku mantjintja wiyangku wantinyi. Palulanguṟu nyuntu tangkiyi palunya ngunti kaṯantara. Palu nyura uti tjitji katja ngaṉmanypa ngarinytja tjuṯa ngayunya ungkunytjatjanungku maḻakungku payamilanma wantinytja wiyangku.” Alatji Godalu wangkangu. Munu piṟuku wangkangu, “Nyura uti ngayulakutu pitjanytjikitja mukuringkulampa kutjupa kutjupa ungkunytjikitjangku katima maṟalpa pitjanytja wiyangku. ");
INSERT INTO pjt_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Munu nyura uti tjiṉṯu 6 waṟkarima, munu palula maḻangka tjiṉṯu panya 7-ta nyinara tjiṉṯu kutju pakuwiyaringama waṟkarinytja wiya. Tjinguṟu waṟka puḻka ngaṟanyi kaanangka manta tjawaṟa waṉantjaku, munta tjinguṟu mai urantjaku, palu tjiṉṯu 6 waṟkarinytjatjanungku tjiṉṯu panya 7 wirkankunyangka waṟka palatja wantima munu nyinara pakuwiyaringama. ");
INSERT INTO pjt_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Munu nyura uti kuḻi kutjupa kuḻi kutjupa inma panya ini ‘Mai Urantjanya’ palyanma nyurampa mai wiita piḻṯiringkunyangka urantjikitjangku. Munu kuḻingka maḻangka nyura uti piṟuku inma kutjupa ini ‘Wiltjanya’ palyanma yiya kutjupa yiya kutjupa. ");
INSERT INTO pjt_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","“Uwa, yiya kutjupa yiya kutjupa wati uwankara uti maṉkuraṟa inmangka tjunguringama ngayunya waḻkuntjikitja, panya ngayulu Israelkunu tjuṯaku Mayatja Godanya. ");
INSERT INTO pjt_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Ka manta nyara palula ngayulu aṉangu nguratja tjuṯa-waraṟa pakaltjingaṟa ma-paiṟa waṉaṟa iyalku, ka nyura maḻangka tjarpara nyinara nguraṟariku. Ka nyara palula maḻangka inma nyanga maṉkurpa ngaṟanytja-aṟangka warmaḻa tjuṯa nyurampa pikaringkunytjikitja pitjanytja wiya ngaṟaku nyurampa ngurakutu munuya nyurampa manta puṯu mantjilku. ");
INSERT INTO pjt_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Palu nyura ngayunya kuka pungkula ungkunytjikitja mukuringkula mai nyuma yiitjatjara kukangka tjunguṟa ungkuwiyangku wantima, mai pilytja kutjuṉiya kukangka tjunguṟa ungama. Munuya inma panya Katuwanu Ankunytjanya kulintjikitjangku kuka lamalama pungkula ngalkuntjatjanungku tjara mungawinkiku tjunkunytja wiyangku wantira uwankara ngalkula wiyanma. ");
INSERT INTO pjt_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Ka panya nyura kuḻi kutjupa kuḻi kutjupa mai wiita nyurampa kuṟuringkunyangka uralpai. Munu nyura uti mai ngaṉmanytju urantja katima Mayatja Godaku waḻikutu, munu palulanguṟu maḻa urantja tjuṯa kutju nyurampa ngurakutu katima. “Munuya tjiipi kuḻunypa munta tjinguṟu nanikuta kuḻunypa ngunytjunguṟu ipi uṟu mantjiṟa kuka panya kuḻunypa palunya ipi uṟungka kutjantjikitjangku kulilwiyangku wantima alatjiṯu.” ");
INSERT INTO pjt_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Munu palulanguṟu Mayatja Godalu Mosela wangkangu, “Tjukurpa nyanganpa walkatjura nyura watarkurinytjaku-tawara rawangku kulintjikitjangku, panya ngayulu nyuranya kalkuṉu aṯunymaṟa kanyintjikitjangku munu panya nyurala tjukurpa wiṟu tjuṯa wangkangu nyura kuliṟa palyantjaku, ka panya nyura ngapartji kalkuṉu ngayulu wangkanytja uwankara wangaṉarangku kulintjikitjangku.” Alatji Godalu wangkangi. ");
INSERT INTO pjt_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Ka Mosenya puḻi katu Mayatja Godala tjungu nyinangi tjiṉṯu 40 munga 40 mai ngalkuwiya, mina kuḻu tjikilwiya. Munu tjiwa panya kutjarangka walkatjunu Godalu wangkara wituntjitja tjuṯa tjukurpa panya puḻka 10. ");
INSERT INTO pjt_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Ka Mosenya ngula ukalingu puḻi panya Tjaniyalanguṟu munu katingi tjiwa kutjara panya Godaku tjukurpatjara, ka palumpa yunpa irnyaningi, panya Mayatja Godanya palula tjungu nyinara pula rawa wangkangi, ka pala palulanguṟu palumpa yunpa puḻkaṟa irnyaningi. Palu paluṟunku yunpa walytjangku irnyannyangka nyakunytja wiya. ");
INSERT INTO pjt_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Ka Aarontu munu aṉangu panya Israelkunu tjuṯangku kutju Mosenya yunpa irnyannyangka nyangu, munuya nguḻu-nguḻuringkula palulakutu ilaringkunytja wiya paṯu ngaṟangi. ");
INSERT INTO pjt_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Ka tjananya Moselu aḻṯingu, ka Aaronnga munu wati Israelkunu puḻka tjuṯa palulakutu pitjangu. Ka paluṟu tjanala wangkangi. ");
INSERT INTO pjt_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Ka palula maḻangka aṉangu Israelkunu tjuṯa ngalya-tjunguringkula ngaṟangu Mosela tjukurpa kulintjikitja. Ka tjanala tjakultjunangi panya Mayatja Godalu palunya puḻi katu wangkanytja uwankara tjana kuliṟa wangaṉarangku Godala kulintjaku. ");
INSERT INTO pjt_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Munu palulanguṟu Moselu tjanala wangkara wiyaringkula paluṟu yunpa paluṟunku raikingka tjutuṉu. ");
INSERT INTO pjt_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Munu paluṟu tiinta panya Godala Tjunguringkula Kulilpaingka tjarpara kutju raiki panya palunya araltjankupai Godala wangkanytjikitjangku. Munu tiintanguṟu ngalya-pakaṟa Israelkunu tjuṯangka Mayatja Godalu wangkanytjitja uwankara tjanala tjakultjunkupai, ");
INSERT INTO pjt_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Kaya yunpa palunya nyakupai irnyannyangka alatjiṯu, ka palulanguṟu Moselu maḻakungku raiki panya tanpaṟa kanyilpai piṟuku Godala ngula wangkanytjikitjangku tiintangka panya unngu tjarpara. ");
INSERT INTO pjt_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Ka Moselu tjananya Israelkunu uwankara aḻṯira uṯuḻuṟa wangkangu, “Mayatja Godalu nganaṉanya wangkangu nyanga alatji palyantjaku. ");
INSERT INTO pjt_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Nyurampa tjiṟirpi 6 waṟkarinytjaku ngaṟanyi, palu tjiṟirpi 6 ngaṟala wiyaringkunyangka maḻangka tjiṟirpi panya 7 nyurampa miḻmiḻpa ngaṟanyi pakuwiyaringkula Mayatja Godanya kulintjaku. Ka tjinguṟu aṉangu kutjupa tjiṟirpi nyara palula tungunpungkula waṟkarinyangkaya palunya iluntanama. ");
INSERT INTO pjt_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Munuya nyurampa ngurangka waṟu tililwiyangku wantima tjiṟirpi panya pakuwiyaringkupaingka.” Alatji Moselu tjanala wangkangu Godalu wangkanytjitja. ");
INSERT INTO pjt_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Munu piṟuku tjanala wangkangu, “Mayatja Godalu nganaṉanya wangkangu nyanga alatji palyantjaku. ");
INSERT INTO pjt_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Nyura kanyintja uwankaranguṟuya tjaraṟa katima Mayatja Godanya ungkunytjikitjangku. Nyura mukuringkula munytjangku ungama nyanga palunya tjananya kanyintjatjanungku apu panya gold munu tjiilpa, munu ayana maṟu ini puṟantji. ");
INSERT INTO pjt_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","Munuya mantara wiṟu ukiṟi ini flax-nguṟu palyantja, munu inyu kuka tjiipinguṟu walka panya puyul-puyulpa, purple, tjitin-tjitinpa kuḻu ungama, nanikuta inyu kuḻu. ");
INSERT INTO pjt_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","Munuya tjiipi nyiṯayira miṟi kuḻu ungama tjitin-tjitinpa palyantjatjanungku, munu miṟi panya rapa puṟunypa antipina puḻkanguṟu katira ungama, munu puṉu palya ilykuwaranguṟu kuḻu ungama. ");
INSERT INTO pjt_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","Munuya uwila mai ini alipanguṟu katira ungama panya lampangka tjutintjaku tiliku, munu panya kurpiṟa miḻmiḻmankunytjaku kuḻu uwila palunya katima. Munuya uwila palula tjunguntjaku kutjupa kutjupa paṉṯi wiṟu katira ungama, munuya paṉṯi panya wiṟutjara piṟuku katima panya kampara wiṟu paṉṯinytjaku. ");
INSERT INTO pjt_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","Munu apu wiṟuly-wiṟulypa wiṟu kutjupa kutjupa tjuṯa walka wiṟutjara kuḻu katira ungama wati tjukurtjara puḻkangku piḻpirta tanpaṟa kanyintjaku. Uwa, nyanga palunya tjananya nyura kanyintjatjanungku katira ungama Tiinta Miḻmiḻku, munu tjukurtjaraku mantaraku kuḻu.” Alatji Moselu tjanala wangkangu Israelkunu tjuṯangka. ");
INSERT INTO pjt_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","11","Munu piṟuku tjanala wangkangi Moselu, “Utiya wati wiṟu palyalpai nintipuka tjuṯangku pitjala kutjupa kutjupa uwankara palyanma panya Godalu wangkanytjitjangka. Nyanga alatjiya palyala tiinta puḻka ngura miḻmiḻpa Godala tjunguringkula kulintjaku. Ngaṉmanytjuya puṉu tjuṯa kaṯala para-muṟutjuṟa waṉantjaku munu palulanguṟu puṉu kutjupa tjuṯa kuḻu palyala kaṯakutjara para-ngaritjuṟa waṉantjaku katu kuḻu, munuya ayana kutjupa kutjupa tjuṯa kuḻu palyala puṉu tjuṯa witiṟa kanyintjaku. Munuya palulanguṟu tiinta puḻka tjiipi miṟinguṟu palyala katu ngampaḻtjunkunytjaku, munu palulanguṟu tiinta kutjupa antipina miṟi panya rapanguṟu palyala palula katuku waṉinytjaku. ");
INSERT INTO pjt_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Munuya Pakutja Kalkuntjitja puṉunguṟu palyala munuya gold-nguṟu liitangka katutja angelpa nyaḻpitjara kampa kutjara nyinanytja palyala. Munuya puṉu waṟa kutjara kampa kutjara tjura witiṟa katinytjaku, munuya mantara waṟa palyala pakutja palula kuranyu waṟaly-waṟalyngaṟala angatjuṟa kanyintjaku. ");
INSERT INTO pjt_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","Munuya taipula kuḻu palyala, munu puṉu waṟa kutjara kampa kutjara tjura witiṟa katinytjaku, munuya kutjupa kutjupa tjuṯa kuḻu palyala taipulangka tjunkunytjaku, munuya mai nyuma panya Godanya ungkunytjitja kuḻu palyala taipulangka tjunkunytjaku. ");
INSERT INTO pjt_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","Munuya tili tjuṯa witiṟa kanyilpai palyala munu piti tjukutjuku tjuṯa palyala puṉu palula katu uwila tjutinnyangka tili palula tjanalanguṟu kampara irnyantjaku. Nyanga paluṟu lampa tili tjuṯatjara. ");
INSERT INTO pjt_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","Munu taipula kutjupa tjukutjuku nguwanpa palyala pala palula katu nyaḻpi paṉṯi wiṟutjara tjuṯa kampanytjaku, munuya puṉu waṟa kutjara taipulangka kampa kutjara tjura witiṟa katinytjaku, munuya nyaḻpi kutjupa kutjupa tjuṯanguṟu palyala paṉṯi wiṟutjara taipula palula katu kampanyangka wiṟu paṉṯintjaku. Munuya uwila wiṟu kuḻu palyala mai ini alipanguṟu aṉangungka katangka tjutiṟa miḻmiḻmankunytjaku. Munuya mantara waṟa palyala tiinta tjaangka waṟaly-waṟalyngaṟanytjaku. ");
INSERT INTO pjt_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","Munuya pitjilpa puḻka taipula puṟunypa palyala palula katu kuka tiliwakaṟa Godanya ungkunytjaku. Munuya puṉu waṟa kutjara kampa kutjara tanpaṟa tjura wati tjuṯangku pitjilpa palunya katuṟa katinytjaku, munu waṟika puṟunypa puṉu tjuṯa ayananguṟu palyaṟa ngaritjura pitjilpa katu palula tjanala kuka tiliwakantjikitjangku. Munuya ayananguṟu piti puḻka maṉatjara palyala wati tjukurtjara tjuṯangku mina tjutiṟa paltjintjaku. ");
INSERT INTO pjt_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","Munuya piintji puḻka palyala tiinta puḻkangka para-ngaṟala arintankunytjaku. Munuya mantara waṟa ukiṟi flax-nguṟu palyala piintjingka waṟaly-waṟalyngaṟala waṉantjaku. Munuya mantara waṟa kutjupa palyala piintji tjaangka waṟaly-waṟalyngaṟanytjaku. ");
INSERT INTO pjt_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","Munuya tiinta puḻka witu kuṉpu ngaṟanytjaku piiki muṯumuṯu tjuṯa palyala mantangka muṟutjunkunytjaku munuya ruupa kuṉpu tjuṯa kuḻu palyala tiinta witiṟa kanyintjaku. Munuya palu puṟunypaṯu piiki munu ruupa kutjupa tjuṯa kuḻu piintjiku palyala. ");
INSERT INTO pjt_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Munuya mantara wiṟu mulapa palyala wati tjukurtjara tjuṯaku mantara pala palula tjarpara Miḻmiḻṯa waṟkarinytjaku. Mantara nyanga paluṟu tjana panya Aaronku munu palumpa katja tjuṯaku kuḻu.” Nyanga alatji Moselu waṟka nintipuka tjuṯangka wangkangu kutjupa kutjupa uwankara palyantjaku panya Godalu uwankara wangkanytjitja. ");
INSERT INTO pjt_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Kaya tjukurpa nyanga palunya kulintjatjanu Israelkunu uwankarangku Mosenya wantikatira ngurakutu anu. ");
INSERT INTO pjt_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Munuya paluṟu tjana mukuringkula kutjupa kutjupa tjuṯa katingi tjana kanyintjatjanungku Mayatja Godanya munytjangku ungkunytjikitjangku tiinta panya miḻmiḻpa palyantjaku. Tjana kutjupa kutjupa uwankara katingi tiinta panya palyantjaku, munu tiinta unngu nyinanytja tjuṯa kuḻu palyantjaku, munu tjukurtjara tjuṯaku mantara kuḻu palyantjaku. ");
INSERT INTO pjt_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Watingku minymangku uwankarangkuya mukuringkula katingi kutjupa kutjupa tjuṯa apu gold-nguṟu palyantja liritja, pinatja, ringi manyirkitja, kutjupa kutjupa wiṟu tjuṯa tjana aṉangungka tanpaṟa kanyilpai uwankara. Munuya maṟangku katira Mayatja Godala miṟangka maṟa uritjingaṟa waḻkuṟa palunya ungangi. ");
INSERT INTO pjt_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Munuya mantara wiṟu ukiṟi ini flax-nguṟu palyantja kanyintjatjanungku katira ungangi, munuya inyu kuka tjiipinguṟu walka panya puyul-puyulpa, purple, tjitin-tjitinpa kuḻu kanyintjatjanungku katira ungangi, nanikuta inyu kuḻu. Munuya tjiipi nyiṯayira miṟi kuḻu tjitin-tjitinta palyantja kanyintjatjanungku ungangi, miṟi panya rapa puṟunypa antipina puḻkanguṟu palyantja kuḻu. ");
INSERT INTO pjt_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Munuya piṟuku kanyintjatjanungku katingi tjiilpa munu ayana ini puṟantji munuya Mayatja Godanya ungangi. Munuya puṉu wiṟu kuḻu kanyintjatjanungku katira ungangi panya Tiinta Miḻmiḻku puṉu tjuṯa palyantjaku, kutjupa kutjupa tjuṯa kuḻu puṉunguṟu palyantjaku. ");
INSERT INTO pjt_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Kaya minyma nintipuka tjuṯangku puṯuru puḻka rungkaṟa palyaṉu ukiṟi ini flax-nguṟu munu tjiipi inyunguṟu kuḻu puṯuru puḻka mulapa walka panya puyul-puyulpa, purple, munu tjitin-tjitinpa. ");
INSERT INTO pjt_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Munuya piṟuku rungkaṟa palyaṉu nanikuta inyunguṟu puṯuru puḻka. ");
INSERT INTO pjt_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Kaya Israelkunu wati kuranyitja tjuṯangku apu wiṟuly-wiṟulypa wiṟu kutjupa kutjupa tjuṯa walka wiṟutjara katira ungangi, panya wati tjukurtjaraku piḻpirta tjakatjunkunytjaku. ");
INSERT INTO pjt_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Munuya uwila mai ini alipanguṟu palyantjitja katira ungangi panya lampangka tjutintjaku tiliku, munu kurpiṟa miḻmiḻmankunytjaku kuḻu. Munuya uwila nyangangka tjunguntjaku kutjupa kutjupa paṉṯi wiṟutjara kuḻu katingi, munuya paṉṯi panya wiṟutjara piṟuku katira ungangi panya kampanyangka wiṟu paṉṯintjaku. ");
INSERT INTO pjt_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Uwa, Israelkunuku wati minyma uwankarangkuya mukuringkula kutjupa kutjupa tjana kanyintjatjanungku katira ungangi uwankara panya Mayatja Godalu Mosela ungkunytjaku wangkangu. Kaya paluṟu tjana puḻkaṟa pukuḻarira Godanya ungangi Tiinta Miḻmiḻpa palyantjaku munu tiinta unngu nyinanytja tjuṯa kuḻu palyantjaku, munu tjukurtjara tjuṯaku mantara kuḻu palyantjaku. ");
INSERT INTO pjt_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Ka Moselu tjanala Israelkunu tjuṯangka piṟuku wangkangu, “Mayatja Godalu ngurkantanu wati ini Pitjalilnga, panya Uwaṟiku katja, munu Uuku pakaḻi. Nyanga Pitjalilnga tjana Judah-languṟu kanyintja tjuṯa. ");
INSERT INTO pjt_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Ka Godalu palula Kurunpa Miḻmiḻnga tjarpatjunu, munu palunya nintinu kutjupa kutjupa wiṟu tjuṯa mulapa tjukaṟurungku palyantjaku. ");
INSERT INTO pjt_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Ka paluṟu mulapaṯu kutjupa kutjupa tjuṯanguṟu wiṟu mulapa palyaṟa tjungulpai Godalu nintinnyangka, panya gold-nguṟu, tjiilpanguṟu munu puṟantjinguṟu kuḻu. ");
INSERT INTO pjt_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Panya Godalu palunya nintinu apu walka wiṟutjara tjuṯa upala, rupi, apu kutjupa kutjupa tjuṯa kuḻu kaṯaṟa kaṟaly-kaṟalypa wiṟu mulapa palyantjaku. Munu palunya nintinu puṉunguṟu kuḻu wiṟuṟa palyantjaku munu kutjupa kutjupa tjuṯa kuḻu wiṟu mulapa paluṟu witulyankunyangka palyantjaku. ");
INSERT INTO pjt_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Munu Mayatja Godalu wati panya Pitjalilnga pulanya Awu-liyapanya nintinu paluṟu pula aṉangu kutjupa tjuṯa kuḻu nintintjaku uwankara Godalu palunya nintintjitja. Wati panya Awu-liyapanya wati ini Atjimatjaku katja munu walytjapiti Dantanguṟu munu paluṟu kuḻu ninti puḻka kutjupa kutjupa wiṟu tjuṯa tjukaṟurungku palyalpaiṯu. ");
INSERT INTO pjt_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Ka Godalu Pitjalilnga pulanya Awu-liyapanya nintinu kutjupa kutjupa wiṟu tjuṯa ayinayiningku palyantjaku ayananguṟu, puṉunguṟu kuḻu, munu mantara wiṟu mulapa palyantjaku walka tjuṯatjara. Munu pula aṉangu kutjupa tjuṯa kuḻu palu puṟunytjuṯu palyantjaku nintiningi, kaya paluṟu tjana nintiringkula kutjupa kutjupa wiṟu tjuṯa palyalpairingu.” Alatji Moselu tjanala wangkangi Israelkunu tjuṯangka. ");
INSERT INTO pjt_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Munu Moselu wati panya Pitjalilta pulala Awu-liyapala wangkangu munu waṟkaripai kutjupa tjuṯangka kuḻu nyanga alatji, “Uwa, Mayatja Godalu nyuranya kutjupa kutjupa tjuṯa nintinu Tiinta Miḻmiḻpa wiṟu mulapa palyantjaku. Ka nyura kuwari Godalu wangkanytjitja uwankara tjukaṟurungku palyantjaku ngaṟanyi.” ");
INSERT INTO pjt_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Munu Moselu Pitjalilnga pulanya Awu-liyapanya aḻṯingu wati panya nintipukangku palyalpai kutjupa tjuṯa kuḻu tjana kuḻu pitjala tiinta panya miḻmiḻpa palyantjaku. Kaya uwankara wangaṉara pitjala waṟkaringi. ");
INSERT INTO pjt_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Kaya Israelkunu tjuṯangku kutjupa kutjupa tjuṯa katingu Moselakutu Tiinta Miḻmiḻpa palyantjaku. Ka Pitjaliltu tjana Moselanguṟu mantjiṟa palyaningi tiinta panya palunya. Ka Israelkunu tjuṯangku mungawinki kutjupa mungawinki kutjupa tjana kanyintjatjanungku katira Mosenya ungkupai. ");
INSERT INTO pjt_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","5","Ka Pitjaliltu tjana waṟkarira nyangangi rawangku katinyangka, munuya Mosenya wangkangu, “Nyawa, aṉangu nyanga tjuṯangkuya tjuṯa mulapa katinyi, palu nyangatja alatjiṯu nganaṉa uwankara palyantjaku, panya Godalu palyantjaku wangkanytjitja.” ");
INSERT INTO pjt_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Ka Moselu wangka iyaṉu aṉangu uwankarakutu tjana kutjupa kutjupa tjuṯa piṟuku Tiinta Miḻmiḻku katira ungkuwiyangku wantinytjaku. Kaya kuliṟa wantingu piṟuku katiwiyangku. ");
INSERT INTO pjt_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Panya paluṟu tjana katira tjunkunytja tiinta panya palunya palyantjaku waintaṟa ngaringi tjuṯa mulapa waṟka panya palunya palyaṟa wiyantjaku. ");
INSERT INTO pjt_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","38","Kuwari nyuntu chapter 36-ngka verse 8-nguṟu puṯu nyanganyi nyiri nyangangka panya nganaṉa chapter 36, 37, 38 munu 39 kuḻu Pitjantjatjara walkatjunkunytja wiyaṯu kuwaripa. ");
INSERT INTO pjt_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","29","Palu chapter nyanga palula tjanala tjukurpa nyaa ngaṟanyi, panya Pitjaliltu tjana wati nintipuka tjuṯangku Tiinta Miḻmiḻpa, tiinta unngu nyinanytja tjuṯa kuḻu palyantja, munu mantara wiṟu tjukurtjara tjuṯaku kuḻu palyantja. Palu nganaṉa tjukurpa nyanga palunya tjananya muṯumuṯuṟa nyangangka tjunkunytja wiyangku wantingu panya aṟa nyanganpa aṟa panya ngaṉmanyitja tjuṯa puṟunypa panya nganaṉa tjunu chapter 24-ngka maḻangka. Aṟa nyara paluṟu tjana panya Godalu Mosela wangkanytja kutjupa kutjupa uwankara palyantjaku, ka aṟa nyanga chapter 36-nguṟu 39-kutu panya Pitjaliltu tjana kutjupa kutjupa uwankara palyantja Godalu Mosela wangkanytjitja. Palulanguṟula aṟa nyanganpa piṟuku tjunkunytja wiyangku wantingu, panya aṟa palu puṟunypa tjuṯa ngaṉmanypa ngaṟanyangka nyara chapter 24-ngka maḻangka. Palu nyangangka aṟa kutjupa kutjara ngaṉmanypa ngaṟanytja wiya, kala nyanga palula utiṟa tjunanyi. ");
INSERT INTO pjt_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","31","Ka chapter 38-ngka verse 1-nguṟu 31-kutu tjukurpa nyangatja ngaṟanyi, panya ayana kutjupa kutjupa tjuṯanguṟuya palyaningi Tiinta Miḻmiḻpa munu tiinta unngu nyinanytja tjuṯa kuḻu. Wati Pitjaliltu tjana ayana nyanga palula tjanalanguṟu palyaningi gold-nguṟu, tjiilpanguṟu, munu puṟantjinguṟu. Panya Israelkunu tjuṯangku katira ungu Mosenya ayana nyanga palunya tjananya puḻka mulapa Tiinta Miḻmiḻpa palyantjaku. ");
INSERT INTO pjt_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","31","Ka chapter 39-ta verse 1-nguṟu 31-kutu tjukurpa nyangatja ngaṟanyi, panya wati nintipuka tjuṯangku mantara tjuṯa palyantja wati tjukurtjara tjuṯaku. Ka nyura uti nyangama chapter 28 munu verse 1-nguṟu 43-kutu, panya tjukurpa nyanga paluṟu nyara palula kuḻu ngaṟanyi. ");
INSERT INTO pjt_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","43","Ka chapter 39-ta verse 32-nguṟu 43-kutu tjukurpa nyangatja ngaṟanyi, panya wati nintipuka tjuṯangku kutjupa kutjupa wiṟu tjuṯa palyaṉu Tiinta Miḻmiḻku Godalu wangkanytjitjangka. Munuya palyaṟa wiyaṟa tjana uwankara ngalya-katingu Moselakutu, ka paluṟu nyangangi uwankara palya mulapa ngaṟanytjaku. Munu paluṟu nyangu uwankara tjukaṟurungku palyantja panya Godalu palula wangkanytjitja alatjiṯu tjana palyaṉu. Munu palulanguṟu Moselu Pitjalilnga tjananya palula waṟkaripai uwankara pukuḻmanu, tjukaṟurungku palyannyangka. Ka nyanga palulanguṟu nyuntu tjukurpa maḻatja nyakula kulilku chapter 40, panya Moselu tjana Tiinta Miḻmiḻpa palyaṟa ngaṟatjunkunytja. ");
INSERT INTO pjt_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Ka Mayatja Godalu alatji Mosela wangkangu, ");
INSERT INTO pjt_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Piṟa ini Apipala tjiṟirpi ngaṉmanyitjangka tiinta panya miḻmiḻpa ngayuku palyaṟa ngaṟatjura. ");
INSERT INTO pjt_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Munu tjiwa panya kutjara tjukurpa panya puḻkatjara Pakutja Kalkuntjitjangka unngu tjarpatjura munu pakutja panya kalkuntja tiintangka unngu tjura munu mantara palula kuranyu waṟaly-waṟalytjura kumpilpa ngaṟanytjaku. ");
INSERT INTO pjt_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Munu taipula katira tjura munu kutjupa kutjupa tjuṯa kuḻu katira tjura taipulangka katu. Munu lampa panya tili tjuṯa witiṟa kanyilpai katira tjura munu piti uwilatjara palula katu tjura tili kampanytjaku. ");
INSERT INTO pjt_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Munu taipula panya tjukutjuku paṉṯi wiṟu tililpai katira tjura pakutja kalkuntjitjangka kuranyu. Munu mantara waṟa kuranyu waṟaly-waṟalytjura tiinta tjaangka. ");
INSERT INTO pjt_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Munu tjura tiintangka kuranyu pitjilpa panya puḻka, panya kuka tiliwakaṟa Godanya ungkula waḻkuntjaku. ");
INSERT INTO pjt_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Munu piti puḻka panya paltjilpai tjura pitjilpangka muṉkara tiintangka tjangaṯi munu kapi paltjintjaku tjutila. ");
INSERT INTO pjt_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Munu tiinta miḻmiḻṯa para-muṟutjuṟa waṉala puṉu tjuṯa piintji palyantjikitjangku munu palula maḻangka mantara para-tjunkula arintaṟa waṉala patintjikitjangku. Munu piintji tjaangka mantara waṟa kutjupa waṟaly-waṟalytjura. ");
INSERT INTO pjt_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Munu palulanguṟu uwankara palyaṟa tjunkunytjatjanungku uwila wiṟu panya miḻmiḻmankupaingka pitinguṟu tjutiṟa para-kurpiṟa waṉala Tiinta Miḻmiḻpa, munu kutjupa kutjupa tiinta unngu nyinanytja tjuṯa kuḻu kurpila nyanga tjananya uwankara miḻmiḻmankunytjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Munu palulanguṟu pitjilpa panya kuka tiliwakalpai uwila panya palula kurpila palunya kuḻu miḻmiḻmankunytjikitjangku munu ayana panya waṟika puṟunypa tjuṯa kuḻu kurpila palunya tjananya kuḻu miḻmiḻmankunytjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Munu palu puṟunytjuṯu piti panya paltjilpai kurpiṟa miḻmiḻmanama, piti maṉa kuḻu. ");
INSERT INTO pjt_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Munu Aaronnga palumpa katja tjuṯa kuḻu ngalya-kati tiinta pala miḻmiḻpakutu munu tjananya minangka paltjila. ");
INSERT INTO pjt_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Munu Aaronnga mantara panya wiṟu mulata tjarpatjura munu uwila panya miḻmiḻṯa palunya kurpiṟa miḻmiḻmara paluṟu tjukurtjararingkula ngayuku waṟka palyantjaku. ");
INSERT INTO pjt_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Munu palumpa katja tjuṯa kuḻu katira mantara panya wiṟu tjuṯangka tjarpatjura. ");
INSERT INTO pjt_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Munu palu puṟunypaṯu tjananya uwilangka kurpiṟa miḻmiḻmara tjana kuḻu tjukurtjararingkula ngayuku waṟka palyantjaku. Uwilangka kurpiṟa miḻmiḻmankunytja nyanga paluṟu nintini tjana tjukurtjara tjuṯa tiṯutjara ngaṟanytjaku nyanga palula tjanala maḻangka kuḻu kutjupa ngapartji piṟuku ngaṟanytjaku munu piṟuku maḻatja maḻatja.” Nyanga alatji Godalu Mosela wangkangu tjana palyantjaku. ");
INSERT INTO pjt_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Ka Moselu uwankara palyaṉu Mayatja Godalu wangkanytjitja. ");
INSERT INTO pjt_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Kaya Israelkunu tjuṯa ngura Itjipalanguṟu ankula nguṟurpa yiya kutju wiyaringu. Kaya pala palula aṟangka piṟa ngaṉmanyitjangka Moselu tjana tiinta panya miḻmiḻpa palyaṟa ngaṟatjunu tiinta panya Godanya Tjunguringkupai. ");
INSERT INTO pjt_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Tjana puṉu tjuṯa-waraṟa muṟutjunkula puṉu waṟa tjuṯa kaṯakutjara kaṯakutjara para-ngaritjuṟa waṉaṉu katu kuḻu. ");
INSERT INTO pjt_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Munuya palulanguṟu tiinta tjiipi miṟinguṟu palyantja katu ngampaḻtjunu munu palulanguṟu tiinta kutjupa antipina miṟinguṟu palyantja palula katu ngampaḻtjunu panya Godalu wangkanytjitjangka. ");
INSERT INTO pjt_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Ka Moselu puḻi panya tjiwa kutjara tjukurpa puḻkatjara mantjiṟa Pakutja panya Kalkuntjitjangka unngu tjarpatjunu. Munu palulanguṟu puṉu waṟa kutjara kampa kutjara tjunu witiṟa katinytjaku, munu pakutja palula katu liita panya nyaḻpitjara kutjara katu ngaparku nyinanytja kutjaratjara angatjunu. ");
INSERT INTO pjt_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Munu palulanguṟu Pakutja panya Kalkuntja Tiinta Miḻmiḻṯa unngu tjarpatjunu kampa wiluṟara munu mantara waṟa panya waṟaly-waṟalytjunu kuranyu, panya alatji Godalu wangkangu pakutja palunya kumpiṟa kanyintjaku. ");
INSERT INTO pjt_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Munu palulanguṟu taipula panya mai tjunkupai katira tiinta unngu tjarpatjunu kampa alinytjara mantara panya waṟaly-waṟalyngaṟanytjala kakaraṟa. ");
INSERT INTO pjt_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Munu mai nyuma katu tjunu mai panya Godanya ungkunytjitja, panya alatji Godalu palunya tjunkunytjaku wangkangu. ");
INSERT INTO pjt_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Munu lampa panya tili tjuṯatjara tiinta unngu tjarpatjunu taipulangka uḻpaṟira. ");
INSERT INTO pjt_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Munu nyara palula Mayatja Godala miṟangka Moselu tili panya tjuṯa tiliṟa wantingu Godalu wangkanytjitjangka. ");
INSERT INTO pjt_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Munu palulanguṟu taipula tjukutjuku wiṟu paṉṯipaitjara katira tiinta unngu tjunu mantara panya waṟaly-waṟalyngaṟanytjala kuranyu. ");
INSERT INTO pjt_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Munu paluṟu nyaḻpi wiṟu paṉṯipai tjuṯa tiliṟa wantingu wiṟu paṉṯinytjaku, panya alatjingantjaku Godalu wangkangu. ");
INSERT INTO pjt_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Munu palulanguṟu mantara waṟa tiinta tjaangka waṟaly-waṟalytjunu. ");
INSERT INTO pjt_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Munu piṟuku pitjilpa panya kuka tiliwakalpai katira tjunu Tiinta Miḻmiḻṯa kuranyu kampa kakaraṟa. Munu pitjilpa pala palula paluṟu kuka tjunkula tiliwakaṟa mulurunu Godanya ungkula waḻkuntjikitjangku munu mai uṉinypa tjuṯa kuḻu tjunkula tiliwakaṟa Godanya ungu, panya Godalu wangkanytjitjangka. ");
INSERT INTO pjt_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Munu piti panya paltjilpai puḻka katira tjunu pitjilpangka muṉkara tiintangka tjangaṯi, munu kapi kuḻu tjutinu paltjintjaku. ");
INSERT INTO pjt_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","32","Kayanku Moselu, Aarontu munu palumpa katja tjuṯangku kuḻu manyirka, tjina kuḻu paltjiṉu piti panya palula Tiinta Miḻmiḻṯa tjarpanytjikitjangku. Munuya palu puṟunypaṯu tiṯutjarangku paltjiningi Tiinta Miḻmiḻṯa tjarpanytjikitjangku munu pitjilpa kuka tiliwakalpaikutu pitjanytjikitjangku, panya Godalu Mosela wangkangu alatji palyantjaku. ");
INSERT INTO pjt_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Munuya palulanguṟu Moselu tjana piintji panya uṟilta para-ngaṟala waṉalpainya para-tjunkula arintaṟa waṉaṟa wiyaṉu munu mantara waṟa kutjupa piintji tjaangka waṟaly-waṟalytjunu. Ka uwankara tjana palyantja piintji unngu ngaṟangi. Munuya nyanga tjananya uwankara palyaṟa tjunkula wiyaṉu Moselu tjana. ");
INSERT INTO pjt_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Ka palulanguṟu ngangkaḻi panya waṟangku ukalingkula tjutuṉu tiinta panya miḻmiḻpa, ka Godaku pitalytjingku tiinta panya unngu puḻkaṟa irnyaningi. ");
INSERT INTO pjt_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Ka nyanga palulanguṟu ngangkaḻingku tjutuṟa ngaṟanyangka Mosenya Tiinta Miḻmiḻṯa puṯu tjarpangi pitalytjingku puḻkaṟa irnyannyangka. ");
INSERT INTO pjt_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Ka ngangkaḻi panyatja tiinta panya miḻmiḻpanguṟu katuringkula ankunyangka kutjuya Israelkunu tjuṯangku ngura kutjupangka pakaṟa ma-tjunangi. ");
INSERT INTO pjt_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Palu ngangkaḻi paluṟu Tiinta Miḻmiḻṯa ngaṟanyangkaya ankuwiya ngura palulaṯu nyinapai. ");
INSERT INTO pjt_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Ka Mayatja Godanya Israelkunu tjuṯangka tiṯutjara nyinangi tjana para-ngaṟanyangka, panya Godaku ngangkaḻi kaḻaḻa mungangka kuḻu tiinta panya miḻmiḻṯa ngaṟapai, palu mungangka waṟu tili ngangkaḻingka unngu ngaṟapai. Kaya Israelkunu tjuṯangku kaḻaḻa mungangka kuḻu rawangku nyakula kulilpai Mayatja Godanya tjanala nyinanyangka. ");
INSERT INTO pjt_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Iriti mulapa aṉangu tjuṯa manta Israelta nyinangi. Ka tjanampa mayatja puḻka kuranyitja nyinanytja wiya ngaṟangi. Kaya walytjangku walytjangku kuliṟa nyinangi. Ka nyara palula aṟangka ngura paluṟu mai puḻkatjara ngaṟanytjatjanu ailuru puḻkaringu, ka mai uwankara wiyaringu. Kaya aṉangu panya tjuṯa paḻtjatjiratja nyinangi. ");
INSERT INTO pjt_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Ka wati ini Ilima-likanya nyinangi tawunu ini Bethlehemala panya manta ini Judah-la nguṟurpa. Wati nyanga paluṟu panya wati Ipuṟatjalanguṟu kanyintja. Munu paluṟu pula kuriṟara tjitji nyiṯayira kutjaratjara nyinangi. Ka minyma kuri ini Nayuminya. Ka tjitji katja kutjara ini Maalannga pula Tjiliyannga. Ka panya mai wiyaringkunyangka paluṟu tjana Bethlehemanya wantikatira anu ngura kakaraṟa mulapa manta panya Judah-nya ma-wantikatira. Munuya ankula manta kutjupangka nyinangi mai puḻkangka ngura ini Mawapala. ");
INSERT INTO pjt_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Munuya rawa nyinangi, ka wati panya paluṟu ngaḻṯutjara ngulalta ilungu. Ka minyma panya wanakaḻarira nyinangi katja kutjaratjara. ");
INSERT INTO pjt_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Ka pula katja panya kutjarangku puḻkaringkula kungkawaṟalta aḻṯingu Israelnga nguraṟa wiya ngura kutjupitja Mawapanya nguraṟa. Ka wati kuṯangku kungkawaṟa ini Uupanya aḻṯingu ka maḻanypangku kungkawaṟa ini Ruthanya aḻṯingu. Munuya kuriṟara kuriṟara rawa nguwanpa nyinangi ngura nyara Mawapala. ");
INSERT INTO pjt_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Munu pula palulanguṟu tjitji utilwiyaṯu wiyaringu, ngaḻṯutjara kutjara. Ka Nayuminya mingkayi kutjaratjara kutju nyinangi ngura panya palula. ");
INSERT INTO pjt_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","13","Munu ngula paluṟu kulinu kutjupangku pitjala wangkanyangka ngura panya Bethlehemala kunyu mai puḻka pakaṉu Godalu mina iyannyangka. Ka Nayumilu kulinu, “Munta-uwa. Kuwariṉatju maḻaku ankuku ngurakutu panya.” Munu mingkayi kutjaratjara pirtji-pirtjingu ankunytjikitja. Munuya ma-pakaṉu. Munu tjukutjuku ankula Nayumilu palumpa mingkayi kutjarangka wangkangu, “Awa! Nyupali-puṯa ngurakutu maḻaku ara mamangka ngunytjungka nyinanytjikitja, kaṉa ngayulu kutju palya ara. Munuṉa nyupalimpa Godala tjapinma nyupalinya wiṟuṟa kanyintjaku. Panya ngayunya nyupali wiṟuṟa kanyiningi ngayuku kuri katja kutjara kuḻu. Kaṉa kuwari tjapini Godala palu puṟunytjuṯu nyupalinya wiṟuṟa kanyintjaku. Munuṉa nyupalimpa tjapilku wati kuri kutjupaku aḻṯira tjitji utiṟa kanyintjaku.” Munu pulanya Nayumilu mingkayi kutjara ampuṟa mitamita kutjara nyunytjuṟa wangkara iyaṉu pula maḻaku ankunytjaku. Ka pula puḻkaṟa ampuṟa ulangi palula tjungu ankunytjikitja, munu pula wangkangu, “Wiya, nyaakulinyan maḻakungku wituṉi? Ngali mukuringanyi nyuntula tjungu ankula nyuntumpa walytja tjuṯangka nyinanytjikitja.” Ka Nayumilu pulala wangkangu, “Nyaaku nyupali ngayula ankunytjikitja mukuringanyi? Ngayulu minyma pamparingu munuṉa piṟuku iṯi puṯu kanyini. Ngayunya tjinguṟu watingku aḻṯira tjitji utilku, ka tjitji kutjara kuwaripa puḻkaringkula ngula mulapa watiringkuku panya nyupali kuwaripangku rawangku nyinara paṯannyangka. Palu palya nyupali maḻaku ara wati kutjupangku Mawapanya nguraṟangku aḻṯinytjaku. Mama Godalu ngayuku kuri nyupalimpa kuri kutjara kuḻu mantjinu, ka ngayulu nyupalimpa puḻkaṟa ngaḻṯuringanyi kuri wiyaringkunyangka.” ");
INSERT INTO pjt_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","15","Ka pula piṟuku ulangi Nayumiku. Ka kungkawaṟa kutju ini Uupalu palumpa mingkayi mitamita kutjara nyunytjuṟa maḻaku anu ngura panya walytjakutu. Ka kungkawaṟa kutjupa ini Ruthanya palumpa mingkayiku puḻkaṟa mukuringangi palula tjungu ankunytjikitja munu palunya witiṟa ngaṟangi. Ka Nayumilu wangkangu, “Awa Rutha! Nyuntumpa kangkuṟu maḻaku anu walytja tjuṯakutu ngurangka nyinanytjikitja munu god kutjupa palumpa nyurampa nyinara kulintjikitja. Ka nyuntu kuḻu-puṯa maḻaku ara tjungu, palya?” ");
INSERT INTO pjt_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","17","Ka Ruthalu wangkangu palula, “Wiya, nyaaku nyuntu ngayunya maḻaku ankunytjaku wituṉi? Ngayulu mukuringanyi nyuntu ngali tjungu ankunytjikitja. Tjinguṟu nyuntu ngura kutjupa tjuṯakutu ankunyangka ngayulu nyuntula tjunguṯu para-ngaṟama. Ngayulu pukuḻarinyi nyuntumpa walytja tjuṯangka tjungu nyinanytjikitja munuṉa ngayuku walytja tjuṯakutu maḻaku ankunytja wiyangku wantinyi. Munuṉa ngayulu mukuringanyi nyuntu puṟunytju Mayatja Godanya mulapa kulintjikitja. Ka nyuntu ngula nyinara pamparingkula ilunyangka ngayulu wantira maḻaku ankunytja wiya ngura nyara palulaṯu nyinara wiyaringanyi nyuntu wiyaringkunytjitjangkaṯu. Nayumi, ngayulu mulamulangku wangkara kalkuṉi nyuntula tjungu ankunytjikitjangku. Mulapaṉa nyuntula tjungu nyinaku nyuntu ilunytjakutu alatjiṯu.” ");
INSERT INTO pjt_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Ka Nayumilu kulinu, “Munta-uwa, Ruthanya mulapa ngayula ankunytjikitja puḻkaṟa alatjiṯu mukuringanyi.” Munu paluṟu wangka pilunarira pula tjungu anu ngura panya Bethlehemalakutu. ");
INSERT INTO pjt_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Munu pula pitjala pitjala wirkanu ngura nyara palula. Kaya aṉangu nguratja tjuṯangku minyma panya Nayuminya pula pitjanyangka nyakula puḻkaṟa mulapa pukuḻaringu uwankara. Munuya minyma tjuṯangku wangkangu, “Munta, minyma panya Nayuminyampal palatja, minyma panya pukuḻtjumpa.” ");
INSERT INTO pjt_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","21","Ka Nayumilu pitjala tjanala wangkangu, “Wiya, ngayunyaṉiya Nayuminya panya ini pukuḻtju wangkawiyangku wantima. Panya ngura nyanganguṟuṉa kuri munu katja kutjaratjara ankula ma-kawalinu munu nyangaṉa kutjuringkulalta maḻaku wirkanu nyuralakutu. Mulapaṉi nyangatja Godalu tjituṟu-tjituṟu mularmanu. Kura yaaltji-yaaltjinguṟu tjananya mantjinu? Palu nyura ngayunya ini wangkawiyangku wantima munuṉiya ngayunya ini tjituṟu-tjituṟunya tjura, ini panya Maaṟanya.” ");
INSERT INTO pjt_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Nyanga alatji panya Nayuminya ngura Mawapalanguṟu pitjala wirkankunytja mingkayi nyara palunya nguraṟa kutjutjara. Minyma nyanga paluṟu pula kuḻingka pitjala wirkanu ngura pala Bethlehemala ukiṟi mai uṉinypatjara kunartjirira ngaṟala waṉannyangka paama tjuṯangka. ");
INSERT INTO pjt_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Ka ngura pala palula Nayumiku walytja wati ini Pawatjanya nyinangi. Paluṟu panya Nayumiku kuriku walytja mulapa. Munu paluṟu paama puḻka kanyiningi munu ulytja, mani puḻkatjara kuḻu nyinangi. Kaya aṉangu tjuṯangku palula kulilpai paluṟu wangkanyangka, panya paluṟu palyanyku kulilpai. ");
INSERT INTO pjt_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Ka Nayuminya pula panya ngura pala Bethlehemala tjarpara nyinangi. Ka kungkawaṟa Ruthalu wangkangu palumpa mingkayingka, “Mingkayi, wati minyma tjuṯangku paama tjuṯangka ukiṟi panya mai uṉinypatjara kaṯaṟa karpiṟa ngaṟatjunkula waṉaṉi. Kaṉa palya ankuku mai ngalimpa urantjikitja paamakutu? Panya mai tjukun-tjukunpa maḻaringkula ngaripai tjana puṯu mantjintja. Kawi-puṯa watingku wangka mai maḻaringkula ngarinytja urantjaku palumpa paamanguṟu.” Ka Nayumilu wangkangu, “Uwa palya, ma-pitjala waṟkari mai ngalimpa urantjikitja.” ");
INSERT INTO pjt_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Ka paluṟu anu paama tjuṯakutu. Munu ankula tjarpangu wati panya Pawatjaku paamangka. Palu paluṟu kulintja wiya wati panya paama nyanga palumpa walytja. Munu paluṟu wati minyma waṟkaripai tjuṯangka maḻangka mai muṯun-muṯunpa uraningi tjana wantikatinyangka. ");
INSERT INTO pjt_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Munu paluṟu rawa waṟkaringi. Ka ngula wati panya paama palumpa walytja Pawatjanya wirkanu tawunu panya Bethlehemalanguṟu munu palumpa waṟkaripai tjuṯa nyakula tjananya wangkangu, “Mayatja Godanya nyurala ilaringkula ngaṟanyi.” Ka paluṟu tjana ngapartji palula wangkangu, “Uwa, ka Mayatja Godalu nyuntunya pukuḻmanama.” ");
INSERT INTO pjt_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Ka palulanguṟu Pawatjalu wangkangu wati waṟka tjuṯaku mayatjangka, “Awa! Kungkawaṟa nyaratjampa ngananya nyinanyi?” ");
INSERT INTO pjt_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Ka watingku panya ngapartji wangkangu, “Wiya, kungkawaṟa nyara paluṟu malikitja Mawapanya nguraṟa. Pala paluṟu kuwari pitjangu Nayumila mingkayingka. ");
INSERT INTO pjt_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Palu paluṟuṉi mungawinki tjapinu waṟkarinytjikitjangku Nayumilu pulanku mai urantjikitjangku. Paluṟu mungawinki mulapa pitjala waṟkaringi munu waṟkarira waṟkarira kuwari nyanga wiltjangka nyinakatingu pakuwiyaringkunytjikitja.” ");
INSERT INTO pjt_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","9","Ka wati Pawatjanya Ruthalakutu ma-pitjangu munu ngaḻṯunytjungku wangkangu, “Awa! Nyuntu-puṯa ngayuku paamanguṟu kutju mai mantjinma, munu paama kutjupanguṟu ankula mantjilwiyangku wantima. Munu nyuntu minyma ngayuku waṟkaripai tjuṯangka itingka waṟkarima, kutju maḻa waṟkarinytja wiya. Munun wati minyma tjuṯangka mai kaṯaṟa karpinnyangka waṉaṟa ilangku nyangama minyma tjuṯangka itingka mai maḻaringkula ngarinytjitja urantjikitjangku. Ngayulu wati waṟkaripai tjuṯangka wangkangu nyuntunya pampulwiyangku wantinytjaku. Ka nyuntu waṟkarira waṟkarira iluringkula-puṯa mina nyaratja tjikinma panya ngayuku wati waṟkaripai tjuṯangku nyara tjutiṟa pitingka tjunkunytjitja.” ");
INSERT INTO pjt_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Ka Ruthalu kulinu panya Pawatjanya paamaku mayatja munu paluṟu ngurkantaṟa tultjungaṟakatira ngalyangku manta pampuṟa palunya waḻkuṉu. Munu wangkangu, “Ngayulu maliki ngura nyangatja nguraṟa wiya, palu nyuntu ngayunya wiṟuṟa wangkanyi.” ");
INSERT INTO pjt_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","12","Ka watingku panya ngapartji wangkangu, “Wiya Rutha, kulinuṉa nyuntu kunyu mingkayi wiṟuṟa aṯunymanangi nyuntumpa kuri ilunyangka munu wantir'iyalwiyangku wiṟuṟa kanyintjikitjangku waṉaṉu. Panya nyuntu kunyu ngunytju mama walytja tjuṯa wantikatira pitjangu ngura nyanga ngurpatjakutu maliki tjuṯangka tjungu nyinanytjikitja. Nyuntu kungkawaṟa wiṟu mulapa. Ka Israelku Mayatja Godalu nyuntunya ngapartji wiṟuṟa kanyilku, panya nyuntu ngura nyangaku God kulintjatjanu pitjangu paluṟu nyuntunya aṯunymaṟa kanyintjaku.” ");
INSERT INTO pjt_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Ka Ruthalu kuliṟa palula ngapartji wangkangu, “Mayatja, wiṟungkuṉitjun wangkara ipilymananyi. Ngayulu malikitja, palu nyuntu ngayunya wiṟuṟa wangkangu nyuntumpa waṟkaripai tjuṯa puṟunypa. Kaṉa kuwari raparinganyilta nyuntu ngayula alatjingaṟa wangkanyangka.” ");
INSERT INTO pjt_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Munu paluṟu tjana waṟkarira waṟkarira kaḻaḻarinyangka ankula wiltjangka nyinakatira mai ngalkuningi. Ka wati panya Pawatjalu Ruthanya aḻṯira wangkangu, “Nyangatja mai nyuma nyuntumpa. Ka nyanga kiṟipitji wangaṟangka tjaḻatjuṟa ngalkunma.” Ka paluṟu minyma wati waṟka tjuṯangka tjungungku nyinara ngalkuningi. Ka Pawatjalu piṟuku mai uṉinypa pauntjatjanungku Ruthanya ungu ngalkuntjaku. Ka Ruthalu mai ngalkula paḻtjaringkula tjara ngurakutu katinytjikitjangku tjunu. ");
INSERT INTO pjt_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","16","Munu paluṟu pakaṟa ma-pitjangu mai piṟuku urantjikitja. Ka Pawatjalu wangkangu wati waṟkaripai tjuṯangka, “Awa! Kungkawaṟa nyangatjaya wantima pailwiyangku mai nyura kaṯaṟa kultu karpintjitjangka itingka mai mantangka ngarinyangka mantjintjaku. Munu kutjupa-aṟa mai panya nyura karpintjitjanguṟu maṉkurpa ilaṟa mantangka waṉima kungkawaṟa pala paluṟu mantjintjaku.” ");
INSERT INTO pjt_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","18","Ka Ruthalu uraṟa uraṟa mungartjiringu. Munu palulanguṟu mai paluṟunku alkaṟa alkaṟa mai uṉinypa puḻka yakutjangka uraṟa tjarpatjuṟa ngurakutu katingu. Munu paluṟu ngurangka wirkaṟa mai panya paluṟu urantjitja mingkayingka nintinu, munu palunya ungu mai panya kaḻaḻa ngalkula tjunkunytjatjanungku. ");
INSERT INTO pjt_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Ka Nayumilu mai puḻka nyakula wangkangu Ruthala, “Ngangari! Ngura yaaltjingkan mai nyanga puḻka mantjinu? Nganaku paamangka? Ngayulu kuwari puḻkaṟa pukuḻarinyi munuṉa mukuringanyi Godalu wati nyara palunya pukuḻmankunytjaku nyuntunya wiṟuṟa alpamilannyangka.” Ka Ruthalu wangkangu, “Ngayulu wati ini Pawatjaku paamangka mai nyanga palunya uraningi.” ");
INSERT INTO pjt_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Ka Nayumilu wangkangu, “Munta-uwa! Mulapaṉa mukuringanyi Godalu palunya pukuḻmankunytjaku. Panya Mama Godalu aṉangu paluṟunku tjuṯa watarkuriwiyangku rawangku nyakula kanyini mungangka kaḻaḻa. Panya ngalimpa kuri ilungu, ka Godalu panya pula ilunytja kuliṟa ngalinya aṯunymananyi wanakaḻa kutjara. Awa kulila! Wati Pawatjanya nyuntumpa inkaṉi ngayuku walytja mulapa. Munu paluṟu ngalinya aṯunymankunytjaku ngaṟanyi alatjiṯu.” ");
INSERT INTO pjt_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Ka Ruthalu ngapartji wangkangu, “Uwa, paluṟuṉi wiṟuṟa alpamilaṉu munuṉi wangkangu, ‘Nyuntu ngayuku paamangka kutju rawangku mai uranma ngayuku waṟkaripai tjuṯangka tjungungku. Munun mai uwankara uraṟa tjunkunyangka kutju wiyaringama.’ Alatjingaṟaṉi wiṟungku wangkangu.” ");
INSERT INTO pjt_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Ka Nayumilu wangkangu, “Munta wiṟu ngana! Palya nyuntu palumpa paamangka waṟkarima minyma tjuṯawanu. Nyuntu tjinguṟu paama kutjupakutu ankulampa, kanta tjinguṟu watingku nyuntunya pampunma.” ");
INSERT INTO pjt_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Ka paluṟu kuliningi mingkayingku wangkanyangka munu paluṟu rawa waṟkaringi minyma panya Pawatjaku waṟkaripai tjuṯangka tjungu. Ngaṉmanytju paluṟu tjana uraningi mai ini paali munu maḻanguṟu mai maḻatja wiita mantjiningi. Munu tjana mai uwankara waḻingka uraṟa tjunkula kutju wiyaringu piṟa kutjara wiyaringkunyangka. Ka pula rawa mingkayira pukuḻpa nyinangi. ");
INSERT INTO pjt_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Ka ngula Nayumilu kuliṟa palumpa mingkayingka wangkangu, “Awa Rutha! Wangkakuṉa nyuntula? Ngayulu kulini wati kuri nyuntumpa nyakula ngurkantankunytjikitjangku nyupalinku aḻṯira pukuḻpa nyinanytjaku. ");
INSERT INTO pjt_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Ka nyuntu ninti Pawatjaku panya palumpa paamangka nyuntu minyma tjuṯangka tjungu waṟkaringi. Wati panya paluṟu ngayuku walytja mulapa. Palu kulila! Paluṟu kuwari mungangka mai araṟanganyi. ");
INSERT INTO pjt_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Ka nyuntu kuwari minangka paltjiṟa tiṟitja wiṟungka tjarpa mununku paṉṯipai wiṟungka nyiṯila wiṟu paṉṯintjaku. Munu nyuntu munga nyanga kuwari ma-pitja ngura nyara paluṟu tjanaya mai araṟangkunytjalakutu. Munun wirkaṟa utiringkuwiyangku kumpiṟa ngaṟala nyangama tjana araṟangkunyangka. ");
INSERT INTO pjt_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Munu waṟkangka maḻangka mai ngalkula tjikiṟa wiyaringkunyangka Pawatjanya nyawa ngura yaaltjingka ngarikatinyangka. Munun paluṟu watarku kunkunarinyangka nyakula palulakutu panykaṟa pulangkita atiṟa wanti tjina utintjikitjangku munun tjinangka itingka ngarikati. Munu paṯaṟa ngarima kanta paluṟu wankaringkula nyakula kulilku, ‘Munta nyangatja tjinguṟu tjapintjikitja pitjangu ngayulu palunya ngula aḻṯinytjaku.’ Alatji paluṟu kulilku munu paluṟu tjinguṟu nyuntunya wangkaku ngula aḻṯinytjikitjangku.” ");
INSERT INTO pjt_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Ka Ruthalu palumpa mingkayingku wangkanytja uwankara kuliṟa palyanmaṉu. ");
INSERT INTO pjt_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Munu pakaṟa anu ngura panya palulakutu panya Nayumilu wangkara iyantjalakutu. ");
INSERT INTO pjt_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Ka nyara palula wati panya Pawatjalu mai araṟangangi, munu araṟangkula wiyaringkula mai ngalkula tjikiṟa kurunpa pukuḻaringu. Munu ankula mai panya uṯuḻu pantja-pantjaṟa wiṟuṟa ngarikatingu munu kunkunaringu. Ka Ruthanya purkaṟa ma-panykaningi Pawatjalakutu munu pulangkita atiṟa tjina palunya utiṟa wantira maḻarku ngarikatingu. ");
INSERT INTO pjt_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Ka Pawatjanya kunkunpa puḻka ngaringi munu munga kultungka urulyaraṟa wankaringu munu kampa kutjuparira nyangu, “Ai! Kungkawaṟa yaalitja nyangatja ngayula itingka ngarinyi?” ");
INSERT INTO pjt_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Munu wangkangu, “Awai! Ngananyan ngarinyi?” Ka Ruthalu wangkangu, “Ngayulu panya Ruthanya. Ka nyuntu panya ngayuku mingkayiku walytja mulapa munun ngayunya aṯunymankunytjaku ngaṟanyi. Wanyu ngayunya pulangkitangka tjukutjuku tjutula, kaṉa palulanguṟu tjutunnyangka kulilku mulapa nyuntu ngayunya ngula aḻṯiku.” ");
INSERT INTO pjt_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Ka wati panya Pawatjalu wangkangu, “Kungkawaṟa wiṟu, Mayatja Godaluwi nyuntumpa pukuḻpa palyanma, panya nyuntu walytja tjuṯa puḻkaṟa kulilpai. Nyuntu panya wiṟuṟa kanyini nyuntumpa mingkayi. Munu nyuntu piṟuku tjukaṟurungku kulini tjitjuṟurungku aḻṯinytjaku. Wati yangupala tjuṯa ngaṟanyi kutjupatjara mani puḻkatjara, kutjupatjara mani wiya, palu nyuntu tjananya wantira tjukaṟurungku ngayunya ngurkantanu tjitjuṟuru nyuntumpa mingkayiku walytja. ");
INSERT INTO pjt_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Rutha, nyuntu rapa nyinama. Aṉangu uwankara nyuntumpa ninti panya nyuntu kungkawaṟa wiṟu mulapa. Ka ngayuluṉa palya kulini nyuntu wangkanyangka. ");
INSERT INTO pjt_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","14","Mulapa ngayulu tjitjuṟuru nyuntumpa mingkayiku walytja ilatja. Palulanguṟu uti ngayulu nyuntunya mulapa aṯunymaṟa kanyinma. Palu kulila wanyu! Wati kutjupa nyinanyi ngayuku kuṯa. Uti paluṟu nyuntunya aḻṯima wati ngaṉmanyitjangku. Wanyu kaṉa wati nyara palunya mungawinki ankula tjapila nyuntunya aḻṯira kanyintjaku. Ka tjinguṟu paluṟu nyuntunya aḻṯiwiyangku wantinyangkampa ngayuluṉanta aḻṯira aṯunymaṟa kanyilku. Palu palyali kuwari piṟuku kunkunari munu nyuntu tjiṉṯukutu pakaṟa ara nyuntumpa ngurakutu aṉangu nyanga tjuṯangku pakaṟa nyakunytjaku-tawara.” Ka Ruthanya piṟuku maḻarku ngaringu munu ngarira tjiṉṯukutu pakaṉu ngurakutu ankunytjikitja. ");
INSERT INTO pjt_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Ka Pawatjalu pakaṟa wangkangu, “Munta Rutha, pala mantara katatjanku lipiṟa tjura mantangka kaṉanku mai puḻka tjura nyuntu ngurakutu katinytjaku.” Ka mulapaṯu Ruthalu mantara katatja araltjaṟa mantangka lipiṟa kanyiningi mai paali tjunkunytjaku. Ka Pawatjalu mantara palula tjaalyngaṟatjuṟa iyaṉu kungkawaṟa panya palula. Ka paluṟu tjaḻiṟa ngurakutu katingu. ");
INSERT INTO pjt_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","17","Ka wirkankunyangka mingkayingku tjapinu, “Walangkuṉi tjakultjura! Nyaaringu?” Ka Ruthalu uwankara wangkangu Pawatjalu wangkanytja. Munu wangkangu, “Palu Pawatjalu alatji wangkangu wati kutjupa kunyu nyinanyi palumpa kuṯa. Ka kunyu paluṟu wati palunya tjapilku. Munuṉi paluṟu mai nyangatja ungkul'iyaṉu nyuntula maṟalpa wirkankunytjaku-tawara.” ");
INSERT INTO pjt_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Ka Nayumilu palula wangkangu, “Ka nyuntu tjituṟu-tjituṟuwiyangku Pawatjaku pukuḻṯu nyinara paṯanma, panya paluṟunta kulini alatjiṯu watarkuriwiyangku. Munu kuwari nyanga tjapini wati panya palumpa kuṯangka wati panya puḻka tjuṯangka tjunguringkula.” ");
INSERT INTO pjt_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Ka tawunu nyara palula Bethlehemala piintji waṟa para-ngaṟala waṉaningi apunguṟu palyantja kaita kutjutjara. Ka kaita palangka itingka wati mayatja-mayatja tjuṯa kutjupa-aṟa mitingi tjunguringkula wangkapai. Ka nyara palulakutu Pawatjanya ankula nyinakatingu. Munu paluṟu wati panya palumpa kuṯa palula itiwanu wati-pitjanyangka nyakula aḻṯingu, “Kuṯa! Wanyu ngalya-pitja!” Ka paluṟu pitjala nyinakatingu. ");
INSERT INTO pjt_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Palulanguṟu Pawatjalu aḻṯingu wati mayatja-mayatja tjuṯa 10-pa pitjala pulala tjunguringkula nyinara kulintjaku pulanku wangkanyangka. ");
INSERT INTO pjt_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Munu tjunguringkunyangkalta paluṟu wangkangi wati panya palumpa kuṯangkalta, “Ngaṉmanypa panya Nayuminya Mawapalakutu ankunytja kuwaripangka palumpa kuringku paama kanyiningi. Palu paluṟu ma-pakaṟa ngura nyara palula ankula wiyaringu. Ka kuwari minyma panyatja wanakaḻarira maḻaku pitjangu. Munu paluṟu kulini paama panya palunya tjalamilantjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Kaṉanta kuwari tjakultjunanyi kulintjaku panya nyuntu ngayuku kuṯangku kutju payamilantjaku ngaṟanyi. Palu nyuntu mukuringkunytja wiyangku wantinyangka kutju ngayulu payamilantjaku ngaṟanyi. Ala! Nyuntu payamilantjikitja mukuringkulampa wangka nyanga tjanala miṟangka. Palu wantirampa wangka, kaṉa ngayulu payamilalku.” Ka wati panya Pawatjaku kuṯangku wangkangu, “Wiya, palyaṉa ngayulu payamilalku.” ");
INSERT INTO pjt_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Ka Pawatjalu wati panya palula wangkangu, “Uwa palya. Palu nyuntu paama panyatja payamilaṟampa uti kungkawaṟa Mawapanya nguraṟa Ruthanya kuḻu aḻṯima, panya paluṟu wanakaḻaringu nyuntumpa walytjangka. Munun palunya aḻṯira uti tjitji utinma palula, ngula tjitji panya paluṟu puḻkaringkula paama panya paluṟunku kanyintjaku. Panya aṟa nyanga paluṟu nganampa tjaka ngaṟanyi alatjingalpai.” ");
INSERT INTO pjt_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Ka wati panya paluṟu Pawatjalu wangkanyangka kuliṟa nguḻu-nguḻuringu munu kulinu, “Munta, nguntiṉatju paama payamilantjikitjangku wangkangu, palu nyangangkuṉitju mitingingka tjuṯa miṟangka kalkuningi kungkawaṟa Ruthaku paama payamilaṟa aḻṯinytjaku.” Munu paluṟu kulintjatjanungku alatji wangkangu, “Wiya, ngayuluṉa paama panya palunya payamilantja wiyangku wantinyi. Palu nyuntu paama panya palunya payamilala munu Ruthanya aḻṯi, mununku palulanguṟu tjitji utila paama panya palumparinytjaku. Panya ngayuku tjitjiku paama wiya palatja palumpaṟa Ruthaku tjitjiku paama.” ");
INSERT INTO pjt_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","8","Munu paluṟu tjinatja palumpa araltjaṟa Pawatjanya ungkula wangkangu, “Ngayuluṉanta unganyi nyanga tjinatja ngayulu wantira.” Tjakangkuya aṟa tjanampa alatjingalpai wangkara palyanmankunytjatjanungku. ");
INSERT INTO pjt_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","10","Ka Pawatjalu tjinatja mantjiṟa wangkangu wati panya tjuṯangka, “Nyawaya! Ngayuluṉa mulapa kuwari paama payamilaṉi Nayumila, paama panya palumpa kuriku Ilima-likaku munu katja palumpa kutjaraku Maalanku pulampa Tjiliyanku. Munu nyangaṉa kuwari Maalanku kuri Ruthanya wanakaḻarinytja aḻṯinyi. Munuli ngula tjitji ngalinku kanyini, ka paluṟu puḻkaringkula kulilku, ‘Munta-uwa, nyangatja ngayuku tjamuku kamiku paama, kaṉa ngayulu kuwari wiṟuṟa alatjiṯu kanyilku.’” Munu Pawatjalu wangkangu tjanala, “Nyangatjaṉa mulamulangku wangkanyi nyurala miṟangka.” ");
INSERT INTO pjt_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","12","Ka wati tjuṯangku Pawatjala wangkangu, “Uwa, palyala kulini nyuntu wangkanyangka. Kawi Mayatja Godalu tjitji tjuṯa Ruthanya ungama panya Jacobaku kuri kutjara puṟunypa, panya Raitjilnga pulanya Liyanya tjitji tjuṯa Godalu ungu. Kawi nyuntu wati mayatja-mayatja puḻka nyinama mani puḻka mulartjara ngura nyanga Bethlehemala. Kawi Godalu nyupalimpa tjitji tjuṯa palyanma tjana wiṟuṟa nyinanytjaku nyuntumpa tjamu ngaṉmanyitja Piṟitjiku tjitji tjuṯa puṟunypa.” Alatjiya Pawatjala wangkangu. ");
INSERT INTO pjt_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Ka palulanguṟu Pawatjalu Ruthanya aḻṯira katingu palumpa ngurakutu kuriṟara pula nyinanytjikitjangku. Ka Mayatja Godalu Ruthanya pukuḻmanu, ka paluṟu iṯitjararingkula tjitji nyiṯayira kanyinu. ");
INSERT INTO pjt_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Ka iṯi wirkankunyangka minyma tjuṯangku nyakula pukuḻaringu munu Nayumila kamingka wangkangu alatji, “Kuwarila Mayatja Godanya mirawaṉinyi panya paluṟunta pakaḻi ungu nyuntunya pakaḻingku kanyintjaku puḻkaringkula. Kawi aṉangu Israelkunu uwankarangku nyuntumpa pakaḻi ngurkantaṟa puḻkanmanama. ");
INSERT INTO pjt_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Nyuntu panya ngaṉmanypa katjatjara pukuḻpa nyinangi, palu nyuntu kuwari nyuntumpa mingkayiku puḻkaṟa alatjiṯu pukuḻarinyi panya paluṟu nyuntumpa mukulya wiṟunya nyinanyi munu panya kuwari nyuntumpa pakaḻi kanyinu. Ka ngula pamparingkunyangka nyuntunya pakaḻingku wiṟuṟa kanyilku pukuḻmaṟa mulatu.” Alatjiya minyma Bethlehemanya nguraṟa tjuṯangku Nayumila wangkangu. ");
INSERT INTO pjt_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Ka Nayumilu pakaḻi palumpa ampuṉu munu palunya aṯunymaṟa kanyiningi pukuḻṯu. ");
INSERT INTO pjt_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Kaya minyma tjuṯangku iṯi panya wirkankunyangka uwankarangka tjakultjunangi, “Awai! Wanyuya kulila! Kuwari iṯi ngaringu Nayumiku pakaḻi.” Munuya tjitji panya palunya ininu Uupitanya. Ka Uupitanya puḻkaringkula ngula watiringu munu kuri aḻṯira tjitji utinu ini Jesse-nya, ka Jesse-nya puḻkaringkula ngula watiringu munu kuri aḻṯira tjitji utinu ini Davidanya. ");
INSERT INTO pjt_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Ka Uupitaku walytja iritilpi nyinangi Jacobanya. Ka Jacobalu katja ini Judah-nya utinu. Ka Judah-lu katja ini Piṟitjinya utinu. Ka Piṟitjilu katja ini Itjuṟannga utinu. ");
INSERT INTO pjt_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Ka Itjuṟantu katja ini Ramanya utinu. Ka Ramalu utinu katja ini Amina-tapanya. ");
INSERT INTO pjt_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Ka Amina-tapalu utinu katja ini Naatjannga. Ka Naatjantu utinu katja ini Tjalmannga. ");
INSERT INTO pjt_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","22","Ka Tjalmantu katja panya Pawatjanya utinu wati panya Uupitaku mama. Alatjiṯuya walytja wanapari wanapari utiningi Jacobalanguṟu Uupitalakutu. Ka Uupitalu panya katja ini Jesse-nya utinu, ka Jesse-lu katja panya Davidanya utinu, ka paluṟu panya ngula Israelku mayatja puḻka nyinangi. ");
INSERT INTO pjt_vpl VALUES ("S11_1","010_1_1","1SA","1","1","17","Kaya Israelkunu tjuṯa yiya tjuṯa mulapa nyinangi ngura panya kalkuntjitjangka ini Kainanta. Ka wati kutjupa nyinangi kuri kutjaratjara. Kuri ngaṉmanyitja ini Aananya munu paluṟu tjitji wiya nyinangi. Ka kuri maḻatja tjitji tjuṯatjara munu kutjupa-aṟa paluṟu Aananya kuralpai munu tjituṟu-tjituṟu puḻka palyalpai paluṟu kutju tjitji tjuṯatjara nyinara. Ka yiya kutjupa yiya kutjupa Aananya tjana ankupai ngura ini Tjayululakutu tiinta panya miḻmiḻṯa tjunguringkula Godanya waḻkuntjikitja. Munuya nyara palula aṟa paluṟu tjana mai ngalkuningi uṟilta. Ka Aananya pakaṟa anu tiinta panya miḻmiḻpakutu Godala tjapintjikitja. Palu paluṟu wati panya tjukurtjara nyakunytja wiya tuwangka itingka nyinanyangka. Munu minyma panya paluṟu watarku ngaṟala Godala tjapiningi tjaalytju. Ka winpinpi kutju uri-uringi, palu tjukurpa utiringkunytja wiya paluṟu wangkanyangka. Ka wati panya tjukurtjarangku Iilailu nyakula kulinu, “Nyaaku nyangatja taṟangka pitjangu. Paluṟu Godanya kuraṉi alatji pitjala?” Munu palula wangkangu, “Nyaakun taṟangka pitjangu? Utin taṟangka wiya pitjama.” Ka minymangku wangkangu, “Wiya, ngayulu taṟangka wiya. Ngayulu tjituṟu-tjituṟurira ulara ulara pitjangu Godala tjapintjikitja ngayunya alpamilantjaku.” Ka wati tjukurtjarangku kuliṟa wangkangu, “Palya, pukuḻpa ara, panya Godalunta tjapinnyangka kulinu mununta ungkuku.” ");
INSERT INTO pjt_vpl VALUES ("S11_18","010_1_18","1SA","1","18","28","Ka minyma panya paluṟu pukuḻarira ma-pakaṉu munu ngurangka wirkaṟa pukuḻpa alatjiṯu nyinangi piṟuku tjituṟu-tjituṟurinytja wiya. Munu pula kuriṟara tjunguringkula pukuḻpa tiṯutjara nyinangi. Ka panya Godalu palunya kulinu tjapinnyangka munu tjitji katja ungu. Ka palulanguṟu tjitji paluṟu puḻkaringkunyangka ngunytjungku katira ungu Iilainya, munu wangkangu, “Panya Godanyaṉa tjapiningi tjitji nyanga palumpa, kaṉi mulapaṯu ungu, kaṉa ininu Samuelnga. Munuṉa kuwari nyuntulakutu katingu, panya ngaṉmanytjuṉa tjitji nyanga palunya kalkuṉu puḻkaringkunyangka Godanya ungkunytjikitjangku nyuntula tjungungku tiinta nyanga miḻmiḻṯa waṟkarira tiṯutjarangku Godanya waḻkuntjaku.” ");
INSERT INTO pjt_vpl VALUES ("S12_11","010_2_11","1SA","2","11","19","Munu palulanguṟu tjitji panya palunya katira tjunu wati panya tjukurtjaraku ngurangka, ka wati panya palula waṟkaringi tiinta panya miḻmiḻṯa. Ka yiya kutjupa yiya kutjupa palumpa ngunytju mama pitjapai Godanya waḻkuntjikitja munu pula tjitji palumpa ulytja wiṟu katipai. ");
INSERT INTO pjt_vpl VALUES ("S13_1","010_3_1","1SA","3","1","15","Ka nyara palula aṟa aṉangu Israelkunu tjuṯangku Godanya kulintja wiya nyinangi. Ka Godalu tjanala tjukurmankunyangka wangkanytja wiyangku wantingi maṉkurta kutju wangkangi. Ka panya Iilaiku katja kutjarangku kuḻu Godanya kulilpai wiya nyinangi. Ka palulanguṟu Godalu tjitji tjukutjuku Samuelnga ngurkantanu palula wangkanytjikitjangku. Ka munga kutjupa Iilainya pula Samuelnga tiinta unngu ngaringi ruuma kutjupa kutjupangka. Ka Godalu Samuelnga wangkangu, “Samuel! Samuel!” Ka tjitji panya pakaṟa anu Iilailakutu munu wangkangu, “Nyaapa? Nyaakuṉin ini wangkanyi?” Ka Iilailu wangkangu, “Wampa! Nyuntunyaṉa wangkanytja wiyaṯu. Ankula kunkunari!” Ka tjitji panya paluṟu ankula piṟuku ngarikatingu munu kulinu ini wangkanyangka. Munu piṟuku pakaṟa anu Iilailakutu. Ka wangkangu, “Wiya, ngurpaṉa. Ankula ngarikati!” Ka ankula ngarikatira piṟuku kulinu ini wangkanyangka, munu ankula Iilaila tjapinu. Ka paluṟu unngu kulinu, “Munta nyangatja tjinguṟu Godalu palunya ini wangkanyi.” Munu tjitji palunya wangkangu alatji, “Wiya, ankula ngarikati munun piṟuku ini wangkanyangka kuliṟampa wangka alatji, ‘Uwa, Mayatja wangka. Kuliniṉanta.’” Ka mulapaṯu ankula ngarikatira kulinu ini wangkanyangka, “Samuel! Samuel!” Ka Samueltu wangkangu, “Uwa, wangka Mayatja. Kuliniṉanta.” Ka Mayatja Godalu wangkangu, “Kuwariya Israelkunu tjuṯa puḻkaṟa urulyaralku ngayulu palyannyangka panya kuwariṉa Iilainya tjananya palumpa walytjapiti uwankara tjituṟu-tjituṟu puḻka palyalku. Panya Iilaiku katja kutjarangku ngayula rawa tungunpungkupai, ka Iilailu pulanya paintja wiyangku wantipai. Kaṉa nyara palulanguṟu palula wangkangu palumpa walytjapitiku tjituṟu-tjituṟu palyantjikitjangku. Ka paluṟu wantingi alatjiṯu palumpa katja kutjara kura tjuṯa rawangku palyannyangka paintja wiyangku.” Alatji Godalu Samuelta wangkangu. ");
INSERT INTO pjt_vpl VALUES ("S13_18","010_3_18","1SA","3","18","21","Ka paluṟu mungawinki pakaṟa Iilaila uwankara tjakultjunu kutitjunkunytja wiyangku Godalu panya palula wangkanytja. Ka Iilailu wangkangu, “Paluṟu alatjiṯu Mayatjangku uwankara kuliṟa palyantjaku ngaṟanyi alatjiṯu.” Ka Mayatja Godanya Samuelta tjungu tiṯutjara nyinangi. Ka paluṟu ngula puḻkaringkula watiringu. Palu Israelkunu tjuṯangkuya kuliningi Samuelnga Mayatja Godaku wangkatjara nyinanytja. Ka Godalu paluṟunku rawangku utiningi Samuelta, munu paluṟunku utiningi tjukurmankunytja-wanungku. Ka Samuelku tjukurpa lipiringu ngura uwankarangka Israelta munu ngura ititja tjuṯangka kuḻu. ");
INSERT INTO pjt_vpl VALUES ("S14_1","010_4_1","1SA","4","1","11","Ka ngura nyara Israeltakutu wati Pilitjiyanya nguraṟa tjuṯa warmaḻa pitjapai Israelkunu tjuṯa pikaringkunytjikitja. Munuya kutju-aṟa ngaparku tjunguringkula ila-ila ngaringi tjiṉṯungka pakaṟa pika pungkunytjikitja. Ka tjiṉṯuringkunyangka pika puḻka ngaṟangu. Kaya warmaḻa tjuṯangku winki mulapa iluntanu Israelkunu tjuṯa, wati 4,000. Kaya maṉkur-maṉkurpa ngurakutu anu. Munuya wati tjiḻpi tjuṯangka wirkaṟa wangkangu. Kaya tjiḻpi tjuṯangku tjanala tjapinu, “Palu nyaaku Godalu warmaḻa tjuṯa wantir'iyaṉu nganaṉanya iluntankunytjaku? Munta-uwa, wanyula arkaṟa pakutja panya kalkuntja miḻmiḻpa mantjila tiintanguṟu munula ma-kati manta nyara pika pungkupaikutu. Ka tjinguṟu Godalu nganaṉanya alpamilalku nyara palula.” Munuya palulanguṟu wati maṉkur-maṉkurpa iyaṉu pakutja palunya mantjintjaku, panya Iilaiku katja kutjarangku pakutja palunya kanyiningi tiintangka panya unngu. Kaya pakutja panya miḻmiḻpa ankula mantjiṟa ngura nyara palulakutu wirkakatingu. Kaya Israelkunu tjuṯangku nyakula pukuḻarira puḻkaṟa mirangu. Ka manta uringu tjana miranyangka. Kaya warmaḻa tjuṯangku kulinu Israelkunu tjuṯa miranyangka, munuya wangkangu, “Nyaaku nyaranpa miranyi Israelkunu nyara tjuṯaku ngurangka?” Munuya palulanguṟu maḻalta kulinu, “Munta-uwa, pakutja panya miḻmiḻpaya kunyu mantjinu.” Munuya nguḻuringu alatji kuliṟa, “Panya tjanampa God kuwari tjanala wirkaṟa ngaṟanyi tjanala tjungu, munulanya tjinguṟu kuwari uwankara wiyalku, panya alatji ngaṉmanypa ngaṟanytja wiyaṯu. Kuwari-manti kura mulapalta ngaṟaku nganampa. Nganalulanya wankalku? Panya tjanampa God witulya puḻka mulapa, panya uwankara iluntara wiyaṉu ngura panya Itjipala. Wiya, tjana kutju wanyu wati. Nganaṉa watiṯu. Rapariwala ngapartji pungkunytjikitja.” Ka palulanguṟu pikalta ngaṟangu tjananku pungkunytjaku, kayanku pungangilta. Kaya Pilitjiyanya nguraṟa warmaḻa tjuṯa waintaringu alatjiṯu munuya wati winki mulapa Israelkunu tjuṯa iluntanu. Kaya maṉkur-maṉkurpa kutju wankaringkula anu ngurakutu. Kaya pakutja panya miḻmiḻpa warmaḻa tjuṯangku mantjiṟa katingu, panya Iilaiku katja kutjara kuḻu ilungu nyara palula. ");
INSERT INTO pjt_vpl VALUES ("S14_12","010_4_12","1SA","4","12","22","Ka tjiṉṯu nyara palula wati kutju wirtjapakaṉu pikangka uṯu-uṯu, munu ngurangka wirkaṟa aṉangu nguratja tjuṯangka tjakultjunu, kaya puḻkaṟa ulangi. Ka Iilailu ula kuliṟa tjapinu, “Nyaaringu nyanganpa?” Ka wati panya paluṟu Iilaila tjakultjunu alatji, “Pitjanguṉa nyuntula wangkanytjikitja.” Ka Iilailu wangkangu, “Nyaa? Walangkuṉi wangka.” Ka wati panyangku wangkangu, “Wati panyanpaya nguḻu uwankara wirtjapakaṉu, ka uwankara manta-kutjuringu. Winki mulapaya wiyaṉu Pilitjiyanya nguraṟa tjuṯangku. Ka nyuntumpa kuḻu. Nyuntu kutjultan nyinanyi. Kaya pakutja panya miḻmiḻpa kuḻu katingu.” Ka tjiḻpi panya Iilailu kuliṟa kankara punkaṉu munu nguṉṯi kaṯakatira ilungu. Panya paluṟu yiya tjuṯa mulatu Israelkunu tjuṯa kanyiningi. Ka Iilainya katja kutjara kuḻu ilunyangka minyma panya palumpa mingkayi kuliṟa puḻkaṟa tjituṟu-tjituṟuringu munu nyara palulanguṟu paluṟu tjuni iniringu. Ka iṯi panya ngaṉmanypa wirkanu kuwaripangka, munu wirkaṟa ngunytju palumpa pika puḻka palyaṉu. Ka minyma panya paluṟu iṯi katja kanyiṟa pukuḻarinytja wiya watarku alatjiṯu ngaringi panya paluṟu rawangku kuliningi palumpa kuri, mingkayi kuḻu ilunytjitja munu puṯu pukuḻarira ilungu iṯi kanyintjatjanu. Palu minyma paluṟu ilunytja kuwaripangka iṯi palunya ininu Ikapatanya. Ini nyanga paluṟu wangkanyi ‘Witulya Pitalytji Wiya’, panya warmaḻa tjuṯangku pakutja panya miḻmiḻpa ngura tjanampakutu katinyangka Godaku pitalytjingku Israelnga wantikatingu. ");
INSERT INTO pjt_vpl VALUES ("S15_1","010_5_1","1SA","5","1","2","Palula maḻangkaya warmaḻa tjuṯangku pakutja panya miḻmiḻpa Godaku wirkakatingu ngura tjanampakutu Pilitjiyalakutu, munuya tjanampa god puḻkangka ini Taikanta itingka tjunu palumpa timpulangka, panya nyanga palunyaya puḻkaṟa waḻkulpai Pilitjiyanya nguraṟa tjuṯangku. ");
INSERT INTO pjt_vpl VALUES ("S15_3","010_5_3","1SA","5","3","7","Ka tjiṉṯu kutjupa god panya ngalypa-ngalypa puḻkanya Taikannga punkaṟa ngaringi pakutjangka itingka panya palumpa tjukurtjara tjuṯangku tjunkunytjitja. Kaya nyakula piṟuku pakaltjingaṟa ngaṟatjunu. Munuya mungawinki kutjupa piṟuku nyakula wangkangu, “Awari, pitjalaya nyawa! Nganampa panya god puḻkanya kaṯalypa ngarinyi pakutjangka itingka, mina kutjara kaṯalypa munu kata kuḻu kaṯakatira.” Nyanga palula maḻangka Godalu tjanampa kura puḻka mulapa palyaṉu Pilitjiyanya nguraṟa tjuṯaku. Ka tjanala puntungka kalypata puṟunypa tjuṯa pakaṉu. Kaya palulanguṟu tjiḻpi tjuṯangku wangkangu pakutja panya warpungkula katinytjaku ngura kutjupakutu. Kaya wati tjuṯangku pakutja panya palunya ma-katingu tawunu kutjupakutu. Ka pika puḻkaṯu ngaṟangu ngura nyara palula kuḻu. Kaya tjara kutjupa ilungi, kaya tjara kutjupa pika puḻkatjara nyinangi. Ka kaana uwankarangka mingkiri tjuṯaringu munuya mai uwankara ngalkula wiyaṉu. Ka tawunu uwankarangka aṉangu tjuṯa ilungi. Kaya ngulalta Pilitjiyanya nguraṟa tjuṯangku kulinu tjanampa pika rawa ngaṟanyangka, “Munta-uwa, kulinultala pakutja panya tjulyantjitjanguṟu-manti pika nyangatjampa wirkanu. Walangkultala wanyu katira uwa walytja tjuṯa.” ");
INSERT INTO pjt_vpl VALUES ("S16_1","010_6_1","1SA","6","1","21","Munuya palulanguṟu pakaṟa maḻakungku katingu Israelkunu tjuṯakutu. Kaya Israelkunu tjuṯangku nyakula puḻkaṟa pukuḻaringu pakutja panya miḻmiḻpa maḻakungku ngura walytjakutu wirkakatinyangka. Kaya Israelkunu kutjupa tjuṯangku pukuḻarira pakutja panya aḻaṟa nyakula uwankara ilungu panya pakutja nyara palunya Godalu witinu wati tjukurtjarangku kutju pampuntjaku. Ka tjana watarkurira aḻaṉu munuya tjuṯa mulapa ilungu. ");
INSERT INTO pjt_vpl VALUES ("S17_1","010_7_1","1SA","7","1","1","Kaya palulanguṟu ngura kutjupakutu ngapartji iyaṉu pakutja panya palunya, munuya wati kutju ngurkantaṟa tjunu pakutja palunya nyinara aṯunymankunytjaku. ");
INSERT INTO pjt_vpl VALUES ("S17_2","010_7_2","1SA","7","2","4","Kaya nyara palula maḻangka Israelkunu tjuṯa Godaku watarkurira nyinangi. Munuya yiya tjuṯa ngaṟala wiyaringkunyangka kutju maḻaku aṟuringu Godalakutu. Ka palulanguṟu Samueltu tjanala wangkangu, “Godanya waṉantjikitja mukuringkulaya god ngalypa-ngalypa tjuṯa-waraṟa waṉi munuya Godanya kutju kuliṟa waṉanma. Ka palulanguṟu Godalu nyuranya wankalku mirpaṉtju tjuṯanguṟu.” Kaya palulanguṟu god ngalypa-ngalypa tjuṯa waṉingu uwankara. ");
INSERT INTO pjt_vpl VALUES ("S17_5","010_7_5","1SA","7","5","11","Ka Samueltu piṟuku wangkangu, “Uwankarala kutjuriwa kaṉa Godala nyurampa tjapinma.” Ka palulanguṟu aṉangu uwankara tjunguringu ngura uwankaranguṟu ngura kutjungka Godanya waḻkuntjikitja. Kaya mirpaṉtju tjuṯangku ngunti kulinu tjananya pika pungkunytjikitja-mantiya tjunguringu, munuya tjana ngapartji tjunguringuṯu ngura kutjungka tjananya pungkunytjikitja. Kaya Israelkunu tjuṯangku kulinu tjana pika pitjanytja munuya puḻkaṟa nguḻuringkula wangkangu Samuelta, “Nyuntulampa Godala tjapinma rawangku nganaṉanya wankaṟu kanyintjaku.” Ka palulanguṟu Samueltu kuka pungkula ungangi Godanya munu puḻkaṟa palula tjapiningi tjanampa. Ka Godalu kulinu palula. Kaya warmaḻa panya tjuṯa ngalya-ilaringu. Ka tjana ilaringkunyangka ilkaṟingka puḻkaṟa tuuṉu, panya Godalu tuuntjaku palyaṉu, munu tjananya nguḻutjingaṉu, kaya nguḻu wirtjapakaṉu. Kaya Israelkunu tjuṯangku nguḻuṟa waṉaṟa tjara iluntanu, ka tjara kutjupa wanka wirtjapakaṉu ngurakutu. ");
INSERT INTO pjt_vpl VALUES ("S17_12","010_7_12","1SA","7","12","17","Nyara palula maḻangka Samueltu puḻi waḻu mantjiṟa ngaṟatjunu munu paluṟu puḻi nyara palunya ininu 'Ipinitjanya' munu wangkangu alatji, “Panya Mama Godalu nganaṉanya alpamilaṉu.” Kaya Pilitjiyanya nguraṟa tjuṯa maḻaku puṯu tjarpangu ngura panya Israelta, panya Mayatja Godanya tjanala anga-ngaṟangu Israelkunu tjuṯaku ngalkilpa. Panya ngaṉmanytjuya Pilitjiyanya nguraṟa tjuṯangku tjananya pungkula kaṉany-kaṉanyaringi waintarira ngura tjuṯa kuḻu tjulyaṟa tjanalanguṟu. Palu tjana ngapartjiya waintaringu munuya ngura panya palunya tjananya maḻakungku mantjinu. Ka Samueltu tjananya tiṯutjarangku mayatjangku kanyiningi Israelkunu panya tjuṯa, munu palumpa ngurangka pitjilpa kutjupa palyaṉu Godanya rawangku waḻkuntjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("S18_1","010_8_1","1SA","8","1","22","Ka ngula Samuelnga tjiḻpiringu ngura pala palula. Munu paluṟu katja kutjara kanyiningi. Ka katja nyanga paluṟu pula mayatjaringu mamaku aṟangka. Palu paluṟu pula palyanyku waṟkarinytja wiya munu kutjupangku pulanya mani ungkunyangka pula palumpa kura utintja wiyangku wantipai, munu pula alatji rawangku palyaṟa ngura kuraningi alatjiṯu. Kaya Israelkunu tjuṯaku wati kuranyitja tjuṯa ngura kutju-kutjunguṟu tjunguringkula pitjangu Samuelta wangkanytjikitja, munuya wangkangu, “Nyuntu tjiḻpiringu, ka nyuntumpa katja kutjara wiṟuṟa nyinanytja wiya nyuntu puṟunypa. Palu nganaṉa mukuringanyi nyuntu nganampa mayatja puḻka tjunkunytjaku nganaṉanya mayatjarira kanyintjaku. Panya aṉangu ngura kutjupitja tjuṯaku mayatja puḻka tjuṯa nyinanyi. Ka nganaṉa nyara palu puṟunyku mukuringanyi.” Ka tjana alatji wangkanyangka Samuelnga kuliṟa pukuḻarinytja wiya, tjituṟu-tjituṟuringu. Munu paluṟu Mama Godala tjapiningi. Ka Godalu ngapartji Samuelta wangkangu, “Palya nyuntu aṉangu tjuṯangku wangkanyangka wangaṉarangku kulila, panya tjana ngayula tungunpunganyi nyuntula wiyangku. Paluṟu tjana ngayunya wantira god ngalypa-ngalypa tjuṯa palyaṉu tjananya waḻkuntjikitjangku. Palu tjapila tjanala munu nguḻutjura alatji wangkara, ‘Nyaa nyurampa mayatja panya paluṟu palyalku?’” Ka palulanguṟu Samueltu wangkangu tjanala Israelkunu tjuṯangka, “Mulapa nyura mayatjaku mukuringanyi? Ka mayatja nyara paluṟu tjinguṟu palya wiya nyurampa. Kulilaya! Wati kutjupangku nyurampa mayatja puḻka nyinara nyanga alatji palyalku — paluṟu nyurampa katja tjuṯa katiku warmaḻarira pikangku pungkunytjaku ngura kutjupitja tjuṯa. Ka nyurampa katja kutjupa tjuṯangku palumpa tjanampa tjuḻa waṟa tjuṯa palyalku munu kuḻaṯa tjuṯa kuḻu. Ka nyurampa katja kutjupatjara mayatja nyara palumpa kaana tjuṯangka puḻkaṟa waṟkariku. Ka nyurampa uṉṯalpa tjuṯangku palumpa mai kuka kuḻu tiṯutjarangku paulku pakuwiyangku. Ka paluṟu kaana mai wiṟutjara tjulyalku nyuralanguṟu munu palumpa maḻpa tjuṯa ungkuku, munu paluṟu nyurampa kaananguṟu mai wiṟu tjuṯa tjaraṟa mantjilku munu palumpa maḻpa tjuṯa tjara ungkukuṯu. Munu paluṟu mantjilku nyurampa waṟkaripai tjuṯa, munu nyurampa kuka wiṟu tjuṯa kuḻu paluṟu mantjilku palumparinytjaku. Ka palulanguṟu nyura uwankara puḻkaṟa tjituṟu-tjituṟuriku munu nyura wangkara Godala ngatjilku nyuranya alpamilantjaku. Palu Godalu kulilwiyangku wantiku. Kulini nyura? Nyangatjaṉa nyuranya nguḻutjunanyi kulintjaku.” Alatji Samueltu aṉangu tjuṯangka wangkangu. Kaya aṉangu Israelkunu tjuṯangku wangkangu, “Wiya nganaṉa mukuringanyi mayatja puḻkaku nganaṉanya mayatjarira kanyintjaku, panya aṉangu kutjupa tjuṯa mayatja puḻkatjara nyinanyi, kala nganaṉa tjana puṟunypa nyinanytjikitja mukuringanyi.” Ka paluṟu tjanampa tjukurpa uwankara Mama Godala ma-tjakultjunu. Ka Godalu ngapartji wangkangu, “Nyuntu tjanala wangaṉarangku kulila munu tjanampa mayatja mantjila.” Ka Samueltu aṉangu Israelkunu tjuṯangka wangkangu, “Palya uwankaraya ara maḻaku ngura walytjakutu walytjakutu.” ");
INSERT INTO pjt_vpl VALUES ("S19_1","010_9_1","1SA","9","1","27","Ka ngura nyara palula wati kutju nyinangi ini Kitjanya, munu paluṟu katja kutju kanyiningi ini Saulanya. Wati nyara paluṟu tangkiyi tjuṯatjara. Ka kutju-aṟa tangkiyi panya paluṟu tjana kawankatingu. Ka palumpa mamangku katjangka wangkangu, “Wati waṟka kutju mantjila munu pula ankula ngurila tangkiyi panya tjuṯa.” Palu paluṟu pula pakaṟa ankula puṯu alatjiṯu nguriningi tangkiyi panya tjuṯa. Paluṟu pula ngura tjuṯangka puṯu alatjiṯu para-nyangangi. Ka Saulalu wangkangu, “Wantir'iyaṟali maḻaku ara. Ngayuku mama tjinguṟu watarkuringu tangkiyiku munu tjinguṟu ngalinyalta puḻkaṟa kulini.” Palu wati panya waṟkaripaingku wangkangu, “Munta wanyu kulila wati kutjupa wangkatjara nyangangka nyinanyi. Nyara palulaya aṉangu tjuṯangku kulilpai, ka paluṟu uwankara tjukaṟurungku wangkapai. Wanyuli ara palulakutu. Tjinguṟu paluṟu ngalila tjakultjunkuku yaaltjikutungku ngurintjaku.” Ka Saulalu wati panya palula wangkangu, “Ka ngali palula wirkaṟa nyaa palunya ungkuku ngalila tjukaṟurungku tjakultjunkunytjaku? Panya ngali yakutja uḻṯutjara. Munu ngali kutjupa kutjupa kanyintja wiya palunya ungkunytjikitjangku.” Ka wati waṟkaripaingku wangkangu Saulala, “Nyawa, nyangatjaṉa mani tjukutjuku kanyini. Kali ungkuku wati nyara palunya, ka paluṟu ngalila tjakultjunkuku tjukaṟurungku waṉantjaku tangkiyi panya tjuṯa.” Ka Saulalu wati panya palula wangkangu, “Ai, wiṟun kulinu. Walangkuli wanyu katira uwa kalinya nintila.” Munu pula tawunukutu anu wati panya palunya nyakunytjikitja. Panya tawunu paluṟu puḻi katu ngaṟangi. Ka pula puḻingka ma-tatiṟa nguṟurpa nyangu kungkawaṟa tjuṯa mina tjutintjikitja pitjanyangka. Munu pula tjapinu wati panya palumpa. Kaya wangkangu, “Uwa, paluṟu kuranyuringu. Walangku pula waṉaṟa nyawa, panya paluṟu kuwari kutju ngalya-pitjangu nganampa tawunukutu, panya aṉangu tjuṯangkuya kuwari mai kuka puḻka palyaṉi Godanya ungkula waḻkuntjikitjangku. Wala puḻka pula ara, munu pula mapalku nyawa ankunytja kuwaripangka panya paluṟu ananyi Godanya waḻkuntjikitja. Palu aṉangu tjuṯaya ngalkuntja wiya palumpa paṯaṟa nyinanyi paluṟu wirkaṟa inma wangkara miḻmiḻmankunytjaku. Kaya palula maḻangka aṉangu tjuṯangkulta ngalkuṉi. Ka pula warpungkula nyawa.” Ka Saulanya pula tawunukutu anu munu pula ma-wirkaṟa nyangu wangkatjara panya. (Palu paluṟu pula ngurkantankunytja wiya wati nyara palunya). Panya ngaṉmanytju Godalu Samuelta nintinu wati panya Saulanya paluṟu pitjanytja kuwaripangka alatji wangkara, “Mungawinki ngayulu wati kutju nyuntulakutu iyalku. Paluṟu panya Pintjimanku walytjapitinguṟu. Ka nyuntu wati nyara palunya ngurkantara mayatja puḻka nyinanytjaku ngayuku aṉangu tjuṯaku tjananya mayatjarira aṯunymaṟa kanyintjaku mirpaṉtju tjuṯangka-tawara. Ngayulu nyangu ngayuku aṉangu tjuṯa tjituṟu-tjituṟurinyangka munuṉa kulinu tjana ngayula ulara tjapinnyangka.” Alatji Godalu palula ngaṉmanytju wangkangu mungartji. Ka Saulanya ngalya-pitjanyangka Samueltu nyangu, munu kulinu Godalu palula wangkanyangka alatji, “Nyangatja wati paluṟu, panya ngayuluṉanta ngaṉmanytju wangkangu. Nyanga paluṟu mayatjarira kanyilku aṉangu ngayuku tjuṯa.” Ka Saulanya ngalya-ilaringu Samueltakutu munu palula tjapinu, “Nyuntu ninti yaaltjingka wati wangkatjara nyinanyi?” Ka Samueltu wangkangu, “Ngayuluṉa wati wangkatjara. Ma-kuranyuri pula aṉangu nyara tjuṯakutu. Kuwarila nyara palula nyinanyi munula maingka tjunguringkula Godanya waḻkuṟa mai maḻa ngalkuṉi. Kaṉa mungawinki nyuntula tjakultjunanyi nyuntu panya kulintja uwankara. Wanti tangkiyi panya tjuṯa kulintja wiyangku, panya palunya tjananyaya kunyu nguriṟa nyangu. Palu wanyu kulila, Israelkunu tjuṯaya nyuntumpa mukuringanyi munu nyuntumpa walytja tjuṯaku kuḻu.” Ka Saulalu wangkangu, “Ai, nyaakuya ngayuku mukuringanyi? Ngayulu walytja tjuṯatjara wiya. Ngayuku walytja maṉkurpa kutju, tjuṯa mulapa wiya.” Ka Samueltu Saulanya pulanya wati panya waṟkaṟara katingu ruuma puḻkakutu munu pulanya nyinatjunu taipulangka mayatjaku aṟangka. Kaya aṉangu maṉkur-maṉkurpa nyinangi nyara palula. Ka Samueltu wangkangu wati nguratjangka panya palumpa kuka paulpaingka, “Ngalya-kati kuka panya palunya panya wangkanguṉanta mauṉṯalpa paṯaṟa tjunkunytjaku.” Ka wati panya kuka paulpaingku kuka panya tjunta mantjinu munu ngalya-katira taipulangka tjunu Saulalu ngalkuntjaku. Ka Samueltu wangkangu, “Kuka nyangatja ngalkula panya nyangatja mauṉṯalpa tjunkunytja nyuntumpa alatjiṯu.” Munuya ngalkuṉu tjungungku tjiṉṯu nyara palula. Ka pula nyanga palula maḻangka anu Samuelku ngurakutu, munu pula wangkara wiyaringkula munga kutju ngaringu. Munu tjiṟirpirinyangka Samueltu wangkangu, “Pakala pula kaṉa nyupalinya katira ma-iyala.” Munuya uṟilkutu ma-pakaṟa anu Samuelnga tjana. Ka Samueltu wangkangu Saulala, “Wanyu nyuntumpa pala waṟka kuranyurira paṯantjaku witula, kaṉa nyuntula kutjungka wangka tjukurpa nyanga Godalu wangkanytja.” ");
INSERT INTO pjt_vpl VALUES ("S110_1","010_10_1","1SA","10","1","8","Munu palulanguṟu Samueltu mantjinu patala alipa uwilatjara munu paluṟu uwila panya tjutinu Saulala katangka munu nguku kutjara nyunytjuṟa wangkangu, “Mayatja Godalu nyuntunya ngurkantanu aṉangu tjuṯa mayatjarira kanyintjaku. Nyuntu tjananya kanyilku wati mirpaṉtju tjuṯangka-tawara. Kaṉanta kuwari wangkanyi panya nyanga palulanguṟu nyuntu kuwari ngayunya wantikatira ma-pitjala nyakuku wati kutjara. Ka paluṟu pula nyuntula wangkaku alatji, ‘Tangkiyi panya nyuntu mungaṯu ngurintjanyala nyangu. Palu kuwari nyuntumpa mamangku tangkiyi kulintja wiyaringu mununta nyuntunyalta puṯu para-kuliṟa tjuṯangka para-tjapiningi, “Ngayuku katja ankula wiyaringu maḻaku pitjanytja wiya. Yaaltjiringutju?” Alatji paluṟu wangkangi.’ “Kan nyanga palulanguṟu nyuntu ankula ankula nyakuku wati maṉkurpa paluṟu tjana Godanya waḻkuntjikitja ankunyangka ngura Pitjultakutu. Ka wati kutjungku katiku mai maṉkurpa, ka kutjupangku katiku yakutja wainatjara, ka kutjupangku katiku nanikuta maṉkurpa. Munu paluṟu tjana nyuntunya nyakula nyuntumpa pukuḻariku mununtaya ungkuku mai kutjara, ka nyuntu mantjilku tjana ungkunyangka. Munun palulanguṟu piṟuku ngura ini Kipiyalakutu ilaringkula nyakuku wati wangkatjara tjuṯa nguwanpa ngalya-ngaparikatinyangka nyuntulakutu. Munun tjanala kuranyu nyakuku wati kutjupa tjuṯangku puṉu kutjupa kutjupa tjuṯa wangkatjingaṟa inma inkanyangka. Ka Kurunpa Miḻmiḻnga nyuntula tjarpaku witulya puḻkanya. Ka nyuntu wangkatjara palula tjanala tjunguringkula inma puḻkaṟa inkaku. Munu nyuntu wati kutjupariku alatjiṯu. Kan nyanga palula maḻangka nyuntulta palyala kutjupa kutjupa wiṟu nyuntu kulintja, panya Godanya nyuntula tjungu ngaṟanyi. “Ka nyuntu kuranyu ara ngura Kilkaltakutu, munu ngayuku nyinara paṯanma kaṉanta nyara palula tjiṟirpi 7-itjangku nyawa munuṉanta wangkanyilta. Munuṉa kuka pungkula tiliwakaṟa Godanya ungkuku palunya waḻkuntjikitjangku. Munuṉa ngayulu pitjala nyuntunya wangkaku nyaa palyantjaku.” Alatji Samueltu Saulala wangkangu. ");
INSERT INTO pjt_vpl VALUES ("S110_9","010_10_9","1SA","10","9","16","Ka Samueltu wangkara wiyaringkunyangka Godalu Saulanya kurunpa kampa kutjupanu. Ka palula maḻangka Saulanya pula wati panya waṟkaṟara ankula ngura panya Kipiyala wirkanu. Ka Saulalu nyangu wati wangkatjara tjuṯangku Godaku tjukurpa wangkanyangka. Ka Kurunpa Miḻmiḻnga Saulala tjarpangu, ka paluṟu wangkatjara palula tjanala tjunguringkula paluṟu kuḻu tjukurpa Godaku wangkangi Godalu palula unngu nintinnyangka. Kaya aṉangu palumpa ninti tjuṯangku palunya nyanga alatjirinyangka nyakula tjananku tjapiningi, “Nyaaringu wati pala Kitjaku katja? Paluṟu kuḻu wanyu wangkatjara?” Ka Saulalu tjukurpa Godaku wangkara wiyaringkula anu manta nyara Godanya waḻkulpailakutu. Ka Saulaku kulypalpangku palunya nyakula tjapinu, “Yaaltjikutu nyuntu anu?” Ka Saulalu wangkangu, “Ngali tangkiyi nguriningi munuli puṯu nguriṟa nguriṟa anu Samuelta tjapintjikitja.” Ka Saulaku kulypalpangku tjapinu, “Wanyuṉi tjakultjura, nyaa Samueltu wangkangu nyuntula.” Ka Saulalu wangkangu, “Wiya, nyanga alatji kutjuṉi wangkangu panya paluṟu tjana kunyu ngaṉmanytju tangkiyi nguriṟa nyangu.” Munu Saulalu palumpa kulypalpangka tjakultjunkunytja wiyangku wantingi panya Samueltu wangkanytja paluṟu Israelku mayatjarinytjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("S110_17","010_10_17","1SA","10","17","27","Ka palulanguṟu Samueltu aṉangu Israelkunu uwankara aḻṯingu tjanala wangkanytjikitjangku. Munu paluṟu tjanala tjakultjunu Godalu tjanala wangkanytja alatji, “Mayatja Godalu nyurala wangkanyi alatji, ‘Ngayulu panya nyuranya iriti pakaltjingaṉu Itjipalanguṟu, munu panyaṉa anga-ngaṟangu nyurala warmaḻangku pungkula wiyantjaku-tawara.’ Alatji Godalu wangkangu. Palu panya nyura palunya kuliṟa wantira walytjangku wangkangu alatji, ‘Wiya nganaṉa mayatja puḻkaku mukuringanyi nganaṉanya ngura nyangangka aṯunymaṟa kanyintjaku.’ Alatji nyura wangkara Mayatja Godanya wantingu.” Munu Samueltu tjananya wangkangu walytjaṟara walytjaṟara ngurkantaṟa ngaṟanytjaku kapuṯu kutjupa kapuṯu kutjupa. Munu paluṟu nyakula waṉaṟa ngurkantanu Saulaku walytja tjuṯa. Palu puṯuya nyangu Saulanya. Munuya Godala tjapinu, “Wati panya paluṟu yaaltji? Panya paluṟu wiyaṯu ngaṟanyi. Tjinguṟu kuwari pitjanyi.” Ka Godalu wangkangu, “Uwa, paluṟu kumpiṟa nyinanyi nyara kampa kutjupa ulytja tjuṯangka kumpiṟa.” Kaya mapalku wirtjapakaṉu palunya mantjintjikitja, munuya aḻṯira ngalya-katingu. Ka Saulanya pitjala ngaṟangi aṉangu tjuṯangka nguṟur-nguṟurpa waṟa puḻkanya tjanala waintaṟa. Ka Samueltu wangkangu aṉangu panya tjuṯangka, “Nyawaya wati nyangatja! Panya nyanga palunya Mayatja Godalu ngurkantanu nyurampa mayatja puḻka nyinanytjaku. Kutjupa nyanga puṟunypa nyinanytja wiya, panya nyanga paluṟu kutju Godalu ngurkantankunytja.” Kaya aṉangu uwankara mirangu pukuḻarira tjanampa mayatjaku. Ka Samueltu aṉangu tjuṯangka tjakultjunangi mayatjaku waṟka uwankara. Munu paluṟu nyiringka walkatjunu mayatja panya paluṟu nyakula waṟka palyantjaku Mama Godala miṟangka. Munu nyanga palulanguṟu tjananya wituṉu ngurakutu ankunytjaku. Ka Saulanya kuḻu palumpa ngurakutu anu wati tjuṯangka tjunguringkula, panya Godalu palunya tjananya ngurkantaṟa kurunpa rapaṉu tjungu ankunyangka. Palu aṉangu kutjupa tjarangkuya wangkangi, “Yaaltjingaṟalanya wati nyangangku aṯunymankuku?” Munuya Saulku kuraringangi munuya kutjupa kutjupa tjuṯa pukuḻarira ungkuwiyangku wantingi. Ka Saulanya pilunpa ngaṟangi wangkanytja wiya. ");
INSERT INTO pjt_vpl VALUES ("S111_1","010_11_1","1SA","11","1","15","Ka piṟa kutju wiyaringkula mayatja kutjupa ini Nayatjalu tjana palumpa tjaultji tjuṯangku para-tjaṯutjunu ngura ini Tjapitjanya, panya Israelkunu tjuṯaku ngura. Kaya wati Tjapitjanya nguraṟa tjuṯangku Nayatjala wangkangu, “Wanyula pika wiyangku nyinakatira wangkara kuliṟa kalkula. Ka tjinguṟu nyuntu nganampa mayatjarinyangka nganaṉa nyuntumpalta waṟkariku.” Ka paluṟu wangkangu, “Uwa, palyaṉa kulini nyura panya kalkuntja nyuranya iluntankuwiyangku wantinytjikitjangku, palu ngayuku warmaḻa tjuṯaṉa wangkaku nyuranya uwankara kuṟu waku warpuṟa waṉinytjaku. Alatjingannyangka kutjuṉa nyuranya uwankara pungkula iluntankunytja wiyangku wantiku. Ka nyura palulanguṟu puḻkaṟa kuṉṯaringkuku Israelkunu uwankara kuḻu.” Kaya wangkangu wati panya Nayatjala, “Wanyun paṯalku tjiṟirpi tjuṯa nguwanpa, kala iyalku wati maṉkurpa ankunytjaku ngura uwankarakutu manta nyanga Israelta, kaya nganampa walytja tjuṯangku tjinguṟu pitjala alpamilalku. Palu tjana tjinguṟu pitjanytja wiyangkampa nyura palya nganaṉanya palyaṉi nyuntu panya wangkanytjalta.” Ka Nayatjalu palyanmanu. Kaya wati panya maṉkurpa tjakulpa iyannyangka wirkanu Saulaku tjanampa ngurangka. Munuya tjakultjunu aṉangu tjuṯangka. Kaya kuliṟa nguḻuringkula puḻkaṟa ulangi. Ka Saulanya waṟka wiyaringkula ngurakutu pitjangi munu aṉangu tjuṯa ulanyangka kuliṟa kutjupangka tjapinu, “Nyaaringu nyanganpa? Nyaakuya nyanganpa ulara waṉinyi?” Kaya wangkangu Saulala, “Wati maṉkurtulanya pitjala tjakultjunu mayatja panya Nayatjalu wangkanytja.” Ka Saulalu tjukurpa nyanganpa kulinnyangka Godaku Kurunpa palula tjarpangu witulya puḻkanya munu palunya kuṉpuṉu. Ka Saulanya puḻkaṟa mirpaṉaringu. Munu paluṟu kuka panya puluka kutjara pungu munu kaṯaṟa muṯun-muṯunmanu. Munu paluṟu kuka panya muṯun-muṯunmankunytja tjaraṟa ungu wati panya tjakulpa pitjanytja maṉkurpa Munu tjananya wituṉu wangkara, “Katiraya nintila kuka nyanga kaṯantja tjuṯa ngura uwankarangka Israelta winkingka. Munuya aṉangu tjuṯangka nintiṟa wangka nyanga alatji, ‘Kuka puluka nyanga muṯun-muṯunpa nyawa. Nyanga alatjiriku nyurampa puluka uwankara nyura Samuelnga ngalinya waṉantja wiyangku wantinyangka.’” Kaya mulapaṯu wati panya maṉkurtu ankula para-tjakultjunangi ngura winkingka. Kaya aṉangu panya tjuṯa alatji wangkanyangka kuliṟa puḻkaṟa nguḻuringu Mayatja Godaku. Munuya pitjala wati uwankara warmaḻa tjunguringu mungilyi mulapa. Ka Saulalu wati panya tjakulpa ankunytja maṉkurta wangkangu, “Ankulaya wangka wati panya nyuranya wituntjala nyanga alatji, ‘Mungawinki tjiṟirpi pakaṟa kaḻaḻarinytja kuwaripangka Godalu nyuranya anga-tjutulku nyurampa mirpaṉtju tjuṯanguṟu, ka nyura wankaringkuku.’” Kaya wati panya maṉkurpa tjakulpa anu wangkanytjikitja ngura walytjakutu munuya wangkangu. Kaya kuliṟa puḻkaṟa pukuḻaringu munuya tjana ngapartji mayatja panya Nayatjala tjanala alatji ngunti wangkangu, “Mungawinkila ngura nyangatja nguraṟa uwankara nyuntulakutu ma-pitjanyi, ka nyura palya nganaṉanya kuṟu nyaala panya nyura ngaṉmanytju wangkanytjatjanungku.” Ka mungawinki Saulalu wati Israelkunu tjuṯa tjaraṟa tjunu pika pungkunytjikitja ankunytjaku kapuṯu kutjupa kapuṯu kutjupa kapuṯu kutjupa. Kaya ngalya-katjaṟungkannyangka mirpaṉtju tjuṯaku ngurangka tjarpangu tjiṉṯukutu mulapa manta maṟungka munuya tjananya pungkula pungkula wiyaṉu. Munuya palula maḻangka Samuelta wangkangu aṉangu tjuṯangku alatji, “Nganalu tjana panyatja pukuḻarinytja wiyangku wantingi Saulanya mayatjarinytjaku. Aṉangu palunya tjananyaya ngalya-kati kala iluntara.” Palu Saulalu wangkangu, “Wiya, kutjupa iluntankunytja wiyangkuya wantima, panya Godalulanya kuwari nganaṉanya wankaṟunu.” Ka palula maḻangka Samueltu wangkangu aṉangu tjuṯangka, “Pitjaltaya wala, kala ara ngura panya Godanya waḻkulpailakutu. Munula nyara palula tjunguringkula Godala piṟuku kalkula mayatja nyanga Saulala wangaṉarangku kulintjikitjangku.” Kaya aṉangu uwankara anu ngura panya palulakutu munuya Saulanya mayatja puḻka ngaṟatjunu Godala miṟangka munuya inma puḻka palyaṟa Godanya pukuḻṯu waḻkuningi. ");
INSERT INTO pjt_vpl VALUES ("S112_1","010_12_1","1SA","12","1","5","Ka Samueltu wangkangu aṉangu Israelkunu tjuṯangka, “Ngayulu palyaṉu nyura mukuringkula wangkanytja uwankara munuṉa nyurampa mayatja puḻka tjunu nyuranya aṯunymaṟa kanyintjaku. Panya ngayulu kuwari tjiḻpiringu, panya nyuranyaṉa kanyiningi wati yangupalangkulpi. Palu tjinguṟu ngayulu kura palyannyangka nyura ngayunya utingku kuranmanma. Ngayulu wanyu kutjupaku tangkiyi munu puluka kutitjunu? Munta kutjupaṉa ngunti wangkara pikantanu? Ngayulu wanyu aṉangu kutjupa tjuṯaku tjituṟu-tjituṟu palyaṉu? Ka aṉangu kutjupangkuṉi wanyu mani ungu ngayulu palumpa kura utintja wiyangku wantinytjaku? Tjinguṟu ngayulu nyanga alatji palyaṟampaṉa uti kuwariṯu tjukaṟurungku palyanma.” Kaya aṉangu Israelkunu tjuṯangku wangkangu, “Wiya, nyuntu nganaṉanya ngunti kurantja wiyaṯu, munu nyuntu nganaṉanya tjituṟu-tjituṟu palyantja wiyaṯu, munun nyuntu kutjupa kutjupa nganaṉalanguṟu mantjintja wiyaṯu.” Ka Samueltu wangkangu tjanala, “Mayatja Godalu nyuranya nyanganyi nyura alatji wangkanyangka munu nyurampa mayatjangku kuḻu nyuranya kulinu. Paluṟu pula kutjaraṯu ninti panya nyura puṯu ngayuku kura ngurkantananyi. ");
INSERT INTO pjt_vpl VALUES ("S112_13","010_12_13","1SA","12","13","25","“Ka nyangatjalta nyurampa mayatja, panya nyura mukuringkunytja Mayatja Godalu nyurampa ngurkantanu wati nyanga palunya nyuranya mayatjarira kanyintjaku ngura nyanga palula. Ka nyura uti Godanya wangaṉarangku kulinma munu palunya puḻkanmaṟa waḻkunma munu nyura uti palumpa tjukurpa mulamulangku kulinma. Tjinguṟu nyura alatji palyaṟampa nyura palya ngaṟaku. Palu nyura Mayatja Godanya wantinyangkampa munu pikaringkula palumpa tjukurta tungunpungkunyangka paluṟu ngapartji nyuranya wantiku, panya puṟunypa, panya paluṟu iriti wantir'iyaṉu nyurampa walytjapiti. “Ka nyura uti kuwari pilunarira paṯanma munuya nyangama, ka Mayatja Godalu nyurala utilku nyura nyakunytjaku. Panya kuwari nyanga mai panya wiita kaṯantjaku ilaringu. Ka ngayulu Godala tjapilku mina tuutjarangku puyintjaku. Ka nyura nyakula nintiringkuku munu nyura kulilku, ‘Nyaakula panyatja kurangku wati mayatjaku tjapinu Godala nganampa ngurkantaṟa tjunkunytjaku.’” Munu Samueltu Godala tjapinu tjiṉṯu panya palula, ka Godalu mina puḻka iyaṉu. Kaya aṉangu uwankara puḻkaṟa alatjiṯu nguḻuringu Mayatja Godaku munu Samuelku kuḻu. Munuya wangkangu Samuelta, “Wanyu Godala nganampa tjapila nganaṉa ilunytjaku-tawara. Panya nganaṉa kura puḻkangku palula mayatjaku ngatjinu.” Ka Samueltu wangkangu, “Nyura panya kura palyaningi, palu nguḻuringkuwiyangku wantima. Munuya nyanganguṟu Godalanguṟu paṯuringkunytja wiyangku wantima. Palunya kutjuya waḻkunma kurunpa winkingku munu ngalypa-ngalypa pala palyantja tjuṯa wantima ngunti waḻkulwiyangku. Panya Godalu pukuḻtjungku nyuranya ngurkantanu nyura palumpa walytjaringkunytjaku. Ka ngayulu mulapa nyurampa rawangku tjapilku wantinytja wiyangku. Ngayulu nyuranya nintilku wiṟuṟa tjukaṟuru nyinanytjaku. Ka nyura uti Godanya puḻkanmanama palunya waḻkuṟa kurunpa winkingku. Kulinmaya panya paluṟu wiṟu tjuṯa nyurampa palyaṉu. Palu nyura puṯu kuliṟa kura tjuṯa palyannyangka Godalu nyuranya uwankara wiyalku nyurampa mayatja kuḻu.” ");
INSERT INTO pjt_vpl VALUES ("S113_1","010_13_1","1SA","13","1","9","Ka ngula Saulaku katjangku munu palumpa tjaultji tjuṯangku pikangku pungangi wati Pilitjiyanya nguraṟa tjaultji tjuṯa. Kaya wati Pilitjiyanya nguraṟa kutjupa tjuṯangku kulinu munuya puḻkaṟa mirpaṉaringu Israelkunu tjuṯaku. Munuya uṯuḻuringu mungilyi mulapa wati Israelkunu tjuṯa pikangku pungkunytjikitja. Munuya tjinka winki mulata tatiṟa pitjangi. Kaya Israelkunu tjuṯangku nyangu munuya nguḻuringkula ankula ngura kutjupa kutjupa tjuṯangka kumpiningi kuḻpingka, puṉu tjaṯangka, puḻingka, wellangka, pitingka kuḻu. Kaya kutjupatjara uṟungka itipirira anu ngura kutjupakutu. Palu Saulanya nyinangi ngura panya Kilkalta, ka palumpa tjaultji tjuṯaya puḻkaṟa nguḻuringkula tjititingangi. Ka Saulanya paṯaṟa nyinangi Samuelku tjiṟirpi 7 paluṟu pitjala kuka pungkula pitjilta tjunkula tiliwakaṟa Godanya ungkunytjaku. Palu Samuelnga pitjanytja wiya. Ka Saulalu wangkangu, “Ngalya-katiya kuka tjuṯa kala pungkula Godanya ungkula waḻkula paluṟu pukuḻarinytjaku.” ");
INSERT INTO pjt_vpl VALUES ("S113_10","010_13_10","1SA","13","10","15","Ka paluṟu kuka panya pungkula pitjilta waṟungka tjunkunyangka Samuelnga wirkanu. Ka Saulanya pakaṟa ma-pitjangu palunya nyakunytjikitja. Ka Samueltu tjapinu, “Nyaa nyuntu palyaṉu?” Ka Saulalu wangkangu, “Wiya ngayuku wati tjaultji tjuṯangku ngayunya wantikatingi, ka nyuntu kuḻu pitjanytja wiya ngaṟangi. Kaya Pilitjiyanya nguraṟa tjuṯa warmaḻarira tjunguringangi ngura nganaṉala itingka. Kaṉa kulinu alatji, ‘Kuwarintiya ngayulakutu pika pungkunytjikitja pitjaku ngura nyanga Kilkaltakutu. Ka panya ngayulu Mayatja Godala tjapintja wiyaṯu. Munuṉa palulanguṟu kulinu kuka pitjilta tjunkula palunya ungkunytjikitjangku paluṟu ngayuku pukuḻarinytjaku.’” Ka Samueltu wangkangu, “Nyuntu kawakawangku alatji palyaṉu. Nyuntu Godaku tjukurpa kulintja wiya. Tjinguṟu nyuntu palunya wangaṉarangku kulinnyangka Godalu nyuntunya munu nyuntumpa walytja maḻatja maḻatja kuḻu kanyinma Israelku mayatja tiṯutjara nyinanytjaku. Palu kuwari nyuntu mayatja wiyaringanyi, ka nyuntumpa walytja maḻatja maḻatja kuḻu nyuntumpa aṟangka mayatjarira nyinakatinytja wiya. Ka Godalu kuwari ngurkantankuku wati kutjupa aṉangu tjuṯa kuranyurira kanyintjaku nyuntumpa aṟangka, wati tjukaṟuru palula kulilpai, panya nyuntun palumpa tjukurpa kulintja wiyangku wantingi.” Alatji Samueltu wangkangu Saulala, munu wangkara wiyaringkula anu ngura kutjupakutu. ");
INSERT INTO pjt_vpl VALUES ("S114_1","010_14_1","1SA","14","1","15","Ka tjiṉṯu kutjupa Saulaku katjangku Jonathantu wangkangu palumpa wati waṟka, “Pitja kali ara Pilitjiyanya nguraṟa tjuṯaku ngurakutu, nyara kampa kutjupa.” Palu Jonathantu palumpa mamangka wangkanytja wiyaṯu. Munu paluṟu wangkangu wati panya waṟkangka, “Tjinguṟu Godalu ngalinya alpamilalku tjananya pungkula wiyantjaku. Ngali kutjara kutju palu Godalu mukuringkula ngalimpa palyalku alatjiṯu, panya kutjupangku puṯu angatjunanyi Godanya.” Ka wati panyangku wangkangu, “Wiya palya. Nyuntu alatjiṯu wiṟu kuliṟa palyala, kaṉa ngayulu nyuntula tjunguṯu ma-pitjanyi.” Ka Jonathantu wangkangu, “Pitja kali ma-ilariwa nyara wati Pilitjiyanya nguraṟa tjuṯaku ngurakutu, munuli utiriwa tjana nyakunytjaku. Ka tjinguṟu tjana nyakula wangkaku, ‘Paṯaṟa pula ngaṟa pala palula, kala nganaṉa ma-pitjaku nyupalilakutu.’ Tjinguṟu tjana alatjingalku, ka ngali mulapa aṟangkaṯu paṯala tjanalakutu ankunytja wiya. Palu tjinguṟu tjana alatji wangkaku, ‘Nganaṉalakutuya pitja.’ Ka ngali apu katulta tatila. Panya alatji wangkara aḻṯinyangkali kulilku, ‘Munta mulapa Mayatja Godalu nganaṉanya alpamilalku tjananya pungkula wiyantjaku.’” Munu pula mulapaṯu utiringu tjana nyakunytjaku. Kaya mulapaṯu Pilitjiyanya nguraṟa tjuṯangku nyakula wangkangu, “Nyawa nyara wati Israelkunu tjuṯaya ma-ma-manyirkananyi aḻanguṟu pakaṟa kampangkaṯu kumpintjatjanu.” Munuya Pilitjiyanya nguraṟa tjuṯangku nyakula mirangu Jonathanku pulampa, “Ngalya-pitja pula, kala nganaṉa nyupalinya pikangku pungkula nintilku.” Ka Jonathantu wangkangu palumpa maḻpangka, “Ngalya-tatila ngayula maḻangka, panya Godalu kuwari ngalinya alpamilaṉi Pilitjiyanya nguraṟa tjuṯa pungkula wiyantjaku, kala Israelkunu tjuṯangku tjanala waintarinyi.” Munu pula ma-tatinu wanapari munu pula katulta wirkaṟa tjananya pungkula iluntanangi Pilitjiyanya nguraṟa tjuṯa. Munu pula pungkula pungkula tjuṯa mulapa iluntanangi nampa nyangatja 20. Kaya Pilitjiyanya nguraṟa tjuṯa puḻkaṟa nguḻuringkula tjititingangi ngurangka nyinanytja tjuṯa kuḻu. Ka palulanguṟu manta uringu, panya Godalu alatjingaṉu tjana nguḻuringkunytjaku. ");
INSERT INTO pjt_vpl VALUES ("S114_16","010_14_16","1SA","14","16","23","Ka Saulaku wati panya ngaṟala aṯunymankupai tjuṯangku ma-nyangu Pilitjiyanya nguraṟa tjuṯa tjanampa ngurangka nguḻuringkula mirara para-para-wirtjapakaṟinkunyangka. Ka Saulalu wati maṉkurta wangkangu, “Ngayuku tjaultji tjuṯaya para-kantamilala munuya nyawa ngananya tjanalakutu anu ngura nyanganguṟu.” Kaya kantamilaṟa mulapaṯu nyangu Jonathannga pula wiya ngaṟanyangka. Ka Saulalu wangkangu wati panya tjukurtjarangka, “Ngalya-kati pakutja panya miḻmiḻpa Godaku palula nganampa tjapintjikitjangku.” Ka Saulanya wati panya tjukurtjarangka ngaṟala wangkanyangka wati Pilitjiyanya nguraṟa tjuṯa nguḻu miranytja katuringu alatjiṯu, panya puṯu kuli-kuliṟaya puḻkaṟa alatjiṯu mirangi munuyanku ngurangka pikangkulta pungangi. Ka Saulalu nyangatja kuliṟa wangkangu wati panya tjukurtjarangka, “Palya wanti, kala mapalku ara.” Ka Saulanya tjana palumpa tjaultji tjuṯa kuḻu tjunguringkula anu pika pungkunytjikitja munuya nyara palulalta ma-wirkaṟa nyakula urulyaraṉu, “Ai, nyangatjayanku paluṟu tjanankuṯu punganyi.” Kaya Israelkunu kutjupa tjuṯa Pilitjiyanya nguraṟa tjuṯangka ngaṉmanypa tjunguringkunytjatjanu maḻaku tjunguringu Saulala tjanala munuya palunya tjananya nguḻuṟa waṯaparaṉu Pilitjiyanya nguraṟa tjuṯa. Kaya Israelkunu kutjupa tjuṯa kuḻu apungka kumpiṟa nyinangi munuya Pilitjiyanya nguraṟa tjuṯa nguḻu wirtjapakannyangka kuliṟa tjana kuḻu pitjala tjunguringu Saulala tjanala. Ka mulapa Godalu tjananya nyara palula aṟangka puḻkaṟa alpamilaṉu Israelkunu tjuṯa. ");
INSERT INTO pjt_vpl VALUES ("S114_24","010_14_24","1SA","14","24","30","Kaya wati Israelkunu tjuṯa pakuringkula uḻiringu tjiṉṯu nyara palula. Panya ngaṉmanytju Saulalu wangkara nguḻutjunu wati uwankara. Paluṟu alatji tjananya wangkara painu, “Nyura ngaṉmanytju mai ngalkuwiyangku wantima. Munuya tjananya pungkula wiyantjatjanungku kutju maḻangka palya ngalkunma. Tjinguṟu kutjupangku ngaṉmanytju ngalkulampa nyara paluṟu iluku.” Kaya wati Israelkunu tjuṯangku nguḻuringkula mai ngalkuntja wiyaṯu ngaṟangi kuwaripa. Munuya wati panya tjuṯa anu puṯikutu panya puṉu tjaṯakutu. Ka puṯi nyara tjaṯangka tjuratja mantangka ngaringi. Kaya wirkanu panya palula panya tjuratja ngarinytjala. Palu tjana mantjintja wiyaṯu panya paluṟu tjana nguḻuringangi Saulalu panya kalkuntjitjaku. Palu Jonathantu kulintja wiya palumpa mamangku Saulalu aṉangu tjuṯa wangkara nguḻutjunkunytja. Munu paluṟu watarkitjangku puṉu mantjinu, munu tjaḻatjunu tjuratjangka, munu pakaltjingaṟa anytjuṉu munu unngu wiṟuringu. Ka wati kutjungku wangkangu Jonathanta, “Kulila, nyuntumpa mamangku nganaṉala palumpa tjaultji uwankarangka nguḻutjunu alatji wangkara, ‘Wati kutjupangku mai ngalkulampa, paluṟu iluku.’ Kala kuwari mai ngalkuntja wiyanguṟu uparingulta.” Ka Jonathantu wangkangu, “Ngayuku mamangku nyangatja kura palyaṉu ngura nyangaku. Panya ngayulu kuwari palyaringu tjuratja tjukutjuku ngalkuntjatjanu. Uti nyura tjaultji tjuṯaku nguranguṟu mai ngaṉmanytju mantjintjatjanungku ngalkunma alatjiṯu. Kala tjinguṟu winki mulapa iluntanama wati panya Pilitjiyanya nguraṟa tjuṯa nganaṉa mai puḻka ngalkuntjatjanungku.” ");
INSERT INTO pjt_vpl VALUES ("S114_31","010_14_31","1SA","14","31","35","Kaya tjiṉṯu nyara palula wati Israelkunu tjuṯangku Pilitjiyanya nguraṟa tjuṯa pungkula pungkula waintaringu. Munuya palulanguṟu paku puḻka nyinangi. Munu paluṟu tjana tjanampa uwankara katingu tjiipi, puluka tjuṯa kuḻukuḻu munu tjana paḻtjatjiratjarira pungkula iluntara kuka warpungkula ngalkuṉu kurangku milkaḻi winki. Ka kutjupangku wangkangu Saulala, “Nyawa tjana kuraṉi Godanya munuya ngalkuṉi kuka milkaḻi winki.” Ka Saulalu wangkangu, “Nyura kuraringu. Apu pala puḻkaya ngalya-uṉṯuṟa waṉaṟa tjura nyangangka kuwariṯu.” Munu paluṟu wangkangu, “Ankulaya wangka wati uwankarangka, kaya puluka tjananku kutjungku kutjungku ngalya-kati tjiipi kuḻu munuya nyangangka pungkula ngalkunma. Tjana uti kuka milkaḻi winki ngalkuntja wiyangku wantima panya alatji ngalkula tjana Godanya kuraṉi.” Kaya uwankarangku kuka tjuṯa katingu nyara palulakutu munuya pungu. Ka Saulalu palyaṉu apu pitjilpa Godanya waḻkuntjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("S114_36","010_14_36","1SA","14","36","46","Palulanguṟu Saulalu wangkangu, “Arala kuwari Pilitjiyanya nguraṟa tjuṯakutu munula tjana kanyintja uwankara mantjila tjananya pungkula wiyantjatjanungku.” Kaya wangkangu, “Palya, nyuntu wangkanyangkala uwankarangku wiṟu kulini.” Palu wati panya tjukurtjarangku wangkangu, “Wiya, wanyula Godala-waraṟa tjapila, kalanya paluṟu nintilku nyaa palyantjaku.” Ka Saulalu tjapinu Godala, “Nganaṉa palya Pilitjiyanya nguraṟa tjuṯa nguḻuṟa waṉantjikitja ankuku? Ka nyuntu wanyu nganaṉanya iluntankunytjaku alpamilalku?” Alatji paluṟu Godala tjapinu. Palu tjiṉṯu nyara palula Godalu ngapartji wangkanytja wiya Saulala. Ka nyara palulanguṟu Saulalu palumpa tjaultji tjuṯaku mayatja tjuṯangka wangkangu, “Ngalya-pitjaya uwankara, kala ngurila nganalu kuwari kura palyaṉu. Munula nguriṟa nyakula wati palunya iluntankuku. Mulamulangkuṉa wangkanyi Godala miṟangka, tjinguṟu ngayuku katjangku Jonathantu kura palyaṟampa paluṟu iluku.” Palu uwankaraya wangka wiya ngaṟangi. Ka Saulalu piṟuku wangkangu wati Israelkunu tjuṯangka, “Nyura nyarangka kampa kutjupa ngaṟa. Ka ngayuku katja Jonathannga ngali kampa kutjupa nyangangka ngaṟaku. Ka Godalu kampa kutju ngurkantankuku tjinguṟu nyuranya, tjinguṟu ngalinya.” Kaya wangkangu, “Uwa palya, nyuntu wangkanyangkala palya kulini.” Ka Saulalu Mayatja Godala tjapinu wangkara, “Nintinmaṉi God tjukurpa tjukaṟuru. Nganalu kuwari kura palyaṉu?” Ka palulanguṟu puṉu ngurkantankupai kutjara katu waṉingu nyakunytjikitjangku, munuya nyangu kampa nyangatja nintinnyangka panya Saulanya pulanya katjaṟara. Kaya wati kutjupa tjuṯa ngurkantankunytja wiyaṯu ngaṟangi. Ka Saulalu wangkangu, “Piṟuku waṉi. Ka tjinguṟu ngayunya kura nyinanyangka nintilku, munta tjinguṟu ngayuku katja.” Ka arkaṟa waṉingi nyakunytjikitjangku. Ka Jonathannga ngurkantanu. Ka Saulalu wangkangu Jonathanta, “Wangkaṉi nyaan wanyu palyaṉu.” Ka Jonathantu wangkangu, “Ngayulu paḻtjatjiratjarira tjuratja puṉungka tjaḻatjunkula anytjuṉu. Munuṉa palulanguṟu kutju iluku ngayulu.” Ka Saulalu wangkangu palumpa katjangka, “Wiya nyuntu ilunyi alatjiṯu panya ngayulu kalkuṉu ngalkunnyangka iluntankunytjikitjangku. Tjinguṟu nyuntu ilunytja wiyangkampa Mamalu ngayunya iluntankuku.” Palu tjaultji tjuṯangkuya wangkangu Saulala, “Nyaakun Jonathannga iluntankuku? Paluṟu panya aṉangu Israelkunu tjuṯa kuwari wankaṟunu. Munu paluṟu uti ilunytja wiya nyinama, panya palunya Godalu alpamilaṉu alatjiṯu.” Alatjiya Jonathanku anga-wangkangu Saulala. Ka Saulalu palunya iluntankunytja wiyaṯu. Ka palula maḻangkaya piṟuku Pilitjiyanya nguraṟa tjuṯa pikangku waṯaparaṟa pungkunytja wiyangku wantingu. Munuya maḻaku anu ngura walytjakutu. ");
INSERT INTO pjt_vpl VALUES ("S114_47","010_14_47","1SA","14","47","52","Uwa, Saulanya panya mayatja puḻkaringu Israelku munu paluṟu tjaultji tjuṯatjarangku pikangku pungkupai Israelku pikaringkupai tjuṯa ngura winkingka para-arintaṟa. Munu paluṟu wati Israelkunu kutjupa kuṉpu rapa puḻka ngaṟanyangka nyakula palunya ngurkantaṟa tjungulpai palumpa tjaultji tjuṯangka tjanampa pikangku pungkunytjaku. ");
INSERT INTO pjt_vpl VALUES ("S115_1","010_15_1","1SA","15","1","3","Ka ngula Samueltu pitjala wangkangu Saulala, “Mayatja Godalu ngayunya ngaṉmanytju iyaṉu nyuntunya mayatja puḻka ngurkantaṟa tjunkunytjaku aṉangu Israelkunu tjuṯa aṯunymaṟa kanyintjaku. Ka kulila palumpa tjukurpa. Nyanga alatji paluṟu wangkanyi, ‘Iriti panyaya Israelkunu tjuṯaya ngalya-pakaṉu Itjipalanguṟu ngura Kainanku ankunytjikitja. Ka panya wati Ama-likakunu tjuṯangku tjananya angatjunangi Kainantakutu ankunyangka. Ka ngayulu nyangu tjananya alatjingannyangka munuṉa kuwari nyuranya iyaṉi ankula pikangku tjananya pungkunytjaku munu tjanampa uwankara wiyantjaku. Kutjupa wanka nyinanytjaku wantinytja wiyangku uwankara iluntaṟa wiyala wati, minyma, tjitji, munu puluka, tjiipi, munu tangkiyi, kamula kuḻukuḻu.’” Alatji Samueltu wangkangu Saulala. ");
INSERT INTO pjt_vpl VALUES ("S115_4","010_15_4","1SA","15","4","9","Ka Saulalu mulapa palumpa tjaultji tjuṯa aḻṯingu munuya tjunguringkula anu Ama-likakunu tjuṯaku ngurakutu. Munuya aṉangu tjuṯa pungkula waṉaningi munu tjananya uwankara iluntanu aṉangu panya Ama-likakunu tjuṯa. Palu Saulalu tjanampa mayatja iluntankunytja wiyangku wanka wantingi. Munu tjiipi, puluka, kaṉpi puḻka tjuṯa kuḻu iluntankunytja wiyangku wantingu munuya nyurka-nyurka tjuṯa kutju iluntanu. ");
INSERT INTO pjt_vpl VALUES ("S115_10","010_15_10","1SA","15","10","12","Ka palula maḻangka Godalu Samuelta nyanga alatji wangkangu, “Saulalu ngayula kulintja wiyangku tungunpungu. Ka ngayulu puḻkaṟa tjituṟu-tjituṟuringu panya ngayulu palunya mayatja puḻka tjukaṟuru nyinanytjaku ngurkantanu. Ka paluṟu ngayuku tjukurpa kulintja wiya alatjiṯu.” Ka Samuelnga kuliṟa unngu mirpaṉaringi Saulalanguṟu munu paluṟu ulara Mayatja Godala tjapiningi mungangka rawangku. Munu mungawinki pakaṟa anu Saulanya ngurintjikitja. Ka aṉangu kutjupangku palula wangkangu, “Wiya, Saulanya anu ngura Kaamultakutu. Munu kunyu nyara palula pitjilpa palyaṉu palumpa ruurutjara aṉangu maḻatja tjuṯangku nyakula palunya ruurungku kulintjaku. Munu kunyu palula maḻangka anu ngura Kilkaltakutu.” ");
INSERT INTO pjt_vpl VALUES ("S115_13","010_15_13","1SA","15","13","15","Ka Samuelnga ankula wirkanu Saulala. Ka Saulalu wangkangu, “Mayatja Godalu nyuntunya pukuḻmanama. Ngayulu panya Godalu wangkanyangka wangaṉarangku kulinu.” Palu Samueltu palula wangkangu, “Kaṉa nyangatja nyaaku kuwari kulini tjiipi munu puluka tjuṯa wangkara waṉinyangka.” Ka Saulalu ngapartji wangkangu, “Wiya, ngayuku tjaultji tjuṯangkuya tjiipi munu puluka kaṉpi puḻka tjuṯa ngurkantaṟa ngalya-katingu Ama-likakunu tjuṯaku nguranguṟu. Panya tjana kuka nyanga palunya tjananya pungkula ungkula Godanya waḻkuntjikitja mukuringanyi. Palu kutjupa tjuṯala pungkula wiyaṉu.” ");
INSERT INTO pjt_vpl VALUES ("S115_16","010_15_16","1SA","15","16","19","Ka Samueltu Saulanya wangkangu, “Wiyariwa munu kulila ngayulu nyuntula wangkanyangka panya Godaluṉi ngayula wangkangu mungangka.” Ka Saulalu wangkangu, “Uwa, tjakultjuraṉi.” Ka Samueltu palula wangkangu, “Panya ngaṉmanytjun nyuntu walytjangku ngaḻṯutjara kuliṟa ngaḻṯuringangi. Palu Godalu nyuntunya ngurkantanu Israelku mayatja puḻka nyinanytjaku. Munu panya paluṟu nyuntunya wituṉu ankula aṉangu nyara mamutjara tjuṯa iluntara wiyantjaku Ama-likakunu tjuṯa. Paluṟunta wangkangu tjananya uwankara alatjiṯu iluntara wiyantjaku tjanampa kuka tjuṯa kuḻukuḻu. Kan panyatja nyaaku nyuntu Mayatja Godanya kulilwiyangku wantingi? Nyaaku nyuntu tjanampa kuka wiṟu tjuṯa katingu iluntaṟa wantinytja wiyangku?” ");
INSERT INTO pjt_vpl VALUES ("S115_20","010_15_20","1SA","15","20","23","Ka Saulalu wangkangu, “Palu ngayulu Godala kuliningi. Munuṉa paluṟu wangkanytja palyaṉu. Panya aṉangu Ama-likakunu tjuṯaṉa iluntanu munuṉa tjanampa mayatja puḻka kutju wanka ngalya-katingu iluntankunytja wiyangku. Kaya tjaultji tjuṯangku kuka, puluka, tjiipi wiṟu kaṉpi puḻka tjuṯa kuḻukuḻu ngalya-katingu ngula pungkula pitjilta katu waṟungka tjunkula Godanya ungkula waḻkuntjikitjangku.” Palu Samueltu ngapartji wangkangu, “Wiya kulila, nyaaku Godanya puḻkaṟa pukuḻaripai? — kuka waṟungka kutjantjitjaku, munta palunya wangaṉarangku kulintjitjaku? Uwa, Godanya mukuringanyi nyuntu palumpa mulamularingkula wangaṉarangku kuliṟa palyantjaku paluṟu wangkanyangka. Nyanga palulanguṟu paluṟu puḻkaṟa mulapa pukuḻaripai munu panya kuka wiṟu tjuṯa ungkunyangka maḻa kutju kuliṟa tjukutjuku pukuḻaripai. “Panya nyuntu Godala wangaṉarangku kulilwiyangku wantirampa kura puḻkaringu wati panya kaṉany-kaṉanytju god ngalypa-ngalypa waḻkulpai puṟunypa. Nyuntu panya Godala kulintja wiyangku wantingu palumpa tjukurpa paluṟu wangkanytja. Palulanguṟu paluṟu kuwari ngapartji nyuntunya wantinyi mayatja puḻka nyinanytjaku wiya.” ");
INSERT INTO pjt_vpl VALUES ("S115_24","010_15_24","1SA","15","24","26","Ka Saulalu Samuelta wangkangu, “Munta, mulapa ngayulu kura palyaṉu, munuṉa ngayulu Godaku tjukurpa kuliṟa wantingu. Munuṉa nyuntu wangkanyangka palyantja wiyaṯu. Panya ngayulu aṉangu tjuṯaku nguḻuringangi munuṉa tjana wangkanyangka kutju palyaningi. Munuṉa kuwari nyuntula ngatjini ngayunya kura nyanga palyantjitjanguṟu kalypangku wantinytjaku. Wanyu pitja ngayula tjungu Kilkaltakutu, munuli Godanya waḻkula tjungungku nyuntu ngali.” Palu Samueltu wangkangu Saulala, “Wiya, ngayulu nyuntula ankunytja wiya, panya nyuntu Godaku tjukurpa kulintja wiyangku wantingu. Ka kuwari paluṟu ngapartji nyuntunya mayatja puḻka Israelku nyinanytjaku wiyaṉi.” ");
INSERT INTO pjt_vpl VALUES ("S115_27","010_15_27","1SA","15","27","31","Ka Samuelnga para-maḻakukutuṉu ankunytjikitja. Ka Saulalu palumpa mantara witinu, ka tjilpiraraṉu. Ka Samueltu wangkangu palula, “Mayatja Godalu nyuntu panya mayatja puḻka nyinanytja wiyaṉu, munu wati kutjupa ngurkantanu nyuntumpa aṟangka mayatjarira tjukaṟuru nyinanytjaku. Godanya panya mayatja puḻka mulapa, rawa nyinapai wiyaringkunytja wiya. Paluṟu ngunti wangkapai wiya. Paluṟu aṉangu mantatja puṟunypa wiya, munu paluṟu palumpa kulintja kampa kutjupankupai wiya.” Ka Saulalu ngapartji wangkangu, “Mulapa ngayulu kura palyaṉu. Palu wanyuṉi maḻaku pitja ngayula tjungu kali tjungungku Godanya waḻkunma aṉangu tjiḻpi waraṟitja tjuṯangka miṟangka munu aṉangu Israelkunu tjuṯangka miṟangka kuḻu. Kaya nyakula ngayunya palya kulilku.” Alatji Saulalu wangkangu Samuelta. Ka paluṟu mulapaṯu maḻaku anu palula tjungu munu pula Godanya waḻkuṉu aṉangu tjuṯangka miṟangka. ");
INSERT INTO pjt_vpl VALUES ("S115_32","010_15_32","1SA","15","32","35","Ka palulanguṟu Samueltu wangkangu, “Ngalya-kati wanyu wati panya Ama-likakunu tjuṯaku mayatja puḻka.” Ka mulapaṯu paluṟu pitjangu Samueltakutu puḻkaṟa tjititingkula kuliṟa, “Mulapantiṉatju kuwari iluku.” Ka Samueltu palula wangkangu, “Panya nyuntu tjuḻa puḻkangka aṉangu tjuṯa pungkula iluntanu, kaya minyma ngunytju tjuṯa tjituṟu-tjituṟuringu. Ka nyara palu puṟunypa kuwari nyuntumpa ngunytju ngapartji tjituṟu-tjituṟuriku.” Munu palulanguṟu Samueltu mayatja panya palunya kaṯaṟa muṯun-muṯunmanu. Munu palulanguṟu Samuelnga anu ngura ini Raamalakutu. Ka Saulanya anu palumpa ngurakutu. Ka Samueltu palunya piṟuku nyakunytja wiya alatjiṯu nyinara tjiḻpiringu. Ka Godanya puḻkaṟa tjituṟu-tjituṟuringu Saulaku, panya paluṟu ngaṉmanytju palunya Israelku mayatja puḻka tjukaṟuru nyinanytjaku ngurkantaṟa tjunu, palu paluṟu Godala tungunpungu. ");
INSERT INTO pjt_vpl VALUES ("S116_1","010_16_1","1SA","16","1","1","Ka ngula Mayatja Godalu Samuelta wangkangu, “Nyaakun Saulaku rawa alatjiṯu tjituṟu-tjituṟurinyi? Ma-wanti! Panya ngayulu palunya wantingu Israelku mayatja puḻka rawa nyinanytjaku-tawara. Ka kukaku pala yuṟuwilyangka alipa uwila tjutiṟa tjaalyngaṟatjuṟa kati ngura ini Pitjilimalakutu, munun nyara palulalta nyakuku wati ini Jesse-nya, panya palumpa katjaṉa ngayulu ngurkantanu Israelku mayatjarinytjaku.” ");
INSERT INTO pjt_vpl VALUES ("S116_2","010_16_2","1SA","16","2","2","Ka Samueltu alatji wangkangu, “Wiya, puṯu nguwanpaṉa alatji palyaṉi. Tjinguṟuṉitju Saulalu ankunyangka kuliṟa ngayunya iluntankuku.” Ka Mayatja Godalu palula wangkangu, “Wanyuṉi kulila munu pala puluka kuḻunypa kati Pitjilimalakutu munu wirkaṟa wati puḻka tjuṯangka alatji ma-wangka, ‘Nyangatjaṉa kuwari kuka katingu nyurala tjunguringkula pungkula pauṟa Mayatja Godanya ungkula pukuḻmankunytjikitjangku.’ ");
INSERT INTO pjt_vpl VALUES ("S116_3","010_16_3","1SA","16","3","3","Alatji tjanala wangka, munu wati ini Jesse-nya kuḻu aḻṯi nyurala tjunguringkunytjaku. Panya ngaṉmanytjuṉa wati panya palumpa katja kutju ngurkantanu Israelku mayatjarinytjaku, munuṉa kuwari nyanga katja panya palunyalta nyuntula nintini uwila palula katangka tjutintjaku.” ");
INSERT INTO pjt_vpl VALUES ("S116_4","010_16_4","1SA","16","4","4","Ka mulapaṯu Samueltu wangaṉarangku kuliṟa puluka kuḻunypa mantjiṟa ma-katingu Pitjilimalakutu. Kaya wati panya puḻka tjuṯangku ngalya-pitjanyangka nyakula ngaparikatingu palulakutu, munuya nguḻunguḻungku tjititingkula kuḻu tjapiningi palula, “Nyaa? Pikan pitjangu? Munta kalypan?” ");
INSERT INTO pjt_vpl VALUES ("S116_5","010_16_5","1SA","16","5","5","Ka Samueltu wangkangu tjanala, “Ngayuluṉa nyuralakutu kalypa alatjiṯu pitjangu nyuntu nganaṉa tjunguringkula Mayatja Godanya kuka nyangatja pungkula ungkunytjikitja. Kayanku Godala miṟangka rapa ngaṟanytjikitjangku miḻmiḻmanama, munuya palulanguṟulta ngayula tjunguriwa kuka nyangatja Mayatjanya ungkunytjikitjangku.” Alatji Samueltu tjanala wangkangu, munu palulanguṟulta Jesse-nya tjananya palumpa katja tjuṯa kuḻu aḻṯira tjananya paluṟu miḻmiḻmanu tjana kuḻu palyanyku ngaṟanytjaku. Kaya paluṟu tjana kuḻu wati panya puḻka tjuṯangkalta tjunguringu. ");
INSERT INTO pjt_vpl VALUES ("S116_6","010_16_6","1SA","16","6","6","Ka Samueltu nyangu Jesse-ku katja ngaṉmanyitja wati ini Iliyapanya, munu nyakulalta unngu kuliningi, “Ai, wati nyanga palunya alatjiṯu-manti Mayatjalumpa ngurkantanu.” ");
INSERT INTO pjt_vpl VALUES ("S116_7","010_16_7","1SA","16","7","7","Palu Mayatjalu Samuelta wangkangu, “Wiya. Nyuntu palunya nyakula alatji kulini, ‘Wati nyanga paluṟu waṟa wiṟu munu kuṉpu puḻka mulapa, nyanga palunya-manti Mayatjalumpa ngurkantanu.’ Palu nyuntu kulintja palatja, ngayulu kulintja wiya, panya aṉangungku utitja nyakupai, palu ngayuluṉa unngutja nyakupai, kurunpa unngutja. Palu wati nyangatjaṉa ngurkantankunytja wiyaṯu.” ");
INSERT INTO pjt_vpl VALUES ("S116_8","010_16_8","1SA","16","8","8","Ka Jesse-lu katja kutjupa aḻṯingu ini Apina-tapanya, ka Samuelta kuranyulta ankula ngaṟakatingu. Ka Samueltu wangkangu, “Wiya, nyanga palunya kuḻu Mayatjalu ngurkantankunytja wiyaṯu.” ");
INSERT INTO pjt_vpl VALUES ("S116_9","010_16_9","1SA","16","9","9","Ka Jesse-lu piṟuku wangkangu katja kutjupa ini Tjaamanya Samuelta kuranyu ankula ngaṟanytjaku, ka wangkangu, “Wiyaṯu, nyanga paluṟu kuḻu wiya.” ");
INSERT INTO pjt_vpl VALUES ("S116_10","010_16_10","1SA","16","10","10","Ka piṟuku Jesse-lu wangkangu katja kutjupa tjuṯangka ngapartji ankula Samuelta kuranyu ngaṟanytjaku wanapari wanapari katja panya 4-palangka, palu Samueltu tjananya uwankara nyakula waṉaṟa wangkangu, “Wiya, katja nyanga 7-pa uwankaraṯu Mayatja Godalu ngurkantankunytja wiya.” ");
INSERT INTO pjt_vpl VALUES ("S116_11","010_16_11","1SA","16","11","11","Munu Samueltu Jesse-la tjapinu, “Nyuntu katja kutjupa kanyini?” Ka Jesse-lu wangkangu, “Uwa, kutjultatju nyinanyi maḻatja. Nyara paluṟu panya yangupala tjukutjuku. Paluṟu ilytjingka tjiipi tjuṯa kanyini.” Ka Samueltu wangkangu, “Wanyu wati kutjupa witula palunya aḻṯira ngalya-katinytjaku. Kala paluṟu pitjanyangka kutju kuka panya pungkula paulku.” ");
INSERT INTO pjt_vpl VALUES ("S116_12","010_16_12","1SA","16","12","12","Ka mulapaṯu Jesse-lu wituṉu palumpa panya katja maḻatjaku Davidaku. Ka ankula mantjiṟa palunya ngalya-katingu. Panya paluṟu yangupala kuṉpu puḻka, yunpa wiṟu mulapa, kuṟu kuḻu kaḻṯaṟa wiṟutjara. Ka Mayatja Godalu Samuelta wangkangu, “Pala paluṟu! Ka nyuntu uwila tjutila palumpa katangka, kaya Israelkunu tjuṯangku nyakulalta kulilku, ‘Mulapa nyanga palunya panya Godalu ngurkantanu nganampa mayatjarira nyinanytjaku.’” ");
INSERT INTO pjt_vpl VALUES ("S116_13","010_16_13","1SA","16","13","13","Ka palulanguṟu Samueltu yuṟuwilya panya alipa uwiltjara mantjinu munu kuṯa tjuṯangka miṟangka Davidala katangka uwila tjutinu. Ka mapalku alatjiṯu Mayatjaku kurunpa palula tjarpangu munu nyara palulanguṟu rawa alatjiṯu palula tjungu nyinangi. Kaya palulanguṟu kuka pungkula pauṟa tjara tjunu Godaku munuya tjara kutjupa ngalkunu. Ka palula maḻangka Samuelnga ngurakutu maḻaku anu, Raamalakutu. ");
INSERT INTO pjt_vpl VALUES ("S116_14","010_16_14","1SA","16","14","14","Ka Mayatja Godaku kuruntu Saulanya wantikatingu, munu Godalu kurunpa kutjupa palulakutu iyaṉu mamu palula tjungu nyinanytjaku, munu palunya nguḻutjingantjaku. ");
INSERT INTO pjt_vpl VALUES ("S116_15","010_16_15","1SA","16","15","15","Ka Saulaku waṟkaripaingku palula wangkangu, “Kulila, kurunpa kutjupangkunta nyuntunya nguḻutjingaṉi mamungku panya Godalu iyantjitjangku. ");
INSERT INTO pjt_vpl VALUES ("S116_16","010_16_16","1SA","16","16","16","Wanyula wati kutjupa ngurilku, kita wiṟuṟa wangkatjingalpai inma mayu wiṟutjara, ka mamungku nyuntunya nguḻutjingannyangka wati paluṟulta nyuntumpa wangkatjingalku, kan kuliṟalta palyaringkuku.” ");
INSERT INTO pjt_vpl VALUES ("S116_17","010_16_17","1SA","16","17","17","Ka Saulalu wangkangu, “Uwa, palya. Nguriṟaya ngalya-kati.” ");
INSERT INTO pjt_vpl VALUES ("S116_18","010_16_18","1SA","16","18","18","Ka wati waṟka kutjupangku wangkangu Saulala, “Wati ini Jesse-ku katja Bethlehemala nyinanyi — nyara paluṟu kita wiṟuṟa wangkatjingalpai. Paluṟu wati tjaultji rapa mulapa munu yunpa wiṟu mulapa munu wiṟuṟa wangkapai ka Mayatja Godanya palula tjungu nyinanyi.” ");
INSERT INTO pjt_vpl VALUES ("S116_19","010_16_19","1SA","16","19","19","Ka Saulalu wati tjakulpa iyaṉu Jesse-lakutu munu wangkangu alatji, “Saulalu wangkangu nyuntumpa katja kunyu iyala Davidanya panya tjiipi aṯunymankupainya.” ");
INSERT INTO pjt_vpl VALUES ("S116_20","010_16_20","1SA","16","20","20","Ka Jesse-lu mai nyuma tjuṯa munu waina tjuṯa kuḻu mantjiṟa yakutjangka karpiṟa tangkiyingka tjunu munu palulanguṟu nanikuta yangupala witiṉu. Munu Davidanya wangkangu Saulalakutu katinytjaku. ");
INSERT INTO pjt_vpl VALUES ("S116_21","010_16_21","1SA","16","21","21","Ka mulapaṯu Davidalu Saulanya katira ungu munu palumpa tjaatarira waṟkaringi. Ka Saulalu palunya nyangangi wiṟuṟa waṟkarinyangka munu puḻkaṟa pukuḻaringu, munu palunya waṟka kutjupalta ungu palumpa kuḻaṯa, munu tjula waṟa, kuṯitji kuḻu para-katiṟinkunytjaku. ");
INSERT INTO pjt_vpl VALUES ("S116_22","010_16_22","1SA","16","22","22","Ka tjiṉṯu kutjupa Saulalu piṟuku wati kutjupa iyaṉu Jesse-lakutu nyanga alatji wangkanytjaku, “Puḻkaṟaṉa mukuringanyi nyuntumpa katjaku. Wanyu wiṟungku wantima ngayula rawa nguwanpa nyinanytjaku.” Ka mulapaṯu mamangku panya palunya markuṉu. ");
INSERT INTO pjt_vpl VALUES ("S116_23","010_16_23","1SA","16","23","23","Ka mamuku kuruntu Saulanya nguḻutjingannyangka Davidalu kita wangkatjingaṟa inkapai, ka mulapaṯu wangkatjingannyangka paluṟu palyaringkupai, ka mamungku palunya wantikatipai. ");
INSERT INTO pjt_vpl VALUES ("S117_1","010_17_1","1SA","17","1","1","Kaya wati Pilitjiyanya nguraṟa tjuṯa warmaḻarira anu tawunu ini Tjakulakutu manta panya Judah-lakutu Israelkunu tjuṯa pungkunytjikitja. Munuya ilaringkula putingka ngura tjunu ngura ini Ipitja-Tamimila ngura ini Tjakula pulala Atjikala nguṟurpa. ");
INSERT INTO pjt_vpl VALUES ("S117_2","010_17_2","1SA","17","2","3","Kaya Saulanya tjana Israelkunu tjuṯa ngapartji warmaḻarira anu munuya wimaṟu ini Iilala ma-wirkanu puḻi katu munuya ngura tjunkula ritiringangi Pilitjiyanya nguraṟa tjuṯa pikangku pungkunytjikitja panya tjanaya wimaṟu kampa kutjupangka nyinangi. ");
INSERT INTO pjt_vpl VALUES ("S117_4","010_17_4","1SA","17","4","4","Ka wati nyara palula tjanala tjungutja wati tjangaṟa waṟa puḻka mulapa nyinangi 3 metre nguwanpa. Nyara paluṟu panya ini Kalaitjanya tawunu ini Kaatjanya nguraṟa. ");
INSERT INTO pjt_vpl VALUES ("S117_5","010_17_5","1SA","17","5","5","Paluṟu ayananguṟu palyantja mukaṯa wituwitu katangka kanyiningi munu kuuta ngapartji palu puṟunypaṯu ayananguṟu palyantja kuṉpu puḻka kanyiningi 57 kilogram. ");
INSERT INTO pjt_vpl VALUES ("S117_6","010_17_6","1SA","17","6","6","Munu paluṟu tjaḻpangka kuḻu palu puṟunypaṯu ayana wituwitu tjunkula kanyiningi. Munu tjaṉangka kuḻaṯa waṟa karpintja kanyiningi. ");
INSERT INTO pjt_vpl VALUES ("S117_7","010_17_7","1SA","17","7","7","Ka palumpa kuḻaṯa waṟa mulapa waṯa puḻkatjara. Waṯa paluṟu ayananguṟu palyantja kuṉpu mulapa 7 kilogram. Ka wati kutjupangku Kalaitjala kuranyu ankula palumpa kuṯitji katipai. ");
INSERT INTO pjt_vpl VALUES ("S117_8","010_17_8","1SA","17","8","8","Ka tjangaṟa panya Kalaitjalu ngaṟala mirara wangkangi wati Israelkunu tjuṯangka, “Awa! Ngayuku nyura tjaṯuringanyi ngayunya pungkunytjikitja? Wiya, ngayuluṉa miriputju alatjiṯu ka nyura wiya nguwanpa Saulaku kutju waṟkaripai. Palu wati kuṉpuyanku nyuralanguṟu ngurkantaṟa ngalya-iyala ngayula pikaringkunytjaku ");
INSERT INTO pjt_vpl VALUES ("S117_9","010_17_9","1SA","17","9","9","Ka paluṟu ngayunya iluntankunyangkampa warmaḻa nyanga ngayuku tjuṯa nyurampariku, palu ngayulu wati palunya iluntankunyangkampa nyura nganampariku.” ");
INSERT INTO pjt_vpl VALUES ("S117_10","010_17_10","1SA","17","10","10","Munu tjangaṟa panya paluṟu kaṉany-kaṉanytju wangkangi, “Iii! Walangkuwi pikaṯi palunya ngalya-walatjura ngayunya pungkunytjaku kaṉa palunya wiyalku alatjiṯu.” ");
INSERT INTO pjt_vpl VALUES ("S117_11","010_17_11","1SA","17","11","11","Ka paluṟu mirara pauntjingaṟa wangkanyangka Saulanya tjana kuliṟa puḻkaṟa nguḻuringkula tjititingangi. ");
INSERT INTO pjt_vpl VALUES ("S117_12","010_17_12","1SA","17","12","12","Ka Davidaku mama Jesse-nya wati panya Ipaṟakunu tawunu Bethlehemanya nguraṟa manta panya Judah-la nguṟurpa nyinangi. Wati tjiḻpi paluṟu katja 8-tjara. ");
INSERT INTO pjt_vpl VALUES ("S117_13","010_17_13","1SA","17","13","14","Panya palumpa katja ngaṉmanyitja ini Iliyapanya, ka paluṟu pininu ini Pinatapanya, ka Pinatapalu pininu Tjaamanya. Katja nyanga maṉkurpaya ngaṉmanypa tjunguringu Saulaku warmaḻa tjuṯangka munuya paṯaṟa nyinangi wati warmaḻa Pilitjiyanya nguraṟa tjuṯa pungkunytjikitja. Ka Davidanya panya Jesse-ku katja maḻatja. ");
INSERT INTO pjt_vpl VALUES ("S117_15","010_17_15","1SA","17","15","15","Paluṟu panya palumpa mamaku tjiipi tjuṯa aṯunymankupai ngura Bethlehemala itingka munu kutjupa-aṟa ankula kuṯa tjuṯa nyakupai tjana pikakitja paṯaṟa nyinanyangka, munu nyakula maḻaku ankupai ngurakutu tjiipi panya tjuṯa kanyintjikitja. ");
INSERT INTO pjt_vpl VALUES ("S117_16","010_17_16","1SA","17","16","16","Ka wati panya Kalaitjanya mungawinki tiṯutjara mungartji tiṯutjara tjiṉṯu 40-aṟa alatjiṯu ngaṟala ngalytjurmaṟa mirara wangkangi alatji, “Wati pala nyurampa tjuṯayanku ngalya-walatjura ngayunya pitjala pungkunytjaku.” ");
INSERT INTO pjt_vpl VALUES ("S117_17","010_17_17","1SA","17","17","17","Ka tjiṉṯu kutjupa Jesse-lu wangkangu Davidala, “Kuṯanya tjana nyara warmaḻa tjuṯangka tjungu nyinanyi patu, ka walangku wanyu mai nyanga tjanampa ma-kati. Nyangatja mai uṉinypa pauntja 10 kilogram munu mai nyuma 10-pa. ");
INSERT INTO pjt_vpl VALUES ("S117_18","010_17_18","1SA","17","18","18","Munu tjiitja nyanga tjuṯa kuḻu katira nyuntumpa kuṯa tjuṯaku mayatja uwa. Munu tjanala ma-tjapila, ‘Palya nyura nyinanyi?’ Munu tjana wangkanyangka kuliṟa pitjalaṉi tjakultjura.” ");
INSERT INTO pjt_vpl VALUES ("S117_19","010_17_19","1SA","17","19","19","Kaya mayatja Saulanya tjana Davidaku kuṯa tjuṯa kuḻuya wati warmaḻa winkitjara paṯaṟa nyinangi wimaṟu ngura ini Iilala Pilitjiyanya nguraṟa tjuṯa pungkunytjikitja. ");
INSERT INTO pjt_vpl VALUES ("S117_20","010_17_20","1SA","17","20","20","Ka Davidalu palumpa mamangka wangaṉarangku kulinu munu munga-mungangka pakaṟa wati kutjupa aḻṯingu pitjala tjiipi kanyintjaku. Munu mai panya tjuṯa mantjiṟa anu warmaḻa tjuṯaku ngurakutu. Munu tjanampa ngurangka wirkaṟa ma-nyangu tjana pikakitja ma-pakannyangka. Tjanayanku kuṉpuringkunytjikitja mirara waṉingi. ");
INSERT INTO pjt_vpl VALUES ("S117_21","010_17_21","1SA","17","21","21","Munuya wati panya Israelkunu tjuṯangku ngura tjananku wantikatira wimaṟungka ngalya-ukalingu tjanalakutu, kaya Pilitjiyanya nguraṟa tjuṯa ngapartji ngalya-pitjangiṯu, munuya nguṟurpa ngaṟangu pikakitja, munuyanku ngaparku nyangangi. ");
INSERT INTO pjt_vpl VALUES ("S117_22","010_17_22","1SA","17","22","22","Ka Davidalu mai ungkukatingu wati tjanampa mai aṯunymankupai, munu wirtjapakaṉu kuṯa tjuṯa tjapiṟa kulintjikitja, “Palya nyura?” ");
INSERT INTO pjt_vpl VALUES ("S117_23","010_17_23","1SA","17","23","23","Ka Davidanya ngaṟala kuṯa tjuṯangka wangkanyangka wati Pilitjiyanya nguraṟa wati panya Kalaitjanya ngalya-kuranyuringu tjanalakutu munu mirangu wati Israelkunu kutju ngalya-walatjunkunytjaku paluṟu pulanku pungkunytjikitjangku. Ka Davidalu miranyangka kulinu. ");
INSERT INTO pjt_vpl VALUES ("S117_24","010_17_24","1SA","17","24","24","Kaya Israelkunu tjuṯangku wati panya Kalaitjanya ngaṟala miranyangka kuliṟa nguḻu maḻaku ma-wirtjapakaṉu ngurakutu. ");
INSERT INTO pjt_vpl VALUES ("S117_25","010_17_25","1SA","17","25","25","Munuyanku ngaparku wangkangi, “Panya paluṟu rawangku tjiṉṯu winkingku nganaṉanya nguḻutjingaṟa pikangku wangkanyi. Ka Saulalu nganaṉala wangkangu alatji, ‘Wati kutjupangku tjinguṟu ankula palunya iluntankunyangkampa ngayulu palunya wiṟu mulapalta ungkuku, munuṉa ngayuku uṉṯalpa kuri aḻṯinytjaku ungkuku. Ka paluṟu munu palumpa walytjapiti uwankarangku ngayunya tax mani rawangku ungkunytja wiyaringkuku.’ Alatji Saulalu wangkara kalkuṉu.” ");
INSERT INTO pjt_vpl VALUES ("S117_26","010_17_26","1SA","17","26","26","Ka Davidalu wati tjaultji kutju ila ngaṟanyangka tjapinu munu wangkangu, “Wati warmaḻa nyarangkulanya puḻkaṟa nguḻutjingaṟa kuraṉi aṉangu Israelkunu tjuṯa. Ka uti wati kutjupangku wati nyara palunya iluntankuku, ka piṟuku ngalya-ngaṟala ngalytjurmaṟa miranytja wiyaringkuku. Palu nganampa Mayatjangku nyaa ungkuku wati kutjupangku palunya iluntankunyangka?” ");
INSERT INTO pjt_vpl VALUES ("S117_27","010_17_27","1SA","17","27","27","Ka wati tjaultji paluṟu Davidala tjukurpa panya palunyaṯu wangkangu, panya mayatja Saulalu ungkunytjikitjangku kalkuntja. ");
INSERT INTO pjt_vpl VALUES ("S117_28","010_17_28","1SA","17","28","28","Ka Davidaku kuṯa Iliyapalu kulinu paluṟu tjaultjingka wangkanyangka munu mirpaṉarira palunya wangkangi, “Nyaakun tjaultji tjuṯangka ngaṟala wangkanyi? Nyuntu uti anama ngurakutu tjiipi panya tjuṯa kanyintjikitja. Kuran pitjangu wati Israelkunu tjuṯa tjananku pikangku pungkunyangka nyakunytjikitja wati warmaḻa Pilitjiyanya nguraṟa tjuṯangku.” ");
INSERT INTO pjt_vpl VALUES ("S117_29","010_17_29","1SA","17","29","29","Ka Davidalu wangkangu, “Wiya. Ngayuluṉa kutjupa kutjupa kurantja wiyaṯu. Tjapiningi kutjuṉa.” ");
INSERT INTO pjt_vpl VALUES ("S117_30","010_17_30","1SA","17","30","30","Ka Davidalu tjaultji kutjupangka piṟuku tjapinu, ka tjukurpa panya palunyaṯu wangkangu panya tjaultji kutjupangku ngaṉmanytju wangkanytjanya. ");
INSERT INTO pjt_vpl VALUES ("S117_31","010_17_31","1SA","17","31","31","Ka tjaultji panya paluṟu Davidala kulintjatjanungku ankula Saulala tjakultjunu, ka paluṟu Davidanya aḻṯinytjaku wituṉu. ");
INSERT INTO pjt_vpl VALUES ("S117_32","010_17_32","1SA","17","32","32","Ka paluṟu wirkaṟa Saulala wangkangu, “Utila wati nyara palunya nguḻu wiyangku rapangku pungama. Wanti kaṉa ngayulu palunya iluntara.” Alatji Davidalu wangkangu. ");
INSERT INTO pjt_vpl VALUES ("S117_33","010_17_33","1SA","17","33","33","Ka Saulalu palula wangkangu, “Wiya nyuntu yangupala kuḻunypa, nyuntu puṯu palunya punganyi. Wati kuṉpu puḻka mulapa nyaratja. Paluṟu tjaultji rawa mulapa nyinanytja tjitjinguṟu alatjiṯu.” ");
INSERT INTO pjt_vpl VALUES ("S117_34","010_17_34","1SA","17","34","34","Ka Davidalu wangkangu Saulala, “Ngayulu ngayuku mamaku tjiipi aṯunymankupai, ka lionpangku munu bearangku pitjala tjiipi patjaṟa katipai, ");
INSERT INTO pjt_vpl VALUES ("S117_35","010_17_35","1SA","17","35","36","kaṉa waṉaṟa inuṟa palunya tjananya pungkupai alatjiṯu, kaya wantikatira nguḻu wirtjapakalpai. Palu liontu munta bearangku ngayunya arkaṟa patjannyangkaṉa ngayulu lirintaṟa iluntankupai. Munuṉa ngayulu wati nyara kurakura palu puṟunypaṯu palyalku. Paluṟu panya wati Godaku walytja tjuṯa tiṯutjarangku kuraṟa punganyi. ");
INSERT INTO pjt_vpl VALUES ("S117_37","010_17_37","1SA","17","37","37","Panya ngaṉmanytjuṉi ngayunya Mayatja Godalu wankaṟunu liontu bearangku patjantjaku-tawara munuṉi palu puṟunypaṯu kuwari wankaṟunkuku wati nyara tjangaṟa paluṟu ngayunya iluntankunytjaku-tawara.” Ka Saulalu kuliṟa palyanmanu, “Palya. Ankula palunya puwa, kaṉanku Mayatja Godala tjapilku nyuntunya ilangku ma-katinytjaku.” ");
INSERT INTO pjt_vpl VALUES ("S117_38","010_17_38","1SA","17","38","39","Munu Saulalu palumpa mantara panya kuṉpu ungu Davidanya tjarpanytjaku. Ka paluṟu mukaṯa ayananguṟu palyantja katangka tjarpatjunu munu kuuta ayanatjara karpinu munu tjuḻa waṟa kaṟilta karpiṟa tanpaṉu, munu arkaṟa ma-pitjangu. Palu paluṟu puṯu nguwanpa anangi ulytja puḻkatjara, panya paluṟu ngurpa nyara palu puṟunypa tjuṯaku. Munu paluṟu wangkangu Saulala, “Wiya ulytja nyanga kuṉpu tjuṯatjarangkuṉa puṯu punganyi. Ngurpaṉa kuṉpu puḻka kanyilpai wiya.” Munu paluṟu araltjaṟa wantikatingu. ");
INSERT INTO pjt_vpl VALUES ("S117_40","010_17_40","1SA","17","40","40","Munu Davidalu tjukara munu tjangaya paluṟunku mantjiṟa ma-pakaṉu, munu karuwanu ma-itipirira puḻi wiṟuly-wiṟulypa kutjara maṉkurpa mantjiṟa yakutjangka tjarpatjunu munu wati panya palulakutu ma-ilaringu Kalaitjalakutu. ");
INSERT INTO pjt_vpl VALUES ("S117_41","010_17_41","1SA","17","41","41","Ka wati paluṟu ngapartji ngalya-ilaringuṯu, ka tjaultji panya palumpa kuṯitji katipai palula kuranyu tjunguṯu pitjalinangi. ");
INSERT INTO pjt_vpl VALUES ("S117_42","010_17_42","1SA","17","42","43","Ka Kalaitjalu ngalya-ilaringkula nyakula kulinu, “Munta, tjitji nyiiṉkampal nyangatja.” Munu paluṟu anaṟa ikaringangi, “Ngayulakutuntaya wituṟa iyaṉu tjitji tjukutjuku?” Munu paluṟu Davidanya wangkangu, “Puṉutjara pitjanytja wiya! Ngayulu papa wiya.” Munu paluṟu Pilitjiyaku godangka wangkangu Davidanya pikantankunytjaku. ");
INSERT INTO pjt_vpl VALUES ("S117_44","010_17_44","1SA","17","44","44","Munu Kalaitjalu mirara wangkangu Davidanya, “Walaltatju pitja kaṉanta pungkula waṉi tjuḻpungku inuṟangku ngalkuntjaku.” ");
INSERT INTO pjt_vpl VALUES ("S117_45","010_17_45","1SA","17","45","45","Ka Davidalu Kalaitjanya alatji wangkangu, “Munta, nyuntu-mantin tjuḻatjara kuḻaṯatjara pitjanyi ngayunya iluntankunytjikitja, palu ngayulu nyuntula pikaringkunyangka Mayatja Godalu witulya puḻkangku ngayunya alpamilaṉi, Israelkunu tjuṯaku panya mayatjangku. Ka nyuntu tjananya kuraṟampa palunya kuḻu kuraṉi. ");
INSERT INTO pjt_vpl VALUES ("S117_46","010_17_46","1SA","17","46","46","Ka kuwari paluṟu ngayunya alpamilaṉi nyuntunya wiyantjaku. Ngayulu nyuntunya atuṟa punkatjingaṟa kata kaṯalku munuṉa kutjupa pala tjuṯa kuḻu tjunguṟa wiyalku uwankara tjuḻpungku inuṟa tjuṯangku ngalkuntjaku. Kaya nyanga palulanguṟu manta winkitjangku kulilku panya Israelkunu tjuṯaku God kuṉpu puḻkanya. ");
INSERT INTO pjt_vpl VALUES ("S117_47","010_17_47","1SA","17","47","47","Ka aṉangu nyangantu kulilku Mayatja Godalu tjulangka kuḻaṯangka wankalpai wiya. Paluṟu tiṯutjara alatjiṯu waintaripai pikangka munulanya kuwari paluṟu alpamilalku nyuranya pungkula wiyantjaku.” Alatji Davidalu Kalaitjala wangkangu. ");
INSERT INTO pjt_vpl VALUES ("S117_48","010_17_48","1SA","17","48","48","Ka wati panya paluṟu Davidalakutu ngalya-ilaringu, ka Davidanya mapalku palulakutu ma-wirtjapakaṉu. ");
INSERT INTO pjt_vpl VALUES ("S117_49","010_17_49","1SA","17","49","49","Munu puḻi yakutjanguṟu mantjinu munu tjangayangka tjunkula uritjingaṟa Kalaitjanya ngalya atuṉu, ka puḻi palula tjarpangu alatjiṯu, ka yunpanguṟu mantangka punkaṉu. ");
INSERT INTO pjt_vpl VALUES ("S117_50","010_17_50","1SA","17","50","50","Uwa nyangatja Davidalu Kalaitjanya tjangayangka kutju atuṟa iluntanu tjuḻangka wiya. ");
INSERT INTO pjt_vpl VALUES ("S117_51","010_17_51","1SA","17","51","51","Munu paluṟu palulakutu mapalku wirtjapakaṟa tjula panya palumpa mantjinu munu kata kaṯaṉu. Kaya Pilitjiyanya nguraṟa tjuṯangku palunya kata kaṯannyangka nyakula nguḻu wirtjapakaṉu. ");
INSERT INTO pjt_vpl VALUES ("S117_52","010_17_52","1SA","17","52","52","Kaya Israelku tjaultji tjuṯangku munu Judah-ku tjaultji tjuṯangku puḻkaṟa mirara nguḻuṟa ma-watarparaṉu warmaḻa panya tjuṯa ngura ini Kaatjalakutu munu tawunu ini Ikaṟantakutu. Munuya uwankara alatjiṯu iluntara wiyalkatingi, kaya ilunytja iwarangka ma-ngarira waṉaningi tawunu ini Tjaaṟaimalanguṟu tawunu ini Ikaṟantakutu munu Kaatjalakutu kuḻu. ");
INSERT INTO pjt_vpl VALUES ("S117_53","010_17_53","1SA","17","53","53","Munuya wiyaringkula ngapari pitjala Pilitjiyanya nguraṟa tjuṯaku ngura uḻṯungka tjarpara kutjupa kutjupa uwankara tjana wantikatinytja mantjiṟa katingu tjanampa ngurakutu. ");
INSERT INTO pjt_vpl VALUES ("S117_54","010_17_54","1SA","17","54","54","Ka Davidalu Kalaitjanya kata mantjiṟa katingu Jerusalemalakutu munu palumpa panya ulytja tjuṯa kuḻu paluṟu mantjinu munu palumpa tiintangkalta tjunkula wantingu. ");
INSERT INTO pjt_vpl VALUES ("S117_55","010_17_55","1SA","17","55","55","Ka Saulalu Davidanya pika ankunyangka nyangangi wati Kalaitjaku, munu paluṟu wati tjaultji tjuṯaku mayatjangka tjapinu wati ini Apanala. “Wati nyanga yangupalampa nganaku katja?” Ka wangkangu, “Wampa, ngurpaṉa.” ");
INSERT INTO pjt_vpl VALUES ("S117_56","010_17_56","1SA","17","56","56","Ka Saulalu wituṉu, “Ankula tjapiṟa kulila.” ");
INSERT INTO pjt_vpl VALUES ("S117_57","010_17_57","1SA","17","57","57","Ka Davidanya ngurakutu maḻaku aṟuringu wati panya Kalaitjanya iluntankunytjatjanu kata winkitjara. Ka wati panya Apananya palulakutu ngaparikatingu munu palunya katingu Saulalakutu kata winkitjara. ");
INSERT INTO pjt_vpl VALUES ("S117_58","010_17_58","1SA","17","58","58","Ka Saulalu tjapinu Davidanya, “Wati ngana! Wanyuṉi tjakultjura! Nganaku katjan?” Ka paluṟunku utiṟa tjakultjunu, “Ngayuluṉa Jesse-ku katja maḻatja. Nganaṉa panya Bethlehemanya nguraṟa.” ");
INSERT INTO pjt_vpl VALUES ("S118_1","010_18_1","1SA","18","1","1","Ka paluṟu pula wangkara wiyaringkunyangka Saulaku katja Jonathannga Davidaku maḻparingu munu paluṟu Davidaku puḻkaṟa alatjiṯu mukuringangi. ");
INSERT INTO pjt_vpl VALUES ("S118_2","010_18_2","1SA","18","2","2","Ka tjiṉṯu nyanga palulanguṟu Saulalu palunya rawangku kanyiningi mamakutu iyantja wiyangku. ");
INSERT INTO pjt_vpl VALUES ("S118_3","010_18_3","1SA","18","3","3","Ka Jonathannga Davidaku puḻkaṟa mukuringkula palunya kalkuṉu pula tjungu maḻpaṟara tiṯutjara nyinanytjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("S118_4","010_18_4","1SA","18","4","4","Munu palulanguṟu kuuta aṉangitja araltjaṟa Davidanya ungu, mantara panya pikakitja paluṟu tjarpapainya kuḻu, munu tjula waṟa, punaṟa, pilta kuḻu palunya ungu. ");
INSERT INTO pjt_vpl VALUES ("S118_5","010_18_5","1SA","18","5","5","Ka Saulalu Davidanya rawangku iyaningi tjaultji tjuṯatjara ankula aṉangu kutjupa tjuṯangka pikaringkunytjaku mirpaṉtju panya tjuṯangka. Kaya paluṟu tjana tiṯutjarangku alatjiṯu pungkukatingi. Ka palulanguṟu Saulalu Davidanya ngurkantaṟa tjunu palumpa tjaultji tjuṯa mayatjangku kanyintjaku, kaya wati tjaultji tjuṯa palumpa puḻkaṟa pukuḻaringi, munuya palumpa tjanampa mayatja-mayatja tjuṯa kuḻu palumpa pukuḻaringi. ");
INSERT INTO pjt_vpl VALUES ("S118_6","010_18_6","1SA","18","6","6","Ka Davidalu Kalaitjanya iluntankunyangka maḻangka tjaultji panya tjuṯa ngura walytjakutu walytjakutu anangi. Kaya Saulanya tjana ngura tjuṯangka wirkankunyangka minyma tjuṯa tjanampa nyakula puḻkaṟa pukuḻarira mirawaṉingi, munuya inma pukuḻṯu inkara nyaṉpiṟa wangkatjingaṟa waḻkuningi. ");
INSERT INTO pjt_vpl VALUES ("S118_7","010_18_7","1SA","18","7","7","Alatjiya wangkara inkangi, “Saulalu warmaḻa tjuṯa iluntanu tjinguṟu nampa nyangatja 1,000, palu Davidalu mungilyi mulapa iluntanu nampa nyangatja 10,000!” ");
INSERT INTO pjt_vpl VALUES ("S118_8","010_18_8","1SA","18","8","8","Ka Saulalu inma nyangatja kulinu munu puḻkaṟa mirpaṉaringu, munu unngu kuliningi, “Ai! Davidanyaya nyangantu puḻkaṟa mirawaṉinyi paluṟu winki nyaṟuntja ngayula muṉkara. Tjinguṟuya mukuringanyi Davidaku mayatjarinytjaku ngayuku aṟangka.” ");
INSERT INTO pjt_vpl VALUES ("S118_9","010_18_9","1SA","18","9","9","Munu palulanguṟu Saulanya Davidaku nyaṟaringangi munu paluṟu palunya tiṯutjarangku nyakula aṟuningi. ");
INSERT INTO pjt_vpl VALUES ("S118_10","010_18_10","1SA","18","10","10","Ka tjiṉṯu kutjupa Godalu piṟuku mamuku kurunpa walatjunu mayatja panya Saulalakutu, ka palula kurunta unngu tjarpangu munu palunya kuraṟa pungangi, ka paluṟu kawakawaringkula waḻi palumpangka unngu para-ngaṟala mirangi. Ka Davidalu Saulaku waḻingka kita wangkatjinganingi, panya paluṟu rawangku alatjinkupai. Ka Saulalu kuḻaṯa maṟangku kanyiningi, ");
INSERT INTO pjt_vpl VALUES ("S118_11","010_18_11","1SA","18","11","11","munu unngu kuliningi, “Kuwariṉa palunya wakaṟa alatjiṯu wallpangka tjakatjunanyi.” Munu paluṟu kuḻaṯa panya Davidalakutu ma-waṉingu kutjara-aṟangku, ka paluṟu tjirkaṉu ka aḻa wakaṉu. ");
INSERT INTO pjt_vpl VALUES ("S118_12","010_18_12","1SA","18","12","12","Ka Mayatja Godanya Davidala tjungu nyinangi, palu Saulanya paluṟu wantikatingu. Ka palulanguṟu Saulanya Davidaku nguḻuringangi. ");
INSERT INTO pjt_vpl VALUES ("S118_13","010_18_13","1SA","18","13","13","Munu paluṟu Davidanya tjunu tjaultji 1,000-ku mayatjarinytjaku munu palunya tjananya wituṟa iyaṉu ankula mirpaṉtju panya tjuṯangka pika pungkunytjaku. ");
INSERT INTO pjt_vpl VALUES ("S118_14","010_18_14","1SA","18","14","14","Ka Mayatja Godanya Davidala tjungu nyinanyangka paluṟu tjana mirpaṉtju panya tjuṯa tiṯutjarangku pungkula waintaringi. ");
INSERT INTO pjt_vpl VALUES ("S118_15","010_18_15","1SA","18","15","15","Ka Davidalu rawangku pungkunytja Saulalu ruuru kuliningi munu palulanguṟu palumpa puḻkaṟa nguḻuringangi. ");
INSERT INTO pjt_vpl VALUES ("S118_16","010_18_16","1SA","18","16","16","Palu aṉangu Israelnga nguraṟa munu Judah-nya nguraṟa uwankara palumpa puḻkaṟa pukuḻaringi, panya paluṟu mayatja wiṟungku tjananya ngalkiningi. ");
INSERT INTO pjt_vpl VALUES ("S118_17","010_18_17","1SA","18","17","17","Ka tjiṉṯu kutjupa Saulalu wangkangu Davidala, “Ngayuluṉanta ungkuku nyuntunya ngayuku uṉṯalpa ngaṉmanyitja ini panya Miṟapanya kuri nyuntumpa nyinanytjaku. Palu nintila-waraṟaṉi wanyu tjaultji kuṉpu mulapa ngaṟalampa, munu ankula Pilitjiyanya nguraṟa tjuṯangka pikariwa Mayatja Godaku.” Alatji Saulalu wangkangi panya paluṟu Davidanya ilunytjaku mukuringangi. Paluṟu kuliningi, “Wai ngayulu walytjangku palunya pungkula iluntanama. Wanti kaṉa Pilitjiyanya nguraṟa tjuṯakutu iyala, kaya paluṟu tjana palya ma-pungkula iluntara.” Alatji Saulalu unngu kuliningi. ");
INSERT INTO pjt_vpl VALUES ("S118_18","010_18_18","1SA","18","18","18","Ka Davidalu Saulala wangkangu, “Wiya, kuṉṯaringanyiṉa mayatja puḻkaku uṉṯalpa aḻṯinytjaku, panya nyuntun ngayuku walytjapitiku ngurpa. Paluṟu tjana puḻka wiya waintaṟa nyinanytjaku ngura nyanga Israelta.” Alatji Davidalu wangkangi. ");
INSERT INTO pjt_vpl VALUES ("S118_19","010_18_19","1SA","18","19","19","Ka ngula tjiṉṯu waṯalpi ilaringu Saulaku uṉṯalpa aḻṯinytjaku, palu Saulalu Davidanya ungkunytja wiyangku wati kutjupa ini Atuṟiyalnga ungu wati panya Mawulanya nguraṟa. ");
INSERT INTO pjt_vpl VALUES ("S118_20","010_18_20","1SA","18","20","20","Ka Saulaku uṉṯalpa kutjupa nyinangi ini panya Mikalanya munu paluṟu Davidaku puḻkaṟa mukuringangi. Ka Saulalu tjukurpa nyangatja kuliṟa puḻkaṟa pukuḻaringu. ");
INSERT INTO pjt_vpl VALUES ("S118_21","010_18_21","1SA","18","21","21","Panya paluṟu alatji kuliningi, “Palyaṉa Mikalanya unganyi Davidanya, munuṉa palu puṟunypaṯu ngunti kuralku, ka ankula Pilitjiyanya nguraṟa tjuṯangka pikariwa kaya pungkula ma-iluntara.” Munu Saulalu piṟuku Davidala wangkangu, “Uwa palya, nyuntu kuwari ngayuku waputjuriku.” ");
INSERT INTO pjt_vpl VALUES ("S118_22","010_18_22","1SA","18","22","22","Munu mayatja Saulalu wati palumpa waṟkaripai maṉkurta wangkangu Davidala ankula kampangkaṯu ma-wangkanytjaku. Alatjiya palula wangka, “Mayatja Saulanya nyuntumpa puḻkaṟa pukuḻarinyi, nganaṉa kuḻu. Kan wanyu palumpa uṉṯalpa aḻṯiku?” ");
INSERT INTO pjt_vpl VALUES ("S118_23","010_18_23","1SA","18","23","23","Kaya mulapaṯu ankula palula ma-tjakultjunu Davidala, ka paluṟu tjanala wangkangu, “Ngayulu wati ngaḻṯutjara mani puḻkatjara wiya munu ngayuku walytja tjuṯa kuḻu ngaḻṯutjara. Ngayulu kutjupa kutjupa kanyintja wiya mayatjanya ungkunytjikitjangku palumpa uṉṯalpaku, kantiṉi palyaṯu ngayunya ungkunytja wiyangku wantima.” ");
INSERT INTO pjt_vpl VALUES ("S118_24","010_18_24","1SA","18","24","24","Kaya wati panya palumpa waṟkaripai maṉkurpa maḻaku ngurakutu anu munuya Saulala tjakultjunu Davidalu tjanala wangkanytja. ");
INSERT INTO pjt_vpl VALUES ("S118_25","010_18_25","1SA","18","25","25","Ka Saulalu wangkangu wati panya tjuṯangka, “Wiya, ngayuluṉa maniku mukuringkunytja wiya ngayuku uṉṯalpa aḻṯinytjaku, palu ngayulu mukuringanyi paluṟu ankula wati Pilitjiyanya nguraṟa tjuṯa nampa nyangatja 100 pungkula wiyantjaku. Palulanguṟultaṉa palunya ungkuku ngayuku uṉṯalpa.” Alatji paluṟu tjanala wangkangi, palu unngu paluṟu kuliningi alatji, “Kuwariya Pilitjiyanya nguraṟa tjuṯangku palunya-waraṟa wiyaṉi.” ");
INSERT INTO pjt_vpl VALUES ("S118_26","010_18_26","1SA","18","26","27","Ka Davidalu tjukurpa nyangatja kulinu munu puḻkaṟa pukuḻaringu Saulalu wangkanytjitja palyantjikitjangku. Ka Saulalu tjiṉṯu ngurkantanu palumpa panya uṉṯalpa aḻṯinytjaku. Ka tjiṉṯu panya palula kuwaripangka Davidanya anu wati palumpa tjaultji tjuṯatjara, munuya Pilitjiyanya nguraṟa wati tjuṯa mulapa iluntanu. Munu maḻaku ngurakutu aṟuringkula Saulala tjakultjunu, “Nampa nyangatjaṉa 200 iluntanu.” Ka palulanguṟu Saulalu Davidanya ungu palumpa uṉṯalpa Mikalanya, ka palumpa waputjuringulta. ");
INSERT INTO pjt_vpl VALUES ("S118_28","010_18_28","1SA","18","28","28","Nyanga palulanguṟu Saulalu kuliningi, “Mulapa, nyangatja Mayatja Godanya Davidala tjungu alatjiṯu nyinanyi.” Munu paluṟu nyakula kuliningi panya palumpa uṉṯalpa Davidaku puḻkaṟa mukuringkunyangka. ");
INSERT INTO pjt_vpl VALUES ("S118_29","010_18_29","1SA","18","29","29","Munu palulanguṟu Saulanya Davidaku puḻkaṟa nguḻuringangi munu palumpa mirpaṉtju nyinangi rawa mulapa ilunytjakutu-wangkara. ");
INSERT INTO pjt_vpl VALUES ("S118_30","010_18_30","1SA","18","30","30","Ka Davidanya panya wiṟu mulararingu panya paluṟu pika uwankarangka tiṯutjara waintaringi Pilitjiyanya nguraṟa tjuṯa pungkula wiyaṟa, panya paluṟu kuṉpu wiṟu mulapa Saulaku tjaultji tjuṯangka muṉkara alatjiṯu. Kaya aṉangu tjuṯangku palunya kuliṟa mirawaṉingi manta winkitjangku. ");
INSERT INTO pjt_vpl VALUES ("S119_1","010_19_1","1SA","19","1","1","Ka tjiṉṯu kutjupa Saulalu palumpa katja Jonathannga munu palumpa maḻpa tjuṯa kuḻu aḻṯingu munu tjanala wangkara wituwituningi Davidanya iluntankunytjaku. Palu Jonathannga panya Davidaku puḻkaṟa mukuringkupai. ");
INSERT INTO pjt_vpl VALUES ("S119_2","010_19_2","1SA","19","2","3","Munu paluṟu ankula Davidala ma-tjakultjunu, “Ngayuku mama mukuringanyi nyuntunya iluntankunytjikitja, ka nguḻu nyangama munu mungawinki ankula putingka nyara kumpiṟa nyinama, kaṉa ngayuku mama nyuntula itiwanungku ma-katiku, munuṉa nyuntunyatjara palula tjapilku, munuṉa paluṟu wangkanytja nyuntulalta maḻa tjakultjunkuku.” ");
INSERT INTO pjt_vpl VALUES ("S119_4","010_19_4","1SA","19","4","5","Munu mungawinki Jonathantu mulapaṯu mamangka panya wangkangu, “Nyaanguṟuṉa Davidanya iluntankuku? Panya paluṟunta rawa mulatu nyuntunya alpamilaningi. Wanyu paluṟu kutjupa kutjupa nyuntumpa ngunti palyaṉu? Wiya alatjiṯu. Kaṉa nyaanguṟulta iluntankuku?” Munu paluṟu wiṟu tjuṯa Davidanyatjara palula wangkangi alatji, “Kulila Mama! Davidalu panya nguḻu wiyangku alatjiṯu wati panya Kalaitjanya iluntanu, ka nyara palulanguṟulta nganaṉanya Mayatja Godalu alpamilaṉu nganaṉa Israelkunu tjuṯangku tjaultji Pilitjiyanya nguraṟa tjuṯa pungkula wiyantjaku, ka panyan nyakula puḻkaṟa alatjiṯu pukuḻaringu.” ");
INSERT INTO pjt_vpl VALUES ("S119_6","010_19_6","1SA","19","6","6","Ka katjangku panya wangkanytja Saulalu kuliningi munu paluṟu Mayatja Godala miṟangka kalkuṉu Davidanya iluntankunytja wiyangku wantinytjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("S119_7","010_19_7","1SA","19","7","7","Ka maḻalta Jonathantu Davidanya aḻṯira tjakultjunangi Saulalu panya wangkara kalkuntja. Munu palulanguṟu katingu Saulaku ngurakutu, ka Davidanya palumpa ngurangka piṟuku waṟkaringi, panya paluṟu ngaṉmanypa waṟkarinytja puṟunypa. ");
INSERT INTO pjt_vpl VALUES ("S119_8","010_19_8","1SA","19","8","8","Palu pika panya paluṟu piṟukulta pakaṉu Pilitjiyanya nguraṟa tjuṯaku. Ka Davidanya Israelku tjaultji tjuṯatjara anu, munuya tjuṯa mulapa pungkula iluntaṟa wiyaṉu, kaya paluṟu tjana puḻkaṟa nguḻuringkula nguḻu wirtjapakaṉu. ");
INSERT INTO pjt_vpl VALUES ("S119_9","010_19_9","1SA","19","9","9","Ka tjiṉṯu kutjupa mamuku kurunpa Mayatja Godalanguṟu Saulala tjarpangu munu palunya kura kulintjaku palyaṉu. Ka paluṟu ngura palumpangka nyinara kuḻaṯa maṟangku witiṟa kanyiningi, ka Davidalu puṉu panya kita palumpa wangkatjinganingi. ");
INSERT INTO pjt_vpl VALUES ("S119_10","010_19_10","1SA","19","10","10","Ka Saulalu kuliningi, “Kuwariṉa palunya wakaṟa alatjiṯu wallpangka tjakatjunanyi.” Munu kuḻaṯa panya Davidalakutu ma-waṉingu palunya wakaṟa iluntankunytjikitjangku, palu Davidanya mapalku tjirkaṉu, ka wallpa kutju wakaṉu, ka paluṟu wirtjapakaṉu. ");
INSERT INTO pjt_vpl VALUES ("S119_11","010_19_11","1SA","19","11","11","Ka munga nyara palulalta Saulalu wati tjaultji tjuṯa wituṟa iyaṉu Davidaku ngurakutu mungangka nyakula tjiṉṯuringkula mungawinki pakannyangka palunya iluntankunytjaku. Palu Davidaku kuringku Mikalalu nintingku kuliningi munu palula wangkangu, “Mapalku ara mungangkaṯu. Palu ankunytja wiyangku wantirampan, kanta kutjupangku mungawinki pakannyangka nyakula iluntankuku.” ");
INSERT INTO pjt_vpl VALUES ("S119_12","010_19_12","1SA","19","12","12","Alatji paluṟu tjakultjunangi munu palulanguṟu palumpa kuri window-wanungku walatjunu mantakutu, ka kumpiṟa anu, kaya puṯu nyangu. ");
INSERT INTO pjt_vpl VALUES ("S119_13","010_19_13","1SA","19","13","13","Ka Mikalalu palumpa watiwati puṉunguṟu palyantjitja mantjiṟa Davidaku mantarangka tjarpatjunu, munu palumpa pulampa piitangka tjarpatjunu, munu nanikutaku inyu tjunu watiwatiku katangkalta mangka puṟunyarinytjaku. ");
INSERT INTO pjt_vpl VALUES ("S119_14","010_19_14","1SA","19","14","14","Ka mungawinki Saulalu wati tjaultji tjuṯa iyaṉu Davidanya witiṟa palulakutu ngalya-katinytjaku. Ka tjana ma-wirkankunyangka Mikalalu nyakula tjanala wangkangu, “Davidanya pikatjara ngarinyi piitangka.” Kaya maḻaku anu Saulalakutu witintja wiyaṯu. ");
INSERT INTO pjt_vpl VALUES ("S119_15","010_19_15","1SA","19","15","15","Palu Saulalu tjananya piṟuku maḻakungku wituṉu, “Ankulaya ngalya-kati piita winki, kaṉa ngayulu palunya iluntara.” ");
INSERT INTO pjt_vpl VALUES ("S119_16","010_19_16","1SA","19","16","16","Kaya mulapaṯu tjaultji panya tjuṯa maḻaku anu Davidaku waḻikutu munuya tjarpara nyangu watiwati piitangka ngarinyangka nanikutaku mangkatjara. ");
INSERT INTO pjt_vpl VALUES ("S119_17","010_19_17","1SA","19","17","17","Ka Saulalu kuliṟa Mikalala wangkangu, “Utiṉin panyatja tjukaṟurungku wangkama ngayula, palu walatjuṟan iyaṉu ngayuku mirpaṉtju.” Ka Mikalalu mamangka panya ngunti wangkangu, “Davidaluṉi alpamilantjaku wangkangu. Alatji paluṟu wangkangu, ‘Nyuntun ngayunya alpamilantja wiyangku wantirampa, kaṉanta iluntankuku.’” ");
INSERT INTO pjt_vpl VALUES ("S119_18","010_19_18","1SA","19","18","18","Ka nyara palulanguṟulta Davidanya wirtjapakaṉu tawunu ini Raamalakutu Samuelnga nyakunytjikitja. Munu palula wirkaṟa tjakultjunu Saulalu uwankara palunya palyantja. Munu pula tjunguringkula anu waḻi Nayatjalakutu munu pula ngura nyara palulalta ma-nyinangi, Davidanya pula Samuelnga. ");
INSERT INTO pjt_vpl VALUES ("S119_19","010_19_19","1SA","19","19","19","Ka kutjupangku nyakunytjatjanungku Saulala tjakultjunu panya Davidanya ngura Nayatjala nyinanytja Raamala. ");
INSERT INTO pjt_vpl VALUES ("S119_20","010_19_20","1SA","19","20","20","Ka Saulalu piṟukuṯu wati tjaultji tjuṯa wituṉu Davidanya witiṟa maḻakungku ngalya-katinytjaku. Kaya mulapaṯu wirkanu, munuya nyangu Samuelnga tjananya wati wangkatjara kutjupa tjuṯa kuḻu Godaku tjukurpa nyinara wangkanyangka. Samuelnga panya palumpa tjanampa mayatja nyinangi. Ka Godaku kurunpa wati panya Saulaku tjungutja tjuṯangka tjarpangu munu tjananya kuḻu wangkanytjaku palyaṉu, kaya tjana kuḻu wangkangi Godaku tjukurpa. ");
INSERT INTO pjt_vpl VALUES ("S119_21","010_19_21","1SA","19","21","21","Kaya tjukurpa nyanga palunya aṉangu tjuṯangku Saulala tjakultjunu, ka paluṟu piṟukuṯu tjaultji kutjupa tjuṯa iyaṉu, ka nyara paluṟu tjana kuḻu tjunguringkula wangkangi Godaku tjukurpa. Ka piṟukuṯu iyaṉu, kaya palu puṟunyaringu. ");
INSERT INTO pjt_vpl VALUES ("S119_22","010_19_22","1SA","19","22","22","Ka palulanguṟu Saulanyalta anu palula tjanalakutu ngura panya Raamalakutu munu mina tjuṉu puḻkangka ma-wirkanu ngura ini Tjikula munu aṉangu tjuṯangkalta tjapinu, “Yaaltji Samuelnga pula Davidanya?” Kaya wangkangu, “Nyaratja pula nyinanyi, waḻi nyara Nayatjala ngura panya Raamala.” ");
INSERT INTO pjt_vpl VALUES ("S119_23","010_19_23","1SA","19","23","23","Ka Saulanya anu Nayatjalakutu, ka iwarangka ankunyangka Godaku kurunpa palula mapalku tjarpangu, ka paluṟu kuḻu wangkaṟinangi Godaku tjukurpa tjana puṟunytju Nayatjalakutu ankula. ");
INSERT INTO pjt_vpl VALUES ("S119_24","010_19_24","1SA","19","24","24","Munu ngura palula ma-wirkaṟa mantara paluṟunku araltjaṟa waṉingu munu mantangka nikiti ngarira ma-mungartjirira ma-mungaringkula ma-tjiṉṯuringu, munu paluṟu Samuelta miṟangka rawangku wangkangi Godaku tjukurpa. Kaya aṉangu tjuṯangku nyakula urulyaraṟa kuliningi, munuya wangkangi, “Mulapa nyangatja Saulanyampa wangkatjararingu?” ");
INSERT INTO pjt_vpl VALUES ("S120_1","010_20_1","1SA","20","1","1","Ka Davidanya waḻi panya Nayatjalanguṟu pakaṟa nguḻu wirtjapakaṉu munu ngura Raamanya wantikatiralta anu maḻaku Jonathantakutu munu ma-wirkaṟa palula wangkangu alatji, “Ngayulu kutjupa kutjupa palyantja wiyaṯu nyuntumpa mama kurantjikitjangku. Nyaaṉa wanyu palyaṉu, kaṉi nyarangku iluntankunytjikitjangkumpa kulini?” ");
INSERT INTO pjt_vpl VALUES ("S120_2","010_20_2","1SA","20","2","2","Ka Jonathantu wangkangu, “Wiya, kulilaṉi! Nyuntunyanta paluṟu iluntankunytja wiya. Panya Mamaluṉi tjakultjunkupai uwankara paluṟu kulintjitja, puḻka tjuṯa munu tjukutjuku tjuṯa kuḻu. Ka pala nyuntu kulintja, palatja tjukaṟuru mulapa wiya, panya paluṟu kulintjatjanungku ngayula utingku uwankara tjakultjunkupai wantinytja wiyangku.” ");
INSERT INTO pjt_vpl VALUES ("S120_3","010_20_3","1SA","20","3","3","Ka Davidalu wangkangu, “Nyuntumpa panya mama ninti nyuntun ngayuku mukuringkupai, mununta pala palulanguṟu nyuntula wangkawiyangku wantingi ngayunya iluntankunytjikitjangku nyuntu kuliṟa tjituṟu-tjituṟurinytjaku-tawara. Tjukaṟurungkuṉanta nyangatja wangkanyi. Tjinguṟuṉi paluṟu kuwari nguwanpa iluntankuku.” ");
INSERT INTO pjt_vpl VALUES ("S120_4","010_20_4","1SA","20","4","4","Ka Jonathantu Davidala wangkangu, “Munta-uwa! Palu nyaalkuṉa wanyu? Utiṟaṉi tjakultjura, kaṉa palyala.” ");
INSERT INTO pjt_vpl VALUES ("S120_5","010_20_5","1SA","20","5","5","Ka Davidalu wangkangu, “Mungawinkila nganaṉa mai puḻka ngalkuṉi piṟa kuwaritja utiringkunyangka. Palu ngayuluṉa nyuntumpa mamangka tjungungku mai ngalkuwiyangku wantinyi, kaṉa nyuntu palya kulinnyangkampa ankula putingka kumpiṟa ma-nyinama, munuṉa putingka nyara tjiṉṯu kutjara nyinara mungartjiriku. ");
INSERT INTO pjt_vpl VALUES ("S120_6","010_20_6","1SA","20","6","6","Kanta tjinguṟu nyuntumpa mamangku tjapilku, ‘Davidanya yaaltji?’ Ka tjukurpa nyangatja palula wangka alatjingaṟa, ‘Paluṟuṉi wangkangu, nyuntu kunyu palunya ngura walytjakutu wantir'iyala Pitjilimalakutu. Panya tjiṉṯu nyanga palulaya palumpa mamangku munu kuṯa tjuṯangku kuḻu inma puḻka palyalpai yiya kutjupa yiya kutjupa.’ ");
INSERT INTO pjt_vpl VALUES ("S120_7","010_20_7","1SA","20","7","7","Ka tjinguṟu nyuntumpa mamangku wangkaku, ‘Uwa wiṟunya palatja,’ kaṉa ngayulu kulilku, ‘Munta-uwa tjinguṟuṉa wankaringkuku.’ Palu tjinguṟutju paluṟu mirpaṉariku, ka nyuntu nyangatja kulinma alatjiṯu paluṟuṉi ngayunya pikantankuku. ");
INSERT INTO pjt_vpl VALUES ("S120_8","010_20_8","1SA","20","8","8","“Ngaḻṯuringamatju! Nyuntu panya ngalilinkun kalkuṉu Mayatja Godalala miṟangka maḻpa mukulya wiṟuṟa nyinanytjikitjangku. Palu tjinguṟu ngayulu kura palyannyangkampa nyuntu ngayunya iluntara, nyuntumpa mamangku wiya.” ");
INSERT INTO pjt_vpl VALUES ("S120_9","010_20_9","1SA","20","9","9","Ka Jonathantu wangkangu, “Wiya, alatji kulintja wiyangku ma-wanti! Tjinguṟu Mamalu nyuntunya iluntankunytjikitjangku kulinnyangkampaṉa ngayulu nyuntula tjakultjunkuku.” ");
INSERT INTO pjt_vpl VALUES ("S120_10","010_20_10","1SA","20","10","10","Ka Davidalu wangkangu, “Uwa palya, palu tjinguṟu nyuntumpa mama ngayuku mirpaṉarinyangkampa yaaltji-yaaltjingkun nyuntu mungawinki ngayula tjakultjunkuku?” ");
INSERT INTO pjt_vpl VALUES ("S120_11","010_20_11","1SA","20","11","11","Ka Jonathantu palula wangkangu, “Wanyuli ara nyara puṯikutu, kaṉanta wangkaku.” Munu pula mulapaṯu anu tjungu. ");
INSERT INTO pjt_vpl VALUES ("S120_12","010_20_12","1SA","20","12","12","Ka Jonathantu Davidala wangkangu, “Ngayuluṉanta kalkuṉi nyuntula munu Israelku Mayatja Godala alatji, tjiṉṯu nyara palulalta mungawinki kutjupangka ngayulu kulilku ngayuku mamangku kulintja. Tjinguṟu paluṟu nyuntumpa pukuḻarinyi, kaṉa aṉangu kutjupa nyuntulakutu ma-witulku nyuntula ankula tjakultjunkunytjaku. ");
INSERT INTO pjt_vpl VALUES ("S120_13","010_20_13","1SA","20","13","13","Palu tjinguṟunta Mamalu nyuntunya pungkunytjikitjangku kulilku, kaṉanta kuwari nyanga nyuntunya mulamulangku wangkara kalkuṉi nyuntula tjakultjunkunytjikitjangku. Munuṉanta palulanguṟu ngura kutjupakutu ankunytjaku wankaṟu iyalku. Palu tjinguṟuṉa nyuntula wangkawiyangku wantirampa, kaṉitju Mayatja Godalu ngayunya puḻkaṟa pungkuku. “Kaṉa kuwari Mayatja Godala nyuntumpa tjapini tjungu tiṯutjara nyuntula nyinanytjaku, panya paluṟu ngayuku mama ngaṉmanytju aṯunytju kanyiningi, palu puṟunytju.” ");
INSERT INTO pjt_vpl VALUES ("S120_14","010_20_14","1SA","20","14","15","Munu Jonathantu wangkangu Davidala, “Ngula tjiṉṯu kutjupangka Mayatja Godalu nyuntumpa panya mirpaṉtju uwankara wiyalku alatjiṯu manta nyanga palulanguṟu. Ka tjinguṟu ngayulu wankaṯu nyinanyangkampa nyuntu ngayuku ngaḻṯuringamatu, panya Mayatja Godanyatju ngayuku ngaḻṯunytju alatjiṯu nyinanyi, palu puṟunypa. Palu ngayulu ilunyangkampa nyuntu ngayuku walytja tjuṯa palu puṟunytjuṯu ngaḻṯunytjungku aṯunymanama wantinytja wiyangku.” ");
INSERT INTO pjt_vpl VALUES ("S120_16","010_20_16","1SA","20","16","16","Munu pula palulanguṟulta alatji wangkara tjukurpa nyangatja kalkuṉu, “Utiya Davidaku walytjapitingku Jonathanku walytja tjuṯa iluntankuwiyangku wantima.” Ka Jonathantu Davidala wangkangu alatjingaṟa, “Tjinguṟu nyuntumpa walytja tjuṯangku kalkuntja panyatja katantankunyangkampa ngayulu Mayatja Godala tjapilku tjananya wiyantjaku.” ");
INSERT INTO pjt_vpl VALUES ("S120_17","010_20_17","1SA","20","17","17","Uwa, panya Jonathannga puḻkaṟa mulapa mukuringkupai Davidaku paluṟunku mukuringkunytja puṟunypa, munu paluṟu Davidala piṟuku wangkangu alatji, “Ngali panya wangkara kalkuṉu wantinytja wiyakitjangku, katju ngayuku tiṯutjara mukulya puḻka ngaṟama.” ");
INSERT INTO pjt_vpl VALUES ("S120_18","010_20_18","1SA","20","18","18","Munu Jonathantu piṟuku wangkangu palula, “Mungawinki panyala nganaṉa mai puḻka ngalkuṉi piṟa panya kuwaritja ngalya-pakannyangka, ka nyuntu wiya ngaṟanyangkampa aṉangu tjuṯangku kuliṟa puṯu nyakuku nyuntunya. ");
INSERT INTO pjt_vpl VALUES ("S120_19","010_20_19","1SA","20","19","19","Ka palula maḻangka tjiṉṯu kutjupa nyuntu ngura panya palulakutuṯu ara nyuntu panya kumpiṟa ngaṉmanypa nyinanytjalakutu, munu nyara palula paṯaṟa nyinama puḻi panya ini Itjilta itingka. ");
INSERT INTO pjt_vpl VALUES ("S120_20","010_20_20","1SA","20","20","20","Kaṉa ngayulu paṯunguṟu punaṟa waṉiku maṉkur-aṟangku puḻi panya palulakutu arkaṟa tjukaṟurungku waṉinytjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("S120_21","010_20_21","1SA","20","21","21","Munuṉa palulanguṟu tjitji witulku kuḻaṯa panya palunya tjananya nguriṟa mantjintjaku panya ngayuluṉa punuṟa waṉinytja tjuṯa. Ka tjinguṟu ngayuku mamangku nyuntunya iluntankunytjikitjangku kulintja wiyangku wantinyangkampaṉa ngayulu tjitji palula ma-mirara wangkaku alatji, ‘Kuḻaṯa pala tjuṯa tjangaṯi ngarinyi. Mantjiṟa ngalya-kati.’ Ka nyuntu panya kumpiṟa nyinara kulilku munun ngayulu tjangaṯitja wangkanyangka kulinma, ‘Munta-uwa, palyaṉa ma-pakaṟa utiringkuku, kaṉi wantiku iluntankunytja wiyangku Saulalu.’ ");
INSERT INTO pjt_vpl VALUES ("S120_22","010_20_22","1SA","20","22","22","Palu tjinguṟu ngayuku mamangku nyuntunya iluntankunytjikitja mukuringkunyangkaṉa ngayulu tjitjingka alatji ma-mirara wangkaku, ‘Pala munkara ma-nyawa kuḻaṯa ngarinyi!’ Ka alatji wangkanyangka kuliṟampa ara, panya Mayatja Godalunta wituṉi ngura nyangatja wantikatira ankunytjaku. ");
INSERT INTO pjt_vpl VALUES ("S120_23","010_20_23","1SA","20","23","23","Palu rawangku kulinma tjukurpa panya ngalinku kalkuntjanya, kalinya Mayatja Godalu ngalinya rawangku nintilkatima tjukurpa panya palunya watarkurinytjaku-tawara.” Alatji Jonathantu Davidala wangkangi. ");
INSERT INTO pjt_vpl VALUES ("S120_24","010_20_24","1SA","20","24","24","Ka Davidanya mulapaṯu kumpiṟa nyinangi puṯi panya palula. Ka piṟa panya kuwaritja pakannyangka wati panya mayatja Saulalu tjana mai puḻka nyinakatira ngalkuningi. ");
INSERT INTO pjt_vpl VALUES ("S120_25","010_20_25","1SA","20","25","25","Munu paluṟu tjiiya panya aṟangkaṯu nyinangi wallpangka itingka Saulanya, ka palumpa katja Jonathannga taipulangka kampa kutjupa nyinangi aṟangkaṯu mamangka tjungu ilaṯu. Ka wati ini Apananya Saulala itingka tjiiya palulaṯu aṟangka panya nyinangi. Palu Davidaku tjiiya ultu ngaṟangi. ");
INSERT INTO pjt_vpl VALUES ("S120_26","010_20_26","1SA","20","26","26","Ka Saulalu tjiiya ultu nyakula unngu kutju kuliningi, “Munta, tjinguṟu kutjupa kutjupa kura pampuntjatjanu paluṟu puṯu nganaṉala maikitja tjunguringanyi.” Munu paluṟu wangkanytja wiya nyinangi. ");
INSERT INTO pjt_vpl VALUES ("S120_27","010_20_27","1SA","20","27","27","Ka tjiṉṯu kutjararingu, ka tjiiya panya kutju wiyaṯu ngaṟangi. Ka Saulalu tjapinu palumpa katjangka, “Nyaaku Jesse-ku katja mai nyangaku pitjawiyangku wantinyi? Panya paluṟu mungartjilpi wiya ngaṟangi, munu kuwari kuḻu nyanga wiyaṯu ngaṟanyi.” ");
INSERT INTO pjt_vpl VALUES ("S120_28","010_20_28","1SA","20","28","28","Ka Jonathantu palumpa mamangka wangkangu, “Davidalu ngayula tjapinu palunya ngura walytjakutu wantir'iyantjaku Pitjilimalakutu. ");
INSERT INTO pjt_vpl VALUES ("S120_29","010_20_29","1SA","20","29","29","Alatjiṉi paluṟu wangkangu, ‘Iyalaṉi ngayuku walytja tjuṯakutu, panya tjanaya inma puḻkaṯu palyaṉi nganampa ngurangka, kaṉi ngayuku kuṯangku wangkangu palula tjanala tjunguringkunytjaku tjiṉṯu nyangangka. Wanyuṉi maḻpa wiṟungku wantir'iyala kuṯa tjuṯakutu palula tjanala ngapartji nyinanytjaku.’ Alatjiṉi paluṟu tjapinu, kaṉa mulapaṯu palunya wantir'iyaṉu. Nyanga palulanguṟu paluṟu nganaṉala tjungu nyinanytja wiya ngaṟanyi.” ");
INSERT INTO pjt_vpl VALUES ("S120_30","010_20_30","1SA","20","30","30","Ka Saulanya Jonathanku puḻkaṟa mirpaṉaringu munu palula wangkangu, “Nyuntu kura puḻka mulapa munun ngayula wangaṉarangku kulintja wiyaringu. Ngayulu ninti alatjiṯu panya nyuntu Davidaku maḻpa. Ka ngunytju nyuntumpa puḻkaṟa alatjiṯu kuṉṯaringanyi nyuntunya kanyintjatjanu. Katja wiṟu-palkunta kanyinu. Ka nyuntu kuḻu uti kuṉṯa-kuṉṯa nyinama. ");
INSERT INTO pjt_vpl VALUES ("S120_31","010_20_31","1SA","20","31","31","Kulila! Davidanya wanka nyinanyangkampa ngura nyangaku nyuntu puṯu alatjiṯu mayatjarinyi. Palu wanyu ankula Davidanya witiṟa ngalya-kati ngayulakutu, kaṉa palunya iluntara alatjiṯu.” ");
INSERT INTO pjt_vpl VALUES ("S120_32","010_20_32","1SA","20","32","32","Ka Jonathantu palumpa mamangka wangkangu, “Nyaanguṟun palunya iluntankuku? Kura nyaa wanyu paluṟu palyaṉu?” ");
INSERT INTO pjt_vpl VALUES ("S120_33","010_20_33","1SA","20","33","33","Ka Saulalu palumpa mirpaṉarira kuḻaṯa panya waṉingu palunya wakaṟa iluntankunytjikitjangku munu palunya nguwanpa alatjiṯu iluntanu. Ka nyara palulanguṟulta Jonathantu kuliningi, “Munta-uwa, mulapa nyangampal! Ngayuku mamangku Davidanya iluntankunytjikitja mukuringanyi.” ");
INSERT INTO pjt_vpl VALUES ("S120_34","010_20_34","1SA","20","34","34","Munu Jonathannga puḻkaṟa mirpaṉarira taipulanguṟu wala winkilta pakalkatingu munu puḻkaṟa tjituṟu-tjituṟurira mai wantikatira anu, panya palumpa mamangku Davidanya kuraṟa pungkunyangka. ");
INSERT INTO pjt_vpl VALUES ("S120_35","010_20_35","1SA","20","35","35","Munu palulanguṟulta mungawinki Jonathannga anu tjitji mantjiṟa uṟilkutu Davidalakutu. ");
INSERT INTO pjt_vpl VALUES ("S120_36","010_20_36","1SA","20","36","36","Munu tjitjingka panya wangkangu, “Kuwariṉa punaṟanguṟu nyanga kuḻaṯa tjuṯa arkaṟa waṉinyi, ka nyuntu wirtjapakaṟa ngurila kuḻaṯa panya ngayulu waṉinytja tjuṯa.” Ka tjitji panya paluṟu ma-wirtjapakannyangka Jonathantu palula munkara kuḻaṯa punaṟanguṟu waṉingu. ");
INSERT INTO pjt_vpl VALUES ("S120_37","010_20_37","1SA","20","37","37","Ka tjitji panya paluṟu kuḻaṯa panya tjuṯa punkantjalakutu ma-ilaringkunyangka Jonathannga mirangu, “Ma-nyawa, munkara nyara.” ");
INSERT INTO pjt_vpl VALUES ("S120_38","010_20_38","1SA","20","38","38","Munu palulanguṟulta wangkangu, “Walawala puḻkaṟa wirtjapakala ngaṟakatinytja wiya.” Ka tjitjingku panya kuḻaṯa mantjiṟa ngalya-katira Jonathannga ungu. ");
INSERT INTO pjt_vpl VALUES ("S120_39","010_20_39","1SA","20","39","39","Ka Davidalu puṯi tjaṯangka unngu nyinara Jonathannga miranyangka kuliningi. Munu paluṟu tjukurpa munkaritja wangkanyangka kuliṟa kulinu, “Munta-uwa mulapa nyangampal Saulanya ngayuku mirpaṉpa ngaṟanyi.” Ka tjitji nyanga paluṟu panya aṟa nyanga palumpa ninti wiya ngurpa, palu Jonathantu pula Davidalu kutju kuliningi. ");
INSERT INTO pjt_vpl VALUES ("S120_40","010_20_40","1SA","20","40","40","Ka Jonathantu punaṟa tjitji panya palunya ungkul'iyaṟa wangkangu, “Punaṟa nyanga ma-kati ngurakutu!” ");
INSERT INTO pjt_vpl VALUES ("S120_41","010_20_41","1SA","20","41","41","Ka tjitji panya paluṟu mulapaṯu maḻaku tawunukutu anu. Ka Davidanya puḻi panya palula uḻpaṟira kumpiṟa nyinanytjatjanu ngalya-utiringu munu Jonathanta kuranyu tultjungaṟakatira yunpangku manta pampuṉu maṉkuraṟangku munu pulanku ampuṟa nyunytjuṉu munu pula ngaṟala puḻkaṟa ulangi, palu Davidanya rawa alatjiṯu ulangi. ");
INSERT INTO pjt_vpl VALUES ("S120_42","010_20_42","1SA","20","42","42","Ka Jonathantu wangkangu Davidala, “Palya wantikatilanya munu ma-pakala, kanta Godalu wankaṟu kanyilku. Ngali panya kalkuṉu Mayatja Godala miṟangka tiṯutjara maḻpa mulapa nyinanytjikitjangku wantinytja wiyakitjangku. Ka Mayatja Godalu ngayuku walytja tjuṯa munu nyuntumpa walytja tjuṯa kuḻu tjungulku kalkuntja nyanga palunya tiṯutjarangku kanyintjaku.” Ka Davidanya wantikatira ma-pakaṉu, ka Jonathannga maḻaku anu tawunukutu. ");
INSERT INTO pjt_vpl VALUES ("S121_1","010_21_1","1SA","21","1","1","Ka Davidanya anu tawunu ini Napalakutu wati tjukurtjara ini Aima-likinya nyakunytjikitja. Ka wati paluṟu Davidanya nyakula puḻkaṟa alatjiṯu tjititingu munu nguḻungku tjapiṟa wangkangu, “Nyaakun kutju pitjangu?” ");
INSERT INTO pjt_vpl VALUES ("S121_2","010_21_2","1SA","21","2","2","Ka Davidalu ngunti wangkangu alatji, “Wati mayatja Saulaluṉi wangkangu kutjupa kutjupa wiṟu palyantjaku, munuṉi alatji wangkara wituṉu, ‘Kutjupangka wangkanytja wiyangku wantima ngayulu nyanga nyuntunya iyantjikitjangku wangkanytja.’ Kaṉa ngayulu ngayuku wati tjuṯa kuranyungku iyaṉu ngura kutjupangka ngayunya nyakunytjaku.” ");
INSERT INTO pjt_vpl VALUES ("S121_3","010_21_3","1SA","21","3","3","Munu Davidalu tjapinu wati panya Aima-likinya, “Main kanyini ngayunya ungkunytjikitjangku? Wanyuṉi mai kutjara maṉkurpa ungama?” ");
INSERT INTO pjt_vpl VALUES ("S121_4","010_21_4","1SA","21","4","4","Ka wati panya tjukurtjarangku wangkangu, “Mai kutjupaṉa kanyintja wiya, palu mai nyanga miḻmiḻpa kutjuṉa kanyini wati panya kungkangka ngaripai wiya tjuṯangku kutju ngalkuntjaku.” ");
INSERT INTO pjt_vpl VALUES ("S121_5","010_21_5","1SA","21","5","5","Ka Davidalu palula wangkangu, “Wiya nganaṉa tjaultji tjuṯa tjungu para-ngaṟala kungkangka ngaripai wiya. Munula kuwari nyanga ananyi kutjupa kutjupa wiṟu palyantjikitja, palulanguṟula kungkangka tjunguringkula ngarinytja wiya alatjiṯu.” ");
INSERT INTO pjt_vpl VALUES ("S121_6","010_21_6","1SA","21","6","6","Ka wati panya tjukurtjarangkulta mai panya miḻmiḻpa tinta miḻmiḻpanguṟu mantjiṟa Davidanyalta ungu munu mai kuwari pauntja tjunu palumpa aṟangka. ");
INSERT INTO pjt_vpl VALUES ("S121_7","010_21_7","1SA","21","7","7","Ka tjiṉṯu nyara palulaṯu Saulaku tjiipi aṯunymankupai ngura nyara palula nyinangi wati ini Tuwikanya panya Iitamakunu. Paluṟu tiinta miḻmiḻṯa tjarpara Godanya waḻkuningi. ");
INSERT INTO pjt_vpl VALUES ("S121_8","010_21_8","1SA","21","8","8","Ka Davidalu wati panya tjukurtjarangka tjapiningi, “Tjula waṟan kanyini? Munta tjinguṟu tjula waṟa wiyangkampaṉi kuḻaṯa kanyintjatjanungku ungama. Panya mayatja Saulalu ngayunya witunnyangkaṉa mapalku pitjangu tjula wantikatira.” ");
INSERT INTO pjt_vpl VALUES ("S121_9","010_21_9","1SA","21","9","9","Ka wati panya tjukurtjarangku wangkangu, “Tjula panya nyuntu mungaṯu wati Kalaitjanya iluntankunytjitja mantarangka karpintja ngarinyi nyara kampa kutjupa tjukurtjaraku mantarangka itingka. Ka mukuringkulampa palya mantjiṟa kati.” Ka Davidalu wangkangu alatji, “Munta, tjula nyara paluṟu wiṟu mulapa! Wanti, kaṉatju kati!” ");
INSERT INTO pjt_vpl VALUES ("S121_10","010_21_10","1SA","21","10","10","Munu tjiṉṯu nyara palula Davidanya kumpiṟa wirtjapakaṉu Saulaku nguḻu munu ankula ankula manta Pilitjiyala ma-wirkanulta wati mayatja ini Akitjalakutu tawunu ini Kaatjala nyinanyangka. ");
INSERT INTO pjt_vpl VALUES ("S121_11","010_21_11","1SA","21","11","11","Palu mayatja Akitjaku waṟkaripai tjuṯangku palunya nyakula tjanampa mayatjangka wangkangu, “Wati nyanga paluṟu panya Davidanya. Paluṟu panya mayatja puṟunypa nyinapai ngura palumpangka, kaya aṉangu tjuṯangku inma inkara nyaṉpipai nyanga alatji palunya mirawaṉira, ‘Saulalu warmaḻa tjuṯa iluntanu nampa nyangatja 1,000, palu Davidalu iluntanu tjuṯa mulapa palula munkara nampa nyangatja 10,000!’ ” ");
INSERT INTO pjt_vpl VALUES ("S121_12","010_21_12","1SA","21","12","12","Ka Davidalu kulinu tjana kampangkaṯu wangkanyangka munu nguḻuringu wati panya Akitjaku palunya iluntankunytjaku-tawara. ");
INSERT INTO pjt_vpl VALUES ("S121_13","010_21_13","1SA","21","13","13","Munu paluṟu tjananya ngunti kuraningi kawakawangku-palku munu panya tawunuku kaita tuwa piriningi munu paluṟu tjaanguṟu wiṯa tjuti-tjutingi ngaṉkurpawanu. ");
INSERT INTO pjt_vpl VALUES ("S121_14","010_21_14","1SA","21","14","14","Ka wati panya Akitjalu nyakula tjaultjiku mayatja tjuṯangka wangkangu, “Nyawaya! Wati pala kata kawakawa. Nyaaku nyura ngalya-katingu? ");
INSERT INTO pjt_vpl VALUES ("S121_15","010_21_15","1SA","21","15","15","Ngura nyangangkaya kawakawa ngaṉmanyitja tjuṯa nyinanyi, kaṉa mukuringkunytja wiya kutjupalpi piṟuku ngalya-katira tjunguntjaku nyanga ngayuku waḻingka.” ");
INSERT INTO pjt_vpl VALUES ("S122_1","010_22_1","1SA","22","1","1","Ka Davidalu ngura panya Kaatjanya wantikatira anu kuḻpikutu ngura panya ini Atulamala itingka, kaya kuṯa panya tjuṯangku munu walytja kutjupa tjuṯangku kuḻu kulinu ngura nyara palula paluṟu nyinanytja, munuya ankula palula tjunguringu. ");
INSERT INTO pjt_vpl VALUES ("S122_2","010_22_2","1SA","22","2","2","Kaya aṉangu ngaḻṯutjara kutjupa tjuṯangku kuḻu kulinu munuya wirkaṟa palula tjunguringu – kutjupa tjaraya taṟapulatjara, kaya tjara kutjupa tjituṟu-tjituṟu kulintja puḻkatjara, kaya tjara kutjupangku mani ngatjintjatjanungku maḻakungku puṯu ungangi. Wati 400 nguwanpaya Davidala tjunguringu, ka paluṟu tjanampa mayatjaringu. ");
INSERT INTO pjt_vpl VALUES ("S122_3","010_22_3","1SA","22","3","3","Palulanguṟulta Davidalu kuḻpi panya palunya wantikatira anu tawunu ini Mitjapalakutu manta panya ini Mawapalakutu. Munu wangkangu Mawapaku mayatjangka alatji, “Wiṟungkutju ngayuku mama munu ngunytju kuḻu aṯunymaṟa kanyinma ngayuku paṯaṟa? Kaṉatju kumpiṟa ankula ma-nyinamalta Godalu panya nintintjaku paṯaṟa.” Ka Davidalu tjapinnyangka Mawapaku mayatjangku palyanmanu. ");
INSERT INTO pjt_vpl VALUES ("S122_4","010_22_4","1SA","22","4","4","Ka mulapaṯu Davidalu mama ngunytju mayatjaku panya ngurangkalta wantikatingu, munu tjiṉṯu nyara palula ankula kumpiṟa ma-nyinangi ngura ngurpatjangka. Ka pula mama ngunytju Mawapaku mayatjangka rawa nyinangi Davidanya kumpiṟa ma-nyinanyangka. ");
INSERT INTO pjt_vpl VALUES ("S122_5","010_22_5","1SA","22","5","5","Ka tjiṉṯu kutjupangka wati wangkatjara ini Kaitalu Davidala wangkangu, “Kuḻpi nyanga wantikati munu manta panya Judah-lakutu maḻaku aṟuriwa.” Ka mulapaṯu paluṟu kuliṟa kuḻpi panya wantikatira anu manta Judah-lakutu munu wirkaṟa puṯi puḻkangka nyinangi ngura ini Iiṟitjala itingka. ");
INSERT INTO pjt_vpl VALUES ("S122_6","010_22_6","1SA","22","6","6","Ka tjiṉṯu kutjupa Saulanya tawunu ini Kipiyala puḻi katu kuḻaṯatjara nyinangi puṉu wiltjangka, kaya palumpa tjaultji tjuṯaku mayatja maṉkurpa kuḻu palula tjungu ngaṟangi. Ka wati kutjupa maṉkurpa palulakutu pitjangu munuya tjakultjunu, “Ai! Kutjupangku kunyu nyangu wati panya Davidanya tjana ngura kutjupangka utiringkula nyinanyangka.” ");
INSERT INTO pjt_vpl VALUES ("S122_7","010_22_7","1SA","22","7","8","Ka Saulalu tjanala wangkangu, “Kulilaya wati Benjaminkunu tjuṯa! Nyaanguṟu nyura ngayuku mukuringkunytja wiya? Ngayulu puṯu kulini. Tjinguṟu nyura kulini ngula Jesse-ku katjangku mayatjarira nyuranya kaana maitjara kiṟipitjitjara ungkunytjaku. Palu wiya. Munu nyura tjinguṟu kulini alatji, paluṟu nyuranya kuḻu tjunkuku nyura tjaultji tjuṯaku mayatjarinytjaku. Panya ngayuluṉa nyuranya ngurkantaṟa tjunu wati mayatja tjaultji 1,000-ku munuṉa 100-ku kuḻu, palu nyara paluṟu ngayulu puṟunytju nyuranya palyantja wiya alatjiṯu. Kulilaya! Nyura ngayuku kuraringkupai alatjiṯu. Nyura panya ninti ngayuku katja Jonathanku panya paluṟu pulanku Davidalu kalkuṉu tiṯutjara maḻpa mulapa palyanyku nyinanytjikitjangku, kaṉi nyura nyaanguṟu panyatja ngayula tjakultjunkunytja wiyangku wantingi? Munu panya nyura kuwari ngayula tjakultjunkunytja wiyangkuṯu wantingi ngayuku katjangku ngayunya iluntankunytjaku Davidanya wituwitunnyangka.” Nyanga alatji Saulalu tjanala wangkangu. ");
INSERT INTO pjt_vpl VALUES ("S122_9","010_22_9","1SA","22","9","9","Palu wati panya Tuwikanya nyara palula ngaṟangiṯu tjanala tjungu, wati panya Iitamanya nguraṟa, munu paluṟu Saulala wangkangu, “Ngaṉmanypa panyaṉa ngayulu tawunu Naapala nyinangi munuṉa Jesse-ku katja nyangu paluṟu tjukurtjara Ayima-likala wirkankunyangka, Akitupaku katjangka panyalta. ");
INSERT INTO pjt_vpl VALUES ("S122_10","010_22_10","1SA","22","10","10","Ka Godala tjapiningi Ayima-likalu Davidanya alpamilantjaku, munu palulanguṟulta Davidanya mai ungu munu tjula waṟa kuḻu ungu, tjula panyatja Davidalu panya Kalaitjanya kata kaṯantja.” ");
INSERT INTO pjt_vpl VALUES ("S122_11","010_22_11","1SA","22","11","11","Ka Saulalu nyangatja kuliṟa mapalku tjakulpa wituṟa iyaṉu tawunu nyara Naapalakutu Ayima-likanya tjananya aḻṯira ngalya-katinytjaku palumpa walytja tjuṯa kuḻu panya tjana uwankara tjukurtjara. Kaya mulapaṯu pitjangu wangaṉara alatjiṯu Saulalakutu. ");
INSERT INTO pjt_vpl VALUES ("S122_12","010_22_12","1SA","22","12","12","Ka Saulalu wangkangu, “Akitupaku katja, wanyuṉi kulila!” Ka palula wangkangu, “Uwa, mayatja wiṟu! Kuliniṉanta.” ");
INSERT INTO pjt_vpl VALUES ("S122_13","010_22_13","1SA","22","13","13","Ka Saulalu mirpaṉṯu wangkangu, “Nyuntun kura puḻkangku Godala tjapiningi Davidanya alpamilantjaku. Munu panyan kurangku palunya mai ungu, tjula waṟa kuḻu, ka paluṟu kuwari nyanga paṯaṟa ngaṟanyi ngayuku pika pungkunytjikitja.” ");
INSERT INTO pjt_vpl VALUES ("S122_14","010_22_14","1SA","22","14","14","Ka Mayatja Saulala wangkangu, “Wiya, Davidanya panya nyuntumpa waṟkaripai tjukaṟuru mulapa nyuntunya kurantja wiyaṯu. Nyara paluṟunku nyuntumpa panya wati waputju wiṟu mulapa. Paluṟu nyuntumpa tjaultji tjuṯaku mayatja nyinangi, munu nyuntunya wankaṟu aṯunymaṟa kanyiningi. Munu paluṟu nyuntula wiṟuṟa kulilpai wangaṉarangku, kaya nyuntumpa panya walytjapiti puḻkaṟa pukuḻaripai palumpa. ");
INSERT INTO pjt_vpl VALUES ("S122_15","010_22_15","1SA","22","15","15","Mulapaṉa ngayulu Davidaku Godala tjuṯa-aṟangku tjapiningi kuwari kutju wiya. Ka mayatja wiṟu ngana, ngayuku mirpaṉarinytja wiyangkutju wantima ngayuku walytja tjuṯaku kuḻu, panya nganaṉa kura palyantja wiyaṯu.” Alatji Ayima-likalu wangkangu. ");
INSERT INTO pjt_vpl VALUES ("S122_16","010_22_16","1SA","22","16","16","Palu Saulalu wangkangu, “Wiya, nyuntu panyan kura alatjiṯu palyaṉu, kanta palulanguṟulta nyuntunya munu nyuntumpa walytjapiti kuḻu kuwari tjunguṟa uwankara nyuranya iluntananyi.” ");
INSERT INTO pjt_vpl VALUES ("S122_17","010_22_17","1SA","22","17","17","Munu wangkangu palumpa tjaultji tjuṯangka, “Mayatja Godaku nyanga tjukurtjara tjuṯangku Davidanya alpamilaṉu. Paluṟu tjanaya kulinu wati panya paluṟu ngayuku nguḻu wirtjapakannyangka, palu tjanaṉiya ngayula tjakultjunkunytja wiyangku wantingi. Kaya nyura palunya tjananya iluntara alatjiṯu.” Palu tjaultji panya tjuṯangku tungunpungkula Godaku tjukurtjara tjuṯa iluntankunytja wiyangku wantingi. ");
INSERT INTO pjt_vpl VALUES ("S122_18","010_22_18","1SA","22","18","18","Ka Saulalu wati panya Tuwikala wangkangi, “Nyuntu iluntara wati tjukurtjara tjuṯa!” Ka paluṟu mulapaṯu wati panya tjukurtjara uwankara iluntanu nampa nyangatja 85. ");
INSERT INTO pjt_vpl VALUES ("S122_19","010_22_19","1SA","22","19","19","Ka palula maḻangka Saulalu tjaultji tjuṯa iyaṉu tawunu panya Naapalakutu, kaya ankula ma-iluntanu aṉangu winki mulapa wati, minyma, tjitji, iṯi kuḻu munuya puluka, tangkiyi, tjiipi tjuṯa kuḻu pungu. ");
INSERT INTO pjt_vpl VALUES ("S122_20","010_22_20","1SA","22","20","20","Palu tjaultji tjuṯangkuya Ayima-likaku katja puṯu witiningi wati panya ini Apiyatjanya, ka paluṟu nguḻu ma-wirtjapakaṉu Davidalakutu. ");
INSERT INTO pjt_vpl VALUES ("S122_21","010_22_21","1SA","22","21","21","Munu palula ma-tjakultjunu alatji, “Saulalu Mayatja Godaku tjukurtjara tjuṯa iluntanu Naapanya nguraṟa uwankara mulapa.” ");
INSERT INTO pjt_vpl VALUES ("S122_22","010_22_22","1SA","22","22","22","Ka Davidalu kulinu munu Apiyatjala wangkangu, “Kulila! Tjiṉṯu panyatja kulinma panya ngayulu Naapalakutu anu, ka panya Tuwikanya nyara palula nyinangi wati panya Iitamanya nguraṟa. Kaṉa nyara palula aṟangka ngayulu kuliningi, ‘Kuwari wati nyanga Tuwikalu Saulala tjakultjunanyi Ayima-likalu ngayunya alpamilantja.’ Ka nyanga mulapaṯu kuwari nyuntumpa walytja uwankaralta iluntara wiyaṉu. Ngaḻṯutjara! Mulapa panyaṉa nyuntumpa mamangka wirkaṟa tjapinu ngayunya alpamilantjaku, kaya nyara palulanguṟulta uwankara pungu ngayunya alpamilannyangka. ");
INSERT INTO pjt_vpl VALUES ("S122_23","010_22_23","1SA","22","23","23","Ka nyuntu kuwari nguḻuringkunytja wiya ngayula tjungu nyinama, panya Saulalulinya nyuntunya ngalinya ngurini iluntankunytjikitjangku. Palu ngayula tjungu nyinarampan wankaṟu nyinaku.” Alatji Davidalu ngaḻṯuringkula wangkangu. ");
INSERT INTO pjt_vpl VALUES ("S123_1","010_23_1","1SA","23","1","1","Ka tjiṉṯu kutjupangka aṉangu kutjupa tjuṯangku pitjala Davidala wangkangu, “Wati warmaḻa Pilitjiyanya nguraṟa tjuṯangku tawunu panya Kiilala aṉangu tjuṯa punganyi munuya mai uṉinypa kuḻu kutitjunanyi.” ");
INSERT INTO pjt_vpl VALUES ("S123_2","010_23_2","1SA","23","2","2","Ka Davidalu Mayatja Godala tjapinu, “Mayatja, mulapan mukuringanyi ngayulu ankula tjananya pungkunytjaku? Wanyuṉi tjakultjura!” Ka Mayatjalu wangkangu, “Uwa palya, ankula tjananya puwa Pilitjiyanya nguraṟa tjuṯa, munu aṉangu nyara Kiilanya nguraṟa tjuṯa ngalkila.” ");
INSERT INTO pjt_vpl VALUES ("S123_3","010_23_3","1SA","23","3","3","Palu Davidaku tjaultji tjuṯangku wangkangu, “Wiya, nganaṉa palumpa tjanampa nguḻuringanyi. Ka ngura nyara Kiilanya tjanampa ngurangka itingka ila ngaṟanyi. Kala nyara palulakutu pika ankulampa nganaṉa puḻkaṟa alatjiṯu nguḻuringkuku! Munula tjananya puṯu wiyalku Pilitjiyanya nguraṟa panya tjuṯa.” ");
INSERT INTO pjt_vpl VALUES ("S123_4","010_23_4","1SA","23","4","4","Ka Davidalu piṟuku Mayatja Godala tjapinu, ka palula wangkangu, “Wiya palya, araya Kiilalakutu munuya Pilitjiyanya nguraṟa tjuṯangka pikariwa, kaṉa ngayulu nyuranya alpamilalku pungkula uwankara wiyantjaku.” ");
INSERT INTO pjt_vpl VALUES ("S123_5","010_23_5","1SA","23","5","5","Ka mulapaṯu Davidanya tjana anu Kiilalakutu munuya Pilitjiyanya nguraṟa tjuṯa pungkula uwankara iluntanu, munu tjanampa puluka tjiipi kuka uwankara kuḻu mantjiṟa katingu. Kaya aṉangu panya Kiilanya nguraṟa tjuṯa wankaringu. ");
INSERT INTO pjt_vpl VALUES ("S123_6","010_23_6","1SA","23","6","6","Ka wati panya Apiyatjalu ngaṉmanytju tjukurtjaraku mantara miḻmiḻpa katingu ngura Naapalanguṟu munu Saulalanguṟu nguḻu wirtjapakaṉu munu Davidala tjanala tjunguringkula anu ngura Kiilalakutu. ");
INSERT INTO pjt_vpl VALUES ("S123_7","010_23_7","1SA","23","7","7","Ka kutjupangku Saulala tjakultjunu Davidanya Kiilala nyinanytja, ka Saulalu wangkangu, “Munta wiṟunya! Kuwari Godalu palyaṉi ngayulu witintjaku palunya. Panya kuwari paluṟu tawunu wall puḻkatjarangka nyinanyi, kaṉa kuwari ankula witilku patingka nyinanyangka.” ");
INSERT INTO pjt_vpl VALUES ("S123_8","010_23_8","1SA","23","8","8","Munu Saulalu wituṉu palumpa panya tjaultji tjuṯa ritiringkula ankula Kiilala wirkaṟa para-tjatutjuṟa Davidanya witintjaku. ");
INSERT INTO pjt_vpl VALUES ("S123_9","010_23_9","1SA","23","9","9","Palu wati kutjupangku kuliṟa pitjala Davidala tjakultjunu. Ka Davidalu kulinu munu Apiyatjala wangkangu, “Tjukurtjaraku panya mantara ngalya-kati ngayulakutu, kala Godala tjapilku.” ");
INSERT INTO pjt_vpl VALUES ("S123_10","010_23_10","1SA","23","10","10","Ka mantara panya palunya ngalya-katingu, ka Davidalu Godala tjapiningi munu wangkangi alatji, “Mayatja Israelku God! Panya nyuntumpaṉa ngayulu waṟkaripai. Kutjupangkuṉi tjakultjunu Saulalu kunyu kuliningi tawunu nyangangka pitjala uwankara wiyantjikitjangku waḻi tjuṯa kuḻu, panya ngayulu tawunu nyangangka nyinanyangka. ");
INSERT INTO pjt_vpl VALUES ("S123_11","010_23_11","1SA","23","11","12","Mayatja, wiṟungkuṉi tjakultjura – mulapaṉiya nyanga Kiilanya nguraṟa tjuṯangku witiṟa ungkuku Saulanya, kaṉi pitjala witilku?” Ka Mayatja Godalu palula wangkangu, “Uwa, tjana nyuranya wantir'iyalku alatjiṯu Saulalu witiṟa katinytjaku.” ");
INSERT INTO pjt_vpl VALUES ("S123_13","010_23_13","1SA","23","13","13","Ka Davidalu munu palumpa tjaultji tjuṯangku Kiilanya kuwariṯu wantikatingu Saulalu tjananya pitjala witintjaku-tawara. Munuya para-ngaṟangi ngura tjuṯangka nguḻu wati panya nampa nyanganpa 600-tu. Ka Saulalu kulinu Davidalu Kiilanya wantikatinytja, munu wantira ma-nyinangu ankunytja wiya. ");
INSERT INTO pjt_vpl VALUES ("S123_14","010_23_14","1SA","23","14","14","Ka Davidanya tjana puḻingka kumpiṟa nyinangi ilytjingka ngura panya Tjipala itingka. Ka Saulalu Davidanya rawangkuṯu nguriningi, palu Godalu Saulanya alpamilantja wiyangku wantingu alatjiṯu, ka puṯu nguriningi. ");
INSERT INTO pjt_vpl VALUES ("S123_15","010_23_15","1SA","23","15","15","Ka tjiṉṯu kutjupa Davidanya ngura ini Uuṟitjala nyinangi Tjipala itingka. Panya paluṟu kuliningi, “Mulapa, Saulalu ngayunya iluntankunytjikitjangku ngurini.” ");
INSERT INTO pjt_vpl VALUES ("S123_16","010_23_16","1SA","23","16","17","Ka Saulaku panya katja Jonathannga anu ngura nyara palulakutu palumpa panya maḻpa nyakunytjikitja Davidanya, munu wirkaṟa palula wangkangu alatji, “Nguḻu wiya rapa nyinama, panya Mayatja Godalunta aṯunytju kanyini! Ngayuku mamangkunta nyuntunya pungkunytjikitjangku puṯu alatjiṯu ngurilku. Panya paluṟu ninti nyuntu ngula Israelku mayatjariku. Ka nyuntu mayatjarinyangka ngayulu nyuntumpa tjaultji tjuṯaku mayatjarira nyinaku.” ");
INSERT INTO pjt_vpl VALUES ("S123_18","010_23_18","1SA","23","18","18","Munu pulanku Jonathantu pula Davidalu kalkuṉu Mayatja Godala miṟangka maḻpa mulapa tiṯutjara nyinanytjikitjangku, pika wiyakitjangku. Munu Jonathannga kalkuntjatjanu anu ngurakutu maḻaku, ka Davidanya nyinangi ngura panya Uuṟitjala. ");
INSERT INTO pjt_vpl VALUES ("S123_19","010_23_19","1SA","23","19","19","Ka ngula aṉangu Tjipanya nguraṟa kutjupatjara Saulaku ngurakutu anu Kipiyalakutu munuya palula wangkangu, “Davidanya nganampa ngurangka itingka kumpiṟa nyinanyi ngura panya Uuṟitjala puḻi ini Aakilala. ");
INSERT INTO pjt_vpl VALUES ("S123_20","010_23_20","1SA","23","20","20","Ka nyuntu ngula mukuringkulampa pitja nganampa ngurakutu, kala nyuntunya Davidanya witintjaku nintilku.” ");
INSERT INTO pjt_vpl VALUES ("S123_21","010_23_21","1SA","23","21","21","Ka Saulalu nyangatja kuliṟa puḻkaṟa pukuḻaringu munu tjanala wangkangu, “Wiṟu mulapa nyangatja panya nyuraṉi wiṟungku alpamilaṉi Davidanya witintjaku, kaṉa Mayatja Godala tjapilku nyuranya pukuḻmankunytjaku. ");
INSERT INTO pjt_vpl VALUES ("S123_22","010_23_22","1SA","23","22","22","Ala, walaya ara nguraku munuya wirkaṟa para-nguriṟa kulila aṉangu ngananya tjanaya palulakutu rawa ankupai, munuya ma-nyawa kuḻu yaaltjingka paluṟu kumpiṟa nyinanyi, panya paluṟu kunyu ayinayini mulapa. ");
INSERT INTO pjt_vpl VALUES ("S123_23","010_23_23","1SA","23","23","23","Uwa, ngura tjuṯangkaya para-ngurila munuya nyawa paluṟu kumpiṟa nyinanyangka, munuṉiya maḻaku pitjala tjakultjura, kaṉa nyurala tjunguriwa munula ngura nyara palulakutu ara. Ka paluṟu ngura nyara palulaṯu nyinanyangkampaṉa ngayulu palunya nyakula witilku alatjiṯu. Palu wiyangkaṉa ngayulu palunya wantinytja wiyangku rawangku alatjiṯu ngurilku manta winkingka Judah-lawanungku.” Alatji Saulalu tjanala wangkangi. ");
INSERT INTO pjt_vpl VALUES ("S123_24","010_23_24","1SA","23","24","24","Kaya maḻaku anu ngura Tjipalakutu. Ka Davidanya palumpa tjaultji tjuṯatjara kumpiṟa nyinangi ilytjingka puḻi ngura ini Mayanta uḻpaṟira ailurungka. ");
INSERT INTO pjt_vpl VALUES ("S123_25","010_23_25","1SA","23","25","25","Ka Saulanya wirkanu tjaultji tjuṯatjara ngura ini Tjipala munuya nguriningi Davidaku. Ka kulintjatjanungku kutjupangku Davidala wangkangu, “Saulalunta ngurini.” Kaya Davidanya tjana anu ngura kutjupakutu munuya kumpiṟa ma-nyinangi puḻi puḻkangka ngura panya Mayanta. Palu kutjupangku tjananya Saulala wangkangu kumpiṟa nyinanytja, ka Saulalu tjana kuliṟa waṉaṉu alatjiṯu ngura nyara palulakutu munuya para-nguriningi Davidanya. ");
INSERT INTO pjt_vpl VALUES ("S123_26","010_23_26","1SA","23","26","26","Munuya puḻi kampa kutjupawanungku para-nyakula arintanangi, ka Davidanya tjana puḻi kampa kutjupa palulaṯu mapalku para-pitjangu Saulaku nguḻu. Ka Saulanya tjana ngalya-ilaringangi Davidanya tjananya witintjikitja. ");
INSERT INTO pjt_vpl VALUES ("S123_27","010_23_27","1SA","23","27","27","Palu wati kutjupangku pitjala Saulala tjakultjunu, “Maḻakuya warpungkula pitja! Pilitjiyanya nguraṟa tjuṯaya nganampa ngurangka wirkanu.” ");
INSERT INTO pjt_vpl VALUES ("S123_28","010_23_28","1SA","23","28","28","Ka tjananya Saulalu markuṉu palumpa panya tjaultji tjuṯa Davidanya witintja wiyaku, kaya mulapaṯu wantira maḻaku anu Pilitjiyanya nguraṟa tjuṯa pika pungkunytjikitja. Ka Davidanya tjana wankaṟu anu munuya ngura palunyalta iniṉu, ‘Puḻi Wankaṟunkupainya’. ");
INSERT INTO pjt_vpl VALUES ("S123_29","010_23_29","1SA","23","29","29","Munuya ngura panya palunya wantikatira puḻi kutjupa kuḻpitjarangka wirkaṟa nyinangi ngura ini In-Kitila. ");
INSERT INTO pjt_vpl VALUES ("S124_1","010_24_1","1SA","24","1","1","Munu Saulanya palumpa tjaultji tjuṯatjara Pilitjiyanya nguraṟa tjuṯangka pikaringkunytjatjanu maḻaku pitjangu, ka kutjupangku palula tjakultjunu, Davidanya ilytjingka kumpiṟa nyinanytja ngura In-kitila itingka. ");
INSERT INTO pjt_vpl VALUES ("S124_2","010_24_2","1SA","24","2","2","Ka Saulalu wati Israelkunu tjaultji wiṟu tjuṯa kutju ngurkantanu nampa 3,000, munu tjananya katingu Davidanya ngurintjaku. Ka ngura nyara In-kitila itingka Davidanya wati maḻpa tjuṯatjara kumpiṟa nyinangi puḻi ini Nanikuta Inuṟala. ");
INSERT INTO pjt_vpl VALUES ("S124_3","010_24_3","1SA","24","3","3","Ka Saulanya palumpa tjaultji tjuṯatjara iwarangka ankula ankula wirkanu tjiipiku yaatangka iwarangka itingka, ka nyara palula kuḻpi ngaṟangi. Ka Saulanya kuḻpi palula tjarpangu tuwilataku. Palu Davidanya tjana kuḻpi nyara palula unngu mulapa kumpiṟa nyinangi, munuya Saulanya ngalya-tjarpanyangka nyangangi. ");
INSERT INTO pjt_vpl VALUES ("S124_4","010_24_4","1SA","24","4","4","Munuya wati panya tjuṯangku Davidala tjaalymaṟa wangkangi, “Ala, panya Mayatja Godalunta ngaṉmanytju alpamilantjikitjangku kalkuṉu, ka tjinguṟu alatjiṯulta tjiṉṯu nyanga paluṟu ngaṟanyi nyuntumpa mirpaṉtju tjuṯa pungkula wiyantjaku.” Ka Davidanya maṟamaṟa pitjangu Saulalakutu munu mantara panya Saulaku tjukutjuku kaṯaṉu kuuta tjaṉatja purkaṟa mulartu, ka Saulalu palumpa kuuta kaṯannyangka kulintja wiyaṯu. ");
INSERT INTO pjt_vpl VALUES ("S124_5","010_24_5","1SA","24","5","5","Palu maḻangka Saulaku kuuta kaṯantjatjanu Davidanya puḻkaṟa kuṉṯaringu. ");
INSERT INTO pjt_vpl VALUES ("S124_6","010_24_6","1SA","24","6","7","Munu paluṟu wangkangu wati panya tjaultji tjuṯangka, “Wantiya kura wangkanytja wiyangku. Nganaṉa Saulanya pungkunytja wiya, panya Godalu palunya ngurkantaṟa tjunu nganampa mayatja kinga nyinanytjaku, kaṉa palulanguṟu palula puṯu tungunpunganyi. Ngayulu Mayatja Godala tjapini nganaṉanya markuntjaku nganaṉa Saulanya pungkunytjaku-tawara.” Alatji Davidalu wangkara painingi palumpa tjaultji tjuṯa. Ka Saulalu kulintja wiyaṯu munu kuḻpinguṟu ma-pakaṉu. ");
INSERT INTO pjt_vpl VALUES ("S124_8","010_24_8","1SA","24","8","8","Ka Davidanya ma-pakaṉu kuḻpinguṟu panya munu ma-mirangu Saulaku, “Mayatjan wiṟu!” Ka Saulalu urulyaraṟa maḻakukutuṟa nyangu Davidanya tultjungaṟakatira yunpangku manta pampunnyangka. ");
INSERT INTO pjt_vpl VALUES ("S124_9","010_24_9","1SA","24","9","9","Ka Davidalu palula wangkangu, “Aṉangu kutjupa tjuṯangkuya nyuntula ngunti wangkanyi ngayulu nyuntunya iluntankunytjikitjangku wangkanyangka-palku. Palu tjanala kulintja wiyangku wantima. Nguntiya wangkanyi. ");
INSERT INTO pjt_vpl VALUES ("S124_10","010_24_10","1SA","24","10","10","Kulila, panya Mayatja Godalunta nyuntunya kuwari ngalya-katingu kuḻpikutu, kaṉanta tjinguṟu nyara palula alatjiṯu iluntanama. Panya wati tjuṯangkuṉiya wituwituningi nyuntunya iluntankunytjaku, palu wantingiṉa munuṉa wangkangu tjanala, ‘Wiya ngayulu puṯu ngayuku mayatja kinga wiyaṉi, panya Mayatja Godalu palunya kinga ngurkantaṟa mayatja nganampa tjunu.’ Alatji wangkaraṉa tjananya painu.” Munu Davidalu piṟuku Saulala purkaṟangku wangkangu, ");
INSERT INTO pjt_vpl VALUES ("S124_11","010_24_11","1SA","24","11","11","“Mayatjan wiṟu! Nyangatja nyawa nyanga maṟangkuṉa kanyini! Nyuntumpa panya kuutaṉa tjukutjuku ankala kaṯaṉu. Tjinguṟuṉanta mulapa nyara palula aṟa iluntanama. Palu wiya, nyuntunyaṉa wantir'iyaṉu iluntankunytja wiyangku. Ka nyanga palulanguṟu kulinma, panya ngayulu nyuntunya wiyantjikitja mukuringkunytja wiya. Munuṉa puṯu mukuringanyi mayatja nyuntumpa aṟangka nyinanytjikitja. Panya ngayuluṉa nyuntumpa kura palyantja wiyaṯu, palu nyuntu panyaṉin rawangku aṟuningi ngayunya iluntankunytjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("S124_12","010_24_12","1SA","24","12","12","“Wanyu kulila, ka Mayatja Godalu ngalinya kutju kutju tjukaṟurungku ngurkantankuku. Panya nyuntu ngayuku ngunti-ngunti rawangku palyaṉi, ka tjinguṟu Mayatja Godalu nyuntunya pungkuku, palu ngayulu nyuntunya pungkunytja wiya. ");
INSERT INTO pjt_vpl VALUES ("S124_13","010_24_13","1SA","24","13","13","Nyuntu ninti tjukurpa nyangaku panya aṉangu tjuṯangku iriti wangkapai alatji, ‘Aṉangu kura tjuṯangku kutjuya kura tjuṯa palyalpai.’ Ka nyuntu nguḻuringkunytja wiya nyinama panya ngayuluṉa nyuntunya iluntankunytja wiya. ");
INSERT INTO pjt_vpl VALUES ("S124_14","010_24_14","1SA","24","14","14","“Ngayuluṉa puḻka wiya, kaṉin nyaaku rawangku aṟuṉi iluntankunytjikitjangku? Ngayuluṉa papa ilunytja puṟunypa, puḻka wiya, kaṉin nyaaku mayatja puḻkangku ngayunya punpunpa puṟunypa waṯaparaṉi? ");
INSERT INTO pjt_vpl VALUES ("S124_15","010_24_15","1SA","24","15","15","Uti Mayatja Godalu ngalinya ngurkantanama ngananya tjukaṟuru. Uti paluṟu ngayunya nyangama tjukaṟuru nyinanyangka, munu nyuntulanguṟu ngayunya wankaṟu kanyinma.” Alatji Davidalu wangkangu. ");
INSERT INTO pjt_vpl VALUES ("S124_16","010_24_16","1SA","24","16","16","Ka wangkara wiyaringkunyangka Saulalu palula tjapinu, “Davida! Mulapan nyuntuṯu palatja?” Munu paluṟu ulangu. ");
INSERT INTO pjt_vpl VALUES ("S124_17","010_24_17","1SA","24","17","17","Munu wangkangu, “Nyuntun wati palya ngayula munkara mulapa panya nyuntu wiṟu tjuṯa palyaningi ngayuku, kaṉa ngayulu kura tjuṯa kutju palyaningi nyuntumpa. ");
INSERT INTO pjt_vpl VALUES ("S124_18","010_24_18","1SA","24","18","18","Ka nyangatja Mayatja Godalu ngayunya ngalya-katingu nyuntulakutu, kaṉitjun tjinguṟu iluntanama, palu wiya, nyuntun wantingu wanka nyinanytjaku. Palulanguṟuṉanta kulini nyuntun wati palya mulapa. ");
INSERT INTO pjt_vpl VALUES ("S124_19","010_24_19","1SA","24","19","19","Panya warmaḻangku wati kutjupa witiṟa wanka walatjunkupai wiya, palu nyuntun wiṟu palyaṉu ngayuku kuwari, munu panyaṉin wantir'iyaṉu ankunytjaku, kaṉa palulanguṟu Mayatja Godala tjapini wiṟu mulapa nyuntumpa palyantjaku. ");
INSERT INTO pjt_vpl VALUES ("S124_20","010_24_20","1SA","24","20","20","“Kaṉa kulini ngula nyuntun Israelkunu tjuṯaku mayatjariku munun kuṉpungku tjananya aṯunymaṟa kanyilku aṉangu tjuṯa. ");
INSERT INTO pjt_vpl VALUES ("S124_21","010_24_21","1SA","24","21","21","Wiṟungkuṉi kalkula Mayatja Godala miṟangka ngayuku walytja tjuṯa iluntankuwiyangku wantinytjikitjangku, ka aṉangu tjuṯangku nganaṉanya ini watarkuriwiyangku rawangku kulinma.” ");
INSERT INTO pjt_vpl VALUES ("S124_22","010_24_22","1SA","24","22","22","Ka Davidalu kalkuṉu Saulala, ka Saulanya tjana ngurakutu maḻaku anu. Ka Davidanya wati tjuṯatjara maḻaku anu ngura panya puḻi tjuṯatjarakutu piṟuku kumpiṟa nyinanytjikitja ilytjingka. ");
INSERT INTO pjt_vpl VALUES ("S125_1","010_25_1","1SA","25","1","1","Uwa, ka nyara palula aṟangka wangkatjara wati Samuelnga tjiḻpi mulararingu munu wiyaringu. Kaya aṉangu Israelkunu uwankara tjituṟu-tjituṟurira pitjangu ngura panya Raamalakutu tjunguringkula nyinanytjikitja. Raamanya panya Samuelku ngura kaya palunya ngura walytjangka tjuṉutjunu. Ka palula maḻangka Davidanya ilytjikutu anu ngura ini Mayantakutu ngura tjunkula nyinanytjikitja. ");
INSERT INTO pjt_vpl VALUES ("S125_2","010_25_2","1SA","25","2","3","Ka ngura nyara Mayanta wati kutjupa mani puḻkatjara nyinangi ini Napalnga tawunungka itingka Kaamulta. Paluṟu panya wati Calebakunu, munu manta nyara palula tjiipi 3,000 aṯunymaṟa kanyilpai, nanikuta 1,000 kuḻu tjunguṟa. Ka kuri palumpa ini Apikailnga, kungkawaṟa wiṟu mulapa nintipuka alatjiṯu. Palu Napalnga panya wati pikaṯi mulapa munu ngaḻṯunytju wiya alatjiṯu. Ka nyara palula aṟangka palumpa waṟka tjuṯangku palumpa tjiipi tjuṯa tjiiṟamilaningi ngura nyara palumpangka Kaamulta. ");
INSERT INTO pjt_vpl VALUES ("S125_4","010_25_4","1SA","25","4","4","Ka Davidnya ilytjingka nyinangi munu kulinu tjana tjiipi tjiiṟamilannyangka. ");
INSERT INTO pjt_vpl VALUES ("S125_5","010_25_5","1SA","25","5","6","Munu paluṟu wati yangupala 10-pa wituṟa iyaṉu, “Araya ngura nyara Kaamultakutu munuya Napalta ma-wangka ngayulu nyanga wangkanytja alatji, ‘Wiṟu ngana! Palya nyura nyinanyi pukuḻpa? ");
INSERT INTO pjt_vpl VALUES ("S125_7","010_25_7","1SA","25","7","7","Mayatja nganampangku nyuranya kulinu tjiipi tjuṯa tjiiṟamilannyangka, mununku paluṟu mukuringanyi nyuntu nyanga alatji kulintjaku, panya mungaṯula ngura nyangangka nyinangi, nyuntumpa waṟka tjuṯangku tjiipi tjuṯa kanyinnyangka, munula tjananya kurantja wiyangku wantingi, kaya palya alatjiṯu nyinangi. Munu panyala nyuntumpa kutjupa kutjupa tjuṯa kutitjunkunytja wiyangku alatjiṯu wantingi. ");
INSERT INTO pjt_vpl VALUES ("S125_8","010_25_8","1SA","25","8","8","Wanyu tjanala tjapata pala tjuṯangka tjapila, kantaya tjukaṟurungku wangkaku. ‘Kalampa wanyu ngaḻṯuringama. Nyangatjala kuwari pitjangu mai puḻka ngalkunnyangka ngatjintjikitja. Wanyuya nganampa mayatjaku ngaḻṯuringama nyuntumpa panya maḻpaku, Davidaku, munulanya mai ungkul'iyala panya nganaṉala uwankara walytjaṟara walytjaṟara.’ Alatjiya ankula ma-wangka wati panya Napalta.” Alatji Davidalu tjanala wangkara wituṟa iyaṉu wati panya yangupala 10-pangka. ");
INSERT INTO pjt_vpl VALUES ("S125_9","010_25_9","1SA","25","9","9","Kaya mulapaṯu ankula palula ma-tjakultjunu wati panya Napalta, munuya palula wangkara wiyaringkula paṯaṟa ngaṟangi. ");
INSERT INTO pjt_vpl VALUES ("S125_10","010_25_10","1SA","25","10","10","Palu Napaltu tjananya waṟu-waṟungku mirpaṉarira kuraṟa warkingu wati panya tjuṯa, “Wampa! Davida yaalitja nyura wangkanyi? Ngayuluṉa palumpa ngurpa alatjiṯu, kulintja wiyatja. Nyaaku nyarangku wanyu wati puḻkangku-palku kaṉany-kaṉanytju nyinara wangkanyi? Wiya, paluṟu tjinguṟu palumpa mayatjanguṟu nguḻu wirtjapakantjatjanungku wangkanyi. Panya waṟka tjuṯaya mayatja tjuṯanguṟu kumpiṟa wirtjapakalpai, ka tjinguṟu paluṟu palu puṟunypaṯu. ");
INSERT INTO pjt_vpl VALUES ("S125_11","010_25_11","1SA","25","11","11","Kulilaya, mai kuka nyangatja nganampa kutju pauṉu ngayuku munu waṟka tjuṯaku kutju, palu Davidanya nyuranyaṉa ungkunytja wiya alatjiṯu.” ");
INSERT INTO pjt_vpl VALUES ("S125_12","010_25_12","1SA","25","12","12","Kaya wati panya yangupala 10-pa ngurakutu maḻaku anu munuya Davidala tjakultjunu wati panya Napaltu wangkanytja uwankara. ");
INSERT INTO pjt_vpl VALUES ("S125_13","010_25_13","1SA","25","13","13","Ka Davidalu palumpa panya tjaultji uwankarangka wangkangu, “Ala! Tjuḻaya mantjila!” Kaya mulapaṯu mantjinu, ka paluṟu tjula mantjinuṯu. Kaya tjaultji paluṟu tjana ritiringkula Davidala tjungu anu pikakitja nampa nyanganpa 400, palu tjaultji 200 kutjupa-tjaraya nyinangi maḻaringkula ngura anga-kanyintjikitja. ");
INSERT INTO pjt_vpl VALUES ("S125_14","010_25_14","1SA","25","14","14","Palu Napalku wati waṟka kutju anu Apikailtakutu, palumpa panya kurikutu, munu palula alatji wangkangu, “Kulinun? Panya Davidalu wati yangupala 10-pa wituṟa iyaṉu nyuntumpa kurikutu, kaya palulakutu pitjala wiṟuṟa wangkangi, palu nyuntumpa kuringku tjananya kuraṟa waṟu-waṟungku warkira paiṟa iyaṉu mai munu kuka ungkunytja wiyangku. ");
INSERT INTO pjt_vpl VALUES ("S125_15","010_25_15","1SA","25","15","15","Kala nganaṉa nyakula tjituṟu-tjituṟuringu palumpa tjanampa. Tjana wati wiṟu tjuṯa ngaḻṯunytju, munulanya kuraṟa pungkupai wiya, panya tjana mukulyangku nganaṉanya aṯunymaṟa kanyilpai kutjupa tjuṯangku tjulyaṟa katinytjaku-tawara. ");
INSERT INTO pjt_vpl VALUES ("S125_16","010_25_16","1SA","25","16","16","Paluṟu tjana mungangka kaḻaḻa kuḻu nganaṉala itingka para-ngaṟapai, munulanya aṯunymankupai wiṟuṟa wankaṟu nyinanytjaku. ");
INSERT INTO pjt_vpl VALUES ("S125_17","010_25_17","1SA","25","17","17","Palu kuwari nyuntumpa kuringku Davidanya tjananya warkingu, wati panya palumpa tjaultji tjuṯa kuḻu, munu mai kuka ungkuwiyangku wantingi, kaya maṟalpa anu, ngaḻṯutjara. Ka nyanga palulanguṟu Davidalu tjinguṟu nganampa taṟapula palyalku, nyuntumpa walytja uwankaraku kuḻu. Panya nyuntumpa kuri wati mirpaṉtju alatjiṯu, kutjupangka kulilpai wiya. Ka wanyu nyuntu purkaṟangku kulinma, munu Davidaku tjanampa wiṟu palyala, pitjala nganaṉanya pungkunytjaku-tawara.” Alatji wati Napalku waṟkangku wangkangu. ");
INSERT INTO pjt_vpl VALUES ("S125_18","010_25_18","1SA","25","18","18","Ka Napalku kuringku tjukurpa nyangatja kuliṟa mapalkungku kulinu Davidala tjanalakutu mai kuka katinytjikitjangku, munu paluṟu mai nyuma 200 tjunu munu piti puḻka kutjarangka waina tjutinu, munu kuka tjiipi 5 ngaṉmanytju pauṟa uṉmi tjunu, munu yakutja puḻkangka mai wiita tjutinu, munu raitjinpa kapuṯuṟa puḻka tjunu munu mai nyuma 200 ilinguṟu palyantja kuḻu tjunu. Munu mai nyanga uwankara utuluṟa katinytjikitjangku tangkiyi tjuṯangka utitjunu. ");
INSERT INTO pjt_vpl VALUES ("S125_19","010_25_19","1SA","25","19","19","Munu palulanguṟu Apikailtu palumpa waṟkaripai tjuṯangka aḻṯira wangkangu, “Nyura-waraṟa kuranyuri mai pala tjuṯatjara, kaṉa ngayulu nyurala maḻangkaṯu anama ngayuku tangkiyingka.” Palu paluṟu palyantja uwankara palumpa kuringka wangkawiyangku wantingi. ");
INSERT INTO pjt_vpl VALUES ("S125_20","010_25_20","1SA","25","20","20","Munu paluṟu tangkiyingka tatiṟa ma-pakaṉu, munu puḻi nguṟurwanu anangi. Munu ankula ankula para-arintaṟa nyangu Davidanya wati tjuṯatjara iwara kutju palulaṯu ngalya-wirkankunyangka. ");
INSERT INTO pjt_vpl VALUES ("S125_21","010_25_21","1SA","25","21","21","Palu paluṟu pulanku nyakunytja kuwaripangka Davidalu palumpa tjungutja tjuṯangka mirpaṉ-mirpaṉṯu wangkakatingi wati Napalngatjara alatji wangkara, “Panya palumpa wati waṟkaripai tjuṯala wiṟuṟa aṯunymanangi, palumpa tjiipi nanikuta tjuṯa kuḻu, kutjupangku tjulyantjaku-tawara. Mulapaṉatju ngayulu palunya tjananya wiṟuṟa aṯunymanangi, kaṉitju nyaanguṟu paluṟu kuraṟa pungangi? ");
INSERT INTO pjt_vpl VALUES ("S125_22","010_25_22","1SA","25","22","22","Palyaṉa palunya kuwari tjiṉṯu pakantja kuwaripangka iluntankuku, palumpa katja tjuṯa munu wati waṟkaripai uwankara kuḻu. Palu wiyangkampa Godaluṉi ngayunya palya iluntankuku.” Nyanga alatji paluṟu wangkakatingi Davidalu, Apikailnga wirkankunytja kuwaripangka. ");
INSERT INTO pjt_vpl VALUES ("S125_23","010_25_23","1SA","25","23","23","Ka Apikailtu Davidanya nyakula mapalku tangkiyinguṟu panya ukalingkula tultjungaṟakatingu Davidala tjinangka, munu yunpangku manta pampuṉu. ");
INSERT INTO pjt_vpl VALUES ("S125_24","010_25_24","1SA","25","24","24","Munu palula wangkangi, “Ngayukun mayatja! Wanyuṉitju ngayunya kulinma, munutju ngayuku kuringku palyantjitjanguṟu ngayunya ngukanma. ");
INSERT INTO pjt_vpl VALUES ("S125_25","010_25_25","1SA","25","25","25","Wiṟu ngana, ngayuku kuri Napalnga panya tjaka wati mirpaṉtju alatjiṯu, ka paluṟu panya wangkanytja kuliṟa wantima. Panya paluṟu tjakangku kura kutju wangkapai munu tjukaṟurungku kulilpai wiya. Wanyu kulila mayatja! Panya nyuntun wati 10-pa ngayuku kurikutu wituṟa iyaṉu maiku ngatjintjaku, palu ngayuluṉa palunya tjananya nyakunytja wiyaṯu pitjanyangka. ");
INSERT INTO pjt_vpl VALUES ("S125_26","010_25_26","1SA","25","26","27","“Palu Mayatja, kuwariṉanku mai puḻka mulapa ngalya-katingu. Wanyu tjananya mantjiṟa uwa, nyuntumpa tjaultji tjuṯa. Panya Mayatja Godalunta kuwari markuṉi wati nyara tjuṯa pungkula iluntankunytjaku-tawara. Munu nyuntunya kurannyangka ngayuku kuri kuwari pungkuku, kaṉa ngayulu mukuringanyi paluṟu nyuntumpa mirpaṉtju tjuṯa kuḻu palu puṟunypaṯu pungkunytjaku. Uwa, Mayatja Godala miṟangkaṉa nyangatja mulamulangku wangkanyi, nyuntula miṟangka kuḻu. ");
INSERT INTO pjt_vpl VALUES ("S125_28","010_25_28","1SA","25","28","28","“Wati ngana, mayatja wiṟu, ngaḻṯuriwatju! Munuṉitju kura ngayulu palyantjitjanguṟu pungkuwiyangku wantima kalypangku. Ngayulu kulini panya ngulanta Mayatja Godalu Israelku mayatjarinytjaku tjunkuku, panya nyuntun Mayatja Godaku mirpaṉtju tjuṯa pikaringkula pungkupai alatjiṯu. Kaya nyuntumpa katja munu pakaḻipiṯi maḻatja maḻatja palu puṟunypaṯu nyuntumpa aṟangka Israelku mayatjarira nyinara waṉalku. Kaṉa nyuntumpa Godala tjapini nyuntunya tiṯutjarangku tjukaṟuru kanyintjaku kura palyantjaku-tawara. ");
INSERT INTO pjt_vpl VALUES ("S125_29","010_25_29","1SA","25","29","29","Ka nyuntumpa mirpaṉtju tjuṯangku nyuntunya iluntankunytjikitjangku nyakunyangka Mayatja Godalu nyuntunya wankaṟu kanyilku, munu tjananya mapalku iluntankuku, panya watingku tjangayangka puḻi tjunkula atulpai, palu puṟunypa tjananya mapalku wiyalku. ");
INSERT INTO pjt_vpl VALUES ("S125_30","010_25_30","1SA","25","30","31","“Mayatja Godalu panyanta tjuṯa-aṟangku kalkuṉu Israelku mayatja tjunkunytjikitjangku. Paluṟu panya kalkuntjatjanungku palyalku alatjiṯu. Aṟa panyatja kulila, nyuntu panyan mirpaṉarira aṉangu palya tjuṯa iluntankunytjikitjangku kuliningi. Palu kuwarin iluntankunytjaku wiya nguwanpa ngaṟanyi, kan nyara palulanguṟulta miriputju wiyaringkuku. Uwa, ka Mayatja Godalu uwankara wiṟu tjuṯa nyuntumpa palyaṟa wiyannyangka, wanyuṉi kulinma watarkuriwiyangku, nyuntumpa panya waṟkaripai.” ");
INSERT INTO pjt_vpl VALUES ("S125_32","010_25_32","1SA","25","32","32","Ka minyma panya Apikailta Davidalu alatji wangkangu, “Uwa, kuwariṉa Mayatja Godaku puḻkaṟa pukuḻarinyi panya paluṟunta ngayulakutu iyaṉu wangkanytjaku. ");
INSERT INTO pjt_vpl VALUES ("S125_33","010_25_33","1SA","25","33","33","Ngayulu mukuringanyi nyuntunya Godalu pukuḻmankunytjaku panya nyuntun minyma nintipuka mulapa. Kuwari panyan ngayula tjukurpa wiṟu wangkangi ngayulu kuliṟa tjukaṟurungku palyantjaku kaṉa mulamularinganyi tjukurpa wiṟu kutju kuliṟa. Palulanguṟuṉa Napalnga tjananya pungkuwiyangku wantiku palumpa walytjapiti tjuṯa munu palumpa waṟkaripai tjuṯa kuḻu. ");
INSERT INTO pjt_vpl VALUES ("S125_34","010_25_34","1SA","25","34","34","Uwa mulapaṉi Mayatja Godalu markuṉu Israelku panya Mayatjangku aṉangu tjuṯa pungkuwiyangku wantinytjaku nyuntunya kuḻu. Tjinguṟuṉa mulapa Napalnga tjananya iluntanama palumpa wati uwankara kuḻu, palu nyuntu-waraṟan mapalku wirkanu ngayulakutu wimaṟu nyangaku.” ");
INSERT INTO pjt_vpl VALUES ("S125_35","010_25_35","1SA","25","35","35","Munu Davidanya alatji wangkanytjatjanu puḻkaṟa pukuḻaringu, munu Apikailtanguṟu mai mantjiṟa palula wangkangu, “Kulinuṉa nyuntumpa tjukurpa, munuṉanta kuwari nyanga nyuntula wangkanyi kalypangku pungkuwiyangku wantinytjikitjangku. Ka palyalta ma-pitja ngurakutu pukuḻpa nguḻuringkunytja wiya.” ");
INSERT INTO pjt_vpl VALUES ("S125_36","010_25_36","1SA","25","36","36","Palula maḻangka minyma panya paluṟu maḻaku anu ngurakutu, munu ma-wirkaṟa nyangu palumpa panya kuringku Napaltu mai puḻka palumpa waṟka tjuṯaku palyannyangka. Palu wati panya paluṟu taṟangka puḻka, pukuḻpa mulapa nyinangi, ka Apikailtu wantingi taṟangka nyakula palula tjakultjunkunytja wiyangku Davidaku tjanampa mai katinytjatjanungku. ");
INSERT INTO pjt_vpl VALUES ("S125_37","010_25_37","1SA","25","37","37","Ka mungawinki wati panya Napalnga taṟangka ngarira wiyaringkunyangka Apikailtu palula wangkangu alatji, “Mungartjiṉa Davidaku tjanampa mai katingu palumpa wati tjuṯaku kuḻu, munuli wangkangi, ka Davidalu mai ngayulu ungkunytja mantjinu, munuṉi paluṟu wangkangu pukuḻpa ankunytjaku ngurakutu.” Alatji paluṟu uwankara utingku tjakultjunu palumpa kuringka. Ka wati panya paluṟu kuliṟa mapalku kuṯuṯu tuu-tuukatira ngaṟakatingu munu punkaṟa tiwilpa ngaringi. ");
INSERT INTO pjt_vpl VALUES ("S125_38","010_25_38","1SA","25","38","38","Ka tjiṉṯu 10-pa ngaṟala wiyaringkunyangka maḻangka Mayatja Godalu wantir'iyaṉu wati panya Napalnga ilunytjaku. ");
INSERT INTO pjt_vpl VALUES ("S125_39","010_25_39","1SA","25","39","40","Ka Davidalu kulinu Napalnga ilunytja munu wangkangu, “Wati nyara paluṟu Napaltu kura tjuṯa palyaningi aṉangu tjuṯaku, ka kuwari Mayatja Godalu palunya wiyaṉu. Kaṉa kuwari pukuḻpa nyinanyi, panya paluṟuṉi markuṉu palunya tjananya iluntankunytjikitjangku wangkanyangka. Uwa, Mayatja God, mirawaṉinyiṉanta, panya nyuntun Napalnga wiyaṉu ngayunya kurannyangka.” Ka minyma panya Apikailnga wanakaḻarira ngura aṟangkaṯu nyinangi Kaamulta. Ka Davidalu wati maṉkurpa wituṟa iyaṉu minyma panya palula ankula tjapintjaku, kaya mulapaṯu wirkaṟa palula tjapinu alatji, “Davidanyanku mukuringanyi nyupali tjunguringkula nyinanytjikitja kuriṟara.” ");
INSERT INTO pjt_vpl VALUES ("S125_41","010_25_41","1SA","25","41","41","Ka minyma panya Apikailnga tultjungaṟakatingu munu yunpangku manta pampuṉu, munu Davidaku panya waṟka maṉkurta wangkangu, “Uwa, pukuḻarinyiṉa paluṟu ngayunya aḻṯinytjaku, munuṉa pukuḻarinyiṯu waṟka palumpa palyantjikitja, palumpa waṟka tjuṯa kuḻu tjina paltjintjikitja.” ");
INSERT INTO pjt_vpl VALUES ("S125_42","010_25_42","1SA","25","42","42","Munu wangkanytjatjanu mapalku tatinu tangkiyingka, munu palumpa kungkawaṟa waṟka 5 aḻṯira tjunguringkulaya anu wati panya Davidaku waṟka maṉkurta. Ka tjana wirkankunyangka Davidalu kungka panya palunya aḻṯingu. ");
INSERT INTO pjt_vpl VALUES ("S125_43","010_25_43","1SA","25","43","43","Ngaṉmanytju paluṟu kungkawaṟa kutjupa aḻṯira kanyiningi ini Aki-nuwamanya ngura nyara Tjitjiṟiltanguṟu, munu palulanguṟu Apikailnga aḻṯingu munu pulanya kutjaraṟa kanyiningi. ");
INSERT INTO pjt_vpl VALUES ("S125_44","010_25_44","1SA","25","44","44","Panya ngaṉmanytju mayatja Saulalu palumpa uṉṯalpa ini Mikaalanya ungu Davidalu kuringku aḻṯira kanyintjaku. Palu maḻangka Saulalu Davidaku kuraringkula uṉṯalpa palumpa tjulyaṟa wati kutjupa ungu ini panya Paltiyilnga. Wati nyara paluṟu panya wati ini Layitjiku katja ngura ini Kalimalanguṟu. ");
INSERT INTO pjt_vpl VALUES ("S126_1","010_26_1","1SA","26","1","1","Ka wati tjuṯangku ngura nyara ini Tjipalanguṟu ankula Saulanya nyangu ngura panya Kipiyala nyinanyangka tawunu walytjangka munuya palula wangkangu, “Kulila, Davidanya tjana kumpiṟa nyinanyi puḻingka ngura Akilala ngura ini Tjitjimanta itingka.” ");
INSERT INTO pjt_vpl VALUES ("S126_2","010_26_2","1SA","26","2","2","Ka Saulanya tjana wati warmaḻa 3,000-tjara ritiringkula anu ngura panya piḻṯikutu ini Tjipalakutu Davidanya ngurintjikitja. ");
INSERT INTO pjt_vpl VALUES ("S126_3","010_26_3","1SA","26","3","3","Munuya wirkaṟa ngura tjunu iwarangka itingka puḻi panya Akilala ngura ini Tjitjimanta itingka palu Davidanya kumpiṟa nyinangi ngura nyara piḻṯingka Tjipala. ");
INSERT INTO pjt_vpl VALUES ("S126_4","010_26_4","1SA","26","4","4","Ka Davidalu wati palumpa tjuṯa iyaṉu ankula nyakunytjaku, “Yaaltjingkaya wati panya Saulanya tjana ngura tjunkula nyinanyi?” Kaya ankula ma-nyakula pitjala Davidala tjakultjunu. ");
INSERT INTO pjt_vpl VALUES ("S126_5","010_26_5","1SA","26","5","5","Ka munga kultungka Davidanya wati tjuṯatjara anu ngura nyara palulakutu panya Saulanya tjana ngarinytjalakutu munuya nyangu Saulanya pula Apananya tjanala nguṟurpa ngarinyangka. Kaya palumpa pulampa tjaultji tjuṯa para-ngarira waṉaningi kunkunpa uwankara. (Apananya wati ini Nuupaku katja, munu paluṟu Saulaku tjaultji tjuṯaku mayatja.) ");
INSERT INTO pjt_vpl VALUES ("S126_6","010_26_6","1SA","26","6","6","Ka wati kutjara Davidala tjungu ngaṟangi Ayima-likanya (wati panya Iitakunu) munu Joabaku maḻanypa ini Apitjainya kuḻu. Ka Davidalu palula pulala wangkangu, “Wati ngananya ngayula tjungu pitjaku Saulaku ngurakutu?” Ka Apitjailu wangkangu, “Ngayuluṉa.” ");
INSERT INTO pjt_vpl VALUES ("S126_7","010_26_7","1SA","26","7","7","Ka munga nyara palula Davidanya pula Apitjainya panykalkatira Saulaku ngurangka wirkanu tjana kunkunpa puḻka ngarinyangka, munu pula Saulala itingka ngaṟangi kunkunta. Ka palula katangka itingka palumpa kuḻaṯa muṟutjunkunytja ngaṟangi, kaya Apananya tjana tjaultji tjuṯa kuḻu kunkunpa uwankara ngaringi. ");
INSERT INTO pjt_vpl VALUES ("S126_8","010_26_8","1SA","26","8","8","Ka Apitjailu Davidala tjaalymaṟa wangkangi, “Godalunta kuwari nyuntunya unganyi Saulanya panya nyuntumpa mirpaṉtju. Wanyu kaṉa kuḻaṯa nyanga palumpangka wakaṟa mantangka tjakatjuṟa wanti ka ilu.” ");
INSERT INTO pjt_vpl VALUES ("S126_9","010_26_9","1SA","26","9","9","Palu Davidalu tjaalymaṟa wangkangi, “Wiya iluntankuwiyangku wantima, panya Godalu palunya mayatja ngurkantanu kinga nyinanytjaku, ka kutjupangku pungkunytjaku wiya ngaṟanyi. Palu tjinguṟu kutjupangku palunya iluntankuku, ka Godalu aṉangu nyara palunya wiyalku. ");
INSERT INTO pjt_vpl VALUES ("S126_10","010_26_10","1SA","26","10","10","Palu ngula Godalu mulapa Saulanya wiyalku alatjiṯu. Tjinguṟu paluṟu wati tjiḻpiringkula kutju iluku munta tjinguṟu pikangka iluku. ");
INSERT INTO pjt_vpl VALUES ("S126_11","010_26_11","1SA","26","11","11","Panya Godalu palunya ngurkantanu mayatja kinga nyinanytjaku, kaṉa ngayulu Godalu ngurkantankunytjitja puṯu punganyi. Palu wanyuli kuḻaṯa munu piti nyanga minatjara kutju mantjiṟa kati, munuli ngura nyangatja wantikati!” ");
INSERT INTO pjt_vpl VALUES ("S126_12","010_26_12","1SA","26","12","12","Munu Davidalu kuḻaṯa munu mina panya Saulala katangka itingka ngarinytjanya mantjiṟa katingu munu pula anu. Uwa, Godalu Saulanya munu tjaultji kuḻu kunkuntjunu rawa ngarinytjaku, kaya nyakunytja wiyaṯu pula ngaṟala ankunyangka. ");
INSERT INTO pjt_vpl VALUES ("S126_13","010_26_13","1SA","26","13","13","Palulanguṟu pula ankula puḻi kutjupangka tjukutjuku patu ngaṟanyangka ma-tatinu. ");
INSERT INTO pjt_vpl VALUES ("S126_14","010_26_14","1SA","26","14","14","Munu puḻi katunguṟulta Davidanya mirangu Saulaku tjaultji tjuṯakutu munu tjanampa mayatja Apanala mirara wangkangi, “Apana! Kuliniṉin!” Ka Apananya ngapartji ma-mirangu, “Nganalun palatja mirara urulytjingaṉi nganampa kinga?” ");
INSERT INTO pjt_vpl VALUES ("S126_15","010_26_15","1SA","26","15","15","Ka Davidalu mirara ma-wangkangu, “Nyuntu panya kunyun tjaultji wiṟu mulapa Israelku munun palulanguṟu uti kinga nyuntumpa nyakula aṯunymanama kunkunpa ngariwiyangku, palu wati kutjara nyurala kunkunta ankula ngaṟangi mayatja panya nyuntumpa iluntankunytjikitja. ");
INSERT INTO pjt_vpl VALUES ("S126_16","010_26_16","1SA","26","16","16","Panya Mayatja Godalu Saulanya ngurkantanu Israelkunuku kinga nyinanytjaku. Ka nyura palunya aṯunymankuwiyangku wantirampa ilunytjaku ngaṟanyi. Nyawa kuḻaṯa munu piti minatja palumpa katangka itingka ngarinytja. Kuwari nyura nyanganyi? Pala wiya ngaṟanyi. Ngalili mantjiṟa katingu!” ");
INSERT INTO pjt_vpl VALUES ("S126_17","010_26_17","1SA","26","17","17","Ka Saulalu wankaringkula kuliṟa ngurkantanu Davidanya wangka, munu mirara ma-tjapinu, “Nyuntun palatja Davida, ngayuku panya katja?” Ka Davidalu wangkangu, “Uwa mayatja. Ngayuluṉa nyuntumpa panya waṟkaripainya. ");
INSERT INTO pjt_vpl VALUES ("S126_18","010_26_18","1SA","26","18","18","Nyaakuṉin wataparaṉi? Kutjupa kutjupaṉa nyuntumpa ngunti palyaṉu? ");
INSERT INTO pjt_vpl VALUES ("S126_19","010_26_19","1SA","26","19","19","“Mayatja, wanyuṉi wiṟungku kulila! Tjinguṟu Godalu nyuntunya ngayuku mirpaṉarinytjaku palyaṉi, kan tjinguṟu kuka tiliwakaṟa palunya ungkuku, katju ngayuku kalyparingkuku. Palu tjinguṟu aṉangu tjuṯangku nyuntunya ngayuku mirpaṉarinytjaku palyaṉi, kaṉa ngayulu mukuringanyi Godalu tjananya wiyantjaku, panya paluṟu tjanaṉiya ngura panya Godalu ngayunya ungkunytjitjanguṟu paiṉu kaṉa ngayulu wantikatira anu. Panya wangkanguṉiya ankula goda ngalypa-ngalypa tjuṯa waḻkuntjaku. ");
INSERT INTO pjt_vpl VALUES ("S126_20","010_26_20","1SA","26","20","20","Palu mayatja wiṟungkuṉi wantima ngura malikitjakutu parari wantir'iyantja wiyangku Mayatja Godalanguṟu patu ilunytjaku-tawara. Wanyuṉi kulila wiṟungku! Ngayuluṉa nyuntunya uuḻinkunytja wiya. Ngayulu puḻka wiya tjukutjuku tjiṯu puṟunypa. Nyaakuṉin puḻka-palku ngurini? Panya kutjupangku tjuḻpu kuḻunypa tjuṯaku puḻi katu ngurilpai, palu puṟunypaṉin ngurini.” ");
INSERT INTO pjt_vpl VALUES ("S126_21","010_26_21","1SA","26","21","21","Ka Saulanya kuliṟa kuṉṯaringu munu wangkangu, “Uwa mulapa, kurangkuṉa ngayulu ngunti palyaningi. Katja, wanyutju maḻaku pitja! Panya nyuntuṉin kuwari wankaṟunu iluntankuwiyangku, kaṉanta palulanguṟu nyuntunya ngapartji wantinyi nguḻuṟa aṟuntja wiyangku.” ");
INSERT INTO pjt_vpl VALUES ("S126_22","010_26_22","1SA","26","22","22","Ka Davidalu wangkangu, “Nyangatjanku kuḻaṯa panya! Wati kutjupa wituṟa ngalya-iyala mantjintjaku! ");
INSERT INTO pjt_vpl VALUES ("S126_23","010_26_23","1SA","26","23","23","Panya aṉangu kutjupangku Mayatja Godanya wangaṉarangku kulinnyangkampa palunya paluṟu pukuḻmankupai. Panya paluṟuṉi nyurampa ngurangka kuwari tjarpatjunu, palu pungkunytja wiyaṯuṉa nyuntunya, panya Mayatjalunta ngurkantanu kinga nyinanytjaku. ");
INSERT INTO pjt_vpl VALUES ("S126_24","010_26_24","1SA","26","24","24","Uwa, kuwari ngayulu nyuntunya iluntankunytja wiyangku wantingu. Palulanguṟuṉa ngayulu ngapartji Mayatja Godala tjapini ngayunya wankaṟu anga-kanyintjaku.” ");
INSERT INTO pjt_vpl VALUES ("S126_25","010_26_25","1SA","26","25","25","Ka Saulalu wangkangu, “Kaṉanku Mayatjala tjapini nyuntunya aṯunytju kanyintjaku munu kuṉpungku wiṟu tjuṯa palyantjaku.” Ka Davidanya ma-pakaṟa anu, ka Saulanya maḻaku ngura walytjakutu anu palumpa wati tjaultji tjuṯatjara. ");
INSERT INTO pjt_vpl VALUES ("S127_1","010_27_1","1SA","27","1","1","Palu Davidalu walytjangku alatji kuliningi, “Tjinguṟuṉitju ngula Saulalu ngayunya nguriṟa iluntankuku. Wanyu kaṉatju ngura nyara Pilitjiyalakutu ara, kaṉi Saulalu waṉantja wiyangku wantiku, kaṉatju wankalpi kumpiṟa mauṉṯalpa nyinama.” ");
INSERT INTO pjt_vpl VALUES ("S127_2","010_27_2","1SA","27","2","3","Palulanguṟu Davidanya palumpa tjaultji tjuṯa 600-tjara anu Israelnga wantikatira munuya ngura ini Kaitjala wirkaṟa nyinangi, Pilitjiyanya nguraṟa tjuṯangka tjungu. Ka ngura nyara palumpa mayatja wati ini Akitjanya. Wati nyara paluṟu Mayakaku katja. Ka Davidaku tjaultji tjuṯangku tjananku kuri, tjitji tjuṯa kuḻu tjanala tjungu katingu. Ka Davidalu kuḻunku palumpa kuri kutjara katingu Ayinamanya pulanya Apikailnga. Minyma panya Ayinamanya ngura ini Tjitjaṟiltanguṟu, ka minyma panya kuri kutjupa wati panya Napalku kuri wanakaḻarira nyinanytjanya ngura nyara ini Kaamultanguṟu. ");
INSERT INTO pjt_vpl VALUES ("S127_4","010_27_4","1SA","27","4","4","Ka aṉangu kutjupangku Saulala tjakultjunu Davidanya ankunytja ngura ini Kaitjalakutu, ka kulintjatjanungku Saulalu wantir'iyaṉu piṟuku ngurintja wiyangku. ");
INSERT INTO pjt_vpl VALUES ("S127_5","010_27_5","1SA","27","5","5","Ka tjiṉṯu kutjupalta Davidalu Kaitjaku mayatjangka Akitjala ngatjiningi nguraku nyinanytjikitjangku alatji wangkara, “Nyangatjala nyuntumpa ngurangka tjuṯa mulapa nyinanyi. Palu nyuntu ngayuku pukuḻpa ngaṟalampa nganaṉanya tjura tawunu tjukutjukungka mauṉṯalpa, kala nyara palulalta ngura palyaṟa nyinaku.” ");
INSERT INTO pjt_vpl VALUES ("S127_6","010_27_6","1SA","27","6","6","Ka nyara palula aṟangka Davidanya Akitjalu ungulta ngura ini Tjikalakanya, ka palulanguṟulta ngura nyara paluṟu Judah-kuringu Israelkunu panya tjuṯaku. ");
INSERT INTO pjt_vpl VALUES ("S127_7","010_27_7","1SA","27","7","7","Ka Davidanya tjana manta nyara Pilitjiyala kuḻi kutju munu piṟa kutjara kutjara nyinangi. ");
INSERT INTO pjt_vpl VALUES ("S127_8","010_27_8","1SA","27","8","8","Munuya tjiṉṯu nyara palula tjanala nguranguṟu warmaḻarira ankupai ngura tjuṯakutu munuya para-ngaṟala aṉangu tjuṯa pungkula iluntankupai ngura ini nyanga tjananya Kitjurkunu tjuṯa munu Kuutjukunu tjuṯa munu Ama-likakunu tjuṯa. Aṉangu nyara paluṟu tjanaya ngura walytjangka iritinguṟu alatjiṯu nyinangi rawa mulapa. Palumpa tjanampa manta uḻpaṟira ma-ngaringi tjaṟukutu Itjipalakutu. Ngura nyara paluṟu uṟil-uṟilpa puḻka. ");
INSERT INTO pjt_vpl VALUES ("S127_9","010_27_9","1SA","27","9","9","Ka Davidalu palumpa warmaḻa tjuṯatjarangku tjanampa ngurangka tjarpara wati minyma uwankara iluntankupai munuya tjanampa kuka tjuṯa katipai tjiipi, tangkiyi, kamula, puluka munu tjanampa mantara tjuṯa kuḻu. Munu paluṟu ankupai mayatja Akitjalakutu. ");
INSERT INTO pjt_vpl VALUES ("S127_10","010_27_10","1SA","27","10","10","Ka mayatjangku panya Davidala tjapilpai, “Ngura ngananya nguraṟa tjuṯan kuwari pungangi?” Ka Davidalu palunya tiṯutjarangku ngunti kuralpai. Kutjupa-aṟa paluṟu wangkapai, “Judah-lakutula anu.” Munu piṟuku kutjupa-aṟa paluṟu wangkapai, “Ngura Tjiṟamiltakutula anu.” Munu piṟuku kutjupa-aṟa wangkapai, “Kiinkunu tjuṯakutula anu.” Tiṯutjarangku paluṟu alatji ngunti wangkapai mayatja panya palula. ");
INSERT INTO pjt_vpl VALUES ("S127_11","010_27_11","1SA","27","11","11","Palu Davidanya tjana ngura nyara palula tjanalakutu ankunytja wiyaṯu. Palu paluṟu tjana rawa ankupai ngura ititja tjuṯakutu munuya aṉangu Pilitjiyanya nguraṟa tjuṯa iluntaṟa wiyaṟa aṉangu kutjupa witiṟa ngurakutu katinytja wiyaṯu. Ka kutjupa wanka nyinanytja wiya pitjala mayatja Akitjala tjakultjunkunytjikitja, ka mayatjangku panya kulintja wiya Davidalu Pilitjiyanya nguraṟa tjuṯaku tawunungka tjarpara tjuṯa pungkunytja, Israelnga nguraṟa wiya. ");
INSERT INTO pjt_vpl VALUES ("S127_12","010_27_12","1SA","27","12","12","Ka wati panya mayatja Akitjalu kuliṟa mulamularingu alatjiṯu Davidalu wangkanyangka munu unngu alatji kuliningi, “Tjinguṟu kuwari Israelkunu tjuṯa Davidaku kuraringkuku puḻkaṟa alatjiṯu, ka paluṟu ngayuku maḻpalta nyinaku ngayula tiṯutjara.” Paluṟu ngunti kuliningi Israelkunu tjuṯa pungkunyangka-palku. ");
INSERT INTO pjt_vpl VALUES ("S128_1","010_28_1","1SA","28","1","3","Ngaṉmanypa panya Samuelnga Israelta wanka nyinanyangkalpi aṉangu kutjupa tjarangku miri ilunytja tjuṯangka kurunta wangkapai Godala tungunpungkula, ka tjananya Saulalu Israeltanguṟu paiṟa iyaṉu. Ka palulanguṟulta ngula Samuelnga ilungu, kaya Israelkunu tjuṯa tjituṟu-tjituṟurira puḻkaṟa ulangi munuya palunya ngura walytjangka tjuṉutjunu tawunu ini Raamala. Ka tjiṉṯu kutjupa Pilitjiyanya nguraṟa tjuṯa pitjangu pika pungkunytjikitja Israelkunu tjuṯa. Ka Pilitjiyaku mayatjangku Akitjalu Davidala wangkangu, “Nyuntu munu nyuntumpa wati tjuṯa kuḻu uti ngayula tjunguringama Israelkunu tjuṯa pungkunytjikitja.” Ka Davidalu ngunti palula uwanmanu alatji wangkara, “Uwa, palya, nganaṉala tjunguringanyi, kan nyakukulta nganaṉa tjananya puḻkaṟa pungkunyangka.” Ka Akitjalu Davidala wangkangu, “Palu nyura tiṯutjara ngayula tjungu para-ngaṟama, munuṉitjuya puḻkaṟa aṯunymanama, palya?” ");
INSERT INTO pjt_vpl VALUES ("S128_4","010_28_4","1SA","28","4","4","Kaya Pilitjiyanya nguraṟa tjuṯangku pitjala ila ngura tjunu tawunu ini Tjuninta. Ka Saulalu tjana Israelkunu tjuṯangku puḻi murpu ini Kilpawala itingka ngura tjunuṯu. ");
INSERT INTO pjt_vpl VALUES ("S128_5","010_28_5","1SA","28","5","5","Munu Saulalu Pilitjiyanya nguraṟa wati warmaḻa tjuṯa nyakula puḻkaṟa nguḻuringu. ");
INSERT INTO pjt_vpl VALUES ("S128_6","010_28_6","1SA","28","6","6","Munu Mayatja Godala tjapiningi, “Yaaltjirikulanku?” Palu Mayatjalu palula wangkanytja wiyangku alatjiṯu wantingi. Munu palu puṟunypaṯu tjukurmankunytja-wanungku kuḻu utintja wiyangku wantingi. Ka wati tjukurtjarangku arkaṟa puṉu ngurkantankupai kutjara waṉingu nyakunytjikitjangku, palu Godalu puṉu nyara palulawanungku kuḻu utintja wiyaṯu. Munu wati panya wangkatjara tjuṯangka kuḻu paluṟu tjukurpa wangkanytja wiya Saulala utiṟa tjakultjunkunytjaku. Paluṟu wantingi alatjiṯu. ");
INSERT INTO pjt_vpl VALUES ("S128_7","010_28_7","1SA","28","7","7","Ka Saulalu wangkangu warmaḻa panya tjuṯaku mayatjangka, “Minyma kutjupa tjinguṟu palakutu nyinanyi miri ilunytja tjuṯangka kurunta wangkapai. Ankulaya nguriṟa ma-nyawa minyma nyara palunya munuṉiya pitjala tjakultjura, kaṉa palulakutu ankula tjapilku alatji, “Nyaaringkuku kuwari?” Ka paluṟu miri panya kurunta tjapiṟa ngayula wangkara utilku.” Ka watingku palula wangkangu, “Tawunu ini Intula nyinanyi minyma pala palu puṟunypa miringka kurunta wangkapai.” ");
INSERT INTO pjt_vpl VALUES ("S128_8","010_28_8","1SA","28","8","8","Kanku Saulalu nyangatja kuliṟa mantara mayatjaku araltjanu munu mantara kutjupangka tjarpangu aṉangu tjuṯangku mayatja nyakula ngurkantankunytjaku-tawara. Munu munga nyara palula Saulanya wati kutjaratjara anu minyma palunya nyakunytjikitja munu wirkaṟa wangkangu minymangka panya, “Ngayulu mukuringanyi nyuntu wati miri kurunpa aḻṯinytjaku. Kuwariṉanta ini nyuntula wangkaku, ka miri nyara palunya aḻṯira wangka. Palya?” ");
INSERT INTO pjt_vpl VALUES ("S128_9","010_28_9","1SA","28","9","9","Ka minymangku panya Saulanya kuliningi wati kutjupa-palku. Munu palula wangkangu, “Nyuntun ninti kinga panya Saulaku? Panya paluṟu aṉangu miringka wangkapai tjuṯa paiṟa iyaṉu ngura Israeltanguṟu. Tjinguṟuṉitjun ngayunya ngunti kuraṉi iluntankunytjikitjangku.” ");
INSERT INTO pjt_vpl VALUES ("S128_10","010_28_10","1SA","28","10","10","Ka Saulalu wangkangu alatji palula, “Wiya! Nganaṉa taṟapula palyantja wiya nyuntu wati miringka kurunta wangkanyangka. Mulamulangkuṉa wangkanyi Mayatja Godala miṟangka.” ");
INSERT INTO pjt_vpl VALUES ("S128_11","010_28_11","1SA","28","11","11","Ka minymangku wangkangu, “Uwa palya. Palu miri kurunpa ngananyan wanyu wangkanyi ngayulu aḻṯira nyuntula kuranyu ngaṟatjunkunytjaku?” Ka Saulalu wangkangu, “Samuelku kuruntaṉa wangkanytjikitja mukuringanyi.” ");
INSERT INTO pjt_vpl VALUES ("S128_12","010_28_12","1SA","28","12","12","Ka minymangku Samuelku kurunpa aḻṯingu ngalya-pakantjaku. Ka mulapaṯu kurunpa panya utiringu, ka paluṟu nyakula puḻkaṟa mirangu munu Saulanya wangkangu, “Nyuntun ngayunya ngunti kuraṉu. Nyuntun Saulanya alatjiṯu! Kuwariṉin ngayunya iluntankuku?” ");
INSERT INTO pjt_vpl VALUES ("S128_13","010_28_13","1SA","28","13","13","Ka Saulalu palula wangkangu, “Wiya, nguḻuringkunytja wiya rapa ngaṟama! Wanyuṉin tjakultjura nyaan nyangu?” Ka minymangku panya wangkangu, “Wati kurunpa ngalya-pakannyangkaṉa nyangu manta unngunguṟu.” ");
INSERT INTO pjt_vpl VALUES ("S128_14","010_28_14","1SA","28","14","14","Ka Saulalu tjapiningi, “Paluṟu wanyu nyaa puṟunypa?” Ka minymangku wangkangu, “Paluṟu wati tjiḻpi kuuta waṟatjara.” Ka Saulalu alatji kuliṟa kulinu, “Munta-uwa, palatja kurunpa Samuelku alatjiṯu.” Munu Saulalu tultjungaṟakatira yunpangku manta pampuṉu. ");
INSERT INTO pjt_vpl VALUES ("S128_15","010_28_15","1SA","28","15","15","Ka Samueltu kuruntu Saulala wangkangu, “Nyaakuṉin kurulnguṟu nyanga aḻṯira pakaltjingaṉi nyuntula kuranyu ngaṟanytjaku?” Ka Saulalu wangkangu, “Pilitjiyanya nguraṟa tjuṯaya nganampa pikaringanyi kaṉa puṯu kulini. Nyaalkuṉa? Panya Godaluṉi alpamilantja wiyangku wantir'iyaṉu. Palulaṉa tjapinu, kaṉitju wangkanytja wiya. Ngaṉmanypa panya paluṟu ngayulu tjapinnyangka utilpai alatjiṯu, palu kuwari nyanga wiya. Paluṟu wati wangkatjara ngayulakutu iyantja wiya palumpa aṟa utiṟa tjakultjunkunytjaku. Munuṉi tjukurmankunytja-wanungku kuḻu ngayula utiṟa tjakultjunkunytja wiya alatjiṯu. Kaṉanta nyuntunya kuwari pakaltjingaṉu ngayunya alpamilantjaku, ‘Nyaalkuṉa? Wiṟungkuṉi tjakultjura!’” ");
INSERT INTO pjt_vpl VALUES ("S128_16","010_28_16","1SA","28","16","16","Ka Samueltu wangkangu palula, “Mayatja Godalunta wantikatingu munu kuwari nyanga paluṟu nyuntumpa mirpaṉtju nyinanyi. Kaṉi nyuntumpa palyantjaku ngayula tjapintja wiyangku wantima. ");
INSERT INTO pjt_vpl VALUES ("S128_17","010_28_17","1SA","28","17","17","Panya Mayatja Godaluṉi ngaṉmanytju wangkangu wanka nyinanyangkalpi, ka panyaṉanta nyuntula tjakultjunu, ka paluṟu palyaṉi alatjiṯu kuwari ngaṉmanytju nyuntula wangkanytjatjanungku. Tjukaṟurungkuṉanta wangkanyi, panya paluṟunta kuwari wiyaṉi alatjiṯu Israelku Mayatja nyinanytjaku. Nyuntun wiyaringanyi, ka nyuntumpa aṟangka paluṟu Davidanya ngurkantaṟa tjunkuku. ");
INSERT INTO pjt_vpl VALUES ("S128_18","010_28_18","1SA","28","18","18","Panyatjan kulini? Panya Mayatja Godanya Ama-likakunu tjuṯaku puḻkaṟa mirpaṉaringi munu panyanta wangkangu tjananya uwankara pungkula wiyantjaku munu tjana kanyintjitja uwankara kuḻu kuraṟa wiyantjaku. Palu nyuntun palula tungunpungu munun kulintja wiyangku wantingu. Kanta pala palulanguṟu Mayatjalu nyanga alatji palyaṉi. ");
INSERT INTO pjt_vpl VALUES ("S128_19","010_28_19","1SA","28","19","19","Munu Pilitjiyanya nguraṟa tjuṯa mungawinki pika pitjanyangka nyuranya alpamilantja wiyaringkuku, kaya nyurampa pikaringkula pungkula nyurala waintariku Israelkunu uwankarangka, ka nyuntu munu nyuntumpa katja tjuṯa kuḻu ilura ngayula tjunguringkuku miriku nyanga ngurangka.” Nyanga alatji Samueltu Saulala kuruntu wangkangu munu wangkara wiyaringkulalta arkayiringu. ");
INSERT INTO pjt_vpl VALUES ("S128_20","010_28_20","1SA","28","20","20","Ka Saulalu tjukurpa nyangatja kuliṟa yunpanguṟu mantangka punkaṉu puḻkaṟa nguḻuringkula. Panya paluṟu uparingu kaḻaḻa mungangka kuḻu mai ngalkuntja wiyaṯu. ");
INSERT INTO pjt_vpl VALUES ("S128_21","010_28_21","1SA","28","21","21","Ka minyma panya palulakutu ngalya-ilaringu munu nguḻuringkunyangka nyakula wangkangu, “Mayatja wiṟu, nyuntu panyaṉin wangkangu Samuelnga kurunpa pakaltjingantjaku. Kaṉanta kulinu wati kutjupangku-palku wangkanyangka, munu panyaṉa mulapaṯu pakaltjingaṉu palu walytjangkuṉatju kulintja wiyaṯu ilunytjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("S128_22","010_28_22","1SA","28","22","22","Ala, kulilaṉi! Munu mai ngalkula kuṉpuriwa maḻaku nguraku ankunytjikitja.” ");
INSERT INTO pjt_vpl VALUES ("S128_23","010_28_23","1SA","28","23","23","Ka Saulalu wangkangu, “Wiya, wantinyiṉa ngalkuntja wiyangku.” Kaya minymangka tjunguringu Saulaku panya wati kuranyitja tjuṯa kuḻu, munuya rawangku palunya wituwituningi ngalkuntjaku. Ka Saulanya mantangka kuwaripaṯu rawa nguwanpa ngaringi upaṯu, munu kuliṟa kuliṟa mantanguṟu pakaṟa ma-maṟaṟa piitangka nyinakatingu. ");
INSERT INTO pjt_vpl VALUES ("S128_24","010_28_24","1SA","28","24","24","Ka minymangku panya puluka kuḻunypa kaṉpi puḻka kanyintjatjanungku mapalku ankula iluntaṟa pauṉu mai tampa kuḻu. ");
INSERT INTO pjt_vpl VALUES ("S128_25","010_28_25","1SA","28","25","25","Munu katira ungu Saulanya tjananya, kaya ngalkula paḻtjaringkula mungangkaṯu anu. ");
INSERT INTO pjt_vpl VALUES ("S129_1","010_29_1","1SA","29","1","2","Kaya tawunu panya kutjara-maṉkurnguṟu Pilitjiyanya nguraṟa tjuṯa warmaḻarira uwankara ngaparku tjunguringu tawunu ini Apikala, kaya Israelkunu tjuṯangku ngura tjunu kapitjarangka itingka wimaṟungka ma-wirkaṟa ngura ini Tjitjaṟilta. Kaya mayatja panya ngura kutjara-maṉkurnguṟu palumpa tjanampa tjaultjingka tjungu maatjaringi kapuṯu kutjupa kapuṯu kutjupa winki mulapa. Kaya Davidanya tjana palumpa tjaultji tjuṯa tjanala tjunguringkula maatjaringi Akitjaku warmaḻa tjuṯangka munuya maḻa nguwanpa pitjalinangi. ");
INSERT INTO pjt_vpl VALUES ("S129_3","010_29_3","1SA","29","3","3","Ka Pilitjiyaku tjaultji tjuṯaku mayatja tjuṯangku Israelkunu tjuṯa tjanala tjungu maatjarinyangka nyakula wangkangu, “Ai! Israelkunu tjuṯaya nyaratja tjunguringu Akitjala tjanala. Nyaakuya nyaranpa?” Ka Akitjalu wangkangu, “Wiya, Davidanya ngaṉmanypa Saulaku tjaultji nyinangi munu mungaṯu nguwanpa Saulanya wantira nganaṉala tjunguringu palumpa tjaultji tjuṯatjara. Munuya kuwari yiya kutju nganaṉala nyinangi wiṟu mulapa kura kutjupa kutjupa palyantja wiya.” ");
INSERT INTO pjt_vpl VALUES ("S129_4","010_29_4","1SA","29","4","4","Palu Pilitjiyaku tjaultji tjuṯaku mayatja tjuṯa Akitjaku puḻkaṟa mirpaṉaringu munuya palula wangkangu, “Wiya, Davidanya tjananya ngurakutu wituṟa iyala tawunu panya nyuntu ungkunytjitjakutu Saulaku piṟuku maḻparingkunytjaku-tawara. Tjinguṟu paluṟu kulintja kampa kutjuparira nganaṉanya iluntankuku, ka kinga panya Saulanya palumpa pukuḻariku piṟuku. Palula-tawara uti paluṟu tjana mauṉṯalpa nyinama nganaṉala tjungu pika nyangangka tjarpanytja wiya. ");
INSERT INTO pjt_vpl VALUES ("S129_5","010_29_5","1SA","29","5","5","Kulinin panyatja? Israelkunu panya minyma tjuṯa? Panya pukuḻpaya nyaṉpingi munuya inma inkara wangkangi, ‘Saulaku warmaḻa tjuṯangku wiyaṉu 1,000 warmaḻa palu Davidaku warmaḻa tjuṯangkuya palula munkara mulapa iluntanu 10,000-pa puḻka mulapa.’ Alatjiya mirawaṉira wangkangi.” ");
INSERT INTO pjt_vpl VALUES ("S129_6","010_29_6","1SA","29","6","6","Ka Akitjalu Davidanya aḻṯingu munu palula mauṉṯalpa wangkangu, “Tjukaṟurungkuṉanta tjakultjunanyi Godala miṟangka, panya nyuntu warmaḻa tjuṯatjara rawa ngayula tjungu nyinangi maḻpa alatjiṯu, kaṉanku mukuringanyi nyura ngayula tjunguringkula Israelkunu tjuṯaku pikaringkunytjaku. Palu nyanga Pilitjiyaku tjaultjiku mayatja tjuṯaya puṯu mulamularinganyi nyurampa. ");
INSERT INTO pjt_vpl VALUES ("S129_7","010_29_7","1SA","29","7","7","Kaya nguraku ara tjana nyurampa mirpaṉarinytjaku-tawara munuya pilunpa ma-nyinama.” ");
INSERT INTO pjt_vpl VALUES ("S129_8","010_29_8","1SA","29","8","8","Palu Davidanya kuliṟa tjituṟu-tjituṟuringu munu Akitjala wangkangu, “Ngayuluṉa kura palyantja wiyaṯu nyuntumpa. Panya kuwaripatjarala pitjala nyurala tiṯutjara tjungu alatjiṯu nyinangi maḻpa mulapa. Kalanyan nganaṉanya nyaaku markuṉi nyurala tjunguringkula pikaringkunytjaku?” ");
INSERT INTO pjt_vpl VALUES ("S129_9","010_29_9","1SA","29","9","9","Ka Akitjalu wangkangu, “Wiya ngayulu nyurampa puḻkaṟa pukuḻarinyi, panya nyuntu ngayuku maḻpa mulapa, angelpa puṟunypa. Palu ngayuku tjaultji tjuṯaku mayatja tjuṯangku nyuranya wangkangi pika nyangangka tjunguringkunytjaku-tawara. ");
INSERT INTO pjt_vpl VALUES ("S129_10","010_29_10","1SA","29","10","10","Pala palulanguṟuya mungawinki mulapa pakaṟa maḻaku ara ngurakutu tawunu panya ngayulu nyuntunya ungkunytjalakutu.” ");
INSERT INTO pjt_vpl VALUES ("S129_11","010_29_11","1SA","29","11","11","Kaya Davidanya tjana mulapaṯu wangaṉarangku kuliṟa pakaṟa parari tjiṉṯuringkunyangka anu ngura panya Pilitjiyanya nguraṟa tjuṯaku mantakutu, kaya Pilitjiyanya nguraṟa tjuṯa kutju warmaḻarira Tjitjaṟiltakutu ma-tatiningi Saulala tjanalakutu pikakitja. ");
INSERT INTO pjt_vpl VALUES ("S130_1","010_30_1","1SA","30","1","3","Kaya Davidanya tjana tjiṉṯu kutjara anangi rawa munu tjiṉṯu maṉkuritja ngurangka ma-wirkanu tawunu panya Tjikalakala, munuya wirkaṟa nyangu tjanampa waḻi uwankara tiliṟa nyaṟuntja munuya puṯu nyangangi kuri tjuṯaku munu katja uṉṯalpa tjuṯaku kuḻu. Panya tjana Akitjala tjungu ankunyangka Ama-likakunu wati warmaḻa tjuṯa tawunu panya palula tjarpangu maḻangka munuya kungkawaṟa, minyma, tjitji tjuṯa kuḻu katingu munuya tjanampa ngura tiliṟa nyaṟuṟa wantikatingu. ");
INSERT INTO pjt_vpl VALUES ("S130_4","010_30_4","1SA","30","4","4","Kaya Davidalu tjana pitjala nyakula puḻkaṟa ulangu munuya ulara ulara uḻiringkula uparingu. ");
INSERT INTO pjt_vpl VALUES ("S130_5","010_30_5","1SA","30","5","5","Warmaḻa nyarantuya Davidaku kuri kutjara katingu, Aki-nuwamanya pulanya Apikailnga. ");
INSERT INTO pjt_vpl VALUES ("S130_6","010_30_6","1SA","30","6","6","Munuya ulara wiyaringkula Davidaku panya tjaultji tjuṯa palumpa mirpaṉaringu katja uṉṯalpa tjuṯanguṟu, munuya ngukaṟa puntuṟa wangkangi atuṟa iluntankunytjikitjangku. Ka Davidanya kuliṟa wangkanyangka puḻkaṟa tjituṟu-tjituṟuringu. Palu paluṟu kulinu Godalu palunya unngu rapannyangka munu palumpa tjaultji tjuṯangka raparingkula wangkangu. ");
INSERT INTO pjt_vpl VALUES ("S130_7","010_30_7","1SA","30","7","8","Munu wati tjukurtjarangka Apiyatjala wangkangu, “Puṯuṉa kulini. Wanyu mantara panya miḻmiḻpa ngalya-kati munu tjarpa, kali Godala tjapilku nganaṉala utintjaku.” Ka mulapaṯu mantara panya ngalya-katira tjarpangu, ka pula Godala tjapinu, “Waṉalkula wati nyara warmaḻa tjuṯa?” Ka Godalu wangkangu Davidala, “Uwa, palya, waṉalaya, panya nyura tjananya waṉaṟa witilku alatjiṯu munuya nyuranku walytja panya tjuṯa maḻakungku wanka mantjilku.” ");
INSERT INTO pjt_vpl VALUES ("S130_9","010_30_9","1SA","30","9","10","Kaya Davidanya tjana wati nampa 600 ma-pakaṉu munuya ankula karu ini Pitjurta wirkanu, palu tjara kutjupaya nyara palula pakuringkula nyinakatingu wati 200, kaya Davidanya tjana kutju karungka ma-itipirira anu wati 400 kutju. ");
INSERT INTO pjt_vpl VALUES ("S130_11","010_30_11","1SA","30","11","12","Munuya ma-wirkaṟa uṟilta ma-pitjangi munuya wati kutju Itjipanya nguraṟa nyangu. Wati nyanga paluṟu tjiṉṯu maṉkurpa mai wiya, mina wiya nyinangi. Kaya wati palunya nyakula Davidalakutu katingu, munuya mina, mai iḻi, raitjinpa, kiṟipitji piḻṯi kuḻu ungu, ka wati panya paluṟu ngalkula paḻtjaringkula palyaringu. ");
INSERT INTO pjt_vpl VALUES ("S130_13","010_30_13","1SA","30","13","13","Ka Davidalu palula tjapinu, “Ngura yaaltjinguṟun? Ngananyanku mayatja?” Ka wati paluṟu Davidala wangkangu, “Ngayuluṉa wati Itjipanya nguraṟa, ka ngayuku mayatja wati Malakaikunu. Mungaṯuṉi paluṟu pikatjara wantikatingu tjiṉṯu maṉkurpa. ");
INSERT INTO pjt_vpl VALUES ("S130_14","010_30_14","1SA","30","14","14","Panya paluṟu nganaṉa warmaḻarira anu tawunu uḻpaṟira ngaṟanytja tjuṯakutu Kiritjikunu tjuṯaku panya ngurakutu munula tjarpara pungkula uwankara tjanampa tjulyaṟa katingu. Munula piṟuku Judah-nya nguraṟa tjuṯaku mantakutu ngapartji anu munula Calebakunu tjuṯaku ngura tjuṯangka tjarpara palu puṟunypaṯu katingu. Munula palulanguṟu tawunu ini Tjikalakanya tiliṟa nyaṟuṉu.” ");
INSERT INTO pjt_vpl VALUES ("S130_15","010_30_15","1SA","30","15","15","Ka Davidalu wangkangu wati panya palula, “Yaaltjingkaya wati panya warmaḻa tjuṯa kumpiṟa nyinanyi? Katiṉi palula tjanalakutu. Panya paluṟu tjanaya kuraṉu tawunu Tjikalakanya.” Ka wati Itjipanya nguraṟangku wangkangu, “Uwa ngayulu nyuntunya katiku wati palula tjanalakutu, palu ngayunyaṉi kalkula Godala miṟangka iluntankunytja wiyakitjangku munuṉi wati nyara tjananya ungkunytja wiyangku wantima.” Ka Davidalu mulapaṯu kalkuṉu pungkunytja wiyangku wantinytjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("S130_16","010_30_16","1SA","30","16","16","Ka wati paluṟu Davidanya Malakaikunu warmaḻa tjuṯaku ngurakutu katingu. Ka pula ngalya-ilaringkula nyakukatingi tjana mai puḻka para-nyinara arintaṟa ngalkunnyangka. Panya paluṟu tjana kutjupa kutjupa uwankara tjanampa nguranguṟu tjulyaṟa katinytjatjanungku pukuḻarira mai ngalkuningi munuya waina kuḻu tjikiningi. Palu paluṟu pula paṯunguṟu kumpiṟa ngaṟala nyangangi munu pula nyakula maḻaku anu ngurakutu. ");
INSERT INTO pjt_vpl VALUES ("S130_17","010_30_17","1SA","30","17","17","Ka mungawinki ngalya-tjiṉṯuringkunyangka Davidanya warmaḻa tjuṯatjara anu ngura nyara palulakutu, wati panya Itjipanya nguraṟangku nintintjitjangka. Munuya wirkara Malakaikunu tjuṯa pungangi kaḻaḻa waṟa. Pungkulaya mungartjiringu munuya tjuṯa mulapa iluntanangi. Palu wati yangupala Malakaikunu tjuṯaya kamulangka nguḻu tatiṟa wirtjapakaṉu, nampa nyangatja 400. ");
INSERT INTO pjt_vpl VALUES ("S130_18","010_30_18","1SA","30","18","19","Ka pika pungkula wiyaringkunyangka Davidanya tjana maḻangka tjarpangu Ama-likakunu tjuṯaku ngurangka, munuya nyangu wanka nyinanyangka tjanampa kuripiti munu katja uṉṯalpa tjuṯa kuḻu, munu kutjupa kutjupa uwankara Malakaikunu tjuṯangku kutitjuṟa katinytja tjanampa tawunu panya Tjika-lakalanguṟu. Munuya uwankara mantjiṟa maḻakungku katingu, kuka tjuṯa kuḻu. ");
INSERT INTO pjt_vpl VALUES ("S130_20","010_30_20","1SA","30","20","20","Panya tjana tjiipi puluka tjuṯa walytjatjara tjulyaṟa katingu Malakaikunu tjuṯangku. Ka Davidaku tjaultji tjuṯangku kuka uwankara utuluṟa katingi ngurakutu wangkara, “Tjiipi puluka nyanganpa uwankara Davidakuringu.” ");
INSERT INTO pjt_vpl VALUES ("S130_21","010_30_21","1SA","30","21","21","Munuya ngurakutu maḻaku ankula nguṟurpa wirkanu karu Pitjurta, panya nyara palulaya wati tjara nampa 200 paṯaṟa nyinangi pakuringkula. Munuya Davidanya tjananya pitjanyangka nyakula ngaparikatingu munuya uwankara puḻkaṟa pukuḻaringu. ");
INSERT INTO pjt_vpl VALUES ("S130_22","010_30_22","1SA","30","22","22","Palu wati kutjupatjara Malakaikunu tjuṯangka pikaringkunytjatjanu kura nyinangi, munuya Davidala alatji wangkangu, “Wati nyanganpa panyaya nganaṉala tjungu pikakitja ankunytja wiyaṯu. Palu palya tjana kuri munu tjitji tjuṯa kutju mantjiṟa anama, kala nganaṉa tjiipi, puluka, ulytja, kutjupa kutjupa tjuṯa Malakaikunu tjuṯangku tjulyaṟa katinytja tjaraṟa mantjilku.” ");
INSERT INTO pjt_vpl VALUES ("S130_23","010_30_23","1SA","30","23","23","Ka Davidalu tjanala wangkangu wati panya kurakura tjuṯangka, “Walytja tjuṯa! Mayatja Godalulanya nyanganpa ungu uwankara, kala manyuringkunytja wiyangku tjarala. Mayatjalu nganaṉanya wiṟungku ngalkinu kala Malakaikunu tjuṯa pungkula wiyaṉu, panya nyara tjana nganampa ngura Tjikalakanya kuraṟa pungu. ");
INSERT INTO pjt_vpl VALUES ("S130_24","010_30_24","1SA","30","24","24","Ka nyura manyuringkunyangka kutjupa tjuṯa pukuḻarinytja wiya. Kulilaya! Nganaṉa anu pika pungkunytjikitja, kaya tjara kutjupangku nyinara ngura ulytja kutjupa kutjupa tjuṯa aṯunymanangi. Kala uti uwankarangkuṯu tjaraṟa mantjinma.” ");
INSERT INTO pjt_vpl VALUES ("S130_25","010_30_25","1SA","30","25","25","Uwa, tjukurpa nyanga palunya Davidalu wangkangu aṉangu Israelkunu uwankarangku kulintjaku, ka kuwari nyanga ngaṟangi alatjiṯu. ");
INSERT INTO pjt_vpl VALUES ("S130_26","010_30_26","1SA","30","26","26","Kaya Davidanya tjana uwankara tjunguringkula ankula ngurangka wirkanu tawunu panya Tjikalakala munu palulanguṟu kuliningi Malakaikunu tjuṯaku kuka tjuṯa ngura tjuṯakutu iyantjikitjangku tjaṟukutungku manta Judah-lakutu. Munu paluṟu palumpa maḻpa tjuṯangka wangkangu tawunuku panya mayatja kuranyitja tjuṯangka, “Nganaṉa Godaku mirpaṉtju tjuṯa pungkula waintaringu Malakaikunu tjuṯa, munula tjanampa tjiipi puluka tjuṯa katingu, kaṉa kuwari kuka palunya tjananya ma-iyaṉi nyurampa nyuranku kanyintjaku.” ");
INSERT INTO pjt_vpl VALUES ("S130_27","010_30_27","1SA","30","27","31","Munu Davidalu wati tjuṯangka wangkangu tjiipi puluka panya tjuṯa katira aṉangu tjuṯa ungkunytjaku, tawunu nyanga palula tjanalakutu: Pitjiltakutu Ramatja-nikipilakutu Tjatirtakutu Arawalakutu Tjipamatjalakutu Itjimawalakutu Rakaltakutu Uumalakutu Puwatjantakutu Atjakalakutu Ipuṟantakutu Munu piṟuku kutjupatjara iyaṉu aṉangu nyanganku Tjiṟamilkunu tjuṯaku munu Kiinkunu tjuṯaku. Uwa, paluṟu kuka tjuṯa iyaṉu ngura panya palula tjanala para-nyinanytjatjanungku. ");
INSERT INTO pjt_vpl VALUES ("S131_1","010_31_1","1SA","31","1","2","Ka panyaya Pilitjiyanya nguraṟa tjuṯa warmaḻarira anu ngura panya Kilpawalakutu munuya wirkaṟa puḻi paṉṯa waṟaṟa Israelkunu tjuṯa pungangi tjuṯa mulapa. Ka tjara kutjupa nguḻu wirtjapakaṉu Saulanya munu katja maṉkurpa kuḻu ini nyanganpa Jonathannga, Pinatapanya munu Maltji-tjuwanya. Ka tjananya nguḻuṟa ma-waṯaparaṟa katja panya maṉkurpa iluntanu. ");
INSERT INTO pjt_vpl VALUES ("S131_3","010_31_3","1SA","31","3","4","Ka Saulalu tjuṯa pungangi, palu paluṟu puṯu winaringangi, ka Pilitjiyanya nguraṟangku punaṟangka palunya wakaṉu, ka paluṟu punkaṟa ngaringi, munu tjaultji palumpa kuṯitji katipaingka wangkangu, “Kuwariṉiya wati nyara kuliṟa wantipai tjuṯangku pitjala ngayunya anaṟa kuraṟa pungkula iluntananyi. Kaṉi wanyu warpungkula nyuntumpa pala tjulangka wakaṟa iluntara.” Palu tjaultji paluṟu puḻkaṟa nguḻuringangi palumpa panya mayatja iluntankunytjikitja. Palu Saulalunku walytjangku tjula palumpa milpinypa maṟangku witiṟa kanyintjatjanungku palulaṯu punkaṉu mununku walytjangku wakaṟa iluntanu. ");
INSERT INTO pjt_vpl VALUES ("S131_5","010_31_5","1SA","31","5","5","Ka tjaultji panya paluṟu nyangu mununku palu puṟunypaṯu palyaṉu munu tjuḻakutu panya punkaṉu munu ilungu. ");
INSERT INTO pjt_vpl VALUES ("S131_6","010_31_6","1SA","31","6","6","Uwa, Saulanya munu palumpa katja maṉkurpa tjaultji palumpa kuṯitji katipainya munu tjaultji kutjupa tjuṯa kuḻu tjungu uwankaraṯu ilungu tjiṉṯu nyara palulaṯu. ");
INSERT INTO pjt_vpl VALUES ("S131_7","010_31_7","1SA","31","7","7","(Kaya Israelkunu kutjupa tjuṯa nyinangi ngura nyara palula itingka ngura ini Tjitjaṟilta kampa kutjupa, munuya karu Jordanta itipi kuḻu. Munuya tjukurpa kulinu Saulanya munu katja maṉkurpa iluntankunytja, munu Saulaku tjaultji tjuṯa nguḻu wirtjapakantja. Nyanga palunya kuliṟaya tawunu tjananku wantikatira nguḻuṯu wirtjapakaṉu. Kaya tjaultji panya Pilitjiyanya nguraṟa tjuṯangku maḻa pitjala nyangu waḻi ultu, munuya tjarpara walytjaringkula nyinangi.) ");
INSERT INTO pjt_vpl VALUES ("S131_8","010_31_8","1SA","31","8","8","Munuya mungawinki maḻaku anu aṟakutu panya tjana pungkunytjalakutu munuya tjula, kuḻaṯa, kutjupa kutjupa tjuṯa kuḻu mantjiningi aṉangu miri tjuṯanguṟu. Munuya uwankara para-mantjiṟa Saulanya kuḻu miri ngarinyangka nyangu munu katja maṉkurpa kuḻu. ");
INSERT INTO pjt_vpl VALUES ("S131_9","010_31_9","1SA","31","9","10","Munuya Saulanya kata kaṯaṟa palumpa mantara anga-kanyilpainya mantjiṟa katira timpulangka tjunu, panya tjana waḻkulpaingka. Panya tjanampa goda minyma ini Atjatainya. Munuya Saulanya puntu wallpangka wakaṟa utitjunu, palumpa katja maṉkurpa kuḻu, city wall-ta ngura ini Pitjatjanta. Munuya palulanguṟulta tjaultji panya tjuṯangku aṉangu kutjupa tjuṯa tjakulpa wituṟa iyaṉu, kaya tawunu tjuṯangka wirkaṟa para-tjakultjunangi Pilitjiyala manta winkingka timpulangka kuḻu aṉangu uwankarangka. Alatjiya tjakultjunangi, “Mayatja panya Saulanya katja maṉkurtjara ilungu munu tjaultji tjuṯa kuḻu ilungu.” ");
INSERT INTO pjt_vpl VALUES ("S131_11","010_31_11","1SA","31","11","11","Kaya Israelkunu tjuṯa ngura ini Tjaipitjala nyinanytja tjuṯangku kulinu panya Pilitjiyanya nguraṟa tjuṯangkuya kunyu Saulanya wakaṟa wallpangka utitjunu katja maṉkurpa kuḻu tawunu ini Pitjatjanta. ");
INSERT INTO pjt_vpl VALUES ("S131_12","010_31_12","1SA","31","12","12","Kaya ngura nyara Tjaipitjala wati kutjupatjara kuṉpu nyinangi munuya tjunguringkula mungangka anu tawunu panya Pitjatjantakutu munuya miri Saulanya nyakula mantjiṟa katingu katja maṉkurpa kuḻu tjanampa tawunukutu. Munuya waṟungka tilinu puntu palunya tjananya. ");
INSERT INTO pjt_vpl VALUES ("S131_13","010_31_13","1SA","31","13","13","Munuya waṟunguṟu tarka tjuṯa kutju mantjiṟa tjuṉutjunu katja panya maṉkurpa kuḻu puṉu ini Tamaṟikala itingka ngura ini Tjaipitjala manta ini Kiliyatala. Munuya palulanguṟu tjiṉṯu 7-pa nyinangi tjituṟu-tjituṟu puḻka mai wantira. ");
INSERT INTO pjt_vpl VALUES ("NH1_1","017_1_1","NEH","1","1","2","Uwa, ngayulu wati ini Niyamayanya munuṉa kuwari nyiri nyangangka tjakultjunanyi ngayulu palyantjatjanungku. Panya ngayulu ngaṉmanypa nyinangi ngura kutjupangka tawunu ini Tjuutjala, ka nyara palula-aṟangka wati ini Tjuukitjinya mayatja puḻka nyinangi ngura winkiku Israelku kuḻu, panya paluṟu ngura tjuṯa mulapa tjunguṟa mayatjangku kanyiningi ini Puutjanya. Ka ngayulu mayatja panya palumpa waṟkaripai nyinangi. Ka kutjupa-aṟa ngayulu ngura nyara Tjuutjala nyinanyangka ngayuku kuṯa Jerusalemalanguṟu maḻpa tjuṯatjara pitjangu. Kaṉa palunya nyakula puḻkaṟa pukuḻaringu munuṉa tjanala tjapinu, “Ngurangkampaya uwankara palya nyinanyi? Ka waḻi panya Jerusalemanya palya ngaṟanyi?” ");
INSERT INTO pjt_vpl VALUES ("NH1_3","017_1_3","NEH","1","3","3","Kaya wangkangu, “Wiya, nganampa walytja tjuṯaya tjituṟu-tjituṟu puḻka nyinanyi panya tjanampa tuṟapula puḻka rawa ngaṟanyi. Kaya nganaṉanya ngura ititja tjuṯanguṟu kuraṟa pungkupai. Ka wall-pa panya puḻka Jerusalemala kaṯalypaṯu ngaṟanyi munu kaita tjuṯa kuḻu waṟungku kampanytja ngaṟanyi, ka uwankara palyantja wiyaṯu kuwaripaṯu ngaṟanyi.” ");
INSERT INTO pjt_vpl VALUES ("NH1_4","017_1_4","NEH","1","4","4","Ka ngayulu nyangatja kuliṟa puḻkaṟa ulangi tjituṟu-tjituṟurira. Munuṉa tjiṉṯu tjuṯa mai ngalkuwiya nyinara Godala rawangku tjapiningi aṉangu Jew tjuṯaku. Alatjiṉa tjapiningi, ");
INSERT INTO pjt_vpl VALUES ("NH1_5","017_1_5","NEH","1","5","11","“Mayatja God ilkaṟitja! Nyuntu panyan mayatja puḻka mulapa nyinanyi, kaya aṉangu uwankara nyuntumpa puḻkaṟa nguḻuringkupai. Ka panya aṉangu tjuṯangku nyuntumpa puḻkaṟa mukuringkula nyuntumpa tjukurpa wangaṉarangku kulinnyangka nyuntu tjanampa ngaṉmanytju kalkuntjatjanungku palyalpai alatjiṯu wantinytja wiyangku. Katju kuwari ngaḻṯuringama, munuṉi nyuntula tjapinnyangka kulinma. Panya nganaṉa Jew uwankarangku nyuntula puḻkaṟa tungunpungkula tjukurpa panya nyuntu Mosenya ungkunytjitja kuliṟa wantingu. Ka panyan Mosenya wangkara kalkuṉu alatji, ‘Aṉangu nyanga ngayuku walytja tjuṯa ngayula rawa tungunpungkunyangkaṉa tjananya ngura walytjanguṟu paiṟa iyalku, kaya ankula wiyaringkuku ngura malikitja tjuṯakutu.’ Palu panya nyuntun kutjupa kuḻu kalkuṉu alatji, ‘Palu tjana tjinguṟu ngura pararinguṟu piiwiyaringkula ngayunya piṟuku kuliṟa wangaṉararingkunyangkaṉa tjananya maḻakungku katiku ngura walytjakutu ngayunya piṟuku waḻkuntjaku.’ Alatji panyan Mosenya wangkara kalkuṉu. Kala kuwari nyanga nyuntula puḻkaṟa tjapini nganaṉanya ngura walytjakutu maḻakungku katinytjaku. Ka wanyu ngayulu mayatja nyara Tjuukitjila kuwari waṟkarinyangkampa palunya kulintja kampa kutjupanama wangaṉararingkula ngayula kulintjaku.” Alatjiṉa Godala tjapiningi. ");
INSERT INTO pjt_vpl VALUES ("NH2_1","017_2_1","NEH","2","1","1","Munuṉa palula maḻangka tjiṉṯu kutjupa mayatja panya Tjuukitjiku waina katingu paluṟu tjikintjaku, munuṉa palunya ungkula palula itingka nyinakatingu yunpa tjituṟu-tjituṟu alatjiṯu. ");
INSERT INTO pjt_vpl VALUES ("NH2_2","017_2_2","NEH","2","2","6","Ka mayatjangku ngayunya nyakula tjapinu, “Nyaanguṟun yunpa nyanga alatji tjituṟu-tjituṟu nyinanyi?” Kaṉa wangkangu, “Wiya, nyara ngayuku tjamuku nguranguṟuṉa puḻkaṟa tjituṟu-tjituṟuringu, panya warmaḻa tjuṯangku iriti ankula ngura nyara palunya waḻi uwankara kaṯantaṟa kuraṉu, wall-pa puḻka kuḻu piḻuntanu. Ka kunyu palyantja wiya piḻulypaṯu ngaṟanyi.” Ka mayatja panya paluṟu wangkangu, “Kan ngayulu nyaantjaku mukuringanyi?” Kaṉa palula wangkangu, “Nyuntu ngayuku mukuringkulampaṉi palyanmara, kaṉa ankula palyala ngura nyara palunya.” Kaṉi mayatjangku kuliṟa pukuḻaringu munuṉi palyanmanu ankunytjaku. ");
INSERT INTO pjt_vpl VALUES ("NH2_7","017_2_7","NEH","2","7","8","Palu ngayulu piṟuku palula wangkangu alatji, “Wanyuṉi lita tjuṯa nyiringka walkatjuṟa uwa ngayulu mayatja kutjupa tjuṯa nguṟurpa nyakula ungkunytjaku. Kaya mantjiṟa nyuntu walkatjunkunytja panya nyakula ngayunya aṯunymankuku iwarangka tjanampa ngurawanu ankunytjaku. Munuṉi wanyu lita kutjupa kuḻu walkatjuṟa uwa wati panya nyuntumpa puṉu tjuṯa kanyilpainya ungkunytjaku. Munu alatji palula tjakultjura litangka ngayunya puṉu panya puḻka tjuṯa ungkunytjaku, kaṉa ngayuku tjungutja tjuṯa wangkaku mantjiṟa katinytjaku ngayuku tjamuku ngurakutu kaita panya tjuṯa waṟungku kampanytja uwankara piṟuku palyantjikitjangku.” Kaṉi mayatjangku mulapaṯu nyiringka walkatjuṟa ungu katinytjaku. Munu wati tjuṯa kuḻu wituṉu nyanytju winkitjara ngayula tjungu ankunytjaku Jerusalemalakutu. Kala mulapaṯu anu. ");
INSERT INTO pjt_vpl VALUES ("NH2_9","017_2_9","NEH","2","9","10","Palu Jerusalemala itingka wati kutjara nyinangi Tjanpalatanya pula Tapayanya. Paluṟu pula aṉangu Jew wiya nyinangi tjanala tjungutja wiya munu pula tjunguringkula wangkangi. Ka Tjanpalatalu wangkangi, “Wati, nyuntu kulinu?” Ka paluṟu ngapartji wangkangu, “Nyaa? Walangkuṉi wanyu wangka.” Ka Tjanpalatalu wangkangu, “Wiya, wati kutjupa kunyu pitjanyi nguṟurpa aṉangu nyanga Jew tjuṯa alpamilantjikitja.” Palu Tapayalu nyangatja kuliṟa mirpaṉarira wangkangi, “Nyaaku paluṟu pitjanyi nyanga nganampa ngurakutumpa?” Munu paluṟu pula ngayulu pitjanytja kuliṟa puḻkaṟa mirpaṉaringi. ");
INSERT INTO pjt_vpl VALUES ("NH2_11","017_2_11","NEH","2","11","16","Kala ngula wirkanu Jerusalemala panya mayatjangku iyantja tjuṯatjara. Munula kuwaripa nyinara pakuwiyaringangi tjiṉṯu maṉkurpa. Kaṉa palulanguṟu munga kultungka pakaṟa anu wati maḻpa maṉkurtjara, munuṉa para-ngaṟala wall-pa kaṯalypa nyangangi kaita kampanytja tjuṯa kuḻu. ");
INSERT INTO pjt_vpl VALUES ("NH2_17","017_2_17","NEH","2","17","18","Munuṉa palulanguṟu mungawinki wati tjukurtjara tjuṯa munu mayatja tjuṯa kuḻu aḻṯira wangkangu tjanala, “Kulilaya! Ngura nyanga Jerusalemanya piḻukatingu alatjiṯu wall-pa winki, ngaḻṯutjara. Panya kaita tjuṯa kampara wiyaringu, ka waḻi uwankara kuḻu minya-minyantja alatjiṯu ngaṟala waṉinyi. Wanyula kuwari uriṟa wall-pa nyanga piḻuntankunytja munu kaita waṟungku kampanytjitja palyala maḻakungku. Panya Godanya nganampa ngaḻṯuringu mukulya puḻkanya, kaṉi palulanguṟu ngura panya Puutjaku mayatjangku wangkara iyaṉu nyuranya pitjala alpamilantjaku.” Kaya mayatja tjuṯangku ngayulu wangkanyangka kuliṟa palyanmanu munuya wangkangu, “Uwa, walangkula wanyu palyala kuwariṯu.” ");
INSERT INTO pjt_vpl VALUES ("NH2_19","017_2_19","NEH","2","19","20","Kaya wati maṉkurtu Tjanpalatalu, Tapayalu, Kitjimalu tjana kutjupangku tjakultjunkunyangka tjukurpa nyangatja kuliṟa puḻkaṟa ikaringangi munuya nganaṉanya pitjala kuraṟa pungangi alatji wangkara, “Nyaaku nyura nyanga alatji palyaṉi? Nyura tjinguṟu Puutjaku mayatjangka tungunpungkulampa palyaṉi paluṟu ngula pitjala pikangku pungkunytjaku-tawarampa.” Kaṉa tjanala wangkangu, “Wiya, nganaṉa mayatja kurantja wiya. Godalulanya nyangatja alpamilaṉi wall-pa nyangatja palyantjaku. Kala palula kulini munula kuwari palyalkatira alatjiṯu wiyalku. Palu nyura ngura nyangatja nguraṟa wiya, aṉangu malikitja tjuṯa nyinanyi. Ngura nyangatja nganampa nyurampa wiya.” ");
INSERT INTO pjt_vpl VALUES ("NH3_1","017_3_1","NEH","3","1","1","Munula palulanguṟu wall-pa panya palunya palyalkatingi. ");
INSERT INTO pjt_vpl VALUES ("NH4_1","017_4_1","NEH","4","1","3","Palu wati panya Tjanpalatanya mirpaṉaringu munu wangkangu, “Wiya, nyanganpa aṉangu Jew tjuṯa, ngurpa tjuṯa. Nyaaringanyiya nyanganpa? Tjana wall-pa palatja puṯu maḻakungku palyaṟa wiyaṉi.” Ka Tapayalu kuḻu ikaringkula alatji wangkangi, “Uwa, kuwari-puṯa tuuka tjuṯangku pitjala tjana pala palyantjitjangka tatiṟa waṟarakatiku, ka-puṯa uwankara piḻukatira wiyariwa.” ");
INSERT INTO pjt_vpl VALUES ("NH4_4","017_4_4","NEH","4","4","9","Palu nyangatja kuliṟa ngayulu Godala tjapiṟa wangkangu, “Mayatja, nganaṉanya wiṟungku kulinma. Panya tjana nganaṉanya anaṟa wangkanyi munu tjana ikaringanyi nganampa. Wanyu tjananya ngapartji kuraṟaṯu pungama.” Alatjiṉa tjapiningi. Kaya Jew tjuṯa wall-pangka pukuḻpa alatjiṯu waṟkaringi, puḻkaṟa mulapa. Kaya palyalkatira wall-pa panya waṟaṉu nguwanpa, ka wati panya Tjanpalatalu pula Tapayalu nyakula piṟuku puḻkaṟa mirpaṉaringu munu pula wangkangu alatji, “Arali wati tjuṯatjara munula wangkara tjananya uuḻinama, kaya kaar-kaararira pika-pikariwa, kala tjananya uwankaraṯu puwa.” Palu ngayulu tjananya kuliṟa wantingu, munu Godala rawangku tjapiningi, munuṉa wati tjuṯa kuḻaṯatjara wall-pangka itingka ngaṟatjunu anga-ngaṟala nyakunytjaku mungangka kaḻaḻa kuḻu. ");
INSERT INTO pjt_vpl VALUES ("NH4_10","017_4_10","NEH","4","10","10","Kaya Jew kutjupa tjuṯangku pitjala ngayula wangkangu, “Kulila, nyangatja puḻi minya-minya winki mulapa mantangka ngarira waṉinyi, kala waṟka puḻka palyalkatira nganaṉa paku puḻkaringu munula wawanyarira puṯu kulini. Yaaltjingaṟa wall-pa palyaṟa wiyalku.” ");
INSERT INTO pjt_vpl VALUES ("NH4_11","017_4_11","NEH","4","11","11","Kaya nganampa mirpaṉtju tjuṯangku kunyu wangkangu, “Kuwarila Jew tjuṯa watarku waṟkarinyangka ma-panykaṟa ilaringkuku munula urulyku tjananya pungkula wiyanma waṟka tjana palyaṟa wiyantjaku-tawara.” ");
INSERT INTO pjt_vpl VALUES ("NH4_12","017_4_12","NEH","4","12","12","Kaya palula tjanala itingka Jew kutjupa tjuṯa nyinangi, munuya tjana wangkanyangka kuliṟa pitjala ngayula tjakultjunangi tjuṯa-aṟangku. ");
INSERT INTO pjt_vpl VALUES ("NH4_13","017_4_13","NEH","4","13","14","Ka palulanguṟu ngayulu wati kuḻaṯatjara tjuṯa munu tjuḻa waṟatjara tjuṯa kuḻu wall-pangka itingka para-ngaṟatjuṟa waṉaṉu tjana ngaṟala nyakula palunya tjananya waṟkarinyangka aṯunymankunytjaku. Munuṉa Jew tjuṯangka wangkangu alatji, “Nguḻuringkuwiyaya ngaṟama. Munuya kulinma panya Mayatja Godanya kutju puḻka mulapa nyinanyi, munulanya paluṟu kutjungku aṯunymananyi nganaṉanya uwankara. Ka nyuranku walytja tjuṯa kuḻu aṯunytju kanyinma Mayatjanya kuliṟa.” ");
INSERT INTO pjt_vpl VALUES ("NH4_15","017_4_15","NEH","4","15","23","Ka nyara palulanguṟu wati kutjupatjara waṟkarinyangka kutjupa tjuṯa kuḻaṯatjara punaṟatjara tjanala itingka anga-ngaṟangi warmaḻa tjuṯa pitjanyangka paṯaṟa tjananya wakantjikitja. Ka tjiṉṯu kutjupa ngayulu wati tjuṯangka wangkangu alatji, “Kulilaya! Nyangatjala waṟka puḻka mulapa palyaṉi munula paṯupaṯu wall-pangka kumpiṟa nguwanpa palyaṉi munulanku puṯu nyanganyi panya tjarangku tjarangkula palyaṟa. Tjinguṟu warmaḻa pitjanyangkampa wati kutjupangku ngayula itinguṟu ngaṟala tuṟampata puuṟa miratjingalku nyura kumpiṟa ngaṟanytja tjuṯangku kulintjaku. Kaya kuliṟa mapalku tjunguriwa manta nyara ngali ngaṟala miratjingantjala. Ka Godalu nganaṉanya alpamilalku warmaḻa tjuṯa tjananya pungkula wiyantjaku.” ");
INSERT INTO pjt_vpl VALUES ("NH5_1","017_5_1","NEH","5","1","5","Ka ngulalta aṉangu panya wall-pa palyalpai tjuṯangku wangkara kuliningi alatji, “Tjinguṟu nganaṉa nyangangka nyinarampa mai wiya nyinaku, panya nganaṉa wall-pa nyangatja palyantjikitjangku nganampa kaana tjuṯa wantikatingu, munu panyala mai ukiṟi tjuṯa pakaltjingantja wiya pitjangu. Palulanguṟula kuwari walytja tjuṯangka maniku ngatjilpai mai payamilaṟa ngalkuntjikitjangku, munula walytja kutjupa tjuṯangka mani kutjupaku ngatjilpai Puutjaku panya mayatja ungkunytjikitjangku panya palumpa waṟka tjuṯangku nganaṉala tax mani palumpa mantjilpai. Ka panya kutjupa tjuṯangkula nganampa katja uṉṯalpa tjuṯa aṉangu kutjupa tjuṯangka manikitjangku tjalamilaṉu kaya tjanampa unytju waṟkarinyi. Ka nyara palula tjanalanguṟu nganaṉa puḻkaṟa tjituṟu-tjituṟurinyi. Utilanku panyatja ngapartji-ngapartjingku alpamilanma. Palu wiya, kutjupa tjuṯaya mukuringanyi nganaṉa tiṯutjarangku tjananya kutju mani maḻakungku ungkunytjaku.” Nyanga alatjiya wangkara kuliningi. ");
INSERT INTO pjt_vpl VALUES ("NH5_6","017_5_6","NEH","5","6","8","Palu ngayulu tjukurpa nyangatja kuliṟa puḻkaṟa mirpaṉaringu munuṉa mayatja tjuṯa aḻṯira tjanala wangkangu alatji, “Nyura panya kutjupa tjuṯangka mani unytjungku unganyi maḻakungku payamilalkatinytjaku. Palu nyaaku nyura munkararinyi puḻka mulapa maḻakungku ungkunytjaku? Panya tjana puṯu ungkula katja uṉṯalpa aṉangu walytja kutjupa tjuṯangka tjalamilaṉi tjana manitjararingkula nyuranya maḻakungku payamilantjikitjangku. Nyangatja nyura ngunti palyantja.” Kaya wati panya mayatja tjuṯangku pilunpangku nyinara kuliningi ngunti tjana palyantjatjanungku. ");
INSERT INTO pjt_vpl VALUES ("NH5_9","017_5_9","NEH","5","9","11","Kaṉa wangkangu, “Nyanganguṟuya ngunti palyantja wiyangku wantima! Munu kutjupangku nyuranya puṯu maḻakungku payamilannyangkampa mapalkungku ungkunytjaku pauntjingaṟa wangkawiyangku wantima! Munu kulila tjanampa kaana panya, panya nyuranya puṯu maḻakungku payamilannyangka nyura tjanampa kaana tjuṯa mantjinu. Warpungkulaya tjananya maḻakungku uwa! Nyaaku nyura walytja tjuṯa tjituṟu-tjituṟu tiṯutjarangku palyaṉi? Utila uwankara tjungu pukuḻpa waṟkarima.” Alatji ngayulu mayatja tjuṯangka wangkangu. ");
INSERT INTO pjt_vpl VALUES ("NH5_12","017_5_12","NEH","5","12","12","Kaya kuliṟa palyanmanu munuya wangkangu, “Palya, nyuntu pala wangkanytjala nganaṉa kulinu munula kuwari tjukaṟurungku palyaṉi.” Kaṉa palulanguṟu wati tjukurtjara tjuṯa aḻṯingu palula tjanala tjunguringkunytjaku. Kaya pitjanyangka mayatja panya tjuṯangku tjukurtjara tjuṯangka miṟangka kalkuṉu ngayulu panya wangkanytjanya tjungungku palyantjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("NH5_13","017_5_13","NEH","5","13","13","Kaṉa palula tjanala wangkangu, “Nyura kalkuntjatjanungku palyanma alatjiṯu, panya nyura kalkuntja nyangatja tjukaṟurungku palyalwiyangku wantinyangka Godalu uwankara nyuralanguṟu mantjilku nyura kanyintja uwankara, ka nyura maṟalpa alatjiṯu nyinaku.” Kaya aṉangu uwankarangku kuliṟa palyanmanu, “Uwa mulapa.” ");
INSERT INTO pjt_vpl VALUES ("NH6_1","017_6_1","NEH","6","1","2","Munuya puḻkaṟa waṟkarira wall-pa panya wiyaṉu. Palu kaita tjuṯa kutjulta ngaṟangi piṟuku palyantjaku. Kaya wati panya Tjanpalatalu Tapayalu Kitjimalu tjana wangka iyaṉu ngayulakutu alatji wangkara, “Nganaṉalakutu pitja, kala nyinara wangkara kulila.” Alatjiya ngunti wangkara aḻṯingi ngayunya iluntankunytjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("NH6_3","017_6_3","NEH","6","3","7","Palu ngayulu kulinu munuṉa maḻakungku wangka tjanalakutu iyaṉu, “Wiya, nyangatjaṉa waṟka puḻka palyaṉi munuṉa puṯu ma-pitjanyi waṟka wantikatira.” Kaya piṟuku kutjara kutjara-aṟangku ngayunya puṯu aḻṯingu wangkanytjikitjangku. Munu palulanguṟu puṯu aḻṯira Tjanpalatalu lita nyiringka walkatjunu ngayulakutu iyantjikitjangku. Alatji paluṟu nyiringka walkatjunu, Wati panya Kitjimalu kunyu kulinu nyuntu mayatja puḻkaringkunytjikitjangku wangkanytja munu kunyu nyura nganaṉanya pungkula wiyantjikitjangku kuḻu kulinu. Palu lita palunya iyantjikitjangku paluṟu mulamulangku tjakatjuṟa patintja wiyangku aḻa wantingu kutjupangku mukuringkula aḻaṟa nyakunytjaku. ");
INSERT INTO pjt_vpl VALUES ("NH6_8","017_6_8","NEH","6","8","9","Ka ngayulu lita palunya mantjiṟa nyakula ngapartji lita kutjupa walkatjuṟa iyaṉu palulakutu alatji wangkara, “Palatja nyuntu kutjungku kulintja tjukurpa ngunti, mulapa wiya.” Munuṉa piṟuku Godala tjapiningi alatji wangkara, “Wiṟungkuṉi kuṉpunma Mayatja, kuṉpu ngaṟanytjaku tiṯutjara.” ");
INSERT INTO pjt_vpl VALUES ("NH6_10","017_6_10","NEH","6","10","11","Ka tjiṉṯu kutjupa wati kutjupangku ngayula wangkangu, “Utili ngura nyara miḻmiḻṯa timpula unngu ankula tuwa patiṟa unngu nyinama pitjala iluntankunytjaku-tawara.” Kaṉa palula wangkangu, “Wiya, ngayulu wirtjapakaṟa kumpintja wiyangku wantinyi. Ngayuluṉa tjanampa nguḻuringkunytja wiya. Nyanga alatjingaṟala wanyu wankaringkuku nguḻu kumpiṟa? Wiya wantima, kaṉa uti nyinama.” ");
INSERT INTO pjt_vpl VALUES ("NH6_15","017_6_15","NEH","6","15","16","Palulanguṟuya waṟkarira wall-pa palyaṟa wiyaṉu kaita tjuṯa kuḻu. Paluṟu tjana warpungkula nguwanpa wiyaṉu tjiṉṯu 52 kutju waṟkarira. Kaya ngura ititja tjuṯangka nganampa mirpaṉtju tjuṯangku wall-pa palyaṟa wiyannyangka kulinu munuya puḻkaṟa nguḻuringangi kuliṟa, “Tjanampa god-maṉṯu witulya puḻkanya, panya paluṟu tjananya alpamilaṉu wall-pa mapalku palyaṟa wiyantjaku.” ");
INSERT INTO pjt_vpl VALUES ("NH7_4","017_7_4","NEH","7","4","73","Kaya palulanguṟu aṉangu Jew panya ngaṉmanytju katinytja tjuṯa maḻaku wirkankunytjaku ngaṟangi ngura walytjangka Jerusalemala. Munuya ngura malikitja tjuṯanguṟu tjuṯa mulapa pitjangu nampa panya 50,000 nguwanpa munuya ngura walytjangka walytjangka wirkaṟa nyinangi. ");
INSERT INTO pjt_vpl VALUES ("NH8_1","017_8_1","NEH","8","1","8","Ka nyara palula aṟa aṉangu tjuṯa pitjanytjatjanu uwankara tjunguringu tjiṉṯu kutjungka. Ka wati tjukurtjara ini Itjuṟanya pakaṟa ngaṟangu aṉangu tjuṯangka kuranyu munu tjukurpa Godalu Mose-nya ungkunytja mantjiṟa aḻaṉu nyakula wangkanytjikitjangku. Kaya aṉangu uwankara aḻannyangka nyakula pakaṟa ngaṟangu. Ka Itjuṟalu wangkangu, “Godanyala waḻkunma katutja puḻkanya.” Kaya aṉangu tjuṯangku maṟa katuṉu munuya wangkangu, “Uwa mulapa.” Munuya tultjungaṟakatira Godanya waḻkuṉu. Ka wati panya Itjuṟalu Godaku tjukurpa nyakula wangkangi mungawinkinguṟu alatjiṯu munu kaḻaḻarinyangka kutju wiyaringu. Kaya aṉangu uwankarangku purkaṟangku kuliningi. Ka Itjuṟalu Godaku tjukurpa nyakula wangkanyangka wati tjukurtjara kutjupa tjuṯangku aṉangu tjuṯangka ngapartji utiṟa wangkangi. ");
INSERT INTO pjt_vpl VALUES ("NH8_9","017_8_9","NEH","8","9","11","Kaya aṉangu tjuṯangku Godaku tjukurpa kuliṟa tjituṟu-tjituṟuringu munuya puḻkaṟa ulangi tjukurpa palunya rawangku wantinytjatjanungku. Ka Itjuṟalu ngali aṉangu tjuṯangka wangkangu, “Ulanytja wiyariwa munuya pukuḻarira ankula mai wiṟu waina kuḻu ngalkula tjikila, munu mai kutjupa aṉangu ngaḻṯutjara tjuṯa ungama tjana kuḻu ngalkula paḻtjaringkunytjaku. Nyangatja tjiṉṯu miḻmiḻpa Godaku, kaya tjituṟu-tjituṟurinytja wiya nyinama ka paluṟu nyuranya pukuḻmankuku. Ka nyara palulanguṟu nyura palumpa pukuḻarira kuṉpuringkuku.” Alatji ngali tjanala wangkangi. ");
INSERT INTO pjt_vpl VALUES ("NH8_12","017_8_12","NEH","8","12","12","Kaya mulapaṯu ngurakutu pukuḻpa anu tjukurpa utingku kulintjatjanu munuya pukuḻṯu ngalkula tjikiningi, munuya ngaḻṯutjara tjuṯa kuḻu wangaṉarangku ungangi. ");
INSERT INTO pjt_vpl VALUES ("NH8_13","017_8_13","NEH","8","13","18","Munuya tjiṉṯu tjuṯangku inmangka tjunguringkula Godanya rawangku waḻkuningi piṟa kutju. ");
INSERT INTO pjt_vpl VALUES ("NH9_1","017_9_1","NEH","9","1","3","Munuya palulanguṟu piṟa kutju nguwanpa wiyaringkula aṉangu Jew uwankara malikitja tjuṯanguṟu paṯuringu, munuya mai wantira mantara walyku-walykungka tjarpangu munuya tjunguringkula tjituṟu-tjituṟu puḻka ngaṟangi tjanampa panya kuranguṟu. Munuyanku kura tjuṯa tjana palyantjatjanungku piiwiyaringkula Godala tjakultjunangi munuya wantinytjikitjangku kalkuningi. Munuya ngaṟala rawangku kuliningi Godaku tjukurpa tjanala nyakula wangkanyangka. Munuya palulanguṟu piṟuku ngaṟala Godanya rawangku wangkara waḻkuningi. ");
INSERT INTO pjt_vpl VALUES ("NH10_1","017_10_1","NEH","10","1","39","Munula Godanya kalkuṟa nyiringka walkatjunu alatji, “Nganaṉa tjukurpa nyuntu Mosenya ungkunytjitja uwankara wangaṉarangku kuliṟa palyalku tiṯutjarangku.” Alatjila wangkara kalkuṉu munula nyiri panya palula nganaṉa ini tjuṯa walkatjuṟa waṉaṉu wati panya kuranyitja tjuṯangku kalkuntja panya palunya mulamulangku palyantjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("NH11_1","017_11_1","NEH","11","1","36","Chapter nyanga palula Niyamayalu aṉangu Jerusalemala nyinanytja tjuṯa ini tjakultjunangi. ");
INSERT INTO pjt_vpl VALUES ("NH12_27","017_12_27","NEH","12","27","43","Munu palulanguṟula inma puḻka palyaṉu wall-pa panya palyaṟa wiyantjanya miḻmiḻmankunytjikitjangku Godaku miḻmiḻpa ngaṟanytjaku. Munula kuka pungkula tiliwakaṟa Godanya ungangi paluṟu nganampa pukuḻarinytjaku, munula inma inkara palunya waḻkuṟa pukuḻaringi. Kaya aṉangu kutjupa tjuṯangku pararinguṟu kuliningi nganaṉa inma inkara puḻkaṟa pukuḻarinyangka. ");
INSERT INTO pjt_vpl VALUES ("NH13_1","017_13_1","NEH","13","1","31","Chapter nyanga palula Niyamayalu tjukurpa kutjupa tjuṯa walkatjunu Israelkunu tjuṯaku aṟa tjuṯa. ");
INSERT INTO pjt_vpl VALUES ("ET1_1","018_1_1","EST","1","1","22","Iriti wati ini Tjuukitjinya mayatja puḻka mulapa nyinangi ngura tjuṯa mularku. Munu paluṟu tawunu ini Tjuutjala nyinara ngura palunya tjananya kanyiningi. Munu tjiṉṯu kutjupa paluṟu aṉangu winki aḻṯingu palumpa ngurakutu mai puḻka pitjala ngalkuntjaku tjiṉṯu tjuṯa. Kaya aṉangu tjuṯa mulapa pitjangu munuya puḻka ngalkula tjikiningi. Ka mayatja paluṟu palumpa kuri wangkangu mantara wiṟungka tjarpara palula tjungu pitjala ngaṟanytjaku aṉangu tjuṯangku nyakunytjaku. Palu paluṟu pitjanytja wiyangku wantingi. Ka mayatja panya paluṟu palumpa kuriku puḻkaṟa mirpaṉaringu munu palunya painu munu kutjupa aḻṯinytjikitjangku nguriningi. ");
INSERT INTO pjt_vpl VALUES ("ET2_1","018_2_1","EST","2","1","7","Munu paluṟu wati waṟka tjuṯa wituṉu kungkawaṟa tjuṯa uṯuḻuṟa palulakutu katinytjaku tjanalanguṟu kungkawaṟa kutju palumpa ngurkantankunytjikitjangku. Ka Esther-nya kungkawaṟa nyara palula tjanala tjungu pitjangu. Ka Esther-ku kuṯangku wati ini Mutukailu palula ngaṉmanytju wangkangu, “Kulila, nyuntu panyan Jew mununku palula tjanala utintja wiyangku wantima.” Ka paluṟu mulapa kutitjuṟa wantingi utintja wiyangku. ");
INSERT INTO pjt_vpl VALUES ("ET2_8","018_2_8","EST","2","8","23","Ka mayatjaku panya waṟkaripai tjuṯangku kungkawaṟa palunya tjananya rawangku kanyiningi waḻi kutjupangka mayatjaku ngurangka itingka, munu tjiṉṯu kutjupa tjiṉṯu kutjupa tjananya rawangku miṟi wiṟuningi. Ka yiya kutju wiyaringkunyangka wati panya mayatjangku wangkangu palulakutu katinytjaku kungkawaṟa panya tjuṯa yunpa nyakula kungkawaṟa kutju palumpa ngurkantankunytjikitjangku. Munu wati paluṟu tjananya uwankara kutju kutju nyangangi munu Esther-nya nyakula ngurkantanu, panya paluṟu wiṟu mulapa ngaṟanyangka. ");
INSERT INTO pjt_vpl VALUES ("ET3_1","018_3_1","EST","3","1","15","Ka mayatja panya puḻkaku maḻpa nyinangi ini Aimannga. Ka mayatja paluṟu wati palunya mayatja tjunu palula itingka nyinanytjaku. Ka wati paluṟu mayatja puḻkaku nguranguṟu ma-pakannyangka aṉangu tjuṯangku palunya pupakatira waḻkulpai. Palu wati panya Mutukailu wantingi palunya waḻkuntja wiyangku panya paluṟu wati Jew munu kuliningi alatji, “Ngayulu Godanya kutju waḻkulpai.” Munu paluṟu pupakatinytja wiya ngaṟangi. Ka kutjupangku nyakula tjakultjunu wati panya Aimanta, “Wati nyara paluṟu Jew nyinara nyuntunya pupakatira waḻkuntja wiyangku wantipai.” Ka Aimantu nyangatja kuliṟa Mutukaiku puḻkaṟa mirpaṉaringu munu paluṟu kuliningi, “Utila Mutukainya pungkula iluntanama palumpa walytja tjuṯa kuḻu aṉangu panya Jew uwankara ngura winkingka manta nyanga Papilaniyalawanu nyinanyangka muṉkara kuḻu.” Munu paluṟu ankula mayatja panya puḻkangka wangkangu, “Kulila, aṉangu Jew winkiya nyangatja nyinanyi tawunu nyanga uwankarangka munuya wangaṉarangku kulintja wiya nyuntula. Wanyu tjakulpa tjuṯa iyala tawunu tjuṯakutu kaya nyuntumpa tjaultji tjuṯangka wangka Jew uwankara iluntankunytjaku.” Ka mayatjangku kuliṟa wangkangu palula, “Uwa, palya nyangatja nyuntu nyanga wangkanytja. Ka tjukurpa palunya nyiringka walkatjura munu aṉangu tjuṯakutu iyala.” Ka Aimantu wati walkatjara tjuṯangka wangkangu nyiri tjuṯangka tjukurpa walkatjunkunytjaku wangka kutjupangka kutjupangka alatji, “Jew uwankaraya tjiṉṯu kutjungka iluntanama wati, minyma, tjitji kuḻu, kutju wanka kanyintja wiyangku. Munuya tjana kanyintja uwankara mantjinma kutjupa kutjupa wiṟu tjuṯa.” Munu paluṟu tjiṉṯu kuḻu walkatjunkunytjaku wangkangu panya tjaultji tjuṯangku tjananya iluntankunytjaku. Munuya walkatjuṟa wiyaringkula mayatja panya puḻkaku ini tjaṟu walkatjunu munuya mayatjaku ringi kiṯi puṟunytja tjaḻatjuṟa nyiringka walka tjampamilaṉu aṉangu tjuṯangku nyakula mulamularingkunytjaku. Munuya wati tjakulpa tjuṯa ungu ngura uwankarakutu katira aṉangu tjuṯangka nintintjaku. Ka tjakulpa kutjungku ngura pala Tjuutjala tjukurpa panya palunya nyakula wangkangu aṉangu tjuṯangku kulintjaku. ");
INSERT INTO pjt_vpl VALUES ("ET4_1","018_4_1","EST","4","1","17","Ka Mutukailu lita panya mayatjangku walkatjunkunytja kuliṟa puḻkaṟa tjituṟu-tjituṟuringu munu mantara paluṟunku kaṯantaṟa araṉu mununku tjuṉpangka puntu winki nyiṯiṟa mantara walyku-walykungka tjarpara iwarangka para-ngaṟala puḻkaṟa ulangi, panya tjakaya tjituṟu-tjituṟu ngaṟala alatjinkupai. Ka kungkawaṟa Esther-ku waṟkaripaingku nyangu wati palunya para-ngaṟala ulanyangka munu ankula Esther-la tjakultjunu. Ka paluṟu kuliṟa urulyaraṟa puḻkaṟa nguḻuringu munu kungkawaṟa kutju mantara ungu katira Mutukainya ungkunytjaku. Palu wati paluṟu ungkunyangka mantjintja wiyangku wantingi. Ka Esther-lu piṟuku wati waṟka wituṉu Mutukaila tjapiṟa kulintjaku nyaaku paluṟu alatjirinyi. Ka paluṟu ankula tjapinu. Ka Mutukailu tjakultjunu tjukurpa uwankara munu lita panyatja kuḻu ungu Esther-nya ungkunytjaku panya mayatjangku palyanmankula ungkul'iyantjanya, munu wati panya waṟka wituṉu, “Ankula Esther-la wangka, ka paluṟu ankula mayatja panya puḻkangka anga-wangkara puḻkaṟa ngatjila nganampa ngaḻṯuringkunytjaku Jew panya tjuṯaku.” Ka wati panya waṟka paluṟu anu maḻaku piṟuku Esther-lakutu munu wangkangu palula uwankara panya Mutukailu wangkanytja munu nintinu nyiri panya mayatjangku walkatjunkunytja. Ka Esther-lu nyiringuṟu nyakula wiyaringkula wangkangu, “Ankula alatji wangka Mutukaila, ‘Ngayulu mayatjakutu puṯu ananyi, panya paluṟu aḻṯinyangka kutju aṉangu kutjupa tjarpapai palunya nyakunytjikitja. Palu paluṟu aḻṯinytja wiyangka puṯu tjarpanyi walytjangku kuliṟa. Nyangatja palumpa aṟa. Tjinguṟu ngayulu aḻṯinytja wiyangka watarku tjarparampa ka ngayunya iluntankuku. Panya paluṟu kutjungku kutjupa-aṟa palumpa tjukara puṟunypa gold-nguṟu palyantjitja witiṟa katulpai, ka nyara paluṟu nintilpai aṉangungku nyakula ngurkantankunytjaku munu tjarpanytjaku. Kulila, ngayulu panya palunya nyakunytja wiya alatjiṯu nyinangi piṟa kutju, panya paluṟuṉi aḻṯinytja wiyaṯu. Kaṉa puṯu ananyi palulakutu.’ Alatji Mutukaila ankula wangka.” Ka ankula wangkanyangka Mutukailu kuliṟa piṟuku wangkara wati panya waṟka iyaṉu Esther-lakutu alatji wangkanytjaku, “Kulila! Nyuntu tjinguṟu kulini mayatjaku ngurangka pala nyinara wanka nyinanytjikitjangku-palku, palu wiya. Nyuntu panya Jew, kantaya nyuntunya kuḻu iluntankuku nyuntu nganampa anga-wangkawiyangku wantinyangkampa. Palya kutjupangkuntilanya ngula ngalkilku, palu nyuntu nganaṉa kuwari iluku ngalimpa walytjapiti uwankara. Palu kulila, Godalunta nyuntunya tjunu kuwari nyanga mayatja nyinara nganampa anga-wangkanytjaku alatjiṯu.” Ka Esther-lu nyangatja kuliṟa wati panya waṟkaripai piṟuku iyaṉu Mutukailakutu nyanga alatji wangkanytjaku, “Aṉangu Jew tjuṯa ngura nyanga Tjuutjala nyinanyangka aḻṯira uṯuḻura munu tjananya wangka mai ngalkuwiya nyinanytjaku tjiṉṯu maṉkurpa tjana kuliṟa ngayuku Godala tjapintjikitjangku. Ka ngayulu kuḻu palu puṟunypaṯu mai wiya nyinara Godala puḻkaṟa tjapilku. Munuṉa palulanguṟu mayatja panya puḻkakutu ankuku. Kaṉi tjinguṟu nyakuku, munta tjinguṟuṉi iluntankuku.” Ka Mutukailu mulapaṯu palyaṉu uwankara Esther-lu wangkanytja. ");
INSERT INTO pjt_vpl VALUES ("ET5_1","018_5_1","EST","5","1","8","Munu palulanguṟu Esther-nya tiṟitja wiṟu mulata tjarpangu, munu ankula mayatjaku ruumangka itingka uti ngaṟangi tuwa aḻangka paluṟu nyakula aḻṯinytjaku. Ka wati panya mayatjangku palunya nyakula pukuḻaringu munu puṉu panya tjukara puṟunypa gold-nguṟu palyantjitja katuṉu paluṟu tjarpanytjaku. Ka Esther-lu nyakula ngalya-tjarpangu munu puṉu panya tjukara puṟunypa paluṟu katuṟa kanyintjanya ankala pampuṉu. Ka mayatjangku panya palula tjapinu, “Nyaaringun? Nyaakun mukuringanyi? Nyuntu mukuringkunyangkaṉa nyuntunya tjaraṟa puḻka mulapa ungkuku ngayulu kanyintjatjanungku.” Ka Esther-lu wangkangu, “Wanyu nyuntu pitjaku kuwari panya ngayulu mai puḻka palyaṟa wantingu nyuntu nganaṉa ngalkuntjikitjangku. Ka wati panya Aimannga kuḻu ngalya-katima nyuntula tjungu.” Ka nyanga palunya kuliṟa Mayatja panya pukuḻaringu munu wati palumpa waṟkangka wangkangu, “Ankula Aimannga warpungkula aḻṯi, kali paluṟu ngali ara Esther-ku ngurakutu mai ngalkuntjikitja.” Ka mulapaṯu ankula aḻṯingu wati palunya. Ka pula tjunguringkula anu Esther-ku ngurakutu munu pula mai wiṟu ngalkuningi palula tjunguringkula. Ka Mayatja panya puḻkangku Esther-la tjapinu, “Nyaakun mukuringanyi? Nyuntu mukuringkunyangkampa ngayulu nyuntunya tjaraṟa puḻka mulapa ungkuku ngayulu kanyintjatjanungku.” Ka Esther-lu wangkangu, “Ngayulu mukuringanyi nyuntu ngayuku pukuḻarinytjaku. Palu wanyu piṟuku pitja mungawinki mai kutjupaku Aimannga nyupaliṯu. Kaṉanta nyara palulalta tjakultjunkuku ngayulu mukuringkunytja.” ");
INSERT INTO pjt_vpl VALUES ("ET5_9","018_5_9","EST","5","9","14","Ka pula mai ngalkula wiyaringkula anu ngurakutu. Ka Aimantu nguṟurpa nyangu wati panya Mutukainya nyinanyangka kaitangka itingka. Ka wati paluṟu Aimannga pitjanyangka nyakula pakaṟa pupakatira waḻkuntja wiyangku wantira alatjiṯu nyinangi. Ka paluṟu puḻkaṟa mirpaṉaringu Mutukaiku, palu wangkanytja wiyaṯu kaṯakutjara anu. Munu ngurangka wirkaṟa aḻṯingu palumpa maḻpa tjuṯa munu minyma kuri kuḻu munu kaṉany-kaṉanytju alatjiṯu tjanala tjakultjunangi panya mayatja puḻkangku palunya mayatja nampa 2 nyinanytjaku tjunkunytja. Munu wangkangi, “Panya kuwari mayatjaku kuringku mai palyaṟa ngayunya kutju aḻṯingu mayatjangka tjungu ankunytjaku. Kali tjiṉṯungka piṟuku ananyi maiku. Palu aṉangu kutjungkuṉi tjituṟu-tjituṟu palyaṉu. Kaṉa palumpa puḻkaṟa mirpaṉarinyi wati panya Jew ini Mutukaiku.” Kaya palula wangkangu, “Uti nyuntu wati waṟka tjuṯa aḻṯima, kaya pitjala puṉu waṟa palyala ruupatjara aṉangu ruupangka liri karpiṟa katunguṟu waṟaly-waṟalytjunkunytjaku. Munun mungawinki nyuntu mayatjangkalta wangka Mutukainya liringuṟu waṟaly-waṟalytjunkunytjaku. Munun pukuḻariralta ananyi maiku mayatjangka tjungu.” Ka Aimantu unngu kulinu, “Munta-uwa, nyangatja wiṟu nguwanpa.” Munu wangkangu wati waṟkaripai tjuṯa, “Kuwariya puṉu waṟa palyala aṉangu liri karpiṟa katunguṟu waṟaly-waṟalytjunkunytjaku.” ");
INSERT INTO pjt_vpl VALUES ("ET6_1","018_6_1","EST","6","1","14","Ka munga nyara palula wati panya mayatja puḻkanya puṯu nguwanpa kunkunaringi. Munu paluṟu aḻṯingu wati waṟkaripai kutju munu palula wangkangu, “Nyuntu panya nyiringka walkatjunkupai nganaṉa kutjupa kutjupa tjuṯa wangkanyangka munu palyannyangka kuḻu. Wanyu nyiri panya palunya mantjila munu nyakula wangka kaṉa kulila nyaaringangiya ngura nyangangka.” Ka paluṟu nyiri panya palunya mantjinu munu nyakula wangkangi tjukurpa tjuṯa munu tjukurpa nyangangka wirkaṟa wangkangu alatji, “Wati kutjarangku pula mayatja panya puḻka iluntankunytjikitjangku kuliningi. Ka wati ini Mutukailu nyanga palunya kuliṟa ankula palula wangkara nguḻutjunu.” Alatji wati panya waṟkangku mayatja puḻkangka wangkara utinu. Ka mayatjangku wangkangu, “Munta-uwa panya wati nyanga paluṟuṉi wankakutuṉu. Kaṉa nyaa palunya ngapartji ungu paluṟu ngayunya wankakutunnyangka?” Ka wati panya waṟkaripaingku wangkangu, “Wiya, nyuntu Mutukainya kutjupa kutjupa ngapartji ungkunytja wiyaṯu.” Ka pula nyinara wangkanyangka Aimannga ngalya-tjarpangu mayatjaku waḻingka munu paṯaṟa ngaṟangi, panya paluṟu pitjangu mayatjangka tjapintjikitja mungawinki Mutukainya waṟaly-waṟalytjunkunytjikitjangku. Ka wati waṟkaripaingku nyangu Aimannga munu wangkangu mayatjangka, “Aimannga nyangatja nyuntumpa paṯaṟa ngaṟanyi.” Ka wangkangu, “Palya, pitjanytjaku wangka.” Munu palulanguṟu Aimannga pitjanyangka mayatjangku palula tjapinu, “Wati kutjuṉa pukuḻmankunytjikitja mukuringanyi munuṉa nyaalku?” Ka Aimantu unngu alatji kuliningi, “Munta, Mayatjalu tjinguṟu ngayunya kulini pukuḻmankunytjikitjangku.” Munu wangkangu, “Uti nyuntu palunya tjarpatjunama nyuntumpa mantara wiṟungka munu nyuntumpa panya nyanytjungka tatitjura. Ka wati nyuntumpa waṟkaripaingku uti puṟala witiṟa katima iwara tjuṯangka aṉangu tjuṯangku nyakunytjaku, munu uti paluṟu aṉangu tjuṯangka para-wangkama nyanga alatji, ‘Mayatja panya puḻkanya wati nyanga palumpa puḻkaṟa pukuḻarinyi munu paluṟu mukuringanyi nyura kuḻu palumpa pukuḻarira palunya mirawaṉinytjaku.’” Ka mayatjangku kuliṟa Aimannga wituṉu, “Warpungkula ngayuku mantara wiṟu kati munu Mutukainya tjarpatjura munu nyanytjungka tatitjura iwara tjuṯangka kati munu aṉangu tjuṯangka tjakultjunama panya nyuntu wangkanytjanya alatjiṯu.” Ka Aimantu wangaṉarangku kulinu mayatjangku wangkanyangka palu unngu paluṟu puḻkaṟa kuṉṯaringu. Munu wiyaringkula paluṟu mapalku anu ngurakutu kata mantarangka tjutuṟa panya paluṟu kuṉṯaringu. Munu ankula waṟkaripai tjuṯangka palumpa kuringka kuḻu tjakultjunangi. Ka nyinara wangkanyangka mayatjaku wati waṟkaripai kutju wirkanu munu wangkangu, “Wala puḻka kunyu pitja maikutu, panya Esther-lu palyantja riti ngarinyi.” ");
INSERT INTO pjt_vpl VALUES ("ET7_1","018_7_1","EST","7","1","10","Ka Aimannga kuliṟa anu munu mayatja panya puḻkangka tjunguringkula pula wirkanu Esther-ku ngurangka munu pula tjarpara mai ngalkuningi palula tjunguringkula. Palu mayatjangku panya piṟuku tjapinu Esther-la, “Nyaakun mukuringanyi? Tjinguṟu nyuntu mukuringkunyangkaṉanta tjaraṟa puḻka mulapa ungkuku ngayulu kanyintjatjanungku.” Ka Esther-lu wangkangu, “Wiṟungkuṉi wanyu wankaṟura wanka nyinanytjaku, ngayuku walytja tjuṯa kuḻu. Panya ngayulu nyiringka nyangu ngayuku walytja tjuṯa iluntankunytjikitjangku wangkanytja. Palu wanyulanya wiṟungku aṯunymaṟa wanka kanyinma.” Ka mayatjangku panya tjapinu, “Nganalu wanyu walkatjuṟa iyaṉu nyuntumpa walytja tjuṯa iluntankunytjaku?” Ka Esther-lu wangkangu, “Wati nyangangku. Nyanga paluṟu wati kura nganampa mirpaṉtju.” Ka Aimannga kuliṟa puḻkaṟa nguḻuringu. Ka wati panya mayatja puḻka palumpa puḻkaṟa mirpaṉaringu. Ka mayatjaku wati waṟkaripaingku wangkangu, “Nyaratja nyawa, puṉu nyara waṟa palyantja ngaṟanyi Aimanku waḻingka itingka. Nyara palulaya kunyu kuwari Mutukainya liri karpiṟa katunguṟu waṟaly-waṟalytjunanyi.” Ka mayatjangku wangkangu palumpa waṟkaripai tjuṯangka, “Wiya, wati nyanga palunya alatjiṯuya utitjura nyara palula.” Kaya mulapaṯu wati panya Aimannga katira liri karpiṟa katunguṟu waṟaly-waṟalytjunu, ka ilungu. ");
INSERT INTO pjt_vpl VALUES ("ET8_1","018_8_1","EST","8","1","17","Ka Esther-lu mayatja panya puḻkangka tjakultjunu wati panya Mutukainya kuṯa palumpa nyinanyangka. Ka mayatja paluṟu Mutukainya aḻṯingu palulakutu pitjanytjaku, munu pitjanyangka paluṟu ringi palumpa manyirkanguṟu araltjaṟa Mutukainya ungu palumpa pukuḻarira. Ka Esther-lu mayatjangka puḻkaṟa ngatjiningi tjukurpa panya Aimantu walkatjuṟa iyantja wiyanmankunytjaku panya paluṟu ngaṉmanytju ngura tjuṯakutu iyaṉu. Munu wangkangu, “Wanyu tjukurpa kutjupa walkatjura munu Aimanku tjukurpa wiyala. Ngayulu mukuringkunytja wiya ngayuku walytja tjuṯa ilunytjaku.” Ka mayatjangku kuliṟa wangkangu, “Palya nyupali tjukurpa kutjupa walkatjura, munu walkatjuṟa wiyaringkula tjaṟu ngayuku ini walkatjura. Munu ringi ngayuku kiṯi puṟunytja tjaḻatjuṟa nyiringka walka tjampamilala, munu pula Jew tjuṯakutu iyala tjana nyakunytjaku. Kaya ngayuku ini walka nyakula kulilku, ‘Munta-uwa, nyangatja tjukurpa mulapa mayatjangku panya iyantja, kala puṯu wantinyi.’” Ka palulanguṟu Mutukailu mayatjaku panya waṟkaripai tjuṯa wangkangu tjukurpa nyiringka walkatjunkunytjaku wangka kutjupa wangka kutjupa. Kaya mulapaṯu kuliṟa mayatjaku tjukurpa walkatjunu aṉangu uwankaraku Jew tjuṯaku kuḻu alatji, Panya Aimantu tjukurpa ngaṉmanytju walkatjuṟa iyaṉu aṉangu tjuṯakutu ngayuku initjara tjana kuliṟa tjiṉṯu kutjungka Jew tjuṯa pungkula wiyantjaku. Palu kuwariṉa Jew tjuṯangka wangkanyi alatji, “Tjiṉṯu nyara palula kutjupa tjuṯa nyuranya pungkunytjikitja pitjanyangka nyura uti tjananya wantinytja wiyangku puḻkaṟa pungama. Uti nyura tjunguringkula paṯanma kuḻaṯa winki munuya pitjanyangka nyakula tjananya uwankara pungkula alatjiṯu wiyanma munuya tjana kanyintja uwankara mantjiṟa katima.” Alatjiṉa nyuranya mulamulangku wangkanyi nyura wankaringkunytjaku. Alatjiya walkatjara tjuṯangku mayatjaku tjukurpa walkatjunu Mutukailu tjakultjunkunyangka. Munuya walkatjuṟa wiyaringkula mayatjaku ini tjaṟu walkatjunu munu palumpa walka kuḻu tjampamilaṉu palumpa ringingka. Munuya palulanguṟu mayatjaku waṟkaripai kutjupa tjuṯa nyiri palunya tjananya ungkul'iyaṉu, kaya nyanytjungka tatiṟa warpungkula katingu tawunu winkikutu. ");
INSERT INTO pjt_vpl VALUES ("ET9_1","018_9_1","EST","9","1","32","Ka tjiṉṯu panyatja wirkanu panya Aimantu Jew tjuṯa pungkunytjaku wangkanytjitja. Palu Jew tjuṯa tjunguringu tjanampa mirpaṉtju tjuṯa pikangku pungkunytjikitja munuya pungkula uwankara wiyaṉu Jew tjuṯangku. Panya mirpaṉtju tjuṯa kuṉpu wiya nguwanpa munuya nguḻuringangi tjanampa, panya mayatjaku waṟkaripai tjuṯangku tjananya angatjunkunytja wiyangku wantir'iyaṉu, ka tjana tjuṯa mulapa pungu panya aṉangu nguratja tjuṯa. Ka palula maḻangka Jew panya tjuṯa puḻkaṟa pukuḻaringu munuya ngura winkingka mai puḻka palyaṟa tjunguringkula ngalkuningi. Munuyanku kutjupa kutjupa tjuṯa mantjiṟa kutjungku kutjungku ngapartji-ngapartjingku ungangi pukuḻarira. Munuya palulanguṟu yiya kutjupa yiya kutjupa tjiṉṯu panya paluṟu wirkankunyangka mai puḻka palyaṟa ngalkupai aṟa panya palunya kulintjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("ET10_1","018_10_1","EST","10","1","3","Ka mayatja panya puḻkangku Mutukainya mayatja tjunu palula itingka mayatja nyinanytjaku. Kaya Jew tjuṯangku pukuḻarira Mutukainya wangaṉarangku kulilpai, panya Esther-lu pula kuṯaṟarangku tjananya mayatjangka anga-wangkara wankakutuṉu. ");
INSERT INTO pjt_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Godalu pukuḻmankupai palula wangaṉarangku kulilpai tjuṯa. Nyara paluṟu tjana panya kuliṟa wantipai aṉangu kurangku tjananya wituwitunnyangka, munuya iwara kurangka ankunytjaku aḻṯinyangka wantipai, munuya Godanya kaṉany-kaṉanytju analpai tjuṯangka tjunguringkupai wiya. ");
INSERT INTO pjt_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","Paluṟu tjana pukuḻaripai Godaku tjukurku munuya wangaṉarangku kulilpai, munuya nyakula wangkara tiṯutjarangku kulilpai kaḻaḻa mungangka kuḻu. ");
INSERT INTO pjt_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Munuya tjana kuṉpu ngaṟapai, panya puṉu tjuṯa uṟungka itingka ngaṟala waṉalpai, palu puṟunypa. Panya puṉu paluṟu tjana tiṯutjara maitjararingkupai munu nyaḻpi piḻṯiringkupai wiya. Palu puṟunypa nyanga tjana Godaku tjukurpa tiṯutjarangku mulamulangku kulilpai, munuya palulanguṟu kuṉpu ngaṟapai, ka Godalu wiṟu tjuṯa tjanampa palyalpai. ");
INSERT INTO pjt_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Palu aṉangu kura palyalpai tjuṯa tjana puṟunypa wiya. Panya paluṟu tjana unytjunytju puṟunypa nyinanyi, panya kaṉiṟa mai uṉinypa tjaraṟa unytjunytju ma-uṉṯuṟa waṉipai, nyanga palu puṟunypa tjananya Godalu waṉiku tjaraṟa. ");
INSERT INTO pjt_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","6","Uwa, tjanampa kuranguṟu Godalu ngula tjananya ngurkantaṟa tjaralku palumpa walytja tjuṯanguṟu mauṉṯalpa nyinanytjaku, kaya ngura kurangka tiṯutjara nyinaku. Ka Godalu palumpa walytja tjuṯa aṯunymaṟa kanyilku palula wangaṉarangku kulilpai tjuṯa. ");
INSERT INTO pjt_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","Inma nyangatja Davidalu walkatjunkunytja panya paluṟu palumpa katja Absalomalanguṟu nguḻu wirtjapakantjatjanungku. Mayatja, aṉangu panya tjuṯa mulapa ngayuku kuraringanyi, munuṉiya kuwari winkingku pikangku wataparaṉi. ");
INSERT INTO pjt_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","Tjana kunyu anaṟa wangkapai ngayunyatjara alatji, “Godalu palunya wankaṟunkunytja wiya alatjiṯu.” ");
INSERT INTO pjt_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","Palu Mayatja, nyuntun ngayunya kuṯitji puṟunytju anga-kanyilpai. Munuṉin ngayunya witulyankupai tjananya pungkula waintarinytjaku, munuṉin rapa ngaṟanytjaku palyalpai. ");
INSERT INTO pjt_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","Panya ngayulu nyuntula ulara tjapilpai wankaṟunkunytjaku, ka nyuntu mulapaṯu ngayunya puḻi miḻmiḻṯanguṟu alpamilalpai ngura pala Tjayantanguṟu. ");
INSERT INTO pjt_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","Mayatja, nyuntu panyan ngayunya aṯunymaṟa kanyilpai, kaṉa mungangka wiṟuṟa kunkunaripai munuṉa mungawinki wankaringkula pukuḻpa pakalpai. ");
INSERT INTO pjt_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","Ngayuku mirpaṉtju mungilyingkuṉiya para-angatjuṟa waṉaṟa pikangku wataparaṉi. Palu ngayulu tjanampa nguḻuringkunytja wiya rapa alatjiṯu ngaṟanyi. ");
INSERT INTO pjt_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","7","Mayatja God, pitjalaṉitju wankaṟunama! Munu ngayuku nyanga mirpaṉtju tjuṯa kaṯiṯi pungkula minya-minyanma. ");
INSERT INTO pjt_vpl VALUES ("PS3_8","020_3_8","PSA","3","8","8","Mayatja, nyuntu panya nyuntumpa walytja tjuṯa wankaṟu kanyilpai. Wanyu tjananya mukulyangku pukuḻmanama. ");
INSERT INTO pjt_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","Mayatja, ngayuku puḻkaṟa mirpaṉariwiyangkuṉi wantima, Munuṉi puḻkaṟa ngayunya pikantankunytja wiyangku kuḻu wantima. ");
INSERT INTO pjt_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","Panya ngayulu kuwari paku puḻkaringu, katju Mayatja, wanyu ngaḻṯuringama munuṉitju kuṉpunma. Panya ngayulu uparingkula nyanga kuwari paku puḻkaringu, ");
INSERT INTO pjt_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","munuṉa puntu winki kuḻu kuraringu. Palu Mayatja, nyaakun ngayunya rawangku nyakula wantinyi alpamilantja wiyangku? ");
INSERT INTO pjt_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","Wanyuṉitju pitjala wankaṟura! Munuṉitju ngaḻṯunytju puḻkangku aṯunymaṟa kanyinma ilunytjaku-tawara. ");
INSERT INTO pjt_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","Panya miriku ngurangka aṉangu ilunytjitja tjuṯa nyinara nyuntunya kulintja wiyaringkupai, munuya nyuntunya waḻkuntja wiya alatjiṯu. ");
INSERT INTO pjt_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","Ka ngayulu kuwari paku puḻkaringkula uḻiringkula nyuntula tjapini. Panya ngayulu mungangka ngarira puḻkaṟa ulapai, ka iḻanypa puḻka ngayula kuṟunguṟu mantarangka punkalpai. ");
INSERT INTO pjt_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","Panya ngayuku mirpaṉtju tjuṯangkuya kuwari ngayunya rawangku nyii-nyiipungkula ulatjingalpai. Kaṉa nyangatja palulanguṟu kuwari rawa ulara ulara kuṟu utjuringkula pikaringu munuṉa puṯu nguwanpa palyanyku nyakupai. ");
INSERT INTO pjt_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","Mayatja, nyuntu wiṟungku ngayunya ulanyangka kulinu. Munu wanyu kura nyanga palyalpai tjuṯa paila ngayunya wantikatinytjaku! ");
INSERT INTO pjt_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","Panya nyuntu kulilpai ngayulu nyuntula ngatjinnyangka. ");
INSERT INTO pjt_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","Munun ngayuku mirpaṉtju tjuṯa paiṟa iyalku, Kaya mulapa paluṟu tjana kuṉṯaringkula mapalku nguḻu wirtjapakalku. ");
INSERT INTO pjt_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","Davidalu inma nyangatja walkatjunu Inmaku Mayatjaku inma inkapai tjuṯangku kitangka tjungu inkanytjaku. Mayatja God, aṉangu manta winkitjangkula nyuntunya kulini nyuntu panyan mayatja witulya puḻka nyinanyi wiṟu mulapa munun ilkaṟingka pitalytji puḻkangku uwankara alatjiṯu irnyaṉi. ");
INSERT INTO pjt_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","Kaya tjitjingku iṯingku kuḻu nyakula inma inkara nyuntunya mirawaṉipai. Ka nyuntumpa kuraringkupai tjuṯangku nyuntunya puṯu analpai nyuntu witulya puḻkangku markunnyangka. ");
INSERT INTO pjt_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","Panya mungangkaṉa ilkaṟi ira-nyakupai nyuntu panya paluntja, panya kinaṟa, kililpi kuḻu nyuntu tjunkunytja. ");
INSERT INTO pjt_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","Munuṉa nyakula kulilpai, “God, nyuntu panyan puḻka mulapa, ka panya nganaṉa aṉangu tjuṯa minga puṟunypa. Palu nyuntu nganaṉanya ngaḻṯunytjungku kulilpai, Munulanyan aṯunymaṟa kanyilpai. ");
INSERT INTO pjt_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","Panya nyuntu nganaṉanya tjunu puḻka mulapa nyinanytjaku nyuntula itingka pitalytji puḻkatjara. ");
INSERT INTO pjt_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","Munu panyan nganaṉanya tjunu nyuntu panya paluntjitja uwankara mayatjarira kanyintjaku. ");
INSERT INTO pjt_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","Panya nyuntu nganaṉanya tjunu uwankara aṯunymaṟa kanyintjaku tjiipi puluka inuṟa tjuṯa kuḻu, ");
INSERT INTO pjt_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","munu tjuḻpu ilkaṟingka para-ngaṟapai tjuṯa munu uṟu unngu para-ngaṟapai tjuṯa kuḻu.” ");
INSERT INTO pjt_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","Mayatja God, aṉangu manta winkitjangkula nyuntunya kulini nyuntu panyan mayatja witulya puḻka nyinanyi wiṟu mulapa. ");
INSERT INTO pjt_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","1","Mayatja, nyaakuṉin rawangku ngayunya kuliṟa wantinyi? ");
INSERT INTO pjt_vpl VALUES ("PS13_2","020_13_2","PSA","13","2","2","Nyangatjaṉa rawa alatjiṯu tjituṟu-tjituṟu nyinanyi mungangka kaḻaḻa. Panya ngayuku mirpaṉtju tjuṯangkuṉi kuwari rawangku nyii-nyiipunganyi. Kaṉi nyuntu yaalaṟa wankaṟunkuku? ");
INSERT INTO pjt_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","3","Mayatja God, wanyuṉitju nyuntu kulinma rawangku wantinytja wiyangku ngayulu nyuntula tjapinnyangka. Munu ngayunya wankaṟu kanyinma ngayulu ilunytjaku-tawara. ");
INSERT INTO pjt_vpl VALUES ("PS13_4","020_13_4","PSA","13","4","4","Panya ngayulu tjinguṟu iluku, kaya ngayuku mirpaṉtju tjuṯa ngayuku puḻkaṟa alatjiṯu ikaringkula pukuḻariku munuya wangkaku alatji, “Awa! Nganaṉa palya alatjiṯu wiyaṉu!” Kaṉi pala palula-tawara ngayunya wankaṟunama tjana ngunti pukuḻarinytjaku-tawara. ");
INSERT INTO pjt_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","Ngayulu ninti panya nyuntu ngayuku puḻkaṟa mukuringanyi tiṯutjara alatjiṯu, kaṉa nyanga palulanguṟu ngayulu rapa puḻka nyuntula tjungu nyinanyi. Munuṉa puḻkaṟa pukuḻarinyi nyuntu ngayunya wankaṟunkunyangka. ");
INSERT INTO pjt_vpl VALUES ("PS13_6","020_13_6","PSA","13","6","6","Uwa, nyuntu panya ngayunya puḻkaṟa pukuḻmanu, kaṉa pala palulanguṟu inma tjuṯa inkara nyuntunya puḻkaṟa waḻkulku. ");
INSERT INTO pjt_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","Godanya wiṟu mulapa, panya nganaṉa ilkaṟi nyakula palunya kulini uti, panya mulapa nyanganpa Godalu paluntja uwankara. ");
INSERT INTO pjt_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","Tjiṉṯu kutjupa tjiṉṯu kutjupa nganaṉa ilkaṟi nyakula Godanya mulapa kulini. Ka mungangka palu puṟunypaṯu ilkaṟingku nganaṉala nintini Godalu witulya puḻkangku palyantja. ");
INSERT INTO pjt_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","4","Ilkaṟingku wangkapai wiya. Palu ilkaṟingku nintini nganaṉala Godanya kuliṟa mirawaṉinytjaku. Nganaṉa ilkaṟingku wangkanyangka kulintja wiyaṯu. Palu manta winkingka aṉangu uwankarangku ilkaṟi nyakula Godanya kuliṟa waḻkuntjaku ngaṟanyi. ");
INSERT INTO pjt_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","Godalu ilkaṟingka ngura tjiṉṯuku palyaṉu mungaringkunyangka tjarpara ngarinytjaku puṟunypa, kala mungangka puṯu nyakupai. Ka mungawinki tjiṉṯu paluṟu wiṟu mulapa ngalya-pakalpai, panya watingku kuwari kutju aḻṯinytja puṟunypa, panya paluṟu kungkawaṟa aḻṯira mungawinki pukuḻpa mulapa pakalpai, palu puṟunypa. Uwa, tjiṉṯu ngalya-pakaṟa wiṟuṟa ankupai, wati wala puḻka puṟunypa, panya wati paluṟu wirtjapakantjikitja puḻkaṟa pukuḻaripai, palu puṟunypa. ");
INSERT INTO pjt_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","Tjiṉṯu paluṟu pakalpai ilkaṟi kampa kakaraṟanguṟu, munu ilkaṟingka kaṯakutjara ankula ma-tjarpapai ilkaṟi kampa wiluṟara. Munu paluṟu manta winkingka kampapai wiltjangka nyinanytjaku. Uwa, mulapa ilkaṟingku tjiṉṯungku munu Godaku tjukurtu kuḻu nganaṉala Godanya nintilpai. ");
INSERT INTO pjt_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","Panya Godaku tjukurpa puḻka mulapa, munu nganaṉa uparingkunyangka tjukurpa paluṟu nganaṉanya piṟuku kuṉpulpai. Godalu tjukaṟurungku wangkapai, kala uti palumpa tjukurku puḻkaṟa mulamularingama. Panya palumpa tjukurtu aṉangu ngurpa nyinanyangka nintipukaringkunytjaku nintilpai. ");
INSERT INTO pjt_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","Uwa, mulapa Mayatjaku tjukurpa tjukaṟuru mulapa. Ka panya aṉangungku tjukurpa nyara palunya kuliṟa pukuḻaripai, panya palumpa tjukurpa wiṟu mulapa. Ka tjukurpa nyara paluṟu nganaṉala utilpai Godaku iwara tjukaṟurungku waṉantjaku. ");
INSERT INTO pjt_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","Nyangatja wiṟu alatjiṯu ngaṟanyi nganaṉa Mayatja Godanya waḻkuntjaku. Kala rawangku palunya kutju waḻkunma, panya palumpa kulintja tjukaṟuru alatjiṯu tiṯutjara ngaṟanyi. ");
INSERT INTO pjt_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","Puḻi gold wiṟunya mani puḻka mulapa, palu Godaku tjukurpa wiṟu mulapa goldpangka muṉkara alatjiṯu. Ka tjuratja panya mayu wiṟu, palu Godaku tjukurpa wiṟu mulapa wantinytjaku wiya tjuratjangka muṉkara mulapa. ");
INSERT INTO pjt_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","Ngayulu Mayatjala wangaṉarangku kulilpai, kaṉi palumpa tjukurtu tjukaṟurungku palyantjaku nintilpai. Ka ngayulu palumpa tjukurpa kulinnyangka Godalu ngapartji ngayunya wiṟuṟa kanyini. ");
INSERT INTO pjt_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","Nganaṉa uwankarangku walytjangku puṯu ngurkantananyi kura uwankara nganaṉa palyantjatjanungku. Ka Mayatja, ngayuku kalyparingama ngayulu watarkungku kura palyannyangka. ");
INSERT INTO pjt_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","Munu ngayulu nintingku kura palyantjikitjangku kulinnyangkampa ngayunya markunma kura kutju tiṯutjarangku palyalkatinytjaku-tawara. Kaṉa palulanguṟu kuṉṯa wiya palya nyinama. ");
INSERT INTO pjt_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","Mayatja, nyuntu ngayunya kuṉpu puḻkangku anga-kanyilpai kurantjaku-tawara. Kaṉa mukuringanyi nyuntu pukuḻarinytjaku ngayulu nyanga wangkanytja munu kulintja uwankaraku, panya nyuntun ngayuku ngalkilpa nyinanyi. ");
INSERT INTO pjt_vpl VALUES ("PS20_1","020_20_1","PSA","20","1","1","Nganaṉa Mayatja Godala tjapini, Jacobaku panya Godangka, paluṟu kura nyuntula utiringkunyangka, nyuntunya kuliṟa anga-kanyintjaku ");
INSERT INTO pjt_vpl VALUES ("PS20_2","020_20_2","PSA","20","2","2","Palulala tjapini paluṟu ngura nyara Jerusalemalanguṟu nyuntumpa alpa iyantjaku ngura panya miḻmiḻṯanguṟu. ");
INSERT INTO pjt_vpl VALUES ("PS20_3","020_20_3","PSA","20","3","3","Uwa, Godalala tjapini nyuntumpa pukuḻarinytjaku nyuntu wiṟu tjuṯa palunya ungkula waḻkunnyangka. ");
INSERT INTO pjt_vpl VALUES ("PS20_4","020_20_4","PSA","20","4","4","Nganaṉa Godala tjapini nyuntu mukuringkunytja uwankara palyantjaku, munu nyuntumpa kulintja uwankara tjukaṟuru utiringkunytjaku. ");
INSERT INTO pjt_vpl VALUES ("PS20_5","020_20_5","PSA","20","5","5","Munula nyuntu pikaringkula waintarinyangka kuliṟa pukuḻpa mulapa miraku. Munula Godanya mirawaṉira kuḻaṯa kuṯitji tjuṯinypa winkitjara pukuḻarira para-ngaṟaku. Uwa, nganaṉa mukuringanyi Godalu nyuntunya palula tjapinnyangka kulintjaku. ");
INSERT INTO pjt_vpl VALUES ("PS20_6","020_20_6","PSA","20","6","6","Uwa, kuwari nyangala nintiringulta, “Munta-uwa! Mulapa Mayatja Godalu kinga nyanga palunya pikaringkula waintarinytjaku palyaṉingi. Mulapa Godalu kulilpai paluṟu tjapinnyangka. Munu paluṟu ilkaṟinguṟu kuṉpu puḻkangku palunya wankaṟunanyi.” ");
INSERT INTO pjt_vpl VALUES ("PS20_7","020_20_7","PSA","20","7","8","Ngura kutjupitja tjuṯangku kulilpai alatji, “Nganaṉa wakina tjuṯatjara munu nyanytju tjuṯatjara. Palulanguṟula pikaringkula waintarinyi.” Palu wiya. Tjanaya punkalku puṯu waintarira. Ka nganaṉa tiṯutjara kuṉpu alatjiṯu ngaṟaku, panya nganaṉa Mayatja Godaku mulamularingkupai alatji kuliṟa, “Nganampa God Mayatja witulya puḻkanya.” ");
INSERT INTO pjt_vpl VALUES ("PS20_9","020_20_9","PSA","20","9","9","Uwa Mayatja, kinga nyanga palunya wankaṟunama, munulanya kulinma nyuntula tjapinnyangka. ");
INSERT INTO pjt_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","Mayatja nyuntu panyaṉin aṯunymaṟa wiṟuṟa kanyilpai. Panya wati tjapatangku tjiipi tjuṯa wiṟuṟa kanyilpai, palu puṟunytjuṉin nyuntu ngayunya aṯunymankupai. ");
INSERT INTO pjt_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Nyuntu ngayunya ngura wiṟungka kanyilpai, mai puḻkatjarangka ngalkula paḻtja nyinanytjaku. Munuṉin ngayunya mina wiṟukutu katipai tjikiṟa nyantulpa nyinanytjaku. ");
INSERT INTO pjt_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Ka panya ngayulu kurunpa uparingkunyangka nyuntu ngayunya kuṉpulpai. Munun ngayunya katiṟinkupai iwara tjukaṟurungka ngaṉmanytju kalkuntjatjanungku. ");
INSERT INTO pjt_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Tjinguṟu ngayuku tjituṟu-tjituṟu puḻka wirkankunyangkaṉa nguḻuringama ilunytjaku-tawara. Palu nyuntu ngayula tjungu nyinanyi, kaṉa palulanguṟu nguḻu wiya rapa ngaṟaku. Panya tjapatangku tjukaratjarangku tjiipi tjuṯa aṯunymankupai, palu puṟunytjun nyuntu ngayunya aṯunymaṟa kanyini. ");
INSERT INTO pjt_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Nyuntu panya ngayuku puḻkaṟa mulapa mukuringkupai. Munun ngayuku mai puḻka puṟunypa palyalpai ngayuku mukuringkula. Munutjun palu puṟunytjuṯu ngayuku walpayaṯangka tjaalyngaṟatjunkupai tiṯutjara ngarinytjaku. Palu ngayuku mirpaṉtju tjuṯaku nyuntu alatji palyalwiyangku wantipai. Uwa, nyuntu pukuḻtjungku ngayunya wiṟuṟa aṯunymankupai, kaṉa puḻkaṟa pukuḻaripai. ");
INSERT INTO pjt_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Mulapa ngayuku nyuntu tiṯutjara puḻkaṟa mukuringanyi, munun wiṟu kutju alatjiṯu ngayuku palyaṉi. Kaṉa nyuntula tjunguringkula tiṯutjara nyuntula kutju nyinaku mantangka nyanga wanka nyinaralpi. ");
INSERT INTO pjt_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","1","Mayatja God, ngayuluṉa purkaṟa paṯalpai nyuntu alpamilantjaku, Kaṉin nyuntu ulara tjapinnyangka kulilpai alatjiṯu. ");
INSERT INTO pjt_vpl VALUES ("PS40_2","020_40_2","PSA","40","2","2","Ngayuluṉa tjuḻpirpangka kaṟalukatingu ngaṯi puḻkangka mununa puṯu pakaṟa nguwanpa ilungu, kaṉi nyuntu mantjiṟa apu waḻungka tjunu wankaṟu rapa ngaṟanytjaku. ");
INSERT INTO pjt_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","Munuṉin nyuntu inma kuwaritja nintinu inkara nyuntunya waḻkuntjaku. Kaya aṉangu tjuṯangku nyuntu palyantja nyakula kulilku, “Munta-uwa, mulapa Godanya witulya puḻka nyinanyi.” Munuya palulanguṟu nyuntumpa mulamularingkuku. ");
INSERT INTO pjt_vpl VALUES ("PS40_4","020_40_4","PSA","40","4","4","Mayatja God, aṉangu panya nyuntumpa mulamularingkupai pukuḻpa mulapa nyinaku. Aṉangu nyanga palu puṟunypa panya kaṉany-kaṉanypa nyinapai tjuṯangka puṯu tjunguringkupai. Munu palumpa tjanampa god ngalypa-ngalypa tjuṯa tjunguringkula waḻkulpai wiya. ");
INSERT INTO pjt_vpl VALUES ("PS40_5","020_40_5","PSA","40","5","5","Mayatja God, nyuntu puḻka mulapa nganampa palyaṉu kutjupa kutjupa wiṟu tjuṯa. Ka nyanga palu puṟunypa kutjupangku puṯu alatjiṯu palyalpai. Ka panyan piṟuku wiṟu tjuṯa palyantjikitjangku kalkuṉu. Uwa nyuntu palyantja winki mulapa ngaṟanyi, kaṉa puṯu nguwanpa uwankara tjakultjunkuku nyuntu panya palyantjitja tjuṯa. ");
INSERT INTO pjt_vpl VALUES ("PS40_6","020_40_6","PSA","40","6","6","Tjinguṟuṉa puluka munu tjiipi ngalya-katira pungkula tiliwakaṟa nyuntunya ungama ngayuku kalyparingkunytjaku, palu nyuntu mukuringkunytja wiya ngayulu nyanga alatji palyantjaku. Panya nyuntu ngayunya pina palyaṉu nyuntunya wangaṉarangku kulintjaku. ");
INSERT INTO pjt_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","7","Kaṉa nyuntula wangkangu, “Nyangatjaṉa ngayulu pitjangu, panya iriti nyuntu nyiri miḻmiḻṯa walkatjunu tjukurpa ngayunyatjara. ");
INSERT INTO pjt_vpl VALUES ("PS40_8","020_40_8","PSA","40","8","8","Uwa Mayatja God, ngayuluṉatju puḻkaṟa pukuḻaripai nyuntu mukuringkunytjitja tjuṯa palyantjikitja, panya ngayuluṉa nyuntumpa tjukurpa kurunpa winkingku tiṯutjarangku kulilpai.” ");
INSERT INTO pjt_vpl VALUES ("PS40_9","020_40_9","PSA","40","9","9","Ka panya nyuntumpa walytja tjuṯa nyuntunya waḻkuntjikitja tjunguringangi, kaṉa tjanala tjakultjunangi panya nyuntu palyantja uwankara tjukaṟuru alatjiṯu. Nyuntu ninti Mayatja, panya ngayulu nyuntunyatjara rawangku wangkapai wantinytja wiyangku. ");
INSERT INTO pjt_vpl VALUES ("PS40_10","020_40_10","PSA","40","10","10","Ngayuluṉa aṉangu tjuṯangka tjakultjunangi panya nyuntu ngayunya mulapa alatjiṯu wankaṟunu. Alatjiṉa tjanala wangkangi, “Nganampa mayatjangku nganaṉanya ngaḻṯunytjungku kanyilpai tiṯutjarangku. Panya paluṟu kalkuntjatjanungku palyalpai alatjiṯu.” ");
INSERT INTO pjt_vpl VALUES ("PS40_11","020_40_11","PSA","40","11","11","Mayatja God, wanyutju tiṯutjara ngaḻṯunytju ngaṟama. Munuṉi wankaṟu kanyinma panya nyuntun tiṯutjarangku mukulyangku aṯunymankupai, munu panyan kalkuntjatjanungku palyalpai alatjiṯu. ");
INSERT INTO pjt_vpl VALUES ("PS40_12","020_40_12","PSA","40","12","12","Kura winki mulapa nyangatja ngayula utiringanyi munuṉi puuntananyi. Kaṉa puṯu alatjiṯu kulini. Ngayuluṉa kura tjuṯa mulapa palyaṉu, munuṉa kuwari puṯu nyanganyi iwara palyangka ankunytjikitjangku. Kuwariṉa uparingkula rapa ngaṟanytja wiyaringu. ");
INSERT INTO pjt_vpl VALUES ("PS40_13","020_40_13","PSA","40","13","13","Mayatja God, wanyuṉitju warpungkula pitjala ngayunya alpamilala wankaṟu nyinanytjaku. ");
INSERT INTO pjt_vpl VALUES ("PS40_14","020_40_14","PSA","40","14","14","Aṉangu tjuṯangkuya ngayunya iluntankunytjikitjangku kulini, ka mayatja, wanyu tjananya painma kaya kuṉṯaringkula anama alatjiṯu. ");
INSERT INTO pjt_vpl VALUES ("PS40_15","020_40_15","PSA","40","15","15","Paluṟu tjana panya ngayunya kuraṟa pungangi munu ananingi. Ka wanyu mayatja, tjananya puḻkaṟa painma, kaya kuṉṯaringkula wangkama, “Munta, kurangkula palunya kuraṟa pungangi.” ");
INSERT INTO pjt_vpl VALUES ("PS40_16","020_40_16","PSA","40","16","16","Kuwariṉa nyuntula tjapini aṉangu panya nyuntunya waḻkulpai tjuṯaku, paluṟu tjana nyuntumpa puḻkaṟa pukuḻarinytjaku, panya nyuntun palunya tjananya wankaṟunkunytjanguṟu. Wankaṟunkunytja nyara palulanguṟu tjana uti tiṯutjarangku mirawaṉira alatji wangkama, “Mayatja Godanya puḻka mulapa.” ");
INSERT INTO pjt_vpl VALUES ("PS40_17","020_40_17","PSA","40","17","17","Ngayulu ngaḻṯutjara, munuṉa kurunpa uparingu. Palu Mayatja God, wanyuṉitju tiṯutjarangku kulinma, munuṉin wankaṟuṟa aṯunymaṟa mukulyangku kanyinma. Wanyuṉitju warpungkula pitjala alpamilala! ");
INSERT INTO pjt_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","Godanya nganampa ngalkilpa nyinanyi kuṉpu puḻka. Munu nganampa tjituṟu-tjituṟu kura puḻka wirkankunyangka paluṟu ilaṯu ngaṟapai nganaṉanya kurunpa rapantjikitja. ");
INSERT INTO pjt_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","3","Palulanguṟu nganaṉa nguḻu wiya nyinapai, panya Godalulanya aṯunytju kanyini manta urinyangka, munu puḻi murpu puḻka tjuṯa kaṯakatira uṟungka tjarpanyangka. Munula uṟu wiṯatjara waḻpatjara kuḻu puḻkaṟa rurkunnyangka nganaṉa nguḻu wiyaṯu nyinapai. ");
INSERT INTO pjt_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","Palu ngura wiṟunya nyaratja ngaṟanyi Jerusalemanya aṉangu tjuṯa pukuḻpa nyinanytjaku ngura karu uṟu wiṟutjarangka. Ngura nyara palula panya Godanya nyinapai. Paluṟu mayatja puḻka mulapa uwankarangka waintarinytja. ");
INSERT INTO pjt_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","Ka kutjupangku puṯu wiyaṉi ngura nyara palunya, panya Godanya nyinanyi nyara palula, munu paluṟu tiṯutjarangku aṯunymankupai palumpa walytja tjuṯa. ");
INSERT INTO pjt_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","Ngura kutjupangka kutjupangka tjanayanku pikangku punganyi, munu aṉangu kutjupa tjuṯa nguḻutjingaṉi. Palu Godalu mirara wangkanyangka manta kaṯakatira minya-minyaringkuku. ");
INSERT INTO pjt_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","Mayatjanya puḻka mulapa nganaṉala tjungu nyinanyi. Paluṟu nganampa tjamu Jacobaku mayatja, munulanya aṯunymaṟa kanyilpai. ");
INSERT INTO pjt_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","Pitjalaya nyawa Mayatja Godalu palyantja puḻka mulapa manta winkingka. ");
INSERT INTO pjt_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","Paluṟu ngura winkingka pikangku pungkunyangka pilunmankupai, munu kuḻaṯa tjuṯa kaṯantaṟa wiyalpai, munu waṟungka kutjalpai kuṯitji tjuṯa. ");
INSERT INTO pjt_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","Munu paluṟu wangkapai, “Wiyariwaya munu pilunarira kulila ngayunya, panya ngayulu kutju God Mayatja Puḻkanya uwankarangka waintarinytja manta winkingka.” ");
INSERT INTO pjt_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","Uwa, God Mayatja Puḻkanya nganaṉala tjungu nyinanyi. Paluṟu nganampa tjamu Jacobaku mayatja, munulanya aṯunymaṟa kanyilpai. ");
INSERT INTO pjt_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","Mayatja God, nyuntu panyan tiṯutjara ngayuku puḻkaṟa mukuringkupai wiyaringkunytja wiya. Nyanga palulanguṟuṉi ngaḻṯunytjungku wiṟuṟa kanyinma. Panya nyuntula kuliṟa wantiraṉa kura puḻka palyaṉu, katju wanyu ngaḻṯuringkula ngayunya kalypangku wantima kura palyantjitjanguṟu pungkunytja wiyangku. ");
INSERT INTO pjt_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Panya kutjupa-aṟaṉa walytjangku kuliṟa kura mukuringkula palyalpai. Munuṉa kutjupa-aṟa watarkungku palyalpai palya-palku kuliṟa. Kaṉi kura nyanga uwankaranguṟu ngayunya pungkunytja wiyangku wantima. ");
INSERT INTO pjt_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Uwa, ngayuluṉatju kura palyantjatjanungku kuliṟa walytjangku ngurkantananyi, munuṉa nyuntula kuliṟa wantinytjatjanungku rawangku kulilpai munuṉa tjituṟu-tjituṟuripai. ");
INSERT INTO pjt_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Mayatja, ngayulu panya kura palyaṟa nyuntunya puḻkaṟa kuraṉu, panya painuṉin, kaṉa kuliṟa wantira pampuṉu, kan ngayunya tjukaṟurungku kuranmananyi, munuṉin palya wiyaṉi. ");
INSERT INTO pjt_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Uwa, ngayulu iṯinguṟu alatjiṯu kura nyinangi. Panya kura alatjiṯuṉi ngunytjungku tjuningka kanyiningi. ");
INSERT INTO pjt_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Ka nyuntu panya mukuringanyi ngayulu tjukaṟurungku unngu kulintjaku. Palulanguṟuṉi wanyu ngayunya unngu nintila nyuntu kulintjitja tjuṯa, kaṉa kuliṟa nyuntu mukuringkunytja kutju wangaṉarangku palyalku. ");
INSERT INTO pjt_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Uwa, ngayulu kura palyantjitjanguṟuṉi kalypangku wantima munuṉi tjukaṟurunma. Kaṉa pala palulanguṟu palya mulapa nyinama. ");
INSERT INTO pjt_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Wanyuṉi tjakultjura nyuntu ngayunya kalypangku wantinytjatjanungku, kaṉa kuliṟa pukuḻari. Puḻkaṟaṉa kuṉṯaringu, panya kura puḻka mulapa nyuntu ngayula utinu. Kaṉi wanyu piṟuku pukuḻmanama kura nyanga palula tjanalanguṟu nyuntu ngayunya kalyapangku wantinytjatjanungku. ");
INSERT INTO pjt_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Uwa, nyuntu nintingku ngayunya nyangu kura palyannyangka. Palu nyakunytjatjanungku wanyu ngayunya kalypangku wantima pungkunytja wiyangku, munu kura nyanga uwankara ngayulu nyuntula tungunpungkula palyantjitjaku watarkurima rawangku kulintja wiya. ");
INSERT INTO pjt_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","Mayatja God, wanyuṉi kulintja kampa kutjupara, munuṉi tjukaṟurula nyuntula kutju wangaṉarangku kulintjaku. ");
INSERT INTO pjt_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Palu nyuntulanguṟuṉi paiṟa iyantja wiyangku wantima. Munu Kurunpa Miḻmiḻnga ngayulanguṟu mantjilwiyangku wantima, panya paluṟu ngayunya wankaṟu kanyini. ");
INSERT INTO pjt_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Panya ngaṉmanypaṉa pukuḻpa mulapa nyinangi nyuntu ngayula tjungu nyinara alpamilannyangka. Kaṉi wanyu maḻakungku pukuḻmanama panya ngaṉmanyitja puṟunypa nyinanytjaku. Munuṉi kuṉpula, kaṉa nyuntula kutjungka wangaṉarangku kulinma. ");
INSERT INTO pjt_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Alatji nyuntu ngayunya pukuḻmankunyangkaṉa tjakultjunkuku aṉangu panya nyuntunya wantipai tjuṯangka. Kaya ngayulu puṟunypaṯu tjana kuliṟa kuṉṯaringkuku munuya aṟuringkula pitjaku nyuntunya tjukaṟurungku waṉantjikitja. ");
INSERT INTO pjt_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","Mayatja God, nyuntu kutjungku ngayunya wankaṟunkuku. Panya ngayulu kurangku iluntanu, katju ngaḻṯuriwa munuṉi kalypangku wantima pungkuwiyangku. Kaṉa aṉangu tjuṯangka tjakultjura katungku mirara wangkara nyuntu ngayunya wiṟungku tjukaṟuruntja. ");
INSERT INTO pjt_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","Uwa Mayatja, ngayunya wangkanytjaku nintila, kaṉa nyuntunya mirawaṉira waḻkunma. ");
INSERT INTO pjt_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Tjinguṟuṉa ngayuku kuranguṟu kuka tjiipi katima pitjilta pungkula pauṟa muluruṟa ungkunytjikitjangku nyuntunya. Palu ngayulu ninti panya nyuntu pukuḻarinytja wiya kuka kutju pungkula ungkunyangka. ");
INSERT INTO pjt_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","Palu ngayulu kurunpa tjaṟuringkula piiwiyaringkunyangka kutju nyuntu ngayuku pukuḻariku. Munuṉi paiṟa iyantja wiyangku wantira kanyilku. ");
INSERT INTO pjt_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","Palu wanyu ngaḻṯuringkula alpamilala aṉangu nyanga Jerusalemala nyinanytja tjuṯa wall-pa para-ngaṟala waṉantja piṟuku palyantjaku panya ngaṉmanytju piḻuntankunytja. ");
INSERT INTO pjt_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Nyuntu tjinguṟu alatji alpamilannyangkaya nyuntumpa aṉangu tjuṯa tjukaṟuru nyinaku, munuya mulamulangku kuranguṟu piiwiyaringkula kuka katiku pungkula pauṟa muluruṟa ungkunytjikitjangku nyuntunya. Ka nyuntu palumpa tjanampa puḻkaṟa pukuḻariku. ");
INSERT INTO pjt_vpl VALUES ("PS61_1","020_61_1","PSA","61","1","1","God, kulinmaṉitju! Kuruntunanta ulara tjapini. Munuṉitju wanyu kuliṟa alpamilanma. ");
INSERT INTO pjt_vpl VALUES ("PS61_2","020_61_2","PSA","61","2","2","Ngura nyanga parari-nguṟuṉa nyuntula ulara ma-tjapini alpamilantjaku, panya ngayuluṉatju kuwari kurunpa wawanyarira uparingu. Nyuntu panyan puḻi puḻka puṟunytju angatjuṟa kanyilpai, kaṉi ngayunya wankaṟu anga-kanyinma. ");
INSERT INTO pjt_vpl VALUES ("PS61_3","020_61_3","PSA","61","3","3","Nyuntu panyaṉitjun mukulya wiṟungku mirpaṉtju tjuṯangka-tawara anga-kanyilpai. Panya wall-pa ngurangka para-arintaṟa ngaṟapai kuṉpu alatjiṯu mirpaṉtju tjuṯa tjarpanytjaku-tawara, palu puṟunytjuṉin rawangku anga-kanyilpai. ");
INSERT INTO pjt_vpl VALUES ("PS61_4","020_61_4","PSA","61","4","4","Wanyuṉitju tjunama nyuntumpa Tinta Miḻmiḻṯa unngu, kaṉa nyara palula tiṯutjara mulapa rapa nyinaku nyuntu anga-tjutuṟa kanyinnyangka, panya tjuḻpu ngunytjungku nyaḻpingka anga-tjutuṟa kanyilpai aṯunypa nyinanytjaku, palu puṟunytjuṉi aṯunymaṟa kanyinma. ");
INSERT INTO pjt_vpl VALUES ("PS61_5","020_61_5","PSA","61","5","5","God, nyuntuṉin kulinu ngayulu nyuntunya kalkunnyangka, munu panyaṉitjun wiṟungku kulintjatjanungku pukuḻmanu. Panya nyuntu aṉangu nyuntunya waḻkulpai uwankara kuliṟa pukuḻmankupai, palu puṟunypaṉin nyuntu ngayunya ngapartji pukuḻmanu. ");
INSERT INTO pjt_vpl VALUES ("PS61_6","020_61_6","PSA","61","6","6","God, ngayulu nyuntula tjapini nganampa kinga wanka kanyintjaku, paluṟu wanka rawa nyinanytjaku. Munu palula maḻangka palumpa tjitji maḻatja maḻatja tjuṯa kuḻu kingarinyangka kanyilkatima tiṯutjarangku alatjiṯu. ");
INSERT INTO pjt_vpl VALUES ("PS61_7","020_61_7","PSA","61","7","7","Uwa Mayatja God, nganampa kingangka tiṯutjara tjungu ngaṟama paluṟu aṉangu tjuṯa mayatjangku aṯunymaṟa wiṟuṟa kanyintjaku. Munu palunya mukulyangku wankaṟu kanyinma tiṯutjarangku, panya mulapa nyuntu wantinytja wiyangku kanyilpai alatjiṯu. ");
INSERT INTO pjt_vpl VALUES ("PS61_8","020_61_8","PSA","61","8","8","Kaṉanta ngayulu tiṯutjarangku nyuntunya inma inkara waḻkuṟa mirawaṉiku. Munuṉanta nyuntunya kalkuntjatjanungku rawangku palyalku, tjiṉṯu kutjupa tjiṉṯu kutjupa. ");
INSERT INTO pjt_vpl VALUES ("PS63_1","020_63_1","PSA","63","1","1","Ngayulu nyuntunya kuwari waḻkuṉi, panya nyuntu ngayuku God. Kaṉa ngayulu nyuntumpa puḻkaṟa mukuringanyi. Munuṉa kuwari nyuntunya-tjiratja kapi ilu puṟunytju nyinara nyuntunya rawangku puḻkaṟa kulini. Panya ailuru puḻkangka manta piḻṯiringkupai mina wiyangka, palu puṟunypa ngayulu kurunpa winki uḻiringkupai nyuntula wiyangka, panya ngayulu nyuntumpa puḻkaṟa alatjiṯu mukuringanyi. ");
INSERT INTO pjt_vpl VALUES ("PS63_2","020_63_2","PSA","63","2","2","Panya ngayulu nyuntunya nyangangi waḻi miḻmiḻṯa nyinanyangka, munuṉa nyangu nyuntunya witulya puḻkangku palyannyangka munu pitalytji puḻka alatjiṯu irnyannyangka. ");
INSERT INTO pjt_vpl VALUES ("PS63_3","020_63_3","PSA","63","3","3","Palu panya nyuntumpa mukulya puḻka mulapa rawa alatjiṯu ngaṟanyi wanka nyanga mantatjangka waintaṟa mulapa, kaṉa palulanguṟu nyanga kuwari nyuntunya inkara waḻkuṉi. ");
INSERT INTO pjt_vpl VALUES ("PS63_4","020_63_4","PSA","63","4","4","Munuṉa nyanga alatji kulini, “Utiṉa wanka nyanga nyinaralpi nyuntunya tiṯutjarangku waḻkunma, munuṉa nyuntunya ini wangkara maṟa katuringkula waḻkuṟa tjapinma. ");
INSERT INTO pjt_vpl VALUES ("PS63_5","020_63_5","PSA","63","5","5","Munuṉa uti kurunpa winki puḻkaṟa pukuḻarima, panya mai wiṟu ngalkuntjatjanuṉa paḻtjaringkula pukuḻaripai, palu puṟunypa. Uwa, utiṉa inma tjuṯa pukuḻṯu inkara nyuntunya puḻkaṟa mirawaṉima.” ");
INSERT INTO pjt_vpl VALUES ("PS63_6","020_63_6","PSA","63","6","6","Panya ngayulaṉa mungangka ngarikatira nyuntunya rawangku kulilpai, munuṉanta kuliṟa alatjiṯu tjiṉṯuringkupai. ");
INSERT INTO pjt_vpl VALUES ("PS63_7","020_63_7","PSA","63","7","7","Panya nyuntu kutjungkun ngayunya tiṯutjarangku alpamilalpai, kaṉa palulanguṟu nyuntumpa inma tjuṯa pukuḻṯu inkara kulilpai, panya nyuntu ngayula tjungu alatjiṯu nyinanyangka. ");
INSERT INTO pjt_vpl VALUES ("PS63_8","020_63_8","PSA","63","8","8","Uwa, panya ngayulu nyuntumpa puḻkaṟa mukuringkula nyuntula tjungu alatjiṯu nyinaku wantinytja wiya, kaṉin nyuntu wiṟungku witulya puḻkangku alatjiṯu aṯunytju kanyini. ");
INSERT INTO pjt_vpl VALUES ("PS63_9","020_63_9","PSA","63","9","10","Panya kuwariṉiya tjana ngayunya ngurini iluntankunytjikitjangku, kaṉa mukuringanyi nyuntu palunya tjananya wiyantjaku. Panya palunya tjananyaya kuwari pika puḻkangka pungkula iluntankuku, ka inuṟa tjuṯangku tjananya pitjala ngalkuku. Kaya paluṟu tjana miri tjuṯaku ngurangka tjarpara tiṯutjara alatjiṯu nyinaku. ");
INSERT INTO pjt_vpl VALUES ("PS63_11","020_63_11","PSA","63","11","11","Uwa, panya Godalu ngayunya mulapa Israelku mayatja witulyanu warmaḻa tjuṯa pungkula waintarinytjaku, kaṉa palulanguṟu palumpa puḻkaṟa pukuḻarinyi. Kaya aṉangu tjuṯangku panya Godala miṟangka wangkara kalkuntjatjanungku palunya puḻkaṟa mirawaṉiku. Palu panya aṉangu ngunti wangkapai tjuṯa Godalu tjaa patilku. ");
INSERT INTO pjt_vpl VALUES ("PS91_1","020_91_1","PSA","91","1","1","Uti nyuntu Mayatja Godala tjungu nyinama Witulya Puḻkangka, kanta paluṟu nyuntunya tiṯutjarangku aṯunymaṟa kanyilku. ");
INSERT INTO pjt_vpl VALUES ("PS91_2","020_91_2","PSA","91","2","2","Ka nyuntu nyanga palunya kuliṟa nyanga alatji palula wangkaku, “Wiṟungkuṉin ngayunya aṯunymaṟa kanyilpai munuṉin kuṯitji puṟunytju angatjuṟa kanyilpai, ngayuku ngalkiltu, kaṉa ngayulu puḻkaṟa mulamularingkula nyuntunya waḻkulpai.” ");
INSERT INTO pjt_vpl VALUES ("PS91_3","020_91_3","PSA","91","3","3","Ka paluṟu nyuntunya aṯunymankuku kutjupangku nyuntunya ngunti kurantjaku-tawara, munu paluṟu nyuntunya wankaṟu kanyilku pikatjararingkula ilunytjaku-tawara. ");
INSERT INTO pjt_vpl VALUES ("PS91_4","020_91_4","PSA","91","4","4","Uwa, paluṟunta wiṟuṟa kanyilku, panya tjuḻpungku kuḻunypa tjuṯa nyaḻpingka unngu angatjuṟa kanyilpai, palu puṟunytjunta angatjunkula kanyilku, kan nguḻu wiya rapa alatjiṯu nyinaku paluṟu aṯunymankunyangka. ");
INSERT INTO pjt_vpl VALUES ("PS91_5","020_91_5","PSA","91","5","5","Munun mungangka kura kutjupa kutjupa nyuntula utiringkunyangka nyakula nguḻuringkunytja wiya nyinaku, munun kaḻaḻa kuḻu kutjupangku kuḻaṯa waṉinyangka nyakula nyuntu nguḻuringkunytja wiyaṯu, rapa alatjiṯu ngaṟaku. ");
INSERT INTO pjt_vpl VALUES ("PS91_6","020_91_6","PSA","91","6","6","Munun mamu panya kura mungangka para-ngaṟapai tjuṯaku nguḻuringkunytja wiya rapa nyinaku, munun kaḻaḻa kuḻu tjana iluntankunyangka nyakula nyuntu nguḻuringkunytja wiyaṯu ngaṟaku. ");
INSERT INTO pjt_vpl VALUES ("PS91_7","020_91_7","PSA","91","7","7","Ka nyuntula itingka aṉangu tjuṯa mulapa pikatjararingkula iluku, palu Godalu nyuntunya aṯunymaṟa kanyinnyangka nyuntu pikatjararingkunytja wiya palya alatjiṯu nyinaku. ");
INSERT INTO pjt_vpl VALUES ("PS91_8","020_91_8","PSA","91","8","8","Munu nyuntu kuṟu aḻaringkula nyakuku Godalu aṉangu kura palyalpai tjuṯa pungkunyangka. ");
INSERT INTO pjt_vpl VALUES ("PS91_9","020_91_9","PSA","91","9","9","Munu nyuntu rapangku kulilku, “Mayatjaluṉi ngayunya aṯunymaṟa kanyini katutja puḻkangku.” ");
INSERT INTO pjt_vpl VALUES ("PS91_10","020_91_10","PSA","91","10","10","Ka nyara palulanguṟu kura kutjupa kutjupa nyuntula wirkankunytja wiya ngaṟaku. ");
INSERT INTO pjt_vpl VALUES ("PS91_11","020_91_11","PSA","91","11","11","Panya Godalu witulku palumpa angelpa tjuṯa nyuntunya aṯunymaṟa kanyintjaku kaḻaḻa mungangka kuḻu, munu nyinanyangka ankunyangka kuḻu. ");
INSERT INTO pjt_vpl VALUES ("PS91_12","020_91_12","PSA","91","12","12","Munuya nyara paluṟu tjana nyuntunya maṟangku katuṟa kanyilku punkaṟa apungka tjina kaṯakatinytjaku-tawara. ");
INSERT INTO pjt_vpl VALUES ("PS91_13","020_91_13","PSA","91","13","13","Ka nyuntu lion pikaṯi tjuṯangka liru tjuṯangka kuḻu nguṟurpa rapa para-ngaṟaku, kaya nyuntunya patjantja wiyangku wantiku. ");
INSERT INTO pjt_vpl VALUES ("PS91_14","020_91_14","PSA","91","14","14","Panya Godalu wangkanyi nyanga alatji, “Nyuntu ngayuku puḻkaṟa mukuringkunyangkaṉa nyuntunya wankaṟunkuku, munuṉanta nyuntunya aṯunytju kanyilku nyuntu ngayuku mulamularingkunyangka. ");
INSERT INTO pjt_vpl VALUES ("PS91_15","020_91_15","PSA","91","15","15","Palu kura kutjupa kutjupa nyuntula utiringkunyangkampa ngayunya aḻṯi, kaṉa ngayulu kuliṟa nyuntula tjunguringkula nyuntunya wankaṟunkuku, kaya aṉangu kutjupa tjuṯangku nyuntunya wankaṟunkunyangka nyakula wangkaku, ‘Ai, wati nyangatja wiṟu mulapa.’ ");
INSERT INTO pjt_vpl VALUES ("PS91_16","020_91_16","PSA","91","16","16","Uwa, nyuntu ngayula tjungu nyinanyangkaṉa ngayulu nyuntunya wankaṟu kanyilku, ka nyuntu manta nyangangka rawa wanka nyinaku munun ngula tjiḻpiringkula kutju iluku.” ");
INSERT INTO pjt_vpl VALUES ("PS121_1","020_121_1","PSA","121","1","1","Inma nyangatjaya Jerusalemalakutu ankula inkakatipai. Nganaluṉitju alpamilalku? Tjinguṟuṉa murpu nyara puḻkanya ira-nyakula tjapilku, panya paluṟu tjana tiṯutjara kuṉpu ngaṟala iritiringu. Tjinguṟuṉi paluṟu tjana ngayunya alpamilalku. Palu wiyampal nyangatja. Wiya alatjiṯu. ");
INSERT INTO pjt_vpl VALUES ("PS121_2","020_121_2","PSA","121","2","2","Panya Mayatja Godaluṉitju ngayunya alpamilalku, panya paluṟu kutjupa kutjupa uwankara palyaṉu murpu tjuṯa kuḻu. ");
INSERT INTO pjt_vpl VALUES ("PS121_3","020_121_3","PSA","121","3","4","Uwa mulapa Mayatjalu uwankara rawangku kanyilpai pakuringkula kunkunarinytja wiyangku. Munulanya aṯunymankupai punkantjaku-tawara. Uwa, paluṟu nganaṉanya Israelkunu tjuṯa kunkunpa wiyangku aṯunymankupai. ");
INSERT INTO pjt_vpl VALUES ("PS121_5","020_121_5","PSA","121","5","6","Mayatjalulanya anga-kanyilpai panya puṉu wiltja puḻkuṉpa wiṟu ngaṟapai kalanya tjiṉṯungku puṯu kampapai, palu puṟunytju. Munu paluṟu mungangka kuḻu anga-kanyilpai kinaṟa panya wiya ngaṟanyangka. ");
INSERT INTO pjt_vpl VALUES ("PS121_7","020_121_7","PSA","121","7","7","Ka Mayatja Godalulanya aṯunymaṟa kanyini panya kutjupa kutjupa uwankarangku kurantjaku-tawara. Uwa mulapa nyangatjalanya aṯunymananyi wankaṟu nyinanytjaku. ");
INSERT INTO pjt_vpl VALUES ("PS121_8","020_121_8","PSA","121","8","8","Panya paluṟulanya tiṯutjarangku ilangku nyakula kanyini ngurangka nyinanyangka munu ngura parari ankunyangka kuḻu. Munulanya tiṯutjarangku alatjiṯu aṯunytju kanyiṟa iritiriku. ");
INSERT INTO pjt_vpl VALUES ("PS131_1","020_131_1","PSA","131","1","1","Mayatja, ngayulu nyuntumpa kutjuku puḻkaṟa mulamularinganyi. Munuṉatju walytjangku ngayulu kaṉany-kaṉanytju puḻkanmankupai wiya. Nyuntu panya puḻka mulapa palyalpai, kaṉa puṯu kulilpai. Tjinguṟuṉa arkaṟampa puṯu palyanma, panya nyuntu kutjungku nyanga puṟunypa palyalpai nintingku. ");
INSERT INTO pjt_vpl VALUES ("PS131_2","020_131_2","PSA","131","2","2","Uwa, puṯuṉa kulilpai. Palu palya, kurunpaṉi pukuḻpaṯu ngaṟanyi tjitji tjukutjuku puṟunypa, panya ngunytjungku ampuṟa kanyinnyangka pilunpa ngaripai, palu puṟunypa. ");
INSERT INTO pjt_vpl VALUES ("PS131_3","020_131_3","PSA","131","3","3","Ka nyura Israelkunu tjuṯa Mayatja Godaku kutjuku mulamularingama. Munuya tiṯutjarangku palunya kutju mulamulangku kulinma. ");
INSERT INTO pjt_vpl VALUES ("PS133_1","020_133_1","PSA","133","1","1","Aṉangu tjuṯa kutjuringkula tjungu pukuḻpa nyinanyangka nyakula nganaṉa kulilpai, “Awari, nyangatja wiṟu mulapa. Godalu-manti nganaṉanya aṉangu uwankara tjunguṟa pukuḻmananyi.” ");
INSERT INTO pjt_vpl VALUES ("PS133_2","020_133_2","PSA","133","2","2","Panya Godalu palumpa aṉangu tjuṯa pukuḻmankunytjikitjangku wangkangu tjananya tjukurtjara puḻka palumpa tjunkunytjaku Aaronnga panya. Munu wangkangu tjananya, “Uwila wiṟu mulapa miḻmiḻpa palula katangka tjukutjuku tjutila paluṟu tjukurtjara puḻka kuranyitja nyinanytjaku.” Kaya mulapaṯu Aaronta katangka uwila tjutinu, palu puḻka nguwanpaya tjutinu, ka katanguṟu ukalingkula ngaṉkurpawanu tjutingu piningka. Alatji Godalu Aaronnga tjananya puḻkaṟa pukuḻmanu, munu palu puṟunypaṯu Godalu palumpa walytja uwankara puḻkaṟa pukuḻmankupai. ");
INSERT INTO pjt_vpl VALUES ("PS133_3","020_133_3","PSA","133","3","3","Uwa, aṉangu tjuṯa tjungu pukuḻpa nyinanyangkala kulini panya Godalu mulapa pukuḻmananyi palumpa walytja tjuṯa, minangku puyintja puṟunypa. Panya mina puḻkangku ngura ailurungka puyiṟa puṉu ukiṟi wiṟu pakaltjingalpai, palu puṟunypa Godalu pukuḻmankupai palumpa walytja uwankara. Panya Mayatja Godalu wiṟu palyantjikitjangku wangkangu palumpa walytja Jerusalemala nyinanytja tjuṯaku, kaya ngura nyara palula tiṯutjara mulapa nyinaku. ");
INSERT INTO pjt_vpl VALUES ("PS136_1","020_136_1","PSA","136","1","1","Mayatja Godanyala waḻkunma, panya paluṟu wiṟu mulapa. ");
INSERT INTO pjt_vpl VALUES ("PS136_2","020_136_2","PSA","136","2","2","Paluṟu kutju god puḻka mulapa kutjupa uwankarangka waintaṟa alatjiṯu. Kala palunya kutju waḻkunma. ");
INSERT INTO pjt_vpl VALUES ("PS136_3","020_136_3","PSA","136","3","3","Paluṟu kutju mayatja puḻka mulapa mayatja kutjupa uwankarangka waintaṟa. Kala palunya kutju waḻkunma. ");
INSERT INTO pjt_vpl VALUES ("PS136_4","020_136_4","PSA","136","4","4","Paluṟu kutjungku kutjupa kutjupa puḻka mulapa palyalpai witulya puḻkangku. ");
INSERT INTO pjt_vpl VALUES ("PS136_5","020_136_5","PSA","136","5","5","Paluṟu nintipuka mulapa munu palulanguṟu nintingku ilkaṟi paluṟa kutjupa kutjupa tjuṯa tjunu. ");
INSERT INTO pjt_vpl VALUES ("PS136_6","020_136_6","PSA","136","6","6","Paluṟu manta lipiṟa tjunu uṟungka katu. ");
INSERT INTO pjt_vpl VALUES ("PS136_7","020_136_7","PSA","136","7","9","Paluṟu paluṉu tjiṉṯu munu piṟa, munu tjiṉṯu tjunu kaḻaḻa irnyantjaku, munu piṟa kililpi tjunu mungangka irnyantjaku. ");
INSERT INTO pjt_vpl VALUES ("PS136_10","020_136_10","PSA","136","10","12","Paluṟu Itjipanya nguraṟa tjuṯaku katja ngaṉmanyitja tjuṯa iluntanu. Munu paluṟu Israelkunu tjuṯa witulya puḻkangku pakaltjingaṟa katingu ngura Itjipalanguṟu. ");
INSERT INTO pjt_vpl VALUES ("PS136_13","020_136_13","PSA","136","13","15","Paluṟu uṟu ini Tjuṉa-tjuṉatjaranya tjaraṉu Israelkunu tjuṯa itipirinytjaku, munu tjananya nguṟurwanungku katingu. Munu paluṟu uṟungka iluntanu Piiṟanya tjananya warmaḻa winki. ");
INSERT INTO pjt_vpl VALUES ("PS136_16","020_136_16","PSA","136","16","22","Paluṟu katiṟinangi aṉangu tjuṯa ilytjiwanungku. Munu paluṟu pungangi mayatja puḻka tjuṯa. Paluṟu iluntanu aṉangu Amurkunu tjuṯaku mayatja ini Tjiyannga. Munu piṟuku pungu aṉangu Patjanta nyinapai tjuṯaku mayatja ini Akanya. Munu tjanampa manta tjananya ungu palumpa walytja tjuṯa Israelkunu tjuṯa. ");
INSERT INTO pjt_vpl VALUES ("PS136_23","020_136_23","PSA","136","23","24","Kutjupa-aṟa warmaḻangku nganaṉanya pauntjingaṟa pungangi, kala puḻkaṟa tjituṟu-tjituṟuringi. Palu paluṟu nintingku nganaṉanya nyangangi watarkurinytja wiyangku, munulanya walatjunu mirpaṉtju tjuṯanguṟu. ");
INSERT INTO pjt_vpl VALUES ("PS136_25","020_136_25","PSA","136","25","25","Paluṟu kutjungku aṉangu tjuṯa, kuka mantatja uṟutja tjuṯa kuḻu uwankara paḻtjalpai. ");
INSERT INTO pjt_vpl VALUES ("PS136_26","020_136_26","PSA","136","26","26","Waḻkunmala pukuḻarira Mayatja Godanya ilkaṟingka nyinapainya. ");
INSERT INTO pjt_vpl VALUES ("PS146_1","020_146_1","PSA","146","1","1","Waḻkunmala Mayatjanya kurunpa winkingku. ");
INSERT INTO pjt_vpl VALUES ("PS146_2","020_146_2","PSA","146","2","2","Munula palunya kutju inkara mirawaṉima tiṯutjarangku mantangka nyanga wanka nyinaralpi. ");
INSERT INTO pjt_vpl VALUES ("PS146_3","020_146_3","PSA","146","3","3","Munula mayatja mantatja tjuṯaku mulamularingkuwiyangku wantima, panya tjana aṉangu tjuṯa puṯu tjukaṟurungku aṯunymaṟa kanyilpai. ");
INSERT INTO pjt_vpl VALUES ("PS146_4","020_146_4","PSA","146","4","4","Mayatja panya paluṟu tjana unytju nyinanytjatjanu ilura maḻaku mantaringanyi. Ka tjiṉṯu nyara palula tjana palyantjikitjangku wangkara kulintja uwankara kuḻu wiyaringkuku palyantja wiyaṯu. ");
INSERT INTO pjt_vpl VALUES ("PS146_5","020_146_5","PSA","146","5","5","Mayatja Godanya nganampa tjamu tjuṯaku, mayatja Jacobaku tjanampa, munu nganampa kuḻu. Ka nganaṉa palunya kuliṟa mulamularingkunyangka paluṟu nganaṉanya alpamilalku. Nyara palulanguṟu kutju nganaṉa pukuḻpa nyinaku. ");
INSERT INTO pjt_vpl VALUES ("PS146_6","020_146_6","PSA","146","6","6","Panya paluṟu ilkaṟi manta uṟu kuḻu paluṉu munu mai kuka kutjupa kutjupa uwankara kuḻu paluṉu. Munu paluṟu kalkuntjatjanungku palyalpai alatjiṯu. ");
INSERT INTO pjt_vpl VALUES ("PS146_7","020_146_7","PSA","146","7","7","Munu ngaḻṯutjara tjuṯa ngunti kurannyangka nyakula paluṟu tjukaṟurungku ngurkantankupai munu tjananya aṯunymankupai. Paluṟu paḻtjatjiratja nyinanyangka tjananya paḻtjalpai. Munu kuranguṟu puḻkaṟa kuliṟa tjituṟu-tjituṟurinyangka nyakula ngaḻṯunytjungku alpamilaṟa unngu pukuḻmankupai. Panya tjailangka nyinanyangka mayatjangku wangkara walatjunkupai, palu puṟunypa Mayatja Godalu nyakula alpamilalpai. ");
INSERT INTO pjt_vpl VALUES ("PS146_8","020_146_8","PSA","146","8","8","Munu paluṟu kuṟu pati aḻalpai munu tjaṟuringkula punkannyangka piṟuku pakaltjingaṟa kuṉpulpai. Mayatja Godanya tjukaṟuru nyinapai tjuṯaku mukuringanyi. ");
INSERT INTO pjt_vpl VALUES ("PS146_9","020_146_9","PSA","146","9","9","Godalu malikitja tjuṯa aṯunymankupai ngura kutjupanguṟu pitjala nganampa ngurangka nyinanyangka, munu wanakaḻa tjiṯula tjuṯa kuḻu aṯunymankupai. Palu aṉangu tjuṯangku tiṯutjarangku kura kutju palyannyangka Godalu paiṟa iyalpai walytjangku kuliṟa kuraringkula ilunytjaku. ");
INSERT INTO pjt_vpl VALUES ("PS146_10","020_146_10","PSA","146","10","10","Uwa, mulapa Israelkunu tjuṯaku God kutju mayatja puḻka mulapa tiṯutjara nyinaku. Kala palunya kutju waḻkunma Mayatja puḻkanya. ");
INSERT INTO pjt_vpl VALUES ("PR1_1","021_1_1","PRO","1","1","1","Tjukurpa nyanganpa Israelku mayatjangku walkatjunu panya Davidaku katjangku wati ini Tjalamantu. ");
INSERT INTO pjt_vpl VALUES ("PR1_2","021_1_2","PRO","1","2","2","Ka tjukurpa nyanga paluṟu tjana nyuranya nintini kuliṟa ninti puḻkaringkunytjaku, ka nyura nintiringkunytjatjanungku tjukurpa kumpilpa ngaṟanytja tjuṯalta uti kulilku munu kuliṟa wangaṉarangkulta palyalku. Munu palulanguṟu kutjupa tjuṯangku nyurala wangkara nintinnyangka nyura nintingku tjukaṟurungku kulilku. ");
INSERT INTO pjt_vpl VALUES ("PR1_3","021_1_3","PRO","1","3","3","Munu nyura tjukurpa nyanga palumpa tjanampa nintiringkunytjatjanungku kulilku palyanyku nyinanytjikitjangku. Munu nyura kulilku aṉangu uwankaraku palu puṟunytjuṯu tjukaṟurungku palyantjikitjangku kutjupa tjuṯaku kuḻu. ");
INSERT INTO pjt_vpl VALUES ("PR1_4","021_1_4","PRO","1","4","4","Uwa, tjukurpa nyanga palula tjanalanguṟu aṉangu ngurpa-ngurpa tjuṯa nintiringkuku ninti puḻka nyinanytjikitja. Ka wati yangupala kungkawaṟa tjuṯa kuḻu nintiringkuku, munuya palulanguṟu nintiringkunytjatjanungku kuliṟa tjukaṟurungku ngurkantankuku palyanyku nyinanytjikitjangku. ");
INSERT INTO pjt_vpl VALUES ("PR1_5","021_1_5","PRO","1","5","5","Kaya uti aṉangu nintipuka tjuṯangku kuḻu tjukurpa nyanganpa kuliṟa nintiringama munuya nyara palulanguṟu ninti puḻka mularariku. Panya tjana tjukaṟurungku palyantjikitja mukuringkula tjukurpa nyanganpa kuliṟampa tjukaṟurungku ngurkantankuku. ");
INSERT INTO pjt_vpl VALUES ("PR1_6","021_1_6","PRO","1","6","6","Munu aṉangu nintipukangku tjanala tjukurpa aṟa kutjupatjara wangkanyangka tjana uti kulilku. ");
INSERT INTO pjt_vpl VALUES ("PR1_7","021_1_7","PRO","1","7","7","Palu kulilaya! Nyura ninti puḻkaringkunytjikitja mukuringkula Mayatja Godanya-waraṟa waḻkunma munuya palula wangaṉarangku kulinma. Nyara palulanguṟu kutju nyura ninti puḻkaringkuku. Palu panya aṉangu kawakawa tjuṯa ninti puḻkaringkunytjikitja mukuringkunytja wiya munuya kuraringkupai kutjupangku tjananya nintinnyangka. ");
INSERT INTO pjt_vpl VALUES ("PR3_11","021_3_11","PRO","3","11","11","Kulila! Mayatja Godalu nyuntunya tjitji puṟunypa tjukaṟurulpai palulawanu nyinanytjaku, kan uti palula wangaṉarangku kulinma panya paluṟu nyuntunya ngunti palyannyangka pailpai. Uti nyuntu kuranguṟu painnyangka kuliṟa tjituṟu-tjituṟurinytja wiyangku wantima. ");
INSERT INTO pjt_vpl VALUES ("PR3_12","021_3_12","PRO","3","12","12","Panya paluṟu puḻkaṟa mukuringkupai palumpa katja uṉṯalpa tjuṯaku, munu pala palulanguṟu tjananya tjukaṟurulpai munu kuraringkunyangka tjananya pungkupai tjana tjukaṟuru nyinanytja-tjiratjangku. ");
INSERT INTO pjt_vpl VALUES ("PR11_1","021_11_1","PRO","11","1","1","Nyura aṉangu kutjupangka kutjupa kutjupa ngunti tjalamilannyangka Godanya puḻkaṟa mirpaṉaripai, palu paluṟu pukuḻaripai nyura tjukaṟurungku tjalamilannyangka mani nampa ngunti katuntja wiyangku. ");
INSERT INTO pjt_vpl VALUES ("PR12_1","021_12_1","PRO","12","1","1","Tjinguṟu kutjupangku nyuranya wangkara tjukaṟurunnyangka kulintjatjanu nyura ninti puḻka nyinama, palu tjinguṟu nyura kulintja wiyangku wantirampa kawakawa alatjiṯu nyinaku. ");
INSERT INTO pjt_vpl VALUES ("PR19_18","021_19_18","PRO","19","18","18","Tjitji tjuṯaya kura palyannyangka nyakula wangkara tjukaṟurunma paluṟu tjana nintiringkula palya nyinanytjaku. Palu nyura tjukaṟuruntja wiyangku wantirampa nyura alatjiṯu tjananya wantir'iyaṉi tjana puṯu kuliṟa ma-kuraringkunytjaku munu ilunytjaku. ");
INSERT INTO pjt_vpl VALUES ("PR20_1","021_20_1","PRO","20","1","1","Aṉangu wama tjikiṟa taṟangkarira kawakawaringkupai munu puḻkaṟa mirpaṉarira aṉangu tjuṯa kuralpai alatjiṯu. Kaya palula-tawara wama tjikiṟa taṟangkariwiyangku wantima aṉangu kutjupa tjuṯa tjituṟu-tjituṟurinytjaku-tawara. ");
INSERT INTO pjt_vpl VALUES ("PR20_6","021_20_6","PRO","20","6","6","Aṉangu tjuṯangkuya wangkapai, “Ngayuku mulamulariwa panya ngayulu kalkuntjatjanungku palyalpai alatjiṯu.” Palu alatji wangkanyangkaya kuliṟa mapalku mulamularingkuwiyangku wantima, panya tjana unytjungku kutju wangkapai mulamulangku wiya, palu aṉangu maṉkurtu kutju kalkuntjatjanungku tjukaṟurungku palyalpai. ");
INSERT INTO pjt_vpl VALUES ("PR20_13","021_20_13","PRO","20","13","13","Tjinguṟu nyura waṟka wiya rawa kunkunpa ngarira paḻtjatjiratjariku. Palu nyura kunkunpa wiyangku waṟka kutjupa kutjupa tjuṯa palyaṟampa mani mantjiṟa mai puḻkatjara nyinaku paḻtja alatjiṯu. ");
INSERT INTO pjt_vpl VALUES ("PR22_6","021_22_6","PRO","22","6","6","Tjitjiyanku kuḻunypalpi wiṟuṟa nintinma palyanyku nyinanytjaku, ka paluṟu tjana ngula puḻkaringkula kulilku panya palunya tjananya nyura tjukutjukulpi nintintjitja munuya wiṟuṟalta nyinaku tiṯutjara. ");
INSERT INTO pjt_vpl VALUES ("PR22_24","021_22_24","PRO","22","24","25","Uti nyura maḻpa mularku mukuringama munu aṉangu mirpaṉtju maḻpa palyantja wiyangku wantima nyura palu puṟunyarinytjaku-tawara. Tjinguṟu nyura palula tjunguringkula palu puṟunyariku munu nyura aṉangu tjuṯaku puṯu kalypa nyinaku, ka palulanguṟu kura tiṯutjara nyurala ngaṟakatima. ");
INSERT INTO pjt_vpl VALUES ("PR23_4","021_23_4","PRO","23","4","5","Purkaṟangkuya kulinma, panya aṉangu kutjupa tjuṯa puḻkaṟa rawa w