﻿USE sofia;
DROP TABLE IF EXISTS sofia.piu2006_vpl;
CREATE TABLE piu2006_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES piu2006_vpl WRITE;
INSERT INTO piu2006_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","5","Yurrunpa manta anta yilkariwiyangka tjungu Katutjalu palyalkitjalu kuwarripa kuliṉu. Mantawiya yuti ngarangi, kapi kutju tiṉa ngarringi. Waḻpa kutju pirrtjipayi kapi palulawana. Munga ngarapayi. Katutjaku kurrunpa ngalya tjarukatirra nyinayinkupayi. Palulanguru Katutjalu watjaṉu, “Tjiṉṯu mungarrtji rarrpa nguwanpa ngaranytjaku.” Palunyangka rarrpalpi ngarangi. Nyakula Katutjalu watjaṉu, “Ngaatjanya yini kutjupa, rarrpa ngaranyi.” Rarrpa ngarala mungarringu. Katutjalu nyakula watjaṉu, “Ngaatjanya yini ‘Munga.’” Palulanguru munga ngarala rarrpa kutjupa ngarangi. ");
INSERT INTO piu2006_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","8","Katutjalu yalatji watjaṉu tjunkukitjalu, “Yilkarirriwa!” Palulanguru watjaṉu, “Yutuwari ngaranytjaku.” Palulanguru watjaṉu, “Yutuwaringka yunnguwana yuru ngarrinytjaku.” Paluru yalatji palyaṉu. “Ngaatja yilkariṉa yini watjaṉi.” Palulanguru munga ngarala rarrpa kutjupa ngarangi. ");
INSERT INTO piu2006_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","13","Katutjalu yalatji watjaṉu tjunkukitjalu, “Yuruwana manta yutitjarrinytjaku.” Yalatji watjaṉutjangka yilta mantarringu. Katutjalu yunyparringkula watjaṉu, “Ngaatja mantaṉa yini watjaṉi. Kutjupaṉa ngaatjanya watjaṉi, ‘Yuru tiṉa.’” Palulanguru Katutjalu yalatji watjaṉu, “Mantatjanu yukiri pakara ngaranytjaku. Kutjupa tjuṯa yuṉinytjarra, kutjupa kaḻkatjarra.” Yalatji watjaṉutjangka, yilta yukiri watiya pakaṉu. Palulanguru Katutjanya nyakula yunyparringu. Munga ngarala rarrpa kutjupa ngarangi. ");
INSERT INTO piu2006_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","19","Palulanguru Katutjalu watjaṉu, “Tjiṉṯu pira piṉṯirri tjuṯa ngaranytjaku.” Tjiṉṯu nyakula yaṉangulu kulilku tjiṉṯu tjiṉṯurripayi. Yaṉangulu nyakula tjiṉṯu kuliṉi waru. Yalatji ngarala maanytjangka warrirringkupayi. Pira nyakula kuka tjuṯa nyurrkarringanyi, yurarringanyi. Palulanguru tjana pakaṉi maanytjangka. Yalatji Katutjalu watjara palyaṉu tjiṉṯu pira, piṉṯirri tjuṯa ngaranytjaku. Yaṉangulu tjiṉṯu nyakula kuliṉi aaḻi. Tjiṉṯu katu kuliṉi kaḻaḻa. Tjiṉṯu yunngurringkunytja watjaṉi, mungarrtji mungarrtji. Pira piṉṯirri tjuṯanya palyaṉu mungangka tilingku kanyintjaku. Katutjalu yalatji palyaṉu, mantangka tili ngaranytjaku, mungangka tili ngaranytjaku. Yalatji palyara Katutjanya yunyparringu, nyakula. Palulanguru munga ngarala tjiṉṯurringu. ");
INSERT INTO piu2006_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","23","Palunyangka Katutjalu watjaṉu, “Yuruwana kuka kutjupa kutjupa tjuṯa nyinanytjaku. Katuwana tjuḻpu kutjupa kutjupa tjuṯaya yankulinkunytjaku.” Yalatji nguwanpa Katutjalu yuru ngurrara tiṉa tjuṯa palyaṉu, tjuḻpuṯarra. Palunya tjuṯa nyakula Katutjanya yunypalpi nyinangi. Palunya tjuṯanya watjaṉu, tjukutjuku tjuṯa mantjintjaku. “Mantjiranyurra tjuṯatjarra tjiwarriwarringka nyinanytjaku.” Munga ngarala tjiṉṯu kutjuparringu. ");
INSERT INTO piu2006_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","31","Palunya Katutjalu watjaṉu, “Kuka tjuṯa mantawana nyinarra waṉinytjaku, kukawiya tjuṯanyaṯarra.” Katutjalu yalatji watjaṉutjangka, kuka tjuṯa, kukawiya tjuṯanya yilta yutirringu. Yalatji palyantjatjanu Katutjanya nyakula yunypalpi nyinangi. Palunyatjanu Katutjalu yalatji watjaṉu, “Kala, yaṉangulpila palyalku tjungungku, nganaṉanya nguwanpa. Yaṉangu mayutju tjanampa nyinanytjaku kukaku, tjuḻpuku yuru ngurrarakuṯarra.” Wati anta kungka pulanya watjaṉu Katutjalu, “Nyinarrapulan pipirri tjuṯa mantjintjaku. Yalatji yaṉangu tjuṯarringkunytjakuṉa yunyparringanyi, manta tjiwarriwarriwana. Yukiri tjuṯaṉa nyurrampa ngaratjunkula wantingu, mangarri yuṉinytjarra, kaḻkatjarra tjuṯaṯarra ngalkura nyinanytjaku. Mangarri yuṉinypa wiyarringkunytjawiya kutu ngaramalpa.” Mantangka tjanampa mangarri, yukiri kutjupa kutjupa ngaratjunkula wantingu. Katutjanya nyakula puḻkara yunyparringu. Munga ngarala tjiṉṯu kutjuparringu. ");
INSERT INTO piu2006_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","4","Katutjanya waarrka wiyarringkula nyinangi. Tjiṉṯu katukatungka Katutjanya waarrkarrirra tjuṯa palyara wiyaṉu, yilkari, manta, kuka yaṉangu tjungu. Palunyatjanu paluru waarrkarrirra tjiṉṯu kutjupangka wiyalpi nyinangi. Tjiṉṯu palunyaku yunyparringkula Katutjalu yalatjilu watjaṉu, “Tjiṉṯu ngaatjanya waarrkawiya nyinanytjaku. Yilta tjiṉṯu ngaatjanya tiṉalingku, waarrkawiya nyinanytjaku, tjiṉṯu yini Tjarritiyingka.” ");
INSERT INTO piu2006_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","14","Yurrunpa Katutjalu manta yilkari palyaṉutja, wiya yukiri ngarangi. Yuṉinypa wiya ngarangi kapi punkantjawiyangka. Katutjalu wiya wantirriyaṉu. Kaana mangarritjarra wiya ngarangi. Yaṉangungku wiya tjawara ngaratjunangi, kapi walu kutju ngarripayi. Mayutju Katutjalulpi manta mantjira yaṉangu wati palyara ngaratjunu. Mulya puyura kana nyinatjunu, ngaalypa walytjatjarra. Wati paluru kana nyinangu. Palulanguru mayutju Katutjalu ngurra yini Yiitanangka kaana palyara pakaltjingaṉu. Watiya tjuṯa mangarritjarra ngarangi, kutjupa kutjupa. Ngurra palula wati palunya katirra nyinatjunu. Kaanangka ngururrpa watiya kutjarra ngarangi. Kanya watiya kutjupanya mangarri palyatjarra, yaṉangulu ngalkura kana kutu nyinanytjaku. Kanya watiya kutjupanya ngalkura kutjupa kutjupaku ninti nyinapayi. Yaṉangulu ngalkura kuya tjuṯaku ninti nyinanyi. Yalatjiṯarra ngalkura palya tjuṯaku ninti nyinanyi. Ngurra palula kaanangka karru kapi raanarringangi. Karru palulawana yukiri watiya tjuṯa ngarangi. Kaanangka munkarra karru puupala tjarrarringu. Karru kutju yini Piitjanya kapi raanarringangi, manta Yapilawana. Manta palula yaṉangu tjuṯa nyinarraya mantjilpayi puḻi kuultatjarra. Puḻi kutjupa kutjupa tjuṯaya mantjilpayi. Karrku nguwanpaya palula mantjilpayi. Karru kutjupa yini Kiiyunya manta Yitjiyupiyalawana raanarringangi. Karru kutjupa yini Takiritjinya, manta Yatjiriyangka kakarrarawana raanarringangi. Tjarra kutjupa yini Yupurititjala raanarringangi. ");
INSERT INTO piu2006_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","17","Palulanguru mayutju Katutjalu watjaṉu, “Kaana ngaawana mangarri tjuṯaṉa palyaṉu nyuntu palya ngalkuntjaku. Watiya kutjutjanu wiya mangarri nyuntu ngalkunytjaku. Watiya panyapanya kutju ngururrpa ngaranytjanya yaṉangungku ngalkura ninti nyinaku, yuwankarraku kuyaku anta tjukarurruku. Yalatjingkamarra mangarri panyapanya wiya ngalkunytjaku, watiya kutjungka.” Katutjalu watjaṉu, “Mangarri panyapanya nyuntu ngalkura yiluku, tjiṉṯu kutjungka.” ");
INSERT INTO piu2006_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","25","Palunyatjanu Katutjalu walytjalu kuliṉu, “Wati panyapanya kutju nyinanyi. Ngayuluṉara maḻpa palyalku.” Palulanguru Katutjalu manta mantjira kuka tjuṯa palyara kana nyinatjunu. Tjuḻpu tjuṯa yurukarratja yalatji palyaṉingi. Palulanguru wati paluru yini watjaṉingi kuka tjuṯanya anta tjuḻpu tjuṯanyaṯarra, kutjuṯu kutjuṯu. Palulanguru kuka tjuṯa tjuḻpu tjuṯa yinitjarra yinitjarra nyinangu, kaana palula. Palulanguru wati paluru puṯu nyakula ngurriṉingi maḻpa palunya nguwanpaku. Palulanguru Katutjalu wati panyapanya kunkuntjura kantilypa tarrka mantjira maḻakulu patiṉu. Tarrka palunyatjanu Katutjalu minyma palyaṉu. Wati paluru kanarringkula nyangu minymalpi ngarrinytjala. Wati paluru nyakula yunyparringkula watjaṉu, “Yilta maḻpalpitju nyinanyi, ngayunya nguwanpa kantilypa ngayukuṉutjarra. Yiniṉanta watjaṉi, ‘Minyma.’” Paluru kutjarra miiṯararra rawa nyinapayi. Kuwarrila palunya kutjarra nguwanpa, tiṉarringkula paapa maamanya wantirra miiṯalpi yaḻṯinyi. Rawa nyinarra walytjarringanyi. Yurrunpapula tjaaṯawiya nyinangi, kuṉṯawiya. ");
INSERT INTO piu2006_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","6","Yurrunpa mayutju Katutjalu kuka kutjupa tjuṯa palyaṉu piḻkaṯiṯarra palyaṉu. Piḻkaṯi palunya matjiki ngarringu, yaṉangu tjingapungkupayi. Piḻkaṯi palunya yaṉangu nguwanpa wangkarra, minyma palunya tjapiṉu, “Katutjalu nyupalinya watjaṉu watiya ngaa tjuṯatjanu mangarri wiyapulan ngalkunytjaku, yilta?” Minymalu piḻkaṯingka yalatjilu watjaṉu, “Katutjalulinyatju marrkuṉu watiya ngaatjanu wiya mangarri ngalkunytjaku. Kaanangka ngururrpa watiya ngaatjanya ngaranyi. Wiyalitju pampuntjaku. Tjinguru ngalkuralitju yilupayingka.” Piḻkaṯinya minymakutu wangkangu, “Ngunytjintapula watjaṉu. Mangarri ngaatjanyapulan ngalkura wiya yiluku. Ngalkurapulan Katutjanya nguwanpa ninti nyinaku, yuwankarraku. Nintipulanu nyinaku kuyaku anta tjukarurruku.” Palulanguru minyma paluru nyakula kuliṉu, watiya ngururrpa ngarangitjangka. Paluru punturalingku kuliṉu, watiya mangarritjarra, “Tjinguruṉa yatjira ngalkulku, ninti nyinakitja.” Yalatji kulintjatjanungku warrpura ngalkuṉu. Palulanguru katirrara yungu palumpa miiṯa. Watilu mantjira ngalkuṉu. ");
INSERT INTO piu2006_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Yiltapula ngalkura pinalpi alytjurarringu. Nyakulapula kuṉṯarringu, “Nikitili ngaranyi, mantarrawiya.” Palulangurupula parrka mantjira nyiiḻatjarrangku wakaṉu mantarra nguwanpa. Mantarratjarra nguwanpapula nyinangi. ");
INSERT INTO piu2006_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","13","Yalatjipula parrkatjarra nyinangi mungarrtji mungarrtji. Palunyangka kaanawana Katutjanya yankulinangi. Kulirapula tjaṯangka kumpiṉu. Katutjalu pulampa tjapira ngurriṉingi, “Nyaangkamarra nyupali kumpiṉi?” Pakaralpi kuṉṯakuṉṯalu watilu watjaṉu Katutjalakutu, “Kuliṉuṉanta ngalya yananyingka, kaanawana. Nguḻurringkulaṉa kumpiṉu nikiti mantarrawiyalitju kulira.” Katutjalu tjapiṉu, “Nganalunta nintiṉu?, nyupali nikiti nyinanyingka. Tjingurupulan mangarri panyapanya ngalkuṉu. Ngayulu nyupalinya marrkuṉu wiya watiya panyapanya pampuntjaku.” Watilu watjaṉu, “Ngayuluṉa ngurrpa. Minyma panyapaluṉi mangarri ngalya katirra yungu. Minyma panyapa nyuntu maḻpa ngayuku palyaṉu. Yilta paluruṉi yungu.” Palulanguru Katutjalu minymanya tjapiṉu, “Nyaaku nyuntu watiya panyapanya pampuṉu?” Minymangku watjaṉu, “Wiya, piḻkaṯiluṉi tjingapungu, ngalkunytjaku.” ");
INSERT INTO piu2006_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","21","Palulanguru mayutju Katutjalu piḻkaṯi palunya watjaṉu, “Nyuntu tjingapungutjangka, nyuntunya kutjuṉanta kuyalku, kuka kutjupa tjuṯa, wiya. Tjunilulpin pampurinamalpa mantawana.” Katutjalu piḻkaṯi palunya watjaṉu yalatji, “Yunytjuwiyangkupulan nyinamalpa piḻkaṯipa kungka. Kungka palunyakuṉu yuṉṯalpiṯi kapaḻipiṯiluntaya pungamalpa, nyuntukuṉu kapaḻi tjamu nyakula.” Palulanguru Katutjalu kungkangkalpi watjaṉu, “Yalatji nyuntu palyaṉutjangka ngayuluṉanta kuyalku. Palunyatjanu pipirri mantjira nyuntu mikin puḻkatjarralpi nyinaku. Nyuntupa miiṯa mayutju nyuntupa nyinaku.” Palunyatjanu watingkalpi watjaṉu, “Yalatji nyuntupanta watjaṉutjangka kulira nyuntu ngalkuṉu. Nyuntu ngalkuwiyangku wantimara. Yirriṯiṉanta watjaṉu wiya ngalkuntjaku. Nyuntu alatji palyaṉutjangka mantaṉanta kuyalku. Mayi ngalkukitja nyuntu kutu waarrkarrimalpa. Ngayulu kuyaṉutjangka tjilkalaṯarra pakara ngarala waṉiku. Mayi wiima walytja pakara ngaranytja tjuṯa kutju nyuntu yantara ngalkunmalpa, rawa puṯu waarrkarrirra. Palunyangka pakaltjingalkitjalu nyuntu tiṯu puṯu waarrkarrimalpa, yakuri yintirra. Kutu yalatji waarrkarrinytjatjanu nyuntu yiluku. Nyuntu ngarrirra piyuku mantarringkuku.” Palulanguru wati Yatamalu yini watjaṉu, “Yiipanya.” Yini panyapa watjaṉu yaṉangu tjuṯaku maama nyinanytjaku. Mayutju Katutjalu pulampa kuka pangkitjanu mantarra palyara yungu, tjarrparrapula nyinanytjaku. ");
INSERT INTO piu2006_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","24","Palunyatjanu mayutju Katutjalu alatji watjaṉu, “Yaṉangu palunya kutjarra nganaṉa nguwanpalpi ninti nyinanyi. Kuyakupa palyaku nintilpipula nyinanyi. Watiya kanalpayikutupula maḻaku yankula piyuku ngalkutjipingkamarra, waṉmala pulanya iyalku, ngalkurapula kutu kana yilunytjawiya nyinatjipingkamarra.” Palulanguru Katutjalu pulanya watipa kungka palunya watjara iyaṉu, kaana palunyangka waṉma nyinanytjaku. Wantirra iyaṉu pulanya yankula watilu tjawara mayi pakaltjingantjaku, mantangka. Yaṉangu palurulpi manta tjawara waarrkarringu, mayiku. Kaana palula kakarratjayiṯi Katutjalu nyaḻpitjarra maṉkurrpa ngaratjunu, yaṉṯayaṉṯara kanyintjaku, tjuuḻa waṯawaratjarra, tilitjarra, yaṉangu maḻaku tjarrpatjipingka. ");
INSERT INTO piu2006_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","7","Palunyatjanu Yatamanya Yiipanyapula tjungu nyinarra pipirritjarrarringulpi, katjalpi mantjiṉu. Mantjira watjaṉu, “Katutjaluṉi yungu.” Katja palunya yini watjaṉu, “Kayinanya.” Palulanguru ngaṉṯi katja kutjupalpi mantjiṉu. Paluru yini “Yipulanya.” Paluru tiṉarringkula tjiipi tjuṯa kanyiṉingi, kanya palumpa kaakangku tiṉarrirra manta tjawara waarrkarrirra mayi pakaltjingalpayi. Palunyatjanu Kayinalu rawa waarrkarrirra mayi pakaltjingara muṯura ngulaku tjunu. Mayi puḻka pakaṉutjangka Katutjanya waḻkulkitjalu kuliṉu, kunaṯinpa yungkukitjalu, mayi kutjupa tjuṯa mantjira. Mayi kutjupa tjuṯa mantjira Kayinalu katirra Mayutju Katutjanya kunaṯinpa yungu. Palunyatjanu Yipulalu tjiipi tjuṯa kanyiṉingi. Paluru tjiipi wiima kutju pungu, mantjira, Katutjaku kunaṯinpa yungkukitjalu. Tjiipi wiima paluru yurruntitja. Kuka palunya yitjiḻinkula katirra tjunu, kuka palya maṉkurrpa. Yalatji nyakula yunyparringu Katutjanya, Yipulakura. Kanya Kayinaku nyakula wantingu, yunyparrinytjawiyangku. Palulanguru Kayinanyara Katutjaku puntura mirrpaṉarrirra, nyinangu. Palulanguru Katutjalu tjapiṉu, “Nyaakun mirrpaṉpa nyinanyi? Nyuntu tjukarurru palyaṉutjangka ngayuluṉanta yilta pukuḻarrimara. Nyuntu wiya kuya kutu kulintjaku. Kala, nyuntu ngayuku tjukarurru palya nyinanytjaku.” Yalatji Katutjalu Kayinanya watjara wantingu. ");
INSERT INTO piu2006_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","10","Palulanguru Kayinalu palumpa maḻanypa watjaṉu, “Tjungulika yarra!” Tjungupula yankula ngururrpalpi Kayinalu maḻany palumpa mirri pungu. Yalatji pungkula wantirra ngurrakutu maḻaku yanu. Mayutju Katutjalu Kayinanya tjapiṉu, “Yaalytji nyuntupa maḻanypa?” Yalatji Kayinalu ngunytji watjaṉu, “Ngurrpampaṉa. Wampa paluru yanu.” Mayutju Katutjalu tjapiṉu, “Nyaangurumpan mirri pungu? Nyuntu pungkuwiyangku wantimara. Palumpa ngurrka yintinytjatjanu, yaṉangu yutitja nguwanpaṉi wangkangu. Yalatjiṉi watjaṉu, ngaparrtjiṉanta pungkunytjaku.” ");
INSERT INTO piu2006_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","14","Katutjalu Kayinanya piyuku watjaṉu, “Maḻanypa nyuntupan mirri pungutjangka ngayuluṉanta manta kuyalku, nyuntupa maḻanypa ngurrka mantangka yintingutjangka. Nyuntu puṯu mayi pakaltjingalku, wiima wiya kutju pakalku. Ngurra kutjungka nyinanytjawiya nyuntu nyinarinamalpa, ngurra tjuṯawana.” Wangka yalatji kulira Kayinalu watjaṉu, “Puṯuṉa kuliṉi kana nyinakitjangku. Kuunyi nyinarraṉa wiyarriku. Yalatji nyuntu ngayunya watjara wantirra iyaṉi, tjunguli nyinanytjawiyalu. Ngurrawiyaṉa nyinarinamalpa, yaṉangu kutjupa tjuṯawana. Nyakulaṉiya mirri pungku.” ");
INSERT INTO piu2006_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","16","Mayutju Katutjalu watjaṉu, “Nyuntunyanta pungkunyangka, ngayuluṉa tjananya ngaparrtji mirri pungku, walytja palumpa tjapanpala.” Palulanguru Katutjalu Kayinanya maakatjunu, kutjupalu nyakula wiya palunya mirri pungkunytjaku. Palunyatjanu Kayinanya Katutjalu wantirriyaṉu. Palulanguru Kayinanya yanu ngurra kutjupakutu, yini Naatakutu. Ngurra palulawana ngurra Yiitanangka kakarrara nyinarinangi. ");
INSERT INTO piu2006_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","8","Yaṉangu tjuṯarringulpiya ngurra tjiwarriwarri nyinarra waṉingi. Rawaya kuya palyaṉingi. Palulanguru Katutjalu tjananya nyakula tjanampa mirrpaṉarringu. Yalatji kuliṉu, “Yaṉangu ngaa tjuṯaṉa tjananya wiyalku, kuka tjuṯa tjuḻpu tjuṯa. Yilta palyantjawiyaluṉa tjananya wantimara.” Palunyangka wati kutjuku pukuḻarringu, Nuuwaku. ");
INSERT INTO piu2006_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","12","Yara ngaatja Nuuwanyatjarra. Nuuwanya kutju wati palya nyinangu, Katutjaku tjukarurru. Katutjaku walytja yilta, kanyaya yaṉangu winkiya kuyarringu. Yaṉangu kutjupaya mirri pungkupayi, kutjupa tjuṯa waṉngilpayi, kutjupa tjuṯa turaangkarringkula pika pungkupayi. Yalatji Katutjalu nyakula tjanampa mirrpaṉarringu. Nuuwalu kanyiṉu katja maṉkurrpa. Yini yalatjiya nyinangu, Tjiimanya, Yiimanya, Tjiipitjanya. ");
INSERT INTO piu2006_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","22","Palunyatjanu Katutjalu yalatji Nuuwala watjaṉu, “Yaṉangu tjuṯa palatja kuyarringu, yuwankarraṉa tjananya wiyalku. Nyuntu puuta tiṉa palyara ngaratjurra!, watiya kuṉputjarralu. Yunngutjayiṯi ruuma tjuṯatjarra palyala! Kiṯi nguwanta nganytjatjurra patila!, kapi tjarrpatjipingkamarra. Katuwana palyala wintawu tjuṯa!, patilpayitjarra. Puutangka kultutjayiṯi palyala tuuwa patilpayitjarra!” Nuuwala Katutjalu piyuku watjaṉu, “Kapi tiṉaṉa katunguru wantirra iyalku, yiluntankunytjaku kuya palyalpayi tjuṯa. Kapi tiṉangku tjananya mantanguru taara pakara yiluntanku. Yaṉangu kuka tjuṯa tjarrparra yuwankarra wiyarriku. Ka nyurrangarri kutju kana nyinaku. Kanalkitjaluṉa nyurranya watjaṉi. Puutangkaya tjarrpa nyuntu!, nyuntupa miiṯa, nyuntupa katja maṉkurrpa, nyuntupa ngunyarri maṉkurrpa. Kuka tjuṯa miiṯararra miiṯararra tjarrpatjurra! Kukawiya tjuṯa miiṯararra miiṯararra ka tjananya tjurra! Yalatji tjananya tjarrpatjurra!, tjana piyuku tjuṯarrinytjaku, kutjupa tjuṯa kapingku wiyantjala. Mayi tjuṯaṯarra tjarrpatjurra puutangka!, tjanampa, nyurrangarrimpaṯarra.” Yalatji Katutjalu Nuuwanya watjaṉutjangka, paluru kulira palyaṉu. ");
INSERT INTO piu2006_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","24","(7:1—8:12) Puuta kala palyara ngaratjunutjangka Katutjalulpi Nuuwanya watjaṉu, “Puutangkaya tjungu tjarrpa! Kuliṉiṉa yaṉangu tjuṯangkuya kuya palyaṉingka nyuntu kutju tjukarurru nyinanyi.” Katutjalu Nuuwangka piyuku watjaṉu, “Kuka kunaṯinpaṉinyurra yungkupayi. Kuka palunya tjananya tjarrpatjurra!, miiṯararra miiṯararra puutinpala. Kunaṯinpa palunya kuka tjuḻpuṯarra tjarrpatjurra!, miiṯararra miiṯararra, puutinpala. Kukawiya tjuṯa miiṯararra tjarrpatjurra! Tjuṯa kutu tjananya tjarrpatjurra kapingkamarra!, tjana piyuku tjuṯarrinytjaku. Tjiṉṯu tjapanpala wiyarrinytjala kapi puntulpiṉa wantirriyalku. Rawalingku nyurranya pungamalpa pira kutjarra nguwanpa. Yaṉangu tjuṯa, kuka tjuṯa ngurra winkingka yurungku wiyalku kapi tiṉangku, ngayuluṉa wantirra iyantjangka. Ngayuluṉa palyara ngaratjunutja, yuwankarra wiyarriku.” Yalatji kulira Nuuwalu palyaṉu. Kuka tjuṯa, kukawiya tjuṯanyaṯarra Nuuwalungarri katirra tjarrpatjunu. Puutangkaya nyinangu. Nuuwaku katja maṉkurrpa palumpa ngunyarri maṉkurrpa, yuwankarra tjarrpangu. Palunyatjanu Katutjalulpi kutu kutju patiṉu, tuuwa. Palunyangka Nuuwanya nyinangu tjiḻpilingku, tjikitji yantaṯa yiiya. Kapingkulpi tjananya rawa pungangi. Kapi kutjupa tjuṯa kaninytjarranguru pakaṉingi, mantanguru. Kala puuta palunya kapilu katuṉulpi. Kapingka katulpi puuta paluru ngaralinangi. Kapi palunya piyuku puḻkarringu, katunguru yunngunguru. Katulingkulpi ngarangi, puḻingka munkarra. Kapilu tjananya yuwankarra wiyaṉu, yaṉangu tjuṯa, kuka tjuṯa, kukawiya tjuṯanya, mantawana yankupayi tjuṯanya, katuwana yankupayi tjuṯanya. Nuuwanyangarri kutju puutangka kanarringu. Kapilu pungkula wiyarringutjangka, kapi palunya rawa ngarringu, pira tjikitjipala nguwanpa. Katutjalu Nuuwanya puntura kuliṉingi, wiya wantingu. Piyuku watjaṉu, waḻpa wangkanytjaku, tjiṉṯulu kampanytjaku. Waḻpa wangkarra tjiṉṯulu kampanytjatjanu kapi paluru kaninytjarrarringulpi. Palunyatjanu puuta palunya puḻingka ngarangu, yini Yararatangka, katu. Rawaya nyinangu puutangka, pira tjirripala. Palunyangka kapi wiyarringulpi, puḻi tjuṯa yutitjarringu. Pira kutjulpiya nyinangu puutangka. Palunyatjanu Nuuwalu kaaṉkalpi wintawu katu yaḻara iyaṉu. Puutanguru pakara yanu. Wiya piyuku ngalya yanu. Tiṯu parra yankula maa yanulpi. Piyuku Nuuwanya nyinarra ngatapuka nguwanpalpi wantirriyaṉu. Yalatji paluru wantirriyaṉu, kulilkitjangku, “Paluru watiyaku puṯu ngurrira maḻaku ngalya yanku. Palunyangkaṉa kulilku, kapi kutu ngarrinyi.” Puuta palunya puḻingka katu ngaranyangka, Nuuwalu puṯu nyangu, manta nyakukitjangku. Yilta ngatapuka paluru puṯu ngurrira ngalya yanu, Nuuwalakutu. Nuuwalulpi witira tjarrpatjunu. Tjiṉṯu tjapanpala paṯara ngatapuka palunya piyuku wantirriyaṉu. Yankula mungarrtjilpi ngalya yanu. Tjaangka nyaḻpi ngalya katingu. Kala Nuuwalulpi kuliṉu, kapi wiimarringutjangka. Tjiṉṯu tjapanpala paṯara piyuku ngatapuka palunya wantirriyaṉu. Yankula wiya maḻaku ngalya yanu, kutu kutju maa yanu. ");
INSERT INTO piu2006_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","12","(7:1—8:12) Puuta kala palyara ngaratjunutjangka Katutjalulpi Nuuwanya watjaṉu, “Puutangkaya tjungu tjarrpa! Kuliṉiṉa yaṉangu tjuṯangkuya kuya palyaṉingka nyuntu kutju tjukarurru nyinanyi.” Katutjalu Nuuwangka piyuku watjaṉu, “Kuka kunaṯinpaṉinyurra yungkupayi. Kuka palunya tjananya tjarrpatjurra!, miiṯararra miiṯararra puutinpala. Kunaṯinpa palunya kuka tjuḻpuṯarra tjarrpatjurra!, miiṯararra miiṯararra, puutinpala. Kukawiya tjuṯa miiṯararra tjarrpatjurra! Tjuṯa kutu tjananya tjarrpatjurra kapingkamarra!, tjana piyuku tjuṯarrinytjaku. Tjiṉṯu tjapanpala wiyarrinytjala kapi puntulpiṉa wantirriyalku. Rawalingku nyurranya pungamalpa pira kutjarra nguwanpa. Yaṉangu tjuṯa, kuka tjuṯa ngurra winkingka yurungku wiyalku kapi tiṉangku, ngayuluṉa wantirra iyantjangka. Ngayuluṉa palyara ngaratjunutja, yuwankarra wiyarriku.” Yalatji kulira Nuuwalu palyaṉu. Kuka tjuṯa, kukawiya tjuṯanyaṯarra Nuuwalungarri katirra tjarrpatjunu. Puutangkaya nyinangu. Nuuwaku katja maṉkurrpa palumpa ngunyarri maṉkurrpa, yuwankarra tjarrpangu. Palunyatjanu Katutjalulpi kutu kutju patiṉu, tuuwa. Palunyangka Nuuwanya nyinangu tjiḻpilingku, tjikitji yantaṯa yiiya. Kapingkulpi tjananya rawa pungangi. Kapi kutjupa tjuṯa kaninytjarranguru pakaṉingi, mantanguru. Kala puuta palunya kapilu katuṉulpi. Kapingka katulpi puuta paluru ngaralinangi. Kapi palunya piyuku puḻkarringu, katunguru yunngunguru. Katulingkulpi ngarangi, puḻingka munkarra. Kapilu tjananya yuwankarra wiyaṉu, yaṉangu tjuṯa, kuka tjuṯa, kukawiya tjuṯanya, mantawana yankupayi tjuṯanya, katuwana yankupayi tjuṯanya. Nuuwanyangarri kutju puutangka kanarringu. Kapilu pungkula wiyarringutjangka, kapi palunya rawa ngarringu, pira tjikitjipala nguwanpa. Katutjalu Nuuwanya puntura kuliṉingi, wiya wantingu. Piyuku watjaṉu, waḻpa wangkanytjaku, tjiṉṯulu kampanytjaku. Waḻpa wangkarra tjiṉṯulu kampanytjatjanu kapi paluru kaninytjarrarringulpi. Palunyatjanu puuta palunya puḻingka ngarangu, yini Yararatangka, katu. Rawaya nyinangu puutangka, pira tjirripala. Palunyangka kapi wiyarringulpi, puḻi tjuṯa yutitjarringu. Pira kutjulpiya nyinangu puutangka. Palunyatjanu Nuuwalu kaaṉkalpi wintawu katu yaḻara iyaṉu. Puutanguru pakara yanu. Wiya piyuku ngalya yanu. Tiṯu parra yankula maa yanulpi. Piyuku Nuuwanya nyinarra ngatapuka nguwanpalpi wantirriyaṉu. Yalatji paluru wantirriyaṉu, kulilkitjangku, “Paluru watiyaku puṯu ngurrira maḻaku ngalya yanku. Palunyangkaṉa kulilku, kapi kutu ngarrinyi.” Puuta palunya puḻingka katu ngaranyangka, Nuuwalu puṯu nyangu, manta nyakukitjangku. Yilta ngatapuka paluru puṯu ngurrira ngalya yanu, Nuuwalakutu. Nuuwalulpi witira tjarrpatjunu. Tjiṉṯu tjapanpala paṯara ngatapuka palunya piyuku wantirriyaṉu. Yankula mungarrtjilpi ngalya yanu. Tjaangka nyaḻpi ngalya katingu. Kala Nuuwalulpi kuliṉu, kapi wiimarringutjangka. Tjiṉṯu tjapanpala paṯara piyuku ngatapuka palunya wantirriyaṉu. Yankula wiya maḻaku ngalya yanu, kutu kutju maa yanu. ");
INSERT INTO piu2006_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","22","Palunyatjanu Nuuwalu katutjayiṯi yaḻaṉu, nyakukitjangku. Nyangulpi kapi wiima kutju ngarrinytjala, kapi yuḻpaṯayuḻpaṯa. Palunyangka Nuuwanya tjikitji yantaṯan waan nyinangu. Palulanguru pira kutjarra nguwanpa nyinangu. Nyangulpi manta turayirringutjalpi. Katutjalu Nuuwanya watjaṉu, “Kala, yarralpiya!, walytjararranpa. Kuka kutjupa kutjupa tjuṯa walatjurra!, kukawiya tjuṯaṯarra, yankulaya tjuṯarrinytjaku.” Palulanguru Nuuwanyangarri puutangka tjarukatirra yanulpiya. Kuka tjuṯa walytjararra walytjararralpiya tjarukatirra yanu. Nuuwalulpi puḻi tjuṯa mantjira ngalya katirra tjunu, tiipula palyalkitjalu. Kuka palunya manta ngurrara kutjupa kutjupa Nuuwalura pungkula ngarritjunu Katutjaku, yilkari ngurraraṯarra. Ngatapuka kutju, kuka tjuḻpu kutjupa, yiimiyu kutju, kipara kutju. Yalatjira kutjuṯu kutjuṯu pungkula ngarritjunu. Katutjakulpira ngarritjunkula kunaṯinpa palunya tjuṯa kutjara wantingu, Katutjanya waḻkulkitjalu. Kuka palunya paṉṯira mayutju Katutjanya yunyparringu. Yalatji watjaṉu, “Yaṉangu tjuṯa ngula kuyarringanyingka, wiyaṉa kapi puḻkangka piyukuṉa tjananya wiyalku. Wantikuṉa tjananya. Nintiluṉa kuliṉi yaṉangu yuwankarralu kuya palyanyangka. Yaṉangu tjuṯa kuka tjuṯaṯarra, wiyaṉa tjananya piyuku kapingka wiyalku. Ngaatja yiltaṉa nyurranya watjaṉi.” Katutjalu watjaṉu, “Manta kutu ngaranytjala, yaṉangulu waarrkarrirra mayi pakaltjingarantjaku. Mayi palya tjanampa pakanmalpa mantanguru. Pakara puḻkarrinytja mantjiraya tjunamalpa. Tjiṉṯu pakara tjarrpamalpa, munga ngarala tjiṉṯurrimalpa.” ");
INSERT INTO piu2006_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","17","Katutjalu tjananya tjukarurru palyalkitjalu, watjaṉu tjananya, “Nyinarranyurra pipirri mantjilku. Palulanguruya maa tjuṯarriku, nyurrangarrimpa kapaḻipiṯi, tjamupiṯi, piyukuya maa tjuṯarriku. Ngurra tjiwarriwarriwanaya nyinayinku. Nyurrangarri mayutju nyinaku, kuka tjuṯaku, kukawiya tjuṯaku, kapi ngurraraku, manta ngurraraku. Nguḻunynguḻunypa nyurrangarrimpaya nyinaku. Palya tjananya nyurrangarri pungkula ngalkula nyinamalpa. Yukiriṉa nyurrampa pakaltjingantjatjanu, palyanyurra ngalkula nyinamalpa. Yalatjiṉa nyurranya yunganyi. Kuka pungkula ngurrka yintira wiyarringanyingka kutjunyurra ngalku. Ngurrka yintintjawiya wiyanyurra ngalku. Ngayulu Katutjalu kuliṉi ngurrka palunya maṯupurra. Ngurrka paluru kana kanyiṉi.” Katutjalu piyuku tjananya watjaṉu, “Yaṉangu kutjupa mirri pungkunyangka ngaparrtjiṉa palunya pungku. Kuka pikaṯilu yaṉangu warrpura yiluntankunytjala pikaṯi palunya ngayulu mirri pungku.” Katutjalu tjananya piyuku watjaṉu, “Ngayuluṉa Katutjalu yaṉangu palyaṉu, ngayunya nguwanpa nyinanytjaku. Yaṉangu kutjupaku yunytjuwiyarringkula mirri pungutjangka, yaṉangu kutjupa tjuṯalu ngaparrtjilu mirri pungkunytjaku. Palunyangka yaṉangu kutjupanya mirri pungkupayi, palunyanyurra ngaparrtji pungkunytjaku. Pipirri tjuṯanyurra palya mantjintjaku, nyupalimpaṉu walytja ngaṉṯitja tjuṯalingkulpi nyinanytjaku. Ngurra tjuṯawanaya nyinamalpa.” Katutjalu watjaṉu Nuuwala piyuku, palumpa katja tjuṯangkaṯarra, “Tjukarurruṉa nyurranya watjaṉi. Wiyaṉa kapingka wiyalku piyuku, yaṉangu tjuṯa. Wantikuṉa tjananya. Tjuṯiranguṉa ngaratjunamalpa, yaṉangulu nyakula kulintjaku, wiyaṉa nyurranya kapingka piyuku wiyalku. Ngayuluṯarra tjuṯirangu nyakula kulilku panyapa watjantjatjanulu. Yalatji kuliṉutjalu wiyaṉa yaṉangu piyuku kapingka yiluntankuku.” ");
INSERT INTO piu2006_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","9","Nuuwaku tjamu tjuṯa kapaḻi tjuṯa, tjuṯarringuya, wangka kutjutjarraya nyinangu. Kakarraya nyinayinkula ngurra yini Papilunakuturringu. Manta palunyangkaya rawa nyinangu. Waaḻa palyalkitjangkuya alatjingku watjaṉu, “Pakaralaka waarrkarri! Puḻi nguwanpa tjuṯala palyala pilkitjanu!, tjiṉṯungka ngarrirra piḻṯirringkunyangka puḻi nguwanarrinytjala.” Yalatjiya palyara puḻi nguwanpa tjuṯa kanyiṉingi, waaḻa palyalkitjangku. Kiṯi panyapa nganytjalpayiya mantjira kanyiṉingi. Watjaṉuya waaḻa tjuṯa palyalkitjangku. “Waaḻa kutju waṯawaralingkulaka palyala, yilkarikutu! Yaṉangu kutjupa tjuṯalulanyaya nyakula mirra waṉinytjaku. Yalatjilaka palyala!, ngurra kutjungkala tjungu nyinakitjangku. Ngurra tjiwarriwarriwana tjaalpan tjaalpa nyinanytjawiya.” Yalatjiya palyaṉu. Palunyangka Katutjalulpi nyangu, waaḻa palunya palyantjala, waaḻa tjuṯa kutjupaṯarra. Nyakula Katutjalu kuliṉu, “Pala tjuṯaya nyinanyi walytjararranpa, wangka kutjutjarra, ngurra kutjungka. Tjana wiya alatji nyinanytjaku. Ngurra kutjupa kutjupakutuṉa tjananya wantirriyalku, ngurra kutjungkaya nyinarrayanku puḻkawaṉipayingkamarra. Wangka tjaalpan tjaalpaṉa tjananya palyalku, ngurra kutjupa tjuṯangka nyinanytjaku.” Yalatji Katutjalu tjananya wangka kutjupa kutjupa palyaṉu. Yiyaṉulpi tjananya ngurra kutjupa tjuṯakutu. ");
INSERT INTO piu2006_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","26","Nuuwaku katja Tjiimalu Yapatjatanya mantjiṉu. Yapatjatalu mantjiṉu katja, Tjiilanya. Tjiilalu katja Yiipanya mantjiṉu. Yiipalu katja Pilikanya mantjiṉu. Pilikalu katja Ruuwanya mantjiṉu. Ruuwalu katja Tjarukanya mantjiṉu. Tjarukalu katja Niyuwunya mantjiṉu. Niyuwulu katja Tiiranya mantjiṉu. Tiiralu katja Yipumanya mantjiṉu. Ngula Katutjalu watjaṉu Yipumanya yini kutjupa alatji, “Yipuramanya.” ");
INSERT INTO piu2006_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","32","Tiiralu katja maṉkurrpa mantjiṉu, yini Yipumanya, Niyuwunya, Yarananya. Yaranalu katja Laatanya mantjiṉu. Yipumalu miiṯa Tjarayinya yaḻṯingu. Pipirriwiyapula rawa nyinangu. Tjiḻpi Tiiralu tjananya palumpa walytja tjuṯa yaḻṯingu, manta Kayinanalakutu yankukitjangku. Alatjiya yanu, Tiiranya, Yipumanya, Laatanya, Tjarayinya. Tawunu yini Yaaranya wantikatirra yankulaya ngururrpa nyinangu, tawunu yini Yaranangka. Palulaya rawa nyinangu, Yipuramanyangarri. Nyinarraya minytjirringu, paapa tjanampa wiyarringu. ");
INSERT INTO piu2006_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","3","Palulanguru Katutjalu Yipumanya watjaṉu, “Nyuntupa walytja tjuṯanya wantikatirra pakara yarra!, nyuntupa ngurraṯarra. Ngurra kutjupangkan yankula nyinanytjaku. Nyuntu yankunytjala ngururrpaṉanta nintilku ngurra palunya. Kuliṉiṉa walytja ngaṉṯitja tjuṯa nyuntupa nyinatjunkukitjangku. Yilta ngaṉṯitja tjuṯa nyuntupa nyinaku. Yilta kanyiraṉanta tjukarurru palyanmalpa. Yalatjiṉanta tjukarurru palyantjala yaṉangu tjuṯantaya ninti nyinaku. Yaṉangu kutjupalunta tjukarurru palyantjala, ngayuluṉara tjukarurru palyalku. Yaṉangu kutjupalunta yinkaku, palunyangkaṉa ngaparrtji palunya yinkarra kuyalku. Yaṉangu tjuṯakuṉa tjanampa pukuḻarrirra tjukarurru palyalku, nyuntutjun tjukarurru nyinangutjangka.” ");
INSERT INTO piu2006_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","Katutjalu panyapa watjaṉu, palunyangkaya wantirra yanu, Yipumanyangarri. Alatjiya anu Yipumanya, miiṯa palumpa Tjarayinya, Laatanya, waarrkana tjuṯaṯarra. ");
INSERT INTO piu2006_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","9","Yipumanyangarri manta Kayinanalakutu yanu tawunu Tjikimangkaya nyinangu. Katutjalu Yipumanya watjaṉu, “Ngurra palatja nyuntu nyanganyi palunyaṉa nyurranya yunganyi, nyuntupa kapaḻi tjuṯaku tjamu tjuṯakuṯarra, kutunyurra kanyintjaku.” ");
INSERT INTO piu2006_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","9","Manta Kayinanala nyinarra manta Yitjipilakutu anu, Yipumanyangarri. Yitjipila nyinarra paluru kutjarra yulytja puḻkapula mantjiṉu. Alatjipula mantjiṉu, mani kuulta, puluka tjuṯa, tjiipi tjuṯa, nanikuta tjuṯa, waarrkana tjuṯaṯarra. Kanya Laatalu kanyiṉingi, puluka tjuṯa, tjiipi tjuṯa, nanikuta tjuṯa, waarrkana tjuṯa. Manta palulaya nyinarra piyukuya maḻaku yanu, manta Kayinanalakutu. Pulukaṯarra kanyirapula puṯu kuliṉu, ngurra kutjungka kanyilkitjangku. Palulanguru pikarringuyanku waarrkana tjuṯangku, puluka tjungurringkula yukiringka ngalkunytjala. Palulanguru Yipumalu Laatanya watjaṉu, “Walytjararrali nyinanyi. Wiya waarrkana ngayukuṉu tjuṯa pikarrinytjaku waarrkana nyuntupa tjuṯanya, tjungu nyinanytjawiya yankuli tjaalpan tjaalpa nyinanytjaku, pikangkamarra. Ngurra palunyaku nyuntu yunytjurringkunyangka ngayulu ngayuku kuka tjuṯa ngurra kutjupakutu katirra nyinaku Watjalaṉi! Nyuntu ngurra yaalytjingka nyinakitja yunytjurringanyi?” ");
INSERT INTO piu2006_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","13","Laatalu parra nyakula paluru nyangu karru Tjuutanangka tjayiṯingka, yukiri puḻka ngarala waṉinytjala. Manta palula kapi puntu ngarringi, karruwana. Yalatji nyakula watjaṉu, “Ngayulu palyaṉa nyinaku, karrungka yila.” Palulanguru kala Laatalu katingu puluka tjuṯa, yuwankarra, tjiipi nanikutaṯarra. Kala tawunungka yila nyinangu, Tjutumala. Tjutumanya ngurrara tjuṯa Katutjaku mingarrtju tjuṯa nyinangi, kanya Yipumanya manta Kayinanalawana palya nyinangi. ");
INSERT INTO piu2006_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","18","Laatanya yanutjangka Katutjalu ngaṉṯi Yipumanya watjaṉu, “Puḻi palanguru ngarala parra nyawalpilta!, nyuntupa ngurra palunya. Nyuntupa walytja ngaṉṯitja tjuṯalu ngula kanyilku. Nyuntupa walytja ngaṉṯitja tjuṯalingkuya nyinaku, puṯu nyuntu kaantamilalku. Ngurra palulawana nyuntu tjarukatirra ankula nyakulirra!” Palunyatjanu yankula ngurra Yipurunala tiipula nguwanpa palyaṉu, puḻitjanu. Tiipula palula kunaṯinpa pungkula kutjaṉu, Katutjanya puḻkapungkukitjangku. ");
INSERT INTO piu2006_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","16","Ngurra kutjupatjanuya ngalya yanu mayutju puupalaku, tjilirratjarra tjuṯa. Palunyatjanuya pungangi tjananya Tjutumanya ngurrara Kumuranya ngurrara. Laataku walytja tjungurringangi tjanalawana. Palunya ngurrara tjuṯaku mani yulytja kungka tjuṯa tjananya paluru tjana katingu, Laatanyangarri palumpa yulytjaṯarra. Yalatji tjananya pungkula katingutjangka wati kutju tjalkaḻungu, Yipumala tjakultjunu. Kala Yipumalu kuliṉu Laatanya katingutjangka. Palumpa tjilirratjarra watjaṉu kutjungkarrirra yankunytjakuya. Kala Yipumalulpi tjananya katingu tjilirratjarra tjuṯa. Wanaraya Yuupangka yulparirra tjananya pungkula pungkula nguḻutjingara wantirriyaṉu, mungangka. Mani, yulytja, tjiipiṯarra, Laatanyangarri ngalya katingu maḻaku. ");
INSERT INTO piu2006_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","24","Yipumalu tjananya ngalya katinyangka ngururrpa, Tjutumaku mayutju tjungurringu, mayutju kutjupa yini Milkitjitikanyaṯarra. Milkitjitikanya palunya Tjiilumanya ngurrara tjuṯaku mayutju nyinangi. Paluru Katutjaku tuḻkuku mayutju nyinapayi. Paluru Yipumaku mayi anta pulakina ngalya katingu yungu. Katutjanya tjapiṉu Yipumaku, “Mayutju Katutjalunta tjukarurru palyanmalpa, manta yilkari palyalpayilu. Tjilirratjarra kutjupa tjuṯa ngalya yankunyangka, nyuntu palunya tjuṯa nguḻutjingalku, Mama Katutjalunta aalpamilaṉingka. Palulanguru nganaṉa Katutjanya waḻkuṉi.” Kala, Milkitjitikakura yungu ngalytjapungkula mani anta yulytja, tjiipiṯarra. Tjutumaku mayutjulu Yipumanya watjaṉu, “Mani tjiipi yulytjaṯarra nganampaṉu yunganyilatjunta. Ngayuku walytja tjuṯanya kutjuṉi yuwa!, waarrkana tjuṯaṯarra.” Yipumalu watjaṉu, “Katutjangka mirangka kanyintjawiyaluṉanta yungku, mani yulytja tjiipi tjuṯa, walytja tjuṯaṯarra. Wiyaṉa kanyilku, nyuntupa miyaḻa. Nguntiṉanta nyuntupa ngalya katingu, yungkuṉanta nyuntu alatji kuliltjipingkamarra. ‘Ngayuluṉara Yipumaku mani yulytja tjuṯa yunganyingka, Yipumanya yulytja puntutjarralpi nyinanyi.’” Yipumalu piyuku watjaṉu, “Katutjaluṉi yungkupayi mani yulytjaṯarra.” ");
INSERT INTO piu2006_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","4","Yipumanya ngurrangka nyinarra tjukurrpalpi nyangu. Katutjalu watjaṉu alatji, “Nguḻurrinytjawiya ngayuluṉanta yaṉṯayaṉṯalku, kutjupa tjuṯaluntaya pungkutjipingkamarra. Purinypangku kanyiraṉanta ngurra, yulytjaṯarra yungku.” Yipumalu watjaṉu, “Mayutju Katutja. Nyuntu kutju puḻkanya nyinanyi, ngayulu puṯu kuliṉi, pipirri wiya mantjintjatjanungku. Ngayuku katjawiyangka ngayuku waarrkanalulpi mantjilku, ngurra yulytjaṯarra, Yalitjalu, ngayulu wiyarringkunyangka. Ngayulu yunytjurringanyi ngayukuṉu katja walytjalu mantjintjaku.” Katutjalu Yipumanya watjaṉu katja yungkukitjangku, “Yalitjalu wiya nyuntupaṉu ngurra yulytjaṯarra kanyilku, katja nyuntupa walytjalu. Ngula yutirringkula puḻkarringkula kanyilku.” ");
INSERT INTO piu2006_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","16","Katutjalu watjaṉu Yipumanya, “Yurilkutu pakara yarra!” Yipumanya pakara ngaranyingka Katutjalu piyuku watjaṉu, “Piṉṯirri tjuṯalpi nyawa! Yilta, nyuntu puṯu kaantamilalku, tjuṯalingku. Piṉṯirri pala tjuṯa nguwanpa nyuntupa walytja ngaṉṯitja tjuṯa nyinaku, tjuṯalingku.” Katutjalu yalatji watjaṉutjangka Yipumalu puntura kuliṉu, “Yiltalingkuṉi watjaṉu.” Palulanguru Katutjanyara pukuḻpa nyinangu, palumpa wangka kuliṉutja. Katutjalu Yipumanya piyuku alatji watjaṉu, “Ngayuluṉanta mayutjulu yaṉṯayaṉṯara ngalya katingu tawun Yaaralanguru, ngurra ngaatjaṉanta yungkukitjangku.” Yipumalu tjapiṉu, “Yunytjurrinyiṉa manta ngaatjanya kanyilkitja. Kanyilkitjaluṉa puṯu kuliṉi, yiltaṉin yungku? Nintilaṉi ngayulu yilta kanyintjaku!” Katutjalu watjaṉu, “Kala, nintilkuṉanta. Kuka tjuṯatju ngalya katirra tjurra!, puluka kutju, tjiipi kutju, nanikuta kutju, ngatapuka kutjarra.” Yipumalu ngalya katirra pungkula tjananya tjunu. Kuka palunya kilytjuntankula tjunkula wanaṉu. Yalatji paluru palyaṉu, puluka tjiipi nanikuta. Tjuḻpu kutju, paluru winki kutjarra tjunu. Tjuḻpu kutjarra kilytjuntankuwiyangkukampa tjunu. Palulanguru Yipumanya nguḻu ngarrirra yanku puntulpi ngarringu. Katutjanya paluru tjukurrpa nyangu. Yalatji Katutjalu watjaṉu, “Nyuntupa walytja ngaṉṯitja tjuṯa ngula manta kutjupangka nyinamalpa. Palunyangkaya kutjupa tjuṯangku mayutju kuya tjuṯangku tjananya kanyinmalpa, paṉa palula. Yuwa, yilta tjana waarrkarringkula nyinamalpa, mayutju kuya tjuṯaku. Rawa puntuya nyinamalpa ngurra palula, puu yantaṯa yiiya. Ngurra palunya ngurrara tjuṯa, mayutjuṯarraṉa tjananya pungku. Palunyatjanu nyuntupa walytja ngaṉṯitja tjuṯa manta ngaakutuya ngalya yanku. Mani anta yulytja puḻkaya mantjira ngula ngalya yanku ngurra ngaakutu. Ngaangkalpiya kutu nyinamalpa.” ");
INSERT INTO piu2006_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","21","Tjiṉṯu palunya mungarringu. Palulanguru Yipumalu nyangu kaṉilpatjarra nguwanpa, ngalya yankunyangka, tjangi tili nguwanpatjarraṯarra. Palunya nyangu kuka pangkapungkula tjunutjawana ngalya yankunyangka. Palulanguru Yipumalu kuliṉu, Katutjalu watjaṉutjangka, “Yiltaṉa tjanampa manta ngaatjanya yungku, nyuntupa walytja ngaṉṯitja tjuṯaku. Ngurra tjanampa manta winki ngaraku. Wilurarra Yitjipilakutu maa ngaraku. Kakarrara karru yini Yupurititjalakutu maa ngaraku. Ngurra ngaa ngurrara tjuṯaku tjanampa yilta kanyilku, nyuntupa walytja ngaṉṯitja tjuṯalu.” ");
INSERT INTO piu2006_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","6","Yipumaku miiṯa Tjarayinya pipirri mantjintjawiya nyinangu, rawa. Palumpa waarrkana kungka Yayikanya tjungupula nyinangi, Yitjipinya ngurrara. Yipumanya yalatji watjaṉu, “Mayutju Katutjaluṉi marrkuṉu nguwanpa, pipirri mantjintjawiyaṉa nyinanyi. Palunyangka Yayikanyapulan ngarrinytjaku, pipirri ngayuku yutitjarrinytjaku.” Yipumalu yuwa wangkangutjangka Tjarayilu Yayikanya yaḻṯirra ngalya katirra ngaratjunu, Yipumaku, ngarrinytjakupula. Yayikanya tjunitjarrarringkula Tjarayiku yunytjuwiyara nyinangu. Palulanguru Tjarayilu Yipumanya watjaṉu, “Yayikanya yunytjuwiyatju nyinanyi, nyupalipulan ngarringutja. Tjungu ngarrinytjawiyangku nyuntu wantimara, ngayuku yunytjuwiya nyinatjipingkamarra.” Yipumalu Tjarayinya watjaṉu, “Yayikanya nyuntupa waarrkana nyinanyi. Nyuntu yunytjurrirra palyala!” Palunyatjanu Tjarayilu pikarringkula pungkutjipingkamarra Yayikanya nguḻulpi yanu. Ngula kutju, paluru ngalya yanu ngurra palunyakutu nyinangu. Palulanguru Yayikalu katjalpi mantjiṉu. Yitjumilanyalpi yiṯi ngarringu. Palulanguru Yipumalu yinilpi ngula watjaṉu, “Yitjumilanya”. ");
INSERT INTO piu2006_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","16","(17:1-6,15,16) Palulanguru Yipumanya rawalingku nyinangu, yiiya nayintiyi nayinpala. Palunyangka Katutjalulpi palunya watjaṉu, “Ngayuluṉanta mayutju tiṉa nyinanyi. Palunyangka nyuntu tjukarurru kutu nyinama!, kuya palyantjawiya. Ngayuluṉanta watjaṉi, nyuntupa walytja ngaṉṯitja, tjuṯalingku nyinaku.” Kulira Katutjanya waḻkulkitja Yipumanya waṯungarangu. Katutjalu piyuku watjaṉu, “Yiltaṉanta tjamu tiṉa nyinatjunku, ngurra kutjupa ngurrara tjuṯakuṯarra. Yini palunya Yipumanya wiyalpin nyinaku, yini kutjupalpin nyinaku, ‘Yipuramanya’.” Katutjalu Yipuramanya piyuku alatji watjaṉu, “Nyuntupa miiṯa Tjarayinya wiyalpi watjala!, yini palunya ‘Tjaaranyalpi’ watjala! Ngayuluṉanta watjaṉi, nyuntupa miiṯalu katja mantjilku, ngayuluṉara yungkunytjala. Manta kutjupa kutjupa ngurrara tjuṯaku Tjaaranya kapaḻi tiṉa nyinaku.” (17:9-14) Katutjalu Yipuramanya alatji watjaṉu, “Nyurrangarri tjukarurru kutu nyinanytjaku, ngayuluṉanta watjaṉutjawana. Nyuntupa kapaḻi tjuṯa tjamu tjuṯa wangka palulawana tjukarurru nyinanytjaku. Ngayuluṉanta watjaṉutjawana katja tjuṯanyurra tjamu ngaṉṯitja tjuṯa wati palyantjaku. Yalatji kutunyurra palyantjaku. Nyuntupaṉu pipirri maṉṯi yutirrinyangka tjiṉṯu tjapanpala ngarrinytjatjanu kutju nyuntu wati palyantjaku, nyuntupaṉu waarrkanakuṉuṯarra. Tjana watirrinytjatjanungka yaṉangu tjuṯalu kulilku, ‘Yipuramanyangarriya watirrinytja tjuṯalpi nyinanyi, Katutjalu manta yungkukitjangku tjananya watjaṉutjangka. Yilta Katutjaku walytjalingkuya nyinanyi.’” ");
INSERT INTO piu2006_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","15","Tjiṉṯu kaḻaḻa Yipuramanya tiinta yalytjurangka nyinangi. Palunyatjanu paluru nyangu wati maṉkurrpa, ngalya yankunytjala, tiintakutu. Nyakula tjanala yankula pupakatingu. Pakaralpi tjananya watjaṉu, “Ngurrakutuya ngalya yarra, wayinta yankunytjawiya! Puri palangkaya nyina!, kapiṉa nyurrampa mantjintjala, tjinaṉa nyurranya paltjintjaku. Kuka mayiṯarraṉa nyurranya yungku, ngalkuranyurra palya yankunytjaku. Yunytjurringanyiṉa nyurranya yaṉṯayaṉṯalkitja.” Kuliraya watjaṉu, “Yuwa, puringkalatju yankula nyinaku.” Yipuramalu yankula kukapa mayi mantjiṉu. Ngalya katirra tjananya yungu, puringkaya nyinanytjala. Ngalkulaya Yipuramanya tjapiṉu alatji, “Yaalytji Tjaaranya nyuntupa miiṯa?” Watjaṉu tjananya, “Tiinta palangka yila nyinanyi.” Palulanguru wati kutjungku watjaṉu, “Ngula, maanytja nayinpalangkaṉa ngalya yankunytjala Tjaaralu katja mantjilku.” Tjaaralu tiintangka yunngu nyinarra wangka paluru kuliṉu. Tjaaranya wulkumanu nyinangu, Yipuramanyaṯarra tjiḻpi nyinangu. Tjaaralu wangka palunya kulira purinypa yinkangu. Kuliṉungku, “Wiya wulkumanulu kutjuṉa katja mantjilku. Yipuramanyaṯarra tjiḻpilingku nyinanyi.” Wati palunya mayutju Katutjanya yilta ngarangu, yaṉangu nguwanpalingku. Alatjilu Yipuramanya tjapiṉu, “Nyaaku Tjaaranya yinkanyi? Walytjalungku watjaṉu, ‘Ulkumanulu wiyaṉa pipirri mantjilku.’” Tjaaranya nguḻurringkula wiya wangkangu, “Wiyaṉa yinkangu.” Mayutju paluru kuru watjaṉu, “Yuwa. Yilta nyuntu yinkangu.” Mayutju paluru piyuku watjaṉu, “Mayutju Katutjalu wiya puṯu palyalpayi. Panyapaṉanta watjaṉu, maanytja nayinpalangkaṉa ngalya pitjanyangka, Tjaaralu yilta katja mantjilku.” ");
INSERT INTO piu2006_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","33","Wati paluru tjana Yipuramanyaṯarra tjungu yanu puḻi murrpunguru Tjutumanya nyakukitja. Mayutju Katutjalu yaṉangu nguwantu watjaṉu, “Yaṉangu tjuṯangkuyanku watjaṉi, tawunu pala ngurrara tjuṯangkuya kuya puntu palyalpayi. Ngurra palulawanala yankula nyakulinkuku, yitjipungkukitjangku. Wanyula nyakunytjakuwarri yarra!” Wati paluru kutjarra yanu Tjutumalakutu. Katutjanya Yipuramanyapula tjungu ngarala wangkangi. Yipuramalu tjapiṉu, “Yilta tjananya nyuntu ngurra palunya ngurrara pungkula wiyalku, yuwankarra? Kutjupa tjuṯa palya nyinanyangka, wantikun? Tjinguru kuya palyalpayi kutju yitjipungkunytjaku? Tjinguru yaṉangu pipitiyipala palya nyinanyangka, wantiku tjananya?” Katutjalu kuliralpi watjaṉu, “Tjinguru yaṉangu pipitiyipala palya nyinanyangka, wantikuṉa tjananya.” Yipuramalu piyuku kulira tjapiṉu, “Tjinguru yaṉangu puutiyipala palya nyinanyangka, nyuntu wantiku?” “Yuwa wantikuṉa.” Yalatji Yipuramalu maṉkurrngara tjapiṉu Katutjanya. Palunyangka yitjipungkuwiyangku wantikitja wangkangu. Palunyatjanu Yipuramalu piyuku tjapiṉu, “Tjinguru yaṉangu tiinpala palya nyinanyangka, nyuntu tjananya wantiku?” Katutjalu watjaṉu, “Yaṉangu tiinpala tjinguru palya nyinanyangka, wantikuṉa tjananya.” Yalatji wangkarra Katutjanya yanu, kanya Yipuramanya palumpa ngurrakutu maḻaku yanu. ");
INSERT INTO piu2006_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","3","Wati paluru kutjarra nyaḻpitjarrarringkula anu tawunu Tjutumalakutu. Paluru kutjarra piyuku yaṉangu nguwanarringkula mungarrtji mungarrtjipula tjarrpangu. Laatalu pulanya ngalyananyingka nyangu. Paluru tjanala yankula tjungurringkula yanu palumpa ngurrakutu. Laatalu pulanya watjaṉu, “Ngayuku ngurrakutupula ngalya yarra, ngarrikitja! Tjiṉṯungkapulan palya ngarrirra yanku.” Laatanyapula watjaṉu, “Wiya. Palyalitju ngarriku ngaangka yurilta.” Ngurrangka tjarrpatjunkukitjangku pulanya watjaṉu. Palunyangkapula palumpa ngurrangka tjarrpangu. ");
INSERT INTO piu2006_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","11","Paluru kutjarra tjaapa ngalkuṉu ngarrikitja. Palunyatjanu wati tjuṯalpiya ngalya yanu waaḻakutu. Laatalu puṯu kuliṉu, wati tjuṯaluya parra yangatjunutjangka, palumpa ngurrangka. Laatanyaya watjaṉu, “Wati palunya kutjarra pulanya pakaltjingala!, ngaangkalatju nyinanytjaku.” Wati palunya kutjarra kungka nguwanpa kanyilkitjaluya kuliṉu. Laatalu kulira tuuwa yalytjurankula tjananya watjaṉu, “Walytja tjuṯa. Kulilaya! Wati palunya kutjarrangka wiyanyurra kuya palyantjaku. Ngayuku yuṉṯalpa kutjarra kutjuṉa nyurrampa ngalya katiku, watiku ngurrpa kutjarra. Palunya kutjarrangka kutjunyurra kuya palyantjaku.” Kuliraya mirrpaṉarringu waaḻangka tjarrpakitjaya. Palunya kutjarralupula Laatanya puulamilara yunngukutu, tuuwa patiṉu. Palunyatjanu paluru kutjarralupula kuru tjananya patiṉu, yatjikilu. Palunyangka kuru patirringkulaya puṯu kuliṉu. Tuuwakuya puṯu pampura wantingu. ");
INSERT INTO piu2006_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","21","Nyaḻpitjarra kutjarrangkupula Laatanya alatji watjaṉu, “Watjalkulitju tawunu ngaatjanya kamparra wiyantjaku. Yalatjingkamarra nyuntupa walytja tjuṯa tjananya waṉma kati! Mayutju Katutjalulinyatju wantirriyaṉu ngurra ngaatjanya nyakunytjaku. Kuwarri paluru kuliṉi ngurra ngaangka yaṉangu tjuṯa, kuwarri nyinanytja tjuṯanya wiyalkitjangku.” Laatalu pulanya mungangka puṯu watjaṉu waputju kutjarra pakara yankunytjaku. Laataku wangkapula kulira wantingu. Tjiṉṯukutu nyaḻpitjarra paluru kutjarralu tjananya puṯu watjaṉu, parrpaṯu yankunytjaku, Laatanyangarri. Palunyatjanu Laatanyangarri mara witira katingu, palumpa miiṯa yuṉṯalpa kutjarraṯarra. Tawunungka waṉma ngarala nyaḻpitjarra kutjulu tjananya watjaṉu, “Kana nyinakitjaya tjukarurru tjalkaḻuwa, puḻi nyarrakutu!, nguṉṯilangarala nyakunytjawiya.” ");
INSERT INTO piu2006_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","29","Tjalkaḻungkulaya Laataku miiṯalu waru kampanytjala taaṉarringkula nyangu. Nyakula puḻi nguwanarringu. Tjiṉṯurringkula Laatanyangarri ankula tawunu wiimangka tjarrpangu, yini Tjuuwangka. Palunyangka tawunu kutjarrangka katunguru waṉingu waru, Katutjalu, Tjutumangka anta Kumurangka. Ngurra pala kutjarra ngurrara, yaṉangu uwankarra kamparra wiyaṉu. Wangka palunya, Yipuramanya kulira Laatanyangarri kanaṉu, warungkamarra, Katutjalu. Tjiṉṯu palula Yipuramanya puḻi katu kaḻparra waru puyu puntu nyangu. ");
INSERT INTO piu2006_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","12","Mayutju Katutjalu yurrunpa watjaṉutjangka Tjaaranya pipirritjarralpi nyinangu. Nyinarra katjalpi mantjiṉu. Katja mantjintjala Yipuramalu yini palunya watjaṉu, “Yatjikanya.” Tjiṉṯu tjapanpala nyinangutjangka palunya watiṉu, Yipuramalu, Katutjalu yurrunpa yalatji palyantjaku watjaṉutjangka. Yatjika paluru yiṯitjanu maa tjinarringu. Tjungupula yinkangarapayi Yitjumilanya kutjarra. Yitjumilanya waarrkana Yayikaku katja nyinangi. Yinkangaralapula Yatjikaku pikapikarringu, Tjaaralu nyakunytjala. Nyakula Yipuramalakutu yankula watjaṉu, “Waarrkana palunya pulanya maamararra wantirriyala! Wiya Yitjumilalu kanyilku yulytja nanikuta pulukaṯarra, nyuntu wiyarrinytjala. Ngayukuṉulu yulytja kanyilku, Yatjikalu. Kala wantirriyala pulanya!” Yipuramalu katjaku puṯu kuliṉu, Yitjumilaku. Palulanguru Katutjalu watjaṉu, “Nyuntu pulanya palya wantirriyantjaku, Tjaaranya yunytjurringutjangka. Panyapaṉanta watjaṉutja kulila! Nyuntupa katjalu tjamupiṯi kapaḻipiṯi tjuṯa kanyilku, Yatjikalu. Ngurra tjiwarriwarriwanaya nyinaku.” ");
INSERT INTO piu2006_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","5","Palunyatjanu Yipuramanya yarrkantjakitjangku yaḻṯingu, Katutjalu. “Yipurama.” Kulira Yipuramalu watjaṉu, “Ngaatjaṉa ngaranyi.” Katutjalu piyuku watjaṉu, “Ngayuluṉa kuliṉi, nyuntu katjaku Yatjikaku puntura yunytjurringanyi. Katja palunya yaḻṯirra kati! Manta Murayalakutupula yarra! Nyupali yananyingka puḻiṉantapula nintilku, murrpu. Puḻi palula kaḻparra katja nyuntupa mirri puwa!, kunaṯinpa ngayunya yungkukitjangku.” Mungawinki pakara Yipuramalu waru kurrkalpa tjuṯa mantjiṉu karrpira yuṯitjunu tuungkiyingka. Yatjikanya waarrkana kutjarraṯarra pulanya yaḻṯingu. Yaḻṯirra tjananya katingu. Tjiṉṯu maṉkurrpa yankula Yipuramalulpi nyangu waṉma, ngurra palunya ngaranytjala. Waarrkana kutjarra pulanya watjalkatingu, “Tuungkiyipula kanyila ngaanguru!, nyarrakutulitju yananyingka, Katutjangka wangkakitja. Wangkarralitju maḻaku ngalya yanku.” ");
INSERT INTO piu2006_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","9","Yipuramalu watjaṉu Yatjikanya waru kurrkalpa katinytjaku, kanya Yipuramalu katingu tjuuḻa waru tjangiṯarra. Tjungupula yankula Yatjikalu kulira yaḻṯingu, “Mama.” Yipuramalu watjaṉu, “Nyaakuṉin tjapiṉi?” Yatjikalu watjaṉu, “Tjangi anta kurrkalpa kutjuli katiyananyi. Yaalytji Katutjanya kunaṯinpa yungkunytjaku?” Yipuramalu watjaṉu, “Katutjalulinya yungku, kunaṯinpa.” Puḻi palulapula kaḻparra Yipuramalu puḻingka tiipula nguwanpa palyaṉu. Waru kurrkalpa tjunkula Yatjikanya witira karrpira kurrkalta katuwana ngarritjunu. ");
INSERT INTO piu2006_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","14","Yipuramalu tjuuḻatjarra mara katurringu wakalkitja. Palunyangka ilkari ngurraralulpi palunya marrkuṉu, “Yipurama, kulila!” Yipuramalu watjaṉu, “Kuliṉiṉanta.” Ilkari ngurraralu piyuku watjaṉu Yipuramanya, “Katja nyuntupa wanti, wakalwiyangku! Nyuntu mularrpa pungamara katja nyuntupa, kaangkinytjingku. Nyuntu yilta Katutjaku kaangkinytji mularrpa.” Yipuramalulpi nguṉṯilangarala nyangu tjiipi watiyangku nganytjaṉutja. Kala palunyalpi Yipuramalu pungkula kunaṯinpa ngarritjunu, katja palumpakuṉu tjuungka. Yipuramalu ngurra palunya yini watjaṉu, “Katutjalu yungkupayinya”. ");
INSERT INTO piu2006_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","19","Katutjaku waarrkana yilkari ngurrara paluru Yipuramala piyuku alatji tjakultjunu, “Mayutju Katutjaluṉanta wangkanyi. Yilta tjukarurruṉanta palyalku. Nyuntupa katja kaangkinytjingku yilta ngarritjunu, mirri pungkukitjangku, kunaṯinpa yungkukitjangku. Yilta nyuntu ngayunya kuliṉu, katja kanyilwiyangku.” Katutjalu watjaṉu, “Nyuntu kuliṉi piṉṯirri tjuṯalingku, nyuntu mungangka nyakupayi. Nyuntupa walytja ngaṉṯitja, tjuṯalingku nyinaku, ngurra tjiwarriwarringka. Tali nyuntu puṯu kaantamilara wantiku, tali kutjupa tjuṯa ngaramalpa, waṉma. Yalatji nguwanpa nyuntupa walytja ngaṉṯitja tjuṯalingku nyinaku. Yaṉangu pungkupayi tjuṯangkamarra, ngayuluṉa tjananya yaṉṯayaṉṯara kanyinmalpa. Yilta nyuntupa tjamu tjuṯangku tjananya tjana payira wantirriyalku. Ngurra kutjupa kutjupa ngurrara tjuṯangku nyuntupa tjamu tjuṯanya nyakula kulilku, ‘Yilta Katutjalu tjananya yaṉṯayaṉṯara kanyiṉi. Palulanguru nganaṉalpi tjapintjaku, Katutjalu nganaṉanyalpi yaṉṯayaṉṯara kanyintjaku.’ Yilta nyuntupa tjamu tjuṯa tjukarurruṉa tjanampa kanyilku, nyuntu kaangkinytjingku katja nyuntupa ngarritjunu, mirri pungkukitjangku.” Katutjalu yalatji pulanya wangkangu. Palulangurupula Yipuramanya katja palumpa tjarukatirrapula yanu. Waarrkana kutjarrangkapula tjungurrirra yanu, ngurra Piitjipalakutu. Ngurra palula Yipuramanyangarri tjunguya nyinangi. ");
INSERT INTO piu2006_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","19","Tjaaranya yilungu, Yipuramaku miiṯa. Paluru rawalingku nyinangu wanaranangi yantaṯan tuuntiyi tjapan yiiyangka wiyarringu. Ngurra Yipurunala Yipuramanya miiṯawiyarringu. Tjana kulira yulangu. Paluru mirri wantirra yanu tjapilkitjalu, palumpa mirri miiṯaku manta payimilantjaku. Paluru tjapiṉu Yiitjaku tjamupiṯi manta payimilalkitjangku. Tjana wangkangu, “Yipuranaku ngurrangka kuḻpi yini Makapilanya ngaranyi.” Yipuramalu tjananya tjapiṉu, “Tjinguru nyurrangarri wati palunya tjapilku?, kuḻpi palunya ngayulu payimilantjaku?” Yipuranalu watjaṉu Makapilanya yungkukitjalu yinytjanulu. Kala Yipuramalu marrkuṉu manitjarrangku payimilalkitjalu. Paluru yilta payimilaṉu yaṉangu tjuṯangka kurungka, Yiitjaku tjamupiṯingka. Paluru maḻaku yanu palumpa walytja tjuṯakutu. Yipuramalu tjananya watjaṉu, “Ngayuku miiṯaṉa katirra kuḻpi Makapilangka ngarritjunku.” Palunyatjanu Yipuramalu katingu palumpa miiṯanya kuḻpingka tjunkunytjaku. Yipuramaku walytjapiṯiluya tjunkukatirra wantirra yanu. ");
INSERT INTO piu2006_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","9","Yipuramanya tjiḻpilingkulpi nyinangi. Mayutju Katutjalu palunya yaṉṯayaṉṯara purinypangku yungkula kanyiṉingi. Mani anta yulytja tjuṯatjarra nyinangi. Yipuramalu yaḻṯingu palumpa waarrkana tiṉanya. Paluru watjaṉu, “Ngayuku katja ngaangka nyinanyi miiṯawiya. Nyuntu yalinytjarra yarra!, ngayuku walytja tjuṯakutu. Yankulara miiṯa mantjira ngalya kati, Yatjikaku! Nyuntu tjukarurru yarra!, ngurra palulakutu. Wiya mantjintjaku ngurra ngaa ngurrara. Tjukarurruṉi watjala!, ngurra palunya ngurrara kutju mantjila! Yangkaḻpaṉi pampura tjukarurru watjala!” Yirriṯiya yalatji watjara wangkapayi, “Yangkaḻpaṉi pampula!” Yilta wangkakitjalu. Waarrkanalu Yipuramanya tjapiṉu. “Tjinguruṉa yankula ngurra palula puṯu tjapilku, nyuntupa katjaku miiṯa ngalya katinytjakitja. Tjinguruṉiya wiya watjalku. Wiya wangkanyingkaṉa yaalytjirriku? Tjinguruṉa ngalya yankula watjalku nyuntupa katjanya, yankula kungka palunya mantjintjaku.” Yipuramalu watjaṉu, “Wiya Yatjikanya ngurra palulakutu wantirriyantjaku. Ngurra ngaatjanya nyinarra kanyintjaku. Katutjaluṉi tjangkura yungu manta ngaatjanya, ngayulu kanyintjaku. Ngayuku walytja ngaṉṯitja tjuṯa kutu ngurra ngaangka nyinanytjaku.” Yipuramalu palumpa waarrkana piyuku watjaṉu, “Katutjalunta yilkari ngurrara ngalya wantirriyalku nyuntunya nintintjaku. Palurunta nintilku kungka palunya mantjira ngalya katinytjaku, Yatjikaku. Wiya wangkanyingka nyuntu wantirra ngalya yarra!” Yalatji waarrkana paluru yangkaḻpa pampura watjaṉu yankula miiṯa Yatjikaku mantjintjaku. ");
INSERT INTO piu2006_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","14","Palulanguru waarrkana tiṉa paluru watjaṉu kutjupa tjuṯanya kamula tiinpala mantjira ngalya katinytjaku, yankukitjangku ngurra yalinytjarra manta Mitjiputayimiyalakutu, Niyuwuku ngurrakutu. Rawaya yankula yankula ngurra palula mungarrtji tjarrpangu. Tawunungka waṉma kapi wiilangka tjana kamula tjuṯa pupatjunu, wiilangka yila. Mungarrtjiya kungka tjuṯaya kapi mantjilkitja ngalya yanu, wiilakutu. Palulanguru tjananya waarrkana tiṉalu nyangu kungka tjuṯa ngalya yananyingka. Paluru Katutjanya tjapiṉu, “Kulilaṉi! Nyuntu Yipuramaku mayutju tiṉa nyinanyi, kanya Yipuramanya ngayuku mayutju nyinanyi. Yipuramaluṉi ngayunya watjara wantirriyaṉu, Yatjikaku miiṯa mantjira katinytjaku. Nyuntu Yipuramanya watjaṉu ngayunya nintintjaku. Kuwarrilpiṉi nintila kungka palunya! Ngaangkaṉa wiilangka ngaraku kungka tjuṯaya ngalya yankula kapi mantjilkuya. Palulanguruṉa tjapilku kungka kutjuluṉi kapi yititjunkunytjaku, yalatji, ‘Turaama tjurra! Yititjurraṉi ngayulu kapi tjikintjaku!’ Palulanguru kungka paluru watjalku, ‘Yuwa, tjikila! Ngayuluṉa maṉmara yintilku nyuntupa kamula tjuṯaku, tjikintjaku.’” Mamalakutu piyuku wangkangu waarrkana paluru, “Kungkaṉi yalatji wangkanyingka ngayuluṉa yilta kulilku, ‘Yiltaṉa kuliṉi Katutjalu ngurrtjaṉu kungka ngaatja, Yatjikaku miiṯa nyinanytjaku.’” ");
INSERT INTO piu2006_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","27","Waarrkana paluru Katutjanya tjapira wiyarringutjangka, kungka Ripikanya ngalya yanu, Pitjulaku yuṉṯalpa, kapi maṉmalkitja. Wati paluru Niyuwuku katja nyinangi. Niyuwunya Yipuramaku maḻanypa nyinangi. Ripikalu turaama manyirrkangka katiyanangi. Kungka paluru yuṉpa palya ngarangi, watiku ngurrpa. Ngalya yankula wiilangka kapi maṉmara yanu katangka tjunkula, wayinta katikitjangku. Palunyatjanu waarrkana paluru maa wanara tjapiṉu, “Turaama tjurra! Kapiṉi yititjurra!” Kungka paluru Ripikalu watjaṉu, “Palyaṉanta kapi yititjunku.” Tjiḻpi paluru tjikira ngarangi, wangkanytjawiya. Ripikalu watjaṉu, “Ngayuluṉa nyuntupa kamula tjuṯaku kapi yintilku, tjana tjikintjaku. Rawangkuṉa maṉmara yintilku.” Tjuṯangara maṉmara tjanampa yintiṉu kaṉilpa tiṉakutu. Wiyarringutjangka Ripikanya ngarangi. Palunyatjanu waarrkana paluru riinga, kuultatjanu palyaṉutja mantjira yungu, kungka palunya mulya witintjaku. Riinga tiṉa kutjarra kutjupara mantjira yungu, manyirrkangka tjunkunytjaku. Yungkulara tjiḻpi paluru tjapiṉu, “Nyuntupa mama yini ngananya?” Ripikalu watjaṉu, “Ngayuku mama yini ngaatja Pitjulanya nyinanyi. Paluru tjiḻpi Niyuwuku katja, wulkumanu yini Milkakuṉu.” Tjiḻpi paluru piyuku tjapiṉu, “Palyalatju ngurra palula ngarriku, ngayuku waarrkana tjuṯaṯarra.” “Yuwa, palyanyurra ngarriku ngayuku mamaku waaḻangka. Waaḻa tiṉalampatju ngaranyi. Watiya yukiri tjuṯa ngaranyi, nyuntupa kamula tjuṯangku ngalkunytjaku.” Pupakatirra tjiḻpi waarrkana paluru Katutjanya yalatji waḻkuṉu, “Waḻkuṉiṉanta, Katutja nyuntu ngayuku mayutju Yipuramaku mayutju tiṉa nyinanyi. Nyuntuṉinu katirra tjukarurrungku nintiṉu Yipuramaku walytja tjuṯanya.” ");
INSERT INTO piu2006_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","53","Ripikanya tjalkaḻungu palumpa maamakutu anta kaakakutu tjakultjarra. Ripikaku kaakalu yini Liipanalu kulira tjalkaḻungkula wiilangka yaḻṯirra ngalya katingu tjananya, ngurra palumpakutu. Ngalya yankulaya tjarukatirra tjukarurru tjarrpangu waaḻa palula. Tjarrparraya nyinangi Yipuramaku waarrkana tjuṯanya ngalkunytjawiya wantirra. Waarrkana paluru watjaṉu, “Mangarri kuwarripa, wanti! Ngayuluṉa wangkakitja yunytjurringanyi.” Liipanalu watjaṉu, “Palyalinyatju watjala!” Liipanalu anta Piitjulalu kutjarralu kuliṉingi Yipuramaku waarrkanalu yara rawangku wangkangi, “Yalatjiṉa watjaṉi Yipuramaluṉi watjara wantirriyaṉu.” Watjara pulanya tjapiṉu, “Tjingurupulan Ripikanya ngayuku mayutjuku katjaku yungkuku? Tjingurupulan wiya kuliṉi. Wiya kuliraṉipula tjukarurru watjala! Wiya wangkanyingkaṉa ngayulu kulilku.” Liipanalu anta Piitjulalupula watjaṉu, “Mayutju Katutjalunta tjukarurru nintiṉu, panyapan nyuntu wiilangka wangkangi. Wiyalitju wiya wangkaku, Katutjalunta tjukarurru nintiṉu, kungka palunya. Palya nyuntu katiku Ripikanya Yatjikalu miiṯa mantjintjaku. Palyalatju kuliṉi.” Wangka palunya Yipuramaku waarrkananya kulira pupakatirra Katutjanya waḻkuṉu, waarrkana paluru. Waḻkura pakara Ripikaku yungu mani nguwanpa puḻi kuulta, puḻi tjiilpa puḻi kilaatja nguwanpa tjuṯa, mantarra palyaṯarra. Liipanakuṯarrara yungu mani kuulta nguwanpa tjuṯa. Ripikaku maamakuṯarra yungu puḻi mani kuulta nguwanpa. ");
INSERT INTO piu2006_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","67","Ngurra palunyangka nyinarra Yipuramaku waarrkanalu Ripikanya manta Kayinanalakutu mantjira katingu. Yankula yankulaya mungarrtji mungarrtji tjarrpangu Yipuramaku ngurrangka. Palunyangka tjananya Yatjikalu nyangu kamula tjuṯatjarra ngalya yananyingka. Yatjikanya yunyparringkula tjalkaḻungu tjanalawana paluru tjungurringu. Waarrkana paluru watjaṉu Yatjikanya, “Nyuntupa miiṯalatju ngalya katingu, Yipuramaku walytja.” Palunyatjanu Yatjikalu kulira Ripikanya yaḻṯirra katingu palumpa kalikikutu. Tjungupula miiṯararra yunypa rawa nyinapayi. ");
INSERT INTO piu2006_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","11","Yipuramanya tjiḻpirringkula wanaranangi yantaṯan tjapantiyi payipi nyinarra paluru wiyarringu. Palumpa katja kutjarrangku Yatjikalu anta Yitjumilalu katirrapula kuḻpingka ngarritjunu, palumpa miiṯa Tjaarala yila. Kuḻpi palunya yini Makapilanya Yipuramalu yurrunpa talatjarrangku payimilara wantingu, Yitatuku tjamu tjuṯangka, wati yini Yipuranala. ");
INSERT INTO piu2006_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","26","Yatjikanya yiiya puutiyipalangka nyinarra miiṯa mantjiṉu, Ripikanya. Rawapula nyinangi pipirri mantjintjawiya. Yatjikalura Katutjanya tjapiṉu. Katutjalu kuliṉu. Ripikanya tjunitjarra nyinangulpi. Pikatjarra nguwanpa nyinangi. Palulanguru Ripikalu tjapiṉu, Katutjanya. Mayutju Katutjalulpi watjaṉu, “Yiṯi kutjarranta yutirriku. Tiṉarringkulapula tjamupiṯi kapaḻipiṯi mantjilku. Katja yurruntitjaku ngaṉṯitja tjuṯa tjaalpa nyinamalpa, katja ngaṉṯitjaku tjuṯangkamarra. Yiltantapula yutirriku katja kutjarrapula. Katja ngaṉṯitja katja yurruntitjaku mayutjurrikura.” Palulanguru Ripikalu katja kutjarra mantjiṉu, tjiṉṯu kutjungka. Katja yurruntitja pangki tjatjaka ngarringi yinyu puntu. Palunyangka yini watjaṉu yalatji, “Yitjuwunya.” Katja palunya yutirringkula katja ngaṉṯitjalu luku witira kanyiṉingi, palumpa kuṯa. Palunyangka katja ngaṉṯitja yini yalatji watjaṉu, Tjikupanya. Palunya kutjarrapula yutirringu, Yatjikanya yiiya tjikitjiyingka nyinangi. ");
INSERT INTO piu2006_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","28","Pipirri paluru kutjarra tiṉarringkula Yitjuwunya wiḻinyi yankula kuka pungkulinkula ngalya katipayi. Palunyangka paapara Yatjikanya yunytjura nyinapayi, kuka wakalpayiku. Kanya Tjikupanya ngurrangka nyinapayi. Palunyangka Ripikanya yunytjura nyinangi. ");
INSERT INTO piu2006_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","34","Tjikupalu mangarri tjatjaka ngurrangka kutjalpayi. Yitjuwunya wiḻinyitjanu paḻtjatjirratja ngalya yanu. Ngalya yankula Tjikupanya tjapiṉu, “Mangarritjirratjaṉa. Mangarri tjatjakanyaṉi yuwa!” Tjikupalu palumpa kaakanya watjaṉu, “Kaaka. Nyuntu paapakuṉu yulytja tjuṯa mantjira kanyinmalpa, paapa wiyarrinytjala. Nyuntu watjalaṉi!, ngayululpiṉa yulytja tjuṯa mantjira kanyinmalpa. Yalatjitjun wangkanytjala, ngayululpiṉanta mangarri yungkuku.” Yitjuwulu parrpaṯu nguwanpa watjaṉu, “Palya nyuntulpi yulytja tjuṯa mantjilku. Mangarriṉi yuwa!, mangarriwiyaṉa nyinarra wiyarringkupayingka.” Tjikupalu mangarri yungkukitjangku watjaṉu, “Wanyu. Paapakuṉu yungkukitjaluṉi yilta watjala!, Katutjala kurungka.” Yitjuwulu watjaṉu, “Katutjangka kurungkaṉanta yilta nyuntulpi palya mantjintjaku, paapakuṉu yulytja tjuṯa.” Palunyangka Tjikupalu mangarri palunya Yitjuwukura yungu. ");
INSERT INTO piu2006_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","24","Yatjikanya nyinayinkula manta Kayinalawana tjiḻpirrirra kuru paangalpi, paluru nyinangi. Waarrkana yaḻṯirra watjaṉu, “Katja yurruntitjanya yaḻtirra ngalya kati!” Yitjuwunya ngalya yanu. Yatjikalu watjaṉu, “Katja. Nyuntu ngayuku ninti nyinanyi. Ngayulu waṯalpi tjiḻpirringulpi nyinarra wiyarringkukitja. Puwanarratjarrangku kuka wakaratju ngalya kati! Palunyangka kuka kutjaratju ngalya kati!, ngayuluṉa ngalkunytjakuṉa. Ngalkula Katutjanyaṉanta tjapilku, wiyarringkukitjangku. Katutjanya ngayulu tjapilku paluru nyuntupa tjukarurrungku palyantjaku. Yalatjilatju yirriṯi katja yurruntitjaku tjapilpayi.” Yatjikalu Yitjuwunya wangka panyapa watjaṉingka, Ripikalu pulanya kuliṉingi. Palulanguru Yitjuwunya kukakulpi yanutjangka Ripikalu yankula Tjikupanya watjaṉu, “Ngayuluṉa kuwarri kuliṉingi nyuntupa paapangku Yitjuwunya watjantjala Katutjanya tjapilkitjangku.” Ripikalu Tjikupanya marrkuṉu, yalatji, “Katja. Kulilaṉi! Ngayuluṉanta watjaṉi. Nyuntu yankula yalatji palyala! Yankula nanikuta kutjarra pungkula ngalya kati!, ngayuluṉa kutjantjaku nyuntupa paapaku, Yatjikaku. Paluru kuka yalatjiku yunytjurripayi. Palulanguru nyuntulpi kuka palunya katirra yungku. Nyuntupalpi Katutjanya tjapilku. Katutjalu nyuntupa tjukarurru palyalku.” Yirriṯiya tjiḻpirrirra katja yurruntitjaku Katutjalakutu tjapilpayi. Yalatji Tjikupalu kuliṉu, katja ngaṉṯitjalu. Paluru yalatji Ripikanya watjaṉu, “Ngayulu wangkanyingka paluruṉi kulilku katja ngaṉṯitja. Tjinguruṉi paluru pampulku, yinyuwiya. Yitjuwunya yinyu tiṉatjarra paluru kulilku. Ngunytjinytjunanyingkaṉi paluru kuru watjalku.” Ripikalu Tjikupaku maamangku watjaṉu, “Yalatji kulintjaku, wiya. Ngayuluṉanta watjaṉi, yankula palyala!” Palulanguru Ripikalu kuka palunya kutjaṉu. Ripikalu nanikuta pangki yinyutjarra mantjira Tjikupala karrpiṉu, miṉawana, nguṉṯiwana. Yitjuwuku mantarrangka tjarrpatjunkula Tjikupanya palumpa paapakutu wantirriyaṉu, kuka anta mangarritjarra. Yatjikanya tjiḻpi paanga nyinangi. Tjikupalu katirra watjaṉu, “Paapa. Ngayulu ngalya yanu.” Yatjikalu tjapiṉu, “Nyuntu ngananya? Nyuntu tjinguru katja yurruntitjanya, tjinguru katja ngaṉṯitja.” Tjikupalu ngunytji wangkangu, “Ngayulu katja yurruntitjanya, Yitjuwunya. Nyuntu panyapa ngayunya watjaṉu. Yankulaṉa kuka pungkula ngalya katingu. Pakara nyina! Kuka ngaatjaṉanta ngalya katingu, nyuntu ngalkunytjaku. Nyuntu ngalkura ngayukulpitju Katutjanya tjapila!” Yatjikalu tjapiṉu, “Ngayuluṉa puṯu kuliṉi. Nyuntu waṉmawana kukaku ngurrilpayi. Yaalytjiyaalytjikampa nyuntu parrpaṯulu yankula kuka wakara ngalya katingu, rawawiyangku?” Tjikupalu piyuku ngunytjinytjunu, “Nyuntupa mayutju Katutjaluṉi kuka parrpaṯu nintiṉu.” Yatjikalu piyuku watjaṉu, “Ngalya yarra, ngayulakutu! Yilarriwa!, ngayuluṉanta pampuntjaku. Tjinguru nyuntu Yitjuwunya ngaranyi, tjinguru nyuntu Tjikupanya.” Yatjikalu Tjikupanya pampura kutu kuliṉingi, watjaṉu, “Nyuntu Tjikupanya nguwanpa wangkanyi. Miṉa yinyu tiṉatjarra Yitjuwunya nguwanpa.” Tjikupanya puṯu nuumilaṉingi, yinyu Yitjuwunya nguwanpa pampura. Piyuku tjapiṉu, “Yilta nyuntu Yitjuwunya ngaranyi?” Tjikupalu ngunytji wangkangu, “Yuwa. Ngayuluṉa Yitjuwunya ngaranyi.” ");
INSERT INTO piu2006_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","29","Yatjikalu Yitjuwunya nguwanpa kulira watjaṉu, “Kuka panyapaṉi ngalya katirra yuwa! Ngalkuraṉa Katutjanya nyuntupa tjapilku.” Tjikupalu kuka anta tjurratja katirra yungu. Yatjikalu watjaṉu, “Nyunytjulaṉi!” Tjikupalu nyunytjuṉu Yatjikanya. Paluru tjaaṯa kukatjanu yakuri yiwarrtjura watjaṉu, “Nyuntupa tjaaṯaṉanta yiwarrtjunu kukatjanu yakuri.” Yitjuwunya nguwanpa kulira Yatjikalu Katutjalakutu yalatjilu tjapiṉu, “Ngayuluṉa yunytjurringanyi Katutjalunta yaṉṯayaṉṯara kanyintjaku, rawa. Paluru nyuntupa kapi puntu wantirriyantjaku, kulyarrpaṯarra. Kaana nyuntupa tjuṯa mangarri tiṉatjarra ngaranytjaku. Mangarri anta tjurratja tiṉatjarra nyuntu nyinanytjaku. Manta kutjupa kutjupa ngurrara tjuṯa nyuntupa waarrkana nyinaku. Nyuntupa walytja tjuṯaku, nyuntu mayutju tiṉa nyinaku, nyuntupa maamaku walytja tjuṯakuṯarra. Kutjupa tjuṯaluntaya wiyawanalu kuyalkitjalu yini watjaṉingka, Katutjalu tjananya ngaparrtjilu yiluntankuku. Kutjupa tjuṯaluya nyuntupa tjukarurru palyaṉingka, Katutjalu tjananya ngaparrtji tjukarurru palyara kanyilku.” Yalatji Yatjikalu Katutjanya tjapiṉu, Tjikupaku tjukarurru palyantjaku. ");
INSERT INTO piu2006_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","41","Yatjikanya panyapa Katutjalakutu wangkarra wiyarringu. Palulanguru Tjikupanya pakara yanu wayinta. Palunyangka palumpa kaaka Yitjuwunya ngalya yanu, wiḻinyitjanu. Kuka anta mangarri kutjara Yitjuwulu katingu tjiḻpi Yatjikaku. Paluru katirra yungu. Yatjikanya tiltirrmankula watjaṉu, “Nyuntupa maḻanypangkuṉi ngunytjinytjunangi. Nyuntunya nguwanpaṉanta kuliṉingi. Ngayuluṉa Tjikupaku Katutjanya tjapiṉu. Yalatji kutu ngaraku.” Yitjuwulu kulira yularra Yatjikanya watjaṉu, “Paapa ngayukuṯarratju Katutjanya tjapila!” Yatjikalu watjaṉu, “Ngayuluṉa kala wangkangu, Tjikupanya nyuntupa mayutju nyinanytjaku. Nyurrangarri palumpa waarrkana tjuṯa nyinaku. Katja kulila! Nyuntupaṉanta Mamanya tjapilkitjalu puṯu kuliṉi.” Yitjuwulu kutu tjiḻpi Yatjikanya watjaṉingi, “Katutjalakutu tjapila, ngayuku!” Yitjuwulu puṯu watjara yulangu. Palulanguru Yatjikalu Katutjanya tjapiṉu, “Katutjalunku wiya nyuntupa kapi anta kulyarrpa wantirriyalku. Nyuntupa kaana mangarri tjuṯatjarra wiya ngaraku. Pikaṯi tjuṯaluntaya nyuntunya tjuuḻa waṯawaratjarrangku pika pungku. Nyuntunu tjuuḻa waṯawaratjarra nyinaku. Nyuntupa maḻanypaku waarrkana nyuntu nyinaku. Nyuntupa maḻanypa, nyuntu wantirra yanku ngurra kutjupakutu, nyinakitja.” Yalatji Yatjikalu watjara wantingu. Palunyatjanu Yitjuwunya Tjikupaku mulyarralpi kutu nyinangu. Yitjuwululpi kuliṉu, “Ngayuku paapa yilunyingka ngaṉṯiṉa Tjikupanya mirri pungku.” ");
INSERT INTO piu2006_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","(27:46—28:5) Ripikalu Yatjikanya watjaṉu Tjikupanya wantirriyantjaku Yitjuwulu mirri pungkupayingka. Ripikalu watjara waarrkana tjuṯanya wantirriyaṉu, palumpa wangka kuliltjipingka. Palulanguru Ripikalu watjaṉu Yatjikanya, “Ngayuluṉa wiya Yitjuwuku miiṯa kutjarraku yunytju nyinanyi. Paluru kutjarra Yitatuku kapaḻi nyinanyi, walytjawiya. Tjinguru Tjikupalu kungka Yitatuku kapaḻi yaḻṯinyingka, ngayuluṉa wiya yunytju nyinaku.” Palunyangka Yatjikalu Tjikupanya yaḻṯirra watjaṉu, “Nyuntu wiya kungka ngaa ngurrara mantjintjaku, Kayinananya ngurrara. Nyuntu tjamu Piitjulaku ngurrakutu yankula miiṯa mantjila!, manta Mitjiputamiyalakutu. Ngurra palula nyuntupa kamuru nyinanyi Liipananya. Paluru yuṉṯalpa maṉkurrpa kanyiṉi, nyuntupa watjirra. Palya nyuntu mantjilku miiṯa. Yunytjurringanyiṉa Katutjaluntapula miiṯararra yaṉṯayaṉṯantjaku, katjapiṯi yuṉṯalpiṯi palya mantjintjaku. Nyuntu paapa tiṉa tjanampa nyinaku, tjuṯaku. Tjamu kapaḻi tjuṯatjarran nyinaku. Katutjalu Yipuramaku tjukarurru palyantja nguwanpa, nyuntupalpi Katutjalu tjukarurru palyantjaku. Nyuntu nyinarra pipirri tjuṯatjarra ngalya yankula manta ngaatjanya kanyintjaku. Katutjalu ngurra ngaatjanya Yipuramaku walytja tjuṯaku watjara yungu.” Yalatji Yatjikalu Tjikupanya Piitjulaku ngurrakutu watjara wantirriyaṉu. ");
INSERT INTO piu2006_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","5","(27:46—28:5) Ripikalu Yatjikanya watjaṉu Tjikupanya wantirriyantjaku Yitjuwulu mirri pungkupayingka. Ripikalu watjara waarrkana tjuṯanya wantirriyaṉu, palumpa wangka kuliltjipingka. Palulanguru Ripikalu watjaṉu Yatjikanya, “Ngayuluṉa wiya Yitjuwuku miiṯa kutjarraku yunytju nyinanyi. Paluru kutjarra Yitatuku kapaḻi nyinanyi, walytjawiya. Tjinguru Tjikupalu kungka Yitatuku kapaḻi yaḻṯinyingka, ngayuluṉa wiya yunytju nyinaku.” Palunyangka Yatjikalu Tjikupanya yaḻṯirra watjaṉu, “Nyuntu wiya kungka ngaa ngurrara mantjintjaku, Kayinananya ngurrara. Nyuntu tjamu Piitjulaku ngurrakutu yankula miiṯa mantjila!, manta Mitjiputamiyalakutu. Ngurra palula nyuntupa kamuru nyinanyi Liipananya. Paluru yuṉṯalpa maṉkurrpa kanyiṉi, nyuntupa watjirra. Palya nyuntu mantjilku miiṯa. Yunytjurringanyiṉa Katutjaluntapula miiṯararra yaṉṯayaṉṯantjaku, katjapiṯi yuṉṯalpiṯi palya mantjintjaku. Nyuntu paapa tiṉa tjanampa nyinaku, tjuṯaku. Tjamu kapaḻi tjuṯatjarran nyinaku. Katutjalu Yipuramaku tjukarurru palyantja nguwanpa, nyuntupalpi Katutjalu tjukarurru palyantjaku. Nyuntu nyinarra pipirri tjuṯatjarra ngalya yankula manta ngaatjanya kanyintjaku. Katutjalu ngurra ngaatjanya Yipuramaku walytja tjuṯaku watjara yungu.” Yalatji Yatjikalu Tjikupanya Piitjulaku ngurrakutu watjara wantirriyaṉu. ");
INSERT INTO piu2006_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","22","Ngurra Piitjipanya Tjikupalu wantirra maḻpawiya yanu. Yankula ngururrpa mungarringu. Ngurra palula lukurrmalawiya Tjikupanya puḻingka ngarringi kutunarringu. Ngarrirra tjukurrpa nyangu, mantatjanu katukutu Laata ngaranyingka. Laata palunyangka nyaḻpitjarra tjuṯa nyangu tjarukatingu kaḻpangulpi. Mayutju Katutjanya nyangu ngaranyingka, tjayiṯingka, Tjikupalu, kanya Tjikupanya wangkangu, “Ngayuluṉa Katutjanya ngaranyi, mayutju tiṉa, Yipuramaku, Yatjikakuṯarra.” Katutjalu Tjikupanya piyuku wangkangu, “Nyuntu kuwarri ngarrinyi manta ngaangka. Ngurra ngaatjaṉa nyurranya yunganyi, nyuntupa katja tjuṯaku, yuṉṯalpa tjuṯaku, piḻirri tjuṯaku. Ruunytjalingkuya yilta nyinaku. Manta ngaaṉiya ruunytjalingku nyinaku. Palulanguru yankulaya ngurra kutjupa kutjupangka nyinamalpa. Yalatjiya ruunytjalingku nyinaku, nyuntupa piḻirri tjuṯa. Nyuntupa piḻirri tjuṯakuṉa tjukarurru palyalku, kutjupa kutjupa ngurrara tjuṯakuṯarraṉa. Nyuntu ngurra Yaranalakutu yananyingka, ngayuluṉanta purinypangku katiyankuku. Ngulaṉanta ngalya katiku ngurra ngaakutu. Ngayuluṉanta watjaṉu yaṉṯayaṉṯalkitjangku. Wiyaṉanta wantiku, kutuṉanta purinypangku katiyankuku.” Tjikupalu tjukurrmankula nyakula kanarrirra watjaṉungku walytjangku, “Yilta, mayutju Katutjanya ngaangka nyinanyi, ngurrpaṉa ngalya yanu.” Tjikupalu nguḻurringkula watjaṉu, “Yilta, manta ngaatjanya Katutjaku ngurra, nguḻurringanyiṉa paluruṉi pungkutjipingka. Ngurra ngaangka yilkari yaḻa ngaranyi, yilkarikutu yankunytjaku.” Tjukurrpa nyakunytjatjanu piyuku tjiṉṯungkalpi pakaṉu. Puḻi katamala palunya mantjira ngaratjunu, kutjupa tjuṯangkuya ngula nyakula yalatji kulintjaku, “Yirriṯi Katutjanya ngurra ngaangka Tjikupangka wangkangu.” Puḻi palula paluru tjira yintiṉu. Yintira ngurra palunya yini watjaṉu, “Pitjilanya.” Palunyatjanu Tjikupalu Katutjanya watjaṉu yalatji, “Nyuntu ngayunya yaṉṯayaṉṯara mangarri, kuka, mantarraṯarra kutu yunganyingka, ngayuluṉangku tjukarurru nyinaku. Nyuntu ngayunya yaṉṯayaṉṯara ngayuku paapaku walytja tjuṯakutu maa katinyingka, palulanguru ngurra walytjakutulpitjunu piyuku maḻaku katiku ngayuku paapaku ngurrakutu, ngayuluṉanta kutu tjukarurru nyinamalpa. Puḻi ngaatjanya ngayulu ngaratjunu, tjuṯangkuya nyakula kulilku nyuntunya waḻkuntjakitjangku. Mani, mayi, yulytjaṯarra nyuntu ngayunya yungkula yaṉṯayaṉṯaṉutjangka, ngayuluṉanta nyuntunya wiima mantjira yungamalpa, ngaparrtjingku tjawirrilyi.” ");
INSERT INTO piu2006_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","14","Tjikupalu ngurra Pitjilanya wantirra yalinytjarra yanu. Rawa yankula kapi wiila nyangu pilangka. Wiila palunyangka yurrunpaya puḻi tiṉa yuṉṯura patilkitjalu ngaratjunu. Wiila palunyangkaya tjiipi tjuṯa ngarrirra waṉingi, kapuṯu kutjupa, kapuṯu. Tjiipiku mayutju tjuṯangku mungarrtji tjiipi tjuṯa ngalya katirra wiilangka yila tjunkula puḻi waṉirra yaḻalpayi, kapiku. Puḻiya ngaratjunkula kapi maṉmalpayi, tjiipiku kapi yungkukitjalu. Palulanguru tjiipiku mayutju tjuṯalu puḻi yuṉṯura wiila patilpayi. Tjikupalu tjananya nyangu tjiipiku mayutju maṉkurrpa, ngaranyingka. Tjana paṯaṉingi kutjupa tjuṯaku, tjungungku puḻi tiṉa yuṉṯuntjaku. Nyakula tjananya tjapiṉu, Tjikupalu, “Ngurra yaalytji ngurraranyurra?” Watjaṉuya, “Nganaṉatju ngurra Yaranalanguru ngalya yanu.” Tjikupalu tjapiṉu, “Wati Liipanakunyurra ninti? Tjiḻpi Niyuwuku tjamuku?” “Yuwa. Nintilatjura tjiḻpi Niyuwuku tjamuku.” Tjikupalu tjananya piyuku tjapiṉu, “Paluru palya nyinanyi?” Watjaṉuya, “Yuwa paluru palya nyinanyi. Nyawa, nyarratja Riitjilanya! Palatja Liipanaku yuṉṯalpa ngalyananyi, tjiipi tjuṯatjarra.” Riitjilanya yilarringu tjiipi tjuṯatjarra wiilakutu. Tjikupalu yankula puḻi tiṉa yuṉṯuyuṉṯura ngaratjunu, kutjungku. Palulanguru tjanampa maṉmara kapi yintiṉingi, Riitjilaku tjiipi tjuṯaku. Tjikupalu watjaṉu, “Ngayuluṉa watjirra nyuntupa. Ngayuluṉa Ripikaku katja.” Riitjilalu kulira tjalkaḻungu palumpa paapakutu, tjakultjunkukitja. Liipanalu kulira tjalkaḻungu Tjikupanya nyakukitja. Nyakula yilta Liipanalu Tjikupanya nyunytjuṉu. Nyunytjura yampura mara witira yaḻṯirra katingu ngurrakutu. ");
INSERT INTO piu2006_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","30","Liipanalu kanyiṉingi yuṉṯalpa kutjarra. Palumpa yuṉṯalpa yurruntitja yini Liiyanya, kanya kutjupa yini Riitjilanya. Riitjilanya yuṉpa palya nyinangi. Tjikupanya Riitjilaku yunytjurrirra nyinangi. Ngurra palula nyinarra Tjikupanya waarrkarringi. Palunyangka Liipanalu tjapiṉu, “Nyuntutjun rawa waarrkarripayi. Mani nyaa nguwanpaṉanta yungku?” Tjikupalu watjaṉu, “Wiya mani, waarrkarrimalpaṉanta yiiya tjapanpala nyinarra, Riitjilanyaṉinu yungkunytjaku.” Tjikupalu watjaṉu Liipananya, “Tjangkulatju Riitjilanya!, ngayulu ngulaṉa miiṯa mantjintjaku.” Liipanalu watjaṉu, “Yuwa. Palyaṉanta kuliṉi, nyuntu ngayuku yuṉṯalpa mantjintjaku. Palyanu ngaangka nyinanytjaku waarrkarrirra.” Tjikupanya rawa waarrkarrirra yunypa nyinangi Riitjilanya yaḻṯikitja. Tjikupalulpi Liipananya watjaṉu, “Kala, ngayuluṉa wiḻki yiiya waarrkarringu. Yuwaṉi nyuntupa yuṉṯalpa!, nyuntu tjangkuṉutja.” Palulanguru Liipanalu palumpa walytja tjuṯa yaḻṯirra kapuṯunu. Ngurra palulaya kuka tjuṯa kutjara yunyparrirra ngalkuṉingi. Palulanguru Liipanalu Liiyanya katirra wantikatingu Tjikupaku ngurrangka, mungangka. Tjikupalu kuliṉu, “Ngaatja Riitjilanya.” Palulangurupula ngurrangka ngarringi. Tjiṉṯungka Tjikupalu nyangu Liiyanya ngarringitjangka. Tjikupanyara Liipanaku mulyarrarringu paluru kikiri tjalkaḻungkula Liipananya kuru watjaṉu, “Nyaakuṉin ngunytjinytjunu? Ngayulu nyuntupa rawa waarrkarringu Riitjilanya mantjilkitjangku. Nyaakun nyuntu Liiyanya katirra ngayuku ngurrangka wantikatingu.” Liipanalu watjaṉu, “Nyuntu kulila! Ngurra ngaangkalatju yuṉṯalpa yurruntitja yungkupayi, watiku. Palulanguru yuṉṯalpa ngaṉṯitja yungkupayi, maḻa. Kuwarripa paṯala! Kuwarrilatju yunyparrirra maa Purayitiyirringkulaṉanta Riitjilanya yungku. Palya nyuntu kangkururra pulanya kanyilku. Nyuntu piyukutjun wiḻki yiiya nyinarra waarrkarriku.” Tjikupalu kulira yuwa watjaṉu, “Ngayuluṉanta waarrkarriku.” Liipanalu Riitjilanya Tjikupaku katirra yungu. Tjikupanyara yunyparringu puḻkara Riitjilaku, kanya Liiyakura tjukutjuku yunytjurripayi. Liipanalu kungka waarrkana kutjarranya katirra Tjikupaku ngurrangka wantikatingu. Riitjilaku waarrkana yini Pilananya, kanya Liiyakura waarrkana yini Tjilpanya. ");
INSERT INTO piu2006_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","35","(29:31—30:24; 30:25-43; 35:18) Tjikupanya rawa nyinarra Liipanaku ngurrawana waarrkarripayi. Paluru tjiipi anta puluka yaṉṯayaṉṯalpayi, Liipanaku. Palulanguru Liiyalura Tjikupaku katja tjuṯa kanyiṉu. Katja tjuṯa yini yalatji, Ruupinanya, Tjimiyananya, Lipayinya, Tjuutanya nyinangi. Kanya Riitjilanya pipirri wiyapilku nyinangi. Palulanguru Riitjilalu Tjikupanya watjaṉu palumpa waarrkanawana ngarrinytjaku, Pilanalawana, Riitjilaku pipirri mantjintjaku. Tjikupalawana ngarrirra Pilanalu yilta katja kutjarra mantjiṉu, Taananya anta Naputalinya. Rawa nyinarra Liiyalu puṯu kuliṉu piyuku pipirri mantjilkitjalu. Paluru Tjikupanya waarrkana palumpa katirra yungu ngarrinytjaku, Tjikupalawana, Liiyaku pipirri mantjintjaku. Yiltara Tjilpalu mantjiṉu katja kutjarra Kaatanya, Yaatjanya. Palunyatjanu Liiyalu piyuku katja kutjarra kutjupa mantjiṉu yini Yitjikanya anta, Tjipulananya. Palulanguru yuṉṯalpaṯarra mantjiṉu, yini Tayinanya. Riitjilanya rawa nyinangi pipirriwiya. Paluru rawangku tjapiṉu Katutjanya pipirriku. Katutjalu kuliṉu Riitjilanya, paluru pipirri mantjilkitjalu tjapiṉingi. Yiltalpi Riitjilalu katja kutju mantjiṉu, yini paluru Tjutjupanya. Manta kutjupangka Kayinanala Riitjilalu piyuku katja mantjiṉu, yini paluru Pintjiminanya. Tjikupakura yulytja tjuṯarringu, tjiipi anta nanikuta tjuṯarringu. Liipanaku tjiipi anta nanikuta tjuṯa Tjikupalu yaṉṯayaṉṯara kanyilpayi. Liipanalura tjiipi tjuṯa anta nanikuta tjuṯara yungu mani nguwanpa, Tjikupanya. Tjikupalu tjukarurru yaṉṯayaṉṯara waarrka palyalpayi, palunyangka Liipanalu tjiipi anta nanikuta yungu tjuṯalingku. Tjikupalungku walytjalu kanyilpayi tjiipi tjuṯa anta nanikuta tjuṯa, puluka, tuungkiyi kamulaṯarra. Paluru kanyilpayi waarrkana tjuṯa, palumpa waarrkarripayi. ");
INSERT INTO piu2006_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","43","(29:31—30:24; 30:25-43; 35:18) Tjikupanya rawa nyinarra Liipanaku ngurrawana waarrkarripayi. Paluru tjiipi anta puluka yaṉṯayaṉṯalpayi, Liipanaku. Palulanguru Liiyalura Tjikupaku katja tjuṯa kanyiṉu. Katja tjuṯa yini yalatji, Ruupinanya, Tjimiyananya, Lipayinya, Tjuutanya nyinangi. Kanya Riitjilanya pipirri wiyapilku nyinangi. Palulanguru Riitjilalu Tjikupanya watjaṉu palumpa waarrkanawana ngarrinytjaku, Pilanalawana, Riitjilaku pipirri mantjintjaku. Tjikupalawana ngarrirra Pilanalu yilta katja kutjarra mantjiṉu, Taananya anta Naputalinya. Rawa nyinarra Liiyalu puṯu kuliṉu piyuku pipirri mantjilkitjalu. Paluru Tjikupanya waarrkana palumpa katirra yungu ngarrinytjaku, Tjikupalawana, Liiyaku pipirri mantjintjaku. Yiltara Tjilpalu mantjiṉu katja kutjarra Kaatanya, Yaatjanya. Palunyatjanu Liiyalu piyuku katja kutjarra kutjupa mantjiṉu yini Yitjikanya anta, Tjipulananya. Palulanguru yuṉṯalpaṯarra mantjiṉu, yini Tayinanya. Riitjilanya rawa nyinangi pipirriwiya. Paluru rawangku tjapiṉu Katutjanya pipirriku. Katutjalu kuliṉu Riitjilanya, paluru pipirri mantjilkitjalu tjapiṉingi. Yiltalpi Riitjilalu katja kutju mantjiṉu, yini paluru Tjutjupanya. Manta kutjupangka Kayinanala Riitjilalu piyuku katja mantjiṉu, yini paluru Pintjiminanya. Tjikupakura yulytja tjuṯarringu, tjiipi anta nanikuta tjuṯarringu. Liipanaku tjiipi anta nanikuta tjuṯa Tjikupalu yaṉṯayaṉṯara kanyilpayi. Liipanalura tjiipi tjuṯa anta nanikuta tjuṯara yungu mani nguwanpa, Tjikupanya. Tjikupalu tjukarurru yaṉṯayaṉṯara waarrka palyalpayi, palunyangka Liipanalu tjiipi anta nanikuta yungu tjuṯalingku. Tjikupalungku walytjalu kanyilpayi tjiipi tjuṯa anta nanikuta tjuṯa, puluka, tuungkiyi kamulaṯarra. Paluru kanyilpayi waarrkana tjuṯa, palumpa waarrkarripayi. ");
INSERT INTO piu2006_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","55","Tjikupalu kuliṉu yara, palumpa watjirra tjuṯangku watjaṉutjangka. Yalatjiya watjaṉu, “Tjikupalu kanyiṉi nanikuta tjuṯa anta tjiipi, nganampa paapakuṉu mulyaṯangku. Paluru mani anta yulytja tjuṯatjarra nyinanyi, nganampa paapakuṉu.” Liipananya nyinangi mulyarra Tjikupaku. Palunyatjanu Katutjanya wangkangu, Tjikupalakutu, yalatji, “Nyuntu yarra maḻaku!, nyuntupa paapaku ngurrakutu, nyuntupa walytja tjuṯakutu.” Katutjanya piyuku wangkangu, “Ngayuluṉa nyurranya yaṉṯayaṉṯara katirinamalpa ngurra palulakutu.” Palunyangka Tjikupalu tjiipi tjuṯa kanyiṉingi Liipanaku ngurrangka waṉma. Tjikupalu wikarru watjara waarrkana wantirriyaṉu, Riitjilaku anta Liiyaku, palunya kutjarra yaḻṯirra ngalya katinytjaku. Tjungurrirraya wangkangu ngurra kutjupakutu yankunytjaku, manta Kayinanalakutu. Liipananya waṉma waarrkarringi, palumpa ngurrangka munkarra. Tjikupalu wiya waarrkana palumpa wantirriyaṉu Liipananya watjantjaku. Paluru tjana watjantjawiya yankukitjalu kuliṉu. Tjikupalu kamula tjuṯa pupatjunkula yulytja tjuṯa yurrara tjunu kamulangka. Palumpa waarrkanaṯarra paluru kaḻpatjunkula wantirriyaṉu. Tjikupalu tjananya watjaṉu “Yurrunpaya kati!, nanikuta tjiipiṯarra.” Paluru yanu, palumpa miiṯa kutjarraku anta pipirri tjuṯaku. Kamulangka tjananya kaḻpatjura yanu. Ngurra palula tjana Liipananyangarri wantirra yanu, watjantjawiya. Tjiṉṯu maṉkurrarrirra Liipanalu kuliṉu, Tjikupanyangarri kumpira yanutjangka. Liipananya anta palumpa waarrkana tjuṯangkuya wanara wirrkanu. Wirrkankula Liipananya pikarringu Tjikupaku, palumpa yuṉṯaltjirratja anta tjamu kapaḻitjirratja. Rawangkupulangku wangkangi pikangku. Palulangurupula wangkarra kalyparringulpi. Kalypa kutu nyinakitjalupula puḻi tjuṯa mantjira kapuṯu tjunu. Liipanalu watjaṉu, “Yiwarra ngaaṉili yankula, puḻi ngaatjanya ngula nyakula kulintjaku, kalypali nyinanytjaku.” Tjikupalu kulira yuwa watjaṉu, “Ngurra ngaatjanya yini Kilatanya.” Liipanalu yuṉṯalpa kutjarra anta tjamu kapaḻi tjuṯanya nyunytjura wantikatingu, paluru maḻaku ngurra walytjakutu yankukitjalu, kanya Tjikupanyangarri kutuya yanangi manta Kayinanalakutu. ");
INSERT INTO piu2006_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","21","Tjikupanyangarri yankula ngururrpa munga maṉkurrpa ngarrirra, paluru waarrkana maṉkurrpa watjara wantirriyaṉu, palumpa kaaka Yitjuwunya watjantjaku. Waarrkana maṉkurrpaya maa tjarrparra maḻaku parrpaṯu yanu Tjikupala watjalkitja. “Yitjuwunyangarri ngalya yananyi pikaku tjilirratjarra tjuṯa, yantaṯa puupala.” Tjikupanyangarri kulira nguḻurringu. Palunyatjanu Tjikupalu tjapiṉu, Katutjanya, “Katutja, nyuntuṉin watjaṉu ngayuku ngurrakutu maḻaku yankunytjaku. Yiltaṉin ngampuṯu yaṉṯayaṉṯalku? Ngayuluṉanta nguḻulu tjapiṉi, ngayuku kaakalu pungkupayingka. Panyapaṉin yirriṯi watjaṉu, nyuntulanyatjun yaṉṯayaṉṯantjaku, ngayuku walytja ngaṉṯitja tjuṯa nyinanytjaku ngurra Kayinanala, palya. Kanalalanyatju mirri pungkupayingka, maama tjuṯa anta pipirri tjuṯa!” Mungangkaya ngarrirra Tjikupalu pakara nanikuta tjuṯa kapuṯura wantingu, tuu yantaṯan tuuntiyi, Yitjuwuku wantirriyalkitjalu. Paluru palumpa waarrkana tjuṯa yaḻṯirra watjaṉu, “Nanikuta ngaanpanyaya kati yurrunpa!, ngayuluṉa ngaangka nyinanyingka. Yitjuwulu nyurranya nyakula yalatjilu tjapilku, ‘Nanikuta ngaan tjuṯa nganaku? Yaalytjikutunyurra katinyi?’ Yalatjiluya watjala! ‘Ngaa tjuṯa yinytjanulunta yiyaṉu, nyuntupa waarrkanalu, Tjikupalu. Paluru maḻawana ngalya yananyi.’” Palunyatjanu Tjikupalu waarrkana kutjupa tjuṯanya yaḻṯirra watjaṉu, “Nanikuta tjuṯaya katingu. Ngaṉṯiwanaluya tjiipi tjuṯa kati!, tuu yantaṯan tuuntiyi. Ngayuluṉa nyinanyi. Yitjuwulu nyurranya nyakula yalatjilu tjapilku, ‘Tjiipi ngaan tjuṯa nganaku? Yaalytjikutunyurra katinyi?’ Yalatjiluya watjala!, ‘Ngaa tjuṯa yinytjanulunta yiyaṉu, nyuntupa waarrkanalu, Tjikupalu. Paluru maḻawana ngalya yananyi.’” Palulanguru piyuku paluru wantirriyaṉu kamula wiima tjaatiyipala anta puluka pipitiyipala, tuungkiyi tjaatiyipala. Tjikupalu kulira wantirriyaṉura, “Yitjuwulu kuka tjuṯa nyakula tjingurutju kalyparriku, yirriṯiṉa ngayulu ngunytjilyinutjangka.” ");
INSERT INTO piu2006_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","32","Tjikupalu tjananya watjara iyaṉu palumpa walytja tjuṯanya yurrunpa yankunytjaku. Tjana karru Tjapukanya wantikatirra yulparirra tjayiṯi paṯara ngarringu, Tjikupaku miiṯa kutjarra anta palumpa pipirri tjuṯa, kanya Tjikupanya karrungka yalinytjarra kutju nyinangi, paluru Katutjalakutu wangkakitja. Mungangka nyaḻpitjarra yaṉangu nguwanpa ngalya yankula Tjikupanya yampura palykupungkulapulanku puṯu paḻira mantangkapulanku kanyiṉingi. Yalatjipulanku palykupungkula tjiṉṯurringu. Yilkari ngurraralu kuliṉu, “Ngaangkuṉi Tjikupalu piitamilaṉi.” Palunyatjanu Tjikupanya tjunta paḻira pulyku kilytjuntanu. Palulanguru Tjikupanya nyumpurringu. Kutu Tjikupalu wati palunya ngamira kanyiṉingi. Wati yilkari ngurraralu watjaṉu, “Ngamilwiyaluṉi wanti!, tjiṉṯurringu.” Tjikupalu watjaṉu, “Wiya. Ngamiraṉanta kanyiṉi nyuntu Katutjanya tjapintjaku, ngayuku.” Kulira wati paluru Tjikupanya tjapiṉu, “Yinin ngananyan?” Tjikupalu watjaṉu, “Ngayuluṉa Tjikupanya.” Wati paluru piyuku tjapiṉu, “Nyuntunya, wiyantaya Tjikupanya watjalku, nyuntupa yini kutjupa. Nyuntunyantaya Yitjurilanya watjalku.” Tjikupalu tjapiṉu, “Yinin ngananyan? Watjalaṉi!” Kanya wati paluru watjaṉu, “Wiya ngayunya yiniku tjapintjaku.” Yalatji wangkarra paluru Tjikupaku Katutjanya tjapiṉu. Wati paluru ngarala wiyarringu. Tjikupalu puṯu kuliṉu, “Kuwarriṉa Katutjanya nyangu. Ngayuluṉa nyakula yilumara. Yilta ngayuluṉa kana kutu nyinanyi. Palunyangka ngurra ngaatjanyaṉa yini watjalku, ‘Katutjanya yuṉpa.’” ");
INSERT INTO piu2006_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","20","Tjikupalu tjananya nyangu waṉmanguru Yitjuwunyangarri ngalya yananyingka, tjilirratjarra tjuṯa. Palulanguru nyakula kungka waarrkana palunya kutjarra maamararranpa tjananya Tjikupalu yurrunpa ngaratjunu. Ngaṉṯiwana tjananya ngaratjunu Liiyanya anta Riitjilanya, pipirri tjuṯatjarra. Tjikupalu tjananya ngaratjunkula maa wayintarrirra Yitjuwukutu maa yankula tjaṉṯarrngarala pupakatingu, tjapanpalangara. Yalatjiya yurrunpa palyalpayi yunngurrirraya pakalpayi, mayutju tiṉa ngalya yananyingka. Yitjuwulu nuumilara ngalya tjalkaḻungkula Tjikupanya yampura nyunytjuṉu. Yampurapula yulangi. Yitjuwulu nyakula tjapiṉu, “Ngananyangarri nyarratja?” Tjikupalu watjaṉu, “Mayutju Kututjaluṉi yungu pipirri nyarra tjuṯa.” Palunyatjanupula rawa wangkangi. Yitjuwunyalpi wangkangu, “Katikulatju nyurranya ngayuku ngurrakutu, kutjupa tjuṯalu nyurranya pungkutjipingkamarra.” Tjikupalu watjaṉu, “Wiya, nganaṉatju maḻawana maa yankuku, purinypa. Nyurrangarri yurrunpa maa yarra!” Palunyatjanu Tjikupanyangarri ngaṉṯiwana paṉa Kayinanalakutu maa anangi. Yankulaya ngurra Tjakutjala nyinangi. Palunyatjanu yankulaya tawunu Tjikimala yila nguwanpa nyinangi. ");
INSERT INTO piu2006_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","19","Katutjalu Tjikupanya watjaṉu, “Yarraya ngurra Pitjilalakutu! Ngurra palulaṉanta ngayulu yurrunpa yutirringu, nyuntu Yitjuwulamarra nguḻu tjalkaḻungu. Yankula puḻitjanu palyala tiipula nguwanpa!, ngayunyaṉin puḻkawaṉikitjangku.” Palulanguru watjaṉu tjananya Tjikupalu, “Kulilaya!, ngurra ngaatjanyala wantikatinyi, yankulala ngurra Pitjilala nyinanytjakitja. Kulilaya wangka ngaatjanya! Kutjupa ruunytjalunyurra Katutjanya nguwanpa waḻkulpayi, wiyawanalu. Nyurrangarri kuwarri wantinytjaku, Katutjanya kutju waḻkuntjaku. Yankulaya mantjila Katutjanya nguwanpa!, nyurrangarri waḻkulpayi. Yankulaya mantjira ngalya katirra, ngaṯingka tjawara tjarrpatjurra! Palunyatjanu nyurrangarri mantarra nyuwanatjarra nyinama! Palunyatjanu yankulala ngurra Pitjilala tiipula nguwanpa puḻitjanu palyalku, Katutjanya waḻkulkitjangku. Yurrunpa ngayunya Katutjalu yaṉṯayaṉṯara katiyankupayi. Ngayukutju maḻpa yulytjayankupayi.” Palunyatjanuya yankulaya Katutjanya nguwanpa yurrunpa palyantjatjanu, mantjiraya ngalya katirra ngaṯingka waṉingu. Tjikupalu watiya palunya tjuṯa tjawara ngaṯingka tjutuṉu, tawunu Tjikimala ila kurrkara kutju ngarapayi. Palulanguru ngurra Pitjilalakutuya yanu. Yankulaya puḻitjanu palyaṉu tiipula nguwanpa. Palulanguru ngurra palula Katutjalu Tjikupanya watjaṉu, “Nyuntu yini Tjikupanya watjalpayintaya. Kuwarri ngayuluṉanta yini kutjupa tjunanyi, ‘Yitjurilanya.’ Ngayuluṉanta kaṉṯilya puntutjarrangku watjaṉi. Nyuntupa walytja ngaṉṯitja ruunytja nyinaku. Ngurra kutjupa, ngurra kutjupa tjiwarriwarriwanaya nyinaku, nyuntupa ngaṉṯitja tjuṯa. Kutjupa tjuṯaya mayutju tiṉa nyinaku. Yirriṯiṉa pulampa manta ngaatjanya Yipuramaku Yatjikaku yungu, yurrunpa. Kuwarriṉanta nyuntunya yunganyi, manta ngaatjanya, nyuntupa ngaṉṯitja tjuṯangku witira kanyintjaku.” Palunyatjanu ngurra Pitjilanyaya wantirra Yaparatjalakutu yanu. Yankulaya ngururrpa nyinangi, Riitjilalu iṯi mantjiṉutjangka. Riitjilalu pipirri wiima mantjira pika puntutjarrarringkula ilungu. Palunyatjanuya puntura ularra mantangka tjawara tjarrpatjunu. Pipirri wiima paluru iṯi ngarrinytjala Tjikupalulpi yini tjunu, “Pintjiminanya.” ");
INSERT INTO piu2006_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","29","Palulanguru Tjikupanyalpi yanu palumpa paapa nyakunytjakitja, kutjupa ruunytjaṯarraya yanu palulawana, ngurra Mamarilakutu. Ngurra Mamarinya ngurra Yipuranala ila ngarangi. Ngurra palula Yatjikanya nyinarra ilungu. Tjiḻpi paluru rawa nyinangi, waan antaṯa an yayitiyi yiiya. Palulanguru Yitjuwulu anta Tjikupalu tjawara mantangka tjunu. ");
INSERT INTO piu2006_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","4","Tjikupanyangarrilpiya manta Kayinanalawana nyinapayi, palumpa paapaku ngurrawana. Palumpa katja ngaṉṯitja Tjutjupanya nyinarra tiṉarringulpi. Tjutjupaku kaaka tiṉa tjuṯangkuṯarralpiya kanyilpayi tjiipi, nanikutaṯarra. Wiya tjana puraapawayi yaṉṯayaṉṯalpayi, ngunytji tjana kanyira kumpira yankupayi. Palulanguru Tjutjupalu yankula Tjikupangka tjakultjunu, “Ngayuku kaaka tjuṯangku nanikuta tjiipi kanyira kumpira yankupayi. Wiyaya puraapawayi kanyilpayi.” Palulanguru palumpa kaaka ruunytjalpi kulira ngurrkurringuya Tjutjupaku. Tjikupanyalpi Tjutjupakulpi puntura yunypa nyinangu, katja ngaṉṯitjaku. Tjikupalu kuuta waṯawara palyara yungulpira Tjutjupa palumpa. Alatji Tjutjupaku yungutjangka, palumpa kaaka ruunytjalpiraya ngurrkurringkula nyinangi. Rawa, kuturaya ngurrku nyinapayi, Tjutjupa palumpa. ");
INSERT INTO piu2006_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","11","Palunyatjanu Tjutjupalulpi tjukurrmara nyangu, mungangka. Palulanguru mungawinkilpi pakara ankula palumpa kaaka ruunytjangka tjakultjunu, “Kulilaya! Mungangkaṉa ngarrirra tjukurrpa nyangu. Nyanguṉa wiita nganaṉa tjungungku muṯura tjunkulinangi. Wiita palunya tayimapirala tjunkulinangi. Ngayulu tayimapira ngarritjunutja wiita palunya, paluru pakara tjukarurrulpi ngarangi mayutju tjukarurru ngaranytja nguwanpa, kanya nyurrangarrimpa wiita tayimapira tjunutja pakara mantawana ngarringi. Nyurrangarrimpa wiita waarrkana nguwanpa ngarringi.” Palunyatjanu palumpa kaaka ruunytjangku kuliralpiya palunya watjaṉu, “Nyuntu wiyalampatjun mayutju nyinaku. Nyuntu ramaramalu kuliṉi.” Palunyatjanu palumpa kaaka ruunytjaya palumparaya ngurrkurrirra nyinangi. Palunyatjanu munga kutjupangka Tjutjupalu piyuku tjukurrmara nyakula kaaka tjuṯa watjaṉu, “Kulilaya! Alatji ngaa nguwanpa nyanguṉa. Tjiṉṯu, pira piṉṯirri lipinpala ngaa tjuṯaṉa nyangu, ngayuku nguwanpatjuya waṯungarakatirra waḻkuṉingiṉiya.” Palunyatjanu paluru palumpa paapakutulpi yankula tjakultjunu. Tjakulpa palunyalpi Tjikupalu kulira kuliṉu, “Tjinguru alatji ngaa nguwanpa paluru nyinaku, nganaṉa palunya waḻkunmalpa, tjinguru.” Palunyatjanu Tjikupalulpi kulira palunya watjaṉu, “Wiyawana nyuntu ramaramalu nyangu. Wiyalatjunta nyuntunya waḻkulku.” Tjikupalulpi parra ulytjarra rawangku kulirinangi, “Tjinguru paluru ngula mayutju puntu nyinaku”, kanya palumpa kaaka ruunytjalpi rawaraya ngurrku nyinapayi. ");
INSERT INTO piu2006_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","30","Palunyatjanu Tjutjupanyalpi nyinapayi, palumpa paapaku ngurrangka, ngurra paluru Yipurunanya. Palunyatjanu palumpa paapangkulpi palunya watjaṉu, “Nyuntupa kaaka ruunytjaya nyarrangka nyinanyi, ngurra Tjikimala. Yankula tjananya nyawa, Tjikimala! Tjinguruya nanikuta anta tjiipi ruunytja palya kanyiṉi. Palunya tjuṯaṯarra tjananya maa nyawa! Tjinguruya palya nyinanyi? Maa nyakula tjananya ngalya yankulaṉi tjakultjurra!” Palunyatjanu paluru yanulpi maḻpawiya. Yankula tjanampa puṯu ngurririnangi, ngurra Tjikimanyaṯarra puṯu nyakulinangi. Palunyatjanu wati kutjupalpi tjapiṉu, “Nyuntu, ngayuku kaaka ruunytja nyangu?” “Yuwa. Nyanguṉa nyarratjaya yanu ngurra Tuutjanalakutu.” Palunyatjanu paluru yankula nyangu tjananya. Paluru tjana tjiipi nanikutaṯarra kanyiṉingi. Paluru waṉmanguru tjananya nyangangi. Tjutjupanya tjana nyakula palumpa kaaka tjuṯa wangkapayiya, Tjutjupanya mirri pungkukitja. “Mirrilaka palunya pungkula waṉi, wiila palula! Wiila kapiwiyangkala pungkula waṉi! Palunyatjanu yankulalaka ngunytji tjakultjurra!, layina pikaṯilu patjaṉutja. Palunyatjanu wiya tjukurrpa nyakupayinya kana nyinaku, mirrilaka puwa palunya! Paluru wiyalampa mayutju nyinanytjaku.” Palunyatjanu palumpa kaaka tiṉangkulpi Ruupinalu watjaṉu tjananya, “Kulilaya! Palunya wiyalaka mirri puwa! Pungkuwiyangkula palunya kana tjarrpatjurra wiila palula! Palulangurulpila palunya wantirra yanku.” Yalatji ngaa nguwanpa tjananya watjaṉu Ruupinalu, tjana yankunytjala, ngaṉṯi paluru pakaltjingara wantirriyantjakitjangku, palumpa paapalakutu. Tjutjupanya ngalya yankula ngaranytjala paluru tjana witira kuuta palumpa yarrara palunya katirra wiilangka tjarrpatjunu. Palunyatjanu ngurrakutulpiya ngaṉṯikutu yankula mayi kuka ngalkuralpiya nyangu, kutjupa ruunytjaya ngalya yanangi, kamulatjarra. Luutu tiṉalingkuya katiyanangi. Yaṉangu paluru tjana Yitjumilaku walytja ngaṉṯitja tjuṯa ngalya yanangiya. Paluru tjana manta ngurra Yitjipilakutu yankunytjakitjaya ngalya yanangi. Palunyangka Tjuutalulpi tjananya marrkura watjaṉu, palumpa maḻanypa tjuṯangkalpi, “Wiyala iluntankunytjaku panya palunya. Yaalytjinyurra kuliṉi? Nyarra tjuṯangkala tjalamilala! Nyarra paluru tjana ngurra waṉmakutu ananyi.” Ngaatjanya Tjuutalu tjananya palumpa maḻanypa tjuṯakutu kulira watjaṉu. Tjana palunyalpi kuliraya yunyparringu. Palunyatjanu Tjutjupa palunyalpiya yankula mantjilkatingu, paluru tjana wiilangka tjarrpatjura waṉikatingutja. Palunyatjanuya tjalamilaṉu kamulatjarra tjuṯangka mani tjiilpa tuwintiyipala nguwanpa. Palunyatjanu Ruupinanya ngurra kutjupangka yankula nyinangitjangka tjana palunya wiyangka ngaṉṯiya tjalamilaṉu, palumpa tjanampa kaaka tiṉa ngurra kutjupakutu yanutjangka. Palunyatjanu Yitjumilaku ngaṉṯitja tjuṯangku katinguya ngurra yini Yitjipilakutu. Palunyatjanu Ruupina paluru rawa nyinarra ngalya yankula puṯu nyakula maḻanypa palunyatjirratjangku kuuta palumpa, wintarrpungu. Paluru maḻanypa palunyatjirratja puntura yulatjarrarringkula nyinangi. ");
INSERT INTO piu2006_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","35","Tjutjupaku kaaka ruunytjangku kuuta palumpaṉungka nanikutatjanu ngurrka kaṉilpangkaya yintiraya kanyiṉingitjangku, kuuta palumpaṉu nyapaṉu ngurrka palunyatjarrangku. Palunyatjanu palumpa paapakutu katirraya nintiṉu, kuuta palunya. Paluru tjana ngunytjinytju ngurrpa nguwanpa wangkangi, “Kuuta ngaatjanyalatju mantangka ngarringitja mantjiṉu. Tjinguru kuuta ngaatjanya nyuntupa katjaku?” Palunyatjanu Tjikupalulpi mantjira kuuta palunya nyakula watjaṉu, “Yuwa, ngaatjanya ngayuku katjaku kuuta. Tjinguru layina pikaṯingku patjara waṉingu. Yuwa, kuunyi ngayuku katjatju layinangku patjaṉu.” Tjutjupanya yilungutja nguwanpa Tjikupalu rawa kulira yulapayi. Paluru rawa yularra watjilarripayi nyinangi. ");
INSERT INTO piu2006_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","6","Yitjumilaku ngaṉṯitja walytja palunya tjuṯangkuya katirra Tjutjupa palunya tjalamilaṉu, ngurra Yitjipila. Mayutju Patipa paluru payimilaṉu. Mayutju Katutjalu palunya kaṉṯilya puntu palyaṉutjangka Tjutjupa palurulpi ngurra palulalpi paluru rapa waarrkarripayi. Palunyatjanu Tjutjupanya mayutju nyinatjunkukitjalu kuliṉingi. Tjutjupanya waaḻaku mayutjulpi nyinatjunu. Mayutju Patipa palumpa yulytja ruunytja paluru nyakula kanyilpayi. Waarrkana palumpa tjuṯakulpi tjanampa Tjutjupanya mayutju puntu nyinapayi. ");
INSERT INTO piu2006_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","18","Tjutjupanya yuṉpa palyalingku nyinapayi. Palunyatjanu Patipaku miiṯalpi paluru palumpa yunytjurringangi. Minyma palurulpi Tjutjupanya tjapiṉu ngurrangkapula ngarrikitjangku. Tjutjupalulpi minyma palunya watjaṉu, “Wiya. Ngayuku mayutjuluṉi nyinatjunuṉi waaḻa ngaaku mayutju. Palunyatjanu mayutju Patipanya yulytja ngaa tjuṯaku wiya paluru kuliṉi. Paluru yunypa nyinanyi, ngayuluṉara yulytja ngaa tjuṯa kanyiṉingka. Nyuntunya kutjuṉanta wantinytjaku, palumpa miiṯa. Nyuntunyaṉanta kanyira Katutjangka mirangka kurraṉanta palyaltjipingka.” Tjiṉṯu kutjupa tjiṉṯu kutjupangka tjapira ngarapayi minyma paluru Tjutjupangka ngarrikitjalu. Tjutjupa paluru kutu wiya watjalpayi. Tjutjupa palurulpi rawa waarrkarringkula yaatjayiṯi yankula parra waarrkarringiya. Rawa parra waarrkarringkula paluru kutju yanu ngurrangka yunngu waarrkarrikitja, kanya minyma Patipaku miiṯa paluru kutju yunngu waaḻangka nyinangi. Tjutjupanya yunngu tjarrpangutja minyma palurulpi nyakula ngalya yankula kuuta witira watjaṉu, “Yarralika ngurrangka ngarrinytjaku!” Kuuta palunya witiṉutjangka paluru yirriwiltjira tjalkaḻungu, kanya minyma paluru kuuta palumpaṉunya kanyiṉingi, paluru tjalkaḻungutjangka. Kanya minyma paluru kuuta kutju kanyira, paluru puntura ngurrkurringura. Minyma palurulpi yankula tjananya parrpaṯu yaḻṯingu, waarrkana waaḻangka waarrkarripayi tjuṯanya. Ngalya yankulalpiya waarrkana palunya tjuṯa ngarangitjangka tjakultjunu tjananya, “Kuuta ngaatjanyaya nyawa! Wati kutjungku Yipuru wangkatjarrangkuṉi ngarritjunkukitjangku palykupungkula tjalkaḻungu. Palunyangka ngayulu katu mirrangutjangka paluru nguḻu tjalkaḻungu, kuuta ngaatjanyalpi waṉikatingu.” Minyma palurulpi paṯara kanyiṉingi palumpa miiṯa tjakultjunkukitjalu. Patipanyalpi ngalya yanutjangka minyma palurura tjakultjunu, Tjutjupalukunyu ngarritjunkukitjalu palykupungu. ");
INSERT INTO piu2006_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","23","Palulanguru Patipa paluru iltarringkula watjaṉu tjananya Tjutjupanya witira katirra nyinatjunkunytjaku tjiilangka. Tjiilangka nyinanytja mayutju Katutjalu yilangku nyakula kanyiṉingi. Tjutjupanya tjukarurru nyinanyangka tjiilaku mayutju pukuḻpara nyinangi. Mayutju paluru Tjutjupanya nyinatjunu tjiila ngurrara tjuṯanya palyangku kanyintjaku. Tjutjupalulpi tjananya waarrkarrirra palyangku aṉṯaṉṯaṉingi. Mayutju Katutjalu palunya rapaṉu. ");
INSERT INTO piu2006_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","23","Ngurra Yitjipiku mayutju puḻkara pulampa ngurrkurringu waarrkana kutjarraku. Wati kutjungku mayutjuku pulakina tjutira yungkupayi, kanya wati kutjupangku mayi kutjara mayutjuku yungkupayi. Mayutju paluru tjananya watjaṉu palunya kutjarra tjiilakutu katirra tjarrpatjunkunytjaku. Tjilangkapula nyinanyangka Tjutjupalu pulanya yilanguru aṉṯaṉṯalpayi. Paluru kutjarra mungangka ngarrirra tjukurrpa nyangu. Tjiṉṯurringkunyangka paluru kutjarra nyinarra kuliṉingi tjiila unngunguru. Tjiṉṯu palula Tjutjupalu pulanya nyangu, “Nyaakupulan watjilarrinyi?” Nyarra palulangurupula Tjutjupanya nyakula watjaṉu, “Ngalitjulitju mungangka tjukurrpa nyangutjangku, nyuntulakutu wangkanyi.” Pulakina tjutilpayilu nyakula watjaṉu, “Ngayuluṉa nyangu watiya tjirripala kuripitjitjarra uṉmirringkula ngaranytjala. Maraluṉa panikina kanyiṉingi, mayutju puḻkakuṉu. Palulanguruṉa kuripitji tjulkura tjutura kanyiṉingi, mayutju puḻkaku. Palulanguruṉa katirra mayutju palunya yungu.” Tjutjupalu watjaṉu, “Kulila! Watiya kuripitjitjarra tjirripala nguwanpa tjiṉṯu tjirripala ngaramalpa. Palunyangka palurunta nyinarra kulira watjalku, nyuntu tjiṉṯu maṉkurrarrinyangka tjiilanguru pakalku. Palunyangka mayutju palurunta watjalku waarrka kutju palunya palyantjaku.” Tjutjupalu wati palunya piyuku watjaṉu, “Nyuntu pakara mayutjungka wangka!, ngayunya tjiilanguru pakaltjingantjaku.” Tjukurrpa yuti palunya kulira Tjutjupanya watjaṉu mangarri kutjalpayilu, “Yuwa, ngayuluṯarraṉa tjukurrpa nyangu. Kaṉilpa nguwanpa maṉkurrpa wati kutjungku katangka kanyira katiyankupayi. Kaṉilpa palula mayi tjuṯa ngarringi, mayutju puḻkaku. Tjuḻpu tjuṯangkulpiya ngalya yankula mayi palunya ngalkuṉingi.” Tjutjupalu wangka palunya kulira watjaṉu, “Kaṉilpa maṉkurrpa nguwanpa tjiṉṯu maṉkurrpa ngaramalpa. Palunyangkalta mayutju palurunta kuliranta watjalku, tjiilangurun pakalku tjiṉṯu maṉkurrarrinytja. Palulangurunta watjalku waralytjunkunytjakitjangku. Waarrkana kutjupa tjuṯangku nyuntunya waralytjunkula mirrintanku Palulangurunta tjuḻpu tjuṯangkulpi ngalkunmalpa.” Wangka panyapa Tjutjupakuṉu iltarringu. Pulakina yungkupayinya palya pakara mayutju puḻkaku waarrkarringu. Mayi kutjalpayi palunya pakaltjingara iluntanu. Tjutjupakura wangka panyapakura ramarringu, pulakina yungkupayinya. Wiyara mayutjungka tjakultjunu Tjutjupanya pakaltjingantjaku. ");
INSERT INTO piu2006_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","13","Palunyatjanu Tjutjupanya yiiya kutjarra nyinangi tjiilangka unngu. Ngurra Yitjipinya ngurrarangku mayutju puḻkangku ngarrirra tjukurrpa nyangu, Piirulu. Manta Yitjipingka Piirunya ngarangu karru tiṉangka. Palulanguru paluru karrunguru puluka tjuṯa pakantjala nyangu. Puluka yakura tjapanpalangku pakara yukiri ngalkulinangi karru tjayiṯinguru. Puluka paluru tjana yukiritjanu paḻtja ngarangi, kanya puluka kutjupa tjuṯaya paḻtjatjirratja nyurrka karrunguruya pakara ngarangi. Nyurrka tjuṯangkuya ngarala nyangangi kutjupa tjuṯa ngalkura wiyalkitjalu. Kala tjananya ngalkura wiyaṉu. Alatji panya mayutju puḻkalu tjukurrpa nyakula kanarringu. Palunyatjanu Piirululpi tjukurrpa nyangu, watiya pakara ngarangi mangarri tjapanpalatjarra. Mangarri palunya tjana uṉmilpi ngarangi, kanya watiya kutjupa tjayiṯingka ngarangi, mangarri tjapanpala piḻṯi ngarangi. Mangarri piḻṯi paluru tjuṯangku, mangarri uṉmi palunya tjananya ngalkura wiyaṉu. Tjukurrpa panyapalpi nyakula kanarringu, mayutju Piirulu. Mungawinki ngarrirra puṯu kuliṉingi tjukurrpa panyapa. Paluru pakara watjilpa nyinangi. Wati ninti puḻka tjananya paluru nyakula yaḻṯingu, tjuṯa kutjupaṯarra, yatjikilu palyalpayi. Ngalya yankula ngaranytjala tjananya mayutju paluru tjananya watjaṉu tjukurrpa nyangutjangku. Palulanguru kulira ngarangi, nintilkitjalu puṯuya kuliṉingi. Palunyangka mayutju puḻkaku walytjangku watjaṉu, pulakina yungkupayilu, “Ngayuluṉanta yurrunpa watjalmara. Ngayuluṉa ramarringu. Tjiilangka nyinarra nyiṯayirralulinyatju Yipuru wangkatjarrangku watjaṉu, tjungungkulitju tjukurrpa palunya nyakupayi. Palumpaṉu wangka yiltarringu. Paluru ilta tjukurrpa kulira nintilpayi.” ");
INSERT INTO piu2006_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","36","Wangka panyapa kulira mayutju Piirulu wantirriyaṉu Tjutjupanya yankula tjiilanguru pakaltjingantjaku. Palulanguru Tjutjupanyalpi katingu mayutju puḻkaku ngurrakutu. Tjarrparra mantarra kutjupangkalpi tjarrpangu, ngaṉkurrpawiyalpi pakaṉu. Yankula mayutju puḻkangkalpi ngarangi, Piirungka. Palulanguru Piirululpi watjaṉu, “Mungangkaṉa tjukurrpa nyakunytjatjanungku ninti tjuṯakutu tjakultjunu. Tjukurrpa palumpaya puṯu kuliṉingi. Tjingurun nyuntu tjukurrpa nintilpayi. Ngaaluṉi watjaṉu wayina yungkupayilu.” Tjutjupalu watjaṉu, “Wanyu mayutju, ngayuluṉa wiya tjukurrpa nintilpayi. Wanyulika kulila mayutju Katutjanya!, palurulinya tjukarurrungku tjukurrpa palunyaku nintilku.” Palunyangka mayutju paluru tjukurrpa palunya Tjutjupakutu tjakultjunu. Palunyangka Tjutjupalulpi watjaṉu, tjukurrpa panyapa kutjarra wangkarra tjukarurruntjaku. Yalatji watjaṉu, “Nyuntu mayutju, wangka kutju kulintjaku, Katutjakuṉu wangka. Palunyangka puluka tjapanpala paḻtja ngarangi. Palunya nguwanpa watiya tjapanpala mangarritjarra ngarangi. Wangka palunya nguwanpa yiiya tjapanpala ngaraku mangarritjarra rawa nyinanytjaku. Palunyangka puluka tjapanpala nyurrka ngarangi. Palunya nguwanpa kutjupa watiya tjapanpala piḻṯi ngarangi. “Wangka palunya nguwanpa paḻtjatjirratja rawala nyinamalpa, yiiya tjapanpalangara. Palunyangka kapiwiya mayiwiya kukawiya nyinamalpa. Alatji mayutju Katutjalulanya watjaṉu, palya kutju nyinanytjaku yiiya tjapanpala. Palulanguru mangarriwiya kukawiya kapiwiya nyinamalpa.” Tjutjupalulpi piyuku watjaṉu, “Mangarriwiyalpila nyinatjipingkamarra, nyuntu wati kutjupalpi nyinatjurra ninti puḻkanya!, paluru waarrkana kutjupa tjuṯanya watjantjaku. Waarrkana paluru tjana yankula mangarriku ngatjira payimilantjaku, ngurra kutjupa tjuṯangka. Ngurra palula mangarri pakaltjingalpayi. Palunyangka tjana tjinguru mantjira mangarri tjuṯanya ngalya katirra waaḻangka purinytjungku kanyintjaku. Palunyangka waaḻa mangarritjarra tjuṯa ngaramalpa ngurra tjiwarriwarringka. Ngula kapiwiyarrinyingka waaḻa palula tjanalaya payimilara ngalkunmalpa, yaṉangu tjuṯalu.” ");
INSERT INTO piu2006_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","57","Wangka panyapa kulira pukuḻarringu mayutju Piirunya. Palurulpi tjananya watjaṉu palumpa waarrkana tjuṯanya, “Wati ngaatjanya tjinguru ninti Katutjaku kurruntjarra. Wati kutjupa tjuṯanya nintiwiya puṯu kulira nyinanyi.” Palunyangka Piirululpi Tjutjupalakutu wangkangu, “Katutjalunta nintiṉu mangarriku ngatjira kanyintjaku waaḻangka, nyuntu ilta ninti puḻka nyinanyi. Palunyangka wati kutjupa tjuṯa ngatalpa nguwanpa nyinanyi. Kalaṉanta mayutju puḻkalpi nyinatjunku, yaṉangu tjuṯaku, ngurra uwankarraku. Palunyangka nyuntulpi watjantjala kulilkuya palyantjakitjangku. Nyuntulpi mayutju puḻka nyinaku, ngayula ngaṉṯi.” Manta Yitjipilawana Tjutjupanyangarri parra ulytjarinangi ngurra kutjupa tjuṯawana, mangarri payimilalkitja. Palulanguruya katirra waaḻa tjuṯangka tjarrpatjunkula wantingu. Palunyangka waarrkana kutjupa tjuṯa tjananya tjana watjaṉu nyakula kanyintjaku. Palulanguru manta Yitjipilawana puṯu kuliṉingiya mangarri wiyarringanyingka. Palulanguruya puṯu kulira tjapiṉu mayutju Piirunya. Piirulu watjaṉu Tjutjupanya, “Yankula wangka!, nyuntupa waarrkana tjuṯangku mangarritjarra aḻantjaku, yaṉangu kutjupa tjuṯangku payimilantjaku.” Palunyangkaya Yitjipinya ngurrara tjuṯangkulpi payimilara palya nyinangi mangarritjarra. Palunyangka manta kutjupa ngurrara tjuṯa ngalya yankupayi, ngurra Yitjipilakutu mangarri payimilalkitja. ");
INSERT INTO piu2006_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","8","Manta Kayinanangka iṉa Tjikupanya nyinarra kuliṉingi, manta Yitjipingka mangarritjarraya nyinangi. Palunyangka palumpa katja tjuṯalpi watjaṉu, “Yankulaya ngurra Yitjipilakutu mangarri payimilara ngalya katilampa!, nganaṉala mangarriwiyalpi nyinatjipingkamarra.” Yalatji tjananya Tjutjupaku kuṯa tjuṯa tjananya tiinpala watjaṉu. Palulanguruya ngurra Yitjipilakutu yanu. Palunyangka Tjutjupaku maḻanypa Pintjiminanya ngurrangka kanyiṉingi, ngurra kutjupa ngurrarangku pungkutjipingkamarra. Palunyangka manta Yitjipingka yankulaya pupakatingu mayutju tiṉangka. Palunyatjanuya pakara ngarala tjapiṉu, mangarri payimilalkitjalu. Palunyangkaya wiya ngarala kuliṉu Tjutjupanya mayutju tiṉalpi ngaranytjala. Irriṯiya mayutju tiṉangka pupakatirra ngarapayi. Tjutjupalu tjananya nyakula wiyalpi unyparringu. Palunyangka wiyaya Tjutjupanya kuliṉu mayutju tiṉa Yitjipinya ngurrara kutjupa nguwanpa ngaranytjala. Paluru Yitjipikuṉu wangka kanyiṉingi. ");
INSERT INTO piu2006_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","17","Tjutjupalulpi watjaṉu palumpa waarrkanangku Yipuru wangkatjarrangku watjantjaku. Waarrkana palurulpi tjananya tjapiṉu, “Ngurra yaalytjingurunyurra ngalyanu?” Kaaka tjuṯangkulpi watjaṉu, “Manta Kayinanalangurulatju ngalyanu, mangarri payimilalkitja.” Tjutjupalulpi watjaṉu palumpa waarrkanangku Yipuru wangkatjarrangku watjantjaku yalatji, “Wiya, nyurrangarri nguntinytju tjuṯa ngaranyi. Nganampatju ngurrangka parra ngarala maḻakunyurra yankuku watjalkitjalu nyurrampa mayutju tiṉangka. Palunyangkanyurra warrmaḻalpi ngalya pakalku ngurra ngaakutu.” Palunyangkalpi Tjutjupaku kaaka tjuṯangku kuliraya nguḻurringu. Watjaṉuya, “Wiya, mangarrikulatju ngalya yanu. Nyuntupa walytja tjuṯalatju nyinanyi. Palunyangkalatju kaakararranpa nyinapayi ngurra Kayinanangka, paapa kutjutjanu. Palunyangkalampatju maḻanypa kutjulpi yankula wiyarringu, ngurra irriṯi. Palunyangka maḻanypa kutjulampatju nyinanyi paapawana.” Waarrkana palurulpi tjakultjunu Tjutjupalakutu Yitjipikuṉu wangka, kulintjaku. Tjutjupalulpi kulira Yitjipikuṉu wangkangku waarrkanala watjaṉu paluru taaṉamilantjaku wangka yalatji, “Wiya, nyurrangarri ngunytjinytjunanyi, nganampatju manta nyakula katirra tjakultjunkukitjalu.” Palunyangka Tjutjupalulpi ngarala kuliṉingi piyuku watjalkitjalu. Tjutjupalu palumpa waarrkana piyuku watjaṉu wangka yalatji taaṉamilantjaku, “Nyurrangarrinyurra ngayunya ngunytjinytjunanyi, tjinguru nyurrangarri tjukarurru wangkanyi nyuntupa maḻanypa ngurrangka nyinanyi. Palunyangka wati kutjululpi yankula aḻṯikatinytjaku, ngalya katirra ngayula nintintjaku, kanya kutjupa tjuṯanyurra tjiilangka tjarrparra nyinamalpa. Maḻanypa palunya ngayulu ilangku nyakunytjaku. Nyakula watjalkuṉa nyurranya tjiilanguru pakara ngurrakutu ankunytjaku.” ");
INSERT INTO piu2006_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","24","Palulanguruya Tjiṉṯu maṉkurrarringu tjungu tjiilangka nyinangi. Palunyangka Tjutjupalulpi yankula tjananya palumpa kaaka tjuṯakutu. Ngarala paluru palumpa waarrkanangka watjaṉu wangka yalatji taaṉamilantjaku, “Katutjanya ilta nyinanytjala ngayulu kuliṉi. Palunyangka aḻṯururringkulaṉa nyurranya watjaṉi. Tjuṯanyurra ngaangka nyinanytjawiya, yaṉangu kutju kutju ngaangka nyinaku. Palunyangkanyurra tjuṯa kutjupangku mangarri payimilara katiku ngurra Kayinanalakutu, nyurrangarrimpa walytja tjuṯaku. Palunyangkanyurra nyinarra nyurrangarrimpa maḻanypa ngalya kati! Maḻanypa palunyaṉa nyakula watjalku iltanyurra wangka palunya watjaṉu. Nyurrangarrimpa maḻanypa ngaṉṯitja nyakula ngayulu wiya tjananya watjalku nyurrangarrinya mirri pungkunytjaku.” Palunyangka kaaka tjuṯangkulpi Tjutjupaku wangka kulira yunyparringu. Palulanguruya wangkarra waṉingi, “Ilta maḻanypa Tjutjupanyalpila irriṯi kawaḻinu, palunyangkalpila tjiilangka nyinanyi. Katutjalulpilampa ngurrkurringkula tjarrpatjunu tjiilangka. Palunyangka irriṯi Tjutjupanyalpila kawaḻinu aḻṯuruwiyangku. Palurulpilanya watjaṉu ngurra walytjangka yankula nyinanytjaku, ngurra Kayinanala. Nganaṉala kaaka tjuṯangku maḻanypa kawaḻinutjangka, palunyangkalanya Katutjalu yitjipunganyi.” Tjutjupalu tjananya wangka panyapa kulira paluru yankula yulangi, waaḻangka yurilta. Tjutjupanya ngaranytjala kuliṉuya, “Wiyalanya ngaangku kuliṉi, wati kutjupa Yitjipikuṉu wangkatjarrangku.” Palunyangka Tjutjupanya yurilta yulanytjatjanu pakara ngalya yanu. Ngalya yankula tjananya watjaṉu palumpa waarrkana tjuṯanya, wati Tjimiyananya witira tayimapira tjiilangka kutu kanyintjaku. Paluru piyuku watjaṉu kutjupa tjuṯalpi pakara tjiilanguru ankunytjaku. ");
INSERT INTO piu2006_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","38","Tjutjupalu watjaṉu palumpa waarrkanangka yankula tjanampa mangarri tjutira payiki kutjupangka kutjupangka puulapankunytjaku. Palunyangka piyuku Tjutjupalu watjaṉu, “Mani tjanampa payiki tjuṯangka tjarrpatjunkula wanti!, payiki mangarri tjuṯatjarrangka, kumpilpa ngarrinytjaku.” Palunyangka kaaka tjuṯalpi ngalya yankula payiki mangarritjarra tuungkiyi tjuṯangka uṯitjunkula katingu. Palunyangkaya waaḻa palunya wantikatingu yankulaya ngururrpa ngarringu, ngurra Kayinanakitja. Palunyangka wati kutjululpi payiki mantjira arrara nyangu, mani panyapa ngarrinytjala. Palunyangka tjananya wati kutjupa tjuṯanya watjaṉu, “Mani panyapa ngaatja ngarrinyi.” Palunyangkaya kulira nguḻunguḻurringu, palunyangka puṯu kuliṉangi. Nguḻurringkulaya katingu tjiḻpi Tjikupalakutu. Palunyangkaya nyakula watjaṉu, “Tjimiyananya tjiilangka nyinanyi. Mayutju Yitjipinya ngurraralulanyatju watjaṉu Pintjiminanya katirra nintintjaku, mayutju tiṉangka.” Palunyangka Tjikupalulpi watjaṉu, “Wiya Pintjiminanya katinytjaku, ngurra Yitjipilakutu, kutjupalu pungkutjipingkamarra, ngayuku katja nguwanpa, yini Tjutjupanya nguwanpa.” Palulanguru kaaka tjuṯangkulpi payiki tjuṯa arrara nyangu, mani ngarrinytjala, payiki unngu. Palulanguru nyakulaya nguḻunguḻurringu. ");
INSERT INTO piu2006_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","15","Manta Kayinanala kutuya mangarriwiya kapiwiya nyinangi. Palunyangka wiya tjanampa kapi punkara ngarringi. Mangarri panyapa tjuṯanya ngalkuraya wiyaṉu. Palunyangka tjananya Tjikupalu watjaṉu, “Yankulaya manta Yitjipilakutu mangarri payimilala! Payimilaraya ngalya kati!” Katja ngururrṯitjalu yini Tjuutalu watjaṉu, “Pintjiminanyalatju katiku ngurra Yitjipilakutu? Mayutju tiṉangku watjaṉutja. Palunyangka ngayuluṉa katirra ilangku nyakula kanyinmalpa, kutjupalu pungkutjipingkamarra. Tjinguru kutjupalu pungku, palunyangka ngayunyalpiṉi nyurrangarri ngaparrtjilu mirri iluntanku.” Palunyangka Tjikupalulpi tjananya watjaṉu, “Kalalpi Pintjiminanya kati! Mingkuḻpa puḻka, ngalypuru puḻka kati!, mayutju tiṉa inytjanungku ungkunytjaku. Mani panyapa payikingka ngarringitja katirrara yuwa mayutju tiṉaku! Mani kutjupaṯarra katirrara yuwa!, mangarri kutjupa payimilantjaku. Ngayuluṉa Katutjanya tjapiṉi aḻṯururringkula nyurrampa nyinanytjaku, mayutju tiṉa palunya, palunyangka ngayuku katja kutjarra Tjimiyananya, Pintjiminanya ngalya wantirriyantjaku, mayutju Yitjipinya ngurrarangku.” Palulanguruya kaakararranpa yanu ngurra Yitjipilakutu maḻanypa kutju, panyapatjarra. ");
INSERT INTO piu2006_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","34","Yankulaya mayutju tiṉangka ngarangi. Tjutjupalulpi tjananya nyakula watjaṉu, palumpa waarrkanakutu, palumpa ngurrakutu tjananya katinytjaku. Palunyangka waarrkana palurulpi tjananya yaḻṯirra katingu Tjutjupaku ngurrakutu. Yankulaya kulirinangi, “Nyaakulanya mayutju tiṉaku ngurrakutu katinyi? Tjinguru mani panyapa tjuṯanguru mayutju tiṉa ngurrkurringu. Palulangurulanya tjinguru rungkara kanyinmalpa, palumpa ngurrangka, tjiilangka nguwanpa. Tjingurula palumpa waarrkanarrikula waarrkarringamalpa, ngurra palumpaṉungka.” Palunyangka yankulaya Tjutjupaku waaḻangka yurilta ngarangi. Waarrkana panyapaya watjaṉu, “Irriṯilatju ngalya ankula mangarri payimilara anu. Palulangurulatju ngula kutju payikitjarra mani palunya nyangu, payiki tjuṯangka ngarringutja. Mani palunyalatju ngalya katirra kanyiṉi yungkukitjalu. Mani kutjupa tjuṯalatju kanyiṉi mangarri payimilalkitjalu. Palunyangkalatju puṯu kuliṉi. Nganalulampatju mani panyapa tjuṯanya payikingka tjarrpatjunu?” Waarrkana paluru tjananya watjaṉu, “Wiyanyurra nguḻurrinytjaku. Tjinguru Katutjalu nyurrampa tjarrpatjunu. Mani panyapa ngayuluṉa katirra tjarrpatjunu waaḻangka, mangarriku.” Palulanguru waarrkana paluru mantjira katingu Tjimiyananya, tjiilangka nyinangitja. Watjaṉu tjananya tjungungku tjiṉṯu katurrinyangka ngalkuntjaku, mayutju tiṉangka. Tjikupaku katja tjuṯangku yankulaya tuungkiyingka tjuṯangka mingkuḻpapa ngalypuru mantjiraya ngalya katirra waaḻangka yunngu tjunu, mayutju tiṉa yungkunytjakitjangku. Tjana waaḻangka yunnguya paṯara nyinangi mayutjuku. Tjutjupanya ngalya yanu mayutju tiṉa. Palulanguru tjana nyakula pupakatirra tjana waḻkuṉu. Tjutjupalu tjananya nyakula waarrkana watjaṉu, wangka yalatji taaṉamilantjaku, “Pupakatiwiyaya pakala!” Tjutjupalu watjaṉutjangka palumpa waarrkanangku piyuku tjananya tjapiṉu, “Paapa nyurrangarrimpa kana nyinanyi?” Tjana yuwa wangkangu. Tjutjupalu palumpa maḻanypa Pintjiminanya nyakula palumpa waarrkana watjaṉu wangka yalatji taaṉamilara tjapiṉu, “Palatja nyurrangarrimpa maḻanypa? Panyapatjunyurra yirriṯi watjaṉu?” “Yuwa”, wangkanguya. Tjutjupalu nyakula Pintjiminanya palumpa waarrkana watjaṉu wangka yalatji taaṉamilantjaku, “Ngayuluṉa yunytjurringanyi Katutjalunta nyuntunya yaṉṯayaṉṯantjaku.” Kaaka tjuṯangku kuliltjipingkamarra paluru pakara yanu kumpilpanguru yulanytjaku, maḻanypanguru. Yuṉpa paltjira piyuku paluru maḻaku yanu kaaka tjuṯakutu. Yankula ngarala waarrkanangka watjaṉu, mayi anta kuka ngalya katirra tjunkunytjaku tjanampa. Tjutjupalu tiipula kutjungka waṉmanguru nyinarra ngalkuṉingi, kanya kaakararrantuya tiipula kutjupangka ngalkula tjikira paḻtjarringu. ");
INSERT INTO piu2006_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","34","Manta Kayinanalakutu kaakararranpaya piyuku maḻaku yankunytjakitja. Tjutjupalu palumpa waarrkanangka watjaṉu yalatji, “Palan tjuṯaku payiki tjuṯangka mayi yintira puulaparra! Manintaya kuwarri yungkunytjala tjunkula wanala payiki kutjuṯukutjuṯungka! Maḻanypa ngaṉṯitjaku payikingka tjurra!, panikina palya ngayuku, tjiilpatjanu palyaṉutja.” Tjutjupalu watjantjawana waarrkanangku yankula payiki kutjuṯukutjuṯungka tjunangi. Mungawinki pakara kaakararranpaya tuungkiyingka kaḻpakatirra yanu manta Kayinalakutu yankunytjakitja. Yitjipila yilaya tjana yanangi. Tjutjupalu palumpa waarrkanangka watjaṉu, “Kala, wanara tjananya nyakula tjapila raapangku!, ‘Nyaakunyurra mulyaṯangku panikina palya katingu? Ngayuku mayutjungku nyurrangarrinya palya kutju kanyilpayi.’” Tjutjupalu watjantjawana paluru wanara tjananya tjapiṉu, “Nyaakunyurra panikina mulyaṯangku katingu, mayutjuku?” Tjana nguḻurringkula watjaṉu, “Wiyawanangku nyuntu kuru nganaṉanya watjaṉi. Panikina wiyalatju mulyaṯangku mantjiṉu, ngurrpalatju. Tjinguru nyuntu panikina nyakula mantjira nyuntu nyakula palunya kutju mirri puwa! Kutjupa tjuṯalatju mayutju tiṉaku palyalatju puntura waarrkarrimalpa.” Waarrkanangku watjaṉu, “Panikina mantjintjatjanu kutju puntura waarrkarriku, kutjupa tjuṯanyurra palya yarurringkunytjaku ngurrakutu.” Tjutjupaku waarrkanangku purinypa ngurriṉingi, payiki tjuṯangka, panikinaku. Kaaka tjuṯaku payikingka yurrunpa puṯu ngurriṉingi. Palumpa maḻanypaku payikingka ngurrira mantjiṉu, kala Pintjiminakuṉungka. Tjuni kuyarringkula tjana puṯu kuliṉingi. Piyukuya maḻaku yanu tawunukutu. Tjutjupaku waaḻangka yankula tjana Tjutjupakuya pupakatingu, mayutju tiṉaku. Tjutjupalu watjaṉu palumpa waarrkanangku wangka taaṉamilara yalatji tjananya watjantjaku, “Pakaraya ngara! Nyaakunyurra panikina ngayuku mulyaṯangku katingu?” Watjaṉulpiya, “Puṯulatju kuliṉi wiya wangkanytjaku. Wiya panikina mantjiṉutja kutju waarrkana nyinaku, tjuṯalatju palya waarrkarrimalpa.” Tjutjupakuṉu wangka waarrkana paluru tjananya watjaṉu, “Wiya tjuṯa waarrkarriku, mulyaṯangku katingutja, paluru kutju puntura waarrkarringkunytjaku. Kutjupa tjuṯanyurra palya yankunytjaku paapa nyurrangarrimpakutu.” Tjuutalulpi yilarringkula Tjutjupanya mayutju Yitjipinya ngurrara kutjupakutjura paluru kulira marrkuṉu, “Mayutju. Nyuntu manta ngaaku mayutju puntu ngaranyi. Kulilaṉi ngurrkurringkunytjawiyangku! Yirriṯilanyatjun watjaṉu maḻanypa ngalya katinytjaku. Yankulalatju puṯu tjapiṉu Paapanya. Paapangku watjaṉu, ‘Pipirri ngaatja wiya katinytjaku.’ Ngula piyukulatju paapanya tjapiṉu pipirri ngaatja katinytjaku. Palulanguru paluru yuwa wangkangu, ‘Yuwa. Pipirri palatja katirra yaṉṯayaṉṯala!’ Wiyalatju pipirri ngaatja wantikatiku. Nganaṉatju yankula tjakultjunkunytjala, tjiḻpi nyarrangku kulira watjilarrirra yilupayingkamarra. Ngayululpiṉa kaaka puḻka ngaangka nyinarra waarrkarrimalpa, palunyangkaya Pintjiminanya palya katinytjaku, tjiḻpi nyarratja kulira watjilarrirra yilupayingkamarra.” ");
INSERT INTO piu2006_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","24","Tjutjupalu wangka palunya kulira yulakitjarrirra tjanala waarrkana tjuṯangka watjaṉu, “Yankulaya yurilpangka nyina!” Palunyatjanu paluru kaaka tjuṯangka nyakula puntura yulangu. Palulanguruya yurilpanguruya ngarala kuliṉu yulanytjala, waarrkana tjuṯangku. Tjutjupanya wangkangu palumpa kaakangkapa maḻanypangka Yipuru wangka tjana kulintjaku, “Ngayuluṉa ngaatja ngaranyi, Tjutjupanya.” Tjutjupalu watjaṉutjangka kaaka tjuṯa tjanaya nguḻurringkula yataṉpa ngarangi. Tjutjupalu tjananya piyuku watjaṉu, “Nguḻurringkuwiya yilaya ngara! Ngayulu nyurrangarrimpa maḻanypa wangkanyi, Tjutjupanya. Yirriṯinyurra ngayunya tjalamilara manta ngaakutu wantirriyaṉu, manta Yitjipilakutu. Wiya nyurrangarri ngayula nguḻurringkunytjaku. Katutjalu kutju ngurra ngaakutu wantirriyaṉu ngayunya, mayutju tiṉa nyinanytjaku. Mayi palyaṉa nyurrampa yunganyi kananyurra nyinanytjaku, yaṉangu yuwankarra mayiwiyarringkunytjala mirrirringkupayingkamarra. Yiiya payipalangka kapingku wiya pungkuku, an mangarriwiya pakalku. Nyurrangarri yankula maḻaku ngalya yankunytjaku ngurra Kuutjinalakutu, mayi palyangkanyurra nyinanytjaku. Ngayuku paapangkaya yankula tjakultjurra!, mayi palyakutunyurra ngalya yankunytjaku, mayiwiyangka. Yankula tjanala wangka!, tjamupiṯi kapaḻipiṯi ngalya katinytjaku ngaakutu mayi palyangkaya nyinanytjaku. Tjiipi tjuṯa, nanikuta tjuṯa, puluka tjuṯaṯarra ngalya kati!, yukiri palyakutu. Nyurrangarri ngalya yankunytjala ngayulu nyurrangarrinya mayi palyatjarrangku yaṉṯayaṉṯalku. Ngurra Kuutjinalanyurra nyinaku.” Palulanguru Tjutjupanya yankula Pintjiminanya yampura yulangu. Palulanguru kuṯa tjuṯangkalpi yampura yulangu. Palunyangka kuṯa tjuṯaya yunyparringkula Tjutjupala wangkangu. Piirululpi tjananya kulira pukuḻarringu Tjutjupanyalpi watjaṉu, “Yankulaya nyuntupa walytja tjuṯa mantjira ngalya katinytjaku. Ngalya yankulaya palya nyinamalpa manta Kuutjinala, mayi palyangka. Palya, wakina tjuṯa tjanampa yuwa!, yulytjaya mantjira ngalya katirra ngurra ngaangkalpi nyinanytjaku, ngurra yini Kuutjinala.” Palulanguru Tjutjupalu tjananya wakina tjuṯa yungu yulytja tjuṯa kaḻpatjunkula ngalya katinytjaku. Paluru mangarri kuka yungkula tjananya watjaṉu, “Yankula tjananya mantjira ngalya kati!, yulytja tjuṯaṯarra, ngaangkanyurra palya nyinanytjaku mayingka, yukiri palyatjarrangka.” Kala, yuwaya wangkangu. ");
INSERT INTO piu2006_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","28","Palunyatjanu paluru tjana manta Kayinalakutu yanu. Tjana yankulaya Tjikupala tjakultjunu, “Tjutjupanya palya kana nyinanyi. Manta Yitjipinya ngurrarakulpi mayutju nyinanyi.” Tjikupalu kulira, wiyawanangku kulira watjaṉu, “Wiya. Ngayuku katja yirriṯi mirrirringu.” Palulanguru wakina tjuṯa nyakula tjana watjaṉu, “Ngaatjanya nyuntupa katjaku wakina, Tjutjupaku.” Yiltalpi paluru kulira watjaṉu, “Kala, yananyilpila yuwankarra, ngaangkaṉa ngayuku katja nyakunytjawiya nyinarra mirrirritjipingkamarra.” ");
INSERT INTO piu2006_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","27","Tjikupalungarri yulytja tjuṯa yuṯitjunkula tjananya watjaṉu, “Yankulala ngurra Piitjipala kunaṯinpa pungkula ngalkunytjaku, Katutjanya waḻkuntjakitja.” Yankulaya Katutjanya waḻkuṉu ngurra Piitjipala. Palulanguru Katutjanya wangkangu Tjikupala yalatji, “Ngayuluṉa nyuntupa paapaku mayutju tiṉa wangkanyi, Katutjanya. Palyanyurra manta Yitjipilakutu yankunytjaku, nguḻurringkunytjaku wiya. Nyuntu ngurra palula nyinarra mirrirringkunytjala, Tjutjupalunta nyuntunya kanyilku, maḻpalu. Nyuntupa ngaṉṯitja tjuṯanya ngayulu tjananya yaṉṯayaṉṯara ngalya katiku ngurra ngaakutu, tjanaya nyinanytjaku ngaangka, ngurra Kayinanala, palyangka.” Palulanguruya Tjikupanyangarri wakinatjarra yanu Yitjipilakutu. Yaṉangu tjuṯaya yanu tjikitji tjikitj yaṉangu, watipa minyma pipirri wiima tjuṯaṯarra. ");
INSERT INTO piu2006_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","34","(46:28—47:12) Tjikupanyangarri yankulaya yilarringkula Tjuutanyalpiya wantirriyaṉu, yankula Tjutjupala wangkanytjaku yalatji, “Nganaṉatju ngurra yilalpilatju nyinanyi, ngalya yankulalanyatju nyawa!, Kuutjinalalpilatju nyinanytjala.” Kala, palulanguru Tjutjupalu kulira yunyparringkula yanu paapa palumpa nyakunytjaku. Paluru yankula palumpa paapangka yampura yulangi. Tjikupanya wangkangu “Ngayuku Katjaṉanta nyakula kutju yunyparrinyi.” Kaaka payipalalpi tjananya yaḻṯirra katingu, yankula Piirunya nintintjaku. Katirra tjananya nintintjaku mayutju puḻka Piirunya, Tjutjupalu yilarringkula Piirula wangkangu, “Ngayuku walytja tjuṯaya tjarrpangu ngurra Kuutjinangka. Ngayuku kaaka tjuṯaṉa tjananya ngalya katingu ngurra ngaakutu, nyuntunyantaya nyakunytjaku, mayutju tiṉa.” Piirulu tjananya nyakula tjapiṉu, “Waarrka nyaanyurra palyalpayi?” Watjaṉuraya, “Tjiipi kutjulatju kanyilpayi, yirriṯitja tjuṯaluya kanyilpayi, palunya nguwanpa. Ngaatjalatju ngalya yanu mayi wiyarringanyingka. Yaalytji?, palyalatju nyinaku ngurra Kuutjinala?” “Yuwa, palya nyurrangarri nyinanytjaku ngurra nyarra palula.” Piirululpi tjananya wangkarra tjananya iyaṉu. Tjutjupanyalpi watjaṉu, “Nyuntupa walytja tjuṯangkuya tjana katirra yaṉṯayaṉṯantjaku yukiri palyangka, ngayuku tjiipi tjuṯa, nanikuta tjuṯaṯarra.” Ngula kutju katirra Tjutjupalu Piiruku nintiṉu, palumpa paapa, “Ngaatja ngayuku paapa.” Palulanguru tjiḻpi Tjikupalu Katutjanyara tjapiṉu, Piiruku, kala Piirunyara yunyparringu. Paluru pukuḻarrira maḻaku yanu ngurra Kuutjinalakutu. Ngurra palulaya palya nyinapayi. Tjutjupalu tjananya palya kutju nyakula tjananya yaṉṯayaṉṯara yungkupayi, palyaya tjana nyinanytjaku, ngurra palula. ");
INSERT INTO piu2006_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","12","(46:28—47:12) Tjikupanyangarri yankulaya yilarringkula Tjuutanyalpiya wantirriyaṉu, yankula Tjutjupala wangkanytjaku yalatji, “Nganaṉatju ngurra yilalpilatju nyinanyi, ngalya yankulalanyatju nyawa!, Kuutjinalalpilatju nyinanytjala.” Kala, palulanguru Tjutjupalu kulira yunyparringkula yanu paapa palumpa nyakunytjaku. Paluru yankula palumpa paapangka yampura yulangi. Tjikupanya wangkangu “Ngayuku Katjaṉanta nyakula kutju yunyparrinyi.” Kaaka payipalalpi tjananya yaḻṯirra katingu, yankula Piirunya nintintjaku. Katirra tjananya nintintjaku mayutju puḻka Piirunya, Tjutjupalu yilarringkula Piirula wangkangu, “Ngayuku walytja tjuṯaya tjarrpangu ngurra Kuutjinangka. Ngayuku kaaka tjuṯaṉa tjananya ngalya katingu ngurra ngaakutu, nyuntunyantaya nyakunytjaku, mayutju tiṉa.” Piirulu tjananya nyakula tjapiṉu, “Waarrka nyaanyurra palyalpayi?” Watjaṉuraya, “Tjiipi kutjulatju kanyilpayi, yirriṯitja tjuṯaluya kanyilpayi, palunya nguwanpa. Ngaatjalatju ngalya yanu mayi wiyarringanyingka. Yaalytji?, palyalatju nyinaku ngurra Kuutjinala?” “Yuwa, palya nyurrangarri nyinanytjaku ngurra nyarra palula.” Piirululpi tjananya wangkarra tjananya iyaṉu. Tjutjupanyalpi watjaṉu, “Nyuntupa walytja tjuṯangkuya tjana katirra yaṉṯayaṉṯantjaku yukiri palyangka, ngayuku tjiipi tjuṯa, nanikuta tjuṯaṯarra.” Ngula kutju katirra Tjutjupalu Piiruku nintiṉu, palumpa paapa, “Ngaatja ngayuku paapa.” Palulanguru tjiḻpi Tjikupalu Katutjanyara tjapiṉu, Piiruku, kala Piirunyara yunyparringu. Paluru pukuḻarrira maḻaku yanu ngurra Kuutjinalakutu. Ngurra palulaya palya nyinapayi. Tjutjupalu tjananya palya kutju nyakula tjananya yaṉṯayaṉṯara yungkupayi, palyaya tjana nyinanytjaku, ngurra palula. ");
INSERT INTO piu2006_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","33","(49:29—50:14) Tjikupalu paluru rawa nyinarra paluru kuliṉulpi, katja tjuṯangka watjalkitjangku. Paluru yaḻṯirra tjananya watjaṉu mirrirrikitjangku, “Ngayulu mirrirrikitjangku nyurrangarrila tjakultjunanyi. Mirrirrinytjaṉiya katirra tjurra, manta Kayinanala! Kuḻpi panyapangkaṉiya yini Makapilangka katirra tjarrpatjunkula ngarritjurra!, tawunu Mamaringka kakarrara. Tjamuwana paapawanaṉiya katirra ngarritjurra!” Yalatji tjanala wangkarralpi paluru mirrirringu. Palulanguruya Tjutjupanyangarri puntura yulangi, Yitjipinya ngurra tjuṯaṯarra. Palunyatjanuya Tjutjupalungarri mirri palunya katingu manta Kayinanalakutu, Tjutjupaku kaaka tjuṯangku. Yitjipinya ngurrara mayutju tjuṯaya tjungu yanu waarrkana kutjupa tjuṯaṯarra. Ngururrpaya piyuku puntura yularra katingu kuḻpi Makapilangkalpi ngarritjunu. Yitjipilakutulpiya maḻaku yanu ngurrakutu. ");
INSERT INTO piu2006_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","14","(49:29—50:14) Tjikupalu paluru rawa nyinarra paluru kuliṉulpi, katja tjuṯangka watjalkitjangku. Paluru yaḻṯirra tjananya watjaṉu mirrirrikitjangku, “Ngayulu mirrirrikitjangku nyurrangarrila tjakultjunanyi. Mirrirrinytjaṉiya katirra tjurra, manta Kayinanala! Kuḻpi panyapangkaṉiya yini Makapilangka katirra tjarrpatjunkula ngarritjurra!, tawunu Mamaringka kakarrara. Tjamuwana paapawanaṉiya katirra ngarritjurra!” Yalatji tjanala wangkarralpi paluru mirrirringu. Palulanguruya Tjutjupanyangarri puntura yulangi, Yitjipinya ngurra tjuṯaṯarra. Palunyatjanuya Tjutjupalungarri mirri palunya katingu manta Kayinanalakutu, Tjutjupaku kaaka tjuṯangku. Yitjipinya ngurrara mayutju tjuṯaya tjungu yanu waarrkana kutjupa tjuṯaṯarra. Ngururrpaya piyuku puntura yularra katingu kuḻpi Makapilangkalpi ngarritjunu. Yitjipilakutulpiya maḻaku yanu ngurrakutu. ");
INSERT INTO piu2006_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","21","Paapa tjanampa wiyarringutjangka ngaṉṯiya nguḻurringkula kuliṉu Tjutjupaku kaaka tjuṯangku, “Tjinguru Tjutjupalu kuliṉi ngaparrtjilulanya pungkunytjakitjangku, yirriṯila tjalamilara wantirriyanutjangka. Tjingurulampa kutu ngurrku nyinanyi.” Yalatji kuliraya wati kutju Tjutjupalakutu yiyaṉu, yalatji tjakultjunkunytjaku, “Nganampa paapangku kana nyinarra watjaṉutjangka, nyuntunya tjapintjaku. Yalatjilatjunta kuwarri tjapiṉi. Ngaparrtjingku pungkuwiyangkulanyatju wanti! Nganaṉatju yirriṯi wiyawanangku nyuntunya tjalamilara wantirriyaṉu. Kalyparringkulalampatju nyinama!” Tjutjupalu wangka panyapa kulira yularra watjaṉu, “Ngayulu wiya nyurrangarrimpa ngurrku nyinanyi. Yirriṯiṉa nyurrampa kalyparringu.” Tjutjupaku kaaka tjuṯaya ngalya yankula waṯungaralaya Tjutjupala wangkangu, “Palyalatju nyuntupa waarrkanalpi waarrkarrira nyinamalpa.” Tjutjupalu tjananya watjaṉu, “Pakalaya! Nyaakunyurra ngaangka waṯungaranyi? Nyaakunyurra nguḻurringanyi? Ngayulu wiya nyurrangarrimpa ngurrku nyinanyi. Waarrkana wiyatjunyurra waarrkarrimalpa. Nyurrangarri ngayuku kaaka tiṉa tjuṯa. Yiltaṉinyurra mirri pungkukitjalu tjalamilara wantirriyaṉu. Kala, Katutjalu kuliranytjawanaṉinyurra ngalya wantirriyaṉu, palya, mayiwiyangkaṉa nyurranya yaṉangu tjuṯa kanantjaku. Kuwarri kananyurra nyinanyi, ngaakutuṉinyurra ngalya wantirriyaṉu. Ngayukutjuya nguḻurringkuwiya nyinama! Ngayulu nyurrangarrinya pipirri tjuṯaṯarra yaṉṯayaṉṯara kanyinmalpa.” ");
INSERT INTO piu2006_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","26","Tjutjupanyangarriya palumpa kaaka tjuṯaṯarra kutuya manta Yitjipingka nyinangi. Yirriṯi Tjutjupalu miiṯa Yitjipinya ngurrara yaḻṯirra katja kutjarra mantjiṉu. Yini yalatjipula nyinangi Yipurimanya, Manatjanya. Watirringkula Manatjaku katjalpira yutirringu yini Makiranya. Tjutjupalu tjiḻpirringkula palumpa tjamupiṯi kapaḻipiṯi nyangu, Makiraku katjaṯarra. Palulanguru Tjutjupalu tjananya palumpa kaaka tjuṯa yaḻṯirra watjaṉu, “Kuwarriṉa mirrirriku. Palulanguru ngaṉṯi Katutjalu nyurrangarrinya kutu manta ngaangka yaṉṯayaṉṯara kanyinmalpa. Ngaangka nyurrangarrinya kanyira ngula manta palulakutu katiku, manta Kayinanalakutu. Yirriṯi manta panyapa nyurranya yungkunytjakitjalu Katutjalu tjananya watjaṉu, Yipuramanya Yatjikanya, Tjikupanya.” Palulanguru Tjutjupalu tjananya piyuku watjaṉu, “Katutjala mirangka, watjalaṉiya ngayunyaṉiya tarrka manta palulakutu katinytjaku!” Yuwa wangkanguya. Palunyatjanu Tjutjupanya manta Yitjipingkalpi mirrirringu. Yalatji Tjutjupanya rawa nyinangi, yantaṯan tiin yiiya. Yirriṯi tjananya Yitjipinya ngurrara tjuṯangku mirrirringutja waaḻangka kuupanangka tjunkula wantipayi tarrkarrinytjaku. Tjutjupanyalpiya mirrirringutjangka katinguya waaḻangka yunngu tjunkula wantingu, kuupanangka. (Palulanguruya Yitjurilaku walytja ngaṉṯitja tjuṯangku tarrka mantjira katirra kuḻpi palula tjunu, ngurra Kayinanala.) ");
INSERT INTO piu2006_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","22","Tjiḻpi Yitjurilanya, Tjutjupanya palumpa kuṯa tjuṯa ngurra Yitjipila nyinarra wiyarringu. Katja tjuṯa yuṉṯalpa tjuṯa nyinarra tjuṯarringu. Yitjurilaku walytja ngaṉṯitja tjuṯa, tjuṯarringu. Palunyangka Yitjipila mayutju tiṉa kutjupa Piirunya nyinangu, Tjutjupaku ngurrpa. Yitjurilaku walytja ngaṉṯitja tjuṯa, tjuṯarringulpi, palunyangka Yitjipiku mayutju paluru nguḻurringu. Paluru nguḻurrirra watjaṉu tjananya palumpa walytja tjuṯangka yalatji, “Yitjurilaku walytja ngaṉṯitja tjuṯa, tjuṯalpiya nyinanyi. Tjinguru paluru tjanalanya pungkutjipingkamarra. Yalatjingkamarra wiyaya katja tjuṯa kutjupa mantjintjaku, tjuṯarringkupayingka.” Palunyatjanu Yitjurilaku walytja ngaṉṯitja tjuṯa watjaṉu, waarrkana tjuṯalpiya waarrkarrinytjaku, mani mantjintjawiya. Palunyangka Yitjipinya ngurrara tjuṯalu tjananya mayutju kuyalu kanyiṉingi, waarrka tiṉaya palyantjaku. Yalatjiya waarrkarrirra waaḻa tiṉa tjuṯa palyara ngaratjunu. Yitjurilaku walytja ngaṉṯitja tjuṯaya rawa tjuṯarringkula nyinangi, Yipuru wangkapayi tjuṯa. Kutuya Yitjipinya ngurrara tjuṯalu tjananya yaḻṯuruwiyalu nguḻurrirra waarrkaku tjingapungkupayi. Palunyangka wulkumanu kutjarra Yipuru wangkapayi nyinapayi. Paluru kutjarra minyma tjuṯa yaṉṯayaṉṯalpayi, pipirri mantjiṉingka. Palunyatjanu mayutju tiṉalu pulanya yalatji watjaṉu, “Kungka Yipuru wangkapayingku uḻa wiima yutira kanyintjala, yilangku puwa! Tjinguru kungka wiima yutirrinytjala pungkuwiyalu wanti!” Puṯu pulanya marrkura Yitjipiku mayutju puḻkalu tjananya Yitjipinya ngurrara tjuṯa watjaṉu yalatjilu, “Yipuru wangkapayilu uḻa wiima yutira kanyintjala, tjulyaraya katirra karru yini Nayilangka waṉi kapingka unngu ilunytjaku!, kanya kungka wiima tjuṯaya wanti!” ");
INSERT INTO piu2006_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","4","Palunyangka Yipuru wangkapayipula miiṯararra nyinangi, katjalpi mantjiṉu yini Muutjanya. Pipirri palya nyakula palumpa maamalu waaḻangka yarrkatjunu, Yitjipinya ngurraralu nyakula tjulyara katipayingka. Pipirri palunya pira maṉkurrpa ngarrinytjala, palumpa maamalu puuta wiima palyaṉu katuwana patilpayitjarra. Puuta palula maamalu yangatjunu kapi tjarrpatjipingka, kiṯitjarrangku. Muutjanya yunngu ngarritjunkula katingu yamultatjiwana yarrkatjunu. Muutjaku yayi yila ngarangi, nyakula kanyintjaku. ");
INSERT INTO piu2006_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","10","Palunyangka Piiruku yuṉṯalpa tiṉa yanu karrukutu, paltjintjaku. Paluru tjaṯawana yamultatjiwana puuta wiima nyangu. Paluru nyakula watjaṉu palumpa waarrkana yankula mantjintjaku. Waarrkana paluru mantjira ngalya katirra yalara nyangu pipirri wiima ngarrirra yulanyingka. Nyakula yaḻṯururringkula watjaṉu, “Kuunyi nyawa!, pipirri ngaatja Yipuru wangkapayiku.” Palunyangka Muutjaku kangkuru ngalya yankula tjapiṉu, “Yaḻṯikuṉa minyma Yipuru wangkapayi?, pipirri wiima ngaatjanya yaṉṯayaṉṯantjaku, paluru waarrkana nyuntupa nyinanytjaku.” Piiruku yuṉṯalpalu watjaṉu, “Yuwa, yankula yaḻṯirra ngalya kati, minyma palunya!” Kungka paluru yankula Muutjaku maama yaḻṯirra ngalya katingu. Muutjaku maamalu watjaṉu, Piiruku yuṉṯalpa yalatji, “Pipirri uḻa wiima ngaatjaṉa kanyira tiṉalku. Tiṉarringanyingkaṉanta yungku.” Piiruku yuṉṯalpa wiya ninti nyinangu Muutjaku maamaku. Piiruku yuṉṯalpalu watjaṉu, “Kanyiratju tiṉala! Maniṉanta yungamalpa pipirri kanyiṉingka.” Ama tjikintjawiya nyinarra tiṉarringulpi. Muutjaku maamalu katirra yungu Piiruku yuṉṯalpalu kanyintjaku. ");
INSERT INTO piu2006_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","15","Muutjanya nyinarra watirringkula yanu walytja palumpa tjuṯa nyakunytjaku. Paluru yankula nyangu Yipuru wangkapayi tjuṯa puntura waarrkarrinyingka. Yitjipinya ngurrara tjuṯangku tjananya pungkula kanyiṉingi. Muutjalu nyakula yaḻṯururringu. Paluru nyangu Yitjipinya ngurraralu punganyingka palumpa walytja kutju. Nyakula paluru nyaarringu?, yaḻṯururringu wati palumpa. Muutjalu parra nyangu kutjupangku nyakupayingka. Paluru wati Yitjipinya ngurrara pungkula yiluntanu ngaparrtjilu. Muutjalu pungkula nguḻunguḻungku parrpaṯu tjawara talingka yarrkatjunu, kutjupangku nyakula nintilpayingka. Tjiṉṯu kutjupangka Muutjanya yanu nyakunytjaku palumpa walytja tjuṯanya waarrkarrinyingka. Yankula paluru nyangu Yipuru wangkapayi kutjarralupulanku punganyingka. Muutjalu watjaṉu, “Nyaakupulankun walytjatjarrangku punganyi?” Wati Yipuru wangkapayilu watjaṉu, “Nyaakutjun tjapiṉu ngayunya?, pika pungkukitjalu? Nyuntu panya wati Yitjipinya ngurrara pungkula iluntanu.” Muutjanya kulira nguḻurrira yanu ngurra kutjupakutu, kanya Yitjipinya ngurrara mayutju tiṉalu waarrkana palumpa tjuṯa watjaṉu, “Yankulanyurra Muutjanya ngurrira mantjintjaku, palunya ngaparrtjilu pungkunytjaku.” ");
INSERT INTO piu2006_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","25","Paluru yankula nyinangu kapi wiilangka yila. Wati Tjiitjarunya ngurra palula nyinapayi. Palumpa yuṉṯalpa tjuṯa ngalyanu kapi mantjintjaku, tjiipi tjuṯaku nanikuṯu tjuṯakuṯarra. Kanya wati tjiipiku mayutju tjuṯalu tjananya payira wantirriyantjala Muutjalu tjananya marrkuṉu. Marrkura tjananya minyma tjuṯaku kapi yintira yungu, tjiipi tjuṯangku nanikuṯu tjuṯangkuṯarra tjikintjaku. Minyma tjuṯalu yankula paapala watjaṉu, “Wati Yitjipinya ngurraralulanyatju kapi tjutira yungu. Paluru tjananya wati mayutju tjuṯa pikangku payira yiyaṉu. Palurulpilampatju tjutira yungu.” Paluru tjanampa paapangku yini Tjiitjarulu tjananya watjaṉu, “Yankulaya yaḻṯikati!, wati palunya, paluru ngalyankula nganaṉalawana ngalkuntjaku, mangarri.” Muutjanya kutu nyinangu tjiḻpi Tjiitjaruku ngurrangka. Nyinarra paluru Tjiitjaruku yuṉṯalpa mantjiṉu, yini Tjipuranya. Ngurra Yitjipila mayutju tiṉa panyapa nyinarra wiyarringu. Kututja tjana yitjipungkula kanyiṉingi, Yipuru wangkapayi tjuṯanya. Paluru tjana maniwiya waarrkarringkupayi, Yitjurilaku walytja ngaṉṯitja tjuṯa. Kutuya Katutjanya tjapilpayi waarrka puntu wantirra palyalpi nyinakitjangku. Katutjalu kulira tjananya yaḻṯururringu. Paluru kuliṉu, “Ngayulu yirriṯi Yipuramala, Yatjikalakamu, Tjikupangka watjaṉu tjanampa walytja ngaṉṯitja tjuṯa yaṉṯayaṉṯalkitjalu.” ");
INSERT INTO piu2006_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","6","Muutjalu tjananya yaṉṯayaṉṯara katiyanangi palumpa waputjuku tjiipi tjuṯa, nanikutaṯarra. Tjana yukiri tjuṯa ngalkulinangi waṉmawana, puḻi yini Tjaniyalakutu. Ngurra palula Katutjaku nyaḻpitjarra Muutjala yutirringu, waru tili nguwanpa. Waru tili paluru watiyangka kampangi. Muutjalu watiya tili ngaranyingka nyakula puṯu kuliṉu, “Nyaaku watiya palatja kamparra yiṉminyirrinytjawiya? Piyukuṉa yilarrirra nyaku.” Yilarringutjangka mayutju Katutjalu watiyanguru yaḻṯingu, “Muutja.” Muutjalu watjaṉu, kulira yalatji, “Ngaatjaṉa ngaranyi.” Katutjalu watjaṉu, “Yilarrinytjawiya maa ngara! Tjinakuṉu palatja yirriwiltjira tjurra! Wiya tjinakuṉutjarralu paḻintjaku manta ngaatjanya. Ngayuluṉa Katutjanya mayutju tiṉa tjanampa nyinanyi ngaa tjuṯaku Yipuramaku, Yatjikaku, Tjikupaku.” Palunyangka Muutjanya kulira nguḻurrira yuṉpa tjutuṉu marangku, Katutjanya yuti nyakutjipingka. ");
INSERT INTO piu2006_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","12","Katutjalu Muutjanya piyuku watjaṉu yalatji, “Kuliṉiṉa tjananya ngayuku walytja tjuṯa, Yitjipinya ngurrara tjuṯangku pungkula kanyiṉingka. Yaṉkuraya nyinanyi. Kuliṉiya yankukitja, ngurra palyangka nyinakitja. Yalatjiṉa kuliṉi tjananya mantjira ngalya katikitja, pungkula tjananya kanyiṉingka ngurra palula. Ngurra kutjupakutuṉa tjananya katikitja manta palyakutu. Manta paluru yini Kayinananya. Yaṉangu tjuṯa kuwarri nyinanyi manta palula. Palunyangka kuwarriṉanta wantirriyalku Piirulakutu yankula watjara wantirriyantjaku ngayuku walytja tjuṯa, nyuntu ngalya katinytjaku tjananya, tjana Yitjipila rawa nyinapayingka.” Muutjalu Katutjalakutu wangkangu, “Ngayuluṉa mungutja mayutjuwiyaṉa nyinanyi. Ngayulu mungutjangkuṉa wiya yankula watjalku Piirunya.” Katutjalu piyuku watjaṉu Muutjanya, “Ngayuluṉanta nintira yilta yaṉṯayaṉṯara katiyanamalpa. Yitjurilaku walytja ngaṉṯitja tjuṯa tjananya nyuntu mayutjulu ngalya katirra puḻi ngaangka nyinatjurra! Ngula nyuntu ngaangka nyinarra kulilku, ‘Yilta, Katutjalu ngayunya yiyaṉu, yaṉangu tjuṯa puḻi ngaakutu ngalya katinytjaku.’” ");
INSERT INTO piu2006_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","22","(3:13—4:16) Muutjalu Katutjanya piyuku tjapiṉu, “Tjinguruṉa Yitjurilaku walytja ngaṉṯitja tjuṯa yankula yalatjingku watjalku, ‘Nyurrangarrimpa tjuṯaku mayutju tiṉangku Katutjalu yiyaṉu ngayunya.’ Yalatjiṉa tjananya watjantjala, tjingurutjuya yalatji tjapilku, ‘Yini nganalunta iyaṉu? Mayutju paluru ngananya?’ Kanya ngayulu nyaaṉa tjananya watjalku?” Katutjalu Muutjanya watjaṉu, “Watjala tjananya! Yini ngayunyaṉa yalatji. ‘Ngayunyaṉa kutu nyinapayinya.’” Katutjalu piyuku watjaṉu Muutjanya, “Yalatji tjananya watjala! ‘Mayutju Katutjaluṉi wantirriyaṉu yirriṯi wiyarringutja tjuṯaku mayutju tiṉangku. Ngayulu tjanampa Yipuramaku, Yatjikaku Tjikupakuṯarra mayutju tiṉa nyinanyi.’ Muutja. Yankula tjananya mayutju tjuṯa yaḻṯirra kutjungkara tjakultjurra tjanala wangka yalatji! ‘Yitjipinya ngurrara tjuṯangku nyurranya yaḻṯuruwiyangku kanyiṉi. Yalatji kuliraṉa nyurranya katiku manta palyakutu. Yitjipinya ngurrara tjuṯangku nyurranya pungkula kanyiṉi, palunyangka manta Kayinanalakutuṉa nyurranya katirra nyinatjunku. Kuwarri manta palula kutjupa tjuṯa nyinanyi.’ Wangka palunya tjanala ngayuku walytja tjuṯangka nyuntu tjakultjunkunytjala, yiltaya kulilku. Palunyangka nyuntu yarra Piirulakutu!, yankula wangkanytjaku. Piirula yalatji wangka! ‘Yipuru wangkapayi tjuṯakulampatju mayutju tiṉalu Katutjalu watjaṉutjangka, yunytjurrinyilatju tjiṉṯu tjirripala yankula kunaṯinpa pungkula yungkunytjaku Katutjaku, waḻkura.’ Piirulu watjalku wiya nyurrangarri yanku palulawana. Yalatjikuṉa ninti nyinanyi. Palunyangka ngayuluṉa Katutjalu kuṉpu tiṉatjarrangkuṉa tjananya Yitjipinya ngurrara tjuṯa kutu yitjipungku. Palunyangkaya nguḻu tiṉarriku. Palulanguru Piirulu Yitjipinya ngurraralu yuwanmanku nyurrangarrinya ngalya wantirriyantjaku.” Muutjalu Katutjala watjaṉu, “Tjinguru Yitjurilaku walytja ngaṉṯitja tjuṯangku ngayuku wangka kulira wantiku. Tjinguruṉiya yalatji panypurangku, ‘Wiya Katutjanyanta yutitjarrira wangkangu. Nyuntu mungutja, ngunytjinytjunkupayi.’ Yalatji nguwanpaṉiya tjinguru watjalku, yaalytjirrikuṉa?” Katutjalu tjapiṉu Muutjanya, “Nyaan kanyiṉi?” Muutjalu watjaṉu, “Watiyaṉa kanyiṉi.” Watiya wana nguwanpa katiyankupayi. Mayutju Katutjalu piyuku watjaṉu, “Mantakutu waṉirriyala!” Mantangka watiya waṉingu, kanya piḻkaṯirringu. Piḻkaṯi nyakula Muutjanya tjalkaḻungu nguḻu warrpulpayingka. Katutjalu Muutjanya watjaṉu, “Piḻkaṯi wipu witira kanyila!” Palunyangka Muutjalu piḻkaṯi witintjala watiyarringulpi. Katutjalu piyuku watjaṉu, “Yitjurilaku walytja ngaṉṯitja tjuṯangku nyanganyingka, watiya waṉirriyala!, piḻkaṯirrinytjaku, panyapa nguwanpa. Nyakulaya yilta kulilku ngayuluṉanta watjara wantirriyaṉutjangka, mirri tjuṯaku mayutju tiṉa Katutjalu.” Katutjalu Muutjala piyuku watjaṉu, “Maranku kuutangka tjarrpatjurra!” Muutjalu parrpaṯu kulira tjarrpatjunu. Palunyatjanu yurrkura mara pikatjarralpi nyangu. Mayutju Katutjalu piyuku watjaṉu, “Piyukunku mara tjarrpatjurra, kuutangka!” Yalatji tjarrpatjunkula yurrkura pangki palyalpi nyangu. Mayutju Katutjalu Muutjala piyuku watjaṉu, “Tjinguru nyuntunya mara pikatjarra tjana nyakula tjuḻurrmanku, kulilkuya, ‘Yilta Katutjalu ngaatjanya mara pikantanu. Paluru ilta ngaatjanya wantirriyaṉu.’ Nyakulaya tjinguru wiya yalatji tjukarurrulu kulilku. Palulanguru kutjupa tjananya nintila!, kapi yintiṉingka ngurrkarriku. Karru Nayilangka nyuntu kapi mantjira mantakutu yintintjala yilta ngurrkarriku.” Muutjalu kulira watjaṉu, “Mayutju, ngayunya wiyaṉi wantirriyala! Tjaḻinypa wiyaṉa palya wangkapayi nyinanyi, purinypaṉa wangkapayi.” Mayutju Katutjalu watjaṉu, “Ngayuluṉa tjaḻinypa palyalpayi. Ngayuluṉa tjaḻinypa palyara nintilpayi tjukarurru wangkanytjaku. Nganalu pina patilpayi? Nganalu kuru palyalpayi? Nganalu kuru patira yaḻalpayi?, ngayulu yilta, mayutju Katutjalu watjaṉingka.” Muutjalu piyuku watjaṉu, “Ngayunya wiyaṉi wantirriyala!, wati kutjupa wantirriyala!” Palunyangka mayutju Katutjanya Muutjaku mulyarrarringkula watjaṉu, “Yaalytjin kuliṉi? Tjinguru nyuntupa kaaka Yirananyaṉantapula wantirriyalku? Paluru tjaḻinypa tjukarurru wangkapayi palya. Kuwarrinta ngalya yananyi Yirananya. Tjungurrira yarra tjananya!, palurulpi tjananya wangka palyalu nintintjaku. Nyuntu Yirananya nintilku tjukarurrungku tjananya tjakultjunkunytjaku.” ");
INSERT INTO piu2006_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","16","(3:13—4:16) Muutjalu Katutjanya piyuku tjapiṉu, “Tjinguruṉa Yitjurilaku walytja ngaṉṯitja tjuṯa yankula yalatjingku watjalku, ‘Nyurrangarrimpa tjuṯaku mayutju tiṉangku Katutjalu yiyaṉu ngayunya.’ Yalatjiṉa tjananya watjantjala, tjingurutjuya yalatji tjapilku, ‘Yini nganalunta iyaṉu? Mayutju paluru ngananya?’ Kanya ngayulu nyaaṉa tjananya watjalku?” Katutjalu Muutjanya watjaṉu, “Watjala tjananya! Yini ngayunyaṉa yalatji. ‘Ngayunyaṉa kutu nyinapayinya.’” Katutjalu piyuku watjaṉu Muutjanya, “Yalatji tjananya watjala! ‘Mayutju Katutjaluṉi wantirriyaṉu yirriṯi wiyarringutja tjuṯaku mayutju tiṉangku. Ngayulu tjanampa Yipuramaku, Yatjikaku Tjikupakuṯarra mayutju tiṉa nyinanyi.’ Muutja. Yankula tjananya mayutju tjuṯa yaḻṯirra kutjungkara tjakultjurra tjanala wangka yalatji! ‘Yitjipinya ngurrara tjuṯangku nyurranya yaḻṯuruwiyangku kanyiṉi. Yalatji kuliraṉa nyurranya katiku manta palyakutu. Yitjipinya ngurrara tjuṯangku nyurranya pungkula kanyiṉi, palunyangka manta Kayinanalakutuṉa nyurranya katirra nyinatjunku. Kuwarri manta palula kutjupa tjuṯa nyinanyi.’ Wangka palunya tjanala ngayuku walytja tjuṯangka nyuntu tjakultjunkunytjala, yiltaya kulilku. Palunyangka nyuntu yarra Piirulakutu!, yankula wangkanytjaku. Piirula yalatji wangka! ‘Yipuru wangkapayi tjuṯakulampatju mayutju tiṉalu Katutjalu watjaṉutjangka, yunytjurrinyilatju tjiṉṯu tjirripala yankula kunaṯinpa pungkula yungkunytjaku Katutjaku, waḻkura.’ Piirulu watjalku wiya nyurrangarri yanku palulawana. Yalatjikuṉa ninti nyinanyi. Palunyangka ngayuluṉa Katutjalu kuṉpu tiṉatjarrangkuṉa tjananya Yitjipinya ngurrara tjuṯa kutu yitjipungku. Palunyangkaya nguḻu tiṉarriku. Palulanguru Piirulu Yitjipinya ngurraralu yuwanmanku nyurrangarrinya ngalya wantirriyantjaku.” Muutjalu Katutjala watjaṉu, “Tjinguru Yitjurilaku walytja ngaṉṯitja tjuṯangku ngayuku wangka kulira wantiku. Tjinguruṉiya yalatji panypurangku, ‘Wiya Katutjanyanta yutitjarrira wangkangu. Nyuntu mungutja, ngunytjinytjunkupayi.’ Yalatji nguwanpaṉiya tjinguru watjalku, yaalytjirrikuṉa?” Katutjalu tjapiṉu Muutjanya, “Nyaan kanyiṉi?” Muutjalu watjaṉu, “Watiyaṉa kanyiṉi.” Watiya wana nguwanpa katiyankupayi. Mayutju Katutjalu piyuku watjaṉu, “Mantakutu waṉirriyala!” Mantangka watiya waṉingu, kanya piḻkaṯirringu. Piḻkaṯi nyakula Muutjanya tjalkaḻungu nguḻu warrpulpayingka. Katutjalu Muutjanya watjaṉu, “Piḻkaṯi wipu witira kanyila!” Palunyangka Muutjalu piḻkaṯi witintjala watiyarringulpi. Katutjalu piyuku watjaṉu, “Yitjurilaku walytja ngaṉṯitja tjuṯangku nyanganyingka, watiya waṉirriyala!, piḻkaṯirrinytjaku, panyapa nguwanpa. Nyakulaya yilta kulilku ngayuluṉanta watjara wantirriyaṉutjangka, mirri tjuṯaku mayutju tiṉa Katutjalu.” Katutjalu Muutjala piyuku watjaṉu, “Maranku kuutangka tjarrpatjurra!” Muutjalu parrpaṯu kulira tjarrpatjunu. Palunyatjanu yurrkura mara pikatjarralpi nyangu. Mayutju Katutjalu piyuku watjaṉu, “Piyukunku mara tjarrpatjurra, kuutangka!” Yalatji tjarrpatjunkula yurrkura pangki palyalpi nyangu. Mayutju Katutjalu Muutjala piyuku watjaṉu, “Tjinguru nyuntunya mara pikatjarra tjana nyakula tjuḻurrmanku, kulilkuya, ‘Yilta Katutjalu ngaatjanya mara pikantanu. Paluru ilta ngaatjanya wantirriyaṉu.’ Nyakulaya tjinguru wiya yalatji tjukarurrulu kulilku. Palulanguru kutjupa tjananya nintila!, kapi yintiṉingka ngurrkarriku. Karru Nayilangka nyuntu kapi mantjira mantakutu yintintjala yilta ngurrkarriku.” Muutjalu kulira watjaṉu, “Mayutju, ngayunya wiyaṉi wantirriyala! Tjaḻinypa wiyaṉa palya wangkapayi nyinanyi, purinypaṉa wangkapayi.” Mayutju Katutjalu watjaṉu, “Ngayuluṉa tjaḻinypa palyalpayi. Ngayuluṉa tjaḻinypa palyara nintilpayi tjukarurru wangkanytjaku. Nganalu pina patilpayi? Nganalu kuru palyalpayi? Nganalu kuru patira yaḻalpayi?, ngayulu yilta, mayutju Katutjalu watjaṉingka.” Muutjalu piyuku watjaṉu, “Ngayunya wiyaṉi wantirriyala!, wati kutjupa wantirriyala!” Palunyangka mayutju Katutjanya Muutjaku mulyarrarringkula watjaṉu, “Yaalytjin kuliṉi? Tjinguru nyuntupa kaaka Yirananyaṉantapula wantirriyalku? Paluru tjaḻinypa tjukarurru wangkapayi palya. Kuwarrinta ngalya yananyi Yirananya. Tjungurrira yarra tjananya!, palurulpi tjananya wangka palyalu nintintjaku. Nyuntu Yirananya nintilku tjukarurrungku tjananya tjakultjunkunytjaku.” ");
INSERT INTO piu2006_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","28","Palunyatjanu Muutjanya yarurringu waputju palumpa nyakunytjaku. Yalatjingku tjapiṉu, “Yunytjurrinyiṉa ngayuku walytja tjuṯa nyakukitja, ngurra Yitjipila.” Kanya palumpa waputjulu Tjiitjarulu watjaṉu, “Yuwa, palyan yanku walytja nyuntupa tjuṯa nyakunytjaku.” Palunyangka Muutjalu palumpa miiṯa an pipirri tjuṯa tuungkiyingka kaḻpatjunkula katingu, manta Yitjipilakutu. Katutjalu Yirananya watjara wantirriyaṉu Muutjalakutu. Yitjipingka yilarringkula, palumpa kaaka Yirananya nyakula yampuṉu tjungurrira yanu. Muutjalu Yirananya tjakultjunu Katutjalu watjara wantirriyaṉutjangka. ");
INSERT INTO piu2006_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","31","Muutjalukamu Yiranalupula yaḻṯirra mayutju tjuṯa ruunytjaṉu, watjalkitjangku. Palunya tjananya kapuṯunkula Yiranalu watjaṉu, Katutjalu Muutjanya watjara wantirriyaṉutjangka. Palulanguru Muutjalu tjananya Yitjurilaku walytja ngaṉṯitja tjuṯa nintiṉu watiyanguru piḻkaṯirrinytjaku, mara pangki pikatjarrarrinytjaku. Muutjakukamu Yiranaku wangkaya nguḻurrira kuliṉu. Kuliraya pupakatirra Katutjanya waḻkuṉu. ");
INSERT INTO piu2006_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","5","Yitjipiku mayutju tiṉakutu Piirukutu Muutjanyakamu Yirananya yanupula watjantjaku. Yalatjipula watjaṉu, “Yitjurilaku walytja ngaṉṯitja tjuṯaku mayutju tiṉalunta Katutjalu yalatji watjaṉu, ‘Ngayuku walytja tjuṯa tjananya kanyilwiyangku wanti!, taliwanaya yankuku ngayunya tjungurringkula waḻkuntjaku.’” Piirulu kulira mulyarrarringu watjaṉu, “Mayutju tiṉa panyapa ngananya? Ngurrpaṉa, wiyaṉa ninti palumpa. Yaṉangu palunya tjananya, wiyaṉa tjananya wantirriyalku.” Muutjalukamu Yiranalu watjaṉu, “Mayutju Katutjalulinyatju watjaṉu tjungulatju yankula ngurra kutjupawana kunaṯinpa pungkula kutjara mayutju Katutjaku yungkunytjaku. Kunaṯinpalatjura yankula pungkula yungkuwiyangka Katutjalulanyatju kulira mirri pungkutjipingka. Tjinguru pikatjarralatju nyinarra wiyarriku. Tjinguru kutjupa tjuṯalulanyatjuya mirri pungku wiyalku.” Piirulu pulanya watjaṉu, “Nyupali tjananya watjaṉutjangka waarrkawiyalpiya nyinaku, ngurra kutjupawana yankukitja. Watjala tjananyapula piyuku waarrkarrinytjaku!, wiyaya ngurra kutjupakutu yanku.” ");
INSERT INTO piu2006_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","14","Waarrkana tjuṯaku mayutju tjuṯangka tjananya Piirulu yalatjilu watjaṉu, “Yitjurilaku walytja ngaṉṯitja tjuṯa puntura waarrkarrinytjaku, pilkinguru kutu puḻi nguwanpa palyantjaku. Yirriṯi kutjupa tjuṯalu tjanampa tjanpi yantara katirra yungkupayi, puḻi nguwanpa palyantjaku. Kuwarri wiya waarrkana kutjupa tjuṯangku tjanampa tjanpi yantara katirra yungkunytjaku. Paluru tjanaya yantara ngalya katirra puḻi nguwanpa palyara tjunkunytjaku, Yipuru wangkapayi tjuṯangku. Nampa yirriṯiya palyalpayi, kututjaya nampa palunya nguwanpa palyantjaku. Waarrkawiyaya nyinanyi tjinguru yankukitja, ngurra kutjupakutu yankula kunaṯinpa pungkula kutjalkitja. Palunyangka tjananya puntura waarrkarrinytjaku, wiyaya ngurra kutjupakutu yankunytjaku.” Palulanguru Yitjipinya ngurrara mayutju tjuṯangku tjananya yankula Yipuru wangkapayi tjuṯa tjakultjunu, mayutju tiṉangku tjananya watjaṉutjangka. Watjaṉu tjananya walytjangkuya tjanpi mantjira puḻi nguwanpa nampa palunya nguwanpa palyantjaku. Palunyangka Yipuru wangkapayi tjuṯalu tjanpiku ngurriṉingi paṉa kutjupa kutjupawana. Mayutju Yitjipinya ngurrara tjuṯangku tjananya wiipatjarralu pungangi Yipuru wangkapayi tjuṯanya. Mayutju tiṉa paluru yalatji tjananya watjaṉu, “Nyurrangarrimpa waarrkana tjuṯa tjingapuwa!, punturaya waarrkarrinytjaku, puḻi nguwanpa nampa palyantjaku.” ");
INSERT INTO piu2006_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","21","Yipuru wangkapayi mayutju tjuṯangku puṯu kuliṉu tjanpi mantjira nampa palyalkitjalu. Puṯu kuliralpiya Piirulakutu yankula palunya, mayutju tiṉangka yalatji tjapiṉu, “Mayutju tiṉa. Nyaakulanyatju watjaṉu nyuntu puḻi nampa nguwanpa palyantjaku. Kutjupa tjuṯangkulanyatjuya tjanpi ngalya katinytjawiyangka, nampa panyapa palyantjaku, mayutju Yitjipinya ngurrara tjuṯangkulanya pungangi yaḻṯuruwiyangku.” Mayutju tiṉangku tjananya yalatji watjaṉu, “Kututjanyurra kulilwiya nyinanyi waarrka palyalwiya. Waarrkawiya nyinakitjangkunyurra ngunytji tjapilpayi, ngurra kutjupakutu yankula kunaṯinpa pungkula kutjalkitjangku. Kalanyurra yankula puntura waarrkarri! Wiyalatju nyurrangarrimpa tjanpi mantjira katirra yungku, kutunyurra tjanpi mantjira nampa palunya palyantjaku.” Yipuru wangkapayi mayutju tjuṯangkuya kulira watjilarringkula yankula Muutjanyakamu Yirananya payiṉu, “Nyupalipula mayutju tiṉangka watjaṉutjangkalampatju yunytjuwiya nyinanyi. Yalatjiku Katutjanya ninti nyinanyi. Katutja paluruntapula yitjipungku, nyupalipula mayutju tiṉa ngurrkurrinytjaku palyaṉu. Yitjipinya ngurrara tjuṯalampatjuya yunytjurringanyi mirri pungkukitja.” ");
INSERT INTO piu2006_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","23","(5:22—6:1) Palulanguru Muutjalu Katutjanya yalatji watjaṉu, “Mayutju. Nyaaku nyuntu tjananya wantinyi?, kutuya yitjipungkunytjaku, nyuntupa walytja Yipuru wangkapayi tjuṯanya. Nyaakutjun ngayunya wantirriyaṉu Yitjipilakutu? Ngayulu mayutju tiṉakutu yankula wangkangutjangka Yipuru wangkapayi tjuṯanya tjananya yunytjuwiyangku tjananya kutu pungkula kanyiṉi. Nyuntu tjananya yurrunpa ngurra kutjupakutu wantirriyanmara pungkupayi tjuṯangkamarra.” Katutjalu Muutjala wangkangu, “Kalalpi, kuwarriṉa mayutju tiṉa palunya yitjipungkula nguḻutjingalku. Nguḻurringanyingka nyuntu nyaku. Nguḻutjingaraṉa tjananya wantirriyalku Yipuru wangkapayi tjuṯa manta ngaangkaya nyinatjipingkamarra.” ");
INSERT INTO piu2006_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","(5:22—6:1) Palulanguru Muutjalu Katutjanya yalatji watjaṉu, “Mayutju. Nyaaku nyuntu tjananya wantinyi?, kutuya yitjipungkunytjaku, nyuntupa walytja Yipuru wangkapayi tjuṯanya. Nyaakutjun ngayunya wantirriyaṉu Yitjipilakutu? Ngayulu mayutju tiṉakutu yankula wangkangutjangka Yipuru wangkapayi tjuṯanya tjananya yunytjuwiyangku tjananya kutu pungkula kanyiṉi. Nyuntu tjananya yurrunpa ngurra kutjupakutu wantirriyanmara pungkupayi tjuṯangkamarra.” Katutjalu Muutjala wangkangu, “Kalalpi, kuwarriṉa mayutju tiṉa palunya yitjipungkula nguḻutjingalku. Nguḻurringanyingka nyuntu nyaku. Nguḻutjingaraṉa tjananya wantirriyalku Yipuru wangkapayi tjuṯa manta ngaangkaya nyinatjipingkamarra.” ");
INSERT INTO piu2006_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","13","Mayutju Katutjalu piyuku watjaṉu Muutjanyakamu Yirananya yankunytjaku, mayutju Piirulakutu wangkanytjaku. Katutjalu piyuku yalatji Muutjanya wangkangu, “Mayutju paluru tjinguru nyuntunya watjalku ngangkaritjarrangku palyantjaku. Yalatji watjantjala nyuntu Yirananya watjala!, palumpa watiya mantakutu waṉinytjaku, mayutju tiṉangka kurungka. Watiya palunya wantirriyaṉutja piḻkaṯirriku.” Ngunytjiya panya watiya wana nguwanpa katiyankupayi. Katutjalu pulanya watjaṉutjangka Muutjanya an Yirananya yanu mayutju tiṉakutu Piirulakutu. Katutjalu watjaṉingitjangkapula palyaṉu. Yiranalu palumpa watiya waṉirriyaṉutjangka, kanya piḻkaṯirringu, mayutju waarrkana tjuṯangka, kurungka. Mayutju palumpaku waarrkana tjuṯalu yatjiki palyalpayingku watiya tjuṯa waṉiwaṉingu, kanya paluru tjana piḻkaṯirringu. Palulanguru Yiranaku piḻkaṯilu tjananya kutjupa tjuṯa ngalkura wiyaṉu. Yalatji nyakula Piirulu wiya kuliṉingi tjananya wantirriyantjaku. Yipuru wangkapayi tjuṯanya, militjitjingku tjananya kanyiṉingi. ");
INSERT INTO piu2006_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","25","Mayutju Katutjalu Muutjalakutu yalatji watjaṉu, “Mayutju tiṉa paluru yilta militjitji nyinanyi. Palulanguru tjiṉṯungka nyupali mayutju tiṉangka yankula tjungurriwa!, karru Nayilakutu paluru yanku paltjintjaku. Nyupali tjungurrirra yalatji watjala!, ‘Yipuru wangkapayi tjuṯa tjananya nyuntu kanyilwiyangku wantinytjaku, yankulalatju mayutju Katutjanya ngurra kutjupawanalu waḻkuntjaku. Yalatji mayutju tiṉangkulanyatju Katutjalu watjaṉu. Nyuntu kulintjawiyangku kutu kanyintjala, mayutju Katutjalu yatjikilu kuṉpu tiṉangku palyalku, nyuntu nyakula yilta Katutjanya kulira nintirriku. Kuwarri karru ngaatjanya ngayuku watiyangku pampuntjangka tjatjakarriku. Tjatjakarrinytjala kapi ngurrara tjuṯa yiluku. Yilurra ngarrinyingka karru paṉṯi kuyarriku. Kapi panyapa tjatjakarrinyingka puṯunyurra tjikilkitjangku kulilku, Yitjipinya ngurrara tjuṯangku.’” Katutjalu piyuku watjaṉutjangka Yiranalu yankula palumpa watiyangka pampuṉu. Palulanguru kapi tjatjakarringu. Ngurra kutjupa kutjupangka Yitjipinya ngurrara tjuṯaku kapi tjatjakarringu. Kutu tjananya mayutju tiṉangku yitjipungkula kanyiṉingi. Yipuru wangkapayi tjuṯa wiyalingku wantirriyaṉu. ");
INSERT INTO piu2006_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","15","Mayutju Katutjalu Muutjangka yalatji wangkangu, “Mayutju Piirulakutu yankula watjala yalatjingku!, ‘Ngayuku walytja tjuṯa tjananya kanyilwiyangku wantirriyala!, yankulaya ngayunya waḻkuntjaku. Nyuntu kutu tjananya kanyiṉi yitjipungkula wantirriyalwiyangku. Ngayulu nyurrangarrimpa wantirriyalku ngaṉngi tjuṯa, Yitjipinya ngurrara tjuṯakuṉa waaḻawana, ngurra kutjupa kutjupawanaṯarra. Karruwana waaḻa tjuṯawana nyuntupa waaḻawana, yinytjamiwana kaṉilpa tjuṯawanaṯarra. Ngurra kutjupa kutjupawana ngaṉngi maa tjuṯarringku.’” Katutjalu Muutjanya piyuku watjaṉu Yiranalu palumpa watiya katura kanyintjaku kapi tjuṯangka. Yalatji kanyiṉingka ngaṉngi tjuṯalingkuya mantanguru ngurra Yitjipila nyinarra waṉingi. Palulanguru mayutju Piirululpi pulanya Muutjanyakamu Yirananya yaḻṯingu. Ngalya yankulapula ngaranytjala, mayutju paluru pulanya watjaṉu, “Nyuntupa mayutju tiṉanyapula tjapila!, ngaṉngi tjuṯanya yiyantjaku, ngurra waṉmalingku katirra wiyantjaku. Ngayuluṉa wantirriyalku nyupalimpa walytja tjuṯanya, tjana yankula kunaṯinpa pungkula yungkunytjaku.” Muutjalu Katutjanya tjapiṉu ngaṉngi tjuṯa tjanampa wiyantjaku. Ngaṉngi tjuṯa wiyarringutjangka nyakula mayutju paluru kutu tjananya kanyiṉingi, waarrkana waarrkarrinytjaku, Yitjurilaku walytja ngaṉṯitja tjuṯanya. Piirulu Muutjakukamu Yiranaku wangka wiya kuliṉu. ");
INSERT INTO piu2006_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","19","Mayutju Katutjalu Muutjala yalatji wangkangu, “Yirananya yalatji watjala!, palumpa watiyatjarralu pungkunytjaku manta, palulanguru kiwinyi tjuṯarrinytjaku. Tjuṯalingku manta Yitjipila nyinarra waṉiku.” Yaṉangu tjuṯaku, pulukaku, nanikutakuṯarra kiwinyi tjuṯarringu. Piirulu wiya tjananya wantirriyaṉu Yitjurilaku walytja ngaṉṯitja tjuṯa, yiyantjawiyangku, kanyiṉingi militjitjingku, kutu. Muutjakukamu Yiranaku wangka wiya kuliṉu. ");
INSERT INTO piu2006_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","32","Mayutju Katutjalu Muutjanya yalatji watjaṉu, “Karrukutu Piirunya paltjilkitja yananyingka, tjiṉṯungka nyuntu yankula tjungurriwa! Tjungurrira yalatji wangka!, ‘Ngayuku walytja tjuṯa tjananya kanyilwiyangku wantirriyala!, tjana ngayunya yankula waḻkuntjaku. Nyuntu tjananya kutu kanyiṉingka ngayulu nyurrangarrimpa yiyalku muungu tjuṯalingku. Paluru tjana tjarrpaku waaḻawana kutjupa kutjupawanaṯarra parra nyinaku. Ngurra waaḻangka yunngu tjarrparra puularriku, kanya ngayuku walytja tjuṯaku ngurrangka wiya. Tjiṉṯungka yatjikiluṉa muungu tjuṯa wantirriyalku. Manta Yitjipilawana muungu tjuṯarriku, nyakulanyurra kulilku ngayulu kuṉpu tiṉatjarrangku wantirriyantja. Ngayulu tjananya ngayuku walytja tjuṯa purinypalu kanyilku. Ngayuku walytja Yitjurilaku ngaṉṯitja tjuṯaṉa kanyiṉingka wiyaya muungutjarra nyinaku.’” Palulanguru Muutjalu yankula Piirula Katutjaku wangka tjakultjunu. Palulanguru Katutjalu muungu tjuṯalingku wantirriyaṉu. Nyarra palula Yitjipila nyinarra ruunytjarringu. Puṯu kulira Piirulu Muutjanyakamu Yirananya yaḻṯirra watjaṉu, “Palyanyurra manta ngaangka yila yankula kunaṯinpara yungkunytjaku, nyurrangarrimpa mayutju tiṉa.” Muutjalukamu Yiranalupula watjaṉu, “Wiyalatju paṉa ngaangka kunaṯinpa pungkunytjaku, Yitjipinya ngurralulanya nyakula ngurrira pungkupayingka. Nganaṉatju ngurra kutjupangka waṉma yankula kunaṯinpa pungkunytjaku, mayutju Katutjalu watjaṉutjangka.” Mayutju Piirulu watjaṉu, “Katutjanya tjapila!, muungu tjuṯa katirra wiyantjaku. Palyanyurra ngurra kutjupakutu yankunytjaku, waṉmawiya. Yilanyurra kunaṯinpa pungkula waḻkuntjaku.” Yilta Muutjalu tjapiṉu Katutjanya muungu tjuṯa wiyantjaku, palulanguru muungu tjuṯaya wiyarringu, kanya Piirulu tjananya ngunytji watjara militjitjingku kanyiṉingi, Yitjurilaku ngaṉṯitja tjuṯa. ");
INSERT INTO piu2006_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","7","Mayutju Katutjalu Muutjanya watjaṉu, “Yitjipinya ngurraraku mayutju tiṉakutu yankula yalatji tjakultjurra! ‘Yipuru wangkapayi tjuṯaku mayutju tiṉalulinyatju watjaṉu yalatji, “Ngayuku walytja tjuṯa tjananya wantirriyala kanyilwiyangku!, yankulaya ngayunya waḻkuntjaku. Nyuntu kulilwiyangku kutu kanyiṉingka, ngayuluṉa tjananya nyurrangarrimpa kuka tjuṯaṉa pungkula wiyalku. Pika tiṉatjarraya ngarala wiyarriku, naanytja tjuṯa, tuungkiyi tjuṯa, kamula, puluka, tjiipikamu nanikuta tjuṯaṯarra. Yalatji tjuṯaya yiluku, kanya kuka kutjupa tjuṯa Yitjurilaku ngaṉṯitja tjuṯaku ngulytju tjanampa kana ngarala waṉiku, yilunytjawiya. Yalatji watjara mungawinkiṉa nyurrampa pungku.” ’” Muutjalukamu Yiranalupula Yitjipiku mayutju tiṉakutu yankula panyapa tjakultjunu. Tjiṉṯu kutjupangka Yitjipinya ngurrara tjuṯaku tjanampa kuka yilurra wiyarringu, kanya Yipuru wangkapayiku tjanampa kana kutu ngarala waṉingi, yiluwiya. Piirulu tjananya militjitjingku kanyiṉingi, Yitjurilaku ngaṉṯitja tjuṯa. ");
INSERT INTO piu2006_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","12","Mayutju Katutjalu pulanya Muutjanyakamu Yirananya yalatji watjaṉu, “Warutjanu tjuṉpa mantjira Muutjalu katu waṉinytjaku, mayutju tiṉanya ngaranytjala. Yalatji waṉinytjala waḻpangku katiku, manta Yitjipilawana. Palulanguru pika puyila tjuṯa yaṉangu tjuṯangka pakara taḻṯurriku, kuka tjuṯangkaṯarra.” Palulanguru pika katjuru paluru yaṉangu tjuṯangka pakara taḻṯurringu, kuka tjuṯangkaṯarra. Kutu mayutju paluru kaṉṯilyangku kanyiṉingi tjananya iyalwiyangku. Piirulu wiya Muutjakukamu Yiranaku wangka kuliṉu. ");
INSERT INTO piu2006_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","35","Mayutju Katutjalu Muutjanya yalatji watjaṉu, “Aaḻi yankula Piirula watjalku, ngayuku walytja tjuṯa kanyilwiyangku wantirriyantjaku, yankula tjana ngayunya waḻkuntjaku. Yalatji mayutju tiṉa palula watjala!, ‘Kuwarriṉa nyurranya tjuṯalingku yitjipungku nyuntunya, nyuntupa waarrkana tjuṯaṯarra. Yitjipungkunytjala yalatjinyurra tjukarurru kulilku, ngayuluṉa mayutju tiṉa kutju nyinanyi. Yurrunpa ngayuluṉa nyurranya wiya puntura yitjipungkupayi. Kala, kuwarriṉa nyurranya puntura yitjipungku, kulira ngayunyalpinyurra waḻkulku, kutjupa kutjupa ngurrara tjuṯaṯarra. Kutuya Yitjipingka nyinanyi, ngayuku walytja tjuṯa. Nyuntu tjananya wantirriyalwiyangku kanyiṉi. Palulanguru kuwarri tjiṉṯungka kunaṯa inpurangku pungkuku nyurranya. Yurrunpa yalatji nguwanpa wiya nyurranya pungkupayi. Nyurrangarrimpa waarrkana tjuṯangka tjananya watjala!, puluka tjiipi, nanikutaṯarra, waaḻangka tjarrpatjunkunytjaku, kunaṯangku pungkula yiluntankupayingka. Yaṉangu tjuṯaṯarra waaḻangka tjarrparra kumpira ngaranytjaku.’” Muutjalu yankula wangka palunya maa watjaṉu, mayutju tiṉangka. Palulanguru Katutjalu Muutjala piyuku watjaṉu palumpa watiya katura kanyintjaku ilkarikutu. Palunyangka mayutju Katutjalu kunaṯa tiṉa tjanampa waṉiwaṉirriyaṉu. Maṉngirri tiṉangku rungkara tuutuuraṉu. Kunaṯa tiṉangku tjananya pungkula yiluntanangi waaḻangka yila ngaranyingka. Yaṉangu tjuṯa kuka tjuṯaṯarra pungkula wiyaṉu. Watiya, yukiri tjuṯaṯarra kilytjuntankula wiyaṉu. Manta Kuutjinangka kutju tjananya wiya pungu kunaṯangku, Yitjurilaku ngulytju ngaṉṯitja tjuṯa. Yitjipiku mayutju tiṉa paluru watjara wantirriyaṉu Muutjanyakamu Yirananyapula yaḻṯirra ngalya katinytjaku. Ngalya yankulapula ngaranytjala Piirulu pulanya yalatji watjaṉu, “Kalalpi, Katutjanyapula tjapila!, kunaṯa wiyarrinytjaku. Mayutju Katutjanya kutju tjukarurru nyinanyi. Ngayuluṉa wiyawanangku Katutjanya kulilpayi, ngayuku walytja tjuṯangkuṯarra. Watjaṉiṉantapula waarrkana tjuṯa ngayulu tjananya kanyilwiyangku wantirriyalkitjalu. Palyanyurra tjuṯa yankunytjaku.” Palunyangka Muutjalu yankula tawunungka yila ngarala mara katura Katutjanya tjapiṉu kunaṯakamu kapi wiyarrinytjaku. Yitjipiku mayutju tiṉalu nyakula kunaṯa kapi wiyarrinytjala, militjitjingku Yipuru wangkapayi tjuṯa kanyiṉingi, yiyantjawiyangku. ");
INSERT INTO piu2006_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","20","Mayutju Katutjalu Muutjala yalatji watjaṉu, “Piirunyakamu mayutju tiṉa tjuṯaṯarra militjitjiya nyinanyi. Ngayuluṉa tjananya yaṉpiri patiṉu militjitjiya kutu nyinanytjaku. Kutuya yalatji nyinanytjala ngayuluṉa tjananya kuṉpu tiṉatjarrangkuṉa yitjipungku, nyurrangarri ngayunya kutju kulira waḻkuntjaku, nyurrangarrimpa ngaṉṯitja tjuṯangkuṯarra.” Katutjalu pulanya Yirananya wangka kutjupa wangkarra wantingu. Palulangurupula yankula Piirula yalatji watjaṉu, “Yipuru wangkapayi tjuṯaku mayutju tiṉalu watjaṉu, ‘Nyaakun nyuntu kutu puṯu kulilpayi? Ngayuku walytja tjuṯa tjananya kanyilwiyangku wanti!, yankulatjuya waḻkuntjaku. Nyuntu kutu militjitji nyinanyingka mungawinkiṉa tjiṉṯilyka tjuṯalingku wantirriyalku. Yukiri, watiya tjuṯa tjananya ngalkura kilytjuntara wiyalku, tjiṉṯilyka ruunytjangku.’” Yitjipinya ngurrara tjuṯaku mayutju Piirulu kulira pulanya yarurringkula yanu. Muutjalu Yiranaluṯarra Piiruku ngurra wantikatirra yanu. Palulanguru palumpa waarrkana tjuṯangku wanara marrkuṉu, “Nyuntu kulila! Ngurralampa manta Yitjipinya kuyarringu. Palunyatjanu Yipuru wangkapayi tjuṯa tjananya kanyilwiyangku wanti!, yankulaya mayutju Katutjanya waḻkuntjaku.” Palulanguru Piirulu tjananya watjaṉu Muutjanyakamu Yirananya yankula yaḻṯirra ngalya katinytjaku. Piirulu pulanya yalatji watjaṉu, “Kalalpi, palyanyurra yankula nyurrangarrimpa mayutju Katutjanya waḻkuntjaku.” Muutjalu watjaṉu, “Tjuṯalatju tjungu yanku, wati tjuṯa kungkakamu pipirri tjuṯa, tjiipi tjuṯa, nanikuta tjuṯa, puluka tjuṯaṯarra. Katutjanyalatju tjuṯangku waḻkulku.” Mayutju tiṉalu watjaṉu, “Wiya tjuṯa, wati tjuṯa kutjunyurra yankunytjaku. Kungkakamu pipirri tjuṯa ngaangka kutu nyinanytjaku.” Wangka palunya watjara mayutju tiṉalu pulanya wantirriyaṉu. Palunyangka Katutjalu tjiṉṯilyka tjuṯa wantirriyaṉu, yukiri watiya tjuṯa ngalkula kilytjuntankula wiyantjaku. Yalatji ngalkuṉingitjangka mayutju paluru pulanya Muutjanyakamu Yirananya yaḻṯingu. Piyuku pulanya ngunytjilyinu, Yipuru wangkapayi tjuṯa kanyilwiyangku wantirriyalkitjangku. Palunyangka waḻpa tiṉangku wilurarranguru tjiṉṯilyka tjuṯa tjananya rungkara katirra kapingka wiyaṉu, kanya Piirulu tjananya militjitjingku kanyiṉingi wantirriyalwiyangku. ");
INSERT INTO piu2006_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","29","Mayutju Katutjalu Muutjanya yalatjilu watjaṉu, “Nyuntu mara katura yilkarikutu kanyintjala, manta Yitjipilawana munga tiṉa ngaraku.” Palunyangka pakara yankula Muutjalu mara kanyiṉingka munga tiṉa rawa ngarangu, tjiṉṯu tjirripala, Yitjipinya ngurraraku ngurrawana. Palunyangkaya rawa nyinangi ngurra walytja kutjuṯu kutjuṯungka, pakara yankunytjawiya, kanya Yitjurilaku ngulytju ngaṉṯitja tjuṯaya ngurrawana palya tjanampa ngarangu. Mungangka rawa nyinarra Yitjipiku mayutju tiṉalu waarrkana wantirriyaṉu Muutjanya yaḻṯirra ngalya katinytjaku. Muutjanya ngalya yankula ngaranytjala, mayutju paluru watjaṉu, “Palyanyurra tjungu yankula nyurrangarrimpa mayutju tiṉa waḻkuntjaku, kungka tjuṯangku, pipirri tjuṯangkuṯarra. Nyurrangarrimpa kuka tjuṯa kutju ngaangka wantikatinytjaku, tjiipi, nanikutakamu puluka.” Muutjalu watjaṉu, “Wiya. Kuka tjuṯalatju tjananya katiku, ngurra palunyangkalatju nyakula kunaṯinpa pungkukitjalu.” Mayutju Katutjalu Yitjipiku mayutju militjitji nyinatjunutjangka, palunya yaṉpiri, patiṉu miltjitji kutu nyinanytjaku. Mayutju paluru Muutjanya payira wantirriyaṉu, “Wantirraṉi yarra!, maḻaku ngalya yankula nyakunytjawiya. Nyuntu ngalya yankula ngayula piyuku yutirriku, ngayuluṉa tjananya watjalku nyuntunyantaya mirri pungkunytjaku.” Muutjalu watjaṉu, “Tjukarurrun watjaṉu. Wiyan piyuku ngayunya nyaku.” ");
INSERT INTO piu2006_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","10","(11:1—12:27) Mayutju Katutjalu Muutjanya piyuku watjaṉu, “Yitjipinya ngurrara tjuṯa tjananya kutjungaralpi ngayulu kuwarri yitjipungku. Palunyatjanu mayutju paluru kanyilwiyangku nyurrangarrinya wantirriyalku. Kalalpi Muutja, nyuntu tjananya Yitjurilaku ngulytju ngaṉṯitja tjuṯanya yankula yalatji tjakultjurra!, ‘Yitjipinya ngurrara tjuṯa tjananya tjapila!, ngurra kutjungka nyinapayilu nyurranya mani nguwanpa yungkunytjaku, puḻi tjiilpa, puḻi kuulta.’” Muutjakuya kulira nguḻurringu mayutju tiṉa nyinanytjala, Yitjipinya ngurrara tjuṯa mayutju tiṉaku walytja tjuṯaṯarra. Mayutju Katutjalu tjananya nguḻutjingaṉu Yitjipinya ngurrara tjuṯa. Nguḻu nguwanpaya nyinangi Yitjurilaku ngulytju ngaṉṯitja tjuṯaku. Muutjalu yankula mayutju tiṉangka yalatjingku tjakultjunu, “Mayutju Katutjalunta yalatji watjaṉu, ‘Munga ngururrkutu kuwarri paṉa Yitjipilawana yankuku Katutjaku nyaḻpitjarra. Palulanguru katja yurruntitja tjuṯalingku yiluku, uwankarra. Katja tjuṯa nyurrampa yiluku ngurra ngaangka. Mayutju tiṉa. Nyuntupa katjaṯarra waarrkana kuyakuya tjuṯaku katjaṯarra, kuka tjuṯa uḻa wiima yurruntitja tjuṯaṯarra yiluku. Palunyangkanyurra katjatjirratja kulira yulaku, kanya Yitjurilaku ngulytju ngaṉṯitja tjuṯa ngaangka palya nyinaku. Katja yurruntitja tjuṯa tjanampa kutu kana nyinaku. Palunyangka nyuntu mayutju tiṉa ninti nyinaku, Katutjalu palumpa ngulytju tjuṯa tjananya yaṉṯayaṉṯara palya kanyilpayi.’” Mayutju Katutjalu pulanya Muutjanyakamu Yirananya yalatjilu watjaṉu, “Yalatji tjananyapula watjala!, Yitjurilaku ngulytju ngaṉṯitja tjuṯakutu. Pira yalangaangka tjiṉṯu nampa tiinangka wati tjuṯangkunyurra kutjuṯu kutjuṯu kunaṯinpa palya kilytjunpawiya mantjintjaku, tjiipi uḻa wiima tjinguru nanikuta uḻa wiima. Pipirri tjuṯatjarralu kunaṯinpa tiṉalingku mantjintjaku, kanya pipirri tjirripalatjarrangku tjukutjuku mantjintjaku ngalkura wiyantjaku. Tjinguru miiṯararralu pipirri wiimatjarrangku puṯu kulilku ngalkula wiyalkitjangku. Palumpa kutjarraku walytja kutjupa tjuṯangku ngalya yankula tjungurrirra kunaṯinpa ngalkula wiyantjaku, palula kutjarrangka. “Kunaṯinpa palunya tjuṯanyurra mantjira kana kanyira tjiṉṯu nampa puutinangka mungarrtji mirri pungkunytjaku, tjiṉṯu tjarrpanyingka ngaṉṯi. Mirri pungkulanyurra kaṉilpangka ngurrka tjutira waaḻa walytjangka katirra tjunkula wanantjaku. Kantily kutjarra yaḻangka kutjuya palyara tjurra!, yaḻangka katuwanaṯarra. Kunaṯinpa tjiipi palunya pungkulanyurra paṯantjaku. Kuka palunya ngarrirra ngurrka paṉakutu tjutira wiyarrinytjala mantjiranyurra kutjantjaku. Mungangka kuka palunya ngalkula wiyantjaku. Kapingka wiyanyurra puyilamilara kutjantjaku, kulkungka kutjunyurra kutjara ngalkuntjaku. Mangarri tjaati kutjunyurra ngalkuntjaku. Tjingurunyurra kuka palunya tiṉa ngalkula puṯu kulilku wiyalkitjangku, palunyatjanungkunyurra ngalkula wantinytja warungka kutjara wiyantjaku. “Nyurrangarri ngurra Yitjipinya wantirra yankukitjangku, kuka palunya parrpaṯu ngalkula wiyantjaku, yurrunpanyurra tjinakuṉungka tjarrparra yulytja pulangkitiṯarra ruulamapintjaku. Pulangkiti yulytja tjuṯaṯarra riirri kanyira yankukitjangkunyurra parrpaṯu ngalkula wiyantjaku. Ngulanyurra manta Kayinanalakutu yankula nyinarra palunya nguwanpanyurra tuḻku palyara ngalkula ngayunya Katutjanyanyurra waḻkuntjaku. Pira palula kutju tjiṉṯu nampa puutinangka ngalkuntjaku.” Mayutju Katutjalu pulanya Muutjanyakamu Yirananya yalatjilu watjaṉu, “Manta Kayinanangkanyurra nyinarra tuḻku Patjuwupanya yalatji palyala! Tjiṉṯu nampa puutinangkanyurra tjuṯarringku, ngayunya Katutjanya waḻkuntjaku. Kukanyurra pungkuku ngurrangka tjutira panyapa nguwanpa parrpaṯu mungula! Tjiṉṯu panyapangka mangarri tjaatinyurra ngalkuntjaku. Mangarri tjaati kutju kutunyurra ngalkunma!, tjiṉṯu tjikitjipalarrinyingka. Tjiṉṯu nampa puutinangka pikinpawutuku ngurrilaya waaḻa walytjawana!, mantjira katirra waṉirriyantjaku. Tjiṉṯu palunyangka mangarri tjaati kutjunyurra kutjara munguntjaku. Yalatjinyurra tjiṉṯu tjikitjipala nyinarra mangarri tjaati ngalkuntjaku. Yalatji ngalkula piyukunyurra tjuṯarrirra ngayunya Katutjanya waḻkuntjaku. “Tjiṉṯu palunya tjuṯangka tjinguru yaṉangulu mangarri pikinpawututjarra kutjara ngalkunytjala tjungurrinytjawiyangkunyurra wantinytjaku. Yaṉangu paluru ngayuku walytja wiya nyinaku.” ");
INSERT INTO piu2006_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","27","(11:1—12:27) Mayutju Katutjalu Muutjanya piyuku watjaṉu, “Yitjipinya ngurrara tjuṯa tjananya kutjungaralpi ngayulu kuwarri yitjipungku. Palunyatjanu mayutju paluru kanyilwiyangku nyurrangarrinya wantirriyalku. Kalalpi Muutja, nyuntu tjananya Yitjurilaku ngulytju ngaṉṯitja tjuṯanya yankula yalatji tjakultjurra!, ‘Yitjipinya ngurrara tjuṯa tjananya tjapila!, ngurra kutjungka nyinapayilu nyurranya mani nguwanpa yungkunytjaku, puḻi tjiilpa, puḻi kuulta.’” Muutjakuya kulira nguḻurringu mayutju tiṉa nyinanytjala, Yitjipinya ngurrara tjuṯa mayutju tiṉaku walytja tjuṯaṯarra. Mayutju Katutjalu tjananya nguḻutjingaṉu Yitjipinya ngurrara tjuṯa. Nguḻu nguwanpaya nyinangi Yitjurilaku ngulytju ngaṉṯitja tjuṯaku. Muutjalu yankula mayutju tiṉangka yalatjingku tjakultjunu, “Mayutju Katutjalunta yalatji watjaṉu, ‘Munga ngururrkutu kuwarri paṉa Yitjipilawana yankuku Katutjaku nyaḻpitjarra. Palulanguru katja yurruntitja tjuṯalingku yiluku, uwankarra. Katja tjuṯa nyurrampa yiluku ngurra ngaangka. Mayutju tiṉa. Nyuntupa katjaṯarra waarrkana kuyakuya tjuṯaku katjaṯarra, kuka tjuṯa uḻa wiima yurruntitja tjuṯaṯarra yiluku. Palunyangkanyurra katjatjirratja kulira yulaku, kanya Yitjurilaku ngulytju ngaṉṯitja tjuṯa ngaangka palya nyinaku. Katja yurruntitja tjuṯa tjanampa kutu kana nyinaku. Palunyangka nyuntu mayutju tiṉa ninti nyinaku, Katutjalu palumpa ngulytju tjuṯa tjananya yaṉṯayaṉṯara palya kanyilpayi.’” Mayutju Katutjalu pulanya Muutjanyakamu Yirananya yalatjilu watjaṉu, “Yalatji tjananyapula watjala!, Yitjurilaku ngulytju ngaṉṯitja tjuṯakutu. Pira yalangaangka tjiṉṯu nampa tiinangka wati tjuṯangkunyurra kutjuṯu kutjuṯu kunaṯinpa palya kilytjunpawiya mantjintjaku, tjiipi uḻa wiima tjinguru nanikuta uḻa wiima. Pipirri tjuṯatjarralu kunaṯinpa tiṉalingku mantjintjaku, kanya pipirri tjirripalatjarrangku tjukutjuku mantjintjaku ngalkura wiyantjaku. Tjinguru miiṯararralu pipirri wiimatjarrangku puṯu kulilku ngalkula wiyalkitjangku. Palumpa kutjarraku walytja kutjupa tjuṯangku ngalya yankula tjungurrirra kunaṯinpa ngalkula wiyantjaku, palula kutjarrangka. “Kunaṯinpa palunya tjuṯanyurra mantjira kana kanyira tjiṉṯu nampa puutinangka mungarrtji mirri pungkunytjaku, tjiṉṯu tjarrpanyingka ngaṉṯi. Mirri pungkulanyurra kaṉilpangka ngurrka tjutira waaḻa walytjangka katirra tjunkula wanantjaku. Kantily kutjarra yaḻangka kutjuya palyara tjurra!, yaḻangka katuwanaṯarra. Kunaṯinpa tjiipi palunya pungkulanyurra paṯantjaku. Kuka palunya ngarrirra ngurrka paṉakutu tjutira wiyarrinytjala mantjiranyurra kutjantjaku. Mungangka kuka palunya ngalkula wiyantjaku. Kapingka wiyanyurra puyilamilara kutjantjaku, kulkungka kutjunyurra kutjara ngalkuntjaku. Mangarri tjaati kutjunyurra ngalkuntjaku. Tjingurunyurra kuka palunya tiṉa ngalkula puṯu kulilku wiyalkitjangku, palunyatjanungkunyurra ngalkula wantinytja warungka kutjara wiyantjaku. “Nyurrangarri ngurra Yitjipinya wantirra yankukitjangku, kuka palunya parrpaṯu ngalkula wiyantjaku, yurrunpanyurra tjinakuṉungka tjarrparra yulytja pulangkitiṯarra ruulamapintjaku. Pulangkiti yulytja tjuṯaṯarra riirri kanyira yankukitjangkunyurra parrpaṯu ngalkula wiyantjaku. Ngulanyurra manta Kayinanalakutu yankula nyinarra palunya nguwanpanyurra tuḻku palyara ngalkula ngayunya Katutjanyanyurra waḻkuntjaku. Pira palula kutju tjiṉṯu nampa puutinangka ngalkuntjaku.” Mayutju Katutjalu pulanya Muutjanyakamu Yirananya yalatjilu watjaṉu, “Manta Kayinanangkanyurra nyinarra tuḻku Patjuwupanya yalatji palyala! Tjiṉṯu nampa puutinangkanyurra tjuṯarringku, ngayunya Katutjanya waḻkuntjaku. Kukanyurra pungkuku ngurrangka tjutira panyapa nguwanpa parrpaṯu mungula! Tjiṉṯu panyapangka mangarri tjaatinyurra ngalkuntjaku. Mangarri tjaati kutju kutunyurra ngalkunma!, tjiṉṯu tjikitjipalarrinyingka. Tjiṉṯu nampa puutinangka pikinpawutuku ngurrilaya waaḻa walytjawana!, mantjira katirra waṉirriyantjaku. Tjiṉṯu palunyangka mangarri tjaati kutjunyurra kutjara munguntjaku. Yalatjinyurra tjiṉṯu tjikitjipala nyinarra mangarri tjaati ngalkuntjaku. Yalatji ngalkula piyukunyurra tjuṯarrirra ngayunya Katutjanya waḻkuntjaku. “Tjiṉṯu palunya tjuṯangka tjinguru yaṉangulu mangarri pikinpawututjarra kutjara ngalkunytjala tjungurrinytjawiyangkunyurra wantinytjaku. Yaṉangu paluru ngayuku walytja wiya nyinaku.” ");
INSERT INTO piu2006_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","30","Palunya tjakultjunkunytja kuliraya Yitjurilaku ngulytju ngaṉṯitja tjuṯangkuya kunaṯinpa pungkula ngurrka kaṉilpangka tjutiṉu. Tjutiraya watiya parrkangka tjulyultjunkula tuuwawana tjunangi, kantilypa kutjarrawanaṯarra tuuwangka katuwana. Palunyatjanu munga ngururrkutu Katutjalu waarrkana nyaḻpitjarra yiyaṉu mirri pungkunytjaku, Yitjipinya ngurraraku katja yurruntitja tjuṯanya. Katja yurruntitja tjuṯa tjananya mirri pungu, mayutjuku katjaṯarra, kuka tjuṯakuṉu uḻa wiima yurruntitja tjuṯaṯarra. Yitjipinya ngurrara tjuṯaya yularra waṉingi. Puṯuraya kulira walytjayanku yulangi, katja yurruntitjatjirratja, mirri nyakula, kanya Yitjurilaku ngulytju ngaṉṯitja tjuṯa palyaya nyinangi. Kuliraya ngurrka tuuwawana tjunu, Muutjalu watjaṉutjangka. ");
INSERT INTO piu2006_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","36","Munga palula mayutju tiṉa paluru watjaṉu, Muutjanyakamu Yirananya yaḻṯirra ngalya katinytjaku. Ngalya yankunytjala pulanya watjaṉu, “Tjuṯangkuya ngurra ngaatja wantirra yarra! Nyupali panyapa tjapiṉutjangka, tjuṯalunyurra yankula mayutju Katutjanya waḻkula! Katutjanyapula tjapila!, nganaṉanya piyukulanyatju yitjipungkupayingka. Nyurrangarrimpa tjiipi tjuṯa, nanikuta tjuṯa katinytjaku tjananya, puluka tjuṯaṯarra.” Yitjipinya ngurrara tjuṯalu tjananya parrpaṯu parrpaṯunangi, pakaraya tjuṯa yankunytjaku. Wantirriyalkitjangku tjananya tjana yalatji watjaṉu, “Pakaraya tjuṯa, kutu yarra!, Katutjalulpilanya Yitjipinya ngurrara tjuṯa mirri pungkutjipingkamarra.” Palunyangka Yitjurilaku ngulytju ngaṉṯitja tjuṯangku kaṉilpa, mangarri tjaatitjarra, yulytjakamu pulangkitingka karrpira tjaḻira katingu. Muutjalu tjananya yurrun yurrunpa watjaṉutjangka yalatji, “Tjapilaya Yitjipinya ngurrara tjuṯangka!, ‘Mani puḻi tjiilpa, puḻi kuultakamu yungkunytjakulanya.’” Paluru tjana mani puḻi tjiilpa, puḻi kuultaṯarraya katiyanu paṉa Yitjipinya wantikatirra. ");
INSERT INTO piu2006_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","22","Paṉa Kayinanalakutu Katutjalu wiya tjukarurrungku katiyanangi, manangkarrawana tjananya katiyanangi. Katutjalu yalatji kuliṉu, “Paṉa Kayinananya ngurrara tjuṯa tjananya pikangku mirri pungkula kutju, palyaya nyinaku ngurra palula, Yitjurilaku ngulytju ngaṉṯi tjuṯa. Paluru tjana nguḻu paṉa Kayinananya ngurrara tjuṯaku nyinangi. Tjinguruya nguḻu paṉa Yitjipilakutu maḻaku yankutjipingka, ngurra waṉmawanaṉa tjananya ngayulu katiyankuku, kapi yini Tjatjakalawana.” Yalatjiya manangkarrawana rawa yulytjayinangi. Yurrunpa Tjutjupalu watjaṉutjangka Muutjalu Tjutjupanya mirri tarrka katiyinangi. Yankula ngurra Tjakutjangka tjarrpangu. Palunyatjanuya ngurra Yiltjamalakutu yanu, manangkarrangka yila ngaranytjala. Mayutju Katutjanya tjanampa tjiṉṯungka yutuwari nguwanpa yurrunpa yankulinangi. Kanya Yitjurilaku ngulytju ngaṉṯitja tjuṯa ngaṉṯiwana yankulinangi. Mungangka mayutju Katutjanya tjanampa waru tili nguwanpa yurrunpa yanangi. ");
INSERT INTO piu2006_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","12","Yitjipinya ngurrara tjuṯaya mayutju tiṉangkuṯarra nyinarra waarrkana tjuṯaku puṯu kulira yalatjingkuya watjaṉu, “Nyaakula tjananya wantirriyaṉu?, Yitjurilaku ngulytju ngaṉṯitja tjuṯa.” Tjana yalatji wangkangu, “Waarrkanawiyalpila nyinanyi.” Mayutju tiṉa paluru tjananya wakina naanytjatjarra katiyankupayi tjuṯa yaḻṯingu. Paluru tjilirratjarra kutjupa tjuṯa naanytjangka kaḻparra yankupayi yaḻṯingu. Palumpa tjilirratjarra tjuṯa tjananya tjina yankupayi yaḻṯingu. Tjilirratjarra tjuṯangkuya Yitjurilaku ngulytju ngaṉṯitja tjuṯa wanaṉu, pungkunytjaku. Kapi Tjatjakangka yila Muutjalukamu yaṉangu tjuṯangku nyinarra nyangu, Yitjipinya ngurrara tjuṯa waṉma ngalya yananyingka. Yaṉangu paluru tjanaya nyakula nguḻurrirra mayutju Katutjanya tjapiṉu mirri pungkupayingka. Paluru tjana Muutjanya panypurangkula watjaṉu, “Nyaakulanyatju nyuntu ngurra ngaakutu ngalya katingu? Ngaangkalpilanya pungkula yiluntankuku. Yitjipilalatju palya nyinamara, ngurra palulalatju nyinarra wiyarringamara. Nyaakulanya ngaakutu ngalya katingu?, palyalatju waarrkana kutu nyinamara, ngaakutu ngalya yankula yilupayingka.” ");
INSERT INTO piu2006_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","31","Muutjalu tjananya watjaṉu, “Yitjipinya ngurrara tjuṯaku nguḻurrinytjaku wiya, raapaya ngaranytjaku. Yalatji ngaralanyurra nintirriku, Katutjalulanya kanalku. Nyarra Yitjipinya ngurrara tjuṯa tjananya kuwarrinyurra nyaku, mayutju Katutjalu kuwarri pungku tjananya, pikalu tjananyanyurra pungkutjipingkamarra. Pika pungkunytjawiya nyurrangarri ngaranytjaku.” Yurrunpa nyaḻpitjarra kutju Katutjaku waarrkana Yitjurilaku ngulytju ngaṉṯitja tjuṯaku yurrunpa yankupayi. Palulanguru paluru parra yankula ngaṉṯiwanalpi tjanampa ngaralinangi, Yitjipinya ngurrara tjuṯangku tjananya wanara pungkupayingkamarra. Yutuwari paluru tjanampa yurrunpa ngaralinangi. Palulanguru parra yanu ngaṉṯiwanalpi ngarangi, Yitjurilaku ngulytju ngaṉṯitja tjuṯaku maḻpa. Yalatji ngarala munga tjanampa Yitjipinya ngurrara tjuṯaku ngarangi. Kanya Yipuru wangkapayi tjuṯaku tjanampa tili ngarangi. Yalatji Katutjalu tjananya Yitjurilaku ngulytju ngaṉṯitja tjuṯaku ngaḻkinpa yangatjunu, Yitjipinya ngurrara tjuṯangku pikalu pungkutjipingka. Yurrunpa Katutjalu Muutjanya wangkangu watiya katura kanyintjaku kapi Tjatjakangka. Palulanguru paluru yankula yilta watiya kanyiṉingi. Palulanguru waḻpa kakarraranguru mungangka tiṉalingku wangkarra tjiṉṯukutu wiyarringu. Yalatji waḻpa tiṉa wangkanyingka kapi wiyarringu, yiwarra tjanampa tarayi ngarangu. Kapi kutjarra ngaṉtjarrpa kutjarra ngaranyingka Yitjurilaku ngulyju ngaṉṯitja tjuṯaya tjarukatirra yankula paṉa palyangka maa tatiṉu. Palulanguru tjananya Yitjipinya ngurrara tjuṯangku pungkukitjangku ngaṉṯiwanangku wanaṉu. Tjuṯangku tjananya tjarukatirra wanaṉu tjilirratjarra tjuṯangku, anta naanytjatjarra tjuṯangku, wakinangka yankupayi tjuṯalu. Tjiṉṯu ngalya katurringanyingka Katutjalu tjananya nguḻutjingaṉu. Tulykungku wakina tjanampa taayi tjuṯa witira kanyiṉu. Puṯuya wakinatjarra tjuṯangku katirra yilarringutjangka Yitjipinya ngurrara tjuṯangku watjaṉu, “Mayutju Katutjalulampa kuyaṉu, Yitjurilaku ngulytju ngaṉṯitjaku walytjangku. Wakina wantirralaka yarra maḻaku!” Kala, yurungku tjananya Yitjipinya ngurrara tjuṯa mirrintanu, kutju wiya kana nyinangu, wiya. ");
INSERT INTO piu2006_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","26","Palulanguru tjananya Muutjalu katiyinangi mayutju tiṉangku. Kapi Tjatjakanya wantirraya kapiwiyawana mangarriwiyawana yanu. Kapikuya puṯu ngurrira nyakulinkula tjiṉṯu tjirripala yankula kapi yini Maarangkaya tjarrpangu. Tjikiraya puṯu yarrkaṉu paṉṯutjarra. Yaṉangu tjuṯaluya puṯu yarrkara Muutjakulpiya ngurrkurringu, “Wiyawanalulanyatjun ngunytji ngalya katingu, kapiwiyakutu. Nyaaltala tjikilku?” Palunyangka Muutjalu Katutjanya tjapiṉu kapi tjikilkitjangku puṯu kulira. Katutjalu Muutjanya nintiṉu watiya ngarrinyingka. Muutjalu mantjira katirra kapikutu watiya waṉirriyanyingka, kapi palyarringulpi. Palulanguru kapi tjikiraya paḻtjarringu. Ngula palunyatjanu Katutjaku luwu tjuṯa tjananya Muutjalu nintiṉu, kuliraya tjukarurru nyinanytjaku. Yalatji tjananya Katutjalu watjaṉutja tjakultjunu, “Ngayuluṉa nyurranya watjaṉutjangka kuliranyurra tjukarurru nyinanytjaku. Tjukarurrunyurra kutu palya nyinanyingka, wiyaṉa nyurranya yitjipungku. Yitjipinya ngurrara tjuṯaṉa tjananya yitjipungkula wiyaṉu, kanya ngayuluṉa nyurranya yaṉṯayaṉṯara kanyinmalpa.” ");
INSERT INTO piu2006_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Ngarrirraya mungawinki pakara anu kapi Yiilimangka. Kapi tuwalpala ngarringu watiya tjuṯa ngarala waṉingi. Ngurra palula ngunytjiya nyinangi. ");
INSERT INTO piu2006_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","31","Kapi Yiilimanyaya wantirra yanu kapiwiyawana. Ngurra palunya yini Tjiinanya. Manangkarra palula yaṉangu tjuṯaraya Katutjaku ngurrkurringu. Muutjanyakamu Yirananya pulanya tjana yalatji watjaṉu, “Katutjalulanyatju mirri pungamara ngurra Yitjipila, ngaakutu katiwiyangku. Nyupali nganaṉanyatju nyaaku ngaakutu ngalya katingu?, mangarriwiyakutu. Mangarriwiyalpilatju nyinarra wiyarriku. Palyalatju Yitjipila nyinamara, kukakamu mangarri ngalkula.” Mayutju Katutjalu Muutjanya yalatji watjaṉu, “Kuwarriṉa nyurrampa ngayulu mangarri katunguru wantirriyalku. Paṉangka ngarrirra waṉinyingkanyurra nyakula yurralku, tjiṉṯukarrangu tjiṉṯungka. Tjiṉṯu kutjungkanyurra yurrara ngalkuntjaku, wiya tjiṉṯu kutjupaku kanyintjaku. Puratiyi mungawinki palyanyurra tjiṉṯu kutjarraku yurrantjaku, Puratiyikukamu Tjarritiyiku. Yalatjinyurra yurrara mantjintjaku. Ngayuluṉa nyurrangarrinya watjaṉi, ngayuku wangka kuliranyurra kanyintjaku.” Wangka palunya Muutjalu tjananya kulira yaṉangu tjuṯangka tjakultjunu. Yara kutjupaṯarra tjananya yalatjingku watjaṉu, “Ngalinyatjunyurra Yirananya kuru watjara yilta Katutjanyaṯarranyurra kuru watjaṉi. Panyapalinyatjunyurra kuru watjaṉutjangka Katutjalu kuliṉu. Kulira nyurranya kuwarri mungarrtji kuka yungkuku. Palunyatjanu tjiṉṯungka nyurranya mangarri yungkuku.” Mungarrtji tjuḻpu tjuṯa Yitjurilaku ngulytju ngaṉṯitja tjuṯangku, ngurrangka ngalya yankula nyinakatingutjangka, nyangu. Palunyangka yaṉangu tjuṯangkuya watiyangka pungkula warungka kutjara ngalkuṉu. Tjiṉṯungka kapi wiita nguwanpa winki ngarringi. Ngarrirra wiyarringutjangka mangarri tjulkura paṉangka ngarrirra waṉingi, nyaḻpi tjukutjuku nguwanpa. Yaṉangu tjuṯangkuya nyakula puṯu kulira tjapiṉu, “Nyaapa ngaatja?” Muutjalu tjananya watjaṉu, “Ngaatjanya mangarri Katutjalu wantirriyantja. Kuwarrinyurra kutjara ngalkuntjaku. Tjiṉṯu kutjupaku wiyanyurra kanyintjaku.” Yaṉangu kutjupa tjuṯangkuya kulira Muutjakuṉu wangka wantingu. Mangarri palunya mungura kanyiṉu, aaḻi tjiṉṯu kutjupangka ngalkulkitjangku. Pakara ngalkukitjangku paṉṯiṉu yuṉarrinytja, katilykatjarra ngarrinyingka. Yalatjiya kanyiṉutjangka Muutjanya tjanampa ngurrkurringu, yurrunpa tjananya kanyintjawiyangku watjaṉu. Tjiṉṯu Puratiyingka mangarri palunya yurraraya tjiṉṯu kutjarraku kanyiṉingi Tjarritiyikuṯarra, Katutjalu yurrunpa watjaṉutjangka. Muutjalu tjananya watjaṉu, “Mangarri palunya yurraraya rungkara kutjala!, kuwarri ngalkukitjalu. Tjiṉṯu aaḻi ngalkukitjalu rungkaraya tjurra!, kaṉilpa nguwanpangka. Yalatjiya tjunkula kanyila!, aaḻi Tjarritiyi ngalkulkitjangku. Tjarritiyingkanyurra Katutjanya waarrkawiyalu kulira waḻkuntjaku.” Aaḻi pakara Tjarritiyingka yaṉangu kutjupa tjuṯangku puṯu ngurrira nyakulinangi mangarri palunya yurralkitjalu. Katutjalu tjananya nyakula ngurrkungku yalatji payiṉu, “Ngayuluṉa nyurranya watjaṉutjangka, nyaakunyurra kutu wantinytjawiyangku ngurriṉi? Tjarritiyingkanyurra ngurrilwiya ngurrangka nyinamara. Ngayuku wangka nyurrangarri kulira wantingu.” ");
INSERT INTO piu2006_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","7","Yitjurilaku ngulytju ngaṉṯitja tjuṯaya parra yankula ngurra kutjupakutu yanu, mayutju Katutjalu watjaṉutjangka. Piyuku paluru tjananya watjaṉutjangka nyinarraya katurringkula yanu ngurra kutjupakutu. Katutjalu kutju Muutjanya watjaṉingka, yalatjiya katurringkula kutju ngurra kutjupakutu yankupayi. Ngurra Ripatimakutuya yankula puṯu nyangu kapiku. Muutjanyaya panypurangu, “Kapiwiyangkala nyaa tjikilku? Kapilanyatju yuwa!” Muutjalu tjananya watjaṉu, “Nyaakuṉinyurra panypuranganyi? Ngayunya kutju wiya, mayutju Katutjanyanyurra panypuranganyi.” Yaṉangu tjuṯangkuya kapitjirratjalu Muutjanya yalatji panypurangu, “Nyaakulanyatju nyuntu ngaakutu nganaṉanya ngalya katingu? Palyalatju ngurra Yitjipila kutu nyinamara. Nyuntu pipirri tjuṯa nganaṉanyaṯarra yiluntankukitjangku ngalya katingu.” Muutjalu puṯu kulira Katutjanya yalatji tjapiṉu, “Yaṉangu tjuṯangkuṉiya ngayunya ngurrkungku puḻingka rungkalkitjangku kuliṉi. Puṯuṉa tjananya watjalpayi.” Mayutju Katutjalu Muutjanya watjaṉu, “Yaṉangu tjuṯaku mayutju tjirripala tjananya yaḻṯirra kutjungkara kati! Yaṉangu tjuṯangka yurrunpaya yarra! Yankula nyuntu watiyatjarralu puḻi nyarratja puwa! Yalatji nyuntu pungkunytjala kapi nyurrampa puḻinguru taara yintiku, tjikintjaku nyurra.” Katutjalu palunya watjaṉutjangka, Muutjalu puḻi pungu watiyatjarrangku. Pungkunytjala kapi puḻinguru taara paṉakutu yintingu. ");
INSERT INTO piu2006_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","16","Ngurra Ripatimangkaya Yitjurilaku ngulytju ngaṉṯitja tjuṯaya nyinanyingka, Yimalikaku waarrkana tjuṯaya tjilirratjarra ngalya yanu, pika pungkukitja. Palulanguru Muutjalu wati Tjatjuwanya watjaṉu, “Tjilirratjarra tjuṯa tjananya ngurrtjara mantjila! Tjungunyurra tjiṉṯungka yankula Yimalikaku waarrkana tjuṯa pikalu pungku. Yankula nyurrangarri pika punganyingka, puḻingkaṉa kaḻparra ngaraku. Watiya palunya marangkuṉa katukutu kanyilku.” Muutjalu piyuku watjaṉu, “Tjatjuwanyangarrinyurra pikaku yankunytjala, nganaṉatju Yirananyakamu Yaaranya puḻingka tjungulatju kaḻpaku.” Muutjalu mara katura kanyintjala, Tjatjuwalungarri palya pungkula maa wantirriyaṉu. Muutjanya mara purrkarringkula mara yunngurringu. Palulanguru Yimalikaku waarrkana tjuṯangku tjananya pungkula ngalya wantirriyaṉu. Muutjalu mara katura kanyira purrkarringutjangka, Yiranalukamu Yaaralu puḻi mantjira katirra tjunurapula, Muutjanya nyinakatinytjaku. Puḻingka nyinanyingka Yiranalukamu Yaaralu Muutjanya mara kutjarra witira katukutu kanyiṉu, tjiṉṯu maa tjarrpangutjangka. Palunyangka Tjatjuwalungarri tjananya pungkula nguḻutjingara wantirriyaṉu, Yimalikaku waarrkana tjuṯanya. Kutjupa tjuṯa tjananya mirrintanu. ");
INSERT INTO piu2006_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","13","Ngurra Ripatimanya wantirraya puḻi Tjaniyalakutuya yankula nyinangu. Puḻi paṉṯangkaya nyinarra waṉingi. Muutjanya kutju puḻi palula kaḻpangu, Katutjanyapula wangkakitja. Katutjalu Muutjanya yaḻṯirra watjaṉu, “Yaṉangu tjuṯangka tjananya yalatji tjarukatirra tjakultjurra! Nintilunyurra kuliṉi, ngayuluṉa nyurrangarrinya yaṉṯayaṉṯara katiyinkupayi. Yalatjikuṯarranyurra nintingku kuliṉi, ngayuluṉa yirriṯi Yitjipinya ngurrara tjuṯa yitjipungkula kanyilpayi. Ngayuluṉa nyurranya kuwarri watjantjala, palya kulira nyinanytjaku, wiya wantinytjaku. Ngayuku kutjunyurra tjukarurru nyinarra yilta ngayuku walytja tjuṯa nyinaku.” Muutjalu wangka palunya kulira tjarukatirra yankula tjanala tjakultjunu. Yaṉangu tjuṯangku kulira watjaṉu, “Yuwa tjukarurrulatju nyinaku, Katutjaku wangkaku.” Yaṉangu tjuṯaku wangka Muutjalu Katutjanya kaḻparra tjakultjunu. Katutjalu Muutjanya piyuku watjaṉu, “Tjarukatirra tjananya yalatji watjala!, kiliinalpiya nyinanytjaku, ngayunyaṉiya waḻkulkitja. Tjiṉṯu kutjupangkaṉa puḻi ngaakutu ngalya yankula nyinaku. Nyurrangarri tjaaṯa paltjira kiliinatjarra nyinanytjaku. Kuwarrinyurra ngayuku wangka kulintjatjanu miiṯararrangku pampuntjawiya ngarrinytjaku, puḻi ngaangka tjungurringkula ngayunya waḻkulkitja. Puḻingka kalkuṉiya maaka tjunkula wanala! Maakangka munkarra kutjuya nyina! Maakangka kalkuṉi wiya ngalya yankunytjaku, puḻingka kaḻpanytjawiya. Tjinguru yaṉangu tjuṯakamu puluka puḻi maaka palula kalkuṉi ngalya yankupayingkamarra, nyurrangarri rungkara yiluntankunytjaku, puḻitjarrangku. Yiluntankunytjangka marangkunyurra wiya pampuntjaku, wantirra yarra! Waarrkanangku turampata mirratjingaṉingka, kulira yaṉangu tjuṯa puḻi paṉṯa ngaakutu ngalya yankunytjaku.” ");
INSERT INTO piu2006_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","25","Tjiṉṯu kutjupangka yutuwari maru puḻi palula ngarangi. Maṉngirrilu rungkara tuutuuṉingi. Yaṉangu tjuṯangkuya turampata katuwana mirratjingaṉutja nguwanpa kuliṉu. Kuliraya nguḻu tiltirrmara ngarala waṉingi. Muutjalu tjananya tjuṯara katingu puḻi palulakutu Katutjanya kulintjaku. Yankulaya yaṉangu tjuṯa puḻi paṉṯangka ngarakatingu. Puḻi Tjaniyangka puyu tiṉa ngarangu mayutju Katutjanya waru tili nguwanpa tjarukatirra nyinangu. Kutuya yaṉangu tjuṯa nguḻurrirra tiltirrmara ngarangi. Turampata nguwanpa kutu rawa mirratjingaṉingi, tiṉalpi mirratjingaṉu. Palulanguru Katutjanya ngalya tjarukatirra puḻi Tjaniyangka katu ngaranyingka Muutjanya yaḻṯingu kaḻpanytjaku. Palunyatjanu Muutjanya tatira ngarangu. Mayutju Katutjalu Muutjanya yalatji watjaṉu, “Tjarukatirra tjananya yaṉangu tjuṯa tjananya yaṉpiritjurra!, kulira tjana maaka kalkuṉi wiya tatintjaku. Ngalya yankula kaḻpangutjangka ngayulu tjananya yitjipungku. Kala nyuntu tjarukatirra Yirananya yaḻṯirra ngalya kati!” Muutjalu tjarukatirra tjananya tjakultjunu Katutjalu watjaṉutjangka. ");
INSERT INTO piu2006_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","17","Katutjalu yalatji watjaṉu, “Ngayuluṉa nyurrangarrimpa mayutju tiṉa nyinanyi, Katutjanya. Paṉa Yitjipilanyurra waarrkana nyinapayi, ngayuluṉa nyurranya pakaltjingara kanara ngalya katingu. Ngayunya kutjunyurra waḻkuntjaku. Ngayunya nguwanpa kutjupa wiyalingku palyara waḻkuntjaku. Katu ngurrara nguwanpa, tjinguru paṉa ngurrara nguwanpa wiyanyurra palyara ngaratjunkunytjaku waḻkulkitjangku. Kapingka nyinapayi tjuṯa nguwanpaṯarra wiya palyara waḻkuntjaku. Palunya tjuṯa wiyanyurra pupakatirra waḻkuntjaku. Ngayulu Katutjanya kutjuṉa nyurrangarrimpa mayutju tiṉa nyinanyi. Mayutju kutjupangku wiya nyurranya kanyiṉi. “Ngayuku yunytjuwiya nyinapayi tjuṯaṉa tjananya pungkuku. Palunya tjuṯaku ngaṉṯitja tjuṯaṯarra ngayuluṉa tjananya pungkuku. Ngayuku yunytju nyinapayi tjuṯaṉa tjananya yaṉṯayaṉṯalku, tjawutjuna tjuṯa, ngayuku wangkaku tjukarurru nyinapayi tjuṯa. “Ngayunya yini ngunytji wiyanyurra wangkanytjaku. Ngayunya yini ngunytji wangkanyingkaṉa pungkuku. “Tjarritiyingka nyurrangarri waarrkawiya nyinanytjaku, ngayunya Katutjanya kutju kulintjaku. Palyanyurra tjiṉṯu kutjupa tjuṯangka waarrkarrinytjaku. Tjuṯanyurra waarrkawiya nyinanytjaku, nyurrangarrimpa pipirri tjuṯa, waarrkana tjuṯa, yanngatja tjuṯa, anta naanytja, puluka tuungkiyi tjuṯaṯarra. Tjiṉṯu tjikitjipalangkaṉa waarrkarrirra paṉa ilkariṯarra palyaṉu, palulanguru Tjarritiyingka waarrkawiyalpiṉa nyinangu. Nyinarra yunyparringuṉa tjiṉṯu palumpa. Palulanguru yaṉangu tjuṯa tjiṉṯu palula ngayunya kulira kutju waḻkuntjaku. “Paapaku, maamaku wangkakunyurra kaangkinytji nyinanytjaku. Yalatjinyurra kulira ngurra Kayinanala nyinarra kutu palula palya nyinamalpa. Kayinanalanyurra nyinarra palyangku kanyintjaku. “Yaṉangu kutjupa wiyanyurra mirri pungkunytjaku. “Wiyanyurra tjulyara kutjupaku miiṯa kanyintjaku. “Yulytja kutjupaku wiyanyurra mulyaṯangku mantjintjaku. “Wiyanyurra ngunytji tjakultjunkunytjaku. “Yaṉangu kutjupaku yulytja wiyanyurra yunytjurringkula kanyintjaku. Palumpa waaḻaku, tjinguru miiṯaku wiyanyurra yunytjurringkula nyinanytjaku. Palumpa kuka tjuṯakuṯarra puluka, tuungkiyi, tjiipi, wiyanyurra yunytjurringkula kanyintjaku.” ");
INSERT INTO piu2006_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","19","(23:10-19; 40:16-38) Kaliki palunya yulytjaṯarraya palyara ngaratjunu Muutjalungarri. Yulytja palunya tjuṯa, tiipula tjuṯa, kaṉilpa tiṉaṯarra tjukarurruya ngaratjunkula wantingu. Parriki palunyaṯarraya ngaratjunkula wanaṉu. Palunyatjanu utuwari Katutjakuṉu ngalya yankula katu ngarala kaliki tjutura wangkangu, tilitjarra yirrnyaṉangi. Palunyatjanu Muutjanya wiyalpi kaliki palula kutu tjarrpangu. Utuwari palunya katurrirra yanutjangka kutju, Yitjurilaku ngaṉṯitja tjuṯangkuya kaliki palunya yulytja walytjaṯarra ruulamapira karrpira ngurra kutjupakutu katipayi. Utuwari palunya waru tili nguwanpa ngarapayi mungangka. Yirriṯi puḻi wirulypa yurruntitja kutjarra yungkukitjangku Katutjalu Muutjanya yalatji watjaṉu, “Yaṉangu tjuṯangka tjananya yalatji tjakultjurra! Ngurra palyangkanyurra nyinarra yalatji tjukarurru nyinanytjaku. Tjurrkarrangka mangarri yukiri nyurrangarri pakaltjingara wanantjaku. Katirranyurra ngurrangka kanyintjaku rawangkunyurra ngalkukitjangku. Tjurrkarra kutjupangka piyuku nyurrangarri pakaltjingantjaku mangarri. Yiiya palunya nguwanpangkanyurra piyuku mangarri pakaltjingantjaku. Yiiya tjikitjipalangka nyurrangarri mangarri yukiri pakaltjingara kanyintjaku, ngula yiiya wiḻkingka ngalkunytjakitjangku. Yiiya nampa wiḻkingka wiyanyurra mangarri pakaltjingantjaku. Yiiya palula yukiri walytjaya pakara wanantjaku, maralpa tjuṯangkuya mantjira kanyintjaku, ngalkura. Palunyatjanu tjurrkarrangkanyurra piyuku mangarri pakaltjingantjaku.” Katutjalu Muutjanya piyuku watjaṉu, “Tuḻku maṉkurrkunyurra tjungurrinytjaku. Tjungurringkulanyurra ngayunya puḻkapungkunytjaku, yalatji. “Warringka yurrun yurrunpa kutjuṉinyurra tjungurringkula mangarri rungkara ngalkuntjaku ngayunya puḻkapungkunytjakitjangku, mangarri taḻṯuwiya. Yalatji ngalkula kuka tjawirrilyitjunyurra pungkula ngalkuntjaku. “Tjurrkarrangka kutjuṉinyurra mangarri wiita yurruntitja muṯura rungkara kutjantjaku. Kutjaṉutja palunya mangarri tjawirrilyinyurra katirra tjunkula tjungurrinytjaku, ngayunya puḻkapungkunytjakitjangku. Ngayuluṉa nyurrampa mangarri pakaltjingaṉi, ngayunyaṉinyurra puḻkapungkunytjaku. “Kuḻingka kutjuṉinyurra kiripitji, yarinytji, mangarri palunya nguwanpa kutjupa tjuṯa yurrara katirra tjunkula tjungurrinytjaku, ngayunya puḻkapungkukitjangku.” ");
INSERT INTO piu2006_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","18","(24:12—31:18) Katutjalu luwu kutjupa tjuṯa watjara Muutjanya yalatji watjaṉu, “Puḻi ngaangkaṉi kaḻparra nyawa! Palulanguruṉanta wakara puḻi wirulypa kutjarra yungku, ngayuku luwu tjuṯatjarra.” Palulanguru Muutjanyakamu Tjatjuwanya kutjarra puḻi palula kaḻpangu. Kaḻparrapula ngururrpa nyinangi. Puḻingka katu tili tiṉa tilingarangi waru tili nguwanpa. Tjiṉṯu tjikitjipalangka yutuwari puḻingka katu ngarangi. Tjiṉṯu kutjupangka Katutjalu Muutjanya kutju yaḻṯingu katukutu kaḻpanytjaku. Kaḻparra yutuwaringka tjarrparra katu nyinangi kutu, Puratiyi tjikitjipala. Palulanguru Katutjalu Muutjanya nintiṉu, tjaatji kaliki nguwanpa palyantjaku. Tjaatji palula kunaṯinpa tjiṉṯu kutjupa tjiṉṯungka Katutjaku pungkula ngarritjunkula kutjantjaku nintiṉu. Tuḻkuku mayutju tjuṯaku tjaaṯa palyantjaku nintiṉu. Tuḻkuku mayutju tjukarurru waarrkarrinytjaku nintiṉu. Yalatji nintira Katutjalu Muutjanya yungu puḻi wirulypa kutjarra, palumpa luwutjarra, yurrunpa wakara tjunutja. ");
INSERT INTO piu2006_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","40","(24:12—31:18) Katutjalu luwu kutjupa tjuṯa watjara Muutjanya yalatji watjaṉu, “Puḻi ngaangkaṉi kaḻparra nyawa! Palulanguruṉanta wakara puḻi wirulypa kutjarra yungku, ngayuku luwu tjuṯatjarra.” Palulanguru Muutjanyakamu Tjatjuwanya kutjarra puḻi palula kaḻpangu. Kaḻparrapula ngururrpa nyinangi. Puḻingka katu tili tiṉa tilingarangi waru tili nguwanpa. Tjiṉṯu tjikitjipalangka yutuwari puḻingka katu ngarangi. Tjiṉṯu kutjupangka Katutjalu Muutjanya kutju yaḻṯingu katukutu kaḻpanytjaku. Kaḻparra yutuwaringka tjarrparra katu nyinangi kutu, Puratiyi tjikitjipala. Palulanguru Katutjalu Muutjanya nintiṉu, tjaatji kaliki nguwanpa palyantjaku. Tjaatji palula kunaṯinpa tjiṉṯu kutjupa tjiṉṯungka Katutjaku pungkula ngarritjunkula kutjantjaku nintiṉu. Tuḻkuku mayutju tjuṯaku tjaaṯa palyantjaku nintiṉu. Tuḻkuku mayutju tjukarurru waarrkarrinytjaku nintiṉu. Yalatji nintira Katutjalu Muutjanya yungu puḻi wirulypa kutjarra, palumpa luwutjarra, yurrunpa wakara tjunutja. ");
INSERT INTO piu2006_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","37","(24:12—31:18) Katutjalu luwu kutjupa tjuṯa watjara Muutjanya yalatji watjaṉu, “Puḻi ngaangkaṉi kaḻparra nyawa! Palulanguruṉanta wakara puḻi wirulypa kutjarra yungku, ngayuku luwu tjuṯatjarra.” Palulanguru Muutjanyakamu Tjatjuwanya kutjarra puḻi palula kaḻpangu. Kaḻparrapula ngururrpa nyinangi. Puḻingka katu tili tiṉa tilingarangi waru tili nguwanpa. Tjiṉṯu tjikitjipalangka yutuwari puḻingka katu ngarangi. Tjiṉṯu kutjupangka Katutjalu Muutjanya kutju yaḻṯingu katukutu kaḻpanytjaku. Kaḻparra yutuwaringka tjarrparra katu nyinangi kutu, Puratiyi tjikitjipala. Palulanguru Katutjalu Muutjanya nintiṉu, tjaatji kaliki nguwanpa palyantjaku. Tjaatji palula kunaṯinpa tjiṉṯu kutjupa tjiṉṯungka Katutjaku pungkula ngarritjunkula kutjantjaku nintiṉu. Tuḻkuku mayutju tjuṯaku tjaaṯa palyantjaku nintiṉu. Tuḻkuku mayutju tjukarurru waarrkarrinytjaku nintiṉu. Yalatji nintira Katutjalu Muutjanya yungu puḻi wirulypa kutjarra, palumpa luwutjarra, yurrunpa wakara tjunutja. ");
INSERT INTO piu2006_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","21","(24:12—31:18) Katutjalu luwu kutjupa tjuṯa watjara Muutjanya yalatji watjaṉu, “Puḻi ngaangkaṉi kaḻparra nyawa! Palulanguruṉanta wakara puḻi wirulypa kutjarra yungku, ngayuku luwu tjuṯatjarra.” Palulanguru Muutjanyakamu Tjatjuwanya kutjarra puḻi palula kaḻpangu. Kaḻparrapula ngururrpa nyinangi. Puḻingka katu tili tiṉa tilingarangi waru tili nguwanpa. Tjiṉṯu tjikitjipalangka yutuwari puḻingka katu ngarangi. Tjiṉṯu kutjupangka Katutjalu Muutjanya kutju yaḻṯingu katukutu kaḻpanytjaku. Kaḻparra yutuwaringka tjarrparra katu nyinangi kutu, Puratiyi tjikitjipala. Palulanguru Katutjalu Muutjanya nintiṉu, tjaatji kaliki nguwanpa palyantjaku. Tjaatji palula kunaṯinpa tjiṉṯu kutjupa tjiṉṯungka Katutjaku pungkula ngarritjunkula kutjantjaku nintiṉu. Tuḻkuku mayutju tjuṯaku tjaaṯa palyantjaku nintiṉu. Tuḻkuku mayutju tjukarurru waarrkarrinytjaku nintiṉu. Yalatji nintira Katutjalu Muutjanya yungu puḻi wirulypa kutjarra, palumpa luwutjarra, yurrunpa wakara tjunutja. ");
INSERT INTO piu2006_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","43","(24:12—31:18) Katutjalu luwu kutjupa tjuṯa watjara Muutjanya yalatji watjaṉu, “Puḻi ngaangkaṉi kaḻparra nyawa! Palulanguruṉanta wakara puḻi wirulypa kutjarra yungku, ngayuku luwu tjuṯatjarra.” Palulanguru Muutjanyakamu Tjatjuwanya kutjarra puḻi palula kaḻpangu. Kaḻparrapula ngururrpa nyinangi. Puḻingka katu tili tiṉa tilingarangi waru tili nguwanpa. Tjiṉṯu tjikitjipalangka yutuwari puḻingka katu ngarangi. Tjiṉṯu kutjupangka Katutjalu Muutjanya kutju yaḻṯingu katukutu kaḻpanytjaku. Kaḻparra yutuwaringka tjarrparra katu nyinangi kutu, Puratiyi tjikitjipala. Palulanguru Katutjalu Muutjanya nintiṉu, tjaatji kaliki nguwanpa palyantjaku. Tjaatji palula kunaṯinpa tjiṉṯu kutjupa tjiṉṯungka Katutjaku pungkula ngarritjunkula kutjantjaku nintiṉu. Tuḻkuku mayutju tjuṯaku tjaaṯa palyantjaku nintiṉu. Tuḻkuku mayutju tjukarurru waarrkarrinytjaku nintiṉu. Yalatji nintira Katutjalu Muutjanya yungu puḻi wirulypa kutjarra, palumpa luwutjarra, yurrunpa wakara tjunutja. ");
INSERT INTO piu2006_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","37","Katutjalu puḻi Tjaniyangka watjaṉutjatjanungka, Muutjalu Yirananya palumpa katja tjuṯaṯarra watjaṉu, tuḻkuku mayutju tjuṯaya nyinanytjaku, Katutjaku tuḻkuya kanyira tjaatji kalikingkaya tjawirrilyi kutjara waarrkarrinytjaku. Muutjalu tjananya Yirananya palumpa katja maṉkurrpa kaliki palulakutu katirra ngaratjunu, tuḻkuku mayutju tjuṯa nyinanytjakulpiya. Watjaṉu tjananya kaṉilpa tiṉangka paltjintjaku. Palunyatjanu Muutjalu Yirananya tuḻkuku mayutjukuṉungka mantarrangka tjarrpatjunu. Tjarrpatjunkula tjira mantjira katangka yintiṉu. Palumpa katja tjuṯaṯarra tuḻkuku mayutjukuṉungka mantarrangka tjarrpatjunu. Palunyatjanuya puluka tjawirrilyi katirra kaliki aḻangka ngaratjunu. Yiranalungarri puluka kata marangku witira kanyiṉingka, kutjupangku puluka tjuuḻatjarrangku yunytju muṯuṉu. Puluka palunya ngurrka yintirra ngarringi. Kaṉilpakutu ngurrka yintingi. Kaṉilpa mantjira Muutjalu mara tjarrpatjunkula tiipula palula yayina katu ngarapayi puupalangka nyapaṉu. Palunyatjanu tiipula palula tjayiṯingka paṉangka yintira wiyaṉu. Puluka palula wiḻa yaḻara tjira mantjiṉu. Kapurarrtji kutjarra anta yalu kuntara mantjira tiipula palula warungka kutjaṉu, kampanyingka Katutjalu paṉṯira nyakula yunyparrinytjaku. Puluka winki kutjupaya maa katirra ngurra yurilpangka kutjara wiyaṉu. Yalatjiya tjawirrilyi kutjara wiyaṉu, Katutjalu tjanampa kuya waṉinytjaku, tuḻkuku mayutju tjuṯaku. Tjiipi uḻa tjawirrilyiya katirra ngaratjunu. Yiranalungarri tjiipi kata marangku witira kanyiṉingka, kutjupangku tjiipi tjuuḻatjarrangku yunytju muṯuṉu. Tjiipi palunya ngurrka yintirra ngarringi. Kaṉilpakutu ngurrka yintingi. Muutjalu ngurrka panyapanya katirra yintirra wanaṉu tiipula palula tjayiṯingka. Palunyatjanu yitjiḻinkula kuka kapingka paltjira warungka ngarritjunkula winki kutjara wiyaṉu, tiipula palula katungka, Katutjalu paṉṯira yunyparrinytjaku. Tjiipi maṉṯi kutjupaya katirra tjawirrilyi ngaratjunu. Yiranalungarri tjiipi kata marangku witira kanyiṉingka, kutjupangku tjiipi tjuuḻatjarrangku yunytju muṯuṉu. Tjiipi palunya ngurrka yintirra ngarringi. Kaṉilpakutu ngurrka yintingi. Muutjalu kaṉilpa mantjira mara tjarrparra yankula Yirananya mara mantjira mara tiṉanya nyapaṉu, ngurrkatjarrangku. Tjina tiṉa puntunyaṯarra nyapaṉu ngurrkatjarrangku, Yirananya. Pinaṯarrara ngurrkatjarrangku nyapaṉu. Yalatji paluru Yirananya waku tjayiṯi maṉkurrpa nyapaṉu. Yalatji piyuku mara tjarrparra palumpa katja maṉkurrpa nyapaṉu, waku tjayiṯi. Ngurrka kutjupa yintira wiyaṉu tiipula tjawirrilyi kutjalpayingka tjayiṯingka. Tjiipi palunya wiḻa yaḻara tjira kuntara mantjiṉu. Mangarriṯarralpi tjungura kutjaṉu Katutjaku. Kuka winki palunya tjana kapingka payilimilara mantjira ngalkuṉu, tuḻkuku mayutju tjuṯangku. Kuka palunya maṯupurra tuḻkuku mayutjungku kutju ngalkuntjaku. Yalatjiya tjawirrilyi katirra tjapanpalangara pungu, tjiṉṯu tjapanpalangka. Yalatjiya tjawirrilyi pungkula Yirananya, palumpa katja tjuṯaṯarra tuḻkuku mayutju tjuṯa nyinatjunu, Katutjalu watjaṉutjangka. ");
INSERT INTO piu2006_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","38","(24:12—31:18) Katutjalu luwu kutjupa tjuṯa watjara Muutjanya yalatji watjaṉu, “Puḻi ngaangkaṉi kaḻparra nyawa! Palulanguruṉanta wakara puḻi wirulypa kutjarra yungku, ngayuku luwu tjuṯatjarra.” Palulanguru Muutjanyakamu Tjatjuwanya kutjarra puḻi palula kaḻpangu. Kaḻparrapula ngururrpa nyinangi. Puḻingka katu tili tiṉa tilingarangi waru tili nguwanpa. Tjiṉṯu tjikitjipalangka yutuwari puḻingka katu ngarangi. Tjiṉṯu kutjupangka Katutjalu Muutjanya kutju yaḻṯingu katukutu kaḻpanytjaku. Kaḻparra yutuwaringka tjarrparra katu nyinangi kutu, Puratiyi tjikitjipala. Palulanguru Katutjalu Muutjanya nintiṉu, tjaatji kaliki nguwanpa palyantjaku. Tjaatji palula kunaṯinpa tjiṉṯu kutjupa tjiṉṯungka Katutjaku pungkula ngarritjunkula kutjantjaku nintiṉu. Tuḻkuku mayutju tjuṯaku tjaaṯa palyantjaku nintiṉu. Tuḻkuku mayutju tjukarurru waarrkarrinytjaku nintiṉu. Yalatji nintira Katutjalu Muutjanya yungu puḻi wirulypa kutjarra, palumpa luwutjarra, yurrunpa wakara tjunutja. ");
INSERT INTO piu2006_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","18","(24:12—31:18) Katutjalu luwu kutjupa tjuṯa watjara Muutjanya yalatji watjaṉu, “Puḻi ngaangkaṉi kaḻparra nyawa! Palulanguruṉanta wakara puḻi wirulypa kutjarra yungku, ngayuku luwu tjuṯatjarra.” Palulanguru Muutjanyakamu Tjatjuwanya kutjarra puḻi palula kaḻpangu. Kaḻparrapula ngururrpa nyinangi. Puḻingka katu tili tiṉa tilingarangi waru tili nguwanpa. Tjiṉṯu tjikitjipalangka yutuwari puḻingka katu ngarangi. Tjiṉṯu kutjupangka Katutjalu Muutjanya kutju yaḻṯingu katukutu kaḻpanytjaku. Kaḻparra yutuwaringka tjarrparra katu nyinangi kutu, Puratiyi tjikitjipala. Palulanguru Katutjalu Muutjanya nintiṉu, tjaatji kaliki nguwanpa palyantjaku. Tjaatji palula kunaṯinpa tjiṉṯu kutjupa tjiṉṯungka Katutjaku pungkula ngarritjunkula kutjantjaku nintiṉu. Tuḻkuku mayutju tjuṯaku tjaaṯa palyantjaku nintiṉu. Tuḻkuku mayutju tjukarurru waarrkarrinytjaku nintiṉu. Yalatji nintira Katutjalu Muutjanya yungu puḻi wirulypa kutjarra, palumpa luwutjarra, yurrunpa wakara tjunutja. ");
INSERT INTO piu2006_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","6","Muutjanya puḻi palula rawa nyinanytjala yaṉangu tjuṯangku Yirananya tjingapungu yalatji, “Wati panyapa Muutjanya yaalytjirringu? Wiya, ngurrpalatju. Puṯula kuliṉi. Palulanguru Katutjanya nguwanpalampa nyuntu palyala!, yutitjangkulanya katiyankunytjaku.” Yiranalu tjananya watjaṉu, “Kuultatjanu riinga, nikilitjikamu palyaṉutja yaṉangu tjuṯakuṉu yirriwiltjila!, ngalya katirra ngayunya yuwa!” Palulanguruya kuultatjanu palyaṉutja pinangka waralyngarapayi tjuṯa, riinga tjuṯa, nikilitji tjuṯa yirriwiltjira katirra Yirananya yungu. Yiranalu yurrara kaṉilpa nguwanpangka tjunu. Palunyatjanu kaṉilpa palunya warungka tjunu, kuulta kamparra nyurirrinytjaku, kapi nguwanpa. Puluka wiima nguwanpa pilkitjanu palyara ngaratjunu. Kuulta nyurirrinytjala mantjira puluka nguwanpa wiimangka tjutira wanaṉu. Puluka wiima palyara ngaratjunu. Yaṉangu tjuṯangku nyakula yunyparringkula yalatji watjaṉu, “Nyawaya puluka wiima! Ngaangkulanya paṉa Yitjipilanguru mantjira ngalya katingu, nganampa mayutju tiṉangku.” Puluka wiima palula yila Yiranalu tiipula puḻingka palyaṉu, kunaṯinpa pungkula kutjantjaku. Palyara tjananya watjaṉu, “Tjiṉṯungkalpila ngalkula waḻkulku mayutju Katutjanya.” Tjiṉṯu katuya kuka kunaṯinpa tjuṯanya ngalya katirra pungkula ngarritjunu kutjalkitjalu. Kuka yuṉmi ngarrinyingka yaṉangu tjuṯarringkula ngalkula tjurratja tjikira tjungu yunyparringu. Kutuya tjikira tjungu ngalkula yunytjurringu miiṯa kutjupa kutjupangka ngarrikitja. Ngarrirraya kuya palyaṉu. ");
INSERT INTO piu2006_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","10","Mayutju Katutjalu puḻi Tjaniyangka Muutjala yalatji watjaṉu, “Parrpaṯu tjarukatirra tjananya yankula nyawa! Yaṉangu panyapa tjuṯangkuya kuya palyaṉi, panya nyuntu Yitjipilanguru ngalya katinytja tjuṯangku. Panyapa ngayuluṉa tjananya watjaṉu, kuliraṉiya wantingu. Tjanaya puluka wiima kuultatjanu palyara ngaratjunutja waḻkuṉi. Yaṉangu tjuṯangkuya yalatji watjaṉi, ‘Puluka wiima palumpala kunaṯinpa pungkula ngarritjunku, kutjara waḻkulkitjangku. Puluka wiima ngaangkulanya Yitjipilanguru mantjira ngalya katingu.’” Katutjalu Muutjanya piyuku watjaṉu, “Yiltatjuya ngayuku militjitji nyinanyi, tjukarurrungku kulintjawiya. Palulanguru ngayuluṉa tjananya mirri pungkula wiyalku.” Katutjalu Muutjanya piyuku watjaṉu, “Nyuntu wiya ngayunya marrkuntjaku palunya tjuṯatjirratjangku. Ngayuluṉa tjananya ngurrkurrirra mirri pungkula wiyalku. Nyuntupa ngulytju ngaṉṯitja tjuṯanya kutju ngayulu palya yaṉṯayaṉṯara kanyilku.” ");
INSERT INTO piu2006_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","16","Muutjalu tjanampa yalatjingku marrkuṉu, “Mayutju. Nyaaku tjanampan mulyarra nyinanyi? Nyaaku tjananyan Yitjipilanguru kanara ngalya katingu? Tjuṯa tjananya mirri pungkuwiyangku wanti!, aapa kutju tjananya puwa!, Yitjipinya ngurrara tjuṯangku yalatji kulira watjalpayingka, ‘Yipuru wangkapayi tjuṯa tjananya Katutjalu Yitjipilanguru mantjira puḻiwana katingu, mirri pungkula wiyalkitjalu.’ Ngurrkurrirra mirri pungkuwiyangku kulira yaḻṯururringkula wanti! Mirri tjuṯangka tjanala nyuntu tjakultjunu Yipuramala, Yatjikala, Tjikupala, tjanampa ngaṉṯitja tjuṯa yaṉṯayaṉṯara kanyintjaku. Nyuntu tjananya ngurra yungkukitjangku tjangkuṉu, ngurra palunya kutuya kanyintjaku.” Muutjalu yalatji marrkuṉutjangka mayutju Katutjalu tjananya wantingu, tjungu mirri pungkuwiyangku. ");
INSERT INTO piu2006_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","29","Muutjalu puḻi Tjaniyangka tjarukatirra puḻi wirulypa kutjarra katiyinangi. Puḻi palunya kutjarrangka Katutjalu palumpa luwu wakara tjunu. Tjatjuwanyapula tjungurringkula ngurrakutu yankula wangkanyingka kulira Tjatjuwalu Muutjanya watjaṉu, “Tjinguruyanku pika punganyi?” Muutjalu watjaṉu, “Pikawiya, kulila!, tuḻkuya warraṉi.” Yankulapula yilarrirra nyangu, puluka wiima ngaranyingka, yaṉangu tjuṯaya yunyparringkula nyaṉpinytjala. Nyakula Muutjalu tjanampa ngurrkurringkula tjanampa puḻi wirulypa kutjarra waṉirra kilytjuntanu. Maa yankula puluka wiima kuultatjanu palyaṉutja mantjira warukutu waṉirriyaṉu. Warungka kamparra nyurirringutja mantjira tjunu taayitirrinytjaku. Puḻi kuulta palunya yuḻpura yatuṉangi pulawu nguwanpa ngarrinytjaku. Pulawu nguwanpa mantjira yungulpi tjananya kapiwinki tjikintjaku. Muutjalu Yirananya yalatji tjapiṉu, “Nyaaku tjananyan tjingapungu?, kuyaya palyantjaku?” Yiranalu watjaṉu, “Ngayuku wiya pikarrinytjaku. Nyuntu ninti tjanampan nyinanyi. Tjana kuya yirriṯinguru palyara nyinapayi. Watjaṉutjuya Katutjanya nguwanpa palyantjaku. Palulanguruṉa tjanampa riinga nikilitjikamu mantjira warukutu waṉingu. Yalatji ngayulu wantirriyantjala puluka wiima tjaalpa pakara ngarangi kuultatjanu palyaṉutja.” Palulanguru Muutjalu tjananya ngaratjunkula watjaṉu, “Mayutju Katutjaku walytja, ngaakutuya ngalyankula ngara!” Palulanguru Lipayiku walytja tjuṯangku kutju yaṉangu tjuṯa wantirra Muutjalakutu yankula tjungurringu. Palunyatjanu Muutjalu tjananya watjaṉu, “Wati tjuṯangkunyurra tjuuḻa waṯawara kutjuṯu kutjuṯu mantjira ngalya kati!” Muutjalu piyuku watjaṉu, “Mayutju Katutjalutju ngayunya watjaṉutja tjakultjunanyi. Nyurrangarri yaṉangu tjuṯawana yankula tjungurringkula walytja kutjupa tjuṯa wakara yiluntarra!, maḻanypa kaaka tjuṯaṯarra, ngurra kutju ngurrara tjuṯa.” Lipayiku walytja tjuṯangkuya wantiwiyangku tjuuḻa waṯawaratjarrangku wakara mirri pungangi. Palulanguruya wati tjawutjuna tjirripala yilungu tjiṉṯu palula. ");
INSERT INTO piu2006_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","35","Tjiṉṯu kutjupangka Muutjalu tjananya tjuṯara watjaṉu, “Kuyanyurra kuwarri palyaṉu, waḻkura Katutjanya nguwanpa. Kuwarriṉa piyuku yankula puḻi panyapangka kaḻparra Katutjanya tjapilku, piyuku nyurrangarrinya pungkuwiyangku wantinytjaku. Tjapintjala tjinguru Katutjanya nyurrangarrimpa kalyparringkula kuya nyurrampa waṉiku.” Muutjanya yarurrirra yankula puḻi Tjaniyangka kaḻparra Katutjala yalatji wangkangu, “Yaṉangu palunya tjuṯangkuya yilta kuya puntu palyaṉu. Pulukaya wiima palyara waḻkuṉu. Tjapiṉiṉanta kuya tjanampa waṉi!, nyuntupa kalypalpiya nyinanytjaku. Tjinguru nyuntu tjananya wantiku kalyparrinytjawiyangku. Tjinguru nyuntu kuliṉi yaṉangu tjuṯa pungkukitjangku. Nyuntu yalatji kulintjala ngayuku yini tjutula piipangka!, ngayulu walytja nyuntupa wiya.” Mayutju Katutjalu watjaṉu, “Kuya palyalpayi tjuṯa kutjuṉa yini tjutulku. Kutjupa tjuṯa tjananya nyuntu tjarukatirra kati!, ngurra palyakutu. Yalatji kulila! Nyaḻpitjarra kutjungku nyurranya nintira katiyanamalpa. Piyukuṉa tjananya kulilku yitjipungkukitjangku, kuya panyapa palyaṉutjangka.” Yilta Katutjalu tjananya kutjupa tjuṯa pikatjarraṉu. Palulanguruya tjuṯa pikatjarra ngarrirra waṉingi. ");
INSERT INTO piu2006_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","35","(1,2,3,4,5,27-35) Mayutju Katutjalu Muutjanya watjaṉu puḻi katu nyinanyingka, “Puḻi wirulypa kutjarra kutjupa mantjila! Tjiṉṯungka katirra kaḻparra ngayula nintira tjurra!, ngayulu piyuku wakantjaku, ngayuku luwu. Nyuntu kutjungku ngalya katirra kaḻparra tjunkunytjaku. Watjala tjananya!, tjiipi puluka waṉma kanyintjaku, tjana puḻi ngaangka paṉṯawana wiya ngalkuntjaku.” Palunyatjanu Muutjanya tjarukatirra puḻi wirulypa kutjarra yatura kilytjuntankula mantjiṉu. Tjiṉṯungka Muutjanya puḻi katu kaḻparra puḻi wirulypa kutjarra tjunu, palunya mayutju Katutjalu watjaṉutjangka. Yutuwarilu tjutuṉutjangka mayutju Katutjanya tjarukatirra tjungurringu. Muutjanya puḻi katu kutu nyinangi, Puratiyi tjikitjipala, Katutjaku luwu tiinpala palunya nyinarra wakaṉingi, puḻi wirulypa kutjarrangka. Mangarri ngalkura tjikilwiya puḻingka kutu nyinangi. Nyinarra Muutjanya puḻi kutjarratjarra tjarukatirra palumpa walytja tjuṯakutu yanu, ngurrakutu. Katutjala wangkarra Muutjanya yuṉpa kutjupa kutjuparringu. Yuṉpa palumpa rantaṉingi. Walytjangku paluru wiya nyangu yuṉpa kutjuparringutja. Yiranalukamu yaṉangu tjuṯangku tjungurrirra yuṉpa rantarinangitjangka nyakula nguḻurringu. Muutjalu tjananya yaḻṯirra yaṉangu tjuṯa watjaṉu wangka palumpa kulintjaku. Muutjalu tjananya tjakultjunu Katutjalu puḻingka wakaṉutja. Palulanguru Muutjalu tjaaṯangka karrpira yuṉpa tjutura yankupayi. Kaliki tjaatjikutu yankula Katutjala wangkakitjangku yirriwiltjilpayi. Wangkarra Katutjala wiyarringkula piyuku tjutura yankupayi. ");
INSERT INTO piu2006_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","29","(35:4-29; 36:1-7) Yirriṯi Katutjalu Muutjanya puḻi wirulypa kutjarra yurruntitja yungkukitjangku watjaṉu, tjaatji kaliki palyantjaku. Puḻi Tjaniyangka nintiṉu tjaatji palunya tjukarurru palyantjaku, tjaatjiku yulytjaṯarraya. Wangka palunya Katutjalu watjaṉutjangka Muutjalu tjananya yaṉangu tjuṯangka yalatji tjakultjunu, “Katutjalulanya yalatji watjaṉu, tjawirrilyila yungkukitja yunytjurrirra yalatji ngalya katirra yungkunytjaku, Katutjaku kaliki tjaatji palyantjaku. Yalatji nguwanpala ngalya katinytjaku yungkukitja, puḻi kuulta, puḻi tjiilpa, puḻi yayina nguwanpa kutjupa. Mantarra tjuṯala ngalya katirra yungkunytjaku yalatji, mantarra puluuwana, mantarra maru, mantarra tjiipi yinyutjanu rungkara palyaṉutja, mantarra nanikuta yinyutjanu rungkara palyaṉutja. Tjiipikuṉu pangki karrkukarrku ngalya katinytjaku, pangki kutjupa tjuṯaṯarra. Nyiṯi laampangka kampapayila mantjira ngalya katinytjaku. Watiya tjuṯa, puḻi kilaatja nguwanpaṯarrala ngalya katirra Katutjaku yungkunytjaku.” Palunyatjanuya walytjalungkuya kulira yunytjurringkula katingu, puḻi kuulta tjuṯa, puḻi tjiilpa tjuṯa, mantarra tjuṯa, pangki tjuṯa, watiya tjuṯaṯarra. Yalatji yulytja tiṉaya katirra tjunguṉu, Katutjaku tjaatji tiṉa palyantjaku. Yitjurilaku ngaṉṯitja tjuṯangkuya mungawinkikarrangu mungawinkingka kutu yulytja katirra tjunkupayi. Yulytja palunya tjuṯarringutjangka, Muutjalu tjananya marrkuṉu wiya ngalya katinytjaku. ");
INSERT INTO piu2006_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","7","(35:4-29; 36:1-7) Yirriṯi Katutjalu Muutjanya puḻi wirulypa kutjarra yurruntitja yungkukitjangku watjaṉu, tjaatji kaliki palyantjaku. Puḻi Tjaniyangka nintiṉu tjaatji palunya tjukarurru palyantjaku, tjaatjiku yulytjaṯarraya. Wangka palunya Katutjalu watjaṉutjangka Muutjalu tjananya yaṉangu tjuṯangka yalatji tjakultjunu, “Katutjalulanya yalatji watjaṉu, tjawirrilyila yungkukitja yunytjurrirra yalatji ngalya katirra yungkunytjaku, Katutjaku kaliki tjaatji palyantjaku. Yalatji nguwanpala ngalya katinytjaku yungkukitja, puḻi kuulta, puḻi tjiilpa, puḻi yayina nguwanpa kutjupa. Mantarra tjuṯala ngalya katirra yungkunytjaku yalatji, mantarra puluuwana, mantarra maru, mantarra tjiipi yinyutjanu rungkara palyaṉutja, mantarra nanikuta yinyutjanu rungkara palyaṉutja. Tjiipikuṉu pangki karrkukarrku ngalya katinytjaku, pangki kutjupa tjuṯaṯarra. Nyiṯi laampangka kampapayila mantjira ngalya katinytjaku. Watiya tjuṯa, puḻi kilaatja nguwanpaṯarrala ngalya katirra Katutjaku yungkunytjaku.” Palunyatjanuya walytjalungkuya kulira yunytjurringkula katingu, puḻi kuulta tjuṯa, puḻi tjiilpa tjuṯa, mantarra tjuṯa, pangki tjuṯa, watiya tjuṯaṯarra. Yalatji yulytja tiṉaya katirra tjunguṉu, Katutjaku tjaatji tiṉa palyantjaku. Yitjurilaku ngaṉṯitja tjuṯangkuya mungawinkikarrangu mungawinkingka kutu yulytja katirra tjunkupayi. Yulytja palunya tjuṯarringutjangka, Muutjalu tjananya marrkuṉu wiya ngalya katinytjaku. ");
INSERT INTO piu2006_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","28","Nintingku palyalpayi tjuṯa tjananya Muutjalu nuuwimilara yaḻṯingu. Waarrkaku yunytjurripayi tjuṯa tjananya watjaṉu yulytja palunya mantjira Katutjaku tjaatji palyantjaku. Nintingku palyalpayi kutjarra yini yalatji Pitjalilanya Wulipanya nyinangu. Paluru kutjarra nintingku palyalpayi kutjupa tjuṯangkuṯarraya kaliki tiṉa palunya palyaṉingi. Kaliki tiṉa payipalaya nyiiḻangka wakara tjunguṉu. Kaliki payipala kutjupaya nyiiḻangka wakara tjunguṉu. Tjunguraya wakaṉutja tjuṯangka tjayiṯiwana wakara wanaṉu. Paluru tjana alytjura palula tjuṯangka puturru nguwanpa tjarrpatjunangi. Palunyatjanuya puturru tjuṯangka riinga tjuṯa kuultatjanu palyaṉutjaya karrpira wanaṉu. Yalatji nguwanpaya kaliki tiṉa kutjarra ngururrwana karrpira tjunguṉu, riinga tjuṯangka. Palunyatjanuya kaliki nguwanpa kutjupa palyaṉu nanikuta yinyutjanu. Palunyatjanuya kaliki nguwanpa kutjupa palyaṉu tjiipi pangkitjanu. Kaliki nguwanpa kutjupalpiya palyaṉu pangki wirulypa tjuṯatjanu. Palunyatjanungkuya watiya tiimpa tjuṯa kuntara wanara tjawara tjayiṯiwana ngaratjunkula wanaṉu. Tiimpa palunya tjuṯa ngaratjunkula wanantja tjuṯangka riila tjuṯa waṯawara yatura tjungura wanaṉu, riinga tjuṯawana, kuultatjanu palyaṉutjangka. Katuwanaya katura katirra, kaliki nguwanpa palunya watiya tjuṯangka, pupatjunkula wanaṉu. Pangki wirulytjanu palyaṉutja ngaṉṯiwanangkuya katura katirra kaliki pupatjunkula wanaṉu. Palunyatjanungku wakaraya palyaṉu kaliki kutjarra kutjupa unngu waralyngaranytjaku. Kutjupaya ngururrpa waralytjunu, kutjupa tuuwa nguwanpa wakara waralytjunu. ");
INSERT INTO piu2006_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","29","(37:1-29; 38:1-20) Wati Pitjalilalu pukutju patilpayitjarra palyaṉu, kaatputa nguwanpa. Kuulta pangki nguwanpa palyara pukutju palula tjayiṯiwana nganytjatjura wanaṉu, unnguwanaṯarra. Riila kutjarra palyara kuulta pangki nguwanpa riila palula kutjarrangka nganytjatjura wanaṉu. Pukutju palula tjayiṯingka riinga kutjarra nganytjatjunu. Tjayiṯi kutjupangka riinga kutjarra kutjupa nganytjatjunu. Pukutju katikitjangku riinga puupalangka riila palunya kutjarra tjarrpatjura katipayi. Pukutju palula katu kuultatjanu palyaṉutja yilkari ngurrara nyaḻpitjarra kutjarra ngarangi. Paluru kutjarra ngaparrku ngarangi nyaḻpi pilarrirra. Wati paluru tiipula palyaṉu watiyatjanu, mayi tjawirrilyi Katutjaku ngarritjunkunytjaku. Kuulta pangki nguwanpa palyara tjayiṯiwana nganytjatjura wanaṉu. Riila kutjarraṯarra palyaṉu tjayiṯiwana tjarrpatjunkula tiipula palunya katiyankunytjaku. Tiipula palula ngarrinytjaku kaṉilpa panikinaṯarra kuultatjanu palyaṉutja. Tjangi tilitjarra maṉkurrpa kuultatjanu palyaṉu. Palyara ngaratjunu tilitjarra tjikitjipala. Watiyatjanu tiipula kutjupa palyaṉu, Katutjaku kutjara puyutjunkunytjaku. Kuulta pangki nguwanpa palyara tiipula palula tjayiṯiwana nganytjatjura wanaṉu. Riila kutjarraṯarra palyaṉu, tjayiṯiwana tjarrpatjunkula katiyankunytjaku. Palunyatjanu tiipula tiṉa watiyatjanu palyaṉu, kalikingka yila ngaranytjaku. Tiipula palulaya waru tilira kuka tjawirrilyi kutjalpayi Katutjaku. Tiipula palula yayina puupala tjayiṯi puupalangka ngarangi ngaratjunutja. Yayina kutjupa pangki nguwanpa palyara tiipula palula tjayiṯiwana nganytjatjura wanaṉu. Riila kutjarraṯarra palyaṉu tiipula palula tjayiṯingka tjarrpatjunkula katiyankunytjaku. Niitingi nguwanpa palyara tiipulangka katuwana nganytjatjunu, niitingingka katuwana waru kampanytjaku. Palunyatjanu yayina nguwanpatjanu kaṉilpa tiṉa palyaṉu, kalikingka ila ngaranytjaku, mara paltjilpayi. Kilaatja nguwanpa tjuṯa kungka tjuṯangkuya kanyiṉingi, yayinatjanu palyaṉutja. Katutjakuya yayina palunya tjuṯa katirra tjunu. Palunyatjanu yayina palunya tjuṯa warungka tjunkula kaṉilpa palunya palyaṉu. Kaṉilpa palunya kapitjarra ngarapayi, tuḻkuku mayutju tjuṯangkuya mara paltjintjaku. Kalikingka ila parriki nguwanpaya palyara ngaratjunkula wanaṉu. Parriki palunya palyalkitjangkuya watiya tjuṯa ngaratjunkula wanaṉu. Kaliki ngururrwanaya waralytjunkula wanaṉu. ");
INSERT INTO piu2006_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","20","(37:1-29; 38:1-20) Wati Pitjalilalu pukutju patilpayitjarra palyaṉu, kaatputa nguwanpa. Kuulta pangki nguwanpa palyara pukutju palula tjayiṯiwana nganytjatjura wanaṉu, unnguwanaṯarra. Riila kutjarra palyara kuulta pangki nguwanpa riila palula kutjarrangka nganytjatjura wanaṉu. Pukutju palula tjayiṯingka riinga kutjarra nganytjatjunu. Tjayiṯi kutjupangka riinga kutjarra kutjupa nganytjatjunu. Pukutju katikitjangku riinga puupalangka riila palunya kutjarra tjarrpatjura katipayi. Pukutju palula katu kuultatjanu palyaṉutja yilkari ngurrara nyaḻpitjarra kutjarra ngarangi. Paluru kutjarra ngaparrku ngarangi nyaḻpi pilarrirra. Wati paluru tiipula palyaṉu watiyatjanu, mayi tjawirrilyi Katutjaku ngarritjunkunytjaku. Kuulta pangki nguwanpa palyara tjayiṯiwana nganytjatjura wanaṉu. Riila kutjarraṯarra palyaṉu tjayiṯiwana tjarrpatjunkula tiipula palunya katiyankunytjaku. Tiipula palula ngarrinytjaku kaṉilpa panikinaṯarra kuultatjanu palyaṉutja. Tjangi tilitjarra maṉkurrpa kuultatjanu palyaṉu. Palyara ngaratjunu tilitjarra tjikitjipala. Watiyatjanu tiipula kutjupa palyaṉu, Katutjaku kutjara puyutjunkunytjaku. Kuulta pangki nguwanpa palyara tiipula palula tjayiṯiwana nganytjatjura wanaṉu. Riila kutjarraṯarra palyaṉu, tjayiṯiwana tjarrpatjunkula katiyankunytjaku. Palunyatjanu tiipula tiṉa watiyatjanu palyaṉu, kalikingka yila ngaranytjaku. Tiipula palulaya waru tilira kuka tjawirrilyi kutjalpayi Katutjaku. Tiipula palula yayina puupala tjayiṯi puupalangka ngarangi ngaratjunutja. Yayina kutjupa pangki nguwanpa palyara tiipula palula tjayiṯiwana nganytjatjura wanaṉu. Riila kutjarraṯarra palyaṉu tiipula palula tjayiṯingka tjarrpatjunkula katiyankunytjaku. Niitingi nguwanpa palyara tiipulangka katuwana nganytjatjunu, niitingingka katuwana waru kampanytjaku. Palunyatjanu yayina nguwanpatjanu kaṉilpa tiṉa palyaṉu, kalikingka ila ngaranytjaku, mara paltjilpayi. Kilaatja nguwanpa tjuṯa kungka tjuṯangkuya kanyiṉingi, yayinatjanu palyaṉutja. Katutjakuya yayina palunya tjuṯa katirra tjunu. Palunyatjanu yayina palunya tjuṯa warungka tjunkula kaṉilpa palunya palyaṉu. Kaṉilpa palunya kapitjarra ngarapayi, tuḻkuku mayutju tjuṯangkuya mara paltjintjaku. Kalikingka ila parriki nguwanpaya palyara ngaratjunkula wanaṉu. Parriki palunya palyalkitjangkuya watiya tjuṯa ngaratjunkula wanaṉu. Kaliki ngururrwanaya waralytjunkula wanaṉu. ");
INSERT INTO piu2006_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","38","(23:10-19; 40:16-38) Kaliki palunya yulytjaṯarraya palyara ngaratjunu Muutjalungarri. Yulytja palunya tjuṯa, tiipula tjuṯa, kaṉilpa tiṉaṯarra tjukarurruya ngaratjunkula wantingu. Parriki palunyaṯarraya ngaratjunkula wanaṉu. Palunyatjanu utuwari Katutjakuṉu ngalya yankula katu ngarala kaliki tjutura wangkangu, tilitjarra yirrnyaṉangi. Palunyatjanu Muutjanya wiyalpi kaliki palula kutu tjarrpangu. Utuwari palunya katurrirra yanutjangka kutju, Yitjurilaku ngaṉṯitja tjuṯangkuya kaliki palunya yulytja walytjaṯarra ruulamapira karrpira ngurra kutjupakutu katipayi. Utuwari palunya waru tili nguwanpa ngarapayi mungangka. Yirriṯi puḻi wirulypa yurruntitja kutjarra yungkukitjangku Katutjalu Muutjanya yalatji watjaṉu, “Yaṉangu tjuṯangka tjananya yalatji tjakultjurra! Ngurra palyangkanyurra nyinarra yalatji tjukarurru nyinanytjaku. Tjurrkarrangka mangarri yukiri nyurrangarri pakaltjingara wanantjaku. Katirranyurra ngurrangka kanyintjaku rawangkunyurra ngalkukitjangku. Tjurrkarra kutjupangka piyuku nyurrangarri pakaltjingantjaku mangarri. Yiiya palunya nguwanpangkanyurra piyuku mangarri pakaltjingantjaku. Yiiya tjikitjipalangka nyurrangarri mangarri yukiri pakaltjingara kanyintjaku, ngula yiiya wiḻkingka ngalkunytjakitjangku. Yiiya nampa wiḻkingka wiyanyurra mangarri pakaltjingantjaku. Yiiya palula yukiri walytjaya pakara wanantjaku, maralpa tjuṯangkuya mantjira kanyintjaku, ngalkura. Palunyatjanu tjurrkarrangkanyurra piyuku mangarri pakaltjingantjaku.” Katutjalu Muutjanya piyuku watjaṉu, “Tuḻku maṉkurrkunyurra tjungurrinytjaku. Tjungurringkulanyurra ngayunya puḻkapungkunytjaku, yalatji. “Warringka yurrun yurrunpa kutjuṉinyurra tjungurringkula mangarri rungkara ngalkuntjaku ngayunya puḻkapungkunytjakitjangku, mangarri taḻṯuwiya. Yalatji ngalkula kuka tjawirrilyitjunyurra pungkula ngalkuntjaku. “Tjurrkarrangka kutjuṉinyurra mangarri wiita yurruntitja muṯura rungkara kutjantjaku. Kutjaṉutja palunya mangarri tjawirrilyinyurra katirra tjunkula tjungurrinytjaku, ngayunya puḻkapungkunytjakitjangku. Ngayuluṉa nyurrampa mangarri pakaltjingaṉi, ngayunyaṉinyurra puḻkapungkunytjaku. “Kuḻingka kutjuṉinyurra kiripitji, yarinytji, mangarri palunya nguwanpa kutjupa tjuṯa yurrara katirra tjunkula tjungurrinytjaku, ngayunya puḻkapungkukitjangku.” ");
INSERT INTO piu2006_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","14","(1:1-14; 3:1-17; 4:1-12,27-32; 6:26) Tjaatji kaliki palulakutu yankunytjaku, mayutju Katutjalu Muutjanya aḻṯirra yalatji watjaṉu, “Yitjurilaku ngaṉṯitja tjuṯangkunyurra ngayuku tjawirrilyi katirra tjukarurrungku pungkula yitjiḻinkula kutjantjaku.” Paluru Katutjaku wangka kulira tjananya yalatji tjakultjunu, “Yaṉangungku kuya palyara puluka tjawirrilyi katinytjaku, ngayuku Katutjaku kalypa nyinakitjangku. Puluka manpaṯa kutjuṉinyurra ngalya katirra yungkunytjaku nyurrkanyurrkawiya. Katirra kaliki yalytjurangkanyurra ngaratjunkunytjaku. Ngaratjunkulanyurra marangku kata pampura mara kutjupangku kuntala yunytju!” Muutjalu tjananya Katutjaku wangka kutjupa yalatji tjakultjunu, “Katutjalu mara tjunkunytja nyakula yunyparriku, yaṉangu palumpa kuyara waṉinytjakitja. Palunyatjanungku yaṉangu paluru yunytju kuntara ngurrka yintilku kaṉilpangka. Palunyatjanu tuḻkuku mayutjungku ngurrka palunya maṯupurra mantjira Katutjaku yintira wiyalku, tiipula tjawirrilyi kutjalpayi palula tjayiṯiwana. Palunyatjanu yaṉangu paluru tjawirrilyi palunya pangkira yitjiḻira kapingkalpi paltjintjaku. Tuḻkuku mayutju tjuṯangkuya tiipula palula waru kutjara tjawirrilyi yitjiḻinkunytjatjanu tjuṯa ngarritjunkula kutjara wiyalku. Katutjalu paṉṯira yaṉangu palumpa yunypa nyinarra, kuya palumpara waṉikulpira. Pulukawiyangka palya tjiipi, tjinguru nanikuta, tjinguru paaḻkara katirra Katutjaku tjawirrilyi yungkunytjaku. “Aṉangungku Katutjanya puḻkapungkunytjakitjangku tjawirrilyi katirra yalatjingku pungkula yungkunytjaku. Puluka maṉṯi, tjinguru kungka puluka manpaṯa kutju nyurrkanyurrkawiya katinytjaku. Katirra ngaratjunkula marangku kata pampura mara kutjupangku kuntala yunytju! Katutjalu mara tjunkunytja nyakula yunyparriku, yaṉangu palumpa tjukarurru palyalkitja. Palunyatjanungku yaṉangu paluru yunytju kuntara ngurrka yintilku kaṉilpangka Palunyatjanu tuḻkuku mayutjungku ngurrka palunya maṯupurra mantjira Katutjaku yintira wiyalku, tiipula tjawirrilyi kutjalpayi palula tjayiṯiwana. Kuka palunya wiḻa yaḻara nyiṯi kapurarrtji kutjarra anta yalu mantjira tjunkunytjaku. Tuḻkuku mayutjungku kuka palunya maṉkurrpa mantjira warungka ngarritjunkula kutjara wiyalku, Katutjalu paṉṯira yunyparrinytjaku, puyutjunkunytjala. Kuka yaṉangu winki palya tuḻkuku mayutju tjuṯangku ngalkuntjaku. Pulukawiyangka palya tjiipi, tjinguru nanikuta ngalya katirra yungkunytjaku, Katutjanya puḻkapungkunytjakitjangku. Nyiṯi anta ngurrka mayutju Katutjaku maṯupurra. Yitjurilaku ngaṉṯitja tjuṯangkuya wiya nyiṯi ngalkula ngurrka tjikintjaku. “Tuḻkuku mayutju tiṉangku Katutjaku wangka kulilwiyangku kuya palyantjala, luwu yalatji ngaranyi. Tuḻkuku mayutju paluru puluka manpaṯa nyurrkanyurrkawiya katirra tjaatji kaliki yalytjurangka ngaratjunkunytjaku. Ngaratjunkula marangku kata pampura mara kutjupangku kuntala yunytju! Katutjalu mara tjunkunytja nyakula yunyparriku, tuḻkuku mayutju palumpa kuyara waṉinytjakitja. Palunyatjanungku yaṉangu paluru yunytju kuntara ngurrka yintilku kaṉilpangka. Paluru kalikingka maa tjarrparra ngurrka palunya katinytjaku kaliki waralyngarala yangatjunkupayikutu. “Palunyatjanu puluka ngurrkangka yaṉanguku mara tjarrparra marangku yintiyintira wanantjaku, kaliki tjayiṯiwana. Yalatji tjapanpalangara mara ngurrkatjarrangku yintiyintira wanantjaku. Palunyatjanungku tiipula wiimangka kutjara puyutjunkupayingka, mara tjarrpatjunkula ngurrkatjarrangku yintiyintira wanantjaku, tiipula tjayiṯiwana. Yalatji yintiyintira wanara piyuku maḻaku yankula kalikinguru pakara tiipula tjawirrilyi kutjalpayingka tjayiṯiwana yintiyintira wiyara wanantjaku. Tuḻkuku mayutju tiṉa paluru puluka palunya wiḻa aḻara nyiṯi kapurarrtji kutjarra anta yalu mantjira kutjara wiyantjaku, tiipula palula. Kuka yaṉangu winki katirra ngurrangka ila kutjara wiyantjaku, yurilpangka, tjuṉpaya katirra yintilpayingka ila. “Yaṉangu kutjupangku Katutjaku wangka kulintjawiyangku kuya palyantjala, luwu yalatji ngaranyi. Yaṉangu paluru kungka nanikuta manpaṯa kutju nyurrkanyurrkawiya, katirra ngaratjunkunytjaku tiipula tjawirrilyi kutjalpayingka ila. Ngaratjunkula marangku kata pampura mara kutjupangku kuntala yunytju! Katutjalu mara tjunkunytja nyakula yunyparriku, yaṉangu palumpa kuyara waṉinytjakitja. Palunyatjanungku yaṉangu paluru yunytju kuntara ngurrka yintilku kaṉilpangka. Tuḻkuku mayutjungkulpi ngurrka mantjira mara tjarrpatjunkula tjawirrilyi kutjalpayingka yayina puupala ngaranytjala mara ngurrkatjarrangku nyapantjaku. Yalatji nyapara yintira wanara wiyantjaku tiipula tjawirrilyi kutjalpayingka tjayiṯiwana. Yaṉangu paluru wiḻa aḻara nyiṯi kapurarrtji kutjarra an yalu mantjira tjunkunytjaku. Tuḻkuku mayutjungkulpi kuka maṉkurrpa palunya mantjira warungka kutjara wiyantjaku, tiipula palula Katutjalu paṉṯira yunyparrinytjaku. Palya kuka yaṉangu winki tuḻkuku mayutju tjuṯangkuya ngalkula wiyantjaku. Yalatji nguwanpa tuḻkuku mayutjungku palyaṉingka, Katutjalu yaṉangu palumpa kuyara waṉiku. Mangarri pulawu yuḻpu an tjiraṯarraya katipayi Katutjaku tjawirrilyi yungkukitjangku, mayi puriiti kutjaṉutjaṯarra. Tuḻkuku mayutjungku mayi pulawu tjinguru puriiti aapa mantjira, tiipula palula warungka Katutjaku kutjara wiyalpayi. Mangarri puriiti aapa kutjupa kanyilpayi tuḻkuku mayutju tjuṯangku kutju ngalkuntjaku.” ");
INSERT INTO piu2006_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","17","(1:1-9,10-14; 2:1; 3:1-17; 4:1-12,27-32; 6:26) Tjaatji kaliki palulakutu yankunytjaku, mayutju Katutjalu Muutjanya aḻṯirra yalatji watjaṉu, “Yitjurilaku ngaṉṯitja tjuṯangkunyurra ngayuku tjawirrilyi katirra tjukarurrungku pungkula yitjiḻinkula kutjantjaku.” Paluru Katutjaku wangka kulira tjananya yalatji tjakultjunu, “Yaṉangungku kuya palyara puluka tjawirrilyi katinytjaku, ngayuku Katutjaku kalypa nyinakitjangku. Puluka manpaṯa kutjuṉinyurra ngalya katirra yungkunytjaku nyurrkanyurrkawiya. Katirra kaliki yalytjurangkanyurra ngaratjunkunytjaku. Ngaratjunkulanyurra marangku kata pampura mara kutjupangku kuntala yunytju!” Muutjalu tjananya Katutjaku wangka kutjupa yalatji tjakultjunu, “Katutjalu mara tjunkunytja nyakula yunyparriku, yaṉangu palumpa kuyara waṉinytjakitja. Palunyatjanungku yaṉangu paluru yunytju kuntara ngurrka yintilku kaṉilpangka. Palunyatjanu tuḻkuku mayutjungku ngurrka palunya maṯupurra mantjira Katutjaku yintira wiyalku, tiipula tjawirrilyi kutjalpayi palula tjayiṯiwana. Palunyatjanu yaṉangu paluru tjawirrilyi palunya pangkira yitjiḻira kapingkalpi paltjintjaku. Tuḻkuku mayutju tjuṯangkuya tiipula palula waru kutjara tjawirrilyi yitjiḻinkunytjatjanu tjuṯa ngarritjunkula kutjara wiyalku. Katutjalu paṉṯira yaṉangu palumpa yunypa nyinarra, kuya palumpara waṉikulpira. Pulukawiyangka palya tjiipi, tjinguru nanikuta, tjinguru paaḻkara katirra Katutjaku tjawirrilyi yungkunytjaku. “Aṉangungku Katutjanya puḻkapungkunytjakitjangku tjawirrilyi katirra yalatjingku pungkula yungkunytjaku. Puluka maṉṯi, tjinguru kungka puluka manpaṯa kutju nyurrkanyurrkawiya katinytjaku. Katirra ngaratjunkula marangku kata pampura mara kutjupangku kuntala yunytju! Katutjalu mara tjunkunytja nyakula yunyparriku, yaṉangu palumpa tjukarurru palyalkitja. Palunyatjanungku yaṉangu paluru yunytju kuntara ngurrka yintilku kaṉilpangka Palunyatjanu tuḻkuku mayutjungku ngurrka palunya maṯupurra mantjira Katutjaku yintira wiyalku, tiipula tjawirrilyi kutjalpayi palula tjayiṯiwana. Kuka palunya wiḻa yaḻara nyiṯi kapurarrtji kutjarra anta yalu mantjira tjunkunytjaku. Tuḻkuku mayutjungku kuka palunya maṉkurrpa mantjira warungka ngarritjunkula kutjara wiyalku, Katutjalu paṉṯira yunyparrinytjaku, puyutjunkunytjala. Kuka yaṉangu winki palya tuḻkuku mayutju tjuṯangku ngalkuntjaku. Pulukawiyangka palya tjiipi, tjinguru nanikuta ngalya katirra yungkunytjaku, Katutjanya puḻkapungkunytjakitjangku. Nyiṯi anta ngurrka mayutju Katutjaku maṯupurra. Yitjurilaku ngaṉṯitja tjuṯangkuya wiya nyiṯi ngalkula ngurrka tjikintjaku. “Tuḻkuku mayutju tiṉangku Katutjaku wangka kulilwiyangku kuya palyantjala, luwu yalatji ngaranyi. Tuḻkuku mayutju paluru puluka manpaṯa nyurrkanyurrkawiya katirra tjaatji kaliki yalytjurangka ngaratjunkunytjaku. Ngaratjunkula marangku kata pampura mara kutjupangku kuntala yunytju! Katutjalu mara tjunkunytja nyakula yunyparriku, tuḻkuku mayutju palumpa kuyara waṉinytjakitja. Palunyatjanungku yaṉangu paluru yunytju kuntara ngurrka yintilku kaṉilpangka. Paluru kalikingka maa tjarrparra ngurrka palunya katinytjaku kaliki waralyngarala yangatjunkupayikutu. “Palunyatjanu puluka ngurrkangka yaṉanguku mara tjarrparra marangku yintiyintira wanantjaku, kaliki tjayiṯiwana. Yalatji tjapanpalangara mara ngurrkatjarrangku yintiyintira wanantjaku. Palunyatjanungku tiipula wiimangka kutjara puyutjunkupayingka, mara tjarrpatjunkula ngurrkatjarrangku yintiyintira wanantjaku, tiipula tjayiṯiwana. Yalatji yintiyintira wanara piyuku maḻaku yankula kalikinguru pakara tiipula tjawirrilyi kutjalpayingka tjayiṯiwana yintiyintira wiyara wanantjaku. Tuḻkuku mayutju tiṉa paluru puluka palunya wiḻa aḻara nyiṯi kapurarrtji kutjarra anta yalu mantjira kutjara wiyantjaku, tiipula palula. Kuka yaṉangu winki katirra ngurrangka ila kutjara wiyantjaku, yurilpangka, tjuṉpaya katirra yintilpayingka ila. “Yaṉangu kutjupangku Katutjaku wangka kulintjawiyangku kuya palyantjala, luwu yalatji ngaranyi. Yaṉangu paluru kungka nanikuta manpaṯa kutju nyurrkanyurrkawiya, katirra ngaratjunkunytjaku tiipula tjawirrilyi kutjalpayingka ila. Ngaratjunkula marangku kata pampura mara kutjupangku kuntala yunytju! Katutjalu mara tjunkunytja nyakula yunyparriku, yaṉangu palumpa kuyara waṉinytjakitja. Palunyatjanungku yaṉangu paluru yunytju kuntara ngurrka yintilku kaṉilpangka. Tuḻkuku mayutjungkulpi ngurrka mantjira mara tjarrpatjunkula tjawirrilyi kutjalpayingka yayina puupala ngaranytjala mara ngurrkatjarrangku nyapantjaku. Yalatji nyapara yintira wanara wiyantjaku tiipula tjawirrilyi kutjalpayingka tjayiṯiwana. Yaṉangu paluru wiḻa aḻara nyiṯi kapurarrtji kutjarra an yalu mantjira tjunkunytjaku. Tuḻkuku mayutjungkulpi kuka maṉkurrpa palunya mantjira warungka kutjara wiyantjaku, tiipula palula Katutjalu paṉṯira yunyparrinytjaku. Palya kuka yaṉangu winki tuḻkuku mayutju tjuṯangkuya ngalkula wiyantjaku. Yalatji nguwanpa tuḻkuku mayutjungku palyaṉingka, Katutjalu yaṉangu palumpa kuyara waṉiku. Mangarri pulawu yuḻpu an tjiraṯarraya katipayi Katutjaku tjawirrilyi yungkukitjangku, mayi puriiti kutjaṉutjaṯarra. Tuḻkuku mayutjungku mayi pulawu tjinguru puriiti aapa mantjira, tiipula palula warungka Katutjaku kutjara wiyalpayi. Mangarri puriiti aapa kutjupa kanyilpayi tuḻkuku mayutju tjuṯangku kutju ngalkuntjaku.” ");
INSERT INTO piu2006_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","32","(1:1-9,10-14; 2:1; 3:1-17; 4:1-12,27-32; 6:26) Tjaatji kaliki palulakutu yankunytjaku, mayutju Katutjalu Muutjanya aḻṯirra yalatji watjaṉu, “Yitjurilaku ngaṉṯitja tjuṯangkunyurra ngayuku tjawirrilyi katirra tjukarurrungku pungkula yitjiḻinkula kutjantjaku.” Paluru Katutjaku wangka kulira tjananya yalatji tjakultjunu, “Yaṉangungku kuya palyara puluka tjawirrilyi katinytjaku, ngayuku Katutjaku kalypa nyinakitjangku. Puluka manpaṯa kutjuṉinyurra ngalya katirra yungkunytjaku nyurrkanyurrkawiya. Katirra kaliki yalytjurangkanyurra ngaratjunkunytjaku. Ngaratjunkulanyurra marangku kata pampura mara kutjupangku kuntala yunytju!” Muutjalu tjananya Katutjaku wangka kutjupa yalatji tjakultjunu, “Katutjalu mara tjunkunytja nyakula yunyparriku, yaṉangu palumpa kuyara waṉinytjakitja. Palunyatjanungku yaṉangu paluru yunytju kuntara ngurrka yintilku kaṉilpangka. Palunyatjanu tuḻkuku mayutjungku ngurrka palunya maṯupurra mantjira Katutjaku yintira wiyalku, tiipula tjawirrilyi kutjalpayi palula tjayiṯiwana. Palunyatjanu yaṉangu paluru tjawirrilyi palunya pangkira yitjiḻira kapingkalpi paltjintjaku. Tuḻkuku mayutju tjuṯangkuya tiipula palula waru kutjara tjawirrilyi yitjiḻinkunytjatjanu tjuṯa ngarritjunkula kutjara wiyalku. Katutjalu paṉṯira yaṉangu palumpa yunypa nyinarra, kuya palumpara waṉikulpira. Pulukawiyangka palya tjiipi, tjinguru nanikuta, tjinguru paaḻkara katirra Katutjaku tjawirrilyi yungkunytjaku. “Aṉangungku Katutjanya puḻkapungkunytjakitjangku tjawirrilyi katirra yalatjingku pungkula yungkunytjaku. Puluka maṉṯi, tjinguru kungka puluka manpaṯa kutju nyurrkanyurrkawiya katinytjaku. Katirra ngaratjunkula marangku kata pampura mara kutjupangku kuntala yunytju! Katutjalu mara tjunkunytja nyakula yunyparriku, yaṉangu palumpa tjukarurru palyalkitja. Palunyatjanungku yaṉangu paluru yunytju kuntara ngurrka yintilku kaṉilpangka Palunyatjanu tuḻkuku mayutjungku ngurrka palunya maṯupurra mantjira Katutjaku yintira wiyalku, tiipula tjawirrilyi kutjalpayi palula tjayiṯiwana. Kuka palunya wiḻa yaḻara nyiṯi kapurarrtji kutjarra anta yalu mantjira tjunkunytjaku. Tuḻkuku mayutjungku kuka palunya maṉkurrpa mantjira warungka ngarritjunkula kutjara wiyalku, Katutjalu paṉṯira yunyparrinytjaku, puyutjunkunytjala. Kuka yaṉangu winki palya tuḻkuku mayutju tjuṯangku ngalkuntjaku. Pulukawiyangka palya tjiipi, tjinguru nanikuta ngalya katirra yungkunytjaku, Katutjanya puḻkapungkunytjakitjangku. Nyiṯi anta ngurrka mayutju Katutjaku maṯupurra. Yitjurilaku ngaṉṯitja tjuṯangkuya wiya nyiṯi ngalkula ngurrka tjikintjaku. “Tuḻkuku mayutju tiṉangku Katutjaku wangka kulilwiyangku kuya palyantjala, luwu yalatji ngaranyi. Tuḻkuku mayutju paluru puluka manpaṯa nyurrkanyurrkawiya katirra tjaatji kaliki yalytjurangka ngaratjunkunytjaku. Ngaratjunkula marangku kata pampura mara kutjupangku kuntala yunytju! Katutjalu mara tjunkunytja nyakula yunyparriku, tuḻkuku mayutju palumpa kuyara waṉinytjakitja. Palunyatjanungku yaṉangu paluru yunytju kuntara ngurrka yintilku kaṉilpangka. Paluru kalikingka maa tjarrparra ngurrka palunya katinytjaku kaliki waralyngarala yangatjunkupayikutu. “Palunyatjanu puluka ngurrkangka yaṉanguku mara tjarrparra marangku yintiyintira wanantjaku, kaliki tjayiṯiwana. Yalatji tjapanpalangara mara ngurrkatjarrangku yintiyintira wanantjaku. Palunyatjanungku tiipula wiimangka kutjara puyutjunkupayingka, mara tjarrpatjunkula ngurrkatjarrangku yintiyintira wanantjaku, tiipula tjayiṯiwana. Yalatji yintiyintira wanara piyuku maḻaku yankula kalikinguru pakara tiipula tjawirrilyi kutjalpayingka tjayiṯiwana yintiyintira wiyara wanantjaku. Tuḻkuku mayutju tiṉa paluru puluka palunya wiḻa aḻara nyiṯi kapurarrtji kutjarra anta yalu mantjira kutjara wiyantjaku, tiipula palula. Kuka yaṉangu winki katirra ngurrangka ila kutjara wiyantjaku, yurilpangka, tjuṉpaya katirra yintilpayingka ila. “Yaṉangu kutjupangku Katutjaku wangka kulintjawiyangku kuya palyantjala, luwu yalatji ngaranyi. Yaṉangu paluru kungka nanikuta manpaṯa kutju nyurrkanyurrkawiya, katirra ngaratjunkunytjaku tiipula tjawirrilyi kutjalpayingka ila. Ngaratjunkula marangku kata pampura mara kutjupangku kuntala yunytju! Katutjalu mara tjunkunytja nyakula yunyparriku, yaṉangu palumpa kuyara waṉinytjakitja. Palunyatjanungku yaṉangu paluru yunytju kuntara ngurrka yintilku kaṉilpangka. Tuḻkuku mayutjungkulpi ngurrka mantjira mara tjarrpatjunkula tjawirrilyi kutjalpayingka yayina puupala ngaranytjala mara ngurrkatjarrangku nyapantjaku. Yalatji nyapara yintira wanara wiyantjaku tiipula tjawirrilyi kutjalpayingka tjayiṯiwana. Yaṉangu paluru wiḻa aḻara nyiṯi kapurarrtji kutjarra an yalu mantjira tjunkunytjaku. Tuḻkuku mayutjungkulpi kuka maṉkurrpa palunya mantjira warungka kutjara wiyantjaku, tiipula palula Katutjalu paṉṯira yunyparrinytjaku. Palya kuka yaṉangu winki tuḻkuku mayutju tjuṯangkuya ngalkula wiyantjaku. Yalatji nguwanpa tuḻkuku mayutjungku palyaṉingka, Katutjalu yaṉangu palumpa kuyara waṉiku. Mangarri pulawu yuḻpu an tjiraṯarraya katipayi Katutjaku tjawirrilyi yungkukitjangku, mayi puriiti kutjaṉutjaṯarra. Tuḻkuku mayutjungku mayi pulawu tjinguru puriiti aapa mantjira, tiipula palula warungka Katutjaku kutjara wiyalpayi. Mangarri puriiti aapa kutjupa kanyilpayi tuḻkuku mayutju tjuṯangku kutju ngalkuntjaku.” ");
INSERT INTO piu2006_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","19","Mayutju Katutjalu Muutjanya watjaṉu, “Nyuntupa kuṯa Yirananya, tuḻkuku mayutju tiṉanya yalatji watjala!, ‘Yirana, kulilaṉi! Tjurrkarrangka kutju kaliki palula maa tjarrparra maa yankula kaliki waralyngarala yangatjunkupayingka wayintara maa tjarrpanytjaku, ngayuku ngurra yunngukutu. Wiya nyuntu tjuṯangara tjarrpanytjaku, kutjungara kutju tjarrparra ngaranytjaku. Ngayuku ngurra palunya ngaranyi, pukutju palula katu ngayulu nyinanyi. Tjurrkarrangka kutju nyuntu palya tjarrpaku, kuḻi tayimi nyuntu tjarrparra mirrirritjipingkamarra. Tjawirrilyi kutjarra puluka an tjiipi ngalya katirra yunytju muṯuntjatjanu kutju nyuntu tjarrpanytjaku.’” Katutjalu yalatji piyuku watjaṉu, “Yirananya, tuḻkuku mayutju tiṉanya, kutju ngayuku ngurra yunngukutu tjarrpanytjaku, ngayuluṉa tjanampa yaṉangu tjuṯaku kuya waṉinytjaku, yalatji yuwankarraku, Yiranaku, palumpa walytja tjuṯakuṯarra, yaṉangu uwankarraku, Yitjurilaku ngaṉṯitja tjuṯaku. Ngurra palula tjarrpakitja paluru walytjangkungku paltjira tuḻkuku mayutju tiṉakuṉu mantarrangka tjarrpanytjaku. Tjarrparra puluka mantjira katirra ngaratjunkunytjaku yunytju muṯulkitjangku. Puluka palunya yunytju muṯura ngurrka yintintjala, ngayuluṉa tjanampa Yiranaku, palumpa walytja tjuṯakuṯarra kuya waṉiku. “Puluka palunya yunytju muṯura Yiranalu ngurrka kaṉilpangka yintintjaku. Yankula paluru kaṉilpa kutjupa mantjintjaku, waru yaḻṯatjarra. Tjira nguwanpaṯarra warungka puyutjunkupayi, paluru mantjintjaku. Palunyatjanu kaṉilpa ngurrkatjarra, kutjupa yaḻṯatjarra, tjiratjarraṯarra kaliki palula tjarrparra maa yankula kaliki waralyngarala yangatjunkupayingka wayinta Yirananya tjarrpanytjaku. Tjarrparra tjira nguwanpa palunya paluru yaḻṯangka yintira puyutjunkunytjaku, puyu pakara pukutju palunya tjutuntjaku, Yirana paluruṉi nyakutjipingkamarra ngayuluṉa pukutju palula katu ngaranytjala, paluruṉi nyakula mirri punkara ngarripayingka. Kaṉil palunya ngurrkatjarrangka mara tjarrpatjunkula ngurrkatjarrangku yintiyintira wanantjaku, pukutju palulawana. Yalatji paluru mara tjarrpatjunkula tjapanpalangara yintiyintira wanantjaku. “Palunyatjanu Yitjurilaku ngaṉṯitja tjuṯangkuya nanikuta kutjarra ngalya katirra tjawirrilyi kutjalpayingka ngaratjunkunytjaku. Yiranalu kaliki yunngunguru pakara mani tjiilpangka yinkarra nanikuta kutju ngurrtjara mantjintjaku, yunytju muṯuntjakitjangku. Yunytju muṯura ngurrka kaṉilpangka yintintjaku. Ngurrka katirra Yiranalu kalikingka maḻaku tjarrparra, waralyngarala yangatjunkupayingka wayinta katinytjaku. Ngurrka palunya katirra yintira wanantjaku, pukutju palulawana. Yiranalu yalatji palyaṉingka kaliki palunya palyalpi nyurrangarrimpa ngaraku, yuḻpaṯawiya. Kuya palyaranyurra kaliki palunya yuḻpaṯankupayi, mungutja nguwanpa ngaraku. “Palunyatjanu Yiranalu pakara nanikuta palunya kana ngaranytja katirra puliinangka walatjunkula wantirriyantjaku, ngurrangka waṉma. Nanikuta palunya yaṉangu tjuṯaku kuyatjarra yankula kutu kawaṉkatiku. Nanikuta paluru tjanampa kuya katinytjala, kuyawiyalpiya yaṉangu tjuṯa nyinaku. Yalatjinyurra tjukarurru palyaṉingka ngayulu nyurrangarrimpa kuya waṉiku.” ");
INSERT INTO piu2006_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","24","Mayutju Katutjalu Muutjanya yalatji watjaṉu, “Yaṉangu tjuṯaku mayutju tjuṯa yaḻṯirra tjananya tjungula! Tjungura tjananya ngurrtjara mantjila!, mayutju tuwalpala. Mantjira tjananya iyala!, paṉa Kayinanalawana parra nyakuyinkunytjaku, parra nyakuyinkula ngalya yankula nyuntula tjakultjunkunytjaku. Paṉa palulawana nyuntupa waarrkana tjuṯangku parra nyakuyinku. Ngurra palunya ngayulu nyurrangarrinya yungku rawa kutu nyinanytjaku.” Wangka panyapa kulira Muutjalu tjananya ngurrtjara mantjira yalinytjarra iyaṉu parra nyakuyinkunytjaku, nyakuyinkula ngalya yankula tjakultjunkunytjaku. Muutjalu kuliṉu, “Tjana ngalya yankula ngayunya tjakultjunanyingka, tjilirratjarra tjuṯa ngayuluṉa tjananya katiku ngurra palulawana tjananya mirri pungkula nguḻutjingara iyantjaku. Ngurra palulalpi nganaṉa nyinaku.” Paluru tjana ngurra Yipurunalawana yankula tjananya yaṉangu waṯawara tjuṯa nyangu, Yanakaku ngaṉṯitja tjuṯa. Puliina yini Yitjikulawanaya yankula nyangu, mangarri palya ngarala waṉinytja, kiripitji, witjirrki, mangarri kutjupa tjuṯaṯarra. Mangarri kiripitji kaḻka palunya tiṉa puntu kuntara, riilangka karrpira waralytjunu, wati kutjarrangku katiyankunytjaku. Purayitiyi tjikitjipala paluru tjana parra nyakula ngalya yanu Muutjala tjakultjunkukitja. Mangarri puntuya ngalya katingu, kiripitji kaḻka palunya, witjirrki nguwanpa kaḻka, mangarri kutjupa tjuṯaṯarra. ");
INSERT INTO piu2006_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","33","Ngurra Kititjangka Muutjanyangarriya nyinanyingka tuwalpala paluru tjana ngurra palulawana nyakuyinkulaya ngalya yanu. Ngalya yankulaya Muutjala alatji tjakultjunu, “Ngurra palyalatju parra nyakuyinangi. Kapi tjuṯa ngarrirra waṉinyi. Yukiri, watiya, mangarri palya tjuṯatjarra ngarala waṉinyi. Mangarri ngaatjanya ngurra palulalatju mantjira ngalya katingu, nyurrangarrinya nintintjakitjangku, nyuntu yurrunpa alatji watjaṉutjangka. Ngurra palulaya aṉangu manpaṯa tjuṯa nyinarra waṉinyi. Waaḻa tjuṯa ngarala waṉinyi parriki palyara ngururrtjunutjatjarra. Parriki palula kiiṯa kutju yaḻalpayitjarra ngaranyi. Tjinguru nganaṉa tjilirratjarra tjuṯa yankula tjananya puṯu mirri pungkula nguḻutjingara wantirriyalku. Manpaṯa kutjupa tjuṯaṯarra nganaṉatju nyakula nguḻurringu, waṯawara palunya tjuṯaku walytja tjuṯa. Yamalikaku ngaṉṯitja tjuṯaya ila nyinarra waṉinyi yalinytjarra, kanya Yiitjaku ngaṉṯitja tjuṯaya, Tjipuyutjaku ngaṉṯitja tjuṯaṯarraya wirriḻi puḻiwana nyinarra waṉinyi, Yamurataku ngaṉṯitja tjuṯaṯarra. Yamalakaku ngaṉṯitja tjuṯaku ngurrangka wilurarra Kayinananya ngurrara tjuṯa nyinanyi, yuru tiṉangka yilawana, karru Tjuutanawanaṯarraya nyinarra waṉinyi.” Mayutju kutjungku Kiilipalu paṉa Kayinanalawana nyakuyinkula tjananya watjara marrkuṉu, “Kuwarri nganaṉa tjilirratjarra tjuṯa yankula pungkula wantirriyantjaku, paṉa palula nyinanytjakitjangku. Nganaṉa palya tjananya pikangku pungkula nguḻutjingara iyalku.” Mayutju kutjupa tjuṯangkuya paṉa Kayinanalawana nyakuyinkula alatji watjara marrkuṉu, “Nganaṉa wiya yankula tjananya pungkunytjaku, tjanaya nganaṉanya pungkula wiyaltjipingka, manpaṯa tjuṯangku.” Mayutju paluru tjana miitingingka wangkarra yaṉangu kutjupa tjuṯawana ngunytji tjakultjunangi, nguḻutjingantjakitjangku. Yalatji tjananya parra ngunytjinytjunangi, “Paṉa nyarratja yalinytjarra kuya. Palunya ngurrara tjuṯangkuya mangarri puṯu tjawara pakaltjingalpayi. Palunyatjanuya mangarriku puṯulpiya kulilpayi. Ngurra nyarra palunya ngurrara tjuṯa waṯawara nyinanyi, manpaṯa tjuṯa. Tjana nganaṉanya nyakula tjinguru yalatji kulilku, ‘Nyarra tjuṯaya pikaṯiwiya, nyurrkanyurrka tjuṯaya yaṉangu.’” ");
INSERT INTO piu2006_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","25","Tjakulpa wiyawana iltakutjura kulira yaṉangu tjuṯaya nguḻurrirra mungangka yularra tjiṉṯurringu. Muutjanya Yirananyaṯarra paluru tjana palunya kutjarra yalatji payira watjaṉu, “Paṉa Yitjipilakutula maḻaku yankunytjaku. Kapi wiyawanalanyatjun ngalya katingu, mirrirringamaralatju, ngururrpa. Palyalatju paṉa Yitjipila nyinamara, pungkulalanyatju tjana wiipatjarrangku mirrintanamara. Nganaṉa wiya yankula tjananya pikangku pungku. Tjinguru Katutjalu kuliṉi Kayinananya ngurrara tjuṯangkulanya mirri pungkunytjaku. Yalinytjarra ngurrara tjuṯangkulpi nganampa kungka tjuṯa, pipirri tjuṯaṯarra witira katirra kanyilku. Wiya, paṉa Yitjipilakutu nganaṉa maḻaku piyuku yankunytjaku.” Yaṉangu tjuṯangkuya watjara waṉingu, “Mayutju kutjupa nganaṉa ngurrtjara nyinatjunkunytjaku, paṉa Yitjipilakutulanya maḻaku katinytjaku.” Palunyatjanu paluru kutjarrangku Tjatjuwalu anta Kiilipalu yaṉangu tjuṯa marrkuṉu, “Paṉa palulawanalitju yankula nyakuyinkula tjakultjunanyilpi. Paṉa palatja ilta palya. Watiya, yukiri mangarri palyatjarra ngarala waṉinyi. Katutjalulanya yunyparringkula palya katirra nyinatjunku ngurra palula. Wiya palunya ngurrara tjuṯakula nguḻurrinytjaku. Palyala tjananya tjilirratjarra tjuṯangku yankula mirri pungkula wiyalku. Katutjanya wiyanyurra panypurangkunytjaku. Palurulanya purinytju kanyilku. Tjanaya wiya Katutjanya kuliṉi, tjanaya wiyawanangku ngunytjingku Katutjanya nguwanpa kutjupa tjuṯa waḻkuṉi. Katutjanya kutju kaṉṯilya puntu nyinanyilampa, palurulanya purinytju kanyilku, nganaṉa yankula pikangku tjananya mirri pungkula wiyaṉingka.” Yaṉangu tjuṯangkuya kulira wantirra puḻi tjuṯalpi mantjiraya ngarala waṉingi, rungkara yiluntankunytjakitja pulanya. Palunyatjanu tjaatji kalikingka katu paarrtji nguwanpangku yirrnyara kanyiṉingi mayutju Katutjanya ngaranyingka. Palunyatjanu Katutjalu Muutjanya yalatji watjaṉu, “Yaṉangu ngaa tjuṯaya yilta militjitji nyinanyi, ngayuku wangkaya tjukarurru kulintjawiya. Ngayulu puṯuṉa tjanampa kutjupa kutjupa palyara nintiṉingi, palunyatjanuya tjukarurru yurrunpa nyinamara. Kala, militjitji tjuṯaya pika nyuṉu punturringkula mirrirrikula wanalku. Kalalpi, Muutja nyuntu kulila!, nyuntupa katjapiṯi yuṉṯalpiṯi kutju ngayuku walytja tjuṯalpiya nyinaku, nyuntupa tjamupiṯi kapaḻipiṯiṯarra.” Muutjalu Katutjanya yalatji tjapiṉu, “Nyuntu yilta yaḻṯurunytjungku yaṉanguku kuya waṉipayi. Yirriṯi nyuntu panyapa ngayunya watjaṉu. Yaṉangu tjuṯangkuntaya yilta kuwarri panypurangkula kuya palyaṉu. Kuya palunya tjanampa waṉi!, nyuṉu puntuya nyinarra wiyarritjipingkamarra. Yiluntankunytjawiyangku tjananya yaḻṯururrirra wanti!” Katutjalu Muutjanya yalatji watjaṉu, “Nyuntu kutjuṉin tjapiṉingka kuyaṉa tjanampa waṉiku, yuwankarraya nyuṉu punturrirra nyinarra wiyarritjipingkamarra. Ngayuluṉanta tjukarurru watjaṉi, militjitji palunya tjuṯaya wiya paṉa Kayinanangka yankula nyinaku. Ngururrpaya maa yankula paluru tjana wiyarriku.” ");
INSERT INTO piu2006_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","45","Katutjalu pulanya Muutjanya anta Yirananya watjaṉu, aṉangu tjuṯangka yalatji tjakultjunkunytjaku, “Ngayulu tjukarurru nyurrangarrinya watjaṉi. Militjitji tjuṯangkuṉinyurra panypuranganyingka yiltanyurra mirrirriku. Wulkumanu tjuṯa anta tjiḻpi tjuṯanyurra paṉa Kayinanala ngururrpa maa yankula mirrirriku, paṉa palulakutu yankula nyinanytjawiya. Yangupala tjuṯa yukarra tjuṯa kutjunyurra ngaṉṯitja tjuṯaṯarra yankula paṉa palula nyinaku. Tjatjuwanya anta Kiilipanyaṯarra kana nyinarra paṉa palulalpipula nyinaku. Paṉa palunya yalinytjarra nyurrangarri nguḻurrirra wantinyingka, nyurrangarrimpa pipirri ngaṉṯitja tjuṯa kutjuya paṉa palula yankula nyinamalpa. Nyurrangarrimpa pipirri tjuṯa ngaṉṯitja tjuṯaṯarra ngurra ngaawana kapiwiyawana rawa nyinayinamalpa yiiya puutiyipala. Militjitji tjuṯanyurra yilta ngurra palula yankula ngururrpa mirrirriku.” Katutjalu watjantja palunyaya kulira yaṉangu tjuṯangku puṯu kulira yularra watjara pungangiyanku, “Yiltala Katutjanya panypurangkula kuya palyaṉu. Kalalpi, nganaṉa kuwarri yalinytjarra yankula pungkula wantirriyalku, tjilirratjarra tjuṯangku.” Muutjalu tjananya marrkuṉu, “Wiya. Pikaku yankuwiyangkuya wanti!, Katutjaku wangka kulira kilytjuntankunytjawiya. Palyaya ngaangka nyinama! Tjingurunyurra pika pungkukitja yananyingka, Katutjalu nyurranya wiya yaṉṯara yaṉṯara kanyilku.” Kulintjawiyangkuya tjilirra mantjira yalinytjarra yanu, Yamalikaku ngaṉṯitja tjuṯa pikangku pungkukitja. Palunyatjanu Yamalikaku ngaṉṯitja tjuṯangku Kayinananya ngurrara tjuṯangkuṯarra tjananya mirri pungu. Kutjupa tjuṯa tjananya Yitjurilaku ngaṉṯitja tjuṯa pungkula nguḻutjingara maḻaku wantirriyaṉu. Mayutju palunya tjuṯa, paṉa Kayinanalawana nyakuyinkula nyinapayi tjuṯa tjananya Katutjalu yitjipungkula mirrintanu. Nyuṉu punturrirra tjana nyinarra wiyarringu. Kutjarra kutjupapula palya kana nyinangi, Tjatjuwanya an Kiilipanya. ");
INSERT INTO piu2006_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","27","Mayutju maṉkurrpa Kuuralu, Tiitjalu, Yaparamaluya mayutju kutjupa tjuṯangkuṯarra Muutjaku an Yiranaku kuyarrirra panypurangu. Mayutju palunya tjuṯa tjungurringu tuu yantaṯan pipitiyi. Tjana Muutjanya an Yirananya yalatji watjara panypurangu, “Wiyalanya nyupali tjukarurru kanyilpayi. Muutja. Nyaaku nyuntu mayutju tiṉarringu nganampatju? Nganaṉatjuṯarra mayutju tjuṯa nyinanyi, Katutjaku walytja tjungula nyinanyi.” Muutjalu wangka palunya kulira waṯungarala Katutjanya tjapiṉu. Tjapira pakara tjananya yalatji watjaṉu Kuuranyangarri, “Katutjalu kuliṉi mayutju nyurrangarrimpa nyinanyi. Mungawinki palurulanya nintilku, palurulanya nintilku mayutju nyinatjunutja. Katutjalu nyinatjunutja palunya kutju tjawirrilyi kutjalpayikutu palya yankula Katutjanya waḻkulku. Mungawinki kaṉilpa yayinatjanu palyaṉutja tjuṯa mantjirala waru yaḻṯa yintira ngarala kanyila!, nyiṯi puyutjunkupayitjarrangku. Palunyatjanula nyakulpi, mayutju palunya, Katutjalu mayutju ngurrtjara nyinatjunku.” Yalatji kuliraya ngurrakutu yanu. Palunyatjanu Muutjalu wikarru wantirriyaṉu Tiitjanya an Yaparamanya yaḻṯirra ngalya katinytjaku. Wikarrutja paluru pulanya puṯu yaḻṯirra yankula Muutjala yalatji tjakultjunu, “Wiya. Paluru kutjarra nyinanyi. Paluru kutjarra, nyuntunya yalatji panypurangu, ‘Nyuntu wiyawanangkulanyatju ngurra ngaa kuyawana ngalya katingu, ngurra palyakutu katinytjawiyangku. Nyuntu wiyalinyatju mayutju nguwanpangku aḻṯinytjaku. Nyuntu mungutja nyinanyi.’” Tjakultjunkunytja kulira Muutjalu mirrpaṉarrirra Katutjanya watjaṉu, “Paluru kutjarrangku tjawirrilyi yungkukitjangku ngalya katinytjala, wiyapulampa yunyparrinytjaku! Paluru kutjarrangkupula wiyawanangku ngunytji wangkapayi.” Mungawinki pakara Kuuranyangarri kaṉilpa waru yaḻṯa kutjuṯu kutjuṯutjarra tjaatji kalikingka yankula ngarangi, tjawirrilyi kutjalpayingka waṉma nguwanpa, parrikingka yaḻa yilangka ngarangi. Muutjanya an Yirananyaṯarra tjungu ngarangi. Palunyatjanu tjananya Kuuralu yaḻṯingu, yaṉangu yuwankarra ngalya yankula tjungurrinytjaku. Palunyatjanu Katutjanya paarrtji puntutjarra ngarangi. Muutjanya an Yirananya watjaṉu, “Waṉmapula ngara!, ngaanpa yaṉangu yuwankarra ngayulu tjananya yiluntankuku kuwarri.” Muutjalu an Yiranalu kulira waṯungarala Katutjanya yalatji marrkuṉu, “Katutja, nyuntu mayutju tiṉa nyinanyi. Wati kutjungku nyuntunya kuya palyaṉu, palunya kutju nyuntu pungkunytjaku, wiya yaṉangu yuwankarra nyuntu pungkunytjaku.” Palunyatjanu tjana yaṉangu yuwankarra ngurrakutu yanu. Mayutju Katutjalu Muutjanya piyuku watjaṉu, “Yaṉangu tjuṯa tjananya watjala!, ngurra tjanampa wantirra waṉmarrinytjaku, Kuuraku walytja tjuṯaku, Tiitjaku walytja tjuṯaku, Yaparamaku walytja tjuṯaku.” Kala Muutjanyangarriya Tiitjaku an Yaparamaku ngurrakutu yanu. Yila nyinanytja tjuṯa tjananya paluru tjana watjaṉu, “Ngurra nyarra tjuṯanya wantirra waṉmarri!, Katutjalu tjungu nyurranya mirri pungkutjipingkamarra.” ");
INSERT INTO piu2006_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","35","Palunyatjanuya yaṉangu tjuṯangku palunya tjuṯaku ngurra wantirra yankula waṉma ngarala waṉingi. Tiitjanyangarriṯarra palumpa miiṯa, katjapiṯi yuṉṯalpiṯiṯarra kaliki yaḻangka ngarala waṉingi. Yaparamanya palumpa walytja tjuṯaṯarraya kaliki walytjangka yaḻangka ngarala waṉingi. Muutjalu tjananya yaṉangu tjuṯangka yalatji watjaṉu, “Yaṉangu nyarra tjuṯaya tjinguru kana kutuya nyinaku, yalatjiya kulila! ‘Katutjalu ngayunya Muutjanya nyurrangarrimpa mayutju wiyalpi nyinatjunku.’ Tjinguru Katutjalu paṉa yaḻantjala, yaṉangu paluru tjana tjuṯa ngaṯingka punkara wiyarringku, yalatjinyurra kulintjaku, ‘Yiltalampa Katutjalu mayutju tiṉa nyinatjunu, Muutjanya.’” Yalatji wangkarra wiyarringutjangka paṉa yaḻarringu. Ngaṯi yaḻarringutjangka tjana punkara mirrirringu Tiitjanyangarri, Yaparamanyangarri, Kuuranyangarri, Kuuraku wangka kulilpayi tjuṯaṯarra. Paṉa yaḻarrirra piyuku maḻaku patirringu. Tjana nguḻu punkara mirrarra waṉinytjala kulira yaṉangu kutjupa tjuṯaya nguḻurrirra tjalkaḻungu. Mirrarraya tjalkaḻungkula yaṉangu kutjupa tjuṯawana watjarinangi, “Tjalkaḻuwalaka!, paṉa yaḻarringutjangka punkara mirrirritjipingkamarra.” Panyapa tjuṯa tjananya yurrunpa tjaatji kalikikutu yankula kaṉilpa yaḻṯatjarra ngarangutjatjanuṯarra, Katutjalu tjananya warutjarrangku mirrintara wiyaṉu yantaṯa kutjarra an pipitiyipala. ");
INSERT INTO piu2006_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","12","Mayutju Katutjalu Muutjanya watjaṉu, “Yaṉangu tjuṯaya walytjararranpa tuwalpala nyinarra waṉinyi. Walytjararranpa Ruupinaku ngaṉṯitja tjuṯa nyinanyi, mayutju tiṉa tjanampa. Walytjararranpa kutjupa Tjuutaku ngaṉṯitja tjuṯaku nyinanyi mayutju tiṉa kutjupa. Yalatjiya mayutju tuwalpala nyinanyi walytjararranpa tuwalpalakuṉu. Tjana watiya katiyankupayi, kaḻi nguwanpa. Nyuntu mayutju palunya tjuṯangka tjananya watjala!, tjanaya watiya palunya ngalya katirra nyuntunya yungkunytjaku. Mayutju kutjungkunta watiya yunganyingka, mantjira nyuntu watiya palula yini wakala!, mayutju palunya. Mayutju kutjupangkunta watiya yunganyingka, nyuntu mantjira watiya palula yini wakala!, mayutju palunya. Yalatji watiya tuwalpalangka mayutju yini tuwalpala wakala! Wakara watiya palunya tjuṯa katirra tjaatji kalikingka tjarrparra pukutju palula yila paṉangka tjurra!, puḻi wirulypa kutjarratjarrangka, watiya kutju ngarrirra yukiritjarrarrinytjaku. Yukiritjarrarrinytja yininyurra nyakula nintingku kulilku, mayutju ngayuluṉa nyinatjunutja.” Palunyatjanu Muutjalu watiya tjuṯa tjanampa mantjira yini wakaṉingi, watiya kutjuṯu kutjuṯungka, Yiranakuṉu watiyangkaṯarra. Watiya walytjangka Muutjalu mantjira wakalwiyangku wantingu. Mayutju kutjupa tjuṯaku kutju tjanampa watiya tjuṯangka wakara katirra tjunu. Mungawinki Muutjalu yankula tjaatji kalikingka tjarrpangu, watiya palunya tjuṯa ngurrtjalkitja. Paluru nyangu watiya kutju yukiritjarrarrirra ngarringitja, mayi yuṉmitjarra. Nyakula yini Yirananyalpi nyangu. Watiya tuwalpala palunya mantjira katirra Muutjalu tjananya nintiṉu, yaṉangu tjuṯa tjungu ngaranytjala. Watiya mangarritjarra nyakulaya yini Yirananyatjarra mayutju lipinpala paluru watiya walytjangku walytjangkuyanku mantjira kanyira waṉingi. Mayutju Katutjalu Muutjanya yalatji watjaṉu, “Yiranaku watiya mantjira maḻaku katirra tjaatji kalikingka tjurra!, pukutju palula, kutu ngarrinytjaku. Puṯu kulilpayi tjuṯangku watiya palunya mangarritjarra nyakula kulintjaku, ngayunya panypurangkuwiyangku.” Muutjalu watiya palunya mantjira katirra pakutju palula tjunkula wantingu. ");
INSERT INTO piu2006_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","7","Mayutju Katutjalu Yirananya yalatji watjaṉu, “Ngayuku tuḻkungka nyinarranyurra tjukarurru kaliki ngaangka palyantjaku. Wiyawanangkunyurra palyaṉingka ngayulu nyurrangarrinya pungku. Nyuntu Yirana kulila!, nyuntu, nyuntupa katja tjuṯaṯarra Lipayiku ngulytju ngaṉṯitja tjuṯa nyinanyi, kutjupa tjuṯaṯarraraya palumpa ngulytju ngaṉṯitja nyinanyi Lipayiku. Nyuntu tjananya yaḻṯi!, kalikiwanaya ngalya yankula waarrkarrinytjaku. Kalikingka yila kutjuya waarrkarrinytjaku, unnguwiya, yurilta kutju. Tuḻkuku mayutju tjuṯa kutjunyurra kalikingka yunngu waarrkarrinytjaku, yulytja palunya tjuṯawana. Tjawirrilyi kutjalpayiwanaṯarra nyurrangarri tuḻkuku mayutju tjuṯa waarrkarrinytjaku, wiya tjanaya Lipayiku ngaṉṯitja kutjupa tjuṯa palulawana waarrkarrinytjaku. Tjinguru Lipayiku ngaṉṯitja kutju waṯawaṯarringkula yulytja palulawana waarrkarrinyingka mirri pungkutjipingkaṉa. Paluru tjana kapi, waru yulytja kutjupaṯarra mantjira katirra kalikingka yurilta ila tjunkula waarrkarrinytjaku. Tjinguru yaṉangu kutjupangku ilarringkula kaliki palula ngayuku yulytja tjuṯa pampuṉingka, mirriṉa pungkutjipingka.” ");
INSERT INTO piu2006_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","20","Mayutju Katutjalu Yirananya yalatji watjaṉu, “Tjawirrilyi ngayuku kuka an mangarri yaṉangu tjuṯangkuya katirra yungkunytjala palyanyurra tuḻkuku mayutju tjuṯangku kutjunyurra ngalkuntjaku, kutjupa tjuṯangkuya wiya ngalkuntjaku. Nyuntu, nyuntupa katja tjuṯangku kutjunyurra tjungungku ngalkuntjaku. “Yitjurilaku walytja ngaṉṯitja tjuṯangku mangarri tjawirrilyi kutjupa tjuṯa ngayuku katirra yungkunytjaku. Tjawirrilyi palunya palya nyurrangarrimpa walytja tjuṯangku ngalkuntjaku, katjapiṯingku, yuṉṯalpiṯingku, tjamupiṯingku kapaḻingkuṯarra. “Maṉṯi yurruntitja tjuṯa, ngayukutjuya Katutjaku nyinanyi. Maamangku an paapangku katja yurruntitja mantjira mani katirra tuḻkuku mayutjuku yungkunytjaku. Yalatjiya mani yungkunytjaku ngayuku waarrkana tjuṯaku, ngaparrtjingku, katja yurruntitja mantjira. “Puluka, tjiipi, nanikuta wiima, yurruntitja tjuṯa, ngayukutjuya yuwankarra nyinanyi. Wiya yaṉangu tjuṯangku palunya tjuṯa tjananya mantjira mani katirra yungkunytjaku tuḻkuku mayutjuku, wiya. Paluru tjana ngunytji tjananya kuka tjuṯa kanyira katirra tjawirrilyi pungkunytjaku, ngayuku Katutjaku. Mirri punganyingka wiḻa yaḻara tjira, kapurarrtji kutjarra, yaluṯarra mantjira warungka kutjara wiyantjaku, ngayuku Katutjaku yungkula. Kuka winki kutjupa palyanyurra tuḻkuku mayutju tjuṯangku ngalkuntjaku.” Katutjalu Yirananya kutu yalatji watjaṉu, “Paṉa Kayinanakutunyurra Lipayiku ngaṉṯitja tjuṯa ankula wiya paṉa walytja kanyilku, Yitjurilaku ngaṉṯitja kutjupa tjuṯangkuya paṉa walytja kanyilku. Wiyanyurra paṉa walytja kanyilku, mangarri pakaltjingantjaku. Ngayulu nyurrangarrinya watjaṉi, yilta kutjupa tjuṯangku yungkunytjala palya nyurrangarri ngalkuntjaku, tjawirrilyi palunya. Yalatjiṉa nyurrangarrinya yaṉṯayaṉṯara kanyilku.” ");
INSERT INTO piu2006_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","32","Mayutju Katutjalu Muutjanya yalatji watjaṉu, “Kuwarrilpi Lipayiku ngaṉṯitja tjuṯangku kalikingka waarrkarrirra purinytju kanyilku. Palunya tjuṯangku kutjuya kaliki ruulamapira karrpira katirra ngurra kutjupangka ngaratjunkula purinytju kanyilku. Kaliki palunya ngaranyingka Yitjurilaku ngaṉṯitja tjuṯangkuya kalikikutu katirra tjawirrilyi ngayuku yungkunytjaku. Paluru tjana mangarri mantjira wiimaṉiya tjawirrilyi yungkunytjaku ngayuku, kalikikutu katirra. Tjawirrilyi palunya tjuṯa ngayulu watjaṉutjangka, Lipayiku ngaṉṯitja tjuṯangku ngalkuntjaku. Kiripitji, yarinytji, mangarri kaḻkatjarra kutjupa mantjira wiimaṉiya tjawirrilyi yungkunytjaku ngayuku. Ngayulu watjaṉi, Lipayiku ngaṉṯitja tjuṯangkuya tjawirrilyi palunya tjuṯa ngalkuntjaku. “Paṉa Kayinanakutu yankula Lipayiku ngaṉṯitja tjuṯangku wiya paṉa walytja kanyilku mangarri pakaltjingantjaku. Mangarri tjawirrilyi palunya tjanampa nyurrangarri kutu yungkunytjaku. Tawunu maṉkurrpa kutjupa tjanampa ngaraku, palyaya ngurrangka nyinanytjaku. “Mangarri tjawirrilyinyurra katirra ngayuku yunganyingka, Lipayiku ngaṉṯitja tjuṯangkuya mantjira wiima ngayunyaṉi Katutjanya yungkunytjaku, Yitjurilaku ngaṉṯitja kutjupa tjuṯangkuya tjawirrilyi ngayuku yungkunytja nguwanpa.” ");
INSERT INTO piu2006_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","21","Yitjurilaku walytja ngaṉṯitja tjuṯa parra yankulaya ngurra kutjupawana yanu, kapiwiyawana, yini Kiititjalawana. Palulanguru Muutjaku kangkuru Miriyamanya mirrirringu. Yularraya palunya tjunu. Ngurra palula tjana kapiwiya nyinangu. Tjungurringkulaya tjana Muutjala Yiranala piyuku panypurangu, “Nyaaku nyupali nganaṉanyatju ngurra ngaakutu ngalya katingu?, tjinguru nganaṉanyatju pungkula tjunkukitjangku?, puluka tjiipi tjuṯaṯarra. Paṉa Yitjipingkalatju nyinamara, ngurra palyangka. Ngurra ngaangka kapiwiya, mangarriwiyaṯarra ngaranyi. Nyaaku nyupali nganaṉanyatju ngaakutu ngalya katingu?” Muutjanya anta Yirananya tjaatji kaliki palulakutu yankulapula mantangka waṯungarangu Katutjanya tjapilkitja. Palulanguru Katutjanya kalikingka katu paatji nguwanpa ngarangu. Paluru Muutjanya yalatji watjaṉu, “Nyuntu pukutju palula watiya palunya mantjira yankula yaṉangu tjuṯa tjunguntjaku. Tjungura tjananyapula kati puḻi nyarrakutu!, tjana ngarala nyakunytjaku. Tjana ngarala nyakunytjala nyuntu puḻingka wangka!, kapi yaḻarrinytjaku, puḻinguru. Palulanguru kapi nyurrampa puḻinguru yaḻara yintiku, piiringi nguwanpa, uwankarrangkunyurra tjikintjaku, kuka tjuṯangkuṯarra.” Watiya palunya pukutju palula mantjira Muutjalu anta Yiranalupula yaṉangu tjuṯa tjungura puḻi palulakutu katingu. Palulanguru Muutjalu tjananya yalatji kuru watjaṉu, “Yaaṯapalipa tjuṯanyurra ngarala waṉinyi. Kapilitju nyurrangarrimpa puḻi ngaangka yaḻalku.” Palulanguru Muutjalu puḻi palunya kutjarrangara yatuṉu watiyatjarrangku, wangkawiyangku. Palunyatjanu kapi tiṉa yaḻara yintingu. Yaṉangu tjuṯangkuya tjikiṉangi, anta kuka tjuṯangkuṯarra. Muutjalu puḻi watjantjawiyangku watiyatjarrangku yatuṉutjala, Katutjalu pulanya yalatji kuru watjaṉu, “Ngayulu ngangkari puntutjarrangku kapi yaḻara yungkupayi. Nyupali puḻi yatulwiyangku puḻikutu wangkamara, ngayulu nyupalinya watjaṉutja. Ngayuku wangka nyupali kulinmara. Wiya nyupali tjananya paṉa Kayinanalakutu katiku. Nyupali tjananya katirra ngururrpa maa iyalku.” Katutjaku wangka palunya paluru kutjarrangku kuliṉu. Yiitumanya ngurrara tjuṯaku ngurrawana yankukitjangku Muutjalu pulanya waarrkana kutjarra wantirriyaṉu mayutju tjanampa tjapintjaku. “Palyalatju yanku kurutjukata nyuntupa ngurrawana?” Yankulapula tjapintjala mayutju paluru wiya watjaṉu. Muutjalu tjananya piyuku iyaṉu yankula mayutju palula tjapintjaku, tjana ruutuwana kurutjukata parrpaṯu yankunytjaku. Piyuku tjananya mayutju paluru wiya watjara palumpa tjilirratjarra tjuṯa tjananya tjunguṉu. Palulanguru paluru tjana yankula Yitjurilaku walytja ngaṉṯitja tjuṯa tjananya pikangku pungkula iyaṉu. Palulanguru Muutjanyangarri taaṉarrirra yiwarra kutjupawana yanu, pungkupayi tjuṯangkamarra. ");
INSERT INTO piu2006_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","29","Muutjanyangarriya puḻi yini Yuurakutu yankula tjana nyinangu. Palulanguru mayutju Katutjalu pulanya watjaṉu, “Yirananya wiya paṉa Kayinanalakutu yankula nyinaku. Ngurra palula nyupali wiya wangka ngayukuṉu kuliṉu, ngurra Miripala. Muutja, nyuntu pulanya Yirananya anta palumpa katja yurruntitja Yalitjanya katirra pulanya puḻi Yuurangka kaḻpatjurra! Katirra pulanya puḻi palula tuḻkuku mayutjukuṉu mantarra Yiranala yirriwiltjinkula Yalitjalalpi tjarrpatjurra!, tuḻku mayutju tiṉalpi paluru nyinanytjaku. Yirananya puḻi palula katu mirrirriku.” Palulanguruya Muutjanyangarri tjungu puḻi Yuurangka katu kaḻpangu. Puḻi palula katu Yirananya mirrirringu. Palunyatjanu Muutjalu anta Yalitjalu tjarukatirra tjananya tjakultjunu yaṉangu tjuṯangka. Kuliraya rawa yulangi tjiḻpi Yirananyatjirratja. ");
INSERT INTO piu2006_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","9","Puḻi Yuurangkaya nyinarra paṉa Yiitumangka yitiwana yanuya. Yankulaya kapiku puṯu ngurrira mayi maanaku yunytjuwiyarringu. Paluru tjana yaṉangu tjuṯangku Katutjanya anta Muutjanya piyuku panypurangu, “Nyupali nyaaku nganaṉanyatju ngalya katingu ngurra ngaakutu?, mangarriwiyakutu, kapiwiyakutuṯarra. Paṉa Yitjipingkalatju palya nyinamara. Wiya nganaṉatju yunytjurrinyi mangarri maana ngaatjanya kutulingku ngalkuntjaku.” Palulanguru Katutjalu piḻkaṯi tjuṯa wantirriyaṉu, patjara tjananya uwankarra mirrintankunytjaku. Piḻkaṯi tjuṯangku yaṉangu maṉkurrpa nguwanpa tjananya patjara mirrintanu. Yaṉangu maṉkurrpa palunya mirrirringkunytjala nyakulaya kutjupa tjuṯangku Muutjanya yalatji watjaṉu, “Nganaṉatju Katutjanya anta nyuntunya wiyawanangku panypurangu. Nganaṉatju yalatji panypurangkula yilta kuya palyaṉu. Katutjanya nganampa tjapila!, piḻkaṯi tjuṯa payira wantirriyantjaku.” Palunyatjanu Muutjalu tjanampa tjapiṉu. Palulanguru Katutjalu Muutjanya watjaṉu, piḻkaṯi nguwanpa yayinatjanu palyantjaku, palulanguru watiyangka katu waralytjunkunytjaku. Katutjalu watjaṉu yalatji, “Patjantjala yaṉangungku piḻkaṯi palunya yayinatjanu palyaṉutja nyakula palyarriku.” Palulanguru Muutjalu piḻkaṯi nguwanpa palyara waralytjunu. Palunyatjanu patjaṉutja tjuṯaya nyakula yilta palyarringu, mirrirrinytjawiyalpi. ");
INSERT INTO piu2006_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","21","Palunyatjanu Yitjurilaku walytja ngaṉṯitja tjuṯangku tjananya yankula Yamuraku ngaṉṯitja tjuṯa mirri pungangi. Paluru tjana mirri pungkula tawunu tjuṯangka waaḻa tjuṯa yaṉṯayaṉṯalpayi. Palulanguru Yitjurilaku walytja ngaṉṯitja kutjupa tjuṯa yankula puliina yini Muwapala nyinangu, panya karru Tjuutanala kakarrara. Muwapanya ngurrara tjuṯaku mayutju tiṉa yini Piilakanya nyinangi. Paluru tjakulpa kuliṉu, Yitjurilaku ngaṉṯitja tjuṯangku Yamuraku ngaṉṯitja tjuṯa pungutjangka. Panyapa kulira paluru nguḻurringu. Nguḻurringkula mayutju paluru wikarru tjirripala wantirriyaṉu, wati Piilamanya yaḻṯirra ngalya katinytjaku. Wikarru paluru tjana mani tiṉa tjuṯa katingu Piilamaku yungkunytjaku. Paluru tjana yankula Piilamanya yalatji tjakultjunu mayutjukuṉu wangka, “Yaṉangu mingalingkuya ngalya yanu, ngurra Yitjipilanguru. Tjana nganaṉanya mirri pungkutjipingka, ngurraṯarra nganampa kanyilpayingkamarra, nyuntu ngalya yankula ngurra ngaanguru Katutjanyalampa tjapila!, pungkunytjaku tjananya. Kanya tjana tjuṯalingkuya nyinarra waṉinyi, nganaṉatju maṉkurrpa nguwanpala nyinanyi. Nyuntu ngalya yankula ngurra ngaanguru tjapila Katutjanya!, pungkunytjaku tjananya.” Piilamalu wangka palunya kulira Katutjanya tjapiṉu. Katutjalu palunya marrkuṉu, “Nyuntu wiya yankula ngurra palula tjapintjaku, ngayulu tjananya pungkunytjaku, Yitjurilaku ngaṉṯitja tjuṯanya.” Palulanguru Piilamalu tjananya wiya watjaṉu. Piilamaku wangka kuliraya wikarru paluru tjana piyuku yankula mayutju Piilakala tjakultjunu. Palulanguru tjananya Piilakalu mayutju tiṉa tjuṯa Piilamalakutu piyuku iyaṉu. Yankula Piilakaku wangka tjana tjakultjunu Piilamala yalatji, “Mani tiṉa, yulytja tiṉaṯarraṉanta yungku, nyuntu ngalya yankula ngurra ngaanguru Katutjanya tjapintjala, paluru tjananya Yitjurilaku ngaṉṯitja tjuṯanya mirri pungkunytjaku.” Piilamalu piyuku Katutjanya tjapiṉu. Katutjalu yalatji watjaṉu, “Piilama. Palyanu nyuntu mayutju palunya tjuṯawana yankunytjaku. Ngayuluṉanta watjantjala kutju nyuntu palulawana palyala!” Piilamanya aaḻi tuungkiyingka kaḻparra yanu mayutju palunya tjuṯawana. ");
INSERT INTO piu2006_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","41","Palunyatjanu Piilamanya maniku kulira yunytjurringkunytjala Katutjalu kulira yunytjuwiyarringura. Palulanguru yilkari ngurrara wantirriyaṉu, ruutungka yangara ngaranytjaku, tjuuḻa waṯawaratjarra. Tuungkiyi paluru kutju nyangu yilkari ngurrara palunya, yutiwiya ngaranytjala. Tjuuḻatjarrangku wakaltjipingkamarra nguḻurringkula tuungkiyi ruutungka tjayiṯiwana yanu. Palunyatjanu Piilamalu mirrpaṉarrirra tuungkiyi palunya pungangi. Palunyangka yilkari ngurrara paluru maa yankula parriki yutjungka ngarangi ruutu yangara. Parriki puḻitjanu palyaṉutja palula ngarangi. Yilkari ngurrarangku tjuuḻa waṯawaratjarrangku wakaltjipingkamarra tuungkiyi paluru parrikingka yila yankula Piilamanya tjina yutjura pikantanu. Palulanguru Piilamalu wayilarrirra tuungkiyi palunya piyuku pungangi. Palulanguru yilkari ngurrarangku maa yankula parriki kutjarrangka ngururrpa yutjulingkungka piyuku ngarangi. Yutju palulawana tuungkiyi wanaparri kutju yankupayi, tuungkiyi kutjarra kutjupa yankunytjawiya yutjuwana. Yutju palula ilkari ngurrara nyakula tuungkiyi paluru ngarakatingu. Palunyatjanu Piilamalu puntura wayilarrirra watiyatjarrangku pungangi. Katutjalu nintintjala tuungkiyi yaṉangu nguwanpa wangkangu Piilamala. Yalatji tuungkiyi paluru tjapiṉu, “Nyaangurutjunu tjirripalangara pungangi?, ngayuluṉa yaalytji palyantjala?” Piilamalu watjaṉu, “Nyuntu wiyawanangku ngayunya katingutjangka. Tjuuḻa waṯawara katiyankula wakaraṉanta mirrintanamara.” Tuungkiyi paluru Piilamanya piyuku watjaṉu, “Yirriṯi wiyaṉanta wiyawanangku katiyankupayi, ngarakatirra. Yalatji tjukarurruṉanta watjaṉi.” Palulanguru Piilamalu watjaṉu, “Yuwa, tjukarurruṉin katipayi.” Palunyatjanu Katutjalu Piilamanya kuru yaḻaṉu nguwanpa. Yilkari ngurrara paluru yuti nyangu tjuuḻa waṯawaratjarra yutjungka ngaranytjala. Nyakula Piilamanya nguḻurringkula waṯungarangu. Yilkari ngurrara paluru Piilamanya yalatji kuru watjaṉu, “Nyuntu tuungkiyi pungkuwiyangku wantimara, ngayuluṉanta yangatjunkunytjala. Nyuntu ngurra walytjangka nyinamara, ngalya yankunytjawiya. Nyuntupa tuungkiyingku ngayunya nyakula tjirripalangara tjayiṯiwanarringu, ngayuluṉanta mirri pungkutjipingka. Tjinguru ngayulakutu nyuntunya tuungkiyingku ngalya katinytjala, ngayuluṉanta mirri pungamara, tuungkiyi palunya wantirra pungkuwiyangku.” Piilamalu watjaṉu, “Yiltaṉa ngalya yankula kuya palyaṉu. Ngayulu tuungkiyingka nyinayinkula, ngayulu nyuntupa ngurrpa nyinangi. Tjinguru nyuntu watjantjala ngayuluṉa yarurriku ngurrakutu.” Yilkari ngurrarangku watjaṉu, “Wati pala tjuṯawana nyuntu tjanala yanama, kutu! Ngayuluṉanta watjantjala kutju nyuntu watjala!” Piilamanyangarriya yanu Piilakaku ngurrakutu. Piilakalu nyakula Piilamaku yunyparringu. ");
INSERT INTO piu2006_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","30","(23:1-30; 24:1-9) Piilamalu Piilakanya yalatji watjaṉu, “Katutjaluṉi watjaṉutjangka kutjuṉa watjalku.” Aaḻi pakara Piilaka paluru Piilamanya katingu puḻi Pamutjapalakutu. Puḻi palulapula kaḻparra nyangu tjananya Yitjurilaku ngaṉṯitja tjuṯa, tjuṯalingkuya puliinawana nyinarra waṉingu. Nyakula Piilamalu Piilakanya watjaṉu tiipula nguwanpa tjapanpala puḻitjanu palyantjaku, tjawirrilyiṯarra kutjantjaku. Palulanguru piyuku watjaṉu tjawirrilyi puluka maṉṯi tjapanpala anta tjiipi maṉṯi tjapanpala mantjira ngalya katinytjaku. Tiipula palula tjuṯa ngaranytjala, Piilamalu anta Piilakalu puluka kutju anta tjiipi kutju pungkula kutjaṉupula, tiipula kutjungka. Palunyatjanu tiipula kutjupakutu puluka kutjupa anta tjiipi kutjupa tiipula palula kutjara wiyaṉu, Katutjaku. Yalatjiya tiipula tjapanpalangka kunaṯinpa puluka anta tjiipi kutjara wiyaṉu. Piilamalu Piilakanya yalatji watjaṉu, “Ngaangka paṯanma!, ngayulu puḻingka kaḻparra Katutjanya tjapilku.” Paluru Katutjanya tjapira tjarukatirra tjananya Muwapanya ngurrara tjuṯaku mayutju tjuṯa tjananya watjaṉu, Piilakanyaṯarra, “Palangkuṉi Piilakalu nyurrangarrimpa mayutju tiṉangku wikarrutja tjuṯa iyaṉu, ngayunya ngalya katinytjaku. Paluru tjana ngayunya ngalya katingu Katutjanya tjapintjaku, paluru tjananya Yitjurilaku ngaṉṯitja tjuṯa pungkunytjaku. Katutjalu wiya tjananya kuliṉi pungkunytjakitjangku. Paluruṉi wiya watjaṉu. Palunyatjanu ngayuluṉa puṯu kuliṉi Yitjurilaku ngaṉṯitja tjuṯa yinkarra kuyalkitjangku. Tjana minga nguwanpa nyinanyi Katutjaku ninti tjuṯa, palumpa walytja tjuṯa.” Kulira Piilakalu Piilamanya yalatji payiṉu, “Nyarra tjuṯa yinkarra kuyantjakuṉanta watjaṉu. Yalatjiku tjana nyuntunya ngalya katingu. Wiya nyuntu tjanaya kuyalwiyangku wantinytjaku.” Piilamalu tjananya Piilakanyangarri piyuku watjaṉu, “Katutjaluṉi watjaṉutjangka kutjuṉa nyurrangarrinya watjalku.” Piilakalu Piilamanya watjaṉu ngurra kutjupakutu yankula tjawirrilyi kutjupa tjuṯa pungkula kutjantjaku. Piilaka paluru watjaṉu ngurra palulanguru Piilamalu piyuku Katutjanya tjapintjaku, paluru Yitjurilaku ngaṉṯitja tjuṯa mirri pungkunytjaku. Ngurra palula Piilamalungarri tjawirrilyi pungkula kutjara Piilamalu Katutjanya yankula piyuku tjapiṉu. Puṯu tjapira paluru yankula Piilakala yalatji watjaṉu, “Katutjalu tjanampa tjukarurru palyalku, kuyantjawiyangku.” Kulira Piilaka paluru Piilamanya piyuku watjaṉu, ngurra kutjupangka yankula tjawirrilyi tjuṯa pungkula kutjantjaku, Katutjanya piyuku tjapintjaku. Palulanguru Piilamalu Katutjanya piyuku tjapiṉu, Katutjalu tjananya mirri pungkunytjaku. Katutjalu piyuku watjaṉu Yitjurilaku ngaṉṯitja tjuṯa mirri pungkuwiyangku. Yalatji Piilamalu Piilakanya piyuku tjakultjunu. ");
INSERT INTO piu2006_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","25","Palulanguru Yitjurilaku ngaṉṯitja tjuṯa kuyalkitjangku Piilakalu wayilarringkula Piilamanya payira wantirriyaṉu, mani anta yulytja yungkuwiyangku. Yalatji Piilamanya payiṉu, Piilakalu, “Wikarrutja tjuṯanya tjananya ngayulu wantirriyaṉu, nyuntu ngalya yankula tjananya kuyantjaku. Palulanguru nyuntu tjananya kuyantjawiyangku wantingu. Wiyaṉanta mani, yulytjaṯarra yungku, ngurrakutu yarra!” Piilamalu watjaṉu, “Ngayulu irriṯi panyapa wikarrutja tjuṯangka watjaṉu, Katutjaku wangkawana kutjuṉa palyalku. Tjinguruṉin mani tiṉa, puḻi kuulta, puḻi tjiilpa yungkunytjala, ngayuluṉa wantirra Katutjaku kutju ngayulu tjukarurru nyinaku.” Ngurrakutu yankukitjangku Piilama paluru Piilakanya yalatji watjaṉu, “Ngurra walytjakutuṉa piyuku yananyi. Katutjalu watjaṉutja ngaatja wiya kutjuṉanta tjakultjunanyi. Yitjurilaku ngaṉṯitja tjuṯaku mayutju tiṉa ngula nyinaku. Mayutju paluru tjananya palumpa tjilirratjarra tjuṯa ngalya katiku, Muwapanya ngurrara tjuṯa mirri pungkula nguḻutjingara wantirriyantjaku, Yiitumanya ngurrara tjuṯaṯarra. Alatji nyurrangarrinya mirri pungkula ngurraṯarra nyurrampa kanyilku, ngurrangkaya kutu nyinakitjangku. Ngurra kutjupa kutjupa nyinanytja tjuṯa tjananya Yitjurilaku ngaṉṯitja tjuṯangku mirri pungkula wiyalku, ngurra tjanampangkaya kutu nyinakitjangku.” Wangka palunya tjakultjunkula wantirra Piilamanya ngurra walytjakutu piyuku yanu. ");
INSERT INTO piu2006_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","23","Mayutju Katutjalu Muutjanya watjaṉu, “Ngayuluṉa nyupalinya Yirananya ngurra Kiititjala watjaṉutjangka, kulintjawiyangku nyupali wantingu, kapi tjanampa mantjintjakitjangku. Ngayulu ngangkari puntutjarrangku palyalpayi kututja, wiya nyupali yalatji tjananya nintiṉu. Palulanguru nyuntu puḻingka kaḻparra paṉa Kayinananya nyakula mirrirriku. Paṉa palulakutu nyuntu wiya yankula nyinaku.” Muutja paluru Katutjanya tjapiṉu, “Tjapiṉiṉanta nyuntu mayutju kutjupalpi tjanampa ngaratjunkunytjaku, pikakutu tjananya tjukarurru katinytjaku. Wati nguḻuwiya nyinanytja ngurrtjara ngaratjurra!, mayutjungku tjananya kanyintjaku, mayutjuwiyalpiya nyinatjipingkamarra.” Palunyatjanu Katutjalu Muutjanya watjaṉu, “Yankula Tjatjuwanya tjiḻpi Naanaku katja yaḻṯirra ngalya katirra ngaratjurra!, tuḻkuku mayutju tiṉangka yila, yini Yalitjala. Yalatji Tjatjuwanya ngaranytjala tuḻkuku mayutjungka kurungka, yaṉangu tjuṯangka kurungkaṯarra, nyuntu Tjatjuwangka mara katangka tjunkula yalatji tjanala watjala!, ‘Wati ngaatjanyalpi mayutju nyurrangarrimpa ngaranyi, ngayuluṉa kuwarri mirrirriku. Karru Tjuutanangka munkarra wiyala tjungu yankula nyinaku. Mayutju ngaangku nyurrangarrinya katiku, karru Tjuutanangka wilurarra tjananya pikangku pungkunytjaku. Mayutju Katutjalu nyurrangarrinya aalpamilalku, ngurra palunya ngurrara tjuṯa mirri pungkula wiyantjaku. Nyurrangarri nguḻuwiyangku tjananya yankula pungkunytjaku.’” Palunyatjanu Muutjalu Tjatjuwanya piyuku yalatji watjaṉu, “Rapangku tjananya katiyanama!, nguḻuwiyangku. Nyuntu yilta tjananya katirra nyinatjunku paṉa Kayinanala, panya Katutjalu yirriṯi nyinanytja tjuṯa yungkukitjangku watjaṉutjangka. Mayutju Katutjalunta purinypa katiyanamalpa, wantinytjawiyangku. Palulanguru nyuntu rapanytju nyinama!” ");
INSERT INTO piu2006_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","8","Ngula Katutjalu Muutjanya yalatji watjaṉu, “Yitjurilaku walytja ngaṉṯitja tjuṯa tjananya yalatji watjala! Ngurra Kayinanalakutu yankula mirri pungkuyinkula tjananya nyurrangarri ngurra tjanampaṉu kanyilku. Kanyiranyurra tawunu tjikitjipala ngurrtjara watjantjaku, tawunu palula tjanala yaṉangu mirri pungkupayi tjalkaḻungkula kumpintjaku. Tawunu palunya tjuṯangka yaṉangu mirri pungkupayi tjuṯa tjalkaḻungkula kumpira kana nyinanytjaku, ngaparrtjingku tjananya pungkutjipingkamarra. Yaṉangu kutjupa kulintjawiyangku yiluntankula tawunu palulakutu tjalkaḻungkula kumpira nyinanytjaku, mirriku walytja tjuṯangkuya wanara ngaparrtjingku mirri pungkutjipingkamarra. Mirriku walytja tjuṯaya wiya tawunu palunya tjuṯangka tjarrpanytjaku, ngaparrtjingku mirri pungkukitja. “Tjinguru mirri pungkukitjangku kulintjawiyangku yaṉangu kutjupa punganyingka, yaṉangu pungutja paluru ngaṉṯi mirrirriku. Palunyatjanu wati paluru palunya pungkula tawunu palulakutu tjalkaḻungkula kana nyinanytjaku. Tjinguru wati kutjupangku nyakunytjawiyangku tjinguru kuḻaṯa palunya waṉirra watilpi kumpira ngarrinyingka wakara mirrintanku. Palunyatjanu wati paluru tawunu palulakutu nguḻulpi tjalkaḻungkula nyinarra kanarringkunytjaku. “Tawunu palula nyinanyingka, kuutawutjungkaya ngaratjunkula watjalku. Wangkarraya watjalku wati palunya wiya ngaparrtjingku mirri pungkunytjaku, wiyakutjura kuḻaṯa palunya kulilwiyangku waṉirra wakaṉutjangka. Yalatji watjaṉutjangka wati palunya nyinanytjaku ngurra palula, ngurra walytja palulakutu piyuku yankunytjawiya, mirriku walytja tjuṯangku paṯara pungkutjipingkamarra. Tuḻkuku mayutju tiṉa mirrirrinyingka kutju, pakara ngurra walytjakutu ngula piyuku yankunytjaku, nyinanytjakitja. “Tjinguru wati kutjupangku yaṉangu kutjupaku kuyarrirra mirri pungkula, paluru tjinguru tawunu palulakutu tjalkaḻungku, kana nyinanytjakitja. Palunyatjanu tawunu palula kuutawutjungkaya wangkarra watjalku, wati palunya ngaparrtjingku mirri pungkunytjaku. “Tjinguru yaṉangu kutjupangku rawa mulyarrara nyinarra ngankirrikutu yuṉṯulku, punkara mirrirrinytjaku. Palunyatjanu mirri palumpa walytja ilatjangku wanara ngaparrtjingku mirri pungkunytjaku. “Wati kutjupa mulyarrarrirra mirri punganyingka, ngurra paṉa palunya kuyarringku. Mirri pungkupayi palunya ngaparrtjingku mirri punganyingka, ngurra, paṉa kuyarrinytja palyarriku. Palyanyurra nyinanytjaku mulyarrarrirra yaṉangu kutjupa pungkunytjawiya. Ngurraṯarra kuyantjawiyangku kanyintjaku palyangku, ngayulu mayutju Katutjaluṉa nyurrangarrinya watjaṉingka.” ");
INSERT INTO piu2006_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","19","Tjatjuwaku ngalungku tjuṯa yilungutjangka, katja tjuṯangku yuṉṯalpa tjuṯangku Katutjanya wantirra ramarringkula wiyawana nyinangi. Yalatjiya nyinarra Katutjanya nguwanpa tjuṯa, Paalanyangarri waḻkura nyinangi. Palulanguru Katutjalu tjananya ngurrkurrirra wantingu. Ngurra kutjupa ngurrara tjuṯangku ngalya yankula pungkula tjananya wantirriyaṉu. Mani tjuṯa, yulytja tjuṯa tjanampa mantjira katingu, kungka tjuṯaṯarra tjulyara katingu. Yitjurilaku ngaṉṯitja tjuṯangku tjilirratjarrangku yankula puṯu pungkupayi yaṉangu palunya tjuṯa, Katutjalu wiya tjananya aalpamilaṉu. Kutjupa tjuṯalpi tjananya Katutjalu aalpamilaṉu Yitjurilaku ngaṉṯitja tjuṯa pungkula wantirriyantjaku. Palulanguruya Yitjurilaku ngaṉṯitja tjuṯa nguḻurrirra puṯu kuliṉu. Palulanguru Katutjalu tjanampa Yitjurilaku ngaṉṯitja tjuṯaku mayutju tjuṯa nyinatjunu. Mayutju paluru tjananya tjilirratjarrangku pikaku katipayi. Yalatji tjanampa mayutju kutju nyinarra wiyarringu, tjilirratjarra tjuṯaku. Palulanguru Katutjalu tjanampa mayutju kutjupa nyinatjunu. Mayutju paluru nyinarra yilungu, palulanguru mayutju kutjupalpi tjanampa nyinatjunu. Yalatji tjanampa Katutjalu tjilirratjarra tjuṯaku mayutju tjuṯa nyinatjunu. Mayutju yilungutjangka yaṉangu tjuṯa wiya tjukarurru nyinapayi. Katutjaku wangkaṯarraya kulira wantipayi. Tjana kuya palyalpayi, Katutjanya nguwanpa tjuṯaya waḻkura nyinapayi, Katutjanya yilta tjana wantirra nyinapayi. Mayutju kutjungku tjananya palya kanyilpayi. Palulanguru kutjupa tjuṯa katirra pungkula nguḻutjingalpayi. Palulanguru Yitjurilaku ngaṉṯi tjuṯa tjukarurru nyinapayi mayutju palumpa. Palulanguruya Katutjaku tjukarurru nyinangu. Mayutju paluru yilungutjangka ngunytjiwanaya Katutjaku nyinapayi. Yalatjiya rawa Yitjurilaku ngaṉṯitja tjuṯa palya nyinarra kuyarringu, Katutjaku tjukarurru nyinanytjawiya. ");
INSERT INTO piu2006_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","10","Palulanguruya Yitjurilaku ngaṉṯitja tjuṯangku Katutjanya wantirra kuya palyaṉingi. Palulanguru Katutjalu tjananya wantingu, Mitiyanya ngurrara tjuṯa tjanampa mayutjulpi nyinanytjaku. Mayutju tjikipaka tjuṯangku tjananya kanyiṉingi, Mitiyanya ngurrara tjuṯangku. Panyapa tjuṯangkamarra Yitjurilaku ngaṉṯitja tjuṯa kuḻpi tjuṯangka tjarrparra kumpiṉingi. Yitjurilaku ngaṉṯitja tjuṯangkuya mangarri pakaltjingalkitjangku yuṉinypa tjunkula wantipayi, mangarri walytja tjanampa pakara yuṉmirringkunytjaku. Palulanguru Mitiyanya ngurrara tjuṯangkuya yankula mangarri yuṉmirrikitja kilytjuntara waṉipayi. Tjiipi tjuṯa, puluka tjuṯa, tuungkiyi tjuṯaṯarra tjungura tjanampa mulyaṯangku katipayi. Tjuṯalingkungkuya minga nguwanpangku ngalya yankula mangarriṯarra kilytjuntara kuyalpayi. Palulanguruya Yitjurilaku ngaṉṯitja tjuṯangku mangarritjirratjangku puṯu kulira nyinapayi. Yalatji puṯu kulira tjana Katutjanyalpiya tjapiṉu, Mitiyanya ngurrara tjuṯa pungkula wantirriyantjaku. Katutjalu wantirriyaṉu, palumpa wangka watjalpayi tjanalakutu. Paluru tjananya tjakultjunu Yitjurilaku ngaṉṯitja tjuṯangka yalatji, “Mayutju Katutjalu nyurranya yalatji watjaṉi, ‘Ngayuluṉa tjananya paṉa Yitjipitjanu ngalya katingu waarrkarringkula kutuya nyinapayingkamarra. Nyurrangarrimpa walytja yirriṯitja tjuṯa nyinangi ngaangka. Tjanaya ngaangka nyinanytjaku ngayuluṉa ngaa ngurrara kutjupa tjuṯa pungkula wiyalpayi. Ngayulu ngurra ngaatja yungu nyurrangarri kutu nyinanytjaku. Ngayulu nyurrangarrinya ngurra ngaatja yungu ngaangkanyurra nyinarra ngayunya waḻkuntjaku. Nyurrangarri ngayunya kulira wantingu.’” ");
INSERT INTO piu2006_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","6","Yirriṯi Muutjalu Yitjurilaku ngaṉṯitja tjuṯa yalatji watjaṉu, “Mayutju Katutjalu nyurrampa Kayinananya ngurrara tjuṯa mirri pungkula wiyalku, ngurra palulalpinyurra nyinanytjaku. Kulilaya! Yilta nyurrampa ngurra ngaatja Katutjalu yungkuku, tjingurunyurra palumpa tjukarurru nyinangutjangka. Wiya. Nyurrangarri palumpa wiya tjukarurru nyinangu. Katutjalu nyurrampa yungkuku yirriṯi watjaṉutja. Katutjalu tjananya Kayinananya ngurrara tjuṯa mirri pungkula wiyalku, tjana kuya kutu palyalpayi. Pungkula tjananya wiyalku nyurrangarrinya ngurra yungkukitjangku, yirriṯi tjanampa watjaṉutjangka, Yipuramaku, Yatjikaku, Tjikupakungarri, ngurra palunya. Tjukarurru wiyanyurra nyinangu Katutjaku, militjitjinyurra nyinapayi.” ");
INSERT INTO piu2006_vpl VALUES ("DT31_1","006_31_1","DEU","31","1","8","Mayutju Katutjalu Muutjanya watjaṉu, “Ngayuluṉa nyupalinya Yirananya ngurra Kiititjala watjaṉutjangka, kulintjawiyangku nyupali wantingu, kapi tjanampa mantjintjakitjangku. Ngayulu ngangkari puntutjarrangku palyalpayi kututja, wiya nyupali yalatji tjananya nintiṉu. Palulanguru nyuntu puḻingka kaḻparra paṉa Kayinananya nyakula mirrirriku. Paṉa palulakutu nyuntu wiya yankula nyinaku.” Muutja paluru Katutjanya tjapiṉu, “Tjapiṉiṉanta nyuntu mayutju kutjupalpi tjanampa ngaratjunkunytjaku, pikakutu tjananya tjukarurru katinytjaku. Wati nguḻuwiya nyinanytja ngurrtjara ngaratjurra!, mayutjungku tjananya kanyintjaku, mayutjuwiyalpiya nyinatjipingkamarra.” Palunyatjanu Katutjalu Muutjanya watjaṉu, “Yankula Tjatjuwanya tjiḻpi Naanaku katja yaḻṯirra ngalya katirra ngaratjurra!, tuḻkuku mayutju tiṉangka yila, yini Yalitjala. Yalatji Tjatjuwanya ngaranytjala tuḻkuku mayutjungka kurungka, yaṉangu tjuṯangka kurungkaṯarra, nyuntu Tjatjuwangka mara katangka tjunkula yalatji tjanala watjala!, ‘Wati ngaatjanyalpi mayutju nyurrangarrimpa ngaranyi, ngayuluṉa kuwarri mirrirriku. Karru Tjuutanangka munkarra wiyala tjungu yankula nyinaku. Mayutju ngaangku nyurrangarrinya katiku, karru Tjuutanangka wilurarra tjananya pikangku pungkunytjaku. Mayutju Katutjalu nyurrangarrinya aalpamilalku, ngurra palunya ngurrara tjuṯa mirri pungkula wiyantjaku. Nyurrangarri nguḻuwiyangku tjananya yankula pungkunytjaku.’” Palunyatjanu Muutjalu Tjatjuwanya piyuku yalatji watjaṉu, “Rapangku tjananya katiyanama!, nguḻuwiyangku. Nyuntu yilta tjananya katirra nyinatjunku paṉa Kayinanala, panya Katutjalu yirriṯi nyinanytja tjuṯa yungkukitjangku watjaṉutjangka. Mayutju Katutjalunta purinypa katiyanamalpa, wantinytjawiyangku. Palulanguru nyuntu rapanytju nyinama!” ");
INSERT INTO piu2006_vpl VALUES ("DT31_9","006_31_9","DEU","31","9","13","Muutjalu Katutjaku wangka piipangka wakaṉu. Wakara Lipayiku ngaṉṯitja tjuṯaku yungu, tjaatji kalikingka tjunkula kanyintjaku, pukutju palula, puḻi wirulypa kutjarrangka ila. Palunyatjanu Muutjalu tjananya yaṉangu tjuṯa ngarala Katutjaku wangka nintiṉingi. Piyuku tjananya paluru watjaṉu, “Ngayulu nyurrangarrinya wangka palunya kuwarri nintiṉu, wangka ngaaku nyurrangarri tjukarurru nyinanytjaku. Nyurrangarri tjanala wangka palunya katja tjuṯangka, yuṉṯalpa tjuṯangkaṯarra nintila!, alatji kulira tjana Katutjaku wangkakulpi tjukarurru nyinanytjaku. Wangka palunya maṯupurra. Karru Tjuutanangka wilurarra nyurrangarri nyinarra wangka palulawana tjukarurru kutu nyinama! Wangka palulawana nyurrangarri tjukarurru nyinarra kana nyinamalpa ngurra palula.” ");
INSERT INTO piu2006_vpl VALUES ("DT32_48","006_32_48","DEU","32","48","52","(32:48-52; 34:) Mayutju Katutjalu Muutjanya yalatji watjaṉu, “Nyuntu paṉa Muwapalawana yankula puḻi Niipungka kaḻparra paṉa Kayinananya nyawa!, puḻi katunguru. Palulanguru nyuntu nyakula puḻingka katu mirrirriku, nyupali, nyuntupa kaakangkuṯarra irriṯi ngurra Kiititjala ngayuku wangka kulira wantingu.” Palunyatjanu Muutjanya yankula puḻi Niipungka maḻpawiya kaḻpangu. Palulanguru kaḻparra katu ngarangi. Katutjalu palunya nintiṉu, paṉa Kayinananya. Paṉa tjuṯa palunya Muutjanya nintira Katutjalu watjaṉu, “Paṉa nyarratja ngayulu Yitjurilaku ngaṉṯitja tjuṯaku yungkukitjangku watjaṉu Yipuramala, Yatjikala, Tjikupala, palumpa tjanampa ngaṉṯitja tjuṯaku, kutu tjana nyinanytjaku. Paṉa nyarrangka wiya nyuntu yankula nyinaku.” Palunyanguru mayutju Katutjaku waarrkana Muutjanya mirrirringu. Katutjalu Muutjanya mirri katirra paṉa Muwapangka puliinangka tjunutjunu. Tjunutjunkunytjala yaṉangu tjuṯangku wiya nyakupayi, yaṉangu tjuṯaya ngurrpa nyinangi. Muutjanya yiiya yantaṯan tuuntiyipala nyinarra alatji paluru mirrirringu. Yitjurilaku ngaṉṯitja tjuṯaya rawa yulangi Muutjaku, Puratiyi puupala. ");
INSERT INTO piu2006_vpl VALUES ("DT34_1","006_34_1","DEU","34","1","12","(32:48-52; 34:1-12) Mayutju Katutjalu Muutjanya yalatji watjaṉu, “Nyuntu paṉa Muwapalawana yankula puḻi Niipungka kaḻparra paṉa Kayinananya nyawa!, puḻi katunguru. Palulanguru nyuntu nyakula puḻingka katu mirrirriku, nyupali, nyuntupa kaakangkuṯarra irriṯi ngurra Kiititjala ngayuku wangka kulira wantingu.” Palunyatjanu Muutjanya yankula puḻi Niipungka maḻpawiya kaḻpangu. Palulanguru kaḻparra katu ngarangi. Katutjalu palunya nintiṉu, paṉa Kayinananya. Paṉa tjuṯa palunya Muutjanya nintira Katutjalu watjaṉu, “Paṉa nyarratja ngayulu Yitjurilaku ngaṉṯitja tjuṯaku yungkukitjangku watjaṉu Yipuramala, Yatjikala, Tjikupala, palumpa tjanampa ngaṉṯitja tjuṯaku, kutu tjana nyinanytjaku. Paṉa nyarrangka wiya nyuntu yankula nyinaku.” Palunyanguru mayutju Katutjaku waarrkana Muutjanya mirrirringu. Katutjalu Muutjanya mirri katirra paṉa Muwapangka puliinangka tjunutjunu. Tjunutjunkunytjala yaṉangu tjuṯangku wiya nyakupayi, yaṉangu tjuṯaya ngurrpa nyinangi. Muutjanya yiiya yantaṯan tuuntiyipala nyinarra alatji paluru mirrirringu. Yitjurilaku ngaṉṯitja tjuṯaya rawa yulangi Muutjaku, Puratiyi puupala. ");
INSERT INTO piu2006_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","18","Mayutju Katutjalu Tjatjuwanya watjaṉu, “Kuwarrinyurra yulytja kalikiṯarra mantjira kamulangka tjunkula kati! Karru Tjuutanangka tjarukatirra maa kaḻparra maa yankula yila nyina! Karru palula munkarra parra nyakulanyurra ngurra palula nyinanytjaku. Ngurra palunya nyurrangarrimpa ngaraku. Palyanyurra yankula pikalu pungkula ngurra mantjilku, tjilirratjarra tjuṯangku. Tjilirratjarra kutjupa tjuṯangku nyurranya puṯu pungkula nguḻutjingara wantirriyalku. Ngayuluṉanta Tjatjuwanya yaṉṯayaṉṯara kanyilku, tjiḻpi Muutjanyaṉa yaṉṯayaṉṯara kanyiṉutja nguwanpa. Ngayuku wangkaku nyuntu palya kutu nyinanytjaku. Wiyaṉanta wantikatiku, rawangkuṉanta yaṉṯayaṉṯara kanyilku. Ngayuku wangka piipangka ngarrinytjala kutu tjananya riitarrirra nintintjaku, yaṉangu tjuṯangka. Wangka palunya rawangku nyuntu riitarrirra nintirringkunytjaku. Yalatjiku nintirringkula nyuntu palya kulira tjananya nintingku kanyilku, mayutju palyangku. Nguḻurringkunytjawiya nyuntu rapa nyinama!, ngayuluṉanta Katutjalu kutu yaṉṯayaṉṯara katiyanku.” Palulanguru Tjatjuwalu tjananya watjaṉu waarrkana kutjupa tjuṯa yaṉangu tjuṯawana tjananya yankula tjakultjurinkunytjaku. Yalatjiya tjakultjunu, “Mayi kutjara yulytja tjuṯaṯarra mantjira yuṯitjurra! Tjiṉṯu tjirripalangkala karru Tjuutanangka tjarukatirra maa kaḻparra munkarra nyinanytjaku, manta palyangka, manta palunya Katutjalu tjananya yirriṯi watjaṉutjangka.” Palulanguru Tjatjuwalu tjananya yaṉangu tjuṯangka watjaṉu, “Muutjalu nyurranya yirriṯi watjaṉu, kutjupa tjuṯanyurra palya Tjuutanangka kakarrara nyinanytjaku. Ngayuluṉa kuliṉi palya. Nyurrangarrimpa kungka tjuṯa, pipirri tjuṯa, Tjuutanangka kakarrarawana nyinaku. Kungka palunya tjuṯangkuya nyurrangarrimpa puluka tjuṯa, tjiipi tjuṯa palya kanyinmalpa, nanikuta tjuṯaṯarra. Kanya wati tjuṯanyurra kakarrara ngurrara karru Tjuutanangka munkarra tjungula!, yankunytjaku wilurarra, pungkula tjananya manta mantjintjaku. Ngula nyurrangarri palulanguru wilurarra manta mantjira ngalya yankula nyinanytjaku, ngaangka karru Tjuutanangka kakarrara.” Kakarrara ngurrara tjuṯangku kulira watjaṉu, “Yuwa, palyala tjungu yankuku, kala palyalatju ngalya yankula ngaangka nyinaku.” ");
INSERT INTO piu2006_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","2","Palulanguru Tjatjuwalu waarrkana kutjarra wilurarra wantirriyalkitjalu watjaṉu, “Mantarra Tjirikunya ngurrarangka tjarrparrapula parra ngurrilapula tjanampa ngurra!, waaḻa yunnguṯarra tawunu Tjirikungka tjarrparra parra nyakula ngalya yankulaṉipula tjakultjurra, ngayula!” Kuliralpipula yankula parra ngurrira Tjirikukuturringu. Tjarrparrapula kungkaku waaḻangka kumpira nyinangi. Kungka paluru yini Rayapanya. Watingku kurra palyara mani yungkunytjaku paluru paṯara nyinapayi. Tawunu Tjirikuku mayutjulu tjakulpa kuliṉu, Tjatjuwaku waarrkana kutjarra kumpintjatjanungka, Rayapaku ngurrangka. Mayutju paluru kuliṉu, “Paluru kutjarra ngalya yanu ngurra nyakulinkunytjaku, nyakulinkula maḻakupula yankula mayutjungka tjakultjunkukitja.” ");
INSERT INTO piu2006_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","24","Mayutju palulamarra Rayapalu pulanya Tjatjuwaku waarrkana kutjarra yurrunpa katirra waaḻangka kaḻpatjunu, kumpirapula nyinanytjaku. Palulanguru yukiri piḻṯirringutjangka katirra pulanya yarrkatjunu. Kala, mayutju paluru waarrkana tjuṯa wantirriyaṉu, Rayapaku ngurrakutu. Rayapanya yalatji tjana tjapiṉu, “Wati paluru kutjarra yaalytji? Mayutjululanyatju watjaṉutjangka, katinytjakulatju palunya kutjarra. Nintingkulatju kuliṉi nyangutjangku. Paluru kutjarra ngalya yanu ngurra nyakuyinkula piyuku yankukitja.” Kulira Rayapalu tjananya nguntilyinu, “Paluru kutjarra ngaangka nyinarra yanu. Tjiṉṯu tjarrpanytjalapula pakara wampa yanu. Tjingurupula yanu ngurrakutu. Parriki puntu ngaranyi waaḻa tjuṯangka yila. Parriki palunya ngaṉṯiya kiiṯa patiṉu. Waaḻa ngaangurupula pakara yurrunpa yanu. Wanaranyurra parrpaṯu witilku.” Palulanguru Rayapaku wangka yiltakutjura kuliraya puṯu ngurririnkula kala karru Tjuutanakuturringuya, Tjatjuwaku waarrkana kutjarra witilkitja. Paluru tjana yanutjangka ngaṉṯi Rayapalu pulanya yankula tjakultjunu. Watjaṉu pulanya, “Katutjalu nyurranya yilta manta ngaatja yungkuku Yitjurilaku ngaṉṯitja tjuṯaku. Ngaa ngurrara tjuṯalatju nguḻu nguwanpa nyinanyi nyurrangarrilamarra. Ngurra tjuṯawanalatju nguḻu nyinanyi.” Rayapalu pulanya piyuku watjaṉu, “Tjakulpalatju kulilpayi yuru Tjatjakawana nyurrangarrinya katingutjangka. Kutjupa tjuṯa, Muwapanya ngurrara tjuṯa pungutja nganaṉatju kuliṉu. Yilta nyurrangarrimpa mayutju tiṉa Katutjanya kutju nyinanyi. Katutja palula mirangka tjukarurrupula wangka!, nganaṉanyatju pungkuwiyangku wantinytjaku, ngayuku walytja tjuṯa, ngayulu nyupalinya kumpitjunkula yaṉṯayaṉṯaṉutjangka. Yalatjipula wangka!, pungkuwiyangkulanyatju wantinytjaku.” Wati kutjarrangkupula watjaṉu, “Yiltalinyatjun yarrkatjunkula kanaṉu. Ngalitju yankunytjala ngaṉṯi wangkawiya nyinama! Nyuntu tjakultjunkunytjawiya nyinanytjala, yilta nganaṉatju nyurrangarrinya kanara yaṉṯayaṉṯara kanyilku, mirri pungkuwiyangku.” Wati paluru kutjarra Rayapanya piyuku watjaṉu, “Ruupa tjatjaka ngaatja nyuntupa waaḻa yaḻangka yuti taayitinkula ngaratjurra!, ngalya yankulalatju nyakula nuuwimilantjaku. Nyakula nyurrangarrinya pungkuwiyangku wantiku, waaḻa ngaangka nyinanytja tjuṯa.” Waaḻa tjuṯa ngarangi parrikingka yunngu. Rayapaku waaḻa parriki tiṉangka yila ngarangi. Rayapalu waaḻa yaḻawana ruupa kutjupa tjarrpatjunu, wati kutjarralupula ruupa witira tjarukatinytjaku, parriki tiṉangka yaatjayiṯi. Walatjunkula pulanya iyaṉu, puḻingka yankula kumpintjaku. Yankulapula nyinangi tjiṉṯu maṉkurrpa. Palulanguru Rayapalu ruupa tjatjaka palunya katu mantjira yaḻangka yila tjunkula wantingu, ngulaya ngalya yankula nyakunytjaku, Tjatjuwalungarri. Tjirikunya ngurrara tjuṯangkuya palumpa kutjarrakuya puṯu ngurrira maḻakuya yanu. ");
INSERT INTO piu2006_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","17","Mungawinki pakara Yitjurilaku ngaṉṯitja tjuṯaya pakara yinytjami kalikiṯarra mantjira wilurarra yanu, karru Tjuutanalakutu. Kapi tiṉangku pungkula wantinytjala karru palula kapi puḻkarringkula ngankirringka katu ngarripayi. Tjiṉṯu maṉkurrpaya rawa karrungka yila nyinapayi. Palulanguru mayutju tjuṯangku tjananya parra tjakultjurinangi, “Tuḻkuku mayutju tjuṯaluya pukutju palunya puḻi wirulypa kutjarratjarra mantjira katinytjala, nyakula pakara waṉmawanangku wanantjaku, wiya yilawanangku.” Palulanguru mayutju Katutjalu Tjatjuwanya watjaṉu, “Kuwarriṉa nyurrampa yatjikingku kutjupa kutjupa palyalku. Palulanguru yaṉangu tjuṯangkuya yalatji kulilku, ‘Yilta Tjatjuwanyalampa mayutju tiṉa nyinanyi, Muutjanya nguwanpa nintiṉu.’” Tjatjuwalu wangka palunya kulira yankula yaṉangu tjuṯangka tjanala watjaṉu, “Ngalya yankulaya kulila!, Katutjakuṉu wangka. Yalatji nyurrangarrinya watjaṉu, ‘Katutjaluṉa nyurrampa manta Kayinananya yungkuku palula nyinanytjaku. Palulanguru Kayinananya ngurrara ngayuluṉa tjananya pungkula wantirriyalku, wiyawanaya nyinanytjala. Yalatji yinitjarra tjuṯaku ngaṉṯitja tjuṯaṉa tjananya pungkula iyalku, Yitatuku ngaṉṯitja tjuṯa, Yipataku ngaṉṯitja tjuṯa, Piritjaku ngaṉṯitja tjuṯa, Kakatjaku ngaṉṯitja tjuṯa, Yamuraku ngaṉṯitja tjuṯa, Tjiputjaku ngaṉṯitja tjuṯa. Yalatji tjananya ngayulu pungkula wantirriyalku. Tuḻkuku mayutju tjuṯangkuya ngayuku pukutju yurrunpa katinytjala nyurrangarri nyakula kulilku, “Katutjala tjungu yananyi.” Pukutju palunyaya katirra kapingka tjinangku paḻira kanyilku. Palulanguru kapi wiyarringkuku, karrungka raanarringkunytjawiya. Kapi yalinytjarratjayiṯi pulaparringkula ngarakatinytjala kapi mantangka wiyarringkuku. Palulanguru mantawananyurra yankuku.’” Palulanguru Tjatjuwanya piyuku watjaṉu Katutjalu, “Tuḻkuku mayutju tjuṯa tjananya wangka!, pukutju palunya katinytjaku. Katirraya ngara!, kapi paḻira ngaranytjaku.” Palulanguruya tjana yankula kapi paḻira ngarangi. Palulanguru kapi raanarringkunytja wiyarringu. Kapi yalinytjarratjayiṯi pulaparringkula ngarringi, Katutjalu marrkuṉutja. Palulanguru tuḻkuku mayutju tjuṯaluya ngururrpa maa katirra ngarangi tjinangku paḻira. Palunyangka yaṉangu tjuṯalingkuya maa tjarukatirra maa kaḻpangu. Rawaya kaḻpangi tjuṯalingku. ");
INSERT INTO piu2006_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","24","Yankula kaḻparra nyinangiya karrungka katu. Katutjalu Tjatjuwanyalpi watjaṉu, “Wati tuwalpala nyuntu ngurrtjara mantjila!, yalatji. Ruupinaku ngaṉṯitja tjuṯanguru kutju mantjila! Tjuutaku ngaṉṯitja tjuṯanguru kutju mantjila! Lipayiku ngaṉṯitja tjuṯanguru kutju mantjila! Nayinpala mantjila ngaṉṯitja kutjupa tjuṯanguru! Palulanguru tjananya watjala!, yankulaya puḻi kutjuṯu kutjuṯu mantjintjaku, karrungka ngururrpa. Mantjiraya ngalya katirra ngankirringkaya katu kapuṯu tjunkunytjaku, puḻi tuwalpala. Ngankirringka ngarrinytjala puḻi tuwalpala kutjupa tjuṯa mantjiraya katirra karrungka ngururrpa kapuṯu tjunkunytjaku.” Rawalingkuya ngarangi pukutjutjarra karrungka ngururrpa, puḻi tuwalpala mantjira tjunkula wantinytjala, palulanguru pukutjutjarra pakaraya yanu, yaṉangu tjuṯangku nyakunytjala. Pukutjutjarra katu kaḻparraya katiyanangi katuwana. Tjana yalatji katiyananyingka kapilpi raanarringangi karru tiṉangka. Katutjalulpi kapi iyaṉu karruwana yankunytjaku. Tjatjuwalu tjananya watjaṉu yaṉangu tjuṯangka piyuku, “Ngula nyurrangarrimpa katjapiṯingku yuṉṯalpiṯingku puḻi tuwalpala ngaatjanya nyakula nyurranya tjana tjapintjala, watjala tjananya yalatji!, ‘Katutjalu ngangkari puntutjarrangku karru ngaatjanya yangatjunu, tjarukatirralatju mantawana yankulalatju ngalya kaḻpangu.’” Palulanguruya Tjatjuwanyangarri ngurra Kilkalalakutu yankula kaliki palyaraya wilytjangka nyinangi, Tjirikungka yila. Yaṉangu tjuṯalingkuya nyinangi, wulkumanu tjuṯa, tjiḻpi tjuṯa, yangupala tjuṯa, yukarra tjuṯa, pipirri wiima tjuṯaṯarra, tjilirratjarra tjuṯaṯarra. ");
INSERT INTO piu2006_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","12","Kayinananya ngurrara tjuṯangkuya tjakulpa kuliṉu Katutjalu tjanampa kapi marrkuṉu Yitjurilaku ngaṉṯitja tjuṯa karruwana ngalya tjarukatirra ngalya kaḻpanytjaku. Yalatjiya kulira nguḻurringu, “Katutjalu tjananya yaṉṯayaṉṯaṉi. Tjinguruya ngaakutu ngalya yananyi nganaṉanya pungkula iyantjaku.” Palulanguru Tjatjuwanya Katutjalu yalatji watjaṉu, “Tjungura tjananya watjala tjana watirringkunytjaku!” Manta Yitjipilanguruya ngalya yankula paapa tjuṯa rawa nyinarra tjiḻpirringkula wiyarringu. Paluru tjana wiya katjapiṯi tjamupiṯi watimanangi. Palulanguru Katutjalu Tjatjuwanya watjaṉu, “Watjala tjananya!, katjapiṯi tjamupiṯilpi watirringkunytjaku.” Palulanguru Tjatjuwalungarri tjananya katirra watiṉu. Katjapiṯi tjamupiṯi tjana pira kutjungka nyinarra palyarringu. Ngurra palulaya nyinarra tuḻku Patjuwupangkaya tjiipi pungkula kunaṯinpa ngalkuṉu Katutjanya waḻkulkitjangku. Mayi tjaatiṯarraya ngalkura warrara waḻkulpayi. Palunyatjanu mayi maana tjanampa wiyarringu, puutjikarratja. Piyuku wiyalpi tjananya Katutjalu yungkupayi. Yankulaya parra mantjirinkupayi mangarri wiita rungkaraya ngalkupayi, Kayinananya ngurraralu pakaltjingaṉutjangka. Yalatji rawaluya mayi wiitaya ngalkula nyinapayi. ");
INSERT INTO piu2006_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","15","Palulanguru Tjatjuwanya yanu tawunu Tjirikungka ila parra ngaranytjaku. Parra ngaralinkula paluru tjukurrpa nguwanpa nyangu, wati kutju tjuuḻa waṯawara kanyintjala. Tjatjuwalu tjapiṉu, “Nyuntu yaalytjinguru ngalya yanu? Tjinguru nyuntu ngalya yanu nganaṉanya pungkunytjakitja? Tjinguru nyuntu tjanampa walytja?” Wati paluru wangkangu, “Nyurrangarri Katutjaku walytja tjuṯa nyinanytjala ngayuluṉa ngalya yanu mayutju nyurrangarrimpa tiṉa, nyurrangarrinya watjantjakitja. Ilkari ngurrara tjuṯa tjuulytji nguwanpa nyinanyi. Ngayulu tjanampa mayutju tiṉa nyinanyi.” Tjatjuwalu nguḻurringkula waṯungarala waḻkuṉu, “Ngayuluṉa nyuntupa waarrkana. Nyaampaṉanta palyantjaku nyuntu yunytjurringanyi?” Wati paluru watjaṉu Tjatjuwanya, “Puutatjarralu wiya manta miiḻmiiḻpa paḻintjaku. Nyuntu puuta yarrara tjurra!, Katutjaku manta ngaangka.” Palulanguru Tjatjuwalu kulira puuta yarrara tjunu. ");
INSERT INTO piu2006_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","6a","Palunyangka parrikiya puḻitjanu palyara wantingutja ngarangi. Tawunu Tjirikunya waaḻa tjuṯa parrikingka yunngu ngarangi. Parriki parra ngaratjunkula wantingu, waaḻangka yaatjayiṯi. Parriki palunyangka kiiṯa tiṉaya patira wantingu, Yitjurilaku ngaṉṯitja tjuṯaya ngalya yankula tjarrpatjipingkamarra, tjarrparraya tjananya pungkutjipingkamarra. Palunya ngurrara yunngu kutuya rawa nyinangi, yaatjayiṯi wiya yankupayi kaanakutu, kiiṯa puntuya patira wantingutjangka. Palulanguru Tjatjuwalu tjananya tjilirratjarra tjuṯa katingu Tjirikungka yila nyinanytjaku. Tjatjuwanya Katutjalu watjaṉu, “Tjirikunya ngurrara tjuṯa nyurrangarri yankula tjananya pikangku pungkunytjaku. Ngayulu nyurrangarrinya aalpamilalku nyurrangarri tjananya pikalu mirri pungkula wiyantjaku. Nyurrangarri mungawinki yankula parrikingka yaatjayiṯi kutjungara parra yankula ngalya yankula piyuku ngurrangka nyinanytjaku. Mungawinki tjungunyurra tuḻkuku mayutju tjapanpala yurrunpa yankunytjaku, turampatatjarra. Palulanguru ngaṉṯi tuḻkuku mayutju kutjupa tjuṯangku katinytjaku, pukutju palunya puḻi wirulypa kutjarratjarra. Palulanguru tjungu nyurrangarri tjilirratjarra yankunytjaku. Palulanguru tjiṉṯu tjikitjingka nyurrangarri kutjungara parra yankula ngalya yankulaya nyina! “Palulanguru tjiṉṯu nampa tjapanangka tjapanpalangaralpinyurra parra rawunurringkula ngarakatinytjaku. Palulanguru turampata tjapanpalatjarrangku wangkatjingala! Wangkatjingantja kulira nyurrangarri katu puntura mirra! Yalatjinyurra mirranytjala kilytjukatirra parriki palunya yuḻpurringkula ngarrimalpa. Palulangurunyurra tjilirratjarra tjuṯalulpi kaḻparra tjananya mirri pungkula wiyala!, yaṉangu yuwankarra wati, minyma, pipirri tjuṯaṯarra.” Yalatji Katutjalu Tjatjuwanya watjaṉu. ");
INSERT INTO piu2006_vpl VALUES ("JS6_6b","007_6_6b","JOS","6","6b","25","Tjatjuwalu wangka palunya kulira yaḻṯirra tjananya watjaṉu tuḻkuku mayutju tjuṯangka, “Katutjaku pukutju palunya puḻi wirulypa kutjarratjarranyurra tawunu Tjirikungka purinytju yaṉṯayaṉṯara parra katinytjaku. Tjapanpala tjanampanyurra turampatatjarra yurrunpa yankunytjaku, pukutjutjarra tjuṯaku.” Tjatjuwalu tjananya yalatji watjaṉu, tjilirratjarra tjuṯangka, “Kutjupa tjuṯanyurra tuḻkuku mayutju tjuṯangka yurrunpa yankunytjaku, kanya kutjupa tjuṯanyurra ngaṉṯiwana yankunytjaku.” Yalatjiya tawunu Tjirikungka parra yankukitja nyinangu. Parra yankulaya tuḻkuku mayutju tjuṯangku turampatatjarrangkuya mirratjingarinangi. Kutjungaraya parra yankula yarurringu ngurrakutu. Ngarrirraya pakara mungawinki yanu. Tawunu Tjirikungka kutjungara parra yankula piyuku yarurringu, tjilirratjarra tjuṯa, tuḻkuku mayutju tjuṯaṯarra. Yalatji nguwanpaya tjiṉṯu tjikitjipalangara mungawinki pakara tjunguya parra yankula ngalya yanu. Ngarrirraya mungawinki pakaṉu, Tjatjuwalu tjananya piyuku watjaṉu, tjilirratjarra tjuṯangka, “Kala, kuwarri Katutjalulpilanya aalpamilalku Tjirikunya ngurrara tjuṯa, nganaṉa tjananya pungkula wiyantjaku, kutju tjalkaḻungkunytjawiya. Kungka Rayapanyangarri ruupa tjatjakatjarra nyinanytjala nyurrangarri wiya nyakula tjananya pungkunytjaku, wanti tjananya!, walytjararranpa palya nyinanytjaku. Tjirikunya ngurrara kutjupa tjuṯaku waaḻa tjanampa nyurrangarri kilytjuntankula wiyala!, yulytjaṯarra tjanampa wiyala! Puḻi tjiilpa puḻi kuulta yayina tjuṯaṯarra mantjira ngalya katirra tjurra!, mayutju Katutjaku yulytja ngarrinytjaku. Yalatjinyurra tjuṯa mirri pungkula kilytjuntankula wiyantjaku. Walytjalunku mulyaṯangku mantjintjawiyangku wanti!, mulyaṯangku katinytjala Katutjalulanya pungkutjipingkamarra.” Tawunu Tjirikulakutuya piyuku yankula tjapanpalangara parra yankula turampatatjarrangkuya katungku mirratjingaṉu. Palulanguru tjilirratjarra tjuṯa katuya mirrangu. Mirranytjala parriki palunya puḻitjanu palyantja patangarala yuḻpurringkula ngarringi. Palulanguru waarrkana kutjarra Tjatjuwalu wantirriyaṉu, yankula tjananya mantjira ngalya katinytjaku, Rayapanyangarri. Palulanguruya tjana kaḻparra tjananya tawunuwana yankula tjuuḻa waṯawaratjarrangku wakara yiluntanangi, wati tjuṯa, kungka tjuṯa, pipirri tjuṯa, tjiḻpi tjuṯa, wulkumanu tjuṯaṯarra. Tjuṯa tjananya tjanaya wakara yiluntanu. Puluka tjuṯa, tjiipi tjuṯa, tuungkiyi tjuṯaṯarra yiluntanu tjananya. Rayapanyangarri kutjuya kanarringu, palumpa paapa, maama, kaaka tjuṯa, maḻanypa tjuṯa, tjanampa waarrkana tjuṯaṯarra. Waarrkana kutjarrangku tjananya katingu Yitjurilaku ngaṉṯitja tjuṯaku ngurrakutu. Tjilirratjarra tjuṯangku pungkula tjananya wiyaṉu, ngurraṯarra tjanampa kutjara wiyaṉu. Kala tjuṉpa kutjulpi ngarringi, kamparra tjuṉparringu. Puḻi kuulta, puḻi tjiilpa yayinaṯarra ngarringi, yurrunpaya katirra tjunutja. Tjana mantjira katirra tjaatji kalikingka tjunu. ");
INSERT INTO piu2006_vpl VALUES ("JS7_1","007_7_1","JOS","7","1","1","Panyapa Katutjalu watjaṉu, tawunu Tjirikungka wiya mulyaṯalu mantjintjaku. Wati kutjungku yulytjanguru Katutjaku ngurrkurringkula wangka palunya kulira wantingu. Wati paluru yini Yikanalu puḻi kuulta yulytjaṯarra mulyaṯangku mantjira yarrkatjunu. Palulanguru tjanampa Katutjanya ngurrku nyinangi. ");
INSERT INTO piu2006_vpl VALUES ("JS7_2","007_7_2","JOS","7","2","6","Palulanguru Tjirikunya ngurrara tjuṯa tjananya pungkula Tjatjuwalu wati maṉkurrpa wantirriyaṉu, yankula tawunu Yayiyinya parra nyakula ngalya katirra tjakultjunkunytjaku. Parra yankula nyakulinkula ngalya yankulaya yalatji tjakultjunu, “Tawunu Yayiyinya paluru wiima. Palyala tjananya yankula pungkuku. Wiyala tjuṯangku yankula pungkuku, tjawutjuna tjirripalangku kutju yankula pungkunytjaku. Tjawutjuna kutjupa tjuṯanyurra palya ngurrangka nyinanytjaku.” Kulira Tjatjuwanya wangkangu, “Yuwa, palyala yankula tjananya pungkuku, tjawutjuna tjirripalangku.” Palulanguru tjawutjuna tjirripala yanuya tawunu wiima palulakutu, pungkunytjaku. Yankulaya yilarringkula nyangu tjana pika tjanampa ngalya pakaṉu, pika pungkunytjaku. Ngalya pakara pikalu tjananya kutjupa tjuṯa mirri pungkula tjananya wantirriyaṉu, tjilirratjarra tjuṯa Tjatjuwaku walytja tjuṯa. Palulanguru tjanaya nguḻu tjalkaḻungu Tjatjuwalakutu. Tjatjuwalu tjananya nyakula mayutju kutjupa tjuṯa yaḻṯingu. Tjunguya yanu Katutjaku pukutjunguru pupakatirra tjapintjaku. Palulanguruya watjilpa puntu Katutjaku pukutjungka ngarrirraya mungarrtjirringu. ");
INSERT INTO piu2006_vpl VALUES ("JS7_7","007_7_7","JOS","7","7","15","Mungarrtjirringkula Tjatjuwalu Katutjanya puntura tjapiṉu, “Nyaaku nyuntu nganaṉanyatju ngaakutu ngalya katingu?, pikangkulanyatju ngaa ngurrarangku pungkula wantirriyantjaku? Karru Tjuutanangka parraritjayiṯi palyalatju nyinamara. Ngayuku walytja tjuṯa tjananya mirri pungutjangka, kutjupa tjuṯa tjananya pikangku nguḻura wantirriyaṉutjangka kutjupa tjuṯangku kulira ngalya yankula pungkupayingkamarralatju nguḻurringanyi. Nyuntu nganaṉanyatju palya yaṉṯayaṉṯara kanyila!, kutjupa tjuṯangku pungkula wiyalpayingkamarra.” Mayutju Katutjalu Tjatjuwala watjaṉu, “Pakalaya mantangka ngarrinytjawiya! Yitjurilaku ngaṉṯitja kutjungku ngayuku wangka kilytjuntanu, Tjirikula mulyaṯangku mantjira katingutjangka. Palulanguru tjananya nyurrangarri kuwarri puṯu pungu, Yayiyinya ngurrara tjuṯa. Kuya palyalpayi palunya mantjira warungka nyinatjunkula tilira wantirriyala!, palumpa walytja tjuṯaṯarra. Yaṉangu tjuṯa tjananya watjala!, walytjararranpa walytjararranpaya ngalya yankulantaya nyuntula ngaranytjaku. Walytjararranpa ngaranytjala, ngayuluṉanta nintilku yalatji, ‘Walytjararranpa ngaa tjuṯangka mulyaṯanytjunya kumpiṉi.’ Walytjararranpa palunya yaṉangu kutjuṯu kutjuṯuya yankulantaya ngaranytjaku nyuntula. Palulanguru mulyaṯangku mantjilpayiṉanta nintilku.” ");
INSERT INTO piu2006_vpl VALUES ("JS7_16","007_7_16","JOS","7","16","26","Mungawinki pakaraya Yitjurilaku ngaṉṯitja tjuṯa kutjungkarringkula ngarangiya, Tjatjuwala. Katutjalu nintintjala, Tjatjuwalu tjananya ngurrtjara mantjiṉu Tjuutaku ngaṉṯitja tjuṯa, walytjararranpa tjuṯalingkuya ngaranytjala. Tjatjuwalu tjananya watjaṉu, “Pamuli, pamuliya ngalya yankula ngara!, ngaangka, Katutjaluṉi nintilku.” Pamuli an pamuli ngalya yankula ngarala yanu. Palulanguru Tjiraku pamuli tjuṯalpi ngalya yankula ngarangitjangka, Katutjalu Tjatjuwanya nintiṉu. Tjatjuwalu tjananya watjaṉu, “Ngalya yankulaya yaṉangu kutjuṯu kutjuṯu ngara!, ngayula yila.” Yaṉangu kutjuṯu kutjuṯu ngalya yankula ngarala yanu. Palulanguru Yikananya ngalya yankula ngarangi. Palunya Katutjalu nintintjala Tjatjuwalu watjaṉu, “Nyawaṉi! Watjalaṉi tjukarurru! Nyuntu mantjiṉu? Nyuntu nyaalytjinu Tjirikula?” Yikanalu Tjatjuwalara watjaṉu, “Yiltaṉa mulyaṯalu mantjira Katutjanya yuḻpaṯanu. Palumpa wangkaṉa kulira kilytjuntanu. Tjirikula puḻi kuulta tjiilpaṯarralatju mantjira rawangkulatju katirra tjunkula wantingu, mayutju Katutjaku, ngulaku. Yulytja palunya tjuṯawanangka ngayulu nyangu yulytja palya ngarrinytjala. Palulanguru tjanala ngaṉṯi ngayulu mulyaṯangku mantjiṉu, kuuta, puḻi kuulta tiṉa, puḻi tjiilpaṯarra. Katirraṉa yarrkatjunu ngulaku. Ngayuku kalikingka ngarrinyi mantangka yunngutjayiṯi, tjawara tjutura wantingutjangka.” Palulanguru Tjatjuwalu tjananya wati maṉkurrpa iyaṉu, yankula tjawara mantjira ngalya katinytjaku. Mantjiraya katirra tjunu, yaṉangu tjuṯangka mirangka. Palulanguru Tjatjuwalu Yikananya witira watjaṉu walytja palumpa tjuṯaṯarra witira katinytjaku yurilkutu, palumpa miiṯa, palumpa katja tjuṯa, yuṉṯalpa tjuṯaṯarra. Kutjupa tjuṯa tjananya watjaṉu, “Puḻi kuulta, puḻi tjiilpa panyapa tjuṯaṯarraya mantjira ngalya kati, yurilkutu! Palulanguru palumpa kaliki, yulytja tjuṯa, puluka tjuṯa, tjiipi tjuṯa, tuungkiyi tjuṯa mantjiraya katirra yurilpangka ngaratjunkulaya paṯala!” Yankulaya yurilpanguru ngaralaya yilangku nyangangi, Tjatjuwalu Yikananya yalatji watjantjala, “Nyaakun nyuntu mulyaṯangku ramarringkula mantjiṉu? Nyuntu mulyaṯalu mantjiṉutjangka wiyalanya Katutjalu yaṉṯayaṉṯaṉu, wantingulanya palunya tjuṯangku pungkunytjaku. Kalalpi nyurrangarri turapulatjarra ngaangkalpiya ngara!, puḻitjarrangku nyurrangarrinya nganaṉatju rungkara yiluntankuku, nyurrangarrinya.” Palulanguru yaṉangu tjuṯangku tjananya rungkaralpi tjananya yiluntankula warungkalpi tjananya kutjara wiyaṉu, tjiipi tjuṯa, puluka tjuṯa, puḻi kuulta tjiilpaṯarra. Yuwankarra kamparra wiyaṉu. Palulanguru tjuṉpa kutjulpi ngarringi. Palula ngaṉṯi kamparra wiyaṉutjangka Katutjanya ngurrkuwiyalpi nyinangi. Palulanguruya watjalpayi, ngurra palatja, “Turaapulatjarranya.” ");
INSERT INTO piu2006_vpl VALUES ("JS8_1","007_8_1","JOS","8","1","29","Mayutju Katutjalu Tjatjuwanya yalatji watjaṉu, “Tjilirratjarra tjuṯa tjananya katirra tawunu Yayiyila pungkunytjaku. Wiya tjanampanyurra nguḻurringkunytjaku, ngayuluṉa nyurranya aalpamilalku panyapa tjuṯanyurra pungkula yiluntara wiyantjaku. Panyapa tjuṯa tjananya pungkula tjungu yiluntarra! Puluka tjuṯa, tjiipi tjuṯa, palyangkuya kanyila!, yulytja tjuṯaṯarra tjungura kanyila! Tawunu Yayiyila wilurarra kumpira tjananya ngalya yankulaya puwa!” Palulanguru Tjatjuwalu tjilirratjarra tjuṯa wantirriyaṉu, kumpilpa yankula tawunu Yayiyila wilurarra kumpira nyinanytjaku. Palulanguru Tjatjuwanyangarriya tjilirratjarra kutjupa tjuṯa Yayiyilakutu yalinytjarranguru yuti maa yanu. Yayiyinya ngurrara tjuṯangku tjananya nyakula yirriṯi nguwanpa tawununguru pakara ngalya yanu, Tjatjuwanyangarri pungkula wantirriyalkitja. Ngalya yananyingka Tjatjuwanyangarriya maḻaku yalinytjarra nguḻu nguwanpaya tjalkaḻungu. Yayiyinya ngurraralu tjananya wanaṉu, pungkukitjangku. Palulanguru Tjatjuwanyangarriya ngarakatingu, kutjupa tjuṯa nintiṉu, pakantjaku. Ngurra Yayiyila wilurarra kumpira nyinangutja tjuṯangkuya pakara tawunu Yayiyila kiiṯangka tjarrparra wakara tjananya yiluntanu, yuṯu nyinangutja tjuṯa, maḻpa tjanampa tjilirratjarra nyinanytjawiyangka. Mirri pungkula waaḻa tjuṯa tilira wantingu. Palulanguru Yayiyinya ngurrara tjuṯalu tjilirratjarralu nguṉṯilangarala nyangu ngurra kampanyingka. Nyakulaya puṯu kuliṉu, palulanguruya nguḻurringu. Palunyatjanu Yitjurilaku ngaṉṯitja tjuṯangku wilurarranguru yalinytjarranguru ngururrtjunkula mirri pungkula wiyaṉu tjananya. Yayiyinya ngurrara mayutju Tjatjuwalungarriya witira ruupangka nguṉṯiwana tayimapiṉu, watiyangka katura yuṯitjunkula yiluntanu. Yalatji Yayiyinya ngurrara tjuṯa yiluntara wiyaṉu, Tjatjuwalungarri. ");
INSERT INTO piu2006_vpl VALUES ("JS9_1","007_9_1","JOS","9","1","27","Tjatjuwalungarri tjilirratjarra tjuṯangku Tjirikunya ngurrara tjuṯa, Yayiyinya ngurrara tjuṯa mirri pungkula wiyaṉutjangka, paṉa Kayinananya ngurrara tjuṯangkuya kulira nguḻurringu. Kipiyananya ngurrara tjuṯa paṉa Kayinanangka nyinapayingku kulira Kipiyananya ngurrara maṉkurrpa Tjatjuwalakutu iyaṉu. Tjatjuwakungarri ngurrangka yila Kipiyanya ngurrara tjuṯa nyinapayi. Yankukitjangkuya wati maṉkurrpa paluru tjana mangarri puriiti rawa ngarrirra yuṉarringutja mantjira parilykangka tjarrpatjunu. Parilyka paluru yaḻatjarra yutunypangku ngalkuṉutja. Mantjiraya tuungkiyingka kaḻpatjunu. Pangki yirriṯitja tjuṯangkaya kapi yintira kaḻpatjunu. Tjaaṯa yirriṯitjangkaya tjarrparra tuungkiyi tjuṯangkaya kaḻpakatirra yanu Tjatjuwanyangarri ngunytjinytjunkukitja. Tuungkiyitjarraya Kipiyanya ngurrara tjuṯa Yitjurilaku ngaṉṯitja tjuṯaku ngurrakutuya yanu, ngurra Kilkalalakutu. Tuungkiyi tjuṯaya katirra ngaratjunkula Tjatjuwalangarri, mayutju tjuṯangka yalatji wangkangu, “Nganaṉatju nyurrangarrimpa waarrkana ngaranyi.” Tjatjuwalungarriya tjapiṉu, “Ngurra yaalytjingurunyurra ngalya yanu?” Paluru maṉkurrpangku tjananya ngunytjinytjunu, “Waṉmangurulatju ngalya yanu. Paṉa walytjangka waṉma nyinarralatju nganampa mayutju tjuṯangku yirriṯi kuliṉu, nyurrangarrimpa paapa tjuṯa maama tjuṯa paṉa Yitjipila nyinapayi. Palulanguru tjana kuliṉu Katutjalu tjananya yaṉṯayaṉṯalpayi. Yalatjilatju kuliṉu karru Tjuutanangka kakarrara ngurrara tjuṯa tjananya nyurrangarri mirri pungkula wiyaṉu. Yalatjilatju kulira nguḻurringu. Palunyatjanu mayutju tjuṯangkulanyatju iyaṉu, nyurrangarrila tjakultjunkunytjaku, ‘Nyurrangarrimpa waarrkana tjuṯalatju nyinaku, nganampatju walytja tjuṯaṯawarra. Pungkuwiyangkulanyatju wanti!, waṉma ngurrara tjuṯa.’ Nganaṉanyatju ngalyanu nyurrangarrila wangkanytjaku. Yaalytjinyurra kuliṉi?, nganaṉanyatju pungkuwiyangku wantinytjaku? Yilta waṉmalatju nyinapayi. Nyawaya!, mangarri ngaatja rawa ngarrirra yuṉarringu. Yirriṯilatju warungka kutjara mantjira tjarrpatjunu. Rawangkulatju ngalya ngalkura yuṉaṉu. Pangki ngaa tjuṯalatju nyuwana waralytjunu, ngalya yankukitjalu. Nganampatju tjaaṯaya nyawa!, waṉmatjanu yaḻarringu.” Yalatji tjananya tuungkiyitjarrangku ngunytjinytjunu, yila ngurrara maṉkurrpangku. Yara panyapa yilta kulira Tjatjuwalungarri tjananya parrpaṯu watjaṉu pungkuwiyangku wantikitjangku. Katutjanya yurruntu tjapilwiyangku ngulytju nyinakitjangku Tjatjuwalungarri watjaṉu, “Katutjalu nyanganyingka tjukarurrulatju nyurrangarrila watjaṉi wantinytjaku pungkuwiyangku.” Palunyatjanu Kipiyanya ngurrara maṉkurrpa kaḻparra maḻaku yanu. Tjiṉṯu maṉkurrparrirra Tjatjuwalungarri kuliṉu panyapa tjuṯangku ngunytjinytjunutjangka, yila ngurrara tjuṯangku. Palunyatjanu Tjatjuwanyangarri tjilirratjarra tjuṯa tjiṉṯu maṉkurrpa yankula tawunu Kipiyala tjarrpangu. Tawunu tjuṯa kutjupa tjanampa yila ngarangi. Yitjurilaku ngaṉṯitja tjuṯa tjilirratjarrangku wiya tjananya pungu, yurrunpa watjaṉutja. Tjatjuwalu tjananya Kipiyanya ngurrara tjuṯa yaḻṯirra ngaratjunkula tjapiṉu, “Nyaangurulanyatju nyurrangarri ngunytjinytjunu? Waṉma wiyanyurra nyinanyi, yilanyurra nyinanyi. Nyurrangarri ngunytjinytjunutjangka waarrkanalampatju nyurrangarri waarrkarrimalpa. Kutjupa tjuṯangkunyurra waru yatura Katutjaku tjaatji kalikikutu katimalpa. Kutjupa tjuṯangkunyurra yulytja tjuṯa katimalpa tjaatji kaliki panyapakutu. Kutjupa tjuṯangkunyurra kapi mantjira katimalpa, tjaatji kaliki panyapakutu.” ");
INSERT INTO piu2006_vpl VALUES ("JS10_1","007_10_1","JOS","10","1","43","(10:, 11:) Tawunu Tjarutjalumanya ngurrara mayutjulu tjakulpa kuliṉu, Tjatjuwalungarri tjananya Tjirikunya ngurrara tjuṯa, Yayiyinya ngurrara tjuṯa mirri pungutjangka, Kipiyanya ngurrara tjuṯa tjanampa walytjarringutjangka. Mayutju paluru tjananya tawunu kutjupa ngurrara mayutju tiṉa tjuṯanya yaḻṯingu, tjungurringkula wangkanytjaku. Yalatjiya tawunu tjuṯanguru mayutju tiṉa tjuṯa tjungurringu. Wangkanguya Tjatjuwanyangarri mirri pungkukitjangku. Palunyatjanuya maḻaku yanu yaḻṯirra tjilirratjarra tjuṯa ngalya katinytjaku. Palulanguru tawunu tjuṯanguru tjilirratjarra tjuṯa ngalya yankula tjungurringu, tawunu Yipurananya ngurrara, tawunu Tjamutjanya ngurrara, tawunu Likitjanya ngurrara, tawunu Yikulunanya ngurrara. Tjungurringkulaya yanu tawunu Kipiyalakutu, palunya ngurrara tjuṯa tjananya pungkunytjaku. Tawunu paluru parriki tiṉangka ngururrpa ngarangi, puḻitjanu palyara ngaratjunutja. Tawunu palunyaya ngururrtjunkulaya ngarangi. Palunyatjanu tawunu Kipiyanya ngurrara mayutjungku wati maṉkurrpa wantirriyaṉu Tjatjuwanyangarri yaḻṯinytjaku, panyapa tjuṯa tjananya pikangku pungkunytjaku. Palulanguru Tjatjuwanyangarri ngalya yankula tjananya mirri pungkula nguḻutjingara wantirriyaṉu. Tjilirratjarra tjuṯaya nguḻu tjalkaḻungu. Katutjalu tjananya kapi ayitjitjarralu yaṉangu tjuṯa mirri pungkula wiyaṉu. Tjatjuwaku tjilirratjarra tjuṯangku tjananya wanara mirri pungkula wiyantjaku, Tjatjuwalu Katutjanya marrkuṉu tjiṉṯu tjarrpawiya ngaranytjaku, piraṯarra tjarrpawiya ngaranytjaku. Palunyatjanu tjiṉṯu rawa ngarangu tjarrpanytjawiya. Yalatji tjanampa Katutjalu tjiṉṯu marrkura ngaratjunu. Tjiṉṯu ngaranyingka Tjatjuwalungarri tjananya mirri pungkula wiyaṉu. Mayutju tawunu payipala palunya ngurrara tjuṯaya kuḻpingka kumpiṉingi. Tjatjuwalungarri tjananya ngurrira witiṉu. Witira tjananyaya wakara iluntanu. Ruupangka tjananya yunytjuwana tayimapira waralytjunu watiyangka. Tjiṉṯu tjarrpanytjala tjana yirriwiltjira tjananya kuḻpi palula waṉingu. Palulanguru Tjatjuwanyangarriya tjilirratjarra tjuṯa tawunu Makitalakutu yankula mirri tjananya pungkula wiyaṉu. Palulanguru tawunu Lipinalakutu yankula kutjupa tjuṯa tjananya mirri pungu. Palulanguruya piyuku tawunu Likitjalakutu yankulaya mirri kutjupa tjuṯanya pungkula wiyaṉu. Ngurra palulakutuya kutjupa tjuṯa Kitiyanya ngurrara tjuṯa ngalya yankula yurrunpa tjungurringu. Palunya tjuṯaṯarra tjananya Tjatjuwalungarri pungkula yiluntanu. Palulanguru tawunu Yikulunalakutu yankulaya pungkula kutjupa tjuṯanya wiyaṉu. Palulanguru tawunu Yipurunalakutuya yankula pungkula tjananya wiyaṉu. Palulanguru piyukuya yanu tawunu Tipirrpalakutu palulanguru tjananya kutjupa tjuṯa pungkula wiyaṉu. Paṉa palunya ngurrara tjuṯaṯarra tjananya Tjatjuwalungarri mirri pungkula wiyaṉu, puḻi katu nyinapayi tjuṯanyaṯarra, Katutjalu tjananya watjaṉutjangka. Yalatji tjananya pungkula wiyaṉu, palulanguruya yanu ngurra Kilkalala nyinakitja. Ngurra palulaya yirriṯi rawa nyinapayi. Yalinytjarra ngurra tjuṯangkuya tjakulpa kulira nguḻurringu, Tjatjuwalungarri mirri pungkula wiyaṉutjangka. Tawunu Yitjuraku mayutjungku tjananya tawunu kutjupa kutjupa ngurrara tjuṯa yaḻṯirra tjungura wangkangu, Tjatjuwanyangarri mirri pungkula wiyantjaku. Palunya ngurrara tjuṯaṯarraya tjilirratjarra tjungurringu, naanytjatjarra paakitjarraṯarra, ngurra yini Mirimpurukala. Palulanguru mayutju Katutjalu Tjatjuwanya wangkangu, “Nguḻurriwiyangku tjananya mirri pungkula wiyala!, mungarrtjirrinytjala tjana mirri ngarrimalpa. Ngayuluṉa nyurranya Katutjalu aalpamilalku yankula tjananyanyurra mirri pungkunytjaku. Nyurrangarri palumpa tjanampaṯarra naanytja tarrka kilytjuntara wiyala! Paaki tjuṯaṯarra kutjara wiyala!” Yalinytjarra ngurrara Mirimpurukalaya kulilwiya nyinangi, Tjatjuwalungarriya kumpilpa yankula tjananya mirri pungkula wiyaṉu. Naanytja tjuṯaṯarra tarrka kilytjuntara wiyaṉu. Paaki tjuṯanyaṯarra kutjara wiyaṉu. Palulanguru tawunu palunya ngurrara tjuṯaṯarra tjananya pungkula wiyaṉu. Yalatji tjananya Katutjalu yurrunpa wangkangu mirri pungkula wiyantjaku. Palunya ngurrara tjuṯaku tjanampa puluka, tjiipi, yulytja tjuṯa mantjira kanyiṉingi. ");
INSERT INTO piu2006_vpl VALUES ("JS11_1","007_11_1","JOS","11","1","23","(10:, 11:) Tawunu Tjarutjalumanya ngurrara mayutjulu tjakulpa kuliṉu, Tjatjuwalungarri tjananya Tjirikunya ngurrara tjuṯa, Yayiyinya ngurrara tjuṯa mirri pungutjangka, Kipiyanya ngurrara tjuṯa tjanampa walytjarringutjangka. Mayutju paluru tjananya tawunu kutjupa ngurrara mayutju tiṉa tjuṯanya yaḻṯingu, tjungurringkula wangkanytjaku. Yalatjiya tawunu tjuṯanguru mayutju tiṉa tjuṯa tjungurringu. Wangkanguya Tjatjuwanyangarri mirri pungkukitjangku. Palunyatjanuya maḻaku yanu yaḻṯirra tjilirratjarra tjuṯa ngalya katinytjaku. Palulanguru tawunu tjuṯanguru tjilirratjarra tjuṯa ngalya yankula tjungurringu, tawunu Yipurananya ngurrara, tawunu Tjamutjanya ngurrara, tawunu Likitjanya ngurrara, tawunu Yikulunanya ngurrara. Tjungurringkulaya yanu tawunu Kipiyalakutu, palunya ngurrara tjuṯa tjananya pungkunytjaku. Tawunu paluru parriki tiṉangka ngururrpa ngarangi, puḻitjanu palyara ngaratjunutja. Tawunu palunyaya ngururrtjunkulaya ngarangi. Palunyatjanu tawunu Kipiyanya ngurrara mayutjungku wati maṉkurrpa wantirriyaṉu Tjatjuwanyangarri yaḻṯinytjaku, panyapa tjuṯa tjananya pikangku pungkunytjaku. Palulanguru Tjatjuwanyangarri ngalya yankula tjananya mirri pungkula nguḻutjingara wantirriyaṉu. Tjilirratjarra tjuṯaya nguḻu tjalkaḻungu. Katutjalu tjananya kapi ayitjitjarralu yaṉangu tjuṯa mirri pungkula wiyaṉu. Tjatjuwaku tjilirratjarra tjuṯangku tjananya wanara mirri pungkula wiyantjaku, Tjatjuwalu Katutjanya marrkuṉu tjiṉṯu tjarrpawiya ngaranytjaku, piraṯarra tjarrpawiya ngaranytjaku. Palunyatjanu tjiṉṯu rawa ngarangu tjarrpanytjawiya. Yalatji tjanampa Katutjalu tjiṉṯu marrkura ngaratjunu. Tjiṉṯu ngaranyingka Tjatjuwalungarri tjananya mirri pungkula wiyaṉu. Mayutju tawunu payipala palunya ngurrara tjuṯaya kuḻpingka kumpiṉingi. Tjatjuwalungarri tjananya ngurrira witiṉu. Witira tjananyaya wakara iluntanu. Ruupangka tjananya yunytjuwana tayimapira waralytjunu watiyangka. Tjiṉṯu tjarrpanytjala tjana yirriwiltjira tjananya kuḻpi palula waṉingu. Palulanguru Tjatjuwanyangarriya tjilirratjarra tjuṯa tawunu Makitalakutu yankula mirri tjananya pungkula wiyaṉu. Palulanguru tawunu Lipinalakutu yankula kutjupa tjuṯa tjananya mirri pungu. Palulanguruya piyuku tawunu Likitjalakutu yankulaya mirri kutjupa tjuṯanya pungkula wiyaṉu. Ngurra palulakutuya kutjupa tjuṯa Kitiyanya ngurrara tjuṯa ngalya yankula yurrunpa tjungurringu. Palunya tjuṯaṯarra tjananya Tjatjuwalungarri pungkula yiluntanu. Palulanguru tawunu Yikulunalakutu yankulaya pungkula kutjupa tjuṯanya wiyaṉu. Palulanguru tawunu Yipurunalakutuya yankula pungkula tjananya wiyaṉu. Palulanguru piyukuya yanu tawunu Tipirrpalakutu palulanguru tjananya kutjupa tjuṯa pungkula wiyaṉu. Paṉa palunya ngurrara tjuṯaṯarra tjananya Tjatjuwalungarri mirri pungkula wiyaṉu, puḻi katu nyinapayi tjuṯanyaṯarra, Katutjalu tjananya watjaṉutjangka. Yalatji tjananya pungkula wiyaṉu, palulanguruya yanu ngurra Kilkalala nyinakitja. Ngurra palulaya yirriṯi rawa nyinapayi. Yalinytjarra ngurra tjuṯangkuya tjakulpa kulira nguḻurringu, Tjatjuwalungarri mirri pungkula wiyaṉutjangka. Tawunu Yitjuraku mayutjungku tjananya tawunu kutjupa kutjupa ngurrara tjuṯa yaḻṯirra tjungura wangkangu, Tjatjuwanyangarri mirri pungkula wiyantjaku. Palunya ngurrara tjuṯaṯarraya tjilirratjarra tjungurringu, naanytjatjarra paakitjarraṯarra, ngurra yini Mirimpurukala. Palulanguru mayutju Katutjalu Tjatjuwanya wangkangu, “Nguḻurriwiyangku tjananya mirri pungkula wiyala!, mungarrtjirrinytjala tjana mirri ngarrimalpa. Ngayuluṉa nyurranya Katutjalu aalpamilalku yankula tjananyanyurra mirri pungkunytjaku. Nyurrangarri palumpa tjanampaṯarra naanytja tarrka kilytjuntara wiyala! Paaki tjuṯaṯarra kutjara wiyala!” Yalinytjarra ngurrara Mirimpurukalaya kulilwiya nyinangi, Tjatjuwalungarriya kumpilpa yankula tjananya mirri pungkula wiyaṉu. Naanytja tjuṯaṯarra tarrka kilytjuntara wiyaṉu. Paaki tjuṯanyaṯarra kutjara wiyaṉu. Palulanguru tawunu palunya ngurrara tjuṯaṯarra tjananya pungkula wiyaṉu. Yalatji tjananya Katutjalu yurrunpa wangkangu mirri pungkula wiyantjaku. Palunya ngurrara tjuṯaku tjanampa puluka, tjiipi, yulytja tjuṯa mantjira kanyiṉingi. ");
INSERT INTO piu2006_vpl VALUES ("JS13_1","007_13_1","JOS","13","1","33","(13:1—19:51; 21:1-45) Tjatjuwalu tjananya tjilirratjarra tjuṯanya katiyankula rawangku, palulanguru paluru nyinarra tjiḻpirringu. Palulanguru mayutju Katutjalu Tjatjuwanya wangkangu, “Nyuntu rawangku tjananyan, pungkula tjiḻpirringu, waarrka kutjupalpiṉanta palyantjaku wangkanyi. Nyuntu tjananya wangka!, yankulaya maakamilantjaku, yaaṯa nguwanpa tiṉa tjuṯa ngaranytjaku. Kutjupa tjuṯaya yaaṯa tiṉa kutjungka nyinanytjaku, kutjupa tjuṯaya yaaṯa tiṉa kutjupangka nyinanytjaku. Yalatjiya yuwankarra yaaṯa tiṉa tjuṯangka nyinaku. “Yitjurilaku ngaṉṯitja tjuṯangku tjilirratjarra tjuṯangku ngula tjananya yankula mirri puwa!, Pilitjiyanya ngurrara tjuṯa, ngurra tjanampaṉungka nyinakitjangku. Ngurra palula yulparirra nyinapayi tjuṯanya tjana pungkula tjananya wiyala!, ngurra Yitjipila kalkuṉi nyinapayi tjuṯanyaṯarra. Kapi Kaliliyila yalinytjarra nyinapayi tjuṯanyaṯarra tjananya pungkula wiyala!, ngurra tjulyalkitjangku. Ngurra palulakutunyurra tjungu yanku ngurra tjanampa tjulyalkitja. Ngurra palulakutunyurra yankunytjala, ngayuluṉa tjananya nguḻutjingara wantirriyalku.” Tjatjuwalu tjananya piyuku wangkangu, “Ngayulu nyurrangarrinya watjaṉingka yankulanyurra parriki nguwanpa maakamilantjaku. Ngulytjurarranpa kutjuya ngurra walytjangka nyinanytjaku. Ngulytjurarranpa kutjupa ngurra kutjupangka nyinanytjaku. Yalatjiya ngulytjurarranpa tuwalpala ngurra walytjangka nyinanytjaku.” Tjatjuwalu tjananya wangkangu ngurra kutjupa kutjupangka yankula nyinanytjaku. Yalatjiya paṉa Kayinanalawana nyinapayi Yitjurilaku ngaṉṯitja tjuṯa, ngurra kutjupa tjuṯawana. Ngurra tawunu Tjirikulawana, tawunu Kipiyalawana Pintjiminakuṉu ngaṉṯitja tjuṯa nyinapayi. Ngurra palula wilurarra Taanaku ngaṉṯitja tjuṯaya nyinangi. Palulanguru paluru tjana kapi Kaliliyila yalinytjarralpi yankula nyinangi. Pintjiminaku ngaṉṯitja tjuṯaku ngurrangka yulparirra Tjuutaku ngaṉṯitja tjuṯaya nyinapayi, tawunu Yipurunalawana. Tjiḻpi Kiilipanya tawunu palula rawa nyinanytjaku Tjatjuwalu watjaṉu. Ngurra palula yulparirra Tjimiyanaku ngaṉṯitja tjuṯaya nyinangi. Pintjiminaku ngaṉṯitja tjuṯaku ngurrangka kakarraraya Ruupinaku ngaṉṯitja tjuṯa nyinangi, karru Tjuutanala kakarrara. Ngurra palula yalinytjarra Kaataku ngaṉṯitja tjuṯaya nyinangi, karru Tjuutanala kakarrara. Ngurra palula yalinytjarra kapi Kaliliyila kakarrara Manatjaku ngaṉṯitja tjuṯaya nyinangi. Pintjiminaku ngaṉṯitja tjuṯaku ngurrangka yalinytjarra Yipurimaku ngaṉṯitja tjuṯa nyinangi. Ngurra palula yalinytjarra Manatjaku ngaṉṯitja tjuṯaku ngurra kutjupa ngarangi. Ngurra palula yalinytjarra Yitjikaku ngaṉṯitja tjuṯa nyinangi. Ngurra palula yalinytjarra Tjipulanaku ngaṉṯitja tjuṯaya nyinangi. Ngurra palula yalinytjarra Naputaliku ngaṉṯitja tjuṯaya nyinangi. Ngurra palula wilurarra Yaatjaku ngaṉṯitja tjuṯaya nyinangi. Mayutju kutjupa tjuṯangku wangkangu Tjatjuwalu tawunu Timintjiranya walytjalu kanyintjaku, Katutjalu watjaṉutjangka. Tawunu palunya ngarangi Yipuramaku ngaṉṯitja tjuṯaku ngurrangka. Lipayiku ngaṉṯitja tjuṯaku tawunu tjuṯa tjana watjaṉu ngurrangka nyinanytjaku. Wiya tjanampa paṉa tiṉangka nyinanytjaku watjaṉu, ngurra tiṉa tjana wiya kanyiṉu. Tawunu tjuṯa kutju tjana kanyintjaku mayutju tjuṯangku watjaṉu. Katutjalu yurrunpa yalatji watjaṉu, “Lipayiku ngaṉṯitja tjuṯangku waarrka palyara tjaatji kalikingka mangarri kuka mantjintjaku, wiyaya kaanangka waarrkarrira mangarri kuka mantjintjaku.” ");
INSERT INTO piu2006_vpl VALUES ("JS14_1","007_14_1","JOS","14","1","15","(13:1—19:51; 21:1-45) Tjatjuwalu tjananya tjilirratjarra tjuṯanya katiyankula rawangku, palulanguru paluru nyinarra tjiḻpirringu. Palulanguru mayutju Katutjalu Tjatjuwanya wangkangu, “Nyuntu rawangku tjananyan, pungkula tjiḻpirringu, waarrka kutjupalpiṉanta palyantjaku wangkanyi. Nyuntu tjananya wangka!, yankulaya maakamilantjaku, yaaṯa nguwanpa tiṉa tjuṯa ngaranytjaku. Kutjupa tjuṯaya yaaṯa tiṉa kutjungka nyinanytjaku, kutjupa tjuṯaya yaaṯa tiṉa kutjupangka nyinanytjaku. Yalatjiya yuwankarra yaaṯa tiṉa tjuṯangka nyinaku. “Yitjurilaku ngaṉṯitja tjuṯangku tjilirratjarra tjuṯangku ngula tjananya yankula mirri puwa!, Pilitjiyanya ngurrara tjuṯa, ngurra tjanampaṉungka nyinakitjangku. Ngurra palula yulparirra nyinapayi tjuṯanya tjana pungkula tjananya wiyala!, ngurra Yitjipila kalkuṉi nyinapayi tjuṯanyaṯarra. Kapi Kaliliyila yalinytjarra nyinapayi tjuṯanyaṯarra tjananya pungkula wiyala!, ngurra tjulyalkitjangku. Ngurra palulakutunyurra tjungu yanku ngurra tjanampa tjulyalkitja. Ngurra palulakutunyurra yankunytjala, ngayuluṉa tjananya nguḻutjingara wantirriyalku.” Tjatjuwalu tjananya piyuku wangkangu, “Ngayulu nyurrangarrinya watjaṉingka yankulanyurra parriki nguwanpa maakamilantjaku. Ngulytjurarranpa kutjuya ngurra walytjangka nyinanytjaku. Ngulytjurarranpa kutjupa ngurra kutjupangka nyinanytjaku. Yalatjiya ngulytjurarranpa tuwalpala ngurra walytjangka nyinanytjaku.” Tjatjuwalu tjananya wangkangu ngurra kutjupa kutjupangka yankula nyinanytjaku. Yalatjiya paṉa Kayinanalawana nyinapayi Yitjurilaku ngaṉṯitja tjuṯa, ngurra kutjupa tjuṯawana. Ngurra tawunu Tjirikulawana, tawunu Kipiyalawana Pintjiminakuṉu ngaṉṯitja tjuṯa nyinapayi. Ngurra palula wilurarra Taanaku ngaṉṯitja tjuṯaya nyinangi. Palulanguru paluru tjana kapi Kaliliyila yalinytjarralpi yankula nyinangi. Pintjiminaku ngaṉṯitja tjuṯaku ngurrangka yulparirra Tjuutaku ngaṉṯitja tjuṯaya nyinapayi, tawunu Yipurunalawana. Tjiḻpi Kiilipanya tawunu palula rawa nyinanytjaku Tjatjuwalu watjaṉu. Ngurra palula yulparirra Tjimiyanaku ngaṉṯitja tjuṯaya nyinangi. Pintjiminaku ngaṉṯitja tjuṯaku ngurrangka kakarraraya Ruupinaku ngaṉṯitja tjuṯa nyinangi, karru Tjuutanala kakarrara. Ngurra palula yalinytjarra Kaataku ngaṉṯitja tjuṯaya nyinangi, karru Tjuutanala kakarrara. Ngurra palula yalinytjarra kapi Kaliliyila kakarrara Manatjaku ngaṉṯitja tjuṯaya nyinangi. Pintjiminaku ngaṉṯitja tjuṯaku ngurrangka yalinytjarra Yipurimaku ngaṉṯitja tjuṯa nyinangi. Ngurra palula yalinytjarra Manatjaku ngaṉṯitja tjuṯaku ngurra kutjupa ngarangi. Ngurra palula yalinytjarra Yitjikaku ngaṉṯitja tjuṯa nyinangi. Ngurra palula yalinytjarra Tjipulanaku ngaṉṯitja tjuṯaya nyinangi. Ngurra palula yalinytjarra Naputaliku ngaṉṯitja tjuṯaya nyinangi. Ngurra palula wilurarra Yaatjaku ngaṉṯitja tjuṯaya nyinangi. Mayutju kutjupa tjuṯangku wangkangu Tjatjuwalu tawunu Timintjiranya walytjalu kanyintjaku, Katutjalu watjaṉutjangka. Tawunu palunya ngarangi Yipuramaku ngaṉṯitja tjuṯaku ngurrangka. Lipayiku ngaṉṯitja tjuṯaku tawunu tjuṯa tjana watjaṉu ngurrangka nyinanytjaku. Wiya tjanampa paṉa tiṉangka nyinanytjaku watjaṉu, ngurra tiṉa tjana wiya kanyiṉu. Tawunu tjuṯa kutju tjana kanyintjaku mayutju tjuṯangku watjaṉu. Katutjalu yurrunpa yalatji watjaṉu, “Lipayiku ngaṉṯitja tjuṯangku waarrka palyara tjaatji kalikingka mangarri kuka mantjintjaku, wiyaya kaanangka waarrkarrira mangarri kuka mantjintjaku.” ");
INSERT INTO piu2006_vpl VALUES ("JS15_1","007_15_1","JOS","15","1","63","(13:1—19:51; 21:1-45) Tjatjuwalu tjananya tjilirratjarra tjuṯanya katiyankula rawangku, palulanguru paluru nyinarra tjiḻpirringu. Palulanguru mayutju Katutjalu Tjatjuwanya wangkangu, “Nyuntu rawangku tjananyan, pungkula tjiḻpirringu, waarrka kutjupalpiṉanta palyantjaku wangkanyi. Nyuntu tjananya wangka!, yankulaya maakamilantjaku, yaaṯa nguwanpa tiṉa tjuṯa ngaranytjaku. Kutjupa tjuṯaya yaaṯa tiṉa kutjungka nyinanytjaku, kutjupa tjuṯaya yaaṯa tiṉa kutjupangka nyinanytjaku. Yalatjiya yuwankarra yaaṯa tiṉa tjuṯangka nyinaku. “Yitjurilaku ngaṉṯitja tjuṯangku tjilirratjarra tjuṯangku ngula tjananya yankula mirri puwa!, Pilitjiyanya ngurrara tjuṯa, ngurra tjanampaṉungka nyinakitjangku. Ngurra palula yulparirra nyinapayi tjuṯanya tjana pungkula tjananya wiyala!, ngurra Yitjipila kalkuṉi nyinapayi tjuṯanyaṯarra. Kapi Kaliliyila yalinytjarra nyinapayi tjuṯanyaṯarra tjananya pungkula wiyala!, ngurra tjulyalkitjangku. Ngurra palulakutunyurra tjungu yanku ngurra tjanampa tjulyalkitja. Ngurra palulakutunyurra yankunytjala, ngayuluṉa tjananya nguḻutjingara wantirriyalku.” Tjatjuwalu tjananya piyuku wangkangu, “Ngayulu nyurrangarrinya watjaṉingka yankulanyurra parriki nguwanpa maakamilantjaku. Ngulytjurarranpa kutjuya ngurra walytjangka nyinanytjaku. Ngulytjurarranpa kutjupa ngurra kutjupangka nyinanytjaku. Yalatjiya ngulytjurarranpa tuwalpala ngurra walytjangka nyinanytjaku.” Tjatjuwalu tjananya wangkangu ngurra kutjupa kutjupangka yankula nyinanytjaku. Yalatjiya paṉa Kayinanalawana nyinapayi Yitjurilaku ngaṉṯitja tjuṯa, ngurra kutjupa tjuṯawana. Ngurra tawunu Tjirikulawana, tawunu Kipiyalawana Pintjiminakuṉu ngaṉṯitja tjuṯa nyinapayi. Ngurra palula wilurarra Taanaku ngaṉṯitja tjuṯaya nyinangi. Palulanguru paluru tjana kapi Kaliliyila yalinytjarralpi yankula nyinangi. Pintjiminaku ngaṉṯitja tjuṯaku ngurrangka yulparirra Tjuutaku ngaṉṯitja tjuṯaya nyinapayi, tawunu Yipurunalawana. Tjiḻpi Kiilipanya tawunu palula rawa nyinanytjaku Tjatjuwalu watjaṉu. Ngurra palula yulparirra Tjimiyanaku ngaṉṯitja tjuṯaya nyinangi. Pintjiminaku ngaṉṯitja tjuṯaku ngurrangka kakarraraya Ruupinaku ngaṉṯitja tjuṯa nyinangi, karru Tjuutanala kakarrara. Ngurra palula yalinytjarra Kaataku ngaṉṯitja tjuṯaya nyinangi, karru Tjuutanala kakarrara. Ngurra palula yalinytjarra kapi Kaliliyila kakarrara Manatjaku ngaṉṯitja tjuṯaya nyinangi. Pintjiminaku ngaṉṯitja tjuṯaku ngurrangka yalinytjarra Yipurimaku ngaṉṯitja tjuṯa nyinangi. Ngurra palula yalinytjarra Manatjaku ngaṉṯitja tjuṯaku ngurra kutjupa ngarangi. Ngurra palula yalinytjarra Yitjikaku ngaṉṯitja tjuṯa nyinangi. Ngurra palula yalinytjarra Tjipulanaku ngaṉṯitja tjuṯaya nyinangi. Ngurra palula yalinytjarra Naputaliku ngaṉṯitja tjuṯaya nyinangi. Ngurra palula wilurarra Yaatjaku ngaṉṯitja tjuṯaya nyinangi. Mayutju kutjupa tjuṯangku wangkangu Tjatjuwalu tawunu Timintjiranya walytjalu kanyintjaku, Katutjalu watjaṉutjangka. Tawunu palunya ngarangi Yipuramaku ngaṉṯitja tjuṯaku ngurrangka. Lipayiku ngaṉṯitja tjuṯaku tawunu tjuṯa tjana watjaṉu ngurrangka nyinanytjaku. Wiya tjanampa paṉa tiṉangka nyinanytjaku watjaṉu, ngurra tiṉa tjana wiya kanyiṉu. Tawunu tjuṯa kutju tjana kanyintjaku mayutju tjuṯangku watjaṉu. Katutjalu yurrunpa yalatji watjaṉu, “Lipayiku ngaṉṯitja tjuṯangku waarrka palyara tjaatji kalikingka mangarri kuka mantjintjaku, wiyaya kaanangka waarrkarrira mangarri kuka mantjintjaku.” ");
INSERT INTO piu2006_vpl VALUES ("JS16_1","007_16_1","JOS","16","1","10","(13:1—19:51; 21:1-45) Tjatjuwalu tjananya tjilirratjarra tjuṯanya katiyankula rawangku, palulanguru paluru nyinarra tjiḻpirringu. Palulanguru mayutju Katutjalu Tjatjuwanya wangkangu, “Nyuntu rawangku tjananyan, pungkula tjiḻpirringu, waarrka kutjupalpiṉanta palyantjaku wangkanyi. Nyuntu tjananya wangka!, yankulaya maakamilantjaku, yaaṯa nguwanpa tiṉa tjuṯa ngaranytjaku. Kutjupa tjuṯaya yaaṯa tiṉa kutjungka nyinanytjaku, kutjupa tjuṯaya yaaṯa tiṉa kutjupangka nyinanytjaku. Yalatjiya yuwankarra yaaṯa tiṉa tjuṯangka nyinaku. “Yitjurilaku ngaṉṯitja tjuṯangku tjilirratjarra tjuṯangku ngula tjananya yankula mirri puwa!, Pilitjiyanya ngurrara tjuṯa, ngurra tjanampaṉungka nyinakitjangku. Ngurra palula yulparirra nyinapayi tjuṯanya tjana pungkula tjananya wiyala!, ngurra Yitjipila kalkuṉi nyinapayi tjuṯanyaṯarra. Kapi Kaliliyila yalinytjarra nyinapayi tjuṯanyaṯarra tjananya pungkula wiyala!, ngurra tjulyalkitjangku. Ngurra palulakutunyurra tjungu yanku ngurra tjanampa tjulyalkitja. Ngurra palulakutunyurra yankunytjala, ngayuluṉa tjananya nguḻutjingara wantirriyalku.” Tjatjuwalu tjananya piyuku wangkangu, “Ngayulu nyurrangarrinya watjaṉingka yankulanyurra parriki nguwanpa maakamilantjaku. Ngulytjurarranpa kutjuya ngurra walytjangka nyinanytjaku. Ngulytjurarranpa kutjupa ngurra kutjupangka nyinanytjaku. Yalatjiya ngulytjurarranpa tuwalpala ngurra walytjangka nyinanytjaku.” Tjatjuwalu tjananya wangkangu ngurra kutjupa kutjupangka yankula nyinanytjaku. Yalatjiya paṉa Kayinanalawana nyinapayi Yitjurilaku ngaṉṯitja tjuṯa, ngurra kutjupa tjuṯawana. Ngurra tawunu Tjirikulawana, tawunu Kipiyalawana Pintjiminakuṉu ngaṉṯitja tjuṯa nyinapayi. Ngurra palula wilurarra Taanaku ngaṉṯitja tjuṯaya nyinangi. Palulanguru paluru tjana kapi Kaliliyila yalinytjarralpi yankula nyinangi. Pintjiminaku ngaṉṯitja tjuṯaku ngurrangka yulparirra Tjuutaku ngaṉṯitja tjuṯaya nyinapayi, tawunu Yipurunalawana. Tjiḻpi Kiilipanya tawunu palula rawa nyinanytjaku Tjatjuwalu watjaṉu. Ngurra palula yulparirra Tjimiyanaku ngaṉṯitja tjuṯaya nyinangi. Pintjiminaku ngaṉṯitja tjuṯaku ngurrangka kakarraraya Ruupinaku ngaṉṯitja tjuṯa nyinangi, karru Tjuutanala kakarrara. Ngurra palula yalinytjarra Kaataku ngaṉṯitja tjuṯaya nyinangi, karru Tjuutanala kakarrara. Ngurra palula yalinytjarra kapi Kaliliyila kakarrara Manatjaku ngaṉṯitja tjuṯaya nyinangi. Pintjiminaku ngaṉṯitja tjuṯaku ngurrangka yalinytjarra Yipurimaku ngaṉṯitja tjuṯa nyinangi. Ngurra palula yalinytjarra Manatjaku ngaṉṯitja tjuṯaku ngurra kutjupa ngarangi. Ngurra palula yalinytjarra Yitjikaku ngaṉṯitja tjuṯa nyinangi. Ngurra palula yalinytjarra Tjipulanaku ngaṉṯitja tjuṯaya nyinangi. Ngurra palula yalinytjarra Naputaliku ngaṉṯitja tjuṯaya nyinangi. Ngurra palula wilurarra Yaatjaku ngaṉṯitja tjuṯaya nyinangi. Mayutju kutjupa tjuṯangku wangkangu Tjatjuwalu tawunu Timintjiranya walytjalu kanyintjaku, Katutjalu watjaṉutjangka. Tawunu palunya ngarangi Yipuramaku ngaṉṯitja tjuṯaku ngurrangka. Lipayiku ngaṉṯitja tjuṯaku tawunu tjuṯa tjana watjaṉu ngurrangka nyinanytjaku. Wiya tjanampa paṉa tiṉangka nyinanytjaku watjaṉu, ngurra tiṉa tjana wiya kanyiṉu. Tawunu tjuṯa kutju tjana kanyintjaku mayutju tjuṯangku watjaṉu. Katutjalu yurrunpa yalatji watjaṉu, “Lipayiku ngaṉṯitja tjuṯangku waarrka palyara tjaatji kalikingka mangarri kuka mantjintjaku, wiyaya kaanangka waarrkarrira mangarri kuka mantjintjaku.” ");
INSERT INTO piu2006_vpl VALUES ("JS17_1","007_17_1","JOS","17","1","18","(13:1—19:51; 21:1-45) Tjatjuwalu tjananya tjilirratjarra tjuṯanya katiyankula rawangku, palulanguru paluru nyinarra tjiḻpirringu. Palulanguru mayutju Katutjalu Tjatjuwanya wangkangu, “Nyuntu rawangku tjananyan, pungkula tjiḻpirringu, waarrka kutjupalpiṉanta palyantjaku wangkanyi. Nyuntu tjananya wangka!, yankulaya maakamilantjaku, yaaṯa nguwanpa tiṉa tjuṯa ngaranytjaku. Kutjupa tjuṯaya yaaṯa tiṉa kutjungka nyinanytjaku, kutjupa tjuṯaya yaaṯa tiṉa kutjupangka nyinanytjaku. Yalatjiya yuwankarra yaaṯa tiṉa tjuṯangka nyinaku. “Yitjurilaku ngaṉṯitja tjuṯangku tjilirratjarra tjuṯangku ngula tjananya yankula mirri puwa!, Pilitjiyanya ngurrara tjuṯa, ngurra tjanampaṉungka nyinakitjangku. Ngurra palula yulparirra nyinapayi tjuṯanya tjana pungkula tjananya wiyala!, ngurra Yitjipila kalkuṉi nyinapayi tjuṯanyaṯarra. Kapi Kaliliyila yalinytjarra nyinapayi tjuṯanyaṯarra tjananya pungkula wiyala!, ngurra tjulyalkitjangku. Ngurra palulakutunyurra tjungu yanku ngurra tjanampa tjulyalkitja. Ngurra palulakutunyurra yankunytjala, ngayuluṉa tjananya nguḻutjingara wantirriyalku.” Tjatjuwalu tjananya piyuku wangkangu, “Ngayulu nyurrangarrinya watjaṉingka yankulanyurra parriki nguwanpa maakamilantjaku. Ngulytjurarranpa kutjuya ngurra walytjangka nyinanytjaku. Ngulytjurarranpa kutjupa ngurra kutjupangka nyinanytjaku. Yalatjiya ngulytjurarranpa tuwalpala ngurra walytjangka nyinanytjaku.” Tjatjuwalu tjananya wangkangu ngurra kutjupa kutjupangka yankula nyinanytjaku. Yalatjiya paṉa Kayinanalawana nyinapayi Yitjurilaku ngaṉṯitja tjuṯa, ngurra kutjupa tjuṯawana. Ngurra tawunu Tjirikulawana, tawunu Kipiyalawana Pintjiminakuṉu ngaṉṯitja tjuṯa nyinapayi. Ngurra palula wilurarra Taanaku ngaṉṯitja tjuṯaya nyinangi. Palulanguru paluru tjana kapi Kaliliyila yalinytjarralpi yankula nyinangi. Pintjiminaku ngaṉṯitja tjuṯaku ngurrangka yulparirra Tjuutaku ngaṉṯitja tjuṯaya nyinapayi, tawunu Yipurunalawana. Tjiḻpi Kiilipanya tawunu palula rawa nyinanytjaku Tjatjuwalu watjaṉu. Ngurra palula yulparirra Tjimiyanaku ngaṉṯitja tjuṯaya nyinangi. Pintjiminaku ngaṉṯitja tjuṯaku ngurrangka kakarraraya Ruupinaku ngaṉṯitja tjuṯa nyinangi, karru Tjuutanala kakarrara. Ngurra palula yalinytjarra Kaataku ngaṉṯitja tjuṯaya nyinangi, karru Tjuutanala kakarrara. Ngurra palula yalinytjarra kapi Kaliliyila kakarrara Manatjaku ngaṉṯitja tjuṯaya nyinangi. Pintjiminaku ngaṉṯitja tjuṯaku ngurrangka yalinytjarra Yipurimaku ngaṉṯitja tjuṯa nyinangi. Ngurra palula yalinytjarra Manatjaku ngaṉṯitja tjuṯaku ngurra kutjupa ngarangi. Ngurra palula yalinytjarra Yitjikaku ngaṉṯitja tjuṯa nyinangi. Ngurra palula yalinytjarra Tjipulanaku ngaṉṯitja tjuṯaya nyinangi. Ngurra palula yalinytjarra Naputaliku ngaṉṯitja tjuṯaya nyinangi. Ngurra palula wilurarra Yaatjaku ngaṉṯitja tjuṯaya nyinangi. Mayutju kutjupa tjuṯangku wangkangu Tjatjuwalu tawunu Timintjiranya walytjalu kanyintjaku, Katutjalu watjaṉutjangka. Tawunu palunya ngarangi Yipuramaku ngaṉṯitja tjuṯaku ngurrangka. Lipayiku ngaṉṯitja tjuṯaku tawunu tjuṯa tjana watjaṉu ngurrangka nyinanytjaku. Wiya tjanampa paṉa tiṉangka nyinanytjaku watjaṉu, ngurra tiṉa tjana wiya kanyiṉu. Tawunu tjuṯa kutju tjana kanyintjaku mayutju tjuṯangku watjaṉu. Katutjalu yurrunpa yalatji watjaṉu, “Lipayiku ngaṉṯitja tjuṯangku waarrka palyara tjaatji kalikingka mangarri kuka mantjintjaku, wiyaya kaanangka waarrkarrira mangarri kuka mantjintjaku.” ");
INSERT INTO piu2006_vpl VALUES ("JS18_1","007_18_1","JOS","18","1","28","(13:1—19:51; 21:1-45) Tjatjuwalu tjananya tjilirratjarra tjuṯanya katiyankula rawangku, palulanguru paluru nyinarra tjiḻpirringu. Palulanguru mayutju Katutjalu Tjatjuwanya wangkangu, “Nyuntu rawangku tjananyan, pungkula tjiḻpirringu, waarrka kutjupalpiṉanta palyantjaku wangkanyi. Nyuntu tjananya wangka!, yankulaya maakamilantjaku, yaaṯa nguwanpa tiṉa tjuṯa ngaranytjaku. Kutjupa tjuṯaya yaaṯa tiṉa kutjungka nyinanytjaku, kutjupa tjuṯaya yaaṯa tiṉa kutjupangka nyinanytjaku. Yalatjiya yuwankarra yaaṯa tiṉa tjuṯangka nyinaku. “Yitjurilaku ngaṉṯitja tjuṯangku tjilirratjarra tjuṯangku ngula tjananya yankula mirri puwa!, Pilitjiyanya ngurrara tjuṯa, ngurra tjanampaṉungka nyinakitjangku. Ngurra palula yulparirra nyinapayi tjuṯanya tjana pungkula tjananya wiyala!, ngurra Yitjipila kalkuṉi nyinapayi tjuṯanyaṯarra. Kapi Kaliliyila yalinytjarra nyinapayi tjuṯanyaṯarra tjananya pungkula wiyala!, ngurra tjulyalkitjangku. Ngurra palulakutunyurra tjungu yanku ngurra tjanampa tjulyalkitja. Ngurra palulakutunyurra yankunytjala, ngayuluṉa tjananya nguḻutjingara wantirriyalku.” Tjatjuwalu tjananya piyuku wangkangu, “Ngayulu nyurrangarrinya watjaṉingka yankulanyurra parriki nguwanpa maakamilantjaku. Ngulytjurarranpa kutjuya ngurra walytjangka nyinanytjaku. Ngulytjurarranpa kutjupa ngurra kutjupangka nyinanytjaku. Yalatjiya ngulytjurarranpa tuwalpala ngurra walytjangka nyinanytjaku.” Tjatjuwalu tjananya wangkangu ngurra kutjupa kutjupangka yankula nyinanytjaku. Yalatjiya paṉa Kayinanalawana nyinapayi Yitjurilaku ngaṉṯitja tjuṯa, ngurra kutjupa tjuṯawana. Ngurra tawunu Tjirikulawana, tawunu Kipiyalawana Pintjiminakuṉu ngaṉṯitja tjuṯa nyinapayi. Ngurra palula wilurarra Taanaku ngaṉṯitja tjuṯaya nyinangi. Palulanguru paluru tjana kapi Kaliliyila yalinytjarralpi yankula nyinangi. Pintjiminaku ngaṉṯitja tjuṯaku ngurrangka yulparirra Tjuutaku ngaṉṯitja tjuṯaya nyinapayi, tawunu Yipurunalawana. Tjiḻpi Kiilipanya tawunu palula rawa nyinanytjaku Tjatjuwalu watjaṉu. Ngurra palula yulparirra Tjimiyanaku ngaṉṯitja tjuṯaya nyinangi. Pintjiminaku ngaṉṯitja tjuṯaku ngurrangka kakarraraya Ruupinaku ngaṉṯitja tjuṯa nyinangi, karru Tjuutanala kakarrara. Ngurra palula yalinytjarra Kaataku ngaṉṯitja tjuṯaya nyinangi, karru Tjuutanala kakarrara. Ngurra palula yalinytjarra kapi Kaliliyila kakarrara Manatjaku ngaṉṯitja tjuṯaya nyinangi. Pintjiminaku ngaṉṯitja tjuṯaku ngurrangka yalinytjarra Yipurimaku ngaṉṯitja tjuṯa nyinangi. Ngurra palula yalinytjarra Manatjaku ngaṉṯitja tjuṯaku ngurra kutjupa ngarangi. Ngurra palula yalinytjarra Yitjikaku ngaṉṯitja tjuṯa nyinangi. Ngurra palula yalinytjarra Tjipulanaku ngaṉṯitja tjuṯaya nyinangi. Ngurra palula yalinytjarra Naputaliku ngaṉṯitja tjuṯaya nyinangi. Ngurra palula wilurarra Yaatjaku ngaṉṯitja tjuṯaya nyinangi. Mayutju kutjupa tjuṯangku wangkangu Tjatjuwalu tawunu Timintjiranya walytjalu kanyintjaku, Katutjalu watjaṉutjangka. Tawunu palunya ngarangi Yipuramaku ngaṉṯitja tjuṯaku ngurrangka. Lipayiku ngaṉṯitja tjuṯaku tawunu tjuṯa tjana watjaṉu ngurrangka nyinanytjaku. Wiya tjanampa paṉa tiṉangka nyinanytjaku watjaṉu, ngurra tiṉa tjana wiya kanyiṉu. Tawunu tjuṯa kutju tjana kanyintjaku mayutju tjuṯangku watjaṉu. Katutjalu yurrunpa yalatji watjaṉu, “Lipayiku ngaṉṯitja tjuṯangku waarrka palyara tjaatji kalikingka mangarri kuka mantjintjaku, wiyaya kaanangka waarrkarrira mangarri kuka mantjintjaku.” ");
INSERT INTO piu2006_vpl VALUES ("JS19_1","007_19_1","JOS","19","1","51","(13:1—19:51; 21:1-45) Tjatjuwalu tjananya tjilirratjarra tjuṯanya katiyankula rawangku, palulanguru paluru nyinarra tjiḻpirringu. Palulanguru mayutju Katutjalu Tjatjuwanya wangkangu, “Nyuntu rawangku tjananyan, pungkula tjiḻpirringu, waarrka kutjupalpiṉanta palyantjaku wangkanyi. Nyuntu tjananya wangka!, yankulaya maakamilantjaku, yaaṯa nguwanpa tiṉa tjuṯa ngaranytjaku. Kutjupa tjuṯaya yaaṯa tiṉa kutjungka nyinanytjaku, kutjupa tjuṯaya yaaṯa tiṉa kutjupangka nyinanytjaku. Yalatjiya yuwankarra yaaṯa tiṉa tjuṯangka nyinaku. “Yitjurilaku ngaṉṯitja tjuṯangku tjilirratjarra tjuṯangku ngula tjananya yankula mirri puwa!, Pilitjiyanya ngurrara tjuṯa, ngurra tjanampaṉungka nyinakitjangku. Ngurra palula yulparirra nyinapayi tjuṯanya tjana pungkula tjananya wiyala!, ngurra Yitjipila kalkuṉi nyinapayi tjuṯanyaṯarra. Kapi Kaliliyila yalinytjarra nyinapayi tjuṯanyaṯarra tjananya pungkula wiyala!, ngurra tjulyalkitjangku. Ngurra palulakutunyurra tjungu yanku ngurra tjanampa tjulyalkitja. Ngurra palulakutunyurra yankunytjala, ngayuluṉa tjananya nguḻutjingara wantirriyalku.” Tjatjuwalu tjananya piyuku wangkangu, “Ngayulu nyurrangarrinya watjaṉingka yankulanyurra parriki nguwanpa maakamilantjaku. Ngulytjurarranpa kutjuya ngurra walytjangka nyinanytjaku. Ngulytjurarranpa kutjupa ngurra kutjupangka nyinanytjaku. Yalatjiya ngulytjurarranpa tuwalpala ngurra walytjangka nyinanytjaku.” Tjatjuwalu tjananya wangkangu ngurra kutjupa kutjupangka yankula nyinanytjaku. Yalatjiya paṉa Kayinanalawana nyinapayi Yitjurilaku ngaṉṯitja tjuṯa, ngurra kutjupa tjuṯawana. Ngurra tawunu Tjirikulawana, tawunu Kipiyalawana Pintjiminakuṉu ngaṉṯitja tjuṯa nyinapayi. Ngurra palula wilurarra Taanaku ngaṉṯitja tjuṯaya nyinangi. Palulanguru paluru tjana kapi Kaliliyila yalinytjarralpi yankula nyinangi. Pintjiminaku ngaṉṯitja tjuṯaku ngurrangka yulparirra Tjuutaku ngaṉṯitja tjuṯaya nyinapayi, tawunu Yipurunalawana. Tjiḻpi Kiilipanya tawunu palula rawa nyinanytjaku Tjatjuwalu watjaṉu. Ngurra palula yulparirra Tjimiyanaku ngaṉṯitja tjuṯaya nyinangi. Pintjiminaku ngaṉṯitja tjuṯaku ngurrangka kakarraraya Ruupinaku ngaṉṯitja tjuṯa nyinangi, karru Tjuutanala kakarrara. Ngurra palula yalinytjarra Kaataku ngaṉṯitja tjuṯaya nyinangi, karru Tjuutanala kakarrara. Ngurra palula yalinytjarra kapi Kaliliyila kakarrara Manatjaku ngaṉṯitja tjuṯaya nyinangi. Pintjiminaku ngaṉṯitja tjuṯaku ngurrangka yalinytjarra Yipurimaku ngaṉṯitja tjuṯa nyinangi. Ngurra palula yalinytjarra Manatjaku ngaṉṯitja tjuṯaku ngurra kutjupa ngarangi. Ngurra palula yalinytjarra Yitjikaku ngaṉṯitja tjuṯa nyinangi. Ngurra palula yalinytjarra Tjipulanaku ngaṉṯitja tjuṯaya nyinangi. Ngurra palula yalinytjarra Naputaliku ngaṉṯitja tjuṯaya nyinangi. Ngurra palula wilurarra Yaatjaku ngaṉṯitja tjuṯaya nyinangi. Mayutju kutjupa tjuṯangku wangkangu Tjatjuwalu tawunu Timintjiranya walytjalu kanyintjaku, Katutjalu watjaṉutjangka. Tawunu palunya ngarangi Yipuramaku ngaṉṯitja tjuṯaku ngurrangka. Lipayiku ngaṉṯitja tjuṯaku tawunu tjuṯa tjana watjaṉu ngurrangka nyinanytjaku. Wiya tjanampa paṉa tiṉangka nyinanytjaku watjaṉu, ngurra tiṉa tjana wiya kanyiṉu. Tawunu tjuṯa kutju tjana kanyintjaku mayutju tjuṯangku watjaṉu. Katutjalu yurrunpa yalatji watjaṉu, “Lipayiku ngaṉṯitja tjuṯangku waarrka palyara tjaatji kalikingka mangarri kuka mantjintjaku, wiyaya kaanangka waarrkarrira mangarri kuka mantjintjaku.” ");
INSERT INTO piu2006_vpl VALUES ("JS20_1","007_20_1","JOS","20","1","9","Mayutju Katutjalu Tjatjuwanya wangkangu. Wangka panyapa tjananya paluru tjakultjunu, “Katutjalu watjaṉu mirri pungkupayinya tawunu kutjupakutu yankula kana nyinanytjaku. Tawunu palula kuutawutjungka paluru wangkanytjaku. Watjalaya tawunu tjikitjipala!, palula mirri pungkupayinya nyinanytjaku. Panyapa Muutjalulanya yirriṯi watjaṉu. Tjinguru yaṉangungku kulintjawiyangku mirri pungkula nguḻu tjalkaḻungku tawunu kutjupakutu, walytja tjuṯangku mirri pungkutjipingkamarra, tawunu palula kana nyinanytjaku. Yalatji tawunu tjikitjipala nyurrampa palya ngaraku.” Palulanguru wangkanguya tawunu tjirripala karru Tjuutanala wilurarra ngarangi. Tawunu yini Kiititjanya, Naputaliku ngaṉṯitja tjuṯaku ngurra. Tawunu kutjupa yini Tjikimanya Yipurimaku ngaṉṯitja tjuṯaku ngurra. Tawunu kutjupa Yipurananya ngarangi, Tjuutaku ngaṉṯitja tjuṯaku. Palulanguruya wangkangu tawunu tjirripala kutjupa ngarangi, karru Tjuutanala kakarrara. Tawunu yini Pitjanya, Ruupinaku ngaṉṯitja tjuṯaku ngurra tjanampa ngarangi. Tawunu kutjupa yini Ramutjanya, Kaataku ngaṉṯitja tjuṯaku ngurra ngarangi. Tawunu kutjupa Kulananya, Manatjaku ngaṉṯitja tjuṯaku ngurra ngarangi, kapi yini Kaliliyila kakarrara. ");
INSERT INTO piu2006_vpl VALUES ("JS21_1","007_21_1","JOS","21","1","45","(13:1—19:51; 21:1-45) Tjatjuwalu tjananya tjilirratjarra tjuṯanya katiyankula rawangku, palulanguru paluru nyinarra tjiḻpirringu. Palulanguru mayutju Katutjalu Tjatjuwanya wangkangu, “Nyuntu rawangku tjananyan, pungkula tjiḻpirringu, waarrka kutjupalpiṉanta palyantjaku wangkanyi. Nyuntu tjananya wangka!, yankulaya maakamilantjaku, yaaṯa nguwanpa tiṉa tjuṯa ngaranytjaku. Kutjupa tjuṯaya yaaṯa tiṉa kutjungka nyinanytjaku, kutjupa tjuṯaya yaaṯa tiṉa kutjupangka nyinanytjaku. Yalatjiya yuwankarra yaaṯa tiṉa tjuṯangka nyinaku. “Yitjurilaku ngaṉṯitja tjuṯangku tjilirratjarra tjuṯangku ngula tjananya yankula mirri puwa!, Pilitjiyanya ngurrara tjuṯa, ngurra tjanampaṉungka nyinakitjangku. Ngurra palula yulparirra nyinapayi tjuṯanya tjana pungkula tjananya wiyala!, ngurra Yitjipila kalkuṉi nyinapayi tjuṯanyaṯarra. Kapi Kaliliyila yalinytjarra nyinapayi tjuṯanyaṯarra tjananya pungkula wiyala!, ngurra tjulyalkitjangku. Ngurra palulakutunyurra tjungu yanku ngurra tjanampa tjulyalkitja. Ngurra palulakutunyurra yankunytjala, ngayuluṉa tjananya nguḻutjingara wantirriyalku.” Tjatjuwalu tjananya piyuku wangkangu, “Ngayulu nyurrangarrinya watjaṉingka yankulanyurra parriki nguwanpa maakamilantjaku. Ngulytjurarranpa kutjuya ngurra walytjangka nyinanytjaku. Ngulytjurarranpa kutjupa ngurra kutjupangka nyinanytjaku. Yalatjiya ngulytjurarranpa tuwalpala ngurra walytjangka nyinanytjaku.” Tjatjuwalu tjananya wangkangu ngurra kutjupa kutjupangka yankula nyinanytjaku. Yalatjiya paṉa Kayinanalawana nyinapayi Yitjurilaku ngaṉṯitja tjuṯa, ngurra kutjupa tjuṯawana. Ngurra tawunu Tjirikulawana, tawunu Kipiyalawana Pintjiminakuṉu ngaṉṯitja tjuṯa nyinapayi. Ngurra palula wilurarra Taanaku ngaṉṯitja tjuṯaya nyinangi. Palulanguru paluru tjana kapi Kaliliyila yalinytjarralpi yankula nyinangi. Pintjiminaku ngaṉṯitja tjuṯaku ngurrangka yulparirra Tjuutaku ngaṉṯitja tjuṯaya nyinapayi, tawunu Yipurunalawana. Tjiḻpi Kiilipanya tawunu palula rawa nyinanytjaku Tjatjuwalu watjaṉu. Ngurra palula yulparirra Tjimiyanaku ngaṉṯitja tjuṯaya nyinangi. Pintjiminaku ngaṉṯitja tjuṯaku ngurrangka kakarraraya Ruupinaku ngaṉṯitja tjuṯa nyinangi, karru Tjuutanala kakarrara. Ngurra palula yalinytjarra Kaataku ngaṉṯitja tjuṯaya nyinangi, karru Tjuutanala kakarrara. Ngurra palula yalinytjarra kapi Kaliliyila kakarrara Manatjaku ngaṉṯitja tjuṯaya nyinangi. Pintjiminaku ngaṉṯitja tjuṯaku ngurrangka yalinytjarra Yipurimaku ngaṉṯitja tjuṯa nyinangi. Ngurra palula yalinytjarra Manatjaku ngaṉṯitja tjuṯaku ngurra kutjupa ngarangi. Ngurra palula yalinytjarra Yitjikaku ngaṉṯitja tjuṯa nyinangi. Ngurra palula yalinytjarra Tjipulanaku ngaṉṯitja tjuṯaya nyinangi. Ngurra palula yalinytjarra Naputaliku ngaṉṯitja tjuṯaya nyinangi. Ngurra palula wilurarra Yaatjaku ngaṉṯitja tjuṯaya nyinangi. Mayutju kutjupa tjuṯangku wangkangu Tjatjuwalu tawunu Timintjiranya walytjalu kanyintjaku, Katutjalu watjaṉutjangka. Tawunu palunya ngarangi Yipuramaku ngaṉṯitja tjuṯaku ngurrangka. Lipayiku ngaṉṯitja tjuṯaku tawunu tjuṯa tjana watjaṉu ngurrangka nyinanytjaku. Wiya tjanampa paṉa tiṉangka nyinanytjaku watjaṉu, ngurra tiṉa tjana wiya kanyiṉu. Tawunu tjuṯa kutju tjana kanyintjaku mayutju tjuṯangku watjaṉu. Katutjalu yurrunpa yalatji watjaṉu, “Lipayiku ngaṉṯitja tjuṯangku waarrka palyara tjaatji kalikingka mangarri kuka mantjintjaku, wiyaya kaanangka waarrkarrira mangarri kuka mantjintjaku.” ");
INSERT INTO piu2006_vpl VALUES ("JS23_1","007_23_1","JOS","23","1","16","(23:; 24:1-13) Katutjalu tjananya yaṉṯayaṉṯara kanyilpayi, Yitjurilaku ngaṉṯitja tjuṯanya pikarringkunytjawiyaya nyinanytjaku. Palyaya ngurra walytjangka rawa nyinangi, wiyaya ngurra kutjupangka waṉma yankula pika pungkupayi. Tjatjuwalu waarrkana kutju wantirriyaṉu, yankula tjananya yaḻṯinytjaku, mayutju tjuṯanya. Ngalya yankulaya tjungurringkunytjala Tjatjuwalu tjananya yalatji watjaṉu, “Ngayuluṉa tjiḻpirringu tjinguru kuwarriṉa yiluku. Katutjanyala waḻkuṉi, paṉa ngaatjalampa yungutjangka, palyala nyinanytjaku. Paluru kuliṉi nyurrangarri yankula waṉma ngurrara tjuṯa pungkula yiluntankunytjaku, ngurra tjanampaṉulpinyurra mantjira nyinanytjaku. Yalatjinyurra yankunytjala, Katutjalu nyurranya aalpamilalku nyurrangarri yankula mirri pungkunytjala. “Muutjalu yirriṯi Katutjaku wangka piipangka wakara wantingu, wangka palunyakunyurra tjukarurru nyinanytjaku. Katutjanya nguwanpa kutjupa wiyanyurra waḻkuntjaku, Katutjanya kutjunyurra waḻkuntjaku. “Kungka waṉma ngurrara wiyanyurra yaḻṯirra kanyintjaku, Yitjurilaku ngaṉṯitja tjuṯa kutjunyurra yaḻṯirra kanyintjaku. “Kungka waṉma ngurrara tjuṯanyurra yaḻṯirra kanyiṉingka, Katutjalu nyurranya wiya ngurra waṉma yungkuku nyinanytjaku. Nyurrangarri tjananya waṉma ngurrara tjuṯa puṯu pungkula wiyalku. Katutjaku wangkanyurra kulira wantinyingka, paluru nyurranya pungkula wiyalku, nyurrangarri wiya palumpa tjukarurru nyinangutjangka. Ngurra ngaangka wiyanyurra kutu nyinaku.” Palulanguru Tjatjuwalu tjananya watjaṉu yaṉangu tjuṯa tjungurrinytjaku tawunu Tjikimala. Ngurra palula tjananya Tjatjuwalu kutu nintiṉingi, Katutjalu tjananya mirri tjuṯanya Yipuramanyangarri kutu yaṉṯayaṉṯaṉutjangka. Paluru tjananya piyuku wangkangu, “Nyurrangarri nyinanyi ngurra ngaangka mangarri tiṉatjarrangka, Katutjalu nyurranya ngurra ngaatja yungutjangka. Palulanguru kutunyurra Katutjaku tjukarurru nyinanytjaku, paluru nganampa mayutju tiṉa nyinanyingka.” ");
INSERT INTO piu2006_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","13","(23:; 24:1-13) Katutjalu tjananya yaṉṯayaṉṯara kanyilpayi, Yitjurilaku ngaṉṯitja tjuṯanya pikarringkunytjawiyaya nyinanytjaku. Palyaya ngurra walytjangka rawa nyinangi, wiyaya ngurra kutjupangka waṉma yankula pika pungkupayi. Tjatjuwalu waarrkana kutju wantirriyaṉu, yankula tjananya yaḻṯinytjaku, mayutju tjuṯanya. Ngalya yankulaya tjungurringkunytjala Tjatjuwalu tjananya yalatji watjaṉu, “Ngayuluṉa tjiḻpirringu tjinguru kuwarriṉa yiluku. Katutjanyala waḻkuṉi, paṉa ngaatjalampa yungutjangka, palyala nyinanytjaku. Paluru kuliṉi nyurrangarri yankula waṉma ngurrara tjuṯa pungkula yiluntankunytjaku, ngurra tjanampaṉulpinyurra mantjira nyinanytjaku. Yalatjinyurra yankunytjala, Katutjalu nyurranya aalpamilalku nyurrangarri yankula mirri pungkunytjala. “Muutjalu yirriṯi Katutjaku wangka piipangka wakara wantingu, wangka palunyakunyurra tjukarurru nyinanytjaku. Katutjanya nguwanpa kutjupa wiyanyurra waḻkuntjaku, Katutjanya kutjunyurra waḻkuntjaku. “Kungka waṉma ngurrara wiyanyurra yaḻṯirra kanyintjaku, Yitjurilaku ngaṉṯitja tjuṯa kutjunyurra yaḻṯirra kanyintjaku. “Kungka waṉma ngurrara tjuṯanyurra yaḻṯirra kanyiṉingka, Katutjalu nyurranya wiya ngurra waṉma yungkuku nyinanytjaku. Nyurrangarri tjananya waṉma ngurrara tjuṯa puṯu pungkula wiyalku. Katutjaku wangkanyurra kulira wantinyingka, paluru nyurranya pungkula wiyalku, nyurrangarri wiya palumpa tjukarurru nyinangutjangka. Ngurra ngaangka wiyanyurra kutu nyinaku.” Palulanguru Tjatjuwalu tjananya watjaṉu yaṉangu tjuṯa tjungurrinytjaku tawunu Tjikimala. Ngurra palula tjananya Tjatjuwalu kutu nintiṉingi, Katutjalu tjananya mirri tjuṯanya Yipuramanyangarri kutu yaṉṯayaṉṯaṉutjangka. Paluru tjananya piyuku wangkangu, “Nyurrangarri nyinanyi ngurra ngaangka mangarri tiṉatjarrangka, Katutjalu nyurranya ngurra ngaatja yungutjangka. Palulanguru kutunyurra Katutjaku tjukarurru nyinanytjaku, paluru nganampa mayutju tiṉa nyinanyingka.” ");
INSERT INTO piu2006_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","28","Tjatjuwalu tjananya piyuku watjaṉu, “Nganampa mirri tjuṯangku Katutjanya nguwanpa tjuṯa waḻkulpayi. Palunya nguwanpa wiyanyurra waḻkuntjaku. Kuwarrinyurra kulintjaku Katutjanya waḻkuntjakitjangku. Tjingurunyurra kutjupa tjuṯangku Katutjanya nguwanpa kutjupa waḻkulkitjangku kuliṉi. Nganaṉatju ngayuku walytja tjuṯangkuṯarra mayutju Katutjanya kutju waḻkura nyinaku.” Tjatjuwalu tjananya wangkangutjangka yaṉangu tjuṯangku kuliraya wangkangu Katutjanya kutju waḻkuntjaku. Palulanguru Tjatjuwalu tjananya wangkangu, “Nyurrangarri wangkangu Katutjaku tjukarurru nyinakitjangku, palulangurunyurra Katutjanya nguwanpa kutjupa waḻkulwiyangku wantinytjaku. Mantjiraya Katutjanya nguwanpa kutjupa waṉi!” Yalatjiya piyuku wangkangu Katutjanya kutju waḻkura nyinakitjangku. Palulanguru Tjatjuwalu tjananya nintiṉingi Katutjaku luwu tjuṯa, kuliraya tjukarurru nyinanytjaku. Palulanguru Tjatjuwalu piipangka luwu palunya wakaṉu. Palulanguru piyuku tjananya nintiṉingi luwu palulawana. Palulanguru yiyaṉu tjananya ngurrakutuya yankula nyinanytjaku. ");
INSERT INTO piu2006_vpl VALUES ("JS24_29","007_24_29","JOS","24","29","33","Tjatjuwa paluru rawa nyinangu yantaṯan tiin yiiya. Palulanguru paluru yilungu. Yularraya yaṉangu tjuṯangku katirra ngaṯingka tjarrpatjunu, ngurra palumpangka, tawunu Timanatjirangka yila. Tjatjuwaku ngalungku tjuṯaya mayutju tjuṯa rawa nyinapayi. Paluru tjana nyinanytjala, yaṉangu kutjupa tjuṯaya Yitjurilaku ngaṉṯitja tjuṯa tjukarurru Katutjaku nyinangi. Palulanguru tuḻkuku mayutju Yalitjanya, Yiranaku katja yilungu. Katirraya ngaṯingka tjarrpatjunu ngurra Kipiyangka, Yipurimaku ngaṉṯitja tjuṯaku ngurrangka. Yirriṯi Muutjalungarri Tjutjupanya tarrka Yitjipilanguru katirraya, piṉkingka tjarrpatjunu, ngurra Tjikimala. ");
INSERT INTO piu2006_vpl VALUES ("JG6_11","008_6_11","JDG","6","11","24","Wati Kitiyanalu mangarri wiita yarrkayarrkangku rungkaṉangi, kaḻka tjuṯa mantjilkitjangku, Mitiyanya ngurrara tjuṯangku nyakula katipayingkamarra. Palulanguru Katutjaku yilkari ngurrarangku watjaṉu, “Nyuntu nguḻuwiyangku tjilirratjarrangku tjananya yirriṯi pungkula nguḻutjingalpayi. Mayutju Katutjalunta nyakula kanyiṉi.” Kitiyanalu watjaṉu, “Tjapilkitjaṉanta yunytjurringanyi, puṯuṉa kuliṉi. Tjingurulanya Katutjalu nyakula kanyiṉi, tjinguru wiya. Nyaakuya Mitiyanya ngurrara tjuṯangkulanya ngalya yankula pungkupayi? Yirriṯitja tjuṯaku tjanampa yilta Katutjalu paawu puntungku palyalpayi. Katutjalu tjanampa kuya tjuṯa pungkula wantirriyalpayi. Kuwarri palurulampatju wiya Mitiyanya ngurrara tjuṯa pungkula iyaṉi. Paluru tjana nganaṉanya pungkupayi, kutu.” Mayutju Katutjalulpi Kitiyananya yalatji watjaṉu, “Nyurrangarri yankula Mitiyanya ngurrara tjuṯa pungkunytjaku, Yitjurilaku ngaṉṯitja tjuṯa kanalkitjangku. Ngayuluṉanta Katutjalu iyaṉi.” Kitiyanalu watjaṉu, “Puṯuṉa kuliṉi. Ngayulu mungutja, ngayulu tjananya puṯu kanalku. Walytja tjuṯa ngayuku wiya, maṉkurrpa kutjulatju nyinanyi.” Katutjalu watjaṉu, “Nyurrangarri palya yankula tjananya pungkula wantirriyalku, ngayulu nyurrangarrinya aalpamilalku.” Palulanguru Kitiyanalu kuka anta mangarri kunaṯinpa mantjira puḻingka tjunu, ilkari ngurrara palumpa. Ilkari ngurraralu watiya mantjira watiya palunyatjarrangku kuka anta mangarri pampuntjala, kuka anta mangarri puḻiṯarra kamparra wiyarringu. Palunyangka yilkari ngurrara paluru nyinarra wiyarringu. Palulanguru Kitiyanalu ngurra palula yini Wuupangka tiipula nguwanpa palyaṉu puḻitjanu, Katutjaku ngaranytjaku. ");
INSERT INTO piu2006_vpl VALUES ("JG6_25","008_6_25","JDG","6","25","32","Munga palula mayutju Katutjalu Kitiyananya yalatji watjaṉu, “Maa yankula nyuntupa paapaku tiipula nguwanpa yuḻpura waṉi! Tiipula palulaya ngayunya nguwanpa Paalanya waḻkulpayi. Tiipula palula tjayiṯingka ngayunya nguwanpa kutjupa watiya ngaranyi yini Yatjaranya. Palunyaṯarra nyuntu yuḻpura waṉi! Tiipula palunya yuḻpura tiipula kutjupa puḻitjanu palyala!, ngayuku. Palulanguru watiya Yatjaranya yuḻpura ngayuku tiipulangka mantjira tjurra!, kamparra wiyarrinytjaku. Nyuntupa paapaku puluka mirri pungkula yitjiḻinkula Yatjarangka katu tjunkula kutjala! Yalatji tjawirrilyi ngayuku, kamparra wiyarriku, tiipula ngayukuṉungka.” Palumpa walytja tjuṯangkuya nyakula yunytjuwiyangku ngaparrtjingku pungkupayingkamarra, Kitiyanalungarri waarrkana tjuṯangku mungangka yankula tiipula palunya yuḻpuṉu. Watiya Yatjaranyaṯarra tjanaya yuḻpura tiipula Katutjakuṉungka tjunkula tjawirrilyi katuwana kutjaṉu. Aaḻiya pakara tawunu ngurrara tjuṯangku Kitiyanaku walytja tjuṯangkuṯarra nyakulaya pikarringu yuḻpuṉutjangka. Ngaṉṯiya kuliṉu Kitiyanalungarri yuḻpuṉutjangka. Paluru tjana Kitiyanaku paapangka Tjuwatjala yalatji watjaṉu, “Ngalya katirraya ngaangka ngaratjurra!, Kitiyananyalatju mirri pungkunytjaku. Maṯupurralampa Paalakuṉu tiipula anta Yatjaranyaṯarra yuḻpura wiyaṉu.” Tjuwatjalu tjananya palumpa katjaku patjurirringkula tjapiṉu, “Nyaaku nyurrangarri Paalaku Yatjaraku pikarringkula kuliṉi? Nyurrangarri kuliṉi Paalanya ngangkari puntutjarra nyinanyi. Palurulanyatju mirri pungkunytjaku Kitiyananyaṯarra, wiya nyurrangarrilanyatju ngaparrtjingku pungkunytjaku.” ");
INSERT INTO piu2006_vpl VALUES ("JG6_33","008_6_33","JDG","6","33","35","Palulanguruya Mitiyanya ngurrara tjuṯaya Yamalikaku ngaṉṯitja tjuṯaṯarra, kutjupa tjuṯaṯarra tjungurringu. Palulanguru tjanaya yankula puliina yini Tjitjirilangka nyinangu. Palulanguru Katutjaku kurrunpangku Kitiyananya nintira aalpamilaṉu. Paluru turampata mirratjingaṉu palumpa walytja, panya Yapitjitjaku ngaṉṯitja tjuṯa yaḻṯinytjaku. Yalatji tjananya Yapitjitjaku ngaṉṯitja tjuṯa yaḻṯingu tjungurrinytjaku. Palulanguru Kitiyanalu wikarrutja tjuṯa maa wantirriyaṉu, yankula Yitjurilaku ngaṉṯitja tjuṯa yaḻṯirra ngalya katinytjaku, ngurra tjuṯawana nyinanytja tjuṯa. Palulanguruya tjuṯalingku ngalya yankula Kitiyanala tjungurringu. ");
INSERT INTO piu2006_vpl VALUES ("JG6_36","008_6_36","JDG","6","36","40","Kitiyanalu Katutjanya watjaṉu yalatji, “Tjinguru nyuntu ngayunya yaḻṯingu, ngayulu Yitjurilaku ngaṉṯitja tjuṯa pikakutu katinytjaku, Mitiyanya ngurrara tjuṯalatju mirri pungkunytjaku. Tjinguru nyuntu ngayunya wiya yaḻṯingu, ngayulu wiyawanangku kuliṉi. Puṯuṉa kuliṉi. Yalatji ngayulu tjananya mayutjungku katinytjaku nintilaṉi! Tjiipitjanu pangki yinyu ngaatjanyaṉa pilara tjunu paṉangka. Aaḻiṉa pakara ngalya yanku wiita nyakunytjaku tjiipikuṉu yinyuwana. Yinyuwana kutju wiita nyakunytjaku, paṉawana wiya. Ngayuluṉa yalatji nyakula kulilku, ‘Katutjalu yinyungka wiitaṉu, yiltaṉi mayutju nyinatjunu, ngayulu tjananya pikakutu katinytjaku.’ Tjinguru ngayuluṉa aaḻi nyakula paṉawana yinyuwanaṯarra wiita ngarrinyingka, ngayulu yalatji kulilku, ‘Katutjaluṉi wiya nyinatjunu ngayulu tjananya pikakutu katinytjaku.’” Aaḻi pakara Kitiyanalu yankula nyangu yinyu palula wiita ngarringi, paṉawana wiya. Nyakula nguḻurringu. Piyuku Kitiyanalu Katutjanya yalatji tjapiṉu, “Katutja. Ngayukutjunu pikarrinytjawiya. Yara yalatji wiya kutjuṉanta tjapilku, tjipikuṉu yinyu palula wiitawiya ngarrinytjaku, paṉawana kutju wiita ngarrinytjaku. Aaḻiṉa yankula paṉa nyaku wiita ngarrinytjala. Nyakulaṉa kulilku, ‘Yilta Katutjaluṉi mayutju nyinatjunu, ngayulu tjananya pikakutu katinytjaku.’” Yalatji Katutjalu palyaṉu. Aaḻi Kitiyanalu nyangu paṉawana kutju wiita ngarringu. Yalatji nyakula palurulpi tjananya yaḻṯingu tjilirratjarra tjuṯa pikakutu katinytjaku. ");
INSERT INTO piu2006_vpl VALUES ("JG7_1","008_7_1","JDG","7","1","8","Kitiyananya palumpa walytja tjilirratjarra tjuṯa aaḻiya yanu kapi yini Yaratalakutu, rakula tiṉakutu. Kapi palula ila Kitiyananya Katutjalu watjaṉu, “Tjilirratjarra tjuṯalingku tjananya nyuntu katiyananyi. Yalatjiwiya, nampa maṉkurrpa nguwanpa nyuntu tjananya pikakutu katinytjaku. Ngayulu nyurrangarrinya tjilirratjarra maṉkurrpa nguwanpa aalpamilalku palunya tjuṯa pungkula iyantjaku. Palulanguru ngayunya nyurrangarri yiltangku waḻkuntjaku. Tjinguru tjuṯalingkunyurra yankula tjananya pungkula iyalku, wiyawanangkunyurra kulilku yalatji, ‘Nganaṉa tjilirratjarra tjuṯalingkungku tjananya pungkula yiyaṉu.’ Wiya, maṉkurrpa nguwanpangkunyurra yankula tjananya pungkula iyantjaku. Palulangurunyurra tjukarurrulpi kulilku yalatji, ‘Katutjalulanya aalpamilantjala, ngaṉana tjananya pungkula iyaṉu.’” Katutjalu Kitiyananya yalatji piyuku watjaṉu, “Tjilirratjarra tjuṯaya nampa maṉkurrpa nguwanpa nyinanytjaku. Nyuntu watjala tjananya!, nguḻunytju tjuṯa ngurrakutu rayitpayiki yankunytjaku.” Yalatji Kitiyanalu tjananya watjantjala, tjilirratjarra tjawutjuna tuwintituupala ngurrakutu rayitpayiki yanu. Tjilirratjarra tjawutjuna tiinpala nyinangu, Kitiyanalawana pikakutu yankula pungkunytjaku. Palulanguru Katutjalu Kitiyananya piyuku watjaṉu, “Tjilirratjarra tjuṯalingkuya kutu nyinanyi, nampa maṉkurrpa nguwanpa kutju nyuntu tjananya katinytjaku. Kapi nyarrakutu nyuntu tjananya ila kati!, tjikintjaku. Nyuntu nyangama! Marangku mantjira tjikintjala palunya tjuṯa kutju nyuntu marrkula!, pikakutu katinytjaku. Palulanguru nyuntu kutjupa tjuṯa nyawa!, pupakatirra marangku mantjira tjikintjawiya tjikintjala. Kala, nyuntu tjananya watjala!, maḻaku yankunytjaku ngurrakutu.” Tjilirratjarra yantaṯa tjirripalangkuya pupakatirra marangku tjikiṉu. Nyakula tjananya watjaṉu tjungurrinytjaku, kanya kutjupa tjuṯa tjananya watjaṉu ngurrakutu yankunytjaku. ");
INSERT INTO piu2006_vpl VALUES ("JG7_9","008_7_9","JDG","7","9","15","Tjilirratjarra yantaṯa tjirripalaya ngurra kutjungka nyinangu. Mungangka Kitiyananya anta palumpa waarrkanapula yanu Mitiyanya ngurrara tjuṯa parra nyakunytjaku. Yankulapula nyangu tjuṯalingku nyinarra waṉinytjala, tjilirratjarra minga nguwanpa nyinanytjala. Kamula tjuṯa tjanampa ngarala waṉingu, tjuṯalingku. Yilarringkula tjananya paluru kutjarrangku kuliṉu yuṯupula wangkanytjala. Wati kutjungku tjukurrpa nyakula wati kutjupangka yalatji tjakultjunu, “Tjukurrpaṉa nyangu mangarri puriiti kutju nganampa ngurrakutu patangarala ruularringu, kaliki kutju pungkula patatjingaṉu.” Wati kutjupangku kulira watjaṉu, “Puriiti panyapanu nyangu Kitiyananya nguwanpa. Kitiyanalungarri tjuuḻa tawarratjarrangku ngalya yankula nganaṉanya pungkula nguḻutjingara wantirriyalku, Katutjalu tjananya aalpamilaṉutjangka.” Tjukurrpa palunyatjanu wati paluru kutjarra wangkanytjala Kitiyanalupula kuliṉu. Kulira Kitiyanalu yunyparringkula Katutjanya yalatji kuliṉu, “Katutjalulanya iltangku aalpamilalku.” Palulangurupula paluru kutjarra rayitpayiki yanu tjilirratjarra walytja tjuṯakutu. ");
INSERT INTO piu2006_vpl VALUES ("JG7_16","008_7_16","JDG","7","16","25","Kitiyanalu tjananya watjaṉu, “Waṯalpi pakalaya! Nyarra tjuṯa tjananya Katutjalu kuwarri pungku, palurulanya aalpamilalku.” Turaama nguwanpa pilkitjanu palyaṉutja tjuṯa paluru mantjira tjananya kutjuṯu kutjuṯu yungu. Tjangiya mantjira tilira turaama palula tjarrpatjunu tili yutiya nyakutjipingkamarra, Mitiyanya ngurrara tjuṯangku. Turampataṯarra tjananya Kitiyanalu yungu kutjuṯu kutjuṯu. Mitiyanya ngurrara tjuṯaya mungangka yanku ngarrinytjala, Kitiyanaku waarrkana yantaṯa kutjungku turaama tjangi tilitjarra katirra yalinytjarra tjayiṯi yankulaya kumpira ngarangu. Wanaṉu yantaṯa tjilirratjarra kutjupa tjuṯangku turaama tjangi tilitjarra katirra. Yankula yulparirra tjayiṯi kumpiraya ngarangu. Kitiyanalu wanaṉu yantaṯa tjilirratjarra kutjupa tjuṯa katingu. Paluru tjana turaama tjangi tilitjarra katirra, yankula wilurarra tjayiṯi kumpiraya ngarangu. Kitiyanaku tjilirratjarra tjuṯangku tjananya yalatji ngururrtjunkula turampata tjuṯaya mirratjingara wanaṉu. Turaama palunya tjuṯaya yuḻpuṉu tjangi tilitjarralpiya rayitrawunu ngarangu. Raapangkuya yalatji watjaṉu, “Mayutju Katutjalulanyatju iyaṉu. Nganaṉa Kitiyanaku tjilirratjarra tjuṯa ngalya yanu pungkunytjaku nyurrangarrinya, pikangku.” Kitiyanalungarriya ngarala panyapa yunypangku watjara turampata mirratjingaṉingi. Palulanguru Mitiyanya ngurrara tjuṯaya kulira nguḻurringu. Walytja tjuṯangkuyanku tjuuḻa waṯawaratjarrangku wakaṉingiyanku Yalatjiyanku wakaṉingi mungangka. Kutjupa tjuṯaya nguḻu tjalkaḻungu. Kitiyanalungarri tjananya wanara wakaṉu, kanya kutjupa tjuṯa tjananya wantirriyaṉu. Palulanguru Kitiyanalu wikarrutja tjuṯa tjananya iyaṉu tawunu tjuṯakutu. Palunya ngurrara tjuṯa tjananya tjana watjaṉu Kitiyanalu watjaṉutja yalatji, “Pakalaya, tjilirra mantjira Mitiyanya ngurrara nguḻunytju tjuṯa wanara wakala!” Palunya ngurrara tjuṯangkuya kulira yankula tjananya Mitiyanya ngurrara tjuṯa wakarinangi, tjuṯalingku. ");
INSERT INTO piu2006_vpl VALUES ("JG13_1","008_13_1","JDG","13","1","25","Palulanguruya Yitjurilaku ngaṉṯitja tjuṯangku Katutjanya wantirra kutu kuya palyara nyinapayi. Palulanguru tjananya Katutjalu yaṉṯayaṉṯantjawiyangku wantingu, Pilitjiyanya ngurrara tjuṯa tjanampa mayutjurrinytjaku. Paluru tjana mayutju kuyangku rawangku kanyilpayi. Palunyangkapula wati Manuwanya miiṯararra nyinangu tawunu Tjirangka, pipirri mantjintjawiya. Kungka palula Katutjaku yilkari ngurrara yutirringu. Yutirrirra yalatji watjaṉu, “Nyuntu pipirri mantjintjawiya nyinarra, kuwarrilpinu katjalpi mantjilku. Nyuntupa katja yutirringkula tiṉarringkula nyinanytjala palunya kata muṯulwiyangku wanti! Paluru Katutjaku tjukarurru nyinaku. Paluru watirringkula Yitjurilaku ngaṉṯitja tjuṯa kanalku, Pilitjiyanya ngurrara tjuṯangku pungkutjipingkamarra.” Wati Manuwalu Katutjanya tjapintjala, yilkari ngurrara paluru ngalya yankula palula kutjarrangka piyuku wangkangu. Palulanguru Manuwalu nanikuta wiima pungkula tjawirrilyi Katutjaku ngarritjunkula kutjaṉu. Kampanytjala yilkari ngurrara paluru tjawirrilyitjanu tilingka wiyarringu. Palulanguru kungka palurulpi katja mantjira yini Tjamtjananya watjaṉu. Pipirri tiṉarringkula Katutjalu kaṉṯilyankula kanyilpayi. ");
INSERT INTO piu2006_vpl VALUES ("JG14_5","008_14_5","JDG","14","5","6","Tjamtjananya watirringkula manpaṯa tiṉa nyinangi. Palumpa paapa anta maama tjunguya yanu tawunu Timinalakutu. Ngururrpa yankula Tjamtjanalu kuliṉu layina yila nguunmankunytjala. Kulira pulanya wantirra layina palulakutu yankula witira marangku nguṉṯi tjuyintamilara mirrintanu. Yalatji mirrintankunytjaku Katutjalu palunya kaṉṯilyanu. Palumpa paapangku maamangkuṯarra nyakunytjawiya nyinangi, paluru layina palunya mirrintankunytjala. Tjamtjanalu layina mirrintara tjakultjunkunytjawiya paluru kutjarrala tjungurringkula yankula tawunu Timinala tjarrparra nyinapayi. Yurrunpa tawunu palula Tjamtjananya kungka Pilitjiyanya ngurraraku yunytjurringu. Paluru palumpa paapangka watjaṉu, “Kungkaku pamilingka nyuntu yankula tjapila!, ngayulu marriṯi mantjintjaku.” Paluru yankula tjananya tjapiṉu, Tjamtjanalu kungka palunya kanyintjaku. Paluru tjana watjaṉu yuṉṯalpa yungkukitjangku. Yalatji watjara tjanaya wati kutjupakulpi yungu. ");
INSERT INTO piu2006_vpl VALUES ("JG15_1","008_15_1","JDG","15","1","8","Kungka palunya wati kutjupaku yungutjangka, Tjamtjananya pikarringkula yankula tingkuwu tjuṯa wanara witiṉangi, yantaṯa tjirripala. Tingkuwu kutjarra wipu witira tayimapiṉu waru tjangi tilitjarra. Tayimapira pulanya wantirriyaṉu Pilitjiyanya ngurrara tjuṯaku kaanawana. Kaana palunya tjuṯangka mangarri wiita yuṉmi ngarala waṉingi. Tingkuwu paluru kutjarrangku tjangi katirra wiita tilirinkupayi. Tingkuwu kutjarra kutjupa wipu witira tayimapiṉu waru tjangi tilitjarra. Paluru pulanya wantirriyaṉu wiita tilirinkunytjaku. Palunya nguwanpa tingkuwu yantaṯa tjirripala kutjarranguru kutjarranguru tayimapira wantirriyaṉu, mangarri tjanampa wiita tilira wiyantjaku. Yalatji tjananya wantirriyara Tjamtjananya yankula kuḻpingkalpi nyinangu. ");
INSERT INTO piu2006_vpl VALUES ("JG15_9","008_15_9","JDG","15","9","20","Tjamtjananya kuḻpingka nyinanytjala, Pilitjiyanya ngurrara tjuṯaya yanu tawunu Liiyingka tjananya pikangku pungkukitja, Tjuutaku ngaṉṯitja tjuṯa. Pilitjiyanya ngurrara tjuṯangku tjananya watjaṉu, “Yankulanyurra Tjamtjananya kuḻpingka witira ruupangka tayimapira ngalya kati!” Paluru tjana Tjuutaku ngaṉṯitja tjuṯa kuḻpikutu yankula Tjamtjananya ruupangka tayimapira katingu yungkukitja. Pilitjiyanya ngurrara tjuṯangku Tjamtjananya ruupatjarra nyakula yunyparringkula maa tjalkaḻungu Tjamtjananya mirri pungkukitja. Katutjalu Tjamtjananya kaṉṯilyankunytjala ruupa paluru kilytjuntanu. Palulanguru parra ngurrira paluru tuungkiyikuṉu tarrka kaṯiṯitjarra mantjiṉu. Mantjira tarrka palunyatjarrangku Pilitjiyanya ngurrara tjuṯa tjananya wakaṉingi, tjilirratjarra tjuṯalingku, tjawutjuna kutju tjananya. Palulanguru Tjamtjananya Yitjurilaku ngaṉṯitja tjuṯaku tjilirratjarra tjuṯaku mayutju rawa nyinangi. ");
INSERT INTO piu2006_vpl VALUES ("JG16_4","008_16_4","JDG","16","4","22","Palulanguru Tjamtjananya paṉa Pilitjiyakutu yankula kungka palunya ngurraraku kutjupaku yunytjurringkula nyinangi. Kungka paluru yini Tilalanya. Pilitjiyanya ngurrara tjuṯaku mayutju payipala nyinangi. Paluru tjana kungka palulakutu yankula yalatji tjingapungu, “Tjamtjananya ngunytji tjapila!, ‘Nyaatjanu nyuntu manpaṯa nyinanyi? Yaṉangu kutjupangkunta nyaalytjinku?, nyuntu manpaṯawiya nyinanytjaku.’ Tjamtjanalunta tjakultjunkunytjala nganaṉanyalpilanyatju tjakultjurra! Palulangurulatjunta mani puntu yungku, mani tjiilpa waan tjawutjuna.” Palulanguru Tilalalu Tjamtjananya yalatji tjapiṉu, “Nyaatjanu nyuntu manpaṯa nyinanyi? Yaṉangu kutjupangkunta nyaalytjinku?, nyuntu manpaṯawiya nyinanytjaku.” Tjamtjanalu yalatji ngunytjilyinu, “Puwanarratjanu puturru marrkangkaṉiya tjapanpalangara tayimapira nyinatjunkunytjala, puṯuṉa kilytjuntanku, manpaṯawiyaṉa nyinaku.” Tilalalu puwanarratjanu puturru tjapanpala mantjira Tjamtjananya tayimapiṉu, yanku ngarrinytjala. Palula yurrunpa Pilitjiyanya ngurrara maṉkurrpa palumpa waaḻangka kumpiṉu, Tjamtjananya manpaṯawiya nyinanytja witiraya katikitja. Tilalalu Tjamtjananya tayimapira kanara watjaṉu, “Tjamtjana. Pilitjiyanya ngurrara tjuṯangkuntaya witintjaku ngalya yananyi.” Paluru kanarringkula pakara puturru tjuṯa kilytjuntanu. Palunya tjuṯaya yarrka Tilalaku ngurrangka nyinarra ngurra walytjakutu rayitpayiki yanu. Palulanguru Tilalalu piyuku palunya tjapiṉu, “Nyaatjanu nyuntu manpaṯawiya nyinaku?” Tjamtjanalu piyuku yalatji ngunytjilyinu, “Ruupa nyuwanangkaṉiya tayimapira wantinytjala, puṯuṉa yarralytjanku, manpaṯawiyaṉa nyinaku.” Palulanguru Tjamtjananya yanku ngarrinytjala Tilalalu ruupa nyuwanangka tayimapiṉu. Paluru Tjamtjananya kanantjala paluru pakara kilytjuntanu. Palulanguru Tilalalu piyuku tjapiṉu, “Nyaatjanu nyuntu manpaṯawiya nyinaku?” Tjamtjanalu piyuku yalatji ngunytjilyinu, “Mangka waṯawaraṉi ruupa nguwanpa watiya tiṉangka tayimapintjala ngayuluṉa wiya manpaṯa nyinaku.” Palunyangka Tjamtjananya yanku ngarrinytjala Tilalalu mangka waṯawara tayimapiṉu watiya palula. Tayimapira Tjamtjananya kanantjala, paluru parra taaṉarringkula yarralytjanu manpaṯangku. Palulanguru Tilalalu pikarringkula payiṉu, “Nyuntu ngayunya tjuṯangara ngunytjilyinu, nyuntu wiya ngayuku yunytjurringanyi.” Yalatji tjiṉṯu kutjupangka tjiṉṯungka Tilalalu rawangku tjapintjala Tjamtjananya tjikipitarringu tjukarurrulpi paluru tjakultjunu, “Mangka waṯawara wiyaṉiya muṯulpayi. Ngayuku paapangku anta maamangkupula ngayunya pipirri yungu Katutjaku, ngayuluṉara tjukarurru nyinanytjaku. Tjinguru kutjupangkuṉi mangka muṯuntjala wiyaṉa manpaṯa nyinaku, wati kutjupa tjuṯa nguwanpaṉa nyinaku.” Tjamtjanalu tjukarurru watjantjala Tilalalu tjananya mayutju palunya tjuṯa yankula watjaṉu palumpa waaḻangka kumpintjaku. Tjamtjananya yanku ngarrinytjala Tilalalu wati kutjupa watjaṉu Tjamtjananya mangka muṯuntjaku. Paluru muṯuṉu. Palulanguru Tilalalu watjaṉu kanalkitjangku, “Tjamtjana. Pilitjiyanya ngurrara tjuṯaya ngalya yananyi nyuntunyantaya witilkitja.” Katutjalu wiya palunya kaṉṯilyanu, paluru manpaṯawiyalpi nyinangi. Palulanguruya Pilitjiyanya ngurrara tjuṯangku witira katingu tawunu Kaatjalakutu. Tjamtjananya tjana yayinatjarrangku kuru wakara paangaṉu. Paangaraya tjiilangka katirra tjarrpatjunu. Puḻi tiṉangka paluru kutu waarrkarringkula mangarri yuḻpulpayi. Yalatji Tjamtjananya rawa waarrkarringkula mangka tiṉarringulpi. ");
INSERT INTO piu2006_vpl VALUES ("JG16_23","008_16_23","JDG","16","23","31","Pilitjiyanya ngurrara tjuṯaya waaḻa tiṉangka tjungurringu, mayutju tjanampa payipalaṯarra. Yaṉangu tjawutjuna tjirripalaya waaḻa palula ngalkura tjikira yunyparringangi, Tiikunanya waḻkulkitja. Tiikunanya tjana waḻkulpayi Katutjanya nguwanpa. Tjungu yunyparringkulaya uḻa wiima iyaṉu Tjamtjananya yankula yaḻṯirra ngalya katinytjaku. Paluru tjana kuliṉu Tjamtjananya tiitjimilalkitjangku. Uḻa paluru yankula yaḻṯirra katirra Tjamtjananya waaḻangka ngururrpa ngaratjunu. Uḻa palula Tjamtjanalu yalatji watjaṉu, “Uḻa. Watiya palunya tiṉa kutjarrakutuṉi kati!, waaḻa katuwana watiya witilpayi kutjarrakutu.” Uḻa paluru katirra watiya palunya kutjarrangka ngaratjunu. Tjamtjanalu Katutjanya tjapiṉu, “Kutjungaralpiṉi kaṉṯilyarra!”. Palulanguru watiya palunya kutjarra yuṉṯura waaḻa winki piluntanu. Palulanguru waaḻa tiṉangku katunguru punkara tjananya Pilitjiyanya ngurrara tjuṯalingku paḻira mirrintanu, Tjamtjananyaṯarra. Yalatji Tjamtjananya mirrirringu, Yitjurilaku ngaṉṯitja tjuṯaku mayutju nyinarra. ");
INSERT INTO piu2006_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2","Paṉa Kayinanalawana wiya tjananya kapingku pungangi. Palulanguru mangarri tjanampa wiyarringu. Mangarriwiyangkapula wati Yilimalikalu palumpa miiṯalu Niyumilupula kuliṉu paṉa Muwapalakutu yankulapula ngunytji nyinanytjaku. Palulanguru Yilimalikanyangarriya paṉa Muwapalakutu yanu, palumpa katja kutjarraṯarra, Malunanya anta Tjiliyunanya. ");
INSERT INTO piu2006_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","5","Paṉa Muwapalaya rawa nyinarra Yilimalikanya mirrirringu. Palulanguru palumpa katja kutjarrangku kungka Muwapanya ngurrara kutjarra yaḻṯirra kanyiṉangi. Manunalu kungka Ruutjanya kanyiṉangi, Tjiliyunaluṯarra kungka Wupanya kanyiṉangi. Yiiya tiinpalapula nyinarra wati paluru kutjarra mirrirringu. ");
INSERT INTO piu2006_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","22","Kungka tjirripalalpiya nyinarra Niyumilu kuliṉu paṉa Kayinanangka mangarri puntu ngarrinytjala. Palulanguru paluru kuliṉulpi ngurra walytjakutu Pitjiliyamalakutu piyuku yankunytjaku. Niyumilu pulanya Wupanya Ruutjanya marrkuṉu, walytja tjuṯawana, paṉa Muwapala nyinanytjaku. Niyuminya kutju yankunytjala paluru kutjarrangku yularra watjaṉu, “Wiya. Tjungula yanku ngurra Pitjiliyamalakutu.” Piyuku pulanya Niyumilu marrkuṉu ngurra walytjangka kutu nyinanytjaku. Palulanguru Wupalu Niyuminya nyunytjura palumpa ngulytjukutu yanu, rawa nyinanytjaku, kanya Ruutjalu watjaṉu, “Wiyaṉanta wantikatiku, tjunguli yankula nyinaku ngurra kutjungka. Nyuntupa walytja tjuṯakuṉa walytjarringkula yilta tjana ngayuku walytja tjuṯa nyinaku. Nyuntupa mayutjuku Katutjakuṉa ngayulu yunytjurrinyi, palumpa tjukarurru nyinanytjaku. Yilta paluru ngayuku mayutjulpi nyinaku. Ngayulu kutu nyuntulawana nyinamalpa, nyuntu wiyarringkunytjala. Ngayuluṉa ngurra palula nyinarra wiyarringkunytjala tjunkuṉiya nyuntulawana.” Palulanguru Niyumilu wiya watjaṉu ngurra walytjangka nyinanytjaku. Paluru kutjarrapula tjungu yanu tawunu Pitjiliyamalakutu. Tjana tawunu palunya ngurrara tjuṯaya nyakula yunyparringu. Niyumilu tjananya watjaṉu waḻukutangku yuḻṯungku. ");
INSERT INTO piu2006_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","23","Ngurrangka nyinarra Ruutjalu Niyuminya watjaṉu, “Kuwarriṉa yanku, kaanangka mangarri muṯura wantingutja tjuṯa mantjintjaku. Mungarrtjiṉanta ngalya katirra yungku.” Yitjurilaku ngaṉṯitja tjuṯaku luwu ngaranytjala maralpa tjuṯangku mangarri muṯura wantipayi tjuṯa mantjilpayi. Yankula Ruutjalu kaana tiṉangka nyangu waarrkana tjuṯangku mantjirinkupayi. Paluru yankula tjanampa mayutju tjapiṉu, waarrkana tjuṯangka ngaṉṯiwana mantjirinkunytjaku. Mayutju paluru yuwa watjaṉu Ruutjalu mantjintjaku mangarri tjuṯa. Ruutjalu rawa mantjirinkula mangarri tjuṯa, paluru katirra tjunkupayi, mungarrtji ngurrakutu katikitjangku. Palulanguru kaanaku mayutju yini Puwatjalu yankula tjananya kaanaku waarrkana tjuṯangka kuutayi watjaṉu. Puwatjalu Ruutjanya nyakula muṯulpayi tjuṯaku mayutjungka yalatji tjapiṉu, “Kungka nyarratja ngananya?” Mayutju paluru watjaṉu, “Paluru yaṉangu kutjupa, Muwapanya ngurrara. Niyuminyapula tjungu nyinanyi.” Palulanguru Puwatjalu yankula Ruutjanya watjaṉu, “Kaana ngaawana kutju nyuntu mantjirinkunytjaku, ngayuku kungka waarrkarripayi tjuṯangka. Waarrkana wati nyarra tjuṯangka ngayulu watjalku nyuntunyantaya wantinytjaku. Nyuntu kapiku paarritjirrirra turaama nyarra tjuṯangka yankula tjikintjaku.” Ruutjalu kuliṉu, “Wati ngaatjanya walytjawiyatju, ngayukutju ngurrpa. Nyaaku paluru ngayunya kulira yaṉṯayaṉṯalkitjangku watjaṉu?” Ruutjalu Puwatjanya yalatji watjaṉu, “Ngayuluṉa yaṉangu kutjupa, Muwapanya ngurrara. Nyaakutjunu nyuntu ngayunya palya kuliṉu?” Puwatjalu watjaṉu, “Ngayuluṉa kuliṉu nyuntu ngunyarri yaṉṯayaṉṯalpayi, wantinytjawiyangku. Ngurra walytja nyuntu wantirra ngalya yanu ngaakutu, ngunyarri katiyankula kanyilkitja. Yunytjurringanyiṉa Katutjalunta tjukarurru palyara yaṉṯayaṉṯantjaku.” Ruutjalu kutu mantjirinkula mungarrtji mangarri tjuṯa yuḻpura tjunkupayi tiitjingka. Mantjira katingu ngurrakutu, Niyumilupula ngalkuntjaku. Ruutjanya yankula ngurrangka tjarrpangu. Niyumilulpi tjapiṉu, “Kaana nyaalytjingkanu mangarri ngaa tjuṯa mantjiṉu?” Ruutjalu watjaṉu, “Wati yini Puwatjaku kaanangka.” Kulira Niyumi paluru yunyparringkula watjaṉu, “Puwatjanya ngalimpa walytja. Ngayuluṉa yunytjurringanyi panya Katutjalu palunya yaṉṯayaṉṯantjaku, nyuntunya paluru watjaṉu mangarri mantjirinkunytjaku. Puwatja paluru ngalinya yaṉṯayaṉṯantjaku, yalatji luwulampa ngaranyi.” Palulanguru Ruutjalu rawangku mangarri kaana palula mantjirinkupayi. ");
INSERT INTO piu2006_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","18","Wulkumanu Niyumilu Ruutjaku miiṯa mantjilkitjangku Ruutjanya yalatji watjaṉu, “Mungangka kuwarri nyuntu Puwatja palulakutu yankula tjapila!, palurunta ngula palumpaṉu ngurrangka nyuntunya marriṯi kanyintjaku. Paluru kuwarri mungangka waarrkarriku waaḻa panyapangka.” Puwatjanya paluru waarrkarringkulalpi yankurringu. Ngarrirra kanarringkula kungka nyangu. Paluru tjapiṉu, “Ngananya nyuntu?” Ruutjalu watjaṉu, “Ngayulu Ruutjanya. Nyuntu ngayuku walytja ilatja nyinanyi. Nyuntu ngayunya ngurrangka yaṉṯayaṉṯara kanyintjaku, yalatji luwulampa ngaranyi. Tjapiṉiṉanta tjinguru nyuntu kuliṉi ngayunya kanyintjaku marriṯi mantjira?” Puwatjalu kulira watjaṉu, “Nyuntu kungka palyalingku, walytja tjuṯaku kulilpayi. Ngayulu tjiḻpi nguwanpa nyuntuṉi tjapiṉu, yangupala kutjupa tjuṯaku kulintjawiyangku. Kungka kutjupa tjuṯangkuya yangupalaku kutju kulilpayi. Panyapan tjukarurru watjaṉu, iltaṉa walytja nyuntupa ilatja nyinanyi. Wati kutjupaṯarra ilatja nyinanyi, paluru yurrunpa nyuntunya yaḻṯinytjaku, luwulampa yalatji ngaranyi. Aaḻi ngayulu yankula wati palunya tjapilku, palurulpi nyuntunya yaḻṯirra kanyintjaku. Tjinguru paluru wiya watjantjala, ngayuluṉanta yaḻṯirra kanyilku. Tjukarurruṉanta watjaṉi Katutjala kurungka.” Tjaalpa yiitjipula ngarringu tayilayitirringu. Puwatjalu pakara watjaṉu, “Mangarri ngaatjanya katirra Niyumiku yuwa!” Ruutjalu mangarri palunya katirra Niyumikura yungkula tjakultjunu, Puwatjalu watjaṉutjangka. ");
INSERT INTO piu2006_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","22","Ruutjanya mangarri yungkula Puwatjanya yanu tawunu Pitjiliyamalakutu purikutu. Puri palula wati tjuṯa tjungurringkula wangkapayi. Walytja ilatja palunya Puwatjalu nyakula yaḻṯingu, mayutju kutjupa tjuṯaṯarra, nyinarraya kulintjaku. Tjunguya nyinarra Puwatjalu walytja ilatja palula yalatji watjaṉu, “Niyuminya waḻukuta paluru ngurra walytja tjalamilalkitja yunytjurringanyi. Ngurra an waaḻa palumpa nyuntu payimilara palumpa ngunyarri Ruutjanyaṯarra nyuntulpi yaḻṯirra kanyintjaku, wati kutjupangku pulanya yaṉṯayaṉṯantjawiyangka. Yalatji luwulampa ngaranyi.” Wati paluru Puwatjaku wangka kulira wiya watjaṉu yalatji, “Wiya. Nyuntulpi ngurra palumpa payimilala!, ngayulu wantinyi.” Wati kutjupa tjuṯangka kurungka wati paluru puuta yarralytjankula yungu Puwatjaku. Yirriṯiya yalatji puuta yungkupayi mayutju tjuṯangka kurungka, ngurra payimilalkitjangku. Palulanguru Puwatjalu Niyumiku ngurra, waaḻa payimilara yankula Ruutjanya yaḻṯingu, palumpa miiṯalpi nyinanytjaku. Nyinarrapula katjalpi yini Yuupitanya mantjiṉu. Kapaḻi tjuṯaya Niyuminyaṯarra yunyparringu tjamu Yuupitaku. Yuupitalu watirringkula katja Tjiitjiyinya mantjiṉu. Tjiitjiyilulpi watirringkula katja Tapitanya mantjiṉu. ");
INSERT INTO piu2006_vpl VALUES ("S11_1","010_1_1","1SA","1","1","18","Yipurimaku walytja ngaṉṯitja ini paluru nyinangu Ilkananya. Wati paluru kanyiṉingi kungka kutjarra, kungka kutju ini Pininanya, kutjupa ini Yananya. Pininalu pipirri maṉkurrpa kanyiṉingi. Paluru watjalpayi, “Ngayulu pipirri maṉkurrtjarra, kanya nyuntu pipirriwiyakampa.” Yananya pipirri wiyapilkungku kulira ulapayi, mayiṯarra ngalkuwiyangku wantipayi, tjilurungku. Ngurra Tjaluwakutuya tjungu anu tjaatji kalikingka Katutjanya waḻkuntjakitja. Yanalu tjaatji palula pupakatirra Katutjanya tjapilpayi. Pakara ularra Katutjanya wangka unnguwanangku alatji tjapilpayi, “Mayutju tiṉa Katutja, kulilatju!, kuunyingkuṉanta tjapiṉingka. Nyuntutjunu katja yunganyingka, ngaparrtjiṉanta katja palunya yungku, tjukarurru nyuntupa nyinanytjaku. Mangka muṯuntjawiya nyinaku, nyuntupa waarrkana ilta.” Alatjingkuya mangka muṯuntjawiya wantipayi, Katutjaku waarrkana nyinakitjangku. Kutu Yanalu Katutjanya tjapilpayi wangka unnguwanangku. Ingkaṯa Yilayilu Yananya watjaṉu, nyakula waamatjanu ramakutjura kulira payiṉu, kanya Yanalu watjaṉu, “Waamatjanu wiyaṉa, tjilurungkumpaṉa Katutjanya tjapiṉingi.” Yilayilu watjaṉu, “Palya, unytjurringanyiṉanta Katutjalunta ungkunytjaku, nyuntu tjapiṉutjangka.” Yananya pakara anu. Mayi ngalkuṉingi watjilpawiyalpi nyinarra. ");
INSERT INTO piu2006_vpl VALUES ("S11_19","010_1_19","1SA","1","19","28","Ngurra ini Ramakutuya maḻaku yankula nyinangi. Ilkananya Yananya tjungulpi ngarrirra, Yananyalpi mukalatjarrarringkula nyinangi, Katutjalura ungutjangka. Kala, Yanalu katja mantjira ini tjunu Tjamiyulanya. Tjamiyulanya pipirri tiṉarringkula ipi tjikilwiyalpi nyinangi. Palunyatjanu Yanalupula Ilkanalu Tjamiyulanya katingu Katutjaku tjaatjikutu. Ingkaṯa Yilayinya Yanalu tjapiṉu, “Kuliṉimpatjun? Ngaangka pupakatirraṉa Katutjanya yurrunpa tjapilpayi. Palunyatjanu katja ngaatjatju ungu, tiṉarringkula Katutjaku waarrka palyantjaku.” Yalatji tjaatji kalikingkapula Tjamiyulanya ungkula wantirra ngurrakutulpi anu. Tjamiyulanya pipirri kutu tjaatjingka waarrkarrirra nyinangi, ingkaṯa Yilayilu purinytju kanyiṉingka. ");
INSERT INTO piu2006_vpl VALUES ("S12_12","010_2_12","1SA","2","12","25","Yilayiku katja kutjarra watipula nyinangi, ini Wupuninyakamu Piniyatjanya. Paluru kutjarrapula tjaatji kalikingka tjananya nintilpayi. Paluru kutjarra ingkaṯa nyinangi. Paluru kutjarra Katutjaku wangkawanalu wiya tjukarurru palyalpayi. Mayutju paluru kutjarrangkupula waarrkana iyalpayi, ankula kuka kana kuntara mantjintjaku tjawirrilyingka, tuḻkuku mayutjungku lirri muṯuṉingka. Ngunytjinytjungkupula yalatji palyalpayi, tjawirrilyikuṉu luwu kaṯantara. Ngaṉṯipula kuka yuṉmi mantjinmara, Katutjalu watjaṉingka. Kala, paluru kutjarrangku tjananya tjaatjingka waarrkarripayi tjuṯa kungka waarrkana waṉngira katipayi. Tjiḻpi Yilayilu pulanya yalatjilulpi payiṉu, “Nyaakupulan wiyawanalu kuya palyaṉi? Tjuṯangkukunyuṉiya tjakultjura nyinapayi, kuyapulan kutu palyaṉingka. Kuya palyalwiyapula wanti!, Katutjaluntapula yitjipungkuyankupayingka.” Kuya palyalpayipula tjukarurrurrinytjawiya, puṯu pulanya pinangkatjunu. Kala, pulanya Katutjalu mirri pungkukitjalu kuliṉu. ");
INSERT INTO piu2006_vpl VALUES ("S13_1","010_3_1","1SA","3","1","18","Yilayinyakamu pipirri Tjamiyulanya waṉmapula ngarringi mungangka. Tjamiyulanya laampa kampanyingka anku ngarripayi, Katutjaku pukutjungka ila, puḻi wirulypa kutjarratjarrangka. Tjamiyulanya ngururrkuturringkula anku ngarrinyingka, mayutju Katutjalu kanara aḻṯipayi, “Tjamiyula.” Tjamiyulalu kulira kanarrirra watjaṉu, “Ngaatjaṉa ngarrinyi.” Yilayilu aḻṯinytjalakutjura kulira Tjamiyulalu pakara ankula tjiḻpingka watjaṉu, “Nyuntutjunu aḻṯinyingkaṉa ngalya anuṉa.” Yilayilu watjaṉu, “Wiyaṉanta aḻṯingu, inytjamingka ankula ngarrikati!” Kala, Tjamiyulanya ankula piyuku inytjamingka ngarrikatingu. Mayutju Katutjalu piyuku kanara aḻṯingu, “Tjamiyula.” Palunyatjanu Tjamiyulalu kulira kanarrirra pakara ankula Yilayingka puṯu tjapiṉu. Puṯu tjapira piyuku ankula ngarrikatingu. Mayutju Katutjalu piyuku Tjamiyulanya kanara aḻṯingu. Tjamiyulanya pakara ankula Yilayinya watjaṉu, “Nyuntutjun aḻṯinyingkaṉa ngaatja ngalyanuṉanta.” Yilayinya pina aḻarringkulalpi kuliṉu, mayutju Katutjalumpa Tjamiyulanya aḻṯingi. Palunyatjanu watjaṉu, “Ankula ngarrikati! Piyukunta kanara aḻṯinyingka, alatji watjala!, ‘Mayutju. Watjalaṉi waarrkanaluṉanta kuliṉi.’” Palunyatjanu Tjamiyulanya piyuku ankula ngarrikatingu. Mayutju Katutjalu ngalyankula Tjamiyulanya ngururrpa nguwanpa aḻṯingu, “Tjamiyula.” Tjamiyulalu kulira watjaṉu, “Mayutju, watjalaṉi! Waarrkanaluṉanta kuliṉi.” Mayutju Katutjalu Tjamiyulanya watjaṉu, “Ngulaṉa tjananya puḻkara yitjipungku, Yitjurilaku ngaṉṯitja tjuṯa. Yilayiku katja kutjarraṉa mirri pungku, palumpa walytja tjuṯaṯarra. Panyapaṉa tjiḻpi Yilayingka yurrunpa watjaṉu, palumpa walytja tjuṯa yitjipungkukitjangku. Palumpa katja kutjarrangku kuya palyaṉingka, Yilayinya ninti nyinangi. Yurrunpa pulanya marrkulmara tjukarurrulkitjangku. Yurrunpa marrkuntjawiyangka Yitjurilaku ngaṉṯitja tjuṯangkutjuya tjawirrilyi ngalya katirra puṯu yungku. Kuyaṉa tjanampa wiya waṉiku.” Aaḻilingku pakara Tjamiyulalu rawa ngarrirra ngaṉṯi pakara tjaatji aḻaṉu. Yilayinya tjakultjunkutjipingkamarra nguḻu nyinangi. Yilayilulpi aḻṯingu, “Uḻa, ngalya yarra!” Tjamiyulalu maa ankula ngarala watjaṉu, “Ngaatjaṉa ngaranyi.” Yilayilu tjapiṉu, “Mayutju Katutjalunta mungangka nyaa watjaṉu? Wangka tjuṯatju watjala!, wangka wantiwiyangku, Katutjalunta ngaparrtji yitjipungkupayingka.” Palunyatjanu Tjamiyulalu wangka tjuṯa Katutjalu watjantja tjakultjunu. Yilayilu kulira watjaṉu, “Palya mayutju Katutjalu tjukarurru kulira palyalpayi.” ");
INSERT INTO piu2006_vpl VALUES ("S13_19","010_3_19","1SA","3","19","21","Tjamiyulanya watirringkula Katutjaku tjukarurru nyinapayi Yalatji nintiṉingka wangka iltarripayi. Palunyatjanu aṉangu tjuṯaya ninti nyinangi, Tjamiyulalu Katutjaku wangka tjukarurru watjalpayingka. ");
INSERT INTO piu2006_vpl VALUES ("S14_1","010_4_1","1SA","4","1","18","Pilitjiyanya ngurrara tjuṯaya tjungurringu Yitjurilaku ngulytju ngaṉṯitja tjuṯanya tjananya pikangku pungkukitja. Yitjurilaku ngaṉṯitja tjuṯa tjilirratjarra tjuṯalingku ankula nyinangu ngurra Yipinitjangka, Pilitjiyanya ngurrara tjuṯa tjananya pikangku pungkukitja. Ngurra Yipinitjangkaya nyinanyingka, Pilitjiyanya ngurrara tjuṯangku tjananya kuḻaṯatjarrangku ngalya ankula mirri pungkuyinangi, tjawutjuna puupala. Palunyatjanu Yitjurilaku ngaṉṯitja tjuṯangku nguḻurringkula watjaṉu Katutjaku pukutju puḻi wirulypa kutjarratjarra, ankulaya ngurra Tjaluwangka mantjira ngalya katikitjangku. Kuliṉuya yalatjingku, “Pukutju palunya kanyiralatju palya pikangku pungkula wantirriyalku.” Pukutju palunyaya ankula mantjira ngalya katinyingka Yitjurilaku ngaṉṯitja tjuṯaya kuḻaṯatjarra tjuṯaya yunyparringu. Palunyatjanungkuya Pilitjiyanya ngurrara tjuṯangku piyuku ngalyankula, tjuṯalingku mirri pungkula wiyaṉu tjawutjuna tjaaṯiyipala. Kanya Pilitjiyanya ngurrara tjuṯangku tjananya Yilayiku katja kutjarraṯarra, mirri pungkula Katutjaku pukutju palunya mantjira katirra kanyiṉingi. Kuḻaṯatjarra kutju tjalkaḻungu kanarrirra ngurra Tjaluwakutu. Ankula tjananya tjakultjunu, kuliraya nguḻurrirra ularra waṉingi. Yilayilu kulira tjiiyingka nyinarra tjuḻurrwangkarra punkara mirrirringu. Paluru tuḻkuku mayutju tjanampa kuḻi puutiyipala nyinarra yalatji mirrirringu. Kanya Piniyatjaku miiṯa muṯi purrka nyinangi. Piniyatjanya mirrirrinytjala kulira wiyarringu, Katutjaku pukutju katingutjangkaṯarra kulira. Mirrirrirra katjalpi mantjiṉu. ");
INSERT INTO piu2006_vpl VALUES ("S15_1","010_5_1","1SA","5","1","12","(5:1—6:12) Pilitjiyanya ngurrara tjuṯangkuya Katutjaku pukutju mantjira katingu, tawunu Yatjatatakutu. Katirraya tjaatji nguwanpa palulaya Katutjanya nguwanpa Tiikunanya puḻkapungkupayi. Tjaatji palula Tiikunanya puḻitjanu palyaṉutja, ngururrpa aṉangu nguwanpa ngarangi. Puḻi palulaya ila Katutjaku pukutju ngarritjunkula wantingu. Mungawinki pakara tjaatji palulakutuya ankula nyakula karrawurringu, Tiikunanya punkara Katutjaku pukutjungka waṯungaranyingka. Aṉangu mayutju tiṉa puḻkapungkukitja nguwanpa waṯungarangi. Nyakulaya ampura katura ngaratjunu, Tiikunanya puḻitjanu palyaṉutja. Mungawinki kutjupaya ngalya ankula piyuku nyangu, Tiikunanya punkara pukutju palula waṯungarayananyingka. Punkara kilytjukatirra ngarrirra waṉingi, miṉa kutjarra, kataṯarra. Palunya tjanampa palunya ngurrara tjuṯangka puyila taḻṯu pakara ngarala waṉingi. Katutjalu tjananya mirri pungkutjipingka, nguḻurrirraya yalatjilu watjaṉu, “Yitjurilaku mayutju tiṉangkulanya Katutjalu yitjipunganyi, nganampa mayutju Tiikunanyaṯarra punkatjingaṉingi. Katutjaku pukutju palatja waṉma katinytjaku, ngaangka ngarrinytjawiya.” Puṯu kuliraya maa katirra Katutjaku pukutju palunya ngarritjunu tawunu Kaatjangka. Kaatjanya ngurrara tjuṯaṯarra tjananya mayutju Katutjalu yitjipungu. Palunyatjanu tjanampa puyila tjuṯa pakara ngarala waṉingi. Palulanguruya ngurra palula nyinapayi tjuṯangkuya nguḻurrirra Katutjaku pukutju palunya tawunu kutjupakutu wantirriyaṉu, Yikuranakutu. Palunya ngurrara tjuṯangkuya nyakula nguḻurrirra watjaṉu, “Yitjurilaku ngaṉṯitja tjuṯaku pukutju palatjaya ngalya katingu, mayutju Katutjaku pukutju, nganaṉanyalpilanya mirrintankukitjangku. Pukutju palatjaya maa wantirriyala walytja tjuṯakutu!, Yitjurilaku ngaṉṯitja tjuṯakutu.” Palunyatjanu Pilitjiyanya ngurrara tjuṯangku pukutju palunya wakinangka kaḻpatjunkula maa wantirriyaṉu tawunu Piitjimitjikutu, Yitjurilaku ngaṉṯitja tjuṯakutu. Tjawirrilyiya puḻi kuultatjanu palyaṉutja, tjunginpa nguwanpa payipala tjunkula wantirriyaṉu, puyila taḻṯu nguwanpa palyaṉutja payipalaṯarra. Puluka kutjarrangkupula wakina palunya ruutuwana katirra ngurra Piitjimitjikutu tjukarurru katingu, Pilitjiyanya ngurrara mayutju payipalaluya maa nyakula wanantjangka. Katutjaku pukutju pulukalupula ngalya katingitjangka Yitjurilaku ngaṉṯitja tjuṯangku nyakula yunyparringu. Wiita muṯuranarraya pakara nyangu. Nyakulaya ankula puluka palunya kutjarra mirri pungu, tjawirrilyi kutjalkitjangku. Pukutjuya mantjira tjunkula wakinaya kilytjuntankula warulpi kutjaṉu. Puluka kutjarra ngarritjunkula Katutjaku tjawirrilyi kutjaṉu. Wati tjuṯangkuya Katutjaku pukutju aḻara nyangu puḻi kuultatjanu palyaṉutja tjuṯa. Aḻalwiyangkuya wantimara, tuḻkuku mayutjulu kutju aḻara nyakunytjaku. Ngurrpangku nguwanpaya aḻaṉutjangka Katutjalu tjananya mirri pungu, Piitjimitjinya ngurrara wati tjuṯa tjapantiyipala. Yitjurilaku ngaṉṯitja kutjupa tjuṯakutuya wikarru wantirriyaṉu. Tjana tjananya aḻṯingu Yitjurilaku ngaṉṯitja kutjupa ngurrara tjuṯangku ngalyankula, Katutjaku pukutju mantjira maa katinytjaku. ");
INSERT INTO piu2006_vpl VALUES ("S16_1","010_6_1","1SA","6","1","12","(5:1—6:12) Pilitjiyanya ngurrara tjuṯangkuya Katutjaku pukutju mantjira katingu, tawunu Yatjatatakutu. Katirraya tjaatji nguwanpa palulaya Katutjanya nguwanpa Tiikunanya puḻkapungkupayi. Tjaatji palula Tiikunanya puḻitjanu palyaṉutja, ngururrpa aṉangu nguwanpa ngarangi. Puḻi palulaya ila Katutjaku pukutju ngarritjunkula wantingu. Mungawinki pakara tjaatji palulakutuya ankula nyakula karrawurringu, Tiikunanya punkara Katutjaku pukutjungka waṯungaranyingka. Aṉangu mayutju tiṉa puḻkapungkukitja nguwanpa waṯungarangi. Nyakulaya ampura katura ngaratjunu, Tiikunanya puḻitjanu palyaṉutja. Mungawinki kutjupaya ngalya ankula piyuku nyangu, Tiikunanya punkara pukutju palula waṯungarayananyingka. Punkara kilytjukatirra ngarrirra waṉingi, miṉa kutjarra, kataṯarra. Palunya tjanampa palunya ngurrara tjuṯangka puyila taḻṯu pakara ngarala waṉingi. Katutjalu tjananya mirri pungkutjipingka, nguḻurrirraya yalatjilu watjaṉu, “Yitjurilaku mayutju tiṉangkulanya Katutjalu yitjipunganyi, nganampa mayutju Tiikunanyaṯarra punkatjingaṉingi. Katutjaku pukutju palatja waṉma katinytjaku, ngaangka ngarrinytjawiya.” Puṯu kuliraya maa katirra Katutjaku pukutju palunya ngarritjunu tawunu Kaatjangka. Kaatjanya ngurrara tjuṯaṯarra tjananya mayutju Katutjalu yitjipungu. Palunyatjanu tjanampa puyila tjuṯa pakara ngarala waṉingi. Palulanguruya ngurra palula nyinapayi tjuṯangkuya nguḻurrirra Katutjaku pukutju palunya tawunu kutjupakutu wantirriyaṉu, Yikuranakutu. Palunya ngurrara tjuṯangkuya nyakula nguḻurrirra watjaṉu, “Yitjurilaku ngaṉṯitja tjuṯaku pukutju palatjaya ngalya katingu, mayutju Katutjaku pukutju, nganaṉanyalpilanya mirrintankukitjangku. Pukutju palatjaya maa wantirriyala walytja tjuṯakutu!, Yitjurilaku ngaṉṯitja tjuṯakutu.” Palunyatjanu Pilitjiyanya ngurrara tjuṯangku pukutju palunya wakinangka kaḻpatjunkula maa wantirriyaṉu tawunu Piitjimitjikutu, Yitjurilaku ngaṉṯitja tjuṯakutu. Tjawirrilyiya puḻi kuultatjanu palyaṉutja, tjunginpa nguwanpa payipala tjunkula wantirriyaṉu, puyila taḻṯu nguwanpa palyaṉutja payipalaṯarra. Puluka kutjarrangkupula wakina palunya ruutuwana katirra ngurra Piitjimitjikutu tjukarurru katingu, Pilitjiyanya ngurrara mayutju payipalaluya maa nyakula wanantjangka. Katutjaku pukutju pulukalupula ngalya katingitjangka Yitjurilaku ngaṉṯitja tjuṯangku nyakula yunyparringu. Wiita muṯuranarraya pakara nyangu. Nyakulaya ankula puluka palunya kutjarra mirri pungu, tjawirrilyi kutjalkitjangku. Pukutjuya mantjira tjunkula wakinaya kilytjuntankula warulpi kutjaṉu. Puluka kutjarra ngarritjunkula Katutjaku tjawirrilyi kutjaṉu. Wati tjuṯangkuya Katutjaku pukutju aḻara nyangu puḻi kuultatjanu palyaṉutja tjuṯa. Aḻalwiyangkuya wantimara, tuḻkuku mayutjulu kutju aḻara nyakunytjaku. Ngurrpangku nguwanpaya aḻaṉutjangka Katutjalu tjananya mirri pungu, Piitjimitjinya ngurrara wati tjuṯa tjapantiyipala. Yitjurilaku ngaṉṯitja kutjupa tjuṯakutuya wikarru wantirriyaṉu. Tjana tjananya aḻṯingu Yitjurilaku ngaṉṯitja kutjupa ngurrara tjuṯangku ngalyankula, Katutjaku pukutju mantjira maa katinytjaku. ");
INSERT INTO piu2006_vpl VALUES ("S17_1","010_7_1","1SA","7","1","6","Katutjaku pukutju palunyaya yitjurilaku ngaṉṯitja tjuṯangku ngurra Kiriyatjimalakutu katirra kanyiṉingi, kuḻi tuuntiyipala. Wati Yapinatapaku waaḻangka ngarringu. Palumpa katja Yalitjanyaya nyinatjunu, tuḻkuku mayutjulu pukutju palunya aṉṯaṉṯara kanyintjaku. Palunyangka ngurra tjuṯawanaluya Yitjurilaku ngaṉṯitja tjuṯangku Katutjanya tjapiṉingi, Pilitjiyanya ngurrara tjuṯangku tjananya yitjipungkuwiyalu wantinytjaku. Tjamiyulalu tjananya yalatjingku watjaṉu, “Tjukarurru nyinarranyurra mayutju Katutjanya kutju puḻkapungkunytjaku, Katutjanya nguwanpa kutjupa tjuṯa puḻkapungkuwiyalu. Katutjaku kutjunyurra tjukarurru nyinanytjaku. Paluru nyurrampa, Pilitjiyanya ngurrara tjuṯa pungkula wantirriyalku.” Palunyatjanuya Yitjurilaku ngaṉṯitja tjuṯangkuṯarraya Katutjanya nguwanpa tjuṯa Paalanyaṯarra waṉirralpi wiyara, Katutjanyalpi kutju tjukarurrungku waḻkuṉingi. Tjamiyulalu tjananya Yitjurilaku ngaṉṯitja tjuṯa aḻṯingu, ngalya ankulaya ngurra Mitjipangka tjungurrinytjaku. Tjungurringkulaya mayi ngalkuwiyangku wantirra kuya palyaṉutjangku tjakultjunkula Katutjanyalpi puḻkapungu. ");
INSERT INTO piu2006_vpl VALUES ("S17_7","010_7_7","1SA","7","7","11","Yitjurilaku ngaṉṯitja tjuṯaluya ngurra Mitjipangka tjungurrirra tjakulpa kuliṉu, Pilitjiyanya ngurrara tjuṯaya tjungurringanyingka. Pikaṯi tjuṯangku tjananya ngalyankula pungkukitja, kanya Yitjurilaku ngaṉṯitja tjuṯangku nguḻurringkula Tjamiyulanyalpi tjapiṉu yalatjingku, “Katutjanyalampa kutu tjapinma!, Pilitjiyanya ngurrara tjuṯangkulanya ngalya ankula mirri pungkupayingkamarra.” Tjamiyulalu tjiipi wiima pungkula tjawirrilyi kutjaṉu, mayutju Katutjaku. Yalatji kutjara tjanampa Katutjanya tjapiṉu. Kanya yalatji tjawirrilyi kutjara tjapirananyingka, Pilitjiyanya ngurrara tjuṯa pikaṯi yila ngalya anangi, pungkukitja. Kanya Katutjalu puntura wangkatjingaṉu. Kapi tuutuurinangi nguwanpa kulira nguḻu puḻkarrirra ngaṉṯikutu tjalkatjalkaḻungu. Nguḻunytju tjuṯa tjananya Yitjurilaku ngaṉṯitja tjuṯangkuya pikaṯi tjuṯa tjananya wanara mirri pungkuyinangi. ");
INSERT INTO piu2006_vpl VALUES ("S17_12","010_7_12","1SA","7","12","17","Yalatji tjananya Pilitjiyanya ngurrara tjuṯa mirri pungkula nguḻutjingara wantirriyaṉu, Yitjurilaku ngaṉṯitja tjuṯangku. Palunyatjanu Pilitjiyanya ngurrara tjuṯangku tjananya yitjipungkuwiyangku wantingu, Tjamiyulanya kana nyinanyingka. Tjamiyulalu puḻi tiṉa mantjira ngaratjunkula tjananya watjaṉu, “Puḻi ngaatjanya ini alatji, ‘Pungkunytjatjanunya ngaatja ngaranyi.’ Ngulala nyakula alatjingku kulintjaku, ‘Yilta Katutjalulampa Pilitjiyanya ngurrara tjuṯa yitjipungu, ngurra ngaangka.’” Tjamiyulanya mayutju nguwanpa tjanampa nyinangu, Yitjurilaku ngaṉṯitja tjuṯaku. Ngurra puupalakutu rawa ankupayi, kuutawutjuku mayutjulu tjananya kulira watjantjaku. Ngurra Ramangka tiipula nguwanpa puḻitjanu palyaṉu, Katutjaku tjawirrilyi kutjara puḻkapungkunytjaku. ");
INSERT INTO piu2006_vpl VALUES ("S18_1","010_8_1","1SA","8","1","21","Tjamiyulanya tjukarurru nyinarra tjiḻpirringu. Palumpa katja kutjarra pulanya Tjamiyulalu mayutju nyinatjunu. Mayutju tjukarurruwiyapula wiyawanalu palyalpayi. Palunyatjanu Yitjurilaku ngaṉṯitja tjuṯaku mayutju tjuṯaya tawunu Ramangka tjungurringu. Tjungurringkulaya Tjamiyulanya tjapiṉu, “Nyuntu mayutju palyalampatjunu nyinarra tjiḻpirringu. Nyuntupa katja kutjarrapula tjukarurruwiya nyinanyi. Palunyatjanulatju unytjurringanyi, mayutju kutjupa tiṉalampatju nyinatjurra! Mayutju tiṉatjarralpilatju nyinanytjaku, kutjupa ngurrara tjuṯaya mayutju tiṉatjarraya nyinanytja nguwanpa.” Tjamiyulalu wangka palunya kulira kuyarringu, mayutju tiṉakuya unytjurringkula tjapintjala. Mayutju Katutjaku kutjuya unytjurringkula nyinamara, mayutju tiṉa kutjuku. Palunyatjanu puṯu kulira Tjamiyulalu Katutjanya tjapiṉutjangka, Katutjalu alatji watjaṉu, “Wangka tjanampa kulila! Kulira tjananya watjala! Mayutju manta ngurrarangku kuyangku kanyilpayi.” Katutjalu Tjamiyulanya kutu watjaṉu, “Nyuntunya kutju wiyaya kulilwiyangku wantingu, ngayunya Katutjanyaṯarraya mayutju tiṉa kulilwiyangku wantingu. Katutjanya nguwanpa kutjupa tjuṯaya unytjurringkula puḻkapungkukitjangku. Kutuṉiya wantipayi.” Mayutju Katutjalu watjaṉutjangka, Tjamiyulalu alatji tjananya tjakultjunu, “Ngayulu nyurrangarrimpa mayutju tiṉa nyinatjunanyingka, paluru nyurrangarrinya kuyangku kanyilku. Nyurrangarrimpa katjapiṯi tjananya watjalku, kuḻaṯatjarrangku ankula kutjupa tjuṯa pungkunytjaku. Watjalku tjananya waarrka tiṉa kutjupaṯarra palyara nyinanytjaku. Waarrka tiṉatjarraya yilta nyinaku. Nyurrangarrimpa yuṉṯalpa tjuṯaṯarra tjananya mayutju paluru watjalku, puntura waarrkarrinytjaku. Nyurrangarriṯarra mayutju tiṉa palumpa waarrkana tjuṯa nyinarra waarrkarrirra nyinamalpa. Mayutju tiṉa paluru nyurranya watjalku, mayi pakaltjingara ngurrtjara mayutju tiṉa palunyanyurra ungkunytjaku. “Mayutju paluru nyurranya kuyangku kanyiṉingka, Katutjanyanyurra puṯu tjapilku, wapaḻpa nyinakitjangku. Kulira nyurranya wantiku, mayutju tiṉakunyurra unytjurringkula tjapiṉingitjangka.” Yaṉangu paluru tjanaya Tjamiyulaku wangka kulira wantirra kutu watjaṉingi, “Mayutju tiṉatjarralatju nyinakitjalatju unytjurringanyi, kutjupa ngurrara tjuṯaya mayutju tiṉatjarra nyinanytja nguwanpa. Mayutju tiṉalampatju yaḻṯirra nyinatjurra!” Tjamiyulalu kututja piyuku tjapiṉingka, Katutjalu watjaṉu, “Pala tjuṯangkuntaya tjapiṉingka mayutju tiṉa tjanampa ngurrtjara nyinatjurra!” Miitingi alatjiya wangkarra ngurrakutuya ankula waṉingu. ");
INSERT INTO piu2006_vpl VALUES ("S19_1","010_9_1","1SA","9","1","27","(9:1—10:27) Pintjiminaku walytja ngaṉṯitja wati Kiitjanya nyinangi. Kiitjalu katja Tjuulanya kanyiṉu, wati waṯawara palyalingku. Palumpa paapangku pulanya Tjuulanyakamu waarrkana kutjupa wantirriyaṉu, ankulapula Kiitjaku tuungkiyi tjuṯa ngurrira mantjira ngalya katinytjaku. Ankulapula puṯu ngurririnkula kuliṉu, tawunukutu ankula Katutjaku wangka watjalpayinya tjapilkitjangku. Tawunu palulakutu Tjuulalupula ankula kungka tjuṯa nyangu, ngalya ankuyinanyingka. Nyakula tjananyapula tjapiṉu, “Katutjaku wangka nintilpayi palunya tawunu palangka nyinanyi?” Kungka tjuṯangku pulanya watjaṉu, “Yuwa, yilaya ngalya ananyi, Tjamiyulanya kutjupa tjuṯaṯarra, Katutjaku tjawirrilyi kutjara puḻkapungkukitja.” Ankulapula Tjamiyulanya nyangu, yila ngalya ananyingka. Kanya yurrunpa Katutjalu Tjamiyulanya alatji watjaṉu, “Tjiṉṯungkaṉanta wati kutju maa wantirriyalku, tjiṉṯu alangaangka, Pintjiminaku walytja ngaṉṯitja. Wati palula nyuntu tjira intila yurrunpa!, mayutju tiṉa nyurrampa ngula nyinanytjaku, Yitjurilaku ngaṉṯitja tjuṯaku. Wati paluru nyurranya kanyira kanalku, Pilitjiyanya ngurrara tjuṯangku nyurranya pungkutjipingkamarra.” Palunyangka Tjamiyulalu Tjuulanya ngalya ananyingka nyangu. Katutjalu Tjamiyulala watjaṉu, “Alapalatja, wati palunyaṉanta watjaṉu. Paluru nyurranya mayutju tiṉangku purinytju kanyilku.” Tjuulalu Tjamiyulanya kutjupakutjura tjapiṉutjangka, Tjamiyulalu alatji watjaṉu, “Yuwa, ngayuluṉa Katutjaku wangka watjalpayi. Yurrunpapula maa yarra!, tjawirrilyi kutjalpayi nyarrakutu! Tjungungkula kuwarri Katutjanya puḻkapungkuku miyikamu kuka ngalkula, ngayuku ngurrangkapulan ngarrirra tjiṉṯungka anku. Tuungkiyi palunya tjuṯaku kulilwiyangkupula wanti! Nyuntupa paapalu kala ngurrira mantjiṉu.” Tjawirrilyi palunya kutjarra tjungungkuya aṉangu tjuṯangku Katutjanya puḻkapungkula Tjuulaluṯarra kuka ngalkuṉu. Palunyatjanungku pulanya Tjamiyulalu palumpa ngurrakutu katirra ngarritjunu Tjuulanya pulanya maḻpararra. Tjiṉṯungka pakara Tjamiyulanya Tjuulanya palumpa maḻpa tjungu anu, waaḻa tjuṯawana. Ankula kalkuṉi ngarala Tjamiyulalu watjaṉu, Tjuulalu palumpa maḻpa yurrunpa wantirriyantjaku, paṯantjaku. Tjuulanya kutju ngaranyingka, Tjamiyulalu katangka tjira intira watjaṉu, “Tjiraṉanta intiṉu yurrunpa, mayutju Katutjalunta mayutju tiṉalampatju nyinatjunutjangka, Yitjurilaku walytja ngaṉṯitja tjuṯaku.” Palunyatjanupula Tjuulanya maḻpararra tawunu Kipiyakutu ankula tjananya nyangu Katutjaku wangka watjalpayi tjuṯa. Palunyangka Katutjaku kurrunpangku Tjuulanya pukuḻmananyingka, Tjuulanya Katutjaku yunyparrirra nyaṉpinyaṉpingu, Katutjaku wangka watjalpayi kutjupa tjuṯaya nyaṉpinyingka nguwanpa. Alatji nyaṉpinytjaku Tjamiyulalu yurrunpa watjaṉu, yiltarringkulalpi Tjuulanya nyaṉpingu. Aṉangu Tjuṯangkuya Tjuulanya nyakula watjaṉu, “Tjuulanyalpi Katutjaku wangka watjalpayi nyinanyi.” Kala Tjamiyulalu tjananya nyakula aḻṯingu, ngurra Mitjipangka Katutjaku tuḻkuku tjungurrinytjaku. Tjungurringkulaya nyinanyingka Katutjalu watjantja alatji tjananya Tjamiyulalu tjakultjunu, “Ngayuluṉa nyurrampa Katutjanya mayutju tiṉa nyinanyi. Paṉa Yitjipitjanu ngayulu tjananya nyurrangarrimpa mirrinytjanirri tjuṯa pakaltjingara, ngaakutu ngalya katirra nyinatjunu. Kuwarriṉinyurra wantingu nyurrangarrimpa mayutju tiṉa Katutjanya, aṉangu mayutju tiṉaku tjapintjatjanulu. Kalalpi, ngayulu Katutjalu mayutju tiṉalpi nyinatjunku.” Tjamiyulalu tjananya kutu watjaṉu, “Walytjararranpa tjuṯanyurra waṉmaṯu waṉmaṯu ngaranytjaku, Katutjala kurungka.” Alatji Tjamiyulalu mayutju tiṉa mantjilkitjalu walytjararranpa kutjuṯu kutjuṯu aḻṯingu, ngalya ankula Tjamiyulangkaya ngarala waṉinytjaku. Alatjiya walytjararranpa kutjuṯu kutjuṯu ngalya ankula ngaranyingka, Tjamiyulalu wati Kiitjaku walytja ngurrkantankula mantjiṉu. Palunyatjanu Tjamiyulalu watjaṉu wati Tjuulanya ngalya ankula ngaranyingka, mayutju tiṉa nyinatjunkukitjalu. Palunyatjanuya Tjuulaku puṯu nyakula ngurrira nyangulpi yulytja tiṉangka nguḻurringkula kumpiyananyingka. Ngalya katirraya ngaratjunanyingka Tjamiyulalu tjananya watjaṉu, “Alangaatjanyalampa mayutju tiṉa, mayutju Katutjalu ngurrkantankula nyinatjunutja.” Kuliraya yunyparrirra aṉangu tjuṯangkuya katungkuya watjaṉu, “Ngaatjanya mayutju tiṉalampa, rawa kutu nyinanytjaku.” ");
INSERT INTO piu2006_vpl VALUES ("S110_1","010_10_1","1SA","10","1","27","(9:1—10:27) Pintjiminaku walytja ngaṉṯitja wati Kiitjanya nyinangi. Kiitjalu katja Tjuulanya kanyiṉu, wati waṯawara palyalingku. Palumpa paapangku pulanya Tjuulanyakamu waarrkana kutjupa wantirriyaṉu, ankulapula Kiitjaku tuungkiyi tjuṯa ngurrira mantjira ngalya katinytjaku. Ankulapula puṯu ngurririnkula kuliṉu, tawunukutu ankula Katutjaku wangka watjalpayinya tjapilkitjangku. Tawunu palulakutu Tjuulalupula ankula kungka tjuṯa nyangu, ngalya ankuyinanyingka. Nyakula tjananyapula tjapiṉu, “Katutjaku wangka nintilpayi palunya tawunu palangka nyinanyi?” Kungka tjuṯangku pulanya watjaṉu, “Yuwa, yilaya ngalya ananyi, Tjamiyulanya kutjupa tjuṯaṯarra, Katutjaku tjawirrilyi kutjara puḻkapungkukitja.” Ankulapula Tjamiyulanya nyangu, yila ngalya ananyingka. Kanya yurrunpa Katutjalu Tjamiyulanya alatji watjaṉu, “Tjiṉṯungkaṉanta wati kutju maa wantirriyalku, tjiṉṯu alangaangka, Pintjiminaku walytja ngaṉṯitja. Wati palula nyuntu tjira intila yurrunpa!, mayutju tiṉa nyurrampa ngula nyinanytjaku, Yitjurilaku ngaṉṯitja tjuṯaku. Wati paluru nyurranya kanyira kanalku, Pilitjiyanya ngurrara tjuṯangku nyurranya pungkutjipingkamarra.” Palunyangka Tjamiyulalu Tjuulanya ngalya ananyingka nyangu. Katutjalu Tjamiyulala watjaṉu, “Alapalatja, wati palunyaṉanta watjaṉu. Paluru nyurranya mayutju tiṉangku purinytju kanyilku.” Tjuulalu Tjamiyulanya kutjupakutjura tjapiṉutjangka, Tjamiyulalu alatji watjaṉu, “Yuwa, ngayuluṉa Katutjaku wangka watjalpayi. Yurrunpapula maa yarra!, tjawirrilyi kutjalpayi nyarrakutu! Tjungungkula kuwarri Katutjanya puḻkapungkuku miyikamu kuka ngalkula, ngayuku ngurrangkapulan ngarrirra tjiṉṯungka anku. Tuungkiyi palunya tjuṯaku kulilwiyangkupula wanti! Nyuntupa paapalu kala ngurrira mantjiṉu.” Tjawirrilyi palunya kutjarra tjungungkuya aṉangu tjuṯangku Katutjanya puḻkapungkula Tjuulaluṯarra kuka ngalkuṉu. Palunyatjanungku pulanya Tjamiyulalu palumpa ngurrakutu katirra ngarritjunu Tjuulanya pulanya maḻpararra. Tjiṉṯungka pakara Tjamiyulanya Tjuulanya palumpa maḻpa tjungu anu, waaḻa tjuṯawana. Ankula kalkuṉi ngarala Tjamiyulalu watjaṉu, Tjuulalu palumpa maḻpa yurrunpa wantirriyantjaku, paṯantjaku. Tjuulanya kutju ngaranyingka, Tjamiyulalu katangka tjira intira watjaṉu, “Tjiraṉanta intiṉu yurrunpa, mayutju Katutjalunta mayutju tiṉalampatju nyinatjunutjangka, Yitjurilaku walytja ngaṉṯitja tjuṯaku.” Palunyatjanupula Tjuulanya maḻpararra tawunu Kipiyakutu ankula tjananya nyangu Katutjaku wangka watjalpayi tjuṯa. Palunyangka Katutjaku kurrunpangku Tjuulanya pukuḻmananyingka, Tjuulanya Katutjaku yunyparrirra nyaṉpinyaṉpingu, Katutjaku wangka watjalpayi kutjupa tjuṯaya nyaṉpinyingka nguwanpa. Alatji nyaṉpinytjaku Tjamiyulalu yurrunpa watjaṉu, yiltarringkulalpi Tjuulanya nyaṉpingu. Aṉangu Tjuṯangkuya Tjuulanya nyakula watjaṉu, “Tjuulanyalpi Katutjaku wangka watjalpayi nyinanyi.” Kala Tjamiyulalu tjananya nyakula aḻṯingu, ngurra Mitjipangka Katutjaku tuḻkuku tjungurrinytjaku. Tjungurringkulaya nyinanyingka Katutjalu watjantja alatji tjananya Tjamiyulalu tjakultjunu, “Ngayuluṉa nyurrampa Katutjanya mayutju tiṉa nyinanyi. Paṉa Yitjipitjanu ngayulu tjananya nyurrangarrimpa mirrinytjanirri tjuṯa pakaltjingara, ngaakutu ngalya katirra nyinatjunu. Kuwarriṉinyurra wantingu nyurrangarrimpa mayutju tiṉa Katutjanya, aṉangu mayutju tiṉaku tjapintjatjanulu. Kalalpi, ngayulu Katutjalu mayutju tiṉalpi nyinatjunku.” Tjamiyulalu tjananya kutu watjaṉu, “Walytjararranpa tjuṯanyurra waṉmaṯu waṉmaṯu ngaranytjaku, Katutjala kurungka.” Alatji Tjamiyulalu mayutju tiṉa mantjilkitjalu walytjararranpa kutjuṯu kutjuṯu aḻṯingu, ngalya ankula Tjamiyulangkaya ngarala waṉinytjaku. Alatjiya walytjararranpa kutjuṯu kutjuṯu ngalya ankula ngaranyingka, Tjamiyulalu wati Kiitjaku walytja ngurrkantankula mantjiṉu. Palunyatjanu Tjamiyulalu watjaṉu wati Tjuulanya ngalya ankula ngaranyingka, mayutju tiṉa nyinatjunkukitjalu. Palunyatjanuya Tjuulaku puṯu nyakula ngurrira nyangulpi yulytja tiṉangka nguḻurringkula kumpiyananyingka. Ngalya katirraya ngaratjunanyingka Tjamiyulalu tjananya watjaṉu, “Alangaatjanyalampa mayutju tiṉa, mayutju Katutjalu ngurrkantankula nyinatjunutja.” Kuliraya yunyparrirra aṉangu tjuṯangkuya katungkuya watjaṉu, “Ngaatjanya mayutju tiṉalampa, rawa kutu nyinanytjaku.” ");
INSERT INTO piu2006_vpl VALUES ("S113_1","010_13_1","1SA","13","1","23","Palunyatjanuya Pilitjiyanya ngurrara tjuṯa tjananya pungkukitja, Tjuulanyaṯarra tjilirratjarra kutu tjungurringu, ngurra Kilkalangka. Pilitjiyanya ngurrara tjuṯalingku tjananya tjana nyakula Yitjurilaku walytja ngaṉṯitja tjuṯaya nguḻurringu. Tjamiyulalu tuḻkuku mayutjungku, yurruntu Tjuulanya marrkuṉu Kilkalangka tjungurringkula tjiṉṯu tjapanpala paṯantjaku. Tjuulaluṯarraya tjiṉṯu tjapanpala paṯara Tjamiyulaku puṯu nyangu. Palunyangkaya Tjuulaku waarrkana tjilirratjarra kutjupa tjuṯa tjanampa Pilitjiyanya ngurrara tjuṯa tiṉaku, nguḻurrirra maḻaku anu. Palunyangka Tjuulaku waarrkana kutjupa tjuṯa kutu nyinangi. Tjuulalu tjananya watjaṉu kuka tjawirrilyi ngalya katinytjaku, Tjamiyulaku kutu paṯantjawiyangku. Lirri muṯura Tjuulalulpi tjawirrilyi Katutjaku kutjaṉu, tuḻkuku mayutju nguwanpangku. Tjawirrilyi paluru kutu kampayananyingka, Tjamiyulanyalpi ngalya ankula Tjuulanya payiṉu, tuḻkuku mayutju nguwanpangku tjawirrilyi kutjantjatjanungka. Tjuulanya alatji watjaṉu, “Nyuntu Katutjaku tjukarurru nyinanytjawiya, mayutjuwiyalpinu nyinaku.” Alatji watjara Tjamiyulanya pinkulukatirra Tjuulanya wantirra anu. ");
INSERT INTO piu2006_vpl VALUES ("S115_1","010_15_1","1SA","15","1","35","Palunyatjanu ngurra kutjupangka nyinarra yankula Tjamiyulalu Tjuulanya alatji watjaṉu, “Mayutju Katutjalunta watjaṉu, nyurrangarri ankula tjananya Yamalikaku walytja ngaṉṯitja tjuṯa pikangku mirri pungkula wiyantjaku. Mirri pungkula tjananya puluka tjuṯa, tjiipi tjuṯa, kamula tjuṯa, tuungkiyi tjuṯa tjanampa nyurrangarri mirri pungkula wiyantjaku.” Palunyangkaya Tjuulaluṯarra tjilirratjarra tjuṯa ankula aṉangu tjuṯa tjananya mirri pungkuyinangi. Mayutju tiṉa tjanampa wati Yikakanya mirri pungkuwiyangku wantingu. Puluka kutjupa tjuṯa, tjiipi kutjupa tjuṯaṯarra mirri pungkuwiyangku wantingu. Palunyatjanu Tjamiyulalu Katutjaku wangka kulira Tjuulakutu ankula payiṉu puluka tjiipiṯarra mirri pungkuwiyangku kanyintjatjanungka. Tjamiyulalu Tjuulanya kutu tjapiṉingi payilkitjangku, “Nyaaku Katutjaku wangka kulilwiyangku tjiipiṯarra nyuntu mantjira ngalya katirra kanyiṉi?” Tjuulalu watjaṉu, “Nganaṉatju mirri pungkuwiyangku tjiipiṯarra ngalya katingu, tjawirrilyi Katutjaku ungkukitjangku.” Tjamiyulalu Tjuulanya watjaṉu, “Yaalytjin kuliṉi? Katutjanya nyaaku unytjurringanyi?, tjinguru tjawirrilyiku kutju?, tjinguru aṉangulura tjukarurrungku palyantjaku? Yilta, nyuntura tjukarurru palyanmara. Mirri tjuṯan pungamaran, aṉanguṯarra tjiipi, kamula, puluka, nanikutaṯarra. Nyuntu tjukarurru palyantjawiyangka, Katutjalunta marrkura mungutja nyinatjunku. Nyuntu mayutjuwiyalpi nyinaku, Katutjalu mayutju tiṉa kutjupalpi nyinatjunku.” Tjamiyulalu watjara pinkulukatirra Tjuulanya wantirra anu, pinkulukatirra nyakula kutu wangkanytjawiya. ");
INSERT INTO piu2006_vpl VALUES ("S116_1","010_16_1","1SA","16","1","13","Mayutju Katutjalu Tjamiyulanya alatji watjaṉu, “Tjuula palumpa ngaḻṯurrinytjawiya. Yitjurilaku walytja ngaṉṯitjaku nyurrampa mayutjuwiyalpi nyinaku. Tjira intilpayi mantjira tawunu Pitjiliyamakutu ankula Tjiitjiyiku katjangka intila!, mayutju nyinatjunkukitjangku. Palumpa katja tjuṯa nyinanyi. Kuliṉiṉa, kutju mayutju tiṉa nyurrampa nyinanytjaku.” Tjamiyulalu Katutjanya watjaṉu, “Puṯuṉa kuliṉu, Tjiitjiyiku katjaṉa mayutju nyinatjunanyingka, Tjuulalu kulira ngalya ankulaṉi mirri pungkupayingka.” Mayutju Katutjalu Tjamiyulanya watjaṉu, “Puluka tjukutjuku mantjira maa kati!, ngayuku tjawirrilyi pungkula kutjalkitjangku. Aṉangu tjuṯa tjananya aḻṯi!, tjungurringkulaṉinyurra Katutjanya tjungungku puḻkapungkunytjaku. Tjiitjiyiku walytja tjuṯaṯarra aḻṯi! Tjungurringkulaṉinyurra puḻkapungkukitjangku, kalaṉanta nintilku palumpa katjangka intintjaku.” Palunyangka Tjamiyulalu tawunu Pitjiliyamakutu tjina ankula aḻṯingu tjananya, tjungurrirra Katutjanya puḻkapungkunytjaku. Palunya ngurrara tjuṯaya tjungurrinytjala, Tjamiyulalu nyakula Tjiitjiyiku katja yurruntitja Yilayapanya kuliṉu, mayutju nyinatjunkukitjangku. Alatji paluru kuliṉu, “Alapalatja mayutju Katutjalu ngurrkantankula ngaratjunku, tjinguru wati palya waṯawara.” Mayutju Katutjalu alatji marrkuṉu, “Wiya wati palatjaya waṯawara yuṉpa palya ngaranytjaku kutju kulintjaku. Aṉangungku alatji kulilpayi mayutju tiṉa nyinakitjangku. Kanya ngayuluṉa kurrunpa nyakupayi, aṉangutju tjukarurru nyinanytja, yuṉpa palyaku kulintjawiyalu.” Tjamiyulalu wati Tjiitjiyinya watjaṉu palumpa katja kutjupa tjuṯa tjananya ngalya katirra kutjuṯu kutjuṯu ngaratjunkunytjaku. Tjiitjiyilu katja tiṉa kutjupa ngalya katirra ngaratjunu, yini Yapinatapanya. Tjamiyulalu nyakula watjaṉu, “Wiya ngaatjanya mayutju nyinanytjaku watjaṉu.” Palunyangka Tjiitjiyilu katja ini Tjamanya ngalya katirra ngaratjunu. “Ngaatjanya wiya mayutju nyinanytjaku watjaṉu.” Tjiitjiyilu alatji palumpa katja tjapanpala ngalya katirra ngaratjunkunytjala Tjamiyulalu wiya watjaṉu. Tjamiyulalu puṯu nyakula tjapintjala, Tjiitjiyilu watjaṉu, “Katja ngaṉṯitja waṉma waarrkarrinyi, tjiipi tjuṯa tjananya purinytju kanyiṉi.” Tjamiyulalu watjaṉu, “Wikarru wantirriyala!, palunya ngalyananyingka kutjula tjungulu tjawirrilyi kutjalku.” Ngalya ankula Tapitanya ngaranyingka, Tjamiyulalu muṯilya palya nyakula yunyparringu. Katutjalu Tjamiyulanya alatji nintiṉu, “Yalangaangka tjira yintila!, mayutju tiṉa nyinatjunkukitjangku.” Palunyangka Tjamiyulalu Tapitangka katangka yintiṉu, Yitjurilaku walytja ngaṉṯitja tjuṯaku mayutju tiṉa nyinatjunkukitjangku, yaṉangu tjuṯangka mirangka. Palunyangka Katutjaku kurrunpa Tapitangka tjarrparra nyinangi. ");
INSERT INTO piu2006_vpl VALUES ("S116_14","010_16_14","1SA","16","14","23","Katutjaku kurruntu Tjuulanya wantinytjala, mayutju Katutjalu mamu wantirriyaṉu Tjuulanya nguḻutjingantjaku. Tjuulaku waarrkana tjuṯangkuya Tjuulanya marrkuṉu, “Katutjalunta mamu nguwanpa wantirriyaṉu nguḻutjingantjaku. Palunyangkamarra watjalalanyatju wati mutjika yatjikilu wangkatjingalpayi ngurrira mantjira ngalya katinytjaku! Nyuntu nguḻurringanyingka palurunta kiitawu nguwanpa wangkatjingaranta palyarungulku.” Palunyatjanu Tjuulalu watjaṉu, “Mutjika yatjikingku wangkatjingalpayi ngurrira yaḻṯirra ngalya katinytjaku.” Yalatji watjantja kulira palumpa waarrkana kutjupalu Tjuulanya watjaṉu, “Wati Tjiitjiyiku tawunu Pitjiliyamanya ngurraraku katja palya nyinanyi, yatjikingku mutjika wangkatjingalpayi. Katja paluru tjilirratjarrangku pungkupayi, wati nguḻunytjuwiyalu. Yuṉpa palya nyinarra palya wangkapayi, mayutju Katutjanyapula tjungu nyinanyi.” Kulira Tjuulalu waarrkana wantirriyaṉu Tjiitjiyingka alatji watjantjaku, “Nyuntupa katja Tapitanya tjiipi kanyilpayi, ngayulakututju ngalya wantirriyala!, ngayuku ngurrangkalpi waarrkarrinytjaku.” Palunyatjanu Tjiitjiyilu Tapitanya Tjuulakutu wantirriyalkitjangku tuungkiyi ngaratjunkula parilyka mayi puriititjarra waralytjunu, parilyka kutjupa pulakina tjuṯatjarraṯarra. Tuungkiyi luutu palunyatjarra Tapitalu ngalya katingu nanikutaṯarra, Tjuulaku yinytjanungku ungkukitjangku. Alatji Tapitanya ankula Tjuulaku ngurrangka waarrkarringu. Muṯilya Tapitaku yunyparrirra Tjuulalu watjaṉu, Tapitalu palumpa tjilirra katiyankunytjaku. Mayutju tiṉangku wiya tjilirra katiyankula kanyilpayi, waarrkanangku palumpangku katiyankula kanyilpayi. Palunyatjanu Tapitaku yunyparrirra Tjuulalu waarrkana wantirriyara Tjiitjiyinya tjapiṉu, Tapitanya palumpa waarrkana rawa waarrkarrinytjaku. Tjiitjiyilu yuwa watjantjala, Tapitanya rawa Tjuulaku ngurrangka waarrkarripayi. Tjuulanya nguḻurringkula nyinanyingka, Tapitalu kiitawu nguwanpa wangkatjingara ataṉmankupayi. Wangkatjingaṉingka mamu paluru wantirra ankupayi. Palunyatjanu Tjuulanya nguḻuwiya nyinapayi. ");
INSERT INTO piu2006_vpl VALUES ("S117_1","010_17_1","1SA","17","1","11","Yitjurilaku walytja ngaṉṯitja Tjuulanyaṯarra ngurrawana nyinapayi. Tjuulaku waarrkana tjuṯa tjananya Pilitjiyanya ngurrara tjuṯa pikangku pungkukitja, ngalya yankula Tjuukungka ilaya nyinapayi. Yitjurilaku walyja ngaṉṯitja tjilirratjarra tjuṯa tjananya Tjuulalu aḻṯingu, puliina ini Yilayangka tjungurrinytjakuya. Puḻi murrpuwanaya ngarala waṉingu. Tjana ngarala tjananya nyangu puliinangka munkarra puḻi murrpu kutjupawana, Pilitjiyanya ngurrara tjuṯa ngalya ngarala waṉingitjangka, tjilirratjarra tjuṯa, tiṉa. Tjarukatirra puliinangka ngururrpa ngalya ankula ngarapayi Pilitjiyanya ngurrara wati waṯawara, ini Kulayitjanya. Tjilirratjarrangku ngarala aḻṯipayi, Yitjurilaku walyja ngaṉṯitja kutjungku tjilirratjarrangku ngalya ankula pikangku pungkunytjaku. Kulayitjanya paluru manpaṯa ngarangi, yayina ngaḻkilpayi mantarra nguwanpa tjarrparra ngarangi. Mukaṯi yayinatjarraṯarra ngarangi. Yayinatjanu rungkara yirintja manguḻpa yiri tiṉatjarra marangku kanyiṉingi. Tjilirratjarra kutjupangku yurrunpangku palumpa kuṯitji ngaḻkilpayi katiyankula kanyilpayi. Yalatji ngarala Kulayitjalu tjananya Yitjurilaku walyja ngaṉṯitja yaḻṯirra watjaṉu, “Wiyalanku tjuṯangku pikangku pungku, kutjarralu kutjulingku pikalu pungku, wiinarrikitjangku. Nyurrangarrimpa tjilirratjarrangkuṉi pikangku pungkula mirrintankunytjala, nganaṉatju nyurrangarrimpa waarrkana tjuṯa nyinaku. Ngayuluṉa tjinguru nyurrangarrimpa tjilirratjarra yiluntananyingka, nyurrangarrilampatju waarrkana nyinaku. Kalalpi, ngalya arra!, ngayunyatjun pungkula iluntankukitja.” Tjuulaluṯarraya Kulayitjaku wangka kulira nguḻunguḻurringkula nyinangi, pikakitja Kulayitjakutu ngalya ankunytjawiya. ");
INSERT INTO piu2006_vpl VALUES ("S117_12","010_17_12","1SA","17","12","40","Alatji Kulayitjalu tjananya rawangku aḻṯipayi, tjilirratjarra kutju ngalya wantirriyantjaku. Puratiyi tjikitjipalangka alatjingku puṯu aḻṯingu. Kanya wati Tjiitjiyilu ngurra Pitjiliyamangka nyinarra Tapitanya tjanampa wantirriyaṉu tjilirratjarra tjuṯakutu. Wantirriyalkitjangku alatji watjaṉu, “Mayi ngaatjanya katirra tjanampa tjilirratjarra tjuṯaku yuwa! Yungkula nyuntupa kaaka maṉkurrpa palya nyinanyingka, nyakulaṉi ngalya yankulaṉi tjakultjurra!” Kala aaḻilingku Tapitaluṯarra ankula tjananya nyangu, Yitjurilaku walytja ngaṉṯitja tjuṯa puḻi murrpuwana ngarala waṉinytjala, Pilitjiyanya ngurrara tjuṯaṯarra puḻi murrpu kutjupawana ngalya ngarala waṉinyinytjala. Mayikamu kuka panyapa ungkula wayintarringu tjilirratjarra tjuṯa ngarala waṉinytja nyakukitja, palumpa kaaka maṉkurrpaṯarra. Palunyatjanu Kulayitjalu ngalya ankula aḻṯingu Yitjurilaku walytja ngaṉṯitja kutjungku maa ankula pikangku pungkunytjaku. Alatji aḻṯinyingka tjilirratjarra tjuṯa nguḻu tiṉarringkula maḻaku ngalya tjalkaḻungkula nyinarra waṉingi. Tjilirratjarra tjuṯa tjananya Tapitalu tjapiṉu, “Nyaaku Pilitjiyanya ngurrara waṯawara paluru nyurranya puṯu aḻtinyi? Kutjulu palya ankula pikangku pungkunytjaku. Paluru mungutja, Katutjaku ngurrpa, wiyalampa mayutju nyinaku Katutjaku tjilirratjarra tjuṯaku.” Tjilirratjarra maṉkurrpangku Tapitaku wangka kulira katirra Tjuulanya tjakultjunu. Tjuulalu kulira Tapitanya aḻṯingu. Tapitalu Tjuulakutu ankula watjaṉu, “Pilitjiyanya ngurrara palumpa wiyala nguḻu nyinanytjaku. Ngayululpiṉa ankula mirri pungku.” Tjuulalu yangupala Tapitanya nyakula wiya watjaṉu. Palunyangka Tapitalu Tjuulanya marrkuṉu, wati palunya ankula pungkukitjangku. Alatjingku marrkuṉu, “Tjiipi purinytju kanyilkitjangkuṉa layina kutjupa tjuṯaṯarra mirri pungkupayi. Pikaṯi paluru tjanaṉiya patjara iluntankupayingka, mayutju Katutjaluṉi kanalpayi. Palunyatjanuluṉi kuwarri kanalku, Pilitjiya ngurrarangkuṉi mirri pungkupayingkamarra.” Palunyatjanu Tjuulalulpi yuwa wangkangu. Paluru watjaṉu Tapitanya palumpa yayina ngaḻkilpayi tjuṯangka tjarrpanytjaku. Tapitalu tjarrparra puṯu yarrkara watjaṉu, “Wiya, paḻilpayingkatju tiṉangku. Wiyatju yayina palunya walytja.” Yirriwiltjira tjangari nguwanpa mantjira palumpa kuṯuruṯarra katiyanu. Murraṉilu tjiipiku mayutjungku tjangari nguwanpa katiyankupayi layinaṯarra rungkalkitjangku. Tapitalu puḻi wirulypa payipala mantjira, tjangari nguwanpa mantjira tjarukatirra maa anu, Kulayitjanya rungkara iluntankukitja. ");
INSERT INTO piu2006_vpl VALUES ("S117_41","010_17_41","1SA","17","41","51","Tapitanya maa ankunytja nyakula Kulayitjanyaṯarra palumpa kuṯitji katiyankupayiṯarrapula tjungu ngalya anu, pikangku pungkukitja. Ilarringkula Kulayitjalu Tapitanya yangupala wiima nyakula kuṯuru nguwanpatjarra nyakula alatji panypurangu, “Nyaakun wiimapaṯu watiya kanyiṉi?, papa nguwanpatjun pungkukitjangku?” Tapitanya warrkira alatji watjaṉu, “Ngalya arra!, pungkulaṉanta mirri waṉinytjaku, papa tjikipaka tjuṯangkuntaya ngalkuntjaku, tjuḻpu tjuṯangkuṯarra.” Tapitalu watjaṉu, “Ngayunyatju wakara iluntankukitja ngalya yananyinu, kuḻaṯa tjuuḻa waṯawaratjarrangku. Kanya ngayuluṉanta Katutjakuṉu kuṉpu tiṉatjarrangku rungkara iluntara unytju kuntara kilytjuntanku, mayutju tiṉatju Katutjalu rapanytju. Ngayuluṉanta iluntananyingka, ngaṉṯi nyurrangarrimpa waarrkana tjuṯalpilatju pungkula iluntanamalpa. Palunyatjanu tjananya mirri tjuṯa layina tjuṯangku tjuḻpu tjuṯangkuṯarra ngalkula wiyanmalpa. Mayutju Katutjalulanyatju ngaḻkintu rapanytju palya nganaṉatju nyurrangarrinya mirri pungkuyinamalpa.” Kulayitjanya piyuku ngalya ankunytjala, Tapitalu nanpangka puḻi kutju mantjira tjangaringka tjarrpatjunkula maa tjalkaḻungkula ilarringkula ngalya rungkaṉu. Alatji rungkaṉingka punkara mirrilpi ngarringi. Paluru maa tjalkaḻungkula Kulayitjaku tjuuḻa waṯawara yurrkura yunytju kuntara kilytjuntanu. Alatji Tapitalu Kulayitjanya rungkara puḻitjarrangku iluntanu. ");
INSERT INTO piu2006_vpl VALUES ("S117_52","010_17_52","1SA","17","52","54","Pilitjiyanya ngurrara tjuṯaya Kulayitjanya mirri ngarrinytja nyakula tjalkatjalkaḻungu nguḻu pungkupayingka. Yitjurilaku walytja ngaṉṯitja tjuṯangku tjananya wanara mirrintarinangi tawunu Yikurunalakutu, tawunu Kaatjakutuṯarra. Alatji tjanaya tjananya mirrintarinarra maḻakuya ngalya ankula tjilirratjarra tjuṯaku kaliki tjuṯangka tjarrparra mani, yulytja tjanampa tjanaya mantjira kanyiṉingi, Yitjurilaku walytja ngaṉṯitja tjuṯangku. Tapitalu kata Kulayitjanya kuntara kilytjuntankula katingu Tjarutjalumakutu, nintilkitjangku. Kulayitjaku tjuuḻa waṯawaraṯarra Tapitalu katirra kanyiṉingi. ");
INSERT INTO piu2006_vpl VALUES ("S118_1","010_18_1","1SA","18","1","5","Tjuulalu Tapitanya aḻṯirra watjaṉu, “Nyuntu ngayuku ngurrangka waarrkarringkula nyinanytjaku, ngurra walytjakutu yankunytjawiya.” Palunyangka Tjuulaku katja Tjaanatjanya Tapitaku yunyparringkula nyinangi. Alatji yunyparringkula yulykarra nyinanytjatjanungku Tapitanya alatji watjaṉu, “Kutuṉanta maḻpa nyinamalpa, purinytjutju maḻpa nyinamalpa. Ngayuluṉanta kuyarringkula watjara wantinytjawiya.” Palunyatjanupula maḻpararra nyinangi. ");
INSERT INTO piu2006_vpl VALUES ("S118_6","010_18_6","1SA","18","6","30","(18:6-30; 19:; 21:; 23:; 24:; 26:) Tjuulalungarriya kuḻaṯatjarra tjuṯa Pilitjiyanya ngurrara tjuṯa mirri pungutjatjanu Tjarutjalumakutu maḻaku anangi. Yitjurilaku walytja kungka ngaṉṯitja tjuṯangku tawunu tjuṯatjanulu tjakulpa kulira pukuḻarrirra wanaṉu tjananya waḻkuntjakitjangku. Tjilirratjarra tjuṯangka ilawana taanytjirrirra inkayinangi. Alatji tjana inkayinangi, “Tjuulalungarri tjananya tjilirratjarra tjawutjuna kutju iluntanangi, kanya Tapitalungarri tjananya tjilirratjarra tjawutjuna tjuṯa iluntanangi. Tapitanya palyalingku.” Alatjiya ngunytji watjaṉu Tapitanya puḻkapungkunyingka kulira, Tjuulalu Tapitaku kuyarringkula alatji kuliṉu, “Tapitakuya puntura yunyparringanyi. Tjinguru Tapitanyalpiya mayutju tiṉa nyinatjunku ngayunyaṉiya wantirra, aṉangu tjuṯangku.” Palunyatjanu Tjuulanya Tapitaku kutu kuyarringkupayira. Palunyatjanu Tjuulaku ngurrangka Tapitalu kiitawu nguwanpa wangkatjingalpayi, Tjuulanya ataṉmankukitjangku. Palunyangka Tjuulalu Tapitaku mirrpaṉtjungku manguḻṯa wakara iluntankukitjangku puṯaṉu. Tapitalu nyakula tjirrkaṉu. Piyuku Tjuulalu manguḻpa palunya mantjira Tapitanya wakalkitjangku puṯaṉu, piyuku tjirrkantjala. Palunyatjanu Tjuulalu Tapitanya ngurra kutjupakutu wantirriyaṉu. Wantirriyara tjuṯaku mayutju nyinatjunu tjawutjuna kutjuku, ngurra waṉma Tapitanya kutu nyinanytjaku. Tapitalu tjananya pika tjuṯakutu katipayi. Tapitaku waarrkana tjuṯangku tjananya pikangku pungkula nguḻutjingara wantirriyalpayi, kutjupa ngurrara tjuṯa. Mayutju palya nyinanytjala, aṉangu minga Tapitaku yunypa nyinangi, Yitjurilaku walytja ngaṉṯitja tjuṯa, kanya Tjuulanya unytjuwiya nyinangi kutu. Tjuulalu yurrunpa watjaṉu palumpa yuṉṯalpa yurruntitja Tapitaku ungkukitjangku miiṯararrapula nyinanytjaku, Kulayitjanya Tapitalu iluntanutjangka. Tapitaku ungkukitjangku ngunytji tjangkura wati kutjupalpi ungu. Palunyatjanu Tjuulaku yuṉṯalpa kutjupa ini Maakulanya Tapitaku yunytjura nyinangi. Palunyatjanu Tjuulalu Tapitanyaya Pilitjiyanya ngurrara tjuṯangku iluntankunytjaku kuliṉu. Kulira waarrkanangka watjaṉu Tapitangka ankula alatji tjakultjunkunytjaku, “Nyuntu ngayuku waputju nyinaku yuṉṯalpa Maakulanyaṉanta unganyingka. Nyuntu Pilitjiyanya ngurrara antaṯa kutju mirri wakara ilytjanpa kuntara ngalya katinytjaku. Ngalya katirraṉin ungkunyangka uṉṯalpaṉanta ungku.” Tjuulalu kuliṉu, “Tapitalu kutjungku tjananya mirri punganyingka, Pilitjiyanya ngurrara tjuṯangkuya ngururrtjura ngaparrtjingku mirri pungkunytjaku.” Tjuulaku wangka uṉṯalpa ungkukitjalu watjantja waarrkanalu tjakultjunanyingka, Tapitalu kulira yunyparringu. Palunyatjanu Tapitalu tjananya palumpa kuḻaṯatjarra tjuṯa katingu Pilitjiyanya ngurrara tjuṯa pikangku pungkunytjaku. Paluru tjana tuu antaṯa tjuṯa tjananya wakara iluntara ilytjanpa kuntara mantjiṉangi. Ilytjanpa palunya tjuṯa ngalya katirra Tjuulala kurungka kaantamilara ungu. Palunyangka Tapitanya piyuku uti nyakula puṯu kuliṉu. Yalatji palurulpi kuliṉingi, “Katutjalukampa Tapitanya yaṉṯayaṉṯara kanaṉingi.” Palulanguru Tjuulalulpi palumpa uṉṯalpa Maakulanya Tapitanya ungu. Tjuulalu tjananya watjaṉu palumpa waarrkana tjuṯangka, Tjaanatjangkaṯarra, Tapitanya mirri pungkukitjangku. Tjaanatjalu Tjuulanya marrkuṉu wantinytjaku, palunyangka Tjuulanyara yaḻṯururrirra pungkuwiyangku wantikitjangku watjaṉu. Tapitanya piyuku yankula Tjuulaku waaḻangka waarrkarriyankupayi. Mamu panyapangku Tjuulanya nguḻutjingaṉingka, Tapitalu ataṉmankukitjangku mutjika wangkatjingaṉingi. Panyapa Tjuulalu marangku manguḻpa kanyira Tapitanya aṉangu yuti wakalkitjangku puṯaṉu. Tapitanya nguḻu tjirrkara pakara tjalkaḻungu. Tjuulalu piyuku aṉangu uti wakalpayingkamarra, Tapitanyaṯarraya palumpa waarrkanaṯarra tjuṯa tjalkaḻungu tawunu Naapakutu. Ngurra ngaa palula tjaatji ngarangi. Tjaatjiku mayutju tiṉangku ini Yayimalikalu kanyilpayi. Tapitalu Yayimalikangka ngatjiṉu mangarriku, kanya Yayimalikalu watjaṉu, “Mangarri ngayukuṉu walytjawiyaṉa kanyiṉi. Mangarri tjaati kutju ngarrinyi tjaatjingka ngarripayi. Luwu alatji ngaranyingka, miiṯangkanyurra kuwarri ngarrinytjawiyalu palya ngalkunytjaku.” Tapitalu watjaṉu, “Wiyalatju kuwarri miiṯawana ngarringi.” Palunyatjanu Yayimalikalu palumpa ngurrangka tjarrparra puriiti tjaati tjaatjingka tjunkula wantinytjatjanu mantjirara Tapitaku yungu. Tapitanya maralpa nguḻu ngalyankula tjaatji palulakutu yanu, Tjuulalamarra. Paluru Yayimalikanya tjapiṉu, “Kuḻaṯa, tjuuḻan kanyiṉi?” Yayimalikalu Kulayitjaku tjuuḻa waṯawara tjaatjingka ngaratjunkula wantingutja mantjira Tapitaku yungu. Palunyatjanu Tapitanyaṯarraya tawunu Kaatjakutu ankula nyinangi. Tapitanya ngunytji rama nguwanpa nyinangi, Pilitjiyanya ngurrara tjuṯangku mirri pungkupayingkamarra. Palunyatjanu Tapitaṯarraya tawunu Kaatja wantirra ankula kuḻpingka nyinangi. Palumpa kaaka tjuṯaya Tjuulakuṯarra nguḻurrirra Tapitakutu tjungurringu. Tjuṯarringkulaya nyinangi. Palunyatjanuya manta Muwapakutu ankula nyinayinu. Palunyatjanuya tawunu Kiilakutu ankula tjananya pikalu pungu, Pilitjiyanya ngurrara tjuṯa. Alatji tjananya pikangku pungkulaya wantirriyara Kiilanya ngurrara tjuṯa kanaṉu. Palunyatjanu Tapitanyaṯarraya Kiilangka nyinangi. Palunyangka Tjuulalu palumpa tjilirratjarra tjuṯa aḻṯingu, Tapitanyaṯarra tjananya wanaraya pungkukitjangku. Tjuulanyaṯarraya ngalya yananyingka, Tapitalungarriya tjakulpa kulira kurranyu anu puḻi murrpuwana nyinakitja. Palunyatjanu Tjuulaluṯarra tjanampa puṯu ngurriraya maḻaku anu ngurrakutu. Alatji Tjuulalungarriya Tapitanyaṯarra mirri pungkukitjangku tjuṯangara wanalpayi. Tjuulaluṯarra tjananya pungkukitjangkuya wanarankula ngururrpa ngarripayi, puliinangka ngururrpa, yurilta. Kutjarrangara Tapitalu Tjuulanya urilta, kuḻpingkaṯarra ngarriyananyingka wantingu, mirri pungkuwiyalu. Katutjalu mayutju nyinatjunkunytja kulira wantipayi mirri pungkuwiyangku. Tjuulalamarraya Tapitanyangarriya ngurra kutjupawana nyinayinangi. ");
INSERT INTO piu2006_vpl VALUES ("S119_1","010_19_1","1SA","19","1","24","(18:6-30; 19:; 21:; 23:; 24:; 26:) Tjuulalungarriya kuḻaṯatjarra tjuṯa Pilitjiyanya ngurrara tjuṯa mirri pungutjatjanu Tjarutjalumakutu maḻaku anangi. Yitjurilaku walytja kungka ngaṉṯitja tjuṯangku tawunu tjuṯatjanulu tjakulpa kulira pukuḻarrirra wanaṉu tjananya waḻkuntjakitjangku. Tjilirratjarra tjuṯangka ilawana taanytjirrirra inkayinangi. Alatji tjana inkayinangi, “Tjuulalungarri tjananya tjilirratjarra tjawutjuna kutju iluntanangi, kanya Tapitalungarri tjananya tjilirratjarra tjawutjuna tjuṯa iluntanangi. Tapitanya palyalingku.” Alatjiya ngunytji watjaṉu Tapitanya puḻkapungkunyingka kulira, Tjuulalu Tapitaku kuyarringkula alatji kuliṉu, “Tapitakuya puntura yunyparringanyi. Tjinguru Tapitanyalpiya mayutju tiṉa nyinatjunku ngayunyaṉiya wantirra, aṉangu tjuṯangku.” Palunyatjanu Tjuulanya Tapitaku kutu kuyarringkupayira. Palunyatjanu Tjuulaku ngurrangka Tapitalu kiitawu nguwanpa wangkatjingalpayi, Tjuulanya ataṉmankukitjangku. Palunyangka Tjuulalu Tapitaku mirrpaṉtjungku manguḻṯa wakara iluntankukitjangku puṯaṉu. Tapitalu nyakula tjirrkaṉu. Piyuku Tjuulalu manguḻpa palunya mantjira Tapitanya wakalkitjangku puṯaṉu, piyuku tjirrkantjala. Palunyatjanu Tjuulalu Tapitanya ngurra kutjupakutu wantirriyaṉu. Wantirriyara tjuṯaku mayutju nyinatjunu tjawutjuna kutjuku, ngurra waṉma Tapitanya kutu nyinanytjaku. Tapitalu tjananya pika tjuṯakutu katipayi. Tapitaku waarrkana tjuṯangku tjananya pikangku pungkula nguḻutjingara wantirriyalpayi, kutjupa ngurrara tjuṯa. Mayutju palya nyinanytjala, aṉangu minga Tapitaku yunypa nyinangi, Yitjurilaku walytja ngaṉṯitja tjuṯa, kanya Tjuulanya unytjuwiya nyinangi kutu. Tjuulalu yurrunpa watjaṉu palumpa yuṉṯalpa yurruntitja Tapitaku ungkukitjangku miiṯararrapula nyinanytjaku, Kulayitjanya Tapitalu iluntanutjangka. Tapitaku ungkukitjangku ngunytji tjangkura wati kutjupalpi ungu. Palunyatjanu Tjuulaku yuṉṯalpa kutjupa ini Maakulanya Tapitaku yunytjura nyinangi. Palunyatjanu Tjuulalu Tapitanyaya Pilitjiyanya ngurrara tjuṯangku iluntankunytjaku kuliṉu. Kulira waarrkanangka watjaṉu Tapitangka ankula alatji tjakultjunkunytjaku, “Nyuntu ngayuku waputju nyinaku yuṉṯalpa Maakulanyaṉanta unganyingka. Nyuntu Pilitjiyanya ngurrara antaṯa kutju mirri wakara ilytjanpa kuntara ngalya katinytjaku. Ngalya katirraṉin ungkunyangka uṉṯalpaṉanta ungku.” Tjuulalu kuliṉu, “Tapitalu kutjungku tjananya mirri punganyingka, Pilitjiyanya ngurrara tjuṯangkuya ngururrtjura ngaparrtjingku mirri pungkunytjaku.” Tjuulaku wangka uṉṯalpa ungkukitjalu watjantja waarrkanalu tjakultjunanyingka, Tapitalu kulira yunyparringu. Palunyatjanu Tapitalu tjananya palumpa kuḻaṯatjarra tjuṯa katingu Pilitjiyanya ngurrara tjuṯa pikangku pungkunytjaku. Paluru tjana tuu antaṯa tjuṯa tjananya wakara iluntara ilytjanpa kuntara mantjiṉangi. Ilytjanpa palunya tjuṯa ngalya katirra Tjuulala kurungka kaantamilara ungu. Palunyangka Tapitanya piyuku uti nyakula puṯu kuliṉu. Yalatji palurulpi kuliṉingi, “Katutjalukampa Tapitanya yaṉṯayaṉṯara kanaṉingi.” Palulanguru Tjuulalulpi palumpa uṉṯalpa Maakulanya Tapitanya ungu. Tjuulalu tjananya watjaṉu palumpa waarrkana tjuṯangka, Tjaanatjangkaṯarra, Tapitanya mirri pungkukitjangku. Tjaanatjalu Tjuulanya marrkuṉu wantinytjaku, palunyangka Tjuulanyara yaḻṯururrirra pungkuwiyangku wantikitjangku watjaṉu. Tapitanya piyuku yankula Tjuulaku waaḻangka waarrkarriyankupayi. Mamu panyapangku Tjuulanya nguḻutjingaṉingka, Tapitalu ataṉmankukitjangku mutjika wangkatjingaṉingi. Panyapa Tjuulalu marangku manguḻpa kanyira Tapitanya aṉangu yuti wakalkitjangku puṯaṉu. Tapitanya nguḻu tjirrkara pakara tjalkaḻungu. Tjuulalu piyuku aṉangu uti wakalpayingkamarra, Tapitanyaṯarraya palumpa waarrkanaṯarra tjuṯa tjalkaḻungu tawunu Naapakutu. Ngurra ngaa palula tjaatji ngarangi. Tjaatjiku mayutju tiṉangku ini Yayimalikalu kanyilpayi. Tapitalu Yayimalikangka ngatjiṉu mangarriku, kanya Yayimalikalu watjaṉu, “Mangarri ngayukuṉu walytjawiyaṉa kanyiṉi. Mangarri tjaati kutju ngarrinyi tjaatjingka ngarripayi. Luwu alatji ngaranyingka, miiṯangkanyurra kuwarri ngarrinytjawiyalu palya ngalkunytjaku.” Tapitalu watjaṉu, “Wiyalatju kuwarri miiṯawana ngarringi.” Palunyatjanu Yayimalikalu palumpa ngurrangka tjarrparra puriiti tjaati tjaatjingka tjunkula wantinytjatjanu mantjirara Tapitaku yungu. Tapitanya maralpa nguḻu ngalyankula tjaatji palulakutu yanu, Tjuulalamarra. Paluru Yayimalikanya tjapiṉu, “Kuḻaṯa, tjuuḻan kanyiṉi?” Yayimalikalu Kulayitjaku tjuuḻa waṯawara tjaatjingka ngaratjunkula wantingutja mantjira Tapitaku yungu. Palunyatjanu Tapitanyaṯarraya tawunu Kaatjakutu ankula nyinangi. Tapitanya ngunytji rama nguwanpa nyinangi, Pilitjiyanya ngurrara tjuṯangku mirri pungkupayingkamarra. Palunyatjanu Tapitaṯarraya tawunu Kaatja wantirra ankula kuḻpingka nyinangi. Palumpa kaaka tjuṯaya Tjuulakuṯarra nguḻurrirra Tapitakutu tjungurringu. Tjuṯarringkulaya nyinangi. Palunyatjanuya manta Muwapakutu ankula nyinayinu. Palunyatjanuya tawunu Kiilakutu ankula tjananya pikalu pungu, Pilitjiyanya ngurrara tjuṯa. Alatji tjananya pikangku pungkulaya wantirriyara Kiilanya ngurrara tjuṯa kanaṉu. Palunyatjanu Tapitanyaṯarraya Kiilangka nyinangi. Palunyangka Tjuulalu palumpa tjilirratjarra tjuṯa aḻṯingu, Tapitanyaṯarra tjananya wanaraya pungkukitjangku. Tjuulanyaṯarraya ngalya yananyingka, Tapitalungarriya tjakulpa kulira kurranyu anu puḻi murrpuwana nyinakitja. Palunyatjanu Tjuulaluṯarra tjanampa puṯu ngurriraya maḻaku anu ngurrakutu. Alatji Tjuulalungarriya Tapitanyaṯarra mirri pungkukitjangku tjuṯangara wanalpayi. Tjuulaluṯarra tjananya pungkukitjangkuya wanarankula ngururrpa ngarripayi, puliinangka ngururrpa, yurilta. Kutjarrangara Tapitalu Tjuulanya urilta, kuḻpingkaṯarra ngarriyananyingka wantingu, mirri pungkuwiyalu. Katutjalu mayutju nyinatjunkunytja kulira wantipayi mirri pungkuwiyangku. Tjuulalamarraya Tapitanyangarriya ngurra kutjupawana nyinayinangi. ");
INSERT INTO piu2006_vpl VALUES ("S121_1","010_21_1","1SA","21","1","15","(18:6-30; 19:; 21:; 23:; 24:; 26:) Tjuulalungarriya kuḻaṯatjarra tjuṯa Pilitjiyanya ngurrara tjuṯa mirri pungutjatjanu Tjarutjalumakutu maḻaku anangi. Yitjurilaku walytja kungka ngaṉṯitja tjuṯangku tawunu tjuṯatjanulu tjakulpa kulira pukuḻarrirra wanaṉu tjananya waḻkuntjakitjangku. Tjilirratjarra tjuṯangka ilawana taanytjirrirra inkayinangi. Alatji tjana inkayinangi, “Tjuulalungarri tjananya tjilirratjarra tjawutjuna kutju iluntanangi, kanya Tapitalungarri tjananya tjilirratjarra tjawutjuna tjuṯa iluntanangi. Tapitanya palyalingku.” Alatjiya ngunytji watjaṉu Tapitanya puḻkapungkunyingka kulira, Tjuulalu Tapitaku kuyarringkula alatji kuliṉu, “Tapitakuya puntura yunyparringanyi. Tjinguru Tapitanyalpiya mayutju tiṉa nyinatjunku ngayunyaṉiya wantirra, aṉangu tjuṯangku.” Palunyatjanu Tjuulanya Tapitaku kutu kuyarringkupayira. Palunyatjanu Tjuulaku ngurrangka Tapitalu kiitawu nguwanpa wangkatjingalpayi, Tjuulanya ataṉmankukitjangku. Palunyangka Tjuulalu Tapitaku mirrpaṉtjungku manguḻṯa wakara iluntankukitjangku puṯaṉu. Tapitalu nyakula tjirrkaṉu. Piyuku Tjuulalu manguḻpa palunya mantjira Tapitanya wakalkitjangku puṯaṉu, piyuku tjirrkantjala. Palunyatjanu Tjuulalu Tapitanya ngurra kutjupakutu wantirriyaṉu. Wantirriyara tjuṯaku mayutju nyinatjunu tjawutjuna kutjuku, ngurra waṉma Tapitanya kutu nyinanytjaku. Tapitalu tjananya pika tjuṯakutu katipayi. Tapitaku waarrkana tjuṯangku tjananya pikangku pungkula nguḻutjingara wantirriyalpayi, kutjupa ngurrara tjuṯa. Mayutju palya nyinanytjala, aṉangu minga Tapitaku yunypa nyinangi, Yitjurilaku walytja ngaṉṯitja tjuṯa, kanya Tjuulanya unytjuwiya nyinangi kutu. Tjuulalu yurrunpa watjaṉu palumpa yuṉṯalpa yurruntitja Tapitaku ungkukitjangku miiṯararrapula nyinanytjaku, Kulayitjanya Tapitalu iluntanutjangka. Tapitaku ungkukitjangku ngunytji tjangkura wati kutjupalpi ungu. Palunyatjanu Tjuulaku yuṉṯalpa kutjupa ini Maakulanya Tapitaku yunytjura nyinangi. Palunyatjanu Tjuulalu Tapitanyaya Pilitjiyanya ngurrara tjuṯangku iluntankunytjaku kuliṉu. Kulira waarrkanangka watjaṉu Tapitangka ankula alatji tjakultjunkunytjaku, “Nyuntu ngayuku waputju nyinaku yuṉṯalpa Maakulanyaṉanta unganyingka. Nyuntu Pilitjiyanya ngurrara antaṯa kutju mirri wakara ilytjanpa kuntara ngalya katinytjaku. Ngalya katirraṉin ungkunyangka uṉṯalpaṉanta ungku.” Tjuulalu kuliṉu, “Tapitalu kutjungku tjananya mirri punganyingka, Pilitjiyanya ngurrara tjuṯangkuya ngururrtjura ngaparrtjingku mirri pungkunytjaku.” Tjuulaku wangka uṉṯalpa ungkukitjalu watjantja waarrkanalu tjakultjunanyingka, Tapitalu kulira yunyparringu. Palunyatjanu Tapitalu tjananya palumpa kuḻaṯatjarra tjuṯa katingu Pilitjiyanya ngurrara tjuṯa pikangku pungkunytjaku. Paluru tjana tuu antaṯa tjuṯa tjananya wakara iluntara ilytjanpa kuntara mantjiṉangi. Ilytjanpa palunya tjuṯa ngalya katirra Tjuulala kurungka kaantamilara ungu. Palunyangka Tapitanya piyuku uti nyakula puṯu kuliṉu. Yalatji palurulpi kuliṉingi, “Katutjalukampa Tapitanya yaṉṯayaṉṯara kanaṉingi.” Palulanguru Tjuulalulpi palumpa uṉṯalpa Maakulanya Tapitanya ungu. Tjuulalu tjananya watjaṉu palumpa waarrkana tjuṯangka, Tjaanatjangkaṯarra, Tapitanya mirri pungkukitjangku. Tjaanatjalu Tjuulanya marrkuṉu wantinytjaku, palunyangka Tjuulanyara yaḻṯururrirra pungkuwiyangku wantikitjangku watjaṉu. Tapitanya piyuku yankula Tjuulaku waaḻangka waarrkarriyankupayi. Mamu panyapangku Tjuulanya nguḻutjingaṉingka, Tapitalu ataṉmankukitjangku mutjika wangkatjingaṉingi. Panyapa Tjuulalu marangku manguḻpa kanyira Tapitanya aṉangu yuti wakalkitjangku puṯaṉu. Tapitanya nguḻu tjirrkara pakara tjalkaḻungu. Tjuulalu piyuku aṉangu uti wakalpayingkamarra, Tapitanyaṯarraya palumpa waarrkanaṯarra tjuṯa tjalkaḻungu tawunu Naapakutu. Ngurra ngaa palula tjaatji ngarangi. Tjaatjiku mayutju tiṉangku ini Yayimalikalu kanyilpayi. Tapitalu Yayimalikangka ngatjiṉu mangarriku, kanya Yayimalikalu watjaṉu, “Mangarri ngayukuṉu walytjawiyaṉa kanyiṉi. Mangarri tjaati kutju ngarrinyi tjaatjingka ngarripayi. Luwu alatji ngaranyingka, miiṯangkanyurra kuwarri ngarrinytjawiyalu palya ngalkunytjaku.” Tapitalu watjaṉu, “Wiyalatju kuwarri miiṯawana ngarringi.” Palunyatjanu Yayimalikalu palumpa ngurrangka tjarrparra puriiti tjaati tjaatjingka tjunkula wantinytjatjanu mantjirara Tapitaku yungu. Tapitanya maralpa nguḻu ngalyankula tjaatji palulakutu yanu, Tjuulalamarra. Paluru Yayimalikanya tjapiṉu, “Kuḻaṯa, tjuuḻan kanyiṉi?” Yayimalikalu Kulayitjaku tjuuḻa waṯawara tjaatjingka ngaratjunkula wantingutja mantjira Tapitaku yungu. Palunyatjanu Tapitanyaṯarraya tawunu Kaatjakutu ankula nyinangi. Tapitanya ngunytji rama nguwanpa nyinangi, Pilitjiyanya ngurrara tjuṯangku mirri pungkupayingkamarra. Palunyatjanu Tapitaṯarraya tawunu Kaatja wantirra ankula kuḻpingka nyinangi. Palumpa kaaka tjuṯaya Tjuulakuṯarra nguḻurrirra Tapitakutu tjungurringu. Tjuṯarringkulaya nyinangi. Palunyatjanuya manta Muwapakutu ankula nyinayinu. Palunyatjanuya tawunu Kiilakutu ankula tjananya pikalu pungu, Pilitjiyanya ngurrara tjuṯa. Alatji tjananya pikangku pungkulaya wantirriyara Kiilanya ngurrara tjuṯa kanaṉu. Palunyatjanu Tapitanyaṯarraya Kiilangka nyinangi. Palunyangka Tjuulalu palumpa tjilirratjarra tjuṯa aḻṯingu, Tapitanyaṯarra tjananya wanaraya pungkukitjangku. Tjuulanyaṯarraya ngalya yananyingka, Tapitalungarriya tjakulpa kulira kurranyu anu puḻi murrpuwana nyinakitja. Palunyatjanu Tjuulaluṯarra tjanampa puṯu ngurriraya maḻaku anu ngurrakutu. Alatji Tjuulalungarriya Tapitanyaṯarra mirri pungkukitjangku tjuṯangara wanalpayi. Tjuulaluṯarra tjananya pungkukitjangkuya wanarankula ngururrpa ngarripayi, puliinangka ngururrpa, yurilta. Kutjarrangara Tapitalu Tjuulanya urilta, kuḻpingkaṯarra ngarriyananyingka wantingu, mirri pungkuwiyalu. Katutjalu mayutju nyinatjunkunytja kulira wantipayi mirri pungkuwiyangku. Tjuulalamarraya Tapitanyangarriya ngurra kutjupawana nyinayinangi. ");
INSERT INTO piu2006_vpl VALUES ("S123_1","010_23_1","1SA","23","1","28","(18:6-30; 19:; 21:; 23:; 24:; 26:) Tjuulalungarriya kuḻaṯatjarra tjuṯa Pilitjiyanya ngurrara tjuṯa mirri pungutjatjanu Tjarutjalumakutu maḻaku anangi. Yitjurilaku walytja kungka ngaṉṯitja tjuṯangku tawunu tjuṯatjanulu tjakulpa kulira pukuḻarrirra wanaṉu tjananya waḻkuntjakitjangku. Tjilirratjarra tjuṯangka ilawana taanytjirrirra inkayinangi. Alatji tjana inkayinangi, “Tjuulalungarri tjananya tjilirratjarra tjawutjuna kutju iluntanangi, kanya Tapitalungarri tjananya tjilirratjarra tjawutjuna tjuṯa iluntanangi. Tapitanya palyalingku.” Alatjiya ngunytji watjaṉu Tapitanya puḻkapungkunyingka kulira, Tjuulalu Tapitaku kuyarringkula alatji kuliṉu, “Tapitakuya puntura yunyparringanyi. Tjinguru Tapitanyalpiya mayutju tiṉa nyinatjunku ngayunyaṉiya wantirra, aṉangu tjuṯangku.” Palunyatjanu Tjuulanya Tapitaku kutu kuyarringkupayira. Palunyatjanu Tjuulaku ngurrangka Tapitalu kiitawu nguwanpa wangkatjingalpayi, Tjuulanya ataṉmankukitjangku. Palunyangka Tjuulalu Tapitaku mirrpaṉtjungku manguḻṯa wakara iluntankukitjangku puṯaṉu. Tapitalu nyakula tjirrkaṉu. Piyuku Tjuulalu manguḻpa palunya mantjira Tapitanya wakalkitjangku puṯaṉu, piyuku tjirrkantjala. Palunyatjanu Tjuulalu Tapitanya ngurra kutjupakutu wantirriyaṉu. Wantirriyara tjuṯaku mayutju nyinatjunu tjawutjuna kutjuku, ngurra waṉma Tapitanya kutu nyinanytjaku. Tapitalu tjananya pika tjuṯakutu katipayi. Tapitaku waarrkana tjuṯangku tjananya pikangku pungkula nguḻutjingara wantirriyalpayi, kutjupa ngurrara tjuṯa. Mayutju palya nyinanytjala, aṉangu minga Tapitaku yunypa nyinangi, Yitjurilaku walytja ngaṉṯitja tjuṯa, kanya Tjuulanya unytjuwiya nyinangi kutu. Tjuulalu yurrunpa watjaṉu palumpa yuṉṯalpa yurruntitja Tapitaku ungkukitjangku miiṯararrapula nyinanytjaku, Kulayitjanya Tapitalu iluntanutjangka. Tapitaku ungkukitjangku ngunytji tjangkura wati kutjupalpi ungu. Palunyatjanu Tjuulaku yuṉṯalpa kutjupa ini Maakulanya Tapitaku yunytjura nyinangi. Palunyatjanu Tjuulalu Tapitanyaya Pilitjiyanya ngurrara tjuṯangku iluntankunytjaku kuliṉu. Kulira waarrkanangka watjaṉu Tapitangka ankula alatji tjakultjunkunytjaku, “Nyuntu ngayuku waputju nyinaku yuṉṯalpa Maakulanyaṉanta unganyingka. Nyuntu Pilitjiyanya ngurrara antaṯa kutju mirri wakara ilytjanpa kuntara ngalya katinytjaku. Ngalya katirraṉin ungkunyangka uṉṯalpaṉanta ungku.” Tjuulalu kuliṉu, “Tapitalu kutjungku tjananya mirri punganyingka, Pilitjiyanya ngurrara tjuṯangkuya ngururrtjura ngaparrtjingku mirri pungkunytjaku.” Tjuulaku wangka uṉṯalpa ungkukitjalu watjantja waarrkanalu tjakultjunanyingka, Tapitalu kulira yunyparringu. Palunyatjanu Tapitalu tjananya palumpa kuḻaṯatjarra tjuṯa katingu Pilitjiyanya ngurrara tjuṯa pikangku pungkunytjaku. Paluru tjana tuu antaṯa tjuṯa tjananya wakara iluntara ilytjanpa kuntara mantjiṉangi. Ilytjanpa palunya tjuṯa ngalya katirra Tjuulala kurungka kaantamilara ungu. Palunyangka Tapitanya piyuku uti nyakula puṯu kuliṉu. Yalatji palurulpi kuliṉingi, “Katutjalukampa Tapitanya yaṉṯayaṉṯara kanaṉingi.” Palulanguru Tjuulalulpi palumpa uṉṯalpa Maakulanya Tapitanya ungu. Tjuulalu tjananya watjaṉu palumpa waarrkana tjuṯangka, Tjaanatjangkaṯarra, Tapitanya mirri pungkukitjangku. Tjaanatjalu Tjuulanya marrkuṉu wantinytjaku, palunyangka Tjuulanyara yaḻṯururrirra pungkuwiyangku wantikitjangku watjaṉu. Tapitanya piyuku yankula Tjuulaku waaḻangka waarrkarriyankupayi. Mamu panyapangku Tjuulanya nguḻutjingaṉingka, Tapitalu ataṉmankukitjangku mutjika wangkatjingaṉingi. Panyapa Tjuulalu marangku manguḻpa kanyira Tapitanya aṉangu yuti wakalkitjangku puṯaṉu. Tapitanya nguḻu tjirrkara pakara tjalkaḻungu. Tjuulalu piyuku aṉangu uti wakalpayingkamarra, Tapitanyaṯarraya palumpa waarrkanaṯarra tjuṯa tjalkaḻungu tawunu Naapakutu. Ngurra ngaa palula tjaatji ngarangi. Tjaatjiku mayutju tiṉangku ini Yayimalikalu kanyilpayi. Tapitalu Yayimalikangka ngatjiṉu mangarriku, kanya Yayimalikalu watjaṉu, “Mangarri ngayukuṉu walytjawiyaṉa kanyiṉi. Mangarri tjaati kutju ngarrinyi tjaatjingka ngarripayi. Luwu alatji ngaranyingka, miiṯangkanyurra kuwarri ngarrinytjawiyalu palya ngalkunytjaku.” Tapitalu watjaṉu, “Wiyalatju kuwarri miiṯawana ngarringi.” Palunyatjanu Yayimalikalu palumpa ngurrangka tjarrparra puriiti tjaati tjaatjingka tjunkula wantinytjatjanu mantjirara Tapitaku yungu. Tapitanya maralpa nguḻu ngalyankula tjaatji palulakutu yanu, Tjuulalamarra. Paluru Yayimalikanya tjapiṉu, “Kuḻaṯa, tjuuḻan kanyiṉi?” Yayimalikalu Kulayitjaku tjuuḻa waṯawara tjaatjingka ngaratjunkula wantingutja mantjira Tapitaku yungu. Palunyatjanu Tapitanyaṯarraya tawunu Kaatjakutu ankula nyinangi. Tapitanya ngunytji rama nguwanpa nyinangi, Pilitjiyanya ngurrara tjuṯangku mirri pungkupayingkamarra. Palunyatjanu Tapitaṯarraya tawunu Kaatja wantirra ankula kuḻpingka nyinangi. Palumpa kaaka tjuṯaya Tjuulakuṯarra nguḻurrirra Tapitakutu tjungurringu. Tjuṯarringkulaya nyinangi. Palunyatjanuya manta Muwapakutu ankula nyinayinu. Palunyatjanuya tawunu Kiilakutu ankula tjananya pikalu pungu, Pilitjiyanya ngurrara tjuṯa. Alatji tjananya pikangku pungkulaya wantirriyara Kiilanya ngurrara tjuṯa kanaṉu. Palunyatjanu Tapitanyaṯarraya Kiilangka nyinangi. Palunyangka Tjuulalu palumpa tjilirratjarra tjuṯa aḻṯingu, Tapitanyaṯarra tjananya wanaraya pungkukitjangku. Tjuulanyaṯarraya ngalya yananyingka, Tapitalungarriya tjakulpa kulira kurranyu anu puḻi murrpuwana nyinakitja. Palunyatjanu Tjuulaluṯarra tjanampa puṯu ngurriraya maḻaku anu ngurrakutu. Alatji Tjuulalungarriya Tapitanyaṯarra mirri pungkukitjangku tjuṯangara wanalpayi. Tjuulaluṯarra tjananya pungkukitjangkuya wanarankula ngururrpa ngarripayi, puliinangka ngururrpa, yurilta. Kutjarrangara Tapitalu Tjuulanya urilta, kuḻpingkaṯarra ngarriyananyingka wantingu, mirri pungkuwiyalu. Katutjalu mayutju nyinatjunkunytja kulira wantipayi mirri pungkuwiyangku. Tjuulalamarraya Tapitanyangarriya ngurra kutjupawana nyinayinangi. ");
INSERT INTO piu2006_vpl VALUES ("S124_1","010_24_1","1SA","24","1","22","(18:6-30; 19:; 21:; 23:; 24:; 26:) Tjuulalungarriya kuḻaṯatjarra tjuṯa Pilitjiyanya ngurrara tjuṯa mirri pungutjatjanu Tjarutjalumakutu maḻaku anangi. Yitjurilaku walytja kungka ngaṉṯitja tjuṯangku tawunu tjuṯatjanulu tjakulpa kulira pukuḻarrirra wanaṉu tjananya waḻkuntjakitjangku. Tjilirratjarra tjuṯangka ilawana taanytjirrirra inkayinangi. Alatji tjana inkayinangi, “Tjuulalungarri tjananya tjilirratjarra tjawutjuna kutju iluntanangi, kanya Tapitalungarri tjananya tjilirratjarra tjawutjuna tjuṯa iluntanangi. Tapitanya palyalingku.” Alatjiya ngunytji watjaṉu Tapitanya puḻkapungkunyingka kulira, Tjuulalu Tapitaku kuyarringkula alatji kuliṉu, “Tapitakuya puntura yunyparringanyi. Tjinguru Tapitanyalpiya mayutju tiṉa nyinatjunku ngayunyaṉiya wantirra, aṉangu tjuṯangku.” Palunyatjanu Tjuulanya Tapitaku kutu kuyarringkupayira. Palunyatjanu Tjuulaku ngurrangka Tapitalu kiitawu nguwanpa wangkatjingalpayi, Tjuulanya ataṉmankukitjangku. Palunyangka Tjuulalu Tapitaku mirrpaṉtjungku manguḻṯa wakara iluntankukitjangku puṯaṉu. Tapitalu nyakula tjirrkaṉu. Piyuku Tjuulalu manguḻpa palunya mantjira Tapitanya wakalkitjangku puṯaṉu, piyuku tjirrkantjala. Palunyatjanu Tjuulalu Tapitanya ngurra kutjupakutu wantirriyaṉu. Wantirriyara tjuṯaku mayutju nyinatjunu tjawutjuna kutjuku, ngurra waṉma Tapitanya kutu nyinanytjaku. Tapitalu tjananya pika tjuṯakutu katipayi. Tapitaku waarrkana tjuṯangku tjananya pikangku pungkula nguḻutjingara wantirriyalpayi, kutjupa ngurrara tjuṯa. Mayutju palya nyinanytjala, aṉangu minga Tapitaku yunypa nyinangi, Yitjurilaku walytja ngaṉṯitja tjuṯa, kanya Tjuulanya unytjuwiya nyinangi kutu. Tjuulalu yurrunpa watjaṉu palumpa yuṉṯalpa yurruntitja Tapitaku ungkukitjangku miiṯararrapula nyinanytjaku, Kulayitjanya Tapitalu iluntanutjangka. Tapitaku ungkukitjangku ngunytji tjangkura wati kutjupalpi ungu. Palunyatjanu Tjuulaku yuṉṯalpa kutjupa ini Maakulanya Tapitaku yunytjura nyinangi. Palunyatjanu Tjuulalu Tapitanyaya Pilitjiyanya ngurrara tjuṯangku iluntankunytjaku kuliṉu. Kulira waarrkanangka watjaṉu Tapitangka ankula alatji tjakultjunkunytjaku, “Nyuntu ngayuku waputju nyinaku yuṉṯalpa Maakulanyaṉanta unganyingka. Nyuntu Pilitjiyanya ngurrara antaṯa kutju mirri wakara ilytjanpa kuntara ngalya katinytjaku. Ngalya katirraṉin ungkunyangka uṉṯalpaṉanta ungku.” Tjuulalu kuliṉu, “Tapitalu kutjungku tjananya mirri punganyingka, Pilitjiyanya ngurrara tjuṯangkuya ngururrtjura ngaparrtjingku mirri pungkunytjaku.” Tjuulaku wangka uṉṯalpa ungkukitjalu watjantja waarrkanalu tjakultjunanyingka, Tapitalu kulira yunyparringu. Palunyatjanu Tapitalu tjananya palumpa kuḻaṯatjarra tjuṯa katingu Pilitjiyanya ngurrara tjuṯa pikangku pungkunytjaku. Paluru tjana tuu antaṯa tjuṯa tjananya wakara iluntara ilytjanpa kuntara mantjiṉangi. Ilytjanpa palunya tjuṯa ngalya katirra Tjuulala kurungka kaantamilara ungu. Palunyangka Tapitanya piyuku uti nyakula puṯu kuliṉu. Yalatji palurulpi kuliṉingi, “Katutjalukampa Tapitanya yaṉṯayaṉṯara kanaṉingi.” Palulanguru Tjuulalulpi palumpa uṉṯalpa Maakulanya Tapitanya ungu. Tjuulalu tjananya watjaṉu palumpa waarrkana tjuṯangka, Tjaanatjangkaṯarra, Tapitanya mirri pungkukitjangku. Tjaanatjalu Tjuulanya marrkuṉu wantinytjaku, palunyangka Tjuulanyara yaḻṯururrirra pungkuwiyangku wantikitjangku watjaṉu. Tapitanya piyuku yankula Tjuulaku waaḻangka waarrkarriyankupayi. Mamu panyapangku Tjuulanya nguḻutjingaṉingka, Tapitalu ataṉmankukitjangku mutjika wangkatjingaṉingi. Panyapa Tjuulalu marangku manguḻpa kanyira Tapitanya aṉangu yuti wakalkitjangku puṯaṉu. Tapitanya nguḻu tjirrkara pakara tjalkaḻungu. Tjuulalu piyuku aṉangu uti wakalpayingkamarra, Tapitanyaṯarraya palumpa waarrkanaṯarra tjuṯa tjalkaḻungu tawunu Naapakutu. Ngurra ngaa palula tjaatji ngarangi. Tjaatjiku mayutju tiṉangku ini Yayimalikalu kanyilpayi. Tapitalu Yayimalikangka ngatjiṉu mangarriku, kanya Yayimalikalu watjaṉu, “Mangarri ngayukuṉu walytjawiyaṉa kanyiṉi. Mangarri tjaati kutju ngarrinyi tjaatjingka ngarripayi. Luwu alatji ngaranyingka, miiṯangkanyurra kuwarri ngarrinytjawiyalu palya ngalkunytjaku.” Tapitalu watjaṉu, “Wiyalatju kuwarri miiṯawana ngarringi.” Palunyatjanu Yayimalikalu palumpa ngurrangka tjarrparra puriiti tjaati tjaatjingka tjunkula wantinytjatjanu mantjirara Tapitaku yungu. Tapitanya maralpa nguḻu ngalyankula tjaatji palulakutu yanu, Tjuulalamarra. Paluru Yayimalikanya tjapiṉu, “Kuḻaṯa, tjuuḻan kanyiṉi?” Yayimalikalu Kulayitjaku tjuuḻa waṯawara tjaatjingka ngaratjunkula wantingutja mantjira Tapitaku yungu. Palunyatjanu Tapitanyaṯarraya tawunu Kaatjakutu ankula nyinangi. Tapitanya ngunytji rama nguwanpa nyinangi, Pilitjiyanya ngurrara tjuṯangku mirri pungkupayingkamarra. Palunyatjanu Tapitaṯarraya tawunu Kaatja wantirra ankula kuḻpingka nyinangi. Palumpa kaaka tjuṯaya Tjuulakuṯarra nguḻurrirra Tapitakutu tjungurringu. Tjuṯarringkulaya nyinangi. Palunyatjanuya manta Muwapakutu ankula nyinayinu. Palunyatjanuya tawunu Kiilakutu ankula tjananya pikalu pungu, Pilitjiyanya ngurrara tjuṯa. Alatji tjananya pikangku pungkulaya wantirriyara Kiilanya ngurrara tjuṯa kanaṉu. Palunyatjanu Tapitanyaṯarraya Kiilangka nyinangi. Palunyangka Tjuulalu palumpa tjilirratjarra tjuṯa aḻṯingu, Tapitanyaṯarra tjananya wanaraya pungkukitjangku. Tjuulanyaṯarraya ngalya yananyingka, Tapitalungarriya tjakulpa kulira kurranyu anu puḻi murrpuwana nyinakitja. Palunyatjanu Tjuulaluṯarra tjanampa puṯu ngurriraya maḻaku anu ngurrakutu. Alatji Tjuulalungarriya Tapitanyaṯarra mirri pungkukitjangku tjuṯangara wanalpayi. Tjuulaluṯarra tjananya pungkukitjangkuya wanarankula ngururrpa ngarripayi, puliinangka ngururrpa, yurilta. Kutjarrangara Tapitalu Tjuulanya urilta, kuḻpingkaṯarra ngarriyananyingka wantingu, mirri pungkuwiyalu. Katutjalu mayutju nyinatjunkunytja kulira wantipayi mirri pungkuwiyangku. Tjuulalamarraya Tapitanyangarriya ngurra kutjupawana nyinayinangi. ");
INSERT INTO piu2006_vpl VALUES ("S125_1","010_25_1","1SA","25","1","44","(25:1—28:25) Tjiḻpi Tjamiyulanya tuḻkuku mayutju rawa nyinarra wiyarringu. Aṉangu tjuṯaya ularra palumpa ngurrangka tawunu Ramangka tjunutjunu. Palunyatjanu Pilitjiyanya ngurrara tjuṯa tjilirratjarra tjuṯa ngalya anu, Yitjurilaku walytja ngaṉṯitja pikangku pungkukitja. Tawunu Tjunimangkaya ngalyankula nyinarra waṉingi, Pilitjiyanya ngurrara tjuṯa. Palunyatjanu Tjuulalu Yitjurilaku walytja ngaṉṯitja tjuṯa aḻṯingu, pika pungkukitja tjungurrinytjaku. Tjungurringkulaya nyinarra waṉingi, puḻi ini Kilpuwangka. Pilitjiyanya ngurrara tjilirratjarra tjuṯa tjuṯarrinytjala tjananya nyakula Tjuulalu nguḻunguḻurringkula puṯu kulira Katutjanya tjapiṉu. Katutjalu kulira wantingu. Mungangka ngarrirra tjukurrpa nyakunytjala Katutjalu nintilwiyangku wantingu. Katutjaku wangka nintilpayi kutjupalu wiya ngalyankula Tjuulanya nintiṉu. Yilta Tjuulalu Katutjanya puṯu tjapira wantingu. Yurrunpa tjananya Tjuulalu aṉangu kuya tjuṯa mamukutu wangkapayi tjuṯa, payira wantirriyaṉu ngurra kutjupangkalpiya waṉma nyinanytjaku. Pilitjiyanya ngurrara tjuṯangku tjananya pungkutjipingka, Tjuulalu Katutjanya puṯu tjapira waarrkana tjuṯangka watjaṉu, ankula kungka mamukutu wangkapayiku ngurrira mantjintjaku. Ngurrira nyakula ngalya yankulaya Tjuulangka alatji watjaṉu, “Tawunu Yintungka kungka mamukutu wangkapayi nyinanyi.” Tjuulanya mantarra kutjupangka tjarrparra mungangka anu wati kuyakuya nguwanpa kungka palulakutu. Tjunguya anu waarrkana kutjarra. Yini watjantjawiyangku Tjuulalu kungka palula tjapiṉu, mamungka aḻṯirra tjapilkitjangku. Tjuulalu kutu tjapiṉu alatji, “Wati mirringka wangkakitjaṉa unytjurringanyi. Yiniṉanta tjapilku?” Kungka paluru wati kutjupa wiyawanangku kulira Tjuulanya alatji marrkuṉu, “Kulila alatji! Mayutju tiṉangku Tjuulalu watjaṉu, aṉangu mamungka wangkapayi tjuṯalanyatju mirri pungkukitjangku, ngurra waṉmalatju ankula nyinanytjawiyangka. Nyaakuṉin tjapiṉi, mirrikutu wangkakitjangku? Wangkanyingkaṉa Tjuulaluṯarraṉiya mirri pungkutjipingka.” Tjuulalu tjukarurru alatji watjaṉu, “Katutjangka mirangka tjukarurruṉanta watjaṉi, wiyaṉanta tjakultjunku mayutju Tjuulangka. Wiyantaya ngalya ankula mirri pungku.” Kungka paluru kulira tjapiṉu, “Mirri nganakuṉangku tjapilku?” Tjuulalu watjaṉu, “Tjamiyulaku.” Kungka paluru tjukurrpa nguwanpa nyakula mirrangu Tjamiyulanya nyakula. Tjuulangkalpira watjaṉu, “Nyaakuṉin ngunytji watjaṉu? Nyuntu yilta mayutju tiṉa Tjuulanya nyinanyi.” Tjuulalu watjaṉu, “Nguḻurriwiyangkuṉi tjukarurru watjala! Nyaa nguwanpan nyangu?” Kungkalu watjaṉu, “Tjiḻpiṉa nyanganyi ngalya ananyingka, kuuta tiṉatjarra.” Palunyatjanu Tjamiyulalu Tjuulangka alatji tjapiṉu, “Nyaakuṉin aḻṯingu?, ngayunya wantiwiyangku.” Tjuulalu watjaṉu, “Puṯuṉa kuliṉi, Katutjaluṉi wantinytjala. Pilitjiyanya ngurrara tjuṯaya ngarala waṉinyi nganaṉanya pungkukitja. Yaalytjinkulatju? Nyuntulpiṉi nintila!, tjukarurrulatju tjananya pungkula wantirriyantjaku.” Tjamiyulalu Tjuulangka watjaṉu, “Nyuntu wiyawana nyinangutjangkanta Katutjalu wantingu. Palunyangka wiyaṉin aḻṯirra tjapintjaku, nintirrikitjangku. Waṯalpi, Tapitanyalpi mayutju tiṉa tjanampa nyinaku. Tjiṉṯungka nyurrangarrinya Pilitjiyanya ngurrara tjuṯangku mirri pungku, nyuntunya, nyuntupa katja tjuṯaṯarra. Paluru tjana nyuntunya, tjilirratjarra tjuṯaṯarra tjananya mirri pungkuyinkula nguḻutjingara wantirriyalku, Yitjurilaku walytja ngaṉṯitja tjuṯanya.” Wangka alatji kulira Tjuulanya punkara ngarringi nguḻunguḻurringkula. Ngurra palula mangarri ngalkura Tjuulanyaṯarraya maḻaku anu mungangka, palumpa tjilirratjarra tjuṯakutu. ");
INSERT INTO piu2006_vpl VALUES ("S126_1","010_26_1","1SA","26","1","25","(18:6-30; 19:; 21:; 23:; 24:; 26:) Tjuulalungarriya kuḻaṯatjarra tjuṯa Pilitjiyanya ngurrara tjuṯa mirri pungutjatjanu Tjarutjalumakutu maḻaku anangi. Yitjurilaku walytja kungka ngaṉṯitja tjuṯangku tawunu tjuṯatjanulu tjakulpa kulira pukuḻarrirra wanaṉu tjananya waḻkuntjakitjangku. Tjilirratjarra tjuṯangka ilawana taanytjirrirra inkayinangi. Alatji tjana inkayinangi, “Tjuulalungarri tjananya tjilirratjarra tjawutjuna kutju iluntanangi, kanya Tapitalungarri tjananya tjilirratjarra tjawutjuna tjuṯa iluntanangi. Tapitanya palyalingku.” Alatjiya ngunytji watjaṉu Tapitanya puḻkapungkunyingka kulira, Tjuulalu Tapitaku kuyarringkula alatji kuliṉu, “Tapitakuya puntura yunyparringanyi. Tjinguru Tapitanyalpiya mayutju tiṉa nyinatjunku ngayunyaṉiya wantirra, aṉangu tjuṯangku.” Palunyatjanu Tjuulanya Tapitaku kutu kuyarringkupayira. Palunyatjanu Tjuulaku ngurrangka Tapitalu kiitawu nguwanpa wangkatjingalpayi, Tjuulanya ataṉmankukitjangku. Palunyangka Tjuulalu Tapitaku mirrpaṉtjungku manguḻṯa wakara iluntankukitjangku puṯaṉu. Tapitalu nyakula tjirrkaṉu. Piyuku Tjuulalu manguḻpa palunya mantjira Tapitanya wakalkitjangku puṯaṉu, piyuku tjirrkantjala. Palunyatjanu Tjuulalu Tapitanya ngurra kutjupakutu wantirriyaṉu. Wantirriyara tjuṯaku mayutju nyinatjunu tjawutjuna kutjuku, ngurra waṉma Tapitanya kutu nyinanytjaku. Tapitalu tjananya pika tjuṯakutu katipayi. Tapitaku waarrkana tjuṯangku tjananya pikangku pungkula nguḻutjingara wantirriyalpayi, kutjupa ngurrara tjuṯa. Mayutju palya nyinanytjala, aṉangu minga Tapitaku yunypa nyinangi, Yitjurilaku walytja ngaṉṯitja tjuṯa, kanya Tjuulanya unytjuwiya nyinangi kutu. Tjuulalu yurrunpa watjaṉu palumpa yuṉṯalpa yurruntitja Tapitaku ungkukitjangku miiṯararrapula nyinanytjaku, Kulayitjanya Tapitalu iluntanutjangka. Tapitaku ungkukitjangku ngunytji tjangkura wati kutjupalpi ungu. Palunyatjanu Tjuulaku yuṉṯalpa kutjupa ini Maakulanya Tapitaku yunytjura nyinangi. Palunyatjanu Tjuulalu Tapitanyaya Pilitjiyanya ngurrara tjuṯangku iluntankunytjaku kuliṉu. Kulira waarrkanangka watjaṉu Tapitangka ankula alatji tjakultjunkunytjaku, “Nyuntu ngayuku waputju nyinaku yuṉṯalpa Maakulanyaṉanta unganyingka. Nyuntu Pilitjiyanya ngurrara antaṯa kutju mirri wakara ilytjanpa kuntara ngalya katinytjaku. Ngalya katirraṉin ungkunyangka uṉṯalpaṉanta ungku.” Tjuulalu kuliṉu, “Tapitalu kutjungku tjananya mirri punganyingka, Pilitjiyanya ngurrara tjuṯangkuya ngururrtjura ngaparrtjingku mirri pungkunytjaku.” Tjuulaku wangka uṉṯalpa ungkukitjalu watjantja waarrkanalu tjakultjunanyingka, Tapitalu kulira yunyparringu. Palunyatjanu Tapitalu tjananya palumpa kuḻaṯatjarra tjuṯa katingu Pilitjiyanya ngurrara tjuṯa pikangku pungkunytjaku. Paluru tjana tuu antaṯa tjuṯa tjananya wakara iluntara ilytjanpa kuntara mantjiṉangi. Ilytjanpa palunya tjuṯa ngalya katirra Tjuulala kurungka kaantamilara ungu. Palunyangka Tapitanya piyuku uti nyakula puṯu kuliṉu. Yalatji palurulpi kuliṉingi, “Katutjalukampa Tapitanya yaṉṯayaṉṯara kanaṉingi.” Palulanguru Tjuulalulpi palumpa uṉṯalpa Maakulanya Tapitanya ungu. Tjuulalu tjananya watjaṉu palumpa waarrkana tjuṯangka, Tjaanatjangkaṯarra, Tapitanya mirri pungkukitjangku. Tjaanatjalu Tjuulanya marrkuṉu wantinytjaku, palunyangka Tjuulanyara yaḻṯururrirra pungkuwiyangku wantikitjangku watjaṉu. Tapitanya piyuku yankula Tjuulaku waaḻangka waarrkarriyankupayi. Mamu panyapangku Tjuulanya nguḻutjingaṉingka, Tapitalu ataṉmankukitjangku mutjika wangkatjingaṉingi. Panyapa Tjuulalu marangku manguḻpa kanyira Tapitanya aṉangu yuti wakalkitjangku puṯaṉu. Tapitanya nguḻu tjirrkara pakara tjalkaḻungu. Tjuulalu piyuku aṉangu uti wakalpayingkamarra, Tapitanyaṯarraya palumpa waarrkanaṯarra tjuṯa tjalkaḻungu tawunu Naapakutu. Ngurra ngaa palula tjaatji ngarangi. Tjaatjiku mayutju tiṉangku ini Yayimalikalu kanyilpayi. Tapitalu Yayimalikangka ngatjiṉu mangarriku, kanya Yayimalikalu watjaṉu, “Mangarri ngayukuṉu walytjawiyaṉa kanyiṉi. Mangarri tjaati kutju ngarrinyi tjaatjingka ngarripayi. Luwu alatji ngaranyingka, miiṯangkanyurra kuwarri ngarrinytjawiyalu palya ngalkunytjaku.” Tapitalu watjaṉu, “Wiyalatju kuwarri miiṯawana ngarringi.” Palunyatjanu Yayimalikalu palumpa ngurrangka tjarrparra puriiti tjaati tjaatjingka tjunkula wantinytjatjanu mantjirara Tapitaku yungu. Tapitanya maralpa nguḻu ngalyankula tjaatji palulakutu yanu, Tjuulalamarra. Paluru Yayimalikanya tjapiṉu, “Kuḻaṯa, tjuuḻan kanyiṉi?” Yayimalikalu Kulayitjaku tjuuḻa waṯawara tjaatjingka ngaratjunkula wantingutja mantjira Tapitaku yungu. Palunyatjanu Tapitanyaṯarraya tawunu Kaatjakutu ankula nyinangi. Tapitanya ngunytji rama nguwanpa nyinangi, Pilitjiyanya ngurrara tjuṯangku mirri pungkupayingkamarra. Palunyatjanu Tapitaṯarraya tawunu Kaatja wantirra ankula kuḻpingka nyinangi. Palumpa kaaka tjuṯaya Tjuulakuṯarra nguḻurrirra Tapitakutu tjungurringu. Tjuṯarringkulaya nyinangi. Palunyatjanuya manta Muwapakutu ankula nyinayinu. Palunyatjanuya tawunu Kiilakutu ankula tjananya pikalu pungu, Pilitjiyanya ngurrara tjuṯa. Alatji tjananya pikangku pungkulaya wantirriyara Kiilanya ngurrara tjuṯa kanaṉu. Palunyatjanu Tapitanyaṯarraya Kiilangka nyinangi. Palunyangka Tjuulalu palumpa tjilirratjarra tjuṯa aḻṯingu, Tapitanyaṯarra tjananya wanaraya pungkukitjangku. Tjuulanyaṯarraya ngalya yananyingka, Tapitalungarriya tjakulpa kulira kurranyu anu puḻi murrpuwana nyinakitja. Palunyatjanu Tjuulaluṯarra tjanampa puṯu ngurriraya maḻaku anu ngurrakutu. Alatji Tjuulalungarriya Tapitanyaṯarra mirri pungkukitjangku tjuṯangara wanalpayi. Tjuulaluṯarra tjananya pungkukitjangkuya wanarankula ngururrpa ngarripayi, puliinangka ngururrpa, yurilta. Kutjarrangara Tapitalu Tjuulanya urilta, kuḻpingkaṯarra ngarriyananyingka wantingu, mirri pungkuwiyalu. Katutjalu mayutju nyinatjunkunytja kulira wantipayi mirri pungkuwiyangku. Tjuulalamarraya Tapitanyangarriya ngurra kutjupawana nyinayinangi. ");
INSERT INTO piu2006_vpl VALUES ("S131_1","010_31_1","1SA","31","1","13","Tjiṉṯungkaya Pilitjiyanya ngurrara tjuṯa ngalya ankula, Tjuulanyaṯarra tjananya Yitjurilaku walytja ngaṉṯitja tjuṯaṯarra pikangku mirri pungkuyinangi. Tjuulaku katja maṉkurrpa kutju tjananya wanaraya pungkula iluntanu, Tjaanatjanya, Yapinatapanya, Malkitjuwanya. Tjuulaluṯarra waarrkana kutjupa tjuṯangku tjananya Pilitjiyanya ngurrara tjuṯa pungkuyinangitjangka, Pilitjiyanya ngurrarangku puwanarratjarrangku Tjuulanya kultu wakaṉu. Palumpa tjilirra katiyankupayingka Tjuulalu watjaṉu, “Pilitjiyanya ngurraraluṉi kutu wakara tjunkupayingka, tjuuḻa waṯawaratjarrangkuṉi parrpaṯu wakara iluntarra!” Yangupala paluru kulira nguḻurringkula wakalwiyangku wantingu. Palunyangka Tjuulalu tjuuḻa waṯawara walytja ngaratjunkula yiri kuṯuṯukutu ngalya ngaratjunu. Alatji ngaratjunkula ngalya punkaṉu, tjuuḻa yirikutu. Palunyangkara kuṯuṯungka ngalya tjarrparra witjurrulypa pakaṉu murrpungka. Alatjiya mirrirrinytjala angupala kutju tjalkaḻungkula Tapitangkaṯarra tjananya tjakultjunu. Kuliraya Tapitanyaṯarra palumpa kuḻaṯatjarra tjuṯa ularra yurrukulira ulangi. Yurrukuliraya mangarri ngalkuwiyangku wantingu. Mungarrinytjala Yitjurilaku walytja ngaṉṯitja tjuṯa puntu pika pungkula mirrirringutjangka, alatjiya yurrukulira ulangi. Tapitanya pulampa rawa yurrukulira ulangi Tjuulaku, anta Tjaanatjaku. ");
INSERT INTO piu2006_vpl VALUES ("S21_1","011_1_1","2SA","1","1","18","Tjiṉṯungkaya Pilitjiyanya ngurrara tjuṯa ngalya ankula, Tjuulanyaṯarra tjananya Yitjurilaku walytja ngaṉṯitja tjuṯaṯarra pikangku mirri pungkuyinangi. Tjuulaku katja maṉkurrpa kutju tjananya wanaraya pungkula iluntanu, Tjaanatjanya, Yapinatapanya, Malkitjuwanya. Tjuulaluṯarra waarrkana kutjupa tjuṯangku tjananya Pilitjiyanya ngurrara tjuṯa pungkuyinangitjangka, Pilitjiyanya ngurrarangku puwanarratjarrangku Tjuulanya kultu wakaṉu. Palumpa tjilirra katiyankupayingka Tjuulalu watjaṉu, “Pilitjiyanya ngurraraluṉi kutu wakara tjunkupayingka, tjuuḻa waṯawaratjarrangkuṉi parrpaṯu wakara iluntarra!” Yangupala paluru kulira nguḻurringkula wakalwiyangku wantingu. Palunyangka Tjuulalu tjuuḻa waṯawara walytja ngaratjunkula yiri kuṯuṯukutu ngalya ngaratjunu. Alatji ngaratjunkula ngalya punkaṉu, tjuuḻa yirikutu. Palunyangkara kuṯuṯungka ngalya tjarrparra witjurrulypa pakaṉu murrpungka. Alatjiya mirrirrinytjala angupala kutju tjalkaḻungkula Tapitangkaṯarra tjananya tjakultjunu. Kuliraya Tapitanyaṯarra palumpa kuḻaṯatjarra tjuṯa ularra yurrukulira ulangi. Yurrukuliraya mangarri ngalkuwiyangku wantingu. Mungarrinytjala Yitjurilaku walytja ngaṉṯitja tjuṯa puntu pika pungkula mirrirringutjangka, alatjiya yurrukulira ulangi. Tapitanya pulampa rawa yurrukulira ulangi Tjuulaku, anta Tjaanatjaku. ");
INSERT INTO piu2006_vpl VALUES ("S22_1","011_2_1","2SA","2","1","10","Tapitalu Katutjanya alatji tjapiṉu, “Yaalytjinkuṉa? Tjinguru Tjarutjalumangkaṉa wiya nyinaku? Tawunu kutjupakutu ngayulu ankula mayutju tjanampa palunya ngurrara tjuṯaku nyinaku?” Mayutju Katutjalu watjaṉu, “Yuwa, tawunu Yipurunakutu ankula nyinama!” Palunyangkaya Tapitanyaṯarra palumpa miiṯa kutjarra Yayinumanyakamu Yapikalanya tjungu anu ngurra Yipurunakutu, palumpa kuḻaṯatjarra tjuṯaṯarra. Tapitaku kuḻaṯatjarra tjuṯa ngalyankula tawunu Yipuranangka ila nyinangi, tawunu kutjupa tjuṯangkaṯarra. Palunyangkaya Tjuutaku walytja ngaṉṯitja tjuṯangku ngalya ankula Tapitaku yunyparringkula mayutju tiṉa nyinatjunu, tjira katangka intira. Yurrunpa Tjuulaku kuḻaṯatjarra tjuṯaku mayutju ini Yapinalu Tjuulaku katja Yitjiputjitjanya katingu, karru Tjuutanangka munkarra tawunu Mayanamikutu. Tawunu palula Yapinaluṯarra Yitjiputjitjanya mayutju tiṉa nyinatjunu, Yitjurilaku walytja ngaṉṯitja tjuṯaku. Tjuutaku walytja ngaṉṯitja tjuṯaku tjanampa wiya paluru mayutju tiṉa nyinangi, Tapitanya tjanampa mayutju tiṉa nyinangi. Yitjiputjitjanya tjanampa mayutju tiṉa nyinangi, kuḻi kutjarra. ");
INSERT INTO piu2006_vpl VALUES ("S22_12","011_2_12","2SA","2","12","23","(2:12-23; 3:22-39; 4:1-12; 5:1-10) Yitjiputjitjaku waarrkana tjuṯangkuya kuḻaṯatjarra tjuṯangku, Tapitaku waarrkana tjuṯangkuṯarrayanku pikangkuyanku pungkupayi. Pikaya punganyingka yuṯuyuṯu wati Yapinalu yangupala Yatjayilanya wakara mirrintanu. Palunyangka Yatjayilaku kaakangku ini Tjuwapalu Tapitaku waarrkanangku, Yapinanya ngaparrtjingku tjuuḻangku wakara mirrintanu, Tapitanya wapaḻpa nyinanyingka. Yalatji mirrintankunyangka Tapitanya Tjuwapaku kuyarringu. Yapinaku Tapitanyaṯarraya ularra tjunutjunu. Tapitalu Katutjanya tjapiṉu, Tjuwapanya ngaparrtji pungkunytjaku, mayutju Yapinatjirratjangku. Yapinanya wiyarrinytjala ngaṉṯi, Yitjiputjitjaku waarrkana kutjarrangkupula mingarrtjurrirra kuliṉu Yitjiputjitjanya mirri pungkukitjangku, Paanalukamu Rikapalu. Ankulapula waaḻangka yarrka tjarrparra Yitjiputjitjanya kutunpa ngarrinyingka mirri pungu. Lirripula kuntara kata kilytjuntankula katingu tawunu Yipuranakutu, mayutju Tapitalakutu, palumpa ngulytjurrikitjangku. Tapitalu yunyparrinytjawiyangku nyakula mirrpaṉarrirra payiṉu pulanya, mirri pungkupayi kutjarra. Palumpa kuḻaṯatjarrangka Tapitalu Yitjiputjitjatjirratjangku watjaṉu, ngaparrtjingku pulanya wakara mirrintankunytjaku. Palunyatjanu Yitjurilaku walytja ngaṉṯitja, mayutju tjuṯa Tapitakutu ngalya ankula yunyparringkula watjaṉu, “Walytjararrala nyinanyi. Tjuulanyalampa mayutju tiṉa nyinanyingka, nyuntulanyatju mayutju palyangku kuḻaṯatjarra tjuṯa pikakutu katipayi. Mayutju Katutjalunta yurrunpa watjaṉu, mayutju tiṉalampatjun nyinanytjaku.” Yalatji tjuṯangku puḻkapungkula Tapitanya mayutju tiṉa nyinatjunu. Palunyatjanu Tapitanya tjanampa Yitjurilaku walytja ngaṉṯitja tjuṯaku mayutju tiṉa nyinangi. Ngurra Yipuranangka kuḻi tjapanpala nyinarra Tapitalu tjananya palumpa kuḻaṯatjarra tjuṯa katingu, Tjarutjalumanya ngurrara tjuṯa mirri pungkukitjangku, Tapitakuya kutu rawa mingarrtju nyinanyingka. Paluru tjana pungkula tjananya militjitji tjuṯa mirrintara, Tapitanyalpi Tjarutjalumangkalpi nyinangi. ");
INSERT INTO piu2006_vpl VALUES ("S23_22","011_3_22","2SA","3","22","39","(2:12-23; 3:22-39; 4:1-12; 5:1-10) Yitjiputjitjaku waarrkana tjuṯangkuya kuḻaṯatjarra tjuṯangku, Tapitaku waarrkana tjuṯangkuṯarrayanku pikangkuyanku pungkupayi. Pikaya punganyingka yuṯuyuṯu wati Yapinalu yangupala Yatjayilanya wakara mirrintanu. Palunyangka Yatjayilaku kaakangku ini Tjuwapalu Tapitaku waarrkanangku, Yapinanya ngaparrtjingku tjuuḻangku wakara mirrintanu, Tapitanya wapaḻpa nyinanyingka. Yalatji mirrintankunyangka Tapitanya Tjuwapaku kuyarringu. Yapinaku Tapitanyaṯarraya ularra tjunutjunu. Tapitalu Katutjanya tjapiṉu, Tjuwapanya ngaparrtji pungkunytjaku, mayutju Yapinatjirratjangku. Yapinanya wiyarrinytjala ngaṉṯi, Yitjiputjitjaku waarrkana kutjarrangkupula mingarrtjurrirra kuliṉu Yitjiputjitjanya mirri pungkukitjangku, Paanalukamu Rikapalu. Ankulapula waaḻangka yarrka tjarrparra Yitjiputjitjanya kutunpa ngarrinyingka mirri pungu. Lirripula kuntara kata kilytjuntankula katingu tawunu Yipuranakutu, mayutju Tapitalakutu, palumpa ngulytjurrikitjangku. Tapitalu yunyparrinytjawiyangku nyakula mirrpaṉarrirra payiṉu pulanya, mirri pungkupayi kutjarra. Palumpa kuḻaṯatjarrangka Tapitalu Yitjiputjitjatjirratjangku watjaṉu, ngaparrtjingku pulanya wakara mirrintankunytjaku. Palunyatjanu Yitjurilaku walytja ngaṉṯitja, mayutju tjuṯa Tapitakutu ngalya ankula yunyparringkula watjaṉu, “Walytjararrala nyinanyi. Tjuulanyalampa mayutju tiṉa nyinanyingka, nyuntulanyatju mayutju palyangku kuḻaṯatjarra tjuṯa pikakutu katipayi. Mayutju Katutjalunta yurrunpa watjaṉu, mayutju tiṉalampatjun nyinanytjaku.” Yalatji tjuṯangku puḻkapungkula Tapitanya mayutju tiṉa nyinatjunu. Palunyatjanu Tapitanya tjanampa Yitjurilaku walytja ngaṉṯitja tjuṯaku mayutju tiṉa nyinangi. Ngurra Yipuranangka kuḻi tjapanpala nyinarra Tapitalu tjananya palumpa kuḻaṯatjarra tjuṯa katingu, Tjarutjalumanya ngurrara tjuṯa mirri pungkukitjangku, Tapitakuya kutu rawa mingarrtju nyinanyingka. Paluru tjana pungkula tjananya militjitji tjuṯa mirrintara, Tapitanyalpi Tjarutjalumangkalpi nyinangi. ");
INSERT INTO piu2006_vpl VALUES ("S24_1","011_4_1","2SA","4","1","12","(2:12-23; 3:22-39; 4:1-12; 5:1-10) Yitjiputjitjaku waarrkana tjuṯangkuya kuḻaṯatjarra tjuṯangku, Tapitaku waarrkana tjuṯangkuṯarrayanku pikangkuyanku pungkupayi. Pikaya punganyingka yuṯuyuṯu wati Yapinalu yangupala Yatjayilanya wakara mirrintanu. Palunyangka Yatjayilaku kaakangku ini Tjuwapalu Tapitaku waarrkanangku, Yapinanya ngaparrtjingku tjuuḻangku wakara mirrintanu, Tapitanya wapaḻpa nyinanyingka. Yalatji mirrintankunyangka Tapitanya Tjuwapaku kuyarringu. Yapinaku Tapitanyaṯarraya ularra tjunutjunu. Tapitalu Katutjanya tjapiṉu, Tjuwapanya ngaparrtji pungkunytjaku, mayutju Yapinatjirratjangku. Yapinanya wiyarrinytjala ngaṉṯi, Yitjiputjitjaku waarrkana kutjarrangkupula mingarrtjurrirra kuliṉu Yitjiputjitjanya mirri pungkukitjangku, Paanalukamu Rikapalu. Ankulapula waaḻangka yarrka tjarrparra Yitjiputjitjanya kutunpa ngarrinyingka mirri pungu. Lirripula kuntara kata kilytjuntankula katingu tawunu Yipuranakutu, mayutju Tapitalakutu, palumpa ngulytjurrikitjangku. Tapitalu yunyparrinytjawiyangku nyakula mirrpaṉarrirra payiṉu pulanya, mirri pungkupayi kutjarra. Palumpa kuḻaṯatjarrangka Tapitalu Yitjiputjitjatjirratjangku watjaṉu, ngaparrtjingku pulanya wakara mirrintankunytjaku. Palunyatjanu Yitjurilaku walytja ngaṉṯitja, mayutju tjuṯa Tapitakutu ngalya ankula yunyparringkula watjaṉu, “Walytjararrala nyinanyi. Tjuulanyalampa mayutju tiṉa nyinanyingka, nyuntulanyatju mayutju palyangku kuḻaṯatjarra tjuṯa pikakutu katipayi. Mayutju Katutjalunta yurrunpa watjaṉu, mayutju tiṉalampatjun nyinanytjaku.” Yalatji tjuṯangku puḻkapungkula Tapitanya mayutju tiṉa nyinatjunu. Palunyatjanu Tapitanya tjanampa Yitjurilaku walytja ngaṉṯitja tjuṯaku mayutju tiṉa nyinangi. Ngurra Yipuranangka kuḻi tjapanpala nyinarra Tapitalu tjananya palumpa kuḻaṯatjarra tjuṯa katingu, Tjarutjalumanya ngurrara tjuṯa mirri pungkukitjangku, Tapitakuya kutu rawa mingarrtju nyinanyingka. Paluru tjana pungkula tjananya militjitji tjuṯa mirrintara, Tapitanyalpi Tjarutjalumangkalpi nyinangi. ");
INSERT INTO piu2006_vpl VALUES ("S25_1","011_5_1","2SA","5","1","10","(2:12-23; 3:22-39; 4:1-12; 5:1-10) Yitjiputjitjaku waarrkana tjuṯangkuya kuḻaṯatjarra tjuṯangku, Tapitaku waarrkana tjuṯangkuṯarrayanku pikangkuyanku pungkupayi. Pikaya punganyingka yuṯuyuṯu wati Yapinalu yangupala Yatjayilanya wakara mirrintanu. Palunyangka Yatjayilaku kaakangku ini Tjuwapalu Tapitaku waarrkanangku, Yapinanya ngaparrtjingku tjuuḻangku wakara mirrintanu, Tapitanya wapaḻpa nyinanyingka. Yalatji mirrintankunyangka Tapitanya Tjuwapaku kuyarringu. Yapinaku Tapitanyaṯarraya ularra tjunutjunu. Tapitalu Katutjanya tjapiṉu, Tjuwapanya ngaparrtji pungkunytjaku, mayutju Yapinatjirratjangku. Yapinanya wiyarrinytjala ngaṉṯi, Yitjiputjitjaku waarrkana kutjarrangkupula mingarrtjurrirra kuliṉu Yitjiputjitjanya mirri pungkukitjangku, Paanalukamu Rikapalu. Ankulapula waaḻangka yarrka tjarrparra Yitjiputjitjanya kutunpa ngarrinyingka mirri pungu. Lirripula kuntara kata kilytjuntankula katingu tawunu Yipuranakutu, mayutju Tapitalakutu, palumpa ngulytjurrikitjangku. Tapitalu yunyparrinytjawiyangku nyakula mirrpaṉarrirra payiṉu pulanya, mirri pungkupayi kutjarra. Palumpa kuḻaṯatjarrangka Tapitalu Yitjiputjitjatjirratjangku watjaṉu, ngaparrtjingku pulanya wakara mirrintankunytjaku. Palunyatjanu Yitjurilaku walytja ngaṉṯitja, mayutju tjuṯa Tapitakutu ngalya ankula yunyparringkula watjaṉu, “Walytjararrala nyinanyi. Tjuulanyalampa mayutju tiṉa nyinanyingka, nyuntulanyatju mayutju palyangku kuḻaṯatjarra tjuṯa pikakutu katipayi. Mayutju Katutjalunta yurrunpa watjaṉu, mayutju tiṉalampatjun nyinanytjaku.” Yalatji tjuṯangku puḻkapungkula Tapitanya mayutju tiṉa nyinatjunu. Palunyatjanu Tapitanya tjanampa Yitjurilaku walytja ngaṉṯitja tjuṯaku mayutju tiṉa nyinangi. Ngurra Yipuranangka kuḻi tjapanpala nyinarra Tapitalu tjananya palumpa kuḻaṯatjarra tjuṯa katingu, Tjarutjalumanya ngurrara tjuṯa mirri pungkukitjangku, Tapitakuya kutu rawa mingarrtju nyinanyingka. Paluru tjana pungkula tjananya militjitji tjuṯa mirrintara, Tapitanyalpi Tjarutjalumangkalpi nyinangi. ");
INSERT INTO piu2006_vpl VALUES ("S26_1","011_6_1","2SA","6","1","15","(6:1-15; 7:1-12) Katutjaku pukutjungka puḻi wirulypa kutjarra ngarringi. Pukutjuya kulira Tapitanyaṯarra anu mantjira ngalya katikitja. Yapinatapaku ngurrangka mantjiraya wakinangka kaḻpatjunkula Tjarutjalumakutu katingu. Wakina katirra ngaratjunkula tjawirrilyiya pungkula kutjalpayi. Tjawirrilyi kutjupa piyuku pungkula kutjalpayi Katutjanya puḻkapungkukitjangku. Wakina Katutjaku pukutjutjarra katiyankunytjala ilawanaya taanytjirririnkupayi, Tapitanyaṯarra. Yalatjiya taanytjirrirra tjawirrilyiya kutjarinu, Katutjanya puḻkapungkula puukutju palunya katiyankula, puukutju palunya tjukarurruwiyangku, katinytjala, Katutjalu tjanampa mirrpaṉarrirra pungkutjipingkamarra. Yalatjiya Katutjaku puukutju Tjarutjalumakutu katirra tjunu. Mayutju tiṉaku waaḻangka Tapitalu nyinarra Katutjaku tjaatji palyalkitjangku wati Natjananya yalatji watjaṉu, “Ngayunyaṉa waaḻa palyangka nyinanyi, Katutjaku puukutju puḻi wirulypa kutjarratjarra kalikingka ngarrinyi. Waaḻa palyangka ngarrimara.” Katutjaku wangka watjalpayingku Natjanalu watjaṉu, “Panyapan kulintjatjanungku palyala!, mayutju Katutjalunta tjukarurru nintilku.” Mungangka Natjananya anku ngarrinyingka Katutjalu yalatji watjaṉu, “Tapitalakutu ankulara alatji tjakultjurra!, ‘Tapita, nyuntu wiya tjaatji ngayuku palyara ngaratjunkunytjaku, nyuntu mirrirringanyingka ngaṉṯingku nyuntupa katjangkulpi tjaatji ngayuku palyalku. Ngayuluṉa tjananya mayutju Katutjalu aṉangu ngurra tjuṯawana nyinanytja tjuṯa tjakultjunku, nyuntu mayutju tiṉa ngayuku palya nyinanyingka. Ngayuluṉa nyurranya manta ngaangka purinypa kanyilku, kuya tjuṯangku nyurranya ngalya ankula mirri pungkutjipingkamarra. Nyuntu mayutju tiṉa nyinanyingka, kutjupa tjuṯangku nyurranya wiyaya ngalya ankula pungkula wantirriyalku.’” ");
INSERT INTO piu2006_vpl VALUES ("S27_1","011_7_1","2SA","7","1","12","(6:1-15; 7:1-12) Katutjaku pukutjungka puḻi wirulypa kutjarra ngarringi. Pukutjuya kulira Tapitanyaṯarra anu mantjira ngalya katikitja. Yapinatapaku ngurrangka mantjiraya wakinangka kaḻpatjunkula Tjarutjalumakutu katingu. Wakina katirra ngaratjunkula tjawirrilyiya pungkula kutjalpayi. Tjawirrilyi kutjupa piyuku pungkula kutjalpayi Katutjanya puḻkapungkukitjangku. Wakina Katutjaku pukutjutjarra katiyankunytjala ilawanaya taanytjirririnkupayi, Tapitanyaṯarra. Yalatjiya taanytjirrirra tjawirrilyiya kutjarinu, Katutjanya puḻkapungkula puukutju palunya katiyankula, puukutju palunya tjukarurruwiyangku, katinytjala, Katutjalu tjanampa mirrpaṉarrirra pungkutjipingkamarra. Yalatjiya Katutjaku puukutju Tjarutjalumakutu katirra tjunu. Mayutju tiṉaku waaḻangka Tapitalu nyinarra Katutjaku tjaatji palyalkitjangku wati Natjananya yalatji watjaṉu, “Ngayunyaṉa waaḻa palyangka nyinanyi, Katutjaku puukutju puḻi wirulypa kutjarratjarra kalikingka ngarrinyi. Waaḻa palyangka ngarrimara.” Katutjaku wangka watjalpayingku Natjanalu watjaṉu, “Panyapan kulintjatjanungku palyala!, mayutju Katutjalunta tjukarurru nintilku.” Mungangka Natjananya anku ngarrinyingka Katutjalu yalatji watjaṉu, “Tapitalakutu ankulara alatji tjakultjurra!, ‘Tapita, nyuntu wiya tjaatji ngayuku palyara ngaratjunkunytjaku, nyuntu mirrirringanyingka ngaṉṯingku nyuntupa katjangkulpi tjaatji ngayuku palyalku. Ngayuluṉa tjananya mayutju Katutjalu aṉangu ngurra tjuṯawana nyinanytja tjuṯa tjakultjunku, nyuntu mayutju tiṉa ngayuku palya nyinanyingka. Ngayuluṉa nyurranya manta ngaangka purinypa kanyilku, kuya tjuṯangku nyurranya ngalya ankula mirri pungkutjipingkamarra. Nyuntu mayutju tiṉa nyinanyingka, kutjupa tjuṯangku nyurranya wiyaya ngalya ankula pungkula wantirriyalku.’” ");
INSERT INTO piu2006_vpl VALUES ("S27_13","011_7_13","2SA","7","13","17","Katutjaku wangka Natjanalu Tapitangka kutu alatji tjakultjunu, “Nyuntupa katjalutju ngayuku tjaatji palyara ngaratjunku. Katja paluru mayutju tiṉa nyinarra wiyarrinyingka, palumpa katjaṉa tjanampa mayutju tiṉa nyinatjunku. Palunya nyinarra wiyarrinyingka palumpa katjaṉa tjanampa mayutju tiṉa nyinatjunku. Alatji nguwanpaṉa tjananya nyinatjunku nyuntupa walytja ngaṉṯitja tjuṯa kutuya mayutju tjuṯa nyinamalpa. Tapita. Nyuntupa katja mayutju tiṉa nyinarra wiyawanangku palyantjangka ngayulu paapa aṉangu nguwanpangku itjipungku, tjukarurrulkitjangku. Wiyaṉa wantikatiku Tjuulanya nguwanpa, kutuṉa purinypa kanyilku.” ");
INSERT INTO piu2006_vpl VALUES ("S211_1","011_11_1","2SA","11","1","13","Tapitaluṯarra tjananya palumpa tjilirratjarra tjuṯa ankula, tjuṯangara tjananya kutjupa kutjupa tjuṯa mirri pungkula nguḻutjingara wantirriyalpayi. Palunyatjanungku tjananya ngurrangka nyinarra Tjuwapanyaṯarra palumpa tjilirratjarra tjuṯa wantirriyaṉu pikangku tjananya pungkuyinkunytjaku. Ngurrangka nyinarra Tapitalu waaḻa katunguru nyangu kungka palya, kapi yurungka walytjalungku paltjilkitja ngaranyingka. Nyakula palumpa waarrkana wantirriyaṉu, kungka palunya yaḻṯirra ngalya katinytjaku. Kala waarrkanangku kungka Patjipanya ngalya katingu, wati Yurayaku miiṯa. Tapitanyara yunytjurringkula kanyira piyuku iyaṉu ngurra walytjakutu. Ngula Patjipalu waarrkana piipatjarra wantirriyaṉu, Tapitalu riitarrirra kulintjaku, Tapitaku pipirri ngula yutirrinyingka. Wati Yurayalu Patjipaku miiṯangku tjananya ngurra waṉma pikangkuya punganyingka, Tapitalu waarrkana wantirriyaṉu, Yurayanya aḻṯirra ngalya katinytjaku. Yurayanya ngalya ankunyingka Tapitalu watjaṉu, ngurrakutu ankula palumpa miiṯangka aṉṯaṉṯantjaku, Patjipanya kanyintjatjanungku tjakultjunkunytjawiyangku. Yurayanya ngurrakutu ankula ngarrinytjawiya ngururrpa ngarringu. Tjilirratjarra kutjupa tjuṯangka tjananya Tapitaku ngurrangka, mungawinkiya tjungu pikakutu maḻaku ankukitja. ");
INSERT INTO piu2006_vpl VALUES ("S211_14","011_11_14","2SA","11","14","27","Palumpa miiṯangka ngarrinytjaku Tapitalu wati Yurayanya puṯu wituṉu. Puṯu witura piipa wakara mungawinki Yurayaku yungu, maḻaku katirra yungkuliyantjaku Tjuwapaku, tjilirratjarra tjuṯaku mayutjuku. Piipangka yara alatji Tapitalu wakaṉu, kungka Patjipanya kutu kanyilkitjangku, “Tjuwapa. Wati Yurayanya watjala!, yurrunpa ngaranytjaku pikangku pungkukitjangku. Paluru tjananya punganyingka ngaṉṯirrirraya kumpila!, wantirra nyakunytjaku, kutjulpi ngarala tjitjanytjaku, pungkunytjaku warrmaḻa kutjupa tjuṯangkuya.” Kala palunyatjanu Tjuwapaluṯarraya Yurayalu pikangku maa ngarala pungkuyananyingka yurrunpa wantirra maḻaku anu. Palunyatjanu kutjulpiya warrmaḻa kutjupa tjuṯangku Yurayanya ngururrtjura mirri pungu. Yurayanya ilungutjangka Patjipalu kulira yurrukulira ulangi palumpa miiṯatjirratja. Ngula Tapitalu yaḻṯingu palumpa miiṯalpi Patjipanya nyinanytjaku. Tapitaku ngurrangka nyinarra Patjipalu katja mantjiṉu. Yalatji Tapitalu wiyawanangku palyaṉutjangka, Katutjanyara mirrpaṉpa nyinangu. ");
INSERT INTO piu2006_vpl VALUES ("S212_1","011_12_1","2SA","12","1","12","Katutjaku wangka watjalpayi yini Natjananya Katutjalu Tapitalakutu wantirriyaṉu. Natjanalu yalatji watjaṉu, “Yaraṉanta watjalku. Wati kutjarra tawunu kutjungka nyinaku. Kutju yulytja tiṉatjarra, kutjupa wiyakampa maralpa. Yulytja tiṉatjarrangku tjiipi tjuṯa, puluka tjuṯaṯarra kanyilku, kanya maraltu tjiipi kutju kanyilku. Tjiipi kutju palunya purinytju kanyira yampura yititjunkupayi. Yulytja tiṉatjarraku waaḻakutu wati yanngatja ngalya anku. Palunyatjanu yulytja tiṉatjarrangku palumpa tjiipi tjuṯa wantirra ankula maral palumpa tjiipi ngulytju tjulyara katiku, kuka pungkula kutjalkitjangku. Pungkula kutjara yungku yanngatja palumpa.” Tapitalu yara palunya kulira mirrpaṉarringu maralpa palunyatjirratjangku watjaṉu, “Yulytja puntutjarrangku maralpa palumpa tjiipi ngulytju tjulyaṉutjangka mirri pungkunytjaku. Maralpa palumpa tjiipi puupala ngaparrtjingku yungkunytjaku.” Natjanalu Tapitanya yalatji kuru watjaṉu, “Nyuntu yulytja puntutjarrangku mulyaṯangku tjulyalpayi nguwanpa. Katutjalunta yalatji watjaṉu, ‘Katutjaluṉanta mayutju tiṉa nyinatjunu. Ngayuluṉanta miiṯa tjuṯa, mani yulytjaṯarra yungu. Nyaatjanulun ngayuku wangka wantirra kuya palunya palyaṉu? Nyuntu watjaṉu Yurayanyaya wantinyingka kutjupa tjuṯangkuya mirri pungkunytjaku. Palunyatjanun palumpa miiṯa mulyaṯangku mantjira kanyiṉi. Palunyangka nyuntupa walytja tjuṯaya pikangka mirrirriku ngayuku wangka nyuntu wantirra Yurayaku miiṯa tjulyara kanyiṉutjangka. Wati kutjupangku nyuntupa miiṯa tjuṯa tjulyara kanyilku.’” ");
INSERT INTO piu2006_vpl VALUES ("S212_13","011_12_13","2SA","12","13","23","Tapitalu wangka palunya kulira watjaṉu, “Yilta mayutju Katutjangkaṉa kuya palyaṉu.” Natjanalulpi watjaṉu, “Kuya palunya Katutjalunta waṉiku, palunyatjanun wiyan iluku. Katutjanyan kuya palunya palyara yuḻpaṯankunytjatjanungka, nyuntupa katja Patjipakuṉu iluku.” Yalatji tjakultjunkula wati Natjananya ngurrakutu anu. Patjipaku katja palunya pikatjarrarringkula pika puntutjarra ngarringi. Tapitalu mayi ngalkunytjawiyangku Katutjanya tjapiṉu, pipirri palunya palyarrinytjaku. Katjatjirratja waṯungarala yurrukulira yulangi. Katutjaku wangkawana katja palunya yilungu, palyarrinytjawiya. ");
INSERT INTO piu2006_vpl VALUES ("S212_24","011_12_24","2SA","12","24","25","Katja wiimapaṯu palunya wiyarringutjangka, Patjipanya yurrukulira yulangu. Palunyatjanu Tapitalu Patjipanya kutu kanyiṉingitjangka katja kutjupalpira yutirringu. Tapitalu katja palunya ini Tjalamunanya watjaṉu. Mayutju Katutjanya pipirri palumpa yulykarra nyinangi. ");
INSERT INTO piu2006_vpl VALUES ("S213_1","011_13_1","2SA","13","1","39","(13:1-21; 13:23-29,37-39; 14:21-24; 15:1-15; 16:15-23; 18:1,2,14-15,33; 21:15-22) Tapitaku katja Yamananya palumpa nyarrumpaku, kungka Tamaku yunytjurringkulara nyinangi. Yaḻṯikitjangku puṯu kulira pikatjarra nguwanparringu. Palumpa paapangka Tapitangkara tjapiṉu, palumpa nyarrumpa Tamalu ngalya yankula Yamanaku mangarri kutjara yungkunytjaku. Palunyatjanu Tamalura palumpa kaaka Yamanaku mangarri kutjara piitakutu katirra yungu. Yamanalu palumpa nyarrumpa maḻanypa tjapiṉu, tjungu ngarrikitjangku. Tamalu nguḻurrirra wiya watjaṉu. Palunyatjanu Yamanalu witira ngarritjunkula kanyiṉu. Kanyira mirrpaṉarrirra payira wantirriyaṉu. Wati kutjupaku nyinakitjangku puṯu kulira yularra yanu, kaaka kutjupangka tjakultjunkukitja, Yapatjalumala. Tjakultjunkunytja kulira Yapatjalumanya palumpa kaakaku Yamanaku mirrpaṉpa, pika nyinangi. Yiiya kutjarrarrirra Yapatjalumalu Tapitanya tjapiṉu, tjunguya Tapitaku katja tjuṯa kutjungkarrirra ngalkula pukuḻarrinytjaku. Tapitalu wiya watjaṉingka Yapatjalumalu kutu tjapiṉu kaaka Yamananya kutju yankula tjungungku ngalkula pukuḻarrinytjaku. Tapitalulpi watjaṉu katjararranpa Yamananyaṯarraya palya yankunytjaku. Yankulaya tjungungku ngalkula pulakina tjikira Yamananya rarrirarrirrinytjala, Yapatjalumaku waarrkana tjuṯangkuya mirri pungu, nyarrumpa Tamalara kuya palyaṉutjangka. Yapatjalumalu tjananya tjingapungutjangkaya mirri pungu. Yapatjalumaku maḻanypa kutjupa tjuṯa pakara nguḻurrirra tuungkiyi tjuṯangka kaḻparra ngurra Tjarutjalumakutu maḻakuya yanu. Yamananyaya mirri pungkunytjaku yalatji tjananya tjingapungkula Yapatjalumanya ngurra waṉmakutu ankula nyinangi. Tapitanya yuḻṯurrirra tjuḻurrmankula rawa yulangi. Tjuwapanya nyinangu tjilirratjarra tjuṯaku mayutju. Paluru Tapitanya tjapiṉu, yankula Yapatjalumanya aḻṯirra ngalya katinytjaku. Tapitalu yuwa watjaṉu. Palunyatjanu Yapatjalumanya maḻaku ngalya yankula Tjarutjalumangkalpi nyinanytjala Tapitalu Tjuwapanya watjaṉu, “Yapatjalumanya ngurra kutjupangka nyinanytjaku, ngayukuṉungka wiya. Ngayulu wiya yunytjurringanyi palunya nyakunytjaku.” Yapatjalumanya kutu nyinangu Tapitanya nyakunytjawiya. Yiiya kutjarra paluru ngurra kutjupangka nyinangi. Palunyatjanu Tapitanya Yapatjalumaku kalyparringu. Yiiya puupala Tjarutjalumangka nyinarra Yapatjalumalu kuliṉu mayutju tiṉa nyinakitjangku, aṉangu tjuṯaku. Paluru tjananya yaḻṯirra tjingapungkupayi mayutju nyinatjunkukitjangku, Tapitanya panypurangkula. Kutjupa tjuṯaya Tjarutjalumakutu ngalya yankunytjala, Yapatjalumanya tjanala tjungurrirra tjingapungkupayi mayutju nyinatjunkukitjangku. Yalatji yaṉangu tjuṯalingkura ngulytjurringu. Palunyatjanu yulparirra yankula nyinangi tawunu Yipuranangka. Yipuranangkaya Yapatjalumanyaṯarra waarrkana yantaṯa kutjarra tjungu nyinangi. Tawunu kutjupa tjuṯakutu Yapatjalumalu waarrkana tjuṯa wantirriyaṉu, yara yalatji tjananya tjakultjunkunytjaku, “Yapatjalumanyalpilampa mayutju tiṉa kuwarri nyinaku.” Tapitaluṯarraya Tjarutjalumangka nyinarra kuliṉu, Yapatjalumakuya mayutju tiṉa aṉangu tjuṯa yunyparringutjatjanungka. Palunyatjanungka Tapitalu tjananya palumpa waarrkana tjuṯangka watjaṉu, tjunguya pakara tjalkaḻungkukitjangku. Tapitalu palumpa miita tjuṯaṯarra Tjarutjalumangka wantirra anu. Paluru miiṯa kutjupa tjuṯa tjananya wantikatingu ngurra yaṉṯayaṉṯara kanyintjaku. Yapatjalumanyaṯarraya palumpa waarrkana tjuṯa Tjarutjalumakutu ngalya ankula Tapitaku ngurrangka nyinangi. Yapatjalumaku waarrkana Yatjiyupalalu Yapatjalumanya alatji tjingapungu, “Tapitaku miiṯa tjuṯangka nyuntulpi tjananya ngarri!, ngaangka wantikatinytja tjuṯawana.” Palunyatjanu Yapatjalumalu tjananya kanyiṉu, palumpa paapaku miiṯa tjuṯa, Tapitanya mirrpaṉpara nyinanytjaku. Palunyatjanu Yapatjalumalu tjananya Yitjurilaku walytja tjuṯa tjilirratjarra tjuṯa yaḻṯingu tjungurrinytjaku. Tjungurrirraya Tapitanyaṯarra pungkukitja anu. Palunyatjanu Tapitalu tjananya palumpa tjilirratjarra tjuṯa wantirriyaṉu, Yapatjalumanyaṯarra pikangku pungkunytjaku. Watjaṉu tjananya wantirriyalkitjangku, “Yapatjalumanya wiyanyurra mirri pungkunytjaku, witira kutjuya ngalya kati!” Tapitaku waarrkana tjuṯangku tjananya ngalya ankula pungkula nguḻutjingara wantirriyaṉu. Yapatjalumanya tjalkaḻungkukitja watiyangka yunnguwana miyulatjarra tjalkaḻungu. Palunyatjanu watiyangku mangka witira waralytjunkula kanyiṉingi. Waarrkana kutjupangku nyakula Tjuwapangka tjakultjunu. Tjuwapalu Tapitaku wangka kulira wantirra yankula waralyngarayananyingka kultu wakaṉu. Paluru yalatji wakaṉutjangka Tapitalu kulira yulangi. Tapitanyaṯarraya maḻaku ankula Tjarutjalumangka mayutju tiṉa nyinangi. Ngula Pilitjiyanya ngurrara tjuṯaya tjilirratjarra pikaku tjungurringu. Palunyatjanu tjananya Tapitaluṯarra palumpa tjilirratjarra tjuṯangkuya, pikangku pungkula nguḻutjingara wantirriyaṉu. ");
INSERT INTO piu2006_vpl VALUES ("S214_21","011_14_21","2SA","14","21","24","(13:1-21; 13:23-29,37-39; 14:21-24; 15:1-15; 16:15-23; 18:1,2,14-15,33; 21:15-22) Tapitaku katja Yamananya palumpa nyarrumpaku, kungka Tamaku yunytjurringkulara nyinangi. Yaḻṯikitjangku puṯu kulira pikatjarra nguwanparringu. Palumpa paapangka Tapitangkara tjapiṉu, palumpa nyarrumpa Tamalu ngalya yankula Yamanaku mangarri kutjara yungkunytjaku. Palunyatjanu Tamalura palumpa kaaka Yamanaku mangarri kutjara piitakutu katirra yungu. Yamanalu palumpa nyarrumpa maḻanypa tjapiṉu, tjungu ngarrikitjangku. Tamalu nguḻurrirra wiya watjaṉu. Palunyatjanu Yamanalu witira ngarritjunkula kanyiṉu. Kanyira mirrpaṉarrirra payira wantirriyaṉu. Wati kutjupaku nyinakitjangku puṯu kulira yularra yanu, kaaka kutjupangka tjakultjunkukitja, Yapatjalumala. Tjakultjunkunytja kulira Yapatjalumanya palumpa kaakaku Yamanaku mirrpaṉpa, pika nyinangi. Yiiya kutjarrarrirra Yapatjalumalu Tapitanya tjapiṉu, tjunguya Tapitaku katja tjuṯa kutjungkarrirra ngalkula pukuḻarrinytjaku. Tapitalu wiya watjaṉingka Yapatjalumalu kutu tjapiṉu kaaka Yamananya kutju yankula tjungungku ngalkula pukuḻarrinytjaku. Tapitalulpi watjaṉu katjararranpa Yamananyaṯarraya palya yankunytjaku. Yankulaya tjungungku ngalkula pulakina tjikira Yamananya rarrirarrirrinytjala, Yapatjalumaku waarrkana tjuṯangkuya mirri pungu, nyarrumpa Tamalara kuya palyaṉutjangka. Yapatjalumalu tjananya tjingapungutjangkaya mirri pungu. Yapatjalumaku maḻanypa kutjupa tjuṯa pakara nguḻurrirra tuungkiyi tjuṯangka kaḻparra ngurra Tjarutjalumakutu maḻakuya yanu. Yamananyaya mirri pungkunytjaku yalatji tjananya tjingapungkula Yapatjalumanya ngurra waṉmakutu ankula nyinangi. Tapitanya yuḻṯurrirra tjuḻurrmankula rawa yulangi. Tjuwapanya nyinangu tjilirratjarra tjuṯaku mayutju. Paluru Tapitanya tjapiṉu, yankula Yapatjalumanya aḻṯirra ngalya katinytjaku. Tapitalu yuwa watjaṉu. Palunyatjanu Yapatjalumanya maḻaku ngalya yankula Tjarutjalumangkalpi nyinanytjala Tapitalu Tjuwapanya watjaṉu, “Yapatjalumanya ngurra kutjupangka nyinanytjaku, ngayukuṉungka wiya. Ngayulu wiya yunytjurringanyi palunya nyakunytjaku.” Yapatjalumanya kutu nyinangu Tapitanya nyakunytjawiya. Yiiya kutjarra paluru ngurra kutjupangka nyinangi. Palunyatjanu Tapitanya Yapatjalumaku kalyparringu. Yiiya puupala Tjarutjalumangka nyinarra Yapatjalumalu kuliṉu mayutju tiṉa nyinakitjangku, aṉangu tjuṯaku. Paluru tjananya yaḻṯirra tjingapungkupayi mayutju nyinatjunkukitjangku, Tapitanya panypurangkula. Kutjupa tjuṯaya Tjarutjalumakutu ngalya yankunytjala, Yapatjalumanya tjanala tjungurrirra tjingapungkupayi mayutju nyinatjunkukitjangku. Yalatji yaṉangu tjuṯalingkura ngulytjurringu. Palunyatjanu yulparirra yankula nyinangi tawunu Yipuranangka. Yipuranangkaya Yapatjalumanyaṯarra waarrkana yantaṯa kutjarra tjungu nyinangi. Tawunu kutjupa tjuṯakutu Yapatjalumalu waarrkana tjuṯa wantirriyaṉu, yara yalatji tjananya tjakultjunkunytjaku, “Yapatjalumanyalpilampa mayutju tiṉa kuwarri nyinaku.” Tapitaluṯarraya Tjarutjalumangka nyinarra kuliṉu, Yapatjalumakuya mayutju tiṉa aṉangu tjuṯa yunyparringutjatjanungka. Palunyatjanungka Tapitalu tjananya palumpa waarrkana tjuṯangka watjaṉu, tjunguya pakara tjalkaḻungkukitjangku. Tapitalu palumpa miita tjuṯaṯarra Tjarutjalumangka wantirra anu. Paluru miiṯa kutjupa tjuṯa tjananya wantikatingu ngurra yaṉṯayaṉṯara kanyintjaku. Yapatjalumanyaṯarraya palumpa waarrkana tjuṯa Tjarutjalumakutu ngalya ankula Tapitaku ngurrangka nyinangi. Yapatjalumaku waarrkana Yatjiyupalalu Yapatjalumanya alatji tjingapungu, “Tapitaku miiṯa tjuṯangka nyuntulpi tjananya ngarri!, ngaangka wantikatinytja tjuṯawana.” Palunyatjanu Yapatjalumalu tjananya kanyiṉu, palumpa paapaku miiṯa tjuṯa, Tapitanya mirrpaṉpara nyinanytjaku. Palunyatjanu Yapatjalumalu tjananya Yitjurilaku walytja tjuṯa tjilirratjarra tjuṯa yaḻṯingu tjungurrinytjaku. Tjungurrirraya Tapitanyaṯarra pungkukitja anu. Palunyatjanu Tapitalu tjananya palumpa tjilirratjarra tjuṯa wantirriyaṉu, Yapatjalumanyaṯarra pikangku pungkunytjaku. Watjaṉu tjananya wantirriyalkitjangku, “Yapatjalumanya wiyanyurra mirri pungkunytjaku, witira kutjuya ngalya kati!” Tapitaku waarrkana tjuṯangku tjananya ngalya ankula pungkula nguḻutjingara wantirriyaṉu. Yapatjalumanya tjalkaḻungkukitja watiyangka yunnguwana miyulatjarra tjalkaḻungu. Palunyatjanu watiyangku mangka witira waralytjunkula kanyiṉingi. Waarrkana kutjupangku nyakula Tjuwapangka tjakultjunu. Tjuwapalu Tapitaku wangka kulira wantirra yankula waralyngarayananyingka kultu wakaṉu. Paluru yalatji wakaṉutjangka Tapitalu kulira yulangi. Tapitanyaṯarraya maḻaku ankula Tjarutjalumangka mayutju tiṉa nyinangi. Ngula Pilitjiyanya ngurrara tjuṯaya tjilirratjarra pikaku tjungurringu. Palunyatjanu tjananya Tapitaluṯarra palumpa tjilirratjarra tjuṯangkuya, pikangku pungkula nguḻutjingara wantirriyaṉu. ");
INSERT INTO piu2006_vpl VALUES ("S215_1","011_15_1","2SA","15","1","15","(13:1-21; 13:23-29,37-39; 14:21-24; 15:1-15; 16:15-23; 18:1,2,14-15,33; 21:15-22) Tapitaku katja Yamananya palumpa nyarrumpaku, kungka Tamaku yunytjurringkulara nyinangi. Yaḻṯikitjangku puṯu kulira pikatjarra nguwanparringu. Palumpa paapangka Tapitangkara tjapiṉu, palumpa nyarrumpa Tamalu ngalya yankula Yamanaku mangarri kutjara yungkunytjaku. Palunyatjanu Tamalura palumpa kaaka Yamanaku mangarri kutjara piitakutu katirra yungu. Yamanalu palumpa nyarrumpa maḻanypa tjapiṉu, tjungu ngarrikitjangku. Tamalu nguḻurrirra wiya watjaṉu. Palunyatjanu Yamanalu witira ngarritjunkula kanyiṉu. Kanyira mirrpaṉarrirra payira wantirriyaṉu. Wati kutjupaku nyinakitjangku puṯu kulira yularra yanu, kaaka kutjupangka tjakultjunkukitja, Yapatjalumala. Tjakultjunkunytja kulira Yapatjalumanya palumpa kaakaku Yamanaku mirrpaṉpa, pika nyinangi. Yiiya kutjarrarrirra Yapatjalumalu Tapitanya tjapiṉu, tjunguya Tapitaku katja tjuṯa kutjungkarrirra ngalkula pukuḻarrinytjaku. Tapitalu wiya watjaṉingka Yapatjalumalu kutu tjapiṉu kaaka Yamananya kutju yankula tjungungku ngalkula pukuḻarrinytjaku. Tapitalulpi watjaṉu katjararranpa Yamananyaṯarraya palya yankunytjaku. Yankulaya tjungungku ngalkula pulakina tjikira Yamananya rarrirarrirrinytjala, Yapatjalumaku waarrkana tjuṯangkuya mirri pungu, nyarrumpa Tamalara kuya palyaṉutjangka. Yapatjalumalu tjananya tjingapungutjangkaya mirri pungu. Yapatjalumaku maḻanypa kutjupa tjuṯa pakara nguḻurrirra tuungkiyi tjuṯangka kaḻparra ngurra Tjarutjalumakutu maḻakuya yanu. Yamananyaya mirri pungkunytjaku yalatji tjananya tjingapungkula Yapatjalumanya ngurra waṉmakutu ankula nyinangi. Tapitanya yuḻṯurrirra tjuḻurrmankula rawa yulangi. Tjuwapanya nyinangu tjilirratjarra tjuṯaku mayutju. Paluru Tapitanya tjapiṉu, yankula Yapatjalumanya aḻṯirra ngalya katinytjaku. Tapitalu yuwa watjaṉu. Palunyatjanu Yapatjalumanya maḻaku ngalya yankula Tjarutjalumangkalpi nyinanytjala Tapitalu Tjuwapanya watjaṉu, “Yapatjalumanya ngurra kutjupangka nyinanytjaku, ngayukuṉungka wiya. Ngayulu wiya yunytjurringanyi palunya nyakunytjaku.” Yapatjalumanya kutu nyinangu Tapitanya nyakunytjawiya. Yiiya kutjarra paluru ngurra kutjupangka nyinangi. Palunyatjanu Tapitanya Yapatjalumaku kalyparringu. Yiiya puupala Tjarutjalumangka nyinarra Yapatjalumalu kuliṉu mayutju tiṉa nyinakitjangku, aṉangu tjuṯaku. Paluru tjananya yaḻṯirra tjingapungkupayi mayutju nyinatjunkukitjangku, Tapitanya panypurangkula. Kutjupa tjuṯaya Tjarutjalumakutu ngalya yankunytjala, Yapatjalumanya tjanala tjungurrirra tjingapungkupayi mayutju nyinatjunkukitjangku. Yalatji yaṉangu tjuṯalingkura ngulytjurringu. Palunyatjanu yulparirra yankula nyinangi tawunu Yipuranangka. Yipuranangkaya Yapatjalumanyaṯarra waarrkana yantaṯa kutjarra tjungu nyinangi. Tawunu kutjupa tjuṯakutu Yapatjalumalu waarrkana tjuṯa wantirriyaṉu, yara yalatji tjananya tjakultjunkunytjaku, “Yapatjalumanyalpilampa mayutju tiṉa kuwarri nyinaku.” Tapitaluṯarraya Tjarutjalumangka nyinarra kuliṉu, Yapatjalumakuya mayutju tiṉa aṉangu tjuṯa yunyparringutjatjanungka. Palunyatjanungka Tapitalu tjananya palumpa waarrkana tjuṯangka watjaṉu, tjunguya pakara tjalkaḻungkukitjangku. Tapitalu palumpa miita tjuṯaṯarra Tjarutjalumangka wantirra anu. Paluru miiṯa kutjupa tjuṯa tjananya wantikatingu ngurra yaṉṯayaṉṯara kanyintjaku. Yapatjalumanyaṯarraya palumpa waarrkana tjuṯa Tjarutjalumakutu ngalya ankula Tapitaku ngurrangka nyinangi. Yapatjalumaku waarrkana Yatjiyupalalu Yapatjalumanya alatji tjingapungu, “Tapitaku miiṯa tjuṯangka nyuntulpi tjananya ngarri!, ngaangka wantikatinytja tjuṯawana.” Palunyatjanu Yapatjalumalu tjananya kanyiṉu, palumpa paapaku miiṯa tjuṯa, Tapitanya mirrpaṉpara nyinanytjaku. Palunyatjanu Yapatjalumalu tjananya Yitjurilaku walytja tjuṯa tjilirratjarra tjuṯa yaḻṯingu tjungurrinytjaku. Tjungurrirraya Tapitanyaṯarra pungkukitja anu. Palunyatjanu Tapitalu tjananya palumpa tjilirratjarra tjuṯa wantirriyaṉu, Yapatjalumanyaṯarra pikangku pungkunytjaku. Watjaṉu tjananya wantirriyalkitjangku, “Yapatjalumanya wiyanyurra mirri pungkunytjaku, witira kutjuya ngalya kati!” Tapitaku waarrkana tjuṯangku tjananya ngalya ankula pungkula nguḻutjingara wantirriyaṉu. Yapatjalumanya tjalkaḻungkukitja watiyangka yunnguwana miyulatjarra tjalkaḻungu. Palunyatjanu watiyangku mangka witira waralytjunkula kanyiṉingi. Waarrkana kutjupangku nyakula Tjuwapangka tjakultjunu. Tjuwapalu Tapitaku wangka kulira wantirra yankula waralyngarayananyingka kultu wakaṉu. Paluru yalatji wakaṉutjangka Tapitalu kulira yulangi. Tapitanyaṯarraya maḻaku ankula Tjarutjalumangka mayutju tiṉa nyinangi. Ngula Pilitjiyanya ngurrara tjuṯaya tjilirratjarra pikaku tjungurringu. Palunyatjanu tjananya Tapitaluṯarra palumpa tjilirratjarra tjuṯangkuya, pikangku pungkula nguḻutjingara wantirriyaṉu. ");
INSERT INTO piu2006_vpl VALUES ("S216_15","011_16_15","2SA","16","15","23","(13:1-21; 13:23-29,37-39; 14:21-24; 15:1-15; 16:15-23; 18:1,2,14-15,33; 21:15-22) Tapitaku katja Yamananya palumpa nyarrumpaku, kungka Tamaku yunytjurringkulara nyinangi. Yaḻṯikitjangku puṯu kulira pikatjarra nguwanparringu. Palumpa paapangka Tapitangkara tjapiṉu, palumpa nyarrumpa Tamalu ngalya yankula Yamanaku mangarri kutjara yungkunytjaku. Palunyatjanu Tamalura palumpa kaaka Yamanaku mangarri kutjara piitakutu katirra yungu. Yamanalu palumpa nyarrumpa maḻanypa tjapiṉu, tjungu ngarrikitjangku. Tamalu nguḻurrirra wiya watjaṉu. Palunyatjanu Yamanalu witira ngarritjunkula kanyiṉu. Kanyira mirrpaṉarrirra payira wantirriyaṉu. Wati kutjupaku nyinakitjangku puṯu kulira yularra yanu, kaaka kutjupangka tjakultjunkukitja, Yapatjalumala. Tjakultjunkunytja kulira Yapatjalumanya palumpa kaakaku Yamanaku mirrpaṉpa, pika nyinangi. Yiiya kutjarrarrirra Yapatjalumalu Tapitanya tjapiṉu, tjunguya Tapitaku katja tjuṯa kutjungkarrirra ngalkula pukuḻarrinytjaku. Tapitalu wiya watjaṉingka Yapatjalumalu kutu tjapiṉu kaaka Yamananya kutju yankula tjungungku ngalkula pukuḻarrinytjaku. Tapitalulpi watjaṉu katjararranpa Yamananyaṯarraya palya yankunytjaku. Yankulaya tjungungku ngalkula pulakina tjikira Yamananya rarrirarrirrinytjala, Yapatjalumaku waarrkana tjuṯangkuya mirri pungu, nyarrumpa Tamalara kuya palyaṉutjangka. Yapatjalumalu tjananya tjingapungutjangkaya mirri pungu. Yapatjalumaku maḻanypa kutjupa tjuṯa pakara nguḻurrirra tuungkiyi tjuṯangka kaḻparra ngurra Tjarutjalumakutu maḻakuya yanu. Yamananyaya mirri pungkunytjaku yalatji tjananya tjingapungkula Yapatjalumanya ngurra waṉmakutu ankula nyinangi. Tapitanya yuḻṯurrirra tjuḻurrmankula rawa yulangi. Tjuwapanya nyinangu tjilirratjarra tjuṯaku mayutju. Paluru Tapitanya tjapiṉu, yankula Yapatjalumanya aḻṯirra ngalya katinytjaku. Tapitalu yuwa watjaṉu. Palunyatjanu Yapatjalumanya maḻaku ngalya yankula Tjarutjalumangkalpi nyinanytjala Tapitalu Tjuwapanya watjaṉu, “Yapatjalumanya ngurra kutjupangka nyinanytjaku, ngayukuṉungka wiya. Ngayulu wiya yunytjurringanyi palunya nyakunytjaku.” Yapatjalumanya kutu nyinangu Tapitanya nyakunytjawiya. Yiiya kutjarra paluru ngurra kutjupangka nyinangi. Palunyatjanu Tapitanya Yapatjalumaku kalyparringu. Yiiya puupala Tjarutjalumangka nyinarra Yapatjalumalu kuliṉu mayutju tiṉa nyinakitjangku, aṉangu tjuṯaku. Paluru tjananya yaḻṯirra tjingapungkupayi mayutju nyinatjunkukitjangku, Tapitanya panypurangkula. Kutjupa tjuṯaya Tjarutjalumakutu ngalya yankunytjala, Yapatjalumanya tjanala tjungurrirra tjingapungkupayi mayutju nyinatjunkukitjangku. Yalatji yaṉangu tjuṯalingkura ngulytjurringu. Palunyatjanu yulparirra yankula nyinangi tawunu Yipuranangka. Yipuranangkaya Yapatjalumanyaṯarra waarrkana yantaṯa kutjarra tjungu nyinangi. Tawunu kutjupa tjuṯakutu Yapatjalumalu waarrkana tjuṯa wantirriyaṉu, yara yalatji tjananya tjakultjunkunytjaku, “Yapatjalumanyalpilampa mayutju tiṉa kuwarri nyinaku.” Tapitaluṯarraya Tjarutjalumangka nyinarra kuliṉu, Yapatjalumakuya mayutju tiṉa aṉangu tjuṯa yunyparringutjatjanungka. Palunyatjanungka Tapitalu tjananya palumpa waarrkana tjuṯangka watjaṉu, tjunguya pakara tjalkaḻungkukitjangku. Tapitalu palumpa miita tjuṯaṯarra Tjarutjalumangka wantirra anu. Paluru miiṯa kutjupa tjuṯa tjananya wantikatingu ngurra yaṉṯayaṉṯara kanyintjaku. Yapatjalumanyaṯarraya palumpa waarrkana tjuṯa Tjarutjalumakutu ngalya ankula Tapitaku ngurrangka nyinangi. Yapatjalumaku waarrkana Yatjiyupalalu Yapatjalumanya alatji tjingapungu, “Tapitaku miiṯa tjuṯangka nyuntulpi tjananya ngarri!, ngaangka wantikatinytja tjuṯawana.” Palunyatjanu Yapatjalumalu tjananya kanyiṉu, palumpa paapaku miiṯa tjuṯa, Tapitanya mirrpaṉpara nyinanytjaku. Palunyatjanu Yapatjalumalu tjananya Yitjurilaku walytja tjuṯa tjilirratjarra tjuṯa yaḻṯingu tjungurrinytjaku. Tjungurrirraya Tapitanyaṯarra pungkukitja anu. Palunyatjanu Tapitalu tjananya palumpa tjilirratjarra tjuṯa wantirriyaṉu, Yapatjalumanyaṯarra pikangku pungkunytjaku. Watjaṉu tjananya wantirriyalkitjangku, “Yapatjalumanya wiyanyurra mirri pungkunytjaku, witira kutjuya ngalya kati!” Tapitaku waarrkana tjuṯangku tjananya ngalya ankula pungkula nguḻutjingara wantirriyaṉu. Yapatjalumanya tjalkaḻungkukitja watiyangka yunnguwana miyulatjarra tjalkaḻungu. Palunyatjanu watiyangku mangka witira waralytjunkula kanyiṉingi. Waarrkana kutjupangku nyakula Tjuwapangka tjakultjunu. Tjuwapalu Tapitaku wangka kulira wantirra yankula waralyngarayananyingka kultu wakaṉu. Paluru yalatji wakaṉutjangka Tapitalu kulira yulangi. Tapitanyaṯarraya maḻaku ankula Tjarutjalumangka mayutju tiṉa nyinangi. Ngula Pilitjiyanya ngurrara tjuṯaya tjilirratjarra pikaku tjungurringu. Palunyatjanu tjananya Tapitaluṯarra palumpa tjilirratjarra tjuṯangkuya, pikangku pungkula nguḻutjingara wantirriyaṉu. ");
INSERT INTO piu2006_vpl VALUES ("S218_1","011_18_1","2SA","18","1","33","(13:1-21; 13:23-29,37-39; 14:21-24; 15:1-15; 16:15-23; 18:1,2,14-15,33; 21:15-22) Tapitaku katja Yamananya palumpa nyarrumpaku, kungka Tamaku yunytjurringkulara nyinangi. Yaḻṯikitjangku puṯu kulira pikatjarra nguwanparringu. Palumpa paapangka Tapitangkara tjapiṉu, palumpa nyarrumpa Tamalu ngalya yankula Yamanaku mangarri kutjara yungkunytjaku. Palunyatjanu Tamalura palumpa kaaka Yamanaku mangarri kutjara piitakutu katirra yungu. Yamanalu palumpa nyarrumpa maḻanypa tjapiṉu, tjungu ngarrikitjangku. Tamalu nguḻurrirra wiya watjaṉu. Palunyatjanu Yamanalu witira ngarritjunkula kanyiṉu. Kanyira mirrpaṉarrirra payira wantirriyaṉu. Wati kutjupaku nyinakitjangku puṯu kulira yularra yanu, kaaka kutjupangka tjakultjunkukitja, Yapatjalumala. Tjakultjunkunytja kulira Yapatjalumanya palumpa kaakaku Yamanaku mirrpaṉpa, pika nyinangi. Yiiya kutjarrarrirra Yapatjalumalu Tapitanya tjapiṉu, tjunguya Tapitaku katja tjuṯa kutjungkarrirra ngalkula pukuḻarrinytjaku. Tapitalu wiya watjaṉingka Yapatjalumalu kutu tjapiṉu kaaka Yamananya kutju yankula tjungungku ngalkula pukuḻarrinytjaku. Tapitalulpi watjaṉu katjararranpa Yamananyaṯarraya palya yankunytjaku. Yankulaya tjungungku ngalkula pulakina tjikira Yamananya rarrirarrirrinytjala, Yapatjalumaku waarrkana tjuṯangkuya mirri pungu, nyarrumpa Tamalara kuya palyaṉutjangka. Yapatjalumalu tjananya tjingapungutjangkaya mirri pungu. Yapatjalumaku maḻanypa kutjupa tjuṯa pakara nguḻurrirra tuungkiyi tjuṯangka kaḻparra ngurra Tjarutjalumakutu maḻakuya yanu. Yamananyaya mirri pungkunytjaku yalatji tjananya tjingapungkula Yapatjalumanya ngurra waṉmakutu ankula nyinangi. Tapitanya yuḻṯurrirra tjuḻurrmankula rawa yulangi. Tjuwapanya nyinangu tjilirratjarra tjuṯaku mayutju. Paluru Tapitanya tjapiṉu, yankula Yapatjalumanya aḻṯirra ngalya katinytjaku. Tapitalu yuwa watjaṉu. Palunyatjanu Yapatjalumanya maḻaku ngalya yankula Tjarutjalumangkalpi nyinanytjala Tapitalu Tjuwapanya watjaṉu, “Yapatjalumanya ngurra kutjupangka nyinanytjaku, ngayukuṉungka wiya. Ngayulu wiya yunytjurringanyi palunya nyakunytjaku.” Yapatjalumanya kutu nyinangu Tapitanya nyakunytjawiya. Yiiya kutjarra paluru ngurra kutjupangka nyinangi. Palunyatjanu Tapitanya Yapatjalumaku kalyparringu. Yiiya puupala Tjarutjalumangka nyinarra Yapatjalumalu kuliṉu mayutju tiṉa nyinakitjangku, aṉangu tjuṯaku. Paluru tjananya yaḻṯirra tjingapungkupayi mayutju nyinatjunkukitjangku, Tapitanya panypurangkula. Kutjupa tjuṯaya Tjarutjalumakutu ngalya yankunytjala, Yapatjalumanya tjanala tjungurrirra tjingapungkupayi mayutju nyinatjunkukitjangku. Yalatji yaṉangu tjuṯalingkura ngulytjurringu. Palunyatjanu yulparirra yankula nyinangi tawunu Yipuranangka. Yipuranangkaya Yapatjalumanyaṯarra waarrkana yantaṯa kutjarra tjungu nyinangi. Tawunu kutjupa tjuṯakutu Yapatjalumalu waarrkana tjuṯa wantirriyaṉu, yara yalatji tjananya tjakultjunkunytjaku, “Yapatjalumanyalpilampa mayutju tiṉa kuwarri nyinaku.” Tapitaluṯarraya Tjarutjalumangka nyinarra kuliṉu, Yapatjalumakuya mayutju tiṉa aṉangu tjuṯa yunyparringutjatjanungka. Palunyatjanungka Tapitalu tjananya palumpa waarrkana tjuṯangka watjaṉu, tjunguya pakara tjalkaḻungkukitjangku. Tapitalu palumpa miita tjuṯaṯarra Tjarutjalumangka wantirra anu. Paluru miiṯa kutjupa tjuṯa tjananya wantikatingu ngurra yaṉṯayaṉṯara kanyintjaku. Yapatjalumanyaṯarraya palumpa waarrkana tjuṯa Tjarutjalumakutu ngalya ankula Tapitaku ngurrangka nyinangi. Yapatjalumaku waarrkana Yatjiyupalalu Yapatjalumanya alatji tjingapungu, “Tapitaku miiṯa tjuṯangka nyuntulpi tjananya ngarri!, ngaangka wantikatinytja tjuṯawana.” Palunyatjanu Yapatjalumalu tjananya kanyiṉu, palumpa paapaku miiṯa tjuṯa, Tapitanya mirrpaṉpara nyinanytjaku. Palunyatjanu Yapatjalumalu tjananya Yitjurilaku walytja tjuṯa tjilirratjarra tjuṯa yaḻṯingu tjungurrinytjaku. Tjungurrirraya Tapitanyaṯarra pungkukitja anu. Palunyatjanu Tapitalu tjananya palumpa tjilirratjarra tjuṯa wantirriyaṉu, Yapatjalumanyaṯarra pikangku pungkunytjaku. Watjaṉu tjananya wantirriyalkitjangku, “Yapatjalumanya wiyanyurra mirri pungkunytjaku, witira kutjuya ngalya kati!” Tapitaku waarrkana tjuṯangku tjananya ngalya ankula pungkula nguḻutjingara wantirriyaṉu. Yapatjalumanya tjalkaḻungkukitja watiyangka yunnguwana miyulatjarra tjalkaḻungu. Palunyatjanu watiyangku mangka witira waralytjunkula kanyiṉingi. Waarrkana kutjupangku nyakula Tjuwapangka tjakultjunu. Tjuwapalu Tapitaku wangka kulira wantirra yankula waralyngarayananyingka kultu wakaṉu. Paluru yalatji wakaṉutjangka Tapitalu kulira yulangi. Tapitanyaṯarraya maḻaku ankula Tjarutjalumangka mayutju tiṉa nyinangi. Ngula Pilitjiyanya ngurrara tjuṯaya tjilirratjarra pikaku tjungurringu. Palunyatjanu tjananya Tapitaluṯarra palumpa tjilirratjarra tjuṯangkuya, pikangku pungkula nguḻutjingara wantirriyaṉu. ");
INSERT INTO piu2006_vpl VALUES ("S221_15","011_21_15","2SA","21","15","22","(13:1-21; 13:23-29,37-39; 14:21-24; 15:1-15; 16:15-23; 18:1,2,14-15,33; 21:15-22) Tapitaku katja Yamananya palumpa nyarrumpaku, kungka Tamaku yunytjurringkulara nyinangi. Yaḻṯikitjangku puṯu kulira pikatjarra nguwanparringu. Palumpa paapangka Tapitangkara tjapiṉu, palumpa nyarrumpa Tamalu ngalya yankula Yamanaku mangarri kutjara yungkunytjaku. Palunyatjanu Tamalura palumpa kaaka Yamanaku mangarri kutjara piitakutu katirra yungu. Yamanalu palumpa nyarrumpa maḻanypa tjapiṉu, tjungu ngarrikitjangku. Tamalu nguḻurrirra wiya watjaṉu. Palunyatjanu Yamanalu witira ngarritjunkula kanyiṉu. Kanyira mirrpaṉarrirra payira wantirriyaṉu. Wati kutjupaku nyinakitjangku puṯu kulira yularra yanu, kaaka kutjupangka tjakultjunkukitja, Yapatjalumala. Tjakultjunkunytja kulira Yapatjalumanya palumpa kaakaku Yamanaku mirrpaṉpa, pika nyinangi. Yiiya kutjarrarrirra Yapatjalumalu Tapitanya tjapiṉu, tjunguya Tapitaku katja tjuṯa kutjungkarrirra ngalkula pukuḻarrinytjaku. Tapitalu wiya watjaṉingka Yapatjalumalu kutu tjapiṉu kaaka Yamananya kutju yankula tjungungku ngalkula pukuḻarrinytjaku. Tapitalulpi watjaṉu katjararranpa Yamananyaṯarraya palya yankunytjaku. Yankulaya tjungungku ngalkula pulakina tjikira Yamananya rarrirarrirrinytjala, Yapatjalumaku waarrkana tjuṯangkuya mirri pungu, nyarrumpa Tamalara kuya palyaṉutjangka. Yapatjalumalu tjananya tjingapungutjangkaya mirri pungu. Yapatjalumaku maḻanypa kutjupa tjuṯa pakara nguḻurrirra tuungkiyi tjuṯangka kaḻparra ngurra Tjarutjalumakutu maḻakuya yanu. Yamananyaya mirri pungkunytjaku yalatji tjananya tjingapungkula Yapatjalumanya ngurra waṉmakutu ankula nyinangi. Tapitanya yuḻṯurrirra tjuḻurrmankula rawa yulangi. Tjuwapanya nyinangu tjilirratjarra tjuṯaku mayutju. Paluru Tapitanya tjapiṉu, yankula Yapatjalumanya aḻṯirra ngalya katinytjaku. Tapitalu yuwa watjaṉu. Palunyatjanu Yapatjalumanya maḻaku ngalya yankula Tjarutjalumangkalpi nyinanytjala Tapitalu Tjuwapanya watjaṉu, “Yapatjalumanya ngurra kutjupangka nyinanytjaku, ngayukuṉungka wiya. Ngayulu wiya yunytjurringanyi palunya nyakunytjaku.” Yapatjalumanya kutu nyinangu Tapitanya nyakunytjawiya. Yiiya kutjarra paluru ngurra kutjupangka nyinangi. Palunyatjanu Tapitanya Yapatjalumaku kalyparringu. Yiiya puupala Tjarutjalumangka nyinarra Yapatjalumalu kuliṉu mayutju tiṉa nyinakitjangku, aṉangu tjuṯaku. Paluru tjananya yaḻṯirra tjingapungkupayi mayutju nyinatjunkukitjangku, Tapitanya panypurangkula. Kutjupa tjuṯaya Tjarutjalumakutu ngalya yankunytjala, Yapatjalumanya tjanala tjungurrirra tjingapungkupayi mayutju nyinatjunkukitjangku. Yalatji yaṉangu tjuṯalingkura ngulytjurringu. Palunyatjanu yulparirra yankula nyinangi tawunu Yipuranangka. Yipuranangkaya Yapatjalumanyaṯarra waarrkana yantaṯa kutjarra tjungu nyinangi. Tawunu kutjupa tjuṯakutu Yapatjalumalu waarrkana tjuṯa wantirriyaṉu, yara yalatji tjananya tjakultjunkunytjaku, “Yapatjalumanyalpilampa mayutju tiṉa kuwarri nyinaku.” Tapitaluṯarraya Tjarutjalumangka nyinarra kuliṉu, Yapatjalumakuya mayutju tiṉa aṉangu tjuṯa yunyparringutjatjanungka. Palunyatjanungka Tapitalu tjananya palumpa waarrkana tjuṯangka watjaṉu, tjunguya pakara tjalkaḻungkukitjangku. Tapitalu palumpa miita tjuṯaṯarra Tjarutjalumangka wantirra anu. Paluru miiṯa kutjupa tjuṯa tjananya wantikatingu ngurra yaṉṯayaṉṯara kanyintjaku. Yapatjalumanyaṯarraya palumpa waarrkana tjuṯa Tjarutjalumakutu ngalya ankula Tapitaku ngurrangka nyinangi. Yapatjalumaku waarrkana Yatjiyupalalu Yapatjalumanya alatji tjingapungu, “Tapitaku miiṯa tjuṯangka nyuntulpi tjananya ngarri!, ngaangka wantikatinytja tjuṯawana.” Palunyatjanu Yapatjalumalu tjananya kanyiṉu, palumpa paapaku miiṯa tjuṯa, Tapitanya mirrpaṉpara nyinanytjaku. Palunyatjanu Yapatjalumalu tjananya Yitjurilaku walytja tjuṯa tjilirratjarra tjuṯa yaḻṯingu tjungurrinytjaku. Tjungurrirraya Tapitanyaṯarra pungkukitja anu. Palunyatjanu Tapitalu tjananya palumpa tjilirratjarra tjuṯa wantirriyaṉu, Yapatjalumanyaṯarra pikangku pungkunytjaku. Watjaṉu tjananya wantirriyalkitjangku, “Yapatjalumanya wiyanyurra mirri pungkunytjaku, witira kutjuya ngalya kati!” Tapitaku waarrkana tjuṯangku tjananya ngalya ankula pungkula nguḻutjingara wantirriyaṉu. Yapatjalumanya tjalkaḻungkukitja watiyangka yunnguwana miyulatjarra tjalkaḻungu. Palunyatjanu watiyangku mangka witira waralytjunkula kanyiṉingi. Waarrkana kutjupangku nyakula Tjuwapangka tjakultjunu. Tjuwapalu Tapitaku wangka kulira wantirra yankula waralyngarayananyingka kultu wakaṉu. Paluru yalatji wakaṉutjangka Tapitalu kulira yulangi. Tapitanyaṯarraya maḻaku ankula Tjarutjalumangka mayutju tiṉa nyinangi. Ngula Pilitjiyanya ngurrara tjuṯaya tjilirratjarra pikaku tjungurringu. Palunyatjanu tjananya Tapitaluṯarra palumpa tjilirratjarra tjuṯangkuya, pikangku pungkula nguḻutjingara wantirriyaṉu. ");
INSERT INTO piu2006_vpl VALUES ("K11_5","012_1_5","1KI","1","5","40","(1:5-10,15-18,32-40; 2:10,11) Tapitanya tjiḻpirrirra kunpu nyinanyingka, palumpa katja yurruntitja Yatunitjanya yunypa nyinangi, mayutju tiṉa nyinakitja, kanya Patjipalu kuliṉu, palumpa katja Tjalamunanya mayutju tiṉalpi nyinanytjaku. Tapitalakutu ankula marrkuṉu, “Nyuntukunyuṉin yurrunpa watjaṉutjatjanungku Tjalamunanya mayutju tiṉa nyinatjurra!, Yatunitjanya mayutju tiṉa nyinatjipingkamarra.” Tapitalu pulanya watjaṉu, tuḻkuku mayutju kutjarrangku Natjanalu anta Tjatakalu tjira Tjalamunangka katangka intira mayutju tiṉalpi nyinatjunkunytjaku. Tjatakalu Tjalamunanya mayutju tiṉalpi nyinatjunu. Tjiḻpi Tapitalu Tjalamunanya wangkarra nintiṉu, mayutju palya tjukarurru nyinanytjaku. Palunyatjanu Tapitanya muḻṯunyarrirra ilungu. Tapitanya mayutju tiṉa tjanampa rawa nyinangi, yiiya puutiyipala. ");
INSERT INTO piu2006_vpl VALUES ("K12_10","012_2_10","1KI","2","10","11","(1:5-10,15-18,32-40; 2:10,11) Tapitanya tjiḻpirrirra kunpu nyinanyingka, palumpa katja yurruntitja Yatunitjanya yunypa nyinangi, mayutju tiṉa nyinakitja, kanya Patjipalu kuliṉu, palumpa katja Tjalamunanya mayutju tiṉalpi nyinanytjaku. Tapitalakutu ankula marrkuṉu, “Nyuntukunyuṉin yurrunpa watjaṉutjatjanungku Tjalamunanya mayutju tiṉa nyinatjurra!, Yatunitjanya mayutju tiṉa nyinatjipingkamarra.” Tapitalu pulanya watjaṉu, tuḻkuku mayutju kutjarrangku Natjanalu anta Tjatakalu tjira Tjalamunangka katangka intira mayutju tiṉalpi nyinatjunkunytjaku. Tjatakalu Tjalamunanya mayutju tiṉalpi nyinatjunu. Tjiḻpi Tapitalu Tjalamunanya wangkarra nintiṉu, mayutju palya tjukarurru nyinanytjaku. Palunyatjanu Tapitanya muḻṯunyarrirra ilungu. Tapitanya mayutju tiṉa tjanampa rawa nyinangi, yiiya puutiyipala. ");
INSERT INTO piu2006_vpl VALUES ("K13_1","012_3_1","1KI","3","1","15","Tjalamunanya Katutjaku yunytjurrirra nyinangi. Palumpa paapangku watjaṉutjatjanungka kulira tjukarurru nyinangi. Tjalamunanya anu tawunu Kipiyanalakutu, mungawinki Katutjaku tjawirrilyi pungkula tjunkukitjangku. Mungangka anku ngarrirra tjukurrmananyingka Katutjalu alatji tjapiṉu, “Nyaakupan yunytjurringanyi?, ngayuluṉanta ungkunytjaku?” Tjalamunalu watjaṉu, “Nyuntu ngayuku paapaku puntura yulykarra nyinangi, palunyatjanunta tjukarurru nyinangi. Nyuntu Tapitaku tjukarurru palyara ngayunyaṉin Tapitaku katja ungu. Palunyatjanuṉa palumpa katja mayutju tiṉalpi nyinanyi. Ngayuluṉa yangupala ngurrpa nguwanpa mayutju tiṉalpiṉa tjanampa nyinanyi. Tjukarurru kanyilkitjaṉa tjananya puṯu kuliltjipingka nintilaṉi! Nyuntuluṉin nintintjatjanungka kutjuṉa tjananya nyuntupa walytja yaṉangu tjuṯa, tjukarurru kanyilku. Wiyangka, puṯuṉa tjananya tjukarurru kanyilpayingkamarra.” Alatji tjapintjala Katutjalu kulira Tjalamunaku yunyparringu. Alatji watjaṉu, “Yunyparringanyiṉanta nyuntu manikamu yulytja tiṉaku tjapintjawiyangka, rawa kana nyinakitjangku tjapintjawiyangka. Panyapaṉin tjapintjala ngayuluṉanta puntura nintilku, ninti tiṉalpi nyuntu nyinanytjaku. Aṉangu kutjupa tjuṯaya nintiwiya nguwanpa nyinarra waṉinyi. Alatjiṯarraṉanta ungku mani anta yulytja tiṉa. Mayutju tiṉalpi nyuntu nyinamalpa, mayutju kutjupa tjuṯangka munkarra. Nyuntutjun ngayuku wangkaku yunytju kutu nyinanytjala, ngayuluṉanta kana kutu kanyilku. Rawa nyuntu nyinarra ngula kutju iluku.” Katutjalu ilta panyapa watjaṉutjatjanungka yunyparringkula Tjarutjalumakutu ngaṉṯikutu anu. Ankula Katutjaku pukutju palula puḻi wirulypa kutjarra ngarrinyingka paluru ngarala waḻkuṉingi. Waḻkura tjawirrilyi pungkula Katutjaku tjunu. ");
INSERT INTO piu2006_vpl VALUES ("K13_16","012_3_16","1KI","3","16","28","Waaḻa kutjungka kungka kutjarra nyinangu. Ngurra palulakutu wati tjuṯaya ankula mani ungkula ngarrirra kuya palyalpayi kungka palunya kutjarrangka. Palunyatjanupula tjiṉṯu palunya kutjungka muṯi pakurringu. Palunyatjanupula tjiṉṯu palunya kutjungka iṯi, katja kutjarrapula utirringu, maama kutjarraku. Mungangka kungka kutjulu katja pulangkitingka karrpira ititjunkula paḻira iluntanu, kulintjawiyangku. Mungangka kanarrirra ilungutja nyakula mantjira katirra kungka kutjupangka ngarritjunu, kungka paluru anku kutu ngarriyananyingka. Ngarritjunkula pipirri kutjupa kana ngarringitja mantjira, maḻaku katirra piita walytjangka ngarritjunkula kanyira tjiṉṯurringu. Tjiṉṯurringutjangka kungka kutjupangku pipirri mirri nyakula puṯu kulira ulangi. Puṯu ngurrkantankula kuliṉu, “Wiya pipirri mirri ngaatja ngayuku katja, kungka palaku.” Ankula pipirri kutjupa nyakula kungka kutjupangka watjaṉu, “Mirri ngaatjanya nyuntupa katja, palatja ngayuku katja.” Katja kana kanyilkitjapula pikarringu. Pikarrirrapula katingu mayutju tiṉa Tjalamunalakutu. Tjalamunalu kuliṉingitjangka pipirri mulyaṯangku mantjiṉutjatjanu watjaṉu ara palunya. Palunyatjanu kungka paluru ngunytjilyinu, “Pipirri kana ngaatjanya ngayukutju, mulyaṯangkutjun mantjiṉu.” Kanya kungka kutjupangku watjaṉu, “Wiya, pipirri kana ngaatjanya ngayuku, nyuntupa ilungu.” Tjalamunala kurungka pipirritjirratjangku alatjingkupula ngaparrku watjara pungu. Palunyatjanu Tjalamunalu waarrkana wantirriyaṉu tjuuḻa waṯawara mantjira ngalya katinytjaku. Tjuuḻa waṯawara ngalya katirra ngarala kanyiṉingitjangka Tjalamunalu alatji watjaṉu, “Pipirri kana palunya nguruwanaṉa kuntara kilytjuntanku. Ngururrpa kilytjuntara kuntara yangkirrpa kutjupara yuwa!, kungka kutjupaku. Yangkirrpa kutjupa kungka kutjupaku yuwa!” Kuntara kilytjuntankukitjalu watjaṉutjangka kungka paluru katjatjirratjalu marrkuṉu, pipirriku maamalu, “Mayutju. Kuntara kilytjuntankunytjawiyalu kungka palakura yuwa!” Paluru kungka kutjupangku watjaṉu, “Ngayunya kutjuṉi kana yungkunytjawiya, kuntara kilytjuntankula ngaparrtji kutjarralinyatju yuwa!” Paluru Tjalamunalu watjaṉu, “Kuntara kilytjuntankunytjawiyangku, kungka palakura yuwa!, maama palumpa walytjaku.” Tjalamunaku waarrkana tjuṯangku wangka palunya kulira yunyparrirra yaṉangu tjuṯangka tjakultjurinangi. Aṉangu tjuṯaya kulira yunyparringu. Tjalamunanya alatji puḻkapungu, “Yilta mayutju tiṉalampa ninti tiṉa nyinanyi. Tjukarurrungku kulira ngurrkantankula maḻaku mantjira yungkupayi, yungu kungka maama walytjaku.” ");
INSERT INTO piu2006_vpl VALUES ("K14_20","012_4_20","1KI","4","20","34","(4:20-34; 10:1-13) Tjalamunaku waarrkana tjuṯalingku nyinangu. Waarrkana kutjupa tuwalpala tjananya Tjalamunalu mayutju tjuṯa nyinatjunu, ngurra kutjupa kutjupangkaya nyinanytjaku. Mayikamu kuka tjananya yaṉangu tjuṯangka mantjira katipayi, mayutju Tjalamunaku, ngurra Tjarutjalumalakutu. Tjalamunalu tjananya tjukarurru kanyiṉingitjangka, Yitjurilaku walytja ngaṉṯitja tjuṯa yunypa nyinarra waṉingi mayikukamu kukaku puṯu kulintjawiya. Tjalamunaku waarrkana mingaya nyinarra waṉingi. Kutjupa ngurrara tjuṯaṯarra tjanampa Tjalamunanya mayutju tiṉa nyinangi, karru Yupurititjalakutu maa nyinarra waṉinytja tjuṯaku, Pilitjiyanya ngurrara tjuṯakuṯarra, paṉa Yitjipilakutu maa nyinarra waṉinytja tjuṯakuṯarra. Tjuṯangkuya mayutju Tjalamunaku mani yulytjaṯarra ngurrtjara yungkula nyinapayi. Palunyatjanu Tjalamunanya manikamu yulytja tiṉatjarra nyinangi, mayikamu kuka tiṉatjarra. Ninti tiṉangku piipangka yara wakalpayi, tuḻku tjuṯa nintilkitjangku, warrantjakuya. Yukiri yuwankarraku Tjalamunanya nintilingku nyinapayi. Kuka paṉangka nyinanytja tjuṯaku, tjuḻpu tjuṯaku, kuka yuru ngurrara tjuṯaku, yuwankarraku Tjalamunanya ninti nyinapayi. Kutjupa kutjupa ngurrara tjuṯangku Tjalamunanya nintilingku nyinanytjala tjakulpa kulira ngalyankula yunypangku kulilpayi. Tjiipanya ngurrara tjuṯaku mayutju tiṉa kungka nyinapayi. Paluru tjakulpa kulira ngalyanu Tjarutjalumalakutu Tjalamunanya nyakula kulilkitja. Tjalamunangka ngarala wangka marrka puntu kulintjatjanungku tjapiṉu. Tjalamunalu wangka palunya tjuṯa kulira tjukarurrungku nintiṉingi. Kungka Tjiipanya ngurrarangku kulira yunyparringu. Waaḻa tiṉa Tjalamunaku ngurra ngarangu palumpa mani puntu ngarripayi. Puḻi kuulta tiṉa, puḻi tjiilpa tiṉa ngarripayi. Palumpa mayi tiṉa ngarringi, palumpa yulytja tiṉaṯarra. Yalatji kungka paluru nyakula yunyparringu Tjalamunala alatji watjaṉu, “Nyuntu ninti tiṉangku tjananya tjukarurru watjara kanyiṉi. Iltaya nyuntupa walytja tjuṯa nyuntupa waarrkana tjuṯaṯarra yunypaya palya nyinanyi. Ilta nyuntupa mayutju tiṉangku Katutjalunta yunypa nyinarra mayutju tiṉa nyinatjunu, Yitjurilaku walytja ngaṉṯitja tjuṯaku.” Kungka mayutju paluru Tjalamunanya inytjanungku yungu, puḻi kuulta, puḻi tiilyka tjuṯa, ngurutja tjuṯa. Tjalamunalu ngaparrtjilu yulytja tiṉara yungu, kungka paluru tjapiṉingitjangka. Kungka paluru, palumpa waarrkana tjuṯangkuṯarra yulytja tjuṯa kamula tjuṯangka yuṯitjunkula ngurra walytjakutu maḻaku katingu. ");
INSERT INTO piu2006_vpl VALUES ("K15_1","012_5_1","1KI","5","1","18","Tjalamunalu tjananya waarrkana maṉkurrpa iyaṉu tawunu Taayalakutu. Palunya ngurrara tjuṯaku mayutju yini Yaramanya nyinangi. Tjalamunalu tjananya iyaṉu mayutju palula yalatji tjakultjunkunytjaku, “Ngayuku paapa Tapitanya yunytjurringu mayutju Katutjaku tjaatji tiṉa palyalkitja. Yalatjikun ninti nyinanyi. Tapitalu tjananya tjilirratjarra tjuṯa tjuṯangara pikakutu katipayi. Rawangkuya pikangku pungkupayi, kutjupa tjuṯa. Kuwarriya ngurra kutjupa ngurrara tjuṯangkuya wiya pikangkulanyatjuya pungkukitja unytjurringanyi. Pikawiyalatju nyinanyi. Mayutju Katutjalu tjananya kuwarri pikawiyaku marrkuṉu. Palunyatjanuṉa unytjurringanyi Katutjaku tjaatji tiṉa palyalkitja. Nyuntupa waarrkana tjuṯa tjananya wantirriyala!, ngurra Lipananalakutu, watiya tiimpa luutuya atura ngalya katinytjaku, Tjarutjalumalakutu. Tjungungkuya ngayuku waarrkana tjuṯangku watiya tiimpa atura ngalya katimalpa. Nyuntupa waarrkana tjuṯa ngayuluṉa tjananya wayitjimaningka payimilalku. Watjalaṉi! Wayitjimani yaalytjirri ngayulu tjananya yungku?” Yaramalu yara palunya kulira yunyparringu. Palunyatjanu Tjalamunaku waarrkana tjuṯangku Yaramaku waarrkana tjuṯangkuṯarra tjananya watiya tiimpa atura luutu ngalya katipayi, Tjarutjalumakutu tjaatji palyalkitjangku. Tjalamunaku waarrkana kutjupa tjuṯangkuya puḻi walutjanu kilytjukatingutja ngalya katipayi, tjaatji tiṉa palyalkitjangku. ");
INSERT INTO piu2006_vpl VALUES ("K16_1","012_6_1","1KI","6","1","38","(6:1—7:51) Yitjurilaku walytja ngaṉṯitja tjuṯa paṉa Yitjipingka nyinanytjatjanu rawa nyinangi paṉa Kayinanangka, yiiya yantaṯa puupalakamu yiiya yiitiyipala. Palunyatjanu Tjalamunaku waarrkana tjuṯangkuya Katutjaku tjaatji tiṉa palyalkitjangku puḻi walu tjuṯa ngalya katirra ngarritjunkupayi. Kutjupa tjuṯangkuya puḻi panyapa tjuṯa mantjira rawangkuya tjaatji palyaṉingi, yiiya tjapanpalangka. Tjaatji tiṉa katuya palyaṉingi. Tjaatji palula yila wiyaya yilipitjarrangku watiya atulpayi. Palunya nguwanpa wiyaya yamatjarrangku puḻi atura wirulymankupayi, waṉma kutjuya atura wirulymara ngalya katipayi. Watiya tjuṯaṯarraya waṉma yilipitjarrangku atura ngalya katipayi tjaatji palyalkitjangku. Tjaatji waaḻangka ilaṯu ilaṯuya tjunkula wanaṉingi puḻi tjuṯa, kaḻparra tuuwa maṉkurrwana tjarrpanytjaku. Waaḻa tiṉa unnguwanaya ruuma kutjarra palyaṉu, Katutjaku ngurra ngaranytjaku, ruuma kutju palula Katutjaku pukutju puḻi wirulypa kutjarratjarra ngaranytjaku. Tjaatji tiṉa palunyangkaya unnguya kuulta pangki nguwanpaya palyara nganytjatjura wanaṉu. Yayina nguwanpa warungka tjunkula kaṉilpangka kapi kapirringutja piṯingka tjuṯangara tjutira yatjikingku palyaṉingi tayingka tiṉa, tjaatjingka yurilpangka kapitjarra ngaranytjaku. Palunyatjanuya tayingka wiima tjiilpangkaya palyaṉu, wakinangka ngarayinkupayi tiinpala. Kuka tjawirrilyi paltjintjakuya wakina ngaratjunkupayi, tjaatjingka ila yurilta. Yulytja kutjupa tjuṯaṯarraya yatjikingku palyara tjaatji tiṉangka ngaratjunu. ");
INSERT INTO piu2006_vpl VALUES ("K17_1","012_7_1","1KI","7","1","51","(6:1—7:51) Yitjurilaku walytja ngaṉṯitja tjuṯa paṉa Yitjipingka nyinanytjatjanu rawa nyinangi paṉa Kayinanangka, yiiya yantaṯa puupalakamu yiiya yiitiyipala. Palunyatjanu Tjalamunaku waarrkana tjuṯangkuya Katutjaku tjaatji tiṉa palyalkitjangku puḻi walu tjuṯa ngalya katirra ngarritjunkupayi. Kutjupa tjuṯangkuya puḻi panyapa tjuṯa mantjira rawangkuya tjaatji palyaṉingi, yiiya tjapanpalangka. Tjaatji tiṉa katuya palyaṉingi. Tjaatji palula yila wiyaya yilipitjarrangku watiya atulpayi. Palunya nguwanpa wiyaya yamatjarrangku puḻi atura wirulymankupayi, waṉma kutjuya atura wirulymara ngalya katipayi. Watiya tjuṯaṯarraya waṉma yilipitjarrangku atura ngalya katipayi tjaatji palyalkitjangku. Tjaatji waaḻangka ilaṯu ilaṯuya tjunkula wanaṉingi puḻi tjuṯa, kaḻparra tuuwa maṉkurrwana tjarrpanytjaku. Waaḻa tiṉa unnguwanaya ruuma kutjarra palyaṉu, Katutjaku ngurra ngaranytjaku, ruuma kutju palula Katutjaku pukutju puḻi wirulypa kutjarratjarra ngaranytjaku. Tjaatji tiṉa palunyangkaya unnguya kuulta pangki nguwanpaya palyara nganytjatjura wanaṉu. Yayina nguwanpa warungka tjunkula kaṉilpangka kapi kapirringutja piṯingka tjuṯangara tjutira yatjikingku palyaṉingi tayingka tiṉa, tjaatjingka yurilpangka kapitjarra ngaranytjaku. Palunyatjanuya tayingka wiima tjiilpangkaya palyaṉu, wakinangka ngarayinkupayi tiinpala. Kuka tjawirrilyi paltjintjakuya wakina ngaratjunkupayi, tjaatjingka ila yurilta. Yulytja kutjupa tjuṯaṯarraya yatjikingku palyara tjaatji tiṉangka ngaratjunu. ");
INSERT INTO piu2006_vpl VALUES ("K18_1","012_8_1","1KI","8","1","66","Yitjurilaku walytja ngaṉṯitja tjuṯaku mayutju tjuṯa tjananya Tjalamunalu yaḻṯingu tjaatji tiṉangka tjungurrinytjaku. Aḻṯingu tjananya ngalyankula tjungulu nyakula wanantjaku, Katutjaku pukutjuya tjaatji tiṉakutu maa katinyingka. Tuḻkuku mayutju tjuṯangkuya katirra katura tjarrpatjunkula tjunu. Tuulparrangka ngaṉṯiya Tjarutjalumangka yalatji tjungurringu. Tuḻkuku mayutju tjuṯangkuya alatji Katutjaku pukutju riilatjarrangku katirra, kaḻparra tjaatji tiṉangka tjunu, Katutjaku ngurrangka. Lipayiku walytja ngaṉṯitja tjuṯangku tjaatji tiṉa palula yulytja tjuṯa tjunkula wantingu. Alatjiya Katutjaku pukutjuṯarra katirra kaḻparra tjaatji tiṉangka tjunu, kutjupa tjuṯangkuya kuka tjawirrilyi tjuṯalingku pungkula kutjalpayi. Pukutju palunyaya tjunkula maḻaku ankula wirrkanutjangka Katutjakuṉu ngangkaḻi unngu ngarala yirrnyaṉingi, Katutjanya ngalyankula tjaatji yunngu nyinanyingka. Palunyatjanuya tuḻkuku mayutju tjuṯangku waarrka palyalkitja puṯu tjarrpangu, ngangkaḻingku anganingitjangka. Aṉangu tjuṯaya tjaatji tiṉangka kalkuṉi ngarala waṉinyingka, Tjalamunalu aṉangu tjuṯa tjananya tjakultjunu tjaatji puḻka palyantjaku Katutjalu Tapitanya watjaṉutjangka. Palunyatjanu tjanala Tjalamunalu watjaṉu, “Kuwarri nganaṉa yunyparringanyi, tjaatji ngaatja ngaranyingka.” Tjawirrilyi kutjalpayikutu yankula ngarala Tjalamunalu Katutjanya puḻkapungkula rawangku tjapiṉingi paluru tjanala nintira yaṉṯayaṉṯantjaku. Palunyatjanuya Tjalamunalungarri kuka tjawirrilyi tjuṯalingku ngalya katingu, waan yantaṯan puutiyi tuu tjawutjuna Katutjaku pungkula kutjantjaku, kutjalpayi palula. Palunyatjanuya Katutjaku tuḻku tjiṉṯu tjapanpalangara nyinarra warralpayi. Palunyatjanuya yunypalpiya yankula waṉingu ngurrakutu. ");
INSERT INTO piu2006_vpl VALUES ("K110_1","012_10_1","1KI","10","1","13","(4:20-34; 10:1-13) Tjalamunaku waarrkana tjuṯalingku nyinangu. Waarrkana kutjupa tuwalpala tjananya Tjalamunalu mayutju tjuṯa nyinatjunu, ngurra kutjupa kutjupangkaya nyinanytjaku. Mayikamu kuka tjananya yaṉangu tjuṯangka mantjira katipayi, mayutju Tjalamunaku, ngurra Tjarutjalumalakutu. Tjalamunalu tjananya tjukarurru kanyiṉingitjangka, Yitjurilaku walytja ngaṉṯitja tjuṯa yunypa nyinarra waṉingi mayikukamu kukaku puṯu kulintjawiya. Tjalamunaku waarrkana mingaya nyinarra waṉingi. Kutjupa ngurrara tjuṯaṯarra tjanampa Tjalamunanya mayutju tiṉa nyinangi, karru Yupurititjalakutu maa nyinarra waṉinytja tjuṯaku, Pilitjiyanya ngurrara tjuṯakuṯarra, paṉa Yitjipilakutu maa nyinarra waṉinytja tjuṯakuṯarra. Tjuṯangkuya mayutju Tjalamunaku mani yulytjaṯarra ngurrtjara yungkula nyinapayi. Palunyatjanu Tjalamunanya manikamu yulytja tiṉatjarra nyinangi, mayikamu kuka tiṉatjarra. Ninti tiṉangku piipangka yara wakalpayi, tuḻku tjuṯa nintilkitjangku, warrantjakuya. Yukiri yuwankarraku Tjalamunanya nintilingku nyinapayi. Kuka paṉangka nyinanytja tjuṯaku, tjuḻpu tjuṯaku, kuka yuru ngurrara tjuṯaku, yuwankarraku Tjalamunanya ninti nyinapayi. Kutjupa kutjupa ngurrara tjuṯangku Tjalamunanya nintilingku nyinanytjala tjakulpa kulira ngalyankula yunypangku kulilpayi. Tjiipanya ngurrara tjuṯaku mayutju tiṉa kungka nyinapayi. Paluru tjakulpa kulira ngalyanu Tjarutjalumalakutu Tjalamunanya nyakula kulilkitja. Tjalamunangka ngarala wangka marrka puntu kulintjatjanungku tjapiṉu. Tjalamunalu wangka palunya tjuṯa kulira tjukarurrungku nintiṉingi. Kungka Tjiipanya ngurrarangku kulira yunyparringu. Waaḻa tiṉa Tjalamunaku ngurra ngarangu palumpa mani puntu ngarripayi. Puḻi kuulta tiṉa, puḻi tjiilpa tiṉa ngarripayi. Palumpa mayi tiṉa ngarringi, palumpa yulytja tiṉaṯarra. Yalatji kungka paluru nyakula yunyparringu Tjalamunala alatji watjaṉu, “Nyuntu ninti tiṉangku tjananya tjukarurru watjara kanyiṉi. Iltaya nyuntupa walytja tjuṯa nyuntupa waarrkana tjuṯaṯarra yunypaya palya nyinanyi. Ilta nyuntupa mayutju tiṉangku Katutjalunta yunypa nyinarra mayutju tiṉa nyinatjunu, Yitjurilaku walytja ngaṉṯitja tjuṯaku.” Kungka mayutju paluru Tjalamunanya inytjanungku yungu, puḻi kuulta, puḻi tiilyka tjuṯa, ngurutja tjuṯa. Tjalamunalu ngaparrtjilu yulytja tiṉara yungu, kungka paluru tjapiṉingitjangka. Kungka paluru, palumpa waarrkana tjuṯangkuṯarra yulytja tjuṯa kamula tjuṯangka yuṯitjunkula ngurra walytjakutu maḻaku katingu. ");
INSERT INTO piu2006_vpl VALUES ("K111_1","012_11_1","1KI","11","1","43","(1-13,29,30,31,32,33,41,42,43) Tjalamunanya miiṯa tjuṯaku yunytjurringkupayi. Kungka kutjupa kutjupa ngurrara tjuṯa tjananya yaḻṯirra kanyiṉingi. Kungka yalatji ngurrara tjuṯa tjananya yaḻṯirra kanyiṉingi, Yitjipinya ngurrara tjuṯa, Yitatunya ngurrara tjuṯa, Muwapanya ngurrara tjuṯa, Yamananya ngurrara tjuṯa, Yiitumanya ngurrara tjuṯa, Tjayitananya ngurrara tjuṯa. Kungka yalatji ngurrara tjuṯalingku waan tjawutjuna Tjalamunalu yaḻṯirra kanyiṉingi, Katutjaku wangka wantirra. Katutjalu yurrunpa watjaṉu Yitjurilaku walytja kutju aḻṯirra kanyintjaku, kungka kutjupa kutjupa ngurrara wiya. Palumpa wangka kulintjawiyangku Tjalamunalu paluru tjananya ngurra kutjupa kutjupa ngurrara yaḻṯirra kanyiṉingi. Kungka tjuṯangkuya Tjalamunanya tjingapungkupayi Katutjanya nguwanpa kutjupa tjuṯa puḻkapungkunytjaku. Palunyatjanu Tjalamunalulpi tjananya Katutjanya nguwanpa kutjupa tjuṯalpi puḻkapungkula nyinangi. Yalatji tjuṯa puḻkapungkuyananyingka Katutjalu kutjarrangara Tjalamunanya puṯu marrkuṉu. Palunyatjanu Katutjalu Tjalamunanya alatjingku watjaṉu, “Nyuntu tjananya kutu wiyawanangku puḻkapungkuyananyingka nyuntupa waarrkanalpiṉa mayutju tiṉa nyinatjunku, nyuntupa katja wiya. Nyuntupa waarrkanalpi tjanampa Yitjurilaku walytja ngaṉṯitja tjuṯaku mayutju tiṉa nyinaku, nyuntu wiyarringanyingka.” Tjalamunaku waarrkana yini Tjiripumanya waarrka parrpaṯu parrpaṯu palyalpayi nyinangi. Palunyangka Tjalamunalu kulira Tjiripumanya mayutju tjanampa nyinatjunu waarrkana kutjupa tjuṯaku. Tjiripumanya Tjarutjalumalanguru yiwarrawana yananyingka, Katutjaku wangka watjalpayi Yayatjanya tjungurringu. Tjungurrirra Yayatjalu kuuta waṯawara walytja yirriwiltjiṉu palunyatjanu paluru wintarrpungkula kilytjunpa tuwalpala palyaṉu. Tuwalpala palunya marangku kanyira watjaṉu, Tjiripumalu kilytjunpa tiinpala mantjira kanyintjaku. Tjiripumalakutu alatji Katutjaku wangka tjakultjunu, “Tjalamunaluṉi Katutjanya wantingutjangka palumpa katja wiya Yitjurilaku walytja ngaṉṯitja tjuṯaku mayutju tiṉa nyinaku, maṉkurr maṉkurrpaku mayutju nyinaku. Nyuntulpi mayutju tiṉa tjanampa Yitjurilaku walytja ngaṉṯitja tjuṯaku nyinaku, walytjararranpa tiinpalaku. Ngayuluṉanta nyinatjunku, nyuntu mayutju tiṉa tjanampa nyinanytjaku.” Palunyatjanu Tjalamunanya nyinarra wiyarringu mayutju tiṉa tjanampa rawa nyinarra, yiiya puutiyipala. Palumpa katja Riyapumanya mayutju tiṉalpi nyinangu Yitjurilaku walytja ngaṉṯitja tjuṯaku, maṉkurr maṉkurrpaku. ");
INSERT INTO piu2006_vpl VALUES ("K112_1","012_12_1","1KI","12","1","20","Tjalamunanya wiyarringutjangka tjakulpa kulira Tjiripumanya paṉa Yitjipingka nyinarra maḻaku yanu. Tjiripumanya aḻṯirra Yitjurilaku walytja ngaṉṯitja tjuṯa, yalinytjarra ngurrara tjuṯa ngurra Tjikimangka tjungurringuya, Tjalamunaku katja Riyapumaku mirrpaṉarrirra. Palunyatjanuya Riyapumanya yalatji watjaṉu, “Nyuntupa paapa Tjalamunanyalampatju mayutju ngurrkunytju nyinangi, punturalanyatju tjingapungkupayi waarrkarrinytjaku. Puṯulatju nyinarra kulilpayi waarrka tiṉangka. Wiyalatju yunytjurringanyi palunya nguwanpa waarrkarrinytjaku. Tjapiṉilatjunta nyuntu tjukarurrulanyatju kanyintjaku waarrka wiima nguwanpa yungkunytjaku.” Tapitaku ngalungku tjuṯangkuya, tjiḻpi tjuṯangku Riyapumanya tjingapungu, “Palyantaya panyapa tjapiṉu, kuyarrinytjawiyangku tjananya mayutjungku kanyinma!” Ka Riyapumaku maḻpa tjuṯangkuya yangupala tjuṯangku alatji tjingapungu, “Wiya. Nyuntu tjanampa mayutju mulyarranytju tjananya kanyintjaku, punturaya waarrkarrinytjaku.” Palunyangka tjananya Riyapumalu aṉangu tjuṯa tjingapungu puntura waarrkarrinytjaku. Palunyatjanuraya Riyapumaku ngurrkurrirra yalatjiyanku wangkangi, “Riyapumanya wiya mayutjulampa nyinaku. Wantirralaka yalinytjarra yarra!, paluru mayutju kuya, waarrka tiṉa yungkupayi. Wiyalanya tjukarurrungku kanyiṉi.” Alatjiya Yitjurilaku walytja ngaṉṯitja tjuṯangku yalinytjarra ngurrara tjuṯangku mayutju Riyapumanya panypurangkula wantikatingu. Palunyatjanu tjanampa Tjuutaku ngaṉṯitja tjuṯaku kutju yulparirra ngurrara tjuṯaku Riyapumanya mayutju tiṉa nyinangi, ngurra Tjarutjalumala. Yalatjiya Yitjurilaku walytja ngaṉṯitja tjuṯa, yalinytjarra ngurrara tjuṯa tjanampa yulparirra ngurrara tjuṯaku kuyarrirra nyinangi. Riyapumanya wantirraya mayutju tiṉa kutjupa Tjiripumanyalpi nyinatjunu. ");
INSERT INTO piu2006_vpl VALUES ("K112_25","012_12_25","1KI","12","25","33","(12:25-33; 13:33,34) Tjiripumanya, palumpa waarrkana tjuṯaṯarraya tawunu Tjikimangka nyinangi. Palunyatjanuya tawunu Pinulangka ankula nyinangi. Nyinarra Tjiripumalu kuliṉu, “Ngayuku waarrkana tjuṯaya mayutju Katutjanya tjawirrilyi yungkukitja, wiya Tjarutjalumalakutu ankunytjaku. Tjinguruya Katutjanya waḻkulkitja tjaatji tiṉakutu ankula mayutju Riyapumaku ngulytjurriku, ngulytjurrirraṉiya ngalya yankula mirri pungkutjipingka. Yalatjingkamarra Katutjanya nguwanpa ngaangkalpi kutjarraṉa palyara ngaratjunku, ngurra Tjarutjalumalakutu tjaatji tiṉakutu yaṉangu tjuṯa ankupayingkamarra.” Panyapa kulira Tjiripumalu puluka wiima kutjarra nguwanpa palyara ngaratjunu. Kutjupa, ngurra Pitjilta ngaratjunu, kutjupa ngurra Taanangka katirra ngaratjunu. Yaṉangu tjuṯa tjananya Tjiripumalu alatji tjingapungu, “Rawala Tjarutjalumalakutu ankula puḻkapungkupayi. Alatjingkamarra ngaangkalpila puluka wiima kutjarra puḻkapungkunytjaku. Puluka paluru tjananya yirriṯi nyinapayi tjuṯa Yitjipingka pakaltjingara ngalya katingu, mayutju tiṉangku.” Palunyatjanuya Yitjurilaku walytja ngaṉṯitja tjuṯangku alinytjarra ngurrara tjuṯangku Katutjanya nguwanpa puluka wiima kutjarra puḻkapungkula nyinangi. Yiwarra kutjupawanangku tjananya paluru tjingapungkula kuyaṉu. Puluka palula kutjarrawana waarrkarrinytjaku tjananya ngaratjunu tuḻkuku mayutju kutjupa tjuṯa, Tjiripumalu. Paluru tjanaya kuka tjawirrilyi pungkula kutjara puluka puḻkapungkupayi. Tjiripumaluṯarra tuḻkuku mayutju nguwanpangku tjawirrilyi pungkula kutjalpayi, puluka puḻkapungkukitjangku. Lipayiku walytja ngaṉṯitja kulintjawiyangku Tjiripumalu kutjupa tjuṯa tuḻkuku mayutju tjuṯa nyinatjunu. Yaṉangu Lipayiku walytjawiyangku tuḻkuku mayutju nyinakitja yunytjurrirra tjapiṉingka, Tjiripumalu nyinatjunkupayi. Lipayiku walytja ngaṉṯitja tjuṯa wati tjuṯa kutju tjananya tuḻkuku mayutju paluru nyinatjunamara, Muutjalu irriṯi watjaṉutjangka. ");
INSERT INTO piu2006_vpl VALUES ("K113_33","012_13_33","1KI","13","33","34","(12:25-33; 13:33,34) Tjiripumanya, palumpa waarrkana tjuṯaṯarraya tawunu Tjikimangka nyinangi. Palunyatjanuya tawunu Pinulangka ankula nyinangi. Nyinarra Tjiripumalu kuliṉu, “Ngayuku waarrkana tjuṯaya mayutju Katutjanya tjawirrilyi yungkukitja, wiya Tjarutjalumalakutu ankunytjaku. Tjinguruya Katutjanya waḻkulkitja tjaatji tiṉakutu ankula mayutju Riyapumaku ngulytjurriku, ngulytjurrirraṉiya ngalya yankula mirri pungkutjipingka. Yalatjingkamarra Katutjanya nguwanpa ngaangkalpi kutjarraṉa palyara ngaratjunku, ngurra Tjarutjalumalakutu tjaatji tiṉakutu yaṉangu tjuṯa ankupayingkamarra.” Panyapa kulira Tjiripumalu puluka wiima kutjarra nguwanpa palyara ngaratjunu. Kutjupa, ngurra Pitjilta ngaratjunu, kutjupa ngurra Taanangka katirra ngaratjunu. Yaṉangu tjuṯa tjananya Tjiripumalu alatji tjingapungu, “Rawala Tjarutjalumalakutu ankula puḻkapungkupayi. Alatjingkamarra ngaangkalpila puluka wiima kutjarra puḻkapungkunytjaku. Puluka paluru tjananya yirriṯi nyinapayi tjuṯa Yitjipingka pakaltjingara ngalya katingu, mayutju tiṉangku.” Palunyatjanuya Yitjurilaku walytja ngaṉṯitja tjuṯangku alinytjarra ngurrara tjuṯangku Katutjanya nguwanpa puluka wiima kutjarra puḻkapungkula nyinangi. Yiwarra kutjupawanangku tjananya paluru tjingapungkula kuyaṉu. Puluka palula kutjarrawana waarrkarrinytjaku tjananya ngaratjunu tuḻkuku mayutju kutjupa tjuṯa, Tjiripumalu. Paluru tjanaya kuka tjawirrilyi pungkula kutjara puluka puḻkapungkupayi. Tjiripumaluṯarra tuḻkuku mayutju nguwanpangku tjawirrilyi pungkula kutjalpayi, puluka puḻkapungkukitjangku. Lipayiku walytja ngaṉṯitja kulintjawiyangku Tjiripumalu kutjupa tjuṯa tuḻkuku mayutju tjuṯa nyinatjunu. Yaṉangu Lipayiku walytjawiyangku tuḻkuku mayutju nyinakitja yunytjurrirra tjapiṉingka, Tjiripumalu nyinatjunkupayi. Lipayiku walytja ngaṉṯitja tjuṯa wati tjuṯa kutju tjananya tuḻkuku mayutju paluru nyinatjunamara, Muutjalu irriṯi watjaṉutjangka. ");
INSERT INTO piu2006_vpl VALUES ("K114_1","012_14_1","1KI","14","1","20","Palunyangka Tjiripumaku katja wiima pika tiṉatjarra ngarringi. Tjiripumalu palumpa miiṯangka watjaṉu, katja palunya Yayatjalakutu katinytjaku, Katutjaku wangka watjalpayilakutu. Tjiripumaku miiṯangku katja katingu yulparirra, tawunu Tjaluwakutu. Tawunu palula Yayatjanya tjiḻpirrirra kuru pampa nyinangi. Palumpa waaḻangka tjarrpakitja Tjiripumaku miiṯa yini watjantjawiya wangkarra tjarrpangu. Katutjalu Yayatjala yurrun yurrunpa tjakultjunu kungka paluru ngalya yananyingka. Yayatjalu alatji watjaṉu, “Ngalya tjarrpa, Tjiripumakun miiṯa! Nyaakun yiningkun tjukarurrungku watjantjawiya tjarrpangu? Kutjupa nguwanpan wangkarra tjarrpangu. Yara kuyaṉanta watjalku Tjiripumanya ankula alatji tjakultjunkunytjaku, Katutjakuṉu wangka, ‘Mulyarrarringuṉanta nyuntupa, nyuntuṉin ngayunya Katutjanya wantirra ngayunya nguwanpa kutjarra kutjupa ngaratjunutjangka. Nyuntuṯarra tjananya tjingapungu palunya kutjarra puḻkapungkunytjaku. Yalatji nyuntun palyara ngaratjunkula kuya puntu palyaṉu, yaṉangu mirrinytjanirri tjuṯangkuya kuya palyantja nguwanpangka wirriḻi. Palunyangka ngayulu tjananya nyuntupa katjapiṯi tjamupiṯi mirrintara wiyalku. Nyuntupa walytja tjuṯa mirrirrirra wiyarriku.’” Tjiḻpi Yayatjalu Tjiripumaku miiṯalakutu alatji piyuku watjaṉu, “Waṯalpi, ngurrakutu maḻaku arra! Yankulan tawunu walytjangka maa tjarrpanyingka, nyuntupa katja pipirri ngaatjanya wiyarrikuku. Yilta katja ngaatjanya wiyarriku, yulakulpiranyurra.” Tjiḻpi Yayatjalu Tjiripumaku miiṯalakutu alatji piyuku watjaṉu, “Tjiripumanya ankula tjakultjunkunytjaku. Yitjurilaku walytja ngaṉṯitja tjuṯangkuya Katutjanya nguwanpa yini Yatjaranya puḻkapungkupayi. Palunyatjanu yitjipungkukitjangku ngayulu Katutjalu tjananya paṉa kutjupakutu wantirriyalku, karru Yupurititjala munkarra, wiyaya ngaangka ngurra walytjangka kutu nyinanytjaku, wiya. Tjiripumaku wangkaya kulira ngayunya wantirra kuya palyaraya nyinanyi.” Tjiripumaku miiṯangku wangka palunya kulira maḻaku katirra tawunungka tjarrpanyingka katja iṯi palunya wiyarringu, Yayatjalu watjaṉutjangka. Tjiripumalu tjananya Yitjurilaku walytja ngaṉṯitja tjuṯa kanyiṉingi tuuntiyi tuu yiiya. Yalatji tjananya kanyira wiyarringu. Palumpa katjalpi tjanampa mayutju nyinangi, yini Nitapanya. ");
INSERT INTO piu2006_vpl VALUES ("K115_1","012_15_1","1KI","15","1","34","(15:1-8,25-34; 16:6-28) Riyapumanya Tjuutaku walytja ngaṉṯitja tjuṯaku mayutju tiṉa nyinarra wiyarringu. Palunyatjanu palumpa katja Yapayitjanya mayutju tiṉa tjanampa nyinangi. Katutjaku tjukarurruwiya nyinarra wiyarringu. Palumpa katjalpi Yiitjanya tjanampa mayutju tiṉa nyinangi, Tjuutaku walytja ngaṉṯitja tjuṯaku. Tjiripumanya nyinarra wiyarringutjangka, Nitapanya mayutju tiṉa tjanampa nyinangi, Yitjurilaku walytja ngaṉṯitja tjuṯaku. Katutjaku tjukarurruwiya nyinangi. Palunyatjanu wati Paatjalu mirri pungkula mayutju tiṉalpi tjanampa nyinangi. Paatjalu mayutju tiṉarrirra Tjiripumaku walytja tjuṯaku ngurrira mirri pungkuyinangi. Palunyatjanuya yuwankarra Tjiripumaku walytja tjuṯa wiyarringu. Paatjanya Katutjaku tjukarurruwiya nyinarra wiyarringu. Palumpa katja Yilayanya mayutju tiṉalpi nyinangi, Yitjurilaku walytja ngaṉṯitja tjuṯaku. Wati Tjimirilu Yilayanya mirri pungkula mayutju tiṉalpi tjanampa nyinangi. Mayutju tiṉarrirra Tjimirilu tjananya Paatjaku walytja tjuṯa pungkuyinangi, yalatjiya uwankarra wiyarringu. Tjimirinya mayutju tiṉa nyinanyingka wati Wumirinyangarri tjilirratjarra tjuṯa ngalya yanu Tjimirinya mirri pungkukitja. Palunyatjanu Tjimirilu waaḻangka tjarrparra walytjalunku tilira wiyarringu, kutjupa tjuṯangku mirrintankupayingka. Wumurinya tjanampa mayutju tiṉalpi nyinangi Yitjurilaku walytja ngaṉṯitja tjuṯaku. Wumurilu tawunu Tjamiriyanya palyara palula nyinangi. Katutjaku tjukarurruwiya nyinarra Wumurinya wiyarringu. Palumpa katja Yiyapanya mayutju tiṉa tjanampa nyinangi Yitjurilaku walytja ngaṉṯitja tjuṯaku. ");
INSERT INTO piu2006_vpl VALUES ("K116_6","012_16_6","1KI","16","6","28","(15:1-8,25-34; 16:6-28) Riyapumanya Tjuutaku walytja ngaṉṯitja tjuṯaku mayutju tiṉa nyinarra wiyarringu. Palunyatjanu palumpa katja Yapayitjanya mayutju tiṉa tjanampa nyinangi. Katutjaku tjukarurruwiya nyinarra wiyarringu. Palumpa katjalpi Yiitjanya tjanampa mayutju tiṉa nyinangi, Tjuutaku walytja ngaṉṯitja tjuṯaku. Tjiripumanya nyinarra wiyarringutjangka, Nitapanya mayutju tiṉa tjanampa nyinangi, Yitjurilaku walytja ngaṉṯitja tjuṯaku. Katutjaku tjukarurruwiya nyinangi. Palunyatjanu wati Paatjalu mirri pungkula mayutju tiṉalpi tjanampa nyinangi. Paatjalu mayutju tiṉarrirra Tjiripumaku walytja tjuṯaku ngurrira mirri pungkuyinangi. Palunyatjanuya yuwankarra Tjiripumaku walytja tjuṯa wiyarringu. Paatjanya Katutjaku tjukarurruwiya nyinarra wiyarringu. Palumpa katja Yilayanya mayutju tiṉalpi nyinangi, Yitjurilaku walytja ngaṉṯitja tjuṯaku. Wati Tjimirilu Yilayanya mirri pungkula mayutju tiṉalpi tjanampa nyinangi. Mayutju tiṉarrirra Tjimirilu tjananya Paatjaku walytja tjuṯa pungkuyinangi, yalatjiya uwankarra wiyarringu. Tjimirinya mayutju tiṉa nyinanyingka wati Wumirinyangarri tjilirratjarra tjuṯa ngalya yanu Tjimirinya mirri pungkukitja. Palunyatjanu Tjimirilu waaḻangka tjarrparra walytjalunku tilira wiyarringu, kutjupa tjuṯangku mirrintankupayingka. Wumurinya tjanampa mayutju tiṉalpi nyinangi Yitjurilaku walytja ngaṉṯitja tjuṯaku. Wumurilu tawunu Tjamiriyanya palyara palula nyinangi. Katutjaku tjukarurruwiya nyinarra Wumurinya wiyarringu. Palumpa katja Yiyapanya mayutju tiṉa tjanampa nyinangi Yitjurilaku walytja ngaṉṯitja tjuṯaku. ");
INSERT INTO piu2006_vpl VALUES ("K117_1","012_17_1","1KI","17","1","1","Katutjaku wangka watjalpayi yini Yilaatjanya nyinangi. Yitjurilaku walytja ngaṉṯitja tjuṯaku Yiyapanya mayutju tiṉa nyinanyingka, Yilaatjalu Yiyapanya watjaṉu, “Mayutju Katutjangka mirangka tjukarurruṉanta watjaṉi. Kuwarri kapilampa wiya punkalku rawalingku. Kulyarrpalampa wiya ngarriku rawalingku, yiiya maṉkurrpala. Katutjalu panyapa watjaṉu.” ");
INSERT INTO piu2006_vpl VALUES ("K117_2","012_17_2","1KI","17","2","16","Palunyatjanu mayutju Katutjalu Yilaatjanya yalatji watjaṉu, “Ngurra ngaatjanya wantirra kakarrara yarra! Yankula karru yini Tjiritjala kumpira nyinama!, karru Tjuutanangka kakarrara. Karru Tjiritjanya palyan tjikinmalpa ngurra nyarra palula. Tjuḻpu tjuṯangkuntaya miyi katirra yungamalpa, ngayulu tjananya iyaṉingka.” Palunyatjanu Yilaatjanya ankula karru Tjiritjangka palya nyinangi. Mungawinkikarrangu mungawinkingka tjuḻpu tjuṯangku miyi an kuka ngalya katirra ungkupayi, mungarrtjikarrangu mungarrtjiṯarra. Rawa nyinarra kapi wiyarringu. Palunyatjanu Katutjalu Yilaatjala alatji watjaṉu, “Tawunu Tjiyapatjakutu maa yarra!, tawunu Tjayitanangka yila ngaranyi. Palunya ngurrarangkunta paḻtjanmalpa, minyma waḻukutangku, ngayuluṉa minyma panyapa nintiṉingka.” Palunyatjanu Yilaatjanya pakara yanu ngurra Tjirapatjalakutu. Yankula tawunu palula yila nguwanpa nyinangi. Paluru nyangu minyma waḻukuta, waru kutjalkitjangku kurrkalpa mantjiyinanyingka. Nyakula watjaṉu, “Kapitjirratjaṉa ngalya yanutjangka, ankula mantjira ngalya kati!” Maa yananyingka, kutu watjaṉu, “Mangarriṯarratju ngalya kati!” Minyma paluru watjaṉu, “Mayutju Katutjangka mirangka tjukarurrungkuṉanta watjaṉi puriitiwiyaṉa nyinanyi. Pulawu yuḻpu kutju wiima ngarrinyi, tjira wiimapaṯuṯarra. Pulawu palunya kutjalkitjangku waru ngayulu mantjiṉi. Mayi palunya kutjulitju rungkara ngalkula paḻtjarringkula wiyarriku, katjararralitju.” Yilaatjalu watjaṉu, “Mangarriwiyangka wiyarrikitjangku puṯu kulintjawiya, ngayuku kutju mangarri wiima rungkara kutjara ngalya kati! Palunyatjanu ngaṉṯingku rungkara kutjala!, nyupali ngalkukitjangku. Mayutju Katutjaku wangkaṉanta yalatji tjakultjunanyi. Turaama palula pulawu palunya kutu ngarrimalpa, wiyarrinytjawiya. Paatula palula tjira kutu ngarrimalpa, wiyarrinytjawiya. Ngula kutju pulawu an tjira wiyarriku. Ngayulu Katutjanya kapiku tjapintjala ngaṉṯi, palunyatjanu pulawu an tjira wiyarriku.” Waḻukuta paluru parrpaṯu yankula kutjara mantjira ngalya katingu, Yilaatjalu watjaṉutjangka. Wangka palunya Yilaatjalu watjaṉutja iltarringu. Pulawu yuḻpu an tjira palunya kutu ngarringi, wiyarrikunytjawiya. Katutjalura rawangku pulawu an tjiratjarrangku yaṉṯayaṉṯaṉingi waḻukuta palunya. ");
INSERT INTO piu2006_vpl VALUES ("K117_17","012_17_17","1KI","17","17","24","Ngula, minyma waḻukuta palumpa katja pika puntutjarra ngarrirra wiyarringu. Minyma paluru yularra Yilaatjalakutu yankula watjaṉu, “Nyaakun ngaangka ngalya yankula nyinanyi? Nyuntu nyinanyingka Katutjaluṉi tjinguru kuliṉi kuyaṉa palyaṉutjangka. Palunyatjanu ngayunyaṉi yitjipungamara palunyatjanu katjalpitju wiyaṉu.” Yilaatjalu watjaṉu, “Nyuntupa katja palatjaṉi yuwa!, yampura kanyintjanya.” Yilaatjalu mantjira katirra waaḻangka katu katurrirra palumpa ngurra yinytjamingka ngarritjunu. Ngarritjunkula Katutjanya yalatji tjapiṉu, “Mayutju Katutja, nyaakun pipirri ngaatjanya yiluntanu? Waḻukutaku katja kutjupilkura nyinanyi ngaatjanya. Paluruṉi kutu yaṉṯayaṉṯalpayi, kanaranu kanyinmara.” Uḻa palula Yilaatjanya waṯungarakatirra Katutjanya yalatjingku tjapiṉu, “Mayutju Katutja, uḻa ngaatjanyara kanala!” Yalatji tjirripalangara waṯungarakatirra Katutjanya tjapiṉingka, Katutjalu Yilaatjaku wangka kulira uḻa palunya kanaṉu. Kanarringanyingka yampura tjarukatirra yungu palumpa maama. Waḻukuta palunya watjaṉu, “Nyawa!, kanalpinku katja nyinanyi.” Minyma paluru pukuḻarrirra Yilaatjalakutu watjaṉu, “Yilta nyuntu Katutjakuṉu, palumpa wangka yilta nyuntu watjalpayi.” ");
INSERT INTO piu2006_vpl VALUES ("K118_1","012_18_1","1KI","18","1","35","Ngurra tjuṯawana kapiwiya ngarangi yiiya tjirripala. Palunyangka mayutju Katutjalu Yilaatjala yalatji watjaṉu, “Yankula mayutju tiṉa Yiyapala ngarala wangka!, ngayulu kapi nyurrampa kuwarri wantirriyaṉingka.” Palunyangka Yilaatjanya yulparirrawana yanu. Yankula ngururrpa mayutju Yiyapaku waarrkana Wupatayanya tjungurringu. Wangkarrapula Wupatayalu yankula mayutju Yiyapanya aḻṯingu, Yilaatjanya ngalyankula wangkanytjaku. Mayutju Yiyapalu ngalya yankula Yilaatjanya alatji watjaṉu, “Nyuntulanyatjun yurrnyuṉu, kapiwiya nyinanytjaku.” Yilaatjalu watjaṉu, “Wiya, mungutjaṉa. Nyupalipulan paapararrangku kuya palyaṉingitjangka. Katutjaku wangkapulan wantirra Katutjanya nguwanpa, Paalanyalpipulan puḻkapungangitjangka. Palunyatjanu nyurranya Katutjalu kapi wiya yunganyi, tjukarurrunyurra nyinanytjawiyangka.” Yilaatjalu Yiyapala alatji kutu watjaṉingi, “Yaṉangu tjuṯa tjananya Yitjurilaku walytja ngaṉṯitja tjuṯa watjala!, yankula tjungurrinytjaku puḻi yini Kamilangka. Paalaku tuḻku kanyilpayi tjuṯaṯarra tjananya aḻṯirra kati!, yankulaya palula tjungurrinytjaku. Tjanaya tjuṯa nyinanyi, puu yantaṯan pipitiyipala. Yaḻṯirra tjananya kati puḻi palulakutu! Nyuntupa miiṯa Tjiitjapilanya tjanampa yunyparringanyi palumpa walytja tjuṯaku. Paluru tjananya yaṉṯayaṉṯalpayi.” Mayutju Yiyapalu tjananya aḻṯinyingka ankulaya puḻi Kamilala tjungurringu, Yitjurilaku walytja ngaṉṯitja tjuṯa, Paalaku waarrkana tjuṯaṯarra. Palunyatjanu tjananya ankula Yilaatjalu alatji tjapiṉu, “Ngananyanyurra mayutju tiṉa puḻkapungkukitjangku puṯu kuliṉi? Ngananyalampa mayutju tiṉa nyinanyi?, tjinguru Paalanya?, tjinguru Katutjanya? Katutjanya mayutju tiṉalampa nyinanyingka, Katutjanyalpinyurra puḻkapungkunytjaku. Tjinguru Paalanya mayutju tiṉalampa nyinanyingka, Paalanyanyurra puḻkapungkunytjaku. Ngananyalampa mayutju tiṉa nyinanyi?, Paalanya tjinguru Katutjanya.” Yalatji tjananya tjapiṉingitjangka wangkanytjawiyaya ngarala waṉingi. Yilaatjalu tjananya kutu watjaṉu, “Katutjaku wangka watjalpayi ngayulu kutju ngaranyi, kanya Paalaku wangka watjalpayi tjuṯalingkunyurra ngarala waṉinyi. Palunyangka Paalaku waarrkana tjuṯangkunyurra puluka tjawirrilyi kutju mirri pungkula yitjiḻinkula waru kurrkalpangka tjunkunytjaku, tilintjawiyangku. Palunya nguwanpa ngayulu puluka kutju mirri pungkula yitjiḻinkula waru kurrkalpangka tjunku. Yalatjiya Paalaku waarrkana tjuṯangku tjunkula tjapila, waru tilintjaku! Ngayuluṯarraṉa tjawirrilyi tjunkula mayutju Katutjanya tjapilku, waru tilintjaku. Tjinguru Paalalu nyurrampa waru tililku, nganaṉa kulilku paluru yilta mayutju tiṉa nyinanyi. Tjinguru Katutjalu waru ngayuku tililku, nganaṉa kulilku paluru yilta mayutju tiṉalampa nyinanyi.” Yaṉangu tjuṯangkuya Yilaatjaku wangka kulira yunyparringu. Palunyatjanu tjananya Yilaatjalu watjaṉu, “Paalaku waarrkana tjuṯangkunyurra tjawirrilyi tjunkula yurrunpangku tjapintjaku Paalalu waru tilintjaku.” Tjawirrilyi pungkulaya yitjiḻinkula waru kurrkalpangka tjunkula puṯuya tjuṯangara tjapiṉu tilintjaku. Kaḻaḻa tjanampa tilirrinytjawiyangka Yilaatjalu tjananya ngunytji alatji watjaṉu, “Kutuya tjapila! Tjinguru Paalanya tii puḻkara tjikintjatjanu yanu. Tjinguru kunpu ngarrinyi kulintjawiya. Mirrarraya kanala! Tjinguru yanku ngarrinyi, kulintjawiya.” Puṯuya tjapira tjuuḻangkalpiyanku kuntaṉu walytjangku yaḻipiri tjuntaṯarra. Yalatjiya ngurrka yintirra tjuṯangara tjapira mungarrtjirringu. Palunyatjanu tjananya Yilaatjalu watjaṉu, yaṉangu tjuṯa yilarrirra nyakunytjaku. Katutjaku uulta nguwanpaya yaṉangu tjuṯangku yirriṯi palyara wantingu. Palulanguru uulta palunya ngarala kuyakuyarringu. Tjanaya nyanganyingka Yilaatjalu puḻi tjuṯa mantjira tjunangi. Uulta palyalpi ngarangi. Yalatji palyara wiyara tjawara wanaṉingilpi kapi ngaṯiwana ngarrinytjaku. Waru palunya kurrkalpa mantjira uultangka katuwana tjunkula wanaṉu. Kuka tjawirrilyi yitjiḻinkula kurrkalpangka tjunu. Watjaṉu tjananya turaama tjuṯangka tjutira ngalya katinytjaku, ngalya katirraya tjutintjaku kurrkalpangka kukangka. Yalatjiya turaama tjuṯangka tjirripalangara kaṯira kapi tiṉa ngalya katirra yintiṉingi. Kuka an kurrkalpa wiita ngarangi. Ngaṉṯi palunya yurrunpaya tjawara wantingutjangka, kapi palunya yintirra katurringu. ");
INSERT INTO piu2006_vpl VALUES ("K118_36","012_18_36","1KI","18","36","39","Palunyangka uulta palula ila ngarala Yilaatjalu Katutjanya alatji tjapiṉu, “Mayutju Katutja. Nyuntu tjanampa mayutju tiṉa nyinangi Yipuramakungarriku tjanampa, Yatjikaku walytja tjuṯaku, Tjikupaku walytja tjuṯakuṯarra. Tjanampaṉu walytja ngaṉṯitja tjuṯala kuwarri nyinanyi. Kutjupa tjuṯaya ngaangka nyinanyi nyuntupa wiya tjukarurru nyinanyi, kanya ngayulu nyuntunya kuliṉi. Yipuramaku ngaṉṯitja tjuṯa tjananya kuwarri nintila! Waru ngaatja tilila!, tjanaya tjukarurrungku nyakula kulintjaku, nyuntu yilta mayutju tiṉalampa nyinanyi. Nintila tjananya!, ngayulu nyuntupa wangkawana yaḻṯirra tjananya ngaratjunkunytjaku, tjana nyakunytjaku, nyuntu warutjarrangku tiliṉingka. Tjanaya kulintjaku nyuntuṉin alatji watjaṉutjangka, ‘Yilaatja. Waru an kuka tililwiyangku nyuntu tjunkula ngayunya tjapila tilintjaku!’” Yilaatjalu yalatji Katutjanya piyuku tjapiṉu, “Yaṉangu ngaa tjuṯa tjananya nintilkitjangku nyuntu kurrkalpa tilila!, nyakulaya tjukarurrungku kulintjaku, nyuntu mayutju tiṉalampatju nyinanyi. Yalatji tjananya nintila!, yaḻṯururringkula kanyintjakitjangku yaṉangu tjuṯa.” Palunyangka Katutjalu waru katunguru waṉingu. Waru paluru uulta puḻinguru palyaṉutja winki kamparra wiyaṉu, kuka tjawirrilyiṯarra. Ngaṯi palula kapi an paṉa kamparra tjuṉparringu. Yaṉangu tjuṯaya nyakula nguḻurrirra waṯungarala alatjingku Katutjanya puḻkapungu, “Katutjanya mularrpa mayutju tiṉa kutjulampa nyinanyi.” ");
INSERT INTO piu2006_vpl VALUES ("K118_40","012_18_40","1KI","18","40","40","Palunyangka tjananya Yilaatjalu watjaṉu, “Paalaku wangka watjalpayi tjuṯa tjananya uwankarra witira kanyila!, palumpa waarrkana tjuṯa.” Palunyatjanu tjananya Yilaatjalungarri katingu karru yini Kitjunakutu. Paluru tjana katirra tjananya Paalaku waarrkana uwankarra mirri pungkuyinangi. ");
INSERT INTO piu2006_vpl VALUES ("K118_41","012_18_41","1KI","18","41","46","Palunyangka Yilaatjalu mayutju tiṉa Yiyapangka alatji watjaṉu, “Pakara yankula ngalkula! Kuwarri kapi tiṉangkulanya pungamalpa. Kuliṉiṉa kapingku kutu punganyi.” Wangka palunya watjaṉu yutuwari ngaranytjawiyangka. Mayutju Yiyapanya yankula ilangku mayi ngalkuṉingka, Yilaatjanyapula palumpa waarrkana puḻi Kamilangka kaḻparra nyinangi. Yilaatjanya pupakatirra kata muṯi kutjarrangka ngururrpa tjunkula Katutjanya kapiku tjapiṉingi. Palumpa waarrkana witulkitjangku paluru alatji watjaṉu, “Puḻingka katu kaḻparra wilurarra nyawa!, utuwariku.” Waarrkana paluru kaḻparra puṯu nyakula piyuku ngalya tjarukatirra Yilaatjala alatji tjakultjunu, “Wiya, puṯuṉa nyangu.” Tjikitjipalangara paluru kaḻparra puṯu nyangu, Yilaatjalu iyaṉutjangka. Palunyatjanu piyuku iyaṉu. Waarrkana paluru kaḻparra nyakula ngalya tjarukatirra tjakultjunu, “Nyanguṉa utuwari, tjukutjuku, yurunguru mara kapuṯu nguwanpa pakaṉingka.” Palunyatjanu Yilaatjalu waarrkana palunya alatji iyaṉu, “Mayutju tiṉanya Yiyapanya ankula tjakultjurra!, paakingka kaḻparra ngurrakutu wala ankunytjaku, kalyu tiṉangku angatjunkupayingkamarra.” Utuwari tiṉarringu tjanampa waḻpa tiṉa wangkangi. Palunyatjanu kapi tiṉangku tjananya pungkula wanaṉu. Yiyapanya paakingka kaḻparra ngurra Tjitjirilakutu yananyingka, Yilaatjanya paakingka yurrunpa tjina tjalkaḻungkuyinangi ngurra Tjitjirilakutu, Katutjalu palunya katiyanangitjangka. ");
INSERT INTO piu2006_vpl VALUES ("K119_1","012_19_1","1KI","19","1","8","Ngurrakutu ankula mayutju Yiyapalu palumpa miiṯangka Tjiitjapilala tjakultjunu, Yilaatjalungarri Paalaku waarrkana tjuṯa mirri pungutjangka, Paalaku wangka watjalpayi tjuṯa. Palunyatjanu Tjiitjapilalu mirrpaṉarrirra waarrkana iyaṉu Yilaatjangka alatji tjakultjunkunytjaku, “Nyurrangarri tjananya Paalaku waarrkana tjuṯa mirri pungutjangka, ngayululpiṉanta palunya nguwanpa ngaparrtjilu mirri pungku. Pungkukitjangkuṉanta tjukarurru watjaṉi, tjiṉṯu kutjupangkan mirri ngarriku. Mirri pungkuwiyangkuṉanta wantinytjala palyaṉiya mayutju ilkari ngurrara tjuṯangku mirri pungkunytjaku. Yuwa, yiltalatjunta mirri pungku, wantiwiyangku.” Kulira Yilaatjalu nguḻurringkula palumpa waarrkana aḻṯirra maḻpararrapula anu tawunu Piitjipakutu. Ngurra palula waarrkana nyinatjunkula wantirra Yilaatjanya kutjulpi wayinta anu ngurra kapi yukiri kukawiyawana yulparirralku. Yankula wilytjangka watjilpa nyinarra alatji Katutjangka tjapiṉu, “Mayutju Katutja. Kutjupa tjuṯangkuṉiya mirri pungkutjipingka ngayulu puṯu kuliṉi.” Palunyatjanu paluru Katutjanya alatji watjaṉu, “Ngayunyalpiṉi mirrintarra! Watjilpaṉa nyinarra yunytjurringanyi mirrirrikitja.” Wilytja palula paluru ngarrikatirra ankurringu. Palunyangka ilkari ngurrarangku kanara yalatji watjaṉu, “Pakara ngalkula!” Kanarrirra nyangu puriiti kutjukamu paatula kapitjarra ngarangi. Pakara ngalkura tjikira ngarrikatirra yankurringu. Katutjaku waarrkana paluru ilkari ngurrarangku piyuku kanara watjaṉu, “Pakara ngalkula!, ngururrpa mayitjirratja punkara wiyarritjipingka.” Palunyangka Yilaatjalu pakara piyuku ngalkuṉu. Ngalkula tjikira yulparirra waṉma yanu puḻi Tjaniyalakutu, ngururrpa piyuku ngalkula tjikintjawiya. Paluru rawa yanangi ngurra palulakutu, Purayitiyi tjikitjipala. ");
INSERT INTO piu2006_vpl VALUES ("K119_9","012_19_9","1KI","19","9","18","Puḻi Tjaniyala Yilaatjanya kuḻpingka tjarrparra ngarrirra yankurringu, mungangka. Ngurra palula mayutju Katutjalu Yilaatjanya yalatji tjapiṉu, “Yilaatja. Nyaakitjan ngaangka nyinanyi?” Yilaatjalu alatji watjaṉu, “Katutja. Nyuntu mayutju tiṉatjun nyinanyi. Nyuntupa kutjuṉangku waarrkana tjukarurru nyinapayi. Kutjupa tjuṯaya Yitjurilaku walytja ngaṉṯitja tjuṯa wiyawana nyinanyi. Nyuntupa wangka wantirraya nyuntupa uulta tjuṯangka wiyaya nyuntunya puḻkapunganyi. Nyuntupa uulta tjuṯaya kilytjuntankula wiyalpayi. Nyuntupa wangka watjalpayi kutjupa tjuṯa tjananya tjana pungkula wiyaṉu. Ngayunya kutjulpiṉa kana nyinanyi. Kuwarriya yunytjurringanyi ngayunyalpiṉiya mirri pungkunytjakitja.” Katutjalu kulira Yilaatjala watjaṉu, “Kuḻpinguru pakara maa yarra! Puḻingka kaḻparra ngara!, ngayulu nyuntula tjungurrinytjaku.” Pakara yankukitjangka Katutjalu waḻpa tiṉa wantirriyaṉu. Waḻpa paluru puḻi tjuṯa rungkara kilytjukilytjuntanu. Yalatji waḻpa tiṉa rungkaṉingitjangka Yilaatjalu puṯu kuliṉu Katutjala tjungurrikitjangku. Yilaatjalu yalatji puṯu kuliṉu, “Tjinguru Katutjanya waḻpa tiṉawana tjungu ilarringanyi, tjinguru wiya.” Waḻpa wiyarringutjangka paṉa pirrtjipirrtjingi. Pirrtjipirrtjinyingka Yilaatjalu puṯu kuliṉu Katutjala tjungurrikitjangku. “Tjinguru paṉa pirrtjinyingka Katutjanyaṉi ilarringanyi, tjinguru wiya.” Paṉa pirrtjipirrtjirra wiyarringutjangka waru tiṉalpi kamparra wanaṉingi. Kamparra wanaṉingitjangka Yilaatjalu puṯu kuliṉu Katutjala tjungurrikitjangku. “Tjinguru waru wanaṉingitjawana Katutjanyaṉi ilarringanyi, tjinguru wiya.” Waru kamparra wiyarringutjangka Yilaatjalu kuliṉu Katutjanya wangkanyingka. Wangka palunya kulira Yilaatjalu kuutangka yuṉpa tjutura kuḻpi yaḻakutu ankula ngarangi. Ngarala wangka alatji kuliṉu, “Yilaatja. Nyaakitjan ngaangka nyinanyi?” Yilaatjalu watjaṉu, “Katutja. Nyuntu mayutju tiṉatjun nyinanyi. Nyuntupa kutjuṉanku tjukarurru waarrkana nyinapayi. Kutjupa tjuṯaya Yitjurilaku walytja ngaṉṯitja tjuṯa wiyawana nyinanyi. Nyuntupa wangka wantirraya nyuntupa uulta tjuṯangka wiyaya nyuntunya puḻkapunganyi. Nyuntupa uulta tjuṯaya kilytjuntankula wiyalpayi. Nyuntupa wangka watjalpayi kutjupa tjuṯa tjananya tjana pungkula wiyaṉu. Ngayunya kutjulpiṉa kana nyinanyi. Kuwarriya yunytjurringanyi ngayunyalpiṉiya mirri pungkunytjakitja.” Katutjalu Yilaatjala piyuku alatji watjaṉu, “Tawunu Tamatjakatjangka ila ngurra kuya kapiwiya ngaranyi. Ngurra palulakutu ankula nyinama! Palulanguru yarra tawunu Tamatjakatjalakutu! Tjarrparra ankula wati Yatjiyilanya tjira intira mayutju tiṉa tjanampa nyinatjurra!, Tjiriyanya ngurrara tjuṯaku. Palunyatjanu ankula Tjiiyuwanya nyawa, tjiḻpi Nimitjiku katja! Wati palula tjira intira mayutju nyinatjurra!, Yitjurilaku walytja ngaṉṯitja tjuṯaku mayutju tiṉalpi nyinanytjaku. Wati kutjupaṯarra Yilatjanya yankula tjira intila!, ngayuku wangka watjalpayi nyinanytjaku. Paluru wati Tjapataku katja nyinanyi. Paluru nyinaku wangka watjalpayi nyuntu wiyarringanyingka ngaṉṯi. Mayutju palunya tjuṯangku kuyarringkupayi tjuṯa tjananya iluntanku. Kutjupa tjuṯa tjananya mirri pungkuwiyangku wantiku. Ngayulu Katutjalu tjananya Yitjurilaku walytja ngaṉṯitja tjuṯa yaṉṯayaṉṯara kanyilku ngayuku tjana tjukarurru nyinanyingka. Kanalpiya nyinamalpa tjuṯalingku tjapan tjawutjuna. Tjanaya Paalaku ngurrpa nyinanyi, ngayukuya tjukarurru nyinanyi.” ");
INSERT INTO piu2006_vpl VALUES ("K119_19","012_19_19","1KI","19","19","21","Palunyatjanu Yilaatjalu ankula wati Yilatjanya nyangu, puluka kutjarrangku yayina katiyananyingka, paṉa kaanaku yuḻpurinkupayitjarra. Yalatji waarrkarrinyingka Yilaatjalu palumpa kuuta waṯawara irrilytjunkula wanara Yilatjaku yaḻipiringkalpi tjunu, palumpa waarrkana nyinanytjaku. Kututja, Katutjaku wangka watjalpayingku mayutju kutjupa Katutjaku nyinatjunkukitjangku kuuta walytja irrilytjunkula aḻipiringka tjunkupayi, Katutjaku wangka watjalpayi kuuta palunyatjarralpi Katutjakuṉu ngangkaritjarra nyinanytjaku. Palunyatjanu Yilatjalu Katutjaku wangka watjalpayi nyinakitjangku kulira puluka palunya kutjarra wantirra Yilaatjangka alatji watjaṉu, “Wanyuṉa ankula paapakamu maamangka tjakultjunku, ngayulu pulanya nyunytjura tjunguli wantirra yankukitjangku.” Yilaatjalu wati Yilatjangka alatji watjaṉu, “Palya, yankula pulanya maa watjara wantikati!, nyuntupa paapa an nyuntupa maama yankukitjangku kulira.” Palunyatjanu Yilatjalu palumpa puluka kutjarra mirri pungkula kutjara tjanampa yungu, palumpa walytja tjuṯaku. Palunyatjanu Yilatjaku waarrkana nintirrikitja tjungupula yanangi. ");
INSERT INTO piu2006_vpl VALUES ("K121_1","012_21_1","1KI","21","1","7","Mayutju Yiyapaku ngurrangka ila wati Niputjaku kaana palya kiripitjitjarra ngarangi. Yiyapalu kaana kutjupa tjuṯa kanyilpayi. Kaana palunya rawangku nyakula yunytjurripayi mantjilkitja. Yunytjurringkula Niputjanya ankula alatjingku tjapiṉu, “Nyuntupa kaana payimilalkitjaṉa ngalyanu. Palyaṉa payimilalku? Ngayuku ngurrangka ila ngaranyi. Kanyira yukiri kutjupa kutjupa pakaltjingalkitjangkuṉa kuliṉi. Tjingurun kaana kutjupaku nyakula unytjurringanyi, kaana palunyaṉanta payimilara yungku, kaana ngaatjanya kanyilkitjangku.” Niputjalu watjaṉu, “Kaana ngaatjanya ngayuku paapangku an tjamungku kanyilpayi. Palunyatjanuṉa kanyiṉi. Katutjakuṉu luwulampa yalatji ngaranyingka ngayuluṉa kutu kanyintjaku, Katutjanyatju kuyarringkupayingkatju. Palunyangka wiyaṉanta tjalamilalku kaana ngaatjanya ngayuku tjamukuṉu. Kaana kutjupa kanyilkitja wiyaṉa yunytjurringanyi.” Yiyapalu kulira watjilarrirra ngurrakutu yanu maḻaku, Niputjaku kuyarringkula. Mayi ngalkuntjawiya piitangka kutu ngarringi, kaana palunyatjirratja. Yiyapalu kaanaku puṯu tjapiṉingitjangka Tjiitjapilalu palumpa miiṯangku kulira Yiyapalakutu ankula watjaṉu, “Watjilpa ngarrinytjawiya pakala!, yunypa nyina!, ngayuluṉanku Niputjaku kaana mantjilku.” ");
INSERT INTO piu2006_vpl VALUES ("K121_8","012_21_8","1KI","21","8","16","Tjitjirilanya ngurrara mayutju tjuṯakutu Tjiitjapilalu piipa tjuṯa wakara wantirriyaṉu, yara alatjitjarra. “Yaṉangu tjuṯa nyurrangarri watjala!, ngula tjungurringkula ngalkura tjikira yunyparrinytjaku. Ngalkuranyurra tjikira Niputjanya yankula mantjira katinytjaku, ngunytji mayutju nguwanpa nyinatjunkukitjangku. Yurrunpangku pulanya nyurrangarri wati kutjarra tjingapuwa!, Niputjanyapula ngunytjilyinkunytjaku, yaṉangu kutjupa tjuṯangka mirangka. Alatjipula Niputjanya watjalku, ‘Katutjanyaṯarra mayutju Yiyapanya nyuntu Niputjalu kulira wantipayi.’ Palunyangka tjuṯangkunyurra Niputjanya witira katirra puḻitjarrangku rungkara mirrintankunytjaku.” Yitjurilaku walytja ngaṉṯitja tjuṯangku yaṉangu Katutjanya panypurangkupayinya kututja rungkara mirrintankupayi. Tjiitjapilalu piipa palunya tjuṯa wakara tjanampa wantirriyaṉutjangka mayutju palunya ngurrara tjuṯangku Niputjanya yaṉangu kutjupa tjuṯaṯarra yaḻṯirra tjunguṉu tjananya. Yalatjiya yaṉangu tjuṯa tjungurrirra ngalkula tjikira nyinanyingka, paluru kutjarrangku ngunytjilyira Niputjanya ngunytji watjaṉu. Yalatjipula ngunytjilyinutjangkaya yaṉangu tjuṯangkuya Niputjanya witira katirra puḻitjarrangku rungkara mirrintanu. Palunyatjanu mayutju palunya tjuṯangku Tjiitjapilakutu waarrkana wantirriyaṉu yara yalatji tjakultjunkunytjaku, “Wati Niputjanyaya puḻingka rungkara yiluntanu.” Kungka Tjiitjapilalu tjakultjunkunytja kulira yunyparringu. Paluru mayutju Yiyapalakutu ankula tjakultjunu, “Niputjanyaya yiluntanu. Palunyatjanu kaana palunya nyuntu yankula kanyinma!” Palunyangka Yiyapalu tjananya ankula waarrkana tjuṯa, ila nyinanytja tjuṯa watjaṉu kanyintjaku, Niputjakuṉu kaana. ");
INSERT INTO piu2006_vpl VALUES ("K121_17","012_21_17","1KI","21","17","27","Mayutju Katutjalu Yilaatjanya palumpa wangka watjalpayinya alatji watjaṉu, “Yankula mayutju Yiyapanya nyawa!, Niputjaku kaana mulyaṯangku kanyiṉingka. Yankula kaana palula nyakula alatjira tjakultjurra! ‘Wati ngaa ngurrara tjana mirri pungutjangka palumpa kaana wiyan mulyaṯangku kanyintjaku. Ngayulu Katutjaluṉanta Yiyapanya alatji tjukarurru watjaṉi. Ngurra panyapangka Niputjanya wiyarringu, ngurrka papa tjuṯangku anytjuṉu, nyuntunyaṯarralpi anytjulku.’” Yilaatjalu ankula wangka palunya mayutju Yiyapangka tjakultjunu. Wangka kutjupaṯarra palulakutura alatji watjaṉu Katutjakuṉu wangka, “Nyuntu kutu Katutjaku wangka wantirra kuya palyalpayi. Palunyatjanu nyuntupa walytjapiṯiṯarra tjananya Katutjalu mirri pungkula wiyalku. Nyuntupa miiṯa Tjiitjapilanyaṯarraṉa mirri pungku. Tawunu Tjitjirilangka palunya mirri ngarrinyingka papa tjuṯangkulpiya ngalku. Nyuntupa walytja kutjupa tjuṯa ngurra waṉma mirri ngarrirra waṉinytjala tjuḻpu tjuṯangku ngalku.” Mayutju Yiyapalu wangka palunya kulira nguḻurrirra mantarra walytja palumpaṉu wintarrpungangi. Mayi an kuka ngalkuwiyangku wantirra watjilpa nyinangi. Yitjurilaku walytja ngaṉṯitja tjuṯangku kututja mantarra walytja watjilarringkula wintarrpungkupayi. ");
INSERT INTO piu2006_vpl VALUES ("K122_1","012_22_1","1KI","22","1","40","Mayutju tiṉa Yiitjanya tjanampa Tjuutaku walytja ngaṉṯitja tjuṯaku nyinarra mirrirringu. Palunyatjanu palumpa katja Tjiyutjapatanya mayutju tiṉalpi tjanampa nyinangi. Mayutju Yiyapa paluru ankula mayutju Tjiyutjapatanya tjapiṉu, “Palyala tjungu yankuku tawunu Ramutjalakutu pikangku pungkukitja?” Tjiyutjapatalu kulira yunyparrirra watjaṉu, “Katutjaku wangka watjalpayi tjuṯanya ngali tjananya tjapilkuwarri.” Katutjaku wangkapayi tjanaya tjuṯalingku nyinapayi, puu yantaṯa. Yiyapalu tjananya tjungura tjapiṉu, “Palyalatju tjananya ankula Tjiriyanya ngurrara tjuṯa mirri pungkula, kutjupa tjuṯa nguḻutjingaralatju wantirriyalku?, tawunu Ramutjanya kanyilkitjangku.” Watjaṉuya, “Yuwa. Yankula tjananya nyurrangarri palya pungku, mayutju Katutjalu nyurranya kaṉṯilyanku.” Tjiyutjapatalu Yiyapanya tjapiṉu Katutjaku wangka watjalpayi kutjupa yaḻṯirra ngalya katinytjaku kutu tjapintjakitjangku. Yiyapalu watjaṉu, “Katutjaku wangka watjalpayi yini Makayanya nyinanyi. Wiyaṉa palunya tjapilku, yara kuyakuya kutjuṉi tjakultjunkupayi.” Tjiyutjapatalu watjaṉu Makayanya aḻṯirra ngalya katinytjaku. Paluru ngalya yankula ngaranytjala, wangka panyapapula tjapiṉu, yurruntitja tjuṯa tjapiṉutja nguwanpa. Kanya wati Yiyapaku waarrkanangku Makayanya tjingapungu, “Nyuntu wangka yurruntitja tjuṯangku watjaṉingitja nguwanpa Yiyapalara watjala!” Palunyatjanu Makayalu pulanya nguntilyira alatji watjaṉu, “Palyanyurra ankula tjananya mirri pungku.” Yiyapalu kulira alatji marrkuṉu, “Wiya nyuntu ngalinya nguntilyinkunytjaku.” Palunyatjanu Makayalu yalatji tjukarurru watjaṉu, “Tjukurrmankulaṉa nyurranya nyangu Yitjurilaku walytja ngaṉṯitja tjuṯa tjilirratjarra tjuṯa. Tjanaya parra ngarala yulangi mayutju wiyarringutjangka.” Makayalu pulanya yara watjaṉu yalatji, “Katutjaku wangka watjalpayi tjuṯangku nyupalinya ngunytji watjaṉu.” Paluru kutjarra yara kulira Makayaku ngurrkurringu. Wangka palunya kulintjawiyaya Yiyapanya Tjiyutjapatanya tjilirratjarra tjuṯaṯarra, tawunu Ramutjakutu tjungu yanu pika pungkula tawunu palunya tjulyantjakitja. Yiyapanya mantarra kuyakuyangka tjarrparra paakingka yanu pika pungkukitja. Palunyatjanuya Tjiriyanya ngurrara tjuṯangku Yiyapanya kutju yiluntankukitjangku puṯu nuuwimilaraya wantingu. Wati Tjiriyanya ngurrarangku puwanarratjarrangku Yiyapanya kutjupakutjura kulira kultu wakaṉu. Yiyapaku paaki waarrkanangku katiyanangi. Paluru katirra ngaratjunu waṉma nguwanpa kutjupa tjuṯangkuyanku pika pungkunytjala. Paakingka Yiyapanya pika yawarratjarra witira ngarala mungarrtjilpi ilungu. Pikangkuyanku kutu pungkupayi. Palunyatjanu Yiyapanya ngurra walytjakutu mirri katirra tjunutjunu tawunu Tjamiriyangka. Yiyapaku paaki Yiyapanya ngurrkatjarraya katirra ngaratjunu Tjamiriyangka kapingka. Palunyatjanuya papa tjuṯangkulpi Yiyapanya ngurrka yanytjuṉingi, mayutju Katutjalu panyapa watjaṉutjangka. ");
INSERT INTO piu2006_vpl VALUES ("K22_1","013_2_1","2KI","2","1","12","Mayutju Katutjalu Yilaatjanya nintiṉu ilkarikutu katikitjangku. Palulanguru tawunu Kilkalangka Yilaatjalu palumpa waarrkana Yilatjanya yalatji marrkuṉu, “Ngurra ngaangka nyinama! Mayutju Katutjaluṉi watjaṉu Piitjulakutu yankunytjaku.” Yilatjalu tjungu yankukitjangku tjiḻpi Yilaatjanya marrkuṉu. Palunyatjanu yiltapula tjungu yanu Piitjulakutu. Piitjulanya ngurrara tjuṯangkuya Katutjaku wangka watjalpayingku Yilatjanya yalatji watjaṉu, “Nyuntu kuliṉi? Nyuntupa mayutju Katutjalu kuwarri katiku, kutjulpinu nyinaku.” Yilatjalu watjaṉu, “Yuwa kuliṉiṉa.” Palunyatjanu tjiḻpi Yilaatjalu Yilatjanya piyuku marrkuṉu, “Ngurra ngaangka nyinama! Mayutju Katutjaluṉi watjaṉu tawunu Tjirikulakutu ankunytjaku.” Yilatjalu watjaṉu, “Wiyaṉanta wantikatiku tjunguli ngurra palulakutu ankuku.” Yankulapula tjarrpangu. Tjirikunya ngurrara tjuṯangkuya Katutjaku wangka watjalpayi tjuṯangku Yilatjanya piyuku watjaṉu, Katutjalu tjiḻpi Yilaatjanya katinyingka. Tjiḻpi Yilaatjalu Yilatjanya kutu marrkuṉu, “Ngurra ngaangka nyinama! Mayutju Katutjaluṉi watjaṉu karru Tjuutanangka munkarra yankunytjaku.” Puṯu marrkuralpipula Yilatjanyapula tjungu yanu. Paluru tjana Katutjaku wangka watjalpayi tjuṯa tjungu yanu karru Tjuutanalakutu. Karru ilangka ngarala Yilaatjalu palumpa kuuta irriwiltjira karrpira kapi pungu kuutatjarrangku. Kapi tiṉa ukalingkunytjawiyangka paṉa kutju ngaranyingkapula itipirringu. Karrungka tjarukatirrapula maa ankula kaḻpangutjangka, ngaṉṯi kapi tiṉa ukalingangi. Ngarala tjiḻpi Yilaatjalu Yilatjanya yalatji tjapiṉu, “Katutjaluṉi kutu katinyingka yaalytjinkuṉangku?” Yilatjalu watjaṉu, “Yunytjurringanyiṉanta nyuntupaṉu kaṉṯilyatjarra nyinanytjakitja. Katutjaku wangka watjalpayi nyuntunya nguwanpa nyinanytjakitjaṉa yunytjurringanyi.” Tjiḻpi Yilaatjalu watjaṉu yalatji, “Ngayukuṉu kaṉṯilya puntuṉanta yungkukitjangku puṯu kuliṉi. Nyuntu ngayunya irra nyakunytjatjanu kutju Katutjaluṉi katinyingka palurunta yungku ngayukuṉu kaṉṯilya puntu, palunyatjarran nyinaku. Ngayunya nyuntu wiya irra nyakula kaṉṯilyawiyan nyinaku, maralpa nguwanpa.” Kutupula ankula wangkayinangi. Palunyatjanu paaki naanytja tjuṯatjarra nguwanpa ngalya tjarukatirra palula kutjarrangka ngarangi waru tilitjarra. Palunyatjanu waḻpa tiṉangku Yilaatjanya katingu ilkarikutu paaki palula. Maa katinyingka nyakula Yilatjalu watjaṉu, “Tjiḻpi, nyuntu ilkarikutu ananyi. Nyuntu mayutju palyalampatju nyinanyi Yitjurilaku walytja ngaṉṯitja tjuṯaku. Nyuntulanya palya yaṉṯayaṉṯalpayi.” Katutjalu tjiḻpi Yilaatjanya alatji katukutu maa katirra wiya piyuku paṉakutulpi ngalya katingu. Yilatjalu wiya palunya piyuku nyangu. Tjiḻpi Yilaatjanya katukutu nyakula palurulpi kaṉṯilya puntutjarra nyinangi. ");
INSERT INTO piu2006_vpl VALUES ("K24_8","013_4_8","2KI","4","8","37","Palunyatjanu Yilatjanya tawunu Tjunimalakutu ankula nyinangi. Palunya ngurrarangkupula miiṯararrangku yulytja tiṉatjarrangku yaḻṯingu, paḻtjalkitjangku. Palunyatjanu Yilatjanya tawunu palulawana tjuṯangara ankunytjala, minyma paluru paḻtjara wantirriyalpayi. Minyma paluru palumpa miiṯangka yalatji watjaṉu, “Wati palatja yilta Katutjaku wangka watjalpayi nyinanyi. Palumpara ruuma ngali palyantjaku, paluru yaatjayiṯi ngarripayingka, paluru ngalya yankula ngarrirra wayintarrinytjaku. Ruuma ngalira waaḻa ngaangka katu tjayiṯi palyalku, palumpa.” Palunyatjanupula Yilatjaku ruuma palyaṉu. Palunyatjanu Yilatjalu ruuma palunya nyakula yunyparringu. Ruumangka ngarala palumpa waarrkana yini Kiyatjanya wantirriyaṉu, minyma palunya yaḻṯirra ngalya katinytjaku. Ngalya yankula ngaranyingka, Yilatjalu puṯu tjapiṉu ngaparrtjingkura yungkukitjangku, ruuma palyaṉutjatjanungka. Minymangku alatji watjaṉu, “Yulytja tiṉaṉa kanyiṉi, wiya kutjupakuṉa yunytjurringanyi.” Minyma paluru yankula nyinanyingka Kiyatjalu Yilatjanya watjaṉu, “Minyma paluru katjawiya nyinanyi, palumpa miiṯa tjiḻpi nyinanyingka.” Kiyatjalu minyma yankula piyuku yaḻṯirra ngalya katirra ngaratjunu. Yilatjalu minyma palunya yalatji watjaṉu, “Nyuntu ngula katja mantjilku, yiiya kutjungka.” Minyma paluru kulira watjaṉu, “Nyuntu Katutjakuṉu, wiyaṉin ngunytjilyinkunytjaku.” Palunyatjanu ngula minyma paluru yilta katja mantjiṉu, yiiya kutjungka. Ngula katja palunya tiṉarringkula nyinarra kaanakutu yanu paapa palumpawana nyinakitja. Nyinarra mikin tiṉarrirra paapangka yalatji watjaṉu, “Kataṉi mikinarringanyi.” Paapangku watjaṉutjangka waarrkanangku waaḻakutu tjupura katirra maama palumpakura yungu. Yampungka kanyiṉingitjangka uḻa wiima palurupilku kaḻaḻa mirrirringu. Minyma paluru maa kaḻparra katukutu ruuma Yilatjakuṉukutu katirra yinytjamingka ngarritjunu. Palumpa miiṯangka katja mirrirringutjangka tjakultjunkunytjawiya tuungkiyingka kaḻparra wala yanu puḻi Kamilalakutu, Yilatjanya tjakultjunkukitja. Tuungkiyitjarra wirrkanutjangka nyakula Yilatjalu waarrkana Kiyatjanya iyaṉu, yankula tjungurrinytjaku. Iyalkitjangku alatji watjaṉu, “Minyma Tjunimanya ngurrara ngalyananyingka yiwarrawana, yankula nyawa!” Kiyatjalu yankula puṯu tjapiṉu. Minyma paluru palya wangkarra kutu ngalyankula tuungkiyi ngaratjunu Yilatjala. Paluru tjarukatirra pupakatirra yulangi. Yalatji watjaṉu, “Ngayuluṉa kuwarri yuḻṯurringu, puṯuṉa kuliṉi.” Kulira Yilatjalu Kiyatjanya watjaṉu, “Ngayuku watiya mantjira wala yankula uḻa palula katu kanyila!, kanarrinytjaku.” Kiyatjanya yurrunpa yanu uḻa kanantjaku, kanya paluru kutjarrapula ngaṉṯiwana purrkalingku yanangi Yilatjaku waaḻakutu. Yilatjanyapula ngururrpa yananyingka Kiyatjalu uḻa puṯu kanara maḻaku Yilatjalakutu yankula tjakultjunu. Waaḻa palulakutuya tjungu ankula Yilatjalu kutju kaḻparra tjarrparra yinytjamingka uḻa palunya mirri ngarrinyingka nyangu. Tuuwa patira Katutjanya tjapira uḻa palula katuwana waṯungarangu. Yalatji Yilatjanya uḻa palula katuwana waṯungaranyingka wuumpirringu. Yilatjanya pakara waaḻawana unngu yankula piyuku uḻa palula waṯungarangu. Palunyatjanu kanarrirra tjapanpalangara nyurrtjipungkula kuru yaḻarringu. Yalatji kanarringanyingka Yilatjalu mantjira katirra yungu palumpa maama. ");
INSERT INTO piu2006_vpl VALUES ("K25_1","013_5_1","2KI","5","1","14","Tjilirratjarra tjuṯaku mayutju yini Nayamananya nyinangi manta Tjiriyala. Mayutju paluru pangki pikatjarra nyinarra puṯu kulilpayi, pika wiyantjakitjangku. Pangki pikatjarra palunya ngangkaritjarra tjuṯangkuya puṯu palyalpayi. Nayamanalungarri tjananyaya tjilirratjarra tjuṯangku ankula pikangku pungu Yitjurilaku walytja ngaṉṯitja tjuṯa. Kungka wiima kutjuya witira katingu ngurra Tamatjakatjalakutu. Kungka wiima paluru Nayamanaku ngurrangka waarrkarringkupayi, palumpa miiṯaku waarrkana. Nayamanalu pangki pikatjarrangku puṯu kulira watjilpa nyinangi. Kungka wiima paluru nyakula Nayamanaku miiṯangka alatji watjaṉu, “Nayamananya Katutjaku wangka watjalpayilakutu ankunytjaku, Tjamiriyanya ngurraralakutu. Paluru pangki pikatjarra palyalpayi.” Nayamanaku miiṯangkulpi wangka panyapa kulira Nayamananya tjakultjunu. Tjakulpa kulira Nayamanalu yankula Tamatjakatjanya ngurrara tjuṯaku mayutju tiṉangka tjakultjunu. Palunyatjanu mayutju puḻka paluru Nayamananya alatji watjaṉu, “Yitjurilaku walytja ngaṉṯitja tjuṯaku mayutju tiṉa nyinanyi. Ngayuluṉa piipa wakalku, nyuntu mayutju palulakutu katirra yungkunytjaku, palunya ngurrarangkunta palyantjaku. Piipa ngaatjanya yara alatjiṉanta wakalku, ‘Piipa ngaatjanyanta ngayuku waarrkanangku Nayamanalunta katirra yungku. Paluru pangki pikatjarra nyinayananyingka unytjurringanyiṉa ngangkaritjarrangku palyantjaku.’” Nayamanalungarri palumpa waarrkana tjuṯangku piipa palunya mantjira katingu tawunu Tjamiriyalakutu. Puḻi kuulta, puḻi tjiilpa mantarraṯarraya katingu yinytjanungku yungkukitjangku, palyarringanyingka. Piipa palunyaya katirra yungu Tjamiriyanya ngurrara tjuṯaku mayutju. Paluru riitarringkula puṯu kuliṉu, “Nyaakuṉi mayutju Tjiriyanya ngurrarangku tjapiṉi, pangki pikatjarra palyantjaku? Wiya Katutjanya nguwanpangkuṉa pika palyalpayi. Ngangkaritjarrangku pika pangkiṯarra puṯu palyalpayi. Ngangkaritjarrangku puṯu palyaṉingka palurungarri mirrpaṉarringkula ngalya yankula pikangkulanya pungku. Pika pungkukitjangku piipa ngaatjanyatju ngalya wantirriyaṉu.” Mayutju Tjamiriyanya ngurrara paluru piipa panyapa riitarringkula puṯu kuliṉingka, Yilatjalu tjakulpa kuliṉu. Palunyatjanu Yilatjalu palumpa waarrkana wantirriyaṉu mayutju Tjamiriyanya ngurraralakutu, yalatji tjakultjunkunytjaku, “Puṯu kulintjawiya, Nayamananya ngayulakutu ngalya wantirriyala!, ngalilitju wangkanytjaku. Paluru ngayuku wangka kulira yalatji kulilku, ‘Ngaatja yilta Katutjaku wangka watjalpayi, kaṉṯilya puntutjarra nyinanyi.’” Palunyatjanu Nayamananyangarri Yilatjaku waaḻakutu ankula ngarangi. Yilatjalu palumpa waarrkana wantirriyaṉu Nayamananya alatji watjantjaku, “Karru Tjuutanakutu arra!, tjapanpalangara tjurrpinytjaku. Yalatji nyuntu tjurrpirra pangki palyarriku.” Nayamanalu kulira mirrpaṉarrirra alatji watjaṉu, palumpa waarrkana tjuṯala, “Ngayulu mayutju tiṉa nyinanyi. Palangku ngalya yankula mara katura Mama Katutjanya tjapilmara ngayunya palyantjaku. Ngaa ngurrara tjuṯaku tjanampa karru Tjuutananya kuya. Nganampa karru walytja kutjarra palya ngarrinyi manta Tamatjakatjalawana. Karru palulakutuṉi iyanmara.” Mirrpaṉarrirra panyapa wangkarinangi kulira Nayamanaku waarrkanangku alatji marrkuṉu, “Katutjaku wangka watjalpayingkunta watjaṉutjangka nyuntun palya ankula tjurrpinytjaku, palya nyinakitja.” Palunyatjanu Nayamananya karru Tjuutanalakutu ankula tjapanpalangara tjurrpirra pangki palyarringu, pikatjarrarrinytjawiyalpi. ");
INSERT INTO piu2006_vpl VALUES ("K25_15","013_5_15","2KI","5","15","19","Nayamananyangarriya yunyparrirra maḻaku yanu Yilatjaku waaḻakutu. Nayamanalu Yilatjala alatji watjaṉu, “Ngayulu palyantjatjanungkuṉa tjukarurrulpi kuliṉi. Katutjanya kutjulampa mayutju tiṉa nyinanyi. Paluru Yitjurilaku walytja ngaṉṯitja tjuṯa yaṉṯayaṉṯalpayi. Palyarringutjatjanungkuṉanta mani yulytjaṯarra yinytjanungku yungku.” Yilatjalu marrkuṉu, “Wiya, kanyilangku! Wiyaṉin yinytjanungku yungkunytjaku.” Nayamanalu puṯu yungkula alatji watjaṉu, “Ngayulu ngurrakutu yankula mayutju Katutjanya kutju puḻkapungkukitjangku kuliṉi. Katutjaku kutjuṉara tjawirrilyi pungkula kutjalku. Ngaatjanya kutjuṉanta kuwarri tjapiṉi. Palyaṉa paṉa ngaatjanu payikingka tjunkula tuungkiyi kutjarrangka katiku? Kuliṉiṉa Katutjaku paṉa walytja ngaa ngurraraṉa mantjira katirra ngurra walytjangka yintilku. Yintira tjinangku paṉa kantura ngaraku Mama Katutjanya puḻkapungkukitjangku.” Yilatjalu watjaṉu, “Palya, ngurrakutu tjawara mantjira kati!” ");
INSERT INTO piu2006_vpl VALUES ("K25_20","013_5_20","2KI","5","20","27","Yilatjalu mani an yulytja palunya mantjintjawiyangku wantirriyaṉutjangka, palumpa waarrkana Kiyatjalu alatji kuliṉu, “Ngayuku mayutjungku mani yulytjaṯarra ngaparrtji mantjinmara. Nayamanalu ngaparrtji mani an yulytja tjukarurrungku yungamara. Waṯalpi, ngayululpiṉa wanara mantjilku.” Kiyatjalu wanara tjungurrirra Nayamanalara alatji ngunytjilyinu, “Yilatjaluṉi iyaṉu ankulaṉanta alatji watjantjaku, ‘Katutjaku wangka watjalpayi kutjarrapula ngayulakutu kuwarri ngalyankula nyinanyi. Ngayulu yunytjurringanyi panyapa kutjarranya yulytja an mani yungkukitja. Palulanguru yuwara ngayuku waarrkana Kiyatjanya yalatji, puḻi tjiilpa tjawutjuna tjirripala, mantarra yalatjiṯarra kuuta kutjarra, turawutju kutjarra, tjaaṯa kutjarra.’” Nayamanalu kulira yunyparrirra watjaṉu, “Ngaparrtjingkuṉanta yulytja an mani yungku. Puḻi tjiilpa tjawutjuna tjirripala wiya, munkarra nguwanpa tjawutjuna tjikitjipalaṉanta yungku.” Palunyatjanu tjungungkuya Nayamanaku waarrkana kutjarrangku mani palunyaṯarra mantarra katingu, Yilatjaku waaḻakutu. Kiyatjalu pulanya Yilatjaku waaḻangka ila nguwanpa marrkuṉu tjunkula wantinytjaku ngulaku, Yilatjalu nyakutjipingkamarra. Palunya kutjarra pulanya Kiyatjalu piyuku wantirriyaṉu. Kiyatjalu kutjungku katirra yarrkatjunu, waaḻangka ngaṉṯitjayiṯi. Waaḻa palula Kiyatjanya tjarrpangutjangka, Yilatjalu yalatji tjapiṉu, “Nyaalytjikutun yanu?” Kiyatjalu ngunytji watjaṉu, “Ngunytjiṉa yanu, ngamu yulytjayinkukitja.” Yilatjalu watjaṉu, “Kurrunpangkuṉanta nyangu Nayamananya paakitjarra wanaranu marrkuṉutjangka. Tjarukatirranta yungu yulytja an mani. Maniku kutju wiyali kulira mantjintjaku. Nyuntu panyapa tjuṯa mantjiṉutjangka Nayamananya yirriṯi pangki pikatjarra nyinanytja nguwanpa, nyuntulpi pikatjarra nyinaku, nyuntupa katjapiṯi tjamupiṯiṯarra.” Palunyangka Kiyatjanyalpi pangki pikatjarra nyinangi. ");
INSERT INTO piu2006_vpl VALUES ("K28_1","013_8_1","2KI","8","1","29","(8:1—17:41) Yurrunpa Yitjurilaku walytja ngaṉṯitja tjuṯaku mayutju tiṉa Yiyapanya nyinarra wiyarringu. Palumpa katja Yiyatjayanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Tjurumanya tjanampa mayutju tiṉa nyinarra wiyarringu. Palunyatjanu Tjiyuwayatjanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Tjiyuwatjanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Tjiripuma kutjupa tjanampa mayutju tiṉa nyinarra wiyarringu. Palunyatjanu Tjakarriyatjanya tjanampa mayutju tiṉa nyinarra wiyarringu. Palunyatjanu Tjalumanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Minayimanya tjanampa mayutju tiṉa nyinarra wiyarringu. Palunyatjanu Pikayayanya tjanampa mayutju tiṉa nyinarra wiyarringu. Palunyatjanu Pikanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Wutjiyanya mayutju tiṉa nyinangi, Yitjurilaku walytja ngaṉṯitja tjuṯaku. Wutjiyanya mayutju tiṉa nyinanyingka Yatjiriyanya ngurrara tjuṯangku tjananya yalinytjarranguru ngalya yankula pikangku pungkula maḻaku katingu. Paluru tjana yalinytjarra katirra nyinatjunu Yitjurilaku walytja ngaṉṯitja tjuṯa waarrkana tjuṯa nyinanytjaku. Ngurra palula mayutju tiṉangku pikaṯingku kanyiṉingi. Palunyangka yurrunpa Tjuutaku walytja ngaṉṯitja tjuṯaku mayutju tiṉa Tjiyutjapatanya Tjarutjalumangka nyinarra wiyarringu. Palunyatjanu palumpa katja Tjiyuramanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Yiyatjayanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu kungka Yatjalayanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Tjuwatjanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Yamatjayanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Yatjayanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Tjuutjamanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Yiyatjanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Yitjikayanya mayutju tiṉa tjanampa Tjuutaku walytja ngaṉṯitja tjuṯaku nyinangi. Paluru mayutju tiṉa nyinanyingka, Yatjiriyanya ngurrara tjuṯangku tjananya Tjamiriyanya ngurrara tjuṯa yalinytjarra katingu, Yitjurilaku walytja ngaṉṯitja tjuṯa. ");
INSERT INTO piu2006_vpl VALUES ("K29_1","013_9_1","2KI","9","1","37","(8:1—17:41) Yurrunpa Yitjurilaku walytja ngaṉṯitja tjuṯaku mayutju tiṉa Yiyapanya nyinarra wiyarringu. Palumpa katja Yiyatjayanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Tjurumanya tjanampa mayutju tiṉa nyinarra wiyarringu. Palunyatjanu Tjiyuwayatjanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Tjiyuwatjanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Tjiripuma kutjupa tjanampa mayutju tiṉa nyinarra wiyarringu. Palunyatjanu Tjakarriyatjanya tjanampa mayutju tiṉa nyinarra wiyarringu. Palunyatjanu Tjalumanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Minayimanya tjanampa mayutju tiṉa nyinarra wiyarringu. Palunyatjanu Pikayayanya tjanampa mayutju tiṉa nyinarra wiyarringu. Palunyatjanu Pikanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Wutjiyanya mayutju tiṉa nyinangi, Yitjurilaku walytja ngaṉṯitja tjuṯaku. Wutjiyanya mayutju tiṉa nyinanyingka Yatjiriyanya ngurrara tjuṯangku tjananya yalinytjarranguru ngalya yankula pikangku pungkula maḻaku katingu. Paluru tjana yalinytjarra katirra nyinatjunu Yitjurilaku walytja ngaṉṯitja tjuṯa waarrkana tjuṯa nyinanytjaku. Ngurra palula mayutju tiṉangku pikaṯingku kanyiṉingi. Palunyangka yurrunpa Tjuutaku walytja ngaṉṯitja tjuṯaku mayutju tiṉa Tjiyutjapatanya Tjarutjalumangka nyinarra wiyarringu. Palunyatjanu palumpa katja Tjiyuramanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Yiyatjayanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu kungka Yatjalayanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Tjuwatjanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Yamatjayanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Yatjayanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Tjuutjamanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Yiyatjanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Yitjikayanya mayutju tiṉa tjanampa Tjuutaku walytja ngaṉṯitja tjuṯaku nyinangi. Paluru mayutju tiṉa nyinanyingka, Yatjiriyanya ngurrara tjuṯangku tjananya Tjamiriyanya ngurrara tjuṯa yalinytjarra katingu, Yitjurilaku walytja ngaṉṯitja tjuṯa. ");
INSERT INTO piu2006_vpl VALUES ("K210_1","013_10_1","2KI","10","1","36","(8:1—17:41) Yurrunpa Yitjurilaku walytja ngaṉṯitja tjuṯaku mayutju tiṉa Yiyapanya nyinarra wiyarringu. Palumpa katja Yiyatjayanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Tjurumanya tjanampa mayutju tiṉa nyinarra wiyarringu. Palunyatjanu Tjiyuwayatjanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Tjiyuwatjanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Tjiripuma kutjupa tjanampa mayutju tiṉa nyinarra wiyarringu. Palunyatjanu Tjakarriyatjanya tjanampa mayutju tiṉa nyinarra wiyarringu. Palunyatjanu Tjalumanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Minayimanya tjanampa mayutju tiṉa nyinarra wiyarringu. Palunyatjanu Pikayayanya tjanampa mayutju tiṉa nyinarra wiyarringu. Palunyatjanu Pikanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Wutjiyanya mayutju tiṉa nyinangi, Yitjurilaku walytja ngaṉṯitja tjuṯaku. Wutjiyanya mayutju tiṉa nyinanyingka Yatjiriyanya ngurrara tjuṯangku tjananya yalinytjarranguru ngalya yankula pikangku pungkula maḻaku katingu. Paluru tjana yalinytjarra katirra nyinatjunu Yitjurilaku walytja ngaṉṯitja tjuṯa waarrkana tjuṯa nyinanytjaku. Ngurra palula mayutju tiṉangku pikaṯingku kanyiṉingi. Palunyangka yurrunpa Tjuutaku walytja ngaṉṯitja tjuṯaku mayutju tiṉa Tjiyutjapatanya Tjarutjalumangka nyinarra wiyarringu. Palunyatjanu palumpa katja Tjiyuramanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Yiyatjayanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu kungka Yatjalayanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Tjuwatjanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Yamatjayanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Yatjayanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Tjuutjamanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Yiyatjanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Yitjikayanya mayutju tiṉa tjanampa Tjuutaku walytja ngaṉṯitja tjuṯaku nyinangi. Paluru mayutju tiṉa nyinanyingka, Yatjiriyanya ngurrara tjuṯangku tjananya Tjamiriyanya ngurrara tjuṯa yalinytjarra katingu, Yitjurilaku walytja ngaṉṯitja tjuṯa. ");
INSERT INTO piu2006_vpl VALUES ("K211_1","013_11_1","2KI","11","1","21","(8:1—17:41) Yurrunpa Yitjurilaku walytja ngaṉṯitja tjuṯaku mayutju tiṉa Yiyapanya nyinarra wiyarringu. Palumpa katja Yiyatjayanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Tjurumanya tjanampa mayutju tiṉa nyinarra wiyarringu. Palunyatjanu Tjiyuwayatjanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Tjiyuwatjanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Tjiripuma kutjupa tjanampa mayutju tiṉa nyinarra wiyarringu. Palunyatjanu Tjakarriyatjanya tjanampa mayutju tiṉa nyinarra wiyarringu. Palunyatjanu Tjalumanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Minayimanya tjanampa mayutju tiṉa nyinarra wiyarringu. Palunyatjanu Pikayayanya tjanampa mayutju tiṉa nyinarra wiyarringu. Palunyatjanu Pikanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Wutjiyanya mayutju tiṉa nyinangi, Yitjurilaku walytja ngaṉṯitja tjuṯaku. Wutjiyanya mayutju tiṉa nyinanyingka Yatjiriyanya ngurrara tjuṯangku tjananya yalinytjarranguru ngalya yankula pikangku pungkula maḻaku katingu. Paluru tjana yalinytjarra katirra nyinatjunu Yitjurilaku walytja ngaṉṯitja tjuṯa waarrkana tjuṯa nyinanytjaku. Ngurra palula mayutju tiṉangku pikaṯingku kanyiṉingi. Palunyangka yurrunpa Tjuutaku walytja ngaṉṯitja tjuṯaku mayutju tiṉa Tjiyutjapatanya Tjarutjalumangka nyinarra wiyarringu. Palunyatjanu palumpa katja Tjiyuramanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Yiyatjayanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu kungka Yatjalayanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Tjuwatjanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Yamatjayanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Yatjayanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Tjuutjamanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Yiyatjanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Yitjikayanya mayutju tiṉa tjanampa Tjuutaku walytja ngaṉṯitja tjuṯaku nyinangi. Paluru mayutju tiṉa nyinanyingka, Yatjiriyanya ngurrara tjuṯangku tjananya Tjamiriyanya ngurrara tjuṯa yalinytjarra katingu, Yitjurilaku walytja ngaṉṯitja tjuṯa. ");
INSERT INTO piu2006_vpl VALUES ("K212_1","013_12_1","2KI","12","1","21","(8:1—17:41) Yurrunpa Yitjurilaku walytja ngaṉṯitja tjuṯaku mayutju tiṉa Yiyapanya nyinarra wiyarringu. Palumpa katja Yiyatjayanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Tjurumanya tjanampa mayutju tiṉa nyinarra wiyarringu. Palunyatjanu Tjiyuwayatjanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Tjiyuwatjanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Tjiripuma kutjupa tjanampa mayutju tiṉa nyinarra wiyarringu. Palunyatjanu Tjakarriyatjanya tjanampa mayutju tiṉa nyinarra wiyarringu. Palunyatjanu Tjalumanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Minayimanya tjanampa mayutju tiṉa nyinarra wiyarringu. Palunyatjanu Pikayayanya tjanampa mayutju tiṉa nyinarra wiyarringu. Palunyatjanu Pikanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Wutjiyanya mayutju tiṉa nyinangi, Yitjurilaku walytja ngaṉṯitja tjuṯaku. Wutjiyanya mayutju tiṉa nyinanyingka Yatjiriyanya ngurrara tjuṯangku tjananya yalinytjarranguru ngalya yankula pikangku pungkula maḻaku katingu. Paluru tjana yalinytjarra katirra nyinatjunu Yitjurilaku walytja ngaṉṯitja tjuṯa waarrkana tjuṯa nyinanytjaku. Ngurra palula mayutju tiṉangku pikaṯingku kanyiṉingi. Palunyangka yurrunpa Tjuutaku walytja ngaṉṯitja tjuṯaku mayutju tiṉa Tjiyutjapatanya Tjarutjalumangka nyinarra wiyarringu. Palunyatjanu palumpa katja Tjiyuramanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Yiyatjayanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu kungka Yatjalayanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Tjuwatjanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Yamatjayanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Yatjayanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Tjuutjamanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Yiyatjanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Yitjikayanya mayutju tiṉa tjanampa Tjuutaku walytja ngaṉṯitja tjuṯaku nyinangi. Paluru mayutju tiṉa nyinanyingka, Yatjiriyanya ngurrara tjuṯangku tjananya Tjamiriyanya ngurrara tjuṯa yalinytjarra katingu, Yitjurilaku walytja ngaṉṯitja tjuṯa. ");
INSERT INTO piu2006_vpl VALUES ("K213_1","013_13_1","2KI","13","1","25","(8:1—17:41) Yurrunpa Yitjurilaku walytja ngaṉṯitja tjuṯaku mayutju tiṉa Yiyapanya nyinarra wiyarringu. Palumpa katja Yiyatjayanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Tjurumanya tjanampa mayutju tiṉa nyinarra wiyarringu. Palunyatjanu Tjiyuwayatjanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Tjiyuwatjanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Tjiripuma kutjupa tjanampa mayutju tiṉa nyinarra wiyarringu. Palunyatjanu Tjakarriyatjanya tjanampa mayutju tiṉa nyinarra wiyarringu. Palunyatjanu Tjalumanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Minayimanya tjanampa mayutju tiṉa nyinarra wiyarringu. Palunyatjanu Pikayayanya tjanampa mayutju tiṉa nyinarra wiyarringu. Palunyatjanu Pikanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Wutjiyanya mayutju tiṉa nyinangi, Yitjurilaku walytja ngaṉṯitja tjuṯaku. Wutjiyanya mayutju tiṉa nyinanyingka Yatjiriyanya ngurrara tjuṯangku tjananya yalinytjarranguru ngalya yankula pikangku pungkula maḻaku katingu. Paluru tjana yalinytjarra katirra nyinatjunu Yitjurilaku walytja ngaṉṯitja tjuṯa waarrkana tjuṯa nyinanytjaku. Ngurra palula mayutju tiṉangku pikaṯingku kanyiṉingi. Palunyangka yurrunpa Tjuutaku walytja ngaṉṯitja tjuṯaku mayutju tiṉa Tjiyutjapatanya Tjarutjalumangka nyinarra wiyarringu. Palunyatjanu palumpa katja Tjiyuramanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Yiyatjayanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu kungka Yatjalayanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Tjuwatjanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Yamatjayanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Yatjayanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Tjuutjamanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Yiyatjanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Yitjikayanya mayutju tiṉa tjanampa Tjuutaku walytja ngaṉṯitja tjuṯaku nyinangi. Paluru mayutju tiṉa nyinanyingka, Yatjiriyanya ngurrara tjuṯangku tjananya Tjamiriyanya ngurrara tjuṯa yalinytjarra katingu, Yitjurilaku walytja ngaṉṯitja tjuṯa. ");
INSERT INTO piu2006_vpl VALUES ("K214_1","013_14_1","2KI","14","1","29","(8:1—17:41) Yurrunpa Yitjurilaku walytja ngaṉṯitja tjuṯaku mayutju tiṉa Yiyapanya nyinarra wiyarringu. Palumpa katja Yiyatjayanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Tjurumanya tjanampa mayutju tiṉa nyinarra wiyarringu. Palunyatjanu Tjiyuwayatjanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Tjiyuwatjanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Tjiripuma kutjupa tjanampa mayutju tiṉa nyinarra wiyarringu. Palunyatjanu Tjakarriyatjanya tjanampa mayutju tiṉa nyinarra wiyarringu. Palunyatjanu Tjalumanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Minayimanya tjanampa mayutju tiṉa nyinarra wiyarringu. Palunyatjanu Pikayayanya tjanampa mayutju tiṉa nyinarra wiyarringu. Palunyatjanu Pikanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Wutjiyanya mayutju tiṉa nyinangi, Yitjurilaku walytja ngaṉṯitja tjuṯaku. Wutjiyanya mayutju tiṉa nyinanyingka Yatjiriyanya ngurrara tjuṯangku tjananya yalinytjarranguru ngalya yankula pikangku pungkula maḻaku katingu. Paluru tjana yalinytjarra katirra nyinatjunu Yitjurilaku walytja ngaṉṯitja tjuṯa waarrkana tjuṯa nyinanytjaku. Ngurra palula mayutju tiṉangku pikaṯingku kanyiṉingi. Palunyangka yurrunpa Tjuutaku walytja ngaṉṯitja tjuṯaku mayutju tiṉa Tjiyutjapatanya Tjarutjalumangka nyinarra wiyarringu. Palunyatjanu palumpa katja Tjiyuramanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Yiyatjayanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu kungka Yatjalayanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Tjuwatjanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Yamatjayanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Yatjayanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Tjuutjamanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Yiyatjanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Yitjikayanya mayutju tiṉa tjanampa Tjuutaku walytja ngaṉṯitja tjuṯaku nyinangi. Paluru mayutju tiṉa nyinanyingka, Yatjiriyanya ngurrara tjuṯangku tjananya Tjamiriyanya ngurrara tjuṯa yalinytjarra katingu, Yitjurilaku walytja ngaṉṯitja tjuṯa. ");
INSERT INTO piu2006_vpl VALUES ("K215_8","013_15_8","2KI","15","8","31","Mayutju tiṉa Yatjarayanya tjanampa Tjuutaku walytja ngaṉṯitja tjuṯaku nyinangi, kanya tjanampa Yitjurilaku walytja ngaṉṯitja tjuṯaku mayutju tiṉa kutjupa nyinangi, yini Tjakarriyatjanya. Tjakarriyatjanya Katutjaku tjukarurruwiya nyinangi. Pira tjikitjipala mayutju tiṉa tjanampa nyinanyingka, wati Tjalumalu mayutju nyinakitjangku mirri pungu. Wati Tjalumanya tjanampa mayutju tiṉa pira kutju nyinanyingka wati kutjupangku Minayimalu mirri pungu, mayutju nyinakitjangku. Minayimanya Katutjaku wiya tjukarurru nyinangi. Yiiya tiinpala wiyawana nyinarra wiyarringu. Palunyatjanu palumpa katja Pikayayanya mayutju tiṉa tjanampa Yitjurilaku walytja ngaṉṯitja tjuṯaku nyinangi, yalinytjarra ngurrara tjuṯaku. Pikayayanya tjanampa mayutju tiṉa nyinarra wiyawana nyinangi, Katutjaku tjukarurru nyinanytjawiya. Yiiya kutjarra nyinanyingka wati kutjupangku yini Pikalu mirri pungu, mayutju nyinakitjangku. Pikanya Katutjaku tjukarurru nyinanytjawiya, wiyawana nyinangi. Yalatji yiiya tuuntiyipala nyinanyingka wati kutjupangku Wutjiyalu mirri pungu, mayutju nyinakitjangku. Wutjiyanya tjanampa mayutju tiṉa nyinarra wiyarringu. Wati paluru wiya Katutjaku tjukarurru nyinangi. Paluru tjanampa Yitjurilaku walytja ngaṉṯitja tjuṯaku mayutju nyinangi yiiya nayinpala nguwanpa. ");
INSERT INTO piu2006_vpl VALUES ("K216_1","013_16_1","2KI","16","1","20","(8:1—17:41) Yurrunpa Yitjurilaku walytja ngaṉṯitja tjuṯaku mayutju tiṉa Yiyapanya nyinarra wiyarringu. Palumpa katja Yiyatjayanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Tjurumanya tjanampa mayutju tiṉa nyinarra wiyarringu. Palunyatjanu Tjiyuwayatjanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Tjiyuwatjanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Tjiripuma kutjupa tjanampa mayutju tiṉa nyinarra wiyarringu. Palunyatjanu Tjakarriyatjanya tjanampa mayutju tiṉa nyinarra wiyarringu. Palunyatjanu Tjalumanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Minayimanya tjanampa mayutju tiṉa nyinarra wiyarringu. Palunyatjanu Pikayayanya tjanampa mayutju tiṉa nyinarra wiyarringu. Palunyatjanu Pikanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Wutjiyanya mayutju tiṉa nyinangi, Yitjurilaku walytja ngaṉṯitja tjuṯaku. Wutjiyanya mayutju tiṉa nyinanyingka Yatjiriyanya ngurrara tjuṯangku tjananya yalinytjarranguru ngalya yankula pikangku pungkula maḻaku katingu. Paluru tjana yalinytjarra katirra nyinatjunu Yitjurilaku walytja ngaṉṯitja tjuṯa waarrkana tjuṯa nyinanytjaku. Ngurra palula mayutju tiṉangku pikaṯingku kanyiṉingi. Palunyangka yurrunpa Tjuutaku walytja ngaṉṯitja tjuṯaku mayutju tiṉa Tjiyutjapatanya Tjarutjalumangka nyinarra wiyarringu. Palunyatjanu palumpa katja Tjiyuramanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Yiyatjayanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu kungka Yatjalayanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Tjuwatjanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Yamatjayanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Yatjayanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Tjuutjamanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Yiyatjanya mayutju tiṉa tjanampa nyinarra wiyarringu. Palunyatjanu Yitjikayanya mayutju tiṉa tjanampa Tjuutaku walytja ngaṉṯitja tjuṯaku nyinangi. Paluru mayutju tiṉa nyinanyingka, Yatjiriyanya ngurrara tjuṯangku tjananya Tjamiriyanya ngurrara tjuṯa yalinytjarra katingu, Yitjurilaku walytja ngaṉṯitja tjuṯa. ");
INSERT INTO piu2006_vpl VALUES ("K217_5","013_17_5","2KI","17","5","12","Wutjiyanya mayutju tiṉa tjanampa Yitjurilaku walytja ngaṉṯitja tjuṯaku nyinanyingka Yatjiriyanya ngurrara tjuṯa tawunu Tjamiriyalakutu ngalya yanu, pikangku tjananya pungkukitja. Yatjiriyanya ngurrara tjilirratjarra tjuṯaku mayutju yini Tjalmanitjanya nyinangi. Tawunu Tjamiriyanya waaḻa tjuṯangka ilawana parriki tiṉa ngarangi. Parriki paluru waaḻa palunya tjuṯanya ngururrtjunkula, kiiṯa kutjarratjarra ngarangi. Tjamiriyanya ngurrara tjuṯangkuya kiiṯa palunya unnguwanangku patira taayitinu, Yatjiriyanya ngurrara tjuṯangku tjarrparra mirri pungkutjipingkamarra. Yalatjiya yiiya tjirripala unngu nyinangi, Yatjiriyanya ngurrara tjilirratjarra tjuṯa aatjayiṯi nyinarra waṉipayi, unngunguruya pakara tjalkaḻungkutjipingkamarra. Palunyatjanu tjilirratjarra tjuṯangkuya kiiṯa kilytjuntankula tjarrparra pikangku tjananya pungu. Kutjupa tjuṯa tjananya tjanaya witiṉingi nguḻu tjalkaḻungkutjipingkamarra. Witira tjananya kanyiṉingi Yitjurilaku walytja ngaṉṯitja tjuṯa, tjanampaṉu mayutju tiṉaṯarra. Paluru tjana kanyira tjananya katingu yalinytjarra ngurra kutjupakutu waarrkana tjuṯalpiya nyinanytjaku. Tawunu tjuṯangka yalinytjarra tjananya kanyiṉingi Yatjiriyanya ngurrara tjuṯaku ngurra walytjangka. Paluru tjana waarrkana tjuṯa tjananya Yitjurilaku walytja ngaṉṯitja tjuṯa kanyiṉingi ngurra walytjakutuya maḻaku yankutjipingkamarra. Yalatji Katutjalu tjananya Yitjurilaku walytja ngaṉṯitja tjuṯa payira wantirriyaṉu ngurra walytjangkaya kutungku kuya palyaṉingka. Katutjanya nguwanpa tjuṯa tjananya tjanaya Yatjaranya, Paalanyaṯarra puḻkapungkupayi, Katutjanya yilta wantirra. Palunyatjanu Katutjalu tjananya ngurra walytjanguru wantirriyaṉu ngurra kutjupakutu yitjipungkunytjakitjangku. ");
INSERT INTO piu2006_vpl VALUES ("K217_24","013_17_24","2KI","17","24","41","Yatjiriyanya ngurrara tjuṯaku mayutju tiṉangku tjananya kutjupa ngurrara tjuṯa watjaṉu tawunu Tjamiriyangkalpiya yankula nyinanytjaku, tawunu kutjupa tjuṯangkaṯarraya yankula nyinanytjaku, Tjamiriyangka yila ngaranytja tjuṯangka. Palunyatjanu kutjupa ngurrara tjuṯaya yalatjiya tawunu Tjamiriyangka nyinangi, Papilunanya ngurrara tjuṯa, Kuutjanya ngurrara tjuṯa, Yipanya ngurrara tjuṯa, Yamatjanya ngurrara tjuṯa, Tjiparamanya ngurrara tjuṯaṯarra. Tjamiriyangka ilawanaya tawunu kutjupa tjuṯawanaṯarraya nyinarra waṉingi, kanyaya Yitjurilaku walytja ngaṉṯitja tjuṯa yalinytjarra waṉmaya waarrkana nyinangi. Paluru tjanaya tawunu tjuṯawana nyinangi, Tjamiriyangka, yilawana. Tjana wiya Katutjanya puḻkapungkupayi. Palunyatjanu Katutjalu tjananya layina tjikipaka tjuṯa wantirriyaṉu patjara yiluntankunytjaku tjananya. Palunyatjanulpiya kuliṉu paṉa palunyaku mayutju tiṉa Katutjanya nyinangi. Palunyatjanu Yatjiriyanya ngurrara tjuṯaku mayutju tiṉangku Yitjurilaku walytja ngaṉṯitja kutju Tjamiriyalakutu wantirriyaṉu. Wati paluru Katutjaku tuḻkuku mayutju tiṉa nyinangi. Wati palunya mayutju paluru watjaṉu yankula Katutjaku wangka tjananya nintintjaku. Paluru tjananya yankula puṯu nintiṉingi. Katutjanyaya puḻkapungkula Katutjanya nguwanpa kutjupa tjuṯaṯarraya puḻkapungangi, Katutjanya kutju tjukarurru puḻkapungkuwiyangku. ");
INSERT INTO piu2006_vpl VALUES ("K218_1","013_18_1","2KI","18","1","12","Mayutju Yitjikayanya Katutjaku tjukarurru nyinangi, mayutju Tapitanya tjukarurru nyinangutja nguwanpa. Palunyangka yaṉangu tjuṯangku Katutjanya nguwanpa tjuṯa waḻkulpayi Yatjaranya Paalanyaṯarra. Mayutju Yitjikayalu tjananya palumpa waarrkana tjuṯa watjaṉu, yankulaya Yatjaranya Paalanyaṯarra yuḻpura wiyantjaku, yaṉangu tjuṯangku tjanaya waḻkultjipingkamarra. Yitjikayanya yalatji Katutjaku wangkaku tjukarurru nyinanytjala, Katutjalu yaṉṯayaṉṯalpayi. Palumpa waarrkana tjilirratjarra tjuṯangku tjananya palya pungkula wantirriyaṉu Pilitjiyanya ngurrara tjuṯa, kutjupa tjuṯaṯarra, Katutjalu tjananya yaṉṯayaṉṯantjala. Palulanguru Yatjiriyanya ngurrara tjuṯaku mayutju tiṉangku watjaṉu Yitjikayanyangarri palumpa waarrkana tjuṯa nyinanytjaku, mirri pungkuwiyangku wantirra. Mayutju Katutjalu Yitjikayanya rapantjala paluru wiya watjara wantingu, waarrkana nyinakitja kulilwiyangku. Tjuutaku walytja ngaṉṯitja tjuṯaku mayutju tiṉa Yitjikayanya yiiya puupala nyinangi. Palunyatjanu Yatjiriyanya ngurrara tjuṯa tjilirratjarra yanu, tawunu Tjamiriyanya ngurrara tjuṯa pungkukitja. Ngalya yankula tjananya pikangku pungu, ngurra kanyilkitjangku. Yitjurilaku walytja ngaṉṯitja tjuṯaku tawunu tjuṯa mantjilkitjangku tjanaya pikangku pungkupayi. Mirri pungkula tjananya kutjupa tjuṯa kanyiṉingi tawunu Tjamiriyala. Yirriṯi tawunu palula parriki tiṉa tjuṯaya parra tjunangi nganytjalpa. Ngururrpa Tjamiriyanya ngurrara tjuṯa nyinangi. Rawangku tjananya Yatjiriyanya ngurrara tjuṯangku ngururrtjunkula tawunu palula kanyiṉingi yiiya tjirripala, Tjamiriyanya ngurrara tjuṯa pakara tjalkaḻungkutjipingka. Yalatji tjananya kanyira watiya tiṉatjarrangku kiiṯa kilytjuntankula tawunu Tjamiriyangkalpiya tjarrpangu. Tjarrparraya tawunu tjanampa yuḻpuraya kilytjuntanu. Yalinytjarralpi tjananya katingu ngurra palula waarrkana tjuṯaya nyinanytjaku. Yalatjiya Yitjurilaku walytja ngaṉṯitja tjuṯa ngurra palula waarrkarrirraya nyinangi, Katutjakuya tjukarurru nyinangutja wiya, Katutjaku wangkaya kulira wantipayi. Palulanguru Tjuutaku walytja ngaṉṯitja tjuṯa tjananya Yitjikayalu palya kanyiṉingi tawunu Tjarutjalumangka. ");
INSERT INTO piu2006_vpl VALUES ("K218_13","013_18_13","2KI","18","13","37","(18:13-37; 19:1-34) Yitjikayanya tjanampa Tjuutaku walytja ngaṉṯitja tjuṯaku mayutju tiṉa yiiya puutinpala nyinangi. Palulanguru Yatjiriyanya ngurrara tjuṯa tjilirratjarra yanu, Yitjikayanyangarri tjananya pungkukitja. Yitjikayaku waarrkana tjuṯa tjananya yankula Tjarutjalumangka yalinytjarra mirri pungangi. Tjarutjalumalawana piyuku mirri pungkupayingkamarra Yitjikayalu Yatjiriyanya ngurrara mayutju tiṉa palulakutu waarrkana wantirriyaṉu yalatji tjapintjaku, “Nyaapaṉanta yungkunytjaku nyuntu yunytjurringanyi? Nyuntuṉin tjapintjala ngayuluṉanta yungku mani kuulta tiṉa ngayuku waarrkana tjuṯa tjananya pungkutjipingkamarra.” Mayutju paluru Yitjikayanya tjapiṉu puḻi kuulta tiṉaku, puḻi tjiilpa tiṉakuṯarra. Kanarrikitjangku Yitjikayalu puḻi kuulta puḻi tjiilpa tiṉanya tjaatji tiṉangka yarralytjankula mantjiṉu. Mantjira wantirriyaṉu mayutju palulakutu. Puṯu tjanampa kuulta tjuṯa wantirriyaṉu. Yatjiriyanya ngurrara tjuṯangkuya yankula tawunu Tjarutjalumanya ngururrtjunu, tjilirratjarra tjuṯalingkungku. Yitjikayanya palumpa waarrkana tjuṯaṯarra yurrunpa parriki tiṉangka yunngu tjarrparra kiiṯa tjuṯa patiṉu. Yirriṯi tawunu palula parriki tiṉa tjuṯa tjanaya parra tjunangi nganytjalpa. Ngururrpa Tjarutjalumanya ngurrara tjuṯa nyinangi. Yatjiriyanya ngurrara kutjungku mayutju tiṉangku Tjarutjalumangka tjayiṯingka ngarala nguḻultjingalkitjangku tjananya yalatjingku watjaṉu, “Mayutju nyurrampa Yitjikayanya mungutja nyinanyi. Palumpa wangka kulintjawiyangkuya wanti! Puṯu nyurranya kuwarri kanalku. Kuwarrilpi nganaṉatju parrikingka tjarrparra nyurrangarrinya mirri pungku, tjilirratjarra tjuṯangku. Nyurrangarrimpa mayutju tiṉangku nyurranya Katutjalu puṯu kanalku. Nganaṉatju nyurrangarrinya mirri pungkupayingkamarra kiiṯa yalytjurankulaya ngalya yankulaya tjungu ngara!, waarrkana tjuṯalampatju kana nyinakitja.” Yaṉangu tjuṯangku Tjarutjalumanya ngurrara tjuṯangku parrikingka katu nyinarraya wangka palunya kuliṉingi wangkawiyangku, mayutju Yitjikayalu tjananya yurrunpa watjaṉutjangka. Mayutju Yitjikayalu nguḻurringkula waarrkana kutju wantirriyaṉu wati Yaatjayalakutu, Katutjaku wangka watjalpayilakutu, yankula tjapintjaku. Waarrkanaku wangka Yaatjayalu kulira waarrkana kutjupa wantirriyaṉu mayutju Yitjikayalakutu, yalatji tjakultjunkunytjaku, “Mayutju Katutjalunta yalatji watjaṉu. Yatjiriyanya ngurrara tjuṯaku tjanampa nyuntu wiya nguḻurringkunytjaku. Ngayuluṉa wiyawanangku nintintjala Yatjiriyanya ngurrara mayutju tiṉa palunya, ngurra walytjakutu rayitpayiki yanku, palumpa tjilirratjarra tjuṯaṯarra. Ngurra palula kutjupangku mayutju palunya mirri pungku.” Piyuku tjananya nguḻutjingalkitjangku Yatjiriyanya ngurrara tjuṯaku mayutjungku piipa wakara Yitjikayalakutu wantirriyaṉu. Yitjikayalu piipa palunya mantjira riitarrirra Katutjaku tjaatji tiṉakutu katirra tjunkula yutitjanu Katutjalu nyakunytjaku. Yalatji tjunkula pilara Katutjala tjapiṉu Tjarutjalumanya ngurrara tjuṯa tjananya mirri pungkutjipingkamarra. Palunyatjanu Katutjaku wangka watjalpayingku Yaatjayalu waarrkana wantirriyaṉu Yitjikayalakutu yalatji wangkanytjaku, “Nyuntunu Katutjanya panyapa tjapintjala, Katutjalunta alatji watjaṉi, ‘Yatjiriyanya ngurrara tjuṯangkuṉiya wiyawanangku panypurangkupayi. Yiltaṉa nyurrangarrinya watjaṉi. Tjanaya Yatjiriyanya ngurrara tjuṯangku wiya Tjarutjalumangka tjarrparra nyurrangarrinya mirri pungku, wantirra nyurranya ngurra walytjakutuya rayitpayiki yanku.’” ");
INSERT INTO piu2006_vpl VALUES ("K219_1","013_19_1","2KI","19","1","34","(18:13-37; 19:1-34) Yitjikayanya tjanampa Tjuutaku walytja ngaṉṯitja tjuṯaku mayutju tiṉa yiiya puutinpala nyinangi. Palulanguru Yatjiriyanya ngurrara tjuṯa tjilirratjarra yanu, Yitjikayanyangarri tjananya pungkukitja. Yitjikayaku waarrkana tjuṯa tjananya yankula Tjarutjalumangka yalinytjarra mirri pungangi. Tjarutjalumalawana piyuku mirri pungkupayingkamarra Yitjikayalu Yatjiriyanya ngurrara mayutju tiṉa palulakutu waarrkana wantirriyaṉu yalatji tjapintjaku, “Nyaapaṉanta yungkunytjaku nyuntu yunytjurringanyi? Nyuntuṉin tjapintjala ngayuluṉanta yungku mani kuulta tiṉa ngayuku waarrkana tjuṯa tjananya pungkutjipingkamarra.” Mayutju paluru Yitjikayanya tjapiṉu puḻi kuulta tiṉaku, puḻi tjiilpa tiṉakuṯarra. Kanarrikitjangku Yitjikayalu puḻi kuulta puḻi tjiilpa tiṉanya tjaatji tiṉangka yarralytjankula mantjiṉu. Mantjira wantirriyaṉu mayutju palulakutu. Puṯu tjanampa kuulta tjuṯa wantirriyaṉu. Yatjiriyanya ngurrara tjuṯangkuya yankula tawunu Tjarutjalumanya ngururrtjunu, tjilirratjarra tjuṯalingkungku. Yitjikayanya palumpa waarrkana tjuṯaṯarra yurrunpa parriki tiṉangka yunngu tjarrparra kiiṯa tjuṯa patiṉu. Yirriṯi tawunu palula parriki tiṉa tjuṯa tjanaya parra tjunangi nganytjalpa. Ngururrpa Tjarutjalumanya ngurrara tjuṯa nyinangi. Yatjiriyanya ngurrara kutjungku mayutju tiṉangku Tjarutjalumangka tjayiṯingka ngarala nguḻultjingalkitjangku tjananya yalatjingku watjaṉu, “Mayutju nyurrampa Yitjikayanya mungutja nyinanyi. Palumpa wangka kulintjawiyangkuya wanti! Puṯu nyurranya kuwarri kanalku. Kuwarrilpi nganaṉatju parrikingka tjarrparra nyurrangarrinya mirri pungku, tjilirratjarra tjuṯangku. Nyurrangarrimpa mayutju tiṉangku nyurranya Katutjalu puṯu kanalku. Nganaṉatju nyurrangarrinya mirri pungkupayingkamarra kiiṯa yalytjurankulaya ngalya yankulaya tjungu ngara!, waarrkana tjuṯalampatju kana nyinakitja.” Yaṉangu tjuṯangku Tjarutjalumanya ngurrara tjuṯangku parrikingka katu nyinarraya wangka palunya kuliṉingi wangkawiyangku, mayutju Yitjikayalu tjananya yurrunpa watjaṉutjangka. Mayutju Yitjikayalu nguḻurringkula waarrkana kutju wantirriyaṉu wati Yaatjayalakutu, Katutjaku wangka watjalpayilakutu, yankula tjapintjaku. Waarrkanaku wangka Yaatjayalu kulira waarrkana kutjupa wantirriyaṉu mayutju Yitjikayalakutu, yalatji tjakultjunkunytjaku, “Mayutju Katutjalunta yalatji watjaṉu. Yatjiriyanya ngurrara tjuṯaku tjanampa nyuntu wiya nguḻurringkunytjaku. Ngayuluṉa wiyawanangku nintintjala Yatjiriyanya ngurrara mayutju tiṉa palunya, ngurra walytjakutu rayitpayiki yanku, palumpa tjilirratjarra tjuṯaṯarra. Ngurra palula kutjupangku mayutju palunya mirri pungku.” Piyuku tjananya nguḻutjingalkitjangku Yatjiriyanya ngurrara tjuṯaku mayutjungku piipa wakara Yitjikayalakutu wantirriyaṉu. Yitjikayalu piipa palunya mantjira riitarrirra Katutjaku tjaatji tiṉakutu katirra tjunkula yutitjanu Katutjalu nyakunytjaku. Yalatji tjunkula pilara Katutjala tjapiṉu Tjarutjalumanya ngurrara tjuṯa tjananya mirri pungkutjipingkamarra. Palunyatjanu Katutjaku wangka watjalpayingku Yaatjayalu waarrkana wantirriyaṉu Yitjikayalakutu yalatji wangkanytjaku, “Nyuntunu Katutjanya panyapa tjapintjala, Katutjalunta alatji watjaṉi, ‘Yatjiriyanya ngurrara tjuṯangkuṉiya wiyawanangku panypurangkupayi. Yiltaṉa nyurrangarrinya watjaṉi. Tjanaya Yatjiriyanya ngurrara tjuṯangku wiya Tjarutjalumangka tjarrparra nyurrangarrinya mirri pungku, wantirra nyurranya ngurra walytjakutuya rayitpayiki yanku.’” ");
INSERT INTO piu2006_vpl VALUES ("K219_35","013_19_35","2KI","19","35","37","Palunyatjanu mungangka tjananya Katutjaku waarrkana ilkari ngurrarangku tjarukatirra Yatjiriyanya ngurrara tjuṯanya mirri pungu. Mirri tjuṯalingkuya ngarrirra waṉingi waan yantaṯan yiitiyi tjawutjuna. Tawunu Tjarutjalumangka tjayiṯingkaya ngarrirra waṉingi. Palunyatjanu tjilirratjarra kutjupa tjuṯaya pakara nguḻu tjalkaḻungu ngurra walytjakutu, tawunu Ninapalakutu. Palunyatjanu Yatjiriyaku mayutju tiṉangku paapa Katutjanya nguwanpa waḻkuntjala, palumpa katja kutjarrangkupula yunytjuwiyarringkula tjuuḻa waṯawaratjarrangku wakara mirrintanu. ");
INSERT INTO piu2006_vpl VALUES ("K220_1","013_20_1","2KI","20","1","12","Palunyatjanu mayutju Yitjikayanya pika punturringkula ngarringi. Katutjaku wangka watjalpayi Yaatjayalu ankula Yitjikayala alatji Katutjaku wangka tjakultjunu, “Mayutju Katutjalunta watjaṉu alatji. Pikatjarranu ngarrirra yilta kuwarrinu mirrirriku. Kutjupangku tjananya watjalku nyuntupa yulytjaya mantjintjaku.” Mayutju Yitjikayalu kulira yuṯurringkula yulangi. Palunyatjanu Yaatjayanya yanu. Yitjikayalu yularra watjilpangku Katutjanya yalatji tjapiṉu mirrirritjipingkamarra, “Mayutju Katutja. Kulilaṉi! Wiyaṉa yunytjurringanyi mirrirrikitja. Ngayuluṉanta tjukarurrungku palyalpayi. Nyuntu yunytjurringkula watjantjala ngayuluṉanta tjukarurrungku palyalpayi. Nyuntupaṉanta tjukarurru nyinakitjangkuṉa kulira nyinapayi.” Yalatji tjapira piyuku yulangi. Yaatjayalu Yitjikayanya wantirra yankula waaḻangka tjayiṯingka yankunytjala mayutju Katutjalu yalatji watjaṉu, “Rayitpayiki yankula Yitjikayangka yalatji tjakultjurra! Mayutju Katutjaluṉanta kuliṉu nyuntunu mirrirritjipingkamarra kuwarri tjapintjala. Kuwarriṉanta palyalku. Tjiṉṯu tjirripalangka ngarrirranu palya pakara yanku ngayuku tjaatjikutu. Yalatjiṉanta kanantjala yiiya pipitinpala kutjunu nyinarra mirrirriku.” Alatji Yaatjayalu Yitjikayangka tjakultjunkula palumpa waarrkana tjuṯangka tjananya watjaṉu mirritjina palyantjaku, witjirrkingka palyara mirritjinangka Yitjikayanya nyapantjaku. Yitjikayalu Katutjaku wangka palunya kulira alatji kuliṉulpi, “Tjinguruṉa kanarriku, tjinguru wiya.” Alatji kulira Yaatjayanya yalatji tjapiṉu, “Tjinguruṉa piyuku kana nyinaku, tjinguru wiya. Yunytjurringanyiṉa Katutjaluṉi piyuku nintintjaku.” Piyukupula wangkarra Yaatjayalu Katutjanya tjapintjala, Katutjalu watjaṉu tjiṉṯu rayitpayiki kakarrarakutu yankunytjaku, wiima wiyakutju. Tjiṉṯu yalatji panyapawana yankunytjala, wilytja rayitpayiki yanu. Yitjikayalu wilytja rayitpayiki yankunytjala nyakula kuliṉu, “Yilta. Katutjalu wilytja rayitpayiki wantirriyaṉu, ngayunya nintilkitjangku. Yiltaṉa palyarriku.” ");
INSERT INTO piu2006_vpl VALUES ("K220_13","013_20_13","2KI","20","13","21","Palunyatjanu mayutju tiṉangku Papilunanya ngurrarangku waarrkana tjirripala wantirriyaṉu, Yitjikayalakutu munytjangku yungkunytjaku. Paluru mantjira yunyparringu. Palunyatjanu Yitjikayalu tjananya palunya tjirripala Tjarutjalumalawana katirra tjananya parra nintiṉangi. Alatji tjananya katirra tjaatji tiṉangka nintiṉu mani tiṉa an kuulta tjuṯa ngarrinytjala. Palunyatjanu Yaatjayalu tjakulpa kulira Yitjikayanyalpi Katutjaku wangka alatji tjakultjunu, “Nyuntu tjananya Papilunanya ngurrara tjuṯa nintintjawiyangku wantimara. Ngula, nyuntupa katja tjuṯa yuṉṯalpa tjuṯa Papilunanya ngurrara tjuṯangku tjananya pikangku pungkula rayitpayiki katiku tawunu Papilunalakutu, palunya ngurrara tjuṯaku waarrkanaya nyinanytjaku.” Mayutju Yitjikayanya yiiya pipitinpala nyinarra mirrirringu. Palumpa katja Manatjanya mayutju tiṉalpi tjanampa Tjuutaku ngaṉṯitja tjuṯaku nyinangi. ");
INSERT INTO piu2006_vpl VALUES ("K221_1","013_21_1","2KI","21","1","1","(18:; 21:) Tjuutaku walytja ngaṉṯitja tjuṯaku mayutju tiṉa Yitjikayanya rawa yiiya tuuntiyi nayinpala nyinarra mirrirringu. Palulanguru palumpa katja Manatjanya mayutju tiṉa tjanampa nyinangi. Paluru tjananya tjingapungu Katutjanya nguwanpa tjuṯa piyuku palyara ngaratjunkunytjaku. Manatjalungarri palunya tjuṯa waḻkura tjukarurruwiya nyinangi. Yiiya pipitiyi payipala mayutju tjanampa nyinarra mirrirringu. Palunyatjanu palumpa katja Yamananya nyinangi. Katutjanya nguwanpa tjuṯa waḻkura paluru Katutjaku tjukarurruwiya nyinangi. Yiiya kutjarra nyinangutja palumpa waarrkana tjuṯangku mirri pungu. Pungkupayi palunya tjuṯa tjananya Tjuutaku walytja ngaṉṯitja tjuṯangku ngaparrtjingku mirri pungu. Paluru tjana Tjutjayanya Yamanaku katja mayutju tiṉa nyinatjunu. Tjutjayalu Katutjanya tjukarurru nyinarra waḻkuṉingi, kutjupa tjuṯa waḻkuntjawiyangku. Mayutju tjanampa yiiya tjaatiyi waan nyinarra pikakutu paluru yanu. Pika palula kutjupa ngurrara tjuṯangku mirrintanu. Palulanguruya Tjuutaku walytja ngaṉṯitja tjuṯangku palumpa katja Tjiyuwatjanya mayutju tiṉa nyinatjunu. Tjiyuwatjanya Katutjaku tjukarurruwiya nyinangi. Mayutju tiṉa tjanampa pira tjirripala nyinanytjala Yitjipinya ngurrara tjuṯangku palunya witira tjiilangka tjarrpatjunu. Palulanguru tjana palunya manta Yitjipilakutu katingu. Paluru ngurra palula nyinarra mirrirringu. Tjutjayanya mirrirrinytjala Yitjipiku mayutju tiṉangku Tjutjayaku katja Yilayakimanya mayutju tiṉa tjanampa nyinatjunu, Tjuutaku walytja ngaṉṯitja tjuṯaku. Nyinatjunkula yini kutjupa watjaṉu yalatji, Tjiyuyakimanya. Paluru Katutjaku tjukarurruwiya nyinangi. Yiiya lipinpala mayutju tiṉa tjanampa nyinanytjala Yitjipinya ngurrara tjuṯangku palunya witira tjiilangka tjarrpatjunu. Palulanguru tjana palunya ngurra Yitjipilakutu katingu. Ngurra palula nyinarra paluru mirrirringu. Palunyatjanu palumpa katja Tjiyuyatjinanya tjanampa mayutju tiṉa nyinangi. Katutjaku tjukarurruwiya pira tjirripala nyinangu. Palulanguru Papilunanya ngurrara tjuṯangku tjilirratjarra tjuṯangku tjananya yankula pikangku pungu. Pikangku pungkula nguḻutjingara kutjupa tjuṯa tjananya Tjiyuyatjinanyangarri ngurra Papilunalakutu katingu, waarrkana tjuṯaya nyinanytjaku. Papilunakutu tjananya palunya tjuṯa katikitjangku Papilunaku mayutju tiṉangku Tjiyuyatjinaku kamuru Matanayanya, mayutju tiṉa tjanampa nyinatjunu Tjuutaku walytja ngaṉṯitja tjuṯaku. Nyinatjunkula yini kutjupa watjaṉu yalatji, Tjitikayanya. Mayutju paluru Katutjaku tjukarurruwiya nyinangi. Tjitikayanya mayutju tiṉa yiiya nayinpala nyinanytjala, Papilunanya ngurrara mayutju tiṉangku yini Nipukanitjalungarri, palumpa tjilirratjarra tjuṯangku yankula tjananya pikangku pungangi. Tjanaya pikangku pungkula nguḻutjingara tjananya ngurra tjanampa Tjarutjalumanya yuḻpura yaṉangu yuwankarra tjananya kakarrara katingu ngurra Papilunalakutu, Tjuutaku walytja ngaṉṯitja tjuṯa. Aapa nguwanpa tjananya wantingu ngurra walytjangkaya kutu nyinanytjaku, Tjarutjalumangka yila. Ngurra Tjarutjalumala yaṉangu tjuṯa tjananya katikitjangku Nipukanitjalu mayutju kutjupa palunya ngurrara tjuṯaku nyinatjunu, yini Kitalayanya. ");
INSERT INTO piu2006_vpl VALUES ("K221_2","013_21_2","2KI","21","2","26","Papilunakutu tjananya katinytjala yurrunpa Tjuutaku walytja ngaṉṯitja tjuṯaku mayutju Yitjikayanya nyinangi. Yitjikayanya nyinarra mirrirrinytjala palumpa katja Manatjanya tjanampa mayutju tiṉa nyinangi. Manatjanya nyinarra wiyawanangku palyaṉingi. Yirriṯi palumpa mama Yitjikayalu watjantjala Yitjikayaku waarrkana tjuṯangkuya Yatjaranya Paalanyangarri, Katutjanya nguwanpa tjuṯanya yuḻpura wiyaṉu, mayutju Katutjanyalpiya yaṉangu tjuṯangku waḻkura nyinanytjaku. Yitjikayaku katjangku Manatjalu tjananya watjaṉu piyuku Paalaku Yatjaraku palyara ngaratjunkunytjaku, ngaratjunkula waḻkuntjaku yaṉangu tjuṯangku. Manatjalungarri piṉṯirri tjuṯaṯarra waḻkura nyinapayi. Palunya tjuṯa waḻkulkitjangku palumpa katja mirrintara warungka kutjara wiyaṉu. Katutjaku tjaatji tiṉangka Manatjalu tjananya waarrkana tjuṯanya watjaṉu, Yatjaranya nguwanpa watiyanguru palyara ngaratjunkunytjaku. Palunyatjanu Yatjaranyalpiya waḻkuṉingi Katutjaku tjaatji tiṉangka, Tjarutjalumangka. Yalatjiya yaṉangu tjuṯangku wiyawanangku kuya palyara nyinangi, mayutju tiṉangku Manatjalu tjingapungkunytjala. Palunyatjanu Katutjaku wangka watjalpayi tjuṯangku tjananya yalatji langangkatjunu, “Mayutju tiṉangku Manatjalu nyurranya tjingapungkunytjala, wiyawanalpinyurra nyinarra ngayunya Katutjanya wantirra kuya puntu palyaṉi. Palulanguruṉa panitjimilalkitjangku ngayulu nyurrangarrinya ngurra kutjupakutu wantirriyalku. Ngurra Tjarutjalumanya ngayulu wiyantjala, yaṉangu tjuṯa wiyalpinyurra nyinaku. Ngurra kutjupakutunyurra yankula nyinamalpa.” Manatjanya yalatji wiyawana yiiya pipitiyi payipala Tjarutjalumangka nyinarra mirrirringu. Palulanguru palumpa katja Yamananya mayutju tiṉa tjanampa nyinangi Tjuutaku walytja ngaṉṯitja tjuṯaku. Palumpa mama nguwanpa Yamanalu Katutjanya nguwanpa tjuṯa waḻkura nyinangi. Katutjaku tjukarurruwiya nyinarra palumpa wangka kulira wantipayi. Mayutju tiṉaku waaḻawana Tjarutjalumangka mayutju kutjupa tjuṯa nyinangi, Yamanalu nyinatjunutja tjuṯa. Palunya tjuṯaya Yamanaku mirrpaṉarrirra yankula mirri pungu. Yiiya kutjarra mayutju tiṉa tjanampa nyinanytjala, palunya tjuṯangku mirri pungu. Tjuutaku walytja ngaṉṯitja tjuṯangku palunya pungkupayi tjuṯa ngaparrtjingku tjananya mirri pungu. Paluru tjanaya Yamanaku katja mayutju tiṉa nyinatjunu, yini Tjutjayanya. ");
INSERT INTO piu2006_vpl VALUES ("K222_1","013_22_1","2KI","22","1","2","Uḻa Tjutjayanya yiiya yiitpala nyinarra mayutju tiṉaya nyinatjunu. Tjutjayanya tjukarurru nyinarra palunya kutju waḻkulpayi, mayutju tiṉa Tapitanya tjukarurru nyinangutja nguwanpa. Yalatji Katutjaku wangkaku tjukarurru nyinanytjala, mayutju Katutjanyara yunypa nyinangi. Yiiya tjaaṯiyi waan mayutju tiṉa tjanampa Tjarutjalumangka nyinangi. ");
INSERT INTO piu2006_vpl VALUES ("K222_3","013_22_3","2KI","22","3","13","(22:3-13; 23:1-20) Mayutju tiṉangku Tjutjayalu tjananya watjaṉu Katutjaku tjaatjingka yuḻpaṯa kiliinamilara waṉinytjaku, tjaatjiṯarra kiliina ngaranytjaku. Paluru watjaṉu waaḻa ngarala yuḻpurringutja piyuku tjana palyantjaku. Tjaatji paluru rawa ngarala yuḻpurringu, mayutju Tjalamunalungarri yirriṯi palyara ngaratjunutja. Palulanguru mayutju Tjutjayalu watjaṉu waarrkarrirra kiliinamilara piyuku palyantjaku. Mayutju Tjutjayaku waarrkana yini Tjapananya tjaatji tiṉa palulakutu yanu maniku Yilkayala wangkanytjaku. Mani palunya yaṉangu tjuṯangku tjaatjingka tjawirrilyi waṉipayi. Tjapanalu watjaṉu Yilkayalu waarrkana tiṉa tjuṯa mani palunya yungkunytjaku. Paluru watjaṉu paluru tjana watiya tiimpa tjuṯa, puḻi tjuṯaṯarra payimilantjaku, tjaatjiya palyalkitjangku. Paluru piyuku watjaṉu tjana mani palunyatjarrangku waarrkana tjuṯa wiitjimani yungkunytjaku. Palunyangka tuḻkuku mayutjungku Yilkayalu waarrkana palunya piipa yungu, Katutjaku wangkatjarra. Yurrunpa Yilkayalungarri tjaatji tiṉangka kiliinamilara yuḻpaṯawana mantjiṉu Katutjaku wangka. Tjutjayaku waarrkanangku mantjira mayutju tiṉakutu Tjutjayalakutu katirra riitarringu. Yalatji riitarringkunytjala kulira mayutju Tjutjayalu nguḻurringkula palumpa waarrkanangka alatji watjaṉu, “Yankula Yilkayanyangarri tjananya watjala!, mayutju Katutjanyaya tjapintjaku nganaṉanya nintintjaku, tjukarurruwiyala nyinanyingka. Yalatji ngarrinyi piipa ngaangka tuḻkuku mayutju tjuṯangku Katutjanya tjapintjaku. Ngayuku waarrkanangku riitarrinytjala ngayulu kuliṉingi. Palulanguru ngayulu kuliṉi Katutjanyalampa mirrpaṉpa nyinanyi, piipa ngaakula tjukarurruwiya nyinanytjala, nganampa yirriṯi wiyarringutja tjuṯakuṯarra.” Waarrkana paluru wangka palunya katirra tjakultjunu tuḻkuku mayutju tiṉa, Yilkayanya. Yilkayalungarri puṯu kulira yankula tjapiṉu kungka Wultanya, Katutjaku wangka watjalpayinya. Tjapintjala Wultalu tjananya Katutjaku wangka yalatji tjanala tjakultjunu, “Yankulaya mayutju Tjutjayangka yalatji tjakultjurra!, ‘Ngayulu Katutjalu nyurrangarrinya Tjuutaku walytja ngaṉṯitja tjuṯa yilta panitjimilalku, Tjarutjalumanya ngurrara tjuṯanyurra piipa wangkatjarra palunyaku tjukarurru nyinanytjawiyangka. Ngayuku wangkanyurra wantirra ngayunya nguwanpa kutjupa tjuṯa waḻkuṉi. Palunyangka mirrpaṉpaṉa nyinanyi, kanya nyuntu mayutju Tjutjayanya ngayuku wangka piipa palaku kulira palyanu nguḻurringu. Ngayuluṉa Tjarutjalumanya ngurrara tjuṯa panitjimilalkitjangka, nyuntu kulira nguḻurringunu mantarra wintarrpungkula palyanu yulangi. Yularra palyaṉin tjapiṉu. Palunyangka kuwarri wiyaṉa Tjarutjalumanya ngurrara tjuṯa panitjimilalku, ngayulu nyurrangarrinya wantiku. Nyuntu nyinarra mirrirrinytjala ngaṉṯi ngayulu tjananya panitjimilalku.’” Palunyatjanu mayutju Tjutjayalu tjananya Tjarutjalumaku mayutju tjuṯa, tuḻkuku mayutju tjuṯaṯarra yaṉangu tjuṯaṯarra yaḻṯingu, Katutjaku tjaatji tiṉangka tjungurrinytjaku. Yalatjiya tjungurringkula kuliṉingi, Tjutjayalu piipa palunya Katutjaku wangkatjarra riitarrinytjala. Kuliraya tjungungku Katutjala watjaṉu wangka palunyaku tjukarurru nyinakitjangku. Palulanguru mayutju Tjutjayalu tjananya watjaṉu Katutjanya nguwanpa kutjarra Yatjara an Paala katirra tjaatjingka tjayiṯingka waṉinytjaku. Katutjanya nguwanpa tjuṯaya ngurra winkiwana ngarala waṉipayi. Mayutju paluru watjantjala palumpa waarrkana tjuṯangku yuḻpura wiyaṉu, Katutjanya kutjuya tjukarurru waḻkura nyinakitjangku. ");
INSERT INTO piu2006_vpl VALUES ("K223_1","013_23_1","2KI","23","1","20","(22:3-13; 23:1-20) Mayutju tiṉangku Tjutjayalu tjananya watjaṉu Katutjaku tjaatjingka yuḻpaṯa kiliinamilara waṉinytjaku, tjaatjiṯarra kiliina ngaranytjaku. Paluru watjaṉu waaḻa ngarala yuḻpurringutja piyuku tjana palyantjaku. Tjaatji paluru rawa ngarala yuḻpurringu, mayutju Tjalamunalungarri yirriṯi palyara ngaratjunutja. Palulanguru mayutju Tjutjayalu watjaṉu waarrkarrirra kiliinamilara piyuku palyantjaku. Mayutju Tjutjayaku waarrkana yini Tjapananya tjaatji tiṉa palulakutu yanu maniku Yilkayala wangkanytjaku. Mani palunya yaṉangu tjuṯangku tjaatjingka tjawirrilyi waṉipayi. Tjapanalu watjaṉu Yilkayalu waarrkana tiṉa tjuṯa mani palunya yungkunytjaku. Paluru watjaṉu paluru tjana watiya tiimpa tjuṯa, puḻi tjuṯaṯarra payimilantjaku, tjaatjiya palyalkitjangku. Paluru piyuku watjaṉu tjana mani palunyatjarrangku waarrkana tjuṯa wiitjimani yungkunytjaku. Palunyangka tuḻkuku mayutjungku Yilkayalu waarrkana palunya piipa yungu, Katutjaku wangkatjarra. Yurrunpa Yilkayalungarri tjaatji tiṉangka kiliinamilara yuḻpaṯawana mantjiṉu Katutjaku wangka. Tjutjayaku waarrkanangku mantjira mayutju tiṉakutu Tjutjayalakutu katirra riitarringu. Yalatji riitarringkunytjala kulira mayutju Tjutjayalu nguḻurringkula palumpa waarrkanangka alatji watjaṉu, “Yankula Yilkayanyangarri tjananya watjala!, mayutju Katutjanyaya tjapintjaku nganaṉanya nintintjaku, tjukarurruwiyala nyinanyingka. Yalatji ngarrinyi piipa ngaangka tuḻkuku mayutju tjuṯangku Katutjanya tjapintjaku. Ngayuku waarrkanangku riitarrinytjala ngayulu kuliṉingi. Palulanguru ngayulu kuliṉi Katutjanyalampa mirrpaṉpa nyinanyi, piipa ngaakula tjukarurruwiya nyinanytjala, nganampa yirriṯi wiyarringutja tjuṯakuṯarra.” Waarrkana paluru wangka palunya katirra tjakultjunu tuḻkuku mayutju tiṉa, Yilkayanya. Yilkayalungarri puṯu kulira yankula tjapiṉu kungka Wultanya, Katutjaku wangka watjalpayinya. Tjapintjala Wultalu tjananya Katutjaku wangka yalatji tjanala tjakultjunu, “Yankulaya mayutju Tjutjayangka yalatji tjakultjurra!, ‘Ngayulu Katutjalu nyurrangarrinya Tjuutaku walytja ngaṉṯitja tjuṯa yilta panitjimilalku, Tjarutjalumanya ngurrara tjuṯanyurra piipa wangkatjarra palunyaku tjukarurru nyinanytjawiyangka. Ngayuku wangkanyurra wantirra ngayunya nguwanpa kutjupa tjuṯa waḻkuṉi. Palunyangka mirrpaṉpaṉa nyinanyi, kanya nyuntu mayutju Tjutjayanya ngayuku wangka piipa palaku kulira palyanu nguḻurringu. Ngayuluṉa Tjarutjalumanya ngurrara tjuṯa panitjimilalkitjangka, nyuntu kulira nguḻurringunu mantarra wintarrpungkula palyanu yulangi. Yularra palyaṉin tjapiṉu. Palunyangka kuwarri wiyaṉa Tjarutjalumanya ngurrara tjuṯa panitjimilalku, ngayulu nyurrangarrinya wantiku. Nyuntu nyinarra mirrirrinytjala ngaṉṯi ngayulu tjananya panitjimilalku.’” Palunyatjanu mayutju Tjutjayalu tjananya Tjarutjalumaku mayutju tjuṯa, tuḻkuku mayutju tjuṯaṯarra yaṉangu tjuṯaṯarra yaḻṯingu, Katutjaku tjaatji tiṉangka tjungurrinytjaku. Yalatjiya tjungurringkula kuliṉingi, Tjutjayalu piipa palunya Katutjaku wangkatjarra riitarrinytjala. Kuliraya tjungungku Katutjala watjaṉu wangka palunyaku tjukarurru nyinakitjangku. Palulanguru mayutju Tjutjayalu tjananya watjaṉu Katutjanya nguwanpa kutjarra Yatjara an Paala katirra tjaatjingka tjayiṯingka waṉinytjaku. Katutjanya nguwanpa tjuṯaya ngurra winkiwana ngarala waṉipayi. Mayutju paluru watjantjala palumpa waarrkana tjuṯangku yuḻpura wiyaṉu, Katutjanya kutjuya tjukarurru waḻkura nyinakitjangku. ");
INSERT INTO piu2006_vpl VALUES ("K224_1","013_24_1","2KI","24","1","20","(24:1—25:30) Tjuutjaku walytja ngaṉṯitja tjuṯaku mayutju tiṉa Tjiyuyakimanya Tjarutjalumala nyinangi. Palulanguru Papilunanya ngurrara tjuṯa yanu Tjarutjalumalakutu. Mayutju tiṉa tjanampa nyinangi yini Nipukanitjanya. Tjunguya yanu palumpa tjilirratjarra tjuṯaṯarra. Palunya tjuṯaku tjanampa nguḻurringkula mayutju Tjiyuyakimalu Nipukanitjala yalatji watjaṉu, “Pikangkulanku wiya pungkunytjaku, nganaṉatju waarrkana nyurrangarrimpa palya nyinamalpa.” Palunyatjanuya Tjarutjalumanya ngurrara tjuṯa waarrkana yiiya tjirripala nyinarra yunytjuwiyarringu. Nipukanitjaku kaangkinytjiwiyalpiya nyinangi. Mayutju Tjiyuyakimanya mirrirrinytjala palumpa katja Tjiyuyatjinanya mayutju tiṉa tjanampa Tjarutjalumangka nyinangi. Mayutju Tjiyuyatjinanya nyinanytjala Papilunanya ngurrara tjuṯa piyuku yanu Tjarutjalumalakutu tjilirratjarra tjuṯa, Tjuutaku walytja ngaṉṯitja tjuṯa pungkukitja. Papilunanya ngurrara tjuṯangku kutjupa tjuṯa tjananya pungkula tawunu Tjarutjalumangka ngururrtjunkula ngarala waṉingi. Tjarutjalumangka parriki tiṉa puḻitjanu palyaṉutja ngarangi, kiiṯa tjuṯatjarra. Waaḻa uwankarra parriki palula ngururrpa ngarangi. Tjarutjalumanya ngurrara tjuṯangkuya mayutju Tjiyuyatjinalungarri kiiṯa palunya tjuṯa patiraya laakamilaṉu, Papilunanya ngurrara tjuṯangku tjarrparra tjananya mirri pungkupayingka. Yiiya kutjarra nguwanpa tjana yunngu kutu nyinarra mayi tjanampa wiyarringu. Mayiku puṯu kulira mayutju Tjiyuyatjinalungarriya kiiṯa yaḻara pakara ngarala waṉingi. Mayutju Nipukanitjalungarri tjananya ngalya yankula witira mara karrpira waṉingi. Tjarutjalumangkaya Papilunanya ngurrara tjuṯangkuya tjarrparra ngurra tjuṯangkaya kuulta tjuṯa mantjira yuḻpura wantingu. Yalatji tjana ngurra tjuṯa tjanampa yuḻpura wantingu. Kutjupa tjuṯa tjananya tjana waṉma kakarrara katingu ngurra Papilunalakutu waarrkana tjuṯaya nyinanytjaku. Tjuutaku walytja ngaṉṯitja tjuṯalingkuya katingu. Tjana kutjupa tjuṯa tjananya maralpa tjuṯa wantingu, ngurra walytjangka waarrkanaya nyinanytjaku. Palunya tjuṯa tjananya katikitjangku Nipukanitjalu Tjitikayanya tjanampa mayutju tiṉa nyinatjunu, Tjarutjalumalawana nyinapayi tjuṯaku. Tjitikayanya Nipukanitjaku waarrkana Tjarutjalumangka kutu nyinangi yiiya lipinpala. Palunyatjanu mayutju Tjitikayanya Nipukanitjaku yunytjuwiyarringu, kaangkinytji nyinanytjawiya. Palunyatjanu mayutju Nipukanitjanyangarriya palumpa kuḻaṯatjarra tjuṯa ngalya yankula Tjarutjalumangka ngururrtjunkula nyinarra waṉingi, pikangku pungkunytjakitja. Parriki tiṉangka puḻitjanu palyaṉutja yunngu, mayutju Tjitikayanyangarri tjarrparra kiiṯa tjuṯa patira nyinangi, Papilunanya ngurrara tjuṯangku mirri pungkupayingkamarra. Parriki tiṉa palula katuwana Tjitikayaku tjilirratjarra tjuṯaya kaḻparra puḻingkaya kumpira nyakupayi. Yalatji katuya nyinangu puwanarratjarrangku wakalkitja, Papilunanya ngurrara tjuṯangku laata ngaratjunkula kaḻparra tjarrparra pungkutjipingkamarra. Tjarutjalumanya ngurrara tjuṯaya mayitjirratja pakantjaku Papilunanya ngurrara tjuṯa tjanampa rawa paṯaṉingi, yiiya kutjarra. Puṯu paṯaraya yankula parriki tiṉa palunya yatura yatura yuḻpuṉu, watiya tiṉatjarrangku. Yuḻpuraya tjarrpangu. Palunyatjanu mungangkaya mayutju Tjitikayanyangarri palumpa tjilirratjarra tjuṯa kiiṯa kutjupa yaḻara kakarrara tjalkaḻungu. Papilunanya ngurrara tjuṯangku tjananya kulira wanaranangi. Wanarankulaya mayutju Tjitikayanya witira kanyintjala palumpa tjilirratjarra tjuṯangkuya wantirra tjalkaḻungu mayutjuku kulintjawiya. Mayutju Tjitikayanya witiraya katingu mayutju tiṉa Nipukanitjalakutu. Paluru yila nyinangi, tawunu Ripulangka. Mayutju Nipukanitjalu watjantjala Papilunanya ngurrara tjuṯangku tjananya tjilirratjarra tjuṯangku Tjitikayaku katja tjirripala mirri pungu, Tjitikayalu nyakunytjala. Palunyatjanuya Tjitikayanyalpiya kuru paangaṉu, yayina aatatjarrangku. Kuru paangara tjiinangka mara karrpira ngurra Papilunalakutu katingu, waarrkana kutu nyinanytjaku. Tjarutjalumangkaya Papilunanya ngurrara tjuṯangku tjilirratjarra tjuṯangku tjarrparra puḻi kuulta anta puḻi tjiilpa yulytjaṯarra mantjira katirra kapuṯunkula tjunu, ngurra walytjakutu katikitjangku. Kapuṯunkula wantirra Katutjaku tjaatji yuḻpura kutjaṉu. Waaḻa kutjupa tjuṯaya kutjara wiyaṉu. Parriki tiṉa waaḻa tjuṯa ngururrtjunkupayi paluru tjana kilytjuntara yuḻpuṉu. Yalatjiya kilytjuntara wiyaṉu Tjarutjalumanya. Tjarutjalumanya ngurrara tjuṯa Papilunanya ngurrara tjuṯangku tjananya wiipatjarrangku pungangi. Pungkula tjananya tjuuḻa waṯawaratjarrangku wakara mirrintanu. Tjana Papilunanya ngurrara tjilirratjarra tjuṯangku wati tjuṯa tjananya pungu. Tjana yaṉangu tjuṯalingku tjananya karrpira ngurra Papilunalakutu katingu, waarrkarringkula nyinanytjaku. Maṉkurrpa nguwanpa tjananya wantingu Tjarutjalumangka ila kaanangka waarrkarrirra mayi pakaltjingantjaku. Paṉa palunya ngunytji kanyintjaku Nipukanitjalu wati Kitalayanya mayutju nyinatjunu, kaana ngurrara tjuṯa yaṉṯayaṉṯantjaku. Ngurra yini Mitjipangka mayutju Kitalayanyangarriya nyinangi. Maanytja tjirripalangkaya nyinanytjala wati Yitjumilalungarri tjananya ngalya yankula kutjupa tjuṯa tjananya mirri pungu, kanya kutjupa tjuṯaya kaana ngurrara palunya tjuṯa nguḻurringkula paṉa Yitjipilakutu yankula nyinangi, Nipukanitjalu tjananya ngalya yankula pungkupayingka. ");
INSERT INTO piu2006_vpl VALUES ("K225_1","013_25_1","2KI","25","1","30","(24:1—25:30) Tjuutjaku walytja ngaṉṯitja tjuṯaku mayutju tiṉa Tjiyuyakimanya Tjarutjalumala nyinangi. Palulanguru Papilunanya ngurrara tjuṯa yanu Tjarutjalumalakutu. Mayutju tiṉa tjanampa nyinangi yini Nipukanitjanya. Tjunguya yanu palumpa tjilirratjarra tjuṯaṯarra. Palunya tjuṯaku tjanampa nguḻurringkula mayutju Tjiyuyakimalu Nipukanitjala yalatji watjaṉu, “Pikangkulanku wiya pungkunytjaku, nganaṉatju waarrkana nyurrangarrimpa palya nyinamalpa.” Palunyatjanuya Tjarutjalumanya ngurrara tjuṯa waarrkana yiiya tjirripala nyinarra yunytjuwiyarringu. Nipukanitjaku kaangkinytjiwiyalpiya nyinangi. Mayutju Tjiyuyakimanya mirrirrinytjala palumpa katja Tjiyuyatjinanya mayutju tiṉa tjanampa Tjarutjalumangka nyinangi. Mayutju Tjiyuyatjinanya nyinanytjala Papilunanya ngurrara tjuṯa piyuku yanu Tjarutjalumalakutu tjilirratjarra tjuṯa, Tjuutaku walytja ngaṉṯitja tjuṯa pungkukitja. Papilunanya ngurrara tjuṯangku kutjupa tjuṯa tjananya pungkula tawunu Tjarutjalumangka ngururrtjunkula ngarala waṉingi. Tjarutjalumangka parriki tiṉa puḻitjanu palyaṉutja ngarangi, kiiṯa tjuṯatjarra. Waaḻa uwankarra parriki palula ngururrpa ngarangi. Tjarutjalumanya ngurrara tjuṯangkuya mayutju Tjiyuyatjinalungarri kiiṯa palunya tjuṯa patiraya laakamilaṉu, Papilunanya ngurrara tjuṯangku tjarrparra tjananya mirri pungkupayingka. Yiiya kutjarra nguwanpa tjana yunngu kutu nyinarra mayi tjanampa wiyarringu. Mayiku puṯu kulira mayutju Tjiyuyatjinalungarriya kiiṯa yaḻara pakara ngarala waṉingi. Mayutju Nipukanitjalungarri tjananya ngalya yankula witira mara karrpira waṉingi. Tjarutjalumangkaya Papilunanya ngurrara tjuṯangkuya tjarrparra ngurra tjuṯangkaya kuulta tjuṯa mantjira yuḻpura wantingu. Yalatji tjana ngurra tjuṯa tjanampa yuḻpura wantingu. Kutjupa tjuṯa tjananya tjana waṉma kakarrara katingu ngurra Papilunalakutu waarrkana tjuṯaya nyinanytjaku. Tjuutaku walytja ngaṉṯitja tjuṯalingkuya katingu. Tjana kutjupa tjuṯa tjananya maralpa tjuṯa wantingu, ngurra walytjangka waarrkanaya nyinanytjaku. Palunya tjuṯa tjananya katikitjangku Nipukanitjalu Tjitikayanya tjanampa mayutju tiṉa nyinatjunu, Tjarutjalumalawana nyinapayi tjuṯaku. Tjitikayanya Nipukanitjaku waarrkana Tjarutjalumangka kutu nyinangi yiiya lipinpala. Palunyatjanu mayutju Tjitikayanya Nipukanitjaku yunytjuwiyarringu, kaangkinytji nyinanytjawiya. Palunyatjanu mayutju Nipukanitjanyangarriya palumpa kuḻaṯatjarra tjuṯa ngalya yankula Tjarutjalumangka ngururrtjunkula nyinarra waṉingi, pikangku pungkunytjakitja. Parriki tiṉangka puḻitjanu palyaṉutja yunngu, mayutju Tjitikayanyangarri tjarrparra kiiṯa tjuṯa patira nyinangi, Papilunanya ngurrara tjuṯangku mirri pungkupayingkamarra. Parriki tiṉa palula katuwana Tjitikayaku tjilirratjarra tjuṯaya kaḻparra puḻingkaya kumpira nyakupayi. Yalatji katuya nyinangu puwanarratjarrangku wakalkitja, Papilunanya ngurrara tjuṯangku laata ngaratjunkula kaḻparra tjarrparra pungkutjipingkamarra. Tjarutjalumanya ngurrara tjuṯaya mayitjirratja pakantjaku Papilunanya ngurrara tjuṯa tjanampa rawa paṯaṉingi, yiiya kutjarra. Puṯu paṯaraya yankula parriki tiṉa palunya yatura yatura yuḻpuṉu, watiya tiṉatjarrangku. Yuḻpuraya tjarrpangu. Palunyatjanu mungangkaya mayutju Tjitikayanyangarri palumpa tjilirratjarra tjuṯa kiiṯa kutjupa yaḻara kakarrara tjalkaḻungu. Papilunanya ngurrara tjuṯangku tjananya kulira wanaranangi. Wanarankulaya mayutju Tjitikayanya witira kanyintjala palumpa tjilirratjarra tjuṯangkuya wantirra tjalkaḻungu mayutjuku kulintjawiya. Mayutju Tjitikayanya witiraya katingu mayutju tiṉa Nipukanitjalakutu. Paluru yila nyinangi, tawunu Ripulangka. Mayutju Nipukanitjalu watjantjala Papilunanya ngurrara tjuṯangku tjananya tjilirratjarra tjuṯangku Tjitikayaku katja tjirripala mirri pungu, Tjitikayalu nyakunytjala. Palunyatjanuya Tjitikayanyalpiya kuru paangaṉu, yayina aatatjarrangku. Kuru paangara tjiinangka mara karrpira ngurra Papilunalakutu katingu, waarrkana kutu nyinanytjaku. Tjarutjalumangkaya Papilunanya ngurrara tjuṯangku tjilirratjarra tjuṯangku tjarrparra puḻi kuulta anta puḻi tjiilpa yulytjaṯarra mantjira katirra kapuṯunkula tjunu, ngurra walytjakutu katikitjangku. Kapuṯunkula wantirra Katutjaku tjaatji yuḻpura kutjaṉu. Waaḻa kutjupa tjuṯaya kutjara wiyaṉu. Parriki tiṉa waaḻa tjuṯa ngururrtjunkupayi paluru tjana kilytjuntara yuḻpuṉu. Yalatjiya kilytjuntara wiyaṉu Tjarutjalumanya. Tjarutjalumanya ngurrara tjuṯa Papilunanya ngurrara tjuṯangku tjananya wiipatjarrangku pungangi. Pungkula tjananya tjuuḻa waṯawaratjarrangku wakara mirrintanu. Tjana Papilunanya ngurrara tjilirratjarra tjuṯangku wati tjuṯa tjananya pungu. Tjana yaṉangu tjuṯalingku tjananya karrpira ngurra Papilunalakutu katingu, waarrkarringkula nyinanytjaku. Maṉkurrpa nguwanpa tjananya wantingu Tjarutjalumangka ila kaanangka waarrkarrirra mayi pakaltjingantjaku. Paṉa palunya ngunytji kanyintjaku Nipukanitjalu wati Kitalayanya mayutju nyinatjunu, kaana ngurrara tjuṯa yaṉṯayaṉṯantjaku. Ngurra yini Mitjipangka mayutju Kitalayanyangarriya nyinangi. Maanytja tjirripalangkaya nyinanytjala wati Yitjumilalungarri tjananya ngalya yankula kutjupa tjuṯa tjananya mirri pungu, kanya kutjupa tjuṯaya kaana ngurrara palunya tjuṯa nguḻurringkula paṉa Yitjipilakutu yankula nyinangi, Nipukanitjalu tjananya ngalya yankula pungkupayingka. ");
INSERT INTO piu2006_vpl VALUES ("ER1_1","016_1_1","EZR","1","1","11","Papilunanya ngurrara tjuṯaku mayutju Tjaratjanya nyinangi. Mayutju Katutjalu palunya nintintjala paluru yaṉangu tjuṯaku tjanampa piipa wakaṉu. Paluru watjaṉu mayutju tjuṯangku riitarrinytjala, yaṉangu tjuṯangku kulintjaku. Yalatji tjanampa wakaṉu, “Patjaku walytja ngaṉṯitja tjuṯaku mayutju tiṉangku ngayulu nyurrangarrimpa Tjaratjalu wangka yalatji wakara wantirriyaṉi, ngurra tjuṯawananyurra kulintjaku. Mayutju tiṉaluṉi Katutjalu nyinatjunu. Paluruṉi watjaṉu palumpa tjaatji tiṉa tawunu Tjarutjalumangka palyantjaku. Palulanguru Tjuwu tjuṯanyurra ngurra Papilunalawana nyinanytja tjuṯa pakara yankunytjaku Tjarutjalumalakutu. Yankulanyurra tjaatji tiṉa ngurra palula palyantjaku. Katutjaku walytja nyurrangarri Tjuwu tjuṯa nyinanyi. Nyurrangarri ngurra palulakutu yankukitjangku tjinguru puṯu kulilku, mani, yulytja, tuungkiyiṯarra katikitjangku. Yalatjinyurra puṯu kulintjala, ngurrara kutju ngurrara tjuṯangku nyurrangarrinya yungkunytjaku, Papilunanya ngurrara tjuṯangku. Kuka tjawirrilyi tjuṯaṯarra nyurrangarrinya yungkunytjaku, Tjarutjalumalakutunyurra katirra pungkunytjaku. Mayutju Katutjaku tjaatji tiṉangkanyurra katirra pungkula kutjantjaku.” Palunyatjanuya Tjuwu tjuṯa, Tjuutaku walytja ngaṉṯitja tjuṯa, Pintjiminaku walytja ngaṉṯitja tjuṯaṯarra kuliraya yunyparringu. Yunyparrirra yankukitjangku mani yulytjaṯarraya mantjiṉu. ");
INSERT INTO piu2006_vpl VALUES ("ER2_1","016_2_1","EZR","2","1","70","(2:1,68-70; 3:1-13) Mayutju Tjaratjalu Papilunangka Katutjaku yulytja mantjira tjananya yungu, panikina tjuṯa, kaṉilpa tjuṯa kuultatjanu palyaṉutja. Yalatji tjananya Tjuwu tjuṯaku yungu, Tjarutjalumakutuya katirra Katutjaku tjaatjingka tjunkunytjaku. Tjuwu tjuṯalingkuya tjawutjuna puutiyi tuupala tjungurringkulaya rayitpayiki Tjarutjalumalakutu yanu. Wilurarraya yankula ngurra walytjakutuya rayitpayiki yankula nyinangu. Ngurra Tjarutjalumangka tjayiṯiwana tawunu yuḻpuṉutja tjuṯa ngarala waṉingi. Yalatjiya tawunu palula tjuṯakutuya yankula piyuku palyaṉu, ngurra walytja. Yalatjiya palyara tawunu nyuwana tjuṯangkalpiya nyinarra waṉingi, yirriṯitja tjuṯaya nyinarra waṉipayi. Mayutju tjanampa Tjarapapulalungarri Tjarutjalumangka tiipula nguwanpa puḻitjanu palyaṉu, tiipula yirriṯitja ngarangutja, palulaya palyaṉu, tjaatji yirriṯitja ngaranytjala yila. Tiipulaya palyara tjiṉṯu kutjupangka tjiṉṯu kutjupangka kuka tjawirrilyi pungkula Katutjaku kutjalpayi, Muutjalu yirriṯi yalatji kutjantjaku watjaṉu. Yalatjiya tjawirrilyi pungkula Katutjanya waḻkulpayi, Katutjaku tjaatji tiṉa ngaranytjawiyangka. ");
INSERT INTO piu2006_vpl VALUES ("ER3_1","016_3_1","EZR","3","1","13","(1-2, 68-70; 3:1-13) Mayutju Tjaratjalu Papilunangka Katutjaku yulytja mantjira tjananya yungu, panikina tjuṯa, kaṉilpa tjuṯa kuultatjanu palyaṉutja. Yalatji tjananya Tjuwu tjuṯaku yungu, Tjarutjalumakutuya katirra Katutjaku tjaatjingka tjunkunytjaku. Tjuwu tjuṯalingkuya tjawutjuna puutiyi tuupala tjungurringkulaya rayitpayiki Tjarutjalumalakutu yanu. Wilurarraya yankula ngurra walytjakutuya rayitpayiki yankula nyinangu. Ngurra Tjarutjalumangka tjayiṯiwana tawunu yuḻpuṉutja tjuṯa ngarala waṉingi. Yalatjiya tawunu palula tjuṯakutuya yankula piyuku palyaṉu, ngurra walytja. Yalatjiya palyara tawunu nyuwana tjuṯangkalpiya nyinarra waṉingi, yirriṯitja tjuṯaya nyinarra waṉipayi. Mayutju tjanampa Tjarapapulalungarri Tjarutjalumangka tiipula nguwanpa puḻitjanu palyaṉu, tiipula yirriṯitja ngarangutja, palulaya palyaṉu, tjaatji yirriṯitja ngaranytjala yila. Tiipulaya palyara tjiṉṯu kutjupangka tjiṉṯu kutjupangka kuka tjawirrilyi pungkula Katutjaku kutjalpayi, Muutjalu yirriṯi yalatji kutjantjaku watjaṉu. Yalatjiya tjawirrilyi pungkula Katutjanya waḻkulpayi, Katutjaku tjaatji tiṉa ngaranytjawiyangka. (3:7-11; 4:1-6,24; 5:1-17; 6:1-8) Tjarutjalumanya ngurrara tjuṯangku tjaatji tiṉa Katutjakuya palyalkitjangku tjanampa uwankarra yungu, tjira tjuṯa, mayi tjuṯa, waama tjuṯaṯarra, Taayanya anta Tjayitananya ngurrara tjuṯaku. Paluru tjana ngaparrtjingku tiimpa tjuṯa yungu puḻi tjuṯaṯarra, Tjuwu tjuṯangku tjaatji tiṉa palyantjaku. Tiimpa tjuṯa yaturaya maa katirra tjunkupayi tjaatjingka yila. Puḻi palya tjuṯaṯarraya yuḻpura tjunkula katipayi Tjarutjalumalakutu, tjaatji palunya palyantjaku. Waarrkana tjuṯangkuya tjaatji palyalkitjangku puḻi palya tjuṯa mantjira tjunkunytjala yaṉangu kutjupa tjuṯangkuya nyakula yunyparringkula mayutju Katutjanya waḻkuṉangi. Tuḻkuku mayutju tjuṯangkuya turampata tjuṯa yunypangku mirratjingaṉangi. Tjaatji tiṉaya palyantjala Tjamiriyanya ngurrara tjuṯangku ngalya yankula mayutju Tjarapapulanyangarri tjananya yalatji tjapiṉu, “Tjungungkula palyala!, Katutjaku tjaatji tiṉa. Katutjanyalatju ngurra yalinytjarratjayiṯi nyinarra waḻkulpayi, Papilunangkanyurra nyinanytjala.” Tjarapulalungarri tjananya yalatji wiya watjaṉu, “Wiya, palyalatju tjaatji tiṉa Katutjaku palyalku, mayutju Tjaratjalulanyatju watjaṉutjangka. Nyurrangarri wiya tjungurringkula palyantjaku.” Yalatjiya wiya watjantjala yalinytjarra ngurrara tjuṯa tjanampa yunytjuwiyarringu. Paluru tjana watjara payilpayi. “Wiyanyurra tjaatji ngaatja palyantjaku. Tjinguru nyurrangarri kutu palyantjala nganaṉatju nyurrangarrinya pungku.” Palunyatjanu yalinytjarra ngurrara tjuṯangku pungkukitjangku watjantjala, Tjarapapulalungarriya nguḻurringkula tjaatji palunya aapuwayi palyara wantingu. Palunyatjanu ngula Katutjaku wangka watjalpayi kutjarrangku tjananya watjaṉu Katutjaku tjaatji piyuku palyantjaku, wati Yakayilu anta Tjakarriyalu. Palulanguruya Tjuwu tjuṯangku piyuku palyaṉingi tjaatji palunya. Kamanta ngurrarangku tjanampa yini Tatinayalu yunytjuwiyarringkula piipa wakara wantirriyaṉu mayutju Tarayatjalakutu, Papilunanya ngurrara tjuṯaku mayutju tiṉakutu. Mayutju tiṉa Tjaratjanya mirrirrinytjala, mayutju tiṉa Tarayatjanya tjanampa nyinangi, tawunu Papilunangka. Piipangka yalatji Tatinayalu wakara wantirriyaṉu mayutju Tarayatjalakutu. “Tjuwu tjuṯangkuya mayutju Katutjaku tjaatji tiṉa palyaṉi. Tjana watjaṉulanyatju mayutju Tjaratjalu yirriṯi watjaṉutjangka tjaatji palunya palyantjaku. Tjinguru yalatji yiltaya Tjuwu tjuṯangku watjaṉu, tjinguru wiya. Puṯuṉa kuliṉi. Tjinguru watjantjawiyangka palyantjawiyangkuya wantinytjaku. Wangka ngaatjanyaṉanta wakaṉutja nyuntu palya piipa tjuṯangka taaṉamilara nyawa!, mayutju Tjaratjalu wakaṉutja. Yalatji wakanmara, ‘Tjuwu tjuṯangkuya tjaatji palunya Tjarutjalumangka palyantjaku.’” Piipa yalatji Tatinayalu wakara wantirriyaṉu mayutju Tarayatjalakutu. Palunyangka mayutju paluru piipa tjuṯangka taaṉamilara wangka panyapangka nyangu. Yilta paluru Tjaratjalu tjananya yirriṯi wakara watjaṉu tjaatji tiṉa Tjarutjalumangkaya palyantjaku. Piipa palunya nyakula Tarayatjalu piipa kutjupa wakara wantirriyaṉu kamantaku mayutju Tatinayalakutu. Piipa palunyangka watjaṉu palyaya Tjuwu tjuṯangku Katutjaku tjaatji kutu palyara pinitjimilantjaku. Palunyatjanuya tjaatji tiṉa palyara pinitjimilaṉu. Yalatjiya pinitjimilara Tjuwu tjuṯaya yunyparringkula Katutjaku tjawirrilyi pungkula kutjara Katutjanyalpiya waḻkuṉangi. ");
INSERT INTO piu2006_vpl VALUES ("ER4_1","016_4_1","EZR","4","1","24","(3:7-11; 4:1-6,24; 5:1-17; 6:1-8) Tjarutjalumanya ngurrara tjuṯangku tjaatji tiṉa Katutjakuya palyalkitjangku tjanampa uwankarra yungu, tjira tjuṯa, mayi tjuṯa, waama tjuṯaṯarra, Taayanya anta Tjayitananya ngurrara tjuṯaku. Paluru tjana ngaparrtjingku tiimpa tjuṯa yungu puḻi tjuṯaṯarra, Tjuwu tjuṯangku tjaatji tiṉa palyantjaku. Tiimpa tjuṯa yaturaya maa katirra tjunkupayi tjaatjingka yila. Puḻi palya tjuṯaṯarraya yuḻpura tjunkula katipayi Tjarutjalumalakutu, tjaatji palunya palyantjaku. Waarrkana tjuṯangkuya tjaatji palyalkitjangku puḻi palya tjuṯa mantjira tjunkunytjala yaṉangu kutjupa tjuṯangkuya nyakula yunyparringkula mayutju Katutjanya waḻkuṉangi. Tuḻkuku mayutju tjuṯangkuya turampata tjuṯa yunypangku mirratjingaṉangi. Tjaatji tiṉaya palyantjala Tjamiriyanya ngurrara tjuṯangku ngalya yankula mayutju Tjarapapulanyangarri tjananya yalatji tjapiṉu, “Tjungungkula palyala!, Katutjaku tjaatji tiṉa. Katutjanyalatju ngurra yalinytjarratjayiṯi nyinarra waḻkulpayi, Papilunangkanyurra nyinanytjala.” Tjarapulalungarri tjananya yalatji wiya watjaṉu, “Wiya, palyalatju tjaatji tiṉa Katutjaku palyalku, mayutju Tjaratjalulanyatju watjaṉutjangka. Nyurrangarri wiya tjungurringkula palyantjaku.” Yalatjiya wiya watjantjala yalinytjarra ngurrara tjuṯa tjanampa yunytjuwiyarringu. Paluru tjana watjara payilpayi. “Wiyanyurra tjaatji ngaatja palyantjaku. Tjinguru nyurrangarri kutu palyantjala nganaṉatju nyurrangarrinya pungku.” Palunyatjanu yalinytjarra ngurrara tjuṯangku pungkukitjangku watjantjala, Tjarapapulalungarriya nguḻurringkula tjaatji palunya aapuwayi palyara wantingu. Palunyatjanu ngula Katutjaku wangka watjalpayi kutjarrangku tjananya watjaṉu Katutjaku tjaatji piyuku palyantjaku, wati Yakayilu anta Tjakarriyalu. Palulanguruya Tjuwu tjuṯangku piyuku palyaṉingi tjaatji palunya. Kamanta ngurrarangku tjanampa yini Tatinayalu yunytjuwiyarringkula piipa wakara wantirriyaṉu mayutju Tarayatjalakutu, Papilunanya ngurrara tjuṯaku mayutju tiṉakutu. Mayutju tiṉa Tjaratjanya mirrirrinytjala, mayutju tiṉa Tarayatjanya tjanampa nyinangi, tawunu Papilunangka. Piipangka yalatji Tatinayalu wakara wantirriyaṉu mayutju Tarayatjalakutu. “Tjuwu tjuṯangkuya mayutju Katutjaku tjaatji tiṉa palyaṉi. Tjana watjaṉulanyatju mayutju Tjaratjalu yirriṯi watjaṉutjangka tjaatji palunya palyantjaku. Tjinguru yalatji yiltaya Tjuwu tjuṯangku watjaṉu, tjinguru wiya. Puṯuṉa kuliṉi. Tjinguru watjantjawiyangka palyantjawiyangkuya wantinytjaku. Wangka ngaatjanyaṉanta wakaṉutja nyuntu palya piipa tjuṯangka taaṉamilara nyawa!, mayutju Tjaratjalu wakaṉutja. Yalatji wakanmara, ‘Tjuwu tjuṯangkuya tjaatji palunya Tjarutjalumangka palyantjaku.’” Piipa yalatji Tatinayalu wakara wantirriyaṉu mayutju Tarayatjalakutu. Palunyangka mayutju paluru piipa tjuṯangka taaṉamilara wangka panyapangka nyangu. Yilta paluru Tjaratjalu tjananya yirriṯi wakara watjaṉu tjaatji tiṉa Tjarutjalumangkaya palyantjaku. Piipa palunya nyakula Tarayatjalu piipa kutjupa wakara wantirriyaṉu kamantaku mayutju Tatinayalakutu. Piipa palunyangka watjaṉu palyaya Tjuwu tjuṯangku Katutjaku tjaatji kutu palyara pinitjimilantjaku. Palunyatjanuya tjaatji tiṉa palyara pinitjimilaṉu. Yalatjiya pinitjimilara Tjuwu tjuṯaya yunyparringkula Katutjaku tjawirrilyi pungkula kutjara Katutjanyalpiya waḻkuṉangi. ");
INSERT INTO piu2006_vpl VALUES ("ER5_1","016_5_1","EZR","5","1","17","(3:7-11; 4:1-6,24; 5:1-17; 6:1-8) Tjarutjalumanya ngurrara tjuṯangku tjaatji tiṉa Katutjakuya palyalkitjangku tjanampa uwankarra yungu, tjira tjuṯa, mayi tjuṯa, waama tjuṯaṯarra, Taayanya anta Tjayitananya ngurrara tjuṯaku. Paluru tjana ngaparrtjingku tiimpa tjuṯa yungu puḻi tjuṯaṯarra, Tjuwu tjuṯangku tjaatji tiṉa palyantjaku. Tiimpa tjuṯa yaturaya maa katirra tjunkupayi tjaatjingka yila. Puḻi palya tjuṯaṯarraya yuḻpura tjunkula katipayi Tjarutjalumalakutu, tjaatji palunya palyantjaku. Waarrkana tjuṯangkuya tjaatji palyalkitjangku puḻi palya tjuṯa mantjira tjunkunytjala yaṉangu kutjupa tjuṯangkuya nyakula yunyparringkula mayutju Katutjanya waḻkuṉangi. Tuḻkuku mayutju tjuṯangkuya turampata tjuṯa yunypangku mirratjingaṉangi. Tjaatji tiṉaya palyantjala Tjamiriyanya ngurrara tjuṯangku ngalya yankula mayutju Tjarapapulanyangarri tjananya yalatji tjapiṉu, “Tjungungkula palyala!, Katutjaku tjaatji tiṉa. Katutjanyalatju ngurra yalinytjarratjayiṯi nyinarra waḻkulpayi, Papilunangkanyurra nyinanytjala.” Tjarapulalungarri tjananya yalatji wiya watjaṉu, “Wiya, palyalatju tjaatji tiṉa Katutjaku palyalku, mayutju Tjaratjalulanyatju watjaṉutjangka. Nyurrangarri wiya tjungurringkula palyantjaku.” Yalatjiya wiya watjantjala yalinytjarra ngurrara tjuṯa tjanampa yunytjuwiyarringu. Paluru tjana watjara payilpayi. “Wiyanyurra tjaatji ngaatja palyantjaku. Tjinguru nyurrangarri kutu palyantjala nganaṉatju nyurrangarrinya pungku.” Palunyatjanu yalinytjarra ngurrara tjuṯangku pungkukitjangku watjantjala, Tjarapapulalungarriya nguḻurringkula tjaatji palunya aapuwayi palyara wantingu. Palunyatjanu ngula Katutjaku wangka watjalpayi kutjarrangku tjananya watjaṉu Katutjaku tjaatji piyuku palyantjaku, wati Yakayilu anta Tjakarriyalu. Palulanguruya Tjuwu tjuṯangku piyuku palyaṉingi tjaatji palunya. Kamanta ngurrarangku tjanampa yini Tatinayalu yunytjuwiyarringkula piipa wakara wantirriyaṉu mayutju Tarayatjalakutu, Papilunanya ngurrara tjuṯaku mayutju tiṉakutu. Mayutju tiṉa Tjaratjanya mirrirrinytjala, mayutju tiṉa Tarayatjanya tjanampa nyinangi, tawunu Papilunangka. Piipangka yalatji Tatinayalu wakara wantirriyaṉu mayutju Tarayatjalakutu. “Tjuwu tjuṯangkuya mayutju Katutjaku tjaatji tiṉa palyaṉi. Tjana watjaṉulanyatju mayutju Tjaratjalu yirriṯi watjaṉutjangka tjaatji palunya palyantjaku. Tjinguru yalatji yiltaya Tjuwu tjuṯangku watjaṉu, tjinguru wiya. Puṯuṉa kuliṉi. Tjinguru watjantjawiyangka palyantjawiyangkuya wantinytjaku. Wangka ngaatjanyaṉanta wakaṉutja nyuntu palya piipa tjuṯangka taaṉamilara nyawa!, mayutju Tjaratjalu wakaṉutja. Yalatji wakanmara, ‘Tjuwu tjuṯangkuya tjaatji palunya Tjarutjalumangka palyantjaku.’” Piipa yalatji Tatinayalu wakara wantirriyaṉu mayutju Tarayatjalakutu. Palunyangka mayutju paluru piipa tjuṯangka taaṉamilara wangka panyapangka nyangu. Yilta paluru Tjaratjalu tjananya yirriṯi wakara watjaṉu tjaatji tiṉa Tjarutjalumangkaya palyantjaku. Piipa palunya nyakula Tarayatjalu piipa kutjupa wakara wantirriyaṉu kamantaku mayutju Tatinayalakutu. Piipa palunyangka watjaṉu palyaya Tjuwu tjuṯangku Katutjaku tjaatji kutu palyara pinitjimilantjaku. Palunyatjanuya tjaatji tiṉa palyara pinitjimilaṉu. Yalatjiya pinitjimilara Tjuwu tjuṯaya yunyparringkula Katutjaku tjawirrilyi pungkula kutjara Katutjanyalpiya waḻkuṉangi. ");
INSERT INTO piu2006_vpl VALUES ("ER6_1","016_6_1","EZR","6","1","8","(3:7-11; 4:1-6,24; 5:1-17; 6:1-8) Tjarutjalumanya ngurrara tjuṯangku tjaatji tiṉa Katutjakuya palyalkitjangku tjanampa uwankarra yungu, tjira tjuṯa, mayi tjuṯa, waama tjuṯaṯarra, Taayanya anta Tjayitananya ngurrara tjuṯaku. Paluru tjana ngaparrtjingku tiimpa tjuṯa yungu puḻi tjuṯaṯarra, Tjuwu tjuṯangku tjaatji tiṉa palyantjaku. Tiimpa tjuṯa yaturaya maa katirra tjunkupayi tjaatjingka yila. Puḻi palya tjuṯaṯarraya yuḻpura tjunkula katipayi Tjarutjalumalakutu, tjaatji palunya palyantjaku. Waarrkana tjuṯangkuya tjaatji palyalkitjangku puḻi palya tjuṯa mantjira tjunkunytjala yaṉangu kutjupa tjuṯangkuya nyakula yunyparringkula mayutju Katutjanya waḻkuṉangi. Tuḻkuku mayutju tjuṯangkuya turampata tjuṯa yunypangku mirratjingaṉangi. Tjaatji tiṉaya palyantjala Tjamiriyanya ngurrara tjuṯangku ngalya yankula mayutju Tjarapapulanyangarri tjananya yalatji tjapiṉu, “Tjungungkula palyala!, Katutjaku tjaatji tiṉa. Katutjanyalatju ngurra yalinytjarratjayiṯi nyinarra waḻkulpayi, Papilunangkanyurra nyinanytjala.” Tjarapulalungarri tjananya yalatji wiya watjaṉu, “Wiya, palyalatju tjaatji tiṉa Katutjaku palyalku, mayutju Tjaratjalulanyatju watjaṉutjangka. Nyurrangarri wiya tjungurringkula palyantjaku.” Yalatjiya wiya watjantjala yalinytjarra ngurrara tjuṯa tjanampa yunytjuwiyarringu. Paluru tjana watjara payilpayi. “Wiyanyurra tjaatji ngaatja palyantjaku. Tjinguru nyurrangarri kutu palyantjala nganaṉatju nyurrangarrinya pungku.” Palunyatjanu yalinytjarra ngurrara tjuṯangku pungkukitjangku watjantjala, Tjarapapulalungarriya nguḻurringkula tjaatji palunya aapuwayi palyara wantingu. Palunyatjanu ngula Katutjaku wangka watjalpayi kutjarrangku tjananya watjaṉu Katutjaku tjaatji piyuku palyantjaku, wati Yakayilu anta Tjakarriyalu. Palulanguruya Tjuwu tjuṯangku piyuku palyaṉingi tjaatji palunya. Kamanta ngurrarangku tjanampa yini Tatinayalu yunytjuwiyarringkula piipa wakara wantirriyaṉu mayutju Tarayatjalakutu, Papilunanya ngurrara tjuṯaku mayutju tiṉakutu. Mayutju tiṉa Tjaratjanya mirrirrinytjala, mayutju tiṉa Tarayatjanya tjanampa nyinangi, tawunu Papilunangka. Piipangka yalatji Tatinayalu wakara wantirriyaṉu mayutju Tarayatjalakutu. “Tjuwu tjuṯangkuya mayutju Katutjaku tjaatji tiṉa palyaṉi. Tjana watjaṉulanyatju mayutju Tjaratjalu yirriṯi watjaṉutjangka tjaatji palunya palyantjaku. Tjinguru yalatji yiltaya Tjuwu tjuṯangku watjaṉu, tjinguru wiya. Puṯuṉa kuliṉi. Tjinguru watjantjawiyangka palyantjawiyangkuya wantinytjaku. Wangka ngaatjanyaṉanta wakaṉutja nyuntu palya piipa tjuṯangka taaṉamilara nyawa!, mayutju Tjaratjalu wakaṉutja. Yalatji wakanmara, ‘Tjuwu tjuṯangkuya tjaatji palunya Tjarutjalumangka palyantjaku.’” Piipa yalatji Tatinayalu wakara wantirriyaṉu mayutju Tarayatjalakutu. Palunyangka mayutju paluru piipa tjuṯangka taaṉamilara wangka panyapangka nyangu. Yilta paluru Tjaratjalu tjananya yirriṯi wakara watjaṉu tjaatji tiṉa Tjarutjalumangkaya palyantjaku. Piipa palunya nyakula Tarayatjalu piipa kutjupa wakara wantirriyaṉu kamantaku mayutju Tatinayalakutu. Piipa palunyangka watjaṉu palyaya Tjuwu tjuṯangku Katutjaku tjaatji kutu palyara pinitjimilantjaku. Palunyatjanuya tjaatji tiṉa palyara pinitjimilaṉu. Yalatjiya pinitjimilara Tjuwu tjuṯaya yunyparringkula Katutjaku tjawirrilyi pungkula kutjara Katutjanyalpiya waḻkuṉangi. ");
INSERT INTO piu2006_vpl VALUES ("ER7_1","016_7_1","EZR","7","1","28","(7:1—10:24) Patjanya ngurrara tjuṯaku mayutju tiṉa yini Yatikatjatjinya ngurra Papilunala nyinanytjala, wati Yitjaranya Katutjaku tuḻkuku mayutju nyinangi, Muutjaku luwu tjananya nintilpayi. Mayutju tiṉa paluru Yitjaranya yalatji watjaṉu, “Tjuwu tjuṯaya ngurra Tjarutjalumalakutu yankunytjakuya yunytjurringanyi. Palulanguru nyuntu mayutjulu tjananya kati!, ngurra palulakutu. Tjawirrilyi yalatjiya mantjira kati!, kuulta tjuṯa, tjiilpa tjuṯa, yulytja tjuṯaṯarra. Katirra tjawirrilyi palunya Katutjaku tjaatji tiṉangka tjurra!” Mayutju paluru Yitjaranya piyuku watjaṉu yalatji, “Tjarutjalumanya ngurrara tjuṯa tjinguru mayutju Katutjaku tjukarurru nyinanyi, tjinguru wiya. Nyuntu yarra nyakula tjananya nintila!, Katutjaku luwu. Nyuntu yankula tjanampa kamantaku mayutju tjuṯa nyinatjurra!, yaṉṯayaṉṯara tjananya kanyintjaku.” Palulanguru Tjuwu tjuṯaya Yitjaranyangarri tawunu Papilunangka tjungurringu, Tjarutjalumalakutu yankukitja. Mayutju Katutjanyaya tjapiṉu, yaṉṯayaṉṯara tjananya katiyankunytjaku ngurra palulakutu. Wati tjuṯalingku waan tjawutjunan payip antaṯa tjunguya yanu, kungka tjuṯa anta pipirri tjuṯaṯarra. Tjarutjalumangka tjarrparra Yitjaralu tjananya nyangu Katutjaku wiyawana nyinanytjala. Tjuwu tjuṯangkuya kungka kutjupa kutjupa ngurrara tjuṯa tjananya yaḻṯirra kanyiṉangi. Muutjaku luwu tjanampa ngarangu kungka Tjuwu kutjuya ngurra walytja ngurrara kutjuya aḻṯirra kanyintjaku, wiya kungka Tjuwuwiya ngurra kutjupatjanu yaḻṯirra kanyintjaku. Palunyatjanu Yitjaralu tjananya payiṉu kungka kutjupa tjuṯa kanyira Katutjaku luwu kilytjuntankunytjala. Kuṉṯarringkulaya Katutjaku tjukarurru nyinakitjangku kungka kutjupa ngurrara tjuṯa tjananya watjara wantirriyaṉu. ");
INSERT INTO piu2006_vpl VALUES ("ER8_1","016_8_1","EZR","8","1","36","(7:1—10:24) Patjanya ngurrara tjuṯaku mayutju tiṉa yini Yatikatjatjinya ngurra Papilunala nyinanytjala, wati Yitjaranya Katutjaku tuḻkuku mayutju nyinangi, Muutjaku luwu tjananya nintilpayi. Mayutju tiṉa paluru Yitjaranya yalatji watjaṉu, “Tjuwu tjuṯaya ngurra Tjarutjalumalakutu yankunytjakuya yunytjurringanyi. Palulanguru nyuntu mayutjulu tjananya kati!, ngurra palulakutu. Tjawirrilyi yalatjiya mantjira kati!, kuulta tjuṯa, tjiilpa tjuṯa, yulytja tjuṯaṯarra. Katirra tjawirrilyi palunya Katutjaku tjaatji tiṉangka tjurra!” Mayutju paluru Yitjaranya piyuku watjaṉu yalatji, “Tjarutjalumanya ngurrara tjuṯa tjinguru mayutju Katutjaku tjukarurru nyinanyi, tjinguru wiya. Nyuntu yarra nyakula tjananya nintila!, Katutjaku luwu. Nyuntu yankula tjanampa kamantaku mayutju tjuṯa nyinatjurra!, yaṉṯayaṉṯara tjananya kanyintjaku.” Palulanguru Tjuwu tjuṯaya Yitjaranyangarri tawunu Papilunangka tjungurringu, Tjarutjalumalakutu yankukitja. Mayutju Katutjanyaya tjapiṉu, yaṉṯayaṉṯara tjananya katiyankunytjaku ngurra palulakutu. Wati tjuṯalingku waan tjawutjunan payip antaṯa tjunguya yanu, kungka tjuṯa anta pipirri tjuṯaṯarra. Tjarutjalumangka tjarrparra Yitjaralu tjananya nyangu Katutjaku wiyawana nyinanytjala. Tjuwu tjuṯangkuya kungka kutjupa kutjupa ngurrara tjuṯa tjananya yaḻṯirra kanyiṉangi. Muutjaku luwu tjanampa ngarangu kungka Tjuwu kutjuya ngurra walytja ngurrara kutjuya aḻṯirra kanyintjaku, wiya kungka Tjuwuwiya ngurra kutjupatjanu yaḻṯirra kanyintjaku. Palunyatjanu Yitjaralu tjananya payiṉu kungka kutjupa tjuṯa kanyira Katutjaku luwu kilytjuntankunytjala. Kuṉṯarringkulaya Katutjaku tjukarurru nyinakitjangku kungka kutjupa ngurrara tjuṯa tjananya watjara wantirriyaṉu. ");
INSERT INTO piu2006_vpl VALUES ("ER9_1","016_9_1","EZR","9","1","15","(7:1—10:24) Patjanya ngurrara tjuṯaku mayutju tiṉa yini Yatikatjatjinya ngurra Papilunala nyinanytjala, wati Yitjaranya Katutjaku tuḻkuku mayutju nyinangi, Muutjaku luwu tjananya nintilpayi. Mayutju tiṉa paluru Yitjaranya yalatji watjaṉu, “Tjuwu tjuṯaya ngurra Tjarutjalumalakutu yankunytjakuya yunytjurringanyi. Palulanguru nyuntu mayutjulu tjananya kati!, ngurra palulakutu. Tjawirrilyi yalatjiya mantjira kati!, kuulta tjuṯa, tjiilpa tjuṯa, yulytja tjuṯaṯarra. Katirra tjawirrilyi palunya Katutjaku tjaatji tiṉangka tjurra!” Mayutju paluru Yitjaranya piyuku watjaṉu yalatji, “Tjarutjalumanya ngurrara tjuṯa tjinguru mayutju Katutjaku tjukarurru nyinanyi, tjinguru wiya. Nyuntu yarra nyakula tjananya nintila!, Katutjaku luwu. Nyuntu yankula tjanampa kamantaku mayutju tjuṯa nyinatjurra!, yaṉṯayaṉṯara tjananya kanyintjaku.” Palulanguru Tjuwu tjuṯaya Yitjaranyangarri tawunu Papilunangka tjungurringu, Tjarutjalumalakutu yankukitja. Mayutju Katutjanyaya tjapiṉu, yaṉṯayaṉṯara tjananya katiyankunytjaku ngurra palulakutu. Wati tjuṯalingku waan tjawutjunan payip antaṯa tjunguya yanu, kungka tjuṯa anta pipirri tjuṯaṯarra. Tjarutjalumangka tjarrparra Yitjaralu tjananya nyangu Katutjaku wiyawana nyinanytjala. Tjuwu tjuṯangkuya kungka kutjupa kutjupa ngurrara tjuṯa tjananya yaḻṯirra kanyiṉangi. Muutjaku luwu tjanampa ngarangu kungka Tjuwu kutjuya ngurra walytja ngurrara kutjuya aḻṯirra kanyintjaku, wiya kungka Tjuwuwiya ngurra kutjupatjanu yaḻṯirra kanyintjaku. Palunyatjanu Yitjaralu tjananya payiṉu kungka kutjupa tjuṯa kanyira Katutjaku luwu kilytjuntankunytjala. Kuṉṯarringkulaya Katutjaku tjukarurru nyinakitjangku kungka kutjupa ngurrara tjuṯa tjananya watjara wantirriyaṉu. ");
INSERT INTO piu2006_vpl VALUES ("ER10_1","016_10_1","EZR","10","1","44","(7:1—10:24) Patjanya ngurrara tjuṯaku mayutju tiṉa yini Yatikatjatjinya ngurra Papilunala nyinanytjala, wati Yitjaranya Katutjaku tuḻkuku mayutju nyinangi, Muutjaku luwu tjananya nintilpayi. Mayutju tiṉa paluru Yitjaranya yalatji watjaṉu, “Tjuwu tjuṯaya ngurra Tjarutjalumalakutu yankunytjakuya yunytjurringanyi. Palulanguru nyuntu mayutjulu tjananya kati!, ngurra palulakutu. Tjawirrilyi yalatjiya mantjira kati!, kuulta tjuṯa, tjiilpa tjuṯa, yulytja tjuṯaṯarra. Katirra tjawirrilyi palunya Katutjaku tjaatji tiṉangka tjurra!” Mayutju paluru Yitjaranya piyuku watjaṉu yalatji, “Tjarutjalumanya ngurrara tjuṯa tjinguru mayutju Katutjaku tjukarurru nyinanyi, tjinguru wiya. Nyuntu yarra nyakula tjananya nintila!, Katutjaku luwu. Nyuntu yankula tjanampa kamantaku mayutju tjuṯa nyinatjurra!, yaṉṯayaṉṯara tjananya kanyintjaku.” Palulanguru Tjuwu tjuṯaya Yitjaranyangarri tawunu Papilunangka tjungurringu, Tjarutjalumalakutu yankukitja. Mayutju Katutjanyaya tjapiṉu, yaṉṯayaṉṯara tjananya katiyankunytjaku ngurra palulakutu. Wati tjuṯalingku waan tjawutjunan payip antaṯa tjunguya yanu, kungka tjuṯa anta pipirri tjuṯaṯarra. Tjarutjalumangka tjarrparra Yitjaralu tjananya nyangu Katutjaku wiyawana nyinanytjala. Tjuwu tjuṯangkuya kungka kutjupa kutjupa ngurrara tjuṯa tjananya yaḻṯirra kanyiṉangi. Muutjaku luwu tjanampa ngarangu kungka Tjuwu kutjuya ngurra walytja ngurrara kutjuya aḻṯirra kanyintjaku, wiya kungka Tjuwuwiya ngurra kutjupatjanu yaḻṯirra kanyintjaku. Palunyatjanu Yitjaralu tjananya payiṉu kungka kutjupa tjuṯa kanyira Katutjaku luwu kilytjuntankunytjala. Kuṉṯarringkulaya Katutjaku tjukarurru nyinakitjangku kungka kutjupa ngurrara tjuṯa tjananya watjara wantirriyaṉu. ");
INSERT INTO piu2006_vpl VALUES ("NH1_1","017_1_1","NEH","1","1","11","(1:1—4:17) Papilunanya ngurrara tjuṯawana wati Niyamayanya nyinangi, tawunu Tjuutjangka. Nyinarra tjakulpa kuliṉu, Tjarutjalumanya ngurrara tjuṯangkuya waaḻa kutju palyara wantingu, palulanguru tjana purrkarringuya. Parriki tiṉaṯarra tjana palyalwiyangku wantingu. Parriki tiṉa yirriṯi kutju ngarangi waaḻa tjuṯa ngarangitja, ngururrtjunkula. Parriki palunya puḻitjanu palyaṉutja yirriṯi ngarangi. Tjakulpa kulira wati Niyamayalu mayutju tiṉa Yatikatjatjinya tjapiṉu, Tjarutjalumalakutu Niyamayalungarri yankula parriki waaḻaṯarra palyantjaku. Mayutju paluru yuwa wangkarra yalatji watjaṉu, “Piipaṉanta wakara yungku, tiimpa kanyilpayi tjuṯakutu nyuntu katirra yungkunytjaku, tjanaya tiimpa yatura Tjarutjalumalakutu katinytjaku, nyurrangarrimpa.” Mayutju tiṉa paluru piipa kutjupa tjuṯaṯarra wakara yungu, Niyamayaku, paluru katirra mayutju kutjupa tjuṯaku yungkunytjaku, tjanaya Niyamayakungarri tiimpa puḻi tjuṯa katirra tjunkunytjaku. Mayutju tiṉa paluru watjantjala tjilirratjarra tjuṯangku tjananya Tjarutjalumalakutu katingu Niyamayanya an palumpa waarrkana tjuṯaṯarra. Niyamayanyangarri Tjuwu tjuṯa nyinangu. Tjarutjalumangka yankula nyinarra mungangka pakara Niyamayanya anta palumpa maḻpa tjirripala waaḻangka tjayiṯiwana yanangi. Yalatjiya yanangi parriki tiṉa yirriṯi yuḻpuṉutjawana tjanaya nyakula piyuku palyantjaku wangkayinangi. Parra nyakuyinkulaya tjana rayitpayiki yanu, tjiṉṯu pakantjala. Palulanguru tjana tjungurringu mayutju kutjupa tjuṯangka anta, yaṉangu kutjupa tjuṯangkaṯarra. Niyamayalungarri paluru tjanaya yalatji marrkuṉu, “Yunytjuwiya tjuṯangku nganaṉanya ngalya yankula pungkupayingkamarra kulira nganaṉa nguḻu nyinanyi. Palunya tjuṯangkamarra nganaṉa tjungungku waarrkarringkula palyantjaku, parriki tiṉa yirriṯi ngarangitja nguwanpa.” Wangka kutjupaṯarra tjanala watjaṉu mayutju tiṉa paluru Yatikatjatjilu waaḻa anta parriki palyantjaku watjara wantingu. Palulanguru tjana waarrkarringuya, parriki tiṉaya palyalkitja. Tjamiriyanya ngurrara tjuṯangkuya kuliṉu tjanaya parriki palyantjala. Kuliraya tjungurringkula wangkangu yankula tjananya pikangku pungkunytjaku. Niyamayalungarri tjakulpa kulira nguḻurringkula Katutjala tjapiṉu paluru tjananya yaṉṯayaṉṯantjaku. Yalatji kuliraya Tjarutjalumanya ngurrara tjuṯa yaḻṯingu tjungurringkunytjaku. Miitingiya wangkarra wiyarringu. Palulanguru kutjupa tjuṯangku parriki palyaṉingi, kutjupa tjuṯangku ngarala yaṉṯayaṉṯalpayi, tjilirratjarra tjuṯangku. Tjamiriya ngurrara tjuṯangkamarraya yalatji tjana aapangku ngarala nyakunytjala, aapa kutjupangkuya parriki palyara wiyaṉu. Tuuwa tjuṯaṯarraya tiimpatjanu palyara ngaratjunkula wanaṉu. ");
INSERT INTO piu2006_vpl VALUES ("NH2_1","017_2_1","NEH","2","1","20","(1:1—4:17) Papilunanya ngurrara tjuṯawana wati Niyamayanya nyinangi, tawunu Tjuutjangka. Nyinarra tjakulpa kuliṉu, Tjarutjalumanya ngurrara tjuṯangkuya waaḻa kutju palyara wantingu, palulanguru tjana purrkarringuya. Parriki tiṉaṯarra tjana palyalwiyangku wantingu. Parriki tiṉa yirriṯi kutju ngarangi waaḻa tjuṯa ngarangitja, ngururrtjunkula. Parriki palunya puḻitjanu palyaṉutja yirriṯi ngarangi. Tjakulpa kulira wati Niyamayalu mayutju tiṉa Yatikatjatjinya tjapiṉu, Tjarutjalumalakutu Niyamayalungarri yankula parriki waaḻaṯarra palyantjaku. Mayutju paluru yuwa wangkarra yalatji watjaṉu, “Piipaṉanta wakara yungku, tiimpa kanyilpayi tjuṯakutu nyuntu katirra yungkunytjaku, tjanaya tiimpa yatura Tjarutjalumalakutu katinytjaku, nyurrangarrimpa.” Mayutju tiṉa paluru piipa kutjupa tjuṯaṯarra wakara yungu, Niyamayaku, paluru katirra mayutju kutjupa tjuṯaku yungkunytjaku, tjanaya Niyamayakungarri tiimpa puḻi tjuṯa katirra tjunkunytjaku. Mayutju tiṉa paluru watjantjala tjilirratjarra tjuṯangku tjananya Tjarutjalumalakutu katingu Niyamayanya an palumpa waarrkana tjuṯaṯarra. Niyamayanyangarri Tjuwu tjuṯa nyinangu. Tjarutjalumangka yankula nyinarra mungangka pakara Niyamayanya anta palumpa maḻpa tjirripala waaḻangka tjayiṯiwana yanangi. Yalatjiya yanangi parriki tiṉa yirriṯi yuḻpuṉutjawana tjanaya nyakula piyuku palyantjaku wangkayinangi. Parra nyakuyinkulaya tjana rayitpayiki yanu, tjiṉṯu pakantjala. Palulanguru tjana tjungurringu mayutju kutjupa tjuṯangka anta, yaṉangu kutjupa tjuṯangkaṯarra. Niyamayalungarri paluru tjanaya yalatji marrkuṉu, “Yunytjuwiya tjuṯangku nganaṉanya ngalya yankula pungkupayingkamarra kulira nganaṉa nguḻu nyinanyi. Palunya tjuṯangkamarra nganaṉa tjungungku waarrkarringkula palyantjaku, parriki tiṉa yirriṯi ngarangitja nguwanpa.” Wangka kutjupaṯarra tjanala watjaṉu mayutju tiṉa paluru Yatikatjatjilu waaḻa anta parriki palyantjaku watjara wantingu. Palulanguru tjana waarrkarringuya, parriki tiṉaya palyalkitja. Tjamiriyanya ngurrara tjuṯangkuya kuliṉu tjanaya parriki palyantjala. Kuliraya tjungurringkula wangkangu yankula tjananya pikangku pungkunytjaku. Niyamayalungarri tjakulpa kulira nguḻurringkula Katutjala tjapiṉu paluru tjananya yaṉṯayaṉṯantjaku. Yalatji kuliraya Tjarutjalumanya ngurrara tjuṯa yaḻṯingu tjungurringkunytjaku. Miitingiya wangkarra wiyarringu. Palulanguru kutjupa tjuṯangku parriki palyaṉingi, kutjupa tjuṯangku ngarala yaṉṯayaṉṯalpayi, tjilirratjarra tjuṯangku. Tjamiriya ngurrara tjuṯangkamarraya yalatji tjana aapangku ngarala nyakunytjala, aapa kutjupangkuya parriki palyara wiyaṉu. Tuuwa tjuṯaṯarraya tiimpatjanu palyara ngaratjunkula wanaṉu. ");
INSERT INTO piu2006_vpl VALUES ("NH3_1","017_3_1","NEH","3","1","32","(1:1—4:17) Papilunanya ngurrara tjuṯawana wati Niyamayanya nyinangi, tawunu Tjuutjangka. Nyinarra tjakulpa kuliṉu, Tjarutjalumanya ngurrara tjuṯangkuya waaḻa kutju palyara wantingu, palulanguru tjana purrkarringuya. Parriki tiṉaṯarra tjana palyalwiyangku wantingu. Parriki tiṉa yirriṯi kutju ngarangi waaḻa tjuṯa ngarangitja, ngururrtjunkula. Parriki palunya puḻitjanu palyaṉutja yirriṯi ngarangi. Tjakulpa kulira wati Niyamayalu mayutju tiṉa Yatikatjatjinya tjapiṉu, Tjarutjalumalakutu Niyamayalungarri yankula parriki waaḻaṯarra palyantjaku. Mayutju paluru yuwa wangkarra yalatji watjaṉu, “Piipaṉanta wakara yungku, tiimpa kanyilpayi tjuṯakutu nyuntu katirra yungkunytjaku, tjanaya tiimpa yatura Tjarutjalumalakutu katinytjaku, nyurrangarrimpa.” Mayutju tiṉa paluru piipa kutjupa tjuṯaṯarra wakara yungu, Niyamayaku, paluru katirra mayutju kutjupa tjuṯaku yungkunytjaku, tjanaya Niyamayakungarri tiimpa puḻi tjuṯa katirra tjunkunytjaku. Mayutju tiṉa paluru watjantjala tjilirratjarra tjuṯangku tjananya Tjarutjalumalakutu katingu Niyamayanya an palumpa waarrkana tjuṯaṯarra. Niyamayanyangarri Tjuwu tjuṯa nyinangu. Tjarutjalumangka yankula nyinarra mungangka pakara Niyamayanya anta palumpa maḻpa tjirripala waaḻangka tjayiṯiwana yanangi. Yalatjiya yanangi parriki tiṉa yirriṯi yuḻpuṉutjawana tjanaya nyakula piyuku palyantjaku wangkayinangi. Parra nyakuyinkulaya tjana rayitpayiki yanu, tjiṉṯu pakantjala. Palulanguru tjana tjungurringu mayutju kutjupa tjuṯangka anta, yaṉangu kutjupa tjuṯangkaṯarra. Niyamayalungarri paluru tjanaya yalatji marrkuṉu, “Yunytjuwiya tjuṯangku nganaṉanya ngalya yankula pungkupayingkamarra kulira nganaṉa nguḻu nyinanyi. Palunya tjuṯangkamarra nganaṉa tjungungku waarrkarringkula palyantjaku, parriki tiṉa yirriṯi ngarangitja nguwanpa.” Wangka kutjupaṯarra tjanala watjaṉu mayutju tiṉa paluru Yatikatjatjilu waaḻa anta parriki palyantjaku watjara wantingu. Palulanguru tjana waarrkarringuya, parriki tiṉaya palyalkitja. Tjamiriyanya ngurrara tjuṯangkuya kuliṉu tjanaya parriki palyantjala. Kuliraya tjungurringkula wangkangu yankula tjananya pikangku pungkunytjaku. Niyamayalungarri tjakulpa kulira nguḻurringkula Katutjala tjapiṉu paluru tjananya yaṉṯayaṉṯantjaku. Yalatji kuliraya Tjarutjalumanya ngurrara tjuṯa yaḻṯingu tjungurringkunytjaku. Miitingiya wangkarra wiyarringu. Palulanguru kutjupa tjuṯangku parriki palyaṉingi, kutjupa tjuṯangku ngarala yaṉṯayaṉṯalpayi, tjilirratjarra tjuṯangku. Tjamiriya ngurrara tjuṯangkamarraya yalatji tjana aapangku ngarala nyakunytjala, aapa kutjupangkuya parriki palyara wiyaṉu. Tuuwa tjuṯaṯarraya tiimpatjanu palyara ngaratjunkula wanaṉu. ");
INSERT INTO piu2006_vpl VALUES ("NH4_1","017_4_1","NEH","4","1","17","(1:1—4:17) Papilunanya ngurrara tjuṯawana wati Niyamayanya nyinangi, tawunu Tjuutjangka. Nyinarra tjakulpa kuliṉu, Tjarutjalumanya ngurrara tjuṯangkuya waaḻa kutju palyara wantingu, palulanguru tjana purrkarringuya. Parriki tiṉaṯarra tjana palyalwiyangku wantingu. Parriki tiṉa yirriṯi kutju ngarangi waaḻa tjuṯa ngarangitja, ngururrtjunkula. Parriki palunya puḻitjanu palyaṉutja yirriṯi ngarangi. Tjakulpa kulira wati Niyamayalu mayutju tiṉa Yatikatjatjinya tjapiṉu, Tjarutjalumalakutu Niyamayalungarri yankula parriki waaḻaṯarra palyantjaku. Mayutju paluru yuwa wangkarra yalatji watjaṉu, “Piipaṉanta wakara yungku, tiimpa kanyilpayi tjuṯakutu nyuntu katirra yungkunytjaku, tjanaya tiimpa yatura Tjarutjalumalakutu katinytjaku, nyurrangarrimpa.” Mayutju tiṉa paluru piipa kutjupa tjuṯaṯarra wakara yungu, Niyamayaku, paluru katirra mayutju kutjupa tjuṯaku yungkunytjaku, tjanaya Niyamayakungarri tiimpa puḻi tjuṯa katirra tjunkunytjaku. Mayutju tiṉa paluru watjantjala tjilirratjarra tjuṯangku tjananya Tjarutjalumalakutu katingu Niyamayanya an palumpa waarrkana tjuṯaṯarra. Niyamayanyangarri Tjuwu tjuṯa nyinangu. Tjarutjalumangka yankula nyinarra mungangka pakara Niyamayanya anta palumpa maḻpa tjirripala waaḻangka tjayiṯiwana yanangi. Yalatjiya yanangi parriki tiṉa yirriṯi yuḻpuṉutjawana tjanaya nyakula piyuku palyantjaku wangkayinangi. Parra nyakuyinkulaya tjana rayitpayiki yanu, tjiṉṯu pakantjala. Palulanguru tjana tjungurringu mayutju kutjupa tjuṯangka anta, yaṉangu kutjupa tjuṯangkaṯarra. Niyamayalungarri paluru tjanaya yalatji marrkuṉu, “Yunytjuwiya tjuṯangku nganaṉanya ngalya yankula pungkupayingkamarra kulira nganaṉa nguḻu nyinanyi. Palunya tjuṯangkamarra nganaṉa tjungungku waarrkarringkula palyantjaku, parriki tiṉa yirriṯi ngarangitja nguwanpa.” Wangka kutjupaṯarra tjanala watjaṉu mayutju tiṉa paluru Yatikatjatjilu waaḻa anta parriki palyantjaku watjara wantingu. Palulanguru tjana waarrkarringuya, parriki tiṉaya palyalkitja. Tjamiriyanya ngurrara tjuṯangkuya kuliṉu tjanaya parriki palyantjala. Kuliraya tjungurringkula wangkangu yankula tjananya pikangku pungkunytjaku. Niyamayalungarri tjakulpa kulira nguḻurringkula Katutjala tjapiṉu paluru tjananya yaṉṯayaṉṯantjaku. Yalatji kuliraya Tjarutjalumanya ngurrara tjuṯa yaḻṯingu tjungurringkunytjaku. Miitingiya wangkarra wiyarringu. Palulanguru kutjupa tjuṯangku parriki palyaṉingi, kutjupa tjuṯangku ngarala yaṉṯayaṉṯalpayi, tjilirratjarra tjuṯangku. Tjamiriya ngurrara tjuṯangkamarraya yalatji tjana aapangku ngarala nyakunytjala, aapa kutjupangkuya parriki palyara wiyaṉu. Tuuwa tjuṯaṯarraya tiimpatjanu palyara ngaratjunkula wanaṉu. ");
INSERT INTO piu2006_vpl VALUES ("NH8_1","017_8_1","NEH","8","1","10","(8:1-10; 9:1-3; 10:10-39) Palunyatjanu Tjuwu tjuṯaya Tjarutjalumangka tjungurringu, ila ngurrara tjuṯaṯarra. Wati Yitjaranyaya tjapiṉu Katutjaku wangka piipa mantjira ngalya katirra riitarrinytjaku. Piipa mantjira aaḻi tiipula nguwanpangka kaḻparra ngarala tjanampa riitarringkula kaḻaḻarringu. Riitarrinytjala yaṉangu yuwankarrangkuya, wati tjuṯangku, kungka tjuṯangku pipirri tjuṯangkuṯarra yarrkangku kuliṉangi. Yitjaralu Yipuru wangka riitarrinytjala kutjupa tjuṯangku tjanampa taaṉamilalpayi Yaramayika wangkaya, tjukarurrungku kulintjaku. Wangka Yaramayikakuya ngaṉṯitja tjuṯa nintirringu ngurra Papilunangka nyinarra. Katutjaku wangka yutiya kulira yulangi, wiyawana nyinangutja. Palunyangka mayutju tjuṯangku tjananya marrkuṉu, “Yulawiyaya ngarama!, kuwarrila yunyparringkula Katutjanya waḻkuntjaku. Yuḻṯa tiṉa ngaatjanya ngaranyi.” Palulanguru tjiṉṯu kutjupangkaya yaṉangu tjuṯangku Katutjanya tjakultjunu, kuya palyaraya nyinangutja. Katutjaku tjukarurru nyinakitjaya tjananya piipangka yini tjunu. Yuwankarraya wangkangu Katutjaku wangkawanaya tjukarurru nyinanytjaku. Katutjaku wangka palunya Muutjalu piipangka yirriṯi wakaṉu. ");
INSERT INTO piu2006_vpl VALUES ("NH9_1","017_9_1","NEH","9","1","3","(8:1-10; 9:1-3; 10:10-39) Palunyatjanu Tjuwu tjuṯaya Tjarutjalumangka tjungurringu, ila ngurrara tjuṯaṯarra. Wati Yitjaranyaya tjapiṉu Katutjaku wangka piipa mantjira ngalya katirra riitarrinytjaku. Piipa mantjira aaḻi tiipula nguwanpangka kaḻparra ngarala tjanampa riitarringkula kaḻaḻarringu. Riitarrinytjala yaṉangu yuwankarrangkuya, wati tjuṯangku, kungka tjuṯangku pipirri tjuṯangkuṯarra yarrkangku kuliṉangi. Yitjaralu Yipuru wangka riitarrinytjala kutjupa tjuṯangku tjanampa taaṉamilalpayi Yaramayika wangkaya, tjukarurrungku kulintjaku. Wangka Yaramayikakuya ngaṉṯitja tjuṯa nintirringu ngurra Papilunangka nyinarra. Katutjaku wangka yutiya kulira yulangi, wiyawana nyinangutja. Palunyangka mayutju tjuṯangku tjananya marrkuṉu, “Yulawiyaya ngarama!, kuwarrila yunyparringkula Katutjanya waḻkuntjaku. Yuḻṯa tiṉa ngaatjanya ngaranyi.” Palulanguru tjiṉṯu kutjupangkaya yaṉangu tjuṯangku Katutjanya tjakultjunu, kuya palyaraya nyinangutja. Katutjaku tjukarurru nyinakitjaya tjananya piipangka yini tjunu. Yuwankarraya wangkangu Katutjaku wangkawanaya tjukarurru nyinanytjaku. Katutjaku wangka palunya Muutjalu piipangka yirriṯi wakaṉu. ");
INSERT INTO piu2006_vpl VALUES ("NH10_10","017_10_10","NEH","10","10","39","(8:1-10; 9:1-3; 10:10-39) Palunyatjanu Tjuwu tjuṯaya Tjarutjalumangka tjungurringu, ila ngurrara tjuṯaṯarra. Wati Yitjaranyaya tjapiṉu Katutjaku wangka piipa mantjira ngalya katirra riitarrinytjaku. Piipa mantjira aaḻi tiipula nguwanpangka kaḻparra ngarala tjanampa riitarringkula kaḻaḻarringu. Riitarrinytjala yaṉangu yuwankarrangkuya, wati tjuṯangku, kungka tjuṯangku pipirri tjuṯangkuṯarra yarrkangku kuliṉangi. Yitjaralu Yipuru wangka riitarrinytjala kutjupa tjuṯangku tjanampa taaṉamilalpayi Yaramayika wangkaya, tjukarurrungku kulintjaku. Wangka Yaramayikakuya ngaṉṯitja tjuṯa nintirringu ngurra Papilunangka nyinarra. Katutjaku wangka yutiya kulira yulangi, wiyawana nyinangutja. Palunyangka mayutju tjuṯangku tjananya marrkuṉu, “Yulawiyaya ngarama!, kuwarrila yunyparringkula Katutjanya waḻkuntjaku. Yuḻṯa tiṉa ngaatjanya ngaranyi.” Palulanguru tjiṉṯu kutjupangkaya yaṉangu tjuṯangku Katutjanya tjakultjunu, kuya palyaraya nyinangutja. Katutjaku tjukarurru nyinakitjaya tjananya piipangka yini tjunu. Yuwankarraya wangkangu Katutjaku wangkawanaya tjukarurru nyinanytjaku. Katutjaku wangka palunya Muutjalu piipangka yirriṯi wakaṉu. ");
INSERT INTO piu2006_vpl VALUES ("JB1_1","019_1_1","JOB","1","1","3","Wati Tjuupanya Katutjaku tjukarurru nyinangi. Miiṯararrapula nyinarra katja tjapanpala mantjiṉu, yuṉṯalpa tjirripalaṯarra. Tjuupalu tjanampa rawangku kuka tjawirrilyi pungkupayi. Pungkula tjawirrilyi yungkupayi tuḻkuku mayutjungku kutjantjaku, Katutjalu kuya tjanampa waṉinytjaku. Mani tiṉa anta yulytja tiṉatjarra Tjuupanya yalatji nyinangu. Yalatji paluru kanyiṉangi, tjiipi tjuṯalingku tjawutjuna tjapanpala, kamula tjuṯalingku tjawutjuna tjirripala, puluka tjuṯa tjawutjuna kutju, tuungkiyi tjuṯaṯarra yantaṯa payipala. Yalatjira wati Tjuupaku ngarangu. ");
INSERT INTO piu2006_vpl VALUES ("JB1_6","019_1_6","JOB","1","6","12","Yilkari ngurrara tjuṯaya mamuku mayutjuṯarra Katutjala tjungurringu. Palunyangka Katutjalu mamuku mayutjungka yalatji tjapiṉu, “Kuwarri yaalytjinguru nyuntu ngalya yanu?” Mamuku mayutju paluru watjaṉu, “Manta tjuṯawanaṉa yankulaṉa ngalya yanu.” Katutjalu tjapiṉu, “Ngayuku walytja wati Tjuupanya palya nyinanytjala nyuntu nyangu, yilta?” Yalatji tjapira paluru Tjuupanya waḻkuṉu yalatji, “Yaṉangu kutjupa tjuṯangka wirriḻi Tjuupanya ngayuku tjukarurru nyinanyi. Ngayunya paluru tjukarurrungku waḻkulpayi, kutu, kuya palyantjawiya.” Mamuku mayutjungku watjaṉu, “Nyuntu palumpa kutu tjukarurru palyantjala Tjuupanya nyuntupa tjukarurru nyinanyi. Kala nyuntu tjukarurru palyalwiyangku wantinytjala, wiyanta nyuntunya kutu waḻkulku. Tjuupanyangarri tjananya nyuntu kutu yaṉṯayaṉṯalpayi. Nyuntu tjanampa kutu mayi anta kapi yungkupayi. Palumpa kuka tjuṯa nyuntu tjuṯalingku nyinatjunu.” Mamuku mayutjungku Katutjanya piyuku watjaṉu, “Waṯalpi nyuntu palumpa waaḻa yulytjaṯarra yuḻpura wiyala! Palumpa walytja tjuṯa kuka tjuṯaṯarra mirrintarra wiyala! Yalatjinu wiyantjala, wantirranta wiya waḻkulku. Maralpa nyinarra nyuntunya panypurangkula wantiku.” Katutjalu kulira yalatji watjaṉu mamuku mayutjunya, “Palya nyuntu yankula Tjuupanya yarrkala! Palumpa waaḻa yulytjaṯarra yuḻpura wiyala! Palumpa walytja tjuṯa mirrintarra wiyala!, palumpa kuka tjuṯaṯarra. Tjuupanya kutju wanti!, mirrintankunytjawiyangku.” Yalatji Tjuupanya yarrkara kuyalkitja mamuku mayutju paṉakutu yanu. ");
INSERT INTO piu2006_vpl VALUES ("JB1_13","019_1_13","JOB","1","13","22","Tjuupanya ngurrangka nyinanytjala, palumpa waarrkanangku ngalya yankula alatji tjakultjunu, “Nganaṉatju waarrka pulukatjarrangku paṉa yuḻpurinkupayi. Palunyatjanu wati tjikipaka tjuṯangkulanyatju pikangku pungkula puluka uwankarra katingu, tuungkiyi tjuṯaṯarra, Tjapiyanya ngurrara tjuṯangku. Paluru tjana nyuntupa waarrkana tjuṯaṯarra tjananya mirri pungu. Ngayulu kutjuṉa kanarringkula ngalya yanu.” Palunyatjanu waarrkana kutjupangku ngalya tjalkaḻungkula Tjuupanya yalatji tjakultjunu, “Kuwarri maṉngirringku rungkara tilintjala nyuntupa tjiipi tjuṯa kamparra yiluntanu. Tjiipiku mayutjuṯarra tjananya kamparra yiluntanu. Ngayulu kutjuṉa kanarringkula ngalya yanu.” Palunyatjanu waarrkana kutjupangku ngalya tjalkaḻungkula Tjuupanya yalatji tjakultjunu, “Tjaltjiyanya ngurrara tjuṯangkulanyatju ngalya yankula pikangku pungangi. Tjana kamulaku mayutju tjuṯa tjananya mirri pungkula tjananya kamula uwankarra katingu. Ngayulu kutjuṉa kanarringkula ngalya yanu.” Palunyatjanu waarrkana kutjupangku ngalya tjalkaḻungkula yalatji wati palula tjakultjunu, “Nyuntupa katja tjuṯa yuṉṯalpa tjuṯa waaḻa kutjungka tjarrparra tjikira ngalkula yunyparringangi. Palunyatjanu waḻpa tiṉangku tjanampa waaḻa yuḻpura waṉingu. Yuḻpura tjananya nyuntupa walytja tjuṯa paḻira yiluntanu. Ngayulu kutjuṉa kanarringkula ngalya yanu.” Kulira Tjuupanya pakara mantarra wintarrpungkula yulangi. Kata muṯura nyapara yulangi. Yularra waṯungarala yalatji watjaṉu, “Yiṯi tjukutjukuṉa maralpa yutirrirra ngarringi. Nyinarraṉa maralpa mirrirriku. Mayutju Katutjaluṉi katja tjuṯa yuṉṯalpa tjuṯa yulytja uwankarra yungu. Paluruṉi kuwarri uwankarra wiyaṉu. Walytjangku kuliraṉi uwankarra yungkula, palya katirra wiyaṉu. Katutjanya kutjuṉa kutu waḻkulku.” Yalatji uwankarra wiyarrinytjala, Tjuupalu wiya Katutjanya panypurangu. ");
INSERT INTO piu2006_vpl VALUES ("JB2_1","019_2_1","JOB","2","1","10","Mamuku mayutjungku Katutjanya tjapiṉu Tjuupanya pikatjarralkitjangku. Palunyatjanu Katutjalu yuwa watjantjala, mamuku mayutjungku yankula Tjuupanya pikatjarraṉu. Tjuupanya kutu Katutjaku tjukarurru nyinangi, panypurangkunytjawiya. Yalatji mamuku mayutjungku kuliṉingi, “Tjuupanya pikatjarrarringkula Katutjanya panypurangkula wantiku.” Palunyatjanu pika kutjupatjarra Tjuupanya nyinangu pika taḻṯu taḻṯutjarra. Mikin tiṉatjarralpi nyinarra yankula rapitjingka nyinangi. Ngurra palula rapitjiya katirra waṉipayi. Nyinarra watiyatjarrangku wakara yuṉa tjuṯa yintiṉingi. Palumpa miiṯangku yankula Tjuupanya yalatji tjingapungu, “Katutjalunta yarrkaṉi, palunyatjanu nyuntu Katutjanya kuru watjala! Nyuntu Katutjanya wantirra wiyara nyinama! Wiyanta paluru nyuntunya yaṉṯayaṉṯaṉi. Palunya nyuntu wantirra kuru watjala!” Tjuupalu palumpa miiṯa payiṉu, “Wiyawanangkun watjantjawiya. Palyalinya Katutjalu walytjalu kulira yarrkaṉi. Kutuli tjukarurru nyinanytjaku.” Yalatji Tjuupanya pikatjarra nyinarra tjukarurru nyinangi, Katutjanya panypurangkunytjawiya. ");
INSERT INTO piu2006_vpl VALUES ("JB2_11","019_2_11","JOB","2","11","13","Tjuupanya pikatjarra nyinanytjala, kulira Tjuupaku maḻpa tjirripalaya ngalya yankula tjungu nyinangi, maḻpangku kanyilkitja. Tjunguya yularra nyinangi wangkanytjawiya, tjiṉṯu tjapanpala. ");
INSERT INTO piu2006_vpl VALUES ("JB3_1","019_3_1","JOB","3","1","13","Wati Tjuupanya pikatjarra nyinarra watjilpa nyinangi, wangkanytjawiya. Rawa yalatji nyinarra yalatjilpi watjaṉu, “Maamangkuṉi yititjunkuwiyangku wantimara pipirri wiimaṉa mirrirrinytjaku. Palulanguru wiya pika tiṉatjarraṉa nyinamara.” ");
INSERT INTO piu2006_vpl VALUES ("JB4_1","019_4_1","JOB","4","1","21","(4:1—11:20) Tjuupaku maḻpa tjirripalangkuya Tjuupanya alatji watjaṉu, “Nintingkulatju kuliṉi. Nyuntu kuya tiṉa palyaṉutjangka Katutjalunta mirrpaṉarrirra pikatjarraṉi. Nyuntu kulila! Tjukarurru nyinapayi Katutjalu wiya pikatjarraṉi. Palunyatjanu nyuntu yilta kuya tiṉa palyaṉu. Palulanguru Katutjalunta pikatjarraṉi. Nyuntu kuya palyara Katutjanya tjukarurrungku tjakultjunamara.” Wangka palunya nguwanpaya tjuṯangara watjaṉu. Palunyatjanu Tjuupalu tjananya yalatji watjalpayi, “Wiya. Kuya puntu ngayuluṉa palyantjawiya. Ngayuluṉa mungutja nyinanyi, kuya tiṉa wiyaṉa palyalpayi.” ");
INSERT INTO piu2006_vpl VALUES ("JB5_1","019_5_1","JOB","5","1","27","(4:1—11:20) Tjuupaku maḻpa tjirripalangkuya Tjuupanya alatji watjaṉu, “Nintingkulatju kuliṉi. Nyuntu kuya tiṉa palyaṉutjangka Katutjalunta mirrpaṉarrirra pikatjarraṉi. Nyuntu kulila! Tjukarurru nyinapayi Katutjalu wiya pikatjarraṉi. Palunyatjanu nyuntu yilta kuya tiṉa palyaṉu. Palulanguru Katutjalunta pikatjarraṉi. Nyuntu kuya palyara Katutjanya tjukarurrungku tjakultjunamara.” Wangka palunya nguwanpaya tjuṯangara watjaṉu. Palunyatjanu Tjuupalu tjananya yalatji watjalpayi, “Wiya. Kuya puntu ngayuluṉa palyantjawiya. Ngayuluṉa mungutja nyinanyi, kuya tiṉa wiyaṉa palyalpayi.” ");
INSERT INTO piu2006_vpl VALUES ("JB6_1","019_6_1","JOB","6","1","30","(4:1—11:20) Tjuupaku maḻpa tjirripalangkuya Tjuupanya alatji watjaṉu, “Nintingkulatju kuliṉi. Nyuntu kuya tiṉa palyaṉutjangka Katutjalunta mirrpaṉarrirra pikatjarraṉi. Nyuntu kulila! Tjukarurru nyinapayi Katutjalu wiya pikatjarraṉi. Palunyatjanu nyuntu yilta kuya tiṉa palyaṉu. Palulanguru Katutjalunta pikatjarraṉi. Nyuntu kuya palyara Katutjanya tjukarurrungku tjakultjunamara.” Wangka palunya nguwanpaya tjuṯangara watjaṉu. Palunyatjanu Tjuupalu tjananya yalatji watjalpayi, “Wiya. Kuya puntu ngayuluṉa palyantjawiya. Ngayuluṉa mungutja nyinanyi, kuya tiṉa wiyaṉa palyalpayi.” ");
INSERT INTO piu2006_vpl VALUES ("JB7_1","019_7_1","JOB","7","1","21","(4:1—11:20) Tjuupaku maḻpa tjirripalangkuya Tjuupanya alatji watjaṉu, “Nintingkulatju kuliṉi. Nyuntu kuya tiṉa palyaṉutjangka Katutjalunta mirrpaṉarrirra pikatjarraṉi. Nyuntu kulila! Tjukarurru nyinapayi Katutjalu wiya pikatjarraṉi. Palunyatjanu nyuntu yilta kuya tiṉa palyaṉu. Palulanguru Katutjalunta pikatjarraṉi. Nyuntu kuya palyara Katutjanya tjukarurrungku tjakultjunamara.” Wangka palunya nguwanpaya tjuṯangara watjaṉu. Palunyatjanu Tjuupalu tjananya yalatji watjalpayi, “Wiya. Kuya puntu ngayuluṉa palyantjawiya. Ngayuluṉa mungutja nyinanyi, kuya tiṉa wiyaṉa palyalpayi.” ");
INSERT INTO piu2006_vpl VALUES ("JB8_1","019_8_1","JOB","8","1","22","(4:1—11:20) Tjuupaku maḻpa tjirripalangkuya Tjuupanya alatji watjaṉu, “Nintingkulatju kuliṉi. Nyuntu kuya tiṉa palyaṉutjangka Katutjalunta mirrpaṉarrirra pikatjarraṉi. Nyuntu kulila! Tjukarurru nyinapayi Katutjalu wiya pikatjarraṉi. Palunyatjanu nyuntu yilta kuya tiṉa palyaṉu. Palulanguru Katutjalunta pikatjarraṉi. Nyuntu kuya palyara Katutjanya tjukarurrungku tjakultjunamara.” Wangka palunya nguwanpaya tjuṯangara watjaṉu. Palunyatjanu Tjuupalu tjananya yalatji watjalpayi, “Wiya. Kuya puntu ngayuluṉa palyantjawiya. Ngayuluṉa mungutja nyinanyi, kuya tiṉa wiyaṉa palyalpayi.” ");
INSERT INTO piu2006_vpl VALUES ("JB9_1","019_9_1","JOB","9","1","35","(4:1—11:20) Tjuupaku maḻpa tjirripalangkuya Tjuupanya alatji watjaṉu, “Nintingkulatju kuliṉi. Nyuntu kuya tiṉa palyaṉutjangka Katutjalunta mirrpaṉarrirra pikatjarraṉi. Nyuntu kulila! Tjukarurru nyinapayi Katutjalu wiya pikatjarraṉi. Palunyatjanu nyuntu yilta kuya tiṉa palyaṉu. Palulanguru Katutjalunta pikatjarraṉi. Nyuntu kuya palyara Katutjanya tjukarurrungku tjakultjunamara.” Wangka palunya nguwanpaya tjuṯangara watjaṉu. Palunyatjanu Tjuupalu tjananya yalatji watjalpayi, “Wiya. Kuya puntu ngayuluṉa palyantjawiya. Ngayuluṉa mungutja nyinanyi, kuya tiṉa wiyaṉa palyalpayi.” ");
INSERT INTO piu2006_vpl VALUES ("JB10_1","019_10_1","JOB","10","1","22","(4:1—11:20) Tjuupaku maḻpa tjirripalangkuya Tjuupanya alatji watjaṉu, “Nintingkulatju kuliṉi. Nyuntu kuya tiṉa palyaṉutjangka Katutjalunta mirrpaṉarrirra pikatjarraṉi. Nyuntu kulila! Tjukarurru nyinapayi Katutjalu wiya pikatjarraṉi. Palunyatjanu nyuntu yilta kuya tiṉa palyaṉu. Palulanguru Katutjalunta pikatjarraṉi. Nyuntu kuya palyara Katutjanya tjukarurrungku tjakultjunamara.” Wangka palunya nguwanpaya tjuṯangara watjaṉu. Palunyatjanu Tjuupalu tjananya yalatji watjalpayi, “Wiya. Kuya puntu ngayuluṉa palyantjawiya. Ngayuluṉa mungutja nyinanyi, kuya tiṉa wiyaṉa palyalpayi.” ");
INSERT INTO piu2006_vpl VALUES ("JB11_1","019_11_1","JOB","11","1","20","(4:1—11:20) Tjuupaku maḻpa tjirripalangkuya Tjuupanya alatji watjaṉu, “Nintingkulatju kuliṉi. Nyuntu kuya tiṉa palyaṉutjangka Katutjalunta mirrpaṉarrirra pikatjarraṉi. Nyuntu kulila! Tjukarurru nyinapayi Katutjalu wiya pikatjarraṉi. Palunyatjanu nyuntu yilta kuya tiṉa palyaṉu. Palulanguru Katutjalunta pikatjarraṉi. Nyuntu kuya palyara Katutjanya tjukarurrungku tjakultjunamara.” Wangka palunya nguwanpaya tjuṯangara watjaṉu. Palunyatjanu Tjuupalu tjananya yalatji watjalpayi, “Wiya. Kuya puntu ngayuluṉa palyantjawiya. Ngayuluṉa mungutja nyinanyi, kuya tiṉa wiyaṉa palyalpayi.” ");
INSERT INTO piu2006_vpl VALUES ("JB19_1","019_19_1","JOB","19","1","27","(1-6,25,26,27) Tjuupalu tjananya palumpa maḻpa tjirripala yalatji watjaṉu, “Nyaakuṉinyurra aḻṯuruwiyangku panypuranganyi? Kuya puntuṉa wiya palyalpayi. Kulintjakunyurra yalatji. Katutjalu walytjangku kuliraṉi yarrkaṉi. Paluru ngayuku walytja tjuṯa, mani, yulytja uwankarra wiyaṉu yarrkalkitjangku. Palunyatjanu yaḻṯurunyurra ngayuku nyinanytjaku.” Tjuupanya watjilpa nyinarra mirrirrikitjangku kulira yalatji watjaṉu, “Yalatjiṉa kuliṉi yilkari ngurrara kutjutju patjuri nyinaku. Pikatjarra mirrirringkula ngayulu paṉarriku. Katutjanyaṉa yuti nyakuku. Paluru ngayuku walytja nyinanyi. Ngayulu yilta palunya nyakuku.” ");
INSERT INTO piu2006_vpl VALUES ("JB42_10","019_42_10","JOB","42","10","17","Palunyatjanu mayutju Katutjalu wati Tjuupanya palyara waaḻa yulytja manitjarralpi nyinatjunu. Palunyangkaraya palumpa kuṯa tjuṯangku maḻanypa tjuṯangku aḻṯururringkula kuulta mani uwankarra yungu. Palunyatjanu Katutjalu Tjuupanya uwankarra yungu mani anta yulytja tiṉa. Tjiipi tjuṯalingku, tjawutjuna puutinpala Tjuupalu kanyiṉu, kamula tjuṯaṯarra tjawutjuna tjikitjipala. Puluka tjuṯa tjawutjuna kutju paluru kanyiṉu, tuungkiyi tjuṯaṯarra tjawutjuna kutju. Yalatji Tjuupanya Katutjalu uwankarra yungu. Katja tjapanpalara yungu, yuṉṯalpa tjirripalaṯarra. Yuṉṯalpa paluru tjana yuṉpa palyaya nyinangi. Yirriṯi Tjuupalu tjiipi tjuṯa, puluka tjuṯa, kamula tjuṯa kanyilpayi. Palula tjuṯangka wirriḻi Tjuupalulpi kanyiṉu. Yirriṯi Tjuupalu mani puntu, yulytja tjuṯa kanyilpayi. Palula wirriḻi Tjuupalulpi kanyiṉu. Yalatji Tjuupanya kuka tjuṯatjarra, yulytja tiṉatjarra kutu nyinangi yiiya waan yantaṯan puutiyipala. Yalatji nyinarra paluru mirrirringu. ");
INSERT INTO piu2006_vpl VALUES ("PS137_1","020_137_1","PSA","137","1","7","Papilunanya ngurrara tjuṯangku tjananya Tjarutjalumanya ngurrara tjuṯa tjungura tjananya katirra kanyiṉingi ngurra Papilunangka, Tjarutjalumangka yila nyinanytja tjuṯaṯarra. Tjilirratjarra tjuṯangku tjananya kanyiṉangi ngurra walytjakutu rayitpayiki tjalkaḻungkupayingkamarra. Ngurra palulaya nyinarra watjilarringu, ngurra walytjaku. Yalatji watjilpa nyinarra kuliraya yalatji piipangka wakaṉu, “Ngurra Papilunangkalatju karrungka nyinarra yulangi, ngurra Tjarutjalumalakutu rayitpayiki yankukitja. Kiitawu wangkatjingantjawiyangkulatju katu tjunkula wantingu. Papilunanya ngurrara tjuṯangkulanyatju puṯu yinkatjingalkitjangku yalatjiya watjaṉu, ‘Tuḻku nyurrangarri Tjarutjalumala yinkapayinyurra, kuwarriya wangkatjingaraya yinka!’ Nganaṉatju Tjarutjalumanya ngurrara tjuṯangku tjananya watjaṉu, ‘Wiya. Ngurra kutjupangka wiyalatju yunyparrirra yinkakitjangku kuliṉi.’” Ngurra Papilunangka wati Yitjikiyalanya Katutjaku wangka watjalpayi nyinangi. Katutjalu nintintjala Yitjikiyalalu tjukurrpa nyangu yalatji. Kana nyinapayi puupala parra yankupayi, wiilatjarra nguwanpa. Yalatji nyakula kutjupa nyangu yaṉangu nguwanpa tjiiyingka nyinanytjala. Yaṉangu nguwanpa paluru Yitjikiyalanya piipa karrpilpa nintiṉu. Nintira watjaṉu ngalkunytjaku. Yitjikiyalalu ngalkuṉu. Palunyatjanu yaṉangu nguwanpa paluru Yitjikiyalanya watjaṉu, yankula Katutjaku wangka tjakultjunkunytjaku, Yitjurilaku walytja ngaṉṯitja tjuṯangka. Yalatji Yitjikiyalalu tjukurrmankula nyangu. Yitjikiyalalu tjananya yaṉangu tjuṯangka wangka kutjupa tjuṯa watjara, wangka yalatji tjananya mayutju tjuṯangka watjaṉu, Katutjalu nintintjala, “Ngayulu nyurrangarrinya mayutju tjuṯa watjaṉi. Tjiipi tjuṯaku mayutju nguwanpanyurra nyinanyi. Tjiipi tjuṯa nguwanpaya Yitjurilaku walytja ngaṉṯitja tjuṯa nyinarra waṉinyi. Tjiipiku mayutju tjuṯa nguwanpangku tjananya wiya nyurrangarri tjukarurrungku kanyilpayi. Tjiipiku mayutjungku mayi palyakutu tjiipi tjuṯa katipayi. Mayutju palunya nguwanpa wiyanyurra nyinanyi, wiyanyurra yaṉangu tjuṯa palyangku yaṉṯayaṉṯara kanyilpayi. Walytjaku kutjunyurra kulira nyinapayi yaṉangu tjuṯa tjukarurru kanyintjawiya. Yitjurilaku ngaṉṯitja tjuṯanyurra kutjupa kutjupa tjuṯangka kuwarri nyinarra waṉinyi, ngurra walytjawiyangka. Ngayulu nyurrangarrinya tjungulku ngurra walytjangkalpinyurra nyinanytjaku. Ngurra walytjangka ngayulu nyurrangarrinya yaṉṯayaṉṯanmalpa.” Yitjikiyalalu tjananya yaṉangu tjuṯangka Katutjaku wangka piyuku watjaṉu yalatji, “Ngulaṉa nyurranya Katutjalu ngurra walytjakutu rayitpayiki katiku, Tjarutjalumalakutu. Ngurra palula nyurrangarri tjuṯalingku nyinaku. Waaḻa palyara mayi pakaltjingara palyalpinyurra piyuku ngurra palula nyinaku. Palunyatjanutjunyurra ngayuku wangkaku ninti nyinamalpa. Yaṉangu kutjungka kurrunpa walytjaṉa mantjira tjunku kurrunpa kutjupa. Palunyatjanu yaṉangu kutjupangkaṯarra kurrunpa walytja mantjira ngayulu kutjupalpiṉa tjunku. Yalatjiṉa nyurrangarrila yaṉangu tjuṯangka tjunku kurrunpa kutjupa, ngayukutjunyurra tjukarurru kutu nyinanytjaku. Ngayuku kurrunpaṯarra ngayulu nyurrangarrila tjarrpatjunku. Kurrunpa paluru nyurrangarrinya rapalku, ngayuku wangkaku nyurrangarri tjukarurru kutu nyinanytjaku.” ");
INSERT INTO piu2006_vpl VALUES ("IS1_1","024_1_1","ISA","1","1","31","(1:; 6:) Tjuutaku walytja ngaṉṯitja tjuṯaku mayutju tjuṯa yalatji nyinangi, Yatjanya, Tjuutjamanya, Yiiyatjanya, Yitjikayanya. Mayutju palunya tjuṯaya nyinanytjala, Yaatjayalu tjananya Katutjaku wangka watjalpayingku marrkulpayi Katutjaku tjukarurru nyinanytjaku. Yaatjayalu tjananya yalatji watjaṉu, “Mayutju tiṉa Yitjikayanya mirrirrinytjala tjukurrpa nguwanpaṉa nyangu. Mayutju Katutjanyaṉa tjaatji tiṉangka mantarra palyatjarra nyangu, mayutjuku tjiiyingka nyinanytjala. Katutjala katu ngarangiya yilkari ngurrara tjirripala. Paluru tjana nyaḻpi tjuṯatjarra ngarangi, tjikitjipalatjarra. Ilkari ngurrarangku tjakultjunu ilkari ngurrara kutjupanya, ‘Mayutju Katutjanya tjukarurru nyinapayi, palyalampa mayutju tiṉa, maṯupurra. Katutjalu paawu puntutjarrangku tjukarurru palyalpayi ngurra tjuṯawanangku.’” Palunyatjanu Yaatjayalu panyapa nyakula Katutjanya watjaṉu, “Kuunyingkuṉa kuya kutu palyalpayi.” Palunyatjanu ilkari ngurrara kutjungku waru pirilyi nguwanpa mantjira yankula Yaatjayala tjaangka tjunu. Tjunkula Yaatjayalakutu watjaṉu, “Pirilyitjarrangkuṉanta tjaangka pampuntjala nyuntupa kuya Katutjalu waṉingu.” Palunyatjanu Katutjalu ilkari ngurrara kutjupa tjuṯangka wangkangu yalatji, “Ngananyala wantirriyalku nganampa waarrka palyantjaku? Ngananyalampa waarrkarriku?” Palunyatjanu Yaatjayalu watjaṉu, “Ngaatjaṉa ngaranyi. Ngayunyaṉiya wantirriyala!” Palunyatjanu Katutjalu watjaṉu Yaatjayanya, “Yankula tjananya yaṉangu tjuṯangka yalatji tjakultjurra!, ‘Yiltanyurra wangka kulilku. Kuliranyurra wantiku. Yiltanyurra kurungku nyaku Katutjalu palyaṉutja. Nyakulanyurra wantiku.’” (1:3; 1:18; 3:16; 5:) Tjuutaku walytja ngaṉṯitja tjuṯa Katutjaku tjukarurruwiya nyinanytjala, Yaatjayalu tjananya yalatji langangkatjunu, “Ngayuku pipirri nguwanpa ngayulu nyurrangarrinya yaṉṯayaṉṯara kanyilpayi, kanyanyurra yunytjuwiya nyinanyi. Puluka tjuṯangku mayutju walytjaku kulira ngaranyi. Tuungkiyiṯarra mayutju walytjaku kulira ngaranyi, kanya nyurrangarri ngayunya kulira wantinyi. Yitjurilaku walytja ngaṉṯitja tjuṯa nyurrangarri ngayunya mayutju tiṉa kulira wantinyi. “Kutjupa tjuṯangkunyurra waaḻa tjuṯa payimilara kanyiṉi, kanya kutjupa tjuṯa waaḻawiya nyinanyi. Ngurra paṉa tjuṯanyurra payimilara kanyiṉi, kanya kutjupa tjuṯa ngurrawiya nyinanyi. Yalatji payimilara waaḻa tjuṯa an yulytja tiṉatjarra nyinakitjanyurra yunytjurringanyi, mayutju tiṉa tjuṯa nguwanpa. Waarrkana tjuṯaṯarranyurra kanyiṉi liitjipaka tjuṯangku. Wiyawananyurra nyinanyi, yaṉangu kutjupaku wiya nyurrangarri yaḻṯururringanyi. Palunyatjanu ngayuluṉa nyurrangarrinya panitjimilalku. “Kutjupa tjuṯanyurra pulakinaku kutju yunytjurrirra nyinapayi. Yunytjurringkulanyurra tjikira nyinapayi. Tilayitikutu pakara pulakinaku tjikilkitjangku kuliranyurra yankupayi. Mungangkanyurra kutu tjikira pikarringkupayi. Palunyatjanu ngayulu nyurrangarrinya panitjimilalku ngayuku Katutjaku kulintjawiya, pulakinaku kutju kulilpayi. “Pulitjimana tjuṯangku mayutju kutjupa tjuṯangkuṯarraya yaṉangu maralpa tjuṯaku tjukarurrungku palyantjawiyangku wantipayi, yaṉangu kutjupangku yarrkangku tjingapungkula mani yungkunytjala. Mayutju paluru tjana tjukarurru palyantjawiyangku wantipayi tjananya, manitjirratjangku. Mayutju kutjupa tjuṯaṯarra paluru tjana nguwanpa wiyawana nyinangi.” Yalatji Yaatjayalu tjananya marrkuṉu. “Kungka kutjupa tjuṯangkuya mantarraku kutju kulira nyinapayi. Kungka kutjupa tjuṯangkuya riinga tjuṯaku, nikilitji tjuṯaku kutju kulira nyinapayi, Katutjaku kulintjawiya.” Palunya tjananya Yaatjayalu marrkuṉu. Yaṉangu tjuṯangka tjanala Yaatjayalu yalatji marrkulpayi, kuya palyalwiya nyinanytjaku. “Yalatjiya kulila!, mayutju Katutjalu nyurrangarrinya watjaṉi, ‘Kuyatjarranyurra nyinanyi mantarra kuyatjarra nguwanpa. Ngayuluṉa nyurrampa Katutjalu kuya waṉinytjala, mantarra tjulkuratjarralpi, kiliinalpinyurra nyinaku, kuyatjarrawiya.’” ");
INSERT INTO piu2006_vpl VALUES ("IS3_16","024_3_16","ISA","3","16","16","(1:3; 1:18; 3:16; 5:) Tjuutaku walytja ngaṉṯitja tjuṯa Katutjaku tjukarurruwiya nyinanytjala, Yaatjayalu tjananya yalatji langangkatjunu, “Ngayuku pipirri nguwanpa ngayulu nyurrangarrinya yaṉṯayaṉṯara kanyilpayi, kanyanyurra yunytjuwiya nyinanyi. Puluka tjuṯangku mayutju walytjaku kulira ngaranyi. Tuungkiyiṯarra mayutju walytjaku kulira ngaranyi, kanya nyurrangarri ngayunya kulira wantinyi. Yitjurilaku walytja ngaṉṯitja tjuṯa nyurrangarri ngayunya mayutju tiṉa kulira wantinyi. “Kutjupa tjuṯangkunyurra waaḻa tjuṯa payimilara kanyiṉi, kanya kutjupa tjuṯa waaḻawiya nyinanyi. Ngurra paṉa tjuṯanyurra payimilara kanyiṉi, kanya kutjupa tjuṯa ngurrawiya nyinanyi. Yalatji payimilara waaḻa tjuṯa an yulytja tiṉatjarra nyinakitjanyurra yunytjurringanyi, mayutju tiṉa tjuṯa nguwanpa. Waarrkana tjuṯaṯarranyurra kanyiṉi liitjipaka tjuṯangku. Wiyawananyurra nyinanyi, yaṉangu kutjupaku wiya nyurrangarri yaḻṯururringanyi. Palunyatjanu ngayuluṉa nyurrangarrinya panitjimilalku. “Kutjupa tjuṯanyurra pulakinaku kutju yunytjurrirra nyinapayi. Yunytjurringkulanyurra tjikira nyinapayi. Tilayitikutu pakara pulakinaku tjikilkitjangku kuliranyurra yankupayi. Mungangkanyurra kutu tjikira pikarringkupayi. Palunyatjanu ngayulu nyurrangarrinya panitjimilalku ngayuku Katutjaku kulintjawiya, pulakinaku kutju kulilpayi. “Pulitjimana tjuṯangku mayutju kutjupa tjuṯangkuṯarraya yaṉangu maralpa tjuṯaku tjukarurrungku palyantjawiyangku wantipayi, yaṉangu kutjupangku yarrkangku tjingapungkula mani yungkunytjala. Mayutju paluru tjana tjukarurru palyantjawiyangku wantipayi tjananya, manitjirratjangku. Mayutju kutjupa tjuṯaṯarra paluru tjana nguwanpa wiyawana nyinangi.” Yalatji Yaatjayalu tjananya marrkuṉu. “Kungka kutjupa tjuṯangkuya mantarraku kutju kulira nyinapayi. Kungka kutjupa tjuṯangkuya riinga tjuṯaku, nikilitji tjuṯaku kutju kulira nyinapayi, Katutjaku kulintjawiya.” Palunya tjananya Yaatjayalu marrkuṉu. Yaṉangu tjuṯangka tjanala Yaatjayalu yalatji marrkulpayi, kuya palyalwiya nyinanytjaku. “Yalatjiya kulila!, mayutju Katutjalu nyurrangarrinya watjaṉi, ‘Kuyatjarranyurra nyinanyi mantarra kuyatjarra nguwanpa. Ngayuluṉa nyurrampa Katutjalu kuya waṉinytjala, mantarra tjulkuratjarralpi, kiliinalpinyurra nyinaku, kuyatjarrawiya.’” ");
INSERT INTO piu2006_vpl VALUES ("IS5_1","024_5_1","ISA","5","1","30","(1:3; 1:18; 3:16; 5:) Tjuutaku walytja ngaṉṯitja tjuṯa Katutjaku tjukarurruwiya nyinanytjala, Yaatjayalu tjananya yalatji langangkatjunu, “Ngayuku pipirri nguwanpa ngayulu nyurrangarrinya yaṉṯayaṉṯara kanyilpayi, kanyanyurra yunytjuwiya nyinanyi. Puluka tjuṯangku mayutju walytjaku kulira ngaranyi. Tuungkiyiṯarra mayutju walytjaku kulira ngaranyi, kanya nyurrangarri ngayunya kulira wantinyi. Yitjurilaku walytja ngaṉṯitja tjuṯa nyurrangarri ngayunya mayutju tiṉa kulira wantinyi. “Kutjupa tjuṯangkunyurra waaḻa tjuṯa payimilara kanyiṉi, kanya kutjupa tjuṯa waaḻawiya nyinanyi. Ngurra paṉa tjuṯanyurra payimilara kanyiṉi, kanya kutjupa tjuṯa ngurrawiya nyinanyi. Yalatji payimilara waaḻa tjuṯa an yulytja tiṉatjarra nyinakitjanyurra yunytjurringanyi, mayutju tiṉa tjuṯa nguwanpa. Waarrkana tjuṯaṯarranyurra kanyiṉi liitjipaka tjuṯangku. Wiyawananyurra nyinanyi, yaṉangu kutjupaku wiya nyurrangarri yaḻṯururringanyi. Palunyatjanu ngayuluṉa nyurrangarrinya panitjimilalku. “Kutjupa tjuṯanyurra pulakinaku kutju yunytjurrirra nyinapayi. Yunytjurringkulanyurra tjikira nyinapayi. Tilayitikutu pakara pulakinaku tjikilkitjangku kuliranyurra yankupayi. Mungangkanyurra kutu tjikira pikarringkupayi. Palunyatjanu ngayulu nyurrangarrinya panitjimilalku ngayuku Katutjaku kulintjawiya, pulakinaku kutju kulilpayi. “Pulitjimana tjuṯangku mayutju kutjupa tjuṯangkuṯarraya yaṉangu maralpa tjuṯaku tjukarurrungku palyantjawiyangku wantipayi, yaṉangu kutjupangku yarrkangku tjingapungkula mani yungkunytjala. Mayutju paluru tjana tjukarurru palyantjawiyangku wantipayi tjananya, manitjirratjangku. Mayutju kutjupa tjuṯaṯarra paluru tjana nguwanpa wiyawana nyinangi.” Yalatji Yaatjayalu tjananya marrkuṉu. “Kungka kutjupa tjuṯangkuya mantarraku kutju kulira nyinapayi. Kungka kutjupa tjuṯangkuya riinga tjuṯaku, nikilitji tjuṯaku kutju kulira nyinapayi, Katutjaku kulintjawiya.” Palunya tjananya Yaatjayalu marrkuṉu. Yaṉangu tjuṯangka tjanala Yaatjayalu yalatji marrkulpayi, kuya palyalwiya nyinanytjaku. “Yalatjiya kulila!, mayutju Katutjalu nyurrangarrinya watjaṉi, ‘Kuyatjarranyurra nyinanyi mantarra kuyatjarra nguwanpa. Ngayuluṉa nyurrampa Katutjalu kuya waṉinytjala, mantarra tjulkuratjarralpi, kiliinalpinyurra nyinaku, kuyatjarrawiya.’” ");
INSERT INTO piu2006_vpl VALUES ("IS6_1","024_6_1","ISA","6","1","13","(1:; 6:) Tjuutaku walytja ngaṉṯitja tjuṯaku mayutju tjuṯa yalatji nyinangi, Yatjanya, Tjuutjamanya, Yiiyatjanya, Yitjikayanya. Mayutju palunya tjuṯaya nyinanytjala, Yaatjayalu tjananya Katutjaku wangka watjalpayingku marrkulpayi Katutjaku tjukarurru nyinanytjaku. Yaatjayalu tjananya yalatji watjaṉu, “Mayutju tiṉa Yitjikayanya mirrirrinytjala tjukurrpa nguwanpaṉa nyangu. Mayutju Katutjanyaṉa tjaatji tiṉangka mantarra palyatjarra nyangu, mayutjuku tjiiyingka nyinanytjala. Katutjala katu ngarangiya yilkari ngurrara tjirripala. Paluru tjana nyaḻpi tjuṯatjarra ngarangi, tjikitjipalatjarra. Ilkari ngurrarangku tjakultjunu ilkari ngurrara kutjupanya, ‘Mayutju Katutjanya tjukarurru nyinapayi, palyalampa mayutju tiṉa, maṯupurra. Katutjalu paawu puntutjarrangku tjukarurru palyalpayi ngurra tjuṯawanangku.’” Palunyatjanu Yaatjayalu panyapa nyakula Katutjanya watjaṉu, “Kuunyingkuṉa kuya kutu palyalpayi.” Palunyatjanu ilkari ngurrara kutjungku waru pirilyi nguwanpa mantjira yankula Yaatjayala tjaangka tjunu. Tjunkula Yaatjayalakutu watjaṉu, “Pirilyitjarrangkuṉanta tjaangka pampuntjala nyuntupa kuya Katutjalu waṉingu.” Palunyatjanu Katutjalu ilkari ngurrara kutjupa tjuṯangka wangkangu yalatji, “Ngananyala wantirriyalku nganampa waarrka palyantjaku? Ngananyalampa waarrkarriku?” Palunyatjanu Yaatjayalu watjaṉu, “Ngaatjaṉa ngaranyi. Ngayunyaṉiya wantirriyala!” Palunyatjanu Katutjalu watjaṉu Yaatjayanya, “Yankula tjananya yaṉangu tjuṯangka yalatji tjakultjurra!, ‘Yiltanyurra wangka kulilku. Kuliranyurra wantiku. Yiltanyurra kurungku nyaku Katutjalu palyaṉutja. Nyakulanyurra wantiku.’” ");
INSERT INTO piu2006_vpl VALUES ("IS9_1","024_9_1","ISA","9","1","21","(9:; 11:; 53:) Kurayitjanya kanalpayilampa ngalya yankunytjaku Yaatjayalu irriṯi yalatji watjaṉu, “Yaṉangu tjuṯaya mungawana nguwanpaya nyinarra waṉinyi, kuya kutjuya kulira nyinapayi, mungangka kutu nyinakitjaya yunytjurringanyi. Yalatji nyinarraya tili tiṉa nguwanpa nyakulpi. Kuyatjarraya nyinaku mirrirrikitja. Paluru tjana tili tiṉa nguwanpa Kurayitjanya nyaku. Nyakulaya yalatji nintingku kulilku, ‘Katutjalulampa palumpa katja nyinatjunu. Yiṯi wiima nyinarra tiṉarriku. Mayutju tiṉalampa yilta nyinaku. Palunyangkala yalatji katja palunya waḻkula! Katja palunya palyalingkulampa nyinaku. Palurulanya nintilku Katutjanya. Yilta katja palunya mayutju tiṉalampa nyinaku, Katutjanyapula paawu kutjutjarra. Katja paluru paapa tiṉa nguwanpalampa nyinaku. Palurulanya Katutjaku kalypa nyinatjunkupayi. Kanalpayi paluru Kurayitjalulanya yaṉangu tjuṯa yaṉṯayaṉṯalku, kutulanya yaṉṯayaṉṯara kanyinmalpa, ngula nyinanytja tjuṯaṯarra. Mayutju tiṉa Tapitalu tjananya tjukarurru kanyintja nguwanpa, kanalpayi paluru tjananya Tapitaku walytja ngaṉṯitja tjuṯa tjukarurrungku tjananya kutu yaṉṯayaṉṯanmalpa. ‘Watiya piḻṯirringu. Palulanguru watiya palula yukiri nyuwana pakaṉu Yukiri nyuwana pakaṉutja nguwanpa, kanalpayi palunya yutirringkula kanalampa nyinaku. Yirriṯi wati Tjiitjiyinya Tapitaku paapa mirrirringu, palunyatjanu ngula palumpa walytja ngaṉṯitja kana nyinaku. Kanalpayi paluru ninti puntu nyinaku, Katutjaku kurrunpatjarra. Paluru nguḻuwiya nyinarra tjukarurrungku tjananya nintinmalpa. Uwankarraku ninti nyinarra Kurayitjanya mayutju Katutjaku waarrkana nguwanpa nyinaku. ‘Kanalpayi paluru tjananya aṉangu tjuṯa tjukarurrungku watjalku maralpa tjuṯa yaṉṯayaṉṯalkitjangku, mayutju tjuṯaku nguḻurringkunytjawiyangku. Mayutju paluru tjana puṯu tjingapungku Kurayitjalu maralpa tjuṯanya wantinytjaku.’” Yaatjayalulanya nintiṉu kanalpayi Kurayitjanya nganampa kuya waṉikitja tjitjaku. Yaatjaya paluru tjananya yalatji tjakultjunu, “Nganaṉanya tjitjantankutjipingkamarra Kurayitjanyalampa tjitjaku nganampa kuya waṉikitja. Yurrunpala wiyawanangku yalatji kuliṉu, ‘Paluru tjitjaku Katutjalu ngaparrtjingku pungkunytjala.’ Yalatji wiya. Nganampa kuya waṉikitja paluru tjitjaku, nganaṉanya kuyatjarra Katutjalu pungkupayingkamarra. Kurayitja paluru tjitjakulampa, nganaṉa Katutjaku kalypalpi nyinanytjaku. Kurayitja palunya tjana yalatji tjitjantankunytjala Katutjalu kuyalampa waṉiku kana kutu nyinanytjaku. Yalatji Katutjalulanya kana nyinatjunku nganampa kuyanguru Kurayitjanya mirrirringutjangka.” Yalatji Katutjalu Yaatjayanya yirriṯi nintiṉu paluru piipangka wakantjaku. Yaatjayalu yalatji watjaṉu Kurayitjanyalampa kuya waṉikitja waralyngarala tjitjanytjaku, yurrunpa. ");
INSERT INTO piu2006_vpl VALUES ("IS11_1","024_11_1","ISA","11","1","16","(9:; 11:; 53:) Kurayitjanya kanalpayilampa ngalya yankunytjaku Yaatjayalu irriṯi yalatji watjaṉu, “Yaṉangu tjuṯaya mungawana nguwanpaya nyinarra waṉinyi, kuya kutjuya kulira nyinapayi, mungangka kutu nyinakitjaya yunytjurringanyi. Yalatji nyinarraya tili tiṉa nguwanpa nyakulpi. Kuyatjarraya nyinaku mirrirrikitja. Paluru tjana tili tiṉa nguwanpa Kurayitjanya nyaku. Nyakulaya yalatji nintingku kulilku, ‘Katutjalulampa palumpa katja nyinatjunu. Yiṯi wiima nyinarra tiṉarriku. Mayutju tiṉalampa yilta nyinaku. Palunyangkala yalatji katja palunya waḻkula! Katja palunya palyalingkulampa nyinaku. Palurulanya nintilku Katutjanya. Yilta katja palunya mayutju tiṉalampa nyinaku, Katutjanyapula paawu kutjutjarra. Katja paluru paapa tiṉa nguwanpalampa nyinaku. Palurulanya Katutjaku kalypa nyinatjunkupayi. Kanalpayi paluru Kurayitjalulanya yaṉangu tjuṯa yaṉṯayaṉṯalku, kutulanya yaṉṯayaṉṯara kanyinmalpa, ngula nyinanytja tjuṯaṯarra. Mayutju tiṉa Tapitalu tjananya tjukarurru kanyintja nguwanpa, kanalpayi paluru tjananya Tapitaku walytja ngaṉṯitja tjuṯa tjukarurrungku tjananya kutu yaṉṯayaṉṯanmalpa. ‘Watiya piḻṯirringu. Palulanguru watiya palula yukiri nyuwana pakaṉu Yukiri nyuwana pakaṉutja nguwanpa, kanalpayi palunya yutirringkula kanalampa nyinaku. Yirriṯi wati Tjiitjiyinya Tapitaku paapa mirrirringu, palunyatjanu ngula palumpa walytja ngaṉṯitja kana nyinaku. Kanalpayi paluru ninti puntu nyinaku, Katutjaku kurrunpatjarra. Paluru nguḻuwiya nyinarra tjukarurrungku tjananya nintinmalpa. Uwankarraku ninti nyinarra Kurayitjanya mayutju Katutjaku waarrkana nguwanpa nyinaku. ‘Kanalpayi paluru tjananya aṉangu tjuṯa tjukarurrungku watjalku maralpa tjuṯa yaṉṯayaṉṯalkitjangku, mayutju tjuṯaku nguḻurringkunytjawiyangku. Mayutju paluru tjana puṯu tjingapungku Kurayitjalu maralpa tjuṯanya wantinytjaku.’” Yaatjayalulanya nintiṉu kanalpayi Kurayitjanya nganampa kuya waṉikitja tjitjaku. Yaatjaya paluru tjananya yalatji tjakultjunu, “Nganaṉanya tjitjantankutjipingkamarra Kurayitjanyalampa tjitjaku nganampa kuya waṉikitja. Yurrunpala wiyawanangku yalatji kuliṉu, ‘Paluru tjitjaku Katutjalu ngaparrtjingku pungkunytjala.’ Yalatji wiya. Nganampa kuya waṉikitja paluru tjitjaku, nganaṉanya kuyatjarra Katutjalu pungkupayingkamarra. Kurayitja paluru tjitjakulampa, nganaṉa Katutjaku kalypalpi nyinanytjaku. Kurayitja palunya tjana yalatji tjitjantankunytjala Katutjalu kuyalampa waṉiku kana kutu nyinanytjaku. Yalatji Katutjalulanya kana nyinatjunku nganampa kuyanguru Kurayitjanya mirrirringutjangka.” Yalatji Katutjalu Yaatjayanya yirriṯi nintiṉu paluru piipangka wakantjaku. Yaatjayalu yalatji watjaṉu Kurayitjanyalampa kuya waṉikitja waralyngarala tjitjanytjaku, yurrunpa. ");
INSERT INTO piu2006_vpl VALUES ("IS53_1","024_53_1","ISA","53","1","12","(9:; 11:; 53:) Kurayitjanya kanalpayilampa ngalya yankunytjaku Yaatjayalu irriṯi yalatji watjaṉu, “Yaṉangu tjuṯaya mungawana nguwanpaya nyinarra waṉinyi, kuya kutjuya kulira nyinapayi, mungangka kutu nyinakitjaya yunytjurringanyi. Yalatji nyinarraya tili tiṉa nguwanpa nyakulpi. Kuyatjarraya nyinaku mirrirrikitja. Paluru tjana tili tiṉa nguwanpa Kurayitjanya nyaku. Nyakulaya yalatji nintingku kulilku, ‘Katutjalulampa palumpa katja nyinatjunu. Yiṯi wiima nyinarra tiṉarriku. Mayutju tiṉalampa yilta nyinaku. Palunyangkala yalatji katja palunya waḻkula! Katja palunya palyalingkulampa nyinaku. Palurulanya nintilku Katutjanya. Yilta katja palunya mayutju tiṉalampa nyinaku, Katutjanyapula paawu kutjutjarra. Katja paluru paapa tiṉa nguwanpalampa nyinaku. Palurulanya Katutjaku kalypa nyinatjunkupayi. Kanalpayi paluru Kurayitjalulanya yaṉangu tjuṯa yaṉṯayaṉṯalku, kutulanya yaṉṯayaṉṯara kanyinmalpa, ngula nyinanytja tjuṯaṯarra. Mayutju tiṉa Tapitalu tjananya tjukarurru kanyintja nguwanpa, kanalpayi paluru tjananya Tapitaku walytja ngaṉṯitja tjuṯa tjukarurrungku tjananya kutu yaṉṯayaṉṯanmalpa. ‘Watiya piḻṯirringu. Palulanguru watiya palula yukiri nyuwana pakaṉu Yukiri nyuwana pakaṉutja nguwanpa, kanalpayi palunya yutirringkula kanalampa nyinaku. Yirriṯi wati Tjiitjiyinya Tapitaku paapa mirrirringu, palunyatjanu ngula palumpa walytja ngaṉṯitja kana nyinaku. Kanalpayi paluru ninti puntu nyinaku, Katutjaku kurrunpatjarra. Paluru nguḻuwiya nyinarra tjukarurrungku tjananya nintinmalpa. Uwankarraku ninti nyinarra Kurayitjanya mayutju Katutjaku waarrkana nguwanpa nyinaku. ‘Kanalpayi paluru tjananya aṉangu tjuṯa tjukarurrungku watjalku maralpa tjuṯa yaṉṯayaṉṯalkitjangku, mayutju tjuṯaku nguḻurringkunytjawiyangku. Mayutju paluru tjana puṯu tjingapungku Kurayitjalu maralpa tjuṯanya wantinytjaku.’” Yaatjayalulanya nintiṉu kanalpayi Kurayitjanya nganampa kuya waṉikitja tjitjaku. Yaatjaya paluru tjananya yalatji tjakultjunu, “Nganaṉanya tjitjantankutjipingkamarra Kurayitjanyalampa tjitjaku nganampa kuya waṉikitja. Yurrunpala wiyawanangku yalatji kuliṉu, ‘Paluru tjitjaku Katutjalu ngaparrtjingku pungkunytjala.’ Yalatji wiya. Nganampa kuya waṉikitja paluru tjitjaku, nganaṉanya kuyatjarra Katutjalu pungkupayingkamarra. Kurayitja paluru tjitjakulampa, nganaṉa Katutjaku kalypalpi nyinanytjaku. Kurayitja palunya tjana yalatji tjitjantankunytjala Katutjalu kuyalampa waṉiku kana kutu nyinanytjaku. Yalatji Katutjalulanya kana nyinatjunku nganampa kuyanguru Kurayitjanya mirrirringutjangka.” Yalatji Katutjalu Yaatjayanya yirriṯi nintiṉu paluru piipangka wakantjaku. Yaatjayalu yalatji watjaṉu Kurayitjanyalampa kuya waṉikitja waralyngarala tjitjanytjaku, yurrunpa. ");
INSERT INTO piu2006_vpl VALUES ("JR1_1","025_1_1","JER","1","1","1","(1:1; 2:5,13,32; 3:12-14) Tjuutaku walytja ngaṉṯitja tjuṯaku mayutju tiṉa tjuṯa yalatji nyinangu, Tjutjayanya, Tjiyuyakimanya, Tjitikayanyaṯarra. Mayutju palunya tjuṯa nyinanytjala Tjirimayalu Katutjaku wangka yaṉangu tjuṯa tjananya tjakultjunkupayi. Paluru Katutjaku wangka watjalpayi. Yalatji tjananya paluru Katutjaku wangka watjaṉu, “Ngayulu Katutjalu nyurrangarrinya tjapiṉi. Ngayulu nyurrangarrinya kuya nyaa palyantjala?, kulilwiyanyurra nyinanyi. Nyurrangarrimpa walytja tjuṯangku irriṯi kulilwiyangkuṉiya wantipayi. Nyaanguruya ngayunya wantirra wiyawanalpiya nyinapayi? Ngayuku walytja tjuṯangkunyurra kuya kutu palyaṉi, irriṯi wiyarringutja tjuṯangku kuya palyalpayi nguwanpa. Kapi wiila palya wantirra kapi kutjupaku ngurrintja nguwanpanyurra ngayunya wantingu kanalpayinya, ngayunya nguwanpa kutjupa tjuṯa waḻkulkitjangku. Ngayunya nyurrangarri maḻpa wiyawanangku wantingu.” Katutjaku wangka Tjirimayalu tjananya piyuku watjaṉu, “Kungkangku wiya riingaku nikilitjiku ramarrirra wantipayi, ngurra kutjupakutu yankukitjangku, maṯupurra kulira paluru katipayi. Kungkangku ramarrinytjawiyangku maṯupurra kulilpayi nguwanpa wiyaṉinyurra Katutjanya maṯupurra kuliṉi Tjukarurrunyurra ngayunya maṯupurra kulinmara. Yalatji kutuṉinyurra wantipayi, kulilwiyangku. Mayutju Katutjaluṉa nyurrangarrinya watjaṉi. Yitjurilaku walytja ngaṉṯitja tjuṯangku kulila! Tjukarurrutjuya watjala!, nyurrangarri ngayuku wangkaku kulintjawiya nyinangu. Palulanguru tjukarurrutjuya nyinama! Palulanguruṉa nyurrangarrimpa aḻṯururringkula kuya waṉiku, wiyaṉa nyurrampa pika nyinaku. Kutjupa tjuṯa nyurranya ngayulu ngurra ngaakutu walytjakutu rayitpayiki ngalya katiku.” ");
INSERT INTO piu2006_vpl VALUES ("JR2_5","025_2_5","JER","2","5","32","(1:1; 2:5,13,32; 3:12-14) Tjuutaku walytja ngaṉṯitja tjuṯaku mayutju tiṉa tjuṯa yalatji nyinangu, Tjutjayanya, Tjiyuyakimanya, Tjitikayanyaṯarra. Mayutju palunya tjuṯa nyinanytjala Tjirimayalu Katutjaku wangka yaṉangu tjuṯa tjananya tjakultjunkupayi. Paluru Katutjaku wangka watjalpayi. Yalatji tjananya paluru Katutjaku wangka watjaṉu, “Ngayulu Katutjalu nyurrangarrinya tjapiṉi. Ngayulu nyurrangarrinya kuya nyaa palyantjala?, kulilwiyanyurra nyinanyi. Nyurrangarrimpa walytja tjuṯangku irriṯi kulilwiyangkuṉiya wantipayi. Nyaanguruya ngayunya wantirra wiyawanalpiya nyinapayi? Ngayuku walytja tjuṯangkunyurra kuya kutu palyaṉi, irriṯi wiyarringutja tjuṯangku kuya palyalpayi nguwanpa. Kapi wiila palya wantirra kapi kutjupaku ngurrintja nguwanpanyurra ngayunya wantingu kanalpayinya, ngayunya nguwanpa kutjupa tjuṯa waḻkulkitjangku. Ngayunya nyurrangarri maḻpa wiyawanangku wantingu.” Katutjaku wangka Tjirimayalu tjananya piyuku watjaṉu, “Kungkangku wiya riingaku nikilitjiku ramarrirra wantipayi, ngurra kutjupakutu yankukitjangku, maṯupurra kulira paluru katipayi. Kungkangku ramarrinytjawiyangku maṯupurra kulilpayi nguwanpa wiyaṉinyurra Katutjanya maṯupurra kuliṉi Tjukarurrunyurra ngayunya maṯupurra kulinmara. Yalatji kutuṉinyurra wantipayi, kulilwiyangku. Mayutju Katutjaluṉa nyurrangarrinya watjaṉi. Yitjurilaku walytja ngaṉṯitja tjuṯangku kulila! Tjukarurrutjuya watjala!, nyurrangarri ngayuku wangkaku kulintjawiya nyinangu. Palulanguru tjukarurrutjuya nyinama! Palulanguruṉa nyurrangarrimpa aḻṯururringkula kuya waṉiku, wiyaṉa nyurrampa pika nyinaku. Kutjupa tjuṯa nyurranya ngayulu ngurra ngaakutu walytjakutu rayitpayiki ngalya katiku.” ");
INSERT INTO piu2006_vpl VALUES ("JR3_12","025_3_12","JER","3","12","14","(1:1; 2:5,13,32; 3:12-14) Tjuutaku walytja ngaṉṯitja tjuṯaku mayutju tiṉa tjuṯa yalatji nyinangu, Tjutjayanya, Tjiyuyakimanya, Tjitikayanyaṯarra. Mayutju palunya tjuṯa nyinanytjala Tjirimayalu Katutjaku wangka yaṉangu tjuṯa tjananya tjakultjunkupayi. Paluru Katutjaku wangka watjalpayi. Yalatji tjananya paluru Katutjaku wangka watjaṉu, “Ngayulu Katutjalu nyurrangarrinya tjapiṉi. Ngayulu nyurrangarrinya kuya nyaa palyantjala?, kulilwiyanyurra nyinanyi. Nyurrangarrimpa walytja tjuṯangku irriṯi kulilwiyangkuṉiya wantipayi. Nyaanguruya ngayunya wantirra wiyawanalpiya nyinapayi? Ngayuku walytja tjuṯangkunyurra kuya kutu palyaṉi, irriṯi wiyarringutja tjuṯangku kuya palyalpayi nguwanpa. Kapi wiila palya wantirra kapi kutjupaku ngurrintja nguwanpanyurra ngayunya wantingu kanalpayinya, ngayunya nguwanpa kutjupa tjuṯa waḻkulkitjangku. Ngayunya nyurrangarri maḻpa wiyawanangku wantingu.” Katutjaku wangka Tjirimayalu tjananya piyuku watjaṉu, “Kungkangku wiya riingaku nikilitjiku ramarrirra wantipayi, ngurra kutjupakutu yankukitjangku, maṯupurra kulira paluru katipayi. Kungkangku ramarrinytjawiyangku maṯupurra kulilpayi nguwanpa wiyaṉinyurra Katutjanya maṯupurra kuliṉi Tjukarurrunyurra ngayunya maṯupurra kulinmara. Yalatji kutuṉinyurra wantipayi, kulilwiyangku. Mayutju Katutjaluṉa nyurrangarrinya watjaṉi. Yitjurilaku walytja ngaṉṯitja tjuṯangku kulila! Tjukarurrutjuya watjala!, nyurrangarri ngayuku wangkaku kulintjawiya nyinangu. Palulanguru tjukarurrutjuya nyinama! Palulanguruṉa nyurrangarrimpa aḻṯururringkula kuya waṉiku, wiyaṉa nyurrampa pika nyinaku. Kutjupa tjuṯa nyurranya ngayulu ngurra ngaakutu walytjakutu rayitpayiki ngalya katiku.” ");
INSERT INTO piu2006_vpl VALUES ("JR8_22","025_8_22","JER","8","22","22","(8:22; 14:20,21) Tjirimayanya tjanampa yaṉangu tjuṯaku watjilpa yulangu, kulintjawiyangkuya kuya kutu palyaṉingi. Yalatji tjanala watjaṉu, “Kuya waṉirra palyalpayi yaalytji? Ngangkaritjarra nguwanpa yaalytji? Paṉa Kiliitanya ngurrara tjuṯangku mirritjina tjuṯa kanyira puṯu ngangkaritjunkupayi, kuya waṉikitjangku. Palunyatjanu kutunyurra ngayuku walytja tjuṯa kuyatjarra nyinarra waṉinyi.” Tjirimayalu tjanampa Katutjanya yalatji tjapiṉu, “Yiltalatjunta wiyawana nyinarra kuya palyalpayi nganampatju irriṯi wiyarringutja tjuṯaṯarra. Tjungungkulatjunta mayutju Katutjala kuya palyara tjakultjunanyi. Irriṯi nyinanytja tjuṯanya tjananya nyuntu watjaṉu tjanampaṉu ngaṉṯitja tjuṯa yaṉṯayaṉṯalkitjangku. Palunyatjanu nganaṉanyatju yaṉṯayaṉṯara kanyila!, wantinytjawiyangku. Nyuntupalatju tjukarurru kutu nyinakitja yunytjurringanyi.” ");
INSERT INTO piu2006_vpl VALUES ("JR14_20","025_14_20","JER","14","20","21","(8:22; 14:20,21) Tjirimayanya tjanampa yaṉangu tjuṯaku watjilpa yulangu, kulintjawiyangkuya kuya kutu palyaṉingi. Yalatji tjanala watjaṉu, “Kuya waṉirra palyalpayi yaalytji? Ngangkaritjarra nguwanpa yaalytji? Paṉa Kiliitanya ngurrara tjuṯangku mirritjina tjuṯa kanyira puṯu ngangkaritjunkupayi, kuya waṉikitjangku. Palunyatjanu kutunyurra ngayuku walytja tjuṯa kuyatjarra nyinarra waṉinyi.” Tjirimayalu tjanampa Katutjanya yalatji tjapiṉu, “Yiltalatjunta wiyawana nyinarra kuya palyalpayi nganampatju irriṯi wiyarringutja tjuṯaṯarra. Tjungungkulatjunta mayutju Katutjala kuya palyara tjakultjunanyi. Irriṯi nyinanytja tjuṯanya tjananya nyuntu watjaṉu tjanampaṉu ngaṉṯitja tjuṯa yaṉṯayaṉṯalkitjangku. Palunyatjanu nganaṉanyatju yaṉṯayaṉṯara kanyila!, wantinytjawiyangku. Nyuntupalatju tjukarurru kutu nyinakitja yunytjurringanyi.” ");
INSERT INTO piu2006_vpl VALUES ("JR19_10","025_19_10","JER","19","10","11","Mayutju Katutjalu watjaṉu Tjirimayalu kaṉilpa pilkitjanu palyaṉutja yankula mantjintjaku. Paluru ankula kaṉilpa palunya mantjiṉu. Wati kutjupa tjuṯangkuya ngarala nyakunytjala, Tjirimayalu kaṉilpa waṉirra yuḻpuṉu, Katutjalu yalatji yuḻpuntjaku watjaṉutjangka. Yuḻpura tjanala yalatji watjaṉu, “Kaṉilpa palunyaṉa yuḻpuṉutjala, kutjupangku puṯu kulilku palyantjaku. Mayutju Katutjaluṉa nyurranya yalatji watjaṉi. Kaṉilpa yuḻpuntjaku nguwanpa ngayulu Katutjaluṉa nyurrangarrimpa tawunu Tjarutjalumanya yuḻpura piḻuntanku. Yalatji piḻuntankula ngayulu kutjupa tjuṯa nyurrangarrinya mirrintanku, kutjupa tjuṯa ngayulu nyurrangarrinya ngurra kutjupakutu wantirriyalku, yunytjuwiyangkutjunyurra ngayuku wangka wantinytjala.” ");
INSERT INTO piu2006_vpl VALUES ("JR23_5","025_23_5","JER","23","5","6","(23:5,6; 29:11; 31:31-34) Tjirimayalu Katutjaku wangka yalatji tjananya watjaṉu, “Mayutju Katutjalu nyurranya yalatji watjaṉi. ‘Kulilaya! Ngulaṉa Katutjalu mayutju Tapitaku walytja ngaṉṯitja mayutju tiṉa nyinatjunku. Mayutju paluru ninti puḻkangku tjananya tjukarurrungku yaṉṯayaṉṯara kanyilku. Paluru tjananya Yitjurilaku walytja ngaṉṯitja tjuṯa kanalku, Tjuutaku walytja ngaṉṯitja tjuṯaṯarra. Mayutju palunya yini yalatjiya watjalku, “Nganampa mayutjulu yaṉangu tjuṯa tjukarurrulpayinya.” Mayutju Katutjaluṉa kuliṉi yalatji, ngula ngurra palyangkaṉa nyurranya nyinatjunkukitjangku. Ngurra palulanyurra nyinaku yulytja anta mayi puntutjarra. Ngurra palulanyurra yunypa nyinaku, wiyaṉa nyurrangarrinya kutu panitjiminta yungku.’” Tjirimayalu tjananya Katutjaku wangka piyuku tjakultjunu yalatji, “Mayutju Katutjaluṉa tjananya Yitjurilaku walytja ngaṉṯitja tjuṯa, ngula nyinanytja tjuṯa piyuku watjalku, tjukarurru palyalkitjangku. Yalatjiya ngula palya nyinaku. Yuḻṯa palunya alatji ngaraku. Ngayuluṉa tjanampa mayutju tiṉa nyinaku, palulanguruya ngayuku walytja tjuṯa tjukarurru nyinaku. Ngayulu tjananya nintilku tjana pinangku ngayuku wangka kutu kulintjaku. Piipangka wakaṉutja nganaṉa tjuṯangara riitarringkula ninti nyinanyi. Palunya nguwanpa ngayuluṉa tjananya tjuṯangara nintilku luwu ngayukuṉuwanaya tjukarurru nyinanytjaku. Yilta ngayulu tjanampa mayutju tiṉa nyinaku, tjana ngayuku walytja tjuṯalpi nyinaku. Paluru tjana uwankarra ngayuku wangkaku ninti nyinaku, mayutju tjuṯa, kutjupa tjuṯaṯarra. Wiya nintilpayi tjuṯangku tjananya rawangku yarrkara nintinmalpa. Paluru tjana kuya palyantjala ngayulu kuya tjanampa waṉiku. Ngayulu tjananya kaangkinytjingku yaṉṯayaṉṯanmalpa.” ");
INSERT INTO piu2006_vpl VALUES ("JR29_11","025_29_11","JER","29","11","11","(23:5,6; 29:11; 31:31-34) Tjirimayalu Katutjaku wangka yalatji tjananya watjaṉu, “Mayutju Katutjalu nyurranya yalatji watjaṉi. ‘Kulilaya! Ngulaṉa Katutjalu mayutju Tapitaku walytja ngaṉṯitja mayutju tiṉa nyinatjunku. Mayutju paluru ninti puḻkangku tjananya tjukarurrungku yaṉṯayaṉṯara kanyilku. Paluru tjananya Yitjurilaku walytja ngaṉṯitja tjuṯa kanalku, Tjuutaku walytja ngaṉṯitja tjuṯaṯarra. Mayutju palunya yini yalatjiya watjalku, “Nganampa mayutjulu yaṉangu tjuṯa tjukarurrulpayinya.” Mayutju Katutjaluṉa kuliṉi yalatji, ngula ngurra palyangkaṉa nyurranya nyinatjunkukitjangku. Ngurra palulanyurra nyinaku yulytja anta mayi puntutjarra. Ngurra palulanyurra yunypa nyinaku, wiyaṉa nyurrangarrinya kutu panitjiminta yungku.’” Tjirimayalu tjananya Katutjaku wangka piyuku tjakultjunu yalatji, “Mayutju Katutjaluṉa tjananya Yitjurilaku walytja ngaṉṯitja tjuṯa, ngula nyinanytja tjuṯa piyuku watjalku, tjukarurru palyalkitjangku. Yalatjiya ngula palya nyinaku. Yuḻṯa palunya alatji ngaraku. Ngayuluṉa tjanampa mayutju tiṉa nyinaku, palulanguruya ngayuku walytja tjuṯa tjukarurru nyinaku. Ngayulu tjananya nintilku tjana pinangku ngayuku wangka kutu kulintjaku. Piipangka wakaṉutja nganaṉa tjuṯangara riitarringkula ninti nyinanyi. Palunya nguwanpa ngayuluṉa tjananya tjuṯangara nintilku luwu ngayukuṉuwanaya tjukarurru nyinanytjaku. Yilta ngayulu tjanampa mayutju tiṉa nyinaku, tjana ngayuku walytja tjuṯalpi nyinaku. Paluru tjana uwankarra ngayuku wangkaku ninti nyinaku, mayutju tjuṯa, kutjupa tjuṯaṯarra. Wiya nintilpayi tjuṯangku tjananya rawangku yarrkara nintinmalpa. Paluru tjana kuya palyantjala ngayulu kuya tjanampa waṉiku. Ngayulu tjananya kaangkinytjingku yaṉṯayaṉṯanmalpa.” ");
INSERT INTO piu2006_vpl VALUES ("JR31_31","025_31_31","JER","31","31","34","(23:5,6; 29:11; 31:31-34) Tjirimayalu Katutjaku wangka yalatji tjananya watjaṉu, “Mayutju Katutjalu nyurranya yalatji watjaṉi. ‘Kulilaya! Ngulaṉa Katutjalu mayutju Tapitaku walytja ngaṉṯitja mayutju tiṉa nyinatjunku. Mayutju paluru ninti puḻkangku tjananya tjukarurrungku yaṉṯayaṉṯara kanyilku. Paluru tjananya Yitjurilaku walytja ngaṉṯitja tjuṯa kanalku, Tjuutaku walytja ngaṉṯitja tjuṯaṯarra. Mayutju palunya yini yalatjiya watjalku, “Nganampa mayutjulu yaṉangu tjuṯa tjukarurrulpayinya.” Mayutju Katutjaluṉa kuliṉi yalatji, ngula ngurra palyangkaṉa nyurranya nyinatjunkukitjangku. Ngurra palulanyurra nyinaku yulytja anta mayi puntutjarra. Ngurra palulanyurra yunypa nyinaku, wiyaṉa nyurrangarrinya kutu panitjiminta yungku.’” Tjirimayalu tjananya Katutjaku wangka piyuku tjakultjunu yalatji, “Mayutju Katutjaluṉa tjananya Yitjurilaku walytja ngaṉṯitja tjuṯa, ngula nyinanytja tjuṯa piyuku watjalku, tjukarurru palyalkitjangku. Yalatjiya ngula palya nyinaku. Yuḻṯa palunya alatji ngaraku. Ngayuluṉa tjanampa mayutju tiṉa nyinaku, palulanguruya ngayuku walytja tjuṯa tjukarurru nyinaku. Ngayulu tjananya nintilku tjana pinangku ngayuku wangka kutu kulintjaku. Piipangka wakaṉutja nganaṉa tjuṯangara riitarringkula ninti nyinanyi. Palunya nguwanpa ngayuluṉa tjananya tjuṯangara nintilku luwu ngayukuṉuwanaya tjukarurru nyinanytjaku. Yilta ngayulu tjanampa mayutju tiṉa nyinaku, tjana ngayuku walytja tjuṯalpi nyinaku. Paluru tjana uwankarra ngayuku wangkaku ninti nyinaku, mayutju tjuṯa, kutjupa tjuṯaṯarra. Wiya nintilpayi tjuṯangku tjananya rawangku yarrkara nintinmalpa. Paluru tjana kuya palyantjala ngayulu kuya tjanampa waṉiku. Ngayulu tjananya kaangkinytjingku yaṉṯayaṉṯanmalpa.” ");
INSERT INTO piu2006_vpl VALUES ("JR36_2","025_36_2","JER","36","2","3","Mayutju Katutjalu Tjirimayanya watjaṉu yalatji, “Tjutjayanya irriṯi mayutju tiṉa nyinanytjala ngayulu Katutjaluṉanta wangka tjuṯa watjalpayi, nyuntu yaṉangu tjuṯangka tjananya tjakultjunkunytjaku. Tjutjayanya nyinanytjala ngaṉṯi ngayuluṉanta kutu watjalpayi tjanala tjakultjunkunytjaku. Piipa karrpilpa mantjira wangka palunya uwankarra wakara wanala!, yaṉangu tjuṯa irriṯi pinangkatjunkukitjangkuṉa watjaṉutjangka.” Palunyatjanu Tjirimayalu tjakultjunkunytjala wati Pirakalu piipa karrpilpa palunya wakaṉingi. Palunyatjanu yaṉangu tjuṯaluya piipa palunya kulira nguḻurringu, Pirakalu riitarrinytjala. ");
INSERT INTO piu2006_vpl VALUES ("JR36_21","025_36_21","JER","36","21","27","Mayutju Tjiyuyakimalu tjakulpa kulira palumpa waarrkanangka watjaṉu, yankula piipa palunya mantjira ngalya katirra riitarrinytjaku. Katutjaku piipa karrpilpa wiima palunya waarrkana paluru mayutju palula riitarripayi. Paluru riitarrinytjala mayutju Tjiyuyakimalu tjuṯangara tjuuḻangka kuntara tjuṯangara warungka waṉingu, yunytjuwiyangku. Yalatji mayutju paluru piipa palunya kulira kuntara warungka kutjaṉu. Paluru Katutjaku nguḻuwiya nyinangi, palumpa wangka kulintjawiya. Piipa palulanguru mayutju Tjiyuyakimanya Tjirimayaku yunytjuwiya nyinangu. ");
INSERT INTO piu2006_vpl VALUES ("JR36_32","025_36_32","JER","36","32","32","Palulanguru Katutjalu Tjirimayanya watjaṉu piipa karrpilpa kutjupa mantjira wangka palunya piyuku tjunkunytjaku. Palunyatjanu Tjirimayalu piipa nyuwanangka Katutjaku wangka palunya piyuku wakara tjunangi. ");
INSERT INTO piu2006_vpl VALUES ("JR40_1","025_40_1","JER","40","1","16","Tjirimayanyaya karrpira nyinatjunu kutjupa tjuṯawana ngurra Papilunalakutu katikitjangku. Papilunanya ngurrara tjuṯaku mayutju tiṉangku Tjirimayanya yalatji watjaṉu, “Nyurrangarri Katutjaku tjukarurru nyinanytjawiyangka, mayutju Katutjalulanyatju yaḻṯirra watjaṉu, ngalya yankula nyurrangarrinya pikangku pungkula panitjimilantjaku. Yalatji nintingkuṉa kuliṉi. Tjirimaya. Nyuntu Katutjaku wangka watjalpayi, palulanguruṉanta kuwarri walatjunkula wantirriyalku. Tjingurunu paṉa ngaangka nyinakitja yunytjurrinytjala, palyan nyinaku. Tjingurunu yunytjurringanyi Papilunalakutu yankukitja, tjungula palya yankula nyinaku, ngayuluṉanta yaṉṯayaṉṯalku.” Tjirimayalu watjaṉu, “Ngayulu ngurra ngaangka nyinaku.” Yankula Tjirimayanya ngurra Mitjipangka nyinangu, mayutju Kitalayalangarri. Paluru tjana Papilunalakutu tjananya katinytjala ngaṉṯi Tjirimayalu nyangu Tjarutjalumanya yuḻpura ngarrirra waṉinytjala. Yalatji nyakula yulangu. Tjarutjalumala yaṉangu nyinanytjawiyalpi yalatji paluru yulangu. Yalatji paluru watjaṉu, “Tjarutjalumanya wiyalpi ngaranyi, yuḻpuraya wiyaṉu. Yaṉangu yuwankarra wiyarringu. Ngurra walytjangkaya wiya nyinanyi, waarrkanaya nyinanyi ngurra waṉmangka. Ngurra walytjangkaya, wiyaya yulytja kanyiṉi, maralpa tjuṯaya nyinanyi. Wiyaya Tjarutjalumangka yila nyinarra ngalya yankula tjaatji tiṉangka waḻkulku, wiyalpiya. Tjaatji tiṉa ngaranytjawiyangka ngaatja ngurrawiya ngaranyi. Yirriṯi kutju ngaatja palya ngarapayi.” ");
INSERT INTO piu2006_vpl VALUES ("LM1_1","026_1_1","LAM","1","1","22","(1:; 3:) Tjirimayanyaya karrpira nyinatjunu kutjupa tjuṯawana ngurra Papilunalakutu katikitjangku. Papilunanya ngurrara tjuṯaku mayutju tiṉangku Tjirimayanya yalatji watjaṉu, “Nyurrangarri Katutjaku tjukarurru nyinanytjawiyangka, mayutju Katutjalulanyatju yaḻṯirra watjaṉu, ngalya yankula nyurrangarrinya pikangku pungkula panitjimilantjaku. Yalatji nintingkuṉa kuliṉi. Tjirimaya. Nyuntu Katutjaku wangka watjalpayi, palulanguruṉanta kuwarri walatjunkula wantirriyalku. Tjingurunu paṉa ngaangka nyinakitja yunytjurrinytjala, palyan nyinaku. Tjingurunu yunytjurringanyi Papilunalakutu yankukitja, tjungula palya yankula nyinaku, ngayuluṉanta yaṉṯayaṉṯalku.” Tjirimayalu watjaṉu, “Ngayulu ngurra ngaangka nyinaku.” Yankula Tjirimayanya ngurra Mitjipangka nyinangu, mayutju Kitalayalangarri. Paluru tjana Papilunalakutu tjananya katinytjala ngaṉṯi Tjirimayalu nyangu Tjarutjalumanya yuḻpura ngarrirra waṉinytjala. Yalatji nyakula yulangu. Tjarutjalumala yaṉangu nyinanytjawiyalpi yalatji paluru yulangu. Yalatji paluru watjaṉu, “Tjarutjalumanya wiyalpi ngaranyi, yuḻpuraya wiyaṉu. Yaṉangu yuwankarra wiyarringu. Ngurra walytjangkaya wiya nyinanyi, waarrkanaya nyinanyi ngurra waṉmangka. Ngurra walytjangkaya, wiyaya yulytja kanyiṉi, maralpa tjuṯaya nyinanyi. Wiyaya Tjarutjalumangka yila nyinarra ngalya yankula tjaatji tiṉangka waḻkulku, wiyalpiya. Tjaatji tiṉa ngaranytjawiyangka ngaatja ngurrawiya ngaranyi. Yirriṯi kutju ngaatja palya ngarapayi.” ");
INSERT INTO piu2006_vpl VALUES ("LM3_1","026_3_1","LAM","3","1","66","(1:; 3:) Tjirimayanyaya karrpira nyinatjunu kutjupa tjuṯawana ngurra Papilunalakutu katikitjangku. Papilunanya ngurrara tjuṯaku mayutju tiṉangku Tjirimayanya yalatji watjaṉu, “Nyurrangarri Katutjaku tjukarurru nyinanytjawiyangka, mayutju Katutjalulanyatju yaḻṯirra watjaṉu, ngalya yankula nyurrangarrinya pikangku pungkula panitjimilantjaku. Yalatji nintingkuṉa kuliṉi. Tjirimaya. Nyuntu Katutjaku wangka watjalpayi, palulanguruṉanta kuwarri walatjunkula wantirriyalku. Tjingurunu paṉa ngaangka nyinakitja yunytjurrinytjala, palyan nyinaku. Tjingurunu yunytjurringanyi Papilunalakutu yankukitja, tjungula palya yankula nyinaku, ngayuluṉanta yaṉṯayaṉṯalku.” Tjirimayalu watjaṉu, “Ngayulu ngurra ngaangka nyinaku.” Yankula Tjirimayanya ngurra Mitjipangka nyinangu, mayutju Kitalayalangarri. Paluru tjana Papilunalakutu tjananya katinytjala ngaṉṯi Tjirimayalu nyangu Tjarutjalumanya yuḻpura ngarrirra waṉinytjala. Yalatji nyakula yulangu. Tjarutjalumala yaṉangu nyinanytjawiyalpi yalatji paluru yulangu. Yalatji paluru watjaṉu, “Tjarutjalumanya wiyalpi ngaranyi, yuḻpuraya wiyaṉu. Yaṉangu yuwankarra wiyarringu. Ngurra walytjangkaya wiya nyinanyi, waarrkanaya nyinanyi ngurra waṉmangka. Ngurra walytjangkaya, wiyaya yulytja kanyiṉi, maralpa tjuṯaya nyinanyi. Wiyaya Tjarutjalumangka yila nyinarra ngalya yankula tjaatji tiṉangka waḻkulku, wiyalpiya. Tjaatji tiṉa ngaranytjawiyangka ngaatja ngurrawiya ngaranyi. Yirriṯi kutju ngaatja palya ngarapayi.” ");
INSERT INTO piu2006_vpl VALUES ("EK1_1","027_1_1","EZK","1","1","28","(1:; 2:; 3:; 34:; 36:) Papilunanya ngurrara tjuṯangku tjananya Tjarutjalumanya ngurrara tjuṯa tjungura tjananya katirra kanyiṉingi ngurra Papilunangka, Tjarutjalumangka yila nyinanytja tjuṯaṯarra. Tjilirratjarra tjuṯangku tjananya kanyiṉangi ngurra walytjakutu rayitpayiki tjalkaḻungkupayingkamarra. Ngurra palulaya nyinarra watjilarringu, ngurra walytjaku. Yalatji watjilpa nyinarra kuliraya yalatji piipangka wakaṉu, “Ngurra Papilunangkalatju karrungka nyinarra yulangi, ngurra Tjarutjalumalakutu rayitpayiki yankukitja. Kiitawu wangkatjingantjawiyangkulatju katu tjunkula wantingu. Papilunanya ngurrara tjuṯangkulanyatju puṯu yinkatjingalkitjangku yalatjiya watjaṉu, ‘Tuḻku nyurrangarri Tjarutjalumala yinkapayinyurra, kuwarriya wangkatjingaraya yinka!’ Nganaṉatju Tjarutjalumanya ngurrara tjuṯangku tjananya watjaṉu, ‘Wiya. Ngurra kutjupangka wiyalatju yunyparrirra yinkakitjangku kuliṉi.’” Ngurra Papilunangka wati Yitjikiyalanya Katutjaku wangka watjalpayi nyinangi. Katutjalu nintintjala Yitjikiyalalu tjukurrpa nyangu yalatji. Kana nyinapayi puupala parra yankupayi, wiilatjarra nguwanpa. Yalatji nyakula kutjupa nyangu yaṉangu nguwanpa tjiiyingka nyinanytjala. Yaṉangu nguwanpa paluru Yitjikiyalanya piipa karrpilpa nintiṉu. Nintira watjaṉu ngalkunytjaku. Yitjikiyalalu ngalkuṉu. Palunyatjanu yaṉangu nguwanpa paluru Yitjikiyalanya watjaṉu, yankula Katutjaku wangka tjakultjunkunytjaku, Yitjurilaku walytja ngaṉṯitja tjuṯangka. Yalatji Yitjikiyalalu tjukurrmankula nyangu. Yitjikiyalalu tjananya yaṉangu tjuṯangka wangka kutjupa tjuṯa watjara, wangka yalatji tjananya mayutju tjuṯangka watjaṉu, Katutjalu nintintjala, “Ngayulu nyurrangarrinya mayutju tjuṯa watjaṉi. Tjiipi tjuṯaku mayutju nguwanpanyurra nyinanyi. Tjiipi tjuṯa nguwanpaya Yitjurilaku walytja ngaṉṯitja tjuṯa nyinarra waṉinyi. Tjiipiku mayutju tjuṯa nguwanpangku tjananya wiya nyurrangarri tjukarurrungku kanyilpayi. Tjiipiku mayutjungku mayi palyakutu tjiipi tjuṯa katipayi. Mayutju palunya nguwanpa wiyanyurra nyinanyi, wiyanyurra yaṉangu tjuṯa palyangku yaṉṯayaṉṯara kanyilpayi. Walytjaku kutjunyurra kulira nyinapayi yaṉangu tjuṯa tjukarurru kanyintjawiya. Yitjurilaku ngaṉṯitja tjuṯanyurra kutjupa kutjupa tjuṯangka kuwarri nyinarra waṉinyi, ngurra walytjawiyangka. Ngayulu nyurrangarrinya tjungulku ngurra walytjangkalpinyurra nyinanytjaku. Ngurra walytjangka ngayulu nyurrangarrinya yaṉṯayaṉṯanmalpa.” Yitjikiyalalu tjananya yaṉangu tjuṯangka Katutjaku wangka piyuku watjaṉu yalatji, “Ngulaṉa nyurranya Katutjalu ngurra walytjakutu rayitpayiki katiku, Tjarutjalumalakutu. Ngurra palula nyurrangarri tjuṯalingku nyinaku. Waaḻa palyara mayi pakaltjingara palyalpinyurra piyuku ngurra palula nyinaku. Palunyatjanutjunyurra ngayuku wangkaku ninti nyinamalpa. Yaṉangu kutjungka kurrunpa walytjaṉa mantjira tjunku kurrunpa kutjupa. Palunyatjanu yaṉangu kutjupangkaṯarra kurrunpa walytja mantjira ngayulu kutjupalpiṉa tjunku. Yalatjiṉa nyurrangarrila yaṉangu tjuṯangka tjunku kurrunpa kutjupa, ngayukutjunyurra tjukarurru kutu nyinanytjaku. Ngayuku kurrunpaṯarra ngayulu nyurrangarrila tjarrpatjunku. Kurrunpa paluru nyurrangarrinya rapalku, ngayuku wangkaku nyurrangarri tjukarurru kutu nyinanytjaku.” ");
INSERT INTO piu2006_vpl VALUES ("EK2_1","027_2_1","EZK","2","1","10","(1:; 2:; 3:; 34:; 36:) Papilunanya ngurrara tjuṯangku tjananya Tjarutjalumanya ngurrara tjuṯa tjungura tjananya katirra kanyiṉingi ngurra Papilunangka, Tjarutjalumangka yila nyinanytja tjuṯaṯarra. Tjilirratjarra tjuṯangku tjananya kanyiṉangi ngurra walytjakutu rayitpayiki tjalkaḻungkupayingkamarra. Ngurra palulaya nyinarra watjilarringu, ngurra walytjaku. Yalatji watjilpa nyinarra kuliraya yalatji piipangka wakaṉu, “Ngurra Papilunangkalatju karrungka nyinarra yulangi, ngurra Tjarutjalumalakutu rayitpayiki yankukitja. Kiitawu wangkatjingantjawiyangkulatju katu tjunkula wantingu. Papilunanya ngurrara tjuṯangkulanyatju puṯu yinkatjingalkitjangku yalatjiya watjaṉu, ‘Tuḻku nyurrangarri Tjarutjalumala yinkapayinyurra, kuwarriya wangkatjingaraya yinka!’ Nganaṉatju Tjarutjalumanya ngurrara tjuṯangku tjananya watjaṉu, ‘Wiya. Ngurra kutjupangka wiyalatju yunyparrirra yinkakitjangku kuliṉi.’” Ngurra Papilunangka wati Yitjikiyalanya Katutjaku wangka watjalpayi nyinangi. Katutjalu nintintjala Yitjikiyalalu tjukurrpa nyangu yalatji. Kana nyinapayi puupala parra yankupayi, wiilatjarra nguwanpa. Yalatji nyakula kutjupa nyangu yaṉangu nguwanpa tjiiyingka nyinanytjala. Yaṉangu nguwanpa paluru Yitjikiyalanya piipa karrpilpa nintiṉu. Nintira watjaṉu ngalkunytjaku. Yitjikiyalalu ngalkuṉu. Palunyatjanu yaṉangu nguwanpa paluru Yitjikiyalanya watjaṉu, yankula Katutjaku wangka tjakultjunkunytjaku, Yitjurilaku walytja ngaṉṯitja tjuṯangka. Yalatji Yitjikiyalalu tjukurrmankula nyangu. Yitjikiyalalu tjananya yaṉangu tjuṯangka wangka kutjupa tjuṯa watjara, wangka yalatji tjananya mayutju tjuṯangka watjaṉu, Katutjalu nintintjala, “Ngayulu nyurrangarrinya mayutju tjuṯa watjaṉi. Tjiipi tjuṯaku mayutju nguwanpanyurra nyinanyi. Tjiipi tjuṯa nguwanpaya Yitjurilaku walytja ngaṉṯitja tjuṯa nyinarra waṉinyi. Tjiipiku mayutju tjuṯa nguwanpangku tjananya wiya nyurrangarri tjukarurrungku kanyilpayi. Tjiipiku mayutjungku mayi palyakutu tjiipi tjuṯa katipayi. Mayutju palunya nguwanpa wiyanyurra nyinanyi, wiyanyurra yaṉangu tjuṯa palyangku yaṉṯayaṉṯara kanyilpayi. Walytjaku kutjunyurra kulira nyinapayi yaṉangu tjuṯa tjukarurru kanyintjawiya. Yitjurilaku ngaṉṯitja tjuṯanyurra kutjupa kutjupa tjuṯangka kuwarri nyinarra waṉinyi, ngurra walytjawiyangka. Ngayulu nyurrangarrinya tjungulku ngurra walytjangkalpinyurra nyinanytjaku. Ngurra walytjangka ngayulu nyurrangarrinya yaṉṯayaṉṯanmalpa.” Yitjikiyalalu tjananya yaṉangu tjuṯangka Katutjaku wangka piyuku watjaṉu yalatji, “Ngulaṉa nyurranya Katutjalu ngurra walytjakutu rayitpayiki katiku, Tjarutjalumalakutu. Ngurra palula nyurrangarri tjuṯalingku nyinaku. Waaḻa palyara mayi pakaltjingara palyalpinyurra piyuku ngurra palula nyinaku. Palunyatjanutjunyurra ngayuku wangkaku ninti nyinamalpa. Yaṉangu kutjungka kurrunpa walytjaṉa mantjira tjunku kurrunpa kutjupa. Palunyatjanu yaṉangu kutjupangkaṯarra kurrunpa walytja mantjira ngayulu kutjupalpiṉa tjunku. Yalatjiṉa nyurrangarrila yaṉangu tjuṯangka tjunku kurrunpa kutjupa, ngayukutjunyurra tjukarurru kutu nyinanytjaku. Ngayuku kurrunpaṯarra ngayulu nyurrangarrila tjarrpatjunku. Kurrunpa paluru nyurrangarrinya rapalku, ngayuku wangkaku nyurrangarri tjukarurru kutu nyinanytjaku.” ");
INSERT INTO piu2006_vpl VALUES ("EK3_1","027_3_1","EZK","3","1","27","(1:; 2:; 3:; 34:; 36:) Papilunanya ngurrara tjuṯangku tjananya Tjarutjalumanya ngurrara tjuṯa tjungura tjananya katirra kanyiṉingi ngurra Papilunangka, Tjarutjalumangka yila nyinanytja tjuṯaṯarra. Tjilirratjarra tjuṯangku tjananya kanyiṉangi ngurra walytjakutu rayitpayiki tjalkaḻungkupayingkamarra. Ngurra palulaya nyinarra watjilarringu, ngurra walytjaku. Yalatji watjilpa nyinarra kuliraya yalatji piipangka wakaṉu, “Ngurra Papilunangkalatju karrungka nyinarra yulangi, ngurra Tjarutjalumalakutu rayitpayiki yankukitja. Kiitawu wangkatjingantjawiyangkulatju katu tjunkula wantingu. Papilunanya ngurrara tjuṯangkulanyatju puṯu yinkatjingalkitjangku yalatjiya watjaṉu, ‘Tuḻku nyurrangarri Tjarutjalumala yinkapayinyurra, kuwarriya wangkatjingaraya yinka!’ Nganaṉatju Tjarutjalumanya ngurrara tjuṯangku tjananya watjaṉu, ‘Wiya. Ngurra kutjupangka wiyalatju yunyparrirra yinkakitjangku kuliṉi.’” Ngurra Papilunangka wati Yitjikiyalanya Katutjaku wangka watjalpayi nyinangi. Katutjalu nintintjala Yitjikiyalalu tjukurrpa nyangu yalatji. Kana nyinapayi puupala parra yankupayi, wiilatjarra nguwanpa. Yalatji nyakula kutjupa nyangu yaṉangu nguwanpa tjiiyingka nyinanytjala. Yaṉangu nguwanpa paluru Yitjikiyalanya piipa karrpilpa nintiṉu. Nintira watjaṉu ngalkunytjaku. Yitjikiyalalu ngalkuṉu. Palunyatjanu yaṉangu nguwanpa paluru Yitjikiyalanya watjaṉu, yankula Katutjaku wangka tjakultjunkunytjaku, Yitjurilaku walytja ngaṉṯitja tjuṯangka. Yalatji Yitjikiyalalu tjukurrmankula nyangu. Yitjikiyalalu tjananya yaṉangu tjuṯangka wangka kutjupa tjuṯa watjara, wangka yalatji tjananya mayutju tjuṯangka watjaṉu, Katutjalu nintintjala, “Ngayulu nyurrangarrinya mayutju tjuṯa watjaṉi. Tjiipi tjuṯaku mayutju nguwanpanyurra nyinanyi. Tjiipi tjuṯa nguwanpaya Yitjurilaku walytja ngaṉṯitja tjuṯa nyinarra waṉinyi. Tjiipiku mayutju tjuṯa nguwanpangku tjananya wiya nyurrangarri tjukarurrungku kanyilpayi. Tjiipiku mayutjungku mayi palyakutu tjiipi tjuṯa katipayi. Mayutju palunya nguwanpa wiyanyurra nyinanyi, wiyanyurra yaṉangu tjuṯa palyangku yaṉṯayaṉṯara kanyilpayi. Walytjaku kutjunyurra kulira nyinapayi yaṉangu tjuṯa tjukarurru kanyintjawiya. Yitjurilaku ngaṉṯitja tjuṯanyurra kutjupa kutjupa tjuṯangka kuwarri nyinarra waṉinyi, ngurra walytjawiyangka. Ngayulu nyurrangarrinya tjungulku ngurra walytjangkalpinyurra nyinanytjaku. Ngurra walytjangka ngayulu nyurrangarrinya yaṉṯayaṉṯanmalpa.” Yitjikiyalalu tjananya yaṉangu tjuṯangka Katutjaku wangka piyuku watjaṉu yalatji, “Ngulaṉa nyurranya Katutjalu ngurra walytjakutu rayitpayiki katiku, Tjarutjalumalakutu. Ngurra palula nyurrangarri tjuṯalingku nyinaku. Waaḻa palyara mayi pakaltjingara palyalpinyurra piyuku ngurra palula nyinaku. Palunyatjanutjunyurra ngayuku wangkaku ninti nyinamalpa. Yaṉangu kutjungka kurrunpa walytjaṉa mantjira tjunku kurrunpa kutjupa. Palunyatjanu yaṉangu kutjupangkaṯarra kurrunpa walytja mantjira ngayulu kutjupalpiṉa tjunku. Yalatjiṉa nyurrangarrila yaṉangu tjuṯangka tjunku kurrunpa kutjupa, ngayukutjunyurra tjukarurru kutu nyinanytjaku. Ngayuku kurrunpaṯarra ngayulu nyurrangarrila tjarrpatjunku. Kurrunpa paluru nyurrangarrinya rapalku, ngayuku wangkaku nyurrangarri tjukarurru kutu nyinanytjaku.” ");
INSERT INTO piu2006_vpl VALUES ("EK34_1","027_34_1","EZK","34","1","31","(1:; 2:; 3:; 34:; 36:) Papilunanya ngurrara tjuṯangku tjananya Tjarutjalumanya ngurrara tjuṯa tjungura tjananya katirra kanyiṉingi ngurra Papilunangka, Tjarutjalumangka yila nyinanytja tjuṯaṯarra. Tjilirratjarra tjuṯangku tjananya kanyiṉangi ngurra walytjakutu rayitpayiki tjalkaḻungkupayingkamarra. Ngurra palulaya nyinarra watjilarringu, ngurra walytjaku. Yalatji watjilpa nyinarra kuliraya yalatji piipangka wakaṉu, “Ngurra Papilunangkalatju karrungka nyinarra yulangi, ngurra Tjarutjalumalakutu rayitpayiki yankukitja. Kiitawu wangkatjingantjawiyangkulatju katu tjunkula wantingu. Papilunanya ngurrara tjuṯangkulanyatju puṯu yinkatjingalkitjangku yalatjiya watjaṉu, ‘Tuḻku nyurrangarri Tjarutjalumala yinkapayinyurra, kuwarriya wangkatjingaraya yinka!’ Nganaṉatju Tjarutjalumanya ngurrara tjuṯangku tjananya watjaṉu, ‘Wiya. Ngurra kutjupangka wiyalatju yunyparrirra yinkakitjangku kuliṉi.’” Ngurra Papilunangka wati Yitjikiyalanya Katutjaku wangka watjalpayi nyinangi. Katutjalu nintintjala Yitjikiyalalu tjukurrpa nyangu yalatji. Kana nyinapayi puupala parra yankupayi, wiilatjarra nguwanpa. Yalatji nyakula kutjupa nyangu yaṉangu nguwanpa tjiiyingka nyinanytjala. Yaṉangu nguwanpa paluru Yitjikiyalanya piipa karrpilpa nintiṉu. Nintira watjaṉu ngalkunytjaku. Yitjikiyalalu ngalkuṉu. Palunyatjanu yaṉangu nguwanpa paluru Yitjikiyalanya watjaṉu, yankula Katutjaku wangka tjakultjunkunytjaku, Yitjurilaku walytja ngaṉṯitja tjuṯangka. Yalatji Yitjikiyalalu tjukurrmankula nyangu. Yitjikiyalalu tjananya yaṉangu tjuṯangka wangka kutjupa tjuṯa watjara, wangka yalatji tjananya mayutju tjuṯangka watjaṉu, Katutjalu nintintjala, “Ngayulu nyurrangarrinya mayutju tjuṯa watjaṉi. Tjiipi tjuṯaku mayutju nguwanpanyurra nyinanyi. Tjiipi tjuṯa nguwanpaya Yitjurilaku walytja ngaṉṯitja tjuṯa nyinarra waṉinyi. Tjiipiku mayutju tjuṯa nguwanpangku tjananya wiya nyurrangarri tjukarurrungku kanyilpayi. Tjiipiku mayutjungku mayi palyakutu tjiipi tjuṯa katipayi. Mayutju palunya nguwanpa wiyanyurra nyinanyi, wiyanyurra yaṉangu tjuṯa palyangku yaṉṯayaṉṯara kanyilpayi. Walytjaku kutjunyurra kulira nyinapayi yaṉangu tjuṯa tjukarurru kanyintjawiya. Yitjurilaku ngaṉṯitja tjuṯanyurra kutjupa kutjupa tjuṯangka kuwarri nyinarra waṉinyi, ngurra walytjawiyangka. Ngayulu nyurrangarrinya tjungulku ngurra walytjangkalpinyurra nyinanytjaku. Ngurra walytjangka ngayulu nyurrangarrinya yaṉṯayaṉṯanmalpa.” Yitjikiyalalu tjananya yaṉangu tjuṯangka Katutjaku wangka piyuku watjaṉu yalatji, “Ngulaṉa nyurranya Katutjalu ngurra walytjakutu rayitpayiki katiku, Tjarutjalumalakutu. Ngurra palula nyurrangarri tjuṯalingku nyinaku. Waaḻa palyara mayi pakaltjingara palyalpinyurra piyuku ngurra palula nyinaku. Palunyatjanutjunyurra ngayuku wangkaku ninti nyinamalpa. Yaṉangu kutjungka kurrunpa walytjaṉa mantjira tjunku kurrunpa kutjupa. Palunyatjanu yaṉangu kutjupangkaṯarra kurrunpa walytja mantjira ngayulu kutjupalpiṉa tjunku. Yalatjiṉa nyurrangarrila yaṉangu tjuṯangka tjunku kurrunpa kutjupa, ngayukutjunyurra tjukarurru kutu nyinanytjaku. Ngayuku kurrunpaṯarra ngayulu nyurrangarrila tjarrpatjunku. Kurrunpa paluru nyurrangarrinya rapalku, ngayuku wangkaku nyurrangarri tjukarurru kutu nyinanytjaku.” ");
INSERT INTO piu2006_vpl VALUES ("EK36_1","027_36_1","EZK","36","1","38","(1:; 2:; 3:; 34:; 36:) Papilunanya ngurrara tjuṯangku tjananya Tjarutjalumanya ngurrara tjuṯa tjungura tjananya katirra kanyiṉingi ngurra Papilunangka, Tjarutjalumangka yila nyinanytja tjuṯaṯarra. Tjilirratjarra tjuṯangku tjananya kanyiṉangi ngurra walytjakutu rayitpayiki tjalkaḻungkupayingkamarra. Ngurra palulaya nyinarra watjilarringu, ngurra walytjaku. Yalatji watjilpa nyinarra kuliraya yalatji piipangka wakaṉu, “Ngurra Papilunangkalatju karrungka nyinarra yulangi, ngurra Tjarutjalumalakutu rayitpayiki yankukitja. Kiitawu wangkatjingantjawiyangkulatju katu tjunkula wantingu. Papilunanya ngurrara tjuṯangkulanyatju puṯu yinkatjingalkitjangku yalatjiya watjaṉu, ‘Tuḻku nyurrangarri Tjarutjalumala yinkapayinyurra, kuwarriya wangkatjingaraya yinka!’ Nganaṉatju Tjarutjalumanya ngurrara tjuṯangku tjananya watjaṉu, ‘Wiya. Ngurra kutjupangka wiyalatju yunyparrirra yinkakitjangku kuliṉi.’” Ngurra Papilunangka wati Yitjikiyalanya Katutjaku wangka watjalpayi nyinangi. Katutjalu nintintjala Yitjikiyalalu tjukurrpa nyangu yalatji. Kana nyinapayi puupala parra yankupayi, wiilatjarra nguwanpa. Yalatji nyakula kutjupa nyangu yaṉangu nguwanpa tjiiyingka nyinanytjala. Yaṉangu nguwanpa paluru Yitjikiyalanya piipa karrpilpa nintiṉu. Nintira watjaṉu ngalkunytjaku. Yitjikiyalalu ngalkuṉu. Palunyatjanu yaṉangu nguwanpa paluru Yitjikiyalanya watjaṉu, yankula Katutjaku wangka tjakultjunkunytjaku, Yitjurilaku walytja ngaṉṯitja tjuṯangka. Yalatji Yitjikiyalalu tjukurrmankula nyangu. Yitjikiyalalu tjananya yaṉangu tjuṯangka wangka kutjupa tjuṯa watjara, wangka yalatji tjananya mayutju tjuṯangka watjaṉu, Katutjalu nintintjala, “Ngayulu nyurrangarrinya mayutju tjuṯa watjaṉi. Tjiipi tjuṯaku mayutju nguwanpanyurra nyinanyi. Tjiipi tjuṯa nguwanpaya Yitjurilaku walytja ngaṉṯitja tjuṯa nyinarra waṉinyi. Tjiipiku mayutju tjuṯa nguwanpangku tjananya wiya nyurrangarri tjukarurrungku kanyilpayi. Tjiipiku mayutjungku mayi palyakutu tjiipi tjuṯa katipayi. Mayutju palunya nguwanpa wiyanyurra nyinanyi, wiyanyurra yaṉangu tjuṯa palyangku yaṉṯayaṉṯara kanyilpayi. Walytjaku kutjunyurra kulira nyinapayi yaṉangu tjuṯa tjukarurru kanyintjawiya. Yitjurilaku ngaṉṯitja tjuṯanyurra kutjupa kutjupa tjuṯangka kuwarri nyinarra waṉinyi, ngurra walytjawiyangka. Ngayulu nyurrangarrinya tjungulku ngurra walytjangkalpinyurra nyinanytjaku. Ngurra walytjangka ngayulu nyurrangarrinya yaṉṯayaṉṯanmalpa.” Yitjikiyalalu tjananya yaṉangu tjuṯangka Katutjaku wangka piyuku watjaṉu yalatji, “Ngulaṉa nyurranya Katutjalu ngurra walytjakutu rayitpayiki katiku, Tjarutjalumalakutu. Ngurra palula nyurrangarri tjuṯalingku nyinaku. Waaḻa palyara mayi pakaltjingara palyalpinyurra piyuku ngurra palula nyinaku. Palunyatjanutjunyurra ngayuku wangkaku ninti nyinamalpa. Yaṉangu kutjungka kurrunpa walytjaṉa mantjira tjunku kurrunpa kutjupa. Palunyatjanu yaṉangu kutjupangkaṯarra kurrunpa walytja mantjira ngayulu kutjupalpiṉa tjunku. Yalatjiṉa nyurrangarrila yaṉangu tjuṯangka tjunku kurrunpa kutjupa, ngayukutjunyurra tjukarurru kutu nyinanytjaku. Ngayuku kurrunpaṯarra ngayulu nyurrangarrila tjarrpatjunku. Kurrunpa paluru nyurrangarrinya rapalku, ngayuku wangkaku nyurrangarri tjukarurru kutu nyinanytjaku.” ");
INSERT INTO piu2006_vpl VALUES ("DN1_1","028_1_1","DAN","1","1","7","Tjuutaku walytja ngaṉṯitja tjuṯa tawunu tiṉa palula Papilunangka nyinangi. Papilunanya ngurrara tjuṯaku mayutju tiṉa Nipukanitjalu palumpa waarrkana yalatji watjaṉu, “Yitjurilaku ngaṉṯitja tjuṯakutu yankula yangupala ninti tjuṯanya ngurrtjara mantjira ngalya kati!, mayutju tjuṯaku katja tjuṯa. Ngalya kati tjananya!, ngayuku ngurra tiṉawana waarrkarrinytjaku. Yangupala yuṉpa palya kutju ngalya kati!, tjukarurru kulilpayi tjuṯa.” Waarrkana paluru yankula tjananya ngurrtjara mantjiṉu yangupala tjuṯa, yini yalatjiya nyinangi, Taniyalanya, Yananayanya, Mitjilanya Yatjarayanya. Paluru tjana Tjuutaku walytja ngaṉṯitja tjuṯa nyinangi. Ngalya katirra tjananya rawangku nintiṉingi yiiya tjirripala, Papilunanya ngurrara tjuṯaku wangka riitarrirra wakantjaku. Kuula nguwanpa palula nyinarra nintirringuya piipa kutjupa tjuṯaku. Mayutju tiṉaku waarrkana paluru tjananya yini kutjupa watjaṉu. Taniyalanya yini kutjupa Piltatjatjanya watjaṉu. Yananayanya yini kutjupa Tjatarakanya watjaṉu. Mitjilanya yini kutjupa Mitjakanya watjaṉu. Yatjarayanya yini kutjupa Yapinikunya watjaṉu. Kuula palula tjana nintirringkula wiyarringu. Palulanguru mayutju Nipukanitjalu tjananya yangupala palunya tjananya yilaṯu yilaṯu tjapiṉingi yarrkalkitjangku. Yangupala palunya puupala, Taniyalanyangarriku wangka kulira pukuḻarringu, nintilingkuya nyinanytjala. Palunyatjanu Taniyalanyangarriya palumpa waaḻawana mayutjulpi waarrkarripayi. Puṯu kulira nintirrikitjangku tjananya tjapilpayi, mayutju Nipukanitjalu. ");
INSERT INTO piu2006_vpl VALUES ("DN2_1","028_2_1","DAN","2","1","49","Palunyatjanu mayutju Nipukanitjalu mungangka yanku ngarrirra tjukurrpa nyangu. Kanarrirra nguḻu ngarringi, nintirrikitjangku puṯu kulira. Palumpa waarrkana ninti tjuṯa tjananya yaḻṯingu ngalya yankula tjukurrpa panyapa nintintjaku. Nipukanitjalu kuliṉu, “Ngayuluṉa tjananya wiya tjakultjunku tjukurrpa, paluru tjana ngayunya nintingku watjantjaku.” Paluru tjananya watjaṉu, “Munga kuwarriṉa tjukurrpa nyangutjangka tjakultjurraṉiya! Yalatjiṉiya tjakultjunkula tjukurrpatjanungkaṉiya nintila!” Tjanaya watjaṉu, “Nyuntu tjukurrpa nyakula nganaṉanya tjakultjurra! Tjakultjunkunytja kulira kutjulatjunta nintilku.” Nipukanitjalu tjananya piyuku watjaṉu, “Wiya. Nyurrangarri ngayunya tjukurrpa palunya tjakultjurra! Tjukarurrungkuṉinyurra tjakultjunkunytjawiyangka watjalkuṉa tjananya waarrkana kutjupa tjuṯangku nyurrangarrinya mirrintankunytjaku yalatji. Mara kutjarra nyurrangarrinya watiya tiṉangka tjana tayimapilku. Tjina kutjarraṯarralpi ruupatjarrangku tayimapira pulukangka tjunku, puulamilara mirrintankunytjaku. Yalatjiṉa tjananya watjalku ninti tjuṯa nyurrangarrinya puulamilara mirrintankunytjaku. Tjinguru tjukarurrungkuṉinyurra tjakultjunkula nintintjala mani yulytja tiṉaṉa nyurranya yungku.” Puṯuya tjukurr palunyaku kulira tjakultjunkunytjawiyaya. Nipukanitjanya tjanampa pikarringkula tjananya watjaṉu ninti tjuṯa tjananya puulamilara mirrintankunytjaku, kutjupa tjuṯaṯarra waaḻa kutjupangka yunngu nyinanytja tjuṯa. Taniyalanyangarriya ninti tjuṯa waaḻa palula nyinangi. Nipukanitjaku wangka kulira Taniyalalu tjananya palumpa maḻpa tjuṯanya watjaṉu tjungungkuya Katutjanya tjapintjaku. Palunya tjuṯangkuya Katutjanya tjapiṉu, tjukurrpa palunya Nipukanitjaku tjukarurru tjakultjunkula nintintjaku. Munga palula Katutjalu tjukurrpa palunya nintiṉu Taniyalanya. Kulira paluru Katutjanya waḻkuṉu. Aaḻi pakara Taniyalalu yankula mayutju panyapangka watjaṉu mayutju tiṉakutu yankula tjukurrpa nintilkitjangku. Mayutju paluru Taniyalanya katingu Nipukanitjala tjakultjunkunytjaku, kanya mayutju kutjupangku tjananya ninti tjuṯa mirrintankutjipingkamarra. Mayutju paluru mayutju tiṉa Nipukanitjala yalatji watjaṉu, “Tjuwu kutju ngaangku, yini Taniyalalunta tjukurrpa panyapa tjakultjunkula nintilku.” Taniyalalu ngarala Nipukanitjala yalatji tjakultjunu, “Mayutju Katutjaluṉi munga kuwarri nintiṉu nyuntu tjukurrpa nyangutjangka. Yalatjinu nyangu. Yaṉangu manpaṯa waṯawara ngaranyingka nyuntu nyangu, paluru tili nguwanpa. Kata palunya kuultatjanu palyaṉutja ngarangi. Ngarrka anta miṉa tjiilpatjanu palyaṉutja ngarangi. Tjuni anta yangkaḻpa yayina tjatjakatjanu palyaṉutja ngarangi. Tjunta kutjarra yayina anta mantatjanu palyaṉutja ngarangi. Palunyatjanu puḻi tiṉangku katunguru punkara tjina paḻira yuḻpuṉu. Palunyangka yaṉangu nguwanpa palunya punkara yuḻpurrirra paṉa nguwanpa ngarringi. Palunyangka waḻpangku rungkara wiyaṉu, kanya puḻi paluru tiṉarringkula ngarangi, ngurra tjuṯangka.” Nipukanitjala Taniyalalu piyuku watjaṉu, “Mayutju, tjukurrpatjanungkaṉanta nintilku. Kata kuulta palunya nyakula nyuntu yalatji kulintjaku. Kuulta mani tiṉa. Mani tiṉa nguwanpa nyuntu mayutju tiṉa nyinanyi. Ngula mayutju kutjupangku tjananya yaṉangu tjuṯa kanyilku. Ngarrka anta miṉa tjiilpatjanu palyaṉutja nyuntu nyangu. Tjiilpa palunya mani tiṉa nguwanpa mayutju tiṉa kutjupa nyinaku. Nyuntu mayutju nyinarra wiyarriku, mayutju tiṉa kutjupalpi nyinaku. Palunyatjanu mayutju kutjupangku tjananya yaṉangu tjuṯa kanyilku. Yalatji mayutju tjirripalangku tjananya kanyilku. Palunyatjanu Katutjalulpi tjananya mayutju tiṉangku yaṉṯayaṉṯara kanyilku.” Yalatji Taniyalalu tjakultjunkula tjukarurru nintintjala, mayutju Nipukanitjanya yunyparringu. Palunyatjanu Taniyalaku mani anta yulytja tiṉa yungkula mayutju tiṉa tjanampa nyinatjunu, Papilunanya ngurrara tjuṯaku. Taniyalaku maḻpa tjirripalaṯarra tjananya mayutju nyinatjunu. ");
INSERT INTO piu2006_vpl VALUES ("DN3_1","028_3_1","DAN","3","1","19","Mayutju Nipukanitjanya kana nyinanytjala, palumpa waarrkana tjuṯangkuya Nipukanitjanya nguwanpa tiṉaya kuultatjanu palyara ngaratjunu, Nipukanitjalu tjananya watjantjala. Tawunu Papilunangka yila yurilpangka palyara ngaratjunu. Palunyatjanu tjana aḻṯingu aṉangu tjuṯa, kuultatjanu palyaṉutja palula tjungurrinytjaku. Tjungurringkula tjananya mayutju Nipukanitjaku waarrkanalu watjaṉu, “Turampata kiitawuṯarraya tjiṉṯukarrangu tjiṉṯungka wangkatjingalku. Yalatji mutjika wangkatjingantjalanyurra ngurrangurungku kulira pupakatirranyurra ngaatjanya Nipukanitjanya nguwanpa palyaṉutja waḻkuntjaku. Yaṉangungku kulira wantinytjala waḻkuntjawiyangku, waru tiṉakutulatju katirra yuṉṯura waṉiku, kamparra wiyarrinytjaku.” Palunyangka yaṉangu tjuṯangkuya mutjika palunya kulira kuultatjanu palyaṉutja palulakutu yankula waḻkuṉingi. Palunyangka Tjuwu tjuṯaku yunytjuwiya tjuṯangkuya mayutju Nipukanitjala yankula yalatji tjakultjunu, “Tjuwu palunya tjirripala nyuntu tjananya mayutju nyinatjunu. Paluru tjana wiya waḻkuṉi ngaratjunutjanya. Yini yalatjiya nyinanyi Tjatarakanya, Mitjakanya, Yapinikunya. Nyuntupaya mayutjuku kulintjawiya nyinanyi, palunya ngaratjunutja waḻkuntjawiyaya. Nyuntupa wangkaya kulira wantinyi.” Kulira mayutju Nipukanitjalu yuṉpa wayilarrirra waarrkana wantirriyaṉu witira tjananya Tjatarakanyangarri ngalya katinytjaku. Ngalya yankulaya ngaranytjala tjapiṉu tjananya, “Nyaaku nyurrangarri ngaratjunutja nyangangi waḻkuntjawiyangku?” Piyuku tjananya watjaṉu, “Nyurrangarrimpa mayutju tiṉa Katutjalu nyurranya puṯu kanalku, waru tiṉangkanyurra kamparra wiyarriku.” Tjatarakalungarri yalatji watjaṉu, “Yiltalatju wiya kuultatjanu palyaṉutja palunya waḻkulpayi, mayutju Katutjalulanyatju kanalku waru tiṉangkamarra. Yalatjilatju kuliṉi. Tjinguru Katutjalulanyatju kanalkitjangku kulintjawiyangka, kutulatju Katutja palunya waḻkunmalpa, wantiwiyangku. Kuultatjanu palyaṉutja palunya wiyalatju waḻkulku.” Palunyatjanu mayutju Nipukanitjalu tjananya wayilarringkula watjaṉu waarrkana tjuṯangku tjananya katirra waru tiṉangka yuṉṯura tjarrpatjunkunytjaku. ");
INSERT INTO piu2006_vpl VALUES ("DN3_20","028_3_20","DAN","3","20","30","Tjana wati tjirripala palunya Tjatarakanya, Mitjakanya, Yapinikunya ruupangka tayimapiraya katirra waru tiṉa palula yuṉṯura tjarrpatjunu, tjilirratjarra tjirripalangku. Tjilirratjarra tjirripala palunya waru tiṉangku kamparra yiluntanu, yuṉṯuraya tjarrpatjunkunytjala. Palunyangka mayutju Nipukanitjalu warukutu nyakula puṯu kulira waarrkanangka yalatji tjapiṉu, “Wati tjirripalampaya katirra warungka tjarrpatjunu, yilta?” Waarrkana paluru yuwa watjaṉu. Nipukanitjalu watjaṉu, “Wati puupalaṉa nyanganyi warungka parra ngaranytjala. Ruupawiyaya parra ngaranyi. Wati kutjupa Katutjanya nguwanpaṉa nyanganyi.” Nyakula Nipukanitjalu warungka ilarringkula raapangku tjananya watjaṉu, “Tjataraka, Mitjaka, Yapiniku, ngalya pakalaya! Mayutju tiṉa Katutjaku waarrkana tjuṯa kananyurra ngaranyi.” Palunyangkaya palya pakaṉu mantarraṯarra kampawiya. Nipukanitjalu tjananya yaṉangu tjuṯa watjaṉu, “Mayutju Katutjanyalaka waḻkula! Katutjalu palumpa waarrkana ilkari ngurrara wantirriyaṉu Tjatarakanyangarri kanantjaku. Katutja palunya wiyala panypurangkunytjaku, yaṉangungku panypurangkunytjala ngayuluṉa panitjimilaltjipingkamarra.” Nipukanitjalu watjaṉu Tjatarakanyangarri mayutju tiṉa tjirripalalpiya nyinanytjaku. ");
INSERT INTO piu2006_vpl VALUES ("DN5_1","028_5_1","DAN","5","1","31","Papilunanya ngurrara tjuṯaku mayutju tiṉa Nipukanitjanya nyinarra mirrirringu. Palunyatjanu palumpa katja Pilytjatjanya tjanampa mayutju tiṉa nyinangi. Mayutju Pilytjatjalu tjananya palumpa waarrkana mayutju tjuṯa yaḻṯingu, tjunguya ngalkula tjikira yunyparrinytjaku. Tjungurringkulaya pulakina tjikintjala Pilytjatjalu tjananya waarrkana kutjupa tjuṯangka watjaṉu yankula panikina palya tjuṯa mantjira ngalya katinytjaku. Panikina palunya tjuṯa palumpa paapangkungarri yirriṯi mantjiṉu Katutjaku tjaatjingka, tawunu Tjarutjalumangka. Mantjiraya ngalya katinytjala panikina palunya tjuṯangka tjana pulakina yintira tjikilpayi, Katutjanya nguwanpa kutjupa tjuṯa waḻkulpayi. Katutjaku yulytjangka tjikira Katutjanya nguwanpa kutjupa tjuṯa waḻkuntjawiyangkuya wantimara. Palunyangka waaḻangka katu marangku kutu wangka wakara wanaṉu, yaṉangungku ngarala wakantjawiya. Mayutju Pilytjatjalu wakaṉutja nyakula puṯu riitarrirra nguḻurringkula tititingarangu. Waarrkana kutjungka paluru raapangku watjaṉu ninti tjuṯa tjananya yaḻṯirra ngalya katinytjaku. Ngalya yankulaya ngaranytjala mayutju Pilytjatjalu tjananya watjaṉu, “Katuya nyawa!, waaḻangka wakaṉutja ngaranyi. Puṯulatju riitarringu, wangka kutjupa ngaranyi. Kutjungkuṉi riitarrirra nintintjala, wati palunya mantarra palyangkalpiṉa tjarrpatjunkula nyinatjunku.” Puṯuya riitarrirra nintintjala kutjupangku watjaṉu Taniyalanya yaḻṯinytjaku. Taniyalanya ngalya yankula ngaranytjala, mayutju Pilytjatjalu tjapiṉu wangka palunya riitarrirra nintintjaku. Palunyatjanu Taniyalalu Pilytjatjanya alatji watjaṉu, “Nyuntupa paapa, kutu Katutjaku wiyawana nyinarra tjukarurrurringkula palyalpi nyinapayi. Palunya nguwanpa, nyuntu Pilytjatja, wiyanu palya nyinanyi. Katutjaku yulytjanyurra panikina tjuṯa mantjira tjikilpayi, Katutjaku nguḻurringkunytjawiyangku. Yalatjinyurra tjikira Katutjanya nguwanpa tjuṯa waḻkulpayi, Katutjanya kutju kulintjawiyangku. Palunyatjanu Katutjalu wangka palatja wakara tjunu, nyuntunyanta nintilkitjangku. Wangka palatja yalatji ngaranyi. Nyuntu mayutjuwiyalpi nyinaku. Mayutju kutjarra kutjupangkulpi tjananya nyuntupa waarrkana tjuṯa kanyilku, kutju Mitiyanya ngurrarangku kutjupa Patjanya ngurrarangku.” Palunyangka mayutju Pilytjatjalu watjantjala, Taniyalanya mantarra palyangka tjarrpatjunkula nikilitji mayutjukuṉu waralytjunu nguṉṯiwana. Papilunanya ngurrara tjuṯaku mayutju tiṉalpi nyinangu, nampa tjirri. Munga palula kutjupa tjuṯangkuya Pilytjatjanya mirrintanu. Wati Tjaratjanyalpi tjanampa mayutju tiṉalpi nyinangi. ");
INSERT INTO piu2006_vpl VALUES ("DN6_1","028_6_1","DAN","6","1","9","Mayutju Nipukanitjanya mirrirrinytjala palumpa katja Pilytjatjanya wiyawana nyinangi. Palumpa waarrkana tjirripalangku mungangka mirri pungu. Palunyatjanu tjanampa Papilunanya ngurrara tjuṯaku mayutju tiṉa Tarayatjanya nyinangi. Mayutju Tarayatjalu yaṉangu tjuṯa ngurrtjara mayutju tjuṯa waan yantaṯan tuuntiyi ngaratjunu. Kamantaku mayutju palunya tjuṯangku paṉa kutjupa kutjupa ngurrara tjananya kanyiṉingi. Palunyatjanu tjananya mayutju Tarayatjalu Taniyalanya anta mayutju kutjarra kutjupa ngurrtjaṉu mayutju tiṉa tjirripalalpiya nyinanytjaku. Tjanaya mayutju panyapa tjuṯa, waan yantaṯan tuuntiyiku mayutju tiṉa nyinangi. Taniyalanya waarrka yatjikingku palyalpayi nyinangi. Palunyatjanu mayutju tiṉa Tarayatjanyara yunypa nyinangi, kanya mayutju palunya kutjarraṯarrara Taniyalaku yunytjuwiya nyinangi, mayutju kutjupa tjuṯaṯarra. Tjanaya yunytjurringu mayutju Tarayatjalu Taniyalanya payira wantirriyantjaku. Puṯuya kuliṉu Tarayatjanya tjingapungkunytjaku Taniyalanya payira wantirriyantjaku. Palunyatjanuya rawangku kulira mayutju Tarayatjalakutu yankula yalatji watjaṉu, Taniyalanya wantirriyalkitjangku. Yalatjiya watjaṉu, “Tarayatja. Nyuntu mayutju tiṉalampa palya nyinanyi. Nganaṉatju kuliṉi nyuntunya kutjulatjunta yaṉangu tjuṯangku tjapira waḻkuntjaku, kutjupa tjapira waḻkuntjawiyangku. Katutjanya nguwanpa kutjupangka yaṉangu kutjupangkaṯarra, wiyalatju tjapira waḻkuntjaku. Purayitiyi puupala nyuntunya kutjulatjunta Tarayatjanya tjapira waḻkuntjaku.” Wangka yalatji kulira mayutju Tarayatjalu yunyparringkula watjaṉu luwu palunya nguwanpa ngaranytjaku, Tarayatjanya kutjuya waḻkuntjaku. Mayutju paluru watjaṉu tjinguru yaṉangungku, Katutjangka tjinguru Katutjanya nguwanpa kutjupangka, tjinguru yaṉangu kutjupangka tjapira waḻkuntjala, katirraya layina tjuṯangka tjarrpatjunkunytjaku, ngalkulaya wiyantjaku. Yalatji luwu watjara wantingu Purayitiyi puupala ngaranytjaku. Yirriṯi yalatji luwu watjara wantirra wiya mayutjulu tjinytjimilalpayi. ");
INSERT INTO piu2006_vpl VALUES ("DN6_10","028_6_10","DAN","6","10","15","Luwu palunya mayutju Tarayatjalu watjara wantinytjala, Taniyalalu kulira ngurrakutu yankula waaḻangka kaḻparra katu nyinangu. Palulanguru paluru tawunu Tjarutjalumalakutu wintawuwana nyakula pupakatirra Katutjanya tjapiṉu. Yalatji Katutjanya irriṯi tjapilpayi, aaḻi, kaḻaḻa, mungarrtji. Mayutju paluru tjana nintiya nyinangu Taniyalalu ngurrangurungku Katutjanya tjapilpayi. Paluru tjana palumpa ngurrakutu yankula nyangu, Taniyalalu pupakatirra tjapintjala. Nyakulaya yankula mayutju tiṉa Tarayatjangka yalatji tjakultjunu, “Nyuntupa wangka kulintjawiyangku Taniyalalu mayutju Katutjanya kutu tjapilpayi, aaḻi, kaḻaḻa, mungarrtji. Katutjanya kutju tjapilpayi nyuntu Tarayatjanya tjapira waḻkuntjawiyangku.” Mayutju Tarayatjalu kulira Taniyalaku watjilarringu, layina tjuṯangkamarra kanalkitjangku puṯu kuliṉangi, tjiṉṯu maa tjarrpanytjala. Tjiṉṯu maa tjarrpanytjala mayutju paluru tjana yankula mayutju tiṉangka yalatji watjaṉu, “Paluru nyuntunya kutju tjapira waḻkuntjaku, yalatji luwu ngaranyi. Nyuntu luwu watjara wantinytjala, Taniyalanya layina tjuṯakutuya katirra tjarrpatjunkunytjaku, nyuntunya waḻkuntjawiya.” ");
INSERT INTO piu2006_vpl VALUES ("DN6_16","028_6_16","DAN","6","16","28","Palunyatjanu mayutju Tarayatjalu watjaṉu, Taniyalanyaya witira katirra layina tjuṯangka tjarrpatjunkunytjaku. Paluru tjana tjarrpatjunkukitjangka mayutju Tarayatjalu Taniyalanya yalatji watjaṉu, “Yunytjurringanyiṉa nyuntupa mayutju tiṉangkunta Katutjalu kanantjaku layina pikaṯi tjuṯangkamarra. Nyuntu palumpa tjukarurru nyinapayi.” Yalatji watjara wantirriyaṉu layina tjuṯakutuya katinytjaku. Mayutju paluru mungangka puṯu yanku ngarringu. Taniyalanyatjirratjangku kulira kana ngarringi. Aaḻi pakara mayutju Tarayatjalu layina tjuṯaku ngurrakutu yankula Taniyalanya yalatji yaḻṯirra watjaṉu, “Taniyala, nyuntu mayutju Katutjaku tjukarurru nyinapayi. Tjinguru mayutju tiṉangku Katutjalunta kanaṉu?, layina tjikipaka tjuṯangkamarra.” Taniyalalu layina tjuṯangka nyinarra watjaṉu, “Mayutju tiṉangku Katutjalu palumpa waarrkana ilkari ngurrara ngalya wantirriyaṉu, layina tjikipaka tjuṯa tjananya marrkuntjaku, ngayunyaṉiya patjalpayingkamarra. Tjanaya ngayunya tjarrpatjunkunytjawiyangku wantimara. Wiya ngayuluṉa kuya palyalpayi. Yalatji Katutjalu kulira palumpa ilkari ngurraratju ngalya wantirriyaṉu.” Palunyatjanu mayutju Tarayatjalu yunyparringkula waarrkana tjuṯangka watjaṉu, Taniyalanyaya alytjurankula pakaltjingantjaku. Taniyalalu mayutju Katutjanya kuliṉutja kana nyinangi, palumpa walytja. Palunyatjanu mayutju Tarayatjalu watjaṉu tjana mayutju palunya tjuṯa tjananya Taniyalaku yunytjuwiya tjuṯa, witira katirra layina tjikipaka tjuṯangka tjarrpatjunkunytjaku. Palunyangka tjananya waarrkana tjuṯangku mayutju palunya tjananya witira katirra layina tjuṯangka waṉingu, tjanampa walytja tjuṯaṯarra. Layina tjuṯangku tjananya patjara wiyaṉu. Mayutju Tarayatjalu tjananya yaṉangu uwankarra watjaṉu, Taniyalaku mayutju tiṉa Katutjaku nguḻurrirra nyinanytjaku. ");
INSERT INTO piu2006_vpl VALUES ("HS1_1","029_1_1","HOS","1","1","1","(1:1; 4:1,2; 9:3,4) Mayutju maṉkurrpa tjanampa Tjuutaku walytja ngaṉṯitja tjuṯa nyinangi, yini yalatji, Yatjayanya, Tjuutjamanya, Yiiyatjanya Yitjikayanya. Palunyatjanu tjanampa mayutju tiṉa Tjiripumanya Tjiyuwatjaku katja nyinangi, Yitjurilaku walytja ngaṉṯitja tjuṯaku. Mayutju paluru tjuṯaya nyinanyingka wati Wutjiyalu tjananya yalatji Katutjaku wangka tjakultjunu, “Yitjurilaku walytja ngaṉṯitja tjuṯangkuya kulila! Ngayulu Katutjalu nyurranya yilta yitjipungku, tjukarurru nyinanytjawiyangka, kuyanyurra kutu palyara nyinanytjala. Kutjupa ngurrara tjuṯangku nyurranya ngalya yankula pikangku pungkuku. Ngayunyaṉinyurra kulilwiyangku wantingutjangka ilta ngayulu nyurrangarrinya ngurra kutjupakutu iyalku waarrkana tjuṯa nyinanytjaku. Mayutju kutjupangkulpi nyurranya kanyilku, wiyanyurra mayutju walytjatjarra nyinaku. Ngurra palulanyurra nyinarra wiyalpiṉinyurra pungkula kutjanmalpa tjawirrilyi. Ngula kutjulpiṉinyurra ngalya yankula ngayunya puḻkapungku, ngurra walytjangka, palyalpinyurra nyinaku.” ");
INSERT INTO piu2006_vpl VALUES ("HS4_1","029_4_1","HOS","4","1","2","(1:1; 4:1,2; 9:3,4) Mayutju maṉkurrpa tjanampa Tjuutaku walytja ngaṉṯitja tjuṯa nyinangi, yini yalatji, Yatjayanya, Tjuutjamanya, Yiiyatjanya Yitjikayanya. Palunyatjanu tjanampa mayutju tiṉa Tjiripumanya Tjiyuwatjaku katja nyinangi, Yitjurilaku walytja ngaṉṯitja tjuṯaku. Mayutju paluru tjuṯaya nyinanyingka wati Wutjiyalu tjananya yalatji Katutjaku wangka tjakultjunu, “Yitjurilaku walytja ngaṉṯitja tjuṯangkuya kulila! Ngayulu Katutjalu nyurranya yilta yitjipungku, tjukarurru nyinanytjawiyangka, kuyanyurra kutu palyara nyinanytjala. Kutjupa ngurrara tjuṯangku nyurranya ngalya yankula pikangku pungkuku. Ngayunyaṉinyurra kulilwiyangku wantingutjangka ilta ngayulu nyurrangarrinya ngurra kutjupakutu iyalku waarrkana tjuṯa nyinanytjaku. Mayutju kutjupangkulpi nyurranya kanyilku, wiyanyurra mayutju walytjatjarra nyinaku. Ngurra palulanyurra nyinarra wiyalpiṉinyurra pungkula kutjanmalpa tjawirrilyi. Ngula kutjulpiṉinyurra ngalya yankula ngayunya puḻkapungku, ngurra walytjangka, palyalpinyurra nyinaku.” ");
INSERT INTO piu2006_vpl VALUES ("HS9_3","029_9_3","HOS","9","3","4","(1:1; 4:1,2; 9:3,4) Mayutju maṉkurrpa tjanampa Tjuutaku walytja ngaṉṯitja tjuṯa nyinangi, yini yalatji, Yatjayanya, Tjuutjamanya, Yiiyatjanya Yitjikayanya. Palunyatjanu tjanampa mayutju tiṉa Tjiripumanya Tjiyuwatjaku katja nyinangi, Yitjurilaku walytja ngaṉṯitja tjuṯaku. Mayutju paluru tjuṯaya nyinanyingka wati Wutjiyalu tjananya yalatji Katutjaku wangka tjakultjunu, “Yitjurilaku walytja ngaṉṯitja tjuṯangkuya kulila! Ngayulu Katutjalu nyurranya yilta yitjipungku, tjukarurru nyinanytjawiyangka, kuyanyurra kutu palyara nyinanytjala. Kutjupa ngurrara tjuṯangku nyurranya ngalya yankula pikangku pungkuku. Ngayunyaṉinyurra kulilwiyangku wantingutjangka ilta ngayulu nyurrangarrinya ngurra kutjupakutu iyalku waarrkana tjuṯa nyinanytjaku. Mayutju kutjupangkulpi nyurranya kanyilku, wiyanyurra mayutju walytjatjarra nyinaku. Ngurra palulanyurra nyinarra wiyalpiṉinyurra pungkula kutjanmalpa tjawirrilyi. Ngula kutjulpiṉinyurra ngalya yankula ngayunya puḻkapungku, ngurra walytjangka, palyalpinyurra nyinaku.” ");
INSERT INTO piu2006_vpl VALUES ("JL1_1","030_1_1","JOL","1","1","20","(1:; 2:) Katutjalu wati Tjuwulanya nintiṉu yalatji tjananya Katutjaku wangka tjakultjunkunytjaku, Yitjurilaku walytja ngaṉṯitja tjuṯakutu, “Tjuṯangkuya wangka kulila!, tjiḻpi tjuṯangkuṯarra. Wangka ngaatjanya tjananya katjapiṯingka yuṉṯalpiṯingka nintila! Palunya tjuṯangkuya kulira tiṉarrirra tjanampaṉu katjapiṯingka yuṉṯalpiṯingka nintintjaku. Kutuya kulila! Kutjupa tjuṯangku nyurrangarrimpa ngurrangka ngalya yankula pikangku pungkula kilytjuntanku. Palunyatjanu kutjupa tjuṯangku nyurrangarrinya ngalya yankula piyuku pikangku pungkula ngurra tjuṯa kilytjuntanku. Yalatji nyurranya tjuṯa kutjupangku tjuṯa kutjupangkuya ngalya yankula pikangku pungkula ngurra tjuṯa kilytjuntankula wiyalku. “Ngula ngayuluṉa Katutjalu nyurrangarrimpa walytja ngaṉṯitja tjuṯangka tjananya ngayuku kurrunpa wantirriyara tjarrpatjunku. Palunyatjanuya ngayuku wangka tjakultjurinamalpa nyurrangarrimpa walytja ngaṉṯitja tjuṯangku.” ");
INSERT INTO piu2006_vpl VALUES ("JL2_1","030_2_1","JOL","2","1","32","(1:; 2:) Katutjalu wati Tjuwulanya nintiṉu yalatji tjananya Katutjaku wangka tjakultjunkunytjaku, Yitjurilaku walytja ngaṉṯitja tjuṯakutu, “Tjuṯangkuya wangka kulila!, tjiḻpi tjuṯangkuṯarra. Wangka ngaatjanya tjananya katjapiṯingka yuṉṯalpiṯingka nintila! Palunya tjuṯangkuya kulira tiṉarrirra tjanampaṉu katjapiṯingka yuṉṯalpiṯingka nintintjaku. Kutuya kulila! Kutjupa tjuṯangku nyurrangarrimpa ngurrangka ngalya yankula pikangku pungkula kilytjuntanku. Palunyatjanu kutjupa tjuṯangku nyurrangarrinya ngalya yankula piyuku pikangku pungkula ngurra tjuṯa kilytjuntanku. Yalatji nyurranya tjuṯa kutjupangku tjuṯa kutjupangkuya ngalya yankula pikangku pungkula ngurra tjuṯa kilytjuntankula wiyalku. “Ngula ngayuluṉa Katutjalu nyurrangarrimpa walytja ngaṉṯitja tjuṯangka tjananya ngayuku kurrunpa wantirriyara tjarrpatjunku. Palunyatjanuya ngayuku wangka tjakultjurinamalpa nyurrangarrimpa walytja ngaṉṯitja tjuṯangku.” ");
INSERT INTO piu2006_vpl VALUES ("AM1_1","031_1_1","AMO","1","1","1","Yitjurilaku walytja ngaṉṯitja tjuṯaya tawunu Tjamiriyala nyinangi. Ngurra palula yila tawunu tjuṯangkaya nyinangi. Katutjalu tjananya palumpa wangka watjalpayi tjuṯa iyalpayi. Paluru tjana marrkulpayi Katutjaku tjukarurrulpiya nyinanytjaku. Paluru tjanaya langangkatjunkupayi Katutjalu tjananya yitjipungkutjipingkamarra. Palunyatjanu Katutjalu tjananya kutjupa ngurrara tjuṯa wantirriyalpayi, pungkunytjaku. Kutjupa ngurrara warrmaḻa tjuṯa Katutjalu wantirriyalpayi, Yitjurilaku walytja ngaṉṯitja tjuṯanya pungkula tjukarurruntjakitjangku. ");
INSERT INTO piu2006_vpl VALUES ("AM1_2","031_1_2","AMO","1","2","15","(1:; 5:; 6:; 9:) Mayutju yini Tjiripumanya tjanampa Tjiyuwatjaku katja nyinangi, Yitjurilaku walytja ngaṉṯitja tjuṯaku. Mayutju tiṉa paluru nyinanyingka wati Yimutjanya nyinangi. Palunyatjanu Katutjalu Yimutjanya nintira watjaṉu, yankula tjananya yaṉangu tjuṯangka yalatji tjakultjunkunytjaku, “Maralpa tjuṯangka tjananya nyurrangarri yalatji kuya palyalpayi. Mayi wiita tjanampanyurra yatjikingku ngunytjilyira mantjilpayi aḻṯuruwiyangku. Ngurrangka nyinakitjangkunyurra waaḻa tjuṯa palyaṉi. Waaḻa palunya tjuṯangka wiyanyurra nyinaku. Kaana tjuṯanyurra kiripitji tjawara pakaltjingalpayi. Kaana palunya tjuṯangka wiyanyurra kiripitji yantara yintira tjikilku. Kutunyurra kuya palyara nyinapayi. Ngayuku tuḻkukunyurra tjungurringkula nyinapayi, ngayuku walytja palya nguwanpa. Tjawirrilyitju nyurrangarri katirra pungkupayi tjukarurru nyinanytjawiyangku. Tjawirrilyi palunya tjuṯaku ngayulu yunytjuwiya nyinanyi. Ngayunya puḻkapungkukitjangku yinkanytjawiyangku wanti!, yunytjuwiyaṉa nyurrampa Katutjanya nyinanyi. Nyurrangarrimpa ngayunya nguwanpa ngaranyi yini Mulakanya palumpaṉu tjaatji wiimangka. Tjaatji wiima palumpaṉunyurra katiyankula puḻkapungkupayi, ngayunya Katutjanya tjukarurrungku puḻkapungkunytjawiyangku. Palunyatjanu kutjupa tjuṯangku nyurranya ngalya yankula pikangku pungkula ngurra kutjupakutu katiku ngurra walytja wiyakutulpi, yalinytjarra. Ngurra palulanyurra tawunu Tamatjakatjangka munkarra waarrkana tjuṯalpinyurra nyinaku. “Ngurra walytjangka kunpunyurra puntura ngalkula tjikira nyinapayi. Ngurra palya tjuṯangkanyurra ngarripayi. Yalatji ngurra palyangka nyinarra kulintjawiyanyurra nyinanyi, kutjupa tjuṯangku nyurranya ngalya yankula pikangku pungkula wiyalku. Tjanaya ngalya yankula nyurranya pikangku punganyingka yunypawiyalpinyurra Yitjurilaku walytja ngaṉṯitja tjuṯa nyinaku. Yilta, paluru tjana nyurrangarrinya katiku ngurra waṉma waarrkana tjuṯa nyinanytjaku. “Ngula ngayulu Katutjalu Tapitaku walytja ngaṉṯitja kutju, mayutju tiṉa nyinatjunku. Ngayuku walytja tjuṯa tjananya ngayulu ngurra ngaakutu maḻaku ngalya katirra nyinatjunku. Palunyatjanuya waaḻa yuḻpuṉutja tjuṯa piyuku palyara ngaratjunku. Kaana tjuṯaṯarra tjana piyuku tjawara wanara pakaltjingalku. Pakaltjingaraya palya ngalkula tjikilku.” ");
INSERT INTO piu2006_vpl VALUES ("AM5_1","031_5_1","AMO","5","1","27","(1:; 5:; 6:; 9:) Mayutju yini Tjiripumanya tjanampa Tjiyuwatjaku katja nyinangi, Yitjurilaku walytja ngaṉṯitja tjuṯaku. Mayutju tiṉa paluru nyinanyingka wati Yimutjanya nyinangi. Palunyatjanu Katutjalu Yimutjanya nintira watjaṉu, yankula tjananya yaṉangu tjuṯangka yalatji tjakultjunkunytjaku, “Maralpa tjuṯangka tjananya nyurrangarri yalatji kuya palyalpayi. Mayi wiita tjanampanyurra yatjikingku ngunytjilyira mantjilpayi aḻṯuruwiyangku. Ngurrangka nyinakitjangkunyurra waaḻa tjuṯa palyaṉi. Waaḻa palunya tjuṯangka wiyanyurra nyinaku. Kaana tjuṯanyurra kiripitji tjawara pakaltjingalpayi. Kaana palunya tjuṯangka wiyanyurra kiripitji yantara yintira tjikilku. Kutunyurra kuya palyara nyinapayi. Ngayuku tuḻkukunyurra tjungurringkula nyinapayi, ngayuku walytja palya nguwanpa. Tjawirrilyitju nyurrangarri katirra pungkupayi tjukarurru nyinanytjawiyangku. Tjawirrilyi palunya tjuṯaku ngayulu yunytjuwiya nyinanyi. Ngayunya puḻkapungkukitjangku yinkanytjawiyangku wanti!, yunytjuwiyaṉa nyurrampa Katutjanya nyinanyi. Nyurrangarrimpa ngayunya nguwanpa ngaranyi yini Mulakanya palumpaṉu tjaatji wiimangka. Tjaatji wiima palumpaṉunyurra katiyankula puḻkapungkupayi, ngayunya Katutjanya tjukarurrungku puḻkapungkunytjawiyangku. Palunyatjanu kutjupa tjuṯangku nyurranya ngalya yankula pikangku pungkula ngurra kutjupakutu katiku ngurra walytja wiyakutulpi, yalinytjarra. Ngurra palulanyurra tawunu Tamatjakatjangka munkarra waarrkana tjuṯalpinyurra nyinaku. “Ngurra walytjangka kunpunyurra puntura ngalkula tjikira nyinapayi. Ngurra palya tjuṯangkanyurra ngarripayi. Yalatji ngurra palyangka nyinarra kulintjawiyanyurra nyinanyi, kutjupa tjuṯangku nyurranya ngalya yankula pikangku pungkula wiyalku. Tjanaya ngalya yankula nyurranya pikangku punganyingka yunypawiyalpinyurra Yitjurilaku walytja ngaṉṯitja tjuṯa nyinaku. Yilta, paluru tjana nyurrangarrinya katiku ngurra waṉma waarrkana tjuṯa nyinanytjaku. “Ngula ngayulu Katutjalu Tapitaku walytja ngaṉṯitja kutju, mayutju tiṉa nyinatjunku. Ngayuku walytja tjuṯa tjananya ngayulu ngurra ngaakutu maḻaku ngalya katirra nyinatjunku. Palunyatjanuya waaḻa yuḻpuṉutja tjuṯa piyuku palyara ngaratjunku. Kaana tjuṯaṯarra tjana piyuku tjawara wanara pakaltjingalku. Pakaltjingaraya palya ngalkula tjikilku.” ");
INSERT INTO piu2006_vpl VALUES ("AM6_1","031_6_1","AMO","6","1","14","(1:; 5:; 6:; 9:) Mayutju yini Tjiripumanya tjanampa Tjiyuwatjaku katja nyinangi, Yitjurilaku walytja ngaṉṯitja tjuṯaku. Mayutju tiṉa paluru nyinanyingka wati Yimutjanya nyinangi. Palunyatjanu Katutjalu Yimutjanya nintira watjaṉu, yankula tjananya yaṉangu tjuṯangka yalatji tjakultjunkunytjaku, “Maralpa tjuṯangka tjananya nyurrangarri yalatji kuya palyalpayi. Mayi wiita tjanampanyurra yatjikingku ngunytjilyira mantjilpayi aḻṯuruwiyangku. Ngurrangka nyinakitjangkunyurra waaḻa tjuṯa palyaṉi. Waaḻa palunya tjuṯangka wiyanyurra nyinaku. Kaana tjuṯanyurra kiripitji tjawara pakaltjingalpayi. Kaana palunya tjuṯangka wiyanyurra kiripitji yantara yintira tjikilku. Kutunyurra kuya palyara nyinapayi. Ngayuku tuḻkukunyurra tjungurringkula nyinapayi, ngayuku walytja palya nguwanpa. Tjawirrilyitju nyurrangarri katirra pungkupayi tjukarurru nyinanytjawiyangku. Tjawirrilyi palunya tjuṯaku ngayulu yunytjuwiya nyinanyi. Ngayunya puḻkapungkukitjangku yinkanytjawiyangku wanti!, yunytjuwiyaṉa nyurrampa Katutjanya nyinanyi. Nyurrangarrimpa ngayunya nguwanpa ngaranyi yini Mulakanya palumpaṉu tjaatji wiimangka. Tjaatji wiima palumpaṉunyurra katiyankula puḻkapungkupayi, ngayunya Katutjanya tjukarurrungku puḻkapungkunytjawiyangku. Palunyatjanu kutjupa tjuṯangku nyurranya ngalya yankula pikangku pungkula ngurra kutjupakutu katiku ngurra walytja wiyakutulpi, yalinytjarra. Ngurra palulanyurra tawunu Tamatjakatjangka munkarra waarrkana tjuṯalpinyurra nyinaku. “Ngurra walytjangka kunpunyurra puntura ngalkula tjikira nyinapayi. Ngurra palya tjuṯangkanyurra ngarripayi. Yalatji ngurra palyangka nyinarra kulintjawiyanyurra nyinanyi, kutjupa tjuṯangku nyurranya ngalya yankula pikangku pungkula wiyalku. Tjanaya ngalya yankula nyurranya pikangku punganyingka yunypawiyalpinyurra Yitjurilaku walytja ngaṉṯitja tjuṯa nyinaku. Yilta, paluru tjana nyurrangarrinya katiku ngurra waṉma waarrkana tjuṯa nyinanytjaku. “Ngula ngayulu Katutjalu Tapitaku walytja ngaṉṯitja kutju, mayutju tiṉa nyinatjunku. Ngayuku walytja tjuṯa tjananya ngayulu ngurra ngaakutu maḻaku ngalya katirra nyinatjunku. Palunyatjanuya waaḻa yuḻpuṉutja tjuṯa piyuku palyara ngaratjunku. Kaana tjuṯaṯarra tjana piyuku tjawara wanara pakaltjingalku. Pakaltjingaraya palya ngalkula tjikilku.” ");
INSERT INTO piu2006_vpl VALUES ("AM9_1","031_9_1","AMO","9","1","15","(1:; 5:; 6:; 9:) Mayutju yini Tjiripumanya tjanampa Tjiyuwatjaku katja nyinangi, Yitjurilaku walytja ngaṉṯitja tjuṯaku. Mayutju tiṉa paluru nyinanyingka wati Yimutjanya nyinangi. Palunyatjanu Katutjalu Yimutjanya nintira watjaṉu, yankula tjananya yaṉangu tjuṯangka yalatji tjakultjunkunytjaku, “Maralpa tjuṯangka tjananya nyurrangarri yalatji kuya palyalpayi. Mayi wiita tjanampanyurra yatjikingku ngunytjilyira mantjilpayi aḻṯuruwiyangku. Ngurrangka nyinakitjangkunyurra waaḻa tjuṯa palyaṉi. Waaḻa palunya tjuṯangka wiyanyurra nyinaku. Kaana tjuṯanyurra kiripitji tjawara pakaltjingalpayi. Kaana palunya tjuṯangka wiyanyurra kiripitji yantara yintira tjikilku. Kutunyurra kuya palyara nyinapayi. Ngayuku tuḻkukunyurra tjungurringkula nyinapayi, ngayuku walytja palya nguwanpa. Tjawirrilyitju nyurrangarri katirra pungkupayi tjukarurru nyinanytjawiyangku. Tjawirrilyi palunya tjuṯaku ngayulu yunytjuwiya nyinanyi. Ngayunya puḻkapungkukitjangku yinkanytjawiyangku wanti!, yunytjuwiyaṉa nyurrampa Katutjanya nyinanyi. Nyurrangarrimpa ngayunya nguwanpa ngaranyi yini Mulakanya palumpaṉu tjaatji wiimangka. Tjaatji wiima palumpaṉunyurra katiyankula puḻkapungkupayi, ngayunya Katutjanya tjukarurrungku puḻkapungkunytjawiyangku. Palunyatjanu kutjupa tjuṯangku nyurranya ngalya yankula pikangku pungkula ngurra kutjupakutu katiku ngurra walytja wiyakutulpi, yalinytjarra. Ngurra palulanyurra tawunu Tamatjakatjangka munkarra waarrkana tjuṯalpinyurra nyinaku. “Ngurra walytjangka kunpunyurra puntura ngalkula tjikira nyinapayi. Ngurra palya tjuṯangkanyurra ngarripayi. Yalatji ngurra palyangka nyinarra kulintjawiyanyurra nyinanyi, kutjupa tjuṯangku nyurranya ngalya yankula pikangku pungkula wiyalku. Tjanaya ngalya yankula nyurranya pikangku punganyingka yunypawiyalpinyurra Yitjurilaku walytja ngaṉṯitja tjuṯa nyinaku. Yilta, paluru tjana nyurrangarrinya katiku ngurra waṉma waarrkana tjuṯa nyinanytjaku. “Ngula ngayulu Katutjalu Tapitaku walytja ngaṉṯitja kutju, mayutju tiṉa nyinatjunku. Ngayuku walytja tjuṯa tjananya ngayulu ngurra ngaakutu maḻaku ngalya katirra nyinatjunku. Palunyatjanuya waaḻa yuḻpuṉutja tjuṯa piyuku palyara ngaratjunku. Kaana tjuṯaṯarra tjana piyuku tjawara wanara pakaltjingalku. Pakaltjingaraya palya ngalkula tjikilku.” ");
INSERT INTO piu2006_vpl VALUES ("JH1_1","033_1_1","JON","1","1","16","Wati Yamitayiku katja Tjuunanya nyinangi, Katutjaku wangka watjalpayi. Mayutju Katutjalu Tjuunangka alatji watjaṉu, “Yalinytjarra yarra!, tawunu Ninapalakutu. Tawunu tiṉa palulakutu ankula tjananya marrkula!, kuyaya palyayinanyingka, ngayuku wangka kulira tjukarurrulpiya tjana nyinanytjaku. Kuliṉiṉa tjananya kuyaya palyara nyinanyingka.” Tjuunalu wangka palunya kulira wantirra kumpiralpi yanu wilurarralpi, tawunu Ninapalakutu ankula nintilpayingkamarra. Wilurarra ankula tawunu Tjuupangka tjarrpangu yuru tiṉangka ila. Paṉa Piinalakutu yankukitjangku maningka payimilara puutangka kaḻpangu. Ngurra Ninapalakutu yankuwiyangku paluru kuliṉu wilurarra waṉma ankula nyinakitjangku. Puutangkaya tjungu puuta ngurrara tjuṯa ankula ngururrpa ananyingka, Katutjalu waḻpa tiṉa wantirriyaṉu. Waḻpa tiṉangkulpi wangkarra yuru tiṉangku puuta pungkula kilytjuntankula nguwanpa tjarrpatjunu. Palunyatjanu puutangka waarrkarripayi tjuṯaya nguḻu nguḻurringu. Katutjanya nguwanpa kutjupa tjuṯangka tjanayanku tjapiṉingi kanarrikitjangku, yurungka tjarrparra ilutjipingkamarra. Puutangka yunngu tjarrparra puutaku mayutjulu nyangu Tjuunanya kunkunpa ngarrinyingka. Kanara paluru watjaṉu, “Kunkunpa ngarrinytjawiya pakala! Nyuntupa mayutju tiṉa, ilkari ngurrarangka tjapila!, aḻṯururringkulalanya kanantjaku, yurungkala tjarrparra mirrirripayingka.” Waḻpa tiṉa paluru kutu wangkangi. Puutaku waarrkana tjuṯangku alatji kuliṉu, “Wati kutjungku kuya palyantjala palumpa mayutjungku Katutjalu kuyarringkula waḻpa tiṉa wantirriyaṉu. Mani tjiilpaya waṉipayi yinkanytjakitjangku alatji nguwanpaya kulintjakitjangku wati kuyatjarra kaḻpangutjangka puutangka.” Yalatjiya yinkarra wati Tjuunanya kuliṉu. Tjuunalu tjananya tjakultjunu Katutjaku wangka kulira wantingutjanungku. Tjanaya Tjuunanya tjapiṉu, “Yaalytjinkumpala waḻpakamu yuru yataṉarrinytjaku?” Tjuunalu tjananya watjaṉu, “Yurukutuṉiya waṉi! Yiltaṉa Katutjangka kuya palyaṉutjangka waḻpa tiṉa wangkanyi. Ngayunyakunyuṉiya waṉirriyala! Palunyatjanulpi waḻpa yataṉarrikulpi.” Waḻpa yuru tiṉa puntu kulira Tjuunanyalpiya kapikutu waṉingu. Palunyatjanu waḻpa palunya yuru yataṉarringu. Katutjakulpiya puuta ngurrara tjuṯangkulpi kuka tjawirrilyi kutjaṉu. ");
INSERT INTO piu2006_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","(1:17; 2:1-10) Tjuunanya yurukutu waṉingutjangka piitji tiṉangku kuuḻtjura kanyiṉingi, mayutju Katutjalu iyaṉutjangka. Palunyatjanu wiḻangka yunngulpi Tjuunanya ngarringi. Wiḻangka ngarrirra Tjuunalu Katutjanya yalatji tjapiṉu, “Mayutju Katutja. Tjapiṉiṉanta kanantjakuṉin. Yurungka yunnguwanangkuṉanta mirrirrikitjangku tjapiṉi. Yaṉangu kutjupa tjuṯangkuya Katutjanya nguwanpa tjuṯanya waḻkuṉi, kanya ngayulu nyuntunya kutju waḻkunmalpa. Mayutju Katutja. Nyuntu kutju yaṉangu kanalpayi, ngayunyalpi kanala!” Palunyatjanu piitji tiṉa paluru paṉakutu ankula yulkapatjunkula waṯutjunu wati Tjuunanya. Paṉangkalpi waṯungarangi. Palunyatjanu Katutjalu Tjuunanya iyaṉulpi Ninapalakutu. ");
INSERT INTO piu2006_vpl VALUES ("JH2_1","033_2_1","JON","2","1","10","(1:17; 2:1-10) Tjuunanya yurukutu waṉingutjangka piitji tiṉangku kuuḻtjura kanyiṉingi, mayutju Katutjalu iyaṉutjangka. Palunyatjanu wiḻangka yunngulpi Tjuunanya ngarringi. Wiḻangka ngarrirra Tjuunalu Katutjanya yalatji tjapiṉu, “Mayutju Katutja. Tjapiṉiṉanta kanantjakuṉin. Yurungka yunnguwanangkuṉanta mirrirrikitjangku tjapiṉi. Yaṉangu kutjupa tjuṯangkuya Katutjanya nguwanpa tjuṯanya waḻkuṉi, kanya ngayulu nyuntunya kutju waḻkunmalpa. Mayutju Katutja. Nyuntu kutju yaṉangu kanalpayi, ngayunyalpi kanala!” Palunyatjanu piitji tiṉa paluru paṉakutu ankula yulkapatjunkula waṯutjunu wati Tjuunanya. Paṉangkalpi waṯungarangi. Palunyatjanu Katutjalu Tjuunanya iyaṉulpi Ninapalakutu. ");
INSERT INTO piu2006_vpl VALUES ("JH3_1","033_3_1","JON","3","1","10","Palunyatjanu mayutju Katutjalu Tjuunala alatji watjaṉu, “Tawunu tiṉa palulakutu Ninapalakutu maa yankula tjananya wangka ngayuku tjakultjurra!, panyapaṉanta watjaṉu.” Palunyatjanu Tjuunanya yanu tawunu Ninapalakutu. Waaḻawana ankula Tjuunalu tjananya tjakultjurinangi alatji, “Kuyanyurra kutu palyaṉingka purayitiyi tjikitjipala nguwanpa ngarala Katutjalu nyurranya mirrintara wiyalku, ngurraṯarra nyurrangarrimpa kilytjuntankula wiyalku.” Tjuunaku wangkaya yilta kuliṉu, Katutjakulpiya tjukarurru nyinakitjangku. Tjuṯangkuya mayi, kuka ngalkuwiyangku mantarra kuyakuyangka tjarrparra kuya palyantjanguru watjilpa nyinangi. Kuya wantirralpiya nyinangi, Katutjakuraya tjukarurru nyinakitja. Ninapaku mayutju tiṉaṯarra kuya wantirra mantarra kuyakuyangka tjarrparra watjilpa nyinangi. Paluru tjananya palumpa waarrkana tjuṯa watjaṉu tawunuwana parra yankula yaṉangu tjuṯa tjingapungkunytjaku alatji, “Mayutju tiṉangku nyurranya watjaṉu kuya palyalwiyanyurra nyinanytjaku. Kuka an miyi ngalkuwiyangku nyurrangarri wantirra Katutjanya tjapintjaku. Yalatjila tjapintjala, tjinguru Katutjalulanya mirri pungkuwiyangku wantiku. Tjinguru kalypalpilampa nyinaku.” Ninapanya ngurrara tjuṯaya tjukarurrulpi nyinayananyingka Katutjalu tjanampa yaḻṯururringkula wantingu mirri pungkuwiyangku. ");
INSERT INTO piu2006_vpl VALUES ("JH4_1","033_4_1","JON","4","1","11","Katutjalu tjananya mirri pungkuwiyangku wantingutjangka, Tjuunanya Katutjaku ngurrkurrirra yalatjingku watjaṉu, “Mayutju Katutja. Nyuntu tjananya yitjipungkunytjaku. Panyapaṉanta watjaṉu ngurrangkaṉa nyinakitjangku. Nyuntu yaḻṯururrirra wantipayi, mirri pungkuwiyangku. Kuya palyalpayi tjuṯaku nyuntu rawa paṯara ngula kutju yitjipungkupayi. Mirri pungkukitjangku kulira nyuntu aḻṯururringkula wantipayi. Ninapanya ngurrara tjuṯa tjananya nyuntu wantinyingka waṯalpiṉa mirrirriku. Ngurrkurrirraṉangku mirrirrikitja yunytjurringanyi.” Mayutju Katutjalu Tjuunanya yalatji watjaṉu, “Nyaaku nyuntu ngurrku nyinanyi?, ngurrkuwiyan nyinanytjaku.” Palunyatjanu Tjuunanya tawunu Ninapangka kakarrara ankula puri piḻṯi wilytjara nyinangi, puri pulkuṉpawiyangka. Palula nyinarra nyangangi, Katutjalu tjananya mirri pungkula wiyantjaku, ngurra tjuṯaṯarra kilytjuntankula wiyantjaku. Palunyangka Katutjalu yukiri pulkuṉtjarra pakaltjingaṉu. Tjiṉṯu kutjungka parrpaṯu pakara pulkuṉarringu, Tjuunanya wilytjatjunu. Wilytja palumpa yunypa nyinangi. Mungawinki Katutjalu yutunypa tjuṯa wantirriyaṉu, wilytja pulkuṉpa palunya ngalkula wiyantjaku. Palunyangka mungawinki punkara wiyarringu. Tjiṉṯu katurringutjangka Katutjalu waḻpa waru nguwanpa kakarraranguru wantirriyaṉu. Puri piḻṯingka nyinarra Tjuunanya kata rarrirarrirringu. Tjiṉṯungka nyinarra rarrirarrirrirra Katutjanya yalatji tjapiṉu, “Yiluntarraṉi!” Katutjalu Tjuunanya tjapiṉu yarrkalkitjangku, “Nyaakun yukiri pulkuṉpa palunya wiyarringutjangka nyuntu ngayuku ngurrku nyinanyi?” Tjuunalu watjaṉu, “Palyaṉa ngurrku nyinanyi. Ngurrkuṉanta nyinanyingka, palyaṉin yiluntarra!” Mayutju Katutjalu watjaṉu, “Yukiri palatja parrpaṯu walytja pakaṉu, nyuntu kurrpira pakaltjingantjawiya. Tjiṉṯu kutju ngarala wiyarringanyingka nyuntu yukiri palaku aḻṯururringu. Nyuntu yukiriku aḻṯururrinytja nguwanpa ngayuluṉa tjanampa Ninapanya ngurrara tjuṯaku aḻṯururringanyi. Palyaṉa tjanampa yaḻṯururringanyi, yaṉangu tjuṯa palaku, pipirri pala tjuṯaku, kuka pala tjuṯakuṯarra.” ");
INSERT INTO piu2006_vpl VALUES ("MC1_1","034_1_1","MIC","1","1","16","(1:; 2:; 3:) Tjuutaku walytja ngaṉṯitja tjuṯaku mayutju tjuṯa yalatjiya nyinangi, Tjuutjamanya, Yiiyatjanya, Yitjikayanya. Mayutju paluru tjana nyinanytjala, Makayalu tjananya Katutjanya wangkarra marrkulpayi. Yalatji tjananya yaṉangu tjuṯa Makayalu langangkatjunu, “Kutjupa tjuṯangkunyurra kuya palyalkitjangku mungangka kanangku ngarrirra kulilpayi. Kuliranyurra pakara yalatji kuya palyalpayi. Maralpa tjuṯaku waaḻa paṉaṯarra nguntilyira mulyaṯangku mantjilpayi. Nyurrangarri pikangku pungkula tjananya waaḻa, paṉa yulytja uwankarra tjanampa mulyaṯangku mantjilpayi. Nyurrangarri mayutju tjuṯangku tjanampa maralpa tjuṯaku tjukarurrungku palyalwiyangku wantipayi. Mani yungkunytjala kutju tjanampa nyurrangarri palyalpayi, manitjirratjangku. Tjukarurrungku tjanampa nyurrangarri palyanmara maniku kulilwiyangku. Kutjupa tjuṯangkunyurra Katutjaku wangka watjalpayi nguwanpangku manikitjangku nintilpayi. Tjukarurrungku maniku kulilwiyangkunyurra nintilmara. “Tuḻkuku mayutju tjuṯangkuṯarra manikitjangku nintilpayi. Yalatji wiyawanangku nyurrangarri kulilpayi, ‘Palyala irriṯi nyinangutja nguwanpa kuya nyinaku, mayutju Katutjanya walytjalampa nyinanyi, wiyalanya panitjimilalku.’ Yalatji wiyawanangkunyurra kuliṉi. Yilta Katutjalu nyurranya kuya palyalpayi tjuṯa panitjimilalku.” Makayalu tjananya Katutjaku wangka piyuku yalatji watjaṉu, “Ngayulu nyurranya Katutjalu yilta panitjimilalku. Nyurrangarrimpa ngurra Tjarutjalumanya kutjupa tjuṯangku ngalyankula yuḻpura wiyalku. Yuḻpurringkula ngarrirra waṉimalpa.” ");
INSERT INTO piu2006_vpl VALUES ("MC2_1","034_2_1","MIC","2","1","13","(1:; 2:; 3:) Tjuutaku walytja ngaṉṯitja tjuṯaku mayutju tjuṯa yalatjiya nyinangi, Tjuutjamanya, Yiiyatjanya, Yitjikayanya. Mayutju paluru tjana nyinanytjala, Makayalu tjananya Katutjanya wangkarra marrkulpayi. Yalatji tjananya yaṉangu tjuṯa Makayalu langangkatjunu, “Kutjupa tjuṯangkunyurra kuya palyalkitjangku mungangka kanangku ngarrirra kulilpayi. Kuliranyurra pakara yalatji kuya palyalpayi. Maralpa tjuṯaku waaḻa paṉaṯarra nguntilyira mulyaṯangku mantjilpayi. Nyurrangarri pikangku pungkula tjananya waaḻa, paṉa yulytja uwankarra tjanampa mulyaṯangku mantjilpayi. Nyurrangarri mayutju tjuṯangku tjanampa maralpa tjuṯaku tjukarurrungku palyalwiyangku wantipayi. Mani yungkunytjala kutju tjanampa nyurrangarri palyalpayi, manitjirratjangku. Tjukarurrungku tjanampa nyurrangarri palyanmara maniku kulilwiyangku. Kutjupa tjuṯangkunyurra Katutjaku wangka watjalpayi nguwanpangku manikitjangku nintilpayi. Tjukarurrungku maniku kulilwiyangkunyurra nintilmara. “Tuḻkuku mayutju tjuṯangkuṯarra manikitjangku nintilpayi. Yalatji wiyawanangku nyurrangarri kulilpayi, ‘Palyala irriṯi nyinangutja nguwanpa kuya nyinaku, mayutju Katutjanya walytjalampa nyinanyi, wiyalanya panitjimilalku.’ Yalatji wiyawanangkunyurra kuliṉi. Yilta Katutjalu nyurranya kuya palyalpayi tjuṯa panitjimilalku.” Makayalu tjananya Katutjaku wangka piyuku yalatji watjaṉu, “Ngayulu nyurranya Katutjalu yilta panitjimilalku. Nyurrangarrimpa ngurra Tjarutjalumanya kutjupa tjuṯangku ngalyankula yuḻpura wiyalku. Yuḻpurringkula ngarrirra waṉimalpa.” ");
INSERT INTO piu2006_vpl VALUES ("MC3_1","034_3_1","MIC","3","1","12","(1:; 2:; 3:) Tjuutaku walytja ngaṉṯitja tjuṯaku mayutju tjuṯa yalatjiya nyinangi, Tjuutjamanya, Yiiyatjanya, Yitjikayanya. Mayutju paluru tjana nyinanytjala, Makayalu tjananya Katutjanya wangkarra marrkulpayi. Yalatji tjananya yaṉangu tjuṯa Makayalu langangkatjunu, “Kutjupa tjuṯangkunyurra kuya palyalkitjangku mungangka kanangku ngarrirra kulilpayi. Kuliranyurra pakara yalatji kuya palyalpayi. Maralpa tjuṯaku waaḻa paṉaṯarra nguntilyira mulyaṯangku mantjilpayi. Nyurrangarri pikangku pungkula tjananya waaḻa, paṉa yulytja uwankarra tjanampa mulyaṯangku mantjilpayi. Nyurrangarri mayutju tjuṯangku tjanampa maralpa tjuṯaku tjukarurrungku palyalwiyangku wantipayi. Mani yungkunytjala kutju tjanampa nyurrangarri palyalpayi, manitjirratjangku. Tjukarurrungku tjanampa nyurrangarri palyanmara maniku kulilwiyangku. Kutjupa tjuṯangkunyurra Katutjaku wangka watjalpayi nguwanpangku manikitjangku nintilpayi. Tjukarurrungku maniku kulilwiyangkunyurra nintilmara. “Tuḻkuku mayutju tjuṯangkuṯarra manikitjangku nintilpayi. Yalatji wiyawanangku nyurrangarri kulilpayi, ‘Palyala irriṯi nyinangutja nguwanpa kuya nyinaku, mayutju Katutjanya walytjalampa nyinanyi, wiyalanya panitjimilalku.’ Yalatji wiyawanangkunyurra kuliṉi. Yilta Katutjalu nyurranya kuya palyalpayi tjuṯa panitjimilalku.” Makayalu tjananya Katutjaku wangka piyuku yalatji watjaṉu, “Ngayulu nyurranya Katutjalu yilta panitjimilalku. Nyurrangarrimpa ngurra Tjarutjalumanya kutjupa tjuṯangku ngalyankula yuḻpura wiyalku. Yuḻpurringkula ngarrirra waṉimalpa.” ");
INSERT INTO piu2006_vpl VALUES ("MC4_1","034_4_1","MIC","4","1","13","(4:; 5:) Puḻi palula tjaatji tiṉanya ngaranyi. Puḻi palunya ngula tiṉarringkula katulingku ngaraku, puḻi kutjupa tjuṯa ngaranytjala munkarra. Puḻi palulakutu ngayuku tjaatji tiṉakutuya yaṉangu tjuṯa paṉa kutjupa kutjupa ngurrara yankula tjungurriku. Palulakutu yankukitjangkuya alatji watjalku, “Yarralaka Katutjaku tjaatji tiṉakutu!, Yitjurilaku ngaṉṯitja tjuṯaku mayutju tiṉakutu. Katutja palurulanya nintilku tjukarurru nyinanytjaku. Kulirala tjukarurru nyinaku. Ngurra palula kutju Tjarutjalumala Katutjalulanya palumpa walytja tjuṯa nintilpayi.” Kurayitjanya yutirrinytjaku Makayalu yirriṯi watjaṉu. Kurayitjanya yilta yutirrinytjala yurrunpa alatji watjaṉu, “Tawunu Pitjiliyamanya wiima ngaranyi Tjuutaku walytja ngaṉṯitja tjuṯaku ngurrangka. Ngurra palula tawunu tiṉa tjuṯa ngarala waṉinyi. Tawunu wiima palula Kurayitjanya yutirriku. Yitjurilaku walytja ngaṉṯitja tjuṯaku paluru mayutju tiṉalpi tjanampa nyinaku. Yitjurilaku walytja ngaṉṯitja tjuṯaku Kurayitja paluru tawunu palula yutirriku.” ");
INSERT INTO piu2006_vpl VALUES ("MC5_1","034_5_1","MIC","5","1","15","(4:; 5:) Puḻi palula tjaatji tiṉanya ngaranyi. Puḻi palunya ngula tiṉarringkula katulingku ngaraku, puḻi kutjupa tjuṯa ngaranytjala munkarra. Puḻi palulakutu ngayuku tjaatji tiṉakutuya yaṉangu tjuṯa paṉa kutjupa kutjupa ngurrara yankula tjungurriku. Palulakutu yankukitjangkuya alatji watjalku, “Yarralaka Katutjaku tjaatji tiṉakutu!, Yitjurilaku ngaṉṯitja tjuṯaku mayutju tiṉakutu. Katutja palurulanya nintilku tjukarurru nyinanytjaku. Kulirala tjukarurru nyinaku. Ngurra palula kutju Tjarutjalumala Katutjalulanya palumpa walytja tjuṯa nintilpayi.” Kurayitjanya yutirrinytjaku Makayalu yirriṯi watjaṉu. Kurayitjanya yilta yutirrinytjala yurrunpa alatji watjaṉu, “Tawunu Pitjiliyamanya wiima ngaranyi Tjuutaku walytja ngaṉṯitja tjuṯaku ngurrangka. Ngurra palula tawunu tiṉa tjuṯa ngarala waṉinyi. Tawunu wiima palula Kurayitjanya yutirriku. Yitjurilaku walytja ngaṉṯitja tjuṯaku paluru mayutju tiṉalpi tjanampa nyinaku. Yitjurilaku walytja ngaṉṯitja tjuṯaku Kurayitja paluru tawunu palula yutirriku.” ");
INSERT INTO piu2006_vpl VALUES ("HK1_1","036_1_1","HAB","1","1","17","(1:; 2:) Katutjaku wangka watjalpayingku wati Yapakakalu tjananya Tjuutaku walytja ngaṉṯitja tjuṯangka yalatji watjaṉu, “Ngayuluṉa Katutjalu Papilunanya ngurrara tjuṯa nyinatjunku mayutju tjuṯa nyurrampa nyinanytjaku. Yaṉangu kutjupa tjuṯakuṯarra paluru tjana mayutju tjuṯa nyinaku, paṉa tjuṯawana nyinanytja tjuṯaku. Papilunanya ngurrara tjuṯangku nyurrangarrinya Tjarutjalumalakutu yankula pikangku pungku aḻṯuruwiyangku. Paṉa kutjupa kutjupa ngurrara tjuṯa tjananya pungku.” Wati Yapakakalu tjananya piyuku yalatji watjaṉu, “Papilunanya ngurrara tjuṯangkuya yankula kuya palyalpayi tjuṯa mirri pungku, kanya Katutjaku tjukarurru nyinapayi tjuṯa kana kutu nyinaku.” ");
INSERT INTO piu2006_vpl VALUES ("HK2_1","036_2_1","HAB","2","1","20","(1:; 2:) Katutjaku wangka watjalpayingku wati Yapakakalu tjananya Tjuutaku walytja ngaṉṯitja tjuṯangka yalatji watjaṉu, “Ngayuluṉa Katutjalu Papilunanya ngurrara tjuṯa nyinatjunku mayutju tjuṯa nyurrampa nyinanytjaku. Yaṉangu kutjupa tjuṯakuṯarra paluru tjana mayutju tjuṯa nyinaku, paṉa tjuṯawana nyinanytja tjuṯaku. Papilunanya ngurrara tjuṯangku nyurrangarrinya Tjarutjalumalakutu yankula pikangku pungku aḻṯuruwiyangku. Paṉa kutjupa kutjupa ngurrara tjuṯa tjananya pungku.” Wati Yapakakalu tjananya piyuku yalatji watjaṉu, “Papilunanya ngurrara tjuṯangkuya yankula kuya palyalpayi tjuṯa mirri pungku, kanya Katutjaku tjukarurru nyinapayi tjuṯa kana kutu nyinaku.” ");
INSERT INTO piu2006_vpl VALUES ("ZP1_1","037_1_1","ZEP","1","1","18","(1:1—3:20) Tjuutaku walytja ngaṉṯitja tjuṯaku mayutju tiṉa Tjutjayanya nyinanytjala, Katutjaku wangka watjalpayingku Tjipanayalu tjananya yalatji watjaṉu, “Ngayulu Katutjalu ngurra tjuṯawana yaṉangu uwankarra mirri pungkula wiyalku, kuka kutjupa kutjupa tjuṯa, kukawiya tjuṯaṯarra. Ngayulu kuya palyalpayi tjuṯa tjananya mirri pungkula wiyalku. Tjarutjalumanya ngurrara tjuṯa ngayulu tjananya tawunu kutjupa kutjupa ngurrara tjananya panitjimilalku, kuya palyalpayi tjuṯa. Kuwarriṉa nyurrangarrinyaṯarra panitjimilalku kutjupa tjuṯa ngayulu nyurrangarrinya mirri pungkula wiyalku. Waṯalpi yuḻṯa palunya yilarringulpi. Ngayulu nyurranya panitjimilantjala puṯu kuliranyurra nguḻu nyinaku. Palunyatjanu ngayukutjunyurra tjukarurrulpi nyinaku. Yuḻṯa palula ngayulu tjananya kutjupa kutjupa ngurrara tjuṯa, panitjimilalwiyangku kanyilku. Palulanguruya ngayuku wangka kulira tjukarurrulpi nyinaku. Ngayunyalpiya kutu waḻkunmalpa, Katutjanya nguwanpa tjuṯa waḻkuntjawiya.” ");
INSERT INTO piu2006_vpl VALUES ("ZP2_1","037_2_1","ZEP","2","1","15","(1:1—3:20) Tjuutaku walytja ngaṉṯitja tjuṯaku mayutju tiṉa Tjutjayanya nyinanytjala, Katutjaku wangka watjalpayingku Tjipanayalu tjananya yalatji watjaṉu, “Ngayulu Katutjalu ngurra tjuṯawana yaṉangu uwankarra mirri pungkula wiyalku, kuka kutjupa kutjupa tjuṯa, kukawiya tjuṯaṯarra. Ngayulu kuya palyalpayi tjuṯa tjananya mirri pungkula wiyalku. Tjarutjalumanya ngurrara tjuṯa ngayulu tjananya tawunu kutjupa kutjupa ngurrara tjananya panitjimilalku, kuya palyalpayi tjuṯa. Kuwarriṉa nyurrangarrinyaṯarra panitjimilalku kutjupa tjuṯa ngayulu nyurrangarrinya mirri pungkula wiyalku. Waṯalpi yuḻṯa palunya yilarringulpi. Ngayulu nyurranya panitjimilantjala puṯu kuliranyurra nguḻu nyinaku. Palunyatjanu ngayukutjunyurra tjukarurrulpi nyinaku. Yuḻṯa palula ngayulu tjananya kutjupa kutjupa ngurrara tjuṯa, panitjimilalwiyangku kanyilku. Palulanguruya ngayuku wangka kulira tjukarurrulpi nyinaku. Ngayunyalpiya kutu waḻkunmalpa, Katutjanya nguwanpa tjuṯa waḻkuntjawiya.” ");
INSERT INTO piu2006_vpl VALUES ("ZP3_1","037_3_1","ZEP","3","1","20","(1:1—3:20) Tjuutaku walytja ngaṉṯitja tjuṯaku mayutju tiṉa Tjutjayanya nyinanytjala, Katutjaku wangka watjalpayingku Tjipanayalu tjananya yalatji watjaṉu, “Ngayulu Katutjalu ngurra tjuṯawana yaṉangu uwankarra mirri pungkula wiyalku, kuka kutjupa kutjupa tjuṯa, kukawiya tjuṯaṯarra. Ngayulu kuya palyalpayi tjuṯa tjananya mirri pungkula wiyalku. Tjarutjalumanya ngurrara tjuṯa ngayulu tjananya tawunu kutjupa kutjupa ngurrara tjananya panitjimilalku, kuya palyalpayi tjuṯa. Kuwarriṉa nyurrangarrinyaṯarra panitjimilalku kutjupa tjuṯa ngayulu nyurrangarrinya mirri pungkula wiyalku. Waṯalpi yuḻṯa palunya yilarringulpi. Ngayulu nyurranya panitjimilantjala puṯu kuliranyurra nguḻu nyinaku. Palunyatjanu ngayukutjunyurra tjukarurrulpi nyinaku. Yuḻṯa palula ngayulu tjananya kutjupa kutjupa ngurrara tjuṯa, panitjimilalwiyangku kanyilku. Palulanguruya ngayuku wangka kulira tjukarurrulpi nyinaku. Ngayunyalpiya kutu waḻkunmalpa, Katutjanya nguwanpa tjuṯa waḻkuntjawiya.” ");
INSERT INTO piu2006_vpl VALUES ("ML1_1","040_1_1","MAL","1","1","14","(1:; 3:1; 4:5) Tjuwu tjuṯaya wiyawana nyinanytjala, Katutjalu wati Malakayinya nintiṉu, yankula tjananya palumpa wangka nintintjaku. Wangka tjuṯa tjananya nintiṉangi, Katutjakulpiya tjukarurru nyinanytjaku. Malakayilu tjananya Katutjaku wangka piyuku yalatji watjaṉu, “Kulilaya! Wati kutju, ngayuku wangka tjakultjunkupayi, ngayulu Katutjaluṉa nyurrangarrimpa wantirriyalku, nintintjaku nyurrangarrinya. Palunyatjanu mayutju tiṉa nyurrangarrimpa ngalya yankula nyinaku. Mayutju palumpanyurra paṯara nyinanytjaku. Paluru yankula ngayuku tjaatji tiṉangka nyinarra, paluru nyurranya nintilku ngayuku wangka. Paluru nyurrangarrinya watjalku, ‘Katutjalu yirriṯi watjaṉu nyurrangarrinya yaṉṯayaṉṯalkitjangku.’” Malakayilu tjananya Katutjaku wangka yalatji piyuku tjakultjunu, “Kulilaya! Ngayulu Katutjalu nyurrangarrinya watjaṉi. Ngayuku wangka watjalpayinya, Yilaatjanya ngayulu nyurrangarrimpa wantirriyalku yurrunpa. Palunyatjanu ngayuluṉa tjananya kuya palyalpayi tjuṯa kuutawutjungka wangkarra pikantanku. Palula yurrunpa nyurrampa Yilaatjanya yanku.” ");
INSERT INTO piu2006_vpl VALUES ("ML3_1","040_3_1","MAL","3","1","1","(1:; 3:1; 4:5) Tjuwu tjuṯaya wiyawana nyinanytjala, Katutjalu wati Malakayinya nintiṉu, yankula tjananya palumpa wangka nintintjaku. Wangka tjuṯa tjananya nintiṉangi, Katutjakulpiya tjukarurru nyinanytjaku. Malakayilu tjananya Katutjaku wangka piyuku yalatji watjaṉu, “Kulilaya! Wati kutju, ngayuku wangka tjakultjunkupayi, ngayulu Katutjaluṉa nyurrangarrimpa wantirriyalku, nintintjaku nyurrangarrinya. Palunyatjanu mayutju tiṉa nyurrangarrimpa ngalya yankula nyinaku. Mayutju palumpanyurra paṯara nyinanytjaku. Paluru yankula ngayuku tjaatji tiṉangka nyinarra, paluru nyurranya nintilku ngayuku wangka. Paluru nyurrangarrinya watjalku, ‘Katutjalu yirriṯi watjaṉu nyurrangarrinya yaṉṯayaṉṯalkitjangku.’” Malakayilu tjananya Katutjaku wangka yalatji piyuku tjakultjunu, “Kulilaya! Ngayulu Katutjalu nyurrangarrinya watjaṉi. Ngayuku wangka watjalpayinya, Yilaatjanya ngayulu nyurrangarrimpa wantirriyalku yurrunpa. Palunyatjanu ngayuluṉa tjananya kuya palyalpayi tjuṯa kuutawutjungka wangkarra pikantanku. Palula yurrunpa nyurrampa Yilaatjanya yanku.” ");
INSERT INTO piu2006_vpl VALUES ("ML4_5","040_4_5","MAL","4","5","5","(1:; 3:1; 4:5) Tjuwu tjuṯaya wiyawana nyinanytjala, Katutjalu wati Malakayinya nintiṉu, yankula tjananya palumpa wangka nintintjaku. Wangka tjuṯa tjananya nintiṉangi, Katutjakulpiya tjukarurru nyinanytjaku. Malakayilu tjananya Katutjaku wangka piyuku yalatji watjaṉu, “Kulilaya! Wati kutju, ngayuku wangka tjakultjunkupayi, ngayulu Katutjaluṉa nyurrangarrimpa wantirriyalku, nintintjaku nyurrangarrinya. Palunyatjanu mayutju tiṉa nyurrangarrimpa ngalya yankula nyinaku. Mayutju palumpanyurra paṯara nyinanytjaku. Paluru yankula ngayuku tjaatji tiṉangka nyinarra, paluru nyurranya nintilku ngayuku wangka. Paluru nyurrangarrinya watjalku, ‘Katutjalu yirriṯi watjaṉu nyurrangarrinya yaṉṯayaṉṯalkitjangku.’” Malakayilu tjananya Katutjaku wangka yalatji piyuku tjakultjunu, “Kulilaya! Ngayulu Katutjalu nyurrangarrinya watjaṉi. Ngayuku wangka watjalpayinya, Yilaatjanya ngayulu nyurrangarrimpa wantirriyalku yurrunpa. Palunyatjanu ngayuluṉa tjananya kuya palyalpayi tjuṯa kuutawutjungka wangkarra pikantanku. Palula yurrunpa nyurrampa Yilaatjanya yanku.” ");
INSERT INTO piu2006_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yini ngaa tjuṯaya Yiitju Kurayitjaku walytja tjuṯaya nyinangi. Yiitju Kurayitjanya mayutju Tapitaku walytja ngaṉṯitja nyinangi. Mayutju Tapitanya Yipuramaku walytja ngaṉṯitja nyinangi. ");
INSERT INTO piu2006_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Yipuramalu katja Yatjikanya mantjiṉu. Yatjikalu katja Tjikupanya mantjiṉu. Tjikupalu katja tjuṯa mantjiṉu. Tjuutanya palumpa katja nguruṯitja nyinangi. ");
INSERT INTO piu2006_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Tjuutalu katja kutjarra mantjiṉu. Piritjanya palumpa katja yurruntitja nyinangi, kutjupara palumpa katja nyinangi Tjiranya. Palumpa kutjarraku maama kungka Tamanya nyinangi. Piritjalu katja Yitjarunanya mantjiṉu. Yitjarunalu katja Ramanya mantjiṉu. ");
INSERT INTO piu2006_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ramalu katja Yaminitapanya mantjiṉu. Yaminitapalu katja Natjananya mantjiṉu. Natjanalu katja Tjalmananya mantjiṉu. ");
INSERT INTO piu2006_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Tjalmanalu katja Puwatjanya mantjiṉu. Puwatjaku maama Rayapanya nyinangi. Puwatjalu katja Yuupitanya mantjiṉu. Yuupitaku maama Ruutjanya nyinangi. Yuupitalu katja Tjiitjiyinya mantjiṉu. ");
INSERT INTO piu2006_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Tjiitjiyiku katja mayutju tiṉa, Tapitanya nyinangi. Tapitalu katja Tjalamunanya mantjiṉu. Tjalamunaku maama Tapitalu tjulyara kanyiṉingi, wati Yurayaku miiṯa. ");
INSERT INTO piu2006_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Tjalamunalu katja Riyupumanya mantjiṉu. Riyupumalu katja Yapayitjanya mantjiṉu. Yapayitjalu katja Yiitjanya mantjiṉu. ");
INSERT INTO piu2006_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Yiitjalu katja Tjiyutjapatanya mantjiṉu. Tjiyutjapatalu katja Tjurumanya mantjiṉu. Tjurumalu katja Yatjayanya mantjiṉu. ");
INSERT INTO piu2006_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Yatjayalu katja Tjuutjamanya mantjiṉu. Tjuutjamalu katja Yiiyatjanya mantjiṉu. Yiiyatjalu katja Yitjikayanya mantjiṉu. ");
INSERT INTO piu2006_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Yitjikayalu katja Manatjanya mantjiṉu. Manatjalu katja Yiimutjanya mantjiṉu. Yiimutjalu katja Tjutjayanya mantjiṉu. ");
INSERT INTO piu2006_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Tjutjayalu katja tjuṯalpi mantjiṉu. Palumpa katja yurruntitja Tjikunayanya nyinangi. Palulanguru Papilunanya ngurrara tjuṯangku Yitjurilaku walytja ngaṉṯitja tjuṯa tjananya ngurra Papilunalakutu katirra kanyiṉingi. ");
INSERT INTO piu2006_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Tjikunaya paluru katja Tjiltilanya mantjiṉu. Tjiltilalu katja Tjarapapulanya mantjiṉu. ");
INSERT INTO piu2006_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Tjarapapulalu katja Yapiyutanya mantjiṉu. Yapiyutalu katja Yilayakimanya mantjiṉu. Yilayakimalu katja Yiitjuranya mantjiṉu. ");
INSERT INTO piu2006_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Yiitjuralu katja Tjatakanya mantjiṉu. Tjatakalu katja Yiikimanya mantjiṉu. Yiikimalu katja Yiliyutanya mantjiṉu. ");
INSERT INTO piu2006_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Yiliyutalu katja Yalitjanya mantjiṉu. Yalitjalu katja Matanya mantjiṉu. Matalu katja Tjikupanya mantjiṉu. ");
INSERT INTO piu2006_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Tjikupalu katja Tjutjupanya mantjiṉu. Tjutjupalu miiṯa Miirinya mantjiṉu. Mirrilu katja Yiitjunya mantjiṉu. Yaṉangu tjuṯangku Yiitjunya yini kutjupa watjalpayi, Kurayitjanya, Katutjalu yirriṯi watjara wantirriyaṉutja. ");
INSERT INTO piu2006_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Yalatji Yipuramaku walytja ngaṉṯitja tuwalpala nyinarra wiyarrinytjala mayutju Tapitanyalpi nyinangi. Palulanguru mayutju Tapitaku walytja ngaṉṯitja tuwalpala nyinarra wiyarrinytjala Papilunanya ngurrara tjuṯangku tjananya Yitjurilaku walytja ngaṉṯitja tjuṯa, ngurra Papilunalakutu katirra kanyiṉingi. Paluru tjanampa mayutju Tjikunayanya ngurra palula nyinangi. Palulanguru palumpa walytja ngaṉṯitja tuwalpala nyinarra wiyarrinytjala ngaṉṯi Tjutjupalu Miirilulpipula katja Yiitjunya Kurayitjanya mantjiṉu, Katutjalu irriṯi watjara ngalya wantirriyaṉutja. ");
INSERT INTO piu2006_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yiitju Kurayitjanya yalatji mantangka yutitjarringu. Palumpa maama Miirinya wati Tjutjupaku pikatja walytja nyinangu. Ngurra kutjungka wiyapula nyinapayi, kutju iitjipula nyinapayi. Miiri paluru watiku ngurrpa nyinangu, paluru pikatja palumpa walytjaku paṯaṉingi. Palunyatjanu ngula paluru wiḻalirringu, Katutjaku kurrunpangku palunya puritjunanyingka. ");
INSERT INTO piu2006_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Tjutjupalu Miirinya wati kutjupangka ngarringutjangkakutjura kuliṉu. Paluru Miiriku palya kutura nyinangi pikarriwiya. Paluru yalatji kuliṉingi, “Kutjupa tjuṯakutuṉa wiya watjalku Miirinyatjarra. Palunya kutjuṉa watjara wantirriyalku yarrkayarrkangku, tjuṯangku kulilpayingka. Ngaatja wiya ngayuku miiṯa nyinaku.” ");
INSERT INTO piu2006_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Wangka palunya paluru yurrukulirinangi. Katutjalu ilkari ngurrara Tjutjupalakutu ngalya wantirriyaṉu, kutu yurrukulintjala. Tjutjupalu tjukurrpa nyangu ilkari ngurrara ngalya tjarukatingutja wangka watjalkitja. Paluru Tjutjupanya watjaṉu, “Tjutjupa. Nyuntu mayutju Tapitaku walytja ngaṉṯitja nyinanyi. Wangka ngaatjanya kulila! Miirinyatjarra nyuntu wiya puntura yurrukulintjaku. Palya nyuntu yankula yaḻṯirrapulan nyinanytjaku. Paluru tjunitjarralpi nyinanyi, Katutjaku kurrunpangku puritjunutjangka. ");
INSERT INTO piu2006_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","25","Paluru katja mantjilku. Katja palunya nyuntu yini watjala!, ‘Yiitjunya’. Yilta paluru tjananya Yitjurilaku walytja ngaṉṯitja tjuṯa ngulytjura kanyilku, kuya tjanampa waṉirra, kana kutu tjana nyinanytjaku.” Yalatji Katutjaku ilkari ngurrarangku Tjutjupanya watjaṉu. Tjutjupanya yanku ngarrirra kanarringkula pakara yanu Miirinya yaḻṯingu, Katutjakuṉu ilkari ngurrarangku watjaṉutjangka. Nyinarrapula wiya tjungu ngarringi, ngula katja yutitjarringutjangka kutju ngaṉṯipula tjungu ngarringu. Pipirri paluru yutitjarringutjangka katja wiima paluru yini watjaṉu, “Yiitjunya”. Yalatji Miirilu ilta katja mantjiṉu watiku ngurrpangku. Palunya nguwanpa Katutjaku wangka watjalpayingku yirriṯi watjaṉu yalatji, “Ngula, kungka watiku ngurrpangku katja mantjilku. Yaṉangu tjuṯangku katja palunya yini yalatji watjalku, ‘Katutjakuṉu nganaṉala nyinanyi.’” ");
INSERT INTO piu2006_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yalatji Yiitjunya puunarringu manta Tjuutiyala tawunu Pitjiliyamala, mayutju tiṉa Yirutanya nyinangitjangka. Palulanguruya wati ninti maṉkurrpa kakarraranguru Tjarutjalumalakutu yanu. Paluru tjana piṉṯirri tjuṯa nyakula kulilpayi. ");
INSERT INTO piu2006_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Tjarutjalumala paluru tjana yaṉangu tjuṯa tjapiṉu yalatji, “Tjuwu tjuṯaku mayutju tiṉa, yaalytjingka ngarrinyi?, kuwarri paluru puunarringu. Kakarrara nganaṉatju piṉṯirri kutjupa nyangu. Nyakulalatju kuliṉu, ‘Piṉṯirri nyarrangku nganaṉanya nintiṉi mayutju kutjupalpi yutirringutjangka.’ Mayutju palunya nyakula waḻkulkitjalatju ngalyanu.” ");
INSERT INTO piu2006_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Wangka palunya mayutju Yirutalulpi kulira yurrukuliṉingi, “Ngayulu tjinguru mayutju nyinarra wiyarringku.” Tjarutjalumanya ngurrara tjuṯangku kuliṉu, “Tjinguru Yirutalu tjuulytji tjuṯa watjalku nganaṉanya pungkunytjaku, mayutju kutjupaku nganaṉa ngulytjurritjipingka.” ");
INSERT INTO piu2006_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Yirutalu watjaṉu tuḻkuku mayutju tjuṯa, Muutjaku wangka nintilpayi tjuṯaṯarra ngalya yankula tjungurrinytjaku. Tjungura tjananya tjapiṉu yalatji, “Katutjalu watjaṉu yirriṯi Kurayitjanya ngalyankunytjaku. Ngurra yaalytjingka paluru puunarriku?” ");
INSERT INTO piu2006_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Tjana watjaṉu, “Katutjaku wangka watjalpayingku piipangka wakaṉu paluru manta Tjuutiyala tawunu Pitjiliyamala puunarriku. Yalatji paluru wakaṉu, ");
INSERT INTO piu2006_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Tawunu Pitjiliyamanya ngurrara tjuṯangku, kulilaya! Wiya nyurrangarrimpa ngurra mungutja ngaranyi, ngurra puntu. Manta Tjuutiyalawana ngurra tjuṯa ngaranyi. Ngurra palula tjanala wirriḻi Pitjiliyamanya ngaranyi, ngurra puntu. Nyurrangarrimpa ngurrangka mayutju tiṉa yutirriku. Paluru tjananya Yitjurilaku walytja ngaṉṯitja tjuṯa yaṉṯayaṉṯanmalpa. Ngayuku walytja tjuṯa tjana nyinanyi.’” ");
INSERT INTO piu2006_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Palulanguru Yirutalu watjaṉu palumpa waarrkana yankula wati ninti maṉkurrpa palunya yalatji watjantjaku, “Ngalyarraya wangkanytjaku!” Wiya Yirutalu palumpa waarrkana kutjupa tjuṯangka tjakultjunu, kakarrara ngurrara tjuṯangka wangkakitjangku. Palulanguru kakarrara ngurrara paluru tjana ngalyankula nyinanytjala Yirutalu tjananya tjapiṉu yalatji, “Yaalytjingaranyurra nyangu?, piṉṯirri paluru yutirringutja.” ");
INSERT INTO piu2006_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Paluru tjana watjaṉu, “Yuwa, nganaṉatju nyangu, irriṯi piṉṯirri paluru yutirringu.” Yirutalu tjananya watjaṉu, “Tawunu Pitjiliyamalakutu yankula nyurrangarri purinytjungku ngurrila!, pipirri wiima palumpa. Nyakula ngalyankula ngayunya tjakultjurra!, ngayululpiṉa yankula palunya puḻkapungkunytjaku.” ");
INSERT INTO piu2006_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Wangka palunya kulira tjana yanu. Waaḻanguru tjana pakalkatirra piṉṯirri palunya nyakula yunyparringu. Yunyparringkula tjana piyuku wanaṉingi. Piṉṯirri paluru yurrunarringu tjanampa yankula ngarakatingu ngurra kutjungka tawunu Pitjiliyamala. Ngurra palula Yiitjunya pipirri wiima ngarringi. ");
INSERT INTO piu2006_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ngurra palulaya tjarrparra nyangu maamararra, Miirinya pipirri wiimaṯarra. Nyakulaya pupakatirra mayutju tiṉa kulira pipirri wiima palunya tjana puḻkapungangi. Palulanguru yulytja tjuṯaya yankula mantjiṉu yungkukitjangku pipirri wiima palunya. Kuulta tjuṯa, tjira paṉṯi palyatjarra, mirritjina nguwanpaṯarra tjana palunya yungu. ");
INSERT INTO piu2006_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Palulanguru tjana tjukurrpa nyanganyingka Katutjalu tjananya marrkuṉu wiya Yirutalakutu piyuku yankunytjaku. Palulanguruya ngurra walytjakutu yiwarra kutjupawana yarrka yanu, Yirutalamarra. ");
INSERT INTO piu2006_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Kakarrara ngurrara paluru tjana ngurrakutu yananyingka ngaṉṯi, Tjutjupalu tjukurrpa nyanganyingka, Katutjakuṉu ilkari ngurrarangku tjakultjunu yalatji, “Ngurra ngaatja wantirra parrpaṯu pulanya kati!, maamararra manta Yitjipilakutu, mayutju Yirutalamarra. Paluru kuliṉi pipirri palunya mirri pungkukitjangku. Nyurrangarri manta Yitjipila rawa nyinama! Ngayuluṉanta ngurra palula ngula watjalku ngalya katinytjaku pulanya.” ");
INSERT INTO piu2006_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Kala, munga palula paluru pakara maamararra katingu manta Yitjipilakutu. ");
INSERT INTO piu2006_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Yitjipila tjana maa tjarrparra rawa nyinangi. Palunyatjanu mayutju Yirutanyalpi wiyarringu. Yilta Tjutjupanyangarri manta Yitjipila nyinanytjala Katutjalu tjananya watjaṉu palumpa katja Yiitjunya, Tjutjupanya Miirinyaṯarra piyuku manta Yitjurilalakutu yankunytjaku. Yalatji nguwanpa Katutjakuṉu wangka yiltarringu, palumpa wangka watjalpayingku yirriṯi watjaṉutja. Paluru yalatji watjaṉu, “Ngayulu watjaṉu ngayuku katja manta Yitjipilanguru Tjuutiyalakutu yankunytjaku.” ");
INSERT INTO piu2006_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Palulanguru mayutju Yirutanya kakarrara ngurrara palumpa tjanampa puntura ngurrkurringu, tjana yarrka anutjangka ngurra walytjakutu. Paluru watjaṉu palumpa tjuulytji tjuṯa, yankula uḻa wiima tjuṯa mirri pungkunytjaku, tawunu Pitjiliyamala. Pitjiliyamala ila ngurra wiima tjuṯa ngarangi. Paluru tjananya watjaṉu ngurra palulawanaṯarra uḻa wiima tjuṯa mirri pungkunytjaku. Yalatji tjananya watjaṉu, “Uḻa wiima tjuṯa yiiya kutjarrangka puunarringutja tjuṯanyurra mirri pungkunytjaku. Uḻa wiima ngarripayi tjuṯa, maramara yankupayi tjuṯa, tjina parra yankupayi tjuṯaṯarra mirri puwa!” Yirutalu yirriṯi kuliṉu yalatji, “Kakarrara ngurrara tjuṯangku yiiya kutjarrangka nyangu piṉṯirri yutirrinytjala. Yalatji tjana ngayunya watjaṉu. Palulanguru mayutju paluru yiiya kutjarrangka puunarringu.” Yalatji kulira Yirutalu tjananya watjaṉu uḻa wiima yiiya kutjarra nyinangutja tjuṯa mirri pungkunytjaku, Yiitjunya uḻa wiima mirri pungkukitjangku tjungura. ");
INSERT INTO piu2006_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Palulanguru Yirutaku tjuulytji tjuṯangku yankula uḻa wiima tjuṯa mirri pungkuyinangi. Yalatji paluru tjana uḻa wiima tjuṯa pungkunytjala Katutjaku wangka yiltarringu. Wangka panyapa Katutjaku wangka watjalpayingku Tjirimayalu yirriṯi watjaṉu yalatji, ");
INSERT INTO piu2006_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Tawunu Ramala Yitjurilaku walytja ngaṉṯitja tjuṯa ngurrangka yulamalpa pipirri wiima tjuṯa mirri punganyingka. Pipirri wiima tjuṯa mirrirringku. Kutjupa tjuṯangku tjananya puṯu marrkulku, kutuya yulamalpa.” ");
INSERT INTO piu2006_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Palulanguru mayutju Yirutanya mirrirringu. Tjutjupanya manta Yitjipila yanku ngarrirra tjukurrpa nyanganyingka, Katutjaku ilkari ngurrarangku palunya tjakultjunu yalatji, ");
INSERT INTO piu2006_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Pakaralpi pulanya maamararra kati manta Yitjurilalakutu! Yirutalungarri nyuntupa katja mirri pungkukitjangku kuliṉingi. Kala paluru tjana mirrirringu.” ");
INSERT INTO piu2006_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Palulanguru Tjutjupalu pulanya maamararra katingu manta Yitjurilalakutu. ");
INSERT INTO piu2006_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ngururrpaya yankula tjakulpa kuliṉu yalatji, “Yirutaku katja, Yakilayutjanyalpi Tjuutiyanya ngurrara tjuṯaku mayutju tiṉalpi nyinanyi.” Wangka panyapa Tjutjupalu kulira nguḻurringu. Paluru piyuku tjukurrpa nyangu. Katutjaku ilkari ngurrarangku marrkuṉu wiya manta Tjuutiyalakutu yankunytjaku. ");
INSERT INTO piu2006_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Palulanguru Tjutjupalu pulanya katingu manta Kaliliyilakutu, tawunu Natjaritjalakutu. Tawunu palulaya nyinangi. Tawunu palula Yiitjunya nyinanytjala Katutjaku wangka kutjupa iltarringu. Palumpa wangka watjalpayi tjuṯangku yirriṯi watjaṉu yalatji, “Yaṉangu tjuṯangku watjalku, ‘Paluru Natjaritjanya ngurrara.’” ");
INSERT INTO piu2006_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Yiitjunya ngurra palula tiṉarringkula wati rawa nyinangi. Palulanguru manta Tjuutiyala Tjaananya ngurra kapiwiyawana nyinapayi. Paluru Katutjaku wangka yaṉangu tjuṯangka tjakultjunkupayi, kapingkaṯarra tjananya tjarrpatjunkula papatatjimilalpayi. ");
INSERT INTO piu2006_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Yalatji tjanala tjakultjunkupayi, “Nyurrangarri kuya palyara nyinapayi. Yalatji palyalwiyangkuya wanti!, Katutjakuya tjukarurru nyinama! Katutjalu tjananya kuwarri yaṉangu tjuṯa ngulytjulku. Yuḻṯa palunya yilarringulpi.” ");
INSERT INTO piu2006_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yaatjayalu, Katutjaku wangka watjalpayingku wangka Tjaananyatjarra yalatji watjaṉu, “Paluru yankula ngurra kapiwiyawanangka nyinaku. Ngurra palula yaṉangu tjuṯa yankula tjungurriku palumpa wangka kulilkitja. Paluru tjananya yalatji watjalku, ‘Yiwarra tjukarurruwanaya nyinama!, mayutju tiṉa paluru nyurrangarrinya ngalyankula nintilku.’” ");
INSERT INTO piu2006_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Tjaananya tjaaṯa kutjupatjarra nyinangi, kamula yinyutjanutjarra. Piilta kamula pangkitjanutjarra nyinangu. Tjiṉṯilyka ngalypuruṯarra ngalkura nyinapayi. ");
INSERT INTO piu2006_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Paṉa Tjuutiyanya ngurrara tjuṯaya tawunu Tjarutjalumanya ngurrara tjuṯaṯarraya Tjaanalakutu yankula yila ngarangi, palumpa wangka kulilkitja. ");
INSERT INTO piu2006_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Tjaanalakutuya kuya palyalpayi tjuṯangku tjakultjunkupayi, Katutjala kurungka. Yaṉangu kutjuṯu kutjuṯungkuya tjakultjunanyingka Tjaanalu tjananya kapingka tjarrpatjunkula papatatjimilalpayi, karru yini Tjuutanala. ");
INSERT INTO piu2006_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Paratji tjuṯa, mayutju kutjupa tjuṯaṯarra Tjaanalakutu yanu kapingka papatatjimilantjaku. Paluru tjananya watjaṉu yalatji, “Piḻkaṯi tjuṯa, warungkamarra tjalkaḻungkunytja nguwanpa, nyurrangarri nyinanyi, Katutjalu nyurranya ngula warungka kutjaltjipingkamarra. Nyurrangarri yalatji palulamarra ngayulakutu ngalya yanu ngayulu nyurrangarrinya kapingka tjarrpatjunkula papatatjimilantjaku. ");
INSERT INTO piu2006_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","9","Maṉkurr maṉkurrpangkunyurra ngunytji watjalpayi, ‘Ngayulu kuya palyantjawiya, tjukarurrulpi nyinanyi.’ Kutunyurra wiyawana nyinanyi, ngunytji. Katutjaku tjukarurru nyurrangarri nyinanytjaku. Wiyanyurra wiyawanangku kulintjaku yalatji, ‘Wiyala yurrukulira nyinanytjaku, Yipuramanya walytja tiṉalampa yirriṯi nyinapayi, nganaṉa palumpa ngaṉṯitja tjuṯa nyinanyi. Katutjanyalampa yunypa nyinanyi, Yipuramaku yunypa nyinanytja nguwanpa. Palulanguru wiya Katutjalulanya kuya palyalpayi tjuṯa iluntara wiyalku.’ Ngayulu Tjaanalu nyurrangarrinya watjaṉi. Katutjalu yunytjurrirra nyurrangarrinya wiyara, Yipuramaku walytja kutjupa tjuṯa puḻi ngaa tjuṯatjanu palyara nyinatjunku. ");
INSERT INTO piu2006_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Kuya palyantjawiyanyurra Katutjaku tjukarurru nyinanytjaku, Katutjalu nyurranya mulyarrarrirra pungkula wiyaltjipingka. Watiya mangarriwiya kutu ngaranyingka nyakula watingku mangarri pakantjaku puṯu paṯara, yilipitjarrangku yatura waṉiku warungka. Watiya palunya kuya yaṉangu nguwanpa nyinanyi. Katutjalu nyakula puṯu paṯara tjukarurrurrinytjaku, pungkula warungkalpi yuṉṯura waṉiku.” ");
INSERT INTO piu2006_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Tjaanalu tjananya piyuku watjaṉu, “Ngayuluṉa nyurrangarrinya kapingka kutju papatatjimilalpayi, nyurrangarri kuya wantirra tjukarurru nyinakitjangku kulintjala. Kutjupa mayutju tiṉanya ngalya yanku, ngayula ngaṉṯi. Paluru nyurrangarrila Katutjaku kurrunpa tjarrpatjunku. Yilta paluru mayutju tiṉa nyinaku, ngayuluṉara mayutju ngaṉṯi nguwanpa. ");
INSERT INTO piu2006_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Kurayitja paluru kaṉilpatjarra nguwanpa nyinaku, tjiiṯa tjuṯa kutju mantjilkitja. Mangarri wanguṉu nguwanpa mantjira tjunku, kaṉilpangka, tjanpi kutju waṉiku warukutu. Waru palunya kutu kampamalpa. Yara palunya nguwanpa Kurayitjalu ngula kuutawutjungka yaṉangu palumpa walytja tjuṯa ngurrtjara tjunku, palumpa ngurrangka nyinanytjaku. Kuya palyalpayi tjuṯa payira iyalku warukutu.” ");
INSERT INTO piu2006_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Palulanguru manta Kaliliyilanguru Yiitjunya yanu karru Tjuutanalakutu Tjaanalakutu, kapingka paluru tjarrpatjunkula papatatjimilantjaku. ");
INSERT INTO piu2006_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yiitjunya Tjaanala papatatji mantjilkitjangku tjapintjala Tjaanalu puṯu marrkuṉu yalatji, “Wiya. Nyuntu ngayunyaṉin kapingka tjarrpatjunkula papatatjimilantjaku.” ");
INSERT INTO piu2006_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yiitjulu palunya watjaṉu, “Nyuntu palya ngayunya kuwarri tjarrpatjunkula papatatjimilantjaku, Katutjanya yalatjiku yunyparringanyi.” Palulanguru Tjaanalu yuwa wangkangu. ");
INSERT INTO piu2006_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Tjaanalu Yiitjunya tjarrpatjunkula papatatjimilantjala, ilkari alytjurarringu. Yiitjunya kapinguru pakara ngaranytjala Tjaanalu nyangu Katutjaku kurrunpa paaḻkara nguwanpa tjarukatinytjala Yiitjulakutu. ");
INSERT INTO piu2006_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Palulanguru ilkaringuru Katutjalu watjaṉu Yiitjunya yalatji, “Nyuntu ngayuku katja, yunytjuṉanta nyinanyi. Punturaṉanta yunypa nyinanyi, nyuntupa.” ");
INSERT INTO piu2006_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Katutjaku kurrunpangku Yiitjunya yaḻṯirra katingu ngurra kapiwiyawana, mamuku mayutjungku Yiitjunya tjingapungkunytjaku, waarrka kuya palumpaṉu palyantjaku. ");
INSERT INTO piu2006_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ngurra palula Puratiyi tjikitjipala nyinayinangi. Ngurra palula mangarri ngalkuwiya rawa nyinarra, paḻtjatjirratjarringu. ");
INSERT INTO piu2006_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Palulanguru mamuku mayutjungku yalatji watjaṉu, “Tjinguru nyuntu Katutjaku katja nyinarra puḻi pala tjuṯa mangarri palyala ngalkukitjangku!” ");
INSERT INTO piu2006_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yiitjululpi watjaṉu, “Katutjaku wangka ngaranyi alatji, ‘Wiya mangarri kutju ngalkura yaṉangu kana kutu nyinaku, Katutjanya kulira kutju kana kutu paluru nyinaku.’” ");
INSERT INTO piu2006_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Puṯu tjingapungkula tawunu Tjarutjalumalakutu mamuku mayutjungku Yiitjunya yaḻṯirra katirra tjaatji tiṉangka katu nyinatjunu. ");
INSERT INTO piu2006_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Nyinatjunkula watjaṉu, “Tjinguru nyuntu Katutjaku katja nyinarra katunguru wararrakati!” Mamuku mayutjungku piyuku watjaṉu, “Katutjaku wangka yalatji ngaranyi, ‘Ilkari ngurrara tjuṯangkunta purinytju witira walatjunku, mantangka punkaltjipingka. Katutjalu watjalku nyuntunyantaya purinytju kanyintjaku.’” ");
INSERT INTO piu2006_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yiitjulu watjaṉu, “Katutjaku wangka ngaranyi yalatji, ‘Yaṉangungku wiya Katutjanya watjantjaku, paluru walytjangku kutju kulira palyalpayi.’ Palulanguru ngayulu wiya Katutjanya watjalku ngayunya yaṉṯayaṉṯantjaku.” ");
INSERT INTO piu2006_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Mamuku mayutju paluru Yiitjunya katuwana katirra puḻi katu nyinatjunu. Nyinatjunkula nintiṉingi manta, waaḻa tjuṯa, mani puntu waaḻangka ngarrinyingka, yaṉangu tjuṯaṯarra. ");
INSERT INTO piu2006_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Nintira watjaṉura, “Ngaa tjuṯaku ngayulu mayutju tiṉa nyinanyi. Mayutjungkuṉanta watjaṉi. Ngaa tjuṯakuṉanta mayutju tiṉalpi nyinatjunku, ngayunyaṉin mayutju puḻkapunganyingka. Nyuntu ngayunya puḻkapungku, yilta?” ");
INSERT INTO piu2006_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yiitjulu watjaṉu, “Yarra mamu! Katutjaku wangka ngaranyi yalatji, ‘Mayutju Katutjanya kutju puḻkapungkula tjukarurru nyinanytjaku.’” ");
INSERT INTO piu2006_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Mamu paluru puṯu tjingapungkula Yiitjunya wantikatingu. Ilkari ngurrara tjuṯangku Yiitjunya ngalya yankula palunya yaṉṯayaṉṯaṉingi. ");
INSERT INTO piu2006_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Palulanguru tjuulytji tjuṯangkuya Tjaananya witira katirra tjiilangka tjarrpatjunu. Palunya tjarrpatjunutjangka kulira Yiitjunya manta Kaliliyilakutu yanu. ");
INSERT INTO piu2006_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Tawunu Natjaritjalawana yankula tawunu Kapaniyamalakutu yanu, kutu nyinakitja. Tawunu paluru yuru Kaliliyila tjayiṯingka ngarangi. Wati yirriṯitja kutjarra yini Tjipulananya, Naputalinya ngurra palula nyinapayi, palumpa kutjarraku walytja ngaṉṯitja tjuṯaṯarra. ");
INSERT INTO piu2006_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Manta palula Yiitjunya nyinanyingka Katutjaku wangka yiltarringu, Katutjaku wangka watjalpayingku Yaatjayalu yirriṯi yalatji watjaṉu. ");
INSERT INTO piu2006_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Tjipulanaku, Naputaliku ngurra karru Tjuutanala wilurarra ngaranyi, yuru tiṉangka tjayiṯingka, manta yini Kaliliyila. Kutjupa tjuṯaya karru Tjuutanala kakarrara nyinanyi. Palumpa kutjarraku walytja ngaṉṯitja tjuṯa, Kaliliyinya ngurrara kutjupa tjuṯaṯarra Tjuwuwiya tjuṯa nyinanyi. Yuwankarrangkunyurra wangka ngaatjanyalpi kulintjaku. ");
INSERT INTO piu2006_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Nyurrangarri Katutjaku ngurrpa nyinanyi, kuya palyara nyinapayi. Ngula nyurrangarri Kurayitjaku nintirrinytjala palurulpi nyurrangarrimpa kuya waṉiku.” ");
INSERT INTO piu2006_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Palulanguru Yiitjulu tjananya yaṉangu tjuṯa nintiṉingi yalatji, “Nyurrangarri kuya palyalwiyangku wantirra, ngayukuṉu tjakulpa palya kulintjaku. Yalatji kuliranyurra Katutjaku walytja tjuṯalpi nyinaku. Paluru yirriṯi watjara wantinyingka yuḻṯa palunya yilarringulpi. Kuwarri paluru tjananya yaṉangu tjuṯa ngulytjura yaṉṯayaṉṯalku.” ");
INSERT INTO piu2006_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Palulanguru yuru Kaliliyila tjayiṯiwana Yiitjunya yanu. Yankula pulanya nyangu, yurungka niitingitjarrangkupula kuka piitji mantjirinangitja. Wati paluru kutjarra Tjaamananya Yanturunya kaakararrapula nyinangi. Paluru kutjarrangku kuka piitji kapuṯura mantjiṉangi, yalatjipula rawa waarrkarripayi. Ngula yaṉangu tjuṯangku Tjaamananya palunya yini kutjupa watjalpayi, “Piitanya.” ");
INSERT INTO piu2006_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yiitjulu pulanya watjaṉu, “Tjungulaka yarra! Nyupalipulanu kuka piitji waarrkarringkula mantjilpayi. Ngayulu nyupalinya nintilku waarrka kutjupa, Katutjaku wangka nyupali tjanala nintintjaku, yaṉangu tjuṯangka, tjana kulira palumpa walytjarringkunytjaku, Katutjaku.” ");
INSERT INTO piu2006_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Palulangurupula niitingi palunya wantirra Yiitjulawana tjungu yanu, yurungka tjayiṯiwana. ");
INSERT INTO piu2006_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Tjana yankula nyangu Tjayimitjanya Tjaananyaṯarra, paluru kutjarra kaakararra nyinanyingka, tjiḻpi Tjipitiyiku katja kutjarra nyinanyingka puutangka. Tjungungku tjana nyinarra palyaṉingitjangka puuta palula, palumpa paapangkuṯarra niitingi palunya. Yiitjulu pulanya nyakula yaḻṯingu. ");
INSERT INTO piu2006_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Palulangurupula paapa yini Tjipitiyinya, wantikatirra, Yiitjulawanalpi tjungu yanu. ");
INSERT INTO piu2006_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Palulanguru Yiitjulu paṉa Kaliliyilawana ngurra tjuṯawana tjakultjurinangi yalatji, “Kuwarri Katutjalu tjananya yaṉangu tjuṯa ngulytjura yaṉṯayaṉṯalku.” Tjuwuku tjaatji tjuṯawanaṯarra paluru tjakultjurinkula mamutjarra tjuṯaku tjanampa mamu payira wantirriyarinangi. Miiṉṯa tjuṯaṯarra paluru palyarinangi. ");
INSERT INTO piu2006_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Yalatji palyarinangitjangka yaṉangu tjuṯangkuya Yiitjunya tjakultjurinangi, manta Tjiriyalawanangku. Palulanguru yaṉangu tjuṯangku Yiitjulakutuya katingu, mamutjarra tjuṯa, parralayitji tjuṯa, walytja mirrarra punkalpayi tjuṯa. Yiitjulu tjananya miiṉṯa yuwankarra palyaṉingi. ");
INSERT INTO piu2006_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Yaṉangu tjuṯalingkungkuya Yiitjunya wanara kulirinkupayi, Kaliliyinya ngurrara tjuṯangku, Tikapulitjanya ngurrara tjuṯangku, Tjarutjalumanya ngurrara tjuṯangku, manta Tjuutiyanya ngurrara tjuṯangku, karru Tjuutanala kakarrara nyinapayi tjuṯangkuṯarra. ");
INSERT INTO piu2006_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yaṉangu tjuṯa tjungurringkula ngarala waṉinyingka nyakula Yiitjunya puḻingka kaḻpangu katunguru tjananya nintilkitja. Paluru kaḻparra nyinanytjala palumpa kutunguḻu tjuṯa tjungurringkula palula yila nyinangi. ");
INSERT INTO piu2006_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Nintilkitjangku tjananya yalatji watjaṉu, ");
INSERT INTO piu2006_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Maralpa kutjupa tjuṯa Katutjaku tjukarurru nyinanyi. Katutjalu tjananya purinypangku kanyinmalpa. Yalatji kulira tjana yunypa nyinaku. ");
INSERT INTO piu2006_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Walytja wiyarrinytjala yulapayi tjuṯa Katutjalu tjananya aḻṯurunytjungku kanyilku. Yalatji kulira tjana yunypa nyinaku. ");
INSERT INTO piu2006_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Walytjangku waḻkuntjawiya tjuṯa Katutjalu tjananya walytja tjuṯa yaṉṯayaṉṯara kanyilku. Yalatji kulira tjana yunypa nyinaku. ");
INSERT INTO piu2006_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Katutjaku tjukarurru nyinakitja yunytjurripayi tjuṯa Katutjalu tjananya yilta ngulytjura kanyilku. Yalatji kulira tjana yunypa nyinaku. ");
INSERT INTO piu2006_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Yaṉangu tjuṯaku aḻṯururringkula kanyilpayi tjuṯa Katutjalu tjananya aḻṯururringkula kanyinmalpa. Yalatji kulira tjana yunypa nyinaku. ");
INSERT INTO piu2006_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Katutjaku kutju tjukarurru nyinapayi tjuṯangku ngula Katutjala nyinarra palunya yutitja nyakuku. Palunya nyakula tjana yunypa nyinaku. ");
INSERT INTO piu2006_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Yaṉangu tjikipaka marrkulpayi tjuṯa Katutjalu tjananya palumpa walytja tjuṯa yaṉṯayaṉṯalku. Yalatji kulira tjana yunypa nyinaku. ");
INSERT INTO piu2006_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Yaṉangu tjuṯa Katutjaku tjukarurru nyinanytjala, kutjupa tjuṯangku tjananya panypurangkula pungkuku. Katutjalu tjananya yilta palumpa walytja tjuṯa yaṉṯayaṉṯalku. Yalatji kulira tjana yunypa nyinaku.” ");
INSERT INTO piu2006_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","12","Yiitjulu tjananya piyuku nintiṉu yalatji, “Nyurrangarri ngayuku walytja nyinanyingka, kutjupa tjuṯa nyurrangarrimpa tuunlayiki nyinaku. Paluru tjanalpi nyurrangarrinya kanginypungkula panypurangkuku, ngayuku walytjanyurra nyinanyingka. Panypuranganyingka Katutjalu nyurranya purinymara kanyilku. Yalatji kuliranyurra yunypa nyinanytjaku. Ngula paluru nyurranya palumpa ngurrangka kutu kanyilku. Nyurrangarrinya kuwarri panypurangkunytja nguwanpa, yirriṯi nyinanytja tjuṯangku Katutjaku wangka watjalpayi tjuṯa tjananya panypurangkupayi.” ");
INSERT INTO piu2006_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Paṉṯutjanu kuka palyarripayi. Paṉṯu palunya palya, ngayuku walytja palya tjuṯa nguwanpa. Paṉṯu kapingka rawa ngarrirra kuyarringkupayi, yaṉangungku paṉṯu palunya waṉipayi. Yiitjulu yalatji nintilkitjangku yara palunya watjaṉu. Paṉṯu kuya, kapingka rawa ngarripayi nguwanpa, yaṉangu tjaampalaya kuya nyinanyi. Ngayuku wangkaya aapwayi kulira tjana ngayuku walytja nyinakitja yunyparripayi. Yalatji yunyparringkula kutjupawanalpiya nyinapayi. Wiyaya ngayuku puntura yunytjurringanyi, kutjupa tjuṯakuya puntura yunytjurringanyi. Nyurrangarri ngayuku kutu tjukarurru nyinanytjaku.” ");
INSERT INTO piu2006_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Waaḻa tjuṯa puḻi katu ngaraku layititjarra. Yaṉangu tjuṯangku layiti nyakula tjungurriku mungangka. Nyurrangarri ngayuku walytja tjuṯa layititjarra nguwanpa nyinanyi. Yaṉangu ngayuku ngurrpa tjuṯangku nyurrangarrinya nyakula tjungurriku ngayuku wangka kulilkitja.” ");
INSERT INTO piu2006_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Yara kutjupa tjananya Yiitjulu watjaṉu nintilkitjangku, “Laampa tilira wiya turaamangka tjarrpatjunanyi, yuti waralytjunanyi, tilingaranyingka yaṉangu tjuṯangku nyakunytjaku. ");
INSERT INTO piu2006_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nyurrangarri yaṉangu tjuṯaku tjukarurru palyantjaku. Yalatjinyurra tjukarurru palyantjala tjana nyurrangarrinya nyaku, laampa waralytjunutja nguwanpa yutitja. Yalatji nyurrangarrinya nyakula tjana paapa Katutjanya waḻkulku tjungurringkulalpi.” ");
INSERT INTO piu2006_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Tjinguru tjaampalangkunyurra yalatji wiyawana kuliṉi, ‘Yiitju Kurayitjanya mantakutu ngalya yanu Muutjakuṉu wangka panypurangkukitja. Paluru wangka kutjupaṯarra panypurangkukitja ngalya yanu, Katutjaku wangka watjalpayi tjuṯangku yirriṯi watjaṉutja. Wangka palunya panypurangkula paluru nganaṉanya wangka kutjupa nintilku.’ Wangka palunya panypurangkukitja wiyaṉa mantakutu ngalya yanu. Wangka paluru yiltarringu ngayulu mantakutu ngalya yananyingka. Muutjalu panyapa tjuṯangkuṯarra wangka ngayunyatjarra watjara wakalpayi. ");
INSERT INTO piu2006_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Wangka ngaatjaya kulila! Muutjaku luwu tjanampa ngarapayi, yirriṯi nyinanytja tjuṯaku. Wiya yirriṯi nyinanytja tjuṯaku kutju ngarapayi, nganampaṯarralampa, luwu paluru ngaranyi, wiyarrinytjawiya. Luwu paluru kutu ngaramalpa. Ilkari mantaṯarra wiyarringanyingka, kutu luwu paluru ngaramalpa, wiyarrinytjawiya. ");
INSERT INTO piu2006_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Wangka paluru puntulingku, marrkuntja tjuṯa. Marrkuntja kutju tjinguru yaṉangungku kilytjuntankunytjala Katutjanyara wiya puntura yunyparriku. Tjinguru yaṉangu paluru kutjupa tjuṯa nintilku marrkuntja palunya tjuṯa kilytjuntankunytjaku. Yalatji tjananya nintintjala Katutjanya yaṉangu palumpa wiya yunypa nyinaku. Paluru Katutjaku walytja tjuṯangka mayutjuwiya nyinaku. Tjinguru yaṉangu kutjupa mantangka nyinarra marrkuntja palunya tjuṯa kulira tjukarurru nyinanytjala Katutjanya palumpa puntura yunypa nyinaku. Yaṉangu paluru kutjupa tjuṯa marrkuntja palunya tjuṯaku tjukarurru nyinanytjaku nintintjala, Katutjanyara puntura yunypa nyinaku. Paluru Katutjaku walytja mayutju nguwanpa nyinaku. ");
INSERT INTO piu2006_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Yaṉangu tjuṯangkuya watjalpayi, ‘Muutjaku luwu nintilpayi tjuṯa, Paratji tjuṯaṯarraya tjukarurru Katutjaku luwuku nyinanyi.’ Paluru tjana wiya Katutjaku luwuku tjukarurru nyinapayi. Nyurrangarri Katutjaku luwuku puntura tjukarurru nyinanytjaku. Yalatjinyurra puntura tjukarurru nyinarra kutju Katutjaku walytja tjuṯangkalpi tjungu nyinaku.” ");
INSERT INTO piu2006_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Yiitjulu tjananya piyuku nintiṉu, “Yitjurilaku walytja ngaṉṯitja tjuṯa yirriṯi nyinanytjala Muutjalu tjananya Katutjaku luwu nintilpayi. Yalatjikunyurra ninti nyinanyi. Muutjalu tjananya yalatji watjaṉu, ‘Yaṉangu kutjupa wiya mirri pungkunytjaku.’ Paluru piyuku tjananya watjaṉu, ‘Yaṉangu kutjupa mirri pungkunytjala, katirranyurra kuutawutjungka ngaratjunkula watjantjaku.’ ");
INSERT INTO piu2006_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ngayulu nyurrangarrinya watjaṉi wangka palunya nguwanpa. Walytja kutjupaku ngurrkurringutjangka, Katutjalu palunya ngula kuutawutjungka watjalku. Tjinguru yaṉangu kutjupangku palumpa walytja yalatji watjalku, ‘Nyuntu kuya, pina rama.’ Yalatji watjaṉutjangka Katutjalu palunya ngula kuutawutjungka watjalku. Tjinguru yaṉangu kutjupangku palumpa walytja pikapikarringkula warrkintjala Katutjalu palunya ngula kuutawutjungka watjara warukutu wantirriyalku. ");
INSERT INTO piu2006_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Walytja kutjupa tjuṯaku nyurrangarri kalypa nyinanytjaku. Tjinguru nyuntu tjaatji tiṉangka Katutjaku tjawirrilyi tjunkukitja nyinaku. Yalatji nyinarra nyuntu pina alytjurarringkula yalatji kulilku, ‘Nyarratja ngayuku walytjatju ngurrku nyinanyi, kalyparrinytjawiya.’ ");
INSERT INTO piu2006_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Yalatji kulira tjawirrilyi tjunkula wantirra nyuntu yarra!, palula kalypa wangkakitja. Kalypapula wangkarra rayitpayiki nyuntu ngalya yankula nyuntu Katutjaku tjawirrilyi palunya katirra tjurra tjaatjingka! ");
INSERT INTO piu2006_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Yara kutjupaya kulila! Tjinguru wati kutjupangka nyuntu kuya palyalku. Palurunta pikarrirra kuutawutjukutu katikitjangku watjantjala, nyuntu wangkarra kalyparrinytjaku, kuutawutjukutunta katitjipi, mayutju kuutawutju ngurrarangkunta watjara tjiilangka tjarrpatjunkutjipingka. ");
INSERT INTO piu2006_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Tjinguru mayutju palurunta payina puntu yunganyingka puṯu nyuntu kulilku payina payimilalkitjangku.” Yara palunya nintira Yiitjulu tjananya yalatji watjaṉu. Ngayuku wangka kulira nyuntu yaṉangu tjuṯaku kalypa nyinanytjaku. Kalypa tjanampa nyinanytjawiyangka Katutjalunta ngula kuutawutjungka wangkarra warukutulpi iyalpayingkamarra. ");
INSERT INTO piu2006_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Muutjalu yirriṯi Katutjaku luwu tjananya watjara nintiṉu yalatji, ‘Wati kutjupaku miiṯa wiyara tjulyara kanyintjaku.’ Wangka palumpa yalatjikunyurra ninti nyinanyi. ");
INSERT INTO piu2006_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ngayulu nyurrangarrinya watjaṉi. Wiya kungka nyakula kulintjaku, ngarrikitjangku. Ngarrikitjangku kulintjala Katutjalu yalatji kuliṉi, ‘Ngaangku ngayuku luwu kilytjuntananyi, palula ngarrikitjangku kulira.’” ");
INSERT INTO piu2006_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Yiitjulu tjananya yara kutjupa watjaṉu, “Nyuntu tjinguru kuru kutjungku kuya palyaṉutjangku kulira palunya yurrkura waṉi!, kuya rawangku palyara Katutjaku wangka wantipayingkamarra. Palya nyuntu kuru kutjutjarra Katutjaku ngurrangka kana kutu nyinaku. Kuru kutjarratjarrangku nyuntu kuya rawangku palyara ilurra ngurra kuyakutu ankuku. Ngurra palula waru tiṉa kutu kampamalpa. ");
INSERT INTO piu2006_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nyuntu tjinguru mara kutjungku kuya palyaṉutjangku kulira mara palunya kuntara waṉi!, kuya rawangku palyara Katutjaku wangka wantipayingkamarra. Palya nyuntu mara kutjutjarra Katutjaku ngurrangka kana kutu nyinaku. Mara kutjarratjarrangku nyuntu kuya rawangku palyara ilurra ngurra kuyakutu anku. Ngurra palula waru tiṉa kutu kampamalpa.” Wangka palunya Yiitjulu yara nguwanpa watjaṉu. Nganaṉa wiya kuya palyara kuru yurrkura waṉinytjaku. Nganaṉa wiya kuya palyara mara kuntara waṉinytjaku. Yara kuru waṉinytjatjarra watjara Yiitjulu nganaṉanya marrkuṉi kuya palyara nganaṉa piyuku palyantjawiyangku wantinytjaku. Yalatji wantirra nganaṉa tjukarurru kutu palumpa nyinanytjaku. Yara mara kuntara waṉinytjatjarra watjara Yiitjulu nganaṉanya marrkuṉi kuya palyara wantirra tjukarurru palumpa nyinanytjaku. ");
INSERT INTO piu2006_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Muutjalu tjananya yirriṯi Katutjaku luwu watjara nintiṉu yalatji, ‘Watingku miiṯa walytjaku yunytjuwiyarringkula wantirriyalkitjangku piipa wakara yungkuliyanytjaku, piipawiya wiya wantirriyantjaku.’ ");
INSERT INTO piu2006_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ngayulu nyurrangarrinya watjaṉi yalatji. Watingku miiṯa walytja kanyira, miiṯa kutjupa mantjilkitjangku wiya wantirriyantjaku. Miiṯa walytja wantirriyara kutjupa mantjira Katutjaku luwu kilytjuntananyi. Palya watingku miiṯa walytja wantirriyantjaku, paluru wati kutjupakutu yanutjangka. Tjinguru watingku miiṯa walytjaku yunytjuwiyarringkula wantirriyantjala kungka paluru wati kutjupakutu yankula nyinaku. Wati kutjupangka nyinarra kungka paluru Katutjaku wangka kilytjuntanku. Wati paluruṯarra kungka palula nyinarra Katutjaku wangka kilytjuntanku.” ");
INSERT INTO piu2006_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","36","Yiitjulu tjananya yara kutjupa watjaṉu, “Muutjalu tjananya yirriṯi Katutjaku luwu watjara nintiṉu yalatji, ‘Tjinguru nyuntu yaṉangu kutjupangka yalatji watjalku, “Katutjala kurungka ngayuluṉanta tjukarurru watjaṉi nyuntupa palyalkitjangku. Tjinguru ngayulu palyantjawiyangka Katutjaluṉi pungkupayingkamarra.” Yalatji watjara nyuntu palumpa tjukarurru palyala!, ramarringkula wantinytjawiyangku.’ Ngayulu Yiitjulu nyurrangarrinya watjaṉi yalatji. Wiyanyurra wangka palunya nguwanpa watjantjaku, wanti! ");
INSERT INTO piu2006_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Yalatji kutju nyurrangarri watjantjaku, ‘Yuwa, palyalkuṉanta.’ Tjinguru kutjupa wayi nyurrangarri watjantjaku, ‘Wiyaṉanta palyalku.’ Tjukarurrunyurra watjantjaku palyalkitjangku. Wiyanyurra yalatji watjantjaku, ‘Katutjala kurungka ngayulu tjukarurru watjaṉi nyuntupa palyalkitjangku.’ Yalatji tjana ngunytji wangkapayi tjuṯa wangkapayi, wiyanyurra yalatji wangkanytjaku. ");
INSERT INTO piu2006_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Muutjalu tjananya yirriṯi Katutjaku wangka watjara nintiṉu yalatji, ‘Tjinguru wati kutjupangkunta marangku kuru pungkula paanganku. Nyuntu palunya ngaparrtjingku kuru pungkula paangantjaku, marangku. Tjinguru wati kutjupangkunta kaṯiṯi pungkula kilytjuntanku. Nyuntu palunya ngaparrtjingku kaṯiṯi pungkula kilytjuntankunytjaku marangku.’ Wangka palunya Muutjalu tjananya watjaṉu. ");
INSERT INTO piu2006_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ngayulu nyurrangarrinya watjaṉi yalatji. Tjinguru yaṉangu kutjupangkunta kuya palyantjala nyuntu ngaparrtjingku pungkuwiyangku wanti! Nyuntu kuya palyantjawiyangka tjinguru yaṉangu kutjupangkunta kantja pungkukunta. Kutjupa tjayiṯi taaṉarrirra ngara!, kantjanta piyuku pungkunytjaku. Yalatjinta pungutjangka nyuntu pungkunytjawiya ngarama! ");
INSERT INTO piu2006_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Tjinguru yaṉangu kutjupangkunta maniku puṯu tjapilku ngaparrtjingku yungkunytjaku. Maniwiyangka palurunta tjinguru tjaaṯaku tjapilku. Tjaaṯa kuutaṯarra nyuntu yunypangku yungkunytjaku palunya. ");
INSERT INTO piu2006_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Tjinguru tjuulytjingkunta tjingapungku palumpa yulytja katirra yila tjunkunytjaku. Nyuntu wiya ngurra palula tjunkunytjaku, wirriḻira kati!, palumpa ngurrakutu. ");
INSERT INTO piu2006_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Tjinguru kutjupangkunta yinkanytjala, yuwa! Kutjupangkunta yulytja ngunytji kanyilkitjangku tjapintjala, yuwara!, ngalytjarringkuwiyangku. ");
INSERT INTO piu2006_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Yirriṯi Muutjalu yaṉangu tjuṯa watjara nintilpayi yalatji, ‘Nyurrangarri walytja tjuṯaku yunytjurringkula nyinama!, kutjupa tjuṯakunyurra yunytjuwiya nyinanytjaku.’ ");
INSERT INTO piu2006_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ngayulu nyurrangarrinya watjaṉi yalatji. Nyurrangarrimpa yunytjuwiya nyinanytja tjuṯaku nyurrangarri yunytju tjanampa nyinanytjaku. Nyurrangarrinya panypurangkula pungkupayi tjuṯaku Katutjanya tjanampa tjapila! ");
INSERT INTO piu2006_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Yalatjinyurra palya nyinarra, mayutju Katutjaku walytja tjuṯanyurra nyinaku. Katutjalu palumpa kulilwiya tjuṯa yaṉṯayaṉṯalpayi, kuya palyalpayi tjuṯaṯarra. Yaṉṯayaṉṯara tjanampa kapi wantirriyalpayi yaṉangu yuwankarraku. ");
INSERT INTO piu2006_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nyurrangarrimpa walytja tjuṯa nyurrampa yunytju nyinanyi. Walytja palunya tjuṯaku kutjunyurra yunytju nyinanyingka, Katutjanya wiya nyurrampa yunyparringanyi. Yaṉangu ulaataku nyurrangarri yunytju nyinanytjaku. Palunya nguwanpa Katutjaku kulilwiya tjuṯa tjanampa walytja tjuṯaku kutju yunytju nyinanyi. ");
INSERT INTO piu2006_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Nyurrangarrimpa walytja tjuṯa yunypa nyurrampa nyinanyi. Walytja palumpa tjanampa kutjunyurra nyakula yunyparringkupayi. Yalatjinyurra walytja tjuṯaku yunyparrinytjala wiya Katutjanya yunyparringanyi. Yalatji nguwanpaya nyinanyi, Katutjaku kulilwiya tjuṯa. Walytja tjuṯaku kutjuya nyakula yunyparringkupayi. Nyurrangarri yaṉangu ulaataku yunyparrinytjaku. ");
INSERT INTO piu2006_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Yalatjinyurra tjukarurru nyinanytjaku, nyurrangarrimpa paapa ilkari ngurrara tjukarurru nyinapayi nguwanpa.” ");
INSERT INTO piu2006_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","4","Yiitjulu tjananya piyuku nintiṉu yalatji, “Katutjaku tjukarurru nyinakitjangku wiyanyurra kulintjaku yalatji, ‘Yaṉangu tjuṯangka kurungka ngayulu yaṉangu maralpa mani yungkuku, yaṉangu tjuṯangkuṉi nyakula waḻkuntjaku.’ Wiyanyurra yalatji yungkunytjaku yaṉangu tjuṯangka kurungka. Wiyanyurra yalatji kutjupaku tjukarurru palyantjaku, yaṉangu tjuṯangka kurungka. Yalatjinyurra yaṉangungka kurungka palyantjala yaṉangu kutjupa tjuṯa kutju nyurrangarrimpa yunyparriku, Katutjanya wiya nyurrangarrimpa yunyparriku. Wiyanyurra palumpa walytja tjuṯa nyinaku. Tjaatji ngurrara ngunytjinytju tjuṯangku yalatji yaṉangu tjuṯangka kurungka maralpa tjuṯa yungkupayi, tjaatji tjuṯangka, kantina yurilpangkaṯarra. Yuwa, Katutjalu tjananya ngula kuutawutjungka watjalku. Yaṉangu maralpa mani yungkunytjaku, yaṉangu tjuṯa yila ngaranytjawiyangka, paapa Katutjalu kutju nyakula yunyparrinytjaku. Yalatji yunyparringkula nyurrangarrinya paluru ngula palumpa ngurrangka waḻkulku. ");
INSERT INTO piu2006_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Tjaatji ngurrara ngunytjinytju tjuṯangku tjaatjingka ngarala rawangku Katutjanya tjapilpayi. Paluru tjana kantina yurilpangkaṯarra ngarala Katutjanya rawangku tjapilpayi, yaṉangu tjuṯangka kurungka, yaṉangu tjuṯangku kulira yalatji kulintjaku, ‘Ingkaṯa palangku rawa Katutjanya wangkarra tjapilpayi. Paluru ilta ingkaṯa palyalingku.’ Wiya nyurrangarri yalatji kulira yaṉangu tjuṯangka kurungka Katutjanya tjapintjaku. Ngula Katutjalu palunya tjananya kuutawutjungka watjalku. ");
INSERT INTO piu2006_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Tjinguru nyuntu Katutjanya tjapilkitjangku kulira ngurrangka tjarrparra tuuwa patira kutjungku nyinarra palunya tjapintjaku, yaṉangu kutjupangkunta nyakutjipingka. Nganaṉa wiya nyuntunya nyakuku, paapa Katutjalunta nyakula ngula waḻkulku palumpa ngurrangka.” ");
INSERT INTO piu2006_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Yiitjulu tjananya piyuku nintiṉu, “Katutjaku ngurrpa tjuṯangku ngunytji Katutjanya nguwanpa rawangku tjapilpayi. Yalatjiya kuliṉi, ‘Nganampa mayutju ilkaringka nyinanyi. Nganaṉa palunya wiya kutjungara tjapira wantinytjaku, palurulanya kulira wantitjipingka. Nganaṉa palunya rawangku tjapintjala palurulanya parrpaṯungku kulilku.’ Wiyanyurra yalatji rawangku Katutjanya ngunytji tjapintjaku. ");
INSERT INTO piu2006_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Wiyanyurra yalatji kulintjaku Katutjaku ngurrpa nguwanpangku. Katutjalu kuliṉi nyuntu palunya tjapilkitjangku kulintjala. ");
INSERT INTO piu2006_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Yalatjinyurra Katutjanya tjapintjaku. “Nyuntu, paapa nganampatju ilkaringka nyinanyi. Nyuntupa yini maṯupurra uwankarrangka munkarra. Nintinmalanyatju yalatji rawangku kulintjaku! ");
INSERT INTO piu2006_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nyuntulanyatjun mayutjungku uwankarra ngulytjunma! Manta ngaangkalanyatju palyanma!, nyuntulawanalatju kaangkinytjingku palyantjaku, nyarra katu ngurrara tjuṯangku nyuntulawana palyantja nguwanpa. ");
INSERT INTO piu2006_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Kuwarrilanyatju yuwa mangarripa kuka! ");
INSERT INTO piu2006_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Nganaṉatju kuyarringanyingkampa nyuntulampatjun kalyparringama, kuya wiyanma! Tjinguru kutjupangkulanyatju kuyantjala, nganaṉatju palunya nguwanpa palumpara kalyparringama! ");
INSERT INTO piu2006_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Arrkaltjipingkamarralanyatju yangakanyinma!, kuya palyaltjipingka.” ");
INSERT INTO piu2006_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Yaṉangu kutjupa tjuṯakunyurra kalypangku nyinarra Katutjanya tjanampa tjapintjaku. Yalatjinyurra yaṉangu tjuṯaku kalypangku nyinarra tjapiṉingka, paapa Katutjalu ilkari ngurrarangku nyuntupa kulira kuya waṉiku. Paluru nyuntupa kalyparriku. ");
INSERT INTO piu2006_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Tjingurunyurra yaṉangu kutjupa tjuṯaku kalypawiya nyinarra Katutjanya tjanampa wiya tjapilku. Yalatjinyurra yaṉangu tjuṯaku kalypawiya nyinarra tjapintjawiyangka paapa Katutjalu ilkari ngurrarangku wiya nyuntupa kulira kuya waṉiku. Wiya nyuntupa paluru kalyparriku.” ");
INSERT INTO piu2006_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Yiitjulu tjananya piyuku nintiṉingi, “Tjinguru nyuntu kulilku mangarri kukaṯarra wantirra paapa Katutjanya rawangku tjapintjaku. Yalatji mangarri wantirra Katutjanya tjapira nyuntu yunypa nyinanytjaku, wiya nyuntu tjilurutjiluru nguwanpa nyinanytjaku. Tjaatji ngurrara ngunytjinytju paluru tjana tjilurutjiluru nyinapayi, mangarri wantirra Katutjanya tjapira. Paluru tjana yunytjurringkupayi yaṉangu tjuṯangku tjananya mangarri wantinytjala nyakula kulira puḻkapungkunytjaku. Paluru tjana yuṉpa tjuṉpangku nyapara tjilurutjiluru parra ngarapayi, yaṉangu tjuṯangku tjananya nyakula yalatji kulintjaku, ‘Yilta ngaa tjuṯangku mangarri ngalkuwiyangku wantinyi Katutjanyawarri tjapilkitjangku, palya tjuṯangku.’ Yaṉangu tjuṯangku kutju tjananya puḻkapungkupayi, Katutjanya wiya tjanampa yunypa nyinanyi. Paluru tjana ngula Katutjala wangkakuturriku. ");
INSERT INTO piu2006_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Nyuntu Katutjanya waḻkulkitjangku mangarri kukaṯarra wantirra yuṉpa paltjintjaku. Yalatji paltjira yunypa parra ngaranytjaku, tjilurutjiluruwiya. ");
INSERT INTO piu2006_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Yaṉangu tjuṯangkunta nyakula wiya kulilku, nyuntu mangarri wantirra Katutjanya waḻkuntjala. Yalatji nyuntu mangarri wantirra paapa Katutjanya waḻkuntjala paluru kutju nintingku kulilku. Paluru yunyparringkula nyuntunya ngula palumpa ngurrangka waḻkulku.” ");
INSERT INTO piu2006_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Yiitjulu tjananya piyuku nintiṉu yalatji, “Wiyanyurra mani tiṉa yulytja tiṉaṯarra kanyilkitjangku puntura yurrukulintjaku. Yalatji mantjira wiyanyurra kutu kanyintjaku, kutjupaku yungkuwiyangku. Mani tiṉa, yulytja tiṉaṯarra ngurra kutjungka rawa ngarrinytjala katilyka wiima tjuṯangku ngalkula wiyalpayi. Waaḻawana kapingku yintirra mani yulytjaṯarra kuyalpayi. Kutjupangkuṯarra mulyaṯangku mantjira katipayi. ");
INSERT INTO piu2006_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mani yulytjaṯarra kanyira nyurrangarri maralpa tjuṯa yungkunytjaku, kutu kanyilwiyangku. Maralpa tjuṯaku tjanampa nyurrangarri yunganyingka, Katutjanya nyurrampa puntura yunyparringkula ngula kanyilku palumpa ngurrangka katu, kana kutu nyinanytjaku. ");
INSERT INTO piu2006_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","23","Katutjaku ngurrangka nyinakitjanyurra yunytjurringkula yalatjinyurra kulinmalpa. Tjingurunyurra mani manta ngurraraku, yunytjurringkula maniku kutjunyurra yurrukulinmalpa. Yalatji kulira wiyanyurra Katutjaku ngurrangka nyinaku. Katutjaku ngurrangka nyinakitjangku nyurrangarri maralpa tjuṯa aḻṯururringkula yungkunytjaku, ngurrtjara yungkunytjawiya. Yalatjinyurra aḻṯururringkula yungkula Katutjaku tjukarurru nyinaku. ");
INSERT INTO piu2006_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Yaṉangungku mani tiṉa mantjira kanyilkitjangku kutju kulira nyinapayi, wiya Katutjaku tjukarurru nyinanyi. Nganaṉa Katutjaku kutju tjukarurru nyinanytjaku, mani mantjira kutu kanyilkitjangku kulintjawiya.” ");
INSERT INTO piu2006_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Yiitjulu tjananya piyuku watjaṉu, “Wangka panyapa kulira ngayulu nyurrangarrinya yalatji watjaṉi. Wiya nyurrangarri mangarriku mantarraku kutju ngalytjarrinytjaku, kapiku wiyanyurra ngalytjarrinytjaku, Katutjalu nyurrangarrinya yaṉṯayaṉṯaṉi. Katutjalu nganaṉanya kana nyinatjunkula paluru mangarri mantarra, kapiṯarra yungamalpa. Palunya kutjula kulira waḻkuntjaku. ");
INSERT INTO piu2006_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Tjuḻpu tjuṯaya kulila! Tjuḻpu tjuṯangkuya kaanangka wiya mangarri pakaltjingaṉi. Wiyaya muṯura waaḻangka tjarrpatjunanyi, ngula ngalkukitjangku. Paapa Katutjalu tjananya tjuḻpu tjuṯa paḻtjaṉi, wiya tjanampa waṯawaṯarringanyi. Nyurrangarri tjuḻpu tjuṯangka wirriḻi nyinanyi, maṯupurra. Katutjalu nyurrangarrinya yaṉṯayaṉṯalku, tjuḻpu mungutja tjuṯa nguwanpaṯarra. ");
INSERT INTO piu2006_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Tjiḻpi kutu nyinarra mirrirrikitjangku puṯu kulilku, ‘Yaalytjiyaalytjiṉa kana kutu nyinaku?’ Katutjakuṉu tayimingka paluru mirrirriku. Nganaṉa yalatji kulintjaku. Katutjalu nganaṉanya yaṉṯayaṉṯara kanyiṉi, palumpa tayimingka kutjula wiyarriku. ");
INSERT INTO piu2006_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Mantarra kutjupaku wiyanyurra yurrukulintjaku. Puluuma tjuṯaya kulila! Walytjaya pakara ngarala waṉipayi, wiyaya puluuma tjuṯa mantarrangka tjarrpapayi. Palyaya ngarapayi mantarra palyatjarra nguwanpa. ");
INSERT INTO piu2006_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Mayutju tiṉa paluru Tjalamunanya mantarra kiliina palyatjarra irriṯi nyinangi, kanya puluuma tjuṯa palyalingku ngarapayi. ");
INSERT INTO piu2006_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nyurrangarri wiya kuliṉi Katutjanya paluru yilta yaṉṯayaṉṯalpayi nyinanyi. Katutjalu puluuma yaṉṯayaṉṯalpayingku nyurrangarrinyaṯarra yaṉṯayaṉṯalku. Puluuma tjanpiṯarra kuwarri ngarala, tjiṉṯu kutjupangka piḻṯirringkula wiyarringkupayi. Puluuma, tjanpi yaṉṯayaṉṯalpayingku nyurrangarrinyaṯarra maṯupurra yaṉṯayaṉṯalku. Palulanguru nyurrangarri yaṉṯayaṉṯalpayi palunya kulintjaku. Yilta Katutjalu nyurranya yaṉṯayaṉṯanmalpa. ");
INSERT INTO piu2006_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Palulanguru wiya nyurrangarri mangarri ngalkukitjangku, kapi tjikilkitjangku yurrukulintjaku. Wiya mantarrangka tjarrpakitjangku yurrukulintjaku, ‘Mantarrawiyangka nyaangkaṉa tjarrpaku?’ Katutjalu nyurrangarrinya yungkuku. ");
INSERT INTO piu2006_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Katutjaku ngurrpa tjuṯangku mangarri ngalkukitjangku kutu kuliṉi. Paapa Katutjanya nyurrangarrimpa ninti nyinanyi, nyurrangarri mangarri ngalkura kapi tjikilpayi, mantarrangkaṯarranyurra tjarrpapayi. Yalatjiku paapa Katutjanya ninti nyinanyi. ");
INSERT INTO piu2006_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Katutjalu nyurrangarrinya ngulytjuṉu palumpa walytja tjuṯanyurra nyinanyi. Palumpa nyurrangarri tjukarurru nyinanytjaku. Nyurrangarri tjukarurru nyinanytjala paluru nyurrampa yungamalpa mangarri, yulytjaṯarra. ");
INSERT INTO piu2006_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kutjupa tjuṯangku yalatji kuliṉi, ‘Tjiṉṯungka tjinguru mangarri ngayuku ngarriku, tjinguru wiya. Tjinguru mangarriwiya ngayulu nyinaku, tjinguruṉa miiṉṯarriku.’ Kuwarri nganaṉa wiya yalatji kulintjaku, yunypala nyinanytjaku. Katutjalu kuliṉi tjiṉṯungka nganaṉanya yaṉṯayaṉṯalkitjangku, nganaṉa wiya yurrukulintjaku.” ");
INSERT INTO piu2006_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yiitjulu tjananya piyuku watjaṉu nintilkitjangku, “Wiyanyurra yaṉangu kutjupa yaḻṯuruwiyangku mayutju nguwanpangku watjantjaku. Nyurrangarri yaṉangu kutjupanya mayutju nguwanpangku watjantjala, Katutjalulpi nyurranya ngula kuutawutjungka aḻṯuruwiyangku mayutjungku watjara payira wantirriyalku. ");
INSERT INTO piu2006_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Nyurrangarri yaṉangu kutjupa yaḻṯururringkula wiya watjantjala ngula kuutawutjungka Katutjanya nyurrangarrimpa yaḻṯururriku.” ");
INSERT INTO piu2006_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Yara kutjupa tjananya watjaṉu Yiitjulu, “Nyuntula kurungka watiya wiima tjarrpanyingka, wati nintingku palurunta yinyu kurutjanu katura yurrkulkitjangku puṯu kulilku. Kuru walytjangka watiya tiṉatjarrangku puṯu nyaku yurrkulkitjangku. ");
INSERT INTO piu2006_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Wiya nyuntu walytja kutjupanya yankula watjantjaku yalatjingku, wiyawana nintilpayi nguwanpangku, ‘Kurungkaṉanta watiya wiima nyanganyi. Wanyuṉaka mantjila!’ Kuru walytjangka watiya tiṉangku yangatjunkula ngarrinytjatjarrangku wiya yalatji nyuntu watjantjaku. ");
INSERT INTO piu2006_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Nyuntu ngunytjinytju. Yurrunpangkunu watiya yangatjunkula ngarrinytjatjanu walytjangkunkun yurrkunmara nyuntupa kurungka. Palyalpiranu nyuntulpi nyangamara yaṉangu kutjupangka yurrkulkitjangku.” Yara palunya Yiitjulu kampa kutjupa yalatji tjananya watjaṉu, nintilkitjangku. Tjaampalangku wiyawana nintilpayi. Palunya tjananya nguwanpangku wiyanyurra yalatji watjantjaku, “Ngayulu nintilingku nyinanyi. Ngayuluṉanta nintilku tjukarurru nyinanytjaku. Nyuntu ngayuku wangka kulintjaku.” ");
INSERT INTO piu2006_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Yiitjulu tjananya watjaṉu palumpa kutunguḻu tjuṯangka, kulira wantipayi tjuṯangka wiya tjakultjunkunytjaku, “Katutjaku yunytjuwiya nyinarra palumpa walytja pungkupayi tjuṯangka wiyanyurra Katutjaku wangka tjakultjunkunytjaku, tjinguru nyurrangarrinya tjana mulyarrarringkula pungkutjipingka.” ");
INSERT INTO piu2006_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","8","Yiitjulu tjananya piyuku nintiṉingi, “Katutjanya nyurrangarri kutu tjapira nyinanytjaku. Paluru nyurrangarrinya yungkuku, kutu Katutjanyanyurra tjapintjala, mantjilkitjangku. Yilta yaṉangungku tjapintjala Katutjalu yungku.” ");
INSERT INTO piu2006_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Tjinguru nyuntupa katjangkunta mangarriku inkanytjala wiyaran puḻi yungkuku, wiya, nyunturan mangarri yungkuku. ");
INSERT INTO piu2006_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Tjinguru palurunta kuka piitjiku inkanytjala, wiyaran paapangku piḻkaṯi kana patjalpayi yungkuku, wiya, nyunturan kuka piitji yungkuku. ");
INSERT INTO piu2006_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nyurrangarri ilta kuya palyalpayi Katutjanya tjukarurru nyinanytja nguwanpa wiya. Kuya palyalpayi tjuṯangkunyurra tjukarurru yunganyi, katja anta yuṉṯalpa tjuṯanya, tjanantaya tjapintjala, kanya paapa Katutjalu nyurrangarrimpa tjukarurru palyaṉi, nyurrangarri tjapintjala. ");
INSERT INTO piu2006_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Tjingurunyurra yunytjurringanyi, yaṉangu kutjupangkunta tjukarurru palyantjaku. Yalatji yunytjurringkula yaṉangu kutjupaku tjukarurru palyala! Yalatji tjukarurru palyantjaku Muutjalu tjananya yirriṯi watjaṉu, Katutjaku wangka watjalpayi tjuṯangkuṯarra.” ");
INSERT INTO piu2006_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Yara kutjupa Yiitjulu tjananya nintiṉingi, “Ruutu wiimawana nyurrangarri yankula kiiṯa yutjungka tjarrpaku, kana kutu nyinakitja. Wiyanyurra ruutu tiṉawana yankunytjaku kiiṯa tiṉakutu, maa yankula warungka tjarrpatjipingka. Ruutu paluru tiṉanya wiya puḻiwana maa ngarrinyi, yaṉangu tjuṯalingku ruutu palulawana yananyi. ");
INSERT INTO piu2006_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Kiiṯa paluru yutjulingku. Ruutu wiima paluru maa ngarrinyi puḻiwana kiiṯa yutjukutu. Yaṉangu maṉkurrpa nguwanpa ruutu palulawana yananyi kana kutu nyinanytjaku.” Yiitjulu yalatji watjaṉu, “Yaṉangungku ngayuku wangka kulira walytjarringkula ruutu wiimawana yanku kiiṯa yutjungkalpi tjarrpaku, ngayuku ngurrangka kutu kana nyinakitja.” ");
INSERT INTO piu2006_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Yara kutjupa tjananya Yiitjulu watjaṉu, “Katutjaku wangka watjalpayi tjuṯa nguwanpa ngunytjinytju tjuṯa nyurrangarrilakutu ngalyankula wiyawana nintilku. Kutjupa tjuṯangku tjananya nyakula watjalku, ‘Pala tjuṯa ingkaṯa palya, nganaṉa wangka tjanampa kulintjaku.’ Yalatji wiya. Wangka tjanampa wiya nyurrangarri kulintjaku, wanti! ");
INSERT INTO piu2006_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ngunytjinytju tjuṯaya ngalya yananyingka nintingkunyurra kulilku, wiyawanangkuya palyantjala. Tjinguru watingku yukiri wiima pakaṉutja nyakula puṯu kulilku, ‘Watiya nyaa ngaatjanya?’ Yukiri paluru tiṉarringkula mangarritjarra ngaranytjala paluru nyakula nintingku kulilku, ‘Yuwa, yinitjarra ngaatjanya, watiya palya mangarri palyatjarra.’ ");
INSERT INTO piu2006_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","18","Watiya palya, mangarri palyatjarra ngaranyi. Watiya piḻṯi mangarri kuyatjarra ngaranyi. Watiya piḻṯingka wiya nganaṉa mangarri palya mantjiṉi. ");
INSERT INTO piu2006_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Watiya piḻṯi mangarri kuyatjarra kaana ngurrarangku yatura kilytjuntankula waṉiku, warukutu. ");
INSERT INTO piu2006_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Watiya piḻṯi mangarri kuyatjarra nguwanpa ngunytjinytju paluru tjana kuya nyinanyi. Paluru tjana kuya palyantjala nyakulanyurra kulilku, ‘Yiltaya ngunytjinytju tjuṯa.’” ");
INSERT INTO piu2006_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Yiitjulu tjananya piyuku watjaṉu, “Yaṉangu tjuṯangkuṉiya yalatji waḻkulpayi, ‘Nyuntu mayutju nganampa nyinanyi.’ Yalatji watjara tjana yankula kuya palyalpayi. Katutjalu wiya tjananya ngulytjura walytja tjuṯa kanyilku. Kutjupa tjuṯangku Katutjaku wangka kulira tjukarurru nyinanytjala palunya tjananya ngulytjura kanyilku palumpa ngurrangka. ");
INSERT INTO piu2006_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ngula Katutjalu tjananya yaṉangu tjuṯa kuutamilantjala tjuṯangkuṉiya yalatji waḻkulku, ‘Nyuntu nganampa mayutju nyinanyi. Nyuntu watjaṉutjangka nganaṉa Katutjaku wangka tjananya tjakultjurinkupayi. Mamu tjuṯaṯarra nganaṉatju payira wantirriyalpayi nyuntupa ngangkari tiṉatjarrangku. Yuwa, nganaṉa nyuntupa ngangkari tiṉatjarrangku yaṉangu kutjupa tjuṯaṯarra palyalpayi.’ ");
INSERT INTO piu2006_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ngayulu tjananya watjalku, ‘Wiya. Walytjawiyanyurra ngaranyi, ngurrpaṉa nyurrampa. Kuya palyalpayi tjuṯaya maa yarra!’” ");
INSERT INTO piu2006_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Yiitjulutjananya piyuku watjaṉu, “Yaṉangu ngayuku wangka kulira tjukarurru nyinarra waaḻa nintingku palyalpayi ngaa nguwanpa nyinanyi. Waaḻa palyalpayi paluru manta tjawara puḻi yutitjara, tjiminta yintira lalypara waaḻa palyalku. Waaḻa palunya puḻingka katu ngaramalpa taayiti kutu. ");
INSERT INTO piu2006_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Waḻpa tiṉangku rungkara kapi puntungku waaḻa palunya puṯu tjawatjawalku punkatjingalkitjangku, waaḻa palunya puḻingku witira kanyiṉingka. Waaḻa palyalpayingku tjukarurru palyaṉutja nguwanpa, ngayuku walytja tjukarurru kutu nyinaku. ");
INSERT INTO piu2006_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Yaṉangu kutjupangku ngayuku wangka kulira wantirra waaḻa palyalpayi kuyakuya nguwanpa nyinanyi, ngurrpa. Palyalpayi paluru tjiminta yintira lalypara manta katuwana waaḻa palyalku. ");
INSERT INTO piu2006_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Waaḻa palunya talingka katu ngaranyingka, waḻpa tiṉangku rungkara kapi puntungku waaḻa palunya ngaṯingaṯira punkatjingalku. Punkara kilytjukatirra yuḻpurriku. Waaḻa palyalpayi rama nguwanpa, yilta yaṉangu ngayuku wangka kulira wantirra rama nyinaku.” ");
INSERT INTO piu2006_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yiitjulu tjananya yara palunya tjuṯa nintingku nintintjala kuliraya yunyparrirraya kuliṉingi, ");
INSERT INTO piu2006_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","“Ngaangkulanya nintingku nyintilpayi, wiya Muutjaku wangka nintilpayi tjuṯa nguwanpa.” ");
INSERT INTO piu2006_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yiitjulu puḻi paṉṯangka tjananya yalatji nintira pakara tjarukatirra yanangi. Yaṉangu tjuṯalingkungku palunya wanaṉingi. ");
INSERT INTO piu2006_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Palulanguru wati kutju, pangki pikatjarra nyinangi. Ngangkaritjarra tjuṯangku pika palunya puṯu palyalpayi. Paluru Yiitjulakutu yankula pupakatirra watjaṉu, “Mayutju. Nyuntu yilta yunytjurringkula ngayunyaṉi pikatjarra palyala!” ");
INSERT INTO piu2006_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yiitjulu wati pikatjarra palunya marangku yilarringkula kata pampura watjaṉu, “Unytjurringanyiṉa. Kuwarrin palyarringkulpi.” Palulanguru wati paluru pikawiyarringu. ");
INSERT INTO piu2006_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yiitjulu palunya marrkuṉu, “Kutjupangka wiya tjakultjunkunytjaku, tjaatji tiṉakutu yarra!, tuḻkuku mayutjungka nintilanku!, pikawiyarringutjangkulpi. Tuḻkuku mayutju palumpa yuwara tjawirrilyi!, palyarringutjatjanungku. Tjawirrilyi yalatji yungkunytjaku, Muutjalu yirriṯi watjaṉu. Tjawirrilyi yalatji nyuntu yungkunytjala nyakulaya yaṉangu tjuṯangku kulilku yalatji, ‘Palatja pikatjarra nyinangutjangku palyarringkulalpi yunganyi, tjawirrilyi.’” ");
INSERT INTO piu2006_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yiitjunya yankula tawunu Kapaniyamala tjarrpanytjala tjuulytji tjuṯaku mayutjungku palunya tjapiṉu, ");
INSERT INTO piu2006_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Mayutju. Tjinguru nyuntu ngayuku waarrkana palyalku? Paluru ngurrangka miiṉṯa puntu ngarrinyi, puṯu kulira.” ");
INSERT INTO piu2006_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yiitjulu palunya watjaṉu, “Nyuntupa ngurrakutuṉa yankula palyalku.” ");
INSERT INTO piu2006_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Wati paluru piyuku kulira marrkuṉu, “Mayutju. Wiya nyuntu ngalya yankula ngayuku waaḻangka tjarrpanytjaku. Ngayulu nyuntupa mayutju tiṉaku kuṉṯarringanyi. Nyuntu ngaanguru kutju ngarala watjala!, waarrkana ngayuku pikatjarra palyarrinytjaku. Ngayulu nyuntupa kuṉṯarringanyi. Ngayulu mayutju wiima nyinanyi, kanya nyuntu mayutju tiṉa nyinanyi. ");
INSERT INTO piu2006_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ngayulu yalatji kuliṉi. Ngayuku mayutjungku ngayunya watjaṉingka ngayulu waarrkanangku palyalpayi. Tjuulytji tjuṯa ngayuku waarrkana tjuṯa nyinanyi. Tjuulytji kutju ngayulu watjara iyantjala, paluru yankupayi. Tjuulytji kutjupa ngayulu ngalya yankunytjaku watjantjala, ngayulakutu ngalya yankupayi. Ngayulu tjuulytji kutjupa tjaamtjingi palyantjaku watjantjala, paluru yalatji palyalpayi. Yalatji kulira ngayulu nyuntunya watjaṉi ngaanguru ngarala kutju nyuntu mayutju tiṉangku watjala!, ngayuku waarrkana pikatjarra palyarrinytjaku.” ");
INSERT INTO piu2006_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Tjuulytjiku tjuṯaku mayutju paluru Yiitjunya ngangkaritjarra kuliṉu palyalpayi. Yalatji paluru kulintjala Yiitjunya yunyparringu. Nguṉṯilangarala tjananya Yiitjulu yaṉangu tjuṯangka watjaṉu, “Tjuulytji tjuṯaku mayutju paluruṉi ngangkari puntutjarra kuliṉi, ngayuluṉa waṉmanguru wangkarra kutju palyantjaku. Yaṉangu kutjupa tjuṯangku wiya kuliṉi, ngayuluṉa ngangkaritjarrangku waṉmanguru watjara palyalpayi. Yitjurilaku walytja ngaṉṯitja tjuṯangkuṯarra wiya yalatji kuliṉi.” ");
INSERT INTO piu2006_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Paluru piyuku watjaṉu yalatji, “Wangka ngaatjanyaya kulilaya! Katutjaku walytja palunya tjananya Yipuramanya, Yatjikanya Tjikupanyaṯarra, Katutjalu yaṉṯayaṉṯalku. Paluru tjananya yaṉṯayaṉṯaṉingka kutjupa tjuṯa, Tjuwuwiya tjuṯaya yankula tjanalawana tjungurrirra nyinamalpa. Ngurra tjuṯawana nyinanytja tjuṯaya yankula tjungurriku tjanala kakarraranguru, wilurarranguru. Paluru tjana tjungurringkula tjungungku ngalkula yunyparriku, Katutjaku walytja tjuṯa. ");
INSERT INTO piu2006_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Yitjurilaku walytja ngaṉṯitja tjuṯa wiya palula tjanalawana tjungu nyinaku. Katutjalu tjananya payira wantirriyalku waru tiṉakutu. Mikin puntutjarraya nyinaku. Yitjurilaku walytja paluru tjana ngayuku wangka kulira palya nyinamara, Katutjaku walytja kutjupa tjuṯangka tjungurrirra.” ");
INSERT INTO piu2006_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Tjuulytji tjuṯaku mayutju palunya Yiitjulu piyuku watjaṉu, “Ngurrakutu maa yarra! Nyuntu ngayunya ngangkaritjarrangku palyalpayi kuliṉutjangka nyuntupa waarrkana palyarriku.” Yalatji Yiitjulu yurilnguru watjantjala palumpa waarrkana yilta palyarringulpi. ");
INSERT INTO piu2006_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yiitjunya yankula Piitaku waaḻangka tjarrpangu. Waaḻa palula Piitaku yumari miiṉṯa puntu wuumpi ngarringi. ");
INSERT INTO piu2006_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yankula Yiitjulu mara palunya pampuṉu. Pampuntjala paluru yilta pika wiyarringu. Wulkumanu paluru pakara parra ngarala mangarri kukaṯarra yungkula tjananya kanyiṉingi. ");
INSERT INTO piu2006_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Palulanguru tjiṉṯu tjarrpanyingka, tawunu palunya ngurrara tjuṯangku miiṉṯa tjuṯa mamutjarra tjuṯaṯarra katingu Yiitjulakutu pampura palyantjaku. Paluru mamu tjuṯa payira wantirriyaṉu. Pikatjarra tjuṯaṯarra palyaṉu. ");
INSERT INTO piu2006_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yalatji tjananya palyantjala Katutjaku wangka Yaatjayalu yirriṯi watjaṉutja yiltarringu. Katutjaku wangka watjalpayingku, paluru yalatji watjaṉu, “Paluru yaṉangu tjuṯa palyalku, mamu tjuṯa tjanampa payira wantirriyalku.” ");
INSERT INTO piu2006_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yiitjulu kuliṉu, “Yaṉangu tjuṯalingku ngayula tjungurringu.” Yalatji kulira palumpa kutunguḻu tjuṯangka watjaṉu, “Puutangkala kaḻparra manta kutjupakutu yankunytjaku, yurungka wirriḻi.” Tjana kaḻpakatirra yanu manta kutjupakutu. ");
INSERT INTO piu2006_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ngurra palula tjana tjarukatirra ngaranyingka Muutjaku wangka nintilpayingku Yiitjula watjaṉu, “Nintilpayi. Yunytjurringanyiṉa nyuntulawana yankukitja ngurra tjuṯakutu. Tjungula parra ulytjamalpa ngurra tjuṯawana, wiyaṉanta wantirriyalku.” ");
INSERT INTO piu2006_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yiitjulu watjaṉu, “Papa tjuṯa puḻingka nyinapayi. Tjuḻpu tjuṯaya pintjuṉpangka nyinapayi. Ngayuluṉa yaṉanguku katjangku ngurra wiya kanyiṉi, ngarrikitjangku.” ");
INSERT INTO piu2006_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Yiitjuku walytja kutjupangku Yiitjula yalatji watjaṉu, “Mayutju. Wanyu paṯala!, ngayuku paapa tjiḻpi nyinarra mirrirringanyingka, kutjuli tjungu yulytjayinamalpa.” ");
INSERT INTO piu2006_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yiitjulu watjaṉu, “Paluru mirrirringanyingka walytja kutjupa tjuṯangkuya palunya yaṉṯayaṉṯara, tjunutjunkunytjaku. Kuwarri ngali Katutjaku wangka tjakultjurinkunytjaku.” ");
INSERT INTO piu2006_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yiitjunya palumpa kutunguḻu tjuṯaṯarra puutangka piyuku kaḻparra yanu. ");
INSERT INTO piu2006_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Puutangkaya Yiitjunyangarri yankunytjala ngururrpa waḻpa tiṉangku puuta pirrtjipirrtjitjingaṉu. Kapi tiṉa puutangka tjarrparra nguwanpa tjarrpatjunu. Tjarrpatjunkunytjala, yaṉangu tjuṯaya wiyarringamara. Yiitjunya yanku ngarringu puutangka ngaṉṯitjayiṯi. ");
INSERT INTO piu2006_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Nguḻurrirraya yankula kanara watjaṉu, “Mayutju pakala!, nganaṉatju ilupayingkamarra. Nyuntu kulilwiyakampa ngarrinyi.” ");
INSERT INTO piu2006_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yiitjulu tjananya tjapiṉu, “Nyaatjanunyurra nguḻurringu? Ngayunya Katutjakuṉu ngangkaritjarranyurra kulinmara.” Yiitjulu pakara waḻpa, yuru marrkuṉu. Palulanguru waḻpa rungkalwiya wiyarringu, ataṉpa ngarangu, yuru pirrtjiwiya ngarangu. ");
INSERT INTO piu2006_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Palumpa kutunguḻu tjuṯa wangkawiya nyinarra kuliṉuya, “Nyaatjanu, waḻpa rungkalwiya, uruṯarra pirrtjiwiya ngaranyi?” Palulanguru yalatjiya wangkarra pungu, “Ngaatjanya kutjupa. Ngaangku ngangkari tiṉatjarrangku waḻpa yuru marrkura yataṉmankupayi.” ");
INSERT INTO piu2006_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Palulanguru yuruwanaya Yiitjunyangarri puutangka yankula manta kutjupakutu yanu, yaṉanguku ngurrakutu, manta Kiritjinalakutu. Manta paluru yuru Kaliliyingka kakarrara ngaranyi. Puutanguru Yiitjunya tjarukatinyingka, wati kutjarra mamu tjuṯatjarra ngurra palunya ngurrara, kuḻpinguru tjalkaḻungu Yiitjulakutu, nyakukitja. Ngurra palula kuḻpi tjuṯa ngarangi, mirri tjuṯa tjunkupayi. Ngurra palula ruutu yila ngarringi. Yaṉangu tjuṯa palumpa kutjarraku nguḻurringkula ruutu palulawana wiya yankupayi, paluru kutjarrangku pungkupayingka. ");
INSERT INTO piu2006_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Yiitjulakutu paluru kutjarra wirrkara mirrarra watjaṉu, “Nyuntu Katutjakuṉu nyinanyi paawu tiṉatjarraku katja. Nyuntu nyaakitjanu ngalya yanu ngalilakutu, pungkunytjaku? Ngula kutju ngalinya pungkunytjaku, kuutawutjungka wangkarra.” ");
INSERT INTO piu2006_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Paluru kutjarra wangka palunya watjantjala pikipiki tjuṯangkuya puḻingka ngankirriwana ngalkuyinangi. ");
INSERT INTO piu2006_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Mamu tjuṯangkuya Yiitjula watjaṉu yalatji, “Nganaṉatju waṉma ngurra kutjupangka yankula nyinatjipingkamarra, pikipiki nyarra tjuṯakutulanyatju wantirriyala!, pikipikingkalpilatju tjarrparra nyinanytjaku.” ");
INSERT INTO piu2006_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Mamu tjuṯangkuya panyapa watjantjala, Yiitjunya wangkangu, “Kala, yarraya pikipiki tjuṯakutu!” Palulanguru wati panyapa kutjarra wantirra mamu paluru tjana pikipikingkalpiya tjarrparra nyinangi. Palulanguruya pikipiki paluru tjana mamu tjuṯatjarra tjalkaḻungkula punkaṉu yunngukutu ngankirringka. Tjarrparra yuru tiṉangkalpiya ilurra waṉingu. ");
INSERT INTO piu2006_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Palulanguruya maa yankula pikipikiku mayutju tjuṯangkuya tjakultjurinangi tawunuwana. Ngurra palula yaṉangu tjuṯangka tjananya tjakultjunu mamutjanu paluru kutjarra palyarringutjangka. ");
INSERT INTO piu2006_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Palunya ngurrara tjuṯangkuya tjakulpa kulira yanu Yiitjunya nyakukitja. Ngangkari tiṉatjarra tjana kulira Yiitjuku nguḻurringkula watjaṉu yalatji, “Ngurra kutjupakutu nyuntu yankunytjaku.” ");
INSERT INTO piu2006_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yiitjunya palumpa kutunguḻu tjuṯaṯarraya puutangka kaḻpakatirra yuruwana tawunu panyapakutu yanu, palumpaṉu ngurra walytjakutu. ");
INSERT INTO piu2006_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ngurra palula Yiitjunya nyinanyingka wati tjuṯangku wati parralayitji ngalya katingu tjuwayikingka ngarrinytjala. Nyakula tjananya Yiitjulu kuliṉu, “Ngayulu ngangkaritjarrangku palyalpayi kulira ngaa tjuṯangku ngaatjanya ngalya katirra tjarrpatjunu, ngayulu palyantjaku.” Yiitjulu parralayitji palunya watjaṉu, “Yangupala. Yunyparri!, nyuntupa kuya ngayulu waṉinyi.” ");
INSERT INTO piu2006_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Muutjaku wangka nintilpayi tjuṯangkuya ngarala kuliṉingi, “Katutjalu kutju yaṉanguku kuya waṉipayi. Wati ngaangku wiyawanangku watjaṉu, kuya waṉikitjangku.” ");
INSERT INTO piu2006_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Wangka panyapa tjana kulintjala, Yiitjunya ninti nyinangu. Yiitjulu tjananya tjapiṉu yalatji, “Ngayuluṉa kuya waṉinyingka, nyaaku nyurrangarri ngayunya panypuranganyi? ");
INSERT INTO piu2006_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ngayuluṉa watjara palumpa kuya waṉingu. Palulanguru tjinguru nyurrangarri kuliṉi, ‘Tjinguru paluru kuya waṉingu, tjinguru wiya.’ Tjinguruṉa wangka kutjupa yalatji watjalku, ‘Pakara palyarringkula yarra!’ Paluru pakantjawiyangka kulilkunyurra ngayunya ngunytjinytju. Wangka palunya ngayulu watjalku, nyurrangarri ngayunya ngunytjinytjuwiya kulintjaku. ");
INSERT INTO piu2006_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Nyurrangarri ngayunya kulintjaku, Katutjakuṉu ngangkaritjarrangkuṉa kuya waṉinyi. Ngayuluṉa yaṉanguku katjangku kuya waṉinyi.” Panyapa watjara tjananya Yiitjulu parralayitji palula watjaṉu alatji, “Watjaṉiṉanta. Pakala!, tjuwayiki ruulamapira mantjira ngurrakutu yarra!” ");
INSERT INTO piu2006_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","8","Palulanguru pakara paluru ngurrakutu yankunytjala yaṉangu tjuṯangku nyakula kuliṉingi, “Yalatji Katutjakuṉu ngangkari tiṉatjarrangku pakaltjingantjala kuwarri kutju nganaṉa nyangu.” Katutjanyalpiya waḻkuṉingi. ");
INSERT INTO piu2006_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Nintira tjananya wantirra yanu tawunuwana. Yankula paluru nyangulpi wati Maatjuwunya, kamantaku mani mantjilpayi. Waaḻa wiimangka mani kamantaku nyinarra mantjintjala, Yiitjulu palunya watjaṉu, “Tjungulika yarra!” Yilta paluru pakaṉu, Yiitjulawanalpi tjungu yanu. ");
INSERT INTO piu2006_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Maatjuwuku ngurrakutu tjanaya yanu, Yiitjuku kutunguḻu tjuṯaṯarra. Ngurra palulaya mangarri ngalkunytjala kutjupa tjuṯa tjana tjungurringkula nyinangu, kamantaku mani mantjilpayi tjuṯa, Katutjaku ngurrpa tjuṯaṯarra. ");
INSERT INTO piu2006_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Paratji tjuṯaya yankula waaḻangka yila ngarangu. Paluru tjana Yiitjuku kutunguḻu tjuṯa tjananya tjapiṉu yalatji, “Nyaakukampa nyurrangarrimpa nintilpayingku tjungungku nyinarra ngalkuṉi kamantaku mani mantjilpayi tjuṯawana?, Katutjaku ngurrpa tjuṯawanaṯarra? Tjungungku ngalkuwiyangku wantimara tjananya.” ");
INSERT INTO piu2006_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","13","Yiitjulu kuliṉu tjananya panypurangkula wangkanytjala. Paluru yaralpi tjananya watjaṉu, “Wiya ngangkaritjarrangku yaṉangu pikawiya yankula ngangkaritjunanyi, pikatjarranya kutju ngangkaritjunanyi. Wiyawanangkunyurra kuliṉi. Ngayulu ngangkaritjarra palunya nguwanpa nyinanyi. Ngayuluṉa Katutjakuṉu ngangkaritjarra ngalya yanu yaṉangu kuyatjarra tjuṯa nintintjaku, wiyaṉa ngalya yanu yaṉangu palya tjuṯa kutju nintintjaku, wiya. Yuwa, ngayulu ngalya yanu Katutjaku ngurrpa tjuṯa nintintjaku. Palya ngayulu tjanampa aḻṯururringkula tjungurringkula nyinanyi. Yalatji Katutjaku wangka yurrunpa tjunutja ngarrinyi, ‘Nyurrangarri ngayuku tjawirrilyi katirra tjunkupayi. Ngayulu Katutjanya tjawirrilyiku kutju wiya yunytjurringanyi, ngayulu yunytjurringanyi nyurrangarri yaṉangu tjuṯaku aḻṯurunytju nyinanytjaku.’” ");
INSERT INTO piu2006_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Tjiṉṯu palula Tjaanaku kutunguḻu tjuṯangkuya, Paratji tjuṯangkuṯarraya mangarri wantirra ngalkuwiyangku Katutjanya kutu waḻkulpayi. Mantayi kutjupangka Mantayi kutjupangka alatjiya tjana mangarri ngalkuwiyangku Katutjanya waḻkulpayi. Yalatji nyinarra Tjaanaku kutunguḻu tjuṯangku Yiitjulakutu yankula tjapiṉu yalatji, “Nyaakukampa nyuntupa kutunguḻu tjuṯangku mangarri kutu ngalkura nyinanyi?, Katutjanya waḻkulkitjangku mangarri tjana ngalkuwiyangku wantimara. Kanya nganaṉa, Paratji tjuṯangkuṯarra, mangarri wantirra Katutjanya waḻkuṉi.” ");
INSERT INTO piu2006_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yiitjulu tjananya yara watjaṉu nintilkitjangku, yalatji, “Miiṯararrapula tjungu nyinakitjangka palumpa kutjarraku maḻpa tjuṯa tjungurringkula, yunypangku ngalkura tuḻku warralku. Wiya tjana mangarri wantirra nyinaku, wati palunya miiṯatjarra nyinakitjangka, tjunguya wati palula nyinarra mangarri yunypangku ngalkuku. Ngula yaṉangu kuya tjuṯangku wati palunyaya witira katinytjala, palunya tayimi kutjuya maḻpa paluru tjana wati palumpaya yaḻṯururringkula, mangarri wantirra Katutjanya tjapilku, wati palunya yaṉṯayaṉṯantjaku.” Yiitjulu tjananya yalatji kampa kutjupa watjaṉu, “Wati palunya nguwanpa ngayunyaṉiya kuya tjuṯangku witira katiku. Palulanguru ngayuku kutunguḻu tjuṯangku mangarri wantirra Katutjanya ngayuku tjapilku.” ");
INSERT INTO piu2006_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Yiitjulu tjananya piyuku yara ngaatjanya watjaṉu, “Tjaaṯa yirriṯitjatjanu, alytjuratjarrangka wiya tjaaṯa nyuwanangka, nipinipitjarrangku muṯura mantjira tjunkunytjaku alytjurangka, wakalkitjangku, tjunkula nyiiḻangka wakara piyuku alytjurankupayingkmarra, alytjuralpi tiṉarritjipingka, wantinytjaku. Tjaaṯa nyuwana kutju payimilantjaku.” ");
INSERT INTO piu2006_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Yara kutjupa kiripitjikuṉu tjuutja kanyintjaku Yiitjulu tjananya watjaṉu. Tjuwu tjuṯangkuya kiripitjikuṉu tjuutja kanyilpayi, tjiipikuṉu pangkingka, wakara patira, paatulawiyangka. Yalatji pangkingka rawa ngarrirra wayinarripayi. Yiitjulu tjananya watjaṉu, “Wiya kiripitjikuṉu tjuutja kuwarritja yintira kanyintjaku pangki yirriṯitjangka, pangki taḻṯurringkula taalpayi. Wiya yirriṯitjangka kanyintjaku, taara kiripitjikuṉu tjuutja yintirra wiyarritjipingka, pangkiṯarra wintarrparringkula wiyarritjipingka. Yalatji yintira pangki nyuwanangka kutju kanyintjaku.” Yara palunya tjananya kampa kutjupa Yiitjulu watjaṉu yalatji. Tjaaṯa anta pangki yirriṯitja palunya wangka yirriṯitja Paratji tjuṯangku nintiṉutja nguwanpa ngaranyi, kanya tjaaṯa nyuwana anta pangki nyuwana nguwanpa Yiitjukuṉu wangka ngaṉṯitja ngaranyi. ");
INSERT INTO piu2006_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yiitjulu tjananya wangka panyapa watjantjala wati kutju yankula Yiitjula pupakatirra tjapiṉu, Tjuwuku tjaatjiku mayutjungku, “Ngayulu kuwarri kutju yuḻṯurringu ngayuku yuṉṯalpanguru. Nyuntu ngalya yankula marangku pampuntjala paluru yilta kanarriku. Ngayuku ngurrakutu ngalya yarra!, pampura palyantjaku.” ");
INSERT INTO piu2006_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yiitjunya kulira pakara tjungurringkula yanangi, palumpa kutunguḻu tjuṯaṯarra. ");
INSERT INTO piu2006_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Minyma pikatjarraṯarra paluru tjungu yulytjayinangi. Pika palunya minymaku tjanampa pika. Rawa pika palunyatjarra nyinangu yiiya tuwalpala. Yiitjulu tjananya yirriṯi kutjupa tjuṯa palyaṉutjangka minyma paluru kulira yalatji kuliṉu, “Palumpa kuuta kutjuṉa pampura pikawiyalpiṉa kuwarri nyinaku. Ngaatja ngangkari tiṉatjarra.” Wangka palunya kulira minyma paluru ngaṉṯiwana yankula Yiitjukuṉu kuuta yarrkayarrkangku pampuṉu. ");
INSERT INTO piu2006_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yiitjulu taaṉarringkula palunya watjaṉu, “Minyma. Nyuntu ngayunya kuliṉi ngangkari tiṉatjarra. Palulanguru nyuntu palyalpi ngaranyi mikinpawiya.” Yilta minyma paluru pikawiyarringu. ");
INSERT INTO piu2006_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Mayutju palumpa ngurrakutuya yankula waaḻangka tjarrparra tjananya nyangu, yaṉangu tjuṯa yularra waṉinyingka. Piipangka mutjika wangkatjingalpayi tjuṯaṯarra yulangi. ");
INSERT INTO piu2006_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Yiitjulu tjananya watjaṉu, “Yankulanyurra aatjayiṯi paṯara nyinanytjaku. Kungka paluru mirriwiya kutu ngarrinyi, yanku kutju ngarrinyi.” Yaṉangu tjuṯangku yalatji kuliṉu, “Yiitjulu wiyawanangku kuliṉi, yankuwiya, mirri ngarrinyi.” Yalatjiya kulira yinkangu. ");
INSERT INTO piu2006_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Yaṉangu tjuṯaya yankula waaḻangka aatjayiṯi nyinanyingka, Yiitjulu yankula kungka palunya mara witira kanara pakaltjingaṉu. ");
INSERT INTO piu2006_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Kungka palunya yalatji kanantjala yaṉangu tjuṯangkuya ngurra tjuṯawana tjakultjurinangi. ");
INSERT INTO piu2006_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yiitjulu ngurra palunya wantikatirra yanu. Wati paanga kutjarrangku kulira palunya wanarinangi. Paluru kutjarra mirrarra yaḻṯingu, “Yiitju. Tapitaku walytja ngaṉṯitja yaḻṯururriwalimpatju!” ");
INSERT INTO piu2006_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yiitjulu pulanya kulira wantirra yankula waaḻangka tjarrpangu. Paluru kutjarra ngurra palula tjarrparra Yiitjula yila ngarangi. Yiitjulu pulanya tjapiṉu, “Tjinguru nyupali kuliṉi ngayulu ngangkari tiṉatjarra nyinanyi nyupalinya palyantjaku?” Paluru kutjarra Yiitjunya watjara waḻkuṉu, “Yilta nyuntu ngangkari puntutjarra nyinanyi.” ");
INSERT INTO piu2006_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Yiitjulu pulanya kuru pampura watjaṉu, “Yalatji nyupali ngayunya ngangkari puntutjarra kulira kuru palyarriku.” ");
INSERT INTO piu2006_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Yilta paluru kutjarra kuru palyarringu. Yiitjulu palunya kutjarra marrkuṉu, “Palyarringkula wiya nyupali yaṉangu kutjupangka tjakultjunkunytjaku.” ");
INSERT INTO piu2006_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Paluru kutjarra Yiitjuku wangka kulilwiyangku wantirra ramarringkula yaṉangu tjuṯangka yankula tjakultjurinangi, Yiitjulu pulanya palyaṉutja. ");
INSERT INTO piu2006_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Yurrunpa Yiitjulu pulanya marrkuntjala kutjupa tjuṯangku wati wangkawiya Yiitjulakutu katirra ngaratjunu. Wati paluru mamutjarra nyinangi. ");
INSERT INTO piu2006_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yiitjulu mamu palunya payira wantirriyantjala wati paluru palyalpi wangkangi. Yaṉangu tjuṯangkuya wangkanytjala kulira yunyparringkula watjara waṉingu, “Kuwarri kutju nganaṉa nyangu ngangkari tiṉatjarrangku yalatji palyantjala. Yurrunpa Yitjurilaku walytja ngaṉṯitjawana wiya kutjupangku yalatji palyalpayi.” ");
INSERT INTO piu2006_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Kanya Paratji tjuṯangkuya yalatji wiyawana watjaṉu, “Mamuku mayutjukuṉu ngangkaritjarrangku Yiitjulu mamu payira wantirriyaṉi.” ");
INSERT INTO piu2006_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Palulanguru Yiitjunya, palumpa kutunguḻu tuwalpalaṯarra, tjunguya tawunu tjuṯawana yankula tjarrpayinangi. Yiitjulu palunya ngurrara tjuṯangka tjakulpa palya tjananya tjakultjurinkupayi yalatji, “Katutjalu yaṉangu tjuṯa ngulytjura yaṉṯayaṉṯaṉi.” Tjuwuku tjaatji tjuṯangkaṯarra paluru tjananya nintilpayi. Miiṉṯa tjuṯa mamutjarra tjuṯaṯarra tjananya paluru palyarinkupayi. ");
INSERT INTO piu2006_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yaṉangu tjuṯalingkuya palula tjungurrirra ngarala waṉingu. Nyakula tjanampa aḻṯururringu, tjiipi nguwanpaya mayutjuwiya ngarala waṉinytjala. ");
INSERT INTO piu2006_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Aḻṯururringkula palumpa kutunguḻu tjuṯa tjananya watjaṉu, “Yaṉangu tjuṯalingkuya nyinarra waṉinyi, ngayuku wangka kulilkitja, wiita tjuṯalingku, mangarritjarra ngarala waṉinytja nguwanpaya. Maṉkurrpa nguwanpanyurra ngayuku wangka nintilpayi tjuṯa nyinanyi, yaṉangu tjuṯalingku nintilkitja. Puṯu nyurrangarri tjananya yankula nintilku, tjuṯalingkungka. Yalatji nguwanpanyurra nyinanyi, wiita muṯulpayi maṉkurrpa nguwanpa. Puṯuya muṯulku wiita mangarritjarra, tjuṯalingkungka. ");
INSERT INTO piu2006_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Palulanguru Katutjanyaya tjapila!, paluru ngayuku wangka nintilpayi kutjupa tjuṯa wantirriyantjaku yaṉangu tjuṯakutu, wiita muṯulpayi maṉkurrpa palunya nguwanpa. Tjana kaanaku mayutju tjapintjaku, wiita muṯulpayi tjuṯa kutjupa wantirriyantjaku muṯurinkunytjaku.” ");
INSERT INTO piu2006_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yiitjulu tjananya yaḻṯirra tjunguṉu palumpa kutunguḻu tuwalpala. Kutjarra kutjarra tjananya Yiitjulu wantirriyalkitjangku paapa Katutjala tjapiṉu rapangku tjakultjurinkunytjaku. Paluru tjananya iyalkitjangku watjaṉu, mamu payira wantirriyantjaku, miiṉṯa tjuṯaṯarra palyantjaku, palumpaṉu paawutjarrangku. ");
INSERT INTO piu2006_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","4","Tuwalpala paluru tjanaya palumpa waarrkana tjuṯa nyinangi. Yini yalatjiya nyinangu, Tjaamananya, Yanturunya, Tjayimitjanya, Tjaananya, Pilipanya, Patjalamanya, Maatjuwunya, Tamatjanya, Tjayimitja kutjupanya, Tjaamana kutjupanya, Tjuutanya, Tjuutatjanya. Tjaamana paluru yurrunpa watjaṉutja Yiitjulu yini kutjupa watjaṉu yalatji, “Piitanya.” Yanturu paluru Piitaku maḻanypa nyinangu. Tjaamana kutjupa paluru ngaṉṯi watjaṉutja, paluru Ruumanya ngurrara tjuṯaku tuunlayiki nyinangu. Tjayimitja kutjupa paluru ngaṉṯitja watjaṉutja paluru Yalpiyatjaku katja nyinangu. Tjuutatjanya paluru tjana yini kutjupa watjalpayi, “Yitjikarriyatanya.” Paluru tjananya ngula tjakultjunu Yiitjunyaya witira iluntankunytjaku. ");
INSERT INTO piu2006_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","6","Tuwalpala palunya tjananya Yiitjulu wantirriyalkitjangku watjaṉu yalatji, “Yarraya!, Tjuwuku ngurra tjuṯawana. Tjuwuwiyaku ngurrawana wiyaya yarra! Tjamiriyanya ngurrara tjuṯaku ngurrawana wiyaya yarra!, tawunu tjanampangka wiyaya tjarrpa! Tjuwu tjuṯaku ngurrakutu kutjuya yarra!, Yitjurilaku walytja ngaṉṯitja tjuṯakutu. Tjiipi tjuṯa nguwanpaya nyinanyi kawaḻirringutja tjuṯa. Tjiipiku mayutjungku wiya tjananya yaṉṯayaṉṯaṉi. Katutjalu tjananya ngulytjuntjaku.” Yiitjulu tjananya piyuku watjaṉu, ");
INSERT INTO piu2006_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","“Wangka yalatji tjananya tjakultjurinama!, ‘Katutjalu yaṉangu tjuṯa ngulytjura yaṉṯayaṉṯalku, yuḻṯa paluru yilarringu!’” Yiitjulu tjananya piyuku watjaṉu wantirriyalkitjangku, ");
INSERT INTO piu2006_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","“Yankulaya miiṉṯa tjuṯa palyarinama!, pangki pikatjarra tjuṯaṯarra. Mirri tjuṯaṯarra tjananyaya kanarinama! Mamutjarra tjuṯangka tjanala mamu payiraya wantirriyarinama! Palyalkitjangku tjananyaya wiya maniku tjapila! Ngayuluṉa nyurrangarrinya maniku tjapilwiyangku nintilpayi. Miiṉṯa tjuṯaṯarra palyalkitjangku wiyaṉa tjananya maniku tjapilpayi. Yalatji nyurrangarri tjananya palyalkitjangku wiya maniku tjapintjaku.” ");
INSERT INTO piu2006_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","Kutjarra kutjarra wantirriyalkitjangku Yiitjulu tjananya watjaṉu, “Yankukitjangkunyurra wiya mangarri yulytja katinytjaku, wanaṯarra. Yalatji nyurrangarri wiya payiki, maniṯarra katinytjaku. Puutangkaya tjarrparra yarra! Turawutju, tjaaṯa walytjatjarra kutjunyurra yankunytjaku, kutjupa katinytjawiya. Katutjaku waarrkanyurra palyarinanyingka, yaṉangu tjuṯangku nyurrangarrinya paḻtjara yaṉṯayaṉṯalku.” ");
INSERT INTO piu2006_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Yiitjulu tjananya piyuku watjaṉu, “Nyurrangarri kutjarra yiitji tawunu kutjukutu yankunytjaku. Tawunu palulapula waaḻa kutjungka nyinarra tawunu palunya ngurrara tjuṯa nintinma! Waaḻa kutjupa kutjupangka wiya nyupali nyinanytjaku. Waaḻa kutjungka nyinarra nyupali tawunu kutjupakutulpi yankunytjaku. ");
INSERT INTO piu2006_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Tawunungka nyupali tjarrparra waaḻakutu yankula tjapilapula nyinakitjangku! Tjinguru nyupalinya tjana watjalku, ‘Waaḻa ngaangkapula tjarrparra nyinama!’ Waaḻangka tjarrparrapula yalatji watjala!, ‘Katutjalu nyurrangarrinya yaṉṯayaṉṯalku yunypanyurra nyinanytjaku.’ ");
INSERT INTO piu2006_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Waaḻa palunya ngurrara tjuṯangku ngayuku wangkaku yunyparringanyingka, yilta Katutjalu tjananya yaṉṯayaṉṯalku. Ngayuku wangkakuya yunyparrinytjawiyangka, Katutjalu tjananya wiya yaṉṯayaṉṯalku. ");
INSERT INTO piu2006_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Tawunu ngurrara tjuṯa nyupalimpa yunytjuwiyarrinyingka, nyupalimpa wangka tjana kulira wantinyingka, puuta nyupali yarrara manta puutatjanu yunngu ngarringitja, kiliinamilara tjarrparrapula wantirra yarra, tawunu kutjupakutu! ");
INSERT INTO piu2006_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Tawunu palunya ngurrara tjuṯangku nyupalinya kulilwiyangku wantingutjangka, Katutjalu tjananya ngula kuutawutjungka puntura kuru watjalku. Yirriṯi kuya palyalpayi kutjupa tjuṯa nyinangi. Palunya tjananya ngatalpa kuru watjalku. Paluru tjana yirriṯi ngurra Tjutumala, ngurra Kumuralaṯarra kuya palyalpayi, ngayuku wangkakuya ngurrpa nyinarra, wiyarringu. Yuwa, Tjutumanya ngurrara, Kumuranya ngurrara tjuṯaṯarra tjananya Katutjalu ngatalpa kuru watjalku, kanya tawunu palunya ngurrara tjuṯa tjananya puntura kuru watjalku, warukutu waṉikitjangku.” ");
INSERT INTO piu2006_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Wantirriyalkitjangku tjananya Yiitjulu piyuku watjaṉu, “Yankulanyurra yalatji kulinma! Ngayulu nyurrangarrinya tjami tjuṯa wantirriyaṉi, nintintjaku. Yaṉangu tjaampalangku nyurrangarrinya kulira pikarringkula pungkutjipingkamarra yankulaya purinypa tjanala nyinama! Tjiipi nguwanpaṉa nyurrangarrinya wantirriyaṉi, yinura tjuṯakutu nguwanpa. Katutjalu nyurranya purinytju katiyanamalpa, yaṉangu tjikipaka tjuṯangkamarra. ");
INSERT INTO piu2006_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Wangka ngaatjanyaya purinypa kulila! Ngayuku walytja tjuṯa nyurrangarrinya tuunlayiki tjuṯangku ngurra kutju ngurrara tjuṯangku witira katirra kuutamilalku, Tjuwuku tjaatjingka. Ngurra kutjupangka tuunlayiki tjuṯangku ngayuku walytja tjuṯa witira katirra kuutamilalku, Tjuwuku tjaatjingka. Yalatji nguwanpa tjananya ngayuku walytja tjuṯanya Tjuwuku tjaatji tjuṯangka kuutamilalku. Tjaatji palunya tjuṯangka nyurrangarrinya tjana katirra pungamalpa, wiipatjarrangku. ");
INSERT INTO piu2006_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ngayuku walytja nyurrangarri nyinanytjala, tjana nyurrangarrinya witira katirra mayutju tiṉa tjuṯangka ngaratjunku, kamanta ngurrara tiṉa tjuṯangkaṯarra. Mayutju palunya tjuṯangka tjanalanyurra ngarala ngayukuṉu wangka tjakultjunku, Tjuwuwiya tjuṯangkaṯarra. ");
INSERT INTO piu2006_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Mayutju palunya tjuṯangka tjanalanyurra rapa ngarala wiya nguḻurrinytjaku. Wiyanyurra yurrunpa kulintjaku, ‘Yaalytjiṉa ngayulu watjalku kuutawutjungka?’ Katutjaku kurrunpangku nyurrangarrinya nintilku palya wangkanytjaku. ");
INSERT INTO piu2006_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Yuwa, kurrunpa paluru nyurrangarrinya nintintjala tjukarurrunyurra wangkaku. Katutjaku wangkanyurra wangkaku, nyurrangarrimpa wangka wiya. ");
INSERT INTO piu2006_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Nyurrangarrimpa ngulytju tjuṯangku nyurrangarrinya ngayuku walytja tjuṯa katirra mayutjungka ngaratjunku, paluru yalatji watjantjaku, ‘Ngaatja Yiitjuku walytja katirranyurra mirri puwa!’ Kaakangku maḻanypa ngayuku walytja katirra ngaratjunkula kuutawutjungka watjalku, mirri pungkunytjakuya. Paapangku palumpa katja, yuṉṯalpaṯarra witilku, ngayuku walytja kutjarra. Witira pulanya katirra ngaratjunkula kuutawutjungka watjalku, mirri pungkunytjakuya. Katjangku, yuṉṯalpangkuṯarra paapa an maama ngayuku walytja kutjarra, katirra ngaratjunkula watjalku kuutawutjungka, mirri pungkunytjakuya. ");
INSERT INTO piu2006_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Yaṉangu tjuṯa nyurrangarrimpa tuunlayiki nyinaku, ngayuku walytjanyurra nyinanytjala. Tjingurunyurra ngayuku tjukarurru kutu nyinarra, kana kutunyurra nyinamalpa, Katutjaku ngurrangka. ");
INSERT INTO piu2006_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Tawunu kutjungka tjana nyurrangarrinya panypurangkula pungkunytjala tawunu kutjupakutunyurra yarra! Tawunu palula nyurrangarrinya kutjupa tjuṯangku panypurangkula pungkunytjala tawunu kutjupakutunyurra yankunytjaku. Yalatjinyurra tawunu tjuṯakutu yankula ngayuku waarrka palyantjala ngayululpi yaṉanguku katja piyuku mantakutu ngalya yanku. Tawunu kutjupa ngurrara tjuṯangku nyurrangarrimpa wangkaku ngurrpa nyinaku, ngayulu piyuku ngalyankunytjala.” ");
INSERT INTO piu2006_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","25","Yiitjulu tjananya wangka kutjupa watjaṉu, “Nintilpayiṉiya panypurangkupayi, ‘Nyuntu mamukuṉu.’ Ngayunya nguwanpa nyurrangarrinyaṯarra tjana yalatji panypurangku. Wati tjaampalangku ngayunya nyurrangarrimpa mayutju panypurangkula pungku. Yalatji nguwanpa nyurrangarrinya ngayuku waarrkana tjuṯaṯarra yaṉangu tjuṯangku panypurangkula pungkuku. ");
INSERT INTO piu2006_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Panypurangkula pungkupayi tjuṯaku nguḻuwiyaya nyinama! Wangka yalatjinyurra kulintjaku. Ngayulu nyurrangarrinya tjakultjunutja kutjupa tjuṯangkulpiya kulilku. ");
INSERT INTO piu2006_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Yalatji nguwanpa ngayulu nyurrangarrinya nintiṉutja yaṉangu tjuṯangkulpi kulintjaku. Wangka palunya nyurrangarri ngurra tjuṯawana tjakultjurinkunytjaku. ");
INSERT INTO piu2006_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Yaṉangu mirri pungkupayi kutjupangkamarra wiyanyurra nguḻu nyinanytjaku. Paluru tjana nyurrangarrinya mirri pungkula puṯu kulilku, piyuku pungkukitjangku. Katutjaku kutju nganaṉa nguḻunguḻu nyinanytjaku, mayutju tiṉaku. Paluru yaṉangu iluntara kurrunpa wantirriyalpayi warukutu. Yuwa, palumpalara yunytjurringkula tjukarurru nyinanytjaku. ");
INSERT INTO piu2006_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","31","Yaṉangu tjuṯangkuya kuliṉi tjuḻpu tjuṯa mungutja nyinanyi, kuka wiima. Katutjalu wiya mungutja kuliṉi tjuḻpu yuwankarra tjananya kutjuṯu kutjuṯu yaṉṯayaṉṯaṉi. Nyurrangarrinyaṯarra paluru kulira yaṉṯayaṉṯaṉi, mungutja kulilwiyangku.” Yara kutjupa Yiitjulu tjananya watjaṉu nintilkitjangku, “Katutjanya ninti nyinanyi nganampa katangka mangka tjuṯa ngarala waṉinytja tjuṯaku. Yinyu palunya kaantamilara nampaku Katutjanya ninti nyinanyi. Paluru yilangku nyakulalanya kanyiṉi. Yuwa, Katutjalu nyurrangarrinya kulira yaṉṯayaṉṯaṉi, palulanguru Katutjakunyurra yunytjurringkula nyinanytjaku. Paluru kuliṉi tjuḻpungka wirriḻinyurra nyinanyi, maṯupurralingku.” ");
INSERT INTO piu2006_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Yiitjulu tjananya piyuku kiina watjaṉu, “Yaṉangu kutjupa tjuṯanya tjananya nyurrangarri yalatji tjakultjunkunytjaku, ‘Ngayulu Yiitjuku walytja nyinanyi.’ Yalatjinyurra nguḻuwiyangku kutu watjantjala, ngula ngayulu nyurrangarrimpa kuutawutjungka paapa Katutjangka kurungka watjalku, ‘Yuwa, ngaa tjuṯaya ngayuku walytja tjuṯa nyinanyi.’ Yuwa, yalatji ngayulu yaṉanguku katjangku kuutawutjungka watjalku. ");
INSERT INTO piu2006_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Yaṉangu tjuṯaku nguḻurrirra tjinguru kutjupa tjuṯangku yalatji watjalku, ‘Ngayulu ngurrpaṉara, Yiitjuku walytjawiyaṉara.’ Yalatji paluru tjana nguḻurringkula watjantjala ngula kuutawutjungka tjanampa ngayulu Katutjanya watjalku yalatji, ‘Ngaa tjuṯakuṉa ngurrpa walytjawiyaṉa tjanampa.’ ");
INSERT INTO piu2006_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Tjingurunyurra yalatji wiyawanangku kuliṉi, ‘Yiitjunya mantakutu ngalya yanu yaṉangu tjuṯa nintilkitja, kalyparrirraya walytja tjuṯa palya nyinanytjaku.’ Wiya yalatji. Ngayuluṉa kuliṉi. Tjaampalangkuya ngayuku wangka kulira ngayuku walytjarriku, kanya tjaampalangkuya kulira ngayuku wangka wantiku. Tjana ngayuku walytja panyapa tjuṯaku yunytjuwiya nyinaku. ");
INSERT INTO piu2006_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Yalatjiya yunytjuwiya nyinaku. Paapa ngayuku walytja nyinanytjala palumpa katjara yunytjuwiyara nyinaku. Ngurra kutjupangka katja ngayuku walytja nyinanytjala, palumpa paapa yunytjuwiyara nyinaku. Ngurra kutjupangka maama ngayuku walytja nyinanytjala palumpa yuṉṯalpara yunytjuwiya nyinaku. Ngurra kutjupangka yuṉṯalpa ngayuku walytja nyinanytjala, palumpa maama yunytjuwiyara nyinaku. Ngunyarri ulkumanu ngayuku walytja nyinanytjala palumpa ngunyarri yukarrara yunytjuwiya nyinaku. ");
INSERT INTO piu2006_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Yuwa. Ngurra kutju ngurrara tjuṯaya yaṉangu walytjaku yunytjuwiya nyinaku, paluru ngayuku walytja nyinanytjala. ");
INSERT INTO piu2006_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Yaṉangu ngayuku walytja nyinarra ngayuku kutu tjukarurru nyinanytjaku, wiya ngayuku yunytjuwiya tjuṯaku wangka kulira nyinanytjaku. Wiya katja tjinguru yuṉṯalpangku yalatji kulintjaku, ‘Paapa maama Yiitjuku wiyapula walytja nyinanyi, yunytjuwiyapula nyinanyi. Paluru kutjarraṉi panypurangkutjipingka ngayulu wiya kuwarri Yiitjuku walytja nyinaku, tjinguru ngula ngayulu palumpa walytja nyinaku.’ Yaṉangu yalatji nyinarra wiya ngayuku walytja nyinaku. Wiya yaṉangungku yalatji kulintjaku, ‘Katja yuṉṯalpaṯarra wiya Yiitjuku yunytju nyinanyi, yunytjuwiyapula nyinanyi. Paluru kutjarraṉi panypurangkutjipingka ngayulu wiya kuwarri Yiitjuku walytja nyinaku, tjinguru ngula ngayulu palumpa walytja nyinaku.’ Yaṉangungku yalatji palunya kulira wiya ngayuku walytja nyinaku. ");
INSERT INTO piu2006_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ngayuku walytja kutu ngayuku yunytjurringkula tjukarurru nyinanytjaku, kuya tjuṯangkuya panypurangkula mirri punganyingka. Tjinguru kutjupa tjuṯangkuya watiyangka waralytjunkula iluntananyingka, wiya nguḻurringkula ngayunya wantinytjaku, kutu ngayuku tjukarurru nyinanytjaku. ");
INSERT INTO piu2006_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Tjinguru kuya tjuṯangku mirri pungkutjipingka, ngayuku walytjangku nguḻurringkula ngayunya wiyalpi kulilku. Yaṉangu paluru wiya kana kutu nyinaku ngayuku ngurrangka, wiya. Tjinguru kuya tjuṯangku mirri pungkukitjangku watjantjala, ngayuku walytja kutjupangku kulira wiya nguḻurrinytjaku, mirriya pungkukitjangku watjantjala. Paluru kana nyinakitjangku kulintjawiya, tjukarurru ngayuku kutu nyinanytjaku. Yalatji tjukarurru nyinanytjala palulanguru kuya tjuṯangku iluntanku. Palulanguru paluru ngayuku ngurrangka kana kutu nyinaku. ");
INSERT INTO piu2006_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ngayulu nyurrangarrinya wantirriyalku ngayuku wangka tjakultjurinkunytjaku. Tjinguru yaṉangu yunyparriku ngayuku wangka tjakultjunkupayiku. Yalatjira yunyparringkula ngayukuṯarra paluru yunyparriku. Tjinguru yaṉangu ngayuku yunyparringkula Katutjakuṯarra paluru yunyparriku. Walytjalpilimpatju paluru nyinaku. ");
INSERT INTO piu2006_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Katutjaku wangka watjalpayi ngalya yananyingka yaṉangu yunyparriku, palumpa wangka kulilkitja. Ngula Katutjaku wangka watjalpayi palunya yaṉangu palunyaṯarra Katutjalu kuutawutjungka waḻkulku, kanapula nyinaku. Wati tjukarurru nyinapayinya ngalya yananyingka yaṉangu yunyparriku, palumpa wangka kulilkitja. Ngula tjukarurru nyinapayi palunya yaṉangu palunyaṯarra Katutjalu kuutawutjungka waḻkulku, kanapula nyinaku. ");
INSERT INTO piu2006_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Wangka ngaatjanyaya kulila! Tjinguru yaṉangu kutjupangkunta yunyparringkula kapi yungku, nyuntu ngayuku walytja nyinanytjala, Katutjalu yaṉangu palunya ngula ngaparrtjingku yaṉṯayaṉṯalku.” ");
INSERT INTO piu2006_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yalatji palumpa kutunguḻu tuwalpala tjananya wangka panyapa Yiitjulu nintiṉu. Palulanguru Yiitjunya palumpa kutunguḻu tjuṯaṯarra tawunu tjuṯawana yanu, palunya ngurrara tjuṯa tjananya nintilkitja. ");
INSERT INTO piu2006_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","3","Palulanguru tjiilangka nyinarra Tjaanalu tjakulpa kuliṉu, Yiitju Kurayitjalu yaṉangu tjuṯangka nintira palyarinangitjangka. Tjaanalu pulanya palumpa walytja kutjarra yaḻṯirra iyaṉu mayutju Yiitjulakutu yankula yalatji wangkanytjakurapula, “Tjaanalulinyatju ngalya wantirriyaṉu. Palurulinyatju watjalpayi mayutju Kurayitjanya ngalya yankunytjaku. Nyuntu tjinguru Kurayitjanya?, Katutjalu watjara wantirriyaṉutja. Tjinguru paluru ngula ngalya yankuku?” Paluru kutjarrapula yankula Yiitjulakutu wangka panyapa palula tjapiṉu. ");
INSERT INTO piu2006_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yiitjulu pulanya watjaṉu yalatji, “Tjaanalakutupula yankula watjala!, nyupalipulan kuwarri nyakula kuliṉutjangku. Yalatjipula yankula watjala! ");
INSERT INTO piu2006_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Pampa tjuṯangkuya kurungkulpi nyanganyi. Nyumpu tjuṯaya tjunta taayitilpiya yulytjayinanyi. Pangki pikatjarra tjuṯaya pangki palyalpiya yulytjayinanyi. Pinatjarra tjuṯangkuya pina alytjurangkulpiya kuliṉi. Mirri ngarringutja tjuṯaya kanalpi nyinanyi. Maralpa tjuṯangkuya tjakulpa palya kuliṉi.” ");
INSERT INTO piu2006_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Yiitjulu pulanya piyuku watjaṉu, “Nyupali yankula Tjaananya yalatji watjala!, ‘Ngayuluṉa yaṉangu tjuṯa palyalpayi Katutjakuṉu ngangkaritjarrangku. Tjaana, nyuntu tjukarurru kutu kulintjaku, ngayulu Katutjakuṉu, ngangkari tiṉatjarra Kurayitjanya nyinanyingka.’” ");
INSERT INTO piu2006_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","9","Palulanguru Tjaanaku kutunguḻu kutjarrapula yanutjangka ngaṉṯi tjananya, Yiitjulu yaṉangu tjuṯa nintiṉingi yalatji, “Tjaananya paluru ngurra kapiwiyawana nyinapayi. Yirriṯi nyurrangarri waṉma yankupayi, palunya nyakula kulilkitja. Wiyanyurra waṉma yankupayi, wati mungutja kulilkitja, Katutjaku wangka watjalpayi kulilkitjanyurra yankupayi. Wiyanyurra waṉma yankupayi, yaṉangu mantarra palyatjarra nyakukitja. Tjaanaku wangka kulilkitjanyurra ankupayi. Mantarra palyatjarra mayutju tiṉaku waaḻangka nyinapayi, kanya Tjaananya ngurra palulawana wiya nyinapayi mantarra palyatjarra. Yuwa, Katutjaku wangka watjalpayi kulilkitja nyurrangarri waṉma yankupayi. Katutjaku wangka watjalpayi palyalingku Tjaananya nyinanyi. Paluru wirriḻi nyinanyi, Katutjaku wangka watjalpayi kutjupa tjuṯangka. ");
INSERT INTO piu2006_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yirriṯi nyinapayingku wakaṉu, Tjaananya ngula utirringkula tiṉarringkula nyinanytjaku. Yirriṯi yalatjingku wakaṉu Katutjakuṉu wangka, ‘Ngayuluṉa wati kutju tjakultjunkupayinyaṉa yurrunpa paṉakutu wantirriyalku. Palunyatjanu ngayulu mayutju tiṉa kutjupa wantirriyalku, palula ngaṉṯi. Tjakultjunkupayi palunya ngayulu iyalku yankula tjananya yurrunpa nintintjaku, tjukarurru paṯara palumpa nyinanytjaku.’” ");
INSERT INTO piu2006_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Yiitjulu tjananya yaṉangu tjuṯa piyuku watjaṉu, “Kulilaya! Yaṉangu kutjupa tjuṯangka wirriḻi Tjaananya papatatjimilalpayi paluru nyinanyi. Wangka kutjupaya kulila! Katutjanya Tjaanaku yunypa nyinangu. Paluru kutjupa tjuṯakuṯarra yunypa nyinanyi, palumpa walytja tjuṯaku. Ngayuku wangka kulilpayi tjuṯakuṯarra Katutjanya yunypalingku nyinaku. Paluru tjananya ngulytjura yaṉṯayaṉṯalku. ");
INSERT INTO piu2006_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Tjaanalu tjananya yaṉangu tjuṯa nintilpayi. Palulanguru ngayuluṉa kuwarrilpi nyurrangarrinya Katutjaku wangka nintilpayi, wangka palya yalatji. Katutjalu yaṉangu tjuṯa ngulytjura yaṉṯayaṉṯaṉi. Yaṉangu kutjupa tjuṯa puntura yunytjurringanyi Katutjaku walytja tjuṯawana tjungu nyinakitja. ");
INSERT INTO piu2006_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Tjaanalu tjananya yaṉangu tjuṯa nintintjala yurrunpa Katutjaku wangka watjalpayi tjuṯangku Muutjaluṯarra wakaṉu yalatji, ‘Ngula Kurayitjalu yaṉangu tjuṯa tjananya yaṉṯayaṉṯara kanyilku.’ ");
INSERT INTO piu2006_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Kuliṉinyurra Katutjaku wangka watjalpayi Yilaatjanya nguwanpa yutirringkula yaṉangu tjuṯa watjalku yalatji, ‘Kurayitjanya kuwarri mantakutu ngalyananyi.’ Yalatjinyurra kulintjaku Tjaananya Yilaatjanya nguwanpa ngalya yankula yaṉangu tjuṯa tjakultjunkupayi, ‘Kurayitjanyakunyu kuwarri ngalya yananyi.’” ");
INSERT INTO piu2006_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Piyuku tjananya Yiitjulu watjaṉu, “Wangka palunya nyurrangarri purinypa kulira tjukarurru nyinanytjaku.” ");
INSERT INTO piu2006_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Yiitjulu tjananya yaṉangu tjuṯangka piyuku watjaṉu, “Yaṉangu tjuṯa kuwarri nyinanyi. Nyaa nguwanpaya nyinanyi? Yalatji nguwanpaya nyinanyi. Pipirri tjuṯaya ngurrangka ngururrpa yinkangarapayi nguwanpa. Pipirri tjuṯangku tjananya pipirri kutjupa tjuṯangka watjalku yalatji, ");
INSERT INTO piu2006_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Nganaṉatju kiitawu wangkatjingantjala nyurrampa, wiyanyurra taanytjirrikitja kulira ngalya yanu. Nganaṉatju yulanyingka, wiyanyurra kulira ngalya yanu, tjungu yulakitja. Nganaṉanya nyurrangarri kulira wantipayi.’ ");
INSERT INTO piu2006_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Tjaanalu tjananya kapingka papatatjimilalpayi, paluru waamaku ngurrpa nyinangi. Paluru mangarri wantipayi ngalkuwiyangku Katutjanya tjapilkitjangku. Tjaanaku wangkanyurra kulira wantipayi. Yalatjinyurra wiyawanangku watjalpayi, ‘Tjaananya kuya, mamutjarra.’ ");
INSERT INTO piu2006_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ngayuluṉa yaṉanguku katja nyinanyi, yaṉangu kutjupa tjuṯa nguwanpa ngayulu ngalkura tjikiṉi palya. Yalatji wiyawanangkunyurra watjalpayi, ‘Yiitjunya kuya nyinarra, mangarriku kutju kulira ngalkupayi. Waama kutju tjikira turaangkarripayi.’ Yalatjinyurra ngayunya kulira panypurangkupayi. Ngayulu nyinanytjala nyakulanyurra watjalpayi, ‘Yiitjunya kuya, yaṉangu kuya palyalpayi tjuṯaku tjanampa walytja nyinanyi, kamantaku mani mantjilpayi tjuṯakuṯarra.’ Yuwa, kuya palyalpayi tjuṯangku, kamantaku mani mantjilpayi tjuṯangkuṯarraṉi kulira yunyparringkupayi, Katutjalu tjananya nintiṉu ngayuku ninti tjana nyinanytjaku, kanya nyurrangarri ngayukuṉu wangka kulira wantinyi, yilta. Nyurrangarri ngayuku nintiwiya nyinanyi.” ");
INSERT INTO piu2006_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Manta Kaliliyila Yiitjulu tawunu tjuṯawana yankula yaṉangu maṉkurrpa nguwanpa palyara kutjupa tjuṯa tjananya puṯu nintilpayi. Yaṉangu tjuṯangku palumpa wangka kulira wantinytjala paluru tjananya yalatji panypurangangi. ");
INSERT INTO piu2006_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Katutjalu tjananya ngula payira iyalku Kuratjinanya anta Piitjatanya ngurrara tjuṯa ngayuku wangkaya kulira wantipayi tjuṯa. Ngayuluṉa Kuratjinanya anta Piitjatanya ngurrara miiṉṯa tjuṯa palyalpayi. Tjana ngayuku wangka kulinmara, ngayuku walytja tjuṯaya nyinamara. Yaṉangu tjuṯangkuya watjalpayi, Taayanya anta Tjayitananya ngurrara tjuṯaya kuya nyinanyi, Katutjakuya ngurrpa nyinanyi. Wiya tjanala kutjupa tjuṯangku Katutjaku wangka tjakultjurinkupayi, wiya. Ngayuluṯarra Yiitjulu tjanala wiya yankula nyinarra nintilpayi, Tjuwuwiyaya nyinanyingka. Tjinguru ngayulu tjanalakutu yankula tjakultjurinamara. Ngayulu tjanala tjakultjunkunytjala paluru tjana ngayuku wangka kulira ngayuku walytja tjuṯalpi nyinamara. Tjuṉpangkuyanku nyapara nyinamara yuṉpa, mara kutjarra, anta tjuntawana. Mantarra walytja yarrara tjana wati tjuṯa tjuutjatjarra nyinamara, kanya kungka tjuṯa kaatatjarra nyinamara. Yalatji nyinapayi tjuṯa yaṉangu tjuṯangku nyakula yalatji kulinmara, ‘Yilta pala tjuṯangku kuya palyalpayingku wantirra Katutjaku tjukarurrulpiya nyinanyi.’ ");
INSERT INTO piu2006_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ngula Kuratjinanya anta Piitjatanya ngurrara tjuṯa tjananya Katutjalu kuutawutjungka puntura tjananya kuru watjalku ngayuku wangkaya kulira wantingutjangka. Taayanya anta Tjayitananya ngurrara tjuṯa ngayuku wangkaku ngurrpa nyinanyingka, Katutjalu tjananya ngula wiya puntura kuru watjalku. ");
INSERT INTO piu2006_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kapaniyamanya ngurrara tjuṯangkuṯarraya kuliṉiya, ‘Nganaṉa yaṉangu palya tjuṯa nyinanyi, kutjupa ngurrara tjuṯaya mungutja.’ Kapaniyamanya ngurrara tjuṯangku ngayuku wangka kulira wantipayi. Katutjalu tjananya ngula payira iyalku ngurra kuyakutu. Yaṉangu tjuṯangkuya yalatji kuliṉi, ‘Tjutumanya ngurrara tjuṯa tjananya Katutjalu yirriṯi mirri pungu, kuyaya palyara nyinapayi.’” Yiitjulu tjananya piyuku watjaṉu, “Tjutumanya ngurrara tjuṯaya ngurrpa nyinangu, Katutjalu tjanampa ngangkari puntutjarrangku wiya palyalpayi. Tjinguru paluru tjanampa ngangkari puntutjarrangku palyantjala tjana palumpa wangka kulira tjukarurru nyinamara. Tjana tjukarurru nyinanyingka Katutjalu wiya tjananya pungamara. Tawunu tjanampa kutu ngarala kuwarrilpi palya ngaramara. ");
INSERT INTO piu2006_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Yuwa, Kapaniyamanya ngurrara tjuṯa tjananya Katutjalu kuutawutjungka puntura kuru watjalku, tjana ngayuku wangka kulira wantingutjangka. Tjutumanya ngurrara tjuṯa tjananya paluru wiya puntura kuru watjalku.” ");
INSERT INTO piu2006_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","26","Palulanguru Yiitjunya yunyparringkula palumpa paapa Katutjanya waḻkuṉu yalatji, “Paapa, nyuntu mayutju tiṉa nyinanyi manta ngurrara tjuṯaku, ilkari ngurrara tjuṯakuṯarra. Yaṉangu tjuṯangku ngayuku walytja tjuṯa panypurangkupayi, ‘Wiyanyurra kuula tiṉangka nyinarra nintirringkupayi, ngurrpanyurra nyinanyi.’ Paapa, ngayuluṉanta waḻkuṉi, nyuntu tjananya nintilpayi ngayuku wangka palya. Wangka palumpa yaṉangu kutjupa tjuṯa, kuula tiṉa ngurrara tjuṯaṯarra ngurrpa nyinanyi. Paapa, nyuntu kuulaku ngurrpa tjuṯa tjananya yunypangku nintilpayi. ");
INSERT INTO piu2006_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ngayuku paapakuṉu wangkaṉa nintilpayi, paapangku yurrunpa watjaṉutjangka. Yaṉangu tjuṯanyurra ngayuku ngurrpa nguwanpa nyinanyi, Katutjaku katjaku. Ngayuku paapa walytja kutju ngayuku ninti nyinanyi, walytjararra ngalitju nyinanyi. Yaṉangu tjuṯanyurra paapa Katutjaku ngurrpa nguwanpa nyinanyi, ngayulu walytja kutjuṉara ninti nyinanyi. Ngayulu kuliṉi yaṉangu kutjupa tjuṯa nintilkitjangku, tjana paapa Katutjaku walytjalpi nyinanytjaku, ngayunya nguwanpa. ");
INSERT INTO piu2006_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","30","“Tjaampalanyurra Muutjaku luwuwana nyinarra puṯu kuliṉi Katutjaku kalypa nyinakitja. Paratji tjuṯangku luwu kutjupa tjuṯa palyalpayi nyurrangarri luwu palula tjanalawanaṯarra tjukarurru nyinanytjaku. Luwu palula tjanalawananyurra puṯu tjukarurru nyinarra purrkarringanyi. Kala, ngayulu nyurrangarrinya nintilku wangka kutjupawana nyinanytjaku, ngayuku wangkawana. Paluru tjana nyurrangarrinya nintilkitjangku payilpayi tjanampaṉu wangkawana nyinawiyangka. Ngayulu purinypangku nyurrangarrinya nintilku. Ngayuku wangkanyurra kulira palyalpi nyinaku purrkarringkula watjilpawiya. Katutjakunyurra yilta kalypalpi nyinaku.” ");
INSERT INTO piu2006_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Palulanguru Yiitjunya, palumpa kutunguḻu tjuṯaṯarra, kaanawana yanangi, tjiṉṯu Tjarritiyi ngaranytjala. Kaana panyapawana mangarri wiita ngarala waṉingi. Palumpa kutunguḻu tjuṯangkuya kaanawana yankula paḻtjatjirratjarringkula wiita yantara ngalkurinangi. ");
INSERT INTO piu2006_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nyakula tjananya Paratji tjuṯangku Yiitjunyaṯarra kuru watjaṉu yalatji, “Nyawa tjananya!, nyuntupa kutunguḻu tjuṯangkuya wiita yantara ngalkuṉingka. Luwulampa ngaranyi, wiya Tjarritiyingka wiita yantara ngalkunytjaku. Nganampa luwu yalatji ngaranyi yaṉangungku wiita yantara ngalkula yalatji waarrka palyaṉi. Yalatji waarrkarringkula nganampa luwu kilytjuntananyi.” Muutjaku luwu kulira Tjarritiyingka Tjuwu tjuṯaya waarrkawiya kunpu nyinapayi. Wiita tjukutjuku yantaṉingkaya watjalpayi, “Wanti!, waarrkawiya nyinanytjaku!, Tjarritiyi ngaranyingka.” ");
INSERT INTO piu2006_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yiitjulu tjananya watjaṉu, “Riitarrimaranyurra, mayutju Tapitalungarriya yirriṯi paḻtjatjirratjarringkula ngalkuṉingi. ");
INSERT INTO piu2006_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Tapita paluru tjaatji tiṉangka tjarrparra mangarri puriiti tjunkula wantingutja ngalkuṉu. Ngalkura palumpa walytja tjuṯaku tjanampa yungu. Mangarri palunya Katutjaku yungutja, tjawirrilyi, tuḻkuku mayutju tjuṯangku kutju ngalkupayi, luwu tjanampa yalatji ngarangu. ");
INSERT INTO piu2006_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Muutjaku luwu kutjupa nyurrangarri riitarringkula kulinmara yalatji. Tuḻkuku mayutju tjuṯangkuya kutu Tjarritiyingka waarrkarringkupayi tjawirrilyi pungkula, nganampa tjaatji tiṉangka. Mayutju tjuṯangku, Katutjaluṯarra wiya tjananya kuru watjalpayi Tjarritiyingka tjana waarrkarrinytjala. ");
INSERT INTO piu2006_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","7","Yalatji nyurrangarri kuliṉi, ‘Nganaṉa tjaatji tiṉa palumpa yunyparringanyi Katutjalu nganaṉanya yungutja.’ Wiyanyurra tjaatji palumpa kutju yunyparrinytjaku, mayutju kutjupakunyurra yunyparrinytjaku. Wangka ngaatjanyaṯarra Katutjakuṉuṯarra nyurrangarri kulintjaku. ‘Ngayulu nyurrangarrinya watjaṉu tjaatji tiṉakutu kuka tjawirrilyi katirra ngayuku tjunkunytjaku. Kuka yalatji katirra tjunkulanyurra yankula yaṉangu tjuṯaku tuunlayiki nyinanyi. Wiya tjanampa nyurrangarri tuunlayiki nyinanytjaku, aḻṯururringkula tjanampa nyurrangarri palya nyinanytjaku.’ Yalatjinyurra Katutjaku wangka kulira wantinyi. Wiya tjanampa nyurrangarri ngayuku kutunguḻu tjuṯaku aḻṯurunytju nyinanyi, wiya. Nyurrangarri tjananya wantimara, palyaya yantara ngalkuntjaku anymangku. ");
INSERT INTO piu2006_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ngayuluṉa yaṉanguku katja, yaṉangu tjuṯaku mayutju tiṉa ngayulu nyinanyi. Ngayulu watjaṉi palyaya ngayuku kutunguḻu tjuṯangku Tjarritiyingka mangarri yantara ngalkuntjaku.” ");
INSERT INTO piu2006_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Palulanguru Yiitjunyangarriya maḻaku yankula Tjuwuku tjaatji kutjupangka tjarrpangu. ");
INSERT INTO piu2006_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Tjaatji palula wati mara parralayitji nyinangi. Paratji tjuṯangku, kuliṉingi Yiitjunya panypurangkukitjangku, “Tjinguru wati ngaatjanya mara palyalku kuwarri Tjarritiyingka. Yalatji palyara luwulampa kilytjuntanku.” Yalatji kulira tjana Yiitjunya tjapiṉu, “Yaalytji nyuntu kuliṉi? Tjarritiyingka tjinguru ngangkaritjarrangku miiṉṯa palyantjaku, tjinguru wiya? Yalatji palyara tjinguru ngangkaritjarrangku nganampa luwu kilytjuntanku, tjinguru wiya?” ");
INSERT INTO piu2006_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","12","Yiitjulu tjananya watjaṉu, “Tjinguru nyuntu tjiipi kutju kanyilku. Tjarritiyingka tjinguru tjiipi paluru ngaṯingka tjarrpanytjala, nyurrangarri aḻṯururringkula walatjunkula wantirriyalku. Yalatji tjiipiku aḻṯururringkula wiyala luwu kilytjuntananyi. Palunya nguwanpa palya parralayitji palumpa ngayulu aḻṯururringkula Tjarritiyingka palunya kuwarri palyalku. Katutjalu kuliṉi tjiipi tjuṯa mungutja nguwanpa nyinanyi. Paluru kuliṉi yaṉangu palumpa walytja tjuṯaya nyinanyi maṯupurra. Nyurrangarri parralayitji palumpa Katutjaku walytja maṯupurraku aḻṯururringkula nyinamara.” ");
INSERT INTO piu2006_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Wati mara parralayitji palunyalpi nyakula paluru watjaṉu, “Mara ngalya katurriwa!” Katurringkula mara palumpa palyarringu. ");
INSERT INTO piu2006_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Tjarritiyingka palyaṉutjangka paluru tjana Paratji tjuṯa pikarringkula yankula tjungurringu, mayutju kutjupa tjuṯangka. Tjungurrirra Yiitjunya mirri pungkukitjaya wangkangu. ");
INSERT INTO piu2006_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yalatji tjana tjungurringkula mirri pungkukitjangku watjaṉutjangka Yiitjulu kulira ngurra kutjupakutu tjananya waṉma katingu, palumpa kutunguḻu tjuṯa. Yaṉangu tjuṯalingkungku palunya wanara tjungurringkupayi. Yiitjulu tjananya miiṉṯa tjuṯa palyarinkupayi. ");
INSERT INTO piu2006_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Palyara tjananya paluru watjalpayi, “Wiya nyurrangarri yaṉangu kutjupa tjuṯangka tjakultjunkunytjaku, ngayulu nyurrangarrinya palyaṉutjangka. Ngayulu Katutjaku waarrkana, tjana wiya ngayunya waḻkuntjaku.” ");
INSERT INTO piu2006_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Paluru yalatji wiya walytjangku waḻkulpayi. Yalatji wati Yaatjayalu yirriṯi Katutjaku wangka watjaṉu. Yiitjulu panyapa watjantjala wangka palunya iltarringu. Yalatji Yaatjayalu Katutjaku wangka watjalpayingku watjaṉu, ");
INSERT INTO piu2006_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ngayulu watjaṉu ngaatja ngayuku waarrkana nyinanytjaku. Ngayulu yunytjurringanyi ngaaku. Ngaakuṉara yilta yunypa nyinanyi. Ngayulu palula ngayuku kurrunpa tjarrpatjunku, paluru yaṉangu Tjuwuwiya tjuṯangkaṯarra tjananya ngayuku wangka tjakultjunkunytjaku, kuliraya kana nyinanytjaku. ");
INSERT INTO piu2006_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Paluru wiya yunytjurriku yaṉangu tjuṯangku palunya waḻkuntjaku, purinypangku tjananya nintinmalpa. ");
INSERT INTO piu2006_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Paluru aṉangu maralpa tjuṯaku aḻṯururringkula palyara tjananya nintilku, nyakula wantinytjawiyangku. Paluru tjananya rapalku tjana tjukarurrulpi nyinanytjaku. ");
INSERT INTO piu2006_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Tjuwuwiya tjuṯangkuṯarraya palumpa wangka kulira yunypa paṯalku Katutjaku ngurrangka nyinakitja.” ");
INSERT INTO piu2006_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Kutjupa tjuṯangku wati paanga wangkawiya Yiitjulakutu katirra ngaratjunu. Wati paluru mamutjarra nyinangi. Yiitjulu mamu palunya payira wantirriyantjala wati paluru palyalpi wangkangi, paluru nyangangiṯarra. ");
INSERT INTO piu2006_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Yaṉangu tjuṯangkuya wati paluru wangkanytjala kulira yunyparringkula watjara waṉingu, “Kuwarri kutju nganaṉa nyangu ngangkari tiṉatjarrangku yalatji palyantjala. Tjinguru palatja Kurayitjanya, Tapitaku walytja ngaṉṯitja.” ");
INSERT INTO piu2006_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kanya Paratji tjuṯangkuya yalatji wiyawana watjaṉu, “Paluru mamu wantirriyalpayi mamuku mayutjukuṉu ngangkari tiṉatjarrangku.” ");
INSERT INTO piu2006_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","26","Paluru tjanaya yalatji kuliṉingitjangka Yiitjunya tjanampa ninti nyinangi. Ninti nyinarra tjananya yara yalatji watjaṉu, “Yaṉangu walytja tjuṯangkuyanku rawangku pungkula mirrintara yuwankarraya wiyarriku. Tjinguru kalypaya nyinarra kana kutu nyinaku. Yara palunya nguwanpa, kaakararrangkuyanku rawangku pungkula mirrintara yuwankarraya wiyarriku. Kalypaya nyinarra kana kutuya nyinaku. Yara palunya kutjarra nguwanpa walytja tjuṯangkuyanku pungkula mirrintankunytja nguwanpa, tjinguru mamu tjuṯangkuyanku pungkula mirrintanku, mamuku mayutju, mamu tjuṯaṯarra yuwankarra wiyarriku. Nyaaku nyurrangarri ngayunya wiyawanangku watjaṉu?, ngayulu mamu payira wantirriyaṉi, mamukuṉu ngangkaritjarrangku. Yalatji wiya. Mamukuṉu ngangkaritjarrangku wiya mamu walytjanya payira wanara wantirriyaṉi. Ngayulu wiya mamukuṉu ngangkaritjarra nyinanyi, wiya, Katutjakuṉu ngangkaritjarra ngayulu nyinanyi. ");
INSERT INTO piu2006_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Nyurrangarrimpa walytja tjuṯangkuya mamu payira wantirriyalpayi. Paluru tjana kuliṉi, ‘Nganaṉa Katutjakuṉu ngangkaritjarrangku mamu payira iyaṉi.’ Palunya tjananya nguwanpa ngayulu mamu payira iyaṉi Katutjakuṉu ngangkaritjarrangku. Paluru tjana tjukarurru kuliṉi Katutjakuṉu ngangkaritjarrangku nganaṉatju mamu payira iyaṉi. Wiyawanangku nyurrangarri kuliṉi.” ");
INSERT INTO piu2006_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Yiitjulu tjananya piyuku watjaṉu, “Ngayulu Katutjakuṉu ngangkaritjarrangku mamu payira wantirriyaṉingka nyurrangarri nyakula yalatji kulinmara, ‘Yilta, kuwarrilpi Katutjalu yaṉangu tjuṯa ngulytjura yaṉṯayaṉṯaṉi.’” ");
INSERT INTO piu2006_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Yara kutjupa Yiitjulu tjananya watjaṉu, “Wati tjalata tjilirratjarrangkunku palumpa yulytja tjuṯa kanyilku, wiya kutjupangku palumpa waaḻangka tjarrparra yulytja mantjilku, pungkutjipingka. Wati kutjupangku ngangkaritjarrangku, wati tjalata palunya kuyara tayimapira kutju, palumpa yulytja mulyaṯangku katiku.” Yara palunya Yiitjulu kampa kutjupa watjaṉu nintilkitjangku. Wati tjalata palunya nguwanpa, mamuku mayutju nyinanyi. Wati palunya ngangkaritjarra nguwanpa Yiitjunya ngangkaritjarra nyinanyi. Paluru mamu tjuṯa payira wantirriyaṉi, Katutjakuṉu ngangkari tiṉatjarrangku. ");
INSERT INTO piu2006_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Yiitjulu tjananya piyuku watjaṉu, “Tjinguru yaṉangungku yalatji ngayunya panypurangkuku, ‘Yiitjunya mamuku walytja nyinanyi.’ Panypurangkupayi palunya wiya paluru ngayuku walytja nyinanyi, wiya. Tjinguru yaṉangu kutjupa wiya yunytjurringanyi ngayuku waarrka palyalkitja, yaṉangu tjuṯa Katutjaku walytja nyinanytjaku wiya paluru yunytjurringanyi. Yaṉangu paluru yaṉangu tjuṯa kulilwiyangku wantinyi, tjana mamuku walytja tjuṯa kutu nyinanytjaku. ");
INSERT INTO piu2006_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","Wangka ngaatjanyaya kulila! Yaṉangungku kuya palyaṉutjangka, tjinguru Katutjanya panypurangutjangka, tjinguru ngayunya yaṉanguku katja panypurangutjangka, Katutjalu kuya palumpara waṉinyi. Katutjaku kurrunpa yaṉangungku panypurangutjangka Katutjalu wiyara kuya waṉinyi, kutu kuya palunyatjarra nyinarra wiyarriku. Kuya yalatji Katutjaku kurrunpa yaṉangungku panypurangutjangka Katutjalu kutu yitjipungamalpa, ngula kuutawutjungka wangkarra.” ");
INSERT INTO piu2006_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Yiitjulu tjananya yara kutjupa watjaṉu, “Watiya palya, mangarri palyatjarra ngaranyi. Watiya piḻṯi mangarri kuyatjarra ngaranyi. Watiya piḻṯingka wiya nganaṉa mangarri palya mantjiṉi. Tjinguru watingku yukiri wiima pakaṉutja nyakula puṯu kulilku, ‘Watiya nyaa ngaatjanya?’ Yukiri palunya tiṉarringkula mangarritjarra ngaranytjala paluru nyakula nintingkulpi kulilku, ‘Yuwa, ngaatjanya watiya palya mangarri palyatjarra.’ ");
INSERT INTO piu2006_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Yilta, kuya tjuṯanyurra nyinanyi, watiya piḻṯi mangarri kuyatjarra nguwanpa. Ngunytjinytju tjuṯanyurra nyinanyi. ");
INSERT INTO piu2006_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Yara palunya watiya palya nguwanpa, wati palyangku tjukarurru kulira yaṉangu kutjupakura tjukarurru palyalpayi. Watiya piḻṯi nguwanpa wati kutjupangku tjaalpangku kulira yaṉangu kutjupa wantirra wiya tjukarurrura palyalpayi. Yuwa, nyurrangarri ngunytjinytjungku kulira wangkanyi. Yaṉangu kutjupa tjuṯangku nyurrangarrimpa wangka kulira watjaṉi, ‘Yuwa, wati pala tjuṯangku ngunytjinytjungku kulira wangkapayi.’ ");
INSERT INTO piu2006_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Ngayulu nyurrangarrinya watjaṉi yalatji. Ngula kuutawutjungka Katutjalu yaṉangu tjuṯa tjapilku, ‘Mantangka nyuntu nyaaku ngunytji wangkapayi? Tjuṯangara ngunytji watjara tjakultjurraṉi!’ ");
INSERT INTO piu2006_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Nyurrangarrimpa wangka watjaṉutja kulira paluru watjalku palya tjuṯa kanyilkitjangku. Kuya tjuṯa paluru payira wantirriyalku warukutu.” ");
INSERT INTO piu2006_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Paratji tjuṯangku, Muutjaku wangka nintilpayi tjuṯangkuṯarra Yiitjunyaya yalatji watjaṉu, “Nintilpayi. Ngangkaritjarrangku nyuntu kutjupa kutjupa palyala!, nganaṉatju nyakunytjaku. Nyakulalatju tjinguru kulilku nyuntu Katutjakuṉu, tjinguru wiya.” ");
INSERT INTO piu2006_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yiitjulu tjananya watjaṉu yalatji, “Kutuṉinyurra tjapilpayi ngangkaritjarrangku kutjupa kutjupa palyantjaku, nyakulaṉinyurra Katutjakuṉu kulilkitjangku. Yaṉangu tjuṯanyurra kuya nyinanyi Katutjanya kulintjawiya. Ngayulu wiya nyurrangarrimpa ngangkaritjarrangku kutjupa kutjupa palyalku. Yalatji kutju ngayulu nyurrangarrinya watjalku yara Tjawunanyatjarra. Tjawuna paluru irriṯi Katutjaku wangka watjalpayi nyinapayi. ");
INSERT INTO piu2006_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yirriṯi palunya piitji tiṉangku kuuḻtjunkula kanyiṉingi munga kutjarra. Tjiṉṯu kutjupangka piitji paluru yulkapatjunulpi kana kutu. Panyapa kulira tawunu Ninapanya ngurrara tjuṯangkuya kuliṉu, ‘Yilta, Katutjalu Tjawunanya kanaṉu.’ Palunya nguwanpa ngayulu, yaṉanguku katja, munga kutjarra mirri ngarrirra kanarrinytja nyakula nyurrangarri kulilku, ‘Yilta, Katutjalu palunya kanaṉu.’ ");
INSERT INTO piu2006_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Tjawuna paluru tjananya Katutjaku wangka Ninapanya ngurrara tjuṯangka nintiṉingi, palulanguru tjana kuya palyantjawiyalpiya tjukarurru nyinangi. Kanya ngayulu Tjawunala wirriḻi nyinanyi. Ngayulu Katutjakuṉu wangka nyurrangarrinya nintintjala, kuliranyurra wantipayi. Palulanguru Katutjalu yaṉangu yuwankarra ngula kuutamilalku. Ngurra palula Ninapanya ngurrara tjuṯangku nyurrangarrinya kuru watjalku, ngayuku wangka kulira wantingutjangka. ");
INSERT INTO piu2006_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kulilaya!, yara Tjiipanya ngurraratjarraṯarra. Minyma mayutju tiṉa, manta Tjiipalanguru waṉma yanu mayutju Tjalamunalakutu Katutjaku wangka kulilkitja. Mayutju Tjalamunanya ninti puntu nyinangi, kanya ngayulu mayutju Tjalamunangka wirriḻi nyinanyi, ngayulu Katutjakuṉu wangka tjakultjunkupayi. Wangka palunyanyurra kulira wantipayi. Katutjalu ngula yaṉangu yuwankarra kuutamilalku. Ngurra palula minyma paluru Tjiipanya ngurrarangku kuru watjalku nyurrangarrinya, Katutjaku wangka kulira wantipayi tjuṯa.” ");
INSERT INTO piu2006_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Yiitjulu tjananya yara piyuku watjaṉu, nintilkitjangku, “Mamu yalatji nyinanyi. Mamu paluru yaṉangungka tjungu nyinarra wantikatirra ngurra kutjupawana yulytjayinamalpa, wati kurrunpa kutjupangka nyinakitja. ");
INSERT INTO piu2006_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Yaṉangu kutjupaku puṯu ngurririnkula kulilku, ‘Yaṉangu walytjakutuṉa maḻaku yankuku, palumpaṉu kurrunpa walytjangka nyinakitja.’ Yankula mamu paluru yaṉangu palunya nyakuku kurrunpa walytjatjarra palya nyinanyingka, Katutjaku kurrunpatjarra wiya. ");
INSERT INTO piu2006_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Mamu paluru, mamu kuya tjapanpala yaḻṯirra tjananya katiku yaṉangu palulakutu, kuyaraya tjarrparra nyinanytjaku. Yaṉangu paluru yurrunpa mamu kutjutjarra nyinangu, palunyatjanu mamu tjuṯatjarralpi nyinaku, kuyalingkulpi, miiṉṯa. Palunya nguwanpa kuwarri yaṉangu tjuṯa kuya nyinapayi tjuṯa, mamu tjuṯatjarralpi nyinaku.” Yara palunya wangkarra yalatji Yiitjulu tjananya kampa kutjupa watjaṉu. Mamu payira wantirriyaṉutjangka yaṉangungku Yiitjuku wangka kulira palumpa walytjarrinytjaku. Walytjarrinytjawiyangka tjinguru mamuku walytja paluru kutulpi nyinamalpa. ");
INSERT INTO piu2006_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","47","Yaṉangu tjuṯangka panyapa wangkanyingka, Yiitjuku maama, maḻanypa tjuṯaṯarra yankula waaḻangka yuriltaya ngarangi. Wati kutjuya iyaṉu, Yiitjunya yankula yaḻṯinytjaku. Wati paluru maa yankula yila ngarangi yaṉangu tjuṯangku ngarala yangatjunanyingka. Kutjupa tjuṯangku kulira maa watjaṉu Yiitjunya yalatji, “Nyuntupa maama maḻanypa tjuṯaṯarra, ngaranyi yurilpangka. Yankula tjananya nyawa! Yaḻṯinyintaya.” ");
INSERT INTO piu2006_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Wangka palunya kulira Yiitjulu tjananya watjaṉu, “Ngayuku walytja tjuṯa yurilpangka ngaranyi, yilta ngayulu tjanampa walytja nyinanyi. Kutjupakuṯarra ngayulu walytja nyinanyi, Katutjaku.” ");
INSERT INTO piu2006_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","50","Yiitjulu tjananya palumpa kutunguḻu tjuṯakutu marangku nintira, yaṉangu tjuṯangkaṯarra tjananya watjaṉu, “Nyurrangarri wiya ngayuku walytja tjuṯa nyinanyi, tjana ngaranyi yurilpangka. Tjinguru nyurrangarri Katutjaku walytja tjuṯa nyinarra ngayuku walytja tjuṯaṯarranyurra nyinanyi. Kutjupa tjuṯanyurra ngayuku maama tjuṯa nguwanpa nyinanyi. Kutjupa tjuṯanyurra ngayuku maḻanypa tjuṯa nguwanpa nyinanyi. Alatjinyurra Katutjaku wangka kulira tjukarurru nyinarra ngayuku walytja tjuṯanyurra nyinaku. Katutjaku wangka kulira kutjupa tjuṯanyurra ngayuku kangkuru tjuṯa nguwanpa nyinaku. Katutjaku wangka kulira kutjupa tjuṯanyurra ngayuku kaaka tjuṯa nguwanpa nyinaku. Katutjaku wangka kulira kutjupa tjuṯanyurra ngayuku maama tjuṯa nguwanpa nyinaku.” ");
INSERT INTO piu2006_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Waaḻa palula tjananya nintira Yiitjunya pakara yankula yuru tjayiṯingka nyinangi. ");
INSERT INTO piu2006_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Yaṉangu tjuṯalingkuya tjungurringkula yutjura waṉinytjala, puutangkalpi paluru kaḻparra nyinangu, yaṉangu tjuṯa tjananya nintilkitja. Paluru tjana yuru tjayiṯingka ngarala waṉingi. ");
INSERT INTO piu2006_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Yiitjulu tjananya yara tjuṯa watjara nintiṉangi. Yara yalatjilpi tjananya paluru nintiṉangi, “Kulilaya! Kaana ngurrara kaanakutu yankuku tjiiṯa waṉinytjaku. ");
INSERT INTO piu2006_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Wati paluru tjiiṯa waṉinytjala tjiiṯa tjaampala yiwarrangka punkanmalpa. Tjiiṯa panyapa tjuṯa tjuḻpu tiṉangku ngalkura wiyanmalpa. ");
INSERT INTO piu2006_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","6","Tjiiṯa tjaampala patangaramalpa manta puḻitjarrakutu. Tjiiṯa panyapatjanu yukiri pakara wiyarrikulpi, puḻingku yangatjura kuyalku. Tjiṉṯungku kamparra piḻṯilku nguwanpa yukiri palunya wiyarriku. ");
INSERT INTO piu2006_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Tjiiṯa tjaampala tjilkalakutu punkara yukiri wiima pakara ngaraku. Tjilkala tjuṯangku yangatjura kuyantjala, mangarri yutitjarrinytjawiya ngaramalpa. ");
INSERT INTO piu2006_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Tjiiṯa tjaampala manta palyangka punkalku. Pakara mangarritjarralpi ngarala waṉiku. Manta palyangka ngarala waṉiku tjaampala mangarri wiimatjarra. Tjaampala mangarri tiṉatjarra. Tjaampala mangarri puntutjarra.” ");
INSERT INTO piu2006_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Piyuku tjananya Yiitjulu watjaṉu, “Yara palunya nyurrangarri purinypa kulira tjukarurru nyinanytjaku.” ");
INSERT INTO piu2006_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Yaṉangu paluru tjana ngurrakutu rayitpayiki yanu. Palunyatjanu palumpa kutunguḻu tjuṯangkulpi Yiitjunya tjapiṉu yalatji, “Nyaaku nyuntu yaṉangu tjuṯangka tjanala yara watjara nintilpayi?, wangka yuti tjukarurru watjantjawiyangku.” ");
INSERT INTO piu2006_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yiitjulu tjananya watjaṉu, “Katutjanya yunytjurrinyi nintinyurra nyinanytjaku palumpa wangkaku, yarrkatjunutjatjanuku. Kanya yaṉangu kutjupa tjuṯangkuya wiya wangka palunya yarrkatjunutja kulilpayi, yara kutjuya kulilpayi, wangka yarrkatjunutja palunya wiya. Katutjaku walytja tjuṯangkunyurra wangka yuti kulintjaku, paluru nyurranya ngulytjura yaṉṯayaṉṯantjaku. ");
INSERT INTO piu2006_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Yuwa, Katutjaku wangka nyurrangarri kulira nyinanytjala, yilta Katutjalu nyurrangarrinya wangka puntu kutjupa nintilku. Tjinguru yaṉangu kutjupa tjuṯangku wangka palunya kulira wantinytjala, Katutjalu tjananya kawaṉtjingalku, palulanguruya munupinalpi nyinaku Katutjaku wangkaku. ");
INSERT INTO piu2006_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Paluru tjana yara tjuṯa kutju kulira puṯu nintirringkupayi. Tjinguruya kulira Katutjakuya tjukarurru nyinamara, paluru tjanampa kuya waṉimara. ");
INSERT INTO piu2006_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Yaṉangu paluru tjana puṯu kulilpayitjarra Yaatjayalu yirriṯi wakaṉu, Katutjaku wangka. Wangka palunya kuwarri yiltarringu, puṯu kulilpayi tjuṯaya nyinanyi. Yaatjayalu watjaṉu yalatji, ‘Yilta, yaṉangu tjuṯangku Katutjaku wangka kulira puṯu kulilku. ");
INSERT INTO piu2006_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Paluru tjananya pina patilku, kulintjawiyalpiya nyinanytjaku, pina alytjurangkuya palumpa wangka kulira walytjarripayingkamarra. Paluru tjananya pina patintjawiyangka tjinguru tjana palumpa wangka kulira tjukarurru nyinaku. Tjana tjukarurru nyinanytjala Katutjalu tjanampa kuya waṉiku.’” ");
INSERT INTO piu2006_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Yiitjulu tjananya palumpa kutunguḻu tjuṯangka piyuku watjaṉu, “Palunya tjananya nguwanpa wiyanyurra nyinanyi. Pina alytjurangkunyurra Katutjaku wangka kulilpayi. Yalatji kuliranyurra yunypa nyinanyi. ");
INSERT INTO piu2006_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Yirriṯi nyinanytja tjuṯaya yunytjurringu Kurayitjanyaṉiya nyakula kulilkitja, Katutjaku wangka nintilpayi tjuṯa, Katutjaku tjukarurru nyinapayi tjuṯaṯarraya. Puṯuya yunytjurrirra nyinangi, Kurayitjanyaṉiya nyakula yunyparrikitja.” ");
INSERT INTO piu2006_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Yiitjulu tjananya piyuku watjaṉu, “Yara palunya kaana ngurraratjarra ngayulu nyurrangarrinya nintilku, wangka yutinyurra kulintjaku. Kulinmaya! ");
INSERT INTO piu2006_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Tjiiṯa yiwarrangka punkantjala tjuḻpu tiṉangku ngalkura wiyantja nguwanpa alatji. Ingkaṯalu Katutjaku wangka tjakultjunanyingka, yaṉangu tjuṯangku kuliṉi, mamuku mayutjungku tjuḻpu palunya tiṉa nguwanpangku tjaampala tjananya kawaṉtjingaṉi. Palulanguruya wangka palunya kulira wantinyi. Katutjalu tjananya wiya ngulytjura kanyiṉi. ");
INSERT INTO piu2006_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","Yaṉangu tjaampala nyinanyi tjiiṯa palunya puḻitjarrakutu punkantja nguwanpa. Ingkaṯalu nintintjala, Katutjaku wangkaya kulira yunyparringanyi. Palulanguru tjana wantiku, yaṉangu kutjupangku tjingapunganyingka, tjinguru kutjupangku Katutjaku yunytjuwiyangku pungkunytjala. Tjiṉṯungku kamparra piḻṯintankunytja yukiri wiyarringutja nguwanpa tjana Katutjaku walytjawiyalpiya nyinaku. ");
INSERT INTO piu2006_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Tjiiṯa tjilkalakutu punkantja nguwanpa, yaṉangu tjaampala nyinanyi. Ingkaṯalu nintintjala Katutjaku wangkaya yunypangku kulira, ngurrakutu yankula nyinaku. Katutjaku ngurrpa tjuṯangku tjananya tjingapunganyingka, mangarri tiṉaku mani tiṉaku walytjalpiya nyinaku, munupinarringkula. Yalatji Katutjaku ngurrpa tjuṯaku tjana ngulytjurringkula Katutjaku wangkalpiya wantiku. ");
INSERT INTO piu2006_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Tjiiṯa manta palyakutu punkantja nguwanpa, yaṉangu tjaampala nyinanyi. Katutjaku wangka yunypangku kulira tjana Katutjaku waarrka tjukarurru palyaṉi, Katutjaku wangkatjarraya nyinanyi. Tjana yukiri mangarritjarra nguwanpa nyinanyi. Yukiri tjaampala mangarri wiimatjarra ngarapayi nguwanpa, yaṉangu tjaampala Katutjaku wangka wiimatjarraya nyinanyi, palumpa waarrka wiimaya palyaṉi. Mangarri tiṉatjarra ngaranytja nguwanpa yaṉangu tjaampalaya Katutjaku wangka tiṉatjarra nyinanyi, palumpa waarrka tiṉaya palyaṉi. Mangarri puntu ngaranytja nguwanpa, yaṉangu tjaampalaya Katutjaku wangka puntutjarra nyinanyi, palumpa waarrka puntuya palyaṉi.” ");
INSERT INTO piu2006_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yara kutjupa Yiitjulu tjananya watjaṉu nintilkitjangku, “Katutjalu palumpa walytja tjuṯa ngulytjura mantangka kanyilku kuya tjuṯawana tjana nyinanytjala. Wangka yalatji yara ngaatja ngaranyi. Kaana ngurrarangku palumpa kaanangka tjiiṯa palya wiita waṉiyinamalpa. ");
INSERT INTO piu2006_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Yalatji waṉiyinkula ngurrakutu yankula anku ngarrinyingka palumpa tuunlayikingku kaana palulawanangku tjiiṯa tjilkala tjuṯa yarrkayarrkangku waṉiyinamalpa. ");
INSERT INTO piu2006_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ngula wiita paluru pakara ngarala mangarritjarrarriku. Tjilkalaṯarra pakara wiitawana tjungu ngarala waṉimalpa. ");
INSERT INTO piu2006_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Kaana ngurraraku waarrkana tjuṯangkuya tjilkala nyakula watjalku mayutju, ‘Kaanangka yaalytjiyaalytji tjilkala ngarala waṉinyi? Kaḻka wiita kutju nyuntu yirriṯi waṉiyinkupayi.’ ");
INSERT INTO piu2006_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Mayutju paluru waarrkana tjuṯa tjananya watjalku, ‘Ngayuku tuunlayikingku yarrkayarrkangku tjilkala waṉiyinkupayi.’ Waarrkana tjuṯangkuya palunya yalatji tjapilku, ‘Yankulalatju kaanawanangku tjilkala tjuṯa yurrkura waṉiyinamalpa?’ ");
INSERT INTO piu2006_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Mayutju paluru tjananya marrkulku, ‘Wiya, wanti!, yankulanyurra tjilkala yurrkura, watiya wiita yurrkultjipingkamarra. ");
INSERT INTO piu2006_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Wiita tjilkalaṯarra ngarala tiṉarrinytjakuya wanti! Wiita yuṉmirringanyingka kutjuya tjilkala yurrkulku. Ngayulu wiita muṯulpayi tjuṯa tjananya watjalku, “Tjilkala tjuṯa yurrunpaya yankula yurrkula! Warukutuya kapuṯura mantjira kati!, kutjantjaku. Ngaṉṯiya wiita muṯura kapuṯura mantjira kati!, ngayuku waaḻakutu, wiita ngarripayikutu.” ’” ");
INSERT INTO piu2006_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yiitjulu tjananya watjaṉu yalatji, “Katutjalu palumpa walytja tjuṯa ngulytjura kanyilku. Yurrunpa Katutjaku walytja maṉkurrpa nguwanpa ngurra kutjungka nyinanytjala paluru yaṉangu kutjupa tjuṯalpi ngulytjulku, tjuṯalingkulpi tjana nyinanytjaku. Yalatji tjana tjuṯarrinytja nguwanpa yara ngaatjanya ngaranyi. Watingku tjiiṯa yiṯaratjanu mantjira tjawara tjunkuku pakantjaku. Tjiiṯa palunya wiima ngarrinyi, kanya watiya kutjupa tjuṯangka tjiiṯa tiṉa ngarrinyi. ");
INSERT INTO piu2006_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Tjiiṯa wiimatjanu tjawara tjunutja pakara tiṉalpi ngaraku. Tjuḻpu tjuṯangkuya yankula pinytjunpa watiyangka palyalku. Palyaraya nyinaku yiṯara palula.” ");
INSERT INTO piu2006_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yara kutjupa Yiitjulu tjananya watjaṉu nintilkitjangku, “Katutjalu palumpa walytja tjuṯa ngulytjura kanyilku. Ngurra kutjungka Katutjalu yaṉangu tjuṯa purinypangku nintira ngulytjulku, maṉkurrpa nguwanpaya nyinaku. Paluru kutjupa tjuṯa tjananya ngulytjura kanyilku palumpa walytja tjuṯalingkulpiya nyinaku. Wangka yalatji nguwanpa yara ngaatjanya ngaranyi. Minymangku pulawu palyara kapuṯu kutjarra tjunku aapanangka yuṉmirrinytjala paluru mantjira tjunku. Mangarri palumpa kutjarraku yunyparringkula piyuku paluru kutjupa tjuṯalpi palyalku. Tjuṯangara rungkantjala mangarri kapuṯu tjuṯalingkulpiya ngarriku.” Yiitjulu yara palunya kutjarra watjaṉu, yalatji nintilkitjangku. Ngurra kutjungka yurrunpa Katutjaku walytja kutjarra nguwanpa nyinaku. Palunyatjanu Katutjalu yaṉangu kutjupa tjuṯalpi ngulytjura nyinatjunku. Palulanguru palumpa walytja tjuṯalingkulpiya nyinaku. ");
INSERT INTO piu2006_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yiitjulu yara palunya nguwanpa tjuṯa tjananya watjaṉingi, Katutjaku wangka nintilkitjangku. ");
INSERT INTO piu2006_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Yalatji tjanala yara watjara nintintjala Katutjaku wangka yiltarringu. Palumpa wangka watjalpayingku yirriṯi yalatji watjaṉu, “Ngayulu yara watjaraṉa tjananya nintilku. Wangka yirriṯitja ngayulu tjananya nintira yutilku, wangka yarrkatjunutjaṯarra. Manta ngaranytjawiyangka, wangka paluru yarrka ngarangu.” ");
INSERT INTO piu2006_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yaṉangu tjuṯa tjananya Yiitjulu nintira waaḻangka yankula tjarrpangu. Palumpa kutunguḻu tjuṯangku tjarrparra palunya watjaṉu, “Yara palunya, tjiiṯa tjilkala tjuṯa waṉinytjatjarra nintila!, wangka yutilatju kulintjaku.” ");
INSERT INTO piu2006_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yiitjulu tjananya watjaṉu, “Wati paluru kaanaku mayutju nguwanpa ngayulu yaṉanguku katja nyinanyi. ");
INSERT INTO piu2006_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","39","Kaḻka wiita tjuṯa nguwanpa Katutjaku walytja tjuṯa nyinanyi. Ngurra tjuṯawana, manta tjuṯawanaṯarra palumpa walytja tjuṯa nyinanyi, kaana palula tjiiṯa wiita tjuṯa ngarrinytja nguwanpa. Kaḻka tjilkala tjuṯa mamuku mayutjungku waṉipayi. Tjilkala paluru tjana palumpa waarrkana tjuṯa nyinanyi, kuya palyalpayi tjuṯa. Wiita muṯulpayi tjuṯa nguwanpa Katutjaku waarrkana ilkari ngurrara tjuṯangku ngula parra yankula palumpa walytja tjuṯa mantjira tjungulku. ");
INSERT INTO piu2006_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","42","Tjilkala tjuṯa yurrkura mantjira warukutu waṉinytja nguwanpa mamuku waarrkana tjuṯa ilkari ngurrara tjuṯangku mantjira warukutu waṉiku. Ngayulu mantakutu piyuku ngalyankula ilkari ngurrara tjuṯa wantirriyalku tjana parra yankula kuya palyalpayi tjuṯa mantjira warukutu katirra waṉinytjaku. Kuya palyantjaku tjingapungkupayi tjuṯaṯarra tjana mantjira warukutu waṉiku. Waru palula tjana mikintjarra yulamalpa. ");
INSERT INTO piu2006_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Yuḻṯa palula Katutjaku walytja tjukarurru nyinapayi tjuṯa, palyaya nyinamalpa palumpa ngurrangka. Paluru tjananya kutu yaṉṯayaṉṯanmalpa. Wangka palunya nyurrangarri purinypa kulira tjukarurru nyinanytjaku.” ");
INSERT INTO piu2006_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yara kutjupa tjananya Yiitjulu watjaṉu, nintilkitjangku, “Katutjalu yaṉangu tjuṯa ngulytjura kanyilku. Yaṉangu ngurrpangku Katutjaku wangka ngayunyatjarra kulira puntura yunytjurriku Katutjaku ngulytjulpi nyinakitja. Wangka palunya yara yalatji nguwanpa ngaranyi. Watingku manta kutjupawana yankula nyaku, mani tiṉa kutjupangku yirriṯi yarrkatjunutja. Nyakula paluru tjutura puntura yunytjurriku, mani tiṉa palumpa walytjangku kanyilkitjangku. Mani yalatji yirriṯi yarrkatjunkula wantingutja kutjupangku nyakula tjakultjunkunytjala, luwu tjanampa ngarangu, mantaku mayutjungku kutju mani palunya kanyintjaku. Wati paluru tjutura yunypa ngurrakutu piyuku yanku, mantaku mayutjungka tjakultjunkunytjawiya. Yankula ngurra palumpa yulytja yuwankarraṯarra tjalamilalku. Manitjarrangkulpi yankula manta palunya payimilalku, mani tiṉa mantangka tjutura wantingutja kanyilkitjangku.” ");
INSERT INTO piu2006_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Yiitjulu tjananya piyuku yara watjaṉu, “Katutjalu yaṉangu tjuṯa ngulytjura kanyilku. Yaṉangu ngurrpangku Katutjaku wangka ngayunyatjarra kulira puntura yunytjurriku Katutjaku ngulytjulpi nyinakitja. Wangka palunya yara yalatji nguwanpa ngaranyi. Wati puḻi ngurrarangku tjaapa tjuṯawana parra ngurririnku puḻi kuulta palyaku. ");
INSERT INTO piu2006_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Tjaapa ngurrarangku puḻi kuulta palyalingku kanyiṉingka paluru nyakuku. Nyakula paluru yankula yulytja yuwankarra tjalamilara mani mantjira payimilalku, puḻi kuulta palunya kanyilkitja puntura yunytjurringkula.” ");
INSERT INTO piu2006_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Yiitjulu tjananya yara kutjupa watjaṉu, “Katutjalu yaṉangu tjuṯa ngulytjura kanyilku. Paluru ngula tjananya watjalku palumpa walytja tjuṯa yaḻṯirra tjunguntjaku, kutu tjananya yaṉṯayaṉṯalkitjangku. Wangka yalatji nguwanpa yara ngaatja ngaranyi. Wati tjuṯangkuya niitingi yurungka waṉiku, piitji niitingitjarrangkuya mantjilkitjangku. Waṉinytjala piitji kutjupa kutjupa niitingi palula tjarrpa tjarrpaku. ");
INSERT INTO piu2006_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Piitji tjarrparra tjuṯarringanyingka, niitingingku tjungura tjananya katiku piitji kutjupa kutjupa, wati tjuṯangkuya yitarrinanyingka. Mantakutuya niitingi puulamilara yitarrirra katiku. Piitji palya tjuṯa mantjira tiitjingka tjunku. Piitji kuya tjuṯaya mantjira waṉiku. ");
INSERT INTO piu2006_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ngula yaṉangu tjuṯa kuutawutjungka ngaraku. Yuḻṯa palula yurrunpa, yara palunya nguwanpa ilkari ngurrara tjuṯangku tjananya tjukarurru nyinapayi tjuṯa ngalya yankula tjungulku, Katutjaku ngurrangka nyinanytjaku. Yaṉangu kuya palyalpayi tjuṯa tjungura, ");
INSERT INTO piu2006_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","katirra tjananya waru tiṉakutu waṉiku. Waru palula tjana mikintjarra ngaramalpa.” ");
INSERT INTO piu2006_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yiitjulu tjananya palumpa kutunguḻu tjuṯa tjapiṉu, “Nintingkumpanyurra kuliṉu?, yara panyapa tjuṯa?” Paluru tjana watjaṉu, “Yuwa.” ");
INSERT INTO piu2006_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Paluru piyuku tjananya watjaṉu, “Muutjaku luwuwana nyinarra yaṉangu ngayuku wangka kulira walytjarringkula yalatji nyinaku. Paluru Muutjaku luwuku nintirringkula ngayuku wangka kulira tjungulku ngayukulpi tjukarurru nyinanytjaku.” ");
INSERT INTO piu2006_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","54","Yara palunya tjuṯa tjananya paluru watjara, Yiitjunya palumpa kutunguḻu tjuṯaṯarra yarurrirra yanu Yiitjuku ngurrakutu. Ngurra palula paluru tiṉarringu. Ngurra palula Tjuwuku tjaatjingka Yiitjunya tjarrpangu. Tjarrparra tjananya nintiṉingi. Kulira tjana yunyparringkula wangkangu. “Ninti puntungkulanya nintiṉi. Paluru ngangkari puntutjarrangku palyalpayi. Nganalumpa palunya nintiṉu?” Yalatjiya puṯu kulira waṉingi. ");
INSERT INTO piu2006_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Tjaampalangku palumpa wangka kulira wantingu. Yalatjiya wangkarra waṉingu, “Ngaatjanya Katutjakuṉu wiya, Miiriku katja paluru nyinanyi. Paluru ngaangka yirriṯi waarrkarripayi, pukutju tjuṯa palyalpayi. Palumpa maḻanypa tjuṯala tjungu nyinanyi. Yini ngaa tjuṯaya tjana Tjayimitjanya, Tjutjupanya, Tjuutatjanya, Tjaamananyaṯarra. ");
INSERT INTO piu2006_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Palumpa maḻanypa kungka tjuṯa tjungula nyinanyi. Paluru wiya Katutjakuṉu.” ");
INSERT INTO piu2006_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Yalatjiya kulira Yiitjuku yunytjuwiya nyinangu. Palulanguru Yiitjulu tjananya watjaṉu, “Kutjupa ngurrara tjuṯa ngayuku yunyparripayi, ngayulu Katutjaku wangka nintintjala, Natjaritjanya ngurrara tjuṯanyurra ngayuku wiya yunyparringanyi, ngayuku walytja yilatja tjuṯaṯarra.” ");
INSERT INTO piu2006_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Natjaritjanya ngurrara tjuṯangkuya Yiitjunya Katutjakuṉu kulintjawiya. Palulanguru Yiitjulu puṯu kuliṉu yaṉangu tjuṯa palyalkitjangku, maṉkurrpa wiya kutju paluru palyaṉu. ");
INSERT INTO piu2006_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","2","Yaṉangu tjuṯangku nyakupayi Yiitjulu tjananya ngangkari tiṉangku palyaṉingka. Yaṉangu tjuṯangku yalatji tjakultjunkunytjala mayutju Yirutalu palumpa waarrkana tjuṯa yalatji watjaṉu, “Yilta Yiitjunya ngangkari tiṉatjarra nyinanyi. Paluru Tjaananya mirringuru pakaṉutja, ngangkari tiṉatjarra, Tjaananya ngangkari tiṉatjarra nyinangutja nguwanpa.” Yirutanya tjanampa mayutju nyinangi Kaliliyinya ngurrara tjuṯaku. ");
INSERT INTO piu2006_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Yirriṯi Tjaananya kana nyinanyingka Yirutalu Pilipaku miiṯa yini Yirutiyatjanya tjulyara kanyiṉingi. Pilipanya Yirutaku maḻanypa nyinangu. Tjaanalu rawangku Yirutanya marrkuṉingi yalatji, “Nyuntupa maḻanyku miiṯa wiyaranu kanyintjaku, wanti!” Yalatji marrkuṉutjangka minyma Yirutiyatjanyara Tjaanaku yunytjuwiya nyinarra kuliṉu, mirri pungkukitjangku. ");
INSERT INTO piu2006_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Yirutaluṯarra kuliṉu Tjaananya mirri pungkukitjangku. Yalatji kulira wantingu yaṉangu tjuṯangkuya mulyarrarringkula ngaparrtjingku pungkutjipingka. Yaṉangu tjuṯangkuya Tjaanakuraya yunypa nyinarra kuliṉingi, “Tjaananya yilta Katutjaku wangka watjalpayi.” ");
INSERT INTO piu2006_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Yirutaku paatjayi ngaranyingka tjana tjungurringkula yunypangku tjana ngalkura nyinapayi, waamaṯarraya tjikilpayi. Minyma Yirutiyatjaku yuṉṯalpa yankula taanytjirringu ngururrpa, palula tjanala kurungka. Kungka paluru taanytjirringanyingka mayutju Yirutalu kutjupa tjuṯangkuṯarra nyakula yunyparringu. ");
INSERT INTO piu2006_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Palulanguru mayutju paluru kungka palunya tjapiṉu yalatji, “Nyaaku nyuntu yunytjurringanyi?, ngayuluṉanta yungkunytjaku. Nyuntu watjala!” Yirutalu piyuku watjaṉu, “Katutjala kurungka nyuntuṉi tjapintjala ngayuluṉanta yulytja mani waaḻaṯarra yilta yungku.” ");
INSERT INTO piu2006_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Palumpa maamangku watjaṉutjangka yukarra paluru Yirutanyalpi tjapiṉu, yalatji, “Waarrkana watjala!, Tjaananya kuwarri mirri pungkula kata kuntara puḻitingka ngalya katirraṉi yungkunytjaku.” ");
INSERT INTO piu2006_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Yirutalu kulira Tjaanaku paluru puntura watjilarringu. Puṯu kuliṉu kungka yukarrangka wiya watjalkitjangku. “Ngayulu ngayuku walytja tjuṯangka kurungka watjaṉu, kungka yukarraku yungkunytjaku.” ");
INSERT INTO piu2006_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","11","Palulanguru Yirutalu waarrkana kutju iyaṉu tjiilakutu. Waarrkana paluru tjiilakutu yankula watjaṉu tjananya, “Tjaananya kata kuntara yuwaṉi!, Yirutakuṉa katinytjaku.” Kala, tjana Tjaananya kata kuntara waarrkana palumpa yungu. Paluru puḻitingka katirra kungka yukarra palumpa yungu. Kungka yukarralulpira mantjira katirra yungu palumpa maama Yirutiyatjaku. ");
INSERT INTO piu2006_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Tjaanaku walytja tjuṯangkuya mirri pungutja kulira tjiilakutu yanu. Palunyatjanu mantjiraya katingu mantangka tjarrpatjunkunytjaku. Mantangka tjana tjarrpatjunkula Yiitjulakutuya yankula tjakultjunu. ");
INSERT INTO piu2006_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Tjakulpa Tjaananya iluntankunytjatjarra kulira Yiitjunyangarriya puutangka kaḻpakatirra yanu kapiwana. Puutangkaya yankunytjala yaṉangu tjuṯangku tjananya nyakula wanarinangi, yurungka tjayiṯiwanangku. Tawunu kutjupa tjuṯanguruya tjungurringkula wanarinangi. Yankulaya yurrunpa ngarala waṉingu, Yiitjunya palumpa kutunguḻu tjuṯa tjana ngaṉṯi mantakuturringu. ");
INSERT INTO piu2006_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yiitjulu mantakutu yilarringkula nyangu tjananya, yaṉangu tjuṯa ngarala waṉinytjala. Nyakula tjanampa aḻṯururringu. Puutangka tjarukatirra paluru tjananya miiṉṯa tjuṯa palyaṉingi. ");
INSERT INTO piu2006_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Yaṉangu tjuṯa tjananya nintira mungarrtjirringu. Palulanguru Yiitjuku kutunguḻu tjuṯangku Yiitjunya marrkuṉu, “Mungarringanyingka, wantirriyala tjananya ngurra tjuṯakutu!, mangarriyanku yankula payimilantjaku. Ngaangka mangarri wiya ngarrinyi.” ");
INSERT INTO piu2006_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yiitjululpi tjananya watjaṉu, “Tjana wiya mangarriku yankunytjaku ngurra waṉma. Nyurrangarri tjananya yuwa, ngalkunytjaku!” ");
INSERT INTO piu2006_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Puṯu kuliraya watjaṉu, “Mangarri puriiti kapuṯu payipala ngarrinyi, kuka piitji kutjarraṯarra. Puṯula kuliṉi tjuṯalingku paḻtjalkitjangku.” ");
INSERT INTO piu2006_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Paluru tjananya watjaṉu, “Panyapa tjuṯa ngalya katirraṉi yuwa!” ");
INSERT INTO piu2006_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Yaṉangu tjuṯalpi paluru watjaṉu nyinakatinytjaku. Tjana yukiringka nyinanyinakatingi. Puriiti payipala kuka panyapaṯarra Yiitjulu mantjira yirra nyakula Katutjanya waḻkuṉu, mangarri panyapa Katutjalu yungutjangka. Waḻkura Yiitjulu mangarri an piitji panyapa kutu kilytjuntankula kutunguḻu tuwalpalanya yungangi, kutjupa tjuṯaku yungkunytjaku tjanampa. Yalatji tjananya kutu parra katirra yungkuyinangi, kutunguḻu tjuṯangku. ");
INSERT INTO piu2006_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","21","Yaṉangu yuwankarrangkuya ngalkura paḻtjarringu, wati payip tjawutjunangku, minyma anta pipirri tjuṯangkuṯarra. Mangarri tiṉa ngalkura waṉingutja palumpa kutunguḻu tjuṯangku mantjira tjarrpatjunangi kaṉilpa tiṉa tjuṯangka, tuwalpalangka. Kaṉilpa panyapa tjuṯangka mangarri punturringkula katu ngarala waṉingu. ");
INSERT INTO piu2006_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Palulanguru Yiitjulu tjananya palumpa kutunguḻu tjuṯa puutangka kaḻpatjura iyaṉu, yuruwanaya yurrunpa yankunytjaku. Palulanguru Yiitjulu yaṉangu tjuṯa watjara iyaṉu, ngurrakutu. ");
INSERT INTO piu2006_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Paluru puḻingka kaḻpangu Katutjalakutu wangkakitja. Mungarrinyingka Yiitjunya kutju nyinangu, puḻingka katu. ");
INSERT INTO piu2006_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ngurra palula waṉma palumpa kutunguḻu tjuṯa puutangka yanangi, yurungka ngururrwana. Tjana rawangku puutakuṉu wanatjarrangku yuṉṯurinangi. Purrkarringuya waḻpa puntungku tjananya ngalya rungkara wanaṉutjangka. ");
INSERT INTO piu2006_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Aaḻilingku pakara Yiitjunya yurungka katuwana ngalya yanangi puuta palulakutu. ");
INSERT INTO piu2006_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Yurungka katuwana ngalya yananyingka, nyakulaya nguḻurringkula mirra wakaṉu, tjaṉpakutjura kulira. Tjana nyakula kurrunpa nguḻunguḻu nyinangu. ");
INSERT INTO piu2006_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Palulanguru tjananya Yiitjulu watjaṉu, “Nguḻuwiyaya nyina!, ngayuluṉa maa yananyi.” ");
INSERT INTO piu2006_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Piitalu Yiitjunya watjaṉu, “Tjinguru nyuntu ngayuku mayutju yilta ngaranyi. Watjalaṉi maa ilarrinytjaku nyuntulakutu, yuru katuwana.” ");
INSERT INTO piu2006_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Paluru watjaṉu, “Kala, ngalya yarra!” Palulanguru Piitanya puutangka tjarukatirra yurungka katuwana yanangi Yiitjulakutu. ");
INSERT INTO piu2006_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ngururrpa yankula Yiitjula yilarringkula, waḻpa tiṉangku pirrtjitjunutjangka nguḻurringu. Nguḻurringkula purinypa tjarrpayinkula mirrarra watjaṉu, “Mayutju, witilaṉi!, kapingka tjarrpatjipingka.” ");
INSERT INTO piu2006_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yiitjulu palunya mara witira Piitanya katuṉu. Katulkitjangku witira watjaṉu, “Ngayunya ngangkari tiṉatjarra nyuntu kulinmara. Nyuntu ngayunya tjukarurru kulintjaku ramawiyangku.” ");
INSERT INTO piu2006_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Paluru kutjarra puutakutu tjungu yankula kaḻpakatinyingka, waḻpa yataṉarringu. ");
INSERT INTO piu2006_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Palumpa kutunguḻu tjuṯangkuya puutangka nyinarra Yiitjunya waḻkuṉu yalatji, “Nyuntu yilta Katutjaku katja nyinanyi.” ");
INSERT INTO piu2006_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Yuruwanaya yankula manta Kinitjaritjalakutu yanu. ");
INSERT INTO piu2006_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Puutangkaya tjarukatinytjala palunya ngurrara tjuṯangkuya Yiitjunya nuuwimilara kutjupa tjuṯa wantirriyaṉu, miiṉṯa yila ngurrara tjuṯa yaḻṯinytjaku. Yaṉangu paluru tjana yaḻṯirra ngalya katingu, Yiitjulu tjananya pampuntjaku. ");
INSERT INTO piu2006_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Tawunungka ngururrpa yaṉangu tjuṯangku miiṉṯa tjuṯa yurilta ngarritjunkula Yiitjunyaya yaḻṯirra tjapilpayi, pikatjarrangkuya palumpa kuuta kutju pampura palyarrinytjakuya. Pampuṉutja yuwankarraya palyarringkupayi. ");
INSERT INTO piu2006_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Palulanguru Paratji tjuṯa, Muutjaku wangka nintilpayi tjuṯaṯarraya Yiitjula tjungurringu. Aṉangu paluru tjanaya Tjarutjalumanya ngurrara tjuṯa tjungurringu. ");
INSERT INTO piu2006_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Yiitjunyalpiya tjapiṉu, “Yirriṯi nyinapayi tjuṯangkuya watjaṉutjangka, nyuntupa kutunguḻu tjuṯangkuya mara paltjira nyinamara, mangarri ngalkukitjangku. Nyaakuya nyuntupa kutunguḻu tjuṯangku paltjilwiyangku ngalkuṉi?” ");
INSERT INTO piu2006_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yiitjulu tjananya payiṉu, “Yirriṯi nyinapayi tjuṯaku wangka kutjunyurra kuliṉi, Katutjaku wangkanyurra wantinyi. ");
INSERT INTO piu2006_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Yirriṯi Muutjalu Katutjaku wangka yalatji watjaṉu, ‘Paapa anta maamanyurra yaṉṯayaṉṯara kanyintjaku, wiyanyurra panypurangkunytjaku palunya kutjarra, purinypangkunyurra kanyintjaku.’ Wangka kutjupa palunya nguwanpa ngaranyi, ‘Paapa anta maama panypurangkunytjala, yaṉangu palunyanyurra mirri pungkunytjaku.’ ");
INSERT INTO piu2006_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Katutjaku wangka palunya nguwanpanyurra kulira wantinyi. Nyurrangarri wiyawanangku tjananya yaṉangu tjuṯa nintilpayi yalatji, ‘Mani tjinguru yulytjanyurra mantjira, wiyanyurra paapa anta maama yungkunytjaku, wantiya!’ Yalatjinyurra wiyawanangku nintilpayi. Paapa anta maamanyurra ngunytjinytjunkupayi, yulytja mani walytjangku kanyilkitjangku, ‘Yulytja ngaatjanya tjawirrilyi, Katutjaku kutju, maa katirra ngayulu tjaatji ngurraraku yungku.’ ");
INSERT INTO piu2006_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Yaṉangu tjuṯa tjananya nyurrangarri palunya nguwanpa nintilpayi, paapa an maamaku tjukarurru yungkunytjawiya nyinanytjaku. Yalatji Katutjaku wangkanyurra wantinyi yirriṯi nyinapayi tjuṯaku wangka kutjunyurra kulira wanaṉi. Yalatji nguwanpanyurra kutu wiyawanangku palyalpayi. Yirriṯi nyinapayi tjuṯangku watjaṉutja kutjunyurra nintilpayi, Katutjaku wangkawana wiya. ");
INSERT INTO piu2006_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ngunytjinytju tjuṯanyurra nyinanyi. Yirriṯi nyinapayingku Yaatjayalu tjukarurru Katutjaku wangka watjaṉu yalatji, ");
INSERT INTO piu2006_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ngulaya yaṉangu tjuṯa ngunytjinytju nyinaku. Ngayunyaṉiya tjaangku kutju waḻkulku, wiyaṉiya yiltangku waḻkulku. ");
INSERT INTO piu2006_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Puṯu tjana ngayunya waḻkulku, ngunytjinytju tjuṯangku. Yirriṯi nyinapayi tjuṯaku luwuwana nyinakitjangkuya kulilku, ngayuku wangka wantirralpiya nyinaku. Wiya ngayukuṉu wangkaya yaṉangu tjuṯangka nintilku, yaṉangukuṉu wangka kutjuya nintilku.’ Wangka panyapa Yaatjayalu watjaṉu.” Tjuwu tjuṯangkuya mangarri an kuka kutjupa tjuṯa ngalkulpayi. Tjana mangarri an kuka kutjupa tjuṯa ngalkuwiyangku wantipayi, Muutjaku luwu yalatji ngaranyingka. Tjana watjalpayi, “Mangarri an kuka ngaatja ngalkulpayiwiya.” Paratji tjuṯangku kuliṉingi yalatji, “Mangarri an kuka ngaatja nganaṉa wiya ngalkuṉi. Yaṉangungku mangarri an kuka ngaatjanya ngalkulpayiwiya tjuṯa ngalkura, Katutjaku wangka kilytjuntananyi.” ");
INSERT INTO piu2006_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","11","Yaṉangu tjuṯa tjananya Yiitjulu yaḻṯirra tjungura watjaṉu, “Wangka ngaatjanyaya kulila! Yaṉangungku mangarri an kuka ngalkulpayiwiya tjuṯa ngalkura, wiya Katutjaku wangka kilytjuntananyi. Tjinguru yaṉangungku yaṉangu kutjupaku pikarringkula panypurangkula yalatji Katutjaku wangka kilytjuntananyi.” ");
INSERT INTO piu2006_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Yiitjuku kutunguḻu tjuṯangku yankula Yiitjunya tjakultjunu yalatji, “Yara panyapa nyuntu watjaṉingka Paratji tjuṯangku kulira nyuntupa mulyarrarringkula ngarangi.” ");
INSERT INTO piu2006_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yara tjananya Yiitjulu watjaṉu, “Kaana ngurrarangku watiya kuya piḻṯirringutja yurrkura warungka waṉipayi. Yalatji warungka waṉipayi nguwanpa ngayuku paapangku Paratji kuya tjuṯa warukutu waṉiku. ");
INSERT INTO piu2006_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Palula tjanalawana wiya nyurrangarri tjungurringkula kulintjaku. Kuru patingku wiya katipayi wati paanga mara witira, ngaṯingkapula punkaltjipingka.” Yara palunya watjara Yiitjulu yalatji watjaṉu, “Tjaampalangku Katutjaku wangka tjukarurrungku nintilpayi. Tjaampalangku Katutjaku wangka wiyawanangku nintilpayi. Paluru tjana kuru paanga palunya nguwanpa nyinanyi. Paangangku wiya yuti nyanganyi, yalatjiya paluru tjana wiya Katutjaku wangka yuti kulira tjukarurru nyinanyi, tjana kutu kuya palyalpayi. Tjana wiya yaṉangu kutjupa watjantjaku yalatji, ‘Nyuntu kuya palyaṉu, yalatji nyuntu tjukarurru nyinanytjaku, ngayunya nguwanpa.’ Nintilpayingkuṯarra Katutjaku wangka kulira tjukarurru nyinanytjaku.” ");
INSERT INTO piu2006_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Piitalu Yiitjunya watjaṉu, “Yara mangarri an kuka ngalkulpayiwiyatjarra nganaṉanya nintila!” ");
INSERT INTO piu2006_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","17","Yiitjulu tjananya nintiṉu yalatji, “Kutunyurra ngurrpa nyinanyi. Kulilaya! Mangarri an kuka tjaangkula ngalkunytjala wiḻakutu yankula ngarrirra wiyarringanyi. Yalatji mangarri an kuka ngalkulpayiwiya tjuṯa ngalkula wiya yaṉangungku Katutjaku wangka kilytjuntananyi, palya mangarri an kuka palunya ngalkunytjaku.” Yiitjulu wangka palunya watjara yalatji watjaṉu, mangarri kuka yuwankarra palyala ngalkunytjaku. ");
INSERT INTO piu2006_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","19","Yiitjulu tjananya palumpa kutunguḻu tjuṯangka piyuku watjaṉu yalatji, “Yaṉangungku Katutjaku wangka wantirra wiyawana palyara, palumpa wangka kilytjuntananyi, wiya mangarri ngalkura Katutjaku wangka kilytjuntananyi, wiya. Yurrunpa wiyawanangku kulira yalatji yaṉangungku kuya palyaṉi, yalatji Katutjaku wangka kilytjuntananyi. Yurrunpa wiyawanangku kulira miiṯa walytjawiyangka ngarrirra yalatji kuya palyaṉi. Yurrunpa wiyawanangku kulira yulytja mulyaṯalu mantjira yalatji kuya palyaṉi. Yurrunpa wiyawanangku kulira yaṉangu kutjupa mirri pungkula yalatji kuya palyaṉi. Yurrunpa wiyawanangku kulira yaṉangu kutjupanya panypurangkula yalatji Katutjaku wangka kilytjuntananyi. ");
INSERT INTO piu2006_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Wangka palunya tjuṯa nguwanpa wiyawanangkula nganaṉa kulira kuya palyara Katutjaku wangkala kilytjuntananyi, wiya mangarri anta kuka ngalkura.” ");
INSERT INTO piu2006_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yiitjunya palumpa kutunguḻu tjuṯaṯarraya ngurra palunya wantirra yanu, manta Taayalakutu, manta Tjayitanalakutuṯarra. Ngurra palula tjana nyinangi. ");
INSERT INTO piu2006_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Palulanguru minyma palunya ngurrara ngalya yankula Yiitjula tjungurringu. Paluru Tjuwuwiya nyinangu. Paluru Yiitjunya mirrarra watjaṉu, “Tapitaku walytja ngaṉṯitja yaḻṯururriwatju! Ngayuku yuṉṯalpa mamutjarra nyinanyi. Nyuntu palunya palyala!” ");
INSERT INTO piu2006_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yiitjunya wangkawiya ngarangi, yarrka. Palumpa kutunguḻu tjuṯangku yankula Yiitjunya marrkuṉu, “Minyma palatja wantirriyala! Kutulanya palangku wanara mirrarra watjarinanyi. ‘Nyurrangarri ngayuku yuṉṯalpa palyala!’” ");
INSERT INTO piu2006_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yiitjulu tjananya watjaṉu, “Yurrunpa Katutjalu watjaṉu ngayulu Yitjurilaku walytja ngaṉṯitja tjuṯa kutju palyara nintintjaku. Paluru tjana mayutjuwiya nyinanyi, tjiipi tjuṯa mayutju wiya nyinapayi nguwanpa. Minyma palatja wiya Yitjurilaku walytja ngaṉṯitja nyinanyi, Tjuwuwiya paluru nyinanyi.” ");
INSERT INTO piu2006_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Minyma paluru wangka palunya kulira Yiitjula yilarringkula pupakatirra piyuku tjapiṉu, “Mayutju. Nyuntu ngayuku yuṉṯalpa palyalku?” ");
INSERT INTO piu2006_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yiitjulu yara yalatji watjaṉu, “Wiya kuka pipirrikuṉu mantjira papa tjuṯaku yungkunytjaku, pipirriku tjanampa.” Yalatji Yiitjulu minyma palula watjaṉu, “Ngayulu Tjuwu walytja tjuṯaku, pipirri nguwanpa tjuṯaku kutju, mamu payira wantirriyalpayi, wiyaṉa nyurrangarrimpa, papa tjuṯaku nguwanpa Tjuwuwiya tjuṯaku, mamu payira wantirriyalpayi.” ");
INSERT INTO piu2006_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Minyma paluru watjaṉu, “Yuwa kuliṉiṉanta. Wangka kutjupa ngaatjaṉanta watjaṉi. Papa tjuṯangku ngalkuṉi tiipulangka yunngu, pipirri tjuṯangku ngalkura waṉingutja.” Yalatji Minyma paluru Yiitjunya watjaṉu, “Ngayuluṉanta papa nguwanpangku ngarala nyanganyi, kukaku nguwanpa, nyuntu ngangkaritjarrangku ngayuku yuṉṯalpa palyantjaku. Ngayuku yuṉṯalpangka mamu payira wantirriyala!, ngangkari tiṉatjarrangku!” ");
INSERT INTO piu2006_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yiitjulu watjaṉu, “Nyuntu papa nguwanpangku ngarala nyangangi, ngayulu nyuntupa yuṉṯalpa palyantjaku. Yalatji ngayuluṉanta nyuntupa wangka kuliṉi. Nyuntu yilta kuliṉi ngayulu ngangkari puntutjarra nyinanyingka.” Yiitjulu yalatji watjantjala yilta palumpa yuṉṯalpa palyarringu. Mamungku palunya wantirra yanu. ");
INSERT INTO piu2006_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Palulanguru Yiitjunya, palumpa kutunguḻu tjuṯaṯarra yanu yuru Kaliliyila tjayiṯiwana. Puḻingkaya tjana kaḻparra nyinangi. ");
INSERT INTO piu2006_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Puḻi palula Yiitjunya nyinanytjala yaṉangu tjuṯalingkuya palula ngalyankula tjungurringu. Tjungurringkulaya ngalya katingu miiṉṯa tjuṯa, nyumpu tjuṯa, pampa tjuṯa, wangkawiya tjuṯaṯarra. Ngalya katirra tjananya paluru tjana nyinatjunu, Yiitjulu pampura palyantjaku. Yiitjulu tjananya uwankarra palyaṉu. ");
INSERT INTO piu2006_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Paluru tjana palyarringutja tjuṯa nyakula yunyparringu, “Katutjanya nganaṉa waḻkuntjaku. Paluru nganampa mayutju tiṉa nyinanyi Yitjurilaku walytja ngaṉṯitja tjuṯaku. Ngaangku tjananya palumpaṉu ngangkari tiṉatjarrangku palyaṉingi.” ");
INSERT INTO piu2006_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yiitjulu palumpa kutunguḻu tjuṯa yaḻṯirra watjaṉu yalatji, “Ngayulu tjanampa yaḻṯururringanyi yaṉangu ngaa tjuṯaku, paluru tjana tjiṉṯu maṉkurrpa mangarriwiya nyinangutjangka. Ngayuluṉa wiya tjananya paḻtjatjirratja nyinanytjala ngurrakutu wantirriyalkitjangku kuliṉi, yankulaya ngururrpa paḻtjatjirratja punkalpayingka.” ");
INSERT INTO piu2006_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Palumpa kutunguḻu tjuṯangkuya Yiitjula watjaṉu, “Ngaangka mangarri tjuṯa wiya ngaranyi, puriiti tjuṯa tjanampa mantjilkitjangku nganaṉa puṯu kuliṉi. Yaṉangu tjuṯalingkuya ngaatja nyinanyi.” ");
INSERT INTO piu2006_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yiitjulu tjananya tjapiṉu, “Tjinguru mangarri wiima ngarrinyi? Puriiti nyaalytjirrinyurra kanyiṉi?” Watjaṉuya, “Puriiti wiima rawunwana tjapanpalalatju kanyiṉi. Piitji wiima maṉkurrpaṯarra ngarrinyi.” ");
INSERT INTO piu2006_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yaṉangu tjuṯa tjananya Yiitjulu watjaṉu mantangka nyinakatinytjakuya. ");
INSERT INTO piu2006_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Mangarri panyapa, piitjiṯarra mantjira paluru Katutjanya irra nyakula tjapiṉu yalatji, “Paapa, nyuntulanyatjunu mangarri ngaatjanya piitjiṯarra yungu.” Paluru kutu mangarri piitjiṯarra kilytjuntankula tjananya palumpa kutunguḻu tjuṯanya yungangi, yaṉangu tjuṯaku tjanampa katirra yungkunytjaku, paḻtjatjirratjaya nyinanytjala. Yalatji tjananya kutu katirra yungangi, kutunguḻu tjuṯangku. ");
INSERT INTO piu2006_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","38","Yalatji mangarri anta piitji panyapa Yiitjulu tjanampa ngangkaritjarrangku tjuṯalingkuṉu. Yaṉangu yuwankarrangkuya ngalkura paḻtjarringu, wati puu tjawutjunangku, kungka an pipirri tjuṯangkuṯarra. Mangarri tjuṯa ngalkura waṉingutja ngarrirra waṉingi. Palumpa kutunguḻu tjuṯangku mantjira tjunangi kaṉilpa tiṉa tjapanpalangka. Kaṉilpa panyapa tjuṯangka mangarri punturringkula katukaṯitja ngarringi. ");
INSERT INTO piu2006_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Palulanguru Yiitjulu yaṉangu tjuṯanya watjaṉu ngurrakutu yankunytjaku. Puutangkaya kaḻparra yanu Yiitjunya, palumpa kutunguḻu tjuṯaya ngurra Makatanalakutu. ");
INSERT INTO piu2006_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Palulanguru Yiitjulakutuya ngalyanu Paratji tjuṯa, Tjuwuku mayutju kutjupa tjuṯaṯarra. Paluru tjana yalatji kulilpayi, “Tjinguru Yiitjulu wiyawanangku watjaṉingka ngulala kuutawutjuku mayutjungka tjakultjunku.” Yiitjunyaya yalatji watjaṉu, “Ngangkaritjarrangku nyuntu kutjupa kutjupa palyala!, nganaṉatju nyakunytjaku. Nyakulalatju tjinguru kulilku nyuntu Katutjakuṉu, tjinguru wiya.” ");
INSERT INTO piu2006_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yiitjulu tjananya watjaṉu, “Mungarrtji ilkarinyurra nyakula kuliṉi, ‘Ilkari kutju, mungangkalanya kapingku wiya pungku.’ ");
INSERT INTO piu2006_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Aaḻinyurra nyakula kuliṉi, ‘Kuwarrilanya kapingku pungku, yutuwari ngaranyingka.’ Yutuwari nyakula nyurrangarri tjukarurru kuliṉi kapingku pungkukitjangku. Yalatji tjukarurru kulintja nguwanpa ngayuku wangka kulira, ngayulu mangarri tjuṯa palyantjala nyakula nyurrangarri tjukarurru kulinmara, ngayulu Katutjakuṉu nyinanyi, ngangkari tiṉatjarra. ");
INSERT INTO piu2006_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kutuṉinyurra tjapilpayi ngangkaritjarrangku kutjupa kutjupa palyantjaku, nyakulaṉinyurra Katutjakuṉu kulilkitjangku. Yaṉangu tjuṯanyurra kuya nyinanyi Katutjanya kulintjawiya. Ngayulu wiya nyurrangarrimpa ngangkaritjarrangku kutjupa kutjupa palyalku. Yalatji kutju ngayulu nyurrangarrinya watjalku yara Tjawunanyatjarra. Yalatji watjara tjananya Yiitjulu taaṉarringkula wantikatirra yanu. Tjawuna paluru irriṯi Katutjaku wangka watjalpayi. Tjawuna palunya piitji tiṉangku kuuḻtjunkula kanyiṉu munga kutjarra. Yulkapatjunkula tjiṉṯu kutjupangka piitjingku kana walatjunu. Panyapa kulira tawunu Ninapanya ngurrara tjuṯangkuya kuliṉu, ‘Yilta, Katutjalu Tjawunanya kanaṉu.’ Palunya nguwanpa ngayulu, yaṉanguku katja, munga kutjarra mirri ngarrirra kanarringutja nyakula nyurrangarri kulilku, ‘Yilta, Katutjalu palunya kanaṉu.’” ");
INSERT INTO piu2006_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Puutangkaya Yiitjunya, palumpa kutunguḻu tjuṯaṯarra kaḻpakatirra yuruwana yanu. Yankulaya mantakuturringkula palumpa kutunguḻu tjuṯangkulpi kuliṉu, “Yaka, nganaṉa ramarringu. Puriitila tjunkula puutangka ngalya katimara.” ");
INSERT INTO piu2006_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yiitjulu tjananya wangka kutjupa nintiṉu yara yalatji, “Purinypaya nyinama!, Paratji tjuṯangkamarra, nintilpayi kutjupa tjuṯangkamarraṯarra, pikinpawutu nguwanpa tjuṯangkamarra.” ");
INSERT INTO piu2006_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Palumpa kutunguḻu tjuṯangkuya puṯu kulira watjara waṉingu, yalatji, “Nyaa nganaṉanya paluru watjaṉu? Tjinguru puriitila puutangka tjunkunytjawiyangka, panyapa nganaṉanya watjaṉu paluru.” ");
INSERT INTO piu2006_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yiitjulu nintingku kuliṉingi tjana wangkanytjala. Paluru tjananya tjapiṉu, “Nyaakunyurra mangarriwiyangka wangkanyi? Kulinmaraṉinyurra ngayuluṉa Katutjakuṉu ngangkaritjarra nyinanytjala. Kutunyurra nyinanyi ngayunya kulintjawiya. ");
INSERT INTO piu2006_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ngayulu Katutjakuṉu ngangkaritjarrangku palyalpayi. Kulinmaraṉinyurra ngayulu tjanampa yirriṯi puriiti palyalpayi ngangkaritjarrangku, ngayuluṉa yaṉangu tjuṯalingku payipi tjawutjuna paḻtjaṉutjangka, puriiti payipalangka. Kaṉilpa tiṉa tjuṯangkanyurra mantjira tjunangi, mangarri ngalkura waṉingutja. ");
INSERT INTO piu2006_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Kulinmaranyurra ngayulu tjananya kutjupa tjuṯa puu tjawutjuna puriiti tjapanpalangka paḻtjaṉutjangka. Palulanguru kaṉilpa tiṉa tjuṯangkanyurra mantjira tjunangi, puriiti ngalkura waṉingutja. ");
INSERT INTO piu2006_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Puriitinguru wiya ngayulu nyurrangarrinya watjaṉu. Yalatji kutju ngayulu watjaṉu, ‘Purinypaya nyinama!, Paratji tjuṯangkamarra, nintilpayi kutjupa tjuṯangkamarraṯarra, pikinpawutu nguwanpa tjuṯangkamarra.’” ");
INSERT INTO piu2006_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Pina alytjurarringkula tjana kuliṉu yalatji, “Pikinpawutulanya watjaṉu yara kutju, puriitikuṉu pikinpawutu wiya. Watjaṉulanya Paratji tjuṯangku nintilpayi kutjupa tjuṯangkuṯarra Katutjaku wangka wiyawana nintilpayi. Paluru watjaṉu nganaṉa palumpa tjanampa wangka wiya kulintjaku.” ");
INSERT INTO piu2006_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yiitjunya palumpa kutunguḻu tjuṯaṯarra, yanangi ngurra tjuṯawana tawunu Tjiitjarriyapilipayingka tjayiṯiwana. Yankula Yiitjulu tjananya palumpa kutunguḻu tjuṯangka watjaṉu, yalatji, “Ngayulu yaṉanguku katja nyinanyi. Yaṉangu tjuṯangkuṉiya ngunytji kuliṉi ngayulu yini Yiitjunya. Kuliṉiya ngayulu mirritjanu nguwanpa nyinanyi. Yini ngananyaṉiya watjaṉi?” ");
INSERT INTO piu2006_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Watjaṉuya alatji, “Kutjupa tjuṯangkuntaya watjaṉi, nyuntu Tjaananya mirritjanu pakara nyinanyi, kapingka tjarrpatjunkula papatatjimilalpayinya. Kutjupa tjuṯangkuntaya watjaṉi, nyuntu mirritjanu pakara Yilaatjanya nyinanyi. Kutjupa tjuṯangkuntaya watjaṉi, nyuntu mirritjanu pakara Tjirimayanya nyinanyi. Kutjupa tjuṯangkuntaya watjaṉi, nyuntu Katutjaku wangka watjalpayinya nyinanyi, mirritjanu pakara.” ");
INSERT INTO piu2006_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yiitjulu tjananya tjapiṉu, “Ngananyaṉinyurra yini watjaṉi?” ");
INSERT INTO piu2006_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Piitalu watjaṉu, “Nyuntu Kurayitjanya nyinanyi, Katutjalu yirriṯi watjara wantirriyaṉutja, palumpa katja yilta.” ");
INSERT INTO piu2006_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yiitjulu palunya waḻkuṉu yalatji, “Tjaanakun katja, nyuntu tjukarurru watjaṉu. Wiya nyuntu walytjangku kulira panyapa watjaṉu. Paapa Katutjalu, ilkari ngurrarangkunta nintiṉu, wangka panyapa watjantjaku, wiya yaṉangu kutjupangkunta nintiṉu panyapa watjantjaku.” ");
INSERT INTO piu2006_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Yiitjulu Piitanya piyuku watjaṉu, “Nganaṉa nyuntunya yini Pitiranya watjalpayi. Nganaṉa puḻiṯarra yini pitira watjalpayi nyakula. Waarrkana tjuṯangku waaḻa palyalkitjangku tjiminta yurrunpa yintilpayi taayitirringkula puḻirrinytjaku. Tjiminta yurrunpa nyinangutja nguwanpa nyuntu ngayuku walytja yurruntitja nyinanyi. Nyuntu nyinarra wiyarrinytjala ngaṉṯi ngayuku walytja kutjupa tjuṯalingkulpiya nyinarra waṉimalpa ngurra tjuṯawana. Paluru tjana wiyarrinytjala ngayuku walytja kutjupa tjuṯalingkulpi nyinarra waṉimalpa. Yalatji ngayuku walytja tjuṯalingkulpiya nyinarra waṉimalpa. Tjaampalaya mirrirrinytjala kutjupa tjuṯalpi ngayuku walytjarringkula nyinamalpa. Mamuku mayutjungku tjananya puṯu tjingapungku ngayuku wangka wantirra walytjawiyalpi nyinanytjaku. ");
INSERT INTO piu2006_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nyuntulpi Katutjaku walytja tjuṯa tjananya nintinmalpa ngayuku wangkawana tjukarurru nyinanytjaku. Nyuntu yalatji yaṉangu kutjungka watjantjala, ‘Katutjalu nyuntupa kuya waṉinyi, nyuntu palumpa walytja nyinanytjaku.’ Nyuntu panyapa watjantjala Katutjalu ilta palumpa kuya waṉiku. Tjinguru nyuntu yaṉangu kutjupangka yalatji watjantjala, ‘Katutjalu nyuntupa kuya wiya waṉinyi, nyuntu wiya palumpa walytja nyinaku.’ Katutjalu ilta palumpa kuya wiya waṉiku.” ");
INSERT INTO piu2006_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Palulanguru tjananya Yiitjulu marrkuṉu, “Ngayunya Katutjalu wantirriyaṉutja, Kurayitjanya, wiya nyurrangarri yaṉangu kutjupangka tjakultjunkunytjaku.” ");
INSERT INTO piu2006_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Palulanguru palumpa kutunguḻu tjuṯangka tjanala nintiṉu yalatji, “Tjarutjalumalakutu ngayulu yankunytjala, yaṉanguku katjaṉiya tjuṯangara pikantankula mirrintanku. Muutjaku wangka nintilpayi tjuṯangku, tuḻkuku mayutju tiṉa tjuṯangkuṯarra, tjiḻpi tjuṯangkuṯarra watjantjala tjana ngayunya pikantankula mirrintanku. Mirri ngarrirraṉa munga kutjarra pakara yanku.” ");
INSERT INTO piu2006_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Wangka panyapa yuti tjananya Yiitjulu watjaṉu mirrirrikitjangku. Piitalu Yiitjukuṉu wangka kulira Yiitjunya yaḻṯirra katingu paluru kutjarra ngarala wangkanytjaku. Piitalu Yiitjunya yalatji marrkuṉu, “Wiya. Nyuntu kana kutun nyinaku.” ");
INSERT INTO piu2006_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yiitjulu kulira taaṉarrirra Piitanya yalatji payiṉu, “Mamuku mayutjungku tjingapunganyingka nyuntu wiyawanangku kulira watjaṉu ngayunya. Yaṉangu kutjupa tjuṯangkuṯarra pala pilinypa kuliṉi. Ngayulu wiya yalatji kuliṉi. Palya Katutjalu kuliṉi yaṉangu kuya tjuṯangku ngayunya mirrintankunytjaku.” ");
INSERT INTO piu2006_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Palulanguru tjananya palumpa kutunguḻu tjuṯa Yiitjulu watjaṉu yalatji, “Yaṉangu ngayuku walytja nyinanytjakitjangku, yulytjaku, manikuṯarra wiya kulintjaku, ngayunya kutju kulira nyinanytjaku. Kuya tjuṯangkuya panypurangkunytjala paluru ngayuku kutu tjukarurru nyinanytjaku. ");
INSERT INTO piu2006_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tjinguru kuya tjuṯangku mirri pungkutjipingka, ngayuku walytjangku nguḻurringkula ngayunya wiyalpi kulilku. Yaṉangu paluru wiya kana kutu nyinaku ngayuku ngurrangka, wiya. Tjinguru kuya tjuṯangku mirri pungkukitjangku watjantjala, ngayuku walytja kutjupangku kulira wiya nguḻurrinytjaku mirriya pungkukitjangku watjantjala. Paluru kana nyinakitjangku kulintjawiya, tjukarurru ngayuku kutu nyinanytjaku. Yalatji tjukarurru nyinanytjala palulanguru kuya tjuṯangku iluntanku. Palulanguru paluru ngayuku ngurrangka kana kutu nyinaku. ");
INSERT INTO piu2006_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Kulilaya wangka ngaatja! Tjinguru nyurrangarri ngayuku wangka wantirra mani tiṉa, yulytja tiṉaṯarra, waaḻa tjuṯaṯarra mantjira kanyilku. Yalatji mantjira wiya nyurrangarri kana kutu nyinaku Katutjaku ngurrangka. ");
INSERT INTO piu2006_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ngulalatju tjungu mantakutu ngalya yanku, ilkari ngurrara tjuṯa. Ngangkari tiṉatjarra ngayuku paapa nguwanpaṉa yaṉanguku katja mantakutu piyuku ngalya yanku. Ngalya yankulaṉa nyurranya yaṉangu tjuṯa tjukarurru watjalku, kutjupa tjuṯangkunyurra kuya palyaṉutjangka pikantankunytjaku watjalku. Kutjupa tjuṯanyurra tjukarurru nyinangutjangka, Katutjaku ngurrangka palya nyinaku. ");
INSERT INTO piu2006_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Wangka ngaatjanyaya kulila! Katutjalu yaṉangu tjuṯa ngulytjura yaṉṯayaṉṯantjala, tjaampalangkunyurra kana nyinarra walytja palunya tjuṯa ngayunyaṯarra nyakula kutju mirrirriku. Palunya tayimi ngayulu yaṉanguku katja mayutju tiṉalpi mantakutu piyuku ngalyankuku.” ");
INSERT INTO piu2006_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Palulanguru tjiṉṯu tjikitjipala nyinarra Yiitjulu tjananya Piitanya Tjayimitjanya Tjaananyaṯarra yaḻṯirra katingu puḻikutu. Tjaananya paluru Tjayimitjaku maḻanypa nyinangu. Puḻingkaya katu kaḻparra ngarangi. Yaṉangu kutjupa tjuṯa wiya puḻi palula nyinangu. ");
INSERT INTO piu2006_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Paluru tjana kutju nyangu Yiitjunya, yaṉangu kutjupa nguwanpa ngaranytjala. Yuṉpa palumpa layitirringangi. Palumpara mantarra tjulkurarringkula layitirringangi. ");
INSERT INTO piu2006_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Yiitjulawanapula Muutjanya, Yilaatjanya yutitjarringu, yirriṯi nyinarra wiyarringutja kutjarra. Paluru kutjarrapula Yiitjula wangkangi. ");
INSERT INTO piu2006_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Piitalu palunya kutjarra nyakula Yiitjunya watjaṉu, “Mayutju. Nyuntu palya nganaṉanya ngaakutu ngalya katingu. Nyuntu yunytjurringanyingka puri maṉkurrpalatju palyalku nyurrangarrimpa, kutju nyuntupanta, kutjupara Muutjaku, kutjupara Yilaatjaku.” ");
INSERT INTO piu2006_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Piitanya panyapa wangkanytjala yutuwaringku tjananya tjutuṉu. Yutuwari paluru layitirringkula pinpangi. Katutjanya yutuwaringuru wangkangu, “Ngaatjanya katja ngayuku yunytjuṉara nyinanyi. Rawangkunyurra palumpa wangka kulintjaku.” ");
INSERT INTO piu2006_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Piitalungarriya wangka palunya kulira puntura nguḻurringkula waṯungarangi. ");
INSERT INTO piu2006_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yiitjulu tjanalakutu yankula pampura tjananya watjaṉu, “Pakalaya!, nguḻuwiya nyinama!” ");
INSERT INTO piu2006_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Palulanguruya pakara nyangu Yiitjunya kutju ngaranytjala. ");
INSERT INTO piu2006_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Puḻingkaya tjarukatinytjala Yiitjulu tjananya marrkuṉu yalatji, “Puḻingka katu nyurrangarri nyangutjangku wiya yaṉangu kutjupa tjuṯangka tjakultjunkunytjaku.” Piyuku tjananya watjaṉu yalatji, “Ngula palyanyurra tjakultjunkunytjaku, kuwarrinyurra puḻingka nyangutjangku, ngayuluṉa yaṉanguku katja mirringuru pakara kutju yananyingka, ngaṉṯinyurra palya tjakultjunkunytjaku.” ");
INSERT INTO piu2006_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Palulanguru Yiitjunyaya wangka kutjupawana tjapiṉu, “Nyaakuya Muutjaku wangka nintilpayi tjuṯangku watjalpayi yalatji?, ‘Yirriṯi nyinangutja Yilaatjanya yurrunpa ngalya yanku, Kurayitjanya ngaṉṯi ngalya yanku.’” ");
INSERT INTO piu2006_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","12","Yiitjulu tjananya watjaṉu, “Yilaatjanya yilta yurrunpa ngalyanu, yaṉangu tjuṯa nintira tjukarurru nyinatjunkunytjaku. Yilaatja paluru yini Tjaananya yilta ngalya yanu. Ngalya yankula tjakultjunkunytjala, yaṉangu tjuṯangkuya palumpa wangka kulira wantipayi. Yilta Tjaana palunya nguwanpaṉiya yaṉanguku katja kulira wantiku. Palunyatjanuṉiya kulintjawiyangku pungku.” ");
INSERT INTO piu2006_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Palulanguru palumpa kutunguḻu tjuṯangkulpi kuliṉu, “Yuwa, Tjaananya wati Yilaatjanya nguwanpa ngalyanu Katutjaku wangka tjakultjunkula yaṉangu tjuṯa papatatjimilantjakuṯarra.” ");
INSERT INTO piu2006_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Puḻinguru tjana tjarukatirra yankula yaṉangu tjuṯangka tjanala tjungurringu. Wati kutju Yiitjulakutu ngalya yankula pupakatirra wangkangu, ");
INSERT INTO piu2006_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Mayutju. Ngayuku katjaku yaḻṯururringkula palyala! Tayimingka paluru kaṯiṯi patjara punkalpayi. Yalatji mamungku patjantjala paluru warukutu punkalpayi, kapikutuṯarra. ");
INSERT INTO piu2006_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nyuntupa kutunguḻu tjuṯangkaṉa tjananya ngayulu puṯu tjapiṉu mamu payira wantirriyantjaku. Puṯuya payira wantirriyaṉu.” ");
INSERT INTO piu2006_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yiitjulu tjananya yaṉangu tjuṯa, palumpa kutunguḻu tjuṯaṯarra watjaṉu, “Nyurrangarri ngayuku wangka kulira wantipayi. Rawaṉa nyurranya nintiṉangi. Kuliranyurra ninti nyinamara. Yaalytjingaranyurra pina alytjurarringkula kulilku? Uḻa palatja yaḻṯirra ngalya kati, ngayulakutu!” ");
INSERT INTO piu2006_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yiitjulu uḻa palula watjaṉu, “Mamu, uḻa ngaatjanya wantirra yarra!” Yalatji Yiitjulu mamu palunya payira wantirriyara uḻa palunya palyaṉu. Palyalpi paluru nyinangu. ");
INSERT INTO piu2006_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Yaṉangu tjuṯa yila ngaranytjawiyangka palumpa kutunguḻu tjuṯangkuya tjapiṉu, “Nyaangurulatju mamu palunya puṯu payira wantirriyaṉu?” ");
INSERT INTO piu2006_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Yiitjulu tjananya watjaṉu, “Ngayuku wangka yiltangku kulira nyurrangarri rapangku mamu palunya ngayukuṉu ngangkari tiṉatjarrangku payira wantirriyanmara. Wangka ngaatjanyaya kulila! Ngayuku wangka nyurrangarri yiltangku kulira ngayukuṉu ngangkaritjarrangku puḻi ngaatjanya yaṉangu nguwanpa watjalku, ‘Puḻi, pakara ngurra kutjupakutu yarra, nyarrakutu!’ Palulanguru ngurra kutjupakutu puḻi palatja yankula ngaraku.” ");
INSERT INTO piu2006_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","23","Yiitjunya, palumpa kutunguḻu tjuṯaṯarra yankula manta Kaliliyila tjana nyinangu. Ngurra palula Yiitjulu tjananya watjaṉu yalatji, “Wati kutjungkuṉi yaṉanguku katja tjakultjunku tjananya, kutjupa tjuṯangkuṉiya witira iluntankunytjaku. Ilta tjana ngayunya iluntanku. Munga kutjarraṉa mirri ngarriku, Katutjaluṉi pakaltjingalku.” Kuliraya puntura watjilarringu. ");
INSERT INTO piu2006_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Palulanguruya Yiitjunya, palumpa kutunguḻu tjuṯaṯarra yankula tawunu Kapaniyamala tjarrparra nyinangu. Tjaatji tiṉaku mani mantjilpayi maṉkurrpangkuya Piitanya yiwarrangka nyakula tjapiṉu, “Nyuntupa mayutjungkukampa tjaatjiku mani yungkupayi?” ");
INSERT INTO piu2006_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Piitalu tjananya yuwa wangkangu. Palulanguru paluru yankula waaḻangka tjarrpanytjala Yiitjulu Piitanya yalatji tjapiṉu, “Nyaalytji nyuntu kuliṉi? Tjinguru kamantaku mani wiyarringkunytjala kamanta ngurrara mayutju tiṉangku mani kutjupa yaṉangu nganalangarri mantjilku?, tjinguru palumpaṉu katja tjuṯangka?, tjinguru yaṉangu kutjupa tjuṯangka?” ");
INSERT INTO piu2006_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Piitalu palunya watjaṉu, “Kutjupa tjuṯangka.” Yiitjulu watjaṉu, “Yuwa, katjapiṯi wantirra paluru kutjupa tjuṯangka kamantaku mani mantjilku, katjapiṯingku wiya yungku kamantaku mantjira kanyintjaku. Ngayulu mayutju tiṉaku katja nyinarra wiya mani tjaatjiku yungkunytjaku. ");
INSERT INTO piu2006_vpl VALUES ("MT17_27","07