﻿USE sofia;
DROP TABLE IF EXISTS sofia.pirNT_vpl;
CREATE TABLE pirNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES pirNT_vpl WRITE;
INSERT INTO pirNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesucristo acayere panopʉ cjẽnare yahutja yʉhʉ. Tiquiro ñecʉno mʉnano panopʉ cjʉ̃no Davi wame tiriquiro ijie tiahye. Tiquiro ijiato pano tiquina ñecʉno mʉnano iji turiariquiro Abrahã wame tiriquiro ijie tiahye. ");
INSERT INTO pirNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahã Isaac pacʉro ijiahye. Isaac Jacob pacʉro ijiahye. Jacob Judá gʉ̃hʉ pacʉro ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Fare, Zara mehna tiquina pacʉro Judá ijiahye. Tiquina pacoro Tamar wame tiricoro ijiahye. Fare Esrom pacʉro ijiahye. Esrom Aram pacʉro ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram Aminadab pacʉro ijiahye. Aminadab Naasón pacʉro ijiahye. Naasón Salmón pacʉro ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón Booz pacʉro ijiahye. Tiquiro pacoro Rahab ijiahye. Booz Obed pacʉro ijiahye. Tiquiro pacoro Rut ijiahye. Obed Isaí pacʉro ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí Davi pacʉro ijiahye. Davi pehe Israe masa pʉhtoro ijiahye. Tiquiro Uria wame tiriquiro mʉnano namonore tiquiro namo tiri bato Salomo wame tiriquirore pohna tiahye. ");
INSERT INTO pirNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomo Roboam pacʉro ijiahye. Roboam Abia pacʉro ijiahye. Abia Asa pacʉro ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa Josafat pacʉro ijiahye. Josafat Joram pacʉro ijiahye. Joram Uzia pacʉro ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzia Jotam pacʉro ijiahye. Jotam Acaz pacʉro ijiahye. Acaz Ezequia pacʉro ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequia Manase pacʉro ijiahye. Manase Amón pacʉro ijiahye. Amón Josia pacʉro ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josia Jeconia gʉ̃hʉ pacʉro ijiahye. Tiquina ijiri pjere Israe yehpa cjẽnare Babilonia cjẽna pehe ñehe cãhye tiquina ya yehpapʉ. ");
INSERT INTO pirNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Sa ye Babilonia yehpapʉ tiquina esari bato, Jeconia Salatiere pohna tiahye. Salatiel Zorobabel pacʉro ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel Abiud pacʉro ijiahye. Abiud Eliaquim pacʉro ijiahye. Eliaquim Azor pacʉro ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor Zadoc pacʉro ijiahye. Zadoc Aquim pacʉro ijiahye. Aquim Eliud pacʉro ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud Eleazar pacʉro ijiahye. Eleazar Matán pacʉro ijiahye. Matán Jacob pacʉro ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob José pacʉro ijiahye. José María manʉno ijiahye. María pehe Jesu pacoro ijiri. Jesu pehe masare yʉhdʉoatiquiro ijiro, Cristo tiquina ni pisuriquiro ijiri. ");
INSERT INTO pirNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Sa yeye Abrahãre mari queo mʉhtagʉ̃ tee Davire mari queo bato tigʉ̃ ahriquina ijipihtiyequina tiquina panamena mehna ijiye, catorce cururi waro ijiahye. Sa yeye mari pari turi Davire mari queo mʉhtagʉ̃ tee Babiloniapʉ Israe masare tiquina neato pano mari queo bato tigʉ̃ ijipihtiyequina tiquina panamena mehna ijiye, catorce cururi waro pari turi ijiahye. Sa ye tuhasa Babiloniapʉ tiquina esari bato mari queo mʉhtagʉ̃ tee Cristo tiquiro masa bajuagʉ̃pʉ mari queo bato tigʉ̃ ijipihtiyequina tiquina panamena mehna ijiye, catorce cururi waro ijiahye tja. ");
INSERT INTO pirNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Sa ye ohõ saha Jesucristo masa bajuari jiri. Tiquiro pacoro María pehe José mehna omoca dʉhteaticoro ijiahye. Sa yero ticoro omoca dʉhteato pano Espíritu Santo tutuaye mehna coã nijinogãre ne bʉcʉa cãhtaro masiahye ticoro basi. ");
INSERT INTO pirNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Sa yero José ticorore omoca dʉhteatiquiro tire masino, poto ijiyere yeriquiro ijiro ticorore cohãno taro nimahye. Masa tiquina ihñono ticorore bʉoro ye dueraro, masa tiquina tʉhoato pano yahuro marieno ticorore cohãno taro nimahye. ");
INSERT INTO pirNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Tire tiquiro tʉhoturi watoa Cohãcjʉ̃ yaquiro angel pehe quehẽnopʉ Josére bajuaro, ohõ saha niahye: —‍José, Davi mʉnano panami iji turiagʉ, María mehna bʉe tiro marieno omoca dʉhteya. Ticoro Espíritu Santo yedohoro mehna coã nijinogãre ne bʉcʉa cãhtaricoro ijire. Sa yegʉ bʉe tiro marieno omoca dʉhteya ticorore. ");
INSERT INTO pirNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ticoro pohna tirota. Tiquirota ticoro macʉnota tiquiro ya maca cjẽnare pecapʉ wahaboriquinare yʉhdʉoatiquiro ijirota. Tiquiro sa yʉhdʉoatiquiro ijigʉ̃ ihñagʉ̃ Jesu wame yegʉta mʉhʉ tiquirogãre, niahye angel Josére. ");
INSERT INTO pirNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ahri ijipihtiye sa wahahye panopʉ cjʉ̃no Cohãcjʉ̃ yere yahu mʉhtariquiro tiquiro ni ojoariro sahata. Tire tiquirore Cohãcjʉ̃ ojoa dutiahye. Ohõ saha ni ojoahye Cohãcjʉ̃ yere: ");
INSERT INTO pirNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Nuhmino, nijinogãre bocaro pohna tirota ticoro macʉnogãre. Sa yero Emanuel wame tirota tiquirogã, ni ojoahye Cohãcjʉ̃ yere. “Emanuel” nino “Cohãcjʉ̃ mari mehnata ijire”, nino niaga. ");
INSERT INTO pirNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Cohãcjʉ̃ yaquiro angel Josére tiquiro ni yahuri bato José pehe wahcã, angel dutiriro sahata María mehna omoca dʉhteahye. ");
INSERT INTO pirNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Tiquiro macʉnogãre ticoro pohna tiato pano José pehe ticoro mehna ijiera tiahye. Ticoro pehe pohna tia wahahye. Sa yero tiquiro pehe macʉnogãre Jesu wame yeahye. ");
INSERT INTO pirNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Herode Judea yehpa cjẽna pʉhtoro tiquiro ijiri pje ti yehpapʉ ijiri macapʉ Belẽpʉ Jesu masa bajuahye. Tiquiro sa masa bajuari bato ñahpicohare buheyequina ñahpicohare quehnoano masiñequina asʉ̃ mʉja taro cjẽna ahta, Jerusalẽpʉ wihiahye. ");
INSERT INTO pirNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Sa wihiye, masare to cjẽnare sinituahye: —‍¿Judio masa pʉhtoro ijiatiquiro yojopʉre nohopʉ masa bajuagari tiquiro? Asʉ̃ mʉja taropʉ cjãna ijiaja. Sa yena ñahpicoha coã bajua wahã sagʉ̃ ihñana “Pʉhtoro masa bajuaro niaga”, ni masii ʉsã. Sa tia bajuagʉ̃ ihñana, ʉsã ihcãno mehna tiquirore ño peona ahtaʉ ohõpʉ, ni, yahuahye buheyequina masare. ");
INSERT INTO pirNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Sa ye apequina Herodere tire yahuahye. Tiquina sa yahugʉ̃ tʉhoro Herode pehe bʉjʉa witi tʉhotuahye. Sa yeye ijipihtiyequina Jerusalẽ cjẽna gʉ̃hʉ tiquiro yero sahata bʉjʉa witi tʉhotuahye tiquina gʉ̃hʉ. ");
INSERT INTO pirNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Sa yero Herode pehe ijipihtiyequina pahia pʉhtoare, mari judio masare buheyequina gʉ̃hʉre tiquiro piji cahmecoa peho, tiquinare sinituahye tiquiro: —‍¿Nohopʉ masa bajuaboagari Cristo pehe, mʉsa tʉhotugʉ̃? ni sinituahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ohõ saha ni yahuahye tiquirore: —‍Belẽpʉ, Judea yehpapʉ ijiri macapʉ Cristo masa bajuarota. Ohõ saha ni ojoahye Cohãcjʉ̃ yere yahu mʉhtariquiro: ");
INSERT INTO pirNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Belẽpʉ yeequinare Israe masare dutiatiquiro, tiquinare cohteatiquiro ahtarota. Sa yero apeye macari Judea yehpapʉ ijiye macari yʉhdʉoro ijire Belẽ pehe, ni ojoahye Cohãcjʉ̃ yere, ni yahuahye tiquina Herodere. ");
INSERT INTO pirNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tiquina sa ni yahuri bato Herode masa tʉhoeropʉ asʉ̃ mʉja taropʉ ahtariquinare pijioahye. Tiquiro cahapʉ tiquina esagʉ̃ ihñano, tiquinare sinituahye. Tiquiro sa sinitugʉ̃ tʉhoye, tiquina ñahpicohare ihñari decore yahuahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Tiquina sa yahuri bato Herode pehe tiquinare Belẽpʉ ohoro, ohõ saha niahye tiquinare: —‍Tiquirogãre quehnoano macaña. Tiquirogãre bocana yʉhʉre tojoana yahu tojoaya. Yʉhʉ gʉ̃hʉ tiquirogãre ño peou wahaʉ tʉʉ niaja, niahye tiquinare Herode. ");
INSERT INTO pirNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Tiquiro sa nidi bato, tiquina wahahye. Tiquina sa wahagʉ̃ asʉ̃ mʉja taropʉ tiquina ihñaria ñahpicoha pehe tiquina pano ʉhmʉ tãducuahye. Sa yero nijinogã tiquiro ijiro bui waro tojoa wahã sahye tia ñahpicoha. ");
INSERT INTO pirNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Sa yeye ñahpicohare ihñañe, tutuaro bucueahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Nijinogã tiquiro ijiri wʉhʉpʉ esa, sajãa wahahye tiquina. Sa sajã saye, nijinogãre tiquiro pacoro mehna ijiriquirogãre ihñahye tiquina. Sa ihñañe tiquina dʉsepe curi mehna quehe sa, tiquirogãre ño peoahye. Ño peo tuhasa tiquina acarire põoahye. Urure, bueyere, mirra wame tiye ehme sitiye gʉ̃hʉre ne wio, tire tiquirogãre wapa marieno ohoahye. ");
INSERT INTO pirNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Tire oho tuhasa carĩa wahahye tiquina. Tiquina sa carĩgʉ̃ quehẽnopʉ Cohãcjʉ̃ yahuahye tiquinare: “Herode cahapʉ tojoeracãhña”, ni yahuahye Cohãcjʉ̃ tiquinare quehẽnopʉre. Tiquiro sa ni yahuri bato, tiquina pehe wahcãhye. Tiquina sa wahcãri bato ape mahapʉ tiquina ya dihtapʉ tojoaa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Tiquina sa wahari bato Cohãcjʉ̃ yaquiro angel quehẽnopʉ Josére bajuaro, ohõ saha niahye: —‍Wahcãña. Herode pehe nijinogãre wejẽno taro, macano nine yojopʉre. Sa ye nijinogãre tiquiro pacoro gʉ̃hʉre Egiptopʉ ʉmʉñano ne duhti cãa wahaya. Topʉre yʉhʉ nidiro punota ijiya, tee yʉhʉ yahugʉ̃pʉ, ni yahuahye angel Josére. ");
INSERT INTO pirNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Tiquiro sa nigʉ̃ tʉhoro, José pehe ñamita wahcã, nijinogãre, tiquiro pacoro gʉ̃hʉre Egiptopʉ ne duhti cãa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Egiptopʉ esa, Herode catiro puno topʉre ijiahye tiquina. Sa yeahye panopʉ cjʉ̃no Cohãcjʉ̃ yere yahu mʉhtariquiro tiquiro ni ojoariro sahata. Tire tiquirore Cohãcjʉ̃ ojoa dutiahye. Ohõ saha ni ojoahye Cohãcjʉ̃ yere: “Egiptopʉ ijiriquirore yʉhʉ macʉre pijiou”, ni ojoahye Cohãcjʉ̃ yere. ");
INSERT INTO pirNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Sa ye ñahpicohare buheyequina tiquina duhti yʉhdʉ cãgʉ̃ tʉhoro Herode pehe usua yʉhdʉa wahahye. Sa usuaro, Belẽ cjẽnare, ti maca dʉhtʉ caha cjẽna gʉ̃hʉre tiquina pohnene ʉmʉagãre pʉa cʉhma cʉoyequinagãre wejẽ bato ti dutiahye tiquiro. Coã warore ñahpicohare buheyequina ñahpicohare tiquina ihñari decore yahuahye Herodere. Tiquina sa nigʉ̃ tʉhoro tiquiro wejẽ duariquirogã masa bajuari decore masino, “Ohõpe cʉhmari cʉore” nino, pʉa cʉhma cʉoyequinagãre wejẽ bato ti dutiahye. ");
INSERT INTO pirNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Panopʉ cjʉ̃no Jeremia Cohãcjʉ̃ yere yahu mʉhtariquiro tiquiro ni ojoariro sahata wahahye. Ohõ saha ni ojoahye tiquiro: ");
INSERT INTO pirNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ramá wame tiropʉ bisirota. Tutuaro bʉjʉa witiye mehna utiye bisirota. Raquel panamena numia iji turiaye numiapʉ Israe masa namosãnumia tiquina pohnene tutuaro utieta. Tiquina pohnene apequina wejẽgʉ̃ ihñañe, ne bʉjʉa witi duhusi”, ni ojoahye panopʉ. ");
INSERT INTO pirNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Sa ye Herode tiquiro yariari bato Egiptopʉ ijiriquirore Josére Cohãcjʉ̃ yaquiro angel quehẽnopʉ bajuahye. Sa bajuaro ohõ saha niahye Josére: ");
INSERT INTO pirNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—‍Nijinogãre wejẽ duamediquina yariaa wahari. Sa yegʉ wahcãña. Tiquirogãre pacoro mehna Israe yehpapʉ ne tojoaa wahaya mʉhʉ, ni yahuahye angel Josére: ");
INSERT INTO pirNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Tiquiro sa nidi bato José wahcã, nijinogãre pacoro mehnata Israe yehpapʉ ne tojoaa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Sa yeperota Arquelao Herode macʉno pehe tiquiro pacʉro camesariquiro ijigʉ̃ tʉhoro José pehe Judea yehpapʉ tojoa duaro cueahye. Sa yero pari turi tja quehẽnopʉ tiquirore yahu nemoahye. Tiquirore pari turi Judea yehpapʉ iji dutierahye. Tiquiro sa ni yahuri bato, tiquina Galilea yehpapʉ wahaa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ti yehpapʉre Nazare wame tiri macapʉ ijiahye tiquina. Sa yeahye tiquina Cohãcjʉ̃ yere yahu mʉhtariquina tiquina ojoariro sahata. Ohõ saha ni ojoahye: “ ‘Cristo Nazare cjʉ̃nota ijire’, nieta masa”, ni ojoahye Cohãcjʉ̃ yere yahu mʉhtariquina panopʉ cjẽna. ");
INSERT INTO pirNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Sa ye ti pjere Ñu Cohãcjʉ̃ yequinare wame yeriquiro ijiahye. Judea yehpapʉ masa marienopʉ tiquiro Cohãcjʉ̃ yere yahu dʉcahye masare. ");
INSERT INTO pirNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ohõ saha ni yahuahye tiquinare: —‍Mʉsa ñañe yerire bʉjʉa witiya. Tire duhuya. Ʉhmʉse cjʉ̃no Cohãcjʉ̃ mʉsa pʉhtoro tiquiro ijiato mehenogã dʉhsare, ni yahuahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Panopʉ cjʉ̃no Isaia Cohãcjʉ̃ yere yahu mʉhtariquiro Ñu tiquiro buheatire ohõ saha ni ojoahye: Masa marienopʉ yahuducu sañuducuriquiro ohõ saha ni buherota tiquiro: “Mari pʉhtoro ahtato pano mahare mari quehnoyuro saha quehnoana ijiyuya mʉsa. Mʉsa ñañe yerire bʉjʉa witiya”, ni sañuducurota, ni ojoahye Isaia Ñure. ");
INSERT INTO pirNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Sa yero Ñu camello poari suhtirore sañariquiro, wahiquiro cahsero mehna tʉã dihoriquiro ijiahye. Poreroare, nʉcʉ cjẽ umi gʉ̃hʉre ihyae tiahye. ");
INSERT INTO pirNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jerusalẽ cjẽna, ijipihtiro Judea yehpapʉ ijiyequina, Jordã wame tiri ma cahapʉ ijiyequina gʉ̃hʉ tiquirore tʉhoye ahtahye. ");
INSERT INTO pirNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Wihi, tiquirore tʉho, tiquina ñañe yerire bʉjʉa witi, Cohãcjʉ̃re tire yahu yʉhdʉahye tiquina. Sa tiquina yahugʉ̃ tʉhoro Jordãpʉ Ñu tiquinare wame yeahye. ");
INSERT INTO pirNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Sa yero peyequina fariseo masa, saduceo masa gʉ̃hʉ Ñure tiquina wame ye dutiye ahtagʉ̃ ihñano tiquiro yahuahye tiquinare: —‍Añaa yero saha ña yʉhdʉana ijire mʉsa. Mʉsa ñañe yerire bʉjʉa witi duerana Cohãcjʉ̃ mʉsa ñañe yeri buhiri tiquiro buhiri dahreato pano duhti masiedare mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Sa yena potota mʉsa ñañene bʉjʉa witiya. Quehnoañene camesaya. Sa yena quehnoañe pehere yeya mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ohõ saha ni tʉhotueracãhña: “Panopʉ cjʉ̃no Abrahã mari ñecʉ mʉnano ijie tiahye. Sa yena tiquiro panamena iji turiana ijina mari Cohãcjʉ̃ yequina ijiaja”, ni, tʉhotueracãhña mʉsa. Mʉsare niita niaja. Abrahã panamena iji turiana ijimene mʉsa. Mʉsa sa ijiepegʉ̃ta ti mʉsa sa ijiye dʉhseati ijierare. Cohãcjʉ̃ pehe ahri ʉtã paca mehna Abrahã panamenare dojogʉ̃ ye masine. Sa yero Abrahã panamena iji turiana mʉsa ijiye ihyo waro ijire ʉtã paca ti paca ihyo waro ijiro sahata. ");
INSERT INTO pirNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ohõ saha ijire: Masa yucʉri yero saha ijire. Cohãcjʉ̃ pehe yucʉrire quẽatiare comeare cʉoriquiro yero saha ijire. Sa yero ñañe dʉca tiye cjʉre quẽ cohã, ti nʉhcori gʉ̃hʉre dʉte surerota. Dʉte sure tuhasa, pecapʉ ʉjʉ̃anota tiquiro ti cjʉre, nʉhcori gʉ̃hʉre. Sata yerota masa gʉ̃hʉre tiquirore cahmeeñequinare. ");
INSERT INTO pirNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Yʉhʉ bato yʉhʉ yʉhdʉoro tutuariquiro ahtarota. Quehnoa yʉhdʉariquiro ijire tiquiro. Tiquiro yero saha ijieraja yʉhʉ pehe. Sa yegʉ tiquirore tʉhotugʉ, “Ihyo ijigʉ ijiaja yʉhʉ”, ni tʉhotuaja yʉhʉ. Yʉhʉ pehe mʉsa ñañe yerire bʉjʉa witi duti, mʉsare wame yegʉ aco mehna yemi. Tiquiro pehe yʉhʉ yʉhdʉoro yerota. Espíritu Santore masa mehna ijiducugʉ̃ yerota tiquiro. Sa yero peca ñañene ʉjʉ̃a wero sahata tiquiro ahtariquiro pehe mʉsa ñañe yerire cose werota. ");
INSERT INTO pirNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Yʉhʉ bato ahtariquiro cahseri cohãriquiro yero saha ijire. Cahseri cohãriquiro tiquiro batiro mehna ijipihtiye trigo cahserire puti were. Tiquiro sa puti weri bato trigo pehere tiquiro ihbori wʉhʉpʉ ihborota. Sata yerota tiquina ñañene bʉjʉa witiyequinare yʉhʉ bato ahtariquiro. Tiquiro puti weye cahseri pehere tiquiro ʉjʉ̃anota. Ti peca ʉjʉ̃ari peca ne yatisi. Sata yerota tiquiro yʉhʉ bato ahtariquiro tiquina ñañene bʉjʉa witieyequinare, ni yahuahye Ñu. ");
INSERT INTO pirNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Came Jesu Galileapʉ ijiriquiro waha, Jordã wame tiri mapʉ buha sahye Ñure wame ye dutiro. ");
INSERT INTO pirNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Coã warore Ñu wame ye dueramahye. —‍Yohou, mʉhʉ pehe yʉhʉ yʉhdʉoro tutuagʉ yʉhʉ pehere mʉhʉ wame yegʉ̃ quehnoaboaga. Mʉhʉre wame yebogʉ ijieraja yʉhʉ, ni yʉhtimahye Ñu Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesu pehe yʉhtiahye tiquirore: —‍Yʉhʉre wame yeya. Ohõ saha yena, Cohãcjʉ̃ dutiro saha sohtoa tina niaja mari, niahye Jesu. Tiquiro sa nigʉ̃ tʉhoro, —‍Aʉ, ni yʉhtiahye Ñu. ");
INSERT INTO pirNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Sa ni tuhasa, Jesure wame yeahye. Tiquiro wame ye tuhasagʉ̃ Jesu diapʉ ducuriquiro maja dʉcahye. Tiquiro maja dʉcagʉ̃, ʉhmʉanopʉ parĩ maahye. Cohãcjʉ̃ yaquiro Espíritu bujua yero saha tiquiro bui dijia tagʉ̃ ihñahye. ");
INSERT INTO pirNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Sa dijia tagʉ̃ ʉhmʉanopʉ yahuducuye bisiahye: —‍Ahriquiro yʉhʉ macʉ yʉhʉ cahĩniquiro ijire. Tiquiro mehna tutuaro bucueja, niahye ʉhmʉanopʉ. ");
INSERT INTO pirNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Sa ye Espíritu Santo pehe Jesure masa marienopʉ neahye, topʉ watĩno tiquirore ñañene ye dutiato saha. ");
INSERT INTO pirNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Topʉ esaro cuarenta decori waro ihyaro marieno ijiahye Jesu. Sa yero ʉjʉa ahbahye. ");
INSERT INTO pirNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ʉjʉa tiquirore ahbagʉ̃ ihñano watĩno pehe tiquiro cahapʉ esaro, ohõ saha niahye: —‍Mʉhʉ Cohãcjʉ̃ macʉ ijigʉ, ahria ʉtãre ihyaye dojomehneña, nimahye tiquiro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesu ohõ saha ni yʉhtiahye: —‍Yeraja. Cohãcjʉ̃ yere tiquina ojoari pũpʉ ohõ saha nine: “Masare ihyaye mehna dihita catieraro cahmene. Ijipihtiye Cohãcjʉ̃ tiquiro ye yahuye mehna ijiro cahmene”, nine Cohãcjʉ̃, ni yʉhtiahye Jesu watĩnore. ");
INSERT INTO pirNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tiquiro sa ni yʉhtiri bato watĩno pehe Jerusalẽpʉ “Cohãcjʉ̃ ya maca” tiquina nidi macapʉ Jesure neahye. Topʉ esa, Cohãcjʉ̃ ya wʉhʉ bui Jesure ne sahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ne sa tuhasa, tiquirore ohõ saha nimahye: —‍Cohãcjʉ̃ yere tiquina ojoari pũ ohõ saha nine: “Cohãcjʉ̃ tiquiro yequina angelere mʉhʉre ihña ihbo dutirota. Sa yeye tiquina pehe mʉhʉre ihña ihboeta ‘Ʉtãpʉ pʉha tu maari,’ niñe”, nine tiquiro ojoari pũ. Tiquiro sa nidi poto ijigʉ̃ mʉhʉ Cohãcjʉ̃ macʉ ijigʉ yehpapʉ uhpu dijia ihñoña yʉhʉre. Mʉhʉre tiquina yedohogʉ̃ ihñoña yʉhʉre, nimahye watĩno. ");
INSERT INTO pirNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesu uhpu dijia ihño dueraro ohõ saha ni yʉhtiahye: —‍Cohãcjʉ̃ yere tiquina ojoari pũ ohõ saha nine: “Mʉsa pʉhtoro Cohãcjʉ̃ tiquiro nidire ‘¿Poto ijiajari?’ ni masi duana Cohãcjʉ̃re ye ihño duti tuhueracãhña”, nine Cohãcjʉ̃ yere tiquina ojoari pũ, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Tiquiro sa ni yʉhtiri bato ʉhmʉa yʉhdʉdʉ cʉnʉpʉ Jesure ne mʉjahye watĩno tja. Tʉ buipʉ ne mʉja sa pje, ijipihtiye macarine ihñodoque dijioahye Jesure. Tiquina cʉoye gʉ̃hʉre ihñoahye. ");
INSERT INTO pirNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Sa ihñono Jesure ohõ saha nimahye: —‍Yʉhʉre dʉsepe curi mehna quehe sa, ño peoya mʉhʉ. Mʉhʉ sa yegʉ̃ ijipihtiye ahri macarine mʉhʉre ohoutja, ni yahumahye watĩno. ");
INSERT INTO pirNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Tiquiro sa nigʉ̃ Jesu ohõ saha ni yʉhtiahye: —‍Satana, wahaya mʉhʉ. Ohõ saha nine Cohãcjʉ̃ yere tiquina ojoari pũ: “Mʉhʉ pʉhtoro Cohãcjʉ̃ dihitare ño peoya. Tiquiro ye dutiye dihitare yeya”, nine Cohãcjʉ̃ yere tiquina ojoari pũ, niahye Jesu watĩnore. ");
INSERT INTO pirNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Tiquiro sa nigʉ̃ tʉhoro watĩno wahaa wahahye. Tiquiro wahari bato angele pehe wihi, Jesure yedohoye ihyayere ohoahye angele. ");
INSERT INTO pirNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Sa ye Ñure peresupʉ tiquina yegʉ̃ tʉhoro, wahaa wahahye Jesu. Waha, Galilea yehpapʉ esahye. ");
INSERT INTO pirNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Topʉ ijiri macapʉ Nazarepʉ waha, yʉhdʉ cã, Capernau wame tiri macapʉ esahye. Galilea wame tiri ditara dʉhtʉ cahapʉ ijiri Capernau. Ti maca Zebulón yehpa cahapʉ, Neftalí yehpa cahapʉ ijiri Capernau. Topʉ esa, ijiahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Sata yeahye Jesu panopʉ cjʉ̃no Cohãcjʉ̃ yere yahu mʉhtariquiro Isaia tiquiro ni ojoariro sahata. Ohõ saha ni ojoahye: ");
INSERT INTO pirNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Zebulón yehpa cahapʉ, Neftalí yehpa cahapʉ, ditarapʉ wahari mahapʉ, Jordã wame tiri ma ape sie pahrẽpʉ Galilea yehpa ijire. Ti yehpa judio masa ijieyequina ya yehpa ijire. ");
INSERT INTO pirNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","To cjẽna Cohãcjʉ̃ yere quehnoano masiedare. Sa masiedapeta quehnoariquirore ihñañepʉ masieta. Tiquina pehe Cohãcjʉ̃re ne masiedare. Sa yeye pecapʉ wahaboriquina ijimahye. Sa yero ihcãquiro tiquinare Cohãcjʉ̃ yere masigʉ̃ yerota, ni ojoahye Isaia. ");
INSERT INTO pirNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Topʉ ijiro, Cohãcjʉ̃ yere yahu dʉcahye Jesu: —‍Mʉsa ñañe yerire bʉjʉa witiya. Sa yena quehnoañene camesaya. Ʉhmʉse cjʉ̃no Cohãcjʉ̃ ijipihtiyequina pʉhtoro tiquiro ijiato mehenogã dʉhsare, ni yahu dʉcahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Sa ye Galilea wame tiri ditara dʉhtʉ cahapʉ esaro, Simore, tiquiro bahʉro Andre mehna boca sahye Jesu. Simo tiquina Pedro ni pisuriquiro ijiahye. Tiquina pehe wahi wejẽñequina ijiye, tiquina wẽñecjʉre doque ñoñe niahye ditarapʉ. ");
INSERT INTO pirNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","—‍Yʉhʉ mehna cjãna ijianaja ahtaya mʉsa. Yʉhʉ mehna mʉsa ahtagʉ̃ mʉsa wahire ñehe cahmecoana mʉsa ijiro saha, Cohãcjʉ̃ yequina ijiatiquinare masare piji cahmecoana ijigʉ̃ yeitja mʉsare. Yʉhʉ mehna mʉsa ahtagʉ̃ sa yeanajare cũtja mʉsare, niahye tiquiro tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Tiquiro sa nigʉ̃ tʉhoyeta tiquina wẽñecjʉre cũ cã, tiquiro mehna wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Sa ye Jesu tiquina mehna yʉhdʉ cã, Santiagore tiquiro bahʉro Ñu gʉ̃hʉre boca sahye tja. Tiquina Zebedeo pohne ijiri. Tiquina yaria yucʉsapʉ tiquina pacʉro mehna tiquina wẽñecjʉre quehnoñe niahye. Tiquina pʉarore tiquiro pijioahye. ");
INSERT INTO pirNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Tiquiro sa pijiogʉ̃ tʉhoye, tiquina pehe duita tiquina pacʉrore, yucʉsa gʉ̃hʉre cũ, Jesu mehna wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Sa ye ijipihtiropʉ Galilea yehpare Jesu buhe tinidi. Judio masa mari buheye wʉhʉsepʉ quehnoañe buheyere, ʉhmʉse cjʉ̃no tiquiro pʉhtoro ijiye tiyere buheri. Tiquinare buhe, dohatiyequinare quehnoa wahagʉ̃ yero, ijipihtiye dohatiyere yʉhdʉori tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Tiquiro sa yegʉ̃ tʉhoye Siria yehpa cjẽna ijipihtiropʉ ti yehpapʉ ijiyequina tiquirore masi dʉcari. Sa masiñe, sijoro saha ijiye dohatiye cʉoyequinare, watĩare cʉoyequinare, ñama yariaye cʉoyequinare, tini masieñequina gʉ̃hʉre ne sari. Sa yero ijipihtiyequina tiquinare yʉhdʉgʉ̃ yeri Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Tiquiro sa yegʉ̃ ihñañe, Galilea yehpa cjẽna, Decapoli cjẽna, Jerusalẽ cjẽna, Judea yehpa cjẽna, Jordã ape sie pahrẽ cjẽna peyequina masa tiquiro mehna wahari. ");
INSERT INTO pirNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Sa ye masa peyequina tiquiro cahapʉ tiquina esagʉ̃ ihñano Jesu cʉnʉpʉ mʉjaa wahahye. Mʉja sa, topʉ dujiahye. Topʉ dujigʉ̃ tiquiro buheyequina tiquiro cahapʉ esahye. ");
INSERT INTO pirNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Tiquina esagʉ̃ ihñano ohõ saha ni buhe dʉcahye. ");
INSERT INTO pirNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—‍Tiquina ñañene bʉjʉa witiyequina Cohãcjʉ̃re cahmeñequina bucueyequina ijire. Ʉhmʉse cjʉ̃no tiquiro pʉhtoro ijiropʉre wahaeta tiquina. Ʉhmʉse cjẽ tiquina ye ijire. ");
INSERT INTO pirNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Utiyequina gʉ̃hʉ bucueyequina ijire. Tiquinare bucuegʉ̃ yerota mari Pacʉ. ");
INSERT INTO pirNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Apequinare yʉhdʉdʉca dueyequina “Ihyo ijina ijiaja ʉsã”, ni tʉhotuyequina bucueyequina ijire. Cohãcjʉ̃ “Ohoutja”, tiquinare tiquiro nidi yehpare cʉoeta tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Cohãcjʉ̃ dutiro saha ye duayequina, quehnoañene ye duayequina bucueyequina ijire. Cohãcjʉ̃ tiquiro yedohogʉ̃ tiquina quehnoañene yeducueta. ");
INSERT INTO pirNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Apequinare paja ihñañequina bucueyequina ijire. Tiquina sa paja ihñagʉ̃ Cohãcjʉ̃ tiquina gʉ̃hʉre paja ihñanota. ");
INSERT INTO pirNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Tiquina ñañene cosenohriquina bucueyequina ijire. Cohãcjʉ̃re ihñaeta tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Apequinare cahmequedagʉ̃ yeyequina bucueyequina ijire. Tiquinare “Yʉhʉ pohna ijire”, ninota Cohãcjʉ̃. ");
INSERT INTO pirNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Cohãcjʉ̃ dutiyere tiquina yeri buhiri apequina ñano yere Cohãcjʉ̃ tiquiro dutiriquinare. Tiquina sa ñano yegʉ̃ bucueyequina ijire tiquina pehe. Ʉhmʉse cjʉ̃no tiquiro pʉhtoro ijiropʉ tiquiro yere cʉoeta tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Yeere mʉsa yeri buhiri apequina mʉsare tiquina tuhtiepegʉ̃ta bucuena ijire mʉsa. Mʉsare tiquina ñano yepegʉ̃ta bucuena ijire mʉsa. Yeequina mʉsa ijiri buhiri mʉsare ijipihtiye ñañe tiquina quiti dojomehnepegʉ̃ta tiquina ni mehoepegʉ̃ta bucuena ijire mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Cohãcjʉ̃ yere yahu mʉhtariquinare mʉsa pano ijiriquinare tiquinapʉreta ñano ye mʉhtahye. Tiquinare yeriro sahata mʉsa gʉ̃hʉre apequina sa yegʉ̃ bucueya. Quehnoano jeripohna tiya. Sa yero ʉhmʉsepʉ mʉsa esagʉ̃ pajiro quehnoano yerota mʉsare Cohãcjʉ̃, ni yahuahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Sa ye Jesu buhe nemoahye: —‍Moa mehna wahiquiro dihire ti ñano wahaeragʉ̃ yero sahata mʉsa pehe yeequina pehe ijipihtiyequina apequinare ñañene tiquina ye dueragʉ̃ yere. Sa ijieperota moa pehe ti ñañe wahagʉ̃ pari turi quehnoañe ye masiedare. Ti moa ne quehnoaedare. Ti sa wahagʉ̃ ti moare cohãno cahmene. Ti moare cohãri bato ti bui masa cʉhta cũre. Ne dʉhseati ijierare ti moa tiquiro cohãñe. (Ti dʉhseati ijieraro saha ijieracãhña mʉsa. Cohãcjʉ̃ ye pehere cohãedacãhña,) ni yahuahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Sa ye tiquiro buhe nemoahye: —‍Buhrioro marine ihñagʉ̃ yero sahata mʉsa pehe yeequina pehe ahri yehpa cjẽnare Cohãcjʉ̃re masigʉ̃ yere. Cʉnʉ bui ijiri macare nʉono basioerare. ");
INSERT INTO pirNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Sa ye sihãriare masa sihãñe, sutu docapʉ moha dapo masiedare. Tiare sihãriare ʉhmʉanopʉ duhu peore ti wʉhʉ cjẽna ijipihtiyequina tiquina ihñatiare. ");
INSERT INTO pirNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ohõ sahata mʉsa gʉ̃hʉ buhrioro yero saha ijina, quehnoañene yeya. Mʉsa sa yegʉ̃ ihñañe masa mari Pacʉ ʉhmʉse cjʉ̃nore ño peo, “Tutuagʉ, quehnoagʉ ijire”, nieta, ni yahuahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Sa ni tuhasa, tiquinare yahu nemoahye: —‍Ahrire mʉsa masigʉ̃ cahmeaja yʉhʉ. Cohãcjʉ̃ dutiyere Moisere tiquiro cũrire, tiquiro yere yahu mʉhtañequina tiquina ojoari gʉ̃hʉre cohãgʉ tagʉ niedʉ. Ti dutiyere mʉsare quehnoano yahu potou tʉʉ nii. Ti dutiyere poto ijigʉ̃ ihñou ahtaʉ. Ti dutiye nidiro sahata ye sohtori tii tʉʉ nii. ");
INSERT INTO pirNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ijirota mʉsare niaja. Pihtiri deco pano ijinigʉ̃ Cohãcjʉ̃ dutiye Moisere tiquiro cũrire ne mehenogã cohãsi mari. Ahri yehpa, ʉhmʉse gʉ̃hʉ ti ijiro puno tiquiro dutiye gʉ̃hʉ ijirota. ");
INSERT INTO pirNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Sa yeye ti dutiyere ihquẽquina yʉhdʉdʉcaye, apequinare sata ye dutiye, ʉhmʉse cjʉ̃no tiquiro pʉhtoro ijiropʉ cahacjẽna yero saha ijieta. Ihcã dutirogã ijiepegʉ̃ta tiquina yʉhdʉdʉcaye, cahacjẽna yero saha ijieta tiquina. Apequina ti dutiyere quehnoano yeye, apequinare tiquina yero saha ye dutiye, ʉhmʉse cjʉ̃no tiquiro pʉhtoro ijiropʉ pʉhtoa yero saha ijieta tiquina pehe. ");
INSERT INTO pirNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Mʉsare niita niaja yʉhʉ. Judio masare buheyequina, fariseo masa gʉ̃hʉ Cohãcjʉ̃ cahmeñene queoro yerare. Tiquina yʉhdʉoro Cohãcjʉ̃ cahmeñene yeya mʉsa. Mʉsa sa yerana, tiquiro pʉhtoro ijiropʉre ne esasi mʉsa, ni yahuahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Sa ni tuhasa, tiquinare yahu nemoahye: —‍Panopʉ cjẽna ohõ saha ni tiquina yahurire tʉhori jimedi mʉsa: “Masare wejẽdacãhña. Masare wejẽdiquirore tiquina buhiri dahreatiquiro ijire”, tiquina nidire tʉhori jimedi mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ahri tiquina yahuri yʉhdʉo cjũno mʉsare ahri pehere yahu nemoutja. Tiquiro acayʉro mehna usuariquiro pehe tiquina buhiri dahreatiquiro ijire masʉnore wejẽdiquiro yero saha. Tiquiro acayʉrore tuhtiriquiro “Ne tʉho masiñe mariegʉ ijire mʉhʉ”, nidiquiro buhiri dahre dutiyequina cahapʉ tiquina neatiquiro ijire. “Tʉho masiegʉ ijire mʉhʉ”, tiquiro acayʉrore sa nidiquirore pecapʉ wahaboaga tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Mʉsa acayʉro mʉsare tiquiro ihña tuhtigʉ̃ ohõ saha yeya. Cohãcjʉ̃ wʉhʉpʉ Cohãcjʉ̃re mʉsa ño peoato pano, tiquirore wahiquirore mʉsa ohoato pano ohõ saha yeya. ");
INSERT INTO pirNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Cohãcjʉ̃re mʉsa ohoatire duhu cũ, mʉsa acayʉro cahapʉ waha, “Pari turi cahmequedacʉ̃hna. To punota duhuuhna tire”, niña tiquirore. Mʉsa sa nidi bato Cohãcjʉ̃re oho, ño peona wahaya tiquiro ya wʉhʉpʉ. ");
INSERT INTO pirNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Apequiro mʉhʉre yahusã duaro, pʉhtoro masare beseriquiro cahapʉ mʉhʉre tiquiro nea duagʉ̃, tiquiro mehna usuaro marieno ijiya. Beseriquiro cahapʉ tiquiro neato pano tiquiro mehna quehnoano ijiya. Mʉhʉ sa yegʉ̃ ihñano tiquiro mʉhʉre yahusãedaboaga. Mʉhʉ sa quehnoano ijieragʉ̃ ihñano topʉre mʉsa esagʉ̃ tiquiro pehe mʉhʉre masare beseriquirore yahusãnota. Tiquiro sa yahusãgʉ̃, beseriquiro pehe peresu yeyequinapʉre mʉhʉre ohorota. Sa yeye tiquina mʉhʉre peresu yeeta. ");
INSERT INTO pirNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ijirota niaja mʉhʉre. Topʉ ijiniita mʉhʉ. Tee tiquina wapa ye dutirire mʉhʉ wapa ye pehogʉpʉ wijiagʉta mʉhʉ, ni yahuahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ohõ saha ni yahu nemoahye Jesu: —‍Panopʉ cjẽnare ohõ saha tiquina ni yahurire tʉhori jimedi mʉsa: “Apequiro namono mehna ñano yeracãhña”, tiquina nidire tʉhori jimedi mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ahri tiquina yahuri yʉhdʉo cjũno mʉsare ahri pehere yahu nemoutja. Numinore ñehedaperota, ihcãquiro ticorore ñano tutuaro cahmeno, ñano wacũ tʉhoturo, ñano ye tuhasari ticoro mehna. ");
INSERT INTO pirNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Sa yegʉ mʉhʉ capea poto pehepʉ ijiria mehna ñano yegʉ, tiare ore we ne mʉhʉ cohãboriro sahata ti ñañene duhuya. Tire duhueragʉ pecapʉ wahagʉta. Mʉhʉ capeare mʉhʉ cohãgʉ̃ tia capea dihita butire. Mʉhʉ pehere pecapʉ mʉhʉ wahagʉ̃ ña yʉhdʉare. Sa yegʉ ti ñañene duhuya. ");
INSERT INTO pirNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Sa yegʉ mʉhʉ omoca poto pehe ijiri omoca mehna ñano yegʉ, ti omocare mʉhʉ dʉte cohãboriro sahata ti ñañene duhuya. Tire duhueragʉ pecapʉ wahagʉta. Mʉhʉ omocare mʉhʉ cohãgʉ̃ ti omoca dihita butire. Mʉhʉ pehe pecapʉ mʉhʉ wahagʉ̃ ña yʉhdʉare. Sa yegʉ ti ñañene duhuya, ni yahuahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ohõ saha ni yahu nemoahye Jesu: —‍Panopʉ ahri gʉ̃hʉre niahye: “Tiquiro namonore cohã duariquiro tiquiro cohãtire yahuri pũ mehna ticorore cohã masine”, nimahye panopʉ. ");
INSERT INTO pirNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ahri tiquina yahuri yʉhdʉo cjũno mʉsare ahri pehere yahu nemoutja. Tiquiro namono apequiro mehna ñano yericoro ticoro ijierapegʉ̃ta ticoro manʉno ticorore cohãboaga. Ticoro sa cohãnohricoro apequiro mehna omoca dʉhtero, ñano yero niaga ticoro apequiro mehna ijiro. Ticoro manʉno ticorore tiquiro cohãri bato ticorore apequiro mehna ñano yegʉ̃ yere. Sa yero tiquiro bato namo tiriquiro gʉ̃hʉ ticoro mehna ñano yero nine, ni yahuahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ohõ saha ni yahu nemoahye Jesu: —‍Panopʉ cjẽna ohõ saha tiquina ni yahurire tʉhori jimedi mʉsa: “Mʉsa nidiro sahata yeya. ‘Cohãcjʉ̃ mehna poto sa yeitja’ mʉsa nidiro sahata yeya”, tiquina ni yahurire tʉhori jimedi mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ahri tiquina yahuri yʉhdʉo cjũno mʉsare ahri pehere yahu nemoutja. “Ʉhmʉse mehna poto nii niaja”, ni ʉhmʉse mehna wame peoeracãhña. Ʉhmʉse pehe Cohãcjʉ̃ mari pʉhtoro tiquiro ijiro ijire. Ihyo ijiro ijierare. Sa ijigʉ̃ ihñana sa niedacãhña. ");
INSERT INTO pirNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ahri yehpa mehna ne wame peoeracãhña. Ahri yehpa Cohãcjʉ̃ ya yehpa ijire. Sa ijigʉ̃ ihñana sa niedacãhña. Jerusalẽ mehna ne wame peoeracãhña. Tutuariquiro mari pʉhtoro ya maca ijire Jerusalẽ. Ihyo ijiri maca ijierare. Sa ijigʉ̃ ihñana sa niedacãhña ti wamene. ");
INSERT INTO pirNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","“Yʉhʉ dapu mehna poto nii niaja”, ni wame peoeracãhña. Mʉsa poari yehseye poari wahagʉ̃ ye masiedare mʉsa. Ti poarire ñiñe wahagʉ̃ gʉ̃hʉre ye masiedare mʉsa. Sa ye masiena “Yʉhʉ dapu mehna poto nii niaja”, ni wame peoeracãhña. ");
INSERT INTO pirNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","“Yenatja”, nina wame peoro marieno ohõ saha dihita tire niducuya. “Yesi”, nina gʉ̃hʉ wame peoro marieno niducuya. Mʉsa wame peo nina, watĩno ñariquiro dutiro saha yena niaga, ni yahuahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ohõ saha ni yahu nemoahye Jesu: —‍Panopʉ ohõ saha tiquina ni yahurire tʉhori jimedi mʉsa. “Mʉhʉre apequiro mʉhʉ capeare tiquiro quẽ tihãriro sahata mʉhʉ gʉ̃hʉ tiquirore quẽ tihã cahmeña. Mʉhʉ upiriare tiquiro quẽ nuhariro saha mʉhʉ gʉ̃hʉ quẽ nuha cahmeña”, tiquina nidire tʉhori ijimedi mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Tiquina yahuri yʉhdʉo cjũno ahri pehere yahu nemoutja mʉsare. Mʉhʉre ñano yeriquirore sa ihña cãhña. Ihcã pehe mʉhʉ wahsupure tiquiro quẽgʉ̃, ape sie gʉ̃hʉre quẽ dutiya tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Apequiro buhiri dahre dutiriquirore mʉhʉre tiquiro yahusãgʉ̃, dutiriquiro pehe mʉhʉ camisare mʉhʉre yahusãriquirore oho dutiboaga. Tiquiro oho dutigʉ̃, tiquirore ohoya. Mʉhʉ bui cjã suhtiro gʉ̃hʉre oho nemoña tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Apequiro surara apee borore ihcã kilómetro mʉhʉre tiquiro nea basa dutigʉ̃, ape kilómetrore waha nemoña tja. ");
INSERT INTO pirNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mʉhʉre sinidiquirore ohoya. Sa yegʉ apequiro mʉhʉre waso dutigʉ̃ wasoya tiquirore, ni yahuahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ohõ saha ni yahu nemoahye Jesu: —‍Masa ohõ saha nine: “Mʉsa mehna cjẽnare cahĩña. Sa yena mʉsare ihña tuhtiyequinare ihña tuhti cahmeña tja”, tiquina nidire tʉhori jimedi mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Tiquina yahuri yʉhdʉo cjũno ahri pehere yahu nemoutja mʉsare: Mʉsare ihña tuhtiyequinare cahĩña. Mʉsare ñano yeyequinare tiquina ye ijiatire Cohãcjʉ̃re sini basaya. ");
INSERT INTO pirNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Mʉsa sa yena mari Pacʉ ʉhmʉse cjʉ̃no pohna ijire mʉsa. Cohãcjʉ̃ pehe ihcãno saha yere masare. Ñañequina gʉ̃hʉre quehnoañequina gʉ̃hʉre asʉ̃ asigʉ̃ yere tiquiro. Sa yero Cohãcjʉ̃ dutiyere yeyequina gʉ̃hʉre, yeeyequina gʉ̃hʉre acoro ahtagʉ̃ yere tiquiro. Masare ihcãno saha tiquiro yeriro sahata mʉsa gʉ̃hʉ yeya. ");
INSERT INTO pirNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Mʉsare cahĩñequina dihitare mʉsa cahĩgʉ̃ ti ne dʉhseati ijierare. Wapa ne cohteyequina gʉ̃hʉ sata yere. Sa yena ijipihtiyequinare cahĩña. ");
INSERT INTO pirNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Mʉsa acaye dihitare mʉsa quehnoano piti cagʉ̃ ti ne dʉhseati ijierare. Cohãcjʉ̃re masieñequina gʉ̃hʉ sata yere. Sa yena ijipihtiyequinare quehnoano piti caya. ");
INSERT INTO pirNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ñañe mariena ijiya mʉsa. Mari Pacʉ ʉhmʉse cjʉ̃no tiquiro ñañe marieniquiro tiquiro ijiro sahata mʉsa gʉ̃hʉ ñañe mariena ijiya, ni yahuahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Pari turi tiquiro yahu nemoahye: —‍Cohãcjʉ̃ ye ijiatire quehnoañene yena, tire masare “Ohõ saha ijigʉ ijiaja yʉhʉ”, ni ye ihñoedacãhña apequinare. Mʉsa sa ni ye ihñori buhiri quehnoañene mʉsa yeri dʉhseati ijierare. Sa yero Cohãcjʉ̃ ʉhmʉse cjʉ̃no quehnoañene mʉsa yeri wapa mʉsare ohosi. ");
INSERT INTO pirNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Sa yena pejecʉoyequinare yedohona, tire masare ye ihñoedacãhña. Masa tiquina ihñenopʉ yedohoya tiquinare. Sata ihquẽquina ye ihñore mahapʉ ijiyequinare, judio masa mari buheye wʉhʉsepʉ ijiyequina gʉ̃hʉre. Tiquina mari ihñono dihita quehnoano iji mehoñequina ijire. Sa ye ihñore tiquina, “Quehnoañequina ijire ahriquina”, masare ni ihña dutiye. Tiquina sa ni ihñagʉ̃ sa ye ihñoñequina pehe bucue tuhasari. “Quehnoañequina ijire”, ni masa tiquina ño peogʉ̃ bucue tuhasari tiquina. Sa yero Cohãcjʉ̃ pehe ne bucue nemogʉ̃ yesi tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Sa yena pejecʉoyequinare yedohona, masa tiquina ihñenopʉ yedohoya tiquinare. Mʉsa mehna cjẽna mehna ijina tiquina ihñeno pejecʉoyequinare yedohoya. ");
INSERT INTO pirNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Masa tiquina ihñenopʉ mʉsa yedohoepegʉ̃ta Cohãcjʉ̃ pehe ihñare. Sa ihñano mʉsa sa yeri wapa ohorota mʉsare, ni yahuahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Pari turi tiquiro yahu nemoahye: —‍Cohãcjʉ̃re sinina, masa ihñono dihita quehnoano iji mehoñequina yero saha yeracãhña mʉsa. Judio masa mari buheye wʉhʉsepʉ ducu, mahapʉ gʉ̃hʉre ducu, Cohãcjʉ̃re sini ihñore tiquina masare. Sa sini ihñoñe poto masa tiquina ño peoye mehna tiquina bucue tuhasari. ");
INSERT INTO pirNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Cohãcjʉ̃re sinigʉ tagʉ, mʉhʉ ya tucũpʉ biha sajãña. Biha sajã, mari Pacʉ ihñamehneniquirore siniña. Mʉsa sa yegʉ̃ masa marienopʉ mʉsa siniepegʉ̃ta mari Pacʉ mʉsare tʉhorota. Sa tʉhoro mʉsare quehnoano yerota tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Sa yena Cohãcjʉ̃re sinina, tʉhoturo marieno mʉsa sinidireta pari turi sini majare tojoeracãhña. Ohõ sahata yere Cohãcjʉ̃re masieñequina. “Peye tahari ihcãno saha ʉsã sinigʉ̃ Cohãcjʉ̃ ʉsãre tʉhorota”, ni tʉhotumene tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Tiquina yero saha yeracãhña mʉsa. Mʉsa siniato pano mari Pacʉ mʉsa cahmeñene masi tuhasare. ");
INSERT INTO pirNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Sa yena ohõ saha ni siniña mʉsa Cohãcjʉ̃re: Ʉsã Pacʉ, ʉhmʉse cjʉ̃ mʉhʉ quehnoagʉ sa ijiducure. ");
INSERT INTO pirNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Yojopʉre ijipihtiyequina pʉhto ijiya. Ʉhmʉsepʉ mʉhʉ dutiro sahata tiquina yeriro sahata ahri yehpa cjẽna gʉ̃hʉ yeahro. ");
INSERT INTO pirNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Sa yegʉ decoripe ʉsã ihyatire ohoducuya ʉsãre. ");
INSERT INTO pirNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Apequina ʉsãre tiquina ñano yerire ʉsã boaja. Sa yegʉ mʉhʉ gʉ̃hʉ ʉsã ñano yerire boya. ");
INSERT INTO pirNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Sa yegʉ ʉsã ñañene ye duagʉ̃ ʉsã tutuaro cahmegʉ̃ ihñagʉ̃ tire ʉsãre ye dutiegʉta. Sa yegʉ ʉsãre ʉsã ñañene yeragʉ̃ yeya. Mʉhʉ ʉsã pʉhto tutuagʉ sa ijiducugʉta. Ijipihtiyequina mʉhʉre sa ño peoducuahro, ni siniña Cohãcjʉ̃re. ");
INSERT INTO pirNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Apequina mʉsare tiquina ñano yerire mʉsa bogʉ̃ ihñano, mari Pacʉ ʉhmʉse cjʉ̃no gʉ̃hʉ mʉsa ñano yerire borota. ");
INSERT INTO pirNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Sa boeperota apequina mʉsare tiquina ñano yerire mʉsa boaeragʉ̃ mari Pacʉ gʉ̃hʉ mʉsa ñano yerire bosi, ni yahuahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Sa yero tiquiro tiquinare yahu nemoahye: —‍Cohãcjʉ̃re ño peona tana sijina bʉjʉa witiyequina yero saha ye ihñoedacãhña. Sata yere masa ihñono dihita quehnoano iji mehoñequina. Tiquina wʉhdoa paca bʉjʉa witiyequina yero saha ijire. Tiquina sa ijiyequina ijigʉ̃ tiquina sijigʉ̃ ihña masine masa. Ijirota mʉsare nii niaja. Masa tiquinare ño peogʉ̃ cahmene tiquina. Sa yeye tiquinare tiquina ño peogʉ̃ ihñañe bucue tuhasari. Cohãcjʉ̃ pehe tiquirore tiquina ño peori wapa tiquinare bucuegʉ̃ yesi. Sa yena tiquina yero saha ye ihñoedacãhña mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Mʉsa sijina, mʉsa poarire aco mehna wa peo wʉhapo peoya. Sa yena mʉsa wʉhdoa pacare coseya. ");
INSERT INTO pirNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Mʉsa sa yegʉ̃ mʉsa sijigʉ̃ ihña masisi masa. Cohãcjʉ̃ dihita mʉsa sijiyere ihña masinota. Mʉsa sehsaro mʉsa ijigʉ̃ tiquiro mʉsa mehna sa ijiducure. Sa ihñano tiquiro mʉsare quehnoano yerota tiquirore mʉsa ño peori wapa, ni yahuahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Sa yero tiquiro yahu nemoahye: —‍Ahri yehpa cjẽne ne cahmecoedacãhña. Ohõ cjẽ ahbaa wahaboaga. Ti ahbaeragʉ̃ yaqueriquiro neboaga tire. Tiquiro yaqueragʉ̃ mecasia tʉaboaga. Sa yero ahri yehpa cjẽ butiaro cuarĩne. Sa yena ahri yehpa cjẽne tutuaro cahmedacãhña. ");
INSERT INTO pirNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ʉhmʉse cjẽ pehere cahmeña mʉsa. Ʉhmʉse cjẽne mecasia tʉa masiedare. Topʉ mʉsa cʉoye ne ahbaerare. Topʉre yaqueriquiro ne masiedare. Sa yena ʉhmʉse cjẽne cahmeña mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Topʉ mʉsa cʉoye ijigʉ̃, ʉhmʉse cjẽne Cohãcjʉ̃ yere tutuaro wacũre mʉsa, ni yahuahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Sa yero ohõ saha ni yahu nemoahye tiquinare: —‍Sihãria quehnoano buhriogʉ̃ mari quehnoano ihña masino sahata quehnoañene tʉhotuye mehna quehnoano ye masinata mʉsa. Mʉsa tʉhoturo sahata yere mʉsa. Quehnoañene tʉhotuna quehnoano yere mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Quehnoañene tʉhotuerana ñañene yere mʉsa. Mʉsa ñañe dihitare mʉsa tʉhotuducugʉ̃ ti ñañe pehe ña yʉhdʉye ijire, ni yahuahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Sa yero tiquiro yahu nemoahye tiquinare: —‍Ihcãquiro Cohãcjʉ̃ pehere wacũno, tutua yʉhdʉaro niñeru pehere wacũedare. Niñeru pehere tutua yʉhdʉaro wacũno Cohãcjʉ̃ pehere wacũedare. Niñeru dihitare cahmediquiro ijiro Cohãcjʉ̃re bucuegʉ̃ yerare. Cohãcjʉ̃ gʉ̃hʉre, niñeru gʉ̃hʉre pʉarore cahme yʉhdʉdʉcaro basioerare mʉsare. ");
INSERT INTO pirNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Sa yegʉ ahrire mʉsare nii niaja: Mʉsa ihyayere, sihniñene, suhti gʉ̃hʉre pajiro bʉjʉa witi tʉhotueracãhña. Mʉsare bajumehneno ihyayere ihyatina dihitare suhti sañatina dihitare Cohãcjʉ̃ yerari mʉsare. ");
INSERT INTO pirNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Minicjʉa parire Cohãcjʉ̃ tiquiro ihña ihboyere masiña mʉsa. Tiquina weseri marieñequina ijire. Sa yeye ihyayere tiquina ihboye wʉhʉse tiquinare mariedare. Mari Pacʉ pehe tiquinare tiquina ihyatire ohore. Minicjʉa yʉhdʉoro mʉsa pehere cahĩne Cohãcjʉ̃. Sa yero mʉsa gʉ̃hʉre ihña ihborota tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Pajiro mʉsa tʉhotuye mehna ti mʉsare ihcã hora cati nemogʉ̃ yerare. Sa yero mʉsa pajiro tʉhotuye dʉhseati ijierare. ");
INSERT INTO pirNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’Sa yena mʉsa suhti sañatire pajiro bʉjʉa witi tʉhotueracãhña. Nʉcʉ cjẽ cohori ti cohoyere tʉhotuya. Ti cohori ti basi suhtire yerare. Sa yerapeta ti cohori quehnoañe suhti yero saha quehnoañe cohori bajure. ");
INSERT INTO pirNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Salomo mʉnano quehnoañe suhtire sañariquiro tiquiro ijiepegʉ̃ta ti cohori pehe tiquiro yʉhdʉoro quehnoa yʉhdʉaye cohori waro ijire. ");
INSERT INTO pirNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Cohorire quehnoañe cohori yere Cohãcjʉ̃ pehe. Ti cohori pehe meheñe decorigã ijiducu ñai bora dijiaa wahare. Mehenogã iji, ape decopʉ pecapʉ ʉjʉ̃a wahare. Sa ijiepegʉ̃ta cohorire quehnoañe cohori ijigʉ̃ yere Cohãcjʉ̃. Sa yero Cohãcjʉ̃ cohorire tiquiro quehnoañe cohori tiquiro yeriro yʉhdʉoro mʉsa gʉ̃hʉre quehnoano yerota. Suhtire ohorota. Cohãcjʉ̃re mehenogã wacũ tutuare mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Sa yena mʉsa ihyatire, mʉsa sihniatire, mʉsa suhti sañatire pajiro bʉjʉa witi tʉhotueracãhña. ");
INSERT INTO pirNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Cohãcjʉ̃re cahmeeñequina pehe tire sa macaducuye nine. Mari Pacʉ ʉhmʉse cjʉ̃no ijipihtiye mʉsa cahmeñene masine. Tiquiro sa masigʉ̃ pajiro bʉjʉa witi tʉhotueracãhña. ");
INSERT INTO pirNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Cohãcjʉ̃ mʉsa pʉhtoro tiquiro ijiatore cahme mʉhtaña mʉsa. Ijipihtiye apee boro yʉhdʉoro tiquirore cahmeña mʉsa. Quehnoañene tiquiro ye dutiye gʉ̃hʉre cahmeña. Mʉsa sa yeri bato Cohãcjʉ̃ pehe mʉsa cahmeñe dʉhsagʉ̃ ohorota. ");
INSERT INTO pirNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Sa yena ñamiapʉre mʉsa dʉhse wahatore pajiro bʉjʉa witi tʉhotueracãhña. Ñamiare mʉsa ñano yʉhdʉgʉ̃ Cohãcjʉ̃ yedohorota mʉsare. Miare mʉsa ñano yʉhdʉato iji tuhasare. Sa yena mia cjẽ dihitare tʉhotuya. Ape deco cjẽne pajiro bʉjʉa witi tʉhotu nemoedacãhña. Cohãcjʉ̃ pehe mʉsare yedohorota, ni yahuahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Sa yero tiquiro tiquinare yahu nemoahye: —‍Apequinare “Ñañequina ijire”, niedacãhña mʉsa. Mʉsa sa niedagʉ̃ Cohãcjʉ̃ mʉsare “Ñana ijire”, nisi. ");
INSERT INTO pirNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Apequinare “Quehnoano yerare”, mʉsa ni ihñano sahata Cohãcjʉ̃ pehe mʉsa gʉ̃hʉre sata ni ihñanota. ");
INSERT INTO pirNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mari queoye mehna mari buhegʉ̃ ohõ saha yena ijire mʉsa. Mʉsa acayʉro tiquiro capeapʉ meheni pohcarogã sajãgʉ̃ ti pohcarogãre quehnoano ihñare mʉsa. Mʉsa ya capea pehere pajiri pjĩ ijiepegʉ̃ta ti pjĩne ne ihñedare mʉsa. Meheni pohcarogãre mʉsa ihñano saha mʉsa acayʉro tiquiro ñano yeye pehere quehnoano ihñare mʉsa. Mʉsa basi mʉsa ñañene tutuaro yepenata tire masiedare mʉsa, pajiri pjĩne mʉsa ihñeno saha. ¿Dʉhse ijiro boro sa ijiajari mʉsa? ");
INSERT INTO pirNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ohõ saha nibona ijire mʉsa: “Yʉhʉ acayʉ, ñañene yei nine mʉhʉ. Sa yegʉ tire duhuya”, nibona ijire mʉsa. Sa nibona ijiepenata pajiro ñañene yere mʉsa. ¿Dʉhsena mʉsa ñañene yepenata tire masiedajari mʉsa? ");
INSERT INTO pirNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Masa tiquina ihñono dihita quehnoano iji mehona ijire mʉsa sa yena. Pajiri pjĩne mʉsa capeapʉ ijiri pjĩne mʉsa ne mʉhtaboriro sahata mʉsa ñano yeye pehere duhu mʉhtaña. Mʉsa sa yeri bato mʉsa acayʉro tiquiro ñano yeyere duhugʉ̃ ye masiboaga, meheni pohcarogãre mʉsa neboriro sahata. ");
INSERT INTO pirNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Diayea yero saha ijiyequina, yesea yero saha ijiyequina gʉ̃hʉ ñañequina Cohãcjʉ̃ yere quehnoa yʉhdʉyere tiquina ño peoerare. Tiquina pehere yahueracãhña. “Tiquina bʉjʉpe, ñano niari”, nina, yahueracãhña tiquinare, ni yahuahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Sa yero tiquiro tiquinare yahu nemoahye: —‍Cohãcjʉ̃re siniña mʉsa. Sinina mʉsa nenata. Mʉsa sinidire bocanata. Tiquirore sa siniducuya mʉsa. Mʉsa sa yegʉ̃ tiquiro mʉsare ohorota. ");
INSERT INTO pirNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ijipihtiyequina Cohãcjʉ̃re siniñequina neeta. Sa yeye tiquina sinidire bocaeta. Sa yero ijipihtiyequina Cohãcjʉ̃re sa siniducuyequinare tiquiro tiquinare ohorota. ");
INSERT INTO pirNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’¿Mʉsa pohna pãgãre mʉsare tiquina sinigʉ̃ ʉtã pehere ohoboagari mʉsa tiquinare? Ne ohosi. ");
INSERT INTO pirNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿Mʉsa pohna wahire mʉsare tiquina sinigʉ̃ aña pehere ohoboagari mʉsa tiquinare? Ne ohosi. ");
INSERT INTO pirNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mʉsa ñana ijiepenata mʉsa pohnare quehnoañene ohoe tiri mʉsa. Sa yero Cohãcjʉ̃ pehe mʉsa yʉhdʉoro quehnoañene ohore mʉsare tiquiro pohnare tiquirore sininare. Mʉsa pohnare mʉsa ohoriro yʉhdʉoro Cohãcjʉ̃ pehe tiquiro pohnene ohore. ");
INSERT INTO pirNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Apequina mʉsare tiquina quehnoano yegʉ̃ cahmene mʉsa. Tiquinare mʉsa quehnoano yegʉ̃ cahmeno sahata quehnoano yeya tiquina gʉ̃hʉre. Tiquina quehnoano yerapegʉ̃ta mʉsa pehe tiquinare quehnoano yeya. Sata ye dutire Cohãcjʉ̃ dutiye Moisere tiquiro cũripʉ, Cohãcjʉ̃ yere yahu mʉhtariquina tiquina ojoari gʉ̃hʉ, ni yahuahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Sa yero tiquiro yahu nemoahye tiquinare. —‍Ʉhmʉsepʉ Cohãcjʉ̃ cahapʉ waha duana tiquiro yere yero cahmene mʉsare. Sa yena tiquiro yere sa ye macaedacãno cahmene. Meheni sopecahagãpʉ mʉsa sajã duagʉ̃ mijorĩne. Sata mijorĩne Cohãcjʉ̃ cahapʉ mʉsa waha duagʉ̃. Pecapʉ masa tiquina wahagʉ̃ mijoedare. Pajiri sopecahapʉ mari sajãgʉ̃ mijoedare. Ti sopecahapʉ masa tiquina sajãboro saha pecapʉ masa tiquina wahagʉ̃ mijoedare. Sa yeye peyequina masa topʉ wahaye nine. ");
INSERT INTO pirNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Cohãcjʉ̃ cahapʉ mʉsa waha duagʉ̃ mijorĩne. Meheñequinagã masa topʉ wahaeta. Topʉ wahayequina ijipihtiye decori Cohãcjʉ̃ mehna ijiducueta, ni yahuahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Sa yero tiquiro yahu nemoahye tiquinare: —‍Quehnoano yeya. “Cohãcjʉ̃ yere yahu mʉhtana ijiaja”, ni mehoñequinare tʉhoeracãhña mʉsa. Tiquina oveja yero saha usueyequina saha bajumene. Tiquina tʉhotuyepʉ ñañequina ijire tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Tiquina ñano yegʉ̃ ihñana, ñañequina tiquina ijigʉ̃ masinata mʉsa. Tiquina quehnoano yegʉ̃ ihñana quehnoañequina tiquina ijigʉ̃ masinata mʉsa. Pota bʉcʉgʉ ʉhse tõhorine dʉca tierare. Potagʉ higuera pacare dʉca tierare. ");
INSERT INTO pirNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Quehnoadʉ yucʉgʉ quehnoañene dʉca tire. Ñadʉ pehe ñañene dʉca tire. ");
INSERT INTO pirNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Quehnoadʉ yucʉgʉ ñañene ne dʉca tierare. Sa yero ñadʉ quehnoañene dʉca tierare. ");
INSERT INTO pirNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Quehnoañene dʉca tieye cjʉre dʉte cohã cã, pecapʉ ʉjʉ̃anota. Sata yerota Cohãcjʉ̃ tiquiro cahmeñene yerariquinare. ");
INSERT INTO pirNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Sa yena “Cohãcjʉ̃ yere yahu mʉhtana ijiaja”, ni mehoñequinare ohõ saha masinata. Tiquina yerire ihñana, tiquina ni mehoñequina ijigʉ̃ masinata, ni yahuahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Sa yero tiquiro yahu nemoahye tiquinare: —‍Peyequina yʉhʉre “Pʉhto” niñequina ijiepeta ʉhmʉse cjʉ̃no Cohãcjʉ̃ tiquiro pʉhtoro ijiropʉre wahasi tiquina. Yʉhʉ Pacʉ ʉhmʉse cjʉ̃no tiquiro cahmeñene yeyequina dihita tiquiro pʉhtoro ijiropʉre wahaeta. ");
INSERT INTO pirNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Decori pihtigʉ̃pʉre peyequina masa ohõ saha nieta yʉhʉre: “Pʉhto, mʉhʉ yere ʉsã buhei. Mʉhʉ wame mehna watĩare cohãʉ. Sa yena mʉhʉ tutuaye mehna peye bajumehneñene yei ʉsã”, yʉhʉre niñequina ijieta. ");
INSERT INTO pirNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ohõ saha yʉhtiitja tiquinare: “Mʉsare ne masiedaja. Ñañene yena ijire mʉsa. Yʉhʉ cahapʉ ahtaeracãhña”, niitja yʉhʉ tiquinare, ni yahuahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Sa yero tiquiro yahu nemoahye tiquinare: —‍Sa ye ijipihtiyequina ahri yʉhʉ buherire tʉhoriquina yʉhʉ dutiyere yeyequina, quehnoano tʉho masiniquiro wʉhʉ dahreriquiro yero saha ijire tiquina. Tiquiro pehe ʉhcʉãñe coperi sehe, wʉhʉre doco dʉcahye. ");
INSERT INTO pirNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ti wʉhʉre peho tuhasari bato acoro tutuaro ahta, dia mini yʉhdʉa waha, tutuaro wihnono wẽahye. Sa ti tutuaro wẽpegʉ̃ta ti wʉhʉ ʉhcʉãno tiquiro docori wʉhʉ ijiro ne waha sa queherahye. ");
INSERT INTO pirNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Sa yeye ijipihtiyequina yʉhʉ buherire tʉhoepeta yʉhʉ dutiyere yerariquina, tʉho masieniquiro wʉhʉ dahreriquiro yero saha ijire. Tiquiro pehe ti wʉhʉre padʉro buigã doco, quehnoano ye dʉcaerahye. ");
INSERT INTO pirNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ti wʉhʉre peho tuhasari bato, acoro tutuaro ahta, dia mini yʉhdʉa waha, wihnono tutuaro wẽahye. Sa tutuaro wẽno ti wʉhʉ pehere wẽdoque cũ cãhye. Sa yero ti wʉhʉ tutuaro bora sa quehea wahahye, ni yahuahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Tiquiro sa ni buhegʉ̃ tʉhoye, tʉho maria wahahye masa. ");
INSERT INTO pirNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","“Tiquiro potota pʉhtoro ijire. Sa yero quehnoano masi pehoriquiro ijiro marine buhere tiquiro. Mari judio masare buheyequina yero saha buherare”, ni tʉhotuahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesu cʉnʉpʉ buhe dujiriquiro dijiaa wahahye. Tiquiro dijiagʉ̃ ihñañe masa peyequina tiquiro bato wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tiquiro sa wahagʉ̃ ihcãquiro cami bʉcʉ mʉna wihiro tiquirore piti ca, dʉsepe curi mehna quehe sa, tiquirore siniahye. —‍Pʉhto, mʉhʉ yʉhʉre yʉhdʉo duagʉ yʉhdʉoya, niahye. ");
INSERT INTO pirNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Tiquiro sa nigʉ̃ tʉhoro tiquiro omoca mehna Jesu tiquirore ña peoahye. —‍Tire ye duaja. Mʉhʉre yʉhdʉgʉ̃ yeitja, niahye Jesu tiquirore. Tiquiro sa nigʉ̃ta cami bʉcʉ mʉna yatia wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Sa ni tuhasa Jesu tiquirore niahye tja: —‍Yʉhʉ mʉhʉre ohõ saha yerire ne apequinare yahueracãhña. Mʉhʉ pagʉre quehnoari pagʉ waharire pahire ihñogʉ wahaya. Moisere Cohãcjʉ̃ tiquiro cũriro sahata pahire minicjʉare ohoya mʉhʉ yʉhdʉrire masa ijipihtiyequina tiquina masino quehnoano, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Sa ye Jesu Capernau wame tiri macapʉ tiquiro esagʉ̃ cien surara pʉhtoro tiquiro cahapʉ esa, tiquirore tutuaro ohõ saha ni sinidi: ");
INSERT INTO pirNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—‍Pʉhto, yʉhʉ cahacjʉ̃no ne pagʉ tutueriquiro waha masiedaro tiquirore tutuaro purĩgʉ̃ ya wʉhʉpʉ cuñari tiquiro, nidi tiquiro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Tiquiro sa nigʉ̃, —‍Aʉ, tiquiro dohatiyere yʉhdʉogʉ wahaʉtja, nidi Jesu. Tiquiro sa nigʉ̃ ohõ saha nidi surara pʉhtoro: ");
INSERT INTO pirNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","9","—‍Pʉhto, quehnoanota. Wahaegʉta. Yʉhʉ yʉhdʉoro quehnoa yʉhdʉagʉ ijire mʉhʉ. Ya wʉhʉpʉ mʉhʉre sajã ta dutibogʉ ijieraja yʉhʉ. Mʉhʉ masiñe mehna yʉhdʉoya tiquirore. Mʉhʉ sa yegʉ̃ yʉhʉ cahacjʉ̃no quehnoa waharota. Yʉhʉre yʉhʉ bui ijiyequina apequina pʉhtoa dutire. Yʉhʉ gʉ̃hʉ surarare dutiaja. Ihcãquirore “Wahaya”, yʉhʉ nigʉ̃ tiquiro wahare. Apequirore “Ahtaya”, yʉhʉ nigʉ̃ tiquiro ahtare. Yʉhʉ cahacjʉ̃nore “Ahrire yeya”, yʉhʉ nigʉ̃ tire yere. Mʉhʉ gʉ̃hʉ dutigʉta ijire. Sa yero mʉhʉ dutiro sahata tiquiro dohatiriquiro yʉhdʉrota, nidi tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Tiquiro sa nigʉ̃ tʉho maria waharo, peyequina masa tiquiro mehna ijiyequinare ohõ saha nidi Jesu: —‍Ijirota mʉsare niita niaja. Ahriquiro surara pʉhtoro Israe masʉno ijieriquiro Cohãcjʉ̃re tutuaro wacũ tutuare. Tiquiro cahacjʉ̃nore yʉhʉ yʉhdʉgʉ̃ yeatire masi tuhasare. Ne Israe masare ahriquiro yero saha ijiyequinare ihñedaga yʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mʉsare niita niaja. Peyequina ahriquiro yero saha Cohãcjʉ̃re wacũ tutuayequina ijipihtiro cjẽna gʉ̃hʉ ʉhmʉse cjʉ̃no pʉhtoro tiquiro ijiropʉ esa, topʉ ijiyequina mehna ihyaeta. Abrahã, Isaac, Jacob mehna ihyaeta tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Masa apequina pehe Cohãcjʉ̃ tiquiro pʉhtoro ijiropʉ wahaboriquina tiquina ijiepegʉ̃ta ñanopʉ nahitianopʉ cohã cãnota tiquinare. Topʉ tiquiro cohãriquina tutuaro uti, bʉjʉa witiye mehna bahque dihoeta, ni yahuri Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Tire sa ni tuhasa, surara pʉhtorore nidi. —‍Tojoahya mʉhʉ ya wʉhʉpʉ. Mʉhʉ cahacjʉ̃no yʉhdʉrota. “Potota yʉhdʉrota”, ni mʉhʉ tʉhoturiro sahata yʉhdʉrota, nidi Jesu. Sa nigʉ̃ta tiquiro cahacjʉ̃no pehe quehnoa wahari. ");
INSERT INTO pirNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Sa ye Jesu Pedro ya wʉhʉpʉ esa, Pedro mareono dohatigʉ̃ ihñahye tiquiro. Ujuaye tigʉ̃ cuñahye ticoro. ");
INSERT INTO pirNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ticoro sa ijigʉ̃ ihñano ticoro omocare ña peoahye. Tiquiro sa ña peogʉ̃ta ujuaye surua wahahye. Surugʉ̃ tʉhoturo ticoro pehe wahcãdʉca, tiquinare ihyayere peoahye. ");
INSERT INTO pirNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Sa ye ñamicahapʉ peyequina watĩare cʉoyequinare masa ne wihiahye Jesu cahapʉ. Tiquina sa ne wihigʉ̃ ihñano ihcã tahata tiquiro waha dutigʉ̃ watĩa wahaa wahahye. Sa yero ijipihtiyequina dohatiyequina tiquina ne sariquinare yʉhdʉo pehoahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Sata yeahye tiquiro panopʉ cjʉ̃no Cohãcjʉ̃ yere yahu mʉhtariquiro Isaia tiquiro nidiro sahata. Ohõ saha ni ojoahye: “Mari dohatiyere yʉhdʉo cãnota tiquiro. Mari duti tiyere cohã cãnota”, ni ojoahye Isaia Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ape taha Jesu peyequina masa tiquiro cahapʉ tiquina ijigʉ̃ ihñano, ohõ saha nidi. —‍Ape sie pahrẽpʉ isa pehãʉhna, nidi. ");
INSERT INTO pirNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Sa ʉsã pehãto pano mari judio masare buheriquiro Jesu cahapʉ esa, ohõ saha nidi: —‍Buhegʉ, mʉhʉ mehna waha duaja noho mʉhʉ waharopʉ, nidi. ");
INSERT INTO pirNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesu ohõ saha ni yʉhtiri: —‍Ihquẽquina nʉcʉ cjẽna wahiquina tiquina coperi cʉore. Minicjʉa gʉ̃hʉ tiquina suhti cʉore. Yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ pehe yʉhʉ carĩni wʉhʉ cʉoeraja, ni yʉhtiri Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Sa ye apequiro Jesu buheriquiro ohõ saha nidi: —‍Pʉhto, yʉhʉ pacʉ tiquiro yariagʉ̃ yarĩgʉtja. Sa ya tuhasagʉ pũrita mʉhʉ mehna wahagʉtja, nidi tiquiro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesu yʉhtiri: —‍Yʉhʉre cahmeeñequina yariariquina yero saha ijire. Tiquina pehe yariariquinare yaahro. Sa yegʉ mʉhʉ pehe yʉhʉ mehna cjʉ̃ ijiacjʉ ahtaya, nidi tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Sa ni tuhasa yucʉsapʉ sajãri. Sa yena ʉsã tiquiro buhena gʉ̃hʉ tiquiro mehna waha, sajãʉ. ");
INSERT INTO pirNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ti ditarapʉ ʉsã pehãgʉ̃ waro wihnono tutuaro wẽdi. Sa yero pahcõri yucʉsare quẽ mio cãmedi. Sa wihnono wẽpegʉ̃ta Jesu pehe carĩno nidi. ");
INSERT INTO pirNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Sa wahagʉ̃ ihñana ʉsã tiquirore wahcõu. Wahcõ ohõ saha nii: —‍Pʉhto, yʉhdʉoya. Mari minina tana niajʉ́, nii ʉsã. ");
INSERT INTO pirNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ʉsã sa nigʉ̃ Jesu yʉhtiri: —‍¿Dʉhsena cue maca cãri mʉsa? Yʉhʉre wacũ tutuerare mʉsa, nidi Jesu ʉsãre. Sa ninota wahcãdʉca sa, wihnonore pahcõri gʉ̃hʉre “Yʉsʉahya”, nidi. Tiquiro sa nigʉ̃ wihnono yʉhdʉa wahari. Sa ye pahcõri gʉ̃hʉ yʉsʉ dijiaa wahari. ");
INSERT INTO pirNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Tiquiro sa yegʉ̃ ihña acʉana, ohõ saha nii ʉsã: —‍¿Yohou, dʉhse ijiriquiro boro masʉno ijiajari ahriquiro? Ahri wihnono, pahcõri gʉ̃hʉ tiquiro dutigʉ̃ yʉhdʉdʉcaerare tiquirore, nii ʉsã. ");
INSERT INTO pirNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","To bato pehã sa, Gadara cjẽna ya yehpapʉ esaʉ. Topʉ ʉsã esagʉ̃ pʉaro ʉmʉa masa coperi cahapʉ ijiyequina Jesure piti cari. Tiquina watĩare cʉoyequina cuayequina ijiri. Sa yero topʉ masa tiquina wahamehneno ijiri. ");
INSERT INTO pirNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Tiquirore piti ca, sañuducuri: —‍¿Mʉhʉ Cohãcjʉ̃ macʉ dʉhse yegʉ ahtajari mʉhʉ ʉsã cahapʉre? ¿Ʉsãre Cohãcjʉ̃ tiquiro buhiri dahreati pje ijierapegʉ̃ta ʉsãre buhiri dahrei ahtaʉ niajari mʉhʉ? ni sañuducuri tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Tiquina cahapʉ peyequina yesea maca ihyaye nidi. ");
INSERT INTO pirNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Tiquinare ihñañe, watĩa ohõ saha nidi Jesure: —‍Ʉsãre cohãgʉ sisequina cahapʉ waha dutiya ʉsãre. Tiquina mehna iji dutiya ʉsãre, ni sinidi watĩa Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","—‍Aʉ, wahaya, nidi Jesu. Tiquiro sa nigʉ̃ watĩa pʉaro masa mehna ijiriquina waha, yesea cahapʉ esari. Tiquina mehna tiquina ijigʉ̃ta yesea pari, pari cjʉ̃pʉ oma maa buha, ditarapʉ bora ñojoa, mini yaria pihtia wahari. ");
INSERT INTO pirNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Tiquina sa wahagʉ̃ ihñañe yeseare ihña ihboyequina pehe cuea waha, oma maa cãa wahari. Macapʉ esa, yesea tiquina minidire yahu site pehoahye. Watĩare cʉoriquinare Jesu watĩare tiquinapʉre ijiriquinare cohã wiori gʉ̃hʉre yahu pehoahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Sa tiquina yahu siteri bato ti maca cjẽna ijipihtiyequina Jesure ihñañe ahtari. Sa ye tiquirore ihñañe, tutuaro mehna waha dutiri tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Sa ye Jesu yucʉsapʉ sajã, ditarapʉ pehã, tiquiro masari macapʉ esahye. ");
INSERT INTO pirNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Topʉ apequina tini masieniquirore tiquiro cuñari cahsero mehna yo wʉa wihiahye Jesu cahapʉ. “Jesu ahriquirore dohatiyere yʉhdʉgʉ̃ yerota”, ni tʉhotuahye tiquina. Tiquina sa ni tʉhotugʉ̃ masino dohatiriquirore ohõ saha niahye Jesu: —‍Bucueya mʉhʉ. Mʉhʉ ñañe yeyere cohã tuhasaʉ yʉhʉ, niahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Tiquiro sa nigʉ̃ tʉhoye ihquẽquina mari judio masare buheyequina ohõ saha ni tʉhotumahye. “Ahriquiro ihyo ijiriquiro sa nino ‘Cohãcjʉ̃ ijiaja’, nino nine. Sa nino Cohãcjʉ̃re ñano nino nine”, ni tʉhotumahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Tiquina sa ni tʉhotugʉ̃ masino, ohõ saha niahye Jesu: —‍¿Dʉhsena sa ñano tʉhotuajari mʉsa? ");
INSERT INTO pirNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","“Mʉhʉ ñañe yeyere cohã tuhasaja”, yʉhʉ nigʉ̃ “Ni mehogʉ ijire”, nine mʉsa quehnoano masiedapenata. “Wahcãdʉca, wahaya”, yʉhʉ nigʉ̃ tiquiro tinigʉ̃ ihñana, yʉhʉ nidi poto ijigʉ̃ duita mʉsa masinata. ");
INSERT INTO pirNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ ahri yehpapʉ masa tiquina ñañe yeyere cohã masiaja yʉhʉ. Masa tiquina ñañe yeyere cohãcjʉre cũri Cohãcjʉ̃ yʉhʉre. Yʉhʉ sa cohãrire mʉsa masiato saha ohõ sahata ye ihñoutja mʉsa ihñatire, niahye Jesu. Sa ni tuhasa tini masieniquirore ohõ saha niahye: —‍Wahcãdʉcaya. Mʉhʉ cuñari cahserore ne cãhña mʉhʉ ya wʉhʉpʉ, niahye tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Tiquiro sa nigʉ̃ tʉhoro tini masieniquiro wahcãdʉca sa, tiquiro ya wʉhʉpʉ tojoa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Sa wahagʉ̃ ihñañe masa cueahye. Sa ye Jesure Cohãcjʉ̃ tiquiro tutuayere tiquiro ohogʉ̃ ihñañe masa Cohãcjʉ̃re ño peo, quehnoano yahuducuahye. ");
INSERT INTO pirNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Tiquina sa yeri bato Jesu topʉ ijiriquiro ahta, yʉhʉre Mateore boca sari. Pʉhtoa ye ijiatire masare wapa ne cohtegʉ ijimi. Sa yegʉ ti pjere yʉhʉ dahrari tucũpʉ dujii. Topʉ yʉhʉ dujigʉ̃ ihñano ohõ saha nidi yʉhʉre: —‍Yʉhʉ mehna cjʉ̃ ijiacjʉ ahtaya, nidi Jesu yʉhʉre. Tiquiro sa nigʉ̃ tʉhogʉ wahcãdʉca tiquiro mehna wahaʉ. ");
INSERT INTO pirNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Came ya wʉhʉpʉ Jesu gʉ̃hʉ ihyaye ahtari. Peyequina wapa ne cohteyequina, “Ñano yeyequina”, tiquina niñequina gʉ̃hʉ ʉsã mehna ihyari. ");
INSERT INTO pirNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Tiquina mehna ʉsã ihyagʉ̃ ihñañe, fariseo masa ʉsãre Jesu buhenare ohõ saha nidi: —‍¿Dʉhse yero mʉsare buheriquiro wapa ne cohteyequina mehna, ñano yeyequina mehna ihyajari? nidi tiquina ʉsãre tiquiro buhenare. ");
INSERT INTO pirNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","13","Tiquina sa nigʉ̃ tʉhoro Jesu pehe queoye mehna buhero yʉhtiri: —‍Dohatieyequina duturure macaedare. Dohatiyequina dihita duturure macare. Ñañequina dohatiyequina yero saha ijire. Sa yegʉ ñañequina dihitare tiquina ñañene yerire bʉjʉa witi duti, quehnoañe pehere camesagʉ̃ yei ahtaʉ nii yʉhʉ. Tiquina basi “Quehnoana ijiaja ʉsã”, ni tʉhotuyequinare yedohogʉ ahtaerʉ. Cohãcjʉ̃ tiquiro nidire tiquina ojoarire masiña mʉsa. “Wahiquinare mʉsa wejẽ, ʉjʉ̃a mʉoñe mehna yʉhʉre mʉsa ño peogʉ̃ cahmedaja. Apequinare mʉsa paja ihñagʉ̃ pehere cahmeaja”, ni ojoahye. Ahri tiquiro ojoari dʉhse nidire masiña mʉsa. Tire quehnoano buhe nemona wahaya, nidi Jesu fariseo masare. ");
INSERT INTO pirNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Came Ñu wame yeriquiro buheyequina Jesu cahapʉ esa, sinituri: —‍Ʉsã Ñu buhena pehe peye tahari Cohãcjʉ̃re ño peona tana, sijiaja. Fariseo masa gʉ̃hʉ sata sijire. ¿Dʉhse yeye mʉhʉ buheyequina pehe sijierajari? nidi tiquina Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesu tiquiro tʉhotuye mehna queoye mehna buhero taro tiquinare ohõ saha ni yʉhtiri: —‍Ohõ saha ijire ti: Omoca dʉhteropʉ tiquina pijioriquina omoca dʉhteriquiro mehna ijiye, siji masiedare. Sata yʉhʉ buheyequina gʉ̃hʉ yʉhʉ mehna ijiye, siji masiedare. Yʉhʉ omoca dʉhteriquiro yero saha ijiaja. Omoca dʉhteriquiro bose deco tiquiro yegʉ̃ tiquiro mehna cjẽna bʉjʉa witiye mehna ijierare. Sa yeye ihyeyequina ijierare. Yʉhʉ Pacʉ Cohãcjʉ̃ yʉhʉre tiquiro nedi bato pũritare yʉhʉ buheyequina mehna ijisi yʉhʉ. Sa yeye ti pjepʉta yʉhʉ buheyequina gʉ̃hʉ sijieta, ni yʉhtiri Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Panopʉ cjẽ buheye wahma buheye mehna tiquina buhe more duagʉ̃ ihñano ohõ saha ni nemori Jesu tiquinare queoye mehna buhero. —‍Ne wahma cahsero suhtiro cahsero mehna mʉnano suhtirore sere ohõno cahmedare. Sa yegʉ̃ wahma cahsero mari coseri bato mʉnano suhtirore weje cahmecoa, paji yʉhdʉaro tʉhnʉgʉ̃ yere. (Ahri yero saha mʉna buheyere wahma buheye mehna piti dahre buheraro cahmene.) ");
INSERT INTO pirNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Sa yena ne ʉhse co bisiye core wahiquiro cahsero ajurore mʉna ajurore pose yeraro cahmene. Sa yegʉ̃ ʉhse co bisiye pahmuñepʉ mʉna ajurore tʉhrẽ cãhre. Sa tʉhnʉgʉ̃ ʉhse co gʉ̃hʉ, ajuro gʉ̃hʉ cohãa wahare. Sa yena ʉhse co wahma core wahma ajuropʉ pose yero cahmene. Sa yegʉ̃ ʉhse co cohãeda, ajuro gʉ̃hʉ cohãedare. (Sata wahma buheye mʉna buheye mehna buhe moredaro cahmene,) ni yahuri Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Tiquiro sa ni yahuri watoa mari judio masa pʉhtoa mehna cjʉ̃no Jesu cahapʉ wihiri. Wihi, dʉsepe curi mehna quehe sa, ohõ saha nidi. —‍Yʉhʉ maco mianogã yariaa wahari. Ticorore mʉhʉ omocare duhu peogʉ ahtaya. Mʉhʉ sa yegʉ̃ masanota, nidi tiquiro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Tiquiro sa nigʉ̃ tʉhoro Jesu wahcãdʉca tiquiro mehna wahari. Ʉsã tiquiro buhena gʉ̃hʉ wahaʉ. ");
INSERT INTO pirNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ʉsã mahapʉ wahaducugʉ̃ topʉ numino dii mʉna dohatiducuricoro Jesu batopʉ ahta, tiquiro suhtiro sohtoare dahra tuhuahye. Doce cʉhmari waro decoripe dii mʉna dohatiro niahye. ");
INSERT INTO pirNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ohõ saha ni tʉhotuahye ticoro sa yero: “Ti suhtirore dahra tuhugo, quehnoa wahagota”, ni tʉhotuahye ticoro. ");
INSERT INTO pirNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ticoro sa yegʉ̃ masino Jesu majaredʉca, ticorore nidi. —‍Maco, bucueya mʉhʉ. Mʉhʉ yʉhʉre wacũ tutuaye mehna quehnoago tojoare yojopʉre, nidi tiquiro. Tiquiro sa nigʉ̃ta yʉhdʉa wahari ticoro. ");
INSERT INTO pirNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Sa ye tuhasa Jesu pʉhtoro ya wʉhʉpʉ esari. Topʉ esa, ñehe quea utiyequinare weõgʉ mʉte pohoro saha ijidʉre putiyequinare ihñari. Peyequina masa tiquina ñano bisigʉ̃ gʉ̃hʉre tʉhori tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Tiquina sa yegʉ̃ ihñano masare ohõ saha nidi: —‍Wijiaya mʉsa. Yarierare ticoro. Carĩno nine, nidi tiquinare. Tiquiro sa nigʉ̃ tʉhoye “Sa ni maca cãno nine ahriquiro”, niñe, masa bʉjʉri tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Sa yero wʉhʉ puhiapʉre ijiyequina masare tiquiro wio pehori bato yariaricoro cahapʉ esa, ticoro omocare ñeheahye. Tiquiro sa ñehegʉ̃ masa quehe sa, wahcãdʉca sahye ticoro. ");
INSERT INTO pirNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Tiquiro sa yerire tʉhoye, to cjẽna masa ijipihtiyequina yahu siteri. ");
INSERT INTO pirNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Sa yero Jesu topʉ ijiriquiro wahagʉ̃, pʉaro caperi bajueyequina tiquirore pisu nʉnʉ tãri: —‍Davi panami iji turiagʉ, masare yʉhdʉoacjʉ, ʉsãre paja ihñaña mʉhʉ, ni sañuducuri tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Tiquina sa nigʉ̃ta Jesu ape wʉhʉpʉ sajãri. Tiquiro sa sajãgʉ̃ masiñe caperi bajueyequina tiquiro cahapʉ sajãa wahari. Tiquina sa sajã sagʉ̃ ihñano tiquiro pehe sinituri tiquinare: —‍¿“Marine ihñagʉ̃ yerota tiquiro”, ni tʉhotuajari mʉsa yʉhʉre? nidi tiquiro. —‍Pʉhto, sata ni tʉhotuaja ʉsã, ni yʉhtiri tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tiquina sa nigʉ̃ta tiquina caperire ña peori. Ña peo ohõ saha nidi: —‍Yʉhʉre “Sa yerota”, mʉsa ni tʉhoturiro sahata sa yeaja mʉsare, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Tiquiro sa nigʉ̃ta tiquina caperi pehe quehnoa wahari. Sa ye Jesu ohõ saha nidi tiquinare: —‍Ahri yʉhʉ ohõ saha yerire apequinare ne yahueracãhña, nidi. ");
INSERT INTO pirNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Tiquiro sa niepegʉ̃ta waha, topʉ ijiyequinare yahu siteri tiquina tiquiro sa yerire. ");
INSERT INTO pirNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ti wʉhʉre tiquina wijiagʉ̃ waro ihcãquiro yahuducueriquirore ne cãhtari masa. Watĩno tiquiro mehna ijiriquiro tiquirore yahuducueragʉ̃ yeahye. ");
INSERT INTO pirNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Tiquina ne sagʉ̃ ihñano watĩnore Jesu cohã wiori. Tiquiro sa cohãgʉ̃ watĩnore cʉoriquiro pehe yahuducua wahari. Tiquiro sa yegʉ̃ ihñañe ijipihtiyequina ihña maria pihtia wahari. —‍Ne, ahri yehpa Israe yehpapʉre ohõ saha yeyere ihñedahti mari, ni yahuducuri tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Fariseo masa pehe sijoro saha ni yahuducuri: —‍Watĩa pʉhtoro tutuaye mehna watĩare cohãre ahriquiro, ni yahuducuri tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Sa ye ijipihtiye macari topʉ ijiye macarigãre, bʉjʉye macari gʉ̃hʉre buhe tinino wahari Jesu. Quehnoañe buheyere judio masa mari buheye wʉhʉsepʉ buhero wahari tiquiro. Sa yero Cohãcjʉ̃ pʉhtoro tiquiro ijiatire yahuri. Ijipihtiye dohatiye gʉ̃hʉre to cjẽnare yʉhdʉori tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Masa peyequina ñano yʉhdʉyequinare, pejecʉoro wahayequinare tiquina ijigʉ̃ ihñano Jesu tiquinare paja ihñari. Tiquina oveja opana marieñequina yero saha tiquina ijigʉ̃ ihñano Jesu tutuaro paja ihñari tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Sa yero ohõ saha nidi tiquiro ʉsãre tiquiro buhenare, queoye mehna buhero: —‍Trigo peye bʉcʉa tuhasagʉ̃ peye ijigʉ̃ dahraye pajiro ijire. Sa ijiepegʉ̃ta dahrayequina pehe meheñequinagã ijire. Sata quehnoañe buheyere tʉhoatiquina peyequina ijigʉ̃ pajiro ijire mari dahraye. Sa ijiepegʉ̃ta meheñequinagã dahrari masa yero saha quehnoañe buheyere buheatiquina gʉ̃hʉ meheñequinagã ijire. ");
INSERT INTO pirNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Sa yena quehnoañe buheyere buheatiquinare apequinare tiquiro ohoatire siniña Cohãcjʉ̃re, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Came doce ʉsãre tiquiro buhenare Jesu pijio, tutuayere ohori ʉsãre. Watĩare ʉsã cohã masiatire ijipihtiye dohatiyere ʉsã cohã masiatire ohori ʉsãre. ");
INSERT INTO pirNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ohõ saha wame tii ʉsã Jesu cũrina: Simo ijiri. Tiquiroreta Pedro ni pisuri Jesu. Simo bahʉro Andre gʉ̃hʉ ijiri. Santiago gʉ̃hʉ tiquiro bahʉro Ñu mehna ijiri. Tiquina Santiago gʉ̃hʉ pacʉro Zebedeo wame tiri. ");
INSERT INTO pirNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolomé, Tomasu, yʉhʉ Mateo ijii ʉsã. Yʉhʉ pehe pʉhtoa ye ijiatire masare wapa ne cohtegʉ ijimi. Ʉsã mehna Santiago ijiri. Tiquiro pehe Alfeo macʉno ijiri. Sa yero Tadeo gʉ̃hʉ ijiri. ");
INSERT INTO pirNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simo celote ya curua cjʉ̃no ijimediquiro, Juda Iscariote gʉ̃hʉ ijiri. Juda pehe Jesure ihña tuhtiyequinare ihñoatiquiro ijiri. ");
INSERT INTO pirNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Sa ye ʉsãre doce tiquiro buhenare ohoro, “Ohõ saha yeya”, ni yahuri ʉsãre Jesu: —‍Judio masa ijieyequina cahapʉre wahaeracãhña. Ne Samaria yehpapʉ ijiye macaripʉ gʉ̃hʉre wahaeracãhña. ");
INSERT INTO pirNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Israe yehpa cjẽna cahapʉ pehere wahaya. Cohãcjʉ̃re masieñequina ijire tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","“Ʉhmʉse cjʉ̃no pʉhtoro tiquiro ijiato mehenogã dʉhsare”, ni buheya tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Sa yena cami bʉcʉ mʉna wihare, apeye peye sijoro saha ijiye dohatiyere cʉoyequina gʉ̃hʉre yʉhdʉgʉ̃ yeya. Yariariquinare masoña. Watĩa masa mehna ijiyequinare cohãña tiquinare. Mʉsare sa ohogʉ niaja ahri tutuayere. Sa yena mʉsa gʉ̃hʉ yʉhʉ sa ohoriro sahata masare yʉhdʉgʉ̃ yeya wapa neno marieno. ");
INSERT INTO pirNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Mʉsa wahana niñerure ne nedacãhña. ");
INSERT INTO pirNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ne mʉsa ajurore, pʉaro camisare, pʉa pa dahpo suhtire, tuaye cjʉ gʉ̃hʉre nedacãhña. Mʉsa sañano dihitare sañaa wahaya. Apeye suhtire nedacãhña. Mʉsa buhena waharopʉ ijiyequina tiquina pehe mʉsare pohe ijiatire ohoeta. Sata ohoro cahmene tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Ti macaripʉ esana, mʉsare quehnoano piti catiquirore macaña. Sa yena ti wʉhʉpʉta tojoarĩña. Tee, coã wahanapʉ wijiaya ti wʉhʉre. ");
INSERT INTO pirNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Sa yena wʉhʉpʉ sajãna, “¿Ijiajari mʉsa?” niña ti wʉhʉ cjẽnare. Mʉsare quehnoano tiquina cahmegʉ̃ “Cohãcjʉ̃ mehna quehnoano ijiya mʉsa”, niña tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Mʉsare tiquina cahmedagʉ̃, mʉsa sa niborire niedacãhña. ");
INSERT INTO pirNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Sa yena mʉsare tiquina cahmedagʉ̃, tiquina tʉho dueragʉ̃ ti wʉhʉre wijiaya. Wijiana, dahpocãri cjẽ dihta esa wahãrire wejẽ site cũña mʉsa tiquinare tiquina ye buhirire masigʉ̃ yena. Ti maca cjẽna mʉsare cahmedagʉ̃ sata yeya tiquina gʉ̃hʉre. ");
INSERT INTO pirNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ijirota mʉsare niita niaja. Ahri deco pihtigʉ̃pʉre Sodoma cjẽna, Gomorra cjẽna gʉ̃hʉ tutuaro buhiri tiatiquinata ijire. Tiquina sa ijiepegʉ̃ta tiquina yʉhdʉoro mʉsare cahmeeñequina buhiri tiatiquina ijieta, ni yahuri Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Sa ni tuhasa ohõ saha ni nemori: —‍Yʉhʉre tʉhoya mʉsa. Oveja yero saha ijinare mʉsare ñañequina watoa ohogʉ niaja. Tiquina ñañequina nʉcʉ cjẽna yayia usuayequina yero saha ijire. Sa yena mʉsa pehe apequina wahiquina wacũ masiñequina yero saha ijiya. Sa ijina ijiepenata bujua yero saha ne usuena ijiya mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Quehnoano yeya mʉsa. Mʉsare masa pʉhtoare ohoeta. Judio masa mari buheye wʉhʉsepʉ quẽeta mʉsare. ");
INSERT INTO pirNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Sa yeye yeequina mʉsa ijiri buhiri macari cjẽna pʉhtoa cahapʉ tiquina bui ijiyequina pʉhtoa cahapʉ gʉ̃hʉre neañeta mʉsare. Sa yena mʉsare topʉ tiquina neagʉ̃ pʉhtoare, judio masa ijieyequina gʉ̃hʉre quehnoañe buheyere buhenata mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","Mʉsare pʉhtoare tiquina ohogʉ̃ tiquinare mʉsa niatire “Yohou, masiedaboaga”, ni tʉhotueracãhña. Mʉsare tiquina sinitugʉ̃ta mʉsa niatire masinata. Sa masina tiquinare yahuna, mʉsa tire mʉsa esa tuharo yahuducuna nisi. Cohãcjʉ̃ pehe mari Pacʉ tiquiro yaquiro Espíritu mehna mʉsare yahuducugʉ̃ yerota. ");
INSERT INTO pirNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Ti pjere tiquina wahmisʉmʉa tiquina bahanare wejẽ dutiye ohoeta pʉhtoare yeequina tiquina ijiri buhiri. Tiquina pacʉsʉmʉa tiquina pohnene wejẽ dutiye ohoeta pʉhtoare. Tiquina pohne pehe tiquina pacʉsʉmʉare wejẽ dutiye ohoeta pʉhtoare. ");
INSERT INTO pirNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Sa yeye yeequina mʉsa ijiri buhiri ihña tuhtieta masa ijipihtiyequina mʉsare. Tiquina sa yepegʉ̃ta ahri yehpapʉ mʉsa catiro puno mʉsare tiquina ñano yerire ihcãno sahana yʉhʉre duhuerana, yʉhdʉnata mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ihcã macapʉ mʉsare tiquina ñano yegʉ̃ ape macapʉ duhti cãhña. Ijirota mʉsare niita niaja. Israe yehpapʉ ijiye macarine mʉsa pehoato pano, yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ ahri yehpapʉ tojoa taʉtja. ");
INSERT INTO pirNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Ne ihcãquiro buheriquiro tiquirore yahuriquiro buipʉ ijierare. Sa yero cahacjʉ̃no gʉ̃hʉ tiquiro pʉhtoro bui cjũno ijierare. ");
INSERT INTO pirNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Sa yero ohõ saha tʉhoturo cahmene buheriquirore: “Yʉhʉre buheriquiro yero sahata ijigʉtja”, ni tʉhoturo cahmene. Cahacjʉ̃no gʉ̃hʉre sata ni tʉhoturo cahmene. “Yʉhʉ pʉhtoro yero sahata ijigʉtja”, ni tʉhoturo cahmene. “Tiquiro bui ijigʉtja. Sa yegʉ yʉhʉ pʉhtoro tiquiro ñano yʉhdʉriro sahata ñano yʉhdʉsi yʉhʉ pehe”, ni tʉhotueraro cahmene. Yʉhʉ pehe wʉhʉ cjʉ̃no yero saha ijiaja. Mʉsa pehe ti wʉhʉpʉ dahrayequina yero saha ijire. Sa yeye masa yʉhʉre “Beelzebú ijire”, ni yahusãñe, mʉsa gʉ̃hʉre yeequinare ñano ni yahuducueta tiquina, ni yahuri Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Sa ni tuhasa ohõ saha ni nemori: —‍Sa yena mʉsare ñano yeyequinare cueracãhña. Masa tiquina yahuerarire came apequina masieta. Sa yeye tiquina nʉori gʉ̃hʉre apequina masieta. ");
INSERT INTO pirNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Mʉsare tʉhoerogã yʉhʉ yahurire peyequina masa watoa buhe turiaya mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Masʉnore wejẽñequina tiquiro pagʉ dihitare wejẽne. Tiquiro jeripohna yarierare. Sa yena mʉsare wejẽ duayequinare cueracãhña. Cohãcjʉ̃ pehere cueya. Tiquiro mʉsa pagʉrire, mʉsa jeripohnari gʉ̃hʉre pecapʉ cohã masine. Sa yena tiquiro pehere cueya. ");
INSERT INTO pirNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Pʉaro siripia wapa mariedare. Tiquina sa wapa mariedapegʉ̃ta ihcãquirogãre Cohãcjʉ̃ ne boerare. Cohãcjʉ̃ dutieragʉ̃ ne yarierare tiquirogã. ");
INSERT INTO pirNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Sa yero mʉsa poarire ne ihcã poa da dʉhsaro marieno masi pehore Cohãcjʉ̃. Sata mʉsa ijiye tiye gʉ̃hʉre masi pehore Cohãcjʉ̃. Sa masino mʉsare ihña ihboducure. ");
INSERT INTO pirNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Siripiare tiquiro cahĩno yʉhdʉoro, mʉsa pehere cahĩne Cohãcjʉ̃. Sa yena pajiro tʉhotueracãhña mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Ihcãquiro “Jesu yaquiro ijiaja”, masare tiquiro ni yahugʉ̃ yʉhʉ gʉ̃hʉ tiquirore “Yaquiro ijire”, ni yahugʉtja yʉhʉ Pacʉre ʉhmʉse cjʉ̃nore. ");
INSERT INTO pirNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Sa ijiepegʉ̃ta ihcãquiro “Jesu yaquiro ijieraja”, masare tiquiro nigʉ̃ yʉhʉ gʉ̃hʉ “Yaquiro ijierare tiquiro”, ni yahugʉtja yʉhʉ Pacʉre, ni yahuri Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Sa ni tuhasa ohõ saha ni yahu nemori: —‍¿Dʉhse ni tʉhotuajari mʉsa yʉhʉre? ¿“Tiquiro masare tiquiro buheri bato apequina tiquinare ihña tuhtisi”, ni, tʉhotuajari mʉsa? Sa ijierare. Masare yʉhʉ buheri bato ihquẽquina yeere tʉhoeta. Apequina pehe tiquinare ihña tuhtieta. Ihcãno saha ijisi masa. ");
INSERT INTO pirNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Bʉcʉna yʉhʉ buheyere tiquina tʉhori buhiri tiquina pohne tiquinare ihña tuhtieta. Bʉcʉna numia gʉ̃hʉ yʉhʉ buheyere tiquina tʉhori buhiri tiquina pohna numia tiquinare ihña tuhtieta. Tiquina mareosãnumia yʉhʉ buheyere tiquina tʉhori buhiri tiquina macʉ namosãnumia tiquinare ihña tuhtieta. ");
INSERT INTO pirNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Sa yeye masa tiquina acayere ihña tuhtiyequina ijieta. ");
INSERT INTO pirNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Yʉhʉre tiquina cahĩboriro yʉhdʉoro tiquina pacʉsʉmʉa pehere cahĩ yʉhdʉdʉcaye, yeequina ijisi tiquina. Yʉhʉre tiquina cahĩboriro yʉhdʉoro tiquina pohne pehere cahĩ yʉhdʉdʉcaye, yeequina ijisi tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Sa yeye apequina curusapʉ yariariro saha yeequina tiquina ijiri buhiri ñano yʉhdʉeta tiquina gʉ̃hʉ. Sata ñano yʉhdʉ dueyequina yeequina ijisi tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Masa yʉhʉre wacũno marieno tiquina esa tuharo yeye pecapʉ wahaeta tiquina. Sa yeye yeere sa yeducuye ijipihtiye decori yʉhʉ mehna ijieta tiquina, ni yahuri Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Sa ni tuhasa ohõ saha ni yahu nemori: —‍Mʉsare yeequinare ihcãquiro quehnoano cahmeno, yʉhʉ gʉ̃hʉre cahmeno nine tiquiro. Sa yero tiquiro yʉhʉre quehnoano cahmediquiro yʉhʉre ohoriquiro gʉ̃hʉre cahmeno nine. ");
INSERT INTO pirNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Sa yero Cohãcjʉ̃ yere yahuriquiro wapatarota. Tiquirore quehnoano yerota Cohãcjʉ̃. Sa yero tiquiro yere yahuriquiro tiquiro ijigʉ̃ ihñano apequiro pehe yahuriquirore quehnoano cahmeno, yahuriquiro yero sahata wapatarota tiquiro gʉ̃hʉ. Sa ye apequiro quehnoano yeriquiro wapatarota. Sa yero quehnoano yeriquiro tiquiro ijigʉ̃ ihñano apequiro pehe tiquirore quehnoano cahmeno, quehnoano yeriquiro yero saha wapatarota tiquiro gʉ̃hʉ. ");
INSERT INTO pirNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Yaquirogã ihcãquiro tiquiro ijigʉ̃ ihñañe dʉhse ijiyequina tiquirogãre acore mehenogã tiquina sihõepegʉ̃ta, potota tiquinare quehnoano yerota Cohãcjʉ̃, ni yahuri Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ʉsãre tiquiro buhenare tiquiro sa ni yahuri bato to cahapʉ ijiye macaripʉ buhero wahari tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Sa ye tiquiro yerire Ñu peresupʉ ijiriquiro tʉhooahye. Sa tʉhooro Ñu tiquiro buheyequinare Jesure sinitu dutiro ohoahye. ");
INSERT INTO pirNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Sa ye Jesu cahapʉ esa, sinituri tiquina Ñu buheyequina. —‍¿Ñu “Yʉhʉ bato apequiro ahtarota”, tiquiro nidigʉ ijiajari mʉhʉ? ¿Tiquiro nidigʉ mʉhʉ ijieragʉ̃ apequirore cohtenatari ʉsã? ni sinituri tiquina pehe Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Tiquina sa nigʉ̃ tʉhoro Jesu yʉhtiri: —‍Yojopʉre mʉsa tʉhorire, mʉsa ihñarire Ñure yahuna wahaya: ");
INSERT INTO pirNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","“ ‘Caperi bajueyequina ihñare. Tini masieñequina tinine. Cami bʉcʉna quehnoa wahare. Cahmono tʉhoeyequina tʉhoa wahare. Yariariquina masaa wahare. Tiquina ijipihtiyequinare quehnoa wahagʉ̃ yei yʉhʉ. Sa yegʉ pejecʉoyequinare quehnoañe buheyere yahuaja. ");
INSERT INTO pirNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Yʉhʉre tʉhoriquiro “Poto ijire”, niniquiro tiquiro bucueriquiro ijire’, nidi”, ni, Ñure yahuna wahaya, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ñu buheyequina tiquina wahari bato, Jesu pehe Ñu ijiye tiyere yahu dʉcari peyequina masare: —‍Masa marienopʉ taare wihnono wẽdoqueo mʉjagʉ̃ ihñana eserari mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","“Quehnoañe suhti tiriquirore ihñana wahaʉhna”, niedari mʉsa masa marienopʉ wahana. Quehnoañe suhti tiyequina wapa bʉjʉyere cʉoyequina pʉhtoa ye wʉhʉsepʉ ijire. ");
INSERT INTO pirNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Masa marienopʉ esana Cohãcjʉ̃ yere yahu mʉhtariquirore ihñana esari mʉsa. Ijirota ijire. Ñu Cohãcjʉ̃ yere yahu mʉhtariquiro ijire. Apequina Cohãcjʉ̃ yere yahu mʉhtañequina yʉhdʉoro ijiriquiro ijire tiquiro pehe. ");
INSERT INTO pirNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Panopʉ Cohãcjʉ̃ yere tiquina ojoari pũpʉ Ñure ohõ saha ni yahuahye: Mari Pacʉ tiquiro macʉnore ohõ saha niahye: “Mʉhʉ pano mʉhʉre yahuyuatiquirore ohogʉ niaja”, niahye, ni ojoahye panopʉre Ñure. ");
INSERT INTO pirNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Mʉsare ijirota niaja. Apequina ijipihtiyequina bui ijire Ñu wame yeriquiro. Ahri decoripʉre tiquiro sa ijiepegʉ̃ta ʉhmʉse cjʉ̃no pʉhtoro ijiropʉre ijipihtiyequina docapʉ ijiriquiro pũrita Ñu bui ijire. ");
INSERT INTO pirNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Ñu wame yeriquiro tiquiro buhe, wame ye dʉcagʉ̃ peyequina masa ʉhmʉse cjʉ̃no pʉhtoro ijiropʉ tiquina tutuaye mehna, tiquina esa tuharo sajã duamedi. ");
INSERT INTO pirNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Cohãcjʉ̃ yere yahu mʉhtañequina tiquina ojoarire, Cohãcjʉ̃ Moisere tiquiro cũripʉ gʉ̃hʉre buhena Cohãcjʉ̃ tiquiro pʉhtoro ijiatore masiaja mari. Ñu gʉ̃hʉ tireta yahuri. ");
INSERT INTO pirNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","“Elia ahtarota”, panopʉ tiquina nidiquirota ijire Ñu pehe. Panopʉ cjẽna tiquina nidire “Poto ijire”, ni duana Ñu tiquina sa nidiquiro tiquiro ijigʉ̃ masinata mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Quehnoano tʉhoya mʉsa ahrire. ");
INSERT INTO pirNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿Yojopʉ cjẽna masa yabequina yero saha ijiajari tiquina, mʉsa tʉhotugʉ̃? Tiquina macanagã yero saha ijire. Apequina tiquina cahmeno saha tiquina yeragʉ̃ bucuerare tiquinagã. Doeri cjẽ duaropʉ ape dujiye, ohõ saha ni pisupere tiquinagã basi: ");
INSERT INTO pirNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Mʉsa basatire ʉsã putipemi. ¿Dʉhsena mʉsa basaerari ʉsã tire putigʉ̃? Ʉsã tutuaro ñehe quea utipe, sañuducupemi. ¿Mʉsa pehe dʉhsena ʉsã mehna utiperari?” niducuriquina yero sahata ijire yojopʉ cjẽna gʉ̃hʉ. Yojopʉ cjẽna tiquina cahmeno saha ʉsã yeragʉ̃ ihñañe bucuerare tiquina gʉ̃hʉ. ");
INSERT INTO pirNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Tiquina yero saha yena ohõ saha yere mʉsa yojopʉ cjãna. Ñu wame yeriquiro Cohãcjʉ̃re ño peoro taro sijiro, vinore sihniedari. Tiquiro sa sihniedagʉ̃ ihñana “Watĩnore cʉoriquiro ijire”, nimedi mʉsa tiquiro pehere. ");
INSERT INTO pirNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ ijigʉ yʉhʉ ihya, sihniaja. Yʉhʉ sa yegʉ̃ ihñana ohõ saha nine mʉsa yʉhʉ pehere: “Ihñaña. Ahriquiro pajiro ihyariquiro, queheriquiro ijire. Wapa ne cohteyequina, ñano yeyequina gʉ̃hʉ tiquina piti tiriquiro ijire tiquiro”, nine mʉsa yʉhʉre. Sa nina macanagã yero saha yahuducuna nine mʉsa. Mʉsa cahmeno saha ʉsã yeragʉ̃ bucuerare mʉsa. Sa masiedapenata ʉsã ye ihñorire ihñana, Cohãcjʉ̃ yere ʉsã masigʉ̃ masinata mʉsa, nidi Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Apeye macari cjẽnare tuhtiri Jesu. Ti macarine apeye macari yʉhdʉoro Cohãcjʉ̃ tutuaye mehna ye ihñomedi tiquiro. Tiquiro sa ye ihñoepegʉ̃ta tiquina ñañe yerire duhuerari tiquina. Sa yero ohõ saha ni tuhtiri Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—‍Corazín cjãna, mʉsa ñano yʉhdʉnata. Betsaida cjãna, mʉsa gʉ̃hʉ ñano yʉhdʉnata. Mʉsa ye macaripʉre Cohãcjʉ̃ tutuaye mehna ye ihñomi. Tiro wame tiri macare, Sidõ wame tiri maca gʉ̃hʉre tiquiro tutuaye mehna yʉhʉ ye ihñogʉ̃ ihñañe panopʉ to cjẽna pehe tiquina ñañene bʉjʉa witiboaga. Sa yeye quehnoañene camesaboaga. Masa dija suhtire saña, peca cjẽ nujuare tiquina bui dahra site peoboaga tiquina ñañene bʉjʉa witiyere ihñoñe. ");
INSERT INTO pirNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Mʉsare niita niaja. Buhiri dahreati deco ijigʉ̃ Cohãcjʉ̃ Tiro cjẽna, Sidõ cjẽna yʉhdʉoro mʉsa pehere mʉsa ñari buhirire ña yʉhdʉaro buhiri dahrerota. ");
INSERT INTO pirNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Capernau cjãna, mʉsa esa tuharo ʉhmʉsepʉ waha duamedi. Mʉsare Cohãcjʉ̃ pecapʉ cohãnota. Mʉsa ya macapʉ Cohãcjʉ̃ tutuaye mehna ye ihñomi. Mʉsa yʉhʉre tʉhoerari. Sodoma wame tiri macare Cohãcjʉ̃ tutuaye mehna yʉhʉ ye ihñogʉ̃ ti maca pehe yojopʉre ijiboaga. ");
INSERT INTO pirNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Mʉsare niita niaja. Buhiri dahreri deco ijigʉ̃ Cohãcjʉ̃ Sodoma cjẽna yʉhdʉoro, mʉsa pehere mʉsa ñari buhiri ña yʉhdʉaro buhiri dahrerota, nidi Jesu ti macari cjẽnare. ");
INSERT INTO pirNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ti pjere ohõ saha nidi Jesu tiquiro Pacʉro mehna yahuducuro: —‍Yʉhʉ Pacʉ, mʉhʉ ʉhmʉse cjẽna pʉhto, ahri yehpa cjẽna pʉhto ijire. Ahri mʉhʉ buheyere “Quehnoano masina ijiaja ʉsã”, niñequinare masigʉ̃ yerare mʉhʉ. Buhe pehoeyequina pehere mʉhʉ yere masigʉ̃ yere mʉhʉ. Mʉhʉ sa yegʉ̃, “Quehnoare”, niaja yʉhʉ mʉhʉre. ");
INSERT INTO pirNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Sata ijire. Tiquina pehere masigʉ̃ cahmedi mʉhʉ, nidi Jesu tiquiro Pacʉrore. ");
INSERT INTO pirNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Sa yero masare ohõ saha ni yahu nemori: —‍Yʉhʉ Pacʉ ijipihtiyere yʉhʉre ohori. Tiquiro dihita yʉhʉre quehnoano masine. Sa yena ʉsã dihita yʉhʉ masi dutiyequina mehna yʉhʉ Pacʉre masiaja ʉsã. ");
INSERT INTO pirNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Mʉsa ñañe apee boro nʉcʉñe yero saha ijire. Nʉcʉñene wʉana mʉsa tahrĩno saha ñañene wahyia wahare mʉsa. Sa wahyiarina ijina yʉhʉre cahmeña mʉsa. Mʉsare sogʉ̃ yeitja. Mʉsa ñañe yeyere duhugʉ̃ yeitja. ");
INSERT INTO pirNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Yʉhʉ dutiyere yeya. Yeere quehnoano masiña. Yʉhʉ paja ihñagʉ ijiaja. Sa yegʉ yʉhdʉdʉcaegʉ ijiaja. Yʉhʉ sa ijigʉ̃ yeere quehnoano masiña mʉsa. Sa yena soye mehna quehnoano jeripohna tinata mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Yeere mʉsa yegʉ̃ mijoedare. Sa yero mʉsa wʉaye ti nʉcʉedaro sahata yʉhʉ pehe mʉsare mehenogã ye dutiaja, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mehenogã tiquiro sa ni buheri bato saurú ijigʉ̃ ʉsã Jesu mehna trigo wesepʉ esaʉ. Ʉsã tiquiro buhena ʉjʉa ahbana, trigore pehe, ihya tuhasa, yʉhdʉ cãa wahaʉ ʉsã. ");
INSERT INTO pirNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ʉsã sa yegʉ̃ ihñañe, fariseo masa Jesure ohõ saha nidi: —‍Tʉhorĩña ʉsãre. ¿Dʉhse ye mʉhʉ buheyequina saurú mari sori deco ijiepegʉ̃ta dahrajari? Marine dutiyere yʉhdʉdʉcaye nine, nidi tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","4","Jesu yʉhtiri. “Yʉhʉ buheyequina yʉhdʉdʉcaye niedare”, ni yahuro taro ohõ saha ni yʉhtiri: —‍Davi tiquiro mehna cjẽna mehna ʉjʉa ahbaro Cohãcjʉ̃ wʉhʉpʉ sajã, Cohãcjʉ̃ ye pãre ihyahye. Ti pãre pahia dihita ihyae tiahye. Cohãcjʉ̃ dutiyere tiquina ojoari pũ apequinare ti pãre ihya dutierare. ¿Davi gʉ̃hʉ tire tiquina yerire Cohãcjʉ̃ ojoari pũpʉ buherari mʉsa? (Ti pãre ihyaro Cohãcjʉ̃re yʉhdʉdʉcaro niedahye. Miare ahri pjerire ihyaye yʉhʉ buheyequina gʉ̃hʉ Cohãcjʉ̃re yʉhdʉdʉcaye niedare.) ");
INSERT INTO pirNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Sa ye Cohãcjʉ̃ wʉhʉpʉ dahrayequina pahia ne soerare mari soye decorire. Sa soerapeta Cohãcjʉ̃ dutiyere yʉhdʉdʉcayequina ijierare. ¿Tire buherari mʉsa Cohãcjʉ̃ Moisere tiquiro cũri pũpʉ? ");
INSERT INTO pirNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Mʉsare niita niaja. Cohãcjʉ̃ wʉhʉre ño peona ti wʉhʉpʉ dahrayequina tiquina soeragʉ̃ ihñaepenata “Quehnoanota”, nine mʉsa. Ti wʉhʉ yʉhdʉoro yʉhʉ pehere ño peoro cahmene. ");
INSERT INTO pirNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Cohãcjʉ̃ yere tiquina ojoari pũ ohõ saha nine: “Wahiquinare wejẽ, ʉjʉ̃a mʉoñe mehna yʉhʉre mʉsa ño peogʉ̃ cahmedaja. Apequinare mʉsa paja ihñagʉ̃ pehere cahmeaja yʉhʉ”, nine tiquiro yere tiquina ojoari pũ. Tiquiro sa nidire mʉsa quehnoano tʉhona, yʉhʉ buheyequinare tiquina buhiri mariedapegʉ̃ta tiquinare tuhtieraboaga mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ ahri deco saurú decore masa tiquina yeatire yahugʉ ijigʉ pʉhto ijiaja, nidi Jesu fariseo masare. ");
INSERT INTO pirNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Tiquiro sa nidi bato waha, judio masa mari buheri wʉhʉpʉ esaʉ ʉsã Jesu mehna. ");
INSERT INTO pirNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Topʉ omoca bʉhariquiro ijiri. Sa yeye fariseo masa pehe Jesure yahusãñe tehe, tiquirore sinituri: —‍Saurú decore mari sori decore masʉnore yʉhdʉo dutierare Cohãcjʉ̃. ¿Sata ijiajari, mʉhʉ tʉhotugʉ̃? ni sinituri tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesu yʉhtiri tiquinare: —‍¿Mʉsa yaquiro oveja saurú ijigʉ̃ copepʉ tiquiro bora sajãgʉ̃ tiquirore ne wioeraboagari mʉsa? Ne wionata mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Oveja yʉhdʉoro ijire masʉno pehe Cohãcjʉ̃ tiquiro ihñagʉ̃. Sa yero saurú ijigʉ̃ quehnoañene mari yegʉ̃ quehnoarĩne, ni yʉhtiri Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Tiquiro sa nidi bato omoca bʉhariquirore ohõ saha nidi: —‍Mʉhʉ omocare siõ potoya, nidi tiquiro. Tiquiro sa nigʉ̃ omoca bʉhariquiro pehe siõ poto, omoca quehnoa wahari ape omoca quehnoari omoca yero saha. ");
INSERT INTO pirNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Sori decore tiquiro sa yegʉ̃ ihñañe, fariseo masa waha, tiquina basi ohõ saha niahye: —‍¿Dʉhse Jesure wejẽnatari mari? niahye tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesu tiquina sa nidire masino, wahaa wahari. Tiquiro sa wahagʉ̃ peyequina masa tiquirore nʉnʉ tãri. Sa yero tiquiro pehe ijipihtiyequina tiquina mehna cjẽnare dohatiyequinare yʉhdʉgʉ̃ yeri. ");
INSERT INTO pirNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Sa yero dohatiyequinare tiquinare tiquiro yʉhdʉorire apequinare yahu site dutierari tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Sa dohatiyequinare yʉhdʉgʉ̃ yero, Cohãcjʉ̃ yere yahu mʉhtariquiro Isaia panopʉ tiquiro ni ojoariro sahata yero nidi Jesu. Ohõ saha ni ojoahye Isaia: ");
INSERT INTO pirNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ohõ saha nine Cohãcjʉ̃: “Ahriquiro yʉhʉ cahacjʉ̃no ijire. Tiquiro yʉhʉ beseriquiro ijire. Tiquirore cahĩaja. Sa yegʉ tiquiro mehna bucueaja. Yaquiro Espíriture tiquirore ohogʉtja. Sa yero yʉhʉ tutuaye mehna ijipihtiyequina masare yʉhʉ buheyere yahurota tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Sa yahuro tiquiro ne purĩno mehna yahusi. Sa yero sañuducusi. Sa yero maca cjã mahapʉ peyequina masa watoa tiquiro tutuaro sañuducu yahusi. ");
INSERT INTO pirNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Wʉjʉgʉ nuhrino cuadʉ tiquiro nuhriedagʉ̃ yero saha masa gʉ̃hʉre quehnoano yerota tiquiro. Mehenogã ʉjʉ̃ri pecare tiquiro yatigʉ̃ yeraro saha masa gʉ̃hʉre quehnoano yerota tiquiro. Sata yeducurota tiquiro watĩnore tiquiro yʉhdʉdʉcato pano. ");
INSERT INTO pirNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Sa yeye peyequina masa tiquirore wacũ tutueta”, nine Cohãcjʉ̃, ni ojoahye Isaia. ");
INSERT INTO pirNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ihcã deco watĩno cʉoriquirore masa ne cãhtari Jesu cahapʉ. Tiquiro pehe watĩnore cʉoro yahuducu masiedari. Sa yero caperi ne bajuerari. Tiquina sa ne wihigʉ̃ ihñano, yʉhdʉgʉ̃ yeri Jesu tiquirore. Tiquiro sa yegʉ̃ watĩno cʉoriquiro ihña, yahuducuri. ");
INSERT INTO pirNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Tiquiro sa wahagʉ̃ ihñañe, masa ihña maria wahari. —‍¿Ahriquiro Davi panamino iji turiariquiro masare yʉhdʉoatiquiro ijiajari? nidi tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Jesu watĩare tiquiro cohãrire tʉhoye fariseo masa ohõ saha ni tʉhoturi: —‍Beelzebú watĩa pʉhtoro tiquiro tutuaye mehna watĩare cohãre Jesu, ni tʉhoturi tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Tiquina sa ni tʉhotugʉ̃ masino, Jesu queoye mehna yahuri tiquinare, “Watĩno ye tutuaye mehna watĩare cohãgʉ niedaja”, nino taro: —‍Ihcã yehpa cjẽna tiquina basi cahmequeñe, ti yehpa cjẽna waha pihtia wahaboaga. Ihcã maca cjẽna tiquina basi cahmequeñe ti maca cjẽna waha pihtia wahaboaga. Ihcã wʉhʉ cjẽna gʉ̃hʉ sata wahaboaga. ");
INSERT INTO pirNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Sa yeye Beelzebú watĩa pʉhtoro pehe watĩare cohãno, tiquina watĩa tiquina basi cahmequeñe niboaga. Sa ye tiquina gʉ̃hʉ waha pihtia wahaboaga. ");
INSERT INTO pirNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ohõ saha ni yahusãre mʉsa yʉhʉre: “Tiquiro Beelzebú yedohoye mehna watĩare cohãre”, ni yahusãre mʉsa. Mʉsa mehna cjẽna gʉ̃hʉ watĩare cohãre. ¿Watĩno tiquiro tutuaye mehna watĩare cohãjari tiquina gʉ̃hʉ, mʉsa ihñagʉ̃? Sa cohãedare. Tire masine mʉsa. Yʉhʉ gʉ̃hʉ watĩno tutuaye mehna watĩare cohãedaja. ");
INSERT INTO pirNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Sa yegʉ yʉhʉ pehe watĩare cohãgʉ Cohãcjʉ̃ yaquiro Espíritu tutuaye mehna tiquinare cohãja. Yʉhʉ sa cohãgʉ̃ ihñana ohõ saha masiña mʉsa: Cohãcjʉ̃ masa bui pʉhtoro ahri yehpapʉre iji tuhasare yojopʉre. ");
INSERT INTO pirNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Ohõ sahata ijire queoye mehna mari buhegʉ̃: Tutuariquiro ya wʉhʉpʉ apequiro sajã sa yaque masiedare. Tutuariquirore dʉhteraro tiquiro ya wʉhʉpʉ sajã sa yaque masiedare. Tutuariquirore tiquiro dʉhteri bato sajã sa yaque masine, ni yahuri Jesu. (Sa ni yahuri, watĩnore tiquiro yʉhdʉdʉcarire yahuro. Watĩno tutuariquiro tiquiro ijiepegʉ̃ta Jesu tiquirore yʉhdʉdʉcare watĩare cohãno.) Sa ni tuhasa ohõ saha ni yahu nemori Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","—‍Ihcãquiro yʉhʉre cahmedaro, yʉhʉre ihña tuhtiriquiro ijire. Ihcãquiro yʉhʉre yedohoeraro, yʉhʉre wape tigʉ̃ yero nine. ");
INSERT INTO pirNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Sa yegʉ mʉsare poto niita niaja yʉhʉ. Ijipihtiye ñañene masa tiquina yegʉ̃, yahuducugʉ̃ gʉ̃hʉre Cohãcjʉ̃ bo masine. Sa boeperota Espíritu Santore tiquina ñano ni yahuducugʉ̃ ti pũritare ne bosi. ");
INSERT INTO pirNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Yʉhʉre masʉ Cohãcjʉ̃ ohorigʉre yʉhʉre tiquina ñano ni yahuducurire bo masine Cohãcjʉ̃. Espíritu Santo pehere tiquina ñano ni yahuducurire ne bosi Cohãcjʉ̃. Yojopʉre, deco pihtigʉ̃ gʉ̃hʉre tiquina sa nidire bosi tiquiro, ni buheri Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Sa yero queoye mehna buhero ohõ saha ni yahu nemori tiquinare: —‍Quehnoadʉ yucʉgʉ quehnoañene dʉca tire. Ñadʉ yucʉgʉ ñañene dʉca tire. Yucʉgʉ dʉcare masina “Tʉ dʉcata ijire”, ni masiaja mari. Mari sa masino saha masa tiquina yahuducuyere tʉhona tiquina ijiye tiyere masiaja mari. ");
INSERT INTO pirNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Añaa yero saha ñana ijire mʉsa. Mʉsa ñana ijina, quehnoañene ni masiedare mʉsa. Mari wacũñepʉ mari tʉhoturiro sahata mari dʉseropʉ wijiare. ");
INSERT INTO pirNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Quehnoariquiro quehnoañene tʉhoture. Sa yero quehnoañene yahuducure. Ñariquiro ñañene tʉhoture. Sa yero ñañene yahuducure. ");
INSERT INTO pirNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Quehnoano tʉhotu yahuducuna ijiya mʉsa. Quehnoano yahuducuerana, buhiri dahreati deco ijigʉ̃ mʉsa sa ni maca cãrire Cohãcjʉ̃re yahu yʉhdʉnata. ");
INSERT INTO pirNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Queoro mʉsa yahuducurire masino “Quehnoana ijire”, ninota Cohãcjʉ̃. Sa yero ñano mʉsa yahuducurire masino “Ñana ijire”, ninota tiquiro, nidi Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Tiquiro sa nidi bato mari judio masare buheyequina, fariseo masa gʉ̃hʉ tiquirore ohõ saha nidi: —‍Buhegʉ, Cohãcjʉ̃ ohorigʉ ijigʉ Cohãcjʉ̃ tutuaye mehna ye ihñoña ʉsãre, nimedi tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesu yʉhtiri: —‍Yojopʉ cjẽna ñañequina, Cohãcjʉ̃re cahmeeñequina Cohãcjʉ̃ tutuaye mehna yʉhʉ ye ihñogʉ̃ ihña duamene. Tiquina sa ihña duepegʉ̃ta Cohãcjʉ̃ yere yahu mʉhtariquirore Jona panopʉ cjʉ̃nore Cohãcjʉ̃ tiquiro tutuaye mehna tiquiro yeri dihitare ye ihñonota masare. ");
INSERT INTO pirNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jona ihtia deco waro pajiriquiro wahi paa puhiapʉ ijiahye. Tiquiro sa wahariro sahata yʉhʉ gʉ̃hʉ masʉ Cohãcjʉ̃ ohorigʉ ihtia deco waro masa copepʉ ijigʉta. ");
INSERT INTO pirNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nínive cjẽna pehe Jona Cohãcjʉ̃ yere tiquiro yahurire tʉhoye tiquina ñañe yerire bʉjʉa witiahye. Sa bʉjʉa witiyequina ijiye buhiri dahreati deco ijigʉ̃ tiquina yojopʉ cjẽnare tiquina ñañene bʉjʉa witieyequinare “Ñañequina ijire”, ni, yahusãeta. Jona tiquinare Cohãcjʉ̃ yere tiquiro yahugʉ̃ tʉhoye quehnoañene cahmeahye tiquina pehe. Sa cahmeñe quehnoano yeye niahye yojopʉ cjẽna yʉhdʉoro. Sa yeye tiquina yojopʉ cjẽnare yahusãeta. Mʉsare niita niaja. Yojopʉ mʉsare yʉhʉ buheye Jona tiquiro buheri yʉhdʉoro ijire. ");
INSERT INTO pirNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Sa ye buhiri dahreati deco ijigʉ̃ pʉhtoro sur cjõno panopʉ cjõno ducu, yojopʉ cjẽnare “Ñañequina ijire”, ni yahusãnota ticoro gʉ̃hʉ. Ticoro Salomo panopʉ cjʉ̃no tiquiro masiñene tʉho duaro yoaropʉ ahri yehpa ape siepʉ ijiricoro Salomore tʉhoro ahtahye. Sa yero quehnoano yero niahye yojopʉ cjẽna yʉhdʉoro. Sa yero ticoro yahusãnota yojopʉ cjẽnare. Mʉsare niita niaja. Yojopʉ mʉsare yʉhʉ buheri Salomo tiquiro buheri yʉhdʉoro ijire, nidi Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Sa yero pari turi Jesu tiquiro tʉhotuye mehna ohõ saha ni quiti yahuri tiquinare: —‍Watĩno masʉno mehna ijiriquiro waha, aco marieni yehpapʉ tini, tiquiro ijiatore macamahye. ");
INSERT INTO pirNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Sa bocaeraro, ohõ saha ni tʉhotuahye tiquiro. “Masʉno yʉhʉ cohãriquiro mehnata pari turi ijigʉ wahaʉtja”, ni tʉhotuahye tiquiro. Sa ni tʉhoturo tojoaa waha, tiquiro cohãriquiroreta bocahye. Sa tiquiro bocagʉ̃ masʉno pehe quehnoariquiro ijimahye. ");
INSERT INTO pirNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Sa yero watĩno apequina siete watĩare tiquiro yʉhdʉoro ñañequinare pijiro wahahye. Tiquiro sa pijigʉ̃ tiquina ijipihtiyequina tiquiro mehna ijiahye. Masʉno pehe to pano ihcãquiro watĩnore cʉoro, ñariquiro ijimahye. Camepʉ pehere peyequina watĩare cʉoriquiro ijiro, to pano tiquiro ijiriro yʉhdʉoro ña yʉhdʉariquiro ijiahye. Yojopʉ cjẽna Cohãcjʉ̃re cʉomediquina tiquirore cohãñe, tiquina gʉ̃hʉ ña yʉhdʉayequina waro wahaeta, nidi Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Masare tiquiro sa ni yahuducuri watoa tiquiro pacoro tiquiro bahana mehna sopecahapʉ ducu, tiquirore yahu duari. ");
INSERT INTO pirNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Sa yero ihcãquiro Jesure yahuri: —‍Mʉhʉ paco mʉhʉ bahana mehna mʉhʉre yahu duaye sopecahapʉ ducuri, nidi. ");
INSERT INTO pirNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Tiquiro sa nigʉ̃ tʉhoro topʉ ijiyequinare ohõ saha nidi Jesu tiquinare buhero taro: —‍¿Noa ijiajari yʉhʉ paco, yʉhʉ bahana gʉ̃hʉ, mʉsa ihñagʉ̃? nidi. ");
INSERT INTO pirNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Sa nino, ʉsãre tiquiro buhenare ñupuha, ohõ saha nidi: —‍Ahriquina ijire yʉhʉ paco, yʉhʉ bahana yero saha ijiyequina. ");
INSERT INTO pirNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tiquina yʉhʉ Pacʉ ʉhmʉse cjʉ̃no tiquiro cahmeñene yere. Sa yeyequina yʉhʉ bahʉ, yʉhʉ baho, yʉhʉ paco yero saha ijire, nidi Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ti decota Jesu wʉhʉpʉ ijiriquiro wijiari. Wijia, ditarapʉ waha, ditara dʉhtʉ cahapʉ dujiri. ");
INSERT INTO pirNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tiquiro sa dujigʉ̃ ihñañe peyequina masa tiquiro cahapʉ cahmecoa wahpaa waha, bihsaro yeri Jesure. Sa bihsagʉ̃ ihñano yucʉsapʉ sajã, tiapʉ dujiri tiquiro. Masa pehe padʉropʉ ducuri. ");
INSERT INTO pirNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Sa yero tiquiro peye queoye mehna yahuri tiquinare, buhero taro. Ohõ saha nidi tiquiro: —‍Oteriquiro otero wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tiquiro sa otero wahagʉ̃ apeye pjeri maha dʉhtʉ cahapʉ bora quehe sahye. Topʉ bora quehe saye pjerire minicjʉa ahta, ihya cãhye. ");
INSERT INTO pirNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Sa ye apeye pjeri ʉtã paca watoa bora quehe sahye. Ʉtã paca watoa dihta marieda cjũnopʉ duita pihnimahye. ");
INSERT INTO pirNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Sa pihnieperota asʉ̃ tutuaro asigʉ̃, nʉhcori marieda, ñaia wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Apeye pjeri taa watoa bora quehe sahye. Taa pehe dia yʉhdʉa waha, oteye pehere wejẽahye. ");
INSERT INTO pirNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Apeye pjeri quehnoari yehpapʉ bora quehe sahye. Quehnoano pihni, dʉca tiahye. Apeye cjʉ cien pjeri, apeye cjʉ sesenta pjeri, apeye cjʉ treinta pjeri dʉca tiahye. ");
INSERT INTO pirNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ahrire quehnoano tʉhoya mʉsa, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Tiquiro sa nidi bato ʉsã tiquiro buhena tiquiro cahapʉ esa, sinituu ʉsã tiquirore: —‍¿Dʉhse yegʉ masare queoye mehna buheajari mʉhʉ? ni, sinituu ʉsã. ");
INSERT INTO pirNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesu yʉhtiri: —‍Ʉhmʉse cjʉ̃no tiquiro pʉhtoro ijiyere panopʉ cjẽna tiquina masiedarire mʉsare yʉhʉ buhenare masigʉ̃ yere Cohãcjʉ̃. Apequina pehere sa yerare tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Sa yero masiñequinare masi nemogʉ̃ yerota tiquiro. Sa yeye tiquina pehe quehnoano masieta. Masieñequina pehe mehenogã tiquina masiepegʉ̃ta tiquina pehere masiedagʉ̃ yerota tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Sa yegʉ queoye mehna buheaja. Ohõ saha ijire. Yojopʉ cjẽna ihñaepeta, ihñedariquina yero saha tojoare. Sa yeye tʉhoepeta masiedare. Tire tʉhoeyequina yero saha ijire tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Sa ijiyequina ijiye Isaia panopʉ cjʉ̃no tiquiro ni ojoariro sahata yere tiquina. Ohõ saha ni ojoahye: Ohõ saha nine Cohãcjʉ̃: “Cohãcjʉ̃ yere tʉhonata mʉsa. Sa tʉhoepenata, ne masisi mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ahriquina masa dapu paca bʉtiyequina tojoare. Sa ye tiquina cahmo coperire bihare, ‘tʉhoari’, niñe. Tiquina caperire ihmitihãre, ‘ihñari’, niñe. Sa yeraye quehnoano ihñañe, masiboaga tiquina. Sa ye tʉhoye, masiboaga tiquina. Tiquina wacũñepʉ quehnoano masiboaga. Sa masiñe yʉhʉre Cohãcjʉ̃re cahmeboaga tiquina. Sa yʉhʉre cahmegʉ̃ tiquina ñañene cohã, tiquinare pecapʉ wahaboriquinare yʉhdʉgʉ̃ yeboaga yʉhʉ”, nine Cohãcjʉ̃, ni ojoahye Isaia. ");
INSERT INTO pirNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Mʉsa pehe mʉsa caperi mehna ihñana, masine. Mʉsa cahmo mehna tʉhona, masine. Sa yena bucuena ijire mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mʉsare niita niaja. Yojopʉ mʉsa ihñañene mʉsa tʉhoyere panopʉ cjẽna Cohãcjʉ̃ yequina tutuaro ihña duamahye. Cohãcjʉ̃ yere yahu mʉhtariquina gʉ̃hʉ tire tutuaro ihña duamahye. Sa ihña duepeta ne ihñedahye. Yojopʉ mʉsa tʉhoye gʉ̃hʉre tutuaro tʉho duamahye tiquina. Sa masi duepeta tire masiedahye, ni yahuri Jesu ʉsãre tiquiro buhenare. ");
INSERT INTO pirNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Came Jesu ʉsãre yahu nemori: —‍Tʉhoya mʉsa. Oteriquiro queoyere mʉsare yahutja. Yʉhʉre tʉhona, quehnoano masiña. ");
INSERT INTO pirNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Oteye pjeri quehnoañe buheye yero saha ijire. Sa yeye maha dʉhtʉ cahapʉ borari pjeri quehnoañe buheye yero saha ijire. Sa yeye masa quehnoañe buheyere tʉhoepeta ne masiedare. Sa yero masa quehnoañe buheyere tiquina tʉhogʉ̃ ihñano watĩno pehe ahta, ti buheyere quehnoañe buheyere masi dutierare masare. Minicjʉa ti pjerire tiquina dote nediro saha yere watĩno. ");
INSERT INTO pirNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Sa ye ʉtã paca watoa borari pjeri quehnoañe buheye yero saha ijire. Sa yeye masa quehnoañe buheyere tʉho, bucueye mehna duita tire tʉho nene. ");
INSERT INTO pirNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Sa tʉho nepeta ʉtã paca watoa ijiye cjʉ nʉhcori marieñe cjʉ yero saha ahriquina masa gʉ̃hʉ tutuerare. Sa tutueraye ñano yʉhdʉye, yeequina tiquina ijiri buhiri apequina tiquinare ñano yegʉ̃ ihñañe yee pehere duhu cãhre. Apequina tiquinare ñano yegʉ̃ tire ihcãno sahaeraye, yeere duhu cãhre. ");
INSERT INTO pirNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Sa ye taa watoa borari pjeri quehnoañe buheye yero saha ijire. Sa yeye masa quehnoañe buheyere tʉhoepeta, ahri yehpa cjẽne pajiro bʉjʉa witi tʉhotuye, niñeru pehere cahĩne. Tiquina sa yegʉ̃ ti pehe quehnoañe buheyere cahmotare. Sa cahmotagʉ̃ masa quehnoañe pehere yerare. ");
INSERT INTO pirNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Sa ye quehnoari yehpapʉ borari pjeri quehnoañe buheye yero saha ijire. Sa ye masa quehnoañe buheyere tʉhoye, tire quehnoano masine. Sa masiñequina ijiye, Cohãcjʉ̃ cahmeno sahata quehnoañene yere tiquina. Ihquẽquina pajiro quehnoañene yere cien pjeri dʉca tiro saha. Apequina doca cjũnogã quehnoañene yere sesenta pjeri dʉca tiro saha. Apequina mehenogã quehnoañene yere treinta pjeri dʉca tiro saha, ni yahuri Jesu ʉsãre. ");
INSERT INTO pirNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Sa ye pari turi queoye mehna buheri Jesu: —‍Ʉhmʉse cjʉ̃no tiquiro pʉhtoro ijiye ohõ saha ijire. Wese upʉro tiquiro wesepʉ quehnoañe pjerire tiquiro oteriro saha ijire ʉhmʉse cjʉ̃no tiquiro pʉhtoro ijiye. ");
INSERT INTO pirNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Wese upʉro ijipihtiyequina tiquiro mehna cjẽna gʉ̃hʉ tiquina carĩno watoa tiquirore ihña tuhtiriquiro ahtahye. Sa ahtaro trigore ti oteriropʉ taare oteahye. Ote tuhasa wahaa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Came trigo pihniahye. Sa ye ti dʉca tiro taro yegʉ̃ waro diaa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Sa ye wese upʉrore dahra cohteyequina tiquiro cahapʉ esa, yahuahye: “¿Pʉhto, quehnoañe pjeri dihitare mʉhʉ wesere mʉhʉ otepegʉ̃ta, dʉhse ye taa gʉ̃hʉ diajari ti wesere?” nidi tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Yʉhʉre ihña tuhtiriquiro ijiaga ti taare oteriquiro”, niahye wese upʉro. “¿Taare ʉsã curegʉ̃ cahmeajari mʉhʉ?” nimahye tiquirore dahra cohteyequina. ");
INSERT INTO pirNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Taare cureracãhña, ‘Trigo pehere cureari’, nina. ");
INSERT INTO pirNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Trigo taa mehnata bʉcʉarĩahdo. Dʉca nedi pje ijigʉ̃ neñequinare ohõ saha niitja: ‘Taare cure mʉhtaña. Tuhasa mʉsa curerire ʉjʉ̃aña. Came trigore peheya. Pehe peho, tire yʉhʉ ihbori wʉhʉpʉ cũña’, niitja tiquinare”, niahye wese upʉro, nidi Jesu, queoye mehna yahuro. ");
INSERT INTO pirNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Sa ye apeye queoye mehna ʉsãre ohõ saha ni buheri tja: —‍Ʉhmʉse cjʉ̃no tiquiro pʉhtoro ijiye mostaza pjegã yero saha ijire. Ti pjegã meheni pjegã waro ijire. ");
INSERT INTO pirNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ti pjegãre wesepʉ tiquiro oteri bato, quehnoano pihnine. Sa yero paji yʉhdʉadʉ wahare. Sa wahagʉ̃ minicjʉa pari ti dʉpʉripʉ suhti suhare, ni yahuri Jesu. (Sa nino ohõ saha nino niahye. Mostaza pjegã pajidʉ tʉ bʉcʉariro saha ʉhmʉse cjʉ̃nore mari pʉhtorore masiñequina meheñequinagã tiquina iji mʉhtaepegʉ̃ta camepʉ peyequina wahaeta.) ");
INSERT INTO pirNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Sa ye apeye queoye mehna ʉsãre ohõ saha ni buheri tja: —‍Ʉhmʉse cjʉ̃no tiquiro pʉhtoro ijiye pãre pugʉ̃ yeye yero saha ijire. Tire numino ihcã ajuro trigore aco mehna quehnoano tire dahra morene pã bʉcʉatire. Ticoro sa yegʉ̃ pãre pugʉ̃ yeye pehe trigore quehnoano sehsaa wahare, nidi Jesu. (Sa nino ohõ saha nino niahye. Pãre pugʉ̃ yeye trigore ti sehsaa wahariro saha ʉhmʉse cjʉ̃nore mari pʉhtorore peyequina masa ijipihtiro cjẽna masieta.) ");
INSERT INTO pirNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ahri ijipihtiyere buhero, queoye mehna yahuri Jesu. Queoye marieno yahuerari tiquiro tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Sata yeri tiquiro Cohãcjʉ̃ yere yahu mʉhtariquiro ni ojoariro sahata. Ohõ saha ni ojoahye panopʉ: Queoye mehna yahutja. Cohãcjʉ̃ ahri yehpare tiquiro bajumehnedi bato ne masare tiquiro yahuerarire yahutja, ni ojoahye Cohãcjʉ̃ yere yahu mʉhtariquiro mʉnano. ");
INSERT INTO pirNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Sa ye masare cohe ti, wʉhʉpʉ sajãa wahari Jesu. Sa yena ʉsã tiquiro buhena tiquiro cahapʉ esa, sinituu ʉsã: —‍Trigo watoa taa diari queoyere yahu pehoya ʉsãre, nii ʉsã tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesu yʉhtiri ʉsãre: —‍Wese upʉro quehnoañe pjerire oteriquiro yero saha ijiaja yʉhʉ. Yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ ijiaja. ");
INSERT INTO pirNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Wese pehe ahri yehpa yero saha ijire. Quehnoañe pjeri pihniñe ʉhmʉse cjʉ̃no pʉhtoro ijiropʉ ijiatiquina yero saha ijire. Taa pehe watĩno yequina yero saha ijire. ");
INSERT INTO pirNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Wese upʉrore ihña tuhtiriquiro taare oteriquiro watĩno yero saha ijire. Tire nedi pje pihtiri deco yero saha ijire. Sa ye trigore neñequina angele yero saha ijire. ");
INSERT INTO pirNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Taare tiquina cure ʉjʉ̃ariro saha pihtiri deco ijigʉ̃ watĩno yequinare pecapʉ cohãeta tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ yequina angelere ohogʉtja. Yʉhʉ ohogʉ̃ angele pehe ñañene ye dutiyequinare, ñañene yeyequinare yʉhʉ pʉhtoro ijiropʉ neañeta. ");
INSERT INTO pirNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ne sa tuhasa pecapʉ cohãeta tiquinare. Topʉ tiquina tutuaro uti, bʉjʉa witiye mehna bahque dihoeta. ");
INSERT INTO pirNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Sa ye Cohãcjʉ̃ yequina tiquina Pacʉro tiquiro pʉhtoro ijiropʉ ijieta. Topʉ ijiye, asʉ̃ deco cjʉ̃no yero saha quehnoano buhrioeta tiquina. Ahrire quehnoano tʉhoya mʉsa, ni yahuri Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Sa ye apeye queoye mehna yahuri tja: —‍Ʉhmʉse cjʉ̃no tiquiro pʉhtoro ijiye niñeru tiquiro nʉori yero saha ijire. Masʉno tire wesepʉ wacũeno mehna boca, pari turi tire nʉo nemoahye. Sa bocaro tutuaro bucueahye tiquiro. Sa yero tiquiro bocarire neno taro, ti wesere dú duahye. Sa yero tiquiro yere dua peho, ti wesere dúahye, ni yahuri Jesu. (Sa nino ohõ saha nino niahye. Ʉhmʉse cjʉ̃no tiquiro pʉhtoro ijiye tiquiro bocari yero saha ijire. Tiquiro bocarire tiquiro tutuaro cahmediro sahata ʉhmʉse cjʉ̃nore masa pʉhtorore tiquina masidi bato masa tutuaro cahmene tiquirore.) ");
INSERT INTO pirNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Sa ye apeye queoye mehna yahuri tja: —‍Ʉhmʉse cjʉ̃no tiquiro pʉhtoro ijiye wapa bʉjʉye pjerire perla wame tiye pjerire dúriquiro yero saha ijire. ");
INSERT INTO pirNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ti pjerire macano quehnoa yʉhdʉari pjere bocahye. Bocaro, ti pjere dú duaro, ijipihtiye tiquiro yere dua pehoro wahahye. Sa dua tuhasa ti pjere wapa bʉjʉri pjere dúahye, nidi Jesu. (Sa nino ohõ saha nino niahye. Ti pjere perla pjere tiquiro cahmediro sahata ʉhmʉse cjʉ̃nore masa pʉhtorore quehnoano tiquina masidi bato masa tutuaro cahmene tiquirore.) ");
INSERT INTO pirNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Sa ye apeye queoye mehna Jesu yahuri tja: —‍Ʉhmʉse cjʉ̃no tiquiro pʉhtoro ijiye wẽñanʉ tiquina doque ñodʉ yero saha ijire. Tʉ wẽñanʉ mehna peyequina wahi sijoro saha ijiyequinare ñehene. ");
INSERT INTO pirNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Tʉ wahpaa wahagʉ̃ wahi wejẽñequina pehe tʉre padʉropʉ weje nʉjʉa, quehnoañequina wahire besere. Quehnoañequinare tiquina pʉhʉsepʉ bese sajãre. Ñañequina wahire cohãre. ");
INSERT INTO pirNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Pihtiri deco ijigʉ̃ ohõ saha ijirota. Angele pehe masare beseeta. Ñañequinare ne wioeta quehnoañequina cahapʉ ijiyequinare. ");
INSERT INTO pirNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ne wio, tiquinare pecapʉ cohãeta. Topʉ tiquina uti, tutuaro bʉjʉa witiye mehna upiri bahque dihoeta ñañequina pehe, ni yahuri Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Tiquiro sa ni yahuri bato sinituri ʉsãre: —‍¿Ahri ijipihtiyere tʉhoajari mʉsa? ni sinituri tiquiro. —‍Tʉhoaja ʉsã, ni yʉhtii ʉsã. ");
INSERT INTO pirNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ʉsã sa nigʉ̃ tiquiro yahuri ʉsãre: —‍Judio masare buheyequina ʉhmʉse cjʉ̃no tiquiro pʉhtoro ijiyere buheye, pʉaro buheyere yahure. Mʉna buheyere, wahma buheye gʉ̃hʉre yahure. Tiquina wʉhʉ upʉro yero saha ijire. Tiquiro wʉhʉpʉ ijiyere quehnoañene ne wioro, wahmare, mʉna gʉ̃hʉre ne wiore tiquiro, nidi Jesu ʉsãre. ");
INSERT INTO pirNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ti queoyere tiquiro buheri bato, wahaʉ ʉsã tiquiro mehna. ");
INSERT INTO pirNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Waha, tiquiro masari macapʉ esaʉ. Topʉ esa, judio masa mari buheye wʉhʉsepʉ buheri tiquiro. Tiquiro sa buhegʉ̃ tʉhoye, tʉho maria wahari tiquina. —‍¿Ahriquiro nohopʉ tʉhoyari ahri buheyere? ¿Dʉhsero quehnoano masi pehoajari tiquiro? Cohãcjʉ̃ tutuaye mehna ye ihñore tiquiro basi. ");
INSERT INTO pirNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ahriquiro taboa dahrariquiro macʉno ijire. Sa ye tiquiro pacoro María ijire. Sa ye Santiago, José, Simo, Juda, tiquiro bahana ijire. ");
INSERT INTO pirNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Yojopʉre tiquiro bahana numia ahri macapʉ ijire. Sa yero tiquiro mari yero saha ijiriquiro ijire. ¿Sa ijieperota nohopʉ tʉhoyari tiquiro ahri buheyere? ni yahuducuri tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Sa ye tiquina tiquirore cahmedari. Tiquina sa cahmedagʉ̃ ihñano ohõ saha nidi Jesu tiquinare: —‍Cohãcjʉ̃ yere yahu mʉhtariquirore apequina ño peore. Tiquina sa ño peoepegʉ̃ta tiquiro ya maca cjẽna, tiquiro acaye tiquirore ño peoerare. Sa yena yʉhʉre ño peoerare mʉsa ohõpʉ yʉhʉ masarigʉ ijigʉ̃, nidi tiquiro tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Sa yero tiquirore tiquina wacũ tutueragʉ̃ ihñano, ti macapʉ Cohãcjʉ̃ tutuaye mehna peye tahari ye ihñoedari Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ti pjere Herode Galilea cjʉ̃no pʉhtoro Jesu yerire tʉhooahye. ");
INSERT INTO pirNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Sa tʉhooro ohõ saha nimahye: —‍Ñu wame yeriquiro ijiaga masatjiãno. Sa yero yojopʉre tiquiro masari bato ahri tutuayere cʉore tiquiro bajumehneñene yero, nimahye Herode tiquiro cahacjẽnare. Jesure “Ñuta ijire”, ni tʉhotumahye tiquiro Ñure tiquina wejẽdi bato. ");
INSERT INTO pirNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","5","Sa yero Ñure tiquiro wejẽ dutiato pano Herode tiquiro bahʉro Felipe namonore namo tiahye. Tiquiro sa yegʉ̃ ihñano Ñu wame yeriquiro Herode pehere ohõ saha nie timahye: —‍Mʉhʉ bahʉ namonore namo tigʉ Cohãcjʉ̃ dutiyere yʉhdʉdʉcagʉ nine mʉhʉ, nie timahye Ñu. Tiquiro sa nidi buhiri Herode tiquirore wejẽ duamahye. “ ‘Ñu Cohãcjʉ̃ yere yahu mʉhtariquiro ijire’, ni tʉhoturi judio masa”, nino, tiquina pehere cueahye Herode. “Ñure yʉhʉ wejẽgʉ̃ tiquina usuaboaga”, nino tiquinare cueahye. Sa cuero Ñure wejẽ dueramahye. Sa wejẽ dueraperota Herode tiquirore ñehe dʉhte duti, peresu yeahye. Tiquiro namono Herodia dutiro mehna sa yeahye Herode. ");
INSERT INTO pirNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Sa ye Herode masa bajuari deco ijigʉ̃ bose deco yeahye tiquiro. Topʉ Herodia macono bose deco wihiyequina tiquina ihñonopʉ basa ihñoahye. Ticoro sa basa ihñogʉ̃ ihñano Herode bucueahye. Sa bucuero ticorore niahye: ");
INSERT INTO pirNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","—‍Cohãcjʉ̃ mehna poto niita niaja. Yʉhʉre mʉhʉ sinino punota ohogʉtja yʉhʉ mʉhʉre, niahye Herode pehe Herodia maconore. ");
INSERT INTO pirNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tiquiro sa nigʉ̃ tʉhoro Herodia ticoro maconore ticoro siniatire yahuahye ticorore. Ticoro sa yahugʉ̃ ticoro macono pehe ohõ saha ni siniahye Herodere. —‍Ñu wame yeriquiro dapure dʉte sure dutiya. Sa yegʉ waparo mehna tiquiro dapure ohoya yʉhʉre, niahye ticoro. ");
INSERT INTO pirNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ticoro sa nigʉ̃ tʉhoro Herode tutuaro bʉjʉa witiahye. Masa tiquina ihñonopʉ “Ohogʉtja mʉhʉre”, niahye tiquiro. Sa yero tiquiro bʉe tiro “Mʉhʉre ohoeraja”, ni masiedahye ticorore. Sa yero ticoro dutiriro sahata Herode pehe tiquiro cahacjẽnare Ñure wejẽ dutiahye. ");
INSERT INTO pirNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Sa yero Ñu dapure dʉte sure dutiahye. ");
INSERT INTO pirNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Sa dʉte sure tuhasa, waparo mehna tiquiro dapure ne cãhtahye tiquina. Herodia maconore tiquiro dapure tiquina ohogʉ̃, ticoro pehe ticoro pacorore yʉhdʉoahye tja. ");
INSERT INTO pirNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Tiquina sa yeri bato Ñu buheyequina ahta, tiquiro pagʉre masa copepʉ nea cũahye. Sa cũ tuhasa, tiquina tire Jesure yahuye wihiri. ");
INSERT INTO pirNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Tiquina sa ni yahugʉ̃ tʉhoro, Jesu ʉsã mehna yucʉsapʉ sajã, masa marienopʉ siho wahari. Jesu topʉ wahagʉ̃ tʉhoye, masa tiquina ye macaripʉ ijiriquina ahta, mahapʉ tiquirore nʉnʉ tã cãa wahari. ");
INSERT INTO pirNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Sa yero ʉsã wahã sari bato tiquiro peyequina masare ihñano, paja ihñari tiquinare. Sa paja ihñano tiquina mehna cjẽna dohatiyequinare yʉhdʉgʉ̃ yeri. ");
INSERT INTO pirNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ñamicahapʉ ʉsã tiquiro buhena tiquirore ohõ saha nii: —‍Ñamicahapʉ waharo nine. Ohõ masa marienopʉ ijire. Sa yegʉ macaripʉ masare tiquina ihyatire dú dutiya tiquina pohe tiatire, nimi ʉsã tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesu yʉhtiri ʉsãre: —‍Wahaeracãhdo tiquina. Mʉsa basita ihyayere ohoya tiquinare, nidi ʉsãre. ");
INSERT INTO pirNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","—‍Ihcã omope paca pã paca, wahi pʉaro to punota ijire ʉsãre, ni yʉhtii ʉsã. ");
INSERT INTO pirNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","—‍Tire yʉhʉre ne cãhtaya mʉsa, nidi ʉsãre. ");
INSERT INTO pirNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Tiquiro sa nigʉ̃ tʉhona neaʉ ʉsã. Ʉsã ne sari bato taa bui masare tiquiro duji dutiri. Tiquina dujigʉ̃ ihcã omope paca pã pacare, pʉaro wahire ne, ʉhmʉsepʉ ihña mʉo, Cohãcjʉ̃re “Quehnoare”, nidi. Sa ninota pã pacare nuhano, ʉsãre tiquiro buhenare ohori. Tiquiro sa ohogʉ̃ ʉsã pehe tire masare itii. ");
INSERT INTO pirNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Sa ye ijipihtiyequina quehnoano ihya, yapi yʉhdʉa wahari. Tiquina yapi wehorire doce pʉhʉse waro ne cahmecoa, wahpo dapou ʉsã tiquiro buhena. ");
INSERT INTO pirNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Topʉ tire ihyariquina ʉmʉa dihitare queogʉ̃ cinco mil ʉmʉa ijiri. Numia, macanagã gʉ̃hʉ ijiri. ");
INSERT INTO pirNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Came ʉsãre tiquiro buhenare Jesu ditara ape sie pahrẽpʉ pehãyu dutiri masare tiquiro cohe tiri watoa. ");
INSERT INTO pirNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Cohe ti tuhasa, cʉnʉpʉ mʉja, Cohãcjʉ̃re sinino wahahye. Ñamine topʉ tiquiro ihcãquirota ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ti pjeta ditara decopʉ yucʉsa mehna pehãducuna nimi ʉsã. Wihnono tutuaro ahta, pahcõri bʉjʉye wahcã, yucʉsare quẽ sajãri. ");
INSERT INTO pirNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Sa wahagʉ̃ bohrea mʉja tato pano Jesu aco bui tini cãhtari ʉsã cahapʉ. ");
INSERT INTO pirNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ʉsã cahapʉ tiquiro ahtagʉ̃ ihñana cue nii ʉsã. Sa cuena sañuducumi ʉsã. —‍Yariariquiro mʉnano pagʉ ijire, ni sañuducumi ʉsã. ");
INSERT INTO pirNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ʉsã sa cuegʉ̃ ihñano Jesu ohõ saha nidi: —‍Ne yʉhʉre ihña cueracãhña. Yʉhʉta ijiaja, nidi ʉsãre. ");
INSERT INTO pirNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Tiquiro sa nigʉ̃ tʉhoro Pedro nidi tiquirore: —‍Pʉhto, potota mʉhʉta ijigʉ, aco bui yʉhʉre mʉhʉ cahapʉ ducu cã dutiya, nidi tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","—‍Ahtaya, ni yʉhtiri tiquiro pehe. Tiquiro sa nigʉ̃ Pedro yucʉsare dijia, aco bui Jesu cahapʉ ducu cãmedi. ");
INSERT INTO pirNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Wihnono tutuaro ahtagʉ̃ ihñano cueri tiquiro. Sa cuero diha dijiaa wahamedi. —‍Yʉhʉre yedohoya pʉhto, ni sañuducuri tiquiro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Tiquiro sa nigʉ̃ta tiquiro omocare ñehe, —‍Mehenogã wacũ tutuare mʉhʉ yʉhʉre. ¿Dʉhsegʉ yʉhʉre wacũ tutuerajari mʉhʉ? nidi tiquiro Pedrore. ");
INSERT INTO pirNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Tiquiro sa nidi bato yucʉsapʉ sajãri tiquina. Tiquina sa sajãri bato wihnono yʉhdʉa wahari. ");
INSERT INTO pirNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Sa yena ʉsã tiquiro buhena yucʉsapʉ ijina Jesure ño peou. —‍Potota mʉhʉ Cohãcjʉ̃ macʉta ijire, nii ʉsã tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Sa yeri bato pehã, Genesare wame tiri yehpapʉ esaʉ. ");
INSERT INTO pirNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","To cjẽna Jesure ihña masidi. Sa masiñe tiquiro cahapʉ ijiyequinare dohatiyequinare ne cãhta dutiri. Sa ye tiquina dohatiyequinare tiquiro cahapʉ ne cãhtari. ");
INSERT INTO pirNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","—‍Mʉhʉ suhtiro dʉhtʉ caha dihitare ʉsãre ñehe tuhu dutiya, ni sinidi tiquina Jesure. Sa ye tiquiro suhtirore ñehe tuhuriquinape topequinata quehnoa wahari. ");
INSERT INTO pirNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Sa ye Jerusalẽ cjẽna, fariseo masa, marine judio masare buheyequina mehna Jesu cahapʉ wihiye, sinituri tiquirore: ");
INSERT INTO pirNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—‍¿Dʉhse ijiro boro mari acaye bʉcʉna mʉnapʉ tiquina dutirire yerajari mʉhʉ buheyequina pehe? Tiquina ihyato pano tiquina dutiriro sahata omo coserare, nidi tiquina Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesu yʉhtiri tiquinare: —‍¿Dʉhse yena mari acaye panopʉ cjẽna ye dutiye dihitare yena tana Cohãcjʉ̃ ye dutiye pehere yerajari mʉsa pehe? ");
INSERT INTO pirNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ohõ saha nine Cohãcjʉ̃: “Mʉsa pacʉsʉmʉare ño peoya”, nine. Sa yero “Ihcãquiro tiquiro pacʉsʉmʉare ñañene quiti dahreriquiro ijiro ti buhiri apequina tiquina wejẽatiquiro ijirota”, nine Cohãcjʉ̃. ");
INSERT INTO pirNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Tiquiro sa niepegʉ̃ta ohõ saha ye dutire mʉsa pehe tiquina pacʉsʉmʉare yedoho dutierana: Tiquina pacʉsʉmʉare ohoborire Cohãcjʉ̃ pehere oho dutire mʉsa. Sa ni buhemene mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Sa buhena tiquina pacʉsʉmʉare ño peogʉ̃ yerare mʉsa. Mʉsa sa yena Cohãcjʉ̃ dutiyere yʉhdʉdʉcana nine mʉsa, mari acaye panopʉ cjẽna ye dutiye dihitare yena. ");
INSERT INTO pirNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Masa tiquina ihñono dihita quehnoano iji mehona ijire mʉsa. Cohãcjʉ̃ yere yahu mʉhtariquiro Isaia mʉsare potota yahu ojoahye panopʉre: ");
INSERT INTO pirNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ahriquina masa yʉhʉre quehnoano yahuducuepeta yʉhʉre ne ño peoerare. ");
INSERT INTO pirNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Sa ye yʉhʉre tiquina ñu buheye ne dʉhseati ijierare. “Cohãcjʉ̃ ye dutiye ijire ahri”, ni meho buhere tiquina ye buheye pehere, ni ojoahye Isaia, nidi Jesu fariseo masare, mari judio masare buheyequina gʉ̃hʉre. ");
INSERT INTO pirNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Sa ni tuhasa tiquiro cahapʉ masare pijio, ohõ saha nidi: ");
INSERT INTO pirNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","—‍Tʉhoya mʉsa. Yʉhʉ niñene quehnoano masiña mʉsa. Mʉsa dʉserire sajãñe pehe mʉsa ihyaye pehe mʉsare ñana ijigʉ̃ yerare. Mʉsa ñañe yahuducuye pehe mʉsa dʉseri wijiaye pehe mʉsare ñana ijigʉ̃ yere, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tiquiro sa ni buheri bato ʉsã tiquiro buhena pehe tiquirore yahuu. —‍Mʉhʉ sa nigʉ̃ tʉhoye fariseo masa usuari, ni yahuu ʉsã tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Tire tʉho, ohõ saha ni yʉhtiri ʉsãre: —‍Tiquina fariseo masa taa yero saha ijire. Yʉhʉ Pacʉ ʉhmʉse cjʉ̃no ijipihtiye oteyere tiquiro oterarire nʉhcori mehnata cure, cohãnota. Sata yerota tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Tiquinare sa ihña cãhña mʉsa. Tiquina caperi bajueyequina tiquina ihña masiedaro saha ne Cohãcjʉ̃ yere masiedare. Sa ye pecapʉ wahaeta. Sa masiedapeta apequina masieñequinare buhe duamedi. Sa ye caperi bajueyequina copepʉ tiquina boraboriro saha tiquina buhenohriquina gʉ̃hʉ pecapʉ wahaeta, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Tiquiro sa nigʉ̃ tʉhoro Pedro nidi: —‍Ahri quitire masa tiquina dʉseri wijiaye quitire yahu nemoña ʉsãre tja, nidi tiquiro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesu yʉhtiri: —‍¿Ne, yojopʉ tʉhoerajari mʉsa? ");
INSERT INTO pirNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Masa ihyayere ihyagʉ̃ tiquina dʉseripʉ sajãre. Sa ye tiquina paapʉ sajã, yʉhdʉa wahare. Ihyo waro ijire. Mari ihyaye marine ñana wahagʉ̃ yerare. ¿Ahrire masiedajari mʉsa? ");
INSERT INTO pirNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Masa dʉseripʉ wijiaye, tiquina yahuducuye pehe tiquina tʉhotuyepʉ ahtare. Tiquina yahuducuye pehe ñañe ijiro, masare ñañequina ijigʉ̃ yere. ");
INSERT INTO pirNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ñañe tʉhotuye, masare wejẽñe, apequiro namono mehna ñano yeye, ñano yeye numia mehna ñano yeye, yaqueye, ni mehoñe, masare ñañe quiti dahreye masa tʉhotuyepʉ ahtare. ");
INSERT INTO pirNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ti ñañe pehe masare ñañequina ijigʉ̃ yere. Sa yepegʉ̃ta bʉcʉna yee tiriro sahata masa omo coserapeta tiquina ihyagʉ̃ ti masare ñañequina ijigʉ̃ yerare, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Sa ni buhe tuhasa, ʉsãre siho wahari tja. Tiro wame tiri maca cahapʉ Sidõ wame tiri maca cahapʉ esaʉ ʉsã. ");
INSERT INTO pirNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ʉsã topʉ esagʉ̃ Canaa yehpa cjõno topʉ ijiricoro Jesu cahapʉ esa, sañuducuri: —‍Pʉhto, Davi panami iji turiagʉ masare yʉhdʉoacjʉ, yʉhʉre paja ihñaña mʉhʉ. Yʉhʉ maco watĩnore cʉoro, ña yʉhdʉaro yʉhdʉri ticoro, ni sañuducuri ticoro. ");
INSERT INTO pirNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ticoro sa niepegʉ̃ta Jesu yʉhtierari. Sa yegʉ̃ ihñana ʉsã tiquiro buhena pehe tiquirore ohõ saha nimi. —‍Waha dutiya ticorore. Ñano cariboro bisiaga, nimi ʉsã. ");
INSERT INTO pirNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ʉsã sa nigʉ̃ tʉhoro yʉhtiri ticorore: —‍Israe masare Cohãcjʉ̃re masieñequina dihitare yedoho dutiro ohori yʉhʉ Pacʉ yʉhʉre, nidi tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Tiquiro sa niepegʉ̃ta Jesu dahpocãri cahapʉ dʉsepe curi mehna quehe sari ticoro. —‍Pʉhto, yedohoya yʉhʉre, nidi ticoro. ");
INSERT INTO pirNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesu yʉhtiri ticorore. —‍Ohõ saha ijire ahri: Coã warore wʉhʉ upʉro pohne ye ihyayere diayeare oho mʉhtagʉ̃ quehnoaedare. Israe masa yere ape yehpa cjẽnare yʉhʉ oho mʉhtagʉ̃ quehnoaedare, nidi Jesu ticorore queoye mehna yahuro. ");
INSERT INTO pirNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","—‍Sata ijire pʉhto. Sa ijiepegʉ̃ta diayea gʉ̃hʉ wʉhʉ upʉro mesa docapʉ tiquina ihya site boroyere ihya cohtere tiquina gʉ̃hʉ. Ape yehpa cjõ yʉhʉ ijiepegʉ̃ta yʉhʉ gʉ̃hʉre yedoho masine mʉhʉ, ni yʉhtiri ticoro. ");
INSERT INTO pirNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ticoro sa nigʉ̃ tiquiro yʉhtiri: —‍Numio, mʉhʉ yʉhʉre tutuaro wacũ tutuare. Mʉhʉ cahmeno sahata sa waharota, nidi Jesu ticorore. Tiquiro sa nigʉ̃ta duita quehnoa wahari ticoro macono. ");
INSERT INTO pirNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Sa ni tuhasa ʉsãre siho waha, Galilea wame tiri ditara dʉhtʉ cahapʉ siho esari tja. Esa, mehenʉgã cʉnʉre mʉja, tʉ buipʉ dujiri. ");
INSERT INTO pirNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Topʉ tiquiro ijigʉ̃ peyequina masa tini masieñequinare, caperi bajueyequinare, pari yuri wahayequinare, yahuducu masieñequinare, peyequina apequina dohatiyequinare tiquiro cahapʉ ne wihiri masa. Ne wihi tuhasa Jesu dahpocãri cahapʉ duhu cũri tiquina. Tiquina sa duhu cũri bato quehnoa wahagʉ̃ yeri Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Tiquiro sa yegʉ̃ ihñañe masa ihña maria wahari. Yahuducu masieñequina tiquina yahuducugʉ̃ ihñañe, pari yuri wahayequina tiquina quehnoa wahagʉ̃ ihñañe, tini masieñequina tiquina tinigʉ̃ ihñañe, caperi bajueyequina tiquina ihñagʉ̃ ihñañe, ihña maria wahari tiquina. Sa ye ohõ saha nidi: —‍Israe masa ʉsã pʉhto, Cohãcjʉ̃ tutuagʉ, quehnoagʉ ijire, ni ño peori tiquina Cohãcjʉ̃re. ");
INSERT INTO pirNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Tiquiro sa yeri bato Jesu ʉsãre tiquiro buhenare ohõ saha nidi: —‍Ahriquina masa yʉhʉ mehna ihtia deco waro iji tuhasare. Sa ye pohe mariedare tiquinare. Pohe mariedagʉ̃ ihñagʉ tiquinare paja ihñaja. “Tiquina ʉjʉa ahbayequina, mahapʉ borari”, nigʉ tiquinare ihyaye marieno tiquina ye wʉhʉsepʉ waha duti dueraja. Sa yegʉ tiquinare pohe oho duaja, nidi tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Tiquiro sa nigʉ̃ ʉsã tiquiro buhena tiquirore sinituu: —‍¿Dʉhse mari ohõre masa marienopʉre pãre boca ohoboagari mari? nii ʉsã tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","—‍¿Nohope paca pã pacare cʉoajari mʉsa? nidi. —‍Siete pã pacare, meheñequinagã wahire cʉoaja, ni yʉhtii ʉsã. ");
INSERT INTO pirNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ʉsã sa nigʉ̃ tiquiro masare yehpapʉ duji dutiri. ");
INSERT INTO pirNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Tuhasa siete pã pacare, wahigã gʉ̃hʉre ne, Cohãcjʉ̃re “Quehnoare”, nidi. Sa ninota pã pacare nuha, ʉsãre tiquiro buhenare ohori. Sa yena ʉsã pehe ti ihyayere masare itii. ");
INSERT INTO pirNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Sa ye masa tire ihya, yapi yʉhdʉa wahari. Tiquina yapi wehorire siete pʉhʉse waro ne cahmecoa, wahpo dapou ʉsã. ");
INSERT INTO pirNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Topʉ ihyariquinare ʉmʉa dihitare queogʉ̃ cuatro mil waro ʉmʉa ijiri. Numia, macanagã gʉ̃hʉ ijiri. ");
INSERT INTO pirNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Tiquina sa ihya tuhasagʉ̃ Jesu masare waha duti, yucʉsapʉ sajã, Magadán wame tiri yehpapʉ ʉsãre siho esari. ");
INSERT INTO pirNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Sa ye fariseo masa, saduceo masa mehna Jesu cahapʉ wihiri. Tiquiro ñano yegʉ̃ ihña duamedi tiquirore yahusã duaye. Sa ye tiquina tiquirore Cohãcjʉ̃ tutuaye mehna ye ihño dutimedi tiquiro masiedagʉ̃ ihña duaye, “Cohãcjʉ̃ ohoriquiro ijierare”, ni duaye. ");
INSERT INTO pirNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Tiquina sa ye dutigʉ̃ Jesu yʉhtiri tiquinare: —‍Ñamicahapʉ ʉhmʉano sohãgʉ̃ ihñana “Quehnoari ñami ijirota”, nine mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Sa yena bohrearo ʉhmʉano sohãgʉ̃, ñicuri deco ijigʉ̃ ihñana “Acoro ahtarota”, nine mʉsa. Sa quehnoano masiepenata Cohãcjʉ̃ tutuaye mehna mʉsare yʉhʉ ye ihñogʉ̃ ihñaepenata ne tire quehnoano masiedare mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Yojopʉ cjẽna ña yʉhdʉyequina Cohãcjʉ̃re ño peo dueyequina Cohãcjʉ̃ tutuaye mehna ye ihñogʉ̃ ihña duamene. Ye ihñosi yʉhʉ. Cohãcjʉ̃ yere yahu mʉhtariquiro Jona tiquiro dʉhse waharire masi tuhasare mʉsa. Ti dihitare ihñoutja mʉsare, ni yʉhtiri Jesu. Sa ni yahu tuhasa siho wahaa wahari tja. ");
INSERT INTO pirNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ditarare ʉsã pehãna, pãre bo cũ cã, pehã tari jii ʉsã. ");
INSERT INTO pirNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Sa yero Jesu ʉsãre yahuri: —‍Quehnoano yeya. Fariseo masa, saduceo masa tiquina ye pã pugʉ̃ yeyere ihñana quehnoano yeya. Cuarĩne ti, ni yahuri. ");
INSERT INTO pirNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Tiquiro sa nigʉ̃ tʉhona tʉho masiedana, ʉsã basi tire yahuducuu: —‍Mari pãre mari ne cãhtaeragʉ̃ ihñano sa niaga ahriquiro, nimi ʉsã basi. ");
INSERT INTO pirNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ʉsã sa nidire masino, ʉsãre sinituri: —‍¿Dʉhsena mʉsa pã borire wacũajari mʉsa? Mehenogã waro yʉhʉre wacũ tutuare mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Yojopʉ masiedajari mʉsa? ¿Cinco mil ʉmʉare ihcã omope pã pacare yʉhʉ nuha ohorire, numia gʉ̃hʉre yʉhʉ ohorire wacũedagari mʉsa? ¿Nohope pʉhʉse waro mʉsa ne cahmecoa wahpo daporire wacũedagari mʉsa? ");
INSERT INTO pirNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Sa yegʉ siete pã pacare nuha, cuatro mil ʉmʉare yʉhʉ ohorire, numia gʉ̃hʉre yʉhʉ ohorire wacũedagari mʉsa? ¿Nohope pʉhʉse waro mʉsa ne cahmecoa wahpo daporire wacũedagari mʉsa? ");
INSERT INTO pirNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Sa yena pã pugʉ̃ yeyere yʉhʉ yahugʉ̃ dʉhse yena quehnoano tʉhoerajari mʉsa? Sa nigʉ̃ pã warore nigʉ niedaja. Fariseo masa, saduceo masa tiquina pã pugʉ̃ yeyere ihñana quehnoano yeya. Cuarĩne ti, ni yahuri ʉsãre tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Tiquiro sa ni yahugʉ̃pʉ ʉsã masii. “Pã pugʉ̃ yeye”, nino pã warore nino niedari. Sa nino fariseo masa, saduceo masa tiquina buheyere nino nidi. “Tiquina ye buheyere tʉhoeracãhña”, nino nidi. ");
INSERT INTO pirNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Sa ye Jesu mehna wahana, Cesarea Filipo wame tiri maca cahapʉ ijiye macaripʉ esaʉ ʉsã. Sa yero macapʉ sajã sari bato Jesu ʉsãre tiquiro buhenare sinituri: —‍¿Noa boro ijiagari yʉhʉ, masa yʉhʉre tiquina tʉhotugʉ̃? ni sinituri tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","—‍“Ñu wame yeriquiro ijire”, nine mʉhʉre. Apequina “Elia ijire”, nine. Apequina “Jeremia ijiboaga o apequiro Cohãcjʉ̃ yere yahu mʉhtariquina mehna cjʉ̃no mʉnano ijiboaga”, nine, ni yʉhtii ʉsã tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","—‍¿Mʉsa pehe mʉsa tʉhotugʉ̃ noa boro ijiagari yʉhʉ? ni, sinituri tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simo Pedro yʉhtiri: —‍Mʉhʉ Cristo Cohãcjʉ̃ ohorigʉ ijire. Cohãcjʉ̃ catiriquiro waro macʉ ijire mʉhʉ, ni yʉhtiri Simo Pedro. ");
INSERT INTO pirNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","—‍Simo Ñu macʉ mʉhʉ bucuegʉ ijire. Ohõ saha ni mʉhʉ yʉhʉre yʉhtiye masa tiquina yahuri ijierare. Yʉhʉ Pacʉ ʉhmʉse cjʉ̃no pehe tire mʉhʉre masigʉ̃ yeri. ");
INSERT INTO pirNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Mʉhʉre niita niaja. Mʉhʉ Pedro wame tigʉ ijire. (Pedro nino ʉtã nino nine.) Ahri ʉtã paa bui tutuari wʉhʉre yʉhʉ yeboriro saha yeequina pehere wacũ tutuayequina ijigʉ̃ yeitja yʉhʉ. Sa ye yeequina ne pecapʉ wahasi. ");
INSERT INTO pirNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ʉhmʉse cjʉ̃no mari pʉhtoro ijiro cjã sawire mʉhʉre ohoutja. Sa yegʉ ahri yehpare mʉhʉ ye dutieragʉ̃ ʉhmʉsepʉ gʉ̃hʉre ye dutisi. Ahri yehpare mʉhʉ ye dutigʉ̃ ʉhmʉsepʉ gʉ̃hʉre ye dutiye ijieta, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Tiquiro sa nidi bato ʉsãre tiquiro buhenare ohõ saha nidi: —‍Yʉhʉre “Cristo ijire tiquiro”, ni yahu siteniedacãhña apequinare, ni, dutiri ʉsãre. ");
INSERT INTO pirNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ti pjeta Jesu ʉsãre tiquiro buhenare quehnoano yahu peho dʉcari: —‍Jerusalẽpʉ yʉhʉre waharo cahmene yojopʉre. Topʉ judio masa mari bʉcʉna, mari pahia pʉhtoa, marine judio masare buheyequina gʉ̃hʉ yʉhʉre ñano yeeta. Yʉhʉre wejẽeta. Sata ñano yʉhdʉro cahmene yʉhʉre. Sa yegʉ ihtia deco wahaboro masa wijiagʉta, ni yahuri ʉsãre tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Tiquiro sa nigʉ̃ tʉhoro Pedro pehe ape sie cjũnogã Jesure ne sadʉca, tiquirore ohõ saha nidi: —‍Pʉhto, mʉhʉ nino saha sa wahaeracãhdo. Mʉhʉre tiquina wejẽdacãhdo, nimedi tiquiro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Tiquiro sa nigʉ̃ tʉhoro Jesu majaredʉca, tiquirore ohõ saha nidi: —‍Satana yero saha yahuducugʉ nine mʉhʉ. Sa niedacãhña. Mʉhʉ tʉhotuye masa ye ijire. Cohãcjʉ̃ ye ijierare. Sa yegʉ yʉhʉ yeatire cahmota duare mʉhʉ, nidi Jesu Pedrore. ");
INSERT INTO pirNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Tiquiro sa nidi bato ʉsãre yahuri: —‍Ihcãquiro yaquiro iji duaro, tiquiro cahmeno ye duamedire duhu cãnota. Sa yero yaquiro tiquiro ijiri buhiri ñano yʉhdʉeperota yʉhʉre duhusi. Sa yero yeere yeducuriquiro ijirota. ");
INSERT INTO pirNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Masʉno yʉhʉre wacũno marieno tiquiro esa tuharo tiquiro cahmeno sahata yero, pecapʉ waharota. Sa yero yeere masʉno sa yeducuriquiro ijipihtiye decori yʉhʉ mehna ʉhmʉsepʉ ijirota tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Ihcãquiro masʉno ahri yehpa cjẽne ijipihtiyere cʉoriquiro Cohãcjʉ̃re cahmedaro pecapʉ waharo, yabere wapatajari tiquiro? Sa ijiriquiro ne wapataerare. Pecapʉ tiquiro jeripohna wahagʉ̃ ne dʉhse wapa ye wioro basioerare. ");
INSERT INTO pirNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ yeequina angele mehna ahri yehpapʉ tojoa tagʉ yʉhʉ Pacʉ asi siteye mehna tojoa tagʉ ijipihtiyequina masare tiquina ñañe yeri buhiri buhiri dahreitja. Tiquina quehnoañe pehere yegʉ̃ quehnoano yeitja tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ijirota mʉsare yahutja. Ihquẽquina mʉsa ohõpʉre ijina mʉsa yariato pano yʉhʉre yʉhʉ pʉhto sajãgʉ̃ ihñanata, ni yahuri Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Sa ye seis decori bato Jesu Pedrore, Santiagore tiquiro bahʉro Ñu gʉ̃hʉre ʉhmʉanʉ cʉnʉpʉ tiquina dihitare piji mʉjari. ");
INSERT INTO pirNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ʉhmʉanopʉ tiquina esari bato tiquina ihñonopʉ tiquiro pagʉre camesahye. Tiquiro wʉhdoa asʉ̃ deco cjʉ̃no yero saha asi siteahye. Sa yero tiquiro suhtiro buhrioro yero saha yehsero wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Sa ye Jesu Moise mʉnano, Elia mʉnano mehna tiquina yahuducugʉ̃ ihñahye tiquina ihtiaro buheyequina. ");
INSERT INTO pirNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Sa yero Pedro Jesure nimahye: —‍Pʉhto, mari ohõpʉ ijigʉ̃ quehnoa duare. Mʉhʉ cahmegʉ̃ ihtia wʉhʉgã yeitja. Mʉhʉ ya wʉhʉgã, Moise ya wʉhʉgã, Elia ya wʉhʉgã yeitja, nimahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Tiquiro sa ni yahuducuri watoa ehmeo quehnoano asiye ehmeo tiquinare cahmotahye. Sa wahagʉ̃ ehmeo watoapʉ yahuducuye bisiro ca tahye. —‍Ahriquiro yʉhʉ macʉ yʉhʉ cahĩniquiro ijire. Tiquiro mehna bucueaja. Tiquirore tʉhoya, ni yahuducuro ca tahye. ");
INSERT INTO pirNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Sa nigʉ̃ tʉhoye tiquiro buheyequina tʉho maria waha, yehpapʉ doque quehe sahye. ");
INSERT INTO pirNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Tiquina sa wahari bato Jesu tiquina cahapʉ esa, tiquinare bʉacarero, ohõ saha niahye: —‍Wahcãdʉcaya mʉsa. Yojopʉre mʉsa ihñarire, mʉsa tʉhori gʉ̃hʉre cueracãhña, niahye tiquiro tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Tiquiro sa nigʉ̃ tiquina ihña wahcõ, Jesu dihitare ihñahye. Tiquina ihñariquina pehe mariedahye. ");
INSERT INTO pirNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Sa ye cʉnʉpʉ tiquina dijia tagʉ̃ Jesu tiquinare tutuaro mehna niahye: —‍Mianogãta yʉhʉ sa waharire apequinare yahueracãhña. Yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ yʉhʉ yaria masa wijiari batopʉ tire apequinare yahuya mʉsa, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Tiquiro sa nidi bato Pedro gʉ̃hʉ tiquirore sinituahye: —‍“Cristo masare yʉhdʉoatiquiro tiquiro ahtato pano Eliare ahta mʉhtano cahmene”, nine marine judio masa buheyequina. ¿Dʉhse ijiro boro sa niajari tiquina? ni sinituahye tiquina tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesu yʉhtiahye: —‍Potota ijire. Eliare ahta mʉhta dutiri Cohãcjʉ̃, ijipihtiyere quehno mʉhtatiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ohõ saha nigʉ mʉsare nigʉ niaja. Elia wihi tuhasari. Tiquiro sa wihiepegʉ̃ta tiquina tiquirore ne ihña masiedari. Sa ye tiquina dʉhse ye duaro yeri jiri tiquirore. Sata yeeta yʉhʉ gʉ̃hʉre. Yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ ijiaja. Tiquina sa yegʉ̃ ñano yʉhdʉgʉtja yʉhʉ, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Tiquiro sa ni yahugʉ̃ tiquina quehnoano tʉhoahye. “Elia”, nino, Ñu wame yeriquirore nino niahye. Tire masiahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Sa ye peyequina masa cahapʉ tiquina dijia tagʉ̃ ihñano ihcãquiro ʉmʉno Jesu cahapʉ esa, dʉsepe curi mehna quehe sari. ");
INSERT INTO pirNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—‍Pʉhto, yʉhʉ macʉre paja ihñaña. Tiquiro ñama yariayere dohatiriquiro ijire. Sa yero ña yʉhdʉaro yʉhdʉre. Peye tahari pecapʉ bora sa quehea mʉjare tiquiro. Ihquẽ tahari diapʉ bora ñojoa mʉjare. ");
INSERT INTO pirNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Sa yegʉ mʉhʉ buheyequina cahapʉ tiquirore ne sami. Tiquina tiquirore yʉhdʉo masiedari, nidi tiquiro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesu yʉhtiri: —‍Yojopʉ cjãna, ñana ijire mʉsa. Yʉhʉre ne wacũ tutuerare. Yoa yʉhdʉari pje mʉsare buhemi yʉhʉ. ¿Noho puno yoari pje yʉhʉre mʉsa cariboajari? Tiquirore ne cãhtaya yʉhʉre, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Sa yero watĩnore tiquiro tuhtigʉ̃ta watĩno pehe masʉno mehna ijiriquiro wahaa wahari. Sa wahari batogãta quehnoa wahari tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Came ʉsã tiquiro buhena ʉsã sehsaro ijina Jesure sinituu: —‍¿Dʉhsena ʉsã pehe ahriquiro pehere watĩnore cohã masiedari, mʉhʉ tʉhotugʉ̃? ni sinituu ʉsã. ");
INSERT INTO pirNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesu yʉhtiri: —‍Yʉhʉre mehenogã wacũ tutuare mʉsa. Poto mʉsare yahugʉta niaja. Mostaza capegã meheni pjegã ijire. Ti yero saha Cohãcjʉ̃re mehenogã mʉsa wacũ tutuana ohõ saha wahagʉ̃ ye masinata mʉsa. Ahdʉ cʉnʉre “Sohõpʉ wahaya”, mʉsa nigʉ̃, waharota. Cohãcjʉ̃re sata wacũ tutuana, ijipihtiyere ye masine mʉsa.  ");
INSERT INTO pirNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Sa ijiepegʉ̃ta ahriquiro boro watĩnore mʉsa cohã duana Cohãcjʉ̃re tutuaro sinino cahmene mʉsare. Sa ye duana sijiro cahmene mʉsare Cohãcjʉ̃re sinina tana, nidi Jesu ʉsãre. ");
INSERT INTO pirNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Sa ye Galilea yehpapʉ ʉsã tinigʉ̃, Jesu ʉsãre yahuri: —‍Yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ ijiaja. Masa yʉhʉre ñehe, apequinapʉre yʉhʉre ohoeta. ");
INSERT INTO pirNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Sa tiquina ohori bato yʉhʉre wejẽeta. Sa tiquina wejẽgʉ̃ ihtia deco wahaboro masa wijiagʉta, ni yahuri tiquiro ʉsãre. Tiquiro sa ni yahugʉ̃ tutuaro bʉjʉa witii ʉsã. ");
INSERT INTO pirNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Sa yena Capernaupʉ sajã sagʉ̃, Cohãcjʉ̃ wʉhʉ cjẽ ijiatire wapa ne cohteyequina Pedro cahapʉ esa, tiquirore sinituahye. —‍¿Mʉsare buheriquiro Cohãcjʉ̃ wʉhʉ cjẽ wapa ijiatire wapa yeajari tiquiro? ni sinituahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","—‍Wapa yere tiquiro, ni yʉhtiahye Pedro. Tiquiro sa nidi bato wʉhʉpʉ tiquiro sajãgʉ̃ Jesu sinitu mʉhtahye Pedrore: —‍¿Simo dʉhse ni tʉhotuajari mʉhʉ? ¿Ahri yehpa cjẽna pʉhtoa yabequina pehere wapa neajari, mʉhʉ tʉhotugʉ̃? ¿Tiquina mehna cjẽnare wapa neajari? ¿O ape yehpa cjẽna pehere wapa neajari, mʉhʉ tʉhotugʉ̃? ni sinituahye tiquiro Pedrore. ");
INSERT INTO pirNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","—‍Ape yehpa cjẽna pehere wapa nene, ni yʉhtiahye Pedro. Tiquiro sa nigʉ̃ Jesu yahuahye: —‍Sa yero pʉhtoro tiquiro ya yehpa cjẽnare wapa nedari. ");
INSERT INTO pirNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Sa ijiepegʉ̃ta wapa ne cohteyequinare usuagʉ̃ ye dueraja mari. Sa yena wapa yenata. Ditarapʉ wahaya. Topʉ esa, yohyeri dare doque ñoña. Sa yegʉ wahi mʉhʉre ihyariquirore weje nʉoña. Tiquiro dʉseropʉ niñeru cjoere bocagʉta mʉhʉ. Ti cjoe queoro wapa tiri cjoe ijirota. Yʉhʉre, mʉhʉ gʉ̃hʉre Cohãcjʉ̃ wʉhʉ cjẽna tiquina wapa negʉ̃ quehnoano queoro esa tuharota ti cjoe. Ti cjoere bocagʉ mari wapamonore wapa yegʉ wahaya, niahye Jesu Pedrore. ");
INSERT INTO pirNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ti pjere ʉsã tiquiro buhena Jesu cahapʉ esa, sinituu tiquirore: —‍¿Ʉhmʉse cjʉ̃no pʉhtoro ijiropʉre ʉsã mehna cjʉ̃no noa wahaboagari pʉhtoro? ni sinituu ʉsã. ");
INSERT INTO pirNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ʉsã sa nigʉ̃ Jesu nijinogãre pijio, tiquirogãre ʉsã caha duhu docori. Duhu doco tuhasa, ʉsãre nidi: ");
INSERT INTO pirNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","—‍Poto mʉsare yahugʉtja. Ahriquina macanagã Cohãcjʉ̃re tiquina pʉhtoro waro tʉhoture. Sa yena mʉsa gʉ̃hʉ tiquina yero saha tʉhotuna, quehnoañene camesana, ʉhmʉse cjʉ̃no pʉhtoro ijiropʉre wahanata. Tiquina yero saha tʉhotuerana pʉhtoro tiquiro ijiropʉ wahasi mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Sa yero ʉhmʉse cjʉ̃no pʉhtoro ijiropʉre sa tʉhotu cãriquiro ahriquiro nijinogã yero saha tʉhoturiquirota apequina bui pʉhtoro wahare. ");
INSERT INTO pirNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Sa yena yeere yena tana ohõ saha ijiyequinagãre cahmena, yʉhʉ gʉ̃hʉre cahmene mʉsa, ni yahuri Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Sa yero tiquinare yahu nemori: —‍Ahriquirogã yero saha ijiriquiro yʉhʉre wacũ tutuariquirogãre yahutja mʉsare. Apequiro ahriquirogã yero saha ijiriquirore ñañene ye dutiro tiquiro ña yʉhdʉaro yʉhdʉrota. Tiquiro wamʉare pajiria ʉtãre dʉhte yo, pajiri mapʉ tiquirore cohãgʉ̃ ñano wahaboaga tiquiro. Sa ijiepegʉ̃ta ahriquirogã yero saha ijiriquirore ñañene ye dutiriquiro tiquiro pehe pajiri mapʉ tiquina cohãriquiro yʉhdʉoro ñano yʉhdʉrota. ");
INSERT INTO pirNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Masare ñañene yegʉ̃ yeye ijire. Tire yeye ahri yehpa cjẽna ñano yʉhdʉre. Ñañene yeducure masa. Tiquina sa yegʉ̃ tiquinare ñañene yegʉ̃ yeyequina pehe ña yʉhdʉaro yʉhdʉeta. ");
INSERT INTO pirNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Mʉhʉ omoca mehna ñano yegʉ ti omocare mʉhʉ dʉte cohãboro saha ti ñañene duhuya. Tire duhueragʉ pecapʉ wahagʉta. Topʉre ne peca yatierare. Mʉhʉ omocare mʉhʉ cohãgʉ̃ ti si dihita butiboaga. Sa yegʉ mʉhʉ pehe sa bajuri turu ijiepegʉta came Cohãcjʉ̃ mehna ijigʉta. Pʉa omoca mehna pecapʉ wahagʉ mʉhʉ sa wahagʉ̃ ña yʉhdʉaboaga. Sa yegʉ ti ñañene duhuya. Mʉhʉ dahpocã mehna ñano yegʉ ti dahpocã gʉ̃hʉre mʉhʉ dʉte cohãboro saha ti ñañene duhuya. Tire duhueragʉ pecapʉ wahagʉta. Topʉre ne peca yatierare. Mʉhʉ dahpocãre mʉhʉ cohãgʉ̃ ti si dihita butiboaga. Sa yegʉ sa bajuri turu ijiepegʉta came Cohãcjʉ̃ mehna ijigʉta. Pʉa dahpocã mehna pecapʉ wahagʉ mʉhʉ sa wahagʉ̃ ña yʉhdʉaboaga. Sa yegʉ ti ñañene duhuya. ");
INSERT INTO pirNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Mʉhʉ capea mehna ñano yegʉ tiare ore we mʉhʉ cohãboro saha ti ñañene duhuya. Tire duhueragʉ pecapʉ wahagʉta. Topʉre ne peca yatierare. Tiare mʉhʉ cohãgʉ tia dihita butiboaga. Ihcã pehe capea mariedapegʉta came Cohãcjʉ̃ mehna ijigʉta. Pʉa capea mehna pecapʉ wahagʉ mʉhʉ sa wahagʉ̃ ña yʉhdʉaboaga. Sa yegʉ ti ñañene duhuya, ni yahuri Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Sa ni tuhasa ohõ saha ni yahu nemori: —‍Ne, ahriquinagãre macanagãre ihña tuhtieracãhña. Mʉsare niita niaja yʉhʉ. Tiquinagã yeequina angele tiquinagãre cohteyequina ʉhmʉsepʉ ijiyequina pehe yʉhʉ Pacʉ cahapʉ sa ijiducure.  ");
INSERT INTO pirNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ ahri yehpapʉ pecapʉ wahaboriquinare yʉhdʉogʉ tʉʉ nii yʉhʉ, ni yahuri Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Sa ni tuhasa tiquiro tʉhotuye mehna ohõ saha ni queoye mehna buheri ʉsãre. —‍Ovejare cohteriquiro cien ovejare cʉoriquiro ihcãquiro oveja butia wahagʉ̃ ohõ saha yerota tiquinare cohteriquiro pehe. Apequina ovejare noventa y nueve ovejare tiquina ihyaropʉ duhu doco, butiriquirore macano waharota. ");
INSERT INTO pirNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ijirota nii niaja mʉsare. Tiquirore bocaro bucuerota tiquiro. Apequina noventa y nueve dʉhsayequina mehna bucueri tiquiro. Tiquinare tiquiro bucueriro yʉhdʉoro butiriquiro pehere bocaro tutuaro bucuerota. ");
INSERT INTO pirNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Sata mari Pacʉ ʉhmʉse cjʉ̃no ahriquina ihyo ijiyequina gʉ̃hʉre pecapʉ tiquina wahagʉ̃ cahmedare, ni yahuri Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Sa ni tuhasa ohõ saha ni yahu nemori: —‍Mʉhʉ acayʉro mʉhʉre ñano tiquiro yegʉ̃ tiquiro mehna yahugʉ wahaya. Mʉsa sehsaro tire yahuya. Mʉhʉ sa yegʉ̃ tiquiro mʉhʉre tʉhoboaga. Tiquiro tʉhogʉ̃ “Mʉhʉre ne pari turi ohõ saha yesi yʉhʉ”, tiquiro nigʉ̃ mʉhʉ acayʉrore pari turi piti tigʉ niaga mʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Mʉhʉre tiquiro tʉho dueragʉ̃ pũrita ihcãquiro mehna waha duagʉ o pʉaro mehna waha duagʉ tiquinare piti ti cã, pari turi tiquirore yahuna wahaya. Mʉsa sa yena pʉana o ihtiana tiquirore mʉsa yahusãgʉ̃, “Poto tjire”, ni masieta apequina. ");
INSERT INTO pirNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Sa yena mʉhʉ mehna cjẽna gʉ̃hʉre tiquiro tʉho dueragʉ̃ ijipihtiyequina Jesu yequina cahmecoañequinare yahusãna wahaya. Sa yena Jesu yequina cahmecoañequinare tiquiro tʉho dueragʉ̃ ihñana Cohãcjʉ̃re ño peo dueriquiro tiquiro ijiro saha yeya tiquirore. Wapa ne cohteriquiro tiquiro ijiro saha yeya tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Ijirota mʉsare niita niaja. Ahri yehpapʉ mʉsa Jesu yequina ñañene mʉsa ye dutieragʉ̃ ʉhmʉsepʉ gʉ̃hʉre ye dutisi. Ahri yehpapʉ mʉsa quehnoañene ye dutigʉ̃ ʉhmʉsepʉ gʉ̃hʉre ye dutiye ijirota. ");
INSERT INTO pirNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Pari turi mʉsare yahutja ahrire: Mʉsa pʉana Cohãcjʉ̃re sinigʉ̃, mʉsa pʉana mʉsa sinidire ihcãno saha mʉsa tʉhotugʉ̃ yʉhʉ Pacʉ ʉhmʉse cjʉ̃no tire yerota. ");
INSERT INTO pirNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Pʉaro o ihtiaro yeequina, yeere yeatiquina tiquina cahmecoagʉ̃ yʉhʉ tiquina mehna ijiaja, ni yahuri Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Came Pedro Jesu cahapʉ esa, sinituri: —‍¿Pʉhto, yʉhʉ acayʉro mʉhʉ yaquiro peye tahari yʉhʉre ñano tiquiro yegʉ̃ ihñagʉ nohope tahari tire bogʉtari yʉhʉ? ¿Siete tahari bogʉtari yʉhʉ? ni sinituri Pedro. ");
INSERT INTO pirNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesu yʉhtiri: —‍Siete taharita mʉhʉre apequiro ñano yerire mʉhʉ bogʉ̃ to wahaerare. Peye tahari mʉhʉre ñano tiquiro yegʉ̃ gʉ̃hʉre boya. ");
INSERT INTO pirNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Ʉhmʉse cjʉ̃no masa pʉhtoro tiquiro ijiye ahri queoye yero saha ijire. Ijipihtiyequina masa pʉhtoro tiquiro cahacjẽnare tiquirore wapamoñequinare wapa ye peho duti duamahye. ");
INSERT INTO pirNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Tiquina wapamorire tiquiro queo dʉcagʉ̃, tiquirore dahra cohteyequina pehe pajiro wapamoriquirore tiquiro cahapʉ ne cãhtahye. Wapamoriquiro paji yʉhdʉaro wapamoahye tiquiro pʉhtorore. ");
INSERT INTO pirNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Sa yero tiquiro wapa ye masiedagʉ̃ tiquiro pʉhtoro tiquirore, tiquiro namonore, tiquiro pohnene cahacjẽna sõ, tiquinare apequinare dua dutimahye. Sa ye ijipihtiye tiquiro cʉoye gʉ̃hʉre dua dutimahye, tiquiro wapamonore wapa ye peho dutiro. ");
INSERT INTO pirNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Tiquiro sa dua dutigʉ̃ pajiro wapamoriquiro pehe dʉsepe curi mehna quehe sa, tiquiro pʉhtorore tutuaro siniahye: “Pʉhto, yʉhʉre paja ihñagʉ cohteniña. Mʉhʉre wapa ye pehoutja”, niahye tiquiro pʉhtorore. ");
INSERT INTO pirNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Tiquiro sa nigʉ̃ tʉhoro, tiquirore paja ihñano tiquiro wapamonore sata bo cãhye. ");
INSERT INTO pirNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Tiquiro sa yeri bato wapamoriquiro pehe waha, apequiro cahacjʉ̃nore tiquirore mehenogã wapamoriquirore boca sahye. Sa boca saro wamʉa ñeheahye tiquirore. “Yʉhʉre mʉhʉ wapamonore wapa ye pehoya”, niahye tiquiro mehna cjʉ̃nore tiquiro yero saha ijiriquirore cahacjʉ̃nore. ");
INSERT INTO pirNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Tiquiro sa nigʉ̃ apequiro cahacjʉ̃no pehe dʉsepe curi mehna quehe sa, tiquirore tutuaro sinimahye. “Yʉhʉre paja ihñagʉ mehenogã cohteniña. Mʉhʉre wapa ye pehoutja”, nimahye apequiro cahacjʉ̃no tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Tiquiro sa ni siniepegʉ̃ta yʉhtierahye. Sa yero tiquiro apequiro cahacjʉ̃nore peresu ye dutiahye. Tee tiquiro wapa ye pehogʉ̃pʉ wioro taro niahye tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Pajiro wapamoriquiro mehenogã wapamoriquirore tiquiro sa yegʉ̃ ihña, usua, apequina cahacjẽna pehe tiquina pʉhtorore yahusãñe wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Tiquina sa ni yahusãgʉ̃ tʉhoro tiquina pʉhtoro tiquina yahusãriquirore pijio, ohõ saha niahye: “Mʉhʉ ña yʉhdʉagʉ ijire. Mʉhʉ yʉhʉre tutuaro sinigʉ̃ mʉhʉ wapamonore bo pehomi yʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Mʉhʉre yʉhʉ sa yepegʉ̃ta mʉhʉ pehe mʉhʉre wapamoriquirore boerañohti. Mʉhʉ wapamono pehere yʉhʉ boriro sahata tiquiro mʉhʉre wapamono gʉ̃hʉre mʉhʉ bogʉ̃ quehnoa yʉhdʉaboaga. ¿Dʉhsegʉ tiquirore paja ihñedari mʉhʉ, sa yegʉ?” niahye pʉhtoro tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Sa nino tutuaro usua, peresu yeahye tiquiro cahacjʉ̃nore. Tee tiquiro wapa ye pehogʉ̃pʉ wioro taro niahye, ni yahuri Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Sa yero ohõ saha ni ahri quitire yahu bato tiri: —‍Sata yerota yʉhʉ Pacʉ ʉhmʉse cjʉ̃no mʉsare. Mʉsa ijipihtina mʉsa acaye mʉsare tiquina ñano yerire quehnoano mʉsa bo pehoeragʉ̃ tiquiro mʉsare buhiri dahrerota, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Tire tiquiro sa ni yahuri bato tiquiro Galileapʉ ijiriquiro Judea yehpapʉ ʉsãre siho wahari. Jordã wame tiri ma ape sie pahrẽpʉ esaʉ ʉsã. ");
INSERT INTO pirNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Topʉ ʉsã wahagʉ̃ peyequina masa ʉsãre nʉnʉ tã cãri. Tiquina mehna cjẽnare dohatiyequinare yʉhdʉgʉ̃ yeri tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Sa ye ihquẽquina fariseo masa Jesure yahusã duaye, ñano tiquiro yahuducugʉ̃ tʉho duaye, tiquirore sinituri: —‍¿Mari namosãnumiare cohãgʉ̃ quehnoaboagari? ¿Mari dutiye pehe sata ye dutiagari, mʉhʉ tʉhotugʉ̃? ni sinituri tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesu yʉhtiri: —‍¿Cohãcjʉ̃ yere tiquina ojoari pũpʉ ne ahrire buherari mʉsa? Ohõ saha ni ojoahye: “Coã waropʉre ahri yehpare bajumehnediquiro ʉmʉno, numino gʉ̃hʉre yeahye”, ni ojoahye. ");
INSERT INTO pirNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Sa yero ohõ saha ni ojoa nemoahye: “Sa yero ʉmʉno tiquiro pacʉsʉmʉare cohã wijia, tiquiro namono mehna ijirota. Sa ye tiquina pʉaro ijiepeta ihcã pagʉ yero saha ijire. ");
INSERT INTO pirNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Sa ye tiquina pʉaro yero saha ijierare. Ihcã pagʉ yero saha ijiye nine. Cohãcjʉ̃ tiquiro omoca dʉhte dutiyequina ijire. Sa ye tiquinare cahme duhueraro cahmene”, ni ojoahye, nidi Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Tiquiro sa nigʉ̃ fariseo masa sinituri tja: —‍Mʉhʉ ohõ saha ni yahuepegʉ̃ta ohõ saha ni ojoahye Moise pehe: “Mʉhʉ namonore cohã duagʉ papera pũre tire ojoaya. Sa ojoagʉ ti pũre mʉhʉ namonore mʉhʉ ohori bato ticorore cohã masine mʉhʉ”, ni ojoahye Moise. ¿Mʉhʉ nino saha ijiepegʉ̃ta Moise pehe dʉhsero ohõ saha ni ojoayari? ni yʉhtiri tiquina tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesu yʉhti cahmedi tiquinare: —‍Cohãcjʉ̃re mʉsa ñecʉsʉmʉa panopʉ cjẽna tiquina tʉho dueragʉ̃ ihñano tiquina namosãnumiare tiquina cohãgʉ̃, “Sata wahacũnahdo”, niahye Moise. Tiquiro sa niepegʉ̃ta coã waropʉre ahri yehpare sa ijierari. ");
INSERT INTO pirNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Mʉsare niita niaja. Masʉno tiquiro namono ticoro ñano yerapegʉ̃ta ticorore cohãno, apecorore namo tiro, tiquiro apecoro mehna ñano yero nine. Sa yero ahriquiro cohãricorore namo tiriquiro gʉ̃hʉ ticoro mehna ñano yeriquiro ijire, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Tiquina sa nigʉ̃ tʉhona, ʉsã tiquiro buhena pehe tiquirore ohõ saha nii: —‍Sata ʉmʉno tiquiro namono mehna tiquina cahme cohãedagʉ̃ mari pehere mari namo tieragʉ̃ quehnoaboaga, nii ʉsã. ");
INSERT INTO pirNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesu yʉhtiri: —‍Ihquẽquinareta namo ti dutierare Cohãcjʉ̃. Tiquiro namo ti dutiriquina dihita namo tieta. ");
INSERT INTO pirNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ʉmʉare namo ti dutieraye ihquẽgã ijire. Ihquẽquina ʉmʉa numiare cahmeeñequina masa bajuare. Apequina ʉmʉa masa tiquina apẽni tõho tiquina weriquina pehe namo ti masiedare. Apequina ʉmʉa ʉhmʉse cjʉ̃no tiquina pʉhtoro yere yedoho duaye, namo tierare. Sa ye ahriquina namo ti dueyequina sata tʉhotu cãhñequina, sata tiquina sohtori tigʉ̃ quehnoare, nidi Jesu ʉsãre. ");
INSERT INTO pirNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Sa ye masa macanagãre Jesu cahapʉ ne wihiri. Sa ne wihiye, tiquina Jesure tiquiro omocare tiquinagã bui ña peo duti duamedi. Sa ye tiquinagãre Cohãcjʉ̃re sini basa duti duamedi Jesure. Tiquina sa yegʉ̃ ihñana ʉsã tiquiro buhena tiquinare tuhtimi. ");
INSERT INTO pirNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ʉsã sa tuhtigʉ̃ ihñano, ʉsãre Jesu ohõ saha nidi: —‍Macanagã yʉhʉ cahapʉ ahtaahro. “Waharĩsa”, niedacãhña tiquinagãre. Tiquinagã Cohãcjʉ̃re tiquina pʉhtoro tʉhoture. Sa ye tiquiro ʉhmʉse cjʉ̃no pʉhtoro ijiropʉ ahriquinagã yero saha tʉhotuyequina ijire topʉre, nidi Jesu ʉsãre. ");
INSERT INTO pirNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Sa ninota tiquiro omocare tiquinagã bui ña peo tuhasa, wahaa wahari. ");
INSERT INTO pirNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Tiquiro sa yeri bato ihcãquiro Jesu cahapʉ wihi, sinituri tiquirore: —‍¿Ne quehnoagʉ buhegʉ, ijipihtiye decori Cohãcjʉ̃ mehna iji duagʉ, quehnoañene ye duagʉ dʉhse yeboagari yʉhʉ? nidi tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","—‍¿Dʉhse ijiro boro yʉhʉre quehnoañene sinituajari mʉhʉ? Cohãcjʉ̃ dihita quehnoariquiro ijire. Ijipihtiye decori Cohãcjʉ̃ mehna iji duagʉ tiquiro dutiyere yeya, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","—‍¿Dise boro dutiye pehere nigʉ niajari? ni sinitu nemori tiquiro. Jesu yʉhtiri: —‍Masare wejẽdacãhña. Wʉana tieracãhña. Yaqueracãhña. Ni mehoedacãhña. ");
INSERT INTO pirNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Mʉhʉ pacʉsʉmʉare ño peoya. Mʉhʉ basi mʉhʉ cahĩno saha mʉhʉ cahapʉ ijiriquiro gʉ̃hʉre cahĩña. Ahri dutiyere yero cahmene, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","—‍Ahri dutiyere ne yʉhdʉdʉcaera tii yʉhʉ. ¿Dʉhse ye nemoagari yʉhʉ ijipihtiye decori Cohãcjʉ̃ mehna iji duagʉ? nidi tiquiro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Tiquiro sa nigʉ̃ tʉhoro Jesu yahu nemori: —‍Mʉhʉ ñañe mariegʉ iji duagʉ mʉhʉ ye ijipihtiyere duagʉ wahaya. Sa duagʉ ijipihtiye mʉhʉ wapatari niñerure pejecʉoyequinare ohoya. Mʉhʉ sa yegʉ̃ pajiro mʉhʉ ye ʉhmʉsepʉ, Cohãcjʉ̃ cahapʉ ijirota. Mʉhʉ sa yeri bato yʉhʉ mehna cjʉ̃ ijigʉ ahtaya, ni yahuri Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Tiquiro sa nigʉ̃ tʉhoro tutuaro bʉjʉa witiri. Tiquiro doeri cjẽ upʉro ijipihtiye cʉoriquiro ijiri. Sa yero Jesu yahugʉ̃ tʉhoro tutuaro bʉjʉa witiri. Pejecʉoyequinare oho dueraro wahaa wahari. ");
INSERT INTO pirNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Tiquiro sa wahari bato Jesu ʉsãre tiquiro buhenare yahu nemori: —‍Ijirota mʉsare niita niaja. Doeri cjẽ upʉro Cohãcjʉ̃ pʉhtoro ijiropʉre tiquirore waharo basioera cjũre. ");
INSERT INTO pirNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mʉsare yahu nemoutja: Camello pehe awia copepʉ tiquiro sajã duagʉ̃ basioerare tiquirore. Tiquiro sa ijiro yʉhdʉoro doeri cjẽ upʉro Cohãcjʉ̃re cahmedaro, Cohãcjʉ̃ pʉhtoro ijiropʉre waharo basioerare, nidi tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Tiquiro sa nigʉ̃ tʉhona ʉsã tʉho maria waha, ʉsã basi ohõ saha nii: —‍Aa, dʉhse tiquiro nino sahata ijigʉ̃, ne ihcãquiro masʉno Cohãcjʉ̃ cahapʉ waha masiedaboaga, nii ʉsã basi. ");
INSERT INTO pirNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ʉsã sa nigʉ̃ Jesu ʉsãre ihñano, yahuri: —‍Masa tiquina esa tuharo tiquina quehnoano yeri mehna Cohãcjʉ̃ cahapʉ waha masiedare. Cohãcjʉ̃ pehe masare pecapʉ wahaboriquinare yʉhdʉo masine. Tiquiro ijipihtiyere quehnoano ye masi peho cãre, nidi tiquiro ʉsãre. ");
INSERT INTO pirNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Tiquiro sa nigʉ̃ Pedro tiquirore nidi: —‍Tʉhorĩña. Ʉsã pehe ʉsã ye ijipihtiyere cũ cãʉ mʉhʉ mehna wahana tana. ¿Ʉsã ohõ saha yena, dʉhse ijiyere wapatanatari ʉsã? nidi tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Tiquiro sa nigʉ̃ tʉhoro ohõ saha nidi Jesu: —‍Mʉsare niita niaja: Pihtiri deco bato ijipihtiye wahma dihita camesaeta. Ti pjepʉre yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ yʉhʉ pʉhtoro yʉhʉ dujiropʉ asi siteropʉ dujiitja yʉhʉ. Topʉ yʉhʉ dujigʉ̃ mʉsa gʉ̃hʉ doce dujiye pahtaripʉ pʉhtoa tiquina dujiye pahtaripʉ dujinata. Sa yena Israe masare doce cururi cjẽnare besenata mʉsa quehnoañequina gʉ̃hʉre, ñañequina gʉ̃hʉre. ");
INSERT INTO pirNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Sa ye yeere yena tana mʉsa wʉhʉsere, mʉsa bahanare, mʉsa pacʉsʉmʉare, mʉsa pohnare, mʉsa weserire cũrina ijina, pajiro wapatanata. Sa yena ijipihtiye decori Cohãcjʉ̃ mehna ijinata. ");
INSERT INTO pirNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Sa ijiepegʉ̃ta yojopʉre peyequina pʉhtoa ijiriquina ti pjepʉre ihyo ijiyequina tojoaeta. Sa ye yojopʉre peyequina ihyo ijiyequina ijimediquina ti pjepʉre pʉhtoa camesaeta, ni yahuri Jesu ʉsãre tiquiro buhenare. ");
INSERT INTO pirNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Sa ye Jesu pari turi queoye mehna yahu nemori tja: —‍Ʉhmʉse cjʉ̃no masa pʉhtoro ijire. Wese upʉro queoye mehna tiquiro pʉhtoro ijiyere yahutja mʉsare. Tiquiro wese upʉro bohrea quehagʉ̃ tiquiro ya wesere dahratiquinare pijiro wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","“Ihcã cjoe niñeru cjoe wapa yegʉtja ihcã decore”, niahye tiquinare. “Aʉ”, niahye dahratiquina. Tiquina sa nigʉ̃ wesepʉ dahra dutiro ohoahye tiquiro tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Sa yero decopʉ nueve ijigʉ̃ doeri cjẽ duaropʉ wahahye tiquiro. Topʉ esaro, apequina dahraeyequinare ihñahye. ");
INSERT INTO pirNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Sa ihñano tiquinare niahye: “Mʉsa gʉ̃hʉ ya wesere dahrana wahaya. Quehnoano wapa yegʉtja”, niahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Sa ye tiquina wesepʉ dahraye wahahye. Sa ye wese upʉro coheri pje ijigʉ̃, ñamicahapʉ tres ijigʉ̃ gʉ̃hʉre dahra dutiahye. ");
INSERT INTO pirNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Sa ye ñamicahapʉ cinco ijigʉ̃ doeri cjẽ duaropʉ tiquiro wahahye tja. Topʉ esa, apequina dahraeyequinare ihñano, tiquinare niahye: “¿Mʉsa dʉhse yena niajari dahraerapenata ohõpʉre?” ni sinituahye tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Ne, ʉsãre dahraye mariedare”, ni yʉhtiahye tiquina. “Mʉsa gʉ̃hʉ ya wesere dahrana wahaya”, niahye tiquinare. Sa ye tiquiro nidiro sahata tiquiro ya wesere dahraye wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","’Sa ye ñamicahapʉ dahra duhuri pje ijigʉ̃ wese upʉro tiquiro dahrayequinare cohteriquirore ohõ saha niahye: “Dahrayequinare pijiya. Tiquina wihigʉ̃ tiquinare wapa yeya. Camepʉ yʉhʉ dahra dutiriquinare wapa ye mʉhtaña. Tiquinare wapa ye tuhasa, apequina gʉ̃hʉre wapa ye tuhasa, yʉhʉ dahra duti mʉhtariquinare wapa ye bato tiya”, niahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Sa yero cinco ijigʉ̃ dahra dʉcayequinare ihcã cjoe niñeru cjoe wapa yeahye. ");
INSERT INTO pirNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Tiquiro sa wapa yegʉ̃ ihñañe, “Ʉsãre paji cjũnogã wapa yerota”, ni tʉhotumahye tiquiro duti mʉhtariquina pehe. Tiquina gʉ̃hʉre ihcãno saha wapa yeahye. ");
INSERT INTO pirNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Sa ye niñerure tiquiro wapa yegʉ̃ tiquina pʉhtoro mehna usuaye, tiquina basi cahme niahye: ");
INSERT INTO pirNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Ahriquina ʉsã batopʉ tiquiro dahra dutiriquina pehe ihcã horata dahrari. Ʉsã pehe ihcã deco quehnoano dahra nahñoa wahami. Ñano asʉ̃ asiri ʉsãre. Ʉsã sa yoari pje dahraepegʉ̃ta ʉsã batopʉ dahra dʉcariquina gʉ̃hʉre ihcãno saha wapa yeri tiquiro”, ni usuahye tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ihcãquiro tiquina mehna cjʉ̃no tiquiro sa nigʉ̃ tʉhoro, wese upʉro yʉhtiahye tiquirore: “Ne yʉhʉ acayʉ, ‘Ihcã cjoe niñeru cjoere wapa yegʉtja’, nimi mʉsare. Yʉhʉ sa nigʉ̃ yʉhtiri mʉsa. Sa yegʉ yʉhʉ nidiro sahata mʉsare wapa yei yʉhʉ. Queoro wapa yei mʉsare. Ne yaquerʉ mʉsare. ");
INSERT INTO pirNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Sa yegʉ yʉhʉ wapa yerire ne, mʉhʉ ya wʉhʉpʉ tojoarĩsa. Ahriquirore came yʉhʉ dahra dutiriquiro gʉ̃hʉre mʉsare yʉhʉ wapa yeriro punota wapa yegʉtja. ");
INSERT INTO pirNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Yee niñeru ijire ahri. Sa yegʉ yʉhʉ cahmeno sahata ahri mehna wapa yegʉtja. ¿Apequinare bui cjũnogã yʉhʉ quehnoano wapa yegʉ̃ ihña tuhtiajari mʉhʉ?” niahye tiquiro wese upʉro, ni yahuri ti queoyere Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Sa nino, yahu nemori tiquiro: —‍Ahri queoye nidiro saha came cjã curua iji mʉhtari curua ijirota ʉhmʉsepʉ. Sa ye iji mʉhtari curua pehe tiquina camepʉ cjã curua tojoarota ʉhmʉsepʉ, ni yahuri Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Sa ye Jerusalẽpʉ wahaducu, ʉsãre doce tiquiro buhenare pijio tuhasa, ape siepʉ ʉsãre ʉsã sehsaro neari Jesu. Ʉsã sehsaro ʉsã ijigʉ̃ ʉsãre yahuri: ");
INSERT INTO pirNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—‍Tʉhoya yʉhʉre. Yojopʉre Jerusalẽpʉ wahana niaja mari. Topʉ yʉhʉre masʉre Cohãcjʉ̃ ohorigʉre ñehe, apequinapʉre yʉhʉre ohoeta. Pahia pʉhtoare, judio masare buheyequina gʉ̃hʉre yʉhʉre ohoeta. Sa ye yʉhʉre wejẽ dutieta tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Sa wejẽ dutiye, judio masa ijieyequinare yʉhʉre ohoeta. Tiquina sa ohori bato tiquina pehe yʉhʉre bʉjʉpe, tana, curusapʉ quẽ bihaeta yʉhʉre. Sa yegʉ yʉhʉ yariari bato ihtia deco wahaboro masa wijiagʉtja, ni yahuri Jesu ʉsãre. ");
INSERT INTO pirNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Sa ye Zebedeo namono pʉaro ticoro pohne mehna Jesu cahapʉ esa, dʉsepe curi mehna quehe sahye tiquirore sinino taro. ");
INSERT INTO pirNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","—‍¿Dʉhse yʉhʉ yegʉ̃ cahmeajari mʉhʉ? niahye Jesu ticorore. —‍Mʉhʉ pʉhto sajãgʉ yʉhʉ pohnare dutiyequina sõña. Sa yegʉ mʉhʉ pʉa peheripʉ duji dutiya tiquinare, ni siniahye ticoro. ");
INSERT INTO pirNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesu ohõ saha niahye: —‍Mʉsa ñano yʉhdʉatire masiedapenata sa sinine mʉsa. ¿Yojopʉre yʉhʉ ñano yʉhdʉato saha mʉsa gʉ̃hʉ ñano yʉhdʉna ihcãno sahaboagari mʉsa? niahye Jesu ticoro pohnene. —‍Ihcãno sahanata, ni yʉhtiahye Santiago, Ñu mehna. ");
INSERT INTO pirNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","—‍Ijirota niita niaja mʉsare. Yʉhʉ ñano yʉhdʉato saha ñano yʉhdʉnata mʉsa gʉ̃hʉ. Sa ijiepegʉ̃ta yʉhʉ mehna dutiatiquinare, yʉhʉ mehna dujiatiquinare bese masiedaja yʉhʉ. Yʉhʉ Pacʉ pehe quehno tuhasari tire. Sa ye tiquiro beseatiquina dihita yʉhʉ poto pehe yʉhʉ cũ pehe pehe dujieta, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Sa yena ʉsã apequina diez tiquiro buhena pehe Santiago, Ñu ahriquina pʉaro mehna usuaʉ ʉsã. Jesure tiquina pacoro ticoro sini basarire tʉhona usuaʉ tiquina mehna. ");
INSERT INTO pirNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ʉsã sa usuagʉ̃ ihñano, Jesu ʉsãre ijipihtina tiquiro buhenare piji cahmecoa, yahuri ʉsãre: —‍Cohãcjʉ̃re masieñequina pʉhtoa pehe tiquina masare dutiye, usuaro mehna dutire. ");
INSERT INTO pirNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Mʉsa pehe ne sa yesi mʉsa basi. Mʉsa mehna cjʉ̃no pʉhtoro iji duaro, ijipihtiyequina tiquiro mehna cjẽna cahacjʉ̃no ijiro cahmene tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Sa yero ijipihtiyequinare dutiriquiro iji duaro, apequina cahacjʉ̃no ijiro cahmene tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Sata ijigʉ ijiaja yʉhʉ gʉ̃hʉ. Yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ ahri yehpapʉre masare yedohogʉ ahtaʉ. Sa yegʉ peyequina masa ye buhirire yariagʉ ahtaʉ nii. Sa yegʉ masare pecapʉ wahaboriquinare yʉhdʉogʉ ahtaʉ nii. Masare dutipegʉ tagʉ niedʉ, nidi Jesu ʉsãre. ");
INSERT INTO pirNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Sa ye Jericópʉ ijirina ʉsã wahagʉ̃ peyequina masa Jesure nʉnʉ tãri. ");
INSERT INTO pirNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Sa ye Jesu tiquiro yʉhdʉagʉ̃ pʉaro caperi bajueyequina maha dʉhtʉ cahapʉ dujiyequina tʉhori. Sa tʉhoye, ohõ saha ni sañuducuri: —‍Pʉhto, Davi mʉnano panami iji turiagʉ, masare yʉhdʉoacjʉ, ʉsãre paja ihñaña, ni sañuducuri. ");
INSERT INTO pirNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Tiquina sa ni sañuducugʉ̃ masa pehe tiquinare tuhtiri. —‍Dihta mariahña, nidi masa tiquinare. Tiquina sa tuhtigʉ̃ tʉhoye, to pano tiquina sañuducuriro yʉhdʉoro sañuducu nemori tja. —‍Ʉsã pʉhto, Davi mʉnano panami iji turiagʉ, ʉsãre paja ihñaña, ni sañuducu nemori. ");
INSERT INTO pirNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Tiquina sa nigʉ̃ tʉhoro Jesu esadʉca, tiquinare pijio, sinituri: —‍¿Dʉhse yʉhʉ yegʉ̃ cahmeajari mʉsa? ni sinituri. ");
INSERT INTO pirNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","—‍Pʉhto, ʉsãre ihñagʉ̃ yeya, ni yʉhtiri tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Tiquina sa nigʉ̃ Jesu tiquinare paja ihñari. Sa paja ihñano tiquina caperire ña peori. Tiquiro sa ña peogʉ̃ta tiquina pehe ihñaa wahari. Sa ihñañe, tiquirore nʉnʉ tã cãa wahari. ");
INSERT INTO pirNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Sa ye Jerusalẽpʉ esana tana Betfagé wame tiri macapʉ esa mʉhtaʉ ʉsã Jesu mehna. Cʉnʉ Olivo wame tidʉ cahapʉ Betfagé ijiri. Topʉ esaro, ʉsã tiquiro buhena mehna cjẽnare pʉaro Jesu tiquiro pano oho mʉhtari. ");
INSERT INTO pirNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ohõ saha dutiri tiquinare: —‍Si macapʉ burroare nena wahaya. Topʉ esana, duita burrore ticoro macʉnogã mehna tiquina dʉhte docoricorore bocanata. Tiquinare boca, yuta dare pã, ne cãhta basaya yʉhʉre. ");
INSERT INTO pirNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Mʉsa sa yegʉ̃ ihñano, burroa upʉro “¿Dʉhsena tana burroare pãjari mʉsa?” tiquiro nigʉ̃ tʉhona ohõ saha ni yʉhtiya. “Mari pʉhtoro burroare cahmedi. Sa yero mianogã wiarota tiquiro”, ni yʉhtiya tiquirore, ni duti ohori Jesu pʉaro tiquiro buheyequinare. ");
INSERT INTO pirNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Sa yeri Cohãcjʉ̃ yere yahu mʉhtariquiro tiquiro ni ojoariro sahata. Ohõ sahata ni ojoahye panopʉ: ");
INSERT INTO pirNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Jerusalẽ cjẽnare ohõ saha ni yahuya: “Ihñaña mʉsa. Mʉsa pʉhtoro mʉsa cahapʉ ahtare. Tiquiro quehnoano masa quehnoariquiro ijire. Burro macʉnogã bui pesariquiro ahtarota”, ni yahuya Jerusalẽ cjẽnare, ni ojoahye panopʉ. ");
INSERT INTO pirNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jesu tiquiro dutiriquina pʉaro ti macapʉ esa, tiquiro dutiriro sahata yeahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Burrore, ticoro macʉnogã gʉ̃hʉre ne cãhta, tiquina bui sañañe suhtire tu we ne, burrogã bui duhu peori tiquina. Tiquina sa yeri bato Jesu tiquirogã bui mʉja pjeri, waharo taro. ");
INSERT INTO pirNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Mʉja pje tuhasa, tiquirogã bui Jerusalẽpʉ wahari. Tiquiro ahtagʉ̃ ihñañe masa peyequina tiquina bui cjẽ suhtire tu we ne, seõ cũ mʉhtari tiquiro wahari mahare, Jesure ño peoye. Apequina pehe pũri tiye dʉpʉrire mahapʉ cũ mʉhtari tiquirore ño peoye. ");
INSERT INTO pirNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Sa ye tiquiro pano wahayequina, tiquiro bato nʉnʉ tãñequina mehna sañuducuri: —‍Davi panamino iji turiariquirore marine yʉhdʉoatiquirore ño peouhna. Ahriquiro Cohãcjʉ̃ ohoriquiro quehnoano ijiahro. Ʉhmʉse cjʉ̃nore “Tutuagʉ ijire”, ni ño peouhna, ni sañuducuri masa. ");
INSERT INTO pirNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Sa ye Jerusalẽpʉ tiquina esagʉ̃ to cjẽna pehe ihña maria wahari. —‍¿Noa ijiajari ahriquiro? ni cahme sinituri tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Apequina masa yʉhtiri: —‍Ahriquiro Cohãcjʉ̃ yere yahu mʉhtariquiro Nazare cjʉ̃no Jesu wame tiriquiro ijire, ni yahuri tiquina masare. ");
INSERT INTO pirNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Came Cohãcjʉ̃ wʉhʉpʉ esari Jesu. Ti wʉhʉpʉ esa, sajãa wahari. Ti wʉhʉpʉ duayequinare, dúyequina gʉ̃hʉre cohã wiori tiquiro. Sa yero niñeru camesaye mesarire ne majare cũ mʉjari. Bujuaare duayequina tiquina dujiye pahtari gʉ̃hʉre sata yeri. ");
INSERT INTO pirNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Sa yero tiquinare ohõ saha nidi: —‍Cohãcjʉ̃ yere tiquina ojoari pũpʉ ohõ saha nine: “Ya wʉhʉ Cohãcjʉ̃ mehna yahuducuri wʉhʉ wame tirota”, nimene tiquiro ojoari pũpʉ. Mʉsa pehe ahri wʉhʉpʉ duana mʉsa basi cahme yaquere mʉsa, nidi tiquiro tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Tiquiro sa yeri bato caperi bajueyequina, tini masieñequina gʉ̃hʉ Cohãcjʉ̃ wʉhʉpʉ tiquiro cahapʉ wihiri. Tiquina sa wihigʉ̃ tiquinare yʉhdʉgʉ̃ yeri tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Sa quehnoañene tiquiro yegʉ̃ ihñañe, pahia pʉhtoa, marine judio masare buheyequina gʉ̃hʉ usuari tiquiro mehna. Sa ye macanagã Jesure “Davi panami iji turiagʉ, masare yʉhdʉoacjʉ, tutuagʉ ijire mʉhʉ”, tiquina ni ño peogʉ̃ tʉhoye usuari pari turi tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Sa usuaye ohõ saha nidi Jesure: —‍¿Tiquina sa nigʉ̃ tʉhoerajari mʉhʉ? Sa niedacãhdo, ni tuhtiri tiquina Jesure. —‍Tiquina sa nigʉ̃ tʉhoaja. ¿Cohãcjʉ̃ ojoari pũpʉ ahrire ne buherari mʉsa? Macanagãre Cohãcjʉ̃re quehnoano ño peogʉ̃ yeri mʉhʉ, nine Cohãcjʉ̃ yere tiquina ojoari pũpʉ, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Sa ni tuhasa tiquinare cohã cã, Betania wame tiri macapʉ esa, ti ñamine topʉ ijiri. ");
INSERT INTO pirNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ape deco bohrearopʉ Jerusalẽpʉ tojoaro, ʉjʉa ahbari Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Sa ʉjʉa ahbaro, maha dʉhtʉ cahapʉ ijidʉ higueragʉ wame tidʉre ihñano, tʉ dʉcare macano wahamedi. Dʉca mariedari tʉ pehe. Pũri dihita ijiri. Tʉ sa ijigʉ̃ ihñano Jesu tʉre ohõ saha nidi: —‍Ahdʉ ne pari turi dʉca tisi, nidi tiquiro. Tiquiro sa nigʉ̃ta duita tʉ pehe ñaia wahari. ");
INSERT INTO pirNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tʉ sa wahagʉ̃ ihñana ʉsã tiquiro buhena ihña maria wahaʉ. —‍¿Yohou, dʉhsero ahdʉ duita ñaia wahajari? ni sinituu ʉsã. ");
INSERT INTO pirNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesu yʉhtiri: —‍Ahrire wacũña mʉsa. Cohãcjʉ̃re quehnoano wacũ tutuaya. “Potota sa yerota tiquiro”, nina, ahdʉre yʉhʉ yeriro sahata ye masinata mʉsa gʉ̃hʉ. Sa yena ahdʉre yʉhʉ yaria dutiriro yʉhdʉoro ye masinata mʉsa. Ahdʉ cʉnʉre “Duha ne, pajiri mapʉ cohãdʉ ijiahro”, mʉsa nigʉ̃ duha cohãdʉ ijirota. ");
INSERT INTO pirNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Cohãcjʉ̃re mʉsa wacũ tutuagʉ̃, “Yʉhʉ sinidiro sahata waharota”, mʉsa ni wacũgʉ̃ mʉsa sinidiro sahata waharota, nidi Jesu ʉsãre. ");
INSERT INTO pirNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Sa ye Cohãcjʉ̃ wʉhʉpʉ tojoa sa, buheri tiquiro. Tiquiro sa buhegʉ̃ pahia pʉhtoa, mari judio masa bʉcʉna mehna tiquiro cahapʉ wihi, sinituri: —‍¿Dʉhsegʉ canʉ ñamicahare sa yeari mʉhʉ? ¿Noa mʉhʉre tire sa ye dutiari? ni sinituri tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Tiquina sa nigʉ̃ Jesu yʉhtiri: —‍Mʉsa pehere sinitu mʉhtagʉtja. Quehnoano yʉhʉre mʉsa queoro yʉhtigʉ̃ mʉsare yahutja yʉhʉ gʉ̃hʉ. ");
INSERT INTO pirNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Ñu masare tiquiro wame yegʉ̃ noa boro pehe tiquirore wame ye dutiyari, mʉsa tʉhotugʉ̃? ¿O Cohãcjʉ̃ dutierayari? ¿O masa pehe dutiyari, mʉsa tʉhotugʉ̃? ni sinituri Jesu tiquinare. Tiquiro sa nigʉ̃ tiquina pehe tiquina basi ohõ saha nidi: —‍¿Dʉhse ni yʉhtinatari mari? “Cohãcjʉ̃ Ñure dutie tiahye”, mari nigʉ̃, “¿Dʉhsena Ñu tiquiro dutiepegʉ̃ta tʉho duerari mʉsa?” niboaga Jesu marine. Sa yena “Cohãcjʉ̃ Ñure dutie tiahye”, ni yʉhti masiedaja mari. ");
INSERT INTO pirNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ahriquina masa pehe “Potota Ñu Cohãcjʉ̃ yere yahu mʉhtariquiro ijiri”, ni tʉhoturi tiquina. Sa ni tʉhotuye “Ñu tiquiro wame yegʉ̃ Cohãcjʉ̃ pehe tiquirore dutierahye”, mari nigʉ̃ tʉhoye masa usueta mari mehna. Sa yena ti gʉ̃hʉre yahu masiedaja mari, nidi tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Tiquina sa nidi bato Jesure yʉhtiri tiquina. —‍Ñure wame ye dutiriquirore ʉsã masiedaga, nidi tiquina. Tiquina sa nigʉ̃ tʉhoro ohõ saha nidi Jesu: —‍Ti pje pũrita yʉhʉ gʉ̃hʉ mʉsa sinitu mʉhtarire yahueraja mʉsare. Yʉhʉ yerire dutiriquirore yahueraja mʉsare, nidi tiquiro tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Tiquiro sa nidi bato Jesu queoye mehna buhe nemori tiquinare: —‍¿Ne, dʉhse tʉhotuajari mʉsa ahri queoyere? Pʉaro pacʉro ijiahye. Wahmino pehere ohõ saha niahye tiquiro pacʉro: “Macʉ, wesepʉ dahragʉ wahaya”, niahye. ");
INSERT INTO pirNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Wahaeraja”, ni yʉhtimahye tiquiro macʉno coã warore. Sa nieperota camepʉre wesepʉ waha duaro ijiahye tiquirore. Sa yero wahahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Sa yero tiquina pacʉro tiquiro macʉno dʉhsariquiro cahapʉ esa, tiquiro wahminore tiquiro dutiriro sahata wesepʉ waha dutimahye. “Aʉ”, nimahye dʉhsariquiro. Sa nieperota wahaerahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Diquiro pehe tiquiro pacʉro dutiriro sahata yeari? ni sinituri Jesu. —‍Tiquiro wahmino pehe yeahye, ni yʉhtiri tiquina. Tiquina sa nigʉ̃ Jesu yahuri: —‍Mʉsare niita niaja. Wapa ne cohteyequina, ʉmʉa mehna ñano yeducuye numia tiquina buipʉ waro mʉsa pehe ña yʉhdʉana ijire. Sa ye Cohãcjʉ̃ pʉhtoro ijiropʉre mʉsa esaborirore tiquina pehe mʉsare esa mʉhtaboaga. ");
INSERT INTO pirNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ñu wame yeriquiro buhero mʉsare “Quehnoano yeya”, ni yahumedi. Sa tiquiro yahugʉ̃ dʉhsariquiro pacʉrore tiquiro yʉhtierariro sahata tiquirore tʉhoerari mʉsa. Sa yena tiquirore yʉhtierari. Wapa ne cohteyequina pehe, ʉmʉa mehna ñano yeducuye numia gʉ̃hʉ tiquirore tʉhori. Tiquina sa tʉhogʉ̃ ihñari mʉsa. Mʉsa sa ihñaepenata tiquirore ne tʉho duerari. Sa yena tʉhoerari mʉsa, nidi Jesu pahia pʉhtoare, mari judio masa bʉcʉna gʉ̃hʉre. ");
INSERT INTO pirNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Sa ye Jesu pari turi queoye mehna ohõ saha ni tiquinare buhe nemori: —‍Apeye queoyere tʉhoya mʉsa. Dihta cʉoriquiro ijiahye. Tiquiro ya dihtapʉ ʉhse darire oteahye. Ote tuhasa, sahrĩnore ye tuhasa, ʉhsere tiquina cʉhta mʉtoati copere sehe, ʉhmʉari wʉhʉgã yeahye. ’Sa yero ti wesere apequinare ihcã pehe pahrẽ pahma cũahye. Sa yero ti wesere tiquinare ihña ihbo duti, ape yehpapʉ wahaa wahahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Sa ye ʉhse ñidi pje ijigʉ̃ wese upʉro tiquiro cahacjẽnare wesere ihña ihboyequina cahapʉ ohoahye. Wese cjẽ tiquiro oteri dʉcare tiquiro ya pahrẽ cjẽ dʉcare ne dutiro ohomahye. ");
INSERT INTO pirNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Sa ye wesere ihña ihboyequina pehe tiquiro cahacjẽnare ñano yeahye. Ihcãquirore tutuaro quẽ, apequirore wejẽ, apequirore ʉtã mehna doqueahye. ");
INSERT INTO pirNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Came wese upʉro pari turi tiquiro cahacjẽnare tiquiro oho mʉhtariquina yʉhdʉo cjũno ijiri curuare ohomahye tja. Sa ye wesere ihña ihboyequina tiquina gʉ̃hʉre mʉnanota yeahye tja. ");
INSERT INTO pirNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Sa yero tiquiro oho bato tiriquiro tiquiro macʉno ijiahye. “Yʉhʉ macʉ pehere ño peoeta”, nino tiquirore ohomahye. ");
INSERT INTO pirNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Tiquiro sa ni tʉhotuepegʉ̃ta wesere ihña ihboyequina tiquiro macʉno ahtagʉ̃ ihñañe, ohõ saha niahye: “Wese upʉro macʉno ijire ahriquiro. Tiquirore wejẽihna mari. Sa yero ahri wese mari ya wese tojoarota”, nimahye tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Sa niñeta tiquirore ñehe, wese dʉhtʉ cahapʉ ne cã, wejẽahye tiquina tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","’¿Ne, wese upʉro ahtaro dʉhse yerotari tiquiro wesere ihña ihboyequinare? ni sinituri Jesu pahia pʉhtoare, bʉcʉna gʉ̃hʉre. ");
INSERT INTO pirNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Tiquiro sa nigʉ̃ tiquina yʉhtiri: —‍Tiquiro apequinare wesere ihña ihboatiquinare camesarota iji mʉhtañequinare ña yʉhdʉayequinare wejẽno taro. Tiquirore queoro dʉcare tu watiquina pehere ihña ihbo dutirota, ni yʉhtiri tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Tiquina sa nigʉ̃ta Jesu yahu nemori tiquinare: —‍¿Cohãcjʉ̃ yere tiquina ojoari pũpʉ ahrire yʉhʉre tiquiro ni ojoarire ne buherari mʉsa? Ahriquiro Cristo ʉtã yero saha ijire. Ʉtãre wʉhʉ dahreyequina tiquina cohãno saha masa tiquirore cohãeta. Tiquina sa yepegʉ̃ta yojopʉre wʉhʉ dahreyequina wʉhʉre yeye tiquina cũ mʉhtaria ʉtãre tiquina cũno saha Cohãcjʉ̃ tiquirore pʉhtoro sõri. Cohãcjʉ̃ pehe ahrire yeri. Tiquiro sa yegʉ̃ ihñana, “Quehnoa yʉhdʉare”, ni, tʉhotuaja mari, ni ojoahye panopʉ. ’¿Tire ne buherari mʉsa? ");
INSERT INTO pirNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Mʉsare niita niaja yʉhʉ. Cohãcjʉ̃ tiquiro pʉhtoro ijiro mʉsa ijiato ijiboaga. Tiquiro pʉhtoro ijirore apequina pehere mʉsa ijiborirore ohorota Cohãcjʉ̃. Apequina masa pehe tiquiro dutiro sahata yeeta.  ");
INSERT INTO pirNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ijipihtiyequina tia ʉtã bui doque queheyequinare mʉta sitea wahaeta. Sa yero tia ʉtã pehe masʉno bui bora pjero mʉtaa wahagʉ̃ yerota tiquirore. Tiquiro pagʉ mʉnanore daye manarigã wahagʉ̃ yerota. (Sata yʉhʉre ño peo dueyequina yʉhʉ buhiri dahreatiquina ñano yʉhdʉeta,)  nidi Jesu pahia pʉhtoare, mari acaye judio masa bʉcʉna gʉ̃hʉre. ");
INSERT INTO pirNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ti queoyere tiquiro nigʉ̃ tʉhoye, “Sohõ tiquiro yahu mʉhtari queoye, wesere ihña ihboyequina queoye mehna marine nino niaga tiquiro”, ni tʉhoturi tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Sa ni tʉhotuye, tiquirore ñehe duamedi. Masa pehe Jesure ño peo, “Cohãcjʉ̃ yere yahu mʉhtariquiro ijire tiquiro”, niñequina ijie tiri tiquina. Tire masiñe, pahia pʉhtoa, bʉcʉna mehna masare cueye, Jesure ñehedari. ");
INSERT INTO pirNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Sa ye pari turi queoye mehna tiquinare buhe dʉcari Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—‍Ʉhmʉse cjʉ̃no pʉhtoro ijiro ahri queoye yero saha ijire. Ihcã yehpa cjẽna pʉhtoro ijiahye. Sa yero tiquiro macʉno ya deco bose deco yeahye. Tiquiro omoca dʉhteri bose deco ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Sa yero pʉhtoro tiquiro cahacjẽnare bose decore ihñañe ahtatiquinare piji dutiro ohomahye. Tiquina pehe ahta duerahye. ");
INSERT INTO pirNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Sa yero apequinare piji dutiro ohomahye tja tiquiro cahacjẽnare. “Yʉhʉ pijioriquinare ohõ saha ni yahuya. ‘Mari ihyatire dahre tuhasari. Wecʉare, wecʉagã dihi tiyequinagã gʉ̃hʉre wejẽ tuhasari. Sa yero ijipihtiro bose deco cjẽ ijiatire quehno tuhasari. Sa yena bose deco cjẽne ihyana ahtaya’, ni yahuya tiquinare”, ni ohomahye pʉhtoro tiquiro cahacjẽnare. ");
INSERT INTO pirNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Tiquina sa yahuri bato tiquiro pijionohriquina sa tʉhotu cãhye. Bose decore ihñañe wahaerahye. Ihcãquiro tiquiro ya wesepʉ wahaa wahahye. Apequiro tiquiro dahrayere ihñano wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Apequina pehe tiquiro cahacjẽnare ñehe, tiquinare ñano ye, wejẽ cãhye. ");
INSERT INTO pirNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Tiquina sa yegʉ̃ tʉhoro, pʉhtoro pehe usuahye. Usua, tiquina sa wejẽdi buhiri buhiri dahre dutiro tiquiro surarare ohoahye. Sa ye surara tiquinare wejẽ peho, tiquina ya macare ʉjʉ̃a cãhye. ");
INSERT INTO pirNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Tiquina sa yeri bato, pʉhtoro tiquiro cahacjẽnare ohõ saha niahye: “Bose deco cjẽ ijiatire quehno tuhasamedi. Sa ijiepegʉ̃ta yʉhʉ pijio mʉhtariquina yʉhʉ bose decore ihñaboriquina ijierare. Ñañequina ijiri tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Sa yena macare ijiye maharipʉ dʉhse ijiyequina mʉsa boca sayequinare bose decore ihñatiquinare pijiya”, niahye tiquiro cahacjẽnare. ");
INSERT INTO pirNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Tiquiro sa nigʉ̃ tiquiro cahacjẽna maharipʉ waha, ijipihtiyequinare tiquina boca sayequinare, ñañequina, quehnoañequina gʉ̃hʉre yahuahye. Tiquina sa pijiri bato esahye tiquina pari. Quehnoano ti bose deco tiquina yeri tucũre masa wahpa yʉhdʉa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Topʉ tiquina dujigʉ̃ pʉhtoro pehe ihcãquirore omoca dʉhteri deco cjã suhtirore sañeniquirore ihñahye. ");
INSERT INTO pirNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","“¿Ne yʉhʉ acayʉ, dʉhse yegʉ omoca dʉhteri deco cjã suhtirore sañedapegʉta sajã tari mʉhʉ?” ni sinituahye pʉhtoro. ’Tiquiro sa sinitugʉ̃ masʉno pehe yʉhtierahye. ");
INSERT INTO pirNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Tiquiro sa yʉhtieragʉ̃ ihñano tiquiro cahacjẽnare ohõ saha niahye: “Ahriquirore omocarine dʉhteya. Tiquiro dahpocãri gʉ̃hʉre dʉhteya. Dʉhte tuhasa ne wijia, sopecahapʉ cohãña tiquirore nahitianopʉ. Topʉ tiquiro tutuaro uti, bʉjʉa witiro mehna bahque dihorota”, niahye pʉhtoro, ni yahuri Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Tiquiro sa nidi bato ohõ saha ni bato tiri tiquiro: —‍Ahri queoye ijiro saha Cohãcjʉ̃ peyequina masa tiquiro pijioriquina ijiepeta meheñequinagã tiquiro mehna tojoaeta, ni yahu bato tiri Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Tiquiro sa nidi bato fariseo masa waha, tiquirore tiquina yahusãtire tiquina basi yahuducuahye. Tiquiro ñano yʉhtigʉ̃ tʉho duaye nimahye tiquirore yahusãñe tehe. ");
INSERT INTO pirNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Sa yahuducuye tiquina mehna cjẽnare, Herode ya curua cjẽna gʉ̃hʉre Jesure sinitu dutiye ohoahye. Tiquina pehe Jesu cahapʉ wihi, tiquirore meje cũ sinitumedi: —‍Buhegʉ, poto yahuducugʉ ni mehoñe mariegʉ mʉhʉ ijigʉ̃ masiaja ʉsã. Cohãcjʉ̃ yere queoro mʉhʉ yahugʉ̃ gʉ̃hʉre ʉsã masiaja. Sa yegʉ ihcãquiro pʉhtoro waro ijiepegʉ̃ta tiquiro gʉ̃hʉre dóyaro marieno potota yahure mʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Sa yegʉ ʉsãre yahuya. ¿Roma cjʉ̃no ijipihtiyequina pʉhtoro yere marine wapa yero cahmeajari, mʉhʉ tʉhotugʉ̃? ¿Mari dutiye wapa ye dutiajari, mʉhʉ tʉhotugʉ̃? ni sinitumedi tiquina Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Tiquina sa nigʉ̃ tʉhoro tiquirore tiquina ñano ye duayere masino ohõ saha nidi: —‍Masa ihñono dihita quehnoano iji mehona ijire mʉsa. ¿Dʉhsena yʉhʉ ñano yahuducugʉ̃ tʉho duajari mʉsa? ");
INSERT INTO pirNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Yojopʉre niñeru cjoere pʉhtoare wapa yeati cjoere ne cãhtaya. Ti cjoere ihñaʉhna, nidi tiquiro. Tiquiro sa nigʉ̃ tʉhoye niñeru cjoere ne cãhtari tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Sa yero tiquiro sinituri tiquinare: —‍¿Noa boro queoye wahñajari ahri cjoere? ¿Noa boro wame wahñajari? ni sinituri. ");
INSERT INTO pirNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","—‍César, masa ijipihtiyequina pʉhtoro queoye, tiquiro wame gʉ̃hʉ wahñare, ni yʉhtiri tiquina. Tiquina sa nigʉ̃ tʉhoro Jesu yahuri: —‍Ti pje pũrita masa ijipihtiyequina pʉhtoro yere tiquiro pehere ohoya. Cohãcjʉ̃ yere Cohãcjʉ̃ pehere ohoya, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Tiquiro sa nigʉ̃ tʉhoye, tʉho maria waha, wahaa wahari. ");
INSERT INTO pirNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Sa ye ti decota ihquẽquina saduceo masa Jesu cahapʉ wihiri. Saduceo masa pehe “Cohãcjʉ̃ yariariquinare masosi”, ni tʉhotuyequina ijiri. Sa ye ohõ saha nidi tiquina tiquirore: ");
INSERT INTO pirNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—‍Buhegʉ, ohõ saha ni buheahye Moise: “Ihcãquiro wahmino namo tiriquiro pohna mariedaperota yariagʉ̃ ihñano tiquiro bahʉrore tiquiro wahmino namono ijiricorore nʉoano cahmene. Sa yero wahmino mʉnano tiquiro pohna tiboriro saha pohna tiro cahmene tiquiro bahʉrore. Sa ye tiquiro pohne tiquiro wahmino mʉnano pohne yero saha ijieta”, ni ojoahye Moise, nidi tiquina saduceo masa. ");
INSERT INTO pirNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Tire sa ni yahu tuhasa ahri queoyere yahu nemori tiquina Jesure: —‍Ihcãquiro masʉno ijiahye. Seis bahana tiahye tiquiro. Tiquina wahmino pehe namo ti, pohna mariediquiro yariaa wahahye. Sa yero apequiro tiquiro bahʉro gʉ̃hʉ tiquiro wahmino namono ijiricorore nʉoahye. ");
INSERT INTO pirNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Sa nʉoari bato tiquiro wahmino yero sahata pohna mariedaperota yariaa wahahye tja. Sa yero ahriquiro bahʉro tiquiro wahmino mʉnano yero sahata pohna mariedaperota yariaa wahahye. Sa dihita wahahye ihcãquiro pohne waro. Ne pohna mariedapeta yaria pihtia wahahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Tiquina namono ijiricoro gʉ̃hʉ tiquina bato yariaa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","¿Cohãcjʉ̃ ijipihtiyequinare yariariquina mʉnare tiquiro masogʉ̃ diquiro boro namono pehe ijiboagari ticoro? Tiquina ijipihtiyequina ticorore namo tiriquina mʉna ijiahye. ¿Sa yero diquiro namono pehe ijiboagari ticoro pototi? ni sinituri tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesu yʉhtiri tiquinare: —‍Cohãcjʉ̃ yere tiquina ojoari pũre, tiquiro masiñe gʉ̃hʉre ne masiedare mʉsa. Sa ye mʉsa tʉhotuye pehe ne poto ijierare. ");
INSERT INTO pirNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Yariariquina mʉna tiquina masa mʉjari bato tiquina angele yero saha ijire. Namo marieñequina, manʉ marieñe numia ijire topʉre. ");
INSERT INTO pirNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Yariariquina mʉna tiquina masa wijiato pehere mʉsare yahutja. ¿Cohãcjʉ̃ mʉsare tiquiro nidire ne buherari mʉsa? Ohõ saha niahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“ ‘Yʉhʉ Abrahã, Isaac, Jacob tiquina pʉhto ijiaja’, nine Cohãcjʉ̃”, ni ojoahye panopʉre. Tiquina yariari bato “Tiquina pʉhto ijiaja”, ni yahuahye Cohãcjʉ̃. Sa nieperota yariariquina mʉna pʉhtoro ijierare Cohãcjʉ̃. “Tiquina pʉhto ijiaja”, tiquiro niñe mehna catiyequina tiquina ijigʉ̃ masiaja mari. Tiquiro catiyequina pʉhtoro ijire, ni yahuri Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Tiquiro sa ni buhegʉ̃ tʉhoye peyequina masa tʉho maria wahari. ");
INSERT INTO pirNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Sa ye saduceo masa Jesure tiquina yʉhti masiedagʉ̃ tʉhoye, fariseo masa pehe tiquiro cahapʉ cahmecoari. ");
INSERT INTO pirNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Sa yero tiquina mehna cjʉ̃no marine judio masare buheriquiro pehe Jesu tiquiro ñano nigʉ̃ tʉho duaro meje cũ sinitumedi tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—‍¿Buhegʉ, Cohãcjʉ̃ ye dutiro quehnoa yʉhdʉari dutiro noho pehe ijiajari, mʉhʉ tʉhotugʉ̃? ni sinituri tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesu tiquirore yʉhtiri: —‍“Tutuaro mʉsa jeripohna mehna, mʉsa tutuaye mehna, quehnoano mʉsa wacũñe mehna Cohãcjʉ̃re cahĩña”, nine Cohãcjʉ̃. ");
INSERT INTO pirNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ahri dutirota ijire quehnoa yʉhdʉari dutiro apeye dutiye yʉhdʉoro. ");
INSERT INTO pirNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ahri dutiro bato apero dutiro quehnoa yʉhdʉare: “Mʉhʉ basi mʉhʉ cahĩno saha mʉhʉ cahapʉ ijiyequina gʉ̃hʉre cahĩña”, nine Cohãcjʉ̃. ");
INSERT INTO pirNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ahri pʉa dutirota apeye dutiye gʉ̃hʉre masi pehogʉ̃ yere. Ahri pʉa dutirore yena, ijipihtiye apeye dutiyere ye pehona niaja mari. Cohãcjʉ̃ yere yahu mʉhtariquina panopʉ tiquina ojoari gʉ̃hʉre yena niaja mari, ni yahuri Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Sa ye fariseo masa topʉ cahmecoañequina tiquina ijigʉ̃ Jesu tiquinare sinituri: ");
INSERT INTO pirNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—‍“Cristo Cohãcjʉ̃ tiquiro ohoatiquiro ijire”, nine mʉsa. ¿Noa boro ijiajari tiquiro ñecʉno mʉnano panopʉ cjʉ̃no, mʉsa tʉhotugʉ̃? nidi tiquiro. —‍Cristo Davi mʉnano panamino iji turiariquiro ijirota, ni yʉhtiri tiquina. Jesu yahuri: ");
INSERT INTO pirNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","—‍¿Cristo Davi mʉnano panamino iji turiariquiro tiquiro ijigʉ̃ dʉhse yero Davi pehe pʉhtoro tiyari Cristore? ¿Dʉhse yero sa pʉhtoro ti dutiyari Espíritu Santo tiquirore? Ohõ saha niahye Davi: ");
INSERT INTO pirNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Cohãcjʉ̃ yʉhʉ pʉhtorore ohõ saha nidi: “Ohõpʉ yʉhʉ poto pehepʉ dujiya. Sa yegʉ mʉhʉre ihña tuhtiyequinare mʉhʉre yʉhdʉdʉca basaʉtja yʉhʉ”, nidi Cohãcjʉ̃ yʉhʉ pʉhtorore, ni ojoahye Davi. ");
INSERT INTO pirNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Sa ni ojoarota Davi pʉhtoro tiahye Cristore. ¿Davi Cristo ñecʉno iji turiariquiro ijiro dʉhse yero tiquiro pʉhtoro tiyari Cristore? Cristo Davi pʉhtoro ijire, ni yahuri Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Tiquiro sa ni yahugʉ̃ tiquina tiquirore ne yʉhti masiedari. Sa ye to punota sinitu duhu cãri tiquina tiquirore. Sa ye cueye, pari turi sinituerari tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Sa ye peyequina masare, ʉsã gʉ̃hʉre Jesu yahuri tja. ");
INSERT INTO pirNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—‍Marine judio masare buheyequina fariseo masa gʉ̃hʉ Cohãcjʉ̃ dutiye Moisere tiquiro cũrire yahuyequina ijire tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Tiquina sa yahuyequina ijigʉ̃ mʉsare tiquina yahuriro sahata tire ye pehoya mʉsa. Sa yepenata tiquinare ihña cũedacãhña mʉsa. Tiquina buheriro sahata yerare tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Masare peye dutire tiquina. Sa dutiepeta tiquina dutiro saha masa yeragʉ̃ ihñañe tiquinare yedohoerare. ");
INSERT INTO pirNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Masa tiquina ihñono dihita quehnoano ye ihñomene tiquina. Cohãcjʉ̃ yere tiquina ojoari pũre tiquina duhu sãñe acarigãre, bʉjʉ cjũñe acarigãre tiquina wʉhdoa bui dʉhte yori, masare ihña dutiye. Tiquina omocari gʉ̃hʉre dʉhte yori. Sa ye tiquina suhti tu pjeri da bui tiquina ohõri da ehsa yʉhdʉari da ijire. Cohãcjʉ̃re tiquina ño peorire masa pehere ye ihñoñe nimene tiquina. Ti queoro ijierare tiquina sa ye ihñoñe. ");
INSERT INTO pirNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Sa ye bose decori ijigʉ̃ pʉhtoa tiquina dujiyepʉ duji duare. Sa ye judio masa mari buheye wʉhʉsepʉ gʉ̃hʉre quehnoañe dujiye pahtari dihitare cahmene tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Sa ye doeri cjẽ duaropʉ apequina pʉhtoare quehnoano ño peo tiquina sinino saha tiquina piti cagʉ̃ cahmene tiquina. Tiquinare “Buhegʉ”, masa tiquina ni pisugʉ̃ cahmene. ");
INSERT INTO pirNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Apequina mʉsare pisuye “Buhegʉ”, niedacãhdo. Mʉsa ijipihtina ihcãno saha ijina nine. Sa yegʉ mʉsare buhegʉ ihcʉ̃ta ijiaja. ");
INSERT INTO pirNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Sa yena ahri yehpa cjẽnare “Mari pacʉ”, nina tiquinare ño peona niaga. Ne sa niedacãhña. Ʉhmʉse cjʉ̃no dihita mari Pacʉ ijire. Tiquiro dihitare ño peoro cahmene marine. ");
INSERT INTO pirNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Sa yena masʉnore “Pʉhto”, niedacãhña. Mʉsa pʉhto yʉhʉ Cristo pehe ihcʉ̃ta ijiaja. ");
INSERT INTO pirNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Cahacjʉ̃no yero saha mʉsare yedohoriquiro tiquiro ijire mʉsa pʉhtoro ijiatiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ihcãquiro pʉhtoro iji duaro tiquirore ihyo ijiriquiro yero saha ijiro cahmene. Sa yero “Ihyo ijigʉ ijiaja yʉhʉ”, ni tʉhoturiquiro pehe pʉhtoro ijirota, ni yahuri Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Tiquiro sa nidi bato tiquinare yahu nemori: —‍Mʉsa judio masare buhena, fariseo masa gʉ̃hʉ ñano yʉhdʉnata. Masa ihñono dihita quehnoano iji mehona ijire mʉsa. Sijoro saha mʉsa buhegʉ̃ tʉhoye masa pehe Cohãcjʉ̃ pʉhtoro ijiropʉre wahasi. Mʉsa gʉ̃hʉ topʉre wahasi. Sa yena topʉre waha duayequinare cahmotare mʉsa.  ");
INSERT INTO pirNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’Mʉsa judio masare buhena, fariseo masa gʉ̃hʉ ñano yʉhdʉnata. Masa ihñono dihita quehnoano iji mehona ijire mʉsa. Wape wiha numia ye wʉhʉsere tiquina cʉoye gʉ̃hʉre ehmare mʉsa tiquina numiare. Sa yena yoari pje masa ihñonopʉ Cohãcjʉ̃re sini ihñomene mʉsa masare. Mʉsa sa yeri buhiri peyequina yʉhdʉoro Cohãcjʉ̃ buhiri dahrerota mʉsare. ");
INSERT INTO pirNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’Mʉsa judio masare buhena, fariseo masa gʉ̃hʉ ñano yʉhdʉnata. Masa ihñono dihita quehnoano iji mehona ijire mʉsa. Pajiri mapʉ pehã, yoaro cjẽ yehparipʉ wahare mʉsa, mʉsa dutiyere yeatiquirore macana tana. Mʉsa dutiyere yeatiquirore boca, tiquirore buhere. Mʉsa sa yegʉ̃ tiquiro pehe mʉsa yʉhdʉoro pecapʉ wahatiquiro ijirota. ");
INSERT INTO pirNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’Mʉsa ñano yʉhdʉnata. Caperi bajueyequina tiquina ihña masieno saha masiena ijire mʉsa. Sa ijiepenata apequinare buhemene mʉsa. Ohõ saha ni buhemene mʉsa: “ ‘Cohãcjʉ̃ wʉhʉ mehna yʉhʉ nino sahata yeitja’, nidiquiro, tiquiro nidiro sahata yerapegʉ̃ta quehnoanota”, ni buhemene mʉsa. “ ‘Cohãcjʉ̃ ya wʉhʉ cjẽ uru mehna yʉhʉ nino sahata yeitja’, nidiquiro tiquiro pehere tiquiro nidiro sahata ye sohtori tiro cahmene”, ni ti gʉ̃hʉre buhemene mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Caperi bajueyequina tiquina ihña masieno saha masiena ijire mʉsa. Tʉho masiena ijire. ¿Dise boro pehere ño peoro cahmeajari? Urure ño peoeraro cahmene. Cohãcjʉ̃ pehe ti uru ti wʉhʉpʉ ijigʉ̃ quehnoañe ijigʉ̃ yere tire. Sa yena ti wʉhʉ pehere ño peoro cahmene mʉsare. Sa ye mʉsa buheye pehe queoro ijierare. ");
INSERT INTO pirNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ahri gʉ̃hʉre buhemene mʉsa: “ ‘Cohãcjʉ̃ wʉhʉ cjã altar mehna yʉhʉ nino sahata yeitja’, nidiquiro tiquiro nidiro sahata yeragʉ̃ quehnoanota”, ni buhemene mʉsa. “ ‘Ti altar bui ijiye mehna Cohãcjʉ̃re tiquina ohori mehna yʉhʉ nino sahata yeitja’, nidiquiro tiquiro pehere tiquiro nidiro sahata ye sohtori tiro cahmene”, ni buhemene mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Caperi bajueyequina tiquina ihña masieno saha masiena ijire mʉsa. ¿Dise boro pehe ti waro ijiajari, mʉsa tʉhotugʉ̃? Cohãcjʉ̃re masʉno tiquiro ohori ti waro ijiera cjũre. Ti altar bui Cohãcjʉ̃re tiquiro ohogʉ̃, quehnoañe wahare ti altar bui ijiye. Sa yero ti altar pehe ihyo ijiri altar ijierare. Cohãcjʉ̃re tiquina ohori bui cjũnogã quehnoari altar ijire. ");
INSERT INTO pirNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Sa yero “Cohãcjʉ̃ wʉhʉ cjã altar mehna yʉhʉ nino sahata yeitja”, ihcãquiro nino, ti altar bui cjẽ tiquiro ohori mehna sa nino niaga. Sa ye mʉsa buheye pehe queoro ijierare. ");
INSERT INTO pirNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Sa yero “Cohãcjʉ̃ wʉhʉ mehna yʉhʉ nino sahata yeitja”, ihcãquiro nino, potota Cohãcjʉ̃ mehnata sa ninota niaga. Cohãcjʉ̃ ti wʉhʉ cjʉ̃no ijire. ");
INSERT INTO pirNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Sa yero “Ʉhmʉse mehna yʉhʉ nino sahata yeitja”, ihcãquiro nino, Cohãcjʉ̃ ijiropʉ mehnata sa nino niaga. Sa yero Cohãcjʉ̃ mehnata sa nino niaga. Tiquiro pehe to cjʉ̃no ijire. Sa ye mʉsa buheye pehe queoro ijierare. ");
INSERT INTO pirNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’Mʉsa judio masare buhena, fariseo masa gʉ̃hʉ ñano yʉhdʉnata. Masa ihñono dihita quehnoano iji mehona ijire mʉsa. Moa yero saha ijiyere ihyayere ocagʉ̃ yeyere cʉona mehenogã ohomene mʉsa. Cohãcjʉ̃re ño peona tana pahiare ohomene mʉsa. Mehenogã ohomene mʉsa. Menta, anís, comino wame tiye ocagʉ̃ yeyere ohomene mʉsa. Sa ohoepenata quehnoañene yerare mʉsa. Sa yena masare paja ihñedare mʉsa. Sa yena Cohãcjʉ̃re wacũ tutuerare mʉsa. Oteye dʉcare mʉsa nedire mehenogã pahiare mʉsa ohogʉ̃ quehnoare. Sa ohona ohõ saha ye nemoña: Quehnoañene yeya. Sa yena paja ihñaña masare. Sa yena Cohãcjʉ̃re wacũ tutuaya. ");
INSERT INTO pirNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Caperi bajueyequina tiquina ihña masieno saha masiena ijire mʉsa. Ohõ saha yere mʉsa: Mʉsa ye dutiyere ye dutina, ihyo ijiyegã warore dutiyere yere mʉsa. Sa yepenata Cohãcjʉ̃ pototi tiquiro dutiye warore yerare mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’Mʉsa judio masare buhena, fariseo masa gʉ̃hʉ ñano yʉhdʉnata mʉsa. Masa ihñono dihita quehnoano iji mehona ijire mʉsa. Mʉsa waparire, mʉsa sihniñe wajarire bui mʉsa cosero saha quehnoañene ye ihñore mʉsa buigã warona. Sa yepenata Cohãcjʉ̃ yere queoro yerare mʉsa. Apequina yere ehmana, mʉsa basi dihita bʉjʉyere ne duana ijire mʉsa. Sa dihita tʉhoture mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Caperi bajueyequina tiquina ihña masieno saha masiena ijire mʉsa fariseo masa. Mʉsa jeripohnarine camesaya mʉsa. Quehnoañe pehere yeya. Mʉsa sa yena masa tiquina ihñonopʉ quehnoana ijinata mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’Mʉsa judio masare buhena, fariseo masa gʉ̃hʉ ñano yʉhdʉnata. Masa ihñono dihita quehnoano iji mehona ijire mʉsa. Masa cope, yehseye mehna tiquina wisõri cope yero saha ijire mʉsa. Masa ti copere tiquina ihñagʉ̃ quehnoari cope bajure. Sa bajuepegʉ̃ta, puhiapʉ ahbariquirore, tiquiro cohãrine, ñañene ihñedare tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Sata mʉsa gʉ̃hʉ masa ihñonopʉ quehnoañequina yero saha bajumene mʉsa. Sa quehnoañequina yero saha bajuna mʉsa ijiepegʉ̃ta mʉsa tʉhotuyepʉ ñañe, ni mehoñe iji yʉhdʉare ahbaye yero saha, ni yahuri Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Sa ni tuhasa ohõ saha ni yahu nemori tiquinare: —‍Mʉsa judio masare buhena, fariseo masa gʉ̃hʉ ñano yʉhdʉnata. Masa ihñono dihita quehnoano iji mehona ijire mʉsa. Cohãcjʉ̃ yere yahu mʉhtañequina panopʉ cjẽna tiquina masa coperire quehnoano quehnomene mʉsa, tiquinare ño peoro saha yena. Sa yena quehnoano yeyequina mʉna tiquina queoyere mʉsa yeri queoyere quehnoano quehnomene mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Sa yena ohõ saha niducumene mʉsa: “Panopʉre ʉsã ñecʉsʉmʉa iji turiayequina mʉna tiquina yeriro saha ʉsã pehe yeraboaga. Ti pjepʉ ijiyequinare Cohãcjʉ̃ yere yahu mʉhtariquinare ʉsã wejẽdaboaga”, niducumene mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Sa nina mʉsa ñecʉsʉmʉa iji turiayequina Cohãcjʉ̃ yere yahu mʉhtariquinare wejẽdiquina mʉna tiquina yerire ihñona nine. Tiquinare wejẽdiquina mʉna tiquina panamena iji turiana mʉsa ijiye gʉ̃hʉre ihñona nine mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Mʉsa ñecʉsʉmʉa iji turiayequina mʉna tiquina yeriro sahata ye sohtori ticũnahña. ");
INSERT INTO pirNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’Añaa yero saha ña yʉhdʉana ijire mʉsa. Mʉsa ñañe yerire bʉjʉa witi duerana Cohãcjʉ̃ mʉsa ñañe buhirire pecapʉ mʉsare tiquiro cohãto pano duhti masiedare mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Sa yegʉ mʉsare niita niaja. Cohãcjʉ̃ yere yahu mʉhtariquinare, apequina quehnoano masiñequinare, apequina mʉsare buheatiquinare mʉsa cahapʉ ohoutja. Yʉhʉ sa ohogʉ̃ mʉsa pehe ihquẽquina tiquinare wejẽnata. Apequinare curusapʉ quẽ bihanata. Apequinare mʉsa buheye wʉhʉsepʉ tananata. Sa yena macaripepʉ tiquinare ñano yena, oma nʉnʉ tãnata mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Mʉsa sa yena ijipihtiyequina ñañe marieñequinare mʉsa wejẽdi buhiri buhiri tinata. Abe mʉnanore Caĩ wejẽdi buhiri ijipihtina mʉsa gʉ̃hʉ buhiri tinata. Ijipihtiyequina tiquiro bato ijiyequinare quehnoañequinare tiquina wejẽdi buhiri gʉ̃hʉre buhiri tinata mʉsa gʉ̃hʉ. Sa yena Cohãcjʉ̃ wʉhʉ cahapʉ wahiquinare mʉsa ohori altar cahapʉ Zacariare wejẽahye mʉsa. Tiquiro pehe Berequia macʉno ijiahye. Sa yena tiquiro gʉ̃hʉre mʉsa wejẽdi buhiri buhiri tinata mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ijirota mʉsare yahugʉta niaja. Tiquina ijipihtiyequinare tiquina wejẽdi buhiri yojopʉ cjẽna gʉ̃hʉ buhiri tieta, ni yahuri Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Sa ni tuhasa ohõ saha ni nemori: —‍Ahyou, Jerusalẽ cjãna, Cohãcjʉ̃ yere yahu mʉhtariquinare wejẽdina ijire mʉsa. Mʉsa acaye panopʉ cjẽna gʉ̃hʉ sata yeyequina mʉna ijiahye. Sa yena mʉsa cahapʉ tiquiro ohoriquinare ʉtã paca mehna doque wejẽdina ijire mʉsa. Canaca ticoro pohnene ticoro wʉye dʉpʉri mehna ticoro moha cuñano saha peye tahari cahĩducumi mʉsare. Mʉsare cahmemi. Mʉsa pehe yʉhʉre ne cahmedari. ");
INSERT INTO pirNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Yojopʉ mʉsa ya maca cohõri maca ijirota. ");
INSERT INTO pirNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ijirota mʉsare niita niaja. Camepʉ ahtaʉtja yʉhʉ. Sa yʉhʉ ahtagʉ̃ ihñana mʉsa yʉhʉre “Cohãcjʉ̃ tutuaye mehna ahtariquiro quehnoahdo”, ninata. Yʉhʉre mʉsa tire niato pano yʉhʉ tojoa tato pano pari turi yʉhʉre ihñasi mʉsa, nidi Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Sa ye Cohãcjʉ̃ wʉhʉpʉ ijiriquiro Jesu tiquiro wijia wihigʉ̃ ʉsã tiquiro buhena ti wʉhʉre ti wʉhʉ cahapʉ ijiye wʉhʉse gʉ̃hʉre ihñana, —‍Quehnoa yʉhdʉye wʉhʉse ijicjoare. Ihñaña mʉhʉ gʉ̃hʉ, nii ʉsã tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jesu yʉhtiri: —‍Ahri wʉhʉsere yojopʉre ihñamene mʉsa. Mʉsare yahugʉta niaja. Ahri wʉhʉsere ijipihtiye mʉsa ihñari, ahri wʉhʉse cjẽ ʉtã paca gʉ̃hʉre cohã pehoeta. Ne ihcãria ʉtã tojoasi, nidi tiquiro ʉsãre. ");
INSERT INTO pirNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Came Olivo wame tidʉ cʉnʉpʉ esa, topʉ dujiri Jesu. Topʉ dujigʉ̃ ʉsã tiquiro buhena ʉsã sehsaro tiquiro cahapʉ esaʉ. —‍Yahuya ʉsãre. ¿Dʉhse ijigʉ̃ sa waharotari mʉhʉ nidiro saha waharo? ¿Ahri yehpapʉ mʉhʉ tojoa tati deco, pihtiati deco panogã ijigʉ̃ dʉhse ti waha dʉcagʉ̃ ihñanatari ʉsã? ni sinituu ʉsã. ");
INSERT INTO pirNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesu yʉhtiri: —‍Quehnoano yeya mʉsa. Sa yena mʉsare apequina tiquina ni mehoñene tʉhoeracãhña. ");
INSERT INTO pirNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Peyequina masa “Cristo ijiaja yʉhʉ”, ni mehoñequina ahtaeta. Tiquina sa ni mehogʉ̃ tʉhoye peyequina masa Cohãcjʉ̃ yere duhueta. ");
INSERT INTO pirNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mʉsa cahagãpʉ masa apequina tiquina cahme wejẽgʉ̃ tʉhonata mʉsa. Sa yena yoaropʉ gʉ̃hʉre tiquina cahme wejẽgʉ̃ tʉhoonata mʉsa. Sa tʉhooepenata ne tire pajiro wacũedacãhña. Sa waharota. Tiquina sa yegʉ̃ pihtiati deco dʉhsarĩnota. ");
INSERT INTO pirNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ti pjere ihcã yehpa cjẽna ape yehpa cjẽna mehna cahme wejẽeta. Sa ye ihcãquiro pʉhtoro yequina apequiro pʉhtoro yequina mehna cahme wejẽeta. Sa ye peyequina masa ʉjʉa mehna yarieta. Sa yero peye yehparipʉ yehpa ñuhminota. ");
INSERT INTO pirNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Sa wahagʉ̃ ahri yehpa cjẽnare tiquina ñano yʉhdʉ nemoato dʉhsarota ti pjere. Ñano yʉhdʉ nemoeta. ");
INSERT INTO pirNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Ti pjere apequina mʉsare ñehe, ñano ye dutiye ohoeta mʉsare apequina pʉhtoapʉre. Tiquina sa ohogʉ̃ mʉsare wejẽeta. Yeequina mʉsa ijiri buhiri ijipihtiyequina mʉsare ihña tuhtieta. ");
INSERT INTO pirNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ti pjere peyequina yeequina ijimediquina yʉhʉre cohãeta. Sa ye tiquina mehna cjẽnare tiquina ihña tuhtieta. Sa ye tiquina mehna cjẽna tiquina ijiepegʉ̃ta tiquinare ñano yeatiquinare ohoeta tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ti pjere peyequina “Cohãcjʉ̃ yere yahu mʉhtana ijiaja”, ni mehoñequina ijieta. Sa ye peyequina masa tiquina ni mehoñene tʉhoeta. ");
INSERT INTO pirNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ti pjere ña yʉhdʉaro yeeta masa. Sa ye tiquina mehna cjẽnare cahĩ nemosi. ");
INSERT INTO pirNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Sa yena mʉsa tutuana ijina, ahri yehpapʉ mʉsa catinino puno ihcãno sahana, yʉhdʉnata mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Sa yero ahri quehnoañe buheye ijipihtiropʉ ahri yehpapʉre tiquina yahuri buheye ijirota. Cohãcjʉ̃ pʉhtoro ijiyere yahuri buheye tiquina yahu siteri buheye ijirota, ijipihtiyequina ti buheyere tiquina masiato saha. Tiquina sa yahuri bato pihtiri deco dʉcarota. ");
INSERT INTO pirNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Cohãcjʉ̃ yere yahu mʉhtariquiro Daniel mʉnano panopʉ cjʉ̃no ña yʉhdʉariquirore Cohãcjʉ̃ yere ñano yeriquirore yahue tiahye panopʉre. Ti pjere tiquiro ñariquiro pehe Cohãcjʉ̃ ya wʉhʉpʉ tiquiro ducugʉ̃ ihñanata mʉsa. Ahri yʉhʉ nidire quehnoano masiña mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Topʉ tiquiro ducugʉ̃ ihñañe, Judea yehpapʉ ijiyequina pehe cʉnʉ cahapʉ oma duhtiahro. ");
INSERT INTO pirNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Sojaro mehna oma duhtiahro. Ti pjere tiquina wʉhʉseri bui cjẽ paaripʉ ijiyequina wʉhʉ puhiapʉ ijiyere tiquina yere neñe wahaeracãhdo tiquina ʉmʉñano waharo. ");
INSERT INTO pirNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Sa ye ti pjere apequina weseripʉ ijiyequina tiquina bui cjẽ suhti wʉhʉpʉ ijiye suhtire neñe wahaeracãhdo tiquina ʉmʉñano waharo. ");
INSERT INTO pirNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ti pjere niji pacosãnumia, tiquina pohnene apũoñe numia gʉ̃hʉ pejecʉoro wahaeta. ");
INSERT INTO pirNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Sa yena Cohãcjʉ̃re ohõ saha ni siniña: “Pohecʉ ijigʉ̃ judio masa ʉsã soye decori ijigʉ̃ gʉ̃hʉre ʉsã oma duhtiati deco ijieracãhdo”, ni siniña mʉsa Cohãcjʉ̃re. ");
INSERT INTO pirNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ti decorire masa ña yʉhdʉaro wahaeta. Ahri yehpare tiquiro bajumehnedi bato masa ñano yʉhdʉe tiahye. Tiquina sa yʉhdʉepegʉ̃ta ijipihtiye ti purĩñe yʉhdʉoro pihtiri deco panogã ña yʉhdʉaro yʉhdʉeta masa. Sa ñano tiquina yʉhdʉri bato pari turi sata ñano yʉhdʉsi ahri yehpapʉ. ");
INSERT INTO pirNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Cohãcjʉ̃ ti decorire meheñe decorigã ijigʉ̃ yerota. Tiquiro sa yeragʉ̃ ne ihcãquiro masʉno yʉhdʉeraboaga. Sa yero tiquiro beseriquina tiquina yʉhdʉatire meheñe decorigã cũnota Cohãcjʉ̃. ");
INSERT INTO pirNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ti pjere apequina mʉsare “Ihñaña. Ohõpʉ ijire Cristo”, tiquina nigʉ̃ tiquinare tʉhoeracãhña. “Topʉ ijire Cristo”, tiquina nigʉ̃ tiquinare tʉhoeracãhña. ");
INSERT INTO pirNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","“Cristo ijiaja”, ni mehoñequina, “Cohãcjʉ̃ yere yahu mʉhtarina ijiaja”, ni mehoñequina ijieta ti pjere. Sa ye Cohãcjʉ̃ tiquiro beseriquinare ni mehoñe, tiquina bajumehneñene ye ihñoeta. Cohãcjʉ̃ yequinare Cohãcjʉ̃re tiquina cohãgʉ̃ ye duare tiquina ni mehoñequina. ");
INSERT INTO pirNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ahri ijipihtiyere yahuyuaja mʉsare ti sa wahato pano. Sa yena tʉhoya mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Apequina masa mʉsare “Ihñaña. Masa marienopʉ ijire Cristo”, tiquina nigʉ̃ topʉre ihñana wahaeracãhña. Sa yena “Ohõpʉ ahri tucũripʉ ijire tiquiro”, tiquina nigʉ̃ tiquinare tʉhoeracãhña. ");
INSERT INTO pirNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ wacũeno mehna tojoa taʉtja. Ʉpo miadoqueoro ʉhmʉsere asʉ̃ mʉja taropʉ, asʉ̃ sajãnopʉ wacũeno mehna ti miadoqueoro saha wacũeno mehna tojoa taʉtja yʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Masa tiquina ñañe yeducuriropʉ topʉ Cohãcjʉ̃ tiquina ñañe buhiri buhiri dahrerota tiquinare, ni yahuri Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Sa ye tiquinare yahu nemori: —‍Ti ñano yʉhdʉye decori bato asʉ̃ deco cjʉ̃no, ñami cjʉ̃no gʉ̃hʉ buhrio duhueta. Tiquina sa wahagʉ̃ ñahpicoha paca ʉhmʉsepʉ ijiye paca bora dijia taeta. Sa ye ʉhmʉse cjẽ yehpari, ñahpicoha gʉ̃hʉ ti sa wahaducurore camesaeta. Sa ye ñuhmieta. ");
INSERT INTO pirNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ti pjeta yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ ʉhmʉsepʉ yʉhʉ bajumehnenore yʉhʉ ihñogʉ̃ ihñaeta masa. Sa ye ijipihtiye cururi cjẽna utieta. Sa yegʉ yʉhʉ tutuaye mehna, yʉhʉ asi siteye mehna ʉhmʉano cjẽ ehmeo cururi bui ahri yehpapʉre yʉhʉ tojoa tagʉ̃ ihñaeta tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Corneta bisirota. Sa yegʉ yeequina angelere ijipihtiropʉ ahri yehpapʉ ohoutja yʉhʉ. Sa ye ijipihtiropʉ yeequina yʉhʉ beseriquinare tiquina neeta. ");
INSERT INTO pirNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Yojopʉre higueragʉre tʉhotuya mʉsa. Tʉ queoye mehna mʉsare buheitja. Tʉ yucʉgʉ pũri tigʉ̃ ihñana, cʉhma mehenogã dʉhsagʉ̃ masine mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Sata ahri ijipihtiye yʉhʉ nidire ti sa wahagʉ̃ ihñana, yʉhʉ tojoa tato mehenogã ti dʉhsagʉ̃ masinata mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ijirota niita niaja mʉsare. Ti pje cjẽna tiquina yariato pano ijipihtiye yʉhʉ nidiro sahata sa waharota. Ʉhmʉse, ahri yehpa gʉ̃hʉ pihtia waharota. ");
INSERT INTO pirNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Yʉhʉ yahuducuye pehe ne camesasi. Ijipihtiye yʉhʉ nidiro sahata sa waha sohtori tirota. ");
INSERT INTO pirNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Ti decore yʉhʉ tojoa tati decore, ti hora gʉ̃hʉre masiedaja yʉhʉ. Angele gʉ̃hʉ tire masiedare. Masa gʉ̃hʉ masiedare. Yʉhʉ Pacʉ dihita tire masine. ");
INSERT INTO pirNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Noé tiquiro ijiri pje cjẽna tiquina ijiriro sahata ahri yehpapʉ yʉhʉ tojoa tato panogãre sata ijieta masa. ");
INSERT INTO pirNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Yehpa miniato pano masa ihya, sihni, yeahye. Sa yeye ʉmʉa, numia mehna omoca dʉhteahye. Noé gʉ̃hʉ yucʉsapʉ tiquina sajãto pano sa yee timahye masa. ");
INSERT INTO pirNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Duita tutuaro acoro ahta, wacũeno mehna yehpa minia wahahye. Masa gʉ̃hʉ mini pihtia wahahye. Wacũeno mehna tiquina minidiro saha yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ ahri yehpapʉre wacũeno mehna tojoa taʉtja. ");
INSERT INTO pirNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ti pjere wesepʉ pʉaro dahrayequina ijigʉ̃ ihcãquiro yʉhʉre cahmediquirore neitja. Sa yero yʉhʉre cahmeediquiro topʉ tojoarota. ");
INSERT INTO pirNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ti pjere pʉaro numia ihcãnopʉ tiquina trigore ña mʉtoñequina numia ijigʉ̃ ihcãcoro yʉhʉre cahmedicorore neitja. Sa yero yʉhʉre cahmeedicoro topʉta tojoarota. ");
INSERT INTO pirNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Quehnoano wacũ masi cohteya. Yʉhʉ mʉsa pʉhto, yʉhʉ tojoa tati decore ne masiedare mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ahrire wacũña. Yaqueriquiro wʉhʉpʉ tiquiro sajã yaqueato panore wʉhʉ upʉro masino, ti ñami tiquiro carĩedaboaga, yaqueriquirore cohtero. Sa yero yaqueriquirore tiquiro ya wʉhʉpʉ sajã dutieraboaga. Yaqueriquiro tiquiro wacũeno mehna tiquiro ahtariro saha wacũeno mehna ahtaʉtja yʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Sa yena yeere sa yeducuna yʉhʉre cohteya. Yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ ahri yehpapʉ tojoa tagʉ wacũeno mehna ahtaʉtja, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Sa ye Jesu queoye mehna ohõ saha ni buhe nemori tja: —‍Dahra cohteriquiro tiquiro pʉhtorore ño peoriquiro tʉho masiniquiro ijire. Tiquiro sa ijigʉ̃ ihñano apequina dahra cohteyequina bui cũre tiquirore tiquiro pʉhtoro pehe waharo taro. Sa tiquirore cũ tuhasa wahaa wahare pʉhtoro. Sa yero ihyari pje ijigʉ̃ dahra cohteriquiro apequinare ihyayere itire. ");
INSERT INTO pirNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Came pʉhtoro tiquiro ya wʉhʉpʉ tojoa wihire. Tiquiro tojoa wihigʉ̃ ihñano dahra cohteriquiro pehe tiquiro pʉhtoro dutiriro sahata ye pehoriquiro ijiro, bucueriquiro ijirota. ");
INSERT INTO pirNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ijirota mʉsare niita niaja. Tiquiro sa yegʉ̃ ihñano tiquiro pʉhtoro ijipihtiye tiquiro yere ihña ihboriquiro cũnota tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Sa yepegʉ̃ta ñariquiro dahra cohteriquiro pehe “Yʉhʉ pʉhtoro bajuerare”, nino, ");
INSERT INTO pirNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","apequina dahra cohteyequinare quẽpe, pajiro ihya, sihni, queheyequina mehna queherota. ");
INSERT INTO pirNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Came tiquiro pʉhtoro wacũeno mehna tojoa tarota. Ti deco, ti hora gʉ̃hʉre ne masiedare dahra cohteriquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Pʉhtoro pehe tojoa taro ñariquiro tiquiro ñano yerire tʉhoro, tiquirore tutuaro buhiri dahrerota. Sa yero ni mehoñequina tiquina waharopʉ cohãnota tiquirore. Topʉre tiquiro tutuaro uti, bʉjʉa witiro mehna bahque dihorota, ni yahuri Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Sa ye Jesu pari turi queoye mehna ohõ saha ni buhe nemori tja: —‍Ʉhmʉse cjʉ̃no pʉhtoro tiquiro ijiye ahri queoye yero saha ijire: Pʉa omope nuhmia ijiahye. Ihcã ñami tiquina sihõñe paca mehna omoca dʉhteatiquirore piti caye wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Tiquina mehna ihcã omope numia tʉho masieñequina numia ijiahye. Apequina numia pehe ihcã omope numia tʉho masiñequina numia ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Tʉho masieñequina numia pehe tiquina sihõñe pacare, pose tiye pacare nemahye. Apee pacare ʉhse pose tiye pacare ti pihtigʉ̃ tiquina pioborire nedahye. ");
INSERT INTO pirNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Tʉho masiñequina numia pehe tiquina sihõñe paca ʉhse pose tiye pacare neahye. Apee paca tiquina pioati paca gʉ̃hʉre neahye. ");
INSERT INTO pirNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Sa ye omoca dʉhteatiquiro tiquiro bajueragʉ̃ tiquina numiare wʉjʉa purĩgʉ̃ carĩa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Sa yero ñami decopʉ sañuducugʉ̃ tʉhoahye. “Tʉhoya. Omoca dʉhteatiquiro ahtaro ca tare. Tiquirore piti cana ahtaya”, ni sañuducugʉ̃ tʉhoahye. ");
INSERT INTO pirNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Tiquiro sa nigʉ̃ tʉhoye numia wahcã, tiquina ye sihõñe pacare quehnoahye. ");
INSERT INTO pirNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Sa ye tʉho masieñequina numia pehe apee numia tʉho masiñequina numiare ohõ saha niahye: “Ʉsã sihõñe paca yatiro nine. Sa yena mehenogã mʉsa ye ʉhsere ohoya ʉsãre”, ni sinimahye tiquina numia. ");
INSERT INTO pirNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Tiquina sa siniepegʉ̃ta tʉho masiñequina numia ohõ saha yʉhtiahye: “Ʉsã ye ʉhse mari ijipihtinare esa tuhaeraboaga. Sa yena ʉhse cʉoyequinare mʉsa basi dúna wahaya”, ni yʉhtiahye tʉho masiñequina numia pehe. ");
INSERT INTO pirNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Sa ye tʉho masieñequina numia dúye wahahye. Tiquina sa wahari bato omoca dʉhteatiquiro wihiahye. Tiquiro wihigʉ̃ ihña tiquina yere quehno tuhasariquina numia tʉho masiñequina numia tiquirore piti cahye. Piti ca bose deco omoca dʉhteri decopʉ tiquiro mehna ihñañe wahahye. Sa ye bose decore tiquina yeri wʉhʉpʉ apequina mehna numia tiquina sajãri bato, sopecahare biha cãhye. ");
INSERT INTO pirNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Camepʉ tʉho masieñequina numia pehe wihimahye. “Pʉhto, ʉsãre põohña”, nimahye tiquina numia. ");
INSERT INTO pirNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Ijirota mʉsare niita niaja. Mʉsare masiedaja yʉhʉ”, niahye tiquiro tiquina numiare. ");
INSERT INTO pirNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","’Sa yena tʉho masiñequina numia tiquina yere quehnoano quehno tuhasa, tiquina cohteriro saha quehnoana, ñañe mariena iji, cohteya mʉsa gʉ̃hʉ. Yʉhʉ tojoa tati decore ti hora gʉ̃hʉre ne masiedare mʉsa, ni yahuri Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Sa ni yahu tuhasa queoye mehna ohõ saha ni buhe nemori tja: —‍Ti pjere yʉhʉ tojoa tati pje ahri queoye yero saha ijirota. Wʉhʉ upʉro ijiahye. Tiquiro ape siepʉ tinino waharo taro, tiquirore dahra cohteyequinare pijioahye. Sa yero tiquinare tiquiro yere cohte dutiahye. ");
INSERT INTO pirNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Sa cohte dutiro tiquina ihbo masino puno tiquinare niñeru cjoerire ohoahye. Ihcãquirore ihcã omope cjoeri wapa bʉjʉye cjoerire uru cjoerire ohoahye. Apequirore pʉa cjoe ohoahye. Apequirore ihcã cjoe ohoahye. Tiquinare oho tuhasa, wahaa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Sa ye ihcã omope cjoeri tiquiro ohoriquiro duita tiquiro wahari batota ti cjoeri mehna apee borore dúahye. Tiquiro dúrire apequinare duahye. Tiquiro duari wapa pʉa omope cjoeri wapa yeahye tiquirore. Sa yero pʉa omope cjoeri cʉoahye. ");
INSERT INTO pirNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Sa yero pʉa cjoe tiquiro ohoriquiro duita tiquiro wahari batota ti cjoeri mehna apee borore dúahye. Tiquiro dúrire apequinare duahye. Tiquiro duari wapa pititia cjoe wapa yeahye tiquirore. Sa yero pititia cjoe cʉoahye. ");
INSERT INTO pirNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ihcã cjoere tiquiro ohoriquiro pehe cope sehe, ti cjoere yahye, ti copepʉ nʉono. ");
INSERT INTO pirNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Came yoari bato tiquina pʉhtoro wihiahye. Sa wihiro tiquiro niñeru cjoeri mehna tiquina ñehe nemorire queoro ahtaro tiquirore dahra cohteyequinare pijioahye. ");
INSERT INTO pirNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Sa yero ihcã omope cjoeri tiquiro ohoriquiro pʉhtoro cahapʉ esa, pʉa omope cjoeri wiahye tiquirore. “Ihcã omope cjoeri yʉhʉre ohori mʉhʉ. Ihñaña. Ti cjoeri mehna apeye cjoerire ñehe nemou”, niahye tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Quehnoano yeaya mʉhʉ. Mʉhʉ quehnoagʉ, yʉhʉ dutiriro saha yerigʉ ijire. Mehenogãre quehnoano yeaya mʉhʉ. Sa yegʉ yojopʉre mʉhʉre pajiro mʉhʉ dahratire cũtja. Sa yegʉ yʉhʉ mehna bucueya mʉhʉ”, niahye tiquiro pʉhtoro. ");
INSERT INTO pirNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Sa yero pʉa cjoere ñehediquiro pʉhtoro cahapʉ esa, yahuahye tiquirore: “Pʉa cjoe yʉhʉre ohori mʉhʉ. Ihñaña. Ti cjoeri mehna apeye cjoeri pʉa cjoe ñehe nemou”, niahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Quehnoano yeaya mʉhʉ. Mʉhʉ quehnoagʉ, yʉhʉ dutiriro saha yerigʉ ijire. Mehenogãre quehnoano yeaya mʉhʉ. Sa yegʉ yojopʉre pajiro mʉhʉ dahratire cũtja. Sa yegʉ yʉhʉ mehna bucueya mʉhʉ”, niahye tiquiro pʉhtoro. ");
INSERT INTO pirNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","’Sa yero ihcã cjoere ñehediquiro pʉhtoro cahapʉ esa, yahuahye tiquirore: “Pʉhto, mʉhʉ apequina pehere tutuaro dahra dutigʉ ijire. Sa tutuaro dahra dutigʉ ijigʉ mʉhʉ basi oterapegʉta ti dʉcare nene mʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Mʉhʉ sa ijigʉ̃ mʉhʉre cuei. Sa cuegʉ cope sehe, ti copepʉ mʉhʉ niñeru cjoere nʉou. Ihñaña. Ohõpʉ ijire mʉhʉ ya cjoe niñeru cjoe”, niahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Mʉhʉ ñagʉ, cape bʉjʉgʉ ijire. Yʉhʉ basi oterapegʉta ti dʉcare yʉhʉ negʉ ijigʉ̃ masine mʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Yʉhʉ sa ijigʉ̃ ihñaepegʉta yʉhʉ niñeru cjoere niñeru ihbori wʉhʉpʉ ihboboaya mʉhʉ. Mʉhʉ sa ihbogʉ̃ tiquina ti cjoere wiayepʉ apee niñeru oho nemoboaya tiquina”, niahye pʉhtoro tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Sa nino apequina tiquiro dahra cohteyequinare dutiahye tiquiro: “Niñeru cjoere ehmaña tiquirore. Pʉa omope cjoerire cʉoriquiro pehere ohoya. ");
INSERT INTO pirNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Cʉoyequinare oho nemoutja. Sa ye pajiro cʉoeta. Cʉoeyequina pehere mehenogã tiquina cʉoepegʉ̃ta tire ehmaʉtja. ");
INSERT INTO pirNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ahriquiro dahra cohteriquiro dʉhseatiquiro ijierare. Nahitianopʉ ñanopʉ cohã cãhña tiquirore. Topʉ tiquiro tutuaro uti, bʉjʉa witiro mehna bahque dihorota”, niahye pʉhtoro, ni yahuri Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Sa ye Jesu yahu nemori: —‍Yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ ijipihtiyequina angele mehna pʉhto ijigʉ tagʉ, yʉhʉ pʉhtoro dujiropʉ yʉhʉ asi siteye mehna dujigʉtja. ");
INSERT INTO pirNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Sa yʉhʉ dujigʉ̃, ahri yehpa cjẽna ijipihtiyequina yʉhʉ cahapʉ cahmecoaeta. Tiquina sa cahmecoari bato pʉa curua tu waʉtja tiquinare. Ovejare ihña ihboriquiro ovejare, cabra gʉ̃hʉre tiquiro tu wariro saha masare tu wa docoutja. ");
INSERT INTO pirNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Sa tu wagʉ oveja yero saha ijiyequinare quehnoañequinare yʉhʉ poto pehe bese docoutja. Sa yegʉ cabra yero saha ijiyequinare ñañequinare yʉhʉ cũ pehe pehepʉ bese docoutja. ");
INSERT INTO pirNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Yʉhʉ sa yeri bato yʉhʉ ijipihtiyequina pʉhto pehe yʉhʉ poto pehepʉ yʉhʉ bese docoriquinare ohõ saha ni yahutja: “Yʉhʉ Pacʉ mʉsare quehnoano yere. Ahri yehpare bajumehnenopʉ mʉsa ye ijiatire tiquiro pʉhtoro ijirore quehnoyu tuhasari Cohãcjʉ̃. Sa yena yojopʉre tiquiro quehnoriropʉre ijina ahtaya. ");
INSERT INTO pirNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Yʉhʉ ʉjʉa ahbagʉ̃ mʉsa pehe yʉhʉre ihyayere ohori. Yʉhʉ aco wʉogʉ̃ yʉhʉre mʉsa sihõri. Mʉsa cahapʉ yʉhʉ tinigʉ̃ yʉhʉre ihña masiedapenata yʉhʉre quehnoano piti cari mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Suhti mariegʉ yʉhʉ ijigʉ̃ ihñana mʉsa pehe yʉhʉre suhti sãari. Dohatigʉ yʉhʉ ijigʉ̃ mʉsa yʉhʉre ihñana ahtari. Peresupʉ yʉhʉ ijigʉ̃ gʉ̃hʉre yʉhʉre ihñana ahtari mʉsa”, niitja quehnoañequinare. ");
INSERT INTO pirNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Yʉhʉ sa nigʉ̃ tʉhoye tiquina yʉhʉre sinitueta: “¿Pʉhto, dʉhse ijigʉ̃ mʉhʉ ʉjʉa ahbagʉ̃ mʉhʉre ihyayere ohori ʉsã? ¿Dʉhse ijigʉ̃ mʉhʉ aco wʉogʉ̃ mʉhʉre sihõri ʉsã? ");
INSERT INTO pirNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Dʉhse ijigʉ̃ mʉhʉre ihña masiedapenata mʉhʉre quehnoano piti cari ʉsã? ¿Dʉhse ijigʉ̃ suhti mariegʉ mʉhʉ ijigʉ̃ mʉhʉre suhti sãari ʉsã? ");
INSERT INTO pirNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Dʉhse ijigʉ̃ mʉhʉ dohatigʉ̃ o peresupʉ mʉhʉ ijigʉ̃ gʉ̃hʉre mʉhʉre ihñana esari ʉsã?” nieta yʉhʉre. ");
INSERT INTO pirNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Tiquina sa ni sinitugʉ̃ tʉhogʉ yʉhʉ pʉhto tiquinare yahutja. “Ijirota mʉsare niita niaja. Ahriquina yeequina mehna cjʉ̃no ihyo ijiriquiro tiquiro ijiepegʉ̃ta, tiquirore mʉsa sata yeri. Sa ijiriquirore sa yena, yʉhʉre yero saha yena nidi mʉsa tiquinare”, ni yahutja. ");
INSERT INTO pirNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Quehnoañequinare yʉhʉ sa ni yahuri bato yʉhʉ cũ pehe pehepʉ ducuyequinare yʉhʉ ijipihtiyequina pʉhto ohõ saha ni yahutja: “Cohãcjʉ̃ tiquiro buhiri dahreatina ijire mʉsa. Yʉhʉ mehna tojoeracãhña. Pecapʉ wahaya mʉsa. Ti peca ne yatierare. Watĩno, tiquiro yequina angele gʉ̃hʉ tiquina ijiatire ti pecare yeri Cohãcjʉ̃. ");
INSERT INTO pirNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Yʉhʉ ʉjʉa ahbagʉ̃ mʉsa pehe yʉhʉre ihyayere ohoerari. Yʉhʉ aco wʉogʉ̃ mʉsa yʉhʉre sihõedari. ");
INSERT INTO pirNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Yʉhʉre masiedana mʉsa yʉhʉre piti caerari. Sa ihña cãri. Suhti mariegʉ yʉhʉ ijiepegʉ̃ta, yʉhʉre suhti sãaedari mʉsa. Dohatigʉ yʉhʉ ijigʉ̃ peresupʉ yʉhʉ ijigʉ̃ gʉ̃hʉre sa ihña cãri mʉsa yʉhʉre”, ni yahutja tiquinare ñañequinare. ");
INSERT INTO pirNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Yʉhʉ sa nigʉ̃ tʉhoye tiquina yʉhʉre sinitueta: “¿Pʉhto, mʉhʉ ʉjʉa ahbagʉ̃, mʉhʉ aco wʉogʉ̃, ʉsã masiedigʉ mʉhʉ ijigʉ̃, suhti mariegʉ mʉhʉ ijigʉ̃, dohatigʉ mʉhʉ ijigʉ̃, peresupʉ mʉhʉ ijigʉ̃ dʉhse ijigʉ̃ ʉsã pehe mʉhʉre yedohoerari?” ni sinitueta yʉhʉre. ");
INSERT INTO pirNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Tiquina sa ni sinitugʉ̃ yʉhʉ tiquinare ohõ saha ni yahutja: “Ijirota mʉsare niita niaja. Ahriquina yeequina mehna cjʉ̃no ihyo ijiriquirore mʉsa ne yedohoerari. Sa ijiriquirore mʉsa yedohoerana, yʉhʉreta sa yena nidi mʉsa”, ni yahutja tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Sa yero tiquinare sa buhiri dahreducurota Cohãcjʉ̃. Ti buhiri dahreye ne pihtisi. Sa ye, quehnoañequina pehe ijipihtiye decori quehnoano ijieta, ni yahuri Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ti ijipihtiyere tiquiro buheri bato Jesu ʉsãre tiquiro buhenare yahuri: ");
INSERT INTO pirNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—‍Pʉa deco bato pascua ijirota. Tire mʉsa masine. Ti pjere yʉhʉ masʉre Cohãcjʉ̃ ohorigʉre ñeheeta. Ñeheñe, yʉhʉre curusapʉ wejẽeta, nidi tiquiro ʉsãre. ");
INSERT INTO pirNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Sa ye pahia pʉhtoa, judio masa bʉcʉna gʉ̃hʉ cahmecoahye. Caifa pahia pʉhtoro ya wʉhʉpʉ cahmecoahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Topʉ cahmecoa, tiquina ni mehoñe mehna Jesure ñehe tiquina wejẽatire cahme yahuye niahye. ");
INSERT INTO pirNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","—‍Bose deco ijigʉ̃ tiquirore ñehedacʉ̃hna, “Masa usuari”, nina, niahye tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ti pjere Simo cami bʉcʉ mʉna wihiro ijimediquiro ya wʉhʉpʉ ijiri Jesu. Tiquiro ijiri maca Betania wame tiri maca ijiri. ");
INSERT INTO pirNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ti wʉhʉpʉ tiquiro ihyari watoa ihcãcoro numino ehme sitiyere ne cãhta, Jesu dapu bui pio peori. Ti ehme sitiye alabastro wame tiriapʉ pose tiri. Wapa bʉjʉye co ijiri. ");
INSERT INTO pirNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ticoro sa pio peogʉ̃ ihñana ʉsã Jesu buhena usuaʉ. —‍¿Dʉhsero ahricoro ahri core wapa bʉjʉyere sa ye siteajari? ");
INSERT INTO pirNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ti ehme sitiyere duaboaya. Sa duaro pajiro wapa ñeheboaya. Sa ñeheno ti niñerure pejecʉoyequinare ohoboaya ahricoro, nii ʉsã tiquiro buhena. ");
INSERT INTO pirNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ʉsã sa ni usuagʉ̃ ihñano, Jesu yahuri ʉsãre: —‍Sa niedacãhña ticorore. Yʉhʉre quehnoano yero nine. ");
INSERT INTO pirNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Pejecʉoyequina pehe mʉsa mehna sa ijiducueta. Sa yena tiquina pehere mʉsa oho masine. Yʉhʉ pehe ahri yehpapʉre mʉsa mehna sa ijiducusi. ");
INSERT INTO pirNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Yʉhʉre tiquina yato pano yʉhʉ pagʉre quehnoyuro, ticoro yʉhʉre pio peori. ");
INSERT INTO pirNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ijirota mʉsare niita niaja. Ijipihtiro ahri yehpapʉ quehnoañe buheyere tiquina yahuropʉ ahricoro yojopʉre ticoro yerire yahueta. Tiquina sa yahugʉ̃ tʉhoye ticorore masa peyequina wacũeta, ni yahuri Jesu ʉsãre. ");
INSERT INTO pirNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ti pjere ihcãquiro ʉsã mehna cjʉ̃no Juda Iscariote pahia pʉhtoa cahapʉ esahye. ");
INSERT INTO pirNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Esa, tiquinare sinituahye. —‍¿Jesure mʉsare yʉhʉ ihñogʉ̃ noho puno wapa yenatari mʉsa? ni sinituahye tiquinare. Tiquiro sa nigʉ̃ tiquina tiquirore treinta cjoeri plata cjoerire ohoahye. ");
INSERT INTO pirNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tiquina sa ohogʉ̃ Juda pehe Jesure tiquiro ihñoati ñamine cohtero niahye. ");
INSERT INTO pirNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Sa ye pugʉ̃ yeye moremehneñe pãre tiquina ihyati deco bose deco iji dʉcari deco ʉsã tiquiro buhena Jesu cahapʉ waha, sinituu tiquirore: —‍¿Noho boropʉ bose deco ijigʉ̃ mari ihyatire quehnoyu dutigʉ ohoutjari mʉhʉ ʉsãre? nii tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ʉsã sa nigʉ̃ tiquiro yʉhtiri: —‍Jerusalẽpʉ wahaya. Topʉ ijiriquirore ohõ saha ni yahuya: “Marine buheriquiro tiquiro ñano yʉhdʉati deco mehenogã dʉhsatjiãñohti. Pascua ijigʉ̃ mʉhʉ ya wʉhʉpʉ Jesu ʉsãre tiquiro buhenare siho ihyati ijiñohti”, ni yahuya ti wʉhʉ upʉrore, ni ohori Jesu ʉsãre. ");
INSERT INTO pirNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Sa yena ʉsãre tiquiro dutiriro sahata yena, pascua ijigʉ̃ ʉsã ihyatire quehnou ʉsã. ");
INSERT INTO pirNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Sa ye ti ñamine ʉsã mehna doce tiquiro buhena mehna ihyaro nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ʉsã ihyari watoa tiquiro ʉsãre yahuri: —‍Ijirota mʉsare niita niaja. Ihcãquiro mʉsa mehna cjʉ̃no yʉhʉre ihña tuhtiyequinare ihñonota yʉhʉre, ni yahuri tiquiro ʉsãre. ");
INSERT INTO pirNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Tiquiro sa nigʉ̃ tʉhona tutuaro bʉjʉa witina, tiquirore sinitu dʉcaʉ ʉsã ijipihtina: —‍¿Pʉhto, yʉhʉta ijiajari mʉhʉre ihñoacjʉ? ni sinituu. ");
INSERT INTO pirNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ʉsã sa ni sinitugʉ̃ tiquiro yʉhtiri: —‍Yʉhʉ ihyari papʉ yʉhʉ mehna soha ihyariquiro ijire yʉhʉre ihña tuhtiyequinare ihñoatiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Panopʉ yʉhʉre tiquina ojoariro sahata yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ yariagʉtja. Sa yero yʉhʉre ihña tuhtiyequinare ihñoatiquiro ñano yʉhdʉrota. Tiquiro pehe masa bajueraro quehnoa yʉhdʉaboaya. Ñano yʉhdʉeraboaya, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Tiquiro sa nigʉ̃ta tiquirore ihñoatiquiro Juda sinituri: —‍¿Buhegʉ, mʉhʉre ihñoacjʉ ijiajari yʉhʉ? ni sinituri tiquiro. Jesu yʉhtiri: —‍Ʉ̃hʉ. Mʉhʉta ijire, nidi. ");
INSERT INTO pirNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Sa ni yahu tuhasa ʉsã tiquiro buhena mehna ihyaro taro nidi. Sa yero Jesu pãre ne, Cohãcjʉ̃re “Quehnoare”, nidi. Sa ni tuhasa tire nuha, ʉsãre tiquiro buhenare itiri. —‍Ahrire ne, ihyaya. Ahri yʉhʉ pagʉ ijire, nidi tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Sa ni tuhasa tiquiro sihnidi pare ne, Cohãcjʉ̃re “Quehnoare”, ni, ʉsãre ohori. —‍Mʉsa ijipihtina ahrire sihniña. ");
INSERT INTO pirNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ahri yʉhʉ dii ijire. Peyequina masa tiquina ñañe yerire cohãgʉ̃ tagʉ yariʉtja. Sa yegʉ yʉhʉ diire cohãʉtja. Cohãcjʉ̃ “Mʉsare yʉhdʉoutja”, tiquiro nidiro esagʉ̃ yʉhʉ yariaro mehna tiquiro nidiro sohtori tirota. ");
INSERT INTO pirNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mʉsare niita niaja. Yʉhʉ Pacʉ tiquiro pʉhtoro ijiropʉ ʉhmʉsepʉ mʉsa mehna wahma core ʉhse core sihniitja. Mari sa sihniato pano ahri core sihni nemosi yʉhʉ, nidi Jesu ʉsãre. ");
INSERT INTO pirNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Sa yena Cohãcjʉ̃ yere basa tuhasana cʉnʉpʉ Olivo wame tidʉpʉ wahaʉ ʉsã. ");
INSERT INTO pirNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Topʉ ʉsã esagʉ̃ Jesu pehe ʉsãre yahuri: —‍Mia ñami yʉhʉre cohã cãnata mʉsa. Ohõ sahata nine Cohãcjʉ̃ tiquiro yere tiquina ojoari pũpʉ yʉhʉre yahuro: “Ovejare ihña ihboriquiro yero saha ijiriquirore yʉhʉ Cohãcjʉ̃ cohãgʉtja. Yʉhʉ sa cohãgʉ̃ tiquiro yequina oveja yero saha ijiyequina duhti site cãa wahaeta”, nine Cohãcjʉ̃ tiquiro yere tiquina ojoari pũpʉ. ");
INSERT INTO pirNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Sa yegʉ Cohãcjʉ̃ yʉhʉre tiquiro masori bato mʉsa pano Galileapʉ wahayutja yʉhʉ, nidi tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Tiquiro sa nigʉ̃ tʉhoro ohõ saha nimedi Pedro: —‍Yʉhʉ mehna cjẽna ijipihtiyequina mʉhʉre tiquina cohãepegʉ̃ta yʉhʉ pehe mʉhʉre ne cohãsi, nimedi Pedro tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesu yʉhtiri: —‍Ijirota niita niaja mʉhʉre. Mia ñami canaca tiquiro yahuato pano “Yʉhʉ Jesure masiedaga”, niita mʉhʉ. Ihtia taha sa niita mʉhʉ, nidi tiquiro Pedrore. ");
INSERT INTO pirNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Tiquiro sa niepegʉ̃ta Pedro ohõ saha ni yʉhtiri: —‍Mʉhʉ mehna yʉhʉre tiquina wejẽ duepegʉ̃ta “Jesure masiedaga”, ne nisi yʉhʉ, ni yʉhtimedi Pedro. Sa yena ʉsã gʉ̃hʉ apequina tiquiro buhena Pedro tiquiro nidiro sahata nimi ʉsã Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Sa ye Getsemaní wame tiri wesepʉ Jesu ʉsã tiquiro buhena mehna waha, topʉ esa, ʉsãre nidi: —‍Ohõ dujiyuya. Mʉsa ohõ dujiri watoa sohõ cjũnogãpʉ Cohãcjʉ̃re sinigʉ wahagʉ niaja, nidi tiquiro ʉsãre. ");
INSERT INTO pirNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Sa ni tuhasa, Pedrore, pʉaro Zebedeo pohnene tiquina ihtiarore piji cãri. Sa yero tiquiro tutuaro bʉjʉa witi, ñano jeripohna tiahye. ");
INSERT INTO pirNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Sa bʉjʉa witiro tiquiro mehna cjẽnare tiquiro piji cãriquinare ohõ saha niahye: —‍Tutuaro ñano jeripohna tiaja yʉhʉ. Yʉhʉre tutuaro purĩno saha tʉhotugʉ niaja. Sohõ cjũnogã wahagʉ niaja. Ohõpʉ tojoaya. Sa yena yʉhʉ mehnata carĩedacãhña mʉsa gʉ̃hʉ, niahye tiquiro tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Sa ni tuhasa mehenogã waha nemo, yehpapʉ quehe sa, Cohãcjʉ̃re niahye: —‍Mai, yʉhʉ ñano yʉhdʉatire ye dueragʉ yeracãhña. Yʉhʉ sa niepegʉ̃ta yʉhʉ cahmeno saha yeracãhña. Mʉhʉ pehe masine. Mʉhʉ cahmeno saha yeya yʉhʉre, ni siniahye tiquiro Cohãcjʉ̃re. ");
INSERT INTO pirNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Sa ni tuhasa, ihtiaro tiquiro buheyequina cahapʉ wihiro, carĩñequinare ihñahye. Tiquinare ihñano, Pedrore ohõ saha niahye: —‍¿Ihcã hora waro yʉhʉ mehna carĩegʉ iji masiedajari mʉhʉ? ");
INSERT INTO pirNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Quehnoano yeya mʉsa. Sa yena Cohãcjʉ̃re siniducuya mʉsa, “Ñano yeari”, nina. Mʉsa tʉhotuye mehna quehnoañene ye duamene mʉsa. Mʉsa sehsaro sa ye duepenata tire ye masiedare mʉsa, ni yahuahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Sa ni yahu tuhasa, pari turi waha, Cohãcjʉ̃re siniahye: —‍Mai, yʉhʉ ñano yʉhdʉatire ye duagʉ yeya yʉhʉre. Mʉhʉ cahmeno saha yeya, ni siniahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ni, tiquiro buheyequina ihtiaro buheyequina cahapʉ pari turi wihiahye tja. Sa wihiro carĩñequinareta ihñahye tja. Wʉjʉa purĩ yʉhdʉahye tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Sa yero tiquinare cũ cã, pari turi waha, Cohãcjʉ̃re siniahye. To pano tiquiro nidiro sahata niahye tja. ");
INSERT INTO pirNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Sa ni tuhasa tiquiro buheyequina cahapʉ wihi, tiquinare ohõ saha niahye: —‍¿Yojopʉ pũritare carĩnina niajari mʉsa? ¿Sorĩna niajari mʉsa? niahye tiquiro. Sa ni tuhasa, masa tiquina ahtagʉ̃ ihñano, ohõ saha niahye. —‍Tʉhoya. Mianogãta yʉhʉ masʉre Cohãcjʉ̃ ohorigʉre ñañequinare ohoeta yʉhʉre. ");
INSERT INTO pirNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Wahcãña. Isa wahana. Ihñaña. Yʉhʉre ihña tuhtiyequinare ihñoatiquiro ohõpʉ ahtare, niahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Tiquiro sa nino watoa ʉsã mehna cjʉ̃no ijimediquiro Juda pehe wihiri. Masa peyequina ahtari tiquiro mehna. Tiquina pahia pʉhtoa, judio masa bʉcʉna gʉ̃hʉ tiquina ohoriquina ijiri. Ñoseñe pjĩnine, yucʉ tiãri gʉ̃hʉre cʉori. ");
INSERT INTO pirNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Coã warore Jesure ihña tuhtiyequinare ihñoatiquiro masare ohõ saha ni yahuyu tuhasahye: —‍Yʉhʉ wahsupu ihmidiquirota ijirota mʉsa ñeheatiquiro. Tiquirore yʉhʉ ihmidi bato ñeheña tiquirore, niahye Juda tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Sa ye wihiro Jesu cahapʉ duita wahari. —‍¿Buhegʉ, ijiajari mʉhʉ? ni, tiquirore wahsupu ihmidi. ");
INSERT INTO pirNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Tiquiro sa ihmigʉ̃ Jesu ohõ saha nidi: —‍Yʉhʉ acayʉ, ohõpʉre mʉhʉ yei tʉʉ ahtarire yeya mʉhʉ, nidi tiquiro. Sa ye tiquina Jesure ñehedi. ");
INSERT INTO pirNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Tiquina sa yegʉ̃ ihñano Jesu mehna cjʉ̃no tiquiro ñoseni pjĩne tʉã we ne, pahia pʉhtoro cahacjʉ̃nore cahmonore dʉte pahrẽ cãri. ");
INSERT INTO pirNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Tiquiro sa yegʉ̃ ihñano Jesu tiquirore yahuri. —‍Mʉhʉ ñoseni pjĩne ihboya. Apequinare mʉhʉ ñosegʉ̃ tiquina ñose cahmegʉ̃ yariagʉta mʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Yʉhʉ Pacʉre yʉhʉre yʉhʉ yedoho dutigʉ̃ tiquiro pehe peyequina angelere doce cururire yʉhʉ cahapʉ ohoboaya tiquiro. ¿Tire masiedajari mʉhʉ? ");
INSERT INTO pirNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Sa yedohoboriquiro tiquiro ijiepegʉ̃ta tiquirore yʉhʉre yedoho dutisi yʉhʉ. Yʉhʉ sa dutieragʉ̃ Cohãcjʉ̃ yere tiquina ojoari pũ ti nidiro sahata sa waharota, nidi tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Sa ni tuhasa masare yahuri tiquiro: —‍¿Dʉhse ijiro boro mʉsa ñoseñe pjĩni mehna, yucʉ tiãri mehna yaque bʉcʉrore yero saha mʉsa yʉhʉre ñehena ahtajari? Decoripe Cohãcjʉ̃ wʉhʉpʉ mʉsare yʉhʉ buhe dujigʉ̃, mʉsa yʉhʉre ne ñehedari. ");
INSERT INTO pirNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Sa ijiepegʉ̃ta ahri ijipihtiye sa waharo nine Cohãcjʉ̃ yere yahu mʉhtariquina tiquina ni ojoariro sahata, nidi Jesu. Tiquirore tiquina sa ñehegʉ̃ ihñana ʉsã tiquiro buhena tiquirore cohã oma cãa wahaʉ ʉsã. ");
INSERT INTO pirNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Sa ye tiquirore ñehediquina pahia pʉhtoro Caifa wame tiriquiro ya wʉhʉpʉ ne sahye tiquirore. Ti wʉhʉpʉta marine judio masare buheyequina, bʉcʉna gʉ̃hʉ cahmecoahye. ");
INSERT INTO pirNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Topʉ Jesure tiquina neagʉ̃ Pedro yoaropʉ tiquinare ihña nʉnʉ tãhye. Sa nʉnʉ tãno Caifa ya wʉhʉre cahmotari sahrĩnore esa, ti sahrĩno puhiapʉ sajãa wahahye. Sajã sa, ti wʉhʉre cohteyequina surara mehna dujiahye. Jesure tiquina dʉhse yegʉ̃ ihñano taro niahye. ");
INSERT INTO pirNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Sa ye pahia pʉhtoa, apequina pʉhtoa mehna Jesure wejẽ duti duaye, ni mehoñe mehna tiquirore tiquina ñano buhiri dahreatire wacũ macamahye. ");
INSERT INTO pirNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Tiquina yahusãtire wacũ bocaerahye. Sa wacũ bocaerapeta peyequina masa tiquirore sa ni meho yahusã maca cãhye. Sa ye pʉaro tiquina bato wihiyequina tiquirore yahusãhye tja. ");
INSERT INTO pirNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","—‍Ahriquiro ohõ saha nidi: “Cohãcjʉ̃ wʉhʉre cohã masiaja. Sa cohãgʉ ihtia deco wahaboro ti wʉhʉre pari turi yeitja”, tiquiro nigʉ̃ tʉhou ʉsã, ni yahusã maca cãhye Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Tiquina sa nidi bato pahia pʉhtoro wahcãdʉca sa, Jesure sinituahye: —‍¿Ahriquina mʉhʉre tiquina yahusãepegʉ̃ta tiquinare yʉhti cahmedajari mʉhʉ? niahye pʉhtoro. ");
INSERT INTO pirNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Tiquiro sa nigʉ̃ tʉhoeperota Jesu sata tʉhotu cãhye. Tiquiro sa yʉhtieragʉ̃ ihñano pahia pʉhtoro pari turi sinituahye tja: —‍Cohãcjʉ̃ catiriquiro wame mehna poto niña mʉhʉ. Mʉhʉ sa niedagʉ̃ tiquiro mʉhʉre buhiri dahrerota. Yahuya ʉsãre. ¿Cristo Cohãcjʉ̃ macʉta ijiajari mʉhʉ? ni sinituahye tja. ");
INSERT INTO pirNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Tiquiro sa nigʉ̃pʉta Jesu yʉhtiahye: —‍Tiquirota ijiaja. Mʉsare poto yahugʉta niaja. Came yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ yʉhʉ Pacʉ tutuariquiro cahapʉ tiquiro poto pehepʉ yʉhʉ dujigʉ̃ ihñanata mʉsa. Sa yena ʉhmʉse cjẽ ehmeo cururi bui yʉhʉ ahtagʉ̃ gʉ̃hʉre ihñanata mʉsa, ni yʉhtiahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Tiquiro sa nigʉ̃ tʉhoro pahia pʉhtoro tiquiro sañari suhtirore tʉhrẽ cãhye apequinare “Usua yʉhdʉare”, ni ihña masi dutiro. —‍Cohãcjʉ̃re pajiro ñano yahuducuro nine ahriquiro. Sa ye tiquiro ñano yahuducuyere tʉho tuhasaja mari. Sa ye topequinata yahusãahdo ahriquirore. Ohõpʉta tiquiro ñano yahuducugʉ̃ tʉhoaja mari basita. ");
INSERT INTO pirNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Dʉhse yenatari mari yojopʉre ahriquirore? ni sinituahye tiquiro apequina pʉhtoare. —‍Tiquiro ñari buhiri wejẽ cãno cahmene tiquirore, ni yʉhtiahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tiquina sa nidi bato tiquiro wʉhdoare sihco puti ohõ, tiquirore quẽpeahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Tiquirore quẽpe tuhasa, ohõ saha niahye tiquirore: —‍¿Noa pehe mʉhʉre quẽajari? Cristo ijigʉ ihñedapegʉta yahuya ʉsãre, ni bʉjʉpeahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Sa ye ti wʉhʉ cahapʉ ijiri paapʉ quehnoari paapʉ Pedro pehe dujiahye. Tiquiro sa dujigʉ̃ ihñano pahia pʉhtoro cahacjõno tiquiro cahapʉ esaro, ohõ saha niahye: —‍Mʉhʉ gʉ̃hʉ Jesu Galilea cjʉ̃no mehna ijiri, niahye ticoro. ");
INSERT INTO pirNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ticoro sa nigʉ̃ tʉhoro, Pedro ohõ saha niahye: —‍¿Dʉhse ni maca cõo niajari mʉhʉ? Mʉhʉ nidiquirore ne masiedaga yʉhʉ, niahye Pedro ticorore ijipihtiyequina tiquina tʉhoropʉ. ");
INSERT INTO pirNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Tiquiro sa nidi bato ti paa cjã sahrĩno sopecaha cahapʉ wahahye Pedro. Topʉ tiquiro ijigʉ̃ apecoro cahacjõno tiquirore ihñano, topʉ ijiyequinare ohõ saha niahye: —‍Jesu Nazare cjʉ̃no mehna ijiri ahriquiro, niahye ticoro Pedrore tja. ");
INSERT INTO pirNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ticoro sa nigʉ̃ tʉhoro Pedro yʉhtiahye: —‍Cohãcjʉ̃ mehna poto nii niaja. Tiquiro mʉhʉ nidiquirore ne masiedaga yʉhʉ, ni yʉhtiahye Pedro. ");
INSERT INTO pirNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Sa ye came cjũno topʉ ducuyequina Pedro cahapʉ waha, tiquirore ohõ saha niahye tja: —‍Poto tjire. Jesu yequina mehna cjʉ̃ ijire mʉhʉ gʉ̃hʉ. Tiquina yero saha yahuducure mʉhʉ, niahye tiquina Pedrore. ");
INSERT INTO pirNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tiquina sa nigʉ̃ Pedro yʉhtiahye: —‍Poto Cohãcjʉ̃ mehna nii niaja mʉsare. Yʉhʉ poto yʉhʉ niedagʉ̃ Cohãcjʉ̃ yʉhʉre buhiri dahreahro. Tiquirore mʉsa nidiquirore ne masiedaga yʉhʉ, ni yʉhtiahye tiquiro tiquinare. Tiquiro sa nigʉ̃ta canaca yahuahye. ");
INSERT INTO pirNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Tiquiro yahugʉ̃ tʉhoro Jesu tiquirore nidire wacũahye. “Canaca tiquiro yahuato pano ‘Jesure masiedaga’, niita mʉhʉ. Ihtia taha waro sa niita mʉhʉ”, Jesu tiquirore nidire wacũahye Pedro. Sa wacũno, ti sahrĩnore wijia, tutuaro utiahye. ");
INSERT INTO pirNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Sa ye bohrea quehagʉ̃pʉ pahia pʉhtoa mari judio masa bʉcʉna gʉ̃hʉ Jesure tiquina wejẽ dutiatire cahme yahuducuahye. ");
INSERT INTO pirNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Tiquina sa yeri bato tiquirore dʉhte, Pilato cahapʉ nea, tiquirore ohoahye Pilatore. Pilato pehe ti yehpa cjẽna pʉhtoro ijiri. ");
INSERT INTO pirNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Sa yero Jesure tiquina wejẽ dutigʉ̃ ihñano Juda pehe Jesure ihñoriquiro tiquirore tiquiro ihñorire tutuaro wacũ bʉjʉa witiahye. Sa bʉjʉa witiro treinta cjoeri tiquiro ñehedi niñeru cjoerire wiaro waharo, pahia cahapʉ, bʉcʉna cahapʉ esa, ohõ saha niahye: ");
INSERT INTO pirNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","—‍Jesu mʉsare yʉhʉ ihñoriquiro ñañe marieniquiro tiquiro ijiepegʉ̃ta tiquina wejẽ dutiri tiquirore. Sa yegʉ mʉsare tiquirore ihñogʉ ñano yegʉ niaya yʉhʉ, ni yahuahye Juda tiquinare. Tiquiro sa ni yahuri bato tiquina yʉhtiahye: —‍Sata yecũnahdo. Ʉsãre dʉhseati ijierare ti mʉhʉ sa niñe. Mʉhʉ dihita sa ni tʉhoture tire, ni yʉhtiahye tiquina tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Tiquina sa ni yʉhtiri bato Cohãcjʉ̃ ya wʉhʉpʉ Juda tiquiro ye niñeru cjoerire doque site cũahye. Doque site cũ, wahaa wahahye. Waha, yuta dare dʉhte ohõ, tiquiro basi wamʉare tu suha, uhpu cjũ sa, yariaa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Sa ye pahia pʉhtoa niñeru cjoerire ne, ohõ saha niahye: —‍Ahri niñerure Cohãcjʉ̃ wʉhʉ cjã acaropʉ niñeru ihbori acaropʉ mari cũ masiedaja. Ahri niñeru mehnata masʉnore wejẽ dutiri. Sa ye mari ye dutiye marine sa ijiye niñerure ihbo dutierare, niahye tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Tiquina sa nidi bato “Ohõ saha yeihna”, tiquina ni yahuri bato dihi suturire yeriquiro ya yehpare dúahye. Ti cjoeri mehna dúahye. Ape sie cjẽna tiquina wihi tiquina yariagʉ̃ tiquina yati yehpa ijiatore ti yehpare dúahye. ");
INSERT INTO pirNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Sa ye ti yehpare “Dii yehpa”, wame yeri masa. Yojopʉ gʉ̃hʉre sata wame tire. ");
INSERT INTO pirNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ahri ijipihtiye sa wahahye Jeremia panopʉ “Sa waharota”, tiquiro ni ojoariro sahata. Tiquiro Cohãcjʉ̃ yere yahu mʉhtariquiro ijiahye. Ohõ saha ni ojoahye tiquiro: “Treinta niñeru cjoerire plata cjoerire ‘To punota wapa yenata tiquirore ʉsã ñeheatire’, nieta Israe masa. ");
INSERT INTO pirNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Sa ye ti cjoeri mehna dihi suturire yeriquiro ya yehpare dúeta tiquina. Ohõ sahata yʉhʉre ye dutiri Cohãcjʉ̃”, ni ojoahye Jeremia panopʉ. ");
INSERT INTO pirNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Sa ye Pilatore tiquina ohori bato tiquiro pehe Jesure sinituahye: —‍¿Potota judio masa pʉhtota ijiajari mʉhʉ? ni sinituahye Jesure. —‍Mʉhʉ nino sahata ijiaja, ni yʉhtiahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Sa ni yʉhtieperota, pahia pʉhtoa, bʉcʉna gʉ̃hʉ tiquina tiquirore yahusãgʉ̃ yʉhtierahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Tiquiro sa yʉhtieragʉ̃ ihñano Pilato sinituahye: —‍¿Ahri ijipihtiye mʉhʉre tiquina yahusãrire tʉhoerajari mʉhʉ? ni sinituahye tiquiro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Tiquiro sa ni sinituepegʉ̃ta Jesu ne mehenogã yʉhtierahye. Tiquiro sa yʉhtieragʉ̃ ihñano Pilato ne dʉhse ni masiedahye. ");
INSERT INTO pirNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Cʉhmaripe pascua ijigʉ̃ masa yaquiro ijiatiquirore ihcãquiro peresupʉ ijiriquirore Pilato sa wio basaducue tiahye. ");
INSERT INTO pirNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ti pjere Barrabá wame tiriquiro peresupʉ ijiahye. Tiquirore masiahye masa. ");
INSERT INTO pirNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Sa yero tiquina cahmecoagʉ̃ Pilato pehe sinituahye tiquinare: —‍¿Diquiro pehere mʉsare wio basaboagari yʉhʉ? ¿O Barrabá pehere o Jesure Cristo tiquina nidiquirore wio basaboagari yʉhʉ? ni sinituahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Jesure masa cahĩgʉ̃ ihñañe judio masa mari pʉhtoa tiquirore ihña tuhtiahye. Sa ihña tuhtiye tiquirore ohoahye Pilatore. Sa yero masa tiquina cahĩdi buhiri tiquina ihña tuhtirire masino Pilato Jesure wio duamahye. ");
INSERT INTO pirNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Sa ye Pilato masare ñañe yeyequinare tiquiro beseri pahtapʉ dujigʉ̃ tiquiro namono tiquirore quiti ohoahye: “Mia ñamine Jesure quehẽgo, tutuaro ñano yʉhdʉʉ. Sa yegʉ tiquirore ñañe marieniquirore ne sijoro saha yeracãhña mʉhʉ”, ni yahudoqueoahye tiquiro namono Pilatore. ");
INSERT INTO pirNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Sa ye coã waropʉre pahia pʉhtoa, bʉcʉna gʉ̃hʉ masare ohõ saha ni duti tuhasahye. “Barrabá pehere wio duti, Jesu pehere wejẽ dutiya”, ni dutiahye masare. ");
INSERT INTO pirNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Sa yero Pilato masare sinituahye: —‍¿Ahriquina pʉarore diquiro pehere mʉsare wio basaboagari yʉhʉ? ni sinituahye. —‍Barrabá pehere wio basaya ʉsãre, ni yʉhtiahye. ");
INSERT INTO pirNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","—‍¿Ahriquiro Jesu Cristo tiquina nidiquiro pehere dʉhse yeitari yʉhʉ, mʉsa sa ni sañuducugʉ̃? ni sinituahye tiquiro. —‍Curusapʉ quẽ biha wejẽña tiquirore, ni yʉhtiahye masa ijipihtiyequina. ");
INSERT INTO pirNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","—‍¿Yabe borore ñañene yeari ahriquiro, mʉsa sa nigʉ̃? niahye tiquiro. Tiquiro sa nigʉ̃ tʉhoye tiquina tutuaro mehna sañuducuahye: —‍Curusapʉ quẽ biha wejẽña tiquirore, ni sañuducuahye masa tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Tiquina sa ni sañuducugʉ̃ tʉhoro, tiquirore tiquina tʉho dueragʉ̃ ihñano “Masa usua, cahmequeboaga”, nino, yʉhtiro ohõ saha yeahye Pilato. Masa tiquina ihñonopʉ tiquiro omo coseahye. Sa omo cosero ohõ saha niahye. —‍Ahriquirore wejẽdi buhiri yee buhiri ijierare. Mʉsa ye buhiri ijire, nino omo coseahye. ");
INSERT INTO pirNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tiquiro sa nigʉ̃ tʉhoye ijipihtiyequina masa ohõ saha niahye. —‍Ahriquirore wejẽdi buhiri ʉsã, ʉsã pohna gʉ̃hʉ ʉsã ye buhiri ijiahro, niahye masa. ");
INSERT INTO pirNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Tiquina sa nigʉ̃ tʉhoro Pilato Barrabáre peresupʉ ijiriquirore wio dutiahye masa tiquina cahmeniquirore. Sa ye tuhasa Jesu pehere yuta dari mehna tana duti, tiquirore curusapʉ wejẽ dutiro ohoahye surarare. ");
INSERT INTO pirNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Tiquiro sa ohogʉ̃ Pilato ya wʉhʉpʉ tiquiro yequina surara Jesure neñe esahye. Sa ye tiquina surara ijipihtiyequina Jesu cahapʉ cahmecoahye. ");
INSERT INTO pirNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Sa ye tiquiro suhtire tu we ne, pʉhtoro ya suhtiro saha bajuri suhtirore tiquirore sãahye. ");
INSERT INTO pirNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Sa sãa tuhasa, pota behtore ye tuhasa, tiquiro dapu bui duhu peoahye. Sa duhu peo tuhasa, yucʉgʉre poto pehe dahra suhahye. Dahra suha tuhasa, dʉsepe curi mehna quehe sa, bʉjʉpeahye tiquirore. —‍Quehnoano ahtaya. Judio masa pʉhto, quehnoano ahtaya, ni bʉjʉpeahye tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Sa nieta tiquirore sihco puti ohõ, tiquina dahra suhadʉre tiquirore tʉã we ne, tiquiro dapure quẽahye tʉ mehnata. ");
INSERT INTO pirNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Tiquina sa bʉjʉperi bato tiquina sãari suhtirore tu we ne, tiquiro ye suhti pehere sãahye tja. Sãa tuhasa, curusapʉ wejẽñe tehe, tiquirore ne wijiahye. ");
INSERT INTO pirNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Tiquirore ne cã, Simo wame tiriquirore Cirene cjʉ̃nore piti ca, tiquirore Jesu wʉari curusare wʉa cã dutiri. ");
INSERT INTO pirNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Wʉa cã Gólgota wame tiropʉ esari. “Gólgota”, nino “Dapu pehtoro”, nino nine. ");
INSERT INTO pirNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Sa ye vinore sʉẽñe co mehna tiquina moreñe core Jesure ohomedi. Ti acore sihni tuhu, sihniedari tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Sa ye Jesu ye suhtire tiquina tu we nedi bato tiquirore curusapʉ quẽ bihari tiquina. Sa quẽ biha tuhasa, tiquiro ye suhtire “¿Noa yaro ijirotari ohõ?” ni, cahme doqueperi, ni ojoahye panopʉ. ");
INSERT INTO pirNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Doquepe tuhasa tiquirore ihña dujiducuri tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Tiquiro dapu bui curusapʉ ohõ saha ni ojoari pjĩne duhu ohõri tiquina tiquiro ñañe buhirire yahu duaye. “AHRIQUIRO JESU JUDIO MASA PɄHTORO IJIRE”, ni ojoari tiquina ti pjĩne. ");
INSERT INTO pirNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Came pʉaro yaque bʉcʉnare Jesu cahapʉ apeye curusaripʉ quẽ biha docori tiquina. Ihcãquiro tiquiro poto pehe, apequiro tiquiro cũ pehe pehe quẽ biha docori tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Curusari cahapʉ yʉhdʉ cãñequina Jesure ihña, tiquina dapu pacare yure, tiquirore ñano yahuducuri: ");
INSERT INTO pirNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—‍¿Cohãcjʉ̃ wʉhʉre cohã, ihtia deco wahaboro pari turi ti wʉhʉre dahreborigʉ ijiajari mʉhʉ? Cohãcjʉ̃ macʉ ijigʉ mʉhʉ basi dijia taya. Sa yegʉ mʉhʉ basi yedohoya, nidi masa. ");
INSERT INTO pirNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Sata ni bʉjʉperi tiquirore. Pahia pʉhtoa gʉ̃hʉ, marine judio masare buheyequina gʉ̃hʉ, bʉcʉna gʉ̃hʉ tiquirore sa ni bʉjʉperi. ");
INSERT INTO pirNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—‍Tiquiro apequinare yʉhdʉoriquiro ijiro tiquiro basi gʉ̃hʉ yʉhdʉoahro. “Israe masa pʉhto ijiaja”, nimene tiquiro. Sa yena tiquiro basi dijia tagʉ̃ ihñana tiquirore wacũ tutuanata. ");
INSERT INTO pirNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Tiquiro pehe Cohãcjʉ̃re wacũ tutuamene. Sa yero “Cohãcjʉ̃ macʉ ijiaja”, nimene tiquiro. Tiquiro sa ijigʉ̃ Cohãcjʉ̃ pehe tiquirore yedohoahro, ni bʉjʉperi tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Yaque bʉcʉna tiquiro cahapʉ tiquina quẽ bihanohriquina sata tiquirore bʉjʉpe, ñano yahuducuri tiquina gʉ̃hʉ. ");
INSERT INTO pirNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Sa ye coheri pje ijigʉ̃ ihtia hora waro ijipihtiropʉ nahitiano ijiri. ");
INSERT INTO pirNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Sa yero ti pjere nahitia yʉhdʉgʉ̃ waro Jesu tutuaro sañuducuri: —‍¿Elí, Elí lema sabactani? nidi tiquiro. Sa nino ohõ saha nino niahye: “¿Yʉhʉ Pacʉ, yʉhʉ Pacʉ, dʉhsegʉ yʉhʉre cohãjari mʉhʉ?” nino nidi. ");
INSERT INTO pirNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Tiquiro sa nigʉ̃ tʉhoye ihquẽquina topʉ ducuyequina ohõ saha nimedi: —‍Cohãcjʉ̃ yere yahu mʉhtariquirore Eliare pijioro niboaga, nimedi tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Sa yero ihcãquiro tiquina mehna cjʉ̃no oma cã, aco ihmini sʉhte mehna vino sʉẽñe core soha tuhasa, yucʉgʉ sohtoapʉ dʉhte ohõ, Jesu cahapʉ esa, tiquirore sihõmedi. ");
INSERT INTO pirNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Tiquiro sa yegʉ̃ ihñañe apequina sihõriquirore ohõ saha nidi: —‍Cohteniña. Elia ahriquirore tiquiro yʉhdʉogʉ̃ ihñaʉhna mari, nidi apequina. ");
INSERT INTO pirNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Tiquina sa nidi bato pari turi sañuducu, Jesu pehe yariaa wahari. ");
INSERT INTO pirNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Tiquiro yariagʉ̃ta Cohãcjʉ̃ wʉhʉ cjã suhtiro cahsero, topʉ tiquina cahmotari cahsero deco tʉhnʉ maa dijia, cjũ saa wahahye. Sa yero yehpa gʉ̃hʉ ñuhmidi. Sa ñuhmigʉ̃ ʉtã paca bʉjʉye paca wahtia wahari. ");
INSERT INTO pirNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Sa ye masa coperi parĩgʉ̃, peyequina Cohãcjʉ̃ yequina mʉna panopʉ yariariquina mʉna masa wijiahye. ");
INSERT INTO pirNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Masa wijia, Jesu masa wijiari bato ti coperire cohã cã, quehnoari macapʉ Jerusalẽpʉ wahari tiquina. Topʉ tiquina wahagʉ̃ peyequina masa ihñahye tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Sa ye ti ijipihtiyere ihñañe, yehpa ñuhmigʉ̃ ihñañe, surara pʉhtoro tiquiro yequina surara mehna ihña maria wahari. Tiquina Jesure curusapʉ ijiriquirore cohteyequina ijiri. Ihña maria waha, ohõ saha nidi: —‍Ijirota ijire. Ahriquiro Cohãcjʉ̃ macʉnota ijimeya, nidi tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Sa ye Galileapʉ Jesu mehna ahtariquina numia tiquirore yedohoriquina numia yoaropʉ tiquirore curusapʉ ijiriquirore ihñaducuye nidi. ");
INSERT INTO pirNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Tiquina numia mehna María Magdalena ijiri. Apecoro María wame tiricoro gʉ̃hʉ ijiri. Ticoro pehe Santiago, José gʉ̃hʉ pacoro ijiri. Apecoro Zebedeo namono ijiri. ");
INSERT INTO pirNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Sa ye ñamicahapʉ José Arimatea cjʉ̃no doeri cjẽ upʉro topʉ wihiahye. Tiquiro Jesu buheriquiro ijiri. ");
INSERT INTO pirNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Wihi, Pilato cahapʉ esa, Jesu pagʉre siniahye. Tiquiro sa sinigʉ̃ tʉhoro Jesu pagʉre tiquirore oho dutiahye Pilato. ");
INSERT INTO pirNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Tiquiro sa dutiri bato José pehe tiquiro pagʉre ne dijio, quehnoari suhtiro wete marieni suhtiro mehna tiquiro pagʉre wahmeahye. ");
INSERT INTO pirNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Wahme tuhasa, José tiquiro ya masa copepʉ cũahye Jesu pagʉre. Ti cope tiquina ʉtãpʉ seheri cope wahma cope ijiri. Ti copepʉ ne sajã duhu cũ tuhasa, pajiria ʉtãre tu torẽ cãhye tia mehna biharo taro. Biha tuhasa, wahaa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Sa ye María Magdalena, apecoro María mehna ti copere ihña dujiducuahye. ");
INSERT INTO pirNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Sa ye ape deco, pascua ijiatire tiquina quehnori deco bato, saurú ijigʉ̃ pahia pʉhtoa, fariseo masa gʉ̃hʉ Pilato cahapʉ cahmecoahye. ");
INSERT INTO pirNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Cahmecoa tuhasa ohõ saha niahye tiquina Pilatore: —‍Pʉhto, tiquiro ni mehoriquiro Jesu catiro ohõ saha niahye: “Ihtia deco wahaboro masa wijiagʉtja yʉhʉ”, niahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Tiquiro sa nidiquiro ijigʉ̃ tiquiro buheyequina pehe tiquiro pagʉre yaqueboaga. Sa yaqueye masare ohõ saha niboaga: “Jesu masa wijiari”, niboaga tiquina. Tiquiro Jesu pehe masare ni mehono nidi. Sa ijiepegʉ̃ta tiquiro buheyequina pehe “Tiquiro masa wijiari”, niñe, ni mehoñe nieta. Sa yero Jesu tiquiro ni mehoriro yʉhdʉoro tiquina ye ni mehoñe pehe ña yʉhdʉarota. “Sa yaqueari”, nigʉ ihtia deco waro tiquiro masa copere mʉhʉ yequina surarare cohte dutiya, niahye tiquina Pilatore. ");
INSERT INTO pirNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato yʉhtiahye: —‍Aʉ. Ti copere cohteahro. Sa yena mʉsa gʉ̃hʉ mʉsa ye masino puno ti copere quehnoano cohteya, niahye tiquiro tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Tiquiro sa nigʉ̃ tiquina waha, ti copere biharia ʉtã mehnapʉta ñehogʉ̃pʉta wihtã ñeheahye masa tiquina sajãgʉ̃ ihña masiñe tehe. Sa ye surarare ti copere cohte dutiahye. ");
INSERT INTO pirNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sa ye judio masa mari sori deco saurú pehe yʉhdʉgʉ̃ domingo ijigʉ̃ ñami cjũnogã ijigʉ̃ María Magdalena apecoro María mehna Jesu masa copere ihñañe wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Sa yero duita yehpa tutuaro ñuhmiahye. Sa ñuhmigʉ̃ mari pʉhtoro tiquiro yaquiro angel ʉhmʉsepʉ ijiriquiro dijia ta, masa copere biharia ʉtãre tu torẽ cã, tia bui dujiahye. ");
INSERT INTO pirNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ʉpo miadoqueoro yero saha quehnoano asi siteahye tiquiro. Sa ye tiquiro suhti ehmeo curua yero saha quehnoano yehseye suhti ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Tiquiro sa bajuagʉ̃ ti copere cohteyequina surara cue yʉhdʉye, nanare yʉhdʉa waha, buigã warona yaria yʉhdʉa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Sa yero angel pehe tiquina numiare ohõ saha niahye: —‍Yʉhʉre cueracãhña. Curusapʉ tiquina quẽ bihariquiro, Jesure mʉsa macagʉ̃ masiaja yʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Tiquiro yojopʉre ohõre mariedare. Tiquiro nidiro sahata masa wijiaa wahari. Tiquiro pagʉre tiquina cũrirore ihñana ahtaya. ");
INSERT INTO pirNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Sa yena tiquiro buheyequina cahapʉ ʉmʉñano waha, ohõ saha ni yahuna wahaya: “Jesu masa wijiari. Sa yero mʉsa pano Galileapʉ tiquiro wahayurota. Topʉ tiquirore ihñanata mʉsa”, ni yahuna wahaya mʉsa. Ahrita ijire mʉsare yʉhʉ yahuri quiti, niahye angel tiquina numiare. ");
INSERT INTO pirNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Tiquiro sa nidi bato tiquina numia masa copepʉ ijiye numia sojaro mehna wijia, tiquirore cuepeta bucue yʉhdʉye mehna Jesu buheyequinare yahuye oma cãa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Sa wahayequina numiare Jesu piti ca, ohõ saha niahye: —‍¿Quehnoano ijiajari mʉsa? niahye tiquiro. Tiquiro sa nidi bato, tiquina pehe tiquiro cahapʉ esa, dahpocãrine ñehe, tiquirore ño peoahye. ");
INSERT INTO pirNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","—‍Cueracãhña mʉsa. Yʉhʉ bahanare “Galileapʉ wahaya”, ni yahuna wahaya. Topʉ yʉhʉre ihñaeta tiquina, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Tiquiro sa nidi bato numia wahari watoa ihquẽquina masa copere cohteriquina mehna cjẽna surara, Jerusalẽpʉ pahia pʉhtoare ijipihtiyere yahu pehoye wahahye. Jesu tiquiro masa copepʉ wijiarire yahu peho cãhye. ");
INSERT INTO pirNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Tiquina sa ni yahugʉ̃ pahia pʉhtoa, judio masa mari bʉcʉna mehna cahmecoahye. Cahmecoa, yahuducuahye. Sa yeye surarare ni meho dutiye niñerure wapa yeahye. ");
INSERT INTO pirNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","—‍Ohõ saha niña mʉsa masare: “Ñami ʉsã carĩdi bato tiquiro buheyequina pehe masa copepʉ wihi, tiquiro pagʉre ne cãri jiri”, ni yahuya masare. ");
INSERT INTO pirNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Mʉsa sa ni yahugʉ̃ Pilato pehe mʉsa carĩ yʉhdʉarire tʉhoboaga. Tiquiro sa tʉhogʉ̃, “Mʉsare tuhtiari”, nina, mʉsare yahu basanata ʉsã tiquirore, niahye tiquina surarare. ");
INSERT INTO pirNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Tiquina sa nidi bato surara pehe niñerure ñehe, tiquinare tiquina ni meho dutiriro sahata masare yahuye wahahye. Sa ye tiquina ni mehoriro sahata Jesu tiquiro masa copere wijiarire yahuducuri judio masa. Yojopʉ gʉ̃hʉre sata nine tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Sa ye ʉsã Jesu buhena once buhena cʉnʉpʉ Galileapʉ ijidʉpʉ Jesu tiquiro waha dutidʉpʉ wahaʉ ʉsã. ");
INSERT INTO pirNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Topʉ esa, Jesure ihñana, ño peou ʉsã tiquirore. Sa ño peoepenata, ʉsã ihquẽquina “Ahriquiro Cohãcjʉ̃ macʉno ijieraboaga”, ni tʉhotumi. ");
INSERT INTO pirNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ʉsã sa ño peogʉ̃ tiquiro pehe ʉsã cahapʉ wihi, ohõ saha nidi: —‍Ahri yehpapʉre, ʉhmʉsepʉ gʉ̃hʉre Cohãcjʉ̃ ijipihtiyequina bui tutuayere ohori yʉhʉre. ");
INSERT INTO pirNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Tiquiro sa ohogʉ̃ ohõ saha dutiaja mʉsare: Ijipihtiro cjẽnare yeere buhena wahaya. Yeequina tiquina wahatire buhena wahaya. Sa yena mari Pacʉ wame mehna, yʉhʉ wame mehna, Espíritu Santo wame mehna tiquinare wame yeya. ");
INSERT INTO pirNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Sa yena mʉsare yʉhʉ dutirire tiquina ye pehoatire buheya tiquinare mʉsa. Sa yena ahrire yʉhʉ niatire wacũña: Ijipihtiye decori ahri yehpa ijiro puno mʉsa mehna sa ijiducugʉtja. Mʉsa mehna yʉhʉ sa ijiducuatire wacũña mʉsa, ni yahuri ʉsãre Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ahri pũpʉ Jesucristo Cohãcjʉ̃ macʉno tiquiro yerire quehnoañe buheyere yahu dʉcaja. ");
INSERT INTO pirNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Cohãcjʉ̃ yere yahu mʉhtariquiro mʉnano Isaia tiquiro ojoariro sahata yahuye ijire. Ohõ saha ni ojoahye tiquiro: Cohãcjʉ̃ tiquiro macʉnore ohõ saha niahye: “Mʉhʉ pano mʉhʉre yahuyuatiquirore ohoyugʉ niaja. ");
INSERT INTO pirNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Sa yero tiquiro masa marienopʉ waharota. Tiquirore tʉhoyequinare yahuro sañuducurota: ‘Mari pʉhtoro tiquiro ahtato pano mahare mari quehnoyuro saha quehnoana ijiyuya mʉsa. Mʉsa ñañe yerire bʉjʉa witiya,’ ni sañuducurota,” niahye Cohãcjʉ̃, ni ojoahye Isaia. ");
INSERT INTO pirNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ñu wame yeriquiro masa marienopʉ buhee tiahye. —‍Mʉsa ñañe yerire bʉjʉa witiya. Yojopʉre quehnoañe pehere camesaya. Sa yena wame yenohrina ijiya. Mʉsa sa camesagʉ̃ ihñano Cohãcjʉ̃ mʉsa ñañe yerire borota, ni buhee tiahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Sa yero ijipihtiyequina Judea dihta cjẽ macari cjẽna Jerusalẽ cjẽna mehna tiquiro cahapʉ esagʉ̃ ihñaño Ñu pehe Jordã wame tiri mapʉ wame yeahye tiquinare. Tiquinare tiquiro wame yegʉ̃ tiquina pehe tiquina ñañe yerire yahu yʉhdʉahye Cohãcjʉ̃re. ");
INSERT INTO pirNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Sa yero Ñu camello poari suhtirore sañariquiro wahiquina cahsero mehna tʉã dihoriquiro ijiahye. Poreroare, umiquina nʉcʉ cjẽna umine ihyae tiahye. ");
INSERT INTO pirNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Sa yero ohõ saha ni buhee tiahye. —‍Yʉhʉ bato yʉhʉ yʉhdʉoro tutuariquiro ahtarota. Quehnoa yʉhdʉariquiro ijire tiquiro. Tiquiro yero saha ijieraja yʉhʉ pehe. Sa yegʉ tiquirore tʉhotugʉ, “Ihyo ijigʉ ijiaja yʉhʉ”, ni tʉhotuaja yʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mʉsare wame yegʉ aco mehna wame yei. Tiquiro pehe yʉhʉ yʉhdʉoro yerota. Espíritu Santore masa mehna ijiducugʉ̃ yerota, ni buhee tiahye Ñu. ");
INSERT INTO pirNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Sa ye ti pjere Jesu Nazarepʉ Galilea yehpapʉ ijiri macapʉ ijiriquiro Jordã wame tiri mapʉ esahye. Topʉ tiquiro esagʉ̃ Ñu wame yeahye tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Tiquiro wame ye tuhasagʉ̃ Jesu diapʉ ijiriquiro maja sadʉca ʉhmʉanopʉ ihña mʉoahye. Ʉhmʉse parĩ maa wahahye. To parĩ maagʉ̃ta Espíritu bujua yero saha Jesu bui dijia tahye. ");
INSERT INTO pirNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Sa yero ʉhmʉsepʉ yahuducuro ca tahye: —‍Mʉhʉ yʉhʉ macʉ yʉhʉ cahĩgʉ ijire. Mʉhʉ mehna tutuaro bucueaja, nino ca tahye ʉhmʉsepʉ. ");
INSERT INTO pirNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ti pjere Jesure masa marienopʉ Espíritu Santo neahye. ");
INSERT INTO pirNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Topʉre esaro cuarenta decori waro ijiahye. Watĩno pehe Jesu tiquiro ñañene yegʉ̃ ihña duaro ñañene ye dutimahye tiquirore. Sa yero Jesu wahiquina nʉcʉ cjẽna mehna ijiahye. Topʉ tiquiro ijigʉ̃ ihñañe angele pehe tiquirore yedohoahye. ");
INSERT INTO pirNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Sa ye Ñure peresupʉ tiquina biha dapori bato Jesu pehe Galilea yehpapʉ quehnoañe buheyere Cohãcjʉ̃ pʉhtoro ijiyere yahuro wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ohõ saha ni yahuahye: —‍Yojopʉre ohõ saha ijire. Cohãcjʉ̃ tiquiro pʉhtoro ijiato mehenogã dʉhsare. Mʉsa ñañe yerire bʉjʉa witiya. Sa yena quehnoañene camesaya. Quehnoañe buheyere tʉhoya mʉsa, ni buhee tiahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Tire yahu tuhasaro Galilea wame tiri ditara dʉhtʉ cahapʉ esaro, ihñahye Simore, tiquiro bahʉro Andre mehna. Tiquina wahi yohyeyequina ijiahye. Sa ye tiquina wẽñecjʉre doque ñoñe niahye ti ditarapʉ. ");
INSERT INTO pirNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","—‍Yʉhʉ mehna cjãna ijiana ahtaya mʉsa. Yʉhʉ mehna mʉsa ahtagʉ̃ mʉsa wahire ñehe cahmecoana mʉsa ijiro saha Cohãcjʉ̃ yequina ijiatiquinare masare piji cahmecoana ijigʉ̃ yeitja mʉsare. Yʉhʉ mehna mʉsa ahtagʉ̃ sa yeanajare cũtja mʉsare, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Tiquiro sa nigʉ̃ tʉhoye tiquina wẽñecjʉre cũ cã, tiquiro mehna wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Sa ye tiquina mehenogã yʉhdʉ cã, Santiagore, tiquiro bahʉro Ñu gʉ̃hʉre boca sahye tja. Tiquina pehe Zebedeo pohne ijiahye. Tiquina yaria yucʉsapʉ wẽñecjʉre quehnoñe niahye. ");
INSERT INTO pirNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Sa yero tiquiro pijiogʉ̃ tiquina pehe tiquina pacʉrore, tiquirore yedohoyequina mehna yucʉsapʉ cũ cã, Jesu mehna wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Sa ye tiquina Capernau wame tiri macapʉ esahye. Sa yero saurú ijigʉ̃ judio masa buheri wʉhʉpʉ buhero esahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Sa yero tiquiro quehnoano masi pehoriquiro buhero ʉsã judio masare buheyequina yero saha ijierahye tiquiro. Tiquiro sa buhegʉ̃ ti maca cjẽna tʉho maria wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ti pjere ti wʉhʉpʉ ijiriquiro watĩare cʉoriquiro ijiahye. Sa yero ohõ saha niahye Jesure: ");
INSERT INTO pirNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—‍Mʉhʉ Jesu Nazare cjʉ̃ cariboeracãhña ʉsãre. ¿Dʉhse yei tʉʉ niajari ʉsãre? ¿Mʉhʉ ʉsãre butigʉ̃ yei tʉʉ niajari? Cohãcjʉ̃ macʉ quehnoagʉ mʉhʉ ijigʉ̃ yʉhʉ masiaja, ni sañuducuahye tiquiro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Tiquiro sa nigʉ̃ tʉhoro Jesu tuhtiahye watĩare: —‍Dihta mariahña. Duhuya tiquirore, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Sa yeye watĩa tiquirore yehpapʉ doque quehe sa tunugʉ̃ yeye, tiquiro tutuaro sañuducuri watoa duhuahye tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Sa ye ijipihtiyequina ti wʉhʉpʉ dujiyequina acʉa yʉhdʉa waha, ohõ saha niahye: —‍Ahyou. ¿Ahri wahma buheye ijiajari? Tiquiro pʉhtoro yero saha dutire watĩare. Tiquiro dutigʉ̃ tiquina watĩa pehe yʉhdʉdʉcaerare tiquirore, ni yahuducuahye ti wʉhʉpʉ dujiyequina tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Sa ye meheñe decori batota duita ijipihtiyequina Galilea yehpa cjẽna tire tiquiro sa yerire tʉhoahye. ");
INSERT INTO pirNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Sa ye Jesu gʉ̃hʉ judio masa buheri wʉhʉpʉ ijiriquina wijiaa wahahye. Tiquina sa wijiari bato Jesu, Santiago, Ñu, apequina tiquina mehna cjẽna gʉ̃hʉre, Simo, tiquiro bahʉro Andre mehna tiquina ya wʉhʉpʉ siho sajã sahye. ");
INSERT INTO pirNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ti pjere Simo mareono ujuaye dohatiricoro cuñano bui ticoro cuñagʉ̃ ihñañe yahuahye Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Tiquina sa ni yahugʉ̃ tʉhoro tiquiro pehe ticoro cahapʉ esaro, ticoro omocare ñehe, ticorore weje wahcõ dapoahye. Tiquiro sa weje wahcõ dapogʉ̃ta ticorore ujuaye surua wahahye. Ti sa sururi bato ticorota ihyayere peoahye. ");
INSERT INTO pirNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ñamicahapʉ asʉ̃ sajãri bato masa peyequina dohatiyequinare, watĩa cʉoyequinare Jesu cahapʉ ne sahye. ");
INSERT INTO pirNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Sa ye ijipihtiyequina ti maca cjẽna cahmecoa dʉca sahye ti wʉhʉ sopecahapʉ. ");
INSERT INTO pirNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Sa yero Jesu peyequina dohatiyequinare, peyequina watĩa cʉoyequinare quehnoa wahagʉ̃ yeahye. Peyequina watĩare cohãhye. Sa yero Jesure watĩa tiquirore masigʉ̃ ihñano Jesu pehe tiquinare yahuducu dutierahye. ");
INSERT INTO pirNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Sa ye ñami cjũno wahcã, nahitia cjũgʉ̃ masa marienopʉ Cohãcjʉ̃re sinino wahahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Tiquiro sa wahagʉ̃ ihñañe Simo gʉ̃hʉ tiquirore macañe esahye. ");
INSERT INTO pirNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Sa ye tiquirore piti caye, ohõ saha niahye: —‍Masa ijipihtiyequina mʉhʉre macañe nidi, niahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Tiquina sa nigʉ̃ tʉhoro ohõ saha niahye Jesu: —‍Ahri macarine buhegʉ ahtaʉ yʉhʉ. Sa yena apeye macari ohõ cahagã cjẽ macaripʉ wahaʉhna mari. Yʉhʉ ti macari gʉ̃hʉre buheitja, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Sa yero ijipihtiye Galilea yehpare buhe tiniahye. Sa yero macaripe judio masa buheye wʉhʉsepʉ buhero, watĩare masa mehna ijiyequinare cohã wioahye. ");
INSERT INTO pirNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Sa ye apequiro dohatiriquiro cami bʉcʉ mʉna wihiro Jesure piti caro dʉsepe curi mehna quehe sa siniahye: —‍Mʉhʉ yʉhʉre yʉhdʉo duagʉ yʉhdʉoya, niahye cami bʉcʉ mʉna wihiro. ");
INSERT INTO pirNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Tiquiro sa nigʉ̃ tʉhoro Jesu tiquirore paja ihñahye. Sa yero tiquiro omocare siõdoqueo tiquirore ña peoahye. Sa ña peoro ohõ saha niahye: —‍Tire ye duaja. Quehnoagʉ ijiya mʉhʉ, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Tiquiro sa nigʉ̃ta tiquiro cami ahbari yati maa wahahye. Quehnoa wahahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Tiquiro sa wahagʉ̃ ihñano Jesu tiquirore tutuaro mehna yahuahye: ");
INSERT INTO pirNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—‍Apequinare ahrire yahu siteracãhña. Sa yahuerapegʉta mʉhʉ pagʉre pahire ihñoña. Cohãcjʉ̃ dutiye Moisere tiquiro cũriro sahata yeya. Sa yegʉ minicjʉare ohoya pahire mʉhʉ quehnoagʉ mʉhʉ waharire masare mʉhʉ ihñoatire, niahye Jesu. Sa ni tuhasa “Wahaya”, niahye tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Tiquiro sa yahu dutierapegʉ̃ta tiquiro waha, ijipihtiye macari cjẽnare Jesu yerire yahuahye. Tiquiro sa yahuri bato Jesu masa peyequina ijiropʉre waha masiedahye. Sa yero tiquiro meheñequinagã ijiropʉ ijiahye. Topʉ tiquiro ijigʉ̃ peye macari cjẽna tiquiro cahapʉ esahye. ");
INSERT INTO pirNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Meheñe decori bato Jesu Capernaupʉ tojoa wahahye. Wʉhʉpʉ tiquiro ijigʉ̃ masa tʉhoahye. ");
INSERT INTO pirNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Sa ye topʉ masa peyequina cahmecoa, ti wʉhʉre wahpa wijiadʉca saa wahahye. Sa yero Jesu tiquinare quehnoañe buheyere yahuahye. ");
INSERT INTO pirNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Sa ye apequina gʉ̃hʉ ahta, pititiaro ʉmʉa tini masieniquirore ne wihiahye. ");
INSERT INTO pirNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Tiquina masa peyequina ijigʉ̃ ihñañe Jesu cahapʉ sajã masiedahye. Sa ye tiquina wʉhʉ buipʉ muji pahmare ne wedoqueo, Jesu bui waro meheni copegã dahre, tini masieniquirore tiquiro cuñari cahsero mehna duhu dijioahye Jesu caha waro. “Jesu ahriquirore tiquiro dohatiyere yʉhdʉgʉ̃ yerota”, ni tʉhotuahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Tiquina sa ni tʉhotugʉ̃ masino Jesu pehe dohatiriquirore ohõ saha ni yahuahye: —‍Yʉhʉ macʉ, mʉhʉ ñañe yerire cohã tuhasaʉ, niahye Jesu tini masieniquirore. ");
INSERT INTO pirNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Tiquiro sa nigʉ̃ tʉhoye, ʉsã acaye judio masare buheyequina topʉre dujiyequina tiquina basi ohõ saha ni tʉhotumahye: ");
INSERT INTO pirNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ahriquiro sa ni yahuducueracãhdo. Cohãcjʉ̃re ñano yahuducuro nine tiquiro. Masʉno mari yero saha ijiriquiro ijire tiquiro gʉ̃hʉ. Sa yero tiquiro ahriquiro ñañe yerire cohã masiedare. Cohãcjʉ̃ dihita masa tiquina ñañe yerire cohã masine”, ni tʉhotumahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Tiquina sa ni tʉhotugʉ̃ ihñano Jesu tiquina tʉhotuyere masino ohõ saha niahye: —‍¿Dʉhse yena mʉsa sa ni tʉhotuajari? ");
INSERT INTO pirNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","“Mʉhʉ ñañe yerire cohã tuhasaja”, yʉhʉ nigʉ̃, “Ni mehogʉ ijire”, yʉhʉre nina nine mʉsa masiedapenata. Tiquiro tini masieniquirore “Wahcãdʉca, wahaya”, yʉhʉ nigʉ̃, tiquiro tinigʉ̃ ihñana yʉhʉ nidi potota ijigʉ̃ duita masinata mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ ahri yehpapʉre masa tiquina ñañe yerire cohã masiaja yʉhʉ. Yʉhʉ sa cohãrire mʉsa masiato saha ohõ saha tiquiro wahagʉ̃ yeitja, niahye Jesu judio masare buheyequinare. Sa ni tuhasa tini masieniquirore ohõ saha niahye: ");
INSERT INTO pirNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—‍Mʉhʉre niita niaja. Wahcãdʉcaya. Mʉhʉ cuñari cahserore ne cãhña mʉhʉ ya wʉhʉpʉ, niahye Jesu tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Tiquiro sa nigʉ̃ta tini masieniquiro wahcãdʉca sa, tiquiro cuñari cahserore ne, ijipihtiyequina tiquina ihñono wijiaa wahahye. Tiquiro sa yegʉ̃ ihñañe tiquina ijipihtiyequina ihña acʉaa wahahye. “Cohãcjʉ̃ tutuariquiro ijire. Ne mari ohõ saha yegʉ̃re ihñeda tii”, niahye tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Sa ye pari turi Jesu ditara dʉhtʉ cahapʉ wahahye. Sa yero masa peyequina tiquiro cahapʉ tiquina cahmecoagʉ̃ ihñano tiquiro buheahye tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Sa ye tuhasa topʉ ijiriquiro waharo Levíre Alfeo macʉnore tiquiro dahrari tucũpʉ boca sahye. Apequina mehna pʉhtoa ye ijiatire wapa ne cohteyequina ijiahye Leví gʉ̃hʉ. Tiquirore boca saro ohõ saha niahye: —‍Yʉhʉ mehna cjʉ̃ ijiacjʉ ahtaya mʉhʉ, niahye Jesu Levíre. Tiquiro sa nigʉ̃ Leví pehe wahcãdʉca sa, Jesu mehna wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jesu mehna wahayequina peyequina ijiahye. Sa yero Leví ya wʉhʉpʉ mesa cahapʉ peyequina wapa ne cohteyequina mehna, “Ñano yeyequina”, tiquina niñequina mehna tiquiro buheyequina mehna dujiahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Topʉ tiquina dujiri bato apequina ʉsã judio masare buheyequina, fariseo masa mehna Jesu tiquiro ihyagʉ̃ ihñahye tiquina. Sa ihñañe ohõ saha niahye: —‍¿Dʉhsero ñano yeyequina, wapa ne cohteyequina mehna ihyajari Jesu? ni sinituahye judio masare buheyequina Jesu buheyequinare. ");
INSERT INTO pirNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Tiquina sa nigʉ̃ tʉhoro queoye mehna yʉhtiahye Jesu: —‍Dohatieyequina duturure macaedare. Dohatiyequina dihita duturure macare. Ñañequina dohatiyequina yero saha ijire. Sa yegʉ ñañequina dihitare tiquina ñañe yerire bʉjʉa witi duti, quehnoañe pehere tiquinare camesagʉ̃ yegʉ tagʉ nii yʉhʉ. Tiquina basi “Quehnoana ijiaja ʉsã”, ni tʉhotuyequinare yedohogʉ tagʉ niedʉ yʉhʉ, niahye tiquiro tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ti pjere Ñu buheyequina, fariseo masa gʉ̃hʉ Cohãcjʉ̃re ño peoye tehe, sijie tiahye. Sa ye masa Jesure sinituahye: —‍Ñu buheyequina, fariseo masa buheyequina gʉ̃hʉ Cohãcjʉ̃re ño peoye tehe sijire. ¿Dʉhse ye mʉhʉ buheyequina sijierajari? niahye tiquina Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesu tiquiro tʉhotuye mehna queoye mehna buhero tiquinare ohõ saha ni yʉhtiahye: —‍Ohõ saha ijire ti: Omoca dʉhteriquiro bose deco ijigʉ̃ tiquiro mehna cjẽna bʉjʉa witiro mehna ijierare. Sa ye sijiyequina ijierare. Sata yʉhʉ buheyequina gʉ̃hʉ yʉhʉ mehna ijiye, siji masiedare. ");
INSERT INTO pirNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Yʉhʉ Pacʉ Cohãcjʉ̃ yʉhʉre tiquiro neari bato pũritare pari turi yʉhʉ buheyequina mehna ijisi yʉhʉ. Sa ye ti pjepʉ yʉhʉ buheyequina gʉ̃hʉ sijieta, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Panopʉ cjẽ buheye mehna tiquina buhe more duagʉ̃ ihñano ohõ saha ni nemoahye Jesu tiquinare queoye mehna buhero. —‍Ne wahma cahsero suhtiro cahsero mehna mʉnano suhtirore sere ohõno cahmedare. Sa yegʉ̃ wahma cahsero mari coseri bato mʉnano suhtirore weje cahmecoa, paji yʉhdʉaro tʉhnʉgʉ̃ yere. (Sata mʉna buheye wahma buheye mehna piti dahre buheraro cahmene.) ");
INSERT INTO pirNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Sa yena ne ʉhse co bisiye core wahiquiro cahsero ajuropʉre mʉna ajuropʉre pose yeraro cahmene. Sa yegʉ̃ ʉhse co bisiye pahmuñepʉ mʉna ajurore tʉhnʉ dijiaa wahare. Ti ajuro tʉhnʉgʉ̃ ʉhse co gʉ̃hʉ ajuro gʉ̃hʉ cohãa wahare. Sa yena ʉhse co wahma core wahma ajuropʉ pose yero cahmene. (Sata wahma buheye mʉna buheye mehna buhe moredaro cahmene,) ni buheahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ape deco saurú ijigʉ̃ Jesu gʉ̃hʉ trigo wesepʉ wahahye. Tiquiro buheyequina pehe trigo parorire pehe yʉhdʉ cãhye. ");
INSERT INTO pirNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Tiquina sa yegʉ̃ ihñañe ohõ saha ni tuhtiahye fariseo masa Jesure: —‍Tʉhorĩña ʉsãre. ¿Dʉhse ye mʉhʉ buheyequina saurú mari sori deco ijiepegʉ̃ta dahrajari? Mari dutiyere yʉhdʉdʉcaye nine, niahye tiquina Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Tiquina sa nigʉ̃ tʉhoro Jesu tiquinare yʉhtiahye. “Yʉhʉ buheyequina yʉhdʉdʉcaye niedare”, nino taro ohõ saha niahye: —‍Davi mʉnano tiquiro mehna cjẽna mehna ʉjʉa ahbaro, Cohãcjʉ̃ wʉhʉpʉ sajã, Cohãcjʉ̃ ye pãre ihyahye. Sa yero tiquiro mehna cjẽna gʉ̃hʉre ti pãre ohoahye. Ti pãre pahia dihita ihyae tiahye. Cohãcjʉ̃ dutiye tiquina ojoari pũ apequinare ti pãre ihya dutierare. Ti pjere Abiatar wame tiriquiro pahia pʉhtoro ijiahye. ¿Davi gʉ̃hʉ tire tiquina yerire Cohãcjʉ̃ yere tiquina ojoari pũre buherari mʉsa? (Ti pãre ihyaro Cohãcjʉ̃re yʉhdʉdʉcaro niedahye. Miare ahri pjerire ihyaye yʉhʉ buheyequina gʉ̃hʉ Cohãcjʉ̃re yʉhdʉdʉcaye niedare,) niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Sa ni tuhasa ohõ saha ni nemoahye: —‍Sa yero Cohãcjʉ̃ saurú decore tiquina sori deco cũno, masa ya deco cũno nidi dahra wahyiariquinare so dutiro. Ti deco cahacjẽna ijiatire cũno niedari masare. ");
INSERT INTO pirNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Sa yegʉ yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ ahri deco saurú decore masa tiquina yeatire yahugʉ ijigʉ pʉhto ijiaja, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Sa ye Jesu ʉsã judio masa buheri wʉhʉpʉ esaro, sajãhye tja. Sa yero omoca bʉhariquiro gʉ̃hʉ topʉ ijiahye. Sa ye ti wʉhʉpʉ ijiyequina Jesu dihitare ihñadoque ohõahye. ");
INSERT INTO pirNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Saurú ijigʉ̃ Jesu omoca bʉhariquirore tiquiro yʉhdʉogʉ̃ ihña duahye tiquina. Tiquiro sa yegʉ̃ ihñañe tiquirore yahusã duahye. “Mari sori decore Jesu dahraro nine”, ni yahusã duahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Sa yero ohõ saha niahye Jesu omoca bʉhariquirore: —‍Wahcãdʉca saya. Ohõpʉ ahtaya, niahye. Sa ni tuhasa ti wʉhʉpʉ ijiyequinare yahuahye: ");
INSERT INTO pirNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","—‍¿Saurú ijigʉ̃ quehnoañene yegʉ̃ quehnoaedajari? ¿O ñañe yegʉ̃ pehere quehnoajari, mʉsa tʉhotugʉ̃? Saurú ijigʉ̃ masʉnore masogʉ̃ quehnoarĩne. Masʉnore wejẽgʉ̃ pehere quehnoaedare, ni yahuahye Jesu tiquinare. Tiquiro sa niepegʉ̃ta tiquina pehe ne yʉhtierahye. ");
INSERT INTO pirNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Tiquina sa yʉhtieragʉ̃ ihñano Jesu tiquina mehna usuahye. Tiquina tʉho dueragʉ̃ ihñano Jesu bʉjʉa witiahye. —‍Mʉhʉ omocare siõ potoya, niahye tiquiro omoca bʉhariquirore. Tiquiro sa nigʉ̃ tʉhoro tiquiro omocare siõ potoahye. Tiquiro siõ potogʉ̃ta omoca quehnoa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Sa omoca quehnoa wahagʉ̃ ihñañe fariseo masa wijiaa wahahye. Wijia, Herode mehna cjẽna mehna cahmecoa, “¿Dʉhse ye Jesure wejẽnatari mari?” niahye tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Sa ye Jesu tiquiro buheyequina mehna ditara cahapʉ wahahye. Tiquina sa wahagʉ̃ ihñañe Galilea cjẽna masa peyequina tiquiro bato esahye. Sa ye Judea yehpa cjẽna, Jerusalẽ cjẽna, Idumea yehpa cjẽna, Jordã wame tiri ma ape sie pahrẽ cjẽna, Tiro wame tiri maca cjẽna, to cahapʉ ijiyequina, Sidõ wame tiri maca cjẽna, to cahapʉ ijiyequina mehna masa peyequina ijipihtiyequina tiquiro yerire tʉhoye, tiquiro cahapʉ esahye. ");
INSERT INTO pirNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Sa ye masa peyequina ijiye, Jesu cahare bihsa dʉca sahye. Sa yero Jesu yucʉsare quehno pahsa dutiahye tiquiro buheyequinare. ");
INSERT INTO pirNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Peyequina dohatiyequinare tiquiro yʉhdʉogʉ̃ ihñañe apequina dohatiyequina gʉ̃hʉ Jesure piha duaye, bihsa dʉca sahye. ");
INSERT INTO pirNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Sa ye watĩare cʉoyequina pehe Jesure ihñañe tiquiro cahapʉ dʉsepe curi mehna quehe sahye. —‍Mʉhʉ Cohãcjʉ̃ macʉ ijire, ni sañuducuahye tiquina tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Sa yero tiquinare Cohãcjʉ̃ macʉno tiquiro ijiyere tutuaro mehna apequinare yahu dutierahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Sa ye Jesu cʉnʉpʉ mʉja, tiquiro cahmeñequinare pijiahye. Tiquiro pijigʉ̃ tʉhoye, tiquiro cahapʉ esahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Sa yero doce ʉmʉare tiquiro mehna cjẽnare, tiquiro ohoatiquinare, apeye macaripʉre tiquiro yere buheatiquinare bese docoahye Jesu. Sa ye tiquina ya curua Jesu cũriquina wame tiahye. ");
INSERT INTO pirNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Sa yero dohatiyequinare yʉhdʉoatire, watĩare cohãti gʉ̃hʉre cũahye tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Ahriquina ijiahye doce ʉmʉa Jesu tiquiro bese docoriquina: Simo, Santiago Zebedeo macʉno, Ñu Santiago bahʉro, Andre, Felipe, Bartolomé, Mateo, Tomasu, Santiago Alfeo macʉno, Tadeo, Simo celote ya curua cjʉ̃no ijimediquiro, Juda Iscariote, ahriquina ijiahye tiquiro bese docoriquina. Jesu Simore Pedro wame yeahye. Santiagore, Ñu mehna Boanerges wame yeahye. Boanerges “Ʉpo cjẽna”, nino nine. Juda Iscariote Jesure ihña tuhtiyequinare ihñoatiquiro ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Tiquinare bese doco tuhasa, dijia, Jesu tiquiro buheyequina mehna wʉhʉpʉ sajãa wahahye. Sa ye topʉ pari turi masa peyequina cahmecoañe, bihsaa wahahye. Tiquina sa bihsagʉ̃ ihñano Jesu ihya masiedahye. Sa ye tiquiro buheyequina gʉ̃hʉ ihya masiedahye. ");
INSERT INTO pirNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Sa ye apequina Jesu acaye tire tʉhoye tiquiro cahapʉ esaye, tiquirore ñehemahye. “Tiquiro tʉho masieniquiro waharo nine”, nimahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Apequina ohõ saha nimahye: —‍Beelzebú tiquirore sa wahagʉ̃ yero niaga. Tiquiro watĩare cohãno, Beelzebú watĩa pʉhtoro tutuaye mehna tiquinare cohãre, nimahye Jerusalẽpʉ ahtariquina ʉsã judio masare buheyequina. ");
INSERT INTO pirNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Tiquina sa nigʉ̃ tʉhoro Jesu pehe tiquinare piji, tiquiro tʉhotuye mehna queoye mehna yahuahye tiquinare, “Watĩno ye tutuaye mehna watĩare cohãgʉ niedaja”, nino taro. ");
INSERT INTO pirNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","—‍Watĩa tiquina basi cohã masiedare. Sa ye ihcã yehpa cjẽna tiquina basi cahme wejẽ, ti yehpa cjẽna yaria pihtia wahaboaga. ");
INSERT INTO pirNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Sa ye ihcã wʉhʉ cjẽna tiquina basi cahmequeñe ti wʉhʉ cjẽna waha pihtia wahaboaga. ");
INSERT INTO pirNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Sa yero Satana watĩa pʉhtoro pehe watĩare cohãno tiquina basita cahmequeñe niboaga. Sa ye tiquina waha pihtia wahaboaga. ");
INSERT INTO pirNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Ohõ sahata ijire mari queoye mehna buhegʉ̃. Tutuariquiro ya wʉhʉpʉ apequiro sajã sa yaque masiedare. Tutuariquirore dʉhteraro tiquiro ya wʉhʉpʉ sajã sa yaque masiedare. Tutuariquirore tiquiro dʉhteri bato sajã sa yaque masine, ni yahuahye Jesu. (Ohõ saha ni yahuahye watĩnore tiquiro yʉhdʉdʉcarire yahuro. Watĩno tutuariquiro tiquiro ijiepegʉ̃ta Jesu tiquirore yʉhdʉdʉcare watĩare cohãno.) ");
INSERT INTO pirNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Sa ni tuhasa ohõ saha ni yahu nemoahye Jesu: —‍Poto niita niaja mʉsare. Ijipihtiye ñañe masa tiquina yegʉ̃ tiquina yahuducugʉ̃ gʉ̃hʉre Cohãcjʉ̃ bo masine. ");
INSERT INTO pirNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Sa boeperota Espíritu Santore tiquina ñano yahuducugʉ̃ ti pũritare ne bosi. Tiquina sa nidi buhiri sa buhiri tiducuyequina ijieta, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesu Espíritu Santo tiquiro tutuaye mehna watĩare tiquiro cohãepegʉ̃ta “Tiquiro watĩno tutuaye mehna watĩare cohãno nine”, nimahye masa. Tiquina sa nigʉ̃ tʉhoro ti quitire Espíritu Santo quitire yahuahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Sa ye Jesu bahana tiquiro pacoro mehna wihiahye. Sa wihiye sopecahapʉ ijiahye. Apequinare piji dutiahye tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Sa ye masa tiquiro cahapʉ dujiyequina yahuahye tiquirore. —‍Mʉhʉ paco, mʉhʉ bahana mehna sopecahapʉ mʉhʉre pijiri, niahye. ");
INSERT INTO pirNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Tiquina sa nigʉ̃ tʉhoro ohõ saha niahye Jesu tiquinare buhero taro: —‍¿Noa ijiajari yʉhʉ paco, yʉhʉ bahana gʉ̃hʉ, mʉsa ihñagʉ̃? niahye tiquiro tiquinare buhero. ");
INSERT INTO pirNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Sa nino tiquiro caha dujiyequinare ihñano ohõ saha niahye: —‍Ahriquina ijire yʉhʉ paco, yʉhʉ bahana yero saha ijiyequina. Cohãcjʉ̃ cahmeñene yere ahriquina. ");
INSERT INTO pirNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Sa yeyequina yʉhʉ bahʉ, yʉhʉ baho, yʉhʉ paco yero saha ijire, ni buheahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Sa ye pari turi ditara dʉhtʉ cahapʉ Jesu buhe dʉcahye. Sa ye topʉre buhe dʉcaro masa peyequina tiquiro cahapʉ tiquina cahmecoagʉ̃ ihñano Jesu pehe yucʉsapʉ buhe pahsahye. Sa ye masa pehe ditara dʉhtʉ cahapʉ ducuahye. ");
INSERT INTO pirNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Sa yero Jesu peye tiquiro tʉhotuye mehna piti dahre yahuahye tiquinare buhero. ");
INSERT INTO pirNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—‍Ahri quitire tʉhoya mʉsa, niahye tiquiro. —‍Oteriquiro otero wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tiquiro sa otegʉ̃ apeye pjeri maha dʉhtʉ cahapʉ bora quehe sahye. Sa bora quehe saye pjerire minicjʉa ahta, ihya cãhye. ");
INSERT INTO pirNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Sa ye apeye pjeri ʉtã pjeri watoa bora quehe sahye. Ʉtã pjeri watoa dihta marieda cjũno ijiepegʉ̃ duita pihnimahye. ");
INSERT INTO pirNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Sa pihnidi ijieperota, asʉ̃ tutuaro asigʉ̃ nʉhcori marieda, ñaia wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Apeye pjeri taa watoa bora quehe sahye. Taa pehe dia yʉhdʉa waha, oteri pehere wejẽ cãhye. Sa yero dʉca mariedahye. ");
INSERT INTO pirNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Apeye pjeri quehnoari dihtare bora quehe sahye. Quehnoano pihniñe ijiro quehnoano dʉca tiahye. Apeye cjʉ treinta pjeri, apeye cjʉ sesenta pjeri, apeye cjʉ cien pjeri dʉca tiahye. ");
INSERT INTO pirNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ahrire quehnoano tʉhoya mʉsa, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Sa ye tiquina sehsaro ijiye doce buheyequina, apequina Jesu mehna ijiyequina ti quitire masi duaye, Jesure sinituahye. ");
INSERT INTO pirNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Tiquina sa sinituri bato Jesu ohõ saha ni yahuahye: —‍Cohãcjʉ̃ masa pʉhtoro tiquiro ijiyere, panopʉ apequina tiquina masiedarire mʉsare masigʉ̃ yere Cohãcjʉ̃. Apequina pehere sa yerare tiquiro. Tiquinare quiti mehnata buheitja. ");
INSERT INTO pirNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Sa ye tiquina ihñaepeta ihñedariquina yero saha tojoare. Sa ye tʉhoepeta masisi. Tiquina masiñe quehnoañe pehere camesaboaya. Tiquina sa camesagʉ̃ ihñano tiquina ñañe yerire boboaya Cohãcjʉ̃. (Sa ijiepegʉ̃ta tiquina pehe ne tʉho duerare,) niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Tiquiro sa nidi bato ohõ saha ni yahu nemoahye tiquinare: —‍¿Ahri quitire tʉhoena niajari mʉsa? ¿Mʉsa ahri quitire tʉhoerana, dʉhse apeye quitire tʉhonatari mʉsa? niahye Jesu tiquinare. Sa ni tuhasa ohõ saha ni yahu nemoahye tiquinare: ");
INSERT INTO pirNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","—‍Oteriquiro tiquiro oteri pjeri quehnoañe buheye yero saha ijire. ");
INSERT INTO pirNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Sa yero maha dʉhtʉ caha bora quehe sari pjeri quehnoañe buheye yero saha ijire. Sa yero masa quehnoañe buheyere tiquina tʉhogʉ̃ ihñano Satana pehe ahta, ti buheye quehnoañe buheyere masi dutierare tiquinare, minicjʉa ti pjerire tiquina dote nediro saha yero. ");
INSERT INTO pirNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Sa ye ʉtã pjeri watoa bora quehe sari pjeri quehnoañe buheye yero saha ijire. Sa ye masa quehnoañe buheyere tʉho, bucueye mehna duita tire tʉho ñehe maa wahare. ");
INSERT INTO pirNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Sa tʉho ñehepeta ʉtã pjeri watoa ijiye cjʉ nʉhcori marieñe cjʉ yero saha ahriquina masa gʉ̃hʉ tutuerare. Sa tutueraye, ñano yʉhdʉye, yeequina tiquina ijiri buhiri apequina tiquinare ñano yegʉ̃ ihñañe yee pehere duhu cãhre. Apequina tiquinare ñano yegʉ̃ tire ihcãno sahaeraye, yeere duhu cãhre. ");
INSERT INTO pirNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Sa ye taa watoa bora quehe sari pjeri quehnoañe buheye yero saha ijire. ");
INSERT INTO pirNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Sa ye masa quehnoañe buheyere tʉhoepeta, ahri yehpa cjẽne pajiro bʉjʉa witi tʉhotuye, niñeru pehere cahĩne. Apee boro gʉ̃hʉre peye tutuaro cahmene. Tiquina sa ni tʉhotugʉ̃ ti pehe quehnoañe buheyere cahmotare. Ti sa cahmotagʉ̃ masa quehnoañe pehere yerare. ");
INSERT INTO pirNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Sa ye quehnoari yehpapʉ bora quehe sari pjeri quehnoañe buheye yero saha ijire. Sa ye masa quehnoañe buheyere tʉhoye tire cahmene. Sa masiñequina ijiye, Cohãcjʉ̃ tiquiro cahmeno sahata quehnoañene yere tiquina. Ihquẽquina meheno quehnoañene yere treinta pjeri dʉca tiro saha. Apequina bui cjũno quehnoañene yere sesenta pjeri dʉca tiro saha. Apequina pajiro quehnoañene yere cien pjeri dʉca tiro saha, ni yahuahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Sa ni tuhasa ohõ saha ni nemoahye: —‍Ne sihãriare dihi sutu docapʉ cũedare. Sa ye tiare cumuno docapʉ cũedare. Ʉhmʉanopʉ duhu peore quehnoano buhrio dutiye. ");
INSERT INTO pirNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ijipihtiye tiquina masiedarire came masa masieta. Sihãria buhriogʉ̃ mari ihña masino saha panopʉre tiquina masiedarire masieta masa. ");
INSERT INTO pirNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ahrire quehnoano tʉhoya mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Mehenogã masi duana mehenogã masinata. Pajiro masi duana pajiro masinata. Sa yena mʉsa tʉhona quehnoano tʉho nʉnʉña. ");
INSERT INTO pirNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Quehnoano tʉho nʉnʉriquiro quehnoano masinota. Tʉho nʉnʉeniquiro, “Mehenogã tʉhoaja”, tiquiro niepegʉ̃ta ti pehe butia waharota, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Sa ni tuhasa ohõ saha ni yahu nemoahye: —‍Cohãcjʉ̃ masa pʉhtoro tiquiro ijiye trigore oteriquiro yero saha ijire. ");
INSERT INTO pirNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ote tuhasa bohrearo tiquiro oteri pihniñene ihñare tiquiro. “¿Dʉhse pihni wijia ta dʉcajari?” ni ihña masiedare oteriquiro tiquiro basi. ");
INSERT INTO pirNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ti oteri ti basi dʉca tire. Pari pũgã wijia mʉhtare. Came pari paro wijia, bʉcʉare. ");
INSERT INTO pirNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ti parori bʉcʉa tuhasagʉ̃ ihñano, pehere peheri pje ijigʉ̃. (Tiquiro ote, ti bʉcʉarire tiquiro masiedaro saha Cohãcjʉ̃ yequina masa tiquina wahari gʉ̃hʉre yahu peho masiedare masa,) ni buheahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Sa ni tuhasa ohõ saha ni buhe nemoahye queoye mehna buhero: —‍¿Ne Cohãcjʉ̃ masa pʉhtoro tiquiro ijiye yabe boro yero saha ijiajari, mʉsa tʉhotugʉ̃? ¿Dise quiti mehna tire yahunatari? ");
INSERT INTO pirNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Mostaza pjegã yero saha ijire Cohãcjʉ̃ pʉhtoro ijiye. Ti pjegã tiquiro otegʉ̃re meheni pjegã waro ijire. ");
INSERT INTO pirNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Sa ijieperota ti pjegã quehnoano pihnine. Sa yero pajidʉ wahare. Sa ye tʉ dʉpʉri bʉjʉye dʉpʉri bʉcʉagʉ̃ ihñañe minicjʉa ti dʉpʉripʉ suhti suhare, niahye Jesu. (Sa nino ohõ saha nino niahye. Mostaza pjegã pajidʉ tʉ bʉcʉariro saha ʉhmʉse cjʉ̃nore mari pʉhtorore masiñequina meheñequinagã tiquina iji mʉhtaepegʉ̃ta camepʉre peyequina wahaeta.) ");
INSERT INTO pirNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Sa yero ti quiti tiquiro nidiro saha peye quitire tiquina tʉho ñeheno puno quehnoañe buheyere buheahye tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Quiti marieno yahuerahye tiquinare. Sa yero tiquina sehsaro ijiyequinare Jesu quehnoano yahu pehoahye tiquiro buheyequinare. ");
INSERT INTO pirNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Sa ye ti decore ñamicahapʉ Jesu tiquiro buheyequinare ohõ saha niahye: —‍Isa, si pahrẽpʉ pehãʉhna, niahye tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Tiquiro sa nigʉ̃ tʉhoye yucʉsapʉ sajã, masare yehpapʉ ducuyequinare tota cũ, tiquiro buheyequina dihita Jesure ne pehã wahahye. Sa ye apeye yucʉsari mehna apequina tiquina bato pehãhye. ");
INSERT INTO pirNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tiquina sa pehãgʉ̃ wihnono tutuaro wẽahye. Sa wẽno yucʉsare tutuaro pahcõri quẽ sajãhye. Mehenogã dʉhsamahye tiquina miniboriro. ");
INSERT INTO pirNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Sa wahari watoa Jesu yucʉsa ohoturopʉ suhti puti buipʉ carĩno niahye. Sa ye tiquina tiquirore wahcõahye. —‍¿Buhegʉ, mʉhʉ cuerajari? Mari minina tana niajʉ́, niahye tiquina tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Tiquina sa nigʉ̃ta Jesu pehe wahcã, wihnonore, —‍To punota wẽ duhuya, niahye. Sa ninota pahcõri gʉ̃hʉre, —‍Yʉsʉahya, niahye. Tiquiro sa nigʉ̃ta wihnono yʉhdʉa wahahye. Sa ye pahcõri gʉ̃hʉ yʉsʉ dijiaa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","—‍¿Dʉhse yena cue maca cãna niajari mʉsa? ¿Mʉsa yʉhʉre wacũ tutuerajari? niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Sa wahagʉ̃ ihñañe acʉa yʉhdʉa wahahye. —‍¿Yohou, dʉhse ijiriquiro boro masʉno ijiajari ahriquiro? Ahri wihnono, pahcõri gʉ̃hʉ tiquiro dutigʉ̃ yʉhdʉdʉcaerare tiquirore, niahye tiquina pehe. ");
INSERT INTO pirNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","2","Sa ye tiquina si pahrẽpʉ Gerasa cjẽna ya yehpapʉ pehã sahye. Sa yero Jesu pehe yucʉsapʉ sañariquiro maja sadʉcahye. Tiquiro sa maja sadʉcari bato watĩa cʉoriquiro masa coperi ʉtã coperi watoapʉ ijiriquiro wijia ta, tiquiro cahapʉ ahtahye. ");
INSERT INTO pirNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Watĩa cʉoriquiro masa coperi watoa ijiriquiro ijiahye. Apequina pehe tiquirore come da pajiri da mehna ñehe dʉhte masiedahye. ");
INSERT INTO pirNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Sa ye peye tahari masa tiquirore dahpocãri apõñe behtori mehna, come dari mehna dʉhtemahye. Tiquiro omocari gʉ̃hʉre dʉhtemahye. Sa yero tiquiro pehe come darire nuha, dahpocãri apõñe behtori gʉ̃hʉre nuha site mʉjahye. Sa ye tutuariquiro tiquiro ijiro mehna masa pehe tiquirore ñehe masiedahye. ");
INSERT INTO pirNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ñami ijigʉ̃, deco ijigʉ̃ ʉtã coperi watoapʉ cʉnʉpʉ sa sañuducue tiahye tiquiro. Sa yero ʉtã mehna tiquiro basi tiquiro pagʉre quẽe tiahye. ");
INSERT INTO pirNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Sa yero yoaropʉ Jesure ihñadoqueo tiquiro cahapʉ oma maa cãhta, dʉsepe curi mehna quehe sahye tiquirore ño peoro taro. ");
INSERT INTO pirNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","—‍Watĩa duhuya tiquirore, niahye Jesu. Tiquiro sa nigʉ̃ tʉhoro watĩa cʉoriquiro ohõ saha niahye: —‍¿Jesu, Cohãcjʉ̃ tutuariquiro macʉ, yabere yegʉ tʉʉ niajari mʉhʉ yʉhʉre? Cohãcjʉ̃ tiquiro ihñonopʉ siniaja yʉhʉ mʉhʉre. Yʉhʉre ñano yeracãhña, ni sañuducuahye watĩa cʉoriquiro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","—‍¿Dʉhse wame tiajari mʉhʉ? niahye Jesu tiquirore. —‍Ʉsã peyequina ijiaja. Sa yena “Peyequina watĩa” wame tiaja. ");
INSERT INTO pirNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ʉsã ahri dihtapʉ ijinare ape siepʉ waha dutieracãhña, niahye watĩa cʉoriquiro. ");
INSERT INTO pirNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ti pjere yesea peyequina tiquina cahapʉ cʉnʉ dahpotopʉ ihyaye niahye. ");
INSERT INTO pirNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Topʉ tiquina ihyaducugʉ̃ ihñañe, ohõ saha ni siniahye watĩa: —‍Sisequina yesea cahapʉ waha dutiya ʉsãre. Tiquina mehna iji dutiya ʉsãre, ni siniahye watĩa tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Tiquina sa nigʉ̃ tʉhoro tiquinare waha dutiahye Jesu. Tiquiro sa waha dutigʉ̃ watĩa masʉno mehna ijiriquina waha, yesea dos mil yesea cahapʉ esahye. Tiquina cahapʉ tiquina esari bato yesea pehe ijipihtiyequina ditara dʉhtʉ cahapʉ oma buha, ti ditarapʉ bora ñojoa, mini yaria pihtia wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Tiquina sa minigʉ̃ ihñañe, yeseare cohteyequina pajiri macapʉ, daye macarigãpʉ gʉ̃hʉre tire yahuye waha, oma cãa wahahye. Tiquina sa yahugʉ̃ tʉhoye masa pehe peyequina tiquiro yerire ihñañe wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Sa ye Jesu cahapʉ wihiye, watĩa cʉoriquiro tiquiro suhti tiriquiro, tʉho masiniquiro tiquiro dujigʉ̃ ihñañe, ihña maria waha, cueahye. ");
INSERT INTO pirNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Sa ye watĩa cʉomediquiro, yesea gʉ̃hʉre tiquina sa waharire ihñariquina apequinare yahu pehoahye. ");
INSERT INTO pirNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Tiquina sa yahu pehogʉ̃ tʉhoye, Jesure tutuaro mehna ape siepʉ waha dutiahye. ");
INSERT INTO pirNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Sa yero yucʉsapʉ Jesu tiquiro sajãgʉ̃ ihñano, “Mʉhʉ mehna waha duaja”, ni tutuaro sinimahye watĩare cʉomediquiro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Tiquiro sa nigʉ̃ Jesu tiquirore yahuahye: —‍Yʉhʉ mehna wahaeracãhña. Mʉhʉ ya wʉhʉpʉ mʉhʉ caha ijiyequina cahapʉ yʉhʉ mʉhʉ pʉhto mʉhʉre yʉhʉ yerire yahugʉ wahaya. Mʉhʉre yʉhʉ paja ihñarire yahugʉ wahaya tiquinare, niahye tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Tiquiro sa nigʉ̃ watĩa cʉomediquiro pehe Decapoli wame tiri macapʉ Jesu tiquirore yʉhdʉorire yahu dʉcahye. Tiquiro sa ni yahugʉ̃ tʉhoye ijipihtiyequina masa tʉho maria wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Sa ye pari turi Jesu tiquiro majare pehã sagʉ̃ masa peyequina tiquiro cahapʉ ditara dʉhtʉ cahapʉ cahmecoahye. ");
INSERT INTO pirNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Sa yero ʉsã judio masa buheri wʉhʉre ihña ihboriquiro Jairo wame tiriquiro ahta, Jesure ihña, tiquiro dahpocãri cahapʉ dʉsepe curi mehna quehe saro, ohõ saha niahye: ");
INSERT INTO pirNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","—‍Yʉhʉ macogã yariaro nidi. Sa yegʉ ticorore mʉhʉ omoca mehna ña peogʉ, yʉhdʉogʉ ahtaya. Mʉhʉ sa yegʉ̃ ticoro masanota, niahye tiquiro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Tiquiro sa nigʉ̃ Jesu gʉ̃hʉ pehe tiquiro mehna wahahye. Mahapʉ tiquiro wahagʉ̃ masa peyequina tiquirore nʉnʉ tã cã bihsaro esadʉca sahye. ");
INSERT INTO pirNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Sa yero numino doce cʉhmari waro decoripe dii mʉna dohatiducuricoro topʉ ijiahye. To pano peyequina duturua ticorore ñano yʉhdʉgʉ̃ yeahye. ");
INSERT INTO pirNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Sa yero duturuare ijipihtiye ticoro niñeru mehna wapa yemahye ticoro aco ye dutiro. Tiquina sa yepegʉ̃ta ticoro mʉnanota ijiducu cãhye. Sa yero ticoro tiquinare ihñari bato to pano ijiriro yʉhdʉoro ñano wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ticoro sa ñano yʉhdʉri bato Jesu yeyere tʉhoye, apequina yahuahye ticorore. Sa yero ticoro Jesu bato masa peyequina watoa ahta, Jesu suhtirore ñehe tuhuahye. ");
INSERT INTO pirNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","“Yʉhʉ tiquiro suhtiro dihitare ñehe tuhugo quehnoa wahagota”, ni tʉhotuahye. ");
INSERT INTO pirNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Sa yero ticoro sa ñehe tuhuri bato ticoro dii mʉna dohatiyere yʉhdʉgʉ̃ ticoro pagʉre quehnoari pagʉ tʉhotuahye. ");
INSERT INTO pirNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Sa yero Jesu tiquiro tutuaye mehna dohatiyere tiquiro cohãrire masino, masa watoa majaredʉca sa ihñahye. —‍¿Noa yʉhʉ suhtirore ñehe tuhuajari? niahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Tiquiro sa nigʉ̃ tʉhoye tiquiro buheyequina ohõ saha niahye: —‍Bihsarĩne. Sa ye masa peyequina mʉhʉre pihare. “¿Noa yʉhʉre ñehe tuhuajari?” nigʉ, ¿dʉhse nigʉ sa niajari mʉhʉ? niahye tiquina pehe tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Sa yero Jesu tiquirore ñehe tuhuricorore macahye. ");
INSERT INTO pirNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Tiquiro sa macano watoa ticoro pehe ticoro pagʉ quehnoa wahagʉ̃ tʉhoturo, cue nanare dʉsepe curi mehna quehe sahye tiquiro caha tiquirore ño peoro. ");
INSERT INTO pirNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Sa yero ticoro potota yahu pehoahye tiquirore. Ticoro sa ni yahuri bato Jesu ticorore yahuahye: —‍Maco, yʉhʉre mʉhʉ wacũ tutuaye mehna quehnoago tojoare yojopʉre. Bucueye mehna wahaya. Dohatiye mariego ijiya, niahye Jesu ticorore. ");
INSERT INTO pirNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Tiquiro sa ni yahuducuri bato judio masare buheri wʉhʉre ihña ihboriquiro ya wʉhʉ cjẽna yahuye wihiahye. —‍Mʉhʉ maco yaria wahari. Sa yegʉ buheriquirore piji cãhteracãhña, niahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Tiquina sa niepegʉ̃ta sa tʉhotu cãhno, Jesu ti wʉhʉre ihña ihboriquirore ohõ saha ni yahuahye: —‍Bʉjʉa witieracãhña. Yʉhʉre wacũ tutuaya. Ti dihitare yeya, niahye ti wʉhʉre ihña ihboriquirore. ");
INSERT INTO pirNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Sa ni tuhasa Santiago, tiquiro bahʉro Ñu, Pedro tiquina dihitare “Yʉhʉ mehna ahtaya”, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Sa yero judio masa buheri wʉhʉre ihña ihboriquiro ya wʉhʉpʉ esahye. Ti wʉhʉpʉ masa peyequina ñano bisi ñehe quea utigʉ̃, tiquina sañuducugʉ̃ tʉhoahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","—‍Ñano ni, ñehe quea utieracãhña mʉsa. Ticorogã mʉsa sa ni utigʉ̃ yarierare. Carĩno nine, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Tiquiro sa nigʉ̃ tʉhoye “Sa ni maca cãhno nine ahriquiro”, ni bʉjʉahye tiquina pehe tiquirore. Sa yero tiquiro tiquinare sopecahapʉ wio peho cãhye. Sa wio tuhasaro ticorogã pacʉsʉmʉare, tiquiro mehna cjẽna gʉ̃hʉre ticorogã cahapʉ neahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Sa yero Jesu ticoro omocare ñehe, “Talita cum”, niahye tiquiro. “Talita cum”, nino, “ ‘Mehenicorogã wahcãña’, niaja yʉhʉ”, nino nine. ");
INSERT INTO pirNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Tiquiro sa nigʉ̃ ticorogã wahcãdʉca sa, tiniahye. Doce cʉhmari cʉoricoro ijiahye ticoro. Ticorore tiquiro sa yegʉ̃ ihñañe tiquina ihña maria wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Sa yero Jesu tutuaro mehna tiquiro sa yerire yahu site dutierahye. Sa ye tuhasa ticorore ihyayere oho dutiahye. ");
INSERT INTO pirNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Sa ye topʉ ijiriquiro Jesu waha, tiquiro buheyequina mehna tiquiro ya dihtapʉ tojoa sahye. ");
INSERT INTO pirNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sa yero Jesu saurú ijigʉ̃ judio masa buheri wʉhʉpʉ buhe dʉcahye. Tiquiro sa buhegʉ̃ masa peyequina tiquirore tʉhoye, acʉa wahahye. —‍¿Ahriquiro nohopʉ tʉhoyari ahri buheyere? ¿Dʉhse yero quehnoano masi pehoajari ahriquiro? Cohãcjʉ̃ tutuaye mehna ye ihñore ahriquiro masare. ");
INSERT INTO pirNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ahriquiro taboa dahrari masʉno María macʉno, Santiago, José, Juda, Simo tiquina wahminota ijimedero. Sa ye tiquiro bahana numia mari ya macapʉ ijinimedi. Sa yero tiquiro gʉ̃hʉ mari yero saha ijiriquiro ijire, niahye tiquina Jesure tʉhoriquina. Sa ye Jesure ihña tuhtiye, tiquirore cahmedahye. ");
INSERT INTO pirNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Tiquina sa cahmedagʉ̃ ihñano ohõ saha niahye Jesu: —‍Cohãcjʉ̃ yere yahu mʉhtariquirore apequina ño peore. Tiquina sa ño peoepegʉ̃ta tiquiro ya maca cjẽna, tiquiro acaye tiquiro ya wʉhʉpʉ ijiyequinata ño peoerare tiquirore. Sa yena yʉhʉre ño peoerare mʉsa ohõre bʉcʉarigʉ yʉhʉ ijigʉ̃, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Sa yero ti macapʉ ijiriquiro Jesu Cohãcjʉ̃ tutuaye mehna ye ihño masiedahye. Sa ye ihñoedaperota ihquẽquina dohatiyequina bui tiquiro omocare duhu peo, yʉhdʉoahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Sa yero to cjẽna Jesure tiquina wacũ tutueragʉ̃ ihñano, “¿Dʉhse ijiro boro yʉhʉre cahmedajari?” ni tʉhotuahye tiquiro. Sa yero Jesu ti maca cahapʉ ijiye macaripʉ buhero wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Sa ye Jesu doce tiquiro buheyequinare pijio, pʉeyequina dihita ohoahye tiquinare macaripʉre buhe dutiro. Sa yero tiquiro tutuayere ohoahye tiquinare watĩare tiquina cohãtire. ");
INSERT INTO pirNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Sa ohoro apee boro, ihyayere, ajurire, niñerure tiquiro ne cã dutierahye tiquinare. Tiquina tuaye cjʉ dihitare ne cã dutiahye tiquinare. Ihcãnota suhtirore saña dutiahye tiquinare. Pʉaro saña dutierahye. ");
INSERT INTO pirNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Sa yero cʉhta cũñe cahserire saña dutiahye tiquinare. Ihcã suhtirota saña dutiahye tiquinare. Pʉaro saña dutierahye. ");
INSERT INTO pirNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Sa yero ohõ saha ni yahuahye tiquinare: —‍Ijipihtiye macaripʉre mʉsare tiquina carĩno ohogʉ̃ ti wʉhʉpʉta tojoarĩña. Coã wahanapʉ wijiaya ti wʉhʉre. ");
INSERT INTO pirNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Sa yena ape maca cjẽna mʉsare tiquina cahmedagʉ̃ tiquina tʉho dueragʉ̃ ti macare yʉhdʉana dahpocãri cjẽ dihta esa wahãrire wejẽ site cũña mʉsa tiquinare tiquina ye buhirire masigʉ̃ yena, ni yahuahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Sa ye doce buheyequina masare tiquina ñañe yerire bʉjʉa witi dutiye, quehnoañe pehere ye dutiye, buheye wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Sa wahaye peyequina watĩare cohãñe, dohatiyequinare ʉhse mehna wisõñe yʉhdʉgʉ̃ yeahye. ");
INSERT INTO pirNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Sa ye Jesure masa peyequina masiahye. Sa yero tiquiro yerire pʉhtoro Herode tʉhooahye. Sa tʉhooro ohõ saha ni tʉhotumahye tiquiro: “Ñu wame yeriquiro yariariquiro pari turi bajuaro niaga. Sa bajuariquiro ijiro tiquiro tutuaye mehna tire yero niaga”, ni tʉhotumahye Herode. “Jesu Ñuta ijire”, ni tʉhotumahye. ");
INSERT INTO pirNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Apequina pehe ohõ saha ni tʉhotumahye: “Elia ijire”, ni tʉhotumahye. Apequina pehe “Cohãcjʉ̃ yere yahu mʉhtariquiro panopʉ cjẽna yero saha ijire tiquiro”, ni tʉhotumahye tiquina Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Tiquina sa ni tʉhotuepegʉ̃ta Herode pehe Jesu tiquiro yerire tʉhoro ohõ saha ni tʉhotumahye. “Ñu yʉhʉ dapu dʉte sure dutiriquiro bajuaro niaga”, ni tʉhotumahye. ");
INSERT INTO pirNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Ñure tiquina wejẽato pano Herode tiquirore ñehe duti, peresu ye dutiahye. Herode tiquiro bahʉro Felipe namonore Herodia wame tiricorore ehma, namo tiahye. —‍Mʉhʉ bahʉ namonore namo tigʉ Cohãcjʉ̃ dutiyere yʉhdʉdʉcagʉ nine mʉhʉ, ni yahuahye Ñu Herodere. Tiquiro sa nidi buhiri Herode namono Herodia Ñure peresu tiquina yegʉ̃ cahmeahye. ");
INSERT INTO pirNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Sa yero ticoro pehe Ñure ihña tuhtiro, tiquirore wejẽ duti duamahye. Sa ye dueperota ticoro tiquirore wejẽ duti masiedahye. ");
INSERT INTO pirNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herode Ñure cuero “Ñu quehnoañene yeriquiro, quehnoariquiro ijire”, ni tʉhotuahye. Sa yero Herodere cariboro yeahye Ñu pehe tiquirore yahuro. Sa cariboepegʉ̃ta tiquiro bucueye mehna tʉhomahye Ñure. ");
INSERT INTO pirNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Tiquiro sa bucueye mehna tʉhoepegʉ̃ta Herodia tiquirore ticoro wejẽ dutiati deco ʉmʉ sahye. Ti pje Herode masa bajuari deco ijigʉ̃ tiquiro bose deco dahreahye. Sa ye tiquiro yequina gobierno cjẽna, surara pʉhtoa, Galilea cjẽna pʉhtoa gʉ̃hʉ tiquiro ya bose decore ihñañe wihiahye. ");
INSERT INTO pirNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Sa yero Herodia macono bose decore ihñano wihiro tiquina ihñonopʉ basa ihñoahye. Ticoro sa basa ihñogʉ̃ ihñañe, Herode tiquiro pijioriquina gʉ̃hʉ bucueahye. Tiquina sa bucuegʉ̃ ihñano ohõ saha niahye Herode: —‍Mʉhʉ cahmeñene siniña yʉhʉre. Sa yegʉ ohogʉtja mʉhʉre mʉhʉ cahmeñene. ");
INSERT INTO pirNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Cohãcjʉ̃ mehna poto niaja mʉhʉre. Mʉhʉ sinino puno yeere deco mehna ohogʉtja mʉhʉre, niahye tiquiro ticorore. ");
INSERT INTO pirNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Tiquiro sa nigʉ̃ ticoro Herodia macono pehe ticoro pacoro cahapʉ waha, sinituahye: —‍¿Yabere sinigotari yʉhʉ? ni sinituahye ticoro pacorore. —‍Ñu wame yeriquiro dapure siniña, niahye ticoro pacoro pehe. ");
INSERT INTO pirNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ticoro sa nigʉ̃ta Herodia macono ʉmʉñano pʉhtoro Herode cahapʉ waha, siniahye: —‍Mianogãta Ñu wame yeriquiro dapure waparo mehna ohoya yʉhʉre, niahye ticoro. ");
INSERT INTO pirNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ticoro sa nigʉ̃ tʉhoro pʉhtoro Herode pehe tutuaro bʉjʉa witiahye. Masa tiquina ihñonopʉ “Ohogʉtja mʉhʉre”, niahye tiquiro. Sa yero bʉe tiro, tiquiro “Mʉhʉre ohoeraja”, ni masiedahye ticorore. ");
INSERT INTO pirNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Sa yero duita surarare peresupʉ ijiyequinare cohteriquirore Ñu dapure dʉte sure ne cãhta dutiahye. ");
INSERT INTO pirNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Tiquiro sa dutigʉ̃ tʉhoro surara pehe waha, tiquiro dapure dʉte sure, waparo mehna ne cãhtahye. Ne cãhta nuhminore Herodia maconore ohoahye. Sa yero ticoro tiquiro dapure ñehe, ticoro pacorore oho yʉhdʉoahye. ");
INSERT INTO pirNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Sa ye Ñu buheyequina ijiriquina pehe tire tʉhoye, topʉ esa, tiquiro pagʉre masa copepʉ ne cã, cũahye. ");
INSERT INTO pirNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Sa ye Jesu ohoriquina tiquiro cahapʉ tojoa saye, tiquina yerire, tiquina buherire yahuahye tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ti pjere masa peyequina sa majareducuye, tiquinare ne ihyaro ohoerahye. Sa yero ohõ saha niahye Jesu tiquinare. —‍Masa marienopʉ mari sehsaro sona wahaʉhna, niahye tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Sa ye tiquina sehsaro yucʉsa mehna masa marienopʉ wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Tiquina sa wahagʉ̃ ihñañe masa peyequina tiquinare masiahye. Sa masiñe peye macari cjẽna mahapʉ waha, Jesu tiquiro esatopʉ tiquina masa pehe oma cã esa mʉhtahye. ");
INSERT INTO pirNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Tiquina sa esagʉ̃ Jesu tuha sa paha, yucʉsapʉ sañariquiro maja dʉcaro, tiquiro masa peyequina ijigʉ̃ ihñahye. Oveja cohteriquiro marieñequina yero saha ijiahye masa, tiquiro ihñagʉ̃. Sa yero Jesu tiquinare paja ihñano, peye quehnoañe buheyere buheahye. ");
INSERT INTO pirNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ñamicahapʉ doce buheyequina Jesu cahapʉ esa, ohõ saha niahye: —‍Ohõ masa marienopʉ ijire. Ñamicaha waharo nine. ");
INSERT INTO pirNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ohõ cahagã ijiye wʉhʉseripʉ, macaripʉ gʉ̃hʉre tiquina ihyatire dú dutiya masare tiquina pohe tiatire, niahye tiquina Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","—‍Ihyayere ohoya tiquinare, nimahye Jesu tiquiro buheyequinare. Tiquiro sa nigʉ̃ ohõ saha ni yʉhtiahye: —‍¿Dos cientos niñeru cjoeri mehna tiquina ihyati pãre dúnatari ʉsã? niahye tiquina Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","—‍¿Nohope paca pã ijiajari? Ihñana wahaya, niahye tiquiro. Tiquiro sa nigʉ̃ tiquina pehe ihyayere bocaye, ohõ saha niahye: —‍Ihcã omope paca pã paca, pʉaro wahi ijire, niahye tiquina pehe. ");
INSERT INTO pirNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Tiquina sa nigʉ̃ tʉhoro Jesu pehe pe cururi taa bui duji dutiahye masare. ");
INSERT INTO pirNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Tiquiro sa duji dutiri bato tiquina pe cururi dujiahye. Ihquẽ cururire cincuenta masa ijiahye. Apeye cururi pehere cien masa ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Tiquina sa duji tuhasagʉ̃ ihñano Jesu pehe ihcã omope paca pã pacare, pʉaro wahi mehna ne, ʉhmʉsepʉ ihña mʉoahye. Sa ihña mʉono Cohãcjʉ̃re “Quehnoare”, nino niahye. Tiquiro sa nidi bato pã pacare nuha, tiquiro buheyequinare masare iti duti ohoahye. Sa yero pʉaro wahire iti dutiahye ijipihtiyequinare. ");
INSERT INTO pirNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Sa ye ijipihtiyequina ihya, yapi yʉhdʉa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Tiquina ihya dʉharire doce pʉhʉse waro pãre, wahi gʉ̃hʉre ne cahmecoa wahpo dapoahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Sa ye pãre ihyariquina ʉmʉa dihitare tiquina queogʉ̃ cinco mil ʉmʉa ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ti pjeta Jesu tiquiro buheyequinare yucʉsapʉ sajã duti, ape sie pahrẽpʉ Betsaidapʉ tiquiro pano pehãyu dutiahye. Sa yero tiquina pehãri watoa Jesu pehe masare cohe tiahye. ");
INSERT INTO pirNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Cohe ti tuhasa cʉnʉpʉ Cohãcjʉ̃re sinino wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Came ñamipʉ yucʉsa mehna ditarapʉ tiquina pehãducugʉ̃ Jesu ihcãquirota tiquina pehã tariropʉ ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Sa yero tiquina ñano yʉhdʉ wajagʉ̃, tiquina pano wihnono wẽgʉ̃ ihñadoqueoahye tiquiro. Sa yero bohrea mʉja tato pano tiquina cahapʉ esaro, aco bui tini cãa wahahye. Tiquinare tiquiro yʉhdʉ cã duamahye. ");
INSERT INTO pirNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Tiquiro yʉhdʉ cã duepegʉ̃ta tiquirore aco bui ahtagʉ̃ ihñañe, cue niahye. “Yariariquiro ijiboaga”, ni ihñamahye tiquina. Sa ni tʉhotuye tiquina sañuducuahye. ");
INSERT INTO pirNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ijipihtiyequina tiquirore ihñañe, ihña maria wahahye. Tiquina sa ihña mariagʉ̃ ihñano Jesu tiquinare yahuahye: —‍Wacũ tutuaya mʉsa. Ne, yʉhʉre cueracãhña. Yʉhʉta ijiaja, niahye tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Sa ni tuhasa tiquiro tiquina mehna yucʉsapʉ sajãhye. Tiquiro sajãri batogãta wihnono yʉhdʉa wahahye. Sa wahagʉ̃ tiquina pehe acʉa yʉhdʉa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Tiquiro pãre peye yerire wacũedahye tiquina. Tire quehnoano masiedahye. ");
INSERT INTO pirNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Sa ye tiquina pehã sa, Genesare dihtapʉ pehã sa, tiare dʉhte poho, dʉhtʉ cahapʉ pahsahye. ");
INSERT INTO pirNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Sa ye yucʉsapʉ ijiriquina tiquina majagʉ̃ta masa pehe Jesure ihña masiahye. ");
INSERT INTO pirNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Sa ihña masiñe ijipihtiro tiquina ya yehpapʉ oma maja, dohatiyequinare tiquina cuñañe cahseri mehna yo cãhtahye. “Jesu topʉ ijiri”, masa nigʉ̃ tʉhoye topʉre esahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Sa ye ijipihtiye macari tiquiro esaye macaripʉ, bʉjʉye macaripʉ, daye macarigãpʉ, meheñe wʉhʉsegã ijiye cahapʉ gʉ̃hʉre masa dohatiyequinare Jesu cahapʉ nea cũahye. Sa topʉ maharipʉ tiquina cũnopʉ Jesure tiquiro suhtiro dʉhtʉ cahare ñehe tuhu duaye, tutuaro siniahye tiquina: —‍Mʉhʉ suhtiro dʉhtʉ caha dihitare ʉsãre ñehe tuhu dutiya, ni siniahye. Sa ye tiquiro suhtirore ñehe tuhuriquinape quehnoa wahahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Sa ye Jerusalẽpʉ ahtariquina ʉsã acaye judio masare buheyequina, fariseo masa gʉ̃hʉ Jesu cahapʉ cahmecoahye. ");
INSERT INTO pirNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","4","Fariseo masa ijipihtiyequina apequina judio masa mehna panopʉ cjẽna tiquina dutiriro saha tiquina omocarine omo coserape ihyera tiahye. Sa ye doeri cjẽ duayequina cahapʉ esayequina tiquina ye wʉhʉsepʉ wihiye tiquina dutiriro saha tiquina omocarine omo coseraye ihyera tiahye. Sa ye peye apeye dutiyere panopʉ cjẽna judio masa tiquina dutiyere yee tiahye. Sihniñe parire coseye, dihi suturire coseye, come suturire coseye, yee tiahye tiquina judio masa, “Cohãcjʉ̃ sa cahmene”, niñe. Sa ye Jesu cahapʉ cahmecoañe Jesu buheyequina judio masa tiquina dutiriro saha tiquina omo coseragʉ̃ ihñahye fariseo masa. ");
INSERT INTO pirNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Sa ihña tuhasaye Jesure sinituahye: —‍Mʉhʉ buheyequina ihyaye mari ñecʉsʉmʉa mʉna tiquina dutiriro sahata tiquina omocarine omo coserare. ¿Dʉhse yeye mari dutiyere yerajari? niahye tiquina Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Tiquina sa nigʉ̃ tʉhoro Jesu yahuahye tiquinare. —‍Masa tiquina ihñono dihita quehnoano iji mehona ijire mʉsa. Cohãcjʉ̃ yere yahu mʉhtariquiro mʉnano Isaia mʉsare panopʉre potota yahue tiahye. Ohõ saha niahye: Ahriquina masa yʉhʉre quehnoano yahuducuepeta yʉhʉre ne ño peoerare. ");
INSERT INTO pirNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Sa ye yʉhʉre tiquina ñu buheye dʉhseati ijierare. “Cohãcjʉ̃ ye dutiye ijire ahri”, ni meho buhere tiquina buheye, ni ojoahye Isaia. ");
INSERT INTO pirNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ti ijirota ijire. Panopʉ cjẽna ye dutiye pehere yena tana Cohãcjʉ̃ ye dutiyere yerare mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Cohãcjʉ̃ ye dutiyere cohãna, mʉsa acaye ye dutiye pehere yere mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ohõ saha yena Cohãcjʉ̃ ye pehere yʉhdʉdʉcana nine mʉsa. Panopʉre ohõ saha niahye Cohãcjʉ̃ tiquiro dutiyere Moisere cũno: “Mʉsa pacʉsʉmʉare ño peoya. Ihcãquiro tiquiro pacʉsʉmʉare ñano quiti dahreriquiro ijiro ti buhiri tiquina wejẽatiquiro ijirota”, niahye Cohãcjʉ̃ Moisere tiquiro cũri dutiye. ");
INSERT INTO pirNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Tiquiro sa niepegʉ̃ta ohõ saha ye dutire mʉsa tiquina pacʉsʉmʉare yedoho dutierana: Tiquina pacʉsʉmʉare tiquina ohoborire Cohãcjʉ̃ pehere oho dutire mʉsa. Sa ni buhemene mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Sa buhena tiquina pacʉsʉmʉare ño peogʉ̃ yerare mʉsa tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Sa yena Cohãcjʉ̃ dutiyere yʉhdʉdʉcana nine mʉsa mari acaye panopʉ cjẽna ye dutiye pehere yena. Apequinare mʉsa ye buheye dihitare tʉho dutire mʉsa. Peye sa ijiyere yere mʉsa, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Sa ni tuhasaro apequinare pijioahye. Ohõ saha niahye: —‍Mʉsa ijipihtina tʉhoya yʉhʉre. Yʉhʉ niñene quehnoano masiña mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Mʉsa dʉserire sajãñe pehe mʉsa ihyaye pehe mʉsare ñana ijigʉ̃ yerare. Mʉsa ñañe yahuducuye pehe mʉsa dʉseri wijiaye pehe mʉsare ñana ijigʉ̃ yere.  ");
INSERT INTO pirNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Yʉhʉre quehnoano tʉhoya, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Sa ni tuhasa Jesu masa cahapʉ ijiriquiro waha, wʉhʉpʉ sajãa wahahye. Sa sajã sagʉ̃ ihñañe tiquiro buheyequina pehe tiquiro buherire sinituahye. Tiquina sa sinitugʉ̃ tʉhoro ohõ saha niahye tiquiro: ");
INSERT INTO pirNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","—‍¿Ne tʉho ñehedajari mʉsa? Mʉsa dʉserire sajãñe pehe mʉsa ihyaye pehe mʉsare ñana ijigʉ̃ yerare. ");
INSERT INTO pirNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ti mʉsa tʉhotuyepʉre sajãedare. Mʉsa paapʉ sajã yʉhdʉa wahare, niahye Jesu. Sa nino “Ijipihtiye ihyaye quehnoañe ijire”, nino niahye. ");
INSERT INTO pirNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ohõ saha ni nemoahye: —‍Mʉsa ñañe yahuducuye pehe mʉsa dʉseri wijiaye pehe mʉsare ñana ijigʉ̃ yere. ");
INSERT INTO pirNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Ñano tʉhotuye, wʉana tiye, numia mehna ñano yeducuye, ʉmʉa mehna ñano yeducuye, masare wejẽñe, yaqueye, apequiro yere tutuaro cahme yʉhdʉye, ñano yeye, ni mehoñe, peye ñañene yeducuye, apequiro yere coo ihña tuhtiye, ñano quiti dahreye, “Apequinare yʉhdʉdʉcaja”, ni tʉhotuye, tʉho masieñequina ijiye, ti ijipihtiye mʉsare mʉsa tʉhotuyepʉ ahtare. ");
INSERT INTO pirNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ijipihtiye ahri ñañe mʉsa tʉhotuyepʉ ahta, mʉsare ñana ijigʉ̃ yere, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Sa yero Tiro wame tiri maca cahapʉ esaro, to cjã wʉhʉpʉ sajãa wahahye. Sa yero apequinare tiquiro ijiri wʉhʉre yahu dutierahye. Sa yahu dutieraperota tiquinare tiquiro duhti masiedahye. ");
INSERT INTO pirNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ti pjereta numino ticoro macono watĩno cʉoricoro tiquiro cahapʉ ijiahye. Sa ye Jesu yerire ihñañe apequina ticoro pacorore yahuahye. Tiquina sa yahuri bato ticoro pacoro pehe waha, Jesu dahpocãri cahapʉ dʉsepe curi mehna quehe sahye tiquirore ño peoro. ");
INSERT INTO pirNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ticoro Siria yehpapʉ ijiri yehpa Fenicia wame tiri yehpa cjõno ijiahye. —‍Watĩnore cohãrĩña yʉhʉ macore, ni siniahye ticoro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ticoro sa sinigʉ̃ tʉhoro ohõ saha niahye Jesu: —‍Wahmanore wʉhʉ upʉro pohne ye ihyayere diayeare yʉhʉ oho mʉhtagʉ̃ to wahaerare. (Israe masa yere ape yehpa cjẽnare yʉhʉ oho mʉhtagʉ̃ to wahaerare,) niahye Jesu ticorore queoye mehna yahuro. ");
INSERT INTO pirNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","—‍Sa tjire pʉhto. Sa ijiepegʉ̃ta diayea gʉ̃hʉ mesa doca tiquina pohne ihya site dijioyere ihya cohtere tiquina gʉ̃hʉ. (Ape yehpa cjõ yʉhʉ ijiepegʉ̃ta yʉhʉ gʉ̃hʉre yedoho masine mʉhʉ,) ni yʉhtiahye ticoro. ");
INSERT INTO pirNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","—‍Mʉhʉ sa ni yʉhtigʉ̃ mʉhʉ macore watĩno duhu tuhasari. Ihñago wahaya, niahye Jesu ticorore. ");
INSERT INTO pirNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Tiquiro sa nigʉ̃ tʉhoro waha, ticoro wʉhʉpʉ esaro, ticoro maconore watĩno marienicoropʉre cuñanopʉ ijiricorore ihñahye. ");
INSERT INTO pirNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ti pjere Jesu Tiro wame tiri maca cahapʉ ijiriquiro waha, Sidõ wame tiri macare esa yʉhdʉ cã, Decapoli wame tiri macare esa yʉhdʉ cã, Galilea wame tiri ditarapʉ esahye. ");
INSERT INTO pirNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Sa ye cahmono tʉhoeriquirore, yahuducu masieniquirore Jesu cahapʉ ne cãhtahye apequina. —‍Mʉhʉ omoca mehna ña peoya tiquirore, ni siniahye tiquina tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Tiquina sa nigʉ̃ta Jesu pehe tʉhoeriquirore ne cã, masa marienopʉ siho esahye. Tiquina sehsaro ijiahye. Sa yero Jesu tiquiro omo piri mehna tʉhoeriquirore cahmo coperire ohbe sõahye. Sa ye tuhasa, sihco puti, tiquiro ñehmenore ña peoahye. ");
INSERT INTO pirNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Sa ye tuhasa ʉhmʉsepʉ ihña mʉo, jeri ne, ohõ saha niahye: —‍Efata, niahye Jesu. “Efata”, nino “Põohña”, nino nine. Sa nino tiquirore tʉho dutiro niahye. Sa yero yahuducu dutiro niahye. ");
INSERT INTO pirNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Tiquiro sa nigʉ̃ta tiquiro pehe tʉho boca, tiquiro ñehmeno cahbiro wahagʉ̃ tʉhoturo quehnoano yahuducuahye. ");
INSERT INTO pirNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Sa yero Jesu tiquinare tire apequinare yahu site dutierahye. Tiquiro sa yahu site dutieraripe taharita tja tiquina apequinare yahu site nemoahye. ");
INSERT INTO pirNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Sa ye masa tʉho maria wahaye, ohõ saha niahye: —‍Ijipihtiyere tiquiro quehnoano yere. Tʉhoeyequinare quehnoano tʉhogʉ̃ yere. Yahuducu masieñequina gʉ̃hʉre quehnoano yahuducugʉ̃ yere Jesu, niahye masa. ");
INSERT INTO pirNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ti pjere pari turi masa peyequina cahmecoari bato ihyaye marieñequina tiquina ijigʉ̃ ihñano Jesu tiquiro buheyequinare pijioahye: ");
INSERT INTO pirNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—‍Ahriquina masa ihtia deco waro yʉhʉ mehna iji tuhasari. Sa ye tiquinare pohe mariedare. Tiquina pohe mariedagʉ̃ ihñagʉ tiquinare paja ihñaja yʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Apequina tiquina mehna cjẽna yoaropʉ ahtari. “Tiquinapʉ ʉjʉa ahbayequina mahapʉ borari”, nigʉ tiquinare ihyaye marieno tiquina ye wʉhʉsepʉ waha duti dueraja. Sa yegʉ tiquinare pohe oho duaja, niahye Jesu tiquiro buheyequinare. ");
INSERT INTO pirNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","—‍¿Dʉhse ye mari ohõre masa marienopʉre pãre boca ohoboagari mari? niahye Jesu buheyequina tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","—‍¿Nohope paca pã pacare cʉoajari mʉsa? ni sinituahye Jesu. —‍Siete pã paca ijire, niahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Sa yero tiquiro masare yehpapʉ duji duti, siete pã pacare ne, Cohãcjʉ̃re “Quehnoare”, niahye. Sa ni tuhasa, ti pacare nuha, tiquiro buheyequinare oho, masare iti dutiahye. Tiquiro sa dutiri bato tiquiro buheyequina pehe pãre masare itiahye. ");
INSERT INTO pirNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Sa ye wahi gʉ̃hʉre meheñequinagã cʉoahye tiquina. Sa yero tiquinare Cohãcjʉ̃re “Quehnoare”, ni, wahi gʉ̃hʉre iti dutiahye. ");
INSERT INTO pirNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Tiquina iti tuhasagʉ̃ tiquina ihyaye, yapi yʉhdʉa wahahye. Tiquina ihya dʉharire siete pʉhʉse waro ne cahmecoa wahpo dapoahye tiquina. Tiquina cuatro mil masa ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","10","Sa ye tuhasa Jesu masare cohe tiahye. Cohe ti tuhasa tiquiro buheyequina mehna yucʉsapʉ sajãhye. Sajã tuhasa Dalmanuta wame tiri maca cahapʉ wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Sa ye fariseo masa wihi, Jesu mehna cahme dʉse tutuahye. Tiquina Jesure Cohãcjʉ̃ tutuaye mehna ye ihño dutiye, tiquiro ye ihño masiedagʉ̃ ihña duamahye. ");
INSERT INTO pirNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Tiquina sa dutigʉ̃ tʉhoro Jesu tutuaro bʉjʉa witi pihopũri, jeri sajãedaro, ohõ saha niahye: —‍¿Mʉsa yojopʉ cjãna dʉhse yena mʉsa Cohãcjʉ̃ tutuaye mehna ye ihñoñene ihña duajari? Potota niita niaja mʉsare. Yojopʉ cjãnare mʉsare Cohãcjʉ̃ tutuaye mehna ne ye ihñosi yʉhʉ, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Sa ni tuhasa waha, pari turi yucʉsapʉ sajã, ape sie pahrẽpʉ pehãa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Sa wahaye, pãre bo cũ, yucʉsapʉ ihcãriata pãre cʉoahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Sa yero Jesu cua pesaro mehna yahuahye tiquinare. —‍Quehnoano yeya. Fariseo masa, Herode mehna cjẽna gʉ̃hʉ tiquina ye pãre pugʉ̃ yeyere ihñana quehnoano yeya. Cuarĩne ti, ni yahuahye. ");
INSERT INTO pirNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Tiquiro sa nigʉ̃ tʉhoye tiquiro buheyequina pehe tire tiquina basi yahuducuahye. —‍Mari pãre mari ne cãhtaeragʉ̃ ihñano sa niaga ahriquiro, nimahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Tiquina sa nidire masino tiquinare sinituahye Jesu: —‍¿Dʉhse yena mʉsa pã borire wacũajari mʉsa? ¿Mʉsa masiedajari? ¿Tʉhoerajari? ¿Tʉho duerajari mʉsa? ");
INSERT INTO pirNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Caperi tina ijiepenata ihñedajari mʉsa? ¿Sa yena cahmono tina ijiepenata tʉhoerajari mʉsa? ¿Mʉsa ahrire wacũedajari? ");
INSERT INTO pirNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","¿Yʉhʉ ihcã omope paca pã pacare nuha, cinco mil masare yʉhʉ ohorire wacũedajari mʉsa? ¿Tiquina ihya dʉharire nohope pʉhʉsere pã pacare mʉsa ne cahmecoa wahpo dapori pʉhʉsere neari mʉsa? niahye Jesu tiquinare. —‍Doce pʉhʉse nei, niahye tiquina tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—‍¿Sa ye yʉhʉ siete pã pacare cuatro mil masare yʉhʉ ohori bato nohope pʉhʉsere pã pacare mʉsa wahpo dapori pʉhʉsere neari mʉsa? niahye Jesu. —‍Siete pʉhʉse nei, niahye tiquina tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","—‍¿Sa ihñaepenata quehnoano masiedajari mʉsa? niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Sa ye Betsaidapʉ tiquina esagʉ̃ ihñañe, masa pehe caperi bajueriquirore ne cãhtahye. —‍Tiquirore ña peoya, ni tutuaro siniahye tiquina Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Sa yero Jesu caperi bajueriquiro omocare ñehe, ti maca dʉhtʉ cahapʉ tiquirore tʉã cãhye. Topʉ ne sa, tiquiro caperire sihco puti, tiquiro omocari mehna tiquirore ña peoahye. —‍¿Mʉhʉ ihñagʉ̃ bajuajari? ni sinituahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Tiquiro sa nigʉ̃ tiquiro pehe ihñano ohõ saha niahye: —‍Ʉmʉare ihñaja. Yʉhʉ sa ihñaepegʉ̃ta tiquina yucʉri tiniñe cjʉ yero saha bajure, niahye caperi bajueriquiro. ");
INSERT INTO pirNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Tiquiro sa nigʉ̃ tʉhoro Jesu pehe tiquiro omocari mehna tiquiro caperire ña peoahye tja. Tiquiro sa ña peori bato caperi bajueriquiro tutuaro tiquiro ihñagʉ̃ caperi quehnoano bajuahye. Sa yero ijipihtiyere quehnoano ihñahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Sa yero Jesu tiquirore tiquiro ya wʉhʉpʉ ohoahye. —‍Macapʉ pũritare wahaeracãhña, niahye Jesu tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Sa ye Jesu tiquiro buheyequina mehna Cesarea Filipo wame tiri maca cahapʉ ijiye macaripʉ waha nemoahye. Topʉ waharo Jesu sinituahye tiquiro buheyequinare: —‍¿Noa boro ijiagari yʉhʉ, masa yʉhʉre tiquina tʉhotugʉ̃? ni sinituahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Tiquiro sa sinitugʉ̃ tʉhoye yʉhtiahye tiquina: —‍“Ñu wame yeriquiro ijire”, nine. Apequina “Elia ijire”, nine. Apequina “Cohãcjʉ̃ yere yahu mʉhtariquina mehna cjʉ̃no ijiboaga”, nine, ni yʉhtiahye tiquiro buheyequina tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Tiquiro sa nidi bato Jesu sinitu nemoahye: —‍¿Mʉsa pehe tʉhotugʉ̃ noa boro ijiagari yʉhʉ? ni sinituahye tja. —‍Mʉhʉ Cristo Cohãcjʉ̃ ohorigʉ ijire, ni yʉhtiahye Pedro. ");
INSERT INTO pirNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Tiquiro sa nigʉ̃ tʉhoro Jesu ohõ saha niahye: —‍Yʉhʉre “Cristo ijire tiquiro”, ni yahu site niedacãhña apequinapʉre, niahye tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Sa ye tiquiro buhe dʉcahye tiquinare. —‍Yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ ijiaja. Sa yegʉ tutuaro ñano yʉhdʉgʉta. Sata waharo cahmene yʉhʉre. Judio masa bʉcʉna, pahia pʉhtoa, mari judio masare buheyequina yʉhʉre cahmedaye, yʉhʉre wejẽeta. Tiquina sa wejẽgʉ̃ ihtia deco wahaboro masa wijiagʉtja, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Sa nino ne tʉho wisiagʉ̃ yero marieno yahuro niahye tiquinare. Tiquiro sa nigʉ̃ tʉhoro Pedro pehe yoa cjũnogã Jesure ne sadʉca, tiquirore sa ni dutierahye. ");
INSERT INTO pirNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Tiquiro sa ni dutieragʉ̃ tʉhoro Jesu tiquiro buheyequinare majare ihña, tuhtiahye Pedrore. —‍Satana yero saha yahuducugʉ nine mʉhʉ. Sa niedacãhña. Mʉhʉ tʉhotuye masa ye ijire. Cohãcjʉ̃ ye ijierare, niahye tiquiro Pedrore. ");
INSERT INTO pirNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Sa ni tuhasa masare tiquiro buheyequina mehna tiquiro cahapʉ pijio ohõ saha niahye: —‍Ihcãquiro yaquiro iji duaro, tiquiro esa tuharo ye duamedire duhu cãnota. Sa yero yaquiro tiquiro ijiri buhiri ñano yʉhdʉeperota yʉhʉre duhusi. Sa yero yeere yeducuriquiro ijirota. ");
INSERT INTO pirNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Masʉno tiquiro esa tuharo tiquiro cahmeno sahata yeriquiro pecapʉ waharota. Sa yero masʉno, yeere sa yeducuro, quehnoañe buheyere sa yeducuro, ijipihtiye decori yʉhʉ mehna ʉhmʉsepʉ ijiducurota. ");
INSERT INTO pirNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Ihcãquiro masʉno ahri yehpa cjẽne ijipihtiyere cʉoriquiro pecapʉ waharo yabere wapatajari tiquiro? Sa ijiriquiro ne wapataerare. ");
INSERT INTO pirNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Pecapʉ tiquiro jeripohna wahagʉ̃ ne dʉhse wapa ye wioro basioeraga. Masʉno jeripohna ihyo waro ijierare. ");
INSERT INTO pirNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Yojopʉre, ñañequina Cohãcjʉ̃re cahmeeñequina tiquina esa tuharo yeri deco ijiro nine. Ihquẽquina yʉhʉre, yʉhʉ buheye gʉ̃hʉre bʉe tisãboaga. Tiquina sa yegʉ̃ ihñagʉ yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ quehnoañequina angele mehna yʉhʉ Pacʉ asi sitero mehna tojoa tagʉ yʉhʉre bʉe tisãñequinare bʉe tisãgʉtja yʉhʉ gʉ̃hʉ, ni yahuahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Sa ni tuhasa ohõ saha ni nemoahye Jesu: —‍Potota niita niaja mʉsare. Ihquẽquina mʉsa ohõpʉre ijina mʉsa yariato pano Cohãcjʉ̃ tiquiro pʉhtoro ijiropʉre yʉhʉ sajãgʉ̃ yʉhʉre ihñanata, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Sa ye seis decori bato Jesu Pedrore, Santiagore, tiquiro bahʉro Ñu gʉ̃hʉre ʉhmʉanʉ cʉnʉpʉ tiquina dihitare piji mʉjahye. Ʉhmʉanopʉ esari bato tiquina ihñonopʉ tiquiro pagʉre camesaa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Tiquiro suhtiro asi sitero yero saha yehsero wahahye. Ahri yehpa cjẽna numia suhti coseyequina numia sa yehseye ye masiedare. ");
INSERT INTO pirNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Sa ye Jesu Elia mʉnano, Moise mʉnano mehna tiquina yahuducugʉ̃ ihñahye tiquina ihtiaro tiquiro buheyequina. ");
INSERT INTO pirNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Sa ye tiquina tutuaro cueahye. Sa cuero dʉhse ni masiedamehno ohõ saha nimahye Pedro: —‍Pʉhto, mari ohõ ijigʉ̃ quehnoa duare. Ihtia wʉhʉgã yenatja. Mʉhʉ ya wʉhʉgã, Moise ya wʉhʉgã, Elia ya wʉhʉgã yenatja, nimahye tiquiro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Sa yero tiquina bui ehmeo curua cahmotahye. Sa cahmotagʉ̃ta ehmeo watoapʉ nino ca tahye: —‍Ahriquiro yʉhʉ macʉ yʉhʉ cahĩniquiro ijire. Tʉhoya tiquirore, nino ca tahye. ");
INSERT INTO pirNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Sa nigʉ̃ta Pedro gʉ̃hʉ ihñamahye. Jesu dihitare ihñahye. Tiquina ihñariquina pehe mariedahye. ");
INSERT INTO pirNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Sa yero cʉnʉpʉ tiquina dijia tagʉ̃ Jesu tiquinare yahuahye: —‍Mianogã yʉhʉre sa waharire apequinare yahueracãhña. Yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ yʉhʉ yaria masa wijiari bato tire apequinare yahuya mʉsa, ni yahuahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Sa ye tiquiro dutiriro sahata tiquina ihñarire yahuerahye apequinare. Sa ye tiquina basi ohõ saha ni sinitu yahuducuahye: —‍¿“Yʉhʉ yaria masa wijiari bato”, nino dʉhse nino niari tiquiro? ni, yahuducuahye tiquina. Sa ye Jesure ohõ saha ni sinituahye: ");
INSERT INTO pirNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","—‍“Cristo tiquiro ahtato pano Eliare ahta mʉhtano cahmene”, nine mari acaye judio masare buheyequina. ¿Dʉhse ijiro boro sa niagari tiquina? ni sinituahye tiquina tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Jesu yʉhtiahye: —‍Ijirota ijire. Eliare ahta mʉhta dutiri Cohãcjʉ̃, ijipihtiyere quehno mʉhtatiquirore. Yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ peye tahari ñano yʉhdʉgʉta. Apequina yʉhʉre cahmedaye, ñano yeeta. ¿Dʉhse ijiro boro tire sa ni ojoari, mʉsa tʉhotugʉ̃? Sa yegʉ ahrire niitja mʉsare: Elia wihi tuhasari. Tiquiro sa wihiepegʉ̃ta tiquina cahmediro saha tiquirore ñano yeahye. Sata ni ojoahye tiquirore, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Sa ye dijia ta, apequina buheyequina cahapʉ esa, peyequina masare ihñahye. Tiquiro buheyequina pehe judio masare buheyequina mehna cahme dʉse tutuaye niahye. ");
INSERT INTO pirNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Sa ye Jesu gʉ̃hʉ tiquina dijia tagʉ̃ ihñañe, ijipihtiyequina masa acʉa waha, tiquiro cahapʉ oma cãa wahahye. Tiquiro cahapʉ esaye, —‍¿Ahtajari? niahye tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","—‍Ahtaja, ni tuhasa, —‍¿Dʉhse ni cahme dʉse tutuana niari mʉsa tiquina mehna? ni sinituahye Jesu tiquiro buheyequinare. ");
INSERT INTO pirNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Tiquiro sa ni sinitugʉ̃ tʉhoro, masa watoa ducuriquiro yahuahye tiquirore: —‍Buhegʉ, yʉhʉ macʉre watĩno cʉoriquirore mʉhʉre ne cãhtami. Watĩno pehe tiquirore yahuducu dutierare. ");
INSERT INTO pirNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Yʉhʉ macʉre tiquiro ñehegʉ̃ yehpapʉ bora, bahque diho, bʉhaa wahae tiri tiquiro. Sa waharo sahpo tua wahae tiri. Sa yegʉ mʉhʉ buheyequinare watĩnore cohã dutimi. Yʉhʉ sa dutiepegʉ̃ta tiquina cohã masiedari watĩnore, ni yahuahye Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Tiquiro sa nigʉ̃ tʉhoro Jesu ohõ saha niahye tiquinare: —‍Ne, yʉhʉre wacũ tutuerare mʉsa. Yoari pje mʉsare buhemaja yʉhʉ. ¿Noho puno yoari pje yʉhʉre mʉsa cariboajari? Tiquirore ne cãhtaya yʉhʉre, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Tiquiro sa nigʉ̃ tʉhoye watĩno cʉoriquirore Jesu caha ne cãhtahye. Tiquina ne wihigʉ̃ ihñano watĩno pehe coã wahmʉa cãhtariquirore yehpapʉ doque quehe sa, tunu nanaregʉ̃ yeahye. Sa yero sahpo tuaa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","—‍¿Noho puno yoari pje watĩnore cʉoajari ahriquiro? ni, sinituahye Jesu pehe tiquiro pacʉrore. —‍Nijinogã ijiropʉta tiquirore cʉo dʉcari. ");
INSERT INTO pirNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Sa yero watĩno pehe tiquirore pecapʉ, acopʉ cohã wejẽmedi. Sa yegʉ mʉhʉ ye masigʉ ʉsãre paja ihña, yedohoya, niahye tiquiro pacʉro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Tiquiro sa nigʉ̃ tʉhoro ohõ saha niahye Jesu: —‍¿“Mʉhʉ ye masiegʉ ijire”, niajari mʉhʉ yʉhʉre? Yʉhʉre mʉhʉ wacũ tutuagʉ̃ ihñano, Cohãcjʉ̃ ijipihtiyere ye peho masine, mʉhʉre yedohoro, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tiquiro sa nigʉ̃ta coã wahmʉa cãhtariquiro pacʉro ohõ saha ni sañuducuahye: —‍Mʉhʉre wacũ tutuaja. Yʉhʉ wacũ tutueragʉ̃ ihñagʉ yʉhʉre yedohoya mʉhʉre yʉhʉ wacũ tutuato saha, niahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Sa yero masa peyequina tiquina cahapʉ oma cãhta, tiquina cahmecoagʉ̃ ihñano, Jesu watĩnore ohõ saha ni tuhtiahye: —‍Mʉhʉ yahuducu dutiegʉ, tʉho dutiegʉ ahriquiro mehna ijirigʉ wahaya. Sa wahagʉ tiquirore pari turi cariboeracãhña, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Tiquiro sa nigʉ̃ tʉhoro watĩno sañuducu, coã wahmʉa cãhtariquirore yehpapʉ doque quehe sa tunu nanaregʉ̃ ye, wahahye. Tiquiro sa yegʉ̃ coã wahmʉa cãhtariquiro yariariquiro yero saha wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","—‍Tiquiro yariaa wahare, nimahye masa peyequina. Tiquina sa niepegʉ̃ta Jesu pehe tiquiro omocare ñehe, tiquirore wahcõahye. Tiquiro sa wahcõgʉ̃ wahcãhye tiquiro pehe. ");
INSERT INTO pirNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Came Jesu gʉ̃hʉ wʉhʉpʉ tiquina sajã sagʉ̃ tiquiro buheyequina tiquirore sinituahye: —‍¿Dʉhse yena ʉsã pehe watĩnore cohã masiedayari, mʉhʉ tʉhotugʉ̃? ni sinituahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","—‍Ahriquiro boro watĩnore cohã duana Cohãcjʉ̃re tutuaro sinino cahmene mʉsare, ni yʉhtiahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Sa ye topʉ ijiriquina waha, Galilea yehpapʉ esa, yʉhdʉa wahahye. Topʉ tiquina waharire apequina masigʉ̃ cahmedahye Jesu tiquiro yequinare buhero taro. ");
INSERT INTO pirNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Topʉ esaro tiquiro buheyequinare buheahye. Ohõ saha ni buheahye: —‍Yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ ijiaja. Masa yʉhʉre ñehe, apequinapʉre yʉhʉre ohoeta. Tiquina sa ohori bato yʉhʉre wejẽeta. Tiquina sa wejõrigʉ ijiepegʉta ihtia deco wahaboro masa wijiagʉtja, niahye tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Tiquiro sa nigʉ̃ tʉhoye tiquina quehnoano tʉho ñehedahye. Sa ye cueye, tiquirore tire sinitu nemoedahye. ");
INSERT INTO pirNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Sa ye Capernaupʉ tiquina esari bato wʉhʉpʉ tiquina ijigʉ̃ Jesu pehe sinituahye tiquinare. —‍¿Mahapʉre ahtana, dʉhse ni yahuducu cãhtana niari mʉsa? ni, sinituahye tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Tiquiro sa sinitugʉ̃ tiquina yʉhtierahye. Mahapʉre ahtaye, cahme ohõ saha ni yahuducu cãhtaye niahye: —‍¿Mari mehna cjʉ̃nore diquiro pehere mari pʉhtoro sõnatari mari? ni yahuducuye niahye mahapʉre ahtaye. ");
INSERT INTO pirNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Sa ye tiquina sa nidire bʉe tiye Jesure yʉhtierahye. Tiquina sa yʉhtieragʉ̃ ihñano Jesu nuju sa, tiquiro buheyequinare doce buheyequinare pijio ohõ saha niahye: —‍Mʉsa pʉhtoa iji duana ijipihtiyequina masa tiquina cahacjãna ijiro cahmene mʉsare. Sa yena ihyo ijina ijipihtiyequina docapʉ ijinata mʉsa, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Sa nino nijinogãre tiquina watoa duhu docoahye. Duhu doco tuhasa tiquirogãre ne wʉa, ohõ saha ni yahuahye: ");
INSERT INTO pirNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—‍Yeere ye duana ahriquirogãre mʉsa cahmena, yʉhʉ gʉ̃hʉre cahmene mʉsa. Sa yena yʉhʉre cahmena, yʉhʉre ohoriquiro mari Pacʉ gʉ̃hʉre cahmene mʉsa, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Came Ñu ohõ saha niahye Jesure: —‍Buhegʉ, mʉhʉ wame mehna watĩare cohãriquirore ʉsã ihñaʉ. Mari mehna cjʉ̃no tiquiro ijieragʉ̃ ihñana tire tiquirore ye dutierahti ʉsã, niahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Tiquina sa nigʉ̃ tʉhoro Jesu tiquinare yahuahye: —‍Sa niedacãhña mʉsa tiquirore. Ihcãquiro yʉhʉ wame mehna Cohãcjʉ̃ tutuaye mehna yero, came yʉhʉre ñano ni yahuducu masiedare. ");
INSERT INTO pirNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Marine ihña tuhtiriquiro ijieraro, tiquiro mari mehna cjʉ̃no ijire. ");
INSERT INTO pirNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Mʉsare potota nii niaja. Yeequina mʉsa ijigʉ̃ ihñañe apequina mʉsare tiquina yedohogʉ̃ ihñano Cohãcjʉ̃ tiquinare quehnoano yerota. Acore mʉsare tiquina mehenogã sihõgʉ̃ tiquinare quehnoano yerota Cohãcjʉ̃ tiquina sa yeri wapa, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Sa yero Jesu yahu nemoahye: —‍Ahriquirogã yero saha ijiriquirore yʉhʉre wacũ tutua dʉcariquirore yahugʉtja mʉsare. Apequiro ahriquirogã yero saha ijiriquirore ñañene ye dutiro tiquiro ña yʉhdʉaro yʉhdʉrota. Ihcãquirore tiquiro wamʉapʉ pajiria ʉtãre dʉhte yo, pajiri mapʉ tiquirore tiquina cohãgʉ̃ ñano wahaboaga tiquiro. Sa ijiepegʉ̃ta ahriquirogã yero saha ijiriquirore ñañene ye dutiriquiro tiquiro pehe pajiri mapʉ tiquina cohãriquiro yʉhdʉoro ñano yʉhdʉrota. ");
INSERT INTO pirNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Mʉhʉ omoca mehna ñano yegʉ ti omocare mʉhʉ dʉte cohãboriro saha ti mʉhʉ ñano yeye pehere duhuya. Tire duhueragʉ pecapʉ wahagʉta. Topʉre ne peca yatierare. Sa ye becoa ne yarierare. Mʉhʉ omocare cohãgʉ ti si dihita butiboaga. Sa yegʉ mʉhʉ pehe sa bajuri turu ijiepegʉta came Cohãcjʉ̃ mehna ijigʉta. Pʉa omoca mehna pecapʉ wahagʉ mʉhʉ sa wahagʉ̃ ña yʉhdʉaboaga. Sa yegʉ ti mʉhʉ ñano yeye pehere duhuya. ");
INSERT INTO pirNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Mʉhʉ dahpocã mehna ñano yegʉ ti dahpocã gʉ̃hʉre mʉhʉ dʉte cohãboriro saha ti mʉhʉ ñano yeye pehere duhuya. Tire duhueragʉ pecapʉ wahagʉta. Topʉre ne peca yatierare. Sa ye becoa ne yarierare. Mʉhʉ dahpocãre mʉhʉ cohãgʉ̃ ti si dihita butiboaga. Sa yegʉ sa bajuri turu ijiepegʉta came Cohãcjʉ̃ mehna ijigʉta. Pʉa dahpocã mehna pecapʉ wahagʉ mʉhʉ sa wahagʉ̃ ña yʉhdʉaboaga. Sa yegʉ ti mʉhʉ ñano yeye pehere duhuya. ");
INSERT INTO pirNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","48","Mʉhʉ capea mehna ñano yegʉ tiare ore we mʉhʉ cohãboriro saha ti mʉhʉ ñano yeye pehere duhuya. Tire duhueragʉ pecapʉ wahagʉta. Topʉre ne peca yatierare. Sa ye becoa ne yarierare. Tiare mʉhʉ cohãgʉ̃ tia dihita butiboaga. Ihcã capea mariedapegʉ̃ta came Cohãcjʉ̃ mehna ijigʉta. Pʉa capea mehna pecapʉ wahagʉ mʉhʉ sa wahagʉ̃ ña yʉhdʉaboaga. Sa yegʉ ti mʉhʉ ñano yeye pehere duhuya. ");
INSERT INTO pirNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Ahri yehpapʉ ijina ñano yʉhdʉnata mʉsa. Pecapʉ mari ʉjʉ̃gʉ̃ marine purĩno saha ñano yʉhdʉnata mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Moa quehnoano ocare. Moa ocaeragʉ̃ ti moare ocagʉ̃ yero basioerare. Moa ocaeraro ti moa ne quehnoaedare. Ti moare dʉhsero basioerare. Sa ijigʉ̃ ihñana ti moare cohãno cahmene. Moa quehnoano ti ocaro saha mʉsa gʉ̃hʉ masa quehnoana ijiya. Sa yena apequina mehna quehnoano mehna ijiya, ni yahuahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Sa ye tiquiro topʉ ijiriquiro waha, Judea yehpa cahapʉ esa, Jordã wame tiri ma ape sie pahrẽpʉ esahye. Topʉ tiquiro esagʉ̃ ihñañe masa peyequina tiquiro cahapʉ cahmecoahye tja. Tiquina sa cahmecoagʉ̃ ihñano to pano tiquiro buheriro sahata pari turi buheahye tja. ");
INSERT INTO pirNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tiquiro sa buheri watoa fariseo masa wihiahye. Jesure ñano tiquiro yahuducugʉ̃ tʉho duamahye tiquina. Sa tʉho duaye tiquina Jesure sinituahye. —‍¿Mari namosãnumiare cohãgʉ̃ quehnoaboagari? ¿Mari dutiye pehe sata ye dutiajari, mʉhʉ tʉhotugʉ̃? ni sinituahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","—‍¿Dʉhse ye dutiajari to Moise mʉsare tiquiro cũri? ni yʉhtiahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","—‍“Papera pũre mʉsa cohãñene yahuyere ojoana mʉsa namosãnumiare cohã masine”, niahye Moise, ni yʉhtiahye fariseo masa pehe. ");
INSERT INTO pirNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Tiquina sa nigʉ̃ tʉhoro ohõ saha ni yahuahye Jesu: —‍Cohãcjʉ̃ dutiyere mʉsa ye dueragʉ̃ ihñano sa ni ojoahye Moise. ");
INSERT INTO pirNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Tiquiro sa ni ojoari ijiepegʉ̃ta ahri yehpare bajumehnediquiro ʉmʉno, numino gʉ̃hʉre yeahye. ");
INSERT INTO pirNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Sa yero ʉmʉno tiquiro pacʉsʉmʉare cohã wijia, tiquiro namono mehna ijirota. ");
INSERT INTO pirNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Sa ye tiquina pʉaro ijiepeta ihcã pagʉ yero saha ijire. Sa ye tiquina pʉaro yero saha ijierare. Ihcã pagʉ yero saha ijiye nine. ");
INSERT INTO pirNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Cohãcjʉ̃ tiquiro omoca dʉhte dutiriquina ijire. Sa ye tiquinare cahme duhueraro cahmene, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Sa ni tuhasa tiquiro buheyequina mehna wʉhʉpʉ sajãa wahahye. Wʉhʉpʉ sajã sa, tiquina namosãnumiare cohãñene tiquiro buheyequina sinituahye tja tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Tiquina sa sinitugʉ̃ tiquiro yʉhtiahye: —‍Tiquiro namonore cohãriquiro apecorore namo tiro, apecoro mehna ñano yeriquiro ijire. Sa yero tiquiro cohãricorore ñano wahagʉ̃ yero nine. ");
INSERT INTO pirNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Sa yero numino pehe ticoro manʉnore cohãno, apequirore manʉ tiro, tiquiro mehna ñano yericoro ijire, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Sa ye macanagãre Jesure ña peo dutiye tehe tiquinagãre Jesu cahapʉ ne cãhtaye niahye. Tiquina sa yegʉ̃ ihñañe tiquiro buheyequina pehe tiquinagãre ne cãhtayequinare tuhtiahye. ");
INSERT INTO pirNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Tiquina sa tuhtigʉ̃ ihñano Jesu usuaro, ohõ saha niahye tiquinare: —‍Macanagã yʉhʉ cahapʉ ahtaahro. “Waharĩsa”, niedacãhña tiquinagãre. Tiquinagã Cohãcjʉ̃re tiquina pʉhtoro tʉhoture. Sa ye Cohãcjʉ̃ tiquiro pʉhtoro ijiropʉre ahriquinagã yero saha tʉhotuyequina ijire topʉre. ");
INSERT INTO pirNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ijirota niita niaja mʉsare. Ahriquinagã Cohãcjʉ̃re tiquina cahmeno saha mʉsa pehe cahmedana, tiquiro cahapʉ wahasi mʉsa. Mʉsa wahaeragʉ̃ mʉsa pʉhtoro ijisi tiquiro, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Sa ni tuhasa Jesu macanagãre ne wʉa, tiquinagãre ña peoro ohõ saha niahye: —‍Ahriquinagã quehnoañequina wahaahro, ni sini basahye Cohãcjʉ̃re. ");
INSERT INTO pirNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Sa ye Jesu mahapʉ tiquiro wahaducugʉ̃ apequiro pehe oma cã, tiquiro dahpocãri cahapʉ dʉsepe curi mehna quehe sahye tiquirore ño peoro. —‍¿Ne, quehnoagʉ buhegʉ, yʉhʉ ijipihtiye decori Cohãcjʉ̃ mehna iji duagʉ dʉhse yegʉtari yʉhʉ? niahye tiquiro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Tiquiro sa nigʉ̃ Jesu yʉhtiahye: —‍¿Dʉhse ijiro boro yʉhʉre “Quehnoagʉ”, ni pisuajari mʉhʉ? Cohãcjʉ̃ dihita quehnoariquiro ijire. ");
INSERT INTO pirNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ahri Cohãcjʉ̃ dutiyere masine mʉhʉ: Masare wejẽdacãhña. Wʉana tieracãhña. Yaqueracãhña. Ni mehoedacãhña. Apequina yere ni meho nedacãhña. Mʉsa pacʉsʉmʉare ño peoya. Ahri dutiyere yero cahmene masare, ni yahuahye Jesu tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","—‍Buhegʉ, tire ijipihtiyere coã wahmʉa cãhtagʉ ijigʉpʉta yʉhdʉdʉcaera tii yʉhʉ, niahye tiquiro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Tiquiro sa nigʉ̃ tʉhoro Jesu pehe tiquirore ihñadoque ohõ, cahĩahye. Sa yero ohõ saha niahye: —‍Mehenogã dʉhsare mʉhʉre mʉhʉ ye pehoato. Ijipihtiyere mʉhʉ yere duagʉ wahaya. Sa yegʉ ijipihtiye mʉhʉ wapatari niñerure pejecʉoyequinare ohoya. Mʉhʉ sa yegʉ̃ pajiro mʉhʉ ye ʉhmʉsepʉ, Cohãcjʉ̃ cahapʉ ijirota. Mʉhʉ sa yeri bato yʉhʉ mehna cjʉ̃ ijiacjʉ ahtaya, niahye Jesu tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Tiquiro sa nigʉ̃ tʉhoro tiquiro pehe peye doeri cjẽ cʉoriquiro ijiro tire pejecʉoyequinare oho dueraro, bʉjʉa witi, coaera, wahaa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Tiquiro sa bʉjʉa witigʉ̃ ihñano Jesu majaredʉca sa, tiquiro buheyequinare ihñadoque ohõ, ohõ saha niahye: —‍Doeri cjẽ cʉoyequina Cohãcjʉ̃ pʉhtoro ijiropʉre tiquinare waharo basioera cjũre, niahye tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Tiquiro sa nigʉ̃ tʉhoye tiquina pehe tiquirore tʉho maria wahahye. Sa ni tuhasa Jesu pari turi yahuahye tiquinare: —‍Yʉhʉ acaye, ijipihtiyequina doeri cjẽ opana Cohãcjʉ̃re wacũno marieno Cohãcjʉ̃ pʉhtoro ijiropʉ tiquinare waharo basioerare. ");
INSERT INTO pirNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Camello pehe awia copepʉ tiquiro sajã duagʉ̃ basioerare. Tiquiro sa ijiro yʉhdʉoro doeri cjẽ cʉoriquirore Cohãcjʉ̃re wacũno marieno Cohãcjʉ̃ pʉhtoro tiquiro ijiropʉre tiquirore waharo basioerare, ni yahuahye tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Tiquiro sa nigʉ̃ tʉhoye to pano tiquina tʉho mariariro yʉhdʉoro tʉho maria waha, tiquina basi ohõ saha niahye: —‍Yohou, tiquiro nino sahata potota ijigʉ̃ ne ihcãquiro masʉnore yʉhdʉoeraboaga Cohãcjʉ̃, niahye tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Tiquina sa nigʉ̃ tʉhoro Jesu tiquinare ihñadoque ohõ, ohõ saha niahye: —‍Masa tiquina esa tuharo quehnoano yeri mehna Cohãcjʉ̃ cahapʉ waha masiedare. Cohãcjʉ̃ pehe masare pecapʉ wahaboriquinare yʉhdʉo masine. Tiquiro ijipihtiyere quehnoano ye masi peho cãhre, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Tiquiro sa nigʉ̃ Pedro tiquirore ohõ saha niahye: —‍Tʉhorĩña. Ʉsã pehe ijipihtiye ʉsã yere cũ cãʉ mʉhʉ mehna wahana tana, niahye tiquiro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Tiquiro sa nigʉ̃ta Jesu ohõ saha niahye: —‍Ijirota niita niaja mʉsare. Quehnoañe buheyere, yeere yena tana yʉhʉre ño peona tana mʉsa wʉhʉsere, mʉsa bahanare, mʉsa pacʉsʉmʉare, mʉsa pohnare, mʉsa weserire cũrina ijina, pajiro wapatanata mʉsa yojopʉre. ");
INSERT INTO pirNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Sa yena mʉsa wʉhʉsere, mʉsa bahanare, mʉsa pacosãnumiare, mʉsa pohnare, weserire, to pano mʉsa cʉoriro yʉhdʉoro yojopʉre peye cʉonata mʉsa. Sa ye apequina mʉsare ñano yeeta. Sa yena camepʉre ape tjuropʉ ijipihtiye decori Cohãcjʉ̃ mehna ijinata. ");
INSERT INTO pirNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Yojopʉre peyequina pʉhtoa ijiriquina ti pjepʉre ihyo ijiyequina tojoaeta. Sa ye yojopʉre peyequina ihyo ijiyequina ijiriquina ti pjepʉre pʉhtoa camesaeta tja, ni yahuahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Sa ye tiquina mahapʉ maja, Jerusalẽpʉ mʉjañe niahye. Jesu tiquina panogã ʉhmʉ tãhye. Sa tiquiro ʉhmʉ tãgʉ̃ ihñañe tiquiro buheyequina ihña maria wahahye. Sa ye tiquina bato nʉnʉ tãriquina pehe cuero mehna nʉnʉ tãhye. Sa yero Jesu tiquiro buheyequinare tiquina sehsaro neahye tja. Sa yero masa tiquirore dʉhse yeatire Jesu yahu dʉcahye tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—‍Tʉhoya yʉhʉre. Yojopʉre Jerusalẽpʉ wahana niaja mari. Topʉ masa yʉhʉ masʉre Cohãcjʉ̃ ohorigʉre ñehe, apequinapʉre yʉhʉre ohoeta. Pahia pʉhtoare, mari acaye judio masare buheyequina gʉ̃hʉre yʉhʉre ohoeta. Sa ye yʉhʉre wejẽ dutieta tiquina. Sa wejẽ dutiye judio masa ijieyequina pehere yʉhʉre ohoeta. ");
INSERT INTO pirNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Tiquina sa ohori bato tiquina pehe yʉhʉre bʉjʉpe, sihco puti ohõ, tana, wejẽeta. Sa yegʉ yʉhʉ yariari bato ihtia deco wahaboro masa wijiagʉtja, ni yahuahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sa ye Santiago, Ñu mehna Jesu cahapʉ esaye, siniahye tiquirore. Tiquina Zebedeo pohne ijiahye. Sa ye ohõ saha ni siniahye: —‍Buhegʉ, ʉsã sinino saha ʉsãre yeya mʉhʉ, niahye tiquina Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","—‍¿Dʉhse yʉhʉ yegʉ̃ cahmeajari mʉsa? niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","—‍Ijipihtiyequina pʉhtoro ijigʉ ʉsãre mʉhʉ mehna duji dutiya. Ihcãquiro mʉhʉ poto pehe, apequiro mʉhʉ cũ pehe pehe duji dutiya ʉsãre, mʉhʉ mehna pʉhtoa ʉsã ijiato saha, niahye tiquina Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Tiquina sa nigʉ̃ tʉhoro ohõ saha ni yahuahye Jesu tiquinare: —‍Mʉsa ñano yʉhdʉatore masiedapenata sa sinine yʉhʉre. ¿Yojopʉre yʉhʉ ñano yʉhdʉato saha mʉsa gʉ̃hʉ ñano yʉhdʉna ihcãno sahaboagari? ni sinituahye tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Tiquiro sa sinitugʉ̃ tʉhoye tiquina yʉhtiahye: —‍Ihcãno sahanata, ni yʉhtiahye tiquina. Tiquina sa nigʉ̃ Jesu ohõ saha ni yahuahye: —‍Yʉhʉ ñano yʉhdʉato saha ñano yʉhdʉnata mʉsa gʉ̃hʉ. ");
INSERT INTO pirNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Mʉsa sa yʉhdʉanaja mʉsa ijiepegʉ̃ta, yʉhʉ mehna dutiatiquinare, yʉhʉ mehna dujiatiquinare bese masiedaja yʉhʉ. Ahrire yʉhʉ Pacʉ pehe quehno tuhasari. Sa ye tiquiro beseatiquina dihita yʉhʉ poto pehe yʉhʉ cũ pehe pehe dujieta, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Sa ye apequina pʉa omopequina buheyequina Santiago, Ñu ahriquina pʉaro mehna usuahye tiquina sa sinidire tʉhoye. ");
INSERT INTO pirNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Tiquina sa usuagʉ̃ ihñano Jesu tiquiro buheyequinare pijio ohõ saha niahye: —‍Cohãcjʉ̃re masieñequina pʉhtoa pehe tiquina masare dutiye, usuaro mehna dutire. ");
INSERT INTO pirNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Mʉsa pehe ne sa yesi mʉsa basi. Mʉsa mehna cjʉ̃no pʉhtoro iji duaro, ijipihtiyequina tiquiro mehna cjẽna cahacjʉ̃no ijiro cahmene tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Sa yero ijipihtiyequinare dutiriquiro iji duaro, apequina cahacjʉ̃no ijiro cahmene tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Sata ijigʉ ijiaja yʉhʉ gʉ̃hʉ. Yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ ijiepegʉta ahri yehpapʉ masare yedohogʉ ahtaʉ. Sa yegʉ peyequina masa ye buhirire yariagʉ ahtagʉ nii. Sa yegʉ peyequina masare pecapʉ wahaboriquinare yʉhdʉogʉ ahtagʉ nii. Masare dutipegʉ ahtagʉ niedʉ, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Sa ye tiquina Jericópʉ esahye. Sa yero Jesu tiquiro buheyequina, masa peyequina mehna ti macapʉ ijiyequina tiquina wahagʉ̃ Bartimeo pehe maha dʉhtʉ cahapʉ dujiahye. Tiquiro Timeo macʉno caperi bajueriquiro ijiro, decoripe masare niñerure siniducuriquiro ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Sa yero topʉ Jesu Nazare cjʉ̃no tiquiro cahapʉ ahtagʉ̃ tʉhoro Bartimeo ohõ saha ni sañuducuahye: —‍Jesu, Davi mʉnano panami iji turiagʉ, masare yʉhdʉoacjʉ, paja ihñaña yʉhʉre, ni sañuducuahye Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Tiquiro sa nigʉ̃ tʉhoye masa peyequina Bartimeore “Dihta mariahña”, ni tuhtiahye tiquina tiquirore. Tiquina sa tuhtigʉ̃ tʉhoro Bartimeo to pano tiquiro sañuducuriro yʉhdʉo cjũno sañuducu nemoahye tja: —‍Jesu, Davi mʉnano panami iji turiagʉ, masare yʉhdʉoacjʉ, paja ihñaña yʉhʉre, ni sañuducuahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Tiquiro sa ni sañuducugʉ̃ tʉhoro Jesu pehe esadʉca, “Pijiohya tiquirore”, niahye. Tiquiro sa nigʉ̃ tiquina pehe caperi bajueriquirore piji cãhye: —‍Bucueya. Wahcãdʉcaya. Tiquiro mʉhʉre pijiore, niahye tiquina Bartimeore. ");
INSERT INTO pirNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Tiquina sa nigʉ̃ tʉhoro tiquiro bui cjã suhtirore tu we cũ, uhpu yʉhdʉ cã, Jesu cahapʉ esadʉcahye. ");
INSERT INTO pirNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Sa yero Jesu sinituahye tiquirore. —‍¿Dʉhse yʉhʉ yegʉ̃ cahmeajari mʉhʉ? niahye Jesu tiquirore. —‍Yʉhʉ pʉhto, yʉhʉre ihñagʉ̃ yeya, niahye caperi bajueriquiro. ");
INSERT INTO pirNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","—‍Wahaya. Mʉhʉ yʉhʉre wacũ tutuagʉ quehnoa wahare, niahye Jesu tiquirore. Tiquiro sa nigʉ̃ta caperi bajueriquiro ihñaa wahahye. Sa quehnoa waharo Jesu mehna mahapʉ wahaa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Sa ye Jerusalẽpʉ tiquina esato panogã Betfagé wame tiri maca cahapʉ, Betania wame tiri maca cahapʉ ijidʉpʉ, Olivo wame tidʉ cʉnʉpʉ esa mʉhtahye. Topʉ esaro pʉarore tiquiro buheyequina mehna cjẽnare Jesu ohoro ohõ saha niahye: ");
INSERT INTO pirNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","—‍Si macapʉ wahaya. Topʉ esana duita burrogãre tiquina dʉhte docoriquirogãre bocanata. Apequina pesamehnediquirogã ijiaga. Tiquirogãre bocana, yuta dare pã, ne cãhta basaya yʉhʉre. ");
INSERT INTO pirNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mʉsa sa yegʉ̃ ihñano burrogã upʉro “¿Dʉhsena burrogãre pãjari?” tiquiro nigʉ̃ tʉhona, ohõ saha ni yʉhtiya tiquirore: “Mari pʉhtoro burrogãre cahmedoqueo nidi. Sa yero mianogãta wiarota tiquiro”, ni yahuya tiquirore, ni yahu duti ohoahye tiquiro buheyequinare pʉarore. ");
INSERT INTO pirNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Tiquiro sa nigʉ̃ waha, wʉhʉ cahapʉ ijiri mahapʉ sopecaha cahapʉ burrogãre tiquina dʉhte docoriquirogãre bocahye. ");
INSERT INTO pirNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Sa ye tiquirogãre yuta dare tiquina pãgʉ̃ ihñañe topʉ ducuyequina sinituahye tiquinare: —‍¿Dʉhse yena tana mʉsa yuta dare pãjari burrogãre? ni sinituahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Tiquina sa nigʉ̃ tʉhoye, tiquina pehe Jesu tiquiro nidiro sahata yahuahye topʉ ducuyequinare. Tiquina sa yahugʉ̃ tʉhoye topʉ ducuyequina pehe “Neahña”, niahye tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Sa ye tiquina burrogãre Jesu cahapʉ ne sahye. Tiquina ne sari bato tiquirogã bui tiquina suhtire duhu peo tuhasagʉ̃ ihñano, Jesu pehe tiquirogã bui mʉja pjeahye, waharo taro. ");
INSERT INTO pirNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Sa ye masa peyequina tiquina bui sañañe suhtire tu we ne, mahapʉ seõ cũ mʉhtahye, Jesure ño peoye. Apequina pehe pũri tiye dʉpʉrire weseripʉ tiquina ne cãhtari dʉpʉrire mahapʉ cũahye. ");
INSERT INTO pirNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Sa ye tiquiro pano wahayequina, tiquiro bato ahtayequina mehna ohõ saha ni sañuducuahye: —‍Ahriquirore ño peouhna. Ahriquiro Cohãcjʉ̃ tiquiro ohoriquiro quehnoano ijiahro. ");
INSERT INTO pirNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Mari ñecʉ iji turiariquiro Davi mʉnano pʉhtoro tiquiro ijiriro saha ahtariquiro quehnoano ijiahro. Ʉhmʉse cjʉ̃nore “Tutuagʉ ijire”, ni ño peouhna, ni sañuducuahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Sa yero Jesu Jerusalẽpʉ esaro Cohãcjʉ̃ ya wʉhʉpʉ sajã saro, ti wʉhʉpʉ ijiyere ijipihtiyere ihña peho cãhye. Ihña tuhasa “Ñamicahapʉ ijire. Deco cjũnota wahaʉhna”, nino, Jesu tiquiro buheyequina doce buheyequina mehna Betaniapʉ wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Sa ye ape deco tiquina Betaniapʉ ijiriquina wahaa wahahye. Sa yero Jesu pehe ʉjʉa ahbaa waha, yoaropʉ higuera wame tidʉre quehnoano pũri tidʉre ihñano tʉ dʉcare macano wahamahye. ");
INSERT INTO pirNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Dʉca mariedahye. Dʉca tiri pje ijieraro pũri dihita ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Sa yero dʉca mariedagʉ̃ ihñano ohõ saha niahye: —‍Ahdʉ dʉcare masa ne pari turi ihyeracãhdo. Ne dʉca tieracãhdo, niahye Jesu. Tiquiro sa nigʉ̃ tiquiro buheyequina pehe tʉhoahye. ");
INSERT INTO pirNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Tiquiro sa yeri bato tiquina Jerusalẽpʉ esahye. Topʉ esaro, Jesu Cohãcjʉ̃ ya wʉhʉpʉ sajã saro apee boro duayequinare, dúyequina gʉ̃hʉre cohã wioahye. Sa yero niñeru camesaye mesarire yo wahcõ, ne majare cũ mʉjahye. Bujuaare duayequina tiquina dujiye pahtari gʉ̃hʉre sata yeahye. ");
INSERT INTO pirNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Sa yero apee borore ne sajã dutierahye masare. ");
INSERT INTO pirNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Sa yero Jesu ohõ saha ni buheahye tiquinare: —‍Ohõ saha nine Cohãcjʉ̃ yere tiquina ojoari pũ: “Ya wʉhʉ Cohãcjʉ̃ mehna yahuducuri wʉhʉ wame tirota. Sa yero ijipihtiro cjẽna ya wʉhʉ ijirota”, ni ojoahye Cohãcjʉ̃ yere tiquina ojoari pũ. Ti pũ sa niepegʉ̃ta mʉsa pehe ahri wʉhʉpʉ duana, mʉsa basi cahme yaquere mʉsa, ni buheahye tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Tiquiro sa ni buhegʉ̃ ijipihtiyequina masa pehe tʉho maria wahahye. Sa ye pahia pʉhtoa, ʉsã judio masa buheyequina mehna tiquirore cue niahye. Sa ye tiquina tiquirore wejẽatire wacũ macamahye. ");
INSERT INTO pirNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Tiquina sa yegʉ̃ ñamicahapʉ Jesu tiquiro buheyequina mehna ti macapʉ ijiriquina wahaa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Sa ye bohrearo mahapʉ maja taye, higueragʉre ihñahye. Tʉ nʉhcoripʉ ñai dʉca, ñaia wahahye tʉ. ");
INSERT INTO pirNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Tʉre ihñano Pedro pehe wacũ, ohõ saha niahye: —‍Buhegʉ, ihñaña. Higueragʉ mʉhʉ yaria dutidʉ yaria wahaya, niahye Pedro. ");
INSERT INTO pirNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Tiquiro sa nigʉ̃ta Jesu yahuahye tiquinare: —‍Cohãcjʉ̃re wacũ tutuaya mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ijirota niita niaja mʉsare. Ahdʉ cʉnʉre pajiri mapʉ mʉsa cohã dutigʉ̃ mʉsa nidiro saha sa waharota. Cohãcjʉ̃re quehnoano mʉsa wacũ tutuagʉ̃ “Yʉhʉ sinidiro saha waharota”, mʉsa ni tʉhotugʉ̃ mʉsa nidiro saha waharota. ");
INSERT INTO pirNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Sa yegʉ ahrire yahugʉtja mʉsare. Cohãcjʉ̃ mehna yahuducuna, tiquirore sinina, “Yʉhʉ sinidiro saha ohorota yʉhʉre”, ni tʉhotuya. Mʉsa sa yegʉ̃ ihñano Cohãcjʉ̃ mʉsa siniñene ohorota. ");
INSERT INTO pirNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Sa yena Cohãcjʉ̃ mehna mʉsa yahuducuato pano mʉsare apequina tiquina ñano yegʉ̃ mʉsa usuarire duhuya. Mʉsa sa yegʉ̃ ihñano mari Pacʉ ʉhmʉse cjʉ̃no mʉsa ñañe yeri pehere tiquiro gʉ̃hʉ usua duhurota.  ");
INSERT INTO pirNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Mʉsare ñano yeriquinare mʉsa usua duhueragʉ̃ mari Pacʉ gʉ̃hʉ ʉhmʉse cjʉ̃no mʉsa ñañe yeri pehere usuaro ne duhusi tiquiro gʉ̃hʉ, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Tiquiro sa nidi bato tiquina Jerusalẽpʉ wahahye tja. Sa ye Jesu Cohãcjʉ̃ wʉhʉpʉ tiquiro tinigʉ̃ ihñañe pahia pʉhtoa, ʉsã judio masare buheyequina, bʉcʉna gʉ̃hʉ tiquiro cahapʉ esaye, tiquirore sinituahye: ");
INSERT INTO pirNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","—‍¿Dʉhsegʉ canʉre sa yeari mʉhʉ? ¿Noa mʉhʉre tire sa ye dutiari? ni sinituahye tiquina Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Tiquina sa nigʉ̃ Jesu yʉhtiahye: —‍Mʉsa pehere sinitu mʉhtagʉtja. Quehnoano yʉhʉre mʉsa yʉhtigʉ̃ mʉsare yahugʉtja yʉhʉ gʉ̃hʉ. ");
INSERT INTO pirNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Ñu masare tiquiro wame yegʉ̃ noa boro pehe tiquirore wame ye dutiyari, mʉsa tʉhotugʉ̃? ¿O Cohãcjʉ̃ dutierayari? ¿O masa pehe tiquirore dutiyari, mʉsa tʉhotugʉ̃? ni sinituahye tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Tiquiro sa nigʉ̃ tiquina pehe tiquina basi ohõ saha niahye: —‍¿Dʉhse ni yʉhtinatari mari? “Cohãcjʉ̃ Ñure dutiri jiri”, mari nigʉ̃, “¿Dʉhsena Cohãcjʉ̃ Ñure tiquiro dutiepegʉ̃ta tiquirore tʉho duerari mʉsa?” niboaga Jesu marine. ");
INSERT INTO pirNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Sa yero “Ñu tiquiro wame yegʉ̃ Cohãcjʉ̃ pehe tiquirore dutierari jiri”, mari nigʉ̃ masa pehe usueta mari mehna, niahye tiquina basi. “Potota Ñu Cohãcjʉ̃ yere yahu mʉhtariquiro ijire”, ni tʉhotue tiahye masa pehe. Sa ye pahia pʉhtoa, ʉsã judio masare buheyequina, bʉcʉna mehna tiquinare cue niahye. ");
INSERT INTO pirNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Sa ye tiquina Jesure ohõ saha ni yʉhtiahye: —‍Ñure wame ye dutiriquirore ʉsã masiedaga, niahye tiquina Jesure. —‍Ti pje pũrita yʉhʉ gʉ̃hʉ ahrire yʉhʉ yerire dutiriquirore yahueraja mʉsare, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Sa ye Jesu tiquiro tʉhotuye mehna ohõ saha ni queoye mehna buhe dʉcahye tiquinare. —‍Wese upʉro ʉhse darire oteahye. Ote tuhasa, sahrĩnore doco, ʉhsere tiquina cʉhta mʉtoati copere sehe, ʉhmʉari wʉhʉgã dahreahye tiquiro. Sa yero ti wesere apequinare ihcã pehe pahma cũno, ti wesere cohte dutiahye. Cohte duti tuhasa ape siepʉ wahaa wahahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Came ʉhse ñidi pje ijigʉ̃ wese upʉro tiquiro cahacjʉ̃nore wese cjẽ tiquiro ya pahma cjẽ dʉcare ne dutiro ohomahye. ");
INSERT INTO pirNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Sa ye wesere cohteyequina pehe tiquiro cahacjʉ̃nore ñehe, quẽahye tiquirore. Sa ye tuhasa tiquiro cahacjʉ̃nore ʉhse tõhorine ohoerapeta tojoa dutiahye tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Sa yero wese upʉro apequiro tiquiro cahacjʉ̃nore ohomahye tja. Sa ye cohteyequina pehe tiquiro dapure cami dahre, ñano yeahye tiquina tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Sa yero apequiro pehere tiquiro ohogʉ̃ cohteyequina tiquirore wejẽahye. Peyequina apequina gʉ̃hʉre sa dihita ye mʉjahye. Apequina pehere quẽ, apequina pehere wejẽahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Sa yero wese upʉro macʉno dihita dʉhsahye. Tiquiro cahĩniquiro ijiahye. Sa yero tiquiro macʉnore ohoahye, “Yʉhʉ macʉ pehere ño peoeta”, nino. ");
INSERT INTO pirNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Tiquiro sa ni tʉhotuepegʉ̃ta cohteyequina tiquina basi ohõ saha ni yahuducuahye: “Wese upʉro macʉno ijire ahriquiro. Tiquirore wejẽihna mari. Sa yero ahri wese mari ya wese tojoarota”, nimahye tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Sa niñe tiquirore ñehe, wejẽ, wese dʉhtʉ cahapʉ ne cã, cohã cãhye tiquina tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","’¿Ne wese upʉro ahtaro dʉhse yerotari tiquiro wesere cohteyequinare, mʉsa tʉhotugʉ̃? Ohõ saha yerota tiquinare: Tiquiro tiquinare wejẽno, apequina pehere wesere cohte dutirota. ");
INSERT INTO pirNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","¿Cohãcjʉ̃ yere tiquina ojoari pũre ahrire buherari mʉsa? Ohõ saha ni ojoahye: Ahriquiro Cristo ʉtã yero saha ijire. Ʉtãre wʉhʉre dahreyequina tiquina cohãno saha masa tiquirore cohãeta. Tiquina sa cohãepegʉ̃ta yojopʉre wʉhʉre dahreyequina wʉhʉre yeye, tiquina cũ mʉhtaria ʉtãre tiquina cũno saha Cohãcjʉ̃ tiquirore pʉhtoro sõri. Cohãcjʉ̃ pehe ahrire yeri. Tiquiro sa yegʉ̃ ihñana, “Quehnoa yʉhdʉare”, ni tʉhotuaja mari, ni ojoahye panopʉre. ¿Tire ne buherari mʉsa? niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Tiquiro sa nigʉ̃ tʉhoye pahia pʉhtoa, ʉsã acaye judio masare buheyequina, bʉcʉna mehna ohõ saha ni tʉhotuahye: “Jesu wesere cohteyequina quiti mehna marine tuhtiro nine”, ni tʉhotuahye. Sa ni tʉhotuye Jesure ñehe duamahye. Sa ñehe duepeta masare cue niahye. Sa cueye tiquirore cohã cãa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Waha, tiquina fariseo masare, Herode ya curua cjẽna gʉ̃hʉre Jesure sinitu dutiye ohoahye tja. Jesu ñano tiquiro yʉhtigʉ̃ ye duamahye tiquina, tiquirore yahusãñe tehe. ");
INSERT INTO pirNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Sa ye Jesu cahapʉ esaye, tiquirore niji sio sinitumahye: —‍Buhegʉ, poto yahuducugʉ, ni mehoñe mariegʉ mʉhʉ ijigʉ̃ masiaja ʉsã. Cohãcjʉ̃ yere queoro mʉhʉ yahugʉ̃ gʉ̃hʉre masiaja ʉsã. Sa yegʉ ihcãquiro pʉhtoro waro ijiepegʉ̃ta tiquiro gʉ̃hʉre dóyaro marieno potota yahure mʉhʉ. Sa yegʉ ʉsãre yahuya. ¿Roma cjʉ̃no ijipihtiyequina pʉhtoro yere marine wapa yero cahmeajari, mʉhʉ tʉhotugʉ̃? ¿Mari dutiye wapa ye dutiajari, mʉhʉ tʉhotugʉ̃? ni sinituahye tiquina Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Tiquina sa sinitugʉ̃ tʉhoro tiquina ñano ye duayere masino Jesu ohõ saha ni sinituahye tiquinare: —‍¿Dʉhse yena yʉhʉ ñano yahuducugʉ̃ tʉho duajari mʉsa? Yojopʉre niñeru cjoere ne cãhtaya. Ti cjoere ihñaʉhna, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Tiquiro sa nigʉ̃ tʉhoye tiquina pehe ihcã cjoe ne cãhtahye. Tiquina ne wihigʉ̃ Jesu sinituahye tiquinare: —‍¿Noa boro queoye wahñajari ahri cjoere? ¿Noa boro wame wahñajari? ni sinituahye tiquiro. —‍César, masa ijipihtiyequina pʉhtoro queoye, tiquiro wame gʉ̃hʉ wahñare, ni yʉhtiahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Tiquina sa nigʉ̃ Jesu yahuahye tiquinare: —‍Ti pje pũrita masa ijipihtiyequina pʉhtoro yere tiquiro pehere ohoya. Cohãcjʉ̃ yere Cohãcjʉ̃ pehere ohoya, ni yahuahye Jesu. Tiquiro sa nigʉ̃ tʉhoye tʉho maria wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sa ye ihquẽquina saduceo masa Jesu cahapʉ wihiahye. Saduceo masa pehe “Cohãcjʉ̃ yariariquinare masosi”, ni tʉhotuyequina ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Sa ye tiquina ohõ saha niahye tiquirore: —‍Buhegʉ, ohõ saha ni buheahye Moise: “Ihcãquiro wahmino namo tiriquiro pohna mariedaperota yariagʉ̃ ihñano tiquiro bahʉrore tiquiro wahmino namono ijiricorore nʉoano cahmene. Sa yero wahmino mʉnano tiquiro pohna tiboro saha pohna tiro cahmene tiquiro bahʉrore. Sa ye tiquiro pohne tiquiro wahmino mʉnano pohne yero saha ijieta”, ni ojoahye Moise, niahye tiquina Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Tire ni tuhasa, ahri quitireta yahu nemoahye Jesure: —‍Ihcãquiro masʉno ijiahye. Seis bahana tiahye. Tiquiro wahmino pehe namo ti, pohna mariedaperota yariaa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Sa yero apequiro tiquiro bahʉro gʉ̃hʉ tiquiro wahmino namono ijiricorore cʉomahye. Tiquiro sa nʉoari bato tiquiro wahmino yero saha pohna mariedaperota yariaa wahahye tja. Sa yero ahriquiro bahʉro tiquiro wahmino mʉnano yero saha pohna mariedaperota yariaa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Sa dihita wahahye ihcãquiro pohne waro. Ne pohna mariedapeta yaria pihtia wahahye tiquina. Tiquina namono ijiricoro gʉ̃hʉ tiquina batota yariaa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","¿Ne, Cohãcjʉ̃ ijipihtiyequinare yariariquina mʉnare tiquiro masogʉ̃ diquiro namono pehe ijirotari ticoro? Tiquina ijipihtiyequina ticorore namo tiriquina mʉna ijiahye. ¿Sa yero diquiro namono pehe ijiboagari ticoro pototi? ni sinituahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesu yʉhtiahye tiquinare: —‍Cohãcjʉ̃ yere tiquina ojoari pũre, tiquiro masiñe gʉ̃hʉre ne masiedare mʉsa. Sa yero mʉsa tʉhotuye pehe ne poto ijierare. ");
INSERT INTO pirNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Yariariquina mʉna tiquina masa mʉjari bato angele yero saha ijire. Namo marieñequina, manʉ marieñe numia ijire topʉre. ");
INSERT INTO pirNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Yariariquina mʉna tiquina masa wijiato pehere mʉsare yahugʉtja: Tire Moise quehnoano yahu pehoahye. Mehenʉgã ʉjʉ̃ri quitire ohõ saha ni yahuahye tiquiro: “ ‘Yʉhʉ Abrahã, Isaac, Jacob tiquina pʉhto tjiaja’, ni yahuri Cohãcjʉ̃ yʉhʉre”, ni ojoahye Moise tiquiro ojoari pũpʉ. ");
INSERT INTO pirNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Tiquina yariari bato “Tiquina pʉhto tjiaja”, ni yahuahye Cohãcjʉ̃. Sa nieperota yariariquina mʉna pʉhtoro ijierare Cohãcjʉ̃. “Tiquina pʉhto tjiaja”, tiquiro niñe mehna catiyequina tiquina ijigʉ̃ masiaja mari. Tiquiro catiyequina pʉhtoro ijire. Sa yena “Yariariquina masasi”, ni tʉhotuna potota tʉhotuerare mʉsa, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Sa ye ihcãquiro ʉsã acaye judio masare buheyequina mehna cjʉ̃no tiquina cahapʉ wihi, tiquina cahme yahuducugʉ̃ tʉhoahye. Jesu quehnoano yʉhtiyere tʉhoro sinituahye tiquirore. —‍¿Cohãcjʉ̃ ye dutiro quehnoa yʉhdʉari dutiro noho pehe ijiajari, mʉhʉ tʉhotugʉ̃? ni sinituahye tiquiro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesu tiquirore yahuahye: —‍Ahri dutiro ijire apeye dutiye bui quehnoa yʉhdʉari dutiro: “Israe masa, tʉhoya. Cohãcjʉ̃ mʉsa pʉhtoro yʉhʉ ihcʉ̃ta ijiaja. ");
INSERT INTO pirNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Tutuaro mʉsa jeripohnari mehna, quehnoano mʉsa wacũñe mehna, mʉsa tutuaye mehna yʉhʉre cahĩña”, nine Cohãcjʉ̃. ");
INSERT INTO pirNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ahri dutiro bato apero dutiro quehnoano ijire. “Mʉhʉ basi mʉhʉ cahĩno saha mʉhʉ cahapʉ ijiyequina gʉ̃hʉre cahĩña”, nine Cohãcjʉ̃. Ahri pʉaro dutirota ijipihtiye apeye dutiye yʉhdʉoro ijire, ni yahuahye Jesu tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Tiquiro sa nigʉ̃ judio masare buheriquiro ohõ saha niahye: —‍Sa tjire. Buhegʉ, potota nine mʉhʉ. Cohãcjʉ̃ ihcãquirota ijire. Apequiro tiquiro yero saha ijiriquiro mariedare. Mʉhʉ niñe potota ijire. ");
INSERT INTO pirNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Cohãcjʉ̃re tutuaro mari jeripohnari mehna, mari wacũñe mehna, mari tutuaye mehna tiquirore cahĩno cahmene marine. Yʉhʉ caha ijiyequinare yʉhʉ basi yʉhʉ cahĩno saha tiquina gʉ̃hʉre cahĩno cahmene yʉhʉre. Wahiquinare wejẽ ʉjʉ̃a mʉo mari ohori mehna mari ño peogʉ̃ quehnoarĩmene. Ahri yʉhdʉoro Cohãcjʉ̃re, masa gʉ̃hʉre mari cahĩñe quehnoa yʉhdʉare. Mʉhʉ sa niñe ijirota ijire, niahye judio masare buheriquiro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Tiquiro sa quehnoano yʉhtigʉ̃ tʉhoro Jesu yahuahye tiquirore: —‍Mehenogã dʉhsare mʉhʉre Cohãcjʉ̃re mʉhʉ quehnoano masiato, niahye tiquirore. Tiquiro sa nigʉ̃ tʉhoye apequina cueye, ne sinituerahye Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Sa ye Cohãcjʉ̃ wʉhʉpʉ buhero ohõ saha niahye Jesu: —‍“Cristo Davi mʉnano panamino iji turiariquiro ijire”, ni buhere mari acaye judio masare buheyequina. ¿Dʉhse niñe sa ni buheajari tiquina? ");
INSERT INTO pirNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Davi tiquiro basi Espíritu Santo tiquiro dutiriro sahata ohõ saha ni yahuahye: Cohãcjʉ̃ yʉhʉ pʉhtorore ohõ saha nidi: “Ohõpʉ yʉhʉ poto pehe dujiya. Sa yegʉ mʉhʉre ihña tuhtiyequinare mʉhʉre yʉhdʉdʉca basagʉtja yʉhʉ”, nidi Cohãcjʉ̃ yʉhʉ pʉhtorore, ni ojoahye Davi mʉnano. ");
INSERT INTO pirNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Sa ni ojoaro Davi mʉnano pʉhtoro tiahye Cristore. ¿Davi mʉnano Cristo ñecʉno mʉnano iji turiariquiro ijieperota dʉhsero Davi pehe pʉhtoro tiyari Cristore? Cristo Davi mʉnano pʉhtoro ijire, ni yahuahye Jesu. Tiquiro sa ni buhegʉ̃ peyequina masa bucueye mehna tʉhoahye tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Sa yero tiquiro buhe nemono ohõ saha niahye: —‍Mari acaye judio masare buheyequina tiquina ñañe yeyere quehnoano ihñaña. Sa yena tiquina yero saha yeracãhña. Tiquina yoaye suhti saña, masa tiquina ihñonopʉ majare, doeri cjẽ duaropʉ apequina pʉhtoare quehnoano ño peo tiquina sinino saha tiquina piti ca sinigʉ̃ cahmene tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Sa ye mari judio masa buheye wʉhʉsepʉ quehnoañe dujiye dihitare duji duare. Sa ye bose deco ijigʉ̃ topʉ gʉ̃hʉre quehnoañe dujiye dihitare cahmene tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Tiquina wape wiha numia ye wʉhʉsere tiquina cʉoye gʉ̃hʉre ehmare ti numiare. Sa ye tiquina masa ihñonopʉ yoari pje Cohãcjʉ̃re siniducumene masare ihña dutiye. Tiquina sa yeri buhiri apequina bui cjũno tiquinare Cohãcjʉ̃ pajiro buhiri dahrerota, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Sa yero Jesu Cohãcjʉ̃ wʉhʉ cjẽ niñeru tiquina sãri acaro cahapʉ dujiahye. Topʉ masa tiquina niñeru duhu sãgʉ̃ ihña dujiro niahye. Sa ye niñeru opana ti acaropʉ pajiro duhu sãhye. ");
INSERT INTO pirNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Sa yero wape wihoro pejecʉoricoro ti acaropʉ ahta, pʉa cjoegã duhu sãhye. Pʉa cjoe ihcã centavo pose ijire. ");
INSERT INTO pirNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ti cjoeri ticoro duhu sãgʉ̃ ihñano tiquiro buheyequinare pijioahye: —‍Ijirota niita niaja mʉsare. Ahricoro wape wihoro pejecʉoricoro pehe niñeru ihbori acaropʉ duhu sãno apequina ijipihtiyequina tiquina ohori yʉhdʉoro ohori ticoro pehe. ");
INSERT INTO pirNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Apequina doeri cjẽ opana pajiro tiquina ohoepegʉ̃ta tiquina ye pajiro dʉhsare. Ahricoro pehe pejecʉoricoro ijieperota ijipihtiye ticoro ihyatire dúborigãre oho pehori, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Sa ye Cohãcjʉ̃ wʉhʉpʉre tiquina wijiagʉ̃ ihcãquiro buheyequina mehna cjʉ̃no ohõ saha niahye: —‍Buhegʉ, ihñaña. Ahri wʉhʉse quehnoañe ʉtã paca mehna tiquina yeri wʉhʉse quehnoa yʉhdʉaye wʉhʉse ijicjoare, niahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Tiquiro sa nigʉ̃ Jesu yahuahye tiquinare: —‍Ahri ijipihtiye mari ihñari wʉhʉse, ahri wʉhʉse cjẽ ʉtã paca gʉ̃hʉre cohã pehoeta. Ne ihcãria ʉtã tojoasi, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Sa ye Jesu Olivo wame tidʉ cʉnʉpʉ Cohãcjʉ̃ wʉhʉ potopʉ ijidʉpʉ esahye. Tʉ buipʉ dujiahye. Topʉ Pedro, Santiago, Ñu, Andre mehna tiquina sehsaro ijiye, tiquina tiquirore sinituahye: ");
INSERT INTO pirNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—‍Yahuya ʉsãre. ¿Dʉhse ijigʉ̃ sa waharotari mʉhʉ nidiro saha waharo? ¿Deco pihtiato panogã ijigʉ̃ dʉhse ti waha dʉcagʉ̃ ihñanatari ʉsã? ni sinituahye tiquina Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesu yʉhtiahye: —‍Quehnoano yeya mʉsa. Sa yena apequina tiquina ni mehoñene tʉhoeracãhña mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Peyequina masa “Cristo ijiaja yʉhʉ”, ni mehoñequina ahtaeta. Tiquina sa ni mehogʉ̃ tʉhoye peyequina masa Cohãcjʉ̃ yere duhueta. ");
INSERT INTO pirNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Mʉsa cahagã masa apequina tiquina cahme wejẽgʉ̃ tʉhonata mʉsa. Sa yena yoaropʉ gʉ̃hʉre tiquina cahme wejẽgʉ̃ tʉhoonata mʉsa. Sa tʉhooepenata ne tire pajiro tʉhotueracãhña. Sa waharota. Tiquina sa yegʉ̃ pihtiati deco dʉhsarĩnota. ");
INSERT INTO pirNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ti pjere ihcã yehpa cjẽna ape yehpa cjẽna mehna cahme wejẽeta. Sa ye ihcãquiro pʉhtoro yequina apequiro pʉhtoro yequina mehna cahme wejẽeta. Sa yero ijipihtiri yehpa ñuhminota. Sa ye peyequina masa ʉjʉa mehna yarieta. Sa wahagʉ̃ ahri yehpa cjẽnare tiquina ñano yʉhdʉ nemoato dʉhsarĩnota. Ñano yʉhdʉrĩeta. ");
INSERT INTO pirNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Sa wahagʉ̃ ihñana mʉsa basi quehnoano yeya. Apequina mʉsare ñehe, ñano ye dutiye ohoeta apequina pʉhtoapʉre. Sa ye judio masa mari buheye wʉhʉsepʉ mʉsare quẽeta. Tiquina sa yegʉ̃ bʉjʉye macari cjẽna pʉhtoa, tiquina bui pʉhtoa gʉ̃hʉ mʉsare buhiri dahreye tehe sinitueta mʉsare. Yeequina mʉsa ijiri buhirire apequina mʉsare yahusãeta. Sa yena yeere yahunata mʉsa tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Sa ye pihtiati deco pano quehnoañe buheye ijipihtiye yehpari cjẽnare buheripʉ ijirota. ");
INSERT INTO pirNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Sa yena mʉsare buhiri dahre dutiye, buhiri dahre dutiatiquiro cahapʉ tiquina neagʉ̃ tiquirore mʉsa niatire “Yahu masiedaboaga”, ni tʉhotueracãhña mʉsa. Ti pjere mʉsa niatire mʉsare Espíritu Santo yahurota. Tiquiro sa yahurire yahuya mʉsa. Mʉsa esa tuharo yahuducusi mʉsa. Espíritu Santo mʉsare yahuducu basarota. ");
INSERT INTO pirNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ti pjere tiquina wahmisʉmʉa tiquina bahanare wejẽ dutiye ohoeta pʉhtoare, yeequina tiquina ijiri buhiri. Tiquina pacʉsʉmʉa tiquina pohnene wejẽ dutiye ohoeta pʉhtoare. Tiquina pohne pehe tiquina pacʉsʉmʉare wejẽ dutiye ohoeta pʉhtoare. ");
INSERT INTO pirNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Sa ye yeequina mʉsa ijiri buhiri mʉsare masa ijipihtiyequina ihña tuhtieta. Tiquina sa yepegʉ̃ta ahri yehpapʉ mʉsa catiro puno mʉsare tiquina ñano yerire ihcãno sahana yʉhʉre duhuerana, yʉhdʉnata mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Sa yena ña yʉhdʉariquirore Cohãcjʉ̃ yere ñano yeriquirore ihñanata mʉsa. Cohãcjʉ̃ ya wʉhʉpʉ tiquiro ducugʉ̃ ihñanata. Topʉ tiquirore ijieraro cahmene. Topʉ tiquiro ducugʉ̃ ihñañe Judea yehpapʉ ijiyequina cʉnʉ cjʉpʉ duhti oma mʉjaa wahaahro. Ahri yʉhʉ nidire quehnoano masiña mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Sojaro mehna oma duhtiahro. Ti pjere tiquina wʉhʉse bui cjẽ paaripʉ ijiyequina wʉhʉ puhiapʉ ijiyere tiquina yere neñe wahaeracãhdo tiquina waha madoqueoato saha. ");
INSERT INTO pirNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Sa ye ti pjere apequina tiquina weseripʉ ijiyequina tiquina bui cjẽ suhtire wʉhʉpʉ ijiye suhtire neñe wahaeracãhdo tiquina waha madoqueoato saha. ");
INSERT INTO pirNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ti pjere niji pacosãnumia, tiquina pohnene apũoñe numia gʉ̃hʉ pejecʉoro wahaeta. ");
INSERT INTO pirNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Sa yena ohõ saha ni siniña Cohãcjʉ̃re: “Pohecʉ ijigʉ̃ sa wahaeracãhdo”, ni siniña tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ti decorire masa ña yʉhdʉaro wahaeta. Ahri yehpare tiquiro bajumehnedi bato masa ñano yʉhdʉe tiahye. Ti sa ijiepegʉ̃ta ijipihtiye ti purĩñe yʉhdʉoro pihtiati deco ijigʉ̃re ña yʉhdʉaro masa yʉhdʉeta. Sa ñano tiquina yʉhdʉri bato pari turi sa ña yʉhdʉaro yʉhdʉsi ahri yehpapʉ. ");
INSERT INTO pirNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Sa yero Cohãcjʉ̃ ti decorire meheñe decorigã ijigʉ̃ yerota. Tiquiro sa yeragʉ̃ ne ihcãquiro masʉno yʉhdʉeraboaga. Sa yero tiquiro beseriquina tiquina yʉhdʉatire meheñe decorigã cũnota Cohãcjʉ̃. ");
INSERT INTO pirNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Ti pjere apequina mʉsare “Ihñaña. Ahriquiro ijire Cristo”, tiquina nigʉ̃ tiquinare tʉhoeracãhña. “Topʉ ijire Cristo”, tiquina nigʉ̃ gʉ̃hʉre tʉhoeracãhña. ");
INSERT INTO pirNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","“Cristo ijiaja”, ni mehoñequina, “Cohãcjʉ̃ yere yahu mʉhtana ijiaja”, ni mehoñequina ijieta ti pjereta. Sa ye Cohãcjʉ̃ beseriquinare ni mehoñe, tiquina tutuaye mehna ye ihñoeta. Cohãcjʉ̃ yequinare Cohãcjʉ̃re tiquina cohã duagʉ̃ ye duare tiquina mehoñequina. ");
INSERT INTO pirNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ahrire yahuyuaja mʉsare sa wahato pano. Sa yena quehnoano yeya mʉsa, ni yahuahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Sa ni tuhasa ohõ saha ni yahuahye Jesu: —‍Ti decori ijigʉ̃ tiquina ñano yʉhdʉri bato asʉ̃ deco cjʉ̃no, ñami cjʉ̃no gʉ̃hʉ buhrio duhu cãeta. ");
INSERT INTO pirNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Tiquina sa wahagʉ̃ta ñahpicoha paca ʉhmʉsepʉ ijiye paca bora dijiaa wahaeta. Sa ye ʉhmʉse cjẽ yehpari, ñahpicoha gʉ̃hʉ ti sa wahaducurore camesaeta. Sa ye ñuhmieta. ");
INSERT INTO pirNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ti pjeta yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ ahtagʉtja. Sa ye ʉhmʉsepʉ yʉhʉ tutuaye mehna yʉhʉ asi siteye mehna ʉhmʉse cjẽ ehmeo cururi buipʉ ahri yehpapʉre yʉhʉ tojoa tagʉ̃ ihñaeta masa. ");
INSERT INTO pirNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Sa yegʉ yeequina angelere ijipihtiropʉ ahri yehpapʉ ohogʉtja. Sa ye ijipihtiropʉ yeequina yʉhʉ beseriquinare tiquina neeta. ");
INSERT INTO pirNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Yojopʉre higueragʉre tʉhotuya mʉsa. Tʉ quiti mehna mʉsare queoye mehna buhegʉtja. Tʉ yucʉgʉ pũri tigʉ̃ ihñana cʉhma mehenogã dʉhsagʉ̃ masine mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Sata ahri ijipihtiye yʉhʉ nidi sa wahagʉ̃ ihñana, yʉhʉ tojoa tato mehenogã dʉhsagʉ̃ masinata mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ijirota niita niaja mʉsare. Ti pje cjẽna tiquina yariato panore ijipihtiye yʉhʉ nidiro sahata sa waharota. ");
INSERT INTO pirNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ʉhmʉse, ahri yehpa gʉ̃hʉ pihtia waharota. Yʉhʉ yahuducuye pehe ne camesasi. Ijipihtiye yʉhʉ nidiro sahata sa waha sohtori tiarota. ");
INSERT INTO pirNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Ti decore yʉhʉ tojoa tati decore, ti hora gʉ̃hʉre masiedaja yʉhʉ. Angele gʉ̃hʉ tire masiedare. Masa gʉ̃hʉ ne masiedare. Yʉhʉ Pacʉ dihita tire masine. ");
INSERT INTO pirNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Mʉsa gʉ̃hʉ ti decore masiedare. Sa yena quehnoano yeya. Quehnoano cohteya. Cohãcjʉ̃re siniña mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ohõ saha cohteya mʉsa. Ahri quiti mehna mʉsare queoye mehna buhegʉtja. Wʉhʉ upʉro yoaropʉ tiquiro tinino saha ijire ahri. Tiquiro wahato pano tiquiro cahacjẽnare wʉhʉre cohte dutiahye. Tiquinape tiquina dahrayere cũahye. Sa yero wʉhʉre cohteriquirore tiquiro tojoa tatore cohte dutiahye. ");
INSERT INTO pirNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Sa yena mʉsa gʉ̃hʉ quehnoano wacũ masi cohteya. Wʉhʉ upʉro tiquiro tojoa tatore tiquina masiedariro saha yʉhʉ mʉsa pʉhto tojoa tati decore masiedare mʉsa gʉ̃hʉ. Ñamicahapʉ, ñami deco, canaca tiquiro yahuri pje ijigʉ̃ bohrearopʉ ahtaboaga. ");
INSERT INTO pirNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Yʉhʉ sa wacũeno mehna yʉhʉ wihiatore masina, yeere sa yeducuya. Sa yena yʉhʉre quehnoano cohteya. ");
INSERT INTO pirNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Sa yegʉ mʉsare yʉhʉ nino sahata ijipihtiyequinare sa niaja: Quehnoano wacũ masi cohteya, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Sa ye ti pjere pascua wame tiri bose deco pano pugʉ̃ yeye moremehneñe pãre tiquina ihyati deco pano, pʉa deco dʉhsarĩahye. Ti pjere pahia pʉhtoa, ʉsã acaye judio masare buheyequina mehna Jesure tiquina ni mehoñe mehna tiquina ñehe wejẽatire cahme yahuducuye niahye. ");
INSERT INTO pirNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","—‍Bose deco ijigʉ̃ tiquirore ñehedacʉ̃hna “Masa usuari”, nina, niahye tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Sa ye Jesu gʉ̃hʉ Betaniapʉ, Simo cami bʉcʉ mʉna wihiro ijimediquiro ya wʉhʉpʉ ijiahye. Sa yero tiquina ihyari watoa numino pehe alabastro mehna yeriare ehme sitiye nardo wame tiye ʉhsere pose tiriare ne wihiahye. Ti ʉhse pehe wapa bʉjʉye ijiahye. Sa yero ticoro tiare pohadoqueo, Jesu dapu bui pio peoahye. ");
INSERT INTO pirNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ticoro sa yegʉ̃ ihñañe apequina usuaa wahahye. —‍¿Dʉhse yero ahricoro ahri ehme sitiye co wapa bʉjʉyere sa ye siteajari? ");
INSERT INTO pirNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Tire ticoro duaboaya. Tire duaro tres cientos niñeru cjoerire wapataboaya. Sa yero ti niñerure pejecʉoyequinare ohoboaya ticoro, ni cohteahye apequina pehe ticoro sa yegʉ̃ ihñañe. Sa ye tiquina ticorore tuhtiahye. ");
INSERT INTO pirNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Tiquina sa nigʉ̃ tʉhoro Jesu tiquinare yahuahye: —‍Sa niedacãhña ticorore. Yʉhʉre ticoro quehnoano yero nine. ");
INSERT INTO pirNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Pejecʉoyequina pehe mʉsa mehna sa ijiducueta. Sa yena mʉsa cahmedi pje tiquinare oho masine. Yʉhʉ pehe ahri yehpare mʉsa mehna sa ijiducusi. ");
INSERT INTO pirNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ticoro cʉoro puno mehna ticoro yʉhʉre sa yeri. Yʉhʉre tiquina yato pano yʉhʉ pagʉre quehnoyuro, ehme sitiyere pio peori ticoro. ");
INSERT INTO pirNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Sa yegʉ potota niita niaja mʉsare. Ijipihtiro ahri yehpapʉ quehnoañe buheyere tiquina yahuatopʉ ahricoro yojopʉre ticoro yerire yahueta. Tiquina sa yahugʉ̃ tʉhoye ticorore masa peyequina wacũeta, ni yahuahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ti pjereta Juda Iscariote doce buheyequina mehna cjʉ̃no Jesure tiquiro ihñoatire yahuro wahahye tiquirore ihña tuhtiyequinare, pahia pʉhtoare. ");
INSERT INTO pirNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Sa ye pahia pʉhtoa tire tʉhoye bucueahye. —‍Mʉhʉre niñerure ohonatja, niahye tiquina Judare. Sa yero Jesure ihña tuhtiyequinare tiquiro ihñoatire wacũ macahye. ");
INSERT INTO pirNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pugʉ̃ yeye moremehneñe pãre tiquina ihyati bose deco iji dʉcari deco, ovejare pascua deco ijigʉ̃ ihyatiquirore tiquina wejẽati deco ijiahye. Ti pjere tiquiro buheyequina pehe sinituahye Jesure: —‍¿Noho boropʉ bose deco ijigʉ̃ mari ihyatire quehnoyu dutigʉ ohoutjari mʉhʉ ʉsãre? niahye tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Tiquina sa nigʉ̃ta Jesu pehe pʉaro tiquiro buheyequina mehna cjẽnare ohoahye. —‍Jerusalẽpʉ wahaya. Topʉ mʉsa esagʉ̃ aco suture wʉariquiro mʉsare piti carota. Tiquiro piti cagʉ̃ tiquiro mehna wahaya. ");
INSERT INTO pirNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Sa wahana tiquiro siho sajãri wʉhʉpʉ esana wʉhʉ upʉrore ohõ saha ni yahuya: “ ‘¿Nohopʉ yʉhʉ buheyequina mehna pascua cjẽ ihyayere ihyanatari?’ nidi buheriquiro”, niña wʉhʉ upʉrore. ");
INSERT INTO pirNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Mʉsa sa nigʉ̃ tʉhoro ʉhmʉano cjã tucũre pajiri tucũre mari cahmeñe mehna tiquina quehnori tucũre ihñonota wʉhʉ upʉro. Topʉ mari ihyatire dahreya mʉsa, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Tiquiro sa nigʉ̃ tʉhoye tiquina tiquiro buheyequina ti macapʉ wahahye. Topʉ esagʉ̃ tiquinare tiquiro nidiro sahata wahahye. Sa ye tiquina pascua cjẽ ihyayere dahreahye. ");
INSERT INTO pirNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Sa ye nahitia cãhtagʉ̃ Jesu doce tiquiro buheyequina mehna topʉre esahye. ");
INSERT INTO pirNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Sa yero tiquina mehna mesapʉ ihyaro Jesu tiquinare yahuahye: —‍Poto niita niaja mʉsare. Ihcãquiro mʉsa mehna cjʉ̃no yʉhʉ mehna ihyariquirota yʉhʉre ihña tuhtiyequinare ihñonota, ni yahuahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Tiquiro sa nigʉ̃ tʉhoye tiquina pehe bʉjʉa witiahye. —‍¿Yʉhʉta ijiajari mʉhʉre ihñoacjʉ? ni sinitu pihtiahye tiquina Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","—‍Mʉsa mehna cjʉ̃nota ijire tiquiro. Yʉhʉ ihyari papʉ yʉhʉ mehna soha ihyariquirota ijire yʉhʉre ihña tuhtiyequinare ihñoatiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Panopʉ yʉhʉre tiquina yahu ojoariro sahata yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ yariagʉta. Sa yero yʉhʉre ihña tuhtiyequinare ihñoriquiro pejecʉoro yʉhdʉrota. Tiquiro pehe masa bajueragʉ̃, quehnoa yʉhdʉaboya. Ñano yʉhdʉeraboya, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Sa ni yahu tuhasaro tiquiro buheyequina mehna ihyaro taro niahye. Sa yero Jesu pãre ne, Cohãcjʉ̃re “Quehnoare”, niahye. Sa ninota tiare nuha, itiahye tiquinare. —‍Ahrire ne ihyaya. Ahri yʉhʉ pagʉ ijire, niahye tiquiro tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Sa ni tuhasa tiquiro sihnini pare ne, Cohãcjʉ̃re “Quehnoare”, ni tuhasa, ohoahye tiquinare. Tiquiro oho tuhasagʉ̃ tiquina ijipihtiyequina tire sihniahye. ");
INSERT INTO pirNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","—‍Ahri yʉhʉ dii ijire. Peyequina masa tiquina ñañe yerire cohãgʉ tagʉ yariagʉtja. Sa yegʉ yʉhʉ diire cohãgʉtja. Mari Pacʉ “Mʉsare yʉhdʉogʉtja”, tiquiro nidiro esagʉ̃ yʉhʉ yariaro mehna tiquiro nidiro sohtori tirota. ");
INSERT INTO pirNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Poto niita niaja mʉsare. Cohãcjʉ̃ tiquiro pʉhtoro ijiropʉ wahma core ʉhse core yʉhʉ sihniato pano, ahri dihtapʉre ʉhse core pari turi sihnisi yʉhʉ, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Sa ye tiquina ihcã taha Cohãcjʉ̃ ye basayere basa tuhasa, cʉnʉpʉ Olivo wame tidʉpʉ wahaa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Topʉ siho esaro Jesu tiquinare yahuahye: —‍Yojopʉre mʉsa ijipihtina yʉhʉre cohãnata. Ohõ sahata nine Cohãcjʉ̃ yere tiquina ojoari pũpʉ yʉhʉre yahuro: “Ovejare ihña ihboriquiro yero saha ijiriquirore Cohãcjʉ̃ cohãnota. Sa tiquiro cohãgʉ̃ tiquiro yequina oveja yero saha ijiyequina duhti site cãa wahaeta”, nine Cohãcjʉ̃ yere tiquina ojoari pũpʉ. ");
INSERT INTO pirNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Sa yegʉ Cohãcjʉ̃ yʉhʉre tiquiro masori bato mʉsa pano Galileapʉ wahayugʉtja yʉhʉ, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Tiquiro sa nigʉ̃ Pedro ohõ saha niahye: —‍Yʉhʉ mehna cjẽna ijipihtiyequina tiquina cohã cãepegʉ̃ta yʉhʉ pehe mʉhʉre ne cohãsi, nimahye Pedro tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesu yʉhtiahye: —‍Potota niita niaja mʉhʉre. Mia ñamita canaca pʉa taha tiquiro yahuato pano “Yʉhʉ Jesure masiedaja”, nigʉta mʉhʉ. Ihtia taha sa nigʉta mʉhʉ, niahye Jesu Pedrore. ");
INSERT INTO pirNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Tiquiro sa niepegʉ̃ta Pedro ohõ saha ni tutuaro bisiro yʉhtiahye: —‍Mʉhʉ mehna yʉhʉre tiquina wejẽ duepegʉ̃ta “Jesure masiedaja”, ne nisi yʉhʉ, ni yʉhtimahye tiquiro Jesure. Pedro sa nigʉ̃ tʉhoye tiquiro mehna cjẽna gʉ̃hʉ sa dihita ni yʉhtiahye. ");
INSERT INTO pirNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Sa ye tiquina Getsemaní wame tiri wesepʉ wahahye. Topʉ esaro ohõ saha niahye Jesu: —‍Yʉhʉ Cohãcjʉ̃re yʉhʉ sinino watoa ohõ dujiyuya, niahye tiquiro buheyequinare. ");
INSERT INTO pirNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Sa ni tuhasa Pedrore, Santiagore, Ñure tiquinare ihtiarore piji cãhye. Tiquinare sa piji cãno, pajiro tʉhotu dʉcahye tiquiro. Sa yero ñano jeripohna tiahye. ");
INSERT INTO pirNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Sa bʉjʉa witiro tiquiro mehna cjẽnare tiquiro piji cãriquinare ohõ saha niahye: —‍Yʉhʉ ñano jeripohna tiaja. Yʉhʉre tutuaro purĩno saha tʉhotugʉ niaja. Ohõ tojoaya. Sa yena yʉhʉ mehnata carĩedacãhña mʉsa gʉ̃hʉ, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Sa ni tuhasa tiquiro topʉ mehenogã waha nemo, yehpapʉ quehe saro, Cohãcjʉ̃re niahye: —‍Mai, mʉhʉ ijipihtiyere ye masine. Sa yegʉ yʉhʉ ñano yʉhdʉatire ye dueragʉ yeracãhña. Yʉhʉ sa niepegʉ̃ta yʉhʉ cahmeno saha yeracãhña. Mʉhʉ pehe masine. Mʉhʉ cahmeno saha yeya yʉhʉre, ni siniahye tiquiro Cohãcjʉ̃re. ");
INSERT INTO pirNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Sa ni tuhasa, ihtiaro tiquiro buheyequina cahapʉ wihiro, carĩñequinare ihñahye. Tiquinare ihñano Pedrore niahye: —‍¿Simo, carĩgʉ niajari mʉhʉ? ¿Ihcã hora waro yʉhʉ ihcãno mehna carĩegʉ iji masiedajari mʉhʉ? ");
INSERT INTO pirNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Quehnoano yeya mʉsa. Sa yena Cohãcjʉ̃re siniducuya mʉsa, “Ñano yeari”, nina. Mʉsa tʉhotuye mehna quehnoañene ye duamene mʉsa. Mʉsa sehsaro sa ye duepenata tire ye masiedare mʉsa, niahye Jesu Pedrore. ");
INSERT INTO pirNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Sa ni yahu tuhasa pari turi waha, Cohãcjʉ̃re siniahye. To pano tiquiro sinidiro sahata siniahye tja. ");
INSERT INTO pirNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Sa sini tuhasaro pari turi tiquina cahapʉ wihiahye tja. Sa wihiro carĩñequinare ihñahye tja. Wʉjʉa quehe yʉhdʉahye tiquina. Sa ye tiquina Jesure dʉhse ni masiedahye. ");
INSERT INTO pirNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Sa yero pari turi Cohãcjʉ̃re tiquiro sinidi bato tiquina cahapʉ wihi, tiquinare niahye: —‍¿Yojopʉ pũritare carĩnina niajari mʉsa? ¿Sorĩna niajari mʉsa? To punota ʉmʉ saro taro nine. Mianogãta yʉhʉre Cohãcjʉ̃ ohorigʉre ñañequinare tiquina ohoati pje ʉmʉ saro nine. ");
INSERT INTO pirNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Wahcãña. Isa wahana. Ihñaña. Yʉhʉre ihña tuhtiyequinare ihñoatiquiro ohõ ahtare, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Tiquiro sa nino watoata Juda, doce buheyequina mehna cjʉ̃no ijimediquiro wihiahye. Sa ye masa peyequina ñoseñe pjĩni, yucʉ tiãri cʉoyequina tiquiro mehna wihiahye. Pahia pʉhtoa, judio masare buheyequina, bʉcʉna, tiquina ohoriquina masa pehe ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Coã warore Jesure ihña tuhtiyequinare ihñoatiquiro masare ohõ saha ni yahu queo tuhasahye. —‍Wahsupure yʉhʉ ihmidiquiro tiquirota ijirota mʉsa ñeheatiquiro. Tiquirore yʉhʉ ihmidi bato ñeheña tiquirore. Sa yena quehnoano ñeheña tiquirore “Duhtiari”, nina, ni yahu tuhasahye Juda pehe. ");
INSERT INTO pirNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Sa yero wihirota Jesu cahapʉ duita waha madoqueoahye. —‍Buhegʉ, ninota wahsupure ihmiahye tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Tiquiro sa yegʉ̃ ihñañe tiquina Jesure ñeheahye. ");
INSERT INTO pirNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Tiquina sa yegʉ̃ ihñano to cahapʉ ducuyequina mehna cjʉ̃no tiquiro ñoseni pjĩne tʉã we nedoqueo, pahia pʉhtoro cahacjʉ̃nore tiquiro cahmonore dʉte pahrẽ cãhye. ");
INSERT INTO pirNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Sa yero Jesu ohõ saha niahye: —‍¿Dʉhse ijiro boro mʉsa ñoseñe pjĩni mehna, yucʉ tiãri mehna ahtana, yaqueriquirore yero saha yʉhʉre ñehena ahtajari? ");
INSERT INTO pirNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Decoripe Cohãcjʉ̃ wʉhʉpʉ mʉsare yʉhʉ buhe dujigʉ̃, mʉsa yʉhʉre ne ñehedari. Sa ijiepegʉ̃ta ahri ijipihtiye sa waharo niaga Cohãcjʉ̃ yere tiquina ni ojoariro sahata, niahye Jesu masare. ");
INSERT INTO pirNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Sa ye Jesu buheyequina tiquirore cohã cã, ijipihtiyequina oma site cãa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Sa yero wahmʉno suhti mariediquiro ihcãno coma cjũno dihita comariquiro Jesu bato nʉnʉ tãmahye. Tiquiro sa nʉnʉ tãgʉ̃ ihñañe tiquirore ñehemahye. ");
INSERT INTO pirNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Tiquirore tiquina ñehe duagʉ̃ ihñano tiquiro coma cjũnore cohã cã, suhti mariediquiro oma cãa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Sa ye pahia pʉhtoro cahapʉ Jesure ne cãhye. Sa ye ijipihtiyequina pahia pʉhtoa, bʉcʉna, ʉsã acaye judio masare buheyequina gʉ̃hʉ cahmecoahye. ");
INSERT INTO pirNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Sa yero Pedro pehe Jesu bato yoaropʉ nʉnʉ tãhye. Sa nʉnʉ tãno pahia pʉhtoa ya wʉhʉ cahapʉ esahye. Sa yero tiquiro ti wʉhʉre cohteyequina surara mehna peca dʉhtʉ cahapʉ sohma dujiahye. ");
INSERT INTO pirNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pahia pʉhtoa, ijipihtiyequina apequina pʉhtoa gʉ̃hʉ Jesure wejẽ duti duaye, ni mehoñe mehna tiquirore tiquina ñano buhiri dahreatore wacũ macañe nimahye. Tiquina yahusãtire wacũ bocaerahye. ");
INSERT INTO pirNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Sa wacũ bocaerapeta peyequina masa tiquirore sa yahusã maca cãhye. Tiquina yahusãñe poto ijierahye. Apequiro sijoro saha ni, apequiro sijoro saha niahye. ");
INSERT INTO pirNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Sa ye apequina topʉ esaye, Jesure yahusãhye. ");
INSERT INTO pirNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—‍Ahriquiro ohõ saha nidi: “Yʉhʉ ahri wʉhʉre Cohãcjʉ̃ wʉhʉre masa tiquina dahreri wʉhʉre cohãgʉtja. Sa cohãgʉ ihtia deco wahaboro ti wʉhʉre pari turi yegʉtja. Ti wʉhʉ masa tiquina dahreri wʉhʉ ijisi”, tiquiro nigʉ̃ ʉsã tʉhou, niahye ni meho yahusãñequina. ");
INSERT INTO pirNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Tiquina sa ni yahusãepegʉ̃ta tiquina yahusãñe gʉ̃hʉ poto ijierahye. Apequiro sijoro saha ni, apequiro sijoro saha niahye. ");
INSERT INTO pirNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Tiquina sa nigʉ̃ tʉhoro pahia pʉhtoro tiquina watoa ducuriquiro wahcãdʉca sa, Jesure sinituahye: —‍¿Ahriquina mʉhʉre tiquina yahusãepegʉ̃ta tiquinare yʉhti cahmedajari mʉhʉ? ¿Mʉhʉre tiquina yahusãrire dʉhse ni yʉhti cahmeajari mʉhʉ? niahye tiquiro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Tiquiro sa nigʉ̃ tʉhoeperota Jesu sata tʉhotu cãhye. Tiquiro sa yʉhtieragʉ̃ ihñano pahia pʉhtoro tiquirore sinituahye tja: —‍¿Cristota ijiajari mʉhʉ? ¿Quehnoariquiro Cohãcjʉ̃ macʉ warota ijiajari mʉhʉ? niahye tiquiro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","—‍Tiquiro tjiaja. Sa yena yʉhʉre masʉre Cohãcjʉ̃ ohorigʉre yʉhʉ Pacʉ tutuariquiro poto pehepʉ yʉhʉ dujigʉ̃ ihñanata mʉsa. Sa yena ʉhmʉse cjẽ ehmeo cururi watoa yʉhʉ ahtagʉ̃ gʉ̃hʉre ihñanata mʉsa, niahye Jesu tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","Tiquiro sa nigʉ̃ta pahia pʉhtoro pehe tiquiro sañari suhtirore tiquiro basi tʉhrẽ cãhye, apequinare “Usua yʉhdʉare”, ni ihña masi dutiro. —‍Cohãcjʉ̃re ñano yahuducuro nine ahriquiro. Sa yena tiquiro ñano yahuducuyere tʉho tuhasaja mari. Sa ye topequinata yahusãahdo ahriquirore. ¿Sa yena dʉhse yenatari mari yojopʉre ahriquirore? niahye pahia pʉhtoro apequina pʉhtoare. —‍Tiquiro ñari buhiri wejẽno cahmene tiquirore, ni yʉhtiahye apequina pʉhtoa. ");
INSERT INTO pirNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Sa ye tiquina mehna cjẽna Jesure sihco puti, tiquiro caperire dʉhte biha, tiquirore quẽpeahye. Quẽpe tuhasa ohõ saha nipeahye: —‍¿Noa pehe mʉhʉre quẽari? Ihñedapegʉta yahuya ʉsãre, ni bʉjʉpeahye tiquina. Sa ye pʉhtoro yequina surara pehe Jesure quẽpe tuhasa, neahye. ");
INSERT INTO pirNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Sa yero wʉhʉ caha ijiri paapʉ quehnoari paapʉ Pedro ijigʉ̃ pahia pʉhtoro cahacjõno wihiahye. ");
INSERT INTO pirNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pedro tiquiro sohmagʉ̃ ihñano ticoro tiquiro dihitare ihñaducuahye. —‍Nazare cjʉ̃no mehna, Jesu mehna mʉhʉ gʉ̃hʉ ijiri, niahye ticoro Pedrore. ");
INSERT INTO pirNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ticoro sa nigʉ̃ tʉhoro tiquiro ohõ saha niahye: —‍¿Dʉhse ni macago niajari mʉhʉ? Mʉhʉ nidiquirore ne masiedaja yʉhʉ, niahye Pedro ticorore. Tiquiro sa nidi bato Pedro sahrĩno sopecaha cahapʉ wahahye. Sa yero topʉ tiquiro ducugʉ̃ canaca yahuahye. ");
INSERT INTO pirNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Topʉ tiquiro ijigʉ̃ ihñano cahacjõno pehe ticoro cahapʉ ducuyequinare yahuahye tja: —‍Ahriquiro gʉ̃hʉ Jesu buheyequina mehna cjʉ̃no ijire, niahye ticoro. ");
INSERT INTO pirNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ticoro sa nigʉ̃ tʉhoro Pedro pari turi ohõ saha niahye tja: —‍Tiquirore masiedaja yʉhʉ, niahye tja. Sa yero came cjũnopʉ topʉ ducuriquina Pedrore ohõ saha niahye: —‍Ijirota ijire. Mʉhʉ Galilea cjʉ̃ ijire. Sa yegʉ tiquina mehna cjʉ̃ta ijire mʉhʉ, niahye tiquina tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Tiquina sa nigʉ̃ tʉhoro tiquiro yʉhtiahye: —‍Potota Cohãcjʉ̃ mehna niaja mʉsare. Potota yʉhʉ niedagʉ̃ Cohãcjʉ̃ yʉhʉre buhiri dahreahro. Tiquirore mʉsa nidiquirore ne masiedaga yʉhʉ, ni yʉhtiahye Pedro tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Tiquiro sa nigʉ̃ta canaca yahuahye tja. Tiquiro sa yahugʉ̃ tʉhoro Jesu tiquirore nidire wacũahye Pedro: “Canaca pʉa taha tiquiro yahuato pano mʉhʉ yʉhʉre ‘Jesure masiedaga’, nigʉta mʉhʉ. Ihtia taha sa nigʉta mʉhʉ”, Jesu tiquiro nidire wacũahye Pedro pehe. Tiquiro sa nidire wacũno, tutuaro utiahye Pedro. ");
INSERT INTO pirNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Sa ye bohrearopʉ pahia pʉhtoa, bʉcʉna, ʉsã judio masare buheyequina, ijipihtiyequina apequina pʉhtoa mehna cahmecoa, yahuducuahye tiquina yeatire masiñe tehe. Tiquina basi yahuducu tuhasa, Jesure dʉhte, ne cã, Pilatore ohoahye tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Tiquina ne sagʉ̃ ihñano Pilato tiquirore sinituahye: —‍¿Potota judio masa pʉhtota ijiajari mʉhʉ? niahye tiquiro Jesure. —‍Mʉhʉ nino sahata ijiaja, ni yʉhtiahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Sa ye pahia pʉhtoa peye yahusãhye tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Tiquina sa ni yahusãgʉ̃ tʉhoro Pilato tiquirore sinituahye tja: —‍Ahriquina mʉhʉre peye yahusãñe nine. ¿Tiquina sa yahusãepegʉ̃ta yʉhtierajari mʉhʉ? niahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Tiquiro sa niepegʉ̃ta Jesu ne pari turi yʉhti nemoedahye. Sa yero Pilato ne dʉhse ni masiedahye. ");
INSERT INTO pirNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Cʉhmaripe pascuaripe masa yaquiro ijiatiquirore ihcãquiro peresupʉ ijiriquirore tiquina cahmediquirore Pilato wio basaducue tiahye. ");
INSERT INTO pirNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ti pjere Barrabá wame tiriquiro peresupʉ ijiahye. Tiquiro pʉhtoare cohã duayequina, masare wejẽñequina mehna cjʉ̃no ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Sa ye masa peyequina Pilato cahapʉ esaye, tiquirore siniahye: —‍Cʉhmaripe ʉsãre mʉhʉ yeducuriro sahata yeya ʉsãre. Ihcãquiro peresupʉ ijiriquirore ʉsãre wio basaya, niahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Tiquina sa nigʉ̃ta Pilato tiquinare sinituahye: —‍¿Mʉsa yaquiro ijiatiquirore mʉsa judio masa pʉhtorore wio basaboagari yʉhʉ? ni sinituahye masare Jesure wio duaro. ");
INSERT INTO pirNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Jesure masa tiquina cahĩgʉ̃ ihñañe pahia pʉhtoa gʉ̃hʉ tiquirore ihña tuhtiahye. Sa ihña tuhtiye tiquirore ohoahye Pilatopʉre. Sa yero masa tiquina cahĩdi buhiri tiquina ihña tuhtirire masino Pilato Jesure wio duamahye. ");
INSERT INTO pirNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Tiquiro sa wio duepegʉ̃ta pahia pʉhtoa Jesu mehna masare usuagʉ̃ yeahye. Ohõ saha ni dutiahye tiquinare: “Barrabá pehere wioya. Jesure wejẽ dutiya”, ni dutiahye masare. ");
INSERT INTO pirNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Sa yero Pilatore Barrabáre tiquina wio dutiri bato Pilato tiquinare sinituahye tja: —‍¿Ahriquiro judio masa pʉhtoro mʉsa nidiquiro pehere dʉhse yegʉtari yʉhʉ, mʉsa sa nigʉ̃? ni sinituahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","—‍Curusapʉ quẽ biha wejẽña tiquirore, ni sañuducuahye masa. ");
INSERT INTO pirNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","—‍¿Yabe borore ñañene yeari ahriquiro, mʉsa sa ni sañuducugʉ̃? ni sinituahye tiquinare. Tiquiro sa nigʉ̃ tʉhoye tiquina sañuducu nemoahye tja: —‍Curusapʉ quẽ biha wejẽña tiquirore, ni sañuducuahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Tiquina sa ni sañuducugʉ̃ tʉhoro Pilato pehe masare bucuegʉ̃ ye duaro Barrabá pehere peresupʉ ijiriquirore wio dutiahye masa tiquina cahmediquirore. Sa yero Jesu pehere yuta dari mehna tana duti, curusapʉ quẽ biha wejẽ dutiro ohoahye surarare. ");
INSERT INTO pirNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Sa ye surara Pilato ya wʉhʉpʉ pretorio wame tiri wʉhʉpʉ tiquirore ne sahye. Ne sa tuhasa tiquina apequina surarare tiquina mehna cjẽnare cahmecoañe tehe pijioahye. ");
INSERT INTO pirNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Sa ye tiquina pʉhtoro ya suhtiro yero saha bajuri suhtirore Jesure sãa, pota behtore dahre, ti behtore tiquiro dapu bui duhu peoahye. ");
INSERT INTO pirNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Sa ye tuhasa ohõ saha ni bʉjʉpeahye tiquina tiquirore: —‍Quehnoano ahtaya. Judio masa pʉhto, quehnoano ahtaya, ni bʉjʉpeahye. ");
INSERT INTO pirNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Sa nieta yucʉgʉ mehna tiquiro dapure quẽ, tiquirore sihco puti wisõ, cua pesaro yeyequina yero saha tiquirore quehe sa, ño peoro saha yeahye. Tiquirore ñano yeye niahye. Sa ye bʉjʉpeye niahye. ");
INSERT INTO pirNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Sa yepe tuhasa tiquina sãari suhtirore tu we nedoqueo, tiquiro ye suhti pehere tiquirore sãa, tiquirore curusapʉ quẽ biha wejẽñe wahaye, nea wahahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Sa ye topʉ wahariquiro, Simo Cirene cjʉ̃no ihquẽ wʉhʉse ijiropʉ esariquiro, tiquina cahapʉ wihigʉ̃ ihñañe surara pehe tiquirore Jesu ya curusare wʉa cã dutiahye. Alejandro, Rufo pacʉro ijiahye Simo pehe. ");
INSERT INTO pirNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Waha, Gólgota wame tiropʉ esahye. Gólgota nino “Dapu pehtoro”, nino nine. ");
INSERT INTO pirNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Sa ye vinore mirra wame tiye co mehna tiquina moredi core Jesure ohomahye. Sa yero ti core sihni duerahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Sa ye curusapʉ Jesure quẽ bihahye tiquina. Quẽ biha tuhasa tiquiro suhti ijirire “¿Noa yaro ijirotari ohõ?” ni cahme doquepeahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Jesure curusapʉ tiquina quẽ bihagʉ̃ ihtia hora dʉhsahye coheri pje esato. ");
INSERT INTO pirNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Sa ye curusapʉ ohõ saha ni ojoari pjĩne duhu ohõahye tiquina tiquiro ñañe buhirire yahu duaye. “AHRIQUIRO JUDIO MASA PɄHTORO IJIRE”, ni ojoahye tiquina ti pjĩne. ");
INSERT INTO pirNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Sa ye pʉaro yaque bʉcʉna Jesu caha apeye curusaripʉ tiquina quẽ biha ohõriquina ijiahye tiquina. Ihcãquiro poto pehe, apequiro cũ pehe pehe quẽ biha ohõahye tiquina gʉ̃hʉre.  ");
INSERT INTO pirNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Tiquina sa yegʉ̃ panopʉ Cohãcjʉ̃ yere tiquina yahu ojoariro sahata waharo niahye. Ohõ saha ni ojoahye: “ ‘Dutiyere yʉhdʉdʉcayequina mehna cjʉ̃no ijire’, ni, tʉhoturi masa tiquirore”, ni ojoahye panopʉ. ");
INSERT INTO pirNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Sa ye curusari cahapʉ yʉhdʉ cãñequina Jesure ihña, tiquina dapu pacare yuredoqueo, tiquirore ñano ni yahuducuahye: —‍Quehnoare. Quehnoare. ¿Cohãcjʉ̃ wʉhʉre cohã, ihtia deco wahaboro pari turi ti wʉhʉre dahreacjʉ ijiajari mʉhʉ? ");
INSERT INTO pirNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Mʉhʉ basi dijiahya. Sa yegʉ mʉhʉ basi yedohoya. Sa yegʉ yʉhdʉ witigʉta mʉhʉ, ni bʉjʉpeahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Tiquina yero sahata pahia pʉhtoa gʉ̃hʉ ʉsã judio masare buheyequina gʉ̃hʉ tiquirore sa ni bʉjʉpeahye. Sa ni bʉjʉpeye ohõ saha niahye tiquina basi: —‍Tiquiro apequinare yʉhdʉoriquiro ijieperota tiquiro basi yʉhdʉo masiedare. ");
INSERT INTO pirNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","“Israe masa pʉhto, Cristo ijiaja”, nimedi tiquiro. Sa yena tiquiro basi dijia tagʉ̃ ihñana tiquirore wacũ tutuanata, ni bʉjʉpeahye tiquina. Sa ye yaque bʉcʉna tiquiro caha tiquina quẽ biha ohõriquina gʉ̃hʉ sata ñano ni bʉjʉpeahye tiquirore tja. ");
INSERT INTO pirNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Sa ye coheri pje ijigʉ̃ ihtia hora waro ijipihtiropʉ nahitiaa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Sa yero nahitia yʉhdʉgʉ̃ waro Jesu tutuaro sañuducuahye: —‍¿Eloi, Eloi lema sabactani? niahye tiquiro. Sa nino ohõ saha nino niahye. “¿Yʉhʉ Pacʉ, yʉhʉ Pacʉ, dʉhsegʉ yʉhʉre cohãjari mʉhʉ?” nino niahye. ");
INSERT INTO pirNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Tiquiro sa nigʉ̃ tʉhoye ihquẽquina topʉ ducuriquina ohõ saha nimahye: —‍Cohãcjʉ̃ yere yahu mʉhtariquirore Elia mʉnanore pijioro niboaga, nimahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Sa yero ihcãquiro tiquina mehna cjʉ̃no oma cã, aco ihmini sʉhtere vino sʉẽñe core tiquiro sohari sʉhtere ne cã, yucʉgʉ sohtoapʉ dʉhte ohõ, Jesure sihõmahye. Sa sihõno ohõ saha nimahye: —‍Cohteniña. Elia mʉnano ahriquirore tiquiro yʉhdʉogʉ̃ ihñarĩihna mari, nimahye tiquiro apequinare. ");
INSERT INTO pirNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Tiquiro sa nidi bato Jesu pehe tutuaro sañuducu, yariaa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Tiquiro yariagʉ̃ta Cohãcjʉ̃ wʉhʉ cjã suhtiro cahsero tore tiquina cahmotari cahsero deco mehna bui pehe tʉhnʉ dijia ta, tʉhnʉ maa cjũ saa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Tiquiro sa yariagʉ̃ ihñano surara pʉhtoro Jesu caha ducuriquiro ohõ saha niahye: —‍Ijirota ijire. Ahriquiro Cohãcjʉ̃ macʉnota ijire, niahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Sa ye yoaropʉ ducuye numia Jesure ihñaducuye niahye. Tiquina numia mehna María Magdalena ijiahye. Apecoro María wame tiricoro gʉ̃hʉ ijiahye. Ticoro pehe José, tiquiro bahʉro Santiago, tiquina pacoro ijiahye. Apecoro Salomé ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Tiquina numia Jesu yere quehnoano tʉhoyequina numia ijiye, Galilea yehpapʉ tiquiro ijigʉ̃ tiquirore yedohoe tiahye. Tiquina numia mehna peyequina apequina numia gʉ̃hʉ Jerusalẽpʉ Jesu mehna ahtariquina numia ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Sa ye ti deco tiquiro yariari deco saurú pano judio masa ʉsã sori deco pano ijiri deco ijiahye. Sa yero pascua cjẽ ijiatire tiquina quehnoyuri deco ijiahye. Ti ñamita José Arimatea cjʉ̃no cuero marieno Pilato cahapʉ esahye Jesu pagʉre sinino esaro. José judio masa ʉsã pʉhtoa mehna cjʉ̃no, pʉhtoa tiquina cua pesaro ihñariquiro waro ijiahye. Sa yero Cohãcjʉ̃ masa bui tiquiro pʉhtoro sajãtore cohtero niahye. ");
INSERT INTO pirNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Sa yero José Pilatore tiquiro sini tuhasagʉ̃ tʉhoro tʉho maria wahahye Pilato pehe. “¿Jesu yaria tuhasayari?” ni tʉhoturo, tʉho maria wahahye. Sa yero surara pʉhtorore pijio ohõ saha niahye tiquirore: —‍¿Jesu yariaa wahari? ni, sinituahye tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Tiquiro sa nigʉ̃ surara pʉhtoro yʉhtiahye: —‍Yariaa wahari, niahye. Tiquiro sa nigʉ̃ Pilato Jesu pagʉre oho dutiahye Josére. ");
INSERT INTO pirNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Tiquiro sa oho dutiri bato José quehnoari suhtirore dúahye. Dú tuhasa, Jesu pagʉre ne dijio, suhtiro mehna wahme, masa copepʉ ʉtãpʉ tiquina seheri copepʉ tiquiro pagʉre cũahye. Cũ tuhasa, ti cope caha ijiria ʉtãre pajiria ʉtãre tu torẽ cã, ti copere bihahye. ");
INSERT INTO pirNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Sa ye María Magdalena, María José pacoro Jesure tiquina cũrirore ihñahye. ");
INSERT INTO pirNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sa ye saurú yʉhdʉgʉ̃ María Magdalena, María Santiago pacoro, Salomé mehna wisõñe co ehme sitiyere dúahye tiquiro pagʉre wisõñe tehe. ");
INSERT INTO pirNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Sa ye domingo bohrea queharo Jesure tiquina cũri copepʉ wahahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Wahaducuye, ohõ saha niahye: —‍¿Ti copere biharia ʉtãre noa marine põo basarotari na? niahye tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ti copepʉ esaye, ti copere biharia ʉtãre pajiria ʉtãre tiquina põo cũriare ihñahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Sa ihñañe ti copepʉ sajã sahye. Sa sajã saye, wahmʉnore poto pehe dujiriquirore yehseye suhti tiriquirore ihña, acʉaa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Tiquina sa acʉagʉ̃ ohõ saha niahye tiquiro: —‍Yʉhʉre ihña acʉeracãhña. Jesu Nazare cjʉ̃no tiquina quẽ biha wejẽdiquiro mʉsa macariquiro masa wijia tuhasari. Ohõre mariedare. Tiquirore tiquina cũrirore ihñaña. ");
INSERT INTO pirNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","“Tiquiro mʉsa pano Galileapʉ waharota”, ni yahuna wahaya tiquiro buheyequinare, Pedro gʉ̃hʉre. Topʉ tiquiro nidiro sahata mʉsa tiquirore ihñanata, ni yahuahye wahmʉno tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Tiquiro sa nigʉ̃ tʉhoye tiquina cueye, nanare, masa cope cahapʉ ijiriquina oma cãa wahahye. Sa cueye apequinare yahuerahye.  ");
INSERT INTO pirNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Sa ye domingo ijigʉ̃ Jesu tiquiro masa wijiari bato María Magdalenare bajua mʉhtahye. Ticoro siete watĩare cʉomedicoro ijimahye. Sa yero Jesu tiquiro yariato pano watĩare tiquiro cohãnohricoro ijiahye. Sa yero ticoro pehere bajua mʉhtahye tiquiro masa wijiari bato. ");
INSERT INTO pirNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Sa ye Jesu mehna cjẽna tiquiro yariagʉ̃ ihñañe tutuaro bʉjʉa witi, utiye niahye. Sa tiquina utiri watoa ticoro pehe tiquirore ihñarire yahumahye tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","“Cristo catiri. Ihñaʉ”, ticoro ni yahuepegʉ̃ta tʉho duerahye. ");
INSERT INTO pirNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Came pʉaro tiquina mehna cjẽna wʉhʉse marienopʉ tiquina tinigʉ̃ Jesu sijoro saha bajuriquiro tiquinare bajuahye. ");
INSERT INTO pirNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Tiquiro sa bajuagʉ̃ ihñañe tiquina tojoaa waha, apequinare Jesu yequinare tire yahuahye. Tiquina sa ni yahuepegʉ̃ta tiquina pehe tʉho duerahye. ");
INSERT INTO pirNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Came doce tiquiro buheyequinare mesa cahapʉ tiquina dujigʉ̃ tiquinare bajuahye tiquiro. Sa yero tiquirore ihñariquinare tiquina yahugʉ̃ tʉho dueyequinare masino Jesu tiquinare tuhtiahye. Tiquirore tiquina quehnoano wacũ tutuerari buhirire tuhtiahye tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Sa tuhti tuhasaro tiquinare ohõ saha niahye: —‍Ahri yehpa ijipihtiropʉ quehnoañe buheyere ijipihtiyequina masare buhena wahaya. ");
INSERT INTO pirNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Yʉhʉre wacũ tutuayequinare tiquina wame yenohriquinare pecapʉ wahaboriquinare yʉhdʉorota Cohãcjʉ̃. Sa ye yʉhʉre wacũ tutueyequina Cohãcjʉ̃ tiquiro buhiri dahreatiquina pecapʉ wahatiquina ijieta. ");
INSERT INTO pirNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Sa ye yʉhʉre wacũ tutuayequina yʉhʉ tutuaye mehna ohõ saha yeeta: Yʉhʉ tutuaye mehna, yʉhʉ wame mehna watĩare cohãeta. Sa ye wahma yahuducuyere yahuducueta. ");
INSERT INTO pirNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Sa ye añaare tiquina ñehegʉ̃, ijipihtiye nima dʉhse ijiye nimare tiquina sihnigʉ̃, tiquinare ne purĩsi. Sa ye dohatiyequina bui tiquina omocarine tiquina ña peogʉ̃ dohatiyequina pehe quehnoa wahaeta, niahye Jesu tiquiro buheyequinare. ");
INSERT INTO pirNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Sa ni yahu tuhasa mari pʉhtoro Jesu ʉhmʉsepʉ mʉjaa wahahye. Topʉ esaro Cohãcjʉ̃ poto pehe dujiahye tiquiro mehna pʉhtoro ijiro. ");
INSERT INTO pirNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Sa ye Jesu buheyequina ijipihtiropʉ quehnoañe buheyere buheye wahaa wahahye. Tiquina sa buhegʉ̃ mari pʉhtoro tiquinare yedohoahye. Tiquiro tutuaye mehna ye ihño, masigʉ̃ yeahye tiquinare, masare tiquiro ye buheyere tʉho dutiro. To punota ijire.");
INSERT INTO pirNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Pʉhto Teófilo, ahrire mʉhʉ buheatire mʉhʉre ojoa ohogʉ niaja. Jesu ʉsã mehna ijinino tiquiro yerire apequina ojoa dʉca tuhasari jiri. Coã waropʉre Jesure ihñariquina, tiquiro yere buheriquina tiquina ni yahuriro sahata apequina tire ojoa dʉca tuhasari jiri. ");
INSERT INTO pirNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Sa yegʉ ahri ijipihtiyere quehnoano masi peho duagʉ buhei. Sa yegʉ yʉhʉ gʉ̃hʉ tire quehnoano ojoa duaja mʉhʉ buheatire yegʉ. ");
INSERT INTO pirNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Jesu yere yahuyequina mʉhʉre buhe tuhasari. Tire quehnoano mʉhʉ masi nemoatire ahri pũre mʉhʉre ojoa ohogʉ niaja. ");
INSERT INTO pirNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Jesu masa bajuato pano, Herode Judea yehpa cjẽna pʉhtoro tiquiro ijigʉ̃ Zacaria wame tiriquiro pehe pahi ijiahye. Sa yero Zacaria tiquiro ya curua cjẽna pehe pahia curua Abia mʉnano ya curua cjẽna ijiahye. Zacaria namono gʉ̃hʉ pahi Aaron mʉnano panameono iji turiaricoropʉ ijiahye. Ticoro pehe Elisabe wame tiricoro ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Tiquina pʉaro Cohãcjʉ̃ dutiyere quehnoano ye pehoyequina tiquina ijigʉ̃ ihñano, “Decoripe quehnoañene yere”, ni ihñahye Cohãcjʉ̃ tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Elisabe ne pohna marienicoro ijiahye. Ticoro Zacaria mehna sata muhñu cãhye pohna mariedape. ");
INSERT INTO pirNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Pahia dahrayere dahraye tehe, decoripe tiquina camesae tiahye. “Zacaria ya curua cjẽna ijire”, tiquina nidi bato tiquiro pahia decoripe tiquina yeducuriro saha Cohãcjʉ̃ ya wʉhʉpʉ dahraro taro niahye Zacaria. ");
INSERT INTO pirNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Pahia sa yeducuriro saha tiquina “¿Noare ijirotari ʉjʉ̃a mʉoatiquiro?” niñe, doquepeye mehna bueyere ehme sitiyere ʉjʉ̃a mʉoatiquirore beseahye. Cohãcjʉ̃re ño peori altarpʉ tiquina beseriquiro Zacaria ehme sitiyere ʉjʉ̃a mʉoatiquiro ijiahye. Sa yero tiquiro Cohãcjʉ̃ wʉhʉpʉ sajãa wahahye ʉjʉ̃a mʉono waharo. ");
INSERT INTO pirNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Wʉhʉpʉ ijiro ehme sitiyere tiquiro ʉjʉ̃a mʉono watoa ijipihtiyequina masa pehe sopecahapʉ Cohãcjʉ̃re sinie tiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ti pjere Cohãcjʉ̃ yaquiro angel Cohãcjʉ̃re ño peori altar poto pehe bajuadʉca sahye Zacariare. ");
INSERT INTO pirNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Tiquiro sa bajuagʉ̃ ihñano Zacaria tiquirore ihña maria, cuea wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Sa tiquiro cuegʉ̃ ihñano angel tiquirore yahuahye: —‍Zacaria, cueracãhña. Cohãcjʉ̃ mʉhʉ sinidire tʉhori. Sa yena mʉsa pohna tinata. Mʉsa macʉ masa bajuarota. Tiquiro bajuagʉ̃ Ñu wame yeya tiquirogãre. ");
INSERT INTO pirNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","17","“Tiquiro quehnoariquiro, tutuariquiro ijire”, ni, ihñanota Cohãcjʉ̃ mʉhʉ macʉre. Tiquiro masa bajuari bato vinore, sihbiorire sihnisi. Sa yero tiquiro masa bajuari bato Espíritu Santo nidiro sahata yeriquiro ijirota tiquiro. Sa yero peyequina mʉhʉ acaye Israe masare Cohãcjʉ̃ mari pʉhtorore quehnoano cahmegʉ̃ yerota mʉhʉ macʉ. Sa yero tiquiro Cohãcjʉ̃ yere buhero Elia mʉnano Cohãcjʉ̃ yere yahu mʉhtariquiro tiquiro buheriro sahata Espíritu Santo yedohoro mehna Cohãcjʉ̃ tutuaye mehna mʉhʉ macʉ gʉ̃hʉ buherota. Sa buhero tiquina pacʉsʉmʉa tiquina pohne mehna quehnoano cahme cahĩgʉ̃ yerota. Sa yero dutiyere yʉhdʉdʉcariquinare quehnoano tiquina ño peoye mehna yʉhtigʉ̃ yerota. Sa buhero mari pʉhtoro Cohãcjʉ̃ yequina ijiatire yerota tiquiro. Sa yegʉ tiquiro masa bajuari bato mʉhʉ bucuegʉta. Peyequina apequina gʉ̃hʉ bucueeta, niahye angel Zacariare. ");
INSERT INTO pirNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Tiquiro sa nigʉ̃ tʉhoro Zacaria pehe sinituahye angelre: —‍Ʉsã bʉcʉna ijiaja. ¿Sa yegʉ mʉhʉ nidi poto ijigʉ̃ dʉhse masigʉtari yʉhʉ? niahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Tiquiro sa nigʉ̃ angel pehe tiquirore yahuahye: —‍Yʉhʉ Gabriel wame tigʉ ijiaja. Cohãcjʉ̃ cahacjʉ̃ tiquiro cahapʉ ducugʉ ijiaja yʉhʉ. Cohãcjʉ̃ ahri quehnoañe quitire yahu dutiro, mʉhʉ cahapʉ yʉhʉre ohori. ");
INSERT INTO pirNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Yʉhʉ yahuriro sahata potota waharota. Yʉhʉ sa niepegʉ̃ta yʉhʉre mʉhʉ poto tʉhoerari. Sa yegʉ yojopʉre mʉhʉ yahuducuegʉ wahagʉta. Mʉhʉ macʉ tiquiro bajuari bato yahuducugʉta tja, niahye angel Zacariare. ");
INSERT INTO pirNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Sopecahapʉ ijiyequina masa Zacariare cohteye niahye. “¿Dʉhse ijiro boro tiquiro Cohãcjʉ̃ wʉhʉpʉ ijiro, sojaro wijia taerajari?” ni, cohteye niahye masa tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Sa yero ti wʉhʉpʉ ijiriquiro wijia wihi, tiquina mehna yahuducu masiedahye. Tiquiro sa yahuducu masiedagʉ̃ ihñañe “Tiquiro Cohãcjʉ̃ wʉhʉpʉ bajuanohno niaya”, ni, tʉhotuahye tiquina. Sa yero yahuducu masiedaro tiquiro omocari mehna masare yahuducuahye. ");
INSERT INTO pirNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Cohãcjʉ̃ wʉhʉpʉ tiquiro dahraye pihtigʉ̃, tojoaa wahahye tiquiro ya wʉhʉpʉ. ");
INSERT INTO pirNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Tiquiro sa wahari bato tiquiro namono Elisabe coã nijinore cʉo cãhtaro niahye. Sa yero ticoro ihcã omope asʉ̃ri waro masa cahapʉ wahaerahye. ");
INSERT INTO pirNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ohõ saha niahye ticoro: “Yojopʉre yʉhʉre Cohãcjʉ̃ yedohori. Yʉhʉ pohna mariego ijigo tutuaro bʉoro tʉhotuu yʉhʉ. Cohãcjʉ̃ yedohoro mehna nijinogãre bocagota”, ni tʉhotuahye ticoro. ");
INSERT INTO pirNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Elisabe seis asʉ̃ri ticoro niji pacoro ticoro ijiri bato Cohãcjʉ̃ pehe angel Gabriel wame tiriquirore nuhmino cahapʉ ohoahye. Ticoro Nazarepʉ Galilea yehpapʉ ijiri macapʉ ijiahye. María wame tiricoro ijiahye. José wame tiriquiro ijiahye ticoro mehna omoca dʉhteatiquiro. Tiquiro panopʉ cjʉ̃no Davi mʉnano panamino iji turiariquiro ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Sa yero María cahapʉ esaro, angel yahuahye: —‍¿Ne, ijiajari mʉhʉ, María? Cohãcjʉ̃ mʉhʉ mehna ijiro nine. Sa yero mʉhʉre quehnoano yero nine. Ijipihtiye numia apequina numia yʉhdʉoro quehnoano yere mʉhʉre, niahye angel ticorore. ");
INSERT INTO pirNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Tiquiro sa nigʉ̃ tʉhoro, ticoro tutuaro wacũ tʉhotuahye. Angel tiquiro yahurire tʉhoturo “¿Dʉhse nino yʉhʉre sa niagari?” ni wacũahye ticoro. ");
INSERT INTO pirNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ticoro sa ni wacũgʉ̃ ihñano angel yahuahye ticorore: —‍María, Cohãcjʉ̃ mʉhʉre tutuaro cahĩne. Sa yego mʉhʉre yʉhʉ yahuatire tʉho acʉeracãhña. ");
INSERT INTO pirNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Quehnoano tʉhoya. Nijinore bocagota mʉhʉ. Sa yero mʉhʉ macʉ masa bajuarota. Tiquirore Jesu wame yegota mʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","33","Tiquiro tutua yʉhdʉariquiro ijirota. Sa ye tiquirore “Cohãcjʉ̃ ʉhmʉse cjʉ̃no macʉno ijire”, nieta masa. Sa yero mʉhʉ macʉ ñecʉno iji turiariquiro mʉnanopʉ Davi mʉnano Israe masa tiquina pʉhtoro tiquiro ijiriro sahata mʉhʉ macʉ gʉ̃hʉre cũnota Cohãcjʉ̃. Sa yero ijipihtiye decori tiquiro Israe masare dutirota. Sa yero tiquiro pʉhtoro ijiye pehe ne pihtisi, niahye angel. ");
INSERT INTO pirNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Tiquiro sa nigʉ̃ María pehe sinituahye: —‍¿Dʉhse yʉhʉ manʉ mariedapegota pohna tiboagari yʉhʉ? niahye ticoro. ");
INSERT INTO pirNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ticoro sa nigʉ̃ angel pehe yahuahye: —‍Espíritu Santo mʉhʉre pohna tigʉ̃ yerota. Sa yero Cohãcjʉ̃ tiquiro tutuaye ehmeo curua yero saha ahtarota mʉhʉre. Sa ye “Cohãcjʉ̃ macʉno ijire”, nieta masa mʉhʉ macʉre ñañe yerariquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","37","Cohãcjʉ̃ ijipihtiyere ye masine. Sa yero mʉhʉ acayoro Elisabe bʉcʉoro ijieperota nijinogãre bocari ticoro gʉ̃hʉ. Ticoro pohna tirota ʉmʉnogãre. Masa ticorore “Pohna marienicoro ijire”, tiquina nidicoro, yojopʉre seis asʉ̃ri waro wahare nijino ticoro bocari bato, niahye angel Maríare. ");
INSERT INTO pirNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Tiquiro sa nigʉ̃ María yʉhtiahye: —‍Yʉhʉre tʉhoya. Mari pʉhtoro tiquiro cahacjõ ijiaja yʉhʉ. Mʉhʉ nidiro saha yʉhʉre sa wahaahro, niahye ticoro. Ticoro sa nidi bato angel wahaa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Tiquiro sa nidi bato María cʉnʉ cjʉ ijiri yehpapʉ Judea yehpapʉ ijiri macapʉ sojaro mehna wahaa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Topʉ esaro, Zacaria ya wʉhʉpʉ sajãno, “¿Ne, ijiajari?” niahye ticoro Elisabere. ");
INSERT INTO pirNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ticoro sa nigʉ̃ Elisabe tʉhogʉ̃ta, ticoro macʉno pehe niji suhtiropʉ ijiriquiro ñuhmiahye. Elisabe Espíritu Santo dutiriro sahata ye pehoricoro ijiro, tiquiro tutuayere cʉoricoro ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Sa yero tutuaro bucueye mehna ticoro tutuaro yahuducuahye. —‍Ijipihtiyequina numia yʉhdʉoro mʉhʉre quehnoano yeri Cohãcjʉ̃. Mʉhʉ macʉ gʉ̃hʉre quehnoano yeri Cohãcjʉ̃. ");
INSERT INTO pirNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Cuehi, yʉhʉ pʉhtoro pacoro yʉhʉ cahapʉ ahtagʉ̃ quehnoano yeri yʉhʉre Cohãcjʉ̃. ");
INSERT INTO pirNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Mʉhʉ yʉhʉre “¿Ne, ijiajari?” mʉhʉ nigʉ̃ yʉhʉ macʉ pehe niji suhtiropʉ ijiriquiro bucueye mehna ñuhmiahti yʉhʉre. ");
INSERT INTO pirNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Cohãcjʉ̃ tiquiro nidiro sahata yerota. Sa yego tiquiro yahurire tʉhorigo ijigo bucuego ijire mʉhʉ, niahye Elisabe. ");
INSERT INTO pirNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ticoro sa nigʉ̃ María yʉhtiahye: “Cohãcjʉ̃ quehnoariquiro, tutuariquiro ijire”, niaja. Yʉhʉ quehnoano jeripohna tiaja. ");
INSERT INTO pirNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Cohãcjʉ̃ yʉhʉre pecapʉ wahaborigore yedohoriquiro ijire. Sa yero yojopʉre yʉhʉre quehnoano bucueye mehna ijigʉ̃ yere. ");
INSERT INTO pirNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","49","Yʉhʉre tiquiro cahacjõre wacũri jiri. Cohãcjʉ̃ tutua yʉhdʉariquiro quehnoañe dihitare yʉhʉre yedohori. Sa ye yojopʉre “Ticorore Cohãcjʉ̃ quehnoano yeri”, ijipihtiyequina masa sa ni, yahuducueta yʉhʉre. Cohãcjʉ̃ ñañe marieniquiro ijire. ");
INSERT INTO pirNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ijipihtiye decori ijipihtiyequina tiquirore ño peoyequinare tiquiro paja ihñariquiro ijire. ");
INSERT INTO pirNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Cohãcjʉ̃ tiquiro tutuaye mehna yeahye. “Apequinare masi yʉhdʉdʉcaja”, niñequinare yʉhdʉdʉcahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Pʉhtoare cohãhye tiquiro. Sa yero cahacjẽna pehere pʉhtoa yero saha cũahye tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ʉjʉa ahbayequinare tiquiro quehnoañe ihyayere ohoahye. Sa yero peye doeri cjẽ cʉoyequinare doeri cjẽ cʉoeragʉ̃ yeahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Mari ñecʉsʉmʉa iji turiayequina mʉnare tiquiro yahu cũriro sahata ye pehoahye Cohãcjʉ̃. “Pecapʉ wahaboriquinare yʉhdʉoutja”, tiquiro ni yahu cũriro sahata ye pehoahye. Sa yero tiquiro cahacjẽnare Israe masare tiquiro yedohoahye. Abrahã mʉnanore mari ñecʉsʉmʉa mʉnare ijipihtiyequina tiquiro acaye tiquiro bato ijiyequina gʉ̃hʉre Cohãcjʉ̃ ijipihtiye decori sa paja ihñaducuriquiro ijie tiahye. Tiquinare tiquiro yahu cũrire boerahye Cohãcjʉ̃, niahye María. ");
INSERT INTO pirNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ihtia asʉ̃ waro Elisabe mehna ijiahye. To puno ticoro ijiri bato ticoro ya macapʉ tojoaa wahahye María. ");
INSERT INTO pirNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabe ticoro niji wahcõ, pohna tiahye. Ticoro macʉno masa bajuahye. ");
INSERT INTO pirNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Sa yero Cohãcjʉ̃ ticorore tiquiro sa yegʉ̃ ticoro ya maca cjẽna ticoro acaye gʉ̃hʉ ticoro mehna bucueahye. ");
INSERT INTO pirNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ocho decori tiquiro masa bajuari bato, tiquiro pacʉsʉmʉa tiquirogãre cuhnucunʉ sohtoa cahserogãre yʉhre ne dutiye tee niahye. Sa yeye tiquina mehna cjẽna tiquina cahapʉ esahye tiquina yʉhre negʉ̃ ihñañe tehe. Tiquina mehna cjẽna Zacaria tiquiro pacʉro wamene tiquirogãre wame ye duamahye. ");
INSERT INTO pirNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Tiquina sa wame ye duepegʉ̃ta tiquiro pacoro ohõ saha niahye: —‍Tiquiro pacʉro wamene wame yeraja. Ñu wame yenatja tiquirogãre, niahye ticoro. ");
INSERT INTO pirNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","—‍Mʉhʉ acaye ne ihcãquiro Ñu wame tiriquiro mariedare, niahye tiquina ticorore. ");
INSERT INTO pirNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Sa ye tiquina omocari mehna yahuducu, Zacariare sinituahye tiquina: —‍¿Mʉhʉ waro dʉhse wame ye duajari mʉhʉ macʉre? ni, sinituahye tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Tiquina sa nigʉ̃ tiquiro pehe ojoari pjĩne sini, ñehe, ojoahye: “Yʉhʉ macʉ Ñu wame tirota”, ni, ojoahye Zacaria. Tiquiro sa ni ojoagʉ̃ tiquina pehe tʉho maria wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Tiquiro sa ni ojoari bato tiquirore yahuducugʉ̃ yeahye Cohãcjʉ̃. Sa yero tiquiro yahuducua wahahye. —‍Cohãcjʉ̃ tutuariquiro, quehnoariquiro ijire, niahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Tiquiro sa ni yahuducugʉ̃ tʉhoye to cjẽna tʉho maria wahahye. Sa ye ahri ijipihtiyere Judea yehpa cjẽnare cʉnʉ cjʉ watoa ijiyequinare masa yahu siteahye. Sa ye masa to cjẽna quehnoano masi pihtia wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ijipihtiyequina tire tʉhoye wacũahye. “Cohãcjʉ̃ tutuayere ahriquirogã cʉore. Sa yero ihyo ijiriquiro ijisi tiquirogã”, ni, tʉhotuahye masa. ");
INSERT INTO pirNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Sa yero tiquiro pacʉro Zacaria Espíritu Santo dutiriro sahata ye pehoriquiro ijiro tiquiro tutuayere cʉoriquiro ijiro Cohãcjʉ̃ yere yahuahye: ");
INSERT INTO pirNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Cohãcjʉ̃re ño peouhna mari. Mari Israe masa tiquiro yequina ijiaja mari. Sa yero mari cahapʉ wihiro, marine yedohoro quehnoano yʉhdʉgʉ̃ yerota. ");
INSERT INTO pirNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Sa yero Cohãcjʉ̃ tutuariquirore marine pecapʉ wahaborinare quehnoano yʉhdʉgʉ̃ yeatiquirore ohori jiri. Marine quehnoano yʉhdʉoatiquiro tiquiro acayʉro mʉnano Davi ijire. Davi mʉnano pehe marine yʉhdʉoatiquiro cahacjʉ̃no ijire. ");
INSERT INTO pirNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Panopʉ tiquiro yere yahu mʉhtariquinare Cohãcjʉ̃ ohõ sahata ni ahrire yahu dutiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Marine ihña tuhtiyequina marine ñano tiquina ye duagʉ̃ ihñano “Mʉsare yedohoutja”, ni, cũahye Cohãcjʉ̃ marine. ");
INSERT INTO pirNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Mari ñecʉsʉmʉa mʉnare “Mʉsare paja ihñagʉ, yedohoutja. Mʉsare yʉhʉ yahu cũrire wacũtja”, niahye Cohãcjʉ̃ mari ñecʉsʉmʉa iji turiayequina mʉnare. Ti pjepʉre tiquiro nidiro sahata marine yojopʉre yere. ");
INSERT INTO pirNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","75","Ohõ saha ni cũahye Cohãcjʉ̃ panopʉre Abrahãre: “Mʉhʉ acaye camepʉ ijiyequinare ihña tuhtiyequina tiquina ijigʉ̃ cohãʉtja. Sa yegʉ mʉhʉ acayere yedohoutja. Sa ye tiquina cuero marieno yʉhʉ dutiyere ye masieta. Sa yegʉ tiquina ñañene yʉhʉ cohãgʉ̃, tiquina yʉhʉ ihñonopʉ ijipihtiye decori quehnoañequina ijiducueta”, ni, yahu cũahye panopʉ Cohãcjʉ̃ mari acayʉro mʉnanore Abrahãre, niahye Zacaria. Sa ni tuhasa tiquiro macʉnore ohõ saha niahye: ");
INSERT INTO pirNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","77","Macʉ, mʉhʉre ohõ saha nieta masa: “Cohãcjʉ̃ tutua yʉhdʉariquiro tiquiro yere yahu mʉhtariquiro ijire”, nieta mʉhʉre. Sa yegʉ mʉhʉ mari pʉhtoro Cristo pano wahayugʉta mʉhʉ. Sa wahagʉ ohõ saha ni yahugʉta mʉhʉ. “Cohãcjʉ̃ mʉsa ñañene cohãno, pecapʉ wahaborinare yʉhdʉorota mʉsare”, ni, yahugʉta mʉhʉ. Sa ni yahugʉ mari pʉhtoro tiquiro ahtatire yahuyugʉ nigʉta mʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Cohãcjʉ̃ pehe marine tutuaro paja ihñariquiro marine quehnoano yeriquiro ijiro, tiquiro marine pecapʉ wahaborinare yʉhdʉo duare. Marine yʉhdʉoro ahtaro Cristo mari cahapʉ ahtarota. ");
INSERT INTO pirNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ijipihtiyequina marine pecapʉ wahaborinare yʉhdʉo duare tiquiro. Sa yero Cohãcjʉ̃re masiena mari ijigʉ̃ ihñano marine masigʉ̃ ye duare tiquiro. Sa yero mari quehnoano ihcãno mehna mari ijiatire yahurota marine, niahye Zacaria. ");
INSERT INTO pirNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Sa yero Zacaria macʉno quehnoano pagʉ tiriquiro masahye. Sa yero Cohãcjʉ̃re tutuaro ño peoahye. Sa yero yoari pje masa marienopʉ ijie tiahye. Israe masare buhe dʉcaro topʉta ijie tiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ti pjere ijipihtiye yehpari cjẽna pʉhtoro Augusto ijie tiahye. Sa yero ijipihtiyequinare queo dutiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ahriquina masare tiquina coã queo dʉcagʉ̃ Siria yehpa cjẽna pʉhtoro Cirenio wame tiriquiro ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Sa ye ijipihtiyequina tiquina ñecʉsʉmʉa panopʉ cjẽna ye macaripʉ tiquina wamene ojoa ohõñe wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","José gʉ̃hʉ Nazarepʉ Galilea yehpapʉ ijiri macapʉ ijiriquina waha, Judea yehpapʉ Belẽ wame tiri macapʉ esahye. Pʉhtoro Davi mʉnano panopʉ cjʉ̃no tiquiro masa bajuariro ijiahye Belẽ. José Davi mʉnano panamino iji turiariquiro ijiro Belẽpʉ tiquiro wamene ojoa ohõ dutiro wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Sa yero María tiquiro omoca dʉhteaticoro mehna topʉ tiquiro wamene ojoa ohõ dutiro esahye. Ticoro pehere meheñe decorigã dʉhsahye nijino bajuato. ");
INSERT INTO pirNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Sa yero Belẽpʉ esaro ticoro niji wahcõahye. ");
INSERT INTO pirNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Topʉre masa tiquina carĩni wʉhʉ ne esa tuhaerahye tiquinare. Sa yero ticoro pohna ti tuhasa, tiquirogãre suhtiro mehna coma, wecʉa tiquina ihyari cohropʉ, taa bui tiquirogãre duhu peoahye. Tiquirogã ticoro coã macʉ ti mʉhtariquirogã ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ti ñamine oveja tiquina ijiropʉ ovejare ihña ihboyequina tiquina yequina ovejare ihña ihboye niahye. ");
INSERT INTO pirNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Sa yero Cohãcjʉ̃ ohoriquiro angel tiquinare bajuahye. Tiquiro sa bajuagʉ̃ Cohãcjʉ̃ asi siteye tiquinare buhrioahye. Tiquiro sa asi sitegʉ̃ ihñañe, ovejare ihña ihboyequina cuea wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Tiquina sa wahagʉ̃ angel tiquinare yahuahye: —‍Quehnoañe quitire mʉsare yahugʉ ahtaja. Ijipihtiyequinare masare bucuegʉ̃ yerota ahri quiti. Sa yena yʉhʉre cueracãhña mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Mia ñamine pʉhtoro Davi mʉnano ya macapʉ mʉsare pecapʉ wahaborinare yʉhdʉoatiquiro, Cristo Cohãcjʉ̃ ohoriquiro mari pʉhtoro masa bajua tuhasari. ");
INSERT INTO pirNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Sa yero suhtiro mehna comariquirogã wecʉa ihyari cohro bui tiquina duhu peoriquirogã mʉsa ihñatiquirogã tiquiro ijirota, ni yahuahye angel tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tiquiro sa nigʉ̃ta peyequina ʉhmʉse cjẽna iji mʉhtariquiro angel mehna Cohãcjʉ̃re ño peoahye. Ohõ saha ni ño peoahye tiquina: ");
INSERT INTO pirNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Cohãcjʉ̃re ʉhmʉse cjʉ̃nore ño peouhna. Sa ye Cohãcjʉ̃ tiquiro cahĩñequina cuero marieno cahmequeno marieno quehnoano ijiahro, ni, ño peoahye angele pari. ");
INSERT INTO pirNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Sa ni tuhasa ʉhmʉsepʉ tiquina mʉjari bato ovejare ihña ihboyequina pehe tiquina basi cahme yahuducuahye: —‍Ahrire Cohãcjʉ̃ marine tiquiro yahurire Belẽpʉ isa ihñaʉhna, niahye tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Sa niñe sojaro mehna wahaa wahahye. Tiquina Maríare, Josére boca sa, nijinogãre wecʉa ihyari cohropʉ tiquina duhu peoriquirogãre ihñahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ovejare ihña ihboyequina tiquirogãre ihña tuhasa nijinogãre angel tiquiro yahurire yahuahye apequinare. ");
INSERT INTO pirNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Tiquina sa ni yahugʉ̃ ijipihtiyequina tiquinare tʉho maria wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ahri ijipihtiyere María wacũ tʉhotuahye. ");
INSERT INTO pirNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Sa yeye ovejare ihña ihboyequina pehe angel tiquiro yahuriro saha ijigʉ̃ ihñañe, “Cohãcjʉ̃ tutuariquiro ijire”, ni bucueahye. Sa ni bucueye tojoaa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ihcã semana bato nijinogã tiquiro cuhnucunʉ sohtoa cahserogãre yʉhre ne tuhasa tiquirogãre tiquina Jesu wame yeahye. Jesure coã waro ticoro bocato pano angel pehe “Jesu wame yeya tiquirogãre”, ni yahu tuhasahye. Sa yeye tiquirogãre Jesu wame yeahye. ");
INSERT INTO pirNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Cohãcjʉ̃ dutiye Moise tiquiro yahuriro saha yeye tehe, José, María mehna Jerusalẽpʉ wahahye. Topʉ wahahye María ticoro pohna tiri bato pagʉ quehnoaricoro ticoro tojoarire ihñono taro. Cohãcjʉ̃ dutiriro sahata tiquina minicjʉare ohoye wahahye Cohãcjʉ̃re ño peoye. Ohõ saha dutiahye Cohãcjʉ̃: “Bujuaare pʉaro ohoya yʉhʉre. O tiquina mariedagʉ̃ apequina boro minicjʉare ohoya yʉhʉre ño peona”, ni dutiahye Cohãcjʉ̃. Tiquiro dutiriro sahata yeahye tiquina ticoro pagʉ quehnoari pagʉ ticoro waharire ihñoñe taye. Topʉ wahaye tiquina Jesugãre neahye. Tiquirogãre Cohãcjʉ̃re “Ahriquirogã mʉhʉ yaquiro ijiatiquirogã ijire”, ni ihñoñe wahahye. Ohõ saha yeahye Cohãcjʉ̃ yere tiquina ojoari pũpʉ tiquiro ye dutiriro sahata. “Ijipihtiyequina mʉsa pohna coã bajua mʉhtañequinagãre Cohãcjʉ̃re ihñoña. ‘Ahriquirogã mʉhʉ yaquirogã ijiatiquiro ijire’, ni ihñoña”, ni dutiahye Cohãcjʉ̃. Sa ye tiquiro dutiriro sahata yeahye tiquina, Jerusalẽpʉ ijiye. ");
INSERT INTO pirNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ti macapʉ Simeo wame tiriquiro ijiahye. Tiquiro quehnoariquiro, Cohãcjʉ̃re ño peoriquiro ijiro, Israe masare Cohãcjʉ̃ yedohoatire cohteriquiro ijiahye. Sa yero Simeo Espíritu Santo tiquiro nidiro saha yeriquiro ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Sa yero tiquiro yariato pano Cohãcjʉ̃ tiquiro ohoatiquirore Cristore tiquiro ihñatire yahuahye Espíritu Santo tiquirore Simeore. ");
INSERT INTO pirNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Sa yero Espíritu Santo tiquirore dutigʉ̃ Cohãcjʉ̃ wʉhʉpʉ sajãa wahahye. Tiquiro sajã sari bato Jesu pacʉsʉmʉa tiquina macʉnogãre ne sajãhye. Cohãcjʉ̃ tiquiro dutiriro sahata yeye niahye. ");
INSERT INTO pirNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeo pehe tiquirogãre wʉa ne, Cohãcjʉ̃re ño peo, “Quehnoare”, ni, tiquiro mehna yahuducuahye. Ohõ saha niahye tiquiro Cohãcjʉ̃re: ");
INSERT INTO pirNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","32","Yojopʉ pũritare pʉhto, mʉhʉ nidiro sahata masare pecapʉ wahaboriquinare yʉhdʉoatiquirore ohori jiri mʉhʉ. Tiquiro judio masa ijieyequinare buhero mʉhʉre quehnoano masigʉ̃ yerota tiquinare. Masare yʉhdʉoatiquiro Israe masʉnore mʉhʉ cũahye. Ʉsã acayʉrore Israe masʉnore mʉhʉ cũgʉ̃ ijipihtiyequina masiñe, “Israe masare quehnoano yere Cohãcjʉ̃”, nieta masa. Ahriquirogã ʉsãre yʉhdʉoatiquiro ijire. Sa yegʉ ahriquirogãre ihña tuhasagʉ, yojopʉre quehnoano bucuegʉ yariʉtja, niahye Simeo. ");
INSERT INTO pirNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeo tiquirogãre tiquiro sa nigʉ̃ tiquirogã pacʉsʉmʉa pehe tʉho maria wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Sa yero Simeo tiquinare “Quehnoano ijiya mʉsa”, nino tiquiro María Jesu pacorore yahuahye: —‍Cohãcjʉ̃ ahriquirogãre beseahye. Sa beseriquirogã tiquiro ijiepegʉ̃ta judio masa peyequina tiquirore yʉhdʉdʉcaeta. Sa ye tiquina pecapʉ wahaeta. Sa yero judio masare peyequina tiquiro yʉhdʉoatiquiro gʉ̃hʉre Cohãcjʉ̃ beseri tiquirogãre. Tiquiro Cohãcjʉ̃ yere yahuriquiro tiquiro ijiepegʉ̃ta masa peyequina tiquirore ñano ni yahuducueta. ");
INSERT INTO pirNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Tiquina sa yegʉ̃ apequina tiquina ñano wacũñene masieta. Sa yego mʉhʉ tutuaro purĩno yero saha bʉjʉa witigota, niahye Simeo Maríare. ");
INSERT INTO pirNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Topʉ Cohãcjʉ̃ yere yahu mʉhtaricoro Ana wame tiricoro ijiahye. Ticoro Fanuel macono ijiro, Aser mʉnano ya curua cjõno ijiahye. Bʉcʉoro waro ijiahye. Ticoro nuhmino ijiro manʉ tiahye. Sa yero siete cʉhmari waro ticoro manʉno mehna ijiahye. To puno tiquiro ijiri bato ticoro manʉno yariaa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Sa yero ochenta y cuatro cʉhmari waro wape wihoro ijie tiahye ticoro. Sa yero ticoro deco gʉ̃hʉre ñami gʉ̃hʉre Cohãcjʉ̃ yere yero taro siji, Cohãcjʉ̃ mehna yahuducu, Cohãcjʉ̃ wʉhʉre ne wijiaera tiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simeo tiquiro yahuducuri watoa ticoro tiquina cahapʉ wihiro, bucuero, Cohãcjʉ̃re “Quehnoare”, niahye. Sa yero Jerusalẽ cjẽnare pecapʉ wahaboriquinare yʉhdʉoatiquirore cohteyequinare ticoro Jesugãre yahuahye peyequina masare. ");
INSERT INTO pirNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Cohãcjʉ̃ dutiriro sahata ye tuhasaye, tiquina ya macapʉ Nazarepʉ tojoaa wahahye. Galilea yehpapʉ ijiahye ti maca Nazare. ");
INSERT INTO pirNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Sa yero Jesu quehnoano masa, tutuariquiro wahahye. Sa yero tiquiro quehnoano tʉho masiniquiro ijiahye. Sa yero tiquirore Cohãcjʉ̃ quehnoano yeahye. ");
INSERT INTO pirNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Cʉhmaripe Jesu pacʉsʉmʉa Jerusalẽpʉ pascua decorire bose decorire ihñañe wahae tiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jesu doce cʉhmari tiquiro cʉogʉ̃ tiquina yeducuriro sahata tiquina ijipihtiyequina Jerusalẽpʉ wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Sa yeye bose decorire ihña tuhasa tiquina ya macapʉ tojoaa wahahye tja. Tiquina sa tojoepegʉ̃ta Jesu pehe Jerusalẽpʉ tojoa cãhye. Tiquiro pacʉsʉmʉa tiquiro tojoa queherire masiedahye. ");
INSERT INTO pirNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","“Tiquiro mari mehna cjẽna mehna ijiaga”, ni tʉhotumahye tiquina. Sa ye tiquina ihcã deco waro Jesu marieno wahamahye. Sa ye tiquina Jesure tiquina acaye watoa macamahye. ");
INSERT INTO pirNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ne bocaerahye. Sa ye tiquina Jerusalẽpʉ tiquirore macañe wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ihtia deco bato Cohãcjʉ̃ wʉhʉpʉ tiquirore boca sahye. Sa yero Jesu judio masare buheyequinare tʉho, tiquinare sinituro niahye. Sa ye cahme yahuducuye niahye. ");
INSERT INTO pirNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Tiquina ijipihtiyequina Jesure tʉhoye quehnoano masiniquirogã tiquiro ijigʉ̃ ihñañe, tiquina tʉho maria wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Tiquiro pacʉsʉmʉa gʉ̃hʉ Jesure ihñañe, ihña maria wahahye. Sa yero tiquiro pacoro tiquirore ohõ saha niahye: —‍¿Macʉ, dʉhsegʉ sa yeajari mʉhʉ ʉsãre? Mʉhʉ pacʉsʉmʉa ohõ saha ni tʉhotuu ʉsã. “Tiquiro butia wahaga”, ni macaja ʉsã mʉhʉre, niahye ticoro macʉnore. ");
INSERT INTO pirNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ticoro sa nigʉ̃ tiquiro pacʉsʉmʉare yahuahye: —‍¿Dʉhsena yʉhʉre macajari mʉsa? Yʉhʉ Pacʉ yʉhʉre tiquiro dutiriro saha yegʉ niaja. ¿Tire masiedajari mʉsa? niahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Tiquiro sa niepegʉ̃ta tiquina tʉho ñehedahye. ");
INSERT INTO pirNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Sa yero Jesu Nazarepʉ tojoaa waha, tiquiro pacʉsʉmʉare ne yʉhdʉdʉcaerahye. Ahri ijipihtiye tiquiro yerire María quehnoano wacũahye. ");
INSERT INTO pirNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Sa yero Jesu bʉcʉa, quehnoano tʉho masiniquiro wahahye. Sa ye Cohãcjʉ̃, masa gʉ̃hʉ “Quehnoariquiro ijire”, ni ihñahye tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ti pjere tiquina pʉhtoro Tiberio wame tiriquiro pʉhtoro ijiri bato quince cʉhmari wahahye. Sa yero Poncio Pilato wame tiriquiro Judea yehpa cjẽna pʉhtoro ijiahye. Sa yero Herode wame tiriquiro Galilea yehpa cjẽna pʉhtoro ijiahye. Tiquiro bahʉro Felipe Iturea yehpa cjẽna, Traconite yehpa cjẽna gʉ̃hʉ tiquina pʉhtoro ijiahye. Sa yero Lisania wame tiriquiro Abilinia yehpa cjẽna pʉhtoro ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Sa ye Anás, Caifa mehna ijipihtiyequina pahia pʉhtoa ijiahye. Ahriquina ijipihtiyequina tiquina ijiri pjere Ñu Zacaria macʉno masa marienopʉ ijiriquirore Cohãcjʉ̃ pehe tiquirore tiquiro yere yahu dutiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Sa yero Jordã wame tiri ma dʉhtʉ cahapʉ ijiri yehpapʉ ijipihtiropʉ Ñu buhero wahahye. —‍Mʉsa ñañe yeyere bʉjʉa witiya. Yojopʉre quehnoañe pehere camesaya. Sa yena wame yenohrina ijiya. Mʉsa sa camesagʉ̃ ihñano Cohãcjʉ̃ mʉsa ñañe yerire borota, ni, buhee tiahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Isaia mʉnano panopʉ cjʉ̃no Cohãcjʉ̃ yere yahu mʉhtariquiro ojoariro sahata ahriquiro yojopʉre yero niahye. Ohõ saha ni ojoahye Isaia Ñu tiquiro buheatire: Masa marienopʉ yahuducu sañuducuriquiro ohõ saha ni buherota: “Mari pʉhtoro ahtato pano mahare mari quehnoyuriro saha quehnoana ijiyuya mʉsa. Mʉsa ñañe yerire bʉjʉa witiya. ");
INSERT INTO pirNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Pe wʉhtʉri, pe buhuari gʉ̃hʉre quehnoari paa mari yeriro saha, pari yawi ijiye maharine potoye mahari mari yeriro saha, ñañe maharine quehnoañe maharine mari yeriro saha, wetere mʉsa coseriro saha mʉsa ñañe yeyere duhuya. ");
INSERT INTO pirNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Mʉsa sa yegʉ̃ Cohãcjʉ̃ mʉsare pecapʉ wahaborinare tiquiro yʉhdʉogʉ̃ ihñaeta ijipihtiri yehpa cjẽna”, ninota tiquiro sañuducu yahuriquiro pehe, ni ojoahye Isaia mʉnano panopʉre. ");
INSERT INTO pirNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Masa peyequina Ñu cahapʉ wihiye tiquiro tiquinare wame yegʉ̃ cahmeahye tiquina. Sa yero tiquiro tiquinare yahuahye: —‍Añaa pari yero saha ña yʉhdʉna, cue duhti duana ijire mʉsa. Mʉsa ñañe yerire bʉjʉa witi duerana Cohãcjʉ̃ mʉsa ñañe buhirire tiquiro buhiri dahreato pano duhti masiedare mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Sa yena potota mʉsa ñañene bʉjʉa witina ijina, quehnoañene camesana ijina, quehnoañe pehere yeya mʉsa. Ohõ saha ni tʉhotueracãhña. “Panopʉ cjʉ̃no Abrahã mari ñecʉ mʉnano ijie tiahye. Sa yena tiquiro panamena ijina mari Cohãcjʉ̃ yequina ijiaja”, ni tʉhotueracãhña mʉsa. Mʉsare niita niaja. Abrahã panamena iji turiana ijimene mʉsa. Mʉsa sa ijiepegʉ̃ta ti mʉsa sa ijiye dʉhseati ijierare. Cohãcjʉ̃ pehe ahri ʉtã paca mehna Abrahã acayere dahre masine. Sa ye Abrahã acaye mʉsa ijiye ihyo waro ijire ʉtã paca ihyo waro ti ijiro saha. ");
INSERT INTO pirNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ohõ saha ijire: Masa yucʉri yero saha ijire. Cohãcjʉ̃ pehe yucʉrire quẽatiare comeare cʉoriquiro yero saha ijire. Sa yero ñañe dʉca tiye cjʉre dʉte cohã, ti nʉhcori gʉ̃hʉre dʉte sure peho cãnota. Dʉte sure tuhasa, pecapʉ ʉjʉ̃anota tiquiro ti cjʉre, nʉhcori gʉ̃hʉre. Sata yerota masa gʉ̃hʉre tiquirore cahmeeñequinare, niahye Ñu masare. ");
INSERT INTO pirNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Tiquiro sa nigʉ̃ tʉhoye masa pehe tiquirore sinituahye: —‍¿Dʉhse yenatari ʉsã? niahye tiquina Ñure. ");
INSERT INTO pirNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","—‍Pʉa suhtiro cʉoriquiro suhti mariediquirore ihcãno ohoya. Sa yena mʉsa ihyaye cʉona apequina gʉ̃hʉre ohoya, niahye Ñu. ");
INSERT INTO pirNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Meheñequinagã pʉhtoa ye ijiatire wapa ne cohteyequina wame yenohriquina iji duahye tiquina gʉ̃hʉ. Sa yeye Ñu cahapʉ wihiye, tiquirore sinituahye: —‍¿Buhegʉ, ʉsã pehe dʉhse yenatari ʉsã? niahye tiquina tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","—‍Mʉsa pʉhtoa tiquina dutiro punota masare wapa neña. Ni meho wapa ne nemoedacãhña, ni yahuahye Ñu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Apequina surara tiquirore sinituahye tja: —‍¿Ʉsã pehe dʉhse yenatari? niahye tiquina tiquirore tja. —‍Masa yere niñerure ehmedacãhña. Sa yena tiquina ye niñerure ni meho nedacãhña. Mʉsare tiquina wapa yero punota bucueya, ni, yahuahye Ñu. ");
INSERT INTO pirNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Masa Cristore Cohãcjʉ̃ tiquiro ohoatiquirore cohteye niahye. Sa yeye ohõ saha ni tʉhotu dʉcahye tiquina Ñure. “Ahriquiro Ñu pehe Cristo ijiboaga”, ni tʉhotumahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Tiquina sa nigʉ̃ tʉhoro Ñu ijipihtiyequinare yahuahye: —‍Yʉhʉ bato yʉhʉ yʉhdʉoro tutuariquiro ahtarota. Quehnoa yʉhdʉariquiro ijire tiquiro. Tiquiro yero saha ijieraja yʉhʉ pehe. Sa yegʉ tiquirore tʉhotugʉ, “Ihyo ijigʉ ijiaja”, ni tʉhotuaja yʉhʉ. Yʉhʉ pehe mʉsare wame yegʉ aco mehna wame yemi. Tiquiro pehe yʉhʉ yʉhdʉoro yerota. Espíritu Santore masa mehna ijiducugʉ̃ yerota. Sa yero pecapʉ ñañene tiquiro ʉjʉ̃a wero saha tiquiro ahtariquiro pehe mʉsa ñano yeyere cose werota. ");
INSERT INTO pirNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Yʉhʉ bato ahtariquiro trigo cahseri cohãriquiro yero saha ijire. Ti cahserire cohãriquiro tiquiro batiro mehna ijipihtiye trigo pjeri cahserire puti were. Sa ye tuhasa trigo pehere tiquiro ihbori wʉhʉpʉ cũnota. Sata yerota tiquina ñañene bʉjʉa witiyequinare yʉhʉ bato ahtariquiro. Tiquiro puti weri cahseri pehere ʉjʉ̃anota. Ti peca tiquiro ʉjʉ̃ari peca ne yatisi. Sata yerota tiquiro yʉhʉ bato ahtariquiro tiquina ñañene bʉjʉa witieyequinare, ni yahuahye Ñu. ");
INSERT INTO pirNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Peye tiquiro sa ni yahuye mehna masare quehnoañe buheyere yahuahye Ñu. ");
INSERT INTO pirNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Sa yero pʉhtoro Herode pehe tiquiro bahʉro Felipe namonore tiquiro namo tiri buhiri, pajiro ñañene tiquiro yeri buhiri gʉ̃hʉre Ñu tiquirore yahumahye. ");
INSERT INTO pirNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Tiquiro sa ni yahuri buhiri Herode pehe Ñure peresu yeahye, pari turi ñañene yero. ");
INSERT INTO pirNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ñure tiquina peresu yeato pano apequina masare Ñu pehe wame yero niahye. Tiquinare wame yero Jesu gʉ̃hʉre wame yeahye. Sa yero Jesu diapʉ ducuriquiro Cohãcjʉ̃re tiquiro sinino watoa ʉhmʉse parĩ maa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Sa parĩ maari bato Espíritu Santo bujua yero saha bajuriquiro Jesu buipʉ dijia tahye. Tiquiro ahtagʉ̃ ʉhmʉsepʉ yahuducuro ca tahye: —‍Mʉhʉ yʉhʉ macʉ yʉhʉ cahĩgʉ ijire. Mʉhʉ mehna tutuaro bucueaja, nino ca tahye ʉhmʉsepʉ. ");
INSERT INTO pirNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesu buhe dʉcari cʉhmare treinta cʉhmari cʉoahye tiquiro. “Tiquiro José macʉno ijire”, ni, tʉhotumahye masa. José pehe Elí macʉno ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí Matat macʉno ijiahye. Matat Leví macʉno ijiahye. Leví Melqui macʉno ijiahye. Melqui Jana macʉno ijiahye. Jana José macʉno ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José Matatía macʉno ijiahye. Matatía Amós macʉno ijiahye. Amós Nahúm macʉno ijiahye. Nahúm Esli macʉno ijiahye. Esli Nagai macʉno ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai Maat macʉno ijiahye. Maat Matatía macʉno ijiahye. Matatía Semei macʉno ijiahye. Semei Josec macʉno ijiahye. Josec Judá macʉno ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá Joanán macʉno ijiahye. Joanán Resa macʉno ijiahye. Resa Zorobabel macʉno ijiahye. Zorobabel Salatiel macʉno ijiahye. Salatiel Neri macʉno ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri Melqui macʉno ijiahye. Melqui Adi macʉno ijiahye. Adi Cosam macʉno ijiahye. Cosam Elmadam macʉno ijiahye. Elmadam Er macʉno ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er Josué macʉno ijiahye. Josué Eliezer macʉno ijiahye. Eliezer Jorim macʉno ijiahye. Jorim Matat macʉno ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat Leví macʉno ijiahye. Leví Simeo macʉno ijiahye. Simeo Judá macʉno ijiahye. Judá José macʉno ijiahye. José Jonam macʉno ijiahye. Jonam Eliaquim macʉno ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim Melea macʉno ijiahye. Melea Mena macʉno ijiahye. Mena Matata macʉno ijiahye. Matata Natán macʉno ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán Davi macʉno ijiahye. Davi Isaí macʉno ijiahye. Isaí Obed macʉno ijiahye. Obed Booz macʉno ijiahye. Booz Salmón macʉno ijiahye. Salmón Naasón macʉno ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón Aminadab macʉno ijiahye. Aminadab Admin macʉno ijiahye. Admin Arni macʉno ijiahye. Arni Esrom macʉno ijiahye. Esrom Fare macʉno ijiahye. Fare Judá macʉno ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá Jacob macʉno ijiahye. Jacob Isaac macʉno ijiahye. Isaac Abrahã macʉno ijiahye. Abrahã Taré macʉno ijiahye. Taré Nacor macʉno ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor Serug macʉno ijiahye. Serug Ragau macʉno ijiahye. Ragau Peleg macʉno ijiahye. Peleg Heber macʉno ijiahye. Heber Sala macʉno ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala Cainán macʉno ijiahye. Cainán Arfaxad macʉno ijiahye. Arfaxad Sem macʉno ijiahye. Sem Noé macʉno ijiahye. Noé Lamec macʉno ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec Matusalẽ macʉno ijiahye. Matusalẽ Enoco macʉno ijiahye. Enoco Jared macʉno ijiahye. Jared Mahalaleel macʉno ijiahye. Mahalaleel Cainán macʉno ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán Eno macʉno ijiahye. Eno Sete macʉno ijiahye. Sete Adán macʉno ijiahye. Adán Cohãcjʉ̃ yeriquiro ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesu Espíritu Santo dutiriro saha ye pehoriquiro ijiro, Jordã wame tiri ma cahapʉ ijiriquiro tojoaa wahahye. Tiquiro sa tojoaa wahagʉ̃ Espíritu Santo pehe tiquirore masa marienopʉ neahye. ");
INSERT INTO pirNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Topʉ esaro cuarenta decori ijiahye. Sa yero watĩno pehe Jesure ñañene yegʉ̃ cahmemahye. Sa yero ñañene ye dutimahye tiquirore. Ti decorire ne Jesu ihyerahye. Sa yero ti decori pihtigʉ̃ waro tiquiro ʉjʉa ahbahye. ");
INSERT INTO pirNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Tiquiro sa ʉjʉa ahbagʉ̃ ihñano watĩno ohõ saha nimahye Jesure: —‍Mʉhʉ Cohãcjʉ̃ macʉ ijigʉ, ahria ʉtãre ihyaye dojomehneña, nimahye Jesure. ");
INSERT INTO pirNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesu ohõ saha ni yʉhtiahye: —‍Yeraja. Cohãcjʉ̃ yere tiquina ojoari pũpʉ ohõ saha nine: “Masare ihyaye mehna dihita catieraro cahmene. Ijipihtiye Cohãcjʉ̃ ye yahuye mehna ijiro cahmene”, nine Cohãcjʉ̃, ni yʉhtiahye Jesu watĩnore. ");
INSERT INTO pirNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Tiquiro sa nidi bato watĩno pehe tiquirore cʉnʉ ʉhmʉanʉ buipʉ ne mʉja saro, duita ijipihtiye macarine ihño dijioahye Jesure. ");
INSERT INTO pirNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Sa ihñono Jesure yahuahye: —‍Ijipihtiye ahri macari yʉhʉre tiquiro ohori ijire. Sa yegʉ yʉhʉ cahmediquirore oho masiaja. Sa yegʉ ahri macarine, ahri macari cjẽnare dutiati gʉ̃hʉre, tiquina cʉoye mehna mʉhʉre ohoutja. ");
INSERT INTO pirNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Yʉhʉre mʉhʉ ño peogʉ̃ ahri macari ijipihtiye macarine mʉhʉre ohoutja, niahye watĩno Jesure. ");
INSERT INTO pirNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesu ohõ saha ni yʉhtiahye tiquirore: —‍Mʉhʉre ño peoeraja. Ohõ saha nine Cohãcjʉ̃ yere tiquina ojoari pũ: “Mʉhʉ pʉhtoro Cohãcjʉ̃ dihitare ño peoya. Tiquiro ye dutiye dihitare yeya”, ni ojoahye Cohãcjʉ̃ yere, niahye Jesu watĩnore. ");
INSERT INTO pirNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","Tiquiro sa nidi bato Jerusalẽpʉ watĩno pehe tiquirore ne cã, Cohãcjʉ̃ wʉhʉ buipʉ ne sahye. Ne sa tuhasa tiquirore ohõ saha nimahye: —‍Cohãcjʉ̃ yere tiquina ojoari pũ ohõ saha nine: “Cohãcjʉ̃ tiquiro yequina angelere mʉhʉre ihña ihbo dutirota. Sa yeye tiquina pehe mʉhʉre ihña ihboeta, ‘Mʉhʉpʉ ʉtãpʉ pʉhari’, niñe”, ni ojoahye Cohãcjʉ̃ yere tiquina ojoari pũpʉ. Tiquiro sa nidi poto ijigʉ̃ mʉhʉ Cohãcjʉ̃ macʉ ijigʉ, yehpapʉ uhpu dijia ihñoña yʉhʉre. Mʉhʉre tiquina yedohogʉ̃ ihñoña yʉhʉre, nimahye watĩno Jesure. ");
INSERT INTO pirNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesu uhpu dijia ihño dueraro ohõ saha ni yʉhtiahye tiquirore: —‍Cohãcjʉ̃ yere tiquina ojoari pũ ohõ saha nine: “Mʉsa pʉhtoro Cohãcjʉ̃ tiquiro nidire ‘¿Poto ijiajari?’ ni masi duana, Cohãcjʉ̃re ye ihño duti tuhueracãhña”, nine Cohãcjʉ̃ yere tiquina ojoari pũpʉ, niahye Jesu watĩnore. ");
INSERT INTO pirNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Sa yero watĩno ijipihtiye ñañene Jesure ye dutimahye. Sa duti tuhasaro mehenogã duhu cãrĩahye. ");
INSERT INTO pirNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Came Jesu Galileapʉ tojoaa wahahye. Sa yero tiquiro Espíritu Santo tutuaye mehna yeahye. Topʉ ijipihtiropʉ masa tiquirore quiti tiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Judio masa buheye wʉhʉsepʉ Jesu gʉ̃hʉ buhee tiahye. Sa ye ijipihtiyequina masa tiquirore quehnoano yahuducuahye. ");
INSERT INTO pirNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","17","Came Nazarepʉ Jesu tiquiro masariropʉta esahye. Topʉ esa, saurú ijigʉ̃ tiquiro sa yeducuriro saha judio masa tiquina buheri wʉhʉpʉ sajã sahye. Topʉ tiquiro Cohãcjʉ̃ yere tiquina ojoari pũre buhero taro topʉ ducuahye. Tiquiro sa ducugʉ̃ ihñañe to cjẽna pehe Cohãcjʉ̃ yere yahu mʉhtariquiro Isaia mʉnano tiquiro ojoari pũre tiquirore ohoahye. Ti pũpʉ Jesu ahri yahuyere bocaro buheahye: ");
INSERT INTO pirNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Cohãcjʉ̃ yaquiro Espíritu yʉhʉ mehna ijiro, yʉhʉre dutiri. Tiquiro pejecʉoyequinare quehnoañe buheyere yahu dutiro ohori yʉhʉre. Sa yero peresupʉ ijiyequina gʉ̃hʉre tiquinare tiquiro yʉhdʉoatire yahu dutiro ohori yʉhʉre. Caperi bajueyequina tiquina quehnoano ihñatire ohori yʉhʉre. Sa yero masa ñano tiquina yenohriquinare wioacjʉre yʉhʉre ohori. ");
INSERT INTO pirNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Mari pʉhtoro Cohãcjʉ̃ tiquiro yequinare pecapʉ wahaboriquinare tiquiro yʉhdʉoatire yʉhʉre yahu dutiro ohori, ni buheahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Sa ni buhe tuhasa Jesu ti pũre quehnoari tunu torẽ, wʉhʉ cjʉ̃nore wia tuhasa, nuju sahye. Tiquiro nuju sagʉ̃ ihñañe topʉ ijiyequina ijipihtiyequina tiquiro dihitare ihñahye. ");
INSERT INTO pirNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Tiquina sa yegʉ̃ tiquiro tiquinare yahu dʉcahye: —‍Ahri mianogãta yʉhʉ buhero saha Cohãcjʉ̃ tiquiro nidiro sahata waharo nine, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Tiquiro sa nigʉ̃ tʉhoye “Ahriquiro quehnoariquiro ijire”, ni tʉhotuahye tiquina. Sa yeye tiquina tiquiro quehnoano yahuducugʉ̃ tʉhoye, tʉho maria wahahye. Sa yeye ohõ saha niahye tiquina basi: —‍¿Yohnah, José macʉno ijierajari ahriquiro? niahye tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Tiquina sa nigʉ̃ masino Jesu yahuahye tiquinare: —‍Yʉhʉ buheyere tʉho duerana, ohõ saha ni tʉhoture mʉsa yʉhʉre: “Duturu dohatiro tiquiro basi aco ti masine duturu waro tiquiro ijiyere ihñono. Mʉhʉ gʉ̃hʉ duturu tiquiro ye ihñono saha mʉhʉ nidiro saha ijigʉ Cohãcjʉ̃ tutuaye mehna ye ihñoña ʉsãre. Capernaupʉre Cohãcjʉ̃ tutuaye mehna ye ihñoñohti mʉhʉ. Ʉsã gʉ̃hʉre sa ye ihñoña, mʉhʉ buheyere ‘Poto tjire’, ʉsã niato saha”, ni duare mʉsa yʉhʉre. ");
INSERT INTO pirNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ahrire yahutja mʉsare. Cohãcjʉ̃ yere yahu mʉhtariquirore tiquiro ya maca cjẽna ño peoerare. Sa yena yʉhʉre ño peoerare mʉsa ohõpʉ yʉhʉ masarigʉ ijigʉ̃. ");
INSERT INTO pirNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Sata ijiahye panopʉre. Panopʉ Elia tiquiro ijiri pjere ihtia cʉhma ape cʉhma deco waro ne acoro ahtaerahye. Sa yero ijipihtiropʉta ne ihyaye mariedahye. ");
INSERT INTO pirNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ti pjere peyequina wape wiha numia Israe yehpapʉ tiquina ijiepegʉ̃ta Cohãcjʉ̃ Elia mʉnanore tiquinare yedoho dutiro ohoerahye. Tiquiro ya macare sa ye dutieraperota ape yehpapʉ Sidõ cahapʉ ijiri macapʉ Sarepta wame tiri maca cjõno wape wihorore yedoho dutiro Elia mʉnanore ohoahye Cohãcjʉ̃. ");
INSERT INTO pirNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Came Cohãcjʉ̃ yere yahu mʉhtariquiro Eliseo mʉnano tiquiro ijiri pjere Israe yehpapʉ peyequina cami bʉcʉ mʉna wiha tiquina ijiepegʉ̃ta ihcãquiro Israe masʉnore ne quehnoa wahagʉ̃ yerahye Eliseo mʉnano. Tiquiro ya yehpa cjẽnare yeraperota Naamán wame tiriquiro Siria yehpa cjʉ̃no dihitare quehnoa wahagʉ̃ yeahye tiquiro. Sa yero Israe masare yedohoeraro, Israe masa ijieyequina pehere yedohoahye Cohãcjʉ̃, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Tiquiro sa nigʉ̃ tʉhoye ijipihtiyequina ti wʉhʉpʉ ijiyequina usua yʉhdʉa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Sa yeye tiquina wahcãdʉca, Jesure ne wijia, ti maca dʉhtʉ cahapʉ ijiri cʉnʉpʉ tiquirore tudoque dijio duamahye. ");
INSERT INTO pirNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Tiquina sa ye duepegʉ̃ta Jesu tiquina watoata wahaa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Came Jesu Galilea yehpapʉ ijiri macapʉ Capernau wame tiri macapʉ esa, saurú ijigʉ̃ masare buheahye. ");
INSERT INTO pirNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Quehnoano masi pehoriquiro tiquiro buhegʉ̃ tʉhoye masa tʉho maria wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ti wʉhʉpʉ watĩnore cʉoriquiro ijiahye. Tutuaro sañuducuahye: ");
INSERT INTO pirNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—‍Mʉhʉ Jesu Nazare cjʉ̃ ʉsãre cariboeracãhña mʉhʉ. ¿Dʉhse yegʉ tagʉ niajari ʉsãre? ¿Mʉhʉ ʉsãre butigʉ̃ yegʉ tagʉ niajari? Cohãcjʉ̃ macʉ, quehnoagʉ mʉhʉ ijigʉ̃ yʉhʉ masiaja, ni sañuducuahye Jesure. ");
INSERT INTO pirNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Tiquiro sa nigʉ̃ tʉhoro Jesu tuhtiahye watĩnore: —‍Dihta mariahña. Duhuya tiquirore, niahye Jesu. Tiquiro sa nidi bato masʉnore watĩno pehe yehpapʉ doque quehe sa tunugʉ̃ yeahye. Tiquiro sa yeri bato tiquiro pehe quehnoa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Topʉ ijiyequina ijipihtiyequina tiquiro sa wahagʉ̃ ihñañe, ihña maria wahahye. Sa ye tiquina basi ohõ saha ni yahuducuahye: —‍¿Yabe boro buheye ijiajari ahri sa wahagʉ̃ yeye? Yohnah. Tutuaro mehna pʉhtoro yero saha ahriquiro watĩare dutire. Sa yeye tiquiro dutiro sahata tiquina masare duhure, ni yahuducuahye tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Tiquiro sa yegʉ̃ ihñañe ti yehpapʉ ijipihtiropʉ masa Jesure quiti dahreahye. ");
INSERT INTO pirNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Judio masa tiquina buheri wʉhʉre wijia, Simo ya wʉhʉpʉ sajã sahye Jesu. Topʉ Simo mareono dohatiro niahye. Tutuaro ujuaye tiahye. Sa ye tiquina ticoro dohatigʉ̃ yahuahye Jesure. ");
INSERT INTO pirNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Tiquina yahuri bato tiquiro ticoro cahapʉ esa, ujuayere suru dutiahye. Tiquiro sa suru dutiri bato ticorore ujuaye surua waha, duita quehnoa wahahye. Ticoro sa waharo wahcã nuju sa, ticorota tiquinare ihyayere peoahye. ");
INSERT INTO pirNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Asʉ̃ sajãri bato ijipihtiyequina masa tiquiro cahapʉ ijiyequina dohatiyequinare Jesu cahapʉ ne sahye. Dohatiyequina peyequina sijoro saha ijiye dohatiyere cʉoahye. Sa yero Jesu tiquiro omocari mehna tiquina bui ña peo, ijipihtiyequinare tiquina dohatiyere quehnoano yʉhdʉoahye. ");
INSERT INTO pirNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Watĩa gʉ̃hʉre Jesu duhu dutigʉ̃ tiquina duhuye sañuducuahye: —‍Mʉhʉ potota Cohãcjʉ̃ macʉ ijire, niahye tiquina Jesure. Jesu Cohãcjʉ̃ ohoriquiro tiquiro Cristo ijigʉ̃ watĩa masiahye. Sa yero Jesu tiquinare yahuducu dutierahye, “ ‘Cristo ijire’, ni yahu siteari”, nino. ");
INSERT INTO pirNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Bohrea mʉja tagʉ̃ Jesu ti macapʉ ijiriquiro waha, masa marienopʉ esahye. Tiquiro sa esari bato masa tiquirore maca cã, boca saye, ohõ saha niahye: —‍Ʉsã ya macapʉ tojoaya ʉsã mehna. Ape sie wahaegʉta, nimahye tiquina Jesure. ");
INSERT INTO pirNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Tiquina sa niepegʉ̃ta tiquiro pehe ohõ saha ni yʉhtiahye: —‍Cohãcjʉ̃ tiquiro pʉhtoro ijiyere quehnoañe buheyere apeye macaripʉ gʉ̃hʉre buhe duaja yʉhʉ. Cohãcjʉ̃ yʉhʉre ohori tire yahuacjʉre, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Sa yero Judea yehpapʉ ijiye wʉhʉsepʉ, judio masa tiquina buheye wʉhʉsepʉ tiquiro buhe tiniahye. ");
INSERT INTO pirNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ape deco Jesu Genesare wame tiri ditara dʉhtʉ cahapʉ esahye. Topʉ tiquiro ijigʉ̃ ihñañe peyequina masa Cohãcjʉ̃ yere tʉho duaye tiquirore nʉnʉ tã sahye. Quehnoano wahpa dʉca saa wahahye masa pari. ");
INSERT INTO pirNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Pʉa yucʉsa padʉropʉ pahsaye yucʉsarire Jesu ihñahye. Ti yucʉsari cjẽna yohyeyequina maja sadʉca, tiquina wẽñecjʉre coseye niahye. ");
INSERT INTO pirNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Sa yero Jesu Simo yariapʉ sajãhye. Sajã tuhasa tia yucʉsare dia dʉhtʉ cahapʉ cuñariare weje buho dutiahye. Sa yero yucʉsapʉ duji, masare buheahye. ");
INSERT INTO pirNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Buhe tuhasa, Jesu Simore ohõ saha niahye: —‍Deco cjũnogã tu wioya. Sa yena mʉhʉ mehna cjẽna mehna mʉsa wẽñecjʉre doque ñoña wahi ñeheanaja, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Tiquiro sa nigʉ̃ tʉhoro Simo Jesure yʉhtiahye: —‍Pʉhto, wahi wejẽ bohreami ʉsã mia ñamine. Bohreepenata ne ihcãquirogã wejẽdahti ʉsã. Sa wejẽdapenata mʉhʉ dutiro saha doque ño tuhunata, ni yʉhtiahye Simo. ");
INSERT INTO pirNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Sa ni tuhasa tiquina doque ñoahye. Sa tiquina doque ñogʉ̃ tiquina wẽñecjʉre peyequina wahi sajãhye. Peyequina tiquina sajãgʉ̃ wẽñecjʉ tʉhnʉa wahamahye. ");
INSERT INTO pirNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Sa wahagʉ̃ ihñañe aperia cjẽnare tiquina mehna cjẽnare pijioahye. —‍Mʉsa gʉ̃hʉ yedohona ahtaya ʉsãre, ni pijioahye Simo gʉ̃hʉ. Tiquina sa yedohori bato pʉaria yucʉsa quehnoano miniparo bocahye wahire. ");
INSERT INTO pirNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simo Pedro sa wahi peyequina tiquina sajãgʉ̃ ihñano, Jesu cahapʉ dʉsepe curi mehna quehe sa, tiquirore niahye: —‍Yʉhʉ pʉhto, mʉhʉ mehna ijibogʉ ijieraja yʉhʉ. Ñagʉ ijiaja yʉhʉ. Sa yegʉ yʉhʉre duhuya, niahye Simo Jesure. ");
INSERT INTO pirNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Tiquiro, ijipihtiyequina tiquiro mehna cjẽna gʉ̃hʉ peyequina wahi sajãgʉ̃ ihñañe, ihña maria wahahye tiquina gʉ̃hʉ. ");
INSERT INTO pirNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Pʉaro Simo mehna cjẽna Zebedeo pohne Santiago, tiquiro bahʉro Ñu mehna, tiquina gʉ̃hʉ ihña maria wahahye. Tiquina sa ihña mariagʉ̃ ihñano Jesu Pedrore yahuahye: —‍Ihña mariedacãhña. Yojopʉre mʉhʉ wahire ñehe cahmecoagʉ mʉhʉ ijiro saha Cohãcjʉ̃ yequina ijiatiquinare piji cahmecoagʉ ijigʉta mʉhʉ, niahye Jesu Simore. ");
INSERT INTO pirNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Tiquiro sa nidi bato tiquina yucʉsarire ditara dʉhtʉ cahapʉ weje mo cũ cã, tiquina ye ijipihtiyere topʉta cũ cã, Jesu mehna wahaa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jesu ape macapʉ tiquiro ijigʉ̃ cami bʉcʉ mʉna wihiro tiquirore piti cahye. Sa piti caro tiquiro Jesure ihña, dʉsepe curi mehna quehe sa, tutuaro siniahye: —‍Pʉhto, mʉhʉ yʉhʉre yʉhdʉo duagʉ yʉhdʉoya, ni siniahye. ");
INSERT INTO pirNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Tiquiro sa nidi bato Jesu tiquirore ña peoro ohõ saha niahye: —‍Tire ye duaja. Yojopʉ quehnoagʉ ijiya mʉhʉ, niahye. Tiquiro sa nigʉ̃ta tiquiro cami ahbari yatia wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Sa yero Jesu tiquirore dutiahye: —‍Ahri yʉhʉ ohõ saha yerire apequinare yahueracãhña. Pahi cahapʉ wahaya yojopʉre. Sa yegʉ mʉhʉ pagʉre quehnoari pagʉ waharire ihñoña tiquirore. Cohãcjʉ̃ dutiye Moisere tiquiro cũri nidiro saha yeya. Sa yegʉ pahire pʉaro minicjʉare ohoya mʉhʉ cami yʉhdʉrire ijipihtiyequinare ihñogʉ tʉhʉ, niahye cami bʉcʉ mʉna cʉomediquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","“Yahueracãhña”, tiquiro sa niepegʉ̃ta ijipihtiropʉ masa Jesure quiti dahre nemoahye. Tiquina sa quiti dahregʉ̃ tʉhoye masa peyequina tiquiro cahapʉ esahye. Dohatiyequina yʉhdʉ duaye, tiquina gʉ̃hʉ tiquiro cahapʉ esahye. ");
INSERT INTO pirNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Tiquina sa esaepegʉ̃ta Jesu masa marienopʉ Cohãcjʉ̃re sinino wahaa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ape deco Jesu buhegʉ̃ fariseo masa, judio masare buheyequina gʉ̃hʉ topʉ dujiahye. Tiquina peye macari Galileapʉ ijiye macari cjẽna, Judeapʉ ijiye macari cjẽna, Jerusalẽ cjẽna ijiahye. Sa yero Jesu Cohãcjʉ̃ tutuaye mehna dohatiyequinare yʉhdʉoahye. ");
INSERT INTO pirNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Meheñequinagã ʉmʉa tini masieniquirore tiquiro cuñari cahsero mehna yo wʉa wihiahye. Sa yeye tiquirore Jesu cahapʉ cũ duaye, wʉhʉpʉ yo sajã duamahye tiquina tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Sa sajã duepeta masa peyequina ijigʉ̃ tiquina tiquirore yo sajã masiedahye. Sa yeye tiquirore wʉhʉ buipʉ yo mʉjahye. Yo mʉja sa, mehenogã põo we, ti copepʉ tini masieniquirore tiquiro cuñari cahsero mehna duhu dijioahye Jesu cahapʉ ijiyequina watoa. ");
INSERT INTO pirNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","“Jesu ahriquirore tiquiro dohatiyere yʉhdʉgʉ̃ yerota”, ni tʉhotuahye tiquina. Tiquina sa ni tʉhotugʉ̃ masino Cohãcjʉ̃re tiquina wacũ tutuayere masino, Jesu tini masieniquirore ohõ saha ni yahuahye: —‍Yʉhʉ acayʉ, mʉhʉ ñañe yeyere yʉhʉ cohã tuhasaʉ, niahye Jesu tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Tiquiro sa nigʉ̃ tʉhoye fariseo masa, judio masare buheyequina gʉ̃hʉ tiquina basi ohõ saha ni tʉhotumahye: “Ahriquiro sa ni yahuducueracãhdo. Masʉno mari yero saha ijiro, tiquiro ñañe yeyere cohã masiedare. Cohãcjʉ̃ dihita masa tiquina ñañe yeyere cohã masine”, ni, tʉhotumahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesu tiquina tʉhotuyere masino, ohõ saha niahye: —‍¿Dʉhse yena sa ni tʉhotuajari mʉsa? ");
INSERT INTO pirNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","“Mʉhʉ ñañe yeyere yʉhʉ cohã tuhasaja”, yʉhʉ nigʉ̃, “Ni mehogʉ ijire”, yʉhʉre nine mʉsa quehnoano masiedapenata. “Wahcãdʉca wahaya”, yʉhʉ nigʉ̃ tiquiro tinigʉ̃ ihñana yʉhʉ nidi poto ijigʉ̃ duita masinata. ");
INSERT INTO pirNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ ahri yehpapʉ ñañe yeyere cohã masiaja yʉhʉ. Masa tiquina ñañe yeyere cohãcjʉre cũri Cohãcjʉ̃ yʉhʉre. Yʉhʉ sa cohãrire mʉsa masiato saha ohõ saha ye ihñoutja mʉsa ihñatire, niahye Jesu. Sa ni tuhasa tini masieniquirore ohõ saha niahye: —‍Mʉhʉre niita niaja. Wahcãdʉcaya. Mʉhʉ cuñari cahserore ne cãhña mʉhʉ ya wʉhʉpʉ, niahye tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Tiquiro sa nigʉ̃ tʉhorota ijipihtiyequina tiquina ihñonopʉ wahcãdʉca, tiquiro cuñari cahserore ne, tiquiro ya wʉhʉpʉ tojoa wahahye. Sa waharo tiquiro Cohãcjʉ̃re ño peoro, bucueye mehna quehnoano yahuducuahye. ");
INSERT INTO pirNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Tiquiro sa yegʉ̃ ihñañe masa pehe ijipihtiyequina ihña maria wahahye. Tiquina ihña maria waha, Cohãcjʉ̃re ño peoye, bucueye mehna quehnoano yahuducuahye: —‍Miare sijoro saha ijiyere ihñaʉ mari, niahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Sa ye tuhasa waha, Leví wame tiriquirore tiquiro dahrari tucũpʉ ijiriquirore boca sahye Jesu. Leví pehe pʉhtoa ye ijiatire masare wapa ne cohteriquiro ijiahye. Sa boca saro tiquirore ohõ saha niahye: —‍Yʉhʉ mehna cjʉ̃ ijiacjʉ ahtaya, niahye tiquiro Levíre. ");
INSERT INTO pirNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Tiquiro sa nigʉ̃ Leví pehe ijipihtiye tiquiro dahrayere duhu cã, Jesu mehna wahaa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Came Leví ya wʉhʉpʉ Jesu ya bose deco yeye niahye. Topʉ peyequina wapa ne cohteyequina, apequina Leví gʉ̃hʉ mehna dujiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Tiquina mehna Jesu gʉ̃hʉ dujigʉ̃ ihñañe meheñequinagã fariseo masa, judio masare buheyequina mehna usua, Jesu buheyequinare sinituahye. —‍¿Dʉhsena ñano yeyequina, wapa ne cohteyequina mehna ihyajari mʉsa? ni tuhtiahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Tiquina sa nigʉ̃ tʉhoro Jesu yʉhtiahye tiquinare. Ohõ saha ni queoye mehna buheahye: —‍Dohatieyequina duturure macaedare. Dohatiyequina dihita duturure macare. Ñañequina dohatiyequina yero saha ijire. ");
INSERT INTO pirNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Sa yegʉ ñañequina dihitare tiquina ñañene bʉjʉa witi dutigʉ, quehnoañe pehere camesagʉ̃ yegʉ tʉʉ nii yʉhʉ. Tiquina basi “Quehnoana ijiaja ʉsã”, ni tʉhotuyequinare yedohogʉ ahtaerʉ yʉhʉ, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Sa yeye meheñequinagã masa Jesure ohõ saha ni sinituahye: —‍Ñu buheyequina peye tahari Cohãcjʉ̃re ño peoye tehe, sijire. Sa yeye, tiquina peye tahari Cohãcjʉ̃re sinine. Fariseo buheyequina gʉ̃hʉ tiquina yero saha yere. Tiquina sa yepegʉ̃ta mʉhʉ buheyequina pehe ihya, sihnine. Sa ye Cohãcjʉ̃re ño peoye tehe, sijierare. ¿Dʉhse yeye sa yerajari tiquina? niahye tiquina Jesure. ");
INSERT INTO pirNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Tiquina sa nigʉ̃ Jesu tiquiro tʉhotuye mehna quiti dahre buhero taro tiquinare ohõ saha ni yʉhtiahye: —‍Ohõ saha ijire ti: Omoca dʉhteropʉ tiquina pijioriquina omoca dʉhteriquiro mehna ijiye, siji masiedare. Sata yʉhʉ buheyequina gʉ̃hʉ yʉhʉ mehna ijiye, siji masiedare. Yʉhʉ omoca dʉhteriquiro yero saha ijiaja. Omoca dʉhteriquiro bose deco tiquiro yegʉ̃ tiquiro mehna cjẽna ihyeyequina ijierare. ");
INSERT INTO pirNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Yʉhʉ Pacʉ Cohãcjʉ̃ yʉhʉre tiquiro nedi bato pũritare yʉhʉ buheyequina mehna ijisi yʉhʉ. Sa yeye ti pjepʉta yʉhʉ buheyequina gʉ̃hʉ sijieta, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Panopʉ cjẽ buheye wahma buheye mehna tiquina buhe more duagʉ̃ ihñano ohõ saha ni nemoahye Jesu tiquinare queoye mehna buhero. —‍Ne wahma suhtirore meheni cahserogã tʉhrẽ ne, mʉna suhtirore sere ohõno cahmedare. Mari sa sere ohõna wahma cahserore tʉhrẽ cohãna niaja. Sa yero wahma cahsero mʉna suhtiro mehna ihcãno saha bajuerare. ");
INSERT INTO pirNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Sa yena ne ʉhse co bisiye core wahiquiro cahsero ajuropʉre mʉna ajuropʉre pose yero cahmedare. Sa yegʉ̃ ʉhse co bisiye pahmuñepʉ mʉna ajurore tʉhrẽ cãhre. Sa tʉhnʉgʉ̃ ʉhse co gʉ̃hʉ, ajuro gʉ̃hʉ cohãa wahare. ");
INSERT INTO pirNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Sa yena ʉhse co wahma core wahma ajuropʉ pose yero cahmene. (Sata wahma buheye mʉna buheye mehna buhe moredaro cahmene.) ");
INSERT INTO pirNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Mʉna core masa tiquina sihnidi bato, wahma core cahmedare tiquina. Ohõ saha nine masa. “Mʉna co wahma co bui cjũnogã quehnoañe ijire”, nine masa, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ape deco saurú ijigʉ̃ Jesu gʉ̃hʉ trigo wesepʉ esahye. Topʉ esa, tiquiro buheyequina pehe trigo parorire pehe, ti pjerire sahquẽ site dijio, ti pjerire ihya cã wahaa wahahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Tiquina sa yegʉ̃ ihñañe meheñequinagã fariseo masa tiquinare sinituahye: —‍¿Dʉhse yena mʉsa saurú mari sori deco ijiepegʉ̃ta Cohãcjʉ̃ tiquiro dutierari decore dahrajari mʉsa? niahye fariseo masa. Tiquina sa nigʉ̃ tʉhoro Jesu tiquinare yʉhtiahye “Yʉhʉ buheyequina yʉhdʉdʉcaye niedare”, nino taro: ");
INSERT INTO pirNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","—‍Davi mʉnano tiquiro mehna cjẽna mehna ʉjʉa ahbaro, Cohãcjʉ̃ wʉhʉpʉ sajã, Cohãcjʉ̃ ye pãre ihyahye. Sa ihyaro tiquiro mehna cjẽna gʉ̃hʉre ti pãre ihya dutiro ohoahye. Ti pãre pahia dihita ihyae tiahye. Cohãcjʉ̃ dutiye ti pãre apequinare ihya dutierare. ¿Davi mʉnano tire tiquiro yerire buherari mʉsa? (Ti pãre ihyaro Cohãcjʉ̃re yʉhdʉdʉcaro niedahye. Miare ahri pjerire ihyaye yʉhʉ buheyequina gʉ̃hʉ Cohãcjʉ̃re yʉhdʉdʉcaye niedare.) ");
INSERT INTO pirNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ ahri deco saurú decore masa tiquina yeatire yahugʉ ijigʉ pʉhto ijiaja, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ape deco saurú ijigʉ̃ Jesu judio masa tiquina buheri wʉhʉpʉ sajã saro, buheahye masare. Topʉ omoca poto pehe bʉhariquiro ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Meheñequinagã judio masare buheyequina, fariseo masa gʉ̃hʉ Jesure yahusã duamahye. “Saurú decore masʉnore dohatiyere yʉhdʉoboaga Jesu”, ni, ihña nʉnʉ yahusã duamahye tiquina Jesure. ");
INSERT INTO pirNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jesu tiquina tʉhotuyere masino, omoca bʉhariquirore ohõ saha niahye: —‍Wahcãdʉcaya. Ohõpʉ ahtaya, niahye tiquiro. Tiquiro sa nidi bato omoca bʉhariquiro pehe wahcãdʉca, topʉ ducuahye. ");
INSERT INTO pirNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Sa yero Jesu tiquinare sinituahye. —‍Mʉsare sinitutja: ¿Saurú ijigʉ̃ yabere ye dutiajari Cohãcjʉ̃ dutiye? ¿Quehnoañene yegʉ̃ quehnoaedajari? ¿Ñañene yegʉ̃ pehere quehnoaboagari, mʉsa tʉhotugʉ̃? Saurú ijigʉ̃ masʉnore masogʉ̃ quehnoarĩne. Saurú ijigʉ̃ masʉnore wejẽgʉ̃ pehere quehnoaedare. Ñarĩne, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Sa nino Jesu tiquinare ijipihtiyequinare ihñadoqueo, omoca bʉhariquirore ohõ saha niahye tja: —‍Mʉhʉ omocare siõ potoya, niahye tiquiro. Tiquiro sa nigʉ̃ta omoca bʉhariquiro pehe siõ potogʉ̃ta, omoca quehnoa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Tiquiro sa yegʉ̃ ihñañe tiquina tiquiro mehna tutuaro usuahye. —‍¿Dʉhse yenatari mari ahriquirore? niahye tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ti decorire Jesu cʉnʉpʉ Cohãcjʉ̃re sinino mʉjaa wahahye. Topʉ ijiro, ñamine Cohãcjʉ̃ mehna yahuducu bohreahye. ");
INSERT INTO pirNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Bohrearopʉ tiquiro buheyequinare tiquiro cahapʉ pijioahye. Pijio tuhasa, tiquina mehna cjẽnare doce waro tiquiro ohoatiquinare bese docoahye. Sa ye tiquiro cũriquina wame tiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","15","Ahriquina ijiahye Jesu tiquiro bese docoriquina: Simo ijiahye. Simore Pedro ni pisuahye Jesu pehe. Simo bahʉro Andre, Santiago, Ñu, Felipe, Bartolomé, Mateo, Tomasu, Santiago ijiahye. Santiago pehe Alfeo macʉno ijiahye. Sa ye Simo celote ya curua cjʉ̃no ijimediquiro, ");
INSERT INTO pirNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Juda Santiago bahʉro, Juda Iscariote tiquina ijiahye tiquiro bese docoriquina. Juda Iscariote pehe Jesure ihña tuhtiyequinare ihñoatiquiro ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Sa ye Jesu tiquiro buheyequina mehna cʉnʉ buipʉ ijiriquina dijia taye, peyequina apequina tiquiro buheyequina mehna dijia wihidʉca, quehnoari paapʉ ducuahye tiquina. Ijipihtiropʉ Judea yehpapʉ ijiye macari cjẽna, Jerusalẽ cjẽna, Tiro wame tiri maca cjẽna, Sidõ wame tiri maca cjẽna pajiri ma dʉhtʉ cahapʉ ijiye macari cjẽna masa peyequina tiquiro cahapʉ wihiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Tiquina Jesu buheyere tʉhoye tehe, tiquina dohatiyere cohãgʉ̃ cahmeahye. Watĩa cʉoyequina gʉ̃hʉ tiquiro cahapʉ wihi, quehnoa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Jesu tiquiro tutuaye mehna yʉhdʉgʉ̃ yeahye tiquinare. Sa ye tiquina ijipihtiyequina tiquirore dahra tuhuye ahtahye. ");
INSERT INTO pirNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Came Jesu tiquiro buheyequinare ihña, yahuahye: —‍Mʉsa pejecʉona, (mʉsa ñañene bʉjʉa witina), Cohãcjʉ̃ tiquiro pʉhtoro ijiropʉ wahanata mʉsa. Sa yena mʉsa bucuenata. ");
INSERT INTO pirNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Yojopʉre mʉsa ʉjʉa ahbana, yapina ijinata. Sa yena bucuenata. ’Yojopʉ utina ijina, came mʉsa bʉjʉnata. Sa yena mʉsa bucuenata. ");
INSERT INTO pirNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ ijiaja. Sa yena yeere yena mʉsa ijiri buhiri apequina mʉsare tiquina ihña tuhtiepegʉ̃ta bucuena ijire mʉsa. Mʉsare tiquina cohãepegʉ̃ta bucuenata. Mʉsare tiquina ñano yahuducuepegʉ̃ta “Ñana ijire”, mʉsare tiquina niepegʉ̃ta mʉsa pehe bucuenata. ");
INSERT INTO pirNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Mʉsare tiquina sa yegʉ̃ ihñano ʉhmʉsepʉ mʉsa esagʉ̃ pajiro quehnoano yerota Cohãcjʉ̃ mʉsare. Sa yena tutuaro bucuena ijiya. Quehnoano jeripohna tina ijiya. Mʉsare ihña tuhtiyequina tiquina acaye panopʉ cjẽna sata ñano yeahye Cohãcjʉ̃ yere yahu mʉhtariquina gʉ̃hʉre. ");
INSERT INTO pirNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Sa yena mʉsa yojopʉ peye cʉona ahri yehpapʉ mʉsa quehnoano iji cã tuhasari. Sa yena ñano yʉhdʉna ijinata mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Yojopʉ yapina mʉsa ʉjʉa ahbanata. Mʉsa sa ijirina ñano yʉhdʉnata. ’Yojopʉre mʉsa bʉjʉrina ijina camepʉre utinata. Sa yena ñano yʉhdʉnata. ");
INSERT INTO pirNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’ “Cohãcjʉ̃ yere yahu mʉhtana ijiaja”, ni mehoñequinare “Quehnoañequina ijire”, nimahye peyequina panopʉ cjẽna. Sa nimediquina tiquina acaye yojopʉ cjẽna gʉ̃hʉ sata “Quehnoañequina ijire”, niboaga ihquẽquina mʉsa mehna cjẽnare. Tiquina sa ninohrina mʉsa ijina ñano yʉhdʉnata mʉsa gʉ̃hʉ, ni buheahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Sa yero ohõ saha ni buhe nemoahye Jesu: —‍Yʉhʉre tʉho duanare, mʉsareta nigʉ niaja. Mʉsare ihña tuhtiyequina tiquina ijiepegʉ̃ta tiquina gʉ̃hʉre cahĩña. Mʉsare ihña tuhtiyequinare quehnoano yeya. ");
INSERT INTO pirNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mʉsare “Ñano yʉhdʉahro”, niñequina tiquina ijiepegʉ̃ta quehnoa dutiya tiquinare. Mʉsare ñano yeyequina tiquina ijiepegʉ̃ta “Tiquina gʉ̃hʉ quehnoano ijiahro”, ni sini basaya Cohãcjʉ̃re. ");
INSERT INTO pirNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ihcãquiro mʉsa wahsupure tiquiro quẽgʉ̃, ape sie gʉ̃hʉre quẽ dutiya tiquirore. Mʉsa bui cjã suhtirore tiquiro ehmagʉ̃ mʉsa camisa gʉ̃hʉre sa oho cãhña tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mʉsare sinidiquirore tiquiro sinino punota ohoya tiquirore. Mʉsa yere tiquiro negʉ̃ tiquirore sinitueracãhña pari turi tire. ");
INSERT INTO pirNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Apequina mʉsare tiquina quehnoano yegʉ̃ cahmene mʉsa. Tiquinare mʉsa quehnoano yegʉ̃ cahmeno saha quehnoano yeya tiquina gʉ̃hʉre. Tiquina quehnoano yerapegʉ̃ta mʉsa pehe tiquinare quehnoano yeya. ");
INSERT INTO pirNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Mʉsare cahĩñequina dihitare mʉsa cahĩgʉ̃ ti ne dʉhseati ijierare apequina pehere mʉsa cahĩedagʉ̃. Ñañequina gʉ̃hʉ sata yere. ");
INSERT INTO pirNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Sa yena mʉsare quehnoano yeyequina dihitare mʉsa quehnoano yegʉ̃ ti gʉ̃hʉ ne dʉhseati ijierare apequina pehere mʉsa quehnoano yeragʉ̃. Tire ñañequina gʉ̃hʉ yere. ");
INSERT INTO pirNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Sa yero “Yʉhʉre wiaya tire”, mʉsa niñequina dihitare mʉsa wasogʉ̃ ne ti dʉhseati ijierare. Ñañequina gʉ̃hʉ apequinare “Yʉhʉre wiaya tire”, tiquina niñequinare wasore. ");
INSERT INTO pirNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Sa yena mʉsa pehe mʉsare ihña tuhtiyequina gʉ̃hʉre cahĩña. Sa yena tiquinare quehnoano yeya. Apequirore wasona “Yʉhʉre ne wiasi ahriquiro”, ni tʉhotuenata tiquirore wasoya. Cohãcjʉ̃ pehe tiquirore “Quehnoare”, nieñequina gʉ̃hʉre, ñañequina gʉ̃hʉre quehnoano yere. Tiquiro yero saha yeya mʉsa gʉ̃hʉ. Mʉsa sa yegʉ̃ Cohãcjʉ̃ tutuaro quehnoano yerota mʉsare. Sa yena Cohãcjʉ̃ tutua yʉhdʉariquiro ʉhmʉse cjʉ̃no pohna ijinata. ");
INSERT INTO pirNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mari Pacʉ ʉhmʉse cjʉ̃no tiquiro paja ihñariro sahata mʉsa gʉ̃hʉ masare paja ihñaña, ni yahuahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Sa yero tiquinare yahu nemoahye: —‍Apequinare “Ñañequina ijire”, niedacãhña mʉsa. Mʉsa sa niedagʉ̃ Cohãcjʉ̃ mʉsa gʉ̃hʉre “Ñana ijire”, nisi. Apequina mʉsare tiquina ñano yerire tiquina ñano nidi gʉ̃hʉre boya mʉsa. Mʉsa sa bogʉ̃ ihñano Cohãcjʉ̃ mʉsa gʉ̃hʉre mʉsa ñañe yerire borota. ");
INSERT INTO pirNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Apee borore cʉona apequinare ohoya. Mʉsa sa ohogʉ̃ Cohãcjʉ̃ gʉ̃hʉ mʉsare ohorota. Sa ohoro quehnoano queoro mʉsare pajiro ohorota. Quehnoano wahpa yʉhdʉro ohorota. Apequinare mʉsa ohoriro punota Cohãcjʉ̃ gʉ̃hʉ mʉsa gʉ̃hʉre ohorota, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Sa ni tuhasa Jesu quiti mehna buhero ohõ saha ni yahu nemoahye: —‍Caperi bajueyequina sehsaro tiquina basi quehnoano tʉã cã masiedare. Sa tʉã cãñe, tiquina pʉaropʉ bora maa sajãa wahaeta copepʉ. (Sata Cohãcjʉ̃ yere masieñequina apequinare buhe masiedare. Sa ye tiquina ijipihtiyequina pecapʉ wahaeta.) ");
INSERT INTO pirNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Buheyequina tiquinare buheriquirore masi yʉhdʉdʉcaerare. Sa ijiepeta ijipihtiyequina buheyequina tiquina quehnoano buhe pehori bato tiquinare buheriquiro yero saha ijieta, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Sa ni tuhasa apeye quiti mehna yahu nemoahye: —‍Mari queoye mehna buhegʉ̃ ohõ saha yena ijire mʉsa: Mʉsa acayʉro tiquiro capeapʉ meheni pohcarogã tiquirore bora sajãgʉ̃ ti pohcarogãre quehnoano ihñare mʉsa. Mʉsa ya capeapʉ pajiri pjĩ ijiepegʉ̃ta ti pjĩne ne ihñedare mʉsa. Meheni pohcarogãre mʉsa ihñano saha mʉsa acayʉro tiquiro ñano yeye pehere quehnoano ihñare mʉsa. Mʉsa basi mʉsa ñañene tutuaro yepenata tire masiedare mʉsa pajiri pjĩne mʉsa ihñedaro sahata. ¿Dʉhse yena sa yeajari mʉsa? ");
INSERT INTO pirNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ohõ saha nina yero saha ijire mʉsa: “Yʉhʉ acayʉ, ñañene yegʉ nine mʉhʉ. Sa yegʉ tire duhuya”, nina yero saha ijire mʉsa. Sa nina ijiepenata pajiro ñañene yere mʉsa pehe. ¿Dʉhse yena mʉsa ñañene yepenata tire masiedajari mʉsa? Masa ihñono dihita quehnoano iji mehona ijire mʉsa sa yena. Pajiri pjĩne mʉsa capeapʉ ijiri pjĩne mʉsa ne mʉhtaboriro saha mʉsa ñano yeye pehere duhu mʉhtaña. Mʉsa sa yeri bato mʉsa acayʉro tiquiro ñano yeyere duhugʉ̃ ye masiboaga meheni pohcarogãre mʉsa neboriro saha, ni buheahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Sa yero queoye mehna buhero ohõ saha ni yahu nemoahye tiquinare: —‍Quehnoadʉ yucʉgʉ ñañene dʉca tierare. Sa yero ñadʉ quehnoañene dʉca tierare. ");
INSERT INTO pirNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Yucʉ dʉcare masina tʉre masine mʉsa. Potagʉ higuera pacare dʉca tierare. Sa yero pota bʉcʉgʉ ʉhse tõhorine dʉca tierare. ");
INSERT INTO pirNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Sata ijire masa gʉ̃hʉ. Quehnoariquiro tiquiro tʉhotuyepʉ quehnoañe ijire. Sa yero tiquiro quehnoañene yere quehnoadʉ quehnoañene dʉca tiro saha. Ñariquiro tiquiro tʉhotuyepʉre ñañe ijire. Sa yero tiquiro ñañene yere ñadʉ ñañene dʉca tiro saha. Mari tʉhotuyepʉ marine ti ijiro saha yahuducuaja mari, ni yahuahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Sa yero tiquinare yahu nemoahye: —‍Mʉsa yʉhʉre “Pʉhto”, nine. Sa niepenata yʉhʉ dutiye pehere yerare mʉsa. ¿Dʉhse ijiro boro sa yerajari? ");
INSERT INTO pirNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ijipihtiyequina yʉhʉre cahmeñequina yʉhʉ yahuyere tʉhore. Sa yeye yʉhʉ dutiyere yʉhdʉdʉcaerare. Ohõ sahata ijire yʉhʉre yʉhdʉdʉcaeyequina: ");
INSERT INTO pirNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Wʉhʉ dahreriquiro yero saha ijire tiquina. Tiquiro ʉhcʉãñe coperire sehe, wʉhʉre doco dʉcare. Ti wʉhʉ quehnoano tiquiro yeri wʉhʉ ijiro dia minigʉ̃ tutuaro aco tutuepegʉ̃ta ti wʉhʉ quehnoano tojoare. ");
INSERT INTO pirNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Sa yeye yʉhʉ dutiyere tʉhoepeta yʉhdʉdʉcayequina pehe wʉhʉre quehnoano yerariquiro yero saha ijire. Ti wʉhʉre buigã doco, quehnoano ye dʉcaerare. Tiquiro sa yeri wʉhʉ ijiro dia minigʉ̃ aco tutuagʉ̃ duita ti wʉhʉ cohõ bʉrʉa wahare. Sa yero ti wʉhʉ tutuaro bora quehea wahare, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ti quitire masare yahu tuhasa Jesu gʉ̃hʉ Capernaupʉ esahye. ");
INSERT INTO pirNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Topʉ ijiriquiro cien surara pʉhtoro tiquiro cahacjʉ̃nore tutuaro cahĩahye. Tiquiro cahacjʉ̃no pehe tutuaro dohatiro, yariaropʉ niahye. ");
INSERT INTO pirNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Sa yero Jesu yeyere tʉhoro, judio masa bʉcʉnare Jesu cahapʉ ohoahye pʉhtoro pehe. —‍Dohatiriquirore yʉhdʉogʉ ahtaya, ni, yahu dutiro bʉcʉnare ohoahye pʉhtoro. ");
INSERT INTO pirNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Tiquina Jesu cahapʉ esa, ohõ saha ni tutuaro mehna yahuahye tiquirore: —‍Surara pʉhtoro ʉsãre ohori. Tiquiro cahacjʉ̃nore dohatiriquirore yʉhdʉgʉ̃ cahmedi tiquiro. Tiquiro pʉhtoro pehe quehnoariquiro ijire. Tiquiro sa ijigʉ̃ yedohoya tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Mari ya maca cjẽnare tiquiro cahĩne. Sa yero tiquiro ʉsã buheri wʉhʉre tiquina yeri wapare wapa yere, niahye bʉcʉna Jesure. ");
INSERT INTO pirNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Tiquina sa ni yahugʉ̃ tʉhoro Jesu pehe tiquina mehna wahahye. Surara pʉhtoro ya wʉhʉ cahagãpʉ tiquiro esagʉ̃ pʉhtoro pehe tiquiro mehna cjẽnare Jesure ohõ saha ni yahu dutiro ohoahye: —‍Pʉhto, quehnoanota. Ahtaeracãhña. Quehnoagʉ ijieraja yʉhʉ. Ya wʉhʉpʉ mʉhʉre sajã ta dutibogʉ ijieraja yʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Sa yegʉ mʉhʉ cahapʉ wahaeraja. Yʉhʉ sa ijiepegʉ̃ta mʉhʉ masiñe mehna yʉhdʉ dutiya mʉhʉ tiquirore. Mʉhʉ sa yegʉ̃ yʉhʉ cahacjʉ̃no quehnoanota. ");
INSERT INTO pirNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Yʉhʉre yʉhʉ bui ijiyequina apequina pʉhtoa dutire. Sa yegʉ yʉhʉ gʉ̃hʉ surarare dutiaja. Ihcãquirore “Wahaya”, yʉhʉ nigʉ̃ tiquiro wahare. Apequirore “Ahtaya”, yʉhʉ nigʉ̃ tiquiro ahtare. Yʉhʉ cahacjʉ̃nore “Ahrire yeya”, yʉhʉ nigʉ̃ tire tiquiro yere. Mʉhʉ gʉ̃hʉ dutigʉta ijire. Sa yero mʉhʉ dutiro saha tiquiro dohatiriquiro yʉhdʉrota, ni yahu dutiahye surara pʉhtoro. ");
INSERT INTO pirNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Tiquiro sa nigʉ̃ tʉho maria waharo, peyequina masa tiquiro mehna ijiyequinare majaredʉca sa, yahuahye: —‍Mʉsare niita niaja. Tiquiro surara pʉhtoro Israe masʉno ijieriquiro Cohãcjʉ̃re tutuaro wacũ tutuare. Tiquiro cahacjʉ̃nore yʉhʉ yʉhdʉgʉ̃ yeatire masi tuhasare. Israe masare ne ahriquiro yero saha ijiyequinare ihñeda tirʉ yʉhʉ, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Tiquiro sa nidi bato surara pʉhtoro Jesu cahapʉ tiquiro ohoriquina tiquina pʉhtoro ya wʉhʉpʉ tojoaa wahahye. Tojoa sa dohatiriquiro yʉhdʉriquiropʉre ihñahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Came cjũnogã Nai wame tiri macapʉ Jesu tiquiro buheyequina mehna peyequina masa mehna wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ti macare sajãri sopecaha cahapʉ tiquiro esagʉ̃ yariariquirore masa ne wijia taye niahye. Yariariquiro pacoro wape wihoro ijiahye. Ihcãquirota ijiriquiro yariahye. Sa ye to cjẽna masa peyequina ticoro mehna wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Tiquina sa wahagʉ̃ ihñano Jesu ticorore paja ihñahye. —‍Utieracãhña, niahye Jesu ticorore. ");
INSERT INTO pirNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Sa nino yariariquiro tiquiro masa putire ña peoahye. Tiquiro sa ña peogʉ̃ ihñañe ti putire wʉayequina pehe esadʉcahye. —‍Macʉ, yʉhʉ mʉhʉre ohõ saha niaja. Wahcã nujuña, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Tiquiro sa nidi bato yariariquiro mʉnano wahcã nuju, yahuducuahye. Sa yero Jesu tiquirore tiquiro pacorore wiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Tiquiro sa yegʉ̃ ihñañe tiquina ijipihtiyequina cuea wahahye. Sa yeye tiquina Cohãcjʉ̃re ño peo, ohõ saha niahye: —‍Cohãcjʉ̃ yere yahu mʉhtariquiro masi yʉhdʉariquiro yojopʉ pũritare mari watoa ijire, niahye tiquina. —‍Cohãcjʉ̃ marine tiquiro yequinare yedohoro wihi tuhasare, niahye apequina. ");
INSERT INTO pirNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Sa yeye ijipihtiyequina Judea yehpa cjẽnare ti yehpa dʉhtʉ cahapʉ ijiye macari cjẽnare Jesu yerire masa yahu site pehoahye. ");
INSERT INTO pirNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Sa ye Jesu yerire ihñañe Ñure yahuahye tiquiro buheyequina. Sa tiquina yahugʉ̃ tʉhoro pʉarore tiquiro cahapʉ pijio, ");
INSERT INTO pirNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Jesure sinitu dutiro ohoahye Ñu. Ohõ saha ni sinitu dutiahye: —‍¿Ñu “Yʉhʉ bato apequiro ahtarota”, tiquiro nidigʉta ijiajari mʉhʉ? ¿Tiquiro nidigʉ mʉhʉ ijieragʉ̃ apequirore cohtenatari ʉsã? ni sinitu dutiahye Ñu pʉaro tiquiro buheyequinare. ");
INSERT INTO pirNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Sa ye tiquina Jesu cahapʉ esa, sinituahye tiquirore: —‍Ñu wame yeriquiro mʉhʉre sinitu dutiro ohori ʉsãre. ¿Ñu “Yʉhʉ bato apequiro ahtarota”, tiquiro nidigʉta ijiajari mʉhʉ? ¿Tiquiro nidigʉ mʉhʉ ijieragʉ̃ apequirore cohtenatari ʉsã? ni sinituahye tiquina Jesure. ");
INSERT INTO pirNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ti pjeta peyequina dohatiyequinare, watĩa cʉoyequinare, caperi bajueyequinare yʉhdʉgʉ̃ yeahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Sa yero Ñu ohoriquinare Jesu yʉhtiahye: —‍Yojopʉre mʉsa ihñarire mʉsa tʉhorire Ñure yahuna wahaya: Ohõ saha niña: “Caperi bajueyequina ihñare. Tini masieñequina tinine. Cami ahbariquina quehnoa wahare. Tʉhoerariquina tʉhoa wahare. Yariariquina masaa wahare. Tiquina ijipihtiyequinare quehnoa wahagʉ̃ yei yʉhʉ. Sa yegʉ pejecʉoyequinare quehnoañe buheyere yahuaja. ");
INSERT INTO pirNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Yʉhʉre tʉhoriquiro ‘Poto ijire’, nidiquiro tiquiro bucueriquiro ijire”, Ñure ni yahuna wahaya, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ñu buheyequina tiquina wahari bato Jesu pehe Ñu tiquiro ijiye tiyere yahu dʉcahye peyequina masare: —‍Masa marienopʉ esana, taare wihnono wẽdoqueo mʉjagʉ̃ ihñana eserari mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","“Quehnoañe suhti sañariquirore ihñana wahaʉhna”, niedari mʉsa masa marienopʉ wahana. Quehnoañe suhti sañañequina wapa bʉjʉyere cʉoyequina pʉhtoa ye wʉhʉsepʉ ijire. Masa marienopʉ ijierare. ");
INSERT INTO pirNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Masa marienopʉ esana Cohãcjʉ̃ yere yahu mʉhtariquirore ihñana esari mʉsa. Ijirota ijire. Ñu Cohãcjʉ̃ yere yahu mʉhtariquiro ijire. Apequina Cohãcjʉ̃ yere yahu mʉhtariquina yʉhdʉoro ijiriquiro ijire tiquiro pehe. ");
INSERT INTO pirNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Panopʉ Cohãcjʉ̃ yere tiquina ojoari pũpʉ Ñure ohõ saha ni yahuahye: Mari Pacʉ tiquiro macʉnore ohõ saha niahye: “Mʉhʉ pano mʉhʉre yahuyuatiquirore ohogʉtja. Mʉhʉ wihiatore quehnoyurota tiquiro”, niahye Cohãcjʉ̃, ni ojoahye panopʉre Ñure. ");
INSERT INTO pirNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","’Mʉsare poto niita niaja. Apequina masa ijipihtiyequina bui ijire Ñu. Ahri decoripʉre tiquiro sa ijiepegʉ̃ta Cohãcjʉ̃ tiquiro pʉhtoro ijiropʉre ijipihtiyequina docapʉ ijiriquiro pũrita Ñu bui ijire, niahye Jesu masare. ");
INSERT INTO pirNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Tiquiro sa nigʉ̃ tʉhoye ijipihtiyequina masa, wapa ne cohteyequina mehna Ñu tiquiro wame yenohriquina ijiye ohõ saha ni tʉhotuahye Cohãcjʉ̃re. “Cohãcjʉ̃ poto yeriquiro ijire”, ni tʉhotuahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Fariseo masa pehe, judio masare buheyequina gʉ̃hʉ Ñu wame yenohriquina iji duerahye. Sa ye tiquinare Cohãcjʉ̃ yequina tiquiro ye duagʉ̃ cahmedahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Sa yero Jesu pari turi yahuahye: —‍¿Yojopʉ cjẽna masa disequina yero saha ijiajari tiquina, mʉsa tʉhotugʉ̃? ");
INSERT INTO pirNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Tiquina macanagã yero saha ijire. Apequina tiquina cahmeno saha yeragʉ̃ bucuerare tiquinagã. Doeri cjẽ duaropʉ apepe dujiye, ohõ saha ni pisuducure tiquinagã basi: “Mʉsa basatire ʉsã putipemi. ¿Dʉhsena mʉsa basaerari ʉsã putipegʉ̃? Ʉsã tutuaro ñehe quea utipe, sañuducumi. ¿Mʉsa pehe dʉhsena ʉsã mehna utiperari?” niducuyequina yero sahata ijire yojopʉ cjẽna gʉ̃hʉ. Yojopʉ cjẽna tiquina cahmeno saha ʉsã yeragʉ̃ ihñañe bucuerare tiquina gʉ̃hʉ. ");
INSERT INTO pirNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ñu wame yeriquiro Cohãcjʉ̃re ño peoro taro sijiro, vinore sihniedare. Tiquiro sa sihniedagʉ̃ ihñana, “Watĩnore cʉore. Sa yero tʉho masieniquiro ijire”, nimedi mʉsa tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ ijigʉ, yʉhʉ ihya sihniaja. Yʉhʉ sa yegʉ̃ ihñana ohõ saha nine mʉsa yʉhʉ pehere. “Ihñaña. Ahriquiro pajiro ihyariquiro, queheriquiro ijire. Wapa ne cohteyequina, ñano yeyequina gʉ̃hʉ tiquina mehna piti tiriquiro ijire tiquiro”, nine mʉsa yʉhʉre. Sa nina macanagã yero saha yahuducuna ijire mʉsa. Mʉsa cahmeno saha ʉsã yeragʉ̃ bucuerare mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Sa masiedapenata ʉsã ye ihñorire ihñana, Cohãcjʉ̃ yere ʉsã masigʉ̃ masinata mʉsa, ni yahuahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Fariseo masʉno tiquiro ya wʉhʉpʉ ihya dutiro pijiahye Jesure. Tiquiro sa pijigʉ̃ Jesu tiquiro ya wʉhʉpʉ esa, tiquina ihyari mesa cahapʉ nuju sahye. ");
INSERT INTO pirNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","38","Ti macapʉre ñañe yericoro ijiahye. Jesu fariseo masʉno ya wʉhʉpʉ tiquiro dujigʉ̃ ticoro tʉhoahye. Sa tʉhoro alabastro mehna yeriare ehme sitiye pose tiriare ne cãhta, Jesu behero pehepʉ wihidʉca, utiahye. Sa utiro, Jesu dahpocãrine ticoro yahco co mehna weo, ticoro poari mehna wʉoahye. Tiquiro dahpocãri wʉagʉ̃ ihñano ticoro tiquiro dahpocãrine ihmi, ehme sitiye mehna pio peoahye. ");
INSERT INTO pirNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ticoro sa yegʉ̃ ihñano fariseo masʉno Jesure pijiriquiro tiquiro basi ohõ saha ni tʉhotumahye: “Ahricoro tiquirore ñehe tuhuricoro ñañe yericoro ijire. Ahriquiro Jesu Cohãcjʉ̃ yere yahu mʉhtariquiro ijiro tire masiboaga”, ni, tʉhotumahye. ");
INSERT INTO pirNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Tiquiro sa ni tʉhotuyere masino Jesu yahuahye tiquirore: —‍Simo, yojopʉ pũritare mʉhʉre yahu duaja, niahye Jesu. —‍¿Buhegʉ, yʉhʉre dʉhse ni yahu duajari mʉhʉ? niahye Simo. ");
INSERT INTO pirNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Tiquiro sa nigʉ̃ Jesu ohõ saha ni queoye mehna buhe yahuahye: —‍Pʉhtorore pʉaro wapamoñequina ijiahye. Ihcãquiro wapamoriquiro quinientos niñeru cjoerire wapamoahye. Apequiro pehe cincuenta niñeru cjoerire wapamoahye. ");
INSERT INTO pirNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Sa ye tire tiquina wapa ye masiedagʉ̃ ihñano tiquiro tiquina wapamoñene wapa ye dutierahye. ¿Yojopʉ pũritare diquiro pehe wapamoriquiro tiquiro pʉhtorore cahĩ yʉhdʉrotari? ni sinituahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simo yʉhtiahye: —‍Õbah, pajiro wapamoriquiro mehenogã wapamoriquiro yʉhdʉoro tiquiro pʉhtorore cahĩboaga, niahye Simo. —‍Poto yʉhtiri mʉhʉ yʉhʉre, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Sa ni tuhasa tiquirore pio peoricorore majare ihña, Jesu Simore yahu nemoahye: —‍Ahricorore ihñaña mʉhʉ. Mʉhʉ ya wʉhʉpʉ yʉhʉ sajã wihiri bato yʉhʉ dahpocãrine coseati acore yʉhʉre ohoerari mʉhʉ. Ahricoro pehe ticoro yahco co mehna yʉhʉ dahpocãrine weo, ticoro poari mehna wʉori yʉhʉre. ");
INSERT INTO pirNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Mʉhʉ pehe yʉhʉre piti ca ihmiedari. Ahricoro pehe ohõpʉ yʉhʉ dujiro puno yʉhʉ dahpocãrine ihmidi. ");
INSERT INTO pirNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Mʉhʉ pehe yʉhʉ dapure ʉhse mehna pio peoerari. Ticoro pehe yʉhʉ dahpocãrine ehme sitiye mehna pio peori. ");
INSERT INTO pirNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Sa nigʉ mʉhʉreta yahugʉta niaja. Ahricoro ticoro ñañe yeye pe yʉhdʉaye ijire. Sa ijieperota ticoro tutuaro cahĩne yʉhʉre. Sa yegʉ ticoro ñañene bou. Sa yeye tiquina ñañene mehenogã yʉhʉ bonohriquina mehenogã cahĩne yʉhʉre, niahye Jesu Simore. ");
INSERT INTO pirNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Sa ni tuhasa tiquiro ticorore yahuahye: —‍Yojopʉ pũritare mʉhʉ ñañe yeyere bou, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Tiquiro sa nigʉ̃ tʉhoye Jesu mehna dujiyequina tiquina basi ohõ saha ni yahuducuahye: —‍Ahriquiro potota ñañe yeyere boriquiro ijire. ¿Dʉhse ijiriquiro boro ijiajari ahriquiro ñañene boriquiro? niahye tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Sa yero Jesu numinore ohõ saha ni yahuahye: —‍Yʉhʉre mʉhʉ wacũ tutuagʉ̃ mʉhʉre pecapʉ wahaborigore yʉhdʉoaja. Cuero marieno mʉhʉ ya wʉhʉpʉ tojoaa wahaya, niahye Jesu ticorore. ");
INSERT INTO pirNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Came bʉjʉye macaripʉ, daye macarigãpʉ gʉ̃hʉre esa, Cohãcjʉ̃ tiquiro pʉhtoro ijiyere quehnoañe buheyere yahuahye Jesu. Doce tiquiro buheyequina pehe tiquiro mehna ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Sa ye numia gʉ̃hʉ watĩa cʉomediquina numia, dohatimediquina numia Jesu quehnoa wahagʉ̃ tiquiro yeriquina numia tiquiro mehna tiniahye. “María”, tiquina nidicorore “Magdalena”, ni pisue tiahye ticorore. Ticorore siete watĩare Jesu cohãhye to pano. Sa yero ticoro gʉ̃hʉ Jesu mehna tiniahye. ");
INSERT INTO pirNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Chuza wame tiriquiro Herodere yedohomediquiro namono Juana gʉ̃hʉ Jesu mehna tiniahye. Susana wame tiricoro gʉ̃hʉ apequina numia mehna peyequina tiquina cʉoye mehna Jesu gʉ̃hʉre yedohoahye. ");
INSERT INTO pirNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Sa ye peye macari cjẽna Jesu cahapʉ cahmecoahye. Tiquina sa cahmecoari bato Jesu tiquiro tʉhotuye mehna queoye mehna tiquinare yahuahye buhero taro: ");
INSERT INTO pirNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—‍Oteriquiro otero wahahye. Tiquiro sa otegʉ̃ apeye pjeri maha dʉhtʉ cahapʉ bora quehe sahye. Sa yeye ti pjerire masa cʉhta diho cũahye. Sa ye minicjʉa pari pehe ti pjerire ihyahye. ");
INSERT INTO pirNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Sa ye apeye pjeri ʉtã paca watoa bora quehe sahye. Topʉ yehpapʉ aco mariedahye. Sa ye ti pjeri pihni wahcãdʉca ñaia wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Apeye pjeri taa watoa bora quehe sahye. Taa pehe ti oteye mehna pihniahye. Taa pehe dia yʉhdʉa waha, oteyere wejẽahye. ");
INSERT INTO pirNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Apeye pjeri quehnoari yehpapʉ bora quehe sahye. Quehnoano pihni, dʉca tiahye. Sa ye peye dʉca tiahye, niahye Jesu. Sa ni tuhasa ohõ saha tutuaro ni nemoahye: —‍Ahrire quehnoano tʉhoya mʉsa, niahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Came tiquiro buheyequina ti queoyere masi duaye, Jesure sinituahye: —‍¿Ahri queoye mehna dʉhse ni yahugʉ niajari mʉhʉ? ni, sinituahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Tiquina sa nigʉ̃ Jesu yʉhtiahye: —‍Cohãcjʉ̃ masa pʉhtoro tiquiro ijiyere panopʉ apequina tiquina masiedarire mʉsare masigʉ̃ yerota Cohãcjʉ̃. Apequina pehere sa yerare tiquiro. Tiquinare queoye mehnata buheitja. Yʉhʉ sa yegʉ̃ tiquina yʉhʉ buheyere tʉhoepeta masisi, niahye Jesu tiquiro buheyequinare. ");
INSERT INTO pirNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Sa ni tuhasa tiquinare yahu nemoahye: —‍Ohõ saha ni yahure ahri quiti: Oteye pjeri quehnoañe buheye yero saha ijire. ");
INSERT INTO pirNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Sa ye maha dʉhtʉ cahapʉ borari pjeri pehe quehnoañe buheye yero saha ijire. Sa yero masa quehnoañe buheyere tiquina tʉhogʉ̃ ihñano watĩno pehe ahta, ti buheyere masi dutierare masare. Minicjʉa ti pjerire tiquina dote nediro saha yere. Tiquiro sa yeragʉ̃ tiquina Cohãcjʉ̃re wacũ tutuaboa. Tiquina sa wacũ tutuagʉ̃ ihñano Cohãcjʉ̃ pehe tiquinare pecapʉ wahaboriquinare yʉhdʉoboa. ");
INSERT INTO pirNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ʉtã pjeri watoa borari pjeri quehnoañe buheye yero saha ijire. Sa ye masa quehnoañe buheyere tʉho, bucueye mehna tire tʉho nene. Sa tʉho nepeta ʉtã watoa ijiye cjʉ nʉhcori marieñe cjʉ yero saha ahriquina masa gʉ̃hʉ tutuerare. Sa tutueraye yeequina tiquina ijiri buhiri apequina tiquinare ñano yegʉ̃ ihñañe yee pehere duhu cãhre. ");
INSERT INTO pirNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Sa ye taa watoa borari pjeri quehnoañe buheye yero saha ijire. Sa ye masa quehnoañe buheyere tʉhoepeta, ahri yehpa cjẽne pajiro bʉjʉa witi tʉhotu, niñeru pehere cahĩ, ahri yehpa cjẽne bucuere tiquina. Sa yeye ti pehe quehnoañe buheyere cahmotagʉ̃, masa pehe quehnoañe pehere yerare. ");
INSERT INTO pirNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Sa ye quehnoari yehpapʉ borari pjeri quehnoañe buheye yero saha ijire. Sa yeye masa quehnoañe buheyere tʉhoye, quehnoano mehna ti buheyere yʉhdʉdʉcaerare. Sa ye yucʉgʉ dʉca tiro saha quehnoañe buheyere tʉhoyequina pehe Cohãcjʉ̃ tiquiro cahmeno saha quehnoañene yere, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Sa ni tuhasa apeye queoye mehna buheahye tiquiro: —‍Ne sihãriare dihi sutu docapʉ cũedare masa. Sa ye tiare cumuno docapʉ cũedare. Ʉhmʉanopʉ tiare duhu peore wʉhʉpʉ sajã tayequina tiquina quehnoano ihña sajã tato saha. ");
INSERT INTO pirNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ijipihtiye tiquina masiedarire came masa masieta. Sihãria buhriogʉ̃ mari ihña masino saha panopʉ tiquina masiedarire masieta masa. ");
INSERT INTO pirNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Sa yena mʉsa tʉhona quehnoano tʉho nʉnʉña. Quehnoano tʉho nʉnʉriquiro, quehnoano masinota. Tʉho nʉnʉediquiro “Mehenogã tʉhoaja”, tiquiro niepegʉ̃ta ti pehere boaa waharota, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Came Jesu bahana tiquina pacoro mehna tiquiro cahapʉ wahaye nimahye. Masa peyequina ijigʉ̃ tiquiro cahapʉ eserahye. ");
INSERT INTO pirNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Sa yero ihcãquiro Jesure yahuahye: —‍Mʉhʉ paco mʉhʉ bahana mehna sopecahapʉ ducuri. Mʉhʉre ihñañe taye niñohti, niahye tiquiro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Tiquiro sa nigʉ̃ Jesu ohõ saha ni yahuahye ijipihtiyequinare: —‍Cohãcjʉ̃ buheyere tʉhoyequina, tire yʉhdʉdʉcaeyequina tiquinata yʉhʉ paco yʉhʉ bahana yero saha ijire, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ape deco Jesu tiquiro buheyequina mehna yucʉsapʉ sajãhye. —‍Isa, pehãʉhna, ni, tiquina ijipihtiyequina tia mehna ditarapʉ pehãa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Sa pehãno carĩa wahahye Jesu. Tiquina sa pehãducuropʉ tutuaro wihnono wẽahye. Wihnono wẽgʉ̃ bʉjʉye pahcõri wahcã, tiquinare mio cãmahye. Sa waharo miono cua yʉhdʉahye tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Sa wahagʉ̃ ihñañe, acʉaa waha, Jesu cahapʉ waha, tiquirore wahcõahye. —‍Buhegʉ, mari yariana tana niajʉ́, niahye tiquina. Tiquina sa nigʉ̃ Jesu pehe wahcã, wihnonore, —‍To punota wẽ duhuya, niahye. Sa nino pahcõri gʉ̃hʉre, —‍Yʉsʉa wahaya, niahye. Tiquiro sa nigʉ̃ta wihnono yʉhdʉa wahahye. Sa ye pahcõri gʉ̃hʉ yʉsʉ dijiaa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Sa wahari bato Jesu tiquinare ohõ saha niahye: —‍¿Mʉsa yʉhʉre wacũ tutuerajari? niahye tiquiro. Tiquiro sa nigʉ̃ tiquina pehe cue, acʉaa waha, tiquina basi ohõ saha ni yahuducuahye: —‍¿Yohou, dʉhse ijiriquiro boro masʉno ijiajari ahriquiro? Ahri wihnono, pahcõri gʉ̃hʉ tiquiro dutigʉ̃ yʉhdʉdʉcaerare tiquirore, niahye tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Sa ye tiquina ape sie pahrẽpʉ Gerasa cjẽna ya yehpapʉ pehã sahye. Ti yehpa Galilea yehpa poto ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Topʉ Jesu tiquiro maja sadʉcagʉ̃ waro to cjʉ̃no watĩa cʉoriquiro tiquiro cahapʉ ahtahye. Tiquiro yoari pje suhti marieniquiro ijiro, tiquiro ya wʉhʉpʉre ne ijierahye. Sa yero masa coperi ʉtãpʉ tiquina seheri coperi cahapʉ ijie tiahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Sa ye peye tahari watĩa tiquirore ñeheahye. Sa yero tiquiro peresupʉ ijigʉ̃ tiquiro omocarine, dahpocãrine come dari mehna dʉhteriquiro ijieperota, ti darire tʉã sure mʉjahye. Sa ye watĩa pehe tiquirore masa marienopʉ ne cã mʉjae tiahye. Sa yero tiquiro Jesure ihñadoqueo, tutuaro sañuducu, Jesu cahapʉ dʉsepe curi mehna quehe sahye. Tiquiro sa yegʉ̃ ihñano Jesu pehe tiquirore dutiahye: —‍Ahriquiro mehna ijieracãhña. Wahaya watĩa, niahye. Tiquiro sa nigʉ̃ tʉhoro watĩa cʉoriquiro tutuaro sañuducu, sinituahye Jesure: —‍¿Jesu, ʉhmʉse cjʉ̃ Cohãcjʉ̃ macʉ yabere yei tʉʉ niajari mʉhʉ yʉhʉre? Yʉhʉre ñano yeracãhña, niahye watĩa cʉoriquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Tiquiro sa nigʉ̃ Jesu pehe sinituahye tiquirore: —‍¿Dʉhse wame tiajari mʉhʉ? niahye. Peyequina watĩa tiquiro mehna ijiahye. Sa yero ohõ saha niahye tiquinare cʉoriquiro. —‍Watĩa peyequina wame tiaja ʉsã, ni, yʉhtiahye watĩa cʉoriquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","—‍Ʉhcʉãri copepʉ ʉsãre waha dutieracãhña, ni, tutuaro siniahye watĩa pehe. ");
INSERT INTO pirNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ti pjere topʉ cʉnʉ dahpotopʉ yesea peyequina ihyaye niahye. Tiquina topʉ ihyagʉ̃ ihñañe watĩa ohõ saha ni siniahye Jesure: —‍Sisequina yesea cahapʉ waha dutiya ʉsãre. Tiquina mehna iji dutiya ʉsãre, ni, siniahye watĩa. Tiquina sa nigʉ̃ tʉhoro Jesu tiquinare yesea cahapʉ waha dutiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Tiquiro sa waha dutiri bato watĩa pehe masʉno mehna ijimediquina waha, yesea cahapʉ esahye. Tiquina cahapʉ tiquina esari bato yesea pehe pari cjʉ̃pʉ oma maa buhaa waha, ditarapʉ bora ñojoa mini yaria pihtia wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Yeseare cohteyequina yesea tiquina sa minigʉ̃ ihñañe, cue, oma cãa wahahye. Sa oma cã macapʉ esa, ti maca cjẽnare, ihquẽ wʉhʉse ijiro cjẽna gʉ̃hʉre tiquina ihñarire yahu siteahye. ");
INSERT INTO pirNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Tiquina sa yahu siteri bato masa ihñañe wahahye. Sa ye Jesu cahapʉ esa, watĩa cʉomediquirore suhti sañariquiro tʉho masiniquiro tiquiro dujigʉ̃ ihñahye tiquina. Tiquina ijipihtiyere ihñañe, tiquina cue niahye. ");
INSERT INTO pirNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Watĩa cʉomediquiro tiquiro quehnoa waharire ihñañequina apequinare tiquina ihñarire yahuahye. ");
INSERT INTO pirNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ti pjeta Gerasa yehpa cjẽna peyequina Jesure tutuaro cueye, tiquirore waha dutiahye. Tiquina sa waha dutigʉ̃ Jesu yucʉsapʉ sajã, waharo taro niahye. ");
INSERT INTO pirNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Watĩa cʉomediquiro Jesu wahato pano tutuaro sinimahye tiquirore: —‍Mʉhʉ mehna waha duaja, ni sinimahye. ");
INSERT INTO pirNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Tiquiro sa nigʉ̃ta Jesu tiquirore yʉhtiahye: —‍Mʉhʉ ya macapʉ wahaya. Sa wahagʉ Cohãcjʉ̃ mʉhʉre tiquiro yerire yahuya apequinare, niahye Jesu. Tiquiro sa nidi bato waha, tiquiro ya macapʉ esaro, masʉno pehe Jesu tiquirore yerire ijipihtiyequina tiquiro ya maca cjẽnare yahuahye. ");
INSERT INTO pirNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ape sie pahrẽpʉ Jesu pari turi tiquiro pehã sagʉ̃ ihñañe masa peyequina tiquirore cohte, bucueye mehna piti cahye tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Topʉ judio masa buheri wʉhʉ cohteriquiro Jairo wame tiriquiro Jesu cahapʉ esa, tiquiro dahpocãri cahapʉ dʉsepe curi mehna quehe sahye tiquirore ño peoro. Tiquiro macono yariaro niahye. Ticoro ihcãcorota ijiricoro doce cʉhmari cʉoricoro ijiahye. Sa yero tiquiro ya wʉhʉpʉ Jesure piji cãhye. “Aʉ”, ni, tiquiro mehna wahahye Jesu gʉ̃hʉ. Mahapʉ tiquina sa wahagʉ̃ pe yʉhdʉayequina masa ijiye, wahpa yʉhdʉahye. ");
INSERT INTO pirNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Sa yero apecoro numino doce cʉhmari waro dii mʉna dohatiducuricoro topʉ ijiahye. To pano duturuare ijipihtiye ticoro ye niñeru mehna wapa yemahye ticoro aco ye dutiro. Tiquina sa aco yepegʉ̃ta mʉnanota ijiducu cãhye ticoro. ");
INSERT INTO pirNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Sa yero ticoro Jesu behero pehepʉ ahta, tiquiro suhtiro sohtoare ticoro ñehe tuhugʉ̃ta ticoro dohatiye pihtia wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ticoro sa ñehe tuhugʉ̃ tʉhoturo Jesu sinituahye. —‍¿Noa yʉhʉ suhtirore ñehe tuhuajari? niahye tiquiro. Ijipihtiyequina “Ñehe tuhuerʉ”, niahye. Sa ye Pedro gʉ̃hʉ ohõ saha niahye: —‍Buhegʉ, bihsarĩne. Sa yeye masa peyequina mʉhʉre ñehe tuhure. ¿Dʉhsegʉ sa ni sinituajari mʉhʉ? niahye tiquina Jesure. ");
INSERT INTO pirNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Tiquina sa nigʉ̃ Jesu yʉhtiahye: —‍Mianogãta yʉhʉ yʉhdʉgʉ̃ yei ihcãcorore. Sa yegʉ yʉhʉre ticoro ñehe tuhugʉ̃ masiaja, niahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Tiquiro sa nigʉ̃ tʉhoro ticoro duhti masiedaro, nanarericoro Jesu cahapʉ dʉsepe curi mehna quehe sahye tiquirore ño peoro. Sa ye ijipihtiyequina masa tiquina tʉhoropʉ ticoro dohatiyere, Jesure ticoro ñehe tuhurire, ticoro quehnoa waharire yahuahye ticoro. ");
INSERT INTO pirNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ticoro yahu tuhasagʉ̃ Jesu ticorore yahuahye: —‍Maco, yʉhʉre mʉhʉ wacũ tutuaye mehna quehnoago tojoare yojopʉre. Bucueye mehna wahaya, niahye ticorore. ");
INSERT INTO pirNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Tiquiro sa nini watoa Jairo ya wʉhʉpʉ ijiriquiro yahuro wihiahye: —‍Mʉhʉ macogã yariaa wahari. Sa yegʉ buheriquirore piji cãhtaeracãhña, niahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Tiquiro sa nigʉ̃ tʉhoro, Jairore ohõ saha ni yahuahye Jesu: —‍Bʉjʉa witi tʉhotueracãhña. Yʉhʉre wacũ tutuaya. Ti dihitare yeya. Mʉhʉ sa yegʉ̃ ticorogã masaa waharota, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Sa ni tuhasa tiquiro ya wʉhʉpʉ esa, Pedro, Ñu, Santiago, dohatiricoro pacʉsʉmʉa topequinata ne sajãhye. Apequina pehere Jesu sajã dutierahye. ");
INSERT INTO pirNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Topʉ ijipihtiyequina masa tiquina ñehe quea utiri watoa sajã sahye Jesu. —‍Utieracãhña. Ticorogã yarierare. Carĩno nine, niahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Tiquiro sa nigʉ̃ tʉhoye tiquina pehe ticoro yariaricoro ijigʉ̃ masiñe, Jesure bʉjʉahye. “Sa ni maca cãno nine”, ni bʉjʉahye. ");
INSERT INTO pirNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Sa yero Jesu ticorogã omocare ñehe, pisuahye: —‍Mehenicorogã wahcãña, niahye. ");
INSERT INTO pirNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Tiquiro sa nigʉ̃ta yariaricoro masaa waha, wahcãdʉca sahye ticorogã. Ticoro wahcãdʉcari bato Jesu ticorore ihyayere oho dutiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ticoro sa masagʉ̃ ihñañe ticoro pacʉsʉmʉa ihña maria wahahye. Sa yero Jesu tire apequinare yahu dutierahye. ");
INSERT INTO pirNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Sa ye Jesu docere tiquiro buheyequinare pijio, tiquiro tutuayere ohoahye tiquinare. Watĩare tiquina cohãtire, dohatiyequinare yʉhdʉgʉ̃ yeati gʉ̃hʉre tiquiro tutuayere ohoahye tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Sa ye tuhasa tiquinare Cohãcjʉ̃ tiquiro pʉhtoro ijiyere buhe dutiro, dohatiyequinare yʉhdʉo dutiro ohoahye tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ohõ saha ni dutiahye Jesu tiquinare: —‍Mʉsa wahana apee borore nedacãhña. Tua dʉre, ajurore, ihyayere, niñerure nedacãhña. Mʉsa sañano dihitare saña cãhña. Apeye suhtire nedacãhña. ");
INSERT INTO pirNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ijipihtiye macaripʉ mʉsare tiquina carĩno ohogʉ̃ ti wʉhʉpʉta ijiniña. Coã wahanapʉ wijiaya ti wʉhʉre. ");
INSERT INTO pirNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Apeye macari cjẽna mʉsare tiquina cahmedagʉ̃ ihñana ti macarine yʉhdʉ cãa wahaya. Sa wahana mʉsa dahpocãri cjẽ dihta esa wahãrire wejẽ site cũña mʉsa tiquinare tiquina ye buhirire masigʉ̃ yena, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Tiquiro sa nidi bato tiquiro buheyequina pehe waha, ijipihtiye macaripʉ quehnoañe buheyere yahu tiniahye. Sa ye dohatiyequinare yʉhdʉoe tiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Sa ye Herode Galilea yehpa cjẽna pʉhtoro Jesu yerire tʉhoahye. “¿Noa boro ijiajari tiquiro Jesu?” nieperota ne masiedahye. Ihquẽquina ohõ saha nimahye Jesure. “Ñu wame yeriquiro mʉnano masa mʉjahye. Sa yero ‘Jesu’, tiquina nidiquiro tiquirota ijire”, nimahye ihquẽquina. Tiquina sa nigʉ̃ tʉhoro Herode Jesure dʉhse ni masiedahye. ");
INSERT INTO pirNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Sa ye apequina “Tiquiro Elia mʉnano yojopʉ bajuaro nine”, nimahye. Apequina pehe “Cohãcjʉ̃ yere yahu mʉhtariquina panopʉ cjẽna mehna cjʉ̃no yojopʉ masa bajuaro nine”, nimahye Jesure. ");
INSERT INTO pirNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Tiquina sa ni yahuducuepegʉ̃ta ohõ saha ni tʉhotuahye Herode: “Ñu dapure dʉte sure duti tuhasaʉ yʉhʉ. ¿Yojopʉre ijiriquiro masa tiquina yahuriquiro noa boro ijiboagari tiquiro pehe?” ni, tʉhoturo tiquiro Jesure ihña duamahye. ");
INSERT INTO pirNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Sa ye Jesu tiquiro ohoriquina tiquiro cahapʉ tojoa sa, tiquina yerire yahuahye Jesure. Tiquina yahu tuhasagʉ̃ Jesu tiquina dihitare Betsaida wame tiri macapʉ siho wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Tiquina waharire masiñe, masa peyequina tiquinare nʉnʉ tã cãa wahahye. Jesure tiquina ʉmʉ sagʉ̃ ihñano piti cahye Jesu tiquinare. Sa yero tiquiro Cohãcjʉ̃ pʉhtoro ijiyere tiquinare yahu, dohatiyequinare yʉhdʉgʉ̃ yeahye. ");
INSERT INTO pirNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ñamicahapʉ doce tiquiro buheyequina tiquiro cahapʉ esa, Jesure yahuahye: —‍Ohõ masa marienopʉ ijire. Ohõ majano cjẽ wʉhʉsepʉ ahriquina masare ohoya. Carĩato, tiquina ihyati gʉ̃hʉre maca dutiya tiquinare, niahye tiquina Jesure. ");
INSERT INTO pirNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","14","Tiquina sa nigʉ̃ Jesu yʉhtiahye tiquinare: —‍Sa niedacãhña. Ihyayere ohoya tiquinare, niahye. Tiquiro sa nigʉ̃ tʉhoye tiquina yʉhtiahye: —‍Ihcã omope paca pã paca, pʉaro wahi to punota cʉoaja mari. ¿Ahriquina peyequina masa tiquina ihyatire dúboagari ʉsã? niahye tiquiro buheyequina. Peyequina masa tiquina ijigʉ̃ ihñañe sa niahye tiquiro buheyequina. Topʉre cinco mil ʉmʉa ijiahye. Sa yero Jesu yahuahye tiquiro buheyequinare: —‍Cincuenta masare ihcã curua duji dutiya. Apeye cururi gʉ̃hʉre topequinata duji dutiya, niahye Jesu tiquiro buheyequinare. ");
INSERT INTO pirNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Tiquiro sa nigʉ̃ buheyequina tiquiro dutiriro sahata ye, ijipihtiyequina masare duji dutiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Duji duti tuhasa Jesu ihcã omope paca pã pacare pʉaro wahire ne, ʉhmʉanopʉ ihña mʉoahye. Sa ihña mʉono Cohãcjʉ̃re “Quehnoare”, niahye. Tiquiro sa nidi bato pã pacare nuha, tiquiro buheyequinare masare iti dutiro ohoahye. ");
INSERT INTO pirNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Sa ye tiquina ijipihtiyequina masa ihya, yapi yʉhdʉa wahahye. Tiquina yapi wehorire doce pʉhʉse ne cahmecoa wahpo dapoahye tiquiro buheyequina. ");
INSERT INTO pirNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ihcã deco Jesu ihcãquirota ijiro, Cohãcjʉ̃re sinino niahye. Tiquiro sinini watoa tiquiro buheyequina tiquiro cahapʉ esahye. Sa yero Jesu sinituahye tiquinare: —‍¿Noa boro ijiagari yʉhʉ, masa yʉhʉre tiquina tʉhotugʉ̃? ni sinituahye. Tiquiro sa sinitugʉ̃ tʉhoye tiquiro buheyequina yʉhtiahye: ");
INSERT INTO pirNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","—‍“Ñu wame yeriquiro ijire”, nine mʉhʉre. Apequina “Elia ijire”, nine. Apequina “Cohãcjʉ̃ yere yahu mʉhtariquina mehna cjʉ̃no panopʉ cjʉ̃no masa bajuaro nine yojopʉre”, nine, ni yʉhtiahye tiquiro buheyequina pehe tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Tiquina sa nidi bato Jesu tiquinare sinituahye tja: —‍¿Mʉsa pehe mʉsa tʉhotugʉ̃, noa boro ijiagari yʉhʉ? ni, sinituahye tja. —‍Mʉhʉ Cristo Cohãcjʉ̃ ohorigʉ ijire, ni yʉhtiahye Pedro. ");
INSERT INTO pirNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Sa ye Pedro “Cristo ijire mʉhʉ”, tiquiro nidire apequinare Jesu yahu site dutierahye tiquiro buheyequinare. ");
INSERT INTO pirNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Sa ni yahu site dutiera tuhasa ohõ saha ni nemoahye: —‍Yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ tutuaro ñano yʉhdʉta. Sata yʉhdʉro cahmene yʉhʉre. Sa ye mari judio masare buheyequina, bʉcʉna, pahia pʉhtoa mehna yʉhʉre cahmeda, yʉhʉre wejẽeta. Tiquina wejẽdi bato ihtia deco wahaboro masa wijiagʉtja, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Came ijipihtiyequinare ohõ saha ni yahuahye Jesu: —‍Ihcãquiro yaquiro iji duaro, tiquiro cahmeno ye duamedire duhu cãnota. Sa yero yaquiro tiquiro ijiri buhiri ñano yʉhdʉeperota yʉhʉre duhusi. Sa yero yeere yeducuriquiro ijirota. ");
INSERT INTO pirNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Masʉno yʉhʉre wacũno marieno tiquiro esa tuharo tiquiro cahmeno saha yero, pecapʉ waharota. Sa yero yeere sa yeducuriquiro ijipihtiye decori yʉhʉ mehna ʉhmʉsepʉ ijiducurota. ");
INSERT INTO pirNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Ihcãquiro masʉno ahri yehpa cjẽne ijipihtiyere cʉoriquiro Cohãcjʉ̃re cahmedaro pecapʉ waharo, yabere wapatajari tiquiro? Sa ijiriquiro ne wapataerare. ");
INSERT INTO pirNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ihquẽquina yʉhʉre, yʉhʉ buheye gʉ̃hʉre bʉe tisãboaga. Tiquina sa yegʉ̃ ihñagʉ yʉhʉ gʉ̃hʉ yʉhʉre sa yeyequinare bʉe tisãgʉtja. Yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ quehnoañequina angele mehna ʉsã asi siteropʉ, yʉhʉ Pacʉ tiquiro asi siteropʉ tojoa tagʉ tiquinare bʉe tisãgʉta. ");
INSERT INTO pirNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Poto niita niaja mʉsare. Yojopʉre ihquẽquina mʉsa ohõpʉre ijiyequina mʉsa yariato pano Cohãcjʉ̃ ijipihtiyequina bui pʉhtoro tiquiro iji dʉcagʉ̃ ihñanata mʉsa, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Sa ye ocho decori tire tiquiro yahuri bato Jesu Pedrore, Ñure, Santiagore tiquina dihitare pijiahye. Sa ye waha, Cohãcjʉ̃re siniñe waha, cʉnʉpʉ mʉjaa wahahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Cohãcjʉ̃re tiquiro sinini watoa Jesu ya wʉhdoa camesahye. Sa yero tiquiro suhtiro asi siteri suhtiro quehnoano yehseri suhtiro wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Tiquiro sa wahari watoa pʉaro ʉmʉa tiquiro mehna yahuducuye niahye. Yahuducuyequina pehe Elia mʉnano, Moise mʉnano gʉ̃hʉ ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Tiquina ʉhmʉse cjẽ asi siteye mehna bajuahye. Jesu camegãta Jerusalẽpʉ tiquiro yariatire tiquina Jesu mehna yahuducuye niahye. ");
INSERT INTO pirNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedro gʉ̃hʉre wʉjʉa purĩ yʉhdʉahye. Sa carĩepeta acʉa, wahcã wihi, Jesu tiquiro asi siteyere ihñañe, pʉaro tiquiro mehna ducuyequina gʉ̃hʉre ihñahye. ");
INSERT INTO pirNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Moise mʉnano gʉ̃hʉ tiquina wahato panogã Pedro Jesure ohõ saha nimahye: —‍Pʉhto, mari ohõre ijigʉ̃ quehnoa duare. Ihtia wʉhʉgã yenatja. Mʉhʉ ya wʉhʉgã, Moise ya wʉhʉgã, Elia ya wʉhʉgã yenatja, nimahye Pedro. Sa nieperota tiquiro nidire ne masiedahye. ");
INSERT INTO pirNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Tiquiro sa ni yahuducuri watoa tiquinare ehmeo curua cahmotahye. Sa cahmotagʉ̃ ihñañe tiquina cuea wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Sa yero ehmeo puhiapʉ yahuducuye bisiro ca tahye: —‍Ahriquiro yʉhʉ macʉ, yʉhʉ beseriquiro ijire. Quehnoano tʉhoya tiquirore, nino ca tahye ehmeo curua puhiapʉre. ");
INSERT INTO pirNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Tiquiro sa nidi bato Jesu dihitare ihñahye tiquina. Came tiquina ihñarire apequinare yahuerahye. Ne ihcãquirore yahuerahye. ");
INSERT INTO pirNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ape deco tiquina cʉnʉpʉ tiquina dijia tagʉ̃ peyequina masa Jesure piti cahye. ");
INSERT INTO pirNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Sa yero tiquina mehna cjʉ̃no Jesure pisuahye: —‍Buhegʉ, mʉhʉre tutuaro ahrire sini duaja yʉhʉ. Yʉhʉ macʉ ihcãquirota ijire. Sa yegʉ tiquirore ihña basaya mʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Watĩno tiquirore ñehe, sañuducu tunu nanaregʉ̃ ye, sahpo tua wahagʉ̃ yee tire. Sa yero watĩno yʉhʉ macʉre ñano yʉhdʉgʉ̃ ye, ne duhu duerare. ");
INSERT INTO pirNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mʉhʉ buheyequinare watĩnore cohã dutigʉ tutuaro sinimi. Yʉhʉ sa siniepegʉ̃ta tiquina tiquirore cohã masiedari, niahye tiquiro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Tiquiro sa nigʉ̃ Jesu pehe ohõ saha niahye tiquiro buheyequinare: —‍Yojopʉ cjẽna mʉsa ñana ijire. ¿Yʉhʉre ne wacũ tutuerabutiajari? Yoabutiari pje mʉsare buhemi yʉhʉ. ¿Noho puno yoari pje yʉhʉre mʉsa cariboboagari? ni tuhtiahye Jesu. Sa ni tuhasa watĩa cʉoriquiro pacʉrore ohõ saha niahye: —‍Mʉhʉ macʉre ne cãhtaya, niahye. ");
INSERT INTO pirNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Tiquiro sa nidi bato tiquiro macʉno Jesu cahapʉ tiquiro ahtari watoa watĩno pehe tiquirore yehpapʉ doque quehe sa, tunu nanaregʉ̃ yeahye. Tiquiro sa yegʉ̃ Jesu watĩnore waha dutiahye. Tiquiro sa dutigʉ̃ watĩnore cʉoriquirogã yʉhdʉa wahahye. Sa yero Jesu pehe tiquirogãre wiahye tiquiro pacʉrore. ");
INSERT INTO pirNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ijipihtiyequina masa Cohãcjʉ̃ tutuaye mehna tiquiro quehnoa wahagʉ̃ ihñañe, ihña maria wahahye. Masa Jesu tiquiro yerire tiquina ihña, ihña maria wahagʉ̃ Jesu pehe tiquiro buheyequinare ohõ saha ni yahuahye: ");
INSERT INTO pirNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—‍Mianogãta yʉhʉ yahuatire boeracãhña mʉsa. Yʉhʉre Cohãcjʉ̃ tiquiro ohorigʉre apequiro yʉhʉre ñehe dutiro ohorota masare, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Tiquiro sa niepegʉ̃ta tiquina pehe tiquiro yahuyere quehnoano tʉhoerahye. Tiquiro yahurire tiquinare masino basioerahye. Ti pjeta Cohãcjʉ̃ tiquinare tire tʉho dutiero niahye. Sa ye tiquina cueye, tire tiquirore sinituerahye. ");
INSERT INTO pirNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Came Jesu buheyequina cahme sehña soye niahye: —‍¿Mari mehna cjʉ̃no diquiro pehe pʉhtoro sajãnotari? niñe niahye tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Tiquina sa nigʉ̃ Jesu pehe tiquina tʉhotuyere masino, nijinogãre tiquiro cahapʉ ducu duti, tiquiro buheyequinare yahuahye: ");
INSERT INTO pirNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","—‍Yeere yena tana ahriquirogãre cahmena, yʉhʉ gʉ̃hʉre cahmene mʉsa. Sa yena yʉhʉre cahmena, yʉhʉre ohoriquiro gʉ̃hʉre cahmene mʉsa. Mʉsa mehna cjʉ̃no mʉsa cahacjʉ̃no ijiro tiquiro gʉ̃hʉ pʉhtoro ijirota, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Came Ñu Jesure ohõ saha ni yahuahye: —‍Buhegʉ, mʉhʉ wame mehna watĩare cohãriquirore ʉsã ihñaʉ. Mari mehna cjʉ̃no tiquiro ijieragʉ̃ ihñana tire tiquirore ye dutierʉ ʉsã, niahye Ñu Jesure. ");
INSERT INTO pirNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Tiquiro sa nigʉ̃ Jesu Ñure apequina buheyequina gʉ̃hʉre ohõ saha ni yahuahye: —‍Sa niedacãhña mʉsa tiquirore. Marine ihña tuhtiriquiro ijieraro, tiquiro mari mehna cjʉ̃no ijire, niahye Jesu tiquiro buheyequinare. ");
INSERT INTO pirNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ti pjere Jesu ʉhmʉsepʉ tiquiro wahato panogã, “Jerusalẽpʉ wahaʉtja”, niahye tiquiro. Sa nino topʉ waharo niahye. ");
INSERT INTO pirNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Sa ye Jesu tiquiro pano ohoriquina waha, Samaria yehpa cjã macapʉ esa, topʉ Jesu tiquiro ijiatire quehno duamahye. ");
INSERT INTO pirNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Jesu Jerusalẽpʉ waharo taro niahye. Topʉ wahatiquiro tiquiro ijigʉ̃ tʉhoye, to cjẽna tiquirore cahmedahye. ");
INSERT INTO pirNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Tire tʉhoye Santiago, Ñu mehna yahuahye Jesure: —‍Pʉhto, mʉhʉ cahmegʉ̃ ʉhmʉse cjã peca mehna tiquinare wejẽ dutinata, nimahye tiquina tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Tiquina sa nigʉ̃ Jesu majare ihña, tuhtiahye tiquina pʉarore. ");
INSERT INTO pirNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Sa tuhti tuhasa, ape macapʉ Jesu gʉ̃hʉ wahaa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ti mahapʉ tiquina wahagʉ̃, ihcãquiro Jesure yahuahye: —‍Mʉhʉ mehna waha duaja noho mʉhʉ waharopʉ, niahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Tiquiro sa ni tuhasagʉ̃ Jesu yʉhtiahye: —‍Ihquẽquina nʉcʉ cjẽna wahiquina tiquina coperi cʉore. Minicjʉa gʉ̃hʉ tiquina suhti cʉore. Yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ pehe yʉhʉ carĩni wʉhʉ cʉoeraja, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Came apequirore Jesu pijiahye: —‍Yʉhʉ mehna cjʉ̃ ijiacjʉ ahtaya, niahye. Tiquiro sa nigʉ̃ yʉhtiahye Jesure: —‍Pʉhto, yʉhʉ pacʉ tiquiro yariagʉ̃ yarĩgʉtja. Sa ya tuhasagʉ pũrita mʉhʉ mehna wahagʉtja, niahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Tiquiro sa nigʉ̃ Jesu yahuahye: —‍Yʉhʉre cahmeeñequina yariariquina yero saha ijire. Tiquina pehe yariariquinare yaahro. Sa yegʉ mʉhʉ pehe Cohãcjʉ̃ tiquiro pʉhtoro ijiyere quehnoañe buheyere buhegʉ ahtaya, niahye Jesu tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Sa yero apequiro Jesure ohõ saha niahye: —‍Pʉhto, mʉhʉ mehna wahaʉtja. Mʉhʉ mehna yʉhʉ wahato pano yʉhʉ acayere cohe tinii wahaʉtja, niahye tiquiro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Tiquiro sa nigʉ̃ Jesu yahuahye tiquirore: —‍Dahrariquiro dahra dueraro tiquiro dʉhseatiquiro ijierare. Tiquiro yero sahata ijiriquiro ohõ saha ijire: “Cohãcjʉ̃ yere ye duaja”, nieperota tire yerare. Tiquiro Cohãcjʉ̃ yaquiro ijiboriquiro ijierare, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Came Jesu apequina buheyequinare setenta y dos buheyequinare bese, macaripʉ tiquiro wahato pano ohoyuahye. Ti macarine pʉeyequina dihita ohoyuahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Sa ohoyuro ohõ saha ni yahuahye tiquinare queoye mehna buhero: —‍Trigo peye ti bʉcʉa tuhasagʉ̃ peye ijigʉ̃ dahraye pajiro ijire. Sa ijiepegʉ̃ta dahrayequina pehe meheñequinagã ijire. Sata quehnoañe buheyere tʉhoatiquina peyequina ijigʉ̃ pajiro ijire mari dahraye. Sa ijiepegʉ̃ta meheñequinagã dahrari masa yero sahata quehnoañe buheyere buheatiquina gʉ̃hʉ meheñequinagã ijire. Sa yena quehnoañe buheyere buheatiquinare apequinare tiquiro ohoatire siniña Cohãcjʉ̃re mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Wahaya mʉsa. Mʉsare yʉhʉ ohogʉ̃ mʉsa oveja pohne yayia watoa tiquina ijiro sahata mʉsa gʉ̃hʉ ñañequina usuayequina watoa ijinata. ");
INSERT INTO pirNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Niñeru ajurore, paji cjũri ajuro gʉ̃hʉre, dahpo suhtire nedacãhña. Mʉsa mahapʉ tinina apequinare boca sa yahuducueracãhña. Poto wahaya. ");
INSERT INTO pirNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ijipihtiye mʉsa sajãñe wʉhʉsepʉ sajãna, “Ahri wʉhʉ cjẽna quehnoano ijiahro”, ni mʉhtaña. ");
INSERT INTO pirNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ti wʉhʉ cjẽna quehnoano mehna ijiyequina cahmequeno marieñequina tiquina ijigʉ̃, tire niña tiquinare. Quehnoano mehna tiquina ijieragʉ̃ ihñana ti wʉhʉ cjẽnare sa niedacãhña. ");
INSERT INTO pirNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ihcã wʉhʉpʉ sajã sadʉcana tiquina quehnoañequina ijigʉ̃ ti wʉhʉpʉta tojoaya. Topʉ tiquina duhu peorire ihya, sihniña. Dahrayequinare tiquina wapatayere neno cahmene. Sa yena tiquina wapatayere tiquina neno sahata tiquina duhu peorire neña mʉsa gʉ̃hʉ. Sa yena ihcã wʉhʉpʉta mʉsa esari wʉhʉpʉta ijina, ti maca cjẽ wʉhʉsepʉ carĩ tiniedacãhña. ");
INSERT INTO pirNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Macapʉre mʉsa esana to cjẽna pehe mʉsare tiquina cahmeñequina ijigʉ̃ ti ihyayere tiquina duhu peorire ihyaya. ");
INSERT INTO pirNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","To cjẽna dohatiyequinare yʉhdʉoya. Sa yena ohõ saha niña to cjẽnare: “Cohãcjʉ̃ yojopʉre mari pʉhtoro tiquiro ijiati mehenogã dʉhsare”, niña tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ape macapʉ mʉsa esagʉ̃ tiquina pehe mʉsare cahmedaboaga. Tiquina cahmedagʉ̃ ihñana ti maca decopʉ waha, ohõ saha niña tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Ahri maca cjẽ dihtare dahpocãri cjẽ dihtare wejẽ site cohãna niaja ʉsãre mʉsa cahmedari buhiri ihñona. Sa yena ahrire wacũña. Cohãcjʉ̃ mari pʉhtoro yojopʉre tiquiro ijiati mehenogã dʉhsare”, niña tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mʉsare poto niita niaja. Sodoma cjẽna ña yʉhdʉayequina ijiahye. Tiquina sa ijiepegʉ̃ta pihtiati deco ijigʉ̃ Cohãcjʉ̃ tiquiro buhiri dahreati deco ijigʉ̃ Sodoma cjẽna yʉhdʉoro mʉsare cahmeeñequina pehere buhiri dahrerota, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Came Jesu ohõ saha niahye macari cjẽnare: —‍Corazín cjãna, mʉsa ñano yʉhdʉnata. Betsaida cjãna, mʉsa gʉ̃hʉ ñano yʉhdʉnata. Mʉsa ye macaripʉre Cohãcjʉ̃ tutuaye mehna ye ihñomi. Tiro wame tiri macare, Sidõ wame tiri maca gʉ̃hʉre tiquiro tutuaye mehna yʉhʉ ye ihñogʉ̃ ihñañe panopʉ to cjẽna pehe tiquina ñañene bʉjʉa witiboaga. Sa ye quehnoañene camesaboaga. Duita tiquina masa dija suhtire saña, tiquina basi peca cjẽ nujuare tiquina bui dahra site peoboaga tiquina ñañene bʉjʉa witiyere ihñoñe. ");
INSERT INTO pirNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Cohãcjʉ̃ tiquiro buhiri dahreati deco ijigʉ̃ Tiro cjẽna, Sidõ cjẽna yʉhdʉoro mʉsa pehere mʉsa ñari buhiri mʉsare tutuaro buhiri dahrerota tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Capernau cjãna, mʉsa esa tuharo ʉhmʉsepʉ waha duamene. Mʉsa sa waha duepegʉ̃ta mʉsa ñari buhiri mʉsare Cohãcjʉ̃ pecapʉ cohãnota, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Sa ni tuhasa Jesu tiquiro buheyequinare yahuahye: —‍Mʉsare tʉhoyequina yʉhʉ gʉ̃hʉre tʉhore. Mʉsare cahmeeñequina, yʉhʉ gʉ̃hʉre cahmedare. Sa yeye yʉhʉre cahmeeñequina, tiquina yʉhʉre ohoriquiro gʉ̃hʉre cahmedare, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Came setenta y dos buheyequina bucueye mehna tojoa wihiahye: —‍Pʉhto, mʉhʉ wame mehna mʉhʉ tutuaye mehna watĩare ʉsã dutigʉ̃ tiquina pehe ʉsãre yʉhdʉdʉcaerare, niahye tiquina Jesure. ");
INSERT INTO pirNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Tiquina sa nigʉ̃ Jesu yʉhtiahye tiquinare: —‍Ʉhmʉsepʉ mia sitedoque dijioro sahata, watĩno tiquiro bora dijia tagʉ̃ ihñaʉ. ");
INSERT INTO pirNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Quehnoano tʉhoya. Mʉsare yʉhʉ tutuayere ohou yʉhʉ. Sa yegʉ añaa parire, cutipa parire, watĩnore marine ihña tuhtiriquirore mʉsa yʉhdʉdʉcatire ohou yʉhʉ. Sa ye tiquina mʉsare ñano ye masiedare. ");
INSERT INTO pirNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Yʉhʉ sa ohoepegʉ̃ta watĩa mʉsare tiquina yʉhdʉdʉcaeragʉ̃ ihñana ti dihitare bucueracãhña. Ahri pehere bucueya. Ʉhmʉsepʉ Cohãcjʉ̃ yequina tiquina wamene tiquiro ojoa ohõri tjupʉ mʉsa wamene tiquiro ojoa ohõgʉ̃ ihñana, ti pehere bucueya mʉsa, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ti pjere Espíritu Santo Jesure tutuaro bucuegʉ̃ yeahye. Sa yero Jesu ohõ saha niahye: —‍Mai, mʉhʉ ʉhmʉsepʉ gʉ̃hʉre yehpapʉ gʉ̃hʉre pʉhto ijire. Masi yʉhdʉdʉcayequinare mʉhʉ yahuerarire ihyo ijiyequina pehere yahuri mʉhʉ. Mʉhʉ sa yegʉ̃ ihñagʉ “Quehnoa yʉhdʉare”, niaja. Sata ijire mai. Mʉhʉ ye duariro sahata, mʉhʉ cahmediro sahata tiquinare mʉhʉ yere yahuri mʉhʉ, niahye Jesu. Sa ni tuhasa apequinare ohõ saha niahye: ");
INSERT INTO pirNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","—‍Yʉhʉ Pacʉ ijipihtiyere yʉhʉre ohori. Yʉhʉ Pacʉ dihita yʉhʉre masine. Yʉhʉ gʉ̃hʉ tiquirore masiaja. Yʉhʉ beseriquina gʉ̃hʉ tiquirore masine, yʉhʉ masi dutiyequina ijiye. Topequinata yʉhʉ Pacʉre masiaja ʉsã, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Tiquiro sa nidi bato tiquina sehsaro ijigʉ̃ Jesu tiquiro buheyequinare ohõ saha niahye: —‍Ahri ijipihtiyere mʉsa ihñana bucuena ijire. ");
INSERT INTO pirNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ijirota ijire. Peyequina Cohãcjʉ̃ yere yahu mʉhtariquina, ihquẽ yehpari cjẽna pʉhtoa gʉ̃hʉ yojopʉ mʉsa ihñarire ihña duamahye tiquina gʉ̃hʉ. Sa ye mʉsa tʉhori gʉ̃hʉre tʉho duamahye, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ti pjeta judio masare buheriquiro Jesu cahapʉ wihi, Jesure tiquiro ñano yahuducugʉ̃ ye duamahye: —‍¿Buhegʉ, yʉhʉ ijipihtiye decori Cohãcjʉ̃ mehna iji duagʉ dʉhse yeboagari yʉhʉ? ni, sinituahye tiquiro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Tiquiro sa nigʉ̃ Jesu yʉhtiahye tiquirore: —‍¿Dʉhse ni yahuajari Cohãcjʉ̃ yere tiquina ojoari pũpʉ? ¿Cohãcjʉ̃ tiquiro ni ojoarire dʉhse ni tʉhotuajari mʉhʉ? niahye Jesu tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Jesu sa nigʉ̃ tiquiro yʉhtiahye: —‍Ohõ saha niahye Cohãcjʉ̃: “Tutuaro mʉsa jeripohnari mehna, quehnoano mʉsa tutuaye mehna, mʉsa wacũñe mehna Cohãcjʉ̃re cahĩña. Sa ye mʉhʉ basi mʉhʉ cahĩno saha mʉhʉ cahapʉ ijiyequina gʉ̃hʉre cahĩña”, niahye tiquiro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Tiquiro sa nigʉ̃ Jesu yʉhtiahye: —‍Potota nine mʉhʉ. Tire yeya. Sa yegʉ ijipihtiye decori Cohãcjʉ̃ mehna ijigʉta mʉhʉ, niahye tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","“Ahriquiro Cohãcjʉ̃ dutiyere ye pehoriquiro ijire”, masa tiquirore tiquina ni ihñagʉ̃ cahmeahye judio masare buheriquiro. Sa cahmeno tiquiro Jesure ohõ saha ni sinituahye: —‍¿Noa boro ijiboagari yʉhʉre mʉhʉ cahĩ dutiriquiro? niahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Tiquiro sa nigʉ̃ Jesu ohõ saha ni queoye mehna piti dahre buheahye: —‍Ihcã deco Jerusalẽpʉ ahtariquiro Jericópʉ wahariquirore mahapʉ tiquiro tinigʉ̃ yaqueyequina tiquirore ñeheahye. Sa ñeheñe, tiquiro suhtirore tu we ne, tiquirore tutuaro quẽahye. Sa tutuaro quẽ, tiquiro yariaro taro yegʉ̃ duhuahye tiquina tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ti pjeta pahi ti mahapʉ ahtahye. Sa ahtaro tiquina quẽdiquirore ihñaeperota maha ape sie dʉhtʉ cahapʉ yʉhdʉ cãa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Sa ye Cohãcjʉ̃ wʉhʉpʉ dahrariquiro gʉ̃hʉ pejecʉoriquiro cahapʉ esa, tiquirore ihña, maha ape siepʉ yʉhdʉ cãa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Sa ye Samaria cjʉ̃no pehe topʉ waha, yoa cjũnopʉ pejecʉoriquirore ihña, tiquirore paja ihñahye. ");
INSERT INTO pirNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Sa yero tiquiro pejecʉoriquiro cahapʉ esa, ʉhse, vino mehna moredire tiquiro camine pio peoahye. Pio peo tuhasa suhtiro cahsero mehna dʉhteahye tiquiro camine. Tuhasa, pejecʉoriquirore tiquiro yaquiro burro bui duhu peo, carĩni wʉhʉpʉ ne cãhye tiquirore. Topʉ ijiro, Samaria cjʉ̃no quehnoano ihña ihboahye tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ape deco tiquiro carĩni wʉhʉ upʉrore pʉa cjoe niñeru cjoerire oho, ohõ saha niahye: “Ahriquirore ihña ihboya. Ahri esa tuhaeragʉ̃ pari turi tojoa tagʉ wapa ye pehoutja”, niahye Samaria cjʉ̃no wʉhʉ upʉrore, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Sa ni tuhasa judio masare buheriquirore sinituahye Jesu: —‍¿Ahriquina ihtiaro ʉmʉa diquiro pehe ijiajari pejecʉoriquirore cahĩdiquiro? niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Tiquiro sa nigʉ̃ tʉhoro buheriquiro pehe Jesure yʉhtiahye: —‍Pejecʉoriquirore yedohoriquiro ijiaga tiquirore cahĩdiquiro, niahye tiquiro Jesure. —‍Wahaya. Mʉhʉ gʉ̃hʉ masare sata yei wahaya, niahye Jesu buheriquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Sa ye Jesu tiquiro buheyequina mehna tiquina wahagʉ̃, ape macapʉ tiquina tinigʉ̃, Marta wame tiricoro tiquinare ticoro ya wʉhʉpʉ sajã ta dutiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ticoro bahoro María tiquiro dahpocãri cahapʉ duji, tiquiro buheyere tʉhoahye. ");
INSERT INTO pirNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ticoro sa yegʉ̃ ihñano Marta ticoro dahraye peye ijigʉ̃ usuahye. Sa yero ticoro Jesure yahuahye: —‍¿Pʉhto, yʉhʉ ihcõta dahragʉ̃ yʉhʉre yʉhʉ baho ticoro yedohoeragʉ̃ mʉhʉre quehnoajari, mʉhʉ ihñagʉ̃? Ticorore yʉhʉre yedoho dutiya, niahye Marta Jesure. ");
INSERT INTO pirNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ticoro sa nigʉ̃ Jesu yʉhtiahye: —‍Marta, dahraye peye cʉogo pajiro tʉhoture mʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Cohãcjʉ̃ tiquiro yere tʉho dutire. María quehnoañene yero taro, tire cahmene. Sa yegʉ yʉhʉre ticoro tʉhogʉ̃ “Yedohogo wahaya”, niedaja ticorore, niahye Jesu Martare. ");
INSERT INTO pirNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ihcã deco Jesu Cohãcjʉ̃re sinino niahye. Tiquiro sini tuhasagʉ̃, ihcãquiro tiquiro buheyequina mehna cjʉ̃no tiquirore ohõ saha niahye: —‍Pʉhto, Ñu tiquiro buheyequinare tiquiro buheriro sahata Cohãcjʉ̃re siniñene ʉsã gʉ̃hʉre buheya mʉhʉ, niahye tiquiro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Tiquiro sa nigʉ̃ tʉhoro Jesu tiquinare yahuahye: —‍Ohõ saha Cohãcjʉ̃re siniña: “Ʉsã Pacʉ, ʉhmʉse cjʉ̃ mʉhʉ quehnoagʉ sa ijiducure. Yojopʉre ijipihtiyequina pʉhto ijiya. ");
INSERT INTO pirNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Sa yegʉ decoripe ʉsã ihyatire ohoducuya ʉsãre. ");
INSERT INTO pirNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Apequina ʉsãre tiquina ñañe yerire ʉsã boaja. Sa yegʉ mʉhʉ gʉ̃hʉ ʉsã ñañe yerire boya. Sa yegʉ ʉsã ñañene ye duagʉ̃ ʉsã tutuaro cahmegʉ̃ ihñagʉ tire ʉsãre ye dutiegʉta”, ni siniña Cohãcjʉ̃re, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Came Jesu quiti mehna tiquiro buheyequinare ohõ saha ni buheahye: —‍Ihcãquiro ñami decopʉ tiquiro acayʉro ya wʉhʉpʉ waha, tiquirore siniahye: “Yʉhʉ acayʉ, ihtiaria pã pacare ohoya yʉhʉre. ");
INSERT INTO pirNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Apequiro yʉhʉ acayʉro tinino ahtariquiro mianogãta ya wʉhʉpʉ wihiri. Sa yegʉ tiquirore yʉhʉ nuati mariedare”, niahye tiquiro acayʉrore. ");
INSERT INTO pirNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Tiquiro sa nigʉ̃ tiquiro acayʉro wʉhʉ puhiapʉ ijiriquiro yʉhtiahye: “Yʉhʉre cariboeracãhña. Sopecaha bihariro ijire. Yʉhʉ, yʉhʉ pohna mehna carĩna niaja. Wahcãno pjeraga yʉhʉre mʉhʉre ihyayere ohoborigʉ”, niahye tiquiro acayʉro. ");
INSERT INTO pirNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","¿Dʉhse waharotari sinidiquirore? Poto niaja mʉsare. Tiquiro acayʉro ijieperota, ihyaye ohoboriquiro wahcã duerahye. Tiquiro wahcã duerapegʉ̃ta ihyaye sinidiquiro pehe bʉe tiro marieno tiquiro yoari pje siniducugʉ̃ ijipihtiye tiquiro sinidiro sahata ohorota. ");
INSERT INTO pirNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Sa yegʉ ahrire mʉsare ni yahugʉ niaja: Cohãcjʉ̃re siniña. Sa sinina mʉsa nenata. Mʉsa sinidire bocanata. Tiquirore sa siniducuya. Mʉsa sa yegʉ̃ tiquiro ohorota. ");
INSERT INTO pirNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ijipihtiyequina Cohãcjʉ̃re siniñequina neeta. Sa ye tiquina sinidire bocaeta. Sa yero ijipihtiyequina Cohãcjʉ̃re sa siniducuyequinare tiquiro tiquinare ohorota. ");
INSERT INTO pirNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’¿Mʉsa pohna mʉsare wahire tiquina sinigʉ̃ añare ohoboagari mʉsa tiquinare? ");
INSERT INTO pirNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿Mʉsa pohna canaca dʉere tiquina sinigʉ̃ cutipare ohoboagari mʉsa tiquinare? Ne ohosi. ");
INSERT INTO pirNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mʉsa ñana ijiepenata mʉsa pohnare quehnoañene ohoe tiri mʉsa. Sa yero Cohãcjʉ̃ pehe mʉsa ohori yʉhdʉoro quehnoañene ohore mʉsare. Tiquiro mari Pacʉ ʉhmʉse cjʉ̃no Espíritu Santore ohorota tiquirore siniñequinare, niahye Jesu tiquiro buheyequinare. ");
INSERT INTO pirNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ti pjere Jesu watĩnore cohãno niahye. Watĩno pehe yahuducu masiedagʉ̃ yeahye masʉnore. Sa yero watĩno masʉnore tiquiro duhuri bato masʉno pehe yahuducu dʉcahye. Tiquiro yahuducugʉ̃ tʉhoye masa peyequina tʉho maria wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Tiquina sa tʉho mariepegʉ̃ta apequina pehe ohõ saha niahye: —‍Ahriquiro Jesu watĩare tiquiro cohãgʉ̃ Beelzebú wame tiriquiro watĩa pʉhtoro pehe tiquirore yedohore, niahye apequina. ");
INSERT INTO pirNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Apequina “¿Jesu Cohãcjʉ̃ tiquiro ohoriquiro ijiajari?” ni masi duaye tiquirore Cohãcjʉ̃ tutuaye mehna ye ihño dutimahye. ");
INSERT INTO pirNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Tiquina sa dutigʉ̃ tʉhoro “Watĩno tutuaye mehna watĩare cohãre”, ni, tiquina tʉhotuyere masino, tiquinare ohõ saha ni yahuahye Jesu, “Watĩno ye tutuaye mehna watĩare cohãgʉ niedaja”, nino taro: —‍Ihcã yehpa cjẽna tiquina basi cahmequeñe, ti yehpa cjẽna yaria pihtia wahaboaga. Sa ye ihcã wʉhʉ cjẽna tiquina basi cahmequeñe, ti wʉhʉ cjẽna waha pihtia wahaboaga. ");
INSERT INTO pirNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Sa ye, watĩno yequina watĩa tiquina basi cahmequeñe, tiquina watĩa gʉ̃hʉ waha pihtia wahaboaga. Ihcã curua iji masiedaboaga. Mʉsa yʉhʉre ohõ saha nine. “Tiquiro watĩno tutuaye mehna watĩare cohãre”, mʉsa yʉhʉre nina niaga. ");
INSERT INTO pirNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","¿Yʉhʉre mʉsa nidi poto ijigʉ̃ mʉsa mehna cjẽna watĩare cohãñe watĩno tutuaye mehnata cohãjari tiquina gʉ̃hʉ, mʉsa ihñagʉ̃? Mʉsa mehna cjẽna watĩare cohãñe, watĩno tutuaye mehna cohãñe niedare. Ahrire masina watĩno tiquiro tutuaye mehna watĩare yʉhʉ cohãedagʉ̃ masinata mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Sa yegʉ yʉhʉ pehe watĩare cohãgʉ Cohãcjʉ̃ tutuaye mehna cohãja. Ahrire masina, Cohãcjʉ̃ tiquiro pʉhtoro iji dʉcayere masinata mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Tutuariquiro tiquiro ye wamoa mehna tiquiro ya wʉhʉre tiquiro ihña ihbogʉ̃ tiquiro yere apequina yaque masiedare. ");
INSERT INTO pirNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Tiquiro sa ihña ihboepegʉ̃ta apequiro tutua yʉhdʉriquiro tiquiro mehna cahmeque, tiquirore yʉhdʉdʉca, tiquiro ye wamoare ehma cã, tiquiro yere ehma cãhre. Ohõ sahata ye yʉhdʉdʉcaro cahmene watĩare. ");
INSERT INTO pirNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ihcãquiro yʉhʉre cahmedaro, yʉhʉre ihña tuhtiriquiro ijire. Ihcãquiro yʉhʉre yedohoeraro yʉhʉre ñano yero nine, ni buheahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Sa yero tiquiro tʉhotuye mehna ohõ saha ni queoye mehna buheahye tiquinare: —‍Watĩno masʉno mehna ijiriquiro waha, tiquiro aco marieni yehpapʉ tinino, tiquiro ijiatore macamahye. Bocaeraro, ohõ saha ni tʉhotuahye: “Masʉno yʉhʉ duhuriquiro mehna pari turi ijigʉ wahaʉtja”, ni, tʉhotuahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Sa nino tiquiro tojoa waha, masʉnore bocahye. Sa tiquiro bocagʉ̃ masʉno pehe quehnoariquiro ijimahye. ");
INSERT INTO pirNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Sa yero watĩno apequina siete watĩare tiquiro yʉhdʉoro ñañequinare pijiro wahahye. Tiquiro sa pijigʉ̃ tiquina ijipihtiyequina watĩa masʉno mehna ijiahye. Sa yero masʉno pehe to pano ihcãquiro watĩnore cʉoro, ñariquiro ijimahye. Camepʉ pehere peyequina watĩare cʉoriquiro ijiro, to pano tiquiro ijiriro yʉhdʉoro ña yʉhdʉariquiro ijiahye, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Tire tiquiro sa nigʉ̃ masa watoa ijiricoro numino Jesure yahuahye: —‍Mʉhʉre pohna tiricoro, mʉhʉre apũoricoro bucuericoro ijire, niahye Jesure. ");
INSERT INTO pirNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ticoro sa ni tuhasagʉ̃ tʉhoro Jesu ticorore yʉhtiahye: —‍Cohãcjʉ̃ yahuducuyere tʉhoyequina tiquiro dutiyere yeyequina tiquinata ijiaga bucueyequina, niahye Jesu ticorore. ");
INSERT INTO pirNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Sa ye peyequina masa Jesu cahapʉ tiquina wihigʉ̃, tiquiro tiquinare yahu nemoahye: —‍Yojopʉ cjẽna ñañequina ijire. Yʉhʉre poto nigʉ yʉhʉ ijiyere tiquina masi duaye, Cohãcjʉ̃ tutuaye mehna yʉhʉ ye ihñogʉ̃ ihña duamene. Tiquina sa ihña duepegʉ̃ta Jona panopʉ cjʉ̃no Cohãcjʉ̃ tutuaye mehna tiquiro yeri dihitare ihñonota Cohãcjʉ̃ tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jona Cohãcjʉ̃ yere yahu mʉhtariquiro ijiro, tiquiro Nínive wame tiri maca cjẽnare Cohãcjʉ̃ yere tiquiro masigʉ̃ yeriro sahata yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ masigʉ̃ yeaja yojopʉ cjẽnare. ");
INSERT INTO pirNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Buhiri dahreati deco ijigʉ̃ pʉhtoro sur cjõno panopʉ cjõno ducu, yojopʉ cjẽnare “Ñana ijire mʉsa”, ni, yahusãnota ticoro. Ticoro Salomo panopʉ cjʉ̃no tiquiro masiñene tʉho duaro yoaropʉ ahri yehpa ape siepʉ ijiricoro Salomore tʉhoro ahtahye. Sa yero quehnoano yero niahye yojopʉ cjẽna yʉhdʉoro. Sa yero ticoro yahusãnota yojopʉ cjẽnare. Sa nigʉ mʉsare poto niita niaja. Yojopʉ mʉsare yʉhʉ buheye Salomo tiquiro buheri yʉhdʉoro ijire. ");
INSERT INTO pirNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Buhiri dahreati deco ijigʉ̃ Nínive wame tiri maca cjẽna gʉ̃hʉ ducu, yojopʉ cjẽnare “Ñana ijire mʉsa”, ni yahusãeta tiquina. Jona tiquinare Cohãcjʉ̃ yere tiquiro yahugʉ̃ tʉhoye, tiquina ñañene bʉjʉa witi, quehnoañene cahmeahye tiquina pehe. Sa cahmeñe quehnoano yeye niahye yojopʉ cjẽna yʉhdʉoro. Sa ye tiquina gʉ̃hʉ yojopʉ cjẽnare “Ñana ijire mʉsa”, ni yahusãeta. Mʉsare poto niita niaja. Yojopʉ mʉsare yʉhʉ buheye Jona tiquiro buheri yʉhdʉoro ijire, ni yahuahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Sa yero queoye mehna buhero ohõ saha ni yahu nemoahye tiquinare: —‍Masa sihãriare sihãñe nʉoedare. Tiare sihãñe dihi sutu docapʉ duhu dapoerare. Tiare ʉhmʉsepʉ duhu peore wʉhʉpʉ sajã tayequina tiquina quehnoano ihña sajã tatore yeye. ");
INSERT INTO pirNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Sihãria quehnoano buhriogʉ̃ mari quehnoano ihña masino sahata quehnoañene tʉhotuye mehna quehnoano ye masinata mʉsa. Mʉsa tʉhoturo sahata yere mʉsa. Quehnoañene tʉhotuna quehnoano yere mʉsa. Quehnoañene tʉhotuerana ñañe pehere yere mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Sa yena quehnoano yeya. Mʉsa tʉhotuyepʉ ñañene wacũedacãhña. Ñañene ne cahmedacãhña. ");
INSERT INTO pirNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tuhasa mʉsa tʉhotuyepʉ quehnoañe ijigʉ̃, ñañe ne mariedagʉ̃ quehnoañe dihitare tʉhotunata, ni buheahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesu tiquiro buhe tuhasagʉ̃ ihña, fariseo masʉno tiquirore tiquiro ya wʉhʉpʉ ihya dutiro pijiahye. Sa yero Jesu tiquiro ya wʉhʉpʉ sajã sa, tiquina ihyaropʉ tiquina mehna nuju sahye. ");
INSERT INTO pirNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Tiquiro sa nuju sagʉ̃ fariseo masʉno pehe Jesure ihña nʉnʉno judio masa tiquina omo coseducuro sahata tiquiro omo coseragʉ̃ ihñano ohõ saha ni tʉhotuahye: “Yohou. ¿Ahriquiro dʉhsero omo coserajari ʉsã yero saha?” ni tʉhotuahye. ");
INSERT INTO pirNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Tiquiro sa ni tʉhotugʉ̃ masino Jesu tiquirore yahuahye: —‍Mʉsa fariseo masa sihniñe parire, wapari gʉ̃hʉre bui pehe dihitare mʉsa cosero sahata quehnoañene ye ihñore mʉsa buigã warona. Sa yepenata Cohãcjʉ̃ yere queoro yerare. Apequina yere ehma mʉjare mʉsa. Sa yena ñañe dihitare tʉhoture mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Tʉho masiedare mʉsa. Cohãcjʉ̃ mʉsa pagʉrire yeriquiro mʉsa tʉho masiñe gʉ̃hʉre yeahye. ¿Tire masiedajari mʉsa? ");
INSERT INTO pirNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Sa yena mʉsa yere pejecʉoyequinare ohoya mʉsa. Mʉsa sa yena quehnoañene tʉhotuna ijinata. ");
INSERT INTO pirNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’Mʉsa fariseo masa ñano yʉhdʉnata. Moa yero saha ijiyere ihyayere ocagʉ̃ yeyere cʉona mehenogã ohomene mʉsa. Cohãcjʉ̃re ño peona tana pahiare ohomene mʉsa. Sa ohoepenata quehnoañene yerare mʉsa. Sa yena masare paja ihñedare mʉsa. Sa yena Cohãcjʉ̃re ño peoerare mʉsa. Oteye dʉcagãre mʉsa nedire mehenogã Cohãcjʉ̃re mʉsa ohogʉ̃ quehnoarĩne. Sa ohona ohõ saha ye nemoña: Quehnoañene yeya. Sa yena paja ihñaña masare. Sa yena Cohãcjʉ̃re ño peoya mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’Mʉsa fariseo masa ñano yʉhdʉnata. Buheri wʉhʉpʉ ijina, quehnoañe dujiye dihitare duji duare mʉsa. Doeri cjẽ duaropʉ apequina pʉhtoare quehnoano ño peo tiquina sinino saha mʉsare piti cagʉ̃ cahmene mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’Ñano yʉhdʉnata mʉsa. Masa cope nʉori cope yero saha ijire mʉsa. Ti cope cahagã masa ijiye, puhiapʉ cjʉ̃no ahbariquirore ihñedare tiquina. (Sata masa mʉsa cahagã ijiye, mʉsa tʉhotuyepʉre ñañe ijiyere masiedare tiquina,) niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Tiquiro sa nigʉ̃ tʉhoro judio masare buheyequina mehna cjʉ̃no Jesure yahuahye: —‍Buhegʉ, tire nigʉ ʉsã gʉ̃hʉre ñano nii niaga mʉhʉ, niahye tiquiro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Tiquiro sa nigʉ̃ Jesu yʉhtiahye: —‍Ijirota ijire. Judio masare buhena mʉsa gʉ̃hʉ ñano yʉhdʉnata. Mʉsa apequinare tiquina ye masiedarire ye dutire mʉsa tiquinare. Sa ye dutiepenata mʉsa pehe tiquinare ne mehenogã yedohoerare ti dutiyere tiquina yeati pehere. ");
INSERT INTO pirNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’Sa yena mʉsa ñano yʉhdʉnata. Cohãcjʉ̃ yere yahu mʉhtariquina panopʉ cjẽna tiquina masa coperire quehnoano quehnomene mʉsa tiquinare ño peoro saha yena. Mʉsa sa yepegʉ̃ta panopʉ cjẽna mʉsa acaye pehe tiquinare wejẽahye. ");
INSERT INTO pirNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Mʉsa acaye panopʉ cjẽna pehe Cohãcjʉ̃ yere yahu mʉhtariquinare tiquina wejẽdiro sahata mʉsa gʉ̃hʉ yeboaga. Sa yena yojopʉre ti masa coperire quehnomene mʉsa. Sa quehnona mʉsa acaye tiquinare tiquina wejẽdire wacũre mʉsa. Sa tiquina wejõrire wacũna “Quehnoa cãhre”, ni wacũre mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Cohãcjʉ̃ tiquiro masiñe mehna ohõ saha ni yahuahye: “Yeere yahu mʉhtariquina gʉ̃hʉre yʉhʉ buhe duti cũriquina gʉ̃hʉre ohoutja tiquinare. Sa yeye tiquina yʉhʉ ohoriquinare apequinare wejẽ, apequinare ñano yeeta”, niahye Cohãcjʉ̃. ");
INSERT INTO pirNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Ahri yehpare Cohãcjʉ̃ tiquiro bajumehnedi bato Caĩ pehe Abere wejẽahye. Sa ye Cohãcjʉ̃ yere yahu mʉhtariquinare Abe bato ijiyequina gʉ̃hʉre ñañequina wejẽahye. Came Zacariare Cohãcjʉ̃ wʉhʉpʉ Cohãcjʉ̃re ño peori altar cahapʉ mʉsa acaye wejẽahye. Ijipihtiyequina tiquinare tiquina wejẽdi buhiri yojopʉ cjẽnare Cohãcjʉ̃ buhiri dahrerota. Sata ijire. Mʉsare nigʉta niaja. Ijipihtiyequina tiquinare tiquina wejẽdi buhirire yojopʉ cjẽnare Cohãcjʉ̃ buhiri dahrerota. ");
INSERT INTO pirNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’Mʉsa judio masare buhena, mʉsa ñano yʉhdʉnata. Cohãcjʉ̃ masiñene tiquina ojoari pũrine cʉoepenata apequinare yahuerare mʉsa. Mʉsa basi Cohãcjʉ̃ yere tʉhoerare. Sa yena apequina tiquiro yere tiquina tʉho duepegʉ̃ta tire mʉsa tiquinare tʉho dutierare, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Tiquiro sa nigʉ̃ tʉhoye judio masare buheyequina, fariseo masa gʉ̃hʉ tiquiro mehna usua, tiquirore ñano yahuducuahye. Sa ye Jesu tiquiro ñano yʉhtigʉ̃ tʉho duaye, tiquina peye ni meho cũ sinitumahye tiquirore, tiquirore yahusã duaye. ");
INSERT INTO pirNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Sa ye Jesu cahapʉ masa peyequina cahmecoa, wahpa yʉhdʉahye. Topʉ Jesu tiquiro buheyequinare ohõ saha ni yahu dʉcahye: —‍Quehnoano wacũ masiña mʉsa. Fariseo masa tiquina ye pãre pugʉ̃ yeyere ihñana quehnoano wacũ masiña. Tiquina ni mehoducurire nigʉ niaja “Pãre pugʉ̃ yeye”, nigʉ. ");
INSERT INTO pirNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ijipihtiye apequina tiquina masiedarire came masieta. ");
INSERT INTO pirNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Sa yero ñamipʉre tiquina nʉo yahuducurire buhrioropʉ bajugʉ̃ yero sahata Cohãcjʉ̃ yahurota. Bihari tucũpʉ apequirore cahmono caha tiquina nidire masa peyequina watoa yahurota Cohãcjʉ̃, ni yahuahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Sa yero Jesu yahu nemoahye tiquinare: —‍Poto niita niaja mʉsare. Masare wejẽñequina wejẽ tuhasa pari turi tiquina wejõriquina mʉnare ñano ye nemo masiedare. Sa yena mʉsare wejẽ duayequinare cueracãhña. ");
INSERT INTO pirNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Yojopʉre mʉsa cueatiquirore mʉsa ño peoatiquirore yahutja. Cohãcjʉ̃ pehere cue, ño peoya. Tiquiro mʉsa yariari bato pecapʉ cohã masine mʉsare. Sata ijire. Poto nigʉ niaja. Cohãcjʉ̃ pehere cue, ño peoya. ");
INSERT INTO pirNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Ihcã omopequina siripia wapa mariedare. Sa wapa mariedapegʉ̃ta ihcãquirogãre Cohãcjʉ̃ ne boerare. ");
INSERT INTO pirNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Sa yero mʉsa poarire ne ihcã poa da dʉhsaro marieno masi pehore Cohãcjʉ̃. Sata mʉsa ijiye tiye gʉ̃hʉre masi pehore Cohãcjʉ̃. Sa masino mʉsare ihña ihboducure. Siripia yʉhdʉoro Cohãcjʉ̃ cahĩne mʉsa pehere. Sa yena tiquirore ño peona, cueracãhña mʉsa, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Sa ye Jesu yahu nemoahye: —‍Mʉsare niita niaja. Ihcãquiro “Jesu yaquiro ijiaja”, masare tiquiro nigʉ̃ ihñagʉ, yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ “Tiquiro yaquiro ijire”, ni yahutja Cohãcjʉ̃ yequina angelere. ");
INSERT INTO pirNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ihcãquiro “Jesu yaquiro ijieraja”, masare tiquiro nigʉ̃, yʉhʉ gʉ̃hʉ “Tiquiro yaquiro ijierare”, ni, yahutja Cohãcjʉ̃ yequina angelere. ");
INSERT INTO pirNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Ihcãquiro yʉhʉre ñano tiquiro ni yahuducugʉ̃ ti ñañene Cohãcjʉ̃ bo masine. Sa boeperota ihcãquiro Espíritu Santo pehere tiquiro ñano ni yahuducugʉ̃ ti ñañene ne Cohãcjʉ̃ bosi. ");
INSERT INTO pirNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Mari judio masa buheri wʉhʉpʉ pʉhtoa cahapʉ apequina mʉsare ne sajã “Ñañequina ijire”, ni yahusãeta. Tiquina sa yahusãgʉ̃ mʉsa yahuducuatire “Acuehi, masiedaboaga”, ni tʉhotueracãhña. ");
INSERT INTO pirNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Tiquina mʉsare yahusãgʉ̃ta Espíritu Santo mʉsa yahuducuatire yahurota, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Sa ye masa mehna cjʉ̃no Jesure ohõ saha ni yahuahye: —‍Buhegʉ, ʉsã pacʉ tiquiro yariari bato tiquiro ye ʉsãre tojoare. Sa yegʉ yʉhʉ wahmine tire yʉhʉ gʉ̃hʉre queoro tu wa dutiya, niahye tiquiro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Tiquiro sa nigʉ̃ Jesu yʉhtiahye: —‍Ne ti borore tu wabogʉ ijieraja yʉhʉ, niahye Jesu tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Sa ni tuhasa Jesu ijipihtiyequinare yahuahye: —‍Quehnoano yeya mʉsa. Doeri cjẽne, apee boro gʉ̃hʉre cahĩedacãhña. Peye cʉoepenata ti mehnata bucueducueraja mari, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Sa ni tuhasa Jesu quiti mehna yahuahye tiquinare: —‍Doeri cjẽ upʉro quehnoari yehpare cʉoahye. Sa ye ti yehpapʉ tiquiro otegʉ̃ quehnoano dʉca tiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Sa yero tiquiro basi ohõ saha ni tʉhotumahye: “Dʉca ihboye wʉhʉse ne esa tuhaerare. ");
INSERT INTO pirNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Yojopʉre ohõ saha yeitja: Yojopʉ yʉhʉ ihboye wʉhʉsere cohã cã, mʉna wʉhʉse yʉhdʉoro wahma wʉhʉse yeitja. Ti wʉhʉsepʉ yʉhʉ oteye dʉcare, ijipihtiyere yeere ihboutja. ");
INSERT INTO pirNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Yʉhʉ sa yeri bato, ohõ saha ni, tʉhotutja yʉhʉ basi: ‘Yʉhʉ peye apee boro cʉogʉ ijiaja. Quehnoano soutja. Sa yegʉ ihya, sihni, bucueitja’, ni tʉhotutja yʉhʉ basi”, ni tʉhotumahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Tiquiro sa ni tʉhotugʉ̃ Cohãcjʉ̃ tiquirore yahuahye: “Mʉhʉ ne tʉho masiegʉ ijire. Mia ñamita mʉhʉ yariagʉta. Mʉhʉ sa wahagʉ̃ mʉhʉ ye, mʉhʉ cahĩdi butia waharota”, niahye Cohãcjʉ̃ tiquirore, niahye Jesu masare. ");
INSERT INTO pirNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Tire nino, masare ohõ saha ni yahuahye Jesu: —‍Sata wahaeta doeri cjẽ opana Cohãcjʉ̃re wacũeñequina. Sa yero peye doeri cjẽne, niñerure tiquiro ye ijiati dihitare ihboriquiro Cohãcjʉ̃re wacũedaro, tiquiro pejecʉoriquiro yero saha ijirota, Cohãcjʉ̃ tiquiro ihñagʉ̃. Sa yero Cohãcjʉ̃ tiquirore ihña bucuerare, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Sa ye Jesu tiquiro buheyequinare ohõ saha ni yahuahye: —‍Ahrire mʉsare nigʉ niaja: Mʉsa ihyatire, mʉsa suhti sañatire, pajiro bʉjʉa witi tʉhotueracãhña. ");
INSERT INTO pirNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Cohãcjʉ̃ mʉsare bajumehneno, ihyatiquina dihitare yerari mʉsare. Sa yero suhti sañatiquina dihitare yerari mʉsare tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Minicjʉa parire Cohãcjʉ̃ tiquiro ihña ihboyere masiña. Tiquina weseri marieñequina ijire. Sa ye ihyayere tiquina ihboye wʉhʉse tiquinare mariedare. Tiquina sa ijigʉ̃ ihñano tiquinare Cohãcjʉ̃ tiquina ihyatire ohore. Minicjʉa yʉhdʉoro mʉsa pehere cahĩne Cohãcjʉ̃. ");
INSERT INTO pirNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Pajiro mʉsa tʉhotuye mehna ti mʉsare ihcã hora cati nemogʉ̃ yerare. Sa yero mʉsa pajiro tʉhotuye dʉhseati ijierare. ");
INSERT INTO pirNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Sa ye pajiro mʉsa tʉhotuye mehna ne mehenogã ye masiedare mʉsa. ¿Sa yena pajiro mʉsa tʉhotuye ti dʉhseati ijierapegʉ̃ta dʉhse yena mʉsa ihyatire, mʉsa sihniatire, mʉsa sañatire pajiro bʉjʉa witi tʉhotuajari? ");
INSERT INTO pirNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Nʉcʉ cjẽ cohorire tʉhotuya. Ti cohori ti basi suhtire yerare. Sa yerapeta quehnoañe suhti sañañequina yero saha quehnoano bajure ti cohori. Salomo mʉnano quehnoañe suhtire sañariquiro tiquiro ijiepegʉ̃ta ti cohori pehe tiquiro yʉhdʉoro quehnoa yʉhdʉaye cohori waro ijire. ");
INSERT INTO pirNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Cohorire quehnoañe cohori yere Cohãcjʉ̃ pehe. Tiquiro sa yepegʉ̃ta cohori pehe meheñe decorigã ijiducume ñai bora dijiaa wahare. Mehenogã iji, ape deco pecapʉ ʉjʉ̃a wahare. Ti sa ijiepegʉ̃ta cohorire quehnoañe cohori ijigʉ̃ yere Cohãcjʉ̃. Sa yero Cohãcjʉ̃ cohorire tiquiro quehnoañe cohori tiquiro yeriro yʉhdʉoro mʉsa gʉ̃hʉre quehnoano yerota. Suhtire ohorota. Mehenogã Cohãcjʉ̃re wacũ tutuare mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Sa yena mʉsa ihyatire, mʉsa sihniatire pajiro bʉjʉa witi tʉhotueracãhña. ");
INSERT INTO pirNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Cohãcjʉ̃re cahmeeñequina pehe ahri yehpa cjẽna pehe tire sa macaducuye nine. Mari Pacʉ ʉhmʉse cjʉ̃no ijipihtiye mʉsa cahmeñene masine. Tiquiro sa masigʉ̃ pajiro bʉjʉa witi tʉhotueracãhña. ");
INSERT INTO pirNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","“Cohãcjʉ̃ yʉhʉ pʉhtoro ijire”, ni tʉhotu, tiquirore cahmeña mʉsa. Mʉsa sa yeri bato Cohãcjʉ̃ pehe mʉsa cahmeñe dʉhsagʉ̃ ohorota, ni yahu nemoahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Sa yero tiquinare yahu nemoahye: —‍Yʉhʉ cahĩna, meheñequinagã ijiepenata, cueracãhña mʉsa. Cohãcjʉ̃ tiquiro pʉhtoro ijiropʉre tiquiro mehna mʉsa ijigʉ̃ cahmene tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Sa yena mʉsa yere dua pehoya. Tire dua, ti niñerure ne, pejecʉoyequinare ohoya. Sata mʉsa yegʉ̃ ʉhmʉse cjẽ mʉsa wapataye ne pihtisi. Ʉhmʉsepʉ mʉsa ye ijiro ne pihtierare. Topʉre mʉsa yere nea masiedare yaqueriquiro. Sa ye mecasia gʉ̃hʉ tire tʉa masiedare. ");
INSERT INTO pirNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ʉhmʉsepʉ mʉsa ye ijigʉ̃ ʉhmʉse cjẽ dihitare tʉhotunata mʉsa, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Sa ni tuhasa tiquinare yahu nemoahye: —‍Mʉsa yere quehnoyu tuhasariquina yero saha yeere sa yeducuna ijina yʉhʉre cohteya. Dahra cohteyequina tiquina pʉhtoro omoca dʉhteri bose decopʉ tiquiro wahagʉ̃ tiquiro tojoa tatire tiquina cohtere. Tiquina sa cohteriro saha yʉhʉ tojoa tatire cohteya mʉsa gʉ̃hʉ. Pʉhtoro tiquiro wʉhʉpʉ wihi, sopecahare tiquiro dotegʉ̃ tʉhoye tiquina duita põo sõre tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Dahra cohteyequina tiquina pʉhtoro wihigʉ̃ tiquiro cahmeno sahata yeducuyequina ijiye, bucueyequina ijieta. Tiquina sa yegʉ̃ ihñano pʉhtoro pehe dahra cohteriquiro yero saha camesarota. Sa yero dahra cohteyequinare duji dutiro, tiquiro tiquina ihyayere peorota. ");
INSERT INTO pirNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Tiquiro wihiri pje ñami decopʉ, o bohreagʉ̃pʉ ijiepegʉ̃ta dahra cohteyequina pehe tiquiro wihiri pjere tiquirore quehnoano cohteyequina ijiye, bucueyequina ijieta tiquina. ");
INSERT INTO pirNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ahrire wacũña. Yaqueriquiro wʉhʉpʉ tiquiro wihiato pano ti wʉhʉ cjʉ̃no masiedare. Wʉhʉ cjʉ̃no yaqueriquiro tiquiro wihiatore masino, yaqueriquirore sajã ta dutieraboaga. Sa yero wacũeno mehna ahtare yaqueriquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Sa yena mʉsa gʉ̃hʉ cohteya. Yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ wacũeno mehna ahtaʉtja. Sa yena yeere sa yeducuna ijina cohteya mʉsa, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Tiquiro sa nigʉ̃ Pedro pehe sinituahye Jesure: —‍¿Ahri quitire yahugʉ ʉsãre nigʉ niajari? ¿O ijipihtiyequinare sa nigʉ niajari? niahye Pedro. ");
INSERT INTO pirNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Tiquiro sa nigʉ̃ Jesu tiquiro tʉhotuye mehna ohõ saha ni queoye mehna buheahye tiquinare: —‍Dahra cohteriquiro tiquiro pʉhtorore ño peoriquiro tʉho masiniquiro ohõ sahata ijire. Pʉhtoro tinino waharo, dahra cohteriquirore tiquiro ya wʉhʉre cũre. Tiquiro cũnohriquiro pehe dutiriquiro ijirota. Sa yero tiquiro ihyari pje ijigʉ̃ apequina dahra cohteyequinare ihyayere itire. ");
INSERT INTO pirNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Came pʉhtoro tiquiro wihigʉ̃ dahra cohteriquiro pehe tiquiro pʉhtoro tiquiro dutiriro sahata ye pehoriquiro ijiro, tiquiro bucueriquiro ijirota. ");
INSERT INTO pirNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Poto nigʉta niaja mʉsare. Tiquiro sa yegʉ̃ tiquiro pʉhtoro ijipihtiye tiquiro yere ihña ihboriquiro cũnota tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Apequiro dahra cohteriquiro pehe “Yʉhʉ pʉhtoro yoari pje bajuerare”, niboaga. Sa nino apequina dahra cohteyequinare ʉmʉare, numia gʉ̃hʉre quẽ mʉja, pajiro ihya, sihni, queheboaga. ");
INSERT INTO pirNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Tiquiro sa yeri bato wacũeno mehna tiquiro pʉhtoro wihirota. Sa wihiro tiquirore ñano buhiri dahrerota. Sa yero Cohãcjʉ̃re yʉhdʉdʉcayequinare tiquiro cohãnopʉ tiquirore cohãnota. ");
INSERT INTO pirNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Sa yero dahra cohteriquiro tiquiro pʉhtoro cahmeñene masiniquiro ijieperota tire tiquiro yeragʉ̃, tiquiro quehnoano dahraeragʉ̃ tiquiro pʉhtoro pehe tiquirore yuta da mehna tananota. ");
INSERT INTO pirNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Apequiro pehe dahra cohteriquiro tiquiro pʉhtoro cahmeñene masieniquiro ijiro quehnoano yeragʉ̃ ihñano tiquiro pʉhtoro pehe derogã tiquirore tananota. Cohãcjʉ̃ pajiro masare ohoro pajiro tiquinare apequinare oho dutirota. Sa yero tiquiro cahmeñene masigʉ̃ yere masare. Quehnoano tiquiro masigʉ̃ yenohriquinare quehnoano yʉhti dutire tiquiro, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Sa ni tuhasa Jesu tiquinare yahuahye tja: —‍Peca ʉjʉ̃a weriro sahata yʉhʉ ahri yehpapʉre masa tiquina ñañe yeyere cose wegʉ ahtagʉ nii. Yojopʉ pũrita peca ʉjʉ̃a wero saha ñañe marieñequina masa tiquina ijigʉ̃ tutuaro cahmeaja yʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Yʉhʉ ñano yʉhdʉtja. Yʉhʉ sa ñano yʉhdʉatire cohtegʉ, ñano jeripohna tiaja yʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Dʉhse ni tʉhotuajari mʉsa yʉhʉre? ¿“Tiquiro masare tiquiro buheri bato apequina tiquina basi ihña tuhtisi”, ni tʉhotuajari mʉsa yʉhʉre? Sa ijierare. Masare yʉhʉ buheri bato ihquẽquina yeere tʉhoeta. Apequina pehe tiquinare ihña tuhtieta. Ihcãno saha ijisi masa. Mʉsare nigʉta niaja. Masa yʉhʉ buheyere tʉhoye, pʉa curua cahme tu waeta. ");
INSERT INTO pirNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Yojopʉre ihcã wʉhʉ cjẽna ihcã omopequina masa yʉhʉ buheyere tʉhoye, pʉa curua tiquina basi cahme tu waeta. Ihcã curua ihtiaro, ape curua pʉaro ijieta. ");
INSERT INTO pirNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tiquiro pacʉro tiquiro macʉnore ihña tuhtirota yaquiro tiquiro ijiri buhiri. Tiquiro macʉno gʉ̃hʉ tiquiro pacʉrore ihña tuhtirota yaquiro tiquiro ijiri buhiri. Sa yero ticoro pacoro maconore ihña tuhtirota yacoro ticoro ijiri buhiri. Sa yero apecoro macono gʉ̃hʉ ticoro pacorore ihña tuhtirota yacoro ticoro ijiri buhiri. Sa yero ticoro mareono ticoro macʉ namonore ihña tuhtirota yacoro ticoro ijiri buhiri. Sa yero apecoro macʉ namono gʉ̃hʉ ticoro mareonore ihña tuhtirota yacoro ticoro ijiri buhiri. Sa waharota, yʉhʉ buheyere tiquina tʉhogʉ̃, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Sa ye Jesu masare ohõ saha ni yahuahye tja: —‍Ahrie pehepʉ acoro cururire ihñana, duita “Acoro ahtarota”, nine mʉsa. Mʉsa sa nidi bato acoro ahtare. ");
INSERT INTO pirNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Sa yena surpʉ wihnono ahtagʉ̃ “Asiri deco ijirota”, nine mʉsa ahri yehpapʉ ijina. Mʉsa sa nidi bato cʉhmari deco ijire. ");
INSERT INTO pirNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Mʉsa masa ihñonopʉ quehnoano iji mehoducuna ijire. Mʉsa ahri yehpare ʉhmʉse gʉ̃hʉre ihñana, quehnoari deco ijiatire, ñari deco ijiati gʉ̃hʉre masine mʉsa. ¿Sa yena yojopʉ cjẽ decorire masiepenata dʉhsena ahri yehpa cjãna yojopʉre mʉsa dʉhse wahatire masiedajari mʉsa? niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Sa ni tuhasa ohõ saha ni yahu nemoahye: —‍¿Mʉsa poto yeatire yojopʉ masiedajari mʉsa? ");
INSERT INTO pirNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Apequiro mʉhʉre yahusãno waharo buhiri dahre dutiri wʉhʉpʉ waha dutiboaga. Topʉ wahana “Pari turi mʉhʉre sa yesi”, nigʉ cahmeque duhuya. Mʉhʉ sa duhueragʉ̃ tiquiro buhiri dahre dutiriquiro cahapʉ neaboaga mʉhʉre. Sa yero buhiri dahre dutiriquiro pehe mʉhʉre surarare tiquiro ohogʉ̃, mʉhʉre surara peresu yeeta. ");
INSERT INTO pirNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Mʉhʉre nigʉ niaja. Topʉ ijiniita mʉhʉ. Tee tiquina wapa ye dutirire mʉhʉ wapa ye pehogʉpʉ wijiagʉta mʉhʉ, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ti pjere meheñequinagã masa Jesure ohõ saha ni yahue tiahye: —‍Galilea cjẽna wahiquirore wejẽ ʉjʉ̃a mʉo Cohãcjʉ̃re tiquina ño peori watoa Pilato pehe tiquinare wejẽahye. Tiquiro sa wejẽgʉ̃ wahiquiro dii mehna masa dii moreahye, ni, yahuahye tiquina Jesure. ");
INSERT INTO pirNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Tiquina yahu tuhasagʉ̃ Jesu yʉhtiahye: —‍¿Galilea cjẽna Pilato tiquiro wejẽgʉ̃ wejõriquina mʉnare dʉhse ni tʉhotuajari mʉsa? ¿Tiquina sa yariagʉ̃ apequina Galilea cjẽna yʉhdʉoro ñañequina tiquina ijiri buhiri sa yeyari Cohãcjʉ̃ tiquinare, mʉsa tʉhotugʉ̃? ");
INSERT INTO pirNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ijierare. Mʉsare niita niaja. Mʉsa pehe mʉsa ñañene bʉjʉa witierana, quehnoañe pehere camesaerana, mʉsa gʉ̃hʉ yariana pecapʉ wahanata. ");
INSERT INTO pirNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Sa ye sohõ ijiriquina diez y ocho masa Siloé wame tiri wʉhʉ ʉhmʉari wʉhʉ tiquina bui wihnoa dijiaro, tiquinare wejẽ pehoahye. ¿Sa waha yariaye, apequina Jerusalẽ cjẽna yʉhdʉoro ñañequina ijiyari tiquina, mʉsa tʉhotugʉ̃? ");
INSERT INTO pirNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ijierare. Mʉsare niita niaja. Mʉsa ñañene bʉjʉa witierana quehnoañe pehere camesaerana, mʉsa gʉ̃hʉ yarianata. Sa yena pecapʉ wahanata, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Sa ni tuhasa apeye queoye mehna piti dahre yahuahye tiquinare: —‍Wese upʉro tiquiro wesepʉ higueragʉre cʉoahye. Sa yero tiquiro tʉ dʉcare macano wahamahye. Bocaerahye. ");
INSERT INTO pirNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Bocaeraro tiquiro wese dahrariquirore yahuahye. “Tʉhoya yʉhʉre. Ihtia cʉhma waro higueragʉ dʉcare macamaja. Dʉca mariedare. Tʉ dʉca mariedagʉ̃ tʉre quẽ cohã cãhña. Tʉ ya wesepʉ ijigʉ̃ apedʉre otero basioerare. Apedʉ tʉ ihyaborire ihyaboaga tʉ dʉca mariedʉ pehe”, niahye wese upʉro tiquirore dahra cohteriquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Tiquiro sa nigʉ̃ tʉhoro dahra cohteriquiro ohõ saha niahye: “Pʉhto, ahdʉ ihcã cʉhma waro ducurĩahdo. Tʉ nʉhcoripʉ yʉhʉ sehegʉtja. Tuhasa, wahiquiro cʉhta mehna ti copere yaʉtja. ");
INSERT INTO pirNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Yʉhʉ sa yeri bato tʉ ape cʉhma dʉca tiro dʉca tiboaga. Tʉ dʉca mariedagʉ̃ mʉhʉ quẽ cohã dutigʉta”, niahye dahra cohteriquiro wese upʉrore, ni, yahuahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ti pjere saurú deco ijigʉ̃ Jesu judio masa buheri wʉhʉpʉ buhero niahye. ");
INSERT INTO pirNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Topʉ watĩno cʉoricoro ijiahye. Watĩno pehe diez y ocho cʉhmari waro dohatigʉ̃ yeahye ticorore. Sa yero pari tjũ ducuricoro ijiro, poto ducu masiedahye. ");
INSERT INTO pirNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ticoro sa ijigʉ̃ ihñano Jesu ticorore ihña, pisuahye: —‍Numio, mʉhʉ dohatiye pihtia wahare, ni, pisuahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Tiquiro pisuri bato ticorore tiquiro ña peogʉ̃ duita ticoro quehnoano poto dʉca sahye. Sa waharo “Cohãcjʉ̃ tutuagʉ, quehnoagʉ ijire mʉhʉ”, ni ño peoahye ticoro. ");
INSERT INTO pirNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Jesu ticorore saurú deco ijigʉ̃ tiquiro yʉhdʉogʉ̃ ihñano judio masa buheri wʉhʉ cohteriquiro pehe tiquiro mehna usuahye. Sa usuaro tiquiro masare ohõ saha niahye: —‍Seis decori ijire mari dahraye decori. Sa yena mʉsa dohatiyequinare yʉhdʉo duana, ti decorire tire yeya. Saurú mari sori decore tire yeracãhña, niahye ti wʉhʉre cohteriquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Tiquiro sa nigʉ̃ Jesu ohõ saha ni yʉhtiahye: —‍Masa ihñono dihita quehnoana iji mehona ijire mʉsa. Mʉsa wecʉre, burro gʉ̃hʉre cʉona saurú decore tiquina dʉhteri dare pã, tiquinare ne buha, sihni dutiboaga. ");
INSERT INTO pirNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Yojopʉ ahricorore Abrahã mʉnano acayorore watĩno diez y ocho cʉhmari waro ticorore dohatigʉ̃ yere. ¿Saurú deco ijigʉ̃ ticorore yʉhdʉo dutierajari mʉsa? niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Tiquiro sa nigʉ̃ tʉhoye, tiquina bʉoro wahahye. Sa ye apequina pehe ijipihtiyequina Jesu yerire ihña, bucueahye. ");
INSERT INTO pirNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Sa ye Jesu queoye mehna buheahye masare: —‍¿Ne Cohãcjʉ̃ masa pʉhtoro tiquiro ijiye yabe boro yero saha ijiajari? Ahri quiti mehna tire tiquiro pʉhtoro ijiyere yahutja yʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Mostaza pjegã yero saha ijire. Ti pjegãre oteriquiro tiquiro ya wesere otere. Tiquiro oteri bato ti pjegã pihnine. Sa ye tʉ bʉcʉagʉ̃ minicjʉa pari ti dʉpʉripʉ suhti suhare, niahye Jesu. (Sa nino ohõ saha nino niahye. Mostaza pjegã pajidʉ tʉ bʉcʉariro saha ʉhmʉse cjʉ̃nore mari pʉhtorore masiñequina meheñequinagã tiquina iji mʉhtaepegʉ̃ta camepʉ tiquina peyequina wahaeta.) ");
INSERT INTO pirNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Sa yero pari turi Jesu queoye mehna buheahye: —‍¿Ne Cohãcjʉ̃ masa pʉhtoro tiquiro ijiye yabe boro yero saha ijiajari? ");
INSERT INTO pirNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Pãre pugʉ̃ yeye yero saha ijire. Tire numino ihcã ajuro trigore aco mehna quehnoano tire dahra morene pã bʉcʉatire. Ticoro sa yegʉ̃ pãre pugʉ̃ yeye pehe trigore quehnoano sehsaa wahare, niahye Jesu. (Sa nino ohõ saha nino niahye. Pãre pugʉ̃ yeye trigore ti sehsaa wahariro saha ʉhmʉse cjʉ̃nore mari pʉhtorore peyequina masa ijipihtiro cjẽna masieta.) ");
INSERT INTO pirNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Sa ye Jesu bʉjʉye macaripʉ, daye macarigãpʉ gʉ̃hʉre buhe cã, Jerusalẽpʉ esaro taro niahye. ");
INSERT INTO pirNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Tiquiro sa wahari watoa masʉno Jesure ohõ saha ni sinituahye: —‍¿Pʉhto, meheñequinagã masare pecapʉ wahaboriquinare yʉhdʉorotari Cohãcjʉ̃? niahye tiquiro Jesure. Tiquiro sa nigʉ̃ Jesu queoye mehna buhero ohõ saha ni yahuahye: ");
INSERT INTO pirNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—‍Peyequina masa Cohãcjʉ̃ cahapʉ waha duaye, sajã duamene. Meheni sopecahagãre mʉsa sajã duagʉ̃ mijorĩne. Sata Cohãcjʉ̃ cahapʉ mʉsa waha duagʉ̃ mijorĩne. Masa sa sajã duepeta sajã masiedare. Sa yena mʉsa pehe meheni sopecahagãre mʉsa tutuaro sajã duaboro sahata Cohãcjʉ̃ pehere tutuaro masiña. ");
INSERT INTO pirNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ohõ saha yerota Cohãcjʉ̃ peyequina masare. Tiquiro wʉhʉ upʉro yero saha ijire. Wʉhʉ upʉro wahcã, sopecahagãre biharota. Tiquiro sa yegʉ̃ sopecahagãpʉ ducuna, dotenata. Dotena ohõ saha ninata. “Pʉhto, sope pahmare põohña”, mʉsa nigʉ̃ wʉhʉ upʉro pehe yʉhtirota. “Mʉsare, mʉsa ahtariro gʉ̃hʉre ne masiedaja yʉhʉ”, ni yʉhtirota. ");
INSERT INTO pirNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Tiquiro sa nigʉ̃ mʉsa yʉhtinata. “Mʉhʉ mehna ʉsã ihya, sihnii. Ʉsã ya macapʉ buheri mʉhʉ”, ninata mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Mʉsa sa nigʉ̃ tiquiro pehe yʉhtirota. “Mʉsare, mʉsa ahtariro gʉ̃hʉre ne masiedaja. Ijipihtina mʉsa ñañe yerina yʉhʉ cahapʉ ahtaeracãhña”, ninota wʉhʉ upʉro. ");
INSERT INTO pirNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Sa ye Abrahãre, Isaare, Jacore, ijipihtiyequina Cohãcjʉ̃ yere yahu mʉhtariquinare Cohãcjʉ̃ tiquiro pʉhtoro ijirore tiquina ijigʉ̃ ihñana, mʉsa pehe sopecahapʉ cohõrina ijina tutuaro utinata. Sa yena mʉsa tutuaro bʉjʉa witina, bahque dihonata. ");
INSERT INTO pirNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ti pjere ijipihtiro cjẽna Cohãcjʉ̃ tiquiro pʉhtoro ijiropʉre esa, tiquiro mehna ihya dujieta. ");
INSERT INTO pirNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Yojopʉre ihyo ijiyequina ijiriquina ti pjere pʉhtoa ijieta. Sa yeye yojopʉre pʉhtoa ijiriquina ti pjepʉre ihyo ijiyequina ijieta, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ti pjere meheñequinagã fariseo masa Jesu cahapʉ esa, tiquirore yahuahye: —‍Herode mʉhʉre wejẽ duare. Sa yegʉ ape siepʉ wahaya mʉhʉ, niahye tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Tiquina sa nigʉ̃ Jesu pehe yʉhtiahye: —‍Herode ni mehoñe peyariquiro ijire tiquiro. Ohõ saha ni yahuya tiquirore: “Jesu watĩare cohãno nine. Sa yero dohatiyequinare yʉhdʉoro nine. Tire miare, ñamia gʉ̃hʉre yerota. Sa yero ñamia bohrearo dahra bato tirota”, ni yahuya Herodere. ");
INSERT INTO pirNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Sa yegʉ miare waha, ñamia gʉ̃hʉre waha, ñamia bohrearo gʉ̃hʉre waha, Jerusalẽpʉ esaʉtja. Cohãcjʉ̃ yere yahu mʉhtagʉre yʉhʉre wejẽeta masa. Cohãcjʉ̃ yere yahu mʉhtariquinare tiquina wejẽgʉ̃ Jerusalẽpʉ ijiro cahmene tiquinare. Sa yegʉ yʉhʉ gʉ̃hʉre Jerusalẽpʉ ijiro cahmene. ");
INSERT INTO pirNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’Ahyou, Jerusalẽ cjãna, mʉsa Cohãcjʉ̃ yere yahu mʉhtariquinare wejẽ, mʉsa cahapʉ tiquiro ohoriquinare ʉtã paca mehna doque wejẽdi mʉsa. Canaca ticoro pohnene wʉye dʉpʉri mehna ticoro moha cuñano saha peye tahari mʉsare cahĩducumi. Mʉsare cahmemi. Mʉsa pehe yʉhʉre ne cahmedari. ");
INSERT INTO pirNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Yojopʉ mʉsa ya maca cohõri maca ijirota. Ijirota niita niaja mʉsare. Cohãcjʉ̃ mari pʉhtoro tiquiro tutuaye mehna ahtaʉtja yʉhʉ. Yʉhʉ ahtagʉ̃ mʉsa yʉhʉre “Cohãcjʉ̃ tutuaye mehna ahtariquiro quehnoahdo”, ninata. Yʉhʉre mʉsa tire niato pano pari turi yʉhʉre ihñasi mʉsa, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ape deco saurú ijigʉ̃ fariseo masa pʉhtoa mehna cjʉ̃no ya wʉhʉpʉ Jesu ihyaro wahahye. Ti wʉhʉpʉ ijiyequina tiquirore ihña nʉnʉahye. ");
INSERT INTO pirNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Sa yero omoca, ñecʉ gʉ̃hʉ ipinohriquiro tiquiro cahapʉ esahye. ");
INSERT INTO pirNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Sa yero Jesu judio masare buheyequinare, fariseo masa gʉ̃hʉre sinituahye: —‍¿Saurú ijigʉ̃ dohatiriquirore yʉhdʉo dutiajari Cohãcjʉ̃ yere tiquina ojoari pũpʉ? niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Tiquiro sa ni sinituepegʉ̃ta tiquina yʉhtierahye. Tiquina yʉhtieragʉ̃ ihñano Jesu dohatiriquirore yʉhdʉo, “Wahaya”, niahye tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Sa ye tuhasaro, tiquinare sinituahye tja: —‍¿Ihcãquiro mʉsa mehna cjʉ̃no tiquiro macʉno saurú deco mari sori deco ijigʉ̃ aco ijiri copepʉ tiquiro bora sajãgʉ̃ ne wioeraboagari, mʉsa tʉhotugʉ̃? ¿Tiquiro yaquiro wecʉ gʉ̃hʉre ne wioeraboagari, mʉsa sa nina? Ne wioboaga tiquiro, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Tiquiro sa niepegʉ̃ta tiquina tiquiro siniturire yʉhti masiedahye tja. ");
INSERT INTO pirNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Fariseo masʉno ya wʉhʉpʉ ijiro ti wʉhʉ cjʉ̃no tiquiro pijioriquina quehnoañe dujiyere tiquina besegʉ̃ ihñahye Jesu. Sa ihña tuhasa ohõ saha ni yahuahye ijipihtiyequinare: ");
INSERT INTO pirNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—‍Omoca dʉhteri bose deco mʉsare tiquiro pijiogʉ̃, quehnoañe dujiyere bese dujieracãhña. Mʉsa yʉhdʉoro cua pesayequinare pijioboaga ahri wʉhʉ upʉro. ");
INSERT INTO pirNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Tiquiro sa yegʉ̃ mʉsa quehnoañe dujiyepʉ dujigʉ̃ “Ahriquina cua pesayequina pehere mʉsa dujiyere ohoya”, niboaga wʉhʉ upʉro mʉsare. Tiquiro sa nigʉ̃ mʉsa pehe bʉoro wahana, ñañe dujiyepʉ dujiboaga. ");
INSERT INTO pirNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Sa yena wʉhʉ upʉro mʉsare tiquiro pijiogʉ̃, ñañe dujiyepʉ duji mʉhtaña. Mʉsa sa yegʉ̃ wʉhʉ upʉro mʉsare “Quehnoañe dujiye pehere dujina ahtaya”, ninota mʉsare tiquiro. Mʉsa sa wahagʉ̃ apequina tiquiro pijioriquina pehe mʉsare ño peoye mehna ihñaeta. ");
INSERT INTO pirNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ihcãquiro tiquiro basi “Pʉhtota ijiaja”, ni tʉhoturiquiro cahacjʉ̃no ijirota. Sa yero apequiro “Cahacjʉ̃ ijiaja”, ni, tʉhoturiquiro, apequinare yʉhdʉdʉca dueriquiro tiquiro pehe pʉhtoro ijirota, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Sa ni tuhasa Jesu wʉhʉ upʉrore yahuahye: —‍Mʉhʉ bose deco dahregʉ mʉhʉ cahapʉ ijiyequinare, mʉhʉ bahanare, mʉhʉ acayere, doeri cjẽ opanare pijioeracãhña. Mʉhʉ tiquinare pijiogʉ̃ mʉhʉ gʉ̃hʉre tiquina gʉ̃hʉ piji cahmeeta. Sa piji cahmeñe mʉhʉre tiquina wapamonore wapa yeeta. ");
INSERT INTO pirNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Mʉhʉ bose deco dahregʉ pejecʉoyequinare, tini masieñequinare, pari yuri wahayequinare, caperi bajueyequinare pijiohya. ");
INSERT INTO pirNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Mʉhʉ sa yegʉ̃ ihñano Cohãcjʉ̃ mʉhʉre quehnoano yerota. Tiquina pehe mʉhʉre tiquina wapamonore wapa ye masiedare. Sa yero quehnoañequina yariariquina tiquina masa mʉjari pje ijigʉ̃ Cohãcjʉ̃ pehe quehnoano mʉhʉ yeri wapa mʉhʉre quehnoano yerota, niahye Jesu wʉhʉ upʉrore. ");
INSERT INTO pirNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Tiquiro sa nigʉ̃ tʉhoro apequiro ihyari mesa cahapʉ dujiriquiro, Jesure yahuahye: —‍Cohãcjʉ̃ tiquiro pʉhtoro ijiropʉ tiquiro ihyari mesa cahapʉ dujiyequina tutuaro bucueyequina ijieta, niahye tiquiro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Tiquiro sa nigʉ̃ Jesu ahri queoyere yahuahye tiquirore: —‍Pajiri bose deco dahreriquiro peyequina masare pijioahye. ");
INSERT INTO pirNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Tiquiro pijiori bato bose deco tiquiro cahacjʉ̃nore tiquiro pijioriquinare yahu dutiro ohoahye. “Isa, ijipihtiyere bose deco cjẽ ijiatire quehno tuhasari. Sa yero mʉsare pijiori”, ni, yahu dutiahye tiquiro cahacjʉ̃nore. ");
INSERT INTO pirNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Tiquiro cahacjʉ̃no tiquiro sa ni yahuepegʉ̃ta, tiquiro pijionohriquina pehe “Waha masiedaja”, niahye tiquina. Tiquiro pijio mʉhtanohriquiro ohõ saha ni yahuahye tiquiro cahacjʉ̃nore. “Mianogãta yehpare dúu. Sa yegʉ ti yehpare ihñagʉ wahagʉ niaja. Sa yero waharo basioeraga. Ño peo cjũña mʉhʉ yʉhʉre. Yʉhʉre basioerare”, niahye tiquiro pijio mʉhtanohriquiro pehe tiquiro cahacjʉ̃nore. ");
INSERT INTO pirNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Apequiro pehe ohõ saha niahye: “Wecʉare pʉa omoca pihtiyequinare mianogãta dúu. Buhe tuhugʉ wahaʉ tʉʉ niaja ti weje cãtore. Sa yegʉ wecʉare ‘¿Quehnoano dahrajari?’ ni ihñagʉ wahagʉ tʉʉ niaja. Sa yegʉ wahasi. Yʉhʉre basioerare”, niahye tiquiro gʉ̃hʉ. ");
INSERT INTO pirNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Apequiro pehe ohõ saha niahye: “Yʉhʉ mianogãta omoca dʉhtei. Sa yero bose decopʉ waharo basioeraga yʉhʉre”, niahye tiquiro cahacjʉ̃nore. ");
INSERT INTO pirNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","’Tiquiro sa nigʉ̃ cahacjʉ̃no pehe tojoa waha, tiquiro pʉhtoropʉre tiquina nidire yahu peho cãhye. Tiquiro sa ni yahugʉ̃ tiquiro pʉhtoro tutuaro usua, ohõ saha niahye tiquiro cahacjʉ̃nore. “Wʉhʉse watoa cjẽ maharipʉ wahaya. Pejecʉoyequinare macarĩsa. Sa yegʉ pejecʉoyequinare, tini masieñequinare, caperi bajueyequinare, pari yuri wahayequinare ʉmʉñano ne cãhtaya tiquinare”, niahye pʉhtoro. ");
INSERT INTO pirNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Came cjũnogã tiquiro cahacjʉ̃no yahuahye tiquiro pʉhtorore: “Pʉhto, mʉhʉ dutiriro sahata yei. Yʉhʉ sa yepegʉ̃ta apequina gʉ̃hʉ esa tuhaeta”, niahye tiquiro cahacjʉ̃no. ");
INSERT INTO pirNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Tiquiro sa nigʉ̃ pʉhtoro tiquirore dutiahye: “Ihquẽ wʉhʉse ijiropʉ wahaya. Topʉ bʉjʉye maharipʉ, daye maharigãpʉ gʉ̃hʉre masare ya wʉhʉpʉ ahta dutiya, ya wʉhʉpʉ tiquina wahpagʉ̃. ");
INSERT INTO pirNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Poto niita niaja mʉhʉre. Ahriquina yʉhʉ pijio mʉhtamediquina yʉhʉ ihyayere ne mehenogã ihyasi”, niahye pʉhtoro, ni yahuahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ti pjere peyequina masa Jesu mehna wahahye. Sa yero Jesu tiquinare majare ihña, yahuahye: ");
INSERT INTO pirNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—‍Ihcãquiro yʉhʉ buheriquiro iji duaro apequina yʉhdʉoro yʉhʉ pehere cahĩno cahmene. Tiquiro pacʉrore, tiquiro pacorore, tiquiro namonore, tiquiro pohnene, tiquiro bahanare, tiquiro pagʉ gʉ̃hʉre tiquiro cahĩno yʉhdʉoro yʉhʉ pehere cahĩno cahmene. ");
INSERT INTO pirNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ihcãquiro yʉhʉ buheriquiro iji duaro yeere sa yeducuriquiro ijirota. Sa yero yaquiro tiquiro ijiri buhiri ñano yʉhdʉeperota yʉhʉre ne duhusi. ");
INSERT INTO pirNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ahrire masiyuro cahmene mʉsare. Ohõ saha ijire ti: Wʉhʉ dahreriquiro tiquiro ʉhmʉari wʉhʉre yeato pano wʉhʉ wapa tiatire queo mʉhtare. Sa yero, ti wʉhʉre tiquiro pehoatire masine tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Wapa tiyere queoeraro ti wʉhʉre yero pehoeraboa. Sa ye tiquirore ihñañequina bʉjʉpeboa. ");
INSERT INTO pirNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Ahriquiro ti wʉhʉre yero, tutuerare”, ni, bʉjʉpeboa. ");
INSERT INTO pirNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Pʉhtoro apequiro pʉhtoro yeequina mehna tiquina cahmequeato pano, tiquiro yequina surarare tiquiro cahme wejẽ dutiato pano, tiquiro yequina surarare queorota. “¿Yʉhʉ diez mil surara mehna apequiro veinte mil surara cʉoriquiro mehna cahme wejẽgʉ̃ tutueraboagari yʉhʉ?” ni, tʉhoturo queorota tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Sa queoro, tiquiro tutueratire masinota. Sa masino apequiro pʉhtoro tiquiro yequina surara mehna cahme wejẽno ahtariquiro yoaropʉ tiquiro ijigʉ̃ta, tutueriquiro pehe “Cahme wejẽdacʉ̃hna”, ni dutiro ohoboaga dahra cohteriquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Sa yena yʉhʉ buhena iji duana, mʉsa yeatire mʉsare masino cahmene. Mʉsa ye duaye pehere duhu duerana, yʉhʉ buhena iji masiedare, ni yahuahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Sa yero tiquinare yahu nemoahye: —‍Moa quehnoano ocare. Ti ocaeragʉ̃ ocaye yero basioerare. ");
INSERT INTO pirNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Moa ocaeraro ti moa ne quehnoaedare. Ti moare dʉhsero basioerare. Ti sa ijigʉ̃ ti moare cohãno cahmene. Ne dʉhseati ijierare ti moa. (Ti dʉhseati ijieraro saha ijieracãhña mʉsa. Cohãcjʉ̃ ye pehere cohãedacãhña.) Ahrire quehnoano tʉhoya mʉsa, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Sa ye ape deco peyequina wapa ne cohteyequina apequina “Ñañequina”, tiquina niñequina mehna Jesure tʉhoye ahtahye. ");
INSERT INTO pirNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Tiquina sa yegʉ̃ ihñañe fariseo masa, judio masare buheyequina gʉ̃hʉ Jesure ihña tuhtiye, ohõ saha niahye tiquina basi: —‍Ahriquiro ñañequinare piti tire. Sa yero tiquina mehna ihyare, ni, yahuducuahye tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Tiquina sa ni yahuducugʉ̃ Jesu tiquiro tʉhotuye mehna ohõ saha ni, queoye mehna buheahye tiquinare: ");
INSERT INTO pirNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—‍¿Cien oveja cʉoriquiro ihcãquiro oveja butigʉ̃ ihñano dʉhse yerotari tiquiro? Ohõ saha yerota. Tiquiro noventa y nueve ovejare tiquina ihyariropʉ cũ, butiriquirore macano waharota. Ovejare bocaropʉ duhurota. ");
INSERT INTO pirNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Tiquirore bocaro bucuerota. Sa yero tiquiro butiriquirore wʉa peo, tiquiro ya wʉhʉpʉ ne tojoaa waharota. ");
INSERT INTO pirNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ne tojoa sa, tiquiro cahapʉ ijiyequinare, tiquiro acayere piji cahmecoanota. “Yaquiro oveja butiriquirore boca tuhasaʉ. Sa yena yʉhʉ mehna bucueya”, ninota tiquiro tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Poto niita niaja mʉsare. Noventa y nueve oveja peyequina tiquina ijiro sahata, peyequina masa ohõ saha ni tʉhoture: “Ñano yeraja. Sa yegʉ yʉhʉ ñañene bʉjʉa witisi. Quehnoañe pehere camesasi yʉhʉ”, ni, tʉhoture peyequina masa. Tiquina sa ni tʉhotugʉ̃ ihñañe ʉhmʉse cjẽna Cohãcjʉ̃ cahapʉ ijiyequina bucuerare. Apequiro pehere bucuere. Butiriquiro oveja ihcãquirota butiriro sahata tiquiro upʉro tiquirore bocariro sahata ihcãquiro ñariquiro tiquiro ñañene bʉjʉa witigʉ̃, quehnoañe pehere camesagʉ̃ ihñañe, Cohãcjʉ̃ cahapʉ ijiyequina tutuaro bucuere, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Sa ni yahu tuhasa, queoye mehna yahu nemoahye tja: —‍¿Pʉa omope cjoeri niñeru cjoeri cʉoricoro ihcã cjoe butigʉ̃ dʉhse yerotari ticoro? Ohõ saha yerota ticoro. Sihãriare sihã, wʉhʉre coha, quehnoano maca pehorota. Ti cjoere bocaropʉ duhurota. ");
INSERT INTO pirNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ti cjoere boca tuhasa, ticoro cahapʉ ijiyequinare, ticoro mehna cjẽnare piji cahmecoanota. “Niñeru cjoe yʉhʉre butiri cjoere bocaʉ. Sa yena yʉhʉ mehna bucueya”, ninota ticoro. ");
INSERT INTO pirNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Potota niita niaja mʉsare. Sata ihcãquiro ñariquiro tiquiro ñañene bʉjʉa witigʉ̃ quehnoañe pehere camesagʉ̃ Cohãcjʉ̃ yequina angele pehe tutuaro bucueeta, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Sa ni yahu tuhasa Jesu queoye mehna yahu nemoahye tja: —‍Bʉcʉro pohne pʉaro ʉmʉa ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Dʉhsariquiro pehe ohõ saha niahye tiquiro pacʉrore: “Mai, mʉhʉ yariari bato mʉhʉ ohoatire yʉhʉre ohoya”, niahye tiquiro pacʉrore. Tiquiro sa nigʉ̃ tiquina pacʉro pʉaropʉreta tiquiro pohnene itiahye tiquiro cʉorire. ");
INSERT INTO pirNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Meheñe decorigã bato dʉhsariquiro tiquiro yere ijipihtiyere ne, yoaropʉ ape yehpapʉ wahaa wahahye. Topʉ esaro tʉho masieniquiro yero saha ye, tiquiro niñerure, tiquiro yere ye site peho cãhye. ");
INSERT INTO pirNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Tiquiro ye site pehori bato ti yehpapʉre ne ihyaye mariedi pje iji dʉcahye. Sa yero tiquiro ʉjʉa ahbahye. ");
INSERT INTO pirNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Sa yero ti yehpa cjẽ dahrayere macahye. Tiquiro bocagʉ̃ tiquiro pʉhtoro yesea cohteriquiro sõahye tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Sa yero tiquiro yeseare nu, tiquina ihyayere ihya duamahye. Tiquiro sa ihya duepegʉ̃ta ti ihyayere to cjẽna ohoerahye tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Sa ye tiquiro topʉ wacũahye. “Yʉhʉ pacʉre dahra cohteyequina pehe bʉjʉye ihyayere ihyare. Tiquina ihya dʉhari gʉ̃hʉ bʉjʉye dʉhsare. Tiquina sa quehnoano yʉhdʉri watoa yʉhʉ pehe ohõpʉ ijigʉ, ʉjʉa ahbagʉ niaga. ");
INSERT INTO pirNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Yojopʉre yʉhʉ pacʉ cahapʉ tojoagʉtja. Yʉhʉ pacʉ cahapʉ esagʉ ohõ saha niitja tiquirore: ‘Mai, Cohãcjʉ̃re ñano yei. Mʉhʉ gʉ̃hʉre ñano yei. ");
INSERT INTO pirNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ñagʉ ijiaja yʉhʉ. Mʉhʉ macʉ yero saha ijibogʉ ijieraja yʉhʉ. Mʉhʉre dahra cohteriquiro yero saha yeya yʉhʉre’, niitja yʉhʉ pacʉre”, ni tʉhotuahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Sa ni tʉhoturota wahcãdʉca, tiquiro pacʉro cahapʉ tojoaa wahahye. Topʉ tiquiro esariquiro tojoa tagʉ̃ tiquiro pacʉro pehe yoaropʉta tiquiro macʉnore ihñahye. ’Tiquiro sa wihigʉ̃ ihñano macʉnore paja ihñahye. Paja ihñano tiquiro cahapʉ oma cã, tiquirore quẽ suhsu maa, tiquiro wahsupure ihmiahye pacʉro tiquiro macʉnore. ");
INSERT INTO pirNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Mai, Cohãcjʉ̃re ñano yei. Mʉhʉ gʉ̃hʉre ñano yei. Ñagʉ ijiaja yʉhʉ. Mʉhʉ macʉ yero saha ijibogʉ ijieraja yʉhʉ”, niahye tiquiro pacʉrore. ");
INSERT INTO pirNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Tiquiro sa nigʉ̃ tʉhoro pacʉro pehe dahra cohteyequinare pijiahye. “Sojaro mehna, quehnoa yʉhdʉari suhtirore ne cãhtaya. Sa yena yʉhʉ macʉre sãaña. Sãa tuhasa, tiquiro omoca sañari behtore sãa, dahpo suhti gʉ̃hʉre sãaña. ");
INSERT INTO pirNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Sãa tuhasa, dihi tiriquirogãre wecʉgãre wejẽña. Bose deco yeihna mari. ");
INSERT INTO pirNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ahriquiro yʉhʉ macʉ yariariquiro yero saha wahariquiro ijire. Sa wahaeperota yojopʉre catire tiquiro. Tiquiro butimediquirore pari turi bocaʉ. Sa yena bose deco yeihna mari”, niahye tiquiro pacʉro. Tiquiro sa nidi bato bose deco dahre dʉcahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Ti pjere tiquiro wahmino pehe wesepʉ ijiahye. Wesepʉ ijiriquiro cohe tojoa taro wʉhʉ cahapʉ esaro, tiquina basayere tʉhoahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Tʉhoro, ihcãquiro dahra cohteriquirore pijio, tiquirore sinituahye tiquiro: “¿Dʉhse ijiro boro basaye niari?” niahye tiquiro dahra cohteriquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“Mʉhʉ bahʉ coheri. Tiquiro quehnoariquiro, catiriquiro tiquiro cohegʉ̃ mʉhʉ pacʉ dihi tiriquirogãre wecʉgãre wejẽ dutiri”, ni yʉhtiahye dahra cohteriquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Tiquiro sa ni yahugʉ̃ tiquiro wahmino pehe tutuaro usuaro, wʉhʉpʉ sajãedahye. Tiquiro sajãedagʉ̃ ihñano tiquiro pacʉro sopecahapʉ wijia ta, “Sajã taya”, ni, pijimahye tiquiro macʉnore. ");
INSERT INTO pirNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Tiquiro sa pijigʉ̃ macʉno yʉhtiahye. “Tʉhoya mai. Yoari pje mʉhʉre dahra cohteriquiro yero saha mʉhʉre yedohomi. Sa yegʉ mʉhʉ dutiyere ne ihcã taha yʉhdʉdʉcaerʉ. Yʉhʉ mʉhʉre dahra cohtepegʉ̃ta yʉhʉre ne ohoerari mʉhʉ. Ne ihcãquiro wahiquirogãre ne ohoerari mʉhʉ yʉhʉre yʉhʉ piti tiyequina mehna yʉhʉ bose deco dahreatire. ");
INSERT INTO pirNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Sa yero ahriquiro mʉhʉ macʉ pehe ñañequina numia mehna mʉhʉ yere ye site pehoñohti. Tire ye site peho tuhasa, wʉhʉpʉ tiquiro tojoa wihigʉ̃ dihi tiriquirogãre wecʉgãre wejẽ dutiñohti mʉhʉ tiquiro ihyatiquirore”, niahye tiquiro wahmino pehe pacʉrore. ");
INSERT INTO pirNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Macʉ, yʉhʉ mehna ijipihtiye decori mʉhʉ ijigʉ̃ ijipihtiye yʉhʉ cʉoye mʉhʉ ye ijire. ");
INSERT INTO pirNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Mʉhʉ bahʉ pehe yariariquiro yero saha wahari marine. Sa ye yojopʉre tiquiro catiriquiro ijire. Tiquiro butiriquiro yero saha ijiri. Tiquiro sa wahari bato yojopʉre tiquirore bocaʉ. Sa yero tiquiro tojoa wihigʉ̃ mari bose deco ye bucuegʉ̃ quehnoare”, niahye tiquiro macʉnore, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Sa ye ahri quitire tiquiro buheyequinare yahuahye Jesu: —‍Doeri cjẽ upʉro ye niñerure cohteriquiro niñerure quehnoano tiquiro ihboeragʉ̃ ihñano apequiro pehe yahusãhye doeri cjẽ upʉrore. “Mʉhʉ ye niñerure ye sitero nine”, ni yahusãhye tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Tiquiro yahusã tuhasari bato niñeru cohteriquirore pijioahye. Sa yero tiquiro wihigʉ̃ ihñano, tiquirore pʉhtoro yahuahye. “Yee niñerure mʉhʉ ye siterire apequiro yʉhʉre yahuri. Sa yegʉ yeere cohtegʉ iji nemosi mʉhʉ. Sa yegʉ yeere mʉhʉ yerire yahu peho ojoaya. Mʉhʉre cohãgʉ niaja”, niahye pʉhtoro tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Tiquiro sa nidi bato ohõ saha ni tʉhotuahye cohteriquiro tiquiro basi: “Yʉhʉ pʉhtoro yʉhʉre cohãno taro niaga. Yʉhʉ tutueraja. Sa yegʉ tutuaro dahra masiedaja. Sa yegʉ apequinare yʉhʉ niñerure sinigʉ̃ bʉoro yʉhdʉboaga yʉhʉ. ¿Sa yegʉ dʉhse yeitari yʉhʉ? ");
INSERT INTO pirNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Yojopʉ pũritare yʉhʉ yeatire masiaja yʉhʉ. Ohõ saha yʉhʉ yegʉ̃ yʉhʉ dahraye mariedagʉ̃ yʉhʉ pʉhtorore wapamoñequina yʉhʉre cahĩeta. Sa ye tiquina ye wʉhʉsepʉ sajã dutieta yʉhʉre”, ni tʉhotuahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Sa ni tʉhoturo tiquiro ijipihtiyequina tiquiro pʉhtorore wapamoñequinare pijioahye. Pijio tuhasa, cohteahye. Wihi mʉhtariquirore ohõ saha ni sinituahye tiquiro. “¿Yʉhʉ pʉhtorore noho puno wapamoajari mʉhʉ?” niahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Tiquiro sa nigʉ̃ wapamoriquiro pehe yʉhtiahye. “Cien tambores ʉhsere olivo dʉca mehna tiquina yeri ʉhsere wapamoaja tiquirore”, ni, yʉhtiahye. Tiquiro sa ni yahugʉ̃ cohteriquiro pehe ohõ saha ni yahuahye. “Ohõpʉ ijire mʉhʉ wapamonore ojoa ohõri pũ. Dujiya. Sa yegʉ mʉhʉ wapamonore deco mehna ne, deco mehna ojoa quehnoña”, niahye cohteriquiro wapamoriquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Sa ni tuhasa apequiro wapamoriquirore sinituahye tiquiro. “¿Mʉhʉ waro, noho puno wapamoajari?” niahye tja. “Cien ajuri trigo pjeri ajurire wapamoaja yʉhʉ”, niahye wapamoriquiro niñerure cohteriquirore. “Ohõpʉ ijire mʉhʉ wapamonore ojoa ohõri pũ. Mʉhʉ wapamonore ochenta ojoa quehnoña”, niahye cohteriquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Tiquiro sa quehnoano ni meho mihnigʉ̃ ihñano “Ahriquiro ni mehoriquiro quehnoano masidiquiro ijiaga”, ni tʉhotuahye tiquiro pʉhtoro niñerure cohteriquirore. Ahri deco cjẽna, Cohãcjʉ̃re cahmeeñequina tiquina yere quehnorire tiquina niñeru ihborire Cohãcjʉ̃ yequina yʉhdʉoro masiaga tiquina, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Sa ni tuhasa Jesu yahu nemoahye: —‍Sa yegʉ mʉsare niita niaja. Mʉsa cʉoyere, pejecʉoyequinare mʉsa ohogʉ̃, tiquina pehe mʉsare cahĩeta. Mʉsa sa yegʉ̃ mʉsa cʉoye pihtiari bato mʉsa ʉhmʉsepʉ esagʉ̃ mʉsare cahĩeta topʉre. ");
INSERT INTO pirNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Ihyo ijiyequina ye dahrayere poto yena, pʉhtoa ye dahraye gʉ̃hʉre poto yenata. Ihyo ijiyequina ye dahrayere queoro yerana, pʉhtoa ye dahraye gʉ̃hʉre queoro yesi mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Sa yena ahri yehpapʉ mʉsa cʉoye mehna mʉsa quehnoano yerana Cohãcjʉ̃ mʉsare tiquiro ye buheye gʉ̃hʉre quehnoano yesi mʉsa. Sa yero ti buheyere cũsi tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Sa yena apequiro yere mʉsa quehnoano ye basaeragʉ̃ ihñano mʉsa ye ijiatire ohosi mʉsare. ");
INSERT INTO pirNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Ihcãquiro Cohãcjʉ̃ pehere wacũno, tutua yʉhdʉaro niñeru pehere wacũedare. Niñeru pehere tutua yʉhdʉaro wacũno Cohãcjʉ̃ pehere wacũedare. Niñeru dihitare cahmediquiro ijiro Cohãcjʉ̃re bucuegʉ̃ yerare. Cohãcjʉ̃ gʉ̃hʉre, niñeru gʉ̃hʉre pʉarore cahme yʉhdʉdʉcaro basioerare mʉsare. Niñerure cahme yʉhdʉariquiro Cohãcjʉ̃re quehnoano ño peo masiedare, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Tiquiro sa nigʉ̃ tʉhoye fariseo masa pehe tiquirore bʉjʉpeahye. Tiquina pehe niñerure cahĩahye. Sa ye bʉjʉpeahye. ");
INSERT INTO pirNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Tiquina bʉjʉpegʉ̃ tʉhoro Jesu tiquinare yahuahye: —‍Masa tiquina ihñonore mʉsa quehnoano yemene. Mʉsa sa yegʉ̃ “Quehnoañequina, poto yeyequina ijire”, nimene masa mʉsare. Cohãcjʉ̃ pehe mʉsa tʉhotuyere masine. Masa “Quehnoa yʉhdʉare”, tiquina nidire Cohãcjʉ̃ pehe sijoro saha ni tʉhoture. Tire ihña yabire, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Sa ni tuhasa ohõ saha ni nemoahye Jesu: —‍Ñu wame yeriquiro tiquiro ijiato pano Moisere tiquiro cũri dutiye mehna Cohãcjʉ̃ marine dutiri. Cohãcjʉ̃ yere yahu mʉhtariquina tiquina ojoari mehna gʉ̃hʉ marine dutiri. Yojopʉ pehere Ñu tiquiro buhe dʉcari bato quehnoañe buheyere, Cohãcjʉ̃ tiquiro pʉhtoro ijiye gʉ̃hʉre masi dʉcare masa. Sa masiñe masa tiquina esa tuharo tiquina tutuaye mehna Cohãcjʉ̃ tiquiro pʉhtoro ijirore sajã duamene. ");
INSERT INTO pirNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Moisere tiquiro cũri dutiyepʉ Cohãcjʉ̃ nidiro sahata ye pehorota tiquiro. Ʉhmʉse gʉ̃hʉ ahri yehpa gʉ̃hʉ pihtia wahaepegʉ̃ta Cohãcjʉ̃ nidiro sahata ye pehorota, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Sa ni tuhasa ohõ saha ni nemoahye Jesu: —‍Masʉno tiquiro namonore cohãno, apecoro mehna omoca dʉhtero, ticoro mehna ñano yero nine. Apequiro tiquiro cohãricoro mehna omoca dʉhtero, tiquiro gʉ̃hʉ ticoro mehna ñano yero nine, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Sa ye queoye mehna yahuahye Jesu: —‍Ti pjepʉre doeri cjẽ upʉro ijie tiahye. Tiquiro suhti pehe wapa bʉjʉ yʉhdʉahye. Sa yero decoripe quehnoañe dihitare ihyaro, peye cʉoahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Sa yero ti pjere apequiro pejecʉoriquiro, Lázaro wame tiriquiro ijie tiahye. Tiquiro pagʉ peye cami tiriquiro ijiahye. Sa ye apequina pehe tiquirore doeri cjẽ upʉro ya wʉhʉ cjã sahrĩno cahapʉ ne sae tiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Sa yero pejecʉoriquiro pehe doeri cjẽ upʉro tiquiro ihyari mesa docapʉ yehpapʉ dujiro tiquiro ihya site dijioyere ihyae timahye. “Tiquiro ihya site dijiorire ihyagʉ yapigʉta yʉhʉ”, ni, tʉhotue timahye tiquiro. Sa ye diayea tiquiro camine nehneñe ahtae tiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","’Sa yero pejecʉoriquiro tiquiro yariaa wahagʉ̃, Abrahã cahapʉ paraíso wame tiropʉ angele tiquirore ne mʉjahye. Sa yero doeri cjẽ upʉro gʉ̃hʉ tiquiro batogãta yariaa wahahye. Tiquiro yariagʉ̃ tiquirore yahye. ");
INSERT INTO pirNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Sa yero doeri cjẽ upʉrore tutuaro peca ʉjʉ̃ahye. Sa yero pecapʉ ijiro ʉhmʉsepʉ ijiriquirore Abrahãre ihñahye. Lázaro gʉ̃hʉre ihñahye. ");
INSERT INTO pirNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ihña tuhasa, tiquiro Abrahãre pisuahye. “Yʉhʉ acayʉ Abrahã, paja ihñaña yʉhʉre. Pecapʉ yʉhʉ ñano yʉhdʉgʉ niaja. Yʉhʉ sa wahagʉ̃ Lázarore yʉhʉre ohoya. Sa yero acore tiquiro omo piriapʉ soha, yʉhʉ ñehmenore aco mehna nehono ahtaahro. Tire yʉsʉoahro tiquiro”, niahye doeri cjẽ upʉro. ");
INSERT INTO pirNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Tiquiro sa nigʉ̃ Abrahã tiquirore yahuahye: “Yʉhʉ acayʉ, catigʉpʉ mʉhʉ ijipihtiyere quehnoañene cʉori. Lázaro pehe decoripe ñano yʉhdʉri. Yojopʉ pehere mʉhʉ ñano yʉhdʉgʉ̃ tiquiro pehe ohõpʉre bucueye mehna ijiro nine. ");
INSERT INTO pirNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Sa ye mari watoa ʉhcʉãri cope ijire. Sa ye ohõre ijiyequina topʉre waha masiedare. Sa ye topʉ ijiyequina ohõpʉre ahta duayequina ahta masiedare”, niahye Abrahã doeri cjẽ upʉrore. ");
INSERT INTO pirNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Tiquiro sa nigʉ̃ doeri cjẽ upʉro ohõ saha ni nemoahye: “Yʉhʉ acayʉ, tutuaro siniaja mʉhʉre. Lázarore yʉhʉ pacʉ ya wʉhʉpʉ ohoya. ");
INSERT INTO pirNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Yʉhʉ ihcã omopequina bahana tii. Lázaro tiquinare yahuahro. Tiquina ohõre ñano yʉhdʉropʉre ahtaeracãhdo”, niahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Sa nigʉ̃ Abrahã pehe yʉhtiahye: “Cohãcjʉ̃ dutiyere Moise marine cũrire, Cohãcjʉ̃ yere yahu mʉhtariquina tiquina ojoarire cʉore mʉhʉ bahana. Sa ye mʉhʉ bahana tireta tʉhoahro”, niahye Abrahã. ");
INSERT INTO pirNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Tiquiro sa nigʉ̃ doeri cjẽ upʉro pehe yʉhtiahye: “Yʉhʉ acayʉ Abrahã, tire cʉoepeta quehnoano tʉhosi. Lázaro yariariquiro masa bajua, tiquina cahapʉ esagʉ̃ ihñañe tiquina pehe ñañene bʉjʉa witi, quehnoañe pehere camesaeta. Sa ye quehnoañene yeeta yʉhʉ bahana pehe”, niahye doeri cjẽ upʉro mʉnano. ");
INSERT INTO pirNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Tiquiro sa nigʉ̃ Abrahã pehe yahuahye: “Mʉhʉ bahana Moise cũri pũ tiquiro yahuyere, Cohãcjʉ̃ yere yahu mʉhtariquina mʉna tiquina yahuyere tʉho dueyequina ijire. Sa ye Lázaro yariariquiro mʉnano masa bajuepegʉ̃ta tiquina Cohãcjʉ̃re tʉho duasi”, niahye Abrahã, ni, yahuahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Sa ye Jesu yahuahye tiquiro buheyequinare: —‍Masare ñañe yegʉ̃ yeye peye ijire. Sa yeye masa ñañene yere. Ti sa ijiepegʉ̃ta masʉnore ñañene yegʉ̃ yeriquiro pehe ña yʉhdʉaro yʉhdʉrota. ");
INSERT INTO pirNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Masʉnore tiquiro wamʉapʉ pajiria ʉtãre dʉhte yo, pajiri mapʉ tiquirore cohãgʉ̃ ñano wahaboaga tiquiro. Apequiro pehe ahriquinagã mehna cjʉ̃nogãre ñañene yegʉ̃ yero pajiri mapʉ tiquina cohãriquiro yʉhdʉoro ñano yʉhdʉrota. Tiquirore tutuaro buhiri dahrero cahmene. ");
INSERT INTO pirNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Quehnoano yeya mʉsa. Mʉsa acayʉro ñano tiquiro yegʉ̃ ihñana “Yeracãhña”, niña tiquirore. Sa yena tiquiro ñañene bʉjʉa witigʉ̃, quehnoañene camesagʉ̃ mʉsa pehe tiquiro ñañe yeyere boya. ");
INSERT INTO pirNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Sa yero mʉsa acayʉro ihcã decota siete tahari mʉsare ñano tiquiro yegʉ̃ mʉsare tiquiro bo dutigʉ̃ boya. “Pari turi mʉhʉre ñano yesi”, siete tahari tiquiro nigʉ̃ tope taharita tiquiro ñano yerire boya, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Sa ye Jesu buheyequina tiquirore ohõ saha niahye: —‍Cohãcjʉ̃re ʉsãre quehnoano wacũ tutua nemogʉ̃ yeya, niahye tiquina Jesure. ");
INSERT INTO pirNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Tiquina sa nigʉ̃ Jesu yʉhtiahye: —‍Mostaza capegã meheni pjegã ijire. Ti yero saha Cohãcjʉ̃re mehenogã wacũ tutuana, ohõ saha wahagʉ̃ ye masinata mʉsa: Ahdʉ yucʉgʉre ohõ saha ni masine: “Mʉhʉ yucʉgʉ mʉhʉ basi duhtu cã, pajiri mapʉ bora ñojoaña”, ni masine mʉsa. Mʉsa sa nigʉ̃ tʉ yucʉgʉ pehe mʉsa dutiro sahata waharota, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Came ahri quitire yahuahye Jesu: —‍Mʉsare dahra cohteriquiro ijiro wesepʉ tanare. Sa yero ovejare ihña ihbore. ¿Dahra cohteriquiro tiquiro tojoa wihigʉ̃ dʉhse niboagari mʉsa tiquirore? ¿“Sojaro mehna ahtaya. Mʉhʉ ihyaye ohõpʉ ijire”, niboagari mʉsa? ");
INSERT INTO pirNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Sa niedare mʉsa. Tiquirore ohõ saha nine mʉsa: “Yʉhʉ ihyayere doha quehnoña. Sa yegʉ yʉhʉ ihya sihnigʉ̃ yʉhʉre cohteya. Yʉhʉ bato mʉhʉ gʉ̃hʉ ihya sihniña”, nine mʉsa dahra cohteriquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Dahra cohteriquiro mʉsa dutiyere tiquiro yegʉ̃ tiquirore “Quehnoare”, niedare mʉsa. Tiquiro dahraye dihitare yero niaga tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Mʉsa gʉ̃hʉ tiquiro yero saha ijire. Cohãcjʉ̃ dutiriro sahata ye pehona ohõ saha ni, tʉhotuya mʉsa. “Ʉsã gʉ̃hʉ dahra cohtena dihita ijiaja. Ihyo ijina ijiaja ʉsã. Ʉsã dahraye dihitare yei ʉsã”, ni, tʉhotuya mʉsa, niahye Jesu tiquiro buheyequinare. ");
INSERT INTO pirNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ape deco Jerusalẽpʉ Jesu waharo niahye. Topʉ waharo Samaria yehpa, Galilea yehpa, ti pʉa yehpa watoa yʉhdʉ cãhye. ");
INSERT INTO pirNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","13","Ape macapʉ wahari mahapʉ tiquiro tinigʉ̃ pʉa omopequina cami bʉcʉ mʉna wiha pehe tiquirore piti cahye. Sa ye yoa cjũnopʉ ducuye pisuahye: —‍Jesu, pʉhto, ʉsãre paja ihñaña, niahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Sa nigʉ̃ tiquinare ihña, yahuahye Jesu: —‍Pahire mʉsa pagʉrire quehnoañe pagʉri mʉsa waharire ihñona wahaya, niahye tiquinare. Sa nidi bato tiquina wahari watoa quehnoa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Sa yero ihcãquiro tiquina mehna cjʉ̃no quehnoano tiquiro pagʉ wahagʉ̃ ihñano, Jesu cahapʉ majare tojoa tahye. Sa tojoa taro tutuaro mehna Cohãcjʉ̃re ño peoahye. “Cohãcjʉ̃ tutuariquiro, quehnoariquiro ijire”, ni, ño peoahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Sa nino tiquiro Jesu dahpocãri caha dʉsepe curi mehna quehe sa, “Quehnoare”, niahye tiquiro. Samaria cjʉ̃no ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Tiquiro sa yeri bato Jesu ohõ saha ni sinituahye: —‍Pʉa omopequina ijiri masa quehnoa wahariquina. ¿Apequina nueve dʉhsayequina pehe nohopʉ ijiagari tiquina? ");
INSERT INTO pirNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ahriquiro ape yehpa cjʉ̃no dihita Cohãcjʉ̃re “Quehnoare”, nino taro tojoa tari. ¿Dʉhse ijiro boro apequina ahtaerajari? niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Sa ni tuhasa Jesu yahuahye dʉsepe curi mehna quehe sariquirore. —‍Wahcãdʉcaya. Wahaya. Mʉhʉ Cohãcjʉ̃re wacũ tutuagʉ, yʉhdʉre mʉhʉ, niahye Jesu tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ti pjere meheñequinagã fariseo masa Jesure sinituahye: —‍¿Dʉhse ijigʉ̃ Cohãcjʉ̃ pʉhtoro iji dʉcarotari? niahye tiquina. Tiquina sa nigʉ̃ Jesu yʉhtiahye: —‍Cohãcjʉ̃ tiquiro pʉhtoro iji dʉcagʉ̃ masa ihña masiedare. ");
INSERT INTO pirNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","“Cohãcjʉ̃ pʉhtoro ijiye ohõpʉ ijire”, ni masiedare. “Sohõpʉ ijire”, ni masiedare. Cohãcjʉ̃ tiquiro pʉhtoro ijiye masa tiquina tʉhotuyepʉ ijire, niahye Jesu fariseo masare. ");
INSERT INTO pirNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Sa ni tuhasa Jesu tiquiro buheyequinare ohõ saha ni yahuahye: —‍Came yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ ahri yehpapʉ yʉhʉ tojoa tatire tutuaro cahmenata mʉsa. Mehenogã yʉhʉre ihña duepenata yʉhʉre ihñasi mʉsa. Mʉsa yʉhʉre sa ihña duepegʉ̃ta ti pjere ahtasi yʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Apequina mʉsare ohõ saha nieta. “Tiquirore ihñaña. Cristo ijire. Ahriquirore ihñaña. Cristo ijire”, nieta mʉsare. Tiquina sa niepegʉ̃ta tiquinare tʉhoeracãhña. ");
INSERT INTO pirNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ʉpo miadoqueoro wacũeno mehna ti mia sitedoqueoro sahata yʉhʉ gʉ̃hʉ masʉ Cohãcjʉ̃ ohorigʉ wacũeno mehna tojoa taʉtja. ");
INSERT INTO pirNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ahrire yʉhʉ yeato pano yʉhʉ tutuaro ñano yʉhdʉta. Sa ye yojopʉ cjẽna yʉhʉre cahmesi. ");
INSERT INTO pirNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Noé tiquiro ijiri pje cjẽna tiquina ijiriro sahata yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ yʉhʉ tojoa tagʉ̃ sata ijieta masa. ");
INSERT INTO pirNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noé tiquiro ijiri pjere ijipihtiyequina masa sa ihyaducue tiahye. Sa ye sihniducue tiahye. Ʉmʉa, numia mehna omoca dʉhtee tiahye. Noé pajiria yucʉsapʉ tiquiro sajãto pano Cohãcjʉ̃ tiquinare tiquiro mioato pano ti ijipihtiyere masa yeducue tiahye. Sata ijirota yʉhʉ tojoa tagʉ̃ gʉ̃hʉre. ");
INSERT INTO pirNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Lote tiquiro ijiri pje cjẽna tiquina ijiriro sahata yʉhʉ tojoa tagʉ̃ ijieta masa. Lote tiquiro ijie tiri pjere masa ihya, sihni, dú, dua, weserire ote, wʉhʉse yeahye. ");
INSERT INTO pirNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Tiquina sa yeri watoa Sodoma wame tiri macapʉ ijiriquiro Lote tiquiro wahari deco ʉhmʉse cjã peca, peca asiye paca ʉtã pjeri gʉ̃hʉ acoro ahtaro saha tiquina bui bora pje, tiquinare wejẽ pehoe tiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ wacũeno mehna yʉhʉ tojoa tagʉ̃ tiquina yero sahata yeyequina ijieta masa ti pjere. ");
INSERT INTO pirNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Ti pjere ihcãquiro tiquiro ya wʉhʉ bui cjã paapʉ quehnoari paapʉ ijiriquiro wʉhʉ puhiapʉ tiquiro ye ijigʉ̃ tire neno wahaeracãhdo tiquiro sojaro mehna wahato saha. Sa yero wesepʉ ijiriquiro gʉ̃hʉ ti pjere tiquiro ya wʉhʉpʉ piheracãhdo tiquiro sojaro mehna wahato saha. ");
INSERT INTO pirNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lote namono ticoro waharire wacũña mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Masʉno yʉhʉre wacũno marieno tiquiro esa tuharo tiquiro cahmeno saha yero, pecapʉ waharota. Sa yero yeere sa yeducuriquiro ijipihtiye decori yʉhʉ mehna ʉhmʉsepʉ ijirota. ");
INSERT INTO pirNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Ti ñamine pʉaro ihcã cuñanopʉ carĩñequinare ihcãquiro yʉhʉre cahmeniquirore neitja. Sa yero yʉhʉre cahmedariquiro topʉ tojoarota. ");
INSERT INTO pirNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ti pjere pʉaro numia ihcãnopʉ tiquina trigore tu mʉtoñe numiare ihcãcoro yʉhʉre cahmenicorore neitja. Sa yero yʉhʉre cahmedaricoro topʉta tojoarota. ");
INSERT INTO pirNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Sa ye wesepʉ pʉaro dahrayequina tiquina ijigʉ̃ ihcãquirota neitja. Ihcãquiro topʉ tojoarota, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Sa nigʉ̃ tiquiro buheyequina pehe sinituahye tiquirore. —‍¿Nohopʉ sa waharotari? ni sinituahye tiquina. Tiquina sa nigʉ̃ Jesu yʉhtiahye: —‍Masa tiquina ñano yeducuriropʉ, topʉ Cohãcjʉ̃ buhiri dahrerota tiquinare, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Sa ye Jesu tiquinare Cohãcjʉ̃re siniñene yahuro ohõ saha niahye: —‍Mʉsa Cohãcjʉ̃re sinina, cohteya tiquiro yʉhtiatire. Yoari pje cohtepenata bʉjʉa witieracãhña. Tiquirore sinina duhueracãhña, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Tiquiro sa nidire buhero taro ahri queoye mehna yahuahye tiquinare: —‍Ape macapʉ tiquina buhiri dahre dutiriquiro ijiahye. Tiquiro Cohãcjʉ̃re ño peoerahye. Sa yero masa gʉ̃hʉre ño peoerahye. ");
INSERT INTO pirNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Sa yero wape wihoro gʉ̃hʉ topʉ ijiahye. Ticoro tiquiro cahapʉ sa majareno ohõ saha niahye: “Yʉhʉre ihña tuhtiriquirore buhiri dahre dutiya mʉhʉ. Yʉhʉre ni cahmota basaya”, ni siniducuahye ticoro tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ticoro sa nigʉ̃ peye tahari tiquiro “Yesi yʉhʉ”, nimahye ticorore. Tiquiro sa niepegʉ̃ta ticoro peye tahari sa siniducuro tiquirore ni cariboro ye cãmahye. Ticoro caribogʉ̃, ohõ saha niahye tiquiro basi. “Yʉhʉ Cohãcjʉ̃re, masa gʉ̃hʉre ño peoeraja. ");
INSERT INTO pirNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Yʉhʉ sa ño peoegʉ yʉhʉ ijiepegʉ̃ta ahricoro pehe yʉhʉre caribo ye cãmaga. Yʉhʉre sa cariboro yʉhʉre caributigʉ̃ yerota ticoro. Sa ni yahusãducugʉ̃ ticorore ihña tuhtiriquirore buhiri dahre dutiitja”, niahye buhiri dahre dutiriquiro, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Sa nino Jesu tiquinare yahu nemoahye: —‍Sa niahye ñariquiro buhiri dahre dutiriquiro. Tiquiro nidire wacũña mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Tiquiro yʉhdʉoro Cohãcjʉ̃ pehe tiquiro yequina tiquiro beseriquinare ñamipʉ, decopʉ tiquirore sinidiquinare yʉhtiro, yedohorota. ");
INSERT INTO pirNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Mʉsare niita niaja. Cohãcjʉ̃re tiquina sinidiro sahata duita tiquinare yedohorota. ¿Tiquiro sa yʉhtiriquiro ijiepegʉ̃ta yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ ahri yehpapʉ tojoa tagʉ Cohãcjʉ̃re wacũ tutuayequinare bocaboagari yʉhʉ? niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Sa ye apeye quiti mehna ohõ saha ni yahuahye Jesu: “Ʉsã pehe quehnoana ijiaja. Apequina pehe ñano yeyequina ijire”, ni, tʉhotuyequinare ahri quitire yahuahye: ");
INSERT INTO pirNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—‍Cohãcjʉ̃ ya wʉhʉpʉ pʉaro ʉmʉa Cohãcjʉ̃re siniñe wahahye. Ihcãquiro fariseo masʉno ijiahye. Apequiro wapa ne cohteriquiro ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Sa yero fariseo masʉno pehe ducu, ohõ saha ni yahuahye Cohãcjʉ̃re: “Yʉhʉ yaquerigʉ, ñañene yerigʉ, numia mehna ñano yerigʉ ijieraja. Apequina yero saha ijieraja. Ahriquiro wapa ne cohteriquiro yero saha ñagʉ ijieraja. Sa yegʉ mʉhʉre ‘Quehnoare’, niaja Cohãcjʉ̃. ");
INSERT INTO pirNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Yʉhʉ semanaripe pʉa decore mʉhʉ yere yegʉ sijiaja. Sa yegʉ pʉa omope cjoeri niñeru cjoerire wapatagʉ ihcã cjoere mʉhʉre ohoaja”, niahye fariseo masʉno Cohãcjʉ̃re. ");
INSERT INTO pirNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Sa yero wapa ne cohteriquiro pehe yoaropʉ muhri yo ducu, tiquiro ñañene bʉjʉa witi, ʉhmʉsepʉre ihñedahye. Tiquiro ñañene bʉjʉa witiriquiro ijiro tiquiro cutirore quẽ ohõ, siniahye Cohãcjʉ̃re: “Cohãcjʉ̃, yʉhʉ ñagʉ ijiaja. Sa yegʉ mʉhʉ paja ihñaña yʉhʉre”, niahye tiquiro Cohãcjʉ̃re. ");
INSERT INTO pirNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Mʉsare niita niaja. Ahriquiro wapa ne cohteriquiro pehere tiquiro ya wʉhʉpʉ tojoagʉ̃ Cohãcjʉ̃ pehe “Mʉhʉ ñañene cohã tuhasaʉ”, niahye tiquirore. Apequiro fariseo masʉnore “Mʉhʉ ñañene cohãʉ”, niedahye Cohãcjʉ̃. “Yʉhʉ quehnoagʉ ijiaja”, nidiquiro Cohãcjʉ̃ ihñagʉ̃ ñariquiro ijire. “Yʉhʉ ñagʉ ijiaja. Sa yegʉ yee ñañene bʉjʉa witiaja”, nidiquirore Cohãcjʉ̃ quehnoariquiro ijigʉ̃ yerota tiquirore, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Sa ye masa tiquina pohnene macanagãre Jesure ña peo dutiye tehe, tiquiro cahapʉ ne wihiahye. Tiquina sa yegʉ̃ ihñañe Jesu buheyequina tiquinagãre ne wihiyequinare tuhtiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Tiquina sa tuhtigʉ̃ ihñano Jesu macanagãre pijioahye tiquiro cahapʉ. Pijio tuhasa ohõ saha niahye tiquiro buheyequinare: —‍Macanagã yʉhʉ cahapʉ ahtaahro. “Waharĩsa”, niedacãhña tiquinagãre. Tiquinagã Cohãcjʉ̃re tiquina pʉhtoro tʉhoture. Sa ye Cohãcjʉ̃ pʉhtoro ijiropʉre ahriquinagã yero sahata tʉhotuyequina ijire topʉre. ");
INSERT INTO pirNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Potota niita niaja mʉsare. Ahriquinagã Cohãcjʉ̃re tiquina cahmeno saha mʉsa pehe cahmedana, tiquiro cahapʉ wahasi mʉsa. Mʉsa wahaeragʉ̃ mʉsa pʉhtoro ijisi tiquiro, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Tiquiro sa nidi bato judio masa pʉhtoa mehna cjʉ̃no Jesure sinituahye: —‍¿Ne, quehnoagʉ, buhegʉ, ijipihtiye decori Cohãcjʉ̃ mehna iji duagʉ, dʉhse yeboagari yʉhʉ? niahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Tiquiro sa nigʉ̃ Jesu yʉhtiahye: —‍¿Dʉhse ijiro boro yʉhʉre “Quehnoagʉ”, ni pisuajari mʉhʉ? Cohãcjʉ̃ dihita quehnoariquiro ijire. ");
INSERT INTO pirNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ahri Cohãcjʉ̃ dutiyere masine mʉhʉ. “Wʉana tieracãhña. Masare wejẽdacãhña. Yaqueracãhña. Ni mehoedacãhña. Mʉsa pacʉsʉmʉare ño peoya”, ni, sa ye dutire Cohãcjʉ̃. Sa yegʉ tire yeya mʉhʉ, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Tiquiro sa nigʉ̃ Jesure yʉhtiahye: —‍Tire ijipihtiyere yʉhʉ coã wahmʉa cãhtagʉ ijigʉpʉta yʉhdʉdʉcaerahti, niahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Tiquiro sa nigʉ̃ tʉhoro, Jesu tiquirore ohõ saha ni yahuahye: —‍Mehenogã dʉhsare mʉhʉre mʉhʉ ye pehoati. Ijipihtiyere mʉhʉ yere duagʉ wahaya. Sa yegʉ ijipihtiye mʉhʉ wapatari niñerure pejecʉoyequinare ohoya. Mʉhʉ sa yegʉ̃ peye mʉhʉ ye ʉhmʉsepʉ, Cohãcjʉ̃ cahapʉ ijirota. Sa ye tuhasagʉ yʉhʉ mehna cjʉ̃ ijiacjʉ ahtaya, niahye Jesu tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Tiquiro sa nigʉ̃ tʉhoro tiquiro pehe peye doeri cjẽ cʉoriquiro ijiro tire pejecʉoyequinare oho dueraro, tutuaro bʉjʉa witi, wahaa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Tiquiro sa bʉjʉa witigʉ̃ ihñano Jesu ohõ saha ni yahuahye apequinare: —‍Doeri cjẽ opana Cohãcjʉ̃ tiquiro pʉhtoro ijiropʉre tiquinare waharo basioera cjũre. ");
INSERT INTO pirNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Camello pehe awia copepʉ tiquiro sajã duagʉ̃ basioerare tiquirore. Tiquiro sa ijiro yʉhdʉoro doeri cjẽ upʉro Cohãcjʉ̃re cahmedaro, Cohãcjʉ̃ tiquiro pʉhtoro ijiropʉre waharo basioerare, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Tiquiro sa nigʉ̃ tiquirore tʉhoyequina ohõ saha niahye: —‍Aa, dʉhse tiquiro nino saha poto ijigʉ̃, ne ihcãquiro masʉno Cohãcjʉ̃ cahapʉ waha masiedaboaga, niahye tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Tiquina sa nigʉ̃ Jesu yʉhtiahye: —‍Masa tiquina esa tuharo quehnoano yeri mehna Cohãcjʉ̃ cahapʉ waha masiedare. Cohãcjʉ̃ pehe masare pecapʉ wahaboriquinare yʉhdʉo masine. Tiquiro ijipihtiyere quehnoano ye masi peho cãre, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Tiquiro sa nigʉ̃ Pedro tiquirore ohõ saha niahye: —‍Tʉhorĩña. Ʉsã pehe ijipihtiye ʉsã yere cũ cãʉ mʉhʉ mehna wahana, niahye tiquiro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Tiquiro sa nigʉ̃ Jesu ohõ saha niahye: —‍Potota mʉsare niita niaja. Mʉsa Cohãcjʉ̃ yere yena tana mʉsa wʉhʉsere, mʉsa pacʉsʉmʉare, mʉsa bahanare, mʉsa namosãnumiare, mʉsa pohnare cũrina ijina pajiro wapatanata mʉsa yojopʉre. ");
INSERT INTO pirNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Mʉsa cũri yʉhdʉoro wapatanata. Sa yena mʉsa yariari bato ijipihtiye decori Cohãcjʉ̃ mehna ijinata mʉsa, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Sa ye Jesu doce tiquiro buheyequinare neahye. Sa neano tiquinare yahuahye: —‍Tʉhoya yʉhʉre. Yojopʉre mari Jerusalẽpʉ wahana niaja. Topʉ yʉhʉre masʉre Cohãcjʉ̃ ohorigʉre Cohãcjʉ̃ yere yahu mʉhtariquina panopʉ tiquina yahuriro sahata sa yeeta yʉhʉre. ");
INSERT INTO pirNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Topʉ masa yʉhʉre ñeheñe, judio masa ijieyequinare ohoeta yʉhʉre. Yʉhʉre tiquina ohori bato tiquina yʉhʉre bʉjʉpe, ñano ni, yʉhʉre sihco puti ohõeta. ");
INSERT INTO pirNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Sa ye yuta dari mehna tana tuhasa wejẽeta yʉhʉre. Sa yegʉ ihtia deco wahaboro masa wijiagʉta yʉhʉ, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Tiquiro sa ni yahurire quehnoano masiedahye tiquiro buheyequina. Cohãcjʉ̃ tire tiquinare quehnoano masigʉ̃ yeraniahye. ");
INSERT INTO pirNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Sa ye Jesu gʉ̃hʉ Jericó wame tiri maca cahagãpʉ esahye. Topʉ caperi bajueriquiro maha dʉhtʉ caha duji, niñeru sinino niahye. ");
INSERT INTO pirNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Sa yero masa peyequina tiquiro caha yʉhdʉagʉ̃ tʉhoro sinituahye tiquinare: —‍¿Dʉhse ijiro boro masa peyequina yʉhdʉajari? ni sinituahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","—‍Jesu Nazare cjʉ̃no waharo nine, ni, yahuahye apequina tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Tiquina sa ni yahugʉ̃ tʉhoro tiquiro sañuducuahye: —‍Jesu, Davi mʉnano panami iji turiagʉ, masare yʉhdʉoacjʉ, yʉhʉre paja ihñaña, ni sañuducuahye Jesure. ");
INSERT INTO pirNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Tiquiro sa nigʉ̃ tiquiro caha ihñaducuyequina pehe, “Dihta mariahña”, ni tuhtiahye tiquirore. Tiquina sa ni tuhtiepegʉ̃ta to pano tiquiro sañuducuriro yʉhdʉoro sañuducu nemoahye tja: —‍Davi mʉnano panami iji turiagʉ, masare yʉhdʉoacjʉ, yʉhʉre paja ihñaña, ni sañuducuahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Tiquiro sa ni sañuducugʉ̃ tʉhoro, Jesu pehe esadʉca, “Pijioya tiquirore”, niahye. Tiquiro sa nigʉ̃ tiquina pehe caperi bajueriquirore piji cãhye. Tiquina sa piji cãgʉ̃ Jesu cahapʉ esagʉ̃ Jesu pehe tiquirore sinituahye: ");
INSERT INTO pirNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—‍¿Dʉhse yʉhʉ yegʉ̃ cahmeajari mʉhʉ? niahye Jesu. —‍Yʉhʉ pʉhto, yʉhʉre ihñagʉ̃ yeya, ni yʉhtiahye caperi bajueriquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","—‍Ihñaña. Yʉhʉre wacũ tutuagʉ, quehnoa wahare mʉhʉ, niahye Jesu tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Tiquiro sa nigʉ̃ta caperi bajueriquiro ihñaa wahahye. Sa quehnoa waharo, tiquiro Jesu mehna wahahye. “Cohãcjʉ̃ tutuariquiro ijire”, niahye tiquiro. Sa ye masa peyequina caperi bajueriquiro ihñagʉ̃ ihñañe “Cohãcjʉ̃ quehnoariquiro, tutuariquiro ijire”, niahye tiquina gʉ̃hʉ. ");
INSERT INTO pirNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Sa ye Jesu Jericópʉ esa, ti macapʉ yʉhdʉ cãno taro niahye. ");
INSERT INTO pirNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Doeri cjẽ upʉro Zaqueo wame tiriquiro wapa ne cohteyequina pʉhtoro topʉ ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Sa yero tiquiro Jesure “¿Diquiro boro ijiagari?” ni ihña masino taro Jesure ihña duamahye. Sa tiquiro ihña duepegʉ̃ta ʉhmʉediquirogã ijigʉ̃ masa peyequina tiquirogãre cahmotahye. ");
INSERT INTO pirNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Sa yero tiquiro masare oma yʉhdʉ cã, sicómoro wame tidʉ yucʉgʉpʉ mʉjahye Jesure ihñano taro. Came cjũnogã tʉ cahapʉ Jesu yʉhdʉaro taro niahye. Sa yero Zaqueo tʉpʉ cohtero niahye. ");
INSERT INTO pirNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Tiquiro sa cohte pesari watoa Jesu pehe tʉ dahpotopʉ esadʉca, Zaqueore ihña mʉo, tiquirore pisuahye: —‍Zaqueo yojopʉre mʉhʉ ya wʉhʉpʉ tojoagʉtja. Sa yegʉ sojaro mehna dijia taya, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Tiquiro sa nigʉ̃ Zaqueo pehe sojaro mehna dijia ta, tutuaro bucueye mehna tiquiro ya wʉhʉpʉ waha dutiahye Jesure. ");
INSERT INTO pirNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tiquiro sa piti cagʉ̃ ihñañe, ijipihtiyequina masa tiquina basi ohõ saha ni yahuducuahye: —‍Ahriquiro Jesu ñariquiro ya wʉhʉpʉ tinino waha duare, ni, yahuducuahye ijipihtiyequina tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zaqueo pehe piti ca tuhasa topʉ ducuro, Jesure yahuahye: —‍Pʉhto, tʉhoya yʉhʉre. Ijipihtiye yeere deco mehna pejecʉoyequinare ohoutja. Sa yegʉ yʉhʉ apequirore cien niñeru cjoerire ni meho ehmarigʉ ijigʉ, cuatro cientos niñeru cjoerire wapa ye bui peoutja tiquirore, niahye Zaqueo Jesure. ");
INSERT INTO pirNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Tiquiro sa nigʉ̃ Jesu pehe yahuahye tiquirore: —‍Miare mʉhʉre mʉhʉ ya wʉhʉpʉ ijiyequina gʉ̃hʉre pecapʉ wahaboriquinare Cohãcjʉ̃ yʉhdʉo tuhasare. Mʉhʉ gʉ̃hʉ Abrahã mʉnano acayʉ ijire. ");
INSERT INTO pirNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ pecapʉ wahaboriquinare macagʉ ahtagʉ nii. Topʉ wahaboriquinare quehnoano yʉhdʉogʉ ahtagʉ nii, niahye Jesu Zaqueore. ");
INSERT INTO pirNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Sa ye tiquirore tʉhoyequinare Jesu apeye queoye mehna yahuahye. Mehenogã dʉhsahye Jerusalẽpʉ tiquiro esato. Sa ye tiquirore tʉhoyequina ohõ saha ni tʉhotuahye: “Cohãcjʉ̃ pʉhtoro yojopʉre iji dʉcaro taro nine”, ni, tʉhotuahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Tiquina sa ni tʉhotugʉ̃ Jesu yahuahye tiquinare: —‍Ihcãquiro pʉhtoro macʉno pʉhtoro sajãtiquiro yoaropʉ ape yehpapʉ waharo taro niahye. Topʉre esagʉ̃ ihñano tiquina tiquirore pʉhtoro sõñe tee niahye. Came tiquiro ya wʉhʉpʉ tojoa wihiro taro niahye. ");
INSERT INTO pirNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Coã warore tiquiro wahato panore pʉhtoro pʉa omopequina dahra cohteyequinare pijioahye. Sa pijioro, tiquiro tiquinare tiquinape cjoeri niñeru cjoeri wapa bʉjʉye cjoeri uru cjoerire ohoahye. Oho tuhasa, yahuahye tiquinare: “Yʉhʉ mariedagʉ̃ ahri niñeru mehna mʉsa wapata nemoatire macaña”, niahye tiquiro dahra cohteyequinare. ");
INSERT INTO pirNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Sa ye tiquiro ya maca cjẽnata tiquirore cahmedahye. Sa cahmedaye, apequinare tiquirore pʉhtorore yahu dutiye ohoahye. “Mʉhʉ ʉsã pʉhto ijigʉ̃ cahmedaja ʉsã”, niahye tiquina yahu dutiriquina pehe. ");
INSERT INTO pirNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Sa tiquina cahmedapegʉ̃ta came tiquina pʉhtoro sajãhye tiquiro. Pʉhtoro sajã tuhasa tiquiro ya wʉhʉpʉ tojoa tahye. ’Sa tojoa wihiro dahra cohteyequinare tiquiro ye niñeru mehna tiquina wapata nemorire masino taro, tiquinare pijioahye. ");
INSERT INTO pirNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Tiquiro pijiori bato, wihi mʉhtariquiro tiquirore yahuahye: “Pʉhto, mʉhʉ niñeru cjoe, yʉhʉre mʉhʉ ohori cjoe mehna pʉa omope cjoeri wapata nemou yʉhʉ”, niahye dahra cohteriquiro pʉhtorore. ");
INSERT INTO pirNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Quehnoano yeaya mʉhʉ. Mʉhʉ quehnoagʉ dahra cohtegʉ ijire. Mʉhʉ mehenogã mehna yʉhʉ dutiriro sahata ye pehogʉ ijigʉ yojopʉ pʉa omope macari cjẽna tiquina pʉhto ijiacjʉ wahagʉta mʉhʉ”, niahye pʉhtoro dahra cohteriquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Tiquiro bato wihiriquiro tiquiro mehna cjʉ̃no ohõ saha niahye: “Pʉhto, mʉhʉ ya cjoe niñeru cjoe yʉhʉre mʉhʉ ohori cjoe mehna ihcã omope cjoeri wapata nemou yʉhʉ gʉ̃hʉ”, ni yahuahye tiquiro pʉhtorore. ");
INSERT INTO pirNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Ihcã omope macari cjẽna pʉhto ijiacjʉ wahagʉta mʉhʉ”, niahye pʉhtoro tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Tiquiro sa nidi bato apequiro dahra cohteriquiro wihi, yahuahye: “Pʉhto, mʉhʉ niñeru cjoe ohõ ijire. Suhtiro cahsero mehna coma, ti cjoere ihbou. ");
INSERT INTO pirNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mʉhʉ tutuaro dahra dutigʉ ijire. Sa tutuaro dahra dutigʉ ijigʉ mʉhʉ basi oterapegʉta ti dʉcare nene mʉhʉ. Sa yegʉ mʉhʉre cue nii”, niahye tiquiro pʉhtorore “Ti cjoe mehna wapataerʉ yʉhʉ”, ni yahuro. ");
INSERT INTO pirNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Tiquiro sa nigʉ̃ tiquiro pʉhtoro ohõ saha niahye: “Mʉhʉ sa nigʉ ñagʉ ijire mʉhʉ. Yʉhʉre mʉhʉ sa nidi buhiri mʉhʉre buhiri dahregʉtja yʉhʉ. Yʉhʉ mʉhʉre tutuaro dahra dutigʉ yʉhʉ ijigʉ̃ masine mʉhʉ. Apequina yere yʉhʉ negʉ̃ yʉhʉ oterarigʉ ijiepegʉta dʉcare negʉ yʉhʉ ijigʉ̃ masine mʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Yʉhʉ sa ijigʉ̃ ihñaepegʉta ya cjoere niñeru ihbori wʉhʉpʉ cũedahya mʉhʉ. Tire tiquina wasori wapa wapata nemoboaya mʉhʉ. ¿Dʉhsegʉ sa yerari mʉhʉ? Tire mʉhʉ yegʉ̃ tojoa wihigʉ wapata nemoboaya yʉhʉ”, niahye tiquina pʉhtoro. ");
INSERT INTO pirNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Sa ni tuhasa tiquiro cahapʉ ducuyequinare dutiahye: “Niñeru cjoere ehmaña tiquirore. Pʉa omope cjoerire cʉoriquirore ohoya”, niahye pʉhtoro. ");
INSERT INTO pirNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Tiquiro sa nigʉ̃ tiquina pehe yahuahye tiquirore: “Pʉhto, pʉa omope cjoeri cʉoriquiro peye cʉo tuhasare”, niahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Tiquina sa nigʉ̃ pʉhtoro yʉhtiahye: “Mʉsare niita niaja. Ijipihtiyequina cʉoyequinare oho nemoutja. Cʉoeriquiro pehere mehenogã tiquiro cʉoepegʉ̃ta tire ehmagʉtja. ");
INSERT INTO pirNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Yojopʉ pũritare yʉhʉre ihña tuhtiyequinare yʉhʉre tiquina pʉhtoro iji dutierariquinare yʉhʉ cahapʉ ne cãhtaya. Sa yena yʉhʉ ihñonopʉ wejẽña tiquinare”, niahye pʉhtoro dahra cohteyequinare, ni, buheahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Sa ni tuhasa Jesu apequina pano Jerusalẽpʉ wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Tiquiro Betfagé wame tiri maca cahapʉ Betania wame tiri maca cahapʉ esa, cʉnʉ Olivo wame tidʉ cahapʉ esa mʉhtahye. Jerusalẽpʉ tiquiro esato mehenogã dʉhsatjiãhye. Sa yero pʉaro tiquiro buheyequinare Jesu ohoro ohõ saha niahye: ");
INSERT INTO pirNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—‍Si macapʉ burrogãre nena wahaya. Topʉ esana, burrogãre tiquina dʉhte docoriquirogãre boca sanata. Apequina pesamehnediquirogã ijiaga. Tiquirogãre bocana, yuta dare pã, ne cãhta basaya yʉhʉre. ");
INSERT INTO pirNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Mʉsa sa yegʉ̃ ihñano, burrogã upʉro “¿Dʉhsena burrogãre pãjari?” tiquiro nigʉ̃ tʉhona ohõ saha ni yʉhtiya tiquirore: “Mari pʉhtoro burrogãre cahmedoqueo nidi”, ni, yahuya tiquirore, ni yahu duti ohoahye tiquiro buheyequinare pʉarore. ");
INSERT INTO pirNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Tiquiro sa nigʉ̃ tiquina pʉaro pehe tiquiro nidiropʉ esahye. Tiquina sa esagʉ̃ ijipihtiye Jesu tiquiro nidiro sahata ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Sa ye tiquirogãre tiquina pãgʉ̃ ihñañe tiquirogã opana tiquinare sinituahye: —‍¿Dʉhse yena tana mʉsa yuta dare pãjari burrogãre? ni, sinituahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","—‍Mari pʉhtoro burrogãre cahmedoqueo nidi, ni yʉhtiahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Sa ni yahu tuhasa tiquirogãre Jesu cahapʉ ne sahye. Ne sa tuhasa tiquina bui cjẽ suhtire tiquirogã bui seõ peo, tiquirogã buipʉ Jesu mʉja pjegʉ̃ yedohoahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jesu tiquirogã bui pesagʉ̃ tiquiro wahato pano masa tiquina bui cjẽ suhtire tu we ne, mahapʉ seõ cũ mʉhtahye Jesure ño peoye. ");
INSERT INTO pirNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Sa ye tiquina Jerusalẽ cahagãpʉ esa, Olivo wame tidʉpʉ dijia tari mahapʉ esahye. Topʉ Jesu buhegʉ̃ tʉhoyequina peyequina ijipihtiye Cohãcjʉ̃ tutuaye mehna tiquiro ye ihñorire, tiquiro quehnoañe yerire tiquina ihñarire wacũñe, Cohãcjʉ̃re “Quehnoagʉ, tutuagʉ ijire”, ni sañuducuahye. Sa ye tutuaro sañuducu, Cohãcjʉ̃re ño peoye, ohõ saha niahye: ");
INSERT INTO pirNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","—‍Ahriquiro Cohãcjʉ̃ tiquiro ohoriquirore, mari pʉhtorore Cohãcjʉ̃ quehnoano yeahro. Ʉhmʉse cjẽna quehnoano ijiahro. Cohãcjʉ̃ tiquiro tutuariquiro ijigʉ̃ ijipihtiyequina masiahdo, ni ño peoahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Tiquina sa nigʉ̃ tʉhoye fariseo masa meheñequinagã tiquina watoa ijiyequina Jesure yahuahye: —‍Buhegʉ, mʉhʉ buheyequinare dihta maria dutiya, niahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","—‍Mʉsare niita niaja. Tiquina sañuducueragʉ̃ ʉtã paca pari pehe sañuducuboaga, niahye Jesu fariseo masare. ");
INSERT INTO pirNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Sa ni tuhasa Jesu Jerusalẽ cahagãpʉ esa, ti macare ihñano, utiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ohõ saha niahye tiquiro: —‍Jerusalẽ cjãna yojopʉ pũritare mʉsare pecapʉ wahaborinare Cohãcjʉ̃ tiquiro yʉhdʉoatire mʉsa masigʉ̃ quehnoa yʉhdʉaboaga. Sa ijiepegʉ̃ta yojopʉre mʉsa tire ne tʉho duerare. Sa yero Cohãcjʉ̃ tire mʉsare masi dutierare. ");
INSERT INTO pirNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Mʉsare ihña tuhtiyequina mʉsa ijiri macare cahmota sotoa peho quẽheeta. Sa ye, mʉsare tiquina wijia dutisi. ");
INSERT INTO pirNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ti pjeta tiquina mʉsa ya macare cohã pehoeta. Mʉsa gʉ̃hʉre wejẽeta. Mʉsare ihña tuhtiyequina quehnoano cohã pehoeta mʉsa ya macare. Cohãcjʉ̃ pecapʉ wahaborinare mʉsare tiquiro yʉhdʉoatire mʉsa masi duerari. Mʉsa masi duerari buhiri mʉsare ihña tuhtiyequinare Cohãcjʉ̃ mʉsare cohã dutirota, niahye Jesu Jerusalẽ cjẽnare. ");
INSERT INTO pirNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Sa ye Jerusalẽpʉ esaro, Jesu Cohãcjʉ̃ wʉhʉpʉ sajãa wahahye. Sa yero apee boro duayequinare ti wʉhʉpʉ ijiyequinare boca saro, tiquinare cohã wio cãhye. Ohõ saha niahye tiquinare: ");
INSERT INTO pirNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","—‍Cohãcjʉ̃ yere tiquina ojoari pũpʉ ohõ saha nine: “Ya wʉhʉ Cohãcjʉ̃ mehna yahuducuri wʉhʉ wame tirota”, niahye tiquiro yere tiquina ojoari pũpʉ. Tiquiro sa niepegʉ̃ta mʉsa pehe ahri wʉhʉpʉ duana, mʉsa basi cahme yaquere mʉsa, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Sa ye decoripe Cohãcjʉ̃ wʉhʉpʉ Jesu buheahye. Sa ye pahia pʉhtoa, judio masare buheyequina, masa pʉhtoa gʉ̃hʉ tiquirore tiquina wejẽatire wacũ macahye. ");
INSERT INTO pirNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Masa ijipihtiyequina tiquirore sa tʉhoducuye, tiquiro buheyere quehnoano tʉho nʉnʉñequina ijiahye. Tiquina sa quehnoano tʉho nʉnʉgʉ̃ Jesure wejẽ duayequina pehe tiquirore tiquina wejẽatire bocaerahye. ");
INSERT INTO pirNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ape deco Cohãcjʉ̃ wʉhʉpʉ Jesu masare quehnoañe buheyere buhero niahye. Tiquiro sa buhegʉ̃ pahia pʉhtoa, judio masare buheyequina, bʉcʉna mehna tiquiro cahapʉ wihiye, sinituahye: ");
INSERT INTO pirNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","—‍Yahuya ʉsãre. ¿Dʉhsegʉ canʉre sa yeari mʉhʉ? ¿Noa mʉhʉre tire sa ye dutiari? niahye tiquina Jesure. ");
INSERT INTO pirNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Tiquina sa nigʉ̃ Jesu yʉhtiahye tiquinare: —‍Mʉsa pehere sinitu mʉhtagʉtja. Yahuya yʉhʉre. ");
INSERT INTO pirNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Ñu masare tiquiro wame yegʉ̃ noa boro pehe tiquirore wame ye dutiyari, mʉsa tʉhotugʉ̃? ¿O Cohãcjʉ̃ dutierayari? ¿O masa pehe dutiyari, mʉsa tʉhotugʉ̃? ni sinituahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Tiquiro sa nigʉ̃ tiquina pehe tiquina basi ohõ saha niahye: —‍¿Dʉhse ni yʉhtinatari mari? “Cohãcjʉ̃ Ñure dutie tiahye”, mari nigʉ̃, “¿Dʉhsena Ñure Cohãcjʉ̃ dutiepegʉ̃ta tiquirore tʉho duerari mʉsa?” niboaga Jesu marine. Sa yena “Cohãcjʉ̃ Ñure dutiye tiahye”, ni yʉhti masiedaja mari. ");
INSERT INTO pirNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ahriquina masa pehe “Potota Ñu Cohãcjʉ̃ yere yahu mʉhtariquiro ijire”, ni tʉhoture tiquina. Sa ni tʉhotuye “Ñu tiquiro wame yegʉ̃ Cohãcjʉ̃ tiquirore dutierahye”, mari nigʉ̃ tʉhoye marine masa ʉtã paca mehna doqueeta. Sa yena ti gʉ̃hʉre yʉhti masiedaja mari, ni yahuducuahye tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Sa ni yahuducu tuhasa tiquina Jesure yʉhtiahye: —‍Ñure wame ye dutiriquirore ʉsã masiedaja, niahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Tiquina sa nigʉ̃ Jesu yʉhtiahye: —‍Ti pje pũrita yʉhʉ gʉ̃hʉ mʉsa sinitu mʉhtarire yahueraja mʉsare. Ahrire yʉhʉ yerire dutiriquirore yahueraja mʉsare, niahye tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Sa ye Jesu tiquiro tʉhotuye mehna queoye mehna ohõ saha ni buhe dʉcahye masare: —‍Wese upʉro ʉhse darire oteahye. Ote tuhasa, ti wesere apequinare ihcã pehe pahma cũahye. Pahma cũno ti wesere tiquinare ihña ihbo dutiahye. Sa duti tuhasa ape yehpapʉ waha, yoari pje bajuerahye. ");
INSERT INTO pirNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Sa yero ʉhse ñidi pje ijigʉ̃ wese upʉro tiquiro cahacjʉ̃nore wesere ihña ihboyequina cahapʉ ohoahye. Wese cjẽ oteri dʉcare tiquiro ya pahrẽ cjẽne ne dutiro ohomahye. Sa ye ihña ihboyequina pehe tiquiro cahacjʉ̃nore piti ca quẽahye tiquirore. Sa ye tiquina tiquirore dʉcare ohoerapeta tojoa dutiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Sa yero wese upʉro apequiro tiquiro cahacjʉ̃nore ti wese cjẽ oteri dʉcare ne dutiro ohomahye tja. Sa ye wesere ihña ihboyequina tiquiro gʉ̃hʉre quẽ, ñano yeahye tiquirore. Sa ye tuhasa tiquirore ti dʉcare ohoerapeta tojoa dutiahye tja. ");
INSERT INTO pirNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Tiquina sa yeri bato wese upʉro apequiro cahacjʉ̃nore ohomahye tja. Sa ye wesere ihña ihboyequina pehe tiquiro gʉ̃hʉre cami dahre, ti wese dʉhtʉ cahapʉ cohã cãhye tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Tiquina sa yeri bato wese upʉro ohõ saha ni tʉhotumahye: “¿Dʉhse yegʉtari yʉhʉ? Ohõ saha yegʉtja. Yʉhʉ macʉre yʉhʉ cahĩniquirore ohogʉtja. Ijirota ijire. Tiquina tiquirore ño peoeta”, ni tʉhotumahye wese upʉro pehe. ");
INSERT INTO pirNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Sa ye tiquiro macʉnore tiquiro ohoriquirore esagʉ̃ ihñañe ihña ihboyequina pehe tiquina basi ohõ saha ni, yahuducuahye. “Ahriquiro wese upʉro macʉno ijire. Tiquirore wejẽihna. Sa yero ahri wese mari ya wese tojoarota”, nimahye tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Sa ni tuhasa wese upʉro macʉnore wese dʉhtʉ cahapʉ nea, wejẽ cãhye tiquirore. ¿Tiquina sa yegʉ̃ ihñano dʉhse yerotari wese upʉro wesere ihña ihboyequinare? niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","—‍Ti wesere ihña ihboyequinare wejẽno taro, apequinare wesere ihña ihbo dutirota, ni yʉhtiahye Jesu tiquiro basi. Tiquiro sa nigʉ̃ tʉhoye masa pehe ohõ saha niahye: —‍Marine sa wahaeracãhdo, niahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Tiquina sa nigʉ̃ Jesu pehe tiquinare sinituahye: —‍¿Cohãcjʉ̃ yere tiquina ojoari pũre ohõ saha ni yahuducuye, dʉhse nino niajari, mʉsa tʉhotugʉ̃? Ahriquiro Cristo ʉtã yero saha ijire. Ʉtãre wʉhʉ dahreyequina tiquina cohãno saha masa tiquirore cohãeta. Tiquina sa yepegʉ̃ta yojopʉre wʉhʉ dahreyequina wʉhʉre yeye tiquina cũ mʉhtaria ʉtãre tiquina cũno saha Cohãcjʉ̃ tiquirore pʉhtoro sõri, ni ojoahye. ");
INSERT INTO pirNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","’Ijipihtiyequina tia ʉtã bui doque queheyequinare mʉta sitea wahaeta. Sa yero tia ʉtã masʉno bui bora pjero, mʉtaa wahagʉ̃ yerota tiquirore. Tiquiro pagʉ mʉnanore daye manarigã wahagʉ̃ yerota, niahye Jesu. (Sa nino tiquirore cahmedariquina, tiquiro buhiri dahreatiquina tiquina ñano yʉhdʉatire yahuro niahye.) ");
INSERT INTO pirNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Tiquiro sa nigʉ̃ tʉhoye judio masare buheyequina, pahia pʉhtoa gʉ̃hʉ, “Jesu wesere ihña ihboyequina queoye mehna marine tuhtiro nine”, ni, tʉhotuahye tiquina. Sa ni tʉhotuye tiquina Jesure ñehe duamahye. Sa ñehe duepeta tiquina masare cue niahye. ");
INSERT INTO pirNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Sa cueye, Jesure tiquina ñeheati pjere cohteahye tiquina. Sa ye “Poto ijiyequina yero saha ye meho ijiya mʉsa”, niahye tiquina apequinare. Tiquiro ñano ni yʉhtigʉ̃ ye duaye nimahye tiquirore yahusã duaye. Sa ye Jesure sinitu dutiye ohoahye ni mehoñequinare. Jesu ñano ni yahuducugʉ̃ tʉhoye ti yehpa cjẽna pʉhtorore peresu ye dutiye tee nimahye. ");
INSERT INTO pirNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Sa ye tiquina Jesure ni meje cũ sinituye nimahye: —‍Buhegʉ, poto yahuducugʉ, ni mehoñe mariegʉ mʉhʉ ijigʉ̃ ʉsã masiaja. Sa yegʉ ihcãquiro pʉhtoro waro tiquiro ijiepegʉ̃ta tiquiro gʉ̃hʉre dóyaro marieno potota yahure mʉhʉ. Mʉhʉ Cohãcjʉ̃ yere poto mʉhʉ buhegʉ̃ gʉ̃hʉre ʉsã masiaja. ");
INSERT INTO pirNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Yahuya ʉsãre. ¿Ne, Roma cjʉ̃nore ijipihtiyequina pʉhtorore gobierno cjẽne marine wapa yero cahmeajari, mʉhʉ tʉhotugʉ̃? ¿Mari dutiye wapa ye dutiajari, mʉhʉ tʉhotugʉ̃? ni sinituahye tiquina Jesure. ");
INSERT INTO pirNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Tiquina sa nigʉ̃ tʉhoro Jesu tiquina ñano ye duayere masino, tiquinare yʉhtiahye: ");
INSERT INTO pirNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—‍Yojopʉre niñeru cjoere pʉhtoare wapa yeati cjoere ne cãhtaya. Ti cjoere ihñaʉhna, niahye. Ti cjoere tiquina ne wihigʉ̃ ihñano ohõ saha niahye Jesu: —‍¿Noa boro queoye wahñajari ahri cjoere? ¿Noa boro wame wahñajari? niahye Jesu tiquinare. —‍César, masa ijipihtiyequina pʉhtoro queoye, tiquiro wame gʉ̃hʉ wahñare, ni yʉhtiahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Tiquina sa nigʉ̃ Jesu yahuahye: —‍Ti pje pũrita masa ijipihtiyequina pʉhtoro yere tiquiro pehere ohoya. Cohãcjʉ̃ yere Cohãcjʉ̃ pehere ohoya, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Sa ye masa tiquina ihñonopʉ Jesure ñano ni yahuducugʉ̃ ye masiedahye tiquina. Sa ye Jesu yʉhtiyere tʉhoye, tiquina tʉho maria wahahye. Sa tʉho maria waha, dihta maria wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sa ye meheñequinagã saduceo masa Jesu cahapʉ wihiahye. “Cohãcjʉ̃ yariariquinare masosi”, ni tʉhotuyequina ijiahye saduceo masa. Sa ye tiquina ohõ saha niahye tiquirore: ");
INSERT INTO pirNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—‍Buhegʉ, ohõ saha ni buheahye Moise: “Ihcãquiro tiquiro wahmino namo tiriquiro pohna mariedaperota tiquiro yariagʉ̃ ihñano tiquiro bahʉrore tiquiro wahmino namono ijiricorore nʉoano cahmene. Sa yero tiquiro wahmino mʉnano tiquiro pohna tiboriro sahata pohna tiro cahmene tiquiro bahʉrore. Sa ye tiquiro pohne tiquiro wahmino mʉnano pohne yero saha ijieta”, ni, ojoahye Moise, niahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Tire ni tuhasa ahri quitire tja yahu nemoahye Jesure: —‍Ihcãquiro masʉno ijiahye. Seis bahana tiahye. Tiquina wahmino pehe namo ti, pohna mariediquiro yariaa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Sa yero apequiro tiquiro bahʉro gʉ̃hʉ tiquiro wahmino namono ijiricorore nʉoahye. Tiquiro sa nʉoari bato tiquiro wahmino yero sahata pohna mariedaperota tiquiro gʉ̃hʉ yariaa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Sa yero ahriquiro bahʉro gʉ̃hʉ tiquiro wahmino mʉnano yero sahata pohna mariedaperota yariaa wahahye. Sa dihita wahahye ihcãquiro pohne waro. Ne pohna mariedapeta yaria pihtia wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Tiquina namono ijiricoro gʉ̃hʉ tiquina batota yariaa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","¿Ne, Cohãcjʉ̃ ijipihtiyequinare yariariquina mʉnare tiquiro masogʉ̃ diquiro namono pehe ijiboagari ticoro pototi? Tiquina ijipihtiyequina ticorore namo tiriquina mʉna ijiahye. ¿Sa yero diquiro namono pehe ijirotari? ni sinituahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Tiquina sa nigʉ̃ Jesu yʉhtiahye: —‍Yojopʉ cjẽna omoca dʉhtere. ");
INSERT INTO pirNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Tiquina sa dʉhtepegʉ̃ta apequina pehe topʉ cjẽna pehe sa ijierare. Apequina ʉmʉare, numia gʉ̃hʉre poto yeyequinare Cohãcjʉ̃ quehnoañequina ijigʉ̃ yerota. Tiquina yariari bato masa mʉjaeta. Sa ye tiquina topʉ omoca dʉhterare. ");
INSERT INTO pirNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Sa ye tiquina angele yero sahata ne yariasi. Tiquina Cohãcjʉ̃ masoriquina ijiye, Cohãcjʉ̃ pohne ijire. ");
INSERT INTO pirNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Yojopʉre yariariquina mʉna tiquina masa wijiati pehere mʉsare yahutja. Tire Moise quehnoano yahu pehoahye. Tiquiro mehenʉgã ʉjʉ̃ri quitire ohõ saha ni yahuahye: “Abrahã, Isaac, Jacob tiquina pʉhtoro ijire Cohãcjʉ̃,” ni ojoahye Moise. ");
INSERT INTO pirNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Tiquina yariari bato “Tiquina pʉhto ijiaja”, ni yahuahye Cohãcjʉ̃. Sa nieperota yariariquina mʉna pʉhtoro ijierare Cohãcjʉ̃. “Tiquina pʉhto ijiaja”, tiquiro niñe mehna catiyequina tiquina ijigʉ̃ masiaja mari. Tiquiro catiyequina pʉhtoro ijire. Ijipihtiyequina masa catire, Cohãcjʉ̃ ihñagʉ̃, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Tiquiro sa nigʉ̃ meheñequinagã judio masare buheyequina ohõ saha niahye: —‍Buhegʉ, mʉhʉ quehnoano yʉhtiri, niahye tiquina Jesure. ");
INSERT INTO pirNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Sa ye pari turi Jesure sinitu duerahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Came Jesu ohõ saha ni yahu nemoahye tiquinare: —‍“Cristo Davi mʉnano panamino iji turiariquiro ijirota”, ni buhere apequina. ¿Dʉhse ye tiquina sa ni buheajari? ");
INSERT INTO pirNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Davi mʉnano tiquiro basi Salmopʉ tiquiro ojoari pũpʉ ohõ saha ni, ojoahye: Cohãcjʉ̃ yʉhʉ pʉhtorore ohõ saha nidi: “Ohõpʉ yʉhʉ poto pehepʉ dujiya. ");
INSERT INTO pirNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Sa yegʉ mʉhʉre ihña tuhtiyequinare mʉhʉre yʉhdʉdʉca basaʉtja yʉhʉ”, nidi Cohãcjʉ̃ yʉhʉ pʉhtorore, ni, ojoahye Davi mʉnano. ");
INSERT INTO pirNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Sa ni ojoaro Davi mʉnano Cristore “Yʉhʉ pʉhtoro”, ni pisuahye. Davi mʉnano Cristo ñecʉno iji turiariquiro ijieperota Cristore “Yʉhʉ pʉhtoro”, ni pisuahye. ¿Davi mʉnano Cristo ñecʉno iji turiariquiro ijieperota dʉhse ijiro boro tiquiro “Yʉhʉ pʉhtoro”, ni pisuyari Cristore? Cristo pehe Davi mʉnano pʉhtoro ijire, ni yahuahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Masa peyequina Jesure tiquina tʉhori watoa Jesu pehe tiquiro buheyequinare ohõ saha ni yahuahye: ");
INSERT INTO pirNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—‍Mari judio masare buheyequina tiquina ñañe yeyere ihñana quehnoano wacũ masiña. Sa yena tiquina yero saha yeracãhña. Tiquina yoaye suhti saña, masa tiquina ihñonopʉ tini, doeri cjẽ duaropʉ apequina pʉhtoare quehnoano ño peo tiquina sinino saha tiquina piti ca sinigʉ̃ cahmene tiquina. Sa ye tiquina mari judio masa buheye wʉhʉsepʉ quehnoañe dujiye dihitare duji duare. Sa ye bose deco ijigʉ̃ topʉ gʉ̃hʉre quehnoañe dujiye dihitare cahmene. ");
INSERT INTO pirNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Tiquina wape wiha numia ye wʉhʉsere tiquina cʉoye gʉ̃hʉre ehmare ti numiare. Sa ye tiquina masa ihñonopʉ yoari pje Cohãcjʉ̃re siniducumene masare ihña dutiye. Tiquina sa yegʉ̃ apequina bui cjũno tiquinare Cohãcjʉ̃ buhiri dahrerota, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Sa ni yahu tuhasa Cohãcjʉ̃ wʉhʉ cjẽ niñeru tiquina sãri acarore niñeru opana tiquina ye niñerure duhu sãgʉ̃ ihña dujiro niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Sa ihñano wape wihoro pejecʉoricoro pʉa cjoegãre ticoro duhu sãgʉ̃ gʉ̃hʉre ihñahye. ");
INSERT INTO pirNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Tire ihña tuhasa ohõ saha ni yahuahye: —‍Potota niita niaja mʉsare. Ahricoro wape wihoro pejecʉoricoro pehe niñeru sãri acaropʉ duhu sãno apequina ijipihtiyequina ohori yʉhdʉoro ohori ticoro pehe. ");
INSERT INTO pirNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Apequina niñeru opana pajiro tiquina ohoepegʉ̃ta tiquina ye pajiro dʉhsare. Ahricoro pehe pejecʉoricoro ijieperota ijipihtiye ticoro ihyatire ticoro dúborigãre oho pehori, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Sa ye apequina Cohãcjʉ̃ wʉhʉre ohõ saha niahye: —‍Quehnoañe ʉtã paca mehna yeri wʉhʉ, quehnoa yʉhdʉari wʉhʉ ijicjoare. Masa Cohãcjʉ̃ ya wʉhʉ ijiatire tiquina ohori gʉ̃hʉ ti wʉhʉpʉre quehnoano cũri jire, ni, yahuducuye niahye. Tiquina sa nigʉ̃ Jesu yahuahye tiquinare: ");
INSERT INTO pirNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—‍Ahri ijipihtiye mari ihñari wʉhʉsere, ahri ʉtã paca gʉ̃hʉre cohã pehoeta. Ne ihcãria ʉtã tojoasi, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Tiquiro sa nigʉ̃ tʉhoye tiquina pehe sinituahye tiquirore: —‍¿Buhegʉ, dʉhse ijigʉ̃ mʉhʉ nidiro saha sa waharotari? ¿Pihtiati deco panogã ijigʉ̃ dʉhse ti waha dʉcagʉ̃ ihñanatari ʉsã? ni sinituahye tiquina Jesure. ");
INSERT INTO pirNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesu yʉhtiahye tiquinare: —‍Quehnoano yeya mʉsa. Sa yena mʉsare apequina tiquina ni mehoñene tʉhoeracãhña. Peyequina masa “Cristo ijiaja yʉhʉ”, ni mehoñequina ahtaeta. Sa niñe, “Yojopʉre pihtiati deco ijiato mehenogã dʉhsare”, nieta. Tiquina sa nigʉ̃ tʉhoeracãhña. ");
INSERT INTO pirNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Sa ye apequina “Cahme wejẽñe nine”, mʉsare nieta. “Yojopʉre pʉhtoare masa cohãñe nine”, nieta. Mʉsa tire tʉhona cueracãhña. Pihtiati deco pano ohõ saha waha mʉhtanota. Sa wahagʉ̃ pihtiati deco wahato dʉhsarĩnota, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Sa ni tuhasa ohõ saha ni yahu nemoahye: —‍Ihcã yehpa cjẽna ape yehpa cjẽna mehna cahme wejẽeta. ");
INSERT INTO pirNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Sa yero tutuaro yehpa ñuhmi, masa peyequina ʉjʉa mehna yaria, ijipihtiro cjẽna dohatieta. Sa ye ʉhmʉse cjẽ cua pesaye bajuagʉ̃ ihñañe, masa ihña maria wahaeta. ");
INSERT INTO pirNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Ahri ijipihtiye sa wahato pano, apequina mʉsare ñehe, ñano yeeta. Sa ye mari judio masa buheye wʉhʉsepʉ tiquina mʉsare yahusã, peresu yeeta mʉsare. Tiquina sa yegʉ̃ peye yehpari cjẽna pʉhtoa cahapʉ, peye macari cjẽna pʉhtoa cahapʉ ducunata mʉsa tiquina yahusãnohrina. Yeequina mʉsa ijiri buhiri sa yeeta. ");
INSERT INTO pirNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Tiquina sa yahusãgʉ̃ mʉsa pehe quehnoañe buheyere tiquinare yahunata. ");
INSERT INTO pirNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ti pjere mʉsare tiquina yahusãgʉ̃ pʉhtorore mʉsa yʉhtiatire “Yahu masiedaboaga”, ni tʉhotueracãhña mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Yʉhʉ mʉsare yahu basaʉtja. Mʉsare sa yedohogʉ tʉho masiñene, quehnoañe yahuducuye gʉ̃hʉre mʉsare yahugʉ̃ yeitja. Mʉsa sa yegʉ̃ mʉsare ihña tuhtiyequina pehe mʉsa yahuducuyere tʉho, “Ti poto ijierare”, ni, yʉhti masisi. ");
INSERT INTO pirNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ti pjere mʉsa pacʉsʉmʉa, mʉsa bahana, mʉsa acaye, mʉsa mehna cjẽna gʉ̃hʉ mʉsare ihña tuhtiyequinare ohoeta mʉsare, yeequina mʉsa ijiri buhiri. Tiquina sa yegʉ̃ mʉsare ihña tuhtiyequina mʉsa mehna cjẽnare apequinare wejẽeta. ");
INSERT INTO pirNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Sa ye yeequina mʉsa ijigʉ̃ ihñañe, ijipihtiyequina mʉsare ihña tuhtieta. ");
INSERT INTO pirNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Mʉsare sa ihña tuhtiepeta ne mehenogã mʉsare ñano yesi. ");
INSERT INTO pirNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Sa yena mʉsa wacũ tutuana ijiya. Mʉsa sa yena, Cohãcjʉ̃ mehna sa ijiducunata. ");
INSERT INTO pirNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Sa ye peyequina surara Jerusalẽpʉ tiquina cahmota sotoa peho cãgʉ̃ ihñana, Jerusalẽne tiquina cohãto mehenogã dʉhsagʉ̃ masinata mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ti sa wahagʉ̃ ihñañe Judea yehpapʉ ijiyequina cʉnʉ cjʉ cahapʉ oma duhtiahro. Sa ye Jerusalẽpʉ ijiyequina wahaahro. Sa ye weseripʉ ijiyequina Jerusalẽpʉ tojoeracãhdo sojaro mehna tiquina wahato pehe. ");
INSERT INTO pirNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ti decoripʉ buhiri dahreye decoripʉ ijipihtiye Cohãcjʉ̃ tiquiro ojoari pũ tiquiro nidiro sahata sa waharota. ");
INSERT INTO pirNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ijipihtiropʉ ahri yehpapʉ ñano yʉhdʉeta. Ti sa wahagʉ̃, niji wahcõñe numia, tiquina pohnene apũoñe numia gʉ̃hʉ pejecʉoro wahaeta. ");
INSERT INTO pirNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Apequina ahri maca cjẽna mehna cahme wejẽeta. Sa ye apequina ahri maca cjẽnare ijipihtiye yehparipʉ ne cã, peresu yeeta. Sa ye judio masa ijieyequina Jerusalẽne ñano ye, tiquinare yʉhdʉdʉcaeta. Judio masa ijieyequina ya deco pihtigʉ̃pʉ Jerusalẽ cjẽnare ñano ye duhueta, ni yahuahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Sa yero tiquinare yahu nemoahye: —‍Ti pjere asʉ̃ deco cjʉ̃no, ñami cjʉ̃no, ñahpicoha gʉ̃hʉ sijoro saha ijiyequina wahaeta. Ijipihtiyequina ahri yehpa cjẽna “Acuehi, yarianata”, ni tʉhotuyequina pajiri ma cjẽ pahcõri cua yʉhdʉaro ti pahcõri bisi cãhtagʉ̃ tʉhoye tutuaro cueeta. ");
INSERT INTO pirNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ti pjere ʉhmʉse cjẽ yehpari, ñahpicoha gʉ̃hʉ ti sa wahaducurore camesaeta. Sa ye ñuhmieta. Ti sa wahagʉ̃ ihñañe, masa pehe ahri yehpa pihtiatire cohteye, tutuaro cueeta. ");
INSERT INTO pirNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ti pjeta yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ Cohãcjʉ̃ tutuaye mehna tiquiro asi siteye mehna ehmeo curua buipʉ yʉhʉ ahtagʉ̃ ihñaeta masa. ");
INSERT INTO pirNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ahri sa waha dʉcagʉ̃ ihñana, wacũ tutuana ijiya. Sa yena ʉhmʉsepʉ ihñaña. Ti pjere Cohãcjʉ̃ mʉsare pecapʉ wahaborinare tiquiro yʉhdʉoato mehenogã dʉhsarota, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Sa ni tuhasa ahri queoye mehna buheahye Jesu: —‍Higueragʉre, apeye cjʉ gʉ̃hʉre tʉhotuya mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Tʉ yucʉgʉ pũri tigʉ̃ ihñana, cʉhma mehenogã dʉhsagʉ̃ masine mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Sata ahri ijipihtiye yʉhʉ nidire ti sa wahagʉ̃ ihñana, Cohãcjʉ̃ tiquiro pʉhtoro ijiati pje mehenogã dʉhsagʉ̃ masinata mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Mʉsare poto niita niaja. Ti pje cjẽna tiquina yariato pano ijipihtiye yʉhʉ nidiro sahata sa waharota. ");
INSERT INTO pirNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ʉhmʉse, ahri yehpa gʉ̃hʉ pihtia waharota. Yʉhʉ yahuducuye pehe ne camesasi. Ijipihtiye yʉhʉ nidiro sahata sa waha sohtori tirota. ");
INSERT INTO pirNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Yʉhʉ tojoa tati decore ne masiedare mʉsa. Sa yena quehnoano yeya. Bose decorire queheye decorire yeducueracãhña. Sa yena queheracãhña. Ahri yehpa cjẽne pajiro tʉhotueracãhña. Mʉsa yʉhʉ nidiro sahata yena, wacũeno mehna ahri yehpapʉ yʉhʉ ahtagʉ̃ mʉsa ne acʉasi. ");
INSERT INTO pirNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Wahiquirore yuri da wacũeno mehna ti da tʉã suharo saha wacũeno mehna ahtaʉtja yʉhʉ. Ijipihtiyequina ahri yehpa cjẽna tiquina masiedi watoa ti deco wacũeno mehna sa waharota. ");
INSERT INTO pirNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Quehnoano wacũ masi cohteya. Sa yena Cohãcjʉ̃re ahrire sa siniducuya: “Ahri pihtiati decore sa wahagʉ̃ yʉhʉre yedohoya. Tutuayere ohoya yʉhʉre ahrire quehnoano yʉhʉ yʉhdʉatire. Sa yegʉ Cristore mʉhʉ ohoriquirore cuero marieno yʉhʉre piti cagʉ̃ yeya”, ni, siniña Cohãcjʉ̃re, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Sa ye ti decorire Cohãcjʉ̃ wʉhʉpʉ Jesu buhee tiahye. Ñaminipe buhe tuhasaro Olivo wame tidʉ cʉnʉpʉ waha, topʉ iji bohreaye tiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Bohreayepe tahari ijipihtiyequina masa Cohãcjʉ̃ wʉhʉpʉ tiquirore tʉhoye wahae tiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Sa ye ti pjere pugʉ̃ yeye moremehneñe pãre tiquina ihyati bose deco mehenogã dʉhsahye. Ti bose deco pascua wame tiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Sa ye pahia pʉhtoa, judio masare buheyequina mehna Jesure wejẽ duaye, tiquina wejẽatire wacũ macahye. Jesure wejẽ duepeta, masa pehere cueahye, “Usuari”, niñe. ");
INSERT INTO pirNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Sa ye watĩno Juda Iscariotere ñano tiquiro ye dutigʉ̃ Juda pehe yʉhtiahye tiquirore. Juda doce buheyequina mehna cjʉ̃no ijimahye. ");
INSERT INTO pirNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Sa yero tiquiro pahia pʉhtoare, Cohãcjʉ̃ wʉhʉ cjẽna surara pʉhtoa mehna gʉ̃hʉre yahuro wahahye. Tiquina cahapʉ esa, tiquinare Jesure tiquiro ihñoatire yahuahye tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Tiquiro sa nigʉ̃ tʉhoye, tiquina bucue, “Mʉhʉre niñerure wapa yenatja”, niahye tiquina Judare. ");
INSERT INTO pirNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Tiquina sa nigʉ̃ Juda “Aʉ, tiquirore mʉsare ihñoutja”, ni, masa tiquina ihñeno watoa Jesure ihña tuhtiyequinare tiquiro ihñoati ñamine cohtero niahye. ");
INSERT INTO pirNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Pugʉ̃ yeye moremehneñe pãre ihyati bose deco iji dʉcari deco ijiahye. Sa yero pascua cjẽ ijiatire ovejare tiquina ihyatiquinare tiquina wejẽdi deco ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ti pjeta Pedrore, Ñu gʉ̃hʉre Jesu yahuahye: —‍Bose decopʉ mari ihyatire quehnona wahaya, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","—‍¿Noho boropʉ mari ihyatire quehnoyu dutigʉ ohoajari mʉhʉ ʉsãre? ni sinituahye tiquina tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Tiquina sa nigʉ̃ Jesu yʉhtiahye: —‍Jerusalẽpʉ mʉsa esagʉ̃ aco sutu wʉariquiro mʉsare piti carota. Tiquiro piti cagʉ̃ tiquiro mehna wahaya. ");
INSERT INTO pirNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Sa wahana tiquiro siho sajãri wʉhʉpʉ esana wʉhʉ upʉrore ohõ saha ni yahuya. “ ‘¿Nohopʉ yʉhʉ buheyequina mehna pascua cjẽ ihyayere ihyanatari?’ nidi buheriquiro”, niña wʉhʉ upʉrore. ");
INSERT INTO pirNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Mʉsa sa nigʉ̃ tʉhoro ʉhmʉano cjã tucũre pajiri tucũre mari cahmeñe mehna tiquina quehnori tucũre ihñonota wʉhʉ upʉro. Topʉ mari ihyatire dahreya mʉsa, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Tiquiro sa nigʉ̃ tiquina ti macapʉ wahahye. Topʉ tiquina esagʉ̃ tiquinare tiquiro nidiro sahata wahahye. Sa ye tiquina pascua cjẽ ihyatire dahreahye. ");
INSERT INTO pirNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ihyari pje ijigʉ̃ Jesu doce tiquiro buheyequina mehna ihya dujiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","16","Topʉ ihyaropʉ dujiro Jesu tiquinare yahuahye: —‍Mʉsare niita niaja. Ahri pascua bose decore mari dahreaja Cohãcjʉ̃ tiquiro yequinare tiquiro yʉhdʉotire wacũna. Came Cohãcjʉ̃ tiquiro pʉhtoro ijiropʉ tiquiro yequinare yʉhdʉo tuhasarota. Tiquiro sa yʉhdʉoato pano ahri deco cjẽne pari turi ihyasi yʉhʉ. Sa yegʉ yojopʉre yʉhʉ ñano yʉhdʉato pano ahri pascua cjẽ ihyayere mʉsa mehna tutuaro ihya duahti yʉhʉ, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","18","Sa ninota Jesu sihnidi pare ne, Cohãcjʉ̃re “Quehnoare”, ni sini, tiquinare yahuahye: —‍Mʉsare niita niaja. Cohãcjʉ̃ ijipihtiyequina pʉhtoro tiquiro ijiato pano ahri vinore ne pari turi sihnisi yʉhʉ. Sa yena ahri vinore ne, mʉsa basi iti sihniña, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Sa ni tuhasa pãre ne, Cohãcjʉ̃re “Quehnoare”, niahye. Sa yero tiare nuha, itiahye tiquinare. Tiare itiro, tiquinare yahuahye: —‍Ahri yʉhʉ pagʉ ijire. Yʉhʉ pagʉ yʉhʉre ihña tuhtiyequinare tiquina ohori pagʉ ijirota mʉsare yʉhʉ yʉhdʉoati. Sa yena yʉhʉre mʉsa wacũatire ahrire ihyaya, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Sa ihya tuhasa sata tiquiro tiquinare sihnidi pa gʉ̃hʉre ohoahye. Sa ohoro, tiquinare yahuahye: —‍Mʉsa ñañe yeyere cohãgʉ tagʉ yariʉtja. Sa yegʉ yʉhʉ diire cohãʉtja. Cohãcjʉ̃ “Mʉsare yʉhdʉoutja”, tiquiro nidiro esa tuhagʉ̃ yʉhʉ yariaro mehna tiquiro nidiro sohtori tirota. ");
INSERT INTO pirNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Yojopʉre tʉhoya mʉsa. Yʉhʉre ihña tuhtiyequinare yʉhʉre ihñoatiquiro yojopʉre yʉhʉ mehna ohõ dujire. ");
INSERT INTO pirNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Cohãcjʉ̃ tiquiro dutiriro sahata yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ yariʉtja. Tiquiro sa yaria dutiepegʉ̃ta yʉhʉre ihña tuhtiyequinare ihñoatiquiro pũrita ña yʉhdʉaro yʉhdʉrota, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Tiquiro sa nigʉ̃ tiquina pehe tiquina basi ohõ saha ni sinituahye: —‍¿Jesure ihña tuhtiyequinare ihñoatiquiro mari mehna cjʉ̃no diquiro boro ijiagari? ni, yahuducuahye tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Came Jesu buheyequina ohõ saha ni yahuducuahye: —‍¿Mari mehna cjʉ̃no diquiro pehe ijiagari pʉhtoro? ni yahuducuahye tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Tiquina sa ni yahuducugʉ̃ tʉhoro Jesu tiquinare yahuahye: —‍Cohãcjʉ̃re cahmeeñequina pʉhtoa pehe tiquina masare dutiye, purĩno mehna dutire. Sa ye pʉhtoare “Tiquina masare yedohoyequina ijire”, nimene apequina masa tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Mʉsa pehe sa yesi mʉsa basi. Mʉsa mehna cjʉ̃no mʉsa wahmi pehere tiquiro bahʉro yero saha ijiro cahmene. Mʉsa mehna cjʉ̃no pʉhtoro iji duaro cahacjʉ̃no yero saha ijiro cahmene tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Diquiro ijiajari pʉhtoro? ¿Ihya dujiriquiro pehe pʉhtoro ijiajari? ¿O ihyayere itiriquiro pehe pʉhtoro ijiajari? Ihya dujiriquirota ijiaga pʉhtoro. Tiquiro sa ijiepegʉ̃ta yʉhʉ pehe cahacjʉ̃no yero saha mʉsare yedohogʉ ahtaʉ. ");
INSERT INTO pirNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Masa yʉhʉre tiquina ñano yepegʉ̃ta mʉsa pehe yʉhʉre duhuerare. ");
INSERT INTO pirNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Sa yegʉ yʉhʉ Pacʉ yʉhʉre tiquiro pʉhtoro sõriro sahata mʉsa gʉ̃hʉre pʉhtoa sõgʉtja yʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Yʉhʉ pʉhto yʉhʉ ijigʉ̃ yʉhʉ ihyari mesapʉ mʉsa gʉ̃hʉ ihya, sihninata. Sa yena mʉsa pʉhtoa dujiyere dujinata. Mʉsa topʉ dujina Israe masare doce cururi cjẽnare besenata mʉsa ñañequinare, quehnoañequinare, niahye Jesu tiquiro buheyequinare. ");
INSERT INTO pirNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Sa ni tuhasa Pedrore Jesu ohõ saha ni yahuahye: —‍Simo Pedro yʉhʉre tʉhoya. Mʉsare ijipihtinare watĩno yʉhʉre cohãgʉ̃ ye duare. Trigo wese cjʉ̃no trigore tiquiro wejẽ site cohãriro sahata mʉsare ijipihtinare watĩno ñano ye duare. Sa ye duaro, Cohãcjʉ̃re sinidi. ");
INSERT INTO pirNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Tiquiro sa sinigʉ̃ ihñagʉ̃ yʉhʉ pehe Cohãcjʉ̃re sini basaʉ mʉhʉre. Yʉhʉre mʉhʉ wacũ tutua duhueratire sini basaʉ mʉhʉre. Sa yegʉ mʉhʉ yʉhʉ mehna cjʉ̃ pari turi ijigʉ yeequinare yedohoya mʉhʉ, yʉhʉre tiquina wacũ tutua nemoati, niahye Jesu Pedrore. ");
INSERT INTO pirNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Tiquiro sa nigʉ̃ Pedro yʉhtiahye: —‍Pʉhto, yʉhʉre tiquina peresu yepegʉ̃ta, yʉhʉre tiquina wejẽ duepegʉ̃ta mʉhʉ mehna cjʉ̃ ijiitja, niahye Pedro. ");
INSERT INTO pirNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesu yʉhtiahye: —‍Pedro, mʉhʉre niita niaja. Mia ñami canaca tiquiro yahuato pano “Jesure masiedaja”, nigʉta mʉhʉ apequinare. Ihtia taha sa nigʉta mʉhʉ, niahye Jesu Pedrore. ");
INSERT INTO pirNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Sa ni tuhasa Jesu tiquiro buheyequinare yahuahye: —‍¿Sohõ ijiri pje niñeru ajuro mariena, pajiri ajuro mariena, dahpo suhti mariena mʉsare yʉhʉ ohogʉ̃ apee boro dʉhsari mʉsare? ni sinituahye Jesu. —‍Ne ʉsãre yabe dʉhsaerari, ni yʉhtiahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","—‍Ti pjere mʉsare dʉhsaerapegʉ̃ta yojopʉ pehere niñeru ajurore cʉona tire neña. Pajiri ajurore cʉona gʉ̃hʉ neña. Sa yena mʉsare ñoseni pjĩ mariedagʉ̃ mʉsa suhtire duana ti pjĩne dúya. ");
INSERT INTO pirNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ahrire mʉsare nii niaja. Cohãcjʉ̃ yere tiquina ojoari pũpʉ tiquina nidiro sahata yʉhʉre sa waharo cahmene. Ohõ saha niahye ti pũpʉ: “ ‘Tiquiro dutiyere yʉhdʉdʉcayequina mehna cjʉ̃no ijire’, nieta masa”, ni, ojoahye, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","—‍Ihñaña pʉhto. Pʉa pjĩ ñoseñe pjĩnine cʉoaja ʉsã, niahye tiquiro buheyequina. —‍To punota ijire, ni yʉhtiahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Sa ye Jesu tiquiro sa yeducuriro sahata Olivo wame tidʉ cʉnʉpʉ wahahye. Tiquiro sa wahagʉ̃ tiquiro buheyequina tiquiro mehna wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Topʉ esaro tiquiro tiquinare yahuahye: —‍Cohãcjʉ̃re siniña mʉsa ñano yeratire, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Sa ni tuhasa tiquiro dihita mehenogã waha nemo, dʉsepe curi mehna quehe sa, Cohãcjʉ̃re siniahye: ");
INSERT INTO pirNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","—‍Mai, yʉhʉ ñano yʉhdʉatire ye dueragʉ yeracãhña. Yʉhʉ sa niepegʉ̃ta yʉhʉ cahmeñe pehere yeracãhña. Mʉhʉ pehe masine. Mʉhʉ cahmeno saha yeya yʉhʉre, ni siniahye Jesu Cohãcjʉ̃re. ");
INSERT INTO pirNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tiquiro sa sinigʉ̃ ʉhmʉsepʉ ahtariquiro angel Jesure bajua, yedohoahye tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Sa yero Jesu ñano jeripohna ti, tutuaro mehna Cohãcjʉ̃re siniahye. Sa yero tiquiro asi ti cuhsaye dii pjeri yero saha tiquirore wijia, yehpapʉ bora quehe sahye. ");
INSERT INTO pirNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Cohãcjʉ̃re sini bato ti, wahcãdʉca sa, tiquiro buheyequina cahapʉ wihiahye. Tiquiro wihigʉ̃ tiquiro buheyequina tutuaro bʉjʉa witiyequina ijiye, carĩñe niahye. ");
INSERT INTO pirNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Sa yero Jesu tiquinare ohõ saha ni yahuahye: —‍¿Dʉhsena carĩajari mʉsa? Wahcãña. Cohãcjʉ̃re siniña mʉsa, “Ñano yeari”, nina, niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Tiquiro sa ni yahuducuri watoa masa peyequina wihiahye. Juda doce buheyequina mehna cjʉ̃no ijimediquiro masare ʉhmʉ tã cãhtariquiro ijiahye. Sa yero tiquiro Jesu cahapʉ wihi, wahsupu ihmiahye tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Tiquiro sa ihmigʉ̃ Jesu tiquirore sinituahye: —‍¿Juda, yʉhʉ masʉre Cohãcjʉ̃ ohorigʉre yʉhʉre ihña tuhtiyequinare ihñogʉ yʉhʉre wahsupu ihmiñe mehna sa yeajari mʉhʉ? niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Tiquiro sa nidi bato Jesu buheyequina masa Jesure tiquina ñeheatire masiñe, tiquirore sinituahye: —‍¿Pʉhto, ʉsã ñoseñe pjĩni mehna tiquina mehna cahmequema? niahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Tiquina sa nidi bato ihcãquiro Jesu buheyequina mehna cjʉ̃no pehe pahia pʉhtoro cahacjʉ̃nore tiquiro ñoseni pjĩ mehna tiquiro cahmonore poto pehe ijiri cahmonore dʉte pahrẽ cãhye. ");
INSERT INTO pirNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Tiquiro sa yegʉ̃ ihñano Jesu tiquirore ohõ saha niahye: —‍Sa yeracãhña, niahye. Ni, cahacjʉ̃no cahmono ijiriropʉ ña ohõahye. Tiquiro ña ohõgʉ̃ta cahmono mʉnano sahata ijiahye tja. ");
INSERT INTO pirNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Sa ye tuhasa pahia pʉhtoare Cohãcjʉ̃ wʉhʉ cjẽna surara pʉhtoare, bʉcʉna gʉ̃hʉre tiquirore ñeheñe ahtariquinare Jesu sinituahye: —‍¿Dʉhse ijiro boro mʉsa ñoseñe pjĩni, yucʉ tiãri mehna yaqueriquirore tiquina yeriro saha mʉsa yʉhʉre ñehena ahtajari? ");
INSERT INTO pirNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Decoripe Cohãcjʉ̃ wʉhʉpʉ mʉsa mehna yʉhʉ ijigʉ̃, mʉsa yʉhʉre ñehedari. Sa ijiepegʉ̃ta yojopʉre mʉsa ya deco yʉhʉre mʉsa ñano yeati deco ijire. Yojopʉ watĩno tiquiro ñano yeati deco gʉ̃hʉ ijire, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Tiquina Jesure ñehe tuhasa pahia pʉhtoro ya wʉhʉpʉ neahye tiquina tiquirore. Tiquina topʉ neagʉ̃ Pedro yoaropʉ tiquinare ihña nʉnʉ tãhye. ");
INSERT INTO pirNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Pʉhtoro ya wʉhʉpʉ esa, topʉ wʉhʉ cahapʉ ijiri paapʉ, quehnoari paa decopʉ peca wijiãhye apequina. Tiquina wijiãgʉ̃ ihñano Pedro peca cahapʉ dujiyequina mehna dujiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Tiquiro dujiri bato ihcãcoro cahacjõno tiquirore quehnoano ihña, apequinare ohõ saha ni yahuahye: —‍Ahriquiro gʉ̃hʉ tiquiro mehna ijiri, niahye ticoro. ");
INSERT INTO pirNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ticoro sa nigʉ̃ tʉhoro Pedro yʉhtiahye: —‍Numio, tiquirore ne masiedaja yʉhʉ, nimahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Came cjũnogã apequiro Pedrore ihña, ohõ saha ni yahuahye: —‍Mʉhʉ gʉ̃hʉ tiquina mehna cjʉ̃ ijire, niahye tiquiro. —‍Ne ijieraja, nimahye Pedro. ");
INSERT INTO pirNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ihcã hora bato apequiro apequinare ohõ saha ni yahuahye: —‍Ijirota ijire. Ahriquiro Galilea cjʉ̃no ijire. Sa yero potota Jesu mehna ijiri ahriquiro gʉ̃hʉ, niahye tiquiro apequinare. ");
INSERT INTO pirNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Tiquiro sa nigʉ̃ Pedro yʉhtiahye: —‍Ne, mʉhʉ nidiquirore masiedaja yʉhʉ, ni yʉhtiahye Pedro. Tiquiro sa ni yahuducuri watoa canaca yahuahye. ");
INSERT INTO pirNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Tiquiro yahugʉ̃ta Jesu wʉhʉ cahapʉ ijiriquiro Pedrore majare ihñadoqueoahye. Tiquiro sa yegʉ̃ Pedro pehe Jesu tiquiro nidire wacũahye. “Mia ñami canaca tiquiro yahuato pano, ‘Yʉhʉ Jesure masiedaja’, nigʉta mʉhʉ. Ihtia taha sa nigʉta mʉhʉ”, Jesu tiquiro nidire wacũahye Pedro. ");
INSERT INTO pirNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Sa wacũno Pedro topʉ wijia ta, tutuaro utiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Sa ye Jesure cohteyequina surara tiquirore bʉjʉpe, quẽpeahye. ");
INSERT INTO pirNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Sa quẽpeye, tiquiro caperire dʉhte cahmota, tiquirore sinituahye: —‍¿Diquiro mʉhʉre quẽari? Ihñedapegʉta yahuya ʉsãre, ni sinitupeahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Sa ye peye ñano ni yahuducuahye tiquina tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Bohrearopʉ judio masa bʉcʉna, pahia pʉhtoa, judio masare buheyequina gʉ̃hʉ cahmecoahye. Tiquina sa cahmecoanopʉ apequina tiquina cahapʉ Jesure ne cãhtahye. ");
INSERT INTO pirNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—‍Yahuya ʉsãre. ¿Cristota ijiajari mʉhʉ? ni sinituahye tiquina Jesure. Tiquina sa nigʉ̃ Jesu yʉhtiahye: —‍Mʉsare yʉhʉ yahugʉ̃, yʉhʉre tʉhosi mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Mʉsare yʉhʉ sinitugʉ̃ yʉhʉre yʉhtisi mʉsa. Sa yena yʉhʉre wiosi mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Mʉsa wioerapegʉ̃ta came cjũnogã ijipihtiye decori yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ Cohãcjʉ̃ tutuariquiro tiquiro poto pehepʉ dujigʉtja, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Tiquiro sa nigʉ̃ tiquina ijipihtiyequina sinituahye tja pari turi: —‍¿Sa nigʉ Cohãcjʉ̃ macʉta ijiajari mʉhʉ? niahye tiquina. —‍Mʉsa nino sahata ijiaja, ni yʉhtiahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Tiquiro sa nigʉ̃ tiquina ohõ saha ni yahuducuahye tiquina basi: —‍Ahriquiro Cohãcjʉ̃re pajiro tiquiro ñano yahuducugʉ̃ mari basi tʉhou. Sa ye topequinata yahusãahdo ahriquirore, niahye tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Sa ni tuhasa tiquina ijipihtiyequina wahcãdʉca, Jesure Pilato cahapʉ neahye. ");
INSERT INTO pirNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ne esa, Jesure yahusã dʉcahye: —‍Ahriquiro mari ya yehpa cjẽnare tiquiro ñano ye dutigʉ̃ ʉsã tʉhou. Mari pʉhtorore ahriquiro wapa ye dutierare. Sa yero tiquiro “Pʉhto ijiaja. Cristo masare yʉhdʉoacjʉ ijiaja yʉhʉ”, ni yahuducure tiquiro basi, ni yahusãhye tiquina Jesure. ");
INSERT INTO pirNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Tiquina sa ni yahusãri bato Pilato Jesure sinituahye: —‍¿Judio masa pʉhtota ijiajari mʉhʉ? niahye tiquiro Jesure. —‍Mʉhʉ nino sahata ijiaja, ni yʉhtiahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Tiquiro sa nigʉ̃ Pilato pahia pʉhtoare, masa gʉ̃hʉre yahuahye: —‍Ahriquiro buhiri mariedare, niahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Tiquiro sa niepegʉ̃ta tiquina tutuaro yahusã nemoahye: —‍Tiquiro buheye mehna masare cahmequegʉ̃ yere. Galilea yehpapʉ tiquiro tire ye dʉcari. Sa ye dʉca tuhasa ijipihtiro Judea yehpapʉ tire tiquiro yere. Sa yero yojopʉ ohõpʉ gʉ̃hʉre tire yero taro nine, ni, yahusãhye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Tiquina sa ni yahusãgʉ̃ tʉhoro Pilato pehe sinituahye: —‍¿Ahriquiro Galilea cjʉ̃no ijiajari? niahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","—‍To cjʉ̃nota ijire, ni yʉhtiahye apequina. Tiquina sa ni yʉhtigʉ̃ tʉhoro Pilato pehe Jesu tiquiro ijiri yehpare masino pʉhtoro Herode ya yehpa cjʉ̃no Jesu tiquiro ijigʉ̃ masiahye. Tire masino Jesure Herode cahapʉ ohoahye. Ti pjere Herode Jerusalẽpʉ ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","To pano Herode Jesure tʉho tuhasahye. Tiquiro sa tʉhori bato yoari bato tiquirore ihña duahye. Jesu Cohãcjʉ̃ tutuaye mehna tiquiro ye ihñogʉ̃ ihña duamahye tiquiro. Sa yero tiquiro Jesure ihñano, bucueahye. ");
INSERT INTO pirNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Sa yero peye tahari sinituahye Jesure. Tiquiro sa sinituepegʉ̃ta Jesu ne yʉhtierahye tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Pahia pʉhtoa, judio masare buheyequina gʉ̃hʉ Herode cahapʉ esa, tutuaro Jesure yahusãhye. ");
INSERT INTO pirNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Tiquina yahusãri bato, Herode tiquiro yequina surara mehna bʉjʉpe, Jesure ñano yeahye. Sa bʉjʉpeye, quehnoari suhtirore pʉhtoro tiquiro sañari suhtiro yero saha bajuri suhtirore sãahye tiquina Jesure. Sa bʉjʉpe tuhasa, tiquirore Pilato cahapʉ ohoahye tja. ");
INSERT INTO pirNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ti decore Herode, Pilato mehna quehnoano tiquina basi cahme yeyequina iji dʉcahye. To panore tiquina basi cahme ihña tuhtiyequina ijinimahye. ");
INSERT INTO pirNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Sa ye Pilato pahia pʉhtoare, apequina pʉhtoare, masa gʉ̃hʉre tiquiro pijiogʉ̃, cahmecoahye. ");
INSERT INTO pirNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Tiquina cahmecoa pihtigʉ̃ ihñano ohõ saha niahye Pilato tiquinare: —‍Ahriquirore yʉhʉre ne cãhtana, “Tiquiro masare ñano ye dutiri”, nimedi mʉsa yʉhʉre. Yojopʉ mʉsa ihñonopʉ ahriquirore quehnoano sinitu pehou tja. Yʉhʉ sa sinituri bato mʉsa tiquirore sa yahusãducugʉ̃ tiquirore ñañe buhiri ne mariedare, yʉhʉ ihñagʉ̃. ");
INSERT INTO pirNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herode gʉ̃hʉ tiquirore “Ne, ñañe buhiri mariedare”, nidi. Sa nino ahriquirore pari turi ʉsãre oho majare tojore tja. Sa yena ahriquirore tiquiro ñañe buhiri mariedagʉ̃ tiquirore mʉsa wejẽ duti masiedare. ");
INSERT INTO pirNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Sa yegʉ tiquirore yuta dari mehna tana dutiitja yʉhʉ. Sa tiquina tanari bato tiquirore wioutja, nimahye Pilato masare.  ");
INSERT INTO pirNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Cʉhmaripe pascua bose decorire masa yaquiro ijiatiquirore ihcãquiro peresupʉ ijiriquirore Pilato wio basaducue tiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Sa ye Pilato “Jesure wioutja”, tiquiro nigʉ̃ tʉhoye ijipihtiyequina masa ohõ saha ni sañuducuahye: —‍Tiquirore Jesure wejẽña. Barrabá pehere ʉsãre wio basaya, ni sañuducuahye masa. ");
INSERT INTO pirNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","To pano Barrabá pehere Jerusalẽpʉ pʉhtoare tiquiro cohã dutiri buhiri, masare tiquiro cahmeque dutiri buhiri, tiquiro wejẽdi buhiri, peresu yeahye tiquirore. Sa ye camepʉre tiquirore masa wio dutiye niahye. ");
INSERT INTO pirNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato Jesu pehere wio duamahye. Sa yero tiquiro masare sinituahye tja. ");
INSERT INTO pirNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Tiquiro sa wio duepegʉ̃ta tiquina tiquirore niahye tja: —‍Curusapʉ quẽ biha wejẽña tiquirore. Wejẽña tiquirore, ni sañuducuahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Tiquina sa nigʉ̃ Pilato ihtia taha waro ohõ saha nimahye tiquinare: —‍¿Yabere ñano yeri tiquiro mʉsa sa ni sañuducugʉ̃? Ne tiquirore ñañe buhiri mariedare. Sa yegʉ tiquirore wejẽ duti masiedaja. Tiquirore yuta dari mehna tana dutiitja. To punota ye dutiitja. Sa yegʉ wioutja tiquirore, nimahye Pilato. ");
INSERT INTO pirNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Tiquiro sa niepegʉ̃ta tiquina tutuaro mehna sañuducu nemo, Jesure curusapʉ wejẽ dutiahye. Tiquina sa ni sañuducugʉ̃ tʉhoro tiquina cahmediro sahata Pilato yeahye. ");
INSERT INTO pirNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Sa yero tiquina sinidiro sahata Pilato Jesure wejẽ dutiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Sa dutiro tiquiro peresupʉ ijiriquirore masare cahmequegʉ̃ yeriquirore, masare wejẽdiquirore masa tiquina sinidiro sahata Pilato Barrabá pehere wioahye. Sa yero Pilato Jesure curusapʉ wejẽ dutiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Sa ye tiquina Jesure wejẽñe wahaye, neahye. Ti pje tiquina sa yeri watoa Simo wame tiriquiro Cirene cjʉ̃no ihquẽ wʉhʉse ijiropʉ esariquiro tojoa taro niahye. Jerusalẽpʉ tiquiro wihigʉ̃ ihñañe Jesure neañequina tiquirore piti ca, ñehe, curusare tiquirore wʉa cã dutiahye Jesu bato pehe. ");
INSERT INTO pirNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Sa ye masa peyequina Jesure ihña nʉnʉ tãhye. Sa ye masa watoa ijiyequina numia tiquirore tiquina sa yegʉ̃ ihñañe tutuaro utiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Tiquina utigʉ̃ tʉhoro, tiquina numiare Jesu majare ihña, ohõ saha niahye: —‍Jerusalẽ cjãna numia, yʉhʉre utieracãhña. Mʉsa ye ijiatire, mʉsa pohna ye ijiati gʉ̃hʉre utiya. ");
INSERT INTO pirNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Apeye decori ijigʉ̃ ña yʉhdʉaro yʉhdʉnata mʉsa. Ti pjere masa ohõ saha nieta. “Pohna mariena numia, pohna tiena numia, apũoedari numia yojopʉ mari ijigʉ̃ quehnoa yʉhdʉaboaga”, nieta numia. ");
INSERT INTO pirNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ti pjere cʉnʉre ohõ saha ni yahuducueta masa. “Mʉhʉ cʉnʉ ʉsã buipʉ bora dijia taya. Ʉsãre nʉoña”, nieta masa cueye. ");
INSERT INTO pirNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Masa yʉhʉre buhiri mariegʉre ohõ saha tiquina yegʉ̃, ñañe buhiri cʉoyequina pehe ña yʉhdʉaro wahaeta, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Apequina pʉaro dutiyere yʉhdʉdʉcayequina tiquina ijigʉ̃ tiquina gʉ̃hʉre Jesu mehna tiquina wejẽatiquinare neahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Tiquinare nea, “Dapu pehtoro”, wame tiropʉ esa, curusapʉ Jesure quẽ biha ohõahye. Sa ye pʉaro yʉhdʉdʉcayequina gʉ̃hʉre apequirore tiquiro poto pehe, apequirore tiquiro cũ pehe pehe quẽ biha ohõahye. ");
INSERT INTO pirNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Tiquina sa yegʉ̃ Jesu ohõ saha niahye: —‍Mai, ahriquina yʉhʉre wejẽatiquina yojopʉ tiquina ñano yerire boya tiquinare. Tiquina dʉhse yerire masiedare tiquina. Sa yegʉ tiquina ñano yerire boya, niahye Jesu. Sa ye Jesu suhtire cahme itiye, tiquina doquepeahye. Tiquiro suhtire “¿Noa yaro ijirotari ohõ?” ni cahme doquepeahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Sa ye masa topʉ ducuyequina tiquina ihñaducuri watoa judio masa pʉhtoa Jesure bʉjʉpeahye: —‍Tiquiro apequina masare yariaboriquinare yʉhdʉoñohti. Sa yero tiquiro Cristo Cohãcjʉ̃ beseriquiro ijiro, yojopʉ yariaboriquiro ijiro, tiquiro basi yʉhdʉoahro, ni, bʉjʉpeahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Surara gʉ̃hʉ tiquirore bʉjʉpeahye. Jesu cahapʉ esa, tiquina tiquirore ñañe co vinore ohomahye. ");
INSERT INTO pirNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Tire yeye ohõ saha niahye tiquina: —‍Mʉhʉ judio masa tiquina pʉhto ijigʉ mʉhʉ basi yʉhdʉya. Sa yegʉ yʉhdʉ witigʉta mʉhʉ, ni, bʉjʉpeahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Sa ye tiquiro bui ohõ saha ni ojoa ohõahye. “AHRIQUIRO JUDIO MASA PɄHTORO IJIRE”, ni, ojoa ohõahye. ");
INSERT INTO pirNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Apequiro tiquiro mehna tiquina quẽ biha ohõriquiro yʉhdʉdʉcariquiro pehe ñano yahuducuahye Jesure: —‍¿Mʉhʉ Cristo masare yʉhdʉoacjʉ ijierajari? Mʉhʉ basi, ʉsã gʉ̃hʉre yedohoya, niahye tiquiro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Tiquiro sa nigʉ̃ tʉhoro apequiro yʉhdʉdʉcariquiro Jesu poto pehepʉ tiquina quẽ biha ohõriquiro pehe tiquirore ohõ saha niahye: —‍Mari gʉ̃hʉre poto ijiye mehna buhiri dahrere tiquina. ¿Dʉhsegʉ Cohãcjʉ̃re ne ño peoerajari mʉhʉ? ");
INSERT INTO pirNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Marine ñañe buhiri ye, poto yeye nine tiquina. Ñañene mari yeri buhiri marine buhiri dahrere tiquina. Ahriquiro pehe ñañene yerare, niahye tiquiro apequiro yʉhdʉdʉcariquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Sa nino, tiquiro Jesure ohõ saha niahye: —‍Jesu, mʉhʉ pʉhto ijigʉ tojoa tagʉ, yʉhʉre wacũña, niahye tiquiro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","—‍Mʉhʉre ahrire nii niaja. Miare paraíso wame tiropʉ mʉhʉ yʉhʉ mehna ijiita, niahye Jesu tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Sa ye coheri pje ijigʉ̃ asʉ̃ asi duhuahye. Sa yero ijipihtiro ti dihtapʉre ihtia hora waro quehnoano nahitiahye. ");
INSERT INTO pirNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Nahitiari watoa, Cohãcjʉ̃ wʉhʉ cjã suhtiro cahsero, tiquina tore cahmotari cahsero decopʉ ti cahsero ʉhmʉsepʉ tʉhnʉ dʉca, tʉhnʉ yojoa saa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Sa yero Jesu tutuaro sañuducuahye: —‍Mai, yʉhʉ jeripohnare mʉhʉre wiaja mʉhʉ ihña ihboatire, ni, sañuducuahye Jesu. Sa ni tuhasa yariaa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Tiquiro sa yariagʉ̃ ihñano, surara pʉhtoro pehe “Cohãcjʉ̃ tutuariquiro ijire”, nino, “Ahriquiro Jesu mʉnano potota quehnoariquiro ijimeya”, niahye surara pʉhtoro. ");
INSERT INTO pirNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Sa ye tiquina wejẽgʉ̃ ihñañe ahtariquina Jesu tiquiro yariagʉ̃ ihñañe, tiquina ye wʉhʉsepʉ tojoaa wahahye. Tojoaa waha, tiquina ñañe yerire bʉjʉa witiye mehna tiquina cutiro bui quẽ ohõahye. ");
INSERT INTO pirNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ijipihtiyequina Jesu yequina tiquiro mehna cjẽna Galileapʉ tiquiro mehna ahtariquina numia gʉ̃hʉ Jesure yoaropʉ ihñaducuahye. ");
INSERT INTO pirNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ti pjere José wame tiriquiro topʉ ijiahye. Judea yehpa cjã maca Arimatea wame tiri maca cjʉ̃no ijiahye. Sa yero tiquiro quehnoariquiro, poto yeriquiro ijiro, Cohãcjʉ̃ pʉhtoro iji dʉcatire cohteriquiro ijiahye. Sa yero tiquiro judio masa pʉhtoa mehna cjʉ̃no ijieperota Jesure tiquina wejẽ dutigʉ̃ cahmedamahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Sa yero Pilato cahapʉ esa, Jesu pagʉre siniahye. ");
INSERT INTO pirNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Sini tuhasa, Jesu pagʉre ne dijio, quehnoari suhtiro mehna tiquiro pagʉre wahmeahye. Sa wahme tuhasa, masa copepʉ ʉtãpʉ tiquina seheri copepʉ cũahye tiquiro pagʉre. Ti copere ne apequina yariariquinare cũedarĩahye. ");
INSERT INTO pirNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ti deco saurú deco ijiatire tiquina quehnoyuri deco ijiahye. Saurú tiquina sori deco ijiati mehenogã dʉhsahye. ");
INSERT INTO pirNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Sa ye Galileapʉ Jesu mehna ahtariquina numia masa copepʉ José mehna wahahye. Masa copepʉ esa, ti copere ihña, Jesu pagʉre tiquina cũrire ihñahye. ");
INSERT INTO pirNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Came tiquina ye wʉhʉsepʉ tojoaa waha, ehme sitiye co, wisõñe mehna quehnoahye tiquina. Sa ye saurú ijigʉ̃ Cohãcjʉ̃ dutiye Moisere tiquiro cũri dutiye nino sahata tiquina soahye. ");
INSERT INTO pirNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Domingo ijigʉ̃ bohrearopʉ tiquina numia ehme sitiye tiquina quehnorire Jesu masa copepʉ ne cãmahye. ");
INSERT INTO pirNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ti copepʉ esa, ti copere bihariare ʉtãre tiquina põo duhu cũria ʉtãre ihñahye. ");
INSERT INTO pirNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Sa ihñañe tiquina ti copepʉ sajãa wahahye. Jesu pagʉre bocaerahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Tiquiro pagʉre bocaera, “¿Dʉhse wahayari?” ni tʉhotuahye tiquina. Tiquina sa ni tʉhotu yahuducuri watoa pʉaro ʉmʉa asi siteye suhti sañañequina tiquina cahapʉ ducuahye. ");
INSERT INTO pirNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Topʉ tiquina ducugʉ̃ ihña, numia cueye, dʉsepe curi mehna quehe sahye. Sa ye ʉmʉa pehe tiquinare yahuahye: —‍¿Dʉhsena yariariquiro ijirore Jesure macajari mʉsa? Yojopʉre tiquiro catiriquiro ijire. ");
INSERT INTO pirNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Tiquiro ohõre mariedare. Masa wijia tuhasari. ¿Sohõ ijiri pjere tiquiro Galileapʉ mʉsa mehna ijiro mʉsare tiquiro nidire wacũajari mʉsa? ");
INSERT INTO pirNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“Yʉhʉre Cohãcjʉ̃ ohorigʉre apequiro ohorota ñañequinare. Tiquiro ohori bato yʉhʉre curusapʉ quẽ biha wejẽeta tiquina. Sa yegʉ yʉhʉ yariari bato ihtia deco wahaboro masa wijiagʉtja yʉhʉ”, nidi mʉsare. ¿Tiquiro sa nidire wacũajari mʉsa? niahye ʉmʉa pehe. ");
INSERT INTO pirNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Tiquina sa nigʉ̃ tʉhoye, numia pehe tiquiro nidire wacũahye. ");
INSERT INTO pirNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Tiquina sa nidi bato tiquina tojoaa waha, once buheyequinare apequina gʉ̃hʉre tire yahu pehoahye. ");
INSERT INTO pirNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Tiquina numia pehe María Magdalena, Juana, María Santiago pacoro ijiahye. Tiquina numia apequina numia gʉ̃hʉ ijiahye Jesu buheyequinare yahuri numia. ");
INSERT INTO pirNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Tiquina sa ni yahuepegʉ̃ta Jesu buheyequina pehe “Poto niñe niedaga. Ni mehoñe niaga ahriquina numia”, ni tʉhotumahye. Sa ye tiquina numiare tʉho duerahye. ");
INSERT INTO pirNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Tiquina sa nigʉ̃ tʉhoro, Pedro pehe masa copepʉ oma cã, ihñano wahahye. Ti copepʉ esa, tiquiro muhri ihña sõahye. Jesure tiquina wahmedi suhtiro dihitare ihñahye. “¿Dʉhse wahayari?” ni, tʉhotu, tiquiro ya wʉhʉpʉ tojoaa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ti decota pʉaro Jesu buheyequina mehna cjẽna Emau wame tiri macapʉ wahaye niahye. Jerusalẽ once kilómetro yoaro ijire Emaupʉ esato. ");
INSERT INTO pirNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Emaupʉ waha, ijipihtiye Jerusalẽpʉ ti pjere Jesu tiquiro sa waharire tiquirore tiquina ñano yerire yahuducu cãñe niahye. ");
INSERT INTO pirNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Tiquina sa ni yahuducuri watoa Jesu pehe tiquina cahapʉ esa, tiquina mehna wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Sa ye tiquirore ihñaepeta tiquina tiquirore ihña masiedahye. ");
INSERT INTO pirNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","—‍¿Dʉhse ni yahuducu cãna niajari mʉsa? ni, sinituahye Jesu. Tiquiro sa nigʉ̃ tiquina bʉjʉa witiyequina esadʉcahye. ");
INSERT INTO pirNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Cleofa wame tiriquiro pehe Jesure yʉhtiahye: —‍¿Yojopʉre Jerusalẽpʉ tiquina yerire mʉhʉ dihita masiedajari? ni sinituahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","—‍¿Dʉhse wahari Jerusalẽpʉre? niahye Jesu. Tiquiro sa nigʉ̃ Cleofa yʉhtiahye: —‍Jesure Nazare cjʉ̃nore tiquina yerire nina niaja. Tiquiro Cohãcjʉ̃ yere yahu mʉhtariquiro ijimedi. Sa ye tiquiro yahuducurire tʉhoye, tiquiro yeri gʉ̃hʉre ihñañe, “Tutuariquiro ijire”, ni, tʉhotumedi masa. Cohãcjʉ̃ gʉ̃hʉ sata ni tʉhotuaga. ");
INSERT INTO pirNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Mari pahia pʉhtoa, apequina pʉhtoa mehna tiquirore wejẽ dutiye, apequinare ohori. Tiquina sa ohogʉ̃ apequina pehe tiquirore curusapʉ quẽ biha wejẽdi. ");
INSERT INTO pirNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","“Roma cjẽnare cohãtiquiro Israe masa pʉhtoro ijiatiquiro ijire”, ni, tʉhotumi ʉsã tiquirore. Mia mehna ihtia deco wahare tiquiro yariari bato. ");
INSERT INTO pirNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Meheñequinagã numia ʉsã mehna cjẽna numia ʉsãre acʉagʉ̃ yeri. Bohrearopʉ Jesu tiquiro masa copepʉ tiquina numia esa, ");
INSERT INTO pirNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","tiquiro pagʉre bocaerañohti. Tiquiro pagʉre bocaeraye, tiquina tojoa wihi yahuri. “Ʉsãre angele bajuari. Jesu catiñohti”, ni yahuri ʉsãre numia pehe. ");
INSERT INTO pirNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Tiquina sa nigʉ̃ apequina ʉsã mehna cjẽna ti copepʉ esa, numia tiquina nidiro sahata ihñañohti. Tiquina gʉ̃hʉ Jesure ihñedañohti, niahye tiquiro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Tiquiro sa nidi bato Jesu yahuahye tiquinare: —‍Mʉsa ne tʉho masiedare. ¿Cohãcjʉ̃ yere yahu mʉhtariquina mʉna tiquina nidire quehnoano tʉhoerari mʉsa? ");
INSERT INTO pirNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Cristore tiquiro pʉhtoro ijiato pano ʉhmʉsepʉ tiquiro mʉjato pano tiquirore ñano yʉhdʉro cahmedi. ¿Tire masiedajari mʉsa? niahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Sa nino Cohãcjʉ̃ Cristore tiquiro ni yahu tiquina ojoarire Jesu yahu peho cãhye tiquinare. Moise mʉnano tiquiro ojoarire Jesu yahu dʉcahye. Sa yero ijipihtiyequina Cohãcjʉ̃ yere yahu mʉhtariquina Cristore tiquina ojoari gʉ̃hʉre yahu peho cãhye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Tiquina wahari macapʉ tiquina esaye taye yegʉ̃, Jesu pehe tiquinare yʉhdʉ cãa wahamahye. ");
INSERT INTO pirNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Tiquiro sa yepegʉ̃ta tiquina tiquirore waha dutierahye: —‍Ʉsã mehna tojoaya. Ñamicahapʉ ijire. Nahinopʉ nine, niahye tiquina tiquirore. Sa yero Jesu tiquina mehna wʉhʉpʉ sajãa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Wʉhʉpʉ sajã sa, tiquiro tiquina mehna ihyari mesapʉ nuju sa, pãre ne, Cohãcjʉ̃re “Quehnoare”, niahye. Sa nino ti pãre nuha ne, tiquinare ohoahye. ");
INSERT INTO pirNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tiquiro sa yegʉ̃ ihñañe tiquina Jesure ihña masiahye. Tiquina ihña masi dʉcagʉ̃ta tiquiro buti maa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Tiquiro sa buti maa wahagʉ̃ ihñañe tiquina basi ohõ saha ni yahuducuahye: —‍Mahapʉ tiquiro marine tiquiro yahuducuri watoa Cohãcjʉ̃ tiquiro ojoarire tiquiro yahuri watoa mari jeripohnari mehna quehnoano bucueye mehna tʉhotuu mari, niahye tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Sa ni tuhasa tiquina duita Jerusalẽpʉ majare tojoaa wahahye tja. Topʉ esa, once buheyequinare apequina mehna cahmecoañequinare bocahye. ");
INSERT INTO pirNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Tiquina esagʉ̃, once buheyequina ohõ saha niahye: —‍Potota mari pʉhtoro masa wijiañohti. Simo Pedro tiquirore ihñañohti, niahye once buheyequina. ");
INSERT INTO pirNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Tiquina sa nigʉ̃ pʉaro Emau cjẽna mahapʉ Jesure tiquina ihñarire yahuahye: —‍Jesu pãre tiquiro nuhagʉ̃ ʉsã ihña masii tiquirore, ni, yahu pehoahye tiquina apequinare. ");
INSERT INTO pirNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Tiquina sa ni yahuri watoa tiquina cahapʉ iji tuhasahye Jesu pehe. —‍¿Ijiajari mʉsa? niahye tiquiro tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Tiquiro sa nigʉ̃ tʉhoye tiquina “Mari yariariquiro mʉnanore ihñana niaja”, ni tʉhotuye, tutuaro cueahye. ");
INSERT INTO pirNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Tiquina sa cuegʉ̃ ihñano tiquiro tiquinare yahuahye: —‍¿Dʉhsena cueajari mʉsa? ¿Dʉhsena “Ahri poto ijierare”, niajari mʉsa? ");
INSERT INTO pirNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Yʉhʉ omocarine, yʉhʉ dahpocãri gʉ̃hʉre ihñaña. Mʉsa yʉhʉre ihñana, ihña masinata. Yʉhʉre ñehe tuhuya. Ñehe tuhuna masinata mʉsa. Yariariquiro mʉnanopʉ pagʉ mariedare. Yʉhʉ pehe pagʉ tiaja, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Sa nino tiquiro omocari gʉ̃hʉre, tiquiro dahpocãri gʉ̃hʉre ihñoahye tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Tiquiro sa ihñoepegʉ̃ta tiquina tutuaro bucue, ihña maria waha, “Ahri poto ijieraga”, ni tʉhoturĩahye. Tiquina sa tʉhotugʉ̃ masino Jesu tiquinare sinituahye: —‍¿Ohõpʉ ihyaye ijiajari? niahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Tiquiro sa nigʉ̃ tʉhoye wahi dohariquirore ohoahye tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Tire ne, tiquina ihñonopʉ Jesu ihyahye. ");
INSERT INTO pirNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ihya tuhasa, Jesu yahuahye tiquinare: —‍Sohõ ijiri pje mʉsa mehna ijigʉ mʉsare yʉhʉ yahuriro sahata yojopʉ yʉhʉ sa wahaʉ. Cohãcjʉ̃ dutiye Moise marine tiquiro cũri tiquiro sa ni ojoariro sahata yʉhʉre sa wahari. Cohãcjʉ̃ yere yahu mʉhtariquina, Salmo ojoari pũre ojoayequina gʉ̃hʉ panopʉ yʉhʉre tiquina ni yahuriro sahata yojopʉre yʉhʉre sa wahari. Sa wahacjʉta ijii yʉhʉ, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Sa ni tuhasa Cohãcjʉ̃ yere tiquina yahu ojoarire tiquiro buheyequinare masigʉ̃ yeahye Jesu: ");
INSERT INTO pirNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","—‍Cohãcjʉ̃ yere tiquina ojoari ohõ saha nine: “Cristore ñano yʉhdʉro cahmene. Sa yero ihtia deco wahaboro tiquiro yariari bato tiquiro masa wijiarota. ");
INSERT INTO pirNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Tiquiro masa wijiari bato ijipihtiye yehparipʉ tiquiro yequina Cristo yere yahueta. Masa tiquina ñañene tiquina bʉjʉa witiatire, quehnoañene tiquina camesatire Cohãcjʉ̃ tiquina ñañene tiquiro cohãtire yahueta tiquiro yequina. Sa yahuye taye, Jerusalẽpʉ yahu dʉcaeta”, niahye Cohãcjʉ̃ yere tiquina ojoari pũpʉ, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Sa ni tuhasa ohõ saha ni yahu nemoahye: —‍Mʉsa pehe ahri ijipihtiyere ihñarina ijire. Sa yena apequinare yahunata. ");
INSERT INTO pirNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","“Espíritu Santore mʉsare ohoutja”, Cohãcjʉ̃ tiquiro nidiquirore yʉhʉ pehe mʉsare ohoutja. Tiquiro ʉhmʉse cjẽ tutuayere ohoatiquiro ijire. Sa yena Jerusalẽpʉ tiquiro wihiatire cohteya mʉsa, niahye Jesu tiquiro buheyequinare. ");
INSERT INTO pirNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Sa ni tuhasa Jesu tiquinare Jerusalẽpʉ ijiyequinare Betania cahapʉ neahye. Topʉ esa, Jesu tiquiro omocarine ne mʉo, “Quehnoano ijiya”, niahye tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Sa ni tuhasa, tiquinare cũ, ʉhmʉsepʉ mʉjaa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Tiquiro mʉjari bato tiquina tiquirore ño peo, Jerusalẽpʉ tutuaro bucueye mehna tojoaa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Topʉ iji, decoripe tiquina Cohãcjʉ̃ wʉhʉpʉ Cohãcjʉ̃ mehna yahuducu, “Quehnoare”, ni ño peoahye tiquina tiquirore. To punota ijire.");
INSERT INTO pirNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Duitapʉta ahri yehpa to ijiato panopʉta Cohãcjʉ̃ ye yahuducuyere yahuriquiro Cristo masare yʉhdʉoatiquiro duita iji tuhasae tiahye. Tiquiro Cohãcjʉ̃ mehna ijiahye. Sa yero tiquiro Cohãcjʉ̃ta iji cãhno niahye. ");
INSERT INTO pirNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Duitapʉta coã waropʉre Cristo Cohãcjʉ̃ mehna ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Sa yero coã waropʉre ne mariedarire bajumehneahye. Ahri yehpare, ʉhmʉsere, ijipihtiyere, masa gʉ̃hʉre bajumehne dutiahye Cohãcjʉ̃ tiquirore. Sa yero ahrire bajumehne pehoahye tiquiro. Ahrire yojopʉre mari ihñañene, mari ihñedari gʉ̃hʉre tiquiro bajumehnedagʉ̃ ne mariedaboya. ");
INSERT INTO pirNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Cristo catiyere ohoriquiro ijiro nine. Buhrioro marine to quehnoano ihña masigʉ̃ yero saha mari Pacʉre quehnoano masigʉ̃ yere. Sa yero mari Pacʉre masigʉ̃ yere masare. ");
INSERT INTO pirNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ahri yehpa cjẽna ñañene wacũ, tiquina tutuaro cahmeñe nahitiano yero saha ijiye nine. Buhrioro quehnoano marine to ihña masigʉ̃ yero saha Cohãcjʉ̃ ye yahuducuyere yahuriquiro masare masigʉ̃ yere. Sa yero nahitiano buhriorore to yʉhdʉdʉcaero sahata Cristore ne ñañe yʉhdʉdʉcaerare. ");
INSERT INTO pirNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Cohãcjʉ̃ Ñu wame tiriquiro pehere ohoahye, Cristo buhrioro yero saha ijiriquirore masare yahu mʉhta dutiro. Tiquiro ohogʉ̃ Ñu pehe masare yahuro ahtari tiquiro yahuriquirore Cristore ijipihtiyequina tiquina wacũ tutuatire. ");
INSERT INTO pirNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ñu pehe Cristo ijierari. Sa ijieraro tiquiro Cristo pehere masare yahu mʉhtano ahtari. ");
INSERT INTO pirNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Cristo buhrioro yero saha ijiriquiro ijipihtiyequina masare Cohãcjʉ̃re masigʉ̃ yeatiquiro pehe ahri yehpapʉ ahtari jiri. Ijirota ijire ahri. Tiquiro buhrioro yero saha ijiriquiro warota ijire. ");
INSERT INTO pirNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Sa yero Cristo ahri yehpapʉ ijiri jimedi. Ahri yehpare bajumehnediquiro ijiahye. Tiquiro sa ijiepegʉ̃ta tiquiro ya yehpa cjẽna tiquirore ne masiedari. ");
INSERT INTO pirNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Tiquiro ya yehpapʉ masa bajuari jimedi. Tiquiro ya yehpapʉ tiquiro masa bajuariquiro ijiepegʉ̃ta tiquiro ya yehpa cjẽna pehe ne tiquirore cahmedari jiri. ");
INSERT INTO pirNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Tiquina sa cahmedapegʉ̃ta apequina pehere ijipihtiyequina tiquirore cahmeñequina pehere tiquinare Cohãcjʉ̃ tiquiro pohne ijigʉ̃ yeri jiri. Tiquirore wacũ tutuayequina pũrita potota tiquiro pohne warota ijire. ");
INSERT INTO pirNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Tiquina Cohãcjʉ̃ pohneta ijiye nine. Sa ye masa tiquina masa bajuariro saha ijierare, Cohãcjʉ̃ pohne tiquina wahagʉ̃. ");
INSERT INTO pirNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Sa yero Cristo masʉno tiquiro iji dʉcari bato mari mehnata ijire tiquiro. Tiquiro sa ijigʉ̃ ihñana masare cahĩniquiro, potota yahuriquiro tiquiro ijigʉ̃ ʉsã masii. Tiquiro dihita Cohãcjʉ̃ macʉno ijiro tutuariquiro quehnoariquiro ijiri. Tiquiro sa ijiriquiro ijigʉ̃ ʉsã masii. ");
INSERT INTO pirNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ñu Cristore yahu mʉhtano ohõ saha ni sañuducuri masare yahuro: —‍Siquiro ahtare yʉhʉ ohõ saha ni yahuriquiro: “Tiquiro yʉhʉ bato ahtariquiro ijire. Sa ijieperota tiquiro yʉhʉ yʉhdʉoro tutuariquiro ijire. Tiquiro yʉhʉ masa bajuato panopʉ iji tuhasahye. Sa yero tiquiro yʉhʉ yʉhdʉoro tutuariquiro ijire”, mʉsare yʉhʉ ni yahuriquiro ahriquirota ijire, nidi Ñu Jesure masare yahuro. ");
INSERT INTO pirNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Tiquiro Cristo pehe quehnoano tutuaro masare cahĩniquiro ijiro marine ijipihtinare quehnoano yeducuri. ");
INSERT INTO pirNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Cohãcjʉ̃ dutiyere Moise pehe cũ mʉhtahye marine. Jesucristo pehe Cohãcjʉ̃ masare tiquiro cahĩñene buhero ahtari. Cohãcjʉ̃ tiquiro potota yahuducuye gʉ̃hʉre buhero ahtari. ");
INSERT INTO pirNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Masa ne Cohãcjʉ̃re ihñedare. Tiquirore mari ihñedapegʉ̃ta tiquiro macʉno ihcãquirota ijiriquiro tiquiro Pacʉro mehna sa ijiducure. Sa yero tiquiro Pacʉrore marine masigʉ̃ yeri. ");
INSERT INTO pirNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ʉsã acaye judio masa pʉhtoa Jerusalẽpʉ ijiyequinare pahiare, Cohãcjʉ̃ wʉhʉpʉ dahrayequina gʉ̃hʉre Ñu cahapʉ ohori jiri. “¿Noa boro ijiajari mʉhʉ?” ni sinitu dutiye ohori jiri tiquinare. Tiquina sa sinitugʉ̃ ohõ saha ni yahuri Ñu pehe. ");
INSERT INTO pirNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yeero boro marieno yahuri. Potota yahuri: —‍Yʉhʉ Cristo Cohãcjʉ̃ masare yʉhdʉo dutiro tiquiro ohorigʉ ijieraja, nidi tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Tiquiro sa nigʉ̃ tiquina pehe tiquirore pari turi sinituri tja: —‍¿Mʉhʉ Cristo ijieragʉ Elia pehe ijiajari mʉhʉ? nidi tiquina. —‍Ijieraja yʉhʉ, nidi tiquiro. —‍¿Ʉsã cohterigʉ Cohãcjʉ̃ yere yahu mʉhtacjʉ pehe ijiajari mʉhʉ? nidi tiquina. —‍Tiquiro ijieraja yʉhʉ, nidi Ñu pehe. ");
INSERT INTO pirNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Tiquiro sa nigʉ̃ tiquina tiquirore pari turi sinituri tja: —‍Ʉsãre sinitu dutiriquinare ʉsã yahuro quehnoano poto ʉsãre yahu madoqueohya. ¿Noa boro pehe ijiajari mʉhʉ? ¿Mʉhʉ basita dʉhse ijigʉ ijiajari mʉhʉ? “Sa ijigʉ ijiaja yʉhʉ”, ni yahuya ʉsãre, nidi tiquina Ñure. ");
INSERT INTO pirNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Tiquina sa nigʉ̃ ohõ saha ni yʉhtiri tiquiro: —‍Masa marienopʉ ohõ saha ni sañuducugʉ ijiaja yʉhʉ, Cohãcjʉ̃ yere yahu mʉhtariquiro Isaia mʉnano tiquiro ni yahuriro sahata: “Mari pʉhtoro tiquiro ahtato pano mahare mari quehnoyuro saha quehnoana ijiyuya mʉsa”, ni masare yahu sañuducugʉ ijiaja yʉhʉ, nidi Ñu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ñure sinituyequina fariseo masa tiquina ohoriquina ijiri. ");
INSERT INTO pirNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Sa ye tiquina Ñure sinituri tja: —‍¿Mʉhʉ Cristo, Elia, Cohãcjʉ̃ yere yahu mʉhtagʉ ʉsã cohterigʉ ijierapegʉta dʉhsegʉ masare wame yeajari mʉhʉ? nidi tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Tiquina sa nigʉ̃ tʉhoro yʉhtiri tiquiro: —‍Yʉhʉ aco mehna masare wame yeaja. Apequiro pehe mʉsa masieniquiro pehe mʉsa watoa iji tuhasare. ");
INSERT INTO pirNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Tiquiro pehe yʉhʉ bato ahtariquiro yʉhʉ yʉhdʉoro tutuariquiro ijire. Quehnoa yʉhdʉariquiro ijire. Tiquiro yero saha ijieraja yʉhʉ pehe. Sa yegʉ tiquirore tʉhotugʉ, “Ihyo ijigʉ ijiaja yʉhʉ”, ni tʉhotuaja yʉhʉ, nidi Ñu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Sa ni yahuducuri tiquina, Betaniapʉ Jordã wame tiri ma ape sie pahrẽpʉ, Ñu masare tiquiro wame yeriropʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ape decopʉ Jesu Ñu cahagã cjũno tiquiro ahtagʉ̃ Ñu tiquirore ihñano ohõ saha nidi: —‍Ihñaña. Ahriquiro Cohãcjʉ̃ ohoriquiro tiquiro yaquiro cordero yero saha ijiriquiro ijire. Corderore mari wejẽdiro sahata masa ahriquiro gʉ̃hʉre wejẽeta. Sa yariaro ahri yehpa cjẽnare tiquina ñañe yerire cohãnota tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ahriquirota ijire yʉhʉ ohõ saha nidiquiro: “Yʉhʉ bato ahtariquiro yʉhʉ yʉhdʉoro tutuariquiro ijire. Yʉhʉ masa bajuato pano tiquiro iji tuhasahye. Sa yero tiquiro yʉhʉ yʉhdʉoro tutuare”, yʉhʉ nidiquiro ahriquirota ijire. ");
INSERT INTO pirNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Yʉhʉ pehe ahriquirore masiedahti. Sa masiedapegʉta aco mehna wame yei ahtaʉ nii yʉhʉ acaye Israe masa ahriquirore tiquina masiatore, nidi Ñu. ");
INSERT INTO pirNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Sa ni tuhasa Ñu yahu nemori: —‍Espíritu Santo ʉhmʉsepʉ bujua yero saha Cristo bui dijia ta, tiquiro bui wihidʉcagʉ̃ ihñaʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Cohãcjʉ̃ yʉhʉre tiquiro yahueragʉ̃ tiquirore ne masiedaboaga yʉhʉ. Tiquiro yʉhʉre mʉsare aco mehna wame ye dutiro ohoriquiro Cohãcjʉ̃ pehe ohõ saha ni yahu mʉhta tuhasari yʉhʉre: “Espíritu Santo dijia ta tiquiro bui wihidʉcanohriquiro tiquirota ijirota. Tiquiro pehe Espíritu Santore masa mehna ijiducugʉ̃ yerota”, nidi Cohãcjʉ̃ yʉhʉre. ");
INSERT INTO pirNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Yojopʉ pũritare tiquirore ihña tuhasaʉ yʉhʉ. Sa ihñagʉ “Potota Cohãcjʉ̃ macʉno ijire”, nii yʉhʉ mʉsare, ni yahuri Ñu ʉsãre. ");
INSERT INTO pirNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","36","Ape decopʉ Ñu mehna ʉsã pʉana tiquiro buhena ʉsã ducugʉ̃, Jesu ʉsã cahapʉ yʉhdʉ cãno nidi. Tiquiro sa yʉhdʉ cãgʉ̃ Ñu tiquirore ihñano, pari turi ohõ saha nidi ʉsãre: —‍Ihñaña. Ahriquiro Cohãcjʉ̃ yaquiro cordero yero saha ijiriquiro ijire, nidi Ñu. ");
INSERT INTO pirNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Tiquiro sa nigʉ̃ ʉsã pʉana tiquiro buhena pehe tire tʉhona Jesure nʉnʉ tãʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ʉsã sa nʉnʉ tãgʉ̃ ihñano Jesu ʉsãre majare ihña, sinituri: —‍¿Yabere macana niajari mʉsa? nidi tiquiro. Tiquiro sa nigʉ̃ ʉsã gʉ̃hʉ sinituu tiquirore: —‍¿Buhegʉ, nohopʉ ijiajari mʉhʉ? nii ʉsã tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","—‍Yʉhʉ mehna ahtatjiãna ihñana taya, nidi Jesu ʉsãre. Tiquiro sa nigʉ̃ ʉsã pehe tiquiro ijiropʉ ihñana wahaʉ. Ti pjere ñamicahapʉ cuatro hora ijiri. Sa yena ti decore tiquiro mehna tojoaʉ ʉsã. ");
INSERT INTO pirNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ʉsã pʉana Ñure tʉhorina, Jesure nʉnʉ tãrina yʉhʉ piti Andre mehna ijii. Andre pehe Simo bahʉro ijiri. ");
INSERT INTO pirNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Sa yero duita tiquiro wahminore Simore maca, boca, tiquirore ohõ saha ni yahuahye: —‍Mesiare Cohãcjʉ̃ marine yʉhdʉo dutiro tiquiro ohoriquirore ʉsã bocaʉ, niahye Andre Simore. Mesia ʉsã ye mehna nina, Cristo nina niaja. ");
INSERT INTO pirNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Sa ni tuhasa tiquiro Simore Jesu cahapʉ neari. Tiquiro cahapʉ esagʉ̃ ihñano Jesu pehe Simore ohõ saha nidi: —‍Mʉhʉ Simo wame tigʉ, Ñu macʉ ijire. Yojopʉre mʉhʉre Cefa wame yeitja, nidi Jesu Simore. Cefa ʉsã ye mehna nina, Pedro nina niaja. ");
INSERT INTO pirNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ape decopʉ Jesu Galilea yehpapʉ waha duari. Sa yero tiquiro wahato pano Felipere piti ca ohõ saha nidi: —‍Yʉhʉ mehna cjʉ̃ ijiacjʉ ahtaya, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipe pehe Betsaida cjʉ̃no ijiri. Tiquiro Andre, Pedro mehna ihcã maca cjẽna ijiri tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Sa yero Felipe Natanaene maca, tiquirore bocaro ohõ saha ni yahuri: —‍Cohãcjʉ̃ dutiyere Moise tiquiro ojoari pũpʉ tiquiro yahuriquirore apequina Cohãcjʉ̃ yere yahu mʉhtariquina gʉ̃hʉ tiquina yahuriquirore ʉsã bocaʉ. Jesu Nazare cjʉ̃no, José macʉnota ijire, nidi tiquiro Natanaene. ");
INSERT INTO pirNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","—‍Nazarepʉre ne ihcãquiro quehnoariquiro mariedare, nidi Natanae. —‍Ihñagʉ taya mʉhʉ, nidi Felipe. ");
INSERT INTO pirNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Sa ye Jesu cahapʉ tiquiro esagʉ̃ ihñano Jesu pehe ohõ saha nidi Natanaene: —‍Ahriquiro yojopʉ ahtariquiro potota quehnoariquiro judio masʉno warota ijire. Tiquirore mehoñe ne mariedare, nidi Jesu Natanae pehere. ");
INSERT INTO pirNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Tiquiro sa nigʉ̃ tʉhoro Natanae pehe tiquirore sinituri: —‍¿Dʉhsegʉ yʉhʉre quehnoano masiajari mʉhʉ? nidi. —‍Felipe mʉhʉre tiquiro pijiato pano, higueragʉ docapʉ mʉhʉ ijigʉ̃ ihñaʉ yʉhʉ mʉhʉre, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Tiquiro sa nigʉ̃ Natanae pehe ohõ saha nidi tja: —‍Buhegʉ, potota mʉhʉ Cohãcjʉ̃ macʉ ijire. Mʉhʉ Israe masa ʉsã pʉhto ijiacjʉ ijire, nidi Natanae. ");
INSERT INTO pirNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Tiquiro sa nigʉ̃ tʉhoro ohõ saha ni yʉhtiri Jesu: —‍Higueragʉ docapʉ yʉhʉ mʉhʉre ihñarire masigʉ yʉhʉre “Cohãcjʉ̃ macʉ ijire”, ni wacũ tutuare mʉhʉ. ¿Tita mʉhʉre sa masigʉ̃ yeajari? Ahri mʉhʉre yʉhʉ ihñari yʉhdʉoro Cohãcjʉ̃ tutuaye mehna ye ihñogʉtja yʉhʉ mʉhʉre. Yʉhʉ sa ye ihñogʉ̃ ihñagʉta mʉhʉ, nidi Jesu Natanaene. ");
INSERT INTO pirNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Sa ninota ohõ saha ni yahu nemori: —‍Potota mʉhʉre niita niaja. Yʉhʉ masʉ Cohãcjʉ̃ ohorigʉta ijiaja. Ʉhmʉsepʉ parĩ maagʉ̃ Cohãcjʉ̃ tiquiro yequina angele yʉhʉ bui tiquina dijia tagʉ̃, tiquina mʉjagʉ̃ gʉ̃hʉre ihñagʉta mʉhʉ, nidi Jesu tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ihtia deco bato Canápʉ Galilea yehpapʉ ijiri macapʉ omoca dʉhteri bose deco ijiri. Sa yero Jesu pacoro ti wʉhʉpʉ ijiri. ");
INSERT INTO pirNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesu mehna ʉsãre tiquiro buhena gʉ̃hʉre omoca dʉhteropʉ pijiori tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ti bose deco cjẽ vino pihtigʉ̃ Jesu pacoro tiquirore yahuri: —‍Yojopʉre vino pihtia wahari, nidi ticoro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ticoro sa nigʉ̃ tʉhoro Jesu ohõ saha nidi: —‍¿Iño, dʉhsego tago tire yʉhʉre yahuajari mʉhʉ? Masa yʉhʉre tiquina masiato dʉhsarĩne, nidi Jesu tiquiro pacorore. ");
INSERT INTO pirNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Tiquiro sa nidi bato tiquiro pacoro pehe tiquina cahacjẽnare dutiri: —‍Yʉhʉ macʉ tiquiro dutiro sahata yeya, nidi ticoro. ");
INSERT INTO pirNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ti pjepʉre ʉsã acaye judio masa Cohãcjʉ̃ yere yeye tehe masare tiquina pagʉrire sa coseducu dutie tiri. Sa ye ti wʉhʉpʉre seis suturi ʉtã mehna tiquina yeri suturi aco pose tiye suturi ijiri. Ti suturi Cohãcjʉ̃ yere yeye tehe tiquina coseye aco pose tiye suturi ijiri. Ti suturi cincuenta o setenta litro pose esa tuhari. ");
INSERT INTO pirNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Sa yero tiquina cahacjẽnare dutiri Jesu: —‍Ahri suturire acore pio sã nemoña. Quehnoano wahpo dapoya, nidi Jesu. Tiquiro sa nigʉ̃ tiquina pehe quehnoano wahpo dapo peho cãhri ti suturire. ");
INSERT INTO pirNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Tiquina sa yeri bato Jesu tiquinare dutiri tja: —‍Yojopʉre ti acore wa ne, wʉhʉ cjʉ̃nore ohoya, nidi. Tiquiro sa nigʉ̃ tʉhoye ti acore wa ne, wʉhʉ cjʉ̃nore ohori. ");
INSERT INTO pirNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Tiquina sa ohogʉ̃ tiquiro pehe ti acore vino wahagʉ̃ yeri acore sihni tuhuri. Ti acore tiquiro dʉhse yerire masiedari tiquiro. Tiquiro sa masiedapegʉ̃ta tiquiro cahacjẽna ti acore wayequina pehe masidi. Wʉhʉ cjʉ̃no sa masiedaro omoca dʉhteriquirore pijio, ohõ saha ni yahuri: ");
INSERT INTO pirNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","—‍Apequina masa quehnoañe vinore sihõ mʉhtare. Masa tiquina quehnoano sihnidi batopʉ ña cjũñe core sihõri tiquina. Mʉhʉ pehe quehnoañe core ihbo, came cjũno ti core sihõri ʉsãre, nidi wʉhʉ cjʉ̃no omoca dʉhteriquirore. ");
INSERT INTO pirNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Canápʉ Galileapʉ ijiri macapʉ Jesu acore vino tiquiro wahagʉ̃ yero, topʉ Cohãcjʉ̃ tutuaye mehna coã ye dʉcari. Sa yero apequinare tiquiro tutuayere ihñori Jesu. Tiquiro sa ihñori bato ʉsã tiquiro buhena tiquirore wacũ tutuaʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Came Jesu tiquiro pacorore, tiquiro bahanare, ʉsãre tiquiro buhena gʉ̃hʉre Capernaupʉ siho esari. Topʉ esana, meheñe decorigã tojoarĩi ʉsã. ");
INSERT INTO pirNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Pascua ijigʉ̃ judio masa ʉsã bose deco ijiato mehenogã dʉhsatjiãri. Sa yero Jesu Jerusalẽpʉ esari. ");
INSERT INTO pirNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Topʉ esaro tiquiro Cohãcjʉ̃ wʉhʉpʉ sajã saro, wecʉare, ovejare, bujuaare duayequinare boca sari. Sa yero niñerure camesayequina mesaripʉ dujigʉ̃ tiquina gʉ̃hʉre boca sari. ");
INSERT INTO pirNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Sa boca saro yuta dari mehna tanari da ye, tiquinare ijipihtiyequinare sopecahapʉ tana nʉnʉ wiori. Oveja, wecʉa gʉ̃hʉ tana nʉnʉ wio cãri tiquiro. Sa yero niñeru camesayequina ye mesarire ne majaredoqueo, doque cũ cãri. Ti niñeru cjoeri gʉ̃hʉre doque site cãri. ");
INSERT INTO pirNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Sa ye tuhasa bujuaare duayequinare ohõ saha nidi: —‍Mʉsa bujuaare ne wijiaya. Yʉhʉ Pacʉ ya wʉhʉre apee boro duari wʉhʉ yeracãhña, nidi Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Tiquiro sa yegʉ̃ ihñana ʉsã tiquiro buhena pehe Cohãcjʉ̃ yere tiquina ojoari pũpʉ tiquiro nidire wacũu: “ ‘Cohãcjʉ̃, mʉhʉ ya wʉhʉre tutuaro cahĩaja. Sa cahĩgʉ ti wʉhʉre ñano tiquina yegʉ̃ ihñagʉ tutuaro bʉjʉa witiaja yʉhʉ’, ni ojoahye Cohãcjʉ̃ yere tiquina ojoari pũpʉ”, ni wacũu ʉsã Jesu buhena. ");
INSERT INTO pirNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Jesu tiquiro sa yeri bato ʉsã acaye judio masa pʉhtoa tiquirore sinituri: —‍¿Dʉhsegʉ mʉhʉ ahriquinare Cohãcjʉ̃ wʉhʉpʉre ijiyequinare cohã wioari? Cohãcjʉ̃ mʉhʉre tire ye dutiriquiro tiquiro ijigʉ̃ Cohãcjʉ̃ tutuaye mehna ye ihñoña mʉhʉ ʉsã ihñatire, nidi tiquina Jesure. ");
INSERT INTO pirNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Tiquina sa nigʉ̃ Jesu yʉhtiri: —‍Ahri wʉhʉre mʉsa cohãgʉ̃ ihtia deco wahaboro tuhasaʉtja yʉhʉ, nidi Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","—‍Ihtia deco ahri wʉhʉre yesi mʉhʉ. Cuarenta y seis cʉhmari waro tiquina yeri wʉhʉ ijire ahri wʉhʉ, nidi tiquina pehe Jesure. ");
INSERT INTO pirNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Tiquiro sa nigʉ̃ tiquina tiquirore quehnoano tʉhoerari. Jesu “Ahri wʉhʉre”, nino tiquiro pagʉre nino nidi jimedi. ");
INSERT INTO pirNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Sa ye tiquiro yariari bato, tiquiro masa wijiari bato ʉsã tiquiro buhena pehe tiquiro nidire wacũna, Cohãcjʉ̃ yere tiquina ojoari pũre Jesu tiquiro yahuri gʉ̃hʉre “Ti ijirota ijire”, ni wacũu ʉsã. ");
INSERT INTO pirNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Pascua bose deco ijigʉ̃ Jesu Jerusalẽpʉ ijiri. Topʉ tiquiro ijigʉ̃ masa peyequina Cohãcjʉ̃ tutuaye mehna tiquiro ye ihñogʉ̃ ihñañe tiquirore wacũ tutuari. ");
INSERT INTO pirNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Tiquina sa wacũ tutuepegʉ̃ta Jesu masa tiquina wacũñene quehnoano masino, “Yʉhʉre sa wacũ tutuaducueta”, ni tʉhotuerahye. ");
INSERT INTO pirNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Masa tiquina tʉhotuyere quehnoano masidi tiquiro. Sa masino masa tiquina tʉhotuyere apequinare ne sinituerari. ");
INSERT INTO pirNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ti macare Nicodemo wame tiriquiro, judio masa pʉhtoa mehna cjʉ̃no ijiri. Tiquiro fariseo masa ya curua cjʉ̃no ijiri. ");
INSERT INTO pirNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Sa yero ihcã ñami tiquiro Jesu cahapʉ ahta, tiquiro mehna yahuducuahye: —‍Buhegʉ, mʉhʉ Cohãcjʉ̃ buhe dutiro tiquiro ohorigʉ mʉhʉ ijigʉ̃ ʉsã masiaja. Cohãcjʉ̃ mʉhʉre tiquiro yedohoeragʉ̃ mʉhʉ pehe tiquiro tutuaye mehna ne ye ihñoedaboaga. Mʉhʉ peye tahari Cohãcjʉ̃ tutuaye mehna ye ihñore, niahye Nicodemo Jesure. ");
INSERT INTO pirNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Tiquiro sa nigʉ̃ Jesu pehe yahuahye: —‍Ijirota mʉhʉre niita niaja. Wahma masa bajuariquiro yero saha pari turi masa bajuariquiro dihita Cohãcjʉ̃ yaquiro iji masine, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","—‍Yohnah. ¿Bʉcʉro pehe dʉhse ye pari turi masa bajuaboari tiquiro? Tiquiro pacoro niji suhtiropʉ majare sajã, pari turi bajua masiedaboaga tiquiro, niahye Nicodemo. Tiquiro sa nigʉ̃ Jesu yʉhtiahye: ");
INSERT INTO pirNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","—‍Ijirota niita niaja mʉhʉre. Wahma masa bajuariquiro yero saha aco mehna, Espíritu Santo tiquiro tutuaye mehna pari turi masa bajuariquiro dihita Cohãcjʉ̃ yaquiro iji masine. ");
INSERT INTO pirNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Numia niji pacosãnumia ijiye, macanagãre masa bajuagʉ̃ yere. Espíritu Santo pehe masare Cohãcjʉ̃ pohne ijigʉ̃ yere. ");
INSERT INTO pirNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","“Wahma masa bajuariquiro yero saha pari turi masa bajuariquiro dihita Cohãcjʉ̃ yaquiro iji masine”, yʉhʉ nigʉ̃, tʉho wisieracãhña. ");
INSERT INTO pirNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Espíritu Santo masare Cohãcjʉ̃ pohne tiquiro yegʉ̃ ti wihnono yero saha ijire. Wihnono to ahtariropʉ ahtare. To ahtaro ca tagʉ̃ mari tʉhoaja. Sa tʉhoepenata to ahtarirore, to waharirore ne masiedaja. Sata yere Espíritu Santo masare Cohãcjʉ̃ pohne yero, niahye Jesu Nicodemore. ");
INSERT INTO pirNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","—‍Mʉhʉ niñene quehnoano masiedaga, niahye Nicodemo. ");
INSERT INTO pirNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Tiquiro sa nigʉ̃ tʉhoro ohõ saha niahye Jesu: —‍¿Mʉhʉ judio masare buhegʉ ijiepegʉta, dʉhsegʉ yʉhʉ niñene tʉhoerajari? ");
INSERT INTO pirNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ijirota niita niaja mʉhʉre. Ʉsã masidire ʉsã ihñarire ʉsã yahuaja. Ʉsã sa yahuepegʉ̃ta ne mʉsa acaye judio masa ne tʉho duerare. ");
INSERT INTO pirNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ahri yehpa cjẽ mehna masa tiquina masa bajuari mehna mʉsare queoye mehna yʉhʉ buhe mʉhtarire “Ijirota ijire”, niedare mʉsa. Sa niedana queoye mehna buhero marieno Cohãcjʉ̃ yere yʉhʉ yahugʉ̃ gʉ̃hʉre “Ijirota ijire”, nisi mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Ne ihcãquiro ʉhmʉsepʉ Cohãcjʉ̃ cahapʉ wahariquiro ne pari turi tojoa tasi. Yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ yʉhʉ dihita ʉhmʉsepʉ ijirigʉ ahri yehpapʉ ahtaʉ. Sa yegʉ yʉhʉ dihita Cohãcjʉ̃ yere mʉsare yahu masiaja. ");
INSERT INTO pirNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Panopʉre masa marienopʉ Moise mʉnano bronce wame tiri come mehna tiquina yeriquirore añare yucʉgʉ tiquina docodʉpʉ duhu yoahye. Yucʉgʉpʉ tiquina duhu yoriro sahata yʉhʉre masʉre Cohãcjʉ̃ ohorigʉre tiquirore tiquina yeriro sahata yʉhʉ gʉ̃hʉre duhu yoeta. ");
INSERT INTO pirNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Yʉhʉre tiquina sa yeri bato ijipihtiyequina yʉhʉre wacũ tutuayequina ijipihtiye decori Cohãcjʉ̃ mehna ijiducueta, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Sa ni tuhasa ohõ saha ni nemoahye: —‍Cohãcjʉ̃ ijipihtiyequina ahri yehpa cjẽnare tutuaro cahĩne. Sa yero yʉhʉre tiquiro macʉre ihcʉ̃ta ijigʉre Cohãcjʉ̃ ohori ijipihtiyequina yʉhʉre wacũ tutuayequina pecapʉ tiquina “Wahaeracãhdo”, nino. Sa ye ijipihtiye decori Cohãcjʉ̃ mehna ijieta tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Cohãcjʉ̃ yʉhʉre tiquiro macʉre masare buhiri dahre dutiro ohoerari yʉhʉre ahri yehpapʉre. Sa yero masare pecapʉ wahaboriquinare yʉhdʉoacjʉre yʉhʉre ohori. ");
INSERT INTO pirNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Yʉhʉre Cohãcjʉ̃ macʉre wacũ tutuayequinare ne buhiri dahresi Cohãcjʉ̃. Yʉhʉre wacũ tutueyequina pũritare Cohãcjʉ̃ buhiri dahre duti tuhasari. Masa yʉhʉre Cohãcjʉ̃ macʉre ihcʉ̃ta ijigʉre tiquina wacũ tutuerari buhiri, buhiri dahrerota tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Yʉhʉ, Cohãcjʉ̃ macʉ ahri yehpapʉ ahtagʉ buhrioro quehnoano marine to ihña masigʉ̃ yero sahata Cohãcjʉ̃ yere quehnoano masigʉ̃ yeaja. Yʉhʉ sa masigʉ̃ yegʉ̃ ihñañe yʉhʉre wacũ tutueyequina yʉhʉre cahmedare. Tiquina ñañe yeye pehere quehnoano cahmene. Tiquina sa cahmedi buhiri tiquinare buhiri dahrerota. ");
INSERT INTO pirNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ijipihtiyequina ñañene yeyequina tiquina ñañe yeyere duhu duerare. Sa ye buhrioro to bajumehneno sahata tiquina ñañe yerire “Bajumehneari”, niñe, yʉhʉre cahmedari tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Quehnoañene yeyequina pehe yʉhʉre, yʉhʉ buheye gʉ̃hʉre cahmene. Cohãcjʉ̃ yere tiquina yeyere yʉhʉ quehnoano bajuro dahregʉ̃ bʉe tierare tiquina. Sa ye yʉhʉre buhrioro yero saha ijigʉre cahmene, ni yahuahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Came Jesu ʉsãre tiquiro buhenare Judea yehpapʉ siho wahari. Topʉ esaro to cjẽna mehna meheñe decorigã tojoa, wame yeri tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ñu gʉ̃hʉ masare wame yero niahye Enón wame tiri macapʉ. Enón Salim wame tiri maca cahapʉ ijiri. Topʉ dia ijiri. Sa yero Ñu topʉ wame yero niahye masare. ");
INSERT INTO pirNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Tiquina peresu yeato pano Enópʉ wame yero niahye Ñu. ");
INSERT INTO pirNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ti pjere Ñu buheyequina mehna cjẽna meheñequinagã judio masʉno mehna wame yeyere yahuducuye niahye. ");
INSERT INTO pirNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Sa ye tiquina Ñu cahapʉ esa, tiquirore yahuahye: —‍Buhegʉ, Jordã si pahrẽpʉ mʉhʉ mehna ijiriquiro “Tiquirota ijiaga”, mʉhʉ nidiquiro pehe yojopʉre masare wame yero nine. Tiquiro sa yegʉ̃ ijipihtiyequina tiquiro cahapʉ dihita wahare, niahye tiquina Ñure. ");
INSERT INTO pirNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Tiquina sa nigʉ̃ tʉhoro Ñu yʉhtiahye: —‍Tiquiro tutuariquiro ijigʉ̃ Cohãcjʉ̃ pehe tiquirore sa ijigʉ̃ yere. ");
INSERT INTO pirNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","“Cristo ijieraja”, yʉhʉ nigʉ̃ mʉsa tʉhori. Sa ijierapegʉta tiquiro pano ohonoho mʉhtarigʉ ijiaja yʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Cristo mehna masa tiquina wahagʉ̃ ihñagʉ tutuaro bucueaja. Ohõ saha ijire ti: Omoca dʉhtericoro ticoro manʉno mehna ijiro wahare. Omoca dʉhtegʉ̃ cohteriquiro pehe dʉhteatiquiro namo tigʉ̃ ihñano tiquiro yahuducugʉ̃ tʉhoro tutuaro bucuere. Sa yegʉ yʉhʉ omoca dʉhtegʉ̃ cohteriquiro tiquiro bucueriro saha Cristo mehna masa tiquina wahagʉ̃ ihñagʉ tutuaro bucueaja. ");
INSERT INTO pirNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Cristo pehere wacũ tutuaro cahmene masare. Yʉhʉ pehere wacũ tutueraro cahmene masare, ni yʉhtiahye Ñu. ");
INSERT INTO pirNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Sa ni tuhasaro ohõ saha ni nemoahye Ñu: —‍Ʉhmʉsepʉ ahtariquiro ijipihtiyequina yʉhdʉoro tutuariquiro ijire. Ahri yehpapʉ masarina ijina ahri yehpa cjãna ijiaja mari. Sa yena ahri yehpa cjẽne yahuducuaja mari. Ʉhmʉsepʉ ahtariquiro pehe ijipihtiyequina yʉhdʉoro tutuariquiro ijire. ");
INSERT INTO pirNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Tiquiro ihñarire, tiquiro tʉhorire tiquiro yahure. Tiquiro sa yahuepegʉ̃ta tiquiro yahuyere masa pehe ne tʉho duerare. ");
INSERT INTO pirNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ʉhmʉsepʉ ahtariquiro tiquiro yahuyere masa tʉhoye, “Cohãcjʉ̃ potota nidiquiro ijire”, niñe nine tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ahriquiro Cristore Cohãcjʉ̃ ohoriquirore Espíritu Santo ye tutuayere oho pehore Cohãcjʉ̃. Sa yero tiquiro Cohãcjʉ̃ ye yahuducuyere yahure. ");
INSERT INTO pirNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Cohãcjʉ̃ tiquiro macʉnore tutuaro cahĩne. Sa yero ijipihtiyequina pʉhtoro iji dutiri tiquiro macʉnore. Ijipihtiye upʉro iji dutire tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Cohãcjʉ̃ macʉnore wacũ tutuayequina pehe ijipihtiye decori Cohãcjʉ̃ mehna ijieta. Tiquiro macʉnore yʉhdʉdʉcayequina pehe Cohãcjʉ̃ cahapʉ wahasi. Sa ye ijipihtiye decori ʉhmʉsepʉ ijisi. Sa yero Cohãcjʉ̃ tiquinare tutuaro buhiri dahrerota, niahye Ñu. ");
INSERT INTO pirNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Jesu Ñu yʉhdʉoro peyequina buheyequinare tiquiro cʉogʉ̃, Ñu yʉhdʉoro masare tiquiro wame yegʉ̃ fariseo masa tʉhoahye. ");
INSERT INTO pirNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Tiquina sa tʉhoepegʉ̃ta Jesu pehe tiquiro basi masare wame yerari. Ʉsã tiquiro buhena pehe masare wame yei. ");
INSERT INTO pirNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Fariseo masa tiquina sa masigʉ̃ tʉhoro Jesu pehe Judea yehpapʉ ijiriquiro Galilea yehpapʉ ʉsãre siho tojoaa wahari. ");
INSERT INTO pirNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Topʉ wahana Samaria yehpare esa yʉhdʉ cãna tana nii ʉsã. ");
INSERT INTO pirNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Sa yʉhdʉ cãna Samaria yehpapʉ ijiri macapʉ Sicar wame tiri macapʉ esaʉ. Ti maca cahapʉ panopʉ cjʉ̃no Jacob mʉnano tiquiro macʉno José mʉnanore tiquiro ohori yehpa ijiri. ");
INSERT INTO pirNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Topʉ Jacob mʉnano tiquiro sihnidi cope ijiri. Sa yero Jesu pehe yoaropʉ ahtariquiro ijiro, tiquiro wahyia yʉhdʉaro ti cope dʉhtʉ cahapʉ nuju sari. Ti pje tiquiro nuju sari pje coheri pje waro ijiri. ");
INSERT INTO pirNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Ʉsã tiquiro buhena pehe macapʉ ihyayere ʉsã dúna wahari bato ihcãquirota tiquiro topʉ tojoa nuju sari. Sa yero Samaria cjõno ti copepʉ aco waro wihigʉ̃ Jesu ticorore acore siniahye: —‍Acore ohoya yʉhʉre, niahye. ");
INSERT INTO pirNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","—‍Mʉhʉ judio masʉ ijire. Yʉhʉ pehe Samaria cjõ ijiaja. ¿Dʉhsegʉ yʉhʉre acore siniajari mʉhʉ? niahye ticoro Jesure. Judio masa Samaria cjẽnare ihña tuhtiyequina ijire. Sa yero ticoro sa niahye. ");
INSERT INTO pirNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ticoro sa nidi bato Jesu ticorore yahuahye: —‍Mʉhʉre Cohãcjʉ̃ tiquiro yedoho duayere masigo, mʉhʉre acore sinigʉre masigo, mʉhʉ yʉhʉ pehere siniboaya. Mʉhʉ sa sinigʉ̃ apeye aco pehere ohoboaya yʉhʉ. Ti aco pehe catigʉ̃ yere, niahye Jesu ticorore. ");
INSERT INTO pirNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Tiquiro sa nigʉ̃ tʉhoro ticoro yʉhtiahye tiquirore: —‍Ne mʉhʉre sutu mariedare. Sa yero ahri cope ʉhcʉãrĩne. ¿Sa yegʉ ahri catigʉ̃ yeye acore nohopʉ wa neboagari mʉhʉ? ");
INSERT INTO pirNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Mari ñecʉ mʉnano Jacob panopʉ cjʉ̃no ahri copere marine cũe tiahye. Tiquiro, tiquiro pohne, nuñequina gʉ̃hʉ ahri acore sihnie tiahye. ¿“Apeye acore ohoboaya yʉhʉ”, mʉhʉ nigʉ, Jacob yʉhdʉoro tutuagʉ ijiajari mʉhʉ, sa ni tʉhotugʉ? niahye ticoro. ");
INSERT INTO pirNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ticoro sa nigʉ̃ Jesu yʉhtiahye: —‍Ijipihtiyequina ahri acore sihniñequina, pari turi aco wʉoeta. ");
INSERT INTO pirNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Yee aco pehere sihniñequina ne pari turi aco wʉosi. Sa ye, yee acore sihniñequina Cohãcjʉ̃ mehna sa ijiducueta. Ma pohtepʉ aco to sa wijiaducuro sahata yee aco ne pihtisi, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Tiquiro sa nigʉ̃ tʉhoro numino pehe ohõ saha niahye: —‍Ti acore ohoya yʉhʉre pari turi yʉhʉ aco wʉoeraro quehnoano. Sa yego pari turi ne ohõpʉre aco wasi yʉhʉ, niahye ticoro. ");
INSERT INTO pirNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ticoro sa nigʉ̃ Jesu ticorore yahuahye: —‍Ti pje pũrita mʉhʉ manʉnore pijigo wahaya. Piji tuhasa ohõpʉ ahtaya tiquiro mehna, niahye Jesu ticorore. ");
INSERT INTO pirNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","18","—‍Manʉ mariego ijiaja yʉhʉ, niahye ticoro. —‍Ijirota nimene mʉhʉ. Ihcã omope tahari manʉ ti tuhasamedi mʉhʉ. Sa yero yojopʉre mʉhʉ mehna ijiriquiro mʉhʉ manʉno ijierare. Sa ye “Manʉ mariego ijiaja”, nigo potota nimene mʉhʉ, niahye Jesu ticorore. ");
INSERT INTO pirNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Tiquiro sa nigʉ̃ tʉhoro ohõ saha niahye ticoro: —‍Ãa, Cohãcjʉ̃ yere yahu mʉhtagʉ ijire mʉhʉ, yʉhʉ tʉhotugʉ̃. ");
INSERT INTO pirNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ʉsã ñecʉsʉmʉa iji turiayequina mʉna ahdʉ cʉnʉpʉ Cohãcjʉ̃re ño peoe tiahye. Sa yena mʉsa pehe judio masa “Jerusalẽpʉ Cohãcjʉ̃re ño peoro cahmene masare”, nie tiri mʉsa judio masa, niahye ticoro. Ticoro sa nigʉ̃ Jesu yʉhtiahye: ");
INSERT INTO pirNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","—‍Numio, yʉhʉ pehere tʉhorĩña. Camepʉ ahdʉ cʉnʉpʉ, Jerusalẽpʉ gʉ̃hʉre mari Pacʉre ño peosi mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mʉsa pehe mʉsa ño peoriquirore masiedare. Masare yʉhdʉoatiquiro judio masʉnota ijire. Sa yena ʉsã judio masa pehe ʉsã ño peoriquirore masiaja. ");
INSERT INTO pirNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Yojopʉre, camepʉ gʉ̃hʉre Cohãcjʉ̃re potota ño peoyequina tiquina quehnoano tʉhotuye mehna tiquirore ño peoeta. Sa mari ño peogʉ̃ cahmene Cohãcjʉ̃. ");
INSERT INTO pirNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Cohãcjʉ̃re, pagʉ marieniquiro tiquiro ijigʉ̃ masa tiquirore ihñedare. Sa ye tiquirore ño peoye, tiquina quehnoano tʉhotuye mehna tiquirore quehnoano potota ño peoro cahmene masare, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Tiquiro sa nigʉ̃ta ticoro yʉhtiahye: —‍Mesia, “Cristo” tiquina nidiquiro pehe masare yʉhdʉoatiquiro tiquiro ahtatire masiaja yʉhʉ. Tiquiro ahtaro marine ijipihtiyere buhe peho cãnota, niahye ticoro. ");
INSERT INTO pirNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","—‍Yʉhʉta ijiaja Cristo, niahye Jesu ticorore. ");
INSERT INTO pirNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Tiquiro sa nigʉ̃ waro wihii ʉsã. Sa yena ʉsã tiquiro buhena pehe Jesu numino mehna tiquiro yahuducugʉ̃ ihñana, ihña maria wahaʉ. Sa ihña mariepenata, “¿Dʉhse cahmeajari mʉhʉ? ¿Dʉhse niari mʉhʉ ticorore?” ni sinituerʉ tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Sa yero numino ticoro ya suture duhu dapo cã, macapʉ wahaa wahari. Topʉ esaro masare yahuro, ohõ saha niahye: ");
INSERT INTO pirNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—‍Yʉhʉ yerire yahu pehoriquirore ihñana ahtaya mʉsa. Tiquiro potota Cristo ijiboaga, ape taha yero, niahye ticoro. ");
INSERT INTO pirNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ticoro sa nigʉ̃ tʉhoye ti maca cjẽna pehe Jesure ihñañe ahtari. ");
INSERT INTO pirNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ti pjere ʉsã Jesu buhena pehe tiquirore tutuaro ihya dutimi: —‍Buhegʉ, ihyaya, nimi ʉsã. ");
INSERT INTO pirNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","—‍Sijoro ijiye ihyayere cʉoaja yʉhʉ. Tire mʉsa masiedare, nidi tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Tiquiro sa nigʉ̃ tʉhona ʉsã basi ohõ saha ni yahuducuu: —‍¿Apequina tiquirore ihyaye oho tuhasayari? nii ʉsã basi. Ʉsã sa nigʉ̃ Jesu yahuri: ");
INSERT INTO pirNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","—‍Masa pehe ihya coare. Yʉhʉre ohoriquiro tiquiro cahmeñe pehere ye coaja yʉhʉ pehe. ");
INSERT INTO pirNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“Pititia asʉ̃ dʉhsare mari dʉca duha neato”, wese upʉro tiquiro nidiro saha mʉsa pehe ni tʉhotueracãhña. “Cohãcjʉ̃ yere ʉsã yahuato dʉhsarĩne”, ni tʉhotueracãhña. Ijirota niita niaja mʉsare. Yojopʉ pũritare masare ihñaña. Dʉcare neni pje to ijiro sahata, yojopʉ pũrita masa yʉhʉ buheyere tiquina tʉhoati pje ijiro nine. ");
INSERT INTO pirNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Oteye dʉcare neñequinare tiquina wapa yeriro sahata yeere buheriquinare, yeequina ijiatiquinare pijiyequinare, tiquina sa yeri wapa tiquinare quehnoano yeitja yʉhʉ. Tiquina sa buhegʉ̃ tʉhoye yʉhʉ buheyere tʉhoyequina yeequina pehe Cohãcjʉ̃ mehna ijipihtiye decori ijiducueta. Sa ye tiquinare buhe mʉhtañequina, came yeequina wahagʉ̃ yeyequina gʉ̃hʉ ihcãno saha bucueducueta. ");
INSERT INTO pirNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","“Ihcãquiro ote mʉhtariquiro ijire. Apequiro pehe dʉcare neniquiro ijire”, nie tiahye panopʉ. Ti ijirota ijire. Tiquina sa nidiro sahata ihquẽquina yeere yahu mʉhtañequina ijire. Apequina pehe yeere buheye, yeequina wahagʉ̃ yere. ");
INSERT INTO pirNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Wese upʉro yequina dahra cohteyequina oterariquina tiquina ijiepegʉ̃ tiquiro oteye dʉcare tiquinare ne dutiro ohore. Sa masare buhe mʉhtaedarina mʉsa ijiepegʉ̃ta yeequina wahatiquinare buhe dutigʉ ohoaja mʉsare. Apequina pehe tiquinare buhe mʉhta tuhasari. Tiquina buheriquinapʉre pari turi buhe nemona, yeequina wahagʉ̃ yenata mʉsa pehe. Sa ye buhe mʉhtañequina pehe tiquina yedohoro mehna apequinare yeequina wahagʉ̃ yenata mʉsa, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ti pjere Samaria cjõno “Yʉhʉ yerire tiquiro yahu pehori”, ticoro sa nigʉ̃ tʉhoye Samaria cjẽna peyequina Jesure cahmeahye. ");
INSERT INTO pirNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Sa ye Samaria cjẽna Jesu cahapʉ esaye, “Ʉsã mehna tojoarĩña”, nidi tiquirore. Tiquina sa nigʉ̃ ʉsã gʉ̃hʉ tiquiro mehna pʉa deco tojoarĩi. ");
INSERT INTO pirNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Apequina gʉ̃hʉ peyequina Jesure tʉhoye, cahmedi tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ohõ saha nidi masa numinore: —‍Coã waropʉre mʉhʉ yahurire tʉhona, Jesure cahmei. Yojopʉ pũritare tiquiro yahuducuyere tʉhona tiquirore cahmeaja. Sa yena tiquiro pehere tʉhona ahri yehpa cjẽnare pecapʉ wahaboriquinare yʉhdʉoriquiro potota tiquiro ijigʉ̃ yojopʉ ʉsã masiaja, nidi masa Samaria cjõnore. ");
INSERT INTO pirNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Pʉa deco bato Jesu ʉsãre Galilea yehpapʉ siho wahari. ");
INSERT INTO pirNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Coã waropʉre ohõ saha nie tiri tiquiro: “Cohãcjʉ̃ yere yahu mʉhtariquirore tiquiro ya yehpa cjẽna tiquirore ño peoerare. Sa ye yʉhʉre ño peoerare ohõ cjẽna ohõpʉ yʉhʉ bʉcʉarigʉ ijigʉ̃”, nie tiri Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Sa ye Galileapʉ tiquiro esagʉ̃ to cjẽna tiquirore quehnoano piti cari. To pano Jerusalẽpʉ bose deco Jesu tiquiro yerire ihñariquina ijiri tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Sa ye Canápʉ Galileapʉ ijiri macapʉ acore tiquiro ʉhse co bajumehnedi macapʉ wahaʉ ʉsã tiquiro mehna. Caná cahapʉ ijiri macapʉ Capernau wame tiri macapʉ pʉhtoro macʉno dohatiro niahye. ");
INSERT INTO pirNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Sa yero Jesu Judeapʉ ijiriquiro tiquiro Galileapʉ esagʉ̃ pʉhtoro tʉhoahye. Tire tʉhoro Jesu cahapʉ wihiri: —‍Yʉhʉ macʉ yariaro nidi. Sa ye tiquirore yʉhdʉogʉ ahtaya, ni tutuaro mehna pijiri tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Tiquiro sa nigʉ̃ tʉhoro Jesu yʉhtiri: —‍Cohãcjʉ̃ tutuaye mehna yʉhʉ yegʉ̃ ihñedana, ne yʉhʉre wacũ tutuerare mʉsa, nidi Jesu tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Tiquiro sa nigʉ̃ pʉhtoro pehe ohõ saha nidi: —‍Pʉhto, yʉhʉ macʉ tiquiro yariato pano ahtaya, nidi tiquiro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","—‍Tojoahya. Mʉhʉ macʉ catiaga, nidi Jesu. Tiquiro sa nigʉ̃ tʉhoro, “Tiquiro nidiro sahata catirota yʉhʉ macʉ”, nino, pʉhtoro tojoaa wahari. ");
INSERT INTO pirNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Sa tojoaducuriquirore tiquiro cahacjẽna tiquirore piti ca, yahuahye: —‍Mʉhʉ macʉ catiri, ni yahuahye tiquina tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","—‍¿Noho asʉ̃ ijigʉ̃ yʉhdʉari yʉhʉ macʉ? ni sinituahye tiquiro cahacjẽnare. —‍Canʉre coheri pje batogã ujuaye sururi tiquirore, niahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Tiquina sa nigʉ̃ tʉhoro ohõ saha ni tʉhotuahye tiquiro: “Jesu yʉhʉre tiquiro sa ni yahuri pjeta ujuaye suruaya”, ni tʉhotuahye pʉhtoro pehe. “Poto ninota niaya yʉhʉre”, nino, tiquiro ijipihtiyequina tiquiro acaye mehna Jesure wacũ tutuahye. ");
INSERT INTO pirNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jesu Judea yehpapʉ ijiriquiro Galilea yehpapʉ tiquiro esari bato pʉhtoro macʉnore tiquiro yʉhdʉorire mari queogʉ̃ pʉa taha Cohãcjʉ̃ tutuaye mehna ye ihño tuhasari Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Came judio masa Cohãcjʉ̃re ʉsã ño peori bose deco ijigʉ̃ Jesu Jerusalẽpʉ esari tja. ");
INSERT INTO pirNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Topʉ oveja wame tiri sopecaha cahapʉ cuhsari cope ijiri. Ʉsã judio masa ye mehna niñe Betzata wame tiri cope ijiri. Ti cope cahapʉ ihcã omope tihamehneñe tucũri ijiri. ");
INSERT INTO pirNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ti tucũripʉ peyequina dohatiyequina cuñari. Caperi bajueyequina, pari yuri wahayequina, tini masieñequina tiquina ti cope cahapʉ ijiri. Topʉ ijiye aco ñuhmi maanore cohteye nidi. ");
INSERT INTO pirNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Topʉ buharo ti cope cjẽ acore ihquẽ tahari ñuhmigʉ̃ ye mʉjahye angel. Ti cope cjẽ aco ñuhmidi bato ña mio mʉhtariquiro pehe dʉhse ijiyere dohatiyere cʉoriquiro quehnoa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Sa yero tore treinta y ocho cʉhmari waro dohatiriquiro ijiri. ");
INSERT INTO pirNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Topʉ tiquiro cuñagʉ̃ ihñano tiquiro sa yoari pje dohatiriquiro ijigʉ̃ masidi Jesu tiquirore. Sa masino tiquirore sinituri: —‍¿Pagʉ dohatiye mariegʉ iji duajari mʉhʉ? nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Tiquiro sa nigʉ̃ta dohatiriquiro yʉhtiri: —‍Ti aco ñuhmigʉ̃ yʉhʉre aco ijiri copepʉ neaboriquiro mariedare. Ti copepʉ yʉhʉ ña mio duepegʉ̃ta apequina pehe yʉhʉ pano sa ña mio mʉhtaducure, nidi tiquiro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","—‍Wahcãdʉcaya. Mʉhʉ cuñari cahserore ne cãhña, nidi Jesu tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Tiquiro sa nigʉ̃ta dohatiriquiro pehe tiquiro cuñari cahserore ne, tini dʉcari. Ti deco saurú judio masa ʉsã sori deco ijiri. ");
INSERT INTO pirNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ti decore Jesu sa yegʉ̃ ihñañe judio masa ʉsã pʉhtoa pehe dohatimediquirore ohõ saha ni yahuahye: —‍Miare saurú deco mari sori deco ijiepegʉ̃ta mʉhʉ cuñari cahserore neare mʉhʉ. Sa yegʉ mari dutiyere yʉhdʉdʉcagʉ nine mʉhʉ, niahye tiquina tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","—‍Yʉhʉre yʉhʉ dohatiyere cohãriquiro pehe ohõ saha nidi yʉhʉre: “Mʉhʉ cuñari cahserore ne cãhña”, nidi tiquiro yʉhʉre, ni yʉhtiahye dohatimediquiro. ");
INSERT INTO pirNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","—‍¿Tire mʉhʉre sa nidiquiro pehe noa boro ijiari tiquiro? ni sinituahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Topʉ masa peyequina tiquina ijigʉ̃ ihñano Jesu pehe waha tuhasari. Sa yero dohatimediquiro pehe tiquirore yʉhdʉoriquiro wamene masiedahye. ");
INSERT INTO pirNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Came Cohãcjʉ̃ wʉhʉpʉ Jesu tiquirore piti ca yahuri: —‍Tʉhorĩña mʉhʉ yʉhʉre. Yojopʉre quehnoano pagʉ tire mʉhʉ. Ñañene ye nemoedacãhña. Pari turi ñañene ye nemogʉ mʉhʉ dohatiriro yʉhdʉoro wahagʉta mʉhʉ, nidi Jesu tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Tiquiro sa nidi bato dohatimediquiro pehe ʉsã judio masa pʉhtoa tiquirore sinituriquina cahapʉ esaro yahuahye tiquinare: —‍Jesu wame tiriquiro yʉhʉre yʉhdʉgʉ̃ yeri, ni yahuahye tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Sa ye saurú ijigʉ̃ dohatiriquirore tiquiro dohatiyere Jesu cohãgʉ̃ masiñe, judio masa ʉsã pʉhtoa pehe tiquirore ñano ye dʉcari. ");
INSERT INTO pirNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Sa ñano tiquirore tiquina ye duagʉ̃ masino Jesu pehe yahuri tiquinare: —‍Yʉhʉ Pacʉ yojopʉre dahrarĩno nine. Yʉhʉ gʉ̃hʉ dahrarĩi niaja, ni yahuri tiquirore ñano ye duayequinare. ");
INSERT INTO pirNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Tiquiro sa nigʉ̃ judio masa ʉsã pʉhtoa pehe tiquiro mehna tutuaro usuaye, to pano tiquina nidiro yʉhdʉoro tiquirore wejẽ duari. Saurú decore tiquina sori decore ihcãquiro dohatiriquirore tiquiro yʉhdʉogʉ̃ ihñañe tiquina usuari. Sa usuaye tiquiro Cohãcjʉ̃re “Yʉhʉ Pacʉ”, nigʉ̃ tʉhoye, tiquina pehe to pano tiquina nidiro yʉhdʉoro usua nemoahye tja. “ ‘Yʉhʉ Pacʉ’, nino Jesu tiquiro basi ‘Cohãcjʉ̃ mehna ihcãno saha ijiaja’, ni wacũaga tiquiro”, ni tʉhoturi judio masa ʉsã pʉhtoa. ");
INSERT INTO pirNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Sa ye Jesu tiquinare yahuari: —‍Ijirota niita niaja mʉsare. Yʉhʉ Cohãcjʉ̃ macʉ, yʉhʉ esa tuharo yeraja. Yʉhʉ Pacʉ tiquiro yerire ihñagʉ̃, tire yeaja. ");
INSERT INTO pirNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Yʉhʉ Pacʉ yʉhʉre tiquiro macʉre cahĩne. Sa yero tiquiro yerire yʉhʉre ihño pehore. Ahri yojopʉ tiquiro tutuaye mehna yʉhʉ yeri yʉhdʉoro tiquiro apeyere ye dutirota yʉhʉre. Tiquiro sa ye dutigʉ̃ tiquiro tutuaye mehna ye ihñoutja yʉhʉ. Sa yena ihña maria wahanata mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Yʉhʉ Pacʉ yariariquinare tiquiro masoriro sahata yʉhʉ gʉ̃hʉ yʉhʉ cahmeñequinare masoutja. ");
INSERT INTO pirNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","Ne yʉhʉ Pacʉ pehe masa tiquina ñañe buhirire buhiri dahreriquiro ijierare. Yʉhʉ pehere tire tiquina ñañe buhirire buhiri dahreacjʉre cũri yʉhʉ Pacʉ. Ijipihtiyequina masa tiquirore tiquina ño peoriro sahata yʉhʉ gʉ̃hʉre tiquina ño peoatire buhiri dahreacjʉre cũri yʉhʉre. Yʉhʉre tiquiro macʉre ño peoerana yʉhʉ Pacʉ gʉ̃hʉre ño peoerare mʉsa. Tiquiro ijire yʉhʉre ohoriquiro, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Sa ni tuhasa ohõ saha ni yahu nemori: —‍Ijirota niita niaja mʉsare. Yʉhʉ yahuducuyere tʉhoyequina, yʉhʉre ohoriquirore wacũ tutuayequina ijipihtiye decori ʉhmʉsepʉ sa ijiducueta. Sa yegʉ tiquinare buhiri dahresi yʉhʉ. Sa ye tiquina pecapʉ wahaboriquina yʉhdʉeta. ");
INSERT INTO pirNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ijirota niita niaja mʉsare. Pecapʉ wahatiquina yʉhʉre Cohãcjʉ̃ macʉre tiquina tʉhoati pje yojopʉ ijire. Camepʉ gʉ̃hʉre yʉhʉre tiquina tʉhoeta tja. Sa tʉhoye tʉho nʉnʉñequina pehe Cohãcjʉ̃ mehna sa ijiducueta. ");
INSERT INTO pirNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Cohãcjʉ̃ yʉhʉ Pacʉ pehe sa ijiducugʉ̃ yeriquiro ijire. Sa yero yʉhʉre tiquiro macʉre sa ijiducugʉ̃ yeacjʉ iji dutiri tiquiro yʉhʉre. ");
INSERT INTO pirNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Sa yegʉ yʉhʉ masʉ Cohãcjʉ̃ tiquiro ohorigʉ yʉhʉ ijigʉ̃ tiquiro masare buhiri dahreacjʉre cũri yʉhʉre. ");
INSERT INTO pirNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ahrire tʉhona, tʉho mariedacãhña mʉsa. Ape decopʉre ijipihtiyequina yariariquina masa coperipʉ ijiyequina yʉhʉ yahuducugʉ̃ tʉhoeta. ");
INSERT INTO pirNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Sa tʉhoye, quehnoañene yeriquina ijipihtiye decori Cohãcjʉ̃ mehna ijiatiquina masa mʉjaeta. Ñañene yeriquina pehe ñañene tiquina yeri buhiri pecapʉ wahaeta, ni yahuri Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Sa ni tuhasa ohõ saha ni yahu nemori: —‍Yʉhʉ esa tuharo ne yeraja. Ne yʉhʉ basi yʉhʉ cahmeno ye dueraja. Yʉhʉre ohoriquiro tiquiro dutiriro sahata ye duaja. Sa yegʉ tiquiro nidiro sahata buhiri dahreaja. Sa yegʉ yʉhʉ masare buhiri dahregʉ queoro yeaja. ");
INSERT INTO pirNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Yʉhʉ tutuagʉ ijiaja”, yʉhʉ ni yahugʉ̃ “Mʉhʉ yahuye ne poto ijierare”, ni masiboaga mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Apequiro ijire yʉhʉre yahuriquiro. Tiquiro Ñu pehe masare yahure yʉhʉre. Masare yʉhʉre tiquiro yahuri ijirota ijire. Tire yʉhʉ quehnoano masiaja. ");
INSERT INTO pirNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Mʉsa apequina pehere Ñupʉre yʉhʉre sinitu dutina ohori. Sa yero potota yahure tiquiro mʉsare. ");
INSERT INTO pirNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","“Cohãcjʉ̃ macʉno ijire ahriquiro”, yʉhʉre ni yahuatiquinare macaedaja. Sa macaedapegʉta Ñu masʉno tiquiro ijiepegʉ̃ta yʉhʉre “Cohãcjʉ̃ macʉno ijire”, tiquiro ni yahurire yahugʉ niaja. Mʉsa yʉhʉre wacũ tutuatire, mʉsa pecapʉ wahaborina mʉsa yʉhdʉatire yʉhʉre Ñu tiquiro yahurire yahugʉ niaja. ");
INSERT INTO pirNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Sihãria meheñe decorigã ihña masigʉ̃ yero sahata Ñu mʉsare buhe mʉhtano mehenogã tiquiro catiro puno mʉsare masigʉ̃ yeri. Tiquiro sa buhegʉ̃ tʉhona meheñe decorigã bucueri mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Yʉhʉ ijiye tiyere tiquiro sa buhepegʉ̃ta Cohãcjʉ̃ pehe yʉhʉ ijiyere quehnoano yahure. Tiquiro sa yahugʉ̃ Ñu yʉhʉ ijiyere tiquiro yahuye yʉhdʉoro ijire Cohãcjʉ̃ ye yahuye. Sa yegʉ Cohãcjʉ̃ tiquiro tutuaye mehna yʉhʉre tiquiro ye dutirire yojopʉ yei niaja. Ahrire yʉhʉ yegʉ̃ ihñana potota Cohãcjʉ̃ ohorigʉ yʉhʉ ijiyere masine mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Sa yero yʉhʉ Pacʉ yʉhʉre ohoriquiro tiquiro basi “Tiquiro yʉhʉ ohoriquiro ijire”, ni yahure mʉsare. Tiquiro sa ni yahuepegʉ̃ta tiquiro yahuducuyere ne tʉhoerari mʉsa. Sa yena mʉsa tiquirore ne masiedari. ");
INSERT INTO pirNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Yʉhʉre Cohãcjʉ̃ ohorigʉre mʉsa ne tʉho duerari. Sa yena mʉsa Cohãcjʉ̃ yere ne cahmedari. ");
INSERT INTO pirNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Cohãcjʉ̃ yere tiquina ojoari pũre mʉsa buhena, “Mari ahri pũre buhena ijipihtiye decori Cohãcjʉ̃ mehna sa ijiducunata”, nine mʉsa. Ti pũta yʉhʉre yahure. ");
INSERT INTO pirNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ti pũ yʉhʉre ti yahuepegʉ̃ta mʉsa pehe yʉhʉre cahmedare. Ijipihtiye decori Cohãcjʉ̃ mehna mʉsa sa ijiducuatire yʉhʉre sini duerare mʉsa, ni yahuri Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Sa ni tuhasa ohõ saha ni nemori: —‍Yʉhʉre mʉsa ño peoeragʉ̃ ihñagʉ usueraja yʉhʉ pehe. ");
INSERT INTO pirNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Mʉsa pehe Cohãcjʉ̃re mʉsa cahĩedagʉ̃ masiaja yʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Cohãcjʉ̃ yʉhʉ Pacʉ tiquiro yʉhʉre dutiriro sahata yʉhʉ ahtaepegʉ̃ta mʉsa yʉhʉre cahmedari. Apequiro pehere Cohãcjʉ̃ ohoeriquiro tiquiro ijiepegʉ̃ta tiquiro pehere cahmenata mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Apequina masa mʉsare tiquina ño peogʉ̃ cahmene mʉsa. Cohãcjʉ̃ mʉsa mehna tiquiro bucuegʉ̃ cahmedare mʉsa. Tiquiro dihita Cohãcjʉ̃ waro ijire. Sa cahmedana yʉhʉ gʉ̃hʉre tʉhoerare mʉsa. Yʉhʉre wacũ tutuerare. ");
INSERT INTO pirNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Mʉsare yʉhʉ Pacʉre ne yahusãsi yʉhʉ. Tire masiña mʉsa. Moise tiquiro ojoari pũ pehe mʉsare yahusãnota. “Ti pũ cjẽ dutiyere mari ye pehona, Cohãcjʉ̃ cahapʉ wahanata”, mʉsa nidi pũ pehe mʉsare yahusãnota. ");
INSERT INTO pirNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moise tiquiro ojoari pũpʉ yʉhʉ pehere yahuahye. Sa yena ti pũre “Ijirota ijire”, nina, yʉhʉ yahuye gʉ̃hʉre “Ijirota ijire”, niboaya mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Moise tiquiro ojoari pũre “Ijirota ijire”, niedana, yʉhʉ yahuducuye gʉ̃hʉre “Ijirota ijire”, nisi mʉsa, nidi Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Sa tiquiro buheri bato Galilea wame tiri ditara ape sie pahrẽpʉ ʉsã Jesu mehna pehãa wahaʉ. Ti ditara pajiri ditara Tiberia wame tiri. ");
INSERT INTO pirNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","To pano Galilea yehpapʉ Jesu dohatiyequinare tiquina dohatiyere tiquiro cohãgʉ̃ masa ihñae tiri. Tiquina sa ihñari bato Jesu pehãgʉ̃ ihñañe masa peyequina tiquirore nʉnʉ tã cãri. ");
INSERT INTO pirNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Topʉ esana ʉsã tiquiro buhena pehe tiquiro mehna cʉnʉpʉ mʉja sa, tʉ buipʉ dujii. ");
INSERT INTO pirNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ti deco pascua wame tiri bose deco ijiato judio masa ʉsã ya bose deco mehenogã dʉhsari. ");
INSERT INTO pirNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","6","Topʉ dujiro, Jesu peyequina masa tiquiro cahapʉ tiquina ahtagʉ̃ ihñadoqueori. Sa ihñadoqueoro Felipere sinituri: —‍¿Ahriquina masa tiquina ihyatire nohopʉ dúnatari mari? nidi Felipere. Jesu tiquiro basi tiquiro yeatire masieperota Felipere sinituri, “¿Dʉhse yʉhtirotari?” nino. ");
INSERT INTO pirNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Tiquiro sa sinitugʉ̃ tʉhoro Felipe yʉhtiri: —‍Doscientos niñeru cjoeri pose ihyayere mari dúepegʉ̃ta masare dayegã ihyayere mari itiepegʉ̃ta ne esa tuhasi, nidi Felipe Jesure. ");
INSERT INTO pirNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ʉsã mehna cjʉ̃no Andre, Simo Pedro bahʉro pehe Jesure yahuri: ");
INSERT INTO pirNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—‍Ihcã omope pã pacare, pʉaro wahire nijino ohõ cʉore. To punogãta tiquiro cʉoepegʉ̃ta masa pehe peyequina waro ijire. Sa yero ahri mehenogã ihyaye ne esa tuhasi, nidi Andre. ");
INSERT INTO pirNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","—‍Masare duji dutiya mʉsa, nidi Jesu ʉsãre tiquiro buhenare. Topʉ taa dayegã ijiro ijiri. Ʉsã duji dutigʉ̃ masa nuju sa pihtiari taa buipʉ. Ʉmʉa dihitare mari queogʉ̃ cinco mil ijiri. ");
INSERT INTO pirNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Tiquina sa nuju sagʉ̃ ihñano Jesu pehe pãre ne, Cohãcjʉ̃re “Quehnoare” nidi. Sa ni tuhasarota ʉsãre tiquiro buhenare iti dutiri. Tiquiro sa dutigʉ̃ ʉsã pehe dujiyequinare iti cãʉ. Pʉaro wahi gʉ̃hʉre iti cãʉ. Ijipihtiyequinare quehnoano tiquina esa tuharo ihyayere tiquinare itii. ");
INSERT INTO pirNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Sa ye masa pehe yapia wahari. Tiquina sa yapigʉ̃ ihñano Jesu ʉsãre nidi: —‍Tiquina ihya dʉharire quehnoano ne peho cãhña. Sa yena tiquina ihya dʉharire ne bosi, nidi. ");
INSERT INTO pirNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Tiquiro sa nigʉ̃ ʉsã pehe ihcã omope pã paca dʉhsarire ʉsã ne cahmecoagʉ̃ doce pʉhʉse waro wijiari. ");
INSERT INTO pirNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Sa ye masa ti bajumehnenore Jesu tiquiro yegʉ̃ ihñañe, ohõ saha nidi: —‍Ijirota ijire. Ahriquiro Cohãcjʉ̃ yere yahu mʉhtariquiro ahri yehpapʉ ahtariquiro mari cohteriquirota ijire, nidi tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Tiquina Jesure tiquina pʉhtoro ijiatiquiro ñehe sõ duamedi. Jesu tire masino pari turi ihcãquirota cʉnʉpʉ wahaa wahari. ");
INSERT INTO pirNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ñamicahapʉ ʉsã tiquiro buhena ditarapʉ buhaʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Topʉre buha sa, yucʉsapʉ sajã, Capernau wame tiri macapʉ pehãʉ. Ʉsã pehãri pje ñamipʉ ijiri. Sa yero Jesu ʉsã cahapʉ ahtaeranidi. ");
INSERT INTO pirNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Wihnono tutuaro wẽgʉ̃, pajiri ma pahcõri wahcãri. ");
INSERT INTO pirNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ihcã omope kilómetro esaboro waro ʉsã esagʉ̃ waro Jesu ʉsã cahapʉ wihiri. Aco bui tiquiro ahtagʉ̃ ihñaʉ ʉsã. Sa ʉsã cahapʉ tiquiro ahtagʉ̃ ihñana ʉsã cuei. ");
INSERT INTO pirNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Sa ʉsã cuegʉ̃ ihñano tiquiro ʉsãre yahuri: —‍Ne yʉhʉre ihña cueracãhña. Yʉhʉta ijiaja, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Tiquiro sa nigʉ̃ tʉhona ʉsã bucueye mehna tiquirore piti ca sajã dutii. Tiquiro sajãri batogãta ʉsã wahari yehpapʉre pehã sa tuhasaʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ti ñamine masa topʉ tojoariquina pehe ihcãriata ʉsã pehãtiare ihñahye. Tia mehna ʉsã pehãgʉ̃ ihñari tiquina. Jesu ʉsã mehna tiquiro wahaeragʉ̃ gʉ̃hʉre ihñari tiquina. Sa ye ape decore tiquirore cohteye nimahye. ");
INSERT INTO pirNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Tiberia wame tiri macapʉ ahtaye, Jesu Cohãcjʉ̃re “Quehnoare”, tiquiro nidiro cahagã cjũnopʉ, masare tiquiro ihyaye itiriro caha cjũnopʉ wahã sahye tiquina yucʉsa mehna. ");
INSERT INTO pirNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Sa ye ape deco ʉsã Jesu mehna ijirirore ʉsã mariedagʉ̃ ihñañe, masa yucʉsapʉ sajã, Capernaupʉ ʉsãre nʉnʉ tã pehã sari. Jesure maca saye nidi tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ditarapʉ pehã, Jesure boca saye, masa sinituri tiquirore: —‍¿Buhegʉ, dʉhse ijigʉ̃ ahtari mʉhʉ ohõpʉre? ni sinituri tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Tiquina sa sinitugʉ̃ Jesu tiquinare yahuri: —‍Ijirota niita niaja mʉsare. Bajumehnedire yʉhʉ yepegʉ̃ta yʉhʉ pehere wacũ tutuerare mʉsa. Yʉhʉre wacũ tutuerapenata yʉhʉre macare mʉsa. Yʉhʉ mehna bʉjʉye ihyana, mʉsa yapirina yʉhʉre maca cãhtari tja. ");
INSERT INTO pirNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ihyaye ne sa ijiducuerare. Camepʉ pihtia wahare. Sa yena tire wacũducueracãhña. Apeye ihyaye sijoro saha ijiye ihyaye pehere macaña mʉsa. Ti ihyayere bocana ijipihtiye decori Cohãcjʉ̃ mehna ijinata. Sa ye ti ihyaye pũrita ne pihtierare. Ti ihyayere yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ mʉsare ohoutja. Cohãcjʉ̃ yʉhʉ Pacʉ yʉhʉre tire oho dutiriquiro ijire. Cohãcjʉ̃ tiquiro ohorigʉ yʉhʉ ijiyere ihño tuhasari mʉsare, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Tiquiro sa nigʉ̃ tiquina sinituri tiquirore: —‍¿Cohãcjʉ̃ tiquiro ye dutiyere yena tana dʉhse yenatari ʉsã? ni sinituri tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","—‍Ahrire Cohãcjʉ̃ mʉsare ye dutire: “Yʉhʉ ohoriquirore wacũ tutuaya”, nino mʉsare ye dutire Cohãcjʉ̃, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Tiquiro sa nigʉ̃ tʉhoye tiquina ohõ saha nidi tja: —‍Cohãcjʉ̃ ohorigʉ ijigʉ tiquiro tutuaye mehna ye ihñoña ʉsãre mʉhʉre ʉsã quehnoano wacũ tutuatire. ¿Yabe borore yeitjari mʉhʉ? ");
INSERT INTO pirNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Mari ñecʉsʉmʉa mʉnapʉ panopʉ cjẽna masa marienopʉ maná wame tiye pacare ihyae tiahye. Cohãcjʉ̃ yere tiquina ojoari pũpʉ ohõ saha ni yahuahye: “Tiquiro tiquinare ʉhmʉse cjẽ ihyayere ohoe tiahye tiquina ihyatire”, ni ojoahye Cohãcjʉ̃ yere tiquina ojoari pũpʉ. ¿Tiquiro sa yeriro sahata yeitjari mʉhʉ gʉ̃hʉ? nidi tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Tiquina sa nigʉ̃ Jesu yahuri tiquinare: —‍Ijirota niaja mʉsare. Moise ʉhmʉse cjẽ ihyayere ohoerari mʉsare. Yʉhʉ Pacʉ pehe ʉhmʉse cjẽ ihyaye potota ijiyere mʉsare ohoriquiro ijire. ");
INSERT INTO pirNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Cohãcjʉ̃ ye ihyaye ʉhmʉsepʉ dijia taye, ijipihtiri yehpa cjẽnare catiyere oho masine, nidi Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","—‍Pʉhto, decoripe ti ihyayere ohoya ʉsãre, nidi tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Tiquina sa nigʉ̃ tʉhoro Jesu yahuri tiquinare: —‍Yʉhʉ pehe catiyere oho, ihyaye yero saha ijigʉ ijiaja. Mari ye ihyayere mari ihyari batota duita ʉjʉa ahbaa wahaja mari tja. Sihniñe gʉ̃hʉre mari sihnidi batota aco wʉoa wahaja tja. Sa ijiepegʉ̃ta yʉhʉre cahmediquiro, yʉhʉre wacũ tutuariquiro ʉjʉa ahbaerariquiro yero saha tiquiro bucueye tiquirore pihtisi. ");
INSERT INTO pirNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Mʉsa pehe yʉhʉre ihñaepenata yʉhʉre wacũ tutueranine. Tireta mʉsare yahue timi yʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ijipihtiyequina yeequina ijiatiquinare yʉhʉre yʉhʉ Pacʉ tiquiro cũriquina pehe yʉhʉre cahmeeta. Sa ye yʉhʉre cahmeñequinare ne cohãsi yʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ʉhmʉsepʉ ahtagʉ yʉhʉ cahmeno yei ahtagʉ niedʉ yʉhʉ. Yʉhʉre ohoriquiro tiquiro cahmediro sahata yei ahtagʉ nii yʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ahrita ijire yʉhʉre ohoriquiro tiquiro cahmeñe waro: Ijipihtiyequina yeequina yʉhʉre tiquiro ohoriquinare yʉhʉ boeragʉ̃ cahmene yʉhʉre ohoriquiro pihtiri deco ijigʉ̃ tiquina masa mʉjatire. ");
INSERT INTO pirNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ijipihtiyequina yʉhʉre Cohãcjʉ̃ macʉre ihñañequina, yʉhʉre wacũ tutuayequina ijipihtiye decori tiquiro mehna tiquina ijigʉ̃ cahmene yʉhʉ Pacʉ. Sa yegʉ pihtiri decopʉ tiquinare masoutja, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","“Yʉhʉ ʉhmʉsepʉ ahtaye ihyaye yero saha ijigʉ ijiaja”, tiquiro nigʉ̃ tʉhoye judio masa ʉsã pʉhtoa pehe tiquiro mehna usua, tiquina basi Jesure ñano ni yahuducuri. ");
INSERT INTO pirNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","—‍¿Ahriquiro Jesu José macʉno ijierajari? Tiquiro pacʉro, pacoro gʉ̃hʉre mari masiaja. Sa yero mari yero saha pagʉ tiriquirota ijire. ¿Sa ijieperota dʉhsero “Ʉhmʉsepʉ ahtaʉ”, niajari tiquiro? ni usuari tiquina. Tiquina sa nigʉ̃ tʉhoro Jesu yahuri tiquinare: ");
INSERT INTO pirNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","—‍Mʉsa yʉhʉre ñano ni yahuducueracãhña. ");
INSERT INTO pirNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Yʉhʉ Pacʉ yʉhʉre ohoriquiro pehe masare yʉhʉ pehere cahmegʉ̃ yere. Tiquiro sa yeragʉ̃ masa pehe yeequina iji masiedaboaya. Pihtiri deco ijigʉ̃ yeequinare masoutja yʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Cohãcjʉ̃ yere yahu mʉhtariquina pehe ohõ saha ni ojoahye: “Cohãcjʉ̃ tiquinare buherota”, ni ojoahye Cohãcjʉ̃ yere yahu mʉhtariquinapʉ. Ijipihtiyequina yʉhʉ Pacʉ ye buheyere tʉhoyequina, tiquirore yʉhtiyequina yʉhʉre cahmene. Sa yeye yeequina ijire. ");
INSERT INTO pirNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Yʉhʉ Pacʉre ne ihcãquiro masʉno ihñedare. Yʉhʉ Cohãcjʉ̃ ohorigʉ dihita yʉhʉ Pacʉre ihñaʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ijirota niaja mʉsare. Yʉhʉre wacũ tutuariquiro ijipihtiye decori yʉhʉ Pacʉ mehna sa ijiducurota. ");
INSERT INTO pirNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yʉhʉ catiyere oho, ihyaye yero saha ijigʉ ijiaja. ");
INSERT INTO pirNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Mʉsa ñecʉsʉmʉa mʉna iji turiayequina masa marienopʉ manáre ihyae tiahye. Sa tire ihyaepeta yariaa wahae tiahye. ");
INSERT INTO pirNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ʉhmʉsepʉ ahtari ihyayere yʉhʉ niñe ihyayere masʉno ihyaro, ne pecapʉ wahasi. ");
INSERT INTO pirNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yʉhʉ ʉhmʉsepʉ ahtari ihyaye catiyere oho, ihyaye yero saha ijigʉ ijiaja yʉhʉ. Ahri ihyayere ihyariquiro ijipihtiye decori yʉhʉ Pacʉ mehna sa ijiducurota. Ahri ihyaye catigʉ̃ yere. Ahri ihyaye yero saha ijiye yʉhʉ pagʉta ijire. Ijipihtiri yehpa cjẽna Cohãcjʉ̃ mehna tiquina sa ijiducuatire yʉhʉ pagʉre ohogʉtja. Sa ohogʉ yariagʉtja, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Tiquiro sa nigʉ̃ tʉhoye ʉsã acaye judio masa pehe tire ohõ saha ni yahuducuri tiquina basi: —‍¿Ahriquiro dʉhse ye tiquiro pagʉre ihyatire ohorotari? nidi tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Tiquina sa nigʉ̃ tʉhoro Jesu yahuri: —‍Ijirota niaja mʉsare. Yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ ijiaja. Yʉhʉ pagʉre ihyeriquiro, yʉhʉ diire sihnieniquiro ʉhmʉsepʉ wahasi. ");
INSERT INTO pirNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Sa yʉhʉ pagʉre ihyariquirore, yʉhʉ diire sihnidiquirore pihtiri deco ijigʉ̃ masoutja. Sa yero ʉhmʉsepʉ sa ijiducurota tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Yʉhʉ pagʉ potota ihyaye waro yero saha ijire. Yʉhʉ dii potota sihniñe yero saha ijire. ");
INSERT INTO pirNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Yʉhʉ pagʉre ihyariquiro yʉhʉ diire sihnidiquiro yʉhʉ mehna bucueye mehna ijiducurota. Sa yegʉ yʉhʉ gʉ̃hʉ tiquiro mehna bucueye mehna ijiducuaja. ");
INSERT INTO pirNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Yʉhʉ Pacʉ yʉhʉre ohoriquiro sa ijiducure. Sa ijiducuro, yʉhʉ gʉ̃hʉre sa ijiducugʉ̃ yere. Sa yeye yʉhʉre sa ijiducugʉre masa ihyaye, Cohãcjʉ̃ mehna ʉhmʉsepʉ sa ijiducueta tiquina gʉ̃hʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ahri tjire ʉhmʉsepʉ ahtari ihyaye. Mari ñecʉsʉmʉa mʉna iji turiayequina tiquina ihyari yero saha ijierare ahri ihyaye. Tiquina pehe ti ihyayere ihyaepeta yaria pihtia wahae tiahye. Ahri ihyaye pehere ihyariquiro ʉhmʉsepʉ sa ijiducurota, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Capernaupʉ judio masa ʉsã buheri wʉhʉpʉ Jesu buhero, sata ni yahuri. ");
INSERT INTO pirNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Peyequina Jesure cahmeñequina tiquiro sa ni buheyere tʉhoye, ohõ saha ni yahuducuri: —‍Ahri buheye tutuaro mijore. Sa yena mari tʉho duera cjũaja, ni yahuducuri tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Tiquina sa nigʉ̃ Jesu pehe tiquina yahuducurire masidi. Sa masino tiquiro sinituri tiquinare: —‍¿Ahri buheyere tʉhona usuajari mʉsa? ");
INSERT INTO pirNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ ʉhmʉsepʉ yʉhʉ tojoaa wahagʉ̃ ihñana dʉhse ni tʉhotunatari mʉsa? ¿To gʉ̃hʉre usuanatari mʉsa? ");
INSERT INTO pirNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Masʉno tiquiro jeripohnare cʉoro catire. Tiquiro pagʉ pehe tiquirore catigʉ̃ yerare. Masʉno tiquiro jeripohna tiquirore catigʉ̃ yero saha yʉhʉ buheye pehe mʉsare Cohãcjʉ̃ mehna sa ijiducugʉ̃ yere. ");
INSERT INTO pirNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Apequina mʉsa mehna cjẽna ne yʉhʉre wacũ tutuerare, nidi Jesu. Coã waropʉre Jesu tiquirore wacũ tutueyequinare masidi. Sa yero tiquirore ihña tuhtiyequinare ihñoatiquiro gʉ̃hʉre masi tuhasari. Sa tiquirore wacũ tutueyequinare masino “Apequina mʉsa mehna cjẽna yʉhʉre wacũ tutuerare”, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Sa ni tuhasa ohõ saha ni nemori: —‍Ohõ saha ni yahumi mʉsare: “Yʉhʉ Pacʉ masare yʉhʉ pehere cahmegʉ̃ yere. Tiquiro sa yeragʉ̃ masa pehe yeequina iji masiedaboaya”, mʉsare nie timi, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Tiquiro sa ni buhegʉ̃ tʉhoye peyequina Jesure cahmemediquina tiquirore cohã, tiquiro mehna pari turi wahaerari. ");
INSERT INTO pirNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Tiquina sa yegʉ̃ ihñano Jesu ʉsãre doce tiquiro buhenare sinituri: —‍¿Mʉsa gʉ̃hʉ yʉhʉre cohãnatjari? ni sinituri ʉsãre. ");
INSERT INTO pirNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Tiquiro sa nigʉ̃ Simo Pedro yʉhtiri tiquirore: —‍Pʉhto, ʉsãre apequiro buheriquiro mariedare. Mʉhʉ ye buheyere tʉhona Cohãcjʉ̃ mehna sa ijiducunatja ʉsã. Mʉhʉ ye buheye dihita tire yahure ʉsãre. ");
INSERT INTO pirNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Sa yena ʉsã mʉhʉre wacũ tutuaja. Sa yena mʉhʉ quehnoagʉ, Cohãcjʉ̃ macʉ tiquiro ohorigʉ mʉhʉ ijigʉ̃ ʉsã masiaja. Sa yena mʉhʉre cohãsi ʉsã, nidi Simo Pedro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Tiquiro sa nigʉ̃ tʉhoro Jesu yahuri ʉsãre: —‍Yʉhʉ pehe mʉsare doce besei. Sa ijiepegʉ̃ta ihcãquiro mʉsa mehna cjʉ̃no watĩno yaquiro ijiatiquiro ijire, nidi ʉsãre tiquiro buhenare. ");
INSERT INTO pirNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Sa nino Judare Simo Iscariote macʉnore nino nidi. Juda pehe doce ʉsã mehna cjʉ̃no Jesure ihña tuhtiyequinare ihñoatiquiro ijiri. ");
INSERT INTO pirNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Came Jesu Galilea yehpapʉ tinino wahari. Judea yehpapʉ judio masa tiquirore wejẽ duari. Tiquina sa wejẽ duagʉ̃ masino tiquiro ti yehpapʉ wahaerari. ");
INSERT INTO pirNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Judio masa daye wʉhʉsegã ʉsã yeati bose deco mehenogã dʉhsatjiãri. ");
INSERT INTO pirNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Sa ye Jesu bahana tiquirore yahuri: —‍Judeapʉ wahaya. Topʉ mʉhʉ yequinare mʉhʉ bajumehneñene ihñogʉ wahaya mʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Masare mʉhʉ bajumehneñene ihño duagʉ ne nʉosi mʉhʉ. Ye ihñono cahmene. Potota ahri bajumehneñene ye masigʉ ijigʉ tire masare ihñoña, nimedi tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Tiquiro bahana ijiepeta Jesure “Cohãcjʉ̃ macʉno ijire”, niedari. Sa yeye sa nidi tiquina tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Tiquina sa nidi bato Jesu yahuri tiquinare: —‍Masa yʉhʉre tiquina quehnoano masiati pje dʉhsarĩne. Mʉsa ihña duana bose deco ijigʉ̃ waha masine. ");
INSERT INTO pirNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ahri yehpa cjẽna mʉsa pehere ihña tuhtierare. Tiquina ñañe yerire yʉhʉ yahugʉ̃ tiquina yʉhʉ pehere ihña tuhtire. ");
INSERT INTO pirNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Bose deco ijigʉ̃ wahaya mʉsa sehsaro. Yʉhʉ pehere yʉhʉ wahati pje dʉhsarĩne. Sa yegʉ yʉhʉ pehe bose decore mianogãre ihñaʉ waharĩsi, nidi Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Sa nino tiquiro Galileapʉ tojoari. ");
INSERT INTO pirNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Bose decopʉ Jesu bahana tiquina wahari bato Jesu gʉ̃hʉ tiquina bato wahari. Sa waharo masa tiquina ihñeno watoa wahari. ");
INSERT INTO pirNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Bose deco ijiyequina judio masa ʉsã pʉhtoa tiquirore macari: —‍¿Nohopʉ ijiagari tiquiro? ni sinituahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Sa ye masa gʉ̃hʉ Jesure peyequina yahu wajahye. Apequina “Tiquiro quehnoariquiro ijire”, niahye. Apequina “Tiquiro ñariquiro ijire. Masare mehoriquiro ijire”, ni yahu wajahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Sa niepeta judio masa ʉsã pʉhtoare cueye masa tiquina ihñenopʉ Jesure yahu wajahye. ");
INSERT INTO pirNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Bose decori deco mehna dʉhsagʉ̃ Cohãcjʉ̃ wʉhʉpʉ Jesu sajã saro, buheri. ");
INSERT INTO pirNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Tiquiro sa buhegʉ̃ ʉsã acaye judio masa tʉho maria waha, ohõ saha nidi: —‍¿Ahriquiro buheropʉ buhemehnediquiro ijieperota dʉhsero quehnoano masi pehoajari? nidi tiquina basi tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Tiquina sa nigʉ̃ Jesu yahuri tiquinare: —‍Yʉhʉ buheri yee yahuducuye ijierare. Yʉhʉre ohoriquiro ye yahuducuye pehe ijire ahri buheye. ");
INSERT INTO pirNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Cohãcjʉ̃ cahmeñene ye duayequina yʉhʉ buheye pehere Cohãcjʉ̃ ye yahuducuye ti ijigʉ̃ masieta. Yʉhʉ esa tuharo yʉhʉ buheragʉ̃ gʉ̃hʉre masieta tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ihcãquiro tiquiro esa tuharo tiquiro masiñe mehna buhero “Yʉhʉ dihitare ño peoya”, nino nine tiquiro. Sa ijiepegʉ̃ta yʉhʉre ohoriquiro pehere mʉsa ño peogʉ̃ cahmeaja yʉhʉ pehe. Yʉhʉ sa nigʉ̃ tʉhona “Potota ni yahuducure tiquiro. Ne mehoedare”, ni masinata mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Cohãcjʉ̃ dutiyere Moise mʉnano pehe cũahye mʉsare. Tiquiro sa cũepegʉ̃ta mʉsa ijipihtina ti dutiye pehere ne yʉhtierari. ¿Dʉhsena yʉhʉre wejẽ duajari mʉsa? nidi Jesu ʉsã acaye judio masare. ");
INSERT INTO pirNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","—‍Tʉho masiedare mʉhʉ. Watĩnore cʉore mʉhʉ. Mʉhʉre wejẽ duayequina mariedare, ni yʉhtiri tiquina Jesure. Tiquina sa nigʉ̃ Jesu yʉhtiri: ");
INSERT INTO pirNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","—‍Mari judio masa mari sori deco saurú ijigʉ̃ ihcã tahata Cohãcjʉ̃ tutuaye mehna dohatiriquiro tiquiro dohatiyere yʉhʉ cohãgʉ̃ mʉsa ihña maria wahari. ");
INSERT INTO pirNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mari ñecʉsʉmʉa mʉna panopʉ cjẽna pehe tiquina pagʉre cuhnucunʉ sohtoa cahserogãre yʉhre neñequina tiquina yeriro sahata Moise yʉhre ne dutiahye. Potota Moise pehe ti dutirore cũedahye. Mari ñecʉsʉmʉa mʉna iji turiayequina pehe tire cũ, yahu turiahye. Tiquiro sa dutigʉ̃ saurú sori deco ijiepegʉ̃ta masʉnore tiquiro cuhnucunʉ sohtoa cahserogãre yʉhre nene mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Saurú ijigʉ̃ masʉnore tiquiro cuhnucunʉ sohtoa cahserogãre yʉhre nene mʉsa, Moise dutiyere yena tana. ¿Mʉsa gʉ̃hʉ saurú decore tire yepenata ti decopʉ dohatiriquirore yʉhʉ yʉhdʉogʉ̃ dʉhsena yʉhʉ mehna usuajari mʉsa? ");
INSERT INTO pirNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Yʉhʉ yerire mʉsa quehnoano masiedapenata, yʉhʉre ñano tʉhotueracãhña. Mʉsa quehnoano masidi bato yʉhʉre mʉsa tʉhotugʉ̃ potota ijirota. Yʉhʉ yerire masina, queoro masiña mʉsa, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Tiquiro sa ni yahuri bato meheñequinagã Jerusalẽ cjẽna tiquirore ohõ saha ni yahu wajari: —‍¿Ahriquiro judio masa pʉhtoa tiquina wejẽ duariquiro ijierajari? ");
INSERT INTO pirNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Sa yero tiquirore tiquina wejẽ duepegʉ̃ta ijipihtiyequina ihñono masare buhero nine tiquiro. Sa ye tiquirore wejẽ duayequina ijiepeta sa ihña cãre. ¿“Tiquiro potota Cristo ijire”, ni, tʉhotuagari pʉhtoa pehe? ");
INSERT INTO pirNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Sa ijiepegʉ̃ta ahriquiro Jesu tiquiro ahtarirore mari masiaja. Cristo pehe masare yʉhdʉoatiquiro tiquiro ahtagʉ̃ tiquiro ahtariro pehere masimehnedare. Sa yero masare yʉhdʉoatiquiro Cristo waro ijierare Jesu, ni yahu wajari tiquina Jerusalẽ cjẽna. ");
INSERT INTO pirNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Tiquina sa niñene masino, Jesu ohõ saha ni tutuaro sañuducu buheri Cohãcjʉ̃ wʉhʉpʉ: —‍Yʉhʉre ohõ saha ni tʉhoture mʉsa: “Tiquirore masiaja. Sa yena tiquiro ahtariro gʉ̃hʉre masiaja”, ni tʉhotumene mʉsa. Mʉsa sa ni tʉhotuepenata yʉhʉre ohoriquirore ne masiedare mʉsa. Yʉhʉre ohoriquiro poto niniquiro, poto yeriquiro ijire. Tiquirore ne masiedare mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Tiquirota yʉhʉre ohori. Sa yegʉ tiquiro cahapʉta ahtaʉ. Sa yegʉ yʉhʉ pehe tiquirore masiaja, nidi Jesu judio masare. ");
INSERT INTO pirNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Tiquiro sa nigʉ̃ tʉhoye tiquirore ñehe duamedi. Tiquina sa ñehe duepegʉ̃ta Jesu tiquiro ñano yʉhdʉati pje dʉhsarĩdi. Sa ye tiquina tiquirore ñehe masiedari. ");
INSERT INTO pirNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Apequina masa pehe peyequina tiquirore wacũ tutuaye, ohõ saha nidi: —‍“Cristo peye tahari Cohãcjʉ̃ tutuaye mehna ye ihñonota”, panopʉ tiquina ni yahu mʉhtariro sahata ahriquiro Jesu pehe peye tahari Cohãcjʉ̃ tutuaye mehna ye ihñore. Ijipihtiyequina apequina yʉhdʉoro Cohãcjʉ̃ tutuaye mehna ye ihñore tiquiro. Sa yero Cristo Cohãcjʉ̃ ohoriquirota ijire ahriquiro Jesu, nidi Jesure wacũ tutua dʉcayequina. ");
INSERT INTO pirNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Masa Jesure tiquina sa ni yahuducugʉ̃ tʉhoahye fariseo masa. Sa ye tiquina, pahia pʉhtoa mehna Jesure ñehe dutiye ohoahye surarare, Cohãcjʉ̃ wʉhʉre cohteyequinare. ");
INSERT INTO pirNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Sa yero Jesu judio masare ohõ saha nidi: —‍Meheñe decorigã mʉsa mehna ijiniitja. Sa yegʉ mehenogã bato yʉhʉre ohoriquiro cahapʉ wahaʉtja. ");
INSERT INTO pirNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Yʉhʉ ijiatore mʉsa waha masiedare. Sa yena yʉhʉre macaepenata ne bocasi mʉsa, nidi Jesu judio masare. ");
INSERT INTO pirNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Tiquiro sa nigʉ̃ tʉhoye tiquina basi ohõ saha ni yahuducuri: —‍¿Ahriquiro sa nino nohopʉ waharotari, mʉsa tʉhotugʉ̃? ¿Griego masa cahapʉ judio masa waha siteriquina tiquina ijiye macaripʉ griego masapʉre buhero wahaboagari ahriquiro? ");
INSERT INTO pirNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿“Yʉhʉ ijiatore mʉsa waha masiedare. Sa yena mʉsa yʉhʉre macaepenata ne bocasi”, tiquiro nigʉ̃ dʉhse nino boro ahriquiro sa niajari? ni yahuducuri judio masa tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Bose deco bato tiri deco ti deco waro ijiro nidi. Ti decore Jesu topʉ ducuro, tutuaro mehna sañuducu yahuri: —‍Aco wʉoyequina acore tiquina tutuaro cahmeno saha ijipihtiye decori Cohãcjʉ̃ mehna mʉsa ijiatire tutuaro cahmena yʉhʉre siniña. Mʉsa sa sinigʉ̃ tiquiro yequina mʉsare iji dutiitja. ");
INSERT INTO pirNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Yʉhʉre wacũ tutuayequinare ohõ saha ni ojoahye Cohãcjʉ̃ yere tiquina ojoari pũpʉ: “Mári pohteripʉ catigʉ̃ yeye aco sa wijiaducuro sahata catigʉ̃ yeriquiro tiquina mehna sa ijiducurota”, ni ojoahye Cohãcjʉ̃ yere tiquina ojoari pũpʉ, ni yahuri Jesu judio masare. ");
INSERT INTO pirNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Sa catigʉ̃ yeriquirore wame peo yahuro “Yʉhʉre wacũ tutuayequina Espíritu Santore cʉoeta”, nino nidi Jesu. Tiquiro ʉhmʉsepʉ tiquiro mʉjaedarĩgʉ̃ Espíritu Santo pehe wihieraniahye. ");
INSERT INTO pirNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jesu tiquiro sa nigʉ̃ tʉhoye, masa peyequina ohõ saha ni yahuducuri: —‍Ahriquiro potota Cohãcjʉ̃ yere yahu mʉhtariquiro mari cohteriquiro ijire, nidi masa. ");
INSERT INTO pirNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ohõ saha nidi apequina gʉ̃hʉ: —‍Ahriquiro Cristo marine yʉhdʉoatiquiro ijire, nidi. Apequina pehe ohõ saha nidi: —‍Cristo ahtaro, Galilea yehpa cjʉ̃no ijisi tiquiro. Ahriquiro Jesu pehe to cjʉ̃nota ijire. ");
INSERT INTO pirNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Cristo Davi mʉnano panamino ape tjuro cjʉ̃no ijiatiquiro ijirota. Sa yero Davi ya maca ijiriropʉ Belẽpʉ Cristo masa bajuarota. Ohõ saha ni yahure Cohãcjʉ̃ yere tiquina ojoari pũpʉ. Ahriquiro Jesu pehe Belẽpʉ masa bajuerahye. Sa yero tiquiro Cohãcjʉ̃ ohoriquiro Cristo waro ijierare, nidi tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Sa ye Jesure tʉhomediquina pʉa curua tu wari tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Meheñequinagã masa pehe Jesure ñehe duamedi. Sa ñehe duepeta tiquirore ñehedari. ");
INSERT INTO pirNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Sa ye surara pahia pʉhtoa cahapʉ fariseo masa cahapʉ tojoaa wahahye. Tiquina tojoa sagʉ̃ ihñañe tiquina surarare sinituahye: —‍¿Dʉhsena Jesure ñehedari mʉsa? ni sinituahye tiquina pehe. ");
INSERT INTO pirNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","—‍Tiquiro quehnoa yʉhdʉaro yahuducuriquiro ijiri. Apequina tiquiro yero saha yahuducuyequina ne mariedare, ni yʉhtiahye surara tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Tiquina sa nigʉ̃ fariseo masa pehe ohõ saha ni yahuahye: —‍¿Mʉsare tiquiro mehogʉ̃ “Potota nino niaga”, niajari mʉsa gʉ̃hʉ? ");
INSERT INTO pirNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Mari pʉhtoa Jesure wacũ tutueyequina ijiye ne tiquirore cahmedare. Ʉsã gʉ̃hʉ sa ijina tiquirore cahmedaja. ");
INSERT INTO pirNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ahriquina masa pehe Cohãcjʉ̃ dutiyere Moisere tiquiro cũrire masiedare. (Sa masieñequina ijiye Jesure wacũ tutuayequina ijiye, tiquirore cahmene.) Tiquina sa cahmedi buhiri tiquinare mari Pacʉ buhiri dahrerota, niahye fariseo masa. ");
INSERT INTO pirNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Fariseo masʉno Nicodemo Jesure yahuducuro esariquiro topʉ ijiahye tiquina mehna. Tiquina sa nigʉ̃ tʉhoro ohõ saha niahye tiquiro tiquinare: ");
INSERT INTO pirNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—‍Jesu ñano yerire masiedaja mari. Sa masiedana marine tiquiro yahuato pano tiquirore buhiri dahre masiedaja mari. Sa masiedapenata tiquirore buhiri dahrena, mari ye dutiyere yʉhdʉdʉcana niaja mari, niahye Nicodemo tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Tiquiro sa nigʉ̃ tʉhoye ohõ saha ni yʉhtiahye tiquina: —‍¿Mʉhʉ gʉ̃hʉ tiquiro yero saha Galilea cjʉ̃ta ijiajari? Cohãcjʉ̃ yere tiquina ojoari pũre buhe pehoya. Sa buhegʉ “Cohãcjʉ̃ yere yahu mʉhtariquina ne ihcãquiro mariedare Galileare”, ni buhe masiita mʉhʉ. (Sa yero sa ni maca cãno nine Jesu,) ni yʉhtiahye tiquina Nicodemore.  ");
INSERT INTO pirNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Tiquina sa nidi bato tiquina ye wʉhʉsepʉ tojoaa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesu cʉnʉpʉ Olivo wame tidʉpʉ wahari. ");
INSERT INTO pirNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Sa yero bohrearo Cohãcjʉ̃ wʉhʉpʉ tiquiro esari tja. Tiquiro esagʉ̃ ihñañe masa peyequina tiquiro cahapʉ cahmecoari. Tiquina sa cahmecoagʉ̃ ihñano tiquiro pehe dujitjiãno tiquinare buhe dʉcari. ");
INSERT INTO pirNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Tiquiro sa buheri watoa ʉsã acaye judio masa buheyequina, fariseo masa mehna ti wʉhʉpʉ numinore ne cãhtari. Ticoro ʉmʉno mehna ñano yegʉ̃ waro wacũeno mehna esa pjeahye tiquina ticorore. Sa esa pjeye ticorore Cohãcjʉ̃ wʉhʉpʉ ne sajãri tiquina. Ne sajã sa tuhasa ijipihtiyequina ihñono ticorore duhu docoye ohõ saha nidi: ");
INSERT INTO pirNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","—‍Buhegʉ, ahricoro ʉmʉno mehna ñano ticoro yegʉ̃ waro wacũeno mehna ticorore esa pjei. ");
INSERT INTO pirNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Cohãcjʉ̃ dutiyere Moise mʉnanopʉ marine tiquiro cũri ohõ saha nine: “Ʉmʉno mehna ñano yericorore ʉtã paca mehna doque wejẽña”, niahye Cohãcjʉ̃ dutiye. ¿Mʉhʉ waro dʉhse ni tʉhotuajari ahrire? ni sinituri tiquina Jesure. ");
INSERT INTO pirNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Jesu ñano nigʉ̃ tʉho duaye nimedi tiquina tiquirore yahusãñe tehe. Tiquina sa sinituepegʉ̃ta Jesu muhri quehe, yehpapʉ tiquiro omo piria mehna ojoari. ");
INSERT INTO pirNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Sa tiquina ni sinituducugʉ̃ Jesu pehe wahcã nuju sa, tiquinare yahuri: —‍Mʉsa mehna cjʉ̃no ñano yerariquiro ticorore ʉtã mehna doque mʉhtaahdo, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Sa ni tuhasa pari turi muhri quehe, yehpapʉ ojoari tja. ");
INSERT INTO pirNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Tire tʉhoye tiquina ñañe yerire wacũñe, tiquina wahmisʉmʉa pehe wijia mʉhtari. Tiquina bato tiriquina mehna cjẽna gʉ̃hʉ wijia pihtia wahari. Sa yero numino topʉ ducuricoro Jesu mehna tojoari. ");
INSERT INTO pirNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Sa yero Jesu wahcã nuju sa ticorore sinituri: —‍¿Nohopʉ wahajari tiquina? ¿Mʉhʉre buhiri dahre duamediquina mariedajari yojopʉre? nidi ticorore. ");
INSERT INTO pirNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","—‍Mariedare pʉhto, ni yʉhtiri ticoro. —‍Yʉhʉ gʉ̃hʉ buhiri dahreraja mʉhʉre. Wahaya. Sa yego ñañene ye nemoedacãhña, nidi Jesu ticorore. ");
INSERT INTO pirNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Pari turi Jesu ti wʉhʉpʉ ijiyequinare yahuri: —‍Buhrioro marine to ihña masigʉ̃ yero sahata yʉhʉ ahri yehpa cjẽnare Cohãcjʉ̃re masigʉ̃ yeaja. Yʉhʉre wacũ tutuariquiro ijipihtiye decori Cohãcjʉ̃ mehna sa ijiducurota. Sa yero tiquiro quehnoañene wacũnota. Sa yero tiquiro ñañene wacũ duerare, ni yahuri Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Tiquiro sa nigʉ̃ tiquirore fariseo masa ohõ saha nidi: —‍Mʉhʉ basi mʉhʉ ijiye tiyere sa ni yahuducugʉ nine. Sa ye mʉhʉ ohõ saha ni mʉhʉ esa tuharo mʉhʉ ni yahuducu maca quẽhe ne dʉhseati ijierare, nidi tiquina Jesure. Tiquina sa nigʉ̃ Jesu yʉhtiri: ");
INSERT INTO pirNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","—‍Yʉhʉ ahtarirore masiaja yʉhʉ. Yʉhʉ wahato gʉ̃hʉre masiaja yʉhʉ. Mʉsa ne tire masiedare. Mʉsa ohõ saha niepegʉ̃ta yʉhʉ ijiye tiyere mʉsare yʉhʉ yahuri poto tjire. ");
INSERT INTO pirNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mʉsa esa tuharo mʉsa ihñari dihitare masine mʉsa. Sa yena quehnoano masiedare mʉsa. Sa masiedapenata yʉhʉre ñano ni yahuducure mʉsa. Yʉhʉ pehe yʉhʉ esa tuharo masare ne sa niedaja. ");
INSERT INTO pirNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Sa yegʉ masa tiquina ijiye tiyere ihña masigʉ yʉhʉ esa tuharo ihña masiedaja. Yʉhʉ pũrita yʉhʉre ohoriquiro mehna ihña masiaja. Sa yegʉ masa tiquina ijiye tiyere yʉhʉ ihña masiñe poto tjire. ");
INSERT INTO pirNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mʉsare dutiye tiquina ojoari pũ ohõ saha ni yahure. “Pʉaro masa ihcãno saha tiquina yahugʉ̃ ohõ saha tiquina yahuye poto tjire”, ni yahu ojoari jiri. ");
INSERT INTO pirNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Yʉhʉre yahuriquiro mehna ʉsã pʉana tjiaja. Yʉhʉ ijiye tiyere yahuaja yʉhʉ. Sa yero yʉhʉ Pacʉ gʉ̃hʉ yahure yʉhʉ pehere. Tiquiro tjire yʉhʉre ohoriquiro, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","—‍¿Nohopʉ ijiagari mʉhʉ pacʉ? ni sinituri tiquina. —‍Yʉhʉre mʉsa masiedare. Yʉhʉ Pacʉ gʉ̃hʉre masiedare mʉsa. Yʉhʉre masina, yʉhʉ Pacʉ gʉ̃hʉre masiboaga mʉsa, ni yʉhtiri Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesu tiquinare buhero sa ni yahuducuri Cohãcjʉ̃ wʉhʉpʉ tiquina niñeru sãñe acari cahapʉ. Tiquiro ñano yʉhdʉati pje ijieranidi. Sa ye tiquina mehna tiquiro ijiepegʉ̃ta tiquina tiquirore ñehedari. ");
INSERT INTO pirNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Pari turi Jesu tiquinare yahuri tja: —‍Yʉhʉ ahtariropʉ wahaʉtja. Yʉhʉ wahari bato mʉsa yʉhʉre macanata. Sa yena mʉsa ñañe buhiri tiye mehna yarianata. Yʉhʉ wahatopʉre mʉsa pehe waha masisi, ni yahuri Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","—‍“Yʉhʉ wahatopʉre mʉsa pehe waha masisi”, tiquiro nigʉ̃ tʉhoye, “¿Ahriquiro tiquiro basi wejẽ yariarotari, sa nino?” nidi ʉsã acaye judio masa tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Tiquina basi sa nigʉ̃ Jesu yahuri tiquinare: —‍Mʉsa pehe ahri yehpa cjãna ijire. Yʉhʉ pehe ʉhmʉse cjʉ̃ ijiaja. Ahri yehpapʉ bajuarina ijire mʉsa pehe. Ʉhmʉsepʉ ahtarigʉ ijiaja yʉhʉ pehe. ");
INSERT INTO pirNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Mʉsa yʉhʉ ijiye tiyere yʉhʉ nidire “Poto ijierare”, nina, mʉsa ñañe buhiri tiye mehna yarianata mʉsa. Sa yegʉ “Mʉsa ñañe buhiri tiye mehna yarianata mʉsa”, nimi mʉsare, nidi Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","—‍¿Noa boro ijiajari mʉhʉ? ni sinituri tiquina. —‍Coã waropʉre yʉhʉ niducuriro sahata ijiaja yʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mʉsare yʉhʉ yahuati pajiro dʉhsarĩne. Sa yero mʉsa ñano yeri buhirire mʉsare yʉhʉ yahuati pajiro dʉhsarĩne. Sa yegʉ yʉhʉre ohoriquiro tiquiro yahurire ahri yehpa cjẽnare yahuaja. Tiquiro yahuri poto tjire, nidi Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","“Yʉhʉre ohoriquiro”, tiquiro nigʉ̃ tʉhoye, “Mari Pacʉ ijiaga”, ni tʉhotuerari tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Tiquina sa ni tʉhotueragʉ̃ ihñano Jesu yahuri tiquinare. —‍Yʉhʉre masʉre Cohãcjʉ̃ ohorigʉre mʉsa yucʉ teõ mehna wahcõ doconata. Mʉsa sa yena, “Tiquiro Cohãcjʉ̃ ohoriquiro tjire”, ni masinata mʉsa yʉhʉre. Sa yena yʉhʉ esa tuharo yʉhʉ yerarigʉ ijigʉ̃ masinata mʉsa. Sa yena yʉhʉ Pacʉ yʉhʉre tiquiro buheri dihitare yahurigʉ yʉhʉ ijigʉ̃ gʉ̃hʉre masinata mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Sa yero yʉhʉre ohoriquiro pehe yʉhʉ mehna ijire. Tiquiro cahmeñene ijipihtiye decori yeducuaja. Sa yero yʉhʉre tiquiro ne cohãedare, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Tiquiro sa nigʉ̃ tʉhoye, tiquirore masa peyequina wacũ tutuari. ");
INSERT INTO pirNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Sa ye apequina judio masa Jesure wacũ tutuari. Sa yero Jesu tiquinare yahuri: —‍Yʉhʉ dutiyere ye pehona, potota yʉhʉ buhena ijire mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Sa yena poto masinata mʉsa. Poto ijiyere masina, ñañe yeyere duhu masinata. Sa yena cahacjẽna yero saha iji nemosi mʉsa, nidi Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Tiquiro sa nigʉ̃ tʉhoye ohõ saha ni yʉhtiri tiquina: —‍Ʉsã pehe panopʉ cjʉ̃no Abrahã mʉnano panamena iji turiana ijiaja. Sa yena ne apequina tiquina cahacjãna ijieraja ʉsã. ¿Sa yegʉ “Cahacjẽna yero saha iji nemosi”, nigʉ, dʉhse ijiro boro ʉsãre sa niajari mʉhʉ? ni sinituri tiquina Jesure. ");
INSERT INTO pirNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Tiquina sa nigʉ̃ tʉhoro ohõ saha nidi tiquiro: —‍Ijirota niaja mʉsare. Ijipihtiyequina ñañene yeyequina pehe tiquina ñañene ye duhu masiedare. Sa yero ñañe pehe tiquina pʉhtoro yero saha ijire. Sa ijiyequina ijiye cahacjẽna yero saha ijire tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Cahacjʉ̃no pehe tiquiro pʉhtoro ya curua cjʉ̃no ijipihtiye decori ijiducuerare. Ti wʉhʉ cjʉ̃no macʉno pehe ijipihtiye decori potota ti curua cjʉ̃no ijire tiquiro. (Yʉhʉ pehe Cohãcjʉ̃ macʉ ijiaja. Sa yegʉ dutigʉ ijiaja. Mʉsa ñañe yeyere duhu dutiitja.) ");
INSERT INTO pirNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Sa yena yʉhʉ Cohãcjʉ̃ macʉ ñañene yʉhʉ duhugʉ̃ yenohrina ijina potota ñañene duhurina ijire mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Abrahã mʉnano panamena iji turiana mʉsa ijigʉ̃ masiaja. Sa ijiepenata yʉhʉ yahuye pehere tʉho duerare mʉsa. Sa yena yʉhʉre wejẽ duare mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Yʉhʉ Pacʉ yʉhʉre tiquiro masigʉ̃ yerire yahuaja mʉsare. Yʉhʉ sa yahuepegʉ̃ta mʉsa pacʉ watĩno mʉsare tiquiro dutiyere yere mʉsa gʉ̃hʉ, nidi Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","—‍Abrahã mʉnano panopʉ cjʉ̃no ʉsã ñecʉ mʉnano ijie tiahye. Sa yero watĩno ʉsã pacʉ ijierare, ni yʉhtiri tiquina. Tiquina sa nigʉ̃ Jesu yʉhtiri: —‍Abrahã panamena iji turiana ijina, tiquiro yeriro sahata yeboaga mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Cohãcjʉ̃ yʉhʉre poto tiquiro yahuyere mʉsare yʉhʉ yahuepegʉ̃ta yʉhʉre wejẽ duare mʉsa. Abrahã mʉnano pehe ne sa yera tiahye. ");
INSERT INTO pirNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mʉsa pacʉ tiquiro yeriro sahata yere mʉsa, nidi Jesu tiquinare. Tiquiro sa nigʉ̃ tiquina yʉhtiri: —‍Omoca dʉhtemehneñequina pohna ijieraja ʉsã. Ihcãquirota ijire ʉsã Pacʉ. Tiquirota ijire Cohãcjʉ̃, nidi tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Tiquina sa nigʉ̃ Jesu yʉhtiri: —‍Cohãcjʉ̃ mehna cjʉ̃ ijigʉ, ohõpʉre ahtaʉ. Sa yena Cohãcjʉ̃ mʉsa Pacʉ tiquiro ijigʉ̃ yʉhʉre cahĩboya mʉsa. Yʉhʉ esa tuharo ahtaerʉ yʉhʉ pũrita. Cohãcjʉ̃ tiquiro ohogʉ̃ ahtaʉ ohõpʉre. ");
INSERT INTO pirNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Dʉhsena yʉhʉ yahuducuyere tʉhoerajari mʉsa? Yʉhʉ yahuyere tʉho duerare mʉsa. Sa yena tʉhoerare mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mʉsa pacʉ pehe watĩno ijire. Sa yena watĩno cahmeñe pehere ye duare mʉsa. Ahri yehpa coã waropʉ to iji dʉcagʉ̃pʉ, yojopʉ gʉ̃hʉre tiquiro masare wejẽdiquiro ijire. Tiquirore poto yahuducuye mariedare. Sa yero tiquiro ne poto yahuducuerare. Tiquiro coã waropʉre ni meho mʉhta dʉcariquiro ijie tiahye. Sa yero tiquiro sa ni mehoducuriquiro ijiro, ni mehoñene yahure. ");
INSERT INTO pirNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Yʉhʉ pehe mʉsare poto yahuaja. Sa yʉhʉ yahuepegʉ̃ta yʉhʉre tʉhoerare mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","“Mʉhʉ ñano yegʉ ijire”, yʉhʉre ni masiedare mʉsa. ¿Poto mʉsare yʉhʉ yahuepegʉ̃ta dʉhsena tʉhoerajari mʉsa? ");
INSERT INTO pirNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Cohãcjʉ̃ pohne pehe tiquiro yahuducuyere tʉhore. Tiquiro pohne ijierana, tiquiro yahuducuyere tʉho duerare mʉsa, nidi Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Tiquiro sa nigʉ̃ tʉhoye judio masa tiquirore ohõ saha nidi: —‍“Mʉhʉ Samaria cjʉ̃ ijire. Sa yegʉ watĩnore cʉore mʉhʉ”, ʉsã nidi poto tjire, nidi tiquina Jesure. ");
INSERT INTO pirNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Tiquina sa nigʉ̃ tʉhoro ohõ saha ni yʉhtiri Jesu: —‍Watĩnore cʉoeraja yʉhʉ. Yʉhʉ Pacʉre ño peoaja. Mʉsa pehe yʉhʉre ño peoerare. ");
INSERT INTO pirNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Yʉhʉre masa tiquina ño peogʉ̃ cahmedaja yʉhʉ. Yʉhʉ Pacʉ pehe yʉhʉre ño peogʉ̃ cahmene masare. Tiquiro pũrita yʉhʉ ijiye tiyere quehnoano ihña masino, sata ño peo dutire. Sa yero yʉhʉre tiquina cahmedari buhiri, buhiri dahreatiquiro ijirota tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ijirota niaja mʉsare. Yʉhʉ dutiyere yeriquiro ijipihtiye decori Cohãcjʉ̃ mehna sa ijiducurota, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Tiquiro sa nigʉ̃ tʉhoye ohõ saha nidi tiquina: —‍Yojopʉ pũritare watĩnore cʉogʉ mʉhʉ ijigʉ̃ ʉsã quehnoano masiaja. Abrahã mʉnano yariaa wahahye. Cohãcjʉ̃ yere yahu mʉhtariquina gʉ̃hʉ yaria pihtia wahahye. ¿Sa yegʉ “Yʉhʉ dutiyere yeriquiro ijipihtiye decori Cohãcjʉ̃ mehna sa ijiducurota”, nigʉ dʉhse nigʉ sa niajari mʉhʉ? ");
INSERT INTO pirNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Ʉsã ñecʉ mʉnano Abrahã yʉhdʉoro tutuajari mʉhʉ? Tiquiro, Cohãcjʉ̃ yere yahu mʉhtariquina gʉ̃hʉ yariaa wahahye. ¿Mʉhʉ pehe noa boro ijiajari mʉhʉ, sa ni yahuducugʉ? Mʉhʉ sa nibogʉ ijierare, nidi tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Tiquina sa nigʉ̃ tʉhoro Jesu yahu nemori: —‍Yʉhʉ basi “Tutuagʉ ijiaja yʉhʉ”, yʉhʉ nigʉ, tutuagʉ ijieraboaga yʉhʉ. Yʉhʉ Pacʉ pehe “Tiquiro tutuariquiro ijire”, nine yʉhʉre. “Ʉsã Pacʉ”, mʉsa nidiquiro pehe yʉhʉ Pacʉ tjire. ");
INSERT INTO pirNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Mʉsa pehe yʉhʉ Pacʉre ne masiedare. Yʉhʉ pehe tiquirore masiaja. “Tiquirore masiedaja”, nigʉ mʉsa yero saha ni mehoñe peyagʉ ijiboaga yʉhʉ. Potota tiquirore masiaja. Sa yegʉ tiquiro dutiyere yeaja. ");
INSERT INTO pirNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ahri yehpapʉ yʉhʉ ahtatore mari ñecʉ Abrahã mʉnano masie tiahye. Sa masino tiquiro bucuee tiahye, nidi Jesu. Tiquiro sa nigʉ̃ tiquina yʉhtiri: ");
INSERT INTO pirNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","—‍Cincuenta cʉhmari cʉoeraga mʉhʉ. Abrahã mʉnano panopʉ cjʉ̃no ijiri. ¿Yojopʉre tiquiro mʉnanore mʉhʉ dʉhse masiboagari? nidi judio masa Jesure. ");
INSERT INTO pirNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","—‍Ijirota niaja mʉsare. Abrahã tiquiro ijiato pano yʉhʉ pehe iji mʉhta tuhasae tii, nidi Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Tiquiro sa nigʉ̃ tʉhoye tiquina pehe ʉtã pacare ne, tiquirore doque duamedi. Tiquina sa doque duepegʉ̃ta Jesu pehe Cohãcjʉ̃ wʉhʉpʉ ijiriquiro duhti wijiaa wahari. ");
INSERT INTO pirNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Sa yena Jesu ʉsã tiquiro buhena mehna mahapʉ wahana, apequirore caperi bajueriquirore boca saʉ. Tiquiro wahma masa bajuaropʉta caperi bajueriquiro ijie tiahye. ");
INSERT INTO pirNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ʉsã gʉ̃hʉ tiquirore ihñana, sinituu Jesure: —‍¿Buhegʉ, ahriquiro dʉhsero caperi bajueriquiro masa bajuayari? ¿Ñañene yeyari tiquiro sa waharo? ¿O tiquiro pacʉsʉmʉa pehe ñañene yeyari tiquiro sa wahagʉ̃? ni sinituu ʉsã pehe Jesure. ");
INSERT INTO pirNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ʉsã sa nigʉ̃ tʉhoro ohõ saha ni yʉhtiri tiquiro: —‍Ahriquiro ñañene yeri buhiri caperi bajueriquiro wahaerari. Tiquiro pacʉsʉmʉa gʉ̃hʉ ñañene tiquina yeri buhiri caperi bajueriquiro wahaerari. Cohãcjʉ̃ tiquirore caperi bajueragʉ̃ yeri tiquirore ihñagʉ̃ yero taro, masare tiquiro ihñoatire. ");
INSERT INTO pirNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Yʉhʉre ohoriquiro tiquiro cũrire yojopʉre yero cahmene marine. Ñamipʉ mari dahra masieno sahata camepʉ yʉhʉre ohoriquiro tiquiro cũrire ye masiedaja mari. ");
INSERT INTO pirNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ahri yehpapʉ buhrioro marine to ihña masigʉ̃ yero saha ijigʉ ahri yehpa cjẽnare Cohãcjʉ̃ yere masigʉ̃ yeaja yʉhʉ, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Sa ni tuhasarota yehpapʉ sihco puti cũri. Tiquiro sa sihco puti cũrire dihta mehna dahra more, caperi bajueriquirore tiquiro caperire wisõri. ");
INSERT INTO pirNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Sa wisõno ohõ saha nidi Jesu: —‍Siloé wame tiri copepʉ cuhsari copepʉ mʉhʉ caperire cosegʉ wahaya, nidi Jesu. Siloé ʉsã ye mehna niñe “Ohori cope”, niñe nidi. Jesu tiquiro caperire cose dutiriquiro pehe waha, cose, caperi ihñariquiropʉ tojoa wihiri. ");
INSERT INTO pirNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Tiquiro tojoa wihigʉ̃ tiquiro cahapʉ ijiyequina tiquirore ihñari. To pano niñeru sinimediquiro tiquiro ijigʉ̃ ihñariquina tiquirore ohõ saha nidi tiquina basi: —‍¿Ahriquiro sohõ ijiriquiro niñeru sinidiquiro ijierajari? nidi tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","—‍Tiquirota ijire, nidi apequina pehe. —‍Tiquiro ijierare. Tiquiro saha bajuriquiro ijire, nidi apequina pehe. Tiquina sa nigʉ̃ tʉhoro caperi bajueramediquiro pehe ohõ saha nidi: —‍Tiquiro tjiaja yʉhʉ, nidi tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Tiquiro sa nigʉ̃ masa tiquirore sinituri. —‍¿Caperi bajuegʉ ijirigʉ dʉhse waha ihñari mʉhʉ? ni sinituri tiquina tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","—‍Jesu wame tiriquiro sihco co mehna dihta mehna dahra more, yʉhʉ caperire wisõri. Yʉhʉre wisõ tuhasa “Siloé wame tiri copepʉ mʉhʉ caperire cosegʉ wahaya”, tiquiro nigʉ̃ cosegʉ esaʉ yʉhʉ. Yʉhʉ sa coseri bato yʉhʉ caperi quehnoano bajuri yʉhʉre, ni, yahuri tiquiro masare. ");
INSERT INTO pirNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","—‍¿Mʉhʉre sa yeriquiro nohopʉ ijiagari tiquiro? nidi tiquina. —‍Õbah. Noho ijiro ijiaga, nidi tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Sa ni yahuducu tuhasa tiquina caperi bajueramediquirore fariseo masa cahapʉ neari. ");
INSERT INTO pirNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ti deco Jesu dihtare sihco co mehna dahra more caperi bajueriquirore tiquiro ihñagʉ̃ yeri deco saurú deco ijiri. Ti deco ʉsã sori deco ijiri. ");
INSERT INTO pirNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Sa ye fariseo masa pehe tiquirore sinituahye tja. —‍¿Dʉhse ye mʉhʉ ihñari? ni sinituahye tiquina. —‍Dihta mehna yʉhʉ caperire wisõri. Sa yegʉ yʉhʉ caperire yʉhʉ coseri bato ihña dʉcaʉ yʉhʉ, ni yahuahye tiquiro tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","—‍Tiquiro saurú decore mari sori decore mari dahra dutieri decore dahraya. Sa yero tiquiro Cohãcjʉ̃ yaquiro ijierare, niahye apequina fariseo masa pehe. Apequina pehe ohõ saha niahye: —‍Ñañene yeriquiro ohõ saha yʉhdʉo masiedare. Sa yero tiquiro quehnoariquiro ijiboaga, niahye apequina. Sa ye tiquina pʉa curua tu wahye tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Sa ye pari turi tiquina caperi bajueramediquirore sinituahye tja. —‍¿Mʉhʉre caperire quehnoano yeriquirore mʉhʉ waro dʉhse ni tʉhotuajari Jesure? niahye tiquina tiquirore. —‍Tiquiro potota Cohãcjʉ̃ yere yahu mʉhtariquiro ijire, niahye caperi bajueramediquiro. ");
INSERT INTO pirNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Coã waropʉre judio masa ohõ saha ni tʉhotumahye. “Ahriquiro caperi bajueramediquiro ijierare”, ni tʉhotumahye tiquina. Sa ni tʉhotuye caperi bajueramediquiro pacʉsʉmʉare pijioahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Pijio, tiquiro pacʉsʉmʉare sinituahye fariseo masa pʉhtoa. —‍¿Ahriquiro potota mʉsa macʉ ijiajari? ¿Duita tiquiro caperi bajueriquiro masa bajuari? ¿Potota caperi bajueriquiro ijieperota dʉhsero ihñajari yojopʉre? ni sinituahye tiquina tiquiro pacʉsʉmʉare. ");
INSERT INTO pirNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","—‍Ahriquiro ʉsã macʉta ijire. Sa yero duita caperi bajueriquiro masa bajue tiri tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Tire masiepenata tiquiro ihñarire, tiquirore ihñagʉ̃ yeriquiro gʉ̃hʉre masiedaja ʉsã. Ʉsã macʉre sinituya. Bʉcʉro ijire tiquiro. Tiquiro basi yahu masine, niahye tiquiro pacʉsʉmʉa. ");
INSERT INTO pirNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Judio masa ʉsã pʉhtoa coã waropʉre ohõ saha nie tiahye. —‍“Jesuta Cristo Cohãcjʉ̃ ohoriquiro ijire”, niñequinare mari buheye wʉhʉsepʉ sajã dutisi ʉsã, nie tiahye judio masa pʉhtoa. Tiquina sa nigʉ̃ tʉhoye caperi bajueramediquiro pacʉsʉmʉa judio masa pʉhtoare cue niahye. ");
INSERT INTO pirNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Sa cueye, “Bʉcʉro ijire tiquiro. Tiquirore sinituya”, niahye tiquina judio masa pʉhtoare. ");
INSERT INTO pirNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Came judio masa pʉhtoa pari turi pijioahye caperi bajueramediquirore tja. Pijio ohõ saha niahye tiquirore: —‍Cohãcjʉ̃ mehna poto yahuya mʉhʉ. Jesure ni mehoriquiro tiquiro ñañe yeriquiro ijigʉ̃ ʉsã masiaja. Sa yegʉ poto yahuya ʉsãre, niahye judio masa caperi bajueramediquirore. ");
INSERT INTO pirNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Tiquina sa nigʉ̃ tʉhoro ohõ saha ni yʉhtiahye tiquiro: —‍Jesure tiquiro ñañe yeriquiro ijigʉ̃ masiedaja yʉhʉ. Ihcãnota masiaja yʉhʉ. Panopʉre caperi bajuegʉ ijie tii yʉhʉ. Yojopʉre ihñaja yʉhʉ. Ti dihitare masiaja yʉhʉ, ni yʉhtiahye caperi bajueramediquiro tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","—‍¿Dʉhse yeri mʉhʉre tiquiro? ¿Mʉhʉ caperi ihñatire dʉhse yeri tiquiro mʉhʉre? ni sinituahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","—‍Tireta mʉsare yahu tuhasami yʉhʉ. Yʉhʉ sa niepegʉ̃ta mʉsa ne tʉho duerare yʉhʉre. ¿Dʉhse ye duana pari turi yʉhʉ yahugʉ̃ tʉho duajari mʉsa? ¿Mʉsa gʉ̃hʉ tiquiro buhena iji duajari? niahye tiquiro tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tiquiro sa nigʉ̃ tʉhoye tiquina tuhtiahye tiquirore: —‍Mʉhʉ Jesu buherigʉ ijire. Ʉsã pehe Moise buhena ijiaja. ");
INSERT INTO pirNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Potota Cohãcjʉ̃ Moisere yahuducue tiahye. Jesu tiquiro ahtarirore ʉsã masiedaja, niahye tiquina caperi bajueramediquirore. ");
INSERT INTO pirNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Tiquina sa nigʉ̃ yʉhtiahye tiquiro: —‍¿Tiquiro ahtarirore mʉsa masiedagʉ̃ yʉhʉre ihñagʉ̃ yeriquiro ijiro, Cohãcjʉ̃ ohoriquiro ijieraboagari tiquiro? ");
INSERT INTO pirNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Cohãcjʉ̃ ñañe yeyequinare tiquina siniñene tʉhoerare. Ti pũritare mari masiaja. Tiquinare tʉhoeraperota Cohãcjʉ̃re ño peoriquirore, tiquiro dutiyere yeriquirore tiquiro siniñene tʉhore Cohãcjʉ̃. ");
INSERT INTO pirNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Coã waropʉre ahri yehpa iji dʉcagʉ̃pʉre ne coã masa bajuaropʉ caperi bajueriquirore ne ihcãquiro ihñagʉ̃ yeriquiro marieda tiahye. ");
INSERT INTO pirNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Sa yero Jesu Cohãcjʉ̃ ohoriquiro ijieraro yʉhʉre ihñagʉ̃ yeraboaya tiquiro, niahye tiquiro tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","—‍Mʉhʉ duita ñagʉ ijie tiahye. ¿Sa ijiepegʉta ʉsãre buhe duajari mʉhʉ? niahye judio masa pʉhtoa tiquirore. Sa ni tuhasayeta tiquina tiquirore cohã wio cãhye. ");
INSERT INTO pirNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Sa yero caperi bajueramediquirore tiquina cohã wiorire Jesu tʉhori. Sa tʉhoro caperi bajueramediquirore boca saro tiquirore sinituri: —‍¿Masʉnore Cohãcjʉ̃ ohoriquirore wacũ tutuajari mʉhʉ? nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","—‍¿Pʉhto, noa ijiajari tiquiro? Tiquirore masigʉ wacũ tutuagʉtja tiquirore, nidi caperi bajueramediquiro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","—‍Tiquirore ihña tuhasari mʉhʉ. Yojopʉre mʉhʉ mehna yahuducugʉ tiquirota ijiaja yʉhʉ, nidi Jesu caperi bajueramediquirore. ");
INSERT INTO pirNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","—‍Pʉhto, mʉhʉre wacũ tutuaja, nidi caperi bajueramediquiro. Sa nino tiquiro Jesu caha dʉsepe curi mehna quehe sa, tiquirore ño peori. ");
INSERT INTO pirNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Tiquiro sa ño peogʉ̃ ihñano ohõ saha nidi Jesu: —‍Quehnoañequina, ñañequina gʉ̃hʉ tiquina yerire masigʉ̃ yei ahtaʉ ahri yehpapʉre. Caperi bajueyequina tiquina ihña masieno saha tiquina yero saha ijiyequina yʉhʉ Pacʉre masiedare. Sa masieñequinare yʉhʉ Pacʉre masigʉ̃ yei ahtaʉ yʉhʉ. “Ʉsã quehnoano masiaja”, ni tʉhotumediquina quehnoano tiquina masiedarire masigʉ̃ yei ahtaʉ yʉhʉ, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Tiquiro sa nigʉ̃ tʉhoye meheñequinagã fariseo masa tiquirore ohõ saha nidi: —‍¿“Caperi bajueyequina tiquina ihña masieno saha quehnoano masiedare mʉsa gʉ̃hʉ”, nii niajari mʉhʉ ʉsãre? nidi fariseo masa Jesure. ");
INSERT INTO pirNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Tiquina sa nigʉ̃ ohõ saha nidi Jesu: —‍Caperi bajueyequina tiquina ihña masieno saha poto mʉsa quehnoano masiedagʉ̃, mʉsare buhiri mariedaboaya. “Ʉsã quehnoano masina ijiaja”, mʉsa nidi buhiri, buhiri tina ijinine mʉsa yojopʉre, nidi Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Came queoye mehna buhero ohõ saha nidi Jesu: —‍Ijirota niaja mʉsare. Ovejare cohteri sahrĩno sopecaha sajãedariquiro, sopecaha marienopʉ sajãriquiro pehe yaque bʉcʉro ijire. ");
INSERT INTO pirNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Sopecaha sajãriquiro pehe ovejare cohteriquiro ijire. ");
INSERT INTO pirNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Sopecahare cohteriquiro sopecahare põore ovejare cohteriquiro sajãtore. Ovejare cohteriquiro yahuducugʉ̃ tʉho cãhtare tiquiro nuñequina oveja pari. Tiquinare pijioro tiquina wame mehna pisuducure tiquiro. Sa yero tiquinare sahrĩnopʉ ijiriquinare piji wiodocore sopecahapʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Tiquiro yequinare ijipihtiyequinare piji wio tiquinare sa ʉhmʉ tãducure. Oveja pehe tiquiro yahuducuyere tʉho masiñe tiquiro bato nʉnʉ tãre. ");
INSERT INTO pirNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Apequirore tiquina ihña masieniquirore nʉnʉ tãedare tiquina. Sa ye apequina tiquina yahuducuyere tʉhoye, cue oma sitea wahare, nidi Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ahri queoyere tiquiro sa yahuepegʉ̃ta tiquiro yahuyere masiedari tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Pari turi Jesu tiquinare yahuri tja: —‍Ijirota niaja mʉsare. Ovejare cohteri sahrĩno sopecaha yero saha ijiaja yʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ijipihtiyequina yʉhʉ pano ahtayequina ni mehoñene buheyequina yaqueyequina yero saha ijire. Tiquina sa ijiepegʉ̃ta oveja yero saha ijiyequina yeequina pehe apequinare ne tʉho cãedare. ");
INSERT INTO pirNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Yʉhʉ ovejare cohteri sahrĩno sopecaha yero saha ijiaja. Sopecaha sajãñequina yero saha ijire yʉhʉre wacũ tutuayequina. Sa yegʉ tiquinare pecapʉ wahaboriquinare yʉhdʉoutja. Ovejare cahmotari sahrĩno tiquinare cahmotariro sahata yʉhʉ yʉhdʉoyequinare cahmotaʉtja. Sa ye tiquina cahmeñene cʉoeta tiquina, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Sa ni tuhasa ohõ saha ni nemori: —‍Mʉsare ni meho buheyequina ovejare yaqueyequina yero saha ijire. Apequina yaque duaye, apequina wejẽ duaye ahtare. Oveja yero saha ijiyequinare, yeequina ijipihtiye decori Cohãcjʉ̃ mehna ijiatiquinare yegʉ ahtaʉ yʉhʉ. Sa yegʉ yeequina decoripe tiquina bucueatire ahtaʉ yʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ovejare quehnoano cohteriquiro yero saha ijiaja yʉhʉ. Ovejare quehnoano cohteriquiro yariatiquiro ijieperota tiquiro yequina ovejare cohtere, “Sijoro wahari”, nino. Yeequina Cohãcjʉ̃ mehna tiquina sa ijiducuatire yegʉ yariʉtja yʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Oveja upʉro cahacjʉ̃no pehe oveja upʉro ijierare. Sa yeye oveja tiquiro yequina ijierare. Sa yero yairo ovejare tiquiro ihyaro ahtagʉ̃ ihñano tiquiro cahacjʉ̃no pehe ovejare cohã doco cã, oma cãa wahare. Tiquiro sa cohã docori bato, yairo ovejare tiquiro ñehegʉ̃ ihñañe oveja pari oma site cãa wahare. ");
INSERT INTO pirNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Tiquiro cahacjʉ̃no pehe tiquiro wapataye dihitare cahmene. Sa yero tiquiro ovejare quehnoano cohte coaerare, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Sa ni tuhasa ohõ saha ni nemori: —‍Ovejare quehnoano cohteriquiro yero saha ijiaja yʉhʉ. Sa yegʉ yeequinare masiaja yʉhʉ. Sa yeye yeequina pehe yʉhʉre masine. ");
INSERT INTO pirNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Sata yʉhʉ Pacʉ gʉ̃hʉ yʉhʉre masine. Sa yegʉ yʉhʉ gʉ̃hʉ yʉhʉ Pacʉre masiaja. Oveja yero saha ijiyequina yeequina Cohãcjʉ̃ mehna tiquina sa ijiducuatire yariʉtja yʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Apequina oveja ape sahrĩno cjẽna yero saha ijiyequina apequina masa gʉ̃hʉ yeequina ijieta. Tiquina gʉ̃hʉre neagʉtja. Sa ye yʉhʉ yahuducugʉ̃ tʉho cãeta tiquina gʉ̃hʉ. Sa ye yeequina ijipihtiyequina ihcã curuata ijieta. Sa yegʉ yʉhʉ dihita yeequinare cohteitja, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Sa ni tuhasa ohõ saha ni nemori: —‍Yeequina Cohãcjʉ̃ mehna tiquina sa ijiducuatire yariʉtja yʉhʉ. Yʉhʉ yariari bato masa mʉjagʉtja. Sa yeacjʉ yʉhʉ ijigʉ̃ yʉhʉ Pacʉ yʉhʉre cahĩne. ");
INSERT INTO pirNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Yʉhʉ wejẽ dutieragʉ̃ yʉhʉre wejẽ masiedaboaya tiquina. Yʉhʉ cahmeno sahata yʉhʉre wejẽeta. Sa yegʉ yeequina Cohãcjʉ̃ mehna tiquina sa ijiducuatire yariʉtja. Yaria masiaja yʉhʉ. Sa yegʉ masa mʉja masiaja. Yʉhʉ Pacʉ yʉhʉre tireta ye dutiri, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Tiquiro sa nigʉ̃ tʉhoye judio masa pʉa curua tu wari. Apequina sijoro tʉhotu, apequina gʉ̃hʉ sijoro tʉhoturi. ");
INSERT INTO pirNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","—‍Tiquiro watĩno cʉore. Sa yero tʉho masiedare. ¿Dʉhsena tiquirore pari turi tʉhoajari mʉsa? nidi apequina peyequina judio masa. ");
INSERT INTO pirNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Apequina pehe ohõ saha nidi: —‍Watĩno cʉoriquiro ijiro sa ni yahuducueraboaya. Caperi bajueriquirore ihñagʉ̃ ye masiedare watĩnore cʉoriquiro. Sa yero watĩnore cʉoerare Jesu, nidi apequina judio masa. ");
INSERT INTO pirNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ape deco ʉsã acaye judio masa Jerusalẽpʉ bose deco yeye nidi pari turi. Cohãcjʉ̃ wʉhʉre panopʉ Cohãcjʉ̃re tiquina ohorire tiquina wacũati deco ijiri. Ti pjere pohecʉ ijiri. ");
INSERT INTO pirNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ti decore Salomo wame tiri tucũpʉ Cohãcjʉ̃ wʉhʉpʉ ijiri tucũpʉ Jesu ihña tinino nidi. ");
INSERT INTO pirNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ti tucũpʉ tiquiro ijigʉ̃ ihñañe ʉsã acaye judio masa tiquiro cahapʉ cahmecoa, tiquirore sinituri. —‍Yoabutiari pje ʉsãre quehnoano yahueraga mʉhʉ. Poto ʉsãre quehnoano yahu madoqueohya mʉhʉ. ¿Cohãcjʉ̃ ohorigʉ Cristota ijiajari mʉhʉ? nidi tiquina Jesure. ");
INSERT INTO pirNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Tiquina sa nigʉ̃ tʉhoro ohõ saha ni yʉhtiri Jesu: —‍Mʉsare yahu tuhasamajagʉ. Yʉhʉ sa yahuepegʉ̃ta yʉhʉre tʉho duerare mʉsa. Yʉhʉ Pacʉ yʉhʉre tiquiro dutiriro sahata tiquiro tutuaye mehna ye ihñoaja. Sa yegʉ yʉhʉ Cristo ijiyereta mʉsare ihñogʉ niaja. ");
INSERT INTO pirNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Yʉhʉ sa ihñoepegʉ̃ta yʉhʉre tʉho duerare mʉsa. Mʉsa pehe yeequina ijierare. Sa yena apequiro yequina oveja yero saha ijina, yʉhʉ pehere tʉhoerare mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ovejare cohteriquirore tiquiro yequina tiquina tʉhoriro saha yʉhʉre yeequina tʉhore. Sa yegʉ tiquinare masiaja yʉhʉ. Sa ye tiquina yʉhʉ mehna wahare. ");
INSERT INTO pirNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Sa yegʉ ijipihtiye decori Cohãcjʉ̃ mehna ijigʉ̃ yeaja tiquinare. Sa ye tiquina pecapʉ wahasi. Sa yegʉ yeequinare yʉhʉ cohtegʉ̃ apequina pehe ne yʉhʉre ehma masiedare yeequinare. ");
INSERT INTO pirNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Yʉhʉ Pacʉ yʉhʉre yeequinare ohoriquiro ijipihtiyequina yʉhdʉoro tutuariquiro ijire. Sa ye yʉhʉ Pacʉ pehe yeequinare tiquiro cohtegʉ̃ apequina pehe tiquiro gʉ̃hʉre ne ehma masiedare tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Yʉhʉ, yʉhʉ Pacʉ mehna ihcʉ̃ta ijiaja, nidi Jesu judio masare. ");
INSERT INTO pirNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Tiquiro sa nigʉ̃ tʉhoye judio masa pehe tiquirore tiquina doque wejẽati ʉtã pacare pari turi nemedi tja. ");
INSERT INTO pirNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Tiquina sa yegʉ̃ ihñano Jesu sinituri tiquinare: —‍Yʉhʉ Pacʉ tutuaye mehna peye tahari ye ihñomi mʉsare. ¿Dise boro pehere yʉhʉ yeri buhiri yʉhʉre ʉtã paca mehna doque wejẽ duajari mʉsa? ni sinituri Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Tiquiro sa nigʉ̃ tʉhoye ohõ saha nidi tiquina: —‍Cohãcjʉ̃ tutuaye mehna mʉhʉ ye ihñori buhiri mʉhʉre ʉtã mehna doque wejẽ dueraja ʉsã. Cohãcjʉ̃re mʉhʉ ñano yahuducuri buhiri mʉhʉre ʉtã paca mehna doque wejẽ duaja ʉsã. Masʉ ijiepegʉta “Cohãcjʉ̃ ijiaja yʉhʉ”, mʉhʉ niñe buhiri mehna mʉhʉre ʉtã paca mehna doque wejẽ duaja ʉsã, ni yʉhtiri tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Tiquina sa ni yʉhtigʉ̃ tʉhoro Jesu tiquinare yahuri: —‍Mʉsa gʉ̃hʉre “Cohãmana”, ni pisuri Cohãcjʉ̃. Sata ni ojoahye tiquiro dutiyere tiquina ojoari pũpʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Cohãcjʉ̃ yere tiquina ojoari pũ potota ijigʉ̃ mari masiaja. “Ni mehoñe ijire”, ti pũre ni masiedaja mari. Sa yero tiquiro yere tʉhoyequinare potota tiquiro “Cohãmana”, ni pisure. ");
INSERT INTO pirNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Cohãcjʉ̃ yʉhʉre besetjiãno, ahri yehpapʉre ohori. Sa yegʉ yʉhʉ “Cohãcjʉ̃ macʉ ijiaja”, yʉhʉ nidi buhiri “Cohãcjʉ̃re ñano yahuducuro nine Jesu”, nine mʉsa yʉhʉre. ¿Dʉhsena yʉhʉre sa niajari mʉsa? ");
INSERT INTO pirNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Yʉhʉ Pacʉ tiquiro cahmediro sahata tiquiro tutuaye mehna yʉhʉ ye ihñoedagʉ̃ pũritare yʉhʉ buherire “Poto tjire” niedaboaga mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Yʉhʉ Pacʉ tiquiro tutuaye mehna yʉhʉ ye ihñoepegʉ̃ta yʉhʉ pehere tʉho duerare mʉsa. Sa tʉho duerapenata tiquiro tutuaye mehna yʉhʉ ye ihñogʉ̃ ihñana yʉhʉ yerire “Poto tjire”, niña mʉsa. Mʉsa sa nina, yʉhʉ Pacʉ mehna ʉsã ihcãno saha ijigʉ̃ masinata mʉsa. Sa yena tʉhonata mʉsa, nidi Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Tiquiro sa nigʉ̃ tiquina pari turi tiquirore ñehe duamedi. Tiquina sa ñehe duagʉ̃ ihñano tiquiro duhti wijiaa wahari. ");
INSERT INTO pirNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Sa wijiariquiropʉta Ñu masare tiquiro wame ye mʉhtariropʉ Jordã asʉ̃ mʉja taro pehepʉ pari turi Jesu wahari tja. Topʉ esaro tojoa cãri tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Sa ye masa peyequina tiquirore ihñañe esari. Ohõ saha nidi tiquina basi: —‍Ñu pehe Cohãcjʉ̃ tutuaye mehna ye ihñoedari. Sa ye ihñoedapegʉ̃ta ijipihtiye Jesure tiquiro yahuri pehe queorota ijire, nidi masa tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Sa ye topʉre masa peyequina wacũ tutua dʉcari Jesure. ");
INSERT INTO pirNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Sa ye Betania wame tiri maca cjʉ̃no Lázaro wame tiriquiro dohatiro niahye. Ti macapʉ tiquiro wahmiosãnumia gʉ̃hʉ María, Marta mehna ijiri. ");
INSERT INTO pirNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","María pehe Jesure ehme sitiye pio wisõaticoro, ticoro poari mehna tiquirore tu coseaticoro ijire. Ticoro bahʉro Lázaro pehe dohatiro niahye. ");
INSERT INTO pirNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Sa ye tiquina numia apequinare Jesure yahu dutiye ohoahye. —‍Pʉhto, mʉhʉ cahĩniquiro dohatiro nine, ni yahu dutiye ohoahye Lázaro wahmiosãnumia. ");
INSERT INTO pirNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ti quitire tʉhoro ohõ saha nidi Jesu: —‍Yojopʉre Lázaro tiquiro dohatiye tiquiro yariati ijierare. Cohãcjʉ̃ tutuayere masare ihñoatire yojopʉre tiquiro dohatire. Sa ye yʉhʉ tutuagʉ yʉhʉ ijigʉ̃ gʉ̃hʉre masa ihñaeta, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesu Martare, ticoro bahoro gʉ̃hʉre, Lázaro gʉ̃hʉre tutuaro cahĩdi. ");
INSERT INTO pirNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Sa nino Lázaro tiquiro dohatigʉ̃ tʉhoeperota topʉ Jesu pʉa deco tojoari. ");
INSERT INTO pirNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Pʉa deco bato Jesu ohõ saha nidi ʉsãre tiquiro buhenare: —‍Pari turi Judea yehpapʉ tojoa wahaʉhna tja, nidi ʉsãre. ");
INSERT INTO pirNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","—‍Buhegʉ, canʉagãta judio masa mʉhʉre ʉtã paca mehna doque wejẽ duamedi. ¿Dʉhsegʉ pari turi tojoaa waha duajari mʉhʉ? nii ʉsã pehe. ");
INSERT INTO pirNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ʉsã sa nigʉ̃ tʉhoro tiquirore tiquina wejẽ masiedarĩne yahuro, queoye mehna buhero ohõ saha nidi ʉsãre: —‍Pajiro tʉhotueracãhña. Ihcã decore doce horari waro ijire. Asʉ̃ deco cjʉ̃no ijigʉ̃ quehnoano ihñaja mari. Sa yena decore tinina, ne pʉha boraeraja mari. ");
INSERT INTO pirNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Nahitianopʉ tiniñequina pʉha boraa wahare. Asʉ̃ deco cjʉ̃no mariedagʉ̃ quehnoano ihñedare tiquina, nidi Jesu. (Sa nino ohõ saha nino niahye: “Yojopʉre yʉhʉ Pacʉ yere yʉhʉ yahu pehoato dʉhsarĩne. Sa ye yʉhʉre wejẽ masiedarĩne”, nino niahye.) ");
INSERT INTO pirNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Sa nino ʉsãre yahu nemori tja: —‍Mari mehna cjʉ̃no Lázaro, carĩno niaga. Tiquiro sa carĩepegʉ̃ta yʉhʉ tiquirore wahcõgʉ wahaʉtja, nidi ʉsãre. ");
INSERT INTO pirNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","—‍Pʉhto, Lázaro carĩniquiro ijiro, yʉhdʉrota, nii ʉsã. ");
INSERT INTO pirNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ʉsã sa niepegʉ̃ta Jesu “Carĩno niaga”, nino “Yariaa wahare”, nino nidi jimedi. Tiquiro sa nigʉ̃ tʉhona “Lázaro soro niaga”, ni tʉhotumi ʉsã pehe. ");
INSERT INTO pirNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ʉsã sa ni tʉhotugʉ̃ masino Jesu poto yahuri ʉsãre: —‍Lázaro yariaa wahaga. ");
INSERT INTO pirNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Yʉhʉ marieno tiquiro yariagʉ̃ quehnoarĩne. Sa yena mʉsa yʉhʉre wacũ tutua nemonata. Isa mari ihñana wahaʉhna tiquiro cahapʉ, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomasu sʉhdʉariquiro tiquina ni pisuriquiro ohõ saha nidi ʉsãre: —‍Mari gʉ̃hʉ Jesu mehna wahaʉhna. Tiquirore wejẽñe, mari gʉ̃hʉre wejẽahdo, nidi Tomasu. ");
INSERT INTO pirNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Sa ye topʉre ʉsã esari bato to cjẽna ohõ saha ni yahuri Jesure: —‍Pititia deco wahare Lázaro mʉnanore masa copepʉ tiquina cũri bato, ni yahuri tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania pehe Jerusalẽ cahapʉ ihtia kilómetro yoaro ijiri. ");
INSERT INTO pirNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Sa ye ʉsã acaye judio masa peyequina Martare, María gʉ̃hʉre ñehe quea utiye ahtahye Lázaro yariari bato. ");
INSERT INTO pirNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Sa yero Jesu mehna ʉsã esana tana yegʉ̃ tʉhoro Marta pehe ʉsãre piti caro ahtari jiri. Ticoro sa piti caro wahagʉ̃ María pehe tiquina ya wʉhʉpʉ tojoahye. ");
INSERT INTO pirNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Sa piti caro Marta ohõ saha nidi Jesure: —‍Pʉhto, yʉhʉ bahʉ tiquiro yariato pano mʉhʉ ohõpʉ ijigʉ̃ tiquiro yarieraboaya. ");
INSERT INTO pirNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Yojopʉ gʉ̃hʉre Cohãcjʉ̃re mʉhʉ sini basagʉ̃ tiquiro mʉhʉ sinino sahata yerota, nidi Marta Jesure. ");
INSERT INTO pirNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","—‍Mʉhʉ bahʉ masa wijiarota, nidi Jesu ticorore. ");
INSERT INTO pirNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","—‍Ahri yehpa pihtiati deco tiquiro masa wijiatore masiaja yʉhʉ, nidi ticoro. ");
INSERT INTO pirNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ticoro sa nigʉ̃ Jesu yahuri tja: —‍Yʉhʉ masa wijiagʉ̃ yegʉ tjiaja. Yʉhʉ sa ijiducugʉ̃ yegʉ tjiaja. Yʉhʉre wacũ tutuariquiro yarieperota sa ijiducurota. ");
INSERT INTO pirNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Sa ye ijipihtiyequina Cohãcjʉ̃ mehna ijiducuyequina yʉhʉre wacũ tutuayequina ne pecapʉ wahasi. ¿Ahrire masiajari mʉhʉ? nidi Jesu ticorore. ");
INSERT INTO pirNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","—‍Pʉhto, masiaja yʉhʉ. Cristo Cohãcjʉ̃ macʉ, “Ahri yehpapʉ ahtarota”, tiquina nidigʉ mʉhʉ ijigʉ̃ masiaja yʉhʉ, nidi Marta Jesure. ");
INSERT INTO pirNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta sa ni tuhasa ticoro bahoro Maríare pijiro wahari. —‍Marine buheriquiro mari ya macapʉre wihiri. Mʉhʉre pijire, derogã ni yahuahye Maríare. ");
INSERT INTO pirNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ticoro sa nigʉ̃ tʉhoro María sojaro mehna wahcãdʉca, ʉsã cahapʉ ahtahye Jesure ihñano taro. ");
INSERT INTO pirNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Tiquina ya macapʉ esera nii ʉsã. Marta ticoro piti cariropʉ ijinii ʉsã. ");
INSERT INTO pirNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Judio masa ti wʉhʉpʉ Maríare ñehe quea utiye niahye. Sa ye ticoro wahagʉ̃ ihñañe, tiquina ticorore nʉnʉ tã cãhye. “Ticoro bahʉro mʉnanore tiquina cũri copepʉ utiro waharo nine ticoro”, ni tʉhotumahye tiquina. Sa ni tʉhotuye ticorore nʉnʉ tã cãhye. ");
INSERT INTO pirNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Sa yero María ʉsã cahapʉ wihiro, Jesure ihña, tiquiro dahpocãri cahapʉ dʉsepe curi mehna quehe sari. —‍Pʉhto, yʉhʉ bahʉ tiquiro yariato pano mʉhʉ ohõpʉ ijigʉ̃ tiquiro yarieraboaya, nidi ticoro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Sa yero judio masa ticoro mehna ahtariquina gʉ̃hʉ tiquina utigʉ̃ ihñano Jesu pehe tutuaro bʉjʉa witi ñano jeripohna tiri. ");
INSERT INTO pirNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","—‍¿Lázaro mʉnanore nohopʉ cohãri mʉsa? ni sinituri Jesu. —‍Ihñaʉ taya, ni piji cãri tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Tiquina sa nigʉ̃ tʉhoro Jesu utiri. ");
INSERT INTO pirNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","—‍Lázaro mʉnanore Jesu tutuaro cahĩmeyari, nidi judio masa tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Apequina pehe ohõ saha nidi: —‍Caperi bajueriquirore ihñagʉ̃ yeriquiro ijire ahriquiro Jesu. ¿Sa yero Lázaro tiquiro yariato pano tiquirore yʉhdʉoeraboayari? nidi tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Sa yero Jesu pari turi tutuaro bʉjʉa witiri. Sa yena ʉsã ijipihtina Lázaro masa copepʉ esaʉ. Ʉtãpʉ tiquina seheri cope ijiri. Sa yero tiquiro pagʉre tiquina siõ sãa cũri cope ijiri. Sa yero ti cope pajiria ʉtã mehna tiquina bihari cope ijiri. ");
INSERT INTO pirNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","—‍Ʉtã bihariare neña, nidi Jesu. Tiquiro sa nigʉ̃ tʉhoro Marta yariariquiro mʉnano wahmiono ohõ saha nidi: —‍Pʉhto, yojopʉ pititia deco waha tuhasare tiquiro yariari bato. Sa yero tiquiro pagʉ ijiriro ʉrĩ yʉhdʉaga, nidi Jesure. ");
INSERT INTO pirNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","—‍“Yʉhʉre wacũ tutuago Cohãcjʉ̃ tutuayere ihñagota”, mʉhʉre nimigʉ, nidi Jesu Martare. ");
INSERT INTO pirNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Tiquiro sa nidi bato tiquina ʉtã bihariare ne wiori. Tiquina sa nedi bato Jesu pehe ʉhmʉsepʉ ihña mʉo, Cohãcjʉ̃re ohõ saha nidi: —‍Mai, yʉhʉre mʉhʉ tʉho tuhasari. Tire mʉhʉ yegʉ̃ masigʉ bucueaja mʉhʉre. ");
INSERT INTO pirNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Yʉhʉre mʉhʉ decoripe tʉhoducure. Tire masiaja. Sa masiepegʉta yʉhʉ mʉhʉ ohorigʉ yʉhʉ ijigʉ̃ ohõre ducuyequina tiquina masiatire mʉhʉre sa niaja. Tire “Potota ijire”, tiquina nino quehnoano sa nigʉ niaja, nidi Jesu tiquiro Pacʉrore. ");
INSERT INTO pirNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Sa ni tuhasa Jesu tutuaro sañuducuri: —‍Lázaro ahtaya, ni sañuducuri tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Tiquiro sa nigʉ̃ yariariquiro mʉnano omocarine tiquiro dahpocãri gʉ̃hʉre suhti cahseri mehna tiquina dʉhtemediquiro, tiquiro dapure suhtiro mehna tiquina wahmemediquiro, masa copepʉ wijia tari. —‍Tiquina dʉhterire pãña tiquirore, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Tiquiro sa masogʉ̃ ihñañe peyequina judio masa mehna cjẽna María mehna ahtariquina Jesure wacũ tutua, cahmedi. ");
INSERT INTO pirNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Apequina tiquina mehna cjẽna pehe fariseo masa cahapʉ esaye, Jesu yerire yahuahye tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","48","Sa ye pahia pʉhtoa, fariseo masa pʉhtoa gʉ̃hʉ cahmecoa, tiquina basi ohõ saha ni yahuducuahye: —‍Jesu peye tahari Cohãcjʉ̃ tutuaye mehna ye ihñore. Tiquiro sa ye ihñogʉ̃ “Tire yeracãhña”, mari niedagʉ̃ ijipihtiyequina masa tiquirore cahmeñe, tiquiro mehna wahaboaga. Sa ye Roma cjẽna pʉhtoa Cohãcjʉ̃ wʉhʉre cohã dutiye ohoeta tiquina yequina surarare. Mari ya dihta gʉ̃hʉre ehmaeta tiquina. (Mari ya dihta cjẽna Jesure tiquina pʉhtoro cũgʉ̃ ihñañe Roma cjẽna pʉhtoa “Marine cohãñe nine”, ni usua ñano yeeta marine.) ¿Sa yena dʉhse yenatari yojopʉre? ni yahuducuahye tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Tiquina sa niepegʉ̃ta apequiro Caifa wame tiriquiro ti cʉhmare pahia pʉhtoro ijiro, tiquinare yahuahye: —‍Mʉsa pehe ne masiedare. ");
INSERT INTO pirNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Judio masa ijipihtina mari ye ijiatire ihcãquiro masʉno tiquiro yariagʉ̃ quehnoare. Tiquiro yarieragʉ̃ marine ijipihtina judio masare cohã peho cãboaga. Tire mʉsa masiedare, niahye Caifa tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Sa nino tiquiro esa tuharo sa nino niedahye. Pahia pʉhtoro tiquiro ijigʉ̃ judio masa ye ijiatire Jesu yariatire mari Pacʉ pehe Caifare sa ni yahu dutiahye. ");
INSERT INTO pirNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Jesu yariaro judio masa dihitare yʉhdʉoro taro niedare. Sa yariaro ijipihtiyequina Cohãcjʉ̃ pohnene ahri yehpapʉ iji siteyequina gʉ̃hʉre ihcã curuata ijigʉ̃ yeatire yariatiquiro ijiri Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Sa ye ti decota tiquina “¿Jesure dʉhse ye wejẽnatari mari?” ni yahuducuye, tiquirore wejẽñe tee niahye. ");
INSERT INTO pirNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Tiquina sa wejẽ duagʉ̃ masino Jesu peyequina judio masa watoa pari turi tinino wahaerari. Sa yero masa marieno cahagã Efraĩ wame tiri macapʉ ʉsãre siho wahari. Ʉsãre ti maca siho tojoarĩdi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ti pjere pascua bose decori ʉsã judio masa ʉsã bose decori ijiato mehenogã dʉhsatjiãri. Sa ye bose deco panogã masa peyequina apeye macari cjẽna Jerusalẽpʉ cahmecoari. Pascua cjẽne tiquina ihyato pano Cohãcjʉ̃ yere yeye tehe, tiquina cahmomohnore cohsoro saha tiquina ñañene cosee tee nidi. ");
INSERT INTO pirNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Sa ye tiquina Jesure macañe niahye. Sa ye Cohãcjʉ̃ wʉhʉpʉ ijiyequina ohõ saha ni yahuducuahye: —‍¿Bose decore ihñano ahtaeraboari Jesu, mʉsa tʉhotugʉ̃? niahye tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Sa ye pahia pʉhtoa, fariseo masa gʉ̃hʉ ohõ saha ni yahu dutiahye masare: —‍Jesu wihigʉ̃ ihñana, yahuya ʉsãre. Tiquirore ñehena tana niaja, niahye pʉhtoa masare. ");
INSERT INTO pirNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Jesu, ʉsã tiquiro buhena mehna Betaniapʉ ʉsã esari bato pascua deco esato seis decori waro dʉhsarĩdi. Lázaro Jesu masoriquiro ti maca cjʉ̃no ijiri. ");
INSERT INTO pirNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ʉsã esari bato Jesu gʉ̃hʉ ʉsã ihyatire dahreri apequina. Sa ye Lázaro, Jesu, ʉsã mehna mesa cahapʉ nuju saʉ. Ʉsã sa nuju sari bato Marta ihyayere peori ʉsãre. ");
INSERT INTO pirNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Sa yero María ehme sitiye ʉhsere nardo wame tiye cohori ʉhsere kilo deco mehna ne cãhta Jesu dahpocãrine pio peori. Ti ʉhse wapa ti yʉhdʉari. Pio peo tuhasa ticoro poari mehna wʉori. Ticoro sa pio peori bato ti wʉhʉ quehnoano ehme siti sehsaa wahari. ");
INSERT INTO pirNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ʉsã mehna cjʉ̃no, Jesure ihña tuhtiyequinare ihñoatiquiro Juda Iscariote pehe ohõ saha nidi: ");
INSERT INTO pirNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—‍¿Dʉhse yero ahricoro sa ye siteajari? Tire ticoro duaboaya. Tire duaro tres cientos niñeru cjoerire wapataboaya. Sa yero ticoro ti niñerure pejecʉoyequinare ohoboaya, nidi tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Juda pehe pejecʉoyequinare yedoho duerari. Tiquiro ʉsã niñerure ihbo basariquiro ijieperota yaqueriquiro ijiri. Sa yero tiquiro ʉsã niñerure ihquẽ tahari ne mʉjari. Sa yero “Ti niñerure neitja”, nino, sa nidi Maríare tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Tiquiro sa nigʉ̃ tʉhoro ohõ saha nidi Jesu: —‍Sa niedacãhña ticorore. Ticoro ehme sitiyere yʉhʉre ticoro dʉharire yʉhʉre pio peori, yʉhʉre tiquina yato pano yʉhʉ pagʉre quehnoyuro. Pejecʉoyequina pehe mʉsa mehna sa ijiducueta. Sa yena tiquinare oho masine mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Yʉhʉ pehe ahri yehpapʉre mʉsa mehna sa ijiducusi, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Sa ye Jesu Betaniapʉ tiquiro ijigʉ̃ tʉhoye, ʉsã acaye judio masa peyequina tiquirore ihñañe ahtari. Tiquiro dihitare ihñañe ahtaye niedari. Lázaro yariamediquirore Jesu masoriquirore tiquiro gʉ̃hʉre ihñañe ahtaye nidi. ");
INSERT INTO pirNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Tiquina ihñañe esarire masiñe, pahia pʉhtoa Lázaro gʉ̃hʉre wejẽ duari. ");
INSERT INTO pirNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Lázaro yariamediquiro Jesu masoriquiro ijigʉ̃ ihñañe peyequina masa Jesure wacũ tutuari. Tiquiro sa masogʉ̃ ihñañe peyequina judio masa tiquina pahia ye buheye pehere duhu cãri. Tiquina sa duhugʉ̃ ihñañe pahia pʉhtoa pehe usua yʉhdʉye Lázarore wejẽ duari. ");
INSERT INTO pirNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Pascua bose decore tiquina yegʉ̃ peyequina masa Jerusalẽpʉ ihñañe wahari jiri. Ape deco Jerusalẽpʉ Jesu ahtatire masa tʉhori. ");
INSERT INTO pirNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Sa ye iqui pohnarine ne cã, tiquirore piti caye wahari. Sa piti caye ohõ saha ni sañuducuri tiquina: —‍Ahriquirore ño peouhna. Ahriquiro Cohãcjʉ̃ ohoriquiro quehnoano ijiahro. Ahriquiro judio masa mari pʉhtoro tjire, ni sañuducuri tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesu burrogã tiquiro bocariquirogã bui pesari. “Ohõ sahata yerota”, ni ojoahye Cohãcjʉ̃ yere tiquina ojoari pũpʉ: ");
INSERT INTO pirNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Jerusalẽ wame tiri maca cjãna, cueracãhña mʉsa. Ihñaña. Mʉsa pʉhtoro burrogã bui pesa cãhtare, ni yahuahye Cohãcjʉ̃ yere tiquina ojoari pũpʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","“Tiquina sa ni ojoari Jesure nino niaga”, ni, ʉsã tiquiro buhena quehnoano masiedarĩi. Sa masiedapenata ʉhmʉsepʉ Jesu mʉjari bato ʉsã ti ojoarire wacũ boca tʉho masii. Ohõ saha ni tʉhotuu: “Cohãcjʉ̃ yere tiquina ojoari pũ pehe Jesure yahuro nimeya. Sa ye Cohãcjʉ̃ yere tiquina ojoari pũ nidiro sahata yeri masa Jesure”, ni tʉhotu, masii ʉsã. ");
INSERT INTO pirNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Lázarore masa copepʉ ijiriquirore Jesu pisu masogʉ̃ ihñariquina pehe yahuri masare. ");
INSERT INTO pirNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Sa ye Lázarore Jesu masorire tʉhori bato masa peyequina Jesure ihñañe ahtari. ");
INSERT INTO pirNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Tiquina sa ahtagʉ̃ ihñañe fariseo masa tiquina basi ohõ saha niahye: —‍Ijipihtiyequina Jesu yequina dihita wahaye nine yojopʉre. Sa yena mari dʉhse ye masiedaga tiquinare, niahye fariseo masa tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Sa ye bose deco Cohãcjʉ̃re ño peoye ahtayequina mehna cjẽna meheñequinagã griego masa ijiri. ");
INSERT INTO pirNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Sa ye tiquina Felipe cahapʉ wihiahye. Felipe pehe Betsaida wame tiri maca Galilea yehpapʉ ijiri maca cjʉ̃no ijiri. Sa ye tiquiro cahapʉ wihiriquina ohõ saha niahye tiquirore: —‍Jesure ihña duaga ʉsã, niahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Tiquina sa nigʉ̃ tʉhoro Felipe Andrepʉre tire yahuro wahahye. Sa ye tiquina pʉaro Jesure yahuri. ");
INSERT INTO pirNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Tiquina sa ni yahuri bato Jesu tiquinare yahuri: —‍Yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ ijiaja. Yʉhʉre ijipihtiyequina tiquina ño peoati pje yojopʉre ijirota nine. Yojopʉre yʉhʉ yariati pje ijirota nine. ");
INSERT INTO pirNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Potota mʉsare yahugʉ niaja. Oteri pjere yehpapʉ mari yaeragʉ̃, ti pjere mari oteragʉ̃ ihcã pjeta tojoarota. Sa yero ti pjere mari yari bato pihni, dʉca tirota. (Sata yʉhʉ yariari bato yʉhʉre tiquina yari bato peyequina masare Cohãcjʉ̃ mehna sa ijiducuatiquina ijigʉ̃ yeitja yʉhʉ.) ");
INSERT INTO pirNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ahri yehpapʉ mʉsa ijiyere pajiro tʉhotuboaga mʉsa. Sa tʉhotuna Cohãcjʉ̃re wacũedana, pecapʉ wahanata mʉsa. Ahri yehpapʉ mʉsa ijiyere sa tʉhotu cãna, Cohãcjʉ̃ mehna sa ijiducunata. ");
INSERT INTO pirNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Yeere ye duana yʉhʉ buheyere quehnoano tʉhoya mʉsa. Mʉsa sa yena mʉsa gʉ̃hʉ yʉhʉ ijiropʉ ijinata. Yeere yeriquirore yʉhʉ Pacʉ pehe ño peorota, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Sa ni tuhasa ohõ saha ni nemori: —‍Yojopʉre yʉhʉ ñano jeripohna tiaja. ¿Yʉhʉ Pacʉre dʉhse nigʉtari yʉhʉ? ¿“Mai, yʉhʉ ñano yʉhdʉatire yeracãhña yʉhʉre”, niboagari yʉhʉ? Tire niedaja yʉhʉ. Ñano yʉhdʉacjʉta ahri yehpapʉ ahtaʉ. Sa yero yʉhʉ ñano yʉhdʉati pje yojopʉre ijirota nine, ni yahuri ʉsãre tiquiro buhenare. ");
INSERT INTO pirNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Sa yero ohõ saha nidi tiquiro Pacʉrore: —‍Mai, mʉhʉ tutuagʉ ijiyere yojopʉre ihñoña masare, nidi Jesu tiquiro Pacʉrore. Tiquiro sa nigʉ̃ ʉhmʉsepʉ yahuducuro ca tari: —‍Tutuagʉ yʉhʉ ijiyere masare ihño tuhasaʉ. Yojopʉre sa yegʉ pari turi ihñoutja masare, nino ca tari. ");
INSERT INTO pirNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Tiquiro sa nigʉ̃ tʉhoye topʉ ducuyequina masa peyequina ohõ saha nidi: —‍Ʉpo ijiaga sa bisiro, nidi masa. —‍Angel Jesure yahuro nidi, nidi apequina masa. ");
INSERT INTO pirNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ohõ saha nidi Jesu pehe: —‍Ʉhmʉsepʉ sa bisiro yʉhʉre tʉho dutiro niedari. Mʉsa pehere tʉho dutiro sa bisiro ca tari. ");
INSERT INTO pirNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Yojopʉre ahri yehpa cjẽna tiquina ñañe yeri buhirire buhiri dahrerota tiquinare. Ahri yehpa cjẽna pʉhtoro watĩnore cohãnota Cohãcjʉ̃. ");
INSERT INTO pirNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Sa yegʉ yʉhʉre curusapʉ tiquina wahcõ docogʉ̃ peyequina masare yeequina ijiatiquinare yeitja yʉhʉ, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Sa nino curusapʉ tiquiro yariatire yahuro nidi Jesu masare. ");
INSERT INTO pirNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Tiquiro sa nigʉ̃ tʉhoye masa pehe tiquirore ohõ saha nidi: —‍Cohãcjʉ̃ yere tiquina ojoari pũpʉ ohõ saha nine: “Cristo ijipihtiye decori ijirota”, ni ojoahye. ¿Tiquiro sa ni ojoagʉ̃ mʉhʉre masʉre Cohãcjʉ̃ ohorigʉre dʉhse yeye curusapʉ wahcõ docoetari masa mʉhʉre? ¿Masʉno Cohãcjʉ̃ ohoriquiro noa ijiajari tiquiro? ni sinituri tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Tiquina sa nigʉ̃ ohõ saha ni yʉhtiri Jesu: —‍Buhrioro mehna mari ihña masigʉ̃ yero saha masare Cohãcjʉ̃ yere quehnoano masigʉ̃ yeaja yʉhʉ. Came cjũnogã mʉsa mehna ijisi yʉhʉ. Mʉsare yʉhʉ buhegʉ̃ yojopʉre tʉhoya mʉsa “Ñañe yeari”, nina, Cohãcjʉ̃ mehna mʉsa sa ijiducuatire. Yʉhʉ buheyere tʉhoeyequina nahitiano tiniñequina yero saha tiquina wahatore masiedare. ");
INSERT INTO pirNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Sa yegʉ buhrioro yero saha ijigʉ ijiaja yʉhʉ. Sa yegʉ mʉsare buhegʉ Cohãcjʉ̃ yere quehnoano masigʉ̃ yeaja mʉsare. Yojopʉre yʉhʉ wahato pano yʉhʉre wacũ tutuaya. Sa wacũ tutuana yeequina ijinata mʉsa, nidi Jesu. Sa ni yahu tuhasa duhti cãa wahari. ");
INSERT INTO pirNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Peye tahari Cohãcjʉ̃ tutuaye mehna tiquinare Jesu tiquiro ye ihñoepegʉ̃ta peyequina judio masa tiquirore ne tʉho duerari. ");
INSERT INTO pirNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Cohãcjʉ̃ yere tiquina ojoari pũpʉ Isaia mʉnano tiquiro ojoariro sahata yeye nidi tiquina. Ohõ saha ni ojoahye Isaia mʉnano: Cohãcjʉ̃, mʉhʉ buheyere ʉsã yahugʉ̃ masa ne tʉho duerare. Mʉhʉ tutuayere tiquinare mʉhʉ ye ihñoepegʉ̃ta, tire “Poto ijierare”, nidi tiquina, ni ojoahye Isaia mʉnano. ");
INSERT INTO pirNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Tiquina sa tʉho dueragʉ̃ ihñano Cohãcjʉ̃ tiquinare masiedagʉ̃ yeri. Ti gʉ̃hʉre Isaia mʉnano ohõ saha ni ojoahye: ");
INSERT INTO pirNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Caperi bajueyequina yero saha ijigʉ̃ yee tiahye Cohãcjʉ̃ tiquinare. Sa yero tiquiro yere masiedagʉ̃ yee tiahye tiquinare. Sa ye tiquiro tutuayere ihñaepeta tiquina ihñarire masiedare. Sa ye tiquiro buheyere tʉhoepeta tire masiedare tiquina. Cohãcjʉ̃ ye buheyere masiñe tiquina ñañe yerire cohã dutiboaya. Sa yero tiquinare yʉhdʉoboaya tiquiro, ni ojoahye Isaia mʉnano Cohãcjʉ̃ yere tiquina ojoari pũpʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Sa ni ojoaro Isaia Cristo tutuayere masino tiquiro nidiro sahata Cristore yahu ojoahye. ");
INSERT INTO pirNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Apequina Jesure tiquina cahmedapegʉ̃ta judio masa ʉsã pʉhtoa mehna cjẽna peyequina Jesure wacũ tutua, cahmedi. Sa cahmepeta tiquina fariseo masare cueye apequinare “Jesu yequina wahaʉ ʉsã”, ni yahu duerari. Tire tiquina yahugʉ̃ tʉhoye Jesure tiquina cahmedi buhiri judio masa ʉsã buheri wʉhʉpʉ tiquinare sajã dutieraboaga fariseo masa pehe. ");
INSERT INTO pirNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Cohãcjʉ̃re bucuegʉ̃ ye duepeta ti yʉhdʉoro fariseo masa pehere bucuegʉ̃ ye duari Jesure cahme dʉcayequina. Sa ye tiquina “Jesu yequina wahaʉ”, ni apequinare yahu duerari. ");
INSERT INTO pirNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Sa ye Jesu tutuaro sañuducu, yahuri: —‍Yʉhʉre wacũ tutuariquiro yʉhʉ dihitare wacũ tutuerare. Yʉhʉre ohoriquiro gʉ̃hʉre wacũ tutuare tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Sa ye yʉhʉre masiñequina yʉhʉre ohoriquiro gʉ̃hʉre masine. ");
INSERT INTO pirNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Buhrioro mehna mari ihña masigʉ̃ yero saha ahri yehpapʉ Cohãcjʉ̃ yere masigʉ̃ yei ahtaʉ nii yʉhʉ. Sa yegʉ Cohãcjʉ̃ yere masare masigʉ̃ yeaja. Ihcãquiro nahitiano wahariquiro yero saha ñañene yeducure. Yʉhʉre wacũ tutuariquiro tiquiro yero saha yesi. Yʉhʉre wacũ tutuariquiro potota tʉhorota. ");
INSERT INTO pirNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Apequina yʉhʉ yahuyere tʉhoepeta yʉhʉ nidiro saha yerare. Tiquina sa yerapegʉ̃ta tiquina yerari buhirire buhiri dahresi yʉhʉ pehe tiquinare. Ahri yehpapʉre buhiri dahregʉ ahtagʉ niedʉ yʉhʉ. Ahri yehpa cjẽnare pecapʉ wahaboriquinare yʉhdʉoacjʉ ahtagʉ nii yʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Yʉhʉre cahmeeñequina, yʉhʉ yahuye gʉ̃hʉre cahmeeñequina buhiri dahrenohatiquina ijieta. Tiquina yʉhʉ yahuyere tiquina tʉhoerari buhiri ahri yehpa pihtiri deco ijigʉ̃pʉ buhiri tieta. ");
INSERT INTO pirNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Yʉhʉ esa tuharo yeraja. Yʉhʉ Pacʉ yʉhʉre ohoriquiro pehe yʉhʉre yahu dutiri. Sa yero yʉhʉ yahuye pehe tiquiro ye yahuducuye ijire. ");
INSERT INTO pirNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Tiquiro ye yahuducuyere tʉhona Cohãcjʉ̃ mehna sa ijiducunata mʉsa. Sa yegʉ yʉhʉ Pacʉ tiquiro yahu dutiriro sahata yahuaja mʉsare, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Sa ye pascua deco bose deco panogã ahri yehpare tiquiro cohã cãtore tiquiro Pacʉro cahapʉ tiquiro wahatore masidi Jesu. Sa yero ahri yehpa cjẽnare tiquiro yequinare tiquiro tutuaro cahĩdi tiquina mehna tiquiro ijiro puno. Sa cahĩducure tiquiro yequinare. ");
INSERT INTO pirNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ti ñamine Jesu ʉsã tiquiro buhena mehna ʉsã ihyagʉ̃ Juda Iscariotere Simo macʉnore Jesure ihña tuhtiyequinare ihño duti tuhasari jiri watĩno pehe. ");
INSERT INTO pirNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Sa yero mari Pacʉ Cohãcjʉ̃ Jesure ijipihtiyequina bui tiquiro pʉhtoro sõrire masidi Jesu. Sa yero Cohãcjʉ̃ cahapʉ tiquiro ahtarire came ʉhmʉsepʉ tiquiro mʉjati gʉ̃hʉre masidi. ");
INSERT INTO pirNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Sa masino wahcãdʉca, tiquiro suhtiro bui cjãnore tu we ne, tore cũ tuhasa, suhtiro cahsero mehna tiquiro pari yʉjʉ dʉhteri. ");
INSERT INTO pirNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Dʉhte tuhasa, waparopʉ acore pio sãa, ʉsã tiquiro buhena dahpocãrine cose dʉcari. Ʉsãre cose tuhasa tiquiro dʉhteri cahsero mehna wʉori ʉsã dahpocãrine. ");
INSERT INTO pirNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Apequina buheyequinare cose cã, Simo Pedropʉre esari. Tiquiro dahpocãrine tiquiro coseato pano Pedro pehe tiquirore ohõ saha nidi: —‍¿Pʉhto, yʉhʉ dahpocãrine cosegʉ tʉʉ niajari mʉhʉ? nidi Pedro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","—‍Mianogã mʉhʉre yʉhʉ yeatire masiedare mʉhʉ. Sa masiedapegʉta camepʉ masiita mʉhʉ, nidi Jesu tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","—‍Yʉhʉ dahpocãrine ne cosesi mʉhʉ, nidi Pedro. —‍Mʉhʉre yʉhʉ coseragʉ̃ yaquiro ijisi mʉhʉ, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","—‍Pʉhto, yʉhʉ dahpocãri dihitare coseracãhña. Yʉhʉ dahpocãrine, yʉhʉ omocarine, yʉhʉ dapu gʉ̃hʉre coseya, nidi Pedro. ");
INSERT INTO pirNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Tiquiro sa nigʉ̃ Jesu queoye mehna buhero ohõ saha nidi: —‍Ihcãquiro masʉno cuhsaro tiquiro pagʉre quehnoano tu cose pehore. Sa yero pari turi tiquirore tu cosero cahmedare. Tiquiro dahpocãri dihitare tu cosero cahmene. Ijipihtina mʉsa ñañe yerire coserina mʉsa ijiepegʉ̃ta ihcãquiro mʉsa mehna cjʉ̃no tiquiro ñañene cosemehnediquiro ijire, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesu tiquirore ihña tuhtiyequinare ihñoatiquirore masidi: Sa masino “Ihcãquiro mʉsa mehna cjʉ̃no tiquiro ñañene cosemehnediquiro ijire”, nidi. ");
INSERT INTO pirNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ʉsã dahpocãrine cose tuhasa, tiquiro suhtirore saña tuhasa, nuju sari tiquiro dujiriropʉta. —‍¿Mianogã mʉsare yʉhʉ yerire masiajari mʉsa? ");
INSERT INTO pirNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Mʉsa yʉhʉre “Buhegʉ”, ni pisuna, “Pʉhto”, ni pisuna poto ninata nine mʉsa yʉhʉre. Mʉsare buhegʉ, mʉsa pʉhto potota ijiaja yʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Sa yena yʉhʉ mʉsare buhegʉ, mʉsa pʉhto ijiepegʉta mʉsa dahpocãrine yʉhʉ cosegʉ̃ ihñana mʉsa gʉ̃hʉ mʉsa mehna cjẽna dahpocãrine coseya. ");
INSERT INTO pirNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Mianogã mʉsa yeatire mʉsare ihñou. Mʉsa mehna cjẽnare mʉsa yedohoatire ihñou. Mʉsare yʉhʉ yeriro sahata mʉsa gʉ̃hʉ yeya. ");
INSERT INTO pirNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ijirota niaja mʉsare. Mʉsa yʉhʉ cahacjẽna yero saha ijina yʉhʉ bui ijierare. Mʉsare buhe duti yʉhʉ ohorina ijire mʉsa. Sa yena yʉhʉ bui ijierare mʉsa. Sa yegʉ “Yʉhʉ yeriro sahata yeya”, nii mʉsare. ");
INSERT INTO pirNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ahrire masina, yʉhʉ dutiyere yena, bucuena ijinata mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Mʉsare ijipihtinare sa niedaja. Yʉhʉ beseriquinare masiaja yʉhʉ. Cohãcjʉ̃ tiquiro yere tiquina ojoari pũpʉ tiquiro ni ojoariro sahata waharota. “Yʉhʉ mehna ihyariquirota yʉhʉre wejẽ duari”, ni ojoahye Cohãcjʉ̃ yere tiquina ojoari pũpʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Tiquiro sa yeato pano ahrire yahuyugʉ niaja mʉsare. Yʉhʉre tiquiro sa yeri bato, “Jesuta Cristo Cohãcjʉ̃ ohoriquirota ijire”, mʉsa niatire ahrire mʉsare yahuyugʉ niaja yʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ijirota mʉsare niaja. Yʉhʉ ohoriquinare cahmediquiro yʉhʉ gʉ̃hʉre cahmene tiquiro. Sa yero yʉhʉre cahmediquiro yʉhʉre ohoriquiro gʉ̃hʉre cahmene tiquiro, nidi Jesu ʉsãre tiquiro buhenare. ");
INSERT INTO pirNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Sa ni yahu tuhasa Jesu tutuaro bʉjʉa witiri. Sa bʉjʉa witiro yahuri tiquiro ʉsãre. —‍Ijirota mʉsare niaja. Ihcãquiro mʉsa mehna cjʉ̃no yʉhʉre ihña tuhtiyequinare yʉhʉre ihñonota, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Tiquiro sa nigʉ̃ tʉhona Jesure ihñoatiquirore masiedana, ʉsã basi cahme ihñaʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jesu buheyequina mehna cjʉ̃ yʉhʉ, Jesu cahĩdigʉ ijii. Sa yegʉ tiquiro cahapʉ pari paha dujii. ");
INSERT INTO pirNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Sa yero Simo Pedro yʉhʉre tiquiro omoca mehna sinituri: —‍¿Jesure ihñoatiquiro noa pehere nino niajari Jesu? Yahuya ʉsãre, nino, tiquiro omoca mehna sinituri Pedro. ");
INSERT INTO pirNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Tiquiro sa nigʉ̃ yʉhʉ pehe Jesu cahapʉ dujirigʉ sinituu tiquirore: —‍¿Pʉhto, noare nigʉ niajari mʉhʉ? nii yʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","—‍Ahria pãre dahra waha ne, yʉhʉ ña mio yʉhʉ ohoatiquiro pehe tiquirota ijire yʉhʉre ihñoatiquiro, nidi Jesu. Sa ni tuhasa pãre tiquiro dahra waha nedirore ña mio tuhasa tire Simo Iscariote macʉnore Judare ohori. ");
INSERT INTO pirNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Sa yero pãre tiquiro ñehedi bato watĩno pehe Judare ñano ye dutiri jiri. Sa yero Jesu tiquirore ohõ saha nidi: —‍Mʉhʉ yeatore sojaro mehna ye madoqueohya mʉhʉ, nidi Jesu Judare. ");
INSERT INTO pirNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Tiquiro sa nigʉ̃ tʉhona ʉsã mesapʉ dujina, Jesu Judare tiquiro nidire quehnoano masiedʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ihquẽquina ohõ saha ni tʉhotumi: “Juda ʉsã niñerure ihboriquiro ijire. Sa yero bose deco ʉsã ihyatire dú dutiro ohori Jesu Judare. O pejecʉoyequinare niñerure oho dutiro niboaga Jesu”, ni tʉhotumi ʉsã ihquẽquina. ");
INSERT INTO pirNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Sa yero Juda ti pãre ñehe tuhasa, wijiaa wahari. Tiquiro wijiari pje ñami ijiri. ");
INSERT INTO pirNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Tiquiro wijiari bato ohõ saha nidi Jesu: —‍Yojopʉ pũritare yʉhʉ masʉ Cohãcjʉ̃ ohorigʉ yʉhʉ tutuagʉ yʉhʉ ijiye tiyere ihñonota Cohãcjʉ̃ masare. Sa yegʉ Cohãcjʉ̃ tiquiro tutuariquiro ijiyere ihñoutja yʉhʉ pehe. ");
INSERT INTO pirNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Sa yegʉ Cohãcjʉ̃ tiquiro tutuayere yʉhʉ ihñogʉ̃ tiquiro pehe yʉhʉ tutuaye gʉ̃hʉre yojopʉ pũritare ihño madoqueorota. ");
INSERT INTO pirNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Yʉhʉ pohna yʉhʉre tʉhoya. Meheñe decorigã mʉsa mehna ijinigʉtja. Yʉhʉ wahari bato yʉhʉre macanata mʉsa. Sa yegʉ mari acaye judio masare yʉhʉ nidiro sahata mʉsa gʉ̃hʉre niaja. “Yʉhʉ wahatore mʉsa pehe waha masiedare”, tiquinare yʉhʉ nidiro sahata mʉsa gʉ̃hʉre yahuaja. ");
INSERT INTO pirNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Wahma dutirore mʉsare yahugʉtja. Mʉsa mehna cjẽnare cahĩña mʉsa. Mʉsare yʉhʉ cahĩdiro sahata, mʉsa mehna cjẽnare cahĩña. ");
INSERT INTO pirNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Sa yena mʉsa mehna cjẽnare mʉsa cahĩgʉ̃ ihñañe, yeequina mʉsa ijiyere masieta apequina, nidi Jesu ʉsãre. ");
INSERT INTO pirNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Tiquiro sa nigʉ̃ Simo Pedro Jesure sinituri: —‍¿Pʉhto, nohopʉ wahaʉtjari mʉhʉ? nidi Pedro. —‍Yʉhʉ wahatopʉre yojopʉre yʉhʉ mehna waha masiedare mʉhʉ. Yojopʉre waha masiedapegʉta came yʉhʉ cahapʉ wahaʉta mʉhʉ, nidi Jesu Pedrore. ");
INSERT INTO pirNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","—‍¿Pʉhto, dʉhsegʉ yojopʉre mʉhʉ mehna waha masiedaboari yʉhʉ? Yʉhʉre tiquina wejẽ duepegʉ̃ta mʉhʉre ne duhusi yʉhʉ, nidi Pedro Jesure. ");
INSERT INTO pirNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","—‍¿Yʉhʉre ne duhueragʉtari mʉhʉ? Poto mʉhʉre yahutja. Canaca tiquiro yahuato pano “Jesure masiedaja”, niita mʉhʉ apequinare. Ihtia taha sa niita mʉhʉ, nidi Jesu Pedrore. ");
INSERT INTO pirNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Came Jesu ʉsãre ohõ saha ni yahuri: —‍Ne bʉjʉa witi, pajiro wacũedacãhña. Cohãcjʉ̃re wacũ tutuaya. Sa yena yʉhʉ gʉ̃hʉre wacũ tutuaya. ");
INSERT INTO pirNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Yʉhʉ Pacʉ tiquiro ijiropʉre peye wʉhʉse ijire. Mʉsa ijiatore quehnoyugʉ wahagʉtja. Ti ijirota ijire. Sa yegʉ mʉsare tire yahuaja. ");
INSERT INTO pirNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Sa yegʉ mʉsa ijiatore quehno tuhasa, tojoa taʉtja yʉhʉ. Sa yegʉ yʉhʉ cahapʉ mʉsa ijiatire mʉsare negʉ ahtaʉtja yʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Sa yena yʉhʉ wahati mahare masine mʉsa, nidi Jesu ʉsãre tiquiro buhenare. ");
INSERT INTO pirNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","—‍Pʉhto, mʉhʉ wahatore masiedaja ʉsã. ¿Sa yena dʉhse ye mʉhʉ wahati mahare masinatari ʉsã? ni sinituri Tomasu Jesure. ");
INSERT INTO pirNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Tiquiro sa ni sinitugʉ̃ Jesu yʉhtiri: —‍Cohãcjʉ̃ cahapʉ wahagʉ̃ yegʉ ijiita niaja yʉhʉ. Sa yegʉ poto ijiyere yahugʉ ijiita niaja yʉhʉ. Sa yegʉ ʉhmʉsepʉre catiducugʉ̃ yegʉ ijiita niaja yʉhʉ. Sa ye yeequina dihita yʉhʉ Pacʉ cahapʉ wahaeta. ");
INSERT INTO pirNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Yʉhʉre masina, yʉhʉ Pacʉ gʉ̃hʉre masiboya mʉsa. Yojopʉre tiquirore ihñari mʉsa. Sa yena tiquirore masi tuhasare mʉsa, nidi Jesu ʉsãre. ");
INSERT INTO pirNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Tiquiro sa nigʉ̃ Felipe ohõ saha nidi: —‍Pʉhto, mari Pacʉre ihñoña ʉsãre. To punota ihña duaja ʉsã, nidi tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Tiquiro sa nigʉ̃ Jesu yahuri: —‍¿Felipe, yoari pje yʉhʉ mehna ijiepegʉta, mʉhʉ masiedajari yʉhʉre? Yʉhʉre ihñariquiro yʉhʉ Pacʉ gʉ̃hʉre ihña tuhasari. ¿Sa yegʉ “Mari Pacʉre ihñoña ʉsãre”, nigʉ dʉhsegʉ sa niajari mʉhʉ yʉhʉre? ");
INSERT INTO pirNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Yʉhʉ, yʉhʉ Pacʉ mehna pʉana ijiepenata ihcʉ̃ta ijiaja. ¿Tire “Poto ijierare”, niimeje niajari mʉhʉ? Mʉsare yahugʉ yʉhʉ esa tuharo yahugʉ niedaja. Yʉhʉ Pacʉre yahu basagʉ niaja. Sa yero tiquiro yʉhʉ mehna ijiriquiro tiquiro tutuaye mehna ye ihñore. ");
INSERT INTO pirNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Yʉhʉ, yʉhʉ Pacʉ mehna pʉana ijiepenata ihcʉ̃ta ijiaja. Tire “Ijirota ijire”, ni wacũña mʉsa. Tire “Ijirota ijire”, niedana, Cohãcjʉ̃ tutuaye mehna yʉhʉ ye ihñorire wacũna, yʉhʉ Pacʉ mehna yʉhʉ ihcʉ̃ta ijiyere “Ijirota ijire”, ni wacũña mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ijirota mʉsare niaja. Yʉhʉre wacũ tutuariquiro yʉhʉ yeriro sahata yerota. Sa yero tiquiro pehe yʉhʉ yʉhdʉoro yerota. Yʉhʉ Pacʉ cahapʉ tojoa wahaʉ tʉʉ niaja yojopʉre. Sa yero yʉhʉre wacũ tutuariquiro yʉhʉ yʉhdʉoro Cohãcjʉ̃ tutuaye mehna ye ihñonota. ");
INSERT INTO pirNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Sa yegʉ yʉhʉre wacũ tutuayequina tiquina sinino punota yeitja. Sa yegʉ yʉhʉ Pacʉ tiquiro tutuariquiro ijiyere ihñoutja. ");
INSERT INTO pirNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Yʉhʉre wacũ tutuana mʉsa ijigʉ̃ mʉsa sinino punota yeitja, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Sa ni tuhasa ohõ saha ni nemori: —‍Yʉhʉre mʉsa cahĩna, yʉhʉ dutiyere quehnoano ye pehonata. ");
INSERT INTO pirNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Yʉhʉ Pacʉre siniitja. Yʉhʉ sa sinigʉ̃ yʉhʉ Pacʉ pehe apequirore mʉsare yedohoatiquirore mʉsare ohorota. Sa yero tiquiro mʉsare yedohoatiquiro pehe ijipihtiye decori mʉsa mehna ijirota. ");
INSERT INTO pirNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Tiquiro poto yahuriquiro Espíritu Santota ijire. Ahri yehpa cjẽna pehe Espíritu Santore masiedare. Sa ye tiquirore cʉo masiedare. Tiquirota mʉsa mehna ijirota. Sa yena mʉsa pehe tiquirore cʉonata. Sa yena tiquirore masine mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mʉsare cohãsi yʉhʉ. Mʉsa mehna ijigʉ tagʉ, tojoa taʉtja yʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Sa ijiepegʉ̃ta mehenogã dʉhsare yʉhʉ wahato. Yʉhʉ wahari bato ahri yehpa cjẽna yʉhʉre wacũ tutueyequina yʉhʉre pari turi ihñasi. Mʉsa pehe yʉhʉre ihñanata. Yʉhʉ catigʉ ijigʉ̃ mʉsa gʉ̃hʉ ijipihtiye decori Cohãcjʉ̃ mehna catinata. ");
INSERT INTO pirNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ti deco yʉhʉ tojoa tati deco yʉhʉ Pacʉ mehna ihcʉ̃ta ʉsã ijigʉ̃ masinata mʉsa. Sa yegʉ yʉhʉ mehna cjãna mʉsa ijigʉ̃ mʉsa mehna cjʉ̃ yʉhʉ ijigʉ̃ gʉ̃hʉre masinata mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Yʉhʉ dutiyere yeriquiro yʉhʉre cahĩniquirota ijire. Sa yero yʉhʉre cahĩniquirore yʉhʉ Pacʉ pehe cahĩnota. Sa yegʉ yʉhʉ gʉ̃hʉ tiquirore cahĩitja. Sa ye yʉhʉre quehnoano masigʉ̃ yeitja tiquirore, nidi Jesu ʉsãre tiquiro buhenare. ");
INSERT INTO pirNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ʉsã mehna cjʉ̃no apequiro Juda wame tiriquiro ijiri. Juda Iscariote Jesure ihña tuhtiyequinare ihñoatiquiro ijierari tiquiro. Apequiro Juda ijiri. Sa yero tiquiro Jesure sinituri: —‍¿Pʉhto, dʉhse yeitjari mʉhʉ ʉsãre sa nigʉ? ¿Ahri yehpa cjẽnare mʉhʉre masigʉ̃ yeragʉ, yabere yeitari mʉhʉ ʉsã dihitare mʉhʉre masigʉ̃ yegʉ? ni sinituri Juda. ");
INSERT INTO pirNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Tiquiro sa nigʉ̃ tʉhoro Jesu tiquirore yahuri: —‍Yʉhʉre cahĩñequina, yʉhʉ dutiyere quehnoano yeye nine. Tiquina sa yegʉ̃ yʉhʉ Pacʉ pehe tiquinare cahĩnota. Sa yena tiquina mehna ijina ahtanatja ʉsã. ");
INSERT INTO pirNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Yʉhʉre cahĩeniquiro yʉhʉ dutiyere yerare. Sa ye yʉhʉ yahuye mʉsa tʉhori pehe yee yahuye ijierare. Yʉhʉre ohoriquiro ye yahuye pehe ijire. Tiquiro yʉhʉ Pacʉta ijire. ");
INSERT INTO pirNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Mʉsa mehna ijinigʉ ahrire mʉsare yahugʉ niaja. ");
INSERT INTO pirNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Came yʉhʉ sinigʉ̃ yʉhʉ Pacʉ Espíritu Santore ohorota mʉsare. Sa yero Espíritu Santo pehe mʉsare yedohoatiquiro ijiro, mʉsare buhe pehorota tiquiro. Sa yero mʉsare yʉhʉ yahurire mʉsare wacũgʉ̃ yerota tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Mʉsare quehnoano ijigʉ̃ yeitja yʉhʉ. Yʉhʉ quehnoano ijiriro sahata quehnoano ijigʉ̃ yeitja yʉhʉ mʉsare. Ahri yehpa cjẽna tiquina ni mehoriro sahata yesi yʉhʉ mʉsare. Yʉhʉ pũrita potota quehnoano ijigʉ̃ yeitja mʉsare. Bʉjʉa witi pajiro wacũedacãhña mʉsa. Sa yena cueracãhña mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Yʉhʉ wahaʉtja. Sa yegʉ mʉsa mehna ijigʉ tagʉ tojoa taʉtja”, mʉsare yʉhʉ sa ni yahugʉ̃ tʉho tuhasari mʉsa. Tire tʉhona, bucueboaya mʉsa. Yʉhʉre mʉsa poto cahĩna, bucueboaya mʉsa. Yʉhʉ Pacʉ pehe yʉhʉ yʉhdʉoro tutuare. Sa yena tiquiro cahapʉ yʉhʉ wahatore mʉsa masidi bato yʉhʉre cahĩna, bucueboaya mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Mʉsa yʉhʉre wacũ tutuatire yʉhʉ wahatore yahuyugʉ niaja mʉsare. ");
INSERT INTO pirNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Ahri yehpa cjẽna pʉhtoro watĩno pʉhtoro ijiro taro nine yojopʉre. Tiquiro sa ijiro tagʉ̃ yʉhʉ mʉsa mehna yʉhʉ yahuducu bato tiati pje mehenogã dʉhsare. Tiquiro pehe yʉhʉre yʉhdʉdʉca masiedare. ");
INSERT INTO pirNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Sa yegʉ yʉhʉre yʉhʉ Pacʉ tiquiro dutiriro sahata yeaja yʉhʉ. Sata yeaja yʉhʉ, yʉhʉ Pacʉre yʉhʉ cahĩñene ahri yehpa cjẽna tiquina masiatire. Wahcãdʉcaya. Isa wahana, nidi Jesu ʉsãre tiquiro buhenare. ");
INSERT INTO pirNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Came queoye mehna buhero ʉsãre ohõ saha nidi Jesu: —‍Yʉhʉ potota ʉhse da yero saha ijigʉ ijiaja. Yʉhʉ Pacʉ pehe ʉhse dare ihña ihboriquiro yero saha ijire. ");
INSERT INTO pirNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Yeequina ʉhse da dʉpʉri yero saha ijiyequina yʉhʉ mehna cjẽnata ijire. Ʉhse da dʉpʉri dʉca marieñe dʉpʉrire ihña ihboriquiro tiquiro pehe cohãriro saha yʉhʉ Pacʉ tiquiro cahmeñene yerariquinare cohãre. Dʉca tiye dʉpʉrire ihña ihboriquiro tiquiro quehnoriro saha yʉhʉ Pacʉ tiquiro cahmeñene yeyequinare yedohorota tiquiro, “Yʉhʉ cahmeñene ye nemoahdo”, nino. ");
INSERT INTO pirNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Yeere tʉhona, “Ijirota ijire”, nidi mʉsa. Sa yero yʉhʉ Pacʉ mʉsa ñañe yerire cohã tuhasari. ");
INSERT INTO pirNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Yʉhʉ mehna cjãna ijiya mʉsa. Sa yegʉ mʉsa mehna ijiitja. Ʉhse da dʉpʉri ʉhse da mehna wahñaedaye dʉpʉri ijiye, ti dʉpʉri pehe dʉca mariedare. Sata yʉhʉ mehna cjãna ijierana, yʉhʉ Pacʉ cahmeñene ye masiedare mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Yʉhʉ ʉhse da yero saha ijigʉ ijiaja. Mʉsa pehe ti da dʉpʉri yero saha ijina ijire. Yʉhʉ mehna cjʉ̃no mehna yʉhʉ ijigʉ̃ dʉca tiye dʉpʉri yero saha tiquiro yʉhʉ Pacʉ cahmeñene yere. Yʉhʉ mehna cjãna ijierana yʉhʉ Pacʉ cahmeñene ye masiedare mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ñañe dʉpʉrire tiquiro cohãboriro saha yʉhʉ mehna cjẽna ijieyequinare yʉhʉ Pacʉ cohãnota. Ti dʉpʉri ñai dijiaa wahagʉ̃ ʉhse dare ihña ihboriquiro ti dʉpʉrire ne cahmecoa pecapʉ ʉjʉ̃a cohãnota. Sata yerota Cohãcjʉ̃ yʉhʉ mehna cjẽna ijieyequinare. ");
INSERT INTO pirNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Yʉhʉ mehna cjãna ijina, yʉhʉ buheyere boeraboaga mʉsa. Sa boerana, mʉsa cahmeno punota siniña. Sa yegʉ mʉsa sinino punota ye basaʉtja. ");
INSERT INTO pirNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Yʉhʉ Pacʉ cahmeñene yena mʉsa ijigʉ̃ ihñañe “Jesu yequina ijire ahriquina”, ni masieta masa. Sa ye mʉsare ihñañe yʉhʉ Pacʉre ño peoeta. ");
INSERT INTO pirNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Yʉhʉ Pacʉ yʉhʉre tiquiro cahĩdiro sahata mʉsare yʉhʉ gʉ̃hʉ cahĩe tii. Yʉhʉ cahĩna ijiducuya mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Yʉhʉ cahĩñequina ijiducuyequina yʉhʉ dutiyere yere. Yʉhʉ Pacʉ ye dutiyere yeaja yʉhʉ. Sa yegʉ tiquiro cahñogʉ ijiducuaja yʉhʉ. Sata mʉsa gʉ̃hʉ yʉhʉ dutiyere yena yʉhʉ cahĩna ijiducunata mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Ahrire mʉsare yahuu yʉhʉ mehna mʉsa quehnoano bucueatire. Sa yena tutuaro bucuenata mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ohõ saha dutiaja mʉsare: Mʉsare yʉhʉ cahĩdiro sahata mʉsa mehna cjẽna gʉ̃hʉre cahĩña. ");
INSERT INTO pirNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ihcãquiro masʉno tiquiro mehna cjʉ̃no ye buhiri yariaro tiquiro mehna cjʉ̃nore tutuaro cahĩne, apequina tiquina cahĩdiro yʉhdʉoro. ");
INSERT INTO pirNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Sa yena yʉhʉ dutiyere yena yʉhʉ mehna cjãna ijire mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Potota yʉhʉ mehna cjãna waro ijire mʉsa. Mʉsa sa ijigʉ̃ ijipihtiye yʉhʉ yerire yahuaja mʉsare. Cahacjʉ̃no tiquiro pʉhtoro yerire masiedare tiquiro. Sa yegʉ “Yʉhʉ cahacjãna ihyo ijina ijire mʉsa”, mʉsare niedaja. Yʉhʉ Pacʉ yʉhʉre tiquiro yahurire mʉsare yahu pehou. Sa yahugʉ “Yʉhʉ mehna cjãna ijire mʉsa”, mʉsare niaja yojopʉre. ");
INSERT INTO pirNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Mʉsa pehe yʉhʉre ne beserari. Yʉhʉ pehe mʉsare besei yʉhʉ Pacʉ cahmeñene mʉsa yeatire. Mʉsa sa yegʉ̃ mʉsa yeye ne ihyo waro ijisi. Ahri deco yoaro punota sa ijiducuati ijire mʉsa yeye. Mʉsa sa yegʉ̃ yʉhʉre mʉsa wacũ tutuagʉ̃ yʉhʉ Pacʉre mʉsa sinino punota tiquiro mʉsare ohorota. ");
INSERT INTO pirNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ahrire mʉsare dutiaja yʉhʉ: Mʉsa mehna cjẽnare cahĩña mʉsa, ni yahuri Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Sa yero tiquiro yahu nemori: —‍Ahri yehpa cjẽna mʉsare tiquina ihña tuhtigʉ̃ ihñana ahrire wacũña mʉsa: Mʉsare tiquina ihña tuhtiato pano yʉhʉ pehere ihña tuhti mʉhtari tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Cohãcjʉ̃re cahmedana mʉsa ijigʉ̃, ahri yehpa cjẽna tiquina cahme cahĩdiro sahata mʉsa gʉ̃hʉre cahĩboaya tiquina. Ahri yehpa cjãna mʉsa ijigʉ̃ mʉsare besei. Sa yena yojopʉre ahri yehpa cjãna waro ijierare mʉsa. Mʉsa sa ijieragʉ̃ ihñañe ahri yehpa cjẽna mʉsare ihña tuhtire. ");
INSERT INTO pirNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","“Yeequina ijina mʉsa yʉhʉ bui ijierare”, mʉsare yʉhʉ nidire wacũña mʉsa. Sa yena yʉhʉ docapʉ ijina yʉhʉ ñano yʉhdʉriro sahata ñano yʉhdʉnata mʉsa gʉ̃hʉ. Yʉhʉre ñano yeriquinata mʉsa gʉ̃hʉre ñano yeeta. Yʉhʉ buhegʉ̃ yʉhtiriquinata mʉsa buhegʉ̃ gʉ̃hʉre yʉhtieta tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ahri yehpa cjẽna yʉhʉre ohoriquirore masiedare. Sa ye yʉhʉre wacũ tutuana mʉsa ijigʉ̃ ihñañe tiquina ñano yeeta mʉsare. ");
INSERT INTO pirNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Tiquinare yʉhʉ buhegʉ ahtaeragʉ̃ yʉhʉre tiquina cahmedari buhiri, buhiri mariedaboaya. Yojopʉre tiquinare yʉhʉ buheri bato “Ñañe buhiri mariedare ʉsãre”, ni masiedare tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Yʉhʉre ihña tuhtiriquiro yʉhʉ Pacʉ gʉ̃hʉre ihña tuhtire. ");
INSERT INTO pirNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Cohãcjʉ̃ tiquiro tutuaye mehna apequina tiquina ne yerarire ye ihñou. Sa ye tiquinare tire yʉhʉ ye ihñoedagʉ̃ tiquinare ñañe buhiri mariedaboaya. Cohãcjʉ̃ tutuaye mehna yʉhʉ ye ihñorire tiquina ihñari bato yʉhʉre yʉhʉ Pacʉ gʉ̃hʉre ihña tuhtire tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Sa ihña tuhtiye Cohãcjʉ̃ yere tiquina ojoari pũpʉ duitapʉta tiquiro ni ojoariro sahata yeye nidi tiquina. Ohõ saha ni ojoahye: “Tiquinare yʉhʉ ñano yerapegʉ̃ta yʉhʉre ihña tuhtire tiquina”, ni ojoahye duitapʉta Cohãcjʉ̃ yere tiquina ojoari pũpʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Yʉhʉ batopʉ mʉsare yedohoatiquiro, yʉhʉ Pacʉ mehna ijiriquiro mʉsare yʉhʉ ohoatiquiro Espíritu Santota ijire. Tiquiro potota yahuriquiro ijire. Sa yero tiquiro ahtaro, yʉhʉ ijiye tiyere yahurota mʉsare. ");
INSERT INTO pirNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Masare yʉhʉ buhe dʉcagʉ̃pʉta mʉsa gʉ̃hʉ decoripe yʉhʉ mehna ijiducuri. Sa yena mʉsa gʉ̃hʉ yʉhʉ ijiye tiyere yahunata apequinare, ni yahuri Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Sa ni tuhasa ʉsãre ohõ saha ni yahu nemori: —‍Came yʉhʉ buheyere yʉhʉ gʉ̃hʉre mʉsa cohãedatire ahrire ijipihtiyere yahuu mʉsare. ");
INSERT INTO pirNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Judio masa mari buheye wʉhʉsepʉ mʉsa sajã duagʉ̃ mʉsare sajã dutisi yeequina mʉsa ijiri buhiri. Sa ye ape tahapʉ mʉsare wejẽ, “Cohãcjʉ̃ cahmeñene yena niaja”, ni tʉhotuetamaga apequina. ");
INSERT INTO pirNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Sa ye yʉhʉ Pacʉre, yʉhʉ gʉ̃hʉre tiquina masiedare. Sa masiedaye mʉsare ñano yeeta tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Sa yena mʉsare ñano tiquina yegʉ̃ ihñana “Tiquina ohõ saha yeato panota Jesu yahu tuhasari ʉsãre”, ni wacũnata mʉsa. Mʉsa sa ni wacũatire yojopʉre ahrire yahu mʉhtagʉ niaja mʉsare, ni yahuri Jesu. Sa ni tuhasa ohõ saha ni yahu nemori: —‍Coã waropʉre mʉsa mehna ijigʉ ahrire mʉsare yahuerʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Yojopʉ pehere yʉhʉre ohoriquiro cahapʉ wahaʉtja. “¿Nohopʉ wahaʉtjari mʉhʉ?” yʉhʉre ni, ihcãquiro borota ne sinituerari mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Sa sinituerapenata yʉhʉ wahatire mʉsare yʉhʉ yahu mʉjagʉ̃ mʉsa ñano jeripohna tire. ");
INSERT INTO pirNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Mʉsare ijirota yahugʉta niaja. Yʉhʉ wahari bato mʉsare quehnoanota. Yʉhʉ ʉhmʉsepʉ wahaeragʉ̃ mʉsare yedohoatiquiro pehe ahtaeraboaya. Wahagʉ mʉsare tiquirore oho dijioutja yʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Yʉhʉ sa oho dijiogʉ̃ tiquiro ahtarota. Sa wihiro ahri yehpa cjẽna ñañe yeyequina tiquina ijiyere tiquinare masigʉ̃ yerota tiquiro. Sa yero quehnoano ijiye tiye gʉ̃hʉre buherota tiquiro masare. Sa yero Cohãcjʉ̃ masare tiquiro buhiri dahreato gʉ̃hʉre yahurota masare yedohoatiquiro pehe. ");
INSERT INTO pirNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Yʉhʉre wacũ tutueyequina ijire ahri yehpa cjẽna. Sa yero yedohoatiquiro pehe masa ñañe yeyequina tiquina ijiye tiyere tiquinare masigʉ̃ yerota. ");
INSERT INTO pirNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Yʉhʉ Pacʉ cahapʉ wahaʉtja. Yʉhʉ sa wahari bato masa yʉhʉre ihñasi. Sa yero quehnoano ijiye tiye gʉ̃hʉre buherota yedohoatiquiro pehe. ");
INSERT INTO pirNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ahri yehpa cjẽna pʉhtorore watĩnore Cohãcjʉ̃ buhiri dahre duti tuhasari. Sa yero Cohãcjʉ̃ masare tiquiro buhiri dahreati gʉ̃hʉre yahurota yedohoatiquiro pehe. ");
INSERT INTO pirNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Pajiro ijire mʉsare yʉhʉ yahuati. Yʉhʉ sa yahu nemo duepegʉ̃ta tire yʉhʉ yahugʉ̃ yojopʉ masinisi mʉsa. Sa yena yojopʉre quehnoano tʉhosi mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Yʉhʉ sa yahu nemoedagʉ̃ Espíritu Santo pehe mʉsare yahu nemono ahtarota. Tiquiro esa tuharo mʉsare yahusi. Tiquirore yʉhʉ Pacʉ yahu dutirire tiquiro yahurota mʉsare. Sa yero mʉsare poto yahu pehorota. Sa yero “Camepʉ ohõ saha waharota”, ni yahurota tiquiro mʉsare. ");
INSERT INTO pirNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Sa yero yeere mʉsare tiquiro yahurota. Sa yahuro yʉhʉre ño peogʉ̃ yerota masare. ");
INSERT INTO pirNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ijipihtiye yʉhʉ Pacʉ ye, yee gʉ̃hʉ ijire. Sa yegʉ “Espíritu Santo pehe yeere yahurota mʉsare”, nii mʉsare, ni yahuri Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Sa ni tuhasa ohõ saha ni yahu nemori: —‍Mehenogã bato mʉsa yʉhʉre ihñasi. Sa yena mehenogã bato mʉsa yʉhʉre ihñanata tja, nidi Jesu ʉsãre tiquiro buhenare. ");
INSERT INTO pirNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Tiquiro sa nigʉ̃ tʉhona, ʉsã pehe meheñequinagã ohõ saha ni yahuducuu ʉsã basi: —‍¿“Mehenogã bato mʉsa yʉhʉre ihñasi. Sa yena mehenogã bato mʉsa yʉhʉre ihñanata tja”, nino dʉhse nino sa niajari marine? ¿Sa yero “Yʉhʉ Pacʉ cahapʉ wahaʉtja”, nino dʉhse ijiro boro marine sa niagari tiquiro? ");
INSERT INTO pirNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿“Mehenogã bato”, nino dʉhse nino sa niajari ahriquiro? Tiquiro ni yahurire quehnoano masiedaja mari, ni yahuducuu ʉsã basi. ");
INSERT INTO pirNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ʉsã sa ni yahuducugʉ̃ Jesu tiquirore ʉsã sinitu duarire masino, ʉsãre yahuri: —‍¿“Mehenogã bato mʉsa yʉhʉre ihñasi. Sa yena mehenogã bato yʉhʉre ihñanata tja”, yʉhʉ nidire sinitu duajari mʉsa? ¿Tire yʉhʉ nidire masiedajari mʉsa? ");
INSERT INTO pirNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ijirota mʉsare nigʉ niaja. Yʉhʉ yariagʉ̃ ihñana mʉsa utinata. Sa yena tutuaro bʉjʉa witinata. Sa ye yʉhʉre ño peoeyequina pehe bucueeta. Mʉsa pehe bʉjʉa witina ijiepenata, came bucuenata mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ohõ saha ijire ti: Numino niji wahcõno, ticoro ñano yʉhdʉato pano ijire. Sa yero ticoro tutuaro bʉjʉa witire. Sa bʉjʉa witieperota ticoro pohna tiri bato ticorore purĩdire wacũedare ticoro. Nijinogã ahri yehpapʉ tiquiro masa bajuagʉ̃ ticoro bucuere. Sa yero ticorore purĩdire wacũedare. ");
INSERT INTO pirNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Sata mʉsa yojopʉre bʉjʉa witinata. Came mʉsare ihñaʉtja. Sa yena mʉsa tutuaro bucuenata. Mʉsa sa bucuegʉ̃ apequina mʉsare bʉjʉa witigʉ̃ ye masisi. ");
INSERT INTO pirNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Ti deco mʉsa yʉhʉre ihñari deco yʉhʉre sinitusi mʉsa. Masi tuhasarinapʉ ijinata. Ijirota mʉsare nigʉ niaja. Yʉhʉre mʉsa wacũ tutuagʉ̃ ihñano yʉhʉ Pacʉre mʉsa siniñene tiquiro mʉsare ohorota. ");
INSERT INTO pirNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ahri deco pano yʉhʉ tutuaye mehna Cohãcjʉ̃re siniedarĩdi mʉsa. Yʉhʉre wacũ tutuatjiãna Cohãcjʉ̃re siniña. Mʉsa sa sinigʉ̃ mʉsa sinidire mʉsare ohorota, mʉsa quehnoano bucueatire, nidi Jesu ʉsãre. ");
INSERT INTO pirNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Sa ni tuhasa ohõ saha ni nemori: —‍Queoye mehna mʉsare yahue tii. Sa yahuepegʉta came mʉsare queoye mehna yahusi yʉhʉ. Sa yahueragʉ yʉhʉ Pacʉ pehere quehnoano poto yahutja mʉsare. ");
INSERT INTO pirNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ti decore mʉsare yʉhʉ Pacʉre sini basasi yʉhʉ. Yʉhʉre wacũ tutuana, mʉsa basi tiquirore sininata. ");
INSERT INTO pirNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Mʉsa yʉhʉre cahĩne. Sa yena yʉhʉ Pacʉ cahapʉ yʉhʉ ahtarigʉ ijigʉ̃ “Ijirota ijire”, nine mʉsa. Sa nina mʉsa ijigʉ̃ ihñano yʉhʉre cahĩna mʉsa ijigʉ̃ ihñano yʉhʉ Pacʉ pehe mʉsare cahĩne. Tiquiro sa cahĩgʉ̃ tiquirore mʉsa sininata. ");
INSERT INTO pirNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Yʉhʉ Pacʉ cahapʉ ijirigʉ ahri yehpapʉre ahtaʉ yʉhʉ. Sa yegʉ yojopʉre ahri yehpapʉ ijirigʉ yʉhʉ Pacʉ cahapʉ wahaʉtja, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Tiquiro sa nigʉ̃ ʉsã tiquiro buhena ohõ saha nii: —‍Yojopʉ pũrita queoye marieno yahuducugʉ quehnoano bajuro yahugʉ nine mʉhʉ ʉsãre. ");
INSERT INTO pirNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Mʉhʉ quehnoano masi pehogʉ mʉhʉ ijigʉ̃ yojopʉ pũritare ʉsã masiaja. Sa ye apequina mʉhʉre buhe masiedare. Tire yojopʉre ʉsã quehnoano masiaja. Ʉsã quehnoano masina, Cohãcjʉ̃ cahapʉ ahtarigʉ mʉhʉ ijigʉ̃ “Ijirota ijire”, niaja ʉsã, nii ʉsã Jesure. ");
INSERT INTO pirNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ʉsã sa nigʉ̃ Jesu yʉhtiri ʉsãre: —‍¿Yojopʉre “Ijirota ijire”, niajari mʉsa? ");
INSERT INTO pirNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Came cjũno ijipihtina mʉsa wʉhʉsepʉ waha sitena, yʉhʉre cohãnata mʉsa. Mʉsa sa cohãepegʉ̃ta yʉhʉ Pacʉ pehe yʉhʉ mehna ijire. Sa yegʉ yʉhʉ ihcʉ̃ta ijieraja. ");
INSERT INTO pirNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ahrire mʉsare yahu mʉhtaʉ, yʉhʉre mʉsa wacũ tutuaye mehna mʉsa quehnoano ijiatore. Cohãcjʉ̃re cahmeeñequina cahapʉ mʉsa ijigʉ̃ ñano yeeta mʉsare tiquina. Tiquina sa yepegʉ̃ta bucueya mʉsa. Ahri yehpa cjẽna tiquina ñañe yerire yʉhdʉdʉcagʉ ijiaja yʉhʉ. Sa yena yʉhʉre wacũ tutuana bucueya mʉsa, nidi Jesu ʉsãre tiquiro buhenare. ");
INSERT INTO pirNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Sa ni yahu tuhasa Jesu ʉhmʉanopʉ ihña mʉo, Cohãcjʉ̃re ohõ saha ni yahuducuri: —‍Mai, yojopʉre mʉhʉ yahu queoriro sahata yʉhʉre ñano tiquina yeati pje esarota nine. Yʉhʉre mʉhʉ macʉre masare ño peogʉ̃ yeya. Mʉhʉ sa yegʉ̃ mʉhʉre masare ño peogʉ̃ yeitja yʉhʉ gʉ̃hʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ijipihtiyequina pʉhto yʉhʉre cũri mʉhʉ. Sa yegʉ yʉhʉre mʉhʉ ohoriquinare mʉhʉ mehna sa ijiducugʉ̃ yeitja yʉhʉ. Sa yegʉ mʉhʉre masare ño peogʉ̃ yeitja yʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Mʉhʉ dihita Cohãcjʉ̃ waro ijire. Yʉhʉ Jesucristo mʉhʉ ohorigʉ ijiaja. Sa ye ijipihtiyequina mʉhʉre masiñequina, yʉhʉ gʉ̃hʉre masiñequina ʉhmʉsepʉ mari mehna sa ijiducueta, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Sa ninota ohõ saha ni nemori mari Pacʉre: —‍Ahri yehpapʉre mʉhʉ ye dutirire ye peho tuhasaʉ yʉhʉ. Sa yegʉ mʉhʉre masare ño peogʉ̃ yei yʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ahri yehpa ijiato pano mʉhʉ mehna yʉhʉ ijigʉ̃ ijipihtiyequina yʉhʉre tiquina ño peo mʉhtariro sahata yojopʉre yʉhʉre tiquina ño peogʉ̃ yeya tja. ");
INSERT INTO pirNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Ahri yehpapʉ ijiyequinare yʉhʉre mʉhʉ ohoriquinare mʉhʉre masigʉ̃ yei. Mʉhʉ ohoriquina mʉhʉ yequina ijire. Sa yegʉ tiquinare ohori mʉhʉ yʉhʉre. Sa ye mʉhʉ dutiyere yeri tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","8","Yʉhʉre mʉhʉ yahurire tiquinare buhei. Yʉhʉ sa buhegʉ̃ tʉhoye yʉhʉ buheyere cahmedi tiquina. Sa ye potota mʉhʉ cahapʉ ahtarigʉ yʉhʉ ijigʉ̃ masine tiquina. Sa ye mʉhʉ ohorigʉ yʉhʉ ijigʉ̃ “Ijirota ijire”, ni tʉhoture tiquina. Sa ye ijipihtiye yee mʉhʉ ye ti ijigʉ̃ masine tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Tiquinare mʉhʉre sini basagʉ niaja. Apequina pehere sini basagʉ niedaja yʉhʉ. Yʉhʉre mʉhʉ ohoriquina mʉhʉ yequina ijire. Sa yegʉ tiquinare sini basagʉ niaja mʉhʉre. ");
INSERT INTO pirNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Tiquina ijipihtiyequina mʉhʉ yequina ijire. Sa ye mʉhʉ yequina pehe yeequina ijire. Yʉhʉre wacũ tutuaye yʉhʉ tutuagʉ ijiyere masigʉ̃ yere tiquina masare. ");
INSERT INTO pirNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Yojopʉre ahri yehpapʉre tojoasi yʉhʉ. Mʉhʉ cahapʉ wahaʉ tʉʉ niaja. Yʉhʉ sa wahaepegʉ̃ta yojopʉre yʉhʉre mʉhʉ ohoriquina ahri yehpare tojoare. Mai, mʉhʉ quehnoagʉ ijire. Yʉhʉre mʉhʉ ohoriquinare mʉhʉ tutuaye mehna ihña ihbo basaya. Mʉhʉ sa ihña ihbogʉ̃ mari ihcʉ̃ta mari ijiro saha tiquina gʉ̃hʉ ihcã curuata ijiahro. ");
INSERT INTO pirNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Tiquina mehna ijigʉ mʉhʉ tutuaye mehna tiquinare quehnoano ihña ihbou. Ihcãquiro pũrita pecapʉ waharota mʉhʉ yere tiquina ojoari pũpʉ yahuriro sahata. ");
INSERT INTO pirNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Yojopʉre mʉhʉ cahapʉ wahaʉ tʉʉ niaja. Sa yegʉ ahri yehpapʉ ahri ijipihtiyere yeequinare yahuaja yʉhʉ mehna tiquina quehnoano bucueatire. ");
INSERT INTO pirNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mʉhʉ yere yahuu tiquinare. Tiquina gʉ̃hʉ yʉhʉ yero sahata ahri yehpapʉ iji dojoatiquina ijierare. Sa ye ahri yehpa cjẽna pehe tiquinare ihña tuhtire. ");
INSERT INTO pirNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","“Ahri yehpapʉ ijiyequinare, yeequinare neahña”, niedaja. Yʉhʉ sa niedapegʉ̃ta tiquinare quehnoano ihña ihboya. “Watĩno ñañene tiquinare ye dutiari”, nigʉ, quehnoano ihña ihboya tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ahri yehpa cjʉ̃ ijieraja. Tiquina gʉ̃hʉ yʉhʉ yero sahata ahri yehpapʉ iji dojoatiquina ijierare. ");
INSERT INTO pirNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Yeequinare mʉhʉ buheye mehna quehnoañequina yeya tiquinare. Mʉhʉ yahuye pehe ijirota ijire. ");
INSERT INTO pirNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ahri yehpapʉre yʉhʉre mʉhʉ ohoriro sahata yʉhʉ pehe yeequina gʉ̃hʉre mʉhʉ yere buhe dutigʉ ohou. ");
INSERT INTO pirNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Mʉhʉ cahmeñene yegʉ tagʉ yariacjʉ ijigʉ yʉhʉ pagʉre ohoaja. Sa yeaja yʉhʉ, yeequina gʉ̃hʉ mʉhʉ cahmeñene poto tiquina quehnoano yeatire. ");
INSERT INTO pirNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","21","’ “Yeequina yojopʉre ijiyequina dihitare yedohoya”, ni sini basaeraja yʉhʉ. Yeequina apequina gʉ̃hʉre yeere tiquina buheri bato tiquina gʉ̃hʉ yʉhʉre wacũ tutuaeta. Tiquina gʉ̃hʉre yedohoya, yeequina ijipihtiyequina ihcã curua tiquina ijiro quehnoano. Yʉhʉ mʉhʉ mehna mari pʉana ijiepenata ihcʉ̃ta ijiaja. Ihcʉ̃ta mari ijiro sahata tiquina gʉ̃hʉ mari mehna ihcã curuata ijiahro. Ihcã curuata ijiahro, mʉhʉ ohorigʉ yʉhʉ ijiyere ijipihtiyequina masa “Ijirota ijire”, tiquina niatire. ");
INSERT INTO pirNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Yʉhʉre mʉhʉ tutuaye ohorire yeequinare ohou. Ti tutuayere cʉoye, ihcʉ̃ta mari ijiro sahata tiquina gʉ̃hʉ ihcã curuata ijieta. ");
INSERT INTO pirNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Yʉhʉ tiquina mehna ijiaja. Sa yegʉ mʉhʉ yʉhʉ mehna ijire. Mari sa ijigʉ̃ yeequina potota ihcã curuata quehnoano ijieta. Ihcã curuata tiquina ijigʉ̃ ihñañe mʉhʉ ohorigʉ yʉhʉ ijiyere ahri yehpa cjẽna masieta. Sa ye yʉhʉre mʉhʉ cahĩdiro sahata yeequina gʉ̃hʉre mʉhʉ cahĩñene masieta masa. ");
INSERT INTO pirNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Mai, ahri yehpa iji dʉcato pano yʉhʉre cahĩe tiri mʉhʉ. Sa cahĩgʉ yʉhʉ tutuagʉ ijiyere ihñori mʉhʉ. Sa yegʉ yʉhʉre mʉhʉ ohoriquinare yʉhʉ mehna tiquina ijigʉ̃ cahmeaja, yʉhʉ tutuagʉ ijiyere tiquina masiatire. ");
INSERT INTO pirNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Mai, mʉhʉ quehnoagʉ ijire. Ahri yehpa cjẽna ñañequina mʉhʉre masiedare. Yʉhʉ pehe mʉhʉre masiaja. Sa ye mʉhʉ ohorigʉ yʉhʉ ijigʉ̃ masine yeequina. ");
INSERT INTO pirNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Tiquinare mʉhʉre masigʉ̃ yei. Came gʉ̃hʉre mʉhʉre tiquinare masigʉ̃ yeitja, yʉhʉre mʉhʉ cahĩdiro sahata apequinare tiquina cahĩatire. Sa yegʉ yeequina mehna ijigʉtja, nidi Jesu mari Pacʉre. ");
INSERT INTO pirNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Tiquiro sa nidi bato Jesu, ʉsã gʉ̃hʉ tiquiro buhena Cedrõ wame tiri mare pehã, olivo wame tiye cjʉ wesepʉ esaʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Peye tahari ti wesepʉ Jesu mehna cahmecoae tii. Sa yero Juda Jesure ihña tuhtiyequinare ihñoatiquiro ti wesere masidi. ");
INSERT INTO pirNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Sa masino pʉa curua surarare ʉhmʉ tã cãhtari ti wesepʉ Jesure ihñono taro. Ihcã curua surara waro ijiri. Ape curua surara Cohãcjʉ̃ wʉhʉre cohteyequina ijiri. Tiquina pahia pʉhtoa, fariseo masa tiquina ohoriquina ijiri surara, Cohãcjʉ̃ wʉhʉre cohteyequina mehna. Sa ahtaye sihãñe pacare, sihãñe cjʉ gʉ̃hʉre sihã cãhtari. Tiquina wamoa gʉ̃hʉre ne cãhtari tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ti wesepʉ tiquina wihiri bato Jesu tiquiro ñano yʉhdʉatire masino, tiquinare piti ca, sinituri: —‍¿Noare macana niajari mʉsa? nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","—‍Jesu Nazare cjʉ̃nore macaja ʉsã, ni yʉhtiri tiquina. —‍Tiquiro tjiaja yʉhʉ, nidi Jesu. Juda pehe Jesure ñehe dutiro ihñoriquiro tiquina mehna ijiri. ");
INSERT INTO pirNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Sa ye “Tiquiro tjiaja yʉhʉ”, Jesu nigʉ̃ta tiquina pehe tʉho maria waha, du siti maa, yehpapʉ bora quehe sari. ");
INSERT INTO pirNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Tiquina sa wahagʉ̃ ihñano pari turi sinituri tiquinare Jesu: —‍¿Noare macana niajari mʉsa? nidi. —‍Jesu Nazare cjʉ̃nore macana niaja ʉsã, ni yʉhtiri tiquina tja. ");
INSERT INTO pirNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","—‍“Yʉhʉ tjiaja”, ni tuhasamigʉ yʉhʉ mʉsare. Sa yena yʉhʉre ñehena ahriquinare yʉhʉ mehna cjẽnare peresu yeracãhña mʉsa, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Sa ʉsãre cahĩno ne ihcãquirore butigʉ̃ yerari. Sa yero to pano Cohãcjʉ̃re tiquiro nidiro sahata yero nidi tiquiro. “Yʉhʉre mʉhʉ ohoriquinare ne ihcãquiro boerʉ”, tiquiro nidiro sahata yero nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Sa ye Simo Pedro ñoseni pjĩne cʉoro, ti pjĩne tʉã we nedoqueo, pahia pʉhtoro cahacjʉ̃no Malco wame tiriquiro cahmonore dʉte pahrẽ cãri. Poto pehe cjã cahmonore dʉte pahrẽ cãri. ");
INSERT INTO pirNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Tiquiro sa dʉte pahrẽgʉ̃ ihñano Jesu tiquirore ohõ saha nidi: —‍Mʉhʉ ñoseni pjĩne ihboya. Yʉhʉ Pacʉ yʉhʉre tiquiro ñano yʉhdʉ dutiriro sahata ñano yʉhdʉtja yʉhʉ, nidi Jesu Pedrore. ");
INSERT INTO pirNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Tiquiro sa ni tuhasagʉ̃ta surara, tiquina pʉhtoro mehna, Cohãcjʉ̃ wʉhʉre cohteyequina surara gʉ̃hʉ Jesure ñehe, tiquirore dʉhteri. ");
INSERT INTO pirNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Dʉhte tuhasa Anás cahapʉ nea mʉhtari tiquina. Anás pehe Caifa mareino ijiri. Caifa pehe ti cʉhmare pahia pʉhtoro ijiri. ");
INSERT INTO pirNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","“Judio masa ye ijiatire ihcãquiro masʉno yariagʉ̃ quehnoanota”, nidiquiro boro ijiri Caifa pehe. ");
INSERT INTO pirNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Sa yena yʉhʉ Simo Pedro mehna Jesure yoa cjũnopʉ ihña nʉnʉ tãʉ. Caifa ya wʉhʉpʉ neañe nidi Jesure. Yʉhʉ pehe pahia pʉhtoro tiquiro ihña masinohgʉ ijigʉ Jesu bato pʉhtoro ya wʉhʉ ijiri sahrĩnopʉ sajã wahaʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Yʉhʉ sa sajãgʉ̃ Pedro pehe sahrĩno sopecahapʉ tojoadʉca sari. Sa yegʉ majare wijia ta, sopecahare cohtericorore sinituu. Yʉhʉ sa sinitu tuhasagʉ̃ ticoro Pedrore sajã ta dutiri. Ticoro sajã ta dutiri bato yʉhʉ Pedrore ne sajãa wahaʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Yʉhʉ sa ne sajãgʉ̃ ihñano sopecahare cohtericoro pehe Pedrore sinituri: —‍¿Jesu buheyequina mehna cjʉ̃ ijierajari mʉhʉ? nidi ticoro Pedrore. —‍Ijieraja yʉhʉ, ni yʉhtiri Pedro pehe. ");
INSERT INTO pirNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ʉsã esato pano to cjẽna pʉhtoa cahacjẽna, surara mehna tiquina sohmati pecare wijiã tuhasari jiri. Yʉsʉarĩdi. Sa ye tiquina ti peca dʉhtʉ caha ducuye, sohmañe nidi. Tiquina sa sohmagʉ̃ ihñano Pedro gʉ̃hʉ ahta, sohmari. ");
INSERT INTO pirNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Sa ye pahia pʉhtoro Jesu buherire, ʉsã tiquiro buhena gʉ̃hʉre sinituahye Jesure. ");
INSERT INTO pirNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Tiquiro sa sinitugʉ̃ Jesu pehe yʉhtiahye tiquirore: —‍Ijipihtiyequinare buhegʉ tiquina ihñono ducuu. Sa buhegʉ judio masa mari buheye wʉhʉsepʉ Cohãcjʉ̃ wʉhʉpʉ gʉ̃hʉre sa buheducuu yʉhʉ. Duhtitjiãgʉ buherʉ yʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Dʉhsegʉ yʉhʉre sinituajari mʉhʉ? Sinitu duagʉ yʉhʉ buheyequinare sinituya. Yʉhʉ buherire tiquina masine, ni yʉhtiahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Tiquiro sa nigʉ̃ tʉhoro topʉ ducuriquiro surara pehe tiquiro omoca mehna Jesure quẽahye. —‍Sa niedacãhña pahia pʉhtorore, niahye surara pehe Jesure. ");
INSERT INTO pirNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Tiquiro sa nigʉ̃ta Jesu ohõ saha niahye: —‍Ñano yʉhʉ ni yahuducurire yahuya yʉhʉre. ¿Poto mʉsare yʉhʉ yahuepegʉ̃ta, dʉhsegʉ tagʉ yʉhʉre quẽajari mʉhʉ? niahye Jesu surarare. ");
INSERT INTO pirNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Came Anás Jesure tiquina dʉhteriquirore Caifa pahia pʉhtoro cahapʉ ohoahye. ");
INSERT INTO pirNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Sa ye Simo Pedro peca dʉhtʉ cahapʉ ducuro, sohmano nidi. Tiquiro sa sohmaducugʉ̃ ihñañe to cjẽna tiquirore sinituri: —‍¿Mʉhʉ gʉ̃hʉ Jesu buheyequina mehna cjʉ̃ mʉhʉ ijierajari? nidi tiquina Pedrore. —‍Ijieraja yʉhʉ, ni yʉhtiri Pedro. ");
INSERT INTO pirNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Sa yero pahia pʉhtoro cahacjẽna mehna cjʉ̃no Pedro tiquiro cahmono dʉte pahrẽdiquiro acayʉro pehe Pedrore sinituri: —‍¿Jesure tiquina ñehedi wesepʉ yʉhʉ ijigʉ̃ mʉhʉ gʉ̃hʉ tiquiro mehna ijieracoahte? ni sinituri tiquiro Pedrore. ");
INSERT INTO pirNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","—‍Yʉhʉ tiquiro mehna ijierʉ, nidi Pedro. Tiquiro sa nigʉ̃ta canaca yahuri. ");
INSERT INTO pirNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ñami cjũno ijigʉ̃ Caifa ya wʉhʉpʉ ijiriquina Jesure ne wijia, Roma cjẽna pʉhtoro Pilato ya wʉhʉpʉ nea wahari tiquina. Sa wahaepeta tiquiro ya wʉhʉpʉ sajãedari. Pascua deco ijigʉ̃ tiquina ihyatiquina ijiye, ohõ saha nidi: “Judio masʉno ijierare Pilato. Tiquiro sa ijiriquiro ijigʉ̃ tiquiro ya wʉhʉre sajãna, mari dutiyere yʉhdʉdʉcana niboaga. Sa yena mari sajãgʉ̃ marine bose deco cjẽ ihyayere ihya dutieraboaga”, nidi. Sa niñe pʉhtoro Pilato ya wʉhʉre sajãedari Jesure neariquina pehe. ");
INSERT INTO pirNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Tiquina sa sajãedagʉ̃ ihñano Pilato tiquina cahapʉ wʉhʉ sopecahapʉ esadʉcaro, tiquinare sinituri: —‍¿Yabe buhirire ahriquirore yahusã duajari mʉsa? nidi Pilato tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","—‍Ahriquiro quehnoariquiro ijigʉ̃ mʉhʉre ʉsã ohoeraboaya. Ñariquiro ijire tiquiro, ni yʉhtiri tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Tiquina sa nigʉ̃ Pilato ohõ saha nidi: —‍Mʉsa basita tiquirore neaña. Sa yena mʉsa ye dutiye ti nidiro sahata tiquirore buhiri dahreya, nidi Pilato tiquinare. —‍Mʉsa ye dutiye pehe ʉsãre masʉnore wejẽ dutierare, nidi tiquina Pilatore. Sa niñe Jesure wejẽ dutiye tee nidi. ");
INSERT INTO pirNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Tiquina sa wejẽ dutigʉ̃ Jesu pehe curusapʉ tiquiro yariatire to pano tiquiro yahuriro sahata wahari. ");
INSERT INTO pirNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Tiquina sa nidi bato, Pilato pehe wʉhʉpʉ majare sajã, Jesure pijioahye. Pijio tuhasa, tiquirore sinituahye: —‍¿Judio masa tiquina pʉhto tjiajari mʉhʉ? ni sinituahye Pilato. ");
INSERT INTO pirNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","—‍¿Mʉhʉ esa tuharota sa ni sinituajari mʉhʉ yʉhʉre? ¿O apequina pehe yʉhʉre tiquina yahusãri bato tire sinituajari mʉhʉ? niahye Jesu Pilatore. ");
INSERT INTO pirNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","—‍Judio masʉ ijieraja yʉhʉ. Mʉhʉ ya yehpa cjẽna, pahia pʉhtoa gʉ̃hʉ mʉhʉre ohori ʉsãre. ¿Yabere ñano yeari mʉhʉ tiquina sa buhiri dahre duagʉ̃? niahye Pilato. ");
INSERT INTO pirNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","—‍Ahri yehpa cjʉ̃ pʉhto ijieraja yʉhʉ. Ahri yehpa cjʉ̃ pʉhto yʉhʉ ijigʉ̃, yʉhʉ buheyequina yʉhʉre yedohoboaya. Judio masare ñehe dutieraboaya. Yʉhʉ pʉhto ijiye ahri yehpa cjẽ ijierare, niahye Jesu Pilatore. ");
INSERT INTO pirNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","—‍¿Sa yegʉ pʉhto ijiajari mʉhʉ sa nigʉ? niahye Pilato. —‍Mʉhʉ nino sahata pʉhto ijiaja. Masa tiquina pʉhto ijigʉ tagʉ masa bajuʉ yʉhʉ. Sa yegʉ ahri yehpapʉ ahtaʉ tiquina pʉhto ijii tʉhʉ, poto ijiyere yahugʉ tʉhʉ. Ijipihtiyequina poto ijiyere tʉho duayequina, yʉhʉ yahuyere tʉhore, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","—‍¿Yabe boro ijiajari poto ijiye? niahye Pilato. Sa ni tuhasa Pilato judio masa caha majare tojoa tiquinare yahuri: —‍Ahriquiro Jesure ne buhiri mariedare. ");
INSERT INTO pirNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Cʉhmaripe pascua ijigʉ̃ ihcãquiro peresu ijiriquirore mʉsa wio dutiducure. ¿Sa yegʉ ahriquiro Jesureta mʉsa pʉhtoro ijiatiquiro mʉsare wio basagari yʉhʉ? nidi Pilato judio masare. ");
INSERT INTO pirNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Tiquiro sa nigʉ̃ tʉhoye judio masa ohõ saha ni sañuducuri: —‍Tiquirore wioeracãhña. Barrabá pehere ʉsãre wio basaya, ni sañuducuri judio masa Pilatore. Barrabá pehe yaque bʉcʉro ijiri. ");
INSERT INTO pirNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Tiquina sa ni sañuducuri bato Pilato Jesure tana dutiahye. Sa ye tiquiro yequina surara pehe tiquirore tanahye. ");
INSERT INTO pirNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Tana tuhasa tiquina pota behto ye tuhasa, Jesu dapu buipʉ duhu peoahye. Duhu peo tuhasa, pʉhtoa ye suhti borore tiquirore sãa tuhasa, tiquiro cahapʉ esa dʉca, ohõ saha ni bʉjʉpeahye tiquina: ");
INSERT INTO pirNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","—‍Quehnoano ahtaya. Judio masa pʉhto, quehnoano ahtaya, ni bʉjʉpe, Jesu wʉhdoare quẽ mʉjahye. ");
INSERT INTO pirNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Sa yero Pilato pari turi judio masa cahapʉ waha, tiquinare yahuri: —‍Tʉhoya mʉsa. Ahriquiro ne buhiri mariediquiro ijire. Sa yegʉ tire mʉsa masiatire mʉsa cahapʉ tiquirore ne cãhtaʉ, nidi Pilato. ");
INSERT INTO pirNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Tiquiro sa ni tuhasagʉ̃ Jesu pota behto pesariquiro, pʉhtoa ye suhti borore sañariquiro wʉhʉpʉ ijiriquiro wijia tari. Tiquiro sa wijia tagʉ̃ Pilato tiquinare ohõ saha nidi: —‍Ihñaña. Ahriquiro ijire tiquiro, nidi Pilato. ");
INSERT INTO pirNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Tiquiro sa ni tuhasagʉ̃ tʉhoye, pahia pʉhtoa, surara gʉ̃hʉ Jesure ihñañe, sañuducuri: —‍Curusapʉ quẽ biha wejẽña tiquirore. Curusapʉ quẽ biha wejẽña tiquirore, ni sañuducuri tiquina. —‍Tiquiro ne buhiri mariedare. Sa yena mʉsa basita tiquirore neahña. Sa yena mʉsata tiquirore curusapʉ quẽ biha wejẽña, nidi Pilato tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","—‍Tiquiro basi “Cohãcjʉ̃ macʉ ijiaja”, nie tiri. Tire tiquiro sa nigʉ̃ ʉsã dutiye pehe tiquirore wejẽ dutire, nidi tiquina Pilatore. ");
INSERT INTO pirNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Tiquina sa nigʉ̃ tʉhoro cue yʉhdʉa wahari Pilato pehe. ");
INSERT INTO pirNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Sa yero pari turi wʉhʉpʉre majare sajã, Jesure sinituahye tja: —‍¿Noho cjʉ̃ ijiajari mʉhʉ? ni sinituahye tiquiro Jesure. Tiquiro sa ni sinituepegʉ̃ta Jesu tiquirore yʉhtierahye. ");
INSERT INTO pirNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Tiquiro sa yʉhtieragʉ̃ ihñano Pilato tiquirore sinitu nemoahye: —‍¿Yʉhʉre yʉhtierajari mʉhʉ? Yʉhʉ mʉhʉre peresupʉ ijirigʉre wio masiaja. Sa yegʉ mʉhʉre curusapʉ gʉ̃hʉre quẽ biha wejẽ duti masiaja yʉhʉ. ¿Tire masiedajari mʉhʉ? niahye Pilato Jesure. ");
INSERT INTO pirNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","—‍Cohãcjʉ̃ mʉhʉre tiquiro dutieragʉ̃ yʉhʉre ñano ye dutieraboaya mʉhʉ. Yʉhʉre ihña tuhtiyequinare ihñoriquiro pehe mʉhʉ yʉhdʉoro ñano buhiri tire, niahye Jesu Pilatore. ");
INSERT INTO pirNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Tiquiro sa nigʉ̃ tʉhoro Pilato pehe tiquirore wio duamahye. Tiquiro sa wio duepegʉ̃ta pari turi judio masa sañuducuri: —‍Jesu “Pʉhto ijiaja”, nino mari ijipihtina pʉhtorore Roma cjʉ̃nore ihña tuhtiriquiro ijire tiquiro. Sa yegʉ tiquirore wiogʉ mʉhʉ gʉ̃hʉ mari pʉhtorore ihña tuhtigʉ ijiaga mʉhʉ, ni sañuducuri judio masa Pilatore. ");
INSERT INTO pirNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Tiquina sa nigʉ̃ tʉhoro Jesure wʉhʉpʉ ijiriquirore ne wijia ta, buhiri dahre dutiro taro tiquiro dujiri pahtapʉ nuju sari Pilato. Tiquiro buhiri dahre dutiri paa ʉtã mehna tiquina yeri paa judio masa ye mehna Gabata wame tiri. ");
INSERT INTO pirNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ti deco pascua bose deco ʉsã ihyatire ʉsã quehnori deco ijiri. Ti pjere coheri pje waro ijiri. Nuju sa tuhasa Pilato masare ohõ saha ni yahuri: —‍Ahriquiro tjire mʉsa pʉhtoro, nidi tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Tiquiro sa nigʉ̃ tʉhoye judio masa sañuducuri: —‍Yariahro tiquiro. Yariahro tiquiro. Curusapʉ quẽ biha wejẽña tiquirore, ni sañuducuri tiquina. —‍¿Mʉsa pʉhtoro tiquiro ijiepegʉ̃ta tiquirore curusapʉ quẽ biha wejẽ dutiajari mʉsa? nidi Pilato. Tiquiro sa nigʉ̃ ohõ saha ni yʉhtiri pahia pʉhtoa: —‍Mari ijipihtina pʉhtoro Roma cjʉ̃nota tiquiro ʉsã pʉhtoro ijire. Apequiro pʉhtoro ʉsãre mariedare, ni yʉhtiri pahia pʉhtoa. ");
INSERT INTO pirNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Tiquina sa ni yahuducuri bato Pilato Jesure curusapʉ quẽ biha wejẽ dutiro, tiquirore ohori tiquinare. Sa ye tiquina Jesure ne wijiari. ");
INSERT INTO pirNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Tiquina ne wijiagʉ̃ Jesu pehe tiquiro ya curusare tiquiro basi wʉa ne, dapu pehtoro wame tiropʉ esari. Ʉsã judio masa ye mehna Gólgota wame tiri. ");
INSERT INTO pirNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Topʉ esaye tiquina Jesure quẽ biha ohõri. Sa ye apequina pʉarore ihcãquiro tiquiro poto pehe, apequiro tiquiro cũ pehe pehe quẽ biha ohõri tiquina. Sa yero Jesu tiquina deco curusapʉ wahñari. ");
INSERT INTO pirNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Tiquina quẽ biha tuhasagʉ̃ Pilato taboa pjĩne ojoa duti, Jesure tiquina quẽ biha ohõri curusapʉ quẽ biha ohõ dutiri jiri ti pjĩne. Ohõ saha ni ojoa dutiri jiri tiquiro: “AHRIQUIRO JESU NAZARE CJɄ̃NO, JUDIO MASA PɄHTORO IJIRE”, ni ojoa dutiri jiri Pilato ti pjĩne. ");
INSERT INTO pirNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ti pjĩne ojoaro judio masa ye mehna, Roma cjẽna ye mehna, griego masa ye mehna ojoari jiri apequiro. Sa yero Jesure curusapʉ tiquina quẽ biha ohõriro maca cahagã ijiri. To cahagã ijiyequina peyequina judio masa Pilato ojoa dutirire ihña, buheri. ");
INSERT INTO pirNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Sa buhe tuhasa judio masa ʉsã pahia pʉhtoa ohõ saha nidi Pilatore: —‍“Ahriquiro judio masa pʉhtoro ijire”, ni ojoa dutieracãhña. Ʉsã pʉhtoro ijierare ahriquiro. Sa yegʉ ohõ saha ni ojoa quehno dutiya mʉhʉ. “Ahriquiro ‘Judio masa pʉhto ijiaja’, ni ihcãquirota tiquiro basita sa ni tʉhoturiquiro ijiri”, ni ojoa quehno dutiya, nidi pahia pʉhtoa. ");
INSERT INTO pirNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","—‍Yʉhʉ ojoa duti mʉhtariro sahata ijirota, nidi Pilato tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Jesure tiquina quẽ bihari bato pititiaro surara pehe Jesu suhtire tiquina basi itiri. Tiquina sa iti duepegʉ̃ta ihcã suhtiro yoari suhtiro dohori marieni suhtiro ijiri. Ti suhtiro suhari suhtiro ijiri. ");
INSERT INTO pirNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ti suhtiro sa ijigʉ̃ ohõ saha nidi tiquina basi: —‍Ahri suhtirore tʉhrẽdacʉ̃hna. Ahri suhtirore neatiquirore masi duana, doquepeihna mari, nidi tiquina basi. Sa doquepeye, Cohãcjʉ̃ yere tiquina ojoari pũpʉ tiquina ni ojoariro sahata yeye nidi tiquina. “Yʉhʉ suhtire tiquina basi itiri. Sa ye yʉhʉ suhtire neatiquinare masi duaye, doqueperi tiquina”, ni ojoahye Cohãcjʉ̃ yere tiquina ojoari pũpʉ. Tiquiro sa ni ojoariro sahata sa yeye nidi tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Surara tiquina sa yegʉ̃, Jesu pacoro, Jesu mʉono, María Cleofa namono, María Magdalena mehna Jesu curusa cahagã ihñaducuri tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Sa yero tiquiro pacoro yʉhʉ tiquiro cahñogʉ gʉ̃hʉ tiquiro cahapʉ ʉsã ducugʉ̃ ihñano tiquiro pacorore yahuri Jesu: —‍Yojopʉre ahriquiro mʉhʉ macʉ ijire, nidi Jesu tiquiro pacorore. ");
INSERT INTO pirNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Sa ni tuhasa, yʉhʉre ohõ saha ni yahuri tiquiro: —‍Yojopʉre ahricoro mʉhʉ paco ijire, nidi Jesu yʉhʉre. Tiquiro sa nidi bato Jesu pacorore ya wʉhʉpʉ iji dutii. ");
INSERT INTO pirNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Tiquiro sa ni yahuri bato ohõ saha ni tʉhotu, masiahye Jesu: “Ijipihtiye Cohãcjʉ̃ yʉhʉre dahra dutiro tiquiro cũrire ye pehou”, ni tʉhotu, masiahye Jesu. Sa masino Cohãcjʉ̃ yere tiquina ojoari pũpʉ tiquiro ni yahuriro sahata ohõ saha nidi Jesu: —‍Aco wʉoaga yʉhʉ, nidi Jesu. ");
INSERT INTO pirNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Sa yero topʉ vino sʉẽñe co pose tiri sutu dujiri. Sa yero topʉ ijiriquiro aco ihmini sʉhtere sʉẽñe co mehna tiquina sohari sʉhtere yucʉgʉ hisopo wame tidʉ sohtoapʉ dʉhte ohõri. Sa yero Jesu dʉseropʉ siõ ohõri. ");
INSERT INTO pirNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ti core Jesu ihmi tuhasa ohõ saha nidi: —‍To punota ijiaga, ninota tiquiro dapure muhri yo, yariaa wahari. ");
INSERT INTO pirNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ti deco pascua bose deco pano ijiri. Bose deco cjẽne ʉsã ihyatire quehnori deco ijiri. Sa ye ape deco saurú ijigʉ̃ tiquina bose deco ijigʉ̃ curusaripʉ yariariquinare cũ duerari. Ti deco Cohãcjʉ̃re tiquina ño peori bose deco ijiri. Sa ye ti decopʉ tiquina quẽ biha ohõriquinare curusaripʉ tiquina wahñagʉ̃ cahmedari tiquina. Sa ye tiquina quẽ biha ohõriquinare tiquina ñecʉ cohãrine quẽ nuha dutiye tehe, judio masa siniahye Pilatore, “Tiquina yaria madoqueoahro”, niñe. Tiquina sa yeri bato tiquina pagʉrire ne dijio madoqueoye tee nidi. ");
INSERT INTO pirNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Tiquina sa dutigʉ̃ surara pehe curusari cahapʉ esa, ihcãquiro yaqueriquiro ñecʉ cohãrine quẽ nuhari. Apequiro gʉ̃hʉre sata yeri tiquina. ");
INSERT INTO pirNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Sa ye Jesu ñecʉ cohãrine quẽ nuhae tee yemehe, tiquiro yariariquiro ijigʉ̃ ihñañe, quẽ nuhaedari. ");
INSERT INTO pirNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Sa quẽ nuhaedaye ihcãquiro surara tiquiro pati pahma batogã ñosenʉ mehna ñosedi. Tiquiro sa ñosegʉ̃ duita tiquiro dii, aco mehna wijiari. ");
INSERT INTO pirNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ti sa wahagʉ̃ ihñaʉ yʉhʉ. Yʉhʉ ahri pũre ojoarigʉ mʉsare poto yahuaja. Poto yʉhʉ yahuye ijigʉ̃ masiaja yʉhʉ. Mʉsare yahuaja mʉsa gʉ̃hʉ Jesure mʉsa wacũ tutuato saha. ");
INSERT INTO pirNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Cohãcjʉ̃ yere tiquina ojoari pũ ti nidiro sahata sa wahari: “Tiquiro cohãrine ne ihcã cohãre quẽ nuhaedari”, tiquiro ni ojoariro sahata Jesu ñecʉ cohãrine ne ihcã cohãre quẽ nuhaedari. ");
INSERT INTO pirNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Sa yero ape pũpʉ Cohãcjʉ̃ yere tiquina ojoari pũpʉ ohõ saha nine. “Tiquirore tiquina ñosediquirore ihñaeta tiquina”, ni ojoahye Cohãcjʉ̃ yere tiquina ojoari pũpʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Tiquiro yariari bato José Arimatea cjʉ̃no Jesu pagʉre ne dijioro taro, Pilatore siniahye. José pehe apequina judio masare cuero, Jesure wacũ tutuariquiro tiquiro ijiyere yahu duerahye. Sa yero tiquiro pagʉre sinidi bato Pilato pehe Jesu pagʉre nea dutiahye. Tiquiro nea dutigʉ̃ José curusa cahapʉ esa, Jesu pagʉre nea wahahye. ");
INSERT INTO pirNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemo gʉ̃hʉ José mehna wahahye. Tiquiro yucʉgʉ cjẽ ehme sitiyere, mirra wame tiye ehme sitiye yucʉgʉ cjẽ mehna dahra moredire ne cãhye. Jesu pagʉre tiquina cohãto pano tiquina quehnoati ijiahye ti ehme sitiye. Tiquiro ne cãhtari treinta kilo nʉcʉahye. Nicodemo sohõ ijiri pje Jesu mehna tiquiro coã yahuducuri pje ñamipʉ Jesu cahapʉ esariquiro ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Sa ye tiquina pʉaro Jesu pagʉre ne, judio masa yariariquinare ʉsã cohãducuro sahata tiquiro pagʉre ehme sitiye mehna suhti mehna wahmeahye. ");
INSERT INTO pirNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Curusapʉ Jesure tiquina wejẽdiro cahapʉ wese ijiri. Ti wesepʉ masa cope ʉtãpʉ wahma tiquina seheri cope ijiri. Ti copere ne ihcãquiro yariariquirore cohãedarĩdi. ");
INSERT INTO pirNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Pascua bose deco judio masa bose deco ʉsã ihyatire quehnori deco ijiri. Sa ijiri deco ijigʉ̃ ti cope cahagã tiquiro curusa ijigʉ̃, topʉ cũahye tiquina Jesu pagʉre. ");
INSERT INTO pirNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Domingo ñami cjũnogã ijigʉ̃, bohreato panogã María Magdalena Jesu masa copepʉ esahye. Topʉ esaro ti copere tiquina tu biharia ʉtãre yoa cjũnopʉ tiquina põo cũria ʉtãre ihñahye ticoro. ");
INSERT INTO pirNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Sa ijigʉ̃ ihñano, ʉsã cahapʉ oma tojoa tari ticoro. Simo Pedro mehna yʉhʉ ʉsã pʉana ijii. Wihi ohõ saha ni yahuri ʉsãre ticoro: —‍Mari pʉhtoro pagʉre ne cãri jiri. Nohopʉ ne cã cũcoayaye mari masiedaja, nidi ticoro ʉsãre. ");
INSERT INTO pirNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ticoro sa nigʉ tʉhona, Pedro mehna masa copepʉ ihñana wahaʉ ʉsã. ");
INSERT INTO pirNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Sa ihñana wahana ʉsã pʉana oma cãʉ. Sa oma cãna, yʉhʉ Pedrore oma yʉhdʉ cãgʉ masa copepʉ esa mʉhtaʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Topʉ esagʉ muhri ihña sõu ti copepʉre. Muhri ihña sõgʉ tiquirore tiquina wahmedi suhtiro dihitare ihñaʉ. Sa ye ti copere sajãedʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Yʉhʉ sa ihñari batopʉ Simo Pedro yʉhʉ batopʉ wihiri. Wihi masa copepʉ sajã, tiquiro pagʉre tiquina wahmedi suhtirore ihñari tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Sa yero Jesu dapure tiquina wahmedi cahsero gʉ̃hʉre ihñari tja. Ti cahsero sijoro cuñano tiquiro torẽdi cahsero ijiri. ");
INSERT INTO pirNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Sa yegʉ yʉhʉ gʉ̃hʉ masa copepʉ esa mʉhtarigʉ ti copepʉ sajãʉ. Jesu sa mariedagʉ̃ ihñagʉ “Potota Jesu masa wijiahya”, ni tʉhotuu yʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ti copepʉ ʉsã wahato pano Cohãcjʉ̃ yere tiquina ojoari pũpʉ Cristo tiquiro yariatire yahurire, tiquiro masa wijiatire yahuri gʉ̃hʉre ʉsã quehnoano masiedarĩmi. Ti copere yʉhʉ ihñari bato, “Ijirota Jesu masa wijiahya”, ni, tʉhotuu yʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Sa ihña tuhasa ʉsã ye wʉhʉsepʉ tojoaa wahaʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Sa ye masa copepʉ María majare tojoa ta, ti cope sopecahapʉ wihi, ducuro, utiro niahye. Sa utieperota ticoro muhri ihña sõahye masa copepʉre. ");
INSERT INTO pirNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Sa ihña sõno pʉaro angelere, yehseye suhti sañañequinare Jesu tiquiro cuñamediropʉ tiquina dujigʉ̃ ihñahye ticoro. Ihcãquiro tiquiro dapu timediropʉ dujiahye. Apequiro tiquiro dahpocãri timediropʉ dujiahye. ");
INSERT INTO pirNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Tiquinare ticoro ihñagʉ̃ tiquina pehe ticorore sinituahye: —‍¿Numio, dʉhse yego utiajari mʉhʉ? niahye tiquina. —‍Yʉhʉ pʉhtoro pagʉre ne cãri jiri. Sa yego tiquiro pagʉre tiquina cũrire masiedaga yʉhʉ, niahye ticoro. ");
INSERT INTO pirNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Sa ni tuhasa, majaredʉcameno Jesure topʉ ducuriquirore ihñahye ticoro. Sa ihñaeperota Jesure masiedahye ticoro. ");
INSERT INTO pirNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","—‍¿Numio, dʉhse yego utiajari mʉhʉ? ¿Noare macago niajari? niahye Jesu ticorore. “Ahriquiro ahri wesere cohteriquiro ijire”, ni tʉhotumahye ticoro Jesure. Sa ni tʉhoturo, ohõ saha niahye ticoro: —‍Mʉhʉ tiquiro pagʉre nedigʉ ijigʉ mʉhʉ cũrirore yahuya yʉhʉre. Mʉhʉ yahuri bato tiquiro pagʉre negotja, niahye ticoro tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ticoro sa nidi bato Jesu ohõ saha niahye: —‍María, niahye. Tiquiro sa ni pisugʉ̃ tʉhoro majare ihñadoqueo ticoro hebreo ye mehna ohõ saha niahye: —‍Rabuni, niahye ticoro Jesure. “Rabuni”, nino, “Buhegʉ”, nino niahye. ");
INSERT INTO pirNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","—‍Yʉhʉ Pacʉ cahapʉ mʉjaedarĩaja yʉhʉ. Yʉhʉ sa mʉjaedarĩgʉ̃ yʉhʉre ñehedacãhña. Sa yego apequina yeequina cahapʉ wahaya. Tiquina cahapʉ esago ohõ saha ni yahuya tiquinare: “ ‘Yʉhʉ Pacʉ cahapʉ wahaʉ tʉʉ niaja. Mʉsa Pacʉ gʉ̃hʉ ijire tiquiro. Yaquiro Cohãcjʉ̃ cahapʉ wahaʉ tʉʉ niaja. Mʉsa yaquiro Cohãcjʉ̃ gʉ̃hʉ ijire tiquiro’, nidi Jesu”, ni yahuya tiquinare, niahye Jesu Maríare. ");
INSERT INTO pirNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Tiquiro sa nidi bato María Magdalena ʉsã Jesu buhena cahapʉ wihi, yahuri ʉsãre: —‍Mari pʉhtorore ihñaʉ yʉhʉ, ni, Jesu tiquiro yahu dutirire yahuri ʉsãre ticoro. ");
INSERT INTO pirNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ti deco domingo ñamicahapʉ ʉsã Jesu buhena ʉsã acaye judio masare cuena, wʉhʉpʉ biha sajã, dujii ʉsã. Sa ʉsã dujigʉ̃ Jesu ʉsã watoapʉ bajuadʉca saro ohõ saha nidi: —‍¿Ne, ijiajari mʉsa? Quehnoano ijiya mʉsa, nidi. ");
INSERT INTO pirNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Sa ni tuhasa, tiquiro omocarine, tiquiro pati pahma bato gʉ̃hʉre ʉsãre ihñori. Sa yena ʉsã tiquirore ʉsã pʉhtorore ihñana bucuei. ");
INSERT INTO pirNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Pari turi Jesu ʉsãre ohõ saha nidi: —‍Quehnoano ijiya mʉsa. Yʉhʉ Pacʉ yʉhʉre tiquiro ohoriro sahata, mʉsa gʉ̃hʉre yee buheyere buheanare ohoaja, nidi Jesu ʉsãre. ");
INSERT INTO pirNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Sa ni tuhasa tiquiro ʉsãre puti peori. Sa puti peoro Espíritu Santore ʉsã ñeheatire ihñono nidi ʉsãre. Ihño tuhasa ohõ saha nidi: —‍Yojopʉ Espíritu Santore ñeheña mʉsa, mʉsa mehna ijiatiquirore. ");
INSERT INTO pirNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Apequina tiquina ñañe yerire mʉsa bogʉ̃, sata ijieta. Sa ye apequina tiquina ñañe yerire mʉsa boeragʉ̃ ti bori ijisi, nidi Jesu ʉsãre tiquiro buhenare. ");
INSERT INTO pirNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Jesu ʉsã watoapʉ tiquiro bajuagʉ̃ Tomasu sʉhdʉariquiro tiquina ni pisuriquiro ʉsã mehna mariedari. ");
INSERT INTO pirNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Tiquiro sa mariedagʉ̃ ʉsã mehna cjẽna tiquirore yahumedi. —‍Mari pʉhtorore ʉsã ihñaʉ, ni yahumi ʉsã Tomasure. Ʉsã sa ni yahuepegʉ̃ta ohõ saha nidi Tomasu: —‍Tiquiro omocarine tiquina quẽ bihari coperire ihñedagʉ, ti coperire yʉhʉ omo piria mehna ohbe tuhueragʉ “Ijirota masa wijiahya”, nisi yʉhʉ. Sa yegʉ tiquiro pati pahma bato ijiri copere yʉhʉ omoca mehna siõ sõedagʉ, “Ijirota masa wijiahya”, nisi yʉhʉ tiquirore, nidi Tomasu. ");
INSERT INTO pirNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ocho decori bato pari turi ʉsã tiquiro buhena ʉsã wʉhʉpʉ ijii. Ti pjere Tomasu ʉsã mehna ijiri. Ti wʉhʉ bihari wʉhʉ ijiri. Bihari wʉhʉ ijiepegʉ̃ta Jesu wʉhʉpʉ sajã taro, ʉsã watoapʉ bajuadʉca saro ohõ saha nidi: —‍¿Ne, ijiajari mʉsa? Quehnoano ijiya mʉsa, nidi. ");
INSERT INTO pirNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Sa ni tuhasa, tiquiro Tomasure yahuri: —‍Ihñaña yʉhʉ omocarine. Sa ye mʉhʉ omo piria mehna yʉhʉ omocarine tiquina quẽ bihari coperire ohbe tuhuya. Sa yegʉ mʉhʉ omoca mehna yʉhʉ pati pahma bato ijiri copere siõ sõ tuhuya. “Poto ijierare”, niedacãhña. “Ijirota ijire”, niña mʉhʉ, nidi Jesu Tomasure. ");
INSERT INTO pirNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tiquiro sa nidi bato Tomasu yʉhtiri: —‍Mʉhʉ yʉhʉ pʉhto ijire. Yaquiro Cohãcjʉ̃ ijire mʉhʉ, nidi Tomasu Jesure. ");
INSERT INTO pirNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","—‍Yʉhʉre mʉhʉ ihñari bato yʉhʉre wacũ tutuare mʉhʉ. Apequina pehe yʉhʉre ihñedapeta yʉhʉre wacũ tutuaeta. Sa ye tiquina mʉhʉ yʉhdʉoro bucueeta, nidi Jesu Tomasure. ");
INSERT INTO pirNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Sa yero peye apeye gʉ̃hʉre Cohãcjʉ̃ tutuaye mehna ye ihñori Jesu ʉsã mehna ijiro. Tire tiquiro yerire ahri pũpʉ ojoa pehoeradʉ yʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Sa ojoa pehoerapegʉta ahri pũpʉ yʉhʉ yahurire ojoaʉ “Jesuta Cristo Cohãcjʉ̃ ohoriquiro ijire. Tiquiro potota Cohãcjʉ̃ macʉno ijire”, mʉsa ni masiatire. Sa yena mʉsa tiquirore wacũ tutuana Cohãcjʉ̃ mehna mʉsa sa ijiducuatire ojoaʉ ahri pũre. ");
INSERT INTO pirNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Came Tiberia wame tiri ditara dʉhtʉ cahapʉ ʉsãre tiquiro buhenare Jesu pari turi bajuari tja. Ʉsãre bajuaro ohõ saha yeri tiquiro. ");
INSERT INTO pirNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simo Pedro, Tomasu sʉhdʉariquiro tiquina niniquiro, Natanae Galilea yehpapʉ ijiri maca, Caná wame tiri maca cjʉ̃no, apequina pʉaro buheyequina, Zebedeo pohna pʉana ʉsã ohõpequinata cahmecoaʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Sa ʉsã cahmecoari bato Simo Pedro ʉsãre ohõ saha nidi: —‍Wahi wejẽgʉ wahaʉ niaja, nidi tiquiro. —‍Ʉsã gʉ̃hʉ mʉhʉ mehna wahanatja, nii ʉsã tiquirore. Sa ni tuhasa buhaa wahaʉ. Sa yena yucʉsa mehna wahaʉ. Ti ñamine ʉsã quehnoano wahi wejẽ bohreepenata ne ihcãquiro wahi wejẽdadʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Bohrea parĩ quehagʉ̃ Jesu padʉropʉ ducugʉ̃ tiquirore ihñami ʉsã. Sa ihñaepenata tiquirore ihña masiedʉ ʉsã. ");
INSERT INTO pirNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Sa yero tiquiro pehe ʉsãre sinituri: —‍¿Ne wahi wejẽajari mʉsa? nidi Jesu. —‍Ne wejẽdabutiaga ʉsã, ni yʉhtii ʉsã. ");
INSERT INTO pirNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","—‍Yucʉsa poto pehe pahrẽ pehe doque ñoña. Tie pehe doque ñona wahi wejẽnata mʉsa, nidi ʉsãre. Tiquiro sa nigʉ̃ tʉhona ʉsã tiquiro nidirota doque ñou. Ʉsã doque ño tuhasagʉ̃ta peyequina wahi sajãri. Peyequina wahi sajãgʉ̃ wẽñanʉre yucʉsapʉ weje sãana cũedadʉ ʉsã. ");
INSERT INTO pirNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Sa yegʉ yʉhʉ Jesu cahñogʉ Pedrore yahuu: —‍Mari pʉhtorota ijire siquiro padʉropʉ ducuriquiro, nii yʉhʉ Pedrore. Yʉhʉ sa nigʉ̃ tʉhoro Jesuta tiquiro ijigʉ̃ masino, Simo Pedro tiquiro suhtirore sañari. Wahi wejẽno taro tiquiro suhtirore tu weriquiro ijinidi. Tiquiro suhtirore saña tuhasa, diapʉ uhpu ñojoaa wahari. ");
INSERT INTO pirNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Sa yena ʉsã apequina buhena yucʉsapʉ ijina, cien metro yoaro diapʉre pahsaʉ ʉsã. Sa yena wẽñanʉre wahi peyequina sajãdʉre yucʉsa mehna weje nʉjʉaʉ ʉsã. ");
INSERT INTO pirNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Dʉhtʉ cahapʉ ʉsã wahã sagʉ̃, topʉ peca niti dihita asi cuñari peca ijiri. Ti peca bui tiquiro pʉhõ cũriquirore wahire ihñaʉ ʉsã. Pã gʉ̃hʉre ihñaʉ ʉsã. ");
INSERT INTO pirNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Sa ʉsã ihñagʉ̃ ihñano Jesu ʉsãre ohõ saha nidi: —‍Mianogã mʉsa wejẽdiquinare meheñequinagã ne cãhtaya, nidi ʉsãre. ");
INSERT INTO pirNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Tiquiro sa nigʉ̃ Simo Pedro pehe Jesu mehna ijiriquiro yucʉsapʉ sajã, wẽñanʉre, bʉjʉyequina wahi ciento cincuenta y tres wahi sajãdʉre weje majari. Peyequina wahi sajãepeta wẽñanʉre tʉhrẽdari. ");
INSERT INTO pirNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","—‍Ihyana ahtaya, nidi Jesu ʉsãre. “¿Noa boro ijiajari mʉhʉ?” ni sinituerʉ ʉsã tiquirore. Ʉsã pʉhtoro tiquiro ijigʉ̃ masii ʉsã. ");
INSERT INTO pirNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Sa yero Jesu peca cahapʉ esaro, pãre ne, ʉsãre itiri. Wahi gʉ̃hʉre itiri. ");
INSERT INTO pirNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Sa yero Jesu tiquiro masa wijiari bato padʉropʉ bajuaro ihtia taha ʉsãre tiquiro buhenare bajuaro nidi. ");
INSERT INTO pirNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ʉsã ihyari bato Jesu Simo Pedrore sinituri: —‍¿Simo Ñu macʉ, ahriquinare mʉhʉ cahĩno yʉhdʉoro yʉhʉre cahĩajari mʉhʉ? nidi Jesu Simo Pedrore. —‍Pʉhto, mʉhʉre cahĩaja yʉhʉ. Mʉhʉre yʉhʉ cahĩgʉ̃ masine mʉhʉ, ni yʉhtiri Simo Pedro. ");
INSERT INTO pirNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","—‍Sa yegʉ ovejagãre tiquina nuno saha yeequinare buheya mʉhʉ, nidi Jesu. Sa ni tuhasa pari turi tiquiro Simo Pedrore sinituri: —‍¿Simo Ñu macʉ, yʉhʉre cahĩajari mʉhʉ? nidi Jesu. —‍Pʉhto, mʉhʉre cahĩaja yʉhʉ. Mʉhʉre yʉhʉ cahĩgʉ̃ masine mʉhʉ, ni yʉhtiri Simo Pedro. —‍Ovejare cohteriquiro ovejare tiquiro quehnoano cohtero saha, yeequinare quehnoano buhe cohteya, nidi Jesu Pedrore. ");
INSERT INTO pirNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Sa ni tuhasa pari turi Simo Pedrore sinituri: —‍¿Simo Ñu macʉ, yʉhʉre cahĩajari mʉhʉ? nidi Jesu tja. Ihtia taha sa ni tiquiro sinitugʉ̃ tʉhoro Simo Pedro tutuaro bʉjʉa witiri: —‍Pʉhto, mʉhʉ masi pehore. Mʉhʉre yʉhʉ cahĩgʉ̃ masine mʉhʉ, ni yʉhtiri Simo Pedro. —‍Ovejare tiquina nuno saha yeequinare buheya mʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ijirota mʉhʉre niaja. Mʉhʉ wahmʉ ijigʉ mʉhʉ suhtire saña, mʉhʉ cahmediropʉ tinie tiahye mʉhʉ. Sa yerigʉ mʉhʉ ijiepegʉ̃ta came mʉhʉ bʉcʉ ijigʉ̃, mʉhʉ omocarine mʉhʉ siõdoqueogʉ̃ apequiro mʉhʉre suhtiro sãanota. Sa yero mʉhʉ waha dueropʉ mʉhʉre neanota, nidi Jesu Simo Pedrore. ");
INSERT INTO pirNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Sa nino Simo Pedrore dʉhse waha tiquiro yariatire yahuro nidi. Camepʉ bʉcʉro tiquiro wahagʉ̃ sa yeye taye niahye apequina tiquirore. Cohãcjʉ̃ yere Pedro yeri buhiri apequina tiquirore wejẽñe taye niahye. Sa yero Pedro yariatire yahuro nidi Jesu. Sa ni yahu tuhasa, ohõ saha ni nemori Pedrore: —‍Poto yʉhʉ buheriro sahata yeya mʉhʉ, nidi Jesu Pedrore. ");
INSERT INTO pirNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Tiquiro sa nigʉ̃ta Pedro pehe majare ihñadoqueo, yʉhʉre Ñure Jesu tiquiro cahñogʉ buherigʉre tiquinare yʉhʉ nʉnʉ tãgʉ̃ ihñano Pedro Jesure sinituri. Yʉhʉ pehe Pedro ihñarigʉ to pano ohõ saha nidigʉ ijii. “¿Pʉhto, mʉhʉre ihña tuhtiyequinare ihñoatiquiro pehe noa boro ijiagari tiquiro?” ni Jesure siniturigʉ ijii yʉhʉ. Ti pjere Jesu tiquiro pari paha ihya dujii yʉhʉ. Sa yero yʉhʉre ihñano Pedro Jesure sinituri: ");
INSERT INTO pirNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","—‍¿Pʉhto, ahriquiro pehe dʉhse waharotari? ni sinituri. ");
INSERT INTO pirNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","—‍Tire mʉhʉre yahueraja. Ahri yehpapʉ yʉhʉ tojoa tato pano ahriquirore ijiducugʉ̃ yʉhʉ yeatire masiedare mʉhʉ. Sa yegʉ mʉhʉre yahueraja. Poto yʉhʉ buheriro sahata yeya mʉhʉ, nidi Jesu Pedrore. ");
INSERT INTO pirNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Tire tiquiro yahurire ijipihtiyequina Jesu yequina tiquina basi yahu sitemedi. Tire yahu siteye ohõ saha nimedi tiquina pehe: “Jesu tiquiro cahĩniquiro buheriquiro yariasi”, ni yahu sitemedi yʉhʉre Jesu yequina tiquina basi. Tiquina sa niepegʉ̃ta “Tiquiro yariasi”, nino niedari jimedi Jesu. “Ahri yehpapʉ yʉhʉ tojoa tato pano ahriquirore ijiducugʉ̃ yʉhʉ yeatire masiedare mʉhʉ. Sa yegʉ mʉhʉre yahueraja”, nidi Jesu Pedrore. ");
INSERT INTO pirNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Jesu buherigʉ ahrire yahurigʉ, ahri pũre ojoarigʉ ijiaja yʉhʉ. Sa yena ahri yʉhʉ yahuye poto ijigʉ̃ masiaja mari. ");
INSERT INTO pirNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Peye apeye gʉ̃hʉre Jesu yeri. Tiquiro yerire mari ojoa pehogʉ̃ ti pũri ojoari pũri peye waro wahaboaga. Sa ye ti pũrine mari ihbogʉ̃ esa tuhaeraboaga ahri yehpa. Wahpaa wahaboaga, yʉhʉ tʉhotugʉ̃. To puno tjire.");
INSERT INTO pirNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Teófilo, ahri quitire mʉhʉre ojoagʉ niaja. To pano yʉhʉ ojoa mʉhtari pũre Jesu yerire, tiquiro buheyere mʉhʉre yahu tuhasaʉ. Tee ʉhmʉsepʉ tiquiro mʉjarire yʉhʉ yahu bato tii. Jesu tiquiro mʉjato pano Espíritu Santo tutuaye mehna dutiahye tiquiro bese cũriquinare. ");
INSERT INTO pirNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Sa ye Jesu curusapʉ tiquiro yariari bato ihquẽ tahari pagʉ tiriquiro bajuahye tiquiro cũriquinare. Cuarenta decori bato bajua bato tiahye. Sa yero tiquiro basi catiriquiro ijiyere ihñoahye tiquinare. Sa bajuaro mari Pacʉ tiquiro pʉhtoro ijiyere quehnoañe buheyere yahuahye tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Jesu tiquiro cũriquina mehna ijinino tiquinare ohõ saha ni yahuahye: —‍Jerusalẽpʉta ijiniña yojopʉre. “Espíritu Santore mʉsare ohogʉtja”, yʉhʉ Pacʉ tiquiro nidiquirore cohteniña. Tire tiquiro nidire mʉsare yahuu yʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ñu mʉsare wame yero aco mehna wame yemedi. Yʉhʉ pehe ti yʉhdʉoro yeitja mʉsare. Mehenogã bato Espíritu Santore mʉsa mehna ijiducugʉ̃ yeitja mʉsare, niahye Jesu. ");
INSERT INTO pirNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Sa ye ape taha cʉnʉpʉ Olivo wame tidʉpʉ Jesu tiquinare tiquiro bajuagʉ̃ ihñañe tiquina sinituahye tiquirore: —‍¿Pʉhto, Israe yehpare tiquina ehmari yehpare dʉhse ijigʉ̃ ʉsãre pari turi cũgʉtjari mʉhʉ? ¿Dʉhse ijigʉ̃ mari acaye warore pʉhtoro sõgʉtjari mʉhʉ? niahye tiquiro yequina. ");
INSERT INTO pirNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Tiquina sa nigʉ̃ tʉhoro Jesu ohõ saha niahye: —‍Mari Pacʉ dihita ti decore mʉsa ya yehpare mʉsa quehnoano ijiatire cũ masine. Ti decore mʉsare masino basioerare. ");
INSERT INTO pirNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Sa masiedapenata mʉsare Espíritu Santo tiquiro wihigʉ̃ Cohãcjʉ̃ ye tutuayere cʉonata mʉsa. Tiquiro ye tutuayere mʉsa cʉona Jerusalẽ cjẽnare, ijipihtiyequina Judea yehpa cjẽnare, Samaria yehpa cjẽnare, sa ye ijipihtiye yehpari cjẽnare quehnoañe buheyere buhenata mʉsa. Yʉhʉ yariarire, yʉhʉ masa mʉjarire tiquinare buhenata mʉsa, ni yahuahye Jesu tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Sa ni yahu tuhasa, Jesu ʉhmʉsepʉ mʉjaa wahahye. Tiquina tiquirore ihña nʉnʉ tã mʉogʉ̃ta ehmeo curua puhiapʉ sajã, buti mʉjaa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Sa ye tiquina Jesu mʉjariquirore tiquina ihña mʉori watoa pʉaro angele yehseye suhti sañañequina Jesu tiquiro cũriquina watoa bajuadʉca sahye. ");
INSERT INTO pirNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Sa ye tiquinare ohõ saha niahye: —‍¿Mʉsa Galilea cjãna, dʉhse ijiro boro ihña mʉoducuna niajari mʉsa? Ahriquiro Jesu ʉhmʉsepʉ mʉjariquiro, tiquiro mʉjariro saha ahtarota, ni yahuahye angele. ");
INSERT INTO pirNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Sa ye Jesu yequina cʉnʉpʉ Olivo wame tidʉpʉ ijiriquina dijia ta, Jerusalẽpʉ tojoa sahye. Tʉ cʉnʉpʉre ihcã kilómetro yʉhdʉo cjũno yoaro ijiahye Jerusalẽ dʉhtʉ cahapʉre. ");
INSERT INTO pirNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Tojoa sa, ʉhmʉanopʉ tiquina ijiri tucũpʉ mʉjaa wahahye. Ahriquina ijiahye: Pedro, Ñu, Santiago, Andre, Felipe, Tomasu, Bartolomé, Mateo, Santiago, Simo, Juda ijiahye. Santiago pehe Alfeo macʉno ijiahye. Simo pehe celote wame tiri curua cjʉ̃no ijimediquiro ijiahye. Juda pehe Santiago acayʉro ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Peye tahari ahriquina ijipihtiyequina, numia mehna, María Jesu pacoro mehna, Jesu bahana mehna quehnoano cahmecoa, tutuaro mehna mari Pacʉre sinie tiahye. ");
INSERT INTO pirNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Sa ye ti decorire masa peyequina cahmecoahye. Ciento veinte ijiye ijiboaya. Sa yero Pedro pehe tiquiro mehna cjẽna Cristo yequina watoa ducu, yahuahye tiquinare: ");
INSERT INTO pirNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—‍Yʉhʉ acaye, Cohãcjʉ̃ panopʉ tiquiro nidiro sahata waharo nidi. Tire Espíritu Santo Davire yahu dutiahye Juda mʉnanore. Juda mʉnano Jesure ñeheatiquinare ihñoriquiro ijiri. ");
INSERT INTO pirNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Sa yeatiquiro ijieperota mari mehna Jesu yere yeriquiro ijimedi. Sa yero ʉsã mehna cjʉ̃nota ijimedi, niahye Pedro. ");
INSERT INTO pirNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Jesure ihño dutiye tiquina wapa yerire Juda mʉnano pehe wiari bato tiquiro basita wejẽ yariaa wahahye. Sa yero boraa waha, tiquiro cʉhta misi da tʉhnʉa waha, yariaa wahahye. Tiquiro wiari mehna apequina mehenogã yehpare dúahye. ");
INSERT INTO pirNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ijipihtiyequina Jerusalẽ cjẽna masi pihti cãri jiri Juda mʉnano tiquiro ñano yerire. Sa masiñe tiquiro ye niñeru mehna tiquina dúri yehpare Acéldama wame yeri jiri tiquina ye yahuducuye mehna. Acéldama niñe, “Dii yehpa”, niñe nine. ");
INSERT INTO pirNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Came ohõ saha ni nemoahye Pedro: —‍Panopʉ tiquina ojoariro sahata sa wahari Juda mʉnano. Salmo tiquiro ojoari pũpʉ ohõ saha ni ojoahye: Tiquiro wʉhʉ cohõri wʉhʉ ijiahro. Sa ye apequina ti wʉhʉre ijieracãhdo, ni, ojoahye. Ohõ gʉ̃hʉre ohõ saha ni ojoahye: Apequiro tiquiro dahrayere camesariquiro ijirota, ni, ojoahye Salmopʉ. ");
INSERT INTO pirNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","’Sa yena mari ihcãquiro beseihna. Ñu wame yeriquiro mʉnano masare tiquiro buheri watoa ihquẽquina Jesu yequina mari mehna wahari. Tiquina mehna cjʉ̃nore ihcãquiro bese neno cahmene mari mehna cjʉ̃no ijiatiquirore. Jesu mehna mari ijigʉ̃ mari mehna sa ijiducuriquirore besero cahmene. Sa mari beseri bato Jesu tiquiro masa mʉjarire mari mehna buherota, ni yahuahye Pedro tiquiro acayere Cristo yequinare. ");
INSERT INTO pirNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Tiquiro sa nigʉ̃ tʉhoye pʉarore bese bocahye tiquina. Ihcãquiro José Justo wame tiriquirore beseahye. Tiquiro Barsaba tiquina ni pisuriquiro ijiahye. Sa ye apequirore Matia wame tiriquirore beseahye. ");
INSERT INTO pirNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Tiquinare bese boca tuhasa, tiquina mari Pacʉre ohõ saha ni siniahye: —‍Mʉhʉ ʉsã pʉhto, ijipihtiyequina masa tiquina tʉhotuyere masine. Ahriquina pʉaro ʉsã beseriquina ijire. Juda mʉnanore camesatiquirore diquiro mʉhʉ cahmeniquirore beseya. Jesure cohãtjiano Juda mʉnano pehe pecapʉ wahahye. Tiquirore camesariquiro Jesu tiquiro cũriquiro ijirota. Sa yero ʉsã mehna quehnoañe buheyere buherota, niahye tiquina mari Pacʉre. ");
INSERT INTO pirNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Sa niñeta Juda mʉnanore camesatiquirore beseye tehe ʉtã paca mehna doque cũ mʉjahye “Noa pehe sajãnotari”, niñe. Matia tiquiro quehnoano wijiagʉ̃, tiquiro pehe Jesu cũriquina once cũriquina mehna cjʉ̃no tojoahye. ");
INSERT INTO pirNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Sa ye Pentecoste wame tiri deco ijigʉ̃ tiquina ijipihtiyequina ihcã wʉhʉpʉ cahmecoahye. ");
INSERT INTO pirNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ti pjereta wihnono tutuaro wẽno saha ʉhmʉanopʉ bisiro ca tahye. Sa bisiro ca tagʉ̃ tʉhoahye ijipihtiyequina ti wʉhʉpʉ ijiriquina. ");
INSERT INTO pirNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Sa ye peca pohna yero saha ijiye tiquina ijipihtiyequina dapu paca bui bajuahye. Ti peca pohnarigã ñehmeno yero saha bajuahye. ");
INSERT INTO pirNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Sa yero Espíritu Santo wihiahye tiquinare tiquiro tutuayere ohoro taro. Espíritu Santo tiquinare yedohoro puno tiquina pehe apequina ye mehna quehnoano yahuducuahye. ");
INSERT INTO pirNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ti decorire Jerusalẽpʉ peyequina judio masa ijiahye. Mari Pacʉre ño peoyequina ijiahye. Tiquina macaripe cjẽna ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Sa ye ʉhmʉsepʉ bisigʉ̃ tʉhoye Jesu buheyequina cahapʉ peyequina cahmecoahye. Masape ye yahuducuyere Jesu buheyequina tiquina yahuducugʉ̃ tʉhoahye. Sa tiquina yahuducugʉ̃ tʉhoye, tiquina tʉho maria wahahye. ");
INSERT INTO pirNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","8","—‍Ahyou, ¿Dʉhse yeye ahriquina Galilea cjẽna ijiepeta quehnoano mari yere yahuducuajari? Tiquina mari masa bajuariropʉ ahtariquina yero sahata yahuducuye ca tare, niahye tiquina pehe. ");
INSERT INTO pirNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","10","—‍Ijipihtiyequina mari yere yojopʉre yahuducuye nine: Partia cjãna, Media cjãna, Elã cjãna, Mesopotamia cjãna, Judea cjãna, Capadocia cjãna, Ponto cjãna, Asia cjãna, Frigia cjãna, Panfilia cjãna, Egipto cjãna, Libiapʉ ijiye macaripʉ Cirene cahapʉ ijina, Romapʉ ahtarina ijiaja mari. Ihquẽquina judio masa ijiaja mari. Apequina mari judio masa ijiena, judio masa ye buheyere buhenapʉ ijiaja mari. ");
INSERT INTO pirNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Creta cjẽna gʉ̃hʉ, Arabia cjẽna gʉ̃hʉ ijire mari mehna. Sa yena ahriquina mari yere tiquina yahuducugʉ̃ tʉhoaja mari. Tiquina mari ye mehna Cohãcjʉ̃ tutuaye mehna tiquiro yerire yahuye nine, ni yahuducuahye masa tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Sa niñeta tiquina tʉho acʉaa waha, tiquina ihñarire tiquina tʉhorire quehnoano masiedahye. —‍¿Ahri dʉhse ijiro boro ahriquina apequina ye mehna Cohãcjʉ̃ yere sa quehnoano yahuducuajari, mʉsa tʉhotugʉ̃? ni cahme sinituahye tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Tiquina sa ni tʉhotuepegʉ̃ta apequina tiquina mehna cjẽna bʉjʉpeahye: —‍¿Dʉhse ahriquina sihbiori sihni, queheye niajari? ni bʉjʉpeahye apequina tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Sa yero Pedro once Jesu cũriquina mehna ducu, masare yahuahye: —‍Mʉsa Judea yehpa cjãna, ijipihtina Jerusalẽpʉ ijina, ahrire masiña mʉsa. Yʉhʉ yahugʉ̃ tʉhoya mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Mʉsa tʉhotuye poto ijierare. Yojopʉta nueve hora ijire. Sa ye ahriquina queherare. ");
INSERT INTO pirNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ahriquina Cohãcjʉ̃ panopʉ tiquiro nidiro sahata yeye nine. Ti pjepʉre Joere Cohãcjʉ̃ yere yahu mʉhtariquirore, ahrire yahu dutiahye Cohãcjʉ̃ pehe: ");
INSERT INTO pirNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Iji bato tiye decori ijigʉ̃ ohõ saha ijirota: Yaquiro Espíriture masare ijipihtiyequinare ohogʉtja. Sa ye mʉsa pohnapʉ yeere yahueta. Sa ye mʉsa mehna cjẽna wahma pjia bajumehneñene ihñaeta. Sa ye mʉsa mehna cjẽna bʉcʉna quehẽnopʉ quehẽeta. ");
INSERT INTO pirNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Sa yegʉ yʉhʉ cahacjẽnare, yʉhʉ cahacjẽna numia gʉ̃hʉre yaquiro Espíriture ohogʉtja. Sa ye tiquina yahueta yeere. ");
INSERT INTO pirNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Sa yegʉ yʉhʉ tutuaye mehna bajumehneñene ye ihñogʉtja ʉhmʉanopʉ. Yehpapʉ gʉ̃hʉre yʉhʉ bajumehneñene ihñogʉtja: Diire, pecare, peca ohmeore ihñogʉtja. ");
INSERT INTO pirNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Sa yero asʉ̃ deco cjʉ̃no nahitiaa waharota. Ñami cjʉ̃no dii yero saha sohãriquiro camesarota. Ohõ saha waharota Cristo mʉsa pʉhtoro tiquiro ahtati deco, yʉhʉ nidi deco pano. Ti decopʉ ihña maria wahaeta masa. Sa yero ihyo ijiri deco ijisi. Ti deco quehnoari deco ijirota. ");
INSERT INTO pirNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Sa yero ohõ saha ijirota. Ijipihtiyequina masa Cristore tiquina ñañene cohã duti siniñequinare tiquiro tiquinare pecapʉ wahaboriquinare yʉhdʉorota, nine Cohãcjʉ̃, ni ojoahye Joel. ");
INSERT INTO pirNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Mʉsa Israe masa yʉhʉ yahugʉ̃ tʉhoya: Jesu Nazare cjʉ̃no pehe Cohãcjʉ̃ ohoriquiro ijiri. Jesure tiquiro ohorire masa tiquina masiato saha tiquiro tutuaye mehna ye ihñori mʉsare. Mʉsa tire masine. ");
INSERT INTO pirNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Jesure ohori mʉsare apequiro. Panopʉ Cohãcjʉ̃ “Sa waharota”, tiquiro nidiro sahata sa yeri apequiro. Sa yena mʉsa Jesure curusapʉ wejẽ dutiri masa ñañequinare. ");
INSERT INTO pirNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Cohãcjʉ̃ pehe Jesure yariariquiro mʉnanore masori. Pari turi ne yariasi tiquiro. Tiquiro yaria dojoerare. Sa catiducuatiquiro ijire. ");
INSERT INTO pirNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ohõ saha niahye Davi panopʉ cjʉ̃no Cristo tiquiro niboriro sahata: Yʉhʉ pʉhto, yʉhʉ mehna ijire mʉhʉ. Ijipihtiye decori Cohãcjʉ̃ yʉhʉ pʉhto yʉhʉ caha mʉhʉ ijigʉ̃ ihñae tii yʉhʉ cuerato saha. ");
INSERT INTO pirNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","27","Mʉhʉ Cohãcjʉ̃ yʉhʉ jeripohnare yariayequina tiquina ijiropʉre ne cohãsi. Yʉhʉre ñanopʉ yʉhʉ jeripohnare cohãsi mʉhʉ. Yʉhʉ mʉhʉ cahacjʉ̃ mʉhʉre ño peogʉ ijiaja. Yʉhʉ pagʉre ahba dutisi mʉhʉ. Sa yegʉ tutuaro bucueaja. Bucueye mehna yahuducuaja. Sa yegʉ mʉhʉre Cohãcjʉ̃re quehnoano wacũ tutuagʉ ijigʉ cuero marieno quehnoano iji cjã. ");
INSERT INTO pirNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Yʉhʉre pari turi catigʉ̃ yegʉta mʉhʉ. Yʉhʉ mehna mʉhʉ ijigʉ̃ tutuaro bucueaja, ni, ojoahye Davi mʉnano Cristo tiquiro niboriro sahata. ");
INSERT INTO pirNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Acaye, ohõ saha quehnoano yahugʉtja mʉsare Davire mari acayʉro, panopʉ cjʉ̃nore. Tiquiro yariaa wahahye. Sa yero tiquirore tiquina yari cope yojopʉre ijire. Sa yero “Yʉhʉ pagʉre ahba dutisi mʉhʉ”, ni ojoaro tiquiro basi wame peo yahuro niedahye. ");
INSERT INTO pirNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","31","Panopʉ Cohãcjʉ̃ Davi mʉnanore ohõ saha niahye: “Poto niita niaja. Mʉhʉ panamena iji turiayequina mehna cjʉ̃no mʉhʉ yero saha ahri yehpa cjẽna pʉhtoro ijirota”, niahye Cohãcjʉ̃ Davire. Davi Cohãcjʉ̃ yere yahu mʉhtariquiro ijiahye. Sa yero Cristore Cohãcjʉ̃ tiquiro pʉhtoro sõatire masino, Cristo tiquiro masa mʉjatire yahu mʉhta tuhasahye Davi pehe. Ohõ saha niahye: “Tiquiro yariayequina ijiropʉre iji dojoasi. Tiquiro pagʉ topʉ ahbasi”, niahye Davi. ");
INSERT INTO pirNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ahriquirore Jesure Cohãcjʉ̃ masori. Ʉsã ijipihtina ihñaʉ. ");
INSERT INTO pirNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Cristo mari Pacʉ poto pehepʉ ijire dutiriquiro ijiro. Sa yero tiquiro Pacʉro “Espíritu Santore yehpapʉ ohogʉtja”, niahye tiquirore. Sa yero Cristo pehe ahriquinare Espíritu Santore ohori. Yojopʉre Espíritu tiquiro yeyere mʉsa ihñana nine. Sa yena mʉsa tʉhore. ");
INSERT INTO pirNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Davi mʉnano pehe Jesu tiquiro mʉjariro sahata ʉhmʉsepʉ mʉjaedahye. Sa yero tiquiro basi ohõ saha niahye: Cohãcjʉ̃ nidi yʉhʉ pʉhtorore: “Yʉhʉ poto pehepʉ dujiya mʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Mʉhʉre ihña tuhtiyequinare mʉhʉre yʉhdʉdʉca basaʉtja yʉhʉ”, nidi Cohãcjʉ̃ yʉhʉ pʉhtorore, niahye Davi mʉnano. ");
INSERT INTO pirNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Sa yena ijipihtina Israe masa ahrire quehnoano masiña mʉsa: Ahriquiro Jesure mʉsa curusapʉ wejẽdiquirore mʉsa pʉhtoro sõri Cohãcjʉ̃ pehe. Tiquirore mʉsare yʉhdʉoatiquirore Cristore cũri Cohãcjʉ̃, ni yahuahye masare Pedro. ");
INSERT INTO pirNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Tiquiro sa nigʉ̃ tʉhoye tutuaro bʉjʉa witiye, cueye masa pehe Pedro gʉ̃hʉre sinituahye: —‍¿Ʉsã acaye, dʉhse yenatari ʉsã? ni sinituahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Tiquina sa ni sinitugʉ̃ yʉhtiahye Pedro gʉ̃hʉ: —‍Mʉsa ñañe yeyere bʉjʉa witina ijiya. Quehnoañe pehere camesaya. Sa yena Jesu wame mehna wame yenohrina ijiya mʉsa ijipihtina. Mʉsa sa yegʉ̃ mʉsa ñañene borota Cohãcjʉ̃. Mʉsa sa yegʉ̃ Espíritu Santo mʉsa mehna ijirota. Cohãcjʉ̃ yaquiro Espíritu Santore sa oho cãnota mʉsare. ");
INSERT INTO pirNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Mʉsare, mʉsa pohnare, mʉsa panamena iji turiayequinare, yoaropʉ cjẽnare, ijipihtiyequina Cohãcjʉ̃ mari pʉhtoro tiquiro beseriquinare, “Potota yʉhdʉogʉtja mʉsare”, ni, cũahye Cohãcjʉ̃, niahye Pedro. ");
INSERT INTO pirNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Sa ni tuhasa peye yahu nemoahye tiquiro. Sa yero tutuaro mehna yahuahye tiquinare: —‍Ahri yehpa cjẽnare tiquina ñano yeri buhirire buhiri dahrerota Cohãcjʉ̃. Sa yena mʉsa pehe Cohãcjʉ̃ yequina ijiya. Mʉsa sa ijigʉ̃ tiquiro mʉsare buhiri dahresi, niahye Pedro masare. ");
INSERT INTO pirNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Tiquiro sa nigʉ̃ tʉhoye peyequina tiquiro yahuducuyere quehnoano tʉhoahye. Sa yero tiquinare tiquiro wame yeahye. Sa ye Cohãcjʉ̃ yequina mehna cjẽna tres mil masa waha nemoahye. ");
INSERT INTO pirNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Sa ye tiquina masa Cristo cũriquina mehna decoripe ijie tiahye. Sa ye tiquina ti buheyere decoripe tʉhoe tiahye. Tiquina ihyayere cahme iti, Cohãcjʉ̃re sini, Cristo cũriquina mehna quehnoano ijie tiahye. ");
INSERT INTO pirNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Sa ye Cohãcjʉ̃ tutuaye mehna ye ihñoahye Jesu cũriquina. Tiquina sa yegʉ̃ ihñañe masa ijipihtiyequina ihña maria wahae tiahye. ");
INSERT INTO pirNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Sa ye ijipihtiyequina Jesure wacũ tutuayequina cahmecoa, quehnoano ijie tiahye. Sa ye tiquina yere cahme itie tiahye. ");
INSERT INTO pirNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Tiquina yere dua, ijipihtiyequinare apee boro marieñequinare tiquinape ohoe tiahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Sa ye decoripe tiquina Cohãcjʉ̃ wʉhʉpʉ cahmecoae tiahye. Ijipihtiyequina tiquina ye wʉhʉsepʉ bucueye mehna cahmecoa, ihyae tiahye. ");
INSERT INTO pirNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Tiquina sa cahmecoa, “Cohãcjʉ̃ quehnoariquiro ijire”, ni ño peoe tiahye. Sa ye apequina masa tiquinare cahme yʉhdʉe tiahye. Sa yero decoripe Cohãcjʉ̃ apequinare tiquiro yequina wahagʉ̃ yee tiahye. ");
INSERT INTO pirNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ñamicahapʉ tres ijigʉ̃ Cohãcjʉ̃ mehna yahuducuri pje ijigʉ̃ Pedro, Ñu mehna Cohãcjʉ̃ wʉhʉpʉ wahaye niahye. ");
INSERT INTO pirNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Decoripe ti wʉhʉ cjã sopecaha quehnoari sopecaha wame tiri sopecahapʉ apequina ihcãquiro masʉnore ne cãhta, duhu dapoe tiahye. Tiquiro masʉno pehe wahma masa bajuaropʉta tini masiedahye. Sa yero tiquiro ti sopecaha caha niñerure sini dujie tiahye ti wʉhʉpʉ sajãñequinare. ");
INSERT INTO pirNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Sa ye Pedro, Ñu mehna ti wʉhʉpʉ tiquina esadʉcagʉ̃ tini masieniquiro pehe tiquinare ihña, niñerure siniahye. ");
INSERT INTO pirNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Sa ye Pedro gʉ̃hʉ tiquirore ihña, Pedro pehe ohõ saha niahye: —‍Ʉsãre ihñaña mʉhʉ, niahye Pedro tiquirore. ");
INSERT INTO pirNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Tiquiro sa nigʉ̃ tʉhoro “Ahriquina mehenogã yʉhʉre niñerure ohoeta”, ni tʉhoturo ihñadoque ohõ, tʉhoahye tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Tiquiro sa ni tʉhotuepegʉ̃ta Pedro tiquirore ohõ saha ni yahuahye: —‍Niñerure cʉoeraja yʉhʉ. Cʉoerapeita, ahrire yeitja mʉhʉre. Jesucristo Nazare cjʉ̃no tiquiro tutuaye mehna tiniña mʉhʉ, niahye Pedro tini masieniquirore. ");
INSERT INTO pirNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Sa ninota tiquiro omocare poto pehe cjã omocare ñehe, tiquirore weje wahcõ docoahye. Ti pjeta tini masieniquirore tiquiro ñecari tutuaa wahahye. ");
INSERT INTO pirNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Tiquiro sa wahari bato tiquiro wahcãdʉca sa, waha dʉcahye. Sa yero tiquiro waha, uhpu maa, “Cohãcjʉ̃ quehnoariquiro ijire”, ni bucueahye. Sa bucuero tiquina mehna Cohãcjʉ̃ wʉhʉpʉ sajã wahahye. ");
INSERT INTO pirNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Tiquiro sa tinigʉ̃ “Cohãcjʉ̃ quehnoariquiro ijire”, tiquiro nigʉ̃ masa ijipihtiyequina tiquirore ihñahye. ");
INSERT INTO pirNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Sa ye masa tiquirore ihña masiahye. Tiquiro Cohãcjʉ̃ wʉhʉ cjã sopecaha quehnoari sopecaha caha niñerure tiquiro sini dujirire masiahye masa. Sa ye tiquiro tinigʉ̃ ihñañe, ihña maria wahahye. ");
INSERT INTO pirNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Sa ye tini masieniquiro Pedro gʉ̃hʉre tiquiro ñeheni watoa, masa ijipihtiyequina ihña maria waha, quehnoari paapʉ Salomo wame tiri paapʉ oma cã, cahmecoahye. ");
INSERT INTO pirNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Tiquina sa cahmecoari bato Pedro pehe yahuahye tiquinare: —‍¿Mʉsa Israe masa, dʉhse yena ahriquirore ihña mariajari? ¿Dʉhse yena ʉsãre mʉsa ihña nʉnʉajari? Ʉsã pehe ʉsã ye tutuaye mehna Cohãcjʉ̃re ʉsã wacũ tutuaye mehna ʉsã esa tuharo ahriquirore tinigʉ̃ yerʉ ʉsã. ");
INSERT INTO pirNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abrahã, Isaac, Jacob mari ñecʉsʉmʉa panopʉ cjẽna Cohãcjʉ̃re ño peoe tiahye. Tiquiro Cohãcjʉ̃ pehe tiquiro cahacjʉ̃nore Jesure tutuariquiro, quehnoariquiro tiquiro ijigʉ̃ mʉsare ihñoe tiri. Mʉsa Jesure tiquirore ihña tuhtiyequinare ohori. Sa yena Pilato tiquirore peresu wio duepegʉ̃ta mʉsa pehe tiquirore wiogʉ̃ cahmedari. Pilatore Jesure ohori mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Pilato tiquirore wio duamedi. Tiquiro sa wio duepegʉ̃ta mʉsa Jesure quehnoariquirore, quehnoano yeriquirore cahmedana, apequirore masa wejẽdiquiro pehere wio dutiri mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Sa yena Jesure marine catigʉ̃ yeriquirore wejẽdi mʉsa, ʉsã acaye judio masa. Tiquiro yariagʉ̃ Cohãcjʉ̃ tiquirore masori. Tire ʉsã ihñaʉ. ");
INSERT INTO pirNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Sa yena ʉsã tiquirore wacũ tutuana ijiaja. Ʉsã sa wacũ tutuagʉ̃ ihñano ahriquirore mʉsa yojopʉ ihñariquirore mʉsa ihña masiniquirore Jesu pehe tiquiro tutuaye mehna tinigʉ̃ yeri. ");
INSERT INTO pirNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Yʉhʉ acaye, mari pʉhtoa mehna Jesure quehnoano masiedapenata tiquirore wejẽdi mʉsa. Tire masiaja yʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Sa ye panopʉ cjẽna Cohãcjʉ̃ yere yahu mʉhtariquina Cohãcjʉ̃ tiquinare tiquiro yahu dutiriro sahata yahuahye tiquina. “Cristo ñano yʉhdʉrota”, ni yahuahye tiquina. Tiquina sa ni yahuriro sahata sa wahari yojopʉre. ");
INSERT INTO pirNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Sa yena yojopʉre mʉsa ñañe yerire bʉjʉa witina ijiya. Quehnoañe pehere camesaya. Cristore wacũ tutuaya. Sa yero mʉsa ñañe yerire borota Cohãcjʉ̃. Sa yero mʉsare bucueye decori cũnota tiquiro. Sa yena quehnoano jeri sajãnata. ");
INSERT INTO pirNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Sa yero Cohãcjʉ̃ Cristore tiquiro beseriquirore mʉsare ohorota. Cristo Jesuta ijire. ");
INSERT INTO pirNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Cohãcjʉ̃ cahapʉ iji nine Jesu. Panopʉ Cohãcjʉ̃ tiquiro yere yahu mʉhtariquinare yahuyu dutiahye. Masare ahri yehpa gʉ̃hʉre tiquiro yeatire yahuyu dutiahye. Sa yero tiquiro yahuriro sahata yojopʉre ijipihtiyere quehnono nine. Quehno tuhasaro pari turi Cristore ahri yehpapʉ ohorota. ");
INSERT INTO pirNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moise tire yahuro ohõ saha niahye: “Mari mehna cjʉ̃nore mari acayʉrore Cohãcjʉ̃ yere yahu mʉhtariquirore Cohãcjʉ̃ mari pʉhtoro ohorota mʉsare. Yʉhʉre tiquiro ohoriro saha ohorota tiquiro gʉ̃hʉre. Sa yena mʉsare tiquiro yahugʉ̃ tʉho pihti cãhña mʉsa. ");
INSERT INTO pirNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ohõ saha ijirota. Ijipihtiyequina tiquirore tʉhoerariquinare, tiquiro dutiyere yerariquinare tiquiro cohãnota. Cohãcjʉ̃ yequina mehna cjẽna ijisi tiquina”, niahye Moise. ");
INSERT INTO pirNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Ijipihtiyequina Cohãcjʉ̃ yere yahu mʉhtariquinape Samuel, tiquiro bato ijiyequina gʉ̃hʉ ahri decorire yahuahye. ");
INSERT INTO pirNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Mari ñecʉsʉmʉare panopʉ cjẽnare yahuahye Cohãcjʉ̃. Mari gʉ̃hʉre sa ni yahuro niahye. Abrahãre tiquiro nidiro sahata mari gʉ̃hʉre ni yahuro niahye. Ohõ saha ni yahuahye Cohãcjʉ̃ Abrahãre: “Ijipihtiri yehpa cjẽnare quehnoano yeitja. Ohõ saha tire yeitja: Camepʉ iji nʉnʉ tãriquiro mʉhʉ acayʉro pehe masare quehnoano ye basarota yʉhʉre”, niahye Cohãcjʉ̃ Abrahãre. ");
INSERT INTO pirNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Sa yero Cohãcjʉ̃ tiquiro macʉnore mari cahapʉ oho mʉhtari mari ñañe yeyere duhu dutiatiquirore. Sa yero marine tiquiro quehnoano yeri, niahye Pedro tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","3","Masa mehna tiquiro yahuducuri watoa pahia, Cohãcjʉ̃ wʉhʉre cohteyequina surara pʉhtoro, saduceo masa gʉ̃hʉ tiquinare tʉhoahye. Ohõ saha ni buheahye Pedro Ñu mehna masare: —‍Jesu tiquiro yariari bato masa mʉjaa wahari. Tiquiro sa masagʉ̃ ihñana mari gʉ̃hʉ came mari tiquiro yequina mari masa mʉjatire masiaja mari, ni yahuahye Pedro gʉ̃hʉ. Tiquina sa nigʉ̃ tʉhoye pʉhtoa pehe tiquina mehna usuahye. Sa usuaye nahi quehagʉ̃ ihñañe tiquina Pedrore, apequina Jesu cũriquina gʉ̃hʉre ñehe, peresu yeahye. ");
INSERT INTO pirNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pʉhtoa tiquina sa cahmedapegʉ̃ta peyequina Cohãcjʉ̃ yere tʉhoyequina pehe “Ijirota ijire”, ni tʉhotuahye. Sa ye Jesu yequina peyequina sajãhye. Tiquinare ʉmʉa sehsarore mari queogʉ̃ Jesure wacũ tutuayequina cinco mil masa ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Sa ye ape decopʉ ti maca cjẽna pʉhtoa, bʉcʉna, judio masa buheyequina mehna Jerusalẽpʉ cahmecoahye. ");
INSERT INTO pirNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Sa yero pahia pʉhtoro, Anás wame tiriquiro topʉ ijiahye. Tiquiro acaye gʉ̃hʉ ijiahye. Caifa, Ñu, Alejandro, apequina mehna Anás acaye gʉ̃hʉ ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Sa ye tiquina Pedro gʉ̃hʉre tiquina cahmedoqueogʉ̃, surara pehe pʉhtoa watoapʉ tiquinare ne wihi docoahye. Tiquina sa yeri bato pʉhtoa sinituahye Pedro gʉ̃hʉre: —‍¿Noa ye tutuaye mehna mʉsa tiquirore tinigʉ̃ yeari? ¿Noa ijiajari mʉsare tire ye dutiriquiro? ni, sinituahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Tiquina sa nigʉ̃ tʉhoro Espíritu Santo tutuaye mehna yahuahye Pedro tiquinare: ");
INSERT INTO pirNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","—‍¿Mʉsa pʉhtoa, mʉsa bʉcʉna, ʉsã tini masieniquirore quehnoa wahagʉ̃ ʉsã yerire sinituna niajari mʉsa? ");
INSERT INTO pirNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ahrire masiña mʉsa ijipihtina, Israe masa. Ahrire Jesucristo sa yeri. Jesu Nazare cjʉ̃no, mʉsa curusapʉ wejẽdiquiro, Cohãcjʉ̃ tiquiro masoriquiro pehe ahriquiro tini masieniquirore quehnoa wahagʉ̃ yeri. Sa yena ahriquirore yojopʉre mʉsa ihñonopʉ tiquiro tinigʉ̃ ihñare mʉsa. Ohõ saha nine Cohãcjʉ̃ yere tiquina ojoari pũpʉ Cristore yahuro: ");
INSERT INTO pirNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","“Ahriquiro ʉtã yero saha ijiriquiro ijire. Ʉtãre wʉhʉ dahreatiquina tiquina cohãno saha masa tiquirore cohãri. Tiquina sa yepegʉ̃ta yojopʉre wʉhʉ dahreriquina wʉhʉre yeye tiquina cũ mʉhtari ʉtãre tiquina cũno saha Cohãcjʉ̃ tiquirore pʉhtoro sõri. Tiquiro Cristo pehe mariedagʉ̃ Cohãcjʉ̃ yequina wahaeraboaya masa. Tiquiro sa ihyo ijiriquiro ijierapegʉ̃ta mʉsa mari pʉhtoa mehna tiquirore cahmedari. Mʉsa sa cahmedapegʉ̃ta Cohãcjʉ̃ pehe tiquirore mari pʉhtoro sõri”, ni ojoahye panopʉre. ");
INSERT INTO pirNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ne, apequiro masare pecapʉ wahaboriquinare yʉhdʉoriquiro ne mariedare. Ahri yehpapʉre Jesu dihita masare yʉhdʉoriquiro ijire. Ne apequina tiquiro yero saha ijiyequina ne mariedare, ni yahuahye Pedro tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Tiquiro sa ni yahuri bato Pedro, Ñu mehna buhemehneñequina tiquina ijigʉ̃ ihñañe, cuero marieno tiquina buhegʉ̃ ihñañe, pʉhtoa, bʉcʉna, judio masa buheyequina mehna tʉho maria wahahye. Sa ye Jesu yero saha tiquina buhegʉ̃ ihñañe, ohõ saha masiahye tiquina: “Pedro, Ñu gʉ̃hʉ potota Jesu mehna cjẽna ijire ahriquina”, ni, masiahye tiquina. ");
INSERT INTO pirNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Sa yero tini masieniquiro ijimediquiro Pedro gʉ̃hʉ mehna ijiahye. Tiquiro quehnoariquiro ijigʉ̃ ihñahye pʉhtoa, bʉcʉna, judio masa buheyequina mehna. Sa ye tiquina Pedro gʉ̃hʉre “Ñano yeye nine”, ni yahusã masiedahye. ");
INSERT INTO pirNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Sa yahusã masiedaye, pʉhtoa tiquina cahmecoari tucũpʉ ijiyequinare Pedro gʉ̃hʉre wijia dutiahye. ");
INSERT INTO pirNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Tiquina wijiari bato tiquina basi ohõ saha ni yahuducuahye: —‍¿Ahriquinare dʉhse yenatari mari? ni, yahuducuahye tiquina. Ohõ saha ni yahuducu nemoahye: —‍Pedro, Ñu mehna Cohãcjʉ̃ tutuaye mehna tini masieniquirore tinigʉ̃ yeri jiri. Sa ye Jerusalẽ cjẽna ijipihtiyequina tiquina sa yerire masidi. Sa yena mari pehe “Sa yerari tiquina”, ni masiedaja mari. ");
INSERT INTO pirNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Sa yena Jesu tiquiro buherire apequinare buhe dutieracʉ̃hna tiquinare, “Apequina ti buheyere cahmeari”, nina, ni yahuducuahye tiquina basi. ");
INSERT INTO pirNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Sa ni yahuducu tuhasa Pedro gʉ̃hʉre pijio, ohõ saha niahye: —‍Jesu tiquiro buherire ne buheracãhña apequinare. Tire ne yahuducueracãhña, nimahye tiquinare. ");
INSERT INTO pirNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Tiquina sa nigʉ̃ tʉhoye Pedro, Ñu mehna ohõ saha niahye tiquinare: —‍Mʉsa ohõ saha nigʉ̃ mʉsare yʉhtina, Cohãcjʉ̃ pehere yʉhdʉdʉcana niboaga ʉsã. ¿Noa pehere ʉsã yʉhtigʉ̃ cahmeajari mʉsa? ¿Mʉsa pehere ʉsã yʉhtigʉ̃ cahmeajari mʉsa? ¿O Cohãcjʉ̃ pehere ʉsã yʉhtigʉ̃ cahmedajari mʉsa? ");
INSERT INTO pirNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ʉsã pehere ʉsã ihñarire, ʉsã tʉhorire ʉsãre nʉono basioerare, ni yʉhtiahye Pedro, Ñu mehna. ");
INSERT INTO pirNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Tiquina sa nigʉ̃ tʉhoye pʉhtoa pehe pari turi dutimahye tiquinare tja: —‍Jesu tiquiro buherire mʉsa buheri buhiri ñano yʉhdʉnata mʉsa, nimahye pʉhtoa tiquinare. “Ñu, Pedro mehna ñano yeye nine”, ni masiedari jiri tiquina. Sa ye masa pehe tini masieniquiro tiquiro yʉhdʉgʉ̃ ihñañe, “Cohãcjʉ̃ potota quehnoariquiro ijire”, niahye masa. Tiquina sa nigʉ̃ tʉhoye pʉhtoa pehe Pedro gʉ̃hʉre buhiri dahre masieda, tiquinare wioahye. ");
INSERT INTO pirNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Tini masieniquiro, tiquina yʉhdʉoriquiro cuarenta cʉhmari cʉoriquiro ijiahye. ");
INSERT INTO pirNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Sa ye Pedro, Ñu mehna tiquina mehna cjẽna cahapʉ esa, pahia pʉhtoa, bʉcʉna tiquinare tiquina nidire yahuahye. ");
INSERT INTO pirNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Tiquina sa nigʉ̃ tʉhoye tiquina ijipihtiyequina mari Pacʉre Cohãcjʉ̃re siniahye: —‍Ʉsã pʉhto, mʉhʉ ʉhmʉsere, yehpare, mári gʉ̃hʉre yerigʉ, ijipihtiyequina catiyequinare yerigʉ ijire mʉhʉ. ");
INSERT INTO pirNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Mʉhʉ yaquiro Espíritu Santo ʉsã ñecʉ mʉnano Davire mʉhʉ cahacjʉ̃nore ahrire yahu dutiahye mʉhʉ nidiro sahata: ¿Dʉhse ye Israe masa ijieyequina usuajari? Tʉho masieñequina ijire masa. ");
INSERT INTO pirNT_vpl VALUES ("AC4_26","074